
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  171 ( 1423),  selected  171 , name 2nn5_A
# Molecule2: number of CA atoms  101 ( 1588),  selected  101 , name T0482_7_107.pdb
# PARAMETERS: 2nn5_A.T0482_7_107.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G   -10_A      P     7_A           -
LGA    T    -9_A      G     8_A           -
LGA    E    -8_A      H     9_A           -
LGA    N    -7_A      -       -           -
LGA    L    -6_A      -       -           -
LGA    Y    -5_A      -       -           -
LGA    F    -4_A      -       -           -
LGA    Q    -3_A      L    10_A           #
LGA    -       -      H    11_A           -
LGA    S    -2_A      L    12_A          2.028
LGA    -       -      V    13_A           -
LGA    -       -      S    14_A           -
LGA    -       -      L    15_A           -
LGA    -       -      P    16_A           -
LGA    -       -      G    17_A           -
LGA    -       -      L    18_A           -
LGA    -       -      D    19_A           -
LGA    -       -      Q    20_A           -
LGA    -       -      Q    21_A           -
LGA    -       -      D    22_A           -
LGA    -       -      I    23_A           -
LGA    N    -1_A      N    24_A          4.706
LGA    A     0_A      I    25_A           #
LGA    X     1_A      -       -           -
LGA    K     2_A      H    26_A          2.743
LGA    D     3_A      I    27_A          1.991
LGA    T     4_A      R    28_A          1.542
LGA    F     5_A      Y    29_A          1.725
LGA    R     6_A      E    30_A          1.769
LGA    L     7_A      V    31_A          1.879
LGA    E     8_A      R    32_A          2.188
LGA    N     9_A      Q    33_A          2.186
LGA    -       -      N    34_A           -
LGA    -       -      A    35_A           -
LGA    -       -      E    36_A           -
LGA    -       -      S    37_A           -
LGA    -       -      G    38_A           -
LGA    Q    10_A      A    39_A          0.815
LGA    T    11_A      Y    40_A          1.592
LGA    I    12_A      V    41_A          1.450
LGA    Y    13_A      H    42_A          1.105
LGA    F    14_A      F    43_A          1.393
LGA    G    15_A      D    44_A          1.504
LGA    T    16_A      M    45_A          1.888
LGA    E    17_A      D    46_A          1.703
LGA    R    18_A      G    47_A          3.261
LGA    A    19_A      E    48_A          1.496
LGA    I    20_A      I    49_A          1.961
LGA    S    21_A      D    50_A          2.992
LGA    A    22_A      G    51_A          4.595
LGA    S    23_A      K    52_A          4.956
LGA    P    24_A      -       -           -
LGA    Q    25_A      -       -           -
LGA    T    26_A      -       -           -
LGA    I    27_A      -       -           -
LGA    W    28_A      -       -           -
LGA    R    29_A      -       -           -
LGA    Y    30_A      -       -           -
LGA    L    31_A      -       -           -
LGA    T    32_A      -       -           -
LGA    E    33_A      -       -           -
LGA    T    34_A      -       -           -
LGA    D    35_A      -       -           -
LGA    K    36_A      -       -           -
LGA    L    37_A      -       -           -
LGA    K    38_A      -       -           -
LGA    Q    39_A      -       -           -
LGA    W    40_A      -       -           -
LGA    F    41_A      -       -           -
LGA    P    42_A      -       -           -
LGA    E    43_A      -       -           -
LGA    L    44_A      -       -           -
LGA    E    45_A      -       -           -
LGA    I    46_A      -       -           -
LGA    G    47_A      -       -           -
LGA    E    48_A      -       -           -
LGA    L    49_A      -       -           -
LGA    G    50_A      -       -           -
LGA    V    51_A      -       -           -
LGA    N    52_A      -       -           -
LGA    G    53_A      -       -           -
LGA    F    54_A      -       -           -
LGA    W    55_A      -       -           -
LGA    R    56_A      -       -           -
LGA    F    57_A      -       -           -
LGA    I    58_A      -       -           -
LGA    L    59_A      -       -           -
LGA    P    60_A      -       -           -
LGA    D    61_A      -       -           -
LGA    F    62_A      -       -           -
LGA    E    63_A      -       -           -
LGA    E    64_A      -       -           -
LGA    T    65_A      -       -           -
LGA    X    66_A      -       -           -
LGA    P    67_A      -       -           -
LGA    F    68_A      -       -           -
LGA    T    69_A      -       -           -
LGA    D    70_A      -       -           -
LGA    Y    71_A      -       -           -
LGA    A    72_A      -       -           -
LGA    E    73_A      -       -           -
LGA    E    74_A      -       -           -
LGA    K    75_A      -       -           -
LGA    Y    76_A      -       -           -
LGA    L    77_A      -       -           -
LGA    G    78_A      -       -           -
LGA    V    79_A      -       -           -
LGA    T    80_A      -       -           -
LGA    W    81_A      -       -           -
LGA    D    82_A      -       -           -
LGA    T    83_A      -       -           -
LGA    G    84_A      -       -           -
LGA    I    85_A      -       -           -
LGA    I    86_A      -       -           -
LGA    Y    87_A      -       -           -
LGA    F    88_A      -       -           -
LGA    D    89_A      -       -           -
LGA    L    90_A      -       -           -
LGA    K    91_A      -       -           -
LGA    E    92_A      -       -           -
LGA    Q    93_A      -       -           -
LGA    A    94_A      -       -           -
LGA    P    95_A      -       -           -
LGA    H    96_A      -       -           -
LGA    Q    97_A      -       -           -
LGA    T    98_A      -       -           -
LGA    L    99_A      P    53_A          2.614
LGA    L   100_A      F    54_A          1.275
LGA    V   101_A      S    55_A          1.750
LGA    F   102_A      D    56_A          1.930
LGA    S   103_A      S    57_A          1.340
LGA    E   104_A      F    58_A          1.340
LGA    S   105_A      E    59_A          1.382
LGA    L   106_A      L    60_A          1.135
LGA    P   107_A      P    61_A          1.580
LGA    E   108_A      R    62_A          2.822
LGA    N   109_A      D    63_A          3.851
LGA    F   110_A      T    64_A          3.364
LGA    T   111_A      -       -           -
LGA    T   112_A      -       -           -
LGA    P   113_A      -       -           -
LGA    R   114_A      A    65_A          2.041
LGA    H   115_A      F    66_A          2.197
LGA    K   116_A      N    67_A          2.797
LGA    D   117_A      F    68_A          2.873
LGA    I   118_A      -       -           -
LGA    A   119_A      A    69_A          0.831
LGA    G   120_A      S    70_A          1.425
LGA    W   121_A      D    71_A          2.398
LGA    S   122_A      A    72_A          2.817
LGA    I   123_A      T    73_A          2.010
LGA    V   124_A      R    74_A          2.255
LGA    L   125_A      V    75_A          3.166
LGA    N   126_A      A    76_A          3.280
LGA    R   127_A      Q    77_A          1.902
LGA    L   128_A      K    78_A          2.667
LGA    K   129_A      H    79_A          3.507
LGA    Q   130_A      G    80_A          2.903
LGA    V   131_A      -       -           -
LGA    V   132_A      -       -           -
LGA    E   133_A      -       -           -
LGA    T   134_A      -       -           -
LGA    P   135_A      -       -           -
LGA    D   136_A      -       -           -
LGA    A   137_A      -       -           -
LGA    A   138_A      -       -           -
LGA    P   139_A      L    81_A           #
LGA    -       -      H    82_A           -
LGA    -       -      P    83_A           -
LGA    E   140_A      K    84_A          2.706
LGA    -       -      F    85_A           -
LGA    K   141_A      G    86_A          3.255
LGA    I   142_A      A    87_A          4.504
LGA    -       -      I    88_A           -
LGA    -       -      T    89_A           -
LGA    D   143_A      R    90_A          1.987
LGA    F   144_A      V    91_A          3.148
LGA    P   145_A      H    92_A          4.229
LGA    Q   146_A      K    93_A          2.613
LGA    I   147_A      E    94_A           #
LGA    E   148_A      Y    95_A          3.545
LGA    N   149_A      D    96_A          2.467
LGA    H   150_A      A    97_A          4.732
LGA    Y   151_A      M    98_A          3.476
LGA    L   152_A      F    99_A          0.829
LGA    E   153_A      E   100_A          3.656
LGA    K   154_A      D   101_A          3.952
LGA    L   155_A      I   102_A          1.203
LGA    T   156_A      R   103_A          2.947
LGA    N   157_A      A   104_A          4.599
LGA    L   158_A      K   105_A          1.783
LGA    E   159_A      L   106_A          3.498
LGA    N   160_A      H   107_A          4.647

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  171  101    5.0     72    2.73    11.11     46.759     2.543

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.470939 * X  +   0.812178 * Y  +  -0.344360 * Z  +  -3.070339
  Y_new =   0.660097 * X  +   0.065470 * Y  +  -0.748322 * Z  +   2.405915
  Z_new =  -0.585225 * X  +  -0.579725 * Y  +  -0.566949 * Z  +  31.986902 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.345053    0.796539  [ DEG:  -134.3616     45.6384 ]
  Theta =   0.625157    2.516435  [ DEG:    35.8189    144.1811 ]
  Phi   =   2.190485   -0.951108  [ DEG:   125.5055    -54.4945 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2nn5_A                                        
REMARK     2: T0482_7_107.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2nn5_A.T0482_7_107.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  171  101   5.0   72   2.73   11.11  46.759
REMARK  ---------------------------------------------------------- 
MOLECULE 2nn5_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   23-OCT-06   2NN5              
TITLE     STRUCTURE OF CONSERVED PROTEIN OF UNKNOWN FUNCTION EF2215             
TITLE    2 FROM ENTEROCOCCUS FAECALIS                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN EF_2215;                              
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ENTEROCOCCUS FAECALIS;                          
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: V583;                                                        
SOURCE   5 GENE: EF_2215;                                                       
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    STRUCTURAL GENOMICS, APC29336, HYPOTHETICAL PROTEIN, PSI-2,           
KEYWDS   2 PROTEIN STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL          
KEYWDS   3 GENOMICS, MCSG                                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.OSIPIUK,R.WU,S.MOY,A.JOACHIMIAK,MIDWEST CENTER FOR                  
AUTHOR   2 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   1   21-NOV-06 2NN5    0                                                
JRNL        AUTH   J.OSIPIUK,R.WU,S.MOY,A.JOACHIMIAK                            
JRNL        TITL   X-RAY CRYSTAL STRUCTURE OF CONSERVED HYPOTHETICAL            
JRNL        TITL 2 PROTEIN EF_2215 FROM ENTEROCOCCUS FAECALIS.                  
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.45 ANGSTROMS.                                          
DBREF  2NN5 A    1   160  UNP    Q832L1   Q832L1_ENTFA     1    160             
SEQRES   1 A  184  MSE HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 A  184  GLY THR GLU ASN LEU TYR PHE GLN SER ASN ALA MSE LYS          
SEQRES   3 A  184  ASP THR PHE ARG LEU GLU ASN GLN THR ILE TYR PHE GLY          
SEQRES   4 A  184  THR GLU ARG ALA ILE SER ALA SER PRO GLN THR ILE TRP          
SEQRES   5 A  184  ARG TYR LEU THR GLU THR ASP LYS LEU LYS GLN TRP PHE          
SEQRES   6 A  184  PRO GLU LEU GLU ILE GLY GLU LEU GLY VAL ASN GLY PHE          
SEQRES   7 A  184  TRP ARG PHE ILE LEU PRO ASP PHE GLU GLU THR MSE PRO          
SEQRES   8 A  184  PHE THR ASP TYR ALA GLU GLU LYS TYR LEU GLY VAL THR          
SEQRES   9 A  184  TRP ASP THR GLY ILE ILE TYR PHE ASP LEU LYS GLU GLN          
SEQRES  10 A  184  ALA PRO HIS GLN THR LEU LEU VAL PHE SER GLU SER LEU          
SEQRES  11 A  184  PRO GLU ASN PHE THR THR PRO ARG HIS LYS ASP ILE ALA          
SEQRES  12 A  184  GLY TRP SER ILE VAL LEU ASN ARG LEU LYS GLN VAL VAL          
SEQRES  13 A  184  GLU THR PRO ASP ALA ALA PRO GLU LYS ILE ASP PHE PRO          
SEQRES  14 A  184  GLN ILE GLU ASN HIS TYR LEU GLU LYS LEU THR ASN LEU          
SEQRES  15 A  184  GLU ASN                                                      
HET    MSE  A   1      13                                                       
HET    MSE  A  66      13                                                       
HET     MG  A 303       1                                                       
HET     MG  A 304       1                                                       
HET    EDO    301       4                                                       
HET    EDO    302       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      MG MAGNESIUM ION                                                    
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    2(C5 H11 N O2 SE)                                            
FORMUL   2   MG    2(MG 2+)                                                     
FORMUL   4  EDO    2(C2 H6 O2)                                                  
FORMUL   6  HOH   *231(H2 O)                                                    
CRYST1   58.227   69.030   86.766  90.00  90.00  90.00 I 2 2 2       8          
ATOM      1  N   GLY A -10     -10.560   6.179 -21.090  0.80 28.08           N  
ATOM      2  CA  GLY A -10     -10.369   4.951 -20.273  0.80 25.07           C  
ATOM      3  C   GLY A -10     -10.742   5.221 -18.826  0.80 24.94           C  
ATOM      4  O   GLY A -10     -10.725   6.371 -18.341  0.80 26.05           O  
ATOM      5  N   THR A  -9     -11.087   4.159 -18.115  1.00 22.71           N  
ATOM      6  CA  THR A  -9     -11.518   4.317 -16.711  1.00 19.86           C  
ATOM      7  C   THR A  -9     -10.449   3.789 -15.748  1.00 17.17           C  
ATOM      8  O   THR A  -9     -10.686   3.651 -14.580  1.00 16.29           O  
ATOM      9  CB  THR A  -9     -12.813   3.585 -16.542  1.00 20.58           C  
ATOM     10  OG1 THR A  -9     -12.603   2.228 -17.006  1.00 23.78           O  
ATOM     11  CG2 THR A  -9     -13.918   4.318 -17.411  1.00 20.08           C  
ATOM     12  N   GLU A  -8      -9.256   3.532 -16.253  1.00 16.31           N  
ATOM     13  CA  GLU A  -8      -8.274   2.834 -15.433  1.00 14.90           C  
ATOM     14  C   GLU A  -8      -7.840   3.668 -14.262  1.00 14.92           C  
ATOM     15  O   GLU A  -8      -7.633   3.133 -13.159  1.00 14.85           O  
ATOM     16  CB  GLU A  -8      -7.011   2.503 -16.231  1.00 16.29           C  
ATOM     17  CG  GLU A  -8      -7.104   1.212 -17.048  1.00 20.52           C  
ATOM     18  CD  GLU A  -8      -7.702   1.369 -18.435  1.00 22.99           C  
ATOM     19  OE1 GLU A  -8      -8.205   2.462 -18.809  1.00 23.41           O  
ATOM     20  OE2 GLU A  -8      -7.657   0.345 -19.194  1.00 24.94           O  
ATOM     21  N   ASN A  -7      -7.638   4.963 -14.505  1.00 13.92           N  
ATOM     22  CA  ASN A  -7      -7.185   5.831 -13.410  1.00 13.65           C  
ATOM     23  C   ASN A  -7      -8.261   5.879 -12.323  1.00 14.11           C  
ATOM     24  O   ASN A  -7      -7.950   5.741 -11.142  1.00 13.68           O  
ATOM     25  CB  ASN A  -7      -6.952   7.260 -13.934  1.00 13.75           C  
ATOM     26  CG  ASN A  -7      -6.577   8.220 -12.848  1.00 14.57           C  
ATOM     27  OD1 ASN A  -7      -5.612   7.986 -12.115  1.00 15.71           O  
ATOM     28  ND2 ASN A  -7      -7.394   9.290 -12.691  1.00 15.73           N  
ATOM     29  N   LEU A  -6      -9.518   6.067 -12.709  1.00 12.62           N  
ATOM     30  CA  LEU A  -6     -10.560   6.214 -11.701  1.00 13.50           C  
ATOM     31  C   LEU A  -6     -10.737   4.893 -10.947  1.00 12.73           C  
ATOM     32  O   LEU A  -6     -10.943   4.884  -9.738  1.00 13.30           O  
ATOM     33  CB  LEU A  -6     -11.887   6.651 -12.318  1.00 13.69           C  
ATOM     34  CG  LEU A  -6     -11.903   8.167 -12.667  1.00 15.66           C  
ATOM     35  CD1 LEU A  -6     -13.162   8.394 -13.505  1.00 18.19           C  
ATOM     36  CD2 LEU A  -6     -11.939   8.999 -11.404  1.00 16.45           C  
ATOM     37  N   TYR A  -5     -10.664   3.772 -11.665  1.00 13.32           N  
ATOM     38  CA  TYR A  -5     -10.807   2.469 -11.005  1.00 13.82           C  
ATOM     39  C   TYR A  -5      -9.669   2.264  -9.998  1.00 13.13           C  
ATOM     40  O   TYR A  -5      -9.880   1.807  -8.876  1.00 13.52           O  
ATOM     41  CB  TYR A  -5     -10.787   1.360 -12.065  1.00 15.19           C  
ATOM     42  CG  TYR A  -5     -11.097  -0.016 -11.528  1.00 16.84           C  
ATOM     43  CD1 TYR A  -5     -10.115  -0.999 -11.465  1.00 13.88           C  
ATOM     44  CD2 TYR A  -5     -12.370  -0.343 -11.067  1.00 17.58           C  
ATOM     45  CE1 TYR A  -5     -10.408  -2.309 -10.987  1.00 15.16           C  
ATOM     46  CE2 TYR A  -5     -12.673  -1.615 -10.552  1.00 20.17           C  
ATOM     47  CZ  TYR A  -5     -11.676  -2.572 -10.488  1.00 16.62           C  
ATOM     48  OH  TYR A  -5     -12.028  -3.845  -9.983  1.00 20.07           O  
ATOM     49  N   PHE A  -4      -8.449   2.617 -10.383  1.00 13.04           N  
ATOM     50  CA  PHE A  -4      -7.347   2.517  -9.438  1.00 12.90           C  
ATOM     51  C   PHE A  -4      -7.563   3.403  -8.203  1.00 13.60           C  
ATOM     52  O   PHE A  -4      -7.414   2.943  -7.066  1.00 15.07           O  
ATOM     53  CB  PHE A  -4      -6.029   2.920 -10.105  1.00 15.52           C  
ATOM     54  CG  PHE A  -4      -4.906   2.700  -9.224  1.00 17.53           C  
ATOM     55  CD1 PHE A  -4      -4.312   1.423  -9.172  1.00 20.95           C  
ATOM     56  CD2 PHE A  -4      -4.546   3.651  -8.334  1.00 18.88           C  
ATOM     57  CE1 PHE A  -4      -3.322   1.131  -8.254  1.00 24.29           C  
ATOM     58  CE2 PHE A  -4      -3.499   3.371  -7.375  1.00 20.17           C  
ATOM     59  CZ  PHE A  -4      -2.913   2.123  -7.363  1.00 21.36           C  
ATOM     60  N   GLN A  -3      -7.910   4.684  -8.419  1.00 12.98           N  
ATOM     61  CA  GLN A  -3      -8.132   5.591  -7.295  0.50 13.53           C  
ATOM     63  C   GLN A  -3      -9.227   5.071  -6.380  1.00 12.96           C  
ATOM     64  O   GLN A  -3      -9.118   5.184  -5.168  1.00 14.30           O  
ATOM     65  CB  GLN A  -3      -8.509   7.000  -7.771  0.50 13.70           C  
ATOM     67  CG  GLN A  -3      -7.528   7.648  -8.764  0.50 15.21           C  
ATOM     69  CD  GLN A  -3      -6.222   8.010  -8.156  0.50 12.55           C  
ATOM     71  OE1 GLN A  -3      -6.154   8.322  -6.968  0.50 12.25           O  
ATOM     73  NE2 GLN A  -3      -5.163   8.058  -8.989  0.50 14.11           N  
ATOM     75  N   SER A  -2     -10.265   4.487  -6.964  1.00 12.58           N  
ATOM     76  CA  SER A  -2     -11.448   4.083  -6.189  0.50 14.33           C  
ATOM     78  C   SER A  -2     -11.067   2.939  -5.269  1.00 15.78           C  
ATOM     79  O   SER A  -2     -11.643   2.784  -4.184  1.00 18.65           O  
ATOM     80  CB  SER A  -2     -12.598   3.618  -7.104  0.50 15.09           C  
ATOM     82  OG  SER A  -2     -13.089   4.673  -7.908  0.50 16.41           O  
ATOM     84  N   ASN A  -1     -10.116   2.124  -5.729  1.00 15.79           N  
ATOM     85  CA  ASN A  -1      -9.672   0.998  -4.916  1.00 18.73           C  
ATOM     86  C   ASN A  -1      -8.505   1.346  -4.020  1.00 19.55           C  
ATOM     87  O   ASN A  -1      -8.160   0.542  -3.156  1.00 22.43           O  
ATOM     88  CB  ASN A  -1      -9.359  -0.195  -5.804  1.00 18.87           C  
ATOM     89  CG  ASN A  -1     -10.596  -0.778  -6.411  1.00 20.84           C  
ATOM     90  OD1 ASN A  -1     -11.459  -1.317  -5.708  1.00 23.44           O  
ATOM     91  ND2 ASN A  -1     -10.721  -0.674  -7.726  1.00 25.61           N  
ATOM     92  N   ALA A   0      -7.882   2.515  -4.185  1.00 20.72           N  
ATOM     93  CA  ALA A   0      -6.813   2.985  -3.250  1.00 20.68           C  
ATOM     94  C   ALA A   0      -7.328   3.799  -2.068  1.00 20.46           C  
ATOM     95  O   ALA A   0      -6.520   4.238  -1.219  1.00 21.23           O  
ATOM     96  CB  ALA A   0      -5.726   3.839  -4.008  1.00 22.26           C  
HETATM   97  N   MSE A   1      -8.640   4.005  -2.008  1.00 19.47           N  
HETATM   98  CA  MSE A   1      -9.316   4.909  -1.056  0.60 18.93           C  
HETATM  100  C   MSE A   1      -8.951   4.594   0.391  1.00 19.18           C  
HETATM  101  O   MSE A   1      -8.953   5.471   1.244  1.00 20.86           O  
HETATM  102  CB  MSE A   1     -10.876   4.839  -1.205  0.60 18.36           C  
HETATM  104  CG  MSE A   1     -11.426   5.508  -2.416  0.60 21.02           C  
HETATM  106 SE   MSE A   1     -13.308   5.060  -2.747  0.36 18.62          SE  
HETATM  108  CE  MSE A   1     -13.805   4.239  -1.052  0.60 23.16           C  
ATOM    110  N   LYS A   2      -8.738   3.320   0.708  1.00 17.39           N  
ATOM    111  CA  LYS A   2      -8.494   2.989   2.115  0.50 17.11           C  
ATOM    113  C   LYS A   2      -7.087   2.440   2.332  1.00 16.64           C  
ATOM    114  O   LYS A   2      -6.818   1.762   3.309  1.00 17.99           O  
ATOM    115  CB  LYS A   2      -9.580   2.063   2.683  0.50 20.11           C  
ATOM    117  CG  LYS A   2     -11.033   2.613   2.456  0.50 18.48           C  
ATOM    119  CD  LYS A   2     -12.141   1.956   3.260  0.50 23.31           C  
ATOM    121  CE  LYS A   2     -13.500   2.610   2.907  0.50 14.94           C  
ATOM    123  NZ  LYS A   2     -14.712   1.880   3.424  0.50 29.47           N  
ATOM    125  N   ASP A   3      -6.174   2.775   1.439  1.00 14.73           N  
ATOM    126  CA  ASP A   3      -4.770   2.418   1.720  1.00 13.95           C  
ATOM    127  C   ASP A   3      -4.316   3.041   3.029  1.00 12.99           C  
ATOM    128  O   ASP A   3      -4.581   4.239   3.289  1.00 15.40           O  
ATOM    129  CB  ASP A   3      -3.817   2.920   0.643  1.00 13.15           C  
ATOM    130  CG  ASP A   3      -3.974   2.197  -0.702  1.00 12.62           C  
ATOM    131  OD1 ASP A   3      -4.700   1.178  -0.821  1.00 13.37           O  
ATOM    132  OD2 ASP A   3      -3.271   2.594  -1.659  1.00 13.99           O  
ATOM    133  N   THR A   4      -3.556   2.251   3.812  1.00 12.14           N  
ATOM    134  CA  THR A   4      -3.031   2.703   5.074  0.60 12.95           C  
ATOM    136  C   THR A   4      -1.550   2.260   5.178  1.00 12.43           C  
ATOM    137  O   THR A   4      -1.192   1.194   4.664  1.00 12.25           O  
ATOM    138  CB  THR A   4      -3.961   1.999   6.017  0.60 13.11           C  
ATOM    140  OG1 THR A   4      -5.241   2.614   6.114  0.60 17.04           O  
ATOM    142  CG2 THR A   4      -3.390   1.098   7.055  0.60 17.80           C  
ATOM    144  N   PHE A   5      -0.731   3.055   5.858  1.00 13.08           N  
ATOM    145  CA  PHE A   5       0.699   2.789   6.002  1.00 13.81           C  
ATOM    146  C   PHE A   5       1.151   3.092   7.417  1.00 15.15           C  
ATOM    147  O   PHE A   5       0.674   4.056   8.037  1.00 15.69           O  
ATOM    148  CB  PHE A   5       1.510   3.659   5.043  1.00 15.02           C  
ATOM    149  CG  PHE A   5       1.024   3.592   3.633  1.00 13.81           C  
ATOM    150  CD1 PHE A   5      -0.033   4.388   3.214  1.00 15.25           C  
ATOM    151  CD2 PHE A   5       1.592   2.726   2.731  1.00 14.68           C  
ATOM    152  CE1 PHE A   5      -0.523   4.348   1.942  1.00 15.77           C  
ATOM    153  CE2 PHE A   5       1.047   2.670   1.406  1.00 15.90           C  
ATOM    154  CZ  PHE A   5       0.020   3.503   1.056  1.00 14.83           C  
ATOM    155  N   ARG A   6       2.093   2.298   7.889  1.00 14.63           N  
ATOM    156  CA  ARG A   6       2.787   2.614   9.129  0.60 16.25           C  
ATOM    158  C   ARG A   6       4.223   2.150   9.055  1.00 15.94           C  
ATOM    159  O   ARG A   6       4.562   1.221   8.325  1.00 16.37           O  
ATOM    160  CB  ARG A   6       2.083   1.951  10.303  0.60 16.96           C  
ATOM    162  CG  ARG A   6       2.323   2.653  11.636  0.60 20.60           C  
ATOM    164  CD  ARG A   6       1.962   1.764  12.815  0.60 30.57           C  
ATOM    166  NE  ARG A   6       0.517   1.554  12.945  0.60 30.43           N  
ATOM    168  CZ  ARG A   6      -0.091   1.157  14.063  0.60 43.03           C  
ATOM    170  NH1 ARG A   6       0.607   0.935  15.170  0.60 32.95           N  
ATOM    172  NH2 ARG A   6      -1.406   0.990  14.074  0.60 34.71           N  
ATOM    174  N   LEU A   7       5.081   2.863   9.795  1.00 16.07           N  
ATOM    175  CA  LEU A   7       6.511   2.512   9.888  1.00 17.19           C  
ATOM    176  C   LEU A   7       6.810   2.256  11.352  1.00 18.41           C  
ATOM    177  O   LEU A   7       6.526   3.114  12.194  1.00 19.17           O  
ATOM    178  CB  LEU A   7       7.397   3.650   9.335  1.00 17.28           C  
ATOM    179  CG  LEU A   7       8.923   3.490   9.468  1.00 18.29           C  
ATOM    180  CD1 LEU A   7       9.433   2.364   8.582  1.00 20.14           C  
ATOM    181  CD2 LEU A   7       9.607   4.833   9.049  1.00 17.90           C  
ATOM    182  N   GLU A   8       7.341   1.068  11.642  1.00 18.77           N  
ATOM    183  CA  GLU A   8       7.775   0.725  13.021  1.00 20.47           C  
ATOM    184  C   GLU A   8       9.126   0.062  12.915  1.00 21.00           C  
ATOM    185  O   GLU A   8       9.252  -0.961  12.280  1.00 20.08           O  
ATOM    186  CB  GLU A   8       6.783  -0.220  13.754  1.00 21.56           C  
ATOM    187  CG  GLU A   8       5.336   0.264  13.906  1.00 23.14           C  
ATOM    188  CD  GLU A   8       4.471  -0.706  14.774  1.00 25.64           C  
ATOM    189  OE1 GLU A   8       4.717  -1.950  14.820  1.00 29.25           O  
ATOM    190  OE2 GLU A   8       3.532  -0.218  15.442  1.00 33.53           O  
ATOM    191  N   ASN A   9      10.158   0.633  13.540  1.00 22.82           N  
ATOM    192  CA  ASN A   9      11.457  -0.086  13.551  1.00 23.69           C  
ATOM    193  C   ASN A   9      11.905  -0.608  12.181  1.00 23.05           C  
ATOM    194  O   ASN A   9      12.181  -1.829  11.993  1.00 24.42           O  
ATOM    195  CB  ASN A   9      11.430  -1.247  14.532  1.00 24.64           C  
ATOM    196  CG  ASN A   9      12.828  -1.814  14.796  1.00 28.23           C  
ATOM    197  OD1 ASN A   9      13.000  -3.021  14.977  1.00 31.84           O  
ATOM    198  ND2 ASN A   9      13.824  -0.944  14.763  1.00 29.19           N  
ATOM    199  N   GLN A  10      11.959   0.342  11.259  1.00 21.61           N  
ATOM    200  CA  GLN A  10      12.360   0.135   9.863  0.60 21.01           C  
ATOM    202  C   GLN A  10      11.444  -0.751   9.001  1.00 19.28           C  
ATOM    203  O   GLN A  10      11.628  -0.801   7.786  1.00 18.76           O  
ATOM    204  CB  GLN A  10      13.805  -0.357   9.760  0.60 21.76           C  
ATOM    206  CG  GLN A  10      14.806   0.561  10.492  0.60 24.10           C  
ATOM    208  CD  GLN A  10      16.242   0.223  10.146  0.60 37.35           C  
ATOM    210  OE1 GLN A  10      16.642  -0.949  10.170  0.60 29.45           O  
ATOM    212  NE2 GLN A  10      17.030   1.250   9.829  0.60 29.08           N  
ATOM    214  N   THR A  11      10.448  -1.395   9.636  1.00 17.56           N  
ATOM    215  CA  THR A  11       9.493  -2.244   8.921  1.00 15.45           C  
ATOM    216  C   THR A  11       8.269  -1.414   8.503  1.00 15.24           C  
ATOM    217  O   THR A  11       7.708  -0.647   9.292  1.00 15.89           O  
ATOM    218  CB  THR A  11       9.008  -3.407   9.797  1.00 16.59           C  
ATOM    219  OG1 THR A  11      10.138  -4.205  10.113  1.00 19.02           O  
ATOM    220  CG2 THR A  11       8.001  -4.315   9.009  1.00 15.82           C  
ATOM    221  N   ILE A  12       7.878  -1.569   7.245  1.00 14.24           N  
ATOM    222  CA  ILE A  12       6.691  -0.866   6.722  1.00 13.70           C  
ATOM    223  C   ILE A  12       5.517  -1.825   6.776  1.00 13.24           C  
ATOM    224  O   ILE A  12       5.652  -3.013   6.417  1.00 14.17           O  
ATOM    225  CB  ILE A  12       6.954  -0.377   5.303  1.00 14.76           C  
ATOM    226  CG1 ILE A  12       7.923   0.816   5.380  1.00 16.50           C  
ATOM    227  CG2 ILE A  12       5.653   0.086   4.624  1.00 15.29           C  
ATOM    228  CD1 ILE A  12       8.425   1.316   4.093  1.00 18.63           C  
ATOM    229  N   TYR A  13       4.379  -1.352   7.279  1.00 13.04           N  
ATOM    230  CA  TYR A  13       3.120  -2.098   7.252  1.00 12.68           C  
ATOM    231  C   TYR A  13       2.157  -1.407   6.297  1.00 12.25           C  
ATOM    232  O   TYR A  13       1.996  -0.175   6.343  1.00 15.07           O  
ATOM    233  CB  TYR A  13       2.503  -2.175   8.651  1.00 13.53           C  
ATOM    234  CG  TYR A  13       3.402  -2.918   9.643  1.00 14.61           C  
ATOM    235  CD1 TYR A  13       4.401  -2.241  10.373  1.00 16.46           C  
ATOM    236  CD2 TYR A  13       3.290  -4.314   9.802  1.00 16.70           C  
ATOM    237  CE1 TYR A  13       5.243  -2.933  11.250  1.00 16.90           C  
ATOM    238  CE2 TYR A  13       4.111  -5.012  10.673  1.00 16.58           C  
ATOM    239  CZ  TYR A  13       5.095  -4.317  11.390  1.00 16.88           C  
ATOM    240  OH  TYR A  13       5.868  -5.044  12.263  1.00 20.67           O  
ATOM    241  N   PHE A  14       1.512  -2.192   5.455  1.00 12.00           N  
ATOM    242  CA  PHE A  14       0.595  -1.654   4.464  1.00 11.26           C  
ATOM    243  C   PHE A  14      -0.734  -2.381   4.620  1.00 11.33           C  
ATOM    244  O   PHE A  14      -0.756  -3.609   4.833  1.00 12.06           O  
ATOM    245  CB  PHE A  14       1.181  -1.943   3.069  1.00 11.25           C  
ATOM    246  CG  PHE A  14       0.178  -1.721   1.915  1.00 11.43           C  
ATOM    247  CD1 PHE A  14      -0.368  -0.450   1.669  1.00 12.70           C  
ATOM    248  CD2 PHE A  14      -0.157  -2.765   1.063  1.00 13.05           C  
ATOM    249  CE1 PHE A  14      -1.245  -0.236   0.608  1.00 12.29           C  
ATOM    250  CE2 PHE A  14      -1.082  -2.574  -0.028  1.00 13.53           C  
ATOM    251  CZ  PHE A  14      -1.607  -1.312  -0.237  1.00 12.05           C  
ATOM    252  N   GLY A  15      -1.823  -1.641   4.494  1.00 11.87           N  
ATOM    253  CA  GLY A  15      -3.173  -2.230   4.524  1.00 11.69           C  
ATOM    254  C   GLY A  15      -3.989  -1.599   3.423  1.00 11.89           C  
ATOM    255  O   GLY A  15      -3.811  -0.413   3.071  1.00 13.14           O  
ATOM    256  N   THR A  16      -4.858  -2.415   2.842  1.00 10.46           N  
ATOM    257  CA  THR A  16      -5.866  -1.845   1.931  1.00 10.50           C  
ATOM    258  C   THR A  16      -7.101  -2.745   1.944  1.00 10.90           C  
ATOM    259  O   THR A  16      -7.115  -3.758   2.620  1.00 12.67           O  
ATOM    260  CB  THR A  16      -5.290  -1.696   0.535  1.00 11.57           C  
ATOM    261  OG1 THR A  16      -6.188  -0.956  -0.290  1.00 11.17           O  
ATOM    262  CG2 THR A  16      -4.995  -3.037  -0.113  1.00 12.96           C  
ATOM    263  N   GLU A  17      -8.127  -2.311   1.240  1.00 11.20           N  
ATOM    264  CA  GLU A  17      -9.379  -3.065   1.224  1.00 13.38           C  
ATOM    265  C   GLU A  17      -9.925  -3.128  -0.175  1.00 12.33           C  
ATOM    266  O   GLU A  17      -9.798  -2.158  -0.933  1.00 11.81           O  
ATOM    267  CB  GLU A  17     -10.443  -2.325   2.099  1.00 15.78           C  
ATOM    268  CG  GLU A  17     -10.016  -1.997   3.466  1.00 19.86           C  
ATOM    269  CD  GLU A  17     -11.109  -1.305   4.268  1.00 21.59           C  
ATOM    270  OE1 GLU A  17     -12.138  -0.811   3.681  1.00 24.50           O  
ATOM    271  OE2 GLU A  17     -10.925  -1.245   5.513  1.00 30.52           O  
ATOM    272  N   ARG A  18     -10.611  -4.236  -0.479  1.00 10.85           N  
ATOM    273  CA  ARG A  18     -11.380  -4.302  -1.736  1.00 11.16           C  
ATOM    274  C   ARG A  18     -12.803  -4.726  -1.384  1.00 11.57           C  
ATOM    275  O   ARG A  18     -13.004  -5.778  -0.802  1.00 12.00           O  
ATOM    276  CB  ARG A  18     -10.775  -5.285  -2.766  1.00 11.12           C  
ATOM    277  CG  ARG A  18      -9.396  -4.954  -3.234  1.00 10.15           C  
ATOM    278  CD  ARG A  18      -9.377  -3.683  -4.073  1.00 10.64           C  
ATOM    279  NE  ARG A  18      -8.033  -3.337  -4.528  1.00 10.47           N  
ATOM    280  CZ  ARG A  18      -7.142  -2.676  -3.783  1.00 10.01           C  
ATOM    281  NH1 ARG A  18      -5.957  -2.355  -4.336  1.00 10.63           N  
ATOM    282  NH2 ARG A  18      -7.417  -2.378  -2.492  1.00 10.45           N  
ATOM    283  N   ALA A  19     -13.777  -3.900  -1.764  1.00 11.61           N  
ATOM    284  CA  ALA A  19     -15.199  -4.254  -1.645  1.00 12.23           C  
ATOM    285  C   ALA A  19     -15.508  -5.070  -2.903  1.00 12.45           C  
ATOM    286  O   ALA A  19     -15.420  -4.552  -4.013  1.00 14.73           O  
ATOM    287  CB  ALA A  19     -16.105  -3.033  -1.613  1.00 13.74           C  
ATOM    288  N   ILE A  20     -15.865  -6.340  -2.719  1.00 12.40           N  
ATOM    289  CA  ILE A  20     -16.134  -7.249  -3.842  1.00 11.93           C  
ATOM    290  C   ILE A  20     -17.550  -7.798  -3.710  1.00 12.67           C  
ATOM    291  O   ILE A  20     -17.907  -8.289  -2.642  1.00 13.73           O  
ATOM    292  CB  ILE A  20     -15.112  -8.419  -3.861  1.00 12.88           C  
ATOM    293  CG1 ILE A  20     -13.665  -7.863  -3.902  1.00 13.48           C  
ATOM    294  CG2 ILE A  20     -15.368  -9.278  -5.075  1.00 13.50           C  
ATOM    295  CD1 ILE A  20     -12.568  -8.905  -3.800  1.00 12.96           C  
ATOM    296  N   SER A  21     -18.341  -7.712  -4.782  1.00 13.22           N  
ATOM    297  CA  SER A  21     -19.751  -8.159  -4.724  0.60 13.31           C  
ATOM    299  C   SER A  21     -19.862  -9.668  -4.948  1.00 14.00           C  
ATOM    300  O   SER A  21     -20.483 -10.153  -5.915  1.00 16.51           O  
ATOM    301  CB  SER A  21     -20.601  -7.433  -5.744  0.60 14.42           C  
ATOM    303  OG  SER A  21     -20.029  -7.612  -7.012  0.60 17.18           O  
ATOM    305  N   ALA A  22     -19.270 -10.412  -4.027  1.00 13.11           N  
ATOM    306  CA  ALA A  22     -19.494 -11.845  -3.928  1.00 12.24           C  
ATOM    307  C   ALA A  22     -19.354 -12.260  -2.492  1.00 11.90           C  
ATOM    308  O   ALA A  22     -18.848 -11.488  -1.682  1.00 13.09           O  
ATOM    309  CB  ALA A  22     -18.463 -12.630  -4.760  1.00 13.35           C  
ATOM    310  N   SER A  23     -19.779 -13.479  -2.175  1.00 12.61           N  
ATOM    311  CA  SER A  23     -19.677 -13.978  -0.818  1.00 13.50           C  
ATOM    312  C   SER A  23     -18.253 -14.329  -0.465  1.00 12.81           C  
ATOM    313  O   SER A  23     -17.422 -14.581  -1.356  1.00 12.44           O  
ATOM    314  CB  SER A  23     -20.497 -15.241  -0.701  1.00 14.20           C  
ATOM    315  OG  SER A  23     -19.908 -16.277  -1.469  1.00 16.30           O  
ATOM    316  N   PRO A  24     -17.959 -14.353   0.830  1.00 12.75           N  
ATOM    317  CA  PRO A  24     -16.608 -14.781   1.234  1.00 14.19           C  
ATOM    318  C   PRO A  24     -16.259 -16.179   0.716  1.00 14.39           C  
ATOM    319  O   PRO A  24     -15.121 -16.454   0.401  1.00 14.74           O  
ATOM    320  CB  PRO A  24     -16.677 -14.775   2.768  1.00 15.85           C  
ATOM    321  CG  PRO A  24     -17.736 -13.733   3.063  1.00 16.44           C  
ATOM    322  CD  PRO A  24     -18.770 -13.883   1.972  1.00 13.80           C  
ATOM    323  N   GLN A  25     -17.246 -17.060   0.639  1.00 13.61           N  
ATOM    324  CA  GLN A  25     -16.990 -18.409   0.165  1.00 15.07           C  
ATOM    325  C   GLN A  25     -16.543 -18.383  -1.291  1.00 13.55           C  
ATOM    326  O   GLN A  25     -15.632 -19.151  -1.699  1.00 15.23           O  
ATOM    327  CB  GLN A  25     -18.248 -19.251   0.339  1.00 16.69           C  
ATOM    328  CG  GLN A  25     -18.582 -19.458   1.859  1.00 19.17           C  
ATOM    329  CD  GLN A  25     -19.341 -18.315   2.577  1.00 20.57           C  
ATOM    330  OE1 GLN A  25     -19.690 -17.317   2.012  1.00 17.18           O  
ATOM    331  NE2 GLN A  25     -19.646 -18.540   3.849  1.00 26.73           N  
ATOM    332  N   THR A  26     -17.144 -17.507  -2.103  1.00 12.79           N  
ATOM    333  CA  THR A  26     -16.713 -17.396  -3.511  1.00 12.69           C  
ATOM    334  C   THR A  26     -15.283 -16.835  -3.572  1.00 12.66           C  
ATOM    335  O   THR A  26     -14.462 -17.331  -4.313  1.00 12.93           O  
ATOM    336  CB  THR A  26     -17.692 -16.493  -4.241  1.00 13.43           C  
ATOM    337  OG1 THR A  26     -18.952 -17.188  -4.385  1.00 17.07           O  
ATOM    338  CG2 THR A  26     -17.176 -16.144  -5.604  1.00 16.29           C  
ATOM    339  N   ILE A  27     -15.034 -15.750  -2.827  1.00 10.53           N  
ATOM    340  CA  ILE A  27     -13.738 -15.103  -2.939  1.00 11.27           C  
ATOM    341  C   ILE A  27     -12.650 -16.045  -2.427  1.00 10.43           C  
ATOM    342  O   ILE A  27     -11.541 -16.066  -2.959  1.00 10.98           O  
ATOM    343  CB  ILE A  27     -13.770 -13.788  -2.165  1.00 11.25           C  
ATOM    344  CG1 ILE A  27     -14.735 -12.829  -2.873  1.00 13.90           C  
ATOM    345  CG2 ILE A  27     -12.342 -13.230  -2.054  1.00 12.95           C  
ATOM    346  CD1 ILE A  27     -15.203 -11.729  -1.991  1.00 17.95           C  
ATOM    347  N   TRP A  28     -12.949 -16.853  -1.406  1.00 10.58           N  
ATOM    348  CA  TRP A  28     -11.955 -17.799  -0.871  1.00  8.94           C  
ATOM    349  C   TRP A  28     -11.415 -18.738  -1.965  1.00  9.85           C  
ATOM    350  O   TRP A  28     -10.233 -19.131  -1.923  1.00 10.22           O  
ATOM    351  CB  TRP A  28     -12.597 -18.625   0.237  1.00 10.81           C  
ATOM    352  CG  TRP A  28     -11.698 -19.613   0.846  1.00 10.63           C  
ATOM    353  CD1 TRP A  28     -11.763 -20.981   0.701  1.00 11.36           C  
ATOM    354  CD2 TRP A  28     -10.632 -19.353   1.771  1.00  9.81           C  
ATOM    355  NE1 TRP A  28     -10.801 -21.571   1.474  1.00 11.60           N  
ATOM    356  CE2 TRP A  28     -10.084 -20.602   2.144  1.00 10.28           C  
ATOM    357  CE3 TRP A  28     -10.061 -18.176   2.302  1.00  9.94           C  
ATOM    358  CZ2 TRP A  28      -8.968 -20.708   3.028  1.00 11.98           C  
ATOM    359  CZ3 TRP A  28      -8.977 -18.287   3.196  1.00 12.17           C  
ATOM    360  CH2 TRP A  28      -8.475 -19.533   3.555  1.00 11.26           C  
ATOM    361  N   ARG A  29     -12.244 -19.083  -2.941  1.00  9.66           N  
ATOM    362  CA  ARG A  29     -11.783 -20.001  -3.992  1.00  9.77           C  
ATOM    363  C   ARG A  29     -10.680 -19.348  -4.802  1.00  8.70           C  
ATOM    364  O   ARG A  29      -9.837 -20.057  -5.320  1.00  9.70           O  
ATOM    365  CB  ARG A  29     -12.923 -20.443  -4.913  1.00  9.34           C  
ATOM    366  CG  ARG A  29     -14.063 -21.144  -4.082  1.00 11.99           C  
ATOM    367  CD  ARG A  29     -15.193 -21.703  -4.965  1.00 13.52           C  
ATOM    368  NE  ARG A  29     -14.615 -22.634  -5.918  1.00 13.30           N  
ATOM    369  CZ  ARG A  29     -15.237 -23.081  -7.020  1.00 14.08           C  
ATOM    370  NH1 ARG A  29     -14.588 -23.901  -7.840  1.00 14.71           N  
ATOM    371  NH2 ARG A  29     -16.497 -22.693  -7.271  1.00 16.11           N  
ATOM    372  N   TYR A  30     -10.696 -18.002  -4.929  1.00  9.00           N  
ATOM    373  CA  TYR A  30      -9.662 -17.332  -5.702  1.00  9.19           C  
ATOM    374  C   TYR A  30      -8.322 -17.286  -4.972  1.00  8.64           C  
ATOM    375  O   TYR A  30      -7.319 -16.915  -5.592  1.00  9.72           O  
ATOM    376  CB  TYR A  30     -10.129 -15.908  -6.069  1.00  9.28           C  
ATOM    377  CG  TYR A  30     -11.204 -15.962  -7.136  1.00 10.09           C  
ATOM    378  CD1 TYR A  30     -12.541 -16.192  -6.775  1.00  9.52           C  
ATOM    379  CD2 TYR A  30     -10.890 -15.774  -8.487  1.00 10.23           C  
ATOM    380  CE1 TYR A  30     -13.536 -16.302  -7.739  1.00 11.93           C  
ATOM    381  CE2 TYR A  30     -11.889 -15.827  -9.456  1.00 11.42           C  
ATOM    382  CZ  TYR A  30     -13.200 -16.094  -9.071  1.00 10.47           C  
ATOM    383  OH  TYR A  30     -14.193 -16.191 -10.037  1.00 15.41           O  
ATOM    384  N   LEU A  31      -8.318 -17.660  -3.683  1.00  9.08           N  
ATOM    385  CA  LEU A  31      -7.054 -17.739  -2.956  1.00  9.12           C  
ATOM    386  C   LEU A  31      -6.550 -19.179  -2.836  1.00 10.45           C  
ATOM    387  O   LEU A  31      -5.459 -19.392  -2.314  1.00 10.85           O  
ATOM    388  CB  LEU A  31      -7.214 -17.216  -1.511  1.00 10.25           C  
ATOM    389  CG  LEU A  31      -7.652 -15.759  -1.419  1.00  9.85           C  
ATOM    390  CD1 LEU A  31      -8.017 -15.344   0.007  1.00 10.00           C  
ATOM    391  CD2 LEU A  31      -6.562 -14.880  -1.923  1.00 13.86           C  
ATOM    392  N   THR A  32      -7.400 -20.164  -3.192  1.00  9.61           N  
ATOM    393  CA  THR A  32      -7.147 -21.555  -2.819  1.00  9.43           C  
ATOM    394  C   THR A  32      -7.262 -22.536  -3.984  1.00  9.95           C  
ATOM    395  O   THR A  32      -7.111 -23.734  -3.756  1.00 11.16           O  
ATOM    396  CB  THR A  32      -8.084 -22.025  -1.694  1.00  9.93           C  
ATOM    397  OG1 THR A  32      -9.438 -21.757  -2.075  1.00 10.73           O  
ATOM    398  CG2 THR A  32      -7.733 -21.275  -0.426  1.00 11.59           C  
ATOM    399  N   GLU A  33      -7.468 -22.039  -5.202  1.00 10.83           N  
ATOM    400  CA  GLU A  33      -7.568 -22.908  -6.406  1.00  9.89           C  
ATOM    401  C   GLU A  33      -6.721 -22.351  -7.514  1.00  9.87           C  
ATOM    402  O   GLU A  33      -6.836 -21.155  -7.849  1.00 10.79           O  
ATOM    403  CB  GLU A  33      -9.032 -23.056  -6.858  1.00 10.93           C  
ATOM    404  CG  GLU A  33      -9.954 -23.584  -5.742  1.00 11.65           C  
ATOM    405  CD  GLU A  33     -11.411 -23.732  -6.095  1.00 12.36           C  
ATOM    406  OE1 GLU A  33     -11.782 -23.704  -7.301  1.00 16.03           O  
ATOM    407  OE2 GLU A  33     -12.187 -23.849  -5.139  1.00 14.70           O  
ATOM    408  N   THR A  34      -5.842 -23.169  -8.093  1.00 10.57           N  
ATOM    409  CA  THR A  34      -4.847 -22.620  -9.013  1.00 10.91           C  
ATOM    410  C   THR A  34      -5.506 -21.919 -10.214  1.00 11.03           C  
ATOM    411  O   THR A  34      -5.071 -20.839 -10.642  1.00 12.50           O  
ATOM    412  CB  THR A  34      -3.915 -23.700  -9.490  1.00 12.89           C  
ATOM    413  OG1 THR A  34      -3.160 -24.141  -8.344  1.00 12.76           O  
ATOM    414  CG2 THR A  34      -2.956 -23.209 -10.563  1.00 13.21           C  
ATOM    415  N   ASP A  35      -6.578 -22.498 -10.744  1.00 11.73           N  
ATOM    416  CA  ASP A  35      -7.129 -21.911 -11.971  0.70 12.02           C  
ATOM    418  C   ASP A  35      -7.728 -20.543 -11.700  1.00 12.79           C  
ATOM    419  O   ASP A  35      -7.812 -19.697 -12.613  1.00 16.42           O  
ATOM    420  CB  ASP A  35      -8.166 -22.837 -12.556  0.70 12.83           C  
ATOM    422  CG  ASP A  35      -7.550 -24.090 -13.191  0.70 17.69           C  
ATOM    424  OD1 ASP A  35      -6.299 -24.224 -13.302  0.70 22.23           O  
ATOM    426  OD2 ASP A  35      -8.368 -24.935 -13.622  0.70 25.43           O  
ATOM    428  N   LYS A  36      -8.165 -20.334 -10.461  1.00 11.42           N  
ATOM    429  CA  LYS A  36      -8.718 -19.015 -10.108  1.00 10.52           C  
ATOM    430  C   LYS A  36      -7.623 -18.033  -9.670  1.00 10.95           C  
ATOM    431  O   LYS A  36      -7.615 -16.862 -10.053  1.00 12.32           O  
ATOM    432  CB  LYS A  36      -9.747 -19.160  -9.005  1.00 11.28           C  
ATOM    433  CG  LYS A  36     -11.048 -19.770  -9.527  1.00 14.07           C  
ATOM    434  CD  LYS A  36     -12.014 -19.983  -8.404  1.00 15.44           C  
ATOM    435  CE  LYS A  36     -13.300 -20.676  -8.842  1.00 16.12           C  
ATOM    436  NZ  LYS A  36     -14.191 -19.646  -9.384  1.00 21.28           N  
ATOM    437  N   LEU A  37      -6.683 -18.544  -8.914  1.00 11.97           N  
ATOM    438  CA  LEU A  37      -5.551 -17.735  -8.462  1.00 12.35           C  
ATOM    439  C   LEU A  37      -4.838 -17.175  -9.693  1.00 12.69           C  
ATOM    440  O   LEU A  37      -4.502 -15.968  -9.729  1.00 13.83           O  
ATOM    441  CB  LEU A  37      -4.647 -18.659  -7.627  1.00 13.68           C  
ATOM    442  CG  LEU A  37      -3.497 -18.073  -6.899  1.00 14.02           C  
ATOM    443  CD1 LEU A  37      -3.834 -16.822  -6.111  1.00 14.85           C  
ATOM    444  CD2 LEU A  37      -2.809 -19.121  -6.061  1.00 13.03           C  
ATOM    445  N   LYS A  38      -4.656 -17.987 -10.729  1.00 13.39           N  
ATOM    446  CA  LYS A  38      -3.951 -17.484 -11.916  1.00 14.16           C  
ATOM    447  C   LYS A  38      -4.721 -16.416 -12.693  1.00 14.38           C  
ATOM    448  O   LYS A  38      -4.149 -15.742 -13.515  1.00 16.04           O  
ATOM    449  CB  LYS A  38      -3.544 -18.626 -12.837  1.00 16.05           C  
ATOM    450  CG  LYS A  38      -2.415 -19.472 -12.224  1.00 19.04           C  
ATOM    451  CD  LYS A  38      -1.923 -20.461 -13.293  1.00 22.27           C  
ATOM    452  CE  LYS A  38      -0.712 -21.251 -12.828  1.00 22.23           C  
ATOM    453  NZ  LYS A  38       0.406 -20.316 -12.373  1.00 23.96           N  
ATOM    454  N   GLN A  39      -6.042 -16.294 -12.475  1.00 12.11           N  
ATOM    455  CA  GLN A  39      -6.790 -15.223 -13.164  1.00 12.29           C  
ATOM    456  C   GLN A  39      -6.376 -13.835 -12.716  1.00 12.84           C  
ATOM    457  O   GLN A  39      -6.604 -12.848 -13.435  1.00 13.87           O  
ATOM    458  CB  GLN A  39      -8.311 -15.368 -12.958  1.00 11.98           C  
ATOM    459  CG  GLN A  39      -8.869 -16.654 -13.594  1.00 13.28           C  
ATOM    460  CD  GLN A  39     -10.346 -16.845 -13.290  1.00 15.71           C  
ATOM    461  OE1 GLN A  39     -10.764 -17.882 -12.812  1.00 22.42           O  
ATOM    462  NE2 GLN A  39     -11.123 -15.841 -13.574  1.00 19.10           N  
ATOM    463  N   TRP A  40      -5.839 -13.725 -11.503  1.00 11.59           N  
ATOM    464  CA  TRP A  40      -5.480 -12.414 -10.993  1.00 11.61           C  
ATOM    465  C   TRP A  40      -4.000 -12.305 -10.661  1.00 11.57           C  
ATOM    466  O   TRP A  40      -3.476 -11.184 -10.613  1.00 11.03           O  
ATOM    467  CB  TRP A  40      -6.377 -12.012  -9.817  1.00 11.37           C  
ATOM    468  CG  TRP A  40      -6.253 -12.870  -8.598  1.00 10.96           C  
ATOM    469  CD1 TRP A  40      -6.876 -14.082  -8.374  1.00 12.81           C  
ATOM    470  CD2 TRP A  40      -5.521 -12.563  -7.404  1.00 10.50           C  
ATOM    471  NE1 TRP A  40      -6.509 -14.574  -7.109  1.00 11.12           N  
ATOM    472  CE2 TRP A  40      -5.689 -13.653  -6.502  1.00 11.24           C  
ATOM    473  CE3 TRP A  40      -4.738 -11.479  -7.003  1.00 11.43           C  
ATOM    474  CZ2 TRP A  40      -5.068 -13.689  -5.259  1.00 11.40           C  
ATOM    475  CZ3 TRP A  40      -4.141 -11.520  -5.733  1.00 12.06           C  
ATOM    476  CH2 TRP A  40      -4.284 -12.627  -4.910  1.00 12.68           C  
ATOM    477  N   PHE A  41      -3.313 -13.443 -10.417  1.00 10.83           N  
ATOM    478  CA  PHE A  41      -1.879 -13.389 -10.127  1.00 12.09           C  
ATOM    479  C   PHE A  41      -1.262 -14.614 -10.832  1.00 11.37           C  
ATOM    480  O   PHE A  41      -1.060 -15.660 -10.219  1.00 12.12           O  
ATOM    481  CB  PHE A  41      -1.623 -13.348  -8.602  1.00 12.29           C  
ATOM    482  CG  PHE A  41      -0.261 -12.840  -8.224  1.00 11.80           C  
ATOM    483  CD1 PHE A  41       0.855 -12.958  -9.102  1.00 13.69           C  
ATOM    484  CD2 PHE A  41      -0.082 -12.204  -7.024  1.00 13.96           C  
ATOM    485  CE1 PHE A  41       2.120 -12.497  -8.712  1.00 16.09           C  
ATOM    486  CE2 PHE A  41       1.174 -11.738  -6.621  1.00 14.96           C  
ATOM    487  CZ  PHE A  41       2.275 -11.875  -7.468  1.00 15.03           C  
ATOM    488  N   PRO A  42      -0.951 -14.461 -12.139  1.00 14.00           N  
ATOM    489  CA  PRO A  42      -0.608 -15.578 -13.000  1.00 14.74           C  
ATOM    490  C   PRO A  42       0.587 -16.422 -12.568  1.00 14.21           C  
ATOM    491  O   PRO A  42       0.683 -17.614 -12.937  1.00 15.61           O  
ATOM    492  CB  PRO A  42      -0.339 -14.908 -14.376  1.00 16.24           C  
ATOM    493  CG  PRO A  42      -1.024 -13.684 -14.335  1.00 16.96           C  
ATOM    494  CD  PRO A  42      -1.070 -13.197 -12.904  1.00 14.07           C  
ATOM    495  N   GLU A  43       1.489 -15.813 -11.815  1.00 13.29           N  
ATOM    496  CA  GLU A  43       2.726 -16.505 -11.383  1.00 13.91           C  
ATOM    497  C   GLU A  43       2.485 -17.426 -10.199  1.00 12.99           C  
ATOM    498  O   GLU A  43       3.352 -18.239  -9.842  1.00 15.56           O  
ATOM    499  CB  GLU A  43       3.761 -15.471 -10.974  1.00 14.71           C  
ATOM    500  CG  GLU A  43       4.308 -14.673 -12.182  1.00 17.94           C  
ATOM    501  CD  GLU A  43       3.440 -13.536 -12.637  1.00 20.57           C  
ATOM    502  OE1 GLU A  43       2.448 -13.168 -11.961  1.00 19.21           O  
ATOM    503  OE2 GLU A  43       3.798 -12.977 -13.705  1.00 26.03           O  
ATOM    504  N   LEU A  44       1.320 -17.304  -9.547  1.00 12.44           N  
ATOM    505  CA  LEU A  44       1.051 -18.133  -8.356  1.00 13.54           C  
ATOM    506  C   LEU A  44       0.320 -19.428  -8.664  1.00 13.30           C  
ATOM    507  O   LEU A  44      -0.455 -19.518  -9.613  1.00 15.18           O  
ATOM    508  CB  LEU A  44       0.216 -17.350  -7.332  1.00 13.39           C  
ATOM    509  CG  LEU A  44       0.882 -16.098  -6.768  1.00 13.21           C  
ATOM    510  CD1 LEU A  44      -0.118 -15.419  -5.796  1.00 15.78           C  
ATOM    511  CD2 LEU A  44       2.107 -16.462  -5.980  1.00 14.87           C  
ATOM    512  N   GLU A  45       0.627 -20.460  -7.882  1.00 12.28           N  
ATOM    513  CA  GLU A  45      -0.178 -21.688  -7.911  1.00 13.15           C  
ATOM    514  C   GLU A  45      -0.330 -22.228  -6.504  1.00 12.49           C  
ATOM    515  O   GLU A  45       0.416 -21.849  -5.600  1.00 11.78           O  
ATOM    516  CB  GLU A  45       0.413 -22.750  -8.855  1.00 15.37           C  
ATOM    517  CG  GLU A  45       1.702 -23.331  -8.341  1.00 18.29           C  
ATOM    518  CD  GLU A  45       2.317 -24.403  -9.270  1.00 19.09           C  
ATOM    519  OE1 GLU A  45       2.121 -24.307 -10.491  1.00 25.18           O  
ATOM    520  OE2 GLU A  45       2.999 -25.323  -8.760  1.00 25.61           O  
ATOM    521  N   ILE A  46      -1.348 -23.047  -6.309  1.00 11.84           N  
ATOM    522  CA  ILE A  46      -1.498 -23.735  -5.021  1.00 11.46           C  
ATOM    523  C   ILE A  46      -0.444 -24.848  -4.902  1.00 12.49           C  
ATOM    524  O   ILE A  46      -0.244 -25.676  -5.832  1.00 13.84           O  
ATOM    525  CB  ILE A  46      -2.915 -24.352  -4.876  1.00 11.55           C  
ATOM    526  CG1 ILE A  46      -3.992 -23.282  -5.036  1.00 13.35           C  
ATOM    527  CG2 ILE A  46      -3.030 -25.121  -3.568  1.00 12.63           C  
ATOM    528  CD1 ILE A  46      -3.807 -22.082  -4.090  1.00 13.93           C  
ATOM    529  N   GLY A  47       0.201 -24.872  -3.720  1.00 11.60           N  
ATOM    530  CA  GLY A  47       1.025 -25.998  -3.272  1.00 12.50           C  
ATOM    531  C   GLY A  47       0.140 -27.018  -2.591  1.00 12.65           C  
ATOM    532  O   GLY A  47      -0.194 -28.054  -3.184  1.00 15.47           O  
ATOM    533  N   GLU A  48      -0.272 -26.720  -1.372  1.00 11.07           N  
ATOM    534  CA  GLU A  48      -1.220 -27.513  -0.629  1.00 11.11           C  
ATOM    535  C   GLU A  48      -2.010 -26.562   0.230  1.00 10.34           C  
ATOM    536  O   GLU A  48      -1.565 -25.408   0.471  1.00 10.51           O  
ATOM    537  CB  GLU A  48      -0.540 -28.547   0.284  1.00 12.61           C  
ATOM    538  CG  GLU A  48       0.115 -29.708  -0.465  1.00 14.67           C  
ATOM    539  CD  GLU A  48       0.620 -30.767   0.509  1.00 14.75           C  
ATOM    540  OE1 GLU A  48       1.675 -30.533   1.199  1.00 18.69           O  
ATOM    541  OE2 GLU A  48      -0.044 -31.806   0.559  1.00 17.28           O  
ATOM    542  N   LEU A  49      -3.188 -27.002   0.638  1.00 10.72           N  
ATOM    543  CA  LEU A  49      -4.021 -26.211   1.538  1.00 11.42           C  
ATOM    544  C   LEU A  49      -3.871 -26.655   2.974  1.00 11.81           C  
ATOM    545  O   LEU A  49      -3.107 -27.592   3.243  1.00 14.06           O  
ATOM    546  CB  LEU A  49      -5.517 -26.244   1.100  1.00 11.53           C  
ATOM    547  CG  LEU A  49      -5.681 -25.680  -0.360  1.00 10.80           C  
ATOM    548  CD1 LEU A  49      -7.183 -25.747  -0.672  1.00 12.76           C  
ATOM    549  CD2 LEU A  49      -5.196 -24.230  -0.515  1.00 11.87           C  
ATOM    550  N   GLY A  50      -4.548 -25.981   3.906  1.00 12.53           N  
ATOM    551  CA  GLY A  50      -4.507 -26.430   5.314  1.00 13.12           C  
ATOM    552  C   GLY A  50      -3.456 -25.682   6.144  1.00 12.85           C  
ATOM    553  O   GLY A  50      -2.750 -24.781   5.632  1.00 12.46           O  
ATOM    554  N   VAL A  51      -3.323 -26.083   7.411  1.00 13.52           N  
ATOM    555  CA  VAL A  51      -2.496 -25.359   8.366  1.00 13.79           C  
ATOM    556  C   VAL A  51      -0.998 -25.437   8.007  1.00 13.02           C  
ATOM    557  O   VAL A  51      -0.201 -24.612   8.494  1.00 13.56           O  
ATOM    558  CB  VAL A  51      -2.760 -25.886   9.798  1.00 15.20           C  
ATOM    559  CG1 VAL A  51      -2.294 -27.321   9.960  1.00 16.40           C  
ATOM    560  CG2 VAL A  51      -2.100 -24.974  10.847  1.00 18.07           C  
ATOM    561  N   ASN A  52      -0.624 -26.421   7.170  1.00 11.60           N  
ATOM    562  CA  ASN A  52       0.738 -26.555   6.659  1.00 11.90           C  
ATOM    563  C   ASN A  52       0.788 -26.284   5.153  1.00 11.69           C  
ATOM    564  O   ASN A  52       1.694 -26.785   4.444  1.00 13.19           O  
ATOM    565  CB  ASN A  52       1.318 -27.951   7.013  1.00 12.75           C  
ATOM    566  CG  ASN A  52       1.454 -28.129   8.506  1.00 16.35           C  
ATOM    567  OD1 ASN A  52       1.846 -27.223   9.164  1.00 18.88           O  
ATOM    568  ND2 ASN A  52       1.074 -29.262   9.030  1.00 21.49           N  
ATOM    569  N   GLY A  53      -0.162 -25.516   4.632  1.00 10.41           N  
ATOM    570  CA  GLY A  53      -0.256 -25.330   3.178  1.00 10.33           C  
ATOM    571  C   GLY A  53       0.784 -24.309   2.732  1.00  9.35           C  
ATOM    572  O   GLY A  53       1.565 -23.740   3.546  1.00  9.93           O  
ATOM    573  N   PHE A  54       0.725 -24.036   1.440  1.00  9.91           N  
ATOM    574  CA  PHE A  54       1.678 -23.128   0.819  1.00  9.61           C  
ATOM    575  C   PHE A  54       1.207 -22.781  -0.594  1.00 10.22           C  
ATOM    576  O   PHE A  54       0.515 -23.577  -1.240  1.00 10.06           O  
ATOM    577  CB  PHE A  54       3.114 -23.691   0.788  1.00 10.57           C  
ATOM    578  CG  PHE A  54       3.291 -24.956  -0.013  1.00 10.58           C  
ATOM    579  CD1 PHE A  54       3.893 -24.930  -1.248  1.00 11.84           C  
ATOM    580  CD2 PHE A  54       2.982 -26.170   0.559  1.00 11.34           C  
ATOM    581  CE1 PHE A  54       4.163 -26.092  -1.933  1.00 14.27           C  
ATOM    582  CE2 PHE A  54       3.218 -27.363  -0.132  1.00 14.47           C  
ATOM    583  CZ  PHE A  54       3.786 -27.299  -1.402  1.00 14.80           C  
ATOM    584  N   TRP A  55       1.631 -21.607  -1.053  1.00  9.88           N  
ATOM    585  CA  TRP A  55       1.569 -21.238  -2.472  1.00  9.74           C  
ATOM    586  C   TRP A  55       2.937 -21.484  -3.083  1.00 10.63           C  
ATOM    587  O   TRP A  55       3.945 -21.618  -2.359  1.00 10.48           O  
ATOM    588  CB  TRP A  55       1.260 -19.776  -2.620  1.00 10.66           C  
ATOM    589  CG  TRP A  55      -0.219 -19.438  -2.402  1.00  9.86           C  
ATOM    590  CD1 TRP A  55      -1.315 -20.299  -2.297  1.00 11.39           C  
ATOM    591  CD2 TRP A  55      -0.754 -18.092  -2.326  1.00  9.72           C  
ATOM    592  NE1 TRP A  55      -2.509 -19.530  -2.137  1.00 10.34           N  
ATOM    593  CE2 TRP A  55      -2.169 -18.194  -2.144  1.00 10.15           C  
ATOM    594  CE3 TRP A  55      -0.157 -16.797  -2.371  1.00 10.51           C  
ATOM    595  CZ2 TRP A  55      -2.983 -17.057  -2.069  1.00  9.88           C  
ATOM    596  CZ3 TRP A  55      -1.005 -15.645  -2.276  1.00 11.34           C  
ATOM    597  CH2 TRP A  55      -2.378 -15.813  -2.125  1.00 10.97           C  
ATOM    598  N   ARG A  56       2.989 -21.506  -4.404  1.00 10.42           N  
ATOM    599  CA  ARG A  56       4.294 -21.488  -5.090  1.00 12.20           C  
ATOM    600  C   ARG A  56       4.302 -20.289  -6.020  1.00 12.47           C  
ATOM    601  O   ARG A  56       3.243 -19.966  -6.619  1.00 15.12           O  
ATOM    602  CB  ARG A  56       4.489 -22.716  -5.942  1.00 14.49           C  
ATOM    603  CG  ARG A  56       4.467 -24.036  -5.221  1.00 18.97           C  
ATOM    604  CD  ARG A  56       5.059 -25.084  -6.139  1.00 24.32           C  
ATOM    605  NE  ARG A  56       4.980 -26.427  -5.577  1.00 28.25           N  
ATOM    606  CZ  ARG A  56       3.935 -27.229  -5.739  1.00 29.76           C  
ATOM    607  NH1 ARG A  56       3.970 -28.446  -5.209  1.00 29.46           N  
ATOM    608  NH2 ARG A  56       2.867 -26.828  -6.454  1.00 29.33           N  
ATOM    609  N   PHE A  57       5.464 -19.669  -6.166  1.00 13.57           N  
ATOM    610  CA  PHE A  57       5.649 -18.573  -7.122  1.00 13.80           C  
ATOM    611  C   PHE A  57       6.537 -19.101  -8.235  1.00 14.11           C  
ATOM    612  O   PHE A  57       7.626 -19.597  -7.950  1.00 14.28           O  
ATOM    613  CB  PHE A  57       6.271 -17.363  -6.434  1.00 14.86           C  
ATOM    614  CG  PHE A  57       6.555 -16.222  -7.340  1.00 17.42           C  
ATOM    615  CD1 PHE A  57       5.637 -15.190  -7.473  1.00 17.81           C  
ATOM    616  CD2 PHE A  57       7.764 -16.157  -8.015  1.00 21.16           C  
ATOM    617  CE1 PHE A  57       5.886 -14.127  -8.299  1.00 19.83           C  
ATOM    618  CE2 PHE A  57       8.034 -15.093  -8.831  1.00 22.46           C  
ATOM    619  CZ  PHE A  57       7.074 -14.067  -8.987  1.00 21.13           C  
ATOM    620  N   ILE A  58       6.071 -19.018  -9.477  1.00 15.22           N  
ATOM    621  CA  ILE A  58       6.794 -19.639 -10.580  1.00 16.71           C  
ATOM    622  C   ILE A  58       7.031 -18.614 -11.686  1.00 17.58           C  
ATOM    623  O   ILE A  58       6.069 -17.982 -12.207  1.00 19.06           O  
ATOM    624  CB  ILE A  58       5.955 -20.794 -11.186  1.00 18.23           C  
ATOM    625  CG1 ILE A  58       5.524 -21.785 -10.106  1.00 19.20           C  
ATOM    626  CG2 ILE A  58       6.683 -21.384 -12.406  1.00 20.20           C  
ATOM    627  CD1 ILE A  58       6.614 -22.505  -9.452  1.00 24.21           C  
ATOM    628  N   LEU A  59       8.301 -18.513 -12.092  1.00 19.95           N  
ATOM    629  CA  LEU A  59       8.706 -17.736 -13.278  1.00 22.72           C  
ATOM    630  C   LEU A  59       9.609 -18.653 -14.066  1.00 24.91           C  
ATOM    631  O   LEU A  59       9.971 -19.711 -13.589  1.00 24.44           O  
ATOM    632  CB  LEU A  59       9.435 -16.451 -12.870  1.00 23.79           C  
ATOM    633  CG  LEU A  59       8.512 -15.309 -12.408  1.00 28.30           C  
ATOM    634  CD1 LEU A  59       9.342 -14.168 -11.858  1.00 31.37           C  
ATOM    635  CD2 LEU A  59       7.659 -14.877 -13.594  1.00 29.43           C  
ATOM    636  N   PRO A  60       9.943 -18.281 -15.309  1.00 26.36           N  
ATOM    637  CA  PRO A  60      10.838 -19.185 -16.037  1.00 28.11           C  
ATOM    638  C   PRO A  60      12.182 -19.382 -15.308  1.00 28.16           C  
ATOM    639  O   PRO A  60      12.720 -20.493 -15.289  1.00 29.56           O  
ATOM    640  CB  PRO A  60      10.982 -18.497 -17.402  1.00 28.52           C  
ATOM    641  CG  PRO A  60       9.716 -17.660 -17.526  1.00 28.28           C  
ATOM    642  CD  PRO A  60       9.487 -17.139 -16.134  1.00 27.54           C  
ATOM    643  N   ASP A  61      12.709 -18.351 -14.666  1.00 28.32           N  
ATOM    644  CA  ASP A  61      14.049 -18.440 -14.080  0.60 28.32           C  
ATOM    646  C   ASP A  61      14.069 -18.585 -12.570  1.00 28.15           C  
ATOM    647  O   ASP A  61      15.132 -18.440 -11.936  1.00 26.46           O  
ATOM    648  CB  ASP A  61      14.855 -17.207 -14.463  0.60 29.20           C  
ATOM    650  CG  ASP A  61      15.266 -17.218 -15.911  0.60 34.38           C  
ATOM    652  OD1 ASP A  61      15.783 -18.262 -16.378  0.60 31.70           O  
ATOM    654  OD2 ASP A  61      15.078 -16.168 -16.563  0.60 32.69           O  
ATOM    656  N   PHE A  62      12.901 -18.848 -11.984  1.00 26.32           N  
ATOM    657  CA  PHE A  62      12.807 -18.798 -10.543  1.00 24.34           C  
ATOM    658  C   PHE A  62      11.513 -19.427 -10.038  1.00 21.33           C  
ATOM    659  O   PHE A  62      10.421 -19.094 -10.544  1.00 22.25           O  
ATOM    660  CB  PHE A  62      12.863 -17.331 -10.094  1.00 25.79           C  
ATOM    661  CG  PHE A  62      12.766 -17.144  -8.638  1.00 28.75           C  
ATOM    662  CD1 PHE A  62      13.881 -17.337  -7.825  1.00 29.45           C  
ATOM    663  CD2 PHE A  62      11.547 -16.761  -8.052  1.00 29.52           C  
ATOM    664  CE1 PHE A  62      13.788 -17.152  -6.452  1.00 31.21           C  
ATOM    665  CE2 PHE A  62      11.452 -16.565  -6.684  1.00 30.79           C  
ATOM    666  CZ  PHE A  62      12.565 -16.772  -5.874  1.00 30.01           C  
ATOM    667  N   GLU A  63      11.635 -20.329  -9.064  1.00 17.67           N  
ATOM    668  CA  GLU A  63      10.455 -20.882  -8.367  1.00 16.32           C  
ATOM    669  C   GLU A  63      10.704 -20.844  -6.898  1.00 14.76           C  
ATOM    670  O   GLU A  63      11.825 -21.158  -6.462  1.00 14.96           O  
ATOM    671  CB  GLU A  63      10.223 -22.323  -8.748  1.00 17.76           C  
ATOM    672  CG  GLU A  63      10.099 -22.479 -10.263  1.00 20.15           C  
ATOM    673  CD  GLU A  63       9.596 -23.847 -10.661  1.00 26.07           C  
ATOM    674  OE1 GLU A  63       9.336 -24.692  -9.765  1.00 29.13           O  
ATOM    675  OE2 GLU A  63       9.499 -24.086 -11.895  1.00 31.19           O  
ATOM    676  N   GLU A  64       9.678 -20.534  -6.109  1.00 13.79           N  
ATOM    677  CA  GLU A  64       9.862 -20.538  -4.663  1.00 15.80           C  
ATOM    678  C   GLU A  64       8.567 -20.970  -4.006  1.00 13.72           C  
ATOM    679  O   GLU A  64       7.488 -20.725  -4.536  1.00 16.00           O  
ATOM    680  CB  GLU A  64      10.237 -19.144  -4.161  1.00 19.06           C  
ATOM    681  CG  GLU A  64      10.780 -19.114  -2.769  1.00 25.97           C  
ATOM    682  CD  GLU A  64      11.262 -17.737  -2.389  1.00 37.53           C  
ATOM    683  OE1 GLU A  64      10.651 -16.746  -2.865  1.00 34.80           O  
ATOM    684  OE2 GLU A  64      12.248 -17.674  -1.622  1.00 35.56           O  
ATOM    685  N   THR A  65       8.662 -21.655  -2.894  1.00 14.73           N  
ATOM    686  CA  THR A  65       7.432 -21.932  -2.143  0.60 14.66           C  
ATOM    688  C   THR A  65       7.228 -20.883  -1.070  1.00 14.42           C  
ATOM    689  O   THR A  65       8.175 -20.270  -0.551  1.00 16.05           O  
ATOM    690  CB  THR A  65       7.391 -23.271  -1.457  0.60 15.91           C  
ATOM    692  OG1 THR A  65       8.377 -23.280  -0.430  0.60 17.30           O  
ATOM    694  CG2 THR A  65       7.576 -24.426  -2.459  0.60 15.37           C  
HETATM  696  N   MSE A  66       5.946 -20.640  -0.765  1.00 13.11           N  
HETATM  697  CA  MSE A  66       5.525 -19.585   0.157  0.60 13.32           C  
HETATM  699  C   MSE A  66       4.630 -20.210   1.233  1.00 12.05           C  
HETATM  700  O   MSE A  66       3.425 -20.368   1.008  1.00 11.21           O  
HETATM  701  CB  MSE A  66       4.764 -18.521  -0.629  0.60 13.88           C  
HETATM  703  CG  MSE A  66       5.560 -17.979  -1.816  0.60 14.79           C  
HETATM  705 SE   MSE A  66       4.498 -16.897  -3.033  0.36 17.72          SE  
HETATM  707  CE  MSE A  66       5.997 -15.872  -3.748  0.60 21.72           C  
ATOM    709  N   PRO A  67       5.223 -20.634   2.345  1.00 11.90           N  
ATOM    710  CA  PRO A  67       4.405 -21.300   3.340  1.00 11.59           C  
ATOM    711  C   PRO A  67       3.296 -20.407   3.930  1.00 10.48           C  
ATOM    712  O   PRO A  67       3.476 -19.204   4.151  1.00 11.26           O  
ATOM    713  CB  PRO A  67       5.432 -21.735   4.406  1.00 13.54           C  
ATOM    714  CG  PRO A  67       6.744 -21.791   3.644  1.00 14.82           C  
ATOM    715  CD  PRO A  67       6.657 -20.670   2.678  1.00 13.74           C  
ATOM    716  N   PHE A  68       2.139 -21.013   4.174  1.00  9.96           N  
ATOM    717  CA  PHE A  68       1.073 -20.325   4.912  1.00 10.72           C  
ATOM    718  C   PHE A  68       1.517 -20.155   6.360  1.00 11.50           C  
ATOM    719  O   PHE A  68       2.013 -21.092   6.982  1.00 13.00           O  
ATOM    720  CB  PHE A  68      -0.221 -21.109   4.927  1.00 10.80           C  
ATOM    721  CG  PHE A  68      -0.847 -21.291   3.563  1.00  9.96           C  
ATOM    722  CD1 PHE A  68      -0.429 -20.558   2.436  1.00  9.18           C  
ATOM    723  CD2 PHE A  68      -1.898 -22.211   3.391  1.00  9.91           C  
ATOM    724  CE1 PHE A  68      -1.098 -20.683   1.204  1.00  9.97           C  
ATOM    725  CE2 PHE A  68      -2.515 -22.353   2.175  1.00 11.19           C  
ATOM    726  CZ  PHE A  68      -2.113 -21.616   1.049  1.00  9.32           C  
ATOM    727  N   THR A  69       1.297 -18.970   6.911  1.00 11.45           N  
ATOM    728  CA  THR A  69       1.595 -18.733   8.306  1.00 12.29           C  
ATOM    729  C   THR A  69       0.300 -18.759   9.118  1.00 12.75           C  
ATOM    730  O   THR A  69       0.349 -18.857  10.354  1.00 16.34           O  
ATOM    731  CB  THR A  69       2.306 -17.357   8.486  1.00 12.96           C  
ATOM    732  OG1 THR A  69       1.466 -16.324   7.924  1.00 13.83           O  
ATOM    733  CG2 THR A  69       3.685 -17.359   7.756  1.00 14.68           C  
ATOM    734  N   ASP A  70      -0.857 -18.706   8.458  1.00 12.25           N  
ATOM    735  CA  ASP A  70      -2.137 -18.871   9.150  1.00 13.36           C  
ATOM    736  C   ASP A  70      -3.195 -19.259   8.102  1.00 12.80           C  
ATOM    737  O   ASP A  70      -3.097 -18.877   6.926  1.00 12.50           O  
ATOM    738  CB  ASP A  70      -2.550 -17.586   9.832  1.00 15.40           C  
ATOM    739  CG  ASP A  70      -3.131 -17.852  11.216  1.00 20.14           C  
ATOM    740  OD1 ASP A  70      -3.372 -19.045  11.576  1.00 21.35           O  
ATOM    741  OD2 ASP A  70      -3.290 -16.879  11.948  1.00 23.82           O  
ATOM    742  N   TYR A  71      -4.200 -20.012   8.526  1.00 13.67           N  
ATOM    743  CA  TYR A  71      -5.164 -20.579   7.601  1.00 13.11           C  
ATOM    744  C   TYR A  71      -6.469 -20.861   8.328  1.00 13.94           C  
ATOM    745  O   TYR A  71      -6.469 -21.628   9.277  1.00 15.31           O  
ATOM    746  CB  TYR A  71      -4.613 -21.901   7.025  1.00 14.26           C  
ATOM    747  CG  TYR A  71      -5.497 -22.506   5.963  1.00 13.19           C  
ATOM    748  CD1 TYR A  71      -5.289 -22.248   4.597  1.00 14.40           C  
ATOM    749  CD2 TYR A  71      -6.519 -23.405   6.306  1.00 15.45           C  
ATOM    750  CE1 TYR A  71      -6.108 -22.839   3.601  1.00 15.80           C  
ATOM    751  CE2 TYR A  71      -7.326 -23.980   5.329  1.00 15.06           C  
ATOM    752  CZ  TYR A  71      -7.101 -23.713   3.990  1.00 16.52           C  
ATOM    753  OH  TYR A  71      -7.885 -24.272   3.014  1.00 20.46           O  
ATOM    754  N   ALA A  72      -7.545 -20.181   7.918  1.00 13.36           N  
ATOM    755  CA  ALA A  72      -8.882 -20.519   8.420  1.00 13.36           C  
ATOM    756  C   ALA A  72      -9.821 -20.498   7.234  1.00 12.70           C  
ATOM    757  O   ALA A  72     -10.040 -19.458   6.650  1.00 12.12           O  
ATOM    758  CB  ALA A  72      -9.335 -19.546   9.492  1.00 14.11           C  
ATOM    759  N   GLU A  73     -10.334 -21.678   6.868  1.00 14.09           N  
ATOM    760  CA  GLU A  73     -11.195 -21.831   5.711  0.50 14.37           C  
ATOM    762  C   GLU A  73     -12.244 -20.746   5.624  1.00 14.62           C  
ATOM    763  O   GLU A  73     -13.050 -20.545   6.558  1.00 13.96           O  
ATOM    764  CB  GLU A  73     -11.882 -23.193   5.788  0.50 15.88           C  
ATOM    766  CG  GLU A  73     -12.643 -23.619   4.562  0.50 17.94           C  
ATOM    768  CD  GLU A  73     -13.246 -24.994   4.750  0.50 29.69           C  
ATOM    770  OE1 GLU A  73     -14.090 -25.390   3.931  0.50 25.70           O  
ATOM    772  OE2 GLU A  73     -12.870 -25.677   5.749  0.50 22.48           O  
ATOM    774  N   GLU A  74     -12.257 -20.044   4.498  1.00 14.01           N  
ATOM    775  CA  GLU A  74     -13.258 -19.010   4.161  1.00 14.64           C  
ATOM    776  C   GLU A  74     -13.232 -17.792   5.081  1.00 13.66           C  
ATOM    777  O   GLU A  74     -14.187 -16.999   5.085  1.00 15.30           O  
ATOM    778  CB  GLU A  74     -14.693 -19.605   4.010  1.00 14.01           C  
ATOM    779  CG  GLU A  74     -14.730 -20.676   2.946  1.00 16.50           C  
ATOM    780  CD  GLU A  74     -16.017 -21.491   2.896  1.00 18.46           C  
ATOM    781  OE1 GLU A  74     -16.760 -21.554   3.901  1.00 22.39           O  
ATOM    782  OE2 GLU A  74     -16.290 -22.048   1.806  1.00 21.49           O  
ATOM    783  N   LYS A  75     -12.116 -17.606   5.803  1.00 12.53           N  
ATOM    784  CA  LYS A  75     -12.007 -16.535   6.781  0.60 14.54           C  
ATOM    786  C   LYS A  75     -10.698 -15.743   6.598  1.00 13.19           C  
ATOM    787  O   LYS A  75     -10.719 -14.530   6.439  1.00 14.97           O  
ATOM    788  CB  LYS A  75     -12.061 -17.132   8.206  0.60 14.41           C  
ATOM    790  CG  LYS A  75     -13.415 -17.790   8.656  0.60 16.44           C  
ATOM    792  CD  LYS A  75     -13.333 -18.308  10.108  0.60 17.03           C  
ATOM    794  CE  LYS A  75     -13.052 -19.849  10.311  0.60 22.26           C  
ATOM    796  NZ  LYS A  75     -13.418 -20.934   9.272  0.60 21.96           N  
ATOM    798  N   TYR A  76      -9.563 -16.438   6.699  1.00 12.50           N  
ATOM    799  CA  TYR A  76      -8.281 -15.715   6.573  1.00 12.63           C  
ATOM    800  C   TYR A  76      -7.147 -16.598   6.122  1.00 12.04           C  
ATOM    801  O   TYR A  76      -7.217 -17.825   6.251  1.00 11.27           O  
ATOM    802  CB  TYR A  76      -7.870 -14.958   7.834  1.00 14.98           C  
ATOM    803  CG  TYR A  76      -7.807 -15.801   9.066  1.00 14.64           C  
ATOM    804  CD1 TYR A  76      -8.839 -15.759  10.033  1.00 16.02           C  
ATOM    805  CD2 TYR A  76      -6.713 -16.618   9.319  1.00 17.16           C  
ATOM    806  CE1 TYR A  76      -8.759 -16.551  11.230  1.00 18.44           C  
ATOM    807  CE2 TYR A  76      -6.624 -17.394  10.499  1.00 18.63           C  
ATOM    808  CZ  TYR A  76      -7.642 -17.362  11.442  1.00 19.83           C  
ATOM    809  OH  TYR A  76      -7.515 -18.173  12.569  1.00 22.27           O  
ATOM    810  N   LEU A  77      -6.119 -15.940   5.579  1.00 11.24           N  
ATOM    811  CA  LEU A  77      -4.961 -16.624   5.015  1.00 10.17           C  
ATOM    812  C   LEU A  77      -3.759 -15.727   5.175  1.00  9.35           C  
ATOM    813  O   LEU A  77      -3.785 -14.590   4.706  1.00 10.70           O  
ATOM    814  CB  LEU A  77      -5.172 -16.886   3.503  1.00 10.76           C  
ATOM    815  CG  LEU A  77      -4.060 -17.647   2.813  1.00 11.89           C  
ATOM    816  CD1 LEU A  77      -3.913 -19.118   3.343  1.00 11.07           C  
ATOM    817  CD2 LEU A  77      -4.306 -17.674   1.300  1.00 12.21           C  
ATOM    818  N   GLY A  78      -2.717 -16.231   5.843  1.00  9.17           N  
ATOM    819  CA  GLY A  78      -1.462 -15.508   5.908  1.00  9.68           C  
ATOM    820  C   GLY A  78      -0.409 -16.306   5.166  1.00 10.31           C  
ATOM    821  O   GLY A  78      -0.351 -17.521   5.280  1.00 10.56           O  
ATOM    822  N   VAL A  79       0.414 -15.614   4.395  1.00  9.02           N  
ATOM    823  CA  VAL A  79       1.404 -16.261   3.490  1.00  8.75           C  
ATOM    824  C   VAL A  79       2.737 -15.551   3.558  1.00 10.03           C  
ATOM    825  O   VAL A  79       2.778 -14.325   3.637  1.00  9.54           O  
ATOM    826  CB  VAL A  79       0.895 -16.252   1.989  1.00  9.48           C  
ATOM    827  CG1 VAL A  79       1.737 -17.198   1.160  1.00 10.40           C  
ATOM    828  CG2 VAL A  79      -0.564 -16.645   1.876  1.00 10.72           C  
ATOM    829  N   THR A  80       3.797 -16.337   3.579  1.00 10.46           N  
ATOM    830  CA  THR A  80       5.106 -15.700   3.533  0.60 12.46           C  
ATOM    832  C   THR A  80       5.296 -15.053   2.165  1.00 11.97           C  
ATOM    833  O   THR A  80       4.852 -15.504   1.128  1.00 13.09           O  
ATOM    834  CB  THR A  80       6.268 -16.568   4.094  0.60 13.77           C  
ATOM    836  OG1 THR A  80       7.392 -16.684   3.221  0.60 17.13           O  
ATOM    838  CG2 THR A  80       5.793 -17.850   4.711  0.60  7.62           C  
ATOM    840  N   TRP A  81       5.910 -13.876   2.203  1.00 12.77           N  
ATOM    841  CA  TRP A  81       6.097 -13.120   0.978  1.00 12.93           C  
ATOM    842  C   TRP A  81       7.434 -12.374   1.033  1.00 14.32           C  
ATOM    843  O   TRP A  81       7.585 -11.457   1.842  1.00 13.43           O  
ATOM    844  CB  TRP A  81       4.968 -12.131   0.776  1.00 14.30           C  
ATOM    845  CG  TRP A  81       5.063 -11.437  -0.530  1.00 14.24           C  
ATOM    846  CD1 TRP A  81       5.443 -10.140  -0.747  1.00 13.33           C  
ATOM    847  CD2 TRP A  81       4.739 -11.990  -1.790  1.00 15.33           C  
ATOM    848  NE1 TRP A  81       5.424  -9.869  -2.104  1.00 16.05           N  
ATOM    849  CE2 TRP A  81       4.971 -10.992  -2.766  1.00 17.25           C  
ATOM    850  CE3 TRP A  81       4.229 -13.235  -2.191  1.00 19.89           C  
ATOM    851  CZ2 TRP A  81       4.721 -11.211  -4.136  1.00 20.03           C  
ATOM    852  CZ3 TRP A  81       3.975 -13.449  -3.542  1.00 20.60           C  
ATOM    853  CH2 TRP A  81       4.246 -12.448  -4.511  1.00 20.68           C  
ATOM    854  N   ASP A  82       8.393 -12.792   0.207  1.00 15.86           N  
ATOM    855  CA  ASP A  82       9.732 -12.151   0.228  1.00 17.49           C  
ATOM    856  C   ASP A  82      10.190 -12.399   1.702  1.00 17.06           C  
ATOM    857  O   ASP A  82      10.062 -13.525   2.258  1.00 17.91           O  
ATOM    858  CB  ASP A  82       9.596 -10.640  -0.163  1.00 18.66           C  
ATOM    859  CG  ASP A  82      10.902  -9.980  -0.665  1.00 23.65           C  
ATOM    860  OD1 ASP A  82      11.849  -9.853   0.138  1.00 23.04           O  
ATOM    861  OD2 ASP A  82      10.928  -9.496  -1.848  1.00 29.82           O  
ATOM    862  N   THR A  83      10.713 -11.373   2.375  1.00 17.46           N  
ATOM    863  CA  THR A  83      11.155 -11.549   3.769  1.00 17.14           C  
ATOM    864  C   THR A  83      10.054 -11.158   4.771  1.00 16.56           C  
ATOM    865  O   THR A  83      10.289 -11.117   5.976  1.00 17.50           O  
ATOM    866  CB  THR A  83      12.392 -10.668   4.049  1.00 16.72           C  
ATOM    867  OG1 THR A  83      12.012  -9.300   3.865  1.00 17.72           O  
ATOM    868  CG2 THR A  83      13.626 -11.054   3.141  1.00 19.64           C  
ATOM    869  N   GLY A  84       8.847 -10.860   4.271  1.00 13.68           N  
ATOM    870  CA  GLY A  84       7.719 -10.491   5.139  1.00 14.21           C  
ATOM    871  C   GLY A  84       6.523 -11.414   4.963  1.00 12.51           C  
ATOM    872  O   GLY A  84       6.679 -12.606   4.716  1.00 12.45           O  
ATOM    873  N   ILE A  85       5.333 -10.822   5.124  1.00 11.62           N  
ATOM    874  CA  ILE A  85       4.057 -11.560   5.188  0.60 11.23           C  
ATOM    876  C   ILE A  85       2.983 -10.789   4.491  1.00 11.17           C  
ATOM    877  O   ILE A  85       2.948  -9.566   4.560  1.00 11.89           O  
ATOM    878  CB  ILE A  85       3.574 -11.669   6.661  0.60 12.05           C  
ATOM    880  CG1 ILE A  85       4.659 -12.364   7.466  0.60 12.78           C  
ATOM    882  CG2 ILE A  85       2.106 -12.293   6.773  0.60 10.86           C  
ATOM    884  CD1 ILE A  85       4.619 -13.890   7.299  0.60 11.90           C  
ATOM    886  N   ILE A  86       2.112 -11.502   3.784  1.00 10.19           N  
ATOM    887  CA  ILE A  86       0.829 -10.936   3.300  1.00 10.22           C  
ATOM    888  C   ILE A  86      -0.302 -11.642   4.021  1.00  9.57           C  
ATOM    889  O   ILE A  86      -0.187 -12.840   4.422  1.00 10.87           O  
ATOM    890  CB  ILE A  86       0.670 -11.124   1.788  1.00 10.32           C  
ATOM    891  CG1 ILE A  86       0.718 -12.611   1.401  1.00 11.00           C  
ATOM    892  CG2 ILE A  86       1.741 -10.261   1.024  1.00 11.75           C  
ATOM    893  CD1 ILE A  86       0.627 -12.793  -0.148  1.00 11.71           C  
ATOM    894  N   TYR A  87      -1.416 -10.930   4.201  1.00 10.24           N  
ATOM    895  CA  TYR A  87      -2.542 -11.456   5.013  1.00  9.63           C  
ATOM    896  C   TYR A  87      -3.842 -11.017   4.371  1.00  9.68           C  
ATOM    897  O   TYR A  87      -4.015  -9.824   4.078  1.00 11.01           O  
ATOM    898  CB  TYR A  87      -2.410 -10.967   6.462  1.00 11.47           C  
ATOM    899  CG  TYR A  87      -3.331 -11.651   7.413  1.00 12.86           C  
ATOM    900  CD1 TYR A  87      -2.955 -12.872   7.961  1.00 13.85           C  
ATOM    901  CD2 TYR A  87      -4.537 -11.069   7.792  1.00 13.67           C  
ATOM    902  CE1 TYR A  87      -3.818 -13.535   8.881  1.00 14.33           C  
ATOM    903  CE2 TYR A  87      -5.369 -11.688   8.703  1.00 14.78           C  
ATOM    904  CZ  TYR A  87      -5.020 -12.923   9.224  1.00 14.65           C  
ATOM    905  OH  TYR A  87      -5.894 -13.462  10.170  1.00 19.42           O  
ATOM    906  N   PHE A  88      -4.724 -12.001   4.129  1.00  9.85           N  
ATOM    907  CA  PHE A  88      -6.052 -11.777   3.542  1.00  9.90           C  
ATOM    908  C   PHE A  88      -7.083 -12.071   4.626  1.00 10.51           C  
ATOM    909  O   PHE A  88      -7.102 -13.153   5.183  1.00 12.46           O  
ATOM    910  CB  PHE A  88      -6.284 -12.713   2.352  1.00 10.38           C  
ATOM    911  CG  PHE A  88      -5.240 -12.584   1.273  1.00  9.19           C  
ATOM    912  CD1 PHE A  88      -5.448 -11.745   0.148  1.00 10.58           C  
ATOM    913  CD2 PHE A  88      -4.032 -13.318   1.338  1.00 11.14           C  
ATOM    914  CE1 PHE A  88      -4.464 -11.651  -0.863  1.00 11.34           C  
ATOM    915  CE2 PHE A  88      -3.030 -13.176   0.331  1.00 10.27           C  
ATOM    916  CZ  PHE A  88      -3.268 -12.334  -0.760  1.00 11.44           C  
ATOM    917  N   ASP A  89      -7.960 -11.115   4.873  1.00 10.81           N  
ATOM    918  CA  ASP A  89      -9.034 -11.250   5.863  1.00 11.72           C  
ATOM    919  C   ASP A  89     -10.366 -10.993   5.159  1.00 11.34           C  
ATOM    920  O   ASP A  89     -10.602  -9.902   4.614  1.00 12.70           O  
ATOM    921  CB  ASP A  89      -8.797 -10.171   6.920  1.00 13.59           C  
ATOM    922  CG  ASP A  89      -9.597 -10.371   8.154  1.00 18.29           C  
ATOM    923  OD1 ASP A  89     -10.395 -11.325   8.214  1.00 22.03           O  
ATOM    924  OD2 ASP A  89      -9.356  -9.566   9.107  1.00 23.09           O  
ATOM    925  N   LEU A  90     -11.193 -12.028   5.100  1.00 12.00           N  
ATOM    926  CA  LEU A  90     -12.442 -11.937   4.357  0.60 12.11           C  
ATOM    928  C   LEU A  90     -13.549 -11.533   5.337  1.00 13.20           C  
ATOM    929  O   LEU A  90     -13.956 -12.336   6.134  1.00 14.78           O  
ATOM    930  CB  LEU A  90     -12.738 -13.297   3.686  0.60 13.74           C  
ATOM    932  CG  LEU A  90     -11.862 -13.682   2.479  0.60 13.17           C  
ATOM    934  CD1 LEU A  90     -10.389 -14.018   2.823  0.60 14.28           C  
ATOM    936  CD2 LEU A  90     -12.473 -14.866   1.697  0.60 13.82           C  
ATOM    938  N   LYS A  91     -13.973 -10.288   5.262  1.00 12.54           N  
ATOM    939  CA  LYS A  91     -14.993  -9.776   6.180  0.60 13.93           C  
ATOM    941  C   LYS A  91     -16.344  -9.704   5.446  1.00 14.48           C  
ATOM    942  O   LYS A  91     -16.498  -8.980   4.479  1.00 16.23           O  
ATOM    943  CB  LYS A  91     -14.554  -8.397   6.708  0.60 14.55           C  
ATOM    945  CG  LYS A  91     -13.299  -8.433   7.610  0.60 16.95           C  
ATOM    947  CD  LYS A  91     -12.979  -7.028   8.157  0.60 17.26           C  
ATOM    949  CE  LYS A  91     -11.648  -6.982   8.930  0.60 19.45           C  
ATOM    951  NZ  LYS A  91     -11.224  -5.611   9.390  0.60 23.73           N  
ATOM    953  N   GLU A  92     -17.342 -10.453   5.912  1.00 14.56           N  
ATOM    954  CA  GLU A  92     -18.672 -10.427   5.263  1.00 15.74           C  
ATOM    955  C   GLU A  92     -19.324  -9.079   5.515  1.00 14.72           C  
ATOM    956  O   GLU A  92     -19.377  -8.613   6.697  1.00 16.84           O  
ATOM    957  CB  GLU A  92     -19.545 -11.583   5.802  1.00 16.74           C  
ATOM    958  CG  GLU A  92     -20.872 -11.686   5.066  1.00 17.70           C  
ATOM    959  CD  GLU A  92     -21.541 -13.036   5.227  1.00 19.16           C  
ATOM    960  OE1 GLU A  92     -20.818 -14.084   5.297  1.00 20.80           O  
ATOM    961  OE2 GLU A  92     -22.805 -13.047   5.223  1.00 18.96           O  
ATOM    962  N   GLN A  93     -19.828  -8.432   4.452  1.00 15.66           N  
ATOM    963  CA  GLN A  93     -20.554  -7.170   4.622  1.00 17.26           C  
ATOM    964  C   GLN A  93     -22.037  -7.475   4.501  1.00 17.91           C  
ATOM    965  O   GLN A  93     -22.840  -6.847   5.178  1.00 20.04           O  
ATOM    966  CB  GLN A  93     -20.165  -6.139   3.580  1.00 17.75           C  
ATOM    967  CG  GLN A  93     -18.665  -5.907   3.570  1.00 21.04           C  
ATOM    968  CD  GLN A  93     -18.124  -5.207   4.830  1.00 27.47           C  
ATOM    969  OE1 GLN A  93     -18.257  -3.972   5.005  1.00 29.00           O  
ATOM    970  NE2 GLN A  93     -17.461  -5.984   5.683  1.00 28.28           N  
ATOM    971  N   ALA A  94     -22.366  -8.415   3.618  1.00 17.82           N  
ATOM    972  CA  ALA A  94     -23.755  -8.875   3.310  1.00 19.04           C  
ATOM    973  C   ALA A  94     -23.622 -10.257   2.665  1.00 20.78           C  
ATOM    974  O   ALA A  94     -22.506 -10.706   2.408  1.00 20.18           O  
ATOM    975  CB  ALA A  94     -24.437  -7.888   2.390  1.00 20.46           C  
ATOM    976  N   PRO A  95     -24.751 -10.999   2.457  1.00 21.12           N  
ATOM    977  CA  PRO A  95     -24.566 -12.411   2.010  1.00 20.50           C  
ATOM    978  C   PRO A  95     -23.729 -12.562   0.713  1.00 20.26           C  
ATOM    979  O   PRO A  95     -23.041 -13.593   0.475  1.00 21.08           O  
ATOM    980  CB  PRO A  95     -26.030 -12.898   1.814  1.00 21.00           C  
ATOM    981  CG  PRO A  95     -26.812 -12.030   2.879  1.00 23.02           C  
ATOM    982  CD  PRO A  95     -26.175 -10.667   2.703  1.00 22.79           C  
ATOM    983  N   HIS A  96     -23.811 -11.535  -0.119  1.00 18.22           N  
ATOM    984  CA  HIS A  96     -23.095 -11.525  -1.400  1.00 18.02           C  
ATOM    985  C   HIS A  96     -22.181 -10.316  -1.533  1.00 17.34           C  
ATOM    986  O   HIS A  96     -21.897  -9.868  -2.640  1.00 17.50           O  
ATOM    987  CB  HIS A  96     -24.116 -11.606  -2.544  1.00 19.29           C  
ATOM    988  CG  HIS A  96     -24.866 -12.898  -2.527  1.00 25.21           C  
ATOM    989  ND1 HIS A  96     -24.265 -14.108  -2.811  1.00 29.14           N  
ATOM    990  CD2 HIS A  96     -26.147 -13.179  -2.189  1.00 31.26           C  
ATOM    991  CE1 HIS A  96     -25.155 -15.080  -2.669  1.00 32.76           C  
ATOM    992  NE2 HIS A  96     -26.304 -14.540  -2.304  1.00 32.07           N  
ATOM    993  N   GLN A  97     -21.695  -9.811  -0.387  1.00 15.78           N  
ATOM    994  CA  GLN A  97     -20.755  -8.703  -0.426  1.00 16.45           C  
ATOM    995  C   GLN A  97     -19.681  -8.914   0.594  1.00 15.05           C  
ATOM    996  O   GLN A  97     -19.972  -9.172   1.750  1.00 16.30           O  
ATOM    997  CB  GLN A  97     -21.438  -7.378  -0.160  1.00 17.50           C  
ATOM    998  CG  GLN A  97     -22.522  -7.102  -1.162  1.00 23.01           C  
ATOM    999  CD  GLN A  97     -23.226  -5.785  -0.938  1.00 33.53           C  
ATOM   1000  OE1 GLN A  97     -22.597  -4.715  -0.983  1.00 38.15           O  
ATOM   1001  NE2 GLN A  97     -24.550  -5.845  -0.718  1.00 35.42           N  
ATOM   1002  N   THR A  98     -18.425  -8.804   0.173  1.00 14.01           N  
ATOM   1003  CA  THR A  98     -17.320  -9.052   1.073  1.00 13.75           C  
ATOM   1004  C   THR A  98     -16.390  -7.858   1.055  1.00 12.44           C  
ATOM   1005  O   THR A  98     -16.215  -7.226   0.022  1.00 12.96           O  
ATOM   1006  CB  THR A  98     -16.530 -10.258   0.585  1.00 15.31           C  
ATOM   1007  OG1 THR A  98     -17.373 -11.406   0.629  1.00 18.70           O  
ATOM   1008  CG2 THR A  98     -15.245 -10.509   1.430  1.00 16.39           C  
ATOM   1009  N   LEU A  99     -15.792  -7.552   2.204  1.00 12.26           N  
ATOM   1010  CA  LEU A  99     -14.675  -6.629   2.248  0.60 12.68           C  
ATOM   1012  C   LEU A  99     -13.444  -7.472   2.455  1.00 13.06           C  
ATOM   1013  O   LEU A  99     -13.253  -8.072   3.516  1.00 14.46           O  
ATOM   1014  CB  LEU A  99     -14.847  -5.636   3.390  0.60 14.68           C  
ATOM   1016  CG  LEU A  99     -13.830  -4.492   3.415  0.60 14.19           C  
ATOM   1018  CD1 LEU A  99     -14.090  -3.591   2.218  0.60 12.14           C  
ATOM   1020  CD2 LEU A  99     -14.025  -3.716   4.707  0.60 16.84           C  
ATOM   1022  N   LEU A 100     -12.618  -7.522   1.417  1.00 11.82           N  
ATOM   1023  CA  LEU A 100     -11.351  -8.251   1.519  1.00 12.81           C  
ATOM   1024  C   LEU A 100     -10.356  -7.243   2.068  1.00 13.07           C  
ATOM   1025  O   LEU A 100     -10.100  -6.230   1.414  1.00 13.12           O  
ATOM   1026  CB  LEU A 100     -10.930  -8.778   0.131  1.00 12.79           C  
ATOM   1027  CG  LEU A 100      -9.535  -9.432   0.040  1.00 14.56           C  
ATOM   1028  CD1 LEU A 100      -9.390 -10.654   0.934  1.00 19.09           C  
ATOM   1029  CD2 LEU A 100      -9.273  -9.905  -1.401  1.00 15.99           C  
ATOM   1030  N   VAL A 101      -9.835  -7.509   3.273  1.00 12.09           N  
ATOM   1031  CA  VAL A 101      -8.877  -6.626   3.917  1.00 12.57           C  
ATOM   1032  C   VAL A 101      -7.508  -7.283   3.721  1.00 12.49           C  
ATOM   1033  O   VAL A 101      -7.245  -8.409   4.182  1.00 12.13           O  
ATOM   1034  CB  VAL A 101      -9.208  -6.365   5.397  1.00 13.67           C  
ATOM   1035  CG1 VAL A 101      -8.162  -5.373   5.986  1.00 15.61           C  
ATOM   1036  CG2 VAL A 101     -10.561  -5.745   5.479  1.00 13.76           C  
ATOM   1037  N   PHE A 102      -6.637  -6.588   3.013  1.00 11.33           N  
ATOM   1038  CA  PHE A 102      -5.279  -7.075   2.719  1.00 10.90           C  
ATOM   1039  C   PHE A 102      -4.306  -6.319   3.611  1.00 11.36           C  
ATOM   1040  O   PHE A 102      -4.391  -5.081   3.714  1.00 12.62           O  
ATOM   1041  CB  PHE A 102      -4.931  -6.833   1.237  1.00 11.02           C  
ATOM   1042  CG  PHE A 102      -3.505  -7.193   0.865  1.00 10.48           C  
ATOM   1043  CD1 PHE A 102      -3.185  -8.501   0.487  1.00 10.62           C  
ATOM   1044  CD2 PHE A 102      -2.501  -6.209   0.867  1.00 10.63           C  
ATOM   1045  CE1 PHE A 102      -1.894  -8.811   0.101  1.00 11.04           C  
ATOM   1046  CE2 PHE A 102      -1.206  -6.533   0.499  1.00 10.72           C  
ATOM   1047  CZ  PHE A 102      -0.898  -7.853   0.123  1.00 11.25           C  
ATOM   1048  N   SER A 103      -3.384  -7.033   4.256  1.00  9.92           N  
ATOM   1049  CA  SER A 103      -2.341  -6.317   4.990  1.00 11.33           C  
ATOM   1050  C   SER A 103      -0.993  -7.005   4.805  1.00 10.50           C  
ATOM   1051  O   SER A 103      -0.943  -8.194   4.381  1.00 10.63           O  
ATOM   1052  CB  SER A 103      -2.713  -6.198   6.447  1.00 13.57           C  
ATOM   1053  OG  SER A 103      -2.964  -7.460   7.033  1.00 14.71           O  
ATOM   1054  N   GLU A 104       0.089  -6.225   4.949  1.00 10.27           N  
ATOM   1055  CA  GLU A 104       1.399  -6.758   4.584  1.00 10.10           C  
ATOM   1056  C   GLU A 104       2.474  -6.155   5.472  1.00  9.86           C  
ATOM   1057  O   GLU A 104       2.405  -4.963   5.822  1.00 10.60           O  
ATOM   1058  CB  GLU A 104       1.687  -6.411   3.116  1.00  9.63           C  
ATOM   1059  CG  GLU A 104       3.039  -6.919   2.583  1.00 11.23           C  
ATOM   1060  CD  GLU A 104       3.332  -6.550   1.138  1.00 11.82           C  
ATOM   1061  OE1 GLU A 104       2.654  -5.667   0.559  1.00 13.30           O  
ATOM   1062  OE2 GLU A 104       4.319  -7.128   0.607  1.00 13.41           O  
ATOM   1063  N   SER A 105       3.471  -6.982   5.813  1.00 10.89           N  
ATOM   1064  CA  SER A 105       4.675  -6.539   6.568  0.70 11.75           C  
ATOM   1066  C   SER A 105       5.831  -6.574   5.591  1.00 12.00           C  
ATOM   1067  O   SER A 105       6.079  -7.635   4.977  1.00 13.23           O  
ATOM   1068  CB  SER A 105       4.965  -7.470   7.751  0.70 13.09           C  
ATOM   1070  OG  SER A 105       6.175  -7.102   8.423  0.70 13.52           O  
ATOM   1072  N   LEU A 106       6.544  -5.457   5.472  1.00 11.61           N  
ATOM   1073  CA  LEU A 106       7.701  -5.329   4.574  1.00 12.44           C  
ATOM   1074  C   LEU A 106       8.926  -4.844   5.337  1.00 14.61           C  
ATOM   1075  O   LEU A 106       9.137  -3.643   5.520  1.00 13.62           O  
ATOM   1076  CB  LEU A 106       7.399  -4.362   3.392  1.00 11.58           C  
ATOM   1077  CG  LEU A 106       6.108  -4.642   2.607  1.00 12.48           C  
ATOM   1078  CD1 LEU A 106       4.868  -3.923   3.208  1.00 14.10           C  
ATOM   1079  CD2 LEU A 106       6.317  -4.206   1.168  1.00 13.46           C  
ATOM   1080  N   PRO A 107       9.701  -5.798   5.833  1.00 13.44           N  
ATOM   1081  CA  PRO A 107      10.918  -5.414   6.559  1.00 15.16           C  
ATOM   1082  C   PRO A 107      11.911  -4.739   5.639  1.00 17.37           C  
ATOM   1083  O   PRO A 107      11.783  -4.802   4.395  1.00 16.84           O  
ATOM   1084  CB  PRO A 107      11.451  -6.756   7.070  1.00 16.41           C  
ATOM   1085  CG  PRO A 107      10.258  -7.671   7.093  1.00 15.63           C  
ATOM   1086  CD  PRO A 107       9.497  -7.272   5.849  1.00 14.98           C  
ATOM   1087  N   GLU A 108      12.885  -4.094   6.280  1.00 19.80           N  
ATOM   1088  CA  GLU A 108      13.872  -3.296   5.548  0.60 21.02           C  
ATOM   1090  C   GLU A 108      14.745  -4.127   4.593  1.00 21.18           C  
ATOM   1091  O   GLU A 108      15.251  -3.579   3.589  1.00 22.53           O  
ATOM   1092  CB  GLU A 108      14.731  -2.455   6.525  0.60 22.55           C  
ATOM   1094  CG  GLU A 108      15.597  -1.352   5.890  0.60 26.33           C  
ATOM   1096  CD  GLU A 108      16.960  -1.864   5.423  0.60 27.40           C  
ATOM   1098  OE1 GLU A 108      17.375  -2.940   5.918  0.60 32.01           O  
ATOM   1100  OE2 GLU A 108      17.605  -1.205   4.561  0.60 34.42           O  
ATOM   1102  N   ASN A 109      14.885  -5.442   4.874  1.00 20.11           N  
ATOM   1103  CA  ASN A 109      15.643  -6.327   3.976  1.00 20.33           C  
ATOM   1104  C   ASN A 109      14.855  -6.909   2.787  1.00 19.86           C  
ATOM   1105  O   ASN A 109      15.371  -7.752   2.046  1.00 20.12           O  
ATOM   1106  CB  ASN A 109      16.354  -7.446   4.767  1.00 20.22           C  
ATOM   1107  CG  ASN A 109      15.405  -8.460   5.357  1.00 22.95           C  
ATOM   1108  OD1 ASN A 109      15.842  -9.546   5.803  1.00 25.96           O  
ATOM   1109  ND2 ASN A 109      14.115  -8.158   5.352  1.00 19.75           N  
ATOM   1110  N   PHE A 110      13.624  -6.414   2.572  1.00 19.02           N  
ATOM   1111  CA  PHE A 110      12.873  -6.823   1.398  1.00 18.63           C  
ATOM   1112  C   PHE A 110      13.748  -6.727   0.177  1.00 20.00           C  
ATOM   1113  O   PHE A 110      14.442  -5.715  -0.028  1.00 21.43           O  
ATOM   1114  CB  PHE A 110      11.714  -5.861   1.170  1.00 17.92           C  
ATOM   1115  CG  PHE A 110      10.417  -6.535   1.003  1.00 16.62           C  
ATOM   1116  CD1 PHE A 110       9.877  -7.252   2.064  1.00 18.00           C  
ATOM   1117  CD2 PHE A 110       9.716  -6.411  -0.166  1.00 18.75           C  
ATOM   1118  CE1 PHE A 110       8.645  -7.857   1.964  1.00 20.59           C  
ATOM   1119  CE2 PHE A 110       8.485  -7.028  -0.290  1.00 19.82           C  
ATOM   1120  CZ  PHE A 110       7.942  -7.733   0.806  1.00 18.64           C  
ATOM   1121  N   THR A 111      13.695  -7.750  -0.660  1.00 21.30           N  
ATOM   1122  CA  THR A 111      14.513  -7.777  -1.863  1.00 25.08           C  
ATOM   1123  C   THR A 111      14.008  -6.846  -2.976  1.00 25.69           C  
ATOM   1124  O   THR A 111      14.809  -6.249  -3.692  1.00 29.92           O  
ATOM   1125  CB  THR A 111      14.750  -9.235  -2.352  1.00 26.50           C  
ATOM   1126  OG1 THR A 111      13.527  -9.798  -2.784  1.00 30.05           O  
ATOM   1127  CG2 THR A 111      15.263 -10.067  -1.223  1.00 27.96           C  
ATOM   1128  N   THR A 112      12.701  -6.691  -3.109  1.00 24.74           N  
ATOM   1129  CA  THR A 112      12.090  -5.777  -4.091  1.00 22.84           C  
ATOM   1130  C   THR A 112      11.939  -4.411  -3.383  1.00 20.55           C  
ATOM   1131  O   THR A 112      11.572  -4.385  -2.199  1.00 20.67           O  
ATOM   1132  CB  THR A 112      10.680  -6.299  -4.431  1.00 23.10           C  
ATOM   1133  OG1 THR A 112      10.775  -7.607  -5.023  1.00 28.18           O  
ATOM   1134  CG2 THR A 112       9.924  -5.340  -5.375  1.00 25.04           C  
ATOM   1135  N   PRO A 113      12.162  -3.279  -4.087  1.00 18.12           N  
ATOM   1136  CA  PRO A 113      11.875  -1.992  -3.397  1.00 16.73           C  
ATOM   1137  C   PRO A 113      10.431  -2.004  -2.886  1.00 15.94           C  
ATOM   1138  O   PRO A 113       9.524  -2.428  -3.607  1.00 15.57           O  
ATOM   1139  CB  PRO A 113      12.088  -0.939  -4.473  1.00 16.90           C  
ATOM   1140  CG  PRO A 113      13.097  -1.632  -5.453  1.00 18.82           C  
ATOM   1141  CD  PRO A 113      12.677  -3.081  -5.463  1.00 17.20           C  
ATOM   1142  N   ARG A 114      10.258  -1.623  -1.638  1.00 13.07           N  
ATOM   1143  CA  ARG A 114       8.943  -1.846  -0.995  1.00 13.71           C  
ATOM   1144  C   ARG A 114       7.800  -1.134  -1.667  1.00 13.21           C  
ATOM   1145  O   ARG A 114       6.699  -1.690  -1.722  1.00 13.05           O  
ATOM   1146  CB  ARG A 114       9.066  -1.534   0.462  1.00 13.56           C  
ATOM   1147  CG  ARG A 114       9.911  -2.622   1.125  1.00 14.94           C  
ATOM   1148  CD  ARG A 114      10.170  -2.378   2.555  1.00 14.02           C  
ATOM   1149  NE  ARG A 114      11.060  -1.231   2.702  1.00 14.52           N  
ATOM   1150  CZ  ARG A 114      11.426  -0.777   3.887  1.00 15.18           C  
ATOM   1151  NH1 ARG A 114      10.967  -1.348   5.006  1.00 16.14           N  
ATOM   1152  NH2 ARG A 114      12.239   0.279   3.961  1.00 18.55           N  
ATOM   1153  N   HIS A 115       8.039   0.085  -2.192  1.00 12.72           N  
ATOM   1154  CA  HIS A 115       6.941   0.788  -2.842  1.00 12.40           C  
ATOM   1155  C   HIS A 115       6.526   0.074  -4.146  1.00 13.83           C  
ATOM   1156  O   HIS A 115       5.363   0.176  -4.597  1.00 14.28           O  
ATOM   1157  CB  HIS A 115       7.316   2.247  -3.094  1.00 12.74           C  
ATOM   1158  CG  HIS A 115       8.478   2.412  -4.001  1.00 12.97           C  
ATOM   1159  ND1 HIS A 115       9.784   2.195  -3.609  1.00 14.62           N  
ATOM   1160  CD2 HIS A 115       8.522   2.789  -5.292  1.00 15.00           C  
ATOM   1161  CE1 HIS A 115      10.578   2.422  -4.643  1.00 17.04           C  
ATOM   1162  NE2 HIS A 115       9.839   2.821  -5.657  1.00 15.38           N  
ATOM   1163  N   LYS A 116       7.476  -0.613  -4.790  1.00 13.64           N  
ATOM   1164  CA  LYS A 116       7.132  -1.358  -6.009  0.60 14.37           C  
ATOM   1166  C   LYS A 116       6.354  -2.610  -5.679  1.00 13.86           C  
ATOM   1167  O   LYS A 116       5.459  -3.007  -6.432  1.00 14.13           O  
ATOM   1168  CB  LYS A 116       8.365  -1.756  -6.835  0.60 14.54           C  
ATOM   1170  CG  LYS A 116       8.992  -0.623  -7.572  0.60 15.78           C  
ATOM   1172  CD  LYS A 116      10.056  -1.074  -8.592  0.60 17.54           C  
ATOM   1174  CE  LYS A 116      10.691  -2.444  -8.339  0.60 22.93           C  
ATOM   1176  NZ  LYS A 116       9.987  -3.615  -8.985  0.60 26.52           N  
ATOM   1178  N   ASP A 117       6.665  -3.236  -4.552  1.00 13.11           N  
ATOM   1179  CA  ASP A 117       5.921  -4.433  -4.164  1.00 11.94           C  
ATOM   1180  C   ASP A 117       4.495  -4.046  -3.804  1.00 10.56           C  
ATOM   1181  O   ASP A 117       3.553  -4.740  -4.258  1.00 11.17           O  
ATOM   1182  CB  ASP A 117       6.597  -5.104  -2.989  1.00 12.62           C  
ATOM   1183  CG  ASP A 117       5.966  -6.427  -2.665  1.00 13.27           C  
ATOM   1184  OD1 ASP A 117       6.316  -7.429  -3.349  1.00 17.09           O  
ATOM   1185  OD2 ASP A 117       5.085  -6.466  -1.778  1.00 16.31           O  
ATOM   1186  N   ILE A 118       4.308  -2.955  -3.022  1.00 11.16           N  
ATOM   1187  CA  ILE A 118       2.972  -2.442  -2.705  1.00 11.44           C  
ATOM   1188  C   ILE A 118       2.183  -2.062  -3.961  1.00 11.87           C  
ATOM   1189  O   ILE A 118       0.982  -2.412  -4.068  1.00 12.70           O  
ATOM   1190  CB  ILE A 118       3.080  -1.271  -1.715  1.00 11.29           C  
ATOM   1191  CG1 ILE A 118       3.574  -1.814  -0.347  1.00 13.25           C  
ATOM   1192  CG2 ILE A 118       1.732  -0.574  -1.576  1.00 15.07           C  
ATOM   1193  CD1 ILE A 118       4.071  -0.713   0.632  1.00 13.09           C  
ATOM   1194  N   ALA A 119       2.833  -1.393  -4.923  1.00 11.50           N  
ATOM   1195  CA  ALA A 119       2.171  -1.053  -6.191  1.00 11.81           C  
ATOM   1196  C   ALA A 119       1.701  -2.333  -6.853  1.00 11.62           C  
ATOM   1197  O   ALA A 119       0.576  -2.414  -7.337  1.00 12.41           O  
ATOM   1198  CB  ALA A 119       3.157  -0.313  -7.081  1.00 12.56           C  
ATOM   1199  N   GLY A 120       2.562  -3.360  -6.872  1.00 11.38           N  
ATOM   1200  CA  GLY A 120       2.169  -4.630  -7.509  1.00 11.29           C  
ATOM   1201  C   GLY A 120       0.941  -5.250  -6.848  1.00  9.48           C  
ATOM   1202  O   GLY A 120       0.031  -5.726  -7.521  1.00 11.66           O  
ATOM   1203  N   TRP A 121       0.912  -5.258  -5.506  1.00 10.14           N  
ATOM   1204  CA  TRP A 121      -0.258  -5.785  -4.816  1.00 10.20           C  
ATOM   1205  C   TRP A 121      -1.512  -4.972  -5.097  1.00 10.90           C  
ATOM   1206  O   TRP A 121      -2.591  -5.550  -5.290  1.00 11.72           O  
ATOM   1207  CB  TRP A 121      -0.017  -5.839  -3.294  1.00 10.60           C  
ATOM   1208  CG  TRP A 121       0.806  -7.062  -2.961  1.00 10.77           C  
ATOM   1209  CD1 TRP A 121       2.096  -7.125  -2.505  1.00 11.90           C  
ATOM   1210  CD2 TRP A 121       0.371  -8.428  -3.156  1.00 10.37           C  
ATOM   1211  NE1 TRP A 121       2.486  -8.454  -2.381  1.00 13.98           N  
ATOM   1212  CE2 TRP A 121       1.447  -9.269  -2.764  1.00 11.31           C  
ATOM   1213  CE3 TRP A 121      -0.856  -9.022  -3.521  1.00 10.91           C  
ATOM   1214  CZ2 TRP A 121       1.345 -10.670  -2.802  1.00 13.90           C  
ATOM   1215  CZ3 TRP A 121      -0.938 -10.419  -3.586  1.00 12.04           C  
ATOM   1216  CH2 TRP A 121       0.138 -11.212  -3.210  1.00 12.95           C  
ATOM   1217  N   SER A 122      -1.398  -3.645  -5.135  1.00 12.04           N  
ATOM   1218  CA  SER A 122      -2.586  -2.834  -5.401  0.60 11.31           C  
ATOM   1220  C   SER A 122      -3.175  -3.192  -6.767  1.00 11.17           C  
ATOM   1221  O   SER A 122      -4.419  -3.295  -6.910  1.00 11.10           O  
ATOM   1222  CB  SER A 122      -2.213  -1.354  -5.305  0.60 12.25           C  
ATOM   1224  OG  SER A 122      -1.875  -1.067  -3.958  0.60 13.64           O  
ATOM   1226  N   ILE A 123      -2.287  -3.430  -7.752  1.00 10.72           N  
ATOM   1227  CA  ILE A 123      -2.707  -3.747  -9.120  1.00 11.62           C  
ATOM   1228  C   ILE A 123      -3.358  -5.130  -9.163  1.00 10.90           C  
ATOM   1229  O   ILE A 123      -4.439  -5.305  -9.778  1.00 11.90           O  
ATOM   1230  CB  ILE A 123      -1.517  -3.608 -10.128  1.00 12.64           C  
ATOM   1231  CG1 ILE A 123      -1.059  -2.136 -10.167  1.00 15.29           C  
ATOM   1232  CG2 ILE A 123      -1.900  -4.170 -11.499  1.00 16.82           C  
ATOM   1233  CD1 ILE A 123       0.347  -1.882 -10.758  1.00 16.38           C  
ATOM   1234  N   VAL A 124      -2.697  -6.142  -8.569  1.00 10.19           N  
ATOM   1235  CA  VAL A 124      -3.313  -7.463  -8.698  1.00 10.14           C  
ATOM   1236  C   VAL A 124      -4.577  -7.587  -7.851  1.00  9.64           C  
ATOM   1237  O   VAL A 124      -5.478  -8.355  -8.232  1.00 10.27           O  
ATOM   1238  CB  VAL A 124      -2.320  -8.669  -8.430  1.00 10.59           C  
ATOM   1239  CG1 VAL A 124      -1.169  -8.641  -9.395  1.00 13.31           C  
ATOM   1240  CG2 VAL A 124      -1.850  -8.646  -6.995  1.00 11.18           C  
ATOM   1241  N   LEU A 125      -4.662  -6.872  -6.726  1.00  9.77           N  
ATOM   1242  CA  LEU A 125      -5.930  -6.876  -5.955  1.00 10.14           C  
ATOM   1243  C   LEU A 125      -7.060  -6.228  -6.737  1.00 10.51           C  
ATOM   1244  O   LEU A 125      -8.222  -6.645  -6.595  1.00 10.61           O  
ATOM   1245  CB  LEU A 125      -5.770  -6.201  -4.562  1.00 10.47           C  
ATOM   1246  CG  LEU A 125      -4.826  -6.936  -3.617  1.00 11.48           C  
ATOM   1247  CD1 LEU A 125      -4.467  -6.024  -2.468  1.00 11.77           C  
ATOM   1248  CD2 LEU A 125      -5.433  -8.264  -3.152  1.00 13.49           C  
ATOM   1249  N   ASN A 126      -6.740  -5.174  -7.507  1.00  9.94           N  
ATOM   1250  CA  ASN A 126      -7.749  -4.631  -8.402  1.00 10.12           C  
ATOM   1251  C   ASN A 126      -8.184  -5.669  -9.418  1.00 10.44           C  
ATOM   1252  O   ASN A 126      -9.391  -5.724  -9.801  1.00 12.21           O  
ATOM   1253  CB  ASN A 126      -7.234  -3.362  -9.102  1.00 10.54           C  
ATOM   1254  CG  ASN A 126      -7.056  -2.209  -8.130  1.00 11.20           C  
ATOM   1255  OD1 ASN A 126      -7.487  -2.296  -6.998  1.00 12.24           O  
ATOM   1256  ND2 ASN A 126      -6.444  -1.118  -8.595  1.00 13.44           N  
ATOM   1257  N   ARG A 127      -7.199  -6.410  -9.970  1.00  9.53           N  
ATOM   1258  CA  ARG A 127      -7.587  -7.467 -10.912  1.00  9.21           C  
ATOM   1259  C   ARG A 127      -8.440  -8.540 -10.221  1.00 10.77           C  
ATOM   1260  O   ARG A 127      -9.367  -9.085 -10.842  1.00 11.86           O  
ATOM   1261  CB  ARG A 127      -6.329  -8.094 -11.535  1.00 11.74           C  
ATOM   1262  CG  ARG A 127      -6.612  -9.178 -12.516  1.00 13.04           C  
ATOM   1263  CD  ARG A 127      -7.319  -8.690 -13.756  1.00 15.33           C  
ATOM   1264  NE  ARG A 127      -7.447  -9.788 -14.713  1.00 19.72           N  
ATOM   1265  CZ  ARG A 127      -8.358  -9.814 -15.687  1.00 23.18           C  
ATOM   1266  NH1 ARG A 127      -9.196  -8.811 -15.801  1.00 23.02           N  
ATOM   1267  NH2 ARG A 127      -8.450 -10.860 -16.522  1.00 26.89           N  
ATOM   1268  N   LEU A 128      -8.112  -8.907  -8.977  1.00 10.21           N  
ATOM   1269  CA  LEU A 128      -8.953  -9.896  -8.286  1.00 10.98           C  
ATOM   1270  C   LEU A 128     -10.414  -9.441  -8.199  1.00 11.15           C  
ATOM   1271  O   LEU A 128     -11.332 -10.190  -8.529  1.00 11.96           O  
ATOM   1272  CB  LEU A 128      -8.375 -10.135  -6.900  1.00 10.94           C  
ATOM   1273  CG  LEU A 128      -9.224 -10.986  -5.951  1.00 12.81           C  
ATOM   1274  CD1 LEU A 128      -9.534 -12.375  -6.534  1.00 12.59           C  
ATOM   1275  CD2 LEU A 128      -8.475 -11.123  -4.615  1.00 12.98           C  
ATOM   1276  N   LYS A 129     -10.642  -8.190  -7.785  1.00 11.55           N  
ATOM   1277  CA  LYS A 129     -12.010  -7.684  -7.732  0.60 11.39           C  
ATOM   1279  C   LYS A 129     -12.668  -7.781  -9.118  1.00 12.10           C  
ATOM   1280  O   LYS A 129     -13.807  -8.222  -9.242  1.00 11.77           O  
ATOM   1281  CB  LYS A 129     -12.005  -6.223  -7.219  0.60 11.70           C  
ATOM   1283  CG  LYS A 129     -13.350  -5.488  -7.387  0.60 11.09           C  
ATOM   1285  CD  LYS A 129     -13.245  -4.092  -6.741  0.60 11.02           C  
ATOM   1287  CE  LYS A 129     -14.398  -3.219  -7.193  0.60 11.79           C  
ATOM   1289  NZ  LYS A 129     -15.670  -3.666  -6.573  0.60 13.42           N  
ATOM   1291  N   GLN A 130     -11.934  -7.369 -10.136  1.00 11.57           N  
ATOM   1292  CA  GLN A 130     -12.478  -7.363 -11.483  1.00 13.15           C  
ATOM   1293  C   GLN A 130     -12.837  -8.756 -11.970  1.00 12.39           C  
ATOM   1294  O   GLN A 130     -13.884  -8.914 -12.625  1.00 15.85           O  
ATOM   1295  CB  GLN A 130     -11.440  -6.712 -12.429  1.00 14.92           C  
ATOM   1296  CG  GLN A 130     -11.787  -6.549 -13.890  1.00 16.73           C  
ATOM   1297  CD  GLN A 130     -10.656  -5.848 -14.614  1.00 17.49           C  
ATOM   1298  OE1 GLN A 130      -9.493  -6.259 -14.541  1.00 22.82           O  
ATOM   1299  NE2 GLN A 130     -10.987  -4.762 -15.301  1.00 25.01           N  
ATOM   1300  N   VAL A 131     -11.958  -9.733 -11.769  1.00 12.78           N  
ATOM   1301  CA  VAL A 131     -12.253 -11.083 -12.281  1.00 13.70           C  
ATOM   1302  C   VAL A 131     -13.382 -11.760 -11.517  1.00 13.10           C  
ATOM   1303  O   VAL A 131     -14.095 -12.613 -12.083  1.00 14.85           O  
ATOM   1304  CB  VAL A 131     -11.018 -12.026 -12.354  1.00 15.17           C  
ATOM   1305  CG1 VAL A 131      -9.949 -11.417 -13.245  1.00 16.12           C  
ATOM   1306  CG2 VAL A 131     -10.497 -12.469 -11.023  1.00 15.26           C  
ATOM   1307  N   VAL A 132     -13.521 -11.438 -10.233  1.00 12.80           N  
ATOM   1308  CA  VAL A 132     -14.636 -12.027  -9.454  1.00 13.03           C  
ATOM   1309  C   VAL A 132     -15.955 -11.399  -9.932  1.00 14.57           C  
ATOM   1310  O   VAL A 132     -16.936 -12.122 -10.161  1.00 17.52           O  
ATOM   1311  CB  VAL A 132     -14.489 -11.797  -7.936  1.00 13.26           C  
ATOM   1312  CG1 VAL A 132     -15.773 -12.195  -7.166  1.00 15.24           C  
ATOM   1313  CG2 VAL A 132     -13.302 -12.555  -7.400  1.00 13.21           C  
ATOM   1314  N   GLU A 133     -15.986 -10.073 -10.128  1.00 15.45           N  
ATOM   1315  CA  GLU A 133     -17.242  -9.397 -10.474  1.00 16.53           C  
ATOM   1316  C   GLU A 133     -17.582  -9.482 -11.945  1.00 18.72           C  
ATOM   1317  O   GLU A 133     -18.753  -9.573 -12.317  1.00 20.21           O  
ATOM   1318  CB  GLU A 133     -17.187  -7.928 -10.044  1.00 15.94           C  
ATOM   1319  CG  GLU A 133     -17.085  -7.811  -8.525  1.00 15.30           C  
ATOM   1320  CD  GLU A 133     -17.041  -6.359  -8.044  1.00 14.93           C  
ATOM   1321  OE1 GLU A 133     -16.823  -5.449  -8.851  1.00 19.09           O  
ATOM   1322  OE2 GLU A 133     -17.260  -6.128  -6.837  1.00 14.73           O  
ATOM   1323  N   THR A 134     -16.571  -9.386 -12.796  1.00 19.80           N  
ATOM   1324  CA  THR A 134     -16.770  -9.320 -14.248  1.00 23.45           C  
ATOM   1325  C   THR A 134     -15.707 -10.188 -14.925  1.00 25.43           C  
ATOM   1326  O   THR A 134     -14.757  -9.644 -15.476  1.00 25.56           O  
ATOM   1327  CB  THR A 134     -16.678  -7.847 -14.750  1.00 23.26           C  
ATOM   1328  OG1 THR A 134     -15.470  -7.211 -14.281  1.00 25.79           O  
ATOM   1329  CG2 THR A 134     -17.831  -7.024 -14.243  1.00 24.62           C  
ATOM   1330  N   PRO A 135     -15.870 -11.529 -14.866  1.00 27.69           N  
ATOM   1331  CA  PRO A 135     -14.891 -12.539 -15.310  1.00 29.81           C  
ATOM   1332  C   PRO A 135     -14.252 -12.329 -16.695  1.00 32.06           C  
ATOM   1333  O   PRO A 135     -13.085 -12.720 -16.890  1.00 33.36           O  
ATOM   1334  CB  PRO A 135     -15.678 -13.847 -15.221  1.00 29.74           C  
ATOM   1335  CG  PRO A 135     -16.636 -13.622 -14.133  1.00 29.45           C  
ATOM   1336  CD  PRO A 135     -17.062 -12.185 -14.291  1.00 27.90           C  
ATOM   1337  N   ASP A 136     -14.950 -11.686 -17.624  1.00 33.32           N  
ATOM   1338  CA  ASP A 136     -14.306 -11.367 -18.910  1.00 35.02           C  
ATOM   1339  C   ASP A 136     -14.117  -9.887 -19.230  1.00 35.24           C  
ATOM   1340  O   ASP A 136     -14.027  -9.506 -20.411  1.00 35.20           O  
ATOM   1341  CB  ASP A 136     -14.928 -12.118 -20.108  1.00 36.50           C  
ATOM   1342  CG  ASP A 136     -16.433 -12.276 -20.004  1.00 40.12           C  
ATOM   1343  OD1 ASP A 136     -17.155 -11.241 -20.054  1.00 43.07           O  
ATOM   1344  OD2 ASP A 136     -16.887 -13.445 -19.899  1.00 40.02           O  
ATOM   1345  N   ALA A 137     -14.027  -9.054 -18.193  1.00 34.06           N  
ATOM   1346  CA  ALA A 137     -13.642  -7.664 -18.399  1.00 34.25           C  
ATOM   1347  C   ALA A 137     -12.206  -7.671 -18.900  1.00 33.54           C  
ATOM   1348  O   ALA A 137     -11.422  -8.557 -18.538  1.00 33.65           O  
ATOM   1349  CB  ALA A 137     -13.755  -6.864 -17.114  1.00 34.13           C  
ATOM   1350  N   ALA A 138     -11.879  -6.718 -19.767  1.00 33.26           N  
ATOM   1351  CA  ALA A 138     -10.504  -6.569 -20.247  1.00 33.24           C  
ATOM   1352  C   ALA A 138      -9.623  -6.186 -19.059  1.00 32.46           C  
ATOM   1353  O   ALA A 138     -10.039  -5.376 -18.222  1.00 31.83           O  
ATOM   1354  CB  ALA A 138     -10.450  -5.483 -21.322  1.00 33.08           C  
ATOM   1355  N   PRO A 139      -8.418  -6.772 -18.964  1.00 32.17           N  
ATOM   1356  CA  PRO A 139      -7.509  -6.282 -17.919  1.00 31.36           C  
ATOM   1357  C   PRO A 139      -7.242  -4.773 -17.990  1.00 30.68           C  
ATOM   1358  O   PRO A 139      -7.337  -4.146 -19.047  1.00 30.58           O  
ATOM   1359  CB  PRO A 139      -6.219  -7.104 -18.123  1.00 31.69           C  
ATOM   1360  CG  PRO A 139      -6.426  -7.941 -19.362  1.00 32.65           C  
ATOM   1361  CD  PRO A 139      -7.863  -7.901 -19.745  1.00 32.62           C  
ATOM   1362  N   GLU A 140      -6.920  -4.189 -16.850  1.00 29.43           N  
ATOM   1363  CA  GLU A 140      -6.632  -2.772 -16.820  1.00 28.69           C  
ATOM   1364  C   GLU A 140      -5.276  -2.391 -17.390  0.50 29.45           C  
ATOM   1366  O   GLU A 140      -4.239  -2.839 -16.873  0.50 28.56           O  
ATOM   1368  CB  GLU A 140      -6.641  -2.290 -15.362  1.00 27.88           C  
ATOM   1369  CG  GLU A 140      -7.991  -2.515 -14.672  1.00 23.59           C  
ATOM   1370  CD  GLU A 140      -9.049  -1.661 -15.322  1.00 22.55           C  
ATOM   1371  OE1 GLU A 140      -9.073  -0.435 -15.044  1.00 22.55           O  
ATOM   1372  OE2 GLU A 140      -9.820  -2.202 -16.168  1.00 19.84           O  
ATOM   1373  N   LYS A 141      -5.287  -1.507 -18.393  1.00 30.68           N  
ATOM   1374  CA  LYS A 141      -4.060  -1.018 -19.005  1.00 32.76           C  
ATOM   1375  C   LYS A 141      -3.493   0.029 -18.053  1.00 32.97           C  
ATOM   1376  O   LYS A 141      -3.764   1.226 -18.204  1.00 33.76           O  
ATOM   1377  CB  LYS A 141      -4.385  -0.371 -20.358  1.00 33.16           C  
ATOM   1378  CG  LYS A 141      -3.164  -0.004 -21.176  1.00 35.53           C  
ATOM   1379  CD  LYS A 141      -3.543   0.696 -22.483  1.00 36.30           C  
ATOM   1380  CE  LYS A 141      -2.338   1.426 -23.084  1.00 43.70           C  
ATOM   1381  NZ  LYS A 141      -2.263   2.831 -22.590  1.00 41.43           N  
ATOM   1382  N   ILE A 142      -2.720  -0.401 -17.071  1.00 32.97           N  
ATOM   1383  CA  ILE A 142      -2.316   0.563 -16.058  1.00 33.22           C  
ATOM   1384  C   ILE A 142      -0.942   1.125 -16.343  1.00 32.00           C  
ATOM   1385  O   ILE A 142      -0.154   0.584 -17.123  1.00 32.37           O  
ATOM   1386  CB  ILE A 142      -2.441   0.042 -14.590  1.00 34.17           C  
ATOM   1387  CG1 ILE A 142      -1.904  -1.380 -14.471  1.00 35.13           C  
ATOM   1388  CG2 ILE A 142      -3.906   0.100 -14.112  1.00 33.64           C  
ATOM   1389  CD1 ILE A 142      -0.455  -1.444 -14.517  1.00 36.11           C  
ATOM   1390  N   ASP A 143      -0.707   2.256 -15.725  1.00 30.60           N  
ATOM   1391  CA  ASP A 143       0.533   2.955 -15.828  1.00 29.94           C  
ATOM   1392  C   ASP A 143       1.388   2.602 -14.608  1.00 28.72           C  
ATOM   1393  O   ASP A 143       1.303   3.302 -13.591  1.00 28.74           O  
ATOM   1394  CB  ASP A 143       0.156   4.419 -15.799  1.00 30.52           C  
ATOM   1395  CG  ASP A 143       1.315   5.317 -15.965  1.00 33.27           C  
ATOM   1396  OD1 ASP A 143       2.486   4.842 -15.926  1.00 33.54           O  
ATOM   1397  OD2 ASP A 143       1.023   6.517 -16.137  1.00 36.36           O  
ATOM   1398  N   PHE A 144       2.178   1.527 -14.708  1.00 28.68           N  
ATOM   1399  CA  PHE A 144       2.984   1.025 -13.578  0.50 28.52           C  
ATOM   1401  C   PHE A 144       3.893   2.112 -12.989  1.00 27.87           C  
ATOM   1402  O   PHE A 144       3.912   2.334 -11.785  1.00 25.44           O  
ATOM   1403  CB  PHE A 144       3.852  -0.179 -13.997  0.50 30.06           C  
ATOM   1405  CG  PHE A 144       3.143  -1.514 -13.960  0.50 31.35           C  
ATOM   1407  CD1 PHE A 144       3.017  -2.223 -12.767  0.50 33.75           C  
ATOM   1409  CD2 PHE A 144       2.659  -2.092 -15.134  0.50 32.22           C  
ATOM   1411  CE1 PHE A 144       2.380  -3.472 -12.738  0.50 32.71           C  
ATOM   1413  CE2 PHE A 144       2.022  -3.338 -15.111  0.50 33.61           C  
ATOM   1415  CZ  PHE A 144       1.882  -4.025 -13.903  0.50 32.96           C  
ATOM   1417  N   PRO A 145       4.703   2.790 -13.848  1.00 26.91           N  
ATOM   1418  CA  PRO A 145       5.553   3.830 -13.239  1.00 26.66           C  
ATOM   1419  C   PRO A 145       4.808   4.886 -12.414  1.00 25.40           C  
ATOM   1420  O   PRO A 145       5.307   5.322 -11.368  1.00 24.71           O  
ATOM   1421  CB  PRO A 145       6.239   4.468 -14.456  1.00 26.93           C  
ATOM   1422  CG  PRO A 145       6.312   3.328 -15.427  1.00 28.06           C  
ATOM   1423  CD  PRO A 145       4.958   2.694 -15.302  1.00 27.26           C  
ATOM   1424  N   GLN A 146       3.610   5.257 -12.849  1.00 24.23           N  
ATOM   1425  CA  GLN A 146       2.817   6.260 -12.164  1.00 23.81           C  
ATOM   1426  C   GLN A 146       2.339   5.750 -10.774  1.00 22.09           C  
ATOM   1427  O   GLN A 146       2.423   6.445  -9.752  1.00 21.35           O  
ATOM   1428  CB  GLN A 146       1.653   6.605 -13.070  1.00 25.38           C  
ATOM   1429  CG  GLN A 146       0.467   7.333 -12.481  1.00 30.21           C  
ATOM   1430  CD  GLN A 146       0.842   8.546 -11.648  1.00 41.97           C  
ATOM   1431  OE1 GLN A 146       1.974   9.046 -11.715  1.00 39.14           O  
ATOM   1432  NE2 GLN A 146      -0.113   9.029 -10.842  1.00 37.11           N  
ATOM   1433  N   ILE A 147       1.847   4.530 -10.772  1.00 21.07           N  
ATOM   1434  CA  ILE A 147       1.437   3.875  -9.533  1.00 18.10           C  
ATOM   1435  C   ILE A 147       2.645   3.685  -8.607  1.00 17.53           C  
ATOM   1436  O   ILE A 147       2.546   3.971  -7.410  1.00 17.03           O  
ATOM   1437  CB  ILE A 147       0.684   2.585  -9.833  1.00 18.20           C  
ATOM   1438  CG1 ILE A 147      -0.641   2.909 -10.525  1.00 18.27           C  
ATOM   1439  CG2 ILE A 147       0.353   1.834  -8.572  1.00 16.07           C  
ATOM   1440  CD1 ILE A 147      -1.225   1.716 -11.255  1.00 22.25           C  
ATOM   1441  N   GLU A 148       3.780   3.247  -9.175  1.00 18.25           N  
ATOM   1442  CA  GLU A 148       4.973   3.042  -8.355  0.50 17.58           C  
ATOM   1444  C   GLU A 148       5.426   4.358  -7.709  1.00 18.11           C  
ATOM   1445  O   GLU A 148       5.770   4.373  -6.527  1.00 16.90           O  
ATOM   1446  CB  GLU A 148       6.070   2.338  -9.156  0.50 18.38           C  
ATOM   1448  CG  GLU A 148       5.667   0.915  -9.512  0.50 19.32           C  
ATOM   1450  CD  GLU A 148       6.574   0.251 -10.515  0.50 23.09           C  
ATOM   1452  OE1 GLU A 148       7.511   0.916 -11.020  0.50 22.45           O  
ATOM   1454  OE2 GLU A 148       6.331  -0.940 -10.814  0.50 25.34           O  
ATOM   1456  N   ASN A 149       5.379   5.467  -8.451  1.00 17.81           N  
ATOM   1457  CA  ASN A 149       5.689   6.769  -7.895  1.00 17.24           C  
ATOM   1458  C   ASN A 149       4.707   7.211  -6.778  1.00 16.03           C  
ATOM   1459  O   ASN A 149       5.123   7.769  -5.740  1.00 16.07           O  
ATOM   1460  CB  ASN A 149       5.796   7.833  -8.982  1.00 19.98           C  
ATOM   1461  CG  ASN A 149       6.102   9.183  -8.399  1.00 23.10           C  
ATOM   1462  OD1 ASN A 149       5.217  10.060  -8.304  1.00 26.84           O  
ATOM   1463  ND2 ASN A 149       7.321   9.334  -7.894  1.00 23.19           N  
ATOM   1464  N   HIS A 150       3.416   6.938  -6.982  1.00 15.04           N  
ATOM   1465  CA  HIS A 150       2.460   7.231  -5.928  1.00 14.32           C  
ATOM   1466  C   HIS A 150       2.840   6.565  -4.616  1.00 13.27           C  
ATOM   1467  O   HIS A 150       2.843   7.192  -3.561  1.00 13.12           O  
ATOM   1468  CB  HIS A 150       1.091   6.759  -6.338  1.00 15.09           C  
ATOM   1469  CG  HIS A 150       0.072   6.895  -5.257  1.00 15.87           C  
ATOM   1470  ND1 HIS A 150      -0.378   5.838  -4.494  1.00 17.32           N  
ATOM   1471  CD2 HIS A 150      -0.648   7.964  -4.863  1.00 17.50           C  
ATOM   1472  CE1 HIS A 150      -1.333   6.251  -3.678  1.00 13.44           C  
ATOM   1473  NE2 HIS A 150      -1.475   7.553  -3.845  1.00 20.73           N  
ATOM   1474  N   TYR A 151       3.198   5.285  -4.699  1.00 12.22           N  
ATOM   1475  CA  TYR A 151       3.568   4.580  -3.496  1.00 10.89           C  
ATOM   1476  C   TYR A 151       4.928   4.978  -2.953  1.00 10.93           C  
ATOM   1477  O   TYR A 151       5.114   4.985  -1.732  1.00 11.32           O  
ATOM   1478  CB  TYR A 151       3.428   3.067  -3.663  1.00 11.18           C  
ATOM   1479  CG  TYR A 151       1.940   2.672  -3.682  1.00 10.99           C  
ATOM   1480  CD1 TYR A 151       1.159   2.829  -2.554  1.00 11.53           C  
ATOM   1481  CD2 TYR A 151       1.348   2.246  -4.830  1.00 11.84           C  
ATOM   1482  CE1 TYR A 151      -0.206   2.504  -2.535  1.00 11.27           C  
ATOM   1483  CE2 TYR A 151      -0.011   1.907  -4.858  1.00 11.41           C  
ATOM   1484  CZ  TYR A 151      -0.801   2.049  -3.728  1.00 12.21           C  
ATOM   1485  OH  TYR A 151      -2.158   1.753  -3.804  1.00 14.18           O  
ATOM   1486  N   LEU A 152       5.843   5.375  -3.840  1.00 11.81           N  
ATOM   1487  CA  LEU A 152       7.108   5.933  -3.381  1.00 12.98           C  
ATOM   1488  C   LEU A 152       6.833   7.155  -2.484  1.00 11.94           C  
ATOM   1489  O   LEU A 152       7.446   7.288  -1.443  1.00 12.42           O  
ATOM   1490  CB  LEU A 152       8.014   6.338  -4.553  1.00 14.19           C  
ATOM   1491  CG  LEU A 152       9.394   6.891  -4.153  1.00 14.89           C  
ATOM   1492  CD1 LEU A 152      10.118   6.004  -3.144  1.00 15.12           C  
ATOM   1493  CD2 LEU A 152      10.266   7.115  -5.416  1.00 17.38           C  
ATOM   1494  N   GLU A 153       5.926   8.045  -2.925  1.00 11.41           N  
ATOM   1495  CA  GLU A 153       5.670   9.269  -2.138  1.00 13.20           C  
ATOM   1496  C   GLU A 153       4.996   8.912  -0.797  1.00 12.02           C  
ATOM   1497  O   GLU A 153       5.285   9.526   0.255  1.00 13.65           O  
ATOM   1498  CB  GLU A 153       4.773  10.244  -2.930  1.00 15.32           C  
ATOM   1499  CG  GLU A 153       5.440  10.800  -4.138  1.00 18.32           C  
ATOM   1500  CD  GLU A 153       4.437  11.478  -5.087  1.00 31.30           C  
ATOM   1501  OE1 GLU A 153       3.174  11.252  -4.996  1.00 31.17           O  
ATOM   1502  OE2 GLU A 153       4.927  12.241  -5.934  1.00 30.59           O  
ATOM   1503  N   LYS A 154       4.100   7.909  -0.814  1.00 12.04           N  
ATOM   1504  CA  LYS A 154       3.460   7.497   0.459  1.00 10.98           C  
ATOM   1505  C   LYS A 154       4.536   7.002   1.444  1.00 11.80           C  
ATOM   1506  O   LYS A 154       4.478   7.335   2.620  1.00 13.03           O  
ATOM   1507  CB  LYS A 154       2.437   6.367   0.217  1.00 10.92           C  
ATOM   1508  CG  LYS A 154       1.153   6.875  -0.416  1.00 12.88           C  
ATOM   1509  CD  LYS A 154       0.291   7.634   0.647  1.00 12.91           C  
ATOM   1510  CE  LYS A 154      -1.098   7.900   0.082  1.00 15.92           C  
ATOM   1511  NZ  LYS A 154      -2.001   8.532   1.103  1.00 16.67           N  
ATOM   1512  N   LEU A 155       5.470   6.161   0.968  1.00 11.53           N  
ATOM   1513  CA  LEU A 155       6.466   5.592   1.891  1.00 12.26           C  
ATOM   1514  C   LEU A 155       7.494   6.639   2.342  1.00 12.78           C  
ATOM   1515  O   LEU A 155       7.957   6.628   3.481  1.00 14.33           O  
ATOM   1516  CB  LEU A 155       7.158   4.383   1.246  1.00 11.49           C  
ATOM   1517  CG  LEU A 155       6.307   3.190   0.861  1.00 14.67           C  
ATOM   1518  CD1 LEU A 155       7.145   1.925   0.670  1.00 15.15           C  
ATOM   1519  CD2 LEU A 155       5.226   2.970   1.880  1.00 15.38           C  
ATOM   1520  N   THR A 156       7.857   7.516   1.429  1.00 13.74           N  
ATOM   1521  CA  THR A 156       8.820   8.530   1.723  0.50 15.83           C  
ATOM   1523  C   THR A 156       8.256   9.441   2.842  1.00 15.51           C  
ATOM   1524  O   THR A 156       8.980   9.924   3.733  1.00 16.22           O  
ATOM   1525  CB  THR A 156       9.069   9.173   0.360  0.50 17.07           C  
ATOM   1527  OG1 THR A 156      10.228   8.575  -0.240  0.50 19.23           O  
ATOM   1529  CG2 THR A 156       9.131  10.640   0.396  0.50 20.40           C  
ATOM   1531  N   ASN A 157       6.952   9.667   2.796  1.00 14.91           N  
ATOM   1532  CA  ASN A 157       6.336  10.488   3.817  1.00 16.15           C  
ATOM   1533  C   ASN A 157       6.417   9.880   5.214  1.00 14.82           C  
ATOM   1534  O   ASN A 157       6.351  10.603   6.233  1.00 17.20           O  
ATOM   1535  CB  ASN A 157       4.898  10.782   3.430  1.00 17.62           C  
ATOM   1536  CG  ASN A 157       4.402  12.052   4.058  1.00 22.17           C  
ATOM   1537  OD1 ASN A 157       3.663  11.995   5.004  1.00 24.99           O  
ATOM   1538  ND2 ASN A 157       4.852  13.199   3.563  1.00 25.19           N  
ATOM   1539  N   LEU A 158       6.591   8.551   5.305  1.00 15.37           N  
ATOM   1540  CA  LEU A 158       6.700   7.877   6.625  1.00 15.37           C  
ATOM   1541  C   LEU A 158       8.034   8.132   7.297  1.00 16.04           C  
ATOM   1542  O   LEU A 158       8.178   7.940   8.511  1.00 17.62           O  
ATOM   1543  CB  LEU A 158       6.594   6.350   6.458  1.00 15.99           C  
ATOM   1544  CG  LEU A 158       5.226   5.836   6.015  1.00 14.96           C  
ATOM   1545  CD1 LEU A 158       5.340   4.326   5.774  1.00 15.78           C  
ATOM   1546  CD2 LEU A 158       4.204   6.061   7.111  1.00 17.16           C  
ATOM   1547  N   GLU A 159       9.052   8.473   6.532  1.00 16.23           N  
ATOM   1548  CA  GLU A 159      10.371   8.673   7.169  1.00 19.53           C  
ATOM   1549  C   GLU A 159      10.320   9.798   8.241  1.00 21.82           C  
ATOM   1550  O   GLU A 159       9.560  10.730   8.095  1.00 24.93           O  
ATOM   1551  CB  GLU A 159      11.379   9.082   6.088  1.00 19.72           C  
ATOM   1552  CG  GLU A 159      11.575   8.030   4.991  1.00 21.16           C  
ATOM   1553  CD  GLU A 159      12.396   8.591   3.848  1.00 24.68           C  
ATOM   1554  OE1 GLU A 159      13.137   9.562   4.132  1.00 26.91           O  
ATOM   1555  OE2 GLU A 159      12.286   8.114   2.683  1.00 23.40           O  
ATOM   1556  N   ASN A 160      11.118   9.724   9.301  0.60 22.32           N  
ATOM   1557  CA  ASN A 160      11.220  10.887  10.217  0.60 24.95           C  
ATOM   1558  C   ASN A 160      12.034  11.922   9.420  0.60 25.77           C  
ATOM   1559  O   ASN A 160      12.995  11.558   8.727  0.60 27.29           O  
ATOM   1560  CB  ASN A 160      11.860  10.476  11.564  0.60 25.72           C  
ATOM   1561  CG  ASN A 160      11.316  11.278  12.788  0.60 26.48           C  
ATOM   1562  OD1 ASN A 160      10.538  12.217  12.645  0.60 24.94           O  
ATOM   1563  ND2 ASN A 160      11.746  10.886  13.997  0.60 30.13           N  
ATOM   1564  OXT ASN A 160      11.743  13.132   9.351  0.60 26.52           O  
TER    1565      ASN A 160                                                      
END
MOLECULE T0482_7_107.pdb
EXPDTA     NMR, 20 STRUCTURES
ATOM     97  N   PRO A   7      -1.524  11.209   1.755  1.00  0.00           N 
ATOM     98  CA  PRO A   7      -0.374  10.698   2.544  1.00  0.00           C 
ATOM     99  C   PRO A   7      -0.850   9.805   3.722  1.00  0.00           C 
ATOM    100  O   PRO A   7      -1.278  10.304   4.769  1.00  0.00           O 
ATOM    101  CB  PRO A   7       0.357  11.990   3.010  1.00  0.00           C 
ATOM    102  CG  PRO A   7      -0.693  13.067   2.965  1.00  0.00           C 
ATOM    103  CD  PRO A   7      -1.639  12.691   1.839  1.00  0.00           C 
ATOM    104  HA  PRO A   7       0.295  10.112   1.912  1.00  0.00           H 
ATOM    105 2HB  PRO A   7       1.175  12.209   2.329  1.00  0.00           H 
ATOM    106 1HB  PRO A   7       0.755  11.857   4.011  1.00  0.00           H 
ATOM    107 2HG  PRO A   7      -0.229  14.028   2.770  1.00  0.00           H 
ATOM    108 1HG  PRO A   7      -1.226  13.101   3.913  1.00  0.00           H 
ATOM    109 2HD  PRO A   7      -1.329  13.151   0.907  1.00  0.00           H 
ATOM    110 1HD  PRO A   7      -2.654  12.988   2.079  1.00  0.00           H 
ATOM    111  N   GLY A   8      -0.828   8.476   3.495  1.00  0.00           N 
ATOM    112  CA  GLY A   8      -1.248   7.480   4.493  1.00  0.00           C 
ATOM    113  C   GLY A   8      -2.274   6.471   3.961  1.00  0.00           C 
ATOM    114  O   GLY A   8      -2.481   5.419   4.582  1.00  0.00           O 
ATOM    115  H   GLY A   8      -0.501   8.160   2.624  1.00  0.00           H 
ATOM    116 2HA  GLY A   8      -1.674   7.981   5.357  1.00  0.00           H 
ATOM    117 1HA  GLY A   8      -0.369   6.938   4.816  1.00  0.00           H 
ATOM    118  N   HIS A   9      -2.906   6.777   2.799  1.00  0.00           N 
ATOM    119  CA  HIS A   9      -4.036   5.976   2.252  1.00  0.00           C 
ATOM    120  C   HIS A   9      -4.258   6.233   0.734  1.00  0.00           C 
ATOM    121  O   HIS A   9      -3.912   7.285   0.219  1.00  0.00           O 
ATOM    122  CB  HIS A   9      -5.320   6.285   3.075  1.00  0.00           C 
ATOM    123  CG  HIS A   9      -6.600   5.708   2.529  1.00  0.00           C 
ATOM    124  ND1 HIS A   9      -7.504   6.454   1.813  1.00  0.00           N 
ATOM    125  CD2 HIS A   9      -7.111   4.456   2.576  1.00  0.00           C 
ATOM    126  CE1 HIS A   9      -8.507   5.700   1.449  1.00  0.00           C 
ATOM    127  NE2 HIS A   9      -8.304   4.476   1.894  1.00  0.00           N 
ATOM    128  H   HIS A   9      -2.612   7.568   2.302  1.00  0.00           H 
ATOM    129  HA  HIS A   9      -3.784   4.925   2.378  1.00  0.00           H 
ATOM    130 2HB  HIS A   9      -5.440   7.359   3.139  1.00  0.00           H 
ATOM    131 1HB  HIS A   9      -5.194   5.897   4.079  1.00  0.00           H 
ATOM    132  HD1 HIS A   9      -7.432   7.415   1.622  1.00  0.00           H 
ATOM    133  HD2 HIS A   9      -6.669   3.600   3.069  1.00  0.00           H 
ATOM    134  HE1 HIS A   9      -9.362   6.027   0.875  1.00  0.00           H 
ATOM    135  HE2 HIS A   9      -9.027   3.830   2.038  1.00  0.00           H 
ATOM    136  N   LEU A  10      -4.830   5.233   0.035  1.00  0.00           N 
ATOM    137  CA  LEU A  10      -5.185   5.300  -1.392  1.00  0.00           C 
ATOM    138  C   LEU A  10      -6.605   4.693  -1.551  1.00  0.00           C 
ATOM    139  O   LEU A  10      -6.861   3.572  -1.112  1.00  0.00           O 
ATOM    140  CB  LEU A  10      -4.118   4.513  -2.232  1.00  0.00           C 
ATOM    141  CG  LEU A  10      -3.964   4.864  -3.759  1.00  0.00           C 
ATOM    142  CD1 LEU A  10      -2.752   4.129  -4.371  1.00  0.00           C 
ATOM    143  CD2 LEU A  10      -5.232   4.548  -4.578  1.00  0.00           C 
ATOM    144  H   LEU A  10      -5.018   4.397   0.485  1.00  0.00           H 
ATOM    145  HA  LEU A  10      -5.199   6.343  -1.700  1.00  0.00           H 
ATOM    146 2HB  LEU A  10      -4.344   3.454  -2.152  1.00  0.00           H 
ATOM    147 1HB  LEU A  10      -3.151   4.673  -1.763  1.00  0.00           H 
ATOM    148  HG  LEU A  10      -3.771   5.929  -3.848  1.00  0.00           H 
ATOM    149 1HD1 LEU A  10      -1.853   4.401  -3.832  1.00  0.00           H 
ATOM    150 2HD1 LEU A  10      -2.633   4.414  -5.410  1.00  0.00           H 
ATOM    151 3HD1 LEU A  10      -2.899   3.060  -4.308  1.00  0.00           H 
ATOM    152 1HD2 LEU A  10      -5.076   4.802  -5.618  1.00  0.00           H 
ATOM    153 2HD2 LEU A  10      -6.065   5.124  -4.196  1.00  0.00           H 
ATOM    154 3HD2 LEU A  10      -5.468   3.492  -4.500  1.00  0.00           H 
ATOM    155  N   HIS A  11      -7.521   5.455  -2.162  1.00  0.00           N 
ATOM    156  CA  HIS A  11      -8.909   5.023  -2.451  1.00  0.00           C 
ATOM    157  C   HIS A  11      -9.022   4.538  -3.915  1.00  0.00           C 
ATOM    158  O   HIS A  11      -8.440   5.144  -4.808  1.00  0.00           O 
ATOM    159  CB  HIS A  11      -9.859   6.222  -2.187  1.00  0.00           C 
ATOM    160  CG  HIS A  11     -11.311   6.011  -2.554  1.00  0.00           C 
ATOM    161  ND1 HIS A  11     -12.115   7.025  -3.033  1.00  0.00           N 
ATOM    162  CD2 HIS A  11     -12.106   4.912  -2.473  1.00  0.00           C 
ATOM    163  CE1 HIS A  11     -13.331   6.558  -3.230  1.00  0.00           C 
ATOM    164  NE2 HIS A  11     -13.352   5.285  -2.896  1.00  0.00           N 
ATOM    165  H   HIS A  11      -7.258   6.357  -2.423  1.00  0.00           H 
ATOM    166  HA  HIS A  11      -9.168   4.208  -1.778  1.00  0.00           H 
ATOM    167 2HB  HIS A  11      -9.500   7.080  -2.747  1.00  0.00           H 
ATOM    168 1HB  HIS A  11      -9.827   6.467  -1.132  1.00  0.00           H 
ATOM    169  HD1 HIS A  11     -11.837   7.951  -3.202  1.00  0.00           H 
ATOM    170  HD2 HIS A  11     -11.792   3.914  -2.187  1.00  0.00           H 
ATOM    171  HE1 HIS A  11     -14.169   7.125  -3.598  1.00  0.00           H 
ATOM    172  HE2 HIS A  11     -14.164   4.745  -2.804  1.00  0.00           H 
ATOM    173  N   LEU A  12      -9.781   3.446  -4.141  1.00  0.00           N 
ATOM    174  CA  LEU A  12      -9.995   2.857  -5.482  1.00  0.00           C 
ATOM    175  C   LEU A  12     -11.490   2.576  -5.724  1.00  0.00           C 
ATOM    176  O   LEU A  12     -12.110   1.830  -4.975  1.00  0.00           O 
ATOM    177  CB  LEU A  12      -9.193   1.535  -5.642  1.00  0.00           C 
ATOM    178  CG  LEU A  12      -7.639   1.670  -5.707  1.00  0.00           C 
ATOM    179  CD1 LEU A  12      -6.956   0.282  -5.754  1.00  0.00           C 
ATOM    180  CD2 LEU A  12      -7.218   2.547  -6.912  1.00  0.00           C 
ATOM    181  H   LEU A  12     -10.225   3.025  -3.380  1.00  0.00           H 
ATOM    182  HA  LEU A  12      -9.648   3.566  -6.232  1.00  0.00           H 
ATOM    183 2HB  LEU A  12      -9.523   1.038  -6.552  1.00  0.00           H 
ATOM    184 1HB  LEU A  12      -9.444   0.894  -4.804  1.00  0.00           H 
ATOM    185  HG  LEU A  12      -7.294   2.168  -4.805  1.00  0.00           H 
ATOM    186 1HD1 LEU A  12      -7.273  -0.256  -6.639  1.00  0.00           H 
ATOM    187 2HD1 LEU A  12      -7.230  -0.289  -4.875  1.00  0.00           H 
ATOM    188 3HD1 LEU A  12      -5.881   0.403  -5.771  1.00  0.00           H 
ATOM    189 1HD2 LEU A  12      -7.556   2.093  -7.836  1.00  0.00           H 
ATOM    190 2HD2 LEU A  12      -6.140   2.646  -6.937  1.00  0.00           H 
ATOM    191 3HD2 LEU A  12      -7.659   3.531  -6.817  1.00  0.00           H 
ATOM    192  N   VAL A  13     -12.051   3.244  -6.737  1.00  0.00           N 
ATOM    193  CA  VAL A  13     -13.336   2.894  -7.399  1.00  0.00           C 
ATOM    194  C   VAL A  13     -13.076   3.039  -8.916  1.00  0.00           C 
ATOM    195  O   VAL A  13     -12.109   3.725  -9.296  1.00  0.00           O 
ATOM    196  CB  VAL A  13     -14.527   3.828  -6.930  1.00  0.00           C 
ATOM    197  CG1 VAL A  13     -15.858   3.513  -7.660  1.00  0.00           C 
ATOM    198  CG2 VAL A  13     -14.735   3.741  -5.402  1.00  0.00           C 
ATOM    199  H   VAL A  13     -11.580   4.036  -7.069  1.00  0.00           H 
ATOM    200  HA  VAL A  13     -13.578   1.856  -7.176  1.00  0.00           H 
ATOM    201  HB  VAL A  13     -14.255   4.855  -7.166  1.00  0.00           H 
ATOM    202 1HG1 VAL A  13     -15.729   3.647  -8.725  1.00  0.00           H 
ATOM    203 2HG1 VAL A  13     -16.639   4.177  -7.311  1.00  0.00           H 
ATOM    204 3HG1 VAL A  13     -16.149   2.486  -7.461  1.00  0.00           H 
ATOM    205 1HG2 VAL A  13     -15.544   4.398  -5.098  1.00  0.00           H 
ATOM    206 2HG2 VAL A  13     -13.829   4.040  -4.895  1.00  0.00           H 
ATOM    207 3HG2 VAL A  13     -14.981   2.723  -5.124  1.00  0.00           H 
ATOM    208  N   SER A  14     -13.897   2.435  -9.805  1.00  0.00           N 
ATOM    209  CA  SER A  14     -13.634   2.491 -11.249  1.00  0.00           C 
ATOM    210  C   SER A  14     -14.392   3.701 -11.809  1.00  0.00           C 
ATOM    211  O   SER A  14     -15.602   3.825 -11.575  1.00  0.00           O 
ATOM    212  CB  SER A  14     -14.108   1.193 -11.941  1.00  0.00           C 
ATOM    213  OG  SER A  14     -13.741   1.176 -13.314  1.00  0.00           O 
ATOM    214  H   SER A  14     -14.777   2.087  -9.568  1.00  0.00           H 
ATOM    215  HA  SER A  14     -12.561   2.613 -11.412  1.00  0.00           H 
ATOM    216 2HB  SER A  14     -15.188   1.105 -11.864  1.00  0.00           H 
ATOM    217 1HB  SER A  14     -13.651   0.341 -11.457  1.00  0.00           H 
ATOM    218  HG  SER A  14     -14.208   0.462 -13.761  1.00  0.00           H 
ATOM    219  N   LEU A  15     -13.686   4.605 -12.504  1.00  0.00           N 
ATOM    220  CA  LEU A  15     -14.301   5.816 -13.070  1.00  0.00           C 
ATOM    221  C   LEU A  15     -15.236   5.433 -14.251  1.00  0.00           C 
ATOM    222  O   LEU A  15     -14.894   4.533 -15.035  1.00  0.00           O 
ATOM    223  CB  LEU A  15     -13.192   6.848 -13.458  1.00  0.00           C 
ATOM    224  CG  LEU A  15     -12.126   6.418 -14.537  1.00  0.00           C 
ATOM    225  CD1 LEU A  15     -12.578   6.764 -15.978  1.00  0.00           C 
ATOM    226  CD2 LEU A  15     -10.733   7.029 -14.237  1.00  0.00           C 
ATOM    227  H   LEU A  15     -12.733   4.445 -12.654  1.00  0.00           H 
ATOM    228  HA  LEU A  15     -14.911   6.258 -12.283  1.00  0.00           H 
ATOM    229 2HB  LEU A  15     -12.665   7.103 -12.541  1.00  0.00           H 
ATOM    230 1HB  LEU A  15     -13.685   7.754 -13.803  1.00  0.00           H 
ATOM    231  HG  LEU A  15     -12.016   5.339 -14.497  1.00  0.00           H 
ATOM    232 1HD1 LEU A  15     -11.837   6.415 -16.690  1.00  0.00           H 
ATOM    233 2HD1 LEU A  15     -12.689   7.836 -16.077  1.00  0.00           H 
ATOM    234 3HD1 LEU A  15     -13.525   6.286 -16.189  1.00  0.00           H 
ATOM    235 1HD2 LEU A  15     -10.023   6.705 -14.987  1.00  0.00           H 
ATOM    236 2HD2 LEU A  15     -10.392   6.700 -13.265  1.00  0.00           H 
ATOM    237 3HD2 LEU A  15     -10.795   8.111 -14.245  1.00  0.00           H 
ATOM    238  N   PRO A  16     -16.448   6.073 -14.363  1.00  0.00           N 
ATOM    239  CA  PRO A  16     -17.434   5.743 -15.418  1.00  0.00           C 
ATOM    240  C   PRO A  16     -16.866   5.982 -16.835  1.00  0.00           C 
ATOM    241  O   PRO A  16     -16.247   7.022 -17.106  1.00  0.00           O 
ATOM    242  CB  PRO A  16     -18.642   6.673 -15.098  1.00  0.00           C 
ATOM    243  CG  PRO A  16     -18.065   7.780 -14.273  1.00  0.00           C 
ATOM    244  CD  PRO A  16     -16.955   7.147 -13.467  1.00  0.00           C 
ATOM    245  HA  PRO A  16     -17.746   4.703 -15.334  1.00  0.00           H 
ATOM    246 2HB  PRO A  16     -19.388   6.117 -14.538  1.00  0.00           H 
ATOM    247 1HB  PRO A  16     -19.093   7.050 -16.012  1.00  0.00           H 
ATOM    248 2HG  PRO A  16     -18.825   8.194 -13.618  1.00  0.00           H 
ATOM    249 1HG  PRO A  16     -17.668   8.564 -14.918  1.00  0.00           H 
ATOM    250 2HD  PRO A  16     -17.337   6.725 -12.541  1.00  0.00           H 
ATOM    251 1HD  PRO A  16     -16.180   7.876 -13.251  1.00  0.00           H 
ATOM    252  N   GLY A  17     -17.074   4.995 -17.717  1.00  0.00           N 
ATOM    253  CA  GLY A  17     -16.491   4.985 -19.061  1.00  0.00           C 
ATOM    254  C   GLY A  17     -15.361   3.967 -19.184  1.00  0.00           C 
ATOM    255  O   GLY A  17     -15.148   3.398 -20.260  1.00  0.00           O 
ATOM    256  H   GLY A  17     -17.649   4.248 -17.447  1.00  0.00           H 
ATOM    257 2HA  GLY A  17     -16.104   5.969 -19.310  1.00  0.00           H 
ATOM    258 1HA  GLY A  17     -17.269   4.735 -19.770  1.00  0.00           H 
ATOM    259  N   LEU A  18     -14.629   3.741 -18.070  1.00  0.00           N 
ATOM    260  CA  LEU A  18     -13.489   2.804 -18.026  1.00  0.00           C 
ATOM    261  C   LEU A  18     -13.995   1.352 -17.944  1.00  0.00           C 
ATOM    262  O   LEU A  18     -13.786   0.564 -18.878  1.00  0.00           O 
ATOM    263  CB  LEU A  18     -12.565   3.146 -16.822  1.00  0.00           C 
ATOM    264  CG  LEU A  18     -11.286   2.264 -16.636  1.00  0.00           C 
ATOM    265  CD1 LEU A  18     -10.365   2.318 -17.878  1.00  0.00           C 
ATOM    266  CD2 LEU A  18     -10.522   2.674 -15.355  1.00  0.00           C 
ATOM    267  H   LEU A  18     -14.867   4.225 -17.248  1.00  0.00           H 
ATOM    268  HA  LEU A  18     -12.918   2.926 -18.946  1.00  0.00           H 
ATOM    269 2HB  LEU A  18     -13.161   3.074 -15.917  1.00  0.00           H 
ATOM    270 1HB  LEU A  18     -12.248   4.180 -16.929  1.00  0.00           H 
ATOM    271  HG  LEU A  18     -11.593   1.231 -16.512  1.00  0.00           H 
ATOM    272 1HD1 LEU A  18     -10.893   1.940 -18.743  1.00  0.00           H 
ATOM    273 2HD1 LEU A  18      -9.487   1.707 -17.708  1.00  0.00           H 
ATOM    274 3HD1 LEU A  18     -10.055   3.340 -18.066  1.00  0.00           H 
ATOM    275 1HD2 LEU A  18      -9.649   2.044 -15.234  1.00  0.00           H 
ATOM    276 2HD2 LEU A  18     -11.164   2.554 -14.491  1.00  0.00           H 
ATOM    277 3HD2 LEU A  18     -10.209   3.709 -15.426  1.00  0.00           H 
ATOM    278  N   ASP A  19     -14.673   1.023 -16.827  1.00  0.00           N 
ATOM    279  CA  ASP A  19     -15.207  -0.327 -16.570  1.00  0.00           C 
ATOM    280  C   ASP A  19     -16.367  -0.235 -15.566  1.00  0.00           C 
ATOM    281  O   ASP A  19     -16.154   0.074 -14.392  1.00  0.00           O 
ATOM    282  CB  ASP A  19     -14.083  -1.273 -16.043  1.00  0.00           C 
ATOM    283  CG  ASP A  19     -14.572  -2.707 -15.753  1.00  0.00           C 
ATOM    284  OD1 ASP A  19     -15.077  -3.371 -16.683  1.00  0.00           O 
ATOM    285  OD2 ASP A  19     -14.447  -3.184 -14.604  1.00  0.00           O 
ATOM    286  H   ASP A  19     -14.821   1.715 -16.146  1.00  0.00           H 
ATOM    287  HA  ASP A  19     -15.589  -0.725 -17.509  1.00  0.00           H 
ATOM    288 2HB  ASP A  19     -13.666  -0.849 -15.135  1.00  0.00           H 
ATOM    289 1HB  ASP A  19     -13.293  -1.330 -16.787  1.00  0.00           H 
ATOM    290  N   GLN A  20     -17.601  -0.473 -16.047  1.00  0.00           N 
ATOM    291  CA  GLN A  20     -18.811  -0.441 -15.212  1.00  0.00           C 
ATOM    292  C   GLN A  20     -18.952  -1.771 -14.446  1.00  0.00           C 
ATOM    293  O   GLN A  20     -19.638  -2.702 -14.884  1.00  0.00           O 
ATOM    294  CB  GLN A  20     -20.082  -0.121 -16.069  1.00  0.00           C 
ATOM    295  CG  GLN A  20     -20.203   1.352 -16.540  1.00  0.00           C 
ATOM    296  CD  GLN A  20     -19.119   1.782 -17.538  1.00  0.00           C 
ATOM    297  OE1 GLN A  20     -18.051   2.270 -17.156  1.00  0.00           O 
ATOM    298  NE2 GLN A  20     -19.390   1.619 -18.824  1.00  0.00           N 
ATOM    299  H   GLN A  20     -17.698  -0.678 -16.999  1.00  0.00           H 
ATOM    300  HA  GLN A  20     -18.685   0.360 -14.482  1.00  0.00           H 
ATOM    301 2HB  GLN A  20     -20.964  -0.349 -15.480  1.00  0.00           H 
ATOM    302 1HB  GLN A  20     -20.085  -0.758 -16.947  1.00  0.00           H 
ATOM    303 2HG  GLN A  20     -20.148   1.997 -15.673  1.00  0.00           H 
ATOM    304 1HG  GLN A  20     -21.173   1.487 -17.008  1.00  0.00           H 
ATOM    305 2HE2 GLN A  20     -20.256   1.233 -19.070  1.00  0.00           H 
ATOM    306 1HE2 GLN A  20     -18.712   1.891 -19.479  1.00  0.00           H 
ATOM    307  N   GLN A  21     -18.229  -1.843 -13.323  1.00  0.00           N 
ATOM    308  CA  GLN A  21     -18.253  -2.971 -12.386  1.00  0.00           C 
ATOM    309  C   GLN A  21     -18.057  -2.406 -10.977  1.00  0.00           C 
ATOM    310  O   GLN A  21     -17.362  -1.389 -10.806  1.00  0.00           O 
ATOM    311  CB  GLN A  21     -17.137  -3.996 -12.730  1.00  0.00           C 
ATOM    312  CG  GLN A  21     -17.169  -5.302 -11.906  1.00  0.00           C 
ATOM    313  CD  GLN A  21     -16.076  -6.297 -12.307  1.00  0.00           C 
ATOM    314  OE1 GLN A  21     -16.263  -7.107 -13.214  1.00  0.00           O 
ATOM    315  NE2 GLN A  21     -14.933  -6.255 -11.635  1.00  0.00           N 
ATOM    316  H   GLN A  21     -17.645  -1.082 -13.106  1.00  0.00           H 
ATOM    317  HA  GLN A  21     -19.226  -3.453 -12.446  1.00  0.00           H 
ATOM    318 2HB  GLN A  21     -16.173  -3.523 -12.578  1.00  0.00           H 
ATOM    319 1HB  GLN A  21     -17.223  -4.257 -13.781  1.00  0.00           H 
ATOM    320 2HG  GLN A  21     -18.136  -5.775 -12.042  1.00  0.00           H 
ATOM    321 1HG  GLN A  21     -17.046  -5.055 -10.856  1.00  0.00           H 
ATOM    322 2HE2 GLN A  21     -14.843  -5.598 -10.921  1.00  0.00           H 
ATOM    323 1HE2 GLN A  21     -14.221  -6.886 -11.881  1.00  0.00           H 
ATOM    324  N   ASP A  22     -18.655  -3.067  -9.977  1.00  0.00           N 
ATOM    325  CA  ASP A  22     -18.577  -2.626  -8.576  1.00  0.00           C 
ATOM    326  C   ASP A  22     -17.223  -3.037  -7.987  1.00  0.00           C 
ATOM    327  O   ASP A  22     -17.087  -4.115  -7.404  1.00  0.00           O 
ATOM    328  CB  ASP A  22     -19.759  -3.213  -7.751  1.00  0.00           C 
ATOM    329  CG  ASP A  22     -19.741  -2.828  -6.254  1.00  0.00           C 
ATOM    330  OD1 ASP A  22     -19.571  -3.714  -5.384  1.00  0.00           O 
ATOM    331  OD2 ASP A  22     -19.891  -1.624  -5.945  1.00  0.00           O 
ATOM    332  H   ASP A  22     -19.128  -3.901 -10.182  1.00  0.00           H 
ATOM    333  HA  ASP A  22     -18.645  -1.536  -8.565  1.00  0.00           H 
ATOM    334 2HB  ASP A  22     -19.737  -4.294  -7.837  1.00  0.00           H 
ATOM    335 1HB  ASP A  22     -20.690  -2.857  -8.177  1.00  0.00           H 
ATOM    336  N   ILE A  23     -16.190  -2.218  -8.247  1.00  0.00           N 
ATOM    337  CA  ILE A  23     -14.882  -2.380  -7.609  1.00  0.00           C 
ATOM    338  C   ILE A  23     -14.695  -1.215  -6.635  1.00  0.00           C 
ATOM    339  O   ILE A  23     -14.928  -0.050  -6.983  1.00  0.00           O 
ATOM    340  CB  ILE A  23     -13.684  -2.511  -8.656  1.00  0.00           C 
ATOM    341  CG1 ILE A  23     -13.206  -1.140  -9.277  1.00  0.00           C 
ATOM    342  CG2 ILE A  23     -14.069  -3.505  -9.777  1.00  0.00           C 
ATOM    343  CD1 ILE A  23     -11.995  -0.499  -8.596  1.00  0.00           C 
ATOM    344  H   ILE A  23     -16.317  -1.488  -8.895  1.00  0.00           H 
ATOM    345  HA  ILE A  23     -14.909  -3.306  -7.026  1.00  0.00           H 
ATOM    346  HB  ILE A  23     -12.846  -2.960  -8.120  1.00  0.00           H 
ATOM    347 2HG1 ILE A  23     -14.018  -0.422  -9.237  1.00  0.00           H 
ATOM    348 1HG1 ILE A  23     -12.928  -1.283 -10.315  1.00  0.00           H 
ATOM    349 1HG2 ILE A  23     -13.249  -3.606 -10.478  1.00  0.00           H 
ATOM    350 2HG2 ILE A  23     -14.943  -3.142 -10.305  1.00  0.00           H 
ATOM    351 3HG2 ILE A  23     -14.292  -4.474  -9.348  1.00  0.00           H 
ATOM    352 1HD1 ILE A  23     -12.217  -0.305  -7.554  1.00  0.00           H 
ATOM    353 2HD1 ILE A  23     -11.763   0.433  -9.090  1.00  0.00           H 
ATOM    354 3HD1 ILE A  23     -11.147  -1.164  -8.669  1.00  0.00           H 
ATOM    355  N   ASN A  24     -14.353  -1.554  -5.398  1.00  0.00           N 
ATOM    356  CA  ASN A  24     -14.068  -0.582  -4.346  1.00  0.00           C 
ATOM    357  C   ASN A  24     -13.066  -1.203  -3.375  1.00  0.00           C 
ATOM    358  O   ASN A  24     -13.285  -2.299  -2.847  1.00  0.00           O 
ATOM    359  CB  ASN A  24     -15.359  -0.070  -3.644  1.00  0.00           C 
ATOM    360  CG  ASN A  24     -16.286  -1.164  -3.116  1.00  0.00           C 
ATOM    361  OD1 ASN A  24     -16.199  -1.563  -1.958  1.00  0.00           O 
ATOM    362  ND2 ASN A  24     -17.171  -1.666  -3.973  1.00  0.00           N 
ATOM    363  H   ASN A  24     -14.280  -2.510  -5.190  1.00  0.00           H 
ATOM    364  HA  ASN A  24     -13.581   0.271  -4.826  1.00  0.00           H 
ATOM    365 2HB  ASN A  24     -15.923   0.534  -4.348  1.00  0.00           H 
ATOM    366 1HB  ASN A  24     -15.078   0.563  -2.808  1.00  0.00           H 
ATOM    367 2HD2 ASN A  24     -17.185  -1.311  -4.887  1.00  0.00           H 
ATOM    368 1HD2 ASN A  24     -17.765  -2.384  -3.662  1.00  0.00           H 
ATOM    369  N   ILE A  25     -11.938  -0.500  -3.196  1.00  0.00           N 
ATOM    370  CA  ILE A  25     -10.764  -0.971  -2.451  1.00  0.00           C 
ATOM    371  C   ILE A  25     -10.221   0.217  -1.653  1.00  0.00           C 
ATOM    372  O   ILE A  25     -10.222   1.356  -2.139  1.00  0.00           O 
ATOM    373  CB  ILE A  25      -9.608  -1.495  -3.399  1.00  0.00           C 
ATOM    374  CG1 ILE A  25     -10.131  -2.536  -4.436  1.00  0.00           C 
ATOM    375  CG2 ILE A  25      -8.430  -2.089  -2.576  1.00  0.00           C 
ATOM    376  CD1 ILE A  25      -9.111  -2.967  -5.474  1.00  0.00           C 
ATOM    377  H   ILE A  25     -11.906   0.417  -3.535  1.00  0.00           H 
ATOM    378  HA  ILE A  25     -11.067  -1.768  -1.773  1.00  0.00           H 
ATOM    379  HB  ILE A  25      -9.219  -0.635  -3.944  1.00  0.00           H 
ATOM    380 2HG1 ILE A  25     -10.978  -2.118  -4.970  1.00  0.00           H 
ATOM    381 1HG1 ILE A  25     -10.456  -3.431  -3.919  1.00  0.00           H 
ATOM    382 1HG2 ILE A  25      -7.635  -2.401  -3.245  1.00  0.00           H 
ATOM    383 2HG2 ILE A  25      -8.773  -2.946  -2.010  1.00  0.00           H 
ATOM    384 3HG2 ILE A  25      -8.045  -1.342  -1.893  1.00  0.00           H 
ATOM    385 1HD1 ILE A  25      -9.569  -3.666  -6.155  1.00  0.00           H 
ATOM    386 2HD1 ILE A  25      -8.273  -3.445  -4.984  1.00  0.00           H 
ATOM    387 3HD1 ILE A  25      -8.759  -2.105  -6.028  1.00  0.00           H 
ATOM    388  N   HIS A  26      -9.790  -0.046  -0.427  1.00  0.00           N 
ATOM    389  CA  HIS A  26      -9.086   0.923   0.411  1.00  0.00           C 
ATOM    390  C   HIS A  26      -7.667   0.375   0.593  1.00  0.00           C 
ATOM    391  O   HIS A  26      -7.521  -0.815   0.856  1.00  0.00           O 
ATOM    392  CB  HIS A  26      -9.795   1.066   1.797  1.00  0.00           C 
ATOM    393  CG  HIS A  26     -11.306   1.197   1.770  1.00  0.00           C 
ATOM    394  ND1 HIS A  26     -12.106   0.832   2.833  1.00  0.00           N 
ATOM    395  CD2 HIS A  26     -12.158   1.660   0.818  1.00  0.00           C 
ATOM    396  CE1 HIS A  26     -13.369   1.063   2.538  1.00  0.00           C 
ATOM    397  NE2 HIS A  26     -13.425   1.566   1.323  1.00  0.00           N 
ATOM    398  H   HIS A  26      -9.945  -0.938  -0.061  1.00  0.00           H 
ATOM    399  HA  HIS A  26      -9.046   1.888  -0.093  1.00  0.00           H 
ATOM    400 2HB  HIS A  26      -9.402   1.943   2.299  1.00  0.00           H 
ATOM    401 1HB  HIS A  26      -9.568   0.195   2.400  1.00  0.00           H 
ATOM    402  HD1 HIS A  26     -11.791   0.444   3.677  1.00  0.00           H 
ATOM    403  HD2 HIS A  26     -11.887   2.016  -0.165  1.00  0.00           H 
ATOM    404  HE1 HIS A  26     -14.214   0.866   3.177  1.00  0.00           H 
ATOM    405  HE2 HIS A  26     -14.248   1.778   0.837  1.00  0.00           H 
ATOM    406  N   ILE A  27      -6.632   1.213   0.442  1.00  0.00           N 
ATOM    407  CA  ILE A  27      -5.231   0.800   0.655  1.00  0.00           C 
ATOM    408  C   ILE A  27      -4.631   1.734   1.713  1.00  0.00           C 
ATOM    409  O   ILE A  27      -4.342   2.889   1.438  1.00  0.00           O 
ATOM    410  CB  ILE A  27      -4.367   0.863  -0.670  1.00  0.00           C 
ATOM    411  CG1 ILE A  27      -5.003  -0.016  -1.805  1.00  0.00           C 
ATOM    412  CG2 ILE A  27      -2.892   0.432  -0.400  1.00  0.00           C 
ATOM    413  CD1 ILE A  27      -4.245  -0.003  -3.128  1.00  0.00           C 
ATOM    414  H   ILE A  27      -6.809   2.142   0.228  1.00  0.00           H 
ATOM    415  HA  ILE A  27      -5.211  -0.228   1.030  1.00  0.00           H 
ATOM    416  HB  ILE A  27      -4.350   1.899  -1.002  1.00  0.00           H 
ATOM    417 2HG1 ILE A  27      -6.014   0.331  -2.005  1.00  0.00           H 
ATOM    418 1HG1 ILE A  27      -5.052  -1.046  -1.477  1.00  0.00           H 
ATOM    419 1HG2 ILE A  27      -2.866  -0.597  -0.063  1.00  0.00           H 
ATOM    420 2HG2 ILE A  27      -2.460   1.063   0.368  1.00  0.00           H 
ATOM    421 3HG2 ILE A  27      -2.303   0.526  -1.304  1.00  0.00           H 
ATOM    422 1HD1 ILE A  27      -4.774  -0.612  -3.849  1.00  0.00           H 
ATOM    423 2HD1 ILE A  27      -3.252  -0.404  -2.985  1.00  0.00           H 
ATOM    424 3HD1 ILE A  27      -4.178   1.010  -3.502  1.00  0.00           H 
ATOM    425  N   ARG A  28      -4.461   1.212   2.912  1.00  0.00           N 
ATOM    426  CA  ARG A  28      -3.893   1.936   4.051  1.00  0.00           C 
ATOM    427  C   ARG A  28      -2.453   1.471   4.225  1.00  0.00           C 
ATOM    428  O   ARG A  28      -2.190   0.273   4.173  1.00  0.00           O 
ATOM    429  CB  ARG A  28      -4.735   1.635   5.320  1.00  0.00           C 
ATOM    430  CG  ARG A  28      -4.268   2.331   6.615  1.00  0.00           C 
ATOM    431  CD  ARG A  28      -5.196   2.012   7.802  1.00  0.00           C 
ATOM    432  NE  ARG A  28      -4.780   2.692   9.038  1.00  0.00           N 
ATOM    433  CZ  ARG A  28      -5.565   2.918  10.102  1.00  0.00           C 
ATOM    434  NH1 ARG A  28      -6.853   2.609  10.074  1.00  0.00           N 
ATOM    435  NH2 ARG A  28      -5.055   3.463  11.194  1.00  0.00           N 
ATOM    436  H   ARG A  28      -4.724   0.286   3.047  1.00  0.00           H 
ATOM    437  HA  ARG A  28      -3.915   3.005   3.845  1.00  0.00           H 
ATOM    438 2HB  ARG A  28      -4.735   0.561   5.487  1.00  0.00           H 
ATOM    439 1HB  ARG A  28      -5.757   1.946   5.124  1.00  0.00           H 
ATOM    440 2HG  ARG A  28      -4.259   3.403   6.455  1.00  0.00           H 
ATOM    441 1HG  ARG A  28      -3.266   1.998   6.855  1.00  0.00           H 
ATOM    442 2HD  ARG A  28      -5.188   0.942   7.974  1.00  0.00           H 
ATOM    443 1HD  ARG A  28      -6.206   2.323   7.549  1.00  0.00           H 
ATOM    444  HE  ARG A  28      -3.851   2.976   9.087  1.00  0.00           H 
ATOM    445 1HH1 ARG A  28      -7.258   2.207   9.252  1.00  0.00           H 
ATOM    446 2HH1 ARG A  28      -7.429   2.778  10.877  1.00  0.00           H 
ATOM    447 1HH2 ARG A  28      -4.081   3.705  11.226  1.00  0.00           H 
ATOM    448 2HH2 ARG A  28      -5.638   3.639  11.992  1.00  0.00           H 
ATOM    449  N   TYR A  29      -1.520   2.408   4.386  1.00  0.00           N 
ATOM    450  CA  TYR A  29      -0.120   2.079   4.660  1.00  0.00           C 
ATOM    451  C   TYR A  29       0.343   2.884   5.878  1.00  0.00           C 
ATOM    452  O   TYR A  29       0.193   4.113   5.923  1.00  0.00           O 
ATOM    453  CB  TYR A  29       0.775   2.295   3.402  1.00  0.00           C 
ATOM    454  CG  TYR A  29       0.919   3.736   2.880  1.00  0.00           C 
ATOM    455  CD1 TYR A  29       1.995   4.543   3.276  1.00  0.00           C 
ATOM    456  CD2 TYR A  29      -0.010   4.289   1.996  1.00  0.00           C 
ATOM    457  CE1 TYR A  29       2.132   5.833   2.814  1.00  0.00           C 
ATOM    458  CE2 TYR A  29       0.131   5.583   1.527  1.00  0.00           C 
ATOM    459  CZ  TYR A  29       1.200   6.351   1.944  1.00  0.00           C 
ATOM    460  OH  TYR A  29       1.331   7.643   1.500  1.00  0.00           O 
ATOM    461  H   TYR A  29      -1.780   3.354   4.348  1.00  0.00           H 
ATOM    462  HA  TYR A  29      -0.072   1.019   4.928  1.00  0.00           H 
ATOM    463 2HB  TYR A  29       0.368   1.693   2.593  1.00  0.00           H 
ATOM    464 1HB  TYR A  29       1.769   1.924   3.616  1.00  0.00           H 
ATOM    465  HD1 TYR A  29       2.730   4.140   3.961  1.00  0.00           H 
ATOM    466  HD2 TYR A  29      -0.853   3.689   1.669  1.00  0.00           H 
ATOM    467  HE1 TYR A  29       2.971   6.435   3.136  1.00  0.00           H 
ATOM    468  HE2 TYR A  29      -0.603   5.993   0.844  1.00  0.00           H 
ATOM    469  HH  TYR A  29       2.260   7.825   1.314  1.00  0.00           H 
ATOM    470  N   GLU A  30       0.830   2.161   6.889  1.00  0.00           N 
ATOM    471  CA  GLU A  30       1.320   2.727   8.146  1.00  0.00           C 
ATOM    472  C   GLU A  30       2.724   2.190   8.394  1.00  0.00           C 
ATOM    473  O   GLU A  30       2.901   0.979   8.560  1.00  0.00           O 
ATOM    474  CB  GLU A  30       0.393   2.334   9.327  1.00  0.00           C 
ATOM    475  CG  GLU A  30      -1.074   2.767   9.177  1.00  0.00           C 
ATOM    476  CD  GLU A  30      -1.896   2.506  10.444  1.00  0.00           C 
ATOM    477  OE1 GLU A  30      -2.382   1.374  10.628  1.00  0.00           O 
ATOM    478  OE2 GLU A  30      -2.071   3.435  11.258  1.00  0.00           O 
ATOM    479  H   GLU A  30       0.869   1.193   6.780  1.00  0.00           H 
ATOM    480  HA  GLU A  30       1.355   3.814   8.063  1.00  0.00           H 
ATOM    481 2HB  GLU A  30       0.789   2.783  10.237  1.00  0.00           H 
ATOM    482 1HB  GLU A  30       0.414   1.252   9.446  1.00  0.00           H 
ATOM    483 2HG  GLU A  30      -1.523   2.220   8.352  1.00  0.00           H 
ATOM    484 1HG  GLU A  30      -1.105   3.827   8.942  1.00  0.00           H 
ATOM    485  N   VAL A  31       3.716   3.081   8.411  1.00  0.00           N 
ATOM    486  CA  VAL A  31       5.100   2.694   8.661  1.00  0.00           C 
ATOM    487  C   VAL A  31       5.310   2.491  10.166  1.00  0.00           C 
ATOM    488  O   VAL A  31       5.168   3.426  10.963  1.00  0.00           O 
ATOM    489  CB  VAL A  31       6.101   3.756   8.089  1.00  0.00           C 
ATOM    490  CG1 VAL A  31       7.579   3.365   8.368  1.00  0.00           C 
ATOM    491  CG2 VAL A  31       5.846   3.944   6.576  1.00  0.00           C 
ATOM    492  H   VAL A  31       3.510   4.029   8.264  1.00  0.00           H 
ATOM    493  HA  VAL A  31       5.281   1.746   8.141  1.00  0.00           H 
ATOM    494  HB  VAL A  31       5.908   4.705   8.584  1.00  0.00           H 
ATOM    495 1HG1 VAL A  31       7.795   2.405   7.915  1.00  0.00           H 
ATOM    496 2HG1 VAL A  31       7.749   3.300   9.433  1.00  0.00           H 
ATOM    497 3HG1 VAL A  31       8.244   4.114   7.949  1.00  0.00           H 
ATOM    498 1HG2 VAL A  31       5.992   3.006   6.057  1.00  0.00           H 
ATOM    499 2HG2 VAL A  31       6.534   4.679   6.178  1.00  0.00           H 
ATOM    500 3HG2 VAL A  31       4.830   4.286   6.410  1.00  0.00           H 
ATOM    501  N   ARG A  32       5.643   1.256  10.526  1.00  0.00           N 
ATOM    502  CA  ARG A  32       5.896   0.833  11.906  1.00  0.00           C 
ATOM    503  C   ARG A  32       7.346   0.340  11.980  1.00  0.00           C 
ATOM    504  O   ARG A  32       7.948   0.008  10.952  1.00  0.00           O 
ATOM    505  CB  ARG A  32       4.916  -0.307  12.304  1.00  0.00           C 
ATOM    506  CG  ARG A  32       4.998  -0.761  13.789  1.00  0.00           C 
ATOM    507  CD  ARG A  32       4.409  -2.152  14.004  1.00  0.00           C 
ATOM    508  NE  ARG A  32       4.377  -2.570  15.419  1.00  0.00           N 
ATOM    509  CZ  ARG A  32       4.117  -3.823  15.844  1.00  0.00           C 
ATOM    510  NH1 ARG A  32       3.940  -4.810  14.972  1.00  0.00           N 
ATOM    511  NH2 ARG A  32       4.059  -4.089  17.142  1.00  0.00           N 
ATOM    512  H   ARG A  32       5.766   0.589   9.818  1.00  0.00           H 
ATOM    513  HA  ARG A  32       5.766   1.683  12.575  1.00  0.00           H 
ATOM    514 2HB  ARG A  32       5.114  -1.168  11.671  1.00  0.00           H 
ATOM    515 1HB  ARG A  32       3.899   0.025  12.114  1.00  0.00           H 
ATOM    516 2HG  ARG A  32       4.458  -0.049  14.404  1.00  0.00           H 
ATOM    517 1HG  ARG A  32       6.038  -0.774  14.102  1.00  0.00           H 
ATOM    518 2HD  ARG A  32       5.020  -2.858  13.448  1.00  0.00           H 
ATOM    519 1HD  ARG A  32       3.399  -2.172  13.615  1.00  0.00           H 
ATOM    520  HE  ARG A  32       4.541  -1.871  16.090  1.00  0.00           H 
ATOM    521 1HH1 ARG A  32       4.001  -4.633  13.983  1.00  0.00           H 
ATOM    522 2HH1 ARG A  32       3.748  -5.738  15.294  1.00  0.00           H 
ATOM    523 1HH2 ARG A  32       4.211  -3.359  17.813  1.00  0.00           H 
ATOM    524 2HH2 ARG A  32       3.862  -5.023  17.459  1.00  0.00           H 
ATOM    525  N   GLN A  33       7.916   0.305  13.183  1.00  0.00           N 
ATOM    526  CA  GLN A  33       9.278  -0.182  13.398  1.00  0.00           C 
ATOM    527  C   GLN A  33       9.241  -1.548  14.104  1.00  0.00           C 
ATOM    528  O   GLN A  33       8.695  -1.668  15.199  1.00  0.00           O 
ATOM    529  CB  GLN A  33      10.112   0.837  14.227  1.00  0.00           C 
ATOM    530  CG  GLN A  33      10.094   2.295  13.722  1.00  0.00           C 
ATOM    531  CD  GLN A  33      10.625   2.478  12.299  1.00  0.00           C 
ATOM    532  OE1 GLN A  33      11.831   2.616  12.086  1.00  0.00           O 
ATOM    533  NE2 GLN A  33       9.728   2.539  11.320  1.00  0.00           N 
ATOM    534  H   GLN A  33       7.399   0.599  13.953  1.00  0.00           H 
ATOM    535  HA  GLN A  33       9.747  -0.310  12.427  1.00  0.00           H 
ATOM    536 2HB  GLN A  33      11.149   0.504  14.248  1.00  0.00           H 
ATOM    537 1HB  GLN A  33       9.740   0.840  15.240  1.00  0.00           H 
ATOM    538 2HG  GLN A  33      10.694   2.900  14.390  1.00  0.00           H 
ATOM    539 1HG  GLN A  33       9.071   2.657  13.757  1.00  0.00           H 
ATOM    540 2HE2 GLN A  33       8.780   2.463  11.560  1.00  0.00           H 
ATOM    541 1HE2 GLN A  33      10.047   2.667  10.406  1.00  0.00           H 
ATOM    542  N   ASN A  34       9.791  -2.570  13.437  1.00  0.00           N 
ATOM    543  CA  ASN A  34      10.073  -3.899  14.031  1.00  0.00           C 
ATOM    544  C   ASN A  34      11.561  -3.977  14.409  1.00  0.00           C 
ATOM    545  O   ASN A  34      12.392  -3.360  13.754  1.00  0.00           O 
ATOM    546  CB  ASN A  34       9.684  -5.067  13.057  1.00  0.00           C 
ATOM    547  CG  ASN A  34      10.487  -5.200  11.737  1.00  0.00           C 
ATOM    548  OD1 ASN A  34      10.576  -6.289  11.190  1.00  0.00           O 
ATOM    549  ND2 ASN A  34      11.099  -4.142  11.222  1.00  0.00           N 
ATOM    550  H   ASN A  34      10.044  -2.421  12.513  1.00  0.00           H 
ATOM    551  HA  ASN A  34       9.480  -3.993  14.941  1.00  0.00           H 
ATOM    552 2HB  ASN A  34       8.638  -4.956  12.795  1.00  0.00           H 
ATOM    553 1HB  ASN A  34       9.801  -6.008  13.585  1.00  0.00           H 
ATOM    554 2HD2 ASN A  34      11.047  -3.299  11.691  1.00  0.00           H 
ATOM    555 1HD2 ASN A  34      11.561  -4.250  10.367  1.00  0.00           H 
ATOM    556  N   ALA A  35      11.890  -4.732  15.463  1.00  0.00           N 
ATOM    557  CA  ALA A  35      13.290  -4.924  15.913  1.00  0.00           C 
ATOM    558  C   ALA A  35      14.095  -5.817  14.937  1.00  0.00           C 
ATOM    559  O   ALA A  35      15.325  -5.902  15.038  1.00  0.00           O 
ATOM    560  CB  ALA A  35      13.302  -5.505  17.335  1.00  0.00           C 
ATOM    561  H   ALA A  35      11.175  -5.183  15.958  1.00  0.00           H 
ATOM    562  HA  ALA A  35      13.764  -3.947  15.952  1.00  0.00           H 
ATOM    563 1HB  ALA A  35      14.323  -5.601  17.686  1.00  0.00           H 
ATOM    564 2HB  ALA A  35      12.831  -6.480  17.334  1.00  0.00           H 
ATOM    565 3HB  ALA A  35      12.754  -4.849  18.000  1.00  0.00           H 
ATOM    566  N   GLU A  36      13.386  -6.469  13.998  1.00  0.00           N 
ATOM    567  CA  GLU A  36      13.981  -7.370  13.003  1.00  0.00           C 
ATOM    568  C   GLU A  36      14.697  -6.589  11.875  1.00  0.00           C 
ATOM    569  O   GLU A  36      15.887  -6.809  11.622  1.00  0.00           O 
ATOM    570  CB  GLU A  36      12.869  -8.279  12.419  1.00  0.00           C 
ATOM    571  CG  GLU A  36      13.323  -9.215  11.280  1.00  0.00           C 
ATOM    572  CD  GLU A  36      12.177 -10.041  10.683  1.00  0.00           C 
ATOM    573  OE1 GLU A  36      11.908 -11.160  11.173  1.00  0.00           O 
ATOM    574  OE2 GLU A  36      11.521  -9.564   9.732  1.00  0.00           O 
ATOM    575  H   GLU A  36      12.415  -6.351  13.989  1.00  0.00           H 
ATOM    576  HA  GLU A  36      14.709  -7.995  13.516  1.00  0.00           H 
ATOM    577 2HB  GLU A  36      12.075  -7.645  12.041  1.00  0.00           H 
ATOM    578 1HB  GLU A  36      12.468  -8.889  13.221  1.00  0.00           H 
ATOM    579 2HG  GLU A  36      14.083  -9.886  11.663  1.00  0.00           H 
ATOM    580 1HG  GLU A  36      13.759  -8.606  10.495  1.00  0.00           H 
ATOM    581  N   SER A  37      13.970  -5.671  11.209  1.00  0.00           N 
ATOM    582  CA  SER A  37      14.483  -4.925  10.024  1.00  0.00           C 
ATOM    583  C   SER A  37      14.617  -3.417  10.315  1.00  0.00           C 
ATOM    584  O   SER A  37      15.155  -2.659   9.498  1.00  0.00           O 
ATOM    585  CB  SER A  37      13.536  -5.167   8.813  1.00  0.00           C 
ATOM    586  OG  SER A  37      14.001  -4.528   7.627  1.00  0.00           O 
ATOM    587  H   SER A  37      13.059  -5.491  11.514  1.00  0.00           H 
ATOM    588  HA  SER A  37      15.469  -5.310   9.771  1.00  0.00           H 
ATOM    589 2HB  SER A  37      12.549  -4.786   9.043  1.00  0.00           H 
ATOM    590 1HB  SER A  37      13.467  -6.229   8.619  1.00  0.00           H 
ATOM    591  HG  SER A  37      14.531  -5.151   7.111  1.00  0.00           H 
ATOM    592  N   GLY A  38      14.134  -2.991  11.486  1.00  0.00           N 
ATOM    593  CA  GLY A  38      14.043  -1.571  11.818  1.00  0.00           C 
ATOM    594  C   GLY A  38      12.745  -1.004  11.274  1.00  0.00           C 
ATOM    595  O   GLY A  38      11.676  -1.339  11.769  1.00  0.00           O 
ATOM    596  H   GLY A  38      13.804  -3.653  12.124  1.00  0.00           H 
ATOM    597 2HA  GLY A  38      14.886  -1.030  11.397  1.00  0.00           H 
ATOM    598 1HA  GLY A  38      14.057  -1.462  12.896  1.00  0.00           H 
ATOM    599  N   ALA A  39      12.832  -0.183  10.225  1.00  0.00           N 
ATOM    600  CA  ALA A  39      11.649   0.341   9.520  1.00  0.00           C 
ATOM    601  C   ALA A  39      10.990  -0.747   8.646  1.00  0.00           C 
ATOM    602  O   ALA A  39      11.680  -1.587   8.058  1.00  0.00           O 
ATOM    603  CB  ALA A  39      12.030   1.568   8.663  1.00  0.00           C 
ATOM    604  H   ALA A  39      13.721   0.099   9.939  1.00  0.00           H 
ATOM    605  HA  ALA A  39      10.930   0.669  10.281  1.00  0.00           H 
ATOM    606 1HB  ALA A  39      12.477   2.328   9.294  1.00  0.00           H 
ATOM    607 2HB  ALA A  39      11.145   1.978   8.195  1.00  0.00           H 
ATOM    608 3HB  ALA A  39      12.738   1.278   7.894  1.00  0.00           H 
ATOM    609  N   TYR A  40       9.651  -0.736   8.615  1.00  0.00           N 
ATOM    610  CA  TYR A  40       8.839  -1.526   7.659  1.00  0.00           C 
ATOM    611  C   TYR A  40       7.460  -0.857   7.508  1.00  0.00           C 
ATOM    612  O   TYR A  40       7.109   0.021   8.301  1.00  0.00           O 
ATOM    613  CB  TYR A  40       8.708  -3.024   8.103  1.00  0.00           C 
ATOM    614  CG  TYR A  40       7.592  -3.358   9.113  1.00  0.00           C 
ATOM    615  CD1 TYR A  40       7.764  -3.160  10.484  1.00  0.00           C 
ATOM    616  CD2 TYR A  40       6.365  -3.897   8.687  1.00  0.00           C 
ATOM    617  CE1 TYR A  40       6.763  -3.475  11.382  1.00  0.00           C 
ATOM    618  CE2 TYR A  40       5.372  -4.200   9.583  1.00  0.00           C 
ATOM    619  CZ  TYR A  40       5.570  -3.999  10.923  1.00  0.00           C 
ATOM    620  OH  TYR A  40       4.568  -4.332  11.809  1.00  0.00           O 
ATOM    621  H   TYR A  40       9.182  -0.173   9.270  1.00  0.00           H 
ATOM    622  HA  TYR A  40       9.343  -1.485   6.691  1.00  0.00           H 
ATOM    623 2HB  TYR A  40       9.652  -3.336   8.538  1.00  0.00           H 
ATOM    624 1HB  TYR A  40       8.537  -3.629   7.219  1.00  0.00           H 
ATOM    625  HD1 TYR A  40       8.697  -2.748  10.847  1.00  0.00           H 
ATOM    626  HD2 TYR A  40       6.191  -4.064   7.629  1.00  0.00           H 
ATOM    627  HE1 TYR A  40       6.917  -3.311  12.441  1.00  0.00           H 
ATOM    628  HE2 TYR A  40       4.436  -4.607   9.225  1.00  0.00           H 
ATOM    629  HH  TYR A  40       4.164  -5.170  11.535  1.00  0.00           H 
ATOM    630  N   VAL A  41       6.675  -1.257   6.493  1.00  0.00           N 
ATOM    631  CA  VAL A  41       5.313  -0.724   6.293  1.00  0.00           C 
ATOM    632  C   VAL A  41       4.272  -1.847   6.460  1.00  0.00           C 
ATOM    633  O   VAL A  41       4.377  -2.903   5.826  1.00  0.00           O 
ATOM    634  CB  VAL A  41       5.120  -0.056   4.879  1.00  0.00           C 
ATOM    635  CG1 VAL A  41       3.846   0.823   4.856  1.00  0.00           C 
ATOM    636  CG2 VAL A  41       6.357   0.755   4.444  1.00  0.00           C 
ATOM    637  H   VAL A  41       7.014  -1.927   5.867  1.00  0.00           H 
ATOM    638  HA  VAL A  41       5.131   0.038   7.054  1.00  0.00           H 
ATOM    639  HB  VAL A  41       4.980  -0.853   4.149  1.00  0.00           H 
ATOM    640 1HG1 VAL A  41       3.933   1.615   5.590  1.00  0.00           H 
ATOM    641 2HG1 VAL A  41       2.977   0.220   5.090  1.00  0.00           H 
ATOM    642 3HG1 VAL A  41       3.716   1.257   3.870  1.00  0.00           H 
ATOM    643 1HG2 VAL A  41       6.543   1.550   5.155  1.00  0.00           H 
ATOM    644 2HG2 VAL A  41       6.190   1.186   3.464  1.00  0.00           H 
ATOM    645 3HG2 VAL A  41       7.223   0.109   4.403  1.00  0.00           H 
ATOM    646  N   HIS A  42       3.292  -1.607   7.335  1.00  0.00           N 
ATOM    647  CA  HIS A  42       2.101  -2.452   7.494  1.00  0.00           C 
ATOM    648  C   HIS A  42       0.995  -1.928   6.558  1.00  0.00           C 
ATOM    649  O   HIS A  42       0.576  -0.775   6.679  1.00  0.00           O 
ATOM    650  CB  HIS A  42       1.637  -2.417   8.980  1.00  0.00           C 
ATOM    651  CG  HIS A  42       0.253  -2.984   9.237  1.00  0.00           C 
ATOM    652  ND1 HIS A  42      -0.006  -4.326   9.399  1.00  0.00           N 
ATOM    653  CD2 HIS A  42      -0.949  -2.365   9.343  1.00  0.00           C 
ATOM    654  CE1 HIS A  42      -1.297  -4.504   9.582  1.00  0.00           C 
ATOM    655  NE2 HIS A  42      -1.888  -3.333   9.557  1.00  0.00           N 
ATOM    656  H   HIS A  42       3.357  -0.813   7.894  1.00  0.00           H 
ATOM    657  HA  HIS A  42       2.359  -3.477   7.222  1.00  0.00           H 
ATOM    658 2HB  HIS A  42       1.642  -1.390   9.326  1.00  0.00           H 
ATOM    659 1HB  HIS A  42       2.337  -2.985   9.577  1.00  0.00           H 
ATOM    660  HD1 HIS A  42       0.663  -5.041   9.409  1.00  0.00           H 
ATOM    661  HD2 HIS A  42      -1.134  -1.301   9.266  1.00  0.00           H 
ATOM    662  HE1 HIS A  42      -1.786  -5.456   9.732  1.00  0.00           H 
ATOM    663  HE2 HIS A  42      -2.854  -3.204   9.431  1.00  0.00           H 
ATOM    664  N   PHE A  43       0.527  -2.777   5.637  1.00  0.00           N 
ATOM    665  CA  PHE A  43      -0.545  -2.423   4.684  1.00  0.00           C 
ATOM    666  C   PHE A  43      -1.856  -3.149   5.057  1.00  0.00           C 
ATOM    667  O   PHE A  43      -1.820  -4.285   5.548  1.00  0.00           O 
ATOM    668  CB  PHE A  43      -0.139  -2.807   3.240  1.00  0.00           C 
ATOM    669  CG  PHE A  43       1.185  -2.214   2.740  1.00  0.00           C 
ATOM    670  CD1 PHE A  43       1.224  -0.962   2.134  1.00  0.00           C 
ATOM    671  CD2 PHE A  43       2.385  -2.924   2.856  1.00  0.00           C 
ATOM    672  CE1 PHE A  43       2.412  -0.442   1.654  1.00  0.00           C 
ATOM    673  CE2 PHE A  43       3.568  -2.404   2.380  1.00  0.00           C 
ATOM    674  CZ  PHE A  43       3.584  -1.162   1.785  1.00  0.00           C 
ATOM    675  H   PHE A  43       0.906  -3.676   5.583  1.00  0.00           H 
ATOM    676  HA  PHE A  43      -0.707  -1.348   4.725  1.00  0.00           H 
ATOM    677 2HB  PHE A  43      -0.925  -2.484   2.559  1.00  0.00           H 
ATOM    678 1HB  PHE A  43      -0.056  -3.887   3.170  1.00  0.00           H 
ATOM    679  HD1 PHE A  43       0.310  -0.387   2.039  1.00  0.00           H 
ATOM    680  HD2 PHE A  43       2.380  -3.902   3.315  1.00  0.00           H 
ATOM    681  HE1 PHE A  43       2.428   0.532   1.185  1.00  0.00           H 
ATOM    682  HE2 PHE A  43       4.484  -2.969   2.482  1.00  0.00           H 
ATOM    683  HZ  PHE A  43       4.514  -0.756   1.408  1.00  0.00           H 
ATOM    684  N   ASP A  44      -2.997  -2.470   4.833  1.00  0.00           N 
ATOM    685  CA  ASP A  44      -4.359  -3.047   4.955  1.00  0.00           C 
ATOM    686  C   ASP A  44      -5.135  -2.746   3.672  1.00  0.00           C 
ATOM    687  O   ASP A  44      -5.175  -1.593   3.244  1.00  0.00           O 
ATOM    688  CB  ASP A  44      -5.142  -2.432   6.150  1.00  0.00           C 
ATOM    689  CG  ASP A  44      -4.435  -2.600   7.496  1.00  0.00           C 
ATOM    690  OD1 ASP A  44      -4.476  -3.711   8.067  1.00  0.00           O 
ATOM    691  OD2 ASP A  44      -3.835  -1.624   7.994  1.00  0.00           O 
ATOM    692  H   ASP A  44      -2.927  -1.527   4.586  1.00  0.00           H 
ATOM    693  HA  ASP A  44      -4.283  -4.124   5.087  1.00  0.00           H 
ATOM    694 2HB  ASP A  44      -6.122  -2.905   6.218  1.00  0.00           H 
ATOM    695 1HB  ASP A  44      -5.294  -1.372   5.965  1.00  0.00           H 
ATOM    696  N   MET A  45      -5.741  -3.765   3.047  1.00  0.00           N 
ATOM    697  CA  MET A  45      -6.638  -3.568   1.890  1.00  0.00           C 
ATOM    698  C   MET A  45      -8.014  -4.187   2.170  1.00  0.00           C 
ATOM    699  O   MET A  45      -8.100  -5.355   2.536  1.00  0.00           O 
ATOM    700  CB  MET A  45      -6.005  -4.167   0.603  1.00  0.00           C 
ATOM    701  CG  MET A  45      -4.753  -3.414   0.113  1.00  0.00           C 
ATOM    702  SD  MET A  45      -4.014  -4.131  -1.369  1.00  0.00           S 
ATOM    703  CE  MET A  45      -5.384  -4.102  -2.520  1.00  0.00           C 
ATOM    704  H   MET A  45      -5.569  -4.680   3.348  1.00  0.00           H 
ATOM    705  HA  MET A  45      -6.772  -2.500   1.743  1.00  0.00           H 
ATOM    706 2HB  MET A  45      -6.742  -4.148  -0.195  1.00  0.00           H 
ATOM    707 1HB  MET A  45      -5.730  -5.198   0.790  1.00  0.00           H 
ATOM    708 2HG  MET A  45      -4.008  -3.421   0.899  1.00  0.00           H 
ATOM    709 1HG  MET A  45      -5.023  -2.389  -0.106  1.00  0.00           H 
ATOM    710 1HE  MET A  45      -5.707  -3.084  -2.675  1.00  0.00           H 
ATOM    711 2HE  MET A  45      -6.202  -4.688  -2.125  1.00  0.00           H 
ATOM    712 3HE  MET A  45      -5.065  -4.525  -3.464  1.00  0.00           H 
ATOM    713  N   ASP A  46      -9.090  -3.404   1.953  1.00  0.00           N 
ATOM    714  CA  ASP A  46     -10.474  -3.828   2.282  1.00  0.00           C 
ATOM    715  C   ASP A  46     -11.513  -3.099   1.399  1.00  0.00           C 
ATOM    716  O   ASP A  46     -11.311  -1.950   1.014  1.00  0.00           O 
ATOM    717  CB  ASP A  46     -10.780  -3.593   3.790  1.00  0.00           C 
ATOM    718  CG  ASP A  46     -10.745  -2.111   4.211  1.00  0.00           C 
ATOM    719  OD1 ASP A  46     -11.805  -1.546   4.557  1.00  0.00           O 
ATOM    720  OD2 ASP A  46      -9.656  -1.509   4.211  1.00  0.00           O 
ATOM    721  H   ASP A  46      -8.952  -2.513   1.571  1.00  0.00           H 
ATOM    722  HA  ASP A  46     -10.546  -4.898   2.083  1.00  0.00           H 
ATOM    723 2HB  ASP A  46     -10.047  -4.131   4.380  1.00  0.00           H 
ATOM    724 1HB  ASP A  46     -11.762  -4.005   4.020  1.00  0.00           H 
ATOM    725  N   GLY A  47     -12.619  -3.795   1.091  1.00  0.00           N 
ATOM    726  CA  GLY A  47     -13.722  -3.249   0.274  1.00  0.00           C 
ATOM    727  C   GLY A  47     -14.694  -4.355  -0.109  1.00  0.00           C 
ATOM    728  O   GLY A  47     -14.804  -5.329   0.638  1.00  0.00           O 
ATOM    729  H   GLY A  47     -12.691  -4.719   1.419  1.00  0.00           H 
ATOM    730 2HA  GLY A  47     -13.317  -2.800  -0.624  1.00  0.00           H 
ATOM    731 1HA  GLY A  47     -14.251  -2.496   0.842  1.00  0.00           H 
ATOM    732  N   GLU A  48     -15.392  -4.242  -1.265  1.00  0.00           N 
ATOM    733  CA  GLU A  48     -16.205  -5.349  -1.807  1.00  0.00           C 
ATOM    734  C   GLU A  48     -16.282  -5.277  -3.350  1.00  0.00           C 
ATOM    735  O   GLU A  48     -16.906  -4.393  -3.934  1.00  0.00           O 
ATOM    736  CB  GLU A  48     -17.629  -5.382  -1.180  1.00  0.00           C 
ATOM    737  CG  GLU A  48     -18.451  -4.078  -1.306  1.00  0.00           C 
ATOM    738  CD  GLU A  48     -19.870  -4.198  -0.729  1.00  0.00           C 
ATOM    739  OE1 GLU A  48     -20.103  -3.774   0.426  1.00  0.00           O 
ATOM    740  OE2 GLU A  48     -20.767  -4.707  -1.437  1.00  0.00           O 
ATOM    741  H   GLU A  48     -15.343  -3.411  -1.783  1.00  0.00           H 
ATOM    742  HA  GLU A  48     -15.700  -6.277  -1.540  1.00  0.00           H 
ATOM    743 2HB  GLU A  48     -17.534  -5.625  -0.123  1.00  0.00           H 
ATOM    744 1HB  GLU A  48     -18.179  -6.183  -1.660  1.00  0.00           H 
ATOM    745 2HG  GLU A  48     -18.525  -3.815  -2.357  1.00  0.00           H 
ATOM    746 1HG  GLU A  48     -17.923  -3.282  -0.789  1.00  0.00           H 
ATOM    747  N   ILE A  49     -15.591  -6.224  -3.993  1.00  0.00           N 
ATOM    748  CA  ILE A  49     -15.570  -6.320  -5.474  1.00  0.00           C 
ATOM    749  C   ILE A  49     -16.518  -7.408  -5.978  1.00  0.00           C 
ATOM    750  O   ILE A  49     -16.443  -8.551  -5.529  1.00  0.00           O 
ATOM    751  CB  ILE A  49     -14.120  -6.577  -6.000  1.00  0.00           C 
ATOM    752  CG1 ILE A  49     -13.161  -5.456  -5.479  1.00  0.00           C 
ATOM    753  CG2 ILE A  49     -14.096  -6.661  -7.553  1.00  0.00           C 
ATOM    754  CD1 ILE A  49     -11.703  -5.680  -5.795  1.00  0.00           C 
ATOM    755  H   ILE A  49     -14.919  -6.673  -3.456  1.00  0.00           H 
ATOM    756  HA  ILE A  49     -15.899  -5.358  -5.875  1.00  0.00           H 
ATOM    757  HB  ILE A  49     -13.791  -7.539  -5.605  1.00  0.00           H 
ATOM    758 2HG1 ILE A  49     -13.252  -5.384  -4.399  1.00  0.00           H 
ATOM    759 1HG1 ILE A  49     -13.444  -4.507  -5.914  1.00  0.00           H 
ATOM    760 1HG2 ILE A  49     -14.443  -5.727  -7.981  1.00  0.00           H 
ATOM    761 2HG2 ILE A  49     -14.741  -7.463  -7.890  1.00  0.00           H 
ATOM    762 3HG2 ILE A  49     -13.087  -6.857  -7.893  1.00  0.00           H 
ATOM    763 1HD1 ILE A  49     -11.357  -6.578  -5.305  1.00  0.00           H 
ATOM    764 2HD1 ILE A  49     -11.132  -4.838  -5.439  1.00  0.00           H 
ATOM    765 3HD1 ILE A  49     -11.570  -5.777  -6.862  1.00  0.00           H 
ATOM    766  N   ASP A  50     -17.397  -7.008  -6.934  1.00  0.00           N 
ATOM    767  CA  ASP A  50     -18.531  -7.814  -7.434  1.00  0.00           C 
ATOM    768  C   ASP A  50     -19.528  -8.069  -6.270  1.00  0.00           C 
ATOM    769  O   ASP A  50     -20.337  -8.997  -6.290  1.00  0.00           O 
ATOM    770  CB  ASP A  50     -18.011  -9.132  -8.115  1.00  0.00           C 
ATOM    771  CG  ASP A  50     -19.090  -9.936  -8.867  1.00  0.00           C 
ATOM    772  OD1 ASP A  50     -19.443 -11.057  -8.433  1.00  0.00           O 
ATOM    773  OD2 ASP A  50     -19.597  -9.443  -9.897  1.00  0.00           O 
ATOM    774  H   ASP A  50     -17.271  -6.119  -7.317  1.00  0.00           H 
ATOM    775  HA  ASP A  50     -19.041  -7.211  -8.175  1.00  0.00           H 
ATOM    776 2HB  ASP A  50     -17.568  -9.762  -7.349  1.00  0.00           H 
ATOM    777 1HB  ASP A  50     -17.234  -8.873  -8.826  1.00  0.00           H 
ATOM    778  N   GLY A  51     -19.455  -7.185  -5.247  1.00  0.00           N 
ATOM    779  CA  GLY A  51     -20.244  -7.313  -4.024  1.00  0.00           C 
ATOM    780  C   GLY A  51     -19.589  -8.192  -2.966  1.00  0.00           C 
ATOM    781  O   GLY A  51     -20.138  -8.337  -1.869  1.00  0.00           O 
ATOM    782  H   GLY A  51     -18.830  -6.434  -5.322  1.00  0.00           H 
ATOM    783 2HA  GLY A  51     -21.219  -7.726  -4.262  1.00  0.00           H 
ATOM    784 1HA  GLY A  51     -20.384  -6.328  -3.605  1.00  0.00           H 
ATOM    785  N   LYS A  52     -18.422  -8.797  -3.291  1.00  0.00           N 
ATOM    786  CA  LYS A  52     -17.698  -9.716  -2.394  1.00  0.00           C 
ATOM    787  C   LYS A  52     -16.756  -8.966  -1.440  1.00  0.00           C 
ATOM    788  O   LYS A  52     -15.719  -8.451  -1.887  1.00  0.00           O 
ATOM    789  CB  LYS A  52     -16.897 -10.749  -3.231  1.00  0.00           C 
ATOM    790  CG  LYS A  52     -17.778 -11.707  -4.067  1.00  0.00           C 
ATOM    791  CD  LYS A  52     -18.702 -12.570  -3.172  1.00  0.00           C 
ATOM    792  CE  LYS A  52     -19.616 -13.512  -3.970  1.00  0.00           C 
ATOM    793  NZ  LYS A  52     -20.494 -14.303  -3.071  1.00  0.00           N 
ATOM    794  H   LYS A  52     -18.037  -8.656  -4.176  1.00  0.00           H 
ATOM    795  HA  LYS A  52     -18.424 -10.243  -1.814  1.00  0.00           H 
ATOM    796 2HB  LYS A  52     -16.280 -11.346  -2.561  1.00  0.00           H 
ATOM    797 1HB  LYS A  52     -16.239 -10.205  -3.907  1.00  0.00           H 
ATOM    798 2HG  LYS A  52     -17.133 -12.362  -4.643  1.00  0.00           H 
ATOM    799 1HG  LYS A  52     -18.391 -11.121  -4.745  1.00  0.00           H 
ATOM    800 2HD  LYS A  52     -19.322 -11.914  -2.569  1.00  0.00           H 
ATOM    801 1HD  LYS A  52     -18.085 -13.170  -2.511  1.00  0.00           H 
ATOM    802 2HE  LYS A  52     -19.008 -14.192  -4.553  1.00  0.00           H 
ATOM    803 1HE  LYS A  52     -20.240 -12.926  -4.635  1.00  0.00           H 
ATOM    804 1HZ  LYS A  52     -19.920 -14.924  -2.473  1.00  0.00           H 
ATOM    805 2HZ  LYS A  52     -21.150 -14.884  -3.627  1.00  0.00           H 
ATOM    806 3HZ  LYS A  52     -21.046 -13.663  -2.461  1.00  0.00           H 
ATOM    807  N   PRO A  53     -17.078  -8.923  -0.103  1.00  0.00           N 
ATOM    808  CA  PRO A  53     -16.271  -8.193   0.891  1.00  0.00           C 
ATOM    809  C   PRO A  53     -14.951  -8.920   1.207  1.00  0.00           C 
ATOM    810  O   PRO A  53     -14.908 -10.159   1.282  1.00  0.00           O 
ATOM    811  CB  PRO A  53     -17.206  -8.117   2.123  1.00  0.00           C 
ATOM    812  CG  PRO A  53     -18.041  -9.359   2.027  1.00  0.00           C 
ATOM    813  CD  PRO A  53     -18.242  -9.606   0.542  1.00  0.00           C 
ATOM    814  HA  PRO A  53     -16.048  -7.186   0.541  1.00  0.00           H 
ATOM    815 2HB  PRO A  53     -17.820  -7.221   2.063  1.00  0.00           H 
ATOM    816 1HB  PRO A  53     -16.625  -8.090   3.041  1.00  0.00           H 
ATOM    817 2HG  PRO A  53     -18.993  -9.209   2.524  1.00  0.00           H 
ATOM    818 1HG  PRO A  53     -17.514 -10.194   2.483  1.00  0.00           H 
ATOM    819 2HD  PRO A  53     -19.175  -9.168   0.201  1.00  0.00           H 
ATOM    820 1HD  PRO A  53     -18.233 -10.669   0.326  1.00  0.00           H 
ATOM    821  N   PHE A  54     -13.879  -8.138   1.392  1.00  0.00           N 
ATOM    822  CA  PHE A  54     -12.543  -8.666   1.695  1.00  0.00           C 
ATOM    823  C   PHE A  54     -11.845  -7.771   2.719  1.00  0.00           C 
ATOM    824  O   PHE A  54     -12.084  -6.561   2.760  1.00  0.00           O 
ATOM    825  CB  PHE A  54     -11.685  -8.813   0.400  1.00  0.00           C 
ATOM    826  CG  PHE A  54     -11.315  -7.508  -0.332  1.00  0.00           C 
ATOM    827  CD1 PHE A  54     -12.199  -6.909  -1.232  1.00  0.00           C 
ATOM    828  CD2 PHE A  54     -10.070  -6.901  -0.136  1.00  0.00           C 
ATOM    829  CE1 PHE A  54     -11.851  -5.754  -1.906  1.00  0.00           C 
ATOM    830  CE2 PHE A  54      -9.727  -5.746  -0.808  1.00  0.00           C 
ATOM    831  CZ  PHE A  54     -10.617  -5.173  -1.692  1.00  0.00           C 
ATOM    832  H   PHE A  54     -13.993  -7.167   1.344  1.00  0.00           H 
ATOM    833  HA  PHE A  54     -12.667  -9.654   2.141  1.00  0.00           H 
ATOM    834 2HB  PHE A  54     -12.227  -9.442  -0.299  1.00  0.00           H 
ATOM    835 1HB  PHE A  54     -10.761  -9.322   0.653  1.00  0.00           H 
ATOM    836  HD1 PHE A  54     -13.169  -7.361  -1.401  1.00  0.00           H 
ATOM    837  HD2 PHE A  54      -9.365  -7.347   0.558  1.00  0.00           H 
ATOM    838  HE1 PHE A  54     -12.548  -5.305  -2.600  1.00  0.00           H 
ATOM    839  HE2 PHE A  54      -8.760  -5.289  -0.641  1.00  0.00           H 
ATOM    840  HZ  PHE A  54     -10.346  -4.270  -2.221  1.00  0.00           H 
ATOM    841  N   SER A  55     -11.010  -8.393   3.554  1.00  0.00           N 
ATOM    842  CA  SER A  55     -10.126  -7.707   4.494  1.00  0.00           C 
ATOM    843  C   SER A  55      -8.772  -8.430   4.472  1.00  0.00           C 
ATOM    844  O   SER A  55      -8.675  -9.614   4.824  1.00  0.00           O 
ATOM    845  CB  SER A  55     -10.748  -7.685   5.911  1.00  0.00           C 
ATOM    846  OG  SER A  55     -11.035  -8.997   6.384  1.00  0.00           O 
ATOM    847  H   SER A  55     -11.003  -9.371   3.558  1.00  0.00           H 
ATOM    848  HA  SER A  55      -9.985  -6.680   4.149  1.00  0.00           H 
ATOM    849 2HB  SER A  55     -11.671  -7.120   5.888  1.00  0.00           H 
ATOM    850 1HB  SER A  55     -10.062  -7.212   6.596  1.00  0.00           H 
ATOM    851  HG  SER A  55     -10.208  -9.424   6.634  1.00  0.00           H 
ATOM    852  N   ASP A  56      -7.743  -7.706   4.040  1.00  0.00           N 
ATOM    853  CA  ASP A  56      -6.400  -8.241   3.772  1.00  0.00           C 
ATOM    854  C   ASP A  56      -5.363  -7.364   4.484  1.00  0.00           C 
ATOM    855  O   ASP A  56      -5.573  -6.160   4.649  1.00  0.00           O 
ATOM    856  CB  ASP A  56      -6.149  -8.260   2.235  1.00  0.00           C 
ATOM    857  CG  ASP A  56      -4.816  -8.921   1.840  1.00  0.00           C 
ATOM    858  OD1 ASP A  56      -3.799  -8.216   1.677  1.00  0.00           O 
ATOM    859  OD2 ASP A  56      -4.781 -10.163   1.716  1.00  0.00           O 
ATOM    860  H   ASP A  56      -7.886  -6.752   3.904  1.00  0.00           H 
ATOM    861  HA  ASP A  56      -6.340  -9.256   4.163  1.00  0.00           H 
ATOM    862 2HB  ASP A  56      -6.161  -7.241   1.862  1.00  0.00           H 
ATOM    863 1HB  ASP A  56      -6.960  -8.804   1.756  1.00  0.00           H 
ATOM    864  N   SER A  57      -4.265  -7.976   4.937  1.00  0.00           N 
ATOM    865  CA  SER A  57      -3.132  -7.254   5.530  1.00  0.00           C 
ATOM    866  C   SER A  57      -1.823  -7.933   5.100  1.00  0.00           C 
ATOM    867  O   SER A  57      -1.684  -9.155   5.218  1.00  0.00           O 
ATOM    868  CB  SER A  57      -3.252  -7.219   7.075  1.00  0.00           C 
ATOM    869  OG  SER A  57      -4.499  -6.677   7.494  1.00  0.00           O 
ATOM    870  H   SER A  57      -4.217  -8.952   4.883  1.00  0.00           H 
ATOM    871  HA  SER A  57      -3.137  -6.234   5.151  1.00  0.00           H 
ATOM    872 2HB  SER A  57      -2.456  -6.607   7.486  1.00  0.00           H 
ATOM    873 1HB  SER A  57      -3.175  -8.223   7.469  1.00  0.00           H 
ATOM    874  HG  SER A  57      -4.576  -5.766   7.178  1.00  0.00           H 
ATOM    875  N   PHE A  58      -0.878  -7.134   4.591  1.00  0.00           N 
ATOM    876  CA  PHE A  58       0.451  -7.607   4.164  1.00  0.00           C 
ATOM    877  C   PHE A  58       1.506  -6.595   4.608  1.00  0.00           C 
ATOM    878  O   PHE A  58       1.246  -5.398   4.618  1.00  0.00           O 
ATOM    879  CB  PHE A  58       0.497  -7.850   2.628  1.00  0.00           C 
ATOM    880  CG  PHE A  58       0.152  -6.642   1.736  1.00  0.00           C 
ATOM    881  CD1 PHE A  58       1.153  -5.895   1.109  1.00  0.00           C 
ATOM    882  CD2 PHE A  58      -1.174  -6.277   1.507  1.00  0.00           C 
ATOM    883  CE1 PHE A  58       0.837  -4.837   0.281  1.00  0.00           C 
ATOM    884  CE2 PHE A  58      -1.488  -5.215   0.686  1.00  0.00           C 
ATOM    885  CZ  PHE A  58      -0.484  -4.495   0.071  1.00  0.00           C 
ATOM    886  H   PHE A  58      -1.077  -6.175   4.508  1.00  0.00           H 
ATOM    887  HA  PHE A  58       0.656  -8.551   4.673  1.00  0.00           H 
ATOM    888 2HB  PHE A  58      -0.201  -8.649   2.387  1.00  0.00           H 
ATOM    889 1HB  PHE A  58       1.492  -8.192   2.359  1.00  0.00           H 
ATOM    890  HD1 PHE A  58       2.193  -6.157   1.270  1.00  0.00           H 
ATOM    891  HD2 PHE A  58      -1.968  -6.837   1.988  1.00  0.00           H 
ATOM    892  HE1 PHE A  58       1.627  -4.266  -0.188  1.00  0.00           H 
ATOM    893  HE2 PHE A  58      -2.522  -4.948   0.521  1.00  0.00           H 
ATOM    894  HZ  PHE A  58      -0.732  -3.665  -0.577  1.00  0.00           H 
ATOM    895  N   GLU A  59       2.684  -7.086   5.010  1.00  0.00           N 
ATOM    896  CA  GLU A  59       3.763  -6.250   5.570  1.00  0.00           C 
ATOM    897  C   GLU A  59       5.064  -6.484   4.803  1.00  0.00           C 
ATOM    898  O   GLU A  59       5.443  -7.630   4.539  1.00  0.00           O 
ATOM    899  CB  GLU A  59       3.950  -6.556   7.078  1.00  0.00           C 
ATOM    900  CG  GLU A  59       2.683  -6.318   7.924  1.00  0.00           C 
ATOM    901  CD  GLU A  59       2.854  -6.655   9.415  1.00  0.00           C 
ATOM    902  OE1 GLU A  59       3.364  -7.745   9.738  1.00  0.00           O 
ATOM    903  OE2 GLU A  59       2.457  -5.842  10.271  1.00  0.00           O 
ATOM    904  H   GLU A  59       2.842  -8.049   4.916  1.00  0.00           H 
ATOM    905  HA  GLU A  59       3.479  -5.203   5.461  1.00  0.00           H 
ATOM    906 2HB  GLU A  59       4.743  -5.927   7.472  1.00  0.00           H 
ATOM    907 1HB  GLU A  59       4.245  -7.597   7.196  1.00  0.00           H 
ATOM    908 2HG  GLU A  59       1.889  -6.925   7.523  1.00  0.00           H 
ATOM    909 1HG  GLU A  59       2.397  -5.274   7.823  1.00  0.00           H 
ATOM    910  N   LEU A  60       5.734  -5.386   4.449  1.00  0.00           N 
ATOM    911  CA  LEU A  60       6.993  -5.396   3.690  1.00  0.00           C 
ATOM    912  C   LEU A  60       8.065  -4.632   4.479  1.00  0.00           C 
ATOM    913  O   LEU A  60       7.801  -3.504   4.905  1.00  0.00           O 
ATOM    914  CB  LEU A  60       6.767  -4.752   2.297  1.00  0.00           C 
ATOM    915  CG  LEU A  60       5.928  -5.606   1.289  1.00  0.00           C 
ATOM    916  CD1 LEU A  60       5.480  -4.774   0.071  1.00  0.00           C 
ATOM    917  CD2 LEU A  60       6.721  -6.865   0.849  1.00  0.00           C 
ATOM    918  H   LEU A  60       5.371  -4.515   4.727  1.00  0.00           H 
ATOM    919  HA  LEU A  60       7.314  -6.425   3.555  1.00  0.00           H 
ATOM    920 2HB  LEU A  60       7.736  -4.555   1.843  1.00  0.00           H 
ATOM    921 1HB  LEU A  60       6.266  -3.799   2.442  1.00  0.00           H 
ATOM    922  HG  LEU A  60       5.028  -5.947   1.790  1.00  0.00           H 
ATOM    923 1HD1 LEU A  60       6.345  -4.370  -0.440  1.00  0.00           H 
ATOM    924 2HD1 LEU A  60       4.846  -3.958   0.400  1.00  0.00           H 
ATOM    925 3HD1 LEU A  60       4.919  -5.400  -0.612  1.00  0.00           H 
ATOM    926 1HD2 LEU A  60       6.968  -7.466   1.715  1.00  0.00           H 
ATOM    927 2HD2 LEU A  60       7.633  -6.572   0.344  1.00  0.00           H 
ATOM    928 3HD2 LEU A  60       6.114  -7.456   0.174  1.00  0.00           H 
ATOM    929  N   PRO A  61       9.283  -5.234   4.700  1.00  0.00           N 
ATOM    930  CA  PRO A  61      10.419  -4.533   5.347  1.00  0.00           C 
ATOM    931  C   PRO A  61      10.906  -3.349   4.498  1.00  0.00           C 
ATOM    932  O   PRO A  61      10.579  -3.277   3.318  1.00  0.00           O 
ATOM    933  CB  PRO A  61      11.498  -5.639   5.481  1.00  0.00           C 
ATOM    934  CG  PRO A  61      11.162  -6.628   4.410  1.00  0.00           C 
ATOM    935  CD  PRO A  61       9.650  -6.630   4.333  1.00  0.00           C 
ATOM    936  HA  PRO A  61      10.145  -4.169   6.326  1.00  0.00           H 
ATOM    937 2HB  PRO A  61      11.429  -6.090   6.466  1.00  0.00           H 
ATOM    938 1HB  PRO A  61      12.493  -5.228   5.348  1.00  0.00           H 
ATOM    939 2HG  PRO A  61      11.533  -7.611   4.678  1.00  0.00           H 
ATOM    940 1HG  PRO A  61      11.594  -6.314   3.460  1.00  0.00           H 
ATOM    941 2HD  PRO A  61       9.229  -7.336   5.042  1.00  0.00           H 
ATOM    942 1HD  PRO A  61       9.321  -6.870   3.327  1.00  0.00           H 
ATOM    943  N   ARG A  62      11.653  -2.422   5.123  1.00  0.00           N 
ATOM    944  CA  ARG A  62      12.271  -1.254   4.439  1.00  0.00           C 
ATOM    945  C   ARG A  62      12.963  -1.628   3.088  1.00  0.00           C 
ATOM    946  O   ARG A  62      12.952  -0.840   2.133  1.00  0.00           O 
ATOM    947  CB  ARG A  62      13.292  -0.566   5.391  1.00  0.00           C 
ATOM    948  CG  ARG A  62      14.632  -1.326   5.562  1.00  0.00           C 
ATOM    949  CD  ARG A  62      15.616  -0.656   6.537  1.00  0.00           C 
ATOM    950  NE  ARG A  62      16.993  -1.161   6.352  1.00  0.00           N 
ATOM    951  CZ  ARG A  62      17.438  -2.395   6.676  1.00  0.00           C 
ATOM    952  NH1 ARG A  62      16.658  -3.281   7.289  1.00  0.00           N 
ATOM    953  NH2 ARG A  62      18.687  -2.727   6.402  1.00  0.00           N 
ATOM    954  H   ARG A  62      11.711  -2.470   6.099  1.00  0.00           H 
ATOM    955  HA  ARG A  62      11.467  -0.556   4.227  1.00  0.00           H 
ATOM    956 2HB  ARG A  62      12.835  -0.466   6.370  1.00  0.00           H 
ATOM    957 1HB  ARG A  62      13.507   0.428   5.015  1.00  0.00           H 
ATOM    958 2HG  ARG A  62      15.107  -1.402   4.588  1.00  0.00           H 
ATOM    959 1HG  ARG A  62      14.420  -2.327   5.924  1.00  0.00           H 
ATOM    960 2HD  ARG A  62      15.301  -0.847   7.558  1.00  0.00           H 
ATOM    961 1HD  ARG A  62      15.617   0.414   6.361  1.00  0.00           H 
ATOM    962  HE  ARG A  62      17.628  -0.538   5.934  1.00  0.00           H 
ATOM    963 1HH1 ARG A  62      15.710  -3.048   7.528  1.00  0.00           H 
ATOM    964 2HH1 ARG A  62      17.013  -4.192   7.519  1.00  0.00           H 
ATOM    965 1HH2 ARG A  62      19.298  -2.070   5.954  1.00  0.00           H 
ATOM    966 2HH2 ARG A  62      19.029  -3.640   6.645  1.00  0.00           H 
ATOM    967  N   ASP A  63      13.509  -2.863   3.034  1.00  0.00           N 
ATOM    968  CA  ASP A  63      14.270  -3.396   1.889  1.00  0.00           C 
ATOM    969  C   ASP A  63      13.370  -3.680   0.662  1.00  0.00           C 
ATOM    970  O   ASP A  63      13.822  -3.557  -0.479  1.00  0.00           O 
ATOM    971  CB  ASP A  63      15.014  -4.687   2.337  1.00  0.00           C 
ATOM    972  CG  ASP A  63      15.954  -5.276   1.264  1.00  0.00           C 
ATOM    973  OD1 ASP A  63      17.051  -4.718   1.056  1.00  0.00           O 
ATOM    974  OD2 ASP A  63      15.602  -6.289   0.624  1.00  0.00           O 
ATOM    975  H   ASP A  63      13.394  -3.443   3.813  1.00  0.00           H 
ATOM    976  HA  ASP A  63      15.009  -2.648   1.614  1.00  0.00           H 
ATOM    977 2HB  ASP A  63      14.279  -5.438   2.613  1.00  0.00           H 
ATOM    978 1HB  ASP A  63      15.608  -4.456   3.214  1.00  0.00           H 
ATOM    979  N   THR A  64      12.090  -4.015   0.902  1.00  0.00           N 
ATOM    980  CA  THR A  64      11.126  -4.404  -0.155  1.00  0.00           C 
ATOM    981  C   THR A  64       9.813  -3.608  -0.002  1.00  0.00           C 
ATOM    982  O   THR A  64       8.790  -3.966  -0.596  1.00  0.00           O 
ATOM    983  CB  THR A  64      10.831  -5.948  -0.127  1.00  0.00           C 
ATOM    984  OG1 THR A  64      10.411  -6.339   1.185  1.00  0.00           O 
ATOM    985  CG2 THR A  64      12.059  -6.778  -0.549  1.00  0.00           C 
ATOM    986  H   THR A  64      11.743  -3.920   1.810  1.00  0.00           H 
ATOM    987  HA  THR A  64      11.550  -4.152  -1.125  1.00  0.00           H 
ATOM    988  HB  THR A  64      10.022  -6.158  -0.820  1.00  0.00           H 
ATOM    989  HG1 THR A  64      10.391  -7.298   1.240  1.00  0.00           H 
ATOM    990 1HG2 THR A  64      11.811  -7.830  -0.527  1.00  0.00           H 
ATOM    991 2HG2 THR A  64      12.881  -6.591   0.134  1.00  0.00           H 
ATOM    992 3HG2 THR A  64      12.360  -6.504  -1.552  1.00  0.00           H 
ATOM    993  N   ALA A  65       9.865  -2.507   0.782  1.00  0.00           N 
ATOM    994  CA  ALA A  65       8.704  -1.623   1.020  1.00  0.00           C 
ATOM    995  C   ALA A  65       8.240  -0.960  -0.283  1.00  0.00           C 
ATOM    996  O   ALA A  65       7.048  -0.895  -0.557  1.00  0.00           O 
ATOM    997  CB  ALA A  65       9.049  -0.561   2.074  1.00  0.00           C 
ATOM    998  H   ALA A  65      10.710  -2.304   1.237  1.00  0.00           H 
ATOM    999  HA  ALA A  65       7.897  -2.234   1.412  1.00  0.00           H 
ATOM   1000 1HB  ALA A  65       8.179   0.051   2.277  1.00  0.00           H 
ATOM   1001 2HB  ALA A  65       9.852   0.069   1.716  1.00  0.00           H 
ATOM   1002 3HB  ALA A  65       9.363  -1.049   2.989  1.00  0.00           H 
ATOM   1003  N   PHE A  66       9.221  -0.494  -1.073  1.00  0.00           N 
ATOM   1004  CA  PHE A  66       9.001   0.180  -2.378  1.00  0.00           C 
ATOM   1005  C   PHE A  66       8.574  -0.807  -3.492  1.00  0.00           C 
ATOM   1006  O   PHE A  66       8.283  -0.394  -4.616  1.00  0.00           O 
ATOM   1007  CB  PHE A  66      10.281   0.951  -2.784  1.00  0.00           C 
ATOM   1008  CG  PHE A  66      10.816   1.835  -1.659  1.00  0.00           C 
ATOM   1009  CD1 PHE A  66      11.880   1.414  -0.857  1.00  0.00           C 
ATOM   1010  CD2 PHE A  66      10.223   3.062  -1.377  1.00  0.00           C 
ATOM   1011  CE1 PHE A  66      12.335   2.195   0.184  1.00  0.00           C 
ATOM   1012  CE2 PHE A  66      10.681   3.840  -0.343  1.00  0.00           C 
ATOM   1013  CZ  PHE A  66      11.738   3.406   0.441  1.00  0.00           C 
ATOM   1014  H   PHE A  66      10.131  -0.547  -0.723  1.00  0.00           H 
ATOM   1015  HA  PHE A  66       8.196   0.899  -2.243  1.00  0.00           H 
ATOM   1016 2HB  PHE A  66      10.066   1.586  -3.641  1.00  0.00           H 
ATOM   1017 1HB  PHE A  66      11.057   0.243  -3.069  1.00  0.00           H 
ATOM   1018  HD1 PHE A  66      12.355   0.460  -1.062  1.00  0.00           H 
ATOM   1019  HD2 PHE A  66       9.398   3.409  -1.985  1.00  0.00           H 
ATOM   1020  HE1 PHE A  66      13.161   1.857   0.797  1.00  0.00           H 
ATOM   1021  HE2 PHE A  66      10.216   4.797  -0.137  1.00  0.00           H 
ATOM   1022  HZ  PHE A  66      12.092   4.022   1.258  1.00  0.00           H 
ATOM   1023  N   ASN A  67       8.513  -2.106  -3.156  1.00  0.00           N 
ATOM   1024  CA  ASN A  67       7.995  -3.162  -4.053  1.00  0.00           C 
ATOM   1025  C   ASN A  67       6.468  -3.320  -3.874  1.00  0.00           C 
ATOM   1026  O   ASN A  67       5.854  -4.195  -4.503  1.00  0.00           O 
ATOM   1027  CB  ASN A  67       8.720  -4.508  -3.756  1.00  0.00           C 
ATOM   1028  CG  ASN A  67      10.211  -4.571  -4.147  1.00  0.00           C 
ATOM   1029  OD1 ASN A  67      10.731  -5.648  -4.436  1.00  0.00           O 
ATOM   1030  ND2 ASN A  67      10.922  -3.449  -4.168  1.00  0.00           N 
ATOM   1031  H   ASN A  67       8.812  -2.367  -2.264  1.00  0.00           H 
ATOM   1032  HA  ASN A  67       8.190  -2.868  -5.078  1.00  0.00           H 
ATOM   1033 2HB  ASN A  67       8.202  -5.306  -4.281  1.00  0.00           H 
ATOM   1034 1HB  ASN A  67       8.657  -4.708  -2.694  1.00  0.00           H 
ATOM   1035 2HD2 ASN A  67      10.482  -2.607  -3.940  1.00  0.00           H 
ATOM   1036 1HD2 ASN A  67      11.872  -3.511  -4.405  1.00  0.00           H 
ATOM   1037  N   PHE A  68       5.888  -2.465  -2.994  1.00  0.00           N 
ATOM   1038  CA  PHE A  68       4.460  -2.478  -2.648  1.00  0.00           C 
ATOM   1039  C   PHE A  68       3.555  -2.379  -3.883  1.00  0.00           C 
ATOM   1040  O   PHE A  68       2.650  -3.178  -4.018  1.00  0.00           O 
ATOM   1041  CB  PHE A  68       4.117  -1.352  -1.629  1.00  0.00           C 
ATOM   1042  CG  PHE A  68       4.151   0.080  -2.197  1.00  0.00           C 
ATOM   1043  CD1 PHE A  68       5.359   0.693  -2.541  1.00  0.00           C 
ATOM   1044  CD2 PHE A  68       2.977   0.791  -2.415  1.00  0.00           C 
ATOM   1045  CE1 PHE A  68       5.393   1.956  -3.083  1.00  0.00           C 
ATOM   1046  CE2 PHE A  68       3.011   2.057  -2.954  1.00  0.00           C 
ATOM   1047  CZ  PHE A  68       4.217   2.642  -3.290  1.00  0.00           C 
ATOM   1048  H   PHE A  68       6.476  -1.848  -2.515  1.00  0.00           H 
ATOM   1049  HA  PHE A  68       4.273  -3.435  -2.162  1.00  0.00           H 
ATOM   1050 2HB  PHE A  68       4.820  -1.402  -0.807  1.00  0.00           H 
ATOM   1051 1HB  PHE A  68       3.124  -1.537  -1.229  1.00  0.00           H 
ATOM   1052  HD1 PHE A  68       6.281   0.154  -2.377  1.00  0.00           H 
ATOM   1053  HD2 PHE A  68       2.023   0.342  -2.156  1.00  0.00           H 
ATOM   1054  HE1 PHE A  68       6.341   2.412  -3.342  1.00  0.00           H 
ATOM   1055  HE2 PHE A  68       2.090   2.593  -3.116  1.00  0.00           H 
ATOM   1056  HZ  PHE A  68       4.238   3.638  -3.714  1.00  0.00           H 
ATOM   1057  N   ALA A  69       3.812  -1.395  -4.779  1.00  0.00           N 
ATOM   1058  CA  ALA A  69       2.968  -1.129  -5.968  1.00  0.00           C 
ATOM   1059  C   ALA A  69       2.750  -2.362  -6.864  1.00  0.00           C 
ATOM   1060  O   ALA A  69       1.723  -2.452  -7.540  1.00  0.00           O 
ATOM   1061  CB  ALA A  69       3.541   0.035  -6.782  1.00  0.00           C 
ATOM   1062  H   ALA A  69       4.534  -0.753  -4.600  1.00  0.00           H 
ATOM   1063  HA  ALA A  69       1.995  -0.814  -5.591  1.00  0.00           H 
ATOM   1064 1HB  ALA A  69       2.866   0.291  -7.588  1.00  0.00           H 
ATOM   1065 2HB  ALA A  69       4.501  -0.244  -7.192  1.00  0.00           H 
ATOM   1066 3HB  ALA A  69       3.669   0.898  -6.138  1.00  0.00           H 
ATOM   1067  N   SER A  70       3.719  -3.295  -6.867  1.00  0.00           N 
ATOM   1068  CA  SER A  70       3.591  -4.571  -7.581  1.00  0.00           C 
ATOM   1069  C   SER A  70       2.582  -5.487  -6.856  1.00  0.00           C 
ATOM   1070  O   SER A  70       1.629  -5.966  -7.467  1.00  0.00           O 
ATOM   1071  CB  SER A  70       4.982  -5.244  -7.682  1.00  0.00           C 
ATOM   1072  OG  SER A  70       5.938  -4.362  -8.264  1.00  0.00           O 
ATOM   1073  H   SER A  70       4.539  -3.131  -6.357  1.00  0.00           H 
ATOM   1074  HA  SER A  70       3.231  -4.362  -8.588  1.00  0.00           H 
ATOM   1075 2HB  SER A  70       4.914  -6.133  -8.297  1.00  0.00           H 
ATOM   1076 1HB  SER A  70       5.327  -5.519  -6.692  1.00  0.00           H 
ATOM   1077  HG  SER A  70       5.510  -3.523  -8.482  1.00  0.00           H 
ATOM   1078  N   ASP A  71       2.790  -5.676  -5.533  1.00  0.00           N 
ATOM   1079  CA  ASP A  71       1.988  -6.621  -4.716  1.00  0.00           C 
ATOM   1080  C   ASP A  71       0.567  -6.097  -4.432  1.00  0.00           C 
ATOM   1081  O   ASP A  71      -0.396  -6.816  -4.628  1.00  0.00           O 
ATOM   1082  CB  ASP A  71       2.705  -6.946  -3.384  1.00  0.00           C 
ATOM   1083  CG  ASP A  71       1.993  -8.057  -2.582  1.00  0.00           C 
ATOM   1084  OD1 ASP A  71       1.260  -7.755  -1.614  1.00  0.00           O 
ATOM   1085  OD2 ASP A  71       2.157  -9.243  -2.934  1.00  0.00           O 
ATOM   1086  H   ASP A  71       3.516  -5.175  -5.094  1.00  0.00           H 
ATOM   1087  HA  ASP A  71       1.904  -7.537  -5.293  1.00  0.00           H 
ATOM   1088 2HB  ASP A  71       2.758  -6.045  -2.779  1.00  0.00           H 
ATOM   1089 1HB  ASP A  71       3.718  -7.271  -3.602  1.00  0.00           H 
ATOM   1090  N   ALA A  72       0.477  -4.860  -3.910  1.00  0.00           N 
ATOM   1091  CA  ALA A  72      -0.798  -4.140  -3.659  1.00  0.00           C 
ATOM   1092  C   ALA A  72      -1.756  -4.176  -4.870  1.00  0.00           C 
ATOM   1093  O   ALA A  72      -2.974  -4.266  -4.708  1.00  0.00           O 
ATOM   1094  CB  ALA A  72      -0.501  -2.686  -3.254  1.00  0.00           C 
ATOM   1095  H   ALA A  72       1.301  -4.443  -3.622  1.00  0.00           H 
ATOM   1096  HA  ALA A  72      -1.282  -4.625  -2.815  1.00  0.00           H 
ATOM   1097 1HB  ALA A  72      -0.029  -2.167  -4.079  1.00  0.00           H 
ATOM   1098 2HB  ALA A  72       0.170  -2.678  -2.402  1.00  0.00           H 
ATOM   1099 3HB  ALA A  72      -1.419  -2.180  -2.988  1.00  0.00           H 
ATOM   1100  N   THR A  73      -1.182  -4.106  -6.079  1.00  0.00           N 
ATOM   1101  CA  THR A  73      -1.939  -4.250  -7.332  1.00  0.00           C 
ATOM   1102  C   THR A  73      -2.302  -5.733  -7.594  1.00  0.00           C 
ATOM   1103  O   THR A  73      -3.441  -6.040  -7.949  1.00  0.00           O 
ATOM   1104  CB  THR A  73      -1.141  -3.667  -8.538  1.00  0.00           C 
ATOM   1105  OG1 THR A  73      -0.950  -2.253  -8.349  1.00  0.00           O 
ATOM   1106  CG2 THR A  73      -1.846  -3.916  -9.880  1.00  0.00           C 
ATOM   1107  H   THR A  73      -0.217  -3.955  -6.116  1.00  0.00           H 
ATOM   1108  HA  THR A  73      -2.862  -3.679  -7.229  1.00  0.00           H 
ATOM   1109  HB  THR A  73      -0.162  -4.143  -8.567  1.00  0.00           H 
ATOM   1110  HG1 THR A  73      -0.325  -2.116  -7.632  1.00  0.00           H 
ATOM   1111 1HG2 THR A  73      -2.838  -3.479  -9.862  1.00  0.00           H 
ATOM   1112 2HG2 THR A  73      -1.929  -4.981 -10.062  1.00  0.00           H 
ATOM   1113 3HG2 THR A  73      -1.277  -3.464 -10.679  1.00  0.00           H 
ATOM   1114  N   ARG A  74      -1.316  -6.626  -7.391  1.00  0.00           N 
ATOM   1115  CA  ARG A  74      -1.441  -8.090  -7.607  1.00  0.00           C 
ATOM   1116  C   ARG A  74      -2.608  -8.699  -6.792  1.00  0.00           C 
ATOM   1117  O   ARG A  74      -3.410  -9.475  -7.319  1.00  0.00           O 
ATOM   1118  CB  ARG A  74      -0.091  -8.770  -7.248  1.00  0.00           C 
ATOM   1119  CG  ARG A  74      -0.047 -10.304  -7.400  1.00  0.00           C 
ATOM   1120  CD  ARG A  74       1.334 -10.879  -7.031  1.00  0.00           C 
ATOM   1121  NE  ARG A  74       1.378 -12.353  -7.150  1.00  0.00           N 
ATOM   1122  CZ  ARG A  74       2.390 -13.063  -7.676  1.00  0.00           C 
ATOM   1123  NH1 ARG A  74       3.445 -12.456  -8.206  1.00  0.00           N 
ATOM   1124  NH2 ARG A  74       2.331 -14.384  -7.672  1.00  0.00           N 
ATOM   1125  H   ARG A  74      -0.452  -6.280  -7.089  1.00  0.00           H 
ATOM   1126  HA  ARG A  74      -1.637  -8.245  -8.663  1.00  0.00           H 
ATOM   1127 2HB  ARG A  74       0.154  -8.524  -6.217  1.00  0.00           H 
ATOM   1128 1HB  ARG A  74       0.680  -8.350  -7.884  1.00  0.00           H 
ATOM   1129 2HG  ARG A  74      -0.277 -10.564  -8.428  1.00  0.00           H 
ATOM   1130 1HG  ARG A  74      -0.793 -10.745  -6.746  1.00  0.00           H 
ATOM   1131 2HD  ARG A  74       1.564 -10.611  -6.006  1.00  0.00           H 
ATOM   1132 1HD  ARG A  74       2.079 -10.441  -7.686  1.00  0.00           H 
ATOM   1133  HE  ARG A  74       0.607 -12.843  -6.783  1.00  0.00           H 
ATOM   1134 1HH1 ARG A  74       3.497 -11.456  -8.217  1.00  0.00           H 
ATOM   1135 2HH1 ARG A  74       4.199 -12.995  -8.593  1.00  0.00           H 
ATOM   1136 1HH2 ARG A  74       1.536 -14.855  -7.274  1.00  0.00           H 
ATOM   1137 2HH2 ARG A  74       3.080 -14.921  -8.064  1.00  0.00           H 
ATOM   1138  N   VAL A  75      -2.703  -8.307  -5.518  1.00  0.00           N 
ATOM   1139  CA  VAL A  75      -3.766  -8.751  -4.603  1.00  0.00           C 
ATOM   1140  C   VAL A  75      -5.114  -8.080  -4.955  1.00  0.00           C 
ATOM   1141  O   VAL A  75      -6.171  -8.698  -4.806  1.00  0.00           O 
ATOM   1142  CB  VAL A  75      -3.361  -8.516  -3.094  1.00  0.00           C 
ATOM   1143  CG1 VAL A  75      -3.126  -7.030  -2.774  1.00  0.00           C 
ATOM   1144  CG2 VAL A  75      -4.377  -9.140  -2.108  1.00  0.00           C 
ATOM   1145  H   VAL A  75      -2.036  -7.687  -5.180  1.00  0.00           H 
ATOM   1146  HA  VAL A  75      -3.882  -9.821  -4.750  1.00  0.00           H 
ATOM   1147  HB  VAL A  75      -2.410  -9.027  -2.942  1.00  0.00           H 
ATOM   1148 1HG1 VAL A  75      -4.042  -6.472  -2.932  1.00  0.00           H 
ATOM   1149 2HG1 VAL A  75      -2.354  -6.633  -3.419  1.00  0.00           H 
ATOM   1150 3HG1 VAL A  75      -2.816  -6.920  -1.741  1.00  0.00           H 
ATOM   1151 1HG2 VAL A  75      -4.472 -10.201  -2.297  1.00  0.00           H 
ATOM   1152 2HG2 VAL A  75      -5.345  -8.669  -2.230  1.00  0.00           H 
ATOM   1153 3HG2 VAL A  75      -4.037  -8.991  -1.089  1.00  0.00           H 
ATOM   1154  N   ALA A  76      -5.063  -6.833  -5.477  1.00  0.00           N 
ATOM   1155  CA  ALA A  76      -6.268  -6.064  -5.850  1.00  0.00           C 
ATOM   1156  C   ALA A  76      -6.974  -6.713  -7.054  1.00  0.00           C 
ATOM   1157  O   ALA A  76      -8.201  -6.859  -7.069  1.00  0.00           O 
ATOM   1158  CB  ALA A  76      -5.889  -4.613  -6.184  1.00  0.00           C 
ATOM   1159  H   ALA A  76      -4.191  -6.435  -5.679  1.00  0.00           H 
ATOM   1160  HA  ALA A  76      -6.941  -6.053  -4.995  1.00  0.00           H 
ATOM   1161 1HB  ALA A  76      -5.212  -4.599  -7.029  1.00  0.00           H 
ATOM   1162 2HB  ALA A  76      -5.399  -4.157  -5.331  1.00  0.00           H 
ATOM   1163 3HB  ALA A  76      -6.776  -4.046  -6.429  1.00  0.00           H 
ATOM   1164  N   GLN A  77      -6.162  -7.125  -8.042  1.00  0.00           N 
ATOM   1165  CA  GLN A  77      -6.653  -7.753  -9.279  1.00  0.00           C 
ATOM   1166  C   GLN A  77      -7.008  -9.228  -9.051  1.00  0.00           C 
ATOM   1167  O   GLN A  77      -7.849  -9.785  -9.772  1.00  0.00           O 
ATOM   1168  CB  GLN A  77      -5.651  -7.583 -10.449  1.00  0.00           C 
ATOM   1169  CG  GLN A  77      -4.273  -8.216 -10.229  1.00  0.00           C 
ATOM   1170  CD  GLN A  77      -3.381  -8.128 -11.464  1.00  0.00           C 
ATOM   1171  OE1 GLN A  77      -2.637  -7.160 -11.649  1.00  0.00           O 
ATOM   1172  NE2 GLN A  77      -3.459  -9.133 -12.325  1.00  0.00           N 
ATOM   1173  H   GLN A  77      -5.199  -7.018  -7.910  1.00  0.00           H 
ATOM   1174  HA  GLN A  77      -7.571  -7.239  -9.551  1.00  0.00           H 
ATOM   1175 2HB  GLN A  77      -5.512  -6.520 -10.629  1.00  0.00           H 
ATOM   1176 1HB  GLN A  77      -6.092  -8.021 -11.342  1.00  0.00           H 
ATOM   1177 2HG  GLN A  77      -4.402  -9.260  -9.959  1.00  0.00           H 
ATOM   1178 1HG  GLN A  77      -3.785  -7.701  -9.411  1.00  0.00           H 
ATOM   1179 2HE2 GLN A  77      -4.075  -9.868 -12.125  1.00  0.00           H 
ATOM   1180 1HE2 GLN A  77      -2.893  -9.102 -13.125  1.00  0.00           H 
ATOM   1181  N   LYS A  78      -6.365  -9.857  -8.043  1.00  0.00           N 
ATOM   1182  CA  LYS A  78      -6.742 -11.199  -7.557  1.00  0.00           C 
ATOM   1183  C   LYS A  78      -8.146 -11.164  -6.911  1.00  0.00           C 
ATOM   1184  O   LYS A  78      -8.851 -12.172  -6.875  1.00  0.00           O 
ATOM   1185  CB  LYS A  78      -5.672 -11.721  -6.555  1.00  0.00           C 
ATOM   1186  CG  LYS A  78      -5.885 -13.175  -6.073  1.00  0.00           C 
ATOM   1187  CD  LYS A  78      -4.740 -13.696  -5.165  1.00  0.00           C 
ATOM   1188  CE  LYS A  78      -3.396 -13.835  -5.900  1.00  0.00           C 
ATOM   1189  NZ  LYS A  78      -3.464 -14.823  -7.012  1.00  0.00           N 
ATOM   1190  H   LYS A  78      -5.596  -9.418  -7.625  1.00  0.00           H 
ATOM   1191  HA  LYS A  78      -6.772 -11.864  -8.415  1.00  0.00           H 
ATOM   1192 2HB  LYS A  78      -5.661 -11.072  -5.684  1.00  0.00           H 
ATOM   1193 1HB  LYS A  78      -4.697 -11.663  -7.032  1.00  0.00           H 
ATOM   1194 2HG  LYS A  78      -5.969 -13.824  -6.942  1.00  0.00           H 
ATOM   1195 1HG  LYS A  78      -6.818 -13.221  -5.517  1.00  0.00           H 
ATOM   1196 2HD  LYS A  78      -5.024 -14.669  -4.772  1.00  0.00           H 
ATOM   1197 1HD  LYS A  78      -4.613 -13.012  -4.333  1.00  0.00           H 
ATOM   1198 2HE  LYS A  78      -2.642 -14.163  -5.192  1.00  0.00           H 
ATOM   1199 1HE  LYS A  78      -3.108 -12.875  -6.304  1.00  0.00           H 
ATOM   1200 1HZ  LYS A  78      -3.722 -15.764  -6.642  1.00  0.00           H 
ATOM   1201 2HZ  LYS A  78      -2.544 -14.895  -7.484  1.00  0.00           H 
ATOM   1202 3HZ  LYS A  78      -4.176 -14.531  -7.713  1.00  0.00           H 
ATOM   1203  N   HIS A  79      -8.544  -9.970  -6.421  1.00  0.00           N 
ATOM   1204  CA  HIS A  79      -9.883  -9.736  -5.844  1.00  0.00           C 
ATOM   1205  C   HIS A  79     -10.934  -9.356  -6.915  1.00  0.00           C 
ATOM   1206  O   HIS A  79     -12.097  -9.150  -6.561  1.00  0.00           O 
ATOM   1207  CB  HIS A  79      -9.823  -8.651  -4.730  1.00  0.00           C 
ATOM   1208  CG  HIS A  79      -9.238  -9.128  -3.423  1.00  0.00           C 
ATOM   1209  ND1 HIS A  79      -8.108  -8.588  -2.846  1.00  0.00           N 
ATOM   1210  CD2 HIS A  79      -9.665 -10.085  -2.565  1.00  0.00           C 
ATOM   1211  CE1 HIS A  79      -7.871  -9.190  -1.700  1.00  0.00           C 
ATOM   1212  NE2 HIS A  79      -8.796 -10.102  -1.503  1.00  0.00           N 
ATOM   1213  H   HIS A  79      -7.908  -9.223  -6.448  1.00  0.00           H 
ATOM   1214  HA  HIS A  79     -10.212 -10.670  -5.391  1.00  0.00           H 
ATOM   1215 2HB  HIS A  79     -10.824  -8.290  -4.525  1.00  0.00           H 
ATOM   1216 1HB  HIS A  79      -9.223  -7.820  -5.079  1.00  0.00           H 
ATOM   1217  HD1 HIS A  79      -7.548  -7.885  -3.235  1.00  0.00           H 
ATOM   1218  HD2 HIS A  79     -10.536 -10.716  -2.687  1.00  0.00           H 
ATOM   1219  HE1 HIS A  79      -7.054  -8.970  -1.031  1.00  0.00           H 
ATOM   1220  HE2 HIS A  79      -8.704 -10.853  -0.873  1.00  0.00           H 
ATOM   1221  N   GLY A  80     -10.557  -9.291  -8.214  1.00  0.00           N 
ATOM   1222  CA  GLY A  80     -11.533  -9.018  -9.294  1.00  0.00           C 
ATOM   1223  C   GLY A  80     -11.312  -7.720 -10.069  1.00  0.00           C 
ATOM   1224  O   GLY A  80     -12.272  -6.996 -10.349  1.00  0.00           O 
ATOM   1225  H   GLY A  80      -9.639  -9.502  -8.466  1.00  0.00           H 
ATOM   1226 2HA  GLY A  80     -12.542  -9.007  -8.882  1.00  0.00           H 
ATOM   1227 1HA  GLY A  80     -11.476  -9.830 -10.000  1.00  0.00           H 
ATOM   1228  N   LEU A  81     -10.051  -7.419 -10.427  1.00  0.00           N 
ATOM   1229  CA  LEU A  81      -9.723  -6.369 -11.432  1.00  0.00           C 
ATOM   1230  C   LEU A  81      -9.052  -7.044 -12.637  1.00  0.00           C 
ATOM   1231  O   LEU A  81      -8.228  -7.946 -12.465  1.00  0.00           O 
ATOM   1232  CB  LEU A  81      -8.778  -5.239 -10.870  1.00  0.00           C 
ATOM   1233  CG  LEU A  81      -9.440  -4.074 -10.065  1.00  0.00           C 
ATOM   1234  CD1 LEU A  81     -10.495  -3.342 -10.914  1.00  0.00           C 
ATOM   1235  CD2 LEU A  81     -10.031  -4.561  -8.735  1.00  0.00           C 
ATOM   1236  H   LEU A  81      -9.318  -7.923 -10.025  1.00  0.00           H 
ATOM   1237  HA  LEU A  81     -10.656  -5.914 -11.768  1.00  0.00           H 
ATOM   1238 2HB  LEU A  81      -8.246  -4.790 -11.706  1.00  0.00           H 
ATOM   1239 1HB  LEU A  81      -8.039  -5.704 -10.234  1.00  0.00           H 
ATOM   1240  HG  LEU A  81      -8.670  -3.345  -9.823  1.00  0.00           H 
ATOM   1241 1HD1 LEU A  81     -11.306  -4.018 -11.167  1.00  0.00           H 
ATOM   1242 2HD1 LEU A  81     -10.040  -2.979 -11.825  1.00  0.00           H 
ATOM   1243 3HD1 LEU A  81     -10.890  -2.503 -10.360  1.00  0.00           H 
ATOM   1244 1HD2 LEU A  81     -10.446  -3.725  -8.184  1.00  0.00           H 
ATOM   1245 2HD2 LEU A  81      -9.252  -5.021  -8.142  1.00  0.00           H 
ATOM   1246 3HD2 LEU A  81     -10.812  -5.288  -8.922  1.00  0.00           H 
ATOM   1247  N   HIS A  82      -9.420  -6.614 -13.848  1.00  0.00           N 
ATOM   1248  CA  HIS A  82      -8.747  -7.029 -15.093  1.00  0.00           C 
ATOM   1249  C   HIS A  82      -7.687  -5.973 -15.485  1.00  0.00           C 
ATOM   1250  O   HIS A  82      -7.828  -4.808 -15.103  1.00  0.00           O 
ATOM   1251  CB  HIS A  82      -9.788  -7.234 -16.232  1.00  0.00           C 
ATOM   1252  CG  HIS A  82     -10.710  -8.413 -16.018  1.00  0.00           C 
ATOM   1253  ND1 HIS A  82     -11.999  -8.471 -16.508  1.00  0.00           N 
ATOM   1254  CD2 HIS A  82     -10.502  -9.599 -15.392  1.00  0.00           C 
ATOM   1255  CE1 HIS A  82     -12.536  -9.632 -16.191  1.00  0.00           C 
ATOM   1256  NE2 HIS A  82     -11.652 -10.333 -15.515  1.00  0.00           N 
ATOM   1257  H   HIS A  82     -10.169  -5.985 -13.911  1.00  0.00           H 
ATOM   1258  HA  HIS A  82      -8.238  -7.971 -14.910  1.00  0.00           H 
ATOM   1259 2HB  HIS A  82      -9.266  -7.395 -17.170  1.00  0.00           H 
ATOM   1260 1HB  HIS A  82     -10.399  -6.348 -16.319  1.00  0.00           H 
ATOM   1261  HD1 HIS A  82     -12.450  -7.769 -17.025  1.00  0.00           H 
ATOM   1262  HD2 HIS A  82      -9.596  -9.910 -14.892  1.00  0.00           H 
ATOM   1263  HE1 HIS A  82     -13.533  -9.958 -16.452  1.00  0.00           H 
ATOM   1264  HE2 HIS A  82     -11.857 -11.145 -15.006  1.00  0.00           H 
ATOM   1265  N   PRO A  83      -6.595  -6.361 -16.235  1.00  0.00           N 
ATOM   1266  CA  PRO A  83      -5.561  -5.401 -16.737  1.00  0.00           C 
ATOM   1267  C   PRO A  83      -6.128  -4.285 -17.654  1.00  0.00           C 
ATOM   1268  O   PRO A  83      -5.462  -3.276 -17.889  1.00  0.00           O 
ATOM   1269  CB  PRO A  83      -4.564  -6.314 -17.502  1.00  0.00           C 
ATOM   1270  CG  PRO A  83      -4.762  -7.675 -16.899  1.00  0.00           C 
ATOM   1271  CD  PRO A  83      -6.237  -7.763 -16.594  1.00  0.00           C 
ATOM   1272  HA  PRO A  83      -5.050  -4.931 -15.903  1.00  0.00           H 
ATOM   1273 2HB  PRO A  83      -3.547  -5.962 -17.357  1.00  0.00           H 
ATOM   1274 1HB  PRO A  83      -4.790  -6.317 -18.566  1.00  0.00           H 
ATOM   1275 2HG  PRO A  83      -4.178  -7.773 -15.987  1.00  0.00           H 
ATOM   1276 1HG  PRO A  83      -4.471  -8.445 -17.609  1.00  0.00           H 
ATOM   1277 2HD  PRO A  83      -6.416  -8.432 -15.762  1.00  0.00           H 
ATOM   1278 1HD  PRO A  83      -6.795  -8.092 -17.467  1.00  0.00           H 
ATOM   1279  N   LYS A  84      -7.366  -4.481 -18.138  1.00  0.00           N 
ATOM   1280  CA  LYS A  84      -8.084  -3.502 -18.983  1.00  0.00           C 
ATOM   1281  C   LYS A  84      -8.407  -2.216 -18.189  1.00  0.00           C 
ATOM   1282  O   LYS A  84      -8.498  -1.127 -18.763  1.00  0.00           O 
ATOM   1283  CB  LYS A  84      -9.385  -4.143 -19.541  1.00  0.00           C 
ATOM   1284  CG  LYS A  84      -9.183  -5.533 -20.199  1.00  0.00           C 
ATOM   1285  CD  LYS A  84      -8.175  -5.517 -21.380  1.00  0.00           C 
ATOM   1286  CE  LYS A  84      -8.673  -4.711 -22.596  1.00  0.00           C 
ATOM   1287  NZ  LYS A  84      -9.898  -5.301 -23.192  1.00  0.00           N 
ATOM   1288  H   LYS A  84      -7.818  -5.316 -17.913  1.00  0.00           H 
ATOM   1289  HA  LYS A  84      -7.434  -3.246 -19.814  1.00  0.00           H 
ATOM   1290 2HB  LYS A  84      -9.814  -3.474 -20.280  1.00  0.00           H 
ATOM   1291 1HB  LYS A  84     -10.097  -4.259 -18.727  1.00  0.00           H 
ATOM   1292 2HG  LYS A  84     -10.143  -5.890 -20.561  1.00  0.00           H 
ATOM   1293 1HG  LYS A  84      -8.818  -6.223 -19.443  1.00  0.00           H 
ATOM   1294 2HD  LYS A  84      -7.991  -6.540 -21.691  1.00  0.00           H 
ATOM   1295 1HD  LYS A  84      -7.238  -5.085 -21.038  1.00  0.00           H 
ATOM   1296 2HE  LYS A  84      -7.897  -4.692 -23.351  1.00  0.00           H 
ATOM   1297 1HE  LYS A  84      -8.893  -3.697 -22.288  1.00  0.00           H 
ATOM   1298 1HZ  LYS A  84      -9.713  -6.277 -23.501  1.00  0.00           H 
ATOM   1299 2HZ  LYS A  84     -10.203  -4.747 -24.013  1.00  0.00           H 
ATOM   1300 3HZ  LYS A  84     -10.667  -5.311 -22.493  1.00  0.00           H 
ATOM   1301  N   PHE A  85      -8.575  -2.382 -16.861  1.00  0.00           N 
ATOM   1302  CA  PHE A  85      -8.742  -1.277 -15.890  1.00  0.00           C 
ATOM   1303  C   PHE A  85      -7.506  -0.352 -15.878  1.00  0.00           C 
ATOM   1304  O   PHE A  85      -7.622   0.863 -15.679  1.00  0.00           O 
ATOM   1305  CB  PHE A  85      -8.978  -1.887 -14.478  1.00  0.00           C 
ATOM   1306  CG  PHE A  85      -9.107  -0.877 -13.331  1.00  0.00           C 
ATOM   1307  CD1 PHE A  85      -8.052  -0.657 -12.436  1.00  0.00           C 
ATOM   1308  CD2 PHE A  85     -10.289  -0.165 -13.138  1.00  0.00           C 
ATOM   1309  CE1 PHE A  85      -8.176   0.253 -11.400  1.00  0.00           C 
ATOM   1310  CE2 PHE A  85     -10.407   0.744 -12.103  1.00  0.00           C 
ATOM   1311  CZ  PHE A  85      -9.357   0.949 -11.231  1.00  0.00           C 
ATOM   1312  H   PHE A  85      -8.606  -3.301 -16.518  1.00  0.00           H 
ATOM   1313  HA  PHE A  85      -9.614  -0.702 -16.182  1.00  0.00           H 
ATOM   1314 2HB  PHE A  85      -8.154  -2.559 -14.248  1.00  0.00           H 
ATOM   1315 1HB  PHE A  85      -9.888  -2.475 -14.505  1.00  0.00           H 
ATOM   1316  HD1 PHE A  85      -7.122  -1.200 -12.563  1.00  0.00           H 
ATOM   1317  HD2 PHE A  85     -11.121  -0.319 -13.819  1.00  0.00           H 
ATOM   1318  HE1 PHE A  85      -7.351   0.413 -10.718  1.00  0.00           H 
ATOM   1319  HE2 PHE A  85     -11.330   1.289 -11.973  1.00  0.00           H 
ATOM   1320  HZ  PHE A  85      -9.458   1.659 -10.423  1.00  0.00           H 
ATOM   1321  N   GLY A  86      -6.328  -0.944 -16.131  1.00  0.00           N 
ATOM   1322  CA  GLY A  86      -5.050  -0.245 -16.002  1.00  0.00           C 
ATOM   1323  C   GLY A  86      -4.503  -0.368 -14.593  1.00  0.00           C 
ATOM   1324  O   GLY A  86      -4.081   0.620 -13.984  1.00  0.00           O 
ATOM   1325  H   GLY A  86      -6.329  -1.878 -16.417  1.00  0.00           H 
ATOM   1326 2HA  GLY A  86      -5.170   0.803 -16.256  1.00  0.00           H 
ATOM   1327 1HA  GLY A  86      -4.345  -0.693 -16.690  1.00  0.00           H 
ATOM   1328  N   ALA A  87      -4.539  -1.604 -14.072  1.00  0.00           N 
ATOM   1329  CA  ALA A  87      -4.053  -1.917 -12.723  1.00  0.00           C 
ATOM   1330  C   ALA A  87      -2.509  -1.847 -12.673  1.00  0.00           C 
ATOM   1331  O   ALA A  87      -1.939  -0.888 -12.143  1.00  0.00           O 
ATOM   1332  CB  ALA A  87      -4.589  -3.294 -12.286  1.00  0.00           C 
ATOM   1333  H   ALA A  87      -4.914  -2.326 -14.612  1.00  0.00           H 
ATOM   1334  HA  ALA A  87      -4.457  -1.173 -12.041  1.00  0.00           H 
ATOM   1335 1HB  ALA A  87      -5.670  -3.300 -12.342  1.00  0.00           H 
ATOM   1336 2HB  ALA A  87      -4.286  -3.499 -11.268  1.00  0.00           H 
ATOM   1337 3HB  ALA A  87      -4.193  -4.065 -12.937  1.00  0.00           H 
ATOM   1338  N   ILE A  88      -1.840  -2.864 -13.253  1.00  0.00           N 
ATOM   1339  CA  ILE A  88      -0.359  -2.942 -13.308  1.00  0.00           C 
ATOM   1340  C   ILE A  88       0.151  -2.513 -14.703  1.00  0.00           C 
ATOM   1341  O   ILE A  88       1.319  -2.169 -14.873  1.00  0.00           O 
ATOM   1342  CB  ILE A  88       0.129  -4.404 -12.954  1.00  0.00           C 
ATOM   1343  CG1 ILE A  88       1.685  -4.461 -12.764  1.00  0.00           C 
ATOM   1344  CG2 ILE A  88      -0.354  -5.429 -14.016  1.00  0.00           C 
ATOM   1345  CD1 ILE A  88       2.242  -5.819 -12.370  1.00  0.00           C 
ATOM   1346  H   ILE A  88      -2.352  -3.595 -13.648  1.00  0.00           H 
ATOM   1347  HA  ILE A  88       0.050  -2.255 -12.563  1.00  0.00           H 
ATOM   1348  HB  ILE A  88      -0.342  -4.674 -12.012  1.00  0.00           H 
ATOM   1349 2HG1 ILE A  88       1.976  -3.754 -11.993  1.00  0.00           H 
ATOM   1350 1HG1 ILE A  88       2.167  -4.182 -13.689  1.00  0.00           H 
ATOM   1351 1HG2 ILE A  88      -0.052  -6.432 -13.733  1.00  0.00           H 
ATOM   1352 2HG2 ILE A  88       0.078  -5.192 -14.981  1.00  0.00           H 
ATOM   1353 3HG2 ILE A  88      -1.434  -5.393 -14.097  1.00  0.00           H 
ATOM   1354 1HD1 ILE A  88       1.785  -6.150 -11.448  1.00  0.00           H 
ATOM   1355 2HD1 ILE A  88       3.312  -5.743 -12.228  1.00  0.00           H 
ATOM   1356 3HD1 ILE A  88       2.037  -6.535 -13.152  1.00  0.00           H 
ATOM   1357  N   THR A  89      -0.758  -2.527 -15.689  1.00  0.00           N 
ATOM   1358  CA  THR A  89      -0.455  -2.236 -17.105  1.00  0.00           C 
ATOM   1359  C   THR A  89      -0.475  -0.723 -17.419  1.00  0.00           C 
ATOM   1360  O   THR A  89      -0.211  -0.314 -18.558  1.00  0.00           O 
ATOM   1361  CB  THR A  89      -1.482  -3.000 -17.999  1.00  0.00           C 
ATOM   1362  OG1 THR A  89      -2.806  -2.780 -17.479  1.00  0.00           O 
ATOM   1363  CG2 THR A  89      -1.195  -4.515 -18.037  1.00  0.00           C 
ATOM   1364  H   THR A  89      -1.684  -2.747 -15.462  1.00  0.00           H 
ATOM   1365  HA  THR A  89       0.540  -2.616 -17.327  1.00  0.00           H 
ATOM   1366  HB  THR A  89      -1.434  -2.613 -19.014  1.00  0.00           H 
ATOM   1367  HG1 THR A  89      -3.365  -2.408 -18.175  1.00  0.00           H 
ATOM   1368 1HG2 THR A  89      -1.239  -4.921 -17.034  1.00  0.00           H 
ATOM   1369 2HG2 THR A  89      -0.208  -4.695 -18.450  1.00  0.00           H 
ATOM   1370 3HG2 THR A  89      -1.933  -5.010 -18.654  1.00  0.00           H 
ATOM   1371  N   ARG A  90      -0.800   0.098 -16.406  1.00  0.00           N 
ATOM   1372  CA  ARG A  90      -0.725   1.567 -16.492  1.00  0.00           C 
ATOM   1373  C   ARG A  90       0.533   2.016 -15.742  1.00  0.00           C 
ATOM   1374  O   ARG A  90       0.660   1.732 -14.540  1.00  0.00           O 
ATOM   1375  CB  ARG A  90      -1.994   2.212 -15.854  1.00  0.00           C 
ATOM   1376  CG  ARG A  90      -2.208   3.716 -16.171  1.00  0.00           C 
ATOM   1377  CD  ARG A  90      -2.627   3.955 -17.637  1.00  0.00           C 
ATOM   1378  NE  ARG A  90      -2.886   5.381 -17.933  1.00  0.00           N 
ATOM   1379  CZ  ARG A  90      -3.411   5.851 -19.080  1.00  0.00           C 
ATOM   1380  NH1 ARG A  90      -3.732   5.030 -20.072  1.00  0.00           N 
ATOM   1381  NH2 ARG A  90      -3.611   7.150 -19.221  1.00  0.00           N 
ATOM   1382  H   ARG A  90      -1.100  -0.300 -15.564  1.00  0.00           H 
ATOM   1383  HA  ARG A  90      -0.652   1.865 -17.535  1.00  0.00           H 
ATOM   1384 2HB  ARG A  90      -1.945   2.098 -14.774  1.00  0.00           H 
ATOM   1385 1HB  ARG A  90      -2.865   1.671 -16.207  1.00  0.00           H 
ATOM   1386 2HG  ARG A  90      -1.281   4.250 -15.978  1.00  0.00           H 
ATOM   1387 1HG  ARG A  90      -2.981   4.112 -15.519  1.00  0.00           H 
ATOM   1388 2HD  ARG A  90      -3.526   3.383 -17.842  1.00  0.00           H 
ATOM   1389 1HD  ARG A  90      -1.831   3.607 -18.289  1.00  0.00           H 
ATOM   1390  HE  ARG A  90      -2.664   6.028 -17.227  1.00  0.00           H 
ATOM   1391 1HH1 ARG A  90      -3.587   4.043 -19.973  1.00  0.00           H 
ATOM   1392 2HH1 ARG A  90      -4.131   5.389 -20.918  1.00  0.00           H 
ATOM   1393 1HH2 ARG A  90      -3.378   7.777 -18.472  1.00  0.00           H 
ATOM   1394 2HH2 ARG A  90      -4.001   7.513 -20.069  1.00  0.00           H 
ATOM   1395  N   VAL A  91       1.483   2.667 -16.442  1.00  0.00           N 
ATOM   1396  CA  VAL A  91       2.668   3.246 -15.787  1.00  0.00           C 
ATOM   1397  C   VAL A  91       2.232   4.461 -14.935  1.00  0.00           C 
ATOM   1398  O   VAL A  91       1.983   5.559 -15.451  1.00  0.00           O 
ATOM   1399  CB  VAL A  91       3.833   3.618 -16.804  1.00  0.00           C 
ATOM   1400  CG1 VAL A  91       4.455   2.343 -17.425  1.00  0.00           C 
ATOM   1401  CG2 VAL A  91       3.373   4.587 -17.924  1.00  0.00           C 
ATOM   1402  H   VAL A  91       1.383   2.756 -17.409  1.00  0.00           H 
ATOM   1403  HA  VAL A  91       3.061   2.484 -15.106  1.00  0.00           H 
ATOM   1404  HB  VAL A  91       4.616   4.116 -16.232  1.00  0.00           H 
ATOM   1405 1HG1 VAL A  91       4.830   1.698 -16.639  1.00  0.00           H 
ATOM   1406 2HG1 VAL A  91       5.277   2.614 -18.077  1.00  0.00           H 
ATOM   1407 3HG1 VAL A  91       3.707   1.809 -17.998  1.00  0.00           H 
ATOM   1408 1HG2 VAL A  91       2.584   4.126 -18.506  1.00  0.00           H 
ATOM   1409 2HG2 VAL A  91       4.205   4.823 -18.575  1.00  0.00           H 
ATOM   1410 3HG2 VAL A  91       3.002   5.502 -17.483  1.00  0.00           H 
ATOM   1411  N   HIS A  92       2.041   4.214 -13.622  1.00  0.00           N 
ATOM   1412  CA  HIS A  92       1.611   5.252 -12.673  1.00  0.00           C 
ATOM   1413  C   HIS A  92       2.725   6.301 -12.547  1.00  0.00           C 
ATOM   1414  O   HIS A  92       3.779   6.029 -11.982  1.00  0.00           O 
ATOM   1415  CB  HIS A  92       1.242   4.649 -11.290  1.00  0.00           C 
ATOM   1416  CG  HIS A  92       0.083   3.671 -11.333  1.00  0.00           C 
ATOM   1417  ND1 HIS A  92      -1.236   4.053 -11.206  1.00  0.00           N 
ATOM   1418  CD2 HIS A  92       0.057   2.322 -11.494  1.00  0.00           C 
ATOM   1419  CE1 HIS A  92      -2.014   2.989 -11.292  1.00  0.00           C 
ATOM   1420  NE2 HIS A  92      -1.253   1.929 -11.465  1.00  0.00           N 
ATOM   1421  H   HIS A  92       2.198   3.305 -13.292  1.00  0.00           H 
ATOM   1422  HA  HIS A  92       0.724   5.731 -13.090  1.00  0.00           H 
ATOM   1423 2HB  HIS A  92       0.968   5.458 -10.614  1.00  0.00           H 
ATOM   1424 1HB  HIS A  92       2.102   4.133 -10.883  1.00  0.00           H 
ATOM   1425  HD1 HIS A  92      -1.555   4.969 -11.050  1.00  0.00           H 
ATOM   1426  HD2 HIS A  92       0.915   1.678 -11.627  1.00  0.00           H 
ATOM   1427  HE1 HIS A  92      -3.092   2.988 -11.233  1.00  0.00           H 
ATOM   1428  HE2 HIS A  92      -1.559   1.004 -11.383  1.00  0.00           H 
ATOM   1429  N   LYS A  93       2.492   7.482 -13.133  1.00  0.00           N 
ATOM   1430  CA  LYS A  93       3.489   8.568 -13.188  1.00  0.00           C 
ATOM   1431  C   LYS A  93       3.647   9.235 -11.810  1.00  0.00           C 
ATOM   1432  O   LYS A  93       4.724   9.737 -11.469  1.00  0.00           O 
ATOM   1433  CB  LYS A  93       3.075   9.600 -14.267  1.00  0.00           C 
ATOM   1434  CG  LYS A  93       2.959   9.017 -15.694  1.00  0.00           C 
ATOM   1435  CD  LYS A  93       2.605  10.069 -16.786  1.00  0.00           C 
ATOM   1436  CE  LYS A  93       1.178  10.666 -16.665  1.00  0.00           C 
ATOM   1437  NZ  LYS A  93       1.033  11.660 -15.562  1.00  0.00           N 
ATOM   1438  H   LYS A  93       1.610   7.638 -13.536  1.00  0.00           H 
ATOM   1439  HA  LYS A  93       4.443   8.132 -13.472  1.00  0.00           H 
ATOM   1440 2HB  LYS A  93       3.807  10.403 -14.287  1.00  0.00           H 
ATOM   1441 1HB  LYS A  93       2.111  10.022 -13.996  1.00  0.00           H 
ATOM   1442 2HG  LYS A  93       2.193   8.246 -15.689  1.00  0.00           H 
ATOM   1443 1HG  LYS A  93       3.908   8.558 -15.956  1.00  0.00           H 
ATOM   1444 2HD  LYS A  93       2.700   9.596 -17.760  1.00  0.00           H 
ATOM   1445 1HD  LYS A  93       3.319  10.882 -16.729  1.00  0.00           H 
ATOM   1446 2HE  LYS A  93       0.476   9.859 -16.496  1.00  0.00           H 
ATOM   1447 1HE  LYS A  93       0.925  11.158 -17.595  1.00  0.00           H 
ATOM   1448 1HZ  LYS A  93       1.721  12.431 -15.678  1.00  0.00           H 
ATOM   1449 2HZ  LYS A  93       1.192  11.205 -14.642  1.00  0.00           H 
ATOM   1450 3HZ  LYS A  93       0.076  12.062 -15.570  1.00  0.00           H 
ATOM   1451  N   GLU A  94       2.556   9.207 -11.022  1.00  0.00           N 
ATOM   1452  CA  GLU A  94       2.523   9.729  -9.643  1.00  0.00           C 
ATOM   1453  C   GLU A  94       2.995   8.671  -8.620  1.00  0.00           C 
ATOM   1454  O   GLU A  94       2.924   8.912  -7.406  1.00  0.00           O 
ATOM   1455  CB  GLU A  94       1.092  10.213  -9.311  1.00  0.00           C 
ATOM   1456  CG  GLU A  94       0.583  11.336 -10.238  1.00  0.00           C 
ATOM   1457  CD  GLU A  94      -0.884  11.706  -9.996  1.00  0.00           C 
ATOM   1458  OE1 GLU A  94      -1.771  11.134 -10.672  1.00  0.00           O 
ATOM   1459  OE2 GLU A  94      -1.167  12.561  -9.125  1.00  0.00           O 
ATOM   1460  H   GLU A  94       1.732   8.819 -11.388  1.00  0.00           H 
ATOM   1461  HA  GLU A  94       3.200  10.577  -9.584  1.00  0.00           H 
ATOM   1462 2HB  GLU A  94       1.072  10.578  -8.288  1.00  0.00           H 
ATOM   1463 1HB  GLU A  94       0.413   9.368  -9.391  1.00  0.00           H 
ATOM   1464 2HG  GLU A  94       0.696  11.002 -11.267  1.00  0.00           H 
ATOM   1465 1HG  GLU A  94       1.199  12.220 -10.093  1.00  0.00           H 
ATOM   1466  N   TYR A  95       3.476   7.503  -9.118  1.00  0.00           N 
ATOM   1467  CA  TYR A  95       4.135   6.486  -8.279  1.00  0.00           C 
ATOM   1468  C   TYR A  95       5.365   7.088  -7.593  1.00  0.00           C 
ATOM   1469  O   TYR A  95       5.620   6.779  -6.446  1.00  0.00           O 
ATOM   1470  CB  TYR A  95       4.545   5.236  -9.115  1.00  0.00           C 
ATOM   1471  CG  TYR A  95       5.515   4.274  -8.392  1.00  0.00           C 
ATOM   1472  CD1 TYR A  95       6.863   4.178  -8.774  1.00  0.00           C 
ATOM   1473  CD2 TYR A  95       5.098   3.507  -7.302  1.00  0.00           C 
ATOM   1474  CE1 TYR A  95       7.742   3.349  -8.104  1.00  0.00           C 
ATOM   1475  CE2 TYR A  95       5.978   2.674  -6.635  1.00  0.00           C 
ATOM   1476  CZ  TYR A  95       7.293   2.602  -7.033  1.00  0.00           C 
ATOM   1477  OH  TYR A  95       8.162   1.777  -6.358  1.00  0.00           O 
ATOM   1478  H   TYR A  95       3.386   7.329 -10.076  1.00  0.00           H 
ATOM   1479  HA  TYR A  95       3.423   6.180  -7.516  1.00  0.00           H 
ATOM   1480 2HB  TYR A  95       5.016   5.567 -10.034  1.00  0.00           H 
ATOM   1481 1HB  TYR A  95       3.652   4.675  -9.373  1.00  0.00           H 
ATOM   1482  HD1 TYR A  95       7.216   4.759  -9.619  1.00  0.00           H 
ATOM   1483  HD2 TYR A  95       4.065   3.558  -6.987  1.00  0.00           H 
ATOM   1484  HE1 TYR A  95       8.780   3.294  -8.417  1.00  0.00           H 
ATOM   1485  HE2 TYR A  95       5.631   2.089  -5.797  1.00  0.00           H 
ATOM   1486  HH  TYR A  95       7.726   0.944  -6.165  1.00  0.00           H 
ATOM   1487  N   ASP A  96       6.110   7.947  -8.322  1.00  0.00           N 
ATOM   1488  CA  ASP A  96       7.323   8.614  -7.801  1.00  0.00           C 
ATOM   1489  C   ASP A  96       7.007   9.511  -6.587  1.00  0.00           C 
ATOM   1490  O   ASP A  96       7.827   9.639  -5.678  1.00  0.00           O 
ATOM   1491  CB  ASP A  96       8.008   9.445  -8.910  1.00  0.00           C 
ATOM   1492  CG  ASP A  96       8.579   8.562 -10.026  1.00  0.00           C 
ATOM   1493  OD1 ASP A  96       7.841   8.243 -10.981  1.00  0.00           O 
ATOM   1494  OD2 ASP A  96       9.759   8.151  -9.938  1.00  0.00           O 
ATOM   1495  H   ASP A  96       5.848   8.128  -9.252  1.00  0.00           H 
ATOM   1496  HA  ASP A  96       8.009   7.832  -7.481  1.00  0.00           H 
ATOM   1497 2HB  ASP A  96       8.818  10.029  -8.479  1.00  0.00           H 
ATOM   1498 1HB  ASP A  96       7.280  10.130  -9.336  1.00  0.00           H 
ATOM   1499  N   ALA A  97       5.803  10.107  -6.585  1.00  0.00           N 
ATOM   1500  CA  ALA A  97       5.326  10.970  -5.487  1.00  0.00           C 
ATOM   1501  C   ALA A  97       5.018  10.140  -4.217  1.00  0.00           C 
ATOM   1502  O   ALA A  97       5.357  10.536  -3.100  1.00  0.00           O 
ATOM   1503  CB  ALA A  97       4.099  11.770  -5.945  1.00  0.00           C 
ATOM   1504  H   ALA A  97       5.212   9.961  -7.353  1.00  0.00           H 
ATOM   1505  HA  ALA A  97       6.119  11.679  -5.254  1.00  0.00           H 
ATOM   1506 1HB  ALA A  97       3.784  12.445  -5.157  1.00  0.00           H 
ATOM   1507 2HB  ALA A  97       3.286  11.095  -6.178  1.00  0.00           H 
ATOM   1508 3HB  ALA A  97       4.344  12.345  -6.829  1.00  0.00           H 
ATOM   1509  N   MET A  98       4.338   9.006  -4.405  1.00  0.00           N 
ATOM   1510  CA  MET A  98       4.095   8.012  -3.331  1.00  0.00           C 
ATOM   1511  C   MET A  98       5.418   7.385  -2.814  1.00  0.00           C 
ATOM   1512  O   MET A  98       5.594   7.159  -1.619  1.00  0.00           O 
ATOM   1513  CB  MET A  98       3.161   6.917  -3.897  1.00  0.00           C 
ATOM   1514  CG  MET A  98       2.554   5.951  -2.868  1.00  0.00           C 
ATOM   1515  SD  MET A  98       1.484   4.703  -3.631  1.00  0.00           S 
ATOM   1516  CE  MET A  98       0.508   5.665  -4.781  1.00  0.00           C 
ATOM   1517  H   MET A  98       3.896   8.869  -5.270  1.00  0.00           H 
ATOM   1518  HA  MET A  98       3.598   8.517  -2.511  1.00  0.00           H 
ATOM   1519 2HB  MET A  98       3.715   6.332  -4.624  1.00  0.00           H 
ATOM   1520 1HB  MET A  98       2.341   7.403  -4.410  1.00  0.00           H 
ATOM   1521 2HG  MET A  98       1.971   6.512  -2.151  1.00  0.00           H 
ATOM   1522 1HG  MET A  98       3.355   5.437  -2.351  1.00  0.00           H 
ATOM   1523 1HE  MET A  98       1.155   6.105  -5.526  1.00  0.00           H 
ATOM   1524 2HE  MET A  98      -0.012   6.446  -4.247  1.00  0.00           H 
ATOM   1525 3HE  MET A  98      -0.213   5.023  -5.265  1.00  0.00           H 
ATOM   1526  N   PHE A  99       6.315   7.121  -3.766  1.00  0.00           N 
ATOM   1527  CA  PHE A  99       7.653   6.536  -3.543  1.00  0.00           C 
ATOM   1528  C   PHE A  99       8.479   7.417  -2.592  1.00  0.00           C 
ATOM   1529  O   PHE A  99       9.036   6.926  -1.598  1.00  0.00           O 
ATOM   1530  CB  PHE A  99       8.364   6.379  -4.916  1.00  0.00           C 
ATOM   1531  CG  PHE A  99       9.773   5.779  -4.878  1.00  0.00           C 
ATOM   1532  CD1 PHE A  99      10.906   6.597  -4.812  1.00  0.00           C 
ATOM   1533  CD2 PHE A  99       9.962   4.397  -4.912  1.00  0.00           C 
ATOM   1534  CE1 PHE A  99      12.172   6.051  -4.782  1.00  0.00           C 
ATOM   1535  CE2 PHE A  99      11.231   3.855  -4.884  1.00  0.00           C 
ATOM   1536  CZ  PHE A  99      12.335   4.680  -4.817  1.00  0.00           C 
ATOM   1537  H   PHE A  99       6.034   7.320  -4.670  1.00  0.00           H 
ATOM   1538  HA  PHE A  99       7.520   5.556  -3.096  1.00  0.00           H 
ATOM   1539 2HB  PHE A  99       8.428   7.356  -5.384  1.00  0.00           H 
ATOM   1540 1HB  PHE A  99       7.752   5.746  -5.550  1.00  0.00           H 
ATOM   1541  HD1 PHE A  99      10.785   7.675  -4.786  1.00  0.00           H 
ATOM   1542  HD2 PHE A  99       9.097   3.743  -4.964  1.00  0.00           H 
ATOM   1543  HE1 PHE A  99      13.041   6.698  -4.731  1.00  0.00           H 
ATOM   1544  HE2 PHE A  99      11.361   2.784  -4.912  1.00  0.00           H 
ATOM   1545  HZ  PHE A  99      13.331   4.252  -4.794  1.00  0.00           H 
ATOM   1546  N   GLU A 100       8.531   8.729  -2.905  1.00  0.00           N 
ATOM   1547  CA  GLU A 100       9.299   9.709  -2.124  1.00  0.00           C 
ATOM   1548  C   GLU A 100       8.654   9.971  -0.745  1.00  0.00           C 
ATOM   1549  O   GLU A 100       9.364  10.256   0.232  1.00  0.00           O 
ATOM   1550  CB  GLU A 100       9.487  11.024  -2.904  1.00  0.00           C 
ATOM   1551  CG  GLU A 100       8.188  11.775  -3.220  1.00  0.00           C 
ATOM   1552  CD  GLU A 100       8.413  13.113  -3.918  1.00  0.00           C 
ATOM   1553  OE1 GLU A 100       8.721  13.118  -5.126  1.00  0.00           O 
ATOM   1554  OE2 GLU A 100       8.297  14.167  -3.256  1.00  0.00           O 
ATOM   1555  H   GLU A 100       8.051   9.040  -3.699  1.00  0.00           H 
ATOM   1556  HA  GLU A 100      10.279   9.274  -1.958  1.00  0.00           H 
ATOM   1557 2HB  GLU A 100       9.985  10.797  -3.843  1.00  0.00           H 
ATOM   1558 1HB  GLU A 100      10.134  11.680  -2.329  1.00  0.00           H 
ATOM   1559 2HG  GLU A 100       7.653  11.944  -2.290  1.00  0.00           H 
ATOM   1560 1HG  GLU A 100       7.572  11.151  -3.861  1.00  0.00           H 
ATOM   1561  N   ASP A 101       7.313   9.859  -0.678  1.00  0.00           N 
ATOM   1562  CA  ASP A 101       6.566   9.938   0.591  1.00  0.00           C 
ATOM   1563  C   ASP A 101       7.044   8.829   1.546  1.00  0.00           C 
ATOM   1564  O   ASP A 101       7.445   9.103   2.675  1.00  0.00           O 
ATOM   1565  CB  ASP A 101       5.037   9.810   0.338  1.00  0.00           C 
ATOM   1566  CG  ASP A 101       4.196   9.798   1.637  1.00  0.00           C 
ATOM   1567  OD1 ASP A 101       3.781  10.883   2.104  1.00  0.00           O 
ATOM   1568  OD2 ASP A 101       3.970   8.708   2.209  1.00  0.00           O 
ATOM   1569  H   ASP A 101       6.814   9.717  -1.511  1.00  0.00           H 
ATOM   1570  HA  ASP A 101       6.773  10.908   1.038  1.00  0.00           H 
ATOM   1571 2HB  ASP A 101       4.845   8.893  -0.211  1.00  0.00           H 
ATOM   1572 1HB  ASP A 101       4.716  10.646  -0.274  1.00  0.00           H 
ATOM   1573  N   ILE A 102       6.995   7.586   1.045  1.00  0.00           N 
ATOM   1574  CA  ILE A 102       7.371   6.379   1.795  1.00  0.00           C 
ATOM   1575  C   ILE A 102       8.872   6.366   2.192  1.00  0.00           C 
ATOM   1576  O   ILE A 102       9.186   5.946   3.296  1.00  0.00           O 
ATOM   1577  CB  ILE A 102       6.952   5.080   0.992  1.00  0.00           C 
ATOM   1578  CG1 ILE A 102       5.390   5.028   0.855  1.00  0.00           C 
ATOM   1579  CG2 ILE A 102       7.492   3.774   1.638  1.00  0.00           C 
ATOM   1580  CD1 ILE A 102       4.835   3.822   0.114  1.00  0.00           C 
ATOM   1581  H   ILE A 102       6.629   7.478   0.146  1.00  0.00           H 
ATOM   1582  HA  ILE A 102       6.786   6.395   2.715  1.00  0.00           H 
ATOM   1583  HB  ILE A 102       7.387   5.157  -0.004  1.00  0.00           H 
ATOM   1584 2HG1 ILE A 102       5.054   5.916   0.329  1.00  0.00           H 
ATOM   1585 1HG1 ILE A 102       4.947   5.024   1.841  1.00  0.00           H 
ATOM   1586 1HG2 ILE A 102       7.104   3.678   2.645  1.00  0.00           H 
ATOM   1587 2HG2 ILE A 102       8.571   3.803   1.677  1.00  0.00           H 
ATOM   1588 3HG2 ILE A 102       7.184   2.916   1.052  1.00  0.00           H 
ATOM   1589 1HD1 ILE A 102       5.238   3.791  -0.888  1.00  0.00           H 
ATOM   1590 2HD1 ILE A 102       3.759   3.900   0.063  1.00  0.00           H 
ATOM   1591 3HD1 ILE A 102       5.102   2.915   0.639  1.00  0.00           H 
ATOM   1592  N   ARG A 103       9.792   6.849   1.319  1.00  0.00           N 
ATOM   1593  CA  ARG A 103      11.250   6.864   1.657  1.00  0.00           C 
ATOM   1594  C   ARG A 103      11.562   7.892   2.760  1.00  0.00           C 
ATOM   1595  O   ARG A 103      12.472   7.680   3.572  1.00  0.00           O 
ATOM   1596  CB  ARG A 103      12.169   7.019   0.397  1.00  0.00           C 
ATOM   1597  CG  ARG A 103      12.073   8.333  -0.411  1.00  0.00           C 
ATOM   1598  CD  ARG A 103      12.959   9.483   0.108  1.00  0.00           C 
ATOM   1599  NE  ARG A 103      12.919  10.630  -0.821  1.00  0.00           N 
ATOM   1600  CZ  ARG A 103      12.215  11.763  -0.650  1.00  0.00           C 
ATOM   1601  NH1 ARG A 103      11.569  12.003   0.477  1.00  0.00           N 
ATOM   1602  NH2 ARG A 103      12.164  12.658  -1.621  1.00  0.00           N 
ATOM   1603  H   ARG A 103       9.473   7.177   0.456  1.00  0.00           H 
ATOM   1604  HA  ARG A 103      11.459   5.881   2.085  1.00  0.00           H 
ATOM   1605 2HB  ARG A 103      11.930   6.200  -0.279  1.00  0.00           H 
ATOM   1606 1HB  ARG A 103      13.200   6.891   0.706  1.00  0.00           H 
ATOM   1607 2HG  ARG A 103      11.041   8.664  -0.402  1.00  0.00           H 
ATOM   1608 1HG  ARG A 103      12.356   8.130  -1.438  1.00  0.00           H 
ATOM   1609 2HD  ARG A 103      13.982   9.132   0.186  1.00  0.00           H 
ATOM   1610 1HD  ARG A 103      12.612   9.791   1.089  1.00  0.00           H 
ATOM   1611  HE  ARG A 103      13.433  10.530  -1.655  1.00  0.00           H 
ATOM   1612 1HH1 ARG A 103      11.604  11.347   1.228  1.00  0.00           H 
ATOM   1613 2HH1 ARG A 103      11.022  12.838   0.570  1.00  0.00           H 
ATOM   1614 1HH2 ARG A 103      12.657  12.497  -2.480  1.00  0.00           H 
ATOM   1615 2HH2 ARG A 103      11.623  13.497  -1.507  1.00  0.00           H 
ATOM   1616  N   ALA A 104      10.784   8.990   2.798  1.00  0.00           N 
ATOM   1617  CA  ALA A 104      10.911  10.016   3.848  1.00  0.00           C 
ATOM   1618  C   ALA A 104      10.304   9.512   5.169  1.00  0.00           C 
ATOM   1619  O   ALA A 104      10.874   9.709   6.237  1.00  0.00           O 
ATOM   1620  CB  ALA A 104      10.240  11.320   3.405  1.00  0.00           C 
ATOM   1621  H   ALA A 104      10.064   9.084   2.136  1.00  0.00           H 
ATOM   1622  HA  ALA A 104      11.972  10.211   3.998  1.00  0.00           H 
ATOM   1623 1HB  ALA A 104      10.365  12.076   4.170  1.00  0.00           H 
ATOM   1624 2HB  ALA A 104       9.183  11.149   3.236  1.00  0.00           H 
ATOM   1625 3HB  ALA A 104      10.695  11.666   2.489  1.00  0.00           H 
ATOM   1626  N   LYS A 105       9.113   8.899   5.068  1.00  0.00           N 
ATOM   1627  CA  LYS A 105       8.384   8.275   6.193  1.00  0.00           C 
ATOM   1628  C   LYS A 105       9.185   7.149   6.885  1.00  0.00           C 
ATOM   1629  O   LYS A 105       9.189   7.047   8.112  1.00  0.00           O 
ATOM   1630  CB  LYS A 105       7.035   7.725   5.649  1.00  0.00           C 
ATOM   1631  CG  LYS A 105       5.956   7.453   6.708  1.00  0.00           C 
ATOM   1632  CD  LYS A 105       5.529   8.726   7.462  1.00  0.00           C 
ATOM   1633  CE  LYS A 105       4.398   8.459   8.459  1.00  0.00           C 
ATOM   1634  NZ  LYS A 105       3.126   8.088   7.782  1.00  0.00           N 
ATOM   1635  H   LYS A 105       8.628   8.947   4.226  1.00  0.00           H 
ATOM   1636  HA  LYS A 105       8.182   9.055   6.914  1.00  0.00           H 
ATOM   1637 2HB  LYS A 105       7.227   6.797   5.113  1.00  0.00           H 
ATOM   1638 1HB  LYS A 105       6.632   8.439   4.943  1.00  0.00           H 
ATOM   1639 2HG  LYS A 105       6.345   6.733   7.424  1.00  0.00           H 
ATOM   1640 1HG  LYS A 105       5.086   7.024   6.218  1.00  0.00           H 
ATOM   1641 2HD  LYS A 105       5.193   9.465   6.740  1.00  0.00           H 
ATOM   1642 1HD  LYS A 105       6.384   9.123   8.000  1.00  0.00           H 
ATOM   1643 2HE  LYS A 105       4.233   9.348   9.054  1.00  0.00           H 
ATOM   1644 1HE  LYS A 105       4.697   7.644   9.111  1.00  0.00           H 
ATOM   1645 1HZ  LYS A 105       2.791   8.877   7.190  1.00  0.00           H 
ATOM   1646 2HZ  LYS A 105       2.393   7.863   8.485  1.00  0.00           H 
ATOM   1647 3HZ  LYS A 105       3.273   7.258   7.178  1.00  0.00           H 
ATOM   1648  N   LEU A 106       9.835   6.303   6.073  1.00  0.00           N 
ATOM   1649  CA  LEU A 106      10.764   5.252   6.553  1.00  0.00           C 
ATOM   1650  C   LEU A 106      11.969   5.862   7.293  1.00  0.00           C 
ATOM   1651  O   LEU A 106      12.514   5.244   8.209  1.00  0.00           O 
ATOM   1652  CB  LEU A 106      11.261   4.346   5.371  1.00  0.00           C 
ATOM   1653  CG  LEU A 106      10.479   3.013   5.133  1.00  0.00           C 
ATOM   1654  CD1 LEU A 106       8.976   3.257   4.962  1.00  0.00           C 
ATOM   1655  CD2 LEU A 106      11.045   2.245   3.916  1.00  0.00           C 
ATOM   1656  H   LEU A 106       9.644   6.363   5.127  1.00  0.00           H 
ATOM   1657  HA  LEU A 106      10.197   4.645   7.258  1.00  0.00           H 
ATOM   1658 2HB  LEU A 106      12.303   4.089   5.538  1.00  0.00           H 
ATOM   1659 1HB  LEU A 106      11.213   4.932   4.459  1.00  0.00           H 
ATOM   1660  HG  LEU A 106      10.600   2.376   6.004  1.00  0.00           H 
ATOM   1661 1HD1 LEU A 106       8.585   3.768   5.831  1.00  0.00           H 
ATOM   1662 2HD1 LEU A 106       8.464   2.313   4.852  1.00  0.00           H 
ATOM   1663 3HD1 LEU A 106       8.800   3.863   4.081  1.00  0.00           H 
ATOM   1664 1HD2 LEU A 106      10.508   1.313   3.793  1.00  0.00           H 
ATOM   1665 2HD2 LEU A 106      12.094   2.027   4.073  1.00  0.00           H 
ATOM   1666 3HD2 LEU A 106      10.934   2.841   3.017  1.00  0.00           H 
ATOM   1667  N   HIS A 107      12.381   7.063   6.863  1.00  0.00           N 
ATOM   1668  CA  HIS A 107      13.452   7.827   7.525  1.00  0.00           C 
ATOM   1669  C   HIS A 107      12.904   8.573   8.768  1.00  0.00           C 
ATOM   1670  O   HIS A 107      13.686   8.991   9.639  1.00  0.00           O 
ATOM   1671  CB  HIS A 107      14.090   8.813   6.507  1.00  0.00           C 
ATOM   1672  CG  HIS A 107      15.289   9.570   7.026  1.00  0.00           C 
ATOM   1673  ND1 HIS A 107      16.525   8.984   7.199  1.00  0.00           N 
ATOM   1674  CD2 HIS A 107      15.429  10.855   7.429  1.00  0.00           C 
ATOM   1675  CE1 HIS A 107      17.367   9.873   7.681  1.00  0.00           C 
ATOM   1676  NE2 HIS A 107      16.728  11.018   7.828  1.00  0.00           N 
ATOM   1677  H   HIS A 107      11.949   7.450   6.073  1.00  0.00           H 
ATOM   1678  HA  HIS A 107      14.213   7.121   7.855  1.00  0.00           H 
ATOM   1679 2HB  HIS A 107      13.342   9.536   6.195  1.00  0.00           H 
ATOM   1680 1HB  HIS A 107      14.414   8.256   5.636  1.00  0.00           H 
ATOM   1681  HD1 HIS A 107      16.750   8.051   6.995  1.00  0.00           H 
ATOM   1682  HD2 HIS A 107      14.659  11.614   7.432  1.00  0.00           H 
ATOM   1683  HE1 HIS A 107      18.406   9.694   7.922  1.00  0.00           H 
ATOM   1684  HE2 HIS A 107      17.070  11.790   8.325  1.00  0.00           H 
END
