
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   61 (  465),  selected   61 , name 2hf1_A
# Molecule2: number of CA atoms   29 (  432),  selected   29 , name T0480.pdb
# PARAMETERS: 2hf1_A.T0480.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    D     2_A      -       -           -
LGA    A     3_A      -       -           -
LGA    K     4_A      -       -           -
LGA    F     5_A      -       -           -
LGA    L     6_A      -       -           -
LGA    E     7_A      -       -           -
LGA    I     8_A      -       -           -
LGA    L     9_A      -       -           -
LGA    V    10_A      F      20          1.208
LGA    C    11_A      C      21          0.333
LGA    P    12_A      P      22          1.223
LGA    L    13_A      R      23          2.222
LGA    C    14_A      C      24          1.523
LGA    K    15_A      G      25          1.341
LGA    -       -      P      26           -
LGA    -       -      G      27           -
LGA    G    16_A      V      28          1.953
LGA    P    17_A      F      29          0.380
LGA    L    18_A      L      30          1.489
LGA    V    19_A      A      31          1.228
LGA    F    20_A      E      32          2.108
LGA    D    21_A      H      33          2.438
LGA    K    22_A      A      34          2.610
LGA    S    23_A      -       -           -
LGA    K    24_A      -       -           -
LGA    D    25_A      D      35          1.302
LGA    E    26_A      R      36          0.985
LGA    L    27_A      Y      37          1.222
LGA    I    28_A      S      38          0.925
LGA    C    29_A      C      39          0.996
LGA    K    30_A      G      40          0.932
LGA    G    31_A      R      41          0.738
LGA    D    32_A      C      42          1.009
LGA    R    33_A      G      43          1.264
LGA    L    34_A      Y      44          1.669
LGA    A    35_A      T      45          0.810
LGA    F    36_A      E      46          1.482
LGA    P    37_A      F      47          2.095
LGA    I    38_A      K      48          1.875
LGA    K    39_A      -       -           -
LGA    D    40_A      -       -           -
LGA    G    41_A      -       -           -
LGA    I    42_A      -       -           -
LGA    P    43_A      -       -           -
LGA    X    44_A      -       -           -
LGA    X    45_A      -       -           -
LGA    L    46_A      -       -           -
LGA    E    47_A      -       -           -
LGA    S    48_A      -       -           -
LGA    E    49_A      -       -           -
LGA    A    50_A      -       -           -
LGA    R    51_A      -       -           -
LGA    E    52_A      -       -           -
LGA    L    53_A      -       -           -
LGA    A    54_A      -       -           -
LGA    P    55_A      -       -           -
LGA    E    56_A      -       -           -
LGA    E    57_A      -       -           -
LGA    E    58_A      -       -           -
LGA    V    59_A      -       -           -
LGA    K    60_A      -       -           -
LGA    L    61_A      -       -           -
LGA    E    62_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   61   29    5.0     27    1.50    22.22     87.553     1.690

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.788089 * X  +   0.260854 * Y  +  -0.557559 * Z  +   7.721664
  Y_new =   0.556624 * X  +   0.084774 * Y  +   0.826428 * Z  +  -8.008204
  Z_new =   0.262843 * X  +  -0.961649 * Y  +  -0.078388 * Z  +  32.194431 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.652131    1.489462  [ DEG:   -94.6601     85.3399 ]
  Theta =  -0.265968   -2.875625  [ DEG:   -15.2388   -164.7612 ]
  Phi   =   0.614939   -2.526654  [ DEG:    35.2334   -144.7666 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2hf1_A                                        
REMARK     2: T0480.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2hf1_A.T0480.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   61   29   5.0   27   1.50   22.22  87.553
REMARK  ---------------------------------------------------------- 
MOLECULE 2hf1_A
HEADER    TRANSFERASE                             22-JUN-06   2HF1              
TITLE     CRYSTAL STRUCTURE OF THE PUTATIVE TETRAACYLDISACCHARIDE-1-P           
TITLE    2 4-KINASE FROM CHROMOBACTERIUM VIOLACEUM. NESG TARGET CVR39.          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TETRAACYLDISACCHARIDE-1-P 4-KINASE;                        
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 EC: 2.7.1.130;                                                       
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: CHROMOBACTERIUM VIOLACEUM;                      
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: ATCC 12472;                                                  
SOURCE   5 GENE: CV_3345;                                                       
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)+ MAGIC;                          
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PET21                                     
KEYWDS    TETRAACYLDISACCHARIDE-1-P 4-KINASE, LPXK, LIPID A                     
KEYWDS   2 BIOSYNTHESIS, NESG, STRUCTURAL GENOMICS, PSI-2, PROTEIN              
KEYWDS   3 STRUCTURE INITIATIVE, NORTHEAST STRUCTURAL GENOMICS                  
KEYWDS   4 CONSORTIUM                                                           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.M.VOROBIEV,M.ABASHIDZE,J.SEETHARAMAN,C.X.CHEN,M.JIANG,              
AUTHOR   2 K.CUNNINGHAM,L.C.MA,R.XIAO,T.ACTON,G.T.MONTELIONE,J.F.HUNT,          
AUTHOR   3 L.TONG,NORTHEAST STRUCTURAL GENOMICS CONSORTIUM (NESG)               
REVDAT   2   19-SEP-06 2HF1    1       AUTHOR                                   
REVDAT   1   22-AUG-06 2HF1    0                                                
JRNL        AUTH   S.M.VOROBIEV,M ABASHIDZE,J.SEETHARAMAN,C.X.CHEN,             
JRNL        AUTH 2 M.JIANG,K.CUNNINGHAM,L.C.MA,R.XIAO,T.ACTON,                  
JRNL        AUTH 3 G.T.MONTELIONE,J.F.HUNT,L.TONG                               
JRNL        TITL   CRYSTAL STRUCTURE OF THE PUTATIVE                            
JRNL        TITL 2 TETRAACYLDISACCHARIDE-1-P 4-KINASE FROM                      
JRNL        TITL 3 CHROMOBACTERIUM VIOLACEUM.                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  2HF1 A    1    60  UNP    Q7NSS5   Q7NSS5_CHRVO     1     60             
DBREF  2HF1 B    1    60  UNP    Q7NSS5   Q7NSS5_CHRVO     1     60             
SEQRES   1 A   68  MSE ASP ALA LYS PHE LEU GLU ILE LEU VAL CYS PRO LEU          
SEQRES   2 A   68  CYS LYS GLY PRO LEU VAL PHE ASP LYS SER LYS ASP GLU          
SEQRES   3 A   68  LEU ILE CYS LYS GLY ASP ARG LEU ALA PHE PRO ILE LYS          
SEQRES   4 A   68  ASP GLY ILE PRO MSE MSE LEU GLU SER GLU ALA ARG GLU          
SEQRES   5 A   68  LEU ALA PRO GLU GLU GLU VAL LYS LEU GLU HIS HIS HIS          
SEQRES   6 A   68  HIS HIS HIS                                                  
SEQRES   1 B   68  MSE ASP ALA LYS PHE LEU GLU ILE LEU VAL CYS PRO LEU          
SEQRES   2 B   68  CYS LYS GLY PRO LEU VAL PHE ASP LYS SER LYS ASP GLU          
SEQRES   3 B   68  LEU ILE CYS LYS GLY ASP ARG LEU ALA PHE PRO ILE LYS          
SEQRES   4 B   68  ASP GLY ILE PRO MSE MSE LEU GLU SER GLU ALA ARG GLU          
SEQRES   5 B   68  LEU ALA PRO GLU GLU GLU VAL LYS LEU GLU HIS HIS HIS          
SEQRES   6 B   68  HIS HIS HIS                                                  
HET    MSE  A  44       8                                                       
HET    MSE  A  45       8                                                       
HET    MSE  B  44       8                                                       
HET    MSE  B  45       8                                                       
HET     ZN    101       1                                                       
HET     ZN    102       1                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      ZN ZINC ION                                                         
FORMUL   1  MSE    4(C5 H11 N O2 SE)                                            
FORMUL   3   ZN    2(ZN 2+)                                                     
FORMUL   5  HOH   *52(H2 O)                                                     
CRYST1   27.517   93.854   87.219  90.00  90.00  90.00 C 2 2 21     16          
ATOM      1  N   ASP A   2      -5.579  36.073 -21.961  1.00 42.04           N  
ATOM      2  CA  ASP A   2      -5.834  34.939 -21.026  1.00 41.31           C  
ATOM      3  C   ASP A   2      -6.543  35.429 -19.764  1.00 41.55           C  
ATOM      4  O   ASP A   2      -6.443  36.603 -19.400  1.00 41.92           O  
ATOM      5  CB  ASP A   2      -4.517  34.266 -20.655  1.00 42.07           C  
ATOM      6  N   ALA A   3      -7.259  34.525 -19.103  1.00 40.63           N  
ATOM      7  CA  ALA A   3      -7.977  34.863 -17.885  1.00 38.12           C  
ATOM      8  C   ALA A   3      -6.977  35.021 -16.754  1.00 37.66           C  
ATOM      9  O   ALA A   3      -6.154  34.137 -16.517  1.00 37.28           O  
ATOM     10  CB  ALA A   3      -8.978  33.771 -17.544  1.00 40.51           C  
ATOM     11  N   LYS A   4      -7.044  36.149 -16.061  1.00 35.75           N  
ATOM     12  CA  LYS A   4      -6.134  36.394 -14.954  1.00 33.27           C  
ATOM     13  C   LYS A   4      -6.840  37.058 -13.784  1.00 29.77           C  
ATOM     14  O   LYS A   4      -7.972  37.529 -13.909  1.00 25.52           O  
ATOM     15  CB  LYS A   4      -4.950  37.242 -15.419  1.00 36.04           C  
ATOM     16  CG  LYS A   4      -5.328  38.526 -16.131  1.00 39.08           C  
ATOM     17  CD  LYS A   4      -4.161  39.011 -16.973  1.00 42.69           C  
ATOM     18  CE  LYS A   4      -3.795  37.973 -18.036  1.00 44.93           C  
ATOM     19  NZ  LYS A   4      -2.541  38.304 -18.772  1.00 46.11           N  
ATOM     20  N   PHE A   5      -6.157  37.081 -12.646  1.00 26.22           N  
ATOM     21  CA  PHE A   5      -6.706  37.661 -11.433  1.00 25.15           C  
ATOM     22  C   PHE A   5      -6.246  39.098 -11.195  1.00 23.05           C  
ATOM     23  O   PHE A   5      -5.091  39.352 -10.853  1.00 21.96           O  
ATOM     24  CB  PHE A   5      -6.339  36.779 -10.237  1.00 24.26           C  
ATOM     25  CG  PHE A   5      -7.078  37.124  -8.976  1.00 26.55           C  
ATOM     26  CD1 PHE A   5      -6.698  38.214  -8.203  1.00 26.92           C  
ATOM     27  CD2 PHE A   5      -8.167  36.360  -8.569  1.00 27.14           C  
ATOM     28  CE1 PHE A   5      -7.392  38.540  -7.040  1.00 29.71           C  
ATOM     29  CE2 PHE A   5      -8.870  36.673  -7.409  1.00 29.80           C  
ATOM     30  CZ  PHE A   5      -8.483  37.767  -6.641  1.00 27.56           C  
ATOM     31  N   LEU A   6      -7.172  40.031 -11.392  1.00 22.04           N  
ATOM     32  CA  LEU A   6      -6.920  41.450 -11.184  1.00 21.30           C  
ATOM     33  C   LEU A   6      -8.059  42.009 -10.329  1.00 22.10           C  
ATOM     34  O   LEU A   6      -9.233  41.899 -10.695  1.00 18.79           O  
ATOM     35  CB  LEU A   6      -6.883  42.207 -12.517  1.00 21.21           C  
ATOM     36  CG  LEU A   6      -5.760  41.967 -13.541  1.00 23.66           C  
ATOM     37  CD1 LEU A   6      -6.105  42.713 -14.829  1.00 23.80           C  
ATOM     38  CD2 LEU A   6      -4.418  42.440 -12.989  1.00 21.45           C  
ATOM     39  N   GLU A   7      -7.722  42.590  -9.181  1.00 21.68           N  
ATOM     40  CA  GLU A   7      -8.750  43.173  -8.322  1.00 21.81           C  
ATOM     41  C   GLU A   7      -8.299  44.494  -7.711  1.00 20.58           C  
ATOM     42  O   GLU A   7      -7.182  44.611  -7.214  1.00 20.10           O  
ATOM     43  CB  GLU A   7      -9.164  42.196  -7.215  1.00 23.35           C  
ATOM     44  CG  GLU A   7      -8.032  41.672  -6.365  1.00 26.30           C  
ATOM     45  CD  GLU A   7      -8.524  40.980  -5.101  1.00 28.30           C  
ATOM     46  OE1 GLU A   7      -9.696  40.543  -5.066  1.00 31.11           O  
ATOM     47  OE2 GLU A   7      -7.733  40.863  -4.145  1.00 25.46           O  
ATOM     48  N   ILE A   8      -9.170  45.498  -7.773  1.00 19.99           N  
ATOM     49  CA  ILE A   8      -8.853  46.804  -7.207  1.00 18.14           C  
ATOM     50  C   ILE A   8      -8.807  46.663  -5.683  1.00 15.73           C  
ATOM     51  O   ILE A   8      -9.637  45.985  -5.089  1.00 15.26           O  
ATOM     52  CB  ILE A   8      -9.900  47.860  -7.617  1.00 19.88           C  
ATOM     53  CG1 ILE A   8      -9.500  49.230  -7.067  1.00 22.86           C  
ATOM     54  CG2 ILE A   8     -11.279  47.455  -7.121  1.00 23.49           C  
ATOM     55  CD1 ILE A   8     -10.357  50.367  -7.585  1.00 26.66           C  
ATOM     56  N   LEU A   9      -7.826  47.294  -5.052  1.00 15.80           N  
ATOM     57  CA  LEU A   9      -7.682  47.189  -3.609  1.00 15.97           C  
ATOM     58  C   LEU A   9      -8.311  48.335  -2.844  1.00 15.80           C  
ATOM     59  O   LEU A   9      -7.615  49.245  -2.415  1.00 15.97           O  
ATOM     60  CB  LEU A   9      -6.202  47.073  -3.229  1.00 16.62           C  
ATOM     61  CG  LEU A   9      -5.460  45.861  -3.798  1.00 18.85           C  
ATOM     62  CD1 LEU A   9      -4.066  45.771  -3.185  1.00 19.11           C  
ATOM     63  CD2 LEU A   9      -6.251  44.598  -3.498  1.00 16.00           C  
ATOM     64  N   VAL A  10      -9.635  48.285  -2.712  1.00 16.31           N  
ATOM     65  CA  VAL A  10     -10.387  49.273  -1.959  1.00 18.81           C  
ATOM     66  C   VAL A  10     -11.325  48.485  -1.058  1.00 18.90           C  
ATOM     67  O   VAL A  10     -11.642  47.325  -1.342  1.00 19.96           O  
ATOM     68  CB  VAL A  10     -11.221  50.227  -2.863  1.00 18.44           C  
ATOM     69  CG1 VAL A  10     -10.302  51.197  -3.575  1.00 20.57           C  
ATOM     70  CG2 VAL A  10     -12.037  49.436  -3.865  1.00 20.11           C  
ATOM     71  N   CYS A  11     -11.750  49.100   0.036  1.00 19.67           N  
ATOM     72  CA  CYS A  11     -12.646  48.429   0.960  1.00 20.99           C  
ATOM     73  C   CYS A  11     -13.939  48.074   0.237  1.00 23.23           C  
ATOM     74  O   CYS A  11     -14.540  48.921  -0.414  1.00 24.70           O  
ATOM     75  CB  CYS A  11     -12.959  49.334   2.150  1.00 21.30           C  
ATOM     76  SG  CYS A  11     -14.208  48.612   3.212  1.00 22.57           S  
ATOM     77  N   PRO A  12     -14.387  46.815   0.343  1.00 26.07           N  
ATOM     78  CA  PRO A  12     -15.621  46.399  -0.327  1.00 29.51           C  
ATOM     79  C   PRO A  12     -16.867  47.169   0.122  1.00 33.24           C  
ATOM     80  O   PRO A  12     -17.917  47.076  -0.511  1.00 35.73           O  
ATOM     81  CB  PRO A  12     -15.704  44.910   0.003  1.00 28.34           C  
ATOM     82  CG  PRO A  12     -15.058  44.829   1.329  1.00 29.83           C  
ATOM     83  CD  PRO A  12     -13.844  45.719   1.160  1.00 27.70           C  
ATOM     84  N   LEU A  13     -16.747  47.935   1.204  1.00 34.71           N  
ATOM     85  CA  LEU A  13     -17.874  48.709   1.714  1.00 35.34           C  
ATOM     86  C   LEU A  13     -17.871  50.187   1.327  1.00 35.37           C  
ATOM     87  O   LEU A  13     -18.724  50.636   0.560  1.00 35.34           O  
ATOM     88  CB  LEU A  13     -17.948  48.596   3.240  1.00 36.88           C  
ATOM     89  CG  LEU A  13     -18.493  47.286   3.811  1.00 38.03           C  
ATOM     90  CD1 LEU A  13     -18.447  47.325   5.333  1.00 38.65           C  
ATOM     91  CD2 LEU A  13     -19.921  47.086   3.336  1.00 39.49           C  
ATOM     92  N   CYS A  14     -16.917  50.941   1.865  1.00 33.37           N  
ATOM     93  CA  CYS A  14     -16.822  52.374   1.605  1.00 31.28           C  
ATOM     94  C   CYS A  14     -16.023  52.729   0.355  1.00 32.87           C  
ATOM     95  O   CYS A  14     -15.983  53.893  -0.045  1.00 32.79           O  
ATOM     96  CB  CYS A  14     -16.188  53.074   2.808  1.00 29.68           C  
ATOM     97  SG  CYS A  14     -14.426  52.680   3.045  1.00 26.96           S  
ATOM     98  N   LYS A  15     -15.387  51.732  -0.252  1.00 33.87           N  
ATOM     99  CA  LYS A  15     -14.564  51.947  -1.442  1.00 32.86           C  
ATOM    100  C   LYS A  15     -13.339  52.814  -1.161  1.00 30.61           C  
ATOM    101  O   LYS A  15     -12.763  53.402  -2.077  1.00 30.30           O  
ATOM    102  CB  LYS A  15     -15.392  52.578  -2.568  1.00 37.55           C  
ATOM    103  CG  LYS A  15     -16.171  51.571  -3.388  1.00 39.27           C  
ATOM    104  CD  LYS A  15     -17.153  50.803  -2.525  1.00 43.37           C  
ATOM    105  CE  LYS A  15     -17.772  49.644  -3.289  1.00 44.44           C  
ATOM    106  NZ  LYS A  15     -18.495  50.064  -4.525  1.00 47.15           N  
ATOM    107  N   GLY A  16     -12.939  52.886   0.105  1.00 27.88           N  
ATOM    108  CA  GLY A  16     -11.772  53.674   0.466  1.00 27.20           C  
ATOM    109  C   GLY A  16     -10.499  52.847   0.401  1.00 25.72           C  
ATOM    110  O   GLY A  16     -10.569  51.623   0.275  1.00 24.29           O  
ATOM    111  N   PRO A  17      -9.318  53.481   0.484  1.00 26.42           N  
ATOM    112  CA  PRO A  17      -8.036  52.770   0.433  1.00 24.70           C  
ATOM    113  C   PRO A  17      -7.801  51.895   1.665  1.00 22.86           C  
ATOM    114  O   PRO A  17      -8.386  52.120   2.722  1.00 20.63           O  
ATOM    115  CB  PRO A  17      -7.021  53.904   0.325  1.00 23.77           C  
ATOM    116  CG  PRO A  17      -7.677  55.000   1.111  1.00 26.18           C  
ATOM    117  CD  PRO A  17      -9.103  54.933   0.632  1.00 25.93           C  
ATOM    118  N   LEU A  18      -6.937  50.899   1.515  1.00 19.06           N  
ATOM    119  CA  LEU A  18      -6.626  49.981   2.602  1.00 19.65           C  
ATOM    120  C   LEU A  18      -5.187  50.133   3.061  1.00 17.88           C  
ATOM    121  O   LEU A  18      -4.302  50.485   2.274  1.00 18.24           O  
ATOM    122  CB  LEU A  18      -6.870  48.544   2.142  1.00 17.30           C  
ATOM    123  CG  LEU A  18      -8.305  48.305   1.682  1.00 19.56           C  
ATOM    124  CD1 LEU A  18      -8.414  47.022   0.890  1.00 22.76           C  
ATOM    125  CD2 LEU A  18      -9.206  48.284   2.907  1.00 19.72           C  
ATOM    126  N   VAL A  19      -4.957  49.870   4.343  1.00 19.20           N  
ATOM    127  CA  VAL A  19      -3.615  49.956   4.910  1.00 20.52           C  
ATOM    128  C   VAL A  19      -3.058  48.540   5.040  1.00 19.38           C  
ATOM    129  O   VAL A  19      -3.695  47.671   5.638  1.00 19.45           O  
ATOM    130  CB  VAL A  19      -3.636  50.620   6.302  1.00 20.51           C  
ATOM    131  CG1 VAL A  19      -2.225  50.684   6.869  1.00 22.61           C  
ATOM    132  CG2 VAL A  19      -4.223  52.012   6.199  1.00 23.21           C  
ATOM    133  N   PHE A  20      -1.877  48.308   4.477  1.00 17.72           N  
ATOM    134  CA  PHE A  20      -1.275  46.984   4.529  1.00 19.15           C  
ATOM    135  C   PHE A  20      -0.571  46.765   5.853  1.00 19.31           C  
ATOM    136  O   PHE A  20       0.280  47.558   6.249  1.00 18.92           O  
ATOM    137  CB  PHE A  20      -0.284  46.798   3.371  1.00 17.05           C  
ATOM    138  CG  PHE A  20       0.495  45.510   3.428  1.00 19.61           C  
ATOM    139  CD1 PHE A  20       1.879  45.527   3.588  1.00 21.46           C  
ATOM    140  CD2 PHE A  20      -0.152  44.279   3.332  1.00 19.80           C  
ATOM    141  CE1 PHE A  20       2.614  44.334   3.641  1.00 22.62           C  
ATOM    142  CE2 PHE A  20       0.574  43.078   3.385  1.00 24.12           C  
ATOM    143  CZ  PHE A  20       1.959  43.112   3.544  1.00 23.92           C  
ATOM    144  N   ASP A  21      -0.956  45.694   6.540  1.00 21.05           N  
ATOM    145  CA  ASP A  21      -0.347  45.331   7.815  1.00 22.88           C  
ATOM    146  C   ASP A  21       0.540  44.122   7.555  1.00 23.99           C  
ATOM    147  O   ASP A  21       0.050  43.009   7.371  1.00 24.23           O  
ATOM    148  CB  ASP A  21      -1.414  44.968   8.850  1.00 25.30           C  
ATOM    149  CG  ASP A  21      -0.827  44.753  10.241  1.00 26.33           C  
ATOM    150  OD1 ASP A  21       0.314  44.257  10.336  1.00 26.35           O  
ATOM    151  OD2 ASP A  21      -1.507  45.068  11.237  1.00 27.96           O  
ATOM    152  N   LYS A  22       1.847  44.350   7.536  1.00 27.95           N  
ATOM    153  CA  LYS A  22       2.821  43.294   7.281  1.00 32.08           C  
ATOM    154  C   LYS A  22       2.792  42.166   8.316  1.00 33.76           C  
ATOM    155  O   LYS A  22       2.832  40.986   7.959  1.00 33.33           O  
ATOM    156  CB  LYS A  22       4.222  43.912   7.223  1.00 34.92           C  
ATOM    157  CG  LYS A  22       5.369  42.940   6.962  1.00 39.19           C  
ATOM    158  CD  LYS A  22       6.700  43.687   7.071  1.00 43.44           C  
ATOM    159  CE  LYS A  22       7.902  42.814   6.732  1.00 45.31           C  
ATOM    160  NZ  LYS A  22       9.169  43.604   6.787  1.00 44.90           N  
ATOM    161  N   SER A  23       2.714  42.531   9.591  1.00 34.70           N  
ATOM    162  CA  SER A  23       2.711  41.551  10.674  1.00 36.20           C  
ATOM    163  C   SER A  23       1.520  40.591  10.697  1.00 35.65           C  
ATOM    164  O   SER A  23       1.671  39.428  11.060  1.00 35.63           O  
ATOM    165  CB  SER A  23       2.813  42.269  12.022  1.00 36.95           C  
ATOM    166  OG  SER A  23       1.678  43.080  12.251  1.00 39.74           O  
ATOM    167  N   LYS A  24       0.337  41.068  10.325  1.00 35.73           N  
ATOM    168  CA  LYS A  24      -0.843  40.205  10.319  1.00 36.07           C  
ATOM    169  C   LYS A  24      -1.271  39.837   8.905  1.00 34.67           C  
ATOM    170  O   LYS A  24      -2.272  39.143   8.718  1.00 33.63           O  
ATOM    171  CB  LYS A  24      -2.010  40.895  11.030  1.00 37.61           C  
ATOM    172  CG  LYS A  24      -1.887  40.932  12.538  1.00 39.88           C  
ATOM    173  CD  LYS A  24      -2.995  41.770  13.157  1.00 41.20           C  
ATOM    174  CE  LYS A  24      -2.943  41.721  14.675  1.00 41.57           C  
ATOM    175  NZ  LYS A  24      -3.150  40.333  15.173  1.00 42.72           N  
ATOM    176  N   ASP A  25      -0.490  40.285   7.926  1.00 33.07           N  
ATOM    177  CA  ASP A  25      -0.778  40.068   6.511  1.00 33.08           C  
ATOM    178  C   ASP A  25      -2.267  40.299   6.255  1.00 28.85           C  
ATOM    179  O   ASP A  25      -3.005  39.400   5.858  1.00 28.47           O  
ATOM    180  CB  ASP A  25      -0.349  38.664   6.048  1.00 39.20           C  
ATOM    181  CG  ASP A  25      -1.063  37.552   6.784  1.00 43.94           C  
ATOM    182  OD1 ASP A  25      -0.718  37.301   7.957  1.00 46.65           O  
ATOM    183  OD2 ASP A  25      -1.969  36.928   6.185  1.00 46.44           O  
ATOM    184  N   GLU A  26      -2.696  41.527   6.514  1.00 24.67           N  
ATOM    185  CA  GLU A  26      -4.086  41.925   6.325  1.00 23.01           C  
ATOM    186  C   GLU A  26      -4.144  43.305   5.690  1.00 19.69           C  
ATOM    187  O   GLU A  26      -3.163  44.047   5.709  1.00 19.10           O  
ATOM    188  CB  GLU A  26      -4.820  41.980   7.668  1.00 23.77           C  
ATOM    189  CG  GLU A  26      -4.925  40.656   8.399  1.00 25.85           C  
ATOM    190  CD  GLU A  26      -5.720  40.770   9.687  1.00 27.26           C  
ATOM    191  OE1 GLU A  26      -5.442  41.700  10.478  1.00 25.18           O  
ATOM    192  OE2 GLU A  26      -6.616  39.930   9.913  1.00 29.81           O  
ATOM    193  N   LEU A  27      -5.294  43.629   5.115  1.00 16.90           N  
ATOM    194  CA  LEU A  27      -5.514  44.942   4.512  1.00 16.59           C  
ATOM    195  C   LEU A  27      -6.615  45.560   5.364  1.00 15.00           C  
ATOM    196  O   LEU A  27      -7.726  45.036   5.433  1.00 14.14           O  
ATOM    197  CB  LEU A  27      -5.954  44.800   3.052  1.00 15.62           C  
ATOM    198  CG  LEU A  27      -4.889  44.224   2.117  1.00 17.74           C  
ATOM    199  CD1 LEU A  27      -5.434  44.168   0.695  1.00 19.83           C  
ATOM    200  CD2 LEU A  27      -3.631  45.088   2.173  1.00 19.75           C  
ATOM    201  N   ILE A  28      -6.287  46.670   6.015  1.00 16.85           N  
ATOM    202  CA  ILE A  28      -7.194  47.344   6.931  1.00 16.57           C  
ATOM    203  C   ILE A  28      -7.931  48.562   6.389  1.00 18.52           C  
ATOM    204  O   ILE A  28      -7.356  49.398   5.695  1.00 14.43           O  
ATOM    205  CB  ILE A  28      -6.420  47.791   8.201  1.00 19.87           C  
ATOM    206  CG1 ILE A  28      -5.727  46.584   8.836  1.00 20.65           C  
ATOM    207  CG2 ILE A  28      -7.371  48.454   9.218  1.00 16.81           C  
ATOM    208  CD1 ILE A  28      -4.843  46.934  10.032  1.00 21.84           C  
ATOM    209  N   CYS A  29      -9.218  48.653   6.704  1.00 18.50           N  
ATOM    210  CA  CYS A  29      -9.976  49.827   6.311  1.00 22.14           C  
ATOM    211  C   CYS A  29     -10.128  50.621   7.598  1.00 23.79           C  
ATOM    212  O   CYS A  29     -10.857  50.216   8.501  1.00 21.93           O  
ATOM    213  CB  CYS A  29     -11.361  49.489   5.779  1.00 20.96           C  
ATOM    214  SG  CYS A  29     -12.364  51.007   5.618  1.00 24.43           S  
ATOM    215  N   LYS A  30      -9.426  51.743   7.673  1.00 24.85           N  
ATOM    216  CA  LYS A  30      -9.457  52.593   8.851  1.00 30.35           C  
ATOM    217  C   LYS A  30     -10.870  53.086   9.160  1.00 30.78           C  
ATOM    218  O   LYS A  30     -11.366  52.909  10.272  1.00 31.63           O  
ATOM    219  CB  LYS A  30      -8.503  53.777   8.643  1.00 31.90           C  
ATOM    220  CG  LYS A  30      -8.450  54.792   9.773  1.00 36.84           C  
ATOM    221  CD  LYS A  30      -7.853  54.206  11.039  1.00 40.12           C  
ATOM    222  CE  LYS A  30      -7.674  55.279  12.108  1.00 41.65           C  
ATOM    223  NZ  LYS A  30      -6.730  56.352  11.681  1.00 43.09           N  
ATOM    224  N   GLY A  31     -11.514  53.686   8.164  1.00 31.68           N  
ATOM    225  CA  GLY A  31     -12.857  54.217   8.339  1.00 32.72           C  
ATOM    226  C   GLY A  31     -13.935  53.251   8.798  1.00 35.44           C  
ATOM    227  O   GLY A  31     -14.911  53.664   9.430  1.00 36.07           O  
ATOM    228  N   ASP A  32     -13.776  51.968   8.488  1.00 33.60           N  
ATOM    229  CA  ASP A  32     -14.761  50.967   8.885  1.00 30.70           C  
ATOM    230  C   ASP A  32     -14.258  50.061  10.004  1.00 29.54           C  
ATOM    231  O   ASP A  32     -15.008  49.240  10.525  1.00 27.65           O  
ATOM    232  CB  ASP A  32     -15.163  50.123   7.675  1.00 30.51           C  
ATOM    233  CG  ASP A  32     -16.214  50.803   6.815  1.00 32.92           C  
ATOM    234  OD1 ASP A  32     -16.211  50.583   5.588  1.00 30.14           O  
ATOM    235  OD2 ASP A  32     -17.056  51.543   7.365  1.00 30.63           O  
ATOM    236  N   ARG A  33     -12.989  50.217  10.366  1.00 29.35           N  
ATOM    237  CA  ARG A  33     -12.390  49.417  11.424  1.00 29.54           C  
ATOM    238  C   ARG A  33     -12.559  47.932  11.135  1.00 29.45           C  
ATOM    239  O   ARG A  33     -13.014  47.162  11.984  1.00 28.79           O  
ATOM    240  CB  ARG A  33     -13.024  49.772  12.767  1.00 30.36           C  
ATOM    241  N   LEU A  34     -12.184  47.544   9.922  1.00 27.62           N  
ATOM    242  CA  LEU A  34     -12.270  46.163   9.480  1.00 26.65           C  
ATOM    243  C   LEU A  34     -10.931  45.739   8.884  1.00 25.87           C  
ATOM    244  O   LEU A  34     -10.227  46.553   8.278  1.00 25.88           O  
ATOM    245  CB  LEU A  34     -13.359  46.015   8.412  1.00 26.35           C  
ATOM    246  CG  LEU A  34     -14.818  46.278   8.793  1.00 28.40           C  
ATOM    247  CD1 LEU A  34     -15.686  46.137   7.557  1.00 29.64           C  
ATOM    248  CD2 LEU A  34     -15.268  45.293   9.874  1.00 30.61           C  
ATOM    249  N   ALA A  35     -10.586  44.467   9.062  1.00 22.47           N  
ATOM    250  CA  ALA A  35      -9.345  43.924   8.518  1.00 22.76           C  
ATOM    251  C   ALA A  35      -9.692  42.776   7.580  1.00 23.38           C  
ATOM    252  O   ALA A  35     -10.356  41.817   7.979  1.00 24.99           O  
ATOM    253  CB  ALA A  35      -8.439  43.418   9.642  1.00 23.87           C  
ATOM    254  N   PHE A  36      -9.257  42.878   6.330  1.00 20.56           N  
ATOM    255  CA  PHE A  36      -9.515  41.830   5.358  1.00 21.14           C  
ATOM    256  C   PHE A  36      -8.285  40.948   5.281  1.00 19.83           C  
ATOM    257  O   PHE A  36      -7.160  41.431   5.324  1.00 20.09           O  
ATOM    258  CB  PHE A  36      -9.847  42.436   3.990  1.00 21.73           C  
ATOM    259  CG  PHE A  36     -11.094  43.257   4.003  1.00 24.52           C  
ATOM    260  CD1 PHE A  36     -11.080  44.549   4.518  1.00 22.11           C  
ATOM    261  CD2 PHE A  36     -12.306  42.715   3.584  1.00 22.80           C  
ATOM    262  CE1 PHE A  36     -12.251  45.285   4.623  1.00 23.12           C  
ATOM    263  CE2 PHE A  36     -13.483  43.444   3.687  1.00 25.00           C  
ATOM    264  CZ  PHE A  36     -13.457  44.731   4.208  1.00 23.69           C  
ATOM    265  N   PRO A  37      -8.487  39.633   5.173  1.00 20.23           N  
ATOM    266  CA  PRO A  37      -7.346  38.726   5.106  1.00 20.13           C  
ATOM    267  C   PRO A  37      -6.724  38.580   3.730  1.00 20.45           C  
ATOM    268  O   PRO A  37      -7.363  38.820   2.706  1.00 20.85           O  
ATOM    269  CB  PRO A  37      -7.934  37.416   5.604  1.00 20.33           C  
ATOM    270  CG  PRO A  37      -9.315  37.447   4.995  1.00 23.12           C  
ATOM    271  CD  PRO A  37      -9.761  38.890   5.221  1.00 20.28           C  
ATOM    272  N   ILE A  38      -5.462  38.182   3.730  1.00 21.88           N  
ATOM    273  CA  ILE A  38      -4.719  37.925   2.514  1.00 24.39           C  
ATOM    274  C   ILE A  38      -4.423  36.434   2.633  1.00 27.35           C  
ATOM    275  O   ILE A  38      -3.697  36.008   3.533  1.00 28.43           O  
ATOM    276  CB  ILE A  38      -3.407  38.734   2.475  1.00 25.38           C  
ATOM    277  CG1 ILE A  38      -3.728  40.239   2.503  1.00 22.57           C  
ATOM    278  CG2 ILE A  38      -2.604  38.370   1.214  1.00 24.94           C  
ATOM    279  CD1 ILE A  38      -2.501  41.131   2.667  1.00 23.81           C  
ATOM    280  N   LYS A  39      -5.024  35.639   1.757  1.00 27.86           N  
ATOM    281  CA  LYS A  39      -4.835  34.193   1.790  1.00 30.22           C  
ATOM    282  C   LYS A  39      -4.060  33.734   0.564  1.00 30.68           C  
ATOM    283  O   LYS A  39      -4.416  34.069  -0.561  1.00 30.17           O  
ATOM    284  CB  LYS A  39      -6.194  33.494   1.850  1.00 31.59           C  
ATOM    285  CG  LYS A  39      -7.008  33.858   3.089  1.00 33.77           C  
ATOM    286  CD  LYS A  39      -8.281  33.035   3.192  1.00 35.69           C  
ATOM    287  CE  LYS A  39      -9.072  33.413   4.437  1.00 36.18           C  
ATOM    288  NZ  LYS A  39     -10.286  32.571   4.608  1.00 37.84           N  
ATOM    289  N   ASP A  40      -2.994  32.974   0.785  1.00 32.42           N  
ATOM    290  CA  ASP A  40      -2.171  32.498  -0.322  1.00 34.91           C  
ATOM    291  C   ASP A  40      -1.724  33.698  -1.153  1.00 34.49           C  
ATOM    292  O   ASP A  40      -1.673  33.632  -2.375  1.00 36.46           O  
ATOM    293  CB  ASP A  40      -2.971  31.527  -1.194  1.00 34.18           C  
ATOM    294  N   GLY A  41      -1.415  34.800  -0.478  1.00 35.20           N  
ATOM    295  CA  GLY A  41      -0.982  36.000  -1.172  1.00 34.08           C  
ATOM    296  C   GLY A  41      -2.092  36.726  -1.914  1.00 32.46           C  
ATOM    297  O   GLY A  41      -1.820  37.629  -2.708  1.00 33.75           O  
ATOM    298  N   ILE A  42      -3.343  36.354  -1.651  1.00 30.06           N  
ATOM    299  CA  ILE A  42      -4.473  36.984  -2.322  1.00 27.38           C  
ATOM    300  C   ILE A  42      -5.417  37.736  -1.386  1.00 26.18           C  
ATOM    301  O   ILE A  42      -6.073  37.141  -0.535  1.00 22.24           O  
ATOM    302  CB  ILE A  42      -5.301  35.949  -3.104  1.00 30.60           C  
ATOM    303  CG1 ILE A  42      -4.431  35.320  -4.199  1.00 32.05           C  
ATOM    304  CG2 ILE A  42      -6.534  36.612  -3.713  1.00 28.21           C  
ATOM    305  CD1 ILE A  42      -5.146  34.282  -5.024  1.00 34.86           C  
ATOM    306  N   PRO A  43      -5.500  39.066  -1.543  1.00 25.37           N  
ATOM    307  CA  PRO A  43      -6.391  39.846  -0.679  1.00 24.48           C  
ATOM    308  C   PRO A  43      -7.842  39.418  -0.901  1.00 24.77           C  
ATOM    309  O   PRO A  43      -8.343  39.446  -2.030  1.00 21.97           O  
ATOM    310  CB  PRO A  43      -6.130  41.281  -1.125  1.00 25.72           C  
ATOM    311  CG  PRO A  43      -4.686  41.229  -1.570  1.00 27.08           C  
ATOM    312  CD  PRO A  43      -4.678  39.953  -2.382  1.00 23.89           C  
HETATM  313  N   MSE A  44      -8.508  39.013   0.176  1.00 23.05           N  
HETATM  314  CA  MSE A  44      -9.892  38.570   0.091  1.00 24.72           C  
HETATM  315  C   MSE A  44     -10.845  39.749   0.279  1.00 25.83           C  
HETATM  316  O   MSE A  44     -11.368  39.977   1.368  1.00 22.78           O  
HETATM  317  CB  MSE A  44     -10.156  37.499   1.152  1.00 28.98           C  
HETATM  318  CG  MSE A  44      -9.211  36.308   1.071  1.00 32.58           C  
HETATM  319 SE   MSE A  44      -9.262  35.423  -0.654  1.00 42.60          SE  
HETATM  320  CE  MSE A  44     -10.878  34.385  -0.429  1.00 37.64           C  
HETATM  321  N   MSE A  45     -11.074  40.486  -0.803  1.00 25.95           N  
HETATM  322  CA  MSE A  45     -11.938  41.657  -0.779  1.00 27.87           C  
HETATM  323  C   MSE A  45     -13.428  41.312  -0.730  1.00 26.60           C  
HETATM  324  O   MSE A  45     -14.168  41.585  -1.675  1.00 26.36           O  
HETATM  325  CB  MSE A  45     -11.649  42.519  -2.009  1.00 29.91           C  
HETATM  326  CG  MSE A  45     -10.197  42.924  -2.137  1.00 30.82           C  
HETATM  327 SE   MSE A  45      -9.668  44.169  -0.767  1.00 43.84          SE  
HETATM  328  CE  MSE A  45      -9.081  42.998   0.585  1.00 16.04           C  
ATOM    329  N   LEU A  46     -13.854  40.715   0.379  1.00 26.44           N  
ATOM    330  CA  LEU A  46     -15.244  40.327   0.583  1.00 26.82           C  
ATOM    331  C   LEU A  46     -15.674  40.699   1.994  1.00 26.50           C  
ATOM    332  O   LEU A  46     -14.978  40.403   2.951  1.00 24.33           O  
ATOM    333  CB  LEU A  46     -15.414  38.820   0.388  1.00 27.10           C  
ATOM    334  CG  LEU A  46     -15.347  38.292  -1.045  1.00 27.86           C  
ATOM    335  CD1 LEU A  46     -15.280  36.764  -1.025  1.00 28.23           C  
ATOM    336  CD2 LEU A  46     -16.564  38.785  -1.821  1.00 29.09           C  
ATOM    337  N   GLU A  47     -16.829  41.344   2.117  1.00 28.69           N  
ATOM    338  CA  GLU A  47     -17.334  41.750   3.421  1.00 29.56           C  
ATOM    339  C   GLU A  47     -17.394  40.566   4.393  1.00 28.88           C  
ATOM    340  O   GLU A  47     -17.022  40.687   5.559  1.00 28.19           O  
ATOM    341  CB  GLU A  47     -18.712  42.397   3.262  1.00 33.83           C  
ATOM    342  CG  GLU A  47     -19.408  42.725   4.569  1.00 38.63           C  
ATOM    343  CD  GLU A  47     -20.543  43.720   4.396  1.00 42.12           C  
ATOM    344  OE1 GLU A  47     -21.310  43.597   3.417  1.00 44.38           O  
ATOM    345  OE2 GLU A  47     -20.674  44.621   5.253  1.00 43.85           O  
ATOM    346  N   SER A  48     -17.837  39.418   3.898  1.00 26.80           N  
ATOM    347  CA  SER A  48     -17.942  38.209   4.712  1.00 26.40           C  
ATOM    348  C   SER A  48     -16.613  37.762   5.336  1.00 26.32           C  
ATOM    349  O   SER A  48     -16.599  37.110   6.380  1.00 24.39           O  
ATOM    350  CB  SER A  48     -18.493  37.068   3.859  1.00 26.57           C  
ATOM    351  OG  SER A  48     -17.617  36.792   2.778  1.00 26.92           O  
ATOM    352  N   GLU A  49     -15.503  38.106   4.683  1.00 25.44           N  
ATOM    353  CA  GLU A  49     -14.171  37.725   5.147  1.00 26.55           C  
ATOM    354  C   GLU A  49     -13.562  38.677   6.178  1.00 26.14           C  
ATOM    355  O   GLU A  49     -12.631  38.309   6.879  1.00 25.98           O  
ATOM    356  CB  GLU A  49     -13.217  37.627   3.947  1.00 28.63           C  
ATOM    357  CG  GLU A  49     -13.569  36.540   2.943  1.00 27.61           C  
ATOM    358  CD  GLU A  49     -13.043  35.178   3.350  1.00 30.79           C  
ATOM    359  OE1 GLU A  49     -13.329  34.191   2.636  1.00 29.84           O  
ATOM    360  OE2 GLU A  49     -12.338  35.093   4.377  1.00 29.74           O  
ATOM    361  N   ALA A  50     -14.090  39.893   6.265  1.00 29.23           N  
ATOM    362  CA  ALA A  50     -13.564  40.898   7.185  1.00 30.21           C  
ATOM    363  C   ALA A  50     -13.827  40.638   8.662  1.00 32.29           C  
ATOM    364  O   ALA A  50     -14.862  40.099   9.048  1.00 30.24           O  
ATOM    365  CB  ALA A  50     -14.103  42.269   6.810  1.00 30.55           C  
ATOM    366  N   ARG A  51     -12.869  41.038   9.486  1.00 34.36           N  
ATOM    367  CA  ARG A  51     -12.994  40.886  10.928  1.00 36.76           C  
ATOM    368  C   ARG A  51     -12.957  42.296  11.509  1.00 36.62           C  
ATOM    369  O   ARG A  51     -12.239  43.154  10.999  1.00 35.03           O  
ATOM    370  CB  ARG A  51     -11.820  40.085  11.485  1.00 37.86           C  
ATOM    371  CG  ARG A  51     -10.496  40.786  11.286  1.00 40.58           C  
ATOM    372  CD  ARG A  51      -9.404  40.256  12.192  1.00 43.60           C  
ATOM    373  NE  ARG A  51      -8.323  41.232  12.274  1.00 47.56           N  
ATOM    374  CZ  ARG A  51      -7.230  41.096  13.013  1.00 48.30           C  
ATOM    375  NH1 ARG A  51      -7.047  40.010  13.750  1.00 51.35           N  
ATOM    376  NH2 ARG A  51      -6.319  42.058  13.017  1.00 48.87           N  
ATOM    377  N   GLU A  52     -13.734  42.544  12.558  1.00 38.03           N  
ATOM    378  CA  GLU A  52     -13.734  43.857  13.195  1.00 39.54           C  
ATOM    379  C   GLU A  52     -12.440  43.980  13.990  1.00 39.14           C  
ATOM    380  O   GLU A  52     -11.962  42.987  14.537  1.00 37.29           O  
ATOM    381  CB  GLU A  52     -14.899  43.995  14.160  1.00 42.89           C  
ATOM    382  CG  GLU A  52     -16.256  43.946  13.522  1.00 47.59           C  
ATOM    383  CD  GLU A  52     -17.346  44.285  14.511  1.00 50.07           C  
ATOM    384  OE1 GLU A  52     -17.246  45.343  15.171  1.00 52.42           O  
ATOM    385  OE2 GLU A  52     -18.301  43.493  14.628  1.00 51.99           O  
ATOM    386  N   LEU A  53     -11.882  45.189  14.055  1.00 37.54           N  
ATOM    387  CA  LEU A  53     -10.641  45.432  14.786  1.00 38.96           C  
ATOM    388  C   LEU A  53     -10.912  45.501  16.282  1.00 40.20           C  
ATOM    389  O   LEU A  53     -12.010  45.864  16.721  1.00 37.57           O  
ATOM    390  CB  LEU A  53      -9.978  46.736  14.341  1.00 38.57           C  
ATOM    391  CG  LEU A  53      -9.538  46.933  12.893  1.00 39.25           C  
ATOM    392  CD1 LEU A  53      -9.013  48.344  12.792  1.00 37.02           C  
ATOM    393  CD2 LEU A  53      -8.519  45.881  12.449  1.00 37.48           C  
ATOM    394  N   ALA A  54      -9.929  45.075  17.064  1.00 42.55           N  
ATOM    395  CA  ALA A  54     -10.078  45.129  18.501  1.00 45.66           C  
ATOM    396  C   ALA A  54      -9.657  46.586  18.816  1.00 46.59           C  
ATOM    397  O   ALA A  54      -8.997  47.262  18.012  1.00 44.98           O  
ATOM    398  CB  ALA A  54      -9.138  44.144  19.156  1.00 45.17           C  
ATOM    399  N   PRO A  55     -10.039  47.102  19.983  1.00 48.88           N  
ATOM    400  CA  PRO A  55      -9.626  48.478  20.257  1.00 49.36           C  
ATOM    401  C   PRO A  55      -8.135  48.555  20.538  1.00 49.10           C  
ATOM    402  O   PRO A  55      -7.554  49.632  20.436  1.00 49.41           O  
ATOM    403  CB  PRO A  55     -10.468  48.893  21.468  1.00 49.92           C  
ATOM    404  CG  PRO A  55     -11.167  47.611  21.964  1.00 49.86           C  
ATOM    405  CD  PRO A  55     -10.623  46.449  21.162  1.00 49.19           C  
ATOM    406  N   GLU A  56      -7.535  47.415  20.885  1.00 49.76           N  
ATOM    407  CA  GLU A  56      -6.111  47.343  21.160  1.00 50.35           C  
ATOM    408  C   GLU A  56      -5.373  47.467  19.836  1.00 49.85           C  
ATOM    409  O   GLU A  56      -4.161  47.701  19.806  1.00 49.51           O  
ATOM    410  CB  GLU A  56      -5.776  46.011  21.831  1.00 51.26           C  
ATOM    411  CG  GLU A  56      -6.292  44.811  21.064  1.00 53.10           C  
ATOM    412  CD  GLU A  56      -6.617  43.637  21.955  1.00 53.59           C  
ATOM    413  OE1 GLU A  56      -5.694  42.848  22.258  1.00 53.85           O  
ATOM    414  OE2 GLU A  56      -7.801  43.508  22.348  1.00 54.69           O  
ATOM    415  N   GLU A  57      -6.115  47.309  18.743  1.00 49.42           N  
ATOM    416  CA  GLU A  57      -5.545  47.413  17.411  1.00 47.58           C  
ATOM    417  C   GLU A  57      -5.785  48.787  16.805  1.00 47.99           C  
ATOM    418  O   GLU A  57      -5.015  49.205  15.946  1.00 47.15           O  
ATOM    419  CB  GLU A  57      -6.140  46.359  16.482  1.00 46.64           C  
ATOM    420  CG  GLU A  57      -5.894  44.934  16.910  1.00 43.93           C  
ATOM    421  CD  GLU A  57      -6.415  43.939  15.892  1.00 43.60           C  
ATOM    422  OE1 GLU A  57      -5.664  43.604  14.948  1.00 42.03           O  
ATOM    423  OE2 GLU A  57      -7.580  43.509  16.034  1.00 41.58           O  
ATOM    424  N   GLU A  58      -6.855  49.470  17.208  1.00 48.77           N  
ATOM    425  CA  GLU A  58      -7.130  50.799  16.676  1.00 51.17           C  
ATOM    426  C   GLU A  58      -6.034  51.758  17.133  1.00 51.72           C  
ATOM    427  O   GLU A  58      -5.767  52.768  16.485  1.00 51.97           O  
ATOM    428  CB  GLU A  58      -8.498  51.288  17.158  1.00 52.56           C  
ATOM    429  CG  GLU A  58      -9.600  51.126  16.126  1.00 54.83           C  
ATOM    430  CD  GLU A  58     -10.969  51.477  16.662  1.00 56.97           C  
ATOM    431  OE1 GLU A  58     -11.630  50.584  17.231  1.00 58.39           O  
ATOM    432  OE2 GLU A  58     -11.376  52.648  16.518  1.00 58.25           O  
ATOM    433  N   VAL A  59      -5.385  51.424  18.246  1.00 52.18           N  
ATOM    434  CA  VAL A  59      -4.326  52.271  18.790  1.00 51.91           C  
ATOM    435  C   VAL A  59      -3.167  52.561  17.833  1.00 51.35           C  
ATOM    436  O   VAL A  59      -2.719  53.701  17.747  1.00 51.17           O  
ATOM    437  CB  VAL A  59      -3.727  51.689  20.113  1.00 52.28           C  
ATOM    438  CG1 VAL A  59      -4.820  51.486  21.137  1.00 52.70           C  
ATOM    439  CG2 VAL A  59      -3.007  50.383  19.847  1.00 52.94           C  
ATOM    440  N   LYS A  60      -2.684  51.552  17.106  1.00 50.98           N  
ATOM    441  CA  LYS A  60      -1.551  51.766  16.200  1.00 50.97           C  
ATOM    442  C   LYS A  60      -1.842  52.526  14.908  1.00 50.80           C  
ATOM    443  O   LYS A  60      -0.920  52.990  14.239  1.00 51.40           O  
ATOM    444  CB  LYS A  60      -0.868  50.438  15.857  1.00 51.70           C  
ATOM    445  CG  LYS A  60      -1.679  49.489  15.008  1.00 53.41           C  
ATOM    446  CD  LYS A  60      -0.841  48.275  14.660  1.00 53.63           C  
ATOM    447  CE  LYS A  60      -1.672  47.196  13.997  1.00 55.01           C  
ATOM    448  NZ  LYS A  60      -0.875  45.957  13.778  1.00 56.04           N  
ATOM    449  N   LEU A  61      -3.111  52.648  14.544  1.00 50.17           N  
ATOM    450  CA  LEU A  61      -3.464  53.389  13.342  1.00 49.44           C  
ATOM    451  C   LEU A  61      -3.765  54.794  13.837  1.00 49.76           C  
ATOM    452  O   LEU A  61      -4.063  55.701  13.056  1.00 50.49           O  
ATOM    453  CB  LEU A  61      -4.686  52.760  12.675  1.00 48.32           C  
ATOM    454  CG  LEU A  61      -4.507  51.260  12.404  1.00 47.27           C  
ATOM    455  CD1 LEU A  61      -5.818  50.647  11.953  1.00 46.90           C  
ATOM    456  CD2 LEU A  61      -3.422  51.052  11.360  1.00 47.80           C  
ATOM    457  N   GLU A  62      -3.660  54.939  15.161  1.00 49.89           N  
ATOM    458  CA  GLU A  62      -3.886  56.185  15.894  1.00 50.45           C  
ATOM    459  C   GLU A  62      -5.318  56.408  16.357  1.00 50.87           C  
ATOM    460  O   GLU A  62      -6.144  56.872  15.545  1.00 51.77           O  
ATOM    461  CB  GLU A  62      -3.396  57.387  15.087  1.00 49.60           C  
ATOM    462  CG  GLU A  62      -1.908  57.604  15.247  1.00 49.75           C  
ATOM    463  CD  GLU A  62      -1.331  58.520  14.197  1.00 51.18           C  
ATOM    464  OE1 GLU A  62      -1.762  59.692  14.113  1.00 50.13           O  
ATOM    465  OE2 GLU A  62      -0.441  58.054  13.455  1.00 51.76           O  
TER     466      GLU A  62                                                      
END
MOLECULE T0480.pdb
ATOM     43  N   PHE    20      -9.421  47.124  -2.332  1.00  0.00
ATOM     44  HN  PHE    20      -9.663  47.024  -3.278  1.00  0.00
ATOM     45  CA  PHE    20     -10.050  48.188  -1.549  1.00  0.00
ATOM     46  HA  PHE    20      -9.287  48.642  -0.932  1.00  0.00
ATOM     47  CB  PHE    20     -10.641  49.260  -2.478  1.00  0.00
ATOM     48  HB1 PHE    20     -11.197  49.974  -1.885  1.00  0.00
ATOM     49  HB2 PHE    20     -11.316  48.788  -3.178  1.00  0.00
ATOM     50  CG  PHE    20      -9.613  50.019  -3.274  1.00  0.00
ATOM     51  CD1 PHE    20      -9.119  49.504  -4.460  1.00  0.00
ATOM     52  HD1 PHE    20      -9.476  48.547  -4.813  1.00  0.00
ATOM     53  CD2 PHE    20      -9.145  51.251  -2.836  1.00  0.00
ATOM     54  HD2 PHE    20      -9.523  51.664  -1.912  1.00  0.00
ATOM     55  CE1 PHE    20      -8.180  50.199  -5.195  1.00  0.00
ATOM     56  HE1 PHE    20      -7.803  49.783  -6.119  1.00  0.00
ATOM     57  CE2 PHE    20      -8.206  51.949  -3.568  1.00  0.00
ATOM     58  HE2 PHE    20      -7.850  52.908  -3.217  1.00  0.00
ATOM     59  CZ  PHE    20      -7.722  51.422  -4.750  1.00  0.00
ATOM     60  HZ  PHE    20      -6.988  51.966  -5.326  1.00  0.00
ATOM     61  C   PHE    20     -11.149  47.641  -0.643  1.00  0.00
ATOM     62  O   PHE    20     -11.503  46.465  -0.706  1.00  0.00
ATOM     63  N   CYS    21     -11.685  48.510   0.204  1.00  0.00
ATOM     64  HN  CYS    21     -11.329  49.425   0.240  1.00  0.00
ATOM     65  CA  CYS    21     -12.801  48.155   1.067  1.00  0.00
ATOM     66  HA  CYS    21     -12.726  47.105   1.318  1.00  0.00
ATOM     67  HB1 CYS    21     -12.914  50.028   2.087  1.00  0.00
ATOM     68  HB2 CYS    21     -11.760  48.898   2.773  1.00  0.00
ATOM     69  C   CYS    21     -14.100  48.414   0.312  1.00  0.00
ATOM     70  O   CYS    21     -14.384  49.557  -0.023  1.00  0.00
ATOM     71  CB  CYS    21     -12.742  48.991   2.341  1.00  0.00
ATOM     72  SG  CYS    21     -13.954  48.528   3.619  1.00  0.00
ATOM     73  N   PRO    22     -14.916  47.367   0.073  1.00  0.00
ATOM     74  CA  PRO    22     -16.026  47.404  -0.893  1.00  0.00
ATOM     75  HA  PRO    22     -15.680  47.160  -1.889  1.00  0.00
ATOM     76  CB  PRO    22     -16.958  46.298  -0.401  1.00  0.00
ATOM     77  HB1 PRO    22     -17.462  45.846  -1.245  1.00  0.00
ATOM     78  HB2 PRO    22     -17.694  46.716   0.276  1.00  0.00
ATOM     79  CG  PRO    22     -16.074  45.316   0.294  1.00  0.00
ATOM     80  HG1 PRO    22     -15.795  44.526  -0.389  1.00  0.00
ATOM     81  HG2 PRO    22     -16.602  44.907   1.141  1.00  0.00
ATOM     82  CD  PRO    22     -14.843  46.065   0.763  1.00  0.00
ATOM     83  HD1 PRO    22     -13.945  45.532   0.486  1.00  0.00
ATOM     84  HD2 PRO    22     -14.875  46.204   1.835  1.00  0.00
ATOM     85  C   PRO    22     -16.770  48.741  -0.939  1.00  0.00
ATOM     86  O   PRO    22     -16.834  49.390  -1.988  1.00  0.00
ATOM     87  N   ARG    23     -17.316  49.158   0.201  1.00  0.00
ATOM     88  HN  ARG    23     -17.154  48.653   1.025  1.00  0.00
ATOM     89  CA  ARG    23     -18.164  50.344   0.238  1.00  0.00
ATOM     90  HA  ARG    23     -18.672  50.391  -0.712  1.00  0.00
ATOM     91  CB  ARG    23     -19.223  50.223   1.341  1.00  0.00
ATOM     92  HB1 ARG    23     -19.804  51.135   1.369  1.00  0.00
ATOM     93  HB2 ARG    23     -18.724  50.096   2.291  1.00  0.00
ATOM     94  CG  ARG    23     -20.180  49.050   1.141  1.00  0.00
ATOM     95  HG1 ARG    23     -19.642  48.129   1.321  1.00  0.00
ATOM     96  HG2 ARG    23     -20.538  49.061   0.121  1.00  0.00
ATOM     97  CD  ARG    23     -21.381  49.113   2.081  1.00  0.00
ATOM     98  HD1 ARG    23     -21.999  48.242   1.910  1.00  0.00
ATOM     99  HD2 ARG    23     -21.951  50.003   1.854  1.00  0.00
ATOM    100  NE  ARG    23     -20.991  49.150   3.495  1.00  0.00
ATOM    101  HE  ARG    23     -20.100  49.512   3.706  1.00  0.00
ATOM    102  CZ  ARG    23     -21.777  48.752   4.498  1.00  0.00
ATOM    103  NH1 ARG    23     -22.967  48.220   4.250  1.00  0.00
ATOM    104 HH11 ARG    23     -23.285  48.110   3.303  1.00  0.00
ATOM    105 HH12 ARG    23     -23.556  47.929   5.009  1.00  0.00
ATOM    106  NH2 ARG    23     -21.364  48.866   5.751  1.00  0.00
ATOM    107 HH21 ARG    23     -20.460  49.252   5.953  1.00  0.00
ATOM    108 HH22 ARG    23     -21.954  48.569   6.504  1.00  0.00
ATOM    109  C   ARG    23     -17.352  51.633   0.415  1.00  0.00
ATOM    110  O   ARG    23     -17.758  52.692  -0.062  1.00  0.00
ATOM    111  N   CYS    24     -16.206  51.549   1.092  1.00  0.00
ATOM    112  HN  CYS    24     -15.914  50.681   1.429  1.00  0.00
ATOM    113  CA  CYS    24     -15.370  52.739   1.328  1.00  0.00
ATOM    114  HA  CYS    24     -16.018  53.602   1.381  1.00  0.00
ATOM    115  HB1 CYS    24     -14.192  53.616   2.885  1.00  0.00
ATOM    116  HB2 CYS    24     -13.735  51.970   2.480  1.00  0.00
ATOM    117  C   CYS    24     -14.366  52.941   0.194  1.00  0.00
ATOM    118  O   CYS    24     -13.660  53.947   0.171  1.00  0.00
ATOM    119  CB  CYS    24     -14.572  52.634   2.635  1.00  0.00
ATOM    120  SG  CYS    24     -15.473  52.014   4.084  1.00  0.00
ATOM    121  N   GLY    25     -14.311  51.975  -0.727  1.00  0.00
ATOM    122  HN  GLY    25     -15.009  51.286  -0.729  1.00  0.00
ATOM    123  CA  GLY    25     -13.256  51.919  -1.735  1.00  0.00
ATOM    124  HA1 GLY    25     -13.576  51.268  -2.533  1.00  0.00
ATOM    125  HA2 GLY    25     -12.373  51.493  -1.282  1.00  0.00
ATOM    126  C   GLY    25     -12.895  53.274  -2.316  1.00  0.00
ATOM    127  O   GLY    25     -11.779  53.757  -2.106  1.00  0.00
ATOM    128  N   PRO    26     -13.818  53.919  -3.049  1.00  0.00
ATOM    129  CA  PRO    26     -13.599  55.269  -3.570  1.00  0.00
ATOM    130  HA  PRO    26     -12.703  55.315  -4.175  1.00  0.00
ATOM    131  CB  PRO    26     -14.836  55.536  -4.453  1.00  0.00
ATOM    132  HB1 PRO    26     -14.526  55.974  -5.391  1.00  0.00
ATOM    133  HB2 PRO    26     -15.511  56.212  -3.944  1.00  0.00
ATOM    134  CG  PRO    26     -15.466  54.197  -4.662  1.00  0.00
ATOM    135  HG1 PRO    26     -15.052  53.729  -5.546  1.00  0.00
ATOM    136  HG2 PRO    26     -16.537  54.305  -4.764  1.00  0.00
ATOM    137  CD  PRO    26     -15.135  53.389  -3.440  1.00  0.00
ATOM    138  HD1 PRO    26     -15.075  52.339  -3.684  1.00  0.00
ATOM    139  HD2 PRO    26     -15.868  53.560  -2.664  1.00  0.00
ATOM    140  C   PRO    26     -13.496  56.293  -2.437  1.00  0.00
ATOM    141  O   PRO    26     -14.508  56.823  -1.967  1.00  0.00
ATOM    142  N   GLY    27     -12.275  56.524  -1.966  1.00  0.00
ATOM    143  HN  GLY    27     -11.520  56.002  -2.319  1.00  0.00
ATOM    144  CA  GLY    27     -12.036  57.519  -0.932  1.00  0.00
ATOM    145  HA1 GLY    27     -12.982  57.935  -0.612  1.00  0.00
ATOM    146  HA2 GLY    27     -11.430  58.310  -1.348  1.00  0.00
ATOM    147  C   GLY    27     -11.325  56.943   0.273  1.00  0.00
ATOM    148  O   GLY    27     -10.653  57.668   1.009  1.00  0.00
ATOM    149  N   VAL    28     -11.468  55.634   0.479  1.00  0.00
ATOM    150  HN  VAL    28     -12.031  55.114  -0.136  1.00  0.00
ATOM    151  CA  VAL    28     -10.810  54.948   1.591  1.00  0.00
ATOM    152  HA  VAL    28     -10.018  55.586   1.960  1.00  0.00
ATOM    153  CB  VAL    28     -11.782  54.646   2.763  1.00  0.00
ATOM    154  HB  VAL    28     -12.477  53.886   2.424  1.00  0.00
ATOM    155  CG1 VAL    28     -11.028  54.082   3.968  1.00  0.00
ATOM    156 HG11 VAL    28     -10.300  54.803   4.309  1.00  0.00
ATOM    157 HG12 VAL    28     -10.525  53.168   3.687  1.00  0.00
ATOM    158 HG13 VAL    28     -11.728  53.875   4.766  1.00  0.00
ATOM    159  CG2 VAL    28     -12.588  55.883   3.159  1.00  0.00
ATOM    160 HG21 VAL    28     -11.917  56.666   3.482  1.00  0.00
ATOM    161 HG22 VAL    28     -13.260  55.632   3.967  1.00  0.00
ATOM    162 HG23 VAL    28     -13.162  56.229   2.311  1.00  0.00
ATOM    163  C   VAL    28     -10.205  53.631   1.123  1.00  0.00
ATOM    164  O   VAL    28     -10.910  52.621   0.993  1.00  0.00
ATOM    165  N   PHE    29      -8.907  53.645   0.861  1.00  0.00
ATOM    166  HN  PHE    29      -8.420  54.495   0.903  1.00  0.00
ATOM    167  CA  PHE    29      -8.190  52.430   0.504  1.00  0.00
ATOM    168  HA  PHE    29      -8.697  51.979  -0.339  1.00  0.00
ATOM    169  CB  PHE    29      -6.738  52.749   0.109  1.00  0.00
ATOM    170  HB1 PHE    29      -6.738  53.555  -0.613  1.00  0.00
ATOM    171  HB2 PHE    29      -6.296  51.872  -0.342  1.00  0.00
ATOM    172  CG  PHE    29      -5.864  53.166   1.270  1.00  0.00
ATOM    173  CD1 PHE    29      -4.909  52.298   1.788  1.00  0.00
ATOM    174  HD1 PHE    29      -4.786  51.319   1.348  1.00  0.00
ATOM    175  CD2 PHE    29      -6.003  54.418   1.850  1.00  0.00
ATOM    176  HD2 PHE    29      -6.739  55.104   1.458  1.00  0.00
ATOM    177  CE1 PHE    29      -4.116  52.673   2.857  1.00  0.00
ATOM    178  HE1 PHE    29      -3.377  51.988   3.249  1.00  0.00
ATOM    179  CE2 PHE    29      -5.211  54.796   2.917  1.00  0.00
ATOM    180  HE2 PHE    29      -5.331  55.775   3.358  1.00  0.00
ATOM    181  CZ  PHE    29      -4.268  53.924   3.421  1.00  0.00
ATOM    182  HZ  PHE    29      -3.650  54.219   4.258  1.00  0.00
ATOM    183  C   PHE    29      -8.210  51.449   1.679  1.00  0.00
ATOM    184  O   PHE    29      -8.458  51.838   2.825  1.00  0.00
ATOM    185  N   LEU    30      -7.958  50.182   1.396  1.00  0.00
ATOM    186  HN  LEU    30      -7.805  49.919   0.464  1.00  0.00
ATOM    187  CA  LEU    30      -7.868  49.176   2.441  1.00  0.00
ATOM    188  HA  LEU    30      -8.446  49.515   3.292  1.00  0.00
ATOM    189  CB  LEU    30      -8.437  47.841   1.939  1.00  0.00
ATOM    190  HB1 LEU    30      -7.762  47.449   1.190  1.00  0.00
ATOM    191  HB2 LEU    30      -9.389  48.040   1.467  1.00  0.00
ATOM    192  CG  LEU    30      -8.649  46.756   3.010  1.00  0.00
ATOM    193  HG  LEU    30      -7.705  46.559   3.499  1.00  0.00
ATOM    194  CD1 LEU    30      -9.637  47.226   4.075  1.00  0.00
ATOM    195 HD11 LEU    30     -10.591  47.443   3.615  1.00  0.00
ATOM    196 HD12 LEU    30      -9.257  48.119   4.550  1.00  0.00
ATOM    197 HD13 LEU    30      -9.765  46.452   4.819  1.00  0.00
ATOM    198  CD2 LEU    30      -9.129  45.452   2.368  1.00  0.00
ATOM    199 HD21 LEU    30     -10.068  45.622   1.859  1.00  0.00
ATOM    200 HD22 LEU    30      -9.268  44.701   3.133  1.00  0.00
ATOM    201 HD23 LEU    30      -8.392  45.106   1.657  1.00  0.00
ATOM    202  C   LEU    30      -6.405  49.037   2.850  1.00  0.00
ATOM    203  O   LEU    30      -5.581  48.585   2.055  1.00  0.00
ATOM    204  N   ALA    31      -6.089  49.469   4.074  1.00  0.00
ATOM    205  HN  ALA    31      -6.808  49.759   4.671  1.00  0.00
ATOM    206  CA  ALA    31      -4.708  49.517   4.560  1.00  0.00
ATOM    207  HA  ALA    31      -4.182  50.263   3.979  1.00  0.00
ATOM    208  CB  ALA    31      -4.674  49.953   6.023  1.00  0.00
ATOM    209  HB1 ALA    31      -3.648  50.043   6.352  1.00  0.00
ATOM    210  HB2 ALA    31      -5.182  49.219   6.631  1.00  0.00
ATOM    211  HB3 ALA    31      -5.167  50.908   6.126  1.00  0.00
ATOM    212  C   ALA    31      -4.007  48.174   4.380  1.00  0.00
ATOM    213  O   ALA    31      -4.101  47.290   5.237  1.00  0.00
ATOM    214  N   GLU    32      -3.331  48.023   3.246  1.00  0.00
ATOM    215  HN  GLU    32      -3.321  48.760   2.599  1.00  0.00
ATOM    216  CA  GLU    32      -2.625  46.794   2.922  1.00  0.00
ATOM    217  HA  GLU    32      -3.248  45.965   3.234  1.00  0.00
ATOM    218  CB  GLU    32      -2.386  46.686   1.408  1.00  0.00
ATOM    219  HB1 GLU    32      -1.814  47.543   1.083  1.00  0.00
ATOM    220  HB2 GLU    32      -3.342  46.691   0.903  1.00  0.00
ATOM    221  CG  GLU    32      -1.632  45.422   0.999  1.00  0.00
ATOM    222  HG1 GLU    32      -2.172  44.560   1.369  1.00  0.00
ATOM    223  HG2 GLU    32      -0.650  45.445   1.449  1.00  0.00
ATOM    224  CD  GLU    32      -1.467  45.287  -0.506  1.00  0.00
ATOM    225  OE1 GLU    32      -0.618  46.002  -1.079  1.00  0.00
ATOM    226  OE2 GLU    32      -2.171  44.448  -1.114  1.00  0.00
ATOM    227  C   GLU    32      -1.300  46.719   3.673  1.00  0.00
ATOM    228  O   GLU    32      -0.357  47.459   3.381  1.00  0.00
ATOM    229  N   HIS    33      -1.263  45.852   4.668  1.00  0.00
ATOM    230  HN  HIS    33      -2.089  45.388   4.911  1.00  0.00
ATOM    231  CA  HIS    33      -0.045  45.545   5.406  1.00  0.00
ATOM    232  HA  HIS    33       0.685  46.317   5.196  1.00  0.00
ATOM    233  CB  HIS    33      -0.317  45.503   6.914  1.00  0.00
ATOM    234  HB1 HIS    33       0.590  45.218   7.429  1.00  0.00
ATOM    235  HB2 HIS    33      -1.084  44.767   7.119  1.00  0.00
ATOM    236  CG  HIS    33      -0.772  46.815   7.476  1.00  0.00
ATOM    237  ND1 HIS    33       0.097  47.768   7.958  1.00  0.00
ATOM    238  HD1 HIS    33       1.077  47.689   7.991  1.00  0.00
ATOM    239  CD2 HIS    33      -2.014  47.330   7.633  1.00  0.00
ATOM    240  HD2 HIS    33      -2.944  46.851   7.362  1.00  0.00
ATOM    241  CE1 HIS    33      -0.589  48.809   8.385  1.00  0.00
ATOM    242  HE1 HIS    33      -0.169  49.705   8.818  1.00  0.00
ATOM    243  NE2 HIS    33      -1.873  48.572   8.199  1.00  0.00
ATOM    244  HE2 HIS    33      -2.599  49.075   8.631  1.00  0.00
ATOM    245  C   HIS    33       0.506  44.203   4.940  1.00  0.00
ATOM    246  O   HIS    33      -0.225  43.393   4.365  1.00  0.00
ATOM    247  N   ALA    34       1.782  43.964   5.214  1.00  0.00
ATOM    248  HN  ALA    34       2.282  44.621   5.746  1.00  0.00
ATOM    249  CA  ALA    34       2.468  42.759   4.751  1.00  0.00
ATOM    250  HA  ALA    34       2.479  42.779   3.670  1.00  0.00
ATOM    251  CB  ALA    34       3.914  42.763   5.235  1.00  0.00
ATOM    252  HB1 ALA    34       4.434  41.909   4.826  1.00  0.00
ATOM    253  HB2 ALA    34       3.936  42.714   6.315  1.00  0.00
ATOM    254  HB3 ALA    34       4.401  43.670   4.907  1.00  0.00
ATOM    255  C   ALA    34       1.761  41.481   5.206  1.00  0.00
ATOM    256  O   ALA    34       1.850  40.444   4.543  1.00  0.00
ATOM    257  N   ASP    35       1.049  41.561   6.329  1.00  0.00
ATOM    258  HN  ASP    35       0.954  42.428   6.773  1.00  0.00
ATOM    259  CA  ASP    35       0.416  40.383   6.923  1.00  0.00
ATOM    260  HA  ASP    35       0.770  39.510   6.392  1.00  0.00
ATOM    261  CB  ASP    35       0.816  40.251   8.399  1.00  0.00
ATOM    262  HB1 ASP    35       1.883  40.394   8.487  1.00  0.00
ATOM    263  HB2 ASP    35       0.565  39.258   8.747  1.00  0.00
ATOM    264  CG  ASP    35       0.122  41.266   9.293  1.00  0.00
ATOM    265  OD1 ASP    35       0.449  42.468   9.202  1.00  0.00
ATOM    266  OD2 ASP    35      -0.746  40.867  10.097  1.00  0.00
ATOM    267  C   ASP    35      -1.111  40.429   6.812  1.00  0.00
ATOM    268  O   ASP    35      -1.773  39.400   6.966  1.00  0.00
ATOM    269  N   ARG    36      -1.682  41.598   6.521  1.00  0.00
ATOM    270  HN  ARG    36      -1.122  42.366   6.270  1.00  0.00
ATOM    271  CA  ARG    36      -3.142  41.736   6.533  1.00  0.00
ATOM    272  HA  ARG    36      -3.550  40.949   5.917  1.00  0.00
ATOM    273  CB  ARG    36      -3.678  41.570   7.966  1.00  0.00
ATOM    274  HB1 ARG    36      -3.315  40.633   8.368  1.00  0.00
ATOM    275  HB2 ARG    36      -4.759  41.538   7.933  1.00  0.00
ATOM    276  CG  ARG    36      -3.264  42.690   8.914  1.00  0.00
ATOM    277  HG1 ARG    36      -3.731  43.611   8.594  1.00  0.00
ATOM    278  HG2 ARG    36      -2.190  42.797   8.873  1.00  0.00
ATOM    279  CD  ARG    36      -3.677  42.398  10.353  1.00  0.00
ATOM    280  HD1 ARG    36      -3.114  41.546  10.712  1.00  0.00
ATOM    281  HD2 ARG    36      -4.732  42.162  10.370  1.00  0.00
ATOM    282  NE  ARG    36      -3.436  43.539  11.239  1.00  0.00
ATOM    283  HE  ARG    36      -4.165  44.194  11.330  1.00  0.00
ATOM    284  CZ  ARG    36      -2.321  43.724  11.948  1.00  0.00
ATOM    285  NH1 ARG    36      -1.289  42.903  11.808  1.00  0.00
ATOM    286 HH11 ARG    36      -1.337  42.131  11.163  1.00  0.00
ATOM    287 HH12 ARG    36      -0.455  43.046  12.347  1.00  0.00
ATOM    288  NH2 ARG    36      -2.225  44.752  12.777  1.00  0.00
ATOM    289 HH21 ARG    36      -2.992  45.396  12.878  1.00  0.00
ATOM    290 HH22 ARG    36      -1.390  44.887  13.317  1.00  0.00
ATOM    291  C   ARG    36      -3.592  43.080   5.962  1.00  0.00
ATOM    292  O   ARG    36      -2.805  43.816   5.384  1.00  0.00
ATOM    293  N   TYR    37      -4.876  43.366   6.135  1.00  0.00
ATOM    294  HN  TYR    37      -5.429  42.719   6.609  1.00  0.00
ATOM    295  CA  TYR    37      -5.508  44.603   5.686  1.00  0.00
ATOM    296  HA  TYR    37      -4.743  45.306   5.387  1.00  0.00
ATOM    297  CB  TYR    37      -6.477  44.347   4.519  1.00  0.00
ATOM    298  HB1 TYR    37      -6.833  45.302   4.155  1.00  0.00
ATOM    299  HB2 TYR    37      -7.322  43.784   4.887  1.00  0.00
ATOM    300  CG  TYR    37      -5.912  43.586   3.333  1.00  0.00
ATOM    301  CD1 TYR    37      -5.992  42.198   3.273  1.00  0.00
ATOM    302  HD1 TYR    37      -6.438  41.661   4.097  1.00  0.00
ATOM    303  CD2 TYR    37      -5.335  44.256   2.258  1.00  0.00
ATOM    304  HD2 TYR    37      -5.265  45.334   2.286  1.00  0.00
ATOM    305  CE1 TYR    37      -5.512  41.502   2.183  1.00  0.00
ATOM    306  HE1 TYR    37      -5.586  40.425   2.155  1.00  0.00
ATOM    307  CE2 TYR    37      -4.849  43.564   1.166  1.00  0.00
ATOM    308  HE2 TYR    37      -4.402  44.101   0.342  1.00  0.00
ATOM    309  CZ  TYR    37      -4.942  42.190   1.133  1.00  0.00
ATOM    310  OH  TYR    37      -4.459  41.497   0.046  1.00  0.00
ATOM    311  HH  TYR    37      -5.120  40.864  -0.251  1.00  0.00
ATOM    312  C   TYR    37      -6.322  45.182   6.841  1.00  0.00
ATOM    313  O   TYR    37      -6.679  44.453   7.767  1.00  0.00
ATOM    314  N   SER    38      -6.636  46.471   6.777  1.00  0.00
ATOM    315  HN  SER    38      -6.247  47.026   6.068  1.00  0.00
ATOM    316  CA  SER    38      -7.535  47.084   7.751  1.00  0.00
ATOM    317  HA  SER    38      -8.327  46.375   7.956  1.00  0.00
ATOM    318  CB  SER    38      -6.797  47.393   9.060  1.00  0.00
ATOM    319  HB1 SER    38      -6.130  48.229   8.911  1.00  0.00
ATOM    320  HB2 SER    38      -6.225  46.527   9.362  1.00  0.00
ATOM    321  OG  SER    38      -7.714  47.715  10.094  1.00  0.00
ATOM    322  HG  SER    38      -8.082  46.897  10.459  1.00  0.00
ATOM    323  C   SER    38      -8.166  48.351   7.170  1.00  0.00
ATOM    324  O   SER    38      -7.687  48.894   6.172  1.00  0.00
ATOM    325  N   CYS    39      -9.256  48.806   7.780  1.00  0.00
ATOM    326  HN  CYS    39      -9.589  48.331   8.573  1.00  0.00
ATOM    327  CA  CYS    39      -9.980  49.978   7.296  1.00  0.00
ATOM    328  HA  CYS    39      -9.347  50.504   6.596  1.00  0.00
ATOM    329  HB1 CYS    39     -11.825  48.903   7.229  1.00  0.00
ATOM    330  HB2 CYS    39     -10.986  48.989   5.693  1.00  0.00
ATOM    331  C   CYS    39     -10.341  50.922   8.431  1.00  0.00
ATOM    332  O   CYS    39     -11.402  50.776   9.049  1.00  0.00
ATOM    333  CB  CYS    39     -11.253  49.545   6.574  1.00  0.00
ATOM    334  SG  CYS    39     -12.344  50.914   6.050  1.00  0.00
ATOM    335  N   GLY    40      -9.454  51.877   8.706  1.00  0.00
ATOM    336  HN  GLY    40      -8.584  51.868   8.253  1.00  0.00
ATOM    337  CA  GLY    40      -9.742  52.916   9.678  1.00  0.00
ATOM    338  HA1 GLY    40      -8.854  53.512   9.830  1.00  0.00
ATOM    339  HA2 GLY    40     -10.020  52.456  10.616  1.00  0.00
ATOM    340  C   GLY    40     -10.870  53.818   9.213  1.00  0.00
ATOM    341  O   GLY    40     -10.634  54.923   8.718  1.00  0.00
ATOM    342  N   ARG    41     -12.095  53.327   9.360  1.00  0.00
ATOM    343  HN  ARG    41     -12.200  52.466   9.822  1.00  0.00
ATOM    344  CA  ARG    41     -13.289  54.031   8.907  1.00  0.00
ATOM    345  HA  ARG    41     -13.318  54.990   9.406  1.00  0.00
ATOM    346  CB  ARG    41     -13.252  54.250   7.384  1.00  0.00
ATOM    347  HB1 ARG    41     -13.317  53.288   6.892  1.00  0.00
ATOM    348  HB2 ARG    41     -12.308  54.710   7.123  1.00  0.00
ATOM    349  CG  ARG    41     -14.378  55.137   6.858  1.00  0.00
ATOM    350  HG1 ARG    41     -15.326  54.721   7.169  1.00  0.00
ATOM    351  HG2 ARG    41     -14.332  55.156   5.778  1.00  0.00
ATOM    352  CD  ARG    41     -14.270  56.568   7.379  1.00  0.00
ATOM    353  HD1 ARG    41     -13.379  57.024   6.966  1.00  0.00
ATOM    354  HD2 ARG    41     -14.193  56.542   8.456  1.00  0.00
ATOM    355  NE  ARG    41     -15.434  57.375   7.008  1.00  0.00
ATOM    356  HE  ARG    41     -16.316  57.040   7.290  1.00  0.00
ATOM    357  CZ  ARG    41     -15.372  58.529   6.339  1.00  0.00
ATOM    358  NH1 ARG    41     -14.206  59.004   5.921  1.00  0.00
ATOM    359 HH11 ARG    41     -13.359  58.498   6.105  1.00  0.00
ATOM    360 HH12 ARG    41     -14.164  59.872   5.417  1.00  0.00
ATOM    361  NH2 ARG    41     -16.485  59.200   6.077  1.00  0.00
ATOM    362 HH21 ARG    41     -17.372  58.843   6.382  1.00  0.00
ATOM    363 HH22 ARG    41     -16.447  60.068   5.571  1.00  0.00
ATOM    364  C   ARG    41     -14.536  53.232   9.294  1.00  0.00
ATOM    365  O   ARG    41     -15.460  53.767   9.905  1.00  0.00
ATOM    366  N   CYS    42     -14.550  51.941   8.946  1.00  0.00
ATOM    367  HN  CYS    42     -13.788  51.572   8.462  1.00  0.00
ATOM    368  CA  CYS    42     -15.680  51.066   9.290  1.00  0.00
ATOM    369  HA  CYS    42     -16.324  51.612   9.967  1.00  0.00
ATOM    370  HB1 CYS    42     -16.667  51.558   7.443  1.00  0.00
ATOM    371  HB2 CYS    42     -17.452  50.281   8.357  1.00  0.00
ATOM    372  C   CYS    42     -15.190  49.810  10.010  1.00  0.00
ATOM    373  O   CYS    42     -15.972  48.902  10.291  1.00  0.00
ATOM    374  CB  CYS    42     -16.497  50.676   8.042  1.00  0.00
ATOM    375  SG  CYS    42     -15.721  49.422   6.967  1.00  0.00
ATOM    376  N   GLY    43     -13.886  49.755  10.293  1.00  0.00
ATOM    377  HN  GLY    43     -13.292  50.472   9.984  1.00  0.00
ATOM    378  CA  GLY    43     -13.333  48.655  11.068  1.00  0.00
ATOM    379  HA1 GLY    43     -13.985  48.453  11.906  1.00  0.00
ATOM    380  HA2 GLY    43     -12.365  48.951  11.446  1.00  0.00
ATOM    381  C   GLY    43     -13.167  47.383  10.264  1.00  0.00
ATOM    382  O   GLY    43     -12.919  46.319  10.828  1.00  0.00
ATOM    383  N   TYR    44     -13.292  47.490   8.943  1.00  0.00
ATOM    384  HN  TYR    44     -13.474  48.365   8.552  1.00  0.00
ATOM    385  CA  TYR    44     -13.151  46.329   8.071  1.00  0.00
ATOM    386  HA  TYR    44     -13.761  45.533   8.480  1.00  0.00
ATOM    387  CB  TYR    44     -13.634  46.650   6.644  1.00  0.00
ATOM    388  HB1 TYR    44     -12.949  47.348   6.181  1.00  0.00
ATOM    389  HB2 TYR    44     -14.613  47.103   6.698  1.00  0.00
ATOM    390  CG  TYR    44     -13.736  45.430   5.742  1.00  0.00
ATOM    391  CD1 TYR    44     -14.898  44.664   5.711  1.00  0.00
ATOM    392  HD1 TYR    44     -15.731  44.949   6.336  1.00  0.00
ATOM    393  CD2 TYR    44     -12.675  45.043   4.926  1.00  0.00
ATOM    394  HD2 TYR    44     -11.765  45.625   4.936  1.00  0.00
ATOM    395  CE1 TYR    44     -14.999  43.553   4.896  1.00  0.00
ATOM    396  HE1 TYR    44     -15.910  42.972   4.888  1.00  0.00
ATOM    397  CE2 TYR    44     -12.772  43.932   4.110  1.00  0.00
ATOM    398  HE2 TYR    44     -11.937  43.647   3.485  1.00  0.00
ATOM    399  CZ  TYR    44     -13.935  43.191   4.098  1.00  0.00
ATOM    400  OH  TYR    44     -14.035  42.084   3.285  1.00  0.00
ATOM    401  HH  TYR    44     -13.267  41.512   3.421  1.00  0.00
ATOM    402  C   TYR    44     -11.692  45.874   8.052  1.00  0.00
ATOM    403  O   TYR    44     -10.820  46.586   7.541  1.00  0.00
ATOM    404  N   THR    45     -11.440  44.710   8.635  1.00  0.00
ATOM    405  HN  THR    45     -12.181  44.224   9.056  1.00  0.00
ATOM    406  CA  THR    45     -10.111  44.123   8.690  1.00  0.00
ATOM    407  HA  THR    45      -9.436  44.742   8.108  1.00  0.00
ATOM    408  CB  THR    45      -9.598  44.072  10.151  1.00  0.00
ATOM    409  HB  THR    45     -10.307  43.509  10.743  1.00  0.00
ATOM    410  OG1 THR    45      -9.513  45.405  10.682  1.00  0.00
ATOM    411  HG1 THR    45     -10.178  45.513  11.373  1.00  0.00
ATOM    412  CG2 THR    45      -8.233  43.392  10.251  1.00  0.00
ATOM    413 HG21 THR    45      -7.903  43.395  11.280  1.00  0.00
ATOM    414 HG22 THR    45      -7.517  43.926   9.643  1.00  0.00
ATOM    415 HG23 THR    45      -8.311  42.372   9.903  1.00  0.00
ATOM    416  C   THR    45     -10.144  42.717   8.091  1.00  0.00
ATOM    417  O   THR    45     -11.064  41.940   8.359  1.00  0.00
ATOM    418  N   GLU    46      -9.150  42.411   7.270  1.00  0.00
ATOM    419  HN  GLU    46      -8.432  43.068   7.132  1.00  0.00
ATOM    420  CA  GLU    46      -9.061  41.127   6.581  1.00  0.00
ATOM    421  HA  GLU    46      -9.638  40.397   7.131  1.00  0.00
ATOM    422  CB  GLU    46      -9.617  41.256   5.152  1.00  0.00
ATOM    423  HB1 GLU    46      -9.027  41.987   4.614  1.00  0.00
ATOM    424  HB2 GLU    46     -10.638  41.607   5.206  1.00  0.00
ATOM    425  CG  GLU    46      -9.603  39.953   4.359  1.00  0.00
ATOM    426  HG1 GLU    46      -8.586  39.589   4.310  1.00  0.00
ATOM    427  HG2 GLU    46      -9.958  40.150   3.356  1.00  0.00
ATOM    428  CD  GLU    46     -10.477  38.876   4.981  1.00  0.00
ATOM    429  OE1 GLU    46      -9.978  38.115   5.835  1.00  0.00
ATOM    430  OE2 GLU    46     -11.665  38.779   4.610  1.00  0.00
ATOM    431  C   GLU    46      -7.603  40.695   6.546  1.00  0.00
ATOM    432  O   GLU    46      -6.725  41.538   6.470  1.00  0.00
ATOM    433  N   PHE    47      -7.333  39.399   6.601  1.00  0.00
ATOM    434  HN  PHE    47      -8.072  38.749   6.586  1.00  0.00
ATOM    435  CA  PHE    47      -5.950  38.917   6.656  1.00  0.00
ATOM    436  HA  PHE    47      -5.338  39.722   7.041  1.00  0.00
ATOM    437  CB  PHE    47      -5.833  37.719   7.606  1.00  0.00
ATOM    438  HB1 PHE    47      -4.848  37.284   7.507  1.00  0.00
ATOM    439  HB2 PHE    47      -6.574  36.980   7.337  1.00  0.00
ATOM    440  CG  PHE    47      -6.037  38.084   9.055  1.00  0.00
ATOM    441  CD1 PHE    47      -7.275  37.931   9.663  1.00  0.00
ATOM    442  HD1 PHE    47      -8.103  37.536   9.090  1.00  0.00
ATOM    443  CD2 PHE    47      -4.984  38.591   9.806  1.00  0.00
ATOM    444  HD2 PHE    47      -4.014  38.715   9.342  1.00  0.00
ATOM    445  CE1 PHE    47      -7.457  38.275  10.989  1.00  0.00
ATOM    446  HE1 PHE    47      -8.426  38.151  11.451  1.00  0.00
ATOM    447  CE2 PHE    47      -5.163  38.934  11.133  1.00  0.00
ATOM    448  HE2 PHE    47      -4.336  39.325  11.707  1.00  0.00
ATOM    449  CZ  PHE    47      -6.400  38.776  11.724  1.00  0.00
ATOM    450  HZ  PHE    47      -6.542  39.045  12.761  1.00  0.00
ATOM    451  C   PHE    47      -5.431  38.540   5.273  1.00  0.00
ATOM    452  O   PHE    47      -6.207  38.197   4.380  1.00  0.00
ATOM    453  N   LYS    48      -4.109  38.631   5.098  1.00  0.00
ATOM    454  HN  LYS    48      -3.558  39.035   5.806  1.00  0.00
ATOM    455  CA  LYS    48      -3.461  38.123   3.891  1.00  0.00
ATOM    456  HA  LYS    48      -3.984  38.527   3.032  1.00  0.00
ATOM    457  CB  LYS    48      -1.979  38.548   3.833  1.00  0.00
ATOM    458  HB1 LYS    48      -1.467  37.928   3.110  1.00  0.00
ATOM    459  HB2 LYS    48      -1.536  38.381   4.805  1.00  0.00
ATOM    460  CG  LYS    48      -1.748  40.015   3.454  1.00  0.00
ATOM    461  HG1 LYS    48      -0.734  40.287   3.714  1.00  0.00
ATOM    462  HG2 LYS    48      -2.437  40.634   4.012  1.00  0.00
ATOM    463  CD  LYS    48      -1.962  40.267   1.960  1.00  0.00
ATOM    464  HD1 LYS    48      -3.004  40.099   1.722  1.00  0.00
ATOM    465  HD2 LYS    48      -1.349  39.578   1.398  1.00  0.00
ATOM    466  CE  LYS    48      -1.588  41.694   1.562  1.00  0.00
ATOM    467  HE1 LYS    48      -0.547  41.862   1.800  1.00  0.00
ATOM    468  HE2 LYS    48      -2.200  42.386   2.122  1.00  0.00
ATOM    469  NZ  LYS    48      -1.795  41.935   0.107  1.00  0.00
ATOM    470  HZ1 LYS    48      -1.136  41.354  -0.450  1.00  0.00
ATOM    471  HZ2 LYS    48      -1.634  42.936  -0.124  1.00  0.00
ATOM    472  HZ3 LYS    48      -2.767  41.683  -0.163  1.00  0.00
ATOM    473  C   LYS    48      -3.585  36.600   3.875  1.00  0.00
ATOM    474  O   LYS    48      -2.753  35.890   4.447  1.00  0.00
END
