
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   36 (  585),  selected   36 , name 1k81_A
# Molecule2: number of CA atoms   29 (  432),  selected   29 , name T0480.pdb
# PARAMETERS: 1k81_A.T0480.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    V   108_A      -       -           -
LGA    I   109_A      F      20          3.945
LGA    C   110_A      C      21          2.376
LGA    R   111_A      P      22          2.824
LGA    E   112_A      R      23          1.414
LGA    C   113_A      C      24          1.170
LGA    -       -      G      25           -
LGA    G   114_A      P      26          3.588
LGA    K   115_A      G      27          1.002
LGA    P   116_A      V      28          1.240
LGA    D   117_A      F      29          3.585
LGA    T   118_A      L      30          3.279
LGA    K   119_A      A      31          2.036
LGA    I   120_A      E      32          2.391
LGA    I   121_A      H      33          2.307
LGA    K   122_A      A      34          2.468
LGA    E   123_A      -       -           -
LGA    G   124_A      -       -           -
LGA    R   125_A      -       -           -
LGA    V   126_A      -       -           -
LGA    H   127_A      D      35          1.699
LGA    L   128_A      R      36          0.747
LGA    L   129_A      Y      37          0.807
LGA    K   130_A      S      38          1.095
LGA    C   131_A      C      39          1.900
LGA    M   132_A      G      40          2.276
LGA    A   133_A      R      41          1.804
LGA    C   134_A      C      42          1.751
LGA    G   135_A      G      43          1.431
LGA    A   136_A      Y      44          0.884
LGA    I   137_A      T      45          0.723
LGA    R   138_A      E      46          0.494
LGA    P   139_A      F      47          1.194
LGA    I   140_A      K      48          1.634
LGA    R   141_A      -       -           -
LGA    M   142_A      -       -           -
LGA    I   143_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   36   29    5.0     28    2.08    17.86     84.503     1.285

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.284271 * X  +  -0.755134 * Y  +   0.590730 * Z  + -11.061368
  Y_new =   0.410203 * X  +  -0.461109 * Y  +  -0.786837 * Z  +  43.766415
  Z_new =   0.866559 * X  +   0.465994 * Y  +   0.178678 * Z  +  -0.627384 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.204651   -1.936942  [ DEG:    69.0214   -110.9786 ]
  Theta =  -1.048265   -2.093328  [ DEG:   -60.0612   -119.9388 ]
  Phi   =   0.964784   -2.176809  [ DEG:    55.2780   -124.7220 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1k81_A                                        
REMARK     2: T0480.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1k81_A.T0480.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   36   29   5.0   28   2.08   17.86  84.503
REMARK  ---------------------------------------------------------- 
MOLECULE 1k81_A
HEADER    TRANSLATION                             22-OCT-01   1K81              
TITLE     NMR STRUCTURE OF THE ZINC-RIBBON DOMAIN WITHIN TRANSLATION            
TITLE    2 INITIATION FACTOR 2 SUBUNIT BETA                                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROBABLE TRANSLATION INITIATION FACTOR 2 BETA              
COMPND   3 SUBUNIT;                                                             
COMPND   4 CHAIN: A;                                                            
COMPND   5 SYNONYM: EIF-2-BETA;                                                 
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: METHANOCOCCUS JANNASCHII;                       
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET14B                                    
KEYWDS    TRANSLATION INITIATION FACTOR, ZINC RIBBON                            
EXPDTA    NMR, 10 STRUCTURES                                                    
AUTHOR    S.CHO,D.W.HOFFMAN                                                     
REVDAT   2   16-OCT-02 1K81    1       JRNL                                     
REVDAT   1   24-APR-02 1K81    0                                                
JRNL        AUTH   S.CHO,D.W.HOFFMAN                                            
JRNL        TITL   STRUCTURE OF THE BETA SUBUNIT OF TRANSLATION                 
JRNL        TITL 2 INITIATION FACTOR 2 FROM THE ARCHAEON                        
JRNL        TITL 3 METHANOCOCCUS JANNASCHII: A REPRESENTATIVE OF THE            
JRNL        TITL 4 EIF2BETA/EIF5 FAMILY OF PROTEINS                             
JRNL        REF    BIOCHEMISTRY                  V.  41  5730 2002              
JRNL        REFN   ASTM BICHAW  US ISSN 0006-2960                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1K81 A  108   143  UNP    Q57562   IF2B_METJA     108    143             
SEQRES   1 A   36  VAL ILE CYS ARG GLU CYS GLY LYS PRO ASP THR LYS ILE          
SEQRES   2 A   36  ILE LYS GLU GLY ARG VAL HIS LEU LEU LYS CYS MET ALA          
SEQRES   3 A   36  CYS GLY ALA ILE ARG PRO ILE ARG MET ILE                      
HET     ZN  A 144       1                                                       
HETNAM      ZN ZINC ION                                                         
FORMUL   2   ZN    ZN 2+                                                        
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   VAL A 108     -13.869  46.961  -5.614  1.00  0.00           N  
ATOM      2  CA  VAL A 108     -14.032  45.527  -5.450  1.00  0.00           C  
ATOM      3  C   VAL A 108     -13.900  45.113  -3.981  1.00  0.00           C  
ATOM      4  O   VAL A 108     -14.788  44.463  -3.429  1.00  0.00           O  
ATOM      5  CB  VAL A 108     -12.974  44.799  -6.307  1.00  0.00           C  
ATOM      6  CG1 VAL A 108     -12.464  43.530  -5.630  1.00  0.00           C  
ATOM      7  CG2 VAL A 108     -13.536  44.484  -7.685  1.00  0.00           C  
ATOM      8  H   VAL A 108     -13.243  47.285  -6.296  1.00  0.00           H  
ATOM      9  HA  VAL A 108     -15.011  45.253  -5.811  1.00  0.00           H  
ATOM     10  HB  VAL A 108     -12.137  45.477  -6.435  1.00  0.00           H  
ATOM     11 HG11 VAL A 108     -11.749  43.792  -4.865  1.00  0.00           H  
ATOM     12 HG12 VAL A 108     -11.990  42.898  -6.365  1.00  0.00           H  
ATOM     13 HG13 VAL A 108     -13.295  43.003  -5.184  1.00  0.00           H  
ATOM     14 HG21 VAL A 108     -12.833  43.869  -8.228  1.00  0.00           H  
ATOM     15 HG22 VAL A 108     -13.701  45.405  -8.225  1.00  0.00           H  
ATOM     16 HG23 VAL A 108     -14.471  43.955  -7.580  1.00  0.00           H  
ATOM     17  N   ILE A 109     -12.789  45.493  -3.360  1.00  0.00           N  
ATOM     18  CA  ILE A 109     -12.542  45.158  -1.961  1.00  0.00           C  
ATOM     19  C   ILE A 109     -13.536  45.840  -1.050  1.00  0.00           C  
ATOM     20  O   ILE A 109     -14.153  45.223  -0.181  1.00  0.00           O  
ATOM     21  CB  ILE A 109     -11.110  45.533  -1.529  1.00  0.00           C  
ATOM     22  CG1 ILE A 109     -10.088  44.951  -2.508  1.00  0.00           C  
ATOM     23  CG2 ILE A 109     -10.836  45.041  -0.115  1.00  0.00           C  
ATOM     24  CD1 ILE A 109      -8.844  45.799  -2.657  1.00  0.00           C  
ATOM     25  H   ILE A 109     -12.117  46.007  -3.853  1.00  0.00           H  
ATOM     26  HA  ILE A 109     -12.663  44.120  -1.856  1.00  0.00           H  
ATOM     27  HB  ILE A 109     -11.029  46.609  -1.532  1.00  0.00           H  
ATOM     28 HG12 ILE A 109      -9.784  43.975  -2.160  1.00  0.00           H  
ATOM     29 HG13 ILE A 109     -10.545  44.853  -3.481  1.00  0.00           H  
ATOM     30 HG21 ILE A 109     -11.135  44.007  -0.028  1.00  0.00           H  
ATOM     31 HG22 ILE A 109     -11.397  45.639   0.589  1.00  0.00           H  
ATOM     32 HG23 ILE A 109      -9.781  45.130   0.099  1.00  0.00           H  
ATOM     33 HD11 ILE A 109      -8.925  46.401  -3.550  1.00  0.00           H  
ATOM     34 HD12 ILE A 109      -7.979  45.157  -2.733  1.00  0.00           H  
ATOM     35 HD13 ILE A 109      -8.742  46.443  -1.797  1.00  0.00           H  
ATOM     36  N   CYS A 110     -13.668  47.113  -1.271  1.00  0.00           N  
ATOM     37  CA  CYS A 110     -14.575  47.955  -0.501  1.00  0.00           C  
ATOM     38  C   CYS A 110     -15.436  48.813  -1.427  1.00  0.00           C  
ATOM     39  O   CYS A 110     -14.990  49.846  -1.924  1.00  0.00           O  
ATOM     40  CB  CYS A 110     -13.781  48.843   0.464  1.00  0.00           C  
ATOM     41  SG  CYS A 110     -13.864  48.299   2.203  1.00  0.00           S  
ATOM     42  H   CYS A 110     -13.133  47.497  -1.984  1.00  0.00           H  
ATOM     43  HA  CYS A 110     -15.223  47.307   0.070  1.00  0.00           H  
ATOM     44  HB2 CYS A 110     -12.744  48.840   0.169  1.00  0.00           H  
ATOM     45  HB3 CYS A 110     -14.162  49.851   0.413  1.00  0.00           H  
ATOM     46  N   ARG A 111     -16.670  48.371  -1.655  1.00  0.00           N  
ATOM     47  CA  ARG A 111     -17.594  49.093  -2.526  1.00  0.00           C  
ATOM     48  C   ARG A 111     -18.428  50.097  -1.736  1.00  0.00           C  
ATOM     49  O   ARG A 111     -18.772  51.165  -2.244  1.00  0.00           O  
ATOM     50  CB  ARG A 111     -18.512  48.110  -3.256  1.00  0.00           C  
ATOM     51  CG  ARG A 111     -19.196  47.113  -2.336  1.00  0.00           C  
ATOM     52  CD  ARG A 111     -18.542  45.743  -2.410  1.00  0.00           C  
ATOM     53  NE  ARG A 111     -19.262  44.749  -1.617  1.00  0.00           N  
ATOM     54  CZ  ARG A 111     -20.384  44.154  -2.016  1.00  0.00           C  
ATOM     55  NH1 ARG A 111     -20.917  44.449  -3.195  1.00  0.00           N  
ATOM     56  NH2 ARG A 111     -20.974  43.262  -1.233  1.00  0.00           N  
ATOM     57  H   ARG A 111     -16.966  47.538  -1.232  1.00  0.00           H  
ATOM     58  HA  ARG A 111     -17.005  49.630  -3.256  1.00  0.00           H  
ATOM     59  HB2 ARG A 111     -19.276  48.670  -3.776  1.00  0.00           H  
ATOM     60  HB3 ARG A 111     -17.928  47.560  -3.979  1.00  0.00           H  
ATOM     61  HG2 ARG A 111     -19.136  47.474  -1.320  1.00  0.00           H  
ATOM     62  HG3 ARG A 111     -20.234  47.023  -2.624  1.00  0.00           H  
ATOM     63  HD2 ARG A 111     -18.525  45.423  -3.442  1.00  0.00           H  
ATOM     64  HD3 ARG A 111     -17.530  45.820  -2.041  1.00  0.00           H  
ATOM     65  HE  ARG A 111     -18.890  44.513  -0.741  1.00  0.00           H  
ATOM     66 HH11 ARG A 111     -20.477  45.121  -3.791  1.00  0.00           H  
ATOM     67 HH12 ARG A 111     -21.759  43.998  -3.489  1.00  0.00           H  
ATOM     68 HH21 ARG A 111     -20.577  43.035  -0.344  1.00  0.00           H  
ATOM     69 HH22 ARG A 111     -21.818  42.815  -1.532  1.00  0.00           H  
ATOM     70  N   GLU A 112     -18.750  49.751  -0.494  1.00  0.00           N  
ATOM     71  CA  GLU A 112     -19.544  50.628   0.360  1.00  0.00           C  
ATOM     72  C   GLU A 112     -18.644  51.452   1.274  1.00  0.00           C  
ATOM     73  O   GLU A 112     -18.999  51.743   2.416  1.00  0.00           O  
ATOM     74  CB  GLU A 112     -20.528  49.808   1.198  1.00  0.00           C  
ATOM     75  CG  GLU A 112     -21.879  50.483   1.383  1.00  0.00           C  
ATOM     76  CD  GLU A 112     -22.931  49.540   1.929  1.00  0.00           C  
ATOM     77  OE1 GLU A 112     -22.611  48.764   2.852  1.00  0.00           O  
ATOM     78  OE2 GLU A 112     -24.078  49.579   1.432  1.00  0.00           O  
ATOM     79  H   GLU A 112     -18.447  48.887  -0.143  1.00  0.00           H  
ATOM     80  HA  GLU A 112     -20.100  51.298  -0.279  1.00  0.00           H  
ATOM     81  HB2 GLU A 112     -20.689  48.855   0.714  1.00  0.00           H  
ATOM     82  HB3 GLU A 112     -20.098  49.638   2.174  1.00  0.00           H  
ATOM     83  HG2 GLU A 112     -21.763  51.307   2.070  1.00  0.00           H  
ATOM     84  HG3 GLU A 112     -22.212  50.858   0.426  1.00  0.00           H  
ATOM     85  N   CYS A 113     -17.475  51.821   0.762  1.00  0.00           N  
ATOM     86  CA  CYS A 113     -16.515  52.606   1.526  1.00  0.00           C  
ATOM     87  C   CYS A 113     -16.287  53.972   0.881  1.00  0.00           C  
ATOM     88  O   CYS A 113     -15.986  54.949   1.567  1.00  0.00           O  
ATOM     89  CB  CYS A 113     -15.195  51.844   1.635  1.00  0.00           C  
ATOM     90  SG  CYS A 113     -14.389  51.958   3.266  1.00  0.00           S  
ATOM     91  H   CYS A 113     -17.249  51.553  -0.152  1.00  0.00           H  
ATOM     92  HA  CYS A 113     -16.919  52.750   2.517  1.00  0.00           H  
ATOM     93  HB2 CYS A 113     -15.380  50.798   1.438  1.00  0.00           H  
ATOM     94  HB3 CYS A 113     -14.505  52.225   0.896  1.00  0.00           H  
ATOM     95  N   GLY A 114     -16.438  54.034  -0.440  1.00  0.00           N  
ATOM     96  CA  GLY A 114     -16.249  55.287  -1.152  1.00  0.00           C  
ATOM     97  C   GLY A 114     -14.787  55.635  -1.343  1.00  0.00           C  
ATOM     98  O   GLY A 114     -14.058  54.929  -2.041  1.00  0.00           O  
ATOM     99  H   GLY A 114     -16.681  53.225  -0.935  1.00  0.00           H  
ATOM    100  HA2 GLY A 114     -16.718  55.209  -2.122  1.00  0.00           H  
ATOM    101  HA3 GLY A 114     -16.727  56.078  -0.596  1.00  0.00           H  
ATOM    102  N   LYS A 115     -14.354  56.727  -0.718  1.00  0.00           N  
ATOM    103  CA  LYS A 115     -12.969  57.171  -0.817  1.00  0.00           C  
ATOM    104  C   LYS A 115     -12.311  57.185   0.561  1.00  0.00           C  
ATOM    105  O   LYS A 115     -12.221  58.230   1.206  1.00  0.00           O  
ATOM    106  CB  LYS A 115     -12.897  58.564  -1.445  1.00  0.00           C  
ATOM    107  CG  LYS A 115     -13.220  58.578  -2.930  1.00  0.00           C  
ATOM    108  CD  LYS A 115     -11.959  58.481  -3.777  1.00  0.00           C  
ATOM    109  CE  LYS A 115     -11.764  59.719  -4.640  1.00  0.00           C  
ATOM    110  NZ  LYS A 115     -10.677  60.595  -4.117  1.00  0.00           N  
ATOM    111  H   LYS A 115     -14.984  57.245  -0.175  1.00  0.00           H  
ATOM    112  HA  LYS A 115     -12.439  56.472  -1.448  1.00  0.00           H  
ATOM    113  HB2 LYS A 115     -13.600  59.210  -0.939  1.00  0.00           H  
ATOM    114  HB3 LYS A 115     -11.900  58.957  -1.310  1.00  0.00           H  
ATOM    115  HG2 LYS A 115     -13.859  57.739  -3.158  1.00  0.00           H  
ATOM    116  HG3 LYS A 115     -13.733  59.500  -3.168  1.00  0.00           H  
ATOM    117  HD2 LYS A 115     -11.105  58.372  -3.126  1.00  0.00           H  
ATOM    118  HD3 LYS A 115     -12.037  57.615  -4.419  1.00  0.00           H  
ATOM    119  HE2 LYS A 115     -11.510  59.406  -5.643  1.00  0.00           H  
ATOM    120  HE3 LYS A 115     -12.687  60.278  -4.661  1.00  0.00           H  
ATOM    121  HZ1 LYS A 115      -9.794  60.416  -4.637  1.00  0.00           H  
ATOM    122  HZ2 LYS A 115     -10.517  60.403  -3.108  1.00  0.00           H  
ATOM    123  HZ3 LYS A 115     -10.940  61.594  -4.232  1.00  0.00           H  
ATOM    124  N   PRO A 116     -11.852  56.015   1.036  1.00  0.00           N  
ATOM    125  CA  PRO A 116     -11.217  55.860   2.326  1.00  0.00           C  
ATOM    126  C   PRO A 116      -9.697  55.782   2.201  1.00  0.00           C  
ATOM    127  O   PRO A 116      -9.112  56.379   1.298  1.00  0.00           O  
ATOM    128  CB  PRO A 116     -11.808  54.523   2.774  1.00  0.00           C  
ATOM    129  CG  PRO A 116     -11.982  53.735   1.507  1.00  0.00           C  
ATOM    130  CD  PRO A 116     -11.921  54.718   0.359  1.00  0.00           C  
ATOM    131  HA  PRO A 116     -11.497  56.641   3.018  1.00  0.00           H  
ATOM    132  HB2 PRO A 116     -11.134  54.031   3.453  1.00  0.00           H  
ATOM    133  HB3 PRO A 116     -12.757  54.692   3.260  1.00  0.00           H  
ATOM    134  HG2 PRO A 116     -11.187  53.011   1.418  1.00  0.00           H  
ATOM    135  HG3 PRO A 116     -12.939  53.237   1.517  1.00  0.00           H  
ATOM    136  HD2 PRO A 116     -11.032  54.547  -0.230  1.00  0.00           H  
ATOM    137  HD3 PRO A 116     -12.803  54.643  -0.253  1.00  0.00           H  
ATOM    138  N   ASP A 117      -9.063  55.034   3.097  1.00  0.00           N  
ATOM    139  CA  ASP A 117      -7.612  54.873   3.064  1.00  0.00           C  
ATOM    140  C   ASP A 117      -7.248  53.401   3.175  1.00  0.00           C  
ATOM    141  O   ASP A 117      -8.000  52.619   3.761  1.00  0.00           O  
ATOM    142  CB  ASP A 117      -6.958  55.659   4.201  1.00  0.00           C  
ATOM    143  CG  ASP A 117      -6.415  56.997   3.743  1.00  0.00           C  
ATOM    144  OD1 ASP A 117      -7.204  57.961   3.656  1.00  0.00           O  
ATOM    145  OD2 ASP A 117      -5.199  57.082   3.470  1.00  0.00           O  
ATOM    146  H   ASP A 117      -9.579  54.572   3.787  1.00  0.00           H  
ATOM    147  HA  ASP A 117      -7.255  55.253   2.118  1.00  0.00           H  
ATOM    148  HB2 ASP A 117      -7.691  55.835   4.975  1.00  0.00           H  
ATOM    149  HB3 ASP A 117      -6.143  55.079   4.609  1.00  0.00           H  
ATOM    150  N   THR A 118      -6.104  53.010   2.626  1.00  0.00           N  
ATOM    151  CA  THR A 118      -5.690  51.613   2.700  1.00  0.00           C  
ATOM    152  C   THR A 118      -4.284  51.479   3.274  1.00  0.00           C  
ATOM    153  O   THR A 118      -3.350  52.149   2.835  1.00  0.00           O  
ATOM    154  CB  THR A 118      -5.735  50.994   1.302  1.00  0.00           C  
ATOM    155  OG1 THR A 118      -5.047  49.755   1.279  1.00  0.00           O  
ATOM    156  CG2 THR A 118      -5.127  51.879   0.233  1.00  0.00           C  
ATOM    157  H   THR A 118      -5.533  53.664   2.172  1.00  0.00           H  
ATOM    158  HA  THR A 118      -6.383  51.092   3.340  1.00  0.00           H  
ATOM    159  HB  THR A 118      -6.766  50.814   1.034  1.00  0.00           H  
ATOM    160  HG1 THR A 118      -4.102  49.913   1.349  1.00  0.00           H  
ATOM    161 HG21 THR A 118      -5.915  52.324  -0.356  1.00  0.00           H  
ATOM    162 HG22 THR A 118      -4.491  51.285  -0.407  1.00  0.00           H  
ATOM    163 HG23 THR A 118      -4.543  52.658   0.699  1.00  0.00           H  
ATOM    164  N   LYS A 119      -4.143  50.571   4.233  1.00  0.00           N  
ATOM    165  CA  LYS A 119      -2.858  50.308   4.870  1.00  0.00           C  
ATOM    166  C   LYS A 119      -2.612  48.804   4.932  1.00  0.00           C  
ATOM    167  O   LYS A 119      -3.499  48.041   5.317  1.00  0.00           O  
ATOM    168  CB  LYS A 119      -2.892  50.864   6.294  1.00  0.00           C  
ATOM    169  CG  LYS A 119      -3.319  52.320   6.371  1.00  0.00           C  
ATOM    170  CD  LYS A 119      -2.230  53.249   5.859  1.00  0.00           C  
ATOM    171  CE  LYS A 119      -2.039  54.446   6.779  1.00  0.00           C  
ATOM    172  NZ  LYS A 119      -0.714  55.093   6.581  1.00  0.00           N  
ATOM    173  H   LYS A 119      -4.930  50.063   4.524  1.00  0.00           H  
ATOM    174  HA  LYS A 119      -2.075  50.791   4.304  1.00  0.00           H  
ATOM    175  HB2 LYS A 119      -3.585  50.276   6.880  1.00  0.00           H  
ATOM    176  HB3 LYS A 119      -1.906  50.777   6.727  1.00  0.00           H  
ATOM    177  HG2 LYS A 119      -4.206  52.457   5.768  1.00  0.00           H  
ATOM    178  HG3 LYS A 119      -3.539  52.567   7.399  1.00  0.00           H  
ATOM    179  HD2 LYS A 119      -1.300  52.702   5.802  1.00  0.00           H  
ATOM    180  HD3 LYS A 119      -2.503  53.602   4.875  1.00  0.00           H  
ATOM    181  HE2 LYS A 119      -2.817  55.166   6.576  1.00  0.00           H  
ATOM    182  HE3 LYS A 119      -2.118  54.111   7.804  1.00  0.00           H  
ATOM    183  HZ1 LYS A 119      -0.039  54.412   6.180  1.00  0.00           H  
ATOM    184  HZ2 LYS A 119      -0.345  55.438   7.490  1.00  0.00           H  
ATOM    185  HZ3 LYS A 119      -0.805  55.900   5.929  1.00  0.00           H  
ATOM    186  N   ILE A 120      -1.389  48.383   4.632  1.00  0.00           N  
ATOM    187  CA  ILE A 120      -1.043  46.967   4.707  1.00  0.00           C  
ATOM    188  C   ILE A 120       0.220  46.766   5.539  1.00  0.00           C  
ATOM    189  O   ILE A 120       1.222  47.456   5.344  1.00  0.00           O  
ATOM    190  CB  ILE A 120      -0.793  46.415   3.287  1.00  0.00           C  
ATOM    191  CG1 ILE A 120      -0.511  44.913   3.340  1.00  0.00           C  
ATOM    192  CG2 ILE A 120       0.357  47.155   2.619  1.00  0.00           C  
ATOM    193  CD1 ILE A 120      -1.065  44.150   2.157  1.00  0.00           C  
ATOM    194  H   ILE A 120      -0.701  49.034   4.382  1.00  0.00           H  
ATOM    195  HA  ILE A 120      -1.864  46.429   5.153  1.00  0.00           H  
ATOM    196  HB  ILE A 120      -1.684  46.585   2.701  1.00  0.00           H  
ATOM    197 HG12 ILE A 120       0.557  44.755   3.365  1.00  0.00           H  
ATOM    198 HG13 ILE A 120      -0.949  44.502   4.238  1.00  0.00           H  
ATOM    199 HG21 ILE A 120       0.137  47.291   1.571  1.00  0.00           H  
ATOM    200 HG22 ILE A 120       1.265  46.578   2.724  1.00  0.00           H  
ATOM    201 HG23 ILE A 120       0.488  48.119   3.088  1.00  0.00           H  
ATOM    202 HD11 ILE A 120      -1.619  43.293   2.510  1.00  0.00           H  
ATOM    203 HD12 ILE A 120      -0.251  43.819   1.529  1.00  0.00           H  
ATOM    204 HD13 ILE A 120      -1.720  44.794   1.589  1.00  0.00           H  
ATOM    205  N   ILE A 121       0.196  45.762   6.411  1.00  0.00           N  
ATOM    206  CA  ILE A 121       1.355  45.439   7.236  1.00  0.00           C  
ATOM    207  C   ILE A 121       1.668  43.949   7.152  1.00  0.00           C  
ATOM    208  O   ILE A 121       0.771  43.114   7.279  1.00  0.00           O  
ATOM    209  CB  ILE A 121       1.060  45.788   8.708  1.00  0.00           C  
ATOM    210  CG1 ILE A 121      -0.180  45.036   9.200  1.00  0.00           C  
ATOM    211  CG2 ILE A 121       0.874  47.290   8.867  1.00  0.00           C  
ATOM    212  CD1 ILE A 121       0.134  43.946  10.203  1.00  0.00           C  
ATOM    213  H   ILE A 121      -0.614  45.214   6.486  1.00  0.00           H  
ATOM    214  HA  ILE A 121       2.204  46.014   6.898  1.00  0.00           H  
ATOM    215  HB  ILE A 121       1.912  45.492   9.302  1.00  0.00           H  
ATOM    216 HG12 ILE A 121      -0.856  45.734   9.672  1.00  0.00           H  
ATOM    217 HG13 ILE A 121      -0.675  44.577   8.355  1.00  0.00           H  
ATOM    218 HG21 ILE A 121      -0.180  47.525   8.864  1.00  0.00           H  
ATOM    219 HG22 ILE A 121       1.360  47.801   8.049  1.00  0.00           H  
ATOM    220 HG23 ILE A 121       1.312  47.610   9.801  1.00  0.00           H  
ATOM    221 HD11 ILE A 121      -0.667  43.224  10.212  1.00  0.00           H  
ATOM    222 HD12 ILE A 121       0.239  44.382  11.185  1.00  0.00           H  
ATOM    223 HD13 ILE A 121       1.057  43.457   9.925  1.00  0.00           H  
ATOM    224  N   LYS A 122       2.946  43.609   7.027  1.00  0.00           N  
ATOM    225  CA  LYS A 122       3.353  42.209   6.988  1.00  0.00           C  
ATOM    226  C   LYS A 122       4.459  41.946   8.007  1.00  0.00           C  
ATOM    227  O   LYS A 122       5.431  42.697   8.089  1.00  0.00           O  
ATOM    228  CB  LYS A 122       3.865  41.888   5.579  1.00  0.00           C  
ATOM    229  CG  LYS A 122       4.567  40.541   5.470  1.00  0.00           C  
ATOM    230  CD  LYS A 122       5.132  40.319   4.075  1.00  0.00           C  
ATOM    231  CE  LYS A 122       6.209  39.245   4.074  1.00  0.00           C  
ATOM    232  NZ  LYS A 122       7.323  39.578   3.144  1.00  0.00           N  
ATOM    233  H   LYS A 122       3.629  44.312   6.988  1.00  0.00           H  
ATOM    234  HA  LYS A 122       2.497  41.592   7.212  1.00  0.00           H  
ATOM    235  HB2 LYS A 122       3.029  41.887   4.897  1.00  0.00           H  
ATOM    236  HB3 LYS A 122       4.562  42.656   5.280  1.00  0.00           H  
ATOM    237  HG2 LYS A 122       5.377  40.508   6.183  1.00  0.00           H  
ATOM    238  HG3 LYS A 122       3.858  39.756   5.693  1.00  0.00           H  
ATOM    239  HD2 LYS A 122       4.333  40.011   3.418  1.00  0.00           H  
ATOM    240  HD3 LYS A 122       5.557  41.245   3.720  1.00  0.00           H  
ATOM    241  HE2 LYS A 122       6.604  39.150   5.074  1.00  0.00           H  
ATOM    242  HE3 LYS A 122       5.766  38.308   3.772  1.00  0.00           H  
ATOM    243  HZ1 LYS A 122       8.230  39.260   3.543  1.00  0.00           H  
ATOM    244  HZ2 LYS A 122       7.367  40.605   2.991  1.00  0.00           H  
ATOM    245  HZ3 LYS A 122       7.176  39.108   2.228  1.00  0.00           H  
ATOM    246  N   GLU A 123       4.341  40.835   8.725  1.00  0.00           N  
ATOM    247  CA  GLU A 123       5.358  40.447   9.702  1.00  0.00           C  
ATOM    248  C   GLU A 123       5.745  38.994   9.468  1.00  0.00           C  
ATOM    249  O   GLU A 123       4.870  38.144   9.303  1.00  0.00           O  
ATOM    250  CB  GLU A 123       4.774  40.594  11.108  1.00  0.00           C  
ATOM    251  CG  GLU A 123       5.141  41.904  11.785  1.00  0.00           C  
ATOM    252  CD  GLU A 123       4.026  42.930  11.717  1.00  0.00           C  
ATOM    253  OE1 GLU A 123       3.051  42.798  12.486  1.00  0.00           O  
ATOM    254  OE2 GLU A 123       4.128  43.863  10.893  1.00  0.00           O  
ATOM    255  H   GLU A 123       3.563  40.250   8.581  1.00  0.00           H  
ATOM    256  HA  GLU A 123       6.221  41.084   9.591  1.00  0.00           H  
ATOM    257  HB2 GLU A 123       3.696  40.535  11.047  1.00  0.00           H  
ATOM    258  HB3 GLU A 123       5.135  39.783  11.725  1.00  0.00           H  
ATOM    259  HG2 GLU A 123       5.366  41.708  12.823  1.00  0.00           H  
ATOM    260  HG3 GLU A 123       6.016  42.313  11.300  1.00  0.00           H  
ATOM    261  N   GLY A 124       7.030  38.680   9.514  1.00  0.00           N  
ATOM    262  CA  GLY A 124       7.448  37.299   9.330  1.00  0.00           C  
ATOM    263  C   GLY A 124       7.007  36.722   7.986  1.00  0.00           C  
ATOM    264  O   GLY A 124       7.687  36.907   6.977  1.00  0.00           O  
ATOM    265  H   GLY A 124       7.695  39.378   9.697  1.00  0.00           H  
ATOM    266  HA2 GLY A 124       8.525  37.250   9.391  1.00  0.00           H  
ATOM    267  HA3 GLY A 124       7.026  36.698  10.121  1.00  0.00           H  
ATOM    268  N   ARG A 125       5.872  36.014   7.974  1.00  0.00           N  
ATOM    269  CA  ARG A 125       5.358  35.404   6.741  1.00  0.00           C  
ATOM    270  C   ARG A 125       3.825  35.414   6.700  1.00  0.00           C  
ATOM    271  O   ARG A 125       3.197  34.484   6.197  1.00  0.00           O  
ATOM    272  CB  ARG A 125       5.870  33.966   6.605  1.00  0.00           C  
ATOM    273  CG  ARG A 125       5.905  33.203   7.919  1.00  0.00           C  
ATOM    274  CD  ARG A 125       7.287  33.243   8.550  1.00  0.00           C  
ATOM    275  NE  ARG A 125       7.237  33.042   9.996  1.00  0.00           N  
ATOM    276  CZ  ARG A 125       7.121  31.850  10.576  1.00  0.00           C  
ATOM    277  NH1 ARG A 125       7.039  30.750   9.837  1.00  0.00           N  
ATOM    278  NH2 ARG A 125       7.086  31.756  11.897  1.00  0.00           N  
ATOM    279  H   ARG A 125       5.375  35.893   8.810  1.00  0.00           H  
ATOM    280  HA  ARG A 125       5.729  35.984   5.909  1.00  0.00           H  
ATOM    281  HB2 ARG A 125       5.228  33.432   5.921  1.00  0.00           H  
ATOM    282  HB3 ARG A 125       6.871  33.992   6.201  1.00  0.00           H  
ATOM    283  HG2 ARG A 125       5.196  33.649   8.603  1.00  0.00           H  
ATOM    284  HG3 ARG A 125       5.632  32.173   7.735  1.00  0.00           H  
ATOM    285  HD2 ARG A 125       7.893  32.465   8.109  1.00  0.00           H  
ATOM    286  HD3 ARG A 125       7.734  34.205   8.345  1.00  0.00           H  
ATOM    287  HE  ARG A 125       7.294  33.838  10.565  1.00  0.00           H  
ATOM    288 HH11 ARG A 125       7.063  30.812   8.839  1.00  0.00           H  
ATOM    289 HH12 ARG A 125       6.953  29.856  10.278  1.00  0.00           H  
ATOM    290 HH21 ARG A 125       7.146  32.581  12.459  1.00  0.00           H  
ATOM    291 HH22 ARG A 125       6.998  30.860  12.334  1.00  0.00           H  
ATOM    292  N   VAL A 126       3.243  36.476   7.239  1.00  0.00           N  
ATOM    293  CA  VAL A 126       1.815  36.655   7.293  1.00  0.00           C  
ATOM    294  C   VAL A 126       1.488  38.075   6.854  1.00  0.00           C  
ATOM    295  O   VAL A 126       2.113  39.043   7.294  1.00  0.00           O  
ATOM    296  CB  VAL A 126       1.317  36.475   8.740  1.00  0.00           C  
ATOM    297  CG1 VAL A 126      -0.202  36.545   8.797  1.00  0.00           C  
ATOM    298  CG2 VAL A 126       1.819  35.161   9.319  1.00  0.00           C  
ATOM    299  H   VAL A 126       3.794  37.163   7.622  1.00  0.00           H  
ATOM    300  HA  VAL A 126       1.332  35.937   6.650  1.00  0.00           H  
ATOM    301  HB  VAL A 126       1.714  37.283   9.338  1.00  0.00           H  
ATOM    302 HG11 VAL A 126      -0.607  35.545   8.822  1.00  0.00           H  
ATOM    303 HG12 VAL A 126      -0.570  37.062   7.924  1.00  0.00           H  
ATOM    304 HG13 VAL A 126      -0.504  37.078   9.686  1.00  0.00           H  
ATOM    305 HG21 VAL A 126       1.683  34.373   8.594  1.00  0.00           H  
ATOM    306 HG22 VAL A 126       1.266  34.928  10.216  1.00  0.00           H  
ATOM    307 HG23 VAL A 126       2.870  35.252   9.558  1.00  0.00           H  
ATOM    308  N   HIS A 127       0.462  38.186   6.041  1.00  0.00           N  
ATOM    309  CA  HIS A 127      -0.009  39.477   5.549  1.00  0.00           C  
ATOM    310  C   HIS A 127      -1.353  39.834   6.176  1.00  0.00           C  
ATOM    311  O   HIS A 127      -2.267  39.011   6.227  1.00  0.00           O  
ATOM    312  CB  HIS A 127      -0.167  39.395   4.028  1.00  0.00           C  
ATOM    313  CG  HIS A 127       0.911  38.608   3.352  1.00  0.00           C  
ATOM    314  ND1 HIS A 127       2.252  38.805   3.601  1.00  0.00           N  
ATOM    315  CD2 HIS A 127       0.843  37.611   2.437  1.00  0.00           C  
ATOM    316  CE1 HIS A 127       2.962  37.966   2.870  1.00  0.00           C  
ATOM    317  NE2 HIS A 127       2.131  37.230   2.156  1.00  0.00           N  
ATOM    318  H   HIS A 127      -0.004  37.373   5.777  1.00  0.00           H  
ATOM    319  HA  HIS A 127       0.722  40.229   5.797  1.00  0.00           H  
ATOM    320  HB2 HIS A 127      -1.113  38.930   3.796  1.00  0.00           H  
ATOM    321  HB3 HIS A 127      -0.156  40.396   3.620  1.00  0.00           H  
ATOM    322  HD1 HIS A 127       2.627  39.466   4.221  1.00  0.00           H  
ATOM    323  HD2 HIS A 127      -0.059  37.193   2.011  1.00  0.00           H  
ATOM    324  HE1 HIS A 127       4.038  37.892   2.863  1.00  0.00           H  
ATOM    325  N   LEU A 128      -1.492  41.093   6.568  1.00  0.00           N  
ATOM    326  CA  LEU A 128      -2.718  41.601   7.132  1.00  0.00           C  
ATOM    327  C   LEU A 128      -3.093  42.874   6.394  1.00  0.00           C  
ATOM    328  O   LEU A 128      -2.257  43.751   6.174  1.00  0.00           O  
ATOM    329  CB  LEU A 128      -2.493  41.918   8.612  1.00  0.00           C  
ATOM    330  CG  LEU A 128      -3.769  42.134   9.428  1.00  0.00           C  
ATOM    331  CD1 LEU A 128      -4.426  40.802   9.753  1.00  0.00           C  
ATOM    332  CD2 LEU A 128      -3.461  42.904  10.703  1.00  0.00           C  
ATOM    333  H   LEU A 128      -0.759  41.712   6.444  1.00  0.00           H  
ATOM    334  HA  LEU A 128      -3.495  40.862   7.022  1.00  0.00           H  
ATOM    335  HB2 LEU A 128      -1.943  41.098   9.054  1.00  0.00           H  
ATOM    336  HB3 LEU A 128      -1.893  42.811   8.681  1.00  0.00           H  
ATOM    337  HG  LEU A 128      -4.467  42.717   8.844  1.00  0.00           H  
ATOM    338 HD11 LEU A 128      -5.168  40.574   9.002  1.00  0.00           H  
ATOM    339 HD12 LEU A 128      -4.901  40.861  10.721  1.00  0.00           H  
ATOM    340 HD13 LEU A 128      -3.677  40.024   9.766  1.00  0.00           H  
ATOM    341 HD21 LEU A 128      -4.318  43.500  10.980  1.00  0.00           H  
ATOM    342 HD22 LEU A 128      -2.611  43.550  10.537  1.00  0.00           H  
ATOM    343 HD23 LEU A 128      -3.234  42.209  11.498  1.00  0.00           H  
ATOM    344  N   LEU A 129      -4.364  43.000   6.086  1.00  0.00           N  
ATOM    345  CA  LEU A 129      -4.875  44.176   5.425  1.00  0.00           C  
ATOM    346  C   LEU A 129      -5.863  44.877   6.335  1.00  0.00           C  
ATOM    347  O   LEU A 129      -6.752  44.257   6.918  1.00  0.00           O  
ATOM    348  CB  LEU A 129      -5.569  43.755   4.129  1.00  0.00           C  
ATOM    349  CG  LEU A 129      -6.241  44.893   3.358  1.00  0.00           C  
ATOM    350  CD1 LEU A 129      -5.197  45.824   2.764  1.00  0.00           C  
ATOM    351  CD2 LEU A 129      -7.144  44.336   2.268  1.00  0.00           C  
ATOM    352  H   LEU A 129      -4.973  42.306   6.341  1.00  0.00           H  
ATOM    353  HA  LEU A 129      -4.051  44.836   5.200  1.00  0.00           H  
ATOM    354  HB2 LEU A 129      -4.835  43.295   3.485  1.00  0.00           H  
ATOM    355  HB3 LEU A 129      -6.322  43.021   4.371  1.00  0.00           H  
ATOM    356  HG  LEU A 129      -6.853  45.468   4.038  1.00  0.00           H  
ATOM    357 HD11 LEU A 129      -4.319  45.831   3.394  1.00  0.00           H  
ATOM    358 HD12 LEU A 129      -5.601  46.824   2.700  1.00  0.00           H  
ATOM    359 HD13 LEU A 129      -4.929  45.481   1.776  1.00  0.00           H  
ATOM    360 HD21 LEU A 129      -7.917  45.055   2.038  1.00  0.00           H  
ATOM    361 HD22 LEU A 129      -7.597  43.416   2.609  1.00  0.00           H  
ATOM    362 HD23 LEU A 129      -6.559  44.141   1.380  1.00  0.00           H  
ATOM    363  N   LYS A 130      -5.739  46.175   6.384  1.00  0.00           N  
ATOM    364  CA  LYS A 130      -6.612  47.014   7.165  1.00  0.00           C  
ATOM    365  C   LYS A 130      -7.120  48.149   6.295  1.00  0.00           C  
ATOM    366  O   LYS A 130      -6.354  48.798   5.583  1.00  0.00           O  
ATOM    367  CB  LYS A 130      -5.827  47.593   8.343  1.00  0.00           C  
ATOM    368  CG  LYS A 130      -6.699  47.962   9.533  1.00  0.00           C  
ATOM    369  CD  LYS A 130      -6.386  49.360  10.044  1.00  0.00           C  
ATOM    370  CE  LYS A 130      -6.612  49.467  11.544  1.00  0.00           C  
ATOM    371  NZ  LYS A 130      -5.389  49.110  12.316  1.00  0.00           N  
ATOM    372  H   LYS A 130      -5.050  46.584   5.863  1.00  0.00           H  
ATOM    373  HA  LYS A 130      -7.439  46.425   7.528  1.00  0.00           H  
ATOM    374  HB2 LYS A 130      -5.100  46.863   8.669  1.00  0.00           H  
ATOM    375  HB3 LYS A 130      -5.308  48.481   8.013  1.00  0.00           H  
ATOM    376  HG2 LYS A 130      -7.736  47.925   9.232  1.00  0.00           H  
ATOM    377  HG3 LYS A 130      -6.527  47.251  10.327  1.00  0.00           H  
ATOM    378  HD2 LYS A 130      -5.352  49.588   9.829  1.00  0.00           H  
ATOM    379  HD3 LYS A 130      -7.026  50.069   9.541  1.00  0.00           H  
ATOM    380  HE2 LYS A 130      -6.893  50.481  11.781  1.00  0.00           H  
ATOM    381  HE3 LYS A 130      -7.411  48.797  11.823  1.00  0.00           H  
ATOM    382  HZ1 LYS A 130      -5.428  48.112  12.606  1.00  0.00           H  
ATOM    383  HZ2 LYS A 130      -5.318  49.705  13.166  1.00  0.00           H  
ATOM    384  HZ3 LYS A 130      -4.541  49.257  11.731  1.00  0.00           H  
ATOM    385  N   CYS A 131      -8.392  48.437   6.431  1.00  0.00           N  
ATOM    386  CA  CYS A 131      -9.013  49.527   5.724  1.00  0.00           C  
ATOM    387  C   CYS A 131      -9.561  50.485   6.751  1.00  0.00           C  
ATOM    388  O   CYS A 131     -10.228  50.067   7.711  1.00  0.00           O  
ATOM    389  CB  CYS A 131     -10.150  48.988   4.852  1.00  0.00           C  
ATOM    390  SG  CYS A 131     -10.997  50.259   3.852  1.00  0.00           S  
ATOM    391  H   CYS A 131      -8.920  47.933   7.066  1.00  0.00           H  
ATOM    392  HA  CYS A 131      -8.273  50.020   5.111  1.00  0.00           H  
ATOM    393  HB2 CYS A 131      -9.754  48.247   4.176  1.00  0.00           H  
ATOM    394  HB3 CYS A 131     -10.890  48.524   5.489  1.00  0.00           H  
ATOM    395  N   MET A 132      -9.338  51.766   6.514  1.00  0.00           N  
ATOM    396  CA  MET A 132      -9.837  52.779   7.408  1.00  0.00           C  
ATOM    397  C   MET A 132     -10.963  53.544   6.750  1.00  0.00           C  
ATOM    398  O   MET A 132     -10.851  54.020   5.616  1.00  0.00           O  
ATOM    399  CB  MET A 132      -8.704  53.735   7.791  1.00  0.00           C  
ATOM    400  CG  MET A 132      -8.540  53.912   9.291  1.00  0.00           C  
ATOM    401  SD  MET A 132      -9.949  54.740  10.052  1.00  0.00           S  
ATOM    402  CE  MET A 132     -10.219  53.700  11.486  1.00  0.00           C  
ATOM    403  H   MET A 132      -8.846  52.030   5.715  1.00  0.00           H  
ATOM    404  HA  MET A 132     -10.209  52.295   8.298  1.00  0.00           H  
ATOM    405  HB2 MET A 132      -7.776  53.354   7.392  1.00  0.00           H  
ATOM    406  HB3 MET A 132      -8.900  54.705   7.355  1.00  0.00           H  
ATOM    407  HG2 MET A 132      -8.426  52.938   9.744  1.00  0.00           H  
ATOM    408  HG3 MET A 132      -7.652  54.499   9.476  1.00  0.00           H  
ATOM    409  HE1 MET A 132     -10.989  52.975  11.266  1.00  0.00           H  
ATOM    410  HE2 MET A 132     -10.528  54.312  12.320  1.00  0.00           H  
ATOM    411  HE3 MET A 132      -9.303  53.188  11.736  1.00  0.00           H  
ATOM    412  N   ALA A 133     -12.034  53.652   7.519  1.00  0.00           N  
ATOM    413  CA  ALA A 133     -13.268  54.340   7.130  1.00  0.00           C  
ATOM    414  C   ALA A 133     -14.441  53.448   7.491  1.00  0.00           C  
ATOM    415  O   ALA A 133     -15.481  53.907   7.964  1.00  0.00           O  
ATOM    416  CB  ALA A 133     -13.298  54.676   5.643  1.00  0.00           C  
ATOM    417  H   ALA A 133     -11.995  53.221   8.403  1.00  0.00           H  
ATOM    418  HA  ALA A 133     -13.335  55.259   7.696  1.00  0.00           H  
ATOM    419  HB1 ALA A 133     -13.043  53.797   5.071  1.00  0.00           H  
ATOM    420  HB2 ALA A 133     -12.586  55.460   5.437  1.00  0.00           H  
ATOM    421  HB3 ALA A 133     -14.289  55.009   5.371  1.00  0.00           H  
ATOM    422  N   CYS A 134     -14.232  52.154   7.284  1.00  0.00           N  
ATOM    423  CA  CYS A 134     -15.224  51.141   7.601  1.00  0.00           C  
ATOM    424  C   CYS A 134     -14.713  50.248   8.732  1.00  0.00           C  
ATOM    425  O   CYS A 134     -15.463  49.450   9.293  1.00  0.00           O  
ATOM    426  CB  CYS A 134     -15.521  50.291   6.362  1.00  0.00           C  
ATOM    427  SG  CYS A 134     -14.127  49.242   5.827  1.00  0.00           S  
ATOM    428  H   CYS A 134     -13.368  51.868   6.922  1.00  0.00           H  
ATOM    429  HA  CYS A 134     -16.127  51.639   7.920  1.00  0.00           H  
ATOM    430  HB2 CYS A 134     -16.358  49.643   6.573  1.00  0.00           H  
ATOM    431  HB3 CYS A 134     -15.776  50.944   5.538  1.00  0.00           H  
ATOM    432  N   GLY A 135     -13.422  50.381   9.051  1.00  0.00           N  
ATOM    433  CA  GLY A 135     -12.826  49.575  10.096  1.00  0.00           C  
ATOM    434  C   GLY A 135     -12.943  48.100   9.792  1.00  0.00           C  
ATOM    435  O   GLY A 135     -13.668  47.376  10.473  1.00  0.00           O  
ATOM    436  H   GLY A 135     -12.867  51.023   8.562  1.00  0.00           H  
ATOM    437  HA2 GLY A 135     -11.783  49.835  10.192  1.00  0.00           H  
ATOM    438  HA3 GLY A 135     -13.329  49.782  11.030  1.00  0.00           H  
ATOM    439  N   ALA A 136     -12.248  47.651   8.750  1.00  0.00           N  
ATOM    440  CA  ALA A 136     -12.320  46.242   8.360  1.00  0.00           C  
ATOM    441  C   ALA A 136     -10.943  45.593   8.338  1.00  0.00           C  
ATOM    442  O   ALA A 136      -9.996  46.148   7.784  1.00  0.00           O  
ATOM    443  CB  ALA A 136     -12.949  46.159   6.978  1.00  0.00           C  
ATOM    444  H   ALA A 136     -11.697  48.275   8.226  1.00  0.00           H  
ATOM    445  HA  ALA A 136     -12.958  45.721   9.058  1.00  0.00           H  
ATOM    446  HB1 ALA A 136     -13.841  46.767   6.951  1.00  0.00           H  
ATOM    447  HB2 ALA A 136     -13.205  45.133   6.760  1.00  0.00           H  
ATOM    448  HB3 ALA A 136     -12.246  46.519   6.241  1.00  0.00           H  
ATOM    449  N   ILE A 137     -10.856  44.372   8.856  1.00  0.00           N  
ATOM    450  CA  ILE A 137      -9.602  43.630   8.833  1.00  0.00           C  
ATOM    451  C   ILE A 137      -9.784  42.287   8.131  1.00  0.00           C  
ATOM    452  O   ILE A 137     -10.726  41.547   8.411  1.00  0.00           O  
ATOM    453  CB  ILE A 137      -9.124  43.369  10.274  1.00  0.00           C  
ATOM    454  CG1 ILE A 137      -9.154  44.664  11.090  1.00  0.00           C  
ATOM    455  CG2 ILE A 137      -7.723  42.775  10.267  1.00  0.00           C  
ATOM    456  CD1 ILE A 137     -10.479  44.912  11.779  1.00  0.00           C  
ATOM    457  H   ILE A 137     -11.659  43.945   9.223  1.00  0.00           H  
ATOM    458  HA  ILE A 137      -8.858  44.217   8.318  1.00  0.00           H  
ATOM    459  HB  ILE A 137      -9.790  42.652  10.724  1.00  0.00           H  
ATOM    460 HG12 ILE A 137      -8.389  44.622  11.850  1.00  0.00           H  
ATOM    461 HG13 ILE A 137      -8.958  45.500  10.435  1.00  0.00           H  
ATOM    462 HG21 ILE A 137      -7.531  42.316   9.309  1.00  0.00           H  
ATOM    463 HG22 ILE A 137      -7.645  42.029  11.045  1.00  0.00           H  
ATOM    464 HG23 ILE A 137      -6.999  43.556  10.446  1.00  0.00           H  
ATOM    465 HD11 ILE A 137     -10.650  45.975  11.855  1.00  0.00           H  
ATOM    466 HD12 ILE A 137     -10.457  44.479  12.767  1.00  0.00           H  
ATOM    467 HD13 ILE A 137     -11.274  44.460  11.204  1.00  0.00           H  
ATOM    468  N   ARG A 138      -8.829  41.948   7.271  1.00  0.00           N  
ATOM    469  CA  ARG A 138      -8.848  40.682   6.554  1.00  0.00           C  
ATOM    470  C   ARG A 138      -7.496  39.975   6.678  1.00  0.00           C  
ATOM    471  O   ARG A 138      -6.442  40.591   6.493  1.00  0.00           O  
ATOM    472  CB  ARG A 138      -9.131  40.963   5.076  1.00  0.00           C  
ATOM    473  CG  ARG A 138     -10.587  40.750   4.686  1.00  0.00           C  
ATOM    474  CD  ARG A 138     -10.717  39.823   3.487  1.00  0.00           C  
ATOM    475  NE  ARG A 138     -10.035  38.548   3.702  1.00  0.00           N  
ATOM    476  CZ  ARG A 138     -10.312  37.435   3.029  1.00  0.00           C  
ATOM    477  NH1 ARG A 138     -11.255  37.432   2.092  1.00  0.00           N  
ATOM    478  NH2 ARG A 138      -9.643  36.319   3.289  1.00  0.00           N  
ATOM    479  H   ARG A 138      -8.084  42.562   7.127  1.00  0.00           H  
ATOM    480  HA  ARG A 138      -9.630  40.063   6.962  1.00  0.00           H  
ATOM    481  HB2 ARG A 138      -8.871  41.989   4.860  1.00  0.00           H  
ATOM    482  HB3 ARG A 138      -8.519  40.311   4.472  1.00  0.00           H  
ATOM    483  HG2 ARG A 138     -11.113  40.314   5.522  1.00  0.00           H  
ATOM    484  HG3 ARG A 138     -11.027  41.705   4.441  1.00  0.00           H  
ATOM    485  HD2 ARG A 138     -11.765  39.634   3.307  1.00  0.00           H  
ATOM    486  HD3 ARG A 138     -10.286  40.309   2.624  1.00  0.00           H  
ATOM    487  HE  ARG A 138      -9.335  38.521   4.386  1.00  0.00           H  
ATOM    488 HH11 ARG A 138     -11.762  38.269   1.890  1.00  0.00           H  
ATOM    489 HH12 ARG A 138     -11.456  36.591   1.590  1.00  0.00           H  
ATOM    490 HH21 ARG A 138      -8.932  36.316   3.992  1.00  0.00           H  
ATOM    491 HH22 ARG A 138      -9.850  35.482   2.784  1.00  0.00           H  
ATOM    492  N   PRO A 139      -7.514  38.649   6.915  1.00  0.00           N  
ATOM    493  CA  PRO A 139      -6.312  37.836   7.012  1.00  0.00           C  
ATOM    494  C   PRO A 139      -5.942  37.192   5.679  1.00  0.00           C  
ATOM    495  O   PRO A 139      -6.802  36.649   4.983  1.00  0.00           O  
ATOM    496  CB  PRO A 139      -6.740  36.772   8.014  1.00  0.00           C  
ATOM    497  CG  PRO A 139      -8.194  36.551   7.729  1.00  0.00           C  
ATOM    498  CD  PRO A 139      -8.718  37.815   7.078  1.00  0.00           C  
ATOM    499  HA  PRO A 139      -5.473  38.394   7.400  1.00  0.00           H  
ATOM    500  HB2 PRO A 139      -6.162  35.872   7.858  1.00  0.00           H  
ATOM    501  HB3 PRO A 139      -6.586  37.135   9.020  1.00  0.00           H  
ATOM    502  HG2 PRO A 139      -8.310  35.712   7.059  1.00  0.00           H  
ATOM    503  HG3 PRO A 139      -8.720  36.364   8.654  1.00  0.00           H  
ATOM    504  HD2 PRO A 139      -9.161  37.588   6.120  1.00  0.00           H  
ATOM    505  HD3 PRO A 139      -9.438  38.297   7.721  1.00  0.00           H  
ATOM    506  N   ILE A 140      -4.664  37.253   5.326  1.00  0.00           N  
ATOM    507  CA  ILE A 140      -4.190  36.672   4.076  1.00  0.00           C  
ATOM    508  C   ILE A 140      -2.795  36.077   4.241  1.00  0.00           C  
ATOM    509  O   ILE A 140      -2.045  36.467   5.136  1.00  0.00           O  
ATOM    510  CB  ILE A 140      -4.157  37.717   2.945  1.00  0.00           C  
ATOM    511  CG1 ILE A 140      -5.476  38.489   2.894  1.00  0.00           C  
ATOM    512  CG2 ILE A 140      -3.880  37.042   1.609  1.00  0.00           C  
ATOM    513  CD1 ILE A 140      -5.483  39.607   1.876  1.00  0.00           C  
ATOM    514  H   ILE A 140      -4.024  37.698   5.921  1.00  0.00           H  
ATOM    515  HA  ILE A 140      -4.874  35.885   3.792  1.00  0.00           H  
ATOM    516  HB  ILE A 140      -3.351  38.407   3.145  1.00  0.00           H  
ATOM    517 HG12 ILE A 140      -6.275  37.808   2.642  1.00  0.00           H  
ATOM    518 HG13 ILE A 140      -5.670  38.921   3.865  1.00  0.00           H  
ATOM    519 HG21 ILE A 140      -2.816  36.900   1.491  1.00  0.00           H  
ATOM    520 HG22 ILE A 140      -4.251  37.663   0.808  1.00  0.00           H  
ATOM    521 HG23 ILE A 140      -4.375  36.083   1.580  1.00  0.00           H  
ATOM    522 HD11 ILE A 140      -6.440  40.108   1.896  1.00  0.00           H  
ATOM    523 HD12 ILE A 140      -5.312  39.200   0.891  1.00  0.00           H  
ATOM    524 HD13 ILE A 140      -4.701  40.314   2.112  1.00  0.00           H  
ATOM    525  N   ARG A 141      -2.454  35.133   3.371  1.00  0.00           N  
ATOM    526  CA  ARG A 141      -1.149  34.484   3.420  1.00  0.00           C  
ATOM    527  C   ARG A 141      -0.878  33.712   2.132  1.00  0.00           C  
ATOM    528  O   ARG A 141      -1.681  32.878   1.715  1.00  0.00           O  
ATOM    529  CB  ARG A 141      -1.073  33.540   4.619  1.00  0.00           C  
ATOM    530  CG  ARG A 141      -2.245  32.577   4.708  1.00  0.00           C  
ATOM    531  CD  ARG A 141      -1.881  31.329   5.496  1.00  0.00           C  
ATOM    532  NE  ARG A 141      -3.008  30.406   5.610  1.00  0.00           N  
ATOM    533  CZ  ARG A 141      -3.450  29.647   4.608  1.00  0.00           C  
ATOM    534  NH1 ARG A 141      -2.865  29.699   3.419  1.00  0.00           N  
ATOM    535  NH2 ARG A 141      -4.480  28.834   4.798  1.00  0.00           N  
ATOM    536  H   ARG A 141      -3.096  34.866   2.678  1.00  0.00           H  
ATOM    537  HA  ARG A 141      -0.400  35.255   3.529  1.00  0.00           H  
ATOM    538  HB2 ARG A 141      -0.163  32.962   4.550  1.00  0.00           H  
ATOM    539  HB3 ARG A 141      -1.049  34.127   5.524  1.00  0.00           H  
ATOM    540  HG2 ARG A 141      -3.069  33.072   5.198  1.00  0.00           H  
ATOM    541  HG3 ARG A 141      -2.538  32.288   3.709  1.00  0.00           H  
ATOM    542  HD2 ARG A 141      -1.067  30.826   4.995  1.00  0.00           H  
ATOM    543  HD3 ARG A 141      -1.567  31.623   6.486  1.00  0.00           H  
ATOM    544  HE  ARG A 141      -3.460  30.348   6.477  1.00  0.00           H  
ATOM    545 HH11 ARG A 141      -2.088  30.310   3.269  1.00  0.00           H  
ATOM    546 HH12 ARG A 141      -3.202  29.127   2.671  1.00  0.00           H  
ATOM    547 HH21 ARG A 141      -4.926  28.791   5.693  1.00  0.00           H  
ATOM    548 HH22 ARG A 141      -4.813  28.264   4.047  1.00  0.00           H  
ATOM    549  N   MET A 142       0.261  33.995   1.507  1.00  0.00           N  
ATOM    550  CA  MET A 142       0.639  33.327   0.267  1.00  0.00           C  
ATOM    551  C   MET A 142       1.807  32.374   0.499  1.00  0.00           C  
ATOM    552  O   MET A 142       1.872  31.297  -0.094  1.00  0.00           O  
ATOM    553  CB  MET A 142       1.008  34.358  -0.802  1.00  0.00           C  
ATOM    554  CG  MET A 142      -0.042  34.500  -1.896  1.00  0.00           C  
ATOM    555  SD  MET A 142      -0.622  36.196  -2.090  1.00  0.00           S  
ATOM    556  CE  MET A 142      -1.312  36.506  -0.466  1.00  0.00           C  
ATOM    557  H   MET A 142       0.861  34.670   1.889  1.00  0.00           H  
ATOM    558  HA  MET A 142      -0.213  32.756  -0.074  1.00  0.00           H  
ATOM    559  HB2 MET A 142       1.137  35.320  -0.328  1.00  0.00           H  
ATOM    560  HB3 MET A 142       1.939  34.067  -1.264  1.00  0.00           H  
ATOM    561  HG2 MET A 142       0.389  34.174  -2.831  1.00  0.00           H  
ATOM    562  HG3 MET A 142      -0.885  33.871  -1.650  1.00  0.00           H  
ATOM    563  HE1 MET A 142      -0.561  36.316   0.286  1.00  0.00           H  
ATOM    564  HE2 MET A 142      -2.157  35.855  -0.304  1.00  0.00           H  
ATOM    565  HE3 MET A 142      -1.634  37.535  -0.402  1.00  0.00           H  
ATOM    566  N   ILE A 143       2.729  32.777   1.367  1.00  0.00           N  
ATOM    567  CA  ILE A 143       3.896  31.961   1.678  1.00  0.00           C  
ATOM    568  C   ILE A 143       3.617  31.029   2.853  1.00  0.00           C  
ATOM    569  O   ILE A 143       2.741  30.651   2.323  1.00  0.00           O  
ATOM    570  CB  ILE A 143       5.123  32.838   2.004  1.00  0.00           C  
ATOM    571  CG1 ILE A 143       6.359  31.964   2.238  1.00  0.00           C  
ATOM    572  CG2 ILE A 143       4.847  33.712   3.219  1.00  0.00           C  
ATOM    573  CD1 ILE A 143       6.890  31.320   0.976  1.00  0.00           C  
ATOM    574  OXT ILE A 143       2.847  30.577   2.207  1.00  0.00           O  
ATOM    575  H   ILE A 143       2.624  33.646   1.809  1.00  0.00           H  
ATOM    576  HA  ILE A 143       4.128  31.365   0.807  1.00  0.00           H  
ATOM    577  HB  ILE A 143       5.306  33.486   1.160  1.00  0.00           H  
ATOM    578 HG12 ILE A 143       7.147  32.571   2.657  1.00  0.00           H  
ATOM    579 HG13 ILE A 143       6.109  31.177   2.934  1.00  0.00           H  
ATOM    580 HG21 ILE A 143       4.586  34.709   2.892  1.00  0.00           H  
ATOM    581 HG22 ILE A 143       5.729  33.758   3.839  1.00  0.00           H  
ATOM    582 HG23 ILE A 143       4.029  33.295   3.785  1.00  0.00           H  
ATOM    583 HD11 ILE A 143       6.940  30.250   1.112  1.00  0.00           H  
ATOM    584 HD12 ILE A 143       7.879  31.702   0.766  1.00  0.00           H  
ATOM    585 HD13 ILE A 143       6.233  31.548   0.151  1.00  0.00           H  
TER     586      ILE A 143                                                      
END
MOLECULE T0480.pdb
ATOM     43  N   PHE    20      -9.421  47.124  -2.332  1.00  0.00
ATOM     44  HN  PHE    20      -9.663  47.024  -3.278  1.00  0.00
ATOM     45  CA  PHE    20     -10.050  48.188  -1.549  1.00  0.00
ATOM     46  HA  PHE    20      -9.287  48.642  -0.932  1.00  0.00
ATOM     47  CB  PHE    20     -10.641  49.260  -2.478  1.00  0.00
ATOM     48  HB1 PHE    20     -11.197  49.974  -1.885  1.00  0.00
ATOM     49  HB2 PHE    20     -11.316  48.788  -3.178  1.00  0.00
ATOM     50  CG  PHE    20      -9.613  50.019  -3.274  1.00  0.00
ATOM     51  CD1 PHE    20      -9.119  49.504  -4.460  1.00  0.00
ATOM     52  HD1 PHE    20      -9.476  48.547  -4.813  1.00  0.00
ATOM     53  CD2 PHE    20      -9.145  51.251  -2.836  1.00  0.00
ATOM     54  HD2 PHE    20      -9.523  51.664  -1.912  1.00  0.00
ATOM     55  CE1 PHE    20      -8.180  50.199  -5.195  1.00  0.00
ATOM     56  HE1 PHE    20      -7.803  49.783  -6.119  1.00  0.00
ATOM     57  CE2 PHE    20      -8.206  51.949  -3.568  1.00  0.00
ATOM     58  HE2 PHE    20      -7.850  52.908  -3.217  1.00  0.00
ATOM     59  CZ  PHE    20      -7.722  51.422  -4.750  1.00  0.00
ATOM     60  HZ  PHE    20      -6.988  51.966  -5.326  1.00  0.00
ATOM     61  C   PHE    20     -11.149  47.641  -0.643  1.00  0.00
ATOM     62  O   PHE    20     -11.503  46.465  -0.706  1.00  0.00
ATOM     63  N   CYS    21     -11.685  48.510   0.204  1.00  0.00
ATOM     64  HN  CYS    21     -11.329  49.425   0.240  1.00  0.00
ATOM     65  CA  CYS    21     -12.801  48.155   1.067  1.00  0.00
ATOM     66  HA  CYS    21     -12.726  47.105   1.318  1.00  0.00
ATOM     67  HB1 CYS    21     -12.914  50.028   2.087  1.00  0.00
ATOM     68  HB2 CYS    21     -11.760  48.898   2.773  1.00  0.00
ATOM     69  C   CYS    21     -14.100  48.414   0.312  1.00  0.00
ATOM     70  O   CYS    21     -14.384  49.557  -0.023  1.00  0.00
ATOM     71  CB  CYS    21     -12.742  48.991   2.341  1.00  0.00
ATOM     72  SG  CYS    21     -13.954  48.528   3.619  1.00  0.00
ATOM     73  N   PRO    22     -14.916  47.367   0.073  1.00  0.00
ATOM     74  CA  PRO    22     -16.026  47.404  -0.893  1.00  0.00
ATOM     75  HA  PRO    22     -15.680  47.160  -1.889  1.00  0.00
ATOM     76  CB  PRO    22     -16.958  46.298  -0.401  1.00  0.00
ATOM     77  HB1 PRO    22     -17.462  45.846  -1.245  1.00  0.00
ATOM     78  HB2 PRO    22     -17.694  46.716   0.276  1.00  0.00
ATOM     79  CG  PRO    22     -16.074  45.316   0.294  1.00  0.00
ATOM     80  HG1 PRO    22     -15.795  44.526  -0.389  1.00  0.00
ATOM     81  HG2 PRO    22     -16.602  44.907   1.141  1.00  0.00
ATOM     82  CD  PRO    22     -14.843  46.065   0.763  1.00  0.00
ATOM     83  HD1 PRO    22     -13.945  45.532   0.486  1.00  0.00
ATOM     84  HD2 PRO    22     -14.875  46.204   1.835  1.00  0.00
ATOM     85  C   PRO    22     -16.770  48.741  -0.939  1.00  0.00
ATOM     86  O   PRO    22     -16.834  49.390  -1.988  1.00  0.00
ATOM     87  N   ARG    23     -17.316  49.158   0.201  1.00  0.00
ATOM     88  HN  ARG    23     -17.154  48.653   1.025  1.00  0.00
ATOM     89  CA  ARG    23     -18.164  50.344   0.238  1.00  0.00
ATOM     90  HA  ARG    23     -18.672  50.391  -0.712  1.00  0.00
ATOM     91  CB  ARG    23     -19.223  50.223   1.341  1.00  0.00
ATOM     92  HB1 ARG    23     -19.804  51.135   1.369  1.00  0.00
ATOM     93  HB2 ARG    23     -18.724  50.096   2.291  1.00  0.00
ATOM     94  CG  ARG    23     -20.180  49.050   1.141  1.00  0.00
ATOM     95  HG1 ARG    23     -19.642  48.129   1.321  1.00  0.00
ATOM     96  HG2 ARG    23     -20.538  49.061   0.121  1.00  0.00
ATOM     97  CD  ARG    23     -21.381  49.113   2.081  1.00  0.00
ATOM     98  HD1 ARG    23     -21.999  48.242   1.910  1.00  0.00
ATOM     99  HD2 ARG    23     -21.951  50.003   1.854  1.00  0.00
ATOM    100  NE  ARG    23     -20.991  49.150   3.495  1.00  0.00
ATOM    101  HE  ARG    23     -20.100  49.512   3.706  1.00  0.00
ATOM    102  CZ  ARG    23     -21.777  48.752   4.498  1.00  0.00
ATOM    103  NH1 ARG    23     -22.967  48.220   4.250  1.00  0.00
ATOM    104 HH11 ARG    23     -23.285  48.110   3.303  1.00  0.00
ATOM    105 HH12 ARG    23     -23.556  47.929   5.009  1.00  0.00
ATOM    106  NH2 ARG    23     -21.364  48.866   5.751  1.00  0.00
ATOM    107 HH21 ARG    23     -20.460  49.252   5.953  1.00  0.00
ATOM    108 HH22 ARG    23     -21.954  48.569   6.504  1.00  0.00
ATOM    109  C   ARG    23     -17.352  51.633   0.415  1.00  0.00
ATOM    110  O   ARG    23     -17.758  52.692  -0.062  1.00  0.00
ATOM    111  N   CYS    24     -16.206  51.549   1.092  1.00  0.00
ATOM    112  HN  CYS    24     -15.914  50.681   1.429  1.00  0.00
ATOM    113  CA  CYS    24     -15.370  52.739   1.328  1.00  0.00
ATOM    114  HA  CYS    24     -16.018  53.602   1.381  1.00  0.00
ATOM    115  HB1 CYS    24     -14.192  53.616   2.885  1.00  0.00
ATOM    116  HB2 CYS    24     -13.735  51.970   2.480  1.00  0.00
ATOM    117  C   CYS    24     -14.366  52.941   0.194  1.00  0.00
ATOM    118  O   CYS    24     -13.660  53.947   0.171  1.00  0.00
ATOM    119  CB  CYS    24     -14.572  52.634   2.635  1.00  0.00
ATOM    120  SG  CYS    24     -15.473  52.014   4.084  1.00  0.00
ATOM    121  N   GLY    25     -14.311  51.975  -0.727  1.00  0.00
ATOM    122  HN  GLY    25     -15.009  51.286  -0.729  1.00  0.00
ATOM    123  CA  GLY    25     -13.256  51.919  -1.735  1.00  0.00
ATOM    124  HA1 GLY    25     -13.576  51.268  -2.533  1.00  0.00
ATOM    125  HA2 GLY    25     -12.373  51.493  -1.282  1.00  0.00
ATOM    126  C   GLY    25     -12.895  53.274  -2.316  1.00  0.00
ATOM    127  O   GLY    25     -11.779  53.757  -2.106  1.00  0.00
ATOM    128  N   PRO    26     -13.818  53.919  -3.049  1.00  0.00
ATOM    129  CA  PRO    26     -13.599  55.269  -3.570  1.00  0.00
ATOM    130  HA  PRO    26     -12.703  55.315  -4.175  1.00  0.00
ATOM    131  CB  PRO    26     -14.836  55.536  -4.453  1.00  0.00
ATOM    132  HB1 PRO    26     -14.526  55.974  -5.391  1.00  0.00
ATOM    133  HB2 PRO    26     -15.511  56.212  -3.944  1.00  0.00
ATOM    134  CG  PRO    26     -15.466  54.197  -4.662  1.00  0.00
ATOM    135  HG1 PRO    26     -15.052  53.729  -5.546  1.00  0.00
ATOM    136  HG2 PRO    26     -16.537  54.305  -4.764  1.00  0.00
ATOM    137  CD  PRO    26     -15.135  53.389  -3.440  1.00  0.00
ATOM    138  HD1 PRO    26     -15.075  52.339  -3.684  1.00  0.00
ATOM    139  HD2 PRO    26     -15.868  53.560  -2.664  1.00  0.00
ATOM    140  C   PRO    26     -13.496  56.293  -2.437  1.00  0.00
ATOM    141  O   PRO    26     -14.508  56.823  -1.967  1.00  0.00
ATOM    142  N   GLY    27     -12.275  56.524  -1.966  1.00  0.00
ATOM    143  HN  GLY    27     -11.520  56.002  -2.319  1.00  0.00
ATOM    144  CA  GLY    27     -12.036  57.519  -0.932  1.00  0.00
ATOM    145  HA1 GLY    27     -12.982  57.935  -0.612  1.00  0.00
ATOM    146  HA2 GLY    27     -11.430  58.310  -1.348  1.00  0.00
ATOM    147  C   GLY    27     -11.325  56.943   0.273  1.00  0.00
ATOM    148  O   GLY    27     -10.653  57.668   1.009  1.00  0.00
ATOM    149  N   VAL    28     -11.468  55.634   0.479  1.00  0.00
ATOM    150  HN  VAL    28     -12.031  55.114  -0.136  1.00  0.00
ATOM    151  CA  VAL    28     -10.810  54.948   1.591  1.00  0.00
ATOM    152  HA  VAL    28     -10.018  55.586   1.960  1.00  0.00
ATOM    153  CB  VAL    28     -11.782  54.646   2.763  1.00  0.00
ATOM    154  HB  VAL    28     -12.477  53.886   2.424  1.00  0.00
ATOM    155  CG1 VAL    28     -11.028  54.082   3.968  1.00  0.00
ATOM    156 HG11 VAL    28     -10.300  54.803   4.309  1.00  0.00
ATOM    157 HG12 VAL    28     -10.525  53.168   3.687  1.00  0.00
ATOM    158 HG13 VAL    28     -11.728  53.875   4.766  1.00  0.00
ATOM    159  CG2 VAL    28     -12.588  55.883   3.159  1.00  0.00
ATOM    160 HG21 VAL    28     -11.917  56.666   3.482  1.00  0.00
ATOM    161 HG22 VAL    28     -13.260  55.632   3.967  1.00  0.00
ATOM    162 HG23 VAL    28     -13.162  56.229   2.311  1.00  0.00
ATOM    163  C   VAL    28     -10.205  53.631   1.123  1.00  0.00
ATOM    164  O   VAL    28     -10.910  52.621   0.993  1.00  0.00
ATOM    165  N   PHE    29      -8.907  53.645   0.861  1.00  0.00
ATOM    166  HN  PHE    29      -8.420  54.495   0.903  1.00  0.00
ATOM    167  CA  PHE    29      -8.190  52.430   0.504  1.00  0.00
ATOM    168  HA  PHE    29      -8.697  51.979  -0.339  1.00  0.00
ATOM    169  CB  PHE    29      -6.738  52.749   0.109  1.00  0.00
ATOM    170  HB1 PHE    29      -6.738  53.555  -0.613  1.00  0.00
ATOM    171  HB2 PHE    29      -6.296  51.872  -0.342  1.00  0.00
ATOM    172  CG  PHE    29      -5.864  53.166   1.270  1.00  0.00
ATOM    173  CD1 PHE    29      -4.909  52.298   1.788  1.00  0.00
ATOM    174  HD1 PHE    29      -4.786  51.319   1.348  1.00  0.00
ATOM    175  CD2 PHE    29      -6.003  54.418   1.850  1.00  0.00
ATOM    176  HD2 PHE    29      -6.739  55.104   1.458  1.00  0.00
ATOM    177  CE1 PHE    29      -4.116  52.673   2.857  1.00  0.00
ATOM    178  HE1 PHE    29      -3.377  51.988   3.249  1.00  0.00
ATOM    179  CE2 PHE    29      -5.211  54.796   2.917  1.00  0.00
ATOM    180  HE2 PHE    29      -5.331  55.775   3.358  1.00  0.00
ATOM    181  CZ  PHE    29      -4.268  53.924   3.421  1.00  0.00
ATOM    182  HZ  PHE    29      -3.650  54.219   4.258  1.00  0.00
ATOM    183  C   PHE    29      -8.210  51.449   1.679  1.00  0.00
ATOM    184  O   PHE    29      -8.458  51.838   2.825  1.00  0.00
ATOM    185  N   LEU    30      -7.958  50.182   1.396  1.00  0.00
ATOM    186  HN  LEU    30      -7.805  49.919   0.464  1.00  0.00
ATOM    187  CA  LEU    30      -7.868  49.176   2.441  1.00  0.00
ATOM    188  HA  LEU    30      -8.446  49.515   3.292  1.00  0.00
ATOM    189  CB  LEU    30      -8.437  47.841   1.939  1.00  0.00
ATOM    190  HB1 LEU    30      -7.762  47.449   1.190  1.00  0.00
ATOM    191  HB2 LEU    30      -9.389  48.040   1.467  1.00  0.00
ATOM    192  CG  LEU    30      -8.649  46.756   3.010  1.00  0.00
ATOM    193  HG  LEU    30      -7.705  46.559   3.499  1.00  0.00
ATOM    194  CD1 LEU    30      -9.637  47.226   4.075  1.00  0.00
ATOM    195 HD11 LEU    30     -10.591  47.443   3.615  1.00  0.00
ATOM    196 HD12 LEU    30      -9.257  48.119   4.550  1.00  0.00
ATOM    197 HD13 LEU    30      -9.765  46.452   4.819  1.00  0.00
ATOM    198  CD2 LEU    30      -9.129  45.452   2.368  1.00  0.00
ATOM    199 HD21 LEU    30     -10.068  45.622   1.859  1.00  0.00
ATOM    200 HD22 LEU    30      -9.268  44.701   3.133  1.00  0.00
ATOM    201 HD23 LEU    30      -8.392  45.106   1.657  1.00  0.00
ATOM    202  C   LEU    30      -6.405  49.037   2.850  1.00  0.00
ATOM    203  O   LEU    30      -5.581  48.585   2.055  1.00  0.00
ATOM    204  N   ALA    31      -6.089  49.469   4.074  1.00  0.00
ATOM    205  HN  ALA    31      -6.808  49.759   4.671  1.00  0.00
ATOM    206  CA  ALA    31      -4.708  49.517   4.560  1.00  0.00
ATOM    207  HA  ALA    31      -4.182  50.263   3.979  1.00  0.00
ATOM    208  CB  ALA    31      -4.674  49.953   6.023  1.00  0.00
ATOM    209  HB1 ALA    31      -3.648  50.043   6.352  1.00  0.00
ATOM    210  HB2 ALA    31      -5.182  49.219   6.631  1.00  0.00
ATOM    211  HB3 ALA    31      -5.167  50.908   6.126  1.00  0.00
ATOM    212  C   ALA    31      -4.007  48.174   4.380  1.00  0.00
ATOM    213  O   ALA    31      -4.101  47.290   5.237  1.00  0.00
ATOM    214  N   GLU    32      -3.331  48.023   3.246  1.00  0.00
ATOM    215  HN  GLU    32      -3.321  48.760   2.599  1.00  0.00
ATOM    216  CA  GLU    32      -2.625  46.794   2.922  1.00  0.00
ATOM    217  HA  GLU    32      -3.248  45.965   3.234  1.00  0.00
ATOM    218  CB  GLU    32      -2.386  46.686   1.408  1.00  0.00
ATOM    219  HB1 GLU    32      -1.814  47.543   1.083  1.00  0.00
ATOM    220  HB2 GLU    32      -3.342  46.691   0.903  1.00  0.00
ATOM    221  CG  GLU    32      -1.632  45.422   0.999  1.00  0.00
ATOM    222  HG1 GLU    32      -2.172  44.560   1.369  1.00  0.00
ATOM    223  HG2 GLU    32      -0.650  45.445   1.449  1.00  0.00
ATOM    224  CD  GLU    32      -1.467  45.287  -0.506  1.00  0.00
ATOM    225  OE1 GLU    32      -0.618  46.002  -1.079  1.00  0.00
ATOM    226  OE2 GLU    32      -2.171  44.448  -1.114  1.00  0.00
ATOM    227  C   GLU    32      -1.300  46.719   3.673  1.00  0.00
ATOM    228  O   GLU    32      -0.357  47.459   3.381  1.00  0.00
ATOM    229  N   HIS    33      -1.263  45.852   4.668  1.00  0.00
ATOM    230  HN  HIS    33      -2.089  45.388   4.911  1.00  0.00
ATOM    231  CA  HIS    33      -0.045  45.545   5.406  1.00  0.00
ATOM    232  HA  HIS    33       0.685  46.317   5.196  1.00  0.00
ATOM    233  CB  HIS    33      -0.317  45.503   6.914  1.00  0.00
ATOM    234  HB1 HIS    33       0.590  45.218   7.429  1.00  0.00
ATOM    235  HB2 HIS    33      -1.084  44.767   7.119  1.00  0.00
ATOM    236  CG  HIS    33      -0.772  46.815   7.476  1.00  0.00
ATOM    237  ND1 HIS    33       0.097  47.768   7.958  1.00  0.00
ATOM    238  HD1 HIS    33       1.077  47.689   7.991  1.00  0.00
ATOM    239  CD2 HIS    33      -2.014  47.330   7.633  1.00  0.00
ATOM    240  HD2 HIS    33      -2.944  46.851   7.362  1.00  0.00
ATOM    241  CE1 HIS    33      -0.589  48.809   8.385  1.00  0.00
ATOM    242  HE1 HIS    33      -0.169  49.705   8.818  1.00  0.00
ATOM    243  NE2 HIS    33      -1.873  48.572   8.199  1.00  0.00
ATOM    244  HE2 HIS    33      -2.599  49.075   8.631  1.00  0.00
ATOM    245  C   HIS    33       0.506  44.203   4.940  1.00  0.00
ATOM    246  O   HIS    33      -0.225  43.393   4.365  1.00  0.00
ATOM    247  N   ALA    34       1.782  43.964   5.214  1.00  0.00
ATOM    248  HN  ALA    34       2.282  44.621   5.746  1.00  0.00
ATOM    249  CA  ALA    34       2.468  42.759   4.751  1.00  0.00
ATOM    250  HA  ALA    34       2.479  42.779   3.670  1.00  0.00
ATOM    251  CB  ALA    34       3.914  42.763   5.235  1.00  0.00
ATOM    252  HB1 ALA    34       4.434  41.909   4.826  1.00  0.00
ATOM    253  HB2 ALA    34       3.936  42.714   6.315  1.00  0.00
ATOM    254  HB3 ALA    34       4.401  43.670   4.907  1.00  0.00
ATOM    255  C   ALA    34       1.761  41.481   5.206  1.00  0.00
ATOM    256  O   ALA    34       1.850  40.444   4.543  1.00  0.00
ATOM    257  N   ASP    35       1.049  41.561   6.329  1.00  0.00
ATOM    258  HN  ASP    35       0.954  42.428   6.773  1.00  0.00
ATOM    259  CA  ASP    35       0.416  40.383   6.923  1.00  0.00
ATOM    260  HA  ASP    35       0.770  39.510   6.392  1.00  0.00
ATOM    261  CB  ASP    35       0.816  40.251   8.399  1.00  0.00
ATOM    262  HB1 ASP    35       1.883  40.394   8.487  1.00  0.00
ATOM    263  HB2 ASP    35       0.565  39.258   8.747  1.00  0.00
ATOM    264  CG  ASP    35       0.122  41.266   9.293  1.00  0.00
ATOM    265  OD1 ASP    35       0.449  42.468   9.202  1.00  0.00
ATOM    266  OD2 ASP    35      -0.746  40.867  10.097  1.00  0.00
ATOM    267  C   ASP    35      -1.111  40.429   6.812  1.00  0.00
ATOM    268  O   ASP    35      -1.773  39.400   6.966  1.00  0.00
ATOM    269  N   ARG    36      -1.682  41.598   6.521  1.00  0.00
ATOM    270  HN  ARG    36      -1.122  42.366   6.270  1.00  0.00
ATOM    271  CA  ARG    36      -3.142  41.736   6.533  1.00  0.00
ATOM    272  HA  ARG    36      -3.550  40.949   5.917  1.00  0.00
ATOM    273  CB  ARG    36      -3.678  41.570   7.966  1.00  0.00
ATOM    274  HB1 ARG    36      -3.315  40.633   8.368  1.00  0.00
ATOM    275  HB2 ARG    36      -4.759  41.538   7.933  1.00  0.00
ATOM    276  CG  ARG    36      -3.264  42.690   8.914  1.00  0.00
ATOM    277  HG1 ARG    36      -3.731  43.611   8.594  1.00  0.00
ATOM    278  HG2 ARG    36      -2.190  42.797   8.873  1.00  0.00
ATOM    279  CD  ARG    36      -3.677  42.398  10.353  1.00  0.00
ATOM    280  HD1 ARG    36      -3.114  41.546  10.712  1.00  0.00
ATOM    281  HD2 ARG    36      -4.732  42.162  10.370  1.00  0.00
ATOM    282  NE  ARG    36      -3.436  43.539  11.239  1.00  0.00
ATOM    283  HE  ARG    36      -4.165  44.194  11.330  1.00  0.00
ATOM    284  CZ  ARG    36      -2.321  43.724  11.948  1.00  0.00
ATOM    285  NH1 ARG    36      -1.289  42.903  11.808  1.00  0.00
ATOM    286 HH11 ARG    36      -1.337  42.131  11.163  1.00  0.00
ATOM    287 HH12 ARG    36      -0.455  43.046  12.347  1.00  0.00
ATOM    288  NH2 ARG    36      -2.225  44.752  12.777  1.00  0.00
ATOM    289 HH21 ARG    36      -2.992  45.396  12.878  1.00  0.00
ATOM    290 HH22 ARG    36      -1.390  44.887  13.317  1.00  0.00
ATOM    291  C   ARG    36      -3.592  43.080   5.962  1.00  0.00
ATOM    292  O   ARG    36      -2.805  43.816   5.384  1.00  0.00
ATOM    293  N   TYR    37      -4.876  43.366   6.135  1.00  0.00
ATOM    294  HN  TYR    37      -5.429  42.719   6.609  1.00  0.00
ATOM    295  CA  TYR    37      -5.508  44.603   5.686  1.00  0.00
ATOM    296  HA  TYR    37      -4.743  45.306   5.387  1.00  0.00
ATOM    297  CB  TYR    37      -6.477  44.347   4.519  1.00  0.00
ATOM    298  HB1 TYR    37      -6.833  45.302   4.155  1.00  0.00
ATOM    299  HB2 TYR    37      -7.322  43.784   4.887  1.00  0.00
ATOM    300  CG  TYR    37      -5.912  43.586   3.333  1.00  0.00
ATOM    301  CD1 TYR    37      -5.992  42.198   3.273  1.00  0.00
ATOM    302  HD1 TYR    37      -6.438  41.661   4.097  1.00  0.00
ATOM    303  CD2 TYR    37      -5.335  44.256   2.258  1.00  0.00
ATOM    304  HD2 TYR    37      -5.265  45.334   2.286  1.00  0.00
ATOM    305  CE1 TYR    37      -5.512  41.502   2.183  1.00  0.00
ATOM    306  HE1 TYR    37      -5.586  40.425   2.155  1.00  0.00
ATOM    307  CE2 TYR    37      -4.849  43.564   1.166  1.00  0.00
ATOM    308  HE2 TYR    37      -4.402  44.101   0.342  1.00  0.00
ATOM    309  CZ  TYR    37      -4.942  42.190   1.133  1.00  0.00
ATOM    310  OH  TYR    37      -4.459  41.497   0.046  1.00  0.00
ATOM    311  HH  TYR    37      -5.120  40.864  -0.251  1.00  0.00
ATOM    312  C   TYR    37      -6.322  45.182   6.841  1.00  0.00
ATOM    313  O   TYR    37      -6.679  44.453   7.767  1.00  0.00
ATOM    314  N   SER    38      -6.636  46.471   6.777  1.00  0.00
ATOM    315  HN  SER    38      -6.247  47.026   6.068  1.00  0.00
ATOM    316  CA  SER    38      -7.535  47.084   7.751  1.00  0.00
ATOM    317  HA  SER    38      -8.327  46.375   7.956  1.00  0.00
ATOM    318  CB  SER    38      -6.797  47.393   9.060  1.00  0.00
ATOM    319  HB1 SER    38      -6.130  48.229   8.911  1.00  0.00
ATOM    320  HB2 SER    38      -6.225  46.527   9.362  1.00  0.00
ATOM    321  OG  SER    38      -7.714  47.715  10.094  1.00  0.00
ATOM    322  HG  SER    38      -8.082  46.897  10.459  1.00  0.00
ATOM    323  C   SER    38      -8.166  48.351   7.170  1.00  0.00
ATOM    324  O   SER    38      -7.687  48.894   6.172  1.00  0.00
ATOM    325  N   CYS    39      -9.256  48.806   7.780  1.00  0.00
ATOM    326  HN  CYS    39      -9.589  48.331   8.573  1.00  0.00
ATOM    327  CA  CYS    39      -9.980  49.978   7.296  1.00  0.00
ATOM    328  HA  CYS    39      -9.347  50.504   6.596  1.00  0.00
ATOM    329  HB1 CYS    39     -11.825  48.903   7.229  1.00  0.00
ATOM    330  HB2 CYS    39     -10.986  48.989   5.693  1.00  0.00
ATOM    331  C   CYS    39     -10.341  50.922   8.431  1.00  0.00
ATOM    332  O   CYS    39     -11.402  50.776   9.049  1.00  0.00
ATOM    333  CB  CYS    39     -11.253  49.545   6.574  1.00  0.00
ATOM    334  SG  CYS    39     -12.344  50.914   6.050  1.00  0.00
ATOM    335  N   GLY    40      -9.454  51.877   8.706  1.00  0.00
ATOM    336  HN  GLY    40      -8.584  51.868   8.253  1.00  0.00
ATOM    337  CA  GLY    40      -9.742  52.916   9.678  1.00  0.00
ATOM    338  HA1 GLY    40      -8.854  53.512   9.830  1.00  0.00
ATOM    339  HA2 GLY    40     -10.020  52.456  10.616  1.00  0.00
ATOM    340  C   GLY    40     -10.870  53.818   9.213  1.00  0.00
ATOM    341  O   GLY    40     -10.634  54.923   8.718  1.00  0.00
ATOM    342  N   ARG    41     -12.095  53.327   9.360  1.00  0.00
ATOM    343  HN  ARG    41     -12.200  52.466   9.822  1.00  0.00
ATOM    344  CA  ARG    41     -13.289  54.031   8.907  1.00  0.00
ATOM    345  HA  ARG    41     -13.318  54.990   9.406  1.00  0.00
ATOM    346  CB  ARG    41     -13.252  54.250   7.384  1.00  0.00
ATOM    347  HB1 ARG    41     -13.317  53.288   6.892  1.00  0.00
ATOM    348  HB2 ARG    41     -12.308  54.710   7.123  1.00  0.00
ATOM    349  CG  ARG    41     -14.378  55.137   6.858  1.00  0.00
ATOM    350  HG1 ARG    41     -15.326  54.721   7.169  1.00  0.00
ATOM    351  HG2 ARG    41     -14.332  55.156   5.778  1.00  0.00
ATOM    352  CD  ARG    41     -14.270  56.568   7.379  1.00  0.00
ATOM    353  HD1 ARG    41     -13.379  57.024   6.966  1.00  0.00
ATOM    354  HD2 ARG    41     -14.193  56.542   8.456  1.00  0.00
ATOM    355  NE  ARG    41     -15.434  57.375   7.008  1.00  0.00
ATOM    356  HE  ARG    41     -16.316  57.040   7.290  1.00  0.00
ATOM    357  CZ  ARG    41     -15.372  58.529   6.339  1.00  0.00
ATOM    358  NH1 ARG    41     -14.206  59.004   5.921  1.00  0.00
ATOM    359 HH11 ARG    41     -13.359  58.498   6.105  1.00  0.00
ATOM    360 HH12 ARG    41     -14.164  59.872   5.417  1.00  0.00
ATOM    361  NH2 ARG    41     -16.485  59.200   6.077  1.00  0.00
ATOM    362 HH21 ARG    41     -17.372  58.843   6.382  1.00  0.00
ATOM    363 HH22 ARG    41     -16.447  60.068   5.571  1.00  0.00
ATOM    364  C   ARG    41     -14.536  53.232   9.294  1.00  0.00
ATOM    365  O   ARG    41     -15.460  53.767   9.905  1.00  0.00
ATOM    366  N   CYS    42     -14.550  51.941   8.946  1.00  0.00
ATOM    367  HN  CYS    42     -13.788  51.572   8.462  1.00  0.00
ATOM    368  CA  CYS    42     -15.680  51.066   9.290  1.00  0.00
ATOM    369  HA  CYS    42     -16.324  51.612   9.967  1.00  0.00
ATOM    370  HB1 CYS    42     -16.667  51.558   7.443  1.00  0.00
ATOM    371  HB2 CYS    42     -17.452  50.281   8.357  1.00  0.00
ATOM    372  C   CYS    42     -15.190  49.810  10.010  1.00  0.00
ATOM    373  O   CYS    42     -15.972  48.902  10.291  1.00  0.00
ATOM    374  CB  CYS    42     -16.497  50.676   8.042  1.00  0.00
ATOM    375  SG  CYS    42     -15.721  49.422   6.967  1.00  0.00
ATOM    376  N   GLY    43     -13.886  49.755  10.293  1.00  0.00
ATOM    377  HN  GLY    43     -13.292  50.472   9.984  1.00  0.00
ATOM    378  CA  GLY    43     -13.333  48.655  11.068  1.00  0.00
ATOM    379  HA1 GLY    43     -13.985  48.453  11.906  1.00  0.00
ATOM    380  HA2 GLY    43     -12.365  48.951  11.446  1.00  0.00
ATOM    381  C   GLY    43     -13.167  47.383  10.264  1.00  0.00
ATOM    382  O   GLY    43     -12.919  46.319  10.828  1.00  0.00
ATOM    383  N   TYR    44     -13.292  47.490   8.943  1.00  0.00
ATOM    384  HN  TYR    44     -13.474  48.365   8.552  1.00  0.00
ATOM    385  CA  TYR    44     -13.151  46.329   8.071  1.00  0.00
ATOM    386  HA  TYR    44     -13.761  45.533   8.480  1.00  0.00
ATOM    387  CB  TYR    44     -13.634  46.650   6.644  1.00  0.00
ATOM    388  HB1 TYR    44     -12.949  47.348   6.181  1.00  0.00
ATOM    389  HB2 TYR    44     -14.613  47.103   6.698  1.00  0.00
ATOM    390  CG  TYR    44     -13.736  45.430   5.742  1.00  0.00
ATOM    391  CD1 TYR    44     -14.898  44.664   5.711  1.00  0.00
ATOM    392  HD1 TYR    44     -15.731  44.949   6.336  1.00  0.00
ATOM    393  CD2 TYR    44     -12.675  45.043   4.926  1.00  0.00
ATOM    394  HD2 TYR    44     -11.765  45.625   4.936  1.00  0.00
ATOM    395  CE1 TYR    44     -14.999  43.553   4.896  1.00  0.00
ATOM    396  HE1 TYR    44     -15.910  42.972   4.888  1.00  0.00
ATOM    397  CE2 TYR    44     -12.772  43.932   4.110  1.00  0.00
ATOM    398  HE2 TYR    44     -11.937  43.647   3.485  1.00  0.00
ATOM    399  CZ  TYR    44     -13.935  43.191   4.098  1.00  0.00
ATOM    400  OH  TYR    44     -14.035  42.084   3.285  1.00  0.00
ATOM    401  HH  TYR    44     -13.267  41.512   3.421  1.00  0.00
ATOM    402  C   TYR    44     -11.692  45.874   8.052  1.00  0.00
ATOM    403  O   TYR    44     -10.820  46.586   7.541  1.00  0.00
ATOM    404  N   THR    45     -11.440  44.710   8.635  1.00  0.00
ATOM    405  HN  THR    45     -12.181  44.224   9.056  1.00  0.00
ATOM    406  CA  THR    45     -10.111  44.123   8.690  1.00  0.00
ATOM    407  HA  THR    45      -9.436  44.742   8.108  1.00  0.00
ATOM    408  CB  THR    45      -9.598  44.072  10.151  1.00  0.00
ATOM    409  HB  THR    45     -10.307  43.509  10.743  1.00  0.00
ATOM    410  OG1 THR    45      -9.513  45.405  10.682  1.00  0.00
ATOM    411  HG1 THR    45     -10.178  45.513  11.373  1.00  0.00
ATOM    412  CG2 THR    45      -8.233  43.392  10.251  1.00  0.00
ATOM    413 HG21 THR    45      -7.903  43.395  11.280  1.00  0.00
ATOM    414 HG22 THR    45      -7.517  43.926   9.643  1.00  0.00
ATOM    415 HG23 THR    45      -8.311  42.372   9.903  1.00  0.00
ATOM    416  C   THR    45     -10.144  42.717   8.091  1.00  0.00
ATOM    417  O   THR    45     -11.064  41.940   8.359  1.00  0.00
ATOM    418  N   GLU    46      -9.150  42.411   7.270  1.00  0.00
ATOM    419  HN  GLU    46      -8.432  43.068   7.132  1.00  0.00
ATOM    420  CA  GLU    46      -9.061  41.127   6.581  1.00  0.00
ATOM    421  HA  GLU    46      -9.638  40.397   7.131  1.00  0.00
ATOM    422  CB  GLU    46      -9.617  41.256   5.152  1.00  0.00
ATOM    423  HB1 GLU    46      -9.027  41.987   4.614  1.00  0.00
ATOM    424  HB2 GLU    46     -10.638  41.607   5.206  1.00  0.00
ATOM    425  CG  GLU    46      -9.603  39.953   4.359  1.00  0.00
ATOM    426  HG1 GLU    46      -8.586  39.589   4.310  1.00  0.00
ATOM    427  HG2 GLU    46      -9.958  40.150   3.356  1.00  0.00
ATOM    428  CD  GLU    46     -10.477  38.876   4.981  1.00  0.00
ATOM    429  OE1 GLU    46      -9.978  38.115   5.835  1.00  0.00
ATOM    430  OE2 GLU    46     -11.665  38.779   4.610  1.00  0.00
ATOM    431  C   GLU    46      -7.603  40.695   6.546  1.00  0.00
ATOM    432  O   GLU    46      -6.725  41.538   6.470  1.00  0.00
ATOM    433  N   PHE    47      -7.333  39.399   6.601  1.00  0.00
ATOM    434  HN  PHE    47      -8.072  38.749   6.586  1.00  0.00
ATOM    435  CA  PHE    47      -5.950  38.917   6.656  1.00  0.00
ATOM    436  HA  PHE    47      -5.338  39.722   7.041  1.00  0.00
ATOM    437  CB  PHE    47      -5.833  37.719   7.606  1.00  0.00
ATOM    438  HB1 PHE    47      -4.848  37.284   7.507  1.00  0.00
ATOM    439  HB2 PHE    47      -6.574  36.980   7.337  1.00  0.00
ATOM    440  CG  PHE    47      -6.037  38.084   9.055  1.00  0.00
ATOM    441  CD1 PHE    47      -7.275  37.931   9.663  1.00  0.00
ATOM    442  HD1 PHE    47      -8.103  37.536   9.090  1.00  0.00
ATOM    443  CD2 PHE    47      -4.984  38.591   9.806  1.00  0.00
ATOM    444  HD2 PHE    47      -4.014  38.715   9.342  1.00  0.00
ATOM    445  CE1 PHE    47      -7.457  38.275  10.989  1.00  0.00
ATOM    446  HE1 PHE    47      -8.426  38.151  11.451  1.00  0.00
ATOM    447  CE2 PHE    47      -5.163  38.934  11.133  1.00  0.00
ATOM    448  HE2 PHE    47      -4.336  39.325  11.707  1.00  0.00
ATOM    449  CZ  PHE    47      -6.400  38.776  11.724  1.00  0.00
ATOM    450  HZ  PHE    47      -6.542  39.045  12.761  1.00  0.00
ATOM    451  C   PHE    47      -5.431  38.540   5.273  1.00  0.00
ATOM    452  O   PHE    47      -6.207  38.197   4.380  1.00  0.00
ATOM    453  N   LYS    48      -4.109  38.631   5.098  1.00  0.00
ATOM    454  HN  LYS    48      -3.558  39.035   5.806  1.00  0.00
ATOM    455  CA  LYS    48      -3.461  38.123   3.891  1.00  0.00
ATOM    456  HA  LYS    48      -3.984  38.527   3.032  1.00  0.00
ATOM    457  CB  LYS    48      -1.979  38.548   3.833  1.00  0.00
ATOM    458  HB1 LYS    48      -1.467  37.928   3.110  1.00  0.00
ATOM    459  HB2 LYS    48      -1.536  38.381   4.805  1.00  0.00
ATOM    460  CG  LYS    48      -1.748  40.015   3.454  1.00  0.00
ATOM    461  HG1 LYS    48      -0.734  40.287   3.714  1.00  0.00
ATOM    462  HG2 LYS    48      -2.437  40.634   4.012  1.00  0.00
ATOM    463  CD  LYS    48      -1.962  40.267   1.960  1.00  0.00
ATOM    464  HD1 LYS    48      -3.004  40.099   1.722  1.00  0.00
ATOM    465  HD2 LYS    48      -1.349  39.578   1.398  1.00  0.00
ATOM    466  CE  LYS    48      -1.588  41.694   1.562  1.00  0.00
ATOM    467  HE1 LYS    48      -0.547  41.862   1.800  1.00  0.00
ATOM    468  HE2 LYS    48      -2.200  42.386   2.122  1.00  0.00
ATOM    469  NZ  LYS    48      -1.795  41.935   0.107  1.00  0.00
ATOM    470  HZ1 LYS    48      -1.136  41.354  -0.450  1.00  0.00
ATOM    471  HZ2 LYS    48      -1.634  42.936  -0.124  1.00  0.00
ATOM    472  HZ3 LYS    48      -2.767  41.683  -0.163  1.00  0.00
ATOM    473  C   LYS    48      -3.585  36.600   3.875  1.00  0.00
ATOM    474  O   LYS    48      -2.753  35.890   4.447  1.00  0.00
END
