
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  133 ( 1004),  selected  133 , name 2cy9_B
# Molecule2: number of CA atoms  125 (  918),  selected  125 , name T0479.pdb
# PARAMETERS: 2cy9_B.T0479.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_B      T       6           -
LGA    S     2_B      -       -           -
LGA    S     3_B      -       -           -
LGA    X     4_B      -       -           -
LGA    T     5_B      -       -           -
LGA    Q     6_B      -       -           -
LGA    N     7_B      -       -           -
LGA    L     8_B      -       -           -
LGA    R     9_B      -       -           -
LGA    E    10_B      -       -           -
LGA    V    11_B      D       7          3.216
LGA    X    12_B      F       8          1.147
LGA    K    13_B      F       9           -
LGA    V    14_B      G      10           -
LGA    -       -      L      11           -
LGA    X    15_B      T      12          1.080
LGA    F    16_B      I      13          3.645
LGA    G    20_B      P      14          3.267
LGA    F    21_B      F      15          2.611
LGA    D    22_B      M      16          2.842
LGA    R    23_B      Q      17          2.955
LGA    V    24_B      L      18          2.610
LGA    L    25_B      L      19          2.944
LGA    E    26_B      G      20          2.336
LGA    K    27_B      -       -           -
LGA    V    28_B      V      21          1.828
LGA    T    29_B      V      22          2.092
LGA    L    30_B      P      23          2.680
LGA    V    31_B      E      24          2.843
LGA    S    32_B      H      25          2.929
LGA    A    33_B      S      26          2.792
LGA    A    34_B      G      27          3.095
LGA    P    35_B      N      28          1.621
LGA    E    36_B      G      29          1.112
LGA    K    37_B      T      30          1.291
LGA    L    38_B      A      31          1.162
LGA    I    39_B      R      32          1.511
LGA    C    40_B      T      33          1.883
LGA    E    41_B      R      34          1.836
LGA    X    42_B      L      35          1.874
LGA    K    43_B      P      36          2.260
LGA    V    44_B      A      37          2.103
LGA    E    45_B      R      38          1.021
LGA    E    46_B      A      39          1.102
LGA    Q    47_B      D      40          0.796
LGA    H    48_B      L      41          1.163
LGA    T    49_B      V      42          0.760
LGA    N    50_B      N      43          0.976
LGA    K    51_B      S      44          1.633
LGA    L    52_B      R      45          1.431
LGA    G    53_B      G      46          1.022
LGA    T    54_B      D      47          0.553
LGA    L    55_B      I      48          0.868
LGA    H    56_B      H      49          0.609
LGA    G    57_B      G      50          1.429
LGA    G    58_B      G      51          0.998
LGA    L    59_B      T      52          1.412
LGA    T    60_B      L      53          0.812
LGA    A    61_B      M      54          0.796
LGA    T    62_B      S      55          0.556
LGA    L    63_B      V      56          0.809
LGA    V    64_B      L      57          1.374
LGA    D    65_B      D      58          1.139
LGA    S    66_B      F      59          0.888
LGA    I    67_B      T      60          1.354
LGA    S    68_B      L      61          1.323
LGA    T    69_B      G      62          1.644
LGA    X    70_B      A      63          2.362
LGA    A    71_B      A      64          2.486
LGA    L    72_B      I      65          2.141
LGA    X    73_B      R      66          1.630
LGA    C    74_B      G      67          0.728
LGA    T    75_B      D      68          1.037
LGA    E    76_B      T      69          3.283
LGA    -       -      P      70           -
LGA    -       -      E      71           -
LGA    -       -      V      72           -
LGA    P    80_B      G      73          2.919
LGA    G    81_B      V      74          1.839
LGA    V    82_B      A      75          1.528
LGA    S    83_B      T      76          1.570
LGA    V    84_B      I      77          0.908
LGA    D    85_B      D      78          0.541
LGA    X    86_B      M      79          0.433
LGA    N    87_B      N      80          0.445
LGA    I    88_B      T      81          0.082
LGA    T    89_B      S      82          0.373
LGA    Y    90_B      F      83          0.356
LGA    X    91_B      M      84          0.376
LGA    S    92_B      S      85          0.413
LGA    P    93_B      P      86          0.610
LGA    A    94_B      G      87          1.165
LGA    K    95_B      R      88          2.316
LGA    I    96_B      -       -           -
LGA    G    97_B      -       -           -
LGA    E    98_B      G      89          0.864
LGA    E    99_B      D      90          1.422
LGA    I   100_B      L      91          0.761
LGA    V   101_B      V      92          0.847
LGA    I   102_B      I      93          0.566
LGA    T   103_B      E      94          0.402
LGA    A   104_B      T      95          0.809
LGA    H   105_B      R      96          0.639
LGA    I   106_B      C      97          0.815
LGA    L   107_B      L      98          0.827
LGA    K   108_B      R      99          1.179
LGA    Q   109_B      R     100          0.747
LGA    G   110_B      G     101          0.534
LGA    K   111_B      A     102          1.190
LGA    T   112_B      S     103          0.616
LGA    L   113_B      I     104          0.494
LGA    A   114_B      A     105          0.613
LGA    F   115_B      F     106          1.127
LGA    A   116_B      C     107          0.731
LGA    S   117_B      E     108          0.520
LGA    V   118_B      G     109          1.255
LGA    D   119_B      E     110          0.189
LGA    L   120_B      I     111          0.175
LGA    T   121_B      R     112          0.630
LGA    N   122_B      D     113          1.134
LGA    K   123_B      S     114          2.377
LGA    T   124_B      A     115          2.666
LGA    T   125_B      -       -           -
LGA    G   126_B      G     116          0.935
LGA    K   127_B      E     117          0.519
LGA    L   128_B      L     118          0.160
LGA    I   129_B      V     119          0.395
LGA    A   130_B      A     120          0.189
LGA    Q   131_B      K     121          0.322
LGA    G   132_B      A     122          0.491
LGA    R   133_B      T     123          0.642
LGA    H   134_B      A     124          0.996
LGA    T   135_B      T     125          0.726
LGA    K   136_B      F     126          0.857
LGA    H   137_B      K     127          1.109
LGA    L   138_B      I     128          1.609
LGA    G   139_B      I     129          3.043
LGA    -       -      Q     130           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  133  125    5.0    117    1.59    20.51     85.768     6.938

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.725358 * X  +  -0.428306 * Y  +  -0.538897 * Z  +  71.543274
  Y_new =   0.338375 * X  +  -0.903597 * Y  +   0.262709 * Z  +  69.633667
  Z_new =  -0.599465 * X  +   0.008209 * Y  +   0.800359 * Z  +  43.375271 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.010256   -3.131337  [ DEG:     0.5876   -179.4124 ]
  Theta =   0.642833    2.498760  [ DEG:    36.8316    143.1684 ]
  Phi   =   2.705107   -0.436485  [ DEG:   154.9912    -25.0088 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2cy9_B                                        
REMARK     2: T0479.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2cy9_B.T0479.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  133  125   5.0  117   1.59   20.51  85.768
REMARK  ---------------------------------------------------------- 
MOLECULE 2cy9_B
HEADER    HYDROLASE                               06-JUL-05   2CY9              
TITLE     CRYSTAL STRUCTURE OF THIOESTERASE SUPERFAMILY MEMBER2 FROM            
TITLE    2 MUS MUSCULUS                                                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: THIOESTERASE SUPERFAMILY MEMBER 2;                         
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: MS0341;                                                     
COMPND   5 EC: 3.1.2.-;                                                         
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MUS MUSCULUS;                                   
SOURCE   3 ORGANISM_COMMON: MOUSE;                                              
SOURCE   4 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   5 EXPRESSION_SYSTEM_PLASMID: PX040902-05;                              
SOURCE   6 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    STRUCTURAL GENOMICS, THIOESTERASE SUPERFAMILY MEMBER 2,               
KEYWDS   2 NPPSFA, NATIONAL PROJECT ON PROTEIN STRUCTURAL AND                   
KEYWDS   3 FUNCTIONAL ANALYSES, RIKEN STRUCTURAL GENOMICS/PROTEOMICS            
KEYWDS   4 INITIATIVE, RSGI                                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    T.HOSAKA,K.MURAYAMA,S.KISHISHITA,M.SHIROUZU,S.YOKOYAMA,               
AUTHOR   2 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)               
REVDAT   1   06-JAN-06 2CY9    0                                                
JRNL        AUTH   T.HOSAKA,K.MURAYAMA,S.KISHISHITA,M.SHIROUZU,                 
JRNL        AUTH 2 S.YOKOYAMA                                                   
JRNL        TITL   CRYSTAL STRUCTURE OF THIOESTERASE SUPERFAMILY                
JRNL        TITL 2 MEMBER2 FROM MUS MUSCULUS                                    
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.72 ANGSTROMS.                                          
DBREF  2CY9 A    1   140  UNP    Q9CQR4   THEM2_MOUSE      1    140             
DBREF  2CY9 B    1   140  UNP    Q9CQR4   THEM2_MOUSE      1    140             
SEQRES   1 A  140  MSE SER SER MSE THR GLN ASN LEU ARG GLU VAL MSE LYS          
SEQRES   2 A  140  VAL MSE PHE LYS VAL PRO GLY PHE ASP ARG VAL LEU GLU          
SEQRES   3 A  140  LYS VAL THR LEU VAL SER ALA ALA PRO GLU LYS LEU ILE          
SEQRES   4 A  140  CYS GLU MSE LYS VAL GLU GLU GLN HIS THR ASN LYS LEU          
SEQRES   5 A  140  GLY THR LEU HIS GLY GLY LEU THR ALA THR LEU VAL ASP          
SEQRES   6 A  140  SER ILE SER THR MSE ALA LEU MSE CYS THR GLU ARG GLY          
SEQRES   7 A  140  ALA PRO GLY VAL SER VAL ASP MSE ASN ILE THR TYR MSE          
SEQRES   8 A  140  SER PRO ALA LYS ILE GLY GLU GLU ILE VAL ILE THR ALA          
SEQRES   9 A  140  HIS ILE LEU LYS GLN GLY LYS THR LEU ALA PHE ALA SER          
SEQRES  10 A  140  VAL ASP LEU THR ASN LYS THR THR GLY LYS LEU ILE ALA          
SEQRES  11 A  140  GLN GLY ARG HIS THR LYS HIS LEU GLY ASN                      
SEQRES   1 B  140  MSE SER SER MSE THR GLN ASN LEU ARG GLU VAL MSE LYS          
SEQRES   2 B  140  VAL MSE PHE LYS VAL PRO GLY PHE ASP ARG VAL LEU GLU          
SEQRES   3 B  140  LYS VAL THR LEU VAL SER ALA ALA PRO GLU LYS LEU ILE          
SEQRES   4 B  140  CYS GLU MSE LYS VAL GLU GLU GLN HIS THR ASN LYS LEU          
SEQRES   5 B  140  GLY THR LEU HIS GLY GLY LEU THR ALA THR LEU VAL ASP          
SEQRES   6 B  140  SER ILE SER THR MSE ALA LEU MSE CYS THR GLU ARG GLY          
SEQRES   7 B  140  ALA PRO GLY VAL SER VAL ASP MSE ASN ILE THR TYR MSE          
SEQRES   8 B  140  SER PRO ALA LYS ILE GLY GLU GLU ILE VAL ILE THR ALA          
SEQRES   9 B  140  HIS ILE LEU LYS GLN GLY LYS THR LEU ALA PHE ALA SER          
SEQRES  10 B  140  VAL ASP LEU THR ASN LYS THR THR GLY LYS LEU ILE ALA          
SEQRES  11 B  140  GLN GLY ARG HIS THR LYS HIS LEU GLY ASN                      
HET    MSE  A  15       8                                                       
HET    MSE  A  42       8                                                       
HET    MSE  A  70       8                                                       
HET    MSE  A  73       8                                                       
HET    MSE  A  86       8                                                       
HET    MSE  A  91       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B   4       8                                                       
HET    MSE  B  12       8                                                       
HET    MSE  B  15       8                                                       
HET    MSE  B  42       8                                                       
HET    MSE  B  70       8                                                       
HET    MSE  B  73       8                                                       
HET    MSE  B  86       8                                                       
HET    MSE  B  91       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    15(C5 H11 N O2 SE)                                           
FORMUL   3  HOH   *43(H2 O)                                                     
CRYST1   66.522   90.195   61.210  90.00 118.32  90.00 C 1 2 1       8          
HETATM  914  N   MSE B   1      35.312  43.725  20.281  1.00 59.63           N  
HETATM  915  CA  MSE B   1      34.592  44.928  19.621  1.00 58.25           C  
HETATM  916  C   MSE B   1      33.770  45.481  20.634  1.00 58.03           C  
HETATM  917  O   MSE B   1      32.861  46.245  20.259  1.00 59.80           O  
HETATM  918  CB  MSE B   1      33.561  44.711  18.499  1.00 55.63           C  
HETATM  919  CG  MSE B   1      34.062  44.912  17.114  1.00 59.21           C  
HETATM  920 SE   MSE B   1      35.666  45.558  16.721  1.00 39.79          SE  
HETATM  921  CE  MSE B   1      35.140  46.427  15.655  1.00 51.23           C  
ATOM    922  N   SER B   2      33.984  45.119  21.862  1.00 57.53           N  
ATOM    923  CA  SER B   2      33.097  45.746  22.802  1.00 59.20           C  
ATOM    924  C   SER B   2      33.691  46.239  24.021  1.00 62.16           C  
ATOM    925  O   SER B   2      34.689  45.740  24.606  1.00 63.23           O  
ATOM    926  CB  SER B   2      32.018  44.843  23.118  1.00 58.58           C  
ATOM    927  OG  SER B   2      32.497  43.862  23.768  1.00 49.42           O  
ATOM    928  N   SER B   3      33.315  47.382  24.387  1.00 65.11           N  
ATOM    929  CA  SER B   3      34.379  47.788  25.318  1.00 68.51           C  
ATOM    930  C   SER B   3      33.637  47.847  26.576  1.00 67.33           C  
ATOM    931  O   SER B   3      33.317  49.053  27.005  1.00 68.60           O  
ATOM    932  CB  SER B   3      34.999  49.131  24.884  1.00 71.61           C  
ATOM    933  OG  SER B   3      36.254  48.977  24.003  1.00 77.95           O  
HETATM  934  N   MSE B   4      33.181  46.603  27.049  1.00 61.74           N  
HETATM  935  CA  MSE B   4      32.226  46.511  28.194  1.00 54.63           C  
HETATM  936  C   MSE B   4      33.008  46.749  29.538  1.00 48.80           C  
HETATM  937  O   MSE B   4      32.550  47.425  30.505  1.00 45.06           O  
HETATM  938  CB  MSE B   4      31.463  45.169  28.097  1.00 56.06           C  
HETATM  939  CG  MSE B   4      30.397  44.863  29.242  1.00 55.59           C  
HETATM  940 SE   MSE B   4      29.496  43.248  29.071  1.00 43.19          SE  
HETATM  941  CE  MSE B   4      28.209  43.745  28.049  1.00 47.21           C  
ATOM    942  N   THR B   5      34.212  46.213  29.564  1.00 42.26           N  
ATOM    943  CA  THR B   5      34.969  46.394  30.639  1.00 43.55           C  
ATOM    944  C   THR B   5      35.382  47.794  30.847  1.00 47.14           C  
ATOM    945  O   THR B   5      35.295  48.227  32.117  1.00 49.89           O  
ATOM    946  CB  THR B   5      36.075  45.416  30.893  1.00 42.49           C  
ATOM    947  OG1 THR B   5      36.939  45.967  32.022  1.00 48.68           O  
ATOM    948  CG2 THR B   5      36.987  45.363  29.941  1.00 49.02           C  
ATOM    949  N   GLN B   6      35.889  48.487  29.763  1.00 50.32           N  
ATOM    950  CA  GLN B   6      36.123  49.955  29.692  1.00 53.41           C  
ATOM    951  C   GLN B   6      34.878  50.780  30.090  1.00 52.19           C  
ATOM    952  O   GLN B   6      34.875  51.701  30.908  1.00 52.46           O  
ATOM    953  CB  GLN B   6      36.550  50.324  28.262  1.00 55.32           C  
ATOM    954  CG  GLN B   6      37.946  49.779  28.045  1.00 66.50           C  
ATOM    955  CD  GLN B   6      37.918  48.463  27.104  1.00 82.91           C  
ATOM    956  OE1 GLN B   6      37.703  47.330  27.598  1.00 90.10           O  
ATOM    957  NE2 GLN B   6      38.216  48.628  25.730  1.00 91.54           N  
ATOM    958  N   ASN B   7      33.828  50.476  29.415  1.00 51.77           N  
ATOM    959  CA  ASN B   7      32.556  51.117  29.614  1.00 53.01           C  
ATOM    960  C   ASN B   7      31.884  51.036  30.959  1.00 50.67           C  
ATOM    961  O   ASN B   7      31.024  51.844  31.359  1.00 48.27           O  
ATOM    962  CB  ASN B   7      31.617  50.544  28.501  1.00 56.43           C  
ATOM    963  CG  ASN B   7      30.953  51.677  27.467  1.00 59.57           C  
ATOM    964  OD1 ASN B   7      30.457  51.267  26.413  1.00 69.43           O  
ATOM    965  ND2 ASN B   7      30.812  52.975  27.879  1.00 71.34           N  
ATOM    966  N   LEU B   8      32.281  50.051  31.728  1.00 51.41           N  
ATOM    967  CA  LEU B   8      31.625  49.898  33.021  1.00 49.65           C  
ATOM    968  C   LEU B   8      32.453  50.651  33.941  1.00 48.67           C  
ATOM    969  O   LEU B   8      31.990  51.225  34.818  1.00 48.09           O  
ATOM    970  CB  LEU B   8      31.482  48.397  33.360  1.00 50.98           C  
ATOM    971  CG  LEU B   8      30.252  47.794  34.053  1.00 49.68           C  
ATOM    972  CD1 LEU B   8      30.641  46.671  35.074  1.00 47.10           C  
ATOM    973  CD2 LEU B   8      29.429  48.837  34.799  1.00 48.03           C  
ATOM    974  N   ARG B   9      33.731  50.621  33.718  1.00 49.94           N  
ATOM    975  CA  ARG B   9      34.660  51.447  34.344  1.00 51.19           C  
ATOM    976  C   ARG B   9      34.256  52.896  34.328  1.00 53.65           C  
ATOM    977  O   ARG B   9      34.315  53.517  35.339  1.00 56.27           O  
ATOM    978  CB  ARG B   9      35.906  51.313  33.592  1.00 52.54           C  
ATOM    979  CG  ARG B   9      37.181  51.901  34.274  1.00 54.93           C  
ATOM    980  CD  ARG B   9      38.341  50.818  34.425  1.00 47.68           C  
ATOM    981  NE  ARG B   9      38.678  50.326  33.113  1.00 49.09           N  
ATOM    982  CZ  ARG B   9      39.332  49.209  32.922  1.00 54.41           C  
ATOM    983  NH1 ARG B   9      39.590  48.480  33.928  1.00 53.91           N  
ATOM    984  NH2 ARG B   9      39.659  48.761  31.713  1.00 61.26           N  
ATOM    985  N   GLU B  10      33.775  53.477  33.260  1.00 53.67           N  
ATOM    986  CA  GLU B  10      33.113  54.739  33.481  1.00 56.15           C  
ATOM    987  C   GLU B  10      31.755  54.847  34.134  1.00 53.59           C  
ATOM    988  O   GLU B  10      31.636  55.641  35.095  1.00 57.35           O  
ATOM    989  CB  GLU B  10      33.038  55.601  32.207  1.00 59.35           C  
ATOM    990  CG  GLU B  10      34.487  55.888  31.570  1.00 71.26           C  
ATOM    991  CD  GLU B  10      35.580  56.309  32.611  1.00 82.02           C  
ATOM    992  OE1 GLU B  10      36.644  55.518  32.846  1.00 88.29           O  
ATOM    993  OE2 GLU B  10      35.273  57.431  33.233  1.00 84.28           O  
ATOM    994  N   VAL B  11      30.731  54.134  33.687  1.00 49.18           N  
ATOM    995  CA  VAL B  11      29.471  54.152  34.482  1.00 46.03           C  
ATOM    996  C   VAL B  11      29.863  54.037  36.041  1.00 44.62           C  
ATOM    997  O   VAL B  11      29.407  54.761  36.832  1.00 42.00           O  
ATOM    998  CB  VAL B  11      28.613  52.955  34.015  1.00 46.33           C  
ATOM    999  CG1 VAL B  11      27.554  52.450  35.054  1.00 36.27           C  
ATOM   1000  CG2 VAL B  11      27.917  53.133  32.730  1.00 43.72           C  
HETATM 1001  N   MSE B  12      30.725  53.120  36.471  1.00 44.56           N  
HETATM 1002  CA  MSE B  12      30.915  52.917  37.878  1.00 46.70           C  
HETATM 1003  C   MSE B  12      31.413  54.250  38.453  1.00 52.24           C  
HETATM 1004  O   MSE B  12      30.813  54.792  39.425  1.00 52.73           O  
HETATM 1005  CB  MSE B  12      31.911  51.826  38.106  1.00 44.95           C  
HETATM 1006  CG  MSE B  12      31.334  50.334  37.955  1.00 45.78           C  
HETATM 1007 SE   MSE B  12      32.448  48.961  38.179  1.00 40.96          SE  
HETATM 1008  CE  MSE B  12      33.231  49.295  39.744  1.00 52.14           C  
ATOM   1009  N   LYS B  13      32.574  54.738  37.860  1.00 56.68           N  
ATOM   1010  CA  LYS B  13      33.359  55.901  38.402  1.00 56.85           C  
ATOM   1011  C   LYS B  13      32.383  57.193  38.493  1.00 54.27           C  
ATOM   1012  O   LYS B  13      32.459  57.890  39.504  1.00 54.95           O  
ATOM   1013  CB  LYS B  13      34.696  56.203  37.678  1.00 56.25           C  
ATOM   1014  CG  LYS B  13      34.369  57.048  36.487  1.00 66.08           C  
ATOM   1015  CD  LYS B  13      34.519  58.705  36.478  1.00 68.59           C  
ATOM   1016  CE  LYS B  13      33.988  59.368  34.933  1.00 68.18           C  
ATOM   1017  NZ  LYS B  13      33.617  60.957  34.808  1.00 56.27           N  
ATOM   1018  N   VAL B  14      31.463  57.385  37.560  1.00 49.16           N  
ATOM   1019  CA  VAL B  14      30.415  58.291  37.748  1.00 47.47           C  
ATOM   1020  C   VAL B  14      29.630  57.963  38.936  1.00 52.34           C  
ATOM   1021  O   VAL B  14      29.587  58.804  39.885  1.00 58.65           O  
ATOM   1022  CB  VAL B  14      29.558  58.265  36.587  1.00 47.92           C  
ATOM   1023  CG1 VAL B  14      27.987  58.940  36.787  1.00 42.32           C  
ATOM   1024  CG2 VAL B  14      30.398  58.856  35.405  1.00 45.19           C  
HETATM 1025  N   MSE B  15      29.030  56.787  39.082  1.00 53.51           N  
HETATM 1026  CA  MSE B  15      28.064  56.626  40.178  1.00 54.57           C  
HETATM 1027  C   MSE B  15      28.588  56.317  41.551  1.00 54.79           C  
HETATM 1028  O   MSE B  15      27.901  56.257  42.530  1.00 58.54           O  
HETATM 1029  CB  MSE B  15      26.965  55.700  39.770  1.00 55.37           C  
HETATM 1030  CG  MSE B  15      27.466  54.501  38.905  1.00 65.63           C  
HETATM 1031 SE   MSE B  15      26.110  53.324  38.050  1.00 74.20          SE  
HETATM 1032  CE  MSE B  15      24.836  54.877  38.107  1.00 79.34           C  
ATOM   1033  N   PHE B  16      29.833  56.162  41.697  1.00 55.39           N  
ATOM   1034  CA  PHE B  16      30.403  56.169  42.973  1.00 56.93           C  
ATOM   1035  C   PHE B  16      31.068  57.600  43.323  1.00 58.67           C  
ATOM   1036  O   PHE B  16      31.238  58.812  42.661  1.00 64.02           O  
ATOM   1037  CB  PHE B  16      31.433  55.050  42.956  1.00 58.58           C  
ATOM   1038  CG  PHE B  16      30.895  53.734  42.559  1.00 59.18           C  
ATOM   1039  CD1 PHE B  16      31.765  52.538  42.648  1.00 67.60           C  
ATOM   1040  CD2 PHE B  16      29.560  53.545  42.291  1.00 64.75           C  
ATOM   1041  CE1 PHE B  16      31.279  51.083  42.409  1.00 57.60           C  
ATOM   1042  CE2 PHE B  16      29.024  52.130  42.064  1.00 66.88           C  
ATOM   1043  CZ  PHE B  16      29.920  50.926  42.133  1.00 63.09           C  
ATOM   1044  N   GLY B  20      25.897  60.277  47.722  1.00 50.28           N  
ATOM   1045  CA  GLY B  20      25.207  58.925  47.713  1.00 50.01           C  
ATOM   1046  C   GLY B  20      25.813  57.904  48.620  1.00 49.25           C  
ATOM   1047  O   GLY B  20      26.747  58.240  49.259  1.00 52.69           O  
ATOM   1048  N   PHE B  21      25.239  56.721  48.858  1.00 46.27           N  
ATOM   1049  CA  PHE B  21      25.913  55.833  49.797  1.00 36.45           C  
ATOM   1050  C   PHE B  21      26.929  55.192  48.986  1.00 37.39           C  
ATOM   1051  O   PHE B  21      28.097  54.956  49.504  1.00 39.15           O  
ATOM   1052  CB  PHE B  21      24.965  54.904  50.417  1.00 31.57           C  
ATOM   1053  CG  PHE B  21      25.626  53.926  51.471  1.00 30.86           C  
ATOM   1054  CD1 PHE B  21      25.917  52.575  51.146  1.00 29.08           C  
ATOM   1055  CD2 PHE B  21      26.016  54.339  52.728  1.00 15.17           C  
ATOM   1056  CE1 PHE B  21      26.513  51.669  52.185  1.00 32.58           C  
ATOM   1057  CE2 PHE B  21      26.621  53.543  53.645  1.00 32.20           C  
ATOM   1058  CZ  PHE B  21      26.915  52.199  53.402  1.00 32.34           C  
ATOM   1059  N   ASP B  22      26.631  54.898  47.753  1.00 39.06           N  
ATOM   1060  CA  ASP B  22      27.595  54.080  46.859  1.00 47.97           C  
ATOM   1061  C   ASP B  22      29.115  54.770  46.640  1.00 47.98           C  
ATOM   1062  O   ASP B  22      30.201  54.340  46.072  1.00 39.05           O  
ATOM   1063  CB  ASP B  22      26.978  53.814  45.333  1.00 51.29           C  
ATOM   1064  CG  ASP B  22      25.622  52.838  45.285  1.00 62.60           C  
ATOM   1065  OD1 ASP B  22      25.716  51.487  45.630  1.00 72.82           O  
ATOM   1066  OD2 ASP B  22      24.409  53.315  44.917  1.00 75.28           O  
ATOM   1067  N   ARG B  23      29.062  55.987  47.100  1.00 52.06           N  
ATOM   1068  CA  ARG B  23      30.266  56.852  47.115  1.00 52.03           C  
ATOM   1069  C   ARG B  23      31.177  56.214  48.107  1.00 47.02           C  
ATOM   1070  O   ARG B  23      32.273  56.557  47.989  1.00 44.51           O  
ATOM   1071  CB  ARG B  23      29.837  58.336  47.379  1.00 54.03           C  
ATOM   1072  CG  ARG B  23      30.350  58.507  48.892  1.00 63.56           C  
ATOM   1073  CD  ARG B  23      29.335  58.637  50.198  1.00 70.83           C  
ATOM   1074  NE  ARG B  23      29.811  58.557  51.609  1.00 63.12           N  
ATOM   1075  CZ  ARG B  23      28.889  58.408  52.566  1.00 62.97           C  
ATOM   1076  NH1 ARG B  23      27.555  58.376  52.190  1.00 57.62           N  
ATOM   1077  NH2 ARG B  23      29.281  58.305  53.862  1.00 65.31           N  
ATOM   1078  N   VAL B  24      30.736  55.232  48.938  1.00 42.75           N  
ATOM   1079  CA  VAL B  24      31.698  54.532  49.780  1.00 46.04           C  
ATOM   1080  C   VAL B  24      32.568  53.527  49.085  1.00 46.33           C  
ATOM   1081  O   VAL B  24      33.344  52.786  49.728  1.00 40.53           O  
ATOM   1082  CB  VAL B  24      31.024  53.828  50.910  1.00 49.10           C  
ATOM   1083  CG1 VAL B  24      30.217  54.978  51.751  1.00 53.30           C  
ATOM   1084  CG2 VAL B  24      29.897  52.735  50.402  1.00 53.07           C  
ATOM   1085  N   LEU B  25      32.390  53.455  47.755  1.00 48.88           N  
ATOM   1086  CA  LEU B  25      33.074  52.386  47.065  1.00 51.57           C  
ATOM   1087  C   LEU B  25      34.092  52.970  46.102  1.00 53.98           C  
ATOM   1088  O   LEU B  25      33.957  52.767  44.952  1.00 56.79           O  
ATOM   1089  CB  LEU B  25      32.007  51.500  46.306  1.00 51.57           C  
ATOM   1090  CG  LEU B  25      30.926  50.734  47.167  1.00 52.09           C  
ATOM   1091  CD1 LEU B  25      29.732  50.314  46.378  1.00 54.11           C  
ATOM   1092  CD2 LEU B  25      31.459  49.495  47.941  1.00 49.51           C  
ATOM   1093  N   GLU B  26      35.008  53.821  46.519  1.00 55.16           N  
ATOM   1094  CA  GLU B  26      35.631  54.752  45.542  1.00 54.42           C  
ATOM   1095  C   GLU B  26      36.894  54.059  45.319  1.00 52.53           C  
ATOM   1096  O   GLU B  26      37.439  54.100  44.289  1.00 49.33           O  
ATOM   1097  CB  GLU B  26      35.948  56.237  46.058  1.00 55.88           C  
ATOM   1098  CG  GLU B  26      34.723  57.143  46.049  1.00 66.57           C  
ATOM   1099  CD  GLU B  26      34.717  58.643  46.532  1.00 74.18           C  
ATOM   1100  OE1 GLU B  26      34.928  58.864  47.804  1.00 77.31           O  
ATOM   1101  OE2 GLU B  26      34.220  59.530  45.678  1.00 71.81           O  
ATOM   1102  N   LYS B  27      37.420  53.457  46.333  1.00 53.69           N  
ATOM   1103  CA  LYS B  27      38.729  52.836  46.132  1.00 56.73           C  
ATOM   1104  C   LYS B  27      38.596  51.454  45.332  1.00 56.82           C  
ATOM   1105  O   LYS B  27      39.455  50.494  45.567  1.00 56.12           O  
ATOM   1106  CB  LYS B  27      39.503  52.553  47.471  1.00 56.71           C  
ATOM   1107  CG  LYS B  27      40.145  53.655  48.069  1.00 59.45           C  
ATOM   1108  CD  LYS B  27      39.601  55.096  47.667  1.00 63.51           C  
ATOM   1109  CE  LYS B  27      40.713  56.247  47.966  1.00 65.87           C  
ATOM   1110  NZ  LYS B  27      41.339  56.590  46.697  1.00 68.66           N  
ATOM   1111  N   VAL B  28      37.525  51.361  44.525  1.00 54.89           N  
ATOM   1112  CA  VAL B  28      37.195  50.122  44.002  1.00 55.68           C  
ATOM   1113  C   VAL B  28      37.423  50.008  42.559  1.00 52.63           C  
ATOM   1114  O   VAL B  28      36.731  50.524  41.839  1.00 54.38           O  
ATOM   1115  CB  VAL B  28      35.741  49.693  44.396  1.00 59.02           C  
ATOM   1116  CG1 VAL B  28      34.587  50.318  43.370  1.00 69.86           C  
ATOM   1117  CG2 VAL B  28      35.544  48.226  44.184  1.00 59.77           C  
ATOM   1118  N   THR B  29      38.289  49.152  42.122  1.00 52.23           N  
ATOM   1119  CA  THR B  29      38.517  48.898  40.747  1.00 52.27           C  
ATOM   1120  C   THR B  29      37.677  47.777  40.078  1.00 48.75           C  
ATOM   1121  O   THR B  29      37.500  46.828  40.602  1.00 48.75           O  
ATOM   1122  CB  THR B  29      40.042  48.594  40.614  1.00 53.89           C  
ATOM   1123  OG1 THR B  29      40.336  47.939  39.334  1.00 67.03           O  
ATOM   1124  CG2 THR B  29      40.607  47.628  41.573  1.00 56.68           C  
ATOM   1125  N   LEU B  30      37.344  47.931  38.869  1.00 46.08           N  
ATOM   1126  CA  LEU B  30      36.856  46.908  37.982  1.00 48.60           C  
ATOM   1127  C   LEU B  30      38.020  46.319  37.170  1.00 49.37           C  
ATOM   1128  O   LEU B  30      38.577  47.142  36.456  1.00 51.19           O  
ATOM   1129  CB  LEU B  30      35.895  47.548  36.904  1.00 47.90           C  
ATOM   1130  CG  LEU B  30      35.581  46.845  35.592  1.00 49.17           C  
ATOM   1131  CD1 LEU B  30      35.362  45.384  35.938  1.00 50.15           C  
ATOM   1132  CD2 LEU B  30      34.242  47.413  34.897  1.00 43.30           C  
ATOM   1133  N   VAL B  31      38.335  44.999  37.252  1.00 45.96           N  
ATOM   1134  CA  VAL B  31      39.274  44.447  36.422  1.00 45.11           C  
ATOM   1135  C   VAL B  31      38.697  43.800  35.145  1.00 49.83           C  
ATOM   1136  O   VAL B  31      39.437  43.472  34.163  1.00 49.77           O  
ATOM   1137  CB  VAL B  31      40.143  43.464  37.277  1.00 46.71           C  
ATOM   1138  CG1 VAL B  31      39.926  43.636  38.609  1.00 43.92           C  
ATOM   1139  CG2 VAL B  31      40.132  42.010  36.840  1.00 44.58           C  
ATOM   1140  N   SER B  32      37.412  43.472  35.152  1.00 50.94           N  
ATOM   1141  CA  SER B  32      36.890  42.684  34.054  1.00 51.71           C  
ATOM   1142  C   SER B  32      35.384  42.560  34.149  1.00 50.24           C  
ATOM   1143  O   SER B  32      34.958  42.455  35.210  1.00 48.08           O  
ATOM   1144  CB  SER B  32      37.375  41.253  34.058  1.00 53.15           C  
ATOM   1145  OG  SER B  32      36.453  40.530  33.198  1.00 60.93           O  
ATOM   1146  N   ALA B  33      34.695  42.746  33.006  1.00 51.40           N  
ATOM   1147  CA  ALA B  33      33.243  42.827  32.805  1.00 55.70           C  
ATOM   1148  C   ALA B  33      32.845  41.984  31.557  1.00 56.21           C  
ATOM   1149  O   ALA B  33      32.884  42.427  30.446  1.00 58.83           O  
ATOM   1150  CB  ALA B  33      32.608  44.248  32.659  1.00 55.56           C  
ATOM   1151  N   ALA B  34      32.480  40.747  31.832  1.00 56.75           N  
ATOM   1152  CA  ALA B  34      31.867  39.783  30.958  1.00 54.10           C  
ATOM   1153  C   ALA B  34      30.357  40.060  30.926  1.00 54.99           C  
ATOM   1154  O   ALA B  34      29.802  40.866  31.606  1.00 54.34           O  
ATOM   1155  CB  ALA B  34      32.212  38.367  31.510  1.00 54.51           C  
ATOM   1156  N   PRO B  35      29.635  39.361  30.116  1.00 57.22           N  
ATOM   1157  CA  PRO B  35      28.205  39.520  30.085  1.00 55.97           C  
ATOM   1158  C   PRO B  35      27.612  38.733  31.116  1.00 54.92           C  
ATOM   1159  O   PRO B  35      26.572  39.184  31.334  1.00 54.24           O  
ATOM   1160  CB  PRO B  35      27.870  39.061  28.740  1.00 56.69           C  
ATOM   1161  CG  PRO B  35      28.822  38.056  28.447  1.00 62.10           C  
ATOM   1162  CD  PRO B  35      30.059  38.271  29.249  1.00 59.64           C  
ATOM   1163  N   GLU B  36      28.211  37.704  31.759  1.00 55.94           N  
ATOM   1164  CA  GLU B  36      27.702  37.196  33.111  1.00 57.45           C  
ATOM   1165  C   GLU B  36      28.528  37.145  34.376  1.00 52.52           C  
ATOM   1166  O   GLU B  36      28.076  37.076  35.450  1.00 55.95           O  
ATOM   1167  CB  GLU B  36      27.059  35.759  33.007  1.00 62.40           C  
ATOM   1168  CG  GLU B  36      25.433  35.693  32.732  1.00 69.94           C  
ATOM   1169  CD  GLU B  36      24.804  35.992  31.236  1.00 84.04           C  
ATOM   1170  OE1 GLU B  36      24.051  37.157  30.994  1.00 81.08           O  
ATOM   1171  OE2 GLU B  36      25.033  35.045  30.308  1.00 87.78           O  
ATOM   1172  N   LYS B  37      29.786  37.150  34.245  1.00 48.10           N  
ATOM   1173  CA  LYS B  37      30.799  37.285  35.339  1.00 42.78           C  
ATOM   1174  C   LYS B  37      31.416  38.822  35.376  1.00 38.15           C  
ATOM   1175  O   LYS B  37      31.762  39.543  34.395  1.00 29.79           O  
ATOM   1176  CB  LYS B  37      31.958  36.356  34.951  1.00 40.09           C  
ATOM   1177  CG  LYS B  37      32.683  36.073  36.103  1.00 50.75           C  
ATOM   1178  CD  LYS B  37      34.150  35.758  35.777  1.00 58.56           C  
ATOM   1179  CE  LYS B  37      34.792  34.266  35.770  1.00 63.57           C  
ATOM   1180  NZ  LYS B  37      36.414  34.149  36.079  1.00 63.33           N  
ATOM   1181  N   LEU B  38      31.661  39.238  36.579  1.00 35.40           N  
ATOM   1182  CA  LEU B  38      32.297  40.486  36.737  1.00 37.11           C  
ATOM   1183  C   LEU B  38      33.368  40.481  37.738  1.00 37.41           C  
ATOM   1184  O   LEU B  38      33.224  39.967  38.838  1.00 35.80           O  
ATOM   1185  CB  LEU B  38      31.212  41.616  36.842  1.00 38.90           C  
ATOM   1186  CG  LEU B  38      31.516  42.948  37.245  1.00 40.19           C  
ATOM   1187  CD1 LEU B  38      30.158  43.750  37.292  1.00 41.14           C  
ATOM   1188  CD2 LEU B  38      32.126  42.719  38.823  1.00 42.45           C  
ATOM   1189  N   ILE B  39      34.501  41.037  37.372  1.00 38.47           N  
ATOM   1190  CA  ILE B  39      35.583  41.105  38.384  1.00 42.34           C  
ATOM   1191  C   ILE B  39      35.980  42.519  38.756  1.00 42.76           C  
ATOM   1192  O   ILE B  39      36.300  43.317  37.885  1.00 45.00           O  
ATOM   1193  CB  ILE B  39      36.793  40.573  37.876  1.00 43.86           C  
ATOM   1194  CG1 ILE B  39      36.464  39.338  36.979  1.00 53.58           C  
ATOM   1195  CG2 ILE B  39      37.646  40.162  38.968  1.00 45.63           C  
ATOM   1196  CD1 ILE B  39      36.499  38.156  37.651  1.00 55.34           C  
ATOM   1197  N   CYS B  40      36.236  42.617  40.026  1.00 41.04           N  
ATOM   1198  CA  CYS B  40      36.675  43.728  40.728  1.00 41.73           C  
ATOM   1199  C   CYS B  40      37.743  43.447  41.749  1.00 38.58           C  
ATOM   1200  O   CYS B  40      37.929  42.358  42.141  1.00 35.82           O  
ATOM   1201  CB  CYS B  40      35.427  44.359  41.383  1.00 42.26           C  
ATOM   1202  SG  CYS B  40      34.418  45.462  40.321  1.00 57.65           S  
ATOM   1203  N   GLU B  41      38.587  44.461  42.012  1.00 43.94           N  
ATOM   1204  CA  GLU B  41      39.515  44.445  43.265  1.00 47.26           C  
ATOM   1205  C   GLU B  41      39.499  45.597  44.183  1.00 45.85           C  
ATOM   1206  O   GLU B  41      38.951  46.579  43.837  1.00 47.90           O  
ATOM   1207  CB  GLU B  41      40.887  44.246  42.865  1.00 48.40           C  
ATOM   1208  CG  GLU B  41      41.151  42.808  42.426  1.00 59.13           C  
ATOM   1209  CD  GLU B  41      41.740  42.752  41.038  1.00 74.44           C  
ATOM   1210  OE1 GLU B  41      40.979  42.035  40.320  1.00 81.65           O  
ATOM   1211  OE2 GLU B  41      42.912  43.431  40.686  1.00 91.28           O  
HETATM 1212  N   MSE B  42      39.942  45.485  45.370  1.00 46.22           N  
HETATM 1213  CA  MSE B  42      39.921  46.615  46.193  1.00 48.92           C  
HETATM 1214  C   MSE B  42      40.917  46.276  47.331  1.00 53.71           C  
HETATM 1215  O   MSE B  42      40.754  45.422  48.137  1.00 55.23           O  
HETATM 1216  CB  MSE B  42      38.511  46.883  46.605  1.00 47.15           C  
HETATM 1217  CG  MSE B  42      38.344  47.078  48.263  1.00 50.64           C  
HETATM 1218 SE   MSE B  42      37.144  48.374  49.101  1.00 43.94          SE  
HETATM 1219  CE  MSE B  42      36.283  48.991  47.768  1.00 35.48           C  
ATOM   1220  N   LYS B  43      41.989  47.022  47.451  1.00 60.27           N  
ATOM   1221  CA  LYS B  43      42.821  47.001  48.733  1.00 61.28           C  
ATOM   1222  C   LYS B  43      42.074  47.565  49.941  1.00 59.57           C  
ATOM   1223  O   LYS B  43      41.775  48.794  49.976  1.00 53.94           O  
ATOM   1224  CB  LYS B  43      44.171  47.800  48.499  1.00 63.12           C  
ATOM   1225  CG  LYS B  43      45.473  47.507  49.474  1.00 65.09           C  
ATOM   1226  CD  LYS B  43      46.526  48.589  49.349  1.00 60.09           C  
ATOM   1227  CE  LYS B  43      45.990  49.771  50.339  1.00 63.99           C  
ATOM   1228  NZ  LYS B  43      45.553  49.251  51.723  1.00 63.29           N  
ATOM   1229  N   VAL B  44      41.789  46.696  50.886  1.00 61.06           N  
ATOM   1230  CA  VAL B  44      41.203  47.186  52.113  1.00 66.14           C  
ATOM   1231  C   VAL B  44      42.089  48.248  52.883  1.00 70.69           C  
ATOM   1232  O   VAL B  44      43.314  48.036  53.243  1.00 71.48           O  
ATOM   1233  CB  VAL B  44      40.583  46.061  52.997  1.00 65.77           C  
ATOM   1234  CG1 VAL B  44      41.516  44.967  53.120  1.00 68.48           C  
ATOM   1235  CG2 VAL B  44      40.137  46.594  54.454  1.00 65.77           C  
ATOM   1236  N   GLU B  45      41.453  49.428  53.046  1.00 75.36           N  
ATOM   1237  CA  GLU B  45      42.007  50.667  53.664  1.00 78.09           C  
ATOM   1238  C   GLU B  45      41.744  50.480  55.196  1.00 79.24           C  
ATOM   1239  O   GLU B  45      42.172  49.546  55.824  1.00 81.80           O  
ATOM   1240  CB  GLU B  45      41.280  52.027  53.236  1.00 78.78           C  
ATOM   1241  CG  GLU B  45      41.177  52.454  51.801  1.00 86.40           C  
ATOM   1242  CD  GLU B  45      42.556  52.752  51.144  1.00 95.88           C  
ATOM   1243  OE1 GLU B  45      43.608  51.958  51.302  1.00 97.86           O  
ATOM   1244  OE2 GLU B  45      42.559  53.787  50.433  1.00 97.14           O  
ATOM   1245  N   GLU B  46      40.978  51.380  55.790  1.00 79.37           N  
ATOM   1246  CA  GLU B  46      40.884  51.524  57.221  1.00 78.85           C  
ATOM   1247  C   GLU B  46      39.563  52.296  57.399  1.00 73.29           C  
ATOM   1248  O   GLU B  46      38.950  52.090  58.373  1.00 73.94           O  
ATOM   1249  CB  GLU B  46      42.142  52.285  57.767  1.00 80.90           C  
ATOM   1250  CG  GLU B  46      42.362  53.658  57.062  1.00 90.03           C  
ATOM   1251  CD  GLU B  46      43.115  53.674  55.600  1.00103.14           C  
ATOM   1252  OE1 GLU B  46      44.165  52.824  55.430  1.00104.95           O  
ATOM   1253  OE2 GLU B  46      42.680  54.571  54.641  1.00104.33           O  
ATOM   1254  N   GLN B  47      39.141  53.176  56.493  1.00 66.32           N  
ATOM   1255  CA  GLN B  47      37.756  53.621  56.454  1.00 62.71           C  
ATOM   1256  C   GLN B  47      36.577  52.486  55.979  1.00 57.98           C  
ATOM   1257  O   GLN B  47      35.339  52.654  56.139  1.00 52.85           O  
ATOM   1258  CB  GLN B  47      37.810  54.778  55.460  1.00 62.59           C  
ATOM   1259  CG  GLN B  47      38.863  54.665  54.132  1.00 63.78           C  
ATOM   1260  CD  GLN B  47      38.283  55.659  52.863  1.00 74.44           C  
ATOM   1261  OE1 GLN B  47      38.003  55.146  51.688  1.00 69.16           O  
ATOM   1262  NE2 GLN B  47      38.078  57.101  53.165  1.00 75.36           N  
ATOM   1263  N   HIS B  48      37.071  51.452  55.239  1.00 53.50           N  
ATOM   1264  CA  HIS B  48      36.537  50.048  55.056  1.00 49.34           C  
ATOM   1265  C   HIS B  48      36.495  49.185  56.347  1.00 45.63           C  
ATOM   1266  O   HIS B  48      35.566  48.692  56.592  1.00 44.95           O  
ATOM   1267  CB  HIS B  48      37.392  49.437  54.069  1.00 46.26           C  
ATOM   1268  CG  HIS B  48      37.533  50.306  52.869  1.00 38.78           C  
ATOM   1269  ND1 HIS B  48      38.662  50.294  52.035  1.00 33.50           N  
ATOM   1270  CD2 HIS B  48      36.686  51.208  52.365  1.00 27.63           C  
ATOM   1271  CE1 HIS B  48      38.411  51.028  50.981  1.00 40.66           C  
ATOM   1272  NE2 HIS B  48      37.192  51.573  51.145  1.00 39.64           N  
ATOM   1273  N   THR B  49      37.341  49.355  57.279  1.00 43.48           N  
ATOM   1274  CA  THR B  49      37.394  48.567  58.428  1.00 45.07           C  
ATOM   1275  C   THR B  49      36.450  48.664  59.623  1.00 48.81           C  
ATOM   1276  O   THR B  49      35.827  49.719  59.847  1.00 51.01           O  
ATOM   1277  CB  THR B  49      38.774  48.392  58.896  1.00 42.32           C  
ATOM   1278  OG1 THR B  49      39.101  49.575  59.396  1.00 41.29           O  
ATOM   1279  CG2 THR B  49      39.807  47.926  57.736  1.00 39.61           C  
ATOM   1280  N   ASN B  50      36.344  47.468  60.222  1.00 50.61           N  
ATOM   1281  CA  ASN B  50      35.586  47.062  61.312  1.00 57.72           C  
ATOM   1282  C   ASN B  50      35.904  47.716  62.500  1.00 62.59           C  
ATOM   1283  O   ASN B  50      36.862  48.406  62.537  1.00 67.63           O  
ATOM   1284  CB  ASN B  50      36.213  45.721  61.654  1.00 58.07           C  
ATOM   1285  CG  ASN B  50      35.243  44.664  61.790  1.00 62.69           C  
ATOM   1286  OD1 ASN B  50      35.735  43.618  62.213  1.00 82.59           O  
ATOM   1287  ND2 ASN B  50      33.835  44.812  61.387  1.00 70.06           N  
ATOM   1288  N   LYS B  51      35.331  47.265  63.580  1.00 66.41           N  
ATOM   1289  CA  LYS B  51      35.866  47.452  64.958  1.00 67.57           C  
ATOM   1290  C   LYS B  51      37.252  46.735  65.241  1.00 69.16           C  
ATOM   1291  O   LYS B  51      38.052  47.002  66.125  1.00 70.69           O  
ATOM   1292  CB  LYS B  51      34.840  46.894  66.047  1.00 68.79           C  
ATOM   1293  CG  LYS B  51      33.316  46.322  65.680  1.00 67.47           C  
ATOM   1294  CD  LYS B  51      32.450  47.107  64.474  1.00 65.76           C  
ATOM   1295  CE  LYS B  51      31.039  46.249  63.983  1.00 59.01           C  
ATOM   1296  NZ  LYS B  51      31.475  44.994  63.113  1.00 49.65           N  
ATOM   1297  N   LEU B  52      37.578  45.747  64.521  1.00 69.55           N  
ATOM   1298  CA  LEU B  52      38.727  45.108  64.945  1.00 68.71           C  
ATOM   1299  C   LEU B  52      39.693  45.306  63.874  1.00 67.82           C  
ATOM   1300  O   LEU B  52      40.576  44.565  63.916  1.00 69.99           O  
ATOM   1301  CB  LEU B  52      38.397  43.606  65.077  1.00 70.58           C  
ATOM   1302  CG  LEU B  52      37.195  42.971  66.068  1.00 74.67           C  
ATOM   1303  CD1 LEU B  52      35.571  42.636  65.412  1.00 72.37           C  
ATOM   1304  CD2 LEU B  52      37.629  41.759  67.084  1.00 70.83           C  
ATOM   1305  N   GLY B  53      39.560  46.194  62.838  1.00 64.43           N  
ATOM   1306  CA  GLY B  53      40.607  46.210  61.803  1.00 58.51           C  
ATOM   1307  C   GLY B  53      40.487  45.283  60.624  1.00 54.23           C  
ATOM   1308  O   GLY B  53      41.207  45.533  59.581  1.00 53.33           O  
ATOM   1309  N   THR B  54      39.521  44.374  60.641  1.00 47.61           N  
ATOM   1310  CA  THR B  54      39.277  43.640  59.436  1.00 45.20           C  
ATOM   1311  C   THR B  54      38.306  44.363  58.707  1.00 43.81           C  
ATOM   1312  O   THR B  54      37.561  45.224  59.223  1.00 39.48           O  
ATOM   1313  CB  THR B  54      38.657  42.233  59.752  1.00 47.75           C  
ATOM   1314  OG1 THR B  54      37.334  42.278  60.452  1.00 51.21           O  
ATOM   1315  CG2 THR B  54      39.427  41.610  60.811  1.00 50.02           C  
ATOM   1316  N   LEU B  55      38.064  43.898  57.486  1.00 44.59           N  
ATOM   1317  CA  LEU B  55      37.019  44.545  56.656  1.00 44.22           C  
ATOM   1318  C   LEU B  55      35.566  44.456  57.289  1.00 44.92           C  
ATOM   1319  O   LEU B  55      35.106  43.532  57.880  1.00 49.19           O  
ATOM   1320  CB  LEU B  55      37.068  43.985  55.208  1.00 43.64           C  
ATOM   1321  CG  LEU B  55      36.613  44.847  53.941  1.00 43.21           C  
ATOM   1322  CD1 LEU B  55      35.949  43.970  52.697  1.00 40.73           C  
ATOM   1323  CD2 LEU B  55      35.663  45.954  54.424  1.00 42.15           C  
ATOM   1324  N   HIS B  56      34.906  45.506  57.254  1.00 42.29           N  
ATOM   1325  CA  HIS B  56      33.657  45.588  57.884  1.00 40.91           C  
ATOM   1326  C   HIS B  56      32.572  44.770  57.134  1.00 39.71           C  
ATOM   1327  O   HIS B  56      32.381  44.792  55.823  1.00 34.80           O  
ATOM   1328  CB  HIS B  56      33.236  47.102  57.841  1.00 40.01           C  
ATOM   1329  CG  HIS B  56      32.327  47.438  58.938  1.00 37.95           C  
ATOM   1330  ND1 HIS B  56      31.021  47.371  58.726  1.00 33.63           N  
ATOM   1331  CD2 HIS B  56      32.479  47.657  60.264  1.00 38.54           C  
ATOM   1332  CE1 HIS B  56      30.387  47.769  59.773  1.00 33.23           C  
ATOM   1333  NE2 HIS B  56      31.235  47.918  60.752  1.00 29.71           N  
ATOM   1334  N   GLY B  57      31.808  44.109  58.031  1.00 37.69           N  
ATOM   1335  CA  GLY B  57      30.533  43.429  57.592  1.00 34.90           C  
ATOM   1336  C   GLY B  57      29.620  44.039  56.649  1.00 34.09           C  
ATOM   1337  O   GLY B  57      29.317  43.518  55.581  1.00 33.47           O  
ATOM   1338  N   GLY B  58      29.444  45.354  56.835  1.00 34.05           N  
ATOM   1339  CA  GLY B  58      28.491  46.133  55.956  1.00 30.60           C  
ATOM   1340  C   GLY B  58      28.971  46.556  54.684  1.00 27.19           C  
ATOM   1341  O   GLY B  58      28.308  46.856  53.662  1.00 23.69           O  
ATOM   1342  N   LEU B  59      30.203  46.556  54.677  1.00 28.47           N  
ATOM   1343  CA  LEU B  59      30.715  47.124  53.470  1.00 30.88           C  
ATOM   1344  C   LEU B  59      30.841  45.834  52.665  1.00 27.50           C  
ATOM   1345  O   LEU B  59      30.720  45.865  51.380  1.00 18.61           O  
ATOM   1346  CB  LEU B  59      32.160  47.763  53.763  1.00 33.40           C  
ATOM   1347  CG  LEU B  59      33.052  48.022  52.461  1.00 37.90           C  
ATOM   1348  CD1 LEU B  59      32.342  48.735  51.299  1.00 30.70           C  
ATOM   1349  CD2 LEU B  59      34.092  49.086  52.788  1.00 52.76           C  
ATOM   1350  N   THR B  60      31.221  44.740  53.369  1.00 23.58           N  
ATOM   1351  CA  THR B  60      31.270  43.617  52.569  1.00 27.81           C  
ATOM   1352  C   THR B  60      29.837  43.353  52.021  1.00 23.69           C  
ATOM   1353  O   THR B  60      29.612  43.084  50.820  1.00 21.76           O  
ATOM   1354  CB  THR B  60      31.593  42.579  53.332  1.00 30.19           C  
ATOM   1355  OG1 THR B  60      32.980  42.644  53.632  1.00 39.46           O  
ATOM   1356  CG2 THR B  60      31.401  41.301  52.458  1.00 30.27           C  
ATOM   1357  N   ALA B  61      28.819  43.575  52.781  1.00 20.07           N  
ATOM   1358  CA  ALA B  61      27.492  43.468  51.984  1.00 18.74           C  
ATOM   1359  C   ALA B  61      27.358  44.345  51.049  1.00 18.93           C  
ATOM   1360  O   ALA B  61      26.871  44.091  50.038  1.00 19.44           O  
ATOM   1361  CB  ALA B  61      26.490  43.726  52.900  1.00 24.29           C  
ATOM   1362  N   THR B  62      27.820  45.686  51.270  1.00 28.69           N  
ATOM   1363  CA  THR B  62      27.655  46.879  50.149  1.00 23.41           C  
ATOM   1364  C   THR B  62      28.392  46.493  48.975  1.00 23.08           C  
ATOM   1365  O   THR B  62      28.036  46.781  47.911  1.00 17.45           O  
ATOM   1366  CB  THR B  62      28.132  48.241  50.690  1.00 26.11           C  
ATOM   1367  OG1 THR B  62      27.490  48.459  52.058  1.00 23.56           O  
ATOM   1368  CG2 THR B  62      27.562  49.288  49.824  1.00 11.94           C  
ATOM   1369  N   LEU B  63      29.449  45.722  49.146  1.00 24.17           N  
ATOM   1370  CA  LEU B  63      30.166  45.441  47.931  1.00 28.98           C  
ATOM   1371  C   LEU B  63      29.290  44.354  47.120  1.00 33.70           C  
ATOM   1372  O   LEU B  63      29.138  44.428  46.004  1.00 35.65           O  
ATOM   1373  CB  LEU B  63      31.439  44.981  48.463  1.00 28.99           C  
ATOM   1374  CG  LEU B  63      32.712  45.177  47.756  1.00 38.28           C  
ATOM   1375  CD1 LEU B  63      32.284  45.756  46.500  1.00 40.38           C  
ATOM   1376  CD2 LEU B  63      33.857  45.920  48.563  1.00 33.86           C  
ATOM   1377  N   VAL B  64      28.516  43.473  47.784  1.00 35.81           N  
ATOM   1378  CA  VAL B  64      27.711  42.369  47.167  1.00 33.07           C  
ATOM   1379  C   VAL B  64      26.636  43.039  46.541  1.00 33.67           C  
ATOM   1380  O   VAL B  64      26.542  42.877  45.324  1.00 36.48           O  
ATOM   1381  CB  VAL B  64      27.106  41.338  48.215  1.00 30.16           C  
ATOM   1382  CG1 VAL B  64      26.146  40.327  47.614  1.00 36.57           C  
ATOM   1383  CG2 VAL B  64      28.154  40.635  49.069  1.00 25.34           C  
ATOM   1384  N   ASP B  65      25.796  43.788  47.295  1.00 34.17           N  
ATOM   1385  CA  ASP B  65      24.675  44.628  46.515  1.00 34.63           C  
ATOM   1386  C   ASP B  65      25.181  45.250  45.273  1.00 32.66           C  
ATOM   1387  O   ASP B  65      24.687  44.946  44.161  1.00 30.78           O  
ATOM   1388  CB  ASP B  65      23.912  45.703  47.326  1.00 32.55           C  
ATOM   1389  CG  ASP B  65      22.687  46.328  46.494  1.00 48.17           C  
ATOM   1390  OD1 ASP B  65      22.987  46.605  45.257  1.00 59.30           O  
ATOM   1391  OD2 ASP B  65      21.411  46.654  46.944  1.00 55.48           O  
ATOM   1392  N   SER B  66      26.312  45.996  45.373  1.00 34.54           N  
ATOM   1393  CA  SER B  66      26.474  46.981  44.279  1.00 36.87           C  
ATOM   1394  C   SER B  66      27.088  46.259  43.165  1.00 31.57           C  
ATOM   1395  O   SER B  66      26.735  46.345  41.934  1.00 27.98           O  
ATOM   1396  CB  SER B  66      27.080  48.397  44.707  1.00 36.82           C  
ATOM   1397  OG  SER B  66      28.004  48.170  45.751  1.00 47.79           O  
ATOM   1398  N   ILE B  67      28.018  45.503  43.529  1.00 29.41           N  
ATOM   1399  CA  ILE B  67      28.730  44.919  42.389  1.00 35.44           C  
ATOM   1400  C   ILE B  67      28.029  43.877  41.653  1.00 41.42           C  
ATOM   1401  O   ILE B  67      28.240  43.846  40.444  1.00 44.85           O  
ATOM   1402  CB  ILE B  67      30.160  44.289  42.857  1.00 37.65           C  
ATOM   1403  CG1 ILE B  67      30.930  45.544  43.632  1.00 40.45           C  
ATOM   1404  CG2 ILE B  67      30.880  43.292  41.647  1.00 34.24           C  
ATOM   1405  CD1 ILE B  67      32.281  45.592  43.477  1.00 44.88           C  
ATOM   1406  N   SER B  68      27.256  42.972  42.353  1.00 44.88           N  
ATOM   1407  CA  SER B  68      26.238  42.181  41.617  1.00 46.41           C  
ATOM   1408  C   SER B  68      25.206  43.023  40.884  1.00 46.39           C  
ATOM   1409  O   SER B  68      24.747  42.609  39.853  1.00 48.71           O  
ATOM   1410  CB  SER B  68      25.542  41.148  42.480  1.00 47.50           C  
ATOM   1411  OG  SER B  68      24.348  41.574  43.045  1.00 45.85           O  
ATOM   1412  N   THR B  69      24.788  44.155  41.369  1.00 44.41           N  
ATOM   1413  CA  THR B  69      23.967  45.015  40.509  1.00 41.72           C  
ATOM   1414  C   THR B  69      24.692  45.512  39.403  1.00 39.72           C  
ATOM   1415  O   THR B  69      24.138  45.592  38.368  1.00 40.42           O  
ATOM   1416  CB  THR B  69      23.675  46.080  41.373  1.00 45.37           C  
ATOM   1417  OG1 THR B  69      22.681  45.611  42.372  1.00 50.61           O  
ATOM   1418  CG2 THR B  69      23.164  47.234  40.621  1.00 47.78           C  
HETATM 1419  N   MSE B  70      25.998  45.879  39.510  1.00 42.32           N  
HETATM 1420  CA  MSE B  70      26.825  46.465  38.265  1.00 41.84           C  
HETATM 1421  C   MSE B  70      26.624  45.444  37.213  1.00 40.02           C  
HETATM 1422  O   MSE B  70      26.422  45.709  36.077  1.00 37.48           O  
HETATM 1423  CB  MSE B  70      28.419  46.666  38.460  1.00 41.64           C  
HETATM 1424  CG  MSE B  70      28.810  47.896  39.348  1.00 46.10           C  
HETATM 1425 SE   MSE B  70      27.509  49.553  38.890  1.00 56.52          SE  
HETATM 1426  CE  MSE B  70      28.071  49.490  37.296  1.00 49.22           C  
ATOM   1427  N   ALA B  71      26.823  44.210  37.689  1.00 42.05           N  
ATOM   1428  CA  ALA B  71      26.817  42.985  36.870  1.00 43.48           C  
ATOM   1429  C   ALA B  71      25.595  42.821  36.009  1.00 44.20           C  
ATOM   1430  O   ALA B  71      25.686  42.614  34.768  1.00 40.46           O  
ATOM   1431  CB  ALA B  71      26.888  41.887  37.620  1.00 45.26           C  
ATOM   1432  N   LEU B  72      24.500  43.019  36.706  1.00 44.16           N  
ATOM   1433  CA  LEU B  72      23.272  43.156  36.100  1.00 45.40           C  
ATOM   1434  C   LEU B  72      23.088  44.042  35.044  1.00 48.14           C  
ATOM   1435  O   LEU B  72      22.048  44.033  34.463  1.00 42.97           O  
ATOM   1436  CB  LEU B  72      22.190  43.487  37.127  1.00 48.01           C  
ATOM   1437  CG  LEU B  72      21.274  42.188  37.516  1.00 44.66           C  
ATOM   1438  CD1 LEU B  72      20.676  41.697  36.131  1.00 44.31           C  
ATOM   1439  CD2 LEU B  72      21.979  41.137  37.976  1.00 43.05           C  
HETATM 1440  N   MSE B  73      24.029  44.926  34.749  1.00 57.03           N  
HETATM 1441  CA  MSE B  73      23.733  46.057  33.732  1.00 59.40           C  
HETATM 1442  C   MSE B  73      24.336  45.812  32.343  1.00 62.67           C  
HETATM 1443  O   MSE B  73      23.795  46.278  31.319  1.00 60.49           O  
HETATM 1444  CB  MSE B  73      24.194  47.356  34.244  1.00 60.08           C  
HETATM 1445  CG  MSE B  73      23.276  48.060  35.420  1.00 62.10           C  
HETATM 1446 SE   MSE B  73      24.352  49.836  35.853  1.00 53.20          SE  
HETATM 1447  CE  MSE B  73      25.251  49.447  37.273  1.00 32.21           C  
ATOM   1448  N   CYS B  74      25.384  44.958  32.369  1.00 66.78           N  
ATOM   1449  CA  CYS B  74      26.038  44.254  31.216  1.00 68.36           C  
ATOM   1450  C   CYS B  74      25.137  43.564  30.188  1.00 70.66           C  
ATOM   1451  O   CYS B  74      25.089  43.881  28.886  1.00 74.74           O  
ATOM   1452  CB  CYS B  74      27.151  43.361  31.794  1.00 67.97           C  
ATOM   1453  SG  CYS B  74      28.143  44.469  32.825  1.00 69.61           S  
ATOM   1454  N   THR B  75      24.373  42.645  30.713  1.00 70.32           N  
ATOM   1455  CA  THR B  75      23.462  41.923  29.855  1.00 70.60           C  
ATOM   1456  C   THR B  75      22.141  42.715  29.648  1.00 72.25           C  
ATOM   1457  O   THR B  75      21.851  43.642  30.403  1.00 71.65           O  
ATOM   1458  CB  THR B  75      23.187  40.576  30.548  1.00 72.50           C  
ATOM   1459  OG1 THR B  75      22.937  39.409  29.539  1.00 71.74           O  
ATOM   1460  CG2 THR B  75      22.068  40.977  31.903  1.00 64.76           C  
ATOM   1461  N   GLU B  76      21.350  42.324  28.624  1.00 73.50           N  
ATOM   1462  CA  GLU B  76      19.972  42.671  28.528  1.00 75.10           C  
ATOM   1463  C   GLU B  76      19.301  43.466  29.719  1.00 75.53           C  
ATOM   1464  O   GLU B  76      18.731  44.599  29.848  1.00 76.37           O  
ATOM   1465  CB  GLU B  76      19.280  41.350  28.235  1.00 78.00           C  
ATOM   1466  CG  GLU B  76      18.438  40.533  29.370  1.00 84.49           C  
ATOM   1467  CD  GLU B  76      19.037  39.123  29.878  1.00 85.74           C  
ATOM   1468  OE1 GLU B  76      19.657  38.357  28.971  1.00 79.65           O  
ATOM   1469  OE2 GLU B  76      18.937  38.869  31.202  1.00 89.71           O  
ATOM   1470  N   PRO B  80      18.911  46.006  36.258  1.00 62.89           N  
ATOM   1471  CA  PRO B  80      19.391  46.850  37.516  1.00 64.11           C  
ATOM   1472  C   PRO B  80      18.710  46.379  38.927  1.00 63.06           C  
ATOM   1473  O   PRO B  80      19.366  45.747  39.808  1.00 64.87           O  
ATOM   1474  CB  PRO B  80      19.206  48.383  37.119  1.00 61.11           C  
ATOM   1475  CG  PRO B  80      19.007  48.295  35.592  1.00 63.50           C  
ATOM   1476  CD  PRO B  80      18.797  46.807  34.995  1.00 64.10           C  
ATOM   1477  N   GLY B  81      17.436  46.745  39.056  1.00 61.21           N  
ATOM   1478  CA  GLY B  81      16.425  46.251  39.926  1.00 59.57           C  
ATOM   1479  C   GLY B  81      16.279  46.703  41.298  1.00 58.31           C  
ATOM   1480  O   GLY B  81      16.971  47.679  41.783  1.00 58.84           O  
ATOM   1481  N   VAL B  82      15.472  45.906  42.028  1.00 54.71           N  
ATOM   1482  CA  VAL B  82      15.572  46.254  43.434  1.00 53.81           C  
ATOM   1483  C   VAL B  82      15.833  45.055  44.235  1.00 50.25           C  
ATOM   1484  O   VAL B  82      15.604  44.040  43.829  1.00 48.57           O  
ATOM   1485  CB  VAL B  82      14.463  47.239  43.859  1.00 52.08           C  
ATOM   1486  CG1 VAL B  82      14.416  48.205  42.839  1.00 44.40           C  
ATOM   1487  CG2 VAL B  82      12.981  46.551  43.742  1.00 55.29           C  
ATOM   1488  N   SER B  83      16.292  45.295  45.411  1.00 49.22           N  
ATOM   1489  CA  SER B  83      16.717  44.221  46.121  1.00 51.47           C  
ATOM   1490  C   SER B  83      15.468  43.489  46.632  1.00 50.12           C  
ATOM   1491  O   SER B  83      14.386  44.037  46.943  1.00 51.88           O  
ATOM   1492  CB  SER B  83      17.725  44.586  47.243  1.00 51.48           C  
ATOM   1493  OG  SER B  83      19.033  45.014  46.760  1.00 58.24           O  
ATOM   1494  N   VAL B  84      15.652  42.175  46.661  1.00 49.69           N  
ATOM   1495  CA  VAL B  84      14.687  41.263  47.316  1.00 47.64           C  
ATOM   1496  C   VAL B  84      15.223  40.679  48.588  1.00 41.73           C  
ATOM   1497  O   VAL B  84      14.623  40.830  49.832  1.00 39.81           O  
ATOM   1498  CB  VAL B  84      14.062  40.179  46.322  1.00 49.63           C  
ATOM   1499  CG1 VAL B  84      13.158  39.208  47.024  1.00 47.51           C  
ATOM   1500  CG2 VAL B  84      13.313  40.905  45.281  1.00 48.68           C  
ATOM   1501  N   ASP B  85      16.299  40.002  48.316  1.00 36.84           N  
ATOM   1502  CA  ASP B  85      16.961  39.379  49.502  1.00 35.74           C  
ATOM   1503  C   ASP B  85      18.353  39.357  49.290  1.00 28.35           C  
ATOM   1504  O   ASP B  85      18.840  39.193  48.126  1.00 26.67           O  
ATOM   1505  CB  ASP B  85      16.534  37.877  49.588  1.00 37.09           C  
ATOM   1506  CG  ASP B  85      14.921  37.641  49.894  1.00 50.02           C  
ATOM   1507  OD1 ASP B  85      14.595  37.671  51.284  1.00 47.61           O  
ATOM   1508  OD2 ASP B  85      14.096  37.266  48.761  1.00 60.63           O  
HETATM 1509  N   MSE B  86      18.958  39.338  50.367  1.00 21.41           N  
HETATM 1510  CA  MSE B  86      20.415  38.999  50.406  1.00 27.69           C  
HETATM 1511  C   MSE B  86      20.874  38.095  51.575  1.00 20.82           C  
HETATM 1512  O   MSE B  86      20.627  38.320  52.852  1.00 24.89           O  
HETATM 1513  CB  MSE B  86      21.257  40.297  50.512  1.00 31.62           C  
HETATM 1514  CG  MSE B  86      22.894  40.222  50.232  1.00 43.41           C  
HETATM 1515 SE   MSE B  86      23.786  41.975  50.708  1.00 40.01          SE  
HETATM 1516  CE  MSE B  86      23.337  42.415  49.228  1.00 24.12           C  
ATOM   1517  N   ASN B  87      21.823  37.316  51.230  1.00 11.11           N  
ATOM   1518  CA  ASN B  87      22.446  36.544  52.467  1.00 20.99           C  
ATOM   1519  C   ASN B  87      23.931  36.545  52.291  1.00 19.65           C  
ATOM   1520  O   ASN B  87      24.469  36.486  51.094  1.00 25.78           O  
ATOM   1521  CB  ASN B  87      21.930  34.835  52.467  1.00 19.43           C  
ATOM   1522  CG  ASN B  87      21.933  34.330  51.130  1.00 20.63           C  
ATOM   1523  OD1 ASN B  87      22.939  33.758  50.687  1.00 32.28           O  
ATOM   1524  ND2 ASN B  87      20.891  34.685  50.373  1.00 40.39           N  
ATOM   1525  N   ILE B  88      24.617  36.530  53.369  1.00 23.59           N  
ATOM   1526  CA  ILE B  88      26.160  36.585  53.183  1.00 28.54           C  
ATOM   1527  C   ILE B  88      26.900  35.821  54.305  1.00 26.03           C  
ATOM   1528  O   ILE B  88      26.351  35.872  55.360  1.00 26.68           O  
ATOM   1529  CB  ILE B  88      26.650  37.988  53.140  1.00 27.58           C  
ATOM   1530  CG1 ILE B  88      25.881  38.782  52.056  1.00 29.26           C  
ATOM   1531  CG2 ILE B  88      28.404  37.994  52.936  1.00 37.32           C  
ATOM   1532  CD1 ILE B  88      24.647  39.981  52.731  1.00 33.76           C  
ATOM   1533  N   THR B  89      27.991  35.075  54.006  1.00 25.75           N  
ATOM   1534  CA  THR B  89      28.593  34.279  55.034  1.00 28.63           C  
ATOM   1535  C   THR B  89      30.022  34.480  55.255  1.00 28.89           C  
ATOM   1536  O   THR B  89      30.835  34.805  54.300  1.00 25.74           O  
ATOM   1537  CB  THR B  89      28.179  32.658  54.690  1.00 32.00           C  
ATOM   1538  OG1 THR B  89      28.949  31.774  55.550  1.00 39.17           O  
ATOM   1539  CG2 THR B  89      28.692  32.403  53.306  1.00 40.18           C  
ATOM   1540  N   TYR B  90      30.494  34.442  56.478  1.00 31.52           N  
ATOM   1541  CA  TYR B  90      31.904  35.067  56.532  1.00 37.64           C  
ATOM   1542  C   TYR B  90      32.923  34.077  56.973  1.00 45.06           C  
ATOM   1543  O   TYR B  90      32.751  33.430  58.075  1.00 50.40           O  
ATOM   1544  CB  TYR B  90      31.859  36.225  57.546  1.00 39.35           C  
ATOM   1545  CG  TYR B  90      30.997  37.407  57.075  1.00 34.26           C  
ATOM   1546  CD1 TYR B  90      31.514  38.444  56.297  1.00 38.18           C  
ATOM   1547  CD2 TYR B  90      29.648  37.456  57.476  1.00 41.69           C  
ATOM   1548  CE1 TYR B  90      30.640  39.587  55.944  1.00 54.44           C  
ATOM   1549  CE2 TYR B  90      28.688  38.459  57.041  1.00 50.58           C  
ATOM   1550  CZ  TYR B  90      29.205  39.527  56.286  1.00 57.35           C  
ATOM   1551  OH  TYR B  90      28.329  40.421  55.961  1.00 55.75           O  
HETATM 1552  N   MSE B  91      33.912  33.785  56.134  1.00 50.23           N  
HETATM 1553  CA  MSE B  91      34.751  32.614  56.477  1.00 53.95           C  
HETATM 1554  C   MSE B  91      36.150  32.920  57.067  1.00 54.48           C  
HETATM 1555  O   MSE B  91      36.684  31.995  57.647  1.00 56.08           O  
HETATM 1556  CB  MSE B  91      34.848  31.436  55.423  1.00 54.59           C  
HETATM 1557  CG  MSE B  91      34.485  31.514  53.901  1.00 57.18           C  
HETATM 1558 SE   MSE B  91      32.916  30.771  53.691  1.00 52.66          SE  
HETATM 1559  CE  MSE B  91      32.287  31.892  52.862  1.00 52.38           C  
ATOM   1560  N   SER B  92      36.653  34.174  56.961  1.00 53.76           N  
ATOM   1561  CA  SER B  92      38.049  34.693  57.018  1.00 50.40           C  
ATOM   1562  C   SER B  92      37.996  36.322  56.886  1.00 48.97           C  
ATOM   1563  O   SER B  92      37.097  36.917  56.093  1.00 39.13           O  
ATOM   1564  CB  SER B  92      38.596  34.176  55.791  1.00 50.80           C  
ATOM   1565  OG  SER B  92      39.892  34.492  55.509  1.00 61.82           O  
ATOM   1566  N   PRO B  93      38.883  36.955  57.688  1.00 48.75           N  
ATOM   1567  CA  PRO B  93      39.030  38.428  57.916  1.00 49.89           C  
ATOM   1568  C   PRO B  93      39.876  38.961  56.865  1.00 51.41           C  
ATOM   1569  O   PRO B  93      40.617  38.217  56.306  1.00 52.46           O  
ATOM   1570  CB  PRO B  93      39.777  38.591  59.201  1.00 49.37           C  
ATOM   1571  CG  PRO B  93      40.510  37.416  59.365  1.00 50.50           C  
ATOM   1572  CD  PRO B  93      39.876  36.243  58.503  1.00 52.25           C  
ATOM   1573  N   ALA B  94      39.505  40.096  56.350  1.00 52.49           N  
ATOM   1574  CA  ALA B  94      40.334  40.714  55.401  1.00 52.66           C  
ATOM   1575  C   ALA B  94      41.087  41.853  56.131  1.00 55.33           C  
ATOM   1576  O   ALA B  94      40.458  42.879  56.365  1.00 56.26           O  
ATOM   1577  CB  ALA B  94      39.611  41.227  54.459  1.00 50.96           C  
ATOM   1578  N   LYS B  95      42.373  41.707  56.411  1.00 55.67           N  
ATOM   1579  CA  LYS B  95      43.034  42.762  57.144  1.00 60.84           C  
ATOM   1580  C   LYS B  95      43.458  44.146  56.335  1.00 57.56           C  
ATOM   1581  O   LYS B  95      43.385  44.267  55.168  1.00 52.79           O  
ATOM   1582  CB  LYS B  95      44.180  42.139  58.065  1.00 64.14           C  
ATOM   1583  CG  LYS B  95      44.037  40.530  58.449  1.00 71.46           C  
ATOM   1584  CD  LYS B  95      45.153  40.084  59.547  1.00 83.56           C  
ATOM   1585  CE  LYS B  95      45.079  38.540  59.933  1.00 95.29           C  
ATOM   1586  NZ  LYS B  95      44.716  37.484  58.735  1.00 98.80           N  
ATOM   1587  N   ILE B  96      43.885  45.148  57.045  1.00 57.69           N  
ATOM   1588  CA  ILE B  96      44.334  46.435  56.427  1.00 56.27           C  
ATOM   1589  C   ILE B  96      45.593  46.269  55.648  1.00 55.02           C  
ATOM   1590  O   ILE B  96      46.519  45.552  56.055  1.00 52.74           O  
ATOM   1591  CB  ILE B  96      44.619  47.493  57.553  1.00 55.27           C  
ATOM   1592  CG1 ILE B  96      43.672  47.380  58.774  1.00 57.18           C  
ATOM   1593  CG2 ILE B  96      44.345  48.796  57.043  1.00 57.30           C  
ATOM   1594  CD1 ILE B  96      43.049  48.788  59.431  1.00 56.03           C  
ATOM   1595  N   GLY B  97      45.584  46.873  54.488  1.00 55.28           N  
ATOM   1596  CA  GLY B  97      46.575  46.561  53.504  1.00 56.09           C  
ATOM   1597  C   GLY B  97      46.262  45.508  52.486  1.00 58.48           C  
ATOM   1598  O   GLY B  97      46.896  45.498  51.451  1.00 59.14           O  
ATOM   1599  N   GLU B  98      45.216  44.705  52.690  1.00 62.06           N  
ATOM   1600  CA  GLU B  98      44.910  43.476  51.889  1.00 64.65           C  
ATOM   1601  C   GLU B  98      44.370  43.824  50.602  1.00 61.79           C  
ATOM   1602  O   GLU B  98      43.692  44.792  50.571  1.00 59.94           O  
ATOM   1603  CB  GLU B  98      43.882  42.495  52.601  1.00 67.54           C  
ATOM   1604  CG  GLU B  98      44.490  41.096  53.145  1.00 72.77           C  
ATOM   1605  CD  GLU B  98      45.846  41.142  53.918  1.00 76.17           C  
ATOM   1606  OE1 GLU B  98      46.942  41.284  53.346  1.00 85.54           O  
ATOM   1607  OE2 GLU B  98      45.810  41.037  55.126  1.00 72.37           O  
ATOM   1608  N   GLU B  99      44.770  43.147  49.550  1.00 59.85           N  
ATOM   1609  CA  GLU B  99      44.036  43.453  48.406  1.00 61.03           C  
ATOM   1610  C   GLU B  99      43.110  42.305  48.056  1.00 57.13           C  
ATOM   1611  O   GLU B  99      43.570  41.202  47.872  1.00 56.75           O  
ATOM   1612  CB  GLU B  99      44.835  43.892  47.230  1.00 62.88           C  
ATOM   1613  CG  GLU B  99      43.877  44.048  45.982  1.00 72.84           C  
ATOM   1614  CD  GLU B  99      44.306  45.159  44.932  1.00 84.95           C  
ATOM   1615  OE1 GLU B  99      45.032  46.186  45.319  1.00 99.77           O  
ATOM   1616  OE2 GLU B  99      43.975  45.002  43.711  1.00 81.26           O  
ATOM   1617  N   ILE B 100      41.800  42.625  47.984  1.00 52.89           N  
ATOM   1618  CA  ILE B 100      40.678  41.724  47.743  1.00 48.83           C  
ATOM   1619  C   ILE B 100      40.089  41.799  46.356  1.00 48.19           C  
ATOM   1620  O   ILE B 100      39.618  42.775  45.818  1.00 50.47           O  
ATOM   1621  CB  ILE B 100      39.566  41.918  48.675  1.00 47.32           C  
ATOM   1622  CG1 ILE B 100      38.703  43.140  48.235  1.00 53.72           C  
ATOM   1623  CG2 ILE B 100      40.023  42.108  50.060  1.00 40.72           C  
ATOM   1624  CD1 ILE B 100      37.399  43.210  49.061  1.00 61.91           C  
ATOM   1625  N   VAL B 101      40.001  40.658  45.773  1.00 50.42           N  
ATOM   1626  CA  VAL B 101      39.116  40.475  44.520  1.00 50.03           C  
ATOM   1627  C   VAL B 101      37.636  40.028  44.750  1.00 43.73           C  
ATOM   1628  O   VAL B 101      37.265  39.133  45.581  1.00 41.15           O  
ATOM   1629  CB  VAL B 101      39.727  39.432  43.578  1.00 52.25           C  
ATOM   1630  CG1 VAL B 101      40.285  38.334  44.440  1.00 53.32           C  
ATOM   1631  CG2 VAL B 101      38.531  38.975  42.501  1.00 53.46           C  
ATOM   1632  N   ILE B 102      36.836  40.678  44.021  1.00 36.90           N  
ATOM   1633  CA  ILE B 102      35.480  40.462  44.360  1.00 39.70           C  
ATOM   1634  C   ILE B 102      34.970  40.016  43.051  1.00 39.16           C  
ATOM   1635  O   ILE B 102      35.080  40.692  42.127  1.00 38.21           O  
ATOM   1636  CB  ILE B 102      34.633  41.609  45.155  1.00 39.41           C  
ATOM   1637  CG1 ILE B 102      33.622  42.186  44.341  1.00 43.43           C  
ATOM   1638  CG2 ILE B 102      35.579  43.151  45.653  1.00 39.35           C  
ATOM   1639  CD1 ILE B 102      32.677  41.436  43.859  1.00 57.37           C  
ATOM   1640  N   THR B 103      34.414  38.806  43.001  1.00 39.41           N  
ATOM   1641  CA  THR B 103      33.770  38.338  41.777  1.00 43.64           C  
ATOM   1642  C   THR B 103      32.206  37.936  41.789  1.00 41.04           C  
ATOM   1643  O   THR B 103      31.724  37.277  42.728  1.00 42.57           O  
ATOM   1644  CB  THR B 103      34.631  37.242  41.228  1.00 44.69           C  
ATOM   1645  OG1 THR B 103      33.760  36.433  40.408  1.00 56.44           O  
ATOM   1646  CG2 THR B 103      35.401  36.412  42.453  1.00 52.66           C  
ATOM   1647  N   ALA B 104      31.518  38.361  40.763  1.00 38.91           N  
ATOM   1648  CA  ALA B 104      30.136  38.200  40.560  1.00 39.52           C  
ATOM   1649  C   ALA B 104      29.654  37.334  39.360  1.00 38.39           C  
ATOM   1650  O   ALA B 104      30.061  37.295  38.244  1.00 29.90           O  
ATOM   1651  CB  ALA B 104      29.368  39.607  40.606  1.00 40.65           C  
ATOM   1652  N   HIS B 105      28.642  36.601  39.766  1.00 42.56           N  
ATOM   1653  CA  HIS B 105      28.051  35.596  38.883  1.00 45.95           C  
ATOM   1654  C   HIS B 105      26.602  35.730  38.787  1.00 46.22           C  
ATOM   1655  O   HIS B 105      25.871  35.574  39.731  1.00 50.44           O  
ATOM   1656  CB  HIS B 105      28.429  34.184  39.238  1.00 43.68           C  
ATOM   1657  CG  HIS B 105      29.903  33.897  39.082  1.00 48.60           C  
ATOM   1658  ND1 HIS B 105      30.767  33.909  40.192  1.00 48.62           N  
ATOM   1659  CD2 HIS B 105      30.638  33.476  37.986  1.00 50.64           C  
ATOM   1660  CE1 HIS B 105      31.973  33.527  39.776  1.00 59.68           C  
ATOM   1661  NE2 HIS B 105      31.936  33.276  38.447  1.00 58.06           N  
ATOM   1662  N   ILE B 106      26.141  36.065  37.644  1.00 45.16           N  
ATOM   1663  CA  ILE B 106      24.704  35.956  37.418  1.00 46.33           C  
ATOM   1664  C   ILE B 106      24.266  34.530  37.187  1.00 45.13           C  
ATOM   1665  O   ILE B 106      24.560  33.977  36.149  1.00 47.24           O  
ATOM   1666  CB  ILE B 106      24.435  36.791  36.186  1.00 46.61           C  
ATOM   1667  CG1 ILE B 106      24.717  38.242  36.729  1.00 54.61           C  
ATOM   1668  CG2 ILE B 106      23.014  36.675  35.851  1.00 42.88           C  
ATOM   1669  CD1 ILE B 106      25.864  38.879  35.807  1.00 70.22           C  
ATOM   1670  N   LEU B 107      23.741  33.896  38.209  1.00 43.42           N  
ATOM   1671  CA  LEU B 107      23.171  32.524  38.278  1.00 39.32           C  
ATOM   1672  C   LEU B 107      21.883  32.376  37.424  1.00 39.45           C  
ATOM   1673  O   LEU B 107      21.745  31.511  36.612  1.00 34.29           O  
ATOM   1674  CB  LEU B 107      22.746  32.474  39.696  1.00 40.97           C  
ATOM   1675  CG  LEU B 107      23.830  32.068  40.736  1.00 41.81           C  
ATOM   1676  CD1 LEU B 107      25.346  32.349  40.398  1.00 44.75           C  
ATOM   1677  CD2 LEU B 107      23.381  32.384  42.146  1.00 40.36           C  
ATOM   1678  N   LYS B 108      21.092  33.413  37.440  1.00 42.71           N  
ATOM   1679  CA  LYS B 108      19.879  33.530  36.801  1.00 48.15           C  
ATOM   1680  C   LYS B 108      19.268  34.901  36.299  1.00 53.15           C  
ATOM   1681  O   LYS B 108      19.127  35.905  36.973  1.00 50.12           O  
ATOM   1682  CB  LYS B 108      18.758  32.888  37.646  1.00 52.97           C  
ATOM   1683  CG  LYS B 108      17.530  32.006  36.728  1.00 52.84           C  
ATOM   1684  CD  LYS B 108      16.199  32.717  36.763  1.00 59.37           C  
ATOM   1685  CE  LYS B 108      15.174  31.955  35.933  1.00 67.92           C  
ATOM   1686  NZ  LYS B 108      15.411  31.610  34.475  1.00 69.16           N  
ATOM   1687  N   GLN B 109      18.887  34.733  35.015  1.00 60.05           N  
ATOM   1688  CA  GLN B 109      17.942  35.394  34.070  1.00 64.76           C  
ATOM   1689  C   GLN B 109      16.458  35.644  34.575  1.00 65.29           C  
ATOM   1690  O   GLN B 109      16.326  36.423  35.473  1.00 72.80           O  
ATOM   1691  CB  GLN B 109      17.916  34.514  32.726  1.00 67.26           C  
ATOM   1692  CG  GLN B 109      18.094  32.899  32.836  1.00 68.38           C  
ATOM   1693  CD  GLN B 109      19.421  32.373  32.496  1.00 65.07           C  
ATOM   1694  OE1 GLN B 109      19.485  31.223  32.061  1.00 72.74           O  
ATOM   1695  NE2 GLN B 109      20.446  33.181  32.601  1.00 55.29           N  
ATOM   1696  N   GLY B 110      15.350  35.135  34.092  1.00 61.51           N  
ATOM   1697  CA  GLY B 110      14.115  35.527  34.767  1.00 61.90           C  
ATOM   1698  C   GLY B 110      13.324  36.625  34.133  1.00 63.17           C  
ATOM   1699  O   GLY B 110      13.849  37.580  33.596  1.00 68.00           O  
ATOM   1700  N   LYS B 111      12.032  36.494  34.110  1.00 64.33           N  
ATOM   1701  CA  LYS B 111      11.090  37.543  33.573  1.00 65.97           C  
ATOM   1702  C   LYS B 111      10.982  38.701  34.610  1.00 64.52           C  
ATOM   1703  O   LYS B 111      11.110  39.844  34.292  1.00 67.08           O  
ATOM   1704  CB  LYS B 111       9.665  36.985  33.482  1.00 67.68           C  
ATOM   1705  CG  LYS B 111       9.487  35.356  33.441  1.00 78.27           C  
ATOM   1706  CD  LYS B 111      10.048  34.291  34.709  1.00 85.44           C  
ATOM   1707  CE  LYS B 111      11.151  33.165  34.122  1.00 84.47           C  
ATOM   1708  NZ  LYS B 111      11.733  32.396  35.274  1.00 85.01           N  
ATOM   1709  N   THR B 112      10.799  38.433  35.887  1.00 60.14           N  
ATOM   1710  CA  THR B 112      10.933  39.491  36.798  1.00 56.85           C  
ATOM   1711  C   THR B 112      11.980  39.389  37.910  1.00 51.13           C  
ATOM   1712  O   THR B 112      12.042  40.239  38.786  1.00 49.52           O  
ATOM   1713  CB  THR B 112       9.672  39.583  37.512  1.00 58.22           C  
ATOM   1714  OG1 THR B 112       9.730  40.838  38.204  1.00 67.67           O  
ATOM   1715  CG2 THR B 112       9.480  38.412  38.764  1.00 59.32           C  
ATOM   1716  N   LEU B 113      12.699  38.324  37.985  1.00 46.22           N  
ATOM   1717  CA  LEU B 113      13.696  38.251  39.063  1.00 44.09           C  
ATOM   1718  C   LEU B 113      15.059  37.803  38.462  1.00 38.58           C  
ATOM   1719  O   LEU B 113      15.102  37.201  37.451  1.00 33.57           O  
ATOM   1720  CB  LEU B 113      13.357  37.235  40.089  1.00 44.46           C  
ATOM   1721  CG  LEU B 113      12.425  37.449  41.303  1.00 51.30           C  
ATOM   1722  CD1 LEU B 113      12.709  38.771  42.069  1.00 41.57           C  
ATOM   1723  CD2 LEU B 113      10.927  37.263  41.025  1.00 56.30           C  
ATOM   1724  N   ALA B 114      16.116  38.238  39.121  1.00 36.04           N  
ATOM   1725  CA  ALA B 114      17.559  37.943  38.735  1.00 34.00           C  
ATOM   1726  C   ALA B 114      18.351  37.542  39.930  1.00 31.64           C  
ATOM   1727  O   ALA B 114      17.911  37.842  41.053  1.00 31.62           O  
ATOM   1728  CB  ALA B 114      18.203  39.106  38.009  1.00 37.42           C  
ATOM   1729  N   PHE B 115      19.302  36.632  39.795  1.00 30.01           N  
ATOM   1730  CA  PHE B 115      19.917  36.154  41.054  1.00 28.94           C  
ATOM   1731  C   PHE B 115      21.314  36.175  40.714  1.00 29.91           C  
ATOM   1732  O   PHE B 115      21.722  35.881  39.583  1.00 27.73           O  
ATOM   1733  CB  PHE B 115      19.648  34.638  41.437  1.00 30.17           C  
ATOM   1734  CG  PHE B 115      18.105  34.226  41.479  1.00 31.26           C  
ATOM   1735  CD1 PHE B 115      17.383  34.066  40.350  1.00 30.87           C  
ATOM   1736  CD2 PHE B 115      17.495  33.972  42.641  1.00 39.06           C  
ATOM   1737  CE1 PHE B 115      15.977  33.912  40.419  1.00 40.47           C  
ATOM   1738  CE2 PHE B 115      16.141  33.629  42.749  1.00 43.05           C  
ATOM   1739  CZ  PHE B 115      15.360  33.607  41.578  1.00 36.42           C  
ATOM   1740  N   ALA B 116      22.118  36.457  41.706  1.00 33.02           N  
ATOM   1741  CA  ALA B 116      23.562  36.406  41.506  1.00 33.23           C  
ATOM   1742  C   ALA B 116      24.266  36.039  42.678  1.00 32.36           C  
ATOM   1743  O   ALA B 116      23.858  36.385  43.768  1.00 38.54           O  
ATOM   1744  CB  ALA B 116      23.905  37.854  41.254  1.00 36.30           C  
ATOM   1745  N   SER B 117      25.394  35.419  42.508  1.00 30.82           N  
ATOM   1746  CA  SER B 117      26.264  35.046  43.597  1.00 28.83           C  
ATOM   1747  C   SER B 117      27.570  35.924  43.569  1.00 27.11           C  
ATOM   1748  O   SER B 117      28.111  36.176  42.447  1.00 23.30           O  
ATOM   1749  CB  SER B 117      26.677  33.467  43.478  1.00 31.03           C  
ATOM   1750  OG  SER B 117      27.768  33.002  44.551  1.00 34.39           O  
ATOM   1751  N   VAL B 118      28.162  36.175  44.751  1.00 26.22           N  
ATOM   1752  CA  VAL B 118      29.422  36.864  44.822  1.00 28.97           C  
ATOM   1753  C   VAL B 118      30.356  36.363  45.922  1.00 35.47           C  
ATOM   1754  O   VAL B 118      30.103  36.389  47.102  1.00 35.82           O  
ATOM   1755  CB  VAL B 118      29.132  38.440  45.167  1.00 30.19           C  
ATOM   1756  CG1 VAL B 118      30.316  39.250  45.426  1.00 16.52           C  
ATOM   1757  CG2 VAL B 118      28.203  38.990  44.147  1.00 26.80           C  
ATOM   1758  N   ASP B 119      31.623  36.299  45.495  1.00 41.46           N  
ATOM   1759  CA  ASP B 119      32.647  35.750  46.332  1.00 43.82           C  
ATOM   1760  C   ASP B 119      33.794  36.839  46.501  1.00 40.62           C  
ATOM   1761  O   ASP B 119      34.444  37.332  45.524  1.00 39.55           O  
ATOM   1762  CB  ASP B 119      33.279  34.326  45.712  1.00 45.39           C  
ATOM   1763  CG  ASP B 119      32.262  33.174  45.164  1.00 60.56           C  
ATOM   1764  OD1 ASP B 119      31.571  33.188  44.017  1.00 77.50           O  
ATOM   1765  OD2 ASP B 119      32.239  32.062  45.846  1.00 88.13           O  
ATOM   1766  N   LEU B 120      34.199  36.993  47.743  1.00 39.98           N  
ATOM   1767  CA  LEU B 120      35.401  37.799  48.001  1.00 40.68           C  
ATOM   1768  C   LEU B 120      36.506  36.956  48.330  1.00 42.01           C  
ATOM   1769  O   LEU B 120      36.592  36.362  49.377  1.00 36.30           O  
ATOM   1770  CB  LEU B 120      35.190  38.719  49.280  1.00 40.57           C  
ATOM   1771  CG  LEU B 120      34.324  39.859  48.762  1.00 40.72           C  
ATOM   1772  CD1 LEU B 120      33.045  39.600  48.185  1.00 40.39           C  
ATOM   1773  CD2 LEU B 120      34.079  40.764  49.796  1.00 49.50           C  
ATOM   1774  N   THR B 121      37.468  37.101  47.500  1.00 47.84           N  
ATOM   1775  CA  THR B 121      38.749  36.406  47.630  1.00 52.43           C  
ATOM   1776  C   THR B 121      39.939  37.365  48.044  1.00 53.61           C  
ATOM   1777  O   THR B 121      40.040  38.480  47.576  1.00 50.94           O  
ATOM   1778  CB  THR B 121      39.086  35.680  46.253  1.00 52.87           C  
ATOM   1779  OG1 THR B 121      38.341  36.367  45.190  1.00 60.49           O  
ATOM   1780  CG2 THR B 121      38.553  34.161  46.271  1.00 58.16           C  
ATOM   1781  N   ASN B 122      40.887  36.817  48.828  1.00 55.52           N  
ATOM   1782  CA  ASN B 122      42.219  37.315  48.887  1.00 54.77           C  
ATOM   1783  C   ASN B 122      42.889  37.376  47.608  1.00 55.34           C  
ATOM   1784  O   ASN B 122      43.052  36.353  47.059  1.00 55.95           O  
ATOM   1785  CB  ASN B 122      43.077  36.474  49.684  1.00 55.78           C  
ATOM   1786  CG  ASN B 122      44.355  37.272  50.195  1.00 61.10           C  
ATOM   1787  OD1 ASN B 122      45.343  37.488  49.522  1.00 68.08           O  
ATOM   1788  ND2 ASN B 122      44.280  37.680  51.385  1.00 67.26           N  
ATOM   1789  N   LYS B 123      43.280  38.573  47.121  1.00 55.23           N  
ATOM   1790  CA  LYS B 123      44.001  38.595  45.915  1.00 56.38           C  
ATOM   1791  C   LYS B 123      45.167  37.603  45.992  1.00 59.00           C  
ATOM   1792  O   LYS B 123      45.238  36.765  45.247  1.00 58.30           O  
ATOM   1793  CB  LYS B 123      44.457  39.971  45.524  1.00 55.18           C  
ATOM   1794  CG  LYS B 123      44.823  40.117  44.012  1.00 53.76           C  
ATOM   1795  CD  LYS B 123      45.264  41.623  43.639  1.00 67.14           C  
ATOM   1796  CE  LYS B 123      45.558  42.194  42.134  1.00 68.97           C  
ATOM   1797  NZ  LYS B 123      45.610  40.892  41.516  1.00 75.98           N  
ATOM   1798  N   THR B 124      46.051  37.645  46.921  1.00 62.87           N  
ATOM   1799  CA  THR B 124      47.152  36.693  46.898  1.00 67.66           C  
ATOM   1800  C   THR B 124      46.990  35.337  47.428  1.00 66.71           C  
ATOM   1801  O   THR B 124      47.594  34.530  46.837  1.00 67.44           O  
ATOM   1802  CB  THR B 124      48.340  37.268  47.772  1.00 71.26           C  
ATOM   1803  OG1 THR B 124      48.973  38.300  47.001  1.00 78.83           O  
ATOM   1804  CG2 THR B 124      49.523  36.143  48.212  1.00 71.78           C  
ATOM   1805  N   THR B 125      46.384  35.108  48.601  1.00 66.64           N  
ATOM   1806  CA  THR B 125      46.098  33.755  49.074  1.00 67.16           C  
ATOM   1807  C   THR B 125      45.158  33.160  48.023  1.00 66.19           C  
ATOM   1808  O   THR B 125      45.356  32.087  47.633  1.00 69.76           O  
ATOM   1809  CB  THR B 125      45.349  33.639  50.435  1.00 67.95           C  
ATOM   1810  OG1 THR B 125      45.697  34.625  51.365  1.00 78.18           O  
ATOM   1811  CG2 THR B 125      45.867  32.493  51.277  1.00 73.51           C  
ATOM   1812  N   GLY B 126      44.113  33.760  47.532  1.00 62.54           N  
ATOM   1813  CA  GLY B 126      43.218  33.011  46.701  1.00 60.65           C  
ATOM   1814  C   GLY B 126      42.039  32.658  47.586  1.00 59.99           C  
ATOM   1815  O   GLY B 126      40.896  32.523  47.145  1.00 59.84           O  
ATOM   1816  N   LYS B 127      42.378  32.625  48.847  1.00 58.97           N  
ATOM   1817  CA  LYS B 127      41.567  32.232  49.951  1.00 61.12           C  
ATOM   1818  C   LYS B 127      40.212  32.979  50.033  1.00 59.15           C  
ATOM   1819  O   LYS B 127      40.212  34.159  49.754  1.00 60.75           O  
ATOM   1820  CB  LYS B 127      42.396  32.415  51.252  1.00 63.76           C  
ATOM   1821  CG  LYS B 127      42.818  31.112  52.219  1.00 70.65           C  
ATOM   1822  CD  LYS B 127      42.990  31.862  53.692  1.00 87.86           C  
ATOM   1823  CE  LYS B 127      43.452  31.047  54.987  1.00 97.02           C  
ATOM   1824  NZ  LYS B 127      42.615  29.759  55.235  1.00100.07           N  
ATOM   1825  N   LEU B 128      39.094  32.284  50.469  1.00 54.96           N  
ATOM   1826  CA  LEU B 128      37.733  32.873  50.672  1.00 49.34           C  
ATOM   1827  C   LEU B 128      37.560  33.749  51.914  1.00 46.67           C  
ATOM   1828  O   LEU B 128      38.060  33.557  53.029  1.00 45.17           O  
ATOM   1829  CB  LEU B 128      36.582  31.851  50.816  1.00 51.40           C  
ATOM   1830  CG  LEU B 128      35.802  31.506  49.629  1.00 48.53           C  
ATOM   1831  CD1 LEU B 128      35.407  32.850  49.134  1.00 49.25           C  
ATOM   1832  CD2 LEU B 128      36.939  30.929  48.783  1.00 55.60           C  
ATOM   1833  N   ILE B 129      36.741  34.728  51.681  1.00 42.86           N  
ATOM   1834  CA  ILE B 129      36.393  35.692  52.664  1.00 40.43           C  
ATOM   1835  C   ILE B 129      34.952  35.681  52.785  1.00 40.00           C  
ATOM   1836  O   ILE B 129      34.635  35.641  53.860  1.00 43.89           O  
ATOM   1837  CB  ILE B 129      36.898  37.110  52.206  1.00 40.22           C  
ATOM   1838  CG1 ILE B 129      38.415  37.114  51.673  1.00 36.54           C  
ATOM   1839  CG2 ILE B 129      37.044  38.044  53.360  1.00 39.27           C  
ATOM   1840  CD1 ILE B 129      38.929  38.448  51.803  1.00 34.16           C  
ATOM   1841  N   ALA B 130      34.072  35.643  51.733  1.00 38.41           N  
ATOM   1842  CA  ALA B 130      32.827  35.696  52.137  1.00 37.07           C  
ATOM   1843  C   ALA B 130      31.640  35.307  51.256  1.00 38.62           C  
ATOM   1844  O   ALA B 130      30.456  35.135  51.883  1.00 42.67           O  
ATOM   1845  CB  ALA B 130      32.609  36.866  52.782  1.00 37.11           C  
ATOM   1846  N   GLN B 131      31.717  35.039  49.980  1.00 35.18           N  
ATOM   1847  CA  GLN B 131      30.413  34.356  49.488  1.00 32.90           C  
ATOM   1848  C   GLN B 131      29.092  34.993  49.878  1.00 29.25           C  
ATOM   1849  O   GLN B 131      28.625  34.986  51.008  1.00 30.23           O  
ATOM   1850  CB  GLN B 131      30.306  32.871  49.918  1.00 32.76           C  
ATOM   1851  CG  GLN B 131      30.886  31.842  48.872  1.00 38.55           C  
ATOM   1852  CD  GLN B 131      29.813  31.520  47.967  1.00 42.26           C  
ATOM   1853  OE1 GLN B 131      29.574  32.371  47.132  1.00 53.25           O  
ATOM   1854  NE2 GLN B 131      28.989  30.411  48.240  1.00 33.70           N  
ATOM   1855  N   GLY B 132      28.364  35.400  48.942  1.00 28.20           N  
ATOM   1856  CA  GLY B 132      27.211  36.098  49.265  1.00 28.09           C  
ATOM   1857  C   GLY B 132      26.306  35.712  48.161  1.00 30.03           C  
ATOM   1858  O   GLY B 132      26.791  35.405  47.056  1.00 28.11           O  
ATOM   1859  N   ARG B 133      24.961  35.823  48.440  1.00 33.45           N  
ATOM   1860  CA  ARG B 133      23.872  35.604  47.412  1.00 35.15           C  
ATOM   1861  C   ARG B 133      22.776  36.628  47.504  1.00 35.25           C  
ATOM   1862  O   ARG B 133      22.474  37.156  48.577  1.00 34.59           O  
ATOM   1863  CB  ARG B 133      23.344  34.241  47.610  1.00 38.49           C  
ATOM   1864  CG  ARG B 133      22.892  33.511  46.287  1.00 48.26           C  
ATOM   1865  CD  ARG B 133      22.044  32.005  46.472  1.00 48.43           C  
ATOM   1866  NE  ARG B 133      22.804  31.092  47.276  1.00 37.67           N  
ATOM   1867  CZ  ARG B 133      22.462  30.825  48.419  1.00 30.00           C  
ATOM   1868  NH1 ARG B 133      23.348  30.068  49.044  1.00 31.33           N  
ATOM   1869  NH2 ARG B 133      21.287  31.299  48.899  1.00 26.47           N  
ATOM   1870  N   HIS B 134      22.422  37.118  46.350  1.00 37.22           N  
ATOM   1871  CA  HIS B 134      21.631  38.402  46.192  1.00 39.13           C  
ATOM   1872  C   HIS B 134      20.557  38.254  45.086  1.00 37.25           C  
ATOM   1873  O   HIS B 134      20.908  38.000  43.969  1.00 36.27           O  
ATOM   1874  CB  HIS B 134      22.539  39.677  45.768  1.00 45.56           C  
ATOM   1875  CG  HIS B 134      21.846  41.115  45.740  1.00 43.85           C  
ATOM   1876  ND1 HIS B 134      21.508  41.826  46.844  1.00 47.74           N  
ATOM   1877  CD2 HIS B 134      21.583  41.922  44.733  1.00 44.18           C  
ATOM   1878  CE1 HIS B 134      20.930  42.916  46.525  1.00 44.10           C  
ATOM   1879  NE2 HIS B 134      21.001  43.012  45.235  1.00 43.95           N  
ATOM   1880  N   THR B 135      19.316  38.497  45.459  1.00 35.64           N  
ATOM   1881  CA  THR B 135      18.187  38.355  44.727  1.00 37.27           C  
ATOM   1882  C   THR B 135      17.585  39.695  44.539  1.00 32.86           C  
ATOM   1883  O   THR B 135      17.200  40.318  45.503  1.00 32.78           O  
ATOM   1884  CB  THR B 135      16.940  37.468  45.502  1.00 40.77           C  
ATOM   1885  OG1 THR B 135      17.279  36.488  46.554  1.00 54.20           O  
ATOM   1886  CG2 THR B 135      16.360  36.578  44.606  1.00 42.47           C  
ATOM   1887  N   LYS B 136      17.394  40.022  43.347  1.00 29.37           N  
ATOM   1888  CA  LYS B 136      16.695  41.194  42.987  1.00 34.59           C  
ATOM   1889  C   LYS B 136      15.494  41.036  42.092  1.00 36.56           C  
ATOM   1890  O   LYS B 136      15.359  40.139  41.169  1.00 35.03           O  
ATOM   1891  CB  LYS B 136      17.686  42.093  42.110  1.00 40.01           C  
ATOM   1892  CG  LYS B 136      19.087  42.533  42.954  1.00 38.11           C  
ATOM   1893  CD  LYS B 136      19.826  43.628  42.263  1.00 39.46           C  
ATOM   1894  CE  LYS B 136      19.430  45.065  42.434  1.00 40.41           C  
ATOM   1895  NZ  LYS B 136      19.625  46.111  43.786  1.00 54.69           N  
ATOM   1896  N   HIS B 137      14.599  41.933  42.339  1.00 40.18           N  
ATOM   1897  CA  HIS B 137      13.447  42.090  41.495  1.00 47.72           C  
ATOM   1898  C   HIS B 137      13.467  43.057  40.314  1.00 49.31           C  
ATOM   1899  O   HIS B 137      13.814  44.224  40.535  1.00 53.31           O  
ATOM   1900  CB  HIS B 137      12.476  42.787  42.379  1.00 51.69           C  
ATOM   1901  CG  HIS B 137      11.063  42.669  41.884  1.00 64.58           C  
ATOM   1902  ND1 HIS B 137      10.557  41.492  41.358  1.00 74.37           N  
ATOM   1903  CD2 HIS B 137      10.048  43.546  41.885  1.00 75.04           C  
ATOM   1904  CE1 HIS B 137       9.268  41.611  41.160  1.00 74.84           C  
ATOM   1905  NE2 HIS B 137       8.944  42.853  41.455  1.00 80.60           N  
ATOM   1906  N   LEU B 138      13.148  42.663  39.127  1.00 50.51           N  
ATOM   1907  CA  LEU B 138      13.442  43.503  37.983  1.00 53.45           C  
ATOM   1908  C   LEU B 138      12.331  44.563  37.702  1.00 60.47           C  
ATOM   1909  O   LEU B 138      11.645  44.624  36.641  1.00 54.28           O  
ATOM   1910  CB  LEU B 138      13.741  42.719  36.751  1.00 51.29           C  
ATOM   1911  CG  LEU B 138      14.942  41.851  37.127  1.00 53.42           C  
ATOM   1912  CD1 LEU B 138      15.097  41.240  35.858  1.00 57.79           C  
ATOM   1913  CD2 LEU B 138      16.378  42.390  37.687  1.00 48.06           C  
ATOM   1914  N   GLY B 139      12.240  45.428  38.796  1.00 69.64           N  
ATOM   1915  CA  GLY B 139      11.362  46.599  39.073  1.00 72.12           C  
ATOM   1916  C   GLY B 139      12.073  47.803  38.450  1.00 75.76           C  
ATOM   1917  O   GLY B 139      13.127  47.281  37.620  1.00 71.88           O  
TER    1918      GLY B 139                                                      
END
MOLECULE T0479.pdb
ATOM      1  N   THR     6      34.108  56.591  39.835  1.00 82.67           N  
ATOM      2  CA  THR     6      32.687  57.041  39.783  1.00 84.71           C  
ATOM      3  C   THR     6      31.847  56.242  38.792  1.00 84.83           C  
ATOM      4  O   THR     6      30.746  55.797  39.120  1.00 87.33           O  
ATOM      5  CB  THR     6      32.594  58.552  39.443  1.00 84.63           C  
ATOM      6  OG1 THR     6      32.669  59.310  40.659  1.00 80.59           O  
ATOM      7  CG2 THR     6      31.288  58.884  38.714  1.00 85.06           C  
ATOM      8  N   ASP     7      32.357  56.052  37.583  1.00 82.92           N  
ATOM      9  CA  ASP     7      31.608  55.292  36.597  1.00 82.53           C  
ATOM     10  C   ASP     7      31.505  53.876  37.126  1.00 82.43           C  
ATOM     11  O   ASP     7      32.507  53.164  37.202  1.00 83.40           O  
ATOM     12  CB  ASP     7      32.337  55.281  35.254  1.00 83.34           C  
ATOM     13  CG  ASP     7      31.398  55.058  34.080  1.00 83.13           C  
ATOM     14  OD1 ASP     7      31.411  55.902  33.161  1.00 90.62           O  
ATOM     15  OD2 ASP     7      30.652  54.052  34.068  1.00 82.94           O  
ATOM     16  N   PHE     8      30.302  53.477  37.524  1.00 81.00           N  
ATOM     17  CA  PHE     8      30.095  52.129  38.022  1.00 78.25           C  
ATOM     18  C   PHE     8      29.206  51.420  37.035  1.00 78.12           C  
ATOM     19  O   PHE     8      27.993  51.364  37.192  1.00 78.37           O  
ATOM     20  CB  PHE     8      29.455  52.141  39.411  1.00 77.96           C  
ATOM     21  CG  PHE     8      30.418  52.466  40.517  1.00 75.33           C  
ATOM     22  CD1 PHE     8      30.264  53.616  41.272  1.00 73.58           C  
ATOM     23  CD2 PHE     8      31.496  51.628  40.791  1.00 69.75           C  
ATOM     24  CE1 PHE     8      31.172  53.932  42.287  1.00 72.35           C  
ATOM     25  CE2 PHE     8      32.404  51.929  41.799  1.00 67.03           C  
ATOM     26  CZ  PHE     8      32.243  53.085  42.549  1.00 69.31           C  
ATOM     27  N   PHE     9      29.835  50.909  35.989  1.00 79.06           N  
ATOM     28  CA  PHE     9      29.150  50.169  34.948  1.00 79.09           C  
ATOM     29  C   PHE     9      27.978  50.911  34.325  1.00 79.86           C  
ATOM     30  O   PHE     9      26.979  50.298  33.945  1.00 80.70           O  
ATOM     31  CB  PHE     9      28.690  48.836  35.517  1.00 79.01           C  
ATOM     32  CG  PHE     9      29.776  48.084  36.228  1.00 77.86           C  
ATOM     33  CD1 PHE     9      30.883  47.602  35.536  1.00 80.20           C  
ATOM     34  CD2 PHE     9      29.691  47.850  37.594  1.00 75.84           C  
ATOM     35  CE1 PHE     9      31.889  46.890  36.201  1.00 77.51           C  
ATOM     36  CE2 PHE     9      30.689  47.142  38.263  1.00 74.21           C  
ATOM     37  CZ  PHE     9      31.788  46.661  37.567  1.00 74.96           C  
ATOM     38  N   GLY    10      28.102  52.230  34.216  1.00 81.37           N  
ATOM     39  CA  GLY    10      27.041  53.016  33.610  1.00 81.99           C  
ATOM     40  C   GLY    10      26.223  53.898  34.534  1.00 82.45           C  
ATOM     41  O   GLY    10      25.148  54.363  34.148  1.00 83.24           O  
ATOM     42  N   LEU    11      26.724  54.138  35.742  1.00 81.84           N  
ATOM     43  CA  LEU    11      26.015  54.971  36.704  1.00 80.93           C  
ATOM     44  C   LEU    11      26.885  55.422  37.864  1.00 81.11           C  
ATOM     45  O   LEU    11      27.854  54.752  38.224  1.00 81.55           O  
ATOM     46  CB  LEU    11      24.792  54.226  37.245  1.00 82.16           C  
ATOM     47  CG  LEU    11      24.869  52.706  37.388  1.00 80.12           C  
ATOM     48  CD1 LEU    11      24.789  52.279  38.854  1.00 80.11           C  
ATOM     49  CD2 LEU    11      23.717  52.108  36.594  1.00 78.58           C  
ATOM     50  N   THR    12      26.541  56.567  38.444  1.00 81.94           N  
ATOM     51  CA  THR    12      27.287  57.083  39.583  1.00 81.54           C  
ATOM     52  C   THR    12      26.555  56.700  40.869  1.00 80.32           C  
ATOM     53  O   THR    12      25.343  56.884  40.994  1.00 80.81           O  
ATOM     54  CB  THR    12      27.491  58.640  39.490  1.00 82.25           C  
ATOM     55  OG1 THR    12      27.647  59.186  40.808  1.00 81.93           O  
ATOM     56  CG2 THR    12      26.328  59.308  38.779  1.00 80.77           C  
ATOM     57  N   ILE    13      27.311  56.133  41.803  1.00 78.25           N  
ATOM     58  CA  ILE    13      26.793  55.681  43.085  1.00 73.63           C  
ATOM     59  C   ILE    13      27.597  56.362  44.187  1.00 72.82           C  
ATOM     60  O   ILE    13      28.654  55.878  44.583  1.00 73.86           O  
ATOM     61  CB  ILE    13      26.945  54.157  43.209  1.00 72.50           C  
ATOM     62  CG1 ILE    13      26.386  53.476  41.959  1.00 70.72           C  
ATOM     63  CG2 ILE    13      26.218  53.660  44.444  1.00 69.64           C  
ATOM     64  CD1 ILE    13      26.615  51.973  41.912  1.00 66.94           C  
ATOM     65  N   PRO    14      27.097  57.496  44.701  1.00 71.54           N  
ATOM     66  CA  PRO    14      27.744  58.277  45.759  1.00 70.83           C  
ATOM     67  C   PRO    14      28.279  57.487  46.948  1.00 70.92           C  
ATOM     68  O   PRO    14      29.261  57.894  47.573  1.00 72.37           O  
ATOM     69  CB  PRO    14      26.659  59.259  46.170  1.00 70.62           C  
ATOM     70  CG  PRO    14      25.953  59.505  44.881  1.00 70.49           C  
ATOM     71  CD  PRO    14      25.818  58.114  44.315  1.00 70.58           C  
ATOM     72  N   PHE    15      27.644  56.369  47.277  1.00 70.30           N  
ATOM     73  CA  PHE    15      28.112  55.580  48.413  1.00 68.63           C  
ATOM     74  C   PHE    15      29.290  54.712  47.992  1.00 69.27           C  
ATOM     75  O   PHE    15      30.270  54.582  48.727  1.00 68.96           O  
ATOM     76  CB  PHE    15      26.985  54.703  48.979  1.00 66.76           C  
ATOM     77  CG  PHE    15      27.407  53.863  50.158  1.00 62.75           C  
ATOM     78  CD1 PHE    15      27.964  54.455  51.288  1.00 65.47           C  
ATOM     79  CD2 PHE    15      27.258  52.480  50.135  1.00 60.04           C  
ATOM     80  CE1 PHE    15      28.366  53.683  52.381  1.00 63.65           C  
ATOM     81  CE2 PHE    15      27.656  51.697  51.219  1.00 59.43           C  
ATOM     82  CZ  PHE    15      28.212  52.301  52.347  1.00 57.78           C  
ATOM     83  N   MET    16      29.191  54.120  46.806  1.00 68.50           N  
ATOM     84  CA  MET    16      30.266  53.276  46.314  1.00 69.92           C  
ATOM     85  C   MET    16      31.532  54.105  46.109  1.00 70.28           C  
ATOM     86  O   MET    16      32.628  53.687  46.484  1.00 69.63           O  
ATOM     87  CB  MET    16      29.843  52.593  45.012  1.00 68.25           C  
ATOM     88  CG  MET    16      28.836  51.462  45.210  1.00 71.30           C  
ATOM     89  SD  MET    16      29.518  49.996  46.318  1.00 82.26          SE  
ATOM     90  CE  MET    16      28.397  50.232  47.881  1.00 81.23           C  
ATOM     91  N   GLN    17      31.367  55.287  45.525  1.00 71.35           N  
ATOM     92  CA  GLN    17      32.486  56.187  45.280  1.00 73.14           C  
ATOM     93  C   GLN    17      33.152  56.495  46.615  1.00 72.71           C  
ATOM     94  O   GLN    17      34.353  56.744  46.677  1.00 72.94           O  
ATOM     95  CB  GLN    17      31.983  57.490  44.639  1.00 74.17           C  
ATOM     96  CG  GLN    17      33.075  58.494  44.271  1.00 78.87           C  
ATOM     97  CD  GLN    17      32.597  59.942  44.333  1.00 85.45           C  
ATOM     98  OE1 GLN    17      31.612  60.318  43.696  1.00 90.09           O  
ATOM     99  NE2 GLN    17      33.302  60.762  45.105  1.00 86.55           N  
ATOM    100  N   LEU    18      32.356  56.466  47.683  1.00 72.85           N  
ATOM    101  CA  LEU    18      32.837  56.759  49.032  1.00 71.27           C  
ATOM    102  C   LEU    18      33.668  55.626  49.622  1.00 71.30           C  
ATOM    103  O   LEU    18      34.567  55.862  50.431  1.00 70.93           O  
ATOM    104  CB  LEU    18      31.647  57.058  49.950  1.00 70.66           C  
ATOM    105  CG  LEU    18      31.844  57.860  51.244  1.00 69.80           C  
ATOM    106  CD1 LEU    18      31.930  56.948  52.446  1.00 73.18           C  
ATOM    107  CD2 LEU    18      33.078  58.730  51.117  1.00 67.63           C  
ATOM    108  N   LEU    19      33.362  54.396  49.214  1.00 71.25           N  
ATOM    109  CA  LEU    19      34.081  53.224  49.701  1.00 71.47           C  
ATOM    110  C   LEU    19      35.415  53.043  48.998  1.00 73.05           C  
ATOM    111  O   LEU    19      36.224  52.201  49.390  1.00 73.88           O  
ATOM    112  CB  LEU    19      33.246  51.963  49.496  1.00 70.20           C  
ATOM    113  CG  LEU    19      32.009  51.732  50.363  1.00 69.28           C  
ATOM    114  CD1 LEU    19      31.332  50.437  49.937  1.00 64.95           C  
ATOM    115  CD2 LEU    19      32.405  51.662  51.830  1.00 66.56           C  
ATOM    116  N   GLY    20      35.643  53.827  47.951  1.00 74.73           N  
ATOM    117  CA  GLY    20      36.885  53.704  47.211  1.00 75.28           C  
ATOM    118  C   GLY    20      36.969  52.336  46.555  1.00 76.69           C  
ATOM    119  O   GLY    20      37.965  51.628  46.709  1.00 76.35           O  
ATOM    120  N   VAL    21      35.913  51.954  45.839  1.00 75.90           N  
ATOM    121  CA  VAL    21      35.890  50.665  45.161  1.00 74.91           C  
ATOM    122  C   VAL    21      36.060  50.871  43.656  1.00 74.23           C  
ATOM    123  O   VAL    21      35.609  51.876  43.102  1.00 74.26           O  
ATOM    124  CB  VAL    21      34.569  49.882  45.455  1.00 75.48           C  
ATOM    125  CG1 VAL    21      33.353  50.705  45.059  1.00 75.56           C  
ATOM    126  CG2 VAL    21      34.576  48.554  44.708  1.00 75.52           C  
ATOM    127  N   VAL    22      36.712  49.920  42.997  1.00 73.26           N  
ATOM    128  CA  VAL    22      36.955  50.026  41.563  1.00 71.22           C  
ATOM    129  C   VAL    22      36.297  48.933  40.714  1.00 69.51           C  
ATOM    130  O   VAL    22      36.493  47.745  40.956  1.00 69.28           O  
ATOM    131  CB  VAL    22      38.481  50.019  41.277  1.00 71.44           C  
ATOM    132  CG1 VAL    22      38.734  50.139  39.788  1.00 72.67           C  
ATOM    133  CG2 VAL    22      39.153  51.152  42.024  1.00 68.35           C  
ATOM    134  N   PRO    23      35.488  49.332  39.713  1.00 68.68           N  
ATOM    135  CA  PRO    23      34.795  48.412  38.803  1.00 69.35           C  
ATOM    136  C   PRO    23      35.821  47.787  37.856  1.00 70.07           C  
ATOM    137  O   PRO    23      36.584  48.493  37.208  1.00 70.33           O  
ATOM    138  CB  PRO    23      33.787  49.320  38.085  1.00 68.77           C  
ATOM    139  CG  PRO    23      34.445  50.640  38.103  1.00 69.37           C  
ATOM    140  CD  PRO    23      35.035  50.715  39.491  1.00 68.21           C  
ATOM    141  N   GLU    24      35.827  46.463  37.774  1.00 71.08           N  
ATOM    142  CA  GLU    24      36.811  45.762  36.956  1.00 71.52           C  
ATOM    143  C   GLU    24      36.266  45.026  35.724  1.00 71.28           C  
ATOM    144  O   GLU    24      37.016  44.737  34.787  1.00 72.41           O  
ATOM    145  CB  GLU    24      37.571  44.789  37.863  1.00 71.19           C  
ATOM    146  CG  GLU    24      39.055  44.645  37.574  1.00 74.13           C  
ATOM    147  CD  GLU    24      39.917  44.750  38.828  1.00 77.25           C  
ATOM    148  OE1 GLU    24      40.224  45.885  39.255  1.00 83.15           O  
ATOM    149  OE2 GLU    24      40.295  43.699  39.387  1.00 77.85           O  
ATOM    150  N   HIS    25      34.967  44.735  35.719  1.00 70.76           N  
ATOM    151  CA  HIS    25      34.342  44.017  34.613  1.00 68.54           C  
ATOM    152  C   HIS    25      32.855  43.809  34.849  1.00 68.40           C  
ATOM    153  O   HIS    25      32.388  43.788  35.984  1.00 69.03           O  
ATOM    154  CB  HIS    25      35.002  42.646  34.430  1.00 67.13           C  
ATOM    155  CG  HIS    25      34.233  41.710  33.551  1.00 66.67           C  
ATOM    156  ND1 HIS    25      34.002  40.394  33.883  1.00 64.69           N  
ATOM    157  CD2 HIS    25      33.623  41.902  32.352  1.00 67.64           C  
ATOM    158  CE1 HIS    25      33.284  39.814  32.935  1.00 66.58           C  
ATOM    159  NE2 HIS    25      33.043  40.713  31.996  1.00 67.15           N  
ATOM    160  N   SER    26      32.122  43.645  33.755  1.00 68.39           N  
ATOM    161  CA  SER    26      30.692  43.402  33.785  1.00 67.02           C  
ATOM    162  C   SER    26      30.240  43.026  32.388  1.00 66.04           C  
ATOM    163  O   SER    26      30.387  43.804  31.449  1.00 68.32           O  
ATOM    164  CB  SER    26      29.936  44.647  34.243  1.00 68.40           C  
ATOM    165  OG  SER    26      28.563  44.537  33.896  1.00 69.94           O  
ATOM    166  N   GLY    27      29.690  41.828  32.252  1.00 63.41           N  
ATOM    167  CA  GLY    27      29.224  41.394  30.954  1.00 59.63           C  
ATOM    168  C   GLY    27      29.182  39.889  30.902  1.00 57.60           C  
ATOM    169  O   GLY    27      29.900  39.221  31.635  1.00 59.65           O  
ATOM    170  N   ASN    28      28.337  39.354  30.032  1.00 58.55           N  
ATOM    171  CA  ASN    28      28.200  37.912  29.878  1.00 59.88           C  
ATOM    172  C   ASN    28      27.865  37.168  31.165  1.00 60.45           C  
ATOM    173  O   ASN    28      28.385  36.085  31.409  1.00 58.08           O  
ATOM    174  CB  ASN    28      29.481  37.352  29.275  1.00 61.54           C  
ATOM    175  CG  ASN    28      29.808  37.982  27.943  1.00 59.96           C  
ATOM    176  OD1 ASN    28      29.020  37.900  27.004  1.00 57.88           O  
ATOM    177  ND2 ASN    28      30.971  38.636  27.858  1.00 52.70           N  
ATOM    178  N   GLY    29      27.005  37.764  31.984  1.00 58.42           N  
ATOM    179  CA  GLY    29      26.598  37.118  33.217  1.00 59.39           C  
ATOM    180  C   GLY    29      27.591  37.028  34.362  1.00 58.49           C  
ATOM    181  O   GLY    29      27.400  36.212  35.263  1.00 58.96           O  
ATOM    182  N   THR    30      28.647  37.836  34.339  1.00 55.83           N  
ATOM    183  CA  THR    30      29.626  37.818  35.419  1.00 55.20           C  
ATOM    184  C   THR    30      30.039  39.253  35.687  1.00 54.78           C  
ATOM    185  O   THR    30      29.687  40.152  34.930  1.00 56.63           O  
ATOM    186  CB  THR    30      30.904  37.026  35.054  1.00 55.53           C  
ATOM    187  OG1 THR    30      31.572  37.684  33.977  1.00 59.89           O  
ATOM    188  CG2 THR    30      30.580  35.605  34.655  1.00 55.82           C  
ATOM    189  N   ALA    31      30.784  39.474  36.764  1.00 51.78           N  
ATOM    190  CA  ALA    31      31.237  40.818  37.076  1.00 52.61           C  
ATOM    191  C   ALA    31      32.450  40.790  38.010  1.00 53.18           C  
ATOM    192  O   ALA    31      32.691  39.810  38.709  1.00 52.70           O  
ATOM    193  CB  ALA    31      30.097  41.623  37.693  1.00 51.77           C  
ATOM    194  N   ARG    32      33.225  41.869  38.002  1.00 53.91           N  
ATOM    195  CA  ARG    32      34.407  41.932  38.849  1.00 55.41           C  
ATOM    196  C   ARG    32      34.550  43.326  39.411  1.00 54.45           C  
ATOM    197  O   ARG    32      34.304  44.324  38.727  1.00 51.64           O  
ATOM    198  CB  ARG    32      35.682  41.577  38.061  1.00 56.29           C  
ATOM    199  CG  ARG    32      36.710  40.769  38.870  1.00 60.83           C  
ATOM    200  CD  ARG    32      38.165  41.219  38.659  1.00 68.82           C  
ATOM    201  NE  ARG    32      38.433  41.696  37.302  1.00 67.14           N  
ATOM    202  CZ  ARG    32      38.391  40.946  36.205  1.00 66.56           C  
ATOM    203  NH1 ARG    32      38.096  39.654  36.281  1.00 67.50           N  
ATOM    204  NH2 ARG    32      38.623  41.502  35.025  1.00 69.78           N  
ATOM    205  N   THR    33      34.960  43.386  40.667  1.00 54.04           N  
ATOM    206  CA  THR    33      35.150  44.655  41.328  1.00 54.88           C  
ATOM    207  C   THR    33      36.340  44.494  42.275  1.00 55.51           C  
ATOM    208  O   THR    33      36.741  43.371  42.579  1.00 52.87           O  
ATOM    209  CB  THR    33      33.852  45.066  42.075  1.00 55.35           C  
ATOM    210  OG1 THR    33      33.558  46.442  41.790  1.00 60.23           O  
ATOM    211  CG2 THR    33      33.996  44.881  43.573  1.00 52.69           C  
ATOM    212  N   ARG    34      36.904  45.603  42.744  1.00 58.33           N  
ATOM    213  CA  ARG    34      38.070  45.520  43.620  1.00 61.57           C  
ATOM    214  C   ARG    34      38.011  46.499  44.783  1.00 61.13           C  
ATOM    215  O   ARG    34      37.666  47.668  44.602  1.00 62.13           O  
ATOM    216  CB  ARG    34      39.332  45.759  42.779  1.00 63.11           C  
ATOM    217  CG  ARG    34      40.654  45.547  43.495  1.00 67.81           C  
ATOM    218  CD  ARG    34      41.235  46.851  44.018  1.00 80.63           C  
ATOM    219  NE  ARG    34      42.681  46.919  43.799  1.00 88.82           N  
ATOM    220  CZ  ARG    34      43.252  46.975  42.600  1.00 92.25           C  
ATOM    221  NH1 ARG    34      42.495  46.976  41.508  1.00 90.51           N  
ATOM    222  NH2 ARG    34      44.577  47.025  42.491  1.00 94.91           N  
ATOM    223  N   LEU    35      38.362  46.027  45.976  1.00 60.79           N  
ATOM    224  CA  LEU    35      38.335  46.890  47.153  1.00 61.51           C  
ATOM    225  C   LEU    35      39.714  47.210  47.733  1.00 62.84           C  
ATOM    226  O   LEU    35      40.231  46.501  48.599  1.00 62.23           O  
ATOM    227  CB  LEU    35      37.448  46.280  48.255  1.00 59.96           C  
ATOM    228  CG  LEU    35      37.249  47.164  49.495  1.00 60.64           C  
ATOM    229  CD1 LEU    35      36.531  48.452  49.101  1.00 59.80           C  
ATOM    230  CD2 LEU    35      36.457  46.414  50.561  1.00 58.70           C  
ATOM    231  N   PRO    36      40.331  48.295  47.251  1.00 65.05           N  
ATOM    232  CA  PRO    36      41.650  48.673  47.763  1.00 67.72           C  
ATOM    233  C   PRO    36      41.585  48.959  49.265  1.00 70.63           C  
ATOM    234  O   PRO    36      40.669  49.627  49.738  1.00 71.74           O  
ATOM    235  CB  PRO    36      42.014  49.907  46.923  1.00 67.73           C  
ATOM    236  CG  PRO    36      40.688  50.407  46.404  1.00 66.37           C  
ATOM    237  CD  PRO    36      39.927  49.153  46.126  1.00 64.71           C  
ATOM    238  N   ALA    37      42.554  48.433  50.005  1.00 72.73           N  
ATOM    239  CA  ALA    37      42.600  48.610  51.448  1.00 74.97           C  
ATOM    240  C   ALA    37      42.575  50.073  51.880  1.00 78.06           C  
ATOM    241  O   ALA    37      43.148  50.945  51.224  1.00 79.38           O  
ATOM    242  CB  ALA    37      43.831  47.931  52.011  1.00 75.09           C  
ATOM    243  N   ARG    38      41.900  50.325  52.996  1.00 79.16           N  
ATOM    244  CA  ARG    38      41.790  51.660  53.563  1.00 78.26           C  
ATOM    245  C   ARG    38      41.540  51.448  55.042  1.00 77.89           C  
ATOM    246  O   ARG    38      41.137  50.362  55.451  1.00 78.49           O  
ATOM    247  CB  ARG    38      40.625  52.421  52.930  1.00 77.89           C  
ATOM    248  CG  ARG    38      40.756  53.926  53.029  1.00 79.53           C  
ATOM    249  CD  ARG    38      40.565  54.586  51.666  1.00 82.14           C  
ATOM    250  NE  ARG    38      39.190  54.513  51.173  1.00 81.39           N  
ATOM    251  CZ  ARG    38      38.162  55.157  51.718  1.00 84.11           C  
ATOM    252  NH1 ARG    38      38.346  55.925  52.782  1.00 89.00           N  
ATOM    253  NH2 ARG    38      36.949  55.048  51.192  1.00 82.94           N  
ATOM    254  N   ALA    39      41.789  52.471  55.843  1.00 78.61           N  
ATOM    255  CA  ALA    39      41.587  52.371  57.281  1.00 78.25           C  
ATOM    256  C   ALA    39      40.191  52.864  57.650  1.00 77.22           C  
ATOM    257  O   ALA    39      39.693  52.599  58.737  1.00 76.90           O  
ATOM    258  CB  ALA    39      42.655  53.188  58.002  1.00 79.37           C  
ATOM    259  N   ASP    40      39.573  53.583  56.716  1.00 77.54           N  
ATOM    260  CA  ASP    40      38.217  54.117  56.874  1.00 77.22           C  
ATOM    261  C   ASP    40      37.272  52.931  56.852  1.00 76.30           C  
ATOM    262  O   ASP    40      36.191  52.953  57.435  1.00 76.53           O  
ATOM    263  CB  ASP    40      37.834  54.985  55.677  1.00 77.80           C  
ATOM    264  CG  ASP    40      38.088  56.456  55.898  1.00 85.99           C  
ATOM    265  OD1 ASP    40      39.237  56.832  56.212  1.00 98.38           O  
ATOM    266  OD2 ASP    40      37.132  57.245  55.730  1.00 90.77           O  
ATOM    267  N   LEU    41      37.705  51.895  56.151  1.00 75.06           N  
ATOM    268  CA  LEU    41      36.892  50.708  55.945  1.00 72.63           C  
ATOM    269  C   LEU    41      37.057  49.515  56.884  1.00 71.44           C  
ATOM    270  O   LEU    41      36.544  48.441  56.592  1.00 70.58           O  
ATOM    271  CB  LEU    41      37.106  50.251  54.505  1.00 71.79           C  
ATOM    272  CG  LEU    41      37.033  51.397  53.492  1.00 68.81           C  
ATOM    273  CD1 LEU    41      37.246  50.882  52.077  1.00 64.95           C  
ATOM    274  CD2 LEU    41      35.679  52.077  53.620  1.00 69.58           C  
ATOM    275  N   VAL    42      37.726  49.703  58.018  1.00 71.99           N  
ATOM    276  CA  VAL    42      37.962  48.591  58.931  1.00 72.06           C  
ATOM    277  C   VAL    42      37.052  48.400  60.152  1.00 73.10           C  
ATOM    278  O   VAL    42      36.355  49.307  60.612  1.00 73.13           O  
ATOM    279  CB  VAL    42      39.415  48.608  59.414  1.00 72.55           C  
ATOM    280  CG1 VAL    42      40.361  48.501  58.217  1.00 71.29           C  
ATOM    281  CG2 VAL    42      39.678  49.895  60.186  1.00 74.55           C  
ATOM    282  N   ASN    43      37.100  47.174  60.660  1.00 73.75           N  
ATOM    283  CA  ASN    43      36.350  46.720  61.813  1.00 73.70           C  
ATOM    284  C   ASN    43      37.045  47.260  63.050  1.00 75.36           C  
ATOM    285  O   ASN    43      37.844  48.190  62.959  1.00 75.86           O  
ATOM    286  CB  ASN    43      36.381  45.198  61.840  1.00 73.88           C  
ATOM    287  CG  ASN    43      35.532  44.622  62.932  1.00 76.44           C  
ATOM    288  OD1 ASN    43      35.791  43.522  63.420  1.00 79.26           O  
ATOM    289  ND2 ASN    43      34.499  45.351  63.318  1.00 79.28           N  
ATOM    290  N   SER    44      36.739  46.673  64.203  1.00 76.37           N  
ATOM    291  CA  SER    44      37.373  47.063  65.452  1.00 76.63           C  
ATOM    292  C   SER    44      38.514  46.077  65.656  1.00 77.43           C  
ATOM    293  O   SER    44      39.480  46.368  66.354  1.00 77.64           O  
ATOM    294  CB  SER    44      36.383  46.991  66.626  1.00 76.83           C  
ATOM    295  OG  SER    44      35.894  45.674  66.832  1.00 76.34           O  
ATOM    296  N   ARG    45      38.392  44.904  65.036  1.00 77.30           N  
ATOM    297  CA  ARG    45      39.433  43.875  65.118  1.00 76.19           C  
ATOM    298  C   ARG    45      40.462  44.192  64.038  1.00 73.76           C  
ATOM    299  O   ARG    45      41.314  43.367  63.710  1.00 75.30           O  
ATOM    300  CB  ARG    45      38.855  42.474  64.863  1.00 77.62           C  
ATOM    301  CG  ARG    45      37.828  41.992  65.884  1.00 82.48           C  
ATOM    302  CD  ARG    45      38.476  41.651  67.218  1.00 89.78           C  
ATOM    303  NE  ARG    45      39.206  40.385  67.175  1.00 94.62           N  
ATOM    304  CZ  ARG    45      40.475  40.232  67.546  1.00 94.99           C  
ATOM    305  NH1 ARG    45      41.173  41.271  67.991  1.00 94.14           N  
ATOM    306  NH2 ARG    45      41.045  39.035  67.474  1.00 94.64           N  
ATOM    307  N   GLY    46      40.366  45.394  63.480  1.00 71.52           N  
ATOM    308  CA  GLY    46      41.294  45.803  62.441  1.00 69.47           C  
ATOM    309  C   GLY    46      40.961  45.261  61.065  1.00 69.13           C  
ATOM    310  O   GLY    46      41.449  45.783  60.068  1.00 70.07           O  
ATOM    311  N   ASP    47      40.134  44.215  61.018  1.00 68.65           N  
ATOM    312  CA  ASP    47      39.722  43.582  59.760  1.00 66.23           C  
ATOM    313  C   ASP    47      38.785  44.479  58.971  1.00 65.33           C  
ATOM    314  O   ASP    47      38.190  45.397  59.522  1.00 66.99           O  
ATOM    315  CB  ASP    47      38.988  42.269  60.021  1.00 65.80           C  
ATOM    316  CG  ASP    47      39.787  41.304  60.856  1.00 65.95           C  
ATOM    317  OD1 ASP    47      41.015  41.207  60.634  1.00 62.58           O  
ATOM    318  OD2 ASP    47      39.174  40.625  61.720  1.00 64.21           O  
ATOM    319  N   ILE    48      38.643  44.207  57.679  1.00 63.90           N  
ATOM    320  CA  ILE    48      37.734  44.994  56.859  1.00 63.50           C  
ATOM    321  C   ILE    48      36.328  44.661  57.367  1.00 62.00           C  
ATOM    322  O   ILE    48      35.976  43.489  57.484  1.00 61.57           O  
ATOM    323  CB  ILE    48      37.863  44.625  55.362  1.00 63.31           C  
ATOM    324  CG1 ILE    48      39.299  44.867  54.879  1.00 65.41           C  
ATOM    325  CG2 ILE    48      36.910  45.476  54.528  1.00 61.38           C  
ATOM    326  CD1 ILE    48      39.634  46.327  54.571  1.00 65.73           C  
ATOM    327  N   HIS    49      35.538  45.690  57.683  1.00 60.23           N  
ATOM    328  CA  HIS    49      34.170  45.510  58.203  1.00 57.44           C  
ATOM    329  C   HIS    49      33.256  44.751  57.240  1.00 54.86           C  
ATOM    330  O   HIS    49      33.157  45.102  56.068  1.00 54.28           O  
ATOM    331  CB  HIS    49      33.552  46.876  58.544  1.00 56.59           C  
ATOM    332  CG  HIS    49      32.349  46.792  59.433  1.00 56.51           C  
ATOM    333  ND1 HIS    49      31.101  46.436  58.975  1.00 58.06           N  
ATOM    334  CD2 HIS    49      32.216  46.972  60.772  1.00 61.56           C  
ATOM    335  CE1 HIS    49      30.251  46.396  59.986  1.00 60.97           C  
ATOM    336  NE2 HIS    49      30.905  46.718  61.088  1.00 65.28           N  
ATOM    337  N   GLY    50      32.595  43.716  57.755  1.00 54.28           N  
ATOM    338  CA  GLY    50      31.695  42.898  56.953  1.00 55.82           C  
ATOM    339  C   GLY    50      30.656  43.682  56.173  1.00 54.65           C  
ATOM    340  O   GLY    50      30.128  43.208  55.164  1.00 55.18           O  
ATOM    341  N   GLY    51      30.357  44.883  56.655  1.00 54.63           N  
ATOM    342  CA  GLY    51      29.398  45.719  55.981  1.00 55.34           C  
ATOM    343  C   GLY    51      30.061  46.240  54.732  1.00 57.54           C  
ATOM    344  O   GLY    51      29.413  46.409  53.698  1.00 58.76           O  
ATOM    345  N   THR    52      31.360  46.505  54.826  1.00 56.93           N  
ATOM    346  CA  THR    52      32.106  46.994  53.672  1.00 57.73           C  
ATOM    347  C   THR    52      32.002  45.906  52.619  1.00 55.49           C  
ATOM    348  O   THR    52      31.862  46.185  51.438  1.00 57.15           O  
ATOM    349  CB  THR    52      33.609  47.206  53.980  1.00 59.07           C  
ATOM    350  OG1 THR    52      33.767  47.832  55.261  1.00 64.70           O  
ATOM    351  CG2 THR    52      34.239  48.102  52.924  1.00 58.87           C  
ATOM    352  N   LEU    53      32.051  44.658  53.070  1.00 54.28           N  
ATOM    353  CA  LEU    53      31.973  43.510  52.177  1.00 54.38           C  
ATOM    354  C   LEU    53      30.628  43.370  51.465  1.00 55.08           C  
ATOM    355  O   LEU    53      30.581  43.246  50.238  1.00 56.03           O  
ATOM    356  CB  LEU    53      32.288  42.239  52.961  1.00 54.43           C  
ATOM    357  CG  LEU    53      33.572  42.304  53.795  1.00 52.99           C  
ATOM    358  CD1 LEU    53      33.880  40.929  54.383  1.00 55.86           C  
ATOM    359  CD2 LEU    53      34.726  42.774  52.925  1.00 55.19           C  
ATOM    360  N   MET    54      29.541  43.384  52.236  1.00 54.80           N  
ATOM    361  CA  MET    54      28.196  43.260  51.675  1.00 52.43           C  
ATOM    362  C   MET    54      27.894  44.435  50.724  1.00 52.03           C  
ATOM    363  O   MET    54      27.197  44.277  49.717  1.00 48.73           O  
ATOM    364  CB  MET    54      27.156  43.206  52.810  1.00 52.54           C  
ATOM    365  CG  MET    54      27.322  42.027  53.796  1.00 57.30           C  
ATOM    366  SD  MET    54      26.081  42.067  55.318  1.00 62.48          SE  
ATOM    367  CE  MET    54      25.966  40.226  55.821  1.00 55.10           C  
ATOM    368  N   SER    55      28.438  45.609  51.036  1.00 53.67           N  
ATOM    369  CA  SER    55      28.202  46.791  50.202  1.00 55.48           C  
ATOM    370  C   SER    55      28.807  46.581  48.826  1.00 56.00           C  
ATOM    371  O   SER    55      28.170  46.835  47.805  1.00 52.23           O  
ATOM    372  CB  SER    55      28.831  48.041  50.829  1.00 53.38           C  
ATOM    373  OG  SER    55      28.419  48.209  52.174  1.00 55.87           O  
ATOM    374  N   VAL    56      30.047  46.109  48.807  1.00 57.92           N  
ATOM    375  CA  VAL    56      30.719  45.889  47.547  1.00 57.30           C  
ATOM    376  C   VAL    56      30.127  44.653  46.873  1.00 57.04           C  
ATOM    377  O   VAL    56      30.051  44.578  45.648  1.00 58.85           O  
ATOM    378  CB  VAL    56      32.257  45.762  47.761  1.00 57.64           C  
ATOM    379  CG1 VAL    56      32.630  44.379  48.254  1.00 55.71           C  
ATOM    380  CG2 VAL    56      32.981  46.111  46.492  1.00 58.95           C  
ATOM    381  N   LEU    57      29.675  43.694  47.676  1.00 57.70           N  
ATOM    382  CA  LEU    57      29.079  42.484  47.127  1.00 57.43           C  
ATOM    383  C   LEU    57      27.716  42.797  46.524  1.00 58.80           C  
ATOM    384  O   LEU    57      27.326  42.216  45.516  1.00 60.67           O  
ATOM    385  CB  LEU    57      28.945  41.418  48.217  1.00 57.54           C  
ATOM    386  CG  LEU    57      30.007  40.319  48.211  1.00 55.85           C  
ATOM    387  CD1 LEU    57      29.865  39.434  49.442  1.00 48.35           C  
ATOM    388  CD2 LEU    57      29.846  39.493  46.940  1.00 48.05           C  
ATOM    389  N   ASP    58      26.994  43.728  47.139  1.00 58.06           N  
ATOM    390  CA  ASP    58      25.681  44.110  46.639  1.00 59.20           C  
ATOM    391  C   ASP    58      25.877  44.738  45.273  1.00 57.88           C  
ATOM    392  O   ASP    58      25.250  44.358  44.288  1.00 58.06           O  
ATOM    393  CB  ASP    58      25.027  45.123  47.585  1.00 60.09           C  
ATOM    394  CG  ASP    58      23.591  45.424  47.210  1.00 60.92           C  
ATOM    395  OD1 ASP    58      23.009  44.637  46.434  1.00 64.05           O  
ATOM    396  OD2 ASP    58      23.040  46.430  47.701  1.00 63.82           O  
ATOM    397  N   PHE    59      26.770  45.715  45.241  1.00 59.00           N  
ATOM    398  CA  PHE    59      27.117  46.424  44.024  1.00 59.42           C  
ATOM    399  C   PHE    59      27.459  45.465  42.876  1.00 58.46           C  
ATOM    400  O   PHE    59      26.895  45.545  41.786  1.00 59.38           O  
ATOM    401  CB  PHE    59      28.309  47.339  44.319  1.00 60.78           C  
ATOM    402  CG  PHE    59      28.934  47.934  43.095  1.00 69.86           C  
ATOM    403  CD1 PHE    59      28.140  48.503  42.108  1.00 72.66           C  
ATOM    404  CD2 PHE    59      30.314  47.908  42.921  1.00 75.70           C  
ATOM    405  CE1 PHE    59      28.704  49.034  40.960  1.00 84.13           C  
ATOM    406  CE2 PHE    59      30.892  48.439  41.777  1.00 85.16           C  
ATOM    407  CZ  PHE    59      30.082  49.004  40.791  1.00 89.23           C  
ATOM    408  N   THR    60      28.375  44.543  43.147  1.00 57.19           N  
ATOM    409  CA  THR    60      28.852  43.592  42.152  1.00 55.36           C  
ATOM    410  C   THR    60      27.902  42.472  41.730  1.00 55.78           C  
ATOM    411  O   THR    60      28.014  41.949  40.625  1.00 56.93           O  
ATOM    412  CB  THR    60      30.174  42.972  42.627  1.00 54.97           C  
ATOM    413  OG1 THR    60      31.009  44.011  43.157  1.00 51.98           O  
ATOM    414  CG2 THR    60      30.902  42.282  41.454  1.00 50.54           C  
ATOM    415  N   LEU    61      26.978  42.091  42.601  1.00 54.16           N  
ATOM    416  CA  LEU    61      26.039  41.039  42.254  1.00 53.20           C  
ATOM    417  C   LEU    61      25.080  41.575  41.195  1.00 53.73           C  
ATOM    418  O   LEU    61      24.756  40.893  40.222  1.00 52.67           O  
ATOM    419  CB  LEU    61      25.279  40.571  43.504  1.00 52.15           C  
ATOM    420  CG  LEU    61      26.060  39.700  44.497  1.00 50.32           C  
ATOM    421  CD1 LEU    61      25.558  39.942  45.918  1.00 49.21           C  
ATOM    422  CD2 LEU    61      25.916  38.227  44.122  1.00 47.40           C  
ATOM    423  N   GLY    62      24.633  42.808  41.379  1.00 55.99           N  
ATOM    424  CA  GLY    62      23.719  43.392  40.417  1.00 59.26           C  
ATOM    425  C   GLY    62      24.385  43.577  39.065  1.00 60.09           C  
ATOM    426  O   GLY    62      23.770  43.381  38.018  1.00 61.11           O  
ATOM    427  N   ALA    63      25.659  43.950  39.095  1.00 60.63           N  
ATOM    428  CA  ALA    63      26.419  44.172  37.873  1.00 61.18           C  
ATOM    429  C   ALA    63      26.460  42.954  36.957  1.00 60.04           C  
ATOM    430  O   ALA    63      26.575  43.105  35.750  1.00 61.51           O  
ATOM    431  CB  ALA    63      27.832  44.617  38.219  1.00 61.48           C  
ATOM    432  N   ALA    64      26.374  41.752  37.518  1.00 59.72           N  
ATOM    433  CA  ALA    64      26.404  40.539  36.700  1.00 59.00           C  
ATOM    434  C   ALA    64      25.120  40.380  35.901  1.00 61.13           C  
ATOM    435  O   ALA    64      25.025  39.523  35.024  1.00 60.65           O  
ATOM    436  CB  ALA    64      26.618  39.321  37.568  1.00 57.86           C  
ATOM    437  N   ILE    65      24.122  41.196  36.221  1.00 63.34           N  
ATOM    438  CA  ILE    65      22.853  41.143  35.506  1.00 64.35           C  
ATOM    439  C   ILE    65      22.854  42.255  34.466  1.00 65.13           C  
ATOM    440  O   ILE    65      22.716  41.997  33.278  1.00 63.47           O  
ATOM    441  CB  ILE    65      21.633  41.375  36.431  1.00 64.03           C  
ATOM    442  CG1 ILE    65      21.603  40.354  37.561  1.00 61.72           C  
ATOM    443  CG2 ILE    65      20.343  41.247  35.626  1.00 64.35           C  
ATOM    444  CD1 ILE    65      20.632  40.736  38.678  1.00 58.41           C  
ATOM    445  N   ARG    66      23.034  43.498  34.908  1.00 65.61           N  
ATOM    446  CA  ARG    66      22.991  44.625  33.971  1.00 66.75           C  
ATOM    447  C   ARG    66      24.286  45.044  33.265  1.00 65.81           C  
ATOM    448  O   ARG    66      24.657  46.225  33.243  1.00 67.92           O  
ATOM    449  CB  ARG    66      22.348  45.832  34.650  1.00 67.01           C  
ATOM    450  CG  ARG    66      22.930  46.224  35.983  1.00 70.89           C  
ATOM    451  CD  ARG    66      22.388  47.577  36.376  1.00 79.03           C  
ATOM    452  NE  ARG    66      22.696  48.583  35.361  1.00 84.60           N  
ATOM    453  CZ  ARG    66      23.885  49.155  35.206  1.00 86.35           C  
ATOM    454  NH1 ARG    66      24.893  48.825  36.008  1.00 83.77           N  
ATOM    455  NH2 ARG    66      24.062  50.059  34.249  1.00 83.22           N  
ATOM    456  N   GLY    67      24.948  44.056  32.671  1.00 61.55           N  
ATOM    457  CA  GLY    67      26.180  44.278  31.929  1.00 63.66           C  
ATOM    458  C   GLY    67      25.815  43.701  30.583  1.00 65.46           C  
ATOM    459  O   GLY    67      26.284  44.135  29.526  1.00 66.44           O  
ATOM    460  N   ASP    68      24.954  42.686  30.653  1.00 33.74           N  
ATOM    461  CA  ASP    68      24.422  42.009  29.472  1.00 33.21           C  
ATOM    462  C   ASP    68      23.369  42.986  28.987  1.00 36.28           C  
ATOM    463  O   ASP    68      22.870  42.874  27.855  1.00 71.16           O  
ATOM    464  CB  ASP    68      23.781  40.681  29.867  1.00 30.38           C  
ATOM    465  CG  ASP    68      24.819  39.640  30.230  1.00 34.25           C  
ATOM    466  OD1 ASP    68      26.007  39.875  29.876  1.00 35.02           O  
ATOM    467  OD2 ASP    68      24.481  38.589  30.842  1.00 33.10           O  
ATOM    468  N   THR    69      23.038  43.948  29.865  1.00 35.66           N  
ATOM    469  CA  THR    69      22.075  44.989  29.518  1.00 34.35           C  
ATOM    470  C   THR    69      21.996  46.196  30.461  1.00 37.99           C  
ATOM    471  O   THR    69      21.239  46.188  31.440  1.00 71.48           O  
ATOM    472  CB  THR    69      20.667  44.439  29.417  1.00 32.31           C  
ATOM    473  OG1 THR    69      20.701  43.139  28.797  1.00 33.54           O  
ATOM    474  CG2 THR    69      19.833  45.393  28.545  1.00 35.19           C  
ATOM    475  N   PRO    70      22.791  47.243  30.187  1.00 71.09           N  
ATOM    476  CA  PRO    70      22.777  48.455  31.019  1.00 70.65           C  
ATOM    477  C   PRO    70      21.468  49.209  30.766  1.00 70.27           C  
ATOM    478  O   PRO    70      21.241  50.307  31.275  1.00 69.44           O  
ATOM    479  CB  PRO    70      24.015  49.227  30.537  1.00 71.09           C  
ATOM    480  CG  PRO    70      24.252  48.684  29.133  1.00 72.04           C  
ATOM    481  CD  PRO    70      23.974  47.218  29.308  1.00 71.20           C  
ATOM    482  N   GLU    71      20.607  48.581  29.972  1.00 71.09           N  
ATOM    483  CA  GLU    71      19.312  49.150  29.616  1.00 75.30           C  
ATOM    484  C   GLU    71      18.296  48.896  30.714  1.00 78.01           C  
ATOM    485  O   GLU    71      17.318  49.623  30.850  1.00 79.60           O  
ATOM    486  CB  GLU    71      18.815  48.533  28.315  1.00 75.45           C  
ATOM    487  N   VAL    72      18.552  47.858  31.502  1.00 80.19           N  
ATOM    488  CA  VAL    72      17.645  47.444  32.562  1.00 79.15           C  
ATOM    489  C   VAL    72      17.993  47.917  33.969  1.00 79.08           C  
ATOM    490  O   VAL    72      19.128  48.300  34.268  1.00 80.56           O  
ATOM    491  CB  VAL    72      17.540  45.919  32.569  1.00 78.95           C  
ATOM    492  CG1 VAL    72      18.800  45.316  33.164  1.00 78.97           C  
ATOM    493  CG2 VAL    72      16.306  45.478  33.315  1.00 79.92           C  
ATOM    494  N   GLY    73      16.994  47.891  34.840  1.00 77.79           N  
ATOM    495  CA  GLY    73      17.215  48.295  36.213  1.00 74.50           C  
ATOM    496  C   GLY    73      17.176  47.054  37.076  1.00 72.12           C  
ATOM    497  O   GLY    73      16.435  46.124  36.778  1.00 71.30           O  
ATOM    498  N   VAL    74      18.000  47.009  38.115  1.00 69.87           N  
ATOM    499  CA  VAL    74      17.980  45.867  39.021  1.00 67.33           C  
ATOM    500  C   VAL    74      17.924  46.378  40.446  1.00 65.07           C  
ATOM    501  O   VAL    74      18.701  47.252  40.840  1.00 64.68           O  
ATOM    502  CB  VAL    74      19.230  44.925  38.893  1.00 66.36           C  
ATOM    503  CG1 VAL    74      19.382  44.433  37.469  1.00 67.21           C  
ATOM    504  CG2 VAL    74      20.488  45.624  39.395  1.00 66.08           C  
ATOM    505  N   ALA    75      16.990  45.844  41.216  1.00 62.21           N  
ATOM    506  CA  ALA    75      16.860  46.233  42.612  1.00 59.82           C  
ATOM    507  C   ALA    75      17.039  44.956  43.415  1.00 57.48           C  
ATOM    508  O   ALA    75      16.521  43.898  43.035  1.00 55.79           O  
ATOM    509  CB  ALA    75      15.487  46.840  42.869  1.00 59.11           C  
ATOM    510  N   THR    76      17.802  45.046  44.501  1.00 57.35           N  
ATOM    511  CA  THR    76      18.046  43.886  45.356  1.00 54.95           C  
ATOM    512  C   THR    76      16.774  43.588  46.149  1.00 54.39           C  
ATOM    513  O   THR    76      16.188  44.504  46.720  1.00 55.28           O  
ATOM    514  CB  THR    76      19.146  44.179  46.376  1.00 54.73           C  
ATOM    515  OG1 THR    76      20.137  45.028  45.789  1.00 53.12           O  
ATOM    516  CG2 THR    76      19.791  42.875  46.837  1.00 48.76           C  
ATOM    517  N   ILE    77      16.351  42.339  46.161  1.00 54.78           N  
ATOM    518  CA  ILE    77      15.153  41.933  46.919  1.00 53.95           C  
ATOM    519  C   ILE    77      15.629  41.454  48.293  1.00 53.85           C  
ATOM    520  O   ILE    77      15.225  41.980  49.326  1.00 53.87           O  
ATOM    521  CB  ILE    77      14.389  40.777  46.214  1.00 53.06           C  
ATOM    522  CG1 ILE    77      13.793  41.277  44.891  1.00 49.37           C  
ATOM    523  CG2 ILE    77      13.299  40.243  47.112  1.00 51.41           C  
ATOM    524  CD1 ILE    77      13.302  40.153  43.972  1.00 50.91           C  
ATOM    525  N   ASP    78      16.508  40.458  48.278  1.00 55.39           N  
ATOM    526  CA  ASP    78      17.093  39.904  49.496  1.00 55.89           C  
ATOM    527  C   ASP    78      18.510  39.412  49.202  1.00 54.38           C  
ATOM    528  O   ASP    78      18.835  39.076  48.067  1.00 53.61           O  
ATOM    529  CB  ASP    78      16.253  38.747  50.015  1.00 54.72           C  
ATOM    530  CG  ASP    78      16.001  37.701  48.953  1.00 59.69           C  
ATOM    531  OD1 ASP    78      14.817  37.481  48.619  1.00 61.41           O  
ATOM    532  OD2 ASP    78      16.980  37.107  48.448  1.00 60.49           O  
ATOM    533  N   MET    79      19.342  39.374  50.239  1.00 55.52           N  
ATOM    534  CA  MET    79      20.716  38.921  50.105  1.00 55.94           C  
ATOM    535  C   MET    79      21.201  38.170  51.340  1.00 55.05           C  
ATOM    536  O   MET    79      20.918  38.560  52.478  1.00 54.67           O  
ATOM    537  CB  MET    79      21.634  40.112  49.844  1.00 57.77           C  
ATOM    538  CG  MET    79      23.104  39.746  49.644  1.00 61.43           C  
ATOM    539  SD  MET    79      24.188  41.319  49.288  1.00 69.63          SE  
ATOM    540  CE  MET    79      23.137  41.999  47.825  1.00 68.28           C  
ATOM    541  N   ASN    80      21.939  37.097  51.098  1.00 55.10           N  
ATOM    542  CA  ASN    80      22.491  36.243  52.142  1.00 53.44           C  
ATOM    543  C   ASN    80      24.026  36.260  52.038  1.00 52.11           C  
ATOM    544  O   ASN    80      24.590  36.005  50.981  1.00 50.58           O  
ATOM    545  CB  ASN    80      21.935  34.822  51.964  1.00 53.41           C  
ATOM    546  CG  ASN    80      22.277  33.905  53.126  1.00 54.82           C  
ATOM    547  OD1 ASN    80      23.412  33.444  53.253  1.00 56.64           O  
ATOM    548  ND2 ASN    80      21.297  33.642  53.982  1.00 54.68           N  
ATOM    549  N   THR    81      24.690  36.577  53.140  1.00 52.31           N  
ATOM    550  CA  THR    81      26.142  36.657  53.148  1.00 51.58           C  
ATOM    551  C   THR    81      26.772  35.788  54.236  1.00 50.18           C  
ATOM    552  O   THR    81      26.372  35.825  55.406  1.00 47.55           O  
ATOM    553  CB  THR    81      26.595  38.130  53.333  1.00 50.52           C  
ATOM    554  OG1 THR    81      25.786  38.979  52.513  1.00 53.11           O  
ATOM    555  CG2 THR    81      28.056  38.313  52.912  1.00 51.60           C  
ATOM    556  N   SER    82      27.756  34.999  53.822  1.00 49.70           N  
ATOM    557  CA  SER    82      28.486  34.119  54.715  1.00 48.38           C  
ATOM    558  C   SER    82      29.867  34.719  54.962  1.00 49.69           C  
ATOM    559  O   SER    82      30.508  35.220  54.032  1.00 49.83           O  
ATOM    560  CB  SER    82      28.605  32.733  54.090  1.00 47.04           C  
ATOM    561  OG  SER    82      27.380  32.035  54.219  1.00 47.27           O  
ATOM    562  N   PHE    83      30.305  34.683  56.217  1.00 48.39           N  
ATOM    563  CA  PHE    83      31.596  35.233  56.601  1.00 52.04           C  
ATOM    564  C   PHE    83      32.540  34.094  56.982  1.00 53.41           C  
ATOM    565  O   PHE    83      32.405  33.475  58.034  1.00 51.27           O  
ATOM    566  CB  PHE    83      31.401  36.230  57.751  1.00 52.31           C  
ATOM    567  CG  PHE    83      30.568  37.417  57.369  1.00 48.98           C  
ATOM    568  CD1 PHE    83      31.084  38.398  56.533  1.00 47.82           C  
ATOM    569  CD2 PHE    83      29.237  37.511  57.769  1.00 47.87           C  
ATOM    570  CE1 PHE    83      30.289  39.456  56.094  1.00 48.23           C  
ATOM    571  CE2 PHE    83      28.431  38.571  57.331  1.00 50.92           C  
ATOM    572  CZ  PHE    83      28.956  39.538  56.494  1.00 47.91           C  
ATOM    573  N   MET    84      33.502  33.828  56.103  1.00 56.89           N  
ATOM    574  CA  MET    84      34.440  32.731  56.301  1.00 59.89           C  
ATOM    575  C   MET    84      35.791  33.067  56.893  1.00 60.24           C  
ATOM    576  O   MET    84      36.319  32.314  57.712  1.00 60.94           O  
ATOM    577  CB  MET    84      34.684  32.014  54.981  1.00 60.79           C  
ATOM    578  CG  MET    84      33.579  31.076  54.553  1.00 67.59           C  
ATOM    579  SD  MET    84      32.327  31.852  53.306  1.00 82.87          SE  
ATOM    580  CE  MET    84      31.428  30.224  52.768  1.00 74.13           C  
ATOM    581  N   SER    85      36.350  34.189  56.463  1.00 62.74           N  
ATOM    582  CA  SER    85      37.663  34.601  56.904  1.00 65.29           C  
ATOM    583  C   SER    85      37.779  36.104  56.991  1.00 67.79           C  
ATOM    584  O   SER    85      37.254  36.828  56.149  1.00 68.96           O  
ATOM    585  CB  SER    85      38.706  34.086  55.915  1.00 65.16           C  
ATOM    586  OG  SER    85      38.545  32.696  55.708  1.00 67.38           O  
ATOM    587  N   PRO    86      38.474  36.593  58.021  1.00 68.91           N  
ATOM    588  CA  PRO    86      38.650  38.034  58.184  1.00 69.20           C  
ATOM    589  C   PRO    86      39.234  38.589  56.898  1.00 69.57           C  
ATOM    590  O   PRO    86      40.109  37.973  56.303  1.00 69.70           O  
ATOM    591  CB  PRO    86      39.628  38.129  59.352  1.00 70.10           C  
ATOM    592  CG  PRO    86      39.254  36.938  60.189  1.00 69.38           C  
ATOM    593  CD  PRO    86      39.057  35.851  59.154  1.00 68.26           C  
ATOM    594  N   GLY    87      38.742  39.745  56.469  1.00 71.21           N  
ATOM    595  CA  GLY    87      39.238  40.352  55.246  1.00 70.14           C  
ATOM    596  C   GLY    87      40.309  41.386  55.524  1.00 71.08           C  
ATOM    597  O   GLY    87      40.143  42.241  56.393  1.00 70.15           O  
ATOM    598  N   ARG    88      41.409  41.313  54.778  1.00 72.20           N  
ATOM    599  CA  ARG    88      42.517  42.243  54.947  1.00 71.33           C  
ATOM    600  C   ARG    88      43.218  42.528  53.626  1.00 71.05           C  
ATOM    601  O   ARG    88      43.272  41.670  52.749  1.00 71.84           O  
ATOM    602  CB  ARG    88      43.516  41.671  55.954  1.00 72.66           C  
ATOM    603  CG  ARG    88      42.998  41.644  57.382  1.00 72.27           C  
ATOM    604  CD  ARG    88      43.927  40.870  58.295  1.00 76.68           C  
ATOM    605  NE  ARG    88      43.204  39.848  59.050  1.00 79.59           N  
ATOM    606  CZ  ARG    88      43.741  39.114  60.017  1.00 79.58           C  
ATOM    607  NH1 ARG    88      45.013  39.287  60.351  1.00 82.63           N  
ATOM    608  NH2 ARG    88      43.008  38.207  60.651  1.00 78.13           N  
ATOM    609  N   GLY    89      43.758  43.735  53.488  1.00 70.69           N  
ATOM    610  CA  GLY    89      44.446  44.101  52.264  1.00 71.85           C  
ATOM    611  C   GLY    89      43.462  44.226  51.121  1.00 73.12           C  
ATOM    612  O   GLY    89      42.256  44.199  51.342  1.00 73.84           O  
ATOM    613  N   ASP    90      43.970  44.370  49.901  1.00 72.73           N  
ATOM    614  CA  ASP    90      43.117  44.490  48.723  1.00 72.06           C  
ATOM    615  C   ASP    90      42.302  43.219  48.534  1.00 70.71           C  
ATOM    616  O   ASP    90      42.810  42.110  48.713  1.00 71.10           O  
ATOM    617  CB  ASP    90      43.955  44.724  47.462  1.00 73.55           C  
ATOM    618  CG  ASP    90      44.353  46.179  47.277  1.00 74.11           C  
ATOM    619  OD1 ASP    90      44.944  46.770  48.208  1.00 73.77           O  
ATOM    620  OD2 ASP    90      44.085  46.727  46.188  1.00 75.54           O  
ATOM    621  N   LEU    91      41.039  43.384  48.161  1.00 68.33           N  
ATOM    622  CA  LEU    91      40.155  42.244  47.931  1.00 64.69           C  
ATOM    623  C   LEU    91      39.545  42.356  46.539  1.00 63.47           C  
ATOM    624  O   LEU    91      39.327  43.463  46.031  1.00 61.92           O  
ATOM    625  CB  LEU    91      39.041  42.216  48.972  1.00 63.68           C  
ATOM    626  CG  LEU    91      39.459  42.248  50.440  1.00 59.55           C  
ATOM    627  CD1 LEU    91      38.233  42.541  51.291  1.00 60.67           C  
ATOM    628  CD2 LEU    91      40.101  40.933  50.843  1.00 56.88           C  
ATOM    629  N   VAL    92      39.282  41.211  45.920  1.00 61.53           N  
ATOM    630  CA  VAL    92      38.691  41.204  44.593  1.00 60.01           C  
ATOM    631  C   VAL    92      37.337  40.527  44.720  1.00 57.88           C  
ATOM    632  O   VAL    92      37.203  39.510  45.393  1.00 55.94           O  
ATOM    633  CB  VAL    92      39.602  40.457  43.559  1.00 59.18           C  
ATOM    634  CG1 VAL    92      39.536  38.961  43.765  1.00 62.89           C  
ATOM    635  CG2 VAL    92      39.200  40.833  42.151  1.00 60.68           C  
ATOM    636  N   ILE    93      36.331  41.116  44.085  1.00 58.48           N  
ATOM    637  CA  ILE    93      34.974  40.592  44.144  1.00 57.13           C  
ATOM    638  C   ILE    93      34.493  40.141  42.774  1.00 55.90           C  
ATOM    639  O   ILE    93      34.531  40.904  41.809  1.00 56.68           O  
ATOM    640  CB  ILE    93      34.014  41.662  44.710  1.00 57.13           C  
ATOM    641  CG1 ILE    93      34.526  42.132  46.072  1.00 54.80           C  
ATOM    642  CG2 ILE    93      32.602  41.107  44.837  1.00 53.88           C  
ATOM    643  CD1 ILE    93      35.587  43.210  45.997  1.00 48.07           C  
ATOM    644  N   GLU    94      34.035  38.898  42.698  1.00 56.37           N  
ATOM    645  CA  GLU    94      33.559  38.346  41.436  1.00 56.42           C  
ATOM    646  C   GLU    94      32.210  37.645  41.589  1.00 55.31           C  
ATOM    647  O   GLU    94      32.034  36.791  42.451  1.00 54.64           O  
ATOM    648  CB  GLU    94      34.588  37.364  40.873  1.00 58.89           C  
ATOM    649  CG  GLU    94      35.954  37.969  40.620  1.00 62.05           C  
ATOM    650  CD  GLU    94      36.781  37.142  39.657  1.00 69.04           C  
ATOM    651  OE1 GLU    94      37.265  37.703  38.646  1.00 67.11           O  
ATOM    652  OE2 GLU    94      36.945  35.932  39.908  1.00 70.83           O  
ATOM    653  N   THR    95      31.272  38.000  40.720  1.00 55.95           N  
ATOM    654  CA  THR    95      29.928  37.445  40.761  1.00 55.64           C  
ATOM    655  C   THR    95      29.519  36.789  39.450  1.00 57.43           C  
ATOM    656  O   THR    95      30.160  36.987  38.421  1.00 59.47           O  
ATOM    657  CB  THR    95      28.905  38.544  41.078  1.00 55.35           C  
ATOM    658  OG1 THR    95      29.008  39.593  40.104  1.00 53.07           O  
ATOM    659  CG2 THR    95      29.155  39.118  42.467  1.00 51.92           C  
ATOM    660  N   ARG    96      28.447  36.006  39.500  1.00 58.84           N  
ATOM    661  CA  ARG    96      27.907  35.334  38.318  1.00 58.70           C  
ATOM    662  C   ARG    96      26.393  35.235  38.479  1.00 57.98           C  
ATOM    663  O   ARG    96      25.894  35.043  39.589  1.00 57.43           O  
ATOM    664  CB  ARG    96      28.516  33.928  38.154  1.00 60.02           C  
ATOM    665  CG  ARG    96      28.151  32.917  39.244  1.00 64.39           C  
ATOM    666  CD  ARG    96      29.294  31.922  39.471  1.00 73.23           C  
ATOM    667  NE  ARG    96      30.532  32.618  39.831  1.00 79.38           N  
ATOM    668  CZ  ARG    96      31.044  32.700  41.058  1.00 77.77           C  
ATOM    669  NH1 ARG    96      30.442  32.122  42.088  1.00 75.44           N  
ATOM    670  NH2 ARG    96      32.164  33.384  41.255  1.00 77.42           N  
ATOM    671  N   CYS    97      25.664  35.390  37.378  1.00 57.49           N  
ATOM    672  CA  CYS    97      24.211  35.306  37.416  1.00 55.67           C  
ATOM    673  C   CYS    97      23.878  33.840  37.260  1.00 55.73           C  
ATOM    674  O   CYS    97      24.382  33.193  36.350  1.00 58.61           O  
ATOM    675  CB  CYS    97      23.593  36.101  36.269  1.00 56.18           C  
ATOM    676  SG  CYS    97      21.779  36.147  36.286  1.00 57.01           S  
ATOM    677  N   LEU    98      23.040  33.313  38.146  1.00 54.26           N  
ATOM    678  CA  LEU    98      22.664  31.897  38.098  1.00 52.21           C  
ATOM    679  C   LEU    98      21.433  31.641  37.250  1.00 49.03           C  
ATOM    680  O   LEU    98      21.256  30.560  36.704  1.00 46.12           O  
ATOM    681  CB  LEU    98      22.395  31.381  39.504  1.00 54.15           C  
ATOM    682  CG  LEU    98      23.539  31.416  40.510  1.00 54.58           C  
ATOM    683  CD1 LEU    98      22.973  31.175  41.898  1.00 46.73           C  
ATOM    684  CD2 LEU    98      24.594  30.369  40.145  1.00 56.93           C  
ATOM    685  N   ARG    99      20.568  32.644  37.178  1.00 50.48           N  
ATOM    686  CA  ARG    99      19.344  32.557  36.404  1.00 52.49           C  
ATOM    687  C   ARG    99      18.757  33.938  36.190  1.00 52.82           C  
ATOM    688  O   ARG    99      18.828  34.807  37.056  1.00 53.75           O  
ATOM    689  CB  ARG    99      18.304  31.676  37.102  1.00 54.06           C  
ATOM    690  CG  ARG    99      16.945  31.789  36.431  1.00 57.29           C  
ATOM    691  CD  ARG    99      16.145  30.500  36.429  1.00 65.87           C  
ATOM    692  NE  ARG    99      15.023  30.617  35.497  1.00 70.54           N  
ATOM    693  CZ  ARG    99      14.103  31.574  35.559  1.00 67.79           C  
ATOM    694  NH1 ARG    99      14.164  32.496  36.511  1.00 71.10           N  
ATOM    695  NH2 ARG    99      13.132  31.624  34.661  1.00 70.62           N  
ATOM    696  N   ARG   100      18.160  34.132  35.030  1.00 56.24           N  
ATOM    697  CA  ARG   100      17.563  35.413  34.713  1.00 58.79           C  
ATOM    698  C   ARG   100      16.166  35.176  34.156  1.00 59.48           C  
ATOM    699  O   ARG   100      15.992  34.445  33.179  1.00 62.14           O  
ATOM    700  CB  ARG   100      18.432  36.142  33.687  1.00 59.79           C  
ATOM    701  CG  ARG   100      18.455  37.650  33.842  1.00 59.96           C  
ATOM    702  CD  ARG   100      19.412  38.262  32.846  1.00 63.35           C  
ATOM    703  NE  ARG   100      19.086  39.652  32.554  1.00 71.63           N  
ATOM    704  CZ  ARG   100      19.996  40.602  32.363  1.00 73.15           C  
ATOM    705  NH1 ARG   100      21.288  40.302  32.445  1.00 66.78           N  
ATOM    706  NH2 ARG   100      19.618  41.842  32.072  1.00 77.98           N  
ATOM    707  N   GLY   101      15.171  35.778  34.797  1.00 59.68           N  
ATOM    708  CA  GLY   101      13.807  35.625  34.342  1.00 60.36           C  
ATOM    709  C   GLY   101      13.387  36.942  33.748  1.00 59.99           C  
ATOM    710  O   GLY   101      14.216  37.825  33.555  1.00 59.70           O  
ATOM    711  N   ALA   102      12.107  37.086  33.444  1.00 61.31           N  
ATOM    712  CA  ALA   102      11.638  38.337  32.876  1.00 62.56           C  
ATOM    713  C   ALA   102      11.613  39.373  33.981  1.00 63.18           C  
ATOM    714  O   ALA   102      11.869  40.556  33.752  1.00 65.06           O  
ATOM    715  CB  ALA   102      10.259  38.155  32.296  1.00 62.57           C  
ATOM    716  N   SER   103      11.327  38.907  35.191  1.00 63.17           N  
ATOM    717  CA  SER   103      11.222  39.792  36.345  1.00 63.30           C  
ATOM    718  C   SER   103      12.206  39.558  37.492  1.00 60.88           C  
ATOM    719  O   SER   103      12.620  40.507  38.152  1.00 59.41           O  
ATOM    720  CB  SER   103       9.791  39.713  36.886  1.00 65.59           C  
ATOM    721  OG  SER   103       9.628  40.516  38.041  1.00 72.67           O  
ATOM    722  N   ILE   104      12.576  38.294  37.712  1.00 60.81           N  
ATOM    723  CA  ILE   104      13.469  37.891  38.813  1.00 58.72           C  
ATOM    724  C   ILE   104      14.853  37.356  38.406  1.00 59.10           C  
ATOM    725  O   ILE   104      14.965  36.490  37.540  1.00 56.77           O  
ATOM    726  CB  ILE   104      12.793  36.791  39.674  1.00 58.71           C  
ATOM    727  CG1 ILE   104      11.414  37.255  40.143  1.00 54.91           C  
ATOM    728  CG2 ILE   104      13.657  36.457  40.872  1.00 56.87           C  
ATOM    729  CD1 ILE   104      11.455  38.329  41.208  1.00 53.11           C  
ATOM    730  N   ALA   105      15.897  37.851  39.069  1.00 57.55           N  
ATOM    731  CA  ALA   105      17.265  37.408  38.791  1.00 55.87           C  
ATOM    732  C   ALA   105      17.959  36.863  40.039  1.00 53.73           C  
ATOM    733  O   ALA   105      17.839  37.433  41.119  1.00 52.30           O  
ATOM    734  CB  ALA   105      18.079  38.563  38.209  1.00 55.98           C  
ATOM    735  N   PHE   106      18.697  35.765  39.878  1.00 54.37           N  
ATOM    736  CA  PHE   106      19.435  35.138  40.984  1.00 54.66           C  
ATOM    737  C   PHE   106      20.934  35.283  40.757  1.00 56.10           C  
ATOM    738  O   PHE   106      21.431  35.012  39.668  1.00 58.87           O  
ATOM    739  CB  PHE   106      19.118  33.647  41.074  1.00 51.44           C  
ATOM    740  CG  PHE   106      17.710  33.342  41.483  1.00 50.85           C  
ATOM    741  CD1 PHE   106      17.320  33.428  42.822  1.00 44.53           C  
ATOM    742  CD2 PHE   106      16.763  32.968  40.527  1.00 46.72           C  
ATOM    743  CE1 PHE   106      16.002  33.144  43.214  1.00 39.63           C  
ATOM    744  CE2 PHE   106      15.439  32.684  40.904  1.00 47.44           C  
ATOM    745  CZ  PHE   106      15.059  32.773  42.253  1.00 49.21           C  
ATOM    746  N   CYS   107      21.658  35.694  41.788  1.00 59.42           N  
ATOM    747  CA  CYS   107      23.103  35.859  41.666  1.00 60.48           C  
ATOM    748  C   CYS   107      23.868  35.361  42.879  1.00 58.89           C  
ATOM    749  O   CYS   107      23.320  35.228  43.968  1.00 58.15           O  
ATOM    750  CB  CYS   107      23.451  37.333  41.430  1.00 59.77           C  
ATOM    751  SG  CYS   107      22.814  38.008  39.875  1.00 68.43           S  
ATOM    752  N   GLU   108      25.142  35.060  42.670  1.00 58.74           N  
ATOM    753  CA  GLU   108      26.014  34.615  43.746  1.00 57.79           C  
ATOM    754  C   GLU   108      27.394  35.209  43.505  1.00 56.15           C  
ATOM    755  O   GLU   108      27.675  35.741  42.435  1.00 56.27           O  
ATOM    756  CB  GLU   108      26.088  33.090  43.809  1.00 56.81           C  
ATOM    757  CG  GLU   108      26.431  32.413  42.505  1.00 59.58           C  
ATOM    758  CD  GLU   108      27.160  31.110  42.723  1.00 56.82           C  
ATOM    759  OE1 GLU   108      26.776  30.354  43.640  1.00 62.65           O  
ATOM    760  OE2 GLU   108      28.122  30.847  41.975  1.00 63.95           O  
ATOM    761  N   GLY   109      28.252  35.143  44.510  1.00 55.69           N  
ATOM    762  CA  GLY   109      29.573  35.711  44.349  1.00 56.85           C  
ATOM    763  C   GLY   109      30.464  35.456  45.541  1.00 56.87           C  
ATOM    764  O   GLY   109      30.046  34.847  46.526  1.00 54.75           O  
ATOM    765  N   GLU   110      31.693  35.955  45.459  1.00 57.17           N  
ATOM    766  CA  GLU   110      32.664  35.744  46.520  1.00 58.54           C  
ATOM    767  C   GLU   110      33.738  36.825  46.563  1.00 56.41           C  
ATOM    768  O   GLU   110      34.023  37.483  45.560  1.00 57.20           O  
ATOM    769  CB  GLU   110      33.321  34.376  46.325  1.00 58.69           C  
ATOM    770  CG  GLU   110      33.367  33.958  44.854  1.00 67.99           C  
ATOM    771  CD  GLU   110      34.447  32.940  44.547  1.00 76.41           C  
ATOM    772  OE1 GLU   110      34.343  31.793  45.033  1.00 83.23           O  
ATOM    773  OE2 GLU   110      35.399  33.295  43.814  1.00 76.64           O  
ATOM    774  N   ILE   111      34.327  36.997  47.741  1.00 55.20           N  
ATOM    775  CA  ILE   111      35.387  37.964  47.944  1.00 53.99           C  
ATOM    776  C   ILE   111      36.631  37.171  48.334  1.00 53.91           C  
ATOM    777  O   ILE   111      36.563  36.255  49.158  1.00 52.14           O  
ATOM    778  CB  ILE   111      35.039  38.952  49.079  1.00 55.99           C  
ATOM    779  CG1 ILE   111      33.687  39.618  48.794  1.00 50.38           C  
ATOM    780  CG2 ILE   111      36.146  40.007  49.213  1.00 52.86           C  
ATOM    781  CD1 ILE   111      33.182  40.488  49.915  1.00 44.32           C  
ATOM    782  N   ARG   112      37.767  37.512  47.740  1.00 54.95           N  
ATOM    783  CA  ARG   112      39.004  36.802  48.049  1.00 57.36           C  
ATOM    784  C   ARG   112      40.111  37.804  48.309  1.00 58.33           C  
ATOM    785  O   ARG   112      40.093  38.914  47.770  1.00 58.61           O  
ATOM    786  CB  ARG   112      39.401  35.876  46.890  1.00 55.02           C  
ATOM    787  CG  ARG   112      38.240  35.058  46.326  1.00 58.53           C  
ATOM    788  CD  ARG   112      38.714  33.889  45.468  1.00 59.84           C  
ATOM    789  NE  ARG   112      38.967  32.697  46.276  1.00 55.17           N  
ATOM    790  CZ  ARG   112      38.262  31.576  46.185  1.00 56.50           C  
ATOM    791  NH1 ARG   112      37.268  31.499  45.312  1.00 57.16           N  
ATOM    792  NH2 ARG   112      38.530  30.546  46.983  1.00 53.22           N  
ATOM    793  N   ASP   113      41.065  37.418  49.149  1.00 59.75           N  
ATOM    794  CA  ASP   113      42.187  38.293  49.460  1.00 61.42           C  
ATOM    795  C   ASP   113      43.326  38.045  48.482  1.00 61.61           C  
ATOM    796  O   ASP   113      43.249  37.151  47.643  1.00 61.62           O  
ATOM    797  CB  ASP   113      42.678  38.072  50.899  1.00 63.46           C  
ATOM    798  CG  ASP   113      42.922  36.614  51.225  1.00 62.82           C  
ATOM    799  OD1 ASP   113      43.513  35.895  50.390  1.00 71.52           O  
ATOM    800  OD2 ASP   113      42.531  36.189  52.327  1.00 61.21           O  
ATOM    801  N   SER   114      44.375  38.852  48.590  1.00 63.28           N  
ATOM    802  CA  SER   114      45.539  38.730  47.722  1.00 64.00           C  
ATOM    803  C   SER   114      46.053  37.295  47.693  1.00 65.13           C  
ATOM    804  O   SER   114      46.604  36.850  46.693  1.00 66.04           O  
ATOM    805  CB  SER   114      46.643  39.679  48.204  1.00 65.13           C  
ATOM    806  OG  SER   114      46.817  39.600  49.612  1.00 60.56           O  
ATOM    807  N   ALA   115      45.849  36.572  48.792  1.00 66.03           N  
ATOM    808  CA  ALA   115      46.287  35.183  48.918  1.00 65.08           C  
ATOM    809  C   ALA   115      45.301  34.190  48.297  1.00 65.99           C  
ATOM    810  O   ALA   115      45.504  32.977  48.367  1.00 66.38           O  
ATOM    811  CB  ALA   115      46.511  34.846  50.396  1.00 65.09           C  
ATOM    812  N   GLY   116      44.227  34.714  47.707  1.00 66.72           N  
ATOM    813  CA  GLY   116      43.228  33.874  47.061  1.00 64.83           C  
ATOM    814  C   GLY   116      42.303  33.078  47.968  1.00 64.48           C  
ATOM    815  O   GLY   116      41.588  32.188  47.501  1.00 63.85           O  
ATOM    816  N   GLU   117      42.304  33.389  49.259  1.00 63.88           N  
ATOM    817  CA  GLU   117      41.458  32.672  50.204  1.00 64.34           C  
ATOM    818  C   GLU   117      40.067  33.306  50.290  1.00 62.51           C  
ATOM    819  O   GLU   117      39.922  34.529  50.216  1.00 62.86           O  
ATOM    820  CB  GLU   117      42.115  32.656  51.587  1.00 65.37           C  
ATOM    821  CG  GLU   117      42.256  31.277  52.213  1.00 66.65           C  
ATOM    822  CD  GLU   117      43.127  30.333  51.389  1.00 73.09           C  
ATOM    823  OE1 GLU   117      44.185  30.772  50.883  1.00 72.72           O  
ATOM    824  OE2 GLU   117      42.761  29.144  51.258  1.00 73.02           O  
ATOM    825  N   LEU   118      39.053  32.461  50.444  1.00 59.68           N  
ATOM    826  CA  LEU   118      37.671  32.909  50.529  1.00 59.25           C  
ATOM    827  C   LEU   118      37.402  33.732  51.794  1.00 58.30           C  
ATOM    828  O   LEU   118      37.537  33.241  52.920  1.00 54.60           O  
ATOM    829  CB  LEU   118      36.729  31.695  50.472  1.00 60.95           C  
ATOM    830  CG  LEU   118      35.239  31.901  50.169  1.00 59.70           C  
ATOM    831  CD1 LEU   118      35.060  32.717  48.881  1.00 53.79           C  
ATOM    832  CD2 LEU   118      34.574  30.539  50.026  1.00 56.32           C  
ATOM    833  N   VAL   119      37.034  34.994  51.588  1.00 57.09           N  
ATOM    834  CA  VAL   119      36.725  35.905  52.679  1.00 56.54           C  
ATOM    835  C   VAL   119      35.238  35.783  53.006  1.00 54.43           C  
ATOM    836  O   VAL   119      34.868  35.530  54.149  1.00 55.22           O  
ATOM    837  CB  VAL   119      37.065  37.375  52.296  1.00 56.87           C  
ATOM    838  CG1 VAL   119      36.539  38.330  53.353  1.00 56.66           C  
ATOM    839  CG2 VAL   119      38.580  37.534  52.157  1.00 57.01           C  
ATOM    840  N   ALA   120      34.393  35.949  51.996  1.00 53.42           N  
ATOM    841  CA  ALA   120      32.947  35.838  52.174  1.00 54.17           C  
ATOM    842  C   ALA   120      32.283  35.429  50.873  1.00 52.69           C  
ATOM    843  O   ALA   120      32.813  35.685  49.804  1.00 54.05           O  
ATOM    844  CB  ALA   120      32.370  37.164  52.656  1.00 51.04           C  
ATOM    845  N   LYS   121      31.128  34.785  50.974  1.00 53.82           N  
ATOM    846  CA  LYS   121      30.365  34.361  49.807  1.00 53.64           C  
ATOM    847  C   LYS   121      28.933  34.842  50.040  1.00 53.35           C  
ATOM    848  O   LYS   121      28.452  34.835  51.174  1.00 51.67           O  
ATOM    849  CB  LYS   121      30.399  32.838  49.663  1.00 53.76           C  
ATOM    850  CG  LYS   121      30.210  32.357  48.236  1.00 60.50           C  
ATOM    851  CD  LYS   121      30.881  31.005  48.023  1.00 69.99           C  
ATOM    852  CE  LYS   121      30.995  30.643  46.543  1.00 72.37           C  
ATOM    853  NZ  LYS   121      29.668  30.515  45.889  1.00 75.53           N  
ATOM    854  N   ALA   122      28.257  35.258  48.969  1.00 52.17           N  
ATOM    855  CA  ALA   122      26.894  35.764  49.095  1.00 50.01           C  
ATOM    856  C   ALA   122      25.981  35.395  47.937  1.00 47.99           C  
ATOM    857  O   ALA   122      26.429  35.170  46.821  1.00 47.40           O  
ATOM    858  CB  ALA   122      26.921  37.286  49.260  1.00 47.87           C  
ATOM    859  N   THR   123      24.690  35.305  48.219  1.00 48.48           N  
ATOM    860  CA  THR   123      23.720  35.027  47.175  1.00 50.18           C  
ATOM    861  C   THR   123      22.708  36.170  47.283  1.00 50.64           C  
ATOM    862  O   THR   123      22.557  36.775  48.351  1.00 49.94           O  
ATOM    863  CB  THR   123      23.031  33.656  47.369  1.00 48.58           C  
ATOM    864  OG1 THR   123      22.423  33.601  48.666  1.00 52.63           O  
ATOM    865  CG2 THR   123      24.043  32.516  47.217  1.00 48.88           C  
ATOM    866  N   ALA   124      22.047  36.491  46.176  1.00 50.30           N  
ATOM    867  CA  ALA   124      21.073  37.577  46.166  1.00 49.15           C  
ATOM    868  C   ALA   124      19.970  37.360  45.144  1.00 50.23           C  
ATOM    869  O   ALA   124      20.143  36.646  44.150  1.00 48.07           O  
ATOM    870  CB  ALA   124      21.767  38.900  45.896  1.00 49.07           C  
ATOM    871  N   THR   125      18.823  37.969  45.410  1.00 49.61           N  
ATOM    872  CA  THR   125      17.695  37.868  44.509  1.00 49.31           C  
ATOM    873  C   THR   125      17.456  39.292  44.042  1.00 47.89           C  
ATOM    874  O   THR   125      17.596  40.240  44.816  1.00 47.69           O  
ATOM    875  CB  THR   125      16.435  37.301  45.215  1.00 48.47           C  
ATOM    876  OG1 THR   125      16.746  36.048  45.841  1.00 46.66           O  
ATOM    877  CG2 THR   125      15.350  37.055  44.207  1.00 49.82           C  
ATOM    878  N   PHE   126      17.099  39.452  42.777  1.00 47.83           N  
ATOM    879  CA  PHE   126      16.909  40.798  42.258  1.00 49.42           C  
ATOM    880  C   PHE   126      15.630  41.041  41.484  1.00 49.91           C  
ATOM    881  O   PHE   126      15.075  40.134  40.859  1.00 48.27           O  
ATOM    882  CB  PHE   126      18.075  41.197  41.342  1.00 47.90           C  
ATOM    883  CG  PHE   126      19.377  41.440  42.062  1.00 46.56           C  
ATOM    884  CD1 PHE   126      20.242  40.387  42.367  1.00 46.64           C  
ATOM    885  CD2 PHE   126      19.758  42.734  42.399  1.00 40.34           C  
ATOM    886  CE1 PHE   126      21.478  40.634  42.997  1.00 45.60           C  
ATOM    887  CE2 PHE   126      20.988  42.991  43.028  1.00 42.33           C  
ATOM    888  CZ  PHE   126      21.849  41.935  43.324  1.00 39.69           C  
ATOM    889  N   LYS   127      15.173  42.290  41.522  1.00 53.22           N  
ATOM    890  CA  LYS   127      14.003  42.701  40.755  1.00 57.90           C  
ATOM    891  C   LYS   127      14.625  43.362  39.520  1.00 59.78           C  
ATOM    892  O   LYS   127      15.464  44.259  39.659  1.00 58.23           O  
ATOM    893  CB  LYS   127      13.184  43.727  41.536  1.00 56.86           C  
ATOM    894  N   ILE   128      14.283  42.901  38.321  1.00 63.95           N  
ATOM    895  CA  ILE   128      14.820  43.588  37.157  1.00 68.16           C  
ATOM    896  C   ILE   128      13.707  44.524  36.743  1.00 71.94           C  
ATOM    897  O   ILE   128      12.611  44.095  36.375  1.00 71.60           O  
ATOM    898  CB  ILE   128      15.243  42.644  35.982  1.00 67.37           C  
ATOM    899  CG1 ILE   128      14.467  41.327  36.011  1.00 63.20           C  
ATOM    900  CG2 ILE   128      16.746  42.394  36.053  1.00 68.21           C  
ATOM    901  CD1 ILE   128      15.170  40.208  35.236  1.00 60.33           C  
ATOM    902  N   ILE   129      14.000  45.816  36.858  1.00 75.65           N  
ATOM    903  CA  ILE   129      13.054  46.886  36.560  1.00 79.11           C  
ATOM    904  C   ILE   129      12.728  47.158  35.092  1.00 82.21           C  
ATOM    905  O   ILE   129      13.085  48.203  34.556  1.00 82.94           O  
ATOM    906  CB  ILE   129      13.512  48.223  37.209  1.00 79.07           C  
ATOM    907  CG1 ILE   129      13.778  48.023  38.711  1.00 78.47           C  
ATOM    908  CG2 ILE   129      12.450  49.294  37.007  1.00 79.06           C  
ATOM    909  CD1 ILE   129      12.657  47.332  39.458  1.00 77.73           C  
ATOM    910  N   GLN   130      12.055  46.203  34.453  1.00 85.92           N  
ATOM    911  CA  GLN   130      11.596  46.349  33.074  1.00 88.00           C  
ATOM    912  C   GLN   130      10.817  45.148  32.564  1.00 88.85           C  
ATOM    913  O   GLN   130       9.657  45.373  32.160  1.00 89.20           O  
ATOM    914  CB  GLN   130      12.742  46.702  32.114  1.00 87.61           C  
ATOM    915  CG  GLN   130      12.373  47.924  31.257  1.00 87.70           C  
ATOM    916  CD  GLN   130      11.656  49.016  32.066  1.00 85.68           C  
ATOM    917  OE1 GLN   130      10.611  48.772  32.678  1.00 80.72           O  
ATOM    918  NE2 GLN   130      12.217  50.224  32.065  1.00 84.66           N  
END
