
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  131 (  982),  selected  131 , name 1psu_A
# Molecule2: number of CA atoms  125 (  918),  selected  125 , name T0479.pdb
# PARAMETERS: 1psu_A.T0479.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_A      T       6           -
LGA    S     2_A      D       7           -
LGA    H     3_A      F       8           -
LGA    K     4_A      -       -           -
LGA    A     5_A      -       -           -
LGA    W     6_A      -       -           -
LGA    Q     7_A      -       -           -
LGA    N     8_A      -       -           -
LGA    A     9_A      -       -           -
LGA    H    10_A      -       -           -
LGA    A    11_A      F       9           #
LGA    X    12_A      G      10          2.279
LGA    Y    13_A      L      11          1.489
LGA    E    14_A      T      12          3.016
LGA    N    15_A      -       -           -
LGA    D    16_A      I      13          5.072
LGA    A    17_A      P      14          4.364
LGA    C    18_A      F      15          4.021
LGA    A    19_A      M      16          3.347
LGA    K    20_A      Q      17          2.271
LGA    A    21_A      L      18          2.042
LGA    L    22_A      L      19          1.636
LGA    G    23_A      G      20          1.104
LGA    I    24_A      V      21          1.237
LGA    D    25_A      V      22          1.164
LGA    I    26_A      P      23          1.983
LGA    I    27_A      E      24          2.133
LGA    S    28_A      H      25          2.622
LGA    X    29_A      S      26          2.530
LGA    D    30_A      G      27          1.836
LGA    E    31_A      N      28          1.893
LGA    G    32_A      G      29          1.596
LGA    F    33_A      T      30          1.426
LGA    A    34_A      A      31          1.032
LGA    V    35_A      R      32          0.529
LGA    V    36_A      T      33          0.608
LGA    T    37_A      R      34          0.353
LGA    X    38_A      L      35          0.763
LGA    T    39_A      P      36          1.568
LGA    V    40_A      A      37          2.667
LGA    T    41_A      R      38          1.431
LGA    A    42_A      A      39          1.529
LGA    Q    43_A      D      40          1.660
LGA    X    44_A      L      41          1.634
LGA    L    45_A      V      42          1.435
LGA    N    46_A      N      43          1.698
LGA    G    47_A      S      44          1.568
LGA    H    48_A      R      45          1.242
LGA    Q    49_A      G      46          1.178
LGA    S    50_A      D      47          1.135
LGA    C    51_A      I      48          1.384
LGA    H    52_A      H      49          1.411
LGA    G    53_A      G      50          1.582
LGA    G    54_A      G      51          1.124
LGA    Q    55_A      T      52          0.625
LGA    L    56_A      L      53          0.546
LGA    F    57_A      M      54          0.774
LGA    S    58_A      S      55          0.660
LGA    L    59_A      V      56          0.715
LGA    A    60_A      L      57          0.373
LGA    D    61_A      D      58          1.100
LGA    T    62_A      F      59          1.345
LGA    A    63_A      T      60          0.854
LGA    F    64_A      L      61          1.786
LGA    A    65_A      G      62          2.833
LGA    Y    66_A      A      63          2.060
LGA    A    67_A      A      64          1.878
LGA    C    68_A      I      65          2.481
LGA    N    69_A      R      66          2.142
LGA    S    70_A      G      67          0.377
LGA    Q    71_A      D      68          2.308
LGA    G    72_A      T      69          2.516
LGA    -       -      P      70           -
LGA    -       -      E      71           -
LGA    L    73_A      V      72          3.222
LGA    A    74_A      G      73          1.792
LGA    A    75_A      V      74          1.012
LGA    V    76_A      A      75          1.208
LGA    A    77_A      T      76          1.188
LGA    S    78_A      I      77          0.974
LGA    A    79_A      D      78          1.088
LGA    C    80_A      M      79          1.131
LGA    T    81_A      N      80          1.164
LGA    I    82_A      T      81          1.092
LGA    D    83_A      S      82          0.991
LGA    F    84_A      F      83          0.648
LGA    L    85_A      M      84          0.695
LGA    R    86_A      S      85          0.560
LGA    P    87_A      P      86          0.660
LGA    G    88_A      G      87          0.884
LGA    F    89_A      R      88          2.293
LGA    A    90_A      -       -           -
LGA    G    91_A      -       -           -
LGA    D    92_A      G      89          0.746
LGA    T    93_A      D      90          0.720
LGA    L    94_A      L      91          0.630
LGA    T    95_A      V      92          0.540
LGA    A    96_A      I      93          0.556
LGA    T    97_A      E      94          0.544
LGA    A    98_A      T      95          1.346
LGA    Q    99_A      R      96          0.903
LGA    V   100_A      C      97          0.455
LGA    R   101_A      L      98          0.407
LGA    H   102_A      R      99          0.644
LGA    Q   103_A      R     100          0.645
LGA    G   104_A      G     101          1.244
LGA    K   105_A      A     102          1.972
LGA    Q   106_A      S     103          1.061
LGA    T   107_A      I     104          0.639
LGA    G   108_A      A     105          1.150
LGA    V   109_A      F     106          0.489
LGA    Y   110_A      C     107          0.393
LGA    D   111_A      E     108          0.681
LGA    I   112_A      G     109          1.200
LGA    E   113_A      E     110          0.705
LGA    I   114_A      I     111          0.554
LGA    V   115_A      R     112          0.499
LGA    N   116_A      D     113          0.633
LGA    Q   117_A      S     114          0.634
LGA    Q   118_A      A     115          0.644
LGA    Q   119_A      G     116          0.898
LGA    K   120_A      E     117          0.830
LGA    T   121_A      L     118          0.744
LGA    V   122_A      V     119          0.437
LGA    A   123_A      A     120          0.419
LGA    L   124_A      K     121          0.342
LGA    F   125_A      A     122          0.422
LGA    R   126_A      T     123          0.496
LGA    G   127_A      A     124          0.518
LGA    K   128_A      T     125          0.756
LGA    S   129_A      F     126          0.740
LGA    H   130_A      K     127          1.221
LGA    R   131_A      I     128          2.162
LGA    -       -      I     129           -
LGA    -       -      Q     130           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  131  125    5.0    117    1.57    18.80     87.168     7.005

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.695161 * X  +  -0.158874 * Y  +  -0.701078 * Z  +  91.216782
  Y_new =   0.365530 * X  +  -0.917898 * Y  +  -0.154437 * Z  + 106.086365
  Z_new =  -0.618982 * X  +  -0.363624 * Y  +   0.696160 * Z  +   1.612501 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.481350    2.660243  [ DEG:   -27.5793    152.4207 ]
  Theta =   0.667446    2.474146  [ DEG:    38.2419    141.7581 ]
  Phi   =   2.657502   -0.484091  [ DEG:   152.2636    -27.7364 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1psu_A                                        
REMARK     2: T0479.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1psu_A.T0479.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  131  125   5.0  117   1.57   18.80  87.168
REMARK  ---------------------------------------------------------- 
MOLECULE 1psu_A
HEADER    HYDROLASE                               21-JUN-03   1PSU              
TITLE     STRUCTURE OF THE E. COLI PAAI PROTEIN FROM THE                        
TITLE    2 PHYENYLACETIC ACID DEGRADATION OPERON                                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PHENYLACETIC ACID DEGRADATION PROTEIN PAAI;                
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: PAAI;                                                       
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: PAAI;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: B834 DE3;                                  
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET T7                                    
KEYWDS    STRUCTURAL GENOMICS, NYSGXRC, T820, PHENYLACETIC ACID,                
KEYWDS   2 DEGRADATION, OPERON, PSI, PROTEIN STRUCTURE INITIATIVE, NEW          
KEYWDS   3 YORK STRUCTURAL GENOMIX RESEARCH CONSORTIUM                          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    R.KNIEWEL,J.BUGLINO,V.SOLORZANO,J.WU,C.D.LIMA,S.K.BURLEY,             
AUTHOR   2 NEW YORK STRUCTURAL GENOMIX RESEARCH CONSORTIUM (NYSGXRC)            
REVDAT   2   25-JAN-05 1PSU    1       AUTHOR KEYWDS REMARK                     
REVDAT   1   08-JUL-03 1PSU    0                                                
JRNL        AUTH   R.KNIEWEL,J.BUGLINO,V.SOLORZANO,J.WU,C.D.LIMA                
JRNL        TITL   STRUCTURE OF THE E. COLI PAAI PROTEIN FROM THE               
JRNL        TITL 2 PHYENYLACETIC ACID DEGRADATION OPERON                        
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.20 ANGSTROMS.                                          
DBREF  1PSU A    1   140  UNP    P76084   PAAI_ECOLI       1    140             
DBREF  1PSU B    1   140  UNP    P76084   PAAI_ECOLI       1    140             
SEQRES   1 A  140  MSE SER HIS LYS ALA TRP GLN ASN ALA HIS ALA MSE TYR          
SEQRES   2 A  140  GLU ASN ASP ALA CYS ALA LYS ALA LEU GLY ILE ASP ILE          
SEQRES   3 A  140  ILE SER MSE ASP GLU GLY PHE ALA VAL VAL THR MSE THR          
SEQRES   4 A  140  VAL THR ALA GLN MSE LEU ASN GLY HIS GLN SER CYS HIS          
SEQRES   5 A  140  GLY GLY GLN LEU PHE SER LEU ALA ASP THR ALA PHE ALA          
SEQRES   6 A  140  TYR ALA CYS ASN SER GLN GLY LEU ALA ALA VAL ALA SER          
SEQRES   7 A  140  ALA CYS THR ILE ASP PHE LEU ARG PRO GLY PHE ALA GLY          
SEQRES   8 A  140  ASP THR LEU THR ALA THR ALA GLN VAL ARG HIS GLN GLY          
SEQRES   9 A  140  LYS GLN THR GLY VAL TYR ASP ILE GLU ILE VAL ASN GLN          
SEQRES  10 A  140  GLN GLN LYS THR VAL ALA LEU PHE ARG GLY LYS SER HIS          
SEQRES  11 A  140  ARG ILE GLY GLY THR ILE THR GLY GLU ALA                      
SEQRES   1 B  140  MSE SER HIS LYS ALA TRP GLN ASN ALA HIS ALA MSE TYR          
SEQRES   2 B  140  GLU ASN ASP ALA CYS ALA LYS ALA LEU GLY ILE ASP ILE          
SEQRES   3 B  140  ILE SER MSE ASP GLU GLY PHE ALA VAL VAL THR MSE THR          
SEQRES   4 B  140  VAL THR ALA GLN MSE LEU ASN GLY HIS GLN SER CYS HIS          
SEQRES   5 B  140  GLY GLY GLN LEU PHE SER LEU ALA ASP THR ALA PHE ALA          
SEQRES   6 B  140  TYR ALA CYS ASN SER GLN GLY LEU ALA ALA VAL ALA SER          
SEQRES   7 B  140  ALA CYS THR ILE ASP PHE LEU ARG PRO GLY PHE ALA GLY          
SEQRES   8 B  140  ASP THR LEU THR ALA THR ALA GLN VAL ARG HIS GLN GLY          
SEQRES   9 B  140  LYS GLN THR GLY VAL TYR ASP ILE GLU ILE VAL ASN GLN          
SEQRES  10 B  140  GLN GLN LYS THR VAL ALA LEU PHE ARG GLY LYS SER HIS          
SEQRES  11 B  140  ARG ILE GLY GLY THR ILE THR GLY GLU ALA                      
HET    MSE  A   1       8                                                       
HET    MSE  A  12       8                                                       
HET    MSE  A  29       8                                                       
HET    MSE  A  38       8                                                       
HET    MSE  A  44       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  12       8                                                       
HET    MSE  B  29       8                                                       
HET    MSE  B  38       8                                                       
HET    MSE  B  44       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    10(C5 H11 N O2 SE)                                           
FORMUL   3  HOH   *143(H2 O)                                                    
CRYST1   69.847   69.847  117.168  90.00  90.00 120.00 P 31 2 1     12          
HETATM    1  N   MSE A   1      12.752  52.825  23.588  1.00 50.89           N  
HETATM    2  CA  MSE A   1      14.114  52.524  23.058  1.00 50.52           C  
HETATM    3  C   MSE A   1      15.132  53.514  23.608  1.00 45.95           C  
HETATM    4  O   MSE A   1      16.046  53.139  24.340  1.00 41.79           O  
HETATM    5  CB  MSE A   1      14.114  52.589  21.532  1.00 58.19           C  
HETATM    6  CG  MSE A   1      13.395  53.817  20.977  1.00 69.38           C  
HETATM    7 SE   MSE A   1      14.021  54.427  19.227  1.00 86.55          SE  
HETATM    8  CE  MSE A   1      15.156  55.888  19.815  1.00 79.39           C  
ATOM      9  N   SER A   2      14.980  54.782  23.246  1.00 42.46           N  
ATOM     10  CA  SER A   2      15.891  55.805  23.731  1.00 40.95           C  
ATOM     11  C   SER A   2      15.690  55.994  25.227  1.00 39.22           C  
ATOM     12  O   SER A   2      16.617  56.378  25.946  1.00 37.24           O  
ATOM     13  CB  SER A   2      15.673  57.126  22.979  1.00 40.12           C  
ATOM     14  OG  SER A   2      14.324  57.542  23.024  1.00 42.07           O  
ATOM     15  N   HIS A   3      14.474  55.712  25.691  1.00 39.04           N  
ATOM     16  CA  HIS A   3      14.138  55.830  27.112  1.00 38.98           C  
ATOM     17  C   HIS A   3      14.874  54.722  27.856  1.00 37.17           C  
ATOM     18  O   HIS A   3      15.499  54.969  28.886  1.00 33.91           O  
ATOM     19  CB  HIS A   3      12.633  55.657  27.324  1.00 44.22           C  
ATOM     20  CG  HIS A   3      11.796  56.658  26.582  1.00 50.30           C  
ATOM     21  ND1 HIS A   3      11.933  56.889  25.229  1.00 52.55           N  
ATOM     22  CD2 HIS A   3      10.795  57.468  27.002  1.00 52.32           C  
ATOM     23  CE1 HIS A   3      11.051  57.800  24.846  1.00 54.12           C  
ATOM     24  NE2 HIS A   3      10.349  58.166  25.904  1.00 54.45           N  
ATOM     25  N   LYS A   4      14.792  53.503  27.324  1.00 35.08           N  
ATOM     26  CA  LYS A   4      15.455  52.354  27.929  1.00 36.23           C  
ATOM     27  C   LYS A   4      16.962  52.582  27.945  1.00 34.12           C  
ATOM     28  O   LYS A   4      17.623  52.305  28.940  1.00 33.56           O  
ATOM     29  CB  LYS A   4      15.127  51.073  27.153  1.00 38.76           C  
ATOM     30  CG  LYS A   4      13.659  50.674  27.192  1.00 45.87           C  
ATOM     31  CD  LYS A   4      13.396  49.415  26.361  1.00 50.56           C  
ATOM     32  CE  LYS A   4      11.914  49.043  26.350  1.00 52.62           C  
ATOM     33  NZ  LYS A   4      11.663  47.746  25.654  1.00 54.51           N  
ATOM     34  N   ALA A   5      17.496  53.083  26.834  1.00 33.09           N  
ATOM     35  CA  ALA A   5      18.921  53.365  26.733  1.00 32.32           C  
ATOM     36  C   ALA A   5      19.294  54.431  27.762  1.00 32.07           C  
ATOM     37  O   ALA A   5      20.351  54.355  28.397  1.00 29.46           O  
ATOM     38  CB  ALA A   5      19.267  53.850  25.326  1.00 33.28           C  
ATOM     39  N   TRP A   6      18.429  55.429  27.927  1.00 31.53           N  
ATOM     40  CA  TRP A   6      18.683  56.493  28.894  1.00 32.32           C  
ATOM     41  C   TRP A   6      18.709  55.930  30.313  1.00 31.68           C  
ATOM     42  O   TRP A   6      19.486  56.373  31.156  1.00 30.51           O  
ATOM     43  CB  TRP A   6      17.602  57.576  28.811  1.00 33.19           C  
ATOM     44  CG  TRP A   6      17.819  58.667  29.833  1.00 37.17           C  
ATOM     45  CD1 TRP A   6      18.619  59.773  29.704  1.00 38.49           C  
ATOM     46  CD2 TRP A   6      17.322  58.689  31.179  1.00 37.81           C  
ATOM     47  NE1 TRP A   6      18.648  60.479  30.888  1.00 39.97           N  
ATOM     48  CE2 TRP A   6      17.859  59.839  31.806  1.00 38.89           C  
ATOM     49  CE3 TRP A   6      16.464  57.855  31.911  1.00 38.07           C  
ATOM     50  CZ2 TRP A   6      17.585  60.164  33.141  1.00 39.41           C  
ATOM     51  CZ3 TRP A   6      16.189  58.179  33.239  1.00 40.15           C  
ATOM     52  CH2 TRP A   6      16.746  59.330  33.837  1.00 40.00           C  
ATOM     53  N   GLN A   7      17.836  54.961  30.568  1.00 32.34           N  
ATOM     54  CA  GLN A   7      17.744  54.331  31.874  1.00 33.14           C  
ATOM     55  C   GLN A   7      18.970  53.487  32.196  1.00 32.01           C  
ATOM     56  O   GLN A   7      19.400  53.434  33.350  1.00 30.03           O  
ATOM     57  CB  GLN A   7      16.491  53.467  31.956  1.00 35.22           C  
ATOM     58  CG  GLN A   7      15.213  54.268  31.889  1.00 38.88           C  
ATOM     59  CD  GLN A   7      13.976  53.404  32.034  1.00 43.42           C  
ATOM     60  OE1 GLN A   7      13.714  52.523  31.209  1.00 45.08           O  
ATOM     61  NE2 GLN A   7      13.205  53.651  33.088  1.00 45.64           N  
ATOM     62  N   ASN A   8      19.520  52.818  31.184  1.00 31.74           N  
ATOM     63  CA  ASN A   8      20.712  52.004  31.379  1.00 32.17           C  
ATOM     64  C   ASN A   8      21.863  52.934  31.730  1.00 31.79           C  
ATOM     65  O   ASN A   8      22.604  52.692  32.681  1.00 30.25           O  
ATOM     66  CB  ASN A   8      21.061  51.228  30.105  1.00 33.01           C  
ATOM     67  CG  ASN A   8      20.067  50.129  29.789  1.00 33.37           C  
ATOM     68  OD1 ASN A   8      19.373  49.625  30.668  1.00 34.80           O  
ATOM     69  ND2 ASN A   8      20.002  49.746  28.517  1.00 34.11           N  
ATOM     70  N   ALA A   9      21.997  54.012  30.964  1.00 31.34           N  
ATOM     71  CA  ALA A   9      23.051  54.979  31.206  1.00 30.15           C  
ATOM     72  C   ALA A   9      22.921  55.542  32.619  1.00 30.04           C  
ATOM     73  O   ALA A   9      23.918  55.680  33.327  1.00 30.26           O  
ATOM     74  CB  ALA A   9      22.975  56.100  30.177  1.00 30.73           C  
ATOM     75  N   HIS A  10      21.695  55.850  33.036  1.00 30.74           N  
ATOM     76  CA  HIS A  10      21.466  56.400  34.372  1.00 32.76           C  
ATOM     77  C   HIS A  10      21.806  55.380  35.462  1.00 32.11           C  
ATOM     78  O   HIS A  10      22.381  55.725  36.491  1.00 30.63           O  
ATOM     79  CB  HIS A  10      20.011  56.857  34.524  1.00 33.68           C  
ATOM     80  CG  HIS A  10      19.731  57.564  35.815  1.00 37.76           C  
ATOM     81  ND1 HIS A  10      20.457  58.661  36.236  1.00 40.31           N  
ATOM     82  CD2 HIS A  10      18.798  57.342  36.771  1.00 38.83           C  
ATOM     83  CE1 HIS A  10      19.979  59.083  37.394  1.00 40.45           C  
ATOM     84  NE2 HIS A  10      18.973  58.300  37.740  1.00 41.61           N  
ATOM     85  N   ALA A  11      21.447  54.120  35.233  1.00 32.95           N  
ATOM     86  CA  ALA A  11      21.742  53.064  36.198  1.00 33.63           C  
ATOM     87  C   ALA A  11      23.265  52.924  36.348  1.00 33.61           C  
ATOM     88  O   ALA A  11      23.779  52.788  37.457  1.00 33.03           O  
ATOM     89  CB  ALA A  11      21.124  51.742  35.728  1.00 33.07           C  
HETATM   90  N   MSE A  12      23.975  52.957  35.223  1.00 35.39           N  
HETATM   91  CA  MSE A  12      25.430  52.858  35.214  1.00 38.62           C  
HETATM   92  C   MSE A  12      26.012  54.025  36.015  1.00 38.02           C  
HETATM   93  O   MSE A  12      26.863  53.843  36.889  1.00 34.63           O  
HETATM   94  CB  MSE A  12      25.952  52.915  33.777  1.00 43.87           C  
HETATM   95  CG  MSE A  12      25.773  51.634  32.967  1.00 52.12           C  
HETATM   96 SE   MSE A  12      26.939  50.199  33.590  1.00 68.09          SE  
HETATM   97  CE  MSE A  12      28.655  51.003  33.202  1.00 61.43           C  
ATOM     98  N   TYR A  13      25.550  55.229  35.701  1.00 37.06           N  
ATOM     99  CA  TYR A  13      26.000  56.427  36.391  1.00 38.32           C  
ATOM    100  C   TYR A  13      25.915  56.304  37.917  1.00 37.54           C  
ATOM    101  O   TYR A  13      26.906  56.504  38.618  1.00 36.79           O  
ATOM    102  CB  TYR A  13      25.170  57.622  35.925  1.00 42.28           C  
ATOM    103  CG  TYR A  13      25.289  58.836  36.814  1.00 46.25           C  
ATOM    104  CD1 TYR A  13      26.487  59.550  36.900  1.00 48.59           C  
ATOM    105  CD2 TYR A  13      24.206  59.268  37.578  1.00 49.59           C  
ATOM    106  CE1 TYR A  13      26.603  60.665  37.725  1.00 50.84           C  
ATOM    107  CE2 TYR A  13      24.310  60.380  38.410  1.00 52.44           C  
ATOM    108  CZ  TYR A  13      25.509  61.073  38.479  1.00 52.66           C  
ATOM    109  OH  TYR A  13      25.602  62.172  39.305  1.00 55.46           O  
ATOM    110  N   GLU A  14      24.737  55.972  38.431  1.00 36.85           N  
ATOM    111  CA  GLU A  14      24.548  55.854  39.873  1.00 37.82           C  
ATOM    112  C   GLU A  14      25.417  54.768  40.481  1.00 36.74           C  
ATOM    113  O   GLU A  14      25.855  54.889  41.624  1.00 36.51           O  
ATOM    114  CB  GLU A  14      23.081  55.578  40.192  1.00 38.61           C  
ATOM    115  CG  GLU A  14      22.155  56.588  39.531  1.00 45.73           C  
ATOM    116  CD  GLU A  14      20.770  56.594  40.113  1.00 49.05           C  
ATOM    117  OE1 GLU A  14      20.120  55.520  40.141  1.00 51.56           O  
ATOM    118  OE2 GLU A  14      20.317  57.686  40.539  1.00 51.37           O  
ATOM    119  N   ASN A  15      25.667  53.715  39.708  1.00 36.11           N  
ATOM    120  CA  ASN A  15      26.484  52.597  40.154  1.00 34.65           C  
ATOM    121  C   ASN A  15      27.949  53.039  40.217  1.00 32.79           C  
ATOM    122  O   ASN A  15      28.661  52.673  41.142  1.00 31.90           O  
ATOM    123  CB  ASN A  15      26.318  51.425  39.177  1.00 36.19           C  
ATOM    124  CG  ASN A  15      26.786  50.096  39.756  1.00 40.30           C  
ATOM    125  OD1 ASN A  15      27.396  50.044  40.826  1.00 41.72           O  
ATOM    126  ND2 ASN A  15      26.496  49.009  39.045  1.00 40.94           N  
ATOM    127  N   ASP A  16      28.389  53.826  39.238  1.00 31.19           N  
ATOM    128  CA  ASP A  16      29.764  54.312  39.209  1.00 32.57           C  
ATOM    129  C   ASP A  16      30.013  55.297  40.339  1.00 32.04           C  
ATOM    130  O   ASP A  16      31.131  55.413  40.845  1.00 32.70           O  
ATOM    131  CB  ASP A  16      30.101  54.997  37.879  1.00 34.64           C  
ATOM    132  CG  ASP A  16      30.105  54.042  36.708  1.00 39.38           C  
ATOM    133  OD1 ASP A  16      30.509  52.866  36.886  1.00 42.54           O  
ATOM    134  OD2 ASP A  16      29.726  54.471  35.590  1.00 39.75           O  
ATOM    135  N   ALA A  17      28.975  56.027  40.720  1.00 32.82           N  
ATOM    136  CA  ALA A  17      29.086  56.994  41.810  1.00 33.81           C  
ATOM    137  C   ALA A  17      29.272  56.261  43.142  1.00 35.68           C  
ATOM    138  O   ALA A  17      30.084  56.664  43.974  1.00 36.70           O  
ATOM    139  CB  ALA A  17      27.834  57.872  41.862  1.00 32.82           C  
ATOM    140  N   CYS A  18      28.524  55.183  43.355  1.00 35.79           N  
ATOM    141  CA  CYS A  18      28.675  54.439  44.599  1.00 37.76           C  
ATOM    142  C   CYS A  18      30.050  53.785  44.654  1.00 36.01           C  
ATOM    143  O   CYS A  18      30.677  53.727  45.709  1.00 34.17           O  
ATOM    144  CB  CYS A  18      27.594  53.362  44.731  1.00 40.16           C  
ATOM    145  SG  CYS A  18      25.926  54.000  45.033  1.00 45.99           S  
ATOM    146  N   ALA A  19      30.509  53.293  43.507  1.00 35.20           N  
ATOM    147  CA  ALA A  19      31.806  52.628  43.414  1.00 35.72           C  
ATOM    148  C   ALA A  19      32.921  53.600  43.790  1.00 36.72           C  
ATOM    149  O   ALA A  19      33.817  53.263  44.569  1.00 35.30           O  
ATOM    150  CB  ALA A  19      32.031  52.107  42.007  1.00 33.48           C  
ATOM    151  N   LYS A  20      32.858  54.802  43.220  1.00 37.30           N  
ATOM    152  CA  LYS A  20      33.844  55.833  43.494  1.00 39.15           C  
ATOM    153  C   LYS A  20      33.881  56.171  44.987  1.00 39.45           C  
ATOM    154  O   LYS A  20      34.954  56.297  45.571  1.00 39.46           O  
ATOM    155  CB  LYS A  20      33.514  57.101  42.704  1.00 40.06           C  
ATOM    156  CG  LYS A  20      34.498  58.238  42.943  1.00 42.88           C  
ATOM    157  CD  LYS A  20      33.997  59.547  42.363  1.00 45.51           C  
ATOM    158  CE  LYS A  20      34.993  60.662  42.626  1.00 47.92           C  
ATOM    159  NZ  LYS A  20      34.443  61.995  42.257  1.00 50.58           N  
ATOM    160  N   ALA A  21      32.706  56.324  45.593  1.00 39.36           N  
ATOM    161  CA  ALA A  21      32.611  56.661  47.005  1.00 40.78           C  
ATOM    162  C   ALA A  21      33.168  55.549  47.882  1.00 42.49           C  
ATOM    163  O   ALA A  21      33.596  55.793  49.014  1.00 43.90           O  
ATOM    164  CB  ALA A  21      31.169  56.933  47.373  1.00 40.26           C  
ATOM    165  N   LEU A  22      33.169  54.326  47.363  1.00 41.72           N  
ATOM    166  CA  LEU A  22      33.666  53.179  48.119  1.00 41.23           C  
ATOM    167  C   LEU A  22      35.091  52.788  47.714  1.00 41.16           C  
ATOM    168  O   LEU A  22      35.678  51.875  48.299  1.00 42.60           O  
ATOM    169  CB  LEU A  22      32.724  51.989  47.913  1.00 40.69           C  
ATOM    170  CG  LEU A  22      31.307  52.120  48.485  1.00 41.89           C  
ATOM    171  CD1 LEU A  22      30.412  51.026  47.926  1.00 41.87           C  
ATOM    172  CD2 LEU A  22      31.355  52.046  50.008  1.00 42.07           C  
ATOM    173  N   GLY A  23      35.642  53.485  46.722  1.00 40.02           N  
ATOM    174  CA  GLY A  23      36.982  53.177  46.246  1.00 38.36           C  
ATOM    175  C   GLY A  23      37.016  51.855  45.487  1.00 38.19           C  
ATOM    176  O   GLY A  23      37.983  51.104  45.572  1.00 37.54           O  
ATOM    177  N   ILE A  24      35.955  51.575  44.735  1.00 37.25           N  
ATOM    178  CA  ILE A  24      35.854  50.338  43.969  1.00 34.99           C  
ATOM    179  C   ILE A  24      36.222  50.511  42.495  1.00 35.16           C  
ATOM    180  O   ILE A  24      35.811  51.475  41.846  1.00 34.64           O  
ATOM    181  CB  ILE A  24      34.425  49.770  44.079  1.00 35.05           C  
ATOM    182  CG1 ILE A  24      34.127  49.453  45.540  1.00 34.10           C  
ATOM    183  CG2 ILE A  24      34.269  48.544  43.184  1.00 31.96           C  
ATOM    184  CD1 ILE A  24      32.678  49.103  45.837  1.00 34.53           C  
ATOM    185  N   ASP A  25      37.002  49.571  41.970  1.00 34.76           N  
ATOM    186  CA  ASP A  25      37.422  49.623  40.575  1.00 36.39           C  
ATOM    187  C   ASP A  25      37.021  48.366  39.790  1.00 35.86           C  
ATOM    188  O   ASP A  25      37.149  47.243  40.292  1.00 33.24           O  
ATOM    189  CB  ASP A  25      38.940  49.827  40.507  1.00 39.48           C  
ATOM    190  CG  ASP A  25      39.369  51.195  41.038  1.00 44.72           C  
ATOM    191  OD1 ASP A  25      39.079  52.213  40.371  1.00 47.55           O  
ATOM    192  OD2 ASP A  25      39.982  51.264  42.126  1.00 47.18           O  
ATOM    193  N   ILE A  26      36.520  48.564  38.569  1.00 34.88           N  
ATOM    194  CA  ILE A  26      36.132  47.448  37.700  1.00 33.28           C  
ATOM    195  C   ILE A  26      37.373  46.849  37.051  1.00 32.69           C  
ATOM    196  O   ILE A  26      38.148  47.546  36.407  1.00 33.10           O  
ATOM    197  CB  ILE A  26      35.193  47.909  36.582  1.00 35.14           C  
ATOM    198  CG1 ILE A  26      33.916  48.494  37.179  1.00 33.73           C  
ATOM    199  CG2 ILE A  26      34.843  46.725  35.659  1.00 35.89           C  
ATOM    200  CD1 ILE A  26      32.979  49.087  36.141  1.00 35.04           C  
ATOM    201  N   ILE A  27      37.559  45.550  37.229  1.00 32.86           N  
ATOM    202  CA  ILE A  27      38.722  44.855  36.680  1.00 34.44           C  
ATOM    203  C   ILE A  27      38.341  44.118  35.396  1.00 32.04           C  
ATOM    204  O   ILE A  27      39.124  44.033  34.454  1.00 31.97           O  
ATOM    205  CB  ILE A  27      39.251  43.787  37.662  1.00 37.28           C  
ATOM    206  CG1 ILE A  27      39.290  44.349  39.075  1.00 40.55           C  
ATOM    207  CG2 ILE A  27      40.633  43.337  37.238  1.00 39.96           C  
ATOM    208  CD1 ILE A  27      39.351  43.273  40.147  1.00 42.72           C  
ATOM    209  N   SER A  28      37.134  43.565  35.384  1.00 31.86           N  
ATOM    210  CA  SER A  28      36.639  42.808  34.246  1.00 31.91           C  
ATOM    211  C   SER A  28      35.123  42.806  34.284  1.00 31.49           C  
ATOM    212  O   SER A  28      34.521  42.764  35.358  1.00 29.84           O  
ATOM    213  CB  SER A  28      37.158  41.367  34.309  1.00 33.40           C  
ATOM    214  OG  SER A  28      36.713  40.617  33.182  1.00 34.72           O  
HETATM  215  N   MSE A  29      34.502  42.842  33.113  1.00 30.22           N  
HETATM  216  CA  MSE A  29      33.058  42.859  33.071  1.00 30.75           C  
HETATM  217  C   MSE A  29      32.545  42.476  31.701  1.00 29.59           C  
HETATM  218  O   MSE A  29      33.026  42.954  30.672  1.00 29.09           O  
HETATM  219  CB  MSE A  29      32.551  44.246  33.451  1.00 32.25           C  
HETATM  220  CG  MSE A  29      31.037  44.389  33.546  1.00 39.92           C  
HETATM  221 SE   MSE A  29      30.536  46.141  34.289  1.00 51.91          SE  
HETATM  222  CE  MSE A  29      31.602  46.095  35.893  1.00 49.21           C  
ATOM    223  N   ASP A  30      31.569  41.585  31.697  1.00 29.55           N  
ATOM    224  CA  ASP A  30      30.975  41.145  30.458  1.00 29.89           C  
ATOM    225  C   ASP A  30      29.556  40.734  30.737  1.00 27.06           C  
ATOM    226  O   ASP A  30      29.047  40.994  31.813  1.00 26.17           O  
ATOM    227  CB  ASP A  30      31.790  40.003  29.850  1.00 30.87           C  
ATOM    228  CG  ASP A  30      31.809  40.063  28.338  1.00 35.61           C  
ATOM    229  OD1 ASP A  30      31.092  39.257  27.705  1.00 39.73           O  
ATOM    230  OD2 ASP A  30      32.522  40.934  27.777  1.00 35.05           O  
ATOM    231  N   GLU A  31      28.920  40.098  29.766  1.00 28.39           N  
ATOM    232  CA  GLU A  31      27.529  39.682  29.900  1.00 28.37           C  
ATOM    233  C   GLU A  31      27.213  38.792  31.099  1.00 27.04           C  
ATOM    234  O   GLU A  31      27.619  37.636  31.147  1.00 27.23           O  
ATOM    235  CB  GLU A  31      27.070  38.981  28.611  1.00 29.25           C  
ATOM    236  CG  GLU A  31      25.658  38.438  28.688  1.00 30.52           C  
ATOM    237  CD  GLU A  31      25.121  37.985  27.340  1.00 34.15           C  
ATOM    238  OE1 GLU A  31      25.900  37.414  26.555  1.00 36.37           O  
ATOM    239  OE2 GLU A  31      23.923  38.199  27.070  1.00 35.29           O  
ATOM    240  N   GLY A  32      26.480  39.357  32.055  1.00 26.13           N  
ATOM    241  CA  GLY A  32      26.083  38.628  33.241  1.00 27.02           C  
ATOM    242  C   GLY A  32      27.096  38.551  34.367  1.00 24.45           C  
ATOM    243  O   GLY A  32      26.845  37.872  35.356  1.00 24.84           O  
ATOM    244  N   PHE A  33      28.227  39.234  34.244  1.00 25.82           N  
ATOM    245  CA  PHE A  33      29.225  39.182  35.304  1.00 25.09           C  
ATOM    246  C   PHE A  33      30.136  40.391  35.383  1.00 23.54           C  
ATOM    247  O   PHE A  33      30.392  41.072  34.389  1.00 21.33           O  
ATOM    248  CB  PHE A  33      30.075  37.909  35.170  1.00 28.08           C  
ATOM    249  CG  PHE A  33      31.163  37.982  34.126  1.00 28.78           C  
ATOM    250  CD1 PHE A  33      32.369  38.636  34.398  1.00 30.23           C  
ATOM    251  CD2 PHE A  33      31.006  37.339  32.896  1.00 30.61           C  
ATOM    252  CE1 PHE A  33      33.408  38.643  33.466  1.00 29.93           C  
ATOM    253  CE2 PHE A  33      32.040  37.336  31.947  1.00 30.65           C  
ATOM    254  CZ  PHE A  33      33.243  37.986  32.228  1.00 31.27           C  
ATOM    255  N   ALA A  34      30.618  40.656  36.591  1.00 22.89           N  
ATOM    256  CA  ALA A  34      31.522  41.776  36.818  1.00 23.37           C  
ATOM    257  C   ALA A  34      32.512  41.407  37.918  1.00 21.56           C  
ATOM    258  O   ALA A  34      32.164  40.735  38.884  1.00 23.15           O  
ATOM    259  CB  ALA A  34      30.716  43.034  37.222  1.00 21.07           C  
ATOM    260  N   VAL A  35      33.748  41.838  37.747  1.00 22.93           N  
ATOM    261  CA  VAL A  35      34.793  41.594  38.721  1.00 23.42           C  
ATOM    262  C   VAL A  35      35.283  42.983  39.114  1.00 22.23           C  
ATOM    263  O   VAL A  35      35.757  43.728  38.263  1.00 22.88           O  
ATOM    264  CB  VAL A  35      35.971  40.800  38.099  1.00 24.15           C  
ATOM    265  CG1 VAL A  35      37.007  40.513  39.160  1.00 26.23           C  
ATOM    266  CG2 VAL A  35      35.470  39.495  37.463  1.00 22.77           C  
ATOM    267  N   VAL A  36      35.121  43.344  40.382  1.00 24.47           N  
ATOM    268  CA  VAL A  36      35.560  44.642  40.879  1.00 26.57           C  
ATOM    269  C   VAL A  36      36.544  44.441  42.034  1.00 29.39           C  
ATOM    270  O   VAL A  36      36.590  43.368  42.648  1.00 28.46           O  
ATOM    271  CB  VAL A  36      34.367  45.488  41.372  1.00 26.64           C  
ATOM    272  CG1 VAL A  36      33.400  45.719  40.224  1.00 26.71           C  
ATOM    273  CG2 VAL A  36      33.653  44.780  42.524  1.00 28.08           C  
ATOM    274  N   THR A  37      37.320  45.475  42.337  1.00 29.52           N  
ATOM    275  CA  THR A  37      38.316  45.391  43.403  1.00 33.23           C  
ATOM    276  C   THR A  37      38.218  46.570  44.376  1.00 32.91           C  
ATOM    277  O   THR A  37      37.772  47.652  44.003  1.00 31.43           O  
ATOM    278  CB  THR A  37      39.729  45.364  42.793  1.00 35.07           C  
ATOM    279  OG1 THR A  37      40.678  44.978  43.789  1.00 41.93           O  
ATOM    280  CG2 THR A  37      40.096  46.735  42.265  1.00 35.68           C  
HETATM  281  N   MSE A  38      38.649  46.354  45.616  1.00 33.45           N  
HETATM  282  CA  MSE A  38      38.624  47.385  46.649  1.00 35.96           C  
HETATM  283  C   MSE A  38      39.704  47.084  47.687  1.00 34.79           C  
HETATM  284  O   MSE A  38      39.884  45.930  48.082  1.00 33.90           O  
HETATM  285  CB  MSE A  38      37.252  47.417  47.339  1.00 40.95           C  
HETATM  286  CG  MSE A  38      37.084  48.494  48.424  1.00 50.65           C  
HETATM  287 SE   MSE A  38      35.573  48.200  49.676  1.00 65.09          SE  
HETATM  288  CE  MSE A  38      34.193  49.260  48.859  1.00 61.30           C  
ATOM    289  N   THR A  39      40.434  48.112  48.114  1.00 32.56           N  
ATOM    290  CA  THR A  39      41.473  47.930  49.132  1.00 32.91           C  
ATOM    291  C   THR A  39      40.898  48.339  50.485  1.00 31.84           C  
ATOM    292  O   THR A  39      40.356  49.438  50.624  1.00 31.71           O  
ATOM    293  CB  THR A  39      42.728  48.785  48.834  1.00 32.56           C  
ATOM    294  OG1 THR A  39      43.264  48.407  47.561  1.00 33.41           O  
ATOM    295  CG2 THR A  39      43.805  48.554  49.900  1.00 33.46           C  
ATOM    296  N   VAL A  40      41.000  47.448  51.471  1.00 30.87           N  
ATOM    297  CA  VAL A  40      40.495  47.713  52.818  1.00 29.53           C  
ATOM    298  C   VAL A  40      41.399  48.751  53.478  1.00 31.76           C  
ATOM    299  O   VAL A  40      42.623  48.619  53.466  1.00 30.19           O  
ATOM    300  CB  VAL A  40      40.493  46.416  53.700  1.00 28.13           C  
ATOM    301  CG1 VAL A  40      39.873  46.697  55.066  1.00 25.04           C  
ATOM    302  CG2 VAL A  40      39.722  45.305  52.999  1.00 23.58           C  
ATOM    303  N   THR A  41      40.789  49.783  54.044  1.00 34.54           N  
ATOM    304  CA  THR A  41      41.535  50.837  54.706  1.00 39.24           C  
ATOM    305  C   THR A  41      41.248  50.809  56.202  1.00 39.54           C  
ATOM    306  O   THR A  41      40.251  50.228  56.632  1.00 40.16           O  
ATOM    307  CB  THR A  41      41.156  52.214  54.141  1.00 40.95           C  
ATOM    308  OG1 THR A  41      41.912  53.228  54.815  1.00 47.98           O  
ATOM    309  CG2 THR A  41      39.680  52.478  54.344  1.00 40.87           C  
ATOM    310  N   ALA A  42      42.115  51.434  56.995  1.00 41.81           N  
ATOM    311  CA  ALA A  42      41.944  51.452  58.449  1.00 43.46           C  
ATOM    312  C   ALA A  42      40.596  52.031  58.866  1.00 44.50           C  
ATOM    313  O   ALA A  42      40.036  51.647  59.891  1.00 44.14           O  
ATOM    314  CB  ALA A  42      43.076  52.249  59.093  1.00 43.66           C  
ATOM    315  N   GLN A  43      40.079  52.951  58.057  1.00 46.50           N  
ATOM    316  CA  GLN A  43      38.799  53.597  58.339  1.00 49.19           C  
ATOM    317  C   GLN A  43      37.621  52.616  58.366  1.00 50.28           C  
ATOM    318  O   GLN A  43      36.651  52.820  59.098  1.00 51.72           O  
ATOM    319  CB  GLN A  43      38.503  54.685  57.300  1.00 49.69           C  
ATOM    320  CG  GLN A  43      39.543  55.804  57.203  1.00 52.23           C  
ATOM    321  CD  GLN A  43      40.842  55.378  56.530  1.00 52.43           C  
ATOM    322  OE1 GLN A  43      41.632  54.616  57.088  1.00 53.39           O  
ATOM    323  NE2 GLN A  43      41.061  55.869  55.315  1.00 51.97           N  
HETATM  324  N   MSE A  44      37.694  51.553  57.574  1.00 50.03           N  
HETATM  325  CA  MSE A  44      36.597  50.599  57.548  1.00 51.24           C  
HETATM  326  C   MSE A  44      36.771  49.375  58.436  1.00 49.82           C  
HETATM  327  O   MSE A  44      36.114  48.351  58.230  1.00 49.65           O  
HETATM  328  CB  MSE A  44      36.310  50.183  56.098  1.00 54.63           C  
HETATM  329  CG  MSE A  44      37.548  50.035  55.225  1.00 59.22           C  
HETATM  330 SE   MSE A  44      37.168  49.730  53.322  1.00 65.44          SE  
HETATM  331  CE  MSE A  44      36.830  51.560  52.765  1.00 65.41           C  
ATOM    332  N   LEU A  45      37.643  49.476  59.436  1.00 48.43           N  
ATOM    333  CA  LEU A  45      37.868  48.349  60.342  1.00 48.19           C  
ATOM    334  C   LEU A  45      37.013  48.455  61.605  1.00 49.34           C  
ATOM    335  O   LEU A  45      36.821  49.541  62.156  1.00 48.50           O  
ATOM    336  CB  LEU A  45      39.344  48.259  60.744  1.00 45.79           C  
ATOM    337  CG  LEU A  45      40.376  48.010  59.643  1.00 44.57           C  
ATOM    338  CD1 LEU A  45      41.732  47.886  60.288  1.00 44.82           C  
ATOM    339  CD2 LEU A  45      40.046  46.749  58.855  1.00 45.10           C  
ATOM    340  N   ASN A  46      36.490  47.321  62.055  1.00 50.37           N  
ATOM    341  CA  ASN A  46      35.672  47.309  63.254  1.00 52.76           C  
ATOM    342  C   ASN A  46      36.575  47.157  64.467  1.00 53.31           C  
ATOM    343  O   ASN A  46      37.787  47.342  64.370  1.00 54.11           O  
ATOM    344  CB  ASN A  46      34.656  46.161  63.212  1.00 52.71           C  
ATOM    345  CG  ASN A  46      35.297  44.826  62.906  1.00 53.71           C  
ATOM    346  OD1 ASN A  46      36.329  44.471  63.480  1.00 53.74           O  
ATOM    347  ND2 ASN A  46      34.687  44.073  61.998  1.00 53.70           N  
ATOM    348  N   GLY A  47      35.979  46.813  65.605  1.00 54.47           N  
ATOM    349  CA  GLY A  47      36.746  46.643  66.827  1.00 55.02           C  
ATOM    350  C   GLY A  47      37.794  45.550  66.742  1.00 55.60           C  
ATOM    351  O   GLY A  47      38.830  45.612  67.406  1.00 56.11           O  
ATOM    352  N   HIS A  48      37.528  44.539  65.926  1.00 55.26           N  
ATOM    353  CA  HIS A  48      38.470  43.442  65.773  1.00 55.10           C  
ATOM    354  C   HIS A  48      39.482  43.711  64.664  1.00 54.82           C  
ATOM    355  O   HIS A  48      40.123  42.789  64.159  1.00 55.45           O  
ATOM    356  CB  HIS A  48      37.718  42.141  65.494  1.00 55.95           C  
ATOM    357  CG  HIS A  48      36.877  41.677  66.641  1.00 57.01           C  
ATOM    358  ND1 HIS A  48      37.409  41.379  67.877  1.00 57.78           N  
ATOM    359  CD2 HIS A  48      35.541  41.480  66.748  1.00 57.40           C  
ATOM    360  CE1 HIS A  48      36.435  41.021  68.698  1.00 58.03           C  
ATOM    361  NE2 HIS A  48      35.294  41.074  68.037  1.00 57.37           N  
ATOM    362  N   GLN A  49      39.615  44.978  64.284  1.00 53.43           N  
ATOM    363  CA  GLN A  49      40.561  45.368  63.254  1.00 52.69           C  
ATOM    364  C   GLN A  49      40.326  44.660  61.917  1.00 51.20           C  
ATOM    365  O   GLN A  49      41.271  44.397  61.167  1.00 51.07           O  
ATOM    366  CB  GLN A  49      41.981  45.094  63.745  1.00 54.29           C  
ATOM    367  CG  GLN A  49      42.327  45.824  65.036  1.00 57.08           C  
ATOM    368  CD  GLN A  49      43.048  44.933  66.037  1.00 59.55           C  
ATOM    369  OE1 GLN A  49      44.173  44.487  65.798  1.00 60.04           O  
ATOM    370  NE2 GLN A  49      42.397  44.667  67.167  1.00 60.64           N  
ATOM    371  N   SER A  50      39.072  44.336  61.617  1.00 49.43           N  
ATOM    372  CA  SER A  50      38.758  43.685  60.349  1.00 46.59           C  
ATOM    373  C   SER A  50      37.657  44.472  59.659  1.00 44.37           C  
ATOM    374  O   SER A  50      36.910  45.211  60.298  1.00 43.86           O  
ATOM    375  CB  SER A  50      38.296  42.246  60.565  1.00 46.54           C  
ATOM    376  OG  SER A  50      37.020  42.208  61.166  1.00 50.18           O  
ATOM    377  N   CYS A  51      37.565  44.319  58.348  1.00 42.61           N  
ATOM    378  CA  CYS A  51      36.553  45.021  57.580  1.00 42.03           C  
ATOM    379  C   CYS A  51      35.178  44.646  58.137  1.00 40.90           C  
ATOM    380  O   CYS A  51      34.869  43.461  58.269  1.00 40.43           O  
ATOM    381  CB  CYS A  51      36.673  44.615  56.113  1.00 42.38           C  
ATOM    382  SG  CYS A  51      35.806  45.685  54.975  1.00 46.44           S  
ATOM    383  N   HIS A  52      34.359  45.637  58.484  1.00 39.82           N  
ATOM    384  CA  HIS A  52      33.037  45.330  59.025  1.00 41.16           C  
ATOM    385  C   HIS A  52      32.086  44.842  57.937  1.00 39.32           C  
ATOM    386  O   HIS A  52      32.164  45.280  56.789  1.00 38.67           O  
ATOM    387  CB  HIS A  52      32.432  46.536  59.759  1.00 45.27           C  
ATOM    388  CG  HIS A  52      32.241  47.747  58.901  1.00 49.80           C  
ATOM    389  ND1 HIS A  52      33.274  48.599  58.580  1.00 52.77           N  
ATOM    390  CD2 HIS A  52      31.133  48.258  58.313  1.00 52.17           C  
ATOM    391  CE1 HIS A  52      32.810  49.590  57.834  1.00 54.17           C  
ATOM    392  NE2 HIS A  52      31.514  49.405  57.657  1.00 53.55           N  
ATOM    393  N   GLY A  53      31.199  43.926  58.313  1.00 37.90           N  
ATOM    394  CA  GLY A  53      30.242  43.361  57.375  1.00 36.42           C  
ATOM    395  C   GLY A  53      29.564  44.351  56.447  1.00 35.20           C  
ATOM    396  O   GLY A  53      29.250  44.014  55.311  1.00 34.64           O  
ATOM    397  N   GLY A  54      29.344  45.571  56.923  1.00 34.61           N  
ATOM    398  CA  GLY A  54      28.684  46.578  56.113  1.00 33.74           C  
ATOM    399  C   GLY A  54      29.463  46.960  54.877  1.00 34.02           C  
ATOM    400  O   GLY A  54      28.877  47.210  53.821  1.00 33.46           O  
ATOM    401  N   GLN A  55      30.785  47.028  55.005  1.00 34.20           N  
ATOM    402  CA  GLN A  55      31.643  47.363  53.872  1.00 34.77           C  
ATOM    403  C   GLN A  55      31.635  46.207  52.884  1.00 32.87           C  
ATOM    404  O   GLN A  55      31.528  46.410  51.675  1.00 30.58           O  
ATOM    405  CB  GLN A  55      33.079  47.620  54.336  1.00 39.46           C  
ATOM    406  CG  GLN A  55      33.427  49.082  54.547  1.00 45.41           C  
ATOM    407  CD  GLN A  55      33.306  49.901  53.270  1.00 49.15           C  
ATOM    408  OE1 GLN A  55      33.828  49.520  52.217  1.00 51.21           O  
ATOM    409  NE2 GLN A  55      32.629  51.041  53.361  1.00 50.57           N  
ATOM    410  N   LEU A  56      31.768  44.994  53.412  1.00 30.30           N  
ATOM    411  CA  LEU A  56      31.759  43.802  52.585  1.00 30.20           C  
ATOM    412  C   LEU A  56      30.446  43.724  51.809  1.00 28.89           C  
ATOM    413  O   LEU A  56      30.427  43.370  50.640  1.00 28.33           O  
ATOM    414  CB  LEU A  56      31.917  42.547  53.450  1.00 31.21           C  
ATOM    415  CG  LEU A  56      33.304  42.293  54.058  1.00 34.06           C  
ATOM    416  CD1 LEU A  56      33.265  41.041  54.928  1.00 33.50           C  
ATOM    417  CD2 LEU A  56      34.346  42.128  52.944  1.00 31.10           C  
ATOM    418  N   PHE A  57      29.345  44.053  52.467  1.00 28.91           N  
ATOM    419  CA  PHE A  57      28.052  44.009  51.807  1.00 29.01           C  
ATOM    420  C   PHE A  57      28.035  45.033  50.675  1.00 28.10           C  
ATOM    421  O   PHE A  57      27.613  44.731  49.560  1.00 28.39           O  
ATOM    422  CB  PHE A  57      26.936  44.302  52.814  1.00 29.13           C  
ATOM    423  CG  PHE A  57      25.555  44.174  52.238  1.00 30.97           C  
ATOM    424  CD1 PHE A  57      24.858  42.977  52.334  1.00 30.45           C  
ATOM    425  CD2 PHE A  57      24.965  45.244  51.571  1.00 30.95           C  
ATOM    426  CE1 PHE A  57      23.591  42.844  51.772  1.00 32.63           C  
ATOM    427  CE2 PHE A  57      23.698  45.121  51.004  1.00 33.51           C  
ATOM    428  CZ  PHE A  57      23.009  43.916  51.107  1.00 32.48           C  
ATOM    429  N   SER A  58      28.512  46.242  50.953  1.00 26.30           N  
ATOM    430  CA  SER A  58      28.539  47.292  49.934  1.00 27.66           C  
ATOM    431  C   SER A  58      29.370  46.909  48.717  1.00 27.89           C  
ATOM    432  O   SER A  58      29.005  47.207  47.580  1.00 26.94           O  
ATOM    433  CB  SER A  58      29.072  48.596  50.530  1.00 29.73           C  
ATOM    434  OG  SER A  58      28.086  49.204  51.343  1.00 33.35           O  
ATOM    435  N   LEU A  59      30.504  46.265  48.955  1.00 28.01           N  
ATOM    436  CA  LEU A  59      31.357  45.827  47.864  1.00 26.88           C  
ATOM    437  C   LEU A  59      30.574  44.823  47.008  1.00 26.61           C  
ATOM    438  O   LEU A  59      30.484  44.969  45.780  1.00 25.68           O  
ATOM    439  CB  LEU A  59      32.631  45.179  48.417  1.00 27.99           C  
ATOM    440  CG  LEU A  59      33.588  44.500  47.436  1.00 28.61           C  
ATOM    441  CD1 LEU A  59      33.934  45.433  46.284  1.00 28.72           C  
ATOM    442  CD2 LEU A  59      34.850  44.071  48.168  1.00 30.19           C  
ATOM    443  N   ALA A  60      30.004  43.816  47.664  1.00 25.89           N  
ATOM    444  CA  ALA A  60      29.230  42.785  46.968  1.00 26.92           C  
ATOM    445  C   ALA A  60      28.049  43.384  46.205  1.00 26.88           C  
ATOM    446  O   ALA A  60      27.780  42.996  45.073  1.00 25.57           O  
ATOM    447  CB  ALA A  60      28.736  41.742  47.970  1.00 26.00           C  
ATOM    448  N   ASP A  61      27.350  44.321  46.843  1.00 27.72           N  
ATOM    449  CA  ASP A  61      26.205  44.991  46.241  1.00 29.08           C  
ATOM    450  C   ASP A  61      26.617  45.728  44.966  1.00 28.43           C  
ATOM    451  O   ASP A  61      25.922  45.687  43.948  1.00 26.58           O  
ATOM    452  CB  ASP A  61      25.595  45.969  47.251  1.00 34.11           C  
ATOM    453  CG  ASP A  61      24.428  46.748  46.683  1.00 40.44           C  
ATOM    454  OD1 ASP A  61      24.581  47.967  46.426  1.00 43.93           O  
ATOM    455  OD2 ASP A  61      23.345  46.146  46.503  1.00 43.54           O  
ATOM    456  N   THR A  62      27.749  46.415  45.028  1.00 28.15           N  
ATOM    457  CA  THR A  62      28.246  47.139  43.872  1.00 27.73           C  
ATOM    458  C   THR A  62      28.587  46.186  42.725  1.00 26.48           C  
ATOM    459  O   THR A  62      28.316  46.490  41.565  1.00 23.47           O  
ATOM    460  CB  THR A  62      29.500  47.975  44.228  1.00 29.99           C  
ATOM    461  OG1 THR A  62      29.148  48.961  45.205  1.00 32.05           O  
ATOM    462  CG2 THR A  62      30.056  48.669  42.993  1.00 29.81           C  
ATOM    463  N   ALA A  63      29.169  45.030  43.033  1.00 24.81           N  
ATOM    464  CA  ALA A  63      29.530  44.079  41.972  1.00 24.60           C  
ATOM    465  C   ALA A  63      28.270  43.479  41.343  1.00 22.61           C  
ATOM    466  O   ALA A  63      28.241  43.181  40.152  1.00 21.77           O  
ATOM    467  CB  ALA A  63      30.425  42.970  42.536  1.00 23.13           C  
ATOM    468  N   PHE A  64      27.248  43.283  42.171  1.00 24.84           N  
ATOM    469  CA  PHE A  64      25.951  42.750  41.749  1.00 26.61           C  
ATOM    470  C   PHE A  64      25.252  43.749  40.819  1.00 25.94           C  
ATOM    471  O   PHE A  64      24.667  43.376  39.803  1.00 24.78           O  
ATOM    472  CB  PHE A  64      25.087  42.502  42.996  1.00 27.48           C  
ATOM    473  CG  PHE A  64      23.597  42.528  42.738  1.00 28.88           C  
ATOM    474  CD1 PHE A  64      22.961  41.468  42.097  1.00 29.26           C  
ATOM    475  CD2 PHE A  64      22.830  43.626  43.143  1.00 29.11           C  
ATOM    476  CE1 PHE A  64      21.580  41.504  41.862  1.00 30.39           C  
ATOM    477  CE2 PHE A  64      21.453  43.675  42.914  1.00 31.30           C  
ATOM    478  CZ  PHE A  64      20.823  42.613  42.274  1.00 30.76           C  
ATOM    479  N   ALA A  65      25.299  45.022  41.193  1.00 25.06           N  
ATOM    480  CA  ALA A  65      24.672  46.059  40.386  1.00 25.07           C  
ATOM    481  C   ALA A  65      25.358  46.109  39.021  1.00 24.00           C  
ATOM    482  O   ALA A  65      24.694  46.284  37.996  1.00 25.01           O  
ATOM    483  CB  ALA A  65      24.761  47.416  41.083  1.00 23.58           C  
ATOM    484  N   TYR A  66      26.684  45.971  38.997  1.00 21.99           N  
ATOM    485  CA  TYR A  66      27.407  45.975  37.736  1.00 23.13           C  
ATOM    486  C   TYR A  66      27.035  44.769  36.898  1.00 23.25           C  
ATOM    487  O   TYR A  66      26.899  44.884  35.687  1.00 24.44           O  
ATOM    488  CB  TYR A  66      28.929  46.000  37.952  1.00 25.42           C  
ATOM    489  CG  TYR A  66      29.512  47.380  38.169  1.00 28.16           C  
ATOM    490  CD1 TYR A  66      30.438  47.615  39.187  1.00 29.94           C  
ATOM    491  CD2 TYR A  66      29.136  48.457  37.353  1.00 30.13           C  
ATOM    492  CE1 TYR A  66      30.970  48.894  39.395  1.00 30.14           C  
ATOM    493  CE2 TYR A  66      29.671  49.738  37.553  1.00 31.31           C  
ATOM    494  CZ  TYR A  66      30.588  49.942  38.585  1.00 30.91           C  
ATOM    495  OH  TYR A  66      31.106  51.201  38.805  1.00 32.35           O  
ATOM    496  N   ALA A  67      26.874  43.612  37.528  1.00 21.94           N  
ATOM    497  CA  ALA A  67      26.507  42.412  36.775  1.00 24.85           C  
ATOM    498  C   ALA A  67      25.101  42.574  36.170  1.00 25.68           C  
ATOM    499  O   ALA A  67      24.844  42.098  35.071  1.00 27.00           O  
ATOM    500  CB  ALA A  67      26.568  41.164  37.670  1.00 22.36           C  
ATOM    501  N   CYS A  68      24.199  43.249  36.874  1.00 27.08           N  
ATOM    502  CA  CYS A  68      22.856  43.479  36.340  1.00 29.26           C  
ATOM    503  C   CYS A  68      22.932  44.442  35.153  1.00 30.46           C  
ATOM    504  O   CYS A  68      22.365  44.192  34.090  1.00 28.61           O  
ATOM    505  CB  CYS A  68      21.944  44.106  37.387  1.00 29.74           C  
ATOM    506  SG  CYS A  68      21.645  43.096  38.800  1.00 34.12           S  
ATOM    507  N   ASN A  69      23.644  45.545  35.355  1.00 30.69           N  
ATOM    508  CA  ASN A  69      23.803  46.572  34.340  1.00 32.25           C  
ATOM    509  C   ASN A  69      24.555  46.150  33.099  1.00 30.73           C  
ATOM    510  O   ASN A  69      24.391  46.765  32.059  1.00 31.24           O  
ATOM    511  CB  ASN A  69      24.466  47.804  34.956  1.00 32.16           C  
ATOM    512  CG  ASN A  69      23.630  48.405  36.059  1.00 34.83           C  
ATOM    513  OD1 ASN A  69      22.411  48.228  36.087  1.00 33.82           O  
ATOM    514  ND2 ASN A  69      24.275  49.128  36.974  1.00 34.47           N  
ATOM    515  N   SER A  70      25.386  45.120  33.208  1.00 29.40           N  
ATOM    516  CA  SER A  70      26.122  44.629  32.054  1.00 29.37           C  
ATOM    517  C   SER A  70      25.130  44.175  30.984  1.00 29.58           C  
ATOM    518  O   SER A  70      25.466  44.088  29.804  1.00 28.97           O  
ATOM    519  CB  SER A  70      27.001  43.439  32.431  1.00 28.58           C  
ATOM    520  OG  SER A  70      26.205  42.289  32.653  1.00 26.56           O  
ATOM    521  N   GLN A  71      23.902  43.885  31.396  1.00 30.09           N  
ATOM    522  CA  GLN A  71      22.892  43.432  30.450  1.00 30.63           C  
ATOM    523  C   GLN A  71      21.654  44.312  30.455  1.00 29.69           C  
ATOM    524  O   GLN A  71      20.591  43.905  29.984  1.00 30.44           O  
ATOM    525  CB  GLN A  71      22.526  41.978  30.755  1.00 31.35           C  
ATOM    526  CG  GLN A  71      22.332  41.700  32.233  1.00 36.10           C  
ATOM    527  CD  GLN A  71      22.484  40.218  32.596  1.00 39.46           C  
ATOM    528  OE1 GLN A  71      22.518  39.855  33.780  1.00 40.80           O  
ATOM    529  NE2 GLN A  71      22.578  39.361  31.580  1.00 37.32           N  
ATOM    530  N   GLY A  72      21.804  45.523  30.976  1.00 28.31           N  
ATOM    531  CA  GLY A  72      20.691  46.451  31.027  1.00 29.51           C  
ATOM    532  C   GLY A  72      19.517  45.939  31.827  1.00 31.58           C  
ATOM    533  O   GLY A  72      18.367  46.224  31.496  1.00 31.25           O  
ATOM    534  N   LEU A  73      19.794  45.189  32.887  1.00 32.04           N  
ATOM    535  CA  LEU A  73      18.725  44.632  33.708  1.00 33.67           C  
ATOM    536  C   LEU A  73      18.756  45.178  35.123  1.00 35.09           C  
ATOM    537  O   LEU A  73      18.969  44.427  36.078  1.00 35.97           O  
ATOM    538  CB  LEU A  73      18.833  43.102  33.744  1.00 33.58           C  
ATOM    539  CG  LEU A  73      18.727  42.403  32.377  1.00 36.28           C  
ATOM    540  CD1 LEU A  73      18.914  40.906  32.555  1.00 34.93           C  
ATOM    541  CD2 LEU A  73      17.366  42.700  31.737  1.00 35.65           C  
ATOM    542  N   ALA A  74      18.542  46.482  35.256  1.00 34.64           N  
ATOM    543  CA  ALA A  74      18.536  47.136  36.563  1.00 34.45           C  
ATOM    544  C   ALA A  74      17.660  46.382  37.562  1.00 34.39           C  
ATOM    545  O   ALA A  74      16.493  46.082  37.294  1.00 32.55           O  
ATOM    546  CB  ALA A  74      18.052  48.578  36.424  1.00 34.61           C  
ATOM    547  N   ALA A  75      18.230  46.086  38.723  1.00 34.46           N  
ATOM    548  CA  ALA A  75      17.503  45.343  39.743  1.00 35.62           C  
ATOM    549  C   ALA A  75      17.942  45.707  41.152  1.00 36.45           C  
ATOM    550  O   ALA A  75      19.029  46.252  41.362  1.00 37.65           O  
ATOM    551  CB  ALA A  75      17.704  43.839  39.525  1.00 32.65           C  
ATOM    552  N   VAL A  76      17.085  45.401  42.118  1.00 37.88           N  
ATOM    553  CA  VAL A  76      17.392  45.645  43.523  1.00 37.64           C  
ATOM    554  C   VAL A  76      17.365  44.296  44.231  1.00 36.00           C  
ATOM    555  O   VAL A  76      16.621  43.400  43.837  1.00 34.90           O  
ATOM    556  CB  VAL A  76      16.353  46.564  44.183  1.00 39.13           C  
ATOM    557  CG1 VAL A  76      16.703  46.749  45.649  1.00 42.17           C  
ATOM    558  CG2 VAL A  76      16.327  47.908  43.480  1.00 39.81           C  
ATOM    559  N   ALA A  77      18.180  44.149  45.266  1.00 34.90           N  
ATOM    560  CA  ALA A  77      18.214  42.912  46.016  1.00 33.76           C  
ATOM    561  C   ALA A  77      16.996  42.815  46.920  1.00 31.93           C  
ATOM    562  O   ALA A  77      16.641  43.779  47.605  1.00 31.84           O  
ATOM    563  CB  ALA A  77      19.491  42.843  46.847  1.00 36.38           C  
ATOM    564  N   SER A  78      16.329  41.665  46.900  1.00 29.88           N  
ATOM    565  CA  SER A  78      15.172  41.456  47.767  1.00 29.41           C  
ATOM    566  C   SER A  78      15.578  40.565  48.952  1.00 27.29           C  
ATOM    567  O   SER A  78      14.975  40.622  50.015  1.00 25.34           O  
ATOM    568  CB  SER A  78      14.025  40.809  46.992  1.00 29.40           C  
ATOM    569  OG  SER A  78      14.359  39.507  46.573  1.00 34.04           O  
ATOM    570  N   ALA A  79      16.596  39.737  48.750  1.00 27.62           N  
ATOM    571  CA  ALA A  79      17.083  38.862  49.809  1.00 27.35           C  
ATOM    572  C   ALA A  79      18.536  38.555  49.520  1.00 27.12           C  
ATOM    573  O   ALA A  79      18.995  38.680  48.384  1.00 26.37           O  
ATOM    574  CB  ALA A  79      16.275  37.565  49.856  1.00 25.78           C  
ATOM    575  N   CYS A  80      19.274  38.171  50.557  1.00 28.40           N  
ATOM    576  CA  CYS A  80      20.683  37.827  50.390  1.00 29.95           C  
ATOM    577  C   CYS A  80      21.160  36.946  51.532  1.00 28.40           C  
ATOM    578  O   CYS A  80      20.765  37.138  52.676  1.00 26.93           O  
ATOM    579  CB  CYS A  80      21.547  39.090  50.335  1.00 30.59           C  
ATOM    580  SG  CYS A  80      23.288  38.720  49.939  1.00 42.12           S  
ATOM    581  N   THR A  81      21.996  35.971  51.202  1.00 29.49           N  
ATOM    582  CA  THR A  81      22.561  35.083  52.207  1.00 29.71           C  
ATOM    583  C   THR A  81      24.060  35.289  52.114  1.00 28.58           C  
ATOM    584  O   THR A  81      24.592  35.431  51.021  1.00 27.79           O  
ATOM    585  CB  THR A  81      22.227  33.611  51.939  1.00 31.02           C  
ATOM    586  OG1 THR A  81      20.809  33.438  51.970  1.00 33.04           O  
ATOM    587  CG2 THR A  81      22.837  32.728  53.018  1.00 32.21           C  
ATOM    588  N   ILE A  82      24.737  35.321  53.257  1.00 30.28           N  
ATOM    589  CA  ILE A  82      26.172  35.573  53.276  1.00 29.82           C  
ATOM    590  C   ILE A  82      26.905  34.628  54.213  1.00 28.08           C  
ATOM    591  O   ILE A  82      26.451  34.385  55.320  1.00 28.03           O  
ATOM    592  CB  ILE A  82      26.456  37.010  53.758  1.00 31.66           C  
ATOM    593  CG1 ILE A  82      25.493  37.979  53.081  1.00 31.99           C  
ATOM    594  CG2 ILE A  82      27.911  37.372  53.468  1.00 31.27           C  
ATOM    595  CD1 ILE A  82      25.553  39.383  53.644  1.00 34.36           C  
ATOM    596  N   ASP A  83      28.027  34.087  53.748  1.00 29.62           N  
ATOM    597  CA  ASP A  83      28.863  33.216  54.560  1.00 30.34           C  
ATOM    598  C   ASP A  83      30.201  33.921  54.707  1.00 28.83           C  
ATOM    599  O   ASP A  83      30.854  34.219  53.710  1.00 28.47           O  
ATOM    600  CB  ASP A  83      29.085  31.859  53.886  1.00 33.95           C  
ATOM    601  CG  ASP A  83      27.855  30.981  53.931  1.00 39.55           C  
ATOM    602  OD1 ASP A  83      27.403  30.629  55.044  1.00 44.17           O  
ATOM    603  OD2 ASP A  83      27.331  30.627  52.854  1.00 44.21           O  
ATOM    604  N   PHE A  84      30.607  34.211  55.939  1.00 28.73           N  
ATOM    605  CA  PHE A  84      31.901  34.861  56.166  1.00 28.95           C  
ATOM    606  C   PHE A  84      32.889  33.753  56.474  1.00 28.79           C  
ATOM    607  O   PHE A  84      32.726  33.027  57.456  1.00 29.23           O  
ATOM    608  CB  PHE A  84      31.830  35.812  57.352  1.00 28.48           C  
ATOM    609  CG  PHE A  84      30.801  36.882  57.196  1.00 29.57           C  
ATOM    610  CD1 PHE A  84      29.509  36.693  57.673  1.00 30.06           C  
ATOM    611  CD2 PHE A  84      31.119  38.084  56.563  1.00 31.09           C  
ATOM    612  CE1 PHE A  84      28.535  37.690  57.530  1.00 29.80           C  
ATOM    613  CE2 PHE A  84      30.157  39.095  56.411  1.00 31.65           C  
ATOM    614  CZ  PHE A  84      28.862  38.897  56.895  1.00 27.61           C  
ATOM    615  N   LEU A  85      33.915  33.630  55.642  1.00 30.49           N  
ATOM    616  CA  LEU A  85      34.922  32.588  55.821  1.00 31.89           C  
ATOM    617  C   LEU A  85      36.230  33.082  56.442  1.00 32.37           C  
ATOM    618  O   LEU A  85      36.789  32.421  57.309  1.00 33.28           O  
ATOM    619  CB  LEU A  85      35.215  31.920  54.474  1.00 31.10           C  
ATOM    620  CG  LEU A  85      33.980  31.405  53.713  1.00 32.00           C  
ATOM    621  CD1 LEU A  85      34.424  30.724  52.431  1.00 34.86           C  
ATOM    622  CD2 LEU A  85      33.205  30.425  54.574  1.00 33.86           C  
ATOM    623  N   ARG A  86      36.716  34.231  55.979  1.00 34.54           N  
ATOM    624  CA  ARG A  86      37.954  34.818  56.478  1.00 35.87           C  
ATOM    625  C   ARG A  86      37.754  36.319  56.603  1.00 36.02           C  
ATOM    626  O   ARG A  86      37.016  36.924  55.833  1.00 35.34           O  
ATOM    627  CB  ARG A  86      39.115  34.559  55.517  1.00 37.97           C  
ATOM    628  CG  ARG A  86      39.373  33.100  55.203  1.00 42.57           C  
ATOM    629  CD  ARG A  86      40.263  32.959  53.977  1.00 46.95           C  
ATOM    630  NE  ARG A  86      40.209  31.609  53.410  1.00 50.14           N  
ATOM    631  CZ  ARG A  86      41.005  30.612  53.779  1.00 53.48           C  
ATOM    632  NH1 ARG A  86      41.925  30.809  54.717  1.00 54.95           N  
ATOM    633  NH2 ARG A  86      40.877  29.420  53.212  1.00 54.53           N  
ATOM    634  N   PRO A  87      38.433  36.947  57.572  1.00 36.23           N  
ATOM    635  CA  PRO A  87      38.296  38.397  57.760  1.00 35.57           C  
ATOM    636  C   PRO A  87      39.020  39.176  56.663  1.00 35.03           C  
ATOM    637  O   PRO A  87      39.957  38.676  56.051  1.00 34.16           O  
ATOM    638  CB  PRO A  87      38.932  38.631  59.141  1.00 36.36           C  
ATOM    639  CG  PRO A  87      38.875  37.257  59.819  1.00 35.76           C  
ATOM    640  CD  PRO A  87      39.200  36.336  58.674  1.00 35.44           C  
ATOM    641  N   GLY A  88      38.558  40.390  56.401  1.00 35.33           N  
ATOM    642  CA  GLY A  88      39.212  41.219  55.414  1.00 34.11           C  
ATOM    643  C   GLY A  88      39.999  42.268  56.173  1.00 34.88           C  
ATOM    644  O   GLY A  88      39.441  43.270  56.620  1.00 34.86           O  
ATOM    645  N   PHE A  89      41.297  42.038  56.337  1.00 33.02           N  
ATOM    646  CA  PHE A  89      42.140  42.972  57.088  1.00 32.77           C  
ATOM    647  C   PHE A  89      42.556  44.211  56.313  1.00 31.80           C  
ATOM    648  O   PHE A  89      42.491  44.252  55.081  1.00 31.51           O  
ATOM    649  CB  PHE A  89      43.398  42.268  57.580  1.00 32.45           C  
ATOM    650  CG  PHE A  89      43.122  41.028  58.373  1.00 34.54           C  
ATOM    651  CD1 PHE A  89      43.292  39.778  57.799  1.00 35.23           C  
ATOM    652  CD2 PHE A  89      42.703  41.105  59.697  1.00 35.13           C  
ATOM    653  CE1 PHE A  89      43.057  38.620  58.528  1.00 35.39           C  
ATOM    654  CE2 PHE A  89      42.463  39.953  60.438  1.00 35.75           C  
ATOM    655  CZ  PHE A  89      42.641  38.709  59.855  1.00 35.29           C  
ATOM    656  N   ALA A  90      42.989  45.227  57.051  1.00 32.02           N  
ATOM    657  CA  ALA A  90      43.455  46.472  56.446  1.00 31.29           C  
ATOM    658  C   ALA A  90      44.604  46.152  55.498  1.00 30.80           C  
ATOM    659  O   ALA A  90      45.413  45.260  55.766  1.00 30.71           O  
ATOM    660  CB  ALA A  90      43.932  47.436  57.535  1.00 30.80           C  
ATOM    661  N   GLY A  91      44.671  46.880  54.391  1.00 29.71           N  
ATOM    662  CA  GLY A  91      45.718  46.648  53.419  1.00 29.53           C  
ATOM    663  C   GLY A  91      45.353  45.610  52.378  1.00 29.99           C  
ATOM    664  O   GLY A  91      45.857  45.631  51.257  1.00 30.95           O  
ATOM    665  N   ASP A  92      44.472  44.690  52.749  1.00 30.41           N  
ATOM    666  CA  ASP A  92      44.052  43.641  51.829  1.00 31.24           C  
ATOM    667  C   ASP A  92      43.339  44.222  50.613  1.00 30.35           C  
ATOM    668  O   ASP A  92      42.654  45.245  50.698  1.00 28.08           O  
ATOM    669  CB  ASP A  92      43.124  42.652  52.535  1.00 32.83           C  
ATOM    670  CG  ASP A  92      43.849  41.820  53.568  1.00 37.44           C  
ATOM    671  OD1 ASP A  92      45.080  42.004  53.740  1.00 39.11           O  
ATOM    672  OD2 ASP A  92      43.200  40.963  54.203  1.00 41.07           O  
ATOM    673  N   THR A  93      43.533  43.578  49.471  1.00 28.91           N  
ATOM    674  CA  THR A  93      42.874  44.004  48.251  1.00 29.41           C  
ATOM    675  C   THR A  93      41.866  42.906  47.999  1.00 29.08           C  
ATOM    676  O   THR A  93      42.231  41.753  47.793  1.00 29.48           O  
ATOM    677  CB  THR A  93      43.837  44.086  47.069  1.00 30.42           C  
ATOM    678  OG1 THR A  93      44.881  45.019  47.368  1.00 33.00           O  
ATOM    679  CG2 THR A  93      43.085  44.543  45.816  1.00 30.01           C  
ATOM    680  N   LEU A  94      40.594  43.272  48.048  1.00 26.65           N  
ATOM    681  CA  LEU A  94      39.533  42.316  47.858  1.00 28.07           C  
ATOM    682  C   LEU A  94      38.968  42.403  46.455  1.00 28.30           C  
ATOM    683  O   LEU A  94      38.788  43.494  45.906  1.00 28.83           O  
ATOM    684  CB  LEU A  94      38.429  42.556  48.885  1.00 27.51           C  
ATOM    685  CG  LEU A  94      38.862  42.623  50.349  1.00 27.78           C  
ATOM    686  CD1 LEU A  94      37.659  42.977  51.204  1.00 28.96           C  
ATOM    687  CD2 LEU A  94      39.457  41.299  50.784  1.00 27.92           C  
ATOM    688  N   THR A  95      38.711  41.238  45.872  1.00 27.70           N  
ATOM    689  CA  THR A  95      38.156  41.158  44.532  1.00 27.81           C  
ATOM    690  C   THR A  95      36.797  40.495  44.684  1.00 26.13           C  
ATOM    691  O   THR A  95      36.672  39.430  45.275  1.00 24.20           O  
ATOM    692  CB  THR A  95      39.048  40.307  43.603  1.00 30.09           C  
ATOM    693  OG1 THR A  95      40.337  40.920  43.497  1.00 29.95           O  
ATOM    694  CG2 THR A  95      38.430  40.210  42.210  1.00 30.43           C  
ATOM    695  N   ALA A  96      35.775  41.140  44.151  1.00 24.74           N  
ATOM    696  CA  ALA A  96      34.429  40.622  44.246  1.00 25.17           C  
ATOM    697  C   ALA A  96      33.940  40.254  42.862  1.00 25.46           C  
ATOM    698  O   ALA A  96      33.932  41.093  41.964  1.00 23.57           O  
ATOM    699  CB  ALA A  96      33.516  41.673  44.881  1.00 25.70           C  
ATOM    700  N   THR A  97      33.565  38.990  42.679  1.00 25.65           N  
ATOM    701  CA  THR A  97      33.055  38.543  41.384  1.00 25.96           C  
ATOM    702  C   THR A  97      31.570  38.209  41.511  1.00 23.17           C  
ATOM    703  O   THR A  97      31.180  37.377  42.312  1.00 22.87           O  
ATOM    704  CB  THR A  97      33.803  37.299  40.892  1.00 27.18           C  
ATOM    705  OG1 THR A  97      35.202  37.585  40.833  1.00 27.48           O  
ATOM    706  CG2 THR A  97      33.331  36.915  39.497  1.00 26.53           C  
ATOM    707  N   ALA A  98      30.748  38.893  40.727  1.00 22.80           N  
ATOM    708  CA  ALA A  98      29.325  38.647  40.715  1.00 22.27           C  
ATOM    709  C   ALA A  98      28.991  37.968  39.393  1.00 22.99           C  
ATOM    710  O   ALA A  98      29.505  38.353  38.345  1.00 24.73           O  
ATOM    711  CB  ALA A  98      28.553  39.934  40.845  1.00 22.16           C  
ATOM    712  N   GLN A  99      28.121  36.965  39.444  1.00 25.31           N  
ATOM    713  CA  GLN A  99      27.728  36.217  38.254  1.00 24.89           C  
ATOM    714  C   GLN A  99      26.251  35.879  38.356  1.00 24.13           C  
ATOM    715  O   GLN A  99      25.770  35.472  39.414  1.00 25.77           O  
ATOM    716  CB  GLN A  99      28.555  34.931  38.176  1.00 27.68           C  
ATOM    717  CG  GLN A  99      28.043  33.902  37.185  1.00 33.15           C  
ATOM    718  CD  GLN A  99      28.534  34.135  35.777  1.00 35.13           C  
ATOM    719  OE1 GLN A  99      27.795  33.935  34.818  1.00 39.16           O  
ATOM    720  NE2 GLN A  99      29.793  34.535  35.640  1.00 37.43           N  
ATOM    721  N   VAL A 100      25.518  36.059  37.263  1.00 23.54           N  
ATOM    722  CA  VAL A 100      24.096  35.722  37.271  1.00 23.36           C  
ATOM    723  C   VAL A 100      24.029  34.184  37.271  1.00 23.93           C  
ATOM    724  O   VAL A 100      24.797  33.534  36.572  1.00 22.11           O  
ATOM    725  CB  VAL A 100      23.364  36.180  35.982  1.00 25.20           C  
ATOM    726  CG1 VAL A 100      21.863  36.185  36.218  1.00 22.91           C  
ATOM    727  CG2 VAL A 100      23.858  37.521  35.533  1.00 29.56           C  
ATOM    728  N   ARG A 101      23.111  33.618  38.040  1.00 23.66           N  
ATOM    729  CA  ARG A 101      22.955  32.182  38.092  1.00 27.54           C  
ATOM    730  C   ARG A 101      21.593  31.809  37.523  1.00 28.88           C  
ATOM    731  O   ARG A 101      21.383  30.692  37.059  1.00 31.96           O  
ATOM    732  CB  ARG A 101      23.082  31.662  39.531  1.00 27.31           C  
ATOM    733  CG  ARG A 101      24.497  31.762  40.105  1.00 28.04           C  
ATOM    734  CD  ARG A 101      25.496  31.018  39.218  1.00 30.32           C  
ATOM    735  NE  ARG A 101      25.163  29.606  39.095  1.00 32.88           N  
ATOM    736  CZ  ARG A 101      25.417  28.691  40.024  1.00 34.46           C  
ATOM    737  NH1 ARG A 101      26.019  29.038  41.152  1.00 35.61           N  
ATOM    738  NH2 ARG A 101      25.069  27.422  39.823  1.00 35.19           N  
ATOM    739  N   HIS A 102      20.665  32.753  37.563  1.00 30.05           N  
ATOM    740  CA  HIS A 102      19.320  32.530  37.046  1.00 32.84           C  
ATOM    741  C   HIS A 102      18.662  33.862  36.740  1.00 34.56           C  
ATOM    742  O   HIS A 102      18.785  34.807  37.512  1.00 33.41           O  
ATOM    743  CB  HIS A 102      18.468  31.785  38.070  1.00 33.08           C  
ATOM    744  CG  HIS A 102      17.031  31.659  37.679  1.00 34.35           C  
ATOM    745  ND1 HIS A 102      16.583  30.702  36.791  1.00 35.37           N  
ATOM    746  CD2 HIS A 102      15.948  32.398  38.013  1.00 32.90           C  
ATOM    747  CE1 HIS A 102      15.287  30.859  36.598  1.00 33.45           C  
ATOM    748  NE2 HIS A 102      14.878  31.882  37.326  1.00 35.58           N  
ATOM    749  N   GLN A 103      17.965  33.936  35.613  1.00 37.94           N  
ATOM    750  CA  GLN A 103      17.286  35.165  35.240  1.00 41.88           C  
ATOM    751  C   GLN A 103      15.870  34.856  34.785  1.00 43.81           C  
ATOM    752  O   GLN A 103      15.662  34.360  33.677  1.00 45.92           O  
ATOM    753  CB  GLN A 103      18.038  35.869  34.114  1.00 42.00           C  
ATOM    754  CG  GLN A 103      17.657  37.329  33.962  1.00 44.29           C  
ATOM    755  CD  GLN A 103      18.080  38.152  35.164  1.00 46.70           C  
ATOM    756  OE1 GLN A 103      19.260  38.199  35.509  1.00 50.18           O  
ATOM    757  NE2 GLN A 103      17.119  38.808  35.808  1.00 46.40           N  
ATOM    758  N   GLY A 104      14.898  35.145  35.645  1.00 45.09           N  
ATOM    759  CA  GLY A 104      13.513  34.891  35.302  1.00 46.42           C  
ATOM    760  C   GLY A 104      12.822  36.105  34.709  1.00 47.61           C  
ATOM    761  O   GLY A 104      13.466  37.073  34.295  1.00 45.69           O  
ATOM    762  N   LYS A 105      11.497  36.044  34.666  1.00 49.07           N  
ATOM    763  CA  LYS A 105      10.699  37.135  34.125  1.00 50.04           C  
ATOM    764  C   LYS A 105      10.856  38.390  34.978  1.00 49.38           C  
ATOM    765  O   LYS A 105      11.184  39.462  34.470  1.00 49.86           O  
ATOM    766  CB  LYS A 105       9.221  36.735  34.089  1.00 52.50           C  
ATOM    767  CG  LYS A 105       8.879  35.592  33.141  1.00 54.36           C  
ATOM    768  CD  LYS A 105       7.401  35.235  33.250  1.00 55.94           C  
ATOM    769  CE  LYS A 105       6.989  34.181  32.234  1.00 57.20           C  
ATOM    770  NZ  LYS A 105       5.530  33.878  32.334  1.00 57.40           N  
ATOM    771  N   GLN A 106      10.635  38.247  36.281  1.00 48.68           N  
ATOM    772  CA  GLN A 106      10.716  39.386  37.184  1.00 48.00           C  
ATOM    773  C   GLN A 106      11.856  39.300  38.179  1.00 45.21           C  
ATOM    774  O   GLN A 106      12.324  40.319  38.677  1.00 44.44           O  
ATOM    775  CB  GLN A 106       9.402  39.522  37.954  1.00 50.25           C  
ATOM    776  CG  GLN A 106       8.164  39.386  37.091  1.00 53.85           C  
ATOM    777  CD  GLN A 106       7.250  38.275  37.570  1.00 56.23           C  
ATOM    778  OE1 GLN A 106       6.720  38.329  38.681  1.00 57.86           O  
ATOM    779  NE2 GLN A 106       7.064  37.256  36.733  1.00 57.62           N  
ATOM    780  N   THR A 107      12.301  38.085  38.469  1.00 42.87           N  
ATOM    781  CA  THR A 107      13.367  37.905  39.443  1.00 40.33           C  
ATOM    782  C   THR A 107      14.578  37.168  38.899  1.00 37.29           C  
ATOM    783  O   THR A 107      14.558  36.629  37.793  1.00 37.19           O  
ATOM    784  CB  THR A 107      12.857  37.143  40.690  1.00 41.51           C  
ATOM    785  OG1 THR A 107      12.464  35.820  40.312  1.00 44.68           O  
ATOM    786  CG2 THR A 107      11.665  37.860  41.306  1.00 40.78           C  
ATOM    787  N   GLY A 108      15.636  37.157  39.699  1.00 33.97           N  
ATOM    788  CA  GLY A 108      16.853  36.474  39.320  1.00 30.75           C  
ATOM    789  C   GLY A 108      17.656  36.090  40.545  1.00 29.41           C  
ATOM    790  O   GLY A 108      17.283  36.407  41.675  1.00 28.72           O  
ATOM    791  N   VAL A 109      18.761  35.394  40.314  1.00 28.22           N  
ATOM    792  CA  VAL A 109      19.649  34.959  41.386  1.00 26.03           C  
ATOM    793  C   VAL A 109      21.082  35.196  40.953  1.00 24.44           C  
ATOM    794  O   VAL A 109      21.498  34.749  39.886  1.00 25.03           O  
ATOM    795  CB  VAL A 109      19.490  33.467  41.692  1.00 26.24           C  
ATOM    796  CG1 VAL A 109      20.452  33.067  42.819  1.00 25.68           C  
ATOM    797  CG2 VAL A 109      18.063  33.177  42.090  1.00 24.37           C  
ATOM    798  N   TYR A 110      21.826  35.893  41.801  1.00 22.44           N  
ATOM    799  CA  TYR A 110      23.213  36.217  41.548  1.00 22.04           C  
ATOM    800  C   TYR A 110      24.124  35.651  42.623  1.00 21.24           C  
ATOM    801  O   TYR A 110      23.763  35.625  43.791  1.00 22.42           O  
ATOM    802  CB  TYR A 110      23.389  37.737  41.481  1.00 22.75           C  
ATOM    803  CG  TYR A 110      22.809  38.358  40.246  1.00 24.08           C  
ATOM    804  CD1 TYR A 110      21.428  38.493  40.083  1.00 25.14           C  
ATOM    805  CD2 TYR A 110      23.646  38.794  39.222  1.00 24.43           C  
ATOM    806  CE1 TYR A 110      20.901  39.051  38.908  1.00 26.66           C  
ATOM    807  CE2 TYR A 110      23.129  39.353  38.057  1.00 27.11           C  
ATOM    808  CZ  TYR A 110      21.745  39.472  37.912  1.00 26.57           C  
ATOM    809  OH  TYR A 110      21.236  40.019  36.749  1.00 28.78           O  
ATOM    810  N   ASP A 111      25.301  35.194  42.211  1.00 23.02           N  
ATOM    811  CA  ASP A 111      26.294  34.637  43.125  1.00 25.71           C  
ATOM    812  C   ASP A 111      27.437  35.645  43.200  1.00 23.08           C  
ATOM    813  O   ASP A 111      27.827  36.204  42.185  1.00 22.37           O  
ATOM    814  CB  ASP A 111      26.863  33.324  42.577  1.00 31.18           C  
ATOM    815  CG  ASP A 111      26.534  32.128  43.440  1.00 40.06           C  
ATOM    816  OD1 ASP A 111      26.355  32.289  44.669  1.00 46.74           O  
ATOM    817  OD2 ASP A 111      26.477  30.997  42.905  1.00 43.59           O  
ATOM    818  N   ILE A 112      27.971  35.890  44.389  1.00 23.20           N  
ATOM    819  CA  ILE A 112      29.099  36.802  44.504  1.00 22.79           C  
ATOM    820  C   ILE A 112      30.129  36.215  45.452  1.00 22.93           C  
ATOM    821  O   ILE A 112      29.791  35.765  46.537  1.00 24.72           O  
ATOM    822  CB  ILE A 112      28.653  38.188  45.018  1.00 22.53           C  
ATOM    823  CG1 ILE A 112      27.585  38.758  44.085  1.00 23.40           C  
ATOM    824  CG2 ILE A 112      29.832  39.166  45.014  1.00 24.74           C  
ATOM    825  CD1 ILE A 112      26.484  39.518  44.802  1.00 27.30           C  
ATOM    826  N   GLU A 113      31.383  36.185  45.018  1.00 26.01           N  
ATOM    827  CA  GLU A 113      32.456  35.669  45.851  1.00 27.38           C  
ATOM    828  C   GLU A 113      33.503  36.757  46.022  1.00 26.58           C  
ATOM    829  O   GLU A 113      33.860  37.451  45.069  1.00 27.59           O  
ATOM    830  CB  GLU A 113      33.096  34.431  45.214  1.00 30.42           C  
ATOM    831  CG  GLU A 113      34.418  34.008  45.874  1.00 35.74           C  
ATOM    832  CD  GLU A 113      34.935  32.673  45.366  1.00 42.42           C  
ATOM    833  OE1 GLU A 113      34.699  32.357  44.173  1.00 45.52           O  
ATOM    834  OE2 GLU A 113      35.611  31.942  46.139  1.00 43.21           O  
ATOM    835  N   ILE A 114      33.977  36.913  47.249  1.00 26.51           N  
ATOM    836  CA  ILE A 114      35.010  37.892  47.544  1.00 24.80           C  
ATOM    837  C   ILE A 114      36.259  37.165  48.007  1.00 23.77           C  
ATOM    838  O   ILE A 114      36.206  36.359  48.926  1.00 23.85           O  
ATOM    839  CB  ILE A 114      34.568  38.845  48.653  1.00 24.90           C  
ATOM    840  CG1 ILE A 114      33.344  39.632  48.176  1.00 24.79           C  
ATOM    841  CG2 ILE A 114      35.725  39.785  49.032  1.00 22.94           C  
ATOM    842  CD1 ILE A 114      32.763  40.542  49.215  1.00 24.58           C  
ATOM    843  N   VAL A 115      37.377  37.447  47.359  1.00 22.67           N  
ATOM    844  CA  VAL A 115      38.630  36.812  47.720  1.00 24.79           C  
ATOM    845  C   VAL A 115      39.657  37.896  48.014  1.00 25.21           C  
ATOM    846  O   VAL A 115      39.464  39.060  47.636  1.00 23.66           O  
ATOM    847  CB  VAL A 115      39.139  35.911  46.573  1.00 24.24           C  
ATOM    848  CG1 VAL A 115      38.026  34.951  46.142  1.00 24.05           C  
ATOM    849  CG2 VAL A 115      39.579  36.776  45.400  1.00 27.83           C  
ATOM    850  N   ASN A 116      40.736  37.528  48.706  1.00 26.75           N  
ATOM    851  CA  ASN A 116      41.790  38.495  49.010  1.00 27.30           C  
ATOM    852  C   ASN A 116      42.957  38.363  48.030  1.00 27.68           C  
ATOM    853  O   ASN A 116      42.911  37.568  47.087  1.00 27.52           O  
ATOM    854  CB  ASN A 116      42.283  38.348  50.466  1.00 25.50           C  
ATOM    855  CG  ASN A 116      42.841  36.968  50.782  1.00 27.66           C  
ATOM    856  OD1 ASN A 116      43.297  36.246  49.903  1.00 28.91           O  
ATOM    857  ND2 ASN A 116      42.815  36.605  52.064  1.00 28.10           N  
ATOM    858  N   GLN A 117      44.000  39.153  48.249  1.00 29.73           N  
ATOM    859  CA  GLN A 117      45.174  39.126  47.387  1.00 31.89           C  
ATOM    860  C   GLN A 117      45.840  37.741  47.336  1.00 33.62           C  
ATOM    861  O   GLN A 117      46.527  37.419  46.370  1.00 34.56           O  
ATOM    862  CB  GLN A 117      46.190  40.188  47.844  1.00 32.93           C  
ATOM    863  CG  GLN A 117      46.748  39.953  49.241  1.00 34.55           C  
ATOM    864  CD  GLN A 117      45.845  40.452  50.362  1.00 35.28           C  
ATOM    865  OE1 GLN A 117      44.663  40.738  50.159  1.00 35.84           O  
ATOM    866  NE2 GLN A 117      46.408  40.547  51.562  1.00 35.40           N  
ATOM    867  N   GLN A 118      45.624  36.927  48.365  1.00 34.04           N  
ATOM    868  CA  GLN A 118      46.191  35.583  48.423  1.00 36.62           C  
ATOM    869  C   GLN A 118      45.255  34.618  47.706  1.00 37.37           C  
ATOM    870  O   GLN A 118      45.424  33.403  47.778  1.00 36.98           O  
ATOM    871  CB  GLN A 118      46.359  35.111  49.873  1.00 39.27           C  
ATOM    872  CG  GLN A 118      47.082  36.100  50.791  1.00 45.32           C  
ATOM    873  CD  GLN A 118      47.296  35.550  52.210  1.00 49.70           C  
ATOM    874  OE1 GLN A 118      46.361  35.044  52.846  1.00 52.81           O  
ATOM    875  NE2 GLN A 118      48.522  35.669  52.714  1.00 49.48           N  
ATOM    876  N   GLN A 119      44.252  35.165  47.031  1.00 37.74           N  
ATOM    877  CA  GLN A 119      43.285  34.353  46.303  1.00 38.42           C  
ATOM    878  C   GLN A 119      42.458  33.442  47.217  1.00 37.33           C  
ATOM    879  O   GLN A 119      41.863  32.471  46.756  1.00 38.53           O  
ATOM    880  CB  GLN A 119      44.005  33.514  45.239  1.00 42.62           C  
ATOM    881  CG  GLN A 119      44.912  34.327  44.306  1.00 46.88           C  
ATOM    882  CD  GLN A 119      44.144  35.129  43.261  1.00 50.44           C  
ATOM    883  OE1 GLN A 119      43.185  35.836  43.582  1.00 52.31           O  
ATOM    884  NE2 GLN A 119      44.575  35.031  42.002  1.00 51.55           N  
ATOM    885  N   LYS A 120      42.420  33.745  48.512  1.00 34.45           N  
ATOM    886  CA  LYS A 120      41.624  32.949  49.439  1.00 32.90           C  
ATOM    887  C   LYS A 120      40.247  33.592  49.582  1.00 30.00           C  
ATOM    888  O   LYS A 120      40.113  34.817  49.536  1.00 28.01           O  
ATOM    889  CB  LYS A 120      42.296  32.869  50.809  1.00 35.56           C  
ATOM    890  CG  LYS A 120      43.594  32.086  50.795  1.00 39.19           C  
ATOM    891  CD  LYS A 120      44.077  31.794  52.200  1.00 43.41           C  
ATOM    892  CE  LYS A 120      45.317  30.904  52.181  1.00 45.68           C  
ATOM    893  NZ  LYS A 120      45.822  30.644  53.566  1.00 47.51           N  
ATOM    894  N   THR A 121      39.231  32.760  49.771  1.00 28.03           N  
ATOM    895  CA  THR A 121      37.870  33.236  49.891  1.00 26.23           C  
ATOM    896  C   THR A 121      37.579  33.914  51.204  1.00 24.44           C  
ATOM    897  O   THR A 121      37.804  33.375  52.288  1.00 21.76           O  
ATOM    898  CB  THR A 121      36.859  32.110  49.669  1.00 27.27           C  
ATOM    899  OG1 THR A 121      37.072  31.540  48.373  1.00 30.75           O  
ATOM    900  CG2 THR A 121      35.435  32.664  49.745  1.00 28.30           C  
ATOM    901  N   VAL A 122      37.087  35.137  51.086  1.00 22.87           N  
ATOM    902  CA  VAL A 122      36.758  35.949  52.245  1.00 22.73           C  
ATOM    903  C   VAL A 122      35.275  35.777  52.585  1.00 21.35           C  
ATOM    904  O   VAL A 122      34.899  35.561  53.749  1.00 20.09           O  
ATOM    905  CB  VAL A 122      37.092  37.425  51.931  1.00 23.46           C  
ATOM    906  CG1 VAL A 122      36.525  38.350  52.993  1.00 23.61           C  
ATOM    907  CG2 VAL A 122      38.603  37.580  51.843  1.00 22.87           C  
ATOM    908  N   ALA A 123      34.427  35.871  51.562  1.00 20.74           N  
ATOM    909  CA  ALA A 123      33.003  35.715  51.777  1.00 20.02           C  
ATOM    910  C   ALA A 123      32.270  35.265  50.517  1.00 17.65           C  
ATOM    911  O   ALA A 123      32.718  35.523  49.411  1.00 19.33           O  
ATOM    912  CB  ALA A 123      32.422  37.017  52.289  1.00 22.52           C  
ATOM    913  N   LEU A 124      31.151  34.574  50.708  1.00 20.77           N  
ATOM    914  CA  LEU A 124      30.313  34.082  49.616  1.00 22.74           C  
ATOM    915  C   LEU A 124      28.931  34.673  49.788  1.00 23.26           C  
ATOM    916  O   LEU A 124      28.358  34.608  50.877  1.00 25.24           O  
ATOM    917  CB  LEU A 124      30.210  32.555  49.653  1.00 21.69           C  
ATOM    918  CG  LEU A 124      31.540  31.828  49.461  1.00 23.62           C  
ATOM    919  CD1 LEU A 124      31.367  30.342  49.748  1.00 25.09           C  
ATOM    920  CD2 LEU A 124      32.036  32.059  48.045  1.00 24.71           C  
ATOM    921  N   PHE A 125      28.410  35.260  48.716  1.00 22.82           N  
ATOM    922  CA  PHE A 125      27.081  35.852  48.727  1.00 23.81           C  
ATOM    923  C   PHE A 125      26.202  35.190  47.679  1.00 22.33           C  
ATOM    924  O   PHE A 125      26.675  34.762  46.628  1.00 21.55           O  
ATOM    925  CB  PHE A 125      27.107  37.339  48.359  1.00 25.09           C  
ATOM    926  CG  PHE A 125      27.842  38.207  49.327  1.00 26.94           C  
ATOM    927  CD1 PHE A 125      29.226  38.119  49.460  1.00 28.23           C  
ATOM    928  CD2 PHE A 125      27.150  39.153  50.076  1.00 27.51           C  
ATOM    929  CE1 PHE A 125      29.918  38.971  50.334  1.00 29.76           C  
ATOM    930  CE2 PHE A 125      27.827  40.016  50.956  1.00 29.03           C  
ATOM    931  CZ  PHE A 125      29.213  39.924  51.082  1.00 27.88           C  
ATOM    932  N   ARG A 126      24.914  35.129  47.969  1.00 24.86           N  
ATOM    933  CA  ARG A 126      23.947  34.614  47.018  1.00 25.14           C  
ATOM    934  C   ARG A 126      22.721  35.484  47.232  1.00 25.38           C  
ATOM    935  O   ARG A 126      22.126  35.468  48.301  1.00 27.25           O  
ATOM    936  CB  ARG A 126      23.617  33.148  47.287  1.00 25.57           C  
ATOM    937  CG  ARG A 126      22.512  32.642  46.374  1.00 27.67           C  
ATOM    938  CD  ARG A 126      22.500  31.125  46.280  1.00 30.56           C  
ATOM    939  NE  ARG A 126      23.545  30.629  45.386  1.00 31.14           N  
ATOM    940  CZ  ARG A 126      23.779  29.340  45.148  1.00 29.28           C  
ATOM    941  NH1 ARG A 126      23.043  28.406  45.742  1.00 26.48           N  
ATOM    942  NH2 ARG A 126      24.746  28.988  44.308  1.00 29.57           N  
ATOM    943  N   GLY A 127      22.356  36.270  46.227  1.00 27.84           N  
ATOM    944  CA  GLY A 127      21.197  37.125  46.385  1.00 28.68           C  
ATOM    945  C   GLY A 127      20.082  36.943  45.375  1.00 28.20           C  
ATOM    946  O   GLY A 127      20.309  36.475  44.263  1.00 28.66           O  
ATOM    947  N   LYS A 128      18.861  37.289  45.774  1.00 29.14           N  
ATOM    948  CA  LYS A 128      17.732  37.201  44.864  1.00 30.22           C  
ATOM    949  C   LYS A 128      17.496  38.636  44.415  1.00 31.10           C  
ATOM    950  O   LYS A 128      17.531  39.567  45.228  1.00 30.90           O  
ATOM    951  CB  LYS A 128      16.480  36.657  45.559  1.00 31.93           C  
ATOM    952  CG  LYS A 128      15.351  36.375  44.570  1.00 35.53           C  
ATOM    953  CD  LYS A 128      14.014  36.130  45.243  1.00 41.45           C  
ATOM    954  CE  LYS A 128      12.899  35.925  44.216  1.00 42.62           C  
ATOM    955  NZ  LYS A 128      11.552  35.874  44.883  1.00 46.18           N  
ATOM    956  N   SER A 129      17.273  38.816  43.120  1.00 30.89           N  
ATOM    957  CA  SER A 129      17.072  40.144  42.563  1.00 32.32           C  
ATOM    958  C   SER A 129      15.640  40.393  42.150  1.00 33.85           C  
ATOM    959  O   SER A 129      14.911  39.463  41.809  1.00 33.06           O  
ATOM    960  CB  SER A 129      17.985  40.342  41.352  1.00 29.61           C  
ATOM    961  OG  SER A 129      17.729  39.342  40.372  1.00 32.23           O  
ATOM    962  N   HIS A 130      15.260  41.665  42.184  1.00 37.78           N  
ATOM    963  CA  HIS A 130      13.919  42.110  41.820  1.00 42.60           C  
ATOM    964  C   HIS A 130      13.934  42.956  40.557  1.00 43.88           C  
ATOM    965  O   HIS A 130      14.630  43.965  40.497  1.00 40.95           O  
ATOM    966  CB  HIS A 130      13.329  42.962  42.939  1.00 46.88           C  
ATOM    967  CG  HIS A 130      12.135  42.362  43.593  1.00 51.34           C  
ATOM    968  ND1 HIS A 130      11.188  41.643  42.892  1.00 53.76           N  
ATOM    969  CD2 HIS A 130      11.708  42.399  44.876  1.00 53.47           C  
ATOM    970  CE1 HIS A 130      10.233  41.263  43.719  1.00 56.24           C  
ATOM    971  NE2 HIS A 130      10.523  41.709  44.931  1.00 55.83           N  
ATOM    972  N   ARG A 131      13.139  42.547  39.572  1.00 47.54           N  
ATOM    973  CA  ARG A 131      13.013  43.252  38.296  1.00 51.60           C  
ATOM    974  C   ARG A 131      14.211  42.995  37.390  1.00 53.76           C  
ATOM    975  O   ARG A 131      14.024  42.422  36.291  1.00 54.18           O  
ATOM    976  CB  ARG A 131      12.861  44.762  38.519  1.00 51.65           C  
ATOM    977  CG  ARG A 131      11.734  45.163  39.459  1.00 53.24           C  
ATOM    978  CD  ARG A 131      11.747  46.673  39.636  1.00 57.34           C  
ATOM    979  NE  ARG A 131      13.064  47.133  40.072  1.00 60.07           N  
ATOM    980  CZ  ARG A 131      13.480  48.395  40.025  1.00 61.31           C  
ATOM    981  NH1 ARG A 131      12.680  49.344  39.555  1.00 62.31           N  
ATOM    982  NH2 ARG A 131      14.699  48.711  40.453  1.00 61.65           N  
TER     983      ARG A 131                                                      
END
MOLECULE T0479.pdb
ATOM      1  N   THR     6      34.108  56.591  39.835  1.00 82.67           N  
ATOM      2  CA  THR     6      32.687  57.041  39.783  1.00 84.71           C  
ATOM      3  C   THR     6      31.847  56.242  38.792  1.00 84.83           C  
ATOM      4  O   THR     6      30.746  55.797  39.120  1.00 87.33           O  
ATOM      5  CB  THR     6      32.594  58.552  39.443  1.00 84.63           C  
ATOM      6  OG1 THR     6      32.669  59.310  40.659  1.00 80.59           O  
ATOM      7  CG2 THR     6      31.288  58.884  38.714  1.00 85.06           C  
ATOM      8  N   ASP     7      32.357  56.052  37.583  1.00 82.92           N  
ATOM      9  CA  ASP     7      31.608  55.292  36.597  1.00 82.53           C  
ATOM     10  C   ASP     7      31.505  53.876  37.126  1.00 82.43           C  
ATOM     11  O   ASP     7      32.507  53.164  37.202  1.00 83.40           O  
ATOM     12  CB  ASP     7      32.337  55.281  35.254  1.00 83.34           C  
ATOM     13  CG  ASP     7      31.398  55.058  34.080  1.00 83.13           C  
ATOM     14  OD1 ASP     7      31.411  55.902  33.161  1.00 90.62           O  
ATOM     15  OD2 ASP     7      30.652  54.052  34.068  1.00 82.94           O  
ATOM     16  N   PHE     8      30.302  53.477  37.524  1.00 81.00           N  
ATOM     17  CA  PHE     8      30.095  52.129  38.022  1.00 78.25           C  
ATOM     18  C   PHE     8      29.206  51.420  37.035  1.00 78.12           C  
ATOM     19  O   PHE     8      27.993  51.364  37.192  1.00 78.37           O  
ATOM     20  CB  PHE     8      29.455  52.141  39.411  1.00 77.96           C  
ATOM     21  CG  PHE     8      30.418  52.466  40.517  1.00 75.33           C  
ATOM     22  CD1 PHE     8      30.264  53.616  41.272  1.00 73.58           C  
ATOM     23  CD2 PHE     8      31.496  51.628  40.791  1.00 69.75           C  
ATOM     24  CE1 PHE     8      31.172  53.932  42.287  1.00 72.35           C  
ATOM     25  CE2 PHE     8      32.404  51.929  41.799  1.00 67.03           C  
ATOM     26  CZ  PHE     8      32.243  53.085  42.549  1.00 69.31           C  
ATOM     27  N   PHE     9      29.835  50.909  35.989  1.00 79.06           N  
ATOM     28  CA  PHE     9      29.150  50.169  34.948  1.00 79.09           C  
ATOM     29  C   PHE     9      27.978  50.911  34.325  1.00 79.86           C  
ATOM     30  O   PHE     9      26.979  50.298  33.945  1.00 80.70           O  
ATOM     31  CB  PHE     9      28.690  48.836  35.517  1.00 79.01           C  
ATOM     32  CG  PHE     9      29.776  48.084  36.228  1.00 77.86           C  
ATOM     33  CD1 PHE     9      30.883  47.602  35.536  1.00 80.20           C  
ATOM     34  CD2 PHE     9      29.691  47.850  37.594  1.00 75.84           C  
ATOM     35  CE1 PHE     9      31.889  46.890  36.201  1.00 77.51           C  
ATOM     36  CE2 PHE     9      30.689  47.142  38.263  1.00 74.21           C  
ATOM     37  CZ  PHE     9      31.788  46.661  37.567  1.00 74.96           C  
ATOM     38  N   GLY    10      28.102  52.230  34.216  1.00 81.37           N  
ATOM     39  CA  GLY    10      27.041  53.016  33.610  1.00 81.99           C  
ATOM     40  C   GLY    10      26.223  53.898  34.534  1.00 82.45           C  
ATOM     41  O   GLY    10      25.148  54.363  34.148  1.00 83.24           O  
ATOM     42  N   LEU    11      26.724  54.138  35.742  1.00 81.84           N  
ATOM     43  CA  LEU    11      26.015  54.971  36.704  1.00 80.93           C  
ATOM     44  C   LEU    11      26.885  55.422  37.864  1.00 81.11           C  
ATOM     45  O   LEU    11      27.854  54.752  38.224  1.00 81.55           O  
ATOM     46  CB  LEU    11      24.792  54.226  37.245  1.00 82.16           C  
ATOM     47  CG  LEU    11      24.869  52.706  37.388  1.00 80.12           C  
ATOM     48  CD1 LEU    11      24.789  52.279  38.854  1.00 80.11           C  
ATOM     49  CD2 LEU    11      23.717  52.108  36.594  1.00 78.58           C  
ATOM     50  N   THR    12      26.541  56.567  38.444  1.00 81.94           N  
ATOM     51  CA  THR    12      27.287  57.083  39.583  1.00 81.54           C  
ATOM     52  C   THR    12      26.555  56.700  40.869  1.00 80.32           C  
ATOM     53  O   THR    12      25.343  56.884  40.994  1.00 80.81           O  
ATOM     54  CB  THR    12      27.491  58.640  39.490  1.00 82.25           C  
ATOM     55  OG1 THR    12      27.647  59.186  40.808  1.00 81.93           O  
ATOM     56  CG2 THR    12      26.328  59.308  38.779  1.00 80.77           C  
ATOM     57  N   ILE    13      27.311  56.133  41.803  1.00 78.25           N  
ATOM     58  CA  ILE    13      26.793  55.681  43.085  1.00 73.63           C  
ATOM     59  C   ILE    13      27.597  56.362  44.187  1.00 72.82           C  
ATOM     60  O   ILE    13      28.654  55.878  44.583  1.00 73.86           O  
ATOM     61  CB  ILE    13      26.945  54.157  43.209  1.00 72.50           C  
ATOM     62  CG1 ILE    13      26.386  53.476  41.959  1.00 70.72           C  
ATOM     63  CG2 ILE    13      26.218  53.660  44.444  1.00 69.64           C  
ATOM     64  CD1 ILE    13      26.615  51.973  41.912  1.00 66.94           C  
ATOM     65  N   PRO    14      27.097  57.496  44.701  1.00 71.54           N  
ATOM     66  CA  PRO    14      27.744  58.277  45.759  1.00 70.83           C  
ATOM     67  C   PRO    14      28.279  57.487  46.948  1.00 70.92           C  
ATOM     68  O   PRO    14      29.261  57.894  47.573  1.00 72.37           O  
ATOM     69  CB  PRO    14      26.659  59.259  46.170  1.00 70.62           C  
ATOM     70  CG  PRO    14      25.953  59.505  44.881  1.00 70.49           C  
ATOM     71  CD  PRO    14      25.818  58.114  44.315  1.00 70.58           C  
ATOM     72  N   PHE    15      27.644  56.369  47.277  1.00 70.30           N  
ATOM     73  CA  PHE    15      28.112  55.580  48.413  1.00 68.63           C  
ATOM     74  C   PHE    15      29.290  54.712  47.992  1.00 69.27           C  
ATOM     75  O   PHE    15      30.270  54.582  48.727  1.00 68.96           O  
ATOM     76  CB  PHE    15      26.985  54.703  48.979  1.00 66.76           C  
ATOM     77  CG  PHE    15      27.407  53.863  50.158  1.00 62.75           C  
ATOM     78  CD1 PHE    15      27.964  54.455  51.288  1.00 65.47           C  
ATOM     79  CD2 PHE    15      27.258  52.480  50.135  1.00 60.04           C  
ATOM     80  CE1 PHE    15      28.366  53.683  52.381  1.00 63.65           C  
ATOM     81  CE2 PHE    15      27.656  51.697  51.219  1.00 59.43           C  
ATOM     82  CZ  PHE    15      28.212  52.301  52.347  1.00 57.78           C  
ATOM     83  N   MET    16      29.191  54.120  46.806  1.00 68.50           N  
ATOM     84  CA  MET    16      30.266  53.276  46.314  1.00 69.92           C  
ATOM     85  C   MET    16      31.532  54.105  46.109  1.00 70.28           C  
ATOM     86  O   MET    16      32.628  53.687  46.484  1.00 69.63           O  
ATOM     87  CB  MET    16      29.843  52.593  45.012  1.00 68.25           C  
ATOM     88  CG  MET    16      28.836  51.462  45.210  1.00 71.30           C  
ATOM     89  SD  MET    16      29.518  49.996  46.318  1.00 82.26          SE  
ATOM     90  CE  MET    16      28.397  50.232  47.881  1.00 81.23           C  
ATOM     91  N   GLN    17      31.367  55.287  45.525  1.00 71.35           N  
ATOM     92  CA  GLN    17      32.486  56.187  45.280  1.00 73.14           C  
ATOM     93  C   GLN    17      33.152  56.495  46.615  1.00 72.71           C  
ATOM     94  O   GLN    17      34.353  56.744  46.677  1.00 72.94           O  
ATOM     95  CB  GLN    17      31.983  57.490  44.639  1.00 74.17           C  
ATOM     96  CG  GLN    17      33.075  58.494  44.271  1.00 78.87           C  
ATOM     97  CD  GLN    17      32.597  59.942  44.333  1.00 85.45           C  
ATOM     98  OE1 GLN    17      31.612  60.318  43.696  1.00 90.09           O  
ATOM     99  NE2 GLN    17      33.302  60.762  45.105  1.00 86.55           N  
ATOM    100  N   LEU    18      32.356  56.466  47.683  1.00 72.85           N  
ATOM    101  CA  LEU    18      32.837  56.759  49.032  1.00 71.27           C  
ATOM    102  C   LEU    18      33.668  55.626  49.622  1.00 71.30           C  
ATOM    103  O   LEU    18      34.567  55.862  50.431  1.00 70.93           O  
ATOM    104  CB  LEU    18      31.647  57.058  49.950  1.00 70.66           C  
ATOM    105  CG  LEU    18      31.844  57.860  51.244  1.00 69.80           C  
ATOM    106  CD1 LEU    18      31.930  56.948  52.446  1.00 73.18           C  
ATOM    107  CD2 LEU    18      33.078  58.730  51.117  1.00 67.63           C  
ATOM    108  N   LEU    19      33.362  54.396  49.214  1.00 71.25           N  
ATOM    109  CA  LEU    19      34.081  53.224  49.701  1.00 71.47           C  
ATOM    110  C   LEU    19      35.415  53.043  48.998  1.00 73.05           C  
ATOM    111  O   LEU    19      36.224  52.201  49.390  1.00 73.88           O  
ATOM    112  CB  LEU    19      33.246  51.963  49.496  1.00 70.20           C  
ATOM    113  CG  LEU    19      32.009  51.732  50.363  1.00 69.28           C  
ATOM    114  CD1 LEU    19      31.332  50.437  49.937  1.00 64.95           C  
ATOM    115  CD2 LEU    19      32.405  51.662  51.830  1.00 66.56           C  
ATOM    116  N   GLY    20      35.643  53.827  47.951  1.00 74.73           N  
ATOM    117  CA  GLY    20      36.885  53.704  47.211  1.00 75.28           C  
ATOM    118  C   GLY    20      36.969  52.336  46.555  1.00 76.69           C  
ATOM    119  O   GLY    20      37.965  51.628  46.709  1.00 76.35           O  
ATOM    120  N   VAL    21      35.913  51.954  45.839  1.00 75.90           N  
ATOM    121  CA  VAL    21      35.890  50.665  45.161  1.00 74.91           C  
ATOM    122  C   VAL    21      36.060  50.871  43.656  1.00 74.23           C  
ATOM    123  O   VAL    21      35.609  51.876  43.102  1.00 74.26           O  
ATOM    124  CB  VAL    21      34.569  49.882  45.455  1.00 75.48           C  
ATOM    125  CG1 VAL    21      33.353  50.705  45.059  1.00 75.56           C  
ATOM    126  CG2 VAL    21      34.576  48.554  44.708  1.00 75.52           C  
ATOM    127  N   VAL    22      36.712  49.920  42.997  1.00 73.26           N  
ATOM    128  CA  VAL    22      36.955  50.026  41.563  1.00 71.22           C  
ATOM    129  C   VAL    22      36.297  48.933  40.714  1.00 69.51           C  
ATOM    130  O   VAL    22      36.493  47.745  40.956  1.00 69.28           O  
ATOM    131  CB  VAL    22      38.481  50.019  41.277  1.00 71.44           C  
ATOM    132  CG1 VAL    22      38.734  50.139  39.788  1.00 72.67           C  
ATOM    133  CG2 VAL    22      39.153  51.152  42.024  1.00 68.35           C  
ATOM    134  N   PRO    23      35.488  49.332  39.713  1.00 68.68           N  
ATOM    135  CA  PRO    23      34.795  48.412  38.803  1.00 69.35           C  
ATOM    136  C   PRO    23      35.821  47.787  37.856  1.00 70.07           C  
ATOM    137  O   PRO    23      36.584  48.493  37.208  1.00 70.33           O  
ATOM    138  CB  PRO    23      33.787  49.320  38.085  1.00 68.77           C  
ATOM    139  CG  PRO    23      34.445  50.640  38.103  1.00 69.37           C  
ATOM    140  CD  PRO    23      35.035  50.715  39.491  1.00 68.21           C  
ATOM    141  N   GLU    24      35.827  46.463  37.774  1.00 71.08           N  
ATOM    142  CA  GLU    24      36.811  45.762  36.956  1.00 71.52           C  
ATOM    143  C   GLU    24      36.266  45.026  35.724  1.00 71.28           C  
ATOM    144  O   GLU    24      37.016  44.737  34.787  1.00 72.41           O  
ATOM    145  CB  GLU    24      37.571  44.789  37.863  1.00 71.19           C  
ATOM    146  CG  GLU    24      39.055  44.645  37.574  1.00 74.13           C  
ATOM    147  CD  GLU    24      39.917  44.750  38.828  1.00 77.25           C  
ATOM    148  OE1 GLU    24      40.224  45.885  39.255  1.00 83.15           O  
ATOM    149  OE2 GLU    24      40.295  43.699  39.387  1.00 77.85           O  
ATOM    150  N   HIS    25      34.967  44.735  35.719  1.00 70.76           N  
ATOM    151  CA  HIS    25      34.342  44.017  34.613  1.00 68.54           C  
ATOM    152  C   HIS    25      32.855  43.809  34.849  1.00 68.40           C  
ATOM    153  O   HIS    25      32.388  43.788  35.984  1.00 69.03           O  
ATOM    154  CB  HIS    25      35.002  42.646  34.430  1.00 67.13           C  
ATOM    155  CG  HIS    25      34.233  41.710  33.551  1.00 66.67           C  
ATOM    156  ND1 HIS    25      34.002  40.394  33.883  1.00 64.69           N  
ATOM    157  CD2 HIS    25      33.623  41.902  32.352  1.00 67.64           C  
ATOM    158  CE1 HIS    25      33.284  39.814  32.935  1.00 66.58           C  
ATOM    159  NE2 HIS    25      33.043  40.713  31.996  1.00 67.15           N  
ATOM    160  N   SER    26      32.122  43.645  33.755  1.00 68.39           N  
ATOM    161  CA  SER    26      30.692  43.402  33.785  1.00 67.02           C  
ATOM    162  C   SER    26      30.240  43.026  32.388  1.00 66.04           C  
ATOM    163  O   SER    26      30.387  43.804  31.449  1.00 68.32           O  
ATOM    164  CB  SER    26      29.936  44.647  34.243  1.00 68.40           C  
ATOM    165  OG  SER    26      28.563  44.537  33.896  1.00 69.94           O  
ATOM    166  N   GLY    27      29.690  41.828  32.252  1.00 63.41           N  
ATOM    167  CA  GLY    27      29.224  41.394  30.954  1.00 59.63           C  
ATOM    168  C   GLY    27      29.182  39.889  30.902  1.00 57.60           C  
ATOM    169  O   GLY    27      29.900  39.221  31.635  1.00 59.65           O  
ATOM    170  N   ASN    28      28.337  39.354  30.032  1.00 58.55           N  
ATOM    171  CA  ASN    28      28.200  37.912  29.878  1.00 59.88           C  
ATOM    172  C   ASN    28      27.865  37.168  31.165  1.00 60.45           C  
ATOM    173  O   ASN    28      28.385  36.085  31.409  1.00 58.08           O  
ATOM    174  CB  ASN    28      29.481  37.352  29.275  1.00 61.54           C  
ATOM    175  CG  ASN    28      29.808  37.982  27.943  1.00 59.96           C  
ATOM    176  OD1 ASN    28      29.020  37.900  27.004  1.00 57.88           O  
ATOM    177  ND2 ASN    28      30.971  38.636  27.858  1.00 52.70           N  
ATOM    178  N   GLY    29      27.005  37.764  31.984  1.00 58.42           N  
ATOM    179  CA  GLY    29      26.598  37.118  33.217  1.00 59.39           C  
ATOM    180  C   GLY    29      27.591  37.028  34.362  1.00 58.49           C  
ATOM    181  O   GLY    29      27.400  36.212  35.263  1.00 58.96           O  
ATOM    182  N   THR    30      28.647  37.836  34.339  1.00 55.83           N  
ATOM    183  CA  THR    30      29.626  37.818  35.419  1.00 55.20           C  
ATOM    184  C   THR    30      30.039  39.253  35.687  1.00 54.78           C  
ATOM    185  O   THR    30      29.687  40.152  34.930  1.00 56.63           O  
ATOM    186  CB  THR    30      30.904  37.026  35.054  1.00 55.53           C  
ATOM    187  OG1 THR    30      31.572  37.684  33.977  1.00 59.89           O  
ATOM    188  CG2 THR    30      30.580  35.605  34.655  1.00 55.82           C  
ATOM    189  N   ALA    31      30.784  39.474  36.764  1.00 51.78           N  
ATOM    190  CA  ALA    31      31.237  40.818  37.076  1.00 52.61           C  
ATOM    191  C   ALA    31      32.450  40.790  38.010  1.00 53.18           C  
ATOM    192  O   ALA    31      32.691  39.810  38.709  1.00 52.70           O  
ATOM    193  CB  ALA    31      30.097  41.623  37.693  1.00 51.77           C  
ATOM    194  N   ARG    32      33.225  41.869  38.002  1.00 53.91           N  
ATOM    195  CA  ARG    32      34.407  41.932  38.849  1.00 55.41           C  
ATOM    196  C   ARG    32      34.550  43.326  39.411  1.00 54.45           C  
ATOM    197  O   ARG    32      34.304  44.324  38.727  1.00 51.64           O  
ATOM    198  CB  ARG    32      35.682  41.577  38.061  1.00 56.29           C  
ATOM    199  CG  ARG    32      36.710  40.769  38.870  1.00 60.83           C  
ATOM    200  CD  ARG    32      38.165  41.219  38.659  1.00 68.82           C  
ATOM    201  NE  ARG    32      38.433  41.696  37.302  1.00 67.14           N  
ATOM    202  CZ  ARG    32      38.391  40.946  36.205  1.00 66.56           C  
ATOM    203  NH1 ARG    32      38.096  39.654  36.281  1.00 67.50           N  
ATOM    204  NH2 ARG    32      38.623  41.502  35.025  1.00 69.78           N  
ATOM    205  N   THR    33      34.960  43.386  40.667  1.00 54.04           N  
ATOM    206  CA  THR    33      35.150  44.655  41.328  1.00 54.88           C  
ATOM    207  C   THR    33      36.340  44.494  42.275  1.00 55.51           C  
ATOM    208  O   THR    33      36.741  43.371  42.579  1.00 52.87           O  
ATOM    209  CB  THR    33      33.852  45.066  42.075  1.00 55.35           C  
ATOM    210  OG1 THR    33      33.558  46.442  41.790  1.00 60.23           O  
ATOM    211  CG2 THR    33      33.996  44.881  43.573  1.00 52.69           C  
ATOM    212  N   ARG    34      36.904  45.603  42.744  1.00 58.33           N  
ATOM    213  CA  ARG    34      38.070  45.520  43.620  1.00 61.57           C  
ATOM    214  C   ARG    34      38.011  46.499  44.783  1.00 61.13           C  
ATOM    215  O   ARG    34      37.666  47.668  44.602  1.00 62.13           O  
ATOM    216  CB  ARG    34      39.332  45.759  42.779  1.00 63.11           C  
ATOM    217  CG  ARG    34      40.654  45.547  43.495  1.00 67.81           C  
ATOM    218  CD  ARG    34      41.235  46.851  44.018  1.00 80.63           C  
ATOM    219  NE  ARG    34      42.681  46.919  43.799  1.00 88.82           N  
ATOM    220  CZ  ARG    34      43.252  46.975  42.600  1.00 92.25           C  
ATOM    221  NH1 ARG    34      42.495  46.976  41.508  1.00 90.51           N  
ATOM    222  NH2 ARG    34      44.577  47.025  42.491  1.00 94.91           N  
ATOM    223  N   LEU    35      38.362  46.027  45.976  1.00 60.79           N  
ATOM    224  CA  LEU    35      38.335  46.890  47.153  1.00 61.51           C  
ATOM    225  C   LEU    35      39.714  47.210  47.733  1.00 62.84           C  
ATOM    226  O   LEU    35      40.231  46.501  48.599  1.00 62.23           O  
ATOM    227  CB  LEU    35      37.448  46.280  48.255  1.00 59.96           C  
ATOM    228  CG  LEU    35      37.249  47.164  49.495  1.00 60.64           C  
ATOM    229  CD1 LEU    35      36.531  48.452  49.101  1.00 59.80           C  
ATOM    230  CD2 LEU    35      36.457  46.414  50.561  1.00 58.70           C  
ATOM    231  N   PRO    36      40.331  48.295  47.251  1.00 65.05           N  
ATOM    232  CA  PRO    36      41.650  48.673  47.763  1.00 67.72           C  
ATOM    233  C   PRO    36      41.585  48.959  49.265  1.00 70.63           C  
ATOM    234  O   PRO    36      40.669  49.627  49.738  1.00 71.74           O  
ATOM    235  CB  PRO    36      42.014  49.907  46.923  1.00 67.73           C  
ATOM    236  CG  PRO    36      40.688  50.407  46.404  1.00 66.37           C  
ATOM    237  CD  PRO    36      39.927  49.153  46.126  1.00 64.71           C  
ATOM    238  N   ALA    37      42.554  48.433  50.005  1.00 72.73           N  
ATOM    239  CA  ALA    37      42.600  48.610  51.448  1.00 74.97           C  
ATOM    240  C   ALA    37      42.575  50.073  51.880  1.00 78.06           C  
ATOM    241  O   ALA    37      43.148  50.945  51.224  1.00 79.38           O  
ATOM    242  CB  ALA    37      43.831  47.931  52.011  1.00 75.09           C  
ATOM    243  N   ARG    38      41.900  50.325  52.996  1.00 79.16           N  
ATOM    244  CA  ARG    38      41.790  51.660  53.563  1.00 78.26           C  
ATOM    245  C   ARG    38      41.540  51.448  55.042  1.00 77.89           C  
ATOM    246  O   ARG    38      41.137  50.362  55.451  1.00 78.49           O  
ATOM    247  CB  ARG    38      40.625  52.421  52.930  1.00 77.89           C  
ATOM    248  CG  ARG    38      40.756  53.926  53.029  1.00 79.53           C  
ATOM    249  CD  ARG    38      40.565  54.586  51.666  1.00 82.14           C  
ATOM    250  NE  ARG    38      39.190  54.513  51.173  1.00 81.39           N  
ATOM    251  CZ  ARG    38      38.162  55.157  51.718  1.00 84.11           C  
ATOM    252  NH1 ARG    38      38.346  55.925  52.782  1.00 89.00           N  
ATOM    253  NH2 ARG    38      36.949  55.048  51.192  1.00 82.94           N  
ATOM    254  N   ALA    39      41.789  52.471  55.843  1.00 78.61           N  
ATOM    255  CA  ALA    39      41.587  52.371  57.281  1.00 78.25           C  
ATOM    256  C   ALA    39      40.191  52.864  57.650  1.00 77.22           C  
ATOM    257  O   ALA    39      39.693  52.599  58.737  1.00 76.90           O  
ATOM    258  CB  ALA    39      42.655  53.188  58.002  1.00 79.37           C  
ATOM    259  N   ASP    40      39.573  53.583  56.716  1.00 77.54           N  
ATOM    260  CA  ASP    40      38.217  54.117  56.874  1.00 77.22           C  
ATOM    261  C   ASP    40      37.272  52.931  56.852  1.00 76.30           C  
ATOM    262  O   ASP    40      36.191  52.953  57.435  1.00 76.53           O  
ATOM    263  CB  ASP    40      37.834  54.985  55.677  1.00 77.80           C  
ATOM    264  CG  ASP    40      38.088  56.456  55.898  1.00 85.99           C  
ATOM    265  OD1 ASP    40      39.237  56.832  56.212  1.00 98.38           O  
ATOM    266  OD2 ASP    40      37.132  57.245  55.730  1.00 90.77           O  
ATOM    267  N   LEU    41      37.705  51.895  56.151  1.00 75.06           N  
ATOM    268  CA  LEU    41      36.892  50.708  55.945  1.00 72.63           C  
ATOM    269  C   LEU    41      37.057  49.515  56.884  1.00 71.44           C  
ATOM    270  O   LEU    41      36.544  48.441  56.592  1.00 70.58           O  
ATOM    271  CB  LEU    41      37.106  50.251  54.505  1.00 71.79           C  
ATOM    272  CG  LEU    41      37.033  51.397  53.492  1.00 68.81           C  
ATOM    273  CD1 LEU    41      37.246  50.882  52.077  1.00 64.95           C  
ATOM    274  CD2 LEU    41      35.679  52.077  53.620  1.00 69.58           C  
ATOM    275  N   VAL    42      37.726  49.703  58.018  1.00 71.99           N  
ATOM    276  CA  VAL    42      37.962  48.591  58.931  1.00 72.06           C  
ATOM    277  C   VAL    42      37.052  48.400  60.152  1.00 73.10           C  
ATOM    278  O   VAL    42      36.355  49.307  60.612  1.00 73.13           O  
ATOM    279  CB  VAL    42      39.415  48.608  59.414  1.00 72.55           C  
ATOM    280  CG1 VAL    42      40.361  48.501  58.217  1.00 71.29           C  
ATOM    281  CG2 VAL    42      39.678  49.895  60.186  1.00 74.55           C  
ATOM    282  N   ASN    43      37.100  47.174  60.660  1.00 73.75           N  
ATOM    283  CA  ASN    43      36.350  46.720  61.813  1.00 73.70           C  
ATOM    284  C   ASN    43      37.045  47.260  63.050  1.00 75.36           C  
ATOM    285  O   ASN    43      37.844  48.190  62.959  1.00 75.86           O  
ATOM    286  CB  ASN    43      36.381  45.198  61.840  1.00 73.88           C  
ATOM    287  CG  ASN    43      35.532  44.622  62.932  1.00 76.44           C  
ATOM    288  OD1 ASN    43      35.791  43.522  63.420  1.00 79.26           O  
ATOM    289  ND2 ASN    43      34.499  45.351  63.318  1.00 79.28           N  
ATOM    290  N   SER    44      36.739  46.673  64.203  1.00 76.37           N  
ATOM    291  CA  SER    44      37.373  47.063  65.452  1.00 76.63           C  
ATOM    292  C   SER    44      38.514  46.077  65.656  1.00 77.43           C  
ATOM    293  O   SER    44      39.480  46.368  66.354  1.00 77.64           O  
ATOM    294  CB  SER    44      36.383  46.991  66.626  1.00 76.83           C  
ATOM    295  OG  SER    44      35.894  45.674  66.832  1.00 76.34           O  
ATOM    296  N   ARG    45      38.392  44.904  65.036  1.00 77.30           N  
ATOM    297  CA  ARG    45      39.433  43.875  65.118  1.00 76.19           C  
ATOM    298  C   ARG    45      40.462  44.192  64.038  1.00 73.76           C  
ATOM    299  O   ARG    45      41.314  43.367  63.710  1.00 75.30           O  
ATOM    300  CB  ARG    45      38.855  42.474  64.863  1.00 77.62           C  
ATOM    301  CG  ARG    45      37.828  41.992  65.884  1.00 82.48           C  
ATOM    302  CD  ARG    45      38.476  41.651  67.218  1.00 89.78           C  
ATOM    303  NE  ARG    45      39.206  40.385  67.175  1.00 94.62           N  
ATOM    304  CZ  ARG    45      40.475  40.232  67.546  1.00 94.99           C  
ATOM    305  NH1 ARG    45      41.173  41.271  67.991  1.00 94.14           N  
ATOM    306  NH2 ARG    45      41.045  39.035  67.474  1.00 94.64           N  
ATOM    307  N   GLY    46      40.366  45.394  63.480  1.00 71.52           N  
ATOM    308  CA  GLY    46      41.294  45.803  62.441  1.00 69.47           C  
ATOM    309  C   GLY    46      40.961  45.261  61.065  1.00 69.13           C  
ATOM    310  O   GLY    46      41.449  45.783  60.068  1.00 70.07           O  
ATOM    311  N   ASP    47      40.134  44.215  61.018  1.00 68.65           N  
ATOM    312  CA  ASP    47      39.722  43.582  59.760  1.00 66.23           C  
ATOM    313  C   ASP    47      38.785  44.479  58.971  1.00 65.33           C  
ATOM    314  O   ASP    47      38.190  45.397  59.522  1.00 66.99           O  
ATOM    315  CB  ASP    47      38.988  42.269  60.021  1.00 65.80           C  
ATOM    316  CG  ASP    47      39.787  41.304  60.856  1.00 65.95           C  
ATOM    317  OD1 ASP    47      41.015  41.207  60.634  1.00 62.58           O  
ATOM    318  OD2 ASP    47      39.174  40.625  61.720  1.00 64.21           O  
ATOM    319  N   ILE    48      38.643  44.207  57.679  1.00 63.90           N  
ATOM    320  CA  ILE    48      37.734  44.994  56.859  1.00 63.50           C  
ATOM    321  C   ILE    48      36.328  44.661  57.367  1.00 62.00           C  
ATOM    322  O   ILE    48      35.976  43.489  57.484  1.00 61.57           O  
ATOM    323  CB  ILE    48      37.863  44.625  55.362  1.00 63.31           C  
ATOM    324  CG1 ILE    48      39.299  44.867  54.879  1.00 65.41           C  
ATOM    325  CG2 ILE    48      36.910  45.476  54.528  1.00 61.38           C  
ATOM    326  CD1 ILE    48      39.634  46.327  54.571  1.00 65.73           C  
ATOM    327  N   HIS    49      35.538  45.690  57.683  1.00 60.23           N  
ATOM    328  CA  HIS    49      34.170  45.510  58.203  1.00 57.44           C  
ATOM    329  C   HIS    49      33.256  44.751  57.240  1.00 54.86           C  
ATOM    330  O   HIS    49      33.157  45.102  56.068  1.00 54.28           O  
ATOM    331  CB  HIS    49      33.552  46.876  58.544  1.00 56.59           C  
ATOM    332  CG  HIS    49      32.349  46.792  59.433  1.00 56.51           C  
ATOM    333  ND1 HIS    49      31.101  46.436  58.975  1.00 58.06           N  
ATOM    334  CD2 HIS    49      32.216  46.972  60.772  1.00 61.56           C  
ATOM    335  CE1 HIS    49      30.251  46.396  59.986  1.00 60.97           C  
ATOM    336  NE2 HIS    49      30.905  46.718  61.088  1.00 65.28           N  
ATOM    337  N   GLY    50      32.595  43.716  57.755  1.00 54.28           N  
ATOM    338  CA  GLY    50      31.695  42.898  56.953  1.00 55.82           C  
ATOM    339  C   GLY    50      30.656  43.682  56.173  1.00 54.65           C  
ATOM    340  O   GLY    50      30.128  43.208  55.164  1.00 55.18           O  
ATOM    341  N   GLY    51      30.357  44.883  56.655  1.00 54.63           N  
ATOM    342  CA  GLY    51      29.398  45.719  55.981  1.00 55.34           C  
ATOM    343  C   GLY    51      30.061  46.240  54.732  1.00 57.54           C  
ATOM    344  O   GLY    51      29.413  46.409  53.698  1.00 58.76           O  
ATOM    345  N   THR    52      31.360  46.505  54.826  1.00 56.93           N  
ATOM    346  CA  THR    52      32.106  46.994  53.672  1.00 57.73           C  
ATOM    347  C   THR    52      32.002  45.906  52.619  1.00 55.49           C  
ATOM    348  O   THR    52      31.862  46.185  51.438  1.00 57.15           O  
ATOM    349  CB  THR    52      33.609  47.206  53.980  1.00 59.07           C  
ATOM    350  OG1 THR    52      33.767  47.832  55.261  1.00 64.70           O  
ATOM    351  CG2 THR    52      34.239  48.102  52.924  1.00 58.87           C  
ATOM    352  N   LEU    53      32.051  44.658  53.070  1.00 54.28           N  
ATOM    353  CA  LEU    53      31.973  43.510  52.177  1.00 54.38           C  
ATOM    354  C   LEU    53      30.628  43.370  51.465  1.00 55.08           C  
ATOM    355  O   LEU    53      30.581  43.246  50.238  1.00 56.03           O  
ATOM    356  CB  LEU    53      32.288  42.239  52.961  1.00 54.43           C  
ATOM    357  CG  LEU    53      33.572  42.304  53.795  1.00 52.99           C  
ATOM    358  CD1 LEU    53      33.880  40.929  54.383  1.00 55.86           C  
ATOM    359  CD2 LEU    53      34.726  42.774  52.925  1.00 55.19           C  
ATOM    360  N   MET    54      29.541  43.384  52.236  1.00 54.80           N  
ATOM    361  CA  MET    54      28.196  43.260  51.675  1.00 52.43           C  
ATOM    362  C   MET    54      27.894  44.435  50.724  1.00 52.03           C  
ATOM    363  O   MET    54      27.197  44.277  49.717  1.00 48.73           O  
ATOM    364  CB  MET    54      27.156  43.206  52.810  1.00 52.54           C  
ATOM    365  CG  MET    54      27.322  42.027  53.796  1.00 57.30           C  
ATOM    366  SD  MET    54      26.081  42.067  55.318  1.00 62.48          SE  
ATOM    367  CE  MET    54      25.966  40.226  55.821  1.00 55.10           C  
ATOM    368  N   SER    55      28.438  45.609  51.036  1.00 53.67           N  
ATOM    369  CA  SER    55      28.202  46.791  50.202  1.00 55.48           C  
ATOM    370  C   SER    55      28.807  46.581  48.826  1.00 56.00           C  
ATOM    371  O   SER    55      28.170  46.835  47.805  1.00 52.23           O  
ATOM    372  CB  SER    55      28.831  48.041  50.829  1.00 53.38           C  
ATOM    373  OG  SER    55      28.419  48.209  52.174  1.00 55.87           O  
ATOM    374  N   VAL    56      30.047  46.109  48.807  1.00 57.92           N  
ATOM    375  CA  VAL    56      30.719  45.889  47.547  1.00 57.30           C  
ATOM    376  C   VAL    56      30.127  44.653  46.873  1.00 57.04           C  
ATOM    377  O   VAL    56      30.051  44.578  45.648  1.00 58.85           O  
ATOM    378  CB  VAL    56      32.257  45.762  47.761  1.00 57.64           C  
ATOM    379  CG1 VAL    56      32.630  44.379  48.254  1.00 55.71           C  
ATOM    380  CG2 VAL    56      32.981  46.111  46.492  1.00 58.95           C  
ATOM    381  N   LEU    57      29.675  43.694  47.676  1.00 57.70           N  
ATOM    382  CA  LEU    57      29.079  42.484  47.127  1.00 57.43           C  
ATOM    383  C   LEU    57      27.716  42.797  46.524  1.00 58.80           C  
ATOM    384  O   LEU    57      27.326  42.216  45.516  1.00 60.67           O  
ATOM    385  CB  LEU    57      28.945  41.418  48.217  1.00 57.54           C  
ATOM    386  CG  LEU    57      30.007  40.319  48.211  1.00 55.85           C  
ATOM    387  CD1 LEU    57      29.865  39.434  49.442  1.00 48.35           C  
ATOM    388  CD2 LEU    57      29.846  39.493  46.940  1.00 48.05           C  
ATOM    389  N   ASP    58      26.994  43.728  47.139  1.00 58.06           N  
ATOM    390  CA  ASP    58      25.681  44.110  46.639  1.00 59.20           C  
ATOM    391  C   ASP    58      25.877  44.738  45.273  1.00 57.88           C  
ATOM    392  O   ASP    58      25.250  44.358  44.288  1.00 58.06           O  
ATOM    393  CB  ASP    58      25.027  45.123  47.585  1.00 60.09           C  
ATOM    394  CG  ASP    58      23.591  45.424  47.210  1.00 60.92           C  
ATOM    395  OD1 ASP    58      23.009  44.637  46.434  1.00 64.05           O  
ATOM    396  OD2 ASP    58      23.040  46.430  47.701  1.00 63.82           O  
ATOM    397  N   PHE    59      26.770  45.715  45.241  1.00 59.00           N  
ATOM    398  CA  PHE    59      27.117  46.424  44.024  1.00 59.42           C  
ATOM    399  C   PHE    59      27.459  45.465  42.876  1.00 58.46           C  
ATOM    400  O   PHE    59      26.895  45.545  41.786  1.00 59.38           O  
ATOM    401  CB  PHE    59      28.309  47.339  44.319  1.00 60.78           C  
ATOM    402  CG  PHE    59      28.934  47.934  43.095  1.00 69.86           C  
ATOM    403  CD1 PHE    59      28.140  48.503  42.108  1.00 72.66           C  
ATOM    404  CD2 PHE    59      30.314  47.908  42.921  1.00 75.70           C  
ATOM    405  CE1 PHE    59      28.704  49.034  40.960  1.00 84.13           C  
ATOM    406  CE2 PHE    59      30.892  48.439  41.777  1.00 85.16           C  
ATOM    407  CZ  PHE    59      30.082  49.004  40.791  1.00 89.23           C  
ATOM    408  N   THR    60      28.375  44.543  43.147  1.00 57.19           N  
ATOM    409  CA  THR    60      28.852  43.592  42.152  1.00 55.36           C  
ATOM    410  C   THR    60      27.902  42.472  41.730  1.00 55.78           C  
ATOM    411  O   THR    60      28.014  41.949  40.625  1.00 56.93           O  
ATOM    412  CB  THR    60      30.174  42.972  42.627  1.00 54.97           C  
ATOM    413  OG1 THR    60      31.009  44.011  43.157  1.00 51.98           O  
ATOM    414  CG2 THR    60      30.902  42.282  41.454  1.00 50.54           C  
ATOM    415  N   LEU    61      26.978  42.091  42.601  1.00 54.16           N  
ATOM    416  CA  LEU    61      26.039  41.039  42.254  1.00 53.20           C  
ATOM    417  C   LEU    61      25.080  41.575  41.195  1.00 53.73           C  
ATOM    418  O   LEU    61      24.756  40.893  40.222  1.00 52.67           O  
ATOM    419  CB  LEU    61      25.279  40.571  43.504  1.00 52.15           C  
ATOM    420  CG  LEU    61      26.060  39.700  44.497  1.00 50.32           C  
ATOM    421  CD1 LEU    61      25.558  39.942  45.918  1.00 49.21           C  
ATOM    422  CD2 LEU    61      25.916  38.227  44.122  1.00 47.40           C  
ATOM    423  N   GLY    62      24.633  42.808  41.379  1.00 55.99           N  
ATOM    424  CA  GLY    62      23.719  43.392  40.417  1.00 59.26           C  
ATOM    425  C   GLY    62      24.385  43.577  39.065  1.00 60.09           C  
ATOM    426  O   GLY    62      23.770  43.381  38.018  1.00 61.11           O  
ATOM    427  N   ALA    63      25.659  43.950  39.095  1.00 60.63           N  
ATOM    428  CA  ALA    63      26.419  44.172  37.873  1.00 61.18           C  
ATOM    429  C   ALA    63      26.460  42.954  36.957  1.00 60.04           C  
ATOM    430  O   ALA    63      26.575  43.105  35.750  1.00 61.51           O  
ATOM    431  CB  ALA    63      27.832  44.617  38.219  1.00 61.48           C  
ATOM    432  N   ALA    64      26.374  41.752  37.518  1.00 59.72           N  
ATOM    433  CA  ALA    64      26.404  40.539  36.700  1.00 59.00           C  
ATOM    434  C   ALA    64      25.120  40.380  35.901  1.00 61.13           C  
ATOM    435  O   ALA    64      25.025  39.523  35.024  1.00 60.65           O  
ATOM    436  CB  ALA    64      26.618  39.321  37.568  1.00 57.86           C  
ATOM    437  N   ILE    65      24.122  41.196  36.221  1.00 63.34           N  
ATOM    438  CA  ILE    65      22.853  41.143  35.506  1.00 64.35           C  
ATOM    439  C   ILE    65      22.854  42.255  34.466  1.00 65.13           C  
ATOM    440  O   ILE    65      22.716  41.997  33.278  1.00 63.47           O  
ATOM    441  CB  ILE    65      21.633  41.375  36.431  1.00 64.03           C  
ATOM    442  CG1 ILE    65      21.603  40.354  37.561  1.00 61.72           C  
ATOM    443  CG2 ILE    65      20.343  41.247  35.626  1.00 64.35           C  
ATOM    444  CD1 ILE    65      20.632  40.736  38.678  1.00 58.41           C  
ATOM    445  N   ARG    66      23.034  43.498  34.908  1.00 65.61           N  
ATOM    446  CA  ARG    66      22.991  44.625  33.971  1.00 66.75           C  
ATOM    447  C   ARG    66      24.286  45.044  33.265  1.00 65.81           C  
ATOM    448  O   ARG    66      24.657  46.225  33.243  1.00 67.92           O  
ATOM    449  CB  ARG    66      22.348  45.832  34.650  1.00 67.01           C  
ATOM    450  CG  ARG    66      22.930  46.224  35.983  1.00 70.89           C  
ATOM    451  CD  ARG    66      22.388  47.577  36.376  1.00 79.03           C  
ATOM    452  NE  ARG    66      22.696  48.583  35.361  1.00 84.60           N  
ATOM    453  CZ  ARG    66      23.885  49.155  35.206  1.00 86.35           C  
ATOM    454  NH1 ARG    66      24.893  48.825  36.008  1.00 83.77           N  
ATOM    455  NH2 ARG    66      24.062  50.059  34.249  1.00 83.22           N  
ATOM    456  N   GLY    67      24.948  44.056  32.671  1.00 61.55           N  
ATOM    457  CA  GLY    67      26.180  44.278  31.929  1.00 63.66           C  
ATOM    458  C   GLY    67      25.815  43.701  30.583  1.00 65.46           C  
ATOM    459  O   GLY    67      26.284  44.135  29.526  1.00 66.44           O  
ATOM    460  N   ASP    68      24.954  42.686  30.653  1.00 33.74           N  
ATOM    461  CA  ASP    68      24.422  42.009  29.472  1.00 33.21           C  
ATOM    462  C   ASP    68      23.369  42.986  28.987  1.00 36.28           C  
ATOM    463  O   ASP    68      22.870  42.874  27.855  1.00 71.16           O  
ATOM    464  CB  ASP    68      23.781  40.681  29.867  1.00 30.38           C  
ATOM    465  CG  ASP    68      24.819  39.640  30.230  1.00 34.25           C  
ATOM    466  OD1 ASP    68      26.007  39.875  29.876  1.00 35.02           O  
ATOM    467  OD2 ASP    68      24.481  38.589  30.842  1.00 33.10           O  
ATOM    468  N   THR    69      23.038  43.948  29.865  1.00 35.66           N  
ATOM    469  CA  THR    69      22.075  44.989  29.518  1.00 34.35           C  
ATOM    470  C   THR    69      21.996  46.196  30.461  1.00 37.99           C  
ATOM    471  O   THR    69      21.239  46.188  31.440  1.00 71.48           O  
ATOM    472  CB  THR    69      20.667  44.439  29.417  1.00 32.31           C  
ATOM    473  OG1 THR    69      20.701  43.139  28.797  1.00 33.54           O  
ATOM    474  CG2 THR    69      19.833  45.393  28.545  1.00 35.19           C  
ATOM    475  N   PRO    70      22.791  47.243  30.187  1.00 71.09           N  
ATOM    476  CA  PRO    70      22.777  48.455  31.019  1.00 70.65           C  
ATOM    477  C   PRO    70      21.468  49.209  30.766  1.00 70.27           C  
ATOM    478  O   PRO    70      21.241  50.307  31.275  1.00 69.44           O  
ATOM    479  CB  PRO    70      24.015  49.227  30.537  1.00 71.09           C  
ATOM    480  CG  PRO    70      24.252  48.684  29.133  1.00 72.04           C  
ATOM    481  CD  PRO    70      23.974  47.218  29.308  1.00 71.20           C  
ATOM    482  N   GLU    71      20.607  48.581  29.972  1.00 71.09           N  
ATOM    483  CA  GLU    71      19.312  49.150  29.616  1.00 75.30           C  
ATOM    484  C   GLU    71      18.296  48.896  30.714  1.00 78.01           C  
ATOM    485  O   GLU    71      17.318  49.623  30.850  1.00 79.60           O  
ATOM    486  CB  GLU    71      18.815  48.533  28.315  1.00 75.45           C  
ATOM    487  N   VAL    72      18.552  47.858  31.502  1.00 80.19           N  
ATOM    488  CA  VAL    72      17.645  47.444  32.562  1.00 79.15           C  
ATOM    489  C   VAL    72      17.993  47.917  33.969  1.00 79.08           C  
ATOM    490  O   VAL    72      19.128  48.300  34.268  1.00 80.56           O  
ATOM    491  CB  VAL    72      17.540  45.919  32.569  1.00 78.95           C  
ATOM    492  CG1 VAL    72      18.800  45.316  33.164  1.00 78.97           C  
ATOM    493  CG2 VAL    72      16.306  45.478  33.315  1.00 79.92           C  
ATOM    494  N   GLY    73      16.994  47.891  34.840  1.00 77.79           N  
ATOM    495  CA  GLY    73      17.215  48.295  36.213  1.00 74.50           C  
ATOM    496  C   GLY    73      17.176  47.054  37.076  1.00 72.12           C  
ATOM    497  O   GLY    73      16.435  46.124  36.778  1.00 71.30           O  
ATOM    498  N   VAL    74      18.000  47.009  38.115  1.00 69.87           N  
ATOM    499  CA  VAL    74      17.980  45.867  39.021  1.00 67.33           C  
ATOM    500  C   VAL    74      17.924  46.378  40.446  1.00 65.07           C  
ATOM    501  O   VAL    74      18.701  47.252  40.840  1.00 64.68           O  
ATOM    502  CB  VAL    74      19.230  44.925  38.893  1.00 66.36           C  
ATOM    503  CG1 VAL    74      19.382  44.433  37.469  1.00 67.21           C  
ATOM    504  CG2 VAL    74      20.488  45.624  39.395  1.00 66.08           C  
ATOM    505  N   ALA    75      16.990  45.844  41.216  1.00 62.21           N  
ATOM    506  CA  ALA    75      16.860  46.233  42.612  1.00 59.82           C  
ATOM    507  C   ALA    75      17.039  44.956  43.415  1.00 57.48           C  
ATOM    508  O   ALA    75      16.521  43.898  43.035  1.00 55.79           O  
ATOM    509  CB  ALA    75      15.487  46.840  42.869  1.00 59.11           C  
ATOM    510  N   THR    76      17.802  45.046  44.501  1.00 57.35           N  
ATOM    511  CA  THR    76      18.046  43.886  45.356  1.00 54.95           C  
ATOM    512  C   THR    76      16.774  43.588  46.149  1.00 54.39           C  
ATOM    513  O   THR    76      16.188  44.504  46.720  1.00 55.28           O  
ATOM    514  CB  THR    76      19.146  44.179  46.376  1.00 54.73           C  
ATOM    515  OG1 THR    76      20.137  45.028  45.789  1.00 53.12           O  
ATOM    516  CG2 THR    76      19.791  42.875  46.837  1.00 48.76           C  
ATOM    517  N   ILE    77      16.351  42.339  46.161  1.00 54.78           N  
ATOM    518  CA  ILE    77      15.153  41.933  46.919  1.00 53.95           C  
ATOM    519  C   ILE    77      15.629  41.454  48.293  1.00 53.85           C  
ATOM    520  O   ILE    77      15.225  41.980  49.326  1.00 53.87           O  
ATOM    521  CB  ILE    77      14.389  40.777  46.214  1.00 53.06           C  
ATOM    522  CG1 ILE    77      13.793  41.277  44.891  1.00 49.37           C  
ATOM    523  CG2 ILE    77      13.299  40.243  47.112  1.00 51.41           C  
ATOM    524  CD1 ILE    77      13.302  40.153  43.972  1.00 50.91           C  
ATOM    525  N   ASP    78      16.508  40.458  48.278  1.00 55.39           N  
ATOM    526  CA  ASP    78      17.093  39.904  49.496  1.00 55.89           C  
ATOM    527  C   ASP    78      18.510  39.412  49.202  1.00 54.38           C  
ATOM    528  O   ASP    78      18.835  39.076  48.067  1.00 53.61           O  
ATOM    529  CB  ASP    78      16.253  38.747  50.015  1.00 54.72           C  
ATOM    530  CG  ASP    78      16.001  37.701  48.953  1.00 59.69           C  
ATOM    531  OD1 ASP    78      14.817  37.481  48.619  1.00 61.41           O  
ATOM    532  OD2 ASP    78      16.980  37.107  48.448  1.00 60.49           O  
ATOM    533  N   MET    79      19.342  39.374  50.239  1.00 55.52           N  
ATOM    534  CA  MET    79      20.716  38.921  50.105  1.00 55.94           C  
ATOM    535  C   MET    79      21.201  38.170  51.340  1.00 55.05           C  
ATOM    536  O   MET    79      20.918  38.560  52.478  1.00 54.67           O  
ATOM    537  CB  MET    79      21.634  40.112  49.844  1.00 57.77           C  
ATOM    538  CG  MET    79      23.104  39.746  49.644  1.00 61.43           C  
ATOM    539  SD  MET    79      24.188  41.319  49.288  1.00 69.63          SE  
ATOM    540  CE  MET    79      23.137  41.999  47.825  1.00 68.28           C  
ATOM    541  N   ASN    80      21.939  37.097  51.098  1.00 55.10           N  
ATOM    542  CA  ASN    80      22.491  36.243  52.142  1.00 53.44           C  
ATOM    543  C   ASN    80      24.026  36.260  52.038  1.00 52.11           C  
ATOM    544  O   ASN    80      24.590  36.005  50.981  1.00 50.58           O  
ATOM    545  CB  ASN    80      21.935  34.822  51.964  1.00 53.41           C  
ATOM    546  CG  ASN    80      22.277  33.905  53.126  1.00 54.82           C  
ATOM    547  OD1 ASN    80      23.412  33.444  53.253  1.00 56.64           O  
ATOM    548  ND2 ASN    80      21.297  33.642  53.982  1.00 54.68           N  
ATOM    549  N   THR    81      24.690  36.577  53.140  1.00 52.31           N  
ATOM    550  CA  THR    81      26.142  36.657  53.148  1.00 51.58           C  
ATOM    551  C   THR    81      26.772  35.788  54.236  1.00 50.18           C  
ATOM    552  O   THR    81      26.372  35.825  55.406  1.00 47.55           O  
ATOM    553  CB  THR    81      26.595  38.130  53.333  1.00 50.52           C  
ATOM    554  OG1 THR    81      25.786  38.979  52.513  1.00 53.11           O  
ATOM    555  CG2 THR    81      28.056  38.313  52.912  1.00 51.60           C  
ATOM    556  N   SER    82      27.756  34.999  53.822  1.00 49.70           N  
ATOM    557  CA  SER    82      28.486  34.119  54.715  1.00 48.38           C  
ATOM    558  C   SER    82      29.867  34.719  54.962  1.00 49.69           C  
ATOM    559  O   SER    82      30.508  35.220  54.032  1.00 49.83           O  
ATOM    560  CB  SER    82      28.605  32.733  54.090  1.00 47.04           C  
ATOM    561  OG  SER    82      27.380  32.035  54.219  1.00 47.27           O  
ATOM    562  N   PHE    83      30.305  34.683  56.217  1.00 48.39           N  
ATOM    563  CA  PHE    83      31.596  35.233  56.601  1.00 52.04           C  
ATOM    564  C   PHE    83      32.540  34.094  56.982  1.00 53.41           C  
ATOM    565  O   PHE    83      32.405  33.475  58.034  1.00 51.27           O  
ATOM    566  CB  PHE    83      31.401  36.230  57.751  1.00 52.31           C  
ATOM    567  CG  PHE    83      30.568  37.417  57.369  1.00 48.98           C  
ATOM    568  CD1 PHE    83      31.084  38.398  56.533  1.00 47.82           C  
ATOM    569  CD2 PHE    83      29.237  37.511  57.769  1.00 47.87           C  
ATOM    570  CE1 PHE    83      30.289  39.456  56.094  1.00 48.23           C  
ATOM    571  CE2 PHE    83      28.431  38.571  57.331  1.00 50.92           C  
ATOM    572  CZ  PHE    83      28.956  39.538  56.494  1.00 47.91           C  
ATOM    573  N   MET    84      33.502  33.828  56.103  1.00 56.89           N  
ATOM    574  CA  MET    84      34.440  32.731  56.301  1.00 59.89           C  
ATOM    575  C   MET    84      35.791  33.067  56.893  1.00 60.24           C  
ATOM    576  O   MET    84      36.319  32.314  57.712  1.00 60.94           O  
ATOM    577  CB  MET    84      34.684  32.014  54.981  1.00 60.79           C  
ATOM    578  CG  MET    84      33.579  31.076  54.553  1.00 67.59           C  
ATOM    579  SD  MET    84      32.327  31.852  53.306  1.00 82.87          SE  
ATOM    580  CE  MET    84      31.428  30.224  52.768  1.00 74.13           C  
ATOM    581  N   SER    85      36.350  34.189  56.463  1.00 62.74           N  
ATOM    582  CA  SER    85      37.663  34.601  56.904  1.00 65.29           C  
ATOM    583  C   SER    85      37.779  36.104  56.991  1.00 67.79           C  
ATOM    584  O   SER    85      37.254  36.828  56.149  1.00 68.96           O  
ATOM    585  CB  SER    85      38.706  34.086  55.915  1.00 65.16           C  
ATOM    586  OG  SER    85      38.545  32.696  55.708  1.00 67.38           O  
ATOM    587  N   PRO    86      38.474  36.593  58.021  1.00 68.91           N  
ATOM    588  CA  PRO    86      38.650  38.034  58.184  1.00 69.20           C  
ATOM    589  C   PRO    86      39.234  38.589  56.898  1.00 69.57           C  
ATOM    590  O   PRO    86      40.109  37.973  56.303  1.00 69.70           O  
ATOM    591  CB  PRO    86      39.628  38.129  59.352  1.00 70.10           C  
ATOM    592  CG  PRO    86      39.254  36.938  60.189  1.00 69.38           C  
ATOM    593  CD  PRO    86      39.057  35.851  59.154  1.00 68.26           C  
ATOM    594  N   GLY    87      38.742  39.745  56.469  1.00 71.21           N  
ATOM    595  CA  GLY    87      39.238  40.352  55.246  1.00 70.14           C  
ATOM    596  C   GLY    87      40.309  41.386  55.524  1.00 71.08           C  
ATOM    597  O   GLY    87      40.143  42.241  56.393  1.00 70.15           O  
ATOM    598  N   ARG    88      41.409  41.313  54.778  1.00 72.20           N  
ATOM    599  CA  ARG    88      42.517  42.243  54.947  1.00 71.33           C  
ATOM    600  C   ARG    88      43.218  42.528  53.626  1.00 71.05           C  
ATOM    601  O   ARG    88      43.272  41.670  52.749  1.00 71.84           O  
ATOM    602  CB  ARG    88      43.516  41.671  55.954  1.00 72.66           C  
ATOM    603  CG  ARG    88      42.998  41.644  57.382  1.00 72.27           C  
ATOM    604  CD  ARG    88      43.927  40.870  58.295  1.00 76.68           C  
ATOM    605  NE  ARG    88      43.204  39.848  59.050  1.00 79.59           N  
ATOM    606  CZ  ARG    88      43.741  39.114  60.017  1.00 79.58           C  
ATOM    607  NH1 ARG    88      45.013  39.287  60.351  1.00 82.63           N  
ATOM    608  NH2 ARG    88      43.008  38.207  60.651  1.00 78.13           N  
ATOM    609  N   GLY    89      43.758  43.735  53.488  1.00 70.69           N  
ATOM    610  CA  GLY    89      44.446  44.101  52.264  1.00 71.85           C  
ATOM    611  C   GLY    89      43.462  44.226  51.121  1.00 73.12           C  
ATOM    612  O   GLY    89      42.256  44.199  51.342  1.00 73.84           O  
ATOM    613  N   ASP    90      43.970  44.370  49.901  1.00 72.73           N  
ATOM    614  CA  ASP    90      43.117  44.490  48.723  1.00 72.06           C  
ATOM    615  C   ASP    90      42.302  43.219  48.534  1.00 70.71           C  
ATOM    616  O   ASP    90      42.810  42.110  48.713  1.00 71.10           O  
ATOM    617  CB  ASP    90      43.955  44.724  47.462  1.00 73.55           C  
ATOM    618  CG  ASP    90      44.353  46.179  47.277  1.00 74.11           C  
ATOM    619  OD1 ASP    90      44.944  46.770  48.208  1.00 73.77           O  
ATOM    620  OD2 ASP    90      44.085  46.727  46.188  1.00 75.54           O  
ATOM    621  N   LEU    91      41.039  43.384  48.161  1.00 68.33           N  
ATOM    622  CA  LEU    91      40.155  42.244  47.931  1.00 64.69           C  
ATOM    623  C   LEU    91      39.545  42.356  46.539  1.00 63.47           C  
ATOM    624  O   LEU    91      39.327  43.463  46.031  1.00 61.92           O  
ATOM    625  CB  LEU    91      39.041  42.216  48.972  1.00 63.68           C  
ATOM    626  CG  LEU    91      39.459  42.248  50.440  1.00 59.55           C  
ATOM    627  CD1 LEU    91      38.233  42.541  51.291  1.00 60.67           C  
ATOM    628  CD2 LEU    91      40.101  40.933  50.843  1.00 56.88           C  
ATOM    629  N   VAL    92      39.282  41.211  45.920  1.00 61.53           N  
ATOM    630  CA  VAL    92      38.691  41.204  44.593  1.00 60.01           C  
ATOM    631  C   VAL    92      37.337  40.527  44.720  1.00 57.88           C  
ATOM    632  O   VAL    92      37.203  39.510  45.393  1.00 55.94           O  
ATOM    633  CB  VAL    92      39.602  40.457  43.559  1.00 59.18           C  
ATOM    634  CG1 VAL    92      39.536  38.961  43.765  1.00 62.89           C  
ATOM    635  CG2 VAL    92      39.200  40.833  42.151  1.00 60.68           C  
ATOM    636  N   ILE    93      36.331  41.116  44.085  1.00 58.48           N  
ATOM    637  CA  ILE    93      34.974  40.592  44.144  1.00 57.13           C  
ATOM    638  C   ILE    93      34.493  40.141  42.774  1.00 55.90           C  
ATOM    639  O   ILE    93      34.531  40.904  41.809  1.00 56.68           O  
ATOM    640  CB  ILE    93      34.014  41.662  44.710  1.00 57.13           C  
ATOM    641  CG1 ILE    93      34.526  42.132  46.072  1.00 54.80           C  
ATOM    642  CG2 ILE    93      32.602  41.107  44.837  1.00 53.88           C  
ATOM    643  CD1 ILE    93      35.587  43.210  45.997  1.00 48.07           C  
ATOM    644  N   GLU    94      34.035  38.898  42.698  1.00 56.37           N  
ATOM    645  CA  GLU    94      33.559  38.346  41.436  1.00 56.42           C  
ATOM    646  C   GLU    94      32.210  37.645  41.589  1.00 55.31           C  
ATOM    647  O   GLU    94      32.034  36.791  42.451  1.00 54.64           O  
ATOM    648  CB  GLU    94      34.588  37.364  40.873  1.00 58.89           C  
ATOM    649  CG  GLU    94      35.954  37.969  40.620  1.00 62.05           C  
ATOM    650  CD  GLU    94      36.781  37.142  39.657  1.00 69.04           C  
ATOM    651  OE1 GLU    94      37.265  37.703  38.646  1.00 67.11           O  
ATOM    652  OE2 GLU    94      36.945  35.932  39.908  1.00 70.83           O  
ATOM    653  N   THR    95      31.272  38.000  40.720  1.00 55.95           N  
ATOM    654  CA  THR    95      29.928  37.445  40.761  1.00 55.64           C  
ATOM    655  C   THR    95      29.519  36.789  39.450  1.00 57.43           C  
ATOM    656  O   THR    95      30.160  36.987  38.421  1.00 59.47           O  
ATOM    657  CB  THR    95      28.905  38.544  41.078  1.00 55.35           C  
ATOM    658  OG1 THR    95      29.008  39.593  40.104  1.00 53.07           O  
ATOM    659  CG2 THR    95      29.155  39.118  42.467  1.00 51.92           C  
ATOM    660  N   ARG    96      28.447  36.006  39.500  1.00 58.84           N  
ATOM    661  CA  ARG    96      27.907  35.334  38.318  1.00 58.70           C  
ATOM    662  C   ARG    96      26.393  35.235  38.479  1.00 57.98           C  
ATOM    663  O   ARG    96      25.894  35.043  39.589  1.00 57.43           O  
ATOM    664  CB  ARG    96      28.516  33.928  38.154  1.00 60.02           C  
ATOM    665  CG  ARG    96      28.151  32.917  39.244  1.00 64.39           C  
ATOM    666  CD  ARG    96      29.294  31.922  39.471  1.00 73.23           C  
ATOM    667  NE  ARG    96      30.532  32.618  39.831  1.00 79.38           N  
ATOM    668  CZ  ARG    96      31.044  32.700  41.058  1.00 77.77           C  
ATOM    669  NH1 ARG    96      30.442  32.122  42.088  1.00 75.44           N  
ATOM    670  NH2 ARG    96      32.164  33.384  41.255  1.00 77.42           N  
ATOM    671  N   CYS    97      25.664  35.390  37.378  1.00 57.49           N  
ATOM    672  CA  CYS    97      24.211  35.306  37.416  1.00 55.67           C  
ATOM    673  C   CYS    97      23.878  33.840  37.260  1.00 55.73           C  
ATOM    674  O   CYS    97      24.382  33.193  36.350  1.00 58.61           O  
ATOM    675  CB  CYS    97      23.593  36.101  36.269  1.00 56.18           C  
ATOM    676  SG  CYS    97      21.779  36.147  36.286  1.00 57.01           S  
ATOM    677  N   LEU    98      23.040  33.313  38.146  1.00 54.26           N  
ATOM    678  CA  LEU    98      22.664  31.897  38.098  1.00 52.21           C  
ATOM    679  C   LEU    98      21.433  31.641  37.250  1.00 49.03           C  
ATOM    680  O   LEU    98      21.256  30.560  36.704  1.00 46.12           O  
ATOM    681  CB  LEU    98      22.395  31.381  39.504  1.00 54.15           C  
ATOM    682  CG  LEU    98      23.539  31.416  40.510  1.00 54.58           C  
ATOM    683  CD1 LEU    98      22.973  31.175  41.898  1.00 46.73           C  
ATOM    684  CD2 LEU    98      24.594  30.369  40.145  1.00 56.93           C  
ATOM    685  N   ARG    99      20.568  32.644  37.178  1.00 50.48           N  
ATOM    686  CA  ARG    99      19.344  32.557  36.404  1.00 52.49           C  
ATOM    687  C   ARG    99      18.757  33.938  36.190  1.00 52.82           C  
ATOM    688  O   ARG    99      18.828  34.807  37.056  1.00 53.75           O  
ATOM    689  CB  ARG    99      18.304  31.676  37.102  1.00 54.06           C  
ATOM    690  CG  ARG    99      16.945  31.789  36.431  1.00 57.29           C  
ATOM    691  CD  ARG    99      16.145  30.500  36.429  1.00 65.87           C  
ATOM    692  NE  ARG    99      15.023  30.617  35.497  1.00 70.54           N  
ATOM    693  CZ  ARG    99      14.103  31.574  35.559  1.00 67.79           C  
ATOM    694  NH1 ARG    99      14.164  32.496  36.511  1.00 71.10           N  
ATOM    695  NH2 ARG    99      13.132  31.624  34.661  1.00 70.62           N  
ATOM    696  N   ARG   100      18.160  34.132  35.030  1.00 56.24           N  
ATOM    697  CA  ARG   100      17.563  35.413  34.713  1.00 58.79           C  
ATOM    698  C   ARG   100      16.166  35.176  34.156  1.00 59.48           C  
ATOM    699  O   ARG   100      15.992  34.445  33.179  1.00 62.14           O  
ATOM    700  CB  ARG   100      18.432  36.142  33.687  1.00 59.79           C  
ATOM    701  CG  ARG   100      18.455  37.650  33.842  1.00 59.96           C  
ATOM    702  CD  ARG   100      19.412  38.262  32.846  1.00 63.35           C  
ATOM    703  NE  ARG   100      19.086  39.652  32.554  1.00 71.63           N  
ATOM    704  CZ  ARG   100      19.996  40.602  32.363  1.00 73.15           C  
ATOM    705  NH1 ARG   100      21.288  40.302  32.445  1.00 66.78           N  
ATOM    706  NH2 ARG   100      19.618  41.842  32.072  1.00 77.98           N  
ATOM    707  N   GLY   101      15.171  35.778  34.797  1.00 59.68           N  
ATOM    708  CA  GLY   101      13.807  35.625  34.342  1.00 60.36           C  
ATOM    709  C   GLY   101      13.387  36.942  33.748  1.00 59.99           C  
ATOM    710  O   GLY   101      14.216  37.825  33.555  1.00 59.70           O  
ATOM    711  N   ALA   102      12.107  37.086  33.444  1.00 61.31           N  
ATOM    712  CA  ALA   102      11.638  38.337  32.876  1.00 62.56           C  
ATOM    713  C   ALA   102      11.613  39.373  33.981  1.00 63.18           C  
ATOM    714  O   ALA   102      11.869  40.556  33.752  1.00 65.06           O  
ATOM    715  CB  ALA   102      10.259  38.155  32.296  1.00 62.57           C  
ATOM    716  N   SER   103      11.327  38.907  35.191  1.00 63.17           N  
ATOM    717  CA  SER   103      11.222  39.792  36.345  1.00 63.30           C  
ATOM    718  C   SER   103      12.206  39.558  37.492  1.00 60.88           C  
ATOM    719  O   SER   103      12.620  40.507  38.152  1.00 59.41           O  
ATOM    720  CB  SER   103       9.791  39.713  36.886  1.00 65.59           C  
ATOM    721  OG  SER   103       9.628  40.516  38.041  1.00 72.67           O  
ATOM    722  N   ILE   104      12.576  38.294  37.712  1.00 60.81           N  
ATOM    723  CA  ILE   104      13.469  37.891  38.813  1.00 58.72           C  
ATOM    724  C   ILE   104      14.853  37.356  38.406  1.00 59.10           C  
ATOM    725  O   ILE   104      14.965  36.490  37.540  1.00 56.77           O  
ATOM    726  CB  ILE   104      12.793  36.791  39.674  1.00 58.71           C  
ATOM    727  CG1 ILE   104      11.414  37.255  40.143  1.00 54.91           C  
ATOM    728  CG2 ILE   104      13.657  36.457  40.872  1.00 56.87           C  
ATOM    729  CD1 ILE   104      11.455  38.329  41.208  1.00 53.11           C  
ATOM    730  N   ALA   105      15.897  37.851  39.069  1.00 57.55           N  
ATOM    731  CA  ALA   105      17.265  37.408  38.791  1.00 55.87           C  
ATOM    732  C   ALA   105      17.959  36.863  40.039  1.00 53.73           C  
ATOM    733  O   ALA   105      17.839  37.433  41.119  1.00 52.30           O  
ATOM    734  CB  ALA   105      18.079  38.563  38.209  1.00 55.98           C  
ATOM    735  N   PHE   106      18.697  35.765  39.878  1.00 54.37           N  
ATOM    736  CA  PHE   106      19.435  35.138  40.984  1.00 54.66           C  
ATOM    737  C   PHE   106      20.934  35.283  40.757  1.00 56.10           C  
ATOM    738  O   PHE   106      21.431  35.012  39.668  1.00 58.87           O  
ATOM    739  CB  PHE   106      19.118  33.647  41.074  1.00 51.44           C  
ATOM    740  CG  PHE   106      17.710  33.342  41.483  1.00 50.85           C  
ATOM    741  CD1 PHE   106      17.320  33.428  42.822  1.00 44.53           C  
ATOM    742  CD2 PHE   106      16.763  32.968  40.527  1.00 46.72           C  
ATOM    743  CE1 PHE   106      16.002  33.144  43.214  1.00 39.63           C  
ATOM    744  CE2 PHE   106      15.439  32.684  40.904  1.00 47.44           C  
ATOM    745  CZ  PHE   106      15.059  32.773  42.253  1.00 49.21           C  
ATOM    746  N   CYS   107      21.658  35.694  41.788  1.00 59.42           N  
ATOM    747  CA  CYS   107      23.103  35.859  41.666  1.00 60.48           C  
ATOM    748  C   CYS   107      23.868  35.361  42.879  1.00 58.89           C  
ATOM    749  O   CYS   107      23.320  35.228  43.968  1.00 58.15           O  
ATOM    750  CB  CYS   107      23.451  37.333  41.430  1.00 59.77           C  
ATOM    751  SG  CYS   107      22.814  38.008  39.875  1.00 68.43           S  
ATOM    752  N   GLU   108      25.142  35.060  42.670  1.00 58.74           N  
ATOM    753  CA  GLU   108      26.014  34.615  43.746  1.00 57.79           C  
ATOM    754  C   GLU   108      27.394  35.209  43.505  1.00 56.15           C  
ATOM    755  O   GLU   108      27.675  35.741  42.435  1.00 56.27           O  
ATOM    756  CB  GLU   108      26.088  33.090  43.809  1.00 56.81           C  
ATOM    757  CG  GLU   108      26.431  32.413  42.505  1.00 59.58           C  
ATOM    758  CD  GLU   108      27.160  31.110  42.723  1.00 56.82           C  
ATOM    759  OE1 GLU   108      26.776  30.354  43.640  1.00 62.65           O  
ATOM    760  OE2 GLU   108      28.122  30.847  41.975  1.00 63.95           O  
ATOM    761  N   GLY   109      28.252  35.143  44.510  1.00 55.69           N  
ATOM    762  CA  GLY   109      29.573  35.711  44.349  1.00 56.85           C  
ATOM    763  C   GLY   109      30.464  35.456  45.541  1.00 56.87           C  
ATOM    764  O   GLY   109      30.046  34.847  46.526  1.00 54.75           O  
ATOM    765  N   GLU   110      31.693  35.955  45.459  1.00 57.17           N  
ATOM    766  CA  GLU   110      32.664  35.744  46.520  1.00 58.54           C  
ATOM    767  C   GLU   110      33.738  36.825  46.563  1.00 56.41           C  
ATOM    768  O   GLU   110      34.023  37.483  45.560  1.00 57.20           O  
ATOM    769  CB  GLU   110      33.321  34.376  46.325  1.00 58.69           C  
ATOM    770  CG  GLU   110      33.367  33.958  44.854  1.00 67.99           C  
ATOM    771  CD  GLU   110      34.447  32.940  44.547  1.00 76.41           C  
ATOM    772  OE1 GLU   110      34.343  31.793  45.033  1.00 83.23           O  
ATOM    773  OE2 GLU   110      35.399  33.295  43.814  1.00 76.64           O  
ATOM    774  N   ILE   111      34.327  36.997  47.741  1.00 55.20           N  
ATOM    775  CA  ILE   111      35.387  37.964  47.944  1.00 53.99           C  
ATOM    776  C   ILE   111      36.631  37.171  48.334  1.00 53.91           C  
ATOM    777  O   ILE   111      36.563  36.255  49.158  1.00 52.14           O  
ATOM    778  CB  ILE   111      35.039  38.952  49.079  1.00 55.99           C  
ATOM    779  CG1 ILE   111      33.687  39.618  48.794  1.00 50.38           C  
ATOM    780  CG2 ILE   111      36.146  40.007  49.213  1.00 52.86           C  
ATOM    781  CD1 ILE   111      33.182  40.488  49.915  1.00 44.32           C  
ATOM    782  N   ARG   112      37.767  37.512  47.740  1.00 54.95           N  
ATOM    783  CA  ARG   112      39.004  36.802  48.049  1.00 57.36           C  
ATOM    784  C   ARG   112      40.111  37.804  48.309  1.00 58.33           C  
ATOM    785  O   ARG   112      40.093  38.914  47.770  1.00 58.61           O  
ATOM    786  CB  ARG   112      39.401  35.876  46.890  1.00 55.02           C  
ATOM    787  CG  ARG   112      38.240  35.058  46.326  1.00 58.53           C  
ATOM    788  CD  ARG   112      38.714  33.889  45.468  1.00 59.84           C  
ATOM    789  NE  ARG   112      38.967  32.697  46.276  1.00 55.17           N  
ATOM    790  CZ  ARG   112      38.262  31.576  46.185  1.00 56.50           C  
ATOM    791  NH1 ARG   112      37.268  31.499  45.312  1.00 57.16           N  
ATOM    792  NH2 ARG   112      38.530  30.546  46.983  1.00 53.22           N  
ATOM    793  N   ASP   113      41.065  37.418  49.149  1.00 59.75           N  
ATOM    794  CA  ASP   113      42.187  38.293  49.460  1.00 61.42           C  
ATOM    795  C   ASP   113      43.326  38.045  48.482  1.00 61.61           C  
ATOM    796  O   ASP   113      43.249  37.151  47.643  1.00 61.62           O  
ATOM    797  CB  ASP   113      42.678  38.072  50.899  1.00 63.46           C  
ATOM    798  CG  ASP   113      42.922  36.614  51.225  1.00 62.82           C  
ATOM    799  OD1 ASP   113      43.513  35.895  50.390  1.00 71.52           O  
ATOM    800  OD2 ASP   113      42.531  36.189  52.327  1.00 61.21           O  
ATOM    801  N   SER   114      44.375  38.852  48.590  1.00 63.28           N  
ATOM    802  CA  SER   114      45.539  38.730  47.722  1.00 64.00           C  
ATOM    803  C   SER   114      46.053  37.295  47.693  1.00 65.13           C  
ATOM    804  O   SER   114      46.604  36.850  46.693  1.00 66.04           O  
ATOM    805  CB  SER   114      46.643  39.679  48.204  1.00 65.13           C  
ATOM    806  OG  SER   114      46.817  39.600  49.612  1.00 60.56           O  
ATOM    807  N   ALA   115      45.849  36.572  48.792  1.00 66.03           N  
ATOM    808  CA  ALA   115      46.287  35.183  48.918  1.00 65.08           C  
ATOM    809  C   ALA   115      45.301  34.190  48.297  1.00 65.99           C  
ATOM    810  O   ALA   115      45.504  32.977  48.367  1.00 66.38           O  
ATOM    811  CB  ALA   115      46.511  34.846  50.396  1.00 65.09           C  
ATOM    812  N   GLY   116      44.227  34.714  47.707  1.00 66.72           N  
ATOM    813  CA  GLY   116      43.228  33.874  47.061  1.00 64.83           C  
ATOM    814  C   GLY   116      42.303  33.078  47.968  1.00 64.48           C  
ATOM    815  O   GLY   116      41.588  32.188  47.501  1.00 63.85           O  
ATOM    816  N   GLU   117      42.304  33.389  49.259  1.00 63.88           N  
ATOM    817  CA  GLU   117      41.458  32.672  50.204  1.00 64.34           C  
ATOM    818  C   GLU   117      40.067  33.306  50.290  1.00 62.51           C  
ATOM    819  O   GLU   117      39.922  34.529  50.216  1.00 62.86           O  
ATOM    820  CB  GLU   117      42.115  32.656  51.587  1.00 65.37           C  
ATOM    821  CG  GLU   117      42.256  31.277  52.213  1.00 66.65           C  
ATOM    822  CD  GLU   117      43.127  30.333  51.389  1.00 73.09           C  
ATOM    823  OE1 GLU   117      44.185  30.772  50.883  1.00 72.72           O  
ATOM    824  OE2 GLU   117      42.761  29.144  51.258  1.00 73.02           O  
ATOM    825  N   LEU   118      39.053  32.461  50.444  1.00 59.68           N  
ATOM    826  CA  LEU   118      37.671  32.909  50.529  1.00 59.25           C  
ATOM    827  C   LEU   118      37.402  33.732  51.794  1.00 58.30           C  
ATOM    828  O   LEU   118      37.537  33.241  52.920  1.00 54.60           O  
ATOM    829  CB  LEU   118      36.729  31.695  50.472  1.00 60.95           C  
ATOM    830  CG  LEU   118      35.239  31.901  50.169  1.00 59.70           C  
ATOM    831  CD1 LEU   118      35.060  32.717  48.881  1.00 53.79           C  
ATOM    832  CD2 LEU   118      34.574  30.539  50.026  1.00 56.32           C  
ATOM    833  N   VAL   119      37.034  34.994  51.588  1.00 57.09           N  
ATOM    834  CA  VAL   119      36.725  35.905  52.679  1.00 56.54           C  
ATOM    835  C   VAL   119      35.238  35.783  53.006  1.00 54.43           C  
ATOM    836  O   VAL   119      34.868  35.530  54.149  1.00 55.22           O  
ATOM    837  CB  VAL   119      37.065  37.375  52.296  1.00 56.87           C  
ATOM    838  CG1 VAL   119      36.539  38.330  53.353  1.00 56.66           C  
ATOM    839  CG2 VAL   119      38.580  37.534  52.157  1.00 57.01           C  
ATOM    840  N   ALA   120      34.393  35.949  51.996  1.00 53.42           N  
ATOM    841  CA  ALA   120      32.947  35.838  52.174  1.00 54.17           C  
ATOM    842  C   ALA   120      32.283  35.429  50.873  1.00 52.69           C  
ATOM    843  O   ALA   120      32.813  35.685  49.804  1.00 54.05           O  
ATOM    844  CB  ALA   120      32.370  37.164  52.656  1.00 51.04           C  
ATOM    845  N   LYS   121      31.128  34.785  50.974  1.00 53.82           N  
ATOM    846  CA  LYS   121      30.365  34.361  49.807  1.00 53.64           C  
ATOM    847  C   LYS   121      28.933  34.842  50.040  1.00 53.35           C  
ATOM    848  O   LYS   121      28.452  34.835  51.174  1.00 51.67           O  
ATOM    849  CB  LYS   121      30.399  32.838  49.663  1.00 53.76           C  
ATOM    850  CG  LYS   121      30.210  32.357  48.236  1.00 60.50           C  
ATOM    851  CD  LYS   121      30.881  31.005  48.023  1.00 69.99           C  
ATOM    852  CE  LYS   121      30.995  30.643  46.543  1.00 72.37           C  
ATOM    853  NZ  LYS   121      29.668  30.515  45.889  1.00 75.53           N  
ATOM    854  N   ALA   122      28.257  35.258  48.969  1.00 52.17           N  
ATOM    855  CA  ALA   122      26.894  35.764  49.095  1.00 50.01           C  
ATOM    856  C   ALA   122      25.981  35.395  47.937  1.00 47.99           C  
ATOM    857  O   ALA   122      26.429  35.170  46.821  1.00 47.40           O  
ATOM    858  CB  ALA   122      26.921  37.286  49.260  1.00 47.87           C  
ATOM    859  N   THR   123      24.690  35.305  48.219  1.00 48.48           N  
ATOM    860  CA  THR   123      23.720  35.027  47.175  1.00 50.18           C  
ATOM    861  C   THR   123      22.708  36.170  47.283  1.00 50.64           C  
ATOM    862  O   THR   123      22.557  36.775  48.351  1.00 49.94           O  
ATOM    863  CB  THR   123      23.031  33.656  47.369  1.00 48.58           C  
ATOM    864  OG1 THR   123      22.423  33.601  48.666  1.00 52.63           O  
ATOM    865  CG2 THR   123      24.043  32.516  47.217  1.00 48.88           C  
ATOM    866  N   ALA   124      22.047  36.491  46.176  1.00 50.30           N  
ATOM    867  CA  ALA   124      21.073  37.577  46.166  1.00 49.15           C  
ATOM    868  C   ALA   124      19.970  37.360  45.144  1.00 50.23           C  
ATOM    869  O   ALA   124      20.143  36.646  44.150  1.00 48.07           O  
ATOM    870  CB  ALA   124      21.767  38.900  45.896  1.00 49.07           C  
ATOM    871  N   THR   125      18.823  37.969  45.410  1.00 49.61           N  
ATOM    872  CA  THR   125      17.695  37.868  44.509  1.00 49.31           C  
ATOM    873  C   THR   125      17.456  39.292  44.042  1.00 47.89           C  
ATOM    874  O   THR   125      17.596  40.240  44.816  1.00 47.69           O  
ATOM    875  CB  THR   125      16.435  37.301  45.215  1.00 48.47           C  
ATOM    876  OG1 THR   125      16.746  36.048  45.841  1.00 46.66           O  
ATOM    877  CG2 THR   125      15.350  37.055  44.207  1.00 49.82           C  
ATOM    878  N   PHE   126      17.099  39.452  42.777  1.00 47.83           N  
ATOM    879  CA  PHE   126      16.909  40.798  42.258  1.00 49.42           C  
ATOM    880  C   PHE   126      15.630  41.041  41.484  1.00 49.91           C  
ATOM    881  O   PHE   126      15.075  40.134  40.859  1.00 48.27           O  
ATOM    882  CB  PHE   126      18.075  41.197  41.342  1.00 47.90           C  
ATOM    883  CG  PHE   126      19.377  41.440  42.062  1.00 46.56           C  
ATOM    884  CD1 PHE   126      20.242  40.387  42.367  1.00 46.64           C  
ATOM    885  CD2 PHE   126      19.758  42.734  42.399  1.00 40.34           C  
ATOM    886  CE1 PHE   126      21.478  40.634  42.997  1.00 45.60           C  
ATOM    887  CE2 PHE   126      20.988  42.991  43.028  1.00 42.33           C  
ATOM    888  CZ  PHE   126      21.849  41.935  43.324  1.00 39.69           C  
ATOM    889  N   LYS   127      15.173  42.290  41.522  1.00 53.22           N  
ATOM    890  CA  LYS   127      14.003  42.701  40.755  1.00 57.90           C  
ATOM    891  C   LYS   127      14.625  43.362  39.520  1.00 59.78           C  
ATOM    892  O   LYS   127      15.464  44.259  39.659  1.00 58.23           O  
ATOM    893  CB  LYS   127      13.184  43.727  41.536  1.00 56.86           C  
ATOM    894  N   ILE   128      14.283  42.901  38.321  1.00 63.95           N  
ATOM    895  CA  ILE   128      14.820  43.588  37.157  1.00 68.16           C  
ATOM    896  C   ILE   128      13.707  44.524  36.743  1.00 71.94           C  
ATOM    897  O   ILE   128      12.611  44.095  36.375  1.00 71.60           O  
ATOM    898  CB  ILE   128      15.243  42.644  35.982  1.00 67.37           C  
ATOM    899  CG1 ILE   128      14.467  41.327  36.011  1.00 63.20           C  
ATOM    900  CG2 ILE   128      16.746  42.394  36.053  1.00 68.21           C  
ATOM    901  CD1 ILE   128      15.170  40.208  35.236  1.00 60.33           C  
ATOM    902  N   ILE   129      14.000  45.816  36.858  1.00 75.65           N  
ATOM    903  CA  ILE   129      13.054  46.886  36.560  1.00 79.11           C  
ATOM    904  C   ILE   129      12.728  47.158  35.092  1.00 82.21           C  
ATOM    905  O   ILE   129      13.085  48.203  34.556  1.00 82.94           O  
ATOM    906  CB  ILE   129      13.512  48.223  37.209  1.00 79.07           C  
ATOM    907  CG1 ILE   129      13.778  48.023  38.711  1.00 78.47           C  
ATOM    908  CG2 ILE   129      12.450  49.294  37.007  1.00 79.06           C  
ATOM    909  CD1 ILE   129      12.657  47.332  39.458  1.00 77.73           C  
ATOM    910  N   GLN   130      12.055  46.203  34.453  1.00 85.92           N  
ATOM    911  CA  GLN   130      11.596  46.349  33.074  1.00 88.00           C  
ATOM    912  C   GLN   130      10.817  45.148  32.564  1.00 88.85           C  
ATOM    913  O   GLN   130       9.657  45.373  32.160  1.00 89.20           O  
ATOM    914  CB  GLN   130      12.742  46.702  32.114  1.00 87.61           C  
ATOM    915  CG  GLN   130      12.373  47.924  31.257  1.00 87.70           C  
ATOM    916  CD  GLN   130      11.656  49.016  32.066  1.00 85.68           C  
ATOM    917  OE1 GLN   130      10.611  48.772  32.678  1.00 80.72           O  
ATOM    918  NE2 GLN   130      12.217  50.224  32.065  1.00 84.66           N  
END
