
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  138 ( 1026),  selected  138 , name 2fs2_B
# Molecule2: number of CA atoms  125 (  918),  selected  125 , name T0479.pdb
# PARAMETERS: 2fs2_B.T0479.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     0_B      T       6           -
LGA    L     1_B      -       -           -
LGA    S     2_B      -       -           -
LGA    H     3_B      -       -           -
LGA    K     4_B      -       -           -
LGA    A     5_B      -       -           -
LGA    W     6_B      -       -           -
LGA    Q     7_B      -       -           -
LGA    N     8_B      -       -           -
LGA    A     9_B      D       7           #
LGA    H    10_B      F       8          5.375
LGA    A    11_B      F       9          5.323
LGA    X    12_B      G      10          2.827
LGA    Y    13_B      L      11          3.872
LGA    E    14_B      -       -           -
LGA    N    15_B      T      12          1.251
LGA    D    16_B      I      13          1.693
LGA    A    17_B      P      14          1.782
LGA    C    18_B      F      15          1.732
LGA    A    19_B      M      16          1.931
LGA    K    20_B      Q      17          1.539
LGA    A    21_B      L      18          1.182
LGA    L    22_B      L      19          0.954
LGA    G    23_B      G      20          1.372
LGA    I    24_B      V      21          1.154
LGA    D    25_B      V      22          0.938
LGA    I    26_B      P      23          1.327
LGA    I    27_B      E      24          1.346
LGA    S    28_B      H      25          1.902
LGA    X    29_B      S      26          2.068
LGA    D    30_B      G      27          1.599
LGA    E    31_B      N      28          2.308
LGA    G    32_B      G      29          1.604
LGA    F    33_B      T      30          1.074
LGA    A    34_B      A      31          0.625
LGA    V    35_B      R      32          0.360
LGA    V    36_B      T      33          0.269
LGA    T    37_B      R      34          0.297
LGA    X    38_B      L      35          0.810
LGA    T    39_B      P      36          1.485
LGA    V    40_B      A      37          2.504
LGA    T    41_B      R      38          0.944
LGA    A    42_B      A      39          1.130
LGA    Q    43_B      D      40          1.374
LGA    X    44_B      L      41          1.496
LGA    L    45_B      V      42          1.519
LGA    N    46_B      N      43          1.907
LGA    G    47_B      S      44          1.721
LGA    H    48_B      R      45          0.852
LGA    Q    49_B      G      46          0.632
LGA    S    50_B      D      47          1.029
LGA    C    51_B      I      48          1.271
LGA    H    52_B      H      49          1.120
LGA    G    53_B      G      50          1.507
LGA    G    54_B      G      51          1.144
LGA    Q    55_B      T      52          0.574
LGA    L    56_B      L      53          0.676
LGA    F    57_B      M      54          0.609
LGA    S    58_B      S      55          0.532
LGA    L    59_B      V      56          0.955
LGA    A    60_B      L      57          0.458
LGA    D    61_B      D      58          0.593
LGA    T    62_B      F      59          1.076
LGA    A    63_B      T      60          0.653
LGA    F    64_B      L      61          0.986
LGA    A    65_B      G      62          2.085
LGA    Y    66_B      A      63          1.183
LGA    A    67_B      A      64          1.234
LGA    C    68_B      I      65          1.940
LGA    N    69_B      R      66          1.775
LGA    S    70_B      G      67          1.801
LGA    Q    71_B      D      68          2.848
LGA    G    72_B      T      69          2.360
LGA    -       -      P      70           -
LGA    -       -      E      71           -
LGA    L    73_B      V      72          1.479
LGA    A    74_B      G      73          0.660
LGA    A    75_B      V      74          1.115
LGA    V    76_B      A      75          0.900
LGA    A    77_B      T      76          0.882
LGA    S    78_B      I      77          0.548
LGA    A    79_B      D      78          0.859
LGA    C    80_B      M      79          1.247
LGA    T    81_B      N      80          0.368
LGA    I    82_B      T      81          0.303
LGA    D    83_B      S      82          0.186
LGA    F    84_B      F      83          0.571
LGA    L    85_B      M      84          0.665
LGA    R    86_B      S      85          0.745
LGA    P    87_B      P      86          0.822
LGA    G    88_B      G      87          1.320
LGA    F    89_B      R      88          2.521
LGA    A    90_B      -       -           -
LGA    G    91_B      -       -           -
LGA    D    92_B      G      89          0.732
LGA    T    93_B      D      90          0.841
LGA    L    94_B      L      91          0.593
LGA    T    95_B      V      92          0.659
LGA    A    96_B      I      93          0.778
LGA    T    97_B      E      94          0.419
LGA    A    98_B      T      95          0.691
LGA    Q    99_B      R      96          0.250
LGA    V   100_B      C      97          0.740
LGA    R   101_B      L      98          0.782
LGA    H   102_B      R      99          0.688
LGA    Q   103_B      R     100          0.643
LGA    G   104_B      G     101          0.941
LGA    K   105_B      A     102          1.004
LGA    Q   106_B      S     103          0.845
LGA    T   107_B      I     104          0.645
LGA    G   108_B      A     105          1.108
LGA    V   109_B      F     106          0.743
LGA    Y   110_B      C     107          0.666
LGA    D   111_B      E     108          0.793
LGA    I   112_B      G     109          0.865
LGA    E   113_B      E     110          0.697
LGA    I   114_B      I     111          0.536
LGA    V   115_B      R     112          0.617
LGA    N   116_B      D     113          0.710
LGA    Q   117_B      S     114          0.528
LGA    Q   118_B      A     115          0.349
LGA    Q   119_B      G     116          0.263
LGA    K   120_B      E     117          0.478
LGA    T   121_B      L     118          0.560
LGA    V   122_B      V     119          0.312
LGA    A   123_B      A     120          0.243
LGA    L   124_B      K     121          0.319
LGA    F   125_B      A     122          0.185
LGA    R   126_B      T     123          0.423
LGA    G   127_B      A     124          0.615
LGA    K   128_B      T     125          0.761
LGA    S   129_B      F     126          0.751
LGA    H   130_B      K     127          1.111
LGA    R   131_B      I     128          1.276
LGA    I   132_B      I     129          2.104
LGA    G   133_B      Q     130          2.540
LGA    G   134_B      -       -           -
LGA    T   135_B      -       -           -
LGA    I   136_B      -       -           -
LGA    T   137_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  138  125    5.0    121    1.42    19.01     91.881     7.938

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.664306 * X  +  -0.624314 * Y  +   0.411011 * Z  +  23.635231
  Y_new =  -0.331356 * X  +  -0.738866 * Y  +  -0.586754 * Z  + 131.207077
  Z_new =   0.670001 * X  +   0.253593 * Y  +  -0.697703 * Z  + 112.860420 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.792970   -0.348623  [ DEG:   160.0254    -19.9746 ]
  Theta =  -0.734210   -2.407382  [ DEG:   -42.0671   -137.9329 ]
  Phi   =  -0.462688    2.678905  [ DEG:   -26.5101    153.4899 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2fs2_B                                        
REMARK     2: T0479.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2fs2_B.T0479.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  138  125   5.0  121   1.42   19.01  91.881
REMARK  ---------------------------------------------------------- 
MOLECULE 2fs2_B
HEADER    HYDROLASE                               20-JAN-06   2FS2              
TITLE     STRUCTURE OF THE E. COLI PAAI PROTEIN FROM THE                        
TITLE    2 PHYENYLACETIC ACID DEGRADATION OPERON                                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PHENYLACETIC ACID DEGRADATION PROTEIN PAAI;                
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: PAAI;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: B834DE3;                                   
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: T7 PLASMID;                           
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: TOPO-ADAPTED C-TERM                       
SOURCE  10 HEXAHISTIDINE TAG                                                    
KEYWDS    T820, PHENYLACETIC ACID, DEGRADATION, OPERON, STRUCTURAL              
KEYWDS   2 GENOMICS, PSI, PROTEIN STRUCTURE INITIATIVE, NEW YORK                
KEYWDS   3 STRUCTURAL GENOMIX RESEARCH CONSORTIUM, NYSGXRC                      
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    R.KNIEWEL,J.A.BUGLINO,V.SOLORZANO,J.WU,C.D.LIMA,S.K.BURLEY,           
AUTHOR   2 NEW YORK STRUCTURAL GENOMIX RESEARCH CONSORTIUM (NYSGXRC)            
REVDAT   2   02-MAY-06 2FS2    1       JRNL                                     
REVDAT   1   07-FEB-06 2FS2    0                                                
JRNL        AUTH   F.SONG,Z.ZHUANG,L.FINCI,D.DUNAWAY-MARIANO,                   
JRNL        AUTH 2 R.KNIEWEL,J.A.BUGLINO,V.SOLORZANO,J.WU,C.D.LIMA              
JRNL        TITL   STRUCTURE, FUNCTION, AND MECHANISM OF THE                    
JRNL        TITL 2 PHENYLACETATE PATHWAY HOT DOG-FOLD THIOESTERASE              
JRNL        TITL 3 PAAI                                                         
JRNL        REF    J.BIOL.CHEM.                  V. 281 11028 2006              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  2FS2 A    2   140  UNP    P76084   PAAI_ECOLI       2    140             
DBREF  2FS2 B    2   140  UNP    P76084   PAAI_ECOLI       2    140             
SEQRES   1 A  151  SER LEU SER HIS LYS ALA TRP GLN ASN ALA HIS ALA MSE          
SEQRES   2 A  151  TYR GLU ASN ASP ALA CYS ALA LYS ALA LEU GLY ILE ASP          
SEQRES   3 A  151  ILE ILE SER MSE ASP GLU GLY PHE ALA VAL VAL THR MSE          
SEQRES   4 A  151  THR VAL THR ALA GLN MSE LEU ASN GLY HIS GLN SER CYS          
SEQRES   5 A  151  HIS GLY GLY GLN LEU PHE SER LEU ALA ASP THR ALA PHE          
SEQRES   6 A  151  ALA TYR ALA CYS ASN SER GLN GLY LEU ALA ALA VAL ALA          
SEQRES   7 A  151  SER ALA CYS THR ILE ASP PHE LEU ARG PRO GLY PHE ALA          
SEQRES   8 A  151  GLY ASP THR LEU THR ALA THR ALA GLN VAL ARG HIS GLN          
SEQRES   9 A  151  GLY LYS GLN THR GLY VAL TYR ASP ILE GLU ILE VAL ASN          
SEQRES  10 A  151  GLN GLN GLN LYS THR VAL ALA LEU PHE ARG GLY LYS SER          
SEQRES  11 A  151  HIS ARG ILE GLY GLY THR ILE THR GLY GLU ALA GLU GLY          
SEQRES  12 A  151  GLY SER HIS HIS HIS HIS HIS HIS                              
SEQRES   1 B  151  SER LEU SER HIS LYS ALA TRP GLN ASN ALA HIS ALA MSE          
SEQRES   2 B  151  TYR GLU ASN ASP ALA CYS ALA LYS ALA LEU GLY ILE ASP          
SEQRES   3 B  151  ILE ILE SER MSE ASP GLU GLY PHE ALA VAL VAL THR MSE          
SEQRES   4 B  151  THR VAL THR ALA GLN MSE LEU ASN GLY HIS GLN SER CYS          
SEQRES   5 B  151  HIS GLY GLY GLN LEU PHE SER LEU ALA ASP THR ALA PHE          
SEQRES   6 B  151  ALA TYR ALA CYS ASN SER GLN GLY LEU ALA ALA VAL ALA          
SEQRES   7 B  151  SER ALA CYS THR ILE ASP PHE LEU ARG PRO GLY PHE ALA          
SEQRES   8 B  151  GLY ASP THR LEU THR ALA THR ALA GLN VAL ARG HIS GLN          
SEQRES   9 B  151  GLY LYS GLN THR GLY VAL TYR ASP ILE GLU ILE VAL ASN          
SEQRES  10 B  151  GLN GLN GLN LYS THR VAL ALA LEU PHE ARG GLY LYS SER          
SEQRES  11 B  151  HIS ARG ILE GLY GLY THR ILE THR GLY GLU ALA GLU GLY          
SEQRES  12 B  151  GLY SER HIS HIS HIS HIS HIS HIS                              
HET    MSE  A  12       8                                                       
HET    MSE  A  29       8                                                       
HET    MSE  A  38       8                                                       
HET    MSE  A  44       8                                                       
HET    MSE  B  12       8                                                       
HET    MSE  B  29       8                                                       
HET    MSE  B  38       8                                                       
HET    MSE  B  44       8                                                       
HET    SO4    101       5                                                       
HET    SO4    102       5                                                       
HET    SO4    103       5                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     SO4 SULFATE ION                                                      
FORMUL   1  MSE    8(C5 H11 N O2 SE)                                            
FORMUL   3  SO4    3(O4 S 2-)                                                   
FORMUL   6  HOH   *79(H2 O)                                                     
CRYST1   69.847   69.847  117.168  90.00  90.00 120.00 P 31 2 1     12          
ATOM    990  N   SER B   0      31.090  42.479  22.412  1.00 43.60           N  
ATOM    991  CA  SER B   0      29.672  42.260  21.876  1.00 45.45           C  
ATOM    992  C   SER B   0      28.573  42.318  22.967  1.00 43.68           C  
ATOM    993  O   SER B   0      28.025  43.382  23.271  1.00 42.19           O  
ATOM    994  CB  SER B   0      29.576  40.897  21.192  1.00 47.43           C  
ATOM    995  OG  SER B   0      29.960  39.814  22.085  1.00 55.44           O  
ATOM    996  N   LEU B   1      28.268  41.162  23.568  1.00 41.27           N  
ATOM    997  CA  LEU B   1      27.467  41.150  24.816  1.00 39.20           C  
ATOM    998  C   LEU B   1      28.318  41.768  25.929  1.00 35.74           C  
ATOM    999  O   LEU B   1      27.838  42.468  26.772  1.00 35.29           O  
ATOM   1000  CB  LEU B   1      27.057  39.737  25.150  1.00 39.58           C  
ATOM   1001  CG  LEU B   1      25.961  39.149  24.267  1.00 44.39           C  
ATOM   1002  CD1 LEU B   1      25.669  37.700  24.781  1.00 49.38           C  
ATOM   1003  CD2 LEU B   1      24.745  40.022  24.279  1.00 44.74           C  
ATOM   1004  N   SER B   2      29.621  41.541  25.846  1.00 33.58           N  
ATOM   1005  CA  SER B   2      30.521  42.052  26.811  1.00 31.76           C  
ATOM   1006  C   SER B   2      30.678  43.527  26.607  1.00 31.00           C  
ATOM   1007  O   SER B   2      30.735  44.247  27.564  1.00 30.99           O  
ATOM   1008  CB  SER B   2      31.879  41.353  26.729  1.00 31.22           C  
ATOM   1009  OG  SER B   2      32.801  42.141  27.479  1.00 36.11           O  
ATOM   1010  N   HIS B   3      30.705  43.996  25.357  1.00 31.21           N  
ATOM   1011  CA  HIS B   3      30.784  45.445  25.138  1.00 31.77           C  
ATOM   1012  C   HIS B   3      29.532  46.163  25.674  1.00 30.88           C  
ATOM   1013  O   HIS B   3      29.614  47.251  26.203  1.00 31.08           O  
ATOM   1014  CB  HIS B   3      30.964  45.719  23.640  1.00 32.76           C  
ATOM   1015  CG  HIS B   3      31.119  47.159  23.319  1.00 36.67           C  
ATOM   1016  ND1 HIS B   3      32.288  47.836  23.549  1.00 37.82           N  
ATOM   1017  CD2 HIS B   3      30.255  48.051  22.758  1.00 41.10           C  
ATOM   1018  CE1 HIS B   3      32.137  49.099  23.170  1.00 48.66           C  
ATOM   1019  NE2 HIS B   3      30.907  49.257  22.695  1.00 45.99           N  
ATOM   1020  N   LYS B   4      28.371  45.520  25.602  1.00 31.67           N  
ATOM   1021  CA  LYS B   4      27.144  46.170  26.020  1.00 31.75           C  
ATOM   1022  C   LYS B   4      27.208  46.154  27.527  1.00 29.23           C  
ATOM   1023  O   LYS B   4      26.853  47.132  28.196  1.00 27.78           O  
ATOM   1024  CB  LYS B   4      25.954  45.366  25.542  1.00 33.34           C  
ATOM   1025  CG  LYS B   4      25.724  45.431  23.966  1.00 39.62           C  
ATOM   1026  CD  LYS B   4      24.333  44.668  23.583  1.00 50.52           C  
ATOM   1027  CE  LYS B   4      24.138  44.336  22.085  1.00 54.03           C  
ATOM   1028  NZ  LYS B   4      25.242  43.489  21.442  1.00 61.44           N  
ATOM   1029  N   ALA B   5      27.720  45.033  28.058  1.00 26.41           N  
ATOM   1030  CA  ALA B   5      27.789  44.918  29.519  1.00 23.68           C  
ATOM   1031  C   ALA B   5      28.659  46.053  30.019  1.00 21.75           C  
ATOM   1032  O   ALA B   5      28.342  46.657  30.995  1.00 22.32           O  
ATOM   1033  CB  ALA B   5      28.371  43.572  29.937  1.00 23.97           C  
ATOM   1034  N   TRP B   6      29.748  46.370  29.350  1.00 21.36           N  
ATOM   1035  CA  TRP B   6      30.603  47.419  29.872  1.00 22.95           C  
ATOM   1036  C   TRP B   6      30.038  48.805  29.707  1.00 22.63           C  
ATOM   1037  O   TRP B   6      30.304  49.713  30.517  1.00 23.83           O  
ATOM   1038  CB  TRP B   6      31.920  47.397  29.097  1.00 23.91           C  
ATOM   1039  CG  TRP B   6      33.052  46.605  29.726  1.00 21.61           C  
ATOM   1040  CD1 TRP B   6      33.537  45.434  29.310  1.00 21.88           C  
ATOM   1041  CD2 TRP B   6      33.815  46.963  30.908  1.00 16.22           C  
ATOM   1042  NE1 TRP B   6      34.550  45.028  30.154  1.00 17.08           N  
ATOM   1043  CE2 TRP B   6      34.730  45.974  31.120  1.00 15.70           C  
ATOM   1044  CE3 TRP B   6      33.780  48.043  31.802  1.00 20.32           C  
ATOM   1045  CZ2 TRP B   6      35.673  46.032  32.139  1.00 20.32           C  
ATOM   1046  CZ3 TRP B   6      34.744  48.123  32.819  1.00 15.01           C  
ATOM   1047  CH2 TRP B   6      35.680  47.132  32.944  1.00 16.90           C  
ATOM   1048  N   GLN B   7      29.312  49.032  28.633  1.00 25.36           N  
ATOM   1049  CA  GLN B   7      28.580  50.346  28.494  1.00 27.22           C  
ATOM   1050  C   GLN B   7      27.628  50.557  29.629  1.00 27.00           C  
ATOM   1051  O   GLN B   7      27.579  51.611  30.224  1.00 26.88           O  
ATOM   1052  CB  GLN B   7      27.747  50.375  27.192  1.00 28.42           C  
ATOM   1053  CG  GLN B   7      28.619  50.278  25.980  1.00 33.99           C  
ATOM   1054  CD  GLN B   7      27.885  50.614  24.744  1.00 44.99           C  
ATOM   1055  OE1 GLN B   7      28.184  51.644  24.137  1.00 56.10           O  
ATOM   1056  NE2 GLN B   7      26.921  49.787  24.346  1.00 46.78           N  
ATOM   1057  N   ASN B   8      26.842  49.515  29.947  1.00 26.82           N  
ATOM   1058  CA  ASN B   8      25.978  49.616  31.126  1.00 26.86           C  
ATOM   1059  C   ASN B   8      26.722  49.914  32.383  1.00 27.79           C  
ATOM   1060  O   ASN B   8      26.310  50.795  33.154  1.00 27.36           O  
ATOM   1061  CB  ASN B   8      25.144  48.324  31.267  1.00 26.21           C  
ATOM   1062  CG  ASN B   8      24.193  48.160  30.081  1.00 29.57           C  
ATOM   1063  OD1 ASN B   8      23.564  49.111  29.712  1.00 30.59           O  
ATOM   1064  ND2 ASN B   8      24.187  47.018  29.429  1.00 31.35           N  
ATOM   1065  N   ALA B   9      27.838  49.190  32.596  1.00 27.91           N  
ATOM   1066  CA  ALA B   9      28.610  49.429  33.777  1.00 28.26           C  
ATOM   1067  C   ALA B   9      29.229  50.792  33.813  1.00 29.90           C  
ATOM   1068  O   ALA B   9      29.260  51.365  34.940  1.00 30.28           O  
ATOM   1069  CB  ALA B   9      29.694  48.353  34.032  1.00 27.83           C  
ATOM   1070  N   HIS B  10      29.757  51.310  32.667  1.00 31.23           N  
ATOM   1071  CA  HIS B  10      30.270  52.694  32.680  1.00 31.93           C  
ATOM   1072  C   HIS B  10      29.177  53.727  33.018  1.00 32.91           C  
ATOM   1073  O   HIS B  10      29.424  54.657  33.744  1.00 34.57           O  
ATOM   1074  CB  HIS B  10      30.958  53.101  31.357  1.00 32.76           C  
ATOM   1075  CG  HIS B  10      32.303  52.462  31.175  1.00 32.84           C  
ATOM   1076  ND1 HIS B  10      32.738  51.985  29.964  1.00 32.11           N  
ATOM   1077  CD2 HIS B  10      33.250  52.111  32.083  1.00 31.42           C  
ATOM   1078  CE1 HIS B  10      33.921  51.414  30.119  1.00 33.80           C  
ATOM   1079  NE2 HIS B  10      34.245  51.474  31.399  1.00 33.22           N  
ATOM   1080  N   ALA B  11      27.971  53.559  32.474  1.00 34.03           N  
ATOM   1081  CA  ALA B  11      26.836  54.446  32.782  1.00 33.50           C  
ATOM   1082  C   ALA B  11      26.510  54.435  34.249  1.00 34.45           C  
ATOM   1083  O   ALA B  11      26.371  55.507  34.845  1.00 36.01           O  
ATOM   1084  CB  ALA B  11      25.598  54.035  31.976  1.00 32.50           C  
HETATM 1085  N   MSE B  12      26.419  53.247  34.855  1.00 33.93           N  
HETATM 1086  CA  MSE B  12      26.133  53.197  36.281  1.00 35.90           C  
HETATM 1087  C   MSE B  12      27.211  53.706  37.170  1.00 35.72           C  
HETATM 1088  O   MSE B  12      26.930  54.221  38.237  1.00 35.75           O  
HETATM 1089  CB  MSE B  12      25.898  51.765  36.729  1.00 35.36           C  
HETATM 1090  CG  MSE B  12      24.489  51.367  36.452  1.00 47.99           C  
HETATM 1091 SE   MSE B  12      24.418  49.410  36.764  1.00 66.64          SE  
HETATM 1092  CE  MSE B  12      24.206  48.794  34.896  1.00 64.82           C  
ATOM   1093  N   TYR B  13      28.458  53.447  36.805  1.00 37.22           N  
ATOM   1094  CA  TYR B  13      29.543  53.734  37.713  1.00 37.87           C  
ATOM   1095  C   TYR B  13      29.703  55.236  37.721  1.00 39.94           C  
ATOM   1096  O   TYR B  13      30.047  55.838  38.732  1.00 38.40           O  
ATOM   1097  CB  TYR B  13      30.810  53.112  37.174  1.00 37.35           C  
ATOM   1098  CG  TYR B  13      32.023  53.304  38.019  1.00 37.20           C  
ATOM   1099  CD1 TYR B  13      32.195  52.575  39.172  1.00 35.64           C  
ATOM   1100  CD2 TYR B  13      33.021  54.210  37.651  1.00 40.41           C  
ATOM   1101  CE1 TYR B  13      33.302  52.722  39.952  1.00 37.81           C  
ATOM   1102  CE2 TYR B  13      34.178  54.370  38.426  1.00 38.51           C  
ATOM   1103  CZ  TYR B  13      34.312  53.616  39.577  1.00 41.72           C  
ATOM   1104  OH  TYR B  13      35.457  53.701  40.372  1.00 41.09           O  
ATOM   1105  N   GLU B  14      29.439  55.841  36.577  1.00 43.25           N  
ATOM   1106  CA  GLU B  14      29.657  57.286  36.430  1.00 47.82           C  
ATOM   1107  C   GLU B  14      28.849  58.068  37.437  1.00 48.25           C  
ATOM   1108  O   GLU B  14      29.297  59.102  37.858  1.00 49.36           O  
ATOM   1109  CB  GLU B  14      29.391  57.778  34.994  1.00 50.21           C  
ATOM   1110  CG  GLU B  14      30.577  57.675  33.973  1.00 58.02           C  
ATOM   1111  CD  GLU B  14      31.858  56.933  34.474  1.00 68.53           C  
ATOM   1112  OE1 GLU B  14      32.660  57.539  35.265  1.00 71.21           O  
ATOM   1113  OE2 GLU B  14      32.097  55.741  34.063  1.00 71.62           O  
ATOM   1114  N   ASN B  15      27.703  57.559  37.880  1.00 49.12           N  
ATOM   1115  CA  ASN B  15      27.058  58.176  39.018  1.00 50.94           C  
ATOM   1116  C   ASN B  15      26.885  57.264  40.247  1.00 50.75           C  
ATOM   1117  O   ASN B  15      25.883  57.328  40.956  1.00 51.13           O  
ATOM   1118  CB  ASN B  15      25.735  58.810  38.603  1.00 52.36           C  
ATOM   1119  CG  ASN B  15      24.827  57.828  37.892  1.00 55.60           C  
ATOM   1120  OD1 ASN B  15      24.658  57.904  36.669  1.00 61.46           O  
ATOM   1121  ND2 ASN B  15      24.217  56.909  38.651  1.00 57.33           N  
ATOM   1122  N   ASP B  16      27.864  56.413  40.522  1.00 50.19           N  
ATOM   1123  CA  ASP B  16      27.814  55.586  41.738  1.00 48.41           C  
ATOM   1124  C   ASP B  16      28.692  56.174  42.808  1.00 46.90           C  
ATOM   1125  O   ASP B  16      29.864  55.802  42.880  1.00 45.69           O  
ATOM   1126  CB  ASP B  16      28.396  54.219  41.402  1.00 49.01           C  
ATOM   1127  CG  ASP B  16      28.001  53.134  42.379  1.00 49.86           C  
ATOM   1128  OD1 ASP B  16      27.860  53.389  43.610  1.00 47.12           O  
ATOM   1129  OD2 ASP B  16      27.890  51.950  41.968  1.00 50.94           O  
ATOM   1130  N   ALA B  17      28.163  57.055  43.655  1.00 45.72           N  
ATOM   1131  CA  ALA B  17      29.032  57.656  44.696  1.00 45.17           C  
ATOM   1132  C   ALA B  17      29.426  56.714  45.838  1.00 44.74           C  
ATOM   1133  O   ALA B  17      30.516  56.898  46.380  1.00 44.04           O  
ATOM   1134  CB  ALA B  17      28.462  58.994  45.280  1.00 46.24           C  
ATOM   1135  N   CYS B  18      28.581  55.746  46.211  1.00 42.14           N  
ATOM   1136  CA  CYS B  18      29.016  54.751  47.190  1.00 44.00           C  
ATOM   1137  C   CYS B  18      30.274  53.977  46.728  1.00 41.82           C  
ATOM   1138  O   CYS B  18      31.224  53.824  47.523  1.00 40.74           O  
ATOM   1139  CB  CYS B  18      27.880  53.790  47.533  1.00 43.93           C  
ATOM   1140  SG  CYS B  18      28.410  52.134  48.188  1.00 60.52           S  
ATOM   1141  N   ALA B  19      30.279  53.513  45.449  1.00 41.07           N  
ATOM   1142  CA  ALA B  19      31.405  52.768  44.840  1.00 39.01           C  
ATOM   1143  C   ALA B  19      32.617  53.622  44.814  1.00 38.81           C  
ATOM   1144  O   ALA B  19      33.675  53.198  45.263  1.00 36.56           O  
ATOM   1145  CB  ALA B  19      31.101  52.308  43.432  1.00 38.21           C  
ATOM   1146  N   LYS B  20      32.477  54.839  44.291  1.00 39.36           N  
ATOM   1147  CA  LYS B  20      33.619  55.759  44.331  1.00 42.13           C  
ATOM   1148  C   LYS B  20      34.114  56.092  45.783  1.00 41.87           C  
ATOM   1149  O   LYS B  20      35.329  56.041  46.033  1.00 42.78           O  
ATOM   1150  CB  LYS B  20      33.419  57.001  43.440  1.00 42.72           C  
ATOM   1151  CG  LYS B  20      32.919  56.691  42.001  1.00 47.63           C  
ATOM   1152  CD  LYS B  20      32.971  58.003  41.160  1.00 55.56           C  
ATOM   1153  CE  LYS B  20      32.071  57.992  39.868  1.00 57.13           C  
ATOM   1154  NZ  LYS B  20      30.751  58.767  40.091  1.00 58.99           N  
ATOM   1155  N   ALA B  21      33.208  56.305  46.745  1.00 40.75           N  
ATOM   1156  CA  ALA B  21      33.597  56.592  48.143  1.00 40.39           C  
ATOM   1157  C   ALA B  21      34.341  55.435  48.763  1.00 40.34           C  
ATOM   1158  O   ALA B  21      35.234  55.644  49.586  1.00 41.05           O  
ATOM   1159  CB  ALA B  21      32.378  56.892  49.014  1.00 39.99           C  
ATOM   1160  N   LEU B  22      33.942  54.209  48.427  1.00 38.28           N  
ATOM   1161  CA  LEU B  22      34.655  53.065  48.956  1.00 37.87           C  
ATOM   1162  C   LEU B  22      35.892  52.614  48.123  1.00 36.84           C  
ATOM   1163  O   LEU B  22      36.529  51.629  48.537  1.00 36.77           O  
ATOM   1164  CB  LEU B  22      33.716  51.900  49.078  1.00 38.31           C  
ATOM   1165  CG  LEU B  22      32.713  52.050  50.194  1.00 41.90           C  
ATOM   1166  CD1 LEU B  22      31.515  51.178  49.721  1.00 46.18           C  
ATOM   1167  CD2 LEU B  22      33.277  51.478  51.442  1.00 43.51           C  
ATOM   1168  N   GLY B  23      36.210  53.329  47.008  1.00 33.38           N  
ATOM   1169  CA  GLY B  23      37.291  52.991  46.112  1.00 30.53           C  
ATOM   1170  C   GLY B  23      37.063  51.726  45.288  1.00 30.38           C  
ATOM   1171  O   GLY B  23      38.001  51.020  44.960  1.00 29.71           O  
ATOM   1172  N   ILE B  24      35.818  51.390  44.972  1.00 29.23           N  
ATOM   1173  CA  ILE B  24      35.569  50.214  44.149  1.00 30.37           C  
ATOM   1174  C   ILE B  24      35.890  50.531  42.688  1.00 30.86           C  
ATOM   1175  O   ILE B  24      35.484  51.573  42.179  1.00 32.66           O  
ATOM   1176  CB  ILE B  24      34.090  49.674  44.394  1.00 28.85           C  
ATOM   1177  CG1 ILE B  24      33.958  49.399  45.841  1.00 27.63           C  
ATOM   1178  CG2 ILE B  24      33.809  48.377  43.708  1.00 28.52           C  
ATOM   1179  CD1 ILE B  24      32.662  48.888  46.268  1.00 32.08           C  
ATOM   1180  N   ASP B  25      36.682  49.670  42.064  1.00 29.66           N  
ATOM   1181  CA  ASP B  25      36.928  49.735  40.671  1.00 29.41           C  
ATOM   1182  C   ASP B  25      36.323  48.535  39.917  1.00 27.22           C  
ATOM   1183  O   ASP B  25      36.305  47.413  40.431  1.00 26.25           O  
ATOM   1184  CB  ASP B  25      38.414  49.722  40.481  1.00 30.72           C  
ATOM   1185  CG  ASP B  25      39.073  50.993  41.027  1.00 40.78           C  
ATOM   1186  OD1 ASP B  25      38.704  52.096  40.539  1.00 47.59           O  
ATOM   1187  OD2 ASP B  25      39.961  50.987  41.949  1.00 49.12           O  
ATOM   1188  N   ILE B  26      35.829  48.748  38.696  1.00 25.26           N  
ATOM   1189  CA  ILE B  26      35.397  47.609  37.935  1.00 25.55           C  
ATOM   1190  C   ILE B  26      36.468  47.173  37.024  1.00 24.50           C  
ATOM   1191  O   ILE B  26      36.981  47.975  36.286  1.00 24.23           O  
ATOM   1192  CB  ILE B  26      34.215  47.896  37.054  1.00 26.55           C  
ATOM   1193  CG1 ILE B  26      33.114  48.481  37.865  1.00 28.54           C  
ATOM   1194  CG2 ILE B  26      33.699  46.578  36.475  1.00 25.14           C  
ATOM   1195  CD1 ILE B  26      32.476  49.588  37.054  1.00 31.73           C  
ATOM   1196  N   ILE B  27      36.747  45.875  37.030  1.00 22.41           N  
ATOM   1197  CA  ILE B  27      37.838  45.286  36.227  1.00 22.06           C  
ATOM   1198  C   ILE B  27      37.375  44.257  35.230  1.00 21.28           C  
ATOM   1199  O   ILE B  27      38.112  43.924  34.324  1.00 21.66           O  
ATOM   1200  CB  ILE B  27      39.019  44.703  37.117  1.00 21.88           C  
ATOM   1201  CG1 ILE B  27      38.572  43.465  37.895  1.00 21.89           C  
ATOM   1202  CG2 ILE B  27      39.456  45.844  38.111  1.00 19.86           C  
ATOM   1203  CD1 ILE B  27      39.828  42.701  38.647  1.00 22.05           C  
ATOM   1204  N   SER B  28      36.165  43.747  35.346  1.00 19.71           N  
ATOM   1205  CA  SER B  28      35.788  42.821  34.304  1.00 19.67           C  
ATOM   1206  C   SER B  28      34.246  42.789  34.161  1.00 18.44           C  
ATOM   1207  O   SER B  28      33.539  43.001  35.131  1.00 18.21           O  
ATOM   1208  CB  SER B  28      36.436  41.458  34.558  1.00 19.44           C  
ATOM   1209  OG  SER B  28      35.996  40.483  33.530  1.00 25.16           O  
HETATM 1210  N   MSE B  29      33.746  42.558  32.964  1.00 19.19           N  
HETATM 1211  CA  MSE B  29      32.288  42.705  32.671  1.00 20.38           C  
HETATM 1212  C   MSE B  29      31.905  41.812  31.525  1.00 21.73           C  
HETATM 1213  O   MSE B  29      32.547  41.765  30.488  1.00 23.24           O  
HETATM 1214  CB  MSE B  29      31.845  44.135  32.227  1.00 21.84           C  
HETATM 1215  CG  MSE B  29      31.847  45.218  33.233  1.00 22.59           C  
HETATM 1216 SE   MSE B  29      30.620  44.774  34.832  1.00 40.61          SE  
HETATM 1217  CE  MSE B  29      28.884  44.216  33.880  1.00 21.33           C  
ATOM   1218  N   ASP B  30      30.884  41.036  31.712  1.00 21.28           N  
ATOM   1219  CA  ASP B  30      30.335  40.301  30.598  1.00 20.94           C  
ATOM   1220  C   ASP B  30      28.848  40.169  30.885  1.00 18.29           C  
ATOM   1221  O   ASP B  30      28.391  40.569  31.930  1.00 16.54           O  
ATOM   1222  CB  ASP B  30      30.964  38.924  30.510  1.00 20.62           C  
ATOM   1223  CG  ASP B  30      30.904  38.320  29.129  1.00 27.37           C  
ATOM   1224  OD1 ASP B  30      30.349  38.910  28.075  1.00 32.87           O  
ATOM   1225  OD2 ASP B  30      31.423  37.184  29.013  1.00 33.63           O  
ATOM   1226  N   GLU B  31      28.067  39.571  29.996  1.00 20.77           N  
ATOM   1227  CA  GLU B  31      26.637  39.559  30.293  1.00 21.98           C  
ATOM   1228  C   GLU B  31      26.430  38.633  31.526  1.00 20.22           C  
ATOM   1229  O   GLU B  31      26.903  37.544  31.468  1.00 20.70           O  
ATOM   1230  CB  GLU B  31      25.987  38.885  29.128  1.00 23.85           C  
ATOM   1231  CG  GLU B  31      24.525  38.656  29.409  1.00 30.15           C  
ATOM   1232  CD  GLU B  31      23.774  38.210  28.126  1.00 41.34           C  
ATOM   1233  OE1 GLU B  31      24.277  37.210  27.550  1.00 42.36           O  
ATOM   1234  OE2 GLU B  31      22.730  38.882  27.693  1.00 44.01           O  
ATOM   1235  N   GLY B  32      25.769  39.064  32.594  1.00 19.86           N  
ATOM   1236  CA  GLY B  32      25.581  38.225  33.776  1.00 18.96           C  
ATOM   1237  C   GLY B  32      26.879  38.086  34.613  1.00 20.34           C  
ATOM   1238  O   GLY B  32      27.014  37.093  35.378  1.00 21.86           O  
ATOM   1239  N   PHE B  33      27.844  39.017  34.503  1.00 18.39           N  
ATOM   1240  CA  PHE B  33      29.146  38.717  35.078  1.00 19.49           C  
ATOM   1241  C   PHE B  33      29.838  40.017  35.359  1.00 20.43           C  
ATOM   1242  O   PHE B  33      29.948  40.839  34.409  1.00 22.01           O  
ATOM   1243  CB  PHE B  33      29.997  37.848  34.140  1.00 18.03           C  
ATOM   1244  CG  PHE B  33      31.400  37.545  34.673  1.00 22.43           C  
ATOM   1245  CD1 PHE B  33      31.615  36.470  35.622  1.00 13.02           C  
ATOM   1246  CD2 PHE B  33      32.508  38.295  34.235  1.00 16.43           C  
ATOM   1247  CE1 PHE B  33      32.967  36.212  36.135  1.00 17.39           C  
ATOM   1248  CE2 PHE B  33      33.823  38.041  34.761  1.00 19.53           C  
ATOM   1249  CZ  PHE B  33      34.067  36.968  35.708  1.00 17.48           C  
ATOM   1250  N   ALA B  34      30.418  40.163  36.566  1.00 19.85           N  
ATOM   1251  CA  ALA B  34      31.176  41.419  36.916  1.00 21.13           C  
ATOM   1252  C   ALA B  34      32.208  41.085  37.995  1.00 21.77           C  
ATOM   1253  O   ALA B  34      31.927  40.235  38.843  1.00 23.08           O  
ATOM   1254  CB  ALA B  34      30.199  42.500  37.484  1.00 19.78           C  
ATOM   1255  N   VAL B  35      33.342  41.774  38.002  1.00 20.09           N  
ATOM   1256  CA  VAL B  35      34.449  41.582  38.924  1.00 20.34           C  
ATOM   1257  C   VAL B  35      34.805  42.978  39.321  1.00 22.29           C  
ATOM   1258  O   VAL B  35      34.963  43.884  38.429  1.00 22.93           O  
ATOM   1259  CB  VAL B  35      35.678  40.868  38.289  1.00 21.70           C  
ATOM   1260  CG1 VAL B  35      36.860  40.766  39.261  1.00 19.13           C  
ATOM   1261  CG2 VAL B  35      35.390  39.494  37.815  1.00 21.34           C  
ATOM   1262  N   VAL B  36      34.864  43.235  40.622  1.00 21.99           N  
ATOM   1263  CA  VAL B  36      35.152  44.547  41.082  1.00 22.30           C  
ATOM   1264  C   VAL B  36      36.156  44.325  42.176  1.00 23.77           C  
ATOM   1265  O   VAL B  36      36.349  43.211  42.668  1.00 23.50           O  
ATOM   1266  CB  VAL B  36      33.860  45.334  41.607  1.00 22.55           C  
ATOM   1267  CG1 VAL B  36      32.864  45.650  40.434  1.00 20.00           C  
ATOM   1268  CG2 VAL B  36      33.098  44.475  42.760  1.00 22.87           C  
ATOM   1269  N   THR B  37      36.781  45.410  42.565  1.00 24.47           N  
ATOM   1270  CA  THR B  37      37.970  45.362  43.389  1.00 29.14           C  
ATOM   1271  C   THR B  37      37.990  46.529  44.394  1.00 28.85           C  
ATOM   1272  O   THR B  37      37.415  47.565  44.141  1.00 28.05           O  
ATOM   1273  CB  THR B  37      39.155  45.389  42.430  1.00 30.94           C  
ATOM   1274  OG1 THR B  37      40.260  44.717  43.050  1.00 40.26           O  
ATOM   1275  CG2 THR B  37      39.594  46.804  42.216  1.00 29.57           C  
HETATM 1276  N   MSE B  38      38.563  46.337  45.560  1.00 29.16           N  
HETATM 1277  CA  MSE B  38      38.591  47.388  46.568  1.00 31.10           C  
HETATM 1278  C   MSE B  38      39.727  47.088  47.521  1.00 29.93           C  
HETATM 1279  O   MSE B  38      39.978  45.942  47.841  1.00 29.12           O  
HETATM 1280  CB  MSE B  38      37.263  47.355  47.356  1.00 32.22           C  
HETATM 1281  CG  MSE B  38      37.299  48.172  48.631  1.00 40.43           C  
HETATM 1282 SE   MSE B  38      35.614  47.872  49.645  1.00 61.58          SE  
HETATM 1283  CE  MSE B  38      34.713  49.259  48.874  1.00 57.03           C  
ATOM   1284  N   THR B  39      40.377  48.111  48.013  1.00 30.61           N  
ATOM   1285  CA  THR B  39      41.407  47.932  49.026  1.00 32.30           C  
ATOM   1286  C   THR B  39      40.827  48.306  50.387  1.00 32.79           C  
ATOM   1287  O   THR B  39      40.082  49.259  50.515  1.00 32.81           O  
ATOM   1288  CB  THR B  39      42.633  48.767  48.591  1.00 33.96           C  
ATOM   1289  OG1 THR B  39      43.123  48.206  47.328  1.00 33.17           O  
ATOM   1290  CG2 THR B  39      43.840  48.672  49.610  1.00 31.64           C  
ATOM   1291  N   VAL B  40      41.070  47.484  51.396  1.00 33.80           N  
ATOM   1292  CA  VAL B  40      40.637  47.784  52.764  1.00 33.78           C  
ATOM   1293  C   VAL B  40      41.651  48.812  53.335  1.00 37.70           C  
ATOM   1294  O   VAL B  40      42.851  48.514  53.389  1.00 35.54           O  
ATOM   1295  CB  VAL B  40      40.725  46.512  53.559  1.00 34.36           C  
ATOM   1296  CG1 VAL B  40      40.412  46.778  55.036  1.00 32.02           C  
ATOM   1297  CG2 VAL B  40      39.825  45.416  52.890  1.00 30.22           C  
ATOM   1298  N   THR B  41      41.152  50.022  53.605  1.00 40.53           N  
ATOM   1299  CA  THR B  41      41.776  51.119  54.336  1.00 44.51           C  
ATOM   1300  C   THR B  41      41.422  51.072  55.832  1.00 46.51           C  
ATOM   1301  O   THR B  41      40.424  50.413  56.249  1.00 46.66           O  
ATOM   1302  CB  THR B  41      41.202  52.415  53.795  1.00 43.99           C  
ATOM   1303  OG1 THR B  41      39.772  52.394  53.963  1.00 44.62           O  
ATOM   1304  CG2 THR B  41      41.392  52.503  52.312  1.00 44.56           C  
ATOM   1305  N   ALA B  42      42.188  51.799  56.652  1.00 50.53           N  
ATOM   1306  CA  ALA B  42      42.003  51.757  58.134  1.00 52.96           C  
ATOM   1307  C   ALA B  42      40.605  52.251  58.626  1.00 54.44           C  
ATOM   1308  O   ALA B  42      40.000  51.684  59.571  1.00 55.83           O  
ATOM   1309  CB  ALA B  42      43.137  52.498  58.851  1.00 53.99           C  
ATOM   1310  N   GLN B  43      40.108  53.282  57.953  1.00 54.69           N  
ATOM   1311  CA  GLN B  43      38.763  53.801  58.095  1.00 55.83           C  
ATOM   1312  C   GLN B  43      37.670  52.711  58.088  1.00 56.07           C  
ATOM   1313  O   GLN B  43      36.578  52.911  58.616  1.00 56.92           O  
ATOM   1314  CB  GLN B  43      38.501  54.775  56.932  1.00 56.55           C  
ATOM   1315  CG  GLN B  43      39.562  55.888  56.710  1.00 60.81           C  
ATOM   1316  CD  GLN B  43      40.760  55.485  55.820  1.00 65.28           C  
ATOM   1317  OE1 GLN B  43      41.753  54.902  56.305  1.00 66.59           O  
ATOM   1318  NE2 GLN B  43      40.676  55.818  54.522  1.00 65.56           N  
HETATM 1319  N   MSE B  44      37.917  51.553  57.518  1.00 55.24           N  
HETATM 1320  CA  MSE B  44      36.801  50.579  57.433  1.00 56.20           C  
HETATM 1321  C   MSE B  44      36.777  49.503  58.514  1.00 54.89           C  
HETATM 1322  O   MSE B  44      35.869  48.651  58.522  1.00 54.36           O  
HETATM 1323  CB  MSE B  44      36.729  49.892  56.056  1.00 56.50           C  
HETATM 1324  CG  MSE B  44      37.392  50.672  54.944  1.00 61.21           C  
HETATM 1325 SE   MSE B  44      37.135  49.816  53.203  1.00 75.22          SE  
HETATM 1326  CE  MSE B  44      36.812  48.022  53.815  1.00 67.62           C  
ATOM   1327  N   LEU B  45      37.767  49.557  59.408  1.00 54.52           N  
ATOM   1328  CA  LEU B  45      38.008  48.533  60.448  1.00 54.42           C  
ATOM   1329  C   LEU B  45      37.185  48.640  61.766  1.00 54.05           C  
ATOM   1330  O   LEU B  45      36.960  49.716  62.296  1.00 52.68           O  
ATOM   1331  CB  LEU B  45      39.512  48.522  60.804  1.00 54.51           C  
ATOM   1332  CG  LEU B  45      40.583  48.355  59.724  1.00 57.75           C  
ATOM   1333  CD1 LEU B  45      41.997  48.441  60.417  1.00 59.78           C  
ATOM   1334  CD2 LEU B  45      40.431  47.033  58.930  1.00 54.07           C  
ATOM   1335  N   ASN B  46      36.775  47.488  62.286  1.00 55.34           N  
ATOM   1336  CA  ASN B  46      36.187  47.331  63.613  1.00 56.53           C  
ATOM   1337  C   ASN B  46      37.268  47.166  64.699  1.00 58.40           C  
ATOM   1338  O   ASN B  46      38.465  47.381  64.434  1.00 58.09           O  
ATOM   1339  CB  ASN B  46      35.378  46.060  63.607  1.00 55.56           C  
ATOM   1340  CG  ASN B  46      36.247  44.841  63.337  1.00 57.19           C  
ATOM   1341  OD1 ASN B  46      37.455  44.785  63.705  1.00 55.05           O  
ATOM   1342  ND2 ASN B  46      35.663  43.867  62.658  1.00 60.36           N  
ATOM   1343  N   GLY B  47      36.841  46.688  65.877  1.00 59.85           N  
ATOM   1344  CA  GLY B  47      37.683  46.532  67.059  1.00 62.07           C  
ATOM   1345  C   GLY B  47      38.725  45.428  67.072  1.00 63.95           C  
ATOM   1346  O   GLY B  47      39.537  45.323  68.010  1.00 64.64           O  
ATOM   1347  N   HIS B  48      38.732  44.622  66.014  1.00 64.87           N  
ATOM   1348  CA  HIS B  48      39.699  43.525  65.848  1.00 65.74           C  
ATOM   1349  C   HIS B  48      40.708  43.835  64.679  1.00 63.74           C  
ATOM   1350  O   HIS B  48      41.567  43.011  64.341  1.00 63.13           O  
ATOM   1351  CB  HIS B  48      38.898  42.202  65.714  1.00 67.02           C  
ATOM   1352  CG  HIS B  48      37.462  42.345  66.157  1.00 73.30           C  
ATOM   1353  ND1 HIS B  48      37.104  42.556  67.481  1.00 79.49           N  
ATOM   1354  CD2 HIS B  48      36.300  42.380  65.449  1.00 78.13           C  
ATOM   1355  CE1 HIS B  48      35.787  42.692  67.567  1.00 80.72           C  
ATOM   1356  NE2 HIS B  48      35.275  42.590  66.350  1.00 80.88           N  
ATOM   1357  N   GLN B  49      40.597  45.077  64.172  1.00 62.17           N  
ATOM   1358  CA  GLN B  49      41.354  45.728  63.066  1.00 60.72           C  
ATOM   1359  C   GLN B  49      41.012  45.058  61.740  1.00 58.81           C  
ATOM   1360  O   GLN B  49      41.847  44.947  60.831  1.00 58.41           O  
ATOM   1361  CB  GLN B  49      42.873  45.804  63.282  1.00 61.47           C  
ATOM   1362  CG  GLN B  49      43.403  46.541  64.533  1.00 67.08           C  
ATOM   1363  CD  GLN B  49      44.728  45.879  65.050  1.00 74.95           C  
ATOM   1364  OE1 GLN B  49      45.839  46.186  64.551  1.00 76.31           O  
ATOM   1365  NE2 GLN B  49      44.598  44.943  66.012  1.00 74.86           N  
ATOM   1366  N   SER B  50      39.748  44.639  61.664  1.00 56.23           N  
ATOM   1367  CA  SER B  50      39.187  43.830  60.603  1.00 53.07           C  
ATOM   1368  C   SER B  50      38.121  44.632  59.914  1.00 51.08           C  
ATOM   1369  O   SER B  50      37.469  45.447  60.562  1.00 50.85           O  
ATOM   1370  CB  SER B  50      38.490  42.663  61.249  1.00 52.99           C  
ATOM   1371  OG  SER B  50      38.541  41.577  60.375  1.00 55.14           O  
ATOM   1372  N   CYS B  51      37.919  44.389  58.619  1.00 47.40           N  
ATOM   1373  CA  CYS B  51      36.945  45.141  57.845  1.00 45.32           C  
ATOM   1374  C   CYS B  51      35.527  44.913  58.429  1.00 44.93           C  
ATOM   1375  O   CYS B  51      35.173  43.780  58.850  1.00 43.55           O  
ATOM   1376  CB  CYS B  51      37.001  44.757  56.354  1.00 43.45           C  
ATOM   1377  SG  CYS B  51      35.942  45.780  55.290  1.00 46.52           S  
ATOM   1378  N   HIS B  52      34.749  45.992  58.474  1.00 42.97           N  
ATOM   1379  CA  HIS B  52      33.325  45.907  58.821  1.00 42.80           C  
ATOM   1380  C   HIS B  52      32.506  45.174  57.766  1.00 41.02           C  
ATOM   1381  O   HIS B  52      32.787  45.274  56.544  1.00 37.43           O  
ATOM   1382  CB  HIS B  52      32.721  47.298  59.027  1.00 42.93           C  
ATOM   1383  CG  HIS B  52      32.908  47.815  60.421  1.00 50.15           C  
ATOM   1384  ND1 HIS B  52      32.381  47.169  61.535  1.00 55.54           N  
ATOM   1385  CD2 HIS B  52      33.615  48.881  60.895  1.00 52.33           C  
ATOM   1386  CE1 HIS B  52      32.730  47.837  62.628  1.00 55.70           C  
ATOM   1387  NE2 HIS B  52      33.482  48.875  62.268  1.00 53.42           N  
ATOM   1388  N   GLY B  53      31.493  44.451  58.278  1.00 38.70           N  
ATOM   1389  CA  GLY B  53      30.541  43.725  57.456  1.00 37.84           C  
ATOM   1390  C   GLY B  53      29.845  44.601  56.406  1.00 36.20           C  
ATOM   1391  O   GLY B  53      29.727  44.212  55.274  1.00 36.60           O  
ATOM   1392  N   GLY B  54      29.371  45.757  56.801  1.00 34.18           N  
ATOM   1393  CA  GLY B  54      28.689  46.611  55.874  1.00 35.30           C  
ATOM   1394  C   GLY B  54      29.522  47.005  54.688  1.00 34.68           C  
ATOM   1395  O   GLY B  54      28.947  47.200  53.624  1.00 34.61           O  
ATOM   1396  N   GLN B  55      30.845  47.109  54.866  1.00 33.45           N  
ATOM   1397  CA  GLN B  55      31.749  47.438  53.742  1.00 33.36           C  
ATOM   1398  C   GLN B  55      31.925  46.221  52.854  1.00 30.66           C  
ATOM   1399  O   GLN B  55      32.034  46.366  51.650  1.00 29.87           O  
ATOM   1400  CB  GLN B  55      33.146  47.904  54.227  1.00 35.05           C  
ATOM   1401  CG  GLN B  55      33.304  49.458  54.529  1.00 38.96           C  
ATOM   1402  CD  GLN B  55      32.984  49.858  56.027  1.00 45.17           C  
ATOM   1403  OE1 GLN B  55      32.237  49.144  56.717  1.00 46.30           O  
ATOM   1404  NE2 GLN B  55      33.530  51.023  56.497  1.00 47.05           N  
ATOM   1405  N   LEU B  56      32.054  45.048  53.480  1.00 28.29           N  
ATOM   1406  CA  LEU B  56      32.100  43.813  52.768  1.00 27.86           C  
ATOM   1407  C   LEU B  56      30.780  43.580  52.071  1.00 27.71           C  
ATOM   1408  O   LEU B  56      30.804  43.308  50.885  1.00 27.75           O  
ATOM   1409  CB  LEU B  56      32.295  42.671  53.714  1.00 28.65           C  
ATOM   1410  CG  LEU B  56      33.700  42.341  54.117  1.00 31.10           C  
ATOM   1411  CD1 LEU B  56      33.723  40.909  54.669  1.00 29.14           C  
ATOM   1412  CD2 LEU B  56      34.635  42.534  52.903  1.00 26.55           C  
ATOM   1413  N   PHE B  57      29.642  43.719  52.786  1.00 27.01           N  
ATOM   1414  CA  PHE B  57      28.334  43.602  52.160  1.00 25.82           C  
ATOM   1415  C   PHE B  57      28.287  44.573  50.959  1.00 25.03           C  
ATOM   1416  O   PHE B  57      27.819  44.238  49.901  1.00 25.13           O  
ATOM   1417  CB  PHE B  57      27.181  43.892  53.156  1.00 24.16           C  
ATOM   1418  CG  PHE B  57      25.803  43.879  52.507  1.00 25.10           C  
ATOM   1419  CD1 PHE B  57      25.083  42.735  52.422  1.00 29.38           C  
ATOM   1420  CD2 PHE B  57      25.280  44.999  51.905  1.00 26.53           C  
ATOM   1421  CE1 PHE B  57      23.848  42.711  51.744  1.00 27.76           C  
ATOM   1422  CE2 PHE B  57      24.050  44.980  51.236  1.00 28.18           C  
ATOM   1423  CZ  PHE B  57      23.342  43.852  51.174  1.00 26.38           C  
ATOM   1424  N   SER B  58      28.838  45.755  51.094  1.00 25.66           N  
ATOM   1425  CA  SER B  58      28.705  46.763  50.031  1.00 26.65           C  
ATOM   1426  C   SER B  58      29.496  46.429  48.810  1.00 27.07           C  
ATOM   1427  O   SER B  58      29.037  46.704  47.654  1.00 28.78           O  
ATOM   1428  CB  SER B  58      29.159  48.129  50.485  1.00 27.24           C  
ATOM   1429  OG  SER B  58      28.306  48.540  51.523  1.00 30.69           O  
ATOM   1430  N   LEU B  59      30.632  45.775  49.030  1.00 22.52           N  
ATOM   1431  CA  LEU B  59      31.387  45.336  47.948  1.00 21.25           C  
ATOM   1432  C   LEU B  59      30.660  44.229  47.184  1.00 20.73           C  
ATOM   1433  O   LEU B  59      30.735  44.162  45.958  1.00 17.07           O  
ATOM   1434  CB  LEU B  59      32.752  44.821  48.464  1.00 22.16           C  
ATOM   1435  CG  LEU B  59      33.707  44.153  47.459  1.00 24.23           C  
ATOM   1436  CD1 LEU B  59      34.108  45.143  46.311  1.00 22.25           C  
ATOM   1437  CD2 LEU B  59      34.999  43.699  48.192  1.00 23.66           C  
ATOM   1438  N   ALA B  60      30.038  43.284  47.923  1.00 19.53           N  
ATOM   1439  CA  ALA B  60      29.380  42.168  47.267  1.00 20.56           C  
ATOM   1440  C   ALA B  60      28.155  42.685  46.466  1.00 20.51           C  
ATOM   1441  O   ALA B  60      27.884  42.229  45.367  1.00 23.22           O  
ATOM   1442  CB  ALA B  60      28.956  41.061  48.326  1.00 19.34           C  
ATOM   1443  N   ASP B  61      27.513  43.690  46.977  1.00 22.91           N  
ATOM   1444  CA  ASP B  61      26.249  44.200  46.495  1.00 25.51           C  
ATOM   1445  C   ASP B  61      26.566  45.030  45.302  1.00 25.51           C  
ATOM   1446  O   ASP B  61      25.755  45.154  44.392  1.00 25.46           O  
ATOM   1447  CB  ASP B  61      25.664  45.102  47.598  1.00 26.81           C  
ATOM   1448  CG  ASP B  61      24.249  45.635  47.279  1.00 35.86           C  
ATOM   1449  OD1 ASP B  61      23.436  44.936  46.576  1.00 45.45           O  
ATOM   1450  OD2 ASP B  61      23.833  46.728  47.733  1.00 44.55           O  
ATOM   1451  N   THR B  62      27.771  45.588  45.270  1.00 23.54           N  
ATOM   1452  CA  THR B  62      28.184  46.296  44.074  1.00 23.33           C  
ATOM   1453  C   THR B  62      28.476  45.330  42.912  1.00 23.47           C  
ATOM   1454  O   THR B  62      28.078  45.613  41.766  1.00 25.98           O  
ATOM   1455  CB  THR B  62      29.438  47.134  44.383  1.00 22.35           C  
ATOM   1456  OG1 THR B  62      29.121  48.104  45.383  1.00 24.78           O  
ATOM   1457  CG2 THR B  62      29.818  47.972  43.233  1.00 25.24           C  
ATOM   1458  N   ALA B  63      29.230  44.227  43.122  1.00 22.59           N  
ATOM   1459  CA  ALA B  63      29.425  43.297  42.046  1.00 20.99           C  
ATOM   1460  C   ALA B  63      28.065  42.738  41.623  1.00 21.84           C  
ATOM   1461  O   ALA B  63      27.810  42.478  40.467  1.00 21.22           O  
ATOM   1462  CB  ALA B  63      30.382  42.061  42.491  1.00 22.24           C  
ATOM   1463  N   PHE B  64      27.224  42.482  42.603  1.00 21.09           N  
ATOM   1464  CA  PHE B  64      25.885  42.012  42.286  1.00 21.71           C  
ATOM   1465  C   PHE B  64      25.032  43.029  41.356  1.00 20.54           C  
ATOM   1466  O   PHE B  64      24.398  42.599  40.389  1.00 19.91           O  
ATOM   1467  CB  PHE B  64      25.218  41.780  43.644  1.00 22.79           C  
ATOM   1468  CG  PHE B  64      23.794  41.359  43.559  1.00 21.20           C  
ATOM   1469  CD1 PHE B  64      23.373  40.465  42.615  1.00 26.17           C  
ATOM   1470  CD2 PHE B  64      22.906  41.754  44.516  1.00 28.99           C  
ATOM   1471  CE1 PHE B  64      21.971  40.072  42.524  1.00 26.20           C  
ATOM   1472  CE2 PHE B  64      21.519  41.296  44.461  1.00 32.98           C  
ATOM   1473  CZ  PHE B  64      21.086  40.507  43.416  1.00 24.35           C  
ATOM   1474  N   ALA B  65      24.959  44.304  41.735  1.00 20.18           N  
ATOM   1475  CA  ALA B  65      24.255  45.331  40.965  1.00 22.00           C  
ATOM   1476  C   ALA B  65      24.838  45.345  39.549  1.00 22.88           C  
ATOM   1477  O   ALA B  65      24.072  45.374  38.572  1.00 23.54           O  
ATOM   1478  CB  ALA B  65      24.354  46.799  41.657  1.00 18.76           C  
ATOM   1479  N   TYR B  66      26.177  45.233  39.400  1.00 24.14           N  
ATOM   1480  CA  TYR B  66      26.747  45.295  38.049  1.00 23.10           C  
ATOM   1481  C   TYR B  66      26.362  44.089  37.209  1.00 22.35           C  
ATOM   1482  O   TYR B  66      25.922  44.233  36.070  1.00 20.82           O  
ATOM   1483  CB  TYR B  66      28.292  45.574  38.080  1.00 23.51           C  
ATOM   1484  CG  TYR B  66      28.480  47.035  38.437  1.00 26.08           C  
ATOM   1485  CD1 TYR B  66      28.344  47.480  39.722  1.00 29.82           C  
ATOM   1486  CD2 TYR B  66      28.646  47.986  37.445  1.00 35.98           C  
ATOM   1487  CE1 TYR B  66      28.438  48.824  40.049  1.00 35.15           C  
ATOM   1488  CE2 TYR B  66      28.771  49.354  37.740  1.00 38.73           C  
ATOM   1489  CZ  TYR B  66      28.676  49.775  39.055  1.00 39.54           C  
ATOM   1490  OH  TYR B  66      28.761  51.134  39.325  1.00 33.19           O  
ATOM   1491  N   ALA B  67      26.512  42.894  37.772  1.00 18.54           N  
ATOM   1492  CA  ALA B  67      26.228  41.708  37.056  1.00 20.61           C  
ATOM   1493  C   ALA B  67      24.711  41.678  36.676  1.00 21.59           C  
ATOM   1494  O   ALA B  67      24.381  41.332  35.553  1.00 22.67           O  
ATOM   1495  CB  ALA B  67      26.604  40.444  37.927  1.00 16.57           C  
ATOM   1496  N   CYS B  68      23.808  42.033  37.588  1.00 21.93           N  
ATOM   1497  CA  CYS B  68      22.414  41.877  37.247  1.00 25.20           C  
ATOM   1498  C   CYS B  68      21.821  43.061  36.456  1.00 27.40           C  
ATOM   1499  O   CYS B  68      20.625  43.026  36.060  1.00 25.53           O  
ATOM   1500  CB  CYS B  68      21.551  41.627  38.466  1.00 26.46           C  
ATOM   1501  SG  CYS B  68      21.174  42.988  39.540  1.00 32.84           S  
ATOM   1502  N   ASN B  69      22.634  44.086  36.243  1.00 26.45           N  
ATOM   1503  CA  ASN B  69      22.182  45.230  35.431  1.00 27.69           C  
ATOM   1504  C   ASN B  69      22.839  45.234  34.106  1.00 29.09           C  
ATOM   1505  O   ASN B  69      22.518  46.062  33.243  1.00 33.59           O  
ATOM   1506  CB  ASN B  69      22.365  46.552  36.180  1.00 24.57           C  
ATOM   1507  CG  ASN B  69      21.197  46.775  37.175  1.00 31.05           C  
ATOM   1508  OD1 ASN B  69      20.102  47.146  36.772  1.00 34.05           O  
ATOM   1509  ND2 ASN B  69      21.418  46.470  38.460  1.00 30.51           N  
ATOM   1510  N   SER B  70      23.682  44.248  33.892  1.00 28.51           N  
ATOM   1511  CA  SER B  70      24.576  44.214  32.746  1.00 28.75           C  
ATOM   1512  C   SER B  70      23.876  43.935  31.454  1.00 28.97           C  
ATOM   1513  O   SER B  70      24.485  44.184  30.445  1.00 26.59           O  
ATOM   1514  CB  SER B  70      25.615  43.104  32.904  1.00 26.11           C  
ATOM   1515  OG  SER B  70      24.975  41.862  32.855  1.00 31.05           O  
ATOM   1516  N   GLN B  71      22.669  43.328  31.500  1.00 29.15           N  
ATOM   1517  CA  GLN B  71      21.899  43.027  30.314  1.00 31.47           C  
ATOM   1518  C   GLN B  71      21.147  44.287  29.866  1.00 31.80           C  
ATOM   1519  O   GLN B  71      20.526  44.281  28.831  1.00 34.81           O  
ATOM   1520  CB  GLN B  71      20.888  41.848  30.517  1.00 32.54           C  
ATOM   1521  CG  GLN B  71      21.349  40.509  31.236  1.00 36.58           C  
ATOM   1522  CD  GLN B  71      21.633  40.654  32.856  1.00 47.36           C  
ATOM   1523  OE1 GLN B  71      22.147  39.699  33.456  1.00 47.24           O  
ATOM   1524  NE2 GLN B  71      21.334  41.849  33.491  1.00 43.19           N  
ATOM   1525  N   GLY B  72      21.196  45.377  30.608  1.00 31.95           N  
ATOM   1526  CA  GLY B  72      20.482  46.580  30.229  1.00 30.89           C  
ATOM   1527  C   GLY B  72      19.116  46.794  30.848  1.00 32.93           C  
ATOM   1528  O   GLY B  72      18.488  47.776  30.528  1.00 33.96           O  
ATOM   1529  N   LEU B  73      18.632  45.884  31.710  1.00 32.21           N  
ATOM   1530  CA  LEU B  73      17.340  46.006  32.400  1.00 32.83           C  
ATOM   1531  C   LEU B  73      17.507  46.355  33.874  1.00 32.38           C  
ATOM   1532  O   LEU B  73      18.065  45.567  34.607  1.00 33.75           O  
ATOM   1533  CB  LEU B  73      16.613  44.661  32.355  1.00 32.01           C  
ATOM   1534  CG  LEU B  73      16.308  44.512  30.861  1.00 39.30           C  
ATOM   1535  CD1 LEU B  73      16.109  43.049  30.462  1.00 39.27           C  
ATOM   1536  CD2 LEU B  73      15.171  45.486  30.391  1.00 36.99           C  
ATOM   1537  N   ALA B  74      17.014  47.514  34.290  1.00 30.07           N  
ATOM   1538  CA  ALA B  74      17.154  47.961  35.647  1.00 29.60           C  
ATOM   1539  C   ALA B  74      16.643  46.804  36.624  1.00 28.24           C  
ATOM   1540  O   ALA B  74      15.547  46.235  36.402  1.00 27.34           O  
ATOM   1541  CB  ALA B  74      16.316  49.262  35.851  1.00 26.58           C  
ATOM   1542  N   ALA B  75      17.411  46.504  37.663  1.00 24.69           N  
ATOM   1543  CA  ALA B  75      17.065  45.418  38.568  1.00 24.95           C  
ATOM   1544  C   ALA B  75      17.690  45.756  39.897  1.00 26.10           C  
ATOM   1545  O   ALA B  75      18.720  46.460  39.943  1.00 25.75           O  
ATOM   1546  CB  ALA B  75      17.554  44.110  38.062  1.00 22.94           C  
ATOM   1547  N   VAL B  76      17.028  45.302  40.969  1.00 24.70           N  
ATOM   1548  CA  VAL B  76      17.403  45.559  42.364  1.00 25.34           C  
ATOM   1549  C   VAL B  76      17.387  44.205  43.160  1.00 25.56           C  
ATOM   1550  O   VAL B  76      16.819  43.207  42.700  1.00 24.50           O  
ATOM   1551  CB  VAL B  76      16.401  46.532  43.068  1.00 25.92           C  
ATOM   1552  CG1 VAL B  76      16.312  47.861  42.308  1.00 29.88           C  
ATOM   1553  CG2 VAL B  76      15.007  45.903  43.325  1.00 23.37           C  
ATOM   1554  N   ALA B  77      17.980  44.219  44.340  1.00 22.99           N  
ATOM   1555  CA  ALA B  77      18.040  43.027  45.159  1.00 24.03           C  
ATOM   1556  C   ALA B  77      16.682  42.809  45.847  1.00 22.13           C  
ATOM   1557  O   ALA B  77      16.203  43.710  46.436  1.00 24.41           O  
ATOM   1558  CB  ALA B  77      19.125  43.301  46.205  1.00 21.79           C  
ATOM   1559  N   SER B  78      16.023  41.670  45.770  1.00 23.56           N  
ATOM   1560  CA  SER B  78      14.932  41.474  46.715  1.00 20.61           C  
ATOM   1561  C   SER B  78      15.381  40.713  47.957  1.00 21.38           C  
ATOM   1562  O   SER B  78      14.671  40.709  48.977  1.00 20.59           O  
ATOM   1563  CB  SER B  78      13.799  40.648  46.147  1.00 22.60           C  
ATOM   1564  OG  SER B  78      14.359  39.617  45.510  1.00 26.02           O  
ATOM   1565  N   ALA B  79      16.497  40.016  47.886  1.00 19.80           N  
ATOM   1566  CA  ALA B  79      16.925  39.203  49.029  1.00 22.16           C  
ATOM   1567  C   ALA B  79      18.322  38.742  48.798  1.00 23.47           C  
ATOM   1568  O   ALA B  79      18.828  38.697  47.663  1.00 21.49           O  
ATOM   1569  CB  ALA B  79      16.027  37.928  49.220  1.00 21.34           C  
ATOM   1570  N   CYS B  80      18.973  38.347  49.898  1.00 24.61           N  
ATOM   1571  CA  CYS B  80      20.286  37.814  49.725  1.00 26.45           C  
ATOM   1572  C   CYS B  80      20.871  37.260  51.006  1.00 25.92           C  
ATOM   1573  O   CYS B  80      20.394  37.593  52.044  1.00 26.53           O  
ATOM   1574  CB  CYS B  80      21.147  38.921  49.227  1.00 25.62           C  
ATOM   1575  SG  CYS B  80      21.570  40.038  50.477  1.00 39.88           S  
ATOM   1576  N   THR B  81      21.929  36.495  50.898  1.00 22.92           N  
ATOM   1577  CA  THR B  81      22.507  35.887  52.048  1.00 25.01           C  
ATOM   1578  C   THR B  81      24.011  36.004  51.945  1.00 23.16           C  
ATOM   1579  O   THR B  81      24.543  35.897  50.879  1.00 22.63           O  
ATOM   1580  CB  THR B  81      22.060  34.423  52.148  1.00 25.33           C  
ATOM   1581  OG1 THR B  81      22.242  33.782  50.907  1.00 30.89           O  
ATOM   1582  CG2 THR B  81      20.583  34.304  52.129  1.00 31.93           C  
ATOM   1583  N   ILE B  82      24.678  36.216  53.063  1.00 22.79           N  
ATOM   1584  CA  ILE B  82      26.117  36.363  53.079  1.00 24.36           C  
ATOM   1585  C   ILE B  82      26.697  35.413  54.138  1.00 23.56           C  
ATOM   1586  O   ILE B  82      26.152  35.339  55.189  1.00 24.23           O  
ATOM   1587  CB  ILE B  82      26.580  37.946  53.187  1.00 24.95           C  
ATOM   1588  CG1 ILE B  82      28.074  38.117  53.352  1.00 29.68           C  
ATOM   1589  CG2 ILE B  82      25.954  38.738  54.368  1.00 30.20           C  
ATOM   1590  CD1 ILE B  82      28.717  39.461  52.554  1.00 30.85           C  
ATOM   1591  N   ASP B  83      27.731  34.639  53.791  1.00 22.03           N  
ATOM   1592  CA  ASP B  83      28.610  33.983  54.742  1.00 23.75           C  
ATOM   1593  C   ASP B  83      29.992  34.696  54.881  1.00 23.29           C  
ATOM   1594  O   ASP B  83      30.704  34.809  53.898  1.00 26.65           O  
ATOM   1595  CB  ASP B  83      28.860  32.621  54.237  1.00 20.21           C  
ATOM   1596  CG  ASP B  83      27.622  31.770  54.324  1.00 36.35           C  
ATOM   1597  OD1 ASP B  83      27.400  31.188  55.440  1.00 37.59           O  
ATOM   1598  OD2 ASP B  83      26.749  31.694  53.322  1.00 44.20           O  
ATOM   1599  N   PHE B  84      30.360  35.144  56.078  1.00 23.52           N  
ATOM   1600  CA  PHE B  84      31.665  35.744  56.356  1.00 23.71           C  
ATOM   1601  C   PHE B  84      32.664  34.654  56.730  1.00 25.28           C  
ATOM   1602  O   PHE B  84      32.397  33.878  57.658  1.00 25.56           O  
ATOM   1603  CB  PHE B  84      31.483  36.734  57.495  1.00 24.97           C  
ATOM   1604  CG  PHE B  84      30.582  37.973  57.094  1.00 25.13           C  
ATOM   1605  CD1 PHE B  84      29.315  38.105  57.591  1.00 21.63           C  
ATOM   1606  CD2 PHE B  84      31.051  38.959  56.226  1.00 26.54           C  
ATOM   1607  CE1 PHE B  84      28.511  39.247  57.346  1.00 18.46           C  
ATOM   1608  CE2 PHE B  84      30.251  40.087  55.895  1.00 23.45           C  
ATOM   1609  CZ  PHE B  84      28.988  40.230  56.482  1.00 21.97           C  
ATOM   1610  N   LEU B  85      33.727  34.476  55.951  1.00 24.81           N  
ATOM   1611  CA  LEU B  85      34.649  33.357  56.219  1.00 27.29           C  
ATOM   1612  C   LEU B  85      36.029  33.738  56.831  1.00 26.98           C  
ATOM   1613  O   LEU B  85      36.636  32.965  57.558  1.00 27.97           O  
ATOM   1614  CB  LEU B  85      34.867  32.584  54.928  1.00 27.96           C  
ATOM   1615  CG  LEU B  85      33.565  32.191  54.171  1.00 28.68           C  
ATOM   1616  CD1 LEU B  85      33.917  31.759  52.747  1.00 26.75           C  
ATOM   1617  CD2 LEU B  85      32.848  31.073  54.905  1.00 29.40           C  
ATOM   1618  N   ARG B  86      36.544  34.874  56.447  1.00 26.93           N  
ATOM   1619  CA  ARG B  86      37.867  35.317  56.929  1.00 28.68           C  
ATOM   1620  C   ARG B  86      37.750  36.792  57.062  1.00 28.24           C  
ATOM   1621  O   ARG B  86      36.982  37.399  56.349  1.00 28.05           O  
ATOM   1622  CB  ARG B  86      39.005  35.072  55.936  1.00 26.69           C  
ATOM   1623  CG  ARG B  86      39.303  33.689  55.678  1.00 33.76           C  
ATOM   1624  CD  ARG B  86      40.576  33.458  54.841  1.00 37.42           C  
ATOM   1625  NE  ARG B  86      40.931  32.025  54.711  1.00 39.33           N  
ATOM   1626  CZ  ARG B  86      40.256  31.103  53.980  1.00 42.40           C  
ATOM   1627  NH1 ARG B  86      39.117  31.416  53.345  1.00 38.90           N  
ATOM   1628  NH2 ARG B  86      40.717  29.841  53.909  1.00 43.85           N  
ATOM   1629  N   PRO B  87      38.511  37.387  57.962  1.00 30.99           N  
ATOM   1630  CA  PRO B  87      38.517  38.836  58.066  1.00 31.29           C  
ATOM   1631  C   PRO B  87      39.184  39.472  56.827  1.00 31.65           C  
ATOM   1632  O   PRO B  87      39.958  38.820  56.132  1.00 32.47           O  
ATOM   1633  CB  PRO B  87      39.315  39.081  59.356  1.00 33.40           C  
ATOM   1634  CG  PRO B  87      39.338  37.664  60.034  1.00 37.42           C  
ATOM   1635  CD  PRO B  87      39.439  36.710  58.896  1.00 32.00           C  
ATOM   1636  N   GLY B  88      38.826  40.700  56.519  1.00 32.45           N  
ATOM   1637  CA  GLY B  88      39.620  41.553  55.636  1.00 33.92           C  
ATOM   1638  C   GLY B  88      40.498  42.568  56.440  1.00 33.83           C  
ATOM   1639  O   GLY B  88      39.943  43.380  57.131  1.00 34.07           O  
ATOM   1640  N   PHE B  89      41.834  42.522  56.358  1.00 32.17           N  
ATOM   1641  CA  PHE B  89      42.680  43.424  57.168  1.00 32.48           C  
ATOM   1642  C   PHE B  89      43.149  44.553  56.354  1.00 32.38           C  
ATOM   1643  O   PHE B  89      43.206  44.395  55.160  1.00 32.12           O  
ATOM   1644  CB  PHE B  89      43.947  42.675  57.612  1.00 32.40           C  
ATOM   1645  CG  PHE B  89      43.655  41.565  58.528  1.00 31.59           C  
ATOM   1646  CD1 PHE B  89      43.876  40.274  58.144  1.00 36.75           C  
ATOM   1647  CD2 PHE B  89      43.029  41.806  59.713  1.00 34.90           C  
ATOM   1648  CE1 PHE B  89      43.564  39.208  58.993  1.00 37.90           C  
ATOM   1649  CE2 PHE B  89      42.647  40.771  60.558  1.00 35.43           C  
ATOM   1650  CZ  PHE B  89      42.924  39.478  60.225  1.00 35.67           C  
ATOM   1651  N   ALA B  90      43.570  45.664  56.977  1.00 33.46           N  
ATOM   1652  CA  ALA B  90      44.107  46.851  56.248  1.00 33.36           C  
ATOM   1653  C   ALA B  90      45.098  46.468  55.199  1.00 33.05           C  
ATOM   1654  O   ALA B  90      45.960  45.656  55.429  1.00 32.59           O  
ATOM   1655  CB  ALA B  90      44.749  47.942  57.214  1.00 34.35           C  
ATOM   1656  N   GLY B  91      44.928  47.008  53.997  1.00 35.16           N  
ATOM   1657  CA  GLY B  91      45.899  46.807  52.932  1.00 34.35           C  
ATOM   1658  C   GLY B  91      45.453  45.608  52.104  1.00 34.72           C  
ATOM   1659  O   GLY B  91      45.950  45.460  50.966  1.00 35.35           O  
ATOM   1660  N   ASP B  92      44.549  44.753  52.632  1.00 32.60           N  
ATOM   1661  CA  ASP B  92      44.146  43.558  51.877  1.00 31.93           C  
ATOM   1662  C   ASP B  92      43.502  44.048  50.574  1.00 29.14           C  
ATOM   1663  O   ASP B  92      42.741  45.016  50.613  1.00 30.11           O  
ATOM   1664  CB  ASP B  92      43.158  42.687  52.650  1.00 30.35           C  
ATOM   1665  CG  ASP B  92      43.839  41.676  53.577  1.00 40.06           C  
ATOM   1666  OD1 ASP B  92      45.131  41.711  53.768  1.00 44.11           O  
ATOM   1667  OD2 ASP B  92      43.127  40.790  54.189  1.00 44.13           O  
ATOM   1668  N   THR B  93      43.786  43.429  49.433  1.00 26.73           N  
ATOM   1669  CA  THR B  93      43.018  43.833  48.207  1.00 28.01           C  
ATOM   1670  C   THR B  93      41.982  42.781  48.008  1.00 26.08           C  
ATOM   1671  O   THR B  93      42.340  41.624  47.934  1.00 25.24           O  
ATOM   1672  CB  THR B  93      43.886  43.875  46.929  1.00 26.77           C  
ATOM   1673  OG1 THR B  93      44.710  45.020  47.022  1.00 35.58           O  
ATOM   1674  CG2 THR B  93      43.061  44.224  45.643  1.00 32.85           C  
ATOM   1675  N   LEU B  94      40.727  43.198  47.817  1.00 24.79           N  
ATOM   1676  CA  LEU B  94      39.572  42.275  47.826  1.00 22.39           C  
ATOM   1677  C   LEU B  94      38.892  42.340  46.447  1.00 23.38           C  
ATOM   1678  O   LEU B  94      38.646  43.415  45.912  1.00 23.82           O  
ATOM   1679  CB  LEU B  94      38.582  42.721  48.892  1.00 21.29           C  
ATOM   1680  CG  LEU B  94      39.049  42.679  50.333  1.00 24.48           C  
ATOM   1681  CD1 LEU B  94      37.960  43.040  51.320  1.00 22.54           C  
ATOM   1682  CD2 LEU B  94      39.579  41.298  50.657  1.00 20.56           C  
ATOM   1683  N   THR B  95      38.632  41.191  45.861  1.00 22.11           N  
ATOM   1684  CA  THR B  95      38.045  41.079  44.561  1.00 24.01           C  
ATOM   1685  C   THR B  95      36.703  40.316  44.731  1.00 23.08           C  
ATOM   1686  O   THR B  95      36.686  39.224  45.304  1.00 23.33           O  
ATOM   1687  CB  THR B  95      39.034  40.325  43.650  1.00 24.72           C  
ATOM   1688  OG1 THR B  95      40.339  40.969  43.714  1.00 30.79           O  
ATOM   1689  CG2 THR B  95      38.707  40.528  42.197  1.00 26.64           C  
ATOM   1690  N   ALA B  96      35.622  40.928  44.297  1.00 21.32           N  
ATOM   1691  CA  ALA B  96      34.263  40.330  44.319  1.00 20.95           C  
ATOM   1692  C   ALA B  96      33.891  39.989  42.875  1.00 19.88           C  
ATOM   1693  O   ALA B  96      33.993  40.878  41.971  1.00 20.19           O  
ATOM   1694  CB  ALA B  96      33.207  41.302  44.978  1.00 18.11           C  
ATOM   1695  N   THR B  97      33.578  38.720  42.629  1.00 16.24           N  
ATOM   1696  CA  THR B  97      33.159  38.252  41.355  1.00 17.64           C  
ATOM   1697  C   THR B  97      31.725  37.793  41.472  1.00 19.49           C  
ATOM   1698  O   THR B  97      31.421  36.943  42.308  1.00 19.18           O  
ATOM   1699  CB  THR B  97      33.961  37.092  41.023  1.00 18.44           C  
ATOM   1700  OG1 THR B  97      35.347  37.498  40.837  1.00 27.79           O  
ATOM   1701  CG2 THR B  97      33.639  36.485  39.651  1.00 14.81           C  
ATOM   1702  N   ALA B  98      30.880  38.277  40.565  1.00 18.52           N  
ATOM   1703  CA  ALA B  98      29.482  37.950  40.610  1.00 17.11           C  
ATOM   1704  C   ALA B  98      29.154  37.207  39.334  1.00 19.30           C  
ATOM   1705  O   ALA B  98      29.564  37.619  38.273  1.00 21.01           O  
ATOM   1706  CB  ALA B  98      28.735  39.243  40.712  1.00 18.83           C  
ATOM   1707  N   GLN B  99      28.412  36.106  39.390  1.00 17.77           N  
ATOM   1708  CA  GLN B  99      28.133  35.276  38.228  1.00 18.30           C  
ATOM   1709  C   GLN B  99      26.630  34.957  38.295  1.00 17.00           C  
ATOM   1710  O   GLN B  99      26.163  34.546  39.361  1.00 14.28           O  
ATOM   1711  CB  GLN B  99      28.661  33.892  38.517  1.00 19.78           C  
ATOM   1712  CG  GLN B  99      29.941  33.583  38.203  1.00 27.42           C  
ATOM   1713  CD  GLN B  99      30.272  32.213  38.783  1.00 28.75           C  
ATOM   1714  OE1 GLN B  99      29.773  31.196  38.301  1.00 28.70           O  
ATOM   1715  NE2 GLN B  99      31.061  32.199  39.807  1.00 30.65           N  
ATOM   1716  N   VAL B 100      25.927  35.097  37.188  1.00 17.73           N  
ATOM   1717  CA  VAL B 100      24.502  34.712  37.085  1.00 16.11           C  
ATOM   1718  C   VAL B 100      24.411  33.140  37.221  1.00 17.03           C  
ATOM   1719  O   VAL B 100      25.219  32.400  36.652  1.00 18.03           O  
ATOM   1720  CB  VAL B 100      23.859  35.258  35.784  1.00 14.55           C  
ATOM   1721  CG1 VAL B 100      24.501  34.734  34.573  1.00 18.47           C  
ATOM   1722  CG2 VAL B 100      22.385  34.902  35.677  1.00 17.19           C  
ATOM   1723  N   ARG B 101      23.521  32.671  38.086  1.00 16.74           N  
ATOM   1724  CA  ARG B 101      23.064  31.225  38.119  1.00 17.28           C  
ATOM   1725  C   ARG B 101      21.703  31.038  37.437  1.00 18.46           C  
ATOM   1726  O   ARG B 101      21.473  30.028  36.888  1.00 22.09           O  
ATOM   1727  CB  ARG B 101      22.833  30.834  39.578  1.00 14.65           C  
ATOM   1728  CG  ARG B 101      24.106  31.045  40.431  1.00 20.14           C  
ATOM   1729  CD  ARG B 101      25.366  30.334  39.895  1.00 18.24           C  
ATOM   1730  NE  ARG B 101      25.216  28.900  39.613  1.00 24.30           N  
ATOM   1731  CZ  ARG B 101      25.277  27.890  40.538  1.00 28.81           C  
ATOM   1732  NH1 ARG B 101      25.407  28.125  41.809  1.00 27.15           N  
ATOM   1733  NH2 ARG B 101      25.261  26.625  40.193  1.00 26.42           N  
ATOM   1734  N   HIS B 102      20.823  32.025  37.474  1.00 18.89           N  
ATOM   1735  CA  HIS B 102      19.567  32.023  36.776  1.00 18.28           C  
ATOM   1736  C   HIS B 102      19.122  33.477  36.451  1.00 18.44           C  
ATOM   1737  O   HIS B 102      19.205  34.371  37.281  1.00 17.76           O  
ATOM   1738  CB  HIS B 102      18.525  31.454  37.742  1.00 20.09           C  
ATOM   1739  CG  HIS B 102      17.117  31.574  37.243  1.00 24.89           C  
ATOM   1740  ND1 HIS B 102      16.630  30.752  36.264  1.00 27.60           N  
ATOM   1741  CD2 HIS B 102      16.120  32.441  37.540  1.00 30.36           C  
ATOM   1742  CE1 HIS B 102      15.389  31.111  35.962  1.00 31.59           C  
ATOM   1743  NE2 HIS B 102      15.049  32.119  36.736  1.00 33.79           N  
ATOM   1744  N   GLN B 103      18.569  33.698  35.276  1.00 20.91           N  
ATOM   1745  CA  GLN B 103      17.997  35.016  34.972  1.00 23.00           C  
ATOM   1746  C   GLN B 103      16.720  34.737  34.156  1.00 25.31           C  
ATOM   1747  O   GLN B 103      16.850  34.311  33.067  1.00 25.72           O  
ATOM   1748  CB  GLN B 103      18.994  35.847  34.196  1.00 23.21           C  
ATOM   1749  CG  GLN B 103      18.435  37.310  33.856  1.00 21.47           C  
ATOM   1750  CD  GLN B 103      18.073  38.132  35.075  1.00 24.14           C  
ATOM   1751  OE1 GLN B 103      18.949  38.518  35.826  1.00 24.73           O  
ATOM   1752  NE2 GLN B 103      16.822  38.419  35.277  1.00 22.62           N  
ATOM   1753  N   GLY B 104      15.524  34.897  34.739  1.00 28.05           N  
ATOM   1754  CA  GLY B 104      14.246  34.848  34.044  1.00 29.43           C  
ATOM   1755  C   GLY B 104      13.927  36.209  33.474  1.00 32.34           C  
ATOM   1756  O   GLY B 104      14.766  37.149  33.535  1.00 32.97           O  
ATOM   1757  N   LYS B 105      12.716  36.355  32.947  1.00 33.67           N  
ATOM   1758  CA  LYS B 105      12.272  37.678  32.462  1.00 36.57           C  
ATOM   1759  C   LYS B 105      12.157  38.718  33.560  1.00 35.68           C  
ATOM   1760  O   LYS B 105      12.401  39.915  33.314  1.00 37.12           O  
ATOM   1761  CB  LYS B 105      10.940  37.667  31.611  1.00 38.11           C  
ATOM   1762  CG  LYS B 105      11.056  36.994  30.192  1.00 43.57           C  
ATOM   1763  CD  LYS B 105      12.146  37.653  29.237  1.00 56.33           C  
ATOM   1764  CE  LYS B 105      11.924  37.403  27.670  1.00 59.86           C  
ATOM   1765  NZ  LYS B 105      11.096  38.504  26.979  1.00 61.89           N  
ATOM   1766  N   GLN B 106      11.749  38.292  34.738  1.00 34.19           N  
ATOM   1767  CA  GLN B 106      11.577  39.190  35.870  1.00 34.67           C  
ATOM   1768  C   GLN B 106      12.618  38.987  36.974  1.00 33.16           C  
ATOM   1769  O   GLN B 106      13.088  39.950  37.570  1.00 33.93           O  
ATOM   1770  CB  GLN B 106      10.175  39.041  36.486  1.00 35.44           C  
ATOM   1771  CG  GLN B 106       9.001  39.312  35.478  1.00 42.68           C  
ATOM   1772  CD  GLN B 106       8.902  40.787  35.076  1.00 50.72           C  
ATOM   1773  OE1 GLN B 106       8.558  41.102  33.932  1.00 56.39           O  
ATOM   1774  NE2 GLN B 106       9.215  41.691  36.009  1.00 55.36           N  
ATOM   1775  N   THR B 107      12.953  37.739  37.283  1.00 31.49           N  
ATOM   1776  CA  THR B 107      13.851  37.526  38.444  1.00 30.43           C  
ATOM   1777  C   THR B 107      15.125  36.800  38.184  1.00 26.17           C  
ATOM   1778  O   THR B 107      15.206  35.994  37.285  1.00 24.56           O  
ATOM   1779  CB  THR B 107      13.124  36.769  39.583  1.00 31.15           C  
ATOM   1780  OG1 THR B 107      12.867  35.430  39.134  1.00 35.94           O  
ATOM   1781  CG2 THR B 107      11.774  37.355  39.897  1.00 32.56           C  
ATOM   1782  N   GLY B 108      16.136  37.008  39.042  1.00 24.12           N  
ATOM   1783  CA  GLY B 108      17.378  36.306  38.802  1.00 21.76           C  
ATOM   1784  C   GLY B 108      18.094  35.888  40.071  1.00 20.06           C  
ATOM   1785  O   GLY B 108      17.817  36.429  41.090  1.00 19.76           O  
ATOM   1786  N   VAL B 109      18.951  34.898  39.971  1.00 18.32           N  
ATOM   1787  CA  VAL B 109      19.856  34.530  41.053  1.00 17.42           C  
ATOM   1788  C   VAL B 109      21.364  34.713  40.641  1.00 14.48           C  
ATOM   1789  O   VAL B 109      21.766  34.266  39.584  1.00 14.02           O  
ATOM   1790  CB  VAL B 109      19.636  33.064  41.524  1.00 17.70           C  
ATOM   1791  CG1 VAL B 109      20.466  32.785  42.830  1.00 15.03           C  
ATOM   1792  CG2 VAL B 109      18.124  32.842  41.883  1.00 19.98           C  
ATOM   1793  N   TYR B 110      22.153  35.316  41.534  1.00 14.52           N  
ATOM   1794  CA  TYR B 110      23.580  35.687  41.234  1.00 14.97           C  
ATOM   1795  C   TYR B 110      24.380  35.274  42.453  1.00 16.13           C  
ATOM   1796  O   TYR B 110      23.961  35.550  43.584  1.00 16.97           O  
ATOM   1797  CB  TYR B 110      23.725  37.196  41.100  1.00 15.12           C  
ATOM   1798  CG  TYR B 110      23.136  37.682  39.730  1.00 16.42           C  
ATOM   1799  CD1 TYR B 110      21.746  37.705  39.555  1.00 17.79           C  
ATOM   1800  CD2 TYR B 110      23.965  37.983  38.645  1.00 17.70           C  
ATOM   1801  CE1 TYR B 110      21.164  38.013  38.288  1.00 21.68           C  
ATOM   1802  CE2 TYR B 110      23.408  38.300  37.327  1.00 18.12           C  
ATOM   1803  CZ  TYR B 110      21.999  38.353  37.221  1.00 19.98           C  
ATOM   1804  OH  TYR B 110      21.428  38.551  36.037  1.00 20.58           O  
ATOM   1805  N   ASP B 111      25.515  34.650  42.193  1.00 17.64           N  
ATOM   1806  CA  ASP B 111      26.440  34.192  43.228  1.00 18.82           C  
ATOM   1807  C   ASP B 111      27.608  35.147  43.166  1.00 18.31           C  
ATOM   1808  O   ASP B 111      28.114  35.379  42.073  1.00 17.21           O  
ATOM   1809  CB  ASP B 111      26.971  32.868  42.855  1.00 16.56           C  
ATOM   1810  CG  ASP B 111      26.069  31.737  43.355  1.00 29.24           C  
ATOM   1811  OD1 ASP B 111      24.969  32.099  43.861  1.00 34.84           O  
ATOM   1812  OD2 ASP B 111      26.350  30.494  43.342  1.00 31.56           O  
ATOM   1813  N   ILE B 112      28.071  35.584  44.333  1.00 18.69           N  
ATOM   1814  CA  ILE B 112      29.192  36.487  44.378  1.00 19.36           C  
ATOM   1815  C   ILE B 112      30.233  35.830  45.330  1.00 20.36           C  
ATOM   1816  O   ILE B 112      29.904  35.295  46.398  1.00 19.81           O  
ATOM   1817  CB  ILE B 112      28.796  37.876  44.964  1.00 18.68           C  
ATOM   1818  CG1 ILE B 112      28.046  38.817  44.002  1.00 20.00           C  
ATOM   1819  CG2 ILE B 112      30.058  38.630  45.519  1.00 21.28           C  
ATOM   1820  CD1 ILE B 112      26.601  38.305  43.535  1.00 25.69           C  
ATOM   1821  N   GLU B 113      31.498  35.888  44.963  1.00 21.67           N  
ATOM   1822  CA  GLU B 113      32.536  35.436  45.908  1.00 21.29           C  
ATOM   1823  C   GLU B 113      33.531  36.572  46.085  1.00 21.61           C  
ATOM   1824  O   GLU B 113      34.022  37.113  45.093  1.00 21.53           O  
ATOM   1825  CB  GLU B 113      33.214  34.211  45.315  1.00 21.99           C  
ATOM   1826  CG  GLU B 113      34.443  33.705  46.144  1.00 22.30           C  
ATOM   1827  CD  GLU B 113      34.823  32.255  45.825  1.00 39.20           C  
ATOM   1828  OE1 GLU B 113      34.374  31.756  44.736  1.00 44.28           O  
ATOM   1829  OE2 GLU B 113      35.567  31.590  46.659  1.00 43.45           O  
ATOM   1830  N   ILE B 114      33.951  36.814  47.325  1.00 22.39           N  
ATOM   1831  CA  ILE B 114      35.004  37.763  47.627  1.00 22.22           C  
ATOM   1832  C   ILE B 114      36.299  37.034  48.090  1.00 23.49           C  
ATOM   1833  O   ILE B 114      36.260  36.225  48.998  1.00 22.43           O  
ATOM   1834  CB  ILE B 114      34.570  38.870  48.703  1.00 23.43           C  
ATOM   1835  CG1 ILE B 114      33.268  39.619  48.326  1.00 24.04           C  
ATOM   1836  CG2 ILE B 114      35.737  39.898  48.976  1.00 17.07           C  
ATOM   1837  CD1 ILE B 114      32.833  40.711  49.375  1.00 23.78           C  
ATOM   1838  N   VAL B 115      37.402  37.359  47.433  1.00 20.79           N  
ATOM   1839  CA  VAL B 115      38.662  36.675  47.551  1.00 23.40           C  
ATOM   1840  C   VAL B 115      39.689  37.754  47.831  1.00 22.42           C  
ATOM   1841  O   VAL B 115      39.544  38.885  47.302  1.00 21.13           O  
ATOM   1842  CB  VAL B 115      38.939  35.954  46.203  1.00 25.04           C  
ATOM   1843  CG1 VAL B 115      40.326  35.578  46.042  1.00 27.33           C  
ATOM   1844  CG2 VAL B 115      38.045  34.617  46.074  1.00 23.25           C  
ATOM   1845  N   ASN B 116      40.668  37.463  48.705  1.00 22.18           N  
ATOM   1846  CA  ASN B 116      41.705  38.439  48.959  1.00 21.35           C  
ATOM   1847  C   ASN B 116      42.920  38.224  48.090  1.00 21.34           C  
ATOM   1848  O   ASN B 116      42.918  37.367  47.187  1.00 19.81           O  
ATOM   1849  CB  ASN B 116      42.081  38.480  50.418  1.00 20.42           C  
ATOM   1850  CG  ASN B 116      42.875  37.247  50.832  1.00 23.03           C  
ATOM   1851  OD1 ASN B 116      43.381  36.478  50.005  1.00 23.44           O  
ATOM   1852  ND2 ASN B 116      42.963  37.046  52.102  1.00 26.68           N  
ATOM   1853  N   GLN B 117      43.975  39.030  48.317  1.00 22.94           N  
ATOM   1854  CA  GLN B 117      45.137  38.931  47.444  1.00 25.72           C  
ATOM   1855  C   GLN B 117      45.888  37.558  47.649  1.00 27.62           C  
ATOM   1856  O   GLN B 117      46.620  37.093  46.774  1.00 30.54           O  
ATOM   1857  CB  GLN B 117      46.081  40.162  47.632  1.00 26.59           C  
ATOM   1858  CG  GLN B 117      46.793  40.020  49.002  1.00 27.21           C  
ATOM   1859  CD  GLN B 117      45.992  40.595  50.142  1.00 31.32           C  
ATOM   1860  OE1 GLN B 117      44.750  40.859  50.063  1.00 31.09           O  
ATOM   1861  NE2 GLN B 117      46.672  40.795  51.231  1.00 35.70           N  
ATOM   1862  N   GLN B 118      45.682  36.856  48.740  1.00 27.55           N  
ATOM   1863  CA  GLN B 118      46.318  35.523  48.845  1.00 27.59           C  
ATOM   1864  C   GLN B 118      45.461  34.459  48.164  1.00 28.01           C  
ATOM   1865  O   GLN B 118      45.687  33.240  48.350  1.00 28.26           O  
ATOM   1866  CB  GLN B 118      46.492  35.133  50.327  1.00 26.48           C  
ATOM   1867  CG  GLN B 118      47.614  35.929  51.066  1.00 35.96           C  
ATOM   1868  CD  GLN B 118      49.038  35.690  50.387  1.00 49.64           C  
ATOM   1869  OE1 GLN B 118      49.617  34.546  50.483  1.00 53.15           O  
ATOM   1870  NE2 GLN B 118      49.563  36.737  49.652  1.00 49.05           N  
ATOM   1871  N   GLN B 119      44.405  34.880  47.459  1.00 27.10           N  
ATOM   1872  CA  GLN B 119      43.428  33.939  46.903  1.00 26.63           C  
ATOM   1873  C   GLN B 119      42.672  33.156  47.977  1.00 24.75           C  
ATOM   1874  O   GLN B 119      42.272  32.046  47.754  1.00 26.21           O  
ATOM   1875  CB  GLN B 119      44.131  32.967  45.964  1.00 28.76           C  
ATOM   1876  CG  GLN B 119      43.562  32.813  44.513  1.00 39.29           C  
ATOM   1877  CD  GLN B 119      43.213  34.161  43.839  1.00 46.74           C  
ATOM   1878  OE1 GLN B 119      43.989  35.155  43.986  1.00 42.83           O  
ATOM   1879  NE2 GLN B 119      42.030  34.207  43.100  1.00 45.98           N  
ATOM   1880  N   LYS B 120      42.467  33.736  49.132  1.00 24.33           N  
ATOM   1881  CA  LYS B 120      41.656  33.100  50.130  1.00 26.49           C  
ATOM   1882  C   LYS B 120      40.251  33.735  50.066  1.00 25.13           C  
ATOM   1883  O   LYS B 120      40.091  34.921  49.973  1.00 23.35           O  
ATOM   1884  CB  LYS B 120      42.358  33.235  51.527  1.00 26.80           C  
ATOM   1885  CG  LYS B 120      43.816  32.802  51.539  1.00 29.54           C  
ATOM   1886  CD  LYS B 120      44.106  31.339  52.126  1.00 42.90           C  
ATOM   1887  CE  LYS B 120      44.863  31.322  53.542  1.00 51.90           C  
ATOM   1888  NZ  LYS B 120      44.717  30.035  54.419  1.00 53.79           N  
ATOM   1889  N   THR B 121      39.217  32.918  50.061  1.00 25.89           N  
ATOM   1890  CA  THR B 121      37.833  33.407  50.329  1.00 23.98           C  
ATOM   1891  C   THR B 121      37.530  34.131  51.589  1.00 22.39           C  
ATOM   1892  O   THR B 121      37.629  33.605  52.676  1.00 23.75           O  
ATOM   1893  CB  THR B 121      36.871  32.269  50.242  1.00 24.90           C  
ATOM   1894  OG1 THR B 121      37.289  31.470  49.120  1.00 26.55           O  
ATOM   1895  CG2 THR B 121      35.508  32.884  49.777  1.00 24.51           C  
ATOM   1896  N   VAL B 122      37.076  35.363  51.431  1.00 19.99           N  
ATOM   1897  CA  VAL B 122      36.661  36.158  52.508  1.00 19.05           C  
ATOM   1898  C   VAL B 122      35.171  35.978  52.821  1.00 20.30           C  
ATOM   1899  O   VAL B 122      34.777  36.025  54.010  1.00 20.91           O  
ATOM   1900  CB  VAL B 122      36.992  37.599  52.129  1.00 22.32           C  
ATOM   1901  CG1 VAL B 122      36.251  38.599  52.970  1.00 24.23           C  
ATOM   1902  CG2 VAL B 122      38.572  37.792  52.156  1.00 20.21           C  
ATOM   1903  N   ALA B 123      34.355  35.797  51.779  1.00 18.41           N  
ATOM   1904  CA  ALA B 123      32.925  35.855  51.933  1.00 19.71           C  
ATOM   1905  C   ALA B 123      32.232  35.300  50.653  1.00 18.98           C  
ATOM   1906  O   ALA B 123      32.808  35.355  49.522  1.00 18.98           O  
ATOM   1907  CB  ALA B 123      32.513  37.317  52.266  1.00 16.52           C  
ATOM   1908  N   LEU B 124      31.016  34.784  50.841  1.00 18.57           N  
ATOM   1909  CA  LEU B 124      30.193  34.095  49.766  1.00 17.99           C  
ATOM   1910  C   LEU B 124      28.844  34.733  49.918  1.00 17.52           C  
ATOM   1911  O   LEU B 124      28.407  35.009  51.030  1.00 17.80           O  
ATOM   1912  CB  LEU B 124      30.086  32.559  49.996  1.00 19.69           C  
ATOM   1913  CG  LEU B 124      31.365  31.776  49.770  1.00 19.63           C  
ATOM   1914  CD1 LEU B 124      31.316  30.338  50.145  1.00 24.65           C  
ATOM   1915  CD2 LEU B 124      31.828  31.814  48.261  1.00 19.52           C  
ATOM   1916  N   PHE B 125      28.211  35.097  48.813  1.00 15.37           N  
ATOM   1917  CA  PHE B 125      26.993  35.824  48.950  1.00 16.76           C  
ATOM   1918  C   PHE B 125      26.160  35.243  47.798  1.00 14.94           C  
ATOM   1919  O   PHE B 125      26.707  34.767  46.816  1.00 13.55           O  
ATOM   1920  CB  PHE B 125      27.399  37.241  48.696  1.00 19.17           C  
ATOM   1921  CG  PHE B 125      26.308  38.165  48.375  1.00 25.13           C  
ATOM   1922  CD1 PHE B 125      26.000  39.218  49.281  1.00 31.11           C  
ATOM   1923  CD2 PHE B 125      25.644  38.089  47.175  1.00 29.08           C  
ATOM   1924  CE1 PHE B 125      24.976  40.148  48.985  1.00 33.79           C  
ATOM   1925  CE2 PHE B 125      24.593  39.041  46.833  1.00 29.47           C  
ATOM   1926  CZ  PHE B 125      24.275  40.058  47.727  1.00 31.22           C  
ATOM   1927  N   ARG B 126      24.850  35.265  47.965  1.00 17.26           N  
ATOM   1928  CA  ARG B 126      23.968  34.794  46.923  1.00 19.48           C  
ATOM   1929  C   ARG B 126      22.826  35.780  46.972  1.00 19.08           C  
ATOM   1930  O   ARG B 126      22.271  36.104  48.005  1.00 21.40           O  
ATOM   1931  CB  ARG B 126      23.517  33.320  47.122  1.00 18.70           C  
ATOM   1932  CG  ARG B 126      22.347  32.955  46.146  1.00 24.29           C  
ATOM   1933  CD  ARG B 126      22.119  31.487  45.783  1.00 31.41           C  
ATOM   1934  NE  ARG B 126      23.353  30.865  45.297  1.00 34.21           N  
ATOM   1935  CZ  ARG B 126      23.640  29.610  45.447  1.00 32.33           C  
ATOM   1936  NH1 ARG B 126      22.734  28.821  46.067  1.00 31.72           N  
ATOM   1937  NH2 ARG B 126      24.785  29.136  44.962  1.00 28.98           N  
ATOM   1938  N   GLY B 127      22.488  36.329  45.820  1.00 21.41           N  
ATOM   1939  CA  GLY B 127      21.558  37.428  45.818  1.00 19.47           C  
ATOM   1940  C   GLY B 127      20.436  37.096  44.820  1.00 18.28           C  
ATOM   1941  O   GLY B 127      20.647  36.501  43.776  1.00 17.80           O  
ATOM   1942  N   LYS B 128      19.273  37.593  45.116  1.00 17.21           N  
ATOM   1943  CA  LYS B 128      18.175  37.347  44.231  1.00 18.16           C  
ATOM   1944  C   LYS B 128      17.755  38.733  43.702  1.00 16.47           C  
ATOM   1945  O   LYS B 128      17.622  39.643  44.467  1.00 16.76           O  
ATOM   1946  CB  LYS B 128      17.077  36.813  45.075  1.00 17.33           C  
ATOM   1947  CG  LYS B 128      15.717  36.728  44.332  1.00 29.30           C  
ATOM   1948  CD  LYS B 128      15.386  35.282  43.884  1.00 37.81           C  
ATOM   1949  CE  LYS B 128      14.011  35.159  43.174  1.00 45.38           C  
ATOM   1950  NZ  LYS B 128      13.040  36.322  43.643  1.00 50.61           N  
ATOM   1951  N   SER B 129      17.533  38.882  42.410  1.00 19.40           N  
ATOM   1952  CA  SER B 129      17.210  40.228  41.872  1.00 19.72           C  
ATOM   1953  C   SER B 129      15.806  40.234  41.293  1.00 20.02           C  
ATOM   1954  O   SER B 129      15.334  39.217  40.899  1.00 20.05           O  
ATOM   1955  CB  SER B 129      18.147  40.589  40.735  1.00 19.89           C  
ATOM   1956  OG  SER B 129      18.228  39.564  39.769  1.00 22.56           O  
ATOM   1957  N   HIS B 130      15.258  41.412  41.071  1.00 20.61           N  
ATOM   1958  CA  HIS B 130      13.898  41.607  40.592  1.00 24.65           C  
ATOM   1959  C   HIS B 130      14.006  42.795  39.592  1.00 22.68           C  
ATOM   1960  O   HIS B 130      14.555  43.821  39.935  1.00 19.71           O  
ATOM   1961  CB  HIS B 130      13.021  41.979  41.831  1.00 23.97           C  
ATOM   1962  CG  HIS B 130      11.610  42.298  41.515  1.00 38.80           C  
ATOM   1963  ND1 HIS B 130      11.012  43.477  41.921  1.00 47.28           N  
ATOM   1964  CD2 HIS B 130      10.652  41.585  40.867  1.00 47.10           C  
ATOM   1965  CE1 HIS B 130       9.747  43.479  41.518  1.00 52.49           C  
ATOM   1966  NE2 HIS B 130       9.503  42.340  40.880  1.00 51.54           N  
ATOM   1967  N   ARG B 131      13.582  42.612  38.368  1.00 24.24           N  
ATOM   1968  CA  ARG B 131      13.591  43.794  37.431  1.00 28.68           C  
ATOM   1969  C   ARG B 131      12.455  44.737  37.753  1.00 29.68           C  
ATOM   1970  O   ARG B 131      11.374  44.303  38.137  1.00 29.72           O  
ATOM   1971  CB  ARG B 131      13.541  43.278  35.979  1.00 28.16           C  
ATOM   1972  CG  ARG B 131      14.807  42.434  35.764  1.00 28.15           C  
ATOM   1973  CD  ARG B 131      14.898  41.808  34.499  1.00 31.55           C  
ATOM   1974  NE  ARG B 131      16.268  41.474  34.182  1.00 27.03           N  
ATOM   1975  CZ  ARG B 131      16.549  40.773  33.137  1.00 31.00           C  
ATOM   1976  NH1 ARG B 131      15.529  40.368  32.394  1.00 24.02           N  
ATOM   1977  NH2 ARG B 131      17.823  40.419  32.860  1.00 32.04           N  
ATOM   1978  N   ILE B 132      12.693  46.018  37.661  1.00 32.71           N  
ATOM   1979  CA  ILE B 132      11.784  47.001  38.233  1.00 35.95           C  
ATOM   1980  C   ILE B 132      11.205  47.858  37.071  1.00 39.86           C  
ATOM   1981  O   ILE B 132      10.446  48.788  37.291  1.00 40.41           O  
ATOM   1982  CB  ILE B 132      12.531  47.895  39.257  1.00 35.52           C  
ATOM   1983  CG1 ILE B 132      13.829  48.439  38.673  1.00 37.75           C  
ATOM   1984  CG2 ILE B 132      12.813  47.157  40.578  1.00 37.24           C  
ATOM   1985  CD1 ILE B 132      14.196  49.869  39.202  1.00 39.63           C  
ATOM   1986  N   GLY B 133      11.588  47.545  35.843  1.00 42.72           N  
ATOM   1987  CA  GLY B 133      11.007  48.212  34.698  1.00 46.08           C  
ATOM   1988  C   GLY B 133      11.902  49.261  34.080  1.00 47.25           C  
ATOM   1989  O   GLY B 133      12.457  50.137  34.756  1.00 46.39           O  
ATOM   1990  N   GLY B 134      12.026  49.150  32.755  1.00 51.04           N  
ATOM   1991  CA  GLY B 134      12.829  50.070  31.958  1.00 53.77           C  
ATOM   1992  C   GLY B 134      14.303  49.755  32.118  1.00 55.90           C  
ATOM   1993  O   GLY B 134      14.684  48.718  32.697  1.00 52.54           O  
ATOM   1994  N   THR B 135      15.096  50.684  31.587  1.00 59.75           N  
ATOM   1995  CA  THR B 135      16.563  50.643  31.484  1.00 63.46           C  
ATOM   1996  C   THR B 135      17.231  51.374  32.656  1.00 65.36           C  
ATOM   1997  O   THR B 135      16.545  52.034  33.475  1.00 66.08           O  
ATOM   1998  CB  THR B 135      16.995  51.275  30.141  1.00 64.07           C  
ATOM   1999  OG1 THR B 135      16.036  50.940  29.113  1.00 63.10           O  
ATOM   2000  CG2 THR B 135      18.348  50.652  29.643  1.00 66.62           C  
ATOM   2001  N   ILE B 136      18.562  51.258  32.725  1.00 67.60           N  
ATOM   2002  CA  ILE B 136      19.319  51.412  33.998  1.00 69.05           C  
ATOM   2003  C   ILE B 136      19.627  52.893  34.258  1.00 71.54           C  
ATOM   2004  O   ILE B 136      19.343  53.725  33.340  1.00 72.26           O  
ATOM   2005  CB  ILE B 136      20.612  50.518  33.969  1.00 68.62           C  
ATOM   2006  CG1 ILE B 136      21.413  50.771  32.704  1.00 67.52           C  
ATOM   2007  CG2 ILE B 136      20.275  49.047  33.892  1.00 66.32           C  
ATOM   2008  CD1 ILE B 136      22.851  50.977  32.943  1.00 64.82           C  
ATOM   2009  N   THR B 137      20.195  53.245  35.446  1.00 72.77           N  
ATOM   2010  CA  THR B 137      20.352  54.692  35.812  1.00 73.74           C  
ATOM   2011  C   THR B 137      21.717  55.295  35.461  1.00 74.29           C  
ATOM   2012  O   THR B 137      21.778  56.303  34.751  1.00 74.78           O  
ATOM   2013  CB  THR B 137      19.922  55.052  37.301  1.00 73.99           C  
ATOM   2014  OG1 THR B 137      19.612  53.858  38.028  1.00 75.89           O  
ATOM   2015  CG2 THR B 137      18.581  55.868  37.364  1.00 73.04           C  
TER    2016      THR B 137                                                      
END
MOLECULE T0479.pdb
ATOM      1  N   THR     6      34.108  56.591  39.835  1.00 82.67           N  
ATOM      2  CA  THR     6      32.687  57.041  39.783  1.00 84.71           C  
ATOM      3  C   THR     6      31.847  56.242  38.792  1.00 84.83           C  
ATOM      4  O   THR     6      30.746  55.797  39.120  1.00 87.33           O  
ATOM      5  CB  THR     6      32.594  58.552  39.443  1.00 84.63           C  
ATOM      6  OG1 THR     6      32.669  59.310  40.659  1.00 80.59           O  
ATOM      7  CG2 THR     6      31.288  58.884  38.714  1.00 85.06           C  
ATOM      8  N   ASP     7      32.357  56.052  37.583  1.00 82.92           N  
ATOM      9  CA  ASP     7      31.608  55.292  36.597  1.00 82.53           C  
ATOM     10  C   ASP     7      31.505  53.876  37.126  1.00 82.43           C  
ATOM     11  O   ASP     7      32.507  53.164  37.202  1.00 83.40           O  
ATOM     12  CB  ASP     7      32.337  55.281  35.254  1.00 83.34           C  
ATOM     13  CG  ASP     7      31.398  55.058  34.080  1.00 83.13           C  
ATOM     14  OD1 ASP     7      31.411  55.902  33.161  1.00 90.62           O  
ATOM     15  OD2 ASP     7      30.652  54.052  34.068  1.00 82.94           O  
ATOM     16  N   PHE     8      30.302  53.477  37.524  1.00 81.00           N  
ATOM     17  CA  PHE     8      30.095  52.129  38.022  1.00 78.25           C  
ATOM     18  C   PHE     8      29.206  51.420  37.035  1.00 78.12           C  
ATOM     19  O   PHE     8      27.993  51.364  37.192  1.00 78.37           O  
ATOM     20  CB  PHE     8      29.455  52.141  39.411  1.00 77.96           C  
ATOM     21  CG  PHE     8      30.418  52.466  40.517  1.00 75.33           C  
ATOM     22  CD1 PHE     8      30.264  53.616  41.272  1.00 73.58           C  
ATOM     23  CD2 PHE     8      31.496  51.628  40.791  1.00 69.75           C  
ATOM     24  CE1 PHE     8      31.172  53.932  42.287  1.00 72.35           C  
ATOM     25  CE2 PHE     8      32.404  51.929  41.799  1.00 67.03           C  
ATOM     26  CZ  PHE     8      32.243  53.085  42.549  1.00 69.31           C  
ATOM     27  N   PHE     9      29.835  50.909  35.989  1.00 79.06           N  
ATOM     28  CA  PHE     9      29.150  50.169  34.948  1.00 79.09           C  
ATOM     29  C   PHE     9      27.978  50.911  34.325  1.00 79.86           C  
ATOM     30  O   PHE     9      26.979  50.298  33.945  1.00 80.70           O  
ATOM     31  CB  PHE     9      28.690  48.836  35.517  1.00 79.01           C  
ATOM     32  CG  PHE     9      29.776  48.084  36.228  1.00 77.86           C  
ATOM     33  CD1 PHE     9      30.883  47.602  35.536  1.00 80.20           C  
ATOM     34  CD2 PHE     9      29.691  47.850  37.594  1.00 75.84           C  
ATOM     35  CE1 PHE     9      31.889  46.890  36.201  1.00 77.51           C  
ATOM     36  CE2 PHE     9      30.689  47.142  38.263  1.00 74.21           C  
ATOM     37  CZ  PHE     9      31.788  46.661  37.567  1.00 74.96           C  
ATOM     38  N   GLY    10      28.102  52.230  34.216  1.00 81.37           N  
ATOM     39  CA  GLY    10      27.041  53.016  33.610  1.00 81.99           C  
ATOM     40  C   GLY    10      26.223  53.898  34.534  1.00 82.45           C  
ATOM     41  O   GLY    10      25.148  54.363  34.148  1.00 83.24           O  
ATOM     42  N   LEU    11      26.724  54.138  35.742  1.00 81.84           N  
ATOM     43  CA  LEU    11      26.015  54.971  36.704  1.00 80.93           C  
ATOM     44  C   LEU    11      26.885  55.422  37.864  1.00 81.11           C  
ATOM     45  O   LEU    11      27.854  54.752  38.224  1.00 81.55           O  
ATOM     46  CB  LEU    11      24.792  54.226  37.245  1.00 82.16           C  
ATOM     47  CG  LEU    11      24.869  52.706  37.388  1.00 80.12           C  
ATOM     48  CD1 LEU    11      24.789  52.279  38.854  1.00 80.11           C  
ATOM     49  CD2 LEU    11      23.717  52.108  36.594  1.00 78.58           C  
ATOM     50  N   THR    12      26.541  56.567  38.444  1.00 81.94           N  
ATOM     51  CA  THR    12      27.287  57.083  39.583  1.00 81.54           C  
ATOM     52  C   THR    12      26.555  56.700  40.869  1.00 80.32           C  
ATOM     53  O   THR    12      25.343  56.884  40.994  1.00 80.81           O  
ATOM     54  CB  THR    12      27.491  58.640  39.490  1.00 82.25           C  
ATOM     55  OG1 THR    12      27.647  59.186  40.808  1.00 81.93           O  
ATOM     56  CG2 THR    12      26.328  59.308  38.779  1.00 80.77           C  
ATOM     57  N   ILE    13      27.311  56.133  41.803  1.00 78.25           N  
ATOM     58  CA  ILE    13      26.793  55.681  43.085  1.00 73.63           C  
ATOM     59  C   ILE    13      27.597  56.362  44.187  1.00 72.82           C  
ATOM     60  O   ILE    13      28.654  55.878  44.583  1.00 73.86           O  
ATOM     61  CB  ILE    13      26.945  54.157  43.209  1.00 72.50           C  
ATOM     62  CG1 ILE    13      26.386  53.476  41.959  1.00 70.72           C  
ATOM     63  CG2 ILE    13      26.218  53.660  44.444  1.00 69.64           C  
ATOM     64  CD1 ILE    13      26.615  51.973  41.912  1.00 66.94           C  
ATOM     65  N   PRO    14      27.097  57.496  44.701  1.00 71.54           N  
ATOM     66  CA  PRO    14      27.744  58.277  45.759  1.00 70.83           C  
ATOM     67  C   PRO    14      28.279  57.487  46.948  1.00 70.92           C  
ATOM     68  O   PRO    14      29.261  57.894  47.573  1.00 72.37           O  
ATOM     69  CB  PRO    14      26.659  59.259  46.170  1.00 70.62           C  
ATOM     70  CG  PRO    14      25.953  59.505  44.881  1.00 70.49           C  
ATOM     71  CD  PRO    14      25.818  58.114  44.315  1.00 70.58           C  
ATOM     72  N   PHE    15      27.644  56.369  47.277  1.00 70.30           N  
ATOM     73  CA  PHE    15      28.112  55.580  48.413  1.00 68.63           C  
ATOM     74  C   PHE    15      29.290  54.712  47.992  1.00 69.27           C  
ATOM     75  O   PHE    15      30.270  54.582  48.727  1.00 68.96           O  
ATOM     76  CB  PHE    15      26.985  54.703  48.979  1.00 66.76           C  
ATOM     77  CG  PHE    15      27.407  53.863  50.158  1.00 62.75           C  
ATOM     78  CD1 PHE    15      27.964  54.455  51.288  1.00 65.47           C  
ATOM     79  CD2 PHE    15      27.258  52.480  50.135  1.00 60.04           C  
ATOM     80  CE1 PHE    15      28.366  53.683  52.381  1.00 63.65           C  
ATOM     81  CE2 PHE    15      27.656  51.697  51.219  1.00 59.43           C  
ATOM     82  CZ  PHE    15      28.212  52.301  52.347  1.00 57.78           C  
ATOM     83  N   MET    16      29.191  54.120  46.806  1.00 68.50           N  
ATOM     84  CA  MET    16      30.266  53.276  46.314  1.00 69.92           C  
ATOM     85  C   MET    16      31.532  54.105  46.109  1.00 70.28           C  
ATOM     86  O   MET    16      32.628  53.687  46.484  1.00 69.63           O  
ATOM     87  CB  MET    16      29.843  52.593  45.012  1.00 68.25           C  
ATOM     88  CG  MET    16      28.836  51.462  45.210  1.00 71.30           C  
ATOM     89  SD  MET    16      29.518  49.996  46.318  1.00 82.26          SE  
ATOM     90  CE  MET    16      28.397  50.232  47.881  1.00 81.23           C  
ATOM     91  N   GLN    17      31.367  55.287  45.525  1.00 71.35           N  
ATOM     92  CA  GLN    17      32.486  56.187  45.280  1.00 73.14           C  
ATOM     93  C   GLN    17      33.152  56.495  46.615  1.00 72.71           C  
ATOM     94  O   GLN    17      34.353  56.744  46.677  1.00 72.94           O  
ATOM     95  CB  GLN    17      31.983  57.490  44.639  1.00 74.17           C  
ATOM     96  CG  GLN    17      33.075  58.494  44.271  1.00 78.87           C  
ATOM     97  CD  GLN    17      32.597  59.942  44.333  1.00 85.45           C  
ATOM     98  OE1 GLN    17      31.612  60.318  43.696  1.00 90.09           O  
ATOM     99  NE2 GLN    17      33.302  60.762  45.105  1.00 86.55           N  
ATOM    100  N   LEU    18      32.356  56.466  47.683  1.00 72.85           N  
ATOM    101  CA  LEU    18      32.837  56.759  49.032  1.00 71.27           C  
ATOM    102  C   LEU    18      33.668  55.626  49.622  1.00 71.30           C  
ATOM    103  O   LEU    18      34.567  55.862  50.431  1.00 70.93           O  
ATOM    104  CB  LEU    18      31.647  57.058  49.950  1.00 70.66           C  
ATOM    105  CG  LEU    18      31.844  57.860  51.244  1.00 69.80           C  
ATOM    106  CD1 LEU    18      31.930  56.948  52.446  1.00 73.18           C  
ATOM    107  CD2 LEU    18      33.078  58.730  51.117  1.00 67.63           C  
ATOM    108  N   LEU    19      33.362  54.396  49.214  1.00 71.25           N  
ATOM    109  CA  LEU    19      34.081  53.224  49.701  1.00 71.47           C  
ATOM    110  C   LEU    19      35.415  53.043  48.998  1.00 73.05           C  
ATOM    111  O   LEU    19      36.224  52.201  49.390  1.00 73.88           O  
ATOM    112  CB  LEU    19      33.246  51.963  49.496  1.00 70.20           C  
ATOM    113  CG  LEU    19      32.009  51.732  50.363  1.00 69.28           C  
ATOM    114  CD1 LEU    19      31.332  50.437  49.937  1.00 64.95           C  
ATOM    115  CD2 LEU    19      32.405  51.662  51.830  1.00 66.56           C  
ATOM    116  N   GLY    20      35.643  53.827  47.951  1.00 74.73           N  
ATOM    117  CA  GLY    20      36.885  53.704  47.211  1.00 75.28           C  
ATOM    118  C   GLY    20      36.969  52.336  46.555  1.00 76.69           C  
ATOM    119  O   GLY    20      37.965  51.628  46.709  1.00 76.35           O  
ATOM    120  N   VAL    21      35.913  51.954  45.839  1.00 75.90           N  
ATOM    121  CA  VAL    21      35.890  50.665  45.161  1.00 74.91           C  
ATOM    122  C   VAL    21      36.060  50.871  43.656  1.00 74.23           C  
ATOM    123  O   VAL    21      35.609  51.876  43.102  1.00 74.26           O  
ATOM    124  CB  VAL    21      34.569  49.882  45.455  1.00 75.48           C  
ATOM    125  CG1 VAL    21      33.353  50.705  45.059  1.00 75.56           C  
ATOM    126  CG2 VAL    21      34.576  48.554  44.708  1.00 75.52           C  
ATOM    127  N   VAL    22      36.712  49.920  42.997  1.00 73.26           N  
ATOM    128  CA  VAL    22      36.955  50.026  41.563  1.00 71.22           C  
ATOM    129  C   VAL    22      36.297  48.933  40.714  1.00 69.51           C  
ATOM    130  O   VAL    22      36.493  47.745  40.956  1.00 69.28           O  
ATOM    131  CB  VAL    22      38.481  50.019  41.277  1.00 71.44           C  
ATOM    132  CG1 VAL    22      38.734  50.139  39.788  1.00 72.67           C  
ATOM    133  CG2 VAL    22      39.153  51.152  42.024  1.00 68.35           C  
ATOM    134  N   PRO    23      35.488  49.332  39.713  1.00 68.68           N  
ATOM    135  CA  PRO    23      34.795  48.412  38.803  1.00 69.35           C  
ATOM    136  C   PRO    23      35.821  47.787  37.856  1.00 70.07           C  
ATOM    137  O   PRO    23      36.584  48.493  37.208  1.00 70.33           O  
ATOM    138  CB  PRO    23      33.787  49.320  38.085  1.00 68.77           C  
ATOM    139  CG  PRO    23      34.445  50.640  38.103  1.00 69.37           C  
ATOM    140  CD  PRO    23      35.035  50.715  39.491  1.00 68.21           C  
ATOM    141  N   GLU    24      35.827  46.463  37.774  1.00 71.08           N  
ATOM    142  CA  GLU    24      36.811  45.762  36.956  1.00 71.52           C  
ATOM    143  C   GLU    24      36.266  45.026  35.724  1.00 71.28           C  
ATOM    144  O   GLU    24      37.016  44.737  34.787  1.00 72.41           O  
ATOM    145  CB  GLU    24      37.571  44.789  37.863  1.00 71.19           C  
ATOM    146  CG  GLU    24      39.055  44.645  37.574  1.00 74.13           C  
ATOM    147  CD  GLU    24      39.917  44.750  38.828  1.00 77.25           C  
ATOM    148  OE1 GLU    24      40.224  45.885  39.255  1.00 83.15           O  
ATOM    149  OE2 GLU    24      40.295  43.699  39.387  1.00 77.85           O  
ATOM    150  N   HIS    25      34.967  44.735  35.719  1.00 70.76           N  
ATOM    151  CA  HIS    25      34.342  44.017  34.613  1.00 68.54           C  
ATOM    152  C   HIS    25      32.855  43.809  34.849  1.00 68.40           C  
ATOM    153  O   HIS    25      32.388  43.788  35.984  1.00 69.03           O  
ATOM    154  CB  HIS    25      35.002  42.646  34.430  1.00 67.13           C  
ATOM    155  CG  HIS    25      34.233  41.710  33.551  1.00 66.67           C  
ATOM    156  ND1 HIS    25      34.002  40.394  33.883  1.00 64.69           N  
ATOM    157  CD2 HIS    25      33.623  41.902  32.352  1.00 67.64           C  
ATOM    158  CE1 HIS    25      33.284  39.814  32.935  1.00 66.58           C  
ATOM    159  NE2 HIS    25      33.043  40.713  31.996  1.00 67.15           N  
ATOM    160  N   SER    26      32.122  43.645  33.755  1.00 68.39           N  
ATOM    161  CA  SER    26      30.692  43.402  33.785  1.00 67.02           C  
ATOM    162  C   SER    26      30.240  43.026  32.388  1.00 66.04           C  
ATOM    163  O   SER    26      30.387  43.804  31.449  1.00 68.32           O  
ATOM    164  CB  SER    26      29.936  44.647  34.243  1.00 68.40           C  
ATOM    165  OG  SER    26      28.563  44.537  33.896  1.00 69.94           O  
ATOM    166  N   GLY    27      29.690  41.828  32.252  1.00 63.41           N  
ATOM    167  CA  GLY    27      29.224  41.394  30.954  1.00 59.63           C  
ATOM    168  C   GLY    27      29.182  39.889  30.902  1.00 57.60           C  
ATOM    169  O   GLY    27      29.900  39.221  31.635  1.00 59.65           O  
ATOM    170  N   ASN    28      28.337  39.354  30.032  1.00 58.55           N  
ATOM    171  CA  ASN    28      28.200  37.912  29.878  1.00 59.88           C  
ATOM    172  C   ASN    28      27.865  37.168  31.165  1.00 60.45           C  
ATOM    173  O   ASN    28      28.385  36.085  31.409  1.00 58.08           O  
ATOM    174  CB  ASN    28      29.481  37.352  29.275  1.00 61.54           C  
ATOM    175  CG  ASN    28      29.808  37.982  27.943  1.00 59.96           C  
ATOM    176  OD1 ASN    28      29.020  37.900  27.004  1.00 57.88           O  
ATOM    177  ND2 ASN    28      30.971  38.636  27.858  1.00 52.70           N  
ATOM    178  N   GLY    29      27.005  37.764  31.984  1.00 58.42           N  
ATOM    179  CA  GLY    29      26.598  37.118  33.217  1.00 59.39           C  
ATOM    180  C   GLY    29      27.591  37.028  34.362  1.00 58.49           C  
ATOM    181  O   GLY    29      27.400  36.212  35.263  1.00 58.96           O  
ATOM    182  N   THR    30      28.647  37.836  34.339  1.00 55.83           N  
ATOM    183  CA  THR    30      29.626  37.818  35.419  1.00 55.20           C  
ATOM    184  C   THR    30      30.039  39.253  35.687  1.00 54.78           C  
ATOM    185  O   THR    30      29.687  40.152  34.930  1.00 56.63           O  
ATOM    186  CB  THR    30      30.904  37.026  35.054  1.00 55.53           C  
ATOM    187  OG1 THR    30      31.572  37.684  33.977  1.00 59.89           O  
ATOM    188  CG2 THR    30      30.580  35.605  34.655  1.00 55.82           C  
ATOM    189  N   ALA    31      30.784  39.474  36.764  1.00 51.78           N  
ATOM    190  CA  ALA    31      31.237  40.818  37.076  1.00 52.61           C  
ATOM    191  C   ALA    31      32.450  40.790  38.010  1.00 53.18           C  
ATOM    192  O   ALA    31      32.691  39.810  38.709  1.00 52.70           O  
ATOM    193  CB  ALA    31      30.097  41.623  37.693  1.00 51.77           C  
ATOM    194  N   ARG    32      33.225  41.869  38.002  1.00 53.91           N  
ATOM    195  CA  ARG    32      34.407  41.932  38.849  1.00 55.41           C  
ATOM    196  C   ARG    32      34.550  43.326  39.411  1.00 54.45           C  
ATOM    197  O   ARG    32      34.304  44.324  38.727  1.00 51.64           O  
ATOM    198  CB  ARG    32      35.682  41.577  38.061  1.00 56.29           C  
ATOM    199  CG  ARG    32      36.710  40.769  38.870  1.00 60.83           C  
ATOM    200  CD  ARG    32      38.165  41.219  38.659  1.00 68.82           C  
ATOM    201  NE  ARG    32      38.433  41.696  37.302  1.00 67.14           N  
ATOM    202  CZ  ARG    32      38.391  40.946  36.205  1.00 66.56           C  
ATOM    203  NH1 ARG    32      38.096  39.654  36.281  1.00 67.50           N  
ATOM    204  NH2 ARG    32      38.623  41.502  35.025  1.00 69.78           N  
ATOM    205  N   THR    33      34.960  43.386  40.667  1.00 54.04           N  
ATOM    206  CA  THR    33      35.150  44.655  41.328  1.00 54.88           C  
ATOM    207  C   THR    33      36.340  44.494  42.275  1.00 55.51           C  
ATOM    208  O   THR    33      36.741  43.371  42.579  1.00 52.87           O  
ATOM    209  CB  THR    33      33.852  45.066  42.075  1.00 55.35           C  
ATOM    210  OG1 THR    33      33.558  46.442  41.790  1.00 60.23           O  
ATOM    211  CG2 THR    33      33.996  44.881  43.573  1.00 52.69           C  
ATOM    212  N   ARG    34      36.904  45.603  42.744  1.00 58.33           N  
ATOM    213  CA  ARG    34      38.070  45.520  43.620  1.00 61.57           C  
ATOM    214  C   ARG    34      38.011  46.499  44.783  1.00 61.13           C  
ATOM    215  O   ARG    34      37.666  47.668  44.602  1.00 62.13           O  
ATOM    216  CB  ARG    34      39.332  45.759  42.779  1.00 63.11           C  
ATOM    217  CG  ARG    34      40.654  45.547  43.495  1.00 67.81           C  
ATOM    218  CD  ARG    34      41.235  46.851  44.018  1.00 80.63           C  
ATOM    219  NE  ARG    34      42.681  46.919  43.799  1.00 88.82           N  
ATOM    220  CZ  ARG    34      43.252  46.975  42.600  1.00 92.25           C  
ATOM    221  NH1 ARG    34      42.495  46.976  41.508  1.00 90.51           N  
ATOM    222  NH2 ARG    34      44.577  47.025  42.491  1.00 94.91           N  
ATOM    223  N   LEU    35      38.362  46.027  45.976  1.00 60.79           N  
ATOM    224  CA  LEU    35      38.335  46.890  47.153  1.00 61.51           C  
ATOM    225  C   LEU    35      39.714  47.210  47.733  1.00 62.84           C  
ATOM    226  O   LEU    35      40.231  46.501  48.599  1.00 62.23           O  
ATOM    227  CB  LEU    35      37.448  46.280  48.255  1.00 59.96           C  
ATOM    228  CG  LEU    35      37.249  47.164  49.495  1.00 60.64           C  
ATOM    229  CD1 LEU    35      36.531  48.452  49.101  1.00 59.80           C  
ATOM    230  CD2 LEU    35      36.457  46.414  50.561  1.00 58.70           C  
ATOM    231  N   PRO    36      40.331  48.295  47.251  1.00 65.05           N  
ATOM    232  CA  PRO    36      41.650  48.673  47.763  1.00 67.72           C  
ATOM    233  C   PRO    36      41.585  48.959  49.265  1.00 70.63           C  
ATOM    234  O   PRO    36      40.669  49.627  49.738  1.00 71.74           O  
ATOM    235  CB  PRO    36      42.014  49.907  46.923  1.00 67.73           C  
ATOM    236  CG  PRO    36      40.688  50.407  46.404  1.00 66.37           C  
ATOM    237  CD  PRO    36      39.927  49.153  46.126  1.00 64.71           C  
ATOM    238  N   ALA    37      42.554  48.433  50.005  1.00 72.73           N  
ATOM    239  CA  ALA    37      42.600  48.610  51.448  1.00 74.97           C  
ATOM    240  C   ALA    37      42.575  50.073  51.880  1.00 78.06           C  
ATOM    241  O   ALA    37      43.148  50.945  51.224  1.00 79.38           O  
ATOM    242  CB  ALA    37      43.831  47.931  52.011  1.00 75.09           C  
ATOM    243  N   ARG    38      41.900  50.325  52.996  1.00 79.16           N  
ATOM    244  CA  ARG    38      41.790  51.660  53.563  1.00 78.26           C  
ATOM    245  C   ARG    38      41.540  51.448  55.042  1.00 77.89           C  
ATOM    246  O   ARG    38      41.137  50.362  55.451  1.00 78.49           O  
ATOM    247  CB  ARG    38      40.625  52.421  52.930  1.00 77.89           C  
ATOM    248  CG  ARG    38      40.756  53.926  53.029  1.00 79.53           C  
ATOM    249  CD  ARG    38      40.565  54.586  51.666  1.00 82.14           C  
ATOM    250  NE  ARG    38      39.190  54.513  51.173  1.00 81.39           N  
ATOM    251  CZ  ARG    38      38.162  55.157  51.718  1.00 84.11           C  
ATOM    252  NH1 ARG    38      38.346  55.925  52.782  1.00 89.00           N  
ATOM    253  NH2 ARG    38      36.949  55.048  51.192  1.00 82.94           N  
ATOM    254  N   ALA    39      41.789  52.471  55.843  1.00 78.61           N  
ATOM    255  CA  ALA    39      41.587  52.371  57.281  1.00 78.25           C  
ATOM    256  C   ALA    39      40.191  52.864  57.650  1.00 77.22           C  
ATOM    257  O   ALA    39      39.693  52.599  58.737  1.00 76.90           O  
ATOM    258  CB  ALA    39      42.655  53.188  58.002  1.00 79.37           C  
ATOM    259  N   ASP    40      39.573  53.583  56.716  1.00 77.54           N  
ATOM    260  CA  ASP    40      38.217  54.117  56.874  1.00 77.22           C  
ATOM    261  C   ASP    40      37.272  52.931  56.852  1.00 76.30           C  
ATOM    262  O   ASP    40      36.191  52.953  57.435  1.00 76.53           O  
ATOM    263  CB  ASP    40      37.834  54.985  55.677  1.00 77.80           C  
ATOM    264  CG  ASP    40      38.088  56.456  55.898  1.00 85.99           C  
ATOM    265  OD1 ASP    40      39.237  56.832  56.212  1.00 98.38           O  
ATOM    266  OD2 ASP    40      37.132  57.245  55.730  1.00 90.77           O  
ATOM    267  N   LEU    41      37.705  51.895  56.151  1.00 75.06           N  
ATOM    268  CA  LEU    41      36.892  50.708  55.945  1.00 72.63           C  
ATOM    269  C   LEU    41      37.057  49.515  56.884  1.00 71.44           C  
ATOM    270  O   LEU    41      36.544  48.441  56.592  1.00 70.58           O  
ATOM    271  CB  LEU    41      37.106  50.251  54.505  1.00 71.79           C  
ATOM    272  CG  LEU    41      37.033  51.397  53.492  1.00 68.81           C  
ATOM    273  CD1 LEU    41      37.246  50.882  52.077  1.00 64.95           C  
ATOM    274  CD2 LEU    41      35.679  52.077  53.620  1.00 69.58           C  
ATOM    275  N   VAL    42      37.726  49.703  58.018  1.00 71.99           N  
ATOM    276  CA  VAL    42      37.962  48.591  58.931  1.00 72.06           C  
ATOM    277  C   VAL    42      37.052  48.400  60.152  1.00 73.10           C  
ATOM    278  O   VAL    42      36.355  49.307  60.612  1.00 73.13           O  
ATOM    279  CB  VAL    42      39.415  48.608  59.414  1.00 72.55           C  
ATOM    280  CG1 VAL    42      40.361  48.501  58.217  1.00 71.29           C  
ATOM    281  CG2 VAL    42      39.678  49.895  60.186  1.00 74.55           C  
ATOM    282  N   ASN    43      37.100  47.174  60.660  1.00 73.75           N  
ATOM    283  CA  ASN    43      36.350  46.720  61.813  1.00 73.70           C  
ATOM    284  C   ASN    43      37.045  47.260  63.050  1.00 75.36           C  
ATOM    285  O   ASN    43      37.844  48.190  62.959  1.00 75.86           O  
ATOM    286  CB  ASN    43      36.381  45.198  61.840  1.00 73.88           C  
ATOM    287  CG  ASN    43      35.532  44.622  62.932  1.00 76.44           C  
ATOM    288  OD1 ASN    43      35.791  43.522  63.420  1.00 79.26           O  
ATOM    289  ND2 ASN    43      34.499  45.351  63.318  1.00 79.28           N  
ATOM    290  N   SER    44      36.739  46.673  64.203  1.00 76.37           N  
ATOM    291  CA  SER    44      37.373  47.063  65.452  1.00 76.63           C  
ATOM    292  C   SER    44      38.514  46.077  65.656  1.00 77.43           C  
ATOM    293  O   SER    44      39.480  46.368  66.354  1.00 77.64           O  
ATOM    294  CB  SER    44      36.383  46.991  66.626  1.00 76.83           C  
ATOM    295  OG  SER    44      35.894  45.674  66.832  1.00 76.34           O  
ATOM    296  N   ARG    45      38.392  44.904  65.036  1.00 77.30           N  
ATOM    297  CA  ARG    45      39.433  43.875  65.118  1.00 76.19           C  
ATOM    298  C   ARG    45      40.462  44.192  64.038  1.00 73.76           C  
ATOM    299  O   ARG    45      41.314  43.367  63.710  1.00 75.30           O  
ATOM    300  CB  ARG    45      38.855  42.474  64.863  1.00 77.62           C  
ATOM    301  CG  ARG    45      37.828  41.992  65.884  1.00 82.48           C  
ATOM    302  CD  ARG    45      38.476  41.651  67.218  1.00 89.78           C  
ATOM    303  NE  ARG    45      39.206  40.385  67.175  1.00 94.62           N  
ATOM    304  CZ  ARG    45      40.475  40.232  67.546  1.00 94.99           C  
ATOM    305  NH1 ARG    45      41.173  41.271  67.991  1.00 94.14           N  
ATOM    306  NH2 ARG    45      41.045  39.035  67.474  1.00 94.64           N  
ATOM    307  N   GLY    46      40.366  45.394  63.480  1.00 71.52           N  
ATOM    308  CA  GLY    46      41.294  45.803  62.441  1.00 69.47           C  
ATOM    309  C   GLY    46      40.961  45.261  61.065  1.00 69.13           C  
ATOM    310  O   GLY    46      41.449  45.783  60.068  1.00 70.07           O  
ATOM    311  N   ASP    47      40.134  44.215  61.018  1.00 68.65           N  
ATOM    312  CA  ASP    47      39.722  43.582  59.760  1.00 66.23           C  
ATOM    313  C   ASP    47      38.785  44.479  58.971  1.00 65.33           C  
ATOM    314  O   ASP    47      38.190  45.397  59.522  1.00 66.99           O  
ATOM    315  CB  ASP    47      38.988  42.269  60.021  1.00 65.80           C  
ATOM    316  CG  ASP    47      39.787  41.304  60.856  1.00 65.95           C  
ATOM    317  OD1 ASP    47      41.015  41.207  60.634  1.00 62.58           O  
ATOM    318  OD2 ASP    47      39.174  40.625  61.720  1.00 64.21           O  
ATOM    319  N   ILE    48      38.643  44.207  57.679  1.00 63.90           N  
ATOM    320  CA  ILE    48      37.734  44.994  56.859  1.00 63.50           C  
ATOM    321  C   ILE    48      36.328  44.661  57.367  1.00 62.00           C  
ATOM    322  O   ILE    48      35.976  43.489  57.484  1.00 61.57           O  
ATOM    323  CB  ILE    48      37.863  44.625  55.362  1.00 63.31           C  
ATOM    324  CG1 ILE    48      39.299  44.867  54.879  1.00 65.41           C  
ATOM    325  CG2 ILE    48      36.910  45.476  54.528  1.00 61.38           C  
ATOM    326  CD1 ILE    48      39.634  46.327  54.571  1.00 65.73           C  
ATOM    327  N   HIS    49      35.538  45.690  57.683  1.00 60.23           N  
ATOM    328  CA  HIS    49      34.170  45.510  58.203  1.00 57.44           C  
ATOM    329  C   HIS    49      33.256  44.751  57.240  1.00 54.86           C  
ATOM    330  O   HIS    49      33.157  45.102  56.068  1.00 54.28           O  
ATOM    331  CB  HIS    49      33.552  46.876  58.544  1.00 56.59           C  
ATOM    332  CG  HIS    49      32.349  46.792  59.433  1.00 56.51           C  
ATOM    333  ND1 HIS    49      31.101  46.436  58.975  1.00 58.06           N  
ATOM    334  CD2 HIS    49      32.216  46.972  60.772  1.00 61.56           C  
ATOM    335  CE1 HIS    49      30.251  46.396  59.986  1.00 60.97           C  
ATOM    336  NE2 HIS    49      30.905  46.718  61.088  1.00 65.28           N  
ATOM    337  N   GLY    50      32.595  43.716  57.755  1.00 54.28           N  
ATOM    338  CA  GLY    50      31.695  42.898  56.953  1.00 55.82           C  
ATOM    339  C   GLY    50      30.656  43.682  56.173  1.00 54.65           C  
ATOM    340  O   GLY    50      30.128  43.208  55.164  1.00 55.18           O  
ATOM    341  N   GLY    51      30.357  44.883  56.655  1.00 54.63           N  
ATOM    342  CA  GLY    51      29.398  45.719  55.981  1.00 55.34           C  
ATOM    343  C   GLY    51      30.061  46.240  54.732  1.00 57.54           C  
ATOM    344  O   GLY    51      29.413  46.409  53.698  1.00 58.76           O  
ATOM    345  N   THR    52      31.360  46.505  54.826  1.00 56.93           N  
ATOM    346  CA  THR    52      32.106  46.994  53.672  1.00 57.73           C  
ATOM    347  C   THR    52      32.002  45.906  52.619  1.00 55.49           C  
ATOM    348  O   THR    52      31.862  46.185  51.438  1.00 57.15           O  
ATOM    349  CB  THR    52      33.609  47.206  53.980  1.00 59.07           C  
ATOM    350  OG1 THR    52      33.767  47.832  55.261  1.00 64.70           O  
ATOM    351  CG2 THR    52      34.239  48.102  52.924  1.00 58.87           C  
ATOM    352  N   LEU    53      32.051  44.658  53.070  1.00 54.28           N  
ATOM    353  CA  LEU    53      31.973  43.510  52.177  1.00 54.38           C  
ATOM    354  C   LEU    53      30.628  43.370  51.465  1.00 55.08           C  
ATOM    355  O   LEU    53      30.581  43.246  50.238  1.00 56.03           O  
ATOM    356  CB  LEU    53      32.288  42.239  52.961  1.00 54.43           C  
ATOM    357  CG  LEU    53      33.572  42.304  53.795  1.00 52.99           C  
ATOM    358  CD1 LEU    53      33.880  40.929  54.383  1.00 55.86           C  
ATOM    359  CD2 LEU    53      34.726  42.774  52.925  1.00 55.19           C  
ATOM    360  N   MET    54      29.541  43.384  52.236  1.00 54.80           N  
ATOM    361  CA  MET    54      28.196  43.260  51.675  1.00 52.43           C  
ATOM    362  C   MET    54      27.894  44.435  50.724  1.00 52.03           C  
ATOM    363  O   MET    54      27.197  44.277  49.717  1.00 48.73           O  
ATOM    364  CB  MET    54      27.156  43.206  52.810  1.00 52.54           C  
ATOM    365  CG  MET    54      27.322  42.027  53.796  1.00 57.30           C  
ATOM    366  SD  MET    54      26.081  42.067  55.318  1.00 62.48          SE  
ATOM    367  CE  MET    54      25.966  40.226  55.821  1.00 55.10           C  
ATOM    368  N   SER    55      28.438  45.609  51.036  1.00 53.67           N  
ATOM    369  CA  SER    55      28.202  46.791  50.202  1.00 55.48           C  
ATOM    370  C   SER    55      28.807  46.581  48.826  1.00 56.00           C  
ATOM    371  O   SER    55      28.170  46.835  47.805  1.00 52.23           O  
ATOM    372  CB  SER    55      28.831  48.041  50.829  1.00 53.38           C  
ATOM    373  OG  SER    55      28.419  48.209  52.174  1.00 55.87           O  
ATOM    374  N   VAL    56      30.047  46.109  48.807  1.00 57.92           N  
ATOM    375  CA  VAL    56      30.719  45.889  47.547  1.00 57.30           C  
ATOM    376  C   VAL    56      30.127  44.653  46.873  1.00 57.04           C  
ATOM    377  O   VAL    56      30.051  44.578  45.648  1.00 58.85           O  
ATOM    378  CB  VAL    56      32.257  45.762  47.761  1.00 57.64           C  
ATOM    379  CG1 VAL    56      32.630  44.379  48.254  1.00 55.71           C  
ATOM    380  CG2 VAL    56      32.981  46.111  46.492  1.00 58.95           C  
ATOM    381  N   LEU    57      29.675  43.694  47.676  1.00 57.70           N  
ATOM    382  CA  LEU    57      29.079  42.484  47.127  1.00 57.43           C  
ATOM    383  C   LEU    57      27.716  42.797  46.524  1.00 58.80           C  
ATOM    384  O   LEU    57      27.326  42.216  45.516  1.00 60.67           O  
ATOM    385  CB  LEU    57      28.945  41.418  48.217  1.00 57.54           C  
ATOM    386  CG  LEU    57      30.007  40.319  48.211  1.00 55.85           C  
ATOM    387  CD1 LEU    57      29.865  39.434  49.442  1.00 48.35           C  
ATOM    388  CD2 LEU    57      29.846  39.493  46.940  1.00 48.05           C  
ATOM    389  N   ASP    58      26.994  43.728  47.139  1.00 58.06           N  
ATOM    390  CA  ASP    58      25.681  44.110  46.639  1.00 59.20           C  
ATOM    391  C   ASP    58      25.877  44.738  45.273  1.00 57.88           C  
ATOM    392  O   ASP    58      25.250  44.358  44.288  1.00 58.06           O  
ATOM    393  CB  ASP    58      25.027  45.123  47.585  1.00 60.09           C  
ATOM    394  CG  ASP    58      23.591  45.424  47.210  1.00 60.92           C  
ATOM    395  OD1 ASP    58      23.009  44.637  46.434  1.00 64.05           O  
ATOM    396  OD2 ASP    58      23.040  46.430  47.701  1.00 63.82           O  
ATOM    397  N   PHE    59      26.770  45.715  45.241  1.00 59.00           N  
ATOM    398  CA  PHE    59      27.117  46.424  44.024  1.00 59.42           C  
ATOM    399  C   PHE    59      27.459  45.465  42.876  1.00 58.46           C  
ATOM    400  O   PHE    59      26.895  45.545  41.786  1.00 59.38           O  
ATOM    401  CB  PHE    59      28.309  47.339  44.319  1.00 60.78           C  
ATOM    402  CG  PHE    59      28.934  47.934  43.095  1.00 69.86           C  
ATOM    403  CD1 PHE    59      28.140  48.503  42.108  1.00 72.66           C  
ATOM    404  CD2 PHE    59      30.314  47.908  42.921  1.00 75.70           C  
ATOM    405  CE1 PHE    59      28.704  49.034  40.960  1.00 84.13           C  
ATOM    406  CE2 PHE    59      30.892  48.439  41.777  1.00 85.16           C  
ATOM    407  CZ  PHE    59      30.082  49.004  40.791  1.00 89.23           C  
ATOM    408  N   THR    60      28.375  44.543  43.147  1.00 57.19           N  
ATOM    409  CA  THR    60      28.852  43.592  42.152  1.00 55.36           C  
ATOM    410  C   THR    60      27.902  42.472  41.730  1.00 55.78           C  
ATOM    411  O   THR    60      28.014  41.949  40.625  1.00 56.93           O  
ATOM    412  CB  THR    60      30.174  42.972  42.627  1.00 54.97           C  
ATOM    413  OG1 THR    60      31.009  44.011  43.157  1.00 51.98           O  
ATOM    414  CG2 THR    60      30.902  42.282  41.454  1.00 50.54           C  
ATOM    415  N   LEU    61      26.978  42.091  42.601  1.00 54.16           N  
ATOM    416  CA  LEU    61      26.039  41.039  42.254  1.00 53.20           C  
ATOM    417  C   LEU    61      25.080  41.575  41.195  1.00 53.73           C  
ATOM    418  O   LEU    61      24.756  40.893  40.222  1.00 52.67           O  
ATOM    419  CB  LEU    61      25.279  40.571  43.504  1.00 52.15           C  
ATOM    420  CG  LEU    61      26.060  39.700  44.497  1.00 50.32           C  
ATOM    421  CD1 LEU    61      25.558  39.942  45.918  1.00 49.21           C  
ATOM    422  CD2 LEU    61      25.916  38.227  44.122  1.00 47.40           C  
ATOM    423  N   GLY    62      24.633  42.808  41.379  1.00 55.99           N  
ATOM    424  CA  GLY    62      23.719  43.392  40.417  1.00 59.26           C  
ATOM    425  C   GLY    62      24.385  43.577  39.065  1.00 60.09           C  
ATOM    426  O   GLY    62      23.770  43.381  38.018  1.00 61.11           O  
ATOM    427  N   ALA    63      25.659  43.950  39.095  1.00 60.63           N  
ATOM    428  CA  ALA    63      26.419  44.172  37.873  1.00 61.18           C  
ATOM    429  C   ALA    63      26.460  42.954  36.957  1.00 60.04           C  
ATOM    430  O   ALA    63      26.575  43.105  35.750  1.00 61.51           O  
ATOM    431  CB  ALA    63      27.832  44.617  38.219  1.00 61.48           C  
ATOM    432  N   ALA    64      26.374  41.752  37.518  1.00 59.72           N  
ATOM    433  CA  ALA    64      26.404  40.539  36.700  1.00 59.00           C  
ATOM    434  C   ALA    64      25.120  40.380  35.901  1.00 61.13           C  
ATOM    435  O   ALA    64      25.025  39.523  35.024  1.00 60.65           O  
ATOM    436  CB  ALA    64      26.618  39.321  37.568  1.00 57.86           C  
ATOM    437  N   ILE    65      24.122  41.196  36.221  1.00 63.34           N  
ATOM    438  CA  ILE    65      22.853  41.143  35.506  1.00 64.35           C  
ATOM    439  C   ILE    65      22.854  42.255  34.466  1.00 65.13           C  
ATOM    440  O   ILE    65      22.716  41.997  33.278  1.00 63.47           O  
ATOM    441  CB  ILE    65      21.633  41.375  36.431  1.00 64.03           C  
ATOM    442  CG1 ILE    65      21.603  40.354  37.561  1.00 61.72           C  
ATOM    443  CG2 ILE    65      20.343  41.247  35.626  1.00 64.35           C  
ATOM    444  CD1 ILE    65      20.632  40.736  38.678  1.00 58.41           C  
ATOM    445  N   ARG    66      23.034  43.498  34.908  1.00 65.61           N  
ATOM    446  CA  ARG    66      22.991  44.625  33.971  1.00 66.75           C  
ATOM    447  C   ARG    66      24.286  45.044  33.265  1.00 65.81           C  
ATOM    448  O   ARG    66      24.657  46.225  33.243  1.00 67.92           O  
ATOM    449  CB  ARG    66      22.348  45.832  34.650  1.00 67.01           C  
ATOM    450  CG  ARG    66      22.930  46.224  35.983  1.00 70.89           C  
ATOM    451  CD  ARG    66      22.388  47.577  36.376  1.00 79.03           C  
ATOM    452  NE  ARG    66      22.696  48.583  35.361  1.00 84.60           N  
ATOM    453  CZ  ARG    66      23.885  49.155  35.206  1.00 86.35           C  
ATOM    454  NH1 ARG    66      24.893  48.825  36.008  1.00 83.77           N  
ATOM    455  NH2 ARG    66      24.062  50.059  34.249  1.00 83.22           N  
ATOM    456  N   GLY    67      24.948  44.056  32.671  1.00 61.55           N  
ATOM    457  CA  GLY    67      26.180  44.278  31.929  1.00 63.66           C  
ATOM    458  C   GLY    67      25.815  43.701  30.583  1.00 65.46           C  
ATOM    459  O   GLY    67      26.284  44.135  29.526  1.00 66.44           O  
ATOM    460  N   ASP    68      24.954  42.686  30.653  1.00 33.74           N  
ATOM    461  CA  ASP    68      24.422  42.009  29.472  1.00 33.21           C  
ATOM    462  C   ASP    68      23.369  42.986  28.987  1.00 36.28           C  
ATOM    463  O   ASP    68      22.870  42.874  27.855  1.00 71.16           O  
ATOM    464  CB  ASP    68      23.781  40.681  29.867  1.00 30.38           C  
ATOM    465  CG  ASP    68      24.819  39.640  30.230  1.00 34.25           C  
ATOM    466  OD1 ASP    68      26.007  39.875  29.876  1.00 35.02           O  
ATOM    467  OD2 ASP    68      24.481  38.589  30.842  1.00 33.10           O  
ATOM    468  N   THR    69      23.038  43.948  29.865  1.00 35.66           N  
ATOM    469  CA  THR    69      22.075  44.989  29.518  1.00 34.35           C  
ATOM    470  C   THR    69      21.996  46.196  30.461  1.00 37.99           C  
ATOM    471  O   THR    69      21.239  46.188  31.440  1.00 71.48           O  
ATOM    472  CB  THR    69      20.667  44.439  29.417  1.00 32.31           C  
ATOM    473  OG1 THR    69      20.701  43.139  28.797  1.00 33.54           O  
ATOM    474  CG2 THR    69      19.833  45.393  28.545  1.00 35.19           C  
ATOM    475  N   PRO    70      22.791  47.243  30.187  1.00 71.09           N  
ATOM    476  CA  PRO    70      22.777  48.455  31.019  1.00 70.65           C  
ATOM    477  C   PRO    70      21.468  49.209  30.766  1.00 70.27           C  
ATOM    478  O   PRO    70      21.241  50.307  31.275  1.00 69.44           O  
ATOM    479  CB  PRO    70      24.015  49.227  30.537  1.00 71.09           C  
ATOM    480  CG  PRO    70      24.252  48.684  29.133  1.00 72.04           C  
ATOM    481  CD  PRO    70      23.974  47.218  29.308  1.00 71.20           C  
ATOM    482  N   GLU    71      20.607  48.581  29.972  1.00 71.09           N  
ATOM    483  CA  GLU    71      19.312  49.150  29.616  1.00 75.30           C  
ATOM    484  C   GLU    71      18.296  48.896  30.714  1.00 78.01           C  
ATOM    485  O   GLU    71      17.318  49.623  30.850  1.00 79.60           O  
ATOM    486  CB  GLU    71      18.815  48.533  28.315  1.00 75.45           C  
ATOM    487  N   VAL    72      18.552  47.858  31.502  1.00 80.19           N  
ATOM    488  CA  VAL    72      17.645  47.444  32.562  1.00 79.15           C  
ATOM    489  C   VAL    72      17.993  47.917  33.969  1.00 79.08           C  
ATOM    490  O   VAL    72      19.128  48.300  34.268  1.00 80.56           O  
ATOM    491  CB  VAL    72      17.540  45.919  32.569  1.00 78.95           C  
ATOM    492  CG1 VAL    72      18.800  45.316  33.164  1.00 78.97           C  
ATOM    493  CG2 VAL    72      16.306  45.478  33.315  1.00 79.92           C  
ATOM    494  N   GLY    73      16.994  47.891  34.840  1.00 77.79           N  
ATOM    495  CA  GLY    73      17.215  48.295  36.213  1.00 74.50           C  
ATOM    496  C   GLY    73      17.176  47.054  37.076  1.00 72.12           C  
ATOM    497  O   GLY    73      16.435  46.124  36.778  1.00 71.30           O  
ATOM    498  N   VAL    74      18.000  47.009  38.115  1.00 69.87           N  
ATOM    499  CA  VAL    74      17.980  45.867  39.021  1.00 67.33           C  
ATOM    500  C   VAL    74      17.924  46.378  40.446  1.00 65.07           C  
ATOM    501  O   VAL    74      18.701  47.252  40.840  1.00 64.68           O  
ATOM    502  CB  VAL    74      19.230  44.925  38.893  1.00 66.36           C  
ATOM    503  CG1 VAL    74      19.382  44.433  37.469  1.00 67.21           C  
ATOM    504  CG2 VAL    74      20.488  45.624  39.395  1.00 66.08           C  
ATOM    505  N   ALA    75      16.990  45.844  41.216  1.00 62.21           N  
ATOM    506  CA  ALA    75      16.860  46.233  42.612  1.00 59.82           C  
ATOM    507  C   ALA    75      17.039  44.956  43.415  1.00 57.48           C  
ATOM    508  O   ALA    75      16.521  43.898  43.035  1.00 55.79           O  
ATOM    509  CB  ALA    75      15.487  46.840  42.869  1.00 59.11           C  
ATOM    510  N   THR    76      17.802  45.046  44.501  1.00 57.35           N  
ATOM    511  CA  THR    76      18.046  43.886  45.356  1.00 54.95           C  
ATOM    512  C   THR    76      16.774  43.588  46.149  1.00 54.39           C  
ATOM    513  O   THR    76      16.188  44.504  46.720  1.00 55.28           O  
ATOM    514  CB  THR    76      19.146  44.179  46.376  1.00 54.73           C  
ATOM    515  OG1 THR    76      20.137  45.028  45.789  1.00 53.12           O  
ATOM    516  CG2 THR    76      19.791  42.875  46.837  1.00 48.76           C  
ATOM    517  N   ILE    77      16.351  42.339  46.161  1.00 54.78           N  
ATOM    518  CA  ILE    77      15.153  41.933  46.919  1.00 53.95           C  
ATOM    519  C   ILE    77      15.629  41.454  48.293  1.00 53.85           C  
ATOM    520  O   ILE    77      15.225  41.980  49.326  1.00 53.87           O  
ATOM    521  CB  ILE    77      14.389  40.777  46.214  1.00 53.06           C  
ATOM    522  CG1 ILE    77      13.793  41.277  44.891  1.00 49.37           C  
ATOM    523  CG2 ILE    77      13.299  40.243  47.112  1.00 51.41           C  
ATOM    524  CD1 ILE    77      13.302  40.153  43.972  1.00 50.91           C  
ATOM    525  N   ASP    78      16.508  40.458  48.278  1.00 55.39           N  
ATOM    526  CA  ASP    78      17.093  39.904  49.496  1.00 55.89           C  
ATOM    527  C   ASP    78      18.510  39.412  49.202  1.00 54.38           C  
ATOM    528  O   ASP    78      18.835  39.076  48.067  1.00 53.61           O  
ATOM    529  CB  ASP    78      16.253  38.747  50.015  1.00 54.72           C  
ATOM    530  CG  ASP    78      16.001  37.701  48.953  1.00 59.69           C  
ATOM    531  OD1 ASP    78      14.817  37.481  48.619  1.00 61.41           O  
ATOM    532  OD2 ASP    78      16.980  37.107  48.448  1.00 60.49           O  
ATOM    533  N   MET    79      19.342  39.374  50.239  1.00 55.52           N  
ATOM    534  CA  MET    79      20.716  38.921  50.105  1.00 55.94           C  
ATOM    535  C   MET    79      21.201  38.170  51.340  1.00 55.05           C  
ATOM    536  O   MET    79      20.918  38.560  52.478  1.00 54.67           O  
ATOM    537  CB  MET    79      21.634  40.112  49.844  1.00 57.77           C  
ATOM    538  CG  MET    79      23.104  39.746  49.644  1.00 61.43           C  
ATOM    539  SD  MET    79      24.188  41.319  49.288  1.00 69.63          SE  
ATOM    540  CE  MET    79      23.137  41.999  47.825  1.00 68.28           C  
ATOM    541  N   ASN    80      21.939  37.097  51.098  1.00 55.10           N  
ATOM    542  CA  ASN    80      22.491  36.243  52.142  1.00 53.44           C  
ATOM    543  C   ASN    80      24.026  36.260  52.038  1.00 52.11           C  
ATOM    544  O   ASN    80      24.590  36.005  50.981  1.00 50.58           O  
ATOM    545  CB  ASN    80      21.935  34.822  51.964  1.00 53.41           C  
ATOM    546  CG  ASN    80      22.277  33.905  53.126  1.00 54.82           C  
ATOM    547  OD1 ASN    80      23.412  33.444  53.253  1.00 56.64           O  
ATOM    548  ND2 ASN    80      21.297  33.642  53.982  1.00 54.68           N  
ATOM    549  N   THR    81      24.690  36.577  53.140  1.00 52.31           N  
ATOM    550  CA  THR    81      26.142  36.657  53.148  1.00 51.58           C  
ATOM    551  C   THR    81      26.772  35.788  54.236  1.00 50.18           C  
ATOM    552  O   THR    81      26.372  35.825  55.406  1.00 47.55           O  
ATOM    553  CB  THR    81      26.595  38.130  53.333  1.00 50.52           C  
ATOM    554  OG1 THR    81      25.786  38.979  52.513  1.00 53.11           O  
ATOM    555  CG2 THR    81      28.056  38.313  52.912  1.00 51.60           C  
ATOM    556  N   SER    82      27.756  34.999  53.822  1.00 49.70           N  
ATOM    557  CA  SER    82      28.486  34.119  54.715  1.00 48.38           C  
ATOM    558  C   SER    82      29.867  34.719  54.962  1.00 49.69           C  
ATOM    559  O   SER    82      30.508  35.220  54.032  1.00 49.83           O  
ATOM    560  CB  SER    82      28.605  32.733  54.090  1.00 47.04           C  
ATOM    561  OG  SER    82      27.380  32.035  54.219  1.00 47.27           O  
ATOM    562  N   PHE    83      30.305  34.683  56.217  1.00 48.39           N  
ATOM    563  CA  PHE    83      31.596  35.233  56.601  1.00 52.04           C  
ATOM    564  C   PHE    83      32.540  34.094  56.982  1.00 53.41           C  
ATOM    565  O   PHE    83      32.405  33.475  58.034  1.00 51.27           O  
ATOM    566  CB  PHE    83      31.401  36.230  57.751  1.00 52.31           C  
ATOM    567  CG  PHE    83      30.568  37.417  57.369  1.00 48.98           C  
ATOM    568  CD1 PHE    83      31.084  38.398  56.533  1.00 47.82           C  
ATOM    569  CD2 PHE    83      29.237  37.511  57.769  1.00 47.87           C  
ATOM    570  CE1 PHE    83      30.289  39.456  56.094  1.00 48.23           C  
ATOM    571  CE2 PHE    83      28.431  38.571  57.331  1.00 50.92           C  
ATOM    572  CZ  PHE    83      28.956  39.538  56.494  1.00 47.91           C  
ATOM    573  N   MET    84      33.502  33.828  56.103  1.00 56.89           N  
ATOM    574  CA  MET    84      34.440  32.731  56.301  1.00 59.89           C  
ATOM    575  C   MET    84      35.791  33.067  56.893  1.00 60.24           C  
ATOM    576  O   MET    84      36.319  32.314  57.712  1.00 60.94           O  
ATOM    577  CB  MET    84      34.684  32.014  54.981  1.00 60.79           C  
ATOM    578  CG  MET    84      33.579  31.076  54.553  1.00 67.59           C  
ATOM    579  SD  MET    84      32.327  31.852  53.306  1.00 82.87          SE  
ATOM    580  CE  MET    84      31.428  30.224  52.768  1.00 74.13           C  
ATOM    581  N   SER    85      36.350  34.189  56.463  1.00 62.74           N  
ATOM    582  CA  SER    85      37.663  34.601  56.904  1.00 65.29           C  
ATOM    583  C   SER    85      37.779  36.104  56.991  1.00 67.79           C  
ATOM    584  O   SER    85      37.254  36.828  56.149  1.00 68.96           O  
ATOM    585  CB  SER    85      38.706  34.086  55.915  1.00 65.16           C  
ATOM    586  OG  SER    85      38.545  32.696  55.708  1.00 67.38           O  
ATOM    587  N   PRO    86      38.474  36.593  58.021  1.00 68.91           N  
ATOM    588  CA  PRO    86      38.650  38.034  58.184  1.00 69.20           C  
ATOM    589  C   PRO    86      39.234  38.589  56.898  1.00 69.57           C  
ATOM    590  O   PRO    86      40.109  37.973  56.303  1.00 69.70           O  
ATOM    591  CB  PRO    86      39.628  38.129  59.352  1.00 70.10           C  
ATOM    592  CG  PRO    86      39.254  36.938  60.189  1.00 69.38           C  
ATOM    593  CD  PRO    86      39.057  35.851  59.154  1.00 68.26           C  
ATOM    594  N   GLY    87      38.742  39.745  56.469  1.00 71.21           N  
ATOM    595  CA  GLY    87      39.238  40.352  55.246  1.00 70.14           C  
ATOM    596  C   GLY    87      40.309  41.386  55.524  1.00 71.08           C  
ATOM    597  O   GLY    87      40.143  42.241  56.393  1.00 70.15           O  
ATOM    598  N   ARG    88      41.409  41.313  54.778  1.00 72.20           N  
ATOM    599  CA  ARG    88      42.517  42.243  54.947  1.00 71.33           C  
ATOM    600  C   ARG    88      43.218  42.528  53.626  1.00 71.05           C  
ATOM    601  O   ARG    88      43.272  41.670  52.749  1.00 71.84           O  
ATOM    602  CB  ARG    88      43.516  41.671  55.954  1.00 72.66           C  
ATOM    603  CG  ARG    88      42.998  41.644  57.382  1.00 72.27           C  
ATOM    604  CD  ARG    88      43.927  40.870  58.295  1.00 76.68           C  
ATOM    605  NE  ARG    88      43.204  39.848  59.050  1.00 79.59           N  
ATOM    606  CZ  ARG    88      43.741  39.114  60.017  1.00 79.58           C  
ATOM    607  NH1 ARG    88      45.013  39.287  60.351  1.00 82.63           N  
ATOM    608  NH2 ARG    88      43.008  38.207  60.651  1.00 78.13           N  
ATOM    609  N   GLY    89      43.758  43.735  53.488  1.00 70.69           N  
ATOM    610  CA  GLY    89      44.446  44.101  52.264  1.00 71.85           C  
ATOM    611  C   GLY    89      43.462  44.226  51.121  1.00 73.12           C  
ATOM    612  O   GLY    89      42.256  44.199  51.342  1.00 73.84           O  
ATOM    613  N   ASP    90      43.970  44.370  49.901  1.00 72.73           N  
ATOM    614  CA  ASP    90      43.117  44.490  48.723  1.00 72.06           C  
ATOM    615  C   ASP    90      42.302  43.219  48.534  1.00 70.71           C  
ATOM    616  O   ASP    90      42.810  42.110  48.713  1.00 71.10           O  
ATOM    617  CB  ASP    90      43.955  44.724  47.462  1.00 73.55           C  
ATOM    618  CG  ASP    90      44.353  46.179  47.277  1.00 74.11           C  
ATOM    619  OD1 ASP    90      44.944  46.770  48.208  1.00 73.77           O  
ATOM    620  OD2 ASP    90      44.085  46.727  46.188  1.00 75.54           O  
ATOM    621  N   LEU    91      41.039  43.384  48.161  1.00 68.33           N  
ATOM    622  CA  LEU    91      40.155  42.244  47.931  1.00 64.69           C  
ATOM    623  C   LEU    91      39.545  42.356  46.539  1.00 63.47           C  
ATOM    624  O   LEU    91      39.327  43.463  46.031  1.00 61.92           O  
ATOM    625  CB  LEU    91      39.041  42.216  48.972  1.00 63.68           C  
ATOM    626  CG  LEU    91      39.459  42.248  50.440  1.00 59.55           C  
ATOM    627  CD1 LEU    91      38.233  42.541  51.291  1.00 60.67           C  
ATOM    628  CD2 LEU    91      40.101  40.933  50.843  1.00 56.88           C  
ATOM    629  N   VAL    92      39.282  41.211  45.920  1.00 61.53           N  
ATOM    630  CA  VAL    92      38.691  41.204  44.593  1.00 60.01           C  
ATOM    631  C   VAL    92      37.337  40.527  44.720  1.00 57.88           C  
ATOM    632  O   VAL    92      37.203  39.510  45.393  1.00 55.94           O  
ATOM    633  CB  VAL    92      39.602  40.457  43.559  1.00 59.18           C  
ATOM    634  CG1 VAL    92      39.536  38.961  43.765  1.00 62.89           C  
ATOM    635  CG2 VAL    92      39.200  40.833  42.151  1.00 60.68           C  
ATOM    636  N   ILE    93      36.331  41.116  44.085  1.00 58.48           N  
ATOM    637  CA  ILE    93      34.974  40.592  44.144  1.00 57.13           C  
ATOM    638  C   ILE    93      34.493  40.141  42.774  1.00 55.90           C  
ATOM    639  O   ILE    93      34.531  40.904  41.809  1.00 56.68           O  
ATOM    640  CB  ILE    93      34.014  41.662  44.710  1.00 57.13           C  
ATOM    641  CG1 ILE    93      34.526  42.132  46.072  1.00 54.80           C  
ATOM    642  CG2 ILE    93      32.602  41.107  44.837  1.00 53.88           C  
ATOM    643  CD1 ILE    93      35.587  43.210  45.997  1.00 48.07           C  
ATOM    644  N   GLU    94      34.035  38.898  42.698  1.00 56.37           N  
ATOM    645  CA  GLU    94      33.559  38.346  41.436  1.00 56.42           C  
ATOM    646  C   GLU    94      32.210  37.645  41.589  1.00 55.31           C  
ATOM    647  O   GLU    94      32.034  36.791  42.451  1.00 54.64           O  
ATOM    648  CB  GLU    94      34.588  37.364  40.873  1.00 58.89           C  
ATOM    649  CG  GLU    94      35.954  37.969  40.620  1.00 62.05           C  
ATOM    650  CD  GLU    94      36.781  37.142  39.657  1.00 69.04           C  
ATOM    651  OE1 GLU    94      37.265  37.703  38.646  1.00 67.11           O  
ATOM    652  OE2 GLU    94      36.945  35.932  39.908  1.00 70.83           O  
ATOM    653  N   THR    95      31.272  38.000  40.720  1.00 55.95           N  
ATOM    654  CA  THR    95      29.928  37.445  40.761  1.00 55.64           C  
ATOM    655  C   THR    95      29.519  36.789  39.450  1.00 57.43           C  
ATOM    656  O   THR    95      30.160  36.987  38.421  1.00 59.47           O  
ATOM    657  CB  THR    95      28.905  38.544  41.078  1.00 55.35           C  
ATOM    658  OG1 THR    95      29.008  39.593  40.104  1.00 53.07           O  
ATOM    659  CG2 THR    95      29.155  39.118  42.467  1.00 51.92           C  
ATOM    660  N   ARG    96      28.447  36.006  39.500  1.00 58.84           N  
ATOM    661  CA  ARG    96      27.907  35.334  38.318  1.00 58.70           C  
ATOM    662  C   ARG    96      26.393  35.235  38.479  1.00 57.98           C  
ATOM    663  O   ARG    96      25.894  35.043  39.589  1.00 57.43           O  
ATOM    664  CB  ARG    96      28.516  33.928  38.154  1.00 60.02           C  
ATOM    665  CG  ARG    96      28.151  32.917  39.244  1.00 64.39           C  
ATOM    666  CD  ARG    96      29.294  31.922  39.471  1.00 73.23           C  
ATOM    667  NE  ARG    96      30.532  32.618  39.831  1.00 79.38           N  
ATOM    668  CZ  ARG    96      31.044  32.700  41.058  1.00 77.77           C  
ATOM    669  NH1 ARG    96      30.442  32.122  42.088  1.00 75.44           N  
ATOM    670  NH2 ARG    96      32.164  33.384  41.255  1.00 77.42           N  
ATOM    671  N   CYS    97      25.664  35.390  37.378  1.00 57.49           N  
ATOM    672  CA  CYS    97      24.211  35.306  37.416  1.00 55.67           C  
ATOM    673  C   CYS    97      23.878  33.840  37.260  1.00 55.73           C  
ATOM    674  O   CYS    97      24.382  33.193  36.350  1.00 58.61           O  
ATOM    675  CB  CYS    97      23.593  36.101  36.269  1.00 56.18           C  
ATOM    676  SG  CYS    97      21.779  36.147  36.286  1.00 57.01           S  
ATOM    677  N   LEU    98      23.040  33.313  38.146  1.00 54.26           N  
ATOM    678  CA  LEU    98      22.664  31.897  38.098  1.00 52.21           C  
ATOM    679  C   LEU    98      21.433  31.641  37.250  1.00 49.03           C  
ATOM    680  O   LEU    98      21.256  30.560  36.704  1.00 46.12           O  
ATOM    681  CB  LEU    98      22.395  31.381  39.504  1.00 54.15           C  
ATOM    682  CG  LEU    98      23.539  31.416  40.510  1.00 54.58           C  
ATOM    683  CD1 LEU    98      22.973  31.175  41.898  1.00 46.73           C  
ATOM    684  CD2 LEU    98      24.594  30.369  40.145  1.00 56.93           C  
ATOM    685  N   ARG    99      20.568  32.644  37.178  1.00 50.48           N  
ATOM    686  CA  ARG    99      19.344  32.557  36.404  1.00 52.49           C  
ATOM    687  C   ARG    99      18.757  33.938  36.190  1.00 52.82           C  
ATOM    688  O   ARG    99      18.828  34.807  37.056  1.00 53.75           O  
ATOM    689  CB  ARG    99      18.304  31.676  37.102  1.00 54.06           C  
ATOM    690  CG  ARG    99      16.945  31.789  36.431  1.00 57.29           C  
ATOM    691  CD  ARG    99      16.145  30.500  36.429  1.00 65.87           C  
ATOM    692  NE  ARG    99      15.023  30.617  35.497  1.00 70.54           N  
ATOM    693  CZ  ARG    99      14.103  31.574  35.559  1.00 67.79           C  
ATOM    694  NH1 ARG    99      14.164  32.496  36.511  1.00 71.10           N  
ATOM    695  NH2 ARG    99      13.132  31.624  34.661  1.00 70.62           N  
ATOM    696  N   ARG   100      18.160  34.132  35.030  1.00 56.24           N  
ATOM    697  CA  ARG   100      17.563  35.413  34.713  1.00 58.79           C  
ATOM    698  C   ARG   100      16.166  35.176  34.156  1.00 59.48           C  
ATOM    699  O   ARG   100      15.992  34.445  33.179  1.00 62.14           O  
ATOM    700  CB  ARG   100      18.432  36.142  33.687  1.00 59.79           C  
ATOM    701  CG  ARG   100      18.455  37.650  33.842  1.00 59.96           C  
ATOM    702  CD  ARG   100      19.412  38.262  32.846  1.00 63.35           C  
ATOM    703  NE  ARG   100      19.086  39.652  32.554  1.00 71.63           N  
ATOM    704  CZ  ARG   100      19.996  40.602  32.363  1.00 73.15           C  
ATOM    705  NH1 ARG   100      21.288  40.302  32.445  1.00 66.78           N  
ATOM    706  NH2 ARG   100      19.618  41.842  32.072  1.00 77.98           N  
ATOM    707  N   GLY   101      15.171  35.778  34.797  1.00 59.68           N  
ATOM    708  CA  GLY   101      13.807  35.625  34.342  1.00 60.36           C  
ATOM    709  C   GLY   101      13.387  36.942  33.748  1.00 59.99           C  
ATOM    710  O   GLY   101      14.216  37.825  33.555  1.00 59.70           O  
ATOM    711  N   ALA   102      12.107  37.086  33.444  1.00 61.31           N  
ATOM    712  CA  ALA   102      11.638  38.337  32.876  1.00 62.56           C  
ATOM    713  C   ALA   102      11.613  39.373  33.981  1.00 63.18           C  
ATOM    714  O   ALA   102      11.869  40.556  33.752  1.00 65.06           O  
ATOM    715  CB  ALA   102      10.259  38.155  32.296  1.00 62.57           C  
ATOM    716  N   SER   103      11.327  38.907  35.191  1.00 63.17           N  
ATOM    717  CA  SER   103      11.222  39.792  36.345  1.00 63.30           C  
ATOM    718  C   SER   103      12.206  39.558  37.492  1.00 60.88           C  
ATOM    719  O   SER   103      12.620  40.507  38.152  1.00 59.41           O  
ATOM    720  CB  SER   103       9.791  39.713  36.886  1.00 65.59           C  
ATOM    721  OG  SER   103       9.628  40.516  38.041  1.00 72.67           O  
ATOM    722  N   ILE   104      12.576  38.294  37.712  1.00 60.81           N  
ATOM    723  CA  ILE   104      13.469  37.891  38.813  1.00 58.72           C  
ATOM    724  C   ILE   104      14.853  37.356  38.406  1.00 59.10           C  
ATOM    725  O   ILE   104      14.965  36.490  37.540  1.00 56.77           O  
ATOM    726  CB  ILE   104      12.793  36.791  39.674  1.00 58.71           C  
ATOM    727  CG1 ILE   104      11.414  37.255  40.143  1.00 54.91           C  
ATOM    728  CG2 ILE   104      13.657  36.457  40.872  1.00 56.87           C  
ATOM    729  CD1 ILE   104      11.455  38.329  41.208  1.00 53.11           C  
ATOM    730  N   ALA   105      15.897  37.851  39.069  1.00 57.55           N  
ATOM    731  CA  ALA   105      17.265  37.408  38.791  1.00 55.87           C  
ATOM    732  C   ALA   105      17.959  36.863  40.039  1.00 53.73           C  
ATOM    733  O   ALA   105      17.839  37.433  41.119  1.00 52.30           O  
ATOM    734  CB  ALA   105      18.079  38.563  38.209  1.00 55.98           C  
ATOM    735  N   PHE   106      18.697  35.765  39.878  1.00 54.37           N  
ATOM    736  CA  PHE   106      19.435  35.138  40.984  1.00 54.66           C  
ATOM    737  C   PHE   106      20.934  35.283  40.757  1.00 56.10           C  
ATOM    738  O   PHE   106      21.431  35.012  39.668  1.00 58.87           O  
ATOM    739  CB  PHE   106      19.118  33.647  41.074  1.00 51.44           C  
ATOM    740  CG  PHE   106      17.710  33.342  41.483  1.00 50.85           C  
ATOM    741  CD1 PHE   106      17.320  33.428  42.822  1.00 44.53           C  
ATOM    742  CD2 PHE   106      16.763  32.968  40.527  1.00 46.72           C  
ATOM    743  CE1 PHE   106      16.002  33.144  43.214  1.00 39.63           C  
ATOM    744  CE2 PHE   106      15.439  32.684  40.904  1.00 47.44           C  
ATOM    745  CZ  PHE   106      15.059  32.773  42.253  1.00 49.21           C  
ATOM    746  N   CYS   107      21.658  35.694  41.788  1.00 59.42           N  
ATOM    747  CA  CYS   107      23.103  35.859  41.666  1.00 60.48           C  
ATOM    748  C   CYS   107      23.868  35.361  42.879  1.00 58.89           C  
ATOM    749  O   CYS   107      23.320  35.228  43.968  1.00 58.15           O  
ATOM    750  CB  CYS   107      23.451  37.333  41.430  1.00 59.77           C  
ATOM    751  SG  CYS   107      22.814  38.008  39.875  1.00 68.43           S  
ATOM    752  N   GLU   108      25.142  35.060  42.670  1.00 58.74           N  
ATOM    753  CA  GLU   108      26.014  34.615  43.746  1.00 57.79           C  
ATOM    754  C   GLU   108      27.394  35.209  43.505  1.00 56.15           C  
ATOM    755  O   GLU   108      27.675  35.741  42.435  1.00 56.27           O  
ATOM    756  CB  GLU   108      26.088  33.090  43.809  1.00 56.81           C  
ATOM    757  CG  GLU   108      26.431  32.413  42.505  1.00 59.58           C  
ATOM    758  CD  GLU   108      27.160  31.110  42.723  1.00 56.82           C  
ATOM    759  OE1 GLU   108      26.776  30.354  43.640  1.00 62.65           O  
ATOM    760  OE2 GLU   108      28.122  30.847  41.975  1.00 63.95           O  
ATOM    761  N   GLY   109      28.252  35.143  44.510  1.00 55.69           N  
ATOM    762  CA  GLY   109      29.573  35.711  44.349  1.00 56.85           C  
ATOM    763  C   GLY   109      30.464  35.456  45.541  1.00 56.87           C  
ATOM    764  O   GLY   109      30.046  34.847  46.526  1.00 54.75           O  
ATOM    765  N   GLU   110      31.693  35.955  45.459  1.00 57.17           N  
ATOM    766  CA  GLU   110      32.664  35.744  46.520  1.00 58.54           C  
ATOM    767  C   GLU   110      33.738  36.825  46.563  1.00 56.41           C  
ATOM    768  O   GLU   110      34.023  37.483  45.560  1.00 57.20           O  
ATOM    769  CB  GLU   110      33.321  34.376  46.325  1.00 58.69           C  
ATOM    770  CG  GLU   110      33.367  33.958  44.854  1.00 67.99           C  
ATOM    771  CD  GLU   110      34.447  32.940  44.547  1.00 76.41           C  
ATOM    772  OE1 GLU   110      34.343  31.793  45.033  1.00 83.23           O  
ATOM    773  OE2 GLU   110      35.399  33.295  43.814  1.00 76.64           O  
ATOM    774  N   ILE   111      34.327  36.997  47.741  1.00 55.20           N  
ATOM    775  CA  ILE   111      35.387  37.964  47.944  1.00 53.99           C  
ATOM    776  C   ILE   111      36.631  37.171  48.334  1.00 53.91           C  
ATOM    777  O   ILE   111      36.563  36.255  49.158  1.00 52.14           O  
ATOM    778  CB  ILE   111      35.039  38.952  49.079  1.00 55.99           C  
ATOM    779  CG1 ILE   111      33.687  39.618  48.794  1.00 50.38           C  
ATOM    780  CG2 ILE   111      36.146  40.007  49.213  1.00 52.86           C  
ATOM    781  CD1 ILE   111      33.182  40.488  49.915  1.00 44.32           C  
ATOM    782  N   ARG   112      37.767  37.512  47.740  1.00 54.95           N  
ATOM    783  CA  ARG   112      39.004  36.802  48.049  1.00 57.36           C  
ATOM    784  C   ARG   112      40.111  37.804  48.309  1.00 58.33           C  
ATOM    785  O   ARG   112      40.093  38.914  47.770  1.00 58.61           O  
ATOM    786  CB  ARG   112      39.401  35.876  46.890  1.00 55.02           C  
ATOM    787  CG  ARG   112      38.240  35.058  46.326  1.00 58.53           C  
ATOM    788  CD  ARG   112      38.714  33.889  45.468  1.00 59.84           C  
ATOM    789  NE  ARG   112      38.967  32.697  46.276  1.00 55.17           N  
ATOM    790  CZ  ARG   112      38.262  31.576  46.185  1.00 56.50           C  
ATOM    791  NH1 ARG   112      37.268  31.499  45.312  1.00 57.16           N  
ATOM    792  NH2 ARG   112      38.530  30.546  46.983  1.00 53.22           N  
ATOM    793  N   ASP   113      41.065  37.418  49.149  1.00 59.75           N  
ATOM    794  CA  ASP   113      42.187  38.293  49.460  1.00 61.42           C  
ATOM    795  C   ASP   113      43.326  38.045  48.482  1.00 61.61           C  
ATOM    796  O   ASP   113      43.249  37.151  47.643  1.00 61.62           O  
ATOM    797  CB  ASP   113      42.678  38.072  50.899  1.00 63.46           C  
ATOM    798  CG  ASP   113      42.922  36.614  51.225  1.00 62.82           C  
ATOM    799  OD1 ASP   113      43.513  35.895  50.390  1.00 71.52           O  
ATOM    800  OD2 ASP   113      42.531  36.189  52.327  1.00 61.21           O  
ATOM    801  N   SER   114      44.375  38.852  48.590  1.00 63.28           N  
ATOM    802  CA  SER   114      45.539  38.730  47.722  1.00 64.00           C  
ATOM    803  C   SER   114      46.053  37.295  47.693  1.00 65.13           C  
ATOM    804  O   SER   114      46.604  36.850  46.693  1.00 66.04           O  
ATOM    805  CB  SER   114      46.643  39.679  48.204  1.00 65.13           C  
ATOM    806  OG  SER   114      46.817  39.600  49.612  1.00 60.56           O  
ATOM    807  N   ALA   115      45.849  36.572  48.792  1.00 66.03           N  
ATOM    808  CA  ALA   115      46.287  35.183  48.918  1.00 65.08           C  
ATOM    809  C   ALA   115      45.301  34.190  48.297  1.00 65.99           C  
ATOM    810  O   ALA   115      45.504  32.977  48.367  1.00 66.38           O  
ATOM    811  CB  ALA   115      46.511  34.846  50.396  1.00 65.09           C  
ATOM    812  N   GLY   116      44.227  34.714  47.707  1.00 66.72           N  
ATOM    813  CA  GLY   116      43.228  33.874  47.061  1.00 64.83           C  
ATOM    814  C   GLY   116      42.303  33.078  47.968  1.00 64.48           C  
ATOM    815  O   GLY   116      41.588  32.188  47.501  1.00 63.85           O  
ATOM    816  N   GLU   117      42.304  33.389  49.259  1.00 63.88           N  
ATOM    817  CA  GLU   117      41.458  32.672  50.204  1.00 64.34           C  
ATOM    818  C   GLU   117      40.067  33.306  50.290  1.00 62.51           C  
ATOM    819  O   GLU   117      39.922  34.529  50.216  1.00 62.86           O  
ATOM    820  CB  GLU   117      42.115  32.656  51.587  1.00 65.37           C  
ATOM    821  CG  GLU   117      42.256  31.277  52.213  1.00 66.65           C  
ATOM    822  CD  GLU   117      43.127  30.333  51.389  1.00 73.09           C  
ATOM    823  OE1 GLU   117      44.185  30.772  50.883  1.00 72.72           O  
ATOM    824  OE2 GLU   117      42.761  29.144  51.258  1.00 73.02           O  
ATOM    825  N   LEU   118      39.053  32.461  50.444  1.00 59.68           N  
ATOM    826  CA  LEU   118      37.671  32.909  50.529  1.00 59.25           C  
ATOM    827  C   LEU   118      37.402  33.732  51.794  1.00 58.30           C  
ATOM    828  O   LEU   118      37.537  33.241  52.920  1.00 54.60           O  
ATOM    829  CB  LEU   118      36.729  31.695  50.472  1.00 60.95           C  
ATOM    830  CG  LEU   118      35.239  31.901  50.169  1.00 59.70           C  
ATOM    831  CD1 LEU   118      35.060  32.717  48.881  1.00 53.79           C  
ATOM    832  CD2 LEU   118      34.574  30.539  50.026  1.00 56.32           C  
ATOM    833  N   VAL   119      37.034  34.994  51.588  1.00 57.09           N  
ATOM    834  CA  VAL   119      36.725  35.905  52.679  1.00 56.54           C  
ATOM    835  C   VAL   119      35.238  35.783  53.006  1.00 54.43           C  
ATOM    836  O   VAL   119      34.868  35.530  54.149  1.00 55.22           O  
ATOM    837  CB  VAL   119      37.065  37.375  52.296  1.00 56.87           C  
ATOM    838  CG1 VAL   119      36.539  38.330  53.353  1.00 56.66           C  
ATOM    839  CG2 VAL   119      38.580  37.534  52.157  1.00 57.01           C  
ATOM    840  N   ALA   120      34.393  35.949  51.996  1.00 53.42           N  
ATOM    841  CA  ALA   120      32.947  35.838  52.174  1.00 54.17           C  
ATOM    842  C   ALA   120      32.283  35.429  50.873  1.00 52.69           C  
ATOM    843  O   ALA   120      32.813  35.685  49.804  1.00 54.05           O  
ATOM    844  CB  ALA   120      32.370  37.164  52.656  1.00 51.04           C  
ATOM    845  N   LYS   121      31.128  34.785  50.974  1.00 53.82           N  
ATOM    846  CA  LYS   121      30.365  34.361  49.807  1.00 53.64           C  
ATOM    847  C   LYS   121      28.933  34.842  50.040  1.00 53.35           C  
ATOM    848  O   LYS   121      28.452  34.835  51.174  1.00 51.67           O  
ATOM    849  CB  LYS   121      30.399  32.838  49.663  1.00 53.76           C  
ATOM    850  CG  LYS   121      30.210  32.357  48.236  1.00 60.50           C  
ATOM    851  CD  LYS   121      30.881  31.005  48.023  1.00 69.99           C  
ATOM    852  CE  LYS   121      30.995  30.643  46.543  1.00 72.37           C  
ATOM    853  NZ  LYS   121      29.668  30.515  45.889  1.00 75.53           N  
ATOM    854  N   ALA   122      28.257  35.258  48.969  1.00 52.17           N  
ATOM    855  CA  ALA   122      26.894  35.764  49.095  1.00 50.01           C  
ATOM    856  C   ALA   122      25.981  35.395  47.937  1.00 47.99           C  
ATOM    857  O   ALA   122      26.429  35.170  46.821  1.00 47.40           O  
ATOM    858  CB  ALA   122      26.921  37.286  49.260  1.00 47.87           C  
ATOM    859  N   THR   123      24.690  35.305  48.219  1.00 48.48           N  
ATOM    860  CA  THR   123      23.720  35.027  47.175  1.00 50.18           C  
ATOM    861  C   THR   123      22.708  36.170  47.283  1.00 50.64           C  
ATOM    862  O   THR   123      22.557  36.775  48.351  1.00 49.94           O  
ATOM    863  CB  THR   123      23.031  33.656  47.369  1.00 48.58           C  
ATOM    864  OG1 THR   123      22.423  33.601  48.666  1.00 52.63           O  
ATOM    865  CG2 THR   123      24.043  32.516  47.217  1.00 48.88           C  
ATOM    866  N   ALA   124      22.047  36.491  46.176  1.00 50.30           N  
ATOM    867  CA  ALA   124      21.073  37.577  46.166  1.00 49.15           C  
ATOM    868  C   ALA   124      19.970  37.360  45.144  1.00 50.23           C  
ATOM    869  O   ALA   124      20.143  36.646  44.150  1.00 48.07           O  
ATOM    870  CB  ALA   124      21.767  38.900  45.896  1.00 49.07           C  
ATOM    871  N   THR   125      18.823  37.969  45.410  1.00 49.61           N  
ATOM    872  CA  THR   125      17.695  37.868  44.509  1.00 49.31           C  
ATOM    873  C   THR   125      17.456  39.292  44.042  1.00 47.89           C  
ATOM    874  O   THR   125      17.596  40.240  44.816  1.00 47.69           O  
ATOM    875  CB  THR   125      16.435  37.301  45.215  1.00 48.47           C  
ATOM    876  OG1 THR   125      16.746  36.048  45.841  1.00 46.66           O  
ATOM    877  CG2 THR   125      15.350  37.055  44.207  1.00 49.82           C  
ATOM    878  N   PHE   126      17.099  39.452  42.777  1.00 47.83           N  
ATOM    879  CA  PHE   126      16.909  40.798  42.258  1.00 49.42           C  
ATOM    880  C   PHE   126      15.630  41.041  41.484  1.00 49.91           C  
ATOM    881  O   PHE   126      15.075  40.134  40.859  1.00 48.27           O  
ATOM    882  CB  PHE   126      18.075  41.197  41.342  1.00 47.90           C  
ATOM    883  CG  PHE   126      19.377  41.440  42.062  1.00 46.56           C  
ATOM    884  CD1 PHE   126      20.242  40.387  42.367  1.00 46.64           C  
ATOM    885  CD2 PHE   126      19.758  42.734  42.399  1.00 40.34           C  
ATOM    886  CE1 PHE   126      21.478  40.634  42.997  1.00 45.60           C  
ATOM    887  CE2 PHE   126      20.988  42.991  43.028  1.00 42.33           C  
ATOM    888  CZ  PHE   126      21.849  41.935  43.324  1.00 39.69           C  
ATOM    889  N   LYS   127      15.173  42.290  41.522  1.00 53.22           N  
ATOM    890  CA  LYS   127      14.003  42.701  40.755  1.00 57.90           C  
ATOM    891  C   LYS   127      14.625  43.362  39.520  1.00 59.78           C  
ATOM    892  O   LYS   127      15.464  44.259  39.659  1.00 58.23           O  
ATOM    893  CB  LYS   127      13.184  43.727  41.536  1.00 56.86           C  
ATOM    894  N   ILE   128      14.283  42.901  38.321  1.00 63.95           N  
ATOM    895  CA  ILE   128      14.820  43.588  37.157  1.00 68.16           C  
ATOM    896  C   ILE   128      13.707  44.524  36.743  1.00 71.94           C  
ATOM    897  O   ILE   128      12.611  44.095  36.375  1.00 71.60           O  
ATOM    898  CB  ILE   128      15.243  42.644  35.982  1.00 67.37           C  
ATOM    899  CG1 ILE   128      14.467  41.327  36.011  1.00 63.20           C  
ATOM    900  CG2 ILE   128      16.746  42.394  36.053  1.00 68.21           C  
ATOM    901  CD1 ILE   128      15.170  40.208  35.236  1.00 60.33           C  
ATOM    902  N   ILE   129      14.000  45.816  36.858  1.00 75.65           N  
ATOM    903  CA  ILE   129      13.054  46.886  36.560  1.00 79.11           C  
ATOM    904  C   ILE   129      12.728  47.158  35.092  1.00 82.21           C  
ATOM    905  O   ILE   129      13.085  48.203  34.556  1.00 82.94           O  
ATOM    906  CB  ILE   129      13.512  48.223  37.209  1.00 79.07           C  
ATOM    907  CG1 ILE   129      13.778  48.023  38.711  1.00 78.47           C  
ATOM    908  CG2 ILE   129      12.450  49.294  37.007  1.00 79.06           C  
ATOM    909  CD1 ILE   129      12.657  47.332  39.458  1.00 77.73           C  
ATOM    910  N   GLN   130      12.055  46.203  34.453  1.00 85.92           N  
ATOM    911  CA  GLN   130      11.596  46.349  33.074  1.00 88.00           C  
ATOM    912  C   GLN   130      10.817  45.148  32.564  1.00 88.85           C  
ATOM    913  O   GLN   130       9.657  45.373  32.160  1.00 89.20           O  
ATOM    914  CB  GLN   130      12.742  46.702  32.114  1.00 87.61           C  
ATOM    915  CG  GLN   130      12.373  47.924  31.257  1.00 87.70           C  
ATOM    916  CD  GLN   130      11.656  49.016  32.066  1.00 85.68           C  
ATOM    917  OE1 GLN   130      10.611  48.772  32.678  1.00 80.72           O  
ATOM    918  NE2 GLN   130      12.217  50.224  32.065  1.00 84.66           N  
END
