
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   97 ( 1604),  selected   97 , name 2hdc_A
# Molecule2: number of CA atoms   87 ( 1451),  selected   87 , name T0476.pdb
# PARAMETERS: 2hdc_A.T0476.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      A       2           -
LGA    -       -      K       3           -
LGA    -       -      C       4           -
LGA    V     2_A      P       5          2.400
LGA    -       -      I       6           -
LGA    -       -      C       7           -
LGA    K     3_A      G       8          2.741
LGA    P     4_A      S       9          2.613
LGA    P     5_A      P      10          3.497
LGA    Y     6_A      L      11          1.410
LGA    S     7_A      K      12          1.435
LGA    Y     8_A      W      13          1.494
LGA    I     9_A      E      14          2.234
LGA    A    10_A      E      15          2.412
LGA    L    11_A      L      16          1.726
LGA    I    12_A      I      17          2.372
LGA    T    13_A      E      18          3.651
LGA    M    14_A      E      19          4.341
LGA    A    15_A      M      20          4.356
LGA    I    16_A      L      21          4.808
LGA    L    17_A      I      22          4.398
LGA    Q    18_A      I      23          1.964
LGA    S    19_A      E      24          3.117
LGA    P    20_A      N      25          4.975
LGA    Q    21_A      F      26           #
LGA    K    22_A      E      27          3.375
LGA    K    23_A      E      28          1.431
LGA    L    24_A      I      29          1.557
LGA    -       -      V      30           -
LGA    -       -      K      31           -
LGA    T    25_A      D      32          2.575
LGA    L    26_A      R      33          1.693
LGA    S    27_A      E      34          2.103
LGA    G    28_A      R      35          1.766
LGA    I    29_A      F      36          1.632
LGA    C    30_A      L      37          1.441
LGA    E    31_A      A      38          2.365
LGA    F    32_A      Q      39          2.227
LGA    I    33_A      V      40          1.542
LGA    S    34_A      E      41          1.742
LGA    N    35_A      E      42          2.369
LGA    R    36_A      F      43          2.622
LGA    F    37_A      V      44          3.298
LGA    -       -      F      45           -
LGA    -       -      K      46           -
LGA    -       -      C      47           -
LGA    -       -      P      48           -
LGA    -       -      V      49           -
LGA    -       -      C      50           -
LGA    -       -      G      51           -
LGA    -       -      E      52           -
LGA    -       -      E      53           -
LGA    P    38_A      F      54          4.482
LGA    Y    39_A      Y      55          4.193
LGA    Y    40_A      G      56          3.357
LGA    R    41_A      K      57          1.640
LGA    E    42_A      T      58          1.399
LGA    K    43_A      L      59          2.998
LGA    F    44_A      P      60          2.641
LGA    P    45_A      R      61          3.027
LGA    A    46_A      R      62          2.428
LGA    W    47_A      E      63          3.330
LGA    Q    48_A      A      64          2.969
LGA    N    49_A      E      65          2.336
LGA    S    50_A      K      66          1.433
LGA    I    51_A      V      67          1.444
LGA    R    52_A      F      68          2.385
LGA    H    53_A      E      69          2.476
LGA    N    54_A      L      70          3.782
LGA    L    55_A      L      71          4.289
LGA    S    56_A      N      72          4.663
LGA    L    57_A      D      73          4.544
LGA    N    58_A      -       -           -
LGA    D    59_A      -       -           -
LGA    C    60_A      F      74          2.308
LGA    F    61_A      K      75          4.246
LGA    V    62_A      G      76           -
LGA    K    63_A      G      77           -
LGA    I    64_A      -       -           -
LGA    P    65_A      -       -           -
LGA    R    66_A      -       -           -
LGA    E    67_A      -       -           -
LGA    P    68_A      -       -           -
LGA    G    69_A      -       -           -
LGA    N    70_A      -       -           -
LGA    P    71_A      -       -           -
LGA    G    72_A      -       -           -
LGA    K    73_A      -       -           -
LGA    G    74_A      -       -           -
LGA    N    75_A      -       -           -
LGA    Y    76_A      -       -           -
LGA    W    77_A      -       -           -
LGA    T    78_A      -       -           -
LGA    L    79_A      -       -           -
LGA    D    80_A      -       -           -
LGA    P    81_A      -       -           -
LGA    Q    82_A      I      78          5.196
LGA    S    83_A      D      79          2.850
LGA    E    84_A      W      80          1.429
LGA    D    85_A      E      81          2.535
LGA    M    86_A      N      82          3.583
LGA    F    87_A      K      83          1.112
LGA    D    88_A      R      84           #
LGA    N    89_A      -       -           -
LGA    G    90_A      V      85           #
LGA    S    91_A      K      86           -
LGA    F    92_A      L      87           -
LGA    L    93_A      K      88           -
LGA    R    94_A      -       -           -
LGA    R    95_A      -       -           -
LGA    R    96_A      -       -           -
LGA    K    97_A      -       -           -
LGA    R    98_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   97   87    5.0     63    2.95     7.94     43.245     2.064

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.548903 * X  +  -0.635715 * Y  +   0.542744 * Z  +  11.351110
  Y_new =   0.482938 * X  +   0.288781 * Y  +   0.826666 * Z  +  -9.829786
  Z_new =  -0.682258 * X  +   0.715871 * Y  +   0.148498 * Z  +  -4.792766 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.366260   -1.775333  [ DEG:    78.2809   -101.7191 ]
  Theta =   0.750847    2.390745  [ DEG:    43.0204    136.9796 ]
  Phi   =   2.420038   -0.721555  [ DEG:   138.6579    -41.3421 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2hdc_A                                        
REMARK     2: T0476.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2hdc_A.T0476.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   97   87   5.0   63   2.95    7.94  43.245
REMARK  ---------------------------------------------------------- 
MOLECULE 2hdc_A
HEADER    PROTEIN/DNA                             05-MAY-99   2HDC              
TITLE     STRUCTURE OF TRANSCRIPTION FACTOR GENESIS/DNA COMPLEX                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROTEIN (TRANSCRIPTION FACTOR);                            
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: DNA BINDING DOMAIN;                                        
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MOL_ID: 2;                                                           
COMPND   7 MOLECULE: DNA (5'-                                                   
COMPND   8 D(P*GP*CP*TP*TP*AP*AP*AP*AP*TP*AP*AP*CP*AP*AP*TP*AP*C)-3');          
COMPND   9 CHAIN: B;                                                            
COMPND  10 ENGINEERED: YES;                                                     
COMPND  11 MOL_ID: 3;                                                           
COMPND  12 MOLECULE: DNA (5'-                                                   
COMPND  13 D(P*GP*TP*AP*TP*TP*GP*TP*TP*AP*TP*TP*TP*TP*AP*AP*GP*C)-3');          
COMPND  14 CHAIN: C;                                                            
COMPND  15 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: RATTUS NORVEGICUS;                              
SOURCE   3 ORGANISM_COMMON: NORWAY RAT;                                         
SOURCE   4 ORGANELLE: NUCLEUS;                                                  
SOURCE   5 GENE: GENESIS;                                                       
SOURCE   6 MOL_ID: 2;                                                           
SOURCE   7 SYNTHETIC: YES;                                                      
SOURCE   8 MOL_ID: 3;                                                           
SOURCE   9 SYNTHETIC: YES                                                       
KEYWDS    NMR, STRUCTURE, DYANAMICS, GENESIS, WINGED HELIX PROTEIN              
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    C.JIN,I.MARSDEN,X.CHEN,X.LIAO                                         
REVDAT   1   05-JUL-99 2HDC    0                                                
JRNL        AUTH   C.JIN,I.MARSDEN,X.CHEN,X.LIAO                                
JRNL        TITL   DYNAMIC DNA CONTACTS OBSERVED IN THE NMR STRUCTURE           
JRNL        TITL 2 OF WINGED HELIX PROTEIN-DNA COMPLEX.                         
JRNL        REF    J.MOL.BIOL.                   V. 289   683 1999              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2HDC A    2    98  UNP    Q63245   FOXD3_RAT        2     98             
SEQRES   1 A   97  VAL LYS PRO PRO TYR SER TYR ILE ALA LEU ILE THR MET          
SEQRES   2 A   97  ALA ILE LEU GLN SER PRO GLN LYS LYS LEU THR LEU SER          
SEQRES   3 A   97  GLY ILE CYS GLU PHE ILE SER ASN ARG PHE PRO TYR TYR          
SEQRES   4 A   97  ARG GLU LYS PHE PRO ALA TRP GLN ASN SER ILE ARG HIS          
SEQRES   5 A   97  ASN LEU SER LEU ASN ASP CYS PHE VAL LYS ILE PRO ARG          
SEQRES   6 A   97  GLU PRO GLY ASN PRO GLY LYS GLY ASN TYR TRP THR LEU          
SEQRES   7 A   97  ASP PRO GLN SER GLU ASP MET PHE ASP ASN GLY SER PHE          
SEQRES   8 A   97  LEU ARG ARG ARG LYS ARG                                      
SEQRES   1 B   17   DG  DC  DT  DT  DA  DA  DA  DA  DT  DA  DA  DC  DA          
SEQRES   2 B   17   DA  DT  DA  DC                                              
SEQRES   1 C   17   DG  DT  DA  DT  DT  DG  DT  DT  DA  DT  DT  DT  DT          
SEQRES   2 C   17   DA  DA  DG  DC                                              
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   VAL A   2      10.624  -9.190  -5.697  1.00  0.00           N  
ATOM      2  CA  VAL A   2       9.538  -9.858  -6.392  1.00  0.00           C  
ATOM      3  C   VAL A   2       8.582  -8.808  -6.964  1.00  0.00           C  
ATOM      4  O   VAL A   2       7.432  -8.713  -6.538  1.00  0.00           O  
ATOM      5  CB  VAL A   2       8.845 -10.848  -5.453  1.00  0.00           C  
ATOM      6  CG1 VAL A   2       8.270 -10.133  -4.229  1.00  0.00           C  
ATOM      7  CG2 VAL A   2       7.759 -11.634  -6.189  1.00  0.00           C  
ATOM      8  H   VAL A   2      10.767  -8.235  -5.955  1.00  0.00           H  
ATOM      9  HA  VAL A   2       9.973 -10.422  -7.217  1.00  0.00           H  
ATOM     10  HB  VAL A   2       9.595 -11.559  -5.105  1.00  0.00           H  
ATOM     11 HG11 VAL A   2       8.354  -9.054  -4.365  1.00  0.00           H  
ATOM     12 HG12 VAL A   2       7.222 -10.404  -4.109  1.00  0.00           H  
ATOM     13 HG13 VAL A   2       8.827 -10.431  -3.340  1.00  0.00           H  
ATOM     14 HG21 VAL A   2       7.208 -10.963  -6.849  1.00  0.00           H  
ATOM     15 HG22 VAL A   2       8.219 -12.426  -6.780  1.00  0.00           H  
ATOM     16 HG23 VAL A   2       7.073 -12.073  -5.464  1.00  0.00           H  
ATOM     17  N   LYS A   3       9.093  -8.048  -7.921  1.00  0.00           N  
ATOM     18  CA  LYS A   3       8.299  -7.010  -8.555  1.00  0.00           C  
ATOM     19  C   LYS A   3       8.054  -5.878  -7.555  1.00  0.00           C  
ATOM     20  O   LYS A   3       7.815  -6.130  -6.375  1.00  0.00           O  
ATOM     21  CB  LYS A   3       7.016  -7.599  -9.144  1.00  0.00           C  
ATOM     22  CG  LYS A   3       7.113  -7.715 -10.667  1.00  0.00           C  
ATOM     23  CD  LYS A   3       5.873  -7.125 -11.341  1.00  0.00           C  
ATOM     24  CE  LYS A   3       5.861  -7.443 -12.837  1.00  0.00           C  
ATOM     25  NZ  LYS A   3       5.090  -6.419 -13.578  1.00  0.00           N  
ATOM     26  H   LYS A   3      10.029  -8.133  -8.262  1.00  0.00           H  
ATOM     27  HA  LYS A   3       8.883  -6.615  -9.387  1.00  0.00           H  
ATOM     28  HB2 LYS A   3       6.833  -8.583  -8.712  1.00  0.00           H  
ATOM     29  HB3 LYS A   3       6.167  -6.971  -8.876  1.00  0.00           H  
ATOM     30  HG2 LYS A   3       8.005  -7.196 -11.018  1.00  0.00           H  
ATOM     31  HG3 LYS A   3       7.223  -8.762 -10.949  1.00  0.00           H  
ATOM     32  HD2 LYS A   3       4.974  -7.526 -10.872  1.00  0.00           H  
ATOM     33  HD3 LYS A   3       5.855  -6.045 -11.195  1.00  0.00           H  
ATOM     34  HE2 LYS A   3       6.882  -7.482 -13.216  1.00  0.00           H  
ATOM     35  HE3 LYS A   3       5.421  -8.427 -13.003  1.00  0.00           H  
ATOM     36  HZ1 LYS A   3       5.352  -5.509 -13.258  1.00  0.00           H  
ATOM     37  HZ2 LYS A   3       5.285  -6.497 -14.555  1.00  0.00           H  
ATOM     38  HZ3 LYS A   3       4.111  -6.559 -13.421  1.00  0.00           H  
ATOM     39  N   PRO A   4       8.123  -4.625  -8.076  1.00  0.00           N  
ATOM     40  CA  PRO A   4       7.910  -3.453  -7.242  1.00  0.00           C  
ATOM     41  C   PRO A   4       6.426  -3.274  -6.916  1.00  0.00           C  
ATOM     42  O   PRO A   4       5.573  -3.937  -7.505  1.00  0.00           O  
ATOM     43  CB  PRO A   4       8.489  -2.294  -8.036  1.00  0.00           C  
ATOM     44  CG  PRO A   4       8.581  -2.779  -9.474  1.00  0.00           C  
ATOM     45  CD  PRO A   4       8.403  -4.289  -9.469  1.00  0.00           C  
ATOM     46  HA  PRO A   4       8.371  -3.567  -6.361  1.00  0.00           H  
ATOM     47  HB2 PRO A   4       7.852  -1.413  -7.961  1.00  0.00           H  
ATOM     48  HB3 PRO A   4       9.470  -2.010  -7.655  1.00  0.00           H  
ATOM     49  HG2 PRO A   4       7.814  -2.306 -10.087  1.00  0.00           H  
ATOM     50  HG3 PRO A   4       9.546  -2.510  -9.905  1.00  0.00           H  
ATOM     51  HD2 PRO A   4       7.586  -4.593 -10.122  1.00  0.00           H  
ATOM     52  HD3 PRO A   4       9.300  -4.795  -9.826  1.00  0.00           H  
ATOM     53  N   PRO A   5       6.156  -2.351  -5.955  1.00  0.00           N  
ATOM     54  CA  PRO A   5       4.790  -2.076  -5.543  1.00  0.00           C  
ATOM     55  C   PRO A   5       4.058  -1.243  -6.597  1.00  0.00           C  
ATOM     56  O   PRO A   5       4.683  -0.686  -7.498  1.00  0.00           O  
ATOM     57  CB  PRO A   5       4.917  -1.365  -4.207  1.00  0.00           C  
ATOM     58  CG  PRO A   5       6.347  -0.854  -4.140  1.00  0.00           C  
ATOM     59  CD  PRO A   5       7.141  -1.548  -5.236  1.00  0.00           C  
ATOM     60  HA  PRO A   5       4.274  -2.929  -5.462  1.00  0.00           H  
ATOM     61  HB2 PRO A   5       4.205  -0.541  -4.133  1.00  0.00           H  
ATOM     62  HB3 PRO A   5       4.706  -2.043  -3.381  1.00  0.00           H  
ATOM     63  HG2 PRO A   5       6.374   0.227  -4.276  1.00  0.00           H  
ATOM     64  HG3 PRO A   5       6.782  -1.064  -3.162  1.00  0.00           H  
ATOM     65  HD2 PRO A   5       7.621  -0.825  -5.896  1.00  0.00           H  
ATOM     66  HD3 PRO A   5       7.931  -2.171  -4.818  1.00  0.00           H  
ATOM     67  N   TYR A   6       2.743  -1.184  -6.450  1.00  0.00           N  
ATOM     68  CA  TYR A   6       1.918  -0.429  -7.377  1.00  0.00           C  
ATOM     69  C   TYR A   6       0.776   0.279  -6.645  1.00  0.00           C  
ATOM     70  O   TYR A   6       0.490  -0.030  -5.490  1.00  0.00           O  
ATOM     71  CB  TYR A   6       1.328  -1.453  -8.349  1.00  0.00           C  
ATOM     72  CG  TYR A   6       1.702  -1.211  -9.812  1.00  0.00           C  
ATOM     73  CD1 TYR A   6       2.973  -1.513 -10.258  1.00  0.00           C  
ATOM     74  CD2 TYR A   6       0.770  -0.691 -10.685  1.00  0.00           C  
ATOM     75  CE1 TYR A   6       3.325  -1.284 -11.636  1.00  0.00           C  
ATOM     76  CE2 TYR A   6       1.122  -0.463 -12.063  1.00  0.00           C  
ATOM     77  CZ  TYR A   6       2.382  -0.771 -12.470  1.00  0.00           C  
ATOM     78  OH  TYR A   6       2.715  -0.556 -13.771  1.00  0.00           O  
ATOM     79  H   TYR A   6       2.241  -1.640  -5.714  1.00  0.00           H  
ATOM     80  HA  TYR A   6       2.550   0.319  -7.857  1.00  0.00           H  
ATOM     81  HB2 TYR A   6       1.664  -2.449  -8.058  1.00  0.00           H  
ATOM     82  HB3 TYR A   6       0.242  -1.444  -8.255  1.00  0.00           H  
ATOM     83  HD1 TYR A   6       3.710  -1.924  -9.569  1.00  0.00           H  
ATOM     84  HD2 TYR A   6      -0.234  -0.452 -10.333  1.00  0.00           H  
ATOM     85  HE1 TYR A   6       4.325  -1.519 -12.002  1.00  0.00           H  
ATOM     86  HE2 TYR A   6       0.394  -0.051 -12.764  1.00  0.00           H  
ATOM     87  HH  TYR A   6       3.627  -0.150 -13.829  1.00  0.00           H  
ATOM     88  N   SER A   7       0.155   1.214  -7.349  1.00  0.00           N  
ATOM     89  CA  SER A   7      -0.950   1.968  -6.781  1.00  0.00           C  
ATOM     90  C   SER A   7      -2.164   1.055  -6.589  1.00  0.00           C  
ATOM     91  O   SER A   7      -2.678   0.492  -7.554  1.00  0.00           O  
ATOM     92  CB  SER A   7      -1.318   3.159  -7.666  1.00  0.00           C  
ATOM     93  OG  SER A   7      -1.748   2.750  -8.961  1.00  0.00           O  
ATOM     94  H   SER A   7       0.394   1.458  -8.289  1.00  0.00           H  
ATOM     95  HA  SER A   7      -0.588   2.329  -5.818  1.00  0.00           H  
ATOM     96  HB2 SER A   7      -2.109   3.737  -7.188  1.00  0.00           H  
ATOM     97  HB3 SER A   7      -0.455   3.819  -7.762  1.00  0.00           H  
ATOM     98  HG  SER A   7      -2.160   1.840  -8.913  1.00  0.00           H  
ATOM     99  N   TYR A   8      -2.584   0.937  -5.339  1.00  0.00           N  
ATOM    100  CA  TYR A   8      -3.727   0.102  -5.008  1.00  0.00           C  
ATOM    101  C   TYR A   8      -5.040   0.839  -5.277  1.00  0.00           C  
ATOM    102  O   TYR A   8      -6.042   0.221  -5.631  1.00  0.00           O  
ATOM    103  CB  TYR A   8      -3.616  -0.190  -3.510  1.00  0.00           C  
ATOM    104  CG  TYR A   8      -2.623  -1.301  -3.164  1.00  0.00           C  
ATOM    105  CD1 TYR A   8      -1.548  -1.548  -3.993  1.00  0.00           C  
ATOM    106  CD2 TYR A   8      -2.803  -2.057  -2.024  1.00  0.00           C  
ATOM    107  CE1 TYR A   8      -0.613  -2.593  -3.667  1.00  0.00           C  
ATOM    108  CE2 TYR A   8      -1.869  -3.102  -1.698  1.00  0.00           C  
ATOM    109  CZ  TYR A   8      -0.820  -3.319  -2.536  1.00  0.00           C  
ATOM    110  OH  TYR A   8       0.064  -4.307  -2.228  1.00  0.00           O  
ATOM    111  H   TYR A   8      -2.159   1.398  -4.559  1.00  0.00           H  
ATOM    112  HA  TYR A   8      -3.683  -0.789  -5.634  1.00  0.00           H  
ATOM    113  HB2 TYR A   8      -3.320   0.722  -2.993  1.00  0.00           H  
ATOM    114  HB3 TYR A   8      -4.601  -0.466  -3.132  1.00  0.00           H  
ATOM    115  HD1 TYR A   8      -1.405  -0.951  -4.894  1.00  0.00           H  
ATOM    116  HD2 TYR A   8      -3.653  -1.862  -1.369  1.00  0.00           H  
ATOM    117  HE1 TYR A   8       0.241  -2.799  -4.314  1.00  0.00           H  
ATOM    118  HE2 TYR A   8      -1.998  -3.706  -0.800  1.00  0.00           H  
ATOM    119  HH  TYR A   8      -0.102  -4.635  -1.299  1.00  0.00           H  
ATOM    120  N   ILE A   9      -4.993   2.152  -5.097  1.00  0.00           N  
ATOM    121  CA  ILE A   9      -6.166   2.979  -5.316  1.00  0.00           C  
ATOM    122  C   ILE A   9      -6.693   2.746  -6.734  1.00  0.00           C  
ATOM    123  O   ILE A   9      -7.903   2.722  -6.953  1.00  0.00           O  
ATOM    124  CB  ILE A   9      -5.852   4.446  -5.011  1.00  0.00           C  
ATOM    125  CG1 ILE A   9      -4.560   4.885  -5.704  1.00  0.00           C  
ATOM    126  CG2 ILE A   9      -5.806   4.694  -3.502  1.00  0.00           C  
ATOM    127  CD1 ILE A   9      -3.402   4.957  -4.708  1.00  0.00           C  
ATOM    128  H   ILE A   9      -4.174   2.647  -4.809  1.00  0.00           H  
ATOM    129  HA  ILE A   9      -6.929   2.659  -4.606  1.00  0.00           H  
ATOM    130  HB  ILE A   9      -6.658   5.058  -5.414  1.00  0.00           H  
ATOM    131 HG12 ILE A   9      -4.316   4.184  -6.502  1.00  0.00           H  
ATOM    132 HG13 ILE A   9      -4.706   5.860  -6.169  1.00  0.00           H  
ATOM    133 HG21 ILE A   9      -5.277   3.875  -3.015  1.00  0.00           H  
ATOM    134 HG22 ILE A   9      -5.286   5.631  -3.304  1.00  0.00           H  
ATOM    135 HG23 ILE A   9      -6.822   4.753  -3.113  1.00  0.00           H  
ATOM    136 HD11 ILE A   9      -3.566   4.237  -3.906  1.00  0.00           H  
ATOM    137 HD12 ILE A   9      -2.467   4.723  -5.219  1.00  0.00           H  
ATOM    138 HD13 ILE A   9      -3.344   5.962  -4.289  1.00  0.00           H  
ATOM    139  N   ALA A  10      -5.759   2.579  -7.658  1.00  0.00           N  
ATOM    140  CA  ALA A  10      -6.114   2.347  -9.047  1.00  0.00           C  
ATOM    141  C   ALA A  10      -6.897   1.037  -9.158  1.00  0.00           C  
ATOM    142  O   ALA A  10      -8.003   1.015  -9.698  1.00  0.00           O  
ATOM    143  CB  ALA A  10      -4.847   2.343  -9.905  1.00  0.00           C  
ATOM    144  H   ALA A  10      -4.777   2.599  -7.471  1.00  0.00           H  
ATOM    145  HA  ALA A  10      -6.752   3.170  -9.369  1.00  0.00           H  
ATOM    146  HB1 ALA A  10      -4.286   3.261  -9.728  1.00  0.00           H  
ATOM    147  HB2 ALA A  10      -4.232   1.484  -9.639  1.00  0.00           H  
ATOM    148  HB3 ALA A  10      -5.121   2.282 -10.958  1.00  0.00           H  
ATOM    149  N   LEU A  11      -6.294  -0.021  -8.638  1.00  0.00           N  
ATOM    150  CA  LEU A  11      -6.921  -1.332  -8.672  1.00  0.00           C  
ATOM    151  C   LEU A  11      -8.269  -1.265  -7.953  1.00  0.00           C  
ATOM    152  O   LEU A  11      -9.212  -1.963  -8.327  1.00  0.00           O  
ATOM    153  CB  LEU A  11      -5.975  -2.393  -8.107  1.00  0.00           C  
ATOM    154  CG  LEU A  11      -4.908  -2.921  -9.069  1.00  0.00           C  
ATOM    155  CD1 LEU A  11      -5.548  -3.520 -10.323  1.00  0.00           C  
ATOM    156  CD2 LEU A  11      -3.890  -1.830  -9.411  1.00  0.00           C  
ATOM    157  H   LEU A  11      -5.395   0.006  -8.202  1.00  0.00           H  
ATOM    158  HA  LEU A  11      -7.099  -1.582  -9.718  1.00  0.00           H  
ATOM    159  HB2 LEU A  11      -5.473  -1.977  -7.234  1.00  0.00           H  
ATOM    160  HB3 LEU A  11      -6.572  -3.237  -7.761  1.00  0.00           H  
ATOM    161  HG  LEU A  11      -4.365  -3.723  -8.570  1.00  0.00           H  
ATOM    162 HD11 LEU A  11      -6.387  -4.153 -10.035  1.00  0.00           H  
ATOM    163 HD12 LEU A  11      -5.904  -2.717 -10.969  1.00  0.00           H  
ATOM    164 HD13 LEU A  11      -4.809  -4.117 -10.859  1.00  0.00           H  
ATOM    165 HD21 LEU A  11      -4.416  -0.908  -9.660  1.00  0.00           H  
ATOM    166 HD22 LEU A  11      -3.241  -1.657  -8.553  1.00  0.00           H  
ATOM    167 HD23 LEU A  11      -3.289  -2.148 -10.264  1.00  0.00           H  
ATOM    168  N   ILE A  12      -8.320  -0.421  -6.933  1.00  0.00           N  
ATOM    169  CA  ILE A  12      -9.538  -0.254  -6.158  1.00  0.00           C  
ATOM    170  C   ILE A  12     -10.608   0.401  -7.034  1.00  0.00           C  
ATOM    171  O   ILE A  12     -11.676  -0.171  -7.246  1.00  0.00           O  
ATOM    172  CB  ILE A  12      -9.250   0.510  -4.866  1.00  0.00           C  
ATOM    173  CG1 ILE A  12      -9.009  -0.454  -3.701  1.00  0.00           C  
ATOM    174  CG2 ILE A  12     -10.366   1.511  -4.559  1.00  0.00           C  
ATOM    175  CD1 ILE A  12      -7.721  -1.253  -3.909  1.00  0.00           C  
ATOM    176  H   ILE A  12      -7.549   0.143  -6.635  1.00  0.00           H  
ATOM    177  HA  ILE A  12      -9.884  -1.248  -5.876  1.00  0.00           H  
ATOM    178  HB  ILE A  12      -8.332   1.083  -5.004  1.00  0.00           H  
ATOM    179 HG12 ILE A  12      -8.947   0.107  -2.768  1.00  0.00           H  
ATOM    180 HG13 ILE A  12      -9.854  -1.136  -3.608  1.00  0.00           H  
ATOM    181 HG21 ILE A  12     -11.316   0.983  -4.485  1.00  0.00           H  
ATOM    182 HG22 ILE A  12     -10.154   2.014  -3.616  1.00  0.00           H  
ATOM    183 HG23 ILE A  12     -10.421   2.249  -5.360  1.00  0.00           H  
ATOM    184 HD11 ILE A  12      -7.482  -1.287  -4.972  1.00  0.00           H  
ATOM    185 HD12 ILE A  12      -6.905  -0.776  -3.367  1.00  0.00           H  
ATOM    186 HD13 ILE A  12      -7.860  -2.268  -3.535  1.00  0.00           H  
ATOM    187  N   THR A  13     -10.285   1.590  -7.519  1.00  0.00           N  
ATOM    188  CA  THR A  13     -11.205   2.329  -8.366  1.00  0.00           C  
ATOM    189  C   THR A  13     -11.806   1.408  -9.430  1.00  0.00           C  
ATOM    190  O   THR A  13     -12.989   1.514  -9.753  1.00  0.00           O  
ATOM    191  CB  THR A  13     -10.453   3.525  -8.953  1.00  0.00           C  
ATOM    192  OG1 THR A  13      -9.396   2.935  -9.705  1.00  0.00           O  
ATOM    193  CG2 THR A  13      -9.735   4.348  -7.881  1.00  0.00           C  
ATOM    194  H   THR A  13      -9.414   2.049  -7.342  1.00  0.00           H  
ATOM    195  HA  THR A  13     -12.030   2.684  -7.750  1.00  0.00           H  
ATOM    196  HB  THR A  13     -11.120   4.152  -9.543  1.00  0.00           H  
ATOM    197  HG1 THR A  13      -9.047   2.128  -9.229  1.00  0.00           H  
ATOM    198 HG21 THR A  13      -9.867   3.871  -6.909  1.00  0.00           H  
ATOM    199 HG22 THR A  13      -8.673   4.404  -8.118  1.00  0.00           H  
ATOM    200 HG23 THR A  13     -10.155   5.352  -7.852  1.00  0.00           H  
ATOM    201  N   MET A  14     -10.964   0.525  -9.947  1.00  0.00           N  
ATOM    202  CA  MET A  14     -11.397  -0.415 -10.967  1.00  0.00           C  
ATOM    203  C   MET A  14     -12.235  -1.539 -10.358  1.00  0.00           C  
ATOM    204  O   MET A  14     -13.152  -2.052 -10.998  1.00  0.00           O  
ATOM    205  CB  MET A  14     -10.172  -1.010 -11.666  1.00  0.00           C  
ATOM    206  CG  MET A  14     -10.570  -1.712 -12.966  1.00  0.00           C  
ATOM    207  SD  MET A  14      -9.225  -2.732 -13.545  1.00  0.00           S  
ATOM    208  CE  MET A  14      -9.557  -4.229 -12.632  1.00  0.00           C  
ATOM    209  H   MET A  14     -10.004   0.445  -9.679  1.00  0.00           H  
ATOM    210  HA  MET A  14     -12.005   0.167 -11.661  1.00  0.00           H  
ATOM    211  HB2 MET A  14      -9.452  -0.221 -11.880  1.00  0.00           H  
ATOM    212  HB3 MET A  14      -9.680  -1.720 -11.000  1.00  0.00           H  
ATOM    213  HG2 MET A  14     -11.457  -2.323 -12.802  1.00  0.00           H  
ATOM    214  HG3 MET A  14     -10.828  -0.973 -13.724  1.00  0.00           H  
ATOM    215  HE1 MET A  14     -10.147  -3.993 -11.746  1.00  0.00           H  
ATOM    216  HE2 MET A  14     -10.111  -4.924 -13.262  1.00  0.00           H  
ATOM    217  HE3 MET A  14      -8.615  -4.687 -12.328  1.00  0.00           H  
ATOM    218  N   ALA A  15     -11.891  -1.890  -9.128  1.00  0.00           N  
ATOM    219  CA  ALA A  15     -12.601  -2.945  -8.425  1.00  0.00           C  
ATOM    220  C   ALA A  15     -14.031  -2.485  -8.131  1.00  0.00           C  
ATOM    221  O   ALA A  15     -14.956  -3.295  -8.112  1.00  0.00           O  
ATOM    222  CB  ALA A  15     -11.836  -3.316  -7.152  1.00  0.00           C  
ATOM    223  H   ALA A  15     -11.145  -1.469  -8.614  1.00  0.00           H  
ATOM    224  HA  ALA A  15     -12.636  -3.816  -9.079  1.00  0.00           H  
ATOM    225  HB1 ALA A  15     -10.818  -2.930  -7.215  1.00  0.00           H  
ATOM    226  HB2 ALA A  15     -12.336  -2.882  -6.287  1.00  0.00           H  
ATOM    227  HB3 ALA A  15     -11.807  -4.401  -7.049  1.00  0.00           H  
ATOM    228  N   ILE A  16     -14.166  -1.185  -7.910  1.00  0.00           N  
ATOM    229  CA  ILE A  16     -15.467  -0.609  -7.619  1.00  0.00           C  
ATOM    230  C   ILE A  16     -16.198  -0.320  -8.933  1.00  0.00           C  
ATOM    231  O   ILE A  16     -17.390  -0.594  -9.056  1.00  0.00           O  
ATOM    232  CB  ILE A  16     -15.319   0.618  -6.716  1.00  0.00           C  
ATOM    233  CG1 ILE A  16     -16.653   0.980  -6.060  1.00  0.00           C  
ATOM    234  CG2 ILE A  16     -14.720   1.798  -7.485  1.00  0.00           C  
ATOM    235  CD1 ILE A  16     -16.965   0.038  -4.895  1.00  0.00           C  
ATOM    236  H   ILE A  16     -13.408  -0.534  -7.928  1.00  0.00           H  
ATOM    237  HA  ILE A  16     -16.038  -1.351  -7.063  1.00  0.00           H  
ATOM    238  HB  ILE A  16     -14.622   0.370  -5.915  1.00  0.00           H  
ATOM    239 HG12 ILE A  16     -16.618   2.009  -5.701  1.00  0.00           H  
ATOM    240 HG13 ILE A  16     -17.452   0.928  -6.799  1.00  0.00           H  
ATOM    241 HG21 ILE A  16     -15.285   1.956  -8.404  1.00  0.00           H  
ATOM    242 HG22 ILE A  16     -14.769   2.695  -6.870  1.00  0.00           H  
ATOM    243 HG23 ILE A  16     -13.680   1.579  -7.731  1.00  0.00           H  
ATOM    244 HD11 ILE A  16     -16.887  -0.995  -5.233  1.00  0.00           H  
ATOM    245 HD12 ILE A  16     -16.253   0.211  -4.087  1.00  0.00           H  
ATOM    246 HD13 ILE A  16     -17.975   0.228  -4.535  1.00  0.00           H  
ATOM    247  N   LEU A  17     -15.452   0.230  -9.879  1.00  0.00           N  
ATOM    248  CA  LEU A  17     -16.013   0.559 -11.178  1.00  0.00           C  
ATOM    249  C   LEU A  17     -16.463  -0.727 -11.875  1.00  0.00           C  
ATOM    250  O   LEU A  17     -17.557  -0.784 -12.435  1.00  0.00           O  
ATOM    251  CB  LEU A  17     -15.021   1.387 -11.997  1.00  0.00           C  
ATOM    252  CG  LEU A  17     -14.781   2.818 -11.513  1.00  0.00           C  
ATOM    253  CD1 LEU A  17     -13.537   3.418 -12.171  1.00  0.00           C  
ATOM    254  CD2 LEU A  17     -16.021   3.686 -11.733  1.00  0.00           C  
ATOM    255  H   LEU A  17     -14.482   0.450  -9.770  1.00  0.00           H  
ATOM    256  HA  LEU A  17     -16.890   1.184 -11.007  1.00  0.00           H  
ATOM    257  HB2 LEU A  17     -14.065   0.863 -12.010  1.00  0.00           H  
ATOM    258  HB3 LEU A  17     -15.375   1.427 -13.028  1.00  0.00           H  
ATOM    259  HG  LEU A  17     -14.595   2.788 -10.439  1.00  0.00           H  
ATOM    260 HD11 LEU A  17     -12.762   2.656 -12.246  1.00  0.00           H  
ATOM    261 HD12 LEU A  17     -13.791   3.777 -13.168  1.00  0.00           H  
ATOM    262 HD13 LEU A  17     -13.172   4.248 -11.568  1.00  0.00           H  
ATOM    263 HD21 LEU A  17     -16.407   3.522 -12.739  1.00  0.00           H  
ATOM    264 HD22 LEU A  17     -16.786   3.419 -11.003  1.00  0.00           H  
ATOM    265 HD23 LEU A  17     -15.755   4.737 -11.613  1.00  0.00           H  
ATOM    266  N   GLN A  18     -15.598  -1.728 -11.817  1.00  0.00           N  
ATOM    267  CA  GLN A  18     -15.892  -3.010 -12.434  1.00  0.00           C  
ATOM    268  C   GLN A  18     -17.245  -3.534 -11.950  1.00  0.00           C  
ATOM    269  O   GLN A  18     -17.834  -4.415 -12.575  1.00  0.00           O  
ATOM    270  CB  GLN A  18     -14.780  -4.021 -12.155  1.00  0.00           C  
ATOM    271  CG  GLN A  18     -14.850  -4.530 -10.712  1.00  0.00           C  
ATOM    272  CD  GLN A  18     -15.607  -5.857 -10.636  1.00  0.00           C  
ATOM    273  OE1 GLN A  18     -16.732  -5.933 -10.169  1.00  0.00           O  
ATOM    274  NE2 GLN A  18     -14.930  -6.895 -11.117  1.00  0.00           N  
ATOM    275  H   GLN A  18     -14.710  -1.673 -11.359  1.00  0.00           H  
ATOM    276  HA  GLN A  18     -15.934  -2.812 -13.505  1.00  0.00           H  
ATOM    277  HB2 GLN A  18     -14.865  -4.861 -12.844  1.00  0.00           H  
ATOM    278  HB3 GLN A  18     -13.808  -3.560 -12.334  1.00  0.00           H  
ATOM    279  HG2 GLN A  18     -13.841  -4.659 -10.319  1.00  0.00           H  
ATOM    280  HG3 GLN A  18     -15.344  -3.788 -10.086  1.00  0.00           H  
ATOM    281 HE21 GLN A  18     -14.010  -6.765 -11.486  1.00  0.00           H  
ATOM    282 HE22 GLN A  18     -15.341  -7.807 -11.111  1.00  0.00           H  
ATOM    283  N   SER A  19     -17.699  -2.971 -10.839  1.00  0.00           N  
ATOM    284  CA  SER A  19     -18.972  -3.370 -10.263  1.00  0.00           C  
ATOM    285  C   SER A  19     -19.953  -2.198 -10.297  1.00  0.00           C  
ATOM    286  O   SER A  19     -20.170  -1.536  -9.283  1.00  0.00           O  
ATOM    287  CB  SER A  19     -18.793  -3.872  -8.829  1.00  0.00           C  
ATOM    288  OG  SER A  19     -17.649  -3.302  -8.201  1.00  0.00           O  
ATOM    289  H   SER A  19     -17.213  -2.255 -10.336  1.00  0.00           H  
ATOM    290  HA  SER A  19     -19.328  -4.187 -10.891  1.00  0.00           H  
ATOM    291  HB2 SER A  19     -19.683  -3.632  -8.247  1.00  0.00           H  
ATOM    292  HB3 SER A  19     -18.700  -4.958  -8.834  1.00  0.00           H  
ATOM    293  HG  SER A  19     -17.586  -2.329  -8.425  1.00  0.00           H  
ATOM    294  N   PRO A  20     -20.535  -1.970 -11.505  1.00  0.00           N  
ATOM    295  CA  PRO A  20     -21.488  -0.888 -11.685  1.00  0.00           C  
ATOM    296  C   PRO A  20     -22.840  -1.239 -11.060  1.00  0.00           C  
ATOM    297  O   PRO A  20     -23.778  -0.446 -11.117  1.00  0.00           O  
ATOM    298  CB  PRO A  20     -21.565  -0.677 -13.187  1.00  0.00           C  
ATOM    299  CG  PRO A  20     -21.012  -1.945 -13.816  1.00  0.00           C  
ATOM    300  CD  PRO A  20     -20.301  -2.733 -12.728  1.00  0.00           C  
ATOM    301  HA  PRO A  20     -21.173  -0.066 -11.210  1.00  0.00           H  
ATOM    302  HB2 PRO A  20     -22.592  -0.498 -13.505  1.00  0.00           H  
ATOM    303  HB3 PRO A  20     -20.983   0.194 -13.490  1.00  0.00           H  
ATOM    304  HG2 PRO A  20     -21.817  -2.537 -14.252  1.00  0.00           H  
ATOM    305  HG3 PRO A  20     -20.322  -1.702 -14.623  1.00  0.00           H  
ATOM    306  HD2 PRO A  20     -20.701  -3.745 -12.645  1.00  0.00           H  
ATOM    307  HD3 PRO A  20     -19.237  -2.828 -12.938  1.00  0.00           H  
ATOM    308  N   GLN A  21     -22.897  -2.429 -10.480  1.00  0.00           N  
ATOM    309  CA  GLN A  21     -24.118  -2.895  -9.845  1.00  0.00           C  
ATOM    310  C   GLN A  21     -24.380  -2.112  -8.558  1.00  0.00           C  
ATOM    311  O   GLN A  21     -25.401  -2.312  -7.903  1.00  0.00           O  
ATOM    312  CB  GLN A  21     -24.053  -4.399  -9.569  1.00  0.00           C  
ATOM    313  CG  GLN A  21     -25.363  -5.085  -9.959  1.00  0.00           C  
ATOM    314  CD  GLN A  21     -25.272  -5.680 -11.366  1.00  0.00           C  
ATOM    315  OE1 GLN A  21     -25.052  -6.866 -11.552  1.00  0.00           O  
ATOM    316  NE2 GLN A  21     -25.453  -4.795 -12.341  1.00  0.00           N  
ATOM    317  H   GLN A  21     -22.129  -3.068 -10.438  1.00  0.00           H  
ATOM    318  HA  GLN A  21     -24.912  -2.699 -10.567  1.00  0.00           H  
ATOM    319  HB2 GLN A  21     -23.227  -4.840 -10.127  1.00  0.00           H  
ATOM    320  HB3 GLN A  21     -23.850  -4.568  -8.512  1.00  0.00           H  
ATOM    321  HG2 GLN A  21     -25.593  -5.872  -9.241  1.00  0.00           H  
ATOM    322  HG3 GLN A  21     -26.181  -4.367  -9.917  1.00  0.00           H  
ATOM    323 HE21 GLN A  21     -25.629  -3.836 -12.119  1.00  0.00           H  
ATOM    324 HE22 GLN A  21     -25.412  -5.087 -13.296  1.00  0.00           H  
ATOM    325  N   LYS A  22     -23.439  -1.236  -8.234  1.00  0.00           N  
ATOM    326  CA  LYS A  22     -23.557  -0.421  -7.037  1.00  0.00           C  
ATOM    327  C   LYS A  22     -23.451  -1.319  -5.803  1.00  0.00           C  
ATOM    328  O   LYS A  22     -24.409  -1.450  -5.042  1.00  0.00           O  
ATOM    329  CB  LYS A  22     -24.837   0.417  -7.081  1.00  0.00           C  
ATOM    330  CG  LYS A  22     -24.736   1.515  -8.140  1.00  0.00           C  
ATOM    331  CD  LYS A  22     -24.457   2.874  -7.496  1.00  0.00           C  
ATOM    332  CE  LYS A  22     -23.643   3.769  -8.434  1.00  0.00           C  
ATOM    333  NZ  LYS A  22     -22.936   4.818  -7.665  1.00  0.00           N  
ATOM    334  H   LYS A  22     -22.613  -1.079  -8.773  1.00  0.00           H  
ATOM    335  HA  LYS A  22     -22.717   0.274  -7.031  1.00  0.00           H  
ATOM    336  HB2 LYS A  22     -25.689  -0.227  -7.298  1.00  0.00           H  
ATOM    337  HB3 LYS A  22     -25.016   0.864  -6.104  1.00  0.00           H  
ATOM    338  HG2 LYS A  22     -23.942   1.273  -8.846  1.00  0.00           H  
ATOM    339  HG3 LYS A  22     -25.665   1.563  -8.709  1.00  0.00           H  
ATOM    340  HD2 LYS A  22     -25.399   3.363  -7.247  1.00  0.00           H  
ATOM    341  HD3 LYS A  22     -23.915   2.733  -6.561  1.00  0.00           H  
ATOM    342  HE2 LYS A  22     -22.923   3.166  -8.986  1.00  0.00           H  
ATOM    343  HE3 LYS A  22     -24.303   4.230  -9.168  1.00  0.00           H  
ATOM    344  HZ1 LYS A  22     -23.270   4.823  -6.722  1.00  0.00           H  
ATOM    345  HZ2 LYS A  22     -21.954   4.631  -7.671  1.00  0.00           H  
ATOM    346  HZ3 LYS A  22     -23.109   5.710  -8.083  1.00  0.00           H  
ATOM    347  N   LYS A  23     -22.279  -1.913  -5.641  1.00  0.00           N  
ATOM    348  CA  LYS A  23     -22.035  -2.795  -4.511  1.00  0.00           C  
ATOM    349  C   LYS A  23     -20.612  -3.348  -4.600  1.00  0.00           C  
ATOM    350  O   LYS A  23     -20.057  -3.476  -5.690  1.00  0.00           O  
ATOM    351  CB  LYS A  23     -23.112  -3.878  -4.436  1.00  0.00           C  
ATOM    352  CG  LYS A  23     -23.996  -3.687  -3.201  1.00  0.00           C  
ATOM    353  CD  LYS A  23     -25.110  -4.736  -3.157  1.00  0.00           C  
ATOM    354  CE  LYS A  23     -26.283  -4.252  -2.302  1.00  0.00           C  
ATOM    355  NZ  LYS A  23     -27.555  -4.376  -3.050  1.00  0.00           N  
ATOM    356  H   LYS A  23     -21.504  -1.801  -6.264  1.00  0.00           H  
ATOM    357  HA  LYS A  23     -22.117  -2.195  -3.606  1.00  0.00           H  
ATOM    358  HB2 LYS A  23     -23.727  -3.849  -5.335  1.00  0.00           H  
ATOM    359  HB3 LYS A  23     -22.643  -4.861  -4.404  1.00  0.00           H  
ATOM    360  HG2 LYS A  23     -23.387  -3.761  -2.299  1.00  0.00           H  
ATOM    361  HG3 LYS A  23     -24.431  -2.689  -3.210  1.00  0.00           H  
ATOM    362  HD2 LYS A  23     -25.455  -4.947  -4.169  1.00  0.00           H  
ATOM    363  HD3 LYS A  23     -24.721  -5.669  -2.752  1.00  0.00           H  
ATOM    364  HE2 LYS A  23     -26.336  -4.836  -1.384  1.00  0.00           H  
ATOM    365  HE3 LYS A  23     -26.125  -3.213  -2.012  1.00  0.00           H  
ATOM    366  HZ1 LYS A  23     -27.420  -4.066  -3.991  1.00  0.00           H  
ATOM    367  HZ2 LYS A  23     -27.848  -5.332  -3.052  1.00  0.00           H  
ATOM    368  HZ3 LYS A  23     -28.255  -3.813  -2.611  1.00  0.00           H  
ATOM    369  N   LEU A  24     -20.060  -3.663  -3.437  1.00  0.00           N  
ATOM    370  CA  LEU A  24     -18.712  -4.200  -3.369  1.00  0.00           C  
ATOM    371  C   LEU A  24     -18.482  -4.816  -1.986  1.00  0.00           C  
ATOM    372  O   LEU A  24     -19.193  -4.498  -1.035  1.00  0.00           O  
ATOM    373  CB  LEU A  24     -17.688  -3.125  -3.740  1.00  0.00           C  
ATOM    374  CG  LEU A  24     -16.341  -3.634  -4.258  1.00  0.00           C  
ATOM    375  CD1 LEU A  24     -16.497  -4.311  -5.622  1.00  0.00           C  
ATOM    376  CD2 LEU A  24     -15.307  -2.507  -4.293  1.00  0.00           C  
ATOM    377  H   LEU A  24     -20.518  -3.556  -2.554  1.00  0.00           H  
ATOM    378  HA  LEU A  24     -18.637  -4.990  -4.116  1.00  0.00           H  
ATOM    379  HB2 LEU A  24     -18.128  -2.481  -4.501  1.00  0.00           H  
ATOM    380  HB3 LEU A  24     -17.507  -2.505  -2.863  1.00  0.00           H  
ATOM    381  HG  LEU A  24     -15.971  -4.389  -3.565  1.00  0.00           H  
ATOM    382 HD11 LEU A  24     -17.416  -3.964  -6.096  1.00  0.00           H  
ATOM    383 HD12 LEU A  24     -15.645  -4.059  -6.252  1.00  0.00           H  
ATOM    384 HD13 LEU A  24     -16.543  -5.392  -5.487  1.00  0.00           H  
ATOM    385 HD21 LEU A  24     -15.677  -1.655  -3.724  1.00  0.00           H  
ATOM    386 HD22 LEU A  24     -14.372  -2.857  -3.855  1.00  0.00           H  
ATOM    387 HD23 LEU A  24     -15.132  -2.205  -5.326  1.00  0.00           H  
ATOM    388  N   THR A  25     -17.486  -5.687  -1.921  1.00  0.00           N  
ATOM    389  CA  THR A  25     -17.154  -6.351  -0.672  1.00  0.00           C  
ATOM    390  C   THR A  25     -15.638  -6.366  -0.462  1.00  0.00           C  
ATOM    391  O   THR A  25     -14.894  -6.835  -1.323  1.00  0.00           O  
ATOM    392  CB  THR A  25     -17.778  -7.747  -0.698  1.00  0.00           C  
ATOM    393  OG1 THR A  25     -17.233  -8.349  -1.869  1.00  0.00           O  
ATOM    394  CG2 THR A  25     -19.284  -7.711  -0.963  1.00  0.00           C  
ATOM    395  H   THR A  25     -16.912  -5.941  -2.700  1.00  0.00           H  
ATOM    396  HA  THR A  25     -17.583  -5.776   0.148  1.00  0.00           H  
ATOM    397  HB  THR A  25     -17.557  -8.290   0.222  1.00  0.00           H  
ATOM    398  HG1 THR A  25     -16.467  -7.804  -2.209  1.00  0.00           H  
ATOM    399 HG21 THR A  25     -19.500  -6.970  -1.734  1.00  0.00           H  
ATOM    400 HG22 THR A  25     -19.617  -8.693  -1.301  1.00  0.00           H  
ATOM    401 HG23 THR A  25     -19.808  -7.445  -0.046  1.00  0.00           H  
ATOM    402  N   LEU A  26     -15.226  -5.848   0.685  1.00  0.00           N  
ATOM    403  CA  LEU A  26     -13.813  -5.796   1.018  1.00  0.00           C  
ATOM    404  C   LEU A  26     -13.176  -7.158   0.733  1.00  0.00           C  
ATOM    405  O   LEU A  26     -12.139  -7.237   0.076  1.00  0.00           O  
ATOM    406  CB  LEU A  26     -13.619  -5.316   2.458  1.00  0.00           C  
ATOM    407  CG  LEU A  26     -12.993  -6.325   3.423  1.00  0.00           C  
ATOM    408  CD1 LEU A  26     -11.476  -6.391   3.239  1.00  0.00           C  
ATOM    409  CD2 LEU A  26     -13.381  -6.013   4.869  1.00  0.00           C  
ATOM    410  H   LEU A  26     -15.838  -5.470   1.379  1.00  0.00           H  
ATOM    411  HA  LEU A  26     -13.351  -5.056   0.366  1.00  0.00           H  
ATOM    412  HB2 LEU A  26     -12.994  -4.423   2.441  1.00  0.00           H  
ATOM    413  HB3 LEU A  26     -14.590  -5.017   2.854  1.00  0.00           H  
ATOM    414  HG  LEU A  26     -13.390  -7.313   3.189  1.00  0.00           H  
ATOM    415 HD11 LEU A  26     -11.064  -5.382   3.243  1.00  0.00           H  
ATOM    416 HD12 LEU A  26     -11.036  -6.967   4.053  1.00  0.00           H  
ATOM    417 HD13 LEU A  26     -11.247  -6.873   2.288  1.00  0.00           H  
ATOM    418 HD21 LEU A  26     -14.192  -5.283   4.879  1.00  0.00           H  
ATOM    419 HD22 LEU A  26     -13.710  -6.927   5.363  1.00  0.00           H  
ATOM    420 HD23 LEU A  26     -12.519  -5.604   5.397  1.00  0.00           H  
ATOM    421  N   SER A  27     -13.824  -8.196   1.242  1.00  0.00           N  
ATOM    422  CA  SER A  27     -13.333  -9.550   1.051  1.00  0.00           C  
ATOM    423  C   SER A  27     -13.324  -9.898  -0.439  1.00  0.00           C  
ATOM    424  O   SER A  27     -12.338 -10.428  -0.951  1.00  0.00           O  
ATOM    425  CB  SER A  27     -14.183 -10.559   1.826  1.00  0.00           C  
ATOM    426  OG  SER A  27     -14.101 -10.356   3.234  1.00  0.00           O  
ATOM    427  H   SER A  27     -14.665  -8.123   1.776  1.00  0.00           H  
ATOM    428  HA  SER A  27     -12.319  -9.549   1.450  1.00  0.00           H  
ATOM    429  HB2 SER A  27     -15.223 -10.477   1.508  1.00  0.00           H  
ATOM    430  HB3 SER A  27     -13.856 -11.571   1.586  1.00  0.00           H  
ATOM    431  HG  SER A  27     -13.816  -9.418   3.428  1.00  0.00           H  
ATOM    432  N   GLY A  28     -14.433  -9.587  -1.093  1.00  0.00           N  
ATOM    433  CA  GLY A  28     -14.565  -9.859  -2.514  1.00  0.00           C  
ATOM    434  C   GLY A  28     -13.425  -9.214  -3.305  1.00  0.00           C  
ATOM    435  O   GLY A  28     -12.908  -9.807  -4.251  1.00  0.00           O  
ATOM    436  H   GLY A  28     -15.230  -9.156  -0.670  1.00  0.00           H  
ATOM    437  HA2 GLY A  28     -14.566 -10.937  -2.683  1.00  0.00           H  
ATOM    438  HA3 GLY A  28     -15.521  -9.480  -2.874  1.00  0.00           H  
ATOM    439  N   ILE A  29     -13.066  -8.008  -2.888  1.00  0.00           N  
ATOM    440  CA  ILE A  29     -11.998  -7.277  -3.546  1.00  0.00           C  
ATOM    441  C   ILE A  29     -10.672  -8.004  -3.315  1.00  0.00           C  
ATOM    442  O   ILE A  29      -9.887  -8.180  -4.246  1.00  0.00           O  
ATOM    443  CB  ILE A  29     -11.986  -5.817  -3.087  1.00  0.00           C  
ATOM    444  CG1 ILE A  29     -12.203  -4.869  -4.268  1.00  0.00           C  
ATOM    445  CG2 ILE A  29     -10.704  -5.493  -2.320  1.00  0.00           C  
ATOM    446  CD1 ILE A  29     -13.453  -5.258  -5.061  1.00  0.00           C  
ATOM    447  H   ILE A  29     -13.493  -7.534  -2.119  1.00  0.00           H  
ATOM    448  HA  ILE A  29     -12.211  -7.277  -4.615  1.00  0.00           H  
ATOM    449  HB  ILE A  29     -12.819  -5.669  -2.398  1.00  0.00           H  
ATOM    450 HG12 ILE A  29     -12.303  -3.846  -3.905  1.00  0.00           H  
ATOM    451 HG13 ILE A  29     -11.331  -4.892  -4.922  1.00  0.00           H  
ATOM    452 HG21 ILE A  29     -10.610  -6.165  -1.467  1.00  0.00           H  
ATOM    453 HG22 ILE A  29      -9.844  -5.621  -2.979  1.00  0.00           H  
ATOM    454 HG23 ILE A  29     -10.740  -4.462  -1.968  1.00  0.00           H  
ATOM    455 HD11 ILE A  29     -13.881  -6.168  -4.641  1.00  0.00           H  
ATOM    456 HD12 ILE A  29     -14.184  -4.453  -5.005  1.00  0.00           H  
ATOM    457 HD13 ILE A  29     -13.182  -5.431  -6.104  1.00  0.00           H  
ATOM    458  N   CYS A  30     -10.462  -8.405  -2.071  1.00  0.00           N  
ATOM    459  CA  CYS A  30      -9.244  -9.109  -1.707  1.00  0.00           C  
ATOM    460  C   CYS A  30      -9.108 -10.334  -2.614  1.00  0.00           C  
ATOM    461  O   CYS A  30      -7.997 -10.725  -2.971  1.00  0.00           O  
ATOM    462  CB  CYS A  30      -9.234  -9.494  -0.225  1.00  0.00           C  
ATOM    463  SG  CYS A  30      -7.761 -10.514   0.146  1.00  0.00           S  
ATOM    464  H   CYS A  30     -11.105  -8.258  -1.320  1.00  0.00           H  
ATOM    465  HA  CYS A  30      -8.421  -8.414  -1.868  1.00  0.00           H  
ATOM    466  HB2 CYS A  30      -9.228  -8.594   0.391  1.00  0.00           H  
ATOM    467  HB3 CYS A  30     -10.141 -10.044   0.023  1.00  0.00           H  
ATOM    468  HG  CYS A  30      -8.015 -10.656   1.444  1.00  0.00           H  
ATOM    469  N   GLU A  31     -10.251 -10.904  -2.961  1.00  0.00           N  
ATOM    470  CA  GLU A  31     -10.273 -12.076  -3.820  1.00  0.00           C  
ATOM    471  C   GLU A  31     -10.062 -11.668  -5.280  1.00  0.00           C  
ATOM    472  O   GLU A  31      -9.314 -12.319  -6.008  1.00  0.00           O  
ATOM    473  CB  GLU A  31     -11.580 -12.855  -3.653  1.00  0.00           C  
ATOM    474  CG  GLU A  31     -11.582 -14.116  -4.519  1.00  0.00           C  
ATOM    475  CD  GLU A  31     -12.507 -15.183  -3.932  1.00  0.00           C  
ATOM    476  OE1 GLU A  31     -12.546 -15.278  -2.686  1.00  0.00           O  
ATOM    477  OE2 GLU A  31     -13.154 -15.881  -4.742  1.00  0.00           O  
ATOM    478  H   GLU A  31     -11.150 -10.579  -2.666  1.00  0.00           H  
ATOM    479  HA  GLU A  31      -9.442 -12.696  -3.485  1.00  0.00           H  
ATOM    480  HB2 GLU A  31     -11.711 -13.128  -2.606  1.00  0.00           H  
ATOM    481  HB3 GLU A  31     -12.423 -12.221  -3.925  1.00  0.00           H  
ATOM    482  HG2 GLU A  31     -11.903 -13.866  -5.530  1.00  0.00           H  
ATOM    483  HG3 GLU A  31     -10.568 -14.510  -4.596  1.00  0.00           H  
ATOM    484  N   PHE A  32     -10.734 -10.593  -5.664  1.00  0.00           N  
ATOM    485  CA  PHE A  32     -10.628 -10.091  -7.023  1.00  0.00           C  
ATOM    486  C   PHE A  32      -9.192  -9.671  -7.343  1.00  0.00           C  
ATOM    487  O   PHE A  32      -8.766  -9.731  -8.495  1.00  0.00           O  
ATOM    488  CB  PHE A  32     -11.539  -8.866  -7.119  1.00  0.00           C  
ATOM    489  CG  PHE A  32     -10.959  -7.723  -7.956  1.00  0.00           C  
ATOM    490  CD1 PHE A  32     -10.792  -7.880  -9.296  1.00  0.00           C  
ATOM    491  CD2 PHE A  32     -10.613  -6.551  -7.360  1.00  0.00           C  
ATOM    492  CE1 PHE A  32     -10.255  -6.820 -10.074  1.00  0.00           C  
ATOM    493  CE2 PHE A  32     -10.075  -5.491  -8.138  1.00  0.00           C  
ATOM    494  CZ  PHE A  32      -9.907  -5.649  -9.477  1.00  0.00           C  
ATOM    495  H   PHE A  32     -11.340 -10.070  -5.065  1.00  0.00           H  
ATOM    496  HA  PHE A  32     -10.925 -10.900  -7.691  1.00  0.00           H  
ATOM    497  HB2 PHE A  32     -12.495  -9.168  -7.547  1.00  0.00           H  
ATOM    498  HB3 PHE A  32     -11.743  -8.497  -6.113  1.00  0.00           H  
ATOM    499  HD1 PHE A  32     -11.070  -8.820  -9.775  1.00  0.00           H  
ATOM    500  HD2 PHE A  32     -10.746  -6.426  -6.286  1.00  0.00           H  
ATOM    501  HE1 PHE A  32     -10.120  -6.946 -11.148  1.00  0.00           H  
ATOM    502  HE2 PHE A  32      -9.796  -4.552  -7.659  1.00  0.00           H  
ATOM    503  HZ  PHE A  32      -9.494  -4.835 -10.075  1.00  0.00           H  
ATOM    504  N   ILE A  33      -8.486  -9.253  -6.302  1.00  0.00           N  
ATOM    505  CA  ILE A  33      -7.107  -8.823  -6.458  1.00  0.00           C  
ATOM    506  C   ILE A  33      -6.195 -10.051  -6.491  1.00  0.00           C  
ATOM    507  O   ILE A  33      -5.437 -10.241  -7.441  1.00  0.00           O  
ATOM    508  CB  ILE A  33      -6.736  -7.810  -5.374  1.00  0.00           C  
ATOM    509  CG1 ILE A  33      -7.553  -6.525  -5.522  1.00  0.00           C  
ATOM    510  CG2 ILE A  33      -5.231  -7.537  -5.371  1.00  0.00           C  
ATOM    511  CD1 ILE A  33      -7.563  -6.046  -6.975  1.00  0.00           C  
ATOM    512  H   ILE A  33      -8.840  -9.206  -5.368  1.00  0.00           H  
ATOM    513  HA  ILE A  33      -7.031  -8.311  -7.417  1.00  0.00           H  
ATOM    514  HB  ILE A  33      -6.987  -8.240  -4.404  1.00  0.00           H  
ATOM    515 HG12 ILE A  33      -8.574  -6.697  -5.184  1.00  0.00           H  
ATOM    516 HG13 ILE A  33      -7.133  -5.748  -4.883  1.00  0.00           H  
ATOM    517 HG21 ILE A  33      -4.715  -8.337  -5.900  1.00  0.00           H  
ATOM    518 HG22 ILE A  33      -5.033  -6.586  -5.868  1.00  0.00           H  
ATOM    519 HG23 ILE A  33      -4.872  -7.490  -4.343  1.00  0.00           H  
ATOM    520 HD11 ILE A  33      -6.546  -6.051  -7.367  1.00  0.00           H  
ATOM    521 HD12 ILE A  33      -8.186  -6.713  -7.572  1.00  0.00           H  
ATOM    522 HD13 ILE A  33      -7.966  -5.035  -7.022  1.00  0.00           H  
ATOM    523  N   SER A  34      -6.298 -10.853  -5.441  1.00  0.00           N  
ATOM    524  CA  SER A  34      -5.492 -12.058  -5.338  1.00  0.00           C  
ATOM    525  C   SER A  34      -5.700 -12.934  -6.574  1.00  0.00           C  
ATOM    526  O   SER A  34      -4.778 -13.619  -7.016  1.00  0.00           O  
ATOM    527  CB  SER A  34      -5.833 -12.841  -4.068  1.00  0.00           C  
ATOM    528  OG  SER A  34      -7.235 -13.056  -3.934  1.00  0.00           O  
ATOM    529  H   SER A  34      -6.918 -10.691  -4.673  1.00  0.00           H  
ATOM    530  HA  SER A  34      -4.460 -11.710  -5.284  1.00  0.00           H  
ATOM    531  HB2 SER A  34      -5.319 -13.802  -4.086  1.00  0.00           H  
ATOM    532  HB3 SER A  34      -5.464 -12.298  -3.198  1.00  0.00           H  
ATOM    533  HG  SER A  34      -7.631 -13.288  -4.822  1.00  0.00           H  
ATOM    534  N   ASN A  35      -6.916 -12.885  -7.098  1.00  0.00           N  
ATOM    535  CA  ASN A  35      -7.256 -13.666  -8.275  1.00  0.00           C  
ATOM    536  C   ASN A  35      -6.559 -13.068  -9.498  1.00  0.00           C  
ATOM    537  O   ASN A  35      -6.183 -13.791 -10.419  1.00  0.00           O  
ATOM    538  CB  ASN A  35      -8.764 -13.644  -8.533  1.00  0.00           C  
ATOM    539  CG  ASN A  35      -9.134 -14.568  -9.695  1.00  0.00           C  
ATOM    540  OD1 ASN A  35      -8.813 -14.320 -10.845  1.00  0.00           O  
ATOM    541  ND2 ASN A  35      -9.826 -15.644  -9.331  1.00  0.00           N  
ATOM    542  H   ASN A  35      -7.660 -12.325  -6.733  1.00  0.00           H  
ATOM    543  HA  ASN A  35      -6.917 -14.678  -8.054  1.00  0.00           H  
ATOM    544  HB2 ASN A  35      -9.295 -13.954  -7.634  1.00  0.00           H  
ATOM    545  HB3 ASN A  35      -9.084 -12.627  -8.757  1.00  0.00           H  
ATOM    546 HD21 ASN A  35     -10.057 -15.788  -8.369  1.00  0.00           H  
ATOM    547 HD22 ASN A  35     -10.115 -16.309 -10.020  1.00  0.00           H  
ATOM    548  N   ARG A  36      -6.405 -11.752  -9.468  1.00  0.00           N  
ATOM    549  CA  ARG A  36      -5.759 -11.049 -10.563  1.00  0.00           C  
ATOM    550  C   ARG A  36      -4.238 -11.166 -10.445  1.00  0.00           C  
ATOM    551  O   ARG A  36      -3.566 -11.535 -11.406  1.00  0.00           O  
ATOM    552  CB  ARG A  36      -6.150  -9.570 -10.573  1.00  0.00           C  
ATOM    553  CG  ARG A  36      -7.532  -9.371 -11.199  1.00  0.00           C  
ATOM    554  CD  ARG A  36      -7.473  -9.528 -12.720  1.00  0.00           C  
ATOM    555  NE  ARG A  36      -8.371  -8.545 -13.365  1.00  0.00           N  
ATOM    556  CZ  ARG A  36      -8.066  -7.866 -14.479  1.00  0.00           C  
ATOM    557  NH1 ARG A  36      -6.882  -8.058 -15.078  1.00  0.00           N  
ATOM    558  NH2 ARG A  36      -8.942  -6.993 -14.994  1.00  0.00           N  
ATOM    559  H   ARG A  36      -6.713 -11.170  -8.715  1.00  0.00           H  
ATOM    560  HA  ARG A  36      -6.123 -11.542 -11.464  1.00  0.00           H  
ATOM    561  HB2 ARG A  36      -6.150  -9.182  -9.554  1.00  0.00           H  
ATOM    562  HB3 ARG A  36      -5.409  -8.997 -11.132  1.00  0.00           H  
ATOM    563  HG2 ARG A  36      -8.231 -10.097 -10.782  1.00  0.00           H  
ATOM    564  HG3 ARG A  36      -7.912  -8.381 -10.946  1.00  0.00           H  
ATOM    565  HD2 ARG A  36      -6.451  -9.383 -13.069  1.00  0.00           H  
ATOM    566  HD3 ARG A  36      -7.766 -10.539 -13.001  1.00  0.00           H  
ATOM    567  HE  ARG A  36      -9.263  -8.377 -12.944  1.00  0.00           H  
ATOM    568 HH11 ARG A  36      -6.227  -8.709 -14.693  1.00  0.00           H  
ATOM    569 HH12 ARG A  36      -6.653  -7.550 -15.908  1.00  0.00           H  
ATOM    570 HH21 ARG A  36      -9.826  -6.849 -14.548  1.00  0.00           H  
ATOM    571 HH22 ARG A  36      -8.714  -6.485 -15.825  1.00  0.00           H  
ATOM    572  N   PHE A  37      -3.742 -10.845  -9.260  1.00  0.00           N  
ATOM    573  CA  PHE A  37      -2.313 -10.911  -9.005  1.00  0.00           C  
ATOM    574  C   PHE A  37      -1.988 -12.003  -7.983  1.00  0.00           C  
ATOM    575  O   PHE A  37      -2.440 -11.944  -6.841  1.00  0.00           O  
ATOM    576  CB  PHE A  37      -1.899  -9.553  -8.432  1.00  0.00           C  
ATOM    577  CG  PHE A  37      -2.306  -8.361  -9.299  1.00  0.00           C  
ATOM    578  CD1 PHE A  37      -1.633  -8.098 -10.452  1.00  0.00           C  
ATOM    579  CD2 PHE A  37      -3.339  -7.564  -8.918  1.00  0.00           C  
ATOM    580  CE1 PHE A  37      -2.012  -6.991 -11.257  1.00  0.00           C  
ATOM    581  CE2 PHE A  37      -3.717  -6.458  -9.724  1.00  0.00           C  
ATOM    582  CZ  PHE A  37      -3.045  -6.195 -10.876  1.00  0.00           C  
ATOM    583  H   PHE A  37      -4.297 -10.546  -8.483  1.00  0.00           H  
ATOM    584  HA  PHE A  37      -1.826 -11.144  -9.950  1.00  0.00           H  
ATOM    585  HB2 PHE A  37      -2.342  -9.438  -7.442  1.00  0.00           H  
ATOM    586  HB3 PHE A  37      -0.817  -9.541  -8.300  1.00  0.00           H  
ATOM    587  HD1 PHE A  37      -0.804  -8.737 -10.757  1.00  0.00           H  
ATOM    588  HD2 PHE A  37      -3.879  -7.775  -7.994  1.00  0.00           H  
ATOM    589  HE1 PHE A  37      -1.472  -6.780 -12.181  1.00  0.00           H  
ATOM    590  HE2 PHE A  37      -4.546  -5.819  -9.419  1.00  0.00           H  
ATOM    591  HZ  PHE A  37      -3.335  -5.345 -11.494  1.00  0.00           H  
ATOM    592  N   PRO A  38      -1.185 -13.000  -8.445  1.00  0.00           N  
ATOM    593  CA  PRO A  38      -0.795 -14.104  -7.585  1.00  0.00           C  
ATOM    594  C   PRO A  38       0.271 -13.665  -6.578  1.00  0.00           C  
ATOM    595  O   PRO A  38       0.175 -13.972  -5.392  1.00  0.00           O  
ATOM    596  CB  PRO A  38      -0.307 -15.187  -8.532  1.00  0.00           C  
ATOM    597  CG  PRO A  38      -0.005 -14.486  -9.847  1.00  0.00           C  
ATOM    598  CD  PRO A  38      -0.632 -13.102  -9.792  1.00  0.00           C  
ATOM    599  HA  PRO A  38      -1.574 -14.412  -7.040  1.00  0.00           H  
ATOM    600  HB2 PRO A  38       0.583 -15.678  -8.139  1.00  0.00           H  
ATOM    601  HB3 PRO A  38      -1.063 -15.959  -8.666  1.00  0.00           H  
ATOM    602  HG2 PRO A  38       1.071 -14.411 -10.002  1.00  0.00           H  
ATOM    603  HG3 PRO A  38      -0.410 -15.054 -10.684  1.00  0.00           H  
ATOM    604  HD2 PRO A  38       0.109 -12.324  -9.975  1.00  0.00           H  
ATOM    605  HD3 PRO A  38      -1.408 -12.988 -10.548  1.00  0.00           H  
ATOM    606  N   TYR A  39       1.264 -12.952  -7.091  1.00  0.00           N  
ATOM    607  CA  TYR A  39       2.347 -12.467  -6.252  1.00  0.00           C  
ATOM    608  C   TYR A  39       1.804 -11.709  -5.039  1.00  0.00           C  
ATOM    609  O   TYR A  39       2.355 -11.807  -3.944  1.00  0.00           O  
ATOM    610  CB  TYR A  39       3.154 -11.501  -7.122  1.00  0.00           C  
ATOM    611  CG  TYR A  39       3.782 -10.341  -6.347  1.00  0.00           C  
ATOM    612  CD1 TYR A  39       4.374 -10.570  -5.121  1.00  0.00           C  
ATOM    613  CD2 TYR A  39       3.757  -9.066  -6.873  1.00  0.00           C  
ATOM    614  CE1 TYR A  39       4.965  -9.480  -4.390  1.00  0.00           C  
ATOM    615  CE2 TYR A  39       4.349  -7.974  -6.143  1.00  0.00           C  
ATOM    616  CZ  TYR A  39       4.923  -8.235  -4.938  1.00  0.00           C  
ATOM    617  OH  TYR A  39       5.481  -7.203  -4.248  1.00  0.00           O  
ATOM    618  H   TYR A  39       1.335 -12.705  -8.057  1.00  0.00           H  
ATOM    619  HA  TYR A  39       2.917 -13.329  -5.908  1.00  0.00           H  
ATOM    620  HB2 TYR A  39       3.944 -12.057  -7.627  1.00  0.00           H  
ATOM    621  HB3 TYR A  39       2.504 -11.096  -7.898  1.00  0.00           H  
ATOM    622  HD1 TYR A  39       4.393 -11.578  -4.705  1.00  0.00           H  
ATOM    623  HD2 TYR A  39       3.290  -8.884  -7.841  1.00  0.00           H  
ATOM    624  HE1 TYR A  39       5.435  -9.647  -3.422  1.00  0.00           H  
ATOM    625  HE2 TYR A  39       4.336  -6.962  -6.546  1.00  0.00           H  
ATOM    626  HH  TYR A  39       5.099  -7.163  -3.325  1.00  0.00           H  
ATOM    627  N   TYR A  40       0.730 -10.970  -5.274  1.00  0.00           N  
ATOM    628  CA  TYR A  40       0.107 -10.196  -4.215  1.00  0.00           C  
ATOM    629  C   TYR A  40      -0.508 -11.113  -3.155  1.00  0.00           C  
ATOM    630  O   TYR A  40      -0.468 -10.805  -1.964  1.00  0.00           O  
ATOM    631  CB  TYR A  40      -1.010  -9.389  -4.883  1.00  0.00           C  
ATOM    632  CG  TYR A  40      -0.507  -8.309  -5.843  1.00  0.00           C  
ATOM    633  CD1 TYR A  40       0.848  -8.113  -6.013  1.00  0.00           C  
ATOM    634  CD2 TYR A  40      -1.410  -7.531  -6.538  1.00  0.00           C  
ATOM    635  CE1 TYR A  40       1.320  -7.097  -6.917  1.00  0.00           C  
ATOM    636  CE2 TYR A  40      -0.937  -6.514  -7.442  1.00  0.00           C  
ATOM    637  CZ  TYR A  40       0.404  -6.348  -7.587  1.00  0.00           C  
ATOM    638  OH  TYR A  40       0.851  -5.387  -8.440  1.00  0.00           O  
ATOM    639  H   TYR A  40       0.288 -10.896  -6.169  1.00  0.00           H  
ATOM    640  HA  TYR A  40       0.877  -9.580  -3.751  1.00  0.00           H  
ATOM    641  HB2 TYR A  40      -1.661 -10.072  -5.428  1.00  0.00           H  
ATOM    642  HB3 TYR A  40      -1.616  -8.920  -4.109  1.00  0.00           H  
ATOM    643  HD1 TYR A  40       1.560  -8.729  -5.465  1.00  0.00           H  
ATOM    644  HD2 TYR A  40      -2.481  -7.685  -6.403  1.00  0.00           H  
ATOM    645  HE1 TYR A  40       2.389  -6.932  -7.062  1.00  0.00           H  
ATOM    646  HE2 TYR A  40      -1.640  -5.891  -7.997  1.00  0.00           H  
ATOM    647  HH  TYR A  40       0.534  -4.488  -8.139  1.00  0.00           H  
ATOM    648  N   ARG A  41      -1.061 -12.221  -3.626  1.00  0.00           N  
ATOM    649  CA  ARG A  41      -1.682 -13.184  -2.733  1.00  0.00           C  
ATOM    650  C   ARG A  41      -0.617 -14.067  -2.080  1.00  0.00           C  
ATOM    651  O   ARG A  41      -0.896 -14.769  -1.109  1.00  0.00           O  
ATOM    652  CB  ARG A  41      -2.677 -14.071  -3.486  1.00  0.00           C  
ATOM    653  CG  ARG A  41      -3.638 -14.763  -2.516  1.00  0.00           C  
ATOM    654  CD  ARG A  41      -4.443 -15.852  -3.226  1.00  0.00           C  
ATOM    655  NE  ARG A  41      -4.097 -17.180  -2.672  1.00  0.00           N  
ATOM    656  CZ  ARG A  41      -4.328 -18.340  -3.300  1.00  0.00           C  
ATOM    657  NH1 ARG A  41      -4.907 -18.344  -4.509  1.00  0.00           N  
ATOM    658  NH2 ARG A  41      -3.980 -19.497  -2.721  1.00  0.00           N  
ATOM    659  H   ARG A  41      -1.089 -12.464  -4.595  1.00  0.00           H  
ATOM    660  HA  ARG A  41      -2.202 -12.581  -1.990  1.00  0.00           H  
ATOM    661  HB2 ARG A  41      -3.243 -13.467  -4.195  1.00  0.00           H  
ATOM    662  HB3 ARG A  41      -2.137 -14.821  -4.064  1.00  0.00           H  
ATOM    663  HG2 ARG A  41      -3.076 -15.199  -1.691  1.00  0.00           H  
ATOM    664  HG3 ARG A  41      -4.317 -14.027  -2.085  1.00  0.00           H  
ATOM    665  HD2 ARG A  41      -5.510 -15.666  -3.105  1.00  0.00           H  
ATOM    666  HD3 ARG A  41      -4.236 -15.830  -4.296  1.00  0.00           H  
ATOM    667  HE  ARG A  41      -3.662 -17.213  -1.771  1.00  0.00           H  
ATOM    668 HH11 ARG A  41      -5.168 -17.480  -4.941  1.00  0.00           H  
ATOM    669 HH12 ARG A  41      -5.080 -19.210  -4.979  1.00  0.00           H  
ATOM    670 HH21 ARG A  41      -3.547 -19.495  -1.820  1.00  0.00           H  
ATOM    671 HH22 ARG A  41      -4.152 -20.363  -3.191  1.00  0.00           H  
ATOM    672  N   GLU A  42       0.583 -14.003  -2.638  1.00  0.00           N  
ATOM    673  CA  GLU A  42       1.692 -14.787  -2.122  1.00  0.00           C  
ATOM    674  C   GLU A  42       2.321 -14.086  -0.916  1.00  0.00           C  
ATOM    675  O   GLU A  42       2.426 -14.672   0.161  1.00  0.00           O  
ATOM    676  CB  GLU A  42       2.735 -15.046  -3.212  1.00  0.00           C  
ATOM    677  CG  GLU A  42       3.732 -16.120  -2.772  1.00  0.00           C  
ATOM    678  CD  GLU A  42       5.009 -15.487  -2.216  1.00  0.00           C  
ATOM    679  OE1 GLU A  42       5.719 -14.843  -3.017  1.00  0.00           O  
ATOM    680  OE2 GLU A  42       5.246 -15.663  -1.001  1.00  0.00           O  
ATOM    681  H   GLU A  42       0.803 -13.429  -3.427  1.00  0.00           H  
ATOM    682  HA  GLU A  42       1.255 -15.737  -1.812  1.00  0.00           H  
ATOM    683  HB2 GLU A  42       2.237 -15.360  -4.129  1.00  0.00           H  
ATOM    684  HB3 GLU A  42       3.266 -14.122  -3.438  1.00  0.00           H  
ATOM    685  HG2 GLU A  42       3.276 -16.755  -2.012  1.00  0.00           H  
ATOM    686  HG3 GLU A  42       3.978 -16.761  -3.619  1.00  0.00           H  
ATOM    687  N   LYS A  43       2.725 -12.844  -1.138  1.00  0.00           N  
ATOM    688  CA  LYS A  43       3.341 -12.058  -0.082  1.00  0.00           C  
ATOM    689  C   LYS A  43       2.261 -11.586   0.893  1.00  0.00           C  
ATOM    690  O   LYS A  43       2.373 -11.797   2.099  1.00  0.00           O  
ATOM    691  CB  LYS A  43       4.172 -10.920  -0.679  1.00  0.00           C  
ATOM    692  CG  LYS A  43       5.020 -10.240   0.398  1.00  0.00           C  
ATOM    693  CD  LYS A  43       6.436 -10.818   0.427  1.00  0.00           C  
ATOM    694  CE  LYS A  43       7.459  -9.748   0.815  1.00  0.00           C  
ATOM    695  NZ  LYS A  43       8.306  -9.395  -0.346  1.00  0.00           N  
ATOM    696  H   LYS A  43       2.635 -12.376  -2.016  1.00  0.00           H  
ATOM    697  HA  LYS A  43       4.028 -12.713   0.454  1.00  0.00           H  
ATOM    698  HB2 LYS A  43       4.820 -11.310  -1.464  1.00  0.00           H  
ATOM    699  HB3 LYS A  43       3.513 -10.188  -1.144  1.00  0.00           H  
ATOM    700  HG2 LYS A  43       5.066  -9.167   0.205  1.00  0.00           H  
ATOM    701  HG3 LYS A  43       4.551 -10.369   1.373  1.00  0.00           H  
ATOM    702  HD2 LYS A  43       6.481 -11.642   1.139  1.00  0.00           H  
ATOM    703  HD3 LYS A  43       6.687 -11.227  -0.552  1.00  0.00           H  
ATOM    704  HE2 LYS A  43       6.943  -8.859   1.179  1.00  0.00           H  
ATOM    705  HE3 LYS A  43       8.083 -10.111   1.632  1.00  0.00           H  
ATOM    706  HZ1 LYS A  43       7.855  -9.689  -1.189  1.00  0.00           H  
ATOM    707  HZ2 LYS A  43       8.444  -8.405  -0.370  1.00  0.00           H  
ATOM    708  HZ3 LYS A  43       9.191  -9.853  -0.264  1.00  0.00           H  
ATOM    709  N   PHE A  44       1.239 -10.952   0.334  1.00  0.00           N  
ATOM    710  CA  PHE A  44       0.141 -10.448   1.139  1.00  0.00           C  
ATOM    711  C   PHE A  44       0.642  -9.929   2.487  1.00  0.00           C  
ATOM    712  O   PHE A  44       0.259 -10.445   3.536  1.00  0.00           O  
ATOM    713  CB  PHE A  44      -0.813 -11.621   1.379  1.00  0.00           C  
ATOM    714  CG  PHE A  44      -2.274 -11.207   1.560  1.00  0.00           C  
ATOM    715  CD1 PHE A  44      -2.628 -10.386   2.586  1.00  0.00           C  
ATOM    716  CD2 PHE A  44      -3.222 -11.659   0.694  1.00  0.00           C  
ATOM    717  CE1 PHE A  44      -3.984 -10.002   2.753  1.00  0.00           C  
ATOM    718  CE2 PHE A  44      -4.579 -11.276   0.863  1.00  0.00           C  
ATOM    719  CZ  PHE A  44      -4.931 -10.455   1.888  1.00  0.00           C  
ATOM    720  H   PHE A  44       1.156 -10.784  -0.649  1.00  0.00           H  
ATOM    721  HA  PHE A  44      -0.318  -9.629   0.584  1.00  0.00           H  
ATOM    722  HB2 PHE A  44      -0.743 -12.311   0.538  1.00  0.00           H  
ATOM    723  HB3 PHE A  44      -0.488 -12.164   2.266  1.00  0.00           H  
ATOM    724  HD1 PHE A  44      -1.869 -10.024   3.278  1.00  0.00           H  
ATOM    725  HD2 PHE A  44      -2.939 -12.317  -0.128  1.00  0.00           H  
ATOM    726  HE1 PHE A  44      -4.266  -9.345   3.576  1.00  0.00           H  
ATOM    727  HE2 PHE A  44      -5.337 -11.639   0.170  1.00  0.00           H  
ATOM    728  HZ  PHE A  44      -5.973 -10.161   2.018  1.00  0.00           H  
ATOM    729  N   PRO A  45       1.513  -8.887   2.415  1.00  0.00           N  
ATOM    730  CA  PRO A  45       2.071  -8.293   3.618  1.00  0.00           C  
ATOM    731  C   PRO A  45       1.035  -7.421   4.329  1.00  0.00           C  
ATOM    732  O   PRO A  45       1.347  -6.317   4.773  1.00  0.00           O  
ATOM    733  CB  PRO A  45       3.283  -7.507   3.142  1.00  0.00           C  
ATOM    734  CG  PRO A  45       3.091  -7.309   1.647  1.00  0.00           C  
ATOM    735  CD  PRO A  45       1.988  -8.251   1.190  1.00  0.00           C  
ATOM    736  HA  PRO A  45       2.324  -9.006   4.271  1.00  0.00           H  
ATOM    737  HB2 PRO A  45       3.353  -6.549   3.658  1.00  0.00           H  
ATOM    738  HB3 PRO A  45       4.205  -8.049   3.348  1.00  0.00           H  
ATOM    739  HG2 PRO A  45       2.824  -6.275   1.430  1.00  0.00           H  
ATOM    740  HG3 PRO A  45       4.018  -7.518   1.112  1.00  0.00           H  
ATOM    741  HD2 PRO A  45       1.187  -7.708   0.688  1.00  0.00           H  
ATOM    742  HD3 PRO A  45       2.367  -8.988   0.481  1.00  0.00           H  
ATOM    743  N   ALA A  46      -0.176  -7.950   4.417  1.00  0.00           N  
ATOM    744  CA  ALA A  46      -1.261  -7.234   5.068  1.00  0.00           C  
ATOM    745  C   ALA A  46      -2.017  -6.407   4.026  1.00  0.00           C  
ATOM    746  O   ALA A  46      -2.000  -5.178   4.072  1.00  0.00           O  
ATOM    747  CB  ALA A  46      -0.697  -6.372   6.199  1.00  0.00           C  
ATOM    748  H   ALA A  46      -0.422  -8.849   4.054  1.00  0.00           H  
ATOM    749  HA  ALA A  46      -1.938  -7.973   5.494  1.00  0.00           H  
ATOM    750  HB1 ALA A  46       0.208  -6.835   6.592  1.00  0.00           H  
ATOM    751  HB2 ALA A  46      -0.460  -5.380   5.816  1.00  0.00           H  
ATOM    752  HB3 ALA A  46      -1.437  -6.286   6.994  1.00  0.00           H  
ATOM    753  N   TRP A  47      -2.664  -7.114   3.111  1.00  0.00           N  
ATOM    754  CA  TRP A  47      -3.425  -6.461   2.060  1.00  0.00           C  
ATOM    755  C   TRP A  47      -4.793  -6.083   2.632  1.00  0.00           C  
ATOM    756  O   TRP A  47      -5.627  -5.512   1.931  1.00  0.00           O  
ATOM    757  CB  TRP A  47      -3.521  -7.351   0.819  1.00  0.00           C  
ATOM    758  CG  TRP A  47      -2.347  -7.196  -0.149  1.00  0.00           C  
ATOM    759  CD1 TRP A  47      -1.049  -7.436   0.082  1.00  0.00           C  
ATOM    760  CD2 TRP A  47      -2.417  -6.755  -1.522  1.00  0.00           C  
ATOM    761  NE1 TRP A  47      -0.281  -7.183  -1.036  1.00  0.00           N  
ATOM    762  CE2 TRP A  47      -1.139  -6.755  -2.042  1.00  0.00           C  
ATOM    763  CE3 TRP A  47      -3.525  -6.369  -2.298  1.00  0.00           C  
ATOM    764  CZ2 TRP A  47      -0.847  -6.378  -3.359  1.00  0.00           C  
ATOM    765  CZ3 TRP A  47      -3.215  -5.995  -3.612  1.00  0.00           C  
ATOM    766  CH2 TRP A  47      -1.934  -5.989  -4.151  1.00  0.00           C  
ATOM    767  H   TRP A  47      -2.673  -8.114   3.080  1.00  0.00           H  
ATOM    768  HA  TRP A  47      -2.883  -5.562   1.765  1.00  0.00           H  
ATOM    769  HB2 TRP A  47      -3.584  -8.392   1.135  1.00  0.00           H  
ATOM    770  HB3 TRP A  47      -4.447  -7.121   0.292  1.00  0.00           H  
ATOM    771  HD1 TRP A  47      -0.651  -7.787   1.034  1.00  0.00           H  
ATOM    772  HE1 TRP A  47       0.800  -7.296  -1.115  1.00  0.00           H  
ATOM    773  HE3 TRP A  47      -4.543  -6.360  -1.911  1.00  0.00           H  
ATOM    774  HZ2 TRP A  47       0.172  -6.387  -3.746  1.00  0.00           H  
ATOM    775  HZ3 TRP A  47      -4.038  -5.686  -4.257  1.00  0.00           H  
ATOM    776  HH2 TRP A  47      -1.776  -5.684  -5.185  1.00  0.00           H  
ATOM    777  N   GLN A  48      -4.981  -6.417   3.900  1.00  0.00           N  
ATOM    778  CA  GLN A  48      -6.234  -6.120   4.575  1.00  0.00           C  
ATOM    779  C   GLN A  48      -6.384  -4.610   4.772  1.00  0.00           C  
ATOM    780  O   GLN A  48      -7.328  -4.005   4.264  1.00  0.00           O  
ATOM    781  CB  GLN A  48      -6.326  -6.859   5.911  1.00  0.00           C  
ATOM    782  CG  GLN A  48      -7.633  -6.526   6.632  1.00  0.00           C  
ATOM    783  CD  GLN A  48      -7.423  -5.417   7.665  1.00  0.00           C  
ATOM    784  OE1 GLN A  48      -7.000  -5.649   8.786  1.00  0.00           O  
ATOM    785  NE2 GLN A  48      -7.740  -4.202   7.226  1.00  0.00           N  
ATOM    786  H   GLN A  48      -4.297  -6.881   4.464  1.00  0.00           H  
ATOM    787  HA  GLN A  48      -7.015  -6.485   3.910  1.00  0.00           H  
ATOM    788  HB2 GLN A  48      -6.264  -7.934   5.741  1.00  0.00           H  
ATOM    789  HB3 GLN A  48      -5.479  -6.586   6.541  1.00  0.00           H  
ATOM    790  HG2 GLN A  48      -8.384  -6.215   5.906  1.00  0.00           H  
ATOM    791  HG3 GLN A  48      -8.018  -7.419   7.125  1.00  0.00           H  
ATOM    792 HE21 GLN A  48      -8.083  -4.081   6.295  1.00  0.00           H  
ATOM    793 HE22 GLN A  48      -7.638  -3.411   7.829  1.00  0.00           H  
ATOM    794  N   ASN A  49      -5.441  -4.044   5.511  1.00  0.00           N  
ATOM    795  CA  ASN A  49      -5.457  -2.617   5.782  1.00  0.00           C  
ATOM    796  C   ASN A  49      -4.999  -1.860   4.533  1.00  0.00           C  
ATOM    797  O   ASN A  49      -5.480  -0.762   4.257  1.00  0.00           O  
ATOM    798  CB  ASN A  49      -4.506  -2.262   6.926  1.00  0.00           C  
ATOM    799  CG  ASN A  49      -4.307  -3.455   7.863  1.00  0.00           C  
ATOM    800  OD1 ASN A  49      -5.224  -4.201   8.164  1.00  0.00           O  
ATOM    801  ND2 ASN A  49      -3.062  -3.591   8.308  1.00  0.00           N  
ATOM    802  H   ASN A  49      -4.677  -4.543   5.920  1.00  0.00           H  
ATOM    803  HA  ASN A  49      -6.488  -2.388   6.052  1.00  0.00           H  
ATOM    804  HB2 ASN A  49      -3.543  -1.950   6.519  1.00  0.00           H  
ATOM    805  HB3 ASN A  49      -4.904  -1.417   7.486  1.00  0.00           H  
ATOM    806 HD21 ASN A  49      -2.355  -2.944   8.023  1.00  0.00           H  
ATOM    807 HD22 ASN A  49      -2.831  -4.343   8.927  1.00  0.00           H  
ATOM    808  N   SER A  50      -4.075  -2.477   3.813  1.00  0.00           N  
ATOM    809  CA  SER A  50      -3.545  -1.875   2.600  1.00  0.00           C  
ATOM    810  C   SER A  50      -4.676  -1.636   1.598  1.00  0.00           C  
ATOM    811  O   SER A  50      -4.865  -0.516   1.126  1.00  0.00           O  
ATOM    812  CB  SER A  50      -2.460  -2.756   1.977  1.00  0.00           C  
ATOM    813  OG  SER A  50      -1.157  -2.212   2.165  1.00  0.00           O  
ATOM    814  H   SER A  50      -3.688  -3.370   4.044  1.00  0.00           H  
ATOM    815  HA  SER A  50      -3.107  -0.929   2.916  1.00  0.00           H  
ATOM    816  HB2 SER A  50      -2.505  -3.753   2.416  1.00  0.00           H  
ATOM    817  HB3 SER A  50      -2.655  -2.869   0.910  1.00  0.00           H  
ATOM    818  HG  SER A  50      -0.544  -2.912   2.532  1.00  0.00           H  
ATOM    819  N   ILE A  51      -5.399  -2.706   1.304  1.00  0.00           N  
ATOM    820  CA  ILE A  51      -6.507  -2.627   0.366  1.00  0.00           C  
ATOM    821  C   ILE A  51      -7.604  -1.737   0.954  1.00  0.00           C  
ATOM    822  O   ILE A  51      -7.978  -0.729   0.356  1.00  0.00           O  
ATOM    823  CB  ILE A  51      -6.990  -4.029  -0.012  1.00  0.00           C  
ATOM    824  CG1 ILE A  51      -5.887  -4.815  -0.724  1.00  0.00           C  
ATOM    825  CG2 ILE A  51      -8.272  -3.961  -0.843  1.00  0.00           C  
ATOM    826  CD1 ILE A  51      -5.631  -4.255  -2.124  1.00  0.00           C  
ATOM    827  H   ILE A  51      -5.239  -3.614   1.693  1.00  0.00           H  
ATOM    828  HA  ILE A  51      -6.132  -2.158  -0.543  1.00  0.00           H  
ATOM    829  HB  ILE A  51      -7.229  -4.567   0.905  1.00  0.00           H  
ATOM    830 HG12 ILE A  51      -4.969  -4.772  -0.138  1.00  0.00           H  
ATOM    831 HG13 ILE A  51      -6.171  -5.864  -0.795  1.00  0.00           H  
ATOM    832 HG21 ILE A  51      -8.144  -3.239  -1.651  1.00  0.00           H  
ATOM    833 HG22 ILE A  51      -8.485  -4.943  -1.265  1.00  0.00           H  
ATOM    834 HG23 ILE A  51      -9.101  -3.650  -0.207  1.00  0.00           H  
ATOM    835 HD11 ILE A  51      -6.189  -3.327  -2.252  1.00  0.00           H  
ATOM    836 HD12 ILE A  51      -4.565  -4.058  -2.248  1.00  0.00           H  
ATOM    837 HD13 ILE A  51      -5.955  -4.980  -2.871  1.00  0.00           H  
ATOM    838  N   ARG A  52      -8.089  -2.141   2.120  1.00  0.00           N  
ATOM    839  CA  ARG A  52      -9.136  -1.393   2.795  1.00  0.00           C  
ATOM    840  C   ARG A  52      -8.763   0.089   2.872  1.00  0.00           C  
ATOM    841  O   ARG A  52      -9.633   0.955   2.818  1.00  0.00           O  
ATOM    842  CB  ARG A  52      -9.370  -1.927   4.209  1.00  0.00           C  
ATOM    843  CG  ARG A  52     -10.246  -3.181   4.183  1.00  0.00           C  
ATOM    844  CD  ARG A  52     -10.602  -3.632   5.601  1.00  0.00           C  
ATOM    845  NE  ARG A  52     -10.341  -5.081   5.752  1.00  0.00           N  
ATOM    846  CZ  ARG A  52     -10.530  -5.764   6.888  1.00  0.00           C  
ATOM    847  NH1 ARG A  52     -10.983  -5.133   7.981  1.00  0.00           N  
ATOM    848  NH2 ARG A  52     -10.267  -7.077   6.934  1.00  0.00           N  
ATOM    849  H   ARG A  52      -7.780  -2.962   2.600  1.00  0.00           H  
ATOM    850  HA  ARG A  52     -10.024  -1.542   2.182  1.00  0.00           H  
ATOM    851  HB2 ARG A  52      -8.414  -2.158   4.678  1.00  0.00           H  
ATOM    852  HB3 ARG A  52      -9.846  -1.159   4.817  1.00  0.00           H  
ATOM    853  HG2 ARG A  52     -11.159  -2.980   3.622  1.00  0.00           H  
ATOM    854  HG3 ARG A  52      -9.723  -3.984   3.662  1.00  0.00           H  
ATOM    855  HD2 ARG A  52     -10.014  -3.071   6.327  1.00  0.00           H  
ATOM    856  HD3 ARG A  52     -11.651  -3.419   5.807  1.00  0.00           H  
ATOM    857  HE  ARG A  52     -10.003  -5.582   4.955  1.00  0.00           H  
ATOM    858 HH11 ARG A  52     -11.179  -4.153   7.948  1.00  0.00           H  
ATOM    859 HH12 ARG A  52     -11.124  -5.643   8.830  1.00  0.00           H  
ATOM    860 HH21 ARG A  52      -9.930  -7.547   6.119  1.00  0.00           H  
ATOM    861 HH22 ARG A  52     -10.409  -7.586   7.782  1.00  0.00           H  
ATOM    862  N   HIS A  53      -7.466   0.334   2.998  1.00  0.00           N  
ATOM    863  CA  HIS A  53      -6.967   1.696   3.085  1.00  0.00           C  
ATOM    864  C   HIS A  53      -7.156   2.397   1.738  1.00  0.00           C  
ATOM    865  O   HIS A  53      -7.807   3.438   1.662  1.00  0.00           O  
ATOM    866  CB  HIS A  53      -5.515   1.714   3.564  1.00  0.00           C  
ATOM    867  CG  HIS A  53      -4.821   3.042   3.376  1.00  0.00           C  
ATOM    868  ND1 HIS A  53      -4.818   4.029   4.345  1.00  0.00           N  
ATOM    869  CD2 HIS A  53      -4.109   3.534   2.322  1.00  0.00           C  
ATOM    870  CE1 HIS A  53      -4.132   5.065   3.884  1.00  0.00           C  
ATOM    871  NE2 HIS A  53      -3.695   4.757   2.630  1.00  0.00           N  
ATOM    872  H   HIS A  53      -6.765  -0.376   3.042  1.00  0.00           H  
ATOM    873  HA  HIS A  53      -7.572   2.204   3.836  1.00  0.00           H  
ATOM    874  HB2 HIS A  53      -5.489   1.448   4.621  1.00  0.00           H  
ATOM    875  HB3 HIS A  53      -4.957   0.945   3.029  1.00  0.00           H  
ATOM    876  HD1 HIS A  53      -5.258   3.971   5.241  1.00  0.00           H  
ATOM    877  HD2 HIS A  53      -3.914   3.012   1.385  1.00  0.00           H  
ATOM    878  HE1 HIS A  53      -3.950   6.000   4.415  1.00  0.00           H  
ATOM    879  N   ASN A  54      -6.574   1.800   0.709  1.00  0.00           N  
ATOM    880  CA  ASN A  54      -6.669   2.354  -0.631  1.00  0.00           C  
ATOM    881  C   ASN A  54      -8.105   2.210  -1.137  1.00  0.00           C  
ATOM    882  O   ASN A  54      -8.476   2.811  -2.144  1.00  0.00           O  
ATOM    883  CB  ASN A  54      -5.749   1.610  -1.602  1.00  0.00           C  
ATOM    884  CG  ASN A  54      -4.282   1.968  -1.350  1.00  0.00           C  
ATOM    885  OD1 ASN A  54      -3.689   2.783  -2.037  1.00  0.00           O  
ATOM    886  ND2 ASN A  54      -3.734   1.315  -0.331  1.00  0.00           N  
ATOM    887  H   ASN A  54      -6.045   0.954   0.779  1.00  0.00           H  
ATOM    888  HA  ASN A  54      -6.364   3.396  -0.532  1.00  0.00           H  
ATOM    889  HB2 ASN A  54      -5.889   0.535  -1.489  1.00  0.00           H  
ATOM    890  HB3 ASN A  54      -6.018   1.861  -2.628  1.00  0.00           H  
ATOM    891 HD21 ASN A  54      -4.277   0.658   0.194  1.00  0.00           H  
ATOM    892 HD22 ASN A  54      -2.779   1.479  -0.087  1.00  0.00           H  
ATOM    893  N   LEU A  55      -8.875   1.410  -0.414  1.00  0.00           N  
ATOM    894  CA  LEU A  55     -10.264   1.180  -0.777  1.00  0.00           C  
ATOM    895  C   LEU A  55     -11.127   2.313  -0.220  1.00  0.00           C  
ATOM    896  O   LEU A  55     -11.866   2.958  -0.962  1.00  0.00           O  
ATOM    897  CB  LEU A  55     -10.712  -0.212  -0.327  1.00  0.00           C  
ATOM    898  CG  LEU A  55     -12.018  -0.726  -0.934  1.00  0.00           C  
ATOM    899  CD1 LEU A  55     -12.325  -0.018  -2.255  1.00  0.00           C  
ATOM    900  CD2 LEU A  55     -11.990  -2.248  -1.091  1.00  0.00           C  
ATOM    901  H   LEU A  55      -8.567   0.925   0.404  1.00  0.00           H  
ATOM    902  HA  LEU A  55     -10.325   1.201  -1.865  1.00  0.00           H  
ATOM    903  HB2 LEU A  55      -9.919  -0.922  -0.566  1.00  0.00           H  
ATOM    904  HB3 LEU A  55     -10.816  -0.206   0.758  1.00  0.00           H  
ATOM    905  HG  LEU A  55     -12.831  -0.488  -0.246  1.00  0.00           H  
ATOM    906 HD11 LEU A  55     -12.297   1.061  -2.105  1.00  0.00           H  
ATOM    907 HD12 LEU A  55     -11.579  -0.300  -2.999  1.00  0.00           H  
ATOM    908 HD13 LEU A  55     -13.315  -0.312  -2.604  1.00  0.00           H  
ATOM    909 HD21 LEU A  55     -11.024  -2.553  -1.491  1.00  0.00           H  
ATOM    910 HD22 LEU A  55     -12.145  -2.716  -0.119  1.00  0.00           H  
ATOM    911 HD23 LEU A  55     -12.781  -2.557  -1.774  1.00  0.00           H  
ATOM    912  N   SER A  56     -11.005   2.521   1.082  1.00  0.00           N  
ATOM    913  CA  SER A  56     -11.765   3.566   1.748  1.00  0.00           C  
ATOM    914  C   SER A  56     -11.087   4.921   1.538  1.00  0.00           C  
ATOM    915  O   SER A  56     -11.732   5.886   1.132  1.00  0.00           O  
ATOM    916  CB  SER A  56     -11.914   3.273   3.242  1.00  0.00           C  
ATOM    917  OG  SER A  56     -10.804   3.756   3.994  1.00  0.00           O  
ATOM    918  H   SER A  56     -10.402   1.993   1.679  1.00  0.00           H  
ATOM    919  HA  SER A  56     -12.747   3.553   1.276  1.00  0.00           H  
ATOM    920  HB2 SER A  56     -12.830   3.732   3.613  1.00  0.00           H  
ATOM    921  HB3 SER A  56     -12.014   2.198   3.392  1.00  0.00           H  
ATOM    922  HG  SER A  56     -10.021   3.144   3.880  1.00  0.00           H  
ATOM    923  N   LEU A  57      -9.793   4.950   1.825  1.00  0.00           N  
ATOM    924  CA  LEU A  57      -9.021   6.172   1.672  1.00  0.00           C  
ATOM    925  C   LEU A  57      -8.899   6.511   0.186  1.00  0.00           C  
ATOM    926  O   LEU A  57      -7.874   6.234  -0.436  1.00  0.00           O  
ATOM    927  CB  LEU A  57      -7.673   6.045   2.387  1.00  0.00           C  
ATOM    928  CG  LEU A  57      -6.946   7.358   2.683  1.00  0.00           C  
ATOM    929  CD1 LEU A  57      -6.759   7.554   4.189  1.00  0.00           C  
ATOM    930  CD2 LEU A  57      -5.618   7.431   1.926  1.00  0.00           C  
ATOM    931  H   LEU A  57      -9.276   4.161   2.155  1.00  0.00           H  
ATOM    932  HA  LEU A  57      -9.573   6.972   2.166  1.00  0.00           H  
ATOM    933  HB2 LEU A  57      -7.832   5.520   3.328  1.00  0.00           H  
ATOM    934  HB3 LEU A  57      -7.020   5.419   1.779  1.00  0.00           H  
ATOM    935  HG  LEU A  57      -7.566   8.180   2.325  1.00  0.00           H  
ATOM    936 HD11 LEU A  57      -7.580   7.073   4.722  1.00  0.00           H  
ATOM    937 HD12 LEU A  57      -5.814   7.109   4.499  1.00  0.00           H  
ATOM    938 HD13 LEU A  57      -6.752   8.619   4.418  1.00  0.00           H  
ATOM    939 HD21 LEU A  57      -5.709   6.900   0.979  1.00  0.00           H  
ATOM    940 HD22 LEU A  57      -5.366   8.474   1.735  1.00  0.00           H  
ATOM    941 HD23 LEU A  57      -4.832   6.972   2.527  1.00  0.00           H  
ATOM    942  N   ASN A  58      -9.959   7.106  -0.342  1.00  0.00           N  
ATOM    943  CA  ASN A  58      -9.984   7.486  -1.744  1.00  0.00           C  
ATOM    944  C   ASN A  58     -11.434   7.681  -2.189  1.00  0.00           C  
ATOM    945  O   ASN A  58     -11.854   8.802  -2.473  1.00  0.00           O  
ATOM    946  CB  ASN A  58      -9.363   6.396  -2.620  1.00  0.00           C  
ATOM    947  CG  ASN A  58      -8.087   6.900  -3.298  1.00  0.00           C  
ATOM    948  OD1 ASN A  58      -7.890   6.754  -4.493  1.00  0.00           O  
ATOM    949  ND2 ASN A  58      -7.234   7.498  -2.471  1.00  0.00           N  
ATOM    950  H   ASN A  58     -10.789   7.327   0.171  1.00  0.00           H  
ATOM    951  HA  ASN A  58      -9.402   8.406  -1.801  1.00  0.00           H  
ATOM    952  HB2 ASN A  58      -9.136   5.521  -2.013  1.00  0.00           H  
ATOM    953  HB3 ASN A  58     -10.081   6.081  -3.378  1.00  0.00           H  
ATOM    954 HD21 ASN A  58      -7.457   7.585  -1.500  1.00  0.00           H  
ATOM    955 HD22 ASN A  58      -6.371   7.861  -2.820  1.00  0.00           H  
ATOM    956  N   ASP A  59     -12.160   6.574  -2.236  1.00  0.00           N  
ATOM    957  CA  ASP A  59     -13.555   6.610  -2.641  1.00  0.00           C  
ATOM    958  C   ASP A  59     -14.365   7.382  -1.598  1.00  0.00           C  
ATOM    959  O   ASP A  59     -15.175   8.241  -1.946  1.00  0.00           O  
ATOM    960  CB  ASP A  59     -14.136   5.198  -2.741  1.00  0.00           C  
ATOM    961  CG  ASP A  59     -13.412   4.268  -3.717  1.00  0.00           C  
ATOM    962  OD1 ASP A  59     -12.162   4.302  -3.711  1.00  0.00           O  
ATOM    963  OD2 ASP A  59     -14.125   3.546  -4.448  1.00  0.00           O  
ATOM    964  H   ASP A  59     -11.811   5.667  -2.003  1.00  0.00           H  
ATOM    965  HA  ASP A  59     -13.557   7.098  -3.615  1.00  0.00           H  
ATOM    966  HB2 ASP A  59     -14.120   4.744  -1.751  1.00  0.00           H  
ATOM    967  HB3 ASP A  59     -15.181   5.272  -3.041  1.00  0.00           H  
ATOM    968  N   CYS A  60     -14.121   7.048  -0.339  1.00  0.00           N  
ATOM    969  CA  CYS A  60     -14.817   7.699   0.757  1.00  0.00           C  
ATOM    970  C   CYS A  60     -16.287   7.277   0.710  1.00  0.00           C  
ATOM    971  O   CYS A  60     -17.168   8.105   0.483  1.00  0.00           O  
ATOM    972  CB  CYS A  60     -14.659   9.219   0.704  1.00  0.00           C  
ATOM    973  SG  CYS A  60     -13.058   9.707   1.446  1.00  0.00           S  
ATOM    974  H   CYS A  60     -13.461   6.348  -0.065  1.00  0.00           H  
ATOM    975  HA  CYS A  60     -14.345   7.355   1.676  1.00  0.00           H  
ATOM    976  HB2 CYS A  60     -14.710   9.563  -0.328  1.00  0.00           H  
ATOM    977  HB3 CYS A  60     -15.477   9.698   1.241  1.00  0.00           H  
ATOM    978  HG  CYS A  60     -12.820  10.717   0.612  1.00  0.00           H  
ATOM    979  N   PHE A  61     -16.507   5.989   0.926  1.00  0.00           N  
ATOM    980  CA  PHE A  61     -17.855   5.447   0.912  1.00  0.00           C  
ATOM    981  C   PHE A  61     -18.243   4.905   2.289  1.00  0.00           C  
ATOM    982  O   PHE A  61     -17.604   5.226   3.289  1.00  0.00           O  
ATOM    983  CB  PHE A  61     -17.864   4.295  -0.097  1.00  0.00           C  
ATOM    984  CG  PHE A  61     -16.565   3.488  -0.131  1.00  0.00           C  
ATOM    985  CD1 PHE A  61     -16.051   2.977   1.021  1.00  0.00           C  
ATOM    986  CD2 PHE A  61     -15.923   3.283  -1.312  1.00  0.00           C  
ATOM    987  CE1 PHE A  61     -14.845   2.227   0.990  1.00  0.00           C  
ATOM    988  CE2 PHE A  61     -14.716   2.533  -1.343  1.00  0.00           C  
ATOM    989  CZ  PHE A  61     -14.203   2.021  -0.192  1.00  0.00           C  
ATOM    990  H   PHE A  61     -15.785   5.321   1.110  1.00  0.00           H  
ATOM    991  HA  PHE A  61     -18.528   6.260   0.640  1.00  0.00           H  
ATOM    992  HB2 PHE A  61     -18.689   3.626   0.139  1.00  0.00           H  
ATOM    993  HB3 PHE A  61     -18.054   4.700  -1.091  1.00  0.00           H  
ATOM    994  HD1 PHE A  61     -16.565   3.142   1.967  1.00  0.00           H  
ATOM    995  HD2 PHE A  61     -16.334   3.692  -2.234  1.00  0.00           H  
ATOM    996  HE1 PHE A  61     -14.434   1.817   1.912  1.00  0.00           H  
ATOM    997  HE2 PHE A  61     -14.202   2.368  -2.290  1.00  0.00           H  
ATOM    998  HZ  PHE A  61     -13.278   1.446  -0.216  1.00  0.00           H  
ATOM    999  N   VAL A  62     -19.289   4.090   2.296  1.00  0.00           N  
ATOM   1000  CA  VAL A  62     -19.770   3.502   3.534  1.00  0.00           C  
ATOM   1001  C   VAL A  62     -19.637   1.979   3.454  1.00  0.00           C  
ATOM   1002  O   VAL A  62     -19.946   1.378   2.427  1.00  0.00           O  
ATOM   1003  CB  VAL A  62     -21.203   3.962   3.811  1.00  0.00           C  
ATOM   1004  CG1 VAL A  62     -21.706   3.415   5.148  1.00  0.00           C  
ATOM   1005  CG2 VAL A  62     -21.306   5.487   3.768  1.00  0.00           C  
ATOM   1006  H   VAL A  62     -19.803   3.834   1.478  1.00  0.00           H  
ATOM   1007  HA  VAL A  62     -19.136   3.868   4.341  1.00  0.00           H  
ATOM   1008  HB  VAL A  62     -21.842   3.561   3.024  1.00  0.00           H  
ATOM   1009 HG11 VAL A  62     -21.104   2.553   5.438  1.00  0.00           H  
ATOM   1010 HG12 VAL A  62     -21.622   4.189   5.912  1.00  0.00           H  
ATOM   1011 HG13 VAL A  62     -22.749   3.114   5.049  1.00  0.00           H  
ATOM   1012 HG21 VAL A  62     -20.356   5.925   4.074  1.00  0.00           H  
ATOM   1013 HG22 VAL A  62     -21.543   5.808   2.753  1.00  0.00           H  
ATOM   1014 HG23 VAL A  62     -22.092   5.818   4.446  1.00  0.00           H  
ATOM   1015  N   LYS A  63     -19.175   1.400   4.553  1.00  0.00           N  
ATOM   1016  CA  LYS A  63     -18.996  -0.041   4.621  1.00  0.00           C  
ATOM   1017  C   LYS A  63     -19.814  -0.597   5.789  1.00  0.00           C  
ATOM   1018  O   LYS A  63     -20.324   0.161   6.610  1.00  0.00           O  
ATOM   1019  CB  LYS A  63     -17.510  -0.394   4.687  1.00  0.00           C  
ATOM   1020  CG  LYS A  63     -16.671   0.616   3.902  1.00  0.00           C  
ATOM   1021  CD  LYS A  63     -15.547   1.187   4.769  1.00  0.00           C  
ATOM   1022  CE  LYS A  63     -15.699   2.699   4.939  1.00  0.00           C  
ATOM   1023  NZ  LYS A  63     -16.794   3.007   5.887  1.00  0.00           N  
ATOM   1024  H   LYS A  63     -18.925   1.896   5.385  1.00  0.00           H  
ATOM   1025  HA  LYS A  63     -19.387  -0.462   3.694  1.00  0.00           H  
ATOM   1026  HB2 LYS A  63     -17.183  -0.413   5.726  1.00  0.00           H  
ATOM   1027  HB3 LYS A  63     -17.351  -1.395   4.285  1.00  0.00           H  
ATOM   1028  HG2 LYS A  63     -16.247   0.135   3.020  1.00  0.00           H  
ATOM   1029  HG3 LYS A  63     -17.308   1.426   3.547  1.00  0.00           H  
ATOM   1030  HD2 LYS A  63     -15.556   0.705   5.747  1.00  0.00           H  
ATOM   1031  HD3 LYS A  63     -14.582   0.964   4.313  1.00  0.00           H  
ATOM   1032  HE2 LYS A  63     -14.764   3.127   5.303  1.00  0.00           H  
ATOM   1033  HE3 LYS A  63     -15.905   3.160   3.973  1.00  0.00           H  
ATOM   1034  HZ1 LYS A  63     -17.057   2.174   6.373  1.00  0.00           H  
ATOM   1035  HZ2 LYS A  63     -16.483   3.694   6.543  1.00  0.00           H  
ATOM   1036  HZ3 LYS A  63     -17.582   3.361   5.382  1.00  0.00           H  
ATOM   1037  N   ILE A  64     -19.912  -1.918   5.824  1.00  0.00           N  
ATOM   1038  CA  ILE A  64     -20.658  -2.585   6.877  1.00  0.00           C  
ATOM   1039  C   ILE A  64     -19.713  -3.486   7.675  1.00  0.00           C  
ATOM   1040  O   ILE A  64     -19.079  -4.378   7.113  1.00  0.00           O  
ATOM   1041  CB  ILE A  64     -21.865  -3.323   6.293  1.00  0.00           C  
ATOM   1042  CG1 ILE A  64     -21.422  -4.545   5.486  1.00  0.00           C  
ATOM   1043  CG2 ILE A  64     -22.741  -2.378   5.470  1.00  0.00           C  
ATOM   1044  CD1 ILE A  64     -21.968  -5.836   6.099  1.00  0.00           C  
ATOM   1045  H   ILE A  64     -19.493  -2.528   5.151  1.00  0.00           H  
ATOM   1046  HA  ILE A  64     -21.044  -1.813   7.543  1.00  0.00           H  
ATOM   1047  HB  ILE A  64     -22.474  -3.688   7.120  1.00  0.00           H  
ATOM   1048 HG12 ILE A  64     -21.771  -4.450   4.457  1.00  0.00           H  
ATOM   1049 HG13 ILE A  64     -20.334  -4.586   5.450  1.00  0.00           H  
ATOM   1050 HG21 ILE A  64     -23.093  -1.564   6.104  1.00  0.00           H  
ATOM   1051 HG22 ILE A  64     -22.158  -1.969   4.644  1.00  0.00           H  
ATOM   1052 HG23 ILE A  64     -23.596  -2.926   5.074  1.00  0.00           H  
ATOM   1053 HD11 ILE A  64     -22.215  -5.664   7.146  1.00  0.00           H  
ATOM   1054 HD12 ILE A  64     -22.864  -6.143   5.560  1.00  0.00           H  
ATOM   1055 HD13 ILE A  64     -21.214  -6.619   6.027  1.00  0.00           H  
ATOM   1056  N   PRO A  65     -19.646  -3.213   9.005  1.00  0.00           N  
ATOM   1057  CA  PRO A  65     -18.789  -3.989   9.886  1.00  0.00           C  
ATOM   1058  C   PRO A  65     -19.391  -5.368  10.162  1.00  0.00           C  
ATOM   1059  O   PRO A  65     -20.392  -5.745   9.556  1.00  0.00           O  
ATOM   1060  CB  PRO A  65     -18.644  -3.142  11.140  1.00  0.00           C  
ATOM   1061  CG  PRO A  65     -19.791  -2.145  11.105  1.00  0.00           C  
ATOM   1062  CD  PRO A  65     -20.383  -2.165   9.705  1.00  0.00           C  
ATOM   1063  HA  PRO A  65     -17.905  -4.159   9.448  1.00  0.00           H  
ATOM   1064  HB2 PRO A  65     -18.689  -3.760  12.036  1.00  0.00           H  
ATOM   1065  HB3 PRO A  65     -17.681  -2.630  11.155  1.00  0.00           H  
ATOM   1066  HG2 PRO A  65     -20.548  -2.410  11.843  1.00  0.00           H  
ATOM   1067  HG3 PRO A  65     -19.436  -1.146  11.355  1.00  0.00           H  
ATOM   1068  HD2 PRO A  65     -21.451  -2.380   9.729  1.00  0.00           H  
ATOM   1069  HD3 PRO A  65     -20.263  -1.200   9.212  1.00  0.00           H  
ATOM   1070  N   ARG A  66     -18.755  -6.083  11.079  1.00  0.00           N  
ATOM   1071  CA  ARG A  66     -19.215  -7.412  11.443  1.00  0.00           C  
ATOM   1072  C   ARG A  66     -20.742  -7.438  11.536  1.00  0.00           C  
ATOM   1073  O   ARG A  66     -21.315  -6.995  12.530  1.00  0.00           O  
ATOM   1074  CB  ARG A  66     -18.622  -7.852  12.783  1.00  0.00           C  
ATOM   1075  CG  ARG A  66     -19.153  -9.228  13.192  1.00  0.00           C  
ATOM   1076  CD  ARG A  66     -18.548 -10.330  12.321  1.00  0.00           C  
ATOM   1077  NE  ARG A  66     -18.282 -11.534  13.139  1.00  0.00           N  
ATOM   1078  CZ  ARG A  66     -18.809 -12.741  12.896  1.00  0.00           C  
ATOM   1079  NH1 ARG A  66     -19.637 -12.913  11.856  1.00  0.00           N  
ATOM   1080  NH2 ARG A  66     -18.511 -13.776  13.692  1.00  0.00           N  
ATOM   1081  H   ARG A  66     -17.941  -5.769  11.567  1.00  0.00           H  
ATOM   1082  HA  ARG A  66     -18.861  -8.060  10.641  1.00  0.00           H  
ATOM   1083  HB2 ARG A  66     -17.535  -7.885  12.711  1.00  0.00           H  
ATOM   1084  HB3 ARG A  66     -18.868  -7.120  13.552  1.00  0.00           H  
ATOM   1085  HG2 ARG A  66     -18.915  -9.416  14.240  1.00  0.00           H  
ATOM   1086  HG3 ARG A  66     -20.239  -9.243  13.104  1.00  0.00           H  
ATOM   1087  HD2 ARG A  66     -19.231 -10.578  11.507  1.00  0.00           H  
ATOM   1088  HD3 ARG A  66     -17.623  -9.979  11.864  1.00  0.00           H  
ATOM   1089  HE  ARG A  66     -17.668 -11.441  13.924  1.00  0.00           H  
ATOM   1090 HH11 ARG A  66     -19.860 -12.140  11.262  1.00  0.00           H  
ATOM   1091 HH12 ARG A  66     -20.032 -13.814  11.674  1.00  0.00           H  
ATOM   1092 HH21 ARG A  66     -17.893 -13.649  14.469  1.00  0.00           H  
ATOM   1093 HH22 ARG A  66     -18.906 -14.677  13.511  1.00  0.00           H  
ATOM   1094  N   GLU A  67     -21.358  -7.963  10.487  1.00  0.00           N  
ATOM   1095  CA  GLU A  67     -22.808  -8.053  10.437  1.00  0.00           C  
ATOM   1096  C   GLU A  67     -23.257  -9.503  10.634  1.00  0.00           C  
ATOM   1097  O   GLU A  67     -22.438 -10.420  10.603  1.00  0.00           O  
ATOM   1098  CB  GLU A  67     -23.348  -7.485   9.124  1.00  0.00           C  
ATOM   1099  CG  GLU A  67     -24.036  -6.137   9.350  1.00  0.00           C  
ATOM   1100  CD  GLU A  67     -25.125  -5.895   8.304  1.00  0.00           C  
ATOM   1101  OE1 GLU A  67     -25.108  -6.623   7.288  1.00  0.00           O  
ATOM   1102  OE2 GLU A  67     -25.950  -4.988   8.544  1.00  0.00           O  
ATOM   1103  H   GLU A  67     -20.885  -8.322   9.683  1.00  0.00           H  
ATOM   1104  HA  GLU A  67     -23.163  -7.439  11.265  1.00  0.00           H  
ATOM   1105  HB2 GLU A  67     -22.531  -7.366   8.412  1.00  0.00           H  
ATOM   1106  HB3 GLU A  67     -24.055  -8.188   8.683  1.00  0.00           H  
ATOM   1107  HG2 GLU A  67     -24.472  -6.111  10.348  1.00  0.00           H  
ATOM   1108  HG3 GLU A  67     -23.297  -5.336   9.304  1.00  0.00           H  
ATOM   1109  N   PRO A  68     -24.591  -9.668  10.837  1.00  0.00           N  
ATOM   1110  CA  PRO A  68     -25.159 -10.990  11.040  1.00  0.00           C  
ATOM   1111  C   PRO A  68     -25.228 -11.764   9.722  1.00  0.00           C  
ATOM   1112  O   PRO A  68     -26.297 -12.225   9.324  1.00  0.00           O  
ATOM   1113  CB  PRO A  68     -26.527 -10.741  11.655  1.00  0.00           C  
ATOM   1114  CG  PRO A  68     -26.864  -9.291  11.348  1.00  0.00           C  
ATOM   1115  CD  PRO A  68     -25.591  -8.605  10.882  1.00  0.00           C  
ATOM   1116  HA  PRO A  68     -24.573 -11.531  11.644  1.00  0.00           H  
ATOM   1117  HB2 PRO A  68     -27.273 -11.415  11.234  1.00  0.00           H  
ATOM   1118  HB3 PRO A  68     -26.509 -10.919  12.731  1.00  0.00           H  
ATOM   1119  HG2 PRO A  68     -27.634  -9.234  10.578  1.00  0.00           H  
ATOM   1120  HG3 PRO A  68     -27.261  -8.796  12.234  1.00  0.00           H  
ATOM   1121  HD2 PRO A  68     -25.725  -8.147   9.900  1.00  0.00           H  
ATOM   1122  HD3 PRO A  68     -25.295  -7.811  11.567  1.00  0.00           H  
ATOM   1123  N   GLY A  69     -24.075 -11.882   9.081  1.00  0.00           N  
ATOM   1124  CA  GLY A  69     -23.992 -12.593   7.815  1.00  0.00           C  
ATOM   1125  C   GLY A  69     -22.582 -12.500   7.227  1.00  0.00           C  
ATOM   1126  O   GLY A  69     -22.420 -12.271   6.030  1.00  0.00           O  
ATOM   1127  H   GLY A  69     -23.210 -11.504   9.410  1.00  0.00           H  
ATOM   1128  HA2 GLY A  69     -24.261 -13.638   7.964  1.00  0.00           H  
ATOM   1129  HA3 GLY A  69     -24.712 -12.175   7.112  1.00  0.00           H  
ATOM   1130  N   ASN A  70     -21.600 -12.685   8.097  1.00  0.00           N  
ATOM   1131  CA  ASN A  70     -20.210 -12.626   7.677  1.00  0.00           C  
ATOM   1132  C   ASN A  70     -19.446 -13.801   8.291  1.00  0.00           C  
ATOM   1133  O   ASN A  70     -18.542 -13.604   9.100  1.00  0.00           O  
ATOM   1134  CB  ASN A  70     -19.546 -11.331   8.153  1.00  0.00           C  
ATOM   1135  CG  ASN A  70     -20.508 -10.148   8.037  1.00  0.00           C  
ATOM   1136  OD1 ASN A  70     -21.686 -10.240   8.341  1.00  0.00           O  
ATOM   1137  ND2 ASN A  70     -19.943  -9.034   7.582  1.00  0.00           N  
ATOM   1138  H   ASN A  70     -21.740 -12.871   9.068  1.00  0.00           H  
ATOM   1139  HA  ASN A  70     -20.236 -12.669   6.589  1.00  0.00           H  
ATOM   1140  HB2 ASN A  70     -19.222 -11.443   9.187  1.00  0.00           H  
ATOM   1141  HB3 ASN A  70     -18.653 -11.137   7.558  1.00  0.00           H  
ATOM   1142 HD21 ASN A  70     -18.970  -9.025   7.350  1.00  0.00           H  
ATOM   1143 HD22 ASN A  70     -20.491  -8.204   7.471  1.00  0.00           H  
ATOM   1144  N   PRO A  71     -19.850 -15.031   7.872  1.00  0.00           N  
ATOM   1145  CA  PRO A  71     -19.214 -16.237   8.371  1.00  0.00           C  
ATOM   1146  C   PRO A  71     -17.836 -16.435   7.735  1.00  0.00           C  
ATOM   1147  O   PRO A  71     -17.685 -17.224   6.804  1.00  0.00           O  
ATOM   1148  CB  PRO A  71     -20.186 -17.359   8.042  1.00  0.00           C  
ATOM   1149  CG  PRO A  71     -21.107 -16.810   6.964  1.00  0.00           C  
ATOM   1150  CD  PRO A  71     -20.917 -15.302   6.914  1.00  0.00           C  
ATOM   1151  HA  PRO A  71     -19.052 -16.163   9.355  1.00  0.00           H  
ATOM   1152  HB2 PRO A  71     -19.656 -18.244   7.689  1.00  0.00           H  
ATOM   1153  HB3 PRO A  71     -20.751 -17.657   8.924  1.00  0.00           H  
ATOM   1154  HG2 PRO A  71     -20.874 -17.257   5.998  1.00  0.00           H  
ATOM   1155  HG3 PRO A  71     -22.145 -17.057   7.187  1.00  0.00           H  
ATOM   1156  HD2 PRO A  71     -20.646 -14.970   5.912  1.00  0.00           H  
ATOM   1157  HD3 PRO A  71     -21.835 -14.779   7.185  1.00  0.00           H  
ATOM   1158  N   GLY A  72     -16.866 -15.703   8.264  1.00  0.00           N  
ATOM   1159  CA  GLY A  72     -15.506 -15.788   7.760  1.00  0.00           C  
ATOM   1160  C   GLY A  72     -15.104 -14.495   7.046  1.00  0.00           C  
ATOM   1161  O   GLY A  72     -14.418 -13.652   7.622  1.00  0.00           O  
ATOM   1162  H   GLY A  72     -16.997 -15.064   9.021  1.00  0.00           H  
ATOM   1163  HA2 GLY A  72     -14.820 -15.981   8.584  1.00  0.00           H  
ATOM   1164  HA3 GLY A  72     -15.421 -16.628   7.071  1.00  0.00           H  
ATOM   1165  N   LYS A  73     -15.548 -14.380   5.804  1.00  0.00           N  
ATOM   1166  CA  LYS A  73     -15.243 -13.205   5.005  1.00  0.00           C  
ATOM   1167  C   LYS A  73     -16.469 -12.827   4.171  1.00  0.00           C  
ATOM   1168  O   LYS A  73     -16.379 -12.699   2.952  1.00  0.00           O  
ATOM   1169  CB  LYS A  73     -13.980 -13.435   4.174  1.00  0.00           C  
ATOM   1170  CG  LYS A  73     -14.161 -14.615   3.217  1.00  0.00           C  
ATOM   1171  CD  LYS A  73     -12.906 -15.489   3.182  1.00  0.00           C  
ATOM   1172  CE  LYS A  73     -12.956 -16.566   4.267  1.00  0.00           C  
ATOM   1173  NZ  LYS A  73     -11.667 -16.635   4.990  1.00  0.00           N  
ATOM   1174  H   LYS A  73     -16.105 -15.071   5.342  1.00  0.00           H  
ATOM   1175  HA  LYS A  73     -15.030 -12.388   5.696  1.00  0.00           H  
ATOM   1176  HB2 LYS A  73     -13.745 -12.535   3.606  1.00  0.00           H  
ATOM   1177  HB3 LYS A  73     -13.135 -13.624   4.834  1.00  0.00           H  
ATOM   1178  HG2 LYS A  73     -15.016 -15.213   3.531  1.00  0.00           H  
ATOM   1179  HG3 LYS A  73     -14.380 -14.246   2.215  1.00  0.00           H  
ATOM   1180  HD2 LYS A  73     -12.813 -15.959   2.202  1.00  0.00           H  
ATOM   1181  HD3 LYS A  73     -12.021 -14.868   3.322  1.00  0.00           H  
ATOM   1182  HE2 LYS A  73     -13.762 -16.347   4.968  1.00  0.00           H  
ATOM   1183  HE3 LYS A  73     -13.179 -17.534   3.817  1.00  0.00           H  
ATOM   1184  HZ1 LYS A  73     -11.012 -16.012   4.562  1.00  0.00           H  
ATOM   1185  HZ2 LYS A  73     -11.805 -16.370   5.944  1.00  0.00           H  
ATOM   1186  HZ3 LYS A  73     -11.312 -17.570   4.951  1.00  0.00           H  
ATOM   1187  N   GLY A  74     -17.587 -12.661   4.863  1.00  0.00           N  
ATOM   1188  CA  GLY A  74     -18.829 -12.301   4.202  1.00  0.00           C  
ATOM   1189  C   GLY A  74     -19.325 -10.932   4.673  1.00  0.00           C  
ATOM   1190  O   GLY A  74     -20.246 -10.847   5.484  1.00  0.00           O  
ATOM   1191  H   GLY A  74     -17.651 -12.767   5.856  1.00  0.00           H  
ATOM   1192  HA2 GLY A  74     -18.679 -12.285   3.122  1.00  0.00           H  
ATOM   1193  HA3 GLY A  74     -19.587 -13.057   4.407  1.00  0.00           H  
ATOM   1194  N   ASN A  75     -18.692  -9.895   4.144  1.00  0.00           N  
ATOM   1195  CA  ASN A  75     -19.057  -8.535   4.501  1.00  0.00           C  
ATOM   1196  C   ASN A  75     -19.689  -7.846   3.289  1.00  0.00           C  
ATOM   1197  O   ASN A  75     -19.910  -8.479   2.257  1.00  0.00           O  
ATOM   1198  CB  ASN A  75     -17.828  -7.725   4.916  1.00  0.00           C  
ATOM   1199  CG  ASN A  75     -16.699  -7.879   3.896  1.00  0.00           C  
ATOM   1200  OD1 ASN A  75     -16.264  -8.973   3.573  1.00  0.00           O  
ATOM   1201  ND2 ASN A  75     -16.251  -6.727   3.407  1.00  0.00           N  
ATOM   1202  H   ASN A  75     -17.944  -9.973   3.485  1.00  0.00           H  
ATOM   1203  HA  ASN A  75     -19.754  -8.634   5.334  1.00  0.00           H  
ATOM   1204  HB2 ASN A  75     -18.095  -6.673   5.012  1.00  0.00           H  
ATOM   1205  HB3 ASN A  75     -17.485  -8.057   5.897  1.00  0.00           H  
ATOM   1206 HD21 ASN A  75     -16.651  -5.863   3.714  1.00  0.00           H  
ATOM   1207 HD22 ASN A  75     -15.511  -6.723   2.732  1.00  0.00           H  
ATOM   1208  N   TYR A  76     -19.962  -6.561   3.454  1.00  0.00           N  
ATOM   1209  CA  TYR A  76     -20.564  -5.780   2.387  1.00  0.00           C  
ATOM   1210  C   TYR A  76     -20.053  -4.338   2.407  1.00  0.00           C  
ATOM   1211  O   TYR A  76     -19.961  -3.723   3.469  1.00  0.00           O  
ATOM   1212  CB  TYR A  76     -22.069  -5.779   2.662  1.00  0.00           C  
ATOM   1213  CG  TYR A  76     -22.863  -6.746   1.781  1.00  0.00           C  
ATOM   1214  CD1 TYR A  76     -23.324  -6.337   0.547  1.00  0.00           C  
ATOM   1215  CD2 TYR A  76     -23.117  -8.030   2.221  1.00  0.00           C  
ATOM   1216  CE1 TYR A  76     -24.071  -7.247  -0.281  1.00  0.00           C  
ATOM   1217  CE2 TYR A  76     -23.864  -8.940   1.393  1.00  0.00           C  
ATOM   1218  CZ  TYR A  76     -24.305  -8.504   0.182  1.00  0.00           C  
ATOM   1219  OH  TYR A  76     -25.010  -9.364  -0.601  1.00  0.00           O  
ATOM   1220  H   TYR A  76     -19.779  -6.054   4.298  1.00  0.00           H  
ATOM   1221  HA  TYR A  76     -20.290  -6.241   1.438  1.00  0.00           H  
ATOM   1222  HB2 TYR A  76     -22.238  -6.035   3.708  1.00  0.00           H  
ATOM   1223  HB3 TYR A  76     -22.454  -4.770   2.515  1.00  0.00           H  
ATOM   1224  HD1 TYR A  76     -23.123  -5.322   0.199  1.00  0.00           H  
ATOM   1225  HD2 TYR A  76     -22.752  -8.354   3.196  1.00  0.00           H  
ATOM   1226  HE1 TYR A  76     -24.441  -6.935  -1.258  1.00  0.00           H  
ATOM   1227  HE2 TYR A  76     -24.072  -9.956   1.728  1.00  0.00           H  
ATOM   1228  HH  TYR A  76     -24.386  -9.894  -1.174  1.00  0.00           H  
ATOM   1229  N   TRP A  77     -19.735  -3.840   1.221  1.00  0.00           N  
ATOM   1230  CA  TRP A  77     -19.236  -2.482   1.090  1.00  0.00           C  
ATOM   1231  C   TRP A  77     -20.117  -1.750   0.075  1.00  0.00           C  
ATOM   1232  O   TRP A  77     -20.354  -2.252  -1.022  1.00  0.00           O  
ATOM   1233  CB  TRP A  77     -17.755  -2.476   0.707  1.00  0.00           C  
ATOM   1234  CG  TRP A  77     -16.806  -2.674   1.891  1.00  0.00           C  
ATOM   1235  CD1 TRP A  77     -16.923  -3.540   2.907  1.00  0.00           C  
ATOM   1236  CD2 TRP A  77     -15.581  -1.952   2.143  1.00  0.00           C  
ATOM   1237  NE1 TRP A  77     -15.870  -3.429   3.791  1.00  0.00           N  
ATOM   1238  CE2 TRP A  77     -15.028  -2.433   3.312  1.00  0.00           C  
ATOM   1239  CE3 TRP A  77     -14.963  -0.926   1.406  1.00  0.00           C  
ATOM   1240  CZ2 TRP A  77     -13.828  -1.948   3.847  1.00  0.00           C  
ATOM   1241  CZ3 TRP A  77     -13.766  -0.453   1.956  1.00  0.00           C  
ATOM   1242  CH2 TRP A  77     -13.195  -0.926   3.131  1.00  0.00           C  
ATOM   1243  H   TRP A  77     -19.813  -4.346   0.363  1.00  0.00           H  
ATOM   1244  HA  TRP A  77     -19.314  -2.002   2.065  1.00  0.00           H  
ATOM   1245  HB2 TRP A  77     -17.575  -3.264  -0.024  1.00  0.00           H  
ATOM   1246  HB3 TRP A  77     -17.519  -1.529   0.221  1.00  0.00           H  
ATOM   1247  HD1 TRP A  77     -17.748  -4.244   3.022  1.00  0.00           H  
ATOM   1248  HE1 TRP A  77     -15.724  -4.016   4.698  1.00  0.00           H  
ATOM   1249  HE3 TRP A  77     -15.381  -0.529   0.481  1.00  0.00           H  
ATOM   1250  HZ2 TRP A  77     -13.411  -2.346   4.773  1.00  0.00           H  
ATOM   1251  HZ3 TRP A  77     -13.245   0.344   1.423  1.00  0.00           H  
ATOM   1252  HH2 TRP A  77     -12.257  -0.503   3.493  1.00  0.00           H  
ATOM   1253  N   THR A  78     -20.580  -0.576   0.480  1.00  0.00           N  
ATOM   1254  CA  THR A  78     -21.430   0.228  -0.380  1.00  0.00           C  
ATOM   1255  C   THR A  78     -20.776   1.584  -0.660  1.00  0.00           C  
ATOM   1256  O   THR A  78     -20.334   2.266   0.263  1.00  0.00           O  
ATOM   1257  CB  THR A  78     -22.804   0.344   0.286  1.00  0.00           C  
ATOM   1258  OG1 THR A  78     -23.152  -1.003   0.596  1.00  0.00           O  
ATOM   1259  CG2 THR A  78     -23.892   0.794  -0.691  1.00  0.00           C  
ATOM   1260  H   THR A  78     -20.383  -0.175   1.374  1.00  0.00           H  
ATOM   1261  HA  THR A  78     -21.532  -0.281  -1.338  1.00  0.00           H  
ATOM   1262  HB  THR A  78     -22.761   1.002   1.153  1.00  0.00           H  
ATOM   1263  HG1 THR A  78     -23.114  -1.565  -0.230  1.00  0.00           H  
ATOM   1264 HG21 THR A  78     -23.499   0.775  -1.708  1.00  0.00           H  
ATOM   1265 HG22 THR A  78     -24.746   0.121  -0.619  1.00  0.00           H  
ATOM   1266 HG23 THR A  78     -24.206   1.807  -0.442  1.00  0.00           H  
ATOM   1267  N   LEU A  79     -20.735   1.933  -1.938  1.00  0.00           N  
ATOM   1268  CA  LEU A  79     -20.143   3.193  -2.351  1.00  0.00           C  
ATOM   1269  C   LEU A  79     -21.210   4.058  -3.022  1.00  0.00           C  
ATOM   1270  O   LEU A  79     -22.094   3.541  -3.704  1.00  0.00           O  
ATOM   1271  CB  LEU A  79     -18.912   2.945  -3.226  1.00  0.00           C  
ATOM   1272  CG  LEU A  79     -18.563   4.054  -4.222  1.00  0.00           C  
ATOM   1273  CD1 LEU A  79     -17.074   4.024  -4.575  1.00  0.00           C  
ATOM   1274  CD2 LEU A  79     -19.450   3.974  -5.466  1.00  0.00           C  
ATOM   1275  H   LEU A  79     -21.097   1.372  -2.683  1.00  0.00           H  
ATOM   1276  HA  LEU A  79     -19.800   3.704  -1.450  1.00  0.00           H  
ATOM   1277  HB2 LEU A  79     -18.053   2.785  -2.574  1.00  0.00           H  
ATOM   1278  HB3 LEU A  79     -19.067   2.020  -3.782  1.00  0.00           H  
ATOM   1279  HG  LEU A  79     -18.761   5.014  -3.746  1.00  0.00           H  
ATOM   1280 HD11 LEU A  79     -16.604   3.166  -4.094  1.00  0.00           H  
ATOM   1281 HD12 LEU A  79     -16.960   3.942  -5.656  1.00  0.00           H  
ATOM   1282 HD13 LEU A  79     -16.601   4.941  -4.227  1.00  0.00           H  
ATOM   1283 HD21 LEU A  79     -19.475   2.946  -5.827  1.00  0.00           H  
ATOM   1284 HD22 LEU A  79     -20.460   4.294  -5.213  1.00  0.00           H  
ATOM   1285 HD23 LEU A  79     -19.045   4.623  -6.242  1.00  0.00           H  
ATOM   1286  N   ASP A  80     -21.095   5.360  -2.805  1.00  0.00           N  
ATOM   1287  CA  ASP A  80     -22.040   6.302  -3.380  1.00  0.00           C  
ATOM   1288  C   ASP A  80     -21.530   6.758  -4.748  1.00  0.00           C  
ATOM   1289  O   ASP A  80     -20.393   6.468  -5.119  1.00  0.00           O  
ATOM   1290  CB  ASP A  80     -22.190   7.541  -2.495  1.00  0.00           C  
ATOM   1291  CG  ASP A  80     -23.610   7.807  -1.992  1.00  0.00           C  
ATOM   1292  OD1 ASP A  80     -24.322   6.809  -1.746  1.00  0.00           O  
ATOM   1293  OD2 ASP A  80     -23.953   9.002  -1.863  1.00  0.00           O  
ATOM   1294  H   ASP A  80     -20.373   5.772  -2.248  1.00  0.00           H  
ATOM   1295  HA  ASP A  80     -22.982   5.758  -3.446  1.00  0.00           H  
ATOM   1296  HB2 ASP A  80     -21.529   7.437  -1.634  1.00  0.00           H  
ATOM   1297  HB3 ASP A  80     -21.850   8.412  -3.054  1.00  0.00           H  
ATOM   1298  N   PRO A  81     -22.418   7.482  -5.481  1.00  0.00           N  
ATOM   1299  CA  PRO A  81     -22.069   7.981  -6.800  1.00  0.00           C  
ATOM   1300  C   PRO A  81     -21.121   9.178  -6.701  1.00  0.00           C  
ATOM   1301  O   PRO A  81     -21.488  10.297  -7.058  1.00  0.00           O  
ATOM   1302  CB  PRO A  81     -23.397   8.327  -7.454  1.00  0.00           C  
ATOM   1303  CG  PRO A  81     -24.401   8.449  -6.319  1.00  0.00           C  
ATOM   1304  CD  PRO A  81     -23.772   7.844  -5.074  1.00  0.00           C  
ATOM   1305  HA  PRO A  81     -21.573   7.282  -7.315  1.00  0.00           H  
ATOM   1306  HB2 PRO A  81     -23.325   9.259  -8.013  1.00  0.00           H  
ATOM   1307  HB3 PRO A  81     -23.697   7.554  -8.160  1.00  0.00           H  
ATOM   1308  HG2 PRO A  81     -24.658   9.494  -6.148  1.00  0.00           H  
ATOM   1309  HG3 PRO A  81     -25.325   7.929  -6.570  1.00  0.00           H  
ATOM   1310  HD2 PRO A  81     -23.761   8.557  -4.249  1.00  0.00           H  
ATOM   1311  HD3 PRO A  81     -24.329   6.972  -4.732  1.00  0.00           H  
ATOM   1312  N   GLN A  82     -19.920   8.903  -6.215  1.00  0.00           N  
ATOM   1313  CA  GLN A  82     -18.917   9.943  -6.064  1.00  0.00           C  
ATOM   1314  C   GLN A  82     -17.588   9.491  -6.674  1.00  0.00           C  
ATOM   1315  O   GLN A  82     -16.923  10.263  -7.363  1.00  0.00           O  
ATOM   1316  CB  GLN A  82     -18.743  10.328  -4.594  1.00  0.00           C  
ATOM   1317  CG  GLN A  82     -18.913  11.837  -4.399  1.00  0.00           C  
ATOM   1318  CD  GLN A  82     -19.470  12.150  -3.009  1.00  0.00           C  
ATOM   1319  OE1 GLN A  82     -20.610  11.855  -2.688  1.00  0.00           O  
ATOM   1320  NE2 GLN A  82     -18.607  12.764  -2.205  1.00  0.00           N  
ATOM   1321  H   GLN A  82     -19.629   7.991  -5.927  1.00  0.00           H  
ATOM   1322  HA  GLN A  82     -19.304  10.801  -6.615  1.00  0.00           H  
ATOM   1323  HB2 GLN A  82     -19.474   9.795  -3.986  1.00  0.00           H  
ATOM   1324  HB3 GLN A  82     -17.756  10.022  -4.247  1.00  0.00           H  
ATOM   1325  HG2 GLN A  82     -17.951  12.334  -4.529  1.00  0.00           H  
ATOM   1326  HG3 GLN A  82     -19.583  12.232  -5.162  1.00  0.00           H  
ATOM   1327 HE21 GLN A  82     -17.686  12.978  -2.531  1.00  0.00           H  
ATOM   1328 HE22 GLN A  82     -18.878  13.012  -1.275  1.00  0.00           H  
ATOM   1329  N   SER A  83     -17.240   8.243  -6.396  1.00  0.00           N  
ATOM   1330  CA  SER A  83     -16.003   7.680  -6.908  1.00  0.00           C  
ATOM   1331  C   SER A  83     -15.954   7.821  -8.431  1.00  0.00           C  
ATOM   1332  O   SER A  83     -14.998   8.369  -8.976  1.00  0.00           O  
ATOM   1333  CB  SER A  83     -15.859   6.210  -6.506  1.00  0.00           C  
ATOM   1334  OG  SER A  83     -14.866   5.541  -7.279  1.00  0.00           O  
ATOM   1335  H   SER A  83     -17.787   7.623  -5.834  1.00  0.00           H  
ATOM   1336  HA  SER A  83     -15.207   8.263  -6.444  1.00  0.00           H  
ATOM   1337  HB2 SER A  83     -15.600   6.147  -5.449  1.00  0.00           H  
ATOM   1338  HB3 SER A  83     -16.817   5.705  -6.631  1.00  0.00           H  
ATOM   1339  HG  SER A  83     -14.137   6.179  -7.527  1.00  0.00           H  
ATOM   1340  N   GLU A  84     -16.998   7.317  -9.073  1.00  0.00           N  
ATOM   1341  CA  GLU A  84     -17.086   7.380 -10.522  1.00  0.00           C  
ATOM   1342  C   GLU A  84     -17.171   8.836 -10.987  1.00  0.00           C  
ATOM   1343  O   GLU A  84     -16.939   9.133 -12.157  1.00  0.00           O  
ATOM   1344  CB  GLU A  84     -18.278   6.571 -11.035  1.00  0.00           C  
ATOM   1345  CG  GLU A  84     -19.596   7.143 -10.509  1.00  0.00           C  
ATOM   1346  CD  GLU A  84     -20.789   6.329 -11.016  1.00  0.00           C  
ATOM   1347  OE1 GLU A  84     -20.943   5.187 -10.530  1.00  0.00           O  
ATOM   1348  OE2 GLU A  84     -21.518   6.866 -11.876  1.00  0.00           O  
ATOM   1349  H   GLU A  84     -17.771   6.873  -8.622  1.00  0.00           H  
ATOM   1350  HA  GLU A  84     -16.163   6.929 -10.889  1.00  0.00           H  
ATOM   1351  HB2 GLU A  84     -18.284   6.576 -12.125  1.00  0.00           H  
ATOM   1352  HB3 GLU A  84     -18.179   5.532 -10.722  1.00  0.00           H  
ATOM   1353  HG2 GLU A  84     -19.588   7.143  -9.419  1.00  0.00           H  
ATOM   1354  HG3 GLU A  84     -19.698   8.181 -10.828  1.00  0.00           H  
ATOM   1355  N   ASP A  85     -17.504   9.705 -10.043  1.00  0.00           N  
ATOM   1356  CA  ASP A  85     -17.623  11.122 -10.341  1.00  0.00           C  
ATOM   1357  C   ASP A  85     -16.229  11.752 -10.368  1.00  0.00           C  
ATOM   1358  O   ASP A  85     -15.869  12.431 -11.329  1.00  0.00           O  
ATOM   1359  CB  ASP A  85     -18.446  11.842  -9.271  1.00  0.00           C  
ATOM   1360  CG  ASP A  85     -19.250  13.043  -9.773  1.00  0.00           C  
ATOM   1361  OD1 ASP A  85     -18.619  14.100  -9.989  1.00  0.00           O  
ATOM   1362  OD2 ASP A  85     -20.480  12.877  -9.930  1.00  0.00           O  
ATOM   1363  H   ASP A  85     -17.691   9.455  -9.093  1.00  0.00           H  
ATOM   1364  HA  ASP A  85     -18.121  11.171 -11.309  1.00  0.00           H  
ATOM   1365  HB2 ASP A  85     -19.133  11.127  -8.819  1.00  0.00           H  
ATOM   1366  HB3 ASP A  85     -17.774  12.179  -8.482  1.00  0.00           H  
ATOM   1367  N   MET A  86     -15.482  11.504  -9.302  1.00  0.00           N  
ATOM   1368  CA  MET A  86     -14.135  12.039  -9.192  1.00  0.00           C  
ATOM   1369  C   MET A  86     -13.208  11.410 -10.234  1.00  0.00           C  
ATOM   1370  O   MET A  86     -12.128  11.931 -10.505  1.00  0.00           O  
ATOM   1371  CB  MET A  86     -13.589  11.761  -7.790  1.00  0.00           C  
ATOM   1372  CG  MET A  86     -13.473  10.256  -7.535  1.00  0.00           C  
ATOM   1373  SD  MET A  86     -12.089   9.925  -6.457  1.00  0.00           S  
ATOM   1374  CE  MET A  86     -12.184   8.144  -6.370  1.00  0.00           C  
ATOM   1375  H   MET A  86     -15.782  10.951  -8.525  1.00  0.00           H  
ATOM   1376  HA  MET A  86     -14.229  13.109  -9.376  1.00  0.00           H  
ATOM   1377  HB2 MET A  86     -12.611  12.228  -7.678  1.00  0.00           H  
ATOM   1378  HB3 MET A  86     -14.245  12.210  -7.044  1.00  0.00           H  
ATOM   1379  HG2 MET A  86     -14.393   9.884  -7.085  1.00  0.00           H  
ATOM   1380  HG3 MET A  86     -13.343   9.728  -8.479  1.00  0.00           H  
ATOM   1381  HE1 MET A  86     -13.016   7.794  -6.982  1.00  0.00           H  
ATOM   1382  HE2 MET A  86     -11.253   7.713  -6.740  1.00  0.00           H  
ATOM   1383  HE3 MET A  86     -12.340   7.839  -5.335  1.00  0.00           H  
ATOM   1384  N   PHE A  87     -13.666  10.299 -10.793  1.00  0.00           N  
ATOM   1385  CA  PHE A  87     -12.892   9.594 -11.801  1.00  0.00           C  
ATOM   1386  C   PHE A  87     -13.222  10.108 -13.203  1.00  0.00           C  
ATOM   1387  O   PHE A  87     -12.326  10.495 -13.953  1.00  0.00           O  
ATOM   1388  CB  PHE A  87     -13.277   8.117 -11.707  1.00  0.00           C  
ATOM   1389  CG  PHE A  87     -12.091   7.178 -11.482  1.00  0.00           C  
ATOM   1390  CD1 PHE A  87     -11.221   7.413 -10.464  1.00  0.00           C  
ATOM   1391  CD2 PHE A  87     -11.906   6.107 -12.301  1.00  0.00           C  
ATOM   1392  CE1 PHE A  87     -10.119   6.542 -10.255  1.00  0.00           C  
ATOM   1393  CE2 PHE A  87     -10.805   5.235 -12.092  1.00  0.00           C  
ATOM   1394  CZ  PHE A  87      -9.934   5.471 -11.073  1.00  0.00           C  
ATOM   1395  H   PHE A  87     -14.547   9.882 -10.568  1.00  0.00           H  
ATOM   1396  HA  PHE A  87     -11.839   9.778 -11.587  1.00  0.00           H  
ATOM   1397  HB2 PHE A  87     -13.989   7.988 -10.893  1.00  0.00           H  
ATOM   1398  HB3 PHE A  87     -13.788   7.827 -12.626  1.00  0.00           H  
ATOM   1399  HD1 PHE A  87     -11.368   8.271  -9.808  1.00  0.00           H  
ATOM   1400  HD2 PHE A  87     -12.602   5.919 -13.117  1.00  0.00           H  
ATOM   1401  HE1 PHE A  87      -9.422   6.730  -9.439  1.00  0.00           H  
ATOM   1402  HE2 PHE A  87     -10.656   4.378 -12.748  1.00  0.00           H  
ATOM   1403  HZ  PHE A  87      -9.089   4.802 -10.913  1.00  0.00           H  
ATOM   1404  N   ASP A  88     -14.509  10.094 -13.517  1.00  0.00           N  
ATOM   1405  CA  ASP A  88     -14.968  10.553 -14.816  1.00  0.00           C  
ATOM   1406  C   ASP A  88     -14.370  11.931 -15.106  1.00  0.00           C  
ATOM   1407  O   ASP A  88     -13.926  12.197 -16.222  1.00  0.00           O  
ATOM   1408  CB  ASP A  88     -16.492  10.683 -14.849  1.00  0.00           C  
ATOM   1409  CG  ASP A  88     -17.204   9.712 -15.792  1.00  0.00           C  
ATOM   1410  OD1 ASP A  88     -16.558   8.712 -16.171  1.00  0.00           O  
ATOM   1411  OD2 ASP A  88     -18.380   9.992 -16.114  1.00  0.00           O  
ATOM   1412  H   ASP A  88     -15.230   9.777 -12.902  1.00  0.00           H  
ATOM   1413  HA  ASP A  88     -14.631   9.795 -15.524  1.00  0.00           H  
ATOM   1414  HB2 ASP A  88     -16.875  10.533 -13.840  1.00  0.00           H  
ATOM   1415  HB3 ASP A  88     -16.749  11.702 -15.138  1.00  0.00           H  
ATOM   1416  N   ASN A  89     -14.378  12.771 -14.082  1.00  0.00           N  
ATOM   1417  CA  ASN A  89     -13.841  14.116 -14.212  1.00  0.00           C  
ATOM   1418  C   ASN A  89     -12.429  14.042 -14.797  1.00  0.00           C  
ATOM   1419  O   ASN A  89     -12.141  14.673 -15.813  1.00  0.00           O  
ATOM   1420  CB  ASN A  89     -13.754  14.808 -12.851  1.00  0.00           C  
ATOM   1421  CG  ASN A  89     -13.434  16.296 -13.012  1.00  0.00           C  
ATOM   1422  OD1 ASN A  89     -13.140  16.780 -14.092  1.00  0.00           O  
ATOM   1423  ND2 ASN A  89     -13.507  16.990 -11.881  1.00  0.00           N  
ATOM   1424  H   ASN A  89     -14.741  12.547 -13.177  1.00  0.00           H  
ATOM   1425  HA  ASN A  89     -14.537  14.639 -14.868  1.00  0.00           H  
ATOM   1426  HB2 ASN A  89     -14.697  14.690 -12.318  1.00  0.00           H  
ATOM   1427  HB3 ASN A  89     -12.984  14.330 -12.245  1.00  0.00           H  
ATOM   1428 HD21 ASN A  89     -13.754  16.531 -11.028  1.00  0.00           H  
ATOM   1429 HD22 ASN A  89     -13.316  17.972 -11.883  1.00  0.00           H  
ATOM   1430  N   GLY A  90     -11.587  13.267 -14.131  1.00  0.00           N  
ATOM   1431  CA  GLY A  90     -10.212  13.103 -14.572  1.00  0.00           C  
ATOM   1432  C   GLY A  90     -10.142  12.260 -15.848  1.00  0.00           C  
ATOM   1433  O   GLY A  90     -11.087  12.242 -16.635  1.00  0.00           O  
ATOM   1434  H   GLY A  90     -11.830  12.757 -13.306  1.00  0.00           H  
ATOM   1435  HA2 GLY A  90      -9.765  14.080 -14.752  1.00  0.00           H  
ATOM   1436  HA3 GLY A  90      -9.629  12.625 -13.784  1.00  0.00           H  
ATOM   1437  N   SER A  91      -9.015  11.584 -16.011  1.00  0.00           N  
ATOM   1438  CA  SER A  91      -8.809  10.743 -17.178  1.00  0.00           C  
ATOM   1439  C   SER A  91      -7.899   9.566 -16.820  1.00  0.00           C  
ATOM   1440  O   SER A  91      -6.967   9.250 -17.558  1.00  0.00           O  
ATOM   1441  CB  SER A  91      -8.211  11.544 -18.336  1.00  0.00           C  
ATOM   1442  OG  SER A  91      -6.951  12.114 -17.996  1.00  0.00           O  
ATOM   1443  H   SER A  91      -8.252  11.605 -15.366  1.00  0.00           H  
ATOM   1444  HA  SER A  91      -9.801  10.387 -17.456  1.00  0.00           H  
ATOM   1445  HB2 SER A  91      -8.092  10.893 -19.203  1.00  0.00           H  
ATOM   1446  HB3 SER A  91      -8.902  12.336 -18.624  1.00  0.00           H  
ATOM   1447  HG  SER A  91      -6.260  11.840 -18.664  1.00  0.00           H  
ATOM   1448  N   PHE A  92      -8.200   8.949 -15.687  1.00  0.00           N  
ATOM   1449  CA  PHE A  92      -7.421   7.814 -15.222  1.00  0.00           C  
ATOM   1450  C   PHE A  92      -5.995   8.238 -14.864  1.00  0.00           C  
ATOM   1451  O   PHE A  92      -5.029   7.649 -15.346  1.00  0.00           O  
ATOM   1452  CB  PHE A  92      -7.367   6.808 -16.373  1.00  0.00           C  
ATOM   1453  CG  PHE A  92      -7.380   5.346 -15.922  1.00  0.00           C  
ATOM   1454  CD1 PHE A  92      -6.482   4.911 -14.999  1.00  0.00           C  
ATOM   1455  CD2 PHE A  92      -8.292   4.481 -16.445  1.00  0.00           C  
ATOM   1456  CE1 PHE A  92      -6.495   3.553 -14.581  1.00  0.00           C  
ATOM   1457  CE2 PHE A  92      -8.305   3.125 -16.026  1.00  0.00           C  
ATOM   1458  CZ  PHE A  92      -7.406   2.690 -15.103  1.00  0.00           C  
ATOM   1459  H   PHE A  92      -8.959   9.212 -15.092  1.00  0.00           H  
ATOM   1460  HA  PHE A  92      -7.916   7.424 -14.333  1.00  0.00           H  
ATOM   1461  HB2 PHE A  92      -8.215   6.982 -17.035  1.00  0.00           H  
ATOM   1462  HB3 PHE A  92      -6.465   6.988 -16.958  1.00  0.00           H  
ATOM   1463  HD1 PHE A  92      -5.752   5.602 -14.581  1.00  0.00           H  
ATOM   1464  HD2 PHE A  92      -9.012   4.831 -17.185  1.00  0.00           H  
ATOM   1465  HE1 PHE A  92      -5.774   3.204 -13.841  1.00  0.00           H  
ATOM   1466  HE2 PHE A  92      -9.036   2.433 -16.445  1.00  0.00           H  
ATOM   1467  HZ  PHE A  92      -7.416   1.648 -14.782  1.00  0.00           H  
ATOM   1468  N   LEU A  93      -5.909   9.257 -14.021  1.00  0.00           N  
ATOM   1469  CA  LEU A  93      -4.618   9.767 -13.593  1.00  0.00           C  
ATOM   1470  C   LEU A  93      -4.146   8.984 -12.365  1.00  0.00           C  
ATOM   1471  O   LEU A  93      -4.739   9.089 -11.293  1.00  0.00           O  
ATOM   1472  CB  LEU A  93      -4.686  11.278 -13.368  1.00  0.00           C  
ATOM   1473  CG  LEU A  93      -4.089  12.150 -14.476  1.00  0.00           C  
ATOM   1474  CD1 LEU A  93      -5.185  12.894 -15.239  1.00  0.00           C  
ATOM   1475  CD2 LEU A  93      -3.032  13.103 -13.914  1.00  0.00           C  
ATOM   1476  H   LEU A  93      -6.700   9.731 -13.634  1.00  0.00           H  
ATOM   1477  HA  LEU A  93      -3.912   9.593 -14.405  1.00  0.00           H  
ATOM   1478  HB2 LEU A  93      -5.731  11.560 -13.236  1.00  0.00           H  
ATOM   1479  HB3 LEU A  93      -4.173  11.511 -12.435  1.00  0.00           H  
ATOM   1480  HG  LEU A  93      -3.587  11.496 -15.190  1.00  0.00           H  
ATOM   1481 HD11 LEU A  93      -6.157  12.468 -14.987  1.00  0.00           H  
ATOM   1482 HD12 LEU A  93      -5.168  13.949 -14.962  1.00  0.00           H  
ATOM   1483 HD13 LEU A  93      -5.013  12.798 -16.310  1.00  0.00           H  
ATOM   1484 HD21 LEU A  93      -3.437  13.623 -13.047  1.00  0.00           H  
ATOM   1485 HD22 LEU A  93      -2.150  12.534 -13.617  1.00  0.00           H  
ATOM   1486 HD23 LEU A  93      -2.755  13.829 -14.678  1.00  0.00           H  
ATOM   1487  N   ARG A  94      -3.086   8.215 -12.565  1.00  0.00           N  
ATOM   1488  CA  ARG A  94      -2.529   7.415 -11.489  1.00  0.00           C  
ATOM   1489  C   ARG A  94      -1.278   8.087 -10.920  1.00  0.00           C  
ATOM   1490  O   ARG A  94      -0.183   7.530 -10.990  1.00  0.00           O  
ATOM   1491  CB  ARG A  94      -2.167   6.010 -11.977  1.00  0.00           C  
ATOM   1492  CG  ARG A  94      -1.537   5.184 -10.854  1.00  0.00           C  
ATOM   1493  CD  ARG A  94      -0.386   4.326 -11.383  1.00  0.00           C  
ATOM   1494  NE  ARG A  94       0.908   4.872 -10.919  1.00  0.00           N  
ATOM   1495  CZ  ARG A  94       1.631   4.347  -9.920  1.00  0.00           C  
ATOM   1496  NH1 ARG A  94       1.190   3.258  -9.274  1.00  0.00           N  
ATOM   1497  NH2 ARG A  94       2.794   4.910  -9.566  1.00  0.00           N  
ATOM   1498  H   ARG A  94      -2.610   8.135 -13.441  1.00  0.00           H  
ATOM   1499  HA  ARG A  94      -3.320   7.362 -10.741  1.00  0.00           H  
ATOM   1500  HB2 ARG A  94      -3.061   5.507 -12.345  1.00  0.00           H  
ATOM   1501  HB3 ARG A  94      -1.474   6.080 -12.814  1.00  0.00           H  
ATOM   1502  HG2 ARG A  94      -1.169   5.849 -10.071  1.00  0.00           H  
ATOM   1503  HG3 ARG A  94      -2.293   4.545 -10.399  1.00  0.00           H  
ATOM   1504  HD2 ARG A  94      -0.501   3.298 -11.039  1.00  0.00           H  
ATOM   1505  HD3 ARG A  94      -0.411   4.303 -12.472  1.00  0.00           H  
ATOM   1506  HE  ARG A  94       1.267   5.684 -11.379  1.00  0.00           H  
ATOM   1507 HH11 ARG A  94       0.321   2.838  -9.538  1.00  0.00           H  
ATOM   1508 HH12 ARG A  94       1.729   2.866  -8.529  1.00  0.00           H  
ATOM   1509 HH21 ARG A  94       3.124   5.722 -10.048  1.00  0.00           H  
ATOM   1510 HH22 ARG A  94       3.333   4.518  -8.821  1.00  0.00           H  
ATOM   1511  N   ARG A  95      -1.482   9.274 -10.368  1.00  0.00           N  
ATOM   1512  CA  ARG A  95      -0.384  10.028  -9.787  1.00  0.00           C  
ATOM   1513  C   ARG A  95      -0.835  11.453  -9.457  1.00  0.00           C  
ATOM   1514  O   ARG A  95      -0.803  11.865  -8.298  1.00  0.00           O  
ATOM   1515  CB  ARG A  95       0.810  10.087 -10.742  1.00  0.00           C  
ATOM   1516  CG  ARG A  95       2.105   9.703 -10.024  1.00  0.00           C  
ATOM   1517  CD  ARG A  95       2.701   8.423 -10.614  1.00  0.00           C  
ATOM   1518  NE  ARG A  95       3.794   7.928  -9.748  1.00  0.00           N  
ATOM   1519  CZ  ARG A  95       3.608   7.396  -8.533  1.00  0.00           C  
ATOM   1520  NH1 ARG A  95       2.370   7.287  -8.032  1.00  0.00           N  
ATOM   1521  NH2 ARG A  95       4.659   6.973  -7.818  1.00  0.00           N  
ATOM   1522  H   ARG A  95      -2.376   9.719 -10.315  1.00  0.00           H  
ATOM   1523  HA  ARG A  95      -0.119   9.481  -8.882  1.00  0.00           H  
ATOM   1524  HB2 ARG A  95       0.642   9.413 -11.582  1.00  0.00           H  
ATOM   1525  HB3 ARG A  95       0.902  11.091 -11.153  1.00  0.00           H  
ATOM   1526  HG2 ARG A  95       2.826  10.516 -10.107  1.00  0.00           H  
ATOM   1527  HG3 ARG A  95       1.907   9.559  -8.961  1.00  0.00           H  
ATOM   1528  HD2 ARG A  95       1.927   7.662 -10.708  1.00  0.00           H  
ATOM   1529  HD3 ARG A  95       3.080   8.618 -11.617  1.00  0.00           H  
ATOM   1530  HE  ARG A  95       4.731   7.994 -10.092  1.00  0.00           H  
ATOM   1531 HH11 ARG A  95       1.586   7.603  -8.565  1.00  0.00           H  
ATOM   1532 HH12 ARG A  95       2.231   6.891  -7.125  1.00  0.00           H  
ATOM   1533 HH21 ARG A  95       5.583   7.054  -8.192  1.00  0.00           H  
ATOM   1534 HH22 ARG A  95       4.520   6.576  -6.910  1.00  0.00           H  
ATOM   1535  N   ARG A  96      -1.245  12.165 -10.496  1.00  0.00           N  
ATOM   1536  CA  ARG A  96      -1.701  13.534 -10.331  1.00  0.00           C  
ATOM   1537  C   ARG A  96      -0.588  14.397  -9.733  1.00  0.00           C  
ATOM   1538  O   ARG A  96      -0.733  14.929  -8.633  1.00  0.00           O  
ATOM   1539  CB  ARG A  96      -2.931  13.599  -9.422  1.00  0.00           C  
ATOM   1540  CG  ARG A  96      -4.162  14.069 -10.200  1.00  0.00           C  
ATOM   1541  CD  ARG A  96      -4.174  15.593 -10.340  1.00  0.00           C  
ATOM   1542  NE  ARG A  96      -5.442  16.034 -10.965  1.00  0.00           N  
ATOM   1543  CZ  ARG A  96      -5.961  17.261 -10.824  1.00  0.00           C  
ATOM   1544  NH1 ARG A  96      -5.326  18.176 -10.081  1.00  0.00           N  
ATOM   1545  NH2 ARG A  96      -7.116  17.572 -11.428  1.00  0.00           N  
ATOM   1546  H   ARG A  96      -1.268  11.823 -11.435  1.00  0.00           H  
ATOM   1547  HA  ARG A  96      -1.956  13.867 -11.337  1.00  0.00           H  
ATOM   1548  HB2 ARG A  96      -3.122  12.617  -8.991  1.00  0.00           H  
ATOM   1549  HB3 ARG A  96      -2.739  14.280  -8.593  1.00  0.00           H  
ATOM   1550  HG2 ARG A  96      -4.170  13.610 -11.189  1.00  0.00           H  
ATOM   1551  HG3 ARG A  96      -5.067  13.740  -9.689  1.00  0.00           H  
ATOM   1552  HD2 ARG A  96      -4.061  16.057  -9.361  1.00  0.00           H  
ATOM   1553  HD3 ARG A  96      -3.328  15.917 -10.946  1.00  0.00           H  
ATOM   1554  HE  ARG A  96      -5.941  15.374 -11.527  1.00  0.00           H  
ATOM   1555 HH11 ARG A  96      -4.463  17.944  -9.630  1.00  0.00           H  
ATOM   1556 HH12 ARG A  96      -5.713  19.093  -9.976  1.00  0.00           H  
ATOM   1557 HH21 ARG A  96      -7.590  16.888 -11.984  1.00  0.00           H  
ATOM   1558 HH22 ARG A  96      -7.504  18.488 -11.323  1.00  0.00           H  
ATOM   1559  N   LYS A  97       0.499  14.509 -10.483  1.00  0.00           N  
ATOM   1560  CA  LYS A  97       1.635  15.297 -10.040  1.00  0.00           C  
ATOM   1561  C   LYS A  97       1.814  15.125  -8.530  1.00  0.00           C  
ATOM   1562  O   LYS A  97       1.663  16.082  -7.772  1.00  0.00           O  
ATOM   1563  CB  LYS A  97       1.480  16.755 -10.480  1.00  0.00           C  
ATOM   1564  CG  LYS A  97       2.525  17.123 -11.535  1.00  0.00           C  
ATOM   1565  CD  LYS A  97       1.881  17.861 -12.710  1.00  0.00           C  
ATOM   1566  CE  LYS A  97       2.307  19.330 -12.737  1.00  0.00           C  
ATOM   1567  NZ  LYS A  97       1.224  20.175 -13.286  1.00  0.00           N  
ATOM   1568  H   LYS A  97       0.608  14.073 -11.376  1.00  0.00           H  
ATOM   1569  HA  LYS A  97       2.521  14.903 -10.539  1.00  0.00           H  
ATOM   1570  HB2 LYS A  97       0.480  16.913 -10.883  1.00  0.00           H  
ATOM   1571  HB3 LYS A  97       1.584  17.411  -9.616  1.00  0.00           H  
ATOM   1572  HG2 LYS A  97       3.295  17.751 -11.086  1.00  0.00           H  
ATOM   1573  HG3 LYS A  97       3.019  16.220 -11.894  1.00  0.00           H  
ATOM   1574  HD2 LYS A  97       2.164  17.380 -13.646  1.00  0.00           H  
ATOM   1575  HD3 LYS A  97       0.796  17.795 -12.635  1.00  0.00           H  
ATOM   1576  HE2 LYS A  97       2.558  19.660 -11.728  1.00  0.00           H  
ATOM   1577  HE3 LYS A  97       3.207  19.443 -13.342  1.00  0.00           H  
ATOM   1578  HZ1 LYS A  97       0.351  19.905 -12.878  1.00  0.00           H  
ATOM   1579  HZ2 LYS A  97       1.408  21.134 -13.072  1.00  0.00           H  
ATOM   1580  HZ3 LYS A  97       1.178  20.056 -14.277  1.00  0.00           H  
ATOM   1581  N   ARG A  98       2.132  13.900  -8.139  1.00  0.00           N  
ATOM   1582  CA  ARG A  98       2.331  13.592  -6.734  1.00  0.00           C  
ATOM   1583  C   ARG A  98       3.069  14.737  -6.038  1.00  0.00           C  
ATOM   1584  O   ARG A  98       4.090  15.214  -6.532  1.00  0.00           O  
ATOM   1585  CB  ARG A  98       3.132  12.299  -6.563  1.00  0.00           C  
ATOM   1586  CG  ARG A  98       2.989  11.750  -5.143  1.00  0.00           C  
ATOM   1587  CD  ARG A  98       4.272  11.042  -4.696  1.00  0.00           C  
ATOM   1588  NE  ARG A  98       3.946   9.969  -3.730  1.00  0.00           N  
ATOM   1589  CZ  ARG A  98       3.685   8.702  -4.075  1.00  0.00           C  
ATOM   1590  NH1 ARG A  98       3.707   8.339  -5.365  1.00  0.00           N  
ATOM   1591  NH2 ARG A  98       3.400   7.795  -3.129  1.00  0.00           N  
ATOM   1592  H   ARG A  98       2.253  13.129  -8.764  1.00  0.00           H  
ATOM   1593  HA  ARG A  98       1.327  13.469  -6.330  1.00  0.00           H  
ATOM   1594  HB2 ARG A  98       2.789  11.556  -7.282  1.00  0.00           H  
ATOM   1595  HB3 ARG A  98       4.185  12.488  -6.779  1.00  0.00           H  
ATOM   1596  HG2 ARG A  98       2.761  12.564  -4.454  1.00  0.00           H  
ATOM   1597  HG3 ARG A  98       2.152  11.053  -5.101  1.00  0.00           H  
ATOM   1598  HD2 ARG A  98       4.783  10.621  -5.561  1.00  0.00           H  
ATOM   1599  HD3 ARG A  98       4.952  11.760  -4.240  1.00  0.00           H  
ATOM   1600  HE  ARG A  98       3.921  10.206  -2.758  1.00  0.00           H  
ATOM   1601 HH11 ARG A  98       3.919   9.016  -6.070  1.00  0.00           H  
ATOM   1602 HH12 ARG A  98       3.511   7.393  -5.622  1.00  0.00           H  
ATOM   1603 HH21 ARG A  98       3.383   8.065  -2.167  1.00  0.00           H  
ATOM   1604 HH22 ARG A  98       3.205   6.849  -3.387  1.00  0.00           H  
TER    1605      ARG A  98                                                      
END
MOLECULE T0476.pdb
ATOM     20  N   ALA     2       2.300  -1.329  -3.219  1.00  1.00          
ATOM     21  HN  ALA     2       2.119  -0.600  -3.850  1.00  1.00          
ATOM     22  CA  ALA     2       2.425  -2.698  -3.762  1.00  1.00          
ATOM     23  HA  ALA     2       2.430  -3.385  -2.927  1.00  1.00          
ATOM     24  CB  ALA     2       1.232  -3.027  -4.654  1.00  1.00          
ATOM     25  HB1 ALA     2       0.366  -3.248  -4.041  1.00  1.00          
ATOM     26  HB2 ALA     2       1.466  -3.884  -5.266  1.00  1.00          
ATOM     27  HB3 ALA     2       1.012  -2.181  -5.288  1.00  1.00          
ATOM     28  C   ALA     2       3.737  -2.860  -4.536  1.00  1.00          
ATOM     29  O   ALA     2       4.162  -1.925  -5.237  1.00  1.00          
ATOM     30  N   LYS     3       4.348  -4.064  -4.398  1.00  1.00          
ATOM     31  HN  LYS     3       3.910  -4.743  -3.851  1.00  1.00          
ATOM     32  CA  LYS     3       5.630  -4.420  -5.036  1.00  1.00          
ATOM     33  HA  LYS     3       5.927  -3.593  -5.664  1.00  1.00          
ATOM     34  CB  LYS     3       6.703  -4.642  -3.963  1.00  1.00          
ATOM     35  HB1 LYS     3       7.090  -5.646  -4.059  1.00  1.00          
ATOM     36  HB2 LYS     3       6.247  -4.534  -2.991  1.00  1.00          
ATOM     37  CG  LYS     3       7.866  -3.669  -4.054  1.00  1.00          
ATOM     38  HG1 LYS     3       7.478  -2.663  -4.070  1.00  1.00          
ATOM     39  HG2 LYS     3       8.415  -3.861  -4.963  1.00  1.00          
ATOM     40  CD  LYS     3       8.812  -3.819  -2.864  1.00  1.00          
ATOM     41  HD1 LYS     3       9.239  -4.812  -2.884  1.00  1.00          
ATOM     42  HD2 LYS     3       8.242  -3.692  -1.954  1.00  1.00          
ATOM     43  CE  LYS     3       9.950  -2.788  -2.891  1.00  1.00          
ATOM     44  HE1 LYS     3      10.366  -2.698  -1.895  1.00  1.00          
ATOM     45  HE2 LYS     3       9.543  -1.834  -3.190  1.00  1.00          
ATOM     46  NZ  LYS     3      11.048  -3.157  -3.838  1.00  1.00          
ATOM     47  HZ1 LYS     3      10.919  -4.134  -4.171  1.00  1.00          
ATOM     48  HZ2 LYS     3      11.970  -3.084  -3.363  1.00  1.00          
ATOM     49  HZ3 LYS     3      11.041  -2.517  -4.658  1.00  1.00          
ATOM     50  C   LYS     3       5.489  -5.670  -5.903  1.00  1.00          
ATOM     51  O   LYS     3       4.818  -6.637  -5.496  1.00  1.00          
ATOM     52  N   CYS     4       6.139  -5.626  -7.110  1.00  1.00          
ATOM     53  HN  CYS     4       6.610  -4.798  -7.337  1.00  1.00          
ATOM     54  CA  CYS     4       6.151  -6.739  -8.115  1.00  1.00          
ATOM     55  HA  CYS     4       5.134  -7.092  -8.210  1.00  1.00          
ATOM     56  HB1 CYS     4       7.690  -6.064  -9.456  1.00  1.00          
ATOM     57  HB2 CYS     4       6.138  -5.314  -9.733  1.00  1.00          
ATOM     58  C   CYS     4       7.052  -7.958  -7.664  1.00  1.00          
ATOM     59  O   CYS     4       8.242  -7.720  -7.359  1.00  1.00          
ATOM     60  CB  CYS     4       6.628  -6.236  -9.499  1.00  1.00          
ATOM     61  SG  CYS     4       6.315  -7.399 -10.876  1.00  1.00          
ATOM     62  ZN  CYS     4       7.178  -6.267 -12.689  1.00  1.00          
ATOM     63  N   PRO     5       6.504  -9.279  -7.551  1.00  1.00          
ATOM     64  CA  PRO     5       7.350 -10.468  -7.168  1.00  1.00          
ATOM     65  HA  PRO     5       7.965 -10.222  -6.313  1.00  1.00          
ATOM     66  CB  PRO     5       6.300 -11.538  -6.750  1.00  1.00          
ATOM     67  HB1 PRO     5       6.133 -11.486  -5.679  1.00  1.00          
ATOM     68  HB2 PRO     5       6.670 -12.522  -7.004  1.00  1.00          
ATOM     69  CG  PRO     5       5.042 -11.205  -7.513  1.00  1.00          
ATOM     70  HG1 PRO     5       4.168 -11.526  -6.955  1.00  1.00          
ATOM     71  HG2 PRO     5       5.061 -11.696  -8.482  1.00  1.00          
ATOM     72  CD  PRO     5       5.048  -9.697  -7.681  1.00  1.00          
ATOM     73  HD1 PRO     5       4.459  -9.227  -6.903  1.00  1.00          
ATOM     74  HD2 PRO     5       4.661  -9.417  -8.652  1.00  1.00          
ATOM     75  C   PRO     5       8.310 -10.999  -8.302  1.00  1.00          
ATOM     76  O   PRO     5       9.092 -11.941  -8.056  1.00  1.00          
ATOM     77  N   ILE     6       8.243 -10.351  -9.506  1.00  1.00          
ATOM     78  HN  ILE     6       7.662  -9.568  -9.601  1.00  1.00          
ATOM     79  CA  ILE     6       9.041 -10.718 -10.711  1.00  1.00          
ATOM     80  HA  ILE     6       9.414 -11.721 -10.556  1.00  1.00          
ATOM     81  CB  ILE     6       8.166 -10.709 -12.075  1.00  1.00          
ATOM     82  HB  ILE     6       8.010  -9.665 -12.339  1.00  1.00          
ATOM     83  CG1 ILE     6       6.780 -11.397 -11.928  1.00  1.00          
ATOM     84 HG11 ILE     6       6.684 -11.787 -10.923  1.00  1.00          
ATOM     85 HG12 ILE     6       6.717 -12.214 -12.630  1.00  1.00          
ATOM     86  CG2 ILE     6       8.885 -11.402 -13.266  1.00  1.00          
ATOM     87 HG21 ILE     6       8.195 -11.508 -14.089  1.00  1.00          
ATOM     88 HG22 ILE     6       9.234 -12.376 -12.960  1.00  1.00          
ATOM     89 HG23 ILE     6       9.727 -10.799 -13.576  1.00  1.00          
ATOM     90  CD1 ILE     6       5.603 -10.477 -12.185  1.00  1.00          
ATOM     91 HD11 ILE     6       5.734  -9.980 -13.135  1.00  1.00          
ATOM     92 HD12 ILE     6       5.545  -9.738 -11.398  1.00  1.00          
ATOM     93 HD13 ILE     6       4.690 -11.054 -12.203  1.00  1.00          
ATOM     94  C   ILE     6      10.267  -9.754 -10.836  1.00  1.00          
ATOM     95  O   ILE     6      11.410 -10.247 -10.885  1.00  1.00          
ATOM     96  N   CYS     7       9.997  -8.409 -10.880  1.00  1.00          
ATOM     97  HN  CYS     7       9.068  -8.099 -10.752  1.00  1.00          
ATOM     98  CA  CYS     7      11.045  -7.379 -11.052  1.00  1.00          
ATOM     99  HA  CYS     7      11.937  -7.900 -11.371  1.00  1.00          
ATOM    100  HB1 CYS     7      10.463  -6.971 -13.068  1.00  1.00          
ATOM    101  HB2 CYS     7      11.466  -5.723 -12.357  1.00  1.00          
ATOM    102  C   CYS     7      11.386  -6.643  -9.742  1.00  1.00          
ATOM    103  O   CYS     7      12.579  -6.407  -9.475  1.00  1.00          
ATOM    104  CB  CYS     7      10.644  -6.397 -12.176  1.00  1.00          
ATOM    105  SG  CYS     7       9.154  -5.367 -11.862  1.00  1.00          
ATOM    106  N   GLY     8      10.326  -6.300  -8.947  1.00  1.00          
ATOM    107  HN  GLY     8       9.429  -6.536  -9.259  1.00  1.00          
ATOM    108  CA  GLY     8      10.463  -5.587  -7.658  1.00  1.00          
ATOM    109  HA1 GLY     8      11.409  -5.858  -7.215  1.00  1.00          
ATOM    110  HA2 GLY     8       9.671  -5.911  -7.002  1.00  1.00          
ATOM    111  C   GLY     8      10.398  -4.062  -7.773  1.00  1.00          
ATOM    112  O   GLY     8      11.113  -3.371  -7.024  1.00  1.00          
ATOM    113  N   SER     9       9.543  -3.559  -8.714  1.00  1.00          
ATOM    114  HN  SER     9       9.028  -4.201  -9.268  1.00  1.00          
ATOM    115  CA  SER     9       9.353  -2.108  -8.955  1.00  1.00          
ATOM    116  HA  SER     9      10.245  -1.616  -8.608  1.00  1.00          
ATOM    117  CB  SER     9       9.190  -1.838 -10.450  1.00  1.00          
ATOM    118  HB1 SER     9       8.515  -1.007 -10.590  1.00  1.00          
ATOM    119  HB2 SER     9       8.784  -2.717 -10.929  1.00  1.00          
ATOM    120  OG  SER     9      10.434  -1.523 -11.050  1.00  1.00          
ATOM    121  HG  SER     9      11.071  -1.296 -10.369  1.00  1.00          
ATOM    122  C   SER     9       8.118  -1.543  -8.168  1.00  1.00          
ATOM    123  O   SER     9       7.155  -2.318  -7.998  1.00  1.00          
ATOM    124  N   PRO    10       8.068  -0.182  -7.677  1.00  1.00          
ATOM    125  CA  PRO    10       6.894   0.366  -6.898  1.00  1.00          
ATOM    126  HA  PRO    10       6.675  -0.274  -6.053  1.00  1.00          
ATOM    127  CB  PRO    10       7.377   1.745  -6.389  1.00  1.00          
ATOM    128  HB1 PRO    10       7.094   1.885  -5.351  1.00  1.00          
ATOM    129  HB2 PRO    10       6.922   2.521  -6.992  1.00  1.00          
ATOM    130  CG  PRO    10       8.860   1.719  -6.557  1.00  1.00          
ATOM    131  HG1 PRO    10       9.323   1.230  -5.709  1.00  1.00          
ATOM    132  HG2 PRO    10       9.246   2.726  -6.667  1.00  1.00          
ATOM    133  CD  PRO    10       9.089   0.921  -7.810  1.00  1.00          
ATOM    134  HD1 PRO    10      10.092   0.531  -7.830  1.00  1.00          
ATOM    135  HD2 PRO    10       8.896   1.526  -8.686  1.00  1.00          
ATOM    136  C   PRO    10       5.597   0.545  -7.715  1.00  1.00          
ATOM    137  O   PRO    10       5.643   0.957  -8.890  1.00  1.00          
ATOM    138  N   LEU    11       4.473   0.213  -7.043  1.00  1.00          
ATOM    139  HN  LEU    11       4.572  -0.110  -6.123  1.00  1.00          
ATOM    140  CA  LEU    11       3.105   0.301  -7.592  1.00  1.00          
ATOM    141  HA  LEU    11       3.157   0.823  -8.536  1.00  1.00          
ATOM    142  CB  LEU    11       2.505  -1.103  -7.823  1.00  1.00          
ATOM    143  HB1 LEU    11       1.435  -0.986  -7.961  1.00  1.00          
ATOM    144  HB2 LEU    11       2.671  -1.689  -6.932  1.00  1.00          
ATOM    145  CG  LEU    11       3.057  -1.892  -9.022  1.00  1.00          
ATOM    146  HG  LEU    11       4.007  -1.471  -9.320  1.00  1.00          
ATOM    147  CD1 LEU    11       3.294  -3.342  -8.631  1.00  1.00          
ATOM    148 HD11 LEU    11       2.387  -3.756  -8.216  1.00  1.00          
ATOM    149 HD12 LEU    11       4.082  -3.393  -7.896  1.00  1.00          
ATOM    150 HD13 LEU    11       3.580  -3.909  -9.505  1.00  1.00          
ATOM    151  CD2 LEU    11       2.100  -1.814 -10.209  1.00  1.00          
ATOM    152 HD21 LEU    11       1.811  -0.785 -10.370  1.00  1.00          
ATOM    153 HD22 LEU    11       1.222  -2.406 -10.003  1.00  1.00          
ATOM    154 HD23 LEU    11       2.591  -2.193 -11.094  1.00  1.00          
ATOM    155  C   LEU    11       2.200   1.084  -6.640  1.00  1.00          
ATOM    156  O   LEU    11       2.354   0.979  -5.405  1.00  1.00          
ATOM    157  N   LYS    12       1.248   1.846  -7.239  1.00  1.00          
ATOM    158  HN  LYS    12       1.205   1.847  -8.218  1.00  1.00          
ATOM    159  CA  LYS    12       0.268   2.672  -6.500  1.00  1.00          
ATOM    160  HA  LYS    12       0.655   2.832  -5.504  1.00  1.00          
ATOM    161  CB  LYS    12       0.071   4.039  -7.188  1.00  1.00          
ATOM    162  HB1 LYS    12      -0.862   4.462  -6.847  1.00  1.00          
ATOM    163  HB2 LYS    12       0.009   3.879  -8.253  1.00  1.00          
ATOM    164  CG  LYS    12       1.177   5.060  -6.932  1.00  1.00          
ATOM    165  HG1 LYS    12       2.125   4.636  -7.231  1.00  1.00          
ATOM    166  HG2 LYS    12       1.202   5.296  -5.878  1.00  1.00          
ATOM    167  CD  LYS    12       0.933   6.337  -7.719  1.00  1.00          
ATOM    168  HD1 LYS    12       0.002   6.777  -7.392  1.00  1.00          
ATOM    169  HD2 LYS    12       0.868   6.093  -8.769  1.00  1.00          
ATOM    170  CE  LYS    12       2.054   7.343  -7.518  1.00  1.00          
ATOM    171  HE1 LYS    12       2.989   6.884  -7.799  1.00  1.00          
ATOM    172  HE2 LYS    12       2.087   7.622  -6.476  1.00  1.00          
ATOM    173  NZ  LYS    12       1.848   8.568  -8.341  1.00  1.00          
ATOM    174  HZ1 LYS    12       0.845   8.844  -8.326  1.00  1.00          
ATOM    175  HZ2 LYS    12       2.133   8.389  -9.324  1.00  1.00          
ATOM    176  HZ3 LYS    12       2.418   9.351  -7.963  1.00  1.00          
ATOM    177  C   LYS    12      -1.081   1.956  -6.396  1.00  1.00          
ATOM    178  O   LYS    12      -1.559   1.377  -7.390  1.00  1.00          
ATOM    179  N   TRP    13      -1.672   1.996  -5.160  1.00  1.00          
ATOM    180  HN  TRP    13      -1.181   2.442  -4.438  1.00  1.00          
ATOM    181  CA  TRP    13      -3.017   1.404  -4.824  1.00  1.00          
ATOM    182  HA  TRP    13      -3.015   0.400  -5.221  1.00  1.00          
ATOM    183  CB  TRP    13      -3.201   1.310  -3.305  1.00  1.00          
ATOM    184  HB1 TRP    13      -4.256   1.293  -3.074  1.00  1.00          
ATOM    185  HB2 TRP    13      -2.746   2.171  -2.837  1.00  1.00          
ATOM    186  CG  TRP    13      -2.569   0.062  -2.712  1.00  1.00          
ATOM    187  CD1 TRP    13      -1.316  -0.023  -2.173  1.00  1.00          
ATOM    188  HD1 TRP    13      -0.631   0.809  -2.108  1.00  1.00          
ATOM    189  CD2 TRP    13      -3.138  -1.276  -2.597  1.00  1.00          
ATOM    190  NE1 TRP    13      -1.061  -1.302  -1.745  1.00  1.00          
ATOM    191  HE1 TRP    13      -0.226  -1.604  -1.327  1.00  1.00          
ATOM    192  CE2 TRP    13      -2.156  -2.089  -1.988  1.00  1.00          
ATOM    193  CE3 TRP    13      -4.371  -1.874  -2.944  1.00  1.00          
ATOM    194  HE3 TRP    13      -5.157  -1.299  -3.410  1.00  1.00          
ATOM    195  CZ2 TRP    13      -2.361  -3.447  -1.724  1.00  1.00          
ATOM    196  HZ2 TRP    13      -1.601  -4.066  -1.262  1.00  1.00          
ATOM    197  CZ3 TRP    13      -4.566  -3.216  -2.675  1.00  1.00          
ATOM    198  HZ3 TRP    13      -5.504  -3.685  -2.935  1.00  1.00          
ATOM    199  CH2 TRP    13      -3.565  -3.989  -2.072  1.00  1.00          
ATOM    200  HH2 TRP    13      -3.762  -5.034  -1.877  1.00  1.00          
ATOM    201  C   TRP    13      -4.207   2.161  -5.486  1.00  1.00          
ATOM    202  O   TRP    13      -5.280   1.571  -5.690  1.00  1.00          
ATOM    203  N   GLU    14      -3.968   3.482  -5.801  1.00  1.00          
ATOM    204  HN  GLU    14      -3.096   3.848  -5.548  1.00  1.00          
ATOM    205  CA  GLU    14      -4.922   4.411  -6.497  1.00  1.00          
ATOM    206  HA  GLU    14      -5.875   4.335  -5.994  1.00  1.00          
ATOM    207  CB  GLU    14      -4.427   5.865  -6.398  1.00  1.00          
ATOM    208  HB1 GLU    14      -4.913   6.447  -7.167  1.00  1.00          
ATOM    209  HB2 GLU    14      -3.361   5.878  -6.573  1.00  1.00          
ATOM    210  CG  GLU    14      -4.688   6.541  -5.055  1.00  1.00          
ATOM    211  HG1 GLU    14      -4.184   5.982  -4.281  1.00  1.00          
ATOM    212  HG2 GLU    14      -5.752   6.539  -4.866  1.00  1.00          
ATOM    213  CD  GLU    14      -4.193   7.975  -5.018  1.00  1.00          
ATOM    214  OE1 GLU    14      -4.994   8.888  -5.307  1.00  1.00          
ATOM    215  OE2 GLU    14      -3.003   8.183  -4.699  1.00  1.00          
ATOM    216  C   GLU    14      -5.129   4.058  -8.000  1.00  1.00          
ATOM    217  O   GLU    14      -6.217   4.314  -8.541  1.00  1.00          
ATOM    218  N   GLU    15      -4.055   3.473  -8.649  1.00  1.00          
ATOM    219  HN  GLU    15      -3.230   3.319  -8.128  1.00  1.00          
ATOM    220  CA  GLU    15      -4.048   3.031 -10.086  1.00  1.00          
ATOM    221  HA  GLU    15      -4.509   3.819 -10.662  1.00  1.00          
ATOM    222  CB  GLU    15      -2.604   2.844 -10.589  1.00  1.00          
ATOM    223  HB1 GLU    15      -2.622   2.205 -11.460  1.00  1.00          
ATOM    224  HB2 GLU    15      -2.029   2.360  -9.813  1.00  1.00          
ATOM    225  CG  GLU    15      -1.895   4.143 -10.965  1.00  1.00          
ATOM    226  HG1 GLU    15      -1.851   4.779 -10.092  1.00  1.00          
ATOM    227  HG2 GLU    15      -2.462   4.638 -11.739  1.00  1.00          
ATOM    228  CD  GLU    15      -0.482   3.918 -11.472  1.00  1.00          
ATOM    229  OE1 GLU    15      -0.304   3.799 -12.703  1.00  1.00          
ATOM    230  OE2 GLU    15       0.448   3.863 -10.638  1.00  1.00          
ATOM    231  C   GLU    15      -4.856   1.726 -10.327  1.00  1.00          
ATOM    232  O   GLU    15      -5.487   1.583 -11.386  1.00  1.00          
ATOM    233  N   LEU    16      -4.815   0.793  -9.313  1.00  1.00          
ATOM    234  HN  LEU    16      -4.272   1.013  -8.527  1.00  1.00          
ATOM    235  CA  LEU    16      -5.531  -0.525  -9.302  1.00  1.00          
ATOM    236  HA  LEU    16      -5.286  -1.030 -10.224  1.00  1.00          
ATOM    237  CB  LEU    16      -5.014  -1.371  -8.126  1.00  1.00          
ATOM    238  HB1 LEU    16      -5.761  -2.115  -7.894  1.00  1.00          
ATOM    239  HB2 LEU    16      -4.901  -0.721  -7.271  1.00  1.00          
ATOM    240  CG  LEU    16      -3.682  -2.089  -8.365  1.00  1.00          
ATOM    241  HG  LEU    16      -3.230  -1.706  -9.269  1.00  1.00          
ATOM    242  CD1 LEU    16      -2.723  -1.829  -7.213  1.00  1.00          
ATOM    243 HD11 LEU    16      -2.434  -0.789  -7.217  1.00  1.00          
ATOM    244 HD12 LEU    16      -1.845  -2.446  -7.329  1.00  1.00          
ATOM    245 HD13 LEU    16      -3.209  -2.064  -6.275  1.00  1.00          
ATOM    246  CD2 LEU    16      -3.906  -3.581  -8.543  1.00  1.00          
ATOM    247 HD21 LEU    16      -4.651  -3.744  -9.307  1.00  1.00          
ATOM    248 HD22 LEU    16      -4.247  -4.007  -7.610  1.00  1.00          
ATOM    249 HD23 LEU    16      -2.980  -4.051  -8.836  1.00  1.00          
ATOM    250  C   LEU    16      -7.082  -0.392  -9.222  1.00  1.00          
ATOM    251  O   LEU    16      -7.797  -1.152  -9.894  1.00  1.00          
ATOM    252  N   ILE    17      -7.564   0.589  -8.376  1.00  1.00          
ATOM    253  HN  ILE    17      -6.905   1.114  -7.878  1.00  1.00          
ATOM    254  CA  ILE    17      -9.021   0.920  -8.154  1.00  1.00          
ATOM    255  HA  ILE    17      -9.547  -0.023  -8.086  1.00  1.00          
ATOM    256  CB  ILE    17      -9.283   1.731  -6.766  1.00  1.00          
ATOM    257  HB  ILE    17      -9.012   2.758  -6.972  1.00  1.00          
ATOM    258  CG1 ILE    17      -8.423   1.252  -5.486  1.00  1.00          
ATOM    259 HG11 ILE    17      -8.829   1.751  -4.615  1.00  1.00          
ATOM    260 HG12 ILE    17      -7.411   1.598  -5.620  1.00  1.00          
ATOM    261  CG2 ILE    17     -10.798   1.759  -6.372  1.00  1.00          
ATOM    262 HG21 ILE    17     -11.113   0.765  -6.095  1.00  1.00          
ATOM    263 HG22 ILE    17     -11.380   2.095  -7.220  1.00  1.00          
ATOM    264 HG23 ILE    17     -10.945   2.433  -5.542  1.00  1.00          
ATOM    265  CD1 ILE    17      -8.315  -0.266  -5.133  1.00  1.00          
ATOM    266 HD11 ILE    17      -8.367  -0.391  -4.061  1.00  1.00          
ATOM    267 HD12 ILE    17      -7.375  -0.655  -5.494  1.00  1.00          
ATOM    268 HD13 ILE    17      -9.128  -0.801  -5.599  1.00  1.00          
ATOM    269  C   ILE    17      -9.605   1.706  -9.392  1.00  1.00          
ATOM    270  O   ILE    17     -10.742   1.429  -9.806  1.00  1.00          
ATOM    271  N   GLU    18      -8.789   2.673  -9.944  1.00  1.00          
ATOM    272  HN  GLU    18      -7.909   2.811  -9.536  1.00  1.00          
ATOM    273  CA  GLU    18      -9.137   3.532 -11.124  1.00  1.00          
ATOM    274  HA  GLU    18     -10.094   3.986 -10.916  1.00  1.00          
ATOM    275  CB  GLU    18      -8.092   4.649 -11.264  1.00  1.00          
ATOM    276  HB1 GLU    18      -7.478   4.443 -12.126  1.00  1.00          
ATOM    277  HB2 GLU    18      -7.468   4.653 -10.384  1.00  1.00          
ATOM    278  CG  GLU    18      -8.691   6.039 -11.426  1.00  1.00          
ATOM    279  HG1 GLU    18      -9.296   6.259 -10.558  1.00  1.00          
ATOM    280  HG2 GLU    18      -9.313   6.049 -12.308  1.00  1.00          
ATOM    281  CD  GLU    18      -7.632   7.113 -11.566  1.00  1.00          
ATOM    282  OE1 GLU    18      -7.356   7.526 -12.712  1.00  1.00          
ATOM    283  OE2 GLU    18      -7.077   7.544 -10.532  1.00  1.00          
ATOM    284  C   GLU    18      -9.252   2.738 -12.462  1.00  1.00          
ATOM    285  O   GLU    18     -10.109   3.070 -13.297  1.00  1.00          
ATOM    286  N   GLU    19      -8.371   1.695 -12.623  1.00  1.00          
ATOM    287  HN  GLU    19      -7.726   1.518 -11.907  1.00  1.00          
ATOM    288  CA  GLU    19      -8.326   0.776 -13.795  1.00  1.00          
ATOM    289  HA  GLU    19      -8.483   1.363 -14.687  1.00  1.00          
ATOM    290  CB  GLU    19      -6.951   0.112 -13.876  1.00  1.00          
ATOM    291  HB1 GLU    19      -7.044  -0.762 -14.480  1.00  1.00          
ATOM    292  HB2 GLU    19      -6.669  -0.194 -12.881  1.00  1.00          
ATOM    293  CG  GLU    19      -5.837   0.985 -14.458  1.00  1.00          
ATOM    294  HG1 GLU    19      -5.715   1.857 -13.831  1.00  1.00          
ATOM    295  HG2 GLU    19      -6.124   1.295 -15.452  1.00  1.00          
ATOM    296  CD  GLU    19      -4.511   0.255 -14.541  1.00  1.00          
ATOM    297  OE1 GLU    19      -3.762   0.268 -13.542  1.00  1.00          
ATOM    298  OE2 GLU    19      -4.221  -0.332 -15.606  1.00  1.00          
ATOM    299  C   GLU    19      -9.394  -0.352 -13.738  1.00  1.00          
ATOM    300  O   GLU    19      -9.772  -0.895 -14.796  1.00  1.00          
ATOM    301  N   MET    20      -9.869  -0.662 -12.495  1.00  1.00          
ATOM    302  HN  MET    20      -9.596  -0.098 -11.738  1.00  1.00          
ATOM    303  CA  MET    20     -10.851  -1.732 -12.224  1.00  1.00          
ATOM    304  HA  MET    20     -10.869  -2.350 -13.108  1.00  1.00          
ATOM    305  CB  MET    20     -10.362  -2.600 -11.039  1.00  1.00          
ATOM    306  HB1 MET    20     -11.204  -3.141 -10.644  1.00  1.00          
ATOM    307  HB2 MET    20      -9.976  -1.948 -10.271  1.00  1.00          
ATOM    308  CG  MET    20      -9.271  -3.611 -11.399  1.00  1.00          
ATOM    309  HG1 MET    20      -8.427  -3.078 -11.810  1.00  1.00          
ATOM    310  HG2 MET    20      -9.661  -4.290 -12.143  1.00  1.00          
ATOM    311  SD  MET    20      -8.712  -4.575  -9.980  1.00  1.00          
ATOM    312  CE  MET    20      -9.788  -6.004 -10.086  1.00  1.00          
ATOM    313  HE1 MET    20      -9.826  -6.498  -9.128  1.00  1.00          
ATOM    314  HE2 MET    20      -9.405  -6.688 -10.829  1.00  1.00          
ATOM    315  HE3 MET    20     -10.781  -5.687 -10.369  1.00  1.00          
ATOM    316  C   MET    20     -12.301  -1.185 -11.975  1.00  1.00          
ATOM    317  O   MET    20     -13.238  -1.979 -11.741  1.00  1.00          
ATOM    318  N   LEU    21     -12.478   0.177 -12.072  1.00  1.00          
ATOM    319  HN  LEU    21     -11.693   0.723 -12.292  1.00  1.00          
ATOM    320  CA  LEU    21     -13.782   0.887 -11.867  1.00  1.00          
ATOM    321  HA  LEU    21     -14.289   0.374 -11.064  1.00  1.00          
ATOM    322  CB  LEU    21     -13.467   2.336 -11.407  1.00  1.00          
ATOM    323  HB1 LEU    21     -13.584   2.989 -12.261  1.00  1.00          
ATOM    324  HB2 LEU    21     -12.435   2.372 -11.093  1.00  1.00          
ATOM    325  CG  LEU    21     -14.335   2.892 -10.262  1.00  1.00          
ATOM    326  HG  LEU    21     -15.254   2.327 -10.201  1.00  1.00          
ATOM    327  CD1 LEU    21     -13.620   2.772  -8.918  1.00  1.00          
ATOM    328 HD11 LEU    21     -12.795   3.469  -8.885  1.00  1.00          
ATOM    329 HD12 LEU    21     -13.246   1.766  -8.798  1.00  1.00          
ATOM    330 HD13 LEU    21     -14.313   2.996  -8.120  1.00  1.00          
ATOM    331  CD2 LEU    21     -14.700   4.342 -10.537  1.00  1.00          
ATOM    332 HD21 LEU    21     -15.350   4.393 -11.397  1.00  1.00          
ATOM    333 HD22 LEU    21     -13.801   4.908 -10.730  1.00  1.00          
ATOM    334 HD23 LEU    21     -15.207   4.754  -9.677  1.00  1.00          
ATOM    335  C   LEU    21     -14.727   0.863 -13.135  1.00  1.00          
ATOM    336  O   LEU    21     -15.767   1.563 -13.176  1.00  1.00          
ATOM    337  N   ILE    22     -14.367  -0.011 -14.121  1.00  1.00          
ATOM    338  HN  ILE    22     -13.573  -0.559 -13.970  1.00  1.00          
ATOM    339  CA  ILE    22     -15.104  -0.215 -15.411  1.00  1.00          
ATOM    340  HA  ILE    22     -15.610   0.719 -15.613  1.00  1.00          
ATOM    341  CB  ILE    22     -14.139  -0.497 -16.648  1.00  1.00          
ATOM    342  HB  ILE    22     -14.761  -0.873 -17.439  1.00  1.00          
ATOM    343  CG1 ILE    22     -12.992  -1.534 -16.396  1.00  1.00          
ATOM    344 HG11 ILE    22     -13.044  -1.877 -15.372  1.00  1.00          
ATOM    345 HG12 ILE    22     -12.038  -1.053 -16.559  1.00  1.00          
ATOM    346  CG2 ILE    22     -13.533   0.810 -17.141  1.00  1.00          
ATOM    347 HG21 ILE    22     -12.992   1.277 -16.331  1.00  1.00          
ATOM    348 HG22 ILE    22     -14.317   1.471 -17.478  1.00  1.00          
ATOM    349 HG23 ILE    22     -12.856   0.608 -17.957  1.00  1.00          
ATOM    350  CD1 ILE    22     -13.061  -2.746 -17.301  1.00  1.00          
ATOM    351 HD11 ILE    22     -12.869  -2.447 -18.322  1.00  1.00          
ATOM    352 HD12 ILE    22     -14.045  -3.187 -17.235  1.00  1.00          
ATOM    353 HD13 ILE    22     -12.320  -3.470 -16.994  1.00  1.00          
ATOM    354  C   ILE    22     -16.215  -1.322 -15.323  1.00  1.00          
ATOM    355  O   ILE    22     -17.017  -1.469 -16.268  1.00  1.00          
ATOM    356  N   ILE    23     -16.246  -2.055 -14.171  1.00  1.00          
ATOM    357  HN  ILE    23     -15.585  -1.830 -13.484  1.00  1.00          
ATOM    358  CA  ILE    23     -17.214  -3.161 -13.879  1.00  1.00          
ATOM    359  HA  ILE    23     -17.643  -3.471 -14.825  1.00  1.00          
ATOM    360  CB  ILE    23     -16.551  -4.456 -13.175  1.00  1.00          
ATOM    361  HB  ILE    23     -16.448  -4.234 -12.120  1.00  1.00          
ATOM    362  CG1 ILE    23     -15.152  -4.836 -13.744  1.00  1.00          
ATOM    363 HG11 ILE    23     -14.885  -4.128 -14.517  1.00  1.00          
ATOM    364 HG12 ILE    23     -15.205  -5.823 -14.174  1.00  1.00          
ATOM    365  CG2 ILE    23     -17.446  -5.719 -13.302  1.00  1.00          
ATOM    366 HG21 ILE    23     -17.422  -6.076 -14.321  1.00  1.00          
ATOM    367 HG22 ILE    23     -18.461  -5.469 -13.032  1.00  1.00          
ATOM    368 HG23 ILE    23     -17.079  -6.490 -12.640  1.00  1.00          
ATOM    369  CD1 ILE    23     -14.038  -4.841 -12.711  1.00  1.00          
ATOM    370 HD11 ILE    23     -14.212  -5.629 -11.994  1.00  1.00          
ATOM    371 HD12 ILE    23     -14.012  -3.887 -12.201  1.00  1.00          
ATOM    372 HD13 ILE    23     -13.090  -5.007 -13.204  1.00  1.00          
ATOM    373  C   ILE    23     -18.357  -2.596 -12.990  1.00  1.00          
ATOM    374  O   ILE    23     -18.095  -1.832 -12.042  1.00  1.00          
ATOM    375  N   GLU    24     -19.615  -3.011 -13.335  1.00  1.00          
ATOM    376  HN  GLU    24     -19.700  -3.609 -14.107  1.00  1.00          
ATOM    377  CA  GLU    24     -20.878  -2.622 -12.613  1.00  1.00          
ATOM    378  HA  GLU    24     -20.795  -1.568 -12.408  1.00  1.00          
ATOM    379  CB  GLU    24     -22.112  -2.847 -13.495  1.00  1.00          
ATOM    380  HB1 GLU    24     -22.982  -2.924 -12.859  1.00  1.00          
ATOM    381  HB2 GLU    24     -21.989  -3.775 -14.032  1.00  1.00          
ATOM    382  CG  GLU    24     -22.360  -1.739 -14.511  1.00  1.00          
ATOM    383  HG1 GLU    24     -21.510  -1.680 -15.176  1.00  1.00          
ATOM    384  HG2 GLU    24     -22.468  -0.802 -13.983  1.00  1.00          
ATOM    385  CD  GLU    24     -23.610  -1.974 -15.337  1.00  1.00          
ATOM    386  OE1 GLU    24     -23.513  -2.654 -16.379  1.00  1.00          
ATOM    387  OE2 GLU    24     -24.686  -1.479 -14.939  1.00  1.00          
ATOM    388  C   GLU    24     -21.069  -3.339 -11.252  1.00  1.00          
ATOM    389  O   GLU    24     -21.730  -2.783 -10.360  1.00  1.00          
ATOM    390  N   ASN    25     -20.478  -4.575 -11.123  1.00  1.00          
ATOM    391  HN  ASN    25     -20.016  -4.937 -11.907  1.00  1.00          
ATOM    392  CA  ASN    25     -20.485  -5.413  -9.877  1.00  1.00          
ATOM    393  HA  ASN    25     -21.503  -5.455  -9.519  1.00  1.00          
ATOM    394  CB  ASN    25     -20.018  -6.835 -10.202  1.00  1.00          
ATOM    395  HB1 ASN    25     -19.629  -7.294  -9.305  1.00  1.00          
ATOM    396  HB2 ASN    25     -19.237  -6.792 -10.946  1.00  1.00          
ATOM    397  CG  ASN    25     -21.139  -7.703 -10.735  1.00  1.00          
ATOM    398  OD1 ASN    25     -21.366  -7.775 -11.943  1.00  1.00          
ATOM    399  ND2 ASN    25     -21.847  -8.370  -9.832  1.00  1.00          
ATOM    400 HD21 ASN    25     -21.609  -8.265  -8.887  1.00  1.00          
ATOM    401 HD22 ASN    25     -22.580  -8.940 -10.146  1.00  1.00          
ATOM    402  C   ASN    25     -19.587  -4.826  -8.745  1.00  1.00          
ATOM    403  O   ASN    25     -19.800  -5.128  -7.561  1.00  1.00          
ATOM    404  N   PHE    26     -18.579  -3.974  -9.164  1.00  1.00          
ATOM    405  HN  PHE    26     -18.479  -3.886 -10.131  1.00  1.00          
ATOM    406  CA  PHE    26     -17.585  -3.264  -8.287  1.00  1.00          
ATOM    407  HA  PHE    26     -17.010  -4.031  -7.794  1.00  1.00          
ATOM    408  CB  PHE    26     -16.615  -2.431  -9.145  1.00  1.00          
ATOM    409  HB1 PHE    26     -16.916  -1.401  -9.104  1.00  1.00          
ATOM    410  HB2 PHE    26     -16.679  -2.767 -10.166  1.00  1.00          
ATOM    411  CG  PHE    26     -15.159  -2.522  -8.700  1.00  1.00          
ATOM    412  CD1 PHE    26     -14.630  -1.587  -7.813  1.00  1.00          
ATOM    413  HD1 PHE    26     -15.259  -0.786  -7.451  1.00  1.00          
ATOM    414  CD2 PHE    26     -14.325  -3.548  -9.152  1.00  1.00          
ATOM    415  HD2 PHE    26     -14.718  -4.283  -9.840  1.00  1.00          
ATOM    416  CE1 PHE    26     -13.316  -1.672  -7.392  1.00  1.00          
ATOM    417  HE1 PHE    26     -12.922  -0.940  -6.702  1.00  1.00          
ATOM    418  CE2 PHE    26     -13.012  -3.634  -8.730  1.00  1.00          
ATOM    419  HE2 PHE    26     -12.384  -4.438  -9.082  1.00  1.00          
ATOM    420  CZ  PHE    26     -12.508  -2.696  -7.849  1.00  1.00          
ATOM    421  HZ  PHE    26     -11.480  -2.761  -7.520  1.00  1.00          
ATOM    422  C   PHE    26     -18.221  -2.379  -7.186  1.00  1.00          
ATOM    423  O   PHE    26     -17.657  -2.266  -6.085  1.00  1.00          
ATOM    424  N   GLU    27     -19.401  -1.766  -7.527  1.00  1.00          
ATOM    425  HN  GLU    27     -19.712  -1.879  -8.450  1.00  1.00          
ATOM    426  CA  GLU    27     -20.248  -0.926  -6.599  1.00  1.00          
ATOM    427  HA  GLU    27     -19.621  -0.140  -6.211  1.00  1.00          
ATOM    428  CB  GLU    27     -21.426  -0.290  -7.359  1.00  1.00          
ATOM    429  HB1 GLU    27     -22.166   0.029  -6.640  1.00  1.00          
ATOM    430  HB2 GLU    27     -21.866  -1.036  -8.002  1.00  1.00          
ATOM    431  CG  GLU    27     -21.055   0.915  -8.220  1.00  1.00          
ATOM    432  HG1 GLU    27     -20.294   0.616  -8.927  1.00  1.00          
ATOM    433  HG2 GLU    27     -20.662   1.691  -7.579  1.00  1.00          
ATOM    434  CD  GLU    27     -22.238   1.474  -8.985  1.00  1.00          
ATOM    435  OE1 GLU    27     -22.504   0.988 -10.104  1.00  1.00          
ATOM    436  OE2 GLU    27     -22.900   2.396  -8.465  1.00  1.00          
ATOM    437  C   GLU    27     -20.810  -1.753  -5.397  1.00  1.00          
ATOM    438  O   GLU    27     -21.054  -1.194  -4.316  1.00  1.00          
ATOM    439  N   GLU    28     -20.997  -3.093  -5.650  1.00  1.00          
ATOM    440  HN  GLU    28     -20.774  -3.414  -6.558  1.00  1.00          
ATOM    441  CA  GLU    28     -21.472  -4.102  -4.659  1.00  1.00          
ATOM    442  HA  GLU    28     -22.153  -3.600  -3.987  1.00  1.00          
ATOM    443  CB  GLU    28     -22.229  -5.230  -5.379  1.00  1.00          
ATOM    444  HB1 GLU    28     -22.140  -6.133  -4.791  1.00  1.00          
ATOM    445  HB2 GLU    28     -21.762  -5.395  -6.343  1.00  1.00          
ATOM    446  CG  GLU    28     -23.724  -4.942  -5.591  1.00  1.00          
ATOM    447  HG1 GLU    28     -24.047  -5.388  -6.524  1.00  1.00          
ATOM    448  HG2 GLU    28     -23.864  -3.873  -5.642  1.00  1.00          
ATOM    449  CD  GLU    28     -24.602  -5.487  -4.473  1.00  1.00          
ATOM    450  OE1 GLU    28     -24.852  -6.711  -4.457  1.00  1.00          
ATOM    451  OE2 GLU    28     -25.035  -4.688  -3.616  1.00  1.00          
ATOM    452  C   GLU    28     -20.313  -4.697  -3.816  1.00  1.00          
ATOM    453  O   GLU    28     -20.512  -4.990  -2.625  1.00  1.00          
ATOM    454  N   ILE    29     -19.100  -4.858  -4.465  1.00  1.00          
ATOM    455  HN  ILE    29     -19.056  -4.577  -5.402  1.00  1.00          
ATOM    456  CA  ILE    29     -17.826  -5.391  -3.839  1.00  1.00          
ATOM    457  HA  ILE    29     -18.119  -6.251  -3.247  1.00  1.00          
ATOM    458  CB  ILE    29     -16.741  -5.905  -4.933  1.00  1.00          
ATOM    459  HB  ILE    29     -16.436  -5.047  -5.515  1.00  1.00          
ATOM    460  CG1 ILE    29     -17.347  -6.982  -5.891  1.00  1.00          
ATOM    461 HG11 ILE    29     -18.421  -6.990  -5.770  1.00  1.00          
ATOM    462 HG12 ILE    29     -16.959  -7.948  -5.606  1.00  1.00          
ATOM    463  CG2 ILE    29     -15.462  -6.544  -4.282  1.00  1.00          
ATOM    464 HG21 ILE    29     -14.576  -6.253  -4.832  1.00  1.00          
ATOM    465 HG22 ILE    29     -15.553  -7.620  -4.293  1.00  1.00          
ATOM    466 HG23 ILE    29     -15.380  -6.204  -3.259  1.00  1.00          
ATOM    467  CD1 ILE    29     -17.050  -6.801  -7.383  1.00  1.00          
ATOM    468 HD11 ILE    29     -16.128  -6.252  -7.511  1.00  1.00          
ATOM    469 HD12 ILE    29     -17.859  -6.262  -7.849  1.00  1.00          
ATOM    470 HD13 ILE    29     -16.953  -7.772  -7.848  1.00  1.00          
ATOM    471  C   ILE    29     -17.214  -4.327  -2.842  1.00  1.00          
ATOM    472  O   ILE    29     -16.719  -4.716  -1.772  1.00  1.00          
ATOM    473  N   VAL    30     -17.268  -3.006  -3.232  1.00  1.00          
ATOM    474  HN  VAL    30     -17.681  -2.807  -4.098  1.00  1.00          
ATOM    475  CA  VAL    30     -16.734  -1.828  -2.423  1.00  1.00          
ATOM    476  HA  VAL    30     -15.699  -2.078  -2.227  1.00  1.00          
ATOM    477  CB  VAL    30     -16.721  -0.442  -3.218  1.00  1.00          
ATOM    478  HB  VAL    30     -16.463   0.331  -2.501  1.00  1.00          
ATOM    479  CG1 VAL    30     -15.615  -0.442  -4.273  1.00  1.00          
ATOM    480 HG11 VAL    30     -15.795  -1.240  -4.979  1.00  1.00          
ATOM    481 HG12 VAL    30     -14.659  -0.591  -3.794  1.00  1.00          
ATOM    482 HG13 VAL    30     -15.614   0.505  -4.794  1.00  1.00          
ATOM    483  CG2 VAL    30     -18.069  -0.038  -3.897  1.00  1.00          
ATOM    484 HG21 VAL    30     -18.619  -0.929  -4.165  1.00  1.00          
ATOM    485 HG22 VAL    30     -17.860   0.536  -4.785  1.00  1.00          
ATOM    486 HG23 VAL    30     -18.665   0.560  -3.215  1.00  1.00          
ATOM    487  C   VAL    30     -17.415  -1.633  -1.014  1.00  1.00          
ATOM    488  O   VAL    30     -16.859  -0.932  -0.153  1.00  1.00          
ATOM    489  N   LYS    31     -18.636  -2.226  -0.863  1.00  1.00          
ATOM    490  HN  LYS    31     -19.028  -2.656  -1.650  1.00  1.00          
ATOM    491  CA  LYS    31     -19.444  -2.219   0.392  1.00  1.00          
ATOM    492  HA  LYS    31     -19.268  -1.274   0.885  1.00  1.00          
ATOM    493  CB  LYS    31     -20.940  -2.313   0.040  1.00  1.00          
ATOM    494  HB1 LYS    31     -21.470  -2.734   0.881  1.00  1.00          
ATOM    495  HB2 LYS    31     -21.052  -2.971  -0.812  1.00  1.00          
ATOM    496  CG  LYS    31     -21.584  -0.977  -0.315  1.00  1.00          
ATOM    497  HG1 LYS    31     -21.051  -0.540  -1.148  1.00  1.00          
ATOM    498  HG2 LYS    31     -21.524  -0.319   0.538  1.00  1.00          
ATOM    499  CD  LYS    31     -23.045  -1.151  -0.700  1.00  1.00          
ATOM    500  HD1 LYS    31     -23.576  -1.590   0.132  1.00  1.00          
ATOM    501  HD2 LYS    31     -23.107  -1.807  -1.556  1.00  1.00          
ATOM    502  CE  LYS    31     -23.687   0.179  -1.051  1.00  1.00          
ATOM    503  HE1 LYS    31     -23.146   0.619  -1.876  1.00  1.00          
ATOM    504  HE2 LYS    31     -23.625   0.831  -0.192  1.00  1.00          
ATOM    505  NZ  LYS    31     -25.115   0.020  -1.436  1.00  1.00          
ATOM    506  HZ1 LYS    31     -25.704   0.696  -0.909  1.00  1.00          
ATOM    507  HZ2 LYS    31     -25.437  -0.944  -1.220  1.00  1.00          
ATOM    508  HZ3 LYS    31     -25.232   0.194  -2.454  1.00  1.00          
ATOM    509  C   LYS    31     -19.066  -3.363   1.384  1.00  1.00          
ATOM    510  O   LYS    31     -19.371  -3.241   2.589  1.00  1.00          
ATOM    511  N   ASP    32     -18.396  -4.444   0.865  1.00  1.00          
ATOM    512  HN  ASP    32     -18.170  -4.432  -0.083  1.00  1.00          
ATOM    513  CA  ASP    32     -17.971  -5.618   1.658  1.00  1.00          
ATOM    514  HA  ASP    32     -18.111  -5.363   2.699  1.00  1.00          
ATOM    515  CB  ASP    32     -18.850  -6.851   1.334  1.00  1.00          
ATOM    516  HB1 ASP    32     -18.332  -7.743   1.651  1.00  1.00          
ATOM    517  HB2 ASP    32     -19.015  -6.897   0.269  1.00  1.00          
ATOM    518  CG  ASP    32     -20.200  -6.811   2.024  1.00  1.00          
ATOM    519  OD1 ASP    32     -20.245  -7.024   3.253  1.00  1.00          
ATOM    520  OD2 ASP    32     -21.210  -6.566   1.333  1.00  1.00          
ATOM    521  C   ASP    32     -16.477  -5.937   1.447  1.00  1.00          
ATOM    522  O   ASP    32     -16.038  -6.313   0.338  1.00  1.00          
ATOM    523  N   ARG    33     -15.696  -5.696   2.541  1.00  1.00          
ATOM    524  HN  ARG    33     -16.114  -5.203   3.272  1.00  1.00          
ATOM    525  CA  ARG    33     -14.203  -5.966   2.657  1.00  1.00          
ATOM    526  HA  ARG    33     -13.747  -5.429   1.839  1.00  1.00          
ATOM    527  CB  ARG    33     -13.602  -5.390   3.997  1.00  1.00          
ATOM    528  HB1 ARG    33     -13.539  -4.316   3.898  1.00  1.00          
ATOM    529  HB2 ARG    33     -12.598  -5.775   4.096  1.00  1.00          
ATOM    530  CG  ARG    33     -14.364  -5.685   5.329  1.00  1.00          
ATOM    531  HG1 ARG    33     -13.681  -6.081   6.070  1.00  1.00          
ATOM    532  HG2 ARG    33     -15.143  -6.407   5.134  1.00  1.00          
ATOM    533  CD  ARG    33     -14.998  -4.414   5.870  1.00  1.00          
ATOM    534  HD1 ARG    33     -15.615  -3.981   5.098  1.00  1.00          
ATOM    535  HD2 ARG    33     -14.211  -3.721   6.131  1.00  1.00          
ATOM    536  NE  ARG    33     -15.833  -4.661   7.070  1.00  1.00          
ATOM    537  HE  ARG    33     -15.828  -5.580   7.413  1.00  1.00          
ATOM    538  CZ  ARG    33     -16.606  -3.750   7.740  1.00  1.00          
ATOM    539  NH1 ARG    33     -16.704  -2.449   7.390  1.00  1.00          
ATOM    540 HH11 ARG    33     -16.194  -2.102   6.603  1.00  1.00          
ATOM    541 HH12 ARG    33     -17.284  -1.831   7.920  1.00  1.00          
ATOM    542  NH2 ARG    33     -17.294  -4.164   8.792  1.00  1.00          
ATOM    543 HH21 ARG    33     -17.242  -5.121   9.077  1.00  1.00          
ATOM    544 HH22 ARG    33     -17.866  -3.520   9.300  1.00  1.00          
ATOM    545  C   ARG    33     -13.775  -7.453   2.472  1.00  1.00          
ATOM    546  O   ARG    33     -12.675  -7.709   1.954  1.00  1.00          
ATOM    547  N   GLU    34     -14.667  -8.401   2.897  1.00  1.00          
ATOM    548  HN  GLU    34     -15.495  -8.092   3.316  1.00  1.00          
ATOM    549  CA  GLU    34     -14.475  -9.886   2.784  1.00  1.00          
ATOM    550  HA  GLU    34     -13.504 -10.117   3.193  1.00  1.00          
ATOM    551  CB  GLU    34     -15.540 -10.592   3.625  1.00  1.00          
ATOM    552  HB1 GLU    34     -16.262 -11.039   2.963  1.00  1.00          
ATOM    553  HB2 GLU    34     -16.036  -9.854   4.236  1.00  1.00          
ATOM    554  CG  GLU    34     -14.990 -11.675   4.546  1.00  1.00          
ATOM    555  HG1 GLU    34     -14.239 -11.239   5.188  1.00  1.00          
ATOM    556  HG2 GLU    34     -14.541 -12.449   3.942  1.00  1.00          
ATOM    557  CD  GLU    34     -16.066 -12.303   5.413  1.00  1.00          
ATOM    558  OE1 GLU    34     -16.255 -11.841   6.559  1.00  1.00          
ATOM    559  OE2 GLU    34     -16.719 -13.259   4.945  1.00  1.00          
ATOM    560  C   GLU    34     -14.514 -10.404   1.313  1.00  1.00          
ATOM    561  O   GLU    34     -13.832 -11.393   0.994  1.00  1.00          
ATOM    562  N   ARG    35     -15.331  -9.710   0.452  1.00  1.00          
ATOM    563  HN  ARG    35     -15.848  -8.961   0.818  1.00  1.00          
ATOM    564  CA  ARG    35     -15.478  -9.994  -1.009  1.00  1.00          
ATOM    565  HA  ARG    35     -15.418 -11.066  -1.131  1.00  1.00          
ATOM    566  CB  ARG    35     -16.844  -9.520  -1.541  1.00  1.00          
ATOM    567  HB1 ARG    35     -16.792  -9.468  -2.618  1.00  1.00          
ATOM    568  HB2 ARG    35     -17.038  -8.531  -1.156  1.00  1.00          
ATOM    569  CG  ARG    35     -18.031 -10.418  -1.163  1.00  1.00          
ATOM    570  HG1 ARG    35     -18.078 -10.489  -0.085  1.00  1.00          
ATOM    571  HG2 ARG    35     -17.868 -11.400  -1.579  1.00  1.00          
ATOM    572  CD  ARG    35     -19.369  -9.878  -1.689  1.00  1.00          
ATOM    573  HD1 ARG    35     -19.407  -8.815  -1.500  1.00  1.00          
ATOM    574  HD2 ARG    35     -20.176 -10.363  -1.158  1.00  1.00          
ATOM    575  NE  ARG    35     -19.561 -10.110  -3.154  1.00  1.00          
ATOM    576  HE  ARG    35     -18.986 -10.795  -3.555  1.00  1.00          
ATOM    577  CZ  ARG    35     -20.439  -9.469  -3.988  1.00  1.00          
ATOM    578  NH1 ARG    35     -21.296  -8.515  -3.576  1.00  1.00          
ATOM    579 HH11 ARG    35     -21.313  -8.240  -2.614  1.00  1.00          
ATOM    580 HH12 ARG    35     -21.916  -8.082  -4.230  1.00  1.00          
ATOM    581  NH2 ARG    35     -20.453  -9.807  -5.271  1.00  1.00          
ATOM    582 HH21 ARG    35     -19.831 -10.513  -5.608  1.00  1.00          
ATOM    583 HH22 ARG    35     -21.085  -9.354  -5.900  1.00  1.00          
ATOM    584  C   ARG    35     -14.353  -9.351  -1.865  1.00  1.00          
ATOM    585  O   ARG    35     -13.937  -9.953  -2.870  1.00  1.00          
ATOM    586  N   PHE    36     -13.872  -8.120  -1.439  1.00  1.00          
ATOM    587  HN  PHE    36     -14.272  -7.734  -0.632  1.00  1.00          
ATOM    588  CA  PHE    36     -12.788  -7.335  -2.119  1.00  1.00          
ATOM    589  HA  PHE    36     -13.032  -7.321  -3.175  1.00  1.00          
ATOM    590  CB  PHE    36     -12.768  -5.860  -1.604  1.00  1.00          
ATOM    591  HB1 PHE    36     -12.121  -5.808  -0.739  1.00  1.00          
ATOM    592  HB2 PHE    36     -13.766  -5.584  -1.306  1.00  1.00          
ATOM    593  CG  PHE    36     -12.276  -4.810  -2.611  1.00  1.00          
ATOM    594  CD1 PHE    36     -13.182  -4.017  -3.308  1.00  1.00          
ATOM    595  HD1 PHE    36     -14.239  -4.142  -3.138  1.00  1.00          
ATOM    596  CD2 PHE    36     -10.912  -4.619  -2.851  1.00  1.00          
ATOM    597  HD2 PHE    36     -10.191  -5.227  -2.322  1.00  1.00          
ATOM    598  CE1 PHE    36     -12.745  -3.066  -4.213  1.00  1.00          
ATOM    599  HE1 PHE    36     -13.462  -2.457  -4.749  1.00  1.00          
ATOM    600  CE2 PHE    36     -10.477  -3.670  -3.756  1.00  1.00          
ATOM    601  HE2 PHE    36      -9.420  -3.537  -3.933  1.00  1.00          
ATOM    602  CZ  PHE    36     -11.394  -2.894  -4.437  1.00  1.00          
ATOM    603  HZ  PHE    36     -11.055  -2.152  -5.144  1.00  1.00          
ATOM    604  C   PHE    36     -11.381  -7.994  -1.962  1.00  1.00          
ATOM    605  O   PHE    36     -10.656  -8.096  -2.957  1.00  1.00          
ATOM    606  N   LEU    37     -11.045  -8.465  -0.705  1.00  1.00          
ATOM    607  HN  LEU    37     -11.712  -8.391   0.008  1.00  1.00          
ATOM    608  CA  LEU    37      -9.748  -9.152  -0.357  1.00  1.00          
ATOM    609  HA  LEU    37      -8.952  -8.547  -0.765  1.00  1.00          
ATOM    610  CB  LEU    37      -9.569  -9.231   1.169  1.00  1.00          
ATOM    611  HB1 LEU    37      -8.934 -10.076   1.387  1.00  1.00          
ATOM    612  HB2 LEU    37     -10.538  -9.411   1.609  1.00  1.00          
ATOM    613  CG  LEU    37      -8.960  -7.990   1.838  1.00  1.00          
ATOM    614  HG  LEU    37      -9.017  -7.151   1.159  1.00  1.00          
ATOM    615  CD1 LEU    37      -9.735  -7.625   3.094  1.00  1.00          
ATOM    616 HD11 LEU    37      -9.264  -6.779   3.570  1.00  1.00          
ATOM    617 HD12 LEU    37      -9.736  -8.465   3.774  1.00  1.00          
ATOM    618 HD13 LEU    37     -10.751  -7.371   2.833  1.00  1.00          
ATOM    619  CD2 LEU    37      -7.493  -8.232   2.176  1.00  1.00          
ATOM    620 HD21 LEU    37      -7.421  -8.983   2.948  1.00  1.00          
ATOM    621 HD22 LEU    37      -7.048  -7.312   2.526  1.00  1.00          
ATOM    622 HD23 LEU    37      -6.971  -8.571   1.294  1.00  1.00          
ATOM    623  C   LEU    37      -9.625 -10.575  -0.974  1.00  1.00          
ATOM    624  O   LEU    37      -8.521 -10.988  -1.362  1.00  1.00          
ATOM    625  N   ALA    38     -10.798 -11.295  -1.035  1.00  1.00          
ATOM    626  HN  ALA    38     -11.594 -10.860  -0.661  1.00  1.00          
ATOM    627  CA  ALA    38     -10.947 -12.662  -1.630  1.00  1.00          
ATOM    628  HA  ALA    38     -10.133 -13.267  -1.257  1.00  1.00          
ATOM    629  CB  ALA    38     -12.249 -13.289  -1.162  1.00  1.00          
ATOM    630  HB1 ALA    38     -13.082 -12.721  -1.550  1.00  1.00          
ATOM    631  HB2 ALA    38     -12.280 -13.285  -0.084  1.00  1.00          
ATOM    632  HB3 ALA    38     -12.308 -14.305  -1.522  1.00  1.00          
ATOM    633  C   ALA    38     -10.885 -12.664  -3.184  1.00  1.00          
ATOM    634  O   ALA    38     -10.445 -13.661  -3.780  1.00  1.00          
ATOM    635  N   GLN    39     -11.334 -11.518  -3.802  1.00  1.00          
ATOM    636  HN  GLN    39     -11.679 -10.803  -3.227  1.00  1.00          
ATOM    637  CA  GLN    39     -11.334 -11.274  -5.273  1.00  1.00          
ATOM    638  HA  GLN    39     -11.622 -12.199  -5.749  1.00  1.00          
ATOM    639  CB  GLN    39     -12.363 -10.202  -5.635  1.00  1.00          
ATOM    640  HB1 GLN    39     -11.849  -9.350  -6.053  1.00  1.00          
ATOM    641  HB2 GLN    39     -12.880  -9.896  -4.736  1.00  1.00          
ATOM    642  CG  GLN    39     -13.400 -10.677  -6.644  1.00  1.00          
ATOM    643  HG1 GLN    39     -13.877 -11.568  -6.261  1.00  1.00          
ATOM    644  HG2 GLN    39     -12.897 -10.910  -7.571  1.00  1.00          
ATOM    645  CD  GLN    39     -14.469  -9.637  -6.925  1.00  1.00          
ATOM    646  OE1 GLN    39     -15.366  -9.414  -6.110  1.00  1.00          
ATOM    647  NE2 GLN    39     -14.376  -8.993  -8.084  1.00  1.00          
ATOM    648 HE21 GLN    39     -13.634  -9.222  -8.682  1.00  1.00          
ATOM    649 HE22 GLN    39     -15.051  -8.313  -8.293  1.00  1.00          
ATOM    650  C   GLN    39      -9.942 -10.870  -5.820  1.00  1.00          
ATOM    651  O   GLN    39      -9.610 -11.243  -6.947  1.00  1.00          
ATOM    652  N   VAL    40      -9.143 -10.104  -4.991  1.00  1.00          
ATOM    653  HN  VAL    40      -9.520  -9.838  -4.126  1.00  1.00          
ATOM    654  CA  VAL    40      -7.728  -9.640  -5.307  1.00  1.00          
ATOM    655  HA  VAL    40      -7.751  -9.261  -6.322  1.00  1.00          
ATOM    656  CB  VAL    40      -7.265  -8.421  -4.339  1.00  1.00          
ATOM    657  HB  VAL    40      -7.399  -8.743  -3.318  1.00  1.00          
ATOM    658  CG1 VAL    40      -5.795  -7.949  -4.503  1.00  1.00          
ATOM    659 HG11 VAL    40      -5.139  -8.808  -4.525  1.00  1.00          
ATOM    660 HG12 VAL    40      -5.525  -7.310  -3.674  1.00  1.00          
ATOM    661 HG13 VAL    40      -5.699  -7.397  -5.425  1.00  1.00          
ATOM    662  CG2 VAL    40      -8.144  -7.179  -4.545  1.00  1.00          
ATOM    663 HG21 VAL    40      -7.837  -6.403  -3.859  1.00  1.00          
ATOM    664 HG22 VAL    40      -9.177  -7.436  -4.359  1.00  1.00          
ATOM    665 HG23 VAL    40      -8.038  -6.826  -5.560  1.00  1.00          
ATOM    666  C   VAL    40      -6.740 -10.881  -5.289  1.00  1.00          
ATOM    667  O   VAL    40      -5.847 -10.964  -6.145  1.00  1.00          
ATOM    668  N   GLU    41      -6.948 -11.810  -4.291  1.00  1.00          
ATOM    669  HN  GLU    41      -7.679 -11.648  -3.658  1.00  1.00          
ATOM    670  CA  GLU    41      -6.156 -13.082  -4.095  1.00  1.00          
ATOM    671  HA  GLU    41      -5.108 -12.825  -4.137  1.00  1.00          
ATOM    672  CB  GLU    41      -6.452 -13.705  -2.709  1.00  1.00          
ATOM    673  HB1 GLU    41      -6.060 -14.711  -2.697  1.00  1.00          
ATOM    674  HB2 GLU    41      -7.523 -13.753  -2.579  1.00  1.00          
ATOM    675  CG  GLU    41      -5.870 -12.953  -1.514  1.00  1.00          
ATOM    676  HG1 GLU    41      -6.341 -11.983  -1.456  1.00  1.00          
ATOM    677  HG2 GLU    41      -4.807 -12.831  -1.658  1.00  1.00          
ATOM    678  CD  GLU    41      -6.102 -13.679  -0.203  1.00  1.00          
ATOM    679  OE1 GLU    41      -5.208 -14.441   0.221  1.00  1.00          
ATOM    680  OE2 GLU    41      -7.181 -13.490   0.398  1.00  1.00          
ATOM    681  C   GLU    41      -6.445 -14.160  -5.187  1.00  1.00          
ATOM    682  O   GLU    41      -5.529 -14.908  -5.569  1.00  1.00          
ATOM    683  N   GLU    42      -7.733 -14.199  -5.664  1.00  1.00          
ATOM    684  HN  GLU    42      -8.370 -13.556  -5.289  1.00  1.00          
ATOM    685  CA  GLU    42      -8.241 -15.144  -6.708  1.00  1.00          
ATOM    686  HA  GLU    42      -7.747 -16.091  -6.555  1.00  1.00          
ATOM    687  CB  GLU    42      -9.754 -15.348  -6.525  1.00  1.00          
ATOM    688  HB1 GLU    42     -10.174 -15.660  -7.470  1.00  1.00          
ATOM    689  HB2 GLU    42     -10.193 -14.399  -6.246  1.00  1.00          
ATOM    690  CG  GLU    42     -10.128 -16.400  -5.465  1.00  1.00          
ATOM    691  HG1 GLU    42     -11.041 -16.098  -4.963  1.00  1.00          
ATOM    692  HG2 GLU    42      -9.329 -16.457  -4.741  1.00  1.00          
ATOM    693  CD  GLU    42     -10.343 -17.788  -6.050  1.00  1.00          
ATOM    694  OE1 GLU    42     -11.404 -18.017  -6.671  1.00  1.00          
ATOM    695  OE2 GLU    42      -9.448 -18.645  -5.886  1.00  1.00          
ATOM    696  C   GLU    42      -7.966 -14.678  -8.166  1.00  1.00          
ATOM    697  O   GLU    42      -7.851 -15.532  -9.064  1.00  1.00          
ATOM    698  N   PHE    43      -7.863 -13.330  -8.362  1.00  1.00          
ATOM    699  HN  PHE    43      -7.937 -12.758  -7.569  1.00  1.00          
ATOM    700  CA  PHE    43      -7.604 -12.686  -9.673  1.00  1.00          
ATOM    701  HA  PHE    43      -7.862 -13.398 -10.445  1.00  1.00          
ATOM    702  CB  PHE    43      -8.487 -11.424  -9.835  1.00  1.00          
ATOM    703  HB1 PHE    43      -7.853 -10.550  -9.784  1.00  1.00          
ATOM    704  HB2 PHE    43      -9.194 -11.389  -9.022  1.00  1.00          
ATOM    705  CG  PHE    43      -9.276 -11.347 -11.127  1.00  1.00          
ATOM    706  CD1 PHE    43     -10.564 -11.868 -11.206  1.00  1.00          
ATOM    707  HD1 PHE    43     -10.997 -12.342 -10.337  1.00  1.00          
ATOM    708  CD2 PHE    43      -8.737 -10.740 -12.258  1.00  1.00          
ATOM    709  HD2 PHE    43      -7.740 -10.329 -12.214  1.00  1.00          
ATOM    710  CE1 PHE    43     -11.290 -11.788 -12.379  1.00  1.00          
ATOM    711  HE1 PHE    43     -12.288 -12.196 -12.425  1.00  1.00          
ATOM    712  CE2 PHE    43      -9.462 -10.660 -13.432  1.00  1.00          
ATOM    713  HE2 PHE    43      -9.031 -10.188 -14.303  1.00  1.00          
ATOM    714  CZ  PHE    43     -10.739 -11.184 -13.492  1.00  1.00          
ATOM    715  HZ  PHE    43     -11.306 -11.121 -14.409  1.00  1.00          
ATOM    716  C   PHE    43      -6.116 -12.316  -9.823  1.00  1.00          
ATOM    717  O   PHE    43      -5.436 -12.046  -8.809  1.00  1.00          
ATOM    718  N   VAL    44      -5.646 -12.290 -11.099  1.00  1.00          
ATOM    719  HN  VAL    44      -6.276 -12.457 -11.830  1.00  1.00          
ATOM    720  CA  VAL    44      -4.253 -11.972 -11.451  1.00  1.00          
ATOM    721  HA  VAL    44      -3.713 -11.937 -10.512  1.00  1.00          
ATOM    722  CB  VAL    44      -3.627 -13.177 -12.308  1.00  1.00          
ATOM    723  HB  VAL    44      -4.051 -14.083 -11.887  1.00  1.00          
ATOM    724  CG1 VAL    44      -3.969 -13.214 -13.814  1.00  1.00          
ATOM    725 HG11 VAL    44      -5.012 -12.979 -13.954  1.00  1.00          
ATOM    726 HG12 VAL    44      -3.761 -14.197 -14.212  1.00  1.00          
ATOM    727 HG13 VAL    44      -3.357 -12.481 -14.331  1.00  1.00          
ATOM    728  CG2 VAL    44      -2.115 -13.281 -12.114  1.00  1.00          
ATOM    729 HG21 VAL    44      -1.894 -13.608 -11.106  1.00  1.00          
ATOM    730 HG22 VAL    44      -1.667 -12.313 -12.281  1.00  1.00          
ATOM    731 HG23 VAL    44      -1.711 -13.991 -12.820  1.00  1.00          
ATOM    732  C   VAL    44      -4.173 -10.529 -12.072  1.00  1.00          
ATOM    733  O   VAL    44      -5.123 -10.090 -12.753  1.00  1.00          
ATOM    734  N   PHE    45      -3.024  -9.853 -11.825  1.00  1.00          
ATOM    735  HN  PHE    45      -2.310 -10.311 -11.336  1.00  1.00          
ATOM    736  CA  PHE    45      -2.760  -8.460 -12.291  1.00  1.00          
ATOM    737  HA  PHE    45      -3.609  -8.149 -12.882  1.00  1.00          
ATOM    738  CB  PHE    45      -2.596  -7.484 -11.088  1.00  1.00          
ATOM    739  HB1 PHE    45      -2.402  -6.494 -11.480  1.00  1.00          
ATOM    740  HB2 PHE    45      -1.745  -7.793 -10.507  1.00  1.00          
ATOM    741  CG  PHE    45      -3.782  -7.372 -10.139  1.00  1.00          
ATOM    742  CD1 PHE    45      -3.855  -8.180  -9.013  1.00  1.00          
ATOM    743  HD1 PHE    45      -3.068  -8.895  -8.822  1.00  1.00          
ATOM    744  CD2 PHE    45      -4.802  -6.457 -10.368  1.00  1.00          
ATOM    745  HD2 PHE    45      -4.759  -5.823 -11.241  1.00  1.00          
ATOM    746  CE1 PHE    45      -4.918  -8.079  -8.137  1.00  1.00          
ATOM    747  HE1 PHE    45      -4.959  -8.717  -7.266  1.00  1.00          
ATOM    748  CE2 PHE    45      -5.869  -6.355  -9.495  1.00  1.00          
ATOM    749  HE2 PHE    45      -6.657  -5.640  -9.685  1.00  1.00          
ATOM    750  CZ  PHE    45      -5.927  -7.166  -8.377  1.00  1.00          
ATOM    751  HZ  PHE    45      -6.758  -7.085  -7.691  1.00  1.00          
ATOM    752  C   PHE    45      -1.496  -8.411 -13.176  1.00  1.00          
ATOM    753  O   PHE    45      -0.585  -9.239 -13.001  1.00  1.00          
ATOM    754  N   LYS    46      -1.461  -7.419 -14.111  1.00  1.00          
ATOM    755  HN  LYS    46      -2.215  -6.796 -14.144  1.00  1.00          
ATOM    756  CA  LYS    46      -0.337  -7.215 -15.069  1.00  1.00          
ATOM    757  HA  LYS    46       0.244  -8.125 -15.090  1.00  1.00          
ATOM    758  CB  LYS    46      -0.874  -6.933 -16.487  1.00  1.00          
ATOM    759  HB1 LYS    46      -0.082  -6.487 -17.073  1.00  1.00          
ATOM    760  HB2 LYS    46      -1.688  -6.229 -16.413  1.00  1.00          
ATOM    761  CG  LYS    46      -1.381  -8.167 -17.233  1.00  1.00          
ATOM    762  HG1 LYS    46      -2.151  -8.641 -16.640  1.00  1.00          
ATOM    763  HG2 LYS    46      -0.560  -8.855 -17.375  1.00  1.00          
ATOM    764  CD  LYS    46      -1.959  -7.804 -18.591  1.00  1.00          
ATOM    765  HD1 LYS    46      -1.178  -7.371 -19.200  1.00  1.00          
ATOM    766  HD2 LYS    46      -2.751  -7.084 -18.453  1.00  1.00          
ATOM    767  CE  LYS    46      -2.519  -9.025 -19.303  1.00  1.00          
ATOM    768  HE1 LYS    46      -3.269  -9.481 -18.671  1.00  1.00          
ATOM    769  HE2 LYS    46      -1.717  -9.728 -19.471  1.00  1.00          
ATOM    770  NZ  LYS    46      -3.136  -8.676 -20.612  1.00  1.00          
ATOM    771  HZ1 LYS    46      -2.398  -8.563 -21.336  1.00  1.00          
ATOM    772  HZ2 LYS    46      -3.666  -7.785 -20.532  1.00  1.00          
ATOM    773  HZ3 LYS    46      -3.789  -9.428 -20.912  1.00  1.00          
ATOM    774  C   LYS    46       0.572  -6.065 -14.623  1.00  1.00          
ATOM    775  O   LYS    46       0.070  -5.042 -14.119  1.00  1.00          
ATOM    776  N   CYS    47       1.910  -6.257 -14.833  1.00  1.00          
ATOM    777  HN  CYS    47       2.196  -7.098 -15.249  1.00  1.00          
ATOM    778  CA  CYS    47       2.953  -5.266 -14.472  1.00  1.00          
ATOM    779  HA  CYS    47       2.533  -4.623 -13.712  1.00  1.00          
ATOM    780  HB1 CYS    47       4.711  -6.497 -14.684  1.00  1.00          
ATOM    781  HB2 CYS    47       3.904  -6.672 -13.134  1.00  1.00          
ATOM    782  C   CYS    47       3.345  -4.372 -15.704  1.00  1.00          
ATOM    783  O   CYS    47       3.766  -4.951 -16.732  1.00  1.00          
ATOM    784  CB  CYS    47       4.208  -5.966 -13.888  1.00  1.00          
ATOM    785  SG  CYS    47       5.427  -4.827 -13.126  1.00  1.00          
ATOM    786  N   PRO    48       3.164  -2.947 -15.672  1.00  1.00          
ATOM    787  CA  PRO    48       3.583  -2.056 -16.816  1.00  1.00          
ATOM    788  HA  PRO    48       3.246  -2.481 -17.754  1.00  1.00          
ATOM    789  CB  PRO    48       2.813  -0.732 -16.554  1.00  1.00          
ATOM    790  HB1 PRO    48       1.880  -0.736 -17.109  1.00  1.00          
ATOM    791  HB2 PRO    48       3.419   0.101 -16.888  1.00  1.00          
ATOM    792  CG  PRO    48       2.565  -0.676 -15.066  1.00  1.00          
ATOM    793  HG1 PRO    48       1.637  -0.148 -14.863  1.00  1.00          
ATOM    794  HG2 PRO    48       3.389  -0.167 -14.575  1.00  1.00          
ATOM    795  CD  PRO    48       2.475  -2.119 -14.597  1.00  1.00          
ATOM    796  HD1 PRO    48       1.438  -2.422 -14.504  1.00  1.00          
ATOM    797  HD2 PRO    48       2.978  -2.245 -13.647  1.00  1.00          
ATOM    798  C   PRO    48       5.134  -1.808 -16.941  1.00  1.00          
ATOM    799  O   PRO    48       5.580  -1.215 -17.942  1.00  1.00          
ATOM    800  N   VAL    49       5.914  -2.285 -15.914  1.00  1.00          
ATOM    801  HN  VAL    49       5.466  -2.773 -15.190  1.00  1.00          
ATOM    802  CA  VAL    49       7.410  -2.126 -15.828  1.00  1.00          
ATOM    803  HA  VAL    49       7.655  -1.220 -16.367  1.00  1.00          
ATOM    804  CB  VAL    49       7.997  -1.978 -14.329  1.00  1.00          
ATOM    805  HB  VAL    49       8.270  -2.973 -13.995  1.00  1.00          
ATOM    806  CG1 VAL    49       9.286  -1.133 -14.304  1.00  1.00          
ATOM    807 HG11 VAL    49       9.728  -1.179 -13.319  1.00  1.00          
ATOM    808 HG12 VAL    49       9.051  -0.107 -14.545  1.00  1.00          
ATOM    809 HG13 VAL    49       9.985  -1.521 -15.031  1.00  1.00          
ATOM    810  CG2 VAL    49       7.014  -1.365 -13.292  1.00  1.00          
ATOM    811 HG21 VAL    49       7.520  -0.592 -12.735  1.00  1.00          
ATOM    812 HG22 VAL    49       6.661  -2.128 -12.608  1.00  1.00          
ATOM    813 HG23 VAL    49       6.169  -0.937 -13.811  1.00  1.00          
ATOM    814  C   VAL    49       8.125  -3.313 -16.556  1.00  1.00          
ATOM    815  O   VAL    49       8.993  -3.056 -17.414  1.00  1.00          
ATOM    816  N   CYS    50       7.739  -4.573 -16.193  1.00  1.00          
ATOM    817  HN  CYS    50       7.043  -4.666 -15.510  1.00  1.00          
ATOM    818  CA  CYS    50       8.316  -5.799 -16.777  1.00  1.00          
ATOM    819  HA  CYS    50       9.232  -5.497 -17.267  1.00  1.00          
ATOM    820  HB1 CYS    50       9.375  -6.333 -15.000  1.00  1.00          
ATOM    821  HB2 CYS    50       9.172  -7.660 -16.127  1.00  1.00          
ATOM    822  C   CYS    50       7.403  -6.411 -17.860  1.00  1.00          
ATOM    823  O   CYS    50       7.904  -6.697 -18.965  1.00  1.00          
ATOM    824  CB  CYS    50       8.686  -6.811 -15.671  1.00  1.00          
ATOM    825  SG  CYS    50       7.291  -7.452 -14.676  1.00  1.00          
ATOM    826  N   GLY    51       6.086  -6.606 -17.531  1.00  1.00          
ATOM    827  HN  GLY    51       5.807  -6.447 -16.602  1.00  1.00          
ATOM    828  CA  GLY    51       5.095  -7.163 -18.482  1.00  1.00          
ATOM    829  HA1 GLY    51       5.587  -7.312 -19.433  1.00  1.00          
ATOM    830  HA2 GLY    51       4.309  -6.438 -18.617  1.00  1.00          
ATOM    831  C   GLY    51       4.452  -8.493 -18.053  1.00  1.00          
ATOM    832  O   GLY    51       3.428  -8.877 -18.644  1.00  1.00          
ATOM    833  N   GLU    52       5.054  -9.183 -17.026  1.00  1.00          
ATOM    834  HN  GLU    52       5.868  -8.795 -16.642  1.00  1.00          
ATOM    835  CA  GLU    52       4.571 -10.482 -16.473  1.00  1.00          
ATOM    836  HA  GLU    52       4.185 -11.058 -17.302  1.00  1.00          
ATOM    837  CB  GLU    52       5.752 -11.251 -15.856  1.00  1.00          
ATOM    838  HB1 GLU    52       5.394 -11.825 -15.014  1.00  1.00          
ATOM    839  HB2 GLU    52       6.489 -10.542 -15.511  1.00  1.00          
ATOM    840  CG  GLU    52       6.425 -12.204 -16.834  1.00  1.00          
ATOM    841  HG1 GLU    52       6.781 -11.636 -17.680  1.00  1.00          
ATOM    842  HG2 GLU    52       5.697 -12.928 -17.168  1.00  1.00          
ATOM    843  CD  GLU    52       7.596 -12.946 -16.222  1.00  1.00          
ATOM    844  OE1 GLU    52       8.722 -12.408 -16.254  1.00  1.00          
ATOM    845  OE2 GLU    52       7.387 -14.067 -15.710  1.00  1.00          
ATOM    846  C   GLU    52       3.428 -10.301 -15.440  1.00  1.00          
ATOM    847  O   GLU    52       3.339  -9.245 -14.787  1.00  1.00          
ATOM    848  N   GLU    53       2.574 -11.365 -15.317  1.00  1.00          
ATOM    849  HN  GLU    53       2.767 -12.169 -15.843  1.00  1.00          
ATOM    850  CA  GLU    53       1.381 -11.411 -14.420  1.00  1.00          
ATOM    851  HA  GLU    53       0.974 -10.414 -14.346  1.00  1.00          
ATOM    852  CB  GLU    53       0.304 -12.324 -15.040  1.00  1.00          
ATOM    853  HB1 GLU    53      -0.391 -12.615 -14.270  1.00  1.00          
ATOM    854  HB2 GLU    53       0.784 -13.211 -15.429  1.00  1.00          
ATOM    855  CG  GLU    53      -0.490 -11.674 -16.179  1.00  1.00          
ATOM    856  HG1 GLU    53       0.205 -11.287 -16.910  1.00  1.00          
ATOM    857  HG2 GLU    53      -1.072 -10.861 -15.773  1.00  1.00          
ATOM    858  CD  GLU    53      -1.434 -12.638 -16.870  1.00  1.00          
ATOM    859  OE1 GLU    53      -0.962 -13.427 -17.715  1.00  1.00          
ATOM    860  OE2 GLU    53      -2.647 -12.589 -16.586  1.00  1.00          
ATOM    861  C   GLU    53       1.742 -11.898 -13.004  1.00  1.00          
ATOM    862  O   GLU    53       2.536 -12.846 -12.861  1.00  1.00          
ATOM    863  N   PHE    54       1.139 -11.222 -11.991  1.00  1.00          
ATOM    864  HN  PHE    54       0.487 -10.527 -12.219  1.00  1.00          
ATOM    865  CA  PHE    54       1.337 -11.502 -10.546  1.00  1.00          
ATOM    866  HA  PHE    54       1.840 -12.458 -10.483  1.00  1.00          
ATOM    867  CB  PHE    54       2.251 -10.415  -9.864  1.00  1.00          
ATOM    868  HB1 PHE    54       3.228 -10.459 -10.326  1.00  1.00          
ATOM    869  HB2 PHE    54       2.361 -10.669  -8.822  1.00  1.00          
ATOM    870  CG  PHE    54       1.785  -8.954  -9.918  1.00  1.00          
ATOM    871  CD1 PHE    54       0.995  -8.436  -8.904  1.00  1.00          
ATOM    872  HD1 PHE    54       0.722  -9.067  -8.071  1.00  1.00          
ATOM    873  CD2 PHE    54       2.129  -8.132 -10.980  1.00  1.00          
ATOM    874  HD2 PHE    54       2.747  -8.523 -11.775  1.00  1.00          
ATOM    875  CE1 PHE    54       0.556  -7.126  -8.947  1.00  1.00          
ATOM    876  HE1 PHE    54      -0.059  -6.735  -8.150  1.00  1.00          
ATOM    877  CE2 PHE    54       1.694  -6.820 -11.026  1.00  1.00          
ATOM    878  HE2 PHE    54       1.965  -6.188 -11.856  1.00  1.00          
ATOM    879  CZ  PHE    54       0.905  -6.318 -10.009  1.00  1.00          
ATOM    880  HZ  PHE    54       0.563  -5.295 -10.046  1.00  1.00          
ATOM    881  C   PHE    54      -0.034 -11.653  -9.849  1.00  1.00          
ATOM    882  O   PHE    54      -0.969 -10.889 -10.162  1.00  1.00          
ATOM    883  N   TYR    55      -0.119 -12.615  -8.898  1.00  1.00          
ATOM    884  HN  TYR    55       0.686 -13.125  -8.672  1.00  1.00          
ATOM    885  CA  TYR    55      -1.363 -12.935  -8.148  1.00  1.00          
ATOM    886  HA  TYR    55      -2.197 -12.602  -8.746  1.00  1.00          
ATOM    887  CB  TYR    55      -1.477 -14.469  -7.949  1.00  1.00          
ATOM    888  HB1 TYR    55      -2.236 -14.667  -7.207  1.00  1.00          
ATOM    889  HB2 TYR    55      -0.532 -14.841  -7.584  1.00  1.00          
ATOM    890  CG  TYR    55      -1.827 -15.271  -9.202  1.00  1.00          
ATOM    891  CD1 TYR    55      -0.826 -15.803 -10.011  1.00  1.00          
ATOM    892  HD1 TYR    55       0.206 -15.632  -9.747  1.00  1.00          
ATOM    893  CD2 TYR    55      -3.152 -15.506  -9.566  1.00  1.00          
ATOM    894  HD2 TYR    55      -3.945 -15.100  -8.957  1.00  1.00          
ATOM    895  CE1 TYR    55      -1.135 -16.542 -11.138  1.00  1.00          
ATOM    896  HE1 TYR    55      -0.342 -16.947 -11.751  1.00  1.00          
ATOM    897  CE2 TYR    55      -3.465 -16.242 -10.694  1.00  1.00          
ATOM    898  HE2 TYR    55      -4.498 -16.413 -10.957  1.00  1.00          
ATOM    899  CZ  TYR    55      -2.453 -16.758 -11.475  1.00  1.00          
ATOM    900  OH  TYR    55      -2.762 -17.493 -12.597  1.00  1.00          
ATOM    901  HH  TYR    55      -3.405 -18.168 -12.371  1.00  1.00          
ATOM    902  C   TYR    55      -1.424 -12.224  -6.782  1.00  1.00          
ATOM    903  O   TYR    55      -0.370 -11.935  -6.183  1.00  1.00          
ATOM    904  N   GLY    56      -2.689 -11.949  -6.310  1.00  1.00          
ATOM    905  HN  GLY    56      -3.450 -12.205  -6.872  1.00  1.00          
ATOM    906  CA  GLY    56      -2.969 -11.294  -4.993  1.00  1.00          
ATOM    907  HA1 GLY    56      -3.977 -10.905  -5.012  1.00  1.00          
ATOM    908  HA2 GLY    56      -2.288 -10.464  -4.875  1.00  1.00          
ATOM    909  C   GLY    56      -2.816 -12.227  -3.760  1.00  1.00          
ATOM    910  O   GLY    56      -2.881 -11.750  -2.615  1.00  1.00          
ATOM    911  N   LYS    57      -2.617 -13.552  -4.048  1.00  1.00          
ATOM    912  HN  LYS    57      -2.606 -13.783  -5.000  1.00  1.00          
ATOM    913  CA  LYS    57      -2.389 -14.631  -3.044  1.00  1.00          
ATOM    914  HA  LYS    57      -2.947 -14.368  -2.158  1.00  1.00          
ATOM    915  CB  LYS    57      -2.919 -15.974  -3.588  1.00  1.00          
ATOM    916  HB1 LYS    57      -2.089 -16.532  -3.999  1.00  1.00          
ATOM    917  HB2 LYS    57      -3.626 -15.772  -4.378  1.00  1.00          
ATOM    918  CG  LYS    57      -3.613 -16.853  -2.543  1.00  1.00          
ATOM    919  HG1 LYS    57      -4.380 -16.276  -2.050  1.00  1.00          
ATOM    920  HG2 LYS    57      -2.882 -17.174  -1.816  1.00  1.00          
ATOM    921  CD  LYS    57      -4.252 -18.086  -3.178  1.00  1.00          
ATOM    922  HD1 LYS    57      -3.482 -18.648  -3.689  1.00  1.00          
ATOM    923  HD2 LYS    57      -4.994 -17.762  -3.892  1.00  1.00          
ATOM    924  CE  LYS    57      -4.928 -18.985  -2.136  1.00  1.00          
ATOM    925  HE1 LYS    57      -4.326 -18.991  -1.240  1.00  1.00          
ATOM    926  HE2 LYS    57      -4.997 -19.992  -2.525  1.00  1.00          
ATOM    927  NZ  LYS    57      -6.303 -18.515  -1.790  1.00  1.00          
ATOM    928  HZ1 LYS    57      -6.733 -19.150  -1.086  1.00  1.00          
ATOM    929  HZ2 LYS    57      -6.901 -18.503  -2.640  1.00  1.00          
ATOM    930  HZ3 LYS    57      -6.264 -17.553  -1.395  1.00  1.00          
ATOM    931  C   LYS    57      -0.874 -14.755  -2.662  1.00  1.00          
ATOM    932  O   LYS    57      -0.554 -15.326  -1.604  1.00  1.00          
ATOM    933  N   THR    58       0.013 -14.210  -3.547  1.00  1.00          
ATOM    934  HN  THR    58      -0.349 -13.780  -4.350  1.00  1.00          
ATOM    935  CA  THR    58       1.493 -14.204  -3.378  1.00  1.00          
ATOM    936  HA  THR    58       1.736 -14.989  -2.675  1.00  1.00          
ATOM    937  CB  THR    58       2.235 -14.516  -4.729  1.00  1.00          
ATOM    938  HB  THR    58       3.276 -14.255  -4.602  1.00  1.00          
ATOM    939  OG1 THR    58       1.700 -13.726  -5.798  1.00  1.00          
ATOM    940  HG1 THR    58       0.791 -13.491  -5.598  1.00  1.00          
ATOM    941  CG2 THR    58       2.157 -15.999  -5.108  1.00  1.00          
ATOM    942 HG21 THR    58       2.463 -16.606  -4.270  1.00  1.00          
ATOM    943 HG22 THR    58       2.810 -16.189  -5.947  1.00  1.00          
ATOM    944 HG23 THR    58       1.138 -16.245  -5.381  1.00  1.00          
ATOM    945  C   THR    58       2.013 -12.847  -2.784  1.00  1.00          
ATOM    946  O   THR    58       3.244 -12.651  -2.648  1.00  1.00          
ATOM    947  N   LEU    59       1.051 -11.941  -2.376  1.00  1.00          
ATOM    948  HN  LEU    59       0.111 -12.217  -2.445  1.00  1.00          
ATOM    949  CA  LEU    59       1.347 -10.603  -1.784  1.00  1.00          
ATOM    950  HA  LEU    59       2.256 -10.253  -2.244  1.00  1.00          
ATOM    951  CB  LEU    59       0.194  -9.605  -2.082  1.00  1.00          
ATOM    952  HB1 LEU    59      -0.209  -9.264  -1.136  1.00  1.00          
ATOM    953  HB2 LEU    59      -0.585 -10.141  -2.603  1.00  1.00          
ATOM    954  CG  LEU    59       0.539  -8.353  -2.918  1.00  1.00          
ATOM    955  HG  LEU    59       1.597  -8.149  -2.859  1.00  1.00          
ATOM    956  CD1 LEU    59       0.179  -8.558  -4.386  1.00  1.00          
ATOM    957 HD11 LEU    59       0.648  -7.790  -4.982  1.00  1.00          
ATOM    958 HD12 LEU    59      -0.893  -8.502  -4.506  1.00  1.00          
ATOM    959 HD13 LEU    59       0.528  -9.529  -4.710  1.00  1.00          
ATOM    960  CD2 LEU    59      -0.199  -7.140  -2.364  1.00  1.00          
ATOM    961 HD21 LEU    59      -0.085  -6.307  -3.043  1.00  1.00          
ATOM    962 HD22 LEU    59       0.213  -6.878  -1.401  1.00  1.00          
ATOM    963 HD23 LEU    59      -1.248  -7.374  -2.255  1.00  1.00          
ATOM    964  C   LEU    59       1.576 -10.701  -0.224  1.00  1.00          
ATOM    965  O   LEU    59       1.091 -11.689   0.366  1.00  1.00          
ATOM    966  N   PRO    60       2.291  -9.689   0.512  1.00  1.00          
ATOM    967  CA  PRO    60       2.542  -9.770   2.005  1.00  1.00          
ATOM    968  HA  PRO    60       3.000 -10.718   2.259  1.00  1.00          
ATOM    969  CB  PRO    60       3.541  -8.618   2.284  1.00  1.00          
ATOM    970  HB1 PRO    60       4.331  -8.957   2.948  1.00  1.00          
ATOM    971  HB2 PRO    60       3.013  -7.795   2.748  1.00  1.00          
ATOM    972  CG  PRO    60       4.076  -8.238   0.941  1.00  1.00          
ATOM    973  HG1 PRO    60       4.889  -8.898   0.663  1.00  1.00          
ATOM    974  HG2 PRO    60       4.412  -7.208   0.945  1.00  1.00          
ATOM    975  CD  PRO    60       2.916  -8.416   0.005  1.00  1.00          
ATOM    976  HD1 PRO    60       3.258  -8.528  -1.012  1.00  1.00          
ATOM    977  HD2 PRO    60       2.228  -7.584   0.088  1.00  1.00          
ATOM    978  C   PRO    60       1.277  -9.594   2.870  1.00  1.00          
ATOM    979  O   PRO    60       0.309  -8.953   2.429  1.00  1.00          
ATOM    980  N   ARG    61       1.326 -10.175   4.109  1.00  1.00          
ATOM    981  HN  ARG    61       2.150 -10.644   4.354  1.00  1.00          
ATOM    982  CA  ARG    61       0.215 -10.152   5.121  1.00  1.00          
ATOM    983  HA  ARG    61      -0.676 -10.465   4.596  1.00  1.00          
ATOM    984  CB  ARG    61       0.482 -11.181   6.232  1.00  1.00          
ATOM    985  HB1 ARG    61      -0.032 -10.867   7.128  1.00  1.00          
ATOM    986  HB2 ARG    61       1.544 -11.214   6.428  1.00  1.00          
ATOM    987  CG  ARG    61       0.014 -12.587   5.877  1.00  1.00          
ATOM    988  HG1 ARG    61       0.531 -12.912   4.985  1.00  1.00          
ATOM    989  HG2 ARG    61      -1.048 -12.565   5.687  1.00  1.00          
ATOM    990  CD  ARG    61       0.286 -13.582   6.994  1.00  1.00          
ATOM    991  HD1 ARG    61      -0.206 -13.242   7.892  1.00  1.00          
ATOM    992  HD2 ARG    61       1.352 -13.636   7.163  1.00  1.00          
ATOM    993  NE  ARG    61      -0.219 -14.938   6.652  1.00  1.00          
ATOM    994  HE  ARG    61      -0.687 -15.011   5.795  1.00  1.00          
ATOM    995  CZ  ARG    61      -0.105 -16.080   7.398  1.00  1.00          
ATOM    996  NH1 ARG    61       0.508 -16.135   8.596  1.00  1.00          
ATOM    997 HH11 ARG    61       0.912 -15.309   8.988  1.00  1.00          
ATOM    998 HH12 ARG    61       0.558 -17.001   9.092  1.00  1.00          
ATOM    999  NH2 ARG    61      -0.629 -17.199   6.917  1.00  1.00          
ATOM   1000 HH21 ARG    61      -1.095 -17.194   6.032  1.00  1.00          
ATOM   1001 HH22 ARG    61      -0.562 -18.048   7.442  1.00  1.00          
ATOM   1002  C   ARG    61      -0.090  -8.754   5.739  1.00  1.00          
ATOM   1003  O   ARG    61      -1.190  -8.561   6.297  1.00  1.00          
ATOM   1004  N   ARG    62       0.883  -7.787   5.613  1.00  1.00          
ATOM   1005  HN  ARG    62       1.677  -7.969   5.070  1.00  1.00          
ATOM   1006  CA  ARG    62       0.757  -6.390   6.122  1.00  1.00          
ATOM   1007  HA  ARG    62       0.193  -6.431   7.042  1.00  1.00          
ATOM   1008  CB  ARG    62       2.140  -5.819   6.419  1.00  1.00          
ATOM   1009  HB1 ARG    62       2.128  -4.758   6.227  1.00  1.00          
ATOM   1010  HB2 ARG    62       2.860  -6.289   5.765  1.00  1.00          
ATOM   1011  CG  ARG    62       2.583  -6.042   7.863  1.00  1.00          
ATOM   1012  HG1 ARG    62       2.496  -7.095   8.091  1.00  1.00          
ATOM   1013  HG2 ARG    62       1.927  -5.480   8.515  1.00  1.00          
ATOM   1014  CD  ARG    62       4.030  -5.600   8.114  1.00  1.00          
ATOM   1015  HD1 ARG    62       4.186  -5.502   9.181  1.00  1.00          
ATOM   1016  HD2 ARG    62       4.183  -4.639   7.644  1.00  1.00          
ATOM   1017  NE  ARG    62       5.037  -6.563   7.573  1.00  1.00          
ATOM   1018  HE  ARG    62       4.687  -7.438   7.301  1.00  1.00          
ATOM   1019  CZ  ARG    62       6.378  -6.352   7.404  1.00  1.00          
ATOM   1020  NH1 ARG    62       7.002  -5.209   7.753  1.00  1.00          
ATOM   1021 HH11 ARG    62       6.480  -4.459   8.159  1.00  1.00          
ATOM   1022 HH12 ARG    62       7.986  -5.112   7.606  1.00  1.00          
ATOM   1023  NH2 ARG    62       7.109  -7.325   6.880  1.00  1.00          
ATOM   1024 HH21 ARG    62       6.677  -8.189   6.618  1.00  1.00          
ATOM   1025 HH22 ARG    62       8.091  -7.197   6.744  1.00  1.00          
ATOM   1026  C   ARG    62      -0.001  -5.469   5.128  1.00  1.00          
ATOM   1027  O   ARG    62      -0.718  -4.554   5.566  1.00  1.00          
ATOM   1028  N   GLU    63       0.185  -5.737   3.781  1.00  1.00          
ATOM   1029  HN  GLU    63       0.812  -6.451   3.540  1.00  1.00          
ATOM   1030  CA  GLU    63      -0.483  -5.013   2.644  1.00  1.00          
ATOM   1031  HA  GLU    63      -0.363  -3.958   2.832  1.00  1.00          
ATOM   1032  CB  GLU    63       0.205  -5.347   1.315  1.00  1.00          
ATOM   1033  HB1 GLU    63      -0.504  -5.212   0.514  1.00  1.00          
ATOM   1034  HB2 GLU    63       0.520  -6.379   1.336  1.00  1.00          
ATOM   1035  CG  GLU    63       1.430  -4.481   1.023  1.00  1.00          
ATOM   1036  HG1 GLU    63       2.159  -4.643   1.802  1.00  1.00          
ATOM   1037  HG2 GLU    63       1.126  -3.445   1.029  1.00  1.00          
ATOM   1038  CD  GLU    63       2.082  -4.780  -0.322  1.00  1.00          
ATOM   1039  OE1 GLU    63       3.211  -5.309  -0.323  1.00  1.00          
ATOM   1040  OE2 GLU    63       1.478  -4.459  -1.374  1.00  1.00          
ATOM   1041  C   GLU    63      -2.004  -5.306   2.532  1.00  1.00          
ATOM   1042  O   GLU    63      -2.757  -4.448   2.046  1.00  1.00          
ATOM   1043  N   ALA    64      -2.424  -6.543   2.991  1.00  1.00          
ATOM   1044  HN  ALA    64      -1.733  -7.165   3.292  1.00  1.00          
ATOM   1045  CA  ALA    64      -3.851  -7.021   3.050  1.00  1.00          
ATOM   1046  HA  ALA    64      -4.267  -6.928   2.057  1.00  1.00          
ATOM   1047  CB  ALA    64      -3.891  -8.493   3.436  1.00  1.00          
ATOM   1048  HB1 ALA    64      -4.908  -8.853   3.373  1.00  1.00          
ATOM   1049  HB2 ALA    64      -3.528  -8.612   4.446  1.00  1.00          
ATOM   1050  HB3 ALA    64      -3.268  -9.059   2.760  1.00  1.00          
ATOM   1051  C   ALA    64      -4.728  -6.188   4.032  1.00  1.00          
ATOM   1052  O   ALA    64      -5.934  -6.023   3.800  1.00  1.00          
ATOM   1053  N   GLU    65      -4.064  -5.680   5.132  1.00  1.00          
ATOM   1054  HN  GLU    65      -3.124  -5.930   5.241  1.00  1.00          
ATOM   1055  CA  GLU    65      -4.661  -4.777   6.179  1.00  1.00          
ATOM   1056  HA  GLU    65      -5.616  -5.197   6.458  1.00  1.00          
ATOM   1057  CB  GLU    65      -3.764  -4.716   7.427  1.00  1.00          
ATOM   1058  HB1 GLU    65      -4.016  -3.828   7.989  1.00  1.00          
ATOM   1059  HB2 GLU    65      -2.735  -4.649   7.110  1.00  1.00          
ATOM   1060  CG  GLU    65      -3.898  -5.921   8.355  1.00  1.00          
ATOM   1061  HG1 GLU    65      -3.647  -6.815   7.801  1.00  1.00          
ATOM   1062  HG2 GLU    65      -4.921  -5.986   8.695  1.00  1.00          
ATOM   1063  CD  GLU    65      -2.989  -5.830   9.566  1.00  1.00          
ATOM   1064  OE1 GLU    65      -1.820  -6.254   9.463  1.00  1.00          
ATOM   1065  OE2 GLU    65      -3.448  -5.334  10.617  1.00  1.00          
ATOM   1066  C   GLU    65      -4.904  -3.336   5.637  1.00  1.00          
ATOM   1067  O   GLU    65      -5.807  -2.638   6.122  1.00  1.00          
ATOM   1068  N   LYS    66      -4.061  -2.925   4.618  1.00  1.00          
ATOM   1069  HN  LYS    66      -3.348  -3.544   4.353  1.00  1.00          
ATOM   1070  CA  LYS    66      -4.141  -1.614   3.877  1.00  1.00          
ATOM   1071  HA  LYS    66      -4.193  -0.833   4.622  1.00  1.00          
ATOM   1072  CB  LYS    66      -2.892  -1.379   3.008  1.00  1.00          
ATOM   1073  HB1 LYS    66      -3.119  -0.611   2.282  1.00  1.00          
ATOM   1074  HB2 LYS    66      -2.660  -2.293   2.484  1.00  1.00          
ATOM   1075  CG  LYS    66      -1.646  -0.949   3.780  1.00  1.00          
ATOM   1076  HG1 LYS    66      -1.381  -1.727   4.480  1.00  1.00          
ATOM   1077  HG2 LYS    66      -1.860  -0.036   4.316  1.00  1.00          
ATOM   1078  CD  LYS    66      -0.473  -0.706   2.844  1.00  1.00          
ATOM   1079  HD1 LYS    66      -0.743   0.062   2.135  1.00  1.00          
ATOM   1080  HD2 LYS    66      -0.248  -1.620   2.318  1.00  1.00          
ATOM   1081  CE  LYS    66       0.761  -0.260   3.609  1.00  1.00          
ATOM   1082  HE1 LYS    66       1.028  -1.032   4.317  1.00  1.00          
ATOM   1083  HE2 LYS    66       0.530   0.650   4.140  1.00  1.00          
ATOM   1084  NZ  LYS    66       1.917  -0.012   2.706  1.00  1.00          
ATOM   1085  HZ1 LYS    66       2.282   0.951   2.850  1.00  1.00          
ATOM   1086  HZ2 LYS    66       1.625  -0.116   1.714  1.00  1.00          
ATOM   1087  HZ3 LYS    66       2.677  -0.693   2.905  1.00  1.00          
ATOM   1088  C   LYS    66      -5.405  -1.510   2.980  1.00  1.00          
ATOM   1089  O   LYS    66      -5.903  -0.399   2.742  1.00  1.00          
ATOM   1090  N   VAL    67      -5.900  -2.708   2.492  1.00  1.00          
ATOM   1091  HN  VAL    67      -5.401  -3.522   2.717  1.00  1.00          
ATOM   1092  CA  VAL    67      -7.146  -2.879   1.637  1.00  1.00          
ATOM   1093  HA  VAL    67      -7.070  -2.150   0.837  1.00  1.00          
ATOM   1094  CB  VAL    67      -7.300  -4.336   0.963  1.00  1.00          
ATOM   1095  HB  VAL    67      -7.701  -5.001   1.715  1.00  1.00          
ATOM   1096  CG1 VAL    67      -8.282  -4.338  -0.231  1.00  1.00          
ATOM   1097 HG11 VAL    67      -9.277  -4.113   0.123  1.00  1.00          
ATOM   1098 HG12 VAL    67      -8.276  -5.309  -0.702  1.00  1.00          
ATOM   1099 HG13 VAL    67      -7.977  -3.587  -0.947  1.00  1.00          
ATOM   1100  CG2 VAL    67      -5.971  -4.936   0.462  1.00  1.00          
ATOM   1101 HG21 VAL    67      -5.627  -4.378  -0.397  1.00  1.00          
ATOM   1102 HG22 VAL    67      -6.123  -5.968   0.185  1.00  1.00          
ATOM   1103 HG23 VAL    67      -5.232  -4.879   1.248  1.00  1.00          
ATOM   1104  C   VAL    67      -8.421  -2.511   2.492  1.00  1.00          
ATOM   1105  O   VAL    67      -9.346  -1.894   1.965  1.00  1.00          
ATOM   1106  N   PHE    68      -8.439  -2.927   3.807  1.00  1.00          
ATOM   1107  HN  PHE    68      -7.742  -3.540   4.124  1.00  1.00          
ATOM   1108  CA  PHE    68      -9.503  -2.592   4.824  1.00  1.00          
ATOM   1109  HA  PHE    68     -10.443  -3.012   4.483  1.00  1.00          
ATOM   1110  CB  PHE    68      -9.123  -3.235   6.174  1.00  1.00          
ATOM   1111  HB1 PHE    68      -9.193  -2.480   6.944  1.00  1.00          
ATOM   1112  HB2 PHE    68      -8.101  -3.576   6.116  1.00  1.00          
ATOM   1113  CG  PHE    68      -9.968  -4.414   6.608  1.00  1.00          
ATOM   1114  CD1 PHE    68      -9.597  -5.713   6.280  1.00  1.00          
ATOM   1115  HD1 PHE    68      -8.704  -5.875   5.696  1.00  1.00          
ATOM   1116  CD2 PHE    68     -11.119  -4.226   7.366  1.00  1.00          
ATOM   1117  HD2 PHE    68     -11.420  -3.224   7.631  1.00  1.00          
ATOM   1118  CE1 PHE    68     -10.354  -6.794   6.695  1.00  1.00          
ATOM   1119  HE1 PHE    68     -10.053  -7.798   6.434  1.00  1.00          
ATOM   1120  CE2 PHE    68     -11.878  -5.303   7.780  1.00  1.00          
ATOM   1121  HE2 PHE    68     -12.771  -5.141   8.365  1.00  1.00          
ATOM   1122  CZ  PHE    68     -11.496  -6.588   7.445  1.00  1.00          
ATOM   1123  HZ  PHE    68     -12.089  -7.430   7.769  1.00  1.00          
ATOM   1124  C   PHE    68      -9.679  -1.054   5.056  1.00  1.00          
ATOM   1125  O   PHE    68     -10.775  -0.605   5.420  1.00  1.00          
ATOM   1126  N   GLU    69      -8.551  -0.285   4.832  1.00  1.00          
ATOM   1127  HN  GLU    69      -7.763  -0.745   4.481  1.00  1.00          
ATOM   1128  CA  GLU    69      -8.443   1.192   5.008  1.00  1.00          
ATOM   1129  HA  GLU    69      -8.881   1.428   5.967  1.00  1.00          
ATOM   1130  CB  GLU    69      -6.947   1.586   5.046  1.00  1.00          
ATOM   1131  HB1 GLU    69      -6.628   1.823   4.042  1.00  1.00          
ATOM   1132  HB2 GLU    69      -6.379   0.739   5.399  1.00  1.00          
ATOM   1133  CG  GLU    69      -6.622   2.781   5.946  1.00  1.00          
ATOM   1134  HG1 GLU    69      -6.989   2.573   6.940  1.00  1.00          
ATOM   1135  HG2 GLU    69      -7.132   3.648   5.551  1.00  1.00          
ATOM   1136  CD  GLU    69      -5.134   3.083   6.022  1.00  1.00          
ATOM   1137  OE1 GLU    69      -4.595   3.674   5.062  1.00  1.00          
ATOM   1138  OE2 GLU    69      -4.509   2.732   7.046  1.00  1.00          
ATOM   1139  C   GLU    69      -9.214   1.994   3.916  1.00  1.00          
ATOM   1140  O   GLU    69      -9.885   2.978   4.264  1.00  1.00          
ATOM   1141  N   LEU    70      -9.110   1.556   2.607  1.00  1.00          
ATOM   1142  HN  LEU    70      -8.516   0.805   2.412  1.00  1.00          
ATOM   1143  CA  LEU    70      -9.829   2.185   1.439  1.00  1.00          
ATOM   1144  HA  LEU    70      -9.645   3.250   1.524  1.00  1.00          
ATOM   1145  CB  LEU    70      -9.287   1.700   0.048  1.00  1.00          
ATOM   1146  HB1 LEU    70      -8.383   2.242  -0.168  1.00  1.00          
ATOM   1147  HB2 LEU    70     -10.013   1.983  -0.674  1.00  1.00          
ATOM   1148  CG  LEU    70      -8.996   0.195  -0.186  1.00  1.00          
ATOM   1149  HG  LEU    70      -8.749  -0.268   0.759  1.00  1.00          
ATOM   1150  CD1 LEU    70     -10.218  -0.516  -0.756  1.00  1.00          
ATOM   1151 HD11 LEU    70     -10.060  -1.586  -0.739  1.00  1.00          
ATOM   1152 HD12 LEU    70     -10.377  -0.191  -1.773  1.00  1.00          
ATOM   1153 HD13 LEU    70     -11.085  -0.270  -0.160  1.00  1.00          
ATOM   1154  CD2 LEU    70      -7.806   0.024  -1.121  1.00  1.00          
ATOM   1155 HD21 LEU    70      -7.757  -1.002  -1.460  1.00  1.00          
ATOM   1156 HD22 LEU    70      -6.895   0.273  -0.598  1.00  1.00          
ATOM   1157 HD23 LEU    70      -7.922   0.677  -1.972  1.00  1.00          
ATOM   1158  C   LEU    70     -11.373   1.987   1.512  1.00  1.00          
ATOM   1159  O   LEU    70     -12.134   2.895   1.140  1.00  1.00          
ATOM   1160  N   LEU    71     -11.784   0.771   2.002  1.00  1.00          
ATOM   1161  HN  LEU    71     -11.086   0.116   2.213  1.00  1.00          
ATOM   1162  CA  LEU    71     -13.199   0.356   2.240  1.00  1.00          
ATOM   1163  HA  LEU    71     -13.763   0.606   1.357  1.00  1.00          
ATOM   1164  CB  LEU    71     -13.260  -1.167   2.456  1.00  1.00          
ATOM   1165  HB1 LEU    71     -14.146  -1.382   3.034  1.00  1.00          
ATOM   1166  HB2 LEU    71     -12.397  -1.456   3.040  1.00  1.00          
ATOM   1167  CG  LEU    71     -13.288  -2.029   1.183  1.00  1.00          
ATOM   1168  HG  LEU    71     -13.164  -1.397   0.318  1.00  1.00          
ATOM   1169  CD1 LEU    71     -12.147  -3.033   1.182  1.00  1.00          
ATOM   1170 HD11 LEU    71     -11.205  -2.503   1.168  1.00  1.00          
ATOM   1171 HD12 LEU    71     -12.220  -3.658   0.306  1.00  1.00          
ATOM   1172 HD13 LEU    71     -12.198  -3.644   2.067  1.00  1.00          
ATOM   1173  CD2 LEU    71     -14.623  -2.746   1.055  1.00  1.00          
ATOM   1174 HD21 LEU    71     -14.602  -3.393   0.190  1.00  1.00          
ATOM   1175 HD22 LEU    71     -15.409  -2.015   0.936  1.00  1.00          
ATOM   1176 HD23 LEU    71     -14.814  -3.335   1.940  1.00  1.00          
ATOM   1177  C   LEU    71     -13.856   1.087   3.457  1.00  1.00          
ATOM   1178  O   LEU    71     -15.050   1.425   3.397  1.00  1.00          
ATOM   1179  N   ASN    72     -13.034   1.313   4.541  1.00  1.00          
ATOM   1180  HN  ASN    72     -12.098   1.021   4.473  1.00  1.00          
ATOM   1181  CA  ASN    72     -13.440   1.994   5.806  1.00  1.00          
ATOM   1182  HA  ASN    72     -14.442   1.664   6.041  1.00  1.00          
ATOM   1183  CB  ASN    72     -12.512   1.554   6.941  1.00  1.00          
ATOM   1184  HB1 ASN    72     -12.456   2.341   7.678  1.00  1.00          
ATOM   1185  HB2 ASN    72     -11.526   1.373   6.539  1.00  1.00          
ATOM   1186  CG  ASN    72     -12.988   0.287   7.626  1.00  1.00          
ATOM   1187  OD1 ASN    72     -12.934  -0.803   7.055  1.00  1.00          
ATOM   1188  ND2 ASN    72     -13.458   0.424   8.859  1.00  1.00          
ATOM   1189 HD21 ASN    72     -13.474   1.322   9.251  1.00  1.00          
ATOM   1190 HD22 ASN    72     -13.769  -0.379   9.327  1.00  1.00          
ATOM   1191  C   ASN    72     -13.448   3.544   5.718  1.00  1.00          
ATOM   1192  O   ASN    72     -14.280   4.182   6.390  1.00  1.00          
ATOM   1193  N   ASP    73     -12.524   4.111   4.883  1.00  1.00          
ATOM   1194  HN  ASP    73     -11.957   3.514   4.357  1.00  1.00          
ATOM   1195  CA  ASP    73     -12.367   5.571   4.687  1.00  1.00          
ATOM   1196  HA  ASP    73     -12.853   6.050   5.527  1.00  1.00          
ATOM   1197  CB  ASP    73     -10.859   5.931   4.724  1.00  1.00          
ATOM   1198  HB1 ASP    73     -10.475   5.915   3.716  1.00  1.00          
ATOM   1199  HB2 ASP    73     -10.336   5.195   5.314  1.00  1.00          
ATOM   1200  CG  ASP    73     -10.590   7.305   5.323  1.00  1.00          
ATOM   1201  OD1 ASP    73     -10.854   8.315   4.635  1.00  1.00          
ATOM   1202  OD2 ASP    73     -10.116   7.368   6.477  1.00  1.00          
ATOM   1203  C   ASP    73     -13.099   6.036   3.387  1.00  1.00          
ATOM   1204  O   ASP    73     -12.512   6.625   2.440  1.00  1.00          
ATOM   1205  N   PHE    74     -14.424   5.737   3.388  1.00  1.00          
ATOM   1206  HN  PHE    74     -14.759   5.233   4.154  1.00  1.00          
ATOM   1207  CA  PHE    74     -15.377   6.081   2.304  1.00  1.00          
ATOM   1208  HA  PHE    74     -14.812   6.156   1.388  1.00  1.00          
ATOM   1209  CB  PHE    74     -16.431   4.965   2.145  1.00  1.00          
ATOM   1210  HB1 PHE    74     -17.407   5.374   2.368  1.00  1.00          
ATOM   1211  HB2 PHE    74     -16.214   4.177   2.849  1.00  1.00          
ATOM   1212  CG  PHE    74     -16.497   4.340   0.761  1.00  1.00          
ATOM   1213  CD1 PHE    74     -15.668   3.275   0.408  1.00  1.00          
ATOM   1214  HD1 PHE    74     -14.959   2.895   1.129  1.00  1.00          
ATOM   1215  CD2 PHE    74     -17.401   4.812  -0.184  1.00  1.00          
ATOM   1216  HD2 PHE    74     -18.053   5.635   0.071  1.00  1.00          
ATOM   1217  CE1 PHE    74     -15.740   2.707  -0.849  1.00  1.00          
ATOM   1218  HE1 PHE    74     -15.090   1.884  -1.108  1.00  1.00          
ATOM   1219  CE2 PHE    74     -17.473   4.245  -1.443  1.00  1.00          
ATOM   1220  HE2 PHE    74     -18.179   4.624  -2.166  1.00  1.00          
ATOM   1221  CZ  PHE    74     -16.643   3.192  -1.774  1.00  1.00          
ATOM   1222  HZ  PHE    74     -16.700   2.748  -2.757  1.00  1.00          
ATOM   1223  C   PHE    74     -16.064   7.430   2.566  1.00  1.00          
ATOM   1224  O   PHE    74     -16.342   7.781   3.723  1.00  1.00          
ATOM   1225  N   LYS    75     -16.345   8.186   1.442  1.00  1.00          
ATOM   1226  HN  LYS    75     -16.106   7.786   0.580  1.00  1.00          
ATOM   1227  CA  LYS    75     -16.981   9.574   1.391  1.00  1.00          
ATOM   1228  HA  LYS    75     -17.230   9.733   0.349  1.00  1.00          
ATOM   1229  CB  LYS    75     -18.306   9.741   2.220  1.00  1.00          
ATOM   1230  HB1 LYS    75     -18.359  10.754   2.591  1.00  1.00          
ATOM   1231  HB2 LYS    75     -18.277   9.063   3.062  1.00  1.00          
ATOM   1232  CG  LYS    75     -19.570   9.455   1.426  1.00  1.00          
ATOM   1233  HG1 LYS    75     -19.478   8.486   0.959  1.00  1.00          
ATOM   1234  HG2 LYS    75     -19.687  10.215   0.667  1.00  1.00          
ATOM   1235  CD  LYS    75     -20.801   9.459   2.327  1.00  1.00          
ATOM   1236  HD1 LYS    75     -20.853  10.410   2.838  1.00  1.00          
ATOM   1237  HD2 LYS    75     -20.699   8.665   3.055  1.00  1.00          
ATOM   1238  CE  LYS    75     -22.093   9.254   1.530  1.00  1.00          
ATOM   1239  HE1 LYS    75     -22.855   8.851   2.184  1.00  1.00          
ATOM   1240  HE2 LYS    75     -21.897   8.551   0.734  1.00  1.00          
ATOM   1241  NZ  LYS    75     -22.595  10.528   0.935  1.00  1.00          
ATOM   1242  HZ1 LYS    75     -22.066  10.752   0.068  1.00  1.00          
ATOM   1243  HZ2 LYS    75     -22.473  11.309   1.612  1.00  1.00          
ATOM   1244  HZ3 LYS    75     -23.603  10.441   0.702  1.00  1.00          
ATOM   1245  C   LYS    75     -15.957  10.674   1.761  1.00  1.00          
ATOM   1246  O   LYS    75     -15.480  10.734   2.919  1.00  1.00          
ATOM   1247  N   GLY    76     -15.614  11.494   0.732  1.00  1.00          
ATOM   1248  HN  GLY    76     -16.034  11.341  -0.140  1.00  1.00          
ATOM   1249  CA  GLY    76     -14.651  12.595   0.866  1.00  1.00          
ATOM   1250  HA1 GLY    76     -13.866  12.287   1.541  1.00  1.00          
ATOM   1251  HA2 GLY    76     -15.157  13.450   1.290  1.00  1.00          
ATOM   1252  C   GLY    76     -14.025  12.999  -0.458  1.00  1.00          
ATOM   1253  O   GLY    76     -14.391  14.058  -1.005  1.00  1.00          
ATOM   1254  N   GLY    77     -13.089  12.142  -0.950  1.00  1.00          
ATOM   1255  HN  GLY    77     -12.885  11.334  -0.436  1.00  1.00          
ATOM   1256  CA  GLY    77     -12.365  12.375  -2.221  1.00  1.00          
ATOM   1257  HA1 GLY    77     -11.311  12.461  -1.997  1.00  1.00          
ATOM   1258  HA2 GLY    77     -12.700  13.311  -2.639  1.00  1.00          
ATOM   1259  C   GLY    77     -12.541  11.287  -3.285  1.00  1.00          
ATOM   1260  O   GLY    77     -11.601  11.072  -4.073  1.00  1.00          
ATOM   1261  N   ILE    78     -13.729  10.616  -3.301  1.00  1.00          
ATOM   1262  HN  ILE    78     -14.405  10.858  -2.636  1.00  1.00          
ATOM   1263  CA  ILE    78     -14.055   9.535  -4.278  1.00  1.00          
ATOM   1264  HA  ILE    78     -13.224   9.468  -4.971  1.00  1.00          
ATOM   1265  CB  ILE    78     -14.285   8.078  -3.623  1.00  1.00          
ATOM   1266  HB  ILE    78     -15.313   8.025  -3.295  1.00  1.00          
ATOM   1267  CG1 ILE    78     -13.357   7.776  -2.416  1.00  1.00          
ATOM   1268 HG11 ILE    78     -12.680   8.609  -2.276  1.00  1.00          
ATOM   1269 HG12 ILE    78     -12.785   6.885  -2.622  1.00  1.00          
ATOM   1270  CG2 ILE    78     -14.062   6.944  -4.653  1.00  1.00          
ATOM   1271 HG21 ILE    78     -14.611   7.167  -5.557  1.00  1.00          
ATOM   1272 HG22 ILE    78     -14.412   6.008  -4.242  1.00  1.00          
ATOM   1273 HG23 ILE    78     -13.009   6.865  -4.881  1.00  1.00          
ATOM   1274  CD1 ILE    78     -14.104   7.558  -1.118  1.00  1.00          
ATOM   1275 HD11 ILE    78     -14.678   8.442  -0.880  1.00  1.00          
ATOM   1276 HD12 ILE    78     -13.398   7.364  -0.324  1.00  1.00          
ATOM   1277 HD13 ILE    78     -14.770   6.714  -1.222  1.00  1.00          
ATOM   1278  C   ILE    78     -15.308   9.982  -5.069  1.00  1.00          
ATOM   1279  O   ILE    78     -16.370  10.216  -4.462  1.00  1.00          
ATOM   1280  N   ASP    79     -15.134  10.090  -6.412  1.00  1.00          
ATOM   1281  HN  ASP    79     -14.247   9.892  -6.779  1.00  1.00          
ATOM   1282  CA  ASP    79     -16.200  10.488  -7.355  1.00  1.00          
ATOM   1283  HA  ASP    79     -17.123  10.546  -6.796  1.00  1.00          
ATOM   1284  CB  ASP    79     -15.902  11.868  -7.968  1.00  1.00          
ATOM   1285  HB1 ASP    79     -16.448  11.965  -8.894  1.00  1.00          
ATOM   1286  HB2 ASP    79     -14.845  11.943  -8.171  1.00  1.00          
ATOM   1287  CG  ASP    79     -16.299  13.014  -7.052  1.00  1.00          
ATOM   1288  OD1 ASP    79     -15.392  13.678  -6.508  1.00  1.00          
ATOM   1289  OD2 ASP    79     -17.516  13.251  -6.884  1.00  1.00          
ATOM   1290  C   ASP    79     -16.367   9.439  -8.456  1.00  1.00          
ATOM   1291  O   ASP    79     -15.369   9.004  -9.067  1.00  1.00          
ATOM   1292  N   TRP    80     -17.649   9.026  -8.669  1.00  1.00          
ATOM   1293  HN  TRP    80     -18.351   9.424  -8.112  1.00  1.00          
ATOM   1294  CA  TRP    80     -18.065   8.009  -9.693  1.00  1.00          
ATOM   1295  HA  TRP    80     -17.284   7.264  -9.721  1.00  1.00          
ATOM   1296  CB  TRP    80     -19.368   7.313  -9.266  1.00  1.00          
ATOM   1297  HB1 TRP    80     -19.786   6.791 -10.114  1.00  1.00          
ATOM   1298  HB2 TRP    80     -20.071   8.058  -8.923  1.00  1.00          
ATOM   1299  CG  TRP    80     -19.169   6.307  -8.145  1.00  1.00          
ATOM   1300  CD1 TRP    80     -19.391   6.544  -6.819  1.00  1.00          
ATOM   1301  HD1 TRP    80     -19.745   7.485  -6.425  1.00  1.00          
ATOM   1302  CD2 TRP    80     -18.703   4.930  -8.229  1.00  1.00          
ATOM   1303  NE1 TRP    80     -19.095   5.430  -6.076  1.00  1.00          
ATOM   1304  HE1 TRP    80     -19.175   5.361  -5.101  1.00  1.00          
ATOM   1305  CE2 TRP    80     -18.674   4.429  -6.910  1.00  1.00          
ATOM   1306  CE3 TRP    80     -18.306   4.066  -9.277  1.00  1.00          
ATOM   1307  HE3 TRP    80     -18.313   4.397 -10.304  1.00  1.00          
ATOM   1308  CZ2 TRP    80     -18.271   3.129  -6.610  1.00  1.00          
ATOM   1309  HZ2 TRP    80     -18.253   2.759  -5.596  1.00  1.00          
ATOM   1310  CZ3 TRP    80     -17.909   2.777  -8.969  1.00  1.00          
ATOM   1311  HZ3 TRP    80     -17.604   2.102  -9.759  1.00  1.00          
ATOM   1312  CH2 TRP    80     -17.894   2.321  -7.647  1.00  1.00          
ATOM   1313  HH2 TRP    80     -17.575   1.308  -7.453  1.00  1.00          
ATOM   1314  C   TRP    80     -18.210   8.581 -11.130  1.00  1.00          
ATOM   1315  O   TRP    80     -17.950   7.851 -12.102  1.00  1.00          
ATOM   1316  N   GLU    81     -18.632   9.883 -11.229  1.00  1.00          
ATOM   1317  HN  GLU    81     -18.821  10.362 -10.396  1.00  1.00          
ATOM   1318  CA  GLU    81     -18.823  10.631 -12.519  1.00  1.00          
ATOM   1319  HA  GLU    81     -19.262   9.941 -13.225  1.00  1.00          
ATOM   1320  CB  GLU    81     -19.801  11.809 -12.323  1.00  1.00          
ATOM   1321  HB1 GLU    81     -19.668  12.505 -13.137  1.00  1.00          
ATOM   1322  HB2 GLU    81     -19.558  12.308 -11.397  1.00  1.00          
ATOM   1323  CG  GLU    81     -21.276  11.411 -12.273  1.00  1.00          
ATOM   1324  HG1 GLU    81     -21.414  10.696 -11.476  1.00  1.00          
ATOM   1325  HG2 GLU    81     -21.544  10.955 -13.215  1.00  1.00          
ATOM   1326  CD  GLU    81     -22.191  12.596 -12.029  1.00  1.00          
ATOM   1327  OE1 GLU    81     -22.409  12.944 -10.849  1.00  1.00          
ATOM   1328  OE2 GLU    81     -22.693  13.174 -13.017  1.00  1.00          
ATOM   1329  C   GLU    81     -17.492  11.159 -13.127  1.00  1.00          
ATOM   1330  O   GLU    81     -17.354  11.175 -14.364  1.00  1.00          
ATOM   1331  N   ASN    82     -16.547  11.581 -12.234  1.00  1.00          
ATOM   1332  HN  ASN    82     -16.764  11.528 -11.281  1.00  1.00          
ATOM   1333  CA  ASN    82     -15.209  12.112 -12.609  1.00  1.00          
ATOM   1334  HA  ASN    82     -15.290  12.507 -13.611  1.00  1.00          
ATOM   1335  CB  ASN    82     -14.834  13.262 -11.661  1.00  1.00          
ATOM   1336  HB1 ASN    82     -13.760  13.375 -11.649  1.00  1.00          
ATOM   1337  HB2 ASN    82     -15.177  13.023 -10.665  1.00  1.00          
ATOM   1338  CG  ASN    82     -15.451  14.585 -12.077  1.00  1.00          
ATOM   1339  OD1 ASN    82     -16.545  14.941 -11.636  1.00  1.00          
ATOM   1340  ND2 ASN    82     -14.753  15.321 -12.936  1.00  1.00          
ATOM   1341 HD21 ASN    82     -13.892  14.972 -13.249  1.00  1.00          
ATOM   1342 HD22 ASN    82     -15.129  16.179 -13.222  1.00  1.00          
ATOM   1343  C   ASN    82     -14.090  11.029 -12.597  1.00  1.00          
ATOM   1344  O   ASN    82     -13.014  11.254 -13.179  1.00  1.00          
ATOM   1345  N   LYS    83     -14.365   9.822 -11.944  1.00  1.00          
ATOM   1346  HN  LYS    83     -15.254   9.736 -11.541  1.00  1.00          
ATOM   1347  CA  LYS    83     -13.433   8.623 -11.790  1.00  1.00          
ATOM   1348  HA  LYS    83     -13.974   7.939 -11.145  1.00  1.00          
ATOM   1349  CB  LYS    83     -13.206   7.870 -13.151  1.00  1.00          
ATOM   1350  HB1 LYS    83     -12.300   7.286 -13.080  1.00  1.00          
ATOM   1351  HB2 LYS    83     -13.089   8.602 -13.935  1.00  1.00          
ATOM   1352  CG  LYS    83     -14.343   6.943 -13.540  1.00  1.00          
ATOM   1353  HG1 LYS    83     -15.259   7.512 -13.597  1.00  1.00          
ATOM   1354  HG2 LYS    83     -14.440   6.172 -12.788  1.00  1.00          
ATOM   1355  CD  LYS    83     -14.081   6.286 -14.884  1.00  1.00          
ATOM   1356  HD1 LYS    83     -13.142   5.753 -14.838  1.00  1.00          
ATOM   1357  HD2 LYS    83     -14.024   7.054 -15.642  1.00  1.00          
ATOM   1358  CE  LYS    83     -15.187   5.313 -15.253  1.00  1.00          
ATOM   1359  HE1 LYS    83     -16.123   5.849 -15.296  1.00  1.00          
ATOM   1360  HE2 LYS    83     -15.244   4.548 -14.492  1.00  1.00          
ATOM   1361  NZ  LYS    83     -14.938   4.664 -16.569  1.00  1.00          
ATOM   1362  HZ1 LYS    83     -13.954   4.827 -16.866  1.00  1.00          
ATOM   1363  HZ2 LYS    83     -15.576   5.060 -17.288  1.00  1.00          
ATOM   1364  HZ3 LYS    83     -15.103   3.640 -16.498  1.00  1.00          
ATOM   1365  C   LYS    83     -12.093   8.949 -11.022  1.00  1.00          
ATOM   1366  O   LYS    83     -10.958   8.649 -11.484  1.00  1.00          
ATOM   1367  N   ARG    84     -12.280   9.578  -9.829  1.00  1.00          
ATOM   1368  HN  ARG    84     -13.197   9.781  -9.556  1.00  1.00          
ATOM   1369  CA  ARG    84     -11.177   9.973  -8.915  1.00  1.00          
ATOM   1370  HA  ARG    84     -10.248   9.735  -9.415  1.00  1.00          
ATOM   1371  CB  ARG    84     -11.199  11.488  -8.602  1.00  1.00          
ATOM   1372  HB1 ARG    84     -10.545  11.673  -7.762  1.00  1.00          
ATOM   1373  HB2 ARG    84     -12.204  11.766  -8.325  1.00  1.00          
ATOM   1374  CG  ARG    84     -10.759  12.395  -9.761  1.00  1.00          
ATOM   1375  HG1 ARG    84     -11.394  12.192 -10.613  1.00  1.00          
ATOM   1376  HG2 ARG    84      -9.736  12.160 -10.014  1.00  1.00          
ATOM   1377  CD  ARG    84     -10.846  13.887  -9.411  1.00  1.00          
ATOM   1378  HD1 ARG    84     -11.771  14.060  -8.880  1.00  1.00          
ATOM   1379  HD2 ARG    84     -10.850  14.462 -10.328  1.00  1.00          
ATOM   1380  NE  ARG    84      -9.710  14.353  -8.562  1.00  1.00          
ATOM   1381  HE  ARG    84      -9.050  13.668  -8.321  1.00  1.00          
ATOM   1382  CZ  ARG    84      -9.489  15.622  -8.092  1.00  1.00          
ATOM   1383  NH1 ARG    84     -10.311  16.662  -8.334  1.00  1.00          
ATOM   1384 HH11 ARG    84     -11.137  16.530  -8.883  1.00  1.00          
ATOM   1385 HH12 ARG    84     -10.096  17.567  -7.966  1.00  1.00          
ATOM   1386  NH2 ARG    84      -8.407  15.842  -7.358  1.00  1.00          
ATOM   1387 HH21 ARG    84      -7.777  15.091  -7.158  1.00  1.00          
ATOM   1388 HH22 ARG    84      -8.220  16.759  -7.004  1.00  1.00          
ATOM   1389  C   ARG    84     -11.241   9.161  -7.617  1.00  1.00          
ATOM   1390  O   ARG    84     -12.313   9.074  -6.983  1.00  1.00          
ATOM   1391  N   VAL    85     -10.077   8.561  -7.263  1.00  1.00          
ATOM   1392  HN  VAL    85      -9.301   8.687  -7.846  1.00  1.00          
ATOM   1393  CA  VAL    85      -9.904   7.718  -6.039  1.00  1.00          
ATOM   1394  HA  VAL    85     -10.812   7.810  -5.456  1.00  1.00          
ATOM   1395  CB  VAL    85      -9.646   6.150  -6.330  1.00  1.00          
ATOM   1396  HB  VAL    85      -8.581   6.030  -6.499  1.00  1.00          
ATOM   1397  CG1 VAL    85     -10.035   5.258  -5.126  1.00  1.00          
ATOM   1398 HG11 VAL    85     -11.101   5.079  -5.142  1.00  1.00          
ATOM   1399 HG12 VAL    85      -9.770   5.759  -4.207  1.00  1.00          
ATOM   1400 HG13 VAL    85      -9.511   4.313  -5.184  1.00  1.00          
ATOM   1401  CG2 VAL    85     -10.393   5.597  -7.571  1.00  1.00          
ATOM   1402 HG21 VAL    85     -10.481   6.377  -8.314  1.00  1.00          
ATOM   1403 HG22 VAL    85     -11.379   5.269  -7.279  1.00  1.00          
ATOM   1404 HG23 VAL    85      -9.849   4.761  -7.991  1.00  1.00          
ATOM   1405  C   VAL    85      -8.733   8.306  -5.209  1.00  1.00          
ATOM   1406  O   VAL    85      -7.655   8.571  -5.773  1.00  1.00          
ATOM   1407  N   LYS    86      -8.991   8.498  -3.887  1.00  1.00          
ATOM   1408  HN  LYS    86      -9.890   8.294  -3.556  1.00  1.00          
ATOM   1409  CA  LYS    86      -8.000   9.027  -2.925  1.00  1.00          
ATOM   1410  HA  LYS    86      -7.071   9.173  -3.455  1.00  1.00          
ATOM   1411  CB  LYS    86      -8.473  10.381  -2.362  1.00  1.00          
ATOM   1412  HB1 LYS    86      -8.009  10.529  -1.398  1.00  1.00          
ATOM   1413  HB2 LYS    86      -9.545  10.332  -2.223  1.00  1.00          
ATOM   1414  CG  LYS    86      -8.139  11.597  -3.250  1.00  1.00          
ATOM   1415  HG1 LYS    86      -8.972  12.293  -3.242  1.00  1.00          
ATOM   1416  HG2 LYS    86      -7.974  11.254  -4.259  1.00  1.00          
ATOM   1417  CD  LYS    86      -6.886  12.335  -2.776  1.00  1.00          
ATOM   1418  HD1 LYS    86      -6.049  11.653  -2.800  1.00  1.00          
ATOM   1419  HD2 LYS    86      -7.043  12.682  -1.765  1.00  1.00          
ATOM   1420  CE  LYS    86      -6.575  13.533  -3.661  1.00  1.00          
ATOM   1421  HE1 LYS    86      -7.425  14.199  -3.653  1.00  1.00          
ATOM   1422  HE2 LYS    86      -6.402  13.184  -4.668  1.00  1.00          
ATOM   1423  NZ  LYS    86      -5.372  14.274  -3.191  1.00  1.00          
ATOM   1424  HZ1 LYS    86      -5.657  15.075  -2.592  1.00  1.00          
ATOM   1425  HZ2 LYS    86      -4.837  14.638  -4.005  1.00  1.00          
ATOM   1426  HZ3 LYS    86      -4.756  13.644  -2.640  1.00  1.00          
ATOM   1427  C   LYS    86      -7.759   8.043  -1.773  1.00  1.00          
ATOM   1428  O   LYS    86      -8.720   7.452  -1.243  1.00  1.00          
ATOM   1429  N   LEU    87      -6.457   7.890  -1.420  1.00  1.00          
ATOM   1430  HN  LEU    87      -5.788   8.401  -1.914  1.00  1.00          
ATOM   1431  CA  LEU    87      -5.975   7.022  -0.331  1.00  1.00          
ATOM   1432  HA  LEU    87      -6.839   6.619   0.176  1.00  1.00          
ATOM   1433  CB  LEU    87      -5.117   5.864  -0.882  1.00  1.00          
ATOM   1434  HB1 LEU    87      -4.350   5.647  -0.155  1.00  1.00          
ATOM   1435  HB2 LEU    87      -4.637   6.212  -1.785  1.00  1.00          
ATOM   1436  CG  LEU    87      -5.861   4.550  -1.208  1.00  1.00          
ATOM   1437  HG  LEU    87      -6.926   4.721  -1.180  1.00  1.00          
ATOM   1438  CD1 LEU    87      -5.511   4.050  -2.604  1.00  1.00          
ATOM   1439 HD11 LEU    87      -5.965   4.693  -3.341  1.00  1.00          
ATOM   1440 HD12 LEU    87      -5.887   3.044  -2.725  1.00  1.00          
ATOM   1441 HD13 LEU    87      -4.438   4.049  -2.733  1.00  1.00          
ATOM   1442  CD2 LEU    87      -5.525   3.478  -0.176  1.00  1.00          
ATOM   1443 HD21 LEU    87      -5.823   3.815   0.806  1.00  1.00          
ATOM   1444 HD22 LEU    87      -4.462   3.285  -0.184  1.00  1.00          
ATOM   1445 HD23 LEU    87      -6.051   2.566  -0.418  1.00  1.00          
ATOM   1446  C   LEU    87      -5.175   7.851   0.674  1.00  1.00          
ATOM   1447  O   LEU    87      -4.291   8.640   0.276  1.00  1.00          
ATOM   1448  N   LYS    88      -5.529   7.665   1.963  1.00  1.00          
ATOM   1449  HN  LYS    88      -6.253   7.036   2.148  1.00  1.00          
ATOM   1450  HA  LYS    88      -4.275   9.146   2.707  1.00  1.00          
ATOM   1451  CB  LYS    88      -5.962   8.982   4.017  1.00  1.00          
ATOM   1452  HB1 LYS    88      -5.562   9.062   5.017  1.00  1.00          
ATOM   1453  HB2 LYS    88      -6.824   8.332   4.036  1.00  1.00          
ATOM   1454  CG  LYS    88      -6.418  10.364   3.571  1.00  1.00          
ATOM   1455  HG1 LYS    88      -6.771  10.305   2.552  1.00  1.00          
ATOM   1456  HG2 LYS    88      -5.579  11.042   3.624  1.00  1.00          
ATOM   1457  CD  LYS    88      -7.543  10.896   4.457  1.00  1.00          
ATOM   1458  HD1 LYS    88      -7.194  10.910   5.482  1.00  1.00          
ATOM   1459  HD2 LYS    88      -8.391  10.233   4.375  1.00  1.00          
ATOM   1460  CE  LYS    88      -7.980  12.309   4.053  1.00  1.00          
ATOM   1461  HE1 LYS    88      -7.103  12.879   3.782  1.00  1.00          
ATOM   1462  HE2 LYS    88      -8.465  12.784   4.896  1.00  1.00          
ATOM   1463  NZ  LYS    88      -8.931  12.307   2.900  1.00  1.00          
ATOM   1464  HZ1 LYS    88      -8.916  11.381   2.426  1.00  1.00          
ATOM   1465  HZ2 LYS    88      -8.663  13.040   2.213  1.00  1.00          
ATOM   1466  HZ3 LYS    88      -9.898  12.499   3.233  1.00  1.00          
ATOM   1467  CA  LYS    88      -4.895   8.357   3.108  1.00  1.00          
ATOM   1468  C   LYS    88      -4.008   7.403   3.912  1.00  1.00          
ATOM   1469  OT1 LYS    88      -4.429   6.247   4.147  1.00  1.00          
ATOM   1470  OT2 LYS    88      -2.897   7.822   4.299  1.00  1.00          
END
