
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   97 (  774),  selected   97 , name 2uzk_A
# Molecule2: number of CA atoms   87 ( 1451),  selected   87 , name T0476.pdb
# PARAMETERS: 2uzk_A.T0476.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      A       2           -
LGA    -       -      K       3           -
LGA    M   157_A      C       4          3.485
LGA    G   158_A      P       5           -
LGA    -       -      I       6           -
LGA    -       -      C       7           -
LGA    -       -      G       8           -
LGA    -       -      S       9           -
LGA    N   159_A      P      10           #
LGA    L   160_A      L      11          3.629
LGA    S   161_A      K      12          1.508
LGA    Y   162_A      W      13          1.585
LGA    A   163_A      E      14          2.293
LGA    D   164_A      E      15          2.252
LGA    L   165_A      L      16          1.485
LGA    I   166_A      I      17          2.980
LGA    T   167_A      E      18          3.682
LGA    R   168_A      E      19          3.605
LGA    A   169_A      M      20          3.654
LGA    I   170_A      -       -           -
LGA    E   171_A      L      21          1.548
LGA    S   172_A      I      22          3.946
LGA    S   173_A      I      23          3.115
LGA    P   174_A      E      24          4.091
LGA    D   175_A      N      25          3.130
LGA    K   176_A      F      26          3.711
LGA    R   177_A      E      27          1.334
LGA    -       -      E      28           -
LGA    L   178_A      I      29          1.134
LGA    T   179_A      V      30          3.935
LGA    -       -      K      31           -
LGA    -       -      D      32           -
LGA    L   180_A      R      33          1.610
LGA    S   181_A      E      34          2.000
LGA    Q   182_A      R      35          2.072
LGA    I   183_A      F      36          1.484
LGA    Y   184_A      L      37          1.176
LGA    E   185_A      A      38          2.484
LGA    W   186_A      Q      39          2.613
LGA    M   187_A      V      40          1.239
LGA    V   188_A      E      41          0.755
LGA    R   189_A      E      42          1.902
LGA    C   190_A      F      43          2.120
LGA    V   191_A      V      44          2.460
LGA    -       -      F      45           -
LGA    -       -      K      46           -
LGA    -       -      C      47           -
LGA    -       -      P      48           -
LGA    -       -      V      49           -
LGA    -       -      C      50           -
LGA    -       -      G      51           -
LGA    -       -      E      52           -
LGA    -       -      E      53           -
LGA    P   192_A      F      54          2.070
LGA    Y   193_A      Y      55          3.543
LGA    F   194_A      G      56          1.718
LGA    K   195_A      K      57          0.740
LGA    D   196_A      T      58           #
LGA    K   197_A      L      59           -
LGA    G   198_A      -       -           -
LGA    D   199_A      -       -           -
LGA    S   200_A      -       -           -
LGA    N   201_A      -       -           -
LGA    S   202_A      -       -           -
LGA    S   203_A      P      60          5.265
LGA    A   204_A      R      61          1.259
LGA    G   205_A      R      62          1.594
LGA    W   206_A      E      63          1.709
LGA    K   207_A      A      64          1.855
LGA    N   208_A      E      65          1.165
LGA    S   209_A      K      66          0.734
LGA    I   210_A      V      67          1.475
LGA    R   211_A      F      68          2.350
LGA    H   212_A      E      69          2.486
LGA    N   213_A      L      70          3.743
LGA    L   214_A      L      71          4.481
LGA    -       -      N      72           -
LGA    S   215_A      D      73          1.819
LGA    L   216_A      F      74           #
LGA    -       -      K      75           -
LGA    H   217_A      G      76           #
LGA    S   218_A      G      77          1.849
LGA    R   219_A      I      78          2.376
LGA    F   220_A      -       -           -
LGA    M   221_A      -       -           -
LGA    R   222_A      -       -           -
LGA    V   223_A      -       -           -
LGA    Q   224_A      -       -           -
LGA    N   225_A      -       -           -
LGA    E   226_A      -       -           -
LGA    G   227_A      -       -           -
LGA    T   228_A      -       -           -
LGA    G   229_A      -       -           -
LGA    K   230_A      -       -           -
LGA    S   231_A      -       -           -
LGA    S   232_A      -       -           -
LGA    W   233_A      -       -           -
LGA    W   234_A      -       -           -
LGA    I   235_A      -       -           -
LGA    I   236_A      -       -           -
LGA    N   237_A      D      79          1.915
LGA    P   238_A      W      80          5.076
LGA    D   239_A      E      81          3.317
LGA    G   240_A      N      82          4.149
LGA    G   241_A      K      83           -
LGA    K   242_A      R      84           #
LGA    S   243_A      V      85           -
LGA    G   244_A      -       -           -
LGA    K   245_A      -       -           -
LGA    A   246_A      K      86           #
LGA    P   247_A      L      87           -
LGA    R   248_A      K      88           #
LGA    R   249_A      -       -           -
LGA    R   250_A      -       -           -
LGA    A   251_A      -       -           -
LGA    V   252_A      -       -           -
LGA    S   253_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   97   87    5.0     55    2.70    12.73     42.715     1.966

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.678162 * X  +   0.131210 * Y  +  -0.723104 * Z  +  -1.259568
  Y_new =  -0.541641 * X  +   0.575781 * Y  +   0.612455 * Z  +  10.372761
  Z_new =   0.496710 * X  +   0.807007 * Y  +  -0.319404 * Z  +   7.034121 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.947667   -1.193926  [ DEG:   111.5931    -68.4069 ]
  Theta =  -0.519804   -2.621789  [ DEG:   -29.7826   -150.2174 ]
  Phi   =  -2.467651    0.673941  [ DEG:  -141.3860     38.6140 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2uzk_A                                        
REMARK     2: T0476.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2uzk_A.T0476.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   97   87   5.0   55   2.70   12.73  42.715
REMARK  ---------------------------------------------------------- 
MOLECULE 2uzk_A
HEADER    TRANSCRIPTION                           30-APR-07   2UZK              
TITLE     CRYSTAL STRUCTURE OF THE HUMAN FOXO3A-DBD BOUND TO DNA                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: FORKHEAD BOX PROTEIN O3A;                                  
COMPND   3 SYNONYM: FORKHEAD IN RHABDOMYOSARCOMA-LIKE 1,                        
COMPND   4  AF6Q21 PROTEIN;                                                     
COMPND   5 CHAIN: A, C;                                                         
COMPND   6 FRAGMENT: DNA-BINDING DOMAIN, RESIDUES 158-253;                      
COMPND   7 ENGINEERED: YES;                                                     
COMPND   8 MOL_ID: 2;                                                           
COMPND   9 MOLECULE: 5'-D(*CP*TP*AP*TP*GP*TP*AP*AP*AP*CP                        
COMPND  10  *AP*AP*C)-3';                                                       
COMPND  11 SYNONYM: FOXO CONSENSUS BINDING SEQUENCE;                            
COMPND  12 CHAIN: B, D;                                                         
COMPND  13 MOL_ID: 3;                                                           
COMPND  14 MOLECULE: 5'-D(*GP*TP*TP*GP*TP*TP*TP*AP*CP*AP                        
COMPND  15  *TP*AP*G)-3';                                                       
COMPND  16 SYNONYM: FOXO CONSENSUS BINDING SEQUENCE;                            
COMPND  17 CHAIN: E, F                                                          
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   3 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   4 EXPRESSION_SYSTEM_PLASMID: PET-21B;                                  
SOURCE   5 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   6 ORGANISM_COMMON: HUMAN;                                              
SOURCE   7 MOL_ID: 2;                                                           
SOURCE   8 SYNTHETIC: YES;                                                      
SOURCE   9 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE  10 ORGANISM_COMMON: HUMAN;                                              
SOURCE  11 MOL_ID: 3;                                                           
SOURCE  12 SYNTHETIC: YES;                                                      
SOURCE  13 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE  14 ORGANISM_COMMON: HUMAN                                               
KEYWDS    TRANSCRIPTION REGULATION, CHROMOSOMAL REARRANGEMENT, FOXO,            
KEYWDS   2 FORKHEAD, ACTIVATOR, APOPTOSIS, DNA-BINDING, WINGED HELIX,           
KEYWDS   3 TRANSCRIPTION, PROTO-ONCOGENE, FORKHEAD TRANSCRIPTION                
KEYWDS   4 FACTORS, NUCLEAR PROTEIN, PHOSPHORYLATION, DNA-BINDING               
KEYWDS   5 DOMAIN                                                               
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.-L.TSAI,Y.-J.SUN,C.-Y.HUANG,J.-Y.YANG,M.-C.HUNG,                    
AUTHOR   2 C.-D.HSIAO                                                           
REVDAT   1   13-MAY-08 2UZK    0                                                
JRNL        AUTH   K.-L.TSAI,Y.-J.SUN,C.-Y.HUANG,J.-Y.YANG,M.-C.HUNG,           
JRNL        AUTH 2 C.-D.HSIAO                                                   
JRNL        TITL   CRYSTAL STRUCTURE OF THE HUMAN FOXO3A-DBD BOUND TO           
JRNL        TITL 2 DNA                                                          
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.7  ANGSTROMS.                                          
DBREF  2UZK A  157   157  PDB    2UZK     2UZK           157    157             
DBREF  2UZK A  158   253  UNP    O43524   FOXO3_HUMAN    158    253             
DBREF  2UZK B    1    13  PDB    2UZK     2UZK             1     13             
DBREF  2UZK C 1157  1157  PDB    2UZK     2UZK          1157   1157             
DBREF  2UZK C 1158  1253  UNP    O43524   FOXO3_HUMAN    158    253             
DBREF  2UZK D 1001  1013  PDB    2UZK     2UZK          1001   1013             
DBREF  2UZK E   25    37  PDB    2UZK     2UZK            25     37             
DBREF  2UZK F 1025  1037  PDB    2UZK     2UZK          1025   1037             
SEQRES   1 A   97  MET GLY ASN LEU SER TYR ALA ASP LEU ILE THR ARG ALA          
SEQRES   2 A   97  ILE GLU SER SER PRO ASP LYS ARG LEU THR LEU SER GLN          
SEQRES   3 A   97  ILE TYR GLU TRP MET VAL ARG CYS VAL PRO TYR PHE LYS          
SEQRES   4 A   97  ASP LYS GLY ASP SER ASN SER SER ALA GLY TRP LYS ASN          
SEQRES   5 A   97  SER ILE ARG HIS ASN LEU SER LEU HIS SER ARG PHE MET          
SEQRES   6 A   97  ARG VAL GLN ASN GLU GLY THR GLY LYS SER SER TRP TRP          
SEQRES   7 A   97  ILE ILE ASN PRO ASP GLY GLY LYS SER GLY LYS ALA PRO          
SEQRES   8 A   97  ARG ARG ARG ALA VAL SER                                      
SEQRES   1 B   13   DC  DT  DA  DT  DG  DT  DA  DA  DA  DC  DA  DA  DC          
SEQRES   1 C   97  MET GLY ASN LEU SER TYR ALA ASP LEU ILE THR ARG ALA          
SEQRES   2 C   97  ILE GLU SER SER PRO ASP LYS ARG LEU THR LEU SER GLN          
SEQRES   3 C   97  ILE TYR GLU TRP MET VAL ARG CYS VAL PRO TYR PHE LYS          
SEQRES   4 C   97  ASP LYS GLY ASP SER ASN SER SER ALA GLY TRP LYS ASN          
SEQRES   5 C   97  SER ILE ARG HIS ASN LEU SER LEU HIS SER ARG PHE MET          
SEQRES   6 C   97  ARG VAL GLN ASN GLU GLY THR GLY LYS SER SER TRP TRP          
SEQRES   7 C   97  ILE ILE ASN PRO ASP GLY GLY LYS SER GLY LYS ALA PRO          
SEQRES   8 C   97  ARG ARG ARG ALA VAL SER                                      
SEQRES   1 D   13   DC  DT  DA  DT  DG  DT  DA  DA  DA  DC  DA  DA  DC          
SEQRES   1 E   13   DG  DT  DT  DG  DT  DT  DT  DA  DC  DA  DT  DA  DG          
SEQRES   1 F   13   DG  DT  DT  DG  DT  DT  DT  DA  DC  DA  DT  DA  DG          
FORMUL   7  HOH   *209(H2 O1)                                                   
CRYST1   41.964   41.964  354.817  90.00  90.00 120.00 P 61         12          
ATOM      1  N   MET A 157       4.576  -5.038  -6.995  1.00 19.98           N  
ATOM      2  CA  MET A 157       3.912  -4.077  -7.896  1.00 21.70           C  
ATOM      3  C   MET A 157       4.796  -3.661  -9.086  1.00 23.70           C  
ATOM      4  O   MET A 157       5.811  -2.963  -8.918  1.00 24.51           O  
ATOM      5  CB  MET A 157       3.529  -2.848  -7.086  1.00 20.22           C  
ATOM      6  CG  MET A 157       3.386  -3.125  -5.594  1.00 18.96           C  
ATOM      7  SD  MET A 157       2.882  -1.663  -4.622  1.00 15.38           S  
ATOM      8  CE  MET A 157       1.122  -1.971  -4.416  1.00 16.43           C  
ATOM      9  N   GLY A 158       4.425  -4.098 -10.287  1.00 25.81           N  
ATOM     10  CA  GLY A 158       5.178  -3.703 -11.460  1.00 28.61           C  
ATOM     11  C   GLY A 158       5.047  -2.200 -11.580  1.00 30.63           C  
ATOM     12  O   GLY A 158       5.886  -1.444 -11.115  1.00 32.40           O  
ATOM     13  N   ASN A 159       3.946  -1.746 -12.206  1.00 31.37           N  
ATOM     14  CA  ASN A 159       3.711  -0.300 -12.298  1.00 32.13           C  
ATOM     15  C   ASN A 159       2.777   0.308 -11.331  1.00 31.67           C  
ATOM     16  O   ASN A 159       3.163   1.305 -10.677  1.00 33.08           O  
ATOM     17  CB  ASN A 159       3.225  -0.020 -13.747  1.00 34.43           C  
ATOM     18  CG  ASN A 159       4.304  -0.137 -14.800  1.00 36.10           C  
ATOM     19  OD1 ASN A 159       5.369  -0.711 -14.551  1.00 37.54           O  
ATOM     20  ND2 ASN A 159       4.039   0.399 -15.984  1.00 37.83           N  
ATOM     21  N   LEU A 160       1.599  -0.255 -11.105  1.00 30.87           N  
ATOM     22  CA  LEU A 160       0.640   0.443 -10.252  1.00 26.51           C  
ATOM     23  C   LEU A 160       0.537   0.362  -8.742  1.00 23.33           C  
ATOM     24  O   LEU A 160       1.157  -0.472  -8.107  1.00 22.47           O  
ATOM     25  CB  LEU A 160      -0.729   0.283 -10.859  1.00 27.72           C  
ATOM     26  CG  LEU A 160      -1.004  -1.174 -11.189  1.00 29.16           C  
ATOM     27  CD1 LEU A 160      -2.087  -1.627 -10.287  1.00 30.45           C  
ATOM     28  CD2 LEU A 160      -1.430  -1.340 -12.638  1.00 30.59           C  
ATOM     29  N   SER A 161      -0.294   1.261  -8.209  1.00 20.38           N  
ATOM     30  CA  SER A 161      -0.535   1.426  -6.777  1.00 19.05           C  
ATOM     31  C   SER A 161      -1.749   0.701  -6.216  1.00 17.98           C  
ATOM     32  O   SER A 161      -2.640   0.276  -6.959  1.00 18.65           O  
ATOM     33  CB  SER A 161      -0.707   2.914  -6.456  1.00 15.94           C  
ATOM     34  OG  SER A 161       0.035   3.733  -7.354  1.00 12.38           O  
ATOM     35  N   TYR A 162      -1.773   0.575  -4.890  1.00 14.76           N  
ATOM     36  CA  TYR A 162      -2.896  -0.044  -4.191  1.00 13.12           C  
ATOM     37  C   TYR A 162      -4.097   0.838  -4.497  1.00 12.96           C  
ATOM     38  O   TYR A 162      -5.166   0.353  -4.859  1.00 12.67           O  
ATOM     39  CB  TYR A 162      -2.671  -0.038  -2.684  1.00 12.08           C  
ATOM     40  CG  TYR A 162      -2.008  -1.273  -2.140  1.00 12.07           C  
ATOM     41  CD1 TYR A 162      -1.542  -1.313  -0.827  1.00 11.22           C  
ATOM     42  CD2 TYR A 162      -1.850  -2.407  -2.934  1.00 11.07           C  
ATOM     43  CE1 TYR A 162      -0.932  -2.449  -0.323  1.00 11.97           C  
ATOM     44  CE2 TYR A 162      -1.246  -3.546  -2.440  1.00 11.41           C  
ATOM     45  CZ  TYR A 162      -0.786  -3.563  -1.138  1.00 11.87           C  
ATOM     46  OH  TYR A 162      -0.158  -4.685  -0.646  1.00 13.62           O  
ATOM     47  N   ALA A 163      -3.917   2.141  -4.352  1.00 13.30           N  
ATOM     48  CA  ALA A 163      -4.986   3.089  -4.625  1.00 14.94           C  
ATOM     49  C   ALA A 163      -5.651   2.697  -5.936  1.00 15.76           C  
ATOM     50  O   ALA A 163      -6.823   2.327  -5.976  1.00 15.89           O  
ATOM     51  CB  ALA A 163      -4.405   4.505  -4.735  1.00 16.29           C  
ATOM     52  N   ASP A 164      -4.872   2.767  -7.008  1.00 16.39           N  
ATOM     53  CA  ASP A 164      -5.339   2.433  -8.340  1.00 16.87           C  
ATOM     54  C   ASP A 164      -5.993   1.048  -8.437  1.00 17.38           C  
ATOM     55  O   ASP A 164      -7.147   0.933  -8.860  1.00 15.92           O  
ATOM     56  CB  ASP A 164      -4.171   2.554  -9.326  1.00 17.31           C  
ATOM     57  CG  ASP A 164      -4.347   3.712 -10.298  1.00 17.31           C  
ATOM     58  OD1 ASP A 164      -5.067   4.679  -9.957  1.00 16.12           O  
ATOM     59  OD2 ASP A 164      -3.757   3.661 -11.399  1.00 20.51           O  
ATOM     60  N   LEU A 165      -5.267   0.001  -8.046  1.00 18.96           N  
ATOM     61  CA  LEU A 165      -5.802  -1.363  -8.106  1.00 17.91           C  
ATOM     62  C   LEU A 165      -7.232  -1.452  -7.620  1.00 18.83           C  
ATOM     63  O   LEU A 165      -8.093  -1.987  -8.303  1.00 17.65           O  
ATOM     64  CB  LEU A 165      -4.958  -2.323  -7.271  1.00 17.00           C  
ATOM     65  CG  LEU A 165      -4.057  -3.304  -8.025  1.00 18.48           C  
ATOM     66  CD1 LEU A 165      -4.488  -3.416  -9.494  1.00 18.27           C  
ATOM     67  CD2 LEU A 165      -2.611  -2.857  -7.881  1.00 13.28           C  
ATOM     68  N   ILE A 166      -7.474  -0.933  -6.423  1.00 21.37           N  
ATOM     69  CA  ILE A 166      -8.811  -0.950  -5.843  1.00 21.41           C  
ATOM     70  C   ILE A 166      -9.799  -0.266  -6.802  1.00 22.96           C  
ATOM     71  O   ILE A 166     -10.834  -0.836  -7.163  1.00 24.55           O  
ATOM     72  CB  ILE A 166      -8.826  -0.221  -4.487  1.00 20.34           C  
ATOM     73  CG1 ILE A 166      -7.895  -0.931  -3.508  1.00 20.29           C  
ATOM     74  CG2 ILE A 166     -10.239  -0.177  -3.934  1.00 18.86           C  
ATOM     75  CD1 ILE A 166      -7.737  -0.204  -2.182  1.00 21.96           C  
ATOM     76  N   THR A 167      -9.463   0.950  -7.221  1.00 20.59           N  
ATOM     77  CA  THR A 167     -10.295   1.709  -8.143  1.00 18.77           C  
ATOM     78  C   THR A 167     -10.553   0.918  -9.434  1.00 18.07           C  
ATOM     79  O   THR A 167     -11.516   1.184 -10.161  1.00 17.92           O  
ATOM     80  CB  THR A 167      -9.591   3.028  -8.526  1.00 19.13           C  
ATOM     81  OG1 THR A 167      -9.179   3.721  -7.340  1.00 17.46           O  
ATOM     82  CG2 THR A 167     -10.513   3.918  -9.337  1.00 19.35           C  
ATOM     83  N   ARG A 168      -9.677  -0.047  -9.706  1.00 14.40           N  
ATOM     84  CA  ARG A 168      -9.736  -0.863 -10.911  1.00 13.61           C  
ATOM     85  C   ARG A 168     -10.675  -2.059 -10.754  1.00 12.76           C  
ATOM     86  O   ARG A 168     -11.480  -2.354 -11.635  1.00 10.65           O  
ATOM     87  CB  ARG A 168      -8.305  -1.309 -11.244  1.00 12.34           C  
ATOM     88  CG  ARG A 168      -8.096  -2.011 -12.559  1.00 12.59           C  
ATOM     89  CD  ARG A 168      -6.668  -2.562 -12.639  1.00 15.20           C  
ATOM     90  NE  ARG A 168      -5.677  -1.594 -13.117  1.00 16.26           N  
ATOM     91  CZ  ARG A 168      -5.260  -1.495 -14.382  1.00 16.97           C  
ATOM     92  NH1 ARG A 168      -4.357  -0.584 -14.712  1.00 17.25           N  
ATOM     93  NH2 ARG A 168      -5.732  -2.306 -15.324  1.00 14.67           N  
ATOM     94  N   ALA A 169     -10.564  -2.739  -9.621  1.00 15.56           N  
ATOM     95  CA  ALA A 169     -11.397  -3.897  -9.331  1.00 18.03           C  
ATOM     96  C   ALA A 169     -12.827  -3.419  -9.360  1.00 19.93           C  
ATOM     97  O   ALA A 169     -13.687  -4.004 -10.008  1.00 21.31           O  
ATOM     98  CB  ALA A 169     -11.067  -4.439  -7.956  1.00 16.94           C  
ATOM     99  N   ILE A 170     -13.040  -2.314  -8.655  1.00 23.92           N  
ATOM    100  CA  ILE A 170     -14.331  -1.653  -8.511  1.00 24.31           C  
ATOM    101  C   ILE A 170     -14.863  -1.129  -9.863  1.00 25.72           C  
ATOM    102  O   ILE A 170     -16.067  -0.882 -10.015  1.00 25.01           O  
ATOM    103  CB  ILE A 170     -14.186  -0.505  -7.464  1.00 24.96           C  
ATOM    104  CG1 ILE A 170     -15.530  -0.187  -6.819  1.00 24.11           C  
ATOM    105  CG2 ILE A 170     -13.566   0.709  -8.100  1.00 27.63           C  
ATOM    106  CD1 ILE A 170     -15.922  -1.208  -5.782  1.00 26.61           C  
ATOM    107  N   GLU A 171     -13.965  -0.987 -10.843  1.00 26.80           N  
ATOM    108  CA  GLU A 171     -14.340  -0.522 -12.183  1.00 26.68           C  
ATOM    109  C   GLU A 171     -15.030  -1.606 -13.008  1.00 26.86           C  
ATOM    110  O   GLU A 171     -16.092  -1.372 -13.577  1.00 26.64           O  
ATOM    111  CB  GLU A 171     -13.114  -0.019 -12.949  1.00 28.90           C  
ATOM    112  CG  GLU A 171     -13.419   0.520 -14.355  1.00 31.73           C  
ATOM    113  CD  GLU A 171     -13.295  -0.540 -15.437  1.00 32.10           C  
ATOM    114  OE1 GLU A 171     -13.640  -0.255 -16.606  1.00 31.46           O  
ATOM    115  OE2 GLU A 171     -12.842  -1.658 -15.118  1.00 33.77           O  
ATOM    116  N   SER A 172     -14.441  -2.795 -13.092  1.00 26.13           N  
ATOM    117  CA  SER A 172     -15.106  -3.843 -13.858  1.00 26.30           C  
ATOM    118  C   SER A 172     -15.787  -4.890 -12.979  1.00 24.58           C  
ATOM    119  O   SER A 172     -15.158  -5.828 -12.487  1.00 26.80           O  
ATOM    120  CB  SER A 172     -14.142  -4.516 -14.853  1.00 26.86           C  
ATOM    121  OG  SER A 172     -13.167  -5.316 -14.211  1.00 29.96           O  
ATOM    122  N   SER A 173     -17.086  -4.679 -12.789  1.00 22.61           N  
ATOM    123  CA  SER A 173     -17.964  -5.545 -12.019  1.00 21.73           C  
ATOM    124  C   SER A 173     -19.316  -5.492 -12.752  1.00 19.80           C  
ATOM    125  O   SER A 173     -19.618  -4.501 -13.425  1.00 22.34           O  
ATOM    126  CB  SER A 173     -18.116  -5.012 -10.594  1.00 21.97           C  
ATOM    127  OG  SER A 173     -16.896  -5.082  -9.880  1.00 23.78           O  
ATOM    128  N   PRO A 174     -20.135  -6.556 -12.650  1.00 17.44           N  
ATOM    129  CA  PRO A 174     -21.449  -6.614 -13.306  1.00 13.71           C  
ATOM    130  C   PRO A 174     -22.177  -5.317 -13.003  1.00 10.25           C  
ATOM    131  O   PRO A 174     -22.782  -4.690 -13.869  1.00  9.39           O  
ATOM    132  CB  PRO A 174     -22.109  -7.814 -12.639  1.00 15.45           C  
ATOM    133  CG  PRO A 174     -20.954  -8.713 -12.381  1.00 17.90           C  
ATOM    134  CD  PRO A 174     -19.918  -7.750 -11.817  1.00 18.06           C  
ATOM    135  N   ASP A 175     -22.123  -4.940 -11.735  1.00  7.53           N  
ATOM    136  CA  ASP A 175     -22.696  -3.690 -11.269  1.00  4.64           C  
ATOM    137  C   ASP A 175     -21.486  -3.133 -10.548  1.00  4.24           C  
ATOM    138  O   ASP A 175     -20.682  -3.892 -10.017  1.00  5.11           O  
ATOM    139  CB  ASP A 175     -23.857  -3.931 -10.309  1.00  2.62           C  
ATOM    140  CG  ASP A 175     -24.893  -4.862 -10.880  1.00  0.00           C  
ATOM    141  OD1 ASP A 175     -24.897  -6.066 -10.534  1.00  0.00           O  
ATOM    142  OD2 ASP A 175     -25.701  -4.383 -11.686  1.00  0.00           O  
ATOM    143  N   LYS A 176     -21.351  -1.820 -10.526  1.00  5.50           N  
ATOM    144  CA  LYS A 176     -20.186  -1.185  -9.926  1.00  7.23           C  
ATOM    145  C   LYS A 176     -19.670  -1.553  -8.527  1.00  7.04           C  
ATOM    146  O   LYS A 176     -18.471  -1.499  -8.286  1.00  9.90           O  
ATOM    147  CB  LYS A 176     -20.382   0.326  -9.971  1.00  7.84           C  
ATOM    148  CG  LYS A 176     -19.302   1.081  -9.230  1.00  8.53           C  
ATOM    149  CD  LYS A 176     -19.646   2.528  -9.129  1.00  7.31           C  
ATOM    150  CE  LYS A 176     -18.504   3.314  -8.553  1.00  5.10           C  
ATOM    151  NZ  LYS A 176     -18.833   4.755  -8.621  1.00  6.58           N  
ATOM    152  N   ARG A 177     -20.551  -1.939  -7.621  1.00  6.68           N  
ATOM    153  CA  ARG A 177     -20.160  -2.207  -6.238  1.00  6.75           C  
ATOM    154  C   ARG A 177     -19.451  -3.485  -5.787  1.00  4.60           C  
ATOM    155  O   ARG A 177     -19.843  -4.595  -6.145  1.00  6.96           O  
ATOM    156  CB  ARG A 177     -21.398  -2.047  -5.368  1.00  9.31           C  
ATOM    157  CG  ARG A 177     -22.388  -3.148  -5.585  1.00  5.58           C  
ATOM    158  CD  ARG A 177     -23.775  -2.644  -5.368  1.00  4.23           C  
ATOM    159  NE  ARG A 177     -24.527  -2.607  -6.615  1.00  5.22           N  
ATOM    160  CZ  ARG A 177     -25.773  -3.056  -6.736  1.00  5.39           C  
ATOM    161  NH1 ARG A 177     -26.404  -2.988  -7.909  1.00  4.65           N  
ATOM    162  NH2 ARG A 177     -26.385  -3.582  -5.677  1.00  2.28           N  
ATOM    163  N   LEU A 178     -18.425  -3.300  -4.958  1.00  2.72           N  
ATOM    164  CA  LEU A 178     -17.676  -4.399  -4.366  1.00  0.00           C  
ATOM    165  C   LEU A 178     -17.611  -4.251  -2.833  1.00  0.00           C  
ATOM    166  O   LEU A 178     -17.983  -3.218  -2.236  1.00  0.00           O  
ATOM    167  CB  LEU A 178     -16.257  -4.485  -4.923  1.00  0.00           C  
ATOM    168  CG  LEU A 178     -16.129  -4.959  -6.375  1.00  0.00           C  
ATOM    169  CD1 LEU A 178     -14.668  -5.015  -6.776  1.00  0.00           C  
ATOM    170  CD2 LEU A 178     -16.795  -6.332  -6.534  1.00  0.00           C  
ATOM    171  N   THR A 179     -17.114  -5.306  -2.209  1.00  0.00           N  
ATOM    172  CA  THR A 179     -17.004  -5.389  -0.770  1.00  1.05           C  
ATOM    173  C   THR A 179     -15.604  -5.865  -0.433  1.00  0.50           C  
ATOM    174  O   THR A 179     -14.975  -6.564  -1.232  1.00  0.00           O  
ATOM    175  CB  THR A 179     -18.026  -6.393  -0.261  1.00  0.00           C  
ATOM    176  OG1 THR A 179     -19.305  -6.020  -0.784  1.00  0.00           O  
ATOM    177  CG2 THR A 179     -18.062  -6.415   1.275  1.00  0.00           C  
ATOM    178  N   LEU A 180     -15.106  -5.488   0.736  1.00  0.71           N  
ATOM    179  CA  LEU A 180     -13.776  -5.926   1.105  1.00  0.22           C  
ATOM    180  C   LEU A 180     -13.616  -7.357   0.602  1.00  0.00           C  
ATOM    181  O   LEU A 180     -12.878  -7.602  -0.347  1.00  0.00           O  
ATOM    182  CB  LEU A 180     -13.594  -5.855   2.620  1.00  0.00           C  
ATOM    183  CG  LEU A 180     -13.319  -4.484   3.234  1.00  0.00           C  
ATOM    184  CD1 LEU A 180     -14.415  -3.540   2.885  1.00  0.00           C  
ATOM    185  CD2 LEU A 180     -13.205  -4.619   4.732  1.00  0.00           C  
ATOM    186  N   SER A 181     -14.332  -8.293   1.219  1.00  0.78           N  
ATOM    187  CA  SER A 181     -14.261  -9.698   0.804  1.00  2.74           C  
ATOM    188  C   SER A 181     -14.148  -9.824  -0.721  1.00  1.03           C  
ATOM    189  O   SER A 181     -13.206 -10.442  -1.230  1.00  0.00           O  
ATOM    190  CB  SER A 181     -15.495 -10.446   1.299  1.00  3.17           C  
ATOM    191  OG  SER A 181     -16.650  -9.632   1.144  1.00 12.97           O  
ATOM    192  N   GLN A 182     -15.090  -9.207  -1.434  1.00  0.42           N  
ATOM    193  CA  GLN A 182     -15.122  -9.221  -2.898  1.00  0.00           C  
ATOM    194  C   GLN A 182     -13.897  -8.549  -3.487  1.00  0.00           C  
ATOM    195  O   GLN A 182     -13.344  -9.019  -4.471  1.00  0.00           O  
ATOM    196  CB  GLN A 182     -16.383  -8.510  -3.414  1.00  0.00           C  
ATOM    197  CG  GLN A 182     -17.681  -9.163  -2.954  1.00  1.73           C  
ATOM    198  CD  GLN A 182     -18.897  -8.364  -3.343  1.00  1.40           C  
ATOM    199  OE1 GLN A 182     -19.152  -8.158  -4.516  1.00  3.20           O  
ATOM    200  NE2 GLN A 182     -19.651  -7.902  -2.361  1.00  5.21           N  
ATOM    201  N   ILE A 183     -13.487  -7.430  -2.899  1.00  1.08           N  
ATOM    202  CA  ILE A 183     -12.305  -6.728  -3.385  1.00  1.80           C  
ATOM    203  C   ILE A 183     -11.155  -7.685  -3.126  1.00  3.63           C  
ATOM    204  O   ILE A 183     -10.438  -8.072  -4.033  1.00  5.55           O  
ATOM    205  CB  ILE A 183     -12.058  -5.416  -2.616  1.00  1.22           C  
ATOM    206  CG1 ILE A 183     -13.288  -4.510  -2.706  1.00  0.00           C  
ATOM    207  CG2 ILE A 183     -10.858  -4.708  -3.193  1.00  0.95           C  
ATOM    208  CD1 ILE A 183     -13.259  -3.366  -1.748  1.00  0.00           C  
ATOM    209  N   TYR A 184     -11.004  -8.090  -1.875  1.00  7.49           N  
ATOM    210  CA  TYR A 184      -9.953  -9.027  -1.508  1.00  8.95           C  
ATOM    211  C   TYR A 184      -9.888 -10.162  -2.534  1.00  9.71           C  
ATOM    212  O   TYR A 184      -8.809 -10.567  -2.951  1.00  9.45           O  
ATOM    213  CB  TYR A 184     -10.220  -9.600  -0.113  1.00 10.26           C  
ATOM    214  CG  TYR A 184     -10.087  -8.594   1.010  1.00 10.28           C  
ATOM    215  CD1 TYR A 184      -8.920  -7.839   1.157  1.00 12.55           C  
ATOM    216  CD2 TYR A 184     -11.098  -8.433   1.958  1.00  7.23           C  
ATOM    217  CE1 TYR A 184      -8.762  -6.950   2.229  1.00 12.97           C  
ATOM    218  CE2 TYR A 184     -10.948  -7.543   3.033  1.00  7.65           C  
ATOM    219  CZ  TYR A 184      -9.777  -6.812   3.160  1.00  9.20           C  
ATOM    220  OH  TYR A 184      -9.595  -5.958   4.221  1.00  6.82           O  
ATOM    221  N   GLU A 185     -11.046 -10.666  -2.952  1.00 12.33           N  
ATOM    222  CA  GLU A 185     -11.077 -11.747  -3.936  1.00 13.12           C  
ATOM    223  C   GLU A 185     -10.425 -11.312  -5.240  1.00 12.55           C  
ATOM    224  O   GLU A 185      -9.619 -12.059  -5.817  1.00 13.52           O  
ATOM    225  CB  GLU A 185     -12.513 -12.193  -4.204  1.00 11.28           C  
ATOM    226  CG  GLU A 185     -13.198 -12.719  -2.974  1.00 17.44           C  
ATOM    227  CD  GLU A 185     -12.526 -13.957  -2.423  1.00 20.88           C  
ATOM    228  OE1 GLU A 185     -12.840 -14.380  -1.285  1.00 21.98           O  
ATOM    229  OE2 GLU A 185     -11.682 -14.523  -3.144  1.00 26.48           O  
ATOM    230  N   TRP A 186     -10.768 -10.112  -5.704  1.00  9.39           N  
ATOM    231  CA  TRP A 186     -10.187  -9.624  -6.942  1.00  8.03           C  
ATOM    232  C   TRP A 186      -8.677  -9.752  -6.798  1.00  6.60           C  
ATOM    233  O   TRP A 186      -8.030 -10.514  -7.510  1.00  4.23           O  
ATOM    234  CB  TRP A 186     -10.569  -8.157  -7.203  1.00  7.86           C  
ATOM    235  CG  TRP A 186     -10.446  -7.769  -8.665  1.00  9.38           C  
ATOM    236  CD1 TRP A 186     -11.247  -8.185  -9.690  1.00 11.93           C  
ATOM    237  CD2 TRP A 186      -9.424  -6.955  -9.266  1.00 11.37           C  
ATOM    238  NE1 TRP A 186     -10.791  -7.690 -10.891  1.00 10.57           N  
ATOM    239  CE2 TRP A 186      -9.673  -6.934 -10.661  1.00 11.50           C  
ATOM    240  CE3 TRP A 186      -8.322  -6.244  -8.764  1.00 11.35           C  
ATOM    241  CZ2 TRP A 186      -8.857  -6.234 -11.557  1.00 11.51           C  
ATOM    242  CZ3 TRP A 186      -7.510  -5.546  -9.658  1.00  9.68           C  
ATOM    243  CH2 TRP A 186      -7.783  -5.547 -11.037  1.00 11.89           C  
ATOM    244  N   MET A 187      -8.126  -9.022  -5.840  1.00  5.51           N  
ATOM    245  CA  MET A 187      -6.694  -9.023  -5.597  1.00  5.54           C  
ATOM    246  C   MET A 187      -6.063 -10.408  -5.684  1.00  5.28           C  
ATOM    247  O   MET A 187      -5.242 -10.683  -6.562  1.00  4.17           O  
ATOM    248  CB  MET A 187      -6.409  -8.417  -4.221  1.00  4.63           C  
ATOM    249  CG  MET A 187      -7.066  -7.072  -4.038  1.00  4.84           C  
ATOM    250  SD  MET A 187      -6.746  -6.022  -5.462  1.00  5.00           S  
ATOM    251  CE  MET A 187      -5.376  -4.963  -4.769  1.00  4.47           C  
ATOM    252  N   VAL A 188      -6.455 -11.266  -4.751  1.00  5.80           N  
ATOM    253  CA  VAL A 188      -5.942 -12.619  -4.653  1.00  4.99           C  
ATOM    254  C   VAL A 188      -6.075 -13.456  -5.920  1.00  5.57           C  
ATOM    255  O   VAL A 188      -5.249 -14.320  -6.169  1.00  1.92           O  
ATOM    256  CB  VAL A 188      -6.654 -13.384  -3.537  1.00  7.94           C  
ATOM    257  CG1 VAL A 188      -5.916 -14.661  -3.273  1.00  9.32           C  
ATOM    258  CG2 VAL A 188      -6.759 -12.537  -2.271  1.00  6.83           C  
ATOM    259  N   ARG A 189      -7.120 -13.222  -6.709  1.00 10.99           N  
ATOM    260  CA  ARG A 189      -7.335 -14.001  -7.929  1.00 14.67           C  
ATOM    261  C   ARG A 189      -6.700 -13.422  -9.187  1.00 13.62           C  
ATOM    262  O   ARG A 189      -6.262 -14.169 -10.062  1.00 10.19           O  
ATOM    263  CB  ARG A 189      -8.833 -14.211  -8.179  1.00 21.28           C  
ATOM    264  CG  ARG A 189      -9.109 -14.988  -9.475  1.00 28.69           C  
ATOM    265  CD  ARG A 189     -10.519 -15.561  -9.521  1.00 36.02           C  
ATOM    266  NE  ARG A 189     -10.785 -16.213 -10.801  1.00 41.45           N  
ATOM    267  CZ  ARG A 189     -11.911 -16.859 -11.091  1.00 44.23           C  
ATOM    268  NH1 ARG A 189     -12.067 -17.422 -12.289  1.00 43.92           N  
ATOM    269  NH2 ARG A 189     -12.880 -16.949 -10.181  1.00 43.34           N  
ATOM    270  N   CYS A 190      -6.666 -12.096  -9.284  1.00 16.32           N  
ATOM    271  CA  CYS A 190      -6.069 -11.444 -10.444  1.00 19.91           C  
ATOM    272  C   CYS A 190      -4.632 -11.020 -10.163  1.00 17.58           C  
ATOM    273  O   CYS A 190      -4.196 -11.005  -9.013  1.00 18.18           O  
ATOM    274  CB  CYS A 190      -6.904 -10.235 -10.865  1.00 20.60           C  
ATOM    275  SG  CYS A 190      -8.643 -10.633 -11.155  1.00 29.07           S  
ATOM    276  N   VAL A 191      -3.913 -10.676 -11.228  1.00 18.12           N  
ATOM    277  CA  VAL A 191      -2.507 -10.265 -11.156  1.00 20.71           C  
ATOM    278  C   VAL A 191      -1.699 -11.166 -10.228  1.00 18.33           C  
ATOM    279  O   VAL A 191      -1.790 -11.083  -9.006  1.00 17.14           O  
ATOM    280  CB  VAL A 191      -2.335  -8.809 -10.684  1.00 18.71           C  
ATOM    281  CG1 VAL A 191      -0.852  -8.435 -10.728  1.00 17.47           C  
ATOM    282  CG2 VAL A 191      -3.140  -7.879 -11.565  1.00 18.12           C  
ATOM    283  N   PRO A 192      -0.871 -12.031 -10.812  1.00 17.57           N  
ATOM    284  CA  PRO A 192      -0.052 -12.947 -10.028  1.00 20.13           C  
ATOM    285  C   PRO A 192       0.362 -12.463  -8.640  1.00 17.64           C  
ATOM    286  O   PRO A 192       0.363 -13.238  -7.693  1.00 17.64           O  
ATOM    287  CB  PRO A 192       1.142 -13.192 -10.948  1.00 19.88           C  
ATOM    288  CG  PRO A 192       0.482 -13.227 -12.304  1.00 20.90           C  
ATOM    289  CD  PRO A 192      -0.467 -12.041 -12.232  1.00 19.99           C  
ATOM    290  N   TYR A 193       0.696 -11.184  -8.520  1.00 18.17           N  
ATOM    291  CA  TYR A 193       1.167 -10.621  -7.255  1.00 19.28           C  
ATOM    292  C   TYR A 193       0.553 -11.150  -5.954  1.00 19.66           C  
ATOM    293  O   TYR A 193       1.249 -11.818  -5.189  1.00 17.15           O  
ATOM    294  CB  TYR A 193       1.081  -9.094  -7.304  1.00 18.86           C  
ATOM    295  CG  TYR A 193       1.728  -8.410  -6.125  1.00 22.13           C  
ATOM    296  CD1 TYR A 193       3.083  -8.605  -5.815  1.00 20.50           C  
ATOM    297  CD2 TYR A 193       0.982  -7.569  -5.306  1.00 24.32           C  
ATOM    298  CE1 TYR A 193       3.667  -7.973  -4.715  1.00 19.88           C  
ATOM    299  CE2 TYR A 193       1.552  -6.937  -4.205  1.00 23.31           C  
ATOM    300  CZ  TYR A 193       2.891  -7.140  -3.915  1.00 22.86           C  
ATOM    301  OH  TYR A 193       3.434  -6.495  -2.824  1.00 23.75           O  
ATOM    302  N   PHE A 194      -0.717 -10.855  -5.675  1.00 23.37           N  
ATOM    303  CA  PHE A 194      -1.345 -11.351  -4.434  1.00 27.80           C  
ATOM    304  C   PHE A 194      -1.737 -12.820  -4.534  1.00 29.64           C  
ATOM    305  O   PHE A 194      -2.218 -13.269  -5.567  1.00 29.55           O  
ATOM    306  CB  PHE A 194      -2.599 -10.553  -4.063  1.00 26.51           C  
ATOM    307  CG  PHE A 194      -2.321  -9.172  -3.550  1.00 23.79           C  
ATOM    308  CD1 PHE A 194      -2.442  -8.070  -4.388  1.00 24.48           C  
ATOM    309  CD2 PHE A 194      -1.988  -8.967  -2.225  1.00 21.20           C  
ATOM    310  CE1 PHE A 194      -2.238  -6.778  -3.907  1.00 24.40           C  
ATOM    311  CE2 PHE A 194      -1.782  -7.683  -1.740  1.00 23.05           C  
ATOM    312  CZ  PHE A 194      -1.910  -6.586  -2.579  1.00 22.33           C  
ATOM    313  N   LYS A 195      -1.565 -13.556  -3.441  1.00 34.76           N  
ATOM    314  CA  LYS A 195      -1.863 -14.992  -3.420  1.00 38.49           C  
ATOM    315  C   LYS A 195      -2.664 -15.472  -2.205  1.00 40.15           C  
ATOM    316  O   LYS A 195      -3.220 -16.571  -2.197  1.00 38.56           O  
ATOM    317  CB  LYS A 195      -0.543 -15.769  -3.479  1.00 39.63           C  
ATOM    318  CG  LYS A 195      -0.698 -17.284  -3.548  1.00 41.00           C  
ATOM    319  CD  LYS A 195      -0.108 -17.972  -2.321  1.00 40.70           C  
ATOM    320  CE  LYS A 195      -1.174 -18.749  -1.558  1.00 41.47           C  
ATOM    321  NZ  LYS A 195      -1.885 -19.734  -2.422  1.00 37.53           N  
ATOM    322  N   ASP A 196      -2.739 -14.614  -1.200  1.00 44.36           N  
ATOM    323  CA  ASP A 196      -3.391 -14.899   0.067  1.00 48.20           C  
ATOM    324  C   ASP A 196      -4.686 -15.660   0.233  1.00 50.95           C  
ATOM    325  O   ASP A 196      -4.669 -16.711   0.850  1.00 52.65           O  
ATOM    326  CB  ASP A 196      -3.449 -13.606   0.843  1.00 49.30           C  
ATOM    327  CG  ASP A 196      -2.092 -13.005   0.958  1.00 50.55           C  
ATOM    328  OD1 ASP A 196      -1.144 -13.813   0.985  1.00 52.85           O  
ATOM    329  OD2 ASP A 196      -1.940 -11.776   1.011  1.00 51.70           O  
ATOM    330  N   LYS A 197      -5.799 -15.169  -0.294  1.00 54.45           N  
ATOM    331  CA  LYS A 197      -7.068 -15.871  -0.101  1.00 57.08           C  
ATOM    332  C   LYS A 197      -7.427 -16.921  -1.161  1.00 57.83           C  
ATOM    333  O   LYS A 197      -8.367 -17.693  -0.971  1.00 59.88           O  
ATOM    334  CB  LYS A 197      -8.190 -14.831   0.029  1.00 58.90           C  
ATOM    335  CG  LYS A 197      -9.274 -14.915  -1.027  1.00 62.31           C  
ATOM    336  CD  LYS A 197     -10.401 -15.829  -0.575  1.00 64.89           C  
ATOM    337  CE  LYS A 197     -10.967 -16.633  -1.737  1.00 65.23           C  
ATOM    338  NZ  LYS A 197     -12.320 -17.165  -1.417  1.00 63.93           N  
ATOM    339  N   GLY A 198      -6.667 -16.964  -2.253  1.00 58.51           N  
ATOM    340  CA  GLY A 198      -6.926 -17.892  -3.349  1.00 58.39           C  
ATOM    341  C   GLY A 198      -7.445 -19.280  -3.013  1.00 58.46           C  
ATOM    342  O   GLY A 198      -8.543 -19.432  -2.473  1.00 58.10           O  
ATOM    343  N   ASP A 199      -6.669 -20.301  -3.365  1.00 57.97           N  
ATOM    344  CA  ASP A 199      -7.055 -21.672  -3.072  1.00 58.52           C  
ATOM    345  C   ASP A 199      -6.882 -21.882  -1.566  1.00 58.68           C  
ATOM    346  O   ASP A 199      -7.673 -22.587  -0.940  1.00 59.37           O  
ATOM    347  CB  ASP A 199      -6.189 -22.654  -3.869  1.00 57.72           C  
ATOM    348  CG  ASP A 199      -6.221 -22.379  -5.362  1.00 57.04           C  
ATOM    349  OD1 ASP A 199      -5.816 -23.263  -6.148  1.00 57.76           O  
ATOM    350  OD2 ASP A 199      -6.643 -21.272  -5.752  1.00 57.08           O  
ATOM    351  N   SER A 200      -5.848 -21.256  -0.999  1.00 58.08           N  
ATOM    352  CA  SER A 200      -5.557 -21.310   0.443  1.00 56.56           C  
ATOM    353  C   SER A 200      -5.853 -19.908   0.976  1.00 54.40           C  
ATOM    354  O   SER A 200      -6.525 -19.145   0.285  1.00 53.84           O  
ATOM    355  CB  SER A 200      -4.088 -21.664   0.699  1.00 58.02           C  
ATOM    356  OG  SER A 200      -3.791 -21.658   2.087  1.00 54.93           O  
ATOM    357  N   ASN A 201      -5.366 -19.536   2.164  1.00 53.20           N  
ATOM    358  CA  ASN A 201      -5.702 -18.186   2.627  1.00 52.22           C  
ATOM    359  C   ASN A 201      -4.970 -17.325   3.681  1.00 50.79           C  
ATOM    360  O   ASN A 201      -4.621 -17.757   4.781  1.00 48.78           O  
ATOM    361  CB  ASN A 201      -7.196 -18.148   2.982  1.00 53.24           C  
ATOM    362  CG  ASN A 201      -7.526 -18.958   4.214  1.00 54.57           C  
ATOM    363  OD1 ASN A 201      -7.544 -20.190   4.179  1.00 55.35           O  
ATOM    364  ND2 ASN A 201      -7.783 -18.268   5.321  1.00 55.46           N  
ATOM    365  N   SER A 202      -4.778 -16.071   3.274  1.00 50.61           N  
ATOM    366  CA  SER A 202      -4.224 -14.966   4.056  1.00 49.61           C  
ATOM    367  C   SER A 202      -2.771 -14.687   4.451  1.00 48.38           C  
ATOM    368  O   SER A 202      -2.197 -15.361   5.308  1.00 48.88           O  
ATOM    369  CB  SER A 202      -5.070 -14.817   5.321  1.00 49.17           C  
ATOM    370  OG  SER A 202      -6.404 -14.479   4.991  1.00 50.57           O  
ATOM    371  N   SER A 203      -2.205 -13.651   3.826  1.00 46.87           N  
ATOM    372  CA  SER A 203      -0.871 -13.151   4.159  1.00 42.88           C  
ATOM    373  C   SER A 203      -1.180 -11.874   4.934  1.00 41.74           C  
ATOM    374  O   SER A 203      -2.334 -11.443   5.014  1.00 39.06           O  
ATOM    375  CB  SER A 203      -0.022 -12.779   2.936  1.00 43.08           C  
ATOM    376  OG  SER A 203       0.883 -13.810   2.570  1.00 38.89           O  
ATOM    377  N   ALA A 204      -0.134 -11.260   5.466  1.00 37.74           N  
ATOM    378  CA  ALA A 204      -0.238 -10.067   6.293  1.00 35.07           C  
ATOM    379  C   ALA A 204      -0.966  -8.799   5.829  1.00 32.57           C  
ATOM    380  O   ALA A 204      -2.007  -8.842   5.172  1.00 32.49           O  
ATOM    381  CB  ALA A 204       1.157  -9.694   6.764  1.00 31.71           C  
ATOM    382  N   GLY A 205      -0.357  -7.672   6.233  1.00 27.80           N  
ATOM    383  CA  GLY A 205      -0.831  -6.314   6.001  1.00 20.93           C  
ATOM    384  C   GLY A 205      -1.519  -5.734   4.780  1.00 18.62           C  
ATOM    385  O   GLY A 205      -2.211  -4.731   4.920  1.00 20.67           O  
ATOM    386  N   TRP A 206      -1.348  -6.291   3.591  1.00 15.10           N  
ATOM    387  CA  TRP A 206      -2.033  -5.704   2.445  1.00 11.19           C  
ATOM    388  C   TRP A 206      -3.521  -5.624   2.767  1.00 11.99           C  
ATOM    389  O   TRP A 206      -4.230  -4.748   2.261  1.00 13.02           O  
ATOM    390  CB  TRP A 206      -1.829  -6.546   1.203  1.00  6.09           C  
ATOM    391  CG  TRP A 206      -2.365  -7.898   1.361  1.00  0.00           C  
ATOM    392  CD1 TRP A 206      -1.844  -8.894   2.118  1.00  0.00           C  
ATOM    393  CD2 TRP A 206      -3.554  -8.424   0.759  1.00  0.00           C  
ATOM    394  NE1 TRP A 206      -2.629 -10.014   2.025  1.00  0.00           N  
ATOM    395  CE2 TRP A 206      -3.684  -9.754   1.195  1.00  0.00           C  
ATOM    396  CE3 TRP A 206      -4.519  -7.900  -0.116  1.00  0.00           C  
ATOM    397  CZ2 TRP A 206      -4.737 -10.570   0.800  1.00  0.00           C  
ATOM    398  CZ3 TRP A 206      -5.561  -8.714  -0.507  1.00  0.00           C  
ATOM    399  CH2 TRP A 206      -5.660 -10.040  -0.050  1.00  0.00           C  
ATOM    400  N   LYS A 207      -3.978  -6.561   3.596  1.00 12.46           N  
ATOM    401  CA  LYS A 207      -5.361  -6.626   4.053  1.00 12.48           C  
ATOM    402  C   LYS A 207      -5.642  -5.265   4.642  1.00 13.11           C  
ATOM    403  O   LYS A 207      -6.551  -4.555   4.214  1.00 14.74           O  
ATOM    404  CB  LYS A 207      -5.497  -7.705   5.150  1.00 13.13           C  
ATOM    405  CG  LYS A 207      -6.755  -7.638   6.026  1.00  9.00           C  
ATOM    406  CD  LYS A 207      -6.675  -8.536   7.293  1.00  8.09           C  
ATOM    407  CE  LYS A 207      -6.843 -10.048   6.994  1.00  9.82           C  
ATOM    408  NZ  LYS A 207      -7.135 -10.864   8.216  1.00  6.18           N  
ATOM    409  N   ASN A 208      -4.815  -4.909   5.617  1.00 13.04           N  
ATOM    410  CA  ASN A 208      -4.916  -3.653   6.348  1.00 14.92           C  
ATOM    411  C   ASN A 208      -4.664  -2.435   5.468  1.00 14.51           C  
ATOM    412  O   ASN A 208      -5.256  -1.370   5.664  1.00 16.78           O  
ATOM    413  CB  ASN A 208      -3.911  -3.666   7.499  1.00 16.16           C  
ATOM    414  CG  ASN A 208      -4.339  -2.796   8.665  1.00 17.90           C  
ATOM    415  OD1 ASN A 208      -3.648  -2.734   9.684  1.00 21.08           O  
ATOM    416  ND2 ASN A 208      -5.488  -2.125   8.528  1.00 14.96           N  
ATOM    417  N   SER A 209      -3.781  -2.593   4.494  1.00 13.39           N  
ATOM    418  CA  SER A 209      -3.468  -1.494   3.609  1.00 10.93           C  
ATOM    419  C   SER A 209      -4.662  -1.097   2.752  1.00 10.36           C  
ATOM    420  O   SER A 209      -5.076   0.064   2.761  1.00  9.00           O  
ATOM    421  CB  SER A 209      -2.266  -1.857   2.737  1.00 12.48           C  
ATOM    422  OG  SER A 209      -1.096  -1.998   3.530  1.00  8.67           O  
ATOM    423  N   ILE A 210      -5.232  -2.047   2.019  1.00  9.36           N  
ATOM    424  CA  ILE A 210      -6.368  -1.715   1.172  1.00 11.36           C  
ATOM    425  C   ILE A 210      -7.431  -0.897   1.928  1.00 12.99           C  
ATOM    426  O   ILE A 210      -7.958   0.084   1.394  1.00 14.37           O  
ATOM    427  CB  ILE A 210      -7.005  -2.993   0.548  1.00 12.15           C  
ATOM    428  CG1 ILE A 210      -6.290  -3.353  -0.769  1.00  8.89           C  
ATOM    429  CG2 ILE A 210      -8.489  -2.770   0.279  1.00  9.66           C  
ATOM    430  CD1 ILE A 210      -4.900  -3.905  -0.592  1.00  8.15           C  
ATOM    431  N   ARG A 211      -7.725  -1.277   3.170  1.00 11.72           N  
ATOM    432  CA  ARG A 211      -8.717  -0.550   3.966  1.00 11.29           C  
ATOM    433  C   ARG A 211      -8.324   0.914   4.106  1.00 10.38           C  
ATOM    434  O   ARG A 211      -9.176   1.796   4.190  1.00 11.51           O  
ATOM    435  CB  ARG A 211      -8.838  -1.144   5.372  1.00 10.33           C  
ATOM    436  CG  ARG A 211      -9.169  -2.620   5.456  1.00  7.20           C  
ATOM    437  CD  ARG A 211      -9.237  -3.013   6.926  1.00 10.85           C  
ATOM    438  NE  ARG A 211      -8.547  -4.267   7.224  1.00 10.72           N  
ATOM    439  CZ  ARG A 211      -8.103  -4.602   8.430  1.00 10.32           C  
ATOM    440  NH1 ARG A 211      -7.486  -5.759   8.607  1.00 14.77           N  
ATOM    441  NH2 ARG A 211      -8.264  -3.777   9.453  1.00  8.81           N  
ATOM    442  N   HIS A 212      -7.019   1.152   4.151  1.00 10.50           N  
ATOM    443  CA  HIS A 212      -6.451   2.489   4.283  1.00  8.93           C  
ATOM    444  C   HIS A 212      -6.786   3.332   3.052  1.00  7.42           C  
ATOM    445  O   HIS A 212      -7.523   4.320   3.124  1.00  5.18           O  
ATOM    446  CB  HIS A 212      -4.933   2.366   4.411  1.00 12.18           C  
ATOM    447  CG  HIS A 212      -4.283   3.524   5.094  1.00 13.88           C  
ATOM    448  ND1 HIS A 212      -3.088   4.060   4.668  1.00 17.21           N  
ATOM    449  CD2 HIS A 212      -4.639   4.228   6.191  1.00 14.20           C  
ATOM    450  CE1 HIS A 212      -2.736   5.045   5.478  1.00 18.16           C  
ATOM    451  NE2 HIS A 212      -3.662   5.166   6.411  1.00 16.43           N  
ATOM    452  N   ASN A 213      -6.230   2.929   1.917  1.00  5.75           N  
ATOM    453  CA  ASN A 213      -6.466   3.634   0.664  1.00  5.80           C  
ATOM    454  C   ASN A 213      -7.950   4.002   0.506  1.00  5.52           C  
ATOM    455  O   ASN A 213      -8.287   5.190   0.436  1.00  4.92           O  
ATOM    456  CB  ASN A 213      -6.001   2.770  -0.513  1.00  4.60           C  
ATOM    457  CG  ASN A 213      -4.539   2.353  -0.394  1.00  3.58           C  
ATOM    458  OD1 ASN A 213      -3.839   2.257  -1.388  1.00  5.18           O  
ATOM    459  ND2 ASN A 213      -4.082   2.091   0.824  1.00  5.05           N  
ATOM    460  N   LEU A 214      -8.820   2.983   0.463  1.00  5.65           N  
ATOM    461  CA  LEU A 214     -10.279   3.158   0.315  1.00  3.90           C  
ATOM    462  C   LEU A 214     -10.826   4.280   1.178  1.00  3.27           C  
ATOM    463  O   LEU A 214     -11.395   5.255   0.688  1.00  0.00           O  
ATOM    464  CB  LEU A 214     -11.027   1.872   0.698  1.00  2.24           C  
ATOM    465  CG  LEU A 214     -11.149   0.720  -0.306  1.00  2.88           C  
ATOM    466  CD1 LEU A 214     -11.535  -0.584   0.394  1.00  0.00           C  
ATOM    467  CD2 LEU A 214     -12.174   1.096  -1.354  1.00  1.27           C  
ATOM    468  N   SER A 215     -10.653   4.131   2.488  1.00  5.29           N  
ATOM    469  CA  SER A 215     -11.179   5.122   3.384  1.00  7.59           C  
ATOM    470  C   SER A 215     -10.528   6.491   3.251  1.00  9.44           C  
ATOM    471  O   SER A 215     -11.179   7.512   3.466  1.00  9.98           O  
ATOM    472  CB  SER A 215     -11.067   4.616   4.817  1.00  8.19           C  
ATOM    473  OG  SER A 215     -11.713   3.356   4.935  1.00  6.84           O  
ATOM    474  N   LEU A 216      -9.229   6.530   2.871  1.00 10.83           N  
ATOM    475  CA  LEU A 216      -8.521   7.751   2.757  1.00 11.70           C  
ATOM    476  C   LEU A 216      -8.790   8.799   1.666  1.00 14.13           C  
ATOM    477  O   LEU A 216      -9.278   9.872   1.997  1.00 18.24           O  
ATOM    478  CB  LEU A 216      -7.025   7.525   2.766  1.00 11.41           C  
ATOM    479  CG  LEU A 216      -6.215   8.834   2.867  1.00  9.43           C  
ATOM    480  CD1 LEU A 216      -6.137   9.303   4.312  1.00  9.24           C  
ATOM    481  CD2 LEU A 216      -4.829   8.611   2.340  1.00  9.49           C  
ATOM    482  N   HIS A 217      -8.628   8.536   0.413  1.00 12.71           N  
ATOM    483  CA  HIS A 217      -8.674   9.586  -0.609  1.00 10.36           C  
ATOM    484  C   HIS A 217     -10.013  10.209  -0.956  1.00 11.31           C  
ATOM    485  O   HIS A 217     -10.779  10.642  -0.089  1.00 11.97           O  
ATOM    486  CB  HIS A 217      -8.051   9.137  -1.925  1.00 12.73           C  
ATOM    487  CG  HIS A 217      -6.938   8.156  -1.771  1.00 13.18           C  
ATOM    488  ND1 HIS A 217      -6.284   7.617  -2.855  1.00 13.98           N  
ATOM    489  CD2 HIS A 217      -6.395   7.576  -0.676  1.00 11.23           C  
ATOM    490  CE1 HIS A 217      -5.388   6.743  -2.433  1.00 12.05           C  
ATOM    491  NE2 HIS A 217      -5.436   6.699  -1.114  1.00  8.24           N  
ATOM    492  N   SER A 218     -10.270  10.255  -2.266  1.00  8.94           N  
ATOM    493  CA  SER A 218     -11.456  10.880  -2.821  1.00  4.77           C  
ATOM    494  C   SER A 218     -12.231  10.075  -3.852  1.00  5.72           C  
ATOM    495  O   SER A 218     -13.351  10.455  -4.195  1.00  6.49           O  
ATOM    496  CB  SER A 218     -11.062  12.190  -3.469  1.00  2.71           C  
ATOM    497  OG  SER A 218     -10.005  12.796  -2.749  1.00  7.22           O  
ATOM    498  N   ARG A 219     -11.656   8.997  -4.387  1.00  5.75           N  
ATOM    499  CA  ARG A 219     -12.403   8.217  -5.363  1.00  5.08           C  
ATOM    500  C   ARG A 219     -13.307   7.197  -4.699  1.00  5.77           C  
ATOM    501  O   ARG A 219     -14.255   6.734  -5.328  1.00  5.21           O  
ATOM    502  CB  ARG A 219     -11.493   7.524  -6.400  1.00  5.85           C  
ATOM    503  CG  ARG A 219      -9.993   7.436  -6.110  1.00  2.83           C  
ATOM    504  CD  ARG A 219      -9.308   8.782  -6.309  1.00  5.94           C  
ATOM    505  NE  ARG A 219      -7.848   8.697  -6.219  1.00  8.55           N  
ATOM    506  CZ  ARG A 219      -7.025   8.492  -7.249  1.00  9.13           C  
ATOM    507  NH1 ARG A 219      -5.710   8.440  -7.043  1.00  9.27           N  
ATOM    508  NH2 ARG A 219      -7.507   8.346  -8.483  1.00 10.63           N  
ATOM    509  N   PHE A 220     -13.039   6.837  -3.441  1.00  6.38           N  
ATOM    510  CA  PHE A 220     -13.931   5.879  -2.797  1.00  5.73           C  
ATOM    511  C   PHE A 220     -14.800   6.431  -1.683  1.00  5.28           C  
ATOM    512  O   PHE A 220     -14.356   7.196  -0.828  1.00  5.58           O  
ATOM    513  CB  PHE A 220     -13.210   4.647  -2.236  1.00  5.71           C  
ATOM    514  CG  PHE A 220     -11.757   4.528  -2.611  1.00  6.62           C  
ATOM    515  CD1 PHE A 220     -10.803   5.402  -2.082  1.00  5.27           C  
ATOM    516  CD2 PHE A 220     -11.330   3.467  -3.405  1.00  4.15           C  
ATOM    517  CE1 PHE A 220      -9.448   5.210  -2.335  1.00  4.15           C  
ATOM    518  CE2 PHE A 220      -9.986   3.268  -3.663  1.00  2.88           C  
ATOM    519  CZ  PHE A 220      -9.039   4.136  -3.128  1.00  2.95           C  
ATOM    520  N   MET A 221     -16.061   5.996  -1.727  1.00  3.52           N  
ATOM    521  CA  MET A 221     -17.081   6.347  -0.749  1.00  1.41           C  
ATOM    522  C   MET A 221     -17.765   5.032  -0.371  1.00  0.60           C  
ATOM    523  O   MET A 221     -17.762   4.077  -1.133  1.00  0.00           O  
ATOM    524  CB  MET A 221     -18.100   7.299  -1.368  1.00  1.81           C  
ATOM    525  CG  MET A 221     -19.345   7.547  -0.522  1.00  3.06           C  
ATOM    526  SD  MET A 221     -20.584   8.629  -1.324  1.00  2.19           S  
ATOM    527  CE  MET A 221     -19.855  10.242  -1.099  1.00  0.00           C  
ATOM    528  N   ARG A 222     -18.357   4.981   0.810  1.00  0.00           N  
ATOM    529  CA  ARG A 222     -19.027   3.772   1.253  1.00  0.00           C  
ATOM    530  C   ARG A 222     -20.547   3.925   1.288  1.00  0.45           C  
ATOM    531  O   ARG A 222     -21.070   5.011   1.549  1.00  0.00           O  
ATOM    532  CB  ARG A 222     -18.505   3.379   2.636  1.00  0.00           C  
ATOM    533  CG  ARG A 222     -18.771   1.944   2.987  1.00  0.00           C  
ATOM    534  CD  ARG A 222     -19.880   1.860   3.984  1.00  0.00           C  
ATOM    535  NE  ARG A 222     -19.377   1.587   5.321  1.00  0.00           N  
ATOM    536  CZ  ARG A 222     -19.969   2.020   6.424  1.00  0.00           C  
ATOM    537  NH1 ARG A 222     -19.458   1.724   7.605  1.00  0.15           N  
ATOM    538  NH2 ARG A 222     -21.067   2.765   6.337  1.00  0.00           N  
ATOM    539  N   VAL A 223     -21.244   2.827   1.013  1.00  3.65           N  
ATOM    540  CA  VAL A 223     -22.706   2.800   1.019  1.00  7.76           C  
ATOM    541  C   VAL A 223     -23.212   1.527   1.731  1.00 11.44           C  
ATOM    542  O   VAL A 223     -22.763   0.416   1.444  1.00 13.61           O  
ATOM    543  CB  VAL A 223     -23.262   2.867  -0.436  1.00  6.00           C  
ATOM    544  CG1 VAL A 223     -22.933   4.216  -1.054  1.00  3.52           C  
ATOM    545  CG2 VAL A 223     -22.654   1.779  -1.285  1.00  7.25           C  
ATOM    546  N   GLN A 224     -24.111   1.697   2.694  1.00 15.69           N  
ATOM    547  CA  GLN A 224     -24.654   0.565   3.438  1.00 20.00           C  
ATOM    548  C   GLN A 224     -26.110   0.480   3.094  1.00 22.36           C  
ATOM    549  O   GLN A 224     -26.639   1.332   2.393  1.00 23.97           O  
ATOM    550  CB  GLN A 224     -24.554   0.768   4.961  1.00 21.50           C  
ATOM    551  CG  GLN A 224     -23.210   0.420   5.610  1.00 25.97           C  
ATOM    552  CD  GLN A 224     -23.120  -1.024   6.122  1.00 29.62           C  
ATOM    553  OE1 GLN A 224     -22.140  -1.721   5.853  1.00 30.59           O  
ATOM    554  NE2 GLN A 224     -24.132  -1.467   6.879  1.00 29.73           N  
ATOM    555  N   ASN A 225     -26.756  -0.562   3.592  1.00 27.64           N  
ATOM    556  CA  ASN A 225     -28.183  -0.730   3.392  1.00 31.10           C  
ATOM    557  C   ASN A 225     -28.802  -0.235   4.691  1.00 31.88           C  
ATOM    558  O   ASN A 225     -28.294  -0.529   5.777  1.00 30.89           O  
ATOM    559  CB  ASN A 225     -28.531  -2.197   3.177  1.00 33.69           C  
ATOM    560  CG  ASN A 225     -30.005  -2.454   3.284  1.00 35.16           C  
ATOM    561  OD1 ASN A 225     -30.816  -1.678   2.777  1.00 38.30           O  
ATOM    562  ND2 ASN A 225     -30.370  -3.549   3.943  1.00 37.78           N  
ATOM    563  N   GLU A 226     -29.885   0.526   4.574  1.00 34.08           N  
ATOM    564  CA  GLU A 226     -30.566   1.084   5.738  1.00 36.39           C  
ATOM    565  C   GLU A 226     -31.099  -0.019   6.670  1.00 35.88           C  
ATOM    566  O   GLU A 226     -31.186   0.165   7.884  1.00 35.55           O  
ATOM    567  CB  GLU A 226     -31.716   2.000   5.275  1.00 38.24           C  
ATOM    568  CG  GLU A 226     -32.422   2.750   6.404  1.00 41.11           C  
ATOM    569  CD  GLU A 226     -33.639   3.563   5.948  1.00 42.61           C  
ATOM    570  OE1 GLU A 226     -34.534   3.822   6.781  1.00 44.17           O  
ATOM    571  OE2 GLU A 226     -33.709   3.964   4.771  1.00 42.20           O  
ATOM    572  N   GLY A 227     -31.426  -1.167   6.083  1.00 34.98           N  
ATOM    573  CA  GLY A 227     -31.966  -2.292   6.827  1.00 34.29           C  
ATOM    574  C   GLY A 227     -31.192  -2.869   7.998  1.00 34.39           C  
ATOM    575  O   GLY A 227     -30.225  -2.285   8.490  1.00 34.17           O  
ATOM    576  N   THR A 228     -31.630  -4.052   8.420  1.00 32.43           N  
ATOM    577  CA  THR A 228     -31.064  -4.776   9.553  1.00 30.64           C  
ATOM    578  C   THR A 228     -29.606  -5.255   9.446  1.00 30.72           C  
ATOM    579  O   THR A 228     -28.900  -5.308  10.465  1.00 33.42           O  
ATOM    580  CB  THR A 228     -31.948  -6.009   9.878  1.00 29.73           C  
ATOM    581  OG1 THR A 228     -31.677  -6.472  11.209  1.00 29.36           O  
ATOM    582  CG2 THR A 228     -31.669  -7.129   8.885  1.00 29.50           C  
ATOM    583  N   GLY A 229     -29.154  -5.584   8.230  1.00 28.22           N  
ATOM    584  CA  GLY A 229     -27.805  -6.116   8.047  1.00 23.76           C  
ATOM    585  C   GLY A 229     -26.747  -5.460   7.165  1.00 21.88           C  
ATOM    586  O   GLY A 229     -26.967  -4.394   6.577  1.00 19.37           O  
ATOM    587  N   LYS A 230     -25.616  -6.171   7.037  1.00 19.70           N  
ATOM    588  CA  LYS A 230     -24.396  -5.729   6.338  1.00 17.87           C  
ATOM    589  C   LYS A 230     -24.155  -5.595   4.828  1.00 17.04           C  
ATOM    590  O   LYS A 230     -23.358  -6.342   4.261  1.00 16.77           O  
ATOM    591  CB  LYS A 230     -23.185  -6.489   6.938  1.00 16.05           C  
ATOM    592  CG  LYS A 230     -22.748  -7.827   6.283  1.00 16.00           C  
ATOM    593  CD  LYS A 230     -21.453  -8.358   6.963  1.00 15.32           C  
ATOM    594  CE  LYS A 230     -20.689  -9.415   6.154  1.00 13.40           C  
ATOM    595  NZ  LYS A 230     -19.272  -9.005   5.922  1.00 10.24           N  
ATOM    596  N   SER A 231     -24.803  -4.645   4.168  1.00 18.23           N  
ATOM    597  CA  SER A 231     -24.485  -4.445   2.762  1.00 19.82           C  
ATOM    598  C   SER A 231     -23.709  -3.131   2.738  1.00 17.31           C  
ATOM    599  O   SER A 231     -24.267  -2.046   2.857  1.00 15.88           O  
ATOM    600  CB  SER A 231     -25.735  -4.375   1.859  1.00 21.09           C  
ATOM    601  OG  SER A 231     -26.402  -3.130   1.931  1.00 22.10           O  
ATOM    602  N   SER A 232     -22.393  -3.259   2.664  1.00 16.17           N  
ATOM    603  CA  SER A 232     -21.524  -2.104   2.604  1.00 17.08           C  
ATOM    604  C   SER A 232     -20.797  -2.279   1.294  1.00 16.19           C  
ATOM    605  O   SER A 232     -19.973  -3.178   1.166  1.00 16.08           O  
ATOM    606  CB  SER A 232     -20.517  -2.114   3.755  1.00 16.65           C  
ATOM    607  OG  SER A 232     -19.782  -0.901   3.803  1.00 15.78           O  
ATOM    608  N   TRP A 233     -21.132  -1.452   0.312  1.00 14.88           N  
ATOM    609  CA  TRP A 233     -20.486  -1.540  -0.981  1.00 12.70           C  
ATOM    610  C   TRP A 233     -19.550  -0.370  -1.097  1.00 13.44           C  
ATOM    611  O   TRP A 233     -19.802   0.693  -0.531  1.00 12.78           O  
ATOM    612  CB  TRP A 233     -21.499  -1.450  -2.116  1.00 12.40           C  
ATOM    613  CG  TRP A 233     -22.724  -2.256  -1.922  1.00 11.33           C  
ATOM    614  CD1 TRP A 233     -23.950  -1.797  -1.545  1.00  9.67           C  
ATOM    615  CD2 TRP A 233     -22.856  -3.672  -2.090  1.00 12.45           C  
ATOM    616  NE1 TRP A 233     -24.840  -2.840  -1.468  1.00 11.03           N  
ATOM    617  CE2 TRP A 233     -24.193  -4.003  -1.794  1.00 11.34           C  
ATOM    618  CE3 TRP A 233     -21.968  -4.699  -2.457  1.00 13.33           C  
ATOM    619  CZ2 TRP A 233     -24.675  -5.316  -1.860  1.00 12.50           C  
ATOM    620  CZ3 TRP A 233     -22.450  -6.011  -2.522  1.00 12.83           C  
ATOM    621  CH2 TRP A 233     -23.788  -6.303  -2.222  1.00 12.98           C  
ATOM    622  N   TRP A 234     -18.465  -0.572  -1.830  1.00 12.08           N  
ATOM    623  CA  TRP A 234     -17.509   0.492  -2.061  1.00  7.60           C  
ATOM    624  C   TRP A 234     -17.726   0.991  -3.462  1.00  7.45           C  
ATOM    625  O   TRP A 234     -17.630   0.229  -4.407  1.00  7.79           O  
ATOM    626  CB  TRP A 234     -16.076  -0.019  -1.901  1.00  6.13           C  
ATOM    627  CG  TRP A 234     -15.709  -0.097  -0.499  1.00  1.34           C  
ATOM    628  CD1 TRP A 234     -15.643  -1.221   0.281  1.00  1.24           C  
ATOM    629  CD2 TRP A 234     -15.530   1.014   0.377  1.00  1.42           C  
ATOM    630  NE1 TRP A 234     -15.446  -0.871   1.606  1.00  0.00           N  
ATOM    631  CE2 TRP A 234     -15.373   0.497   1.689  1.00  0.00           C  
ATOM    632  CE3 TRP A 234     -15.484   2.410   0.186  1.00  0.00           C  
ATOM    633  CZ2 TRP A 234     -15.183   1.323   2.797  1.00  0.00           C  
ATOM    634  CZ3 TRP A 234     -15.290   3.228   1.288  1.00  0.00           C  
ATOM    635  CH2 TRP A 234     -15.140   2.680   2.579  1.00  0.00           C  
ATOM    636  N   ILE A 235     -18.063   2.261  -3.597  1.00 10.86           N  
ATOM    637  CA  ILE A 235     -18.246   2.818  -4.926  1.00 14.67           C  
ATOM    638  C   ILE A 235     -17.293   3.989  -5.129  1.00 15.33           C  
ATOM    639  O   ILE A 235     -16.527   4.352  -4.238  1.00 14.27           O  
ATOM    640  CB  ILE A 235     -19.727   3.259  -5.190  1.00 16.53           C  
ATOM    641  CG1 ILE A 235     -20.083   4.509  -4.381  1.00 16.35           C  
ATOM    642  CG2 ILE A 235     -20.670   2.110  -4.854  1.00 19.19           C  
ATOM    643  CD1 ILE A 235     -20.099   4.301  -2.895  1.00 19.11           C  
ATOM    644  N   ILE A 236     -17.338   4.563  -6.317  1.00 17.95           N  
ATOM    645  CA  ILE A 236     -16.486   5.682  -6.660  1.00 20.74           C  
ATOM    646  C   ILE A 236     -17.326   6.958  -6.661  1.00 22.46           C  
ATOM    647  O   ILE A 236     -18.541   6.910  -6.870  1.00 20.94           O  
ATOM    648  CB  ILE A 236     -15.835   5.425  -8.044  1.00 22.69           C  
ATOM    649  CG1 ILE A 236     -14.825   4.272  -7.945  1.00 22.88           C  
ATOM    650  CG2 ILE A 236     -15.168   6.678  -8.559  1.00 25.66           C  
ATOM    651  CD1 ILE A 236     -13.592   4.590  -7.102  1.00 22.62           C  
ATOM    652  N   ASN A 237     -16.717   8.110  -6.402  1.00 28.05           N  
ATOM    653  CA  ASN A 237     -17.408   9.365  -6.383  1.00 31.73           C  
ATOM    654  C   ASN A 237     -16.857  10.458  -7.281  1.00 35.60           C  
ATOM    655  O   ASN A 237     -15.802  10.236  -7.876  1.00 36.61           O  
ATOM    656  CB  ASN A 237     -17.659   9.822  -4.914  1.00 31.86           C  
ATOM    657  CG  ASN A 237     -16.384   9.817  -4.105  1.00 29.95           C  
ATOM    658  OD1 ASN A 237     -15.739   8.785  -3.941  1.00 30.36           O  
ATOM    659  ND2 ASN A 237     -16.026  10.974  -3.573  1.00 29.65           N  
ATOM    660  N   PRO A 238     -17.500  11.650  -7.380  1.00 38.08           N  
ATOM    661  CA  PRO A 238     -17.018  12.752  -8.219  1.00 39.64           C  
ATOM    662  C   PRO A 238     -16.139  12.467  -9.447  1.00 43.38           C  
ATOM    663  O   PRO A 238     -14.945  12.181  -9.330  1.00 41.28           O  
ATOM    664  CB  PRO A 238     -16.357  13.664  -7.193  1.00 38.07           C  
ATOM    665  CG  PRO A 238     -17.352  13.573  -6.010  1.00 37.07           C  
ATOM    666  CD  PRO A 238     -18.168  12.262  -6.217  1.00 37.88           C  
ATOM    667  N   ASP A 239     -16.752  12.565 -10.628  1.00 45.47           N  
ATOM    668  CA  ASP A 239     -16.054  12.346 -11.893  1.00 47.17           C  
ATOM    669  C   ASP A 239     -16.201  13.549 -12.813  1.00 48.73           C  
ATOM    670  O   ASP A 239     -15.234  13.969 -13.443  1.00 53.02           O  
ATOM    671  CB  ASP A 239     -16.601  11.119 -12.622  1.00 47.14           C  
ATOM    672  CG  ASP A 239     -15.903  10.873 -13.953  1.00 45.30           C  
ATOM    673  OD1 ASP A 239     -16.539  10.318 -14.877  1.00 43.68           O  
ATOM    674  OD2 ASP A 239     -14.712  11.226 -14.069  1.00 46.09           O  
ATOM    675  N   GLY A 240     -17.416  14.090 -12.892  1.00 49.81           N  
ATOM    676  CA  GLY A 240     -17.685  15.240 -13.752  1.00 49.14           C  
ATOM    677  C   GLY A 240     -16.781  16.418 -13.452  1.00 50.76           C  
ATOM    678  O   GLY A 240     -16.171  16.998 -14.354  1.00 45.47           O  
ATOM    679  N   GLY A 241     -16.707  16.773 -12.174  1.00 52.66           N  
ATOM    680  CA  GLY A 241     -15.844  17.860 -11.754  1.00 58.10           C  
ATOM    681  C   GLY A 241     -14.568  17.211 -11.262  1.00 59.37           C  
ATOM    682  O   GLY A 241     -14.583  16.034 -10.895  1.00 62.80           O  
ATOM    683  N   LYS A 242     -13.467  17.951 -11.244  1.00 60.33           N  
ATOM    684  CA  LYS A 242     -12.204  17.379 -10.796  1.00 60.59           C  
ATOM    685  C   LYS A 242     -11.678  17.946  -9.477  1.00 59.64           C  
ATOM    686  O   LYS A 242     -11.629  17.248  -8.461  1.00 57.95           O  
ATOM    687  CB  LYS A 242     -11.130  17.578 -11.864  1.00 63.81           C  
ATOM    688  CG  LYS A 242     -11.645  17.970 -13.233  1.00 63.36           C  
ATOM    689  CD  LYS A 242     -10.483  18.434 -14.086  1.00 64.33           C  
ATOM    690  CE  LYS A 242     -10.935  19.074 -15.377  1.00 66.04           C  
ATOM    691  NZ  LYS A 242      -9.774  19.714 -16.050  1.00 66.45           N  
ATOM    692  N   SER A 243     -11.281  19.215  -9.520  1.00 57.64           N  
ATOM    693  CA  SER A 243     -10.705  19.925  -8.378  1.00 58.64           C  
ATOM    694  C   SER A 243     -11.272  19.675  -6.980  1.00 56.97           C  
ATOM    695  O   SER A 243     -12.479  19.518  -6.787  1.00 59.38           O  
ATOM    696  CB  SER A 243     -10.710  21.428  -8.662  1.00 60.87           C  
ATOM    697  OG  SER A 243      -9.899  21.722  -9.786  1.00 68.04           O  
ATOM    698  N   GLY A 244     -10.275  19.737  -6.018  1.00 54.99           N  
ATOM    699  CA  GLY A 244     -10.579  19.550  -4.575  1.00 53.10           C  
ATOM    700  C   GLY A 244      -9.351  18.973  -3.764  1.00 51.53           C  
ATOM    701  O   GLY A 244      -9.058  17.785  -3.823  1.00 48.87           O  
ATOM    702  N   LYS A 245      -8.428  19.830  -3.266  1.00 48.33           N  
ATOM    703  CA  LYS A 245      -7.187  19.364  -2.520  1.00 49.71           C  
ATOM    704  C   LYS A 245      -7.702  18.483  -1.352  1.00 49.49           C  
ATOM    705  O   LYS A 245      -8.754  18.826  -0.685  1.00 51.14           O  
ATOM    706  CB  LYS A 245      -6.258  20.566  -1.924  1.00 48.61           C  
ATOM    707  CG  LYS A 245      -5.197  21.353  -3.001  1.00 47.67           C  
ATOM    708  CD  LYS A 245      -3.780  21.657  -2.477  1.00 48.40           C  
ATOM    709  CE  LYS A 245      -2.406  21.364  -3.236  1.00 48.02           C  
ATOM    710  NZ  LYS A 245      -1.108  21.181  -2.710  1.00 48.35           N  
ATOM    711  N   ALA A 246      -6.942  17.423  -1.039  1.00 49.07           N  
ATOM    712  CA  ALA A 246      -7.310  16.559   0.077  1.00 49.32           C  
ATOM    713  C   ALA A 246      -6.234  16.850   1.123  1.00 50.71           C  
ATOM    714  O   ALA A 246      -5.065  16.632   0.869  1.00 49.74           O  
ATOM    715  CB  ALA A 246      -7.252  15.097  -0.318  1.00 51.67           C  
ATOM    716  N   PRO A 247      -6.603  17.429   2.286  1.00 50.89           N  
ATOM    717  CA  PRO A 247      -5.667  17.763   3.372  1.00 53.10           C  
ATOM    718  C   PRO A 247      -4.515  16.814   3.435  1.00 54.93           C  
ATOM    719  O   PRO A 247      -4.385  15.930   4.187  1.00 56.38           O  
ATOM    720  CB  PRO A 247      -6.489  17.611   4.611  1.00 52.54           C  
ATOM    721  CG  PRO A 247      -7.826  18.102   4.172  1.00 51.11           C  
ATOM    722  CD  PRO A 247      -7.973  17.427   2.801  1.00 50.82           C  
ATOM    723  N   ARG A 248      -3.709  17.150   2.670  1.00 59.14           N  
ATOM    724  CA  ARG A 248      -2.563  16.241   2.646  1.00 58.44           C  
ATOM    725  C   ARG A 248      -1.788  16.442   3.968  1.00 59.27           C  
ATOM    726  O   ARG A 248      -1.072  17.427   4.161  1.00 59.13           O  
ATOM    727  CB  ARG A 248      -1.651  16.475   1.420  1.00 57.50           C  
ATOM    728  CG  ARG A 248      -2.318  16.352   0.012  1.00 56.83           C  
ATOM    729  CD  ARG A 248      -3.372  15.209  -0.180  1.00 56.14           C  
ATOM    730  NE  ARG A 248      -2.860  13.854  -0.438  1.00 55.47           N  
ATOM    731  CZ  ARG A 248      -3.638  12.791  -0.663  1.00 56.02           C  
ATOM    732  NH1 ARG A 248      -4.963  12.916  -0.666  1.00 56.35           N  
ATOM    733  NH2 ARG A 248      -3.099  11.596  -0.870  1.00 54.93           N  
ATOM    734  N   ARG A 249      -2.002  15.481   4.865  1.00 60.08           N  
ATOM    735  CA  ARG A 249      -1.463  15.341   6.230  1.00 60.52           C  
ATOM    736  C   ARG A 249      -0.292  16.138   6.830  1.00 59.72           C  
ATOM    737  O   ARG A 249       0.573  16.676   6.131  1.00 58.39           O  
ATOM    738  CB  ARG A 249      -1.194  13.849   6.464  1.00 64.43           C  
ATOM    739  CG  ARG A 249      -1.462  13.347   7.873  1.00 70.37           C  
ATOM    740  CD  ARG A 249      -1.625  11.827   7.883  1.00 74.90           C  
ATOM    741  NE  ARG A 249      -2.909  11.393   7.330  1.00 79.18           N  
ATOM    742  CZ  ARG A 249      -4.062  11.418   7.997  1.00 81.00           C  
ATOM    743  NH1 ARG A 249      -4.100  11.854   9.249  1.00 81.52           N  
ATOM    744  NH2 ARG A 249      -5.179  11.003   7.412  1.00 81.92           N  
ATOM    745  N   ARG A 250      -0.305  16.170   8.165  1.00 58.34           N  
ATOM    746  CA  ARG A 250       0.689  16.826   9.011  1.00 56.59           C  
ATOM    747  C   ARG A 250       0.469  18.318   9.330  1.00 56.65           C  
ATOM    748  O   ARG A 250       0.957  19.190   8.610  1.00 56.63           O  
ATOM    749  CB  ARG A 250       2.096  16.627   8.432  1.00 53.39           C  
ATOM    750  CG  ARG A 250       3.218  16.695   9.470  1.00 49.48           C  
ATOM    751  CD  ARG A 250       3.382  15.368  10.218  1.00 46.39           C  
ATOM    752  NE  ARG A 250       2.253  15.065  11.100  1.00 43.73           N  
ATOM    753  CZ  ARG A 250       1.327  14.139  10.862  1.00 43.37           C  
ATOM    754  NH1 ARG A 250       1.375  13.407   9.758  1.00 43.11           N  
ATOM    755  NH2 ARG A 250       0.355  13.940  11.739  1.00 41.97           N  
ATOM    756  N   ALA A 251      -0.279  18.569  10.389  1.00 69.10           N  
ATOM    757  CA  ALA A 251      -0.551  19.914  10.918  1.00 69.74           C  
ATOM    758  C   ALA A 251       0.082  19.563  12.244  1.00 69.48           C  
ATOM    759  O   ALA A 251       1.141  20.080  12.615  1.00 70.11           O  
ATOM    760  CB  ALA A 251      -2.027  20.130  11.179  1.00 68.63           C  
ATOM    761  N   VAL A 252      -0.637  18.772  12.940  1.00 67.88           N  
ATOM    762  CA  VAL A 252      -0.159  18.030  14.103  1.00 66.87           C  
ATOM    763  C   VAL A 252      -1.066  17.736  15.149  1.00 67.75           C  
ATOM    764  O   VAL A 252      -2.233  17.870  14.847  1.00 67.51           O  
ATOM    765  CB  VAL A 252       1.283  18.016  14.546  1.00 66.13           C  
ATOM    766  CG1 VAL A 252       1.629  16.530  14.250  1.00 65.21           C  
ATOM    767  CG2 VAL A 252       2.249  18.952  13.954  1.00 65.17           C  
ATOM    768  N   SER A 253      -0.482  17.029  16.165  1.00 67.14           N  
ATOM    769  CA  SER A 253      -0.960  16.490  17.466  1.00 67.39           C  
ATOM    770  C   SER A 253      -1.248  17.333  18.757  1.00 67.99           C  
ATOM    771  O   SER A 253      -1.548  18.547  18.767  1.00 69.63           O  
ATOM    772  CB  SER A 253      -0.045  15.362  17.886  1.00 67.42           C  
ATOM    773  OG  SER A 253      -0.354  14.290  17.026  1.00 66.53           O  
ATOM    774  OXT SER A 253      -1.264  16.638  19.805  1.00 68.25           O  
TER     775      SER A 253                                                      
END
MOLECULE T0476.pdb
ATOM     20  N   ALA     2       2.300  -1.329  -3.219  1.00  1.00          
ATOM     21  HN  ALA     2       2.119  -0.600  -3.850  1.00  1.00          
ATOM     22  CA  ALA     2       2.425  -2.698  -3.762  1.00  1.00          
ATOM     23  HA  ALA     2       2.430  -3.385  -2.927  1.00  1.00          
ATOM     24  CB  ALA     2       1.232  -3.027  -4.654  1.00  1.00          
ATOM     25  HB1 ALA     2       0.366  -3.248  -4.041  1.00  1.00          
ATOM     26  HB2 ALA     2       1.466  -3.884  -5.266  1.00  1.00          
ATOM     27  HB3 ALA     2       1.012  -2.181  -5.288  1.00  1.00          
ATOM     28  C   ALA     2       3.737  -2.860  -4.536  1.00  1.00          
ATOM     29  O   ALA     2       4.162  -1.925  -5.237  1.00  1.00          
ATOM     30  N   LYS     3       4.348  -4.064  -4.398  1.00  1.00          
ATOM     31  HN  LYS     3       3.910  -4.743  -3.851  1.00  1.00          
ATOM     32  CA  LYS     3       5.630  -4.420  -5.036  1.00  1.00          
ATOM     33  HA  LYS     3       5.927  -3.593  -5.664  1.00  1.00          
ATOM     34  CB  LYS     3       6.703  -4.642  -3.963  1.00  1.00          
ATOM     35  HB1 LYS     3       7.090  -5.646  -4.059  1.00  1.00          
ATOM     36  HB2 LYS     3       6.247  -4.534  -2.991  1.00  1.00          
ATOM     37  CG  LYS     3       7.866  -3.669  -4.054  1.00  1.00          
ATOM     38  HG1 LYS     3       7.478  -2.663  -4.070  1.00  1.00          
ATOM     39  HG2 LYS     3       8.415  -3.861  -4.963  1.00  1.00          
ATOM     40  CD  LYS     3       8.812  -3.819  -2.864  1.00  1.00          
ATOM     41  HD1 LYS     3       9.239  -4.812  -2.884  1.00  1.00          
ATOM     42  HD2 LYS     3       8.242  -3.692  -1.954  1.00  1.00          
ATOM     43  CE  LYS     3       9.950  -2.788  -2.891  1.00  1.00          
ATOM     44  HE1 LYS     3      10.366  -2.698  -1.895  1.00  1.00          
ATOM     45  HE2 LYS     3       9.543  -1.834  -3.190  1.00  1.00          
ATOM     46  NZ  LYS     3      11.048  -3.157  -3.838  1.00  1.00          
ATOM     47  HZ1 LYS     3      10.919  -4.134  -4.171  1.00  1.00          
ATOM     48  HZ2 LYS     3      11.970  -3.084  -3.363  1.00  1.00          
ATOM     49  HZ3 LYS     3      11.041  -2.517  -4.658  1.00  1.00          
ATOM     50  C   LYS     3       5.489  -5.670  -5.903  1.00  1.00          
ATOM     51  O   LYS     3       4.818  -6.637  -5.496  1.00  1.00          
ATOM     52  N   CYS     4       6.139  -5.626  -7.110  1.00  1.00          
ATOM     53  HN  CYS     4       6.610  -4.798  -7.337  1.00  1.00          
ATOM     54  CA  CYS     4       6.151  -6.739  -8.115  1.00  1.00          
ATOM     55  HA  CYS     4       5.134  -7.092  -8.210  1.00  1.00          
ATOM     56  HB1 CYS     4       7.690  -6.064  -9.456  1.00  1.00          
ATOM     57  HB2 CYS     4       6.138  -5.314  -9.733  1.00  1.00          
ATOM     58  C   CYS     4       7.052  -7.958  -7.664  1.00  1.00          
ATOM     59  O   CYS     4       8.242  -7.720  -7.359  1.00  1.00          
ATOM     60  CB  CYS     4       6.628  -6.236  -9.499  1.00  1.00          
ATOM     61  SG  CYS     4       6.315  -7.399 -10.876  1.00  1.00          
ATOM     62  ZN  CYS     4       7.178  -6.267 -12.689  1.00  1.00          
ATOM     63  N   PRO     5       6.504  -9.279  -7.551  1.00  1.00          
ATOM     64  CA  PRO     5       7.350 -10.468  -7.168  1.00  1.00          
ATOM     65  HA  PRO     5       7.965 -10.222  -6.313  1.00  1.00          
ATOM     66  CB  PRO     5       6.300 -11.538  -6.750  1.00  1.00          
ATOM     67  HB1 PRO     5       6.133 -11.486  -5.679  1.00  1.00          
ATOM     68  HB2 PRO     5       6.670 -12.522  -7.004  1.00  1.00          
ATOM     69  CG  PRO     5       5.042 -11.205  -7.513  1.00  1.00          
ATOM     70  HG1 PRO     5       4.168 -11.526  -6.955  1.00  1.00          
ATOM     71  HG2 PRO     5       5.061 -11.696  -8.482  1.00  1.00          
ATOM     72  CD  PRO     5       5.048  -9.697  -7.681  1.00  1.00          
ATOM     73  HD1 PRO     5       4.459  -9.227  -6.903  1.00  1.00          
ATOM     74  HD2 PRO     5       4.661  -9.417  -8.652  1.00  1.00          
ATOM     75  C   PRO     5       8.310 -10.999  -8.302  1.00  1.00          
ATOM     76  O   PRO     5       9.092 -11.941  -8.056  1.00  1.00          
ATOM     77  N   ILE     6       8.243 -10.351  -9.506  1.00  1.00          
ATOM     78  HN  ILE     6       7.662  -9.568  -9.601  1.00  1.00          
ATOM     79  CA  ILE     6       9.041 -10.718 -10.711  1.00  1.00          
ATOM     80  HA  ILE     6       9.414 -11.721 -10.556  1.00  1.00          
ATOM     81  CB  ILE     6       8.166 -10.709 -12.075  1.00  1.00          
ATOM     82  HB  ILE     6       8.010  -9.665 -12.339  1.00  1.00          
ATOM     83  CG1 ILE     6       6.780 -11.397 -11.928  1.00  1.00          
ATOM     84 HG11 ILE     6       6.684 -11.787 -10.923  1.00  1.00          
ATOM     85 HG12 ILE     6       6.717 -12.214 -12.630  1.00  1.00          
ATOM     86  CG2 ILE     6       8.885 -11.402 -13.266  1.00  1.00          
ATOM     87 HG21 ILE     6       8.195 -11.508 -14.089  1.00  1.00          
ATOM     88 HG22 ILE     6       9.234 -12.376 -12.960  1.00  1.00          
ATOM     89 HG23 ILE     6       9.727 -10.799 -13.576  1.00  1.00          
ATOM     90  CD1 ILE     6       5.603 -10.477 -12.185  1.00  1.00          
ATOM     91 HD11 ILE     6       5.734  -9.980 -13.135  1.00  1.00          
ATOM     92 HD12 ILE     6       5.545  -9.738 -11.398  1.00  1.00          
ATOM     93 HD13 ILE     6       4.690 -11.054 -12.203  1.00  1.00          
ATOM     94  C   ILE     6      10.267  -9.754 -10.836  1.00  1.00          
ATOM     95  O   ILE     6      11.410 -10.247 -10.885  1.00  1.00          
ATOM     96  N   CYS     7       9.997  -8.409 -10.880  1.00  1.00          
ATOM     97  HN  CYS     7       9.068  -8.099 -10.752  1.00  1.00          
ATOM     98  CA  CYS     7      11.045  -7.379 -11.052  1.00  1.00          
ATOM     99  HA  CYS     7      11.937  -7.900 -11.371  1.00  1.00          
ATOM    100  HB1 CYS     7      10.463  -6.971 -13.068  1.00  1.00          
ATOM    101  HB2 CYS     7      11.466  -5.723 -12.357  1.00  1.00          
ATOM    102  C   CYS     7      11.386  -6.643  -9.742  1.00  1.00          
ATOM    103  O   CYS     7      12.579  -6.407  -9.475  1.00  1.00          
ATOM    104  CB  CYS     7      10.644  -6.397 -12.176  1.00  1.00          
ATOM    105  SG  CYS     7       9.154  -5.367 -11.862  1.00  1.00          
ATOM    106  N   GLY     8      10.326  -6.300  -8.947  1.00  1.00          
ATOM    107  HN  GLY     8       9.429  -6.536  -9.259  1.00  1.00          
ATOM    108  CA  GLY     8      10.463  -5.587  -7.658  1.00  1.00          
ATOM    109  HA1 GLY     8      11.409  -5.858  -7.215  1.00  1.00          
ATOM    110  HA2 GLY     8       9.671  -5.911  -7.002  1.00  1.00          
ATOM    111  C   GLY     8      10.398  -4.062  -7.773  1.00  1.00          
ATOM    112  O   GLY     8      11.113  -3.371  -7.024  1.00  1.00          
ATOM    113  N   SER     9       9.543  -3.559  -8.714  1.00  1.00          
ATOM    114  HN  SER     9       9.028  -4.201  -9.268  1.00  1.00          
ATOM    115  CA  SER     9       9.353  -2.108  -8.955  1.00  1.00          
ATOM    116  HA  SER     9      10.245  -1.616  -8.608  1.00  1.00          
ATOM    117  CB  SER     9       9.190  -1.838 -10.450  1.00  1.00          
ATOM    118  HB1 SER     9       8.515  -1.007 -10.590  1.00  1.00          
ATOM    119  HB2 SER     9       8.784  -2.717 -10.929  1.00  1.00          
ATOM    120  OG  SER     9      10.434  -1.523 -11.050  1.00  1.00          
ATOM    121  HG  SER     9      11.071  -1.296 -10.369  1.00  1.00          
ATOM    122  C   SER     9       8.118  -1.543  -8.168  1.00  1.00          
ATOM    123  O   SER     9       7.155  -2.318  -7.998  1.00  1.00          
ATOM    124  N   PRO    10       8.068  -0.182  -7.677  1.00  1.00          
ATOM    125  CA  PRO    10       6.894   0.366  -6.898  1.00  1.00          
ATOM    126  HA  PRO    10       6.675  -0.274  -6.053  1.00  1.00          
ATOM    127  CB  PRO    10       7.377   1.745  -6.389  1.00  1.00          
ATOM    128  HB1 PRO    10       7.094   1.885  -5.351  1.00  1.00          
ATOM    129  HB2 PRO    10       6.922   2.521  -6.992  1.00  1.00          
ATOM    130  CG  PRO    10       8.860   1.719  -6.557  1.00  1.00          
ATOM    131  HG1 PRO    10       9.323   1.230  -5.709  1.00  1.00          
ATOM    132  HG2 PRO    10       9.246   2.726  -6.667  1.00  1.00          
ATOM    133  CD  PRO    10       9.089   0.921  -7.810  1.00  1.00          
ATOM    134  HD1 PRO    10      10.092   0.531  -7.830  1.00  1.00          
ATOM    135  HD2 PRO    10       8.896   1.526  -8.686  1.00  1.00          
ATOM    136  C   PRO    10       5.597   0.545  -7.715  1.00  1.00          
ATOM    137  O   PRO    10       5.643   0.957  -8.890  1.00  1.00          
ATOM    138  N   LEU    11       4.473   0.213  -7.043  1.00  1.00          
ATOM    139  HN  LEU    11       4.572  -0.110  -6.123  1.00  1.00          
ATOM    140  CA  LEU    11       3.105   0.301  -7.592  1.00  1.00          
ATOM    141  HA  LEU    11       3.157   0.823  -8.536  1.00  1.00          
ATOM    142  CB  LEU    11       2.505  -1.103  -7.823  1.00  1.00          
ATOM    143  HB1 LEU    11       1.435  -0.986  -7.961  1.00  1.00          
ATOM    144  HB2 LEU    11       2.671  -1.689  -6.932  1.00  1.00          
ATOM    145  CG  LEU    11       3.057  -1.892  -9.022  1.00  1.00          
ATOM    146  HG  LEU    11       4.007  -1.471  -9.320  1.00  1.00          
ATOM    147  CD1 LEU    11       3.294  -3.342  -8.631  1.00  1.00          
ATOM    148 HD11 LEU    11       2.387  -3.756  -8.216  1.00  1.00          
ATOM    149 HD12 LEU    11       4.082  -3.393  -7.896  1.00  1.00          
ATOM    150 HD13 LEU    11       3.580  -3.909  -9.505  1.00  1.00          
ATOM    151  CD2 LEU    11       2.100  -1.814 -10.209  1.00  1.00          
ATOM    152 HD21 LEU    11       1.811  -0.785 -10.370  1.00  1.00          
ATOM    153 HD22 LEU    11       1.222  -2.406 -10.003  1.00  1.00          
ATOM    154 HD23 LEU    11       2.591  -2.193 -11.094  1.00  1.00          
ATOM    155  C   LEU    11       2.200   1.084  -6.640  1.00  1.00          
ATOM    156  O   LEU    11       2.354   0.979  -5.405  1.00  1.00          
ATOM    157  N   LYS    12       1.248   1.846  -7.239  1.00  1.00          
ATOM    158  HN  LYS    12       1.205   1.847  -8.218  1.00  1.00          
ATOM    159  CA  LYS    12       0.268   2.672  -6.500  1.00  1.00          
ATOM    160  HA  LYS    12       0.655   2.832  -5.504  1.00  1.00          
ATOM    161  CB  LYS    12       0.071   4.039  -7.188  1.00  1.00          
ATOM    162  HB1 LYS    12      -0.862   4.462  -6.847  1.00  1.00          
ATOM    163  HB2 LYS    12       0.009   3.879  -8.253  1.00  1.00          
ATOM    164  CG  LYS    12       1.177   5.060  -6.932  1.00  1.00          
ATOM    165  HG1 LYS    12       2.125   4.636  -7.231  1.00  1.00          
ATOM    166  HG2 LYS    12       1.202   5.296  -5.878  1.00  1.00          
ATOM    167  CD  LYS    12       0.933   6.337  -7.719  1.00  1.00          
ATOM    168  HD1 LYS    12       0.002   6.777  -7.392  1.00  1.00          
ATOM    169  HD2 LYS    12       0.868   6.093  -8.769  1.00  1.00          
ATOM    170  CE  LYS    12       2.054   7.343  -7.518  1.00  1.00          
ATOM    171  HE1 LYS    12       2.989   6.884  -7.799  1.00  1.00          
ATOM    172  HE2 LYS    12       2.087   7.622  -6.476  1.00  1.00          
ATOM    173  NZ  LYS    12       1.848   8.568  -8.341  1.00  1.00          
ATOM    174  HZ1 LYS    12       0.845   8.844  -8.326  1.00  1.00          
ATOM    175  HZ2 LYS    12       2.133   8.389  -9.324  1.00  1.00          
ATOM    176  HZ3 LYS    12       2.418   9.351  -7.963  1.00  1.00          
ATOM    177  C   LYS    12      -1.081   1.956  -6.396  1.00  1.00          
ATOM    178  O   LYS    12      -1.559   1.377  -7.390  1.00  1.00          
ATOM    179  N   TRP    13      -1.672   1.996  -5.160  1.00  1.00          
ATOM    180  HN  TRP    13      -1.181   2.442  -4.438  1.00  1.00          
ATOM    181  CA  TRP    13      -3.017   1.404  -4.824  1.00  1.00          
ATOM    182  HA  TRP    13      -3.015   0.400  -5.221  1.00  1.00          
ATOM    183  CB  TRP    13      -3.201   1.310  -3.305  1.00  1.00          
ATOM    184  HB1 TRP    13      -4.256   1.293  -3.074  1.00  1.00          
ATOM    185  HB2 TRP    13      -2.746   2.171  -2.837  1.00  1.00          
ATOM    186  CG  TRP    13      -2.569   0.062  -2.712  1.00  1.00          
ATOM    187  CD1 TRP    13      -1.316  -0.023  -2.173  1.00  1.00          
ATOM    188  HD1 TRP    13      -0.631   0.809  -2.108  1.00  1.00          
ATOM    189  CD2 TRP    13      -3.138  -1.276  -2.597  1.00  1.00          
ATOM    190  NE1 TRP    13      -1.061  -1.302  -1.745  1.00  1.00          
ATOM    191  HE1 TRP    13      -0.226  -1.604  -1.327  1.00  1.00          
ATOM    192  CE2 TRP    13      -2.156  -2.089  -1.988  1.00  1.00          
ATOM    193  CE3 TRP    13      -4.371  -1.874  -2.944  1.00  1.00          
ATOM    194  HE3 TRP    13      -5.157  -1.299  -3.410  1.00  1.00          
ATOM    195  CZ2 TRP    13      -2.361  -3.447  -1.724  1.00  1.00          
ATOM    196  HZ2 TRP    13      -1.601  -4.066  -1.262  1.00  1.00          
ATOM    197  CZ3 TRP    13      -4.566  -3.216  -2.675  1.00  1.00          
ATOM    198  HZ3 TRP    13      -5.504  -3.685  -2.935  1.00  1.00          
ATOM    199  CH2 TRP    13      -3.565  -3.989  -2.072  1.00  1.00          
ATOM    200  HH2 TRP    13      -3.762  -5.034  -1.877  1.00  1.00          
ATOM    201  C   TRP    13      -4.207   2.161  -5.486  1.00  1.00          
ATOM    202  O   TRP    13      -5.280   1.571  -5.690  1.00  1.00          
ATOM    203  N   GLU    14      -3.968   3.482  -5.801  1.00  1.00          
ATOM    204  HN  GLU    14      -3.096   3.848  -5.548  1.00  1.00          
ATOM    205  CA  GLU    14      -4.922   4.411  -6.497  1.00  1.00          
ATOM    206  HA  GLU    14      -5.875   4.335  -5.994  1.00  1.00          
ATOM    207  CB  GLU    14      -4.427   5.865  -6.398  1.00  1.00          
ATOM    208  HB1 GLU    14      -4.913   6.447  -7.167  1.00  1.00          
ATOM    209  HB2 GLU    14      -3.361   5.878  -6.573  1.00  1.00          
ATOM    210  CG  GLU    14      -4.688   6.541  -5.055  1.00  1.00          
ATOM    211  HG1 GLU    14      -4.184   5.982  -4.281  1.00  1.00          
ATOM    212  HG2 GLU    14      -5.752   6.539  -4.866  1.00  1.00          
ATOM    213  CD  GLU    14      -4.193   7.975  -5.018  1.00  1.00          
ATOM    214  OE1 GLU    14      -4.994   8.888  -5.307  1.00  1.00          
ATOM    215  OE2 GLU    14      -3.003   8.183  -4.699  1.00  1.00          
ATOM    216  C   GLU    14      -5.129   4.058  -8.000  1.00  1.00          
ATOM    217  O   GLU    14      -6.217   4.314  -8.541  1.00  1.00          
ATOM    218  N   GLU    15      -4.055   3.473  -8.649  1.00  1.00          
ATOM    219  HN  GLU    15      -3.230   3.319  -8.128  1.00  1.00          
ATOM    220  CA  GLU    15      -4.048   3.031 -10.086  1.00  1.00          
ATOM    221  HA  GLU    15      -4.509   3.819 -10.662  1.00  1.00          
ATOM    222  CB  GLU    15      -2.604   2.844 -10.589  1.00  1.00          
ATOM    223  HB1 GLU    15      -2.622   2.205 -11.460  1.00  1.00          
ATOM    224  HB2 GLU    15      -2.029   2.360  -9.813  1.00  1.00          
ATOM    225  CG  GLU    15      -1.895   4.143 -10.965  1.00  1.00          
ATOM    226  HG1 GLU    15      -1.851   4.779 -10.092  1.00  1.00          
ATOM    227  HG2 GLU    15      -2.462   4.638 -11.739  1.00  1.00          
ATOM    228  CD  GLU    15      -0.482   3.918 -11.472  1.00  1.00          
ATOM    229  OE1 GLU    15      -0.304   3.799 -12.703  1.00  1.00          
ATOM    230  OE2 GLU    15       0.448   3.863 -10.638  1.00  1.00          
ATOM    231  C   GLU    15      -4.856   1.726 -10.327  1.00  1.00          
ATOM    232  O   GLU    15      -5.487   1.583 -11.386  1.00  1.00          
ATOM    233  N   LEU    16      -4.815   0.793  -9.313  1.00  1.00          
ATOM    234  HN  LEU    16      -4.272   1.013  -8.527  1.00  1.00          
ATOM    235  CA  LEU    16      -5.531  -0.525  -9.302  1.00  1.00          
ATOM    236  HA  LEU    16      -5.286  -1.030 -10.224  1.00  1.00          
ATOM    237  CB  LEU    16      -5.014  -1.371  -8.126  1.00  1.00          
ATOM    238  HB1 LEU    16      -5.761  -2.115  -7.894  1.00  1.00          
ATOM    239  HB2 LEU    16      -4.901  -0.721  -7.271  1.00  1.00          
ATOM    240  CG  LEU    16      -3.682  -2.089  -8.365  1.00  1.00          
ATOM    241  HG  LEU    16      -3.230  -1.706  -9.269  1.00  1.00          
ATOM    242  CD1 LEU    16      -2.723  -1.829  -7.213  1.00  1.00          
ATOM    243 HD11 LEU    16      -2.434  -0.789  -7.217  1.00  1.00          
ATOM    244 HD12 LEU    16      -1.845  -2.446  -7.329  1.00  1.00          
ATOM    245 HD13 LEU    16      -3.209  -2.064  -6.275  1.00  1.00          
ATOM    246  CD2 LEU    16      -3.906  -3.581  -8.543  1.00  1.00          
ATOM    247 HD21 LEU    16      -4.651  -3.744  -9.307  1.00  1.00          
ATOM    248 HD22 LEU    16      -4.247  -4.007  -7.610  1.00  1.00          
ATOM    249 HD23 LEU    16      -2.980  -4.051  -8.836  1.00  1.00          
ATOM    250  C   LEU    16      -7.082  -0.392  -9.222  1.00  1.00          
ATOM    251  O   LEU    16      -7.797  -1.152  -9.894  1.00  1.00          
ATOM    252  N   ILE    17      -7.564   0.589  -8.376  1.00  1.00          
ATOM    253  HN  ILE    17      -6.905   1.114  -7.878  1.00  1.00          
ATOM    254  CA  ILE    17      -9.021   0.920  -8.154  1.00  1.00          
ATOM    255  HA  ILE    17      -9.547  -0.023  -8.086  1.00  1.00          
ATOM    256  CB  ILE    17      -9.283   1.731  -6.766  1.00  1.00          
ATOM    257  HB  ILE    17      -9.012   2.758  -6.972  1.00  1.00          
ATOM    258  CG1 ILE    17      -8.423   1.252  -5.486  1.00  1.00          
ATOM    259 HG11 ILE    17      -8.829   1.751  -4.615  1.00  1.00          
ATOM    260 HG12 ILE    17      -7.411   1.598  -5.620  1.00  1.00          
ATOM    261  CG2 ILE    17     -10.798   1.759  -6.372  1.00  1.00          
ATOM    262 HG21 ILE    17     -11.113   0.765  -6.095  1.00  1.00          
ATOM    263 HG22 ILE    17     -11.380   2.095  -7.220  1.00  1.00          
ATOM    264 HG23 ILE    17     -10.945   2.433  -5.542  1.00  1.00          
ATOM    265  CD1 ILE    17      -8.315  -0.266  -5.133  1.00  1.00          
ATOM    266 HD11 ILE    17      -8.367  -0.391  -4.061  1.00  1.00          
ATOM    267 HD12 ILE    17      -7.375  -0.655  -5.494  1.00  1.00          
ATOM    268 HD13 ILE    17      -9.128  -0.801  -5.599  1.00  1.00          
ATOM    269  C   ILE    17      -9.605   1.706  -9.392  1.00  1.00          
ATOM    270  O   ILE    17     -10.742   1.429  -9.806  1.00  1.00          
ATOM    271  N   GLU    18      -8.789   2.673  -9.944  1.00  1.00          
ATOM    272  HN  GLU    18      -7.909   2.811  -9.536  1.00  1.00          
ATOM    273  CA  GLU    18      -9.137   3.532 -11.124  1.00  1.00          
ATOM    274  HA  GLU    18     -10.094   3.986 -10.916  1.00  1.00          
ATOM    275  CB  GLU    18      -8.092   4.649 -11.264  1.00  1.00          
ATOM    276  HB1 GLU    18      -7.478   4.443 -12.126  1.00  1.00          
ATOM    277  HB2 GLU    18      -7.468   4.653 -10.384  1.00  1.00          
ATOM    278  CG  GLU    18      -8.691   6.039 -11.426  1.00  1.00          
ATOM    279  HG1 GLU    18      -9.296   6.259 -10.558  1.00  1.00          
ATOM    280  HG2 GLU    18      -9.313   6.049 -12.308  1.00  1.00          
ATOM    281  CD  GLU    18      -7.632   7.113 -11.566  1.00  1.00          
ATOM    282  OE1 GLU    18      -7.356   7.526 -12.712  1.00  1.00          
ATOM    283  OE2 GLU    18      -7.077   7.544 -10.532  1.00  1.00          
ATOM    284  C   GLU    18      -9.252   2.738 -12.462  1.00  1.00          
ATOM    285  O   GLU    18     -10.109   3.070 -13.297  1.00  1.00          
ATOM    286  N   GLU    19      -8.371   1.695 -12.623  1.00  1.00          
ATOM    287  HN  GLU    19      -7.726   1.518 -11.907  1.00  1.00          
ATOM    288  CA  GLU    19      -8.326   0.776 -13.795  1.00  1.00          
ATOM    289  HA  GLU    19      -8.483   1.363 -14.687  1.00  1.00          
ATOM    290  CB  GLU    19      -6.951   0.112 -13.876  1.00  1.00          
ATOM    291  HB1 GLU    19      -7.044  -0.762 -14.480  1.00  1.00          
ATOM    292  HB2 GLU    19      -6.669  -0.194 -12.881  1.00  1.00          
ATOM    293  CG  GLU    19      -5.837   0.985 -14.458  1.00  1.00          
ATOM    294  HG1 GLU    19      -5.715   1.857 -13.831  1.00  1.00          
ATOM    295  HG2 GLU    19      -6.124   1.295 -15.452  1.00  1.00          
ATOM    296  CD  GLU    19      -4.511   0.255 -14.541  1.00  1.00          
ATOM    297  OE1 GLU    19      -3.762   0.268 -13.542  1.00  1.00          
ATOM    298  OE2 GLU    19      -4.221  -0.332 -15.606  1.00  1.00          
ATOM    299  C   GLU    19      -9.394  -0.352 -13.738  1.00  1.00          
ATOM    300  O   GLU    19      -9.772  -0.895 -14.796  1.00  1.00          
ATOM    301  N   MET    20      -9.869  -0.662 -12.495  1.00  1.00          
ATOM    302  HN  MET    20      -9.596  -0.098 -11.738  1.00  1.00          
ATOM    303  CA  MET    20     -10.851  -1.732 -12.224  1.00  1.00          
ATOM    304  HA  MET    20     -10.869  -2.350 -13.108  1.00  1.00          
ATOM    305  CB  MET    20     -10.362  -2.600 -11.039  1.00  1.00          
ATOM    306  HB1 MET    20     -11.204  -3.141 -10.644  1.00  1.00          
ATOM    307  HB2 MET    20      -9.976  -1.948 -10.271  1.00  1.00          
ATOM    308  CG  MET    20      -9.271  -3.611 -11.399  1.00  1.00          
ATOM    309  HG1 MET    20      -8.427  -3.078 -11.810  1.00  1.00          
ATOM    310  HG2 MET    20      -9.661  -4.290 -12.143  1.00  1.00          
ATOM    311  SD  MET    20      -8.712  -4.575  -9.980  1.00  1.00          
ATOM    312  CE  MET    20      -9.788  -6.004 -10.086  1.00  1.00          
ATOM    313  HE1 MET    20      -9.826  -6.498  -9.128  1.00  1.00          
ATOM    314  HE2 MET    20      -9.405  -6.688 -10.829  1.00  1.00          
ATOM    315  HE3 MET    20     -10.781  -5.687 -10.369  1.00  1.00          
ATOM    316  C   MET    20     -12.301  -1.185 -11.975  1.00  1.00          
ATOM    317  O   MET    20     -13.238  -1.979 -11.741  1.00  1.00          
ATOM    318  N   LEU    21     -12.478   0.177 -12.072  1.00  1.00          
ATOM    319  HN  LEU    21     -11.693   0.723 -12.292  1.00  1.00          
ATOM    320  CA  LEU    21     -13.782   0.887 -11.867  1.00  1.00          
ATOM    321  HA  LEU    21     -14.289   0.374 -11.064  1.00  1.00          
ATOM    322  CB  LEU    21     -13.467   2.336 -11.407  1.00  1.00          
ATOM    323  HB1 LEU    21     -13.584   2.989 -12.261  1.00  1.00          
ATOM    324  HB2 LEU    21     -12.435   2.372 -11.093  1.00  1.00          
ATOM    325  CG  LEU    21     -14.335   2.892 -10.262  1.00  1.00          
ATOM    326  HG  LEU    21     -15.254   2.327 -10.201  1.00  1.00          
ATOM    327  CD1 LEU    21     -13.620   2.772  -8.918  1.00  1.00          
ATOM    328 HD11 LEU    21     -12.795   3.469  -8.885  1.00  1.00          
ATOM    329 HD12 LEU    21     -13.246   1.766  -8.798  1.00  1.00          
ATOM    330 HD13 LEU    21     -14.313   2.996  -8.120  1.00  1.00          
ATOM    331  CD2 LEU    21     -14.700   4.342 -10.537  1.00  1.00          
ATOM    332 HD21 LEU    21     -15.350   4.393 -11.397  1.00  1.00          
ATOM    333 HD22 LEU    21     -13.801   4.908 -10.730  1.00  1.00          
ATOM    334 HD23 LEU    21     -15.207   4.754  -9.677  1.00  1.00          
ATOM    335  C   LEU    21     -14.727   0.863 -13.135  1.00  1.00          
ATOM    336  O   LEU    21     -15.767   1.563 -13.176  1.00  1.00          
ATOM    337  N   ILE    22     -14.367  -0.011 -14.121  1.00  1.00          
ATOM    338  HN  ILE    22     -13.573  -0.559 -13.970  1.00  1.00          
ATOM    339  CA  ILE    22     -15.104  -0.215 -15.411  1.00  1.00          
ATOM    340  HA  ILE    22     -15.610   0.719 -15.613  1.00  1.00          
ATOM    341  CB  ILE    22     -14.139  -0.497 -16.648  1.00  1.00          
ATOM    342  HB  ILE    22     -14.761  -0.873 -17.439  1.00  1.00          
ATOM    343  CG1 ILE    22     -12.992  -1.534 -16.396  1.00  1.00          
ATOM    344 HG11 ILE    22     -13.044  -1.877 -15.372  1.00  1.00          
ATOM    345 HG12 ILE    22     -12.038  -1.053 -16.559  1.00  1.00          
ATOM    346  CG2 ILE    22     -13.533   0.810 -17.141  1.00  1.00          
ATOM    347 HG21 ILE    22     -12.992   1.277 -16.331  1.00  1.00          
ATOM    348 HG22 ILE    22     -14.317   1.471 -17.478  1.00  1.00          
ATOM    349 HG23 ILE    22     -12.856   0.608 -17.957  1.00  1.00          
ATOM    350  CD1 ILE    22     -13.061  -2.746 -17.301  1.00  1.00          
ATOM    351 HD11 ILE    22     -12.869  -2.447 -18.322  1.00  1.00          
ATOM    352 HD12 ILE    22     -14.045  -3.187 -17.235  1.00  1.00          
ATOM    353 HD13 ILE    22     -12.320  -3.470 -16.994  1.00  1.00          
ATOM    354  C   ILE    22     -16.215  -1.322 -15.323  1.00  1.00          
ATOM    355  O   ILE    22     -17.017  -1.469 -16.268  1.00  1.00          
ATOM    356  N   ILE    23     -16.246  -2.055 -14.171  1.00  1.00          
ATOM    357  HN  ILE    23     -15.585  -1.830 -13.484  1.00  1.00          
ATOM    358  CA  ILE    23     -17.214  -3.161 -13.879  1.00  1.00          
ATOM    359  HA  ILE    23     -17.643  -3.471 -14.825  1.00  1.00          
ATOM    360  CB  ILE    23     -16.551  -4.456 -13.175  1.00  1.00          
ATOM    361  HB  ILE    23     -16.448  -4.234 -12.120  1.00  1.00          
ATOM    362  CG1 ILE    23     -15.152  -4.836 -13.744  1.00  1.00          
ATOM    363 HG11 ILE    23     -14.885  -4.128 -14.517  1.00  1.00          
ATOM    364 HG12 ILE    23     -15.205  -5.823 -14.174  1.00  1.00          
ATOM    365  CG2 ILE    23     -17.446  -5.719 -13.302  1.00  1.00          
ATOM    366 HG21 ILE    23     -17.422  -6.076 -14.321  1.00  1.00          
ATOM    367 HG22 ILE    23     -18.461  -5.469 -13.032  1.00  1.00          
ATOM    368 HG23 ILE    23     -17.079  -6.490 -12.640  1.00  1.00          
ATOM    369  CD1 ILE    23     -14.038  -4.841 -12.711  1.00  1.00          
ATOM    370 HD11 ILE    23     -14.212  -5.629 -11.994  1.00  1.00          
ATOM    371 HD12 ILE    23     -14.012  -3.887 -12.201  1.00  1.00          
ATOM    372 HD13 ILE    23     -13.090  -5.007 -13.204  1.00  1.00          
ATOM    373  C   ILE    23     -18.357  -2.596 -12.990  1.00  1.00          
ATOM    374  O   ILE    23     -18.095  -1.832 -12.042  1.00  1.00          
ATOM    375  N   GLU    24     -19.615  -3.011 -13.335  1.00  1.00          
ATOM    376  HN  GLU    24     -19.700  -3.609 -14.107  1.00  1.00          
ATOM    377  CA  GLU    24     -20.878  -2.622 -12.613  1.00  1.00          
ATOM    378  HA  GLU    24     -20.795  -1.568 -12.408  1.00  1.00          
ATOM    379  CB  GLU    24     -22.112  -2.847 -13.495  1.00  1.00          
ATOM    380  HB1 GLU    24     -22.982  -2.924 -12.859  1.00  1.00          
ATOM    381  HB2 GLU    24     -21.989  -3.775 -14.032  1.00  1.00          
ATOM    382  CG  GLU    24     -22.360  -1.739 -14.511  1.00  1.00          
ATOM    383  HG1 GLU    24     -21.510  -1.680 -15.176  1.00  1.00          
ATOM    384  HG2 GLU    24     -22.468  -0.802 -13.983  1.00  1.00          
ATOM    385  CD  GLU    24     -23.610  -1.974 -15.337  1.00  1.00          
ATOM    386  OE1 GLU    24     -23.513  -2.654 -16.379  1.00  1.00          
ATOM    387  OE2 GLU    24     -24.686  -1.479 -14.939  1.00  1.00          
ATOM    388  C   GLU    24     -21.069  -3.339 -11.252  1.00  1.00          
ATOM    389  O   GLU    24     -21.730  -2.783 -10.360  1.00  1.00          
ATOM    390  N   ASN    25     -20.478  -4.575 -11.123  1.00  1.00          
ATOM    391  HN  ASN    25     -20.016  -4.937 -11.907  1.00  1.00          
ATOM    392  CA  ASN    25     -20.485  -5.413  -9.877  1.00  1.00          
ATOM    393  HA  ASN    25     -21.503  -5.455  -9.519  1.00  1.00          
ATOM    394  CB  ASN    25     -20.018  -6.835 -10.202  1.00  1.00          
ATOM    395  HB1 ASN    25     -19.629  -7.294  -9.305  1.00  1.00          
ATOM    396  HB2 ASN    25     -19.237  -6.792 -10.946  1.00  1.00          
ATOM    397  CG  ASN    25     -21.139  -7.703 -10.735  1.00  1.00          
ATOM    398  OD1 ASN    25     -21.366  -7.775 -11.943  1.00  1.00          
ATOM    399  ND2 ASN    25     -21.847  -8.370  -9.832  1.00  1.00          
ATOM    400 HD21 ASN    25     -21.609  -8.265  -8.887  1.00  1.00          
ATOM    401 HD22 ASN    25     -22.580  -8.940 -10.146  1.00  1.00          
ATOM    402  C   ASN    25     -19.587  -4.826  -8.745  1.00  1.00          
ATOM    403  O   ASN    25     -19.800  -5.128  -7.561  1.00  1.00          
ATOM    404  N   PHE    26     -18.579  -3.974  -9.164  1.00  1.00          
ATOM    405  HN  PHE    26     -18.479  -3.886 -10.131  1.00  1.00          
ATOM    406  CA  PHE    26     -17.585  -3.264  -8.287  1.00  1.00          
ATOM    407  HA  PHE    26     -17.010  -4.031  -7.794  1.00  1.00          
ATOM    408  CB  PHE    26     -16.615  -2.431  -9.145  1.00  1.00          
ATOM    409  HB1 PHE    26     -16.916  -1.401  -9.104  1.00  1.00          
ATOM    410  HB2 PHE    26     -16.679  -2.767 -10.166  1.00  1.00          
ATOM    411  CG  PHE    26     -15.159  -2.522  -8.700  1.00  1.00          
ATOM    412  CD1 PHE    26     -14.630  -1.587  -7.813  1.00  1.00          
ATOM    413  HD1 PHE    26     -15.259  -0.786  -7.451  1.00  1.00          
ATOM    414  CD2 PHE    26     -14.325  -3.548  -9.152  1.00  1.00          
ATOM    415  HD2 PHE    26     -14.718  -4.283  -9.840  1.00  1.00          
ATOM    416  CE1 PHE    26     -13.316  -1.672  -7.392  1.00  1.00          
ATOM    417  HE1 PHE    26     -12.922  -0.940  -6.702  1.00  1.00          
ATOM    418  CE2 PHE    26     -13.012  -3.634  -8.730  1.00  1.00          
ATOM    419  HE2 PHE    26     -12.384  -4.438  -9.082  1.00  1.00          
ATOM    420  CZ  PHE    26     -12.508  -2.696  -7.849  1.00  1.00          
ATOM    421  HZ  PHE    26     -11.480  -2.761  -7.520  1.00  1.00          
ATOM    422  C   PHE    26     -18.221  -2.379  -7.186  1.00  1.00          
ATOM    423  O   PHE    26     -17.657  -2.266  -6.085  1.00  1.00          
ATOM    424  N   GLU    27     -19.401  -1.766  -7.527  1.00  1.00          
ATOM    425  HN  GLU    27     -19.712  -1.879  -8.450  1.00  1.00          
ATOM    426  CA  GLU    27     -20.248  -0.926  -6.599  1.00  1.00          
ATOM    427  HA  GLU    27     -19.621  -0.140  -6.211  1.00  1.00          
ATOM    428  CB  GLU    27     -21.426  -0.290  -7.359  1.00  1.00          
ATOM    429  HB1 GLU    27     -22.166   0.029  -6.640  1.00  1.00          
ATOM    430  HB2 GLU    27     -21.866  -1.036  -8.002  1.00  1.00          
ATOM    431  CG  GLU    27     -21.055   0.915  -8.220  1.00  1.00          
ATOM    432  HG1 GLU    27     -20.294   0.616  -8.927  1.00  1.00          
ATOM    433  HG2 GLU    27     -20.662   1.691  -7.579  1.00  1.00          
ATOM    434  CD  GLU    27     -22.238   1.474  -8.985  1.00  1.00          
ATOM    435  OE1 GLU    27     -22.504   0.988 -10.104  1.00  1.00          
ATOM    436  OE2 GLU    27     -22.900   2.396  -8.465  1.00  1.00          
ATOM    437  C   GLU    27     -20.810  -1.753  -5.397  1.00  1.00          
ATOM    438  O   GLU    27     -21.054  -1.194  -4.316  1.00  1.00          
ATOM    439  N   GLU    28     -20.997  -3.093  -5.650  1.00  1.00          
ATOM    440  HN  GLU    28     -20.774  -3.414  -6.558  1.00  1.00          
ATOM    441  CA  GLU    28     -21.472  -4.102  -4.659  1.00  1.00          
ATOM    442  HA  GLU    28     -22.153  -3.600  -3.987  1.00  1.00          
ATOM    443  CB  GLU    28     -22.229  -5.230  -5.379  1.00  1.00          
ATOM    444  HB1 GLU    28     -22.140  -6.133  -4.791  1.00  1.00          
ATOM    445  HB2 GLU    28     -21.762  -5.395  -6.343  1.00  1.00          
ATOM    446  CG  GLU    28     -23.724  -4.942  -5.591  1.00  1.00          
ATOM    447  HG1 GLU    28     -24.047  -5.388  -6.524  1.00  1.00          
ATOM    448  HG2 GLU    28     -23.864  -3.873  -5.642  1.00  1.00          
ATOM    449  CD  GLU    28     -24.602  -5.487  -4.473  1.00  1.00          
ATOM    450  OE1 GLU    28     -24.852  -6.711  -4.457  1.00  1.00          
ATOM    451  OE2 GLU    28     -25.035  -4.688  -3.616  1.00  1.00          
ATOM    452  C   GLU    28     -20.313  -4.697  -3.816  1.00  1.00          
ATOM    453  O   GLU    28     -20.512  -4.990  -2.625  1.00  1.00          
ATOM    454  N   ILE    29     -19.100  -4.858  -4.465  1.00  1.00          
ATOM    455  HN  ILE    29     -19.056  -4.577  -5.402  1.00  1.00          
ATOM    456  CA  ILE    29     -17.826  -5.391  -3.839  1.00  1.00          
ATOM    457  HA  ILE    29     -18.119  -6.251  -3.247  1.00  1.00          
ATOM    458  CB  ILE    29     -16.741  -5.905  -4.933  1.00  1.00          
ATOM    459  HB  ILE    29     -16.436  -5.047  -5.515  1.00  1.00          
ATOM    460  CG1 ILE    29     -17.347  -6.982  -5.891  1.00  1.00          
ATOM    461 HG11 ILE    29     -18.421  -6.990  -5.770  1.00  1.00          
ATOM    462 HG12 ILE    29     -16.959  -7.948  -5.606  1.00  1.00          
ATOM    463  CG2 ILE    29     -15.462  -6.544  -4.282  1.00  1.00          
ATOM    464 HG21 ILE    29     -14.576  -6.253  -4.832  1.00  1.00          
ATOM    465 HG22 ILE    29     -15.553  -7.620  -4.293  1.00  1.00          
ATOM    466 HG23 ILE    29     -15.380  -6.204  -3.259  1.00  1.00          
ATOM    467  CD1 ILE    29     -17.050  -6.801  -7.383  1.00  1.00          
ATOM    468 HD11 ILE    29     -16.128  -6.252  -7.511  1.00  1.00          
ATOM    469 HD12 ILE    29     -17.859  -6.262  -7.849  1.00  1.00          
ATOM    470 HD13 ILE    29     -16.953  -7.772  -7.848  1.00  1.00          
ATOM    471  C   ILE    29     -17.214  -4.327  -2.842  1.00  1.00          
ATOM    472  O   ILE    29     -16.719  -4.716  -1.772  1.00  1.00          
ATOM    473  N   VAL    30     -17.268  -3.006  -3.232  1.00  1.00          
ATOM    474  HN  VAL    30     -17.681  -2.807  -4.098  1.00  1.00          
ATOM    475  CA  VAL    30     -16.734  -1.828  -2.423  1.00  1.00          
ATOM    476  HA  VAL    30     -15.699  -2.078  -2.227  1.00  1.00          
ATOM    477  CB  VAL    30     -16.721  -0.442  -3.218  1.00  1.00          
ATOM    478  HB  VAL    30     -16.463   0.331  -2.501  1.00  1.00          
ATOM    479  CG1 VAL    30     -15.615  -0.442  -4.273  1.00  1.00          
ATOM    480 HG11 VAL    30     -15.795  -1.240  -4.979  1.00  1.00          
ATOM    481 HG12 VAL    30     -14.659  -0.591  -3.794  1.00  1.00          
ATOM    482 HG13 VAL    30     -15.614   0.505  -4.794  1.00  1.00          
ATOM    483  CG2 VAL    30     -18.069  -0.038  -3.897  1.00  1.00          
ATOM    484 HG21 VAL    30     -18.619  -0.929  -4.165  1.00  1.00          
ATOM    485 HG22 VAL    30     -17.860   0.536  -4.785  1.00  1.00          
ATOM    486 HG23 VAL    30     -18.665   0.560  -3.215  1.00  1.00          
ATOM    487  C   VAL    30     -17.415  -1.633  -1.014  1.00  1.00          
ATOM    488  O   VAL    30     -16.859  -0.932  -0.153  1.00  1.00          
ATOM    489  N   LYS    31     -18.636  -2.226  -0.863  1.00  1.00          
ATOM    490  HN  LYS    31     -19.028  -2.656  -1.650  1.00  1.00          
ATOM    491  CA  LYS    31     -19.444  -2.219   0.392  1.00  1.00          
ATOM    492  HA  LYS    31     -19.268  -1.274   0.885  1.00  1.00          
ATOM    493  CB  LYS    31     -20.940  -2.313   0.040  1.00  1.00          
ATOM    494  HB1 LYS    31     -21.470  -2.734   0.881  1.00  1.00          
ATOM    495  HB2 LYS    31     -21.052  -2.971  -0.812  1.00  1.00          
ATOM    496  CG  LYS    31     -21.584  -0.977  -0.315  1.00  1.00          
ATOM    497  HG1 LYS    31     -21.051  -0.540  -1.148  1.00  1.00          
ATOM    498  HG2 LYS    31     -21.524  -0.319   0.538  1.00  1.00          
ATOM    499  CD  LYS    31     -23.045  -1.151  -0.700  1.00  1.00          
ATOM    500  HD1 LYS    31     -23.576  -1.590   0.132  1.00  1.00          
ATOM    501  HD2 LYS    31     -23.107  -1.807  -1.556  1.00  1.00          
ATOM    502  CE  LYS    31     -23.687   0.179  -1.051  1.00  1.00          
ATOM    503  HE1 LYS    31     -23.146   0.619  -1.876  1.00  1.00          
ATOM    504  HE2 LYS    31     -23.625   0.831  -0.192  1.00  1.00          
ATOM    505  NZ  LYS    31     -25.115   0.020  -1.436  1.00  1.00          
ATOM    506  HZ1 LYS    31     -25.704   0.696  -0.909  1.00  1.00          
ATOM    507  HZ2 LYS    31     -25.437  -0.944  -1.220  1.00  1.00          
ATOM    508  HZ3 LYS    31     -25.232   0.194  -2.454  1.00  1.00          
ATOM    509  C   LYS    31     -19.066  -3.363   1.384  1.00  1.00          
ATOM    510  O   LYS    31     -19.371  -3.241   2.589  1.00  1.00          
ATOM    511  N   ASP    32     -18.396  -4.444   0.865  1.00  1.00          
ATOM    512  HN  ASP    32     -18.170  -4.432  -0.083  1.00  1.00          
ATOM    513  CA  ASP    32     -17.971  -5.618   1.658  1.00  1.00          
ATOM    514  HA  ASP    32     -18.111  -5.363   2.699  1.00  1.00          
ATOM    515  CB  ASP    32     -18.850  -6.851   1.334  1.00  1.00          
ATOM    516  HB1 ASP    32     -18.332  -7.743   1.651  1.00  1.00          
ATOM    517  HB2 ASP    32     -19.015  -6.897   0.269  1.00  1.00          
ATOM    518  CG  ASP    32     -20.200  -6.811   2.024  1.00  1.00          
ATOM    519  OD1 ASP    32     -20.245  -7.024   3.253  1.00  1.00          
ATOM    520  OD2 ASP    32     -21.210  -6.566   1.333  1.00  1.00          
ATOM    521  C   ASP    32     -16.477  -5.937   1.447  1.00  1.00          
ATOM    522  O   ASP    32     -16.038  -6.313   0.338  1.00  1.00          
ATOM    523  N   ARG    33     -15.696  -5.696   2.541  1.00  1.00          
ATOM    524  HN  ARG    33     -16.114  -5.203   3.272  1.00  1.00          
ATOM    525  CA  ARG    33     -14.203  -5.966   2.657  1.00  1.00          
ATOM    526  HA  ARG    33     -13.747  -5.429   1.839  1.00  1.00          
ATOM    527  CB  ARG    33     -13.602  -5.390   3.997  1.00  1.00          
ATOM    528  HB1 ARG    33     -13.539  -4.316   3.898  1.00  1.00          
ATOM    529  HB2 ARG    33     -12.598  -5.775   4.096  1.00  1.00          
ATOM    530  CG  ARG    33     -14.364  -5.685   5.329  1.00  1.00          
ATOM    531  HG1 ARG    33     -13.681  -6.081   6.070  1.00  1.00          
ATOM    532  HG2 ARG    33     -15.143  -6.407   5.134  1.00  1.00          
ATOM    533  CD  ARG    33     -14.998  -4.414   5.870  1.00  1.00          
ATOM    534  HD1 ARG    33     -15.615  -3.981   5.098  1.00  1.00          
ATOM    535  HD2 ARG    33     -14.211  -3.721   6.131  1.00  1.00          
ATOM    536  NE  ARG    33     -15.833  -4.661   7.070  1.00  1.00          
ATOM    537  HE  ARG    33     -15.828  -5.580   7.413  1.00  1.00          
ATOM    538  CZ  ARG    33     -16.606  -3.750   7.740  1.00  1.00          
ATOM    539  NH1 ARG    33     -16.704  -2.449   7.390  1.00  1.00          
ATOM    540 HH11 ARG    33     -16.194  -2.102   6.603  1.00  1.00          
ATOM    541 HH12 ARG    33     -17.284  -1.831   7.920  1.00  1.00          
ATOM    542  NH2 ARG    33     -17.294  -4.164   8.792  1.00  1.00          
ATOM    543 HH21 ARG    33     -17.242  -5.121   9.077  1.00  1.00          
ATOM    544 HH22 ARG    33     -17.866  -3.520   9.300  1.00  1.00          
ATOM    545  C   ARG    33     -13.775  -7.453   2.472  1.00  1.00          
ATOM    546  O   ARG    33     -12.675  -7.709   1.954  1.00  1.00          
ATOM    547  N   GLU    34     -14.667  -8.401   2.897  1.00  1.00          
ATOM    548  HN  GLU    34     -15.495  -8.092   3.316  1.00  1.00          
ATOM    549  CA  GLU    34     -14.475  -9.886   2.784  1.00  1.00          
ATOM    550  HA  GLU    34     -13.504 -10.117   3.193  1.00  1.00          
ATOM    551  CB  GLU    34     -15.540 -10.592   3.625  1.00  1.00          
ATOM    552  HB1 GLU    34     -16.262 -11.039   2.963  1.00  1.00          
ATOM    553  HB2 GLU    34     -16.036  -9.854   4.236  1.00  1.00          
ATOM    554  CG  GLU    34     -14.990 -11.675   4.546  1.00  1.00          
ATOM    555  HG1 GLU    34     -14.239 -11.239   5.188  1.00  1.00          
ATOM    556  HG2 GLU    34     -14.541 -12.449   3.942  1.00  1.00          
ATOM    557  CD  GLU    34     -16.066 -12.303   5.413  1.00  1.00          
ATOM    558  OE1 GLU    34     -16.255 -11.841   6.559  1.00  1.00          
ATOM    559  OE2 GLU    34     -16.719 -13.259   4.945  1.00  1.00          
ATOM    560  C   GLU    34     -14.514 -10.404   1.313  1.00  1.00          
ATOM    561  O   GLU    34     -13.832 -11.393   0.994  1.00  1.00          
ATOM    562  N   ARG    35     -15.331  -9.710   0.452  1.00  1.00          
ATOM    563  HN  ARG    35     -15.848  -8.961   0.818  1.00  1.00          
ATOM    564  CA  ARG    35     -15.478  -9.994  -1.009  1.00  1.00          
ATOM    565  HA  ARG    35     -15.418 -11.066  -1.131  1.00  1.00          
ATOM    566  CB  ARG    35     -16.844  -9.520  -1.541  1.00  1.00          
ATOM    567  HB1 ARG    35     -16.792  -9.468  -2.618  1.00  1.00          
ATOM    568  HB2 ARG    35     -17.038  -8.531  -1.156  1.00  1.00          
ATOM    569  CG  ARG    35     -18.031 -10.418  -1.163  1.00  1.00          
ATOM    570  HG1 ARG    35     -18.078 -10.489  -0.085  1.00  1.00          
ATOM    571  HG2 ARG    35     -17.868 -11.400  -1.579  1.00  1.00          
ATOM    572  CD  ARG    35     -19.369  -9.878  -1.689  1.00  1.00          
ATOM    573  HD1 ARG    35     -19.407  -8.815  -1.500  1.00  1.00          
ATOM    574  HD2 ARG    35     -20.176 -10.363  -1.158  1.00  1.00          
ATOM    575  NE  ARG    35     -19.561 -10.110  -3.154  1.00  1.00          
ATOM    576  HE  ARG    35     -18.986 -10.795  -3.555  1.00  1.00          
ATOM    577  CZ  ARG    35     -20.439  -9.469  -3.988  1.00  1.00          
ATOM    578  NH1 ARG    35     -21.296  -8.515  -3.576  1.00  1.00          
ATOM    579 HH11 ARG    35     -21.313  -8.240  -2.614  1.00  1.00          
ATOM    580 HH12 ARG    35     -21.916  -8.082  -4.230  1.00  1.00          
ATOM    581  NH2 ARG    35     -20.453  -9.807  -5.271  1.00  1.00          
ATOM    582 HH21 ARG    35     -19.831 -10.513  -5.608  1.00  1.00          
ATOM    583 HH22 ARG    35     -21.085  -9.354  -5.900  1.00  1.00          
ATOM    584  C   ARG    35     -14.353  -9.351  -1.865  1.00  1.00          
ATOM    585  O   ARG    35     -13.937  -9.953  -2.870  1.00  1.00          
ATOM    586  N   PHE    36     -13.872  -8.120  -1.439  1.00  1.00          
ATOM    587  HN  PHE    36     -14.272  -7.734  -0.632  1.00  1.00          
ATOM    588  CA  PHE    36     -12.788  -7.335  -2.119  1.00  1.00          
ATOM    589  HA  PHE    36     -13.032  -7.321  -3.175  1.00  1.00          
ATOM    590  CB  PHE    36     -12.768  -5.860  -1.604  1.00  1.00          
ATOM    591  HB1 PHE    36     -12.121  -5.808  -0.739  1.00  1.00          
ATOM    592  HB2 PHE    36     -13.766  -5.584  -1.306  1.00  1.00          
ATOM    593  CG  PHE    36     -12.276  -4.810  -2.611  1.00  1.00          
ATOM    594  CD1 PHE    36     -13.182  -4.017  -3.308  1.00  1.00          
ATOM    595  HD1 PHE    36     -14.239  -4.142  -3.138  1.00  1.00          
ATOM    596  CD2 PHE    36     -10.912  -4.619  -2.851  1.00  1.00          
ATOM    597  HD2 PHE    36     -10.191  -5.227  -2.322  1.00  1.00          
ATOM    598  CE1 PHE    36     -12.745  -3.066  -4.213  1.00  1.00          
ATOM    599  HE1 PHE    36     -13.462  -2.457  -4.749  1.00  1.00          
ATOM    600  CE2 PHE    36     -10.477  -3.670  -3.756  1.00  1.00          
ATOM    601  HE2 PHE    36      -9.420  -3.537  -3.933  1.00  1.00          
ATOM    602  CZ  PHE    36     -11.394  -2.894  -4.437  1.00  1.00          
ATOM    603  HZ  PHE    36     -11.055  -2.152  -5.144  1.00  1.00          
ATOM    604  C   PHE    36     -11.381  -7.994  -1.962  1.00  1.00          
ATOM    605  O   PHE    36     -10.656  -8.096  -2.957  1.00  1.00          
ATOM    606  N   LEU    37     -11.045  -8.465  -0.705  1.00  1.00          
ATOM    607  HN  LEU    37     -11.712  -8.391   0.008  1.00  1.00          
ATOM    608  CA  LEU    37      -9.748  -9.152  -0.357  1.00  1.00          
ATOM    609  HA  LEU    37      -8.952  -8.547  -0.765  1.00  1.00          
ATOM    610  CB  LEU    37      -9.569  -9.231   1.169  1.00  1.00          
ATOM    611  HB1 LEU    37      -8.934 -10.076   1.387  1.00  1.00          
ATOM    612  HB2 LEU    37     -10.538  -9.411   1.609  1.00  1.00          
ATOM    613  CG  LEU    37      -8.960  -7.990   1.838  1.00  1.00          
ATOM    614  HG  LEU    37      -9.017  -7.151   1.159  1.00  1.00          
ATOM    615  CD1 LEU    37      -9.735  -7.625   3.094  1.00  1.00          
ATOM    616 HD11 LEU    37      -9.264  -6.779   3.570  1.00  1.00          
ATOM    617 HD12 LEU    37      -9.736  -8.465   3.774  1.00  1.00          
ATOM    618 HD13 LEU    37     -10.751  -7.371   2.833  1.00  1.00          
ATOM    619  CD2 LEU    37      -7.493  -8.232   2.176  1.00  1.00          
ATOM    620 HD21 LEU    37      -7.421  -8.983   2.948  1.00  1.00          
ATOM    621 HD22 LEU    37      -7.048  -7.312   2.526  1.00  1.00          
ATOM    622 HD23 LEU    37      -6.971  -8.571   1.294  1.00  1.00          
ATOM    623  C   LEU    37      -9.625 -10.575  -0.974  1.00  1.00          
ATOM    624  O   LEU    37      -8.521 -10.988  -1.362  1.00  1.00          
ATOM    625  N   ALA    38     -10.798 -11.295  -1.035  1.00  1.00          
ATOM    626  HN  ALA    38     -11.594 -10.860  -0.661  1.00  1.00          
ATOM    627  CA  ALA    38     -10.947 -12.662  -1.630  1.00  1.00          
ATOM    628  HA  ALA    38     -10.133 -13.267  -1.257  1.00  1.00          
ATOM    629  CB  ALA    38     -12.249 -13.289  -1.162  1.00  1.00          
ATOM    630  HB1 ALA    38     -13.082 -12.721  -1.550  1.00  1.00          
ATOM    631  HB2 ALA    38     -12.280 -13.285  -0.084  1.00  1.00          
ATOM    632  HB3 ALA    38     -12.308 -14.305  -1.522  1.00  1.00          
ATOM    633  C   ALA    38     -10.885 -12.664  -3.184  1.00  1.00          
ATOM    634  O   ALA    38     -10.445 -13.661  -3.780  1.00  1.00          
ATOM    635  N   GLN    39     -11.334 -11.518  -3.802  1.00  1.00          
ATOM    636  HN  GLN    39     -11.679 -10.803  -3.227  1.00  1.00          
ATOM    637  CA  GLN    39     -11.334 -11.274  -5.273  1.00  1.00          
ATOM    638  HA  GLN    39     -11.622 -12.199  -5.749  1.00  1.00          
ATOM    639  CB  GLN    39     -12.363 -10.202  -5.635  1.00  1.00          
ATOM    640  HB1 GLN    39     -11.849  -9.350  -6.053  1.00  1.00          
ATOM    641  HB2 GLN    39     -12.880  -9.896  -4.736  1.00  1.00          
ATOM    642  CG  GLN    39     -13.400 -10.677  -6.644  1.00  1.00          
ATOM    643  HG1 GLN    39     -13.877 -11.568  -6.261  1.00  1.00          
ATOM    644  HG2 GLN    39     -12.897 -10.910  -7.571  1.00  1.00          
ATOM    645  CD  GLN    39     -14.469  -9.637  -6.925  1.00  1.00          
ATOM    646  OE1 GLN    39     -15.366  -9.414  -6.110  1.00  1.00          
ATOM    647  NE2 GLN    39     -14.376  -8.993  -8.084  1.00  1.00          
ATOM    648 HE21 GLN    39     -13.634  -9.222  -8.682  1.00  1.00          
ATOM    649 HE22 GLN    39     -15.051  -8.313  -8.293  1.00  1.00          
ATOM    650  C   GLN    39      -9.942 -10.870  -5.820  1.00  1.00          
ATOM    651  O   GLN    39      -9.610 -11.243  -6.947  1.00  1.00          
ATOM    652  N   VAL    40      -9.143 -10.104  -4.991  1.00  1.00          
ATOM    653  HN  VAL    40      -9.520  -9.838  -4.126  1.00  1.00          
ATOM    654  CA  VAL    40      -7.728  -9.640  -5.307  1.00  1.00          
ATOM    655  HA  VAL    40      -7.751  -9.261  -6.322  1.00  1.00          
ATOM    656  CB  VAL    40      -7.265  -8.421  -4.339  1.00  1.00          
ATOM    657  HB  VAL    40      -7.399  -8.743  -3.318  1.00  1.00          
ATOM    658  CG1 VAL    40      -5.795  -7.949  -4.503  1.00  1.00          
ATOM    659 HG11 VAL    40      -5.139  -8.808  -4.525  1.00  1.00          
ATOM    660 HG12 VAL    40      -5.525  -7.310  -3.674  1.00  1.00          
ATOM    661 HG13 VAL    40      -5.699  -7.397  -5.425  1.00  1.00          
ATOM    662  CG2 VAL    40      -8.144  -7.179  -4.545  1.00  1.00          
ATOM    663 HG21 VAL    40      -7.837  -6.403  -3.859  1.00  1.00          
ATOM    664 HG22 VAL    40      -9.177  -7.436  -4.359  1.00  1.00          
ATOM    665 HG23 VAL    40      -8.038  -6.826  -5.560  1.00  1.00          
ATOM    666  C   VAL    40      -6.740 -10.881  -5.289  1.00  1.00          
ATOM    667  O   VAL    40      -5.847 -10.964  -6.145  1.00  1.00          
ATOM    668  N   GLU    41      -6.948 -11.810  -4.291  1.00  1.00          
ATOM    669  HN  GLU    41      -7.679 -11.648  -3.658  1.00  1.00          
ATOM    670  CA  GLU    41      -6.156 -13.082  -4.095  1.00  1.00          
ATOM    671  HA  GLU    41      -5.108 -12.825  -4.137  1.00  1.00          
ATOM    672  CB  GLU    41      -6.452 -13.705  -2.709  1.00  1.00          
ATOM    673  HB1 GLU    41      -6.060 -14.711  -2.697  1.00  1.00          
ATOM    674  HB2 GLU    41      -7.523 -13.753  -2.579  1.00  1.00          
ATOM    675  CG  GLU    41      -5.870 -12.953  -1.514  1.00  1.00          
ATOM    676  HG1 GLU    41      -6.341 -11.983  -1.456  1.00  1.00          
ATOM    677  HG2 GLU    41      -4.807 -12.831  -1.658  1.00  1.00          
ATOM    678  CD  GLU    41      -6.102 -13.679  -0.203  1.00  1.00          
ATOM    679  OE1 GLU    41      -5.208 -14.441   0.221  1.00  1.00          
ATOM    680  OE2 GLU    41      -7.181 -13.490   0.398  1.00  1.00          
ATOM    681  C   GLU    41      -6.445 -14.160  -5.187  1.00  1.00          
ATOM    682  O   GLU    41      -5.529 -14.908  -5.569  1.00  1.00          
ATOM    683  N   GLU    42      -7.733 -14.199  -5.664  1.00  1.00          
ATOM    684  HN  GLU    42      -8.370 -13.556  -5.289  1.00  1.00          
ATOM    685  CA  GLU    42      -8.241 -15.144  -6.708  1.00  1.00          
ATOM    686  HA  GLU    42      -7.747 -16.091  -6.555  1.00  1.00          
ATOM    687  CB  GLU    42      -9.754 -15.348  -6.525  1.00  1.00          
ATOM    688  HB1 GLU    42     -10.174 -15.660  -7.470  1.00  1.00          
ATOM    689  HB2 GLU    42     -10.193 -14.399  -6.246  1.00  1.00          
ATOM    690  CG  GLU    42     -10.128 -16.400  -5.465  1.00  1.00          
ATOM    691  HG1 GLU    42     -11.041 -16.098  -4.963  1.00  1.00          
ATOM    692  HG2 GLU    42      -9.329 -16.457  -4.741  1.00  1.00          
ATOM    693  CD  GLU    42     -10.343 -17.788  -6.050  1.00  1.00          
ATOM    694  OE1 GLU    42     -11.404 -18.017  -6.671  1.00  1.00          
ATOM    695  OE2 GLU    42      -9.448 -18.645  -5.886  1.00  1.00          
ATOM    696  C   GLU    42      -7.966 -14.678  -8.166  1.00  1.00          
ATOM    697  O   GLU    42      -7.851 -15.532  -9.064  1.00  1.00          
ATOM    698  N   PHE    43      -7.863 -13.330  -8.362  1.00  1.00          
ATOM    699  HN  PHE    43      -7.937 -12.758  -7.569  1.00  1.00          
ATOM    700  CA  PHE    43      -7.604 -12.686  -9.673  1.00  1.00          
ATOM    701  HA  PHE    43      -7.862 -13.398 -10.445  1.00  1.00          
ATOM    702  CB  PHE    43      -8.487 -11.424  -9.835  1.00  1.00          
ATOM    703  HB1 PHE    43      -7.853 -10.550  -9.784  1.00  1.00          
ATOM    704  HB2 PHE    43      -9.194 -11.389  -9.022  1.00  1.00          
ATOM    705  CG  PHE    43      -9.276 -11.347 -11.127  1.00  1.00          
ATOM    706  CD1 PHE    43     -10.564 -11.868 -11.206  1.00  1.00          
ATOM    707  HD1 PHE    43     -10.997 -12.342 -10.337  1.00  1.00          
ATOM    708  CD2 PHE    43      -8.737 -10.740 -12.258  1.00  1.00          
ATOM    709  HD2 PHE    43      -7.740 -10.329 -12.214  1.00  1.00          
ATOM    710  CE1 PHE    43     -11.290 -11.788 -12.379  1.00  1.00          
ATOM    711  HE1 PHE    43     -12.288 -12.196 -12.425  1.00  1.00          
ATOM    712  CE2 PHE    43      -9.462 -10.660 -13.432  1.00  1.00          
ATOM    713  HE2 PHE    43      -9.031 -10.188 -14.303  1.00  1.00          
ATOM    714  CZ  PHE    43     -10.739 -11.184 -13.492  1.00  1.00          
ATOM    715  HZ  PHE    43     -11.306 -11.121 -14.409  1.00  1.00          
ATOM    716  C   PHE    43      -6.116 -12.316  -9.823  1.00  1.00          
ATOM    717  O   PHE    43      -5.436 -12.046  -8.809  1.00  1.00          
ATOM    718  N   VAL    44      -5.646 -12.290 -11.099  1.00  1.00          
ATOM    719  HN  VAL    44      -6.276 -12.457 -11.830  1.00  1.00          
ATOM    720  CA  VAL    44      -4.253 -11.972 -11.451  1.00  1.00          
ATOM    721  HA  VAL    44      -3.713 -11.937 -10.512  1.00  1.00          
ATOM    722  CB  VAL    44      -3.627 -13.177 -12.308  1.00  1.00          
ATOM    723  HB  VAL    44      -4.051 -14.083 -11.887  1.00  1.00          
ATOM    724  CG1 VAL    44      -3.969 -13.214 -13.814  1.00  1.00          
ATOM    725 HG11 VAL    44      -5.012 -12.979 -13.954  1.00  1.00          
ATOM    726 HG12 VAL    44      -3.761 -14.197 -14.212  1.00  1.00          
ATOM    727 HG13 VAL    44      -3.357 -12.481 -14.331  1.00  1.00          
ATOM    728  CG2 VAL    44      -2.115 -13.281 -12.114  1.00  1.00          
ATOM    729 HG21 VAL    44      -1.894 -13.608 -11.106  1.00  1.00          
ATOM    730 HG22 VAL    44      -1.667 -12.313 -12.281  1.00  1.00          
ATOM    731 HG23 VAL    44      -1.711 -13.991 -12.820  1.00  1.00          
ATOM    732  C   VAL    44      -4.173 -10.529 -12.072  1.00  1.00          
ATOM    733  O   VAL    44      -5.123 -10.090 -12.753  1.00  1.00          
ATOM    734  N   PHE    45      -3.024  -9.853 -11.825  1.00  1.00          
ATOM    735  HN  PHE    45      -2.310 -10.311 -11.336  1.00  1.00          
ATOM    736  CA  PHE    45      -2.760  -8.460 -12.291  1.00  1.00          
ATOM    737  HA  PHE    45      -3.609  -8.149 -12.882  1.00  1.00          
ATOM    738  CB  PHE    45      -2.596  -7.484 -11.088  1.00  1.00          
ATOM    739  HB1 PHE    45      -2.402  -6.494 -11.480  1.00  1.00          
ATOM    740  HB2 PHE    45      -1.745  -7.793 -10.507  1.00  1.00          
ATOM    741  CG  PHE    45      -3.782  -7.372 -10.139  1.00  1.00          
ATOM    742  CD1 PHE    45      -3.855  -8.180  -9.013  1.00  1.00          
ATOM    743  HD1 PHE    45      -3.068  -8.895  -8.822  1.00  1.00          
ATOM    744  CD2 PHE    45      -4.802  -6.457 -10.368  1.00  1.00          
ATOM    745  HD2 PHE    45      -4.759  -5.823 -11.241  1.00  1.00          
ATOM    746  CE1 PHE    45      -4.918  -8.079  -8.137  1.00  1.00          
ATOM    747  HE1 PHE    45      -4.959  -8.717  -7.266  1.00  1.00          
ATOM    748  CE2 PHE    45      -5.869  -6.355  -9.495  1.00  1.00          
ATOM    749  HE2 PHE    45      -6.657  -5.640  -9.685  1.00  1.00          
ATOM    750  CZ  PHE    45      -5.927  -7.166  -8.377  1.00  1.00          
ATOM    751  HZ  PHE    45      -6.758  -7.085  -7.691  1.00  1.00          
ATOM    752  C   PHE    45      -1.496  -8.411 -13.176  1.00  1.00          
ATOM    753  O   PHE    45      -0.585  -9.239 -13.001  1.00  1.00          
ATOM    754  N   LYS    46      -1.461  -7.419 -14.111  1.00  1.00          
ATOM    755  HN  LYS    46      -2.215  -6.796 -14.144  1.00  1.00          
ATOM    756  CA  LYS    46      -0.337  -7.215 -15.069  1.00  1.00          
ATOM    757  HA  LYS    46       0.244  -8.125 -15.090  1.00  1.00          
ATOM    758  CB  LYS    46      -0.874  -6.933 -16.487  1.00  1.00          
ATOM    759  HB1 LYS    46      -0.082  -6.487 -17.073  1.00  1.00          
ATOM    760  HB2 LYS    46      -1.688  -6.229 -16.413  1.00  1.00          
ATOM    761  CG  LYS    46      -1.381  -8.167 -17.233  1.00  1.00          
ATOM    762  HG1 LYS    46      -2.151  -8.641 -16.640  1.00  1.00          
ATOM    763  HG2 LYS    46      -0.560  -8.855 -17.375  1.00  1.00          
ATOM    764  CD  LYS    46      -1.959  -7.804 -18.591  1.00  1.00          
ATOM    765  HD1 LYS    46      -1.178  -7.371 -19.200  1.00  1.00          
ATOM    766  HD2 LYS    46      -2.751  -7.084 -18.453  1.00  1.00          
ATOM    767  CE  LYS    46      -2.519  -9.025 -19.303  1.00  1.00          
ATOM    768  HE1 LYS    46      -3.269  -9.481 -18.671  1.00  1.00          
ATOM    769  HE2 LYS    46      -1.717  -9.728 -19.471  1.00  1.00          
ATOM    770  NZ  LYS    46      -3.136  -8.676 -20.612  1.00  1.00          
ATOM    771  HZ1 LYS    46      -2.398  -8.563 -21.336  1.00  1.00          
ATOM    772  HZ2 LYS    46      -3.666  -7.785 -20.532  1.00  1.00          
ATOM    773  HZ3 LYS    46      -3.789  -9.428 -20.912  1.00  1.00          
ATOM    774  C   LYS    46       0.572  -6.065 -14.623  1.00  1.00          
ATOM    775  O   LYS    46       0.070  -5.042 -14.119  1.00  1.00          
ATOM    776  N   CYS    47       1.910  -6.257 -14.833  1.00  1.00          
ATOM    777  HN  CYS    47       2.196  -7.098 -15.249  1.00  1.00          
ATOM    778  CA  CYS    47       2.953  -5.266 -14.472  1.00  1.00          
ATOM    779  HA  CYS    47       2.533  -4.623 -13.712  1.00  1.00          
ATOM    780  HB1 CYS    47       4.711  -6.497 -14.684  1.00  1.00          
ATOM    781  HB2 CYS    47       3.904  -6.672 -13.134  1.00  1.00          
ATOM    782  C   CYS    47       3.345  -4.372 -15.704  1.00  1.00          
ATOM    783  O   CYS    47       3.766  -4.951 -16.732  1.00  1.00          
ATOM    784  CB  CYS    47       4.208  -5.966 -13.888  1.00  1.00          
ATOM    785  SG  CYS    47       5.427  -4.827 -13.126  1.00  1.00          
ATOM    786  N   PRO    48       3.164  -2.947 -15.672  1.00  1.00          
ATOM    787  CA  PRO    48       3.583  -2.056 -16.816  1.00  1.00          
ATOM    788  HA  PRO    48       3.246  -2.481 -17.754  1.00  1.00          
ATOM    789  CB  PRO    48       2.813  -0.732 -16.554  1.00  1.00          
ATOM    790  HB1 PRO    48       1.880  -0.736 -17.109  1.00  1.00          
ATOM    791  HB2 PRO    48       3.419   0.101 -16.888  1.00  1.00          
ATOM    792  CG  PRO    48       2.565  -0.676 -15.066  1.00  1.00          
ATOM    793  HG1 PRO    48       1.637  -0.148 -14.863  1.00  1.00          
ATOM    794  HG2 PRO    48       3.389  -0.167 -14.575  1.00  1.00          
ATOM    795  CD  PRO    48       2.475  -2.119 -14.597  1.00  1.00          
ATOM    796  HD1 PRO    48       1.438  -2.422 -14.504  1.00  1.00          
ATOM    797  HD2 PRO    48       2.978  -2.245 -13.647  1.00  1.00          
ATOM    798  C   PRO    48       5.134  -1.808 -16.941  1.00  1.00          
ATOM    799  O   PRO    48       5.580  -1.215 -17.942  1.00  1.00          
ATOM    800  N   VAL    49       5.914  -2.285 -15.914  1.00  1.00          
ATOM    801  HN  VAL    49       5.466  -2.773 -15.190  1.00  1.00          
ATOM    802  CA  VAL    49       7.410  -2.126 -15.828  1.00  1.00          
ATOM    803  HA  VAL    49       7.655  -1.220 -16.367  1.00  1.00          
ATOM    804  CB  VAL    49       7.997  -1.978 -14.329  1.00  1.00          
ATOM    805  HB  VAL    49       8.270  -2.973 -13.995  1.00  1.00          
ATOM    806  CG1 VAL    49       9.286  -1.133 -14.304  1.00  1.00          
ATOM    807 HG11 VAL    49       9.728  -1.179 -13.319  1.00  1.00          
ATOM    808 HG12 VAL    49       9.051  -0.107 -14.545  1.00  1.00          
ATOM    809 HG13 VAL    49       9.985  -1.521 -15.031  1.00  1.00          
ATOM    810  CG2 VAL    49       7.014  -1.365 -13.292  1.00  1.00          
ATOM    811 HG21 VAL    49       7.520  -0.592 -12.735  1.00  1.00          
ATOM    812 HG22 VAL    49       6.661  -2.128 -12.608  1.00  1.00          
ATOM    813 HG23 VAL    49       6.169  -0.937 -13.811  1.00  1.00          
ATOM    814  C   VAL    49       8.125  -3.313 -16.556  1.00  1.00          
ATOM    815  O   VAL    49       8.993  -3.056 -17.414  1.00  1.00          
ATOM    816  N   CYS    50       7.739  -4.573 -16.193  1.00  1.00          
ATOM    817  HN  CYS    50       7.043  -4.666 -15.510  1.00  1.00          
ATOM    818  CA  CYS    50       8.316  -5.799 -16.777  1.00  1.00          
ATOM    819  HA  CYS    50       9.232  -5.497 -17.267  1.00  1.00          
ATOM    820  HB1 CYS    50       9.375  -6.333 -15.000  1.00  1.00          
ATOM    821  HB2 CYS    50       9.172  -7.660 -16.127  1.00  1.00          
ATOM    822  C   CYS    50       7.403  -6.411 -17.860  1.00  1.00          
ATOM    823  O   CYS    50       7.904  -6.697 -18.965  1.00  1.00          
ATOM    824  CB  CYS    50       8.686  -6.811 -15.671  1.00  1.00          
ATOM    825  SG  CYS    50       7.291  -7.452 -14.676  1.00  1.00          
ATOM    826  N   GLY    51       6.086  -6.606 -17.531  1.00  1.00          
ATOM    827  HN  GLY    51       5.807  -6.447 -16.602  1.00  1.00          
ATOM    828  CA  GLY    51       5.095  -7.163 -18.482  1.00  1.00          
ATOM    829  HA1 GLY    51       5.587  -7.312 -19.433  1.00  1.00          
ATOM    830  HA2 GLY    51       4.309  -6.438 -18.617  1.00  1.00          
ATOM    831  C   GLY    51       4.452  -8.493 -18.053  1.00  1.00          
ATOM    832  O   GLY    51       3.428  -8.877 -18.644  1.00  1.00          
ATOM    833  N   GLU    52       5.054  -9.183 -17.026  1.00  1.00          
ATOM    834  HN  GLU    52       5.868  -8.795 -16.642  1.00  1.00          
ATOM    835  CA  GLU    52       4.571 -10.482 -16.473  1.00  1.00          
ATOM    836  HA  GLU    52       4.185 -11.058 -17.302  1.00  1.00          
ATOM    837  CB  GLU    52       5.752 -11.251 -15.856  1.00  1.00          
ATOM    838  HB1 GLU    52       5.394 -11.825 -15.014  1.00  1.00          
ATOM    839  HB2 GLU    52       6.489 -10.542 -15.511  1.00  1.00          
ATOM    840  CG  GLU    52       6.425 -12.204 -16.834  1.00  1.00          
ATOM    841  HG1 GLU    52       6.781 -11.636 -17.680  1.00  1.00          
ATOM    842  HG2 GLU    52       5.697 -12.928 -17.168  1.00  1.00          
ATOM    843  CD  GLU    52       7.596 -12.946 -16.222  1.00  1.00          
ATOM    844  OE1 GLU    52       8.722 -12.408 -16.254  1.00  1.00          
ATOM    845  OE2 GLU    52       7.387 -14.067 -15.710  1.00  1.00          
ATOM    846  C   GLU    52       3.428 -10.301 -15.440  1.00  1.00          
ATOM    847  O   GLU    52       3.339  -9.245 -14.787  1.00  1.00          
ATOM    848  N   GLU    53       2.574 -11.365 -15.317  1.00  1.00          
ATOM    849  HN  GLU    53       2.767 -12.169 -15.843  1.00  1.00          
ATOM    850  CA  GLU    53       1.381 -11.411 -14.420  1.00  1.00          
ATOM    851  HA  GLU    53       0.974 -10.414 -14.346  1.00  1.00          
ATOM    852  CB  GLU    53       0.304 -12.324 -15.040  1.00  1.00          
ATOM    853  HB1 GLU    53      -0.391 -12.615 -14.270  1.00  1.00          
ATOM    854  HB2 GLU    53       0.784 -13.211 -15.429  1.00  1.00          
ATOM    855  CG  GLU    53      -0.490 -11.674 -16.179  1.00  1.00          
ATOM    856  HG1 GLU    53       0.205 -11.287 -16.910  1.00  1.00          
ATOM    857  HG2 GLU    53      -1.072 -10.861 -15.773  1.00  1.00          
ATOM    858  CD  GLU    53      -1.434 -12.638 -16.870  1.00  1.00          
ATOM    859  OE1 GLU    53      -0.962 -13.427 -17.715  1.00  1.00          
ATOM    860  OE2 GLU    53      -2.647 -12.589 -16.586  1.00  1.00          
ATOM    861  C   GLU    53       1.742 -11.898 -13.004  1.00  1.00          
ATOM    862  O   GLU    53       2.536 -12.846 -12.861  1.00  1.00          
ATOM    863  N   PHE    54       1.139 -11.222 -11.991  1.00  1.00          
ATOM    864  HN  PHE    54       0.487 -10.527 -12.219  1.00  1.00          
ATOM    865  CA  PHE    54       1.337 -11.502 -10.546  1.00  1.00          
ATOM    866  HA  PHE    54       1.840 -12.458 -10.483  1.00  1.00          
ATOM    867  CB  PHE    54       2.251 -10.415  -9.864  1.00  1.00          
ATOM    868  HB1 PHE    54       3.228 -10.459 -10.326  1.00  1.00          
ATOM    869  HB2 PHE    54       2.361 -10.669  -8.822  1.00  1.00          
ATOM    870  CG  PHE    54       1.785  -8.954  -9.918  1.00  1.00          
ATOM    871  CD1 PHE    54       0.995  -8.436  -8.904  1.00  1.00          
ATOM    872  HD1 PHE    54       0.722  -9.067  -8.071  1.00  1.00          
ATOM    873  CD2 PHE    54       2.129  -8.132 -10.980  1.00  1.00          
ATOM    874  HD2 PHE    54       2.747  -8.523 -11.775  1.00  1.00          
ATOM    875  CE1 PHE    54       0.556  -7.126  -8.947  1.00  1.00          
ATOM    876  HE1 PHE    54      -0.059  -6.735  -8.150  1.00  1.00          
ATOM    877  CE2 PHE    54       1.694  -6.820 -11.026  1.00  1.00          
ATOM    878  HE2 PHE    54       1.965  -6.188 -11.856  1.00  1.00          
ATOM    879  CZ  PHE    54       0.905  -6.318 -10.009  1.00  1.00          
ATOM    880  HZ  PHE    54       0.563  -5.295 -10.046  1.00  1.00          
ATOM    881  C   PHE    54      -0.034 -11.653  -9.849  1.00  1.00          
ATOM    882  O   PHE    54      -0.969 -10.889 -10.162  1.00  1.00          
ATOM    883  N   TYR    55      -0.119 -12.615  -8.898  1.00  1.00          
ATOM    884  HN  TYR    55       0.686 -13.125  -8.672  1.00  1.00          
ATOM    885  CA  TYR    55      -1.363 -12.935  -8.148  1.00  1.00          
ATOM    886  HA  TYR    55      -2.197 -12.602  -8.746  1.00  1.00          
ATOM    887  CB  TYR    55      -1.477 -14.469  -7.949  1.00  1.00          
ATOM    888  HB1 TYR    55      -2.236 -14.667  -7.207  1.00  1.00          
ATOM    889  HB2 TYR    55      -0.532 -14.841  -7.584  1.00  1.00          
ATOM    890  CG  TYR    55      -1.827 -15.271  -9.202  1.00  1.00          
ATOM    891  CD1 TYR    55      -0.826 -15.803 -10.011  1.00  1.00          
ATOM    892  HD1 TYR    55       0.206 -15.632  -9.747  1.00  1.00          
ATOM    893  CD2 TYR    55      -3.152 -15.506  -9.566  1.00  1.00          
ATOM    894  HD2 TYR    55      -3.945 -15.100  -8.957  1.00  1.00          
ATOM    895  CE1 TYR    55      -1.135 -16.542 -11.138  1.00  1.00          
ATOM    896  HE1 TYR    55      -0.342 -16.947 -11.751  1.00  1.00          
ATOM    897  CE2 TYR    55      -3.465 -16.242 -10.694  1.00  1.00          
ATOM    898  HE2 TYR    55      -4.498 -16.413 -10.957  1.00  1.00          
ATOM    899  CZ  TYR    55      -2.453 -16.758 -11.475  1.00  1.00          
ATOM    900  OH  TYR    55      -2.762 -17.493 -12.597  1.00  1.00          
ATOM    901  HH  TYR    55      -3.405 -18.168 -12.371  1.00  1.00          
ATOM    902  C   TYR    55      -1.424 -12.224  -6.782  1.00  1.00          
ATOM    903  O   TYR    55      -0.370 -11.935  -6.183  1.00  1.00          
ATOM    904  N   GLY    56      -2.689 -11.949  -6.310  1.00  1.00          
ATOM    905  HN  GLY    56      -3.450 -12.205  -6.872  1.00  1.00          
ATOM    906  CA  GLY    56      -2.969 -11.294  -4.993  1.00  1.00          
ATOM    907  HA1 GLY    56      -3.977 -10.905  -5.012  1.00  1.00          
ATOM    908  HA2 GLY    56      -2.288 -10.464  -4.875  1.00  1.00          
ATOM    909  C   GLY    56      -2.816 -12.227  -3.760  1.00  1.00          
ATOM    910  O   GLY    56      -2.881 -11.750  -2.615  1.00  1.00          
ATOM    911  N   LYS    57      -2.617 -13.552  -4.048  1.00  1.00          
ATOM    912  HN  LYS    57      -2.606 -13.783  -5.000  1.00  1.00          
ATOM    913  CA  LYS    57      -2.389 -14.631  -3.044  1.00  1.00          
ATOM    914  HA  LYS    57      -2.947 -14.368  -2.158  1.00  1.00          
ATOM    915  CB  LYS    57      -2.919 -15.974  -3.588  1.00  1.00          
ATOM    916  HB1 LYS    57      -2.089 -16.532  -3.999  1.00  1.00          
ATOM    917  HB2 LYS    57      -3.626 -15.772  -4.378  1.00  1.00          
ATOM    918  CG  LYS    57      -3.613 -16.853  -2.543  1.00  1.00          
ATOM    919  HG1 LYS    57      -4.380 -16.276  -2.050  1.00  1.00          
ATOM    920  HG2 LYS    57      -2.882 -17.174  -1.816  1.00  1.00          
ATOM    921  CD  LYS    57      -4.252 -18.086  -3.178  1.00  1.00          
ATOM    922  HD1 LYS    57      -3.482 -18.648  -3.689  1.00  1.00          
ATOM    923  HD2 LYS    57      -4.994 -17.762  -3.892  1.00  1.00          
ATOM    924  CE  LYS    57      -4.928 -18.985  -2.136  1.00  1.00          
ATOM    925  HE1 LYS    57      -4.326 -18.991  -1.240  1.00  1.00          
ATOM    926  HE2 LYS    57      -4.997 -19.992  -2.525  1.00  1.00          
ATOM    927  NZ  LYS    57      -6.303 -18.515  -1.790  1.00  1.00          
ATOM    928  HZ1 LYS    57      -6.733 -19.150  -1.086  1.00  1.00          
ATOM    929  HZ2 LYS    57      -6.901 -18.503  -2.640  1.00  1.00          
ATOM    930  HZ3 LYS    57      -6.264 -17.553  -1.395  1.00  1.00          
ATOM    931  C   LYS    57      -0.874 -14.755  -2.662  1.00  1.00          
ATOM    932  O   LYS    57      -0.554 -15.326  -1.604  1.00  1.00          
ATOM    933  N   THR    58       0.013 -14.210  -3.547  1.00  1.00          
ATOM    934  HN  THR    58      -0.349 -13.780  -4.350  1.00  1.00          
ATOM    935  CA  THR    58       1.493 -14.204  -3.378  1.00  1.00          
ATOM    936  HA  THR    58       1.736 -14.989  -2.675  1.00  1.00          
ATOM    937  CB  THR    58       2.235 -14.516  -4.729  1.00  1.00          
ATOM    938  HB  THR    58       3.276 -14.255  -4.602  1.00  1.00          
ATOM    939  OG1 THR    58       1.700 -13.726  -5.798  1.00  1.00          
ATOM    940  HG1 THR    58       0.791 -13.491  -5.598  1.00  1.00          
ATOM    941  CG2 THR    58       2.157 -15.999  -5.108  1.00  1.00          
ATOM    942 HG21 THR    58       2.463 -16.606  -4.270  1.00  1.00          
ATOM    943 HG22 THR    58       2.810 -16.189  -5.947  1.00  1.00          
ATOM    944 HG23 THR    58       1.138 -16.245  -5.381  1.00  1.00          
ATOM    945  C   THR    58       2.013 -12.847  -2.784  1.00  1.00          
ATOM    946  O   THR    58       3.244 -12.651  -2.648  1.00  1.00          
ATOM    947  N   LEU    59       1.051 -11.941  -2.376  1.00  1.00          
ATOM    948  HN  LEU    59       0.111 -12.217  -2.445  1.00  1.00          
ATOM    949  CA  LEU    59       1.347 -10.603  -1.784  1.00  1.00          
ATOM    950  HA  LEU    59       2.256 -10.253  -2.244  1.00  1.00          
ATOM    951  CB  LEU    59       0.194  -9.605  -2.082  1.00  1.00          
ATOM    952  HB1 LEU    59      -0.209  -9.264  -1.136  1.00  1.00          
ATOM    953  HB2 LEU    59      -0.585 -10.141  -2.603  1.00  1.00          
ATOM    954  CG  LEU    59       0.539  -8.353  -2.918  1.00  1.00          
ATOM    955  HG  LEU    59       1.597  -8.149  -2.859  1.00  1.00          
ATOM    956  CD1 LEU    59       0.179  -8.558  -4.386  1.00  1.00          
ATOM    957 HD11 LEU    59       0.648  -7.790  -4.982  1.00  1.00          
ATOM    958 HD12 LEU    59      -0.893  -8.502  -4.506  1.00  1.00          
ATOM    959 HD13 LEU    59       0.528  -9.529  -4.710  1.00  1.00          
ATOM    960  CD2 LEU    59      -0.199  -7.140  -2.364  1.00  1.00          
ATOM    961 HD21 LEU    59      -0.085  -6.307  -3.043  1.00  1.00          
ATOM    962 HD22 LEU    59       0.213  -6.878  -1.401  1.00  1.00          
ATOM    963 HD23 LEU    59      -1.248  -7.374  -2.255  1.00  1.00          
ATOM    964  C   LEU    59       1.576 -10.701  -0.224  1.00  1.00          
ATOM    965  O   LEU    59       1.091 -11.689   0.366  1.00  1.00          
ATOM    966  N   PRO    60       2.291  -9.689   0.512  1.00  1.00          
ATOM    967  CA  PRO    60       2.542  -9.770   2.005  1.00  1.00          
ATOM    968  HA  PRO    60       3.000 -10.718   2.259  1.00  1.00          
ATOM    969  CB  PRO    60       3.541  -8.618   2.284  1.00  1.00          
ATOM    970  HB1 PRO    60       4.331  -8.957   2.948  1.00  1.00          
ATOM    971  HB2 PRO    60       3.013  -7.795   2.748  1.00  1.00          
ATOM    972  CG  PRO    60       4.076  -8.238   0.941  1.00  1.00          
ATOM    973  HG1 PRO    60       4.889  -8.898   0.663  1.00  1.00          
ATOM    974  HG2 PRO    60       4.412  -7.208   0.945  1.00  1.00          
ATOM    975  CD  PRO    60       2.916  -8.416   0.005  1.00  1.00          
ATOM    976  HD1 PRO    60       3.258  -8.528  -1.012  1.00  1.00          
ATOM    977  HD2 PRO    60       2.228  -7.584   0.088  1.00  1.00          
ATOM    978  C   PRO    60       1.277  -9.594   2.870  1.00  1.00          
ATOM    979  O   PRO    60       0.309  -8.953   2.429  1.00  1.00          
ATOM    980  N   ARG    61       1.326 -10.175   4.109  1.00  1.00          
ATOM    981  HN  ARG    61       2.150 -10.644   4.354  1.00  1.00          
ATOM    982  CA  ARG    61       0.215 -10.152   5.121  1.00  1.00          
ATOM    983  HA  ARG    61      -0.676 -10.465   4.596  1.00  1.00          
ATOM    984  CB  ARG    61       0.482 -11.181   6.232  1.00  1.00          
ATOM    985  HB1 ARG    61      -0.032 -10.867   7.128  1.00  1.00          
ATOM    986  HB2 ARG    61       1.544 -11.214   6.428  1.00  1.00          
ATOM    987  CG  ARG    61       0.014 -12.587   5.877  1.00  1.00          
ATOM    988  HG1 ARG    61       0.531 -12.912   4.985  1.00  1.00          
ATOM    989  HG2 ARG    61      -1.048 -12.565   5.687  1.00  1.00          
ATOM    990  CD  ARG    61       0.286 -13.582   6.994  1.00  1.00          
ATOM    991  HD1 ARG    61      -0.206 -13.242   7.892  1.00  1.00          
ATOM    992  HD2 ARG    61       1.352 -13.636   7.163  1.00  1.00          
ATOM    993  NE  ARG    61      -0.219 -14.938   6.652  1.00  1.00          
ATOM    994  HE  ARG    61      -0.687 -15.011   5.795  1.00  1.00          
ATOM    995  CZ  ARG    61      -0.105 -16.080   7.398  1.00  1.00          
ATOM    996  NH1 ARG    61       0.508 -16.135   8.596  1.00  1.00          
ATOM    997 HH11 ARG    61       0.912 -15.309   8.988  1.00  1.00          
ATOM    998 HH12 ARG    61       0.558 -17.001   9.092  1.00  1.00          
ATOM    999  NH2 ARG    61      -0.629 -17.199   6.917  1.00  1.00          
ATOM   1000 HH21 ARG    61      -1.095 -17.194   6.032  1.00  1.00          
ATOM   1001 HH22 ARG    61      -0.562 -18.048   7.442  1.00  1.00          
ATOM   1002  C   ARG    61      -0.090  -8.754   5.739  1.00  1.00          
ATOM   1003  O   ARG    61      -1.190  -8.561   6.297  1.00  1.00          
ATOM   1004  N   ARG    62       0.883  -7.787   5.613  1.00  1.00          
ATOM   1005  HN  ARG    62       1.677  -7.969   5.070  1.00  1.00          
ATOM   1006  CA  ARG    62       0.757  -6.390   6.122  1.00  1.00          
ATOM   1007  HA  ARG    62       0.193  -6.431   7.042  1.00  1.00          
ATOM   1008  CB  ARG    62       2.140  -5.819   6.419  1.00  1.00          
ATOM   1009  HB1 ARG    62       2.128  -4.758   6.227  1.00  1.00          
ATOM   1010  HB2 ARG    62       2.860  -6.289   5.765  1.00  1.00          
ATOM   1011  CG  ARG    62       2.583  -6.042   7.863  1.00  1.00          
ATOM   1012  HG1 ARG    62       2.496  -7.095   8.091  1.00  1.00          
ATOM   1013  HG2 ARG    62       1.927  -5.480   8.515  1.00  1.00          
ATOM   1014  CD  ARG    62       4.030  -5.600   8.114  1.00  1.00          
ATOM   1015  HD1 ARG    62       4.186  -5.502   9.181  1.00  1.00          
ATOM   1016  HD2 ARG    62       4.183  -4.639   7.644  1.00  1.00          
ATOM   1017  NE  ARG    62       5.037  -6.563   7.573  1.00  1.00          
ATOM   1018  HE  ARG    62       4.687  -7.438   7.301  1.00  1.00          
ATOM   1019  CZ  ARG    62       6.378  -6.352   7.404  1.00  1.00          
ATOM   1020  NH1 ARG    62       7.002  -5.209   7.753  1.00  1.00          
ATOM   1021 HH11 ARG    62       6.480  -4.459   8.159  1.00  1.00          
ATOM   1022 HH12 ARG    62       7.986  -5.112   7.606  1.00  1.00          
ATOM   1023  NH2 ARG    62       7.109  -7.325   6.880  1.00  1.00          
ATOM   1024 HH21 ARG    62       6.677  -8.189   6.618  1.00  1.00          
ATOM   1025 HH22 ARG    62       8.091  -7.197   6.744  1.00  1.00          
ATOM   1026  C   ARG    62      -0.001  -5.469   5.128  1.00  1.00          
ATOM   1027  O   ARG    62      -0.718  -4.554   5.566  1.00  1.00          
ATOM   1028  N   GLU    63       0.185  -5.737   3.781  1.00  1.00          
ATOM   1029  HN  GLU    63       0.812  -6.451   3.540  1.00  1.00          
ATOM   1030  CA  GLU    63      -0.483  -5.013   2.644  1.00  1.00          
ATOM   1031  HA  GLU    63      -0.363  -3.958   2.832  1.00  1.00          
ATOM   1032  CB  GLU    63       0.205  -5.347   1.315  1.00  1.00          
ATOM   1033  HB1 GLU    63      -0.504  -5.212   0.514  1.00  1.00          
ATOM   1034  HB2 GLU    63       0.520  -6.379   1.336  1.00  1.00          
ATOM   1035  CG  GLU    63       1.430  -4.481   1.023  1.00  1.00          
ATOM   1036  HG1 GLU    63       2.159  -4.643   1.802  1.00  1.00          
ATOM   1037  HG2 GLU    63       1.126  -3.445   1.029  1.00  1.00          
ATOM   1038  CD  GLU    63       2.082  -4.780  -0.322  1.00  1.00          
ATOM   1039  OE1 GLU    63       3.211  -5.309  -0.323  1.00  1.00          
ATOM   1040  OE2 GLU    63       1.478  -4.459  -1.374  1.00  1.00          
ATOM   1041  C   GLU    63      -2.004  -5.306   2.532  1.00  1.00          
ATOM   1042  O   GLU    63      -2.757  -4.448   2.046  1.00  1.00          
ATOM   1043  N   ALA    64      -2.424  -6.543   2.991  1.00  1.00          
ATOM   1044  HN  ALA    64      -1.733  -7.165   3.292  1.00  1.00          
ATOM   1045  CA  ALA    64      -3.851  -7.021   3.050  1.00  1.00          
ATOM   1046  HA  ALA    64      -4.267  -6.928   2.057  1.00  1.00          
ATOM   1047  CB  ALA    64      -3.891  -8.493   3.436  1.00  1.00          
ATOM   1048  HB1 ALA    64      -4.908  -8.853   3.373  1.00  1.00          
ATOM   1049  HB2 ALA    64      -3.528  -8.612   4.446  1.00  1.00          
ATOM   1050  HB3 ALA    64      -3.268  -9.059   2.760  1.00  1.00          
ATOM   1051  C   ALA    64      -4.728  -6.188   4.032  1.00  1.00          
ATOM   1052  O   ALA    64      -5.934  -6.023   3.800  1.00  1.00          
ATOM   1053  N   GLU    65      -4.064  -5.680   5.132  1.00  1.00          
ATOM   1054  HN  GLU    65      -3.124  -5.930   5.241  1.00  1.00          
ATOM   1055  CA  GLU    65      -4.661  -4.777   6.179  1.00  1.00          
ATOM   1056  HA  GLU    65      -5.616  -5.197   6.458  1.00  1.00          
ATOM   1057  CB  GLU    65      -3.764  -4.716   7.427  1.00  1.00          
ATOM   1058  HB1 GLU    65      -4.016  -3.828   7.989  1.00  1.00          
ATOM   1059  HB2 GLU    65      -2.735  -4.649   7.110  1.00  1.00          
ATOM   1060  CG  GLU    65      -3.898  -5.921   8.355  1.00  1.00          
ATOM   1061  HG1 GLU    65      -3.647  -6.815   7.801  1.00  1.00          
ATOM   1062  HG2 GLU    65      -4.921  -5.986   8.695  1.00  1.00          
ATOM   1063  CD  GLU    65      -2.989  -5.830   9.566  1.00  1.00          
ATOM   1064  OE1 GLU    65      -1.820  -6.254   9.463  1.00  1.00          
ATOM   1065  OE2 GLU    65      -3.448  -5.334  10.617  1.00  1.00          
ATOM   1066  C   GLU    65      -4.904  -3.336   5.637  1.00  1.00          
ATOM   1067  O   GLU    65      -5.807  -2.638   6.122  1.00  1.00          
ATOM   1068  N   LYS    66      -4.061  -2.925   4.618  1.00  1.00          
ATOM   1069  HN  LYS    66      -3.348  -3.544   4.353  1.00  1.00          
ATOM   1070  CA  LYS    66      -4.141  -1.614   3.877  1.00  1.00          
ATOM   1071  HA  LYS    66      -4.193  -0.833   4.622  1.00  1.00          
ATOM   1072  CB  LYS    66      -2.892  -1.379   3.008  1.00  1.00          
ATOM   1073  HB1 LYS    66      -3.119  -0.611   2.282  1.00  1.00          
ATOM   1074  HB2 LYS    66      -2.660  -2.293   2.484  1.00  1.00          
ATOM   1075  CG  LYS    66      -1.646  -0.949   3.780  1.00  1.00          
ATOM   1076  HG1 LYS    66      -1.381  -1.727   4.480  1.00  1.00          
ATOM   1077  HG2 LYS    66      -1.860  -0.036   4.316  1.00  1.00          
ATOM   1078  CD  LYS    66      -0.473  -0.706   2.844  1.00  1.00          
ATOM   1079  HD1 LYS    66      -0.743   0.062   2.135  1.00  1.00          
ATOM   1080  HD2 LYS    66      -0.248  -1.620   2.318  1.00  1.00          
ATOM   1081  CE  LYS    66       0.761  -0.260   3.609  1.00  1.00          
ATOM   1082  HE1 LYS    66       1.028  -1.032   4.317  1.00  1.00          
ATOM   1083  HE2 LYS    66       0.530   0.650   4.140  1.00  1.00          
ATOM   1084  NZ  LYS    66       1.917  -0.012   2.706  1.00  1.00          
ATOM   1085  HZ1 LYS    66       2.282   0.951   2.850  1.00  1.00          
ATOM   1086  HZ2 LYS    66       1.625  -0.116   1.714  1.00  1.00          
ATOM   1087  HZ3 LYS    66       2.677  -0.693   2.905  1.00  1.00          
ATOM   1088  C   LYS    66      -5.405  -1.510   2.980  1.00  1.00          
ATOM   1089  O   LYS    66      -5.903  -0.399   2.742  1.00  1.00          
ATOM   1090  N   VAL    67      -5.900  -2.708   2.492  1.00  1.00          
ATOM   1091  HN  VAL    67      -5.401  -3.522   2.717  1.00  1.00          
ATOM   1092  CA  VAL    67      -7.146  -2.879   1.637  1.00  1.00          
ATOM   1093  HA  VAL    67      -7.070  -2.150   0.837  1.00  1.00          
ATOM   1094  CB  VAL    67      -7.300  -4.336   0.963  1.00  1.00          
ATOM   1095  HB  VAL    67      -7.701  -5.001   1.715  1.00  1.00          
ATOM   1096  CG1 VAL    67      -8.282  -4.338  -0.231  1.00  1.00          
ATOM   1097 HG11 VAL    67      -9.277  -4.113   0.123  1.00  1.00          
ATOM   1098 HG12 VAL    67      -8.276  -5.309  -0.702  1.00  1.00          
ATOM   1099 HG13 VAL    67      -7.977  -3.587  -0.947  1.00  1.00          
ATOM   1100  CG2 VAL    67      -5.971  -4.936   0.462  1.00  1.00          
ATOM   1101 HG21 VAL    67      -5.627  -4.378  -0.397  1.00  1.00          
ATOM   1102 HG22 VAL    67      -6.123  -5.968   0.185  1.00  1.00          
ATOM   1103 HG23 VAL    67      -5.232  -4.879   1.248  1.00  1.00          
ATOM   1104  C   VAL    67      -8.421  -2.511   2.492  1.00  1.00          
ATOM   1105  O   VAL    67      -9.346  -1.894   1.965  1.00  1.00          
ATOM   1106  N   PHE    68      -8.439  -2.927   3.807  1.00  1.00          
ATOM   1107  HN  PHE    68      -7.742  -3.540   4.124  1.00  1.00          
ATOM   1108  CA  PHE    68      -9.503  -2.592   4.824  1.00  1.00          
ATOM   1109  HA  PHE    68     -10.443  -3.012   4.483  1.00  1.00          
ATOM   1110  CB  PHE    68      -9.123  -3.235   6.174  1.00  1.00          
ATOM   1111  HB1 PHE    68      -9.193  -2.480   6.944  1.00  1.00          
ATOM   1112  HB2 PHE    68      -8.101  -3.576   6.116  1.00  1.00          
ATOM   1113  CG  PHE    68      -9.968  -4.414   6.608  1.00  1.00          
ATOM   1114  CD1 PHE    68      -9.597  -5.713   6.280  1.00  1.00          
ATOM   1115  HD1 PHE    68      -8.704  -5.875   5.696  1.00  1.00          
ATOM   1116  CD2 PHE    68     -11.119  -4.226   7.366  1.00  1.00          
ATOM   1117  HD2 PHE    68     -11.420  -3.224   7.631  1.00  1.00          
ATOM   1118  CE1 PHE    68     -10.354  -6.794   6.695  1.00  1.00          
ATOM   1119  HE1 PHE    68     -10.053  -7.798   6.434  1.00  1.00          
ATOM   1120  CE2 PHE    68     -11.878  -5.303   7.780  1.00  1.00          
ATOM   1121  HE2 PHE    68     -12.771  -5.141   8.365  1.00  1.00          
ATOM   1122  CZ  PHE    68     -11.496  -6.588   7.445  1.00  1.00          
ATOM   1123  HZ  PHE    68     -12.089  -7.430   7.769  1.00  1.00          
ATOM   1124  C   PHE    68      -9.679  -1.054   5.056  1.00  1.00          
ATOM   1125  O   PHE    68     -10.775  -0.605   5.420  1.00  1.00          
ATOM   1126  N   GLU    69      -8.551  -0.285   4.832  1.00  1.00          
ATOM   1127  HN  GLU    69      -7.763  -0.745   4.481  1.00  1.00          
ATOM   1128  CA  GLU    69      -8.443   1.192   5.008  1.00  1.00          
ATOM   1129  HA  GLU    69      -8.881   1.428   5.967  1.00  1.00          
ATOM   1130  CB  GLU    69      -6.947   1.586   5.046  1.00  1.00          
ATOM   1131  HB1 GLU    69      -6.628   1.823   4.042  1.00  1.00          
ATOM   1132  HB2 GLU    69      -6.379   0.739   5.399  1.00  1.00          
ATOM   1133  CG  GLU    69      -6.622   2.781   5.946  1.00  1.00          
ATOM   1134  HG1 GLU    69      -6.989   2.573   6.940  1.00  1.00          
ATOM   1135  HG2 GLU    69      -7.132   3.648   5.551  1.00  1.00          
ATOM   1136  CD  GLU    69      -5.134   3.083   6.022  1.00  1.00          
ATOM   1137  OE1 GLU    69      -4.595   3.674   5.062  1.00  1.00          
ATOM   1138  OE2 GLU    69      -4.509   2.732   7.046  1.00  1.00          
ATOM   1139  C   GLU    69      -9.214   1.994   3.916  1.00  1.00          
ATOM   1140  O   GLU    69      -9.885   2.978   4.264  1.00  1.00          
ATOM   1141  N   LEU    70      -9.110   1.556   2.607  1.00  1.00          
ATOM   1142  HN  LEU    70      -8.516   0.805   2.412  1.00  1.00          
ATOM   1143  CA  LEU    70      -9.829   2.185   1.439  1.00  1.00          
ATOM   1144  HA  LEU    70      -9.645   3.250   1.524  1.00  1.00          
ATOM   1145  CB  LEU    70      -9.287   1.700   0.048  1.00  1.00          
ATOM   1146  HB1 LEU    70      -8.383   2.242  -0.168  1.00  1.00          
ATOM   1147  HB2 LEU    70     -10.013   1.983  -0.674  1.00  1.00          
ATOM   1148  CG  LEU    70      -8.996   0.195  -0.186  1.00  1.00          
ATOM   1149  HG  LEU    70      -8.749  -0.268   0.759  1.00  1.00          
ATOM   1150  CD1 LEU    70     -10.218  -0.516  -0.756  1.00  1.00          
ATOM   1151 HD11 LEU    70     -10.060  -1.586  -0.739  1.00  1.00          
ATOM   1152 HD12 LEU    70     -10.377  -0.191  -1.773  1.00  1.00          
ATOM   1153 HD13 LEU    70     -11.085  -0.270  -0.160  1.00  1.00          
ATOM   1154  CD2 LEU    70      -7.806   0.024  -1.121  1.00  1.00          
ATOM   1155 HD21 LEU    70      -7.757  -1.002  -1.460  1.00  1.00          
ATOM   1156 HD22 LEU    70      -6.895   0.273  -0.598  1.00  1.00          
ATOM   1157 HD23 LEU    70      -7.922   0.677  -1.972  1.00  1.00          
ATOM   1158  C   LEU    70     -11.373   1.987   1.512  1.00  1.00          
ATOM   1159  O   LEU    70     -12.134   2.895   1.140  1.00  1.00          
ATOM   1160  N   LEU    71     -11.784   0.771   2.002  1.00  1.00          
ATOM   1161  HN  LEU    71     -11.086   0.116   2.213  1.00  1.00          
ATOM   1162  CA  LEU    71     -13.199   0.356   2.240  1.00  1.00          
ATOM   1163  HA  LEU    71     -13.763   0.606   1.357  1.00  1.00          
ATOM   1164  CB  LEU    71     -13.260  -1.167   2.456  1.00  1.00          
ATOM   1165  HB1 LEU    71     -14.146  -1.382   3.034  1.00  1.00          
ATOM   1166  HB2 LEU    71     -12.397  -1.456   3.040  1.00  1.00          
ATOM   1167  CG  LEU    71     -13.288  -2.029   1.183  1.00  1.00          
ATOM   1168  HG  LEU    71     -13.164  -1.397   0.318  1.00  1.00          
ATOM   1169  CD1 LEU    71     -12.147  -3.033   1.182  1.00  1.00          
ATOM   1170 HD11 LEU    71     -11.205  -2.503   1.168  1.00  1.00          
ATOM   1171 HD12 LEU    71     -12.220  -3.658   0.306  1.00  1.00          
ATOM   1172 HD13 LEU    71     -12.198  -3.644   2.067  1.00  1.00          
ATOM   1173  CD2 LEU    71     -14.623  -2.746   1.055  1.00  1.00          
ATOM   1174 HD21 LEU    71     -14.602  -3.393   0.190  1.00  1.00          
ATOM   1175 HD22 LEU    71     -15.409  -2.015   0.936  1.00  1.00          
ATOM   1176 HD23 LEU    71     -14.814  -3.335   1.940  1.00  1.00          
ATOM   1177  C   LEU    71     -13.856   1.087   3.457  1.00  1.00          
ATOM   1178  O   LEU    71     -15.050   1.425   3.397  1.00  1.00          
ATOM   1179  N   ASN    72     -13.034   1.313   4.541  1.00  1.00          
ATOM   1180  HN  ASN    72     -12.098   1.021   4.473  1.00  1.00          
ATOM   1181  CA  ASN    72     -13.440   1.994   5.806  1.00  1.00          
ATOM   1182  HA  ASN    72     -14.442   1.664   6.041  1.00  1.00          
ATOM   1183  CB  ASN    72     -12.512   1.554   6.941  1.00  1.00          
ATOM   1184  HB1 ASN    72     -12.456   2.341   7.678  1.00  1.00          
ATOM   1185  HB2 ASN    72     -11.526   1.373   6.539  1.00  1.00          
ATOM   1186  CG  ASN    72     -12.988   0.287   7.626  1.00  1.00          
ATOM   1187  OD1 ASN    72     -12.934  -0.803   7.055  1.00  1.00          
ATOM   1188  ND2 ASN    72     -13.458   0.424   8.859  1.00  1.00          
ATOM   1189 HD21 ASN    72     -13.474   1.322   9.251  1.00  1.00          
ATOM   1190 HD22 ASN    72     -13.769  -0.379   9.327  1.00  1.00          
ATOM   1191  C   ASN    72     -13.448   3.544   5.718  1.00  1.00          
ATOM   1192  O   ASN    72     -14.280   4.182   6.390  1.00  1.00          
ATOM   1193  N   ASP    73     -12.524   4.111   4.883  1.00  1.00          
ATOM   1194  HN  ASP    73     -11.957   3.514   4.357  1.00  1.00          
ATOM   1195  CA  ASP    73     -12.367   5.571   4.687  1.00  1.00          
ATOM   1196  HA  ASP    73     -12.853   6.050   5.527  1.00  1.00          
ATOM   1197  CB  ASP    73     -10.859   5.931   4.724  1.00  1.00          
ATOM   1198  HB1 ASP    73     -10.475   5.915   3.716  1.00  1.00          
ATOM   1199  HB2 ASP    73     -10.336   5.195   5.314  1.00  1.00          
ATOM   1200  CG  ASP    73     -10.590   7.305   5.323  1.00  1.00          
ATOM   1201  OD1 ASP    73     -10.854   8.315   4.635  1.00  1.00          
ATOM   1202  OD2 ASP    73     -10.116   7.368   6.477  1.00  1.00          
ATOM   1203  C   ASP    73     -13.099   6.036   3.387  1.00  1.00          
ATOM   1204  O   ASP    73     -12.512   6.625   2.440  1.00  1.00          
ATOM   1205  N   PHE    74     -14.424   5.737   3.388  1.00  1.00          
ATOM   1206  HN  PHE    74     -14.759   5.233   4.154  1.00  1.00          
ATOM   1207  CA  PHE    74     -15.377   6.081   2.304  1.00  1.00          
ATOM   1208  HA  PHE    74     -14.812   6.156   1.388  1.00  1.00          
ATOM   1209  CB  PHE    74     -16.431   4.965   2.145  1.00  1.00          
ATOM   1210  HB1 PHE    74     -17.407   5.374   2.368  1.00  1.00          
ATOM   1211  HB2 PHE    74     -16.214   4.177   2.849  1.00  1.00          
ATOM   1212  CG  PHE    74     -16.497   4.340   0.761  1.00  1.00          
ATOM   1213  CD1 PHE    74     -15.668   3.275   0.408  1.00  1.00          
ATOM   1214  HD1 PHE    74     -14.959   2.895   1.129  1.00  1.00          
ATOM   1215  CD2 PHE    74     -17.401   4.812  -0.184  1.00  1.00          
ATOM   1216  HD2 PHE    74     -18.053   5.635   0.071  1.00  1.00          
ATOM   1217  CE1 PHE    74     -15.740   2.707  -0.849  1.00  1.00          
ATOM   1218  HE1 PHE    74     -15.090   1.884  -1.108  1.00  1.00          
ATOM   1219  CE2 PHE    74     -17.473   4.245  -1.443  1.00  1.00          
ATOM   1220  HE2 PHE    74     -18.179   4.624  -2.166  1.00  1.00          
ATOM   1221  CZ  PHE    74     -16.643   3.192  -1.774  1.00  1.00          
ATOM   1222  HZ  PHE    74     -16.700   2.748  -2.757  1.00  1.00          
ATOM   1223  C   PHE    74     -16.064   7.430   2.566  1.00  1.00          
ATOM   1224  O   PHE    74     -16.342   7.781   3.723  1.00  1.00          
ATOM   1225  N   LYS    75     -16.345   8.186   1.442  1.00  1.00          
ATOM   1226  HN  LYS    75     -16.106   7.786   0.580  1.00  1.00          
ATOM   1227  CA  LYS    75     -16.981   9.574   1.391  1.00  1.00          
ATOM   1228  HA  LYS    75     -17.230   9.733   0.349  1.00  1.00          
ATOM   1229  CB  LYS    75     -18.306   9.741   2.220  1.00  1.00          
ATOM   1230  HB1 LYS    75     -18.359  10.754   2.591  1.00  1.00          
ATOM   1231  HB2 LYS    75     -18.277   9.063   3.062  1.00  1.00          
ATOM   1232  CG  LYS    75     -19.570   9.455   1.426  1.00  1.00          
ATOM   1233  HG1 LYS    75     -19.478   8.486   0.959  1.00  1.00          
ATOM   1234  HG2 LYS    75     -19.687  10.215   0.667  1.00  1.00          
ATOM   1235  CD  LYS    75     -20.801   9.459   2.327  1.00  1.00          
ATOM   1236  HD1 LYS    75     -20.853  10.410   2.838  1.00  1.00          
ATOM   1237  HD2 LYS    75     -20.699   8.665   3.055  1.00  1.00          
ATOM   1238  CE  LYS    75     -22.093   9.254   1.530  1.00  1.00          
ATOM   1239  HE1 LYS    75     -22.855   8.851   2.184  1.00  1.00          
ATOM   1240  HE2 LYS    75     -21.897   8.551   0.734  1.00  1.00          
ATOM   1241  NZ  LYS    75     -22.595  10.528   0.935  1.00  1.00          
ATOM   1242  HZ1 LYS    75     -22.066  10.752   0.068  1.00  1.00          
ATOM   1243  HZ2 LYS    75     -22.473  11.309   1.612  1.00  1.00          
ATOM   1244  HZ3 LYS    75     -23.603  10.441   0.702  1.00  1.00          
ATOM   1245  C   LYS    75     -15.957  10.674   1.761  1.00  1.00          
ATOM   1246  O   LYS    75     -15.480  10.734   2.919  1.00  1.00          
ATOM   1247  N   GLY    76     -15.614  11.494   0.732  1.00  1.00          
ATOM   1248  HN  GLY    76     -16.034  11.341  -0.140  1.00  1.00          
ATOM   1249  CA  GLY    76     -14.651  12.595   0.866  1.00  1.00          
ATOM   1250  HA1 GLY    76     -13.866  12.287   1.541  1.00  1.00          
ATOM   1251  HA2 GLY    76     -15.157  13.450   1.290  1.00  1.00          
ATOM   1252  C   GLY    76     -14.025  12.999  -0.458  1.00  1.00          
ATOM   1253  O   GLY    76     -14.391  14.058  -1.005  1.00  1.00          
ATOM   1254  N   GLY    77     -13.089  12.142  -0.950  1.00  1.00          
ATOM   1255  HN  GLY    77     -12.885  11.334  -0.436  1.00  1.00          
ATOM   1256  CA  GLY    77     -12.365  12.375  -2.221  1.00  1.00          
ATOM   1257  HA1 GLY    77     -11.311  12.461  -1.997  1.00  1.00          
ATOM   1258  HA2 GLY    77     -12.700  13.311  -2.639  1.00  1.00          
ATOM   1259  C   GLY    77     -12.541  11.287  -3.285  1.00  1.00          
ATOM   1260  O   GLY    77     -11.601  11.072  -4.073  1.00  1.00          
ATOM   1261  N   ILE    78     -13.729  10.616  -3.301  1.00  1.00          
ATOM   1262  HN  ILE    78     -14.405  10.858  -2.636  1.00  1.00          
ATOM   1263  CA  ILE    78     -14.055   9.535  -4.278  1.00  1.00          
ATOM   1264  HA  ILE    78     -13.224   9.468  -4.971  1.00  1.00          
ATOM   1265  CB  ILE    78     -14.285   8.078  -3.623  1.00  1.00          
ATOM   1266  HB  ILE    78     -15.313   8.025  -3.295  1.00  1.00          
ATOM   1267  CG1 ILE    78     -13.357   7.776  -2.416  1.00  1.00          
ATOM   1268 HG11 ILE    78     -12.680   8.609  -2.276  1.00  1.00          
ATOM   1269 HG12 ILE    78     -12.785   6.885  -2.622  1.00  1.00          
ATOM   1270  CG2 ILE    78     -14.062   6.944  -4.653  1.00  1.00          
ATOM   1271 HG21 ILE    78     -14.611   7.167  -5.557  1.00  1.00          
ATOM   1272 HG22 ILE    78     -14.412   6.008  -4.242  1.00  1.00          
ATOM   1273 HG23 ILE    78     -13.009   6.865  -4.881  1.00  1.00          
ATOM   1274  CD1 ILE    78     -14.104   7.558  -1.118  1.00  1.00          
ATOM   1275 HD11 ILE    78     -14.678   8.442  -0.880  1.00  1.00          
ATOM   1276 HD12 ILE    78     -13.398   7.364  -0.324  1.00  1.00          
ATOM   1277 HD13 ILE    78     -14.770   6.714  -1.222  1.00  1.00          
ATOM   1278  C   ILE    78     -15.308   9.982  -5.069  1.00  1.00          
ATOM   1279  O   ILE    78     -16.370  10.216  -4.462  1.00  1.00          
ATOM   1280  N   ASP    79     -15.134  10.090  -6.412  1.00  1.00          
ATOM   1281  HN  ASP    79     -14.247   9.892  -6.779  1.00  1.00          
ATOM   1282  CA  ASP    79     -16.200  10.488  -7.355  1.00  1.00          
ATOM   1283  HA  ASP    79     -17.123  10.546  -6.796  1.00  1.00          
ATOM   1284  CB  ASP    79     -15.902  11.868  -7.968  1.00  1.00          
ATOM   1285  HB1 ASP    79     -16.448  11.965  -8.894  1.00  1.00          
ATOM   1286  HB2 ASP    79     -14.845  11.943  -8.171  1.00  1.00          
ATOM   1287  CG  ASP    79     -16.299  13.014  -7.052  1.00  1.00          
ATOM   1288  OD1 ASP    79     -15.392  13.678  -6.508  1.00  1.00          
ATOM   1289  OD2 ASP    79     -17.516  13.251  -6.884  1.00  1.00          
ATOM   1290  C   ASP    79     -16.367   9.439  -8.456  1.00  1.00          
ATOM   1291  O   ASP    79     -15.369   9.004  -9.067  1.00  1.00          
ATOM   1292  N   TRP    80     -17.649   9.026  -8.669  1.00  1.00          
ATOM   1293  HN  TRP    80     -18.351   9.424  -8.112  1.00  1.00          
ATOM   1294  CA  TRP    80     -18.065   8.009  -9.693  1.00  1.00          
ATOM   1295  HA  TRP    80     -17.284   7.264  -9.721  1.00  1.00          
ATOM   1296  CB  TRP    80     -19.368   7.313  -9.266  1.00  1.00          
ATOM   1297  HB1 TRP    80     -19.786   6.791 -10.114  1.00  1.00          
ATOM   1298  HB2 TRP    80     -20.071   8.058  -8.923  1.00  1.00          
ATOM   1299  CG  TRP    80     -19.169   6.307  -8.145  1.00  1.00          
ATOM   1300  CD1 TRP    80     -19.391   6.544  -6.819  1.00  1.00          
ATOM   1301  HD1 TRP    80     -19.745   7.485  -6.425  1.00  1.00          
ATOM   1302  CD2 TRP    80     -18.703   4.930  -8.229  1.00  1.00          
ATOM   1303  NE1 TRP    80     -19.095   5.430  -6.076  1.00  1.00          
ATOM   1304  HE1 TRP    80     -19.175   5.361  -5.101  1.00  1.00          
ATOM   1305  CE2 TRP    80     -18.674   4.429  -6.910  1.00  1.00          
ATOM   1306  CE3 TRP    80     -18.306   4.066  -9.277  1.00  1.00          
ATOM   1307  HE3 TRP    80     -18.313   4.397 -10.304  1.00  1.00          
ATOM   1308  CZ2 TRP    80     -18.271   3.129  -6.610  1.00  1.00          
ATOM   1309  HZ2 TRP    80     -18.253   2.759  -5.596  1.00  1.00          
ATOM   1310  CZ3 TRP    80     -17.909   2.777  -8.969  1.00  1.00          
ATOM   1311  HZ3 TRP    80     -17.604   2.102  -9.759  1.00  1.00          
ATOM   1312  CH2 TRP    80     -17.894   2.321  -7.647  1.00  1.00          
ATOM   1313  HH2 TRP    80     -17.575   1.308  -7.453  1.00  1.00          
ATOM   1314  C   TRP    80     -18.210   8.581 -11.130  1.00  1.00          
ATOM   1315  O   TRP    80     -17.950   7.851 -12.102  1.00  1.00          
ATOM   1316  N   GLU    81     -18.632   9.883 -11.229  1.00  1.00          
ATOM   1317  HN  GLU    81     -18.821  10.362 -10.396  1.00  1.00          
ATOM   1318  CA  GLU    81     -18.823  10.631 -12.519  1.00  1.00          
ATOM   1319  HA  GLU    81     -19.262   9.941 -13.225  1.00  1.00          
ATOM   1320  CB  GLU    81     -19.801  11.809 -12.323  1.00  1.00          
ATOM   1321  HB1 GLU    81     -19.668  12.505 -13.137  1.00  1.00          
ATOM   1322  HB2 GLU    81     -19.558  12.308 -11.397  1.00  1.00          
ATOM   1323  CG  GLU    81     -21.276  11.411 -12.273  1.00  1.00          
ATOM   1324  HG1 GLU    81     -21.414  10.696 -11.476  1.00  1.00          
ATOM   1325  HG2 GLU    81     -21.544  10.955 -13.215  1.00  1.00          
ATOM   1326  CD  GLU    81     -22.191  12.596 -12.029  1.00  1.00          
ATOM   1327  OE1 GLU    81     -22.409  12.944 -10.849  1.00  1.00          
ATOM   1328  OE2 GLU    81     -22.693  13.174 -13.017  1.00  1.00          
ATOM   1329  C   GLU    81     -17.492  11.159 -13.127  1.00  1.00          
ATOM   1330  O   GLU    81     -17.354  11.175 -14.364  1.00  1.00          
ATOM   1331  N   ASN    82     -16.547  11.581 -12.234  1.00  1.00          
ATOM   1332  HN  ASN    82     -16.764  11.528 -11.281  1.00  1.00          
ATOM   1333  CA  ASN    82     -15.209  12.112 -12.609  1.00  1.00          
ATOM   1334  HA  ASN    82     -15.290  12.507 -13.611  1.00  1.00          
ATOM   1335  CB  ASN    82     -14.834  13.262 -11.661  1.00  1.00          
ATOM   1336  HB1 ASN    82     -13.760  13.375 -11.649  1.00  1.00          
ATOM   1337  HB2 ASN    82     -15.177  13.023 -10.665  1.00  1.00          
ATOM   1338  CG  ASN    82     -15.451  14.585 -12.077  1.00  1.00          
ATOM   1339  OD1 ASN    82     -16.545  14.941 -11.636  1.00  1.00          
ATOM   1340  ND2 ASN    82     -14.753  15.321 -12.936  1.00  1.00          
ATOM   1341 HD21 ASN    82     -13.892  14.972 -13.249  1.00  1.00          
ATOM   1342 HD22 ASN    82     -15.129  16.179 -13.222  1.00  1.00          
ATOM   1343  C   ASN    82     -14.090  11.029 -12.597  1.00  1.00          
ATOM   1344  O   ASN    82     -13.014  11.254 -13.179  1.00  1.00          
ATOM   1345  N   LYS    83     -14.365   9.822 -11.944  1.00  1.00          
ATOM   1346  HN  LYS    83     -15.254   9.736 -11.541  1.00  1.00          
ATOM   1347  CA  LYS    83     -13.433   8.623 -11.790  1.00  1.00          
ATOM   1348  HA  LYS    83     -13.974   7.939 -11.145  1.00  1.00          
ATOM   1349  CB  LYS    83     -13.206   7.870 -13.151  1.00  1.00          
ATOM   1350  HB1 LYS    83     -12.300   7.286 -13.080  1.00  1.00          
ATOM   1351  HB2 LYS    83     -13.089   8.602 -13.935  1.00  1.00          
ATOM   1352  CG  LYS    83     -14.343   6.943 -13.540  1.00  1.00          
ATOM   1353  HG1 LYS    83     -15.259   7.512 -13.597  1.00  1.00          
ATOM   1354  HG2 LYS    83     -14.440   6.172 -12.788  1.00  1.00          
ATOM   1355  CD  LYS    83     -14.081   6.286 -14.884  1.00  1.00          
ATOM   1356  HD1 LYS    83     -13.142   5.753 -14.838  1.00  1.00          
ATOM   1357  HD2 LYS    83     -14.024   7.054 -15.642  1.00  1.00          
ATOM   1358  CE  LYS    83     -15.187   5.313 -15.253  1.00  1.00          
ATOM   1359  HE1 LYS    83     -16.123   5.849 -15.296  1.00  1.00          
ATOM   1360  HE2 LYS    83     -15.244   4.548 -14.492  1.00  1.00          
ATOM   1361  NZ  LYS    83     -14.938   4.664 -16.569  1.00  1.00          
ATOM   1362  HZ1 LYS    83     -13.954   4.827 -16.866  1.00  1.00          
ATOM   1363  HZ2 LYS    83     -15.576   5.060 -17.288  1.00  1.00          
ATOM   1364  HZ3 LYS    83     -15.103   3.640 -16.498  1.00  1.00          
ATOM   1365  C   LYS    83     -12.093   8.949 -11.022  1.00  1.00          
ATOM   1366  O   LYS    83     -10.958   8.649 -11.484  1.00  1.00          
ATOM   1367  N   ARG    84     -12.280   9.578  -9.829  1.00  1.00          
ATOM   1368  HN  ARG    84     -13.197   9.781  -9.556  1.00  1.00          
ATOM   1369  CA  ARG    84     -11.177   9.973  -8.915  1.00  1.00          
ATOM   1370  HA  ARG    84     -10.248   9.735  -9.415  1.00  1.00          
ATOM   1371  CB  ARG    84     -11.199  11.488  -8.602  1.00  1.00          
ATOM   1372  HB1 ARG    84     -10.545  11.673  -7.762  1.00  1.00          
ATOM   1373  HB2 ARG    84     -12.204  11.766  -8.325  1.00  1.00          
ATOM   1374  CG  ARG    84     -10.759  12.395  -9.761  1.00  1.00          
ATOM   1375  HG1 ARG    84     -11.394  12.192 -10.613  1.00  1.00          
ATOM   1376  HG2 ARG    84      -9.736  12.160 -10.014  1.00  1.00          
ATOM   1377  CD  ARG    84     -10.846  13.887  -9.411  1.00  1.00          
ATOM   1378  HD1 ARG    84     -11.771  14.060  -8.880  1.00  1.00          
ATOM   1379  HD2 ARG    84     -10.850  14.462 -10.328  1.00  1.00          
ATOM   1380  NE  ARG    84      -9.710  14.353  -8.562  1.00  1.00          
ATOM   1381  HE  ARG    84      -9.050  13.668  -8.321  1.00  1.00          
ATOM   1382  CZ  ARG    84      -9.489  15.622  -8.092  1.00  1.00          
ATOM   1383  NH1 ARG    84     -10.311  16.662  -8.334  1.00  1.00          
ATOM   1384 HH11 ARG    84     -11.137  16.530  -8.883  1.00  1.00          
ATOM   1385 HH12 ARG    84     -10.096  17.567  -7.966  1.00  1.00          
ATOM   1386  NH2 ARG    84      -8.407  15.842  -7.358  1.00  1.00          
ATOM   1387 HH21 ARG    84      -7.777  15.091  -7.158  1.00  1.00          
ATOM   1388 HH22 ARG    84      -8.220  16.759  -7.004  1.00  1.00          
ATOM   1389  C   ARG    84     -11.241   9.161  -7.617  1.00  1.00          
ATOM   1390  O   ARG    84     -12.313   9.074  -6.983  1.00  1.00          
ATOM   1391  N   VAL    85     -10.077   8.561  -7.263  1.00  1.00          
ATOM   1392  HN  VAL    85      -9.301   8.687  -7.846  1.00  1.00          
ATOM   1393  CA  VAL    85      -9.904   7.718  -6.039  1.00  1.00          
ATOM   1394  HA  VAL    85     -10.812   7.810  -5.456  1.00  1.00          
ATOM   1395  CB  VAL    85      -9.646   6.150  -6.330  1.00  1.00          
ATOM   1396  HB  VAL    85      -8.581   6.030  -6.499  1.00  1.00          
ATOM   1397  CG1 VAL    85     -10.035   5.258  -5.126  1.00  1.00          
ATOM   1398 HG11 VAL    85     -11.101   5.079  -5.142  1.00  1.00          
ATOM   1399 HG12 VAL    85      -9.770   5.759  -4.207  1.00  1.00          
ATOM   1400 HG13 VAL    85      -9.511   4.313  -5.184  1.00  1.00          
ATOM   1401  CG2 VAL    85     -10.393   5.597  -7.571  1.00  1.00          
ATOM   1402 HG21 VAL    85     -10.481   6.377  -8.314  1.00  1.00          
ATOM   1403 HG22 VAL    85     -11.379   5.269  -7.279  1.00  1.00          
ATOM   1404 HG23 VAL    85      -9.849   4.761  -7.991  1.00  1.00          
ATOM   1405  C   VAL    85      -8.733   8.306  -5.209  1.00  1.00          
ATOM   1406  O   VAL    85      -7.655   8.571  -5.773  1.00  1.00          
ATOM   1407  N   LYS    86      -8.991   8.498  -3.887  1.00  1.00          
ATOM   1408  HN  LYS    86      -9.890   8.294  -3.556  1.00  1.00          
ATOM   1409  CA  LYS    86      -8.000   9.027  -2.925  1.00  1.00          
ATOM   1410  HA  LYS    86      -7.071   9.173  -3.455  1.00  1.00          
ATOM   1411  CB  LYS    86      -8.473  10.381  -2.362  1.00  1.00          
ATOM   1412  HB1 LYS    86      -8.009  10.529  -1.398  1.00  1.00          
ATOM   1413  HB2 LYS    86      -9.545  10.332  -2.223  1.00  1.00          
ATOM   1414  CG  LYS    86      -8.139  11.597  -3.250  1.00  1.00          
ATOM   1415  HG1 LYS    86      -8.972  12.293  -3.242  1.00  1.00          
ATOM   1416  HG2 LYS    86      -7.974  11.254  -4.259  1.00  1.00          
ATOM   1417  CD  LYS    86      -6.886  12.335  -2.776  1.00  1.00          
ATOM   1418  HD1 LYS    86      -6.049  11.653  -2.800  1.00  1.00          
ATOM   1419  HD2 LYS    86      -7.043  12.682  -1.765  1.00  1.00          
ATOM   1420  CE  LYS    86      -6.575  13.533  -3.661  1.00  1.00          
ATOM   1421  HE1 LYS    86      -7.425  14.199  -3.653  1.00  1.00          
ATOM   1422  HE2 LYS    86      -6.402  13.184  -4.668  1.00  1.00          
ATOM   1423  NZ  LYS    86      -5.372  14.274  -3.191  1.00  1.00          
ATOM   1424  HZ1 LYS    86      -5.657  15.075  -2.592  1.00  1.00          
ATOM   1425  HZ2 LYS    86      -4.837  14.638  -4.005  1.00  1.00          
ATOM   1426  HZ3 LYS    86      -4.756  13.644  -2.640  1.00  1.00          
ATOM   1427  C   LYS    86      -7.759   8.043  -1.773  1.00  1.00          
ATOM   1428  O   LYS    86      -8.720   7.452  -1.243  1.00  1.00          
ATOM   1429  N   LEU    87      -6.457   7.890  -1.420  1.00  1.00          
ATOM   1430  HN  LEU    87      -5.788   8.401  -1.914  1.00  1.00          
ATOM   1431  CA  LEU    87      -5.975   7.022  -0.331  1.00  1.00          
ATOM   1432  HA  LEU    87      -6.839   6.619   0.176  1.00  1.00          
ATOM   1433  CB  LEU    87      -5.117   5.864  -0.882  1.00  1.00          
ATOM   1434  HB1 LEU    87      -4.350   5.647  -0.155  1.00  1.00          
ATOM   1435  HB2 LEU    87      -4.637   6.212  -1.785  1.00  1.00          
ATOM   1436  CG  LEU    87      -5.861   4.550  -1.208  1.00  1.00          
ATOM   1437  HG  LEU    87      -6.926   4.721  -1.180  1.00  1.00          
ATOM   1438  CD1 LEU    87      -5.511   4.050  -2.604  1.00  1.00          
ATOM   1439 HD11 LEU    87      -5.965   4.693  -3.341  1.00  1.00          
ATOM   1440 HD12 LEU    87      -5.887   3.044  -2.725  1.00  1.00          
ATOM   1441 HD13 LEU    87      -4.438   4.049  -2.733  1.00  1.00          
ATOM   1442  CD2 LEU    87      -5.525   3.478  -0.176  1.00  1.00          
ATOM   1443 HD21 LEU    87      -5.823   3.815   0.806  1.00  1.00          
ATOM   1444 HD22 LEU    87      -4.462   3.285  -0.184  1.00  1.00          
ATOM   1445 HD23 LEU    87      -6.051   2.566  -0.418  1.00  1.00          
ATOM   1446  C   LEU    87      -5.175   7.851   0.674  1.00  1.00          
ATOM   1447  O   LEU    87      -4.291   8.640   0.276  1.00  1.00          
ATOM   1448  N   LYS    88      -5.529   7.665   1.963  1.00  1.00          
ATOM   1449  HN  LYS    88      -6.253   7.036   2.148  1.00  1.00          
ATOM   1450  HA  LYS    88      -4.275   9.146   2.707  1.00  1.00          
ATOM   1451  CB  LYS    88      -5.962   8.982   4.017  1.00  1.00          
ATOM   1452  HB1 LYS    88      -5.562   9.062   5.017  1.00  1.00          
ATOM   1453  HB2 LYS    88      -6.824   8.332   4.036  1.00  1.00          
ATOM   1454  CG  LYS    88      -6.418  10.364   3.571  1.00  1.00          
ATOM   1455  HG1 LYS    88      -6.771  10.305   2.552  1.00  1.00          
ATOM   1456  HG2 LYS    88      -5.579  11.042   3.624  1.00  1.00          
ATOM   1457  CD  LYS    88      -7.543  10.896   4.457  1.00  1.00          
ATOM   1458  HD1 LYS    88      -7.194  10.910   5.482  1.00  1.00          
ATOM   1459  HD2 LYS    88      -8.391  10.233   4.375  1.00  1.00          
ATOM   1460  CE  LYS    88      -7.980  12.309   4.053  1.00  1.00          
ATOM   1461  HE1 LYS    88      -7.103  12.879   3.782  1.00  1.00          
ATOM   1462  HE2 LYS    88      -8.465  12.784   4.896  1.00  1.00          
ATOM   1463  NZ  LYS    88      -8.931  12.307   2.900  1.00  1.00          
ATOM   1464  HZ1 LYS    88      -8.916  11.381   2.426  1.00  1.00          
ATOM   1465  HZ2 LYS    88      -8.663  13.040   2.213  1.00  1.00          
ATOM   1466  HZ3 LYS    88      -9.898  12.499   3.233  1.00  1.00          
ATOM   1467  CA  LYS    88      -4.895   8.357   3.108  1.00  1.00          
ATOM   1468  C   LYS    88      -4.008   7.403   3.912  1.00  1.00          
ATOM   1469  OT1 LYS    88      -4.429   6.247   4.147  1.00  1.00          
ATOM   1470  OT2 LYS    88      -2.897   7.822   4.299  1.00  1.00          
END
