
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  139 ( 2236),  selected  139 , name 1ey1_A
# Molecule2: number of CA atoms   87 ( 1451),  selected   87 , name T0476.pdb
# PARAMETERS: 1ey1_A.T0476.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      A       2           -
LGA    -       -      K       3           -
LGA    -       -      C       4           -
LGA    -       -      P       5           -
LGA    M     1_A      I       6           #
LGA    K     2_A      C       7          3.942
LGA    P     3_A      G       8           #
LGA    A     4_A      S       9          3.372
LGA    A     5_A      -       -           -
LGA    R     6_A      P      10          1.210
LGA    R     7_A      L      11          3.831
LGA    R     8_A      K      12           #
LGA    A     9_A      W      13          5.175
LGA    R    10_A      E      14          5.343
LGA    E    11_A      E      15          2.622
LGA    C    12_A      L      16          1.982
LGA    A    13_A      I      17          3.495
LGA    V    14_A      E      18          3.267
LGA    Q    15_A      E      19          3.732
LGA    A    16_A      M      20          4.371
LGA    L    17_A      L      21          4.966
LGA    Y    18_A      I      22          5.024
LGA    S    19_A      I      23          4.473
LGA    W    20_A      -       -           -
LGA    Q    21_A      E      24          5.276
LGA    L    22_A      N      25          3.209
LGA    S    23_A      F      26          3.519
LGA    Q    24_A      E      27          3.083
LGA    N    25_A      E      28          3.159
LGA    D    26_A      I      29          3.936
LGA    I    27_A      V      30          3.029
LGA    -       -      K      31           -
LGA    -       -      D      32           -
LGA    A    28_A      R      33          2.381
LGA    D    29_A      E      34          3.812
LGA    V    30_A      R      35          3.706
LGA    E    31_A      F      36          3.664
LGA    Y    32_A      L      37          4.240
LGA    Q    33_A      A      38          4.075
LGA    F    34_A      Q      39          4.274
LGA    L    35_A      V      40          3.283
LGA    A    36_A      E      41          2.315
LGA    E    37_A      E      42          2.796
LGA    Q    38_A      F      43          3.346
LGA    D    39_A      V      44          2.882
LGA    V    40_A      F      45          3.068
LGA    -       -      K      46           -
LGA    -       -      C      47           -
LGA    -       -      P      48           -
LGA    -       -      V      49           -
LGA    -       -      C      50           -
LGA    -       -      G      51           -
LGA    -       -      E      52           -
LGA    -       -      E      53           -
LGA    K    41_A      F      54          0.989
LGA    D    42_A      Y      55          2.912
LGA    -       -      G      56           -
LGA    -       -      K      57           -
LGA    V    43_A      T      58          3.202
LGA    D    44_A      L      59          1.041
LGA    V    45_A      P      60           #
LGA    L    46_A      R      61          4.990
LGA    Y    47_A      R      62          3.921
LGA    F    48_A      E      63          3.384
LGA    R    49_A      A      64          3.588
LGA    E    50_A      E      65          2.936
LGA    L    51_A      K      66          2.514
LGA    L    52_A      V      67          3.444
LGA    A    53_A      F      68          2.565
LGA    G    54_A      E      69          2.236
LGA    V    55_A      L      70          3.259
LGA    A    56_A      L      71          3.107
LGA    T    57_A      N      72          2.691
LGA    N    58_A      D      73          2.246
LGA    T    59_A      F      74          1.664
LGA    A    60_A      K      75          3.337
LGA    Y    61_A      -       -           -
LGA    L    62_A      -       -           -
LGA    D    63_A      G      76          1.298
LGA    G    64_A      -       -           -
LGA    L    65_A      -       -           -
LGA    M    66_A      G      77          3.518
LGA    K    67_A      I      78           -
LGA    P    68_A      -       -           -
LGA    Y    69_A      -       -           -
LGA    L    70_A      -       -           -
LGA    S    71_A      -       -           -
LGA    R    72_A      -       -           -
LGA    L    73_A      -       -           -
LGA    L    74_A      D      79          2.124
LGA    E    75_A      W      80          2.084
LGA    E    76_A      E      81          1.290
LGA    L    77_A      N      82          0.966
LGA    G    78_A      K      83          3.087
LGA    Q    79_A      -       -           -
LGA    V    80_A      -       -           -
LGA    E    81_A      -       -           -
LGA    K    82_A      R      84          1.620
LGA    A    83_A      V      85          3.099
LGA    V    84_A      -       -           -
LGA    L    85_A      -       -           -
LGA    R    86_A      K      86          2.187
LGA    I    87_A      L      87          3.340
LGA    A    88_A      -       -           -
LGA    L    89_A      -       -           -
LGA    Y    90_A      K      88          1.911
LGA    E    91_A      -       -           -
LGA    L    92_A      -       -           -
LGA    S    93_A      -       -           -
LGA    K    94_A      -       -           -
LGA    R    95_A      -       -           -
LGA    S    96_A      -       -           -
LGA    D    97_A      -       -           -
LGA    V    98_A      -       -           -
LGA    P    99_A      -       -           -
LGA    Y   100_A      -       -           -
LGA    K   101_A      -       -           -
LGA    V   102_A      -       -           -
LGA    A   103_A      -       -           -
LGA    I   104_A      -       -           -
LGA    N   105_A      -       -           -
LGA    E   106_A      -       -           -
LGA    A   107_A      -       -           -
LGA    I   108_A      -       -           -
LGA    E   109_A      -       -           -
LGA    L   110_A      -       -           -
LGA    A   111_A      -       -           -
LGA    K   112_A      -       -           -
LGA    S   113_A      -       -           -
LGA    F   114_A      -       -           -
LGA    G   115_A      -       -           -
LGA    A   116_A      -       -           -
LGA    E   117_A      -       -           -
LGA    D   118_A      -       -           -
LGA    S   119_A      -       -           -
LGA    H   120_A      -       -           -
LGA    K   121_A      -       -           -
LGA    F   122_A      -       -           -
LGA    V   123_A      -       -           -
LGA    N   124_A      -       -           -
LGA    G   125_A      -       -           -
LGA    V   126_A      -       -           -
LGA    L   127_A      -       -           -
LGA    D   128_A      -       -           -
LGA    K   129_A      -       -           -
LGA    A   130_A      -       -           -
LGA    A   131_A      -       -           -
LGA    P   132_A      -       -           -
LGA    V   133_A      -       -           -
LGA    I   134_A      -       -           -
LGA    R   135_A      -       -           -
LGA    P   136_A      -       -           -
LGA    N   137_A      -       -           -
LGA    K   138_A      -       -           -
LGA    K   139_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  139   87    5.0     66    3.30     7.58     43.414     1.940

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.083314 * X  +   0.582293 * Y  +  -0.808699 * Z  + -15.137136
  Y_new =  -0.911452 * X  +   0.372614 * Y  +   0.174395 * Z  + 107.257866
  Z_new =   0.402882 * X  +   0.722561 * Y  +   0.561776 * Z  + -51.049080 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.909939   -2.231654  [ DEG:    52.1357   -127.8643 ]
  Theta =  -0.414663   -2.726929  [ DEG:   -23.7584   -156.2415 ]
  Phi   =  -1.479641    1.661951  [ DEG:   -84.7772     95.2228 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ey1_A                                        
REMARK     2: T0476.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ey1_A.T0476.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  139   87   5.0   66   3.30    7.58  43.414
REMARK  ---------------------------------------------------------- 
MOLECULE 1ey1_A
HEADER    TRANSCRIPTION                           05-MAY-00   1EY1              
TITLE     SOLUTION STRUCTURE OF ESCHERICHIA COLI NUSB                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ANTITERMINATION FACTOR NUSB;                               
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: N UTILIZATION SUBSTANCE PROTEIN B                           
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA                                            
KEYWDS    TRANSCIRPTION TERMINATION                                             
EXPDTA    NMR, 15 STRUCTURES                                                    
AUTHOR    A.S.ALTIERI,M.J.MAZZULLA,D.A.HORITA,R.H.COATS,P.T.WINGFIELD           
REVDAT   2   01-APR-03 1EY1    1       JRNL                                     
REVDAT   1   14-JUN-00 1EY1    0                                                
JRNL        AUTH   A.S.ALTIERI,M.J.MAZZULLA,D.A.HORITA,R.H.COATS,               
JRNL        AUTH 2 P.T.WINGFIELD,A.DAS,D.L.COURT,R.A.BYRD                       
JRNL        TITL   THE STRUCTURE OF THE TRANSCRIPTIONAL                         
JRNL        TITL 2 ANTITERMINATOR NUSB FROM ESCHERICHIA COLI.                   
JRNL        REF    NAT.STRUCT.BIOL.              V.   7   470 2000              
JRNL        REFN   ASTM NSBIEW  US ISSN 1072-8368                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1EY1 A    1   139  UNP    P0A780   NUSB_ECOLI       1    139             
SEQRES   1 A  139  MET LYS PRO ALA ALA ARG ARG ARG ALA ARG GLU CYS ALA          
SEQRES   2 A  139  VAL GLN ALA LEU TYR SER TRP GLN LEU SER GLN ASN ASP          
SEQRES   3 A  139  ILE ALA ASP VAL GLU TYR GLN PHE LEU ALA GLU GLN ASP          
SEQRES   4 A  139  VAL LYS ASP VAL ASP VAL LEU TYR PHE ARG GLU LEU LEU          
SEQRES   5 A  139  ALA GLY VAL ALA THR ASN THR ALA TYR LEU ASP GLY LEU          
SEQRES   6 A  139  MET LYS PRO TYR LEU SER ARG LEU LEU GLU GLU LEU GLY          
SEQRES   7 A  139  GLN VAL GLU LYS ALA VAL LEU ARG ILE ALA LEU TYR GLU          
SEQRES   8 A  139  LEU SER LYS ARG SER ASP VAL PRO TYR LYS VAL ALA ILE          
SEQRES   9 A  139  ASN GLU ALA ILE GLU LEU ALA LYS SER PHE GLY ALA GLU          
SEQRES  10 A  139  ASP SER HIS LYS PHE VAL ASN GLY VAL LEU ASP LYS ALA          
SEQRES  11 A  139  ALA PRO VAL ILE ARG PRO ASN LYS LYS                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1      13.293  -8.777  -6.499  1.00  0.00           N  
ATOM      2  CA  MET A   1      13.160  -7.361  -6.062  1.00  0.00           C  
ATOM      3  C   MET A   1      13.732  -6.406  -7.105  1.00  0.00           C  
ATOM      4  O   MET A   1      14.943  -6.200  -7.173  1.00  0.00           O  
ATOM      5  CB  MET A   1      13.894  -7.192  -4.730  1.00  0.00           C  
ATOM      6  CG  MET A   1      12.977  -7.245  -3.520  1.00  0.00           C  
ATOM      7  SD  MET A   1      12.848  -5.657  -2.677  1.00  0.00           S  
ATOM      8  CE  MET A   1      11.071  -5.432  -2.646  1.00  0.00           C  
ATOM      9  HA  MET A   1      12.111  -7.143  -5.921  1.00  0.00           H  
ATOM     10  HB2 MET A   1      14.627  -7.978  -4.635  1.00  0.00           H  
ATOM     11  HB3 MET A   1      14.399  -6.238  -4.732  1.00  0.00           H  
ATOM     12  HG2 MET A   1      11.991  -7.544  -3.844  1.00  0.00           H  
ATOM     13  HG3 MET A   1      13.363  -7.976  -2.825  1.00  0.00           H  
ATOM     14  HE1 MET A   1      10.836  -4.394  -2.824  1.00  0.00           H  
ATOM     15  HE2 MET A   1      10.688  -5.728  -1.680  1.00  0.00           H  
ATOM     16  HE3 MET A   1      10.618  -6.041  -3.415  1.00  0.00           H  
ATOM     17  H1  MET A   1      12.361  -9.095  -6.830  1.00  0.00           H  
ATOM     18  H2  MET A   1      13.611  -9.332  -5.678  1.00  0.00           H  
ATOM     19  H3  MET A   1      13.993  -8.807  -7.267  1.00  0.00           H  
ATOM     20  N   LYS A   2      12.852  -5.827  -7.915  1.00  0.00           N  
ATOM     21  CA  LYS A   2      13.270  -4.893  -8.954  1.00  0.00           C  
ATOM     22  C   LYS A   2      12.635  -3.523  -8.742  1.00  0.00           C  
ATOM     23  O   LYS A   2      11.438  -3.416  -8.476  1.00  0.00           O  
ATOM     24  CB  LYS A   2      12.895  -5.432 -10.335  1.00  0.00           C  
ATOM     25  CG  LYS A   2      13.352  -6.862 -10.576  1.00  0.00           C  
ATOM     26  CD  LYS A   2      12.894  -7.372 -11.932  1.00  0.00           C  
ATOM     27  CE  LYS A   2      11.390  -7.584 -11.969  1.00  0.00           C  
ATOM     28  NZ  LYS A   2      10.973  -8.750 -11.142  1.00  0.00           N  
ATOM     29  H   LYS A   2      11.899  -6.031  -7.811  1.00  0.00           H  
ATOM     30  HA  LYS A   2      14.344  -4.792  -8.896  1.00  0.00           H  
ATOM     31  HB2 LYS A   2      11.820  -5.399 -10.442  1.00  0.00           H  
ATOM     32  HB3 LYS A   2      13.342  -4.802 -11.089  1.00  0.00           H  
ATOM     33  HG2 LYS A   2      14.430  -6.895 -10.535  1.00  0.00           H  
ATOM     34  HG3 LYS A   2      12.941  -7.496  -9.805  1.00  0.00           H  
ATOM     35  HD2 LYS A   2      13.164  -6.650 -12.688  1.00  0.00           H  
ATOM     36  HD3 LYS A   2      13.388  -8.311 -12.138  1.00  0.00           H  
ATOM     37  HE2 LYS A   2      10.905  -6.696 -11.592  1.00  0.00           H  
ATOM     38  HE3 LYS A   2      11.088  -7.753 -12.993  1.00  0.00           H  
ATOM     39  HZ1 LYS A   2      10.012  -9.049 -11.404  1.00  0.00           H  
ATOM     40  HZ2 LYS A   2      10.982  -8.495 -10.133  1.00  0.00           H  
ATOM     41  HZ3 LYS A   2      11.627  -9.546 -11.291  1.00  0.00           H  
ATOM     42  N   PRO A   3      13.436  -2.454  -8.860  1.00  0.00           N  
ATOM     43  CA  PRO A   3      12.961  -1.078  -8.684  1.00  0.00           C  
ATOM     44  C   PRO A   3      11.899  -0.698  -9.710  1.00  0.00           C  
ATOM     45  O   PRO A   3      11.165   0.274  -9.529  1.00  0.00           O  
ATOM     46  CB  PRO A   3      14.227  -0.238  -8.887  1.00  0.00           C  
ATOM     47  CG  PRO A   3      15.141  -1.111  -9.670  1.00  0.00           C  
ATOM     48  CD  PRO A   3      14.871  -2.498  -9.176  1.00  0.00           C  
ATOM     49  HA  PRO A   3      12.574  -0.917  -7.689  1.00  0.00           H  
ATOM     50  HB2 PRO A   3      13.984   0.658  -9.428  1.00  0.00           H  
ATOM     51  HB3 PRO A   3      14.653   0.018  -7.928  1.00  0.00           H  
ATOM     52  HG2 PRO A   3      14.915  -1.035 -10.723  1.00  0.00           H  
ATOM     53  HG3 PRO A   3      16.169  -0.838  -9.480  1.00  0.00           H  
ATOM     54  HD2 PRO A   3      15.080  -3.226  -9.946  1.00  0.00           H  
ATOM     55  HD3 PRO A   3      15.452  -2.696  -8.292  1.00  0.00           H  
ATOM     56  N   ALA A   4      11.822  -1.472 -10.788  1.00  0.00           N  
ATOM     57  CA  ALA A   4      10.849  -1.218 -11.843  1.00  0.00           C  
ATOM     58  C   ALA A   4       9.448  -1.631 -11.408  1.00  0.00           C  
ATOM     59  O   ALA A   4       8.460  -1.292 -12.060  1.00  0.00           O  
ATOM     60  CB  ALA A   4      11.247  -1.953 -13.114  1.00  0.00           C  
ATOM     61  H   ALA A   4      12.434  -2.233 -10.875  1.00  0.00           H  
ATOM     62  HA  ALA A   4      10.853  -0.158 -12.052  1.00  0.00           H  
ATOM     63  HB1 ALA A   4      10.882  -2.969 -13.072  1.00  0.00           H  
ATOM     64  HB2 ALA A   4      12.323  -1.961 -13.204  1.00  0.00           H  
ATOM     65  HB3 ALA A   4      10.819  -1.452 -13.969  1.00  0.00           H  
ATOM     66  N   ALA A   5       9.369  -2.364 -10.302  1.00  0.00           N  
ATOM     67  CA  ALA A   5       8.088  -2.823  -9.779  1.00  0.00           C  
ATOM     68  C   ALA A   5       7.836  -2.269  -8.382  1.00  0.00           C  
ATOM     69  O   ALA A   5       8.519  -2.635  -7.426  1.00  0.00           O  
ATOM     70  CB  ALA A   5       8.039  -4.343  -9.763  1.00  0.00           C  
ATOM     71  H   ALA A   5      10.192  -2.602  -9.827  1.00  0.00           H  
ATOM     72  HA  ALA A   5       7.311  -2.468 -10.442  1.00  0.00           H  
ATOM     73  HB1 ALA A   5       7.011  -4.670  -9.696  1.00  0.00           H  
ATOM     74  HB2 ALA A   5       8.591  -4.712  -8.911  1.00  0.00           H  
ATOM     75  HB3 ALA A   5       8.480  -4.727 -10.672  1.00  0.00           H  
ATOM     76  N   ARG A   6       6.851  -1.383  -8.270  1.00  0.00           N  
ATOM     77  CA  ARG A   6       6.509  -0.778  -6.989  1.00  0.00           C  
ATOM     78  C   ARG A   6       5.204  -1.353  -6.446  1.00  0.00           C  
ATOM     79  O   ARG A   6       4.469  -0.677  -5.728  1.00  0.00           O  
ATOM     80  CB  ARG A   6       6.390   0.740  -7.133  1.00  0.00           C  
ATOM     81  CG  ARG A   6       7.664   1.486  -6.776  1.00  0.00           C  
ATOM     82  CD  ARG A   6       7.442   2.445  -5.617  1.00  0.00           C  
ATOM     83  NE  ARG A   6       8.162   3.702  -5.801  1.00  0.00           N  
ATOM     84  CZ  ARG A   6       7.786   4.853  -5.252  1.00  0.00           C  
ATOM     85  NH1 ARG A   6       6.702   4.902  -4.489  1.00  0.00           N  
ATOM     86  NH2 ARG A   6       8.493   5.954  -5.466  1.00  0.00           N  
ATOM     87  H   ARG A   6       6.343  -1.131  -9.069  1.00  0.00           H  
ATOM     88  HA  ARG A   6       7.304  -1.004  -6.294  1.00  0.00           H  
ATOM     89  HB2 ARG A   6       6.136   0.974  -8.156  1.00  0.00           H  
ATOM     90  HB3 ARG A   6       5.600   1.091  -6.487  1.00  0.00           H  
ATOM     91  HG2 ARG A   6       8.424   0.771  -6.498  1.00  0.00           H  
ATOM     92  HG3 ARG A   6       7.995   2.048  -7.638  1.00  0.00           H  
ATOM     93  HD2 ARG A   6       6.386   2.654  -5.538  1.00  0.00           H  
ATOM     94  HD3 ARG A   6       7.785   1.974  -4.707  1.00  0.00           H  
ATOM     95  HE  ARG A   6       8.966   3.688  -6.362  1.00  0.00           H  
ATOM     96 HH11 ARG A   6       6.168   4.074  -4.326  1.00  0.00           H  
ATOM     97 HH12 ARG A   6       6.421   5.769  -4.077  1.00  0.00           H  
ATOM     98 HH21 ARG A   6       9.310   5.920  -6.041  1.00  0.00           H  
ATOM     99 HH22 ARG A   6       8.208   6.818  -5.053  1.00  0.00           H  
ATOM    100  N   ARG A   7       4.924  -2.604  -6.795  1.00  0.00           N  
ATOM    101  CA  ARG A   7       3.708  -3.270  -6.343  1.00  0.00           C  
ATOM    102  C   ARG A   7       2.484  -2.717  -7.066  1.00  0.00           C  
ATOM    103  O   ARG A   7       2.033  -1.607  -6.785  1.00  0.00           O  
ATOM    104  CB  ARG A   7       3.541  -3.101  -4.831  1.00  0.00           C  
ATOM    105  CG  ARG A   7       3.462  -4.418  -4.077  1.00  0.00           C  
ATOM    106  CD  ARG A   7       4.766  -4.729  -3.362  1.00  0.00           C  
ATOM    107  NE  ARG A   7       4.894  -3.989  -2.110  1.00  0.00           N  
ATOM    108  CZ  ARG A   7       4.251  -4.316  -0.993  1.00  0.00           C  
ATOM    109  NH1 ARG A   7       3.440  -5.365  -0.975  1.00  0.00           N  
ATOM    110  NH2 ARG A   7       4.419  -3.594   0.106  1.00  0.00           N  
ATOM    111  H   ARG A   7       5.551  -3.091  -7.371  1.00  0.00           H  
ATOM    112  HA  ARG A   7       3.802  -4.321  -6.571  1.00  0.00           H  
ATOM    113  HB2 ARG A   7       4.382  -2.542  -4.448  1.00  0.00           H  
ATOM    114  HB3 ARG A   7       2.634  -2.547  -4.641  1.00  0.00           H  
ATOM    115  HG2 ARG A   7       2.668  -4.357  -3.348  1.00  0.00           H  
ATOM    116  HG3 ARG A   7       3.248  -5.211  -4.779  1.00  0.00           H  
ATOM    117  HD2 ARG A   7       4.801  -5.787  -3.148  1.00  0.00           H  
ATOM    118  HD3 ARG A   7       5.589  -4.466  -4.010  1.00  0.00           H  
ATOM    119  HE  ARG A   7       5.487  -3.210  -2.100  1.00  0.00           H  
ATOM    120 HH11 ARG A   7       3.311  -5.912  -1.803  1.00  0.00           H  
ATOM    121 HH12 ARG A   7       2.957  -5.610  -0.134  1.00  0.00           H  
ATOM    122 HH21 ARG A   7       5.029  -2.802   0.097  1.00  0.00           H  
ATOM    123 HH22 ARG A   7       3.934  -3.841   0.945  1.00  0.00           H  
ATOM    124  N   ARG A   8       1.952  -3.499  -8.000  1.00  0.00           N  
ATOM    125  CA  ARG A   8       0.780  -3.088  -8.764  1.00  0.00           C  
ATOM    126  C   ARG A   8      -0.380  -2.741  -7.836  1.00  0.00           C  
ATOM    127  O   ARG A   8      -0.981  -1.672  -7.964  1.00  0.00           O  
ATOM    128  CB  ARG A   8       0.361  -4.198  -9.729  1.00  0.00           C  
ATOM    129  CG  ARG A   8       1.396  -4.493 -10.804  1.00  0.00           C  
ATOM    130  CD  ARG A   8       1.541  -3.329 -11.771  1.00  0.00           C  
ATOM    131  NE  ARG A   8       2.931  -2.909 -11.916  1.00  0.00           N  
ATOM    132  CZ  ARG A   8       3.824  -3.559 -12.655  1.00  0.00           C  
ATOM    133  NH1 ARG A   8       3.471  -4.655 -13.313  1.00  0.00           N  
ATOM    134  NH2 ARG A   8       5.070  -3.114 -12.737  1.00  0.00           N  
ATOM    135  H   ARG A   8       2.357  -4.374  -8.179  1.00  0.00           H  
ATOM    136  HA  ARG A   8       1.046  -2.210  -9.332  1.00  0.00           H  
ATOM    137  HB2 ARG A   8       0.190  -5.104  -9.167  1.00  0.00           H  
ATOM    138  HB3 ARG A   8      -0.559  -3.908 -10.215  1.00  0.00           H  
ATOM    139  HG2 ARG A   8       2.349  -4.675 -10.331  1.00  0.00           H  
ATOM    140  HG3 ARG A   8       1.089  -5.371 -11.353  1.00  0.00           H  
ATOM    141  HD2 ARG A   8       1.164  -3.632 -12.737  1.00  0.00           H  
ATOM    142  HD3 ARG A   8       0.959  -2.497 -11.403  1.00  0.00           H  
ATOM    143  HE  ARG A   8       3.213  -2.100 -11.438  1.00  0.00           H  
ATOM    144 HH11 ARG A   8       2.532  -4.993 -13.253  1.00  0.00           H  
ATOM    145 HH12 ARG A   8       4.143  -5.143 -13.868  1.00  0.00           H  
ATOM    146 HH21 ARG A   8       5.340  -2.288 -12.243  1.00  0.00           H  
ATOM    147 HH22 ARG A   8       5.741  -3.606 -13.294  1.00  0.00           H  
ATOM    148  N   ALA A   9      -0.678  -3.660  -6.909  1.00  0.00           N  
ATOM    149  CA  ALA A   9      -1.761  -3.492  -5.936  1.00  0.00           C  
ATOM    150  C   ALA A   9      -2.277  -2.058  -5.893  1.00  0.00           C  
ATOM    151  O   ALA A   9      -3.363  -1.764  -6.392  1.00  0.00           O  
ATOM    152  CB  ALA A   9      -1.293  -3.928  -4.554  1.00  0.00           C  
ATOM    153  H   ALA A   9      -0.146  -4.484  -6.879  1.00  0.00           H  
ATOM    154  HA  ALA A   9      -2.573  -4.140  -6.227  1.00  0.00           H  
ATOM    155  HB1 ALA A   9      -0.744  -3.124  -4.087  1.00  0.00           H  
ATOM    156  HB2 ALA A   9      -0.653  -4.793  -4.647  1.00  0.00           H  
ATOM    157  HB3 ALA A   9      -2.149  -4.180  -3.944  1.00  0.00           H  
ATOM    158  N   ARG A  10      -1.488  -1.171  -5.297  1.00  0.00           N  
ATOM    159  CA  ARG A  10      -1.861   0.234  -5.183  1.00  0.00           C  
ATOM    160  C   ARG A  10      -2.660   0.695  -6.397  1.00  0.00           C  
ATOM    161  O   ARG A  10      -3.866   0.921  -6.310  1.00  0.00           O  
ATOM    162  CB  ARG A  10      -0.612   1.101  -5.022  1.00  0.00           C  
ATOM    163  CG  ARG A  10      -0.750   2.173  -3.954  1.00  0.00           C  
ATOM    164  CD  ARG A  10       0.501   3.033  -3.862  1.00  0.00           C  
ATOM    165  NE  ARG A  10       1.719   2.227  -3.867  1.00  0.00           N  
ATOM    166  CZ  ARG A  10       2.198   1.610  -2.792  1.00  0.00           C  
ATOM    167  NH1 ARG A  10       1.565   1.708  -1.632  1.00  0.00           N  
ATOM    168  NH2 ARG A  10       3.312   0.894  -2.877  1.00  0.00           N  
ATOM    169  H   ARG A  10      -0.634  -1.468  -4.922  1.00  0.00           H  
ATOM    170  HA  ARG A  10      -2.476   0.341  -4.303  1.00  0.00           H  
ATOM    171  HB2 ARG A  10       0.221   0.466  -4.758  1.00  0.00           H  
ATOM    172  HB3 ARG A  10      -0.399   1.585  -5.963  1.00  0.00           H  
ATOM    173  HG2 ARG A  10      -1.590   2.806  -4.199  1.00  0.00           H  
ATOM    174  HG3 ARG A  10      -0.920   1.698  -2.999  1.00  0.00           H  
ATOM    175  HD2 ARG A  10       0.523   3.706  -4.705  1.00  0.00           H  
ATOM    176  HD3 ARG A  10       0.462   3.604  -2.946  1.00  0.00           H  
ATOM    177  HE  ARG A  10       2.204   2.142  -4.715  1.00  0.00           H  
ATOM    178 HH11 ARG A  10       0.725   2.247  -1.564  1.00  0.00           H  
ATOM    179 HH12 ARG A  10       1.926   1.243  -0.824  1.00  0.00           H  
ATOM    180 HH21 ARG A  10       3.791   0.818  -3.750  1.00  0.00           H  
ATOM    181 HH22 ARG A  10       3.671   0.431  -2.067  1.00  0.00           H  
ATOM    182  N   GLU A  11      -1.977   0.835  -7.527  1.00  0.00           N  
ATOM    183  CA  GLU A  11      -2.624   1.277  -8.755  1.00  0.00           C  
ATOM    184  C   GLU A  11      -3.667   0.269  -9.222  1.00  0.00           C  
ATOM    185  O   GLU A  11      -4.700   0.642  -9.768  1.00  0.00           O  
ATOM    186  CB  GLU A  11      -1.585   1.500  -9.857  1.00  0.00           C  
ATOM    187  CG  GLU A  11      -0.210   1.889  -9.336  1.00  0.00           C  
ATOM    188  CD  GLU A  11      -0.262   3.032  -8.341  1.00  0.00           C  
ATOM    189  OE1 GLU A  11      -1.288   3.167  -7.642  1.00  0.00           O  
ATOM    190  OE2 GLU A  11       0.725   3.794  -8.261  1.00  0.00           O  
ATOM    191  H   GLU A  11      -1.018   0.638  -7.533  1.00  0.00           H  
ATOM    192  HA  GLU A  11      -3.118   2.214  -8.549  1.00  0.00           H  
ATOM    193  HB2 GLU A  11      -1.484   0.590 -10.430  1.00  0.00           H  
ATOM    194  HB3 GLU A  11      -1.934   2.287 -10.508  1.00  0.00           H  
ATOM    195  HG2 GLU A  11       0.235   1.032  -8.853  1.00  0.00           H  
ATOM    196  HG3 GLU A  11       0.405   2.188 -10.172  1.00  0.00           H  
ATOM    197  N   CYS A  12      -3.390  -1.008  -9.000  1.00  0.00           N  
ATOM    198  CA  CYS A  12      -4.301  -2.076  -9.398  1.00  0.00           C  
ATOM    199  C   CYS A  12      -5.633  -1.969  -8.663  1.00  0.00           C  
ATOM    200  O   CYS A  12      -6.673  -2.397  -9.169  1.00  0.00           O  
ATOM    201  CB  CYS A  12      -3.666  -3.441  -9.124  1.00  0.00           C  
ATOM    202  SG  CYS A  12      -4.388  -4.796 -10.080  1.00  0.00           S  
ATOM    203  H   CYS A  12      -2.548  -1.243  -8.552  1.00  0.00           H  
ATOM    204  HA  CYS A  12      -4.480  -1.981 -10.458  1.00  0.00           H  
ATOM    205  HB2 CYS A  12      -2.614  -3.395  -9.364  1.00  0.00           H  
ATOM    206  HB3 CYS A  12      -3.781  -3.680  -8.077  1.00  0.00           H  
ATOM    207  HG  CYS A  12      -5.297  -4.564 -10.282  1.00  0.00           H  
ATOM    208  N   ALA A  13      -5.587  -1.417  -7.460  1.00  0.00           N  
ATOM    209  CA  ALA A  13      -6.775  -1.281  -6.628  1.00  0.00           C  
ATOM    210  C   ALA A  13      -7.870  -0.451  -7.301  1.00  0.00           C  
ATOM    211  O   ALA A  13      -9.057  -0.696  -7.093  1.00  0.00           O  
ATOM    212  CB  ALA A  13      -6.387  -0.658  -5.298  1.00  0.00           C  
ATOM    213  H   ALA A  13      -4.724  -1.110  -7.108  1.00  0.00           H  
ATOM    214  HA  ALA A  13      -7.160  -2.271  -6.430  1.00  0.00           H  
ATOM    215  HB1 ALA A  13      -5.780  -1.357  -4.731  1.00  0.00           H  
ATOM    216  HB2 ALA A  13      -7.280  -0.419  -4.740  1.00  0.00           H  
ATOM    217  HB3 ALA A  13      -5.823   0.244  -5.482  1.00  0.00           H  
ATOM    218  N   VAL A  14      -7.492   0.523  -8.114  1.00  0.00           N  
ATOM    219  CA  VAL A  14      -8.492   1.346  -8.784  1.00  0.00           C  
ATOM    220  C   VAL A  14      -9.434   0.478  -9.609  1.00  0.00           C  
ATOM    221  O   VAL A  14     -10.645   0.696  -9.620  1.00  0.00           O  
ATOM    222  CB  VAL A  14      -7.843   2.394  -9.701  1.00  0.00           C  
ATOM    223  CG1 VAL A  14      -6.852   1.726 -10.630  1.00  0.00           C  
ATOM    224  CG2 VAL A  14      -8.903   3.155 -10.487  1.00  0.00           C  
ATOM    225  H   VAL A  14      -6.536   0.690  -8.270  1.00  0.00           H  
ATOM    226  HA  VAL A  14      -9.063   1.863  -8.025  1.00  0.00           H  
ATOM    227  HB  VAL A  14      -7.306   3.096  -9.084  1.00  0.00           H  
ATOM    228 HG11 VAL A  14      -7.258   1.700 -11.629  1.00  0.00           H  
ATOM    229 HG12 VAL A  14      -6.671   0.718 -10.285  1.00  0.00           H  
ATOM    230 HG13 VAL A  14      -5.925   2.280 -10.629  1.00  0.00           H  
ATOM    231 HG21 VAL A  14      -9.740   2.505 -10.692  1.00  0.00           H  
ATOM    232 HG22 VAL A  14      -8.481   3.500 -11.418  1.00  0.00           H  
ATOM    233 HG23 VAL A  14      -9.240   4.002  -9.909  1.00  0.00           H  
ATOM    234  N   GLN A  15      -8.871  -0.517 -10.283  1.00  0.00           N  
ATOM    235  CA  GLN A  15      -9.663  -1.428 -11.097  1.00  0.00           C  
ATOM    236  C   GLN A  15     -10.714  -2.099 -10.234  1.00  0.00           C  
ATOM    237  O   GLN A  15     -11.875  -2.225 -10.626  1.00  0.00           O  
ATOM    238  CB  GLN A  15      -8.768  -2.484 -11.750  1.00  0.00           C  
ATOM    239  CG  GLN A  15      -7.433  -1.941 -12.232  1.00  0.00           C  
ATOM    240  CD  GLN A  15      -7.239  -2.111 -13.725  1.00  0.00           C  
ATOM    241  OE1 GLN A  15      -7.364  -3.214 -14.257  1.00  0.00           O  
ATOM    242  NE2 GLN A  15      -6.929  -1.016 -14.409  1.00  0.00           N  
ATOM    243  H   GLN A  15      -7.909  -0.651 -10.218  1.00  0.00           H  
ATOM    244  HA  GLN A  15     -10.154  -0.851 -11.866  1.00  0.00           H  
ATOM    245  HB2 GLN A  15      -8.575  -3.269 -11.033  1.00  0.00           H  
ATOM    246  HB3 GLN A  15      -9.288  -2.904 -12.598  1.00  0.00           H  
ATOM    247  HG2 GLN A  15      -7.381  -0.888 -11.996  1.00  0.00           H  
ATOM    248  HG3 GLN A  15      -6.640  -2.464 -11.718  1.00  0.00           H  
ATOM    249 HE21 GLN A  15      -6.845  -0.172 -13.918  1.00  0.00           H  
ATOM    250 HE22 GLN A  15      -6.796  -1.097 -15.377  1.00  0.00           H  
ATOM    251  N   ALA A  16     -10.303  -2.501  -9.039  1.00  0.00           N  
ATOM    252  CA  ALA A  16     -11.207  -3.132  -8.099  1.00  0.00           C  
ATOM    253  C   ALA A  16     -12.223  -2.115  -7.617  1.00  0.00           C  
ATOM    254  O   ALA A  16     -13.392  -2.439  -7.401  1.00  0.00           O  
ATOM    255  CB  ALA A  16     -10.429  -3.719  -6.942  1.00  0.00           C  
ATOM    256  H   ALA A  16      -9.369  -2.347  -8.776  1.00  0.00           H  
ATOM    257  HA  ALA A  16     -11.726  -3.938  -8.604  1.00  0.00           H  
ATOM    258  HB1 ALA A  16     -10.722  -3.230  -6.025  1.00  0.00           H  
ATOM    259  HB2 ALA A  16      -9.371  -3.575  -7.106  1.00  0.00           H  
ATOM    260  HB3 ALA A  16     -10.644  -4.773  -6.873  1.00  0.00           H  
ATOM    261  N   LEU A  17     -11.778  -0.868  -7.489  1.00  0.00           N  
ATOM    262  CA  LEU A  17     -12.664   0.203  -7.078  1.00  0.00           C  
ATOM    263  C   LEU A  17     -13.776   0.328  -8.105  1.00  0.00           C  
ATOM    264  O   LEU A  17     -14.913   0.670  -7.777  1.00  0.00           O  
ATOM    265  CB  LEU A  17     -11.900   1.523  -6.957  1.00  0.00           C  
ATOM    266  CG  LEU A  17     -11.604   1.971  -5.525  1.00  0.00           C  
ATOM    267  CD1 LEU A  17     -11.137   3.418  -5.504  1.00  0.00           C  
ATOM    268  CD2 LEU A  17     -12.834   1.794  -4.647  1.00  0.00           C  
ATOM    269  H   LEU A  17     -10.843  -0.663  -7.705  1.00  0.00           H  
ATOM    270  HA  LEU A  17     -13.091  -0.058  -6.120  1.00  0.00           H  
ATOM    271  HB2 LEU A  17     -10.960   1.420  -7.481  1.00  0.00           H  
ATOM    272  HB3 LEU A  17     -12.479   2.296  -7.440  1.00  0.00           H  
ATOM    273  HG  LEU A  17     -10.811   1.359  -5.119  1.00  0.00           H  
ATOM    274 HD11 LEU A  17     -11.977   4.070  -5.691  1.00  0.00           H  
ATOM    275 HD12 LEU A  17     -10.389   3.566  -6.269  1.00  0.00           H  
ATOM    276 HD13 LEU A  17     -10.713   3.646  -4.537  1.00  0.00           H  
ATOM    277 HD21 LEU A  17     -12.711   2.360  -3.736  1.00  0.00           H  
ATOM    278 HD22 LEU A  17     -12.957   0.747  -4.407  1.00  0.00           H  
ATOM    279 HD23 LEU A  17     -13.707   2.146  -5.176  1.00  0.00           H  
ATOM    280  N   TYR A  18     -13.434   0.023  -9.356  1.00  0.00           N  
ATOM    281  CA  TYR A  18     -14.403   0.071 -10.444  1.00  0.00           C  
ATOM    282  C   TYR A  18     -15.410  -1.066 -10.301  1.00  0.00           C  
ATOM    283  O   TYR A  18     -16.595  -0.903 -10.593  1.00  0.00           O  
ATOM    284  CB  TYR A  18     -13.692  -0.023 -11.796  1.00  0.00           C  
ATOM    285  CG  TYR A  18     -14.562   0.376 -12.967  1.00  0.00           C  
ATOM    286  CD1 TYR A  18     -15.857   0.838 -12.769  1.00  0.00           C  
ATOM    287  CD2 TYR A  18     -14.088   0.290 -14.269  1.00  0.00           C  
ATOM    288  CE1 TYR A  18     -16.655   1.204 -13.837  1.00  0.00           C  
ATOM    289  CE2 TYR A  18     -14.880   0.654 -15.342  1.00  0.00           C  
ATOM    290  CZ  TYR A  18     -16.162   1.109 -15.120  1.00  0.00           C  
ATOM    291  OH  TYR A  18     -16.954   1.472 -16.186  1.00  0.00           O  
ATOM    292  H   TYR A  18     -12.506  -0.261  -9.548  1.00  0.00           H  
ATOM    293  HA  TYR A  18     -14.926   1.014 -10.383  1.00  0.00           H  
ATOM    294  HB2 TYR A  18     -12.830   0.627 -11.788  1.00  0.00           H  
ATOM    295  HB3 TYR A  18     -13.368  -1.042 -11.954  1.00  0.00           H  
ATOM    296  HD1 TYR A  18     -16.241   0.911 -11.761  1.00  0.00           H  
ATOM    297  HD2 TYR A  18     -13.083  -0.067 -14.440  1.00  0.00           H  
ATOM    298  HE1 TYR A  18     -17.659   1.561 -13.662  1.00  0.00           H  
ATOM    299  HE2 TYR A  18     -14.493   0.580 -16.348  1.00  0.00           H  
ATOM    300  HH  TYR A  18     -16.420   1.505 -16.984  1.00  0.00           H  
ATOM    301  N   SER A  19     -14.924  -2.218  -9.845  1.00  0.00           N  
ATOM    302  CA  SER A  19     -15.769  -3.393  -9.652  1.00  0.00           C  
ATOM    303  C   SER A  19     -16.807  -3.141  -8.562  1.00  0.00           C  
ATOM    304  O   SER A  19     -17.915  -3.672  -8.610  1.00  0.00           O  
ATOM    305  CB  SER A  19     -14.915  -4.608  -9.287  1.00  0.00           C  
ATOM    306  OG  SER A  19     -14.347  -5.197 -10.445  1.00  0.00           O  
ATOM    307  H   SER A  19     -13.970  -2.279  -9.629  1.00  0.00           H  
ATOM    308  HA  SER A  19     -16.282  -3.589 -10.582  1.00  0.00           H  
ATOM    309  HB2 SER A  19     -14.117  -4.300  -8.628  1.00  0.00           H  
ATOM    310  HB3 SER A  19     -15.531  -5.342  -8.790  1.00  0.00           H  
ATOM    311  HG  SER A  19     -14.369  -4.568 -11.169  1.00  0.00           H  
ATOM    312  N   TRP A  20     -16.434  -2.329  -7.580  1.00  0.00           N  
ATOM    313  CA  TRP A  20     -17.325  -2.004  -6.471  1.00  0.00           C  
ATOM    314  C   TRP A  20     -18.593  -1.327  -6.977  1.00  0.00           C  
ATOM    315  O   TRP A  20     -19.699  -1.655  -6.546  1.00  0.00           O  
ATOM    316  CB  TRP A  20     -16.606  -1.076  -5.490  1.00  0.00           C  
ATOM    317  CG  TRP A  20     -17.092  -1.198  -4.078  1.00  0.00           C  
ATOM    318  CD1 TRP A  20     -17.797  -2.233  -3.536  1.00  0.00           C  
ATOM    319  CD2 TRP A  20     -16.905  -0.242  -3.028  1.00  0.00           C  
ATOM    320  NE1 TRP A  20     -18.058  -1.981  -2.210  1.00  0.00           N  
ATOM    321  CE2 TRP A  20     -17.519  -0.764  -1.874  1.00  0.00           C  
ATOM    322  CE3 TRP A  20     -16.274   1.003  -2.952  1.00  0.00           C  
ATOM    323  CZ2 TRP A  20     -17.521  -0.081  -0.658  1.00  0.00           C  
ATOM    324  CZ3 TRP A  20     -16.277   1.679  -1.745  1.00  0.00           C  
ATOM    325  CH2 TRP A  20     -16.895   1.135  -0.614  1.00  0.00           C  
ATOM    326  H   TRP A  20     -15.535  -1.942  -7.597  1.00  0.00           H  
ATOM    327  HA  TRP A  20     -17.587  -2.921  -5.968  1.00  0.00           H  
ATOM    328  HB2 TRP A  20     -15.553  -1.304  -5.499  1.00  0.00           H  
ATOM    329  HB3 TRP A  20     -16.750  -0.054  -5.805  1.00  0.00           H  
ATOM    330  HD1 TRP A  20     -18.098  -3.115  -4.080  1.00  0.00           H  
ATOM    331  HE1 TRP A  20     -18.547  -2.575  -1.603  1.00  0.00           H  
ATOM    332  HE3 TRP A  20     -15.791   1.438  -3.814  1.00  0.00           H  
ATOM    333  HZ2 TRP A  20     -17.990  -0.485   0.227  1.00  0.00           H  
ATOM    334  HZ3 TRP A  20     -15.795   2.642  -1.669  1.00  0.00           H  
ATOM    335  HH2 TRP A  20     -16.874   1.699   0.307  1.00  0.00           H  
ATOM    336  N   GLN A  21     -18.425  -0.381  -7.893  1.00  0.00           N  
ATOM    337  CA  GLN A  21     -19.551   0.348  -8.460  1.00  0.00           C  
ATOM    338  C   GLN A  21     -20.510  -0.592  -9.187  1.00  0.00           C  
ATOM    339  O   GLN A  21     -21.719  -0.560  -8.957  1.00  0.00           O  
ATOM    340  CB  GLN A  21     -19.046   1.422  -9.422  1.00  0.00           C  
ATOM    341  CG  GLN A  21     -20.155   2.234 -10.068  1.00  0.00           C  
ATOM    342  CD  GLN A  21     -20.029   2.294 -11.578  1.00  0.00           C  
ATOM    343  OE1 GLN A  21     -19.582   1.340 -12.213  1.00  0.00           O  
ATOM    344  NE2 GLN A  21     -20.422   3.422 -12.160  1.00  0.00           N  
ATOM    345  H   GLN A  21     -17.518  -0.164  -8.193  1.00  0.00           H  
ATOM    346  HA  GLN A  21     -20.081   0.825  -7.648  1.00  0.00           H  
ATOM    347  HB2 GLN A  21     -18.402   2.100  -8.882  1.00  0.00           H  
ATOM    348  HB3 GLN A  21     -18.475   0.946 -10.206  1.00  0.00           H  
ATOM    349  HG2 GLN A  21     -21.105   1.784  -9.819  1.00  0.00           H  
ATOM    350  HG3 GLN A  21     -20.120   3.238  -9.676  1.00  0.00           H  
ATOM    351 HE21 GLN A  21     -20.766   4.141 -11.592  1.00  0.00           H  
ATOM    352 HE22 GLN A  21     -20.352   3.487 -13.135  1.00  0.00           H  
ATOM    353  N   LEU A  22     -19.964  -1.423 -10.070  1.00  0.00           N  
ATOM    354  CA  LEU A  22     -20.774  -2.365 -10.837  1.00  0.00           C  
ATOM    355  C   LEU A  22     -21.153  -3.586 -10.003  1.00  0.00           C  
ATOM    356  O   LEU A  22     -22.318  -3.981  -9.959  1.00  0.00           O  
ATOM    357  CB  LEU A  22     -20.022  -2.807 -12.093  1.00  0.00           C  
ATOM    358  CG  LEU A  22     -19.708  -1.687 -13.087  1.00  0.00           C  
ATOM    359  CD1 LEU A  22     -19.426  -2.262 -14.467  1.00  0.00           C  
ATOM    360  CD2 LEU A  22     -20.856  -0.690 -13.148  1.00  0.00           C  
ATOM    361  H   LEU A  22     -18.995  -1.398 -10.214  1.00  0.00           H  
ATOM    362  HA  LEU A  22     -21.678  -1.854 -11.133  1.00  0.00           H  
ATOM    363  HB2 LEU A  22     -19.090  -3.261 -11.788  1.00  0.00           H  
ATOM    364  HB3 LEU A  22     -20.616  -3.550 -12.601  1.00  0.00           H  
ATOM    365  HG  LEU A  22     -18.824  -1.160 -12.759  1.00  0.00           H  
ATOM    366 HD11 LEU A  22     -19.546  -3.335 -14.441  1.00  0.00           H  
ATOM    367 HD12 LEU A  22     -18.416  -2.019 -14.759  1.00  0.00           H  
ATOM    368 HD13 LEU A  22     -20.118  -1.839 -15.181  1.00  0.00           H  
ATOM    369 HD21 LEU A  22     -20.552   0.175 -13.718  1.00  0.00           H  
ATOM    370 HD22 LEU A  22     -21.120  -0.386 -12.145  1.00  0.00           H  
ATOM    371 HD23 LEU A  22     -21.709  -1.153 -13.621  1.00  0.00           H  
ATOM    372  N   SER A  23     -20.163  -4.185  -9.351  1.00  0.00           N  
ATOM    373  CA  SER A  23     -20.395  -5.369  -8.527  1.00  0.00           C  
ATOM    374  C   SER A  23     -21.124  -5.009  -7.238  1.00  0.00           C  
ATOM    375  O   SER A  23     -22.110  -5.650  -6.871  1.00  0.00           O  
ATOM    376  CB  SER A  23     -19.067  -6.054  -8.200  1.00  0.00           C  
ATOM    377  OG  SER A  23     -19.281  -7.330  -7.623  1.00  0.00           O  
ATOM    378  H   SER A  23     -19.253  -3.829  -9.430  1.00  0.00           H  
ATOM    379  HA  SER A  23     -21.010  -6.050  -9.096  1.00  0.00           H  
ATOM    380  HB2 SER A  23     -18.494  -6.176  -9.107  1.00  0.00           H  
ATOM    381  HB3 SER A  23     -18.511  -5.445  -7.503  1.00  0.00           H  
ATOM    382  HG  SER A  23     -20.204  -7.419  -7.376  1.00  0.00           H  
ATOM    383  N   GLN A  24     -20.637  -3.981  -6.552  1.00  0.00           N  
ATOM    384  CA  GLN A  24     -21.245  -3.539  -5.302  1.00  0.00           C  
ATOM    385  C   GLN A  24     -21.091  -4.595  -4.211  1.00  0.00           C  
ATOM    386  O   GLN A  24     -21.669  -4.473  -3.132  1.00  0.00           O  
ATOM    387  CB  GLN A  24     -22.726  -3.223  -5.517  1.00  0.00           C  
ATOM    388  CG  GLN A  24     -22.987  -2.298  -6.695  1.00  0.00           C  
ATOM    389  CD  GLN A  24     -24.406  -1.765  -6.713  1.00  0.00           C  
ATOM    390  OE1 GLN A  24     -25.345  -2.478  -7.063  1.00  0.00           O  
ATOM    391  NE2 GLN A  24     -24.569  -0.503  -6.333  1.00  0.00           N  
ATOM    392  H   GLN A  24     -19.848  -3.510  -6.894  1.00  0.00           H  
ATOM    393  HA  GLN A  24     -20.737  -2.639  -4.988  1.00  0.00           H  
ATOM    394  HB2 GLN A  24     -23.258  -4.147  -5.689  1.00  0.00           H  
ATOM    395  HB3 GLN A  24     -23.115  -2.755  -4.625  1.00  0.00           H  
ATOM    396  HG2 GLN A  24     -22.306  -1.462  -6.636  1.00  0.00           H  
ATOM    397  HG3 GLN A  24     -22.810  -2.844  -7.610  1.00  0.00           H  
ATOM    398 HE21 GLN A  24     -23.774   0.006  -6.066  1.00  0.00           H  
ATOM    399 HE22 GLN A  24     -25.476  -0.132  -6.335  1.00  0.00           H  
ATOM    400  N   ASN A  25     -20.308  -5.632  -4.497  1.00  0.00           N  
ATOM    401  CA  ASN A  25     -20.081  -6.705  -3.535  1.00  0.00           C  
ATOM    402  C   ASN A  25     -19.562  -6.147  -2.213  1.00  0.00           C  
ATOM    403  O   ASN A  25     -19.730  -4.962  -1.926  1.00  0.00           O  
ATOM    404  CB  ASN A  25     -19.087  -7.723  -4.098  1.00  0.00           C  
ATOM    405  CG  ASN A  25     -19.441  -9.148  -3.722  1.00  0.00           C  
ATOM    406  OD1 ASN A  25     -20.609  -9.537  -3.747  1.00  0.00           O  
ATOM    407  ND2 ASN A  25     -18.432  -9.936  -3.371  1.00  0.00           N  
ATOM    408  H   ASN A  25     -19.871  -5.676  -5.373  1.00  0.00           H  
ATOM    409  HA  ASN A  25     -21.025  -7.199  -3.358  1.00  0.00           H  
ATOM    410  HB2 ASN A  25     -19.074  -7.647  -5.175  1.00  0.00           H  
ATOM    411  HB3 ASN A  25     -18.100  -7.504  -3.714  1.00  0.00           H  
ATOM    412 HD21 ASN A  25     -17.527  -9.559  -3.372  1.00  0.00           H  
ATOM    413 HD22 ASN A  25     -18.633 -10.863  -3.123  1.00  0.00           H  
ATOM    414  N   ASP A  26     -18.929  -7.002  -1.415  1.00  0.00           N  
ATOM    415  CA  ASP A  26     -18.386  -6.580  -0.129  1.00  0.00           C  
ATOM    416  C   ASP A  26     -17.710  -5.217  -0.255  1.00  0.00           C  
ATOM    417  O   ASP A  26     -18.376  -4.183  -0.204  1.00  0.00           O  
ATOM    418  CB  ASP A  26     -17.393  -7.619   0.398  1.00  0.00           C  
ATOM    419  CG  ASP A  26     -18.065  -8.927   0.768  1.00  0.00           C  
ATOM    420  OD1 ASP A  26     -18.668  -8.997   1.859  1.00  0.00           O  
ATOM    421  OD2 ASP A  26     -17.990  -9.881  -0.035  1.00  0.00           O  
ATOM    422  H   ASP A  26     -18.822  -7.934  -1.699  1.00  0.00           H  
ATOM    423  HA  ASP A  26     -19.209  -6.496   0.566  1.00  0.00           H  
ATOM    424  HB2 ASP A  26     -16.653  -7.819  -0.361  1.00  0.00           H  
ATOM    425  HB3 ASP A  26     -16.902  -7.226   1.278  1.00  0.00           H  
ATOM    426  N   ILE A  27     -16.389  -5.218  -0.437  1.00  0.00           N  
ATOM    427  CA  ILE A  27     -15.639  -3.976  -0.590  1.00  0.00           C  
ATOM    428  C   ILE A  27     -14.182  -4.142  -0.178  1.00  0.00           C  
ATOM    429  O   ILE A  27     -13.278  -4.023  -1.006  1.00  0.00           O  
ATOM    430  CB  ILE A  27     -16.258  -2.828   0.231  1.00  0.00           C  
ATOM    431  CG1 ILE A  27     -15.247  -1.693   0.412  1.00  0.00           C  
ATOM    432  CG2 ILE A  27     -16.730  -3.338   1.583  1.00  0.00           C  
ATOM    433  CD1 ILE A  27     -14.556  -1.284  -0.870  1.00  0.00           C  
ATOM    434  H   ILE A  27     -15.913  -6.072  -0.483  1.00  0.00           H  
ATOM    435  HA  ILE A  27     -15.673  -3.709  -1.636  1.00  0.00           H  
ATOM    436  HB  ILE A  27     -17.117  -2.454  -0.302  1.00  0.00           H  
ATOM    437 HG12 ILE A  27     -15.758  -0.826   0.804  1.00  0.00           H  
ATOM    438 HG13 ILE A  27     -14.489  -2.005   1.115  1.00  0.00           H  
ATOM    439 HG21 ILE A  27     -16.176  -2.843   2.368  1.00  0.00           H  
ATOM    440 HG22 ILE A  27     -16.564  -4.403   1.643  1.00  0.00           H  
ATOM    441 HG23 ILE A  27     -17.783  -3.130   1.699  1.00  0.00           H  
ATOM    442 HD11 ILE A  27     -15.223  -0.676  -1.460  1.00  0.00           H  
ATOM    443 HD12 ILE A  27     -14.281  -2.166  -1.429  1.00  0.00           H  
ATOM    444 HD13 ILE A  27     -13.669  -0.718  -0.632  1.00  0.00           H  
ATOM    445  N   ALA A  28     -13.948  -4.410   1.098  1.00  0.00           N  
ATOM    446  CA  ALA A  28     -12.589  -4.585   1.581  1.00  0.00           C  
ATOM    447  C   ALA A  28     -11.935  -5.774   0.895  1.00  0.00           C  
ATOM    448  O   ALA A  28     -10.854  -5.660   0.316  1.00  0.00           O  
ATOM    449  CB  ALA A  28     -12.582  -4.770   3.091  1.00  0.00           C  
ATOM    450  H   ALA A  28     -14.698  -4.492   1.722  1.00  0.00           H  
ATOM    451  HA  ALA A  28     -12.033  -3.693   1.347  1.00  0.00           H  
ATOM    452  HB1 ALA A  28     -12.081  -5.694   3.337  1.00  0.00           H  
ATOM    453  HB2 ALA A  28     -13.599  -4.805   3.453  1.00  0.00           H  
ATOM    454  HB3 ALA A  28     -12.063  -3.944   3.553  1.00  0.00           H  
ATOM    455  N   ASP A  29     -12.606  -6.914   0.964  1.00  0.00           N  
ATOM    456  CA  ASP A  29     -12.113  -8.139   0.355  1.00  0.00           C  
ATOM    457  C   ASP A  29     -12.261  -8.134  -1.168  1.00  0.00           C  
ATOM    458  O   ASP A  29     -11.414  -8.676  -1.874  1.00  0.00           O  
ATOM    459  CB  ASP A  29     -12.849  -9.345   0.938  1.00  0.00           C  
ATOM    460  CG  ASP A  29     -14.298  -9.406   0.495  1.00  0.00           C  
ATOM    461  OD1 ASP A  29     -14.559  -9.918  -0.614  1.00  0.00           O  
ATOM    462  OD2 ASP A  29     -15.172  -8.943   1.258  1.00  0.00           O  
ATOM    463  H   ASP A  29     -13.462  -6.931   1.439  1.00  0.00           H  
ATOM    464  HA  ASP A  29     -11.065  -8.226   0.598  1.00  0.00           H  
ATOM    465  HB2 ASP A  29     -12.356 -10.250   0.617  1.00  0.00           H  
ATOM    466  HB3 ASP A  29     -12.823  -9.288   2.015  1.00  0.00           H  
ATOM    467  N   VAL A  30     -13.360  -7.568  -1.668  1.00  0.00           N  
ATOM    468  CA  VAL A  30     -13.628  -7.564  -3.109  1.00  0.00           C  
ATOM    469  C   VAL A  30     -12.557  -6.860  -3.933  1.00  0.00           C  
ATOM    470  O   VAL A  30     -12.039  -7.426  -4.896  1.00  0.00           O  
ATOM    471  CB  VAL A  30     -14.980  -6.892  -3.444  1.00  0.00           C  
ATOM    472  CG1 VAL A  30     -14.970  -5.429  -3.049  1.00  0.00           C  
ATOM    473  CG2 VAL A  30     -15.288  -7.035  -4.929  1.00  0.00           C  
ATOM    474  H   VAL A  30     -14.021  -7.182  -1.056  1.00  0.00           H  
ATOM    475  HA  VAL A  30     -13.687  -8.593  -3.429  1.00  0.00           H  
ATOM    476  HB  VAL A  30     -15.760  -7.378  -2.882  1.00  0.00           H  
ATOM    477 HG11 VAL A  30     -14.497  -4.848  -3.828  1.00  0.00           H  
ATOM    478 HG12 VAL A  30     -14.424  -5.316  -2.132  1.00  0.00           H  
ATOM    479 HG13 VAL A  30     -15.984  -5.085  -2.911  1.00  0.00           H  
ATOM    480 HG21 VAL A  30     -16.323  -6.782  -5.109  1.00  0.00           H  
ATOM    481 HG22 VAL A  30     -15.108  -8.053  -5.239  1.00  0.00           H  
ATOM    482 HG23 VAL A  30     -14.651  -6.367  -5.497  1.00  0.00           H  
ATOM    483  N   GLU A  31     -12.245  -5.621  -3.586  1.00  0.00           N  
ATOM    484  CA  GLU A  31     -11.274  -4.857  -4.352  1.00  0.00           C  
ATOM    485  C   GLU A  31      -9.942  -5.584  -4.486  1.00  0.00           C  
ATOM    486  O   GLU A  31      -9.427  -5.774  -5.586  1.00  0.00           O  
ATOM    487  CB  GLU A  31     -11.064  -3.481  -3.710  1.00  0.00           C  
ATOM    488  CG  GLU A  31      -9.615  -3.159  -3.375  1.00  0.00           C  
ATOM    489  CD  GLU A  31      -8.725  -3.102  -4.594  1.00  0.00           C  
ATOM    490  OE1 GLU A  31      -8.965  -2.235  -5.450  1.00  0.00           O  
ATOM    491  OE2 GLU A  31      -7.790  -3.924  -4.691  1.00  0.00           O  
ATOM    492  H   GLU A  31     -12.696  -5.202  -2.824  1.00  0.00           H  
ATOM    493  HA  GLU A  31     -11.690  -4.717  -5.335  1.00  0.00           H  
ATOM    494  HB2 GLU A  31     -11.430  -2.723  -4.386  1.00  0.00           H  
ATOM    495  HB3 GLU A  31     -11.638  -3.436  -2.795  1.00  0.00           H  
ATOM    496  HG2 GLU A  31      -9.582  -2.198  -2.890  1.00  0.00           H  
ATOM    497  HG3 GLU A  31      -9.235  -3.912  -2.702  1.00  0.00           H  
ATOM    498  N   TYR A  32      -9.379  -5.966  -3.365  1.00  0.00           N  
ATOM    499  CA  TYR A  32      -8.098  -6.643  -3.350  1.00  0.00           C  
ATOM    500  C   TYR A  32      -8.177  -8.063  -3.906  1.00  0.00           C  
ATOM    501  O   TYR A  32      -7.171  -8.608  -4.358  1.00  0.00           O  
ATOM    502  CB  TYR A  32      -7.511  -6.597  -1.948  1.00  0.00           C  
ATOM    503  CG  TYR A  32      -7.187  -5.181  -1.525  1.00  0.00           C  
ATOM    504  CD1 TYR A  32      -6.004  -4.570  -1.922  1.00  0.00           C  
ATOM    505  CD2 TYR A  32      -8.070  -4.446  -0.748  1.00  0.00           C  
ATOM    506  CE1 TYR A  32      -5.713  -3.270  -1.549  1.00  0.00           C  
ATOM    507  CE2 TYR A  32      -7.780  -3.152  -0.372  1.00  0.00           C  
ATOM    508  CZ  TYR A  32      -6.603  -2.569  -0.773  1.00  0.00           C  
ATOM    509  OH  TYR A  32      -6.317  -1.276  -0.401  1.00  0.00           O  
ATOM    510  H   TYR A  32      -9.826  -5.772  -2.514  1.00  0.00           H  
ATOM    511  HA  TYR A  32      -7.445  -6.078  -3.999  1.00  0.00           H  
ATOM    512  HB2 TYR A  32      -8.224  -7.008  -1.246  1.00  0.00           H  
ATOM    513  HB3 TYR A  32      -6.600  -7.176  -1.919  1.00  0.00           H  
ATOM    514  HD1 TYR A  32      -5.304  -5.126  -2.527  1.00  0.00           H  
ATOM    515  HD2 TYR A  32      -8.996  -4.903  -0.431  1.00  0.00           H  
ATOM    516  HE1 TYR A  32      -4.793  -2.810  -1.865  1.00  0.00           H  
ATOM    517  HE2 TYR A  32      -8.472  -2.606   0.240  1.00  0.00           H  
ATOM    518  HH  TYR A  32      -6.011  -0.782  -1.166  1.00  0.00           H  
ATOM    519  N   GLN A  33      -9.365  -8.667  -3.878  1.00  0.00           N  
ATOM    520  CA  GLN A  33      -9.523 -10.025  -4.392  1.00  0.00           C  
ATOM    521  C   GLN A  33      -9.157 -10.081  -5.871  1.00  0.00           C  
ATOM    522  O   GLN A  33      -8.686 -11.104  -6.367  1.00  0.00           O  
ATOM    523  CB  GLN A  33     -10.952 -10.524  -4.189  1.00  0.00           C  
ATOM    524  CG  GLN A  33     -11.934  -9.995  -5.223  1.00  0.00           C  
ATOM    525  CD  GLN A  33     -12.424 -11.077  -6.166  1.00  0.00           C  
ATOM    526  OE1 GLN A  33     -11.655 -11.933  -6.601  1.00  0.00           O  
ATOM    527  NE2 GLN A  33     -13.713 -11.042  -6.487  1.00  0.00           N  
ATOM    528  H   GLN A  33     -10.148  -8.191  -3.516  1.00  0.00           H  
ATOM    529  HA  GLN A  33      -8.846 -10.665  -3.844  1.00  0.00           H  
ATOM    530  HB2 GLN A  33     -10.955 -11.602  -4.241  1.00  0.00           H  
ATOM    531  HB3 GLN A  33     -11.291 -10.220  -3.212  1.00  0.00           H  
ATOM    532  HG2 GLN A  33     -12.785  -9.574  -4.712  1.00  0.00           H  
ATOM    533  HG3 GLN A  33     -11.445  -9.226  -5.803  1.00  0.00           H  
ATOM    534 HE21 GLN A  33     -14.266 -10.330  -6.102  1.00  0.00           H  
ATOM    535 HE22 GLN A  33     -14.057 -11.729  -7.095  1.00  0.00           H  
ATOM    536  N   PHE A  34      -9.370  -8.969  -6.567  1.00  0.00           N  
ATOM    537  CA  PHE A  34      -9.056  -8.884  -7.987  1.00  0.00           C  
ATOM    538  C   PHE A  34      -7.588  -9.208  -8.224  1.00  0.00           C  
ATOM    539  O   PHE A  34      -7.233  -9.877  -9.194  1.00  0.00           O  
ATOM    540  CB  PHE A  34      -9.368  -7.480  -8.507  1.00  0.00           C  
ATOM    541  CG  PHE A  34      -8.870  -7.224  -9.902  1.00  0.00           C  
ATOM    542  CD1 PHE A  34      -7.511  -7.183 -10.169  1.00  0.00           C  
ATOM    543  CD2 PHE A  34      -9.760  -7.021 -10.944  1.00  0.00           C  
ATOM    544  CE1 PHE A  34      -7.049  -6.944 -11.449  1.00  0.00           C  
ATOM    545  CE2 PHE A  34      -9.303  -6.781 -12.227  1.00  0.00           C  
ATOM    546  CZ  PHE A  34      -7.946  -6.743 -12.479  1.00  0.00           C  
ATOM    547  H   PHE A  34      -9.743  -8.185  -6.113  1.00  0.00           H  
ATOM    548  HA  PHE A  34      -9.664  -9.601  -8.514  1.00  0.00           H  
ATOM    549  HB2 PHE A  34     -10.435  -7.334  -8.504  1.00  0.00           H  
ATOM    550  HB3 PHE A  34      -8.909  -6.753  -7.852  1.00  0.00           H  
ATOM    551  HD1 PHE A  34      -6.809  -7.341  -9.364  1.00  0.00           H  
ATOM    552  HD2 PHE A  34     -10.822  -7.049 -10.747  1.00  0.00           H  
ATOM    553  HE1 PHE A  34      -5.987  -6.915 -11.644  1.00  0.00           H  
ATOM    554  HE2 PHE A  34     -10.008  -6.624 -13.030  1.00  0.00           H  
ATOM    555  HZ  PHE A  34      -7.587  -6.556 -13.480  1.00  0.00           H  
ATOM    556  N   LEU A  35      -6.742  -8.729  -7.322  1.00  0.00           N  
ATOM    557  CA  LEU A  35      -5.306  -8.961  -7.417  1.00  0.00           C  
ATOM    558  C   LEU A  35      -4.992 -10.454  -7.360  1.00  0.00           C  
ATOM    559  O   LEU A  35      -4.261 -10.977  -8.200  1.00  0.00           O  
ATOM    560  CB  LEU A  35      -4.574  -8.233  -6.286  1.00  0.00           C  
ATOM    561  CG  LEU A  35      -5.005  -6.783  -6.063  1.00  0.00           C  
ATOM    562  CD1 LEU A  35      -4.690  -6.347  -4.640  1.00  0.00           C  
ATOM    563  CD2 LEU A  35      -4.325  -5.867  -7.068  1.00  0.00           C  
ATOM    564  H   LEU A  35      -7.094  -8.205  -6.573  1.00  0.00           H  
ATOM    565  HA  LEU A  35      -4.967  -8.570  -8.364  1.00  0.00           H  
ATOM    566  HB2 LEU A  35      -4.738  -8.782  -5.369  1.00  0.00           H  
ATOM    567  HB3 LEU A  35      -3.518  -8.241  -6.507  1.00  0.00           H  
ATOM    568  HG  LEU A  35      -6.072  -6.703  -6.206  1.00  0.00           H  
ATOM    569 HD11 LEU A  35      -5.374  -6.828  -3.955  1.00  0.00           H  
ATOM    570 HD12 LEU A  35      -4.795  -5.274  -4.560  1.00  0.00           H  
ATOM    571 HD13 LEU A  35      -3.677  -6.628  -4.392  1.00  0.00           H  
ATOM    572 HD21 LEU A  35      -4.417  -6.288  -8.058  1.00  0.00           H  
ATOM    573 HD22 LEU A  35      -3.280  -5.767  -6.815  1.00  0.00           H  
ATOM    574 HD23 LEU A  35      -4.796  -4.895  -7.046  1.00  0.00           H  
ATOM    575  N   ALA A  36      -5.552 -11.132  -6.363  1.00  0.00           N  
ATOM    576  CA  ALA A  36      -5.333 -12.564  -6.196  1.00  0.00           C  
ATOM    577  C   ALA A  36      -5.942 -13.351  -7.350  1.00  0.00           C  
ATOM    578  O   ALA A  36      -5.390 -14.362  -7.784  1.00  0.00           O  
ATOM    579  CB  ALA A  36      -5.915 -13.033  -4.870  1.00  0.00           C  
ATOM    580  H   ALA A  36      -6.125 -10.657  -5.725  1.00  0.00           H  
ATOM    581  HA  ALA A  36      -4.268 -12.737  -6.176  1.00  0.00           H  
ATOM    582  HB1 ALA A  36      -5.750 -14.095  -4.761  1.00  0.00           H  
ATOM    583  HB2 ALA A  36      -6.975 -12.828  -4.849  1.00  0.00           H  
ATOM    584  HB3 ALA A  36      -5.430 -12.509  -4.060  1.00  0.00           H  
ATOM    585  N   GLU A  37      -7.083 -12.881  -7.845  1.00  0.00           N  
ATOM    586  CA  GLU A  37      -7.766 -13.543  -8.950  1.00  0.00           C  
ATOM    587  C   GLU A  37      -7.023 -13.316 -10.263  1.00  0.00           C  
ATOM    588  O   GLU A  37      -6.283 -12.343 -10.409  1.00  0.00           O  
ATOM    589  CB  GLU A  37      -9.203 -13.032  -9.069  1.00  0.00           C  
ATOM    590  CG  GLU A  37     -10.178 -13.736  -8.140  1.00  0.00           C  
ATOM    591  CD  GLU A  37     -11.615 -13.622  -8.608  1.00  0.00           C  
ATOM    592  OE1 GLU A  37     -11.867 -12.878  -9.579  1.00  0.00           O  
ATOM    593  OE2 GLU A  37     -12.490 -14.277  -8.003  1.00  0.00           O  
ATOM    594  H   GLU A  37      -7.474 -12.071  -7.458  1.00  0.00           H  
ATOM    595  HA  GLU A  37      -7.786 -14.602  -8.741  1.00  0.00           H  
ATOM    596  HB2 GLU A  37      -9.218 -11.977  -8.840  1.00  0.00           H  
ATOM    597  HB3 GLU A  37      -9.541 -13.174 -10.085  1.00  0.00           H  
ATOM    598  HG2 GLU A  37      -9.915 -14.782  -8.088  1.00  0.00           H  
ATOM    599  HG3 GLU A  37     -10.098 -13.297  -7.156  1.00  0.00           H  
ATOM    600  N   GLN A  38      -7.225 -14.220 -11.215  1.00  0.00           N  
ATOM    601  CA  GLN A  38      -6.575 -14.118 -12.516  1.00  0.00           C  
ATOM    602  C   GLN A  38      -5.058 -14.081 -12.364  1.00  0.00           C  
ATOM    603  O   GLN A  38      -4.343 -13.630 -13.260  1.00  0.00           O  
ATOM    604  CB  GLN A  38      -7.055 -12.868 -13.254  1.00  0.00           C  
ATOM    605  CG  GLN A  38      -8.472 -12.453 -12.889  1.00  0.00           C  
ATOM    606  CD  GLN A  38      -8.741 -10.988 -13.169  1.00  0.00           C  
ATOM    607  OE1 GLN A  38      -8.100 -10.107 -12.597  1.00  0.00           O  
ATOM    608  NE2 GLN A  38      -9.693 -10.720 -14.055  1.00  0.00           N  
ATOM    609  H   GLN A  38      -7.827 -14.973 -11.040  1.00  0.00           H  
ATOM    610  HA  GLN A  38      -6.845 -14.991 -13.092  1.00  0.00           H  
ATOM    611  HB2 GLN A  38      -6.392 -12.048 -13.021  1.00  0.00           H  
ATOM    612  HB3 GLN A  38      -7.021 -13.055 -14.317  1.00  0.00           H  
ATOM    613  HG2 GLN A  38      -9.166 -13.047 -13.464  1.00  0.00           H  
ATOM    614  HG3 GLN A  38      -8.627 -12.638 -11.836  1.00  0.00           H  
ATOM    615 HE21 GLN A  38     -10.163 -11.473 -14.472  1.00  0.00           H  
ATOM    616 HE22 GLN A  38      -9.888  -9.781 -14.257  1.00  0.00           H  
ATOM    617  N   ASP A  39      -4.572 -14.561 -11.224  1.00  0.00           N  
ATOM    618  CA  ASP A  39      -3.139 -14.583 -10.952  1.00  0.00           C  
ATOM    619  C   ASP A  39      -2.458 -13.338 -11.511  1.00  0.00           C  
ATOM    620  O   ASP A  39      -2.063 -13.305 -12.677  1.00  0.00           O  
ATOM    621  CB  ASP A  39      -2.505 -15.839 -11.555  1.00  0.00           C  
ATOM    622  CG  ASP A  39      -3.540 -16.868 -11.967  1.00  0.00           C  
ATOM    623  OD1 ASP A  39      -4.268 -17.365 -11.082  1.00  0.00           O  
ATOM    624  OD2 ASP A  39      -3.622 -17.176 -13.175  1.00  0.00           O  
ATOM    625  H   ASP A  39      -5.191 -14.907 -10.549  1.00  0.00           H  
ATOM    626  HA  ASP A  39      -3.005 -14.602  -9.881  1.00  0.00           H  
ATOM    627  HB2 ASP A  39      -1.933 -15.562 -12.427  1.00  0.00           H  
ATOM    628  HB3 ASP A  39      -1.848 -16.288 -10.825  1.00  0.00           H  
ATOM    629  N   VAL A  40      -2.324 -12.316 -10.672  1.00  0.00           N  
ATOM    630  CA  VAL A  40      -1.690 -11.070 -11.082  1.00  0.00           C  
ATOM    631  C   VAL A  40      -0.210 -11.060 -10.715  1.00  0.00           C  
ATOM    632  O   VAL A  40       0.239 -10.229  -9.926  1.00  0.00           O  
ATOM    633  CB  VAL A  40      -2.374  -9.851 -10.436  1.00  0.00           C  
ATOM    634  CG1 VAL A  40      -1.688  -8.563 -10.864  1.00  0.00           C  
ATOM    635  CG2 VAL A  40      -3.853  -9.819 -10.789  1.00  0.00           C  
ATOM    636  H   VAL A  40      -2.658 -12.404  -9.755  1.00  0.00           H  
ATOM    637  HA  VAL A  40      -1.785 -10.984 -12.155  1.00  0.00           H  
ATOM    638  HB  VAL A  40      -2.285  -9.940  -9.363  1.00  0.00           H  
ATOM    639 HG11 VAL A  40      -2.333  -8.018 -11.537  1.00  0.00           H  
ATOM    640 HG12 VAL A  40      -0.761  -8.799 -11.365  1.00  0.00           H  
ATOM    641 HG13 VAL A  40      -1.483  -7.958  -9.993  1.00  0.00           H  
ATOM    642 HG21 VAL A  40      -4.410  -9.391  -9.969  1.00  0.00           H  
ATOM    643 HG22 VAL A  40      -4.201 -10.826 -10.974  1.00  0.00           H  
ATOM    644 HG23 VAL A  40      -3.999  -9.219 -11.676  1.00  0.00           H  
ATOM    645  N   LYS A  41       0.544 -11.992 -11.290  1.00  0.00           N  
ATOM    646  CA  LYS A  41       1.973 -12.091 -11.022  1.00  0.00           C  
ATOM    647  C   LYS A  41       2.228 -12.750  -9.671  1.00  0.00           C  
ATOM    648  O   LYS A  41       3.336 -12.688  -9.137  1.00  0.00           O  
ATOM    649  CB  LYS A  41       2.617 -10.704 -11.057  1.00  0.00           C  
ATOM    650  CG  LYS A  41       4.044 -10.708 -11.581  1.00  0.00           C  
ATOM    651  CD  LYS A  41       4.796  -9.456 -11.161  1.00  0.00           C  
ATOM    652  CE  LYS A  41       4.706  -8.371 -12.222  1.00  0.00           C  
ATOM    653  NZ  LYS A  41       3.858  -7.230 -11.778  1.00  0.00           N  
ATOM    654  H   LYS A  41       0.127 -12.627 -11.910  1.00  0.00           H  
ATOM    655  HA  LYS A  41       2.413 -12.701 -11.797  1.00  0.00           H  
ATOM    656  HB2 LYS A  41       2.026 -10.059 -11.690  1.00  0.00           H  
ATOM    657  HB3 LYS A  41       2.627 -10.299 -10.055  1.00  0.00           H  
ATOM    658  HG2 LYS A  41       4.559 -11.573 -11.190  1.00  0.00           H  
ATOM    659  HG3 LYS A  41       4.020 -10.758 -12.661  1.00  0.00           H  
ATOM    660  HD2 LYS A  41       4.370  -9.083 -10.242  1.00  0.00           H  
ATOM    661  HD3 LYS A  41       5.835  -9.708 -11.004  1.00  0.00           H  
ATOM    662  HE2 LYS A  41       5.701  -8.006 -12.432  1.00  0.00           H  
ATOM    663  HE3 LYS A  41       4.282  -8.795 -13.120  1.00  0.00           H  
ATOM    664  HZ1 LYS A  41       4.430  -6.364 -11.711  1.00  0.00           H  
ATOM    665  HZ2 LYS A  41       3.444  -7.432 -10.846  1.00  0.00           H  
ATOM    666  HZ3 LYS A  41       3.088  -7.071 -12.459  1.00  0.00           H  
ATOM    667  N   ASP A  42       1.195 -13.384  -9.124  1.00  0.00           N  
ATOM    668  CA  ASP A  42       1.307 -14.056  -7.835  1.00  0.00           C  
ATOM    669  C   ASP A  42       2.032 -13.176  -6.822  1.00  0.00           C  
ATOM    670  O   ASP A  42       3.258 -13.206  -6.723  1.00  0.00           O  
ATOM    671  CB  ASP A  42       2.046 -15.386  -7.992  1.00  0.00           C  
ATOM    672  CG  ASP A  42       1.365 -16.313  -8.980  1.00  0.00           C  
ATOM    673  OD1 ASP A  42       1.005 -15.846 -10.081  1.00  0.00           O  
ATOM    674  OD2 ASP A  42       1.191 -17.506  -8.653  1.00  0.00           O  
ATOM    675  H   ASP A  42       0.338 -13.399  -9.599  1.00  0.00           H  
ATOM    676  HA  ASP A  42       0.308 -14.250  -7.475  1.00  0.00           H  
ATOM    677  HB2 ASP A  42       3.050 -15.195  -8.340  1.00  0.00           H  
ATOM    678  HB3 ASP A  42       2.090 -15.881  -7.034  1.00  0.00           H  
ATOM    679  N   VAL A  43       1.265 -12.392  -6.071  1.00  0.00           N  
ATOM    680  CA  VAL A  43       1.833 -11.503  -5.065  1.00  0.00           C  
ATOM    681  C   VAL A  43       0.952 -11.444  -3.822  1.00  0.00           C  
ATOM    682  O   VAL A  43      -0.273 -11.368  -3.920  1.00  0.00           O  
ATOM    683  CB  VAL A  43       2.018 -10.077  -5.615  1.00  0.00           C  
ATOM    684  CG1 VAL A  43       3.349  -9.496  -5.159  1.00  0.00           C  
ATOM    685  CG2 VAL A  43       1.918 -10.073  -7.133  1.00  0.00           C  
ATOM    686  H   VAL A  43       0.293 -12.413  -6.196  1.00  0.00           H  
ATOM    687  HA  VAL A  43       2.803 -11.889  -4.788  1.00  0.00           H  
ATOM    688  HB  VAL A  43       1.227  -9.455  -5.221  1.00  0.00           H  
ATOM    689 HG11 VAL A  43       3.215  -8.460  -4.889  1.00  0.00           H  
ATOM    690 HG12 VAL A  43       4.067  -9.570  -5.962  1.00  0.00           H  
ATOM    691 HG13 VAL A  43       3.707 -10.048  -4.303  1.00  0.00           H  
ATOM    692 HG21 VAL A  43       1.875  -9.054  -7.487  1.00  0.00           H  
ATOM    693 HG22 VAL A  43       1.024 -10.598  -7.436  1.00  0.00           H  
ATOM    694 HG23 VAL A  43       2.783 -10.564  -7.552  1.00  0.00           H  
ATOM    695  N   ASP A  44       1.583 -11.481  -2.653  1.00  0.00           N  
ATOM    696  CA  ASP A  44       0.855 -11.431  -1.389  1.00  0.00           C  
ATOM    697  C   ASP A  44       0.249 -10.050  -1.165  1.00  0.00           C  
ATOM    698  O   ASP A  44       0.968  -9.072  -0.964  1.00  0.00           O  
ATOM    699  CB  ASP A  44       1.783 -11.790  -0.228  1.00  0.00           C  
ATOM    700  CG  ASP A  44       1.105 -11.647   1.120  1.00  0.00           C  
ATOM    701  OD1 ASP A  44       0.035 -12.262   1.315  1.00  0.00           O  
ATOM    702  OD2 ASP A  44       1.643 -10.920   1.982  1.00  0.00           O  
ATOM    703  H   ASP A  44       2.561 -11.542  -2.639  1.00  0.00           H  
ATOM    704  HA  ASP A  44       0.057 -12.158  -1.439  1.00  0.00           H  
ATOM    705  HB2 ASP A  44       2.109 -12.814  -0.338  1.00  0.00           H  
ATOM    706  HB3 ASP A  44       2.644 -11.138  -0.249  1.00  0.00           H  
ATOM    707  N   VAL A  45      -1.077  -9.979  -1.199  1.00  0.00           N  
ATOM    708  CA  VAL A  45      -1.780  -8.717  -0.999  1.00  0.00           C  
ATOM    709  C   VAL A  45      -2.825  -8.836   0.101  1.00  0.00           C  
ATOM    710  O   VAL A  45      -3.712  -7.991   0.221  1.00  0.00           O  
ATOM    711  CB  VAL A  45      -2.484  -8.255  -2.284  1.00  0.00           C  
ATOM    712  CG1 VAL A  45      -2.027  -6.858  -2.673  1.00  0.00           C  
ATOM    713  CG2 VAL A  45      -2.240  -9.241  -3.414  1.00  0.00           C  
ATOM    714  H   VAL A  45      -1.596 -10.794  -1.363  1.00  0.00           H  
ATOM    715  HA  VAL A  45      -1.055  -7.968  -0.719  1.00  0.00           H  
ATOM    716  HB  VAL A  45      -3.546  -8.221  -2.085  1.00  0.00           H  
ATOM    717 HG11 VAL A  45      -1.301  -6.503  -1.955  1.00  0.00           H  
ATOM    718 HG12 VAL A  45      -2.877  -6.191  -2.684  1.00  0.00           H  
ATOM    719 HG13 VAL A  45      -1.578  -6.885  -3.655  1.00  0.00           H  
ATOM    720 HG21 VAL A  45      -2.859 -10.115  -3.270  1.00  0.00           H  
ATOM    721 HG22 VAL A  45      -1.200  -9.533  -3.419  1.00  0.00           H  
ATOM    722 HG23 VAL A  45      -2.487  -8.777  -4.358  1.00  0.00           H  
ATOM    723  N   LEU A  46      -2.718  -9.887   0.901  1.00  0.00           N  
ATOM    724  CA  LEU A  46      -3.666 -10.110   1.985  1.00  0.00           C  
ATOM    725  C   LEU A  46      -3.720  -8.890   2.894  1.00  0.00           C  
ATOM    726  O   LEU A  46      -4.798  -8.445   3.288  1.00  0.00           O  
ATOM    727  CB  LEU A  46      -3.272 -11.348   2.792  1.00  0.00           C  
ATOM    728  CG  LEU A  46      -3.428 -12.679   2.052  1.00  0.00           C  
ATOM    729  CD1 LEU A  46      -2.813 -13.813   2.858  1.00  0.00           C  
ATOM    730  CD2 LEU A  46      -4.895 -12.960   1.767  1.00  0.00           C  
ATOM    731  H   LEU A  46      -1.993 -10.527   0.755  1.00  0.00           H  
ATOM    732  HA  LEU A  46      -4.642 -10.265   1.549  1.00  0.00           H  
ATOM    733  HB2 LEU A  46      -2.239 -11.245   3.090  1.00  0.00           H  
ATOM    734  HB3 LEU A  46      -3.884 -11.383   3.681  1.00  0.00           H  
ATOM    735  HG  LEU A  46      -2.908 -12.621   1.108  1.00  0.00           H  
ATOM    736 HD11 LEU A  46      -2.932 -14.742   2.322  1.00  0.00           H  
ATOM    737 HD12 LEU A  46      -3.307 -13.884   3.815  1.00  0.00           H  
ATOM    738 HD13 LEU A  46      -1.761 -13.617   3.010  1.00  0.00           H  
ATOM    739 HD21 LEU A  46      -5.032 -13.116   0.707  1.00  0.00           H  
ATOM    740 HD22 LEU A  46      -5.491 -12.119   2.088  1.00  0.00           H  
ATOM    741 HD23 LEU A  46      -5.203 -13.846   2.303  1.00  0.00           H  
ATOM    742  N   TYR A  47      -2.554  -8.339   3.205  1.00  0.00           N  
ATOM    743  CA  TYR A  47      -2.481  -7.155   4.046  1.00  0.00           C  
ATOM    744  C   TYR A  47      -3.150  -5.977   3.349  1.00  0.00           C  
ATOM    745  O   TYR A  47      -3.834  -5.171   3.982  1.00  0.00           O  
ATOM    746  CB  TYR A  47      -1.023  -6.816   4.369  1.00  0.00           C  
ATOM    747  CG  TYR A  47      -0.748  -6.669   5.849  1.00  0.00           C  
ATOM    748  CD1 TYR A  47      -1.693  -6.105   6.697  1.00  0.00           C  
ATOM    749  CD2 TYR A  47       0.456  -7.094   6.396  1.00  0.00           C  
ATOM    750  CE1 TYR A  47      -1.444  -5.968   8.050  1.00  0.00           C  
ATOM    751  CE2 TYR A  47       0.710  -6.961   7.748  1.00  0.00           C  
ATOM    752  CZ  TYR A  47      -0.242  -6.398   8.570  1.00  0.00           C  
ATOM    753  OH  TYR A  47       0.007  -6.265   9.917  1.00  0.00           O  
ATOM    754  H   TYR A  47      -1.728  -8.726   2.847  1.00  0.00           H  
ATOM    755  HA  TYR A  47      -3.008  -7.365   4.966  1.00  0.00           H  
ATOM    756  HB2 TYR A  47      -0.387  -7.602   3.990  1.00  0.00           H  
ATOM    757  HB3 TYR A  47      -0.763  -5.885   3.888  1.00  0.00           H  
ATOM    758  HD1 TYR A  47      -2.634  -5.770   6.287  1.00  0.00           H  
ATOM    759  HD2 TYR A  47       1.200  -7.534   5.750  1.00  0.00           H  
ATOM    760  HE1 TYR A  47      -2.192  -5.528   8.694  1.00  0.00           H  
ATOM    761  HE2 TYR A  47       1.653  -7.297   8.156  1.00  0.00           H  
ATOM    762  HH  TYR A  47       0.336  -7.096  10.266  1.00  0.00           H  
ATOM    763  N   PHE A  48      -2.963  -5.897   2.033  1.00  0.00           N  
ATOM    764  CA  PHE A  48      -3.557  -4.827   1.242  1.00  0.00           C  
ATOM    765  C   PHE A  48      -5.076  -4.862   1.361  1.00  0.00           C  
ATOM    766  O   PHE A  48      -5.737  -3.831   1.274  1.00  0.00           O  
ATOM    767  CB  PHE A  48      -3.121  -4.912  -0.228  1.00  0.00           C  
ATOM    768  CG  PHE A  48      -2.291  -3.734  -0.659  1.00  0.00           C  
ATOM    769  CD1 PHE A  48      -1.307  -3.235   0.179  1.00  0.00           C  
ATOM    770  CD2 PHE A  48      -2.492  -3.119  -1.891  1.00  0.00           C  
ATOM    771  CE1 PHE A  48      -0.539  -2.149  -0.195  1.00  0.00           C  
ATOM    772  CE2 PHE A  48      -1.725  -2.033  -2.266  1.00  0.00           C  
ATOM    773  CZ  PHE A  48      -0.750  -1.548  -1.419  1.00  0.00           C  
ATOM    774  H   PHE A  48      -2.422  -6.579   1.583  1.00  0.00           H  
ATOM    775  HA  PHE A  48      -3.207  -3.891   1.653  1.00  0.00           H  
ATOM    776  HB2 PHE A  48      -2.534  -5.805  -0.379  1.00  0.00           H  
ATOM    777  HB3 PHE A  48      -3.996  -4.952  -0.855  1.00  0.00           H  
ATOM    778  HD1 PHE A  48      -1.141  -3.704   1.138  1.00  0.00           H  
ATOM    779  HD2 PHE A  48      -3.255  -3.495  -2.566  1.00  0.00           H  
ATOM    780  HE1 PHE A  48       0.223  -1.772   0.470  1.00  0.00           H  
ATOM    781  HE2 PHE A  48      -1.891  -1.563  -3.220  1.00  0.00           H  
ATOM    782  HZ  PHE A  48      -0.151  -0.699  -1.714  1.00  0.00           H  
ATOM    783  N   ARG A  49      -5.626  -6.055   1.561  1.00  0.00           N  
ATOM    784  CA  ARG A  49      -7.070  -6.209   1.688  1.00  0.00           C  
ATOM    785  C   ARG A  49      -7.624  -5.298   2.783  1.00  0.00           C  
ATOM    786  O   ARG A  49      -8.652  -4.640   2.600  1.00  0.00           O  
ATOM    787  CB  ARG A  49      -7.419  -7.667   1.999  1.00  0.00           C  
ATOM    788  CG  ARG A  49      -7.065  -8.632   0.875  1.00  0.00           C  
ATOM    789  CD  ARG A  49      -8.305  -9.125   0.145  1.00  0.00           C  
ATOM    790  NE  ARG A  49      -8.450 -10.576   0.231  1.00  0.00           N  
ATOM    791  CZ  ARG A  49      -8.709 -11.225   1.362  1.00  0.00           C  
ATOM    792  NH1 ARG A  49      -8.850 -10.555   2.498  1.00  0.00           N  
ATOM    793  NH2 ARG A  49      -8.827 -12.546   1.358  1.00  0.00           N  
ATOM    794  H   ARG A  49      -5.051  -6.848   1.621  1.00  0.00           H  
ATOM    795  HA  ARG A  49      -7.514  -5.944   0.752  1.00  0.00           H  
ATOM    796  HB2 ARG A  49      -6.885  -7.972   2.887  1.00  0.00           H  
ATOM    797  HB3 ARG A  49      -8.480  -7.739   2.184  1.00  0.00           H  
ATOM    798  HG2 ARG A  49      -6.423  -8.126   0.170  1.00  0.00           H  
ATOM    799  HG3 ARG A  49      -6.543  -9.480   1.295  1.00  0.00           H  
ATOM    800  HD2 ARG A  49      -9.176  -8.661   0.582  1.00  0.00           H  
ATOM    801  HD3 ARG A  49      -8.232  -8.843  -0.896  1.00  0.00           H  
ATOM    802  HE  ARG A  49      -8.349 -11.093  -0.596  1.00  0.00           H  
ATOM    803 HH11 ARG A  49      -8.762  -9.559   2.504  1.00  0.00           H  
ATOM    804 HH12 ARG A  49      -9.045 -11.046   3.347  1.00  0.00           H  
ATOM    805 HH21 ARG A  49      -8.721 -13.055   0.504  1.00  0.00           H  
ATOM    806 HH22 ARG A  49      -9.021 -13.034   2.209  1.00  0.00           H  
ATOM    807  N   GLU A  50      -6.934  -5.258   3.917  1.00  0.00           N  
ATOM    808  CA  GLU A  50      -7.350  -4.434   5.050  1.00  0.00           C  
ATOM    809  C   GLU A  50      -7.424  -2.947   4.697  1.00  0.00           C  
ATOM    810  O   GLU A  50      -8.194  -2.199   5.298  1.00  0.00           O  
ATOM    811  CB  GLU A  50      -6.389  -4.635   6.223  1.00  0.00           C  
ATOM    812  CG  GLU A  50      -5.968  -6.082   6.424  1.00  0.00           C  
ATOM    813  CD  GLU A  50      -7.145  -7.038   6.415  1.00  0.00           C  
ATOM    814  OE1 GLU A  50      -8.069  -6.849   7.233  1.00  0.00           O  
ATOM    815  OE2 GLU A  50      -7.142  -7.975   5.589  1.00  0.00           O  
ATOM    816  H   GLU A  50      -6.118  -5.799   3.996  1.00  0.00           H  
ATOM    817  HA  GLU A  50      -8.332  -4.764   5.351  1.00  0.00           H  
ATOM    818  HB2 GLU A  50      -5.501  -4.045   6.052  1.00  0.00           H  
ATOM    819  HB3 GLU A  50      -6.868  -4.294   7.130  1.00  0.00           H  
ATOM    820  HG2 GLU A  50      -5.292  -6.361   5.629  1.00  0.00           H  
ATOM    821  HG3 GLU A  50      -5.460  -6.168   7.374  1.00  0.00           H  
ATOM    822  N   LEU A  51      -6.598  -2.516   3.750  1.00  0.00           N  
ATOM    823  CA  LEU A  51      -6.548  -1.108   3.358  1.00  0.00           C  
ATOM    824  C   LEU A  51      -7.900  -0.570   2.882  1.00  0.00           C  
ATOM    825  O   LEU A  51      -8.228   0.590   3.138  1.00  0.00           O  
ATOM    826  CB  LEU A  51      -5.503  -0.901   2.258  1.00  0.00           C  
ATOM    827  CG  LEU A  51      -4.103  -0.542   2.756  1.00  0.00           C  
ATOM    828  CD1 LEU A  51      -3.057  -0.888   1.707  1.00  0.00           C  
ATOM    829  CD2 LEU A  51      -4.029   0.934   3.117  1.00  0.00           C  
ATOM    830  H   LEU A  51      -5.985  -3.153   3.325  1.00  0.00           H  
ATOM    831  HA  LEU A  51      -6.244  -0.543   4.225  1.00  0.00           H  
ATOM    832  HB2 LEU A  51      -5.436  -1.809   1.675  1.00  0.00           H  
ATOM    833  HB3 LEU A  51      -5.844  -0.105   1.613  1.00  0.00           H  
ATOM    834  HG  LEU A  51      -3.886  -1.116   3.645  1.00  0.00           H  
ATOM    835 HD11 LEU A  51      -3.111  -1.944   1.480  1.00  0.00           H  
ATOM    836 HD12 LEU A  51      -2.074  -0.652   2.088  1.00  0.00           H  
ATOM    837 HD13 LEU A  51      -3.244  -0.317   0.811  1.00  0.00           H  
ATOM    838 HD21 LEU A  51      -3.199   1.391   2.599  1.00  0.00           H  
ATOM    839 HD22 LEU A  51      -3.889   1.037   4.183  1.00  0.00           H  
ATOM    840 HD23 LEU A  51      -4.948   1.422   2.825  1.00  0.00           H  
ATOM    841  N   LEU A  52      -8.686  -1.392   2.193  1.00  0.00           N  
ATOM    842  CA  LEU A  52      -9.988  -0.935   1.698  1.00  0.00           C  
ATOM    843  C   LEU A  52     -10.936  -0.645   2.850  1.00  0.00           C  
ATOM    844  O   LEU A  52     -11.800   0.227   2.749  1.00  0.00           O  
ATOM    845  CB  LEU A  52     -10.624  -1.957   0.755  1.00  0.00           C  
ATOM    846  CG  LEU A  52     -10.341  -1.759  -0.741  1.00  0.00           C  
ATOM    847  CD1 LEU A  52     -11.618  -1.433  -1.498  1.00  0.00           C  
ATOM    848  CD2 LEU A  52      -9.304  -0.669  -0.972  1.00  0.00           C  
ATOM    849  H   LEU A  52      -8.391  -2.313   2.015  1.00  0.00           H  
ATOM    850  HA  LEU A  52      -9.825  -0.015   1.160  1.00  0.00           H  
ATOM    851  HB2 LEU A  52     -10.272  -2.940   1.036  1.00  0.00           H  
ATOM    852  HB3 LEU A  52     -11.694  -1.925   0.898  1.00  0.00           H  
ATOM    853  HG  LEU A  52      -9.949  -2.681  -1.140  1.00  0.00           H  
ATOM    854 HD11 LEU A  52     -11.937  -0.433  -1.249  1.00  0.00           H  
ATOM    855 HD12 LEU A  52     -12.390  -2.137  -1.226  1.00  0.00           H  
ATOM    856 HD13 LEU A  52     -11.429  -1.494  -2.562  1.00  0.00           H  
ATOM    857 HD21 LEU A  52      -9.040  -0.643  -2.021  1.00  0.00           H  
ATOM    858 HD22 LEU A  52      -8.424  -0.873  -0.383  1.00  0.00           H  
ATOM    859 HD23 LEU A  52      -9.717   0.286  -0.684  1.00  0.00           H  
ATOM    860  N   ALA A  53     -10.775  -1.374   3.944  1.00  0.00           N  
ATOM    861  CA  ALA A  53     -11.627  -1.181   5.103  1.00  0.00           C  
ATOM    862  C   ALA A  53     -11.554   0.263   5.578  1.00  0.00           C  
ATOM    863  O   ALA A  53     -12.547   0.822   6.047  1.00  0.00           O  
ATOM    864  CB  ALA A  53     -11.225  -2.131   6.222  1.00  0.00           C  
ATOM    865  H   ALA A  53     -10.071  -2.056   3.971  1.00  0.00           H  
ATOM    866  HA  ALA A  53     -12.644  -1.407   4.815  1.00  0.00           H  
ATOM    867  HB1 ALA A  53     -10.837  -1.563   7.055  1.00  0.00           H  
ATOM    868  HB2 ALA A  53     -10.466  -2.809   5.863  1.00  0.00           H  
ATOM    869  HB3 ALA A  53     -12.088  -2.695   6.543  1.00  0.00           H  
ATOM    870  N   GLY A  54     -10.382   0.876   5.430  1.00  0.00           N  
ATOM    871  CA  GLY A  54     -10.225   2.256   5.841  1.00  0.00           C  
ATOM    872  C   GLY A  54     -11.189   3.163   5.113  1.00  0.00           C  
ATOM    873  O   GLY A  54     -11.819   4.029   5.719  1.00  0.00           O  
ATOM    874  H   GLY A  54      -9.627   0.391   5.030  1.00  0.00           H  
ATOM    875  HA2 GLY A  54     -10.401   2.331   6.903  1.00  0.00           H  
ATOM    876  HA3 GLY A  54      -9.216   2.572   5.627  1.00  0.00           H  
ATOM    877  N   VAL A  55     -11.325   2.943   3.814  1.00  0.00           N  
ATOM    878  CA  VAL A  55     -12.241   3.724   3.000  1.00  0.00           C  
ATOM    879  C   VAL A  55     -13.677   3.412   3.388  1.00  0.00           C  
ATOM    880  O   VAL A  55     -14.554   4.273   3.330  1.00  0.00           O  
ATOM    881  CB  VAL A  55     -12.047   3.441   1.498  1.00  0.00           C  
ATOM    882  CG1 VAL A  55     -12.573   4.598   0.663  1.00  0.00           C  
ATOM    883  CG2 VAL A  55     -10.581   3.174   1.190  1.00  0.00           C  
ATOM    884  H   VAL A  55     -10.817   2.217   3.397  1.00  0.00           H  
ATOM    885  HA  VAL A  55     -12.043   4.771   3.181  1.00  0.00           H  
ATOM    886  HB  VAL A  55     -12.612   2.556   1.243  1.00  0.00           H  
ATOM    887 HG11 VAL A  55     -13.568   4.365   0.312  1.00  0.00           H  
ATOM    888 HG12 VAL A  55     -11.921   4.758  -0.183  1.00  0.00           H  
ATOM    889 HG13 VAL A  55     -12.605   5.492   1.268  1.00  0.00           H  
ATOM    890 HG21 VAL A  55     -10.449   2.133   0.935  1.00  0.00           H  
ATOM    891 HG22 VAL A  55      -9.982   3.411   2.056  1.00  0.00           H  
ATOM    892 HG23 VAL A  55     -10.271   3.791   0.359  1.00  0.00           H  
ATOM    893  N   ALA A  56     -13.901   2.163   3.778  1.00  0.00           N  
ATOM    894  CA  ALA A  56     -15.221   1.704   4.176  1.00  0.00           C  
ATOM    895  C   ALA A  56     -15.637   2.305   5.514  1.00  0.00           C  
ATOM    896  O   ALA A  56     -16.824   2.355   5.840  1.00  0.00           O  
ATOM    897  CB  ALA A  56     -15.231   0.187   4.243  1.00  0.00           C  
ATOM    898  H   ALA A  56     -13.151   1.528   3.804  1.00  0.00           H  
ATOM    899  HA  ALA A  56     -15.925   2.012   3.418  1.00  0.00           H  
ATOM    900  HB1 ALA A  56     -15.627  -0.130   5.196  1.00  0.00           H  
ATOM    901  HB2 ALA A  56     -14.219  -0.180   4.131  1.00  0.00           H  
ATOM    902  HB3 ALA A  56     -15.847  -0.205   3.446  1.00  0.00           H  
ATOM    903  N   THR A  57     -14.656   2.760   6.286  1.00  0.00           N  
ATOM    904  CA  THR A  57     -14.926   3.355   7.589  1.00  0.00           C  
ATOM    905  C   THR A  57     -14.353   4.766   7.676  1.00  0.00           C  
ATOM    906  O   THR A  57     -14.456   5.424   8.710  1.00  0.00           O  
ATOM    907  CB  THR A  57     -14.340   2.487   8.702  1.00  0.00           C  
ATOM    908  OG1 THR A  57     -12.959   2.260   8.487  1.00  0.00           O  
ATOM    909  CG2 THR A  57     -15.014   1.136   8.825  1.00  0.00           C  
ATOM    910  H   THR A  57     -13.728   2.694   5.974  1.00  0.00           H  
ATOM    911  HA  THR A  57     -15.998   3.409   7.713  1.00  0.00           H  
ATOM    912  HB  THR A  57     -14.456   3.000   9.645  1.00  0.00           H  
ATOM    913  HG1 THR A  57     -12.700   2.635   7.642  1.00  0.00           H  
ATOM    914 HG21 THR A  57     -16.012   1.193   8.418  1.00  0.00           H  
ATOM    915 HG22 THR A  57     -15.065   0.854   9.866  1.00  0.00           H  
ATOM    916 HG23 THR A  57     -14.444   0.398   8.279  1.00  0.00           H  
ATOM    917  N   ASN A  58     -13.747   5.225   6.585  1.00  0.00           N  
ATOM    918  CA  ASN A  58     -13.157   6.555   6.545  1.00  0.00           C  
ATOM    919  C   ASN A  58     -13.287   7.172   5.157  1.00  0.00           C  
ATOM    920  O   ASN A  58     -12.475   8.008   4.763  1.00  0.00           O  
ATOM    921  CB  ASN A  58     -11.684   6.494   6.952  1.00  0.00           C  
ATOM    922  CG  ASN A  58     -11.480   5.795   8.281  1.00  0.00           C  
ATOM    923  OD1 ASN A  58     -11.690   6.381   9.343  1.00  0.00           O  
ATOM    924  ND2 ASN A  58     -11.065   4.535   8.230  1.00  0.00           N  
ATOM    925  H   ASN A  58     -13.692   4.655   5.790  1.00  0.00           H  
ATOM    926  HA  ASN A  58     -13.689   7.174   7.252  1.00  0.00           H  
ATOM    927  HB2 ASN A  58     -11.130   5.958   6.196  1.00  0.00           H  
ATOM    928  HB3 ASN A  58     -11.298   7.498   7.030  1.00  0.00           H  
ATOM    929 HD21 ASN A  58     -10.916   4.132   7.350  1.00  0.00           H  
ATOM    930 HD22 ASN A  58     -10.924   4.059   9.075  1.00  0.00           H  
ATOM    931  N   THR A  59     -14.312   6.760   4.418  1.00  0.00           N  
ATOM    932  CA  THR A  59     -14.534   7.290   3.077  1.00  0.00           C  
ATOM    933  C   THR A  59     -14.638   8.809   3.123  1.00  0.00           C  
ATOM    934  O   THR A  59     -13.986   9.511   2.349  1.00  0.00           O  
ATOM    935  CB  THR A  59     -15.803   6.694   2.460  1.00  0.00           C  
ATOM    936  OG1 THR A  59     -16.379   5.729   3.320  1.00  0.00           O  
ATOM    937  CG2 THR A  59     -15.563   6.032   1.119  1.00  0.00           C  
ATOM    938  H   THR A  59     -14.931   6.094   4.781  1.00  0.00           H  
ATOM    939  HA  THR A  59     -13.684   7.017   2.468  1.00  0.00           H  
ATOM    940  HB  THR A  59     -16.523   7.487   2.311  1.00  0.00           H  
ATOM    941  HG1 THR A  59     -17.068   6.139   3.849  1.00  0.00           H  
ATOM    942 HG21 THR A  59     -14.503   5.888   0.972  1.00  0.00           H  
ATOM    943 HG22 THR A  59     -15.953   6.659   0.331  1.00  0.00           H  
ATOM    944 HG23 THR A  59     -16.062   5.072   1.097  1.00  0.00           H  
ATOM    945  N   ALA A  60     -15.450   9.311   4.048  1.00  0.00           N  
ATOM    946  CA  ALA A  60     -15.630  10.749   4.207  1.00  0.00           C  
ATOM    947  C   ALA A  60     -14.303  11.422   4.532  1.00  0.00           C  
ATOM    948  O   ALA A  60     -14.053  12.557   4.130  1.00  0.00           O  
ATOM    949  CB  ALA A  60     -16.653  11.037   5.295  1.00  0.00           C  
ATOM    950  H   ALA A  60     -15.934   8.701   4.643  1.00  0.00           H  
ATOM    951  HA  ALA A  60     -16.007  11.144   3.274  1.00  0.00           H  
ATOM    952  HB1 ALA A  60     -16.510  10.350   6.115  1.00  0.00           H  
ATOM    953  HB2 ALA A  60     -17.648  10.917   4.894  1.00  0.00           H  
ATOM    954  HB3 ALA A  60     -16.527  12.050   5.648  1.00  0.00           H  
ATOM    955  N   TYR A  61     -13.446  10.699   5.247  1.00  0.00           N  
ATOM    956  CA  TYR A  61     -12.133  11.211   5.614  1.00  0.00           C  
ATOM    957  C   TYR A  61     -11.327  11.456   4.353  1.00  0.00           C  
ATOM    958  O   TYR A  61     -10.654  12.478   4.213  1.00  0.00           O  
ATOM    959  CB  TYR A  61     -11.407  10.224   6.530  1.00  0.00           C  
ATOM    960  CG  TYR A  61      -9.902  10.256   6.391  1.00  0.00           C  
ATOM    961  CD1 TYR A  61      -9.211  11.462   6.379  1.00  0.00           C  
ATOM    962  CD2 TYR A  61      -9.171   9.081   6.277  1.00  0.00           C  
ATOM    963  CE1 TYR A  61      -7.835  11.493   6.255  1.00  0.00           C  
ATOM    964  CE2 TYR A  61      -7.795   9.104   6.153  1.00  0.00           C  
ATOM    965  CZ  TYR A  61      -7.133  10.312   6.144  1.00  0.00           C  
ATOM    966  OH  TYR A  61      -5.762  10.339   6.025  1.00  0.00           O  
ATOM    967  H   TYR A  61     -13.697   9.796   5.515  1.00  0.00           H  
ATOM    968  HA  TYR A  61     -12.270  12.149   6.133  1.00  0.00           H  
ATOM    969  HB2 TYR A  61     -11.649  10.454   7.557  1.00  0.00           H  
ATOM    970  HB3 TYR A  61     -11.740   9.222   6.303  1.00  0.00           H  
ATOM    971  HD1 TYR A  61      -9.765  12.385   6.467  1.00  0.00           H  
ATOM    972  HD2 TYR A  61      -9.695   8.135   6.283  1.00  0.00           H  
ATOM    973  HE1 TYR A  61      -7.315  12.441   6.248  1.00  0.00           H  
ATOM    974  HE2 TYR A  61      -7.246   8.179   6.066  1.00  0.00           H  
ATOM    975  HH  TYR A  61      -5.366  10.407   6.896  1.00  0.00           H  
ATOM    976  N   LEU A  62     -11.439  10.522   3.419  1.00  0.00           N  
ATOM    977  CA  LEU A  62     -10.765  10.636   2.142  1.00  0.00           C  
ATOM    978  C   LEU A  62     -11.401  11.773   1.360  1.00  0.00           C  
ATOM    979  O   LEU A  62     -10.754  12.430   0.543  1.00  0.00           O  
ATOM    980  CB  LEU A  62     -10.864   9.327   1.355  1.00  0.00           C  
ATOM    981  CG  LEU A  62      -9.931   8.212   1.832  1.00  0.00           C  
ATOM    982  CD1 LEU A  62     -10.057   6.991   0.937  1.00  0.00           C  
ATOM    983  CD2 LEU A  62      -8.491   8.704   1.867  1.00  0.00           C  
ATOM    984  H   LEU A  62     -12.018   9.747   3.585  1.00  0.00           H  
ATOM    985  HA  LEU A  62      -9.726  10.870   2.326  1.00  0.00           H  
ATOM    986  HB2 LEU A  62     -11.882   8.969   1.421  1.00  0.00           H  
ATOM    987  HB3 LEU A  62     -10.640   9.534   0.321  1.00  0.00           H  
ATOM    988  HG  LEU A  62     -10.210   7.922   2.834  1.00  0.00           H  
ATOM    989 HD11 LEU A  62     -10.201   6.110   1.546  1.00  0.00           H  
ATOM    990 HD12 LEU A  62      -9.157   6.879   0.349  1.00  0.00           H  
ATOM    991 HD13 LEU A  62     -10.904   7.113   0.277  1.00  0.00           H  
ATOM    992 HD21 LEU A  62      -7.872   8.047   1.273  1.00  0.00           H  
ATOM    993 HD22 LEU A  62      -8.137   8.707   2.887  1.00  0.00           H  
ATOM    994 HD23 LEU A  62      -8.443   9.705   1.466  1.00  0.00           H  
ATOM    995  N   ASP A  63     -12.686  11.994   1.628  1.00  0.00           N  
ATOM    996  CA  ASP A  63     -13.439  13.051   0.965  1.00  0.00           C  
ATOM    997  C   ASP A  63     -12.795  14.410   1.211  1.00  0.00           C  
ATOM    998  O   ASP A  63     -12.965  15.341   0.423  1.00  0.00           O  
ATOM    999  CB  ASP A  63     -14.886  13.063   1.459  1.00  0.00           C  
ATOM   1000  CG  ASP A  63     -15.292  14.407   2.031  1.00  0.00           C  
ATOM   1001  OD1 ASP A  63     -14.623  14.876   2.976  1.00  0.00           O  
ATOM   1002  OD2 ASP A  63     -16.278  14.991   1.534  1.00  0.00           O  
ATOM   1003  H   ASP A  63     -13.139  11.431   2.301  1.00  0.00           H  
ATOM   1004  HA  ASP A  63     -13.432  12.849  -0.095  1.00  0.00           H  
ATOM   1005  HB2 ASP A  63     -15.544  12.831   0.635  1.00  0.00           H  
ATOM   1006  HB3 ASP A  63     -15.003  12.315   2.228  1.00  0.00           H  
ATOM   1007  N   GLY A  64     -12.054  14.520   2.311  1.00  0.00           N  
ATOM   1008  CA  GLY A  64     -11.398  15.772   2.637  1.00  0.00           C  
ATOM   1009  C   GLY A  64     -10.411  16.196   1.568  1.00  0.00           C  
ATOM   1010  O   GLY A  64     -10.271  17.384   1.279  1.00  0.00           O  
ATOM   1011  H   GLY A  64     -11.954  13.746   2.902  1.00  0.00           H  
ATOM   1012  HA2 GLY A  64     -12.147  16.542   2.747  1.00  0.00           H  
ATOM   1013  HA3 GLY A  64     -10.872  15.658   3.573  1.00  0.00           H  
ATOM   1014  N   LEU A  65      -9.735  15.221   0.970  1.00  0.00           N  
ATOM   1015  CA  LEU A  65      -8.768  15.501  -0.085  1.00  0.00           C  
ATOM   1016  C   LEU A  65      -9.486  15.979  -1.343  1.00  0.00           C  
ATOM   1017  O   LEU A  65      -9.035  16.906  -2.015  1.00  0.00           O  
ATOM   1018  CB  LEU A  65      -7.936  14.254  -0.394  1.00  0.00           C  
ATOM   1019  CG  LEU A  65      -7.132  13.694   0.781  1.00  0.00           C  
ATOM   1020  CD1 LEU A  65      -5.650  13.638   0.437  1.00  0.00           C  
ATOM   1021  CD2 LEU A  65      -7.356  14.526   2.033  1.00  0.00           C  
ATOM   1022  H   LEU A  65      -9.896  14.291   1.236  1.00  0.00           H  
ATOM   1023  HA  LEU A  65      -8.114  16.287   0.262  1.00  0.00           H  
ATOM   1024  HB2 LEU A  65      -8.604  13.481  -0.745  1.00  0.00           H  
ATOM   1025  HB3 LEU A  65      -7.246  14.496  -1.188  1.00  0.00           H  
ATOM   1026  HG  LEU A  65      -7.463  12.688   0.989  1.00  0.00           H  
ATOM   1027 HD11 LEU A  65      -5.514  13.864  -0.613  1.00  0.00           H  
ATOM   1028 HD12 LEU A  65      -5.270  12.649   0.645  1.00  0.00           H  
ATOM   1029 HD13 LEU A  65      -5.114  14.363   1.032  1.00  0.00           H  
ATOM   1030 HD21 LEU A  65      -7.342  15.572   1.776  1.00  0.00           H  
ATOM   1031 HD22 LEU A  65      -6.573  14.319   2.749  1.00  0.00           H  
ATOM   1032 HD23 LEU A  65      -8.313  14.274   2.466  1.00  0.00           H  
ATOM   1033  N   MET A  66     -10.612  15.345  -1.646  1.00  0.00           N  
ATOM   1034  CA  MET A  66     -11.405  15.707  -2.814  1.00  0.00           C  
ATOM   1035  C   MET A  66     -12.191  16.980  -2.542  1.00  0.00           C  
ATOM   1036  O   MET A  66     -12.574  17.701  -3.463  1.00  0.00           O  
ATOM   1037  CB  MET A  66     -12.362  14.573  -3.172  1.00  0.00           C  
ATOM   1038  CG  MET A  66     -11.660  13.258  -3.446  1.00  0.00           C  
ATOM   1039  SD  MET A  66     -12.201  12.486  -4.983  1.00  0.00           S  
ATOM   1040  CE  MET A  66     -11.215  10.991  -4.977  1.00  0.00           C  
ATOM   1041  H   MET A  66     -10.923  14.619  -1.065  1.00  0.00           H  
ATOM   1042  HA  MET A  66     -10.731  15.877  -3.639  1.00  0.00           H  
ATOM   1043  HB2 MET A  66     -13.047  14.423  -2.351  1.00  0.00           H  
ATOM   1044  HB3 MET A  66     -12.922  14.851  -4.053  1.00  0.00           H  
ATOM   1045  HG2 MET A  66     -10.599  13.445  -3.505  1.00  0.00           H  
ATOM   1046  HG3 MET A  66     -11.861  12.584  -2.628  1.00  0.00           H  
ATOM   1047  HE1 MET A  66     -10.222  11.216  -4.614  1.00  0.00           H  
ATOM   1048  HE2 MET A  66     -11.151  10.597  -5.980  1.00  0.00           H  
ATOM   1049  HE3 MET A  66     -11.677  10.258  -4.331  1.00  0.00           H  
ATOM   1050  N   LYS A  67     -12.428  17.242  -1.263  1.00  0.00           N  
ATOM   1051  CA  LYS A  67     -13.168  18.425  -0.838  1.00  0.00           C  
ATOM   1052  C   LYS A  67     -12.919  19.600  -1.780  1.00  0.00           C  
ATOM   1053  O   LYS A  67     -13.856  20.174  -2.331  1.00  0.00           O  
ATOM   1054  CB  LYS A  67     -12.777  18.810   0.589  1.00  0.00           C  
ATOM   1055  CG  LYS A  67     -13.940  19.329   1.419  1.00  0.00           C  
ATOM   1056  CD  LYS A  67     -14.554  18.228   2.267  1.00  0.00           C  
ATOM   1057  CE  LYS A  67     -15.189  18.787   3.531  1.00  0.00           C  
ATOM   1058  NZ  LYS A  67     -14.367  19.871   4.134  1.00  0.00           N  
ATOM   1059  H   LYS A  67     -12.092  16.618  -0.585  1.00  0.00           H  
ATOM   1060  HA  LYS A  67     -14.220  18.181  -0.859  1.00  0.00           H  
ATOM   1061  HB2 LYS A  67     -12.369  17.942   1.086  1.00  0.00           H  
ATOM   1062  HB3 LYS A  67     -12.020  19.579   0.548  1.00  0.00           H  
ATOM   1063  HG2 LYS A  67     -13.584  20.114   2.069  1.00  0.00           H  
ATOM   1064  HG3 LYS A  67     -14.695  19.724   0.755  1.00  0.00           H  
ATOM   1065  HD2 LYS A  67     -15.313  17.722   1.689  1.00  0.00           H  
ATOM   1066  HD3 LYS A  67     -13.782  17.526   2.544  1.00  0.00           H  
ATOM   1067  HE2 LYS A  67     -16.164  19.181   3.285  1.00  0.00           H  
ATOM   1068  HE3 LYS A  67     -15.296  17.986   4.249  1.00  0.00           H  
ATOM   1069  HZ1 LYS A  67     -14.604  20.786   3.697  1.00  0.00           H  
ATOM   1070  HZ2 LYS A  67     -13.356  19.681   3.982  1.00  0.00           H  
ATOM   1071  HZ3 LYS A  67     -14.546  19.931   5.157  1.00  0.00           H  
ATOM   1072  N   PRO A  68     -11.644  19.976  -1.976  1.00  0.00           N  
ATOM   1073  CA  PRO A  68     -11.277  21.091  -2.856  1.00  0.00           C  
ATOM   1074  C   PRO A  68     -11.615  20.813  -4.317  1.00  0.00           C  
ATOM   1075  O   PRO A  68     -11.905  21.732  -5.082  1.00  0.00           O  
ATOM   1076  CB  PRO A  68      -9.761  21.214  -2.672  1.00  0.00           C  
ATOM   1077  CG  PRO A  68      -9.324  19.879  -2.176  1.00  0.00           C  
ATOM   1078  CD  PRO A  68     -10.466  19.348  -1.356  1.00  0.00           C  
ATOM   1079  HA  PRO A  68     -11.754  22.009  -2.548  1.00  0.00           H  
ATOM   1080  HB2 PRO A  68      -9.300  21.454  -3.618  1.00  0.00           H  
ATOM   1081  HB3 PRO A  68      -9.546  21.990  -1.953  1.00  0.00           H  
ATOM   1082  HG2 PRO A  68      -9.125  19.224  -3.011  1.00  0.00           H  
ATOM   1083  HG3 PRO A  68      -8.441  19.985  -1.563  1.00  0.00           H  
ATOM   1084  HD2 PRO A  68     -10.515  18.273  -1.431  1.00  0.00           H  
ATOM   1085  HD3 PRO A  68     -10.365  19.652  -0.325  1.00  0.00           H  
ATOM   1086  N   TYR A  69     -11.579  19.540  -4.698  1.00  0.00           N  
ATOM   1087  CA  TYR A  69     -11.884  19.144  -6.068  1.00  0.00           C  
ATOM   1088  C   TYR A  69     -12.980  18.083  -6.101  1.00  0.00           C  
ATOM   1089  O   TYR A  69     -12.775  16.944  -5.680  1.00  0.00           O  
ATOM   1090  CB  TYR A  69     -10.624  18.628  -6.767  1.00  0.00           C  
ATOM   1091  CG  TYR A  69     -10.396  17.145  -6.595  1.00  0.00           C  
ATOM   1092  CD1 TYR A  69     -11.032  16.227  -7.419  1.00  0.00           C  
ATOM   1093  CD2 TYR A  69      -9.547  16.665  -5.608  1.00  0.00           C  
ATOM   1094  CE1 TYR A  69     -10.829  14.870  -7.264  1.00  0.00           C  
ATOM   1095  CE2 TYR A  69      -9.338  15.309  -5.447  1.00  0.00           C  
ATOM   1096  CZ  TYR A  69      -9.981  14.416  -6.277  1.00  0.00           C  
ATOM   1097  OH  TYR A  69      -9.773  13.065  -6.119  1.00  0.00           O  
ATOM   1098  H   TYR A  69     -11.343  18.851  -4.042  1.00  0.00           H  
ATOM   1099  HA  TYR A  69     -12.237  20.018  -6.591  1.00  0.00           H  
ATOM   1100  HB2 TYR A  69     -10.701  18.831  -7.825  1.00  0.00           H  
ATOM   1101  HB3 TYR A  69      -9.764  19.146  -6.368  1.00  0.00           H  
ATOM   1102  HD1 TYR A  69     -11.695  16.586  -8.193  1.00  0.00           H  
ATOM   1103  HD2 TYR A  69      -9.046  17.367  -4.959  1.00  0.00           H  
ATOM   1104  HE1 TYR A  69     -11.333  14.172  -7.915  1.00  0.00           H  
ATOM   1105  HE2 TYR A  69      -8.675  14.955  -4.672  1.00  0.00           H  
ATOM   1106  HH  TYR A  69      -9.264  12.909  -5.320  1.00  0.00           H  
ATOM   1107  N   LEU A  70     -14.152  18.469  -6.596  1.00  0.00           N  
ATOM   1108  CA  LEU A  70     -15.286  17.560  -6.680  1.00  0.00           C  
ATOM   1109  C   LEU A  70     -15.604  17.223  -8.132  1.00  0.00           C  
ATOM   1110  O   LEU A  70     -15.741  16.054  -8.494  1.00  0.00           O  
ATOM   1111  CB  LEU A  70     -16.511  18.186  -6.014  1.00  0.00           C  
ATOM   1112  CG  LEU A  70     -16.307  18.641  -4.569  1.00  0.00           C  
ATOM   1113  CD1 LEU A  70     -16.019  17.449  -3.668  1.00  0.00           C  
ATOM   1114  CD2 LEU A  70     -15.185  19.663  -4.476  1.00  0.00           C  
ATOM   1115  H   LEU A  70     -14.260  19.392  -6.904  1.00  0.00           H  
ATOM   1116  HA  LEU A  70     -15.026  16.652  -6.158  1.00  0.00           H  
ATOM   1117  HB2 LEU A  70     -16.812  19.043  -6.600  1.00  0.00           H  
ATOM   1118  HB3 LEU A  70     -17.312  17.462  -6.031  1.00  0.00           H  
ATOM   1119  HG  LEU A  70     -17.212  19.110  -4.221  1.00  0.00           H  
ATOM   1120 HD11 LEU A  70     -15.910  16.560  -4.272  1.00  0.00           H  
ATOM   1121 HD12 LEU A  70     -16.836  17.315  -2.975  1.00  0.00           H  
ATOM   1122 HD13 LEU A  70     -15.106  17.625  -3.119  1.00  0.00           H  
ATOM   1123 HD21 LEU A  70     -15.420  20.386  -3.708  1.00  0.00           H  
ATOM   1124 HD22 LEU A  70     -15.080  20.169  -5.424  1.00  0.00           H  
ATOM   1125 HD23 LEU A  70     -14.261  19.162  -4.229  1.00  0.00           H  
ATOM   1126  N   SER A  71     -15.722  18.257  -8.961  1.00  0.00           N  
ATOM   1127  CA  SER A  71     -16.027  18.075 -10.374  1.00  0.00           C  
ATOM   1128  C   SER A  71     -17.507  17.760 -10.571  1.00  0.00           C  
ATOM   1129  O   SER A  71     -17.862  16.810 -11.270  1.00  0.00           O  
ATOM   1130  CB  SER A  71     -15.170  16.953 -10.964  1.00  0.00           C  
ATOM   1131  OG  SER A  71     -14.308  17.447 -11.973  1.00  0.00           O  
ATOM   1132  H   SER A  71     -15.604  19.165  -8.610  1.00  0.00           H  
ATOM   1133  HA  SER A  71     -15.798  18.998 -10.884  1.00  0.00           H  
ATOM   1134  HB2 SER A  71     -14.572  16.512 -10.181  1.00  0.00           H  
ATOM   1135  HB3 SER A  71     -15.814  16.200 -11.393  1.00  0.00           H  
ATOM   1136  HG  SER A  71     -14.504  17.011 -12.805  1.00  0.00           H  
ATOM   1137  N   ARG A  72     -18.364  18.560  -9.946  1.00  0.00           N  
ATOM   1138  CA  ARG A  72     -19.806  18.364 -10.048  1.00  0.00           C  
ATOM   1139  C   ARG A  72     -20.239  17.134  -9.260  1.00  0.00           C  
ATOM   1140  O   ARG A  72     -21.058  17.226  -8.345  1.00  0.00           O  
ATOM   1141  CB  ARG A  72     -20.220  18.220 -11.514  1.00  0.00           C  
ATOM   1142  CG  ARG A  72     -19.724  19.351 -12.399  1.00  0.00           C  
ATOM   1143  CD  ARG A  72     -19.495  18.882 -13.826  1.00  0.00           C  
ATOM   1144  NE  ARG A  72     -18.802  19.885 -14.628  1.00  0.00           N  
ATOM   1145  CZ  ARG A  72     -18.115  19.600 -15.730  1.00  0.00           C  
ATOM   1146  NH1 ARG A  72     -18.033  18.348 -16.156  1.00  0.00           N  
ATOM   1147  NH2 ARG A  72     -17.511  20.568 -16.406  1.00  0.00           N  
ATOM   1148  H   ARG A  72     -18.019  19.297  -9.401  1.00  0.00           H  
ATOM   1149  HA  ARG A  72     -20.288  19.235  -9.630  1.00  0.00           H  
ATOM   1150  HB2 ARG A  72     -19.826  17.291 -11.898  1.00  0.00           H  
ATOM   1151  HB3 ARG A  72     -21.299  18.194 -11.570  1.00  0.00           H  
ATOM   1152  HG2 ARG A  72     -20.461  20.140 -12.405  1.00  0.00           H  
ATOM   1153  HG3 ARG A  72     -18.795  19.727 -11.999  1.00  0.00           H  
ATOM   1154  HD2 ARG A  72     -18.900  17.981 -13.804  1.00  0.00           H  
ATOM   1155  HD3 ARG A  72     -20.452  18.669 -14.279  1.00  0.00           H  
ATOM   1156  HE  ARG A  72     -18.851  20.817 -14.331  1.00  0.00           H  
ATOM   1157 HH11 ARG A  72     -18.488  17.616 -15.649  1.00  0.00           H  
ATOM   1158 HH12 ARG A  72     -17.515  18.135 -16.985  1.00  0.00           H  
ATOM   1159 HH21 ARG A  72     -17.572  21.514 -16.087  1.00  0.00           H  
ATOM   1160 HH22 ARG A  72     -16.994  20.351 -17.234  1.00  0.00           H  
ATOM   1161  N   LEU A  73     -19.683  15.982  -9.620  1.00  0.00           N  
ATOM   1162  CA  LEU A  73     -20.008  14.732  -8.947  1.00  0.00           C  
ATOM   1163  C   LEU A  73     -18.867  13.732  -9.083  1.00  0.00           C  
ATOM   1164  O   LEU A  73     -18.220  13.651 -10.128  1.00  0.00           O  
ATOM   1165  CB  LEU A  73     -21.292  14.138  -9.524  1.00  0.00           C  
ATOM   1166  CG  LEU A  73     -22.509  15.063  -9.487  1.00  0.00           C  
ATOM   1167  CD1 LEU A  73     -22.510  15.994 -10.690  1.00  0.00           C  
ATOM   1168  CD2 LEU A  73     -23.794  14.251  -9.439  1.00  0.00           C  
ATOM   1169  H   LEU A  73     -19.039  15.972 -10.356  1.00  0.00           H  
ATOM   1170  HA  LEU A  73     -20.160  14.948  -7.900  1.00  0.00           H  
ATOM   1171  HB2 LEU A  73     -21.104  13.861 -10.550  1.00  0.00           H  
ATOM   1172  HB3 LEU A  73     -21.529  13.247  -8.967  1.00  0.00           H  
ATOM   1173  HG  LEU A  73     -22.464  15.672  -8.595  1.00  0.00           H  
ATOM   1174 HD11 LEU A  73     -21.502  16.099 -11.064  1.00  0.00           H  
ATOM   1175 HD12 LEU A  73     -22.886  16.962 -10.395  1.00  0.00           H  
ATOM   1176 HD13 LEU A  73     -23.141  15.583 -11.464  1.00  0.00           H  
ATOM   1177 HD21 LEU A  73     -23.577  13.256  -9.079  1.00  0.00           H  
ATOM   1178 HD22 LEU A  73     -24.218  14.190 -10.430  1.00  0.00           H  
ATOM   1179 HD23 LEU A  73     -24.498  14.728  -8.775  1.00  0.00           H  
ATOM   1180  N   LEU A  74     -18.625  12.971  -8.022  1.00  0.00           N  
ATOM   1181  CA  LEU A  74     -17.561  11.975  -8.024  1.00  0.00           C  
ATOM   1182  C   LEU A  74     -17.912  10.806  -8.939  1.00  0.00           C  
ATOM   1183  O   LEU A  74     -17.044  10.244  -9.605  1.00  0.00           O  
ATOM   1184  CB  LEU A  74     -17.306  11.467  -6.603  1.00  0.00           C  
ATOM   1185  CG  LEU A  74     -17.070  12.559  -5.558  1.00  0.00           C  
ATOM   1186  CD1 LEU A  74     -17.545  12.097  -4.189  1.00  0.00           C  
ATOM   1187  CD2 LEU A  74     -15.600  12.946  -5.512  1.00  0.00           C  
ATOM   1188  H   LEU A  74     -19.176  13.082  -7.220  1.00  0.00           H  
ATOM   1189  HA  LEU A  74     -16.665  12.448  -8.394  1.00  0.00           H  
ATOM   1190  HB2 LEU A  74     -18.157  10.880  -6.295  1.00  0.00           H  
ATOM   1191  HB3 LEU A  74     -16.436  10.828  -6.623  1.00  0.00           H  
ATOM   1192  HG  LEU A  74     -17.639  13.437  -5.829  1.00  0.00           H  
ATOM   1193 HD11 LEU A  74     -17.683  12.955  -3.547  1.00  0.00           H  
ATOM   1194 HD12 LEU A  74     -16.807  11.439  -3.756  1.00  0.00           H  
ATOM   1195 HD13 LEU A  74     -18.482  11.571  -4.292  1.00  0.00           H  
ATOM   1196 HD21 LEU A  74     -15.112  12.611  -6.416  1.00  0.00           H  
ATOM   1197 HD22 LEU A  74     -15.131  12.480  -4.657  1.00  0.00           H  
ATOM   1198 HD23 LEU A  74     -15.512  14.019  -5.432  1.00  0.00           H  
ATOM   1199  N   GLU A  75     -19.192  10.448  -8.967  1.00  0.00           N  
ATOM   1200  CA  GLU A  75     -19.659   9.346  -9.801  1.00  0.00           C  
ATOM   1201  C   GLU A  75     -19.620   9.728 -11.276  1.00  0.00           C  
ATOM   1202  O   GLU A  75     -19.527   8.864 -12.149  1.00  0.00           O  
ATOM   1203  CB  GLU A  75     -21.081   8.946  -9.402  1.00  0.00           C  
ATOM   1204  CG  GLU A  75     -21.396   7.482  -9.661  1.00  0.00           C  
ATOM   1205  CD  GLU A  75     -22.679   7.035  -8.987  1.00  0.00           C  
ATOM   1206  OE1 GLU A  75     -23.761   7.498  -9.405  1.00  0.00           O  
ATOM   1207  OE2 GLU A  75     -22.601   6.221  -8.044  1.00  0.00           O  
ATOM   1208  H   GLU A  75     -19.838  10.935  -8.413  1.00  0.00           H  
ATOM   1209  HA  GLU A  75     -19.000   8.507  -9.640  1.00  0.00           H  
ATOM   1210  HB2 GLU A  75     -21.216   9.141  -8.349  1.00  0.00           H  
ATOM   1211  HB3 GLU A  75     -21.782   9.547  -9.962  1.00  0.00           H  
ATOM   1212  HG2 GLU A  75     -21.495   7.331 -10.725  1.00  0.00           H  
ATOM   1213  HG3 GLU A  75     -20.582   6.881  -9.286  1.00  0.00           H  
ATOM   1214  N   GLU A  76     -19.692  11.026 -11.549  1.00  0.00           N  
ATOM   1215  CA  GLU A  76     -19.664  11.523 -12.920  1.00  0.00           C  
ATOM   1216  C   GLU A  76     -18.265  11.401 -13.515  1.00  0.00           C  
ATOM   1217  O   GLU A  76     -18.088  10.858 -14.605  1.00  0.00           O  
ATOM   1218  CB  GLU A  76     -20.125  12.980 -12.965  1.00  0.00           C  
ATOM   1219  CG  GLU A  76     -21.626  13.150 -12.785  1.00  0.00           C  
ATOM   1220  CD  GLU A  76     -22.373  13.162 -14.105  1.00  0.00           C  
ATOM   1221  OE1 GLU A  76     -21.713  13.083 -15.162  1.00  0.00           O  
ATOM   1222  OE2 GLU A  76     -23.618  13.252 -14.080  1.00  0.00           O  
ATOM   1223  H   GLU A  76     -19.764  11.666 -10.810  1.00  0.00           H  
ATOM   1224  HA  GLU A  76     -20.344  10.921 -13.504  1.00  0.00           H  
ATOM   1225  HB2 GLU A  76     -19.627  13.529 -12.179  1.00  0.00           H  
ATOM   1226  HB3 GLU A  76     -19.849  13.405 -13.919  1.00  0.00           H  
ATOM   1227  HG2 GLU A  76     -21.998  12.332 -12.186  1.00  0.00           H  
ATOM   1228  HG3 GLU A  76     -21.810  14.083 -12.274  1.00  0.00           H  
ATOM   1229  N   LEU A  77     -17.274  11.912 -12.790  1.00  0.00           N  
ATOM   1230  CA  LEU A  77     -15.889  11.859 -13.246  1.00  0.00           C  
ATOM   1231  C   LEU A  77     -15.488  10.431 -13.600  1.00  0.00           C  
ATOM   1232  O   LEU A  77     -16.114   9.471 -13.151  1.00  0.00           O  
ATOM   1233  CB  LEU A  77     -14.955  12.412 -12.168  1.00  0.00           C  
ATOM   1234  CG  LEU A  77     -13.687  13.087 -12.693  1.00  0.00           C  
ATOM   1235  CD1 LEU A  77     -13.794  14.598 -12.563  1.00  0.00           C  
ATOM   1236  CD2 LEU A  77     -12.464  12.571 -11.951  1.00  0.00           C  
ATOM   1237  H   LEU A  77     -17.478  12.332 -11.929  1.00  0.00           H  
ATOM   1238  HA  LEU A  77     -15.808  12.474 -14.130  1.00  0.00           H  
ATOM   1239  HB2 LEU A  77     -15.506  13.134 -11.580  1.00  0.00           H  
ATOM   1240  HB3 LEU A  77     -14.662  11.598 -11.523  1.00  0.00           H  
ATOM   1241  HG  LEU A  77     -13.569  12.850 -13.740  1.00  0.00           H  
ATOM   1242 HD11 LEU A  77     -12.870  14.992 -12.168  1.00  0.00           H  
ATOM   1243 HD12 LEU A  77     -14.606  14.846 -11.895  1.00  0.00           H  
ATOM   1244 HD13 LEU A  77     -13.984  15.031 -13.535  1.00  0.00           H  
ATOM   1245 HD21 LEU A  77     -11.576  13.035 -12.354  1.00  0.00           H  
ATOM   1246 HD22 LEU A  77     -12.397  11.499 -12.069  1.00  0.00           H  
ATOM   1247 HD23 LEU A  77     -12.551  12.813 -10.902  1.00  0.00           H  
ATOM   1248  N   GLY A  78     -14.441  10.300 -14.408  1.00  0.00           N  
ATOM   1249  CA  GLY A  78     -13.975   8.984 -14.808  1.00  0.00           C  
ATOM   1250  C   GLY A  78     -14.101   7.961 -13.697  1.00  0.00           C  
ATOM   1251  O   GLY A  78     -13.428   8.062 -12.671  1.00  0.00           O  
ATOM   1252  H   GLY A  78     -13.981  11.100 -14.735  1.00  0.00           H  
ATOM   1253  HA2 GLY A  78     -14.556   8.651 -15.656  1.00  0.00           H  
ATOM   1254  HA3 GLY A  78     -12.938   9.055 -15.101  1.00  0.00           H  
ATOM   1255  N   GLN A  79     -14.967   6.973 -13.898  1.00  0.00           N  
ATOM   1256  CA  GLN A  79     -15.181   5.929 -12.904  1.00  0.00           C  
ATOM   1257  C   GLN A  79     -13.857   5.461 -12.309  1.00  0.00           C  
ATOM   1258  O   GLN A  79     -13.586   5.677 -11.128  1.00  0.00           O  
ATOM   1259  CB  GLN A  79     -15.920   4.745 -13.529  1.00  0.00           C  
ATOM   1260  CG  GLN A  79     -17.419   4.766 -13.282  1.00  0.00           C  
ATOM   1261  CD  GLN A  79     -17.774   4.555 -11.824  1.00  0.00           C  
ATOM   1262  OE1 GLN A  79     -18.214   5.479 -11.140  1.00  0.00           O  
ATOM   1263  NE2 GLN A  79     -17.581   3.334 -11.338  1.00  0.00           N  
ATOM   1264  H   GLN A  79     -15.477   6.946 -14.735  1.00  0.00           H  
ATOM   1265  HA  GLN A  79     -15.789   6.344 -12.114  1.00  0.00           H  
ATOM   1266  HB2 GLN A  79     -15.752   4.752 -14.596  1.00  0.00           H  
ATOM   1267  HB3 GLN A  79     -15.522   3.829 -13.117  1.00  0.00           H  
ATOM   1268  HG2 GLN A  79     -17.810   5.722 -13.596  1.00  0.00           H  
ATOM   1269  HG3 GLN A  79     -17.877   3.982 -13.867  1.00  0.00           H  
ATOM   1270 HE21 GLN A  79     -17.227   2.647 -11.940  1.00  0.00           H  
ATOM   1271 HE22 GLN A  79     -17.802   3.170 -10.397  1.00  0.00           H  
ATOM   1272  N   VAL A  80     -13.036   4.818 -13.133  1.00  0.00           N  
ATOM   1273  CA  VAL A  80     -11.741   4.318 -12.680  1.00  0.00           C  
ATOM   1274  C   VAL A  80     -10.851   5.452 -12.191  1.00  0.00           C  
ATOM   1275  O   VAL A  80     -10.290   5.386 -11.096  1.00  0.00           O  
ATOM   1276  CB  VAL A  80     -10.985   3.558 -13.792  1.00  0.00           C  
ATOM   1277  CG1 VAL A  80     -11.212   2.060 -13.670  1.00  0.00           C  
ATOM   1278  CG2 VAL A  80     -11.391   4.059 -15.171  1.00  0.00           C  
ATOM   1279  H   VAL A  80     -13.310   4.673 -14.062  1.00  0.00           H  
ATOM   1280  HA  VAL A  80     -11.916   3.634 -11.862  1.00  0.00           H  
ATOM   1281  HB  VAL A  80      -9.929   3.745 -13.666  1.00  0.00           H  
ATOM   1282 HG11 VAL A  80     -10.264   1.568 -13.501  1.00  0.00           H  
ATOM   1283 HG12 VAL A  80     -11.653   1.687 -14.582  1.00  0.00           H  
ATOM   1284 HG13 VAL A  80     -11.874   1.862 -12.841  1.00  0.00           H  
ATOM   1285 HG21 VAL A  80     -12.142   3.403 -15.585  1.00  0.00           H  
ATOM   1286 HG22 VAL A  80     -10.525   4.070 -15.818  1.00  0.00           H  
ATOM   1287 HG23 VAL A  80     -11.791   5.058 -15.088  1.00  0.00           H  
ATOM   1288  N   GLU A  81     -10.719   6.492 -13.007  1.00  0.00           N  
ATOM   1289  CA  GLU A  81      -9.880   7.628 -12.656  1.00  0.00           C  
ATOM   1290  C   GLU A  81     -10.281   8.202 -11.306  1.00  0.00           C  
ATOM   1291  O   GLU A  81      -9.437   8.389 -10.430  1.00  0.00           O  
ATOM   1292  CB  GLU A  81      -9.975   8.711 -13.732  1.00  0.00           C  
ATOM   1293  CG  GLU A  81      -9.477   8.261 -15.095  1.00  0.00           C  
ATOM   1294  CD  GLU A  81      -9.885   9.208 -16.207  1.00  0.00           C  
ATOM   1295  OE1 GLU A  81     -10.069  10.411 -15.924  1.00  0.00           O  
ATOM   1296  OE2 GLU A  81     -10.021   8.747 -17.360  1.00  0.00           O  
ATOM   1297  H   GLU A  81     -11.186   6.487 -13.869  1.00  0.00           H  
ATOM   1298  HA  GLU A  81      -8.860   7.281 -12.597  1.00  0.00           H  
ATOM   1299  HB2 GLU A  81     -11.007   9.014 -13.831  1.00  0.00           H  
ATOM   1300  HB3 GLU A  81      -9.387   9.563 -13.421  1.00  0.00           H  
ATOM   1301  HG2 GLU A  81      -8.399   8.204 -15.070  1.00  0.00           H  
ATOM   1302  HG3 GLU A  81      -9.883   7.283 -15.307  1.00  0.00           H  
ATOM   1303  N   LYS A  82     -11.571   8.458 -11.126  1.00  0.00           N  
ATOM   1304  CA  LYS A  82     -12.057   8.998  -9.865  1.00  0.00           C  
ATOM   1305  C   LYS A  82     -11.657   8.077  -8.725  1.00  0.00           C  
ATOM   1306  O   LYS A  82     -11.266   8.532  -7.651  1.00  0.00           O  
ATOM   1307  CB  LYS A  82     -13.577   9.161  -9.894  1.00  0.00           C  
ATOM   1308  CG  LYS A  82     -14.166   9.601  -8.562  1.00  0.00           C  
ATOM   1309  CD  LYS A  82     -14.515   8.409  -7.681  1.00  0.00           C  
ATOM   1310  CE  LYS A  82     -14.566   8.796  -6.211  1.00  0.00           C  
ATOM   1311  NZ  LYS A  82     -15.965   8.887  -5.709  1.00  0.00           N  
ATOM   1312  H   LYS A  82     -12.205   8.273 -11.850  1.00  0.00           H  
ATOM   1313  HA  LYS A  82     -11.597   9.964  -9.715  1.00  0.00           H  
ATOM   1314  HB2 LYS A  82     -13.835   9.899 -10.638  1.00  0.00           H  
ATOM   1315  HB3 LYS A  82     -14.025   8.217 -10.166  1.00  0.00           H  
ATOM   1316  HG2 LYS A  82     -13.444  10.215  -8.046  1.00  0.00           H  
ATOM   1317  HG3 LYS A  82     -15.062  10.174  -8.747  1.00  0.00           H  
ATOM   1318  HD2 LYS A  82     -15.480   8.027  -7.975  1.00  0.00           H  
ATOM   1319  HD3 LYS A  82     -13.767   7.643  -7.817  1.00  0.00           H  
ATOM   1320  HE2 LYS A  82     -14.035   8.052  -5.635  1.00  0.00           H  
ATOM   1321  HE3 LYS A  82     -14.084   9.756  -6.088  1.00  0.00           H  
ATOM   1322  HZ1 LYS A  82     -16.080   9.739  -5.124  1.00  0.00           H  
ATOM   1323  HZ2 LYS A  82     -16.193   8.052  -5.133  1.00  0.00           H  
ATOM   1324  HZ3 LYS A  82     -16.628   8.935  -6.508  1.00  0.00           H  
ATOM   1325  N   ALA A  83     -11.734   6.777  -8.978  1.00  0.00           N  
ATOM   1326  CA  ALA A  83     -11.357   5.792  -7.983  1.00  0.00           C  
ATOM   1327  C   ALA A  83      -9.847   5.788  -7.792  1.00  0.00           C  
ATOM   1328  O   ALA A  83      -9.349   5.658  -6.675  1.00  0.00           O  
ATOM   1329  CB  ALA A  83     -11.847   4.410  -8.392  1.00  0.00           C  
ATOM   1330  H   ALA A  83     -12.032   6.474  -9.863  1.00  0.00           H  
ATOM   1331  HA  ALA A  83     -11.830   6.058  -7.049  1.00  0.00           H  
ATOM   1332  HB1 ALA A  83     -12.118   4.419  -9.437  1.00  0.00           H  
ATOM   1333  HB2 ALA A  83     -12.709   4.143  -7.797  1.00  0.00           H  
ATOM   1334  HB3 ALA A  83     -11.060   3.687  -8.231  1.00  0.00           H  
ATOM   1335  N   VAL A  84      -9.125   5.946  -8.900  1.00  0.00           N  
ATOM   1336  CA  VAL A  84      -7.671   5.958  -8.868  1.00  0.00           C  
ATOM   1337  C   VAL A  84      -7.166   7.040  -7.932  1.00  0.00           C  
ATOM   1338  O   VAL A  84      -6.289   6.803  -7.100  1.00  0.00           O  
ATOM   1339  CB  VAL A  84      -7.087   6.199 -10.273  1.00  0.00           C  
ATOM   1340  CG1 VAL A  84      -6.304   7.502 -10.309  1.00  0.00           C  
ATOM   1341  CG2 VAL A  84      -6.214   5.028 -10.696  1.00  0.00           C  
ATOM   1342  H   VAL A  84      -9.585   6.062  -9.760  1.00  0.00           H  
ATOM   1343  HA  VAL A  84      -7.331   4.993  -8.517  1.00  0.00           H  
ATOM   1344  HB  VAL A  84      -7.909   6.279 -10.971  1.00  0.00           H  
ATOM   1345 HG11 VAL A  84      -5.850   7.622 -11.281  1.00  0.00           H  
ATOM   1346 HG12 VAL A  84      -5.534   7.482  -9.553  1.00  0.00           H  
ATOM   1347 HG13 VAL A  84      -6.970   8.330 -10.122  1.00  0.00           H  
ATOM   1348 HG21 VAL A  84      -6.831   4.158 -10.859  1.00  0.00           H  
ATOM   1349 HG22 VAL A  84      -5.494   4.817  -9.921  1.00  0.00           H  
ATOM   1350 HG23 VAL A  84      -5.696   5.278 -11.611  1.00  0.00           H  
ATOM   1351  N   LEU A  85      -7.734   8.225  -8.070  1.00  0.00           N  
ATOM   1352  CA  LEU A  85      -7.360   9.352  -7.236  1.00  0.00           C  
ATOM   1353  C   LEU A  85      -7.826   9.142  -5.800  1.00  0.00           C  
ATOM   1354  O   LEU A  85      -7.179   9.601  -4.859  1.00  0.00           O  
ATOM   1355  CB  LEU A  85      -7.953  10.646  -7.795  1.00  0.00           C  
ATOM   1356  CG  LEU A  85      -7.464  11.036  -9.190  1.00  0.00           C  
ATOM   1357  CD1 LEU A  85      -8.343  12.130  -9.776  1.00  0.00           C  
ATOM   1358  CD2 LEU A  85      -6.012  11.487  -9.138  1.00  0.00           C  
ATOM   1359  H   LEU A  85      -8.432   8.344  -8.748  1.00  0.00           H  
ATOM   1360  HA  LEU A  85      -6.283   9.426  -7.246  1.00  0.00           H  
ATOM   1361  HB2 LEU A  85      -9.028  10.538  -7.829  1.00  0.00           H  
ATOM   1362  HB3 LEU A  85      -7.711  11.450  -7.116  1.00  0.00           H  
ATOM   1363  HG  LEU A  85      -7.525  10.175  -9.842  1.00  0.00           H  
ATOM   1364 HD11 LEU A  85      -8.918  11.728 -10.596  1.00  0.00           H  
ATOM   1365 HD12 LEU A  85      -7.721  12.938 -10.132  1.00  0.00           H  
ATOM   1366 HD13 LEU A  85      -9.012  12.500  -9.013  1.00  0.00           H  
ATOM   1367 HD21 LEU A  85      -5.419  10.871  -9.799  1.00  0.00           H  
ATOM   1368 HD22 LEU A  85      -5.640  11.390  -8.128  1.00  0.00           H  
ATOM   1369 HD23 LEU A  85      -5.943  12.519  -9.449  1.00  0.00           H  
ATOM   1370  N   ARG A  86      -8.950   8.447  -5.632  1.00  0.00           N  
ATOM   1371  CA  ARG A  86      -9.491   8.208  -4.299  1.00  0.00           C  
ATOM   1372  C   ARG A  86      -8.473   7.486  -3.435  1.00  0.00           C  
ATOM   1373  O   ARG A  86      -8.194   7.901  -2.310  1.00  0.00           O  
ATOM   1374  CB  ARG A  86     -10.780   7.388  -4.386  1.00  0.00           C  
ATOM   1375  CG  ARG A  86     -11.173   6.731  -3.073  1.00  0.00           C  
ATOM   1376  CD  ARG A  86     -12.665   6.857  -2.812  1.00  0.00           C  
ATOM   1377  NE  ARG A  86     -13.417   5.740  -3.378  1.00  0.00           N  
ATOM   1378  CZ  ARG A  86     -14.699   5.507  -3.115  1.00  0.00           C  
ATOM   1379  NH1 ARG A  86     -15.368   6.311  -2.300  1.00  0.00           N  
ATOM   1380  NH2 ARG A  86     -15.313   4.470  -3.668  1.00  0.00           N  
ATOM   1381  H   ARG A  86      -9.426   8.092  -6.416  1.00  0.00           H  
ATOM   1382  HA  ARG A  86      -9.711   9.166  -3.853  1.00  0.00           H  
ATOM   1383  HB2 ARG A  86     -11.586   8.039  -4.694  1.00  0.00           H  
ATOM   1384  HB3 ARG A  86     -10.651   6.614  -5.127  1.00  0.00           H  
ATOM   1385  HG2 ARG A  86     -10.913   5.684  -3.114  1.00  0.00           H  
ATOM   1386  HG3 ARG A  86     -10.634   7.208  -2.268  1.00  0.00           H  
ATOM   1387  HD2 ARG A  86     -12.831   6.885  -1.745  1.00  0.00           H  
ATOM   1388  HD3 ARG A  86     -13.019   7.777  -3.254  1.00  0.00           H  
ATOM   1389  HE  ARG A  86     -12.941   5.133  -3.983  1.00  0.00           H  
ATOM   1390 HH11 ARG A  86     -14.907   7.094  -1.882  1.00  0.00           H  
ATOM   1391 HH12 ARG A  86     -16.332   6.134  -2.104  1.00  0.00           H  
ATOM   1392 HH21 ARG A  86     -14.812   3.862  -4.283  1.00  0.00           H  
ATOM   1393 HH22 ARG A  86     -16.277   4.296  -3.469  1.00  0.00           H  
ATOM   1394  N   ILE A  87      -7.895   6.425  -3.974  1.00  0.00           N  
ATOM   1395  CA  ILE A  87      -6.887   5.677  -3.249  1.00  0.00           C  
ATOM   1396  C   ILE A  87      -5.636   6.525  -3.081  1.00  0.00           C  
ATOM   1397  O   ILE A  87      -4.925   6.417  -2.080  1.00  0.00           O  
ATOM   1398  CB  ILE A  87      -6.520   4.368  -3.974  1.00  0.00           C  
ATOM   1399  CG1 ILE A  87      -7.787   3.622  -4.397  1.00  0.00           C  
ATOM   1400  CG2 ILE A  87      -5.655   3.492  -3.081  1.00  0.00           C  
ATOM   1401  CD1 ILE A  87      -7.602   2.769  -5.634  1.00  0.00           C  
ATOM   1402  H   ILE A  87      -8.137   6.152  -4.884  1.00  0.00           H  
ATOM   1403  HA  ILE A  87      -7.283   5.432  -2.275  1.00  0.00           H  
ATOM   1404  HB  ILE A  87      -5.948   4.618  -4.854  1.00  0.00           H  
ATOM   1405 HG12 ILE A  87      -8.101   2.973  -3.592  1.00  0.00           H  
ATOM   1406 HG13 ILE A  87      -8.569   4.339  -4.601  1.00  0.00           H  
ATOM   1407 HG21 ILE A  87      -4.655   3.442  -3.486  1.00  0.00           H  
ATOM   1408 HG22 ILE A  87      -6.075   2.498  -3.035  1.00  0.00           H  
ATOM   1409 HG23 ILE A  87      -5.620   3.914  -2.088  1.00  0.00           H  
ATOM   1410 HD11 ILE A  87      -8.080   3.249  -6.476  1.00  0.00           H  
ATOM   1411 HD12 ILE A  87      -8.047   1.799  -5.472  1.00  0.00           H  
ATOM   1412 HD13 ILE A  87      -6.548   2.652  -5.836  1.00  0.00           H  
ATOM   1413  N   ALA A  88      -5.383   7.388  -4.064  1.00  0.00           N  
ATOM   1414  CA  ALA A  88      -4.224   8.264  -4.026  1.00  0.00           C  
ATOM   1415  C   ALA A  88      -4.293   9.185  -2.822  1.00  0.00           C  
ATOM   1416  O   ALA A  88      -3.268   9.571  -2.261  1.00  0.00           O  
ATOM   1417  CB  ALA A  88      -4.129   9.073  -5.311  1.00  0.00           C  
ATOM   1418  H   ALA A  88      -6.001   7.445  -4.827  1.00  0.00           H  
ATOM   1419  HA  ALA A  88      -3.341   7.648  -3.948  1.00  0.00           H  
ATOM   1420  HB1 ALA A  88      -3.133   8.984  -5.720  1.00  0.00           H  
ATOM   1421  HB2 ALA A  88      -4.342  10.110  -5.099  1.00  0.00           H  
ATOM   1422  HB3 ALA A  88      -4.846   8.698  -6.026  1.00  0.00           H  
ATOM   1423  N   LEU A  89      -5.511   9.523  -2.419  1.00  0.00           N  
ATOM   1424  CA  LEU A  89      -5.708  10.395  -1.276  1.00  0.00           C  
ATOM   1425  C   LEU A  89      -5.122   9.758  -0.025  1.00  0.00           C  
ATOM   1426  O   LEU A  89      -4.432  10.415   0.756  1.00  0.00           O  
ATOM   1427  CB  LEU A  89      -7.199  10.677  -1.076  1.00  0.00           C  
ATOM   1428  CG  LEU A  89      -7.920  11.279  -2.287  1.00  0.00           C  
ATOM   1429  CD1 LEU A  89      -9.371  11.593  -1.944  1.00  0.00           C  
ATOM   1430  CD2 LEU A  89      -7.202  12.530  -2.773  1.00  0.00           C  
ATOM   1431  H   LEU A  89      -6.294   9.174  -2.898  1.00  0.00           H  
ATOM   1432  HA  LEU A  89      -5.194  11.324  -1.471  1.00  0.00           H  
ATOM   1433  HB2 LEU A  89      -7.688   9.748  -0.818  1.00  0.00           H  
ATOM   1434  HB3 LEU A  89      -7.306  11.359  -0.249  1.00  0.00           H  
ATOM   1435  HG  LEU A  89      -7.918  10.557  -3.091  1.00  0.00           H  
ATOM   1436 HD11 LEU A  89     -10.022  10.957  -2.523  1.00  0.00           H  
ATOM   1437 HD12 LEU A  89      -9.580  12.628  -2.173  1.00  0.00           H  
ATOM   1438 HD13 LEU A  89      -9.537  11.417  -0.892  1.00  0.00           H  
ATOM   1439 HD21 LEU A  89      -7.005  12.443  -3.831  1.00  0.00           H  
ATOM   1440 HD22 LEU A  89      -6.269  12.638  -2.241  1.00  0.00           H  
ATOM   1441 HD23 LEU A  89      -7.822  13.395  -2.592  1.00  0.00           H  
ATOM   1442  N   TYR A  90      -5.374   8.466   0.148  1.00  0.00           N  
ATOM   1443  CA  TYR A  90      -4.851   7.747   1.297  1.00  0.00           C  
ATOM   1444  C   TYR A  90      -3.339   7.625   1.194  1.00  0.00           C  
ATOM   1445  O   TYR A  90      -2.637   7.547   2.202  1.00  0.00           O  
ATOM   1446  CB  TYR A  90      -5.488   6.363   1.418  1.00  0.00           C  
ATOM   1447  CG  TYR A  90      -5.947   6.028   2.822  1.00  0.00           C  
ATOM   1448  CD1 TYR A  90      -5.470   6.739   3.921  1.00  0.00           C  
ATOM   1449  CD2 TYR A  90      -6.858   5.003   3.050  1.00  0.00           C  
ATOM   1450  CE1 TYR A  90      -5.888   6.433   5.202  1.00  0.00           C  
ATOM   1451  CE2 TYR A  90      -7.280   4.694   4.330  1.00  0.00           C  
ATOM   1452  CZ  TYR A  90      -6.793   5.412   5.401  1.00  0.00           C  
ATOM   1453  OH  TYR A  90      -7.212   5.107   6.676  1.00  0.00           O  
ATOM   1454  H   TYR A  90      -5.908   7.982  -0.521  1.00  0.00           H  
ATOM   1455  HA  TYR A  90      -5.093   8.324   2.176  1.00  0.00           H  
ATOM   1456  HB2 TYR A  90      -6.350   6.313   0.768  1.00  0.00           H  
ATOM   1457  HB3 TYR A  90      -4.770   5.615   1.115  1.00  0.00           H  
ATOM   1458  HD1 TYR A  90      -4.761   7.540   3.765  1.00  0.00           H  
ATOM   1459  HD2 TYR A  90      -7.235   4.441   2.208  1.00  0.00           H  
ATOM   1460  HE1 TYR A  90      -5.508   6.996   6.042  1.00  0.00           H  
ATOM   1461  HE2 TYR A  90      -7.989   3.893   4.487  1.00  0.00           H  
ATOM   1462  HH  TYR A  90      -7.704   4.283   6.663  1.00  0.00           H  
ATOM   1463  N   GLU A  91      -2.846   7.611  -0.040  1.00  0.00           N  
ATOM   1464  CA  GLU A  91      -1.416   7.501  -0.289  1.00  0.00           C  
ATOM   1465  C   GLU A  91      -0.652   8.565   0.487  1.00  0.00           C  
ATOM   1466  O   GLU A  91       0.461   8.326   0.955  1.00  0.00           O  
ATOM   1467  CB  GLU A  91      -1.126   7.636  -1.785  1.00  0.00           C  
ATOM   1468  CG  GLU A  91       0.298   7.265  -2.165  1.00  0.00           C  
ATOM   1469  CD  GLU A  91       1.058   8.424  -2.780  1.00  0.00           C  
ATOM   1470  OE1 GLU A  91       0.975   8.601  -4.015  1.00  0.00           O  
ATOM   1471  OE2 GLU A  91       1.736   9.156  -2.029  1.00  0.00           O  
ATOM   1472  H   GLU A  91      -3.460   7.684  -0.801  1.00  0.00           H  
ATOM   1473  HA  GLU A  91      -1.095   6.526   0.045  1.00  0.00           H  
ATOM   1474  HB2 GLU A  91      -1.800   6.992  -2.331  1.00  0.00           H  
ATOM   1475  HB3 GLU A  91      -1.300   8.660  -2.083  1.00  0.00           H  
ATOM   1476  HG2 GLU A  91       0.822   6.943  -1.278  1.00  0.00           H  
ATOM   1477  HG3 GLU A  91       0.268   6.455  -2.878  1.00  0.00           H  
ATOM   1478  N   LEU A  92      -1.255   9.742   0.624  1.00  0.00           N  
ATOM   1479  CA  LEU A  92      -0.623  10.835   1.349  1.00  0.00           C  
ATOM   1480  C   LEU A  92      -0.551  10.526   2.841  1.00  0.00           C  
ATOM   1481  O   LEU A  92       0.423  10.870   3.510  1.00  0.00           O  
ATOM   1482  CB  LEU A  92      -1.392  12.137   1.116  1.00  0.00           C  
ATOM   1483  CG  LEU A  92      -1.669  12.468  -0.351  1.00  0.00           C  
ATOM   1484  CD1 LEU A  92      -3.111  12.910  -0.535  1.00  0.00           C  
ATOM   1485  CD2 LEU A  92      -0.712  13.545  -0.843  1.00  0.00           C  
ATOM   1486  H   LEU A  92      -2.148   9.876   0.233  1.00  0.00           H  
ATOM   1487  HA  LEU A  92       0.380  10.948   0.968  1.00  0.00           H  
ATOM   1488  HB2 LEU A  92      -2.339  12.070   1.633  1.00  0.00           H  
ATOM   1489  HB3 LEU A  92      -0.823  12.949   1.544  1.00  0.00           H  
ATOM   1490  HG  LEU A  92      -1.512  11.582  -0.949  1.00  0.00           H  
ATOM   1491 HD11 LEU A  92      -3.257  13.251  -1.549  1.00  0.00           H  
ATOM   1492 HD12 LEU A  92      -3.331  13.715   0.151  1.00  0.00           H  
ATOM   1493 HD13 LEU A  92      -3.771  12.079  -0.337  1.00  0.00           H  
ATOM   1494 HD21 LEU A  92      -0.825  13.665  -1.910  1.00  0.00           H  
ATOM   1495 HD22 LEU A  92       0.303  13.253  -0.619  1.00  0.00           H  
ATOM   1496 HD23 LEU A  92      -0.937  14.479  -0.349  1.00  0.00           H  
ATOM   1497  N   SER A  93      -1.589   9.874   3.357  1.00  0.00           N  
ATOM   1498  CA  SER A  93      -1.644   9.517   4.770  1.00  0.00           C  
ATOM   1499  C   SER A  93      -0.735   8.330   5.073  1.00  0.00           C  
ATOM   1500  O   SER A  93       0.030   8.351   6.037  1.00  0.00           O  
ATOM   1501  CB  SER A  93      -3.082   9.188   5.177  1.00  0.00           C  
ATOM   1502  OG  SER A  93      -3.124   8.064   6.039  1.00  0.00           O  
ATOM   1503  H   SER A  93      -2.335   9.627   2.772  1.00  0.00           H  
ATOM   1504  HA  SER A  93      -1.305  10.369   5.339  1.00  0.00           H  
ATOM   1505  HB2 SER A  93      -3.511  10.036   5.690  1.00  0.00           H  
ATOM   1506  HB3 SER A  93      -3.663   8.971   4.293  1.00  0.00           H  
ATOM   1507  HG  SER A  93      -3.902   8.119   6.599  1.00  0.00           H  
ATOM   1508  N   LYS A  94      -0.826   7.296   4.243  1.00  0.00           N  
ATOM   1509  CA  LYS A  94      -0.013   6.098   4.422  1.00  0.00           C  
ATOM   1510  C   LYS A  94       1.352   6.257   3.760  1.00  0.00           C  
ATOM   1511  O   LYS A  94       2.075   5.280   3.565  1.00  0.00           O  
ATOM   1512  CB  LYS A  94      -0.734   4.877   3.845  1.00  0.00           C  
ATOM   1513  CG  LYS A  94      -2.110   4.643   4.447  1.00  0.00           C  
ATOM   1514  CD  LYS A  94      -2.202   5.191   5.861  1.00  0.00           C  
ATOM   1515  CE  LYS A  94      -3.594   5.005   6.442  1.00  0.00           C  
ATOM   1516  NZ  LYS A  94      -3.564   4.265   7.734  1.00  0.00           N  
ATOM   1517  H   LYS A  94      -1.455   7.338   3.493  1.00  0.00           H  
ATOM   1518  HA  LYS A  94       0.130   5.951   5.482  1.00  0.00           H  
ATOM   1519  HB2 LYS A  94      -0.848   5.012   2.780  1.00  0.00           H  
ATOM   1520  HB3 LYS A  94      -0.132   3.999   4.026  1.00  0.00           H  
ATOM   1521  HG2 LYS A  94      -2.850   5.137   3.832  1.00  0.00           H  
ATOM   1522  HG3 LYS A  94      -2.308   3.581   4.467  1.00  0.00           H  
ATOM   1523  HD2 LYS A  94      -1.491   4.671   6.485  1.00  0.00           H  
ATOM   1524  HD3 LYS A  94      -1.966   6.245   5.845  1.00  0.00           H  
ATOM   1525  HE2 LYS A  94      -4.036   5.977   6.605  1.00  0.00           H  
ATOM   1526  HE3 LYS A  94      -4.194   4.452   5.734  1.00  0.00           H  
ATOM   1527  HZ1 LYS A  94      -4.303   3.534   7.745  1.00  0.00           H  
ATOM   1528  HZ2 LYS A  94      -3.728   4.920   8.525  1.00  0.00           H  
ATOM   1529  HZ3 LYS A  94      -2.637   3.809   7.862  1.00  0.00           H  
ATOM   1530  N   ARG A  95       1.697   7.492   3.416  1.00  0.00           N  
ATOM   1531  CA  ARG A  95       2.977   7.780   2.777  1.00  0.00           C  
ATOM   1532  C   ARG A  95       4.119   7.076   3.503  1.00  0.00           C  
ATOM   1533  O   ARG A  95       4.586   7.543   4.542  1.00  0.00           O  
ATOM   1534  CB  ARG A  95       3.228   9.287   2.749  1.00  0.00           C  
ATOM   1535  CG  ARG A  95       3.346   9.908   4.132  1.00  0.00           C  
ATOM   1536  CD  ARG A  95       3.221  11.421   4.076  1.00  0.00           C  
ATOM   1537  NE  ARG A  95       2.145  11.914   4.931  1.00  0.00           N  
ATOM   1538  CZ  ARG A  95       2.225  11.968   6.257  1.00  0.00           C  
ATOM   1539  NH1 ARG A  95       3.327  11.563   6.874  1.00  0.00           N  
ATOM   1540  NH2 ARG A  95       1.204  12.429   6.967  1.00  0.00           N  
ATOM   1541  H   ARG A  95       1.078   8.230   3.598  1.00  0.00           H  
ATOM   1542  HA  ARG A  95       2.930   7.413   1.762  1.00  0.00           H  
ATOM   1543  HB2 ARG A  95       4.146   9.479   2.213  1.00  0.00           H  
ATOM   1544  HB3 ARG A  95       2.412   9.768   2.231  1.00  0.00           H  
ATOM   1545  HG2 ARG A  95       2.560   9.515   4.760  1.00  0.00           H  
ATOM   1546  HG3 ARG A  95       4.308   9.649   4.550  1.00  0.00           H  
ATOM   1547  HD2 ARG A  95       4.154  11.858   4.402  1.00  0.00           H  
ATOM   1548  HD3 ARG A  95       3.022  11.716   3.057  1.00  0.00           H  
ATOM   1549  HE  ARG A  95       1.322  12.218   4.495  1.00  0.00           H  
ATOM   1550 HH11 ARG A  95       4.099  11.215   6.341  1.00  0.00           H  
ATOM   1551 HH12 ARG A  95       3.386  11.605   7.871  1.00  0.00           H  
ATOM   1552 HH21 ARG A  95       0.372  12.737   6.505  1.00  0.00           H  
ATOM   1553 HH22 ARG A  95       1.267  12.470   7.964  1.00  0.00           H  
ATOM   1554  N   SER A  96       4.564   5.953   2.952  1.00  0.00           N  
ATOM   1555  CA  SER A  96       5.653   5.189   3.549  1.00  0.00           C  
ATOM   1556  C   SER A  96       6.875   6.072   3.776  1.00  0.00           C  
ATOM   1557  O   SER A  96       7.366   6.194   4.899  1.00  0.00           O  
ATOM   1558  CB  SER A  96       6.025   4.004   2.655  1.00  0.00           C  
ATOM   1559  OG  SER A  96       5.898   4.340   1.284  1.00  0.00           O  
ATOM   1560  H   SER A  96       4.152   5.631   2.122  1.00  0.00           H  
ATOM   1561  HA  SER A  96       5.311   4.815   4.503  1.00  0.00           H  
ATOM   1562  HB2 SER A  96       7.047   3.717   2.848  1.00  0.00           H  
ATOM   1563  HB3 SER A  96       5.371   3.173   2.872  1.00  0.00           H  
ATOM   1564  HG  SER A  96       6.769   4.378   0.881  1.00  0.00           H  
ATOM   1565  N   ASP A  97       7.360   6.689   2.704  1.00  0.00           N  
ATOM   1566  CA  ASP A  97       8.524   7.563   2.784  1.00  0.00           C  
ATOM   1567  C   ASP A  97       8.543   8.549   1.621  1.00  0.00           C  
ATOM   1568  O   ASP A  97       9.606   8.982   1.178  1.00  0.00           O  
ATOM   1569  CB  ASP A  97       9.811   6.737   2.788  1.00  0.00           C  
ATOM   1570  CG  ASP A  97      10.660   6.995   4.017  1.00  0.00           C  
ATOM   1571  OD1 ASP A  97      10.389   7.986   4.728  1.00  0.00           O  
ATOM   1572  OD2 ASP A  97      11.597   6.209   4.268  1.00  0.00           O  
ATOM   1573  H   ASP A  97       6.924   6.552   1.836  1.00  0.00           H  
ATOM   1574  HA  ASP A  97       8.459   8.116   3.709  1.00  0.00           H  
ATOM   1575  HB2 ASP A  97       9.557   5.687   2.764  1.00  0.00           H  
ATOM   1576  HB3 ASP A  97      10.392   6.983   1.912  1.00  0.00           H  
ATOM   1577  N   VAL A  98       7.358   8.900   1.133  1.00  0.00           N  
ATOM   1578  CA  VAL A  98       7.236   9.835   0.022  1.00  0.00           C  
ATOM   1579  C   VAL A  98       6.404  11.051   0.415  1.00  0.00           C  
ATOM   1580  O   VAL A  98       5.381  10.925   1.089  1.00  0.00           O  
ATOM   1581  CB  VAL A  98       6.596   9.165  -1.208  1.00  0.00           C  
ATOM   1582  CG1 VAL A  98       5.178   9.672  -1.415  1.00  0.00           C  
ATOM   1583  CG2 VAL A  98       7.443   9.405  -2.448  1.00  0.00           C  
ATOM   1584  H   VAL A  98       6.546   8.521   1.529  1.00  0.00           H  
ATOM   1585  HA  VAL A  98       8.229  10.163  -0.249  1.00  0.00           H  
ATOM   1586  HB  VAL A  98       6.551   8.100  -1.030  1.00  0.00           H  
ATOM   1587 HG11 VAL A  98       4.596   9.490  -0.523  1.00  0.00           H  
ATOM   1588 HG12 VAL A  98       4.728   9.154  -2.250  1.00  0.00           H  
ATOM   1589 HG13 VAL A  98       5.200  10.732  -1.620  1.00  0.00           H  
ATOM   1590 HG21 VAL A  98       8.320   9.977  -2.181  1.00  0.00           H  
ATOM   1591 HG22 VAL A  98       6.866   9.953  -3.179  1.00  0.00           H  
ATOM   1592 HG23 VAL A  98       7.746   8.457  -2.866  1.00  0.00           H  
ATOM   1593  N   PRO A  99       6.836  12.248  -0.006  1.00  0.00           N  
ATOM   1594  CA  PRO A  99       6.134  13.500   0.300  1.00  0.00           C  
ATOM   1595  C   PRO A  99       4.723  13.528  -0.279  1.00  0.00           C  
ATOM   1596  O   PRO A  99       4.195  12.502  -0.705  1.00  0.00           O  
ATOM   1597  CB  PRO A  99       7.005  14.577  -0.357  1.00  0.00           C  
ATOM   1598  CG  PRO A  99       7.820  13.850  -1.373  1.00  0.00           C  
ATOM   1599  CD  PRO A  99       8.044  12.476  -0.812  1.00  0.00           C  
ATOM   1600  HA  PRO A  99       6.086  13.673   1.365  1.00  0.00           H  
ATOM   1601  HB2 PRO A  99       6.372  15.321  -0.818  1.00  0.00           H  
ATOM   1602  HB3 PRO A  99       7.630  15.042   0.390  1.00  0.00           H  
ATOM   1603  HG2 PRO A  99       7.277  13.792  -2.305  1.00  0.00           H  
ATOM   1604  HG3 PRO A  99       8.764  14.356  -1.516  1.00  0.00           H  
ATOM   1605  HD2 PRO A  99       8.122  11.750  -1.608  1.00  0.00           H  
ATOM   1606  HD3 PRO A  99       8.930  12.459  -0.195  1.00  0.00           H  
ATOM   1607  N   TYR A 100       4.116  14.711  -0.286  1.00  0.00           N  
ATOM   1608  CA  TYR A 100       2.764  14.874  -0.809  1.00  0.00           C  
ATOM   1609  C   TYR A 100       2.790  15.331  -2.264  1.00  0.00           C  
ATOM   1610  O   TYR A 100       2.075  14.790  -3.108  1.00  0.00           O  
ATOM   1611  CB  TYR A 100       1.987  15.885   0.038  1.00  0.00           C  
ATOM   1612  CG  TYR A 100       2.170  17.317  -0.412  1.00  0.00           C  
ATOM   1613  CD1 TYR A 100       3.304  18.037  -0.060  1.00  0.00           C  
ATOM   1614  CD2 TYR A 100       1.209  17.948  -1.193  1.00  0.00           C  
ATOM   1615  CE1 TYR A 100       3.476  19.345  -0.474  1.00  0.00           C  
ATOM   1616  CE2 TYR A 100       1.373  19.254  -1.610  1.00  0.00           C  
ATOM   1617  CZ  TYR A 100       2.508  19.949  -1.248  1.00  0.00           C  
ATOM   1618  OH  TYR A 100       2.674  21.250  -1.662  1.00  0.00           O  
ATOM   1619  H   TYR A 100       4.588  15.492   0.071  1.00  0.00           H  
ATOM   1620  HA  TYR A 100       2.269  13.916  -0.753  1.00  0.00           H  
ATOM   1621  HB2 TYR A 100       0.934  15.653  -0.012  1.00  0.00           H  
ATOM   1622  HB3 TYR A 100       2.318  15.815   1.064  1.00  0.00           H  
ATOM   1623  HD1 TYR A 100       4.061  17.562   0.546  1.00  0.00           H  
ATOM   1624  HD2 TYR A 100       0.321  17.404  -1.473  1.00  0.00           H  
ATOM   1625  HE1 TYR A 100       4.365  19.889  -0.190  1.00  0.00           H  
ATOM   1626  HE2 TYR A 100       0.614  19.725  -2.217  1.00  0.00           H  
ATOM   1627  HH  TYR A 100       3.122  21.749  -0.975  1.00  0.00           H  
ATOM   1628  N   LYS A 101       3.616  16.333  -2.551  1.00  0.00           N  
ATOM   1629  CA  LYS A 101       3.731  16.867  -3.904  1.00  0.00           C  
ATOM   1630  C   LYS A 101       4.153  15.780  -4.888  1.00  0.00           C  
ATOM   1631  O   LYS A 101       3.735  15.782  -6.045  1.00  0.00           O  
ATOM   1632  CB  LYS A 101       4.737  18.018  -3.935  1.00  0.00           C  
ATOM   1633  CG  LYS A 101       4.121  19.353  -4.322  1.00  0.00           C  
ATOM   1634  CD  LYS A 101       4.416  19.704  -5.771  1.00  0.00           C  
ATOM   1635  CE  LYS A 101       3.440  20.743  -6.301  1.00  0.00           C  
ATOM   1636  NZ  LYS A 101       2.089  20.599  -5.692  1.00  0.00           N  
ATOM   1637  H   LYS A 101       4.158  16.725  -1.834  1.00  0.00           H  
ATOM   1638  HA  LYS A 101       2.761  17.241  -4.195  1.00  0.00           H  
ATOM   1639  HB2 LYS A 101       5.181  18.120  -2.956  1.00  0.00           H  
ATOM   1640  HB3 LYS A 101       5.512  17.784  -4.651  1.00  0.00           H  
ATOM   1641  HG2 LYS A 101       3.052  19.299  -4.185  1.00  0.00           H  
ATOM   1642  HG3 LYS A 101       4.529  20.124  -3.683  1.00  0.00           H  
ATOM   1643  HD2 LYS A 101       5.418  20.099  -5.840  1.00  0.00           H  
ATOM   1644  HD3 LYS A 101       4.336  18.809  -6.371  1.00  0.00           H  
ATOM   1645  HE2 LYS A 101       3.824  21.726  -6.075  1.00  0.00           H  
ATOM   1646  HE3 LYS A 101       3.358  20.627  -7.372  1.00  0.00           H  
ATOM   1647  HZ1 LYS A 101       1.790  19.603  -5.719  1.00  0.00           H  
ATOM   1648  HZ2 LYS A 101       1.398  21.173  -6.215  1.00  0.00           H  
ATOM   1649  HZ3 LYS A 101       2.108  20.917  -4.702  1.00  0.00           H  
ATOM   1650  N   VAL A 102       4.983  14.855  -4.421  1.00  0.00           N  
ATOM   1651  CA  VAL A 102       5.460  13.764  -5.262  1.00  0.00           C  
ATOM   1652  C   VAL A 102       4.306  12.880  -5.723  1.00  0.00           C  
ATOM   1653  O   VAL A 102       4.298  12.393  -6.853  1.00  0.00           O  
ATOM   1654  CB  VAL A 102       6.491  12.893  -4.521  1.00  0.00           C  
ATOM   1655  CG1 VAL A 102       5.848  12.201  -3.331  1.00  0.00           C  
ATOM   1656  CG2 VAL A 102       7.111  11.877  -5.468  1.00  0.00           C  
ATOM   1657  H   VAL A 102       5.281  14.906  -3.489  1.00  0.00           H  
ATOM   1658  HA  VAL A 102       5.939  14.195  -6.129  1.00  0.00           H  
ATOM   1659  HB  VAL A 102       7.276  13.537  -4.153  1.00  0.00           H  
ATOM   1660 HG11 VAL A 102       6.615  11.754  -2.716  1.00  0.00           H  
ATOM   1661 HG12 VAL A 102       5.174  11.432  -3.682  1.00  0.00           H  
ATOM   1662 HG13 VAL A 102       5.296  12.924  -2.748  1.00  0.00           H  
ATOM   1663 HG21 VAL A 102       6.331  11.284  -5.922  1.00  0.00           H  
ATOM   1664 HG22 VAL A 102       7.780  11.233  -4.916  1.00  0.00           H  
ATOM   1665 HG23 VAL A 102       7.664  12.394  -6.239  1.00  0.00           H  
ATOM   1666  N   ALA A 103       3.335  12.677  -4.839  1.00  0.00           N  
ATOM   1667  CA  ALA A 103       2.177  11.851  -5.156  1.00  0.00           C  
ATOM   1668  C   ALA A 103       1.375  12.448  -6.307  1.00  0.00           C  
ATOM   1669  O   ALA A 103       0.708  11.729  -7.050  1.00  0.00           O  
ATOM   1670  CB  ALA A 103       1.296  11.684  -3.927  1.00  0.00           C  
ATOM   1671  H   ALA A 103       3.397  13.093  -3.954  1.00  0.00           H  
ATOM   1672  HA  ALA A 103       2.535  10.874  -5.449  1.00  0.00           H  
ATOM   1673  HB1 ALA A 103       1.635  10.834  -3.354  1.00  0.00           H  
ATOM   1674  HB2 ALA A 103       0.273  11.525  -4.236  1.00  0.00           H  
ATOM   1675  HB3 ALA A 103       1.354  12.574  -3.319  1.00  0.00           H  
ATOM   1676  N   ILE A 104       1.448  13.769  -6.450  1.00  0.00           N  
ATOM   1677  CA  ILE A 104       0.729  14.466  -7.510  1.00  0.00           C  
ATOM   1678  C   ILE A 104       1.142  13.949  -8.882  1.00  0.00           C  
ATOM   1679  O   ILE A 104       0.324  13.861  -9.799  1.00  0.00           O  
ATOM   1680  CB  ILE A 104       0.983  15.987  -7.459  1.00  0.00           C  
ATOM   1681  CG1 ILE A 104       0.127  16.640  -6.372  1.00  0.00           C  
ATOM   1682  CG2 ILE A 104       0.695  16.616  -8.813  1.00  0.00           C  
ATOM   1683  CD1 ILE A 104       0.157  15.903  -5.050  1.00  0.00           C  
ATOM   1684  H   ILE A 104       2.000  14.285  -5.828  1.00  0.00           H  
ATOM   1685  HA  ILE A 104      -0.327  14.292  -7.372  1.00  0.00           H  
ATOM   1686  HB  ILE A 104       2.026  16.146  -7.230  1.00  0.00           H  
ATOM   1687 HG12 ILE A 104       0.486  17.643  -6.197  1.00  0.00           H  
ATOM   1688 HG13 ILE A 104      -0.898  16.684  -6.707  1.00  0.00           H  
ATOM   1689 HG21 ILE A 104       0.287  17.605  -8.672  1.00  0.00           H  
ATOM   1690 HG22 ILE A 104      -0.017  16.006  -9.350  1.00  0.00           H  
ATOM   1691 HG23 ILE A 104       1.611  16.683  -9.380  1.00  0.00           H  
ATOM   1692 HD11 ILE A 104       1.168  15.592  -4.835  1.00  0.00           H  
ATOM   1693 HD12 ILE A 104      -0.483  15.034  -5.109  1.00  0.00           H  
ATOM   1694 HD13 ILE A 104      -0.194  16.558  -4.266  1.00  0.00           H  
ATOM   1695  N   ASN A 105       2.418  13.612  -9.013  1.00  0.00           N  
ATOM   1696  CA  ASN A 105       2.952  13.105 -10.272  1.00  0.00           C  
ATOM   1697  C   ASN A 105       2.238  11.825 -10.702  1.00  0.00           C  
ATOM   1698  O   ASN A 105       2.125  11.538 -11.894  1.00  0.00           O  
ATOM   1699  CB  ASN A 105       4.454  12.843 -10.142  1.00  0.00           C  
ATOM   1700  CG  ASN A 105       5.139  12.726 -11.491  1.00  0.00           C  
ATOM   1701  OD1 ASN A 105       4.691  11.984 -12.365  1.00  0.00           O  
ATOM   1702  ND2 ASN A 105       6.231  13.461 -11.665  1.00  0.00           N  
ATOM   1703  H   ASN A 105       3.017  13.709  -8.242  1.00  0.00           H  
ATOM   1704  HA  ASN A 105       2.793  13.861 -11.027  1.00  0.00           H  
ATOM   1705  HB2 ASN A 105       4.909  13.657  -9.599  1.00  0.00           H  
ATOM   1706  HB3 ASN A 105       4.607  11.922  -9.600  1.00  0.00           H  
ATOM   1707 HD21 ASN A 105       6.530  14.028 -10.924  1.00  0.00           H  
ATOM   1708 HD22 ASN A 105       6.694  13.404 -12.526  1.00  0.00           H  
ATOM   1709  N   GLU A 106       1.765  11.058  -9.726  1.00  0.00           N  
ATOM   1710  CA  GLU A 106       1.070   9.805 -10.006  1.00  0.00           C  
ATOM   1711  C   GLU A 106      -0.336  10.057 -10.545  1.00  0.00           C  
ATOM   1712  O   GLU A 106      -0.849   9.282 -11.352  1.00  0.00           O  
ATOM   1713  CB  GLU A 106       0.996   8.948  -8.742  1.00  0.00           C  
ATOM   1714  CG  GLU A 106       2.187   8.020  -8.565  1.00  0.00           C  
ATOM   1715  CD  GLU A 106       2.892   8.222  -7.239  1.00  0.00           C  
ATOM   1716  OE1 GLU A 106       3.216   9.382  -6.908  1.00  0.00           O  
ATOM   1717  OE2 GLU A 106       3.120   7.219  -6.528  1.00  0.00           O  
ATOM   1718  H   GLU A 106       1.891  11.336  -8.795  1.00  0.00           H  
ATOM   1719  HA  GLU A 106       1.638   9.274 -10.754  1.00  0.00           H  
ATOM   1720  HB2 GLU A 106       0.944   9.599  -7.881  1.00  0.00           H  
ATOM   1721  HB3 GLU A 106       0.100   8.346  -8.781  1.00  0.00           H  
ATOM   1722  HG2 GLU A 106       1.842   6.998  -8.620  1.00  0.00           H  
ATOM   1723  HG3 GLU A 106       2.892   8.204  -9.363  1.00  0.00           H  
ATOM   1724  N   ALA A 107      -0.954  11.147 -10.101  1.00  0.00           N  
ATOM   1725  CA  ALA A 107      -2.294  11.497 -10.543  1.00  0.00           C  
ATOM   1726  C   ALA A 107      -2.443  11.253 -12.035  1.00  0.00           C  
ATOM   1727  O   ALA A 107      -3.120  10.316 -12.461  1.00  0.00           O  
ATOM   1728  CB  ALA A 107      -2.590  12.952 -10.208  1.00  0.00           C  
ATOM   1729  H   ALA A 107      -0.495  11.733  -9.470  1.00  0.00           H  
ATOM   1730  HA  ALA A 107      -3.002  10.878 -10.008  1.00  0.00           H  
ATOM   1731  HB1 ALA A 107      -1.736  13.560 -10.466  1.00  0.00           H  
ATOM   1732  HB2 ALA A 107      -2.792  13.044  -9.151  1.00  0.00           H  
ATOM   1733  HB3 ALA A 107      -3.451  13.282 -10.769  1.00  0.00           H  
ATOM   1734  N   ILE A 108      -1.803  12.104 -12.824  1.00  0.00           N  
ATOM   1735  CA  ILE A 108      -1.860  11.994 -14.273  1.00  0.00           C  
ATOM   1736  C   ILE A 108      -1.637  10.561 -14.740  1.00  0.00           C  
ATOM   1737  O   ILE A 108      -2.287  10.095 -15.675  1.00  0.00           O  
ATOM   1738  CB  ILE A 108      -0.819  12.906 -14.949  1.00  0.00           C  
ATOM   1739  CG1 ILE A 108      -0.788  14.274 -14.268  1.00  0.00           C  
ATOM   1740  CG2 ILE A 108      -1.128  13.053 -16.432  1.00  0.00           C  
ATOM   1741  CD1 ILE A 108      -0.159  15.358 -15.115  1.00  0.00           C  
ATOM   1742  H   ILE A 108      -1.280  12.828 -12.421  1.00  0.00           H  
ATOM   1743  HA  ILE A 108      -2.838  12.314 -14.581  1.00  0.00           H  
ATOM   1744  HB  ILE A 108       0.151  12.442 -14.854  1.00  0.00           H  
ATOM   1745 HG12 ILE A 108      -1.798  14.577 -14.039  1.00  0.00           H  
ATOM   1746 HG13 ILE A 108      -0.223  14.198 -13.350  1.00  0.00           H  
ATOM   1747 HG21 ILE A 108      -1.164  12.076 -16.890  1.00  0.00           H  
ATOM   1748 HG22 ILE A 108      -0.358  13.644 -16.904  1.00  0.00           H  
ATOM   1749 HG23 ILE A 108      -2.083  13.543 -16.554  1.00  0.00           H  
ATOM   1750 HD11 ILE A 108       0.907  15.195 -15.177  1.00  0.00           H  
ATOM   1751 HD12 ILE A 108      -0.350  16.322 -14.667  1.00  0.00           H  
ATOM   1752 HD13 ILE A 108      -0.584  15.333 -16.108  1.00  0.00           H  
ATOM   1753  N   GLU A 109      -0.710   9.867 -14.091  1.00  0.00           N  
ATOM   1754  CA  GLU A 109      -0.400   8.488 -14.452  1.00  0.00           C  
ATOM   1755  C   GLU A 109      -1.595   7.572 -14.211  1.00  0.00           C  
ATOM   1756  O   GLU A 109      -1.967   6.779 -15.078  1.00  0.00           O  
ATOM   1757  CB  GLU A 109       0.805   7.989 -13.651  1.00  0.00           C  
ATOM   1758  CG  GLU A 109       2.143   8.321 -14.291  1.00  0.00           C  
ATOM   1759  CD  GLU A 109       3.275   7.470 -13.747  1.00  0.00           C  
ATOM   1760  OE1 GLU A 109       3.001   6.573 -12.922  1.00  0.00           O  
ATOM   1761  OE2 GLU A 109       4.435   7.701 -14.146  1.00  0.00           O  
ATOM   1762  H   GLU A 109      -0.220  10.291 -13.356  1.00  0.00           H  
ATOM   1763  HA  GLU A 109      -0.153   8.469 -15.502  1.00  0.00           H  
ATOM   1764  HB2 GLU A 109       0.779   8.437 -12.669  1.00  0.00           H  
ATOM   1765  HB3 GLU A 109       0.735   6.916 -13.549  1.00  0.00           H  
ATOM   1766  HG2 GLU A 109       2.070   8.157 -15.355  1.00  0.00           H  
ATOM   1767  HG3 GLU A 109       2.370   9.360 -14.102  1.00  0.00           H  
ATOM   1768  N   LEU A 110      -2.188   7.684 -13.030  1.00  0.00           N  
ATOM   1769  CA  LEU A 110      -3.335   6.860 -12.668  1.00  0.00           C  
ATOM   1770  C   LEU A 110      -4.606   7.341 -13.363  1.00  0.00           C  
ATOM   1771  O   LEU A 110      -5.680   6.768 -13.179  1.00  0.00           O  
ATOM   1772  CB  LEU A 110      -3.525   6.871 -11.151  1.00  0.00           C  
ATOM   1773  CG  LEU A 110      -2.232   6.792 -10.337  1.00  0.00           C  
ATOM   1774  CD1 LEU A 110      -2.513   6.260  -8.940  1.00  0.00           C  
ATOM   1775  CD2 LEU A 110      -1.211   5.916 -11.048  1.00  0.00           C  
ATOM   1776  H   LEU A 110      -1.845   8.334 -12.382  1.00  0.00           H  
ATOM   1777  HA  LEU A 110      -3.131   5.847 -12.987  1.00  0.00           H  
ATOM   1778  HB2 LEU A 110      -4.041   7.781 -10.881  1.00  0.00           H  
ATOM   1779  HB3 LEU A 110      -4.143   6.032 -10.880  1.00  0.00           H  
ATOM   1780  HG  LEU A 110      -1.815   7.783 -10.240  1.00  0.00           H  
ATOM   1781 HD11 LEU A 110      -3.270   6.870  -8.470  1.00  0.00           H  
ATOM   1782 HD12 LEU A 110      -1.607   6.294  -8.354  1.00  0.00           H  
ATOM   1783 HD13 LEU A 110      -2.861   5.240  -9.007  1.00  0.00           H  
ATOM   1784 HD21 LEU A 110      -0.736   6.482 -11.836  1.00  0.00           H  
ATOM   1785 HD22 LEU A 110      -1.706   5.055 -11.472  1.00  0.00           H  
ATOM   1786 HD23 LEU A 110      -0.464   5.588 -10.340  1.00  0.00           H  
ATOM   1787  N   ALA A 111      -4.479   8.388 -14.169  1.00  0.00           N  
ATOM   1788  CA  ALA A 111      -5.620   8.933 -14.892  1.00  0.00           C  
ATOM   1789  C   ALA A 111      -5.331   9.018 -16.388  1.00  0.00           C  
ATOM   1790  O   ALA A 111      -6.150   9.518 -17.160  1.00  0.00           O  
ATOM   1791  CB  ALA A 111      -5.992  10.301 -14.343  1.00  0.00           C  
ATOM   1792  H   ALA A 111      -3.598   8.803 -14.283  1.00  0.00           H  
ATOM   1793  HA  ALA A 111      -6.459   8.270 -14.737  1.00  0.00           H  
ATOM   1794  HB1 ALA A 111      -7.036  10.306 -14.069  1.00  0.00           H  
ATOM   1795  HB2 ALA A 111      -5.813  11.053 -15.098  1.00  0.00           H  
ATOM   1796  HB3 ALA A 111      -5.390  10.514 -13.472  1.00  0.00           H  
ATOM   1797  N   LYS A 112      -4.165   8.524 -16.792  1.00  0.00           N  
ATOM   1798  CA  LYS A 112      -3.774   8.541 -18.197  1.00  0.00           C  
ATOM   1799  C   LYS A 112      -3.570   7.123 -18.717  1.00  0.00           C  
ATOM   1800  O   LYS A 112      -3.751   6.852 -19.904  1.00  0.00           O  
ATOM   1801  CB  LYS A 112      -2.493   9.357 -18.381  1.00  0.00           C  
ATOM   1802  CG  LYS A 112      -1.236   8.625 -17.938  1.00  0.00           C  
ATOM   1803  CD  LYS A 112      -0.117   9.596 -17.600  1.00  0.00           C  
ATOM   1804  CE  LYS A 112       0.214  10.495 -18.780  1.00  0.00           C  
ATOM   1805  NZ  LYS A 112       1.563  11.114 -18.646  1.00  0.00           N  
ATOM   1806  H   LYS A 112      -3.554   8.135 -16.131  1.00  0.00           H  
ATOM   1807  HA  LYS A 112      -4.570   9.007 -18.757  1.00  0.00           H  
ATOM   1808  HB2 LYS A 112      -2.387   9.608 -19.426  1.00  0.00           H  
ATOM   1809  HB3 LYS A 112      -2.574  10.267 -17.807  1.00  0.00           H  
ATOM   1810  HG2 LYS A 112      -1.463   8.035 -17.064  1.00  0.00           H  
ATOM   1811  HG3 LYS A 112      -0.909   7.977 -18.738  1.00  0.00           H  
ATOM   1812  HD2 LYS A 112      -0.426  10.211 -16.768  1.00  0.00           H  
ATOM   1813  HD3 LYS A 112       0.765   9.035 -17.328  1.00  0.00           H  
ATOM   1814  HE2 LYS A 112       0.188   9.907 -19.684  1.00  0.00           H  
ATOM   1815  HE3 LYS A 112      -0.527  11.279 -18.840  1.00  0.00           H  
ATOM   1816  HZ1 LYS A 112       1.889  11.051 -17.661  1.00  0.00           H  
ATOM   1817  HZ2 LYS A 112       1.526  12.115 -18.924  1.00  0.00           H  
ATOM   1818  HZ3 LYS A 112       2.244  10.621 -19.258  1.00  0.00           H  
ATOM   1819  N   SER A 113      -3.193   6.221 -17.816  1.00  0.00           N  
ATOM   1820  CA  SER A 113      -2.964   4.827 -18.175  1.00  0.00           C  
ATOM   1821  C   SER A 113      -3.940   3.913 -17.444  1.00  0.00           C  
ATOM   1822  O   SER A 113      -4.193   2.786 -17.872  1.00  0.00           O  
ATOM   1823  CB  SER A 113      -1.526   4.427 -17.840  1.00  0.00           C  
ATOM   1824  OG  SER A 113      -1.082   3.371 -18.674  1.00  0.00           O  
ATOM   1825  H   SER A 113      -3.067   6.501 -16.886  1.00  0.00           H  
ATOM   1826  HA  SER A 113      -3.118   4.727 -19.239  1.00  0.00           H  
ATOM   1827  HB2 SER A 113      -0.876   5.277 -17.979  1.00  0.00           H  
ATOM   1828  HB3 SER A 113      -1.478   4.102 -16.810  1.00  0.00           H  
ATOM   1829  HG  SER A 113      -0.391   2.878 -18.227  1.00  0.00           H  
ATOM   1830  N   PHE A 114      -4.484   4.406 -16.335  1.00  0.00           N  
ATOM   1831  CA  PHE A 114      -5.430   3.635 -15.538  1.00  0.00           C  
ATOM   1832  C   PHE A 114      -6.869   4.041 -15.846  1.00  0.00           C  
ATOM   1833  O   PHE A 114      -7.815   3.420 -15.361  1.00  0.00           O  
ATOM   1834  CB  PHE A 114      -5.137   3.825 -14.049  1.00  0.00           C  
ATOM   1835  CG  PHE A 114      -3.866   3.160 -13.602  1.00  0.00           C  
ATOM   1836  CD1 PHE A 114      -2.635   3.737 -13.875  1.00  0.00           C  
ATOM   1837  CD2 PHE A 114      -3.901   1.960 -12.911  1.00  0.00           C  
ATOM   1838  CE1 PHE A 114      -1.464   3.129 -13.467  1.00  0.00           C  
ATOM   1839  CE2 PHE A 114      -2.732   1.347 -12.501  1.00  0.00           C  
ATOM   1840  CZ  PHE A 114      -1.512   1.932 -12.779  1.00  0.00           C  
ATOM   1841  H   PHE A 114      -4.240   5.309 -16.046  1.00  0.00           H  
ATOM   1842  HA  PHE A 114      -5.301   2.592 -15.789  1.00  0.00           H  
ATOM   1843  HB2 PHE A 114      -5.050   4.880 -13.840  1.00  0.00           H  
ATOM   1844  HB3 PHE A 114      -5.950   3.414 -13.472  1.00  0.00           H  
ATOM   1845  HD1 PHE A 114      -2.597   4.673 -14.413  1.00  0.00           H  
ATOM   1846  HD2 PHE A 114      -4.854   1.502 -12.693  1.00  0.00           H  
ATOM   1847  HE1 PHE A 114      -0.511   3.589 -13.686  1.00  0.00           H  
ATOM   1848  HE2 PHE A 114      -2.773   0.411 -11.963  1.00  0.00           H  
ATOM   1849  HZ  PHE A 114      -0.597   1.455 -12.459  1.00  0.00           H  
ATOM   1850  N   GLY A 115      -7.027   5.083 -16.654  1.00  0.00           N  
ATOM   1851  CA  GLY A 115      -8.354   5.551 -17.012  1.00  0.00           C  
ATOM   1852  C   GLY A 115      -8.464   5.915 -18.480  1.00  0.00           C  
ATOM   1853  O   GLY A 115      -8.429   5.043 -19.347  1.00  0.00           O  
ATOM   1854  H   GLY A 115      -6.238   5.539 -17.012  1.00  0.00           H  
ATOM   1855  HA2 GLY A 115      -9.070   4.772 -16.791  1.00  0.00           H  
ATOM   1856  HA3 GLY A 115      -8.590   6.421 -16.417  1.00  0.00           H  
ATOM   1857  N   ALA A 116      -8.597   7.209 -18.759  1.00  0.00           N  
ATOM   1858  CA  ALA A 116      -8.712   7.687 -20.131  1.00  0.00           C  
ATOM   1859  C   ALA A 116      -7.794   8.881 -20.375  1.00  0.00           C  
ATOM   1860  O   ALA A 116      -7.162   9.388 -19.450  1.00  0.00           O  
ATOM   1861  CB  ALA A 116     -10.155   8.056 -20.442  1.00  0.00           C  
ATOM   1862  H   ALA A 116      -8.618   7.857 -18.023  1.00  0.00           H  
ATOM   1863  HA  ALA A 116      -8.422   6.882 -20.790  1.00  0.00           H  
ATOM   1864  HB1 ALA A 116     -10.224   9.120 -20.617  1.00  0.00           H  
ATOM   1865  HB2 ALA A 116     -10.783   7.788 -19.606  1.00  0.00           H  
ATOM   1866  HB3 ALA A 116     -10.481   7.525 -21.323  1.00  0.00           H  
ATOM   1867  N   GLU A 117      -7.726   9.323 -21.627  1.00  0.00           N  
ATOM   1868  CA  GLU A 117      -6.885  10.458 -21.990  1.00  0.00           C  
ATOM   1869  C   GLU A 117      -7.698  11.748 -22.028  1.00  0.00           C  
ATOM   1870  O   GLU A 117      -8.715  11.872 -21.346  1.00  0.00           O  
ATOM   1871  CB  GLU A 117      -6.225  10.216 -23.350  1.00  0.00           C  
ATOM   1872  CG  GLU A 117      -4.739  10.532 -23.368  1.00  0.00           C  
ATOM   1873  CD  GLU A 117      -4.319  11.292 -24.610  1.00  0.00           C  
ATOM   1874  OE1 GLU A 117      -4.985  12.294 -24.946  1.00  0.00           O  
ATOM   1875  OE2 GLU A 117      -3.325  10.886 -25.248  1.00  0.00           O  
ATOM   1876  H   GLU A 117      -8.254   8.877 -22.321  1.00  0.00           H  
ATOM   1877  HA  GLU A 117      -6.116  10.553 -21.239  1.00  0.00           H  
ATOM   1878  HB2 GLU A 117      -6.355   9.179 -23.621  1.00  0.00           H  
ATOM   1879  HB3 GLU A 117      -6.712  10.836 -24.088  1.00  0.00           H  
ATOM   1880  HG2 GLU A 117      -4.499  11.130 -22.500  1.00  0.00           H  
ATOM   1881  HG3 GLU A 117      -4.186   9.605 -23.327  1.00  0.00           H  
ATOM   1882  N   ASP A 118      -7.243  12.706 -22.829  1.00  0.00           N  
ATOM   1883  CA  ASP A 118      -7.929  13.987 -22.953  1.00  0.00           C  
ATOM   1884  C   ASP A 118      -7.926  14.735 -21.624  1.00  0.00           C  
ATOM   1885  O   ASP A 118      -7.205  15.719 -21.456  1.00  0.00           O  
ATOM   1886  CB  ASP A 118      -9.367  13.775 -23.431  1.00  0.00           C  
ATOM   1887  CG  ASP A 118      -9.450  12.827 -24.610  1.00  0.00           C  
ATOM   1888  OD1 ASP A 118      -8.565  12.894 -25.490  1.00  0.00           O  
ATOM   1889  OD2 ASP A 118     -10.399  12.017 -24.655  1.00  0.00           O  
ATOM   1890  H   ASP A 118      -6.426  12.549 -23.347  1.00  0.00           H  
ATOM   1891  HA  ASP A 118      -7.399  14.577 -23.686  1.00  0.00           H  
ATOM   1892  HB2 ASP A 118      -9.951  13.364 -22.621  1.00  0.00           H  
ATOM   1893  HB3 ASP A 118      -9.785  14.726 -23.725  1.00  0.00           H  
ATOM   1894  N   SER A 119      -8.733  14.259 -20.682  1.00  0.00           N  
ATOM   1895  CA  SER A 119      -8.820  14.880 -19.365  1.00  0.00           C  
ATOM   1896  C   SER A 119      -7.907  14.171 -18.372  1.00  0.00           C  
ATOM   1897  O   SER A 119      -8.357  13.690 -17.332  1.00  0.00           O  
ATOM   1898  CB  SER A 119     -10.264  14.852 -18.860  1.00  0.00           C  
ATOM   1899  OG  SER A 119     -11.146  14.372 -19.860  1.00  0.00           O  
ATOM   1900  H   SER A 119      -9.281  13.470 -20.875  1.00  0.00           H  
ATOM   1901  HA  SER A 119      -8.501  15.907 -19.461  1.00  0.00           H  
ATOM   1902  HB2 SER A 119     -10.329  14.203 -17.999  1.00  0.00           H  
ATOM   1903  HB3 SER A 119     -10.564  15.852 -18.581  1.00  0.00           H  
ATOM   1904  HG  SER A 119     -10.973  13.441 -20.018  1.00  0.00           H  
ATOM   1905  N   HIS A 120      -6.621  14.107 -18.701  1.00  0.00           N  
ATOM   1906  CA  HIS A 120      -5.642  13.453 -17.841  1.00  0.00           C  
ATOM   1907  C   HIS A 120      -4.891  14.472 -16.991  1.00  0.00           C  
ATOM   1908  O   HIS A 120      -4.673  14.260 -15.799  1.00  0.00           O  
ATOM   1909  CB  HIS A 120      -4.653  12.646 -18.683  1.00  0.00           C  
ATOM   1910  CG  HIS A 120      -3.862  13.482 -19.640  1.00  0.00           C  
ATOM   1911  ND1 HIS A 120      -4.167  13.584 -20.982  1.00  0.00           N  
ATOM   1912  CD2 HIS A 120      -2.771  14.261 -19.446  1.00  0.00           C  
ATOM   1913  CE1 HIS A 120      -3.298  14.386 -21.570  1.00  0.00           C  
ATOM   1914  NE2 HIS A 120      -2.442  14.811 -20.659  1.00  0.00           N  
ATOM   1915  H   HIS A 120      -6.323  14.506 -19.545  1.00  0.00           H  
ATOM   1916  HA  HIS A 120      -6.175  12.780 -17.186  1.00  0.00           H  
ATOM   1917  HB2 HIS A 120      -3.957  12.144 -18.027  1.00  0.00           H  
ATOM   1918  HB3 HIS A 120      -5.196  11.907 -19.255  1.00  0.00           H  
ATOM   1919  HD1 HIS A 120      -4.909  13.132 -21.435  1.00  0.00           H  
ATOM   1920  HD2 HIS A 120      -2.255  14.418 -18.509  1.00  0.00           H  
ATOM   1921  HE1 HIS A 120      -3.291  14.653 -22.617  1.00  0.00           H  
ATOM   1922  HE2 HIS A 120      -1.751  15.491 -20.808  1.00  0.00           H  
ATOM   1923  N   LYS A 121      -4.492  15.577 -17.614  1.00  0.00           N  
ATOM   1924  CA  LYS A 121      -3.760  16.627 -16.912  1.00  0.00           C  
ATOM   1925  C   LYS A 121      -4.582  17.190 -15.756  1.00  0.00           C  
ATOM   1926  O   LYS A 121      -4.038  17.529 -14.704  1.00  0.00           O  
ATOM   1927  CB  LYS A 121      -3.386  17.750 -17.882  1.00  0.00           C  
ATOM   1928  CG  LYS A 121      -4.572  18.593 -18.323  1.00  0.00           C  
ATOM   1929  CD  LYS A 121      -4.123  19.925 -18.901  1.00  0.00           C  
ATOM   1930  CE  LYS A 121      -4.534  21.085 -18.009  1.00  0.00           C  
ATOM   1931  NZ  LYS A 121      -3.497  22.153 -17.973  1.00  0.00           N  
ATOM   1932  H   LYS A 121      -4.692  15.689 -18.566  1.00  0.00           H  
ATOM   1933  HA  LYS A 121      -2.855  16.190 -16.516  1.00  0.00           H  
ATOM   1934  HB2 LYS A 121      -2.669  18.399 -17.401  1.00  0.00           H  
ATOM   1935  HB3 LYS A 121      -2.933  17.315 -18.760  1.00  0.00           H  
ATOM   1936  HG2 LYS A 121      -5.124  18.052 -19.077  1.00  0.00           H  
ATOM   1937  HG3 LYS A 121      -5.208  18.776 -17.469  1.00  0.00           H  
ATOM   1938  HD2 LYS A 121      -3.048  19.922 -18.998  1.00  0.00           H  
ATOM   1939  HD3 LYS A 121      -4.573  20.053 -19.874  1.00  0.00           H  
ATOM   1940  HE2 LYS A 121      -5.456  21.503 -18.386  1.00  0.00           H  
ATOM   1941  HE3 LYS A 121      -4.691  20.715 -17.007  1.00  0.00           H  
ATOM   1942  HZ1 LYS A 121      -3.915  23.047 -17.643  1.00  0.00           H  
ATOM   1943  HZ2 LYS A 121      -3.102  22.300 -18.925  1.00  0.00           H  
ATOM   1944  HZ3 LYS A 121      -2.727  21.883 -17.329  1.00  0.00           H  
ATOM   1945  N   PHE A 122      -5.891  17.286 -15.957  1.00  0.00           N  
ATOM   1946  CA  PHE A 122      -6.784  17.812 -14.932  1.00  0.00           C  
ATOM   1947  C   PHE A 122      -6.692  16.982 -13.656  1.00  0.00           C  
ATOM   1948  O   PHE A 122      -6.813  17.508 -12.551  1.00  0.00           O  
ATOM   1949  CB  PHE A 122      -8.227  17.828 -15.441  1.00  0.00           C  
ATOM   1950  CG  PHE A 122      -9.232  18.195 -14.388  1.00  0.00           C  
ATOM   1951  CD1 PHE A 122      -9.672  17.254 -13.472  1.00  0.00           C  
ATOM   1952  CD2 PHE A 122      -9.738  19.484 -14.315  1.00  0.00           C  
ATOM   1953  CE1 PHE A 122     -10.597  17.589 -12.503  1.00  0.00           C  
ATOM   1954  CE2 PHE A 122     -10.663  19.825 -13.347  1.00  0.00           C  
ATOM   1955  CZ  PHE A 122     -11.093  18.877 -12.440  1.00  0.00           C  
ATOM   1956  H   PHE A 122      -6.266  17.000 -16.817  1.00  0.00           H  
ATOM   1957  HA  PHE A 122      -6.479  18.824 -14.712  1.00  0.00           H  
ATOM   1958  HB2 PHE A 122      -8.309  18.545 -16.244  1.00  0.00           H  
ATOM   1959  HB3 PHE A 122      -8.479  16.846 -15.815  1.00  0.00           H  
ATOM   1960  HD1 PHE A 122      -9.284  16.246 -13.520  1.00  0.00           H  
ATOM   1961  HD2 PHE A 122      -9.402  20.226 -15.024  1.00  0.00           H  
ATOM   1962  HE1 PHE A 122     -10.932  16.845 -11.795  1.00  0.00           H  
ATOM   1963  HE2 PHE A 122     -11.050  20.833 -13.300  1.00  0.00           H  
ATOM   1964  HZ  PHE A 122     -11.817  19.142 -11.683  1.00  0.00           H  
ATOM   1965  N   VAL A 123      -6.471  15.683 -13.819  1.00  0.00           N  
ATOM   1966  CA  VAL A 123      -6.355  14.781 -12.681  1.00  0.00           C  
ATOM   1967  C   VAL A 123      -5.189  15.176 -11.784  1.00  0.00           C  
ATOM   1968  O   VAL A 123      -5.282  15.118 -10.560  1.00  0.00           O  
ATOM   1969  CB  VAL A 123      -6.168  13.320 -13.130  1.00  0.00           C  
ATOM   1970  CG1 VAL A 123      -6.968  13.041 -14.393  1.00  0.00           C  
ATOM   1971  CG2 VAL A 123      -4.695  13.001 -13.340  1.00  0.00           C  
ATOM   1972  H   VAL A 123      -6.379  15.322 -14.726  1.00  0.00           H  
ATOM   1973  HA  VAL A 123      -7.272  14.844 -12.112  1.00  0.00           H  
ATOM   1974  HB  VAL A 123      -6.542  12.679 -12.349  1.00  0.00           H  
ATOM   1975 HG11 VAL A 123      -6.296  12.981 -15.236  1.00  0.00           H  
ATOM   1976 HG12 VAL A 123      -7.677  13.839 -14.552  1.00  0.00           H  
ATOM   1977 HG13 VAL A 123      -7.496  12.106 -14.285  1.00  0.00           H  
ATOM   1978 HG21 VAL A 123      -4.207  13.840 -13.806  1.00  0.00           H  
ATOM   1979 HG22 VAL A 123      -4.601  12.134 -13.975  1.00  0.00           H  
ATOM   1980 HG23 VAL A 123      -4.232  12.800 -12.386  1.00  0.00           H  
ATOM   1981  N   ASN A 124      -4.087  15.576 -12.401  1.00  0.00           N  
ATOM   1982  CA  ASN A 124      -2.901  15.974 -11.655  1.00  0.00           C  
ATOM   1983  C   ASN A 124      -3.230  17.089 -10.671  1.00  0.00           C  
ATOM   1984  O   ASN A 124      -2.819  17.050  -9.510  1.00  0.00           O  
ATOM   1985  CB  ASN A 124      -1.800  16.433 -12.612  1.00  0.00           C  
ATOM   1986  CG  ASN A 124      -1.373  17.865 -12.356  1.00  0.00           C  
ATOM   1987  OD1 ASN A 124      -1.545  18.738 -13.206  1.00  0.00           O  
ATOM   1988  ND2 ASN A 124      -0.810  18.113 -11.178  1.00  0.00           N  
ATOM   1989  H   ASN A 124      -4.069  15.603 -13.381  1.00  0.00           H  
ATOM   1990  HA  ASN A 124      -2.552  15.114 -11.104  1.00  0.00           H  
ATOM   1991  HB2 ASN A 124      -0.938  15.794 -12.494  1.00  0.00           H  
ATOM   1992  HB3 ASN A 124      -2.161  16.361 -13.627  1.00  0.00           H  
ATOM   1993 HD21 ASN A 124      -0.705  17.368 -10.550  1.00  0.00           H  
ATOM   1994 HD22 ASN A 124      -0.524  19.030 -10.987  1.00  0.00           H  
ATOM   1995  N   GLY A 125      -3.975  18.082 -11.141  1.00  0.00           N  
ATOM   1996  CA  GLY A 125      -4.337  19.197 -10.291  1.00  0.00           C  
ATOM   1997  C   GLY A 125      -5.142  18.773  -9.081  1.00  0.00           C  
ATOM   1998  O   GLY A 125      -5.003  19.357  -8.006  1.00  0.00           O  
ATOM   1999  H   GLY A 125      -4.277  18.059 -12.074  1.00  0.00           H  
ATOM   2000  HA2 GLY A 125      -3.434  19.686  -9.955  1.00  0.00           H  
ATOM   2001  HA3 GLY A 125      -4.920  19.900 -10.868  1.00  0.00           H  
ATOM   2002  N   VAL A 126      -5.973  17.748  -9.239  1.00  0.00           N  
ATOM   2003  CA  VAL A 126      -6.779  17.267  -8.126  1.00  0.00           C  
ATOM   2004  C   VAL A 126      -5.885  16.840  -6.973  1.00  0.00           C  
ATOM   2005  O   VAL A 126      -6.182  17.110  -5.810  1.00  0.00           O  
ATOM   2006  CB  VAL A 126      -7.672  16.074  -8.516  1.00  0.00           C  
ATOM   2007  CG1 VAL A 126      -8.051  16.131  -9.988  1.00  0.00           C  
ATOM   2008  CG2 VAL A 126      -6.980  14.763  -8.170  1.00  0.00           C  
ATOM   2009  H   VAL A 126      -6.037  17.306 -10.112  1.00  0.00           H  
ATOM   2010  HA  VAL A 126      -7.413  18.077  -7.797  1.00  0.00           H  
ATOM   2011  HB  VAL A 126      -8.582  16.135  -7.936  1.00  0.00           H  
ATOM   2012 HG11 VAL A 126      -8.815  15.396 -10.192  1.00  0.00           H  
ATOM   2013 HG12 VAL A 126      -7.184  15.924 -10.593  1.00  0.00           H  
ATOM   2014 HG13 VAL A 126      -8.427  17.115 -10.226  1.00  0.00           H  
ATOM   2015 HG21 VAL A 126      -6.020  14.716  -8.663  1.00  0.00           H  
ATOM   2016 HG22 VAL A 126      -7.591  13.934  -8.495  1.00  0.00           H  
ATOM   2017 HG23 VAL A 126      -6.836  14.706  -7.099  1.00  0.00           H  
ATOM   2018  N   LEU A 127      -4.781  16.176  -7.304  1.00  0.00           N  
ATOM   2019  CA  LEU A 127      -3.845  15.718  -6.291  1.00  0.00           C  
ATOM   2020  C   LEU A 127      -3.129  16.899  -5.654  1.00  0.00           C  
ATOM   2021  O   LEU A 127      -2.770  16.858  -4.478  1.00  0.00           O  
ATOM   2022  CB  LEU A 127      -2.832  14.743  -6.890  1.00  0.00           C  
ATOM   2023  CG  LEU A 127      -2.970  13.296  -6.411  1.00  0.00           C  
ATOM   2024  CD1 LEU A 127      -1.697  12.519  -6.694  1.00  0.00           C  
ATOM   2025  CD2 LEU A 127      -3.297  13.254  -4.926  1.00  0.00           C  
ATOM   2026  H   LEU A 127      -4.590  15.998  -8.252  1.00  0.00           H  
ATOM   2027  HA  LEU A 127      -4.413  15.208  -5.528  1.00  0.00           H  
ATOM   2028  HB2 LEU A 127      -2.941  14.758  -7.965  1.00  0.00           H  
ATOM   2029  HB3 LEU A 127      -1.842  15.087  -6.640  1.00  0.00           H  
ATOM   2030  HG  LEU A 127      -3.779  12.821  -6.947  1.00  0.00           H  
ATOM   2031 HD11 LEU A 127      -0.941  12.793  -5.972  1.00  0.00           H  
ATOM   2032 HD12 LEU A 127      -1.346  12.752  -7.688  1.00  0.00           H  
ATOM   2033 HD13 LEU A 127      -1.898  11.460  -6.622  1.00  0.00           H  
ATOM   2034 HD21 LEU A 127      -4.317  12.925  -4.791  1.00  0.00           H  
ATOM   2035 HD22 LEU A 127      -3.178  14.241  -4.502  1.00  0.00           H  
ATOM   2036 HD23 LEU A 127      -2.628  12.566  -4.430  1.00  0.00           H  
ATOM   2037  N   ASP A 128      -2.929  17.957  -6.435  1.00  0.00           N  
ATOM   2038  CA  ASP A 128      -2.261  19.148  -5.934  1.00  0.00           C  
ATOM   2039  C   ASP A 128      -3.064  19.754  -4.793  1.00  0.00           C  
ATOM   2040  O   ASP A 128      -2.513  20.108  -3.754  1.00  0.00           O  
ATOM   2041  CB  ASP A 128      -2.084  20.173  -7.055  1.00  0.00           C  
ATOM   2042  CG  ASP A 128      -1.317  21.400  -6.602  1.00  0.00           C  
ATOM   2043  OD1 ASP A 128      -0.071  21.336  -6.555  1.00  0.00           O  
ATOM   2044  OD2 ASP A 128      -1.963  22.423  -6.295  1.00  0.00           O  
ATOM   2045  H   ASP A 128      -3.244  17.936  -7.364  1.00  0.00           H  
ATOM   2046  HA  ASP A 128      -1.290  18.855  -5.563  1.00  0.00           H  
ATOM   2047  HB2 ASP A 128      -1.544  19.715  -7.872  1.00  0.00           H  
ATOM   2048  HB3 ASP A 128      -3.056  20.486  -7.405  1.00  0.00           H  
ATOM   2049  N   LYS A 129      -4.373  19.865  -4.997  1.00  0.00           N  
ATOM   2050  CA  LYS A 129      -5.264  20.412  -3.983  1.00  0.00           C  
ATOM   2051  C   LYS A 129      -5.607  19.369  -2.919  1.00  0.00           C  
ATOM   2052  O   LYS A 129      -5.646  19.672  -1.725  1.00  0.00           O  
ATOM   2053  CB  LYS A 129      -6.548  20.931  -4.634  1.00  0.00           C  
ATOM   2054  CG  LYS A 129      -6.334  21.523  -6.017  1.00  0.00           C  
ATOM   2055  CD  LYS A 129      -5.239  22.579  -6.006  1.00  0.00           C  
ATOM   2056  CE  LYS A 129      -5.166  23.318  -7.333  1.00  0.00           C  
ATOM   2057  NZ  LYS A 129      -5.586  24.740  -7.201  1.00  0.00           N  
ATOM   2058  H   LYS A 129      -4.750  19.559  -5.849  1.00  0.00           H  
ATOM   2059  HA  LYS A 129      -4.756  21.238  -3.508  1.00  0.00           H  
ATOM   2060  HB2 LYS A 129      -7.249  20.115  -4.720  1.00  0.00           H  
ATOM   2061  HB3 LYS A 129      -6.975  21.695  -4.001  1.00  0.00           H  
ATOM   2062  HG2 LYS A 129      -6.051  20.734  -6.696  1.00  0.00           H  
ATOM   2063  HG3 LYS A 129      -7.255  21.976  -6.350  1.00  0.00           H  
ATOM   2064  HD2 LYS A 129      -5.446  23.291  -5.222  1.00  0.00           H  
ATOM   2065  HD3 LYS A 129      -4.290  22.098  -5.819  1.00  0.00           H  
ATOM   2066  HE2 LYS A 129      -4.148  23.285  -7.693  1.00  0.00           H  
ATOM   2067  HE3 LYS A 129      -5.813  22.824  -8.042  1.00  0.00           H  
ATOM   2068  HZ1 LYS A 129      -6.073  24.886  -6.294  1.00  0.00           H  
ATOM   2069  HZ2 LYS A 129      -6.234  24.994  -7.974  1.00  0.00           H  
ATOM   2070  HZ3 LYS A 129      -4.755  25.364  -7.242  1.00  0.00           H  
ATOM   2071  N   ALA A 130      -5.884  18.145  -3.366  1.00  0.00           N  
ATOM   2072  CA  ALA A 130      -6.260  17.053  -2.469  1.00  0.00           C  
ATOM   2073  C   ALA A 130      -5.091  16.530  -1.633  1.00  0.00           C  
ATOM   2074  O   ALA A 130      -5.297  15.989  -0.548  1.00  0.00           O  
ATOM   2075  CB  ALA A 130      -6.873  15.918  -3.275  1.00  0.00           C  
ATOM   2076  H   ALA A 130      -5.857  17.973  -4.333  1.00  0.00           H  
ATOM   2077  HA  ALA A 130      -7.019  17.427  -1.800  1.00  0.00           H  
ATOM   2078  HB1 ALA A 130      -6.116  15.178  -3.487  1.00  0.00           H  
ATOM   2079  HB2 ALA A 130      -7.266  16.306  -4.202  1.00  0.00           H  
ATOM   2080  HB3 ALA A 130      -7.670  15.463  -2.710  1.00  0.00           H  
ATOM   2081  N   ALA A 131      -3.874  16.664  -2.145  1.00  0.00           N  
ATOM   2082  CA  ALA A 131      -2.695  16.171  -1.437  1.00  0.00           C  
ATOM   2083  C   ALA A 131      -2.420  16.951  -0.151  1.00  0.00           C  
ATOM   2084  O   ALA A 131      -2.207  16.359   0.907  1.00  0.00           O  
ATOM   2085  CB  ALA A 131      -1.480  16.204  -2.350  1.00  0.00           C  
ATOM   2086  H   ALA A 131      -3.765  17.088  -3.022  1.00  0.00           H  
ATOM   2087  HA  ALA A 131      -2.882  15.139  -1.176  1.00  0.00           H  
ATOM   2088  HB1 ALA A 131      -1.665  15.587  -3.219  1.00  0.00           H  
ATOM   2089  HB2 ALA A 131      -0.620  15.826  -1.819  1.00  0.00           H  
ATOM   2090  HB3 ALA A 131      -1.293  17.220  -2.665  1.00  0.00           H  
ATOM   2091  N   PRO A 132      -2.409  18.288  -0.228  1.00  0.00           N  
ATOM   2092  CA  PRO A 132      -2.143  19.149   0.932  1.00  0.00           C  
ATOM   2093  C   PRO A 132      -3.320  19.221   1.902  1.00  0.00           C  
ATOM   2094  O   PRO A 132      -3.719  20.304   2.331  1.00  0.00           O  
ATOM   2095  CB  PRO A 132      -1.888  20.514   0.296  1.00  0.00           C  
ATOM   2096  CG  PRO A 132      -2.679  20.490  -0.965  1.00  0.00           C  
ATOM   2097  CD  PRO A 132      -2.640  19.069  -1.452  1.00  0.00           C  
ATOM   2098  HA  PRO A 132      -1.259  18.829   1.468  1.00  0.00           H  
ATOM   2099  HB2 PRO A 132      -2.225  21.295   0.962  1.00  0.00           H  
ATOM   2100  HB3 PRO A 132      -0.833  20.629   0.096  1.00  0.00           H  
ATOM   2101  HG2 PRO A 132      -3.698  20.788  -0.766  1.00  0.00           H  
ATOM   2102  HG3 PRO A 132      -2.230  21.148  -1.694  1.00  0.00           H  
ATOM   2103  HD2 PRO A 132      -3.581  18.803  -1.907  1.00  0.00           H  
ATOM   2104  HD3 PRO A 132      -1.829  18.933  -2.153  1.00  0.00           H  
ATOM   2105  N   VAL A 133      -3.861  18.061   2.257  1.00  0.00           N  
ATOM   2106  CA  VAL A 133      -4.977  17.986   3.190  1.00  0.00           C  
ATOM   2107  C   VAL A 133      -4.730  16.883   4.210  1.00  0.00           C  
ATOM   2108  O   VAL A 133      -4.651  17.141   5.411  1.00  0.00           O  
ATOM   2109  CB  VAL A 133      -6.308  17.722   2.465  1.00  0.00           C  
ATOM   2110  CG1 VAL A 133      -7.348  17.193   3.440  1.00  0.00           C  
ATOM   2111  CG2 VAL A 133      -6.803  18.987   1.781  1.00  0.00           C  
ATOM   2112  H   VAL A 133      -3.492  17.231   1.892  1.00  0.00           H  
ATOM   2113  HA  VAL A 133      -5.048  18.933   3.705  1.00  0.00           H  
ATOM   2114  HB  VAL A 133      -6.140  16.972   1.708  1.00  0.00           H  
ATOM   2115 HG11 VAL A 133      -7.545  17.939   4.197  1.00  0.00           H  
ATOM   2116 HG12 VAL A 133      -6.976  16.294   3.908  1.00  0.00           H  
ATOM   2117 HG13 VAL A 133      -8.261  16.971   2.908  1.00  0.00           H  
ATOM   2118 HG21 VAL A 133      -7.861  18.900   1.584  1.00  0.00           H  
ATOM   2119 HG22 VAL A 133      -6.273  19.123   0.850  1.00  0.00           H  
ATOM   2120 HG23 VAL A 133      -6.625  19.837   2.424  1.00  0.00           H  
ATOM   2121  N   ILE A 134      -4.581  15.656   3.720  1.00  0.00           N  
ATOM   2122  CA  ILE A 134      -4.312  14.520   4.582  1.00  0.00           C  
ATOM   2123  C   ILE A 134      -2.991  14.728   5.315  1.00  0.00           C  
ATOM   2124  O   ILE A 134      -2.738  14.127   6.358  1.00  0.00           O  
ATOM   2125  CB  ILE A 134      -4.238  13.215   3.767  1.00  0.00           C  
ATOM   2126  CG1 ILE A 134      -5.301  12.227   4.242  1.00  0.00           C  
ATOM   2127  CG2 ILE A 134      -2.853  12.600   3.877  1.00  0.00           C  
ATOM   2128  CD1 ILE A 134      -6.445  12.045   3.271  1.00  0.00           C  
ATOM   2129  H   ILE A 134      -4.637  15.512   2.755  1.00  0.00           H  
ATOM   2130  HA  ILE A 134      -5.114  14.437   5.302  1.00  0.00           H  
ATOM   2131  HB  ILE A 134      -4.417  13.455   2.729  1.00  0.00           H  
ATOM   2132 HG12 ILE A 134      -4.842  11.263   4.389  1.00  0.00           H  
ATOM   2133 HG13 ILE A 134      -5.711  12.576   5.178  1.00  0.00           H  
ATOM   2134 HG21 ILE A 134      -2.129  13.259   3.419  1.00  0.00           H  
ATOM   2135 HG22 ILE A 134      -2.844  11.648   3.372  1.00  0.00           H  
ATOM   2136 HG23 ILE A 134      -2.603  12.457   4.918  1.00  0.00           H  
ATOM   2137 HD11 ILE A 134      -6.814  11.032   3.338  1.00  0.00           H  
ATOM   2138 HD12 ILE A 134      -6.098  12.236   2.268  1.00  0.00           H  
ATOM   2139 HD13 ILE A 134      -7.240  12.734   3.517  1.00  0.00           H  
ATOM   2140  N   ARG A 135      -2.159  15.601   4.752  1.00  0.00           N  
ATOM   2141  CA  ARG A 135      -0.861  15.924   5.329  1.00  0.00           C  
ATOM   2142  C   ARG A 135      -0.530  17.394   5.087  1.00  0.00           C  
ATOM   2143  O   ARG A 135       0.015  17.755   4.044  1.00  0.00           O  
ATOM   2144  CB  ARG A 135       0.227  15.033   4.726  1.00  0.00           C  
ATOM   2145  CG  ARG A 135       1.639  15.496   5.046  1.00  0.00           C  
ATOM   2146  CD  ARG A 135       2.409  15.856   3.785  1.00  0.00           C  
ATOM   2147  NE  ARG A 135       3.261  14.760   3.331  1.00  0.00           N  
ATOM   2148  CZ  ARG A 135       4.465  14.507   3.833  1.00  0.00           C  
ATOM   2149  NH1 ARG A 135       4.951  15.263   4.808  1.00  0.00           N  
ATOM   2150  NH2 ARG A 135       5.184  13.497   3.364  1.00  0.00           N  
ATOM   2151  H   ARG A 135      -2.432  16.048   3.923  1.00  0.00           H  
ATOM   2152  HA  ARG A 135      -0.915  15.747   6.393  1.00  0.00           H  
ATOM   2153  HB2 ARG A 135       0.106  14.029   5.105  1.00  0.00           H  
ATOM   2154  HB3 ARG A 135       0.111  15.020   3.652  1.00  0.00           H  
ATOM   2155  HG2 ARG A 135       1.587  16.367   5.684  1.00  0.00           H  
ATOM   2156  HG3 ARG A 135       2.160  14.701   5.560  1.00  0.00           H  
ATOM   2157  HD2 ARG A 135       1.703  16.096   3.004  1.00  0.00           H  
ATOM   2158  HD3 ARG A 135       3.026  16.719   3.989  1.00  0.00           H  
ATOM   2159  HE  ARG A 135       2.919  14.187   2.614  1.00  0.00           H  
ATOM   2160 HH11 ARG A 135       4.413  16.024   5.167  1.00  0.00           H  
ATOM   2161 HH12 ARG A 135       5.858  15.071   5.186  1.00  0.00           H  
ATOM   2162 HH21 ARG A 135       4.820  12.924   2.630  1.00  0.00           H  
ATOM   2163 HH22 ARG A 135       6.090  13.308   3.743  1.00  0.00           H  
ATOM   2164  N   PRO A 136      -0.868  18.262   6.051  1.00  0.00           N  
ATOM   2165  CA  PRO A 136      -0.623  19.701   5.951  1.00  0.00           C  
ATOM   2166  C   PRO A 136       0.824  20.067   6.255  1.00  0.00           C  
ATOM   2167  O   PRO A 136       1.096  21.010   6.997  1.00  0.00           O  
ATOM   2168  CB  PRO A 136      -1.556  20.282   7.010  1.00  0.00           C  
ATOM   2169  CG  PRO A 136      -1.657  19.215   8.045  1.00  0.00           C  
ATOM   2170  CD  PRO A 136      -1.529  17.902   7.316  1.00  0.00           C  
ATOM   2171  HA  PRO A 136      -0.895  20.084   4.978  1.00  0.00           H  
ATOM   2172  HB2 PRO A 136      -1.127  21.188   7.414  1.00  0.00           H  
ATOM   2173  HB3 PRO A 136      -2.518  20.496   6.569  1.00  0.00           H  
ATOM   2174  HG2 PRO A 136      -0.857  19.324   8.762  1.00  0.00           H  
ATOM   2175  HG3 PRO A 136      -2.615  19.276   8.540  1.00  0.00           H  
ATOM   2176  HD2 PRO A 136      -0.921  17.213   7.884  1.00  0.00           H  
ATOM   2177  HD3 PRO A 136      -2.502  17.478   7.130  1.00  0.00           H  
ATOM   2178  N   ASN A 137       1.747  19.312   5.674  1.00  0.00           N  
ATOM   2179  CA  ASN A 137       3.171  19.553   5.881  1.00  0.00           C  
ATOM   2180  C   ASN A 137       3.677  20.652   4.952  1.00  0.00           C  
ATOM   2181  O   ASN A 137       4.704  21.278   5.217  1.00  0.00           O  
ATOM   2182  CB  ASN A 137       3.968  18.269   5.651  1.00  0.00           C  
ATOM   2183  CG  ASN A 137       5.333  18.311   6.310  1.00  0.00           C  
ATOM   2184  OD1 ASN A 137       6.023  19.330   6.272  1.00  0.00           O  
ATOM   2185  ND2 ASN A 137       5.731  17.199   6.920  1.00  0.00           N  
ATOM   2186  H   ASN A 137       1.464  18.574   5.094  1.00  0.00           H  
ATOM   2187  HA  ASN A 137       3.307  19.873   6.903  1.00  0.00           H  
ATOM   2188  HB2 ASN A 137       3.418  17.433   6.058  1.00  0.00           H  
ATOM   2189  HB3 ASN A 137       4.105  18.122   4.590  1.00  0.00           H  
ATOM   2190 HD21 ASN A 137       5.129  16.426   6.910  1.00  0.00           H  
ATOM   2191 HD22 ASN A 137       6.609  17.199   7.354  1.00  0.00           H  
ATOM   2192  N   LYS A 138       2.952  20.881   3.863  1.00  0.00           N  
ATOM   2193  CA  LYS A 138       3.329  21.906   2.895  1.00  0.00           C  
ATOM   2194  C   LYS A 138       4.845  21.977   2.743  1.00  0.00           C  
ATOM   2195  O   LYS A 138       5.479  22.934   3.187  1.00  0.00           O  
ATOM   2196  CB  LYS A 138       2.783  23.270   3.326  1.00  0.00           C  
ATOM   2197  CG  LYS A 138       1.295  23.260   3.634  1.00  0.00           C  
ATOM   2198  CD  LYS A 138       0.470  23.613   2.407  1.00  0.00           C  
ATOM   2199  CE  LYS A 138      -0.139  25.001   2.527  1.00  0.00           C  
ATOM   2200  NZ  LYS A 138       0.417  25.941   1.516  1.00  0.00           N  
ATOM   2201  H   LYS A 138       2.143  20.351   3.706  1.00  0.00           H  
ATOM   2202  HA  LYS A 138       2.895  21.638   1.943  1.00  0.00           H  
ATOM   2203  HB2 LYS A 138       3.311  23.592   4.211  1.00  0.00           H  
ATOM   2204  HB3 LYS A 138       2.961  23.981   2.533  1.00  0.00           H  
ATOM   2205  HG2 LYS A 138       1.014  22.274   3.973  1.00  0.00           H  
ATOM   2206  HG3 LYS A 138       1.095  23.982   4.412  1.00  0.00           H  
ATOM   2207  HD2 LYS A 138       1.108  23.586   1.536  1.00  0.00           H  
ATOM   2208  HD3 LYS A 138      -0.324  22.889   2.298  1.00  0.00           H  
ATOM   2209  HE2 LYS A 138      -1.208  24.924   2.384  1.00  0.00           H  
ATOM   2210  HE3 LYS A 138       0.064  25.385   3.516  1.00  0.00           H  
ATOM   2211  HZ1 LYS A 138       1.316  25.574   1.143  1.00  0.00           H  
ATOM   2212  HZ2 LYS A 138       0.588  26.871   1.949  1.00  0.00           H  
ATOM   2213  HZ3 LYS A 138      -0.252  26.057   0.728  1.00  0.00           H  
ATOM   2214  N   LYS A 139       5.419  20.959   2.111  1.00  0.00           N  
ATOM   2215  CA  LYS A 139       6.861  20.908   1.900  1.00  0.00           C  
ATOM   2216  C   LYS A 139       7.379  22.233   1.350  1.00  0.00           C  
ATOM   2217  O   LYS A 139       6.751  22.770   0.414  1.00  0.00           O  
ATOM   2218  CB  LYS A 139       7.217  19.770   0.939  1.00  0.00           C  
ATOM   2219  CG  LYS A 139       7.849  18.570   1.624  1.00  0.00           C  
ATOM   2220  CD  LYS A 139       9.322  18.438   1.272  1.00  0.00           C  
ATOM   2221  CE  LYS A 139      10.078  19.728   1.547  1.00  0.00           C  
ATOM   2222  NZ  LYS A 139      10.498  20.405   0.290  1.00  0.00           N  
ATOM   2223  OXT LYS A 139       8.408  22.723   1.861  1.00  0.00           O  
ATOM   2224  H   LYS A 139       4.861  20.226   1.779  1.00  0.00           H  
ATOM   2225  HA  LYS A 139       7.329  20.719   2.854  1.00  0.00           H  
ATOM   2226  HB2 LYS A 139       6.317  19.441   0.441  1.00  0.00           H  
ATOM   2227  HB3 LYS A 139       7.912  20.143   0.201  1.00  0.00           H  
ATOM   2228  HG2 LYS A 139       7.755  18.687   2.694  1.00  0.00           H  
ATOM   2229  HG3 LYS A 139       7.331  17.675   1.311  1.00  0.00           H  
ATOM   2230  HD2 LYS A 139       9.755  17.645   1.864  1.00  0.00           H  
ATOM   2231  HD3 LYS A 139       9.410  18.196   0.223  1.00  0.00           H  
ATOM   2232  HE2 LYS A 139       9.438  20.393   2.107  1.00  0.00           H  
ATOM   2233  HE3 LYS A 139      10.957  19.497   2.132  1.00  0.00           H  
ATOM   2234  HZ1 LYS A 139      11.261  21.084   0.487  1.00  0.00           H  
ATOM   2235  HZ2 LYS A 139       9.694  20.916  -0.127  1.00  0.00           H  
ATOM   2236  HZ3 LYS A 139      10.841  19.703  -0.397  1.00  0.00           H  
TER    2237      LYS A 139                                                      
END
MOLECULE T0476.pdb
ATOM     20  N   ALA     2       2.300  -1.329  -3.219  1.00  1.00          
ATOM     21  HN  ALA     2       2.119  -0.600  -3.850  1.00  1.00          
ATOM     22  CA  ALA     2       2.425  -2.698  -3.762  1.00  1.00          
ATOM     23  HA  ALA     2       2.430  -3.385  -2.927  1.00  1.00          
ATOM     24  CB  ALA     2       1.232  -3.027  -4.654  1.00  1.00          
ATOM     25  HB1 ALA     2       0.366  -3.248  -4.041  1.00  1.00          
ATOM     26  HB2 ALA     2       1.466  -3.884  -5.266  1.00  1.00          
ATOM     27  HB3 ALA     2       1.012  -2.181  -5.288  1.00  1.00          
ATOM     28  C   ALA     2       3.737  -2.860  -4.536  1.00  1.00          
ATOM     29  O   ALA     2       4.162  -1.925  -5.237  1.00  1.00          
ATOM     30  N   LYS     3       4.348  -4.064  -4.398  1.00  1.00          
ATOM     31  HN  LYS     3       3.910  -4.743  -3.851  1.00  1.00          
ATOM     32  CA  LYS     3       5.630  -4.420  -5.036  1.00  1.00          
ATOM     33  HA  LYS     3       5.927  -3.593  -5.664  1.00  1.00          
ATOM     34  CB  LYS     3       6.703  -4.642  -3.963  1.00  1.00          
ATOM     35  HB1 LYS     3       7.090  -5.646  -4.059  1.00  1.00          
ATOM     36  HB2 LYS     3       6.247  -4.534  -2.991  1.00  1.00          
ATOM     37  CG  LYS     3       7.866  -3.669  -4.054  1.00  1.00          
ATOM     38  HG1 LYS     3       7.478  -2.663  -4.070  1.00  1.00          
ATOM     39  HG2 LYS     3       8.415  -3.861  -4.963  1.00  1.00          
ATOM     40  CD  LYS     3       8.812  -3.819  -2.864  1.00  1.00          
ATOM     41  HD1 LYS     3       9.239  -4.812  -2.884  1.00  1.00          
ATOM     42  HD2 LYS     3       8.242  -3.692  -1.954  1.00  1.00          
ATOM     43  CE  LYS     3       9.950  -2.788  -2.891  1.00  1.00          
ATOM     44  HE1 LYS     3      10.366  -2.698  -1.895  1.00  1.00          
ATOM     45  HE2 LYS     3       9.543  -1.834  -3.190  1.00  1.00          
ATOM     46  NZ  LYS     3      11.048  -3.157  -3.838  1.00  1.00          
ATOM     47  HZ1 LYS     3      10.919  -4.134  -4.171  1.00  1.00          
ATOM     48  HZ2 LYS     3      11.970  -3.084  -3.363  1.00  1.00          
ATOM     49  HZ3 LYS     3      11.041  -2.517  -4.658  1.00  1.00          
ATOM     50  C   LYS     3       5.489  -5.670  -5.903  1.00  1.00          
ATOM     51  O   LYS     3       4.818  -6.637  -5.496  1.00  1.00          
ATOM     52  N   CYS     4       6.139  -5.626  -7.110  1.00  1.00          
ATOM     53  HN  CYS     4       6.610  -4.798  -7.337  1.00  1.00          
ATOM     54  CA  CYS     4       6.151  -6.739  -8.115  1.00  1.00          
ATOM     55  HA  CYS     4       5.134  -7.092  -8.210  1.00  1.00          
ATOM     56  HB1 CYS     4       7.690  -6.064  -9.456  1.00  1.00          
ATOM     57  HB2 CYS     4       6.138  -5.314  -9.733  1.00  1.00          
ATOM     58  C   CYS     4       7.052  -7.958  -7.664  1.00  1.00          
ATOM     59  O   CYS     4       8.242  -7.720  -7.359  1.00  1.00          
ATOM     60  CB  CYS     4       6.628  -6.236  -9.499  1.00  1.00          
ATOM     61  SG  CYS     4       6.315  -7.399 -10.876  1.00  1.00          
ATOM     62  ZN  CYS     4       7.178  -6.267 -12.689  1.00  1.00          
ATOM     63  N   PRO     5       6.504  -9.279  -7.551  1.00  1.00          
ATOM     64  CA  PRO     5       7.350 -10.468  -7.168  1.00  1.00          
ATOM     65  HA  PRO     5       7.965 -10.222  -6.313  1.00  1.00          
ATOM     66  CB  PRO     5       6.300 -11.538  -6.750  1.00  1.00          
ATOM     67  HB1 PRO     5       6.133 -11.486  -5.679  1.00  1.00          
ATOM     68  HB2 PRO     5       6.670 -12.522  -7.004  1.00  1.00          
ATOM     69  CG  PRO     5       5.042 -11.205  -7.513  1.00  1.00          
ATOM     70  HG1 PRO     5       4.168 -11.526  -6.955  1.00  1.00          
ATOM     71  HG2 PRO     5       5.061 -11.696  -8.482  1.00  1.00          
ATOM     72  CD  PRO     5       5.048  -9.697  -7.681  1.00  1.00          
ATOM     73  HD1 PRO     5       4.459  -9.227  -6.903  1.00  1.00          
ATOM     74  HD2 PRO     5       4.661  -9.417  -8.652  1.00  1.00          
ATOM     75  C   PRO     5       8.310 -10.999  -8.302  1.00  1.00          
ATOM     76  O   PRO     5       9.092 -11.941  -8.056  1.00  1.00          
ATOM     77  N   ILE     6       8.243 -10.351  -9.506  1.00  1.00          
ATOM     78  HN  ILE     6       7.662  -9.568  -9.601  1.00  1.00          
ATOM     79  CA  ILE     6       9.041 -10.718 -10.711  1.00  1.00          
ATOM     80  HA  ILE     6       9.414 -11.721 -10.556  1.00  1.00          
ATOM     81  CB  ILE     6       8.166 -10.709 -12.075  1.00  1.00          
ATOM     82  HB  ILE     6       8.010  -9.665 -12.339  1.00  1.00          
ATOM     83  CG1 ILE     6       6.780 -11.397 -11.928  1.00  1.00          
ATOM     84 HG11 ILE     6       6.684 -11.787 -10.923  1.00  1.00          
ATOM     85 HG12 ILE     6       6.717 -12.214 -12.630  1.00  1.00          
ATOM     86  CG2 ILE     6       8.885 -11.402 -13.266  1.00  1.00          
ATOM     87 HG21 ILE     6       8.195 -11.508 -14.089  1.00  1.00          
ATOM     88 HG22 ILE     6       9.234 -12.376 -12.960  1.00  1.00          
ATOM     89 HG23 ILE     6       9.727 -10.799 -13.576  1.00  1.00          
ATOM     90  CD1 ILE     6       5.603 -10.477 -12.185  1.00  1.00          
ATOM     91 HD11 ILE     6       5.734  -9.980 -13.135  1.00  1.00          
ATOM     92 HD12 ILE     6       5.545  -9.738 -11.398  1.00  1.00          
ATOM     93 HD13 ILE     6       4.690 -11.054 -12.203  1.00  1.00          
ATOM     94  C   ILE     6      10.267  -9.754 -10.836  1.00  1.00          
ATOM     95  O   ILE     6      11.410 -10.247 -10.885  1.00  1.00          
ATOM     96  N   CYS     7       9.997  -8.409 -10.880  1.00  1.00          
ATOM     97  HN  CYS     7       9.068  -8.099 -10.752  1.00  1.00          
ATOM     98  CA  CYS     7      11.045  -7.379 -11.052  1.00  1.00          
ATOM     99  HA  CYS     7      11.937  -7.900 -11.371  1.00  1.00          
ATOM    100  HB1 CYS     7      10.463  -6.971 -13.068  1.00  1.00          
ATOM    101  HB2 CYS     7      11.466  -5.723 -12.357  1.00  1.00          
ATOM    102  C   CYS     7      11.386  -6.643  -9.742  1.00  1.00          
ATOM    103  O   CYS     7      12.579  -6.407  -9.475  1.00  1.00          
ATOM    104  CB  CYS     7      10.644  -6.397 -12.176  1.00  1.00          
ATOM    105  SG  CYS     7       9.154  -5.367 -11.862  1.00  1.00          
ATOM    106  N   GLY     8      10.326  -6.300  -8.947  1.00  1.00          
ATOM    107  HN  GLY     8       9.429  -6.536  -9.259  1.00  1.00          
ATOM    108  CA  GLY     8      10.463  -5.587  -7.658  1.00  1.00          
ATOM    109  HA1 GLY     8      11.409  -5.858  -7.215  1.00  1.00          
ATOM    110  HA2 GLY     8       9.671  -5.911  -7.002  1.00  1.00          
ATOM    111  C   GLY     8      10.398  -4.062  -7.773  1.00  1.00          
ATOM    112  O   GLY     8      11.113  -3.371  -7.024  1.00  1.00          
ATOM    113  N   SER     9       9.543  -3.559  -8.714  1.00  1.00          
ATOM    114  HN  SER     9       9.028  -4.201  -9.268  1.00  1.00          
ATOM    115  CA  SER     9       9.353  -2.108  -8.955  1.00  1.00          
ATOM    116  HA  SER     9      10.245  -1.616  -8.608  1.00  1.00          
ATOM    117  CB  SER     9       9.190  -1.838 -10.450  1.00  1.00          
ATOM    118  HB1 SER     9       8.515  -1.007 -10.590  1.00  1.00          
ATOM    119  HB2 SER     9       8.784  -2.717 -10.929  1.00  1.00          
ATOM    120  OG  SER     9      10.434  -1.523 -11.050  1.00  1.00          
ATOM    121  HG  SER     9      11.071  -1.296 -10.369  1.00  1.00          
ATOM    122  C   SER     9       8.118  -1.543  -8.168  1.00  1.00          
ATOM    123  O   SER     9       7.155  -2.318  -7.998  1.00  1.00          
ATOM    124  N   PRO    10       8.068  -0.182  -7.677  1.00  1.00          
ATOM    125  CA  PRO    10       6.894   0.366  -6.898  1.00  1.00          
ATOM    126  HA  PRO    10       6.675  -0.274  -6.053  1.00  1.00          
ATOM    127  CB  PRO    10       7.377   1.745  -6.389  1.00  1.00          
ATOM    128  HB1 PRO    10       7.094   1.885  -5.351  1.00  1.00          
ATOM    129  HB2 PRO    10       6.922   2.521  -6.992  1.00  1.00          
ATOM    130  CG  PRO    10       8.860   1.719  -6.557  1.00  1.00          
ATOM    131  HG1 PRO    10       9.323   1.230  -5.709  1.00  1.00          
ATOM    132  HG2 PRO    10       9.246   2.726  -6.667  1.00  1.00          
ATOM    133  CD  PRO    10       9.089   0.921  -7.810  1.00  1.00          
ATOM    134  HD1 PRO    10      10.092   0.531  -7.830  1.00  1.00          
ATOM    135  HD2 PRO    10       8.896   1.526  -8.686  1.00  1.00          
ATOM    136  C   PRO    10       5.597   0.545  -7.715  1.00  1.00          
ATOM    137  O   PRO    10       5.643   0.957  -8.890  1.00  1.00          
ATOM    138  N   LEU    11       4.473   0.213  -7.043  1.00  1.00          
ATOM    139  HN  LEU    11       4.572  -0.110  -6.123  1.00  1.00          
ATOM    140  CA  LEU    11       3.105   0.301  -7.592  1.00  1.00          
ATOM    141  HA  LEU    11       3.157   0.823  -8.536  1.00  1.00          
ATOM    142  CB  LEU    11       2.505  -1.103  -7.823  1.00  1.00          
ATOM    143  HB1 LEU    11       1.435  -0.986  -7.961  1.00  1.00          
ATOM    144  HB2 LEU    11       2.671  -1.689  -6.932  1.00  1.00          
ATOM    145  CG  LEU    11       3.057  -1.892  -9.022  1.00  1.00          
ATOM    146  HG  LEU    11       4.007  -1.471  -9.320  1.00  1.00          
ATOM    147  CD1 LEU    11       3.294  -3.342  -8.631  1.00  1.00          
ATOM    148 HD11 LEU    11       2.387  -3.756  -8.216  1.00  1.00          
ATOM    149 HD12 LEU    11       4.082  -3.393  -7.896  1.00  1.00          
ATOM    150 HD13 LEU    11       3.580  -3.909  -9.505  1.00  1.00          
ATOM    151  CD2 LEU    11       2.100  -1.814 -10.209  1.00  1.00          
ATOM    152 HD21 LEU    11       1.811  -0.785 -10.370  1.00  1.00          
ATOM    153 HD22 LEU    11       1.222  -2.406 -10.003  1.00  1.00          
ATOM    154 HD23 LEU    11       2.591  -2.193 -11.094  1.00  1.00          
ATOM    155  C   LEU    11       2.200   1.084  -6.640  1.00  1.00          
ATOM    156  O   LEU    11       2.354   0.979  -5.405  1.00  1.00          
ATOM    157  N   LYS    12       1.248   1.846  -7.239  1.00  1.00          
ATOM    158  HN  LYS    12       1.205   1.847  -8.218  1.00  1.00          
ATOM    159  CA  LYS    12       0.268   2.672  -6.500  1.00  1.00          
ATOM    160  HA  LYS    12       0.655   2.832  -5.504  1.00  1.00          
ATOM    161  CB  LYS    12       0.071   4.039  -7.188  1.00  1.00          
ATOM    162  HB1 LYS    12      -0.862   4.462  -6.847  1.00  1.00          
ATOM    163  HB2 LYS    12       0.009   3.879  -8.253  1.00  1.00          
ATOM    164  CG  LYS    12       1.177   5.060  -6.932  1.00  1.00          
ATOM    165  HG1 LYS    12       2.125   4.636  -7.231  1.00  1.00          
ATOM    166  HG2 LYS    12       1.202   5.296  -5.878  1.00  1.00          
ATOM    167  CD  LYS    12       0.933   6.337  -7.719  1.00  1.00          
ATOM    168  HD1 LYS    12       0.002   6.777  -7.392  1.00  1.00          
ATOM    169  HD2 LYS    12       0.868   6.093  -8.769  1.00  1.00          
ATOM    170  CE  LYS    12       2.054   7.343  -7.518  1.00  1.00          
ATOM    171  HE1 LYS    12       2.989   6.884  -7.799  1.00  1.00          
ATOM    172  HE2 LYS    12       2.087   7.622  -6.476  1.00  1.00          
ATOM    173  NZ  LYS    12       1.848   8.568  -8.341  1.00  1.00          
ATOM    174  HZ1 LYS    12       0.845   8.844  -8.326  1.00  1.00          
ATOM    175  HZ2 LYS    12       2.133   8.389  -9.324  1.00  1.00          
ATOM    176  HZ3 LYS    12       2.418   9.351  -7.963  1.00  1.00          
ATOM    177  C   LYS    12      -1.081   1.956  -6.396  1.00  1.00          
ATOM    178  O   LYS    12      -1.559   1.377  -7.390  1.00  1.00          
ATOM    179  N   TRP    13      -1.672   1.996  -5.160  1.00  1.00          
ATOM    180  HN  TRP    13      -1.181   2.442  -4.438  1.00  1.00          
ATOM    181  CA  TRP    13      -3.017   1.404  -4.824  1.00  1.00          
ATOM    182  HA  TRP    13      -3.015   0.400  -5.221  1.00  1.00          
ATOM    183  CB  TRP    13      -3.201   1.310  -3.305  1.00  1.00          
ATOM    184  HB1 TRP    13      -4.256   1.293  -3.074  1.00  1.00          
ATOM    185  HB2 TRP    13      -2.746   2.171  -2.837  1.00  1.00          
ATOM    186  CG  TRP    13      -2.569   0.062  -2.712  1.00  1.00          
ATOM    187  CD1 TRP    13      -1.316  -0.023  -2.173  1.00  1.00          
ATOM    188  HD1 TRP    13      -0.631   0.809  -2.108  1.00  1.00          
ATOM    189  CD2 TRP    13      -3.138  -1.276  -2.597  1.00  1.00          
ATOM    190  NE1 TRP    13      -1.061  -1.302  -1.745  1.00  1.00          
ATOM    191  HE1 TRP    13      -0.226  -1.604  -1.327  1.00  1.00          
ATOM    192  CE2 TRP    13      -2.156  -2.089  -1.988  1.00  1.00          
ATOM    193  CE3 TRP    13      -4.371  -1.874  -2.944  1.00  1.00          
ATOM    194  HE3 TRP    13      -5.157  -1.299  -3.410  1.00  1.00          
ATOM    195  CZ2 TRP    13      -2.361  -3.447  -1.724  1.00  1.00          
ATOM    196  HZ2 TRP    13      -1.601  -4.066  -1.262  1.00  1.00          
ATOM    197  CZ3 TRP    13      -4.566  -3.216  -2.675  1.00  1.00          
ATOM    198  HZ3 TRP    13      -5.504  -3.685  -2.935  1.00  1.00          
ATOM    199  CH2 TRP    13      -3.565  -3.989  -2.072  1.00  1.00          
ATOM    200  HH2 TRP    13      -3.762  -5.034  -1.877  1.00  1.00          
ATOM    201  C   TRP    13      -4.207   2.161  -5.486  1.00  1.00          
ATOM    202  O   TRP    13      -5.280   1.571  -5.690  1.00  1.00          
ATOM    203  N   GLU    14      -3.968   3.482  -5.801  1.00  1.00          
ATOM    204  HN  GLU    14      -3.096   3.848  -5.548  1.00  1.00          
ATOM    205  CA  GLU    14      -4.922   4.411  -6.497  1.00  1.00          
ATOM    206  HA  GLU    14      -5.875   4.335  -5.994  1.00  1.00          
ATOM    207  CB  GLU    14      -4.427   5.865  -6.398  1.00  1.00          
ATOM    208  HB1 GLU    14      -4.913   6.447  -7.167  1.00  1.00          
ATOM    209  HB2 GLU    14      -3.361   5.878  -6.573  1.00  1.00          
ATOM    210  CG  GLU    14      -4.688   6.541  -5.055  1.00  1.00          
ATOM    211  HG1 GLU    14      -4.184   5.982  -4.281  1.00  1.00          
ATOM    212  HG2 GLU    14      -5.752   6.539  -4.866  1.00  1.00          
ATOM    213  CD  GLU    14      -4.193   7.975  -5.018  1.00  1.00          
ATOM    214  OE1 GLU    14      -4.994   8.888  -5.307  1.00  1.00          
ATOM    215  OE2 GLU    14      -3.003   8.183  -4.699  1.00  1.00          
ATOM    216  C   GLU    14      -5.129   4.058  -8.000  1.00  1.00          
ATOM    217  O   GLU    14      -6.217   4.314  -8.541  1.00  1.00          
ATOM    218  N   GLU    15      -4.055   3.473  -8.649  1.00  1.00          
ATOM    219  HN  GLU    15      -3.230   3.319  -8.128  1.00  1.00          
ATOM    220  CA  GLU    15      -4.048   3.031 -10.086  1.00  1.00          
ATOM    221  HA  GLU    15      -4.509   3.819 -10.662  1.00  1.00          
ATOM    222  CB  GLU    15      -2.604   2.844 -10.589  1.00  1.00          
ATOM    223  HB1 GLU    15      -2.622   2.205 -11.460  1.00  1.00          
ATOM    224  HB2 GLU    15      -2.029   2.360  -9.813  1.00  1.00          
ATOM    225  CG  GLU    15      -1.895   4.143 -10.965  1.00  1.00          
ATOM    226  HG1 GLU    15      -1.851   4.779 -10.092  1.00  1.00          
ATOM    227  HG2 GLU    15      -2.462   4.638 -11.739  1.00  1.00          
ATOM    228  CD  GLU    15      -0.482   3.918 -11.472  1.00  1.00          
ATOM    229  OE1 GLU    15      -0.304   3.799 -12.703  1.00  1.00          
ATOM    230  OE2 GLU    15       0.448   3.863 -10.638  1.00  1.00          
ATOM    231  C   GLU    15      -4.856   1.726 -10.327  1.00  1.00          
ATOM    232  O   GLU    15      -5.487   1.583 -11.386  1.00  1.00          
ATOM    233  N   LEU    16      -4.815   0.793  -9.313  1.00  1.00          
ATOM    234  HN  LEU    16      -4.272   1.013  -8.527  1.00  1.00          
ATOM    235  CA  LEU    16      -5.531  -0.525  -9.302  1.00  1.00          
ATOM    236  HA  LEU    16      -5.286  -1.030 -10.224  1.00  1.00          
ATOM    237  CB  LEU    16      -5.014  -1.371  -8.126  1.00  1.00          
ATOM    238  HB1 LEU    16      -5.761  -2.115  -7.894  1.00  1.00          
ATOM    239  HB2 LEU    16      -4.901  -0.721  -7.271  1.00  1.00          
ATOM    240  CG  LEU    16      -3.682  -2.089  -8.365  1.00  1.00          
ATOM    241  HG  LEU    16      -3.230  -1.706  -9.269  1.00  1.00          
ATOM    242  CD1 LEU    16      -2.723  -1.829  -7.213  1.00  1.00          
ATOM    243 HD11 LEU    16      -2.434  -0.789  -7.217  1.00  1.00          
ATOM    244 HD12 LEU    16      -1.845  -2.446  -7.329  1.00  1.00          
ATOM    245 HD13 LEU    16      -3.209  -2.064  -6.275  1.00  1.00          
ATOM    246  CD2 LEU    16      -3.906  -3.581  -8.543  1.00  1.00          
ATOM    247 HD21 LEU    16      -4.651  -3.744  -9.307  1.00  1.00          
ATOM    248 HD22 LEU    16      -4.247  -4.007  -7.610  1.00  1.00          
ATOM    249 HD23 LEU    16      -2.980  -4.051  -8.836  1.00  1.00          
ATOM    250  C   LEU    16      -7.082  -0.392  -9.222  1.00  1.00          
ATOM    251  O   LEU    16      -7.797  -1.152  -9.894  1.00  1.00          
ATOM    252  N   ILE    17      -7.564   0.589  -8.376  1.00  1.00          
ATOM    253  HN  ILE    17      -6.905   1.114  -7.878  1.00  1.00          
ATOM    254  CA  ILE    17      -9.021   0.920  -8.154  1.00  1.00          
ATOM    255  HA  ILE    17      -9.547  -0.023  -8.086  1.00  1.00          
ATOM    256  CB  ILE    17      -9.283   1.731  -6.766  1.00  1.00          
ATOM    257  HB  ILE    17      -9.012   2.758  -6.972  1.00  1.00          
ATOM    258  CG1 ILE    17      -8.423   1.252  -5.486  1.00  1.00          
ATOM    259 HG11 ILE    17      -8.829   1.751  -4.615  1.00  1.00          
ATOM    260 HG12 ILE    17      -7.411   1.598  -5.620  1.00  1.00          
ATOM    261  CG2 ILE    17     -10.798   1.759  -6.372  1.00  1.00          
ATOM    262 HG21 ILE    17     -11.113   0.765  -6.095  1.00  1.00          
ATOM    263 HG22 ILE    17     -11.380   2.095  -7.220  1.00  1.00          
ATOM    264 HG23 ILE    17     -10.945   2.433  -5.542  1.00  1.00          
ATOM    265  CD1 ILE    17      -8.315  -0.266  -5.133  1.00  1.00          
ATOM    266 HD11 ILE    17      -8.367  -0.391  -4.061  1.00  1.00          
ATOM    267 HD12 ILE    17      -7.375  -0.655  -5.494  1.00  1.00          
ATOM    268 HD13 ILE    17      -9.128  -0.801  -5.599  1.00  1.00          
ATOM    269  C   ILE    17      -9.605   1.706  -9.392  1.00  1.00          
ATOM    270  O   ILE    17     -10.742   1.429  -9.806  1.00  1.00          
ATOM    271  N   GLU    18      -8.789   2.673  -9.944  1.00  1.00          
ATOM    272  HN  GLU    18      -7.909   2.811  -9.536  1.00  1.00          
ATOM    273  CA  GLU    18      -9.137   3.532 -11.124  1.00  1.00          
ATOM    274  HA  GLU    18     -10.094   3.986 -10.916  1.00  1.00          
ATOM    275  CB  GLU    18      -8.092   4.649 -11.264  1.00  1.00          
ATOM    276  HB1 GLU    18      -7.478   4.443 -12.126  1.00  1.00          
ATOM    277  HB2 GLU    18      -7.468   4.653 -10.384  1.00  1.00          
ATOM    278  CG  GLU    18      -8.691   6.039 -11.426  1.00  1.00          
ATOM    279  HG1 GLU    18      -9.296   6.259 -10.558  1.00  1.00          
ATOM    280  HG2 GLU    18      -9.313   6.049 -12.308  1.00  1.00          
ATOM    281  CD  GLU    18      -7.632   7.113 -11.566  1.00  1.00          
ATOM    282  OE1 GLU    18      -7.356   7.526 -12.712  1.00  1.00          
ATOM    283  OE2 GLU    18      -7.077   7.544 -10.532  1.00  1.00          
ATOM    284  C   GLU    18      -9.252   2.738 -12.462  1.00  1.00          
ATOM    285  O   GLU    18     -10.109   3.070 -13.297  1.00  1.00          
ATOM    286  N   GLU    19      -8.371   1.695 -12.623  1.00  1.00          
ATOM    287  HN  GLU    19      -7.726   1.518 -11.907  1.00  1.00          
ATOM    288  CA  GLU    19      -8.326   0.776 -13.795  1.00  1.00          
ATOM    289  HA  GLU    19      -8.483   1.363 -14.687  1.00  1.00          
ATOM    290  CB  GLU    19      -6.951   0.112 -13.876  1.00  1.00          
ATOM    291  HB1 GLU    19      -7.044  -0.762 -14.480  1.00  1.00          
ATOM    292  HB2 GLU    19      -6.669  -0.194 -12.881  1.00  1.00          
ATOM    293  CG  GLU    19      -5.837   0.985 -14.458  1.00  1.00          
ATOM    294  HG1 GLU    19      -5.715   1.857 -13.831  1.00  1.00          
ATOM    295  HG2 GLU    19      -6.124   1.295 -15.452  1.00  1.00          
ATOM    296  CD  GLU    19      -4.511   0.255 -14.541  1.00  1.00          
ATOM    297  OE1 GLU    19      -3.762   0.268 -13.542  1.00  1.00          
ATOM    298  OE2 GLU    19      -4.221  -0.332 -15.606  1.00  1.00          
ATOM    299  C   GLU    19      -9.394  -0.352 -13.738  1.00  1.00          
ATOM    300  O   GLU    19      -9.772  -0.895 -14.796  1.00  1.00          
ATOM    301  N   MET    20      -9.869  -0.662 -12.495  1.00  1.00          
ATOM    302  HN  MET    20      -9.596  -0.098 -11.738  1.00  1.00          
ATOM    303  CA  MET    20     -10.851  -1.732 -12.224  1.00  1.00          
ATOM    304  HA  MET    20     -10.869  -2.350 -13.108  1.00  1.00          
ATOM    305  CB  MET    20     -10.362  -2.600 -11.039  1.00  1.00          
ATOM    306  HB1 MET    20     -11.204  -3.141 -10.644  1.00  1.00          
ATOM    307  HB2 MET    20      -9.976  -1.948 -10.271  1.00  1.00          
ATOM    308  CG  MET    20      -9.271  -3.611 -11.399  1.00  1.00          
ATOM    309  HG1 MET    20      -8.427  -3.078 -11.810  1.00  1.00          
ATOM    310  HG2 MET    20      -9.661  -4.290 -12.143  1.00  1.00          
ATOM    311  SD  MET    20      -8.712  -4.575  -9.980  1.00  1.00          
ATOM    312  CE  MET    20      -9.788  -6.004 -10.086  1.00  1.00          
ATOM    313  HE1 MET    20      -9.826  -6.498  -9.128  1.00  1.00          
ATOM    314  HE2 MET    20      -9.405  -6.688 -10.829  1.00  1.00          
ATOM    315  HE3 MET    20     -10.781  -5.687 -10.369  1.00  1.00          
ATOM    316  C   MET    20     -12.301  -1.185 -11.975  1.00  1.00          
ATOM    317  O   MET    20     -13.238  -1.979 -11.741  1.00  1.00          
ATOM    318  N   LEU    21     -12.478   0.177 -12.072  1.00  1.00          
ATOM    319  HN  LEU    21     -11.693   0.723 -12.292  1.00  1.00          
ATOM    320  CA  LEU    21     -13.782   0.887 -11.867  1.00  1.00          
ATOM    321  HA  LEU    21     -14.289   0.374 -11.064  1.00  1.00          
ATOM    322  CB  LEU    21     -13.467   2.336 -11.407  1.00  1.00          
ATOM    323  HB1 LEU    21     -13.584   2.989 -12.261  1.00  1.00          
ATOM    324  HB2 LEU    21     -12.435   2.372 -11.093  1.00  1.00          
ATOM    325  CG  LEU    21     -14.335   2.892 -10.262  1.00  1.00          
ATOM    326  HG  LEU    21     -15.254   2.327 -10.201  1.00  1.00          
ATOM    327  CD1 LEU    21     -13.620   2.772  -8.918  1.00  1.00          
ATOM    328 HD11 LEU    21     -12.795   3.469  -8.885  1.00  1.00          
ATOM    329 HD12 LEU    21     -13.246   1.766  -8.798  1.00  1.00          
ATOM    330 HD13 LEU    21     -14.313   2.996  -8.120  1.00  1.00          
ATOM    331  CD2 LEU    21     -14.700   4.342 -10.537  1.00  1.00          
ATOM    332 HD21 LEU    21     -15.350   4.393 -11.397  1.00  1.00          
ATOM    333 HD22 LEU    21     -13.801   4.908 -10.730  1.00  1.00          
ATOM    334 HD23 LEU    21     -15.207   4.754  -9.677  1.00  1.00          
ATOM    335  C   LEU    21     -14.727   0.863 -13.135  1.00  1.00          
ATOM    336  O   LEU    21     -15.767   1.563 -13.176  1.00  1.00          
ATOM    337  N   ILE    22     -14.367  -0.011 -14.121  1.00  1.00          
ATOM    338  HN  ILE    22     -13.573  -0.559 -13.970  1.00  1.00          
ATOM    339  CA  ILE    22     -15.104  -0.215 -15.411  1.00  1.00          
ATOM    340  HA  ILE    22     -15.610   0.719 -15.613  1.00  1.00          
ATOM    341  CB  ILE    22     -14.139  -0.497 -16.648  1.00  1.00          
ATOM    342  HB  ILE    22     -14.761  -0.873 -17.439  1.00  1.00          
ATOM    343  CG1 ILE    22     -12.992  -1.534 -16.396  1.00  1.00          
ATOM    344 HG11 ILE    22     -13.044  -1.877 -15.372  1.00  1.00          
ATOM    345 HG12 ILE    22     -12.038  -1.053 -16.559  1.00  1.00          
ATOM    346  CG2 ILE    22     -13.533   0.810 -17.141  1.00  1.00          
ATOM    347 HG21 ILE    22     -12.992   1.277 -16.331  1.00  1.00          
ATOM    348 HG22 ILE    22     -14.317   1.471 -17.478  1.00  1.00          
ATOM    349 HG23 ILE    22     -12.856   0.608 -17.957  1.00  1.00          
ATOM    350  CD1 ILE    22     -13.061  -2.746 -17.301  1.00  1.00          
ATOM    351 HD11 ILE    22     -12.869  -2.447 -18.322  1.00  1.00          
ATOM    352 HD12 ILE    22     -14.045  -3.187 -17.235  1.00  1.00          
ATOM    353 HD13 ILE    22     -12.320  -3.470 -16.994  1.00  1.00          
ATOM    354  C   ILE    22     -16.215  -1.322 -15.323  1.00  1.00          
ATOM    355  O   ILE    22     -17.017  -1.469 -16.268  1.00  1.00          
ATOM    356  N   ILE    23     -16.246  -2.055 -14.171  1.00  1.00          
ATOM    357  HN  ILE    23     -15.585  -1.830 -13.484  1.00  1.00          
ATOM    358  CA  ILE    23     -17.214  -3.161 -13.879  1.00  1.00          
ATOM    359  HA  ILE    23     -17.643  -3.471 -14.825  1.00  1.00          
ATOM    360  CB  ILE    23     -16.551  -4.456 -13.175  1.00  1.00          
ATOM    361  HB  ILE    23     -16.448  -4.234 -12.120  1.00  1.00          
ATOM    362  CG1 ILE    23     -15.152  -4.836 -13.744  1.00  1.00          
ATOM    363 HG11 ILE    23     -14.885  -4.128 -14.517  1.00  1.00          
ATOM    364 HG12 ILE    23     -15.205  -5.823 -14.174  1.00  1.00          
ATOM    365  CG2 ILE    23     -17.446  -5.719 -13.302  1.00  1.00          
ATOM    366 HG21 ILE    23     -17.422  -6.076 -14.321  1.00  1.00          
ATOM    367 HG22 ILE    23     -18.461  -5.469 -13.032  1.00  1.00          
ATOM    368 HG23 ILE    23     -17.079  -6.490 -12.640  1.00  1.00          
ATOM    369  CD1 ILE    23     -14.038  -4.841 -12.711  1.00  1.00          
ATOM    370 HD11 ILE    23     -14.212  -5.629 -11.994  1.00  1.00          
ATOM    371 HD12 ILE    23     -14.012  -3.887 -12.201  1.00  1.00          
ATOM    372 HD13 ILE    23     -13.090  -5.007 -13.204  1.00  1.00          
ATOM    373  C   ILE    23     -18.357  -2.596 -12.990  1.00  1.00          
ATOM    374  O   ILE    23     -18.095  -1.832 -12.042  1.00  1.00          
ATOM    375  N   GLU    24     -19.615  -3.011 -13.335  1.00  1.00          
ATOM    376  HN  GLU    24     -19.700  -3.609 -14.107  1.00  1.00          
ATOM    377  CA  GLU    24     -20.878  -2.622 -12.613  1.00  1.00          
ATOM    378  HA  GLU    24     -20.795  -1.568 -12.408  1.00  1.00          
ATOM    379  CB  GLU    24     -22.112  -2.847 -13.495  1.00  1.00          
ATOM    380  HB1 GLU    24     -22.982  -2.924 -12.859  1.00  1.00          
ATOM    381  HB2 GLU    24     -21.989  -3.775 -14.032  1.00  1.00          
ATOM    382  CG  GLU    24     -22.360  -1.739 -14.511  1.00  1.00          
ATOM    383  HG1 GLU    24     -21.510  -1.680 -15.176  1.00  1.00          
ATOM    384  HG2 GLU    24     -22.468  -0.802 -13.983  1.00  1.00          
ATOM    385  CD  GLU    24     -23.610  -1.974 -15.337  1.00  1.00          
ATOM    386  OE1 GLU    24     -23.513  -2.654 -16.379  1.00  1.00          
ATOM    387  OE2 GLU    24     -24.686  -1.479 -14.939  1.00  1.00          
ATOM    388  C   GLU    24     -21.069  -3.339 -11.252  1.00  1.00          
ATOM    389  O   GLU    24     -21.730  -2.783 -10.360  1.00  1.00          
ATOM    390  N   ASN    25     -20.478  -4.575 -11.123  1.00  1.00          
ATOM    391  HN  ASN    25     -20.016  -4.937 -11.907  1.00  1.00          
ATOM    392  CA  ASN    25     -20.485  -5.413  -9.877  1.00  1.00          
ATOM    393  HA  ASN    25     -21.503  -5.455  -9.519  1.00  1.00          
ATOM    394  CB  ASN    25     -20.018  -6.835 -10.202  1.00  1.00          
ATOM    395  HB1 ASN    25     -19.629  -7.294  -9.305  1.00  1.00          
ATOM    396  HB2 ASN    25     -19.237  -6.792 -10.946  1.00  1.00          
ATOM    397  CG  ASN    25     -21.139  -7.703 -10.735  1.00  1.00          
ATOM    398  OD1 ASN    25     -21.366  -7.775 -11.943  1.00  1.00          
ATOM    399  ND2 ASN    25     -21.847  -8.370  -9.832  1.00  1.00          
ATOM    400 HD21 ASN    25     -21.609  -8.265  -8.887  1.00  1.00          
ATOM    401 HD22 ASN    25     -22.580  -8.940 -10.146  1.00  1.00          
ATOM    402  C   ASN    25     -19.587  -4.826  -8.745  1.00  1.00          
ATOM    403  O   ASN    25     -19.800  -5.128  -7.561  1.00  1.00          
ATOM    404  N   PHE    26     -18.579  -3.974  -9.164  1.00  1.00          
ATOM    405  HN  PHE    26     -18.479  -3.886 -10.131  1.00  1.00          
ATOM    406  CA  PHE    26     -17.585  -3.264  -8.287  1.00  1.00          
ATOM    407  HA  PHE    26     -17.010  -4.031  -7.794  1.00  1.00          
ATOM    408  CB  PHE    26     -16.615  -2.431  -9.145  1.00  1.00          
ATOM    409  HB1 PHE    26     -16.916  -1.401  -9.104  1.00  1.00          
ATOM    410  HB2 PHE    26     -16.679  -2.767 -10.166  1.00  1.00          
ATOM    411  CG  PHE    26     -15.159  -2.522  -8.700  1.00  1.00          
ATOM    412  CD1 PHE    26     -14.630  -1.587  -7.813  1.00  1.00          
ATOM    413  HD1 PHE    26     -15.259  -0.786  -7.451  1.00  1.00          
ATOM    414  CD2 PHE    26     -14.325  -3.548  -9.152  1.00  1.00          
ATOM    415  HD2 PHE    26     -14.718  -4.283  -9.840  1.00  1.00          
ATOM    416  CE1 PHE    26     -13.316  -1.672  -7.392  1.00  1.00          
ATOM    417  HE1 PHE    26     -12.922  -0.940  -6.702  1.00  1.00          
ATOM    418  CE2 PHE    26     -13.012  -3.634  -8.730  1.00  1.00          
ATOM    419  HE2 PHE    26     -12.384  -4.438  -9.082  1.00  1.00          
ATOM    420  CZ  PHE    26     -12.508  -2.696  -7.849  1.00  1.00          
ATOM    421  HZ  PHE    26     -11.480  -2.761  -7.520  1.00  1.00          
ATOM    422  C   PHE    26     -18.221  -2.379  -7.186  1.00  1.00          
ATOM    423  O   PHE    26     -17.657  -2.266  -6.085  1.00  1.00          
ATOM    424  N   GLU    27     -19.401  -1.766  -7.527  1.00  1.00          
ATOM    425  HN  GLU    27     -19.712  -1.879  -8.450  1.00  1.00          
ATOM    426  CA  GLU    27     -20.248  -0.926  -6.599  1.00  1.00          
ATOM    427  HA  GLU    27     -19.621  -0.140  -6.211  1.00  1.00          
ATOM    428  CB  GLU    27     -21.426  -0.290  -7.359  1.00  1.00          
ATOM    429  HB1 GLU    27     -22.166   0.029  -6.640  1.00  1.00          
ATOM    430  HB2 GLU    27     -21.866  -1.036  -8.002  1.00  1.00          
ATOM    431  CG  GLU    27     -21.055   0.915  -8.220  1.00  1.00          
ATOM    432  HG1 GLU    27     -20.294   0.616  -8.927  1.00  1.00          
ATOM    433  HG2 GLU    27     -20.662   1.691  -7.579  1.00  1.00          
ATOM    434  CD  GLU    27     -22.238   1.474  -8.985  1.00  1.00          
ATOM    435  OE1 GLU    27     -22.504   0.988 -10.104  1.00  1.00          
ATOM    436  OE2 GLU    27     -22.900   2.396  -8.465  1.00  1.00          
ATOM    437  C   GLU    27     -20.810  -1.753  -5.397  1.00  1.00          
ATOM    438  O   GLU    27     -21.054  -1.194  -4.316  1.00  1.00          
ATOM    439  N   GLU    28     -20.997  -3.093  -5.650  1.00  1.00          
ATOM    440  HN  GLU    28     -20.774  -3.414  -6.558  1.00  1.00          
ATOM    441  CA  GLU    28     -21.472  -4.102  -4.659  1.00  1.00          
ATOM    442  HA  GLU    28     -22.153  -3.600  -3.987  1.00  1.00          
ATOM    443  CB  GLU    28     -22.229  -5.230  -5.379  1.00  1.00          
ATOM    444  HB1 GLU    28     -22.140  -6.133  -4.791  1.00  1.00          
ATOM    445  HB2 GLU    28     -21.762  -5.395  -6.343  1.00  1.00          
ATOM    446  CG  GLU    28     -23.724  -4.942  -5.591  1.00  1.00          
ATOM    447  HG1 GLU    28     -24.047  -5.388  -6.524  1.00  1.00          
ATOM    448  HG2 GLU    28     -23.864  -3.873  -5.642  1.00  1.00          
ATOM    449  CD  GLU    28     -24.602  -5.487  -4.473  1.00  1.00          
ATOM    450  OE1 GLU    28     -24.852  -6.711  -4.457  1.00  1.00          
ATOM    451  OE2 GLU    28     -25.035  -4.688  -3.616  1.00  1.00          
ATOM    452  C   GLU    28     -20.313  -4.697  -3.816  1.00  1.00          
ATOM    453  O   GLU    28     -20.512  -4.990  -2.625  1.00  1.00          
ATOM    454  N   ILE    29     -19.100  -4.858  -4.465  1.00  1.00          
ATOM    455  HN  ILE    29     -19.056  -4.577  -5.402  1.00  1.00          
ATOM    456  CA  ILE    29     -17.826  -5.391  -3.839  1.00  1.00          
ATOM    457  HA  ILE    29     -18.119  -6.251  -3.247  1.00  1.00          
ATOM    458  CB  ILE    29     -16.741  -5.905  -4.933  1.00  1.00          
ATOM    459  HB  ILE    29     -16.436  -5.047  -5.515  1.00  1.00          
ATOM    460  CG1 ILE    29     -17.347  -6.982  -5.891  1.00  1.00          
ATOM    461 HG11 ILE    29     -18.421  -6.990  -5.770  1.00  1.00          
ATOM    462 HG12 ILE    29     -16.959  -7.948  -5.606  1.00  1.00          
ATOM    463  CG2 ILE    29     -15.462  -6.544  -4.282  1.00  1.00          
ATOM    464 HG21 ILE    29     -14.576  -6.253  -4.832  1.00  1.00          
ATOM    465 HG22 ILE    29     -15.553  -7.620  -4.293  1.00  1.00          
ATOM    466 HG23 ILE    29     -15.380  -6.204  -3.259  1.00  1.00          
ATOM    467  CD1 ILE    29     -17.050  -6.801  -7.383  1.00  1.00          
ATOM    468 HD11 ILE    29     -16.128  -6.252  -7.511  1.00  1.00          
ATOM    469 HD12 ILE    29     -17.859  -6.262  -7.849  1.00  1.00          
ATOM    470 HD13 ILE    29     -16.953  -7.772  -7.848  1.00  1.00          
ATOM    471  C   ILE    29     -17.214  -4.327  -2.842  1.00  1.00          
ATOM    472  O   ILE    29     -16.719  -4.716  -1.772  1.00  1.00          
ATOM    473  N   VAL    30     -17.268  -3.006  -3.232  1.00  1.00          
ATOM    474  HN  VAL    30     -17.681  -2.807  -4.098  1.00  1.00          
ATOM    475  CA  VAL    30     -16.734  -1.828  -2.423  1.00  1.00          
ATOM    476  HA  VAL    30     -15.699  -2.078  -2.227  1.00  1.00          
ATOM    477  CB  VAL    30     -16.721  -0.442  -3.218  1.00  1.00          
ATOM    478  HB  VAL    30     -16.463   0.331  -2.501  1.00  1.00          
ATOM    479  CG1 VAL    30     -15.615  -0.442  -4.273  1.00  1.00          
ATOM    480 HG11 VAL    30     -15.795  -1.240  -4.979  1.00  1.00          
ATOM    481 HG12 VAL    30     -14.659  -0.591  -3.794  1.00  1.00          
ATOM    482 HG13 VAL    30     -15.614   0.505  -4.794  1.00  1.00          
ATOM    483  CG2 VAL    30     -18.069  -0.038  -3.897  1.00  1.00          
ATOM    484 HG21 VAL    30     -18.619  -0.929  -4.165  1.00  1.00          
ATOM    485 HG22 VAL    30     -17.860   0.536  -4.785  1.00  1.00          
ATOM    486 HG23 VAL    30     -18.665   0.560  -3.215  1.00  1.00          
ATOM    487  C   VAL    30     -17.415  -1.633  -1.014  1.00  1.00          
ATOM    488  O   VAL    30     -16.859  -0.932  -0.153  1.00  1.00          
ATOM    489  N   LYS    31     -18.636  -2.226  -0.863  1.00  1.00          
ATOM    490  HN  LYS    31     -19.028  -2.656  -1.650  1.00  1.00          
ATOM    491  CA  LYS    31     -19.444  -2.219   0.392  1.00  1.00          
ATOM    492  HA  LYS    31     -19.268  -1.274   0.885  1.00  1.00          
ATOM    493  CB  LYS    31     -20.940  -2.313   0.040  1.00  1.00          
ATOM    494  HB1 LYS    31     -21.470  -2.734   0.881  1.00  1.00          
ATOM    495  HB2 LYS    31     -21.052  -2.971  -0.812  1.00  1.00          
ATOM    496  CG  LYS    31     -21.584  -0.977  -0.315  1.00  1.00          
ATOM    497  HG1 LYS    31     -21.051  -0.540  -1.148  1.00  1.00          
ATOM    498  HG2 LYS    31     -21.524  -0.319   0.538  1.00  1.00          
ATOM    499  CD  LYS    31     -23.045  -1.151  -0.700  1.00  1.00          
ATOM    500  HD1 LYS    31     -23.576  -1.590   0.132  1.00  1.00          
ATOM    501  HD2 LYS    31     -23.107  -1.807  -1.556  1.00  1.00          
ATOM    502  CE  LYS    31     -23.687   0.179  -1.051  1.00  1.00          
ATOM    503  HE1 LYS    31     -23.146   0.619  -1.876  1.00  1.00          
ATOM    504  HE2 LYS    31     -23.625   0.831  -0.192  1.00  1.00          
ATOM    505  NZ  LYS    31     -25.115   0.020  -1.436  1.00  1.00          
ATOM    506  HZ1 LYS    31     -25.704   0.696  -0.909  1.00  1.00          
ATOM    507  HZ2 LYS    31     -25.437  -0.944  -1.220  1.00  1.00          
ATOM    508  HZ3 LYS    31     -25.232   0.194  -2.454  1.00  1.00          
ATOM    509  C   LYS    31     -19.066  -3.363   1.384  1.00  1.00          
ATOM    510  O   LYS    31     -19.371  -3.241   2.589  1.00  1.00          
ATOM    511  N   ASP    32     -18.396  -4.444   0.865  1.00  1.00          
ATOM    512  HN  ASP    32     -18.170  -4.432  -0.083  1.00  1.00          
ATOM    513  CA  ASP    32     -17.971  -5.618   1.658  1.00  1.00          
ATOM    514  HA  ASP    32     -18.111  -5.363   2.699  1.00  1.00          
ATOM    515  CB  ASP    32     -18.850  -6.851   1.334  1.00  1.00          
ATOM    516  HB1 ASP    32     -18.332  -7.743   1.651  1.00  1.00          
ATOM    517  HB2 ASP    32     -19.015  -6.897   0.269  1.00  1.00          
ATOM    518  CG  ASP    32     -20.200  -6.811   2.024  1.00  1.00          
ATOM    519  OD1 ASP    32     -20.245  -7.024   3.253  1.00  1.00          
ATOM    520  OD2 ASP    32     -21.210  -6.566   1.333  1.00  1.00          
ATOM    521  C   ASP    32     -16.477  -5.937   1.447  1.00  1.00          
ATOM    522  O   ASP    32     -16.038  -6.313   0.338  1.00  1.00          
ATOM    523  N   ARG    33     -15.696  -5.696   2.541  1.00  1.00          
ATOM    524  HN  ARG    33     -16.114  -5.203   3.272  1.00  1.00          
ATOM    525  CA  ARG    33     -14.203  -5.966   2.657  1.00  1.00          
ATOM    526  HA  ARG    33     -13.747  -5.429   1.839  1.00  1.00          
ATOM    527  CB  ARG    33     -13.602  -5.390   3.997  1.00  1.00          
ATOM    528  HB1 ARG    33     -13.539  -4.316   3.898  1.00  1.00          
ATOM    529  HB2 ARG    33     -12.598  -5.775   4.096  1.00  1.00          
ATOM    530  CG  ARG    33     -14.364  -5.685   5.329  1.00  1.00          
ATOM    531  HG1 ARG    33     -13.681  -6.081   6.070  1.00  1.00          
ATOM    532  HG2 ARG    33     -15.143  -6.407   5.134  1.00  1.00          
ATOM    533  CD  ARG    33     -14.998  -4.414   5.870  1.00  1.00          
ATOM    534  HD1 ARG    33     -15.615  -3.981   5.098  1.00  1.00          
ATOM    535  HD2 ARG    33     -14.211  -3.721   6.131  1.00  1.00          
ATOM    536  NE  ARG    33     -15.833  -4.661   7.070  1.00  1.00          
ATOM    537  HE  ARG    33     -15.828  -5.580   7.413  1.00  1.00          
ATOM    538  CZ  ARG    33     -16.606  -3.750   7.740  1.00  1.00          
ATOM    539  NH1 ARG    33     -16.704  -2.449   7.390  1.00  1.00          
ATOM    540 HH11 ARG    33     -16.194  -2.102   6.603  1.00  1.00          
ATOM    541 HH12 ARG    33     -17.284  -1.831   7.920  1.00  1.00          
ATOM    542  NH2 ARG    33     -17.294  -4.164   8.792  1.00  1.00          
ATOM    543 HH21 ARG    33     -17.242  -5.121   9.077  1.00  1.00          
ATOM    544 HH22 ARG    33     -17.866  -3.520   9.300  1.00  1.00          
ATOM    545  C   ARG    33     -13.775  -7.453   2.472  1.00  1.00          
ATOM    546  O   ARG    33     -12.675  -7.709   1.954  1.00  1.00          
ATOM    547  N   GLU    34     -14.667  -8.401   2.897  1.00  1.00          
ATOM    548  HN  GLU    34     -15.495  -8.092   3.316  1.00  1.00          
ATOM    549  CA  GLU    34     -14.475  -9.886   2.784  1.00  1.00          
ATOM    550  HA  GLU    34     -13.504 -10.117   3.193  1.00  1.00          
ATOM    551  CB  GLU    34     -15.540 -10.592   3.625  1.00  1.00          
ATOM    552  HB1 GLU    34     -16.262 -11.039   2.963  1.00  1.00          
ATOM    553  HB2 GLU    34     -16.036  -9.854   4.236  1.00  1.00          
ATOM    554  CG  GLU    34     -14.990 -11.675   4.546  1.00  1.00          
ATOM    555  HG1 GLU    34     -14.239 -11.239   5.188  1.00  1.00          
ATOM    556  HG2 GLU    34     -14.541 -12.449   3.942  1.00  1.00          
ATOM    557  CD  GLU    34     -16.066 -12.303   5.413  1.00  1.00          
ATOM    558  OE1 GLU    34     -16.255 -11.841   6.559  1.00  1.00          
ATOM    559  OE2 GLU    34     -16.719 -13.259   4.945  1.00  1.00          
ATOM    560  C   GLU    34     -14.514 -10.404   1.313  1.00  1.00          
ATOM    561  O   GLU    34     -13.832 -11.393   0.994  1.00  1.00          
ATOM    562  N   ARG    35     -15.331  -9.710   0.452  1.00  1.00          
ATOM    563  HN  ARG    35     -15.848  -8.961   0.818  1.00  1.00          
ATOM    564  CA  ARG    35     -15.478  -9.994  -1.009  1.00  1.00          
ATOM    565  HA  ARG    35     -15.418 -11.066  -1.131  1.00  1.00          
ATOM    566  CB  ARG    35     -16.844  -9.520  -1.541  1.00  1.00          
ATOM    567  HB1 ARG    35     -16.792  -9.468  -2.618  1.00  1.00          
ATOM    568  HB2 ARG    35     -17.038  -8.531  -1.156  1.00  1.00          
ATOM    569  CG  ARG    35     -18.031 -10.418  -1.163  1.00  1.00          
ATOM    570  HG1 ARG    35     -18.078 -10.489  -0.085  1.00  1.00          
ATOM    571  HG2 ARG    35     -17.868 -11.400  -1.579  1.00  1.00          
ATOM    572  CD  ARG    35     -19.369  -9.878  -1.689  1.00  1.00          
ATOM    573  HD1 ARG    35     -19.407  -8.815  -1.500  1.00  1.00          
ATOM    574  HD2 ARG    35     -20.176 -10.363  -1.158  1.00  1.00          
ATOM    575  NE  ARG    35     -19.561 -10.110  -3.154  1.00  1.00          
ATOM    576  HE  ARG    35     -18.986 -10.795  -3.555  1.00  1.00          
ATOM    577  CZ  ARG    35     -20.439  -9.469  -3.988  1.00  1.00          
ATOM    578  NH1 ARG    35     -21.296  -8.515  -3.576  1.00  1.00          
ATOM    579 HH11 ARG    35     -21.313  -8.240  -2.614  1.00  1.00          
ATOM    580 HH12 ARG    35     -21.916  -8.082  -4.230  1.00  1.00          
ATOM    581  NH2 ARG    35     -20.453  -9.807  -5.271  1.00  1.00          
ATOM    582 HH21 ARG    35     -19.831 -10.513  -5.608  1.00  1.00          
ATOM    583 HH22 ARG    35     -21.085  -9.354  -5.900  1.00  1.00          
ATOM    584  C   ARG    35     -14.353  -9.351  -1.865  1.00  1.00          
ATOM    585  O   ARG    35     -13.937  -9.953  -2.870  1.00  1.00          
ATOM    586  N   PHE    36     -13.872  -8.120  -1.439  1.00  1.00          
ATOM    587  HN  PHE    36     -14.272  -7.734  -0.632  1.00  1.00          
ATOM    588  CA  PHE    36     -12.788  -7.335  -2.119  1.00  1.00          
ATOM    589  HA  PHE    36     -13.032  -7.321  -3.175  1.00  1.00          
ATOM    590  CB  PHE    36     -12.768  -5.860  -1.604  1.00  1.00          
ATOM    591  HB1 PHE    36     -12.121  -5.808  -0.739  1.00  1.00          
ATOM    592  HB2 PHE    36     -13.766  -5.584  -1.306  1.00  1.00          
ATOM    593  CG  PHE    36     -12.276  -4.810  -2.611  1.00  1.00          
ATOM    594  CD1 PHE    36     -13.182  -4.017  -3.308  1.00  1.00          
ATOM    595  HD1 PHE    36     -14.239  -4.142  -3.138  1.00  1.00          
ATOM    596  CD2 PHE    36     -10.912  -4.619  -2.851  1.00  1.00          
ATOM    597  HD2 PHE    36     -10.191  -5.227  -2.322  1.00  1.00          
ATOM    598  CE1 PHE    36     -12.745  -3.066  -4.213  1.00  1.00          
ATOM    599  HE1 PHE    36     -13.462  -2.457  -4.749  1.00  1.00          
ATOM    600  CE2 PHE    36     -10.477  -3.670  -3.756  1.00  1.00          
ATOM    601  HE2 PHE    36      -9.420  -3.537  -3.933  1.00  1.00          
ATOM    602  CZ  PHE    36     -11.394  -2.894  -4.437  1.00  1.00          
ATOM    603  HZ  PHE    36     -11.055  -2.152  -5.144  1.00  1.00          
ATOM    604  C   PHE    36     -11.381  -7.994  -1.962  1.00  1.00          
ATOM    605  O   PHE    36     -10.656  -8.096  -2.957  1.00  1.00          
ATOM    606  N   LEU    37     -11.045  -8.465  -0.705  1.00  1.00          
ATOM    607  HN  LEU    37     -11.712  -8.391   0.008  1.00  1.00          
ATOM    608  CA  LEU    37      -9.748  -9.152  -0.357  1.00  1.00          
ATOM    609  HA  LEU    37      -8.952  -8.547  -0.765  1.00  1.00          
ATOM    610  CB  LEU    37      -9.569  -9.231   1.169  1.00  1.00          
ATOM    611  HB1 LEU    37      -8.934 -10.076   1.387  1.00  1.00          
ATOM    612  HB2 LEU    37     -10.538  -9.411   1.609  1.00  1.00          
ATOM    613  CG  LEU    37      -8.960  -7.990   1.838  1.00  1.00          
ATOM    614  HG  LEU    37      -9.017  -7.151   1.159  1.00  1.00          
ATOM    615  CD1 LEU    37      -9.735  -7.625   3.094  1.00  1.00          
ATOM    616 HD11 LEU    37      -9.264  -6.779   3.570  1.00  1.00          
ATOM    617 HD12 LEU    37      -9.736  -8.465   3.774  1.00  1.00          
ATOM    618 HD13 LEU    37     -10.751  -7.371   2.833  1.00  1.00          
ATOM    619  CD2 LEU    37      -7.493  -8.232   2.176  1.00  1.00          
ATOM    620 HD21 LEU    37      -7.421  -8.983   2.948  1.00  1.00          
ATOM    621 HD22 LEU    37      -7.048  -7.312   2.526  1.00  1.00          
ATOM    622 HD23 LEU    37      -6.971  -8.571   1.294  1.00  1.00          
ATOM    623  C   LEU    37      -9.625 -10.575  -0.974  1.00  1.00          
ATOM    624  O   LEU    37      -8.521 -10.988  -1.362  1.00  1.00          
ATOM    625  N   ALA    38     -10.798 -11.295  -1.035  1.00  1.00          
ATOM    626  HN  ALA    38     -11.594 -10.860  -0.661  1.00  1.00          
ATOM    627  CA  ALA    38     -10.947 -12.662  -1.630  1.00  1.00          
ATOM    628  HA  ALA    38     -10.133 -13.267  -1.257  1.00  1.00          
ATOM    629  CB  ALA    38     -12.249 -13.289  -1.162  1.00  1.00          
ATOM    630  HB1 ALA    38     -13.082 -12.721  -1.550  1.00  1.00          
ATOM    631  HB2 ALA    38     -12.280 -13.285  -0.084  1.00  1.00          
ATOM    632  HB3 ALA    38     -12.308 -14.305  -1.522  1.00  1.00          
ATOM    633  C   ALA    38     -10.885 -12.664  -3.184  1.00  1.00          
ATOM    634  O   ALA    38     -10.445 -13.661  -3.780  1.00  1.00          
ATOM    635  N   GLN    39     -11.334 -11.518  -3.802  1.00  1.00          
ATOM    636  HN  GLN    39     -11.679 -10.803  -3.227  1.00  1.00          
ATOM    637  CA  GLN    39     -11.334 -11.274  -5.273  1.00  1.00          
ATOM    638  HA  GLN    39     -11.622 -12.199  -5.749  1.00  1.00          
ATOM    639  CB  GLN    39     -12.363 -10.202  -5.635  1.00  1.00          
ATOM    640  HB1 GLN    39     -11.849  -9.350  -6.053  1.00  1.00          
ATOM    641  HB2 GLN    39     -12.880  -9.896  -4.736  1.00  1.00          
ATOM    642  CG  GLN    39     -13.400 -10.677  -6.644  1.00  1.00          
ATOM    643  HG1 GLN    39     -13.877 -11.568  -6.261  1.00  1.00          
ATOM    644  HG2 GLN    39     -12.897 -10.910  -7.571  1.00  1.00          
ATOM    645  CD  GLN    39     -14.469  -9.637  -6.925  1.00  1.00          
ATOM    646  OE1 GLN    39     -15.366  -9.414  -6.110  1.00  1.00          
ATOM    647  NE2 GLN    39     -14.376  -8.993  -8.084  1.00  1.00          
ATOM    648 HE21 GLN    39     -13.634  -9.222  -8.682  1.00  1.00          
ATOM    649 HE22 GLN    39     -15.051  -8.313  -8.293  1.00  1.00          
ATOM    650  C   GLN    39      -9.942 -10.870  -5.820  1.00  1.00          
ATOM    651  O   GLN    39      -9.610 -11.243  -6.947  1.00  1.00          
ATOM    652  N   VAL    40      -9.143 -10.104  -4.991  1.00  1.00          
ATOM    653  HN  VAL    40      -9.520  -9.838  -4.126  1.00  1.00          
ATOM    654  CA  VAL    40      -7.728  -9.640  -5.307  1.00  1.00          
ATOM    655  HA  VAL    40      -7.751  -9.261  -6.322  1.00  1.00          
ATOM    656  CB  VAL    40      -7.265  -8.421  -4.339  1.00  1.00          
ATOM    657  HB  VAL    40      -7.399  -8.743  -3.318  1.00  1.00          
ATOM    658  CG1 VAL    40      -5.795  -7.949  -4.503  1.00  1.00          
ATOM    659 HG11 VAL    40      -5.139  -8.808  -4.525  1.00  1.00          
ATOM    660 HG12 VAL    40      -5.525  -7.310  -3.674  1.00  1.00          
ATOM    661 HG13 VAL    40      -5.699  -7.397  -5.425  1.00  1.00          
ATOM    662  CG2 VAL    40      -8.144  -7.179  -4.545  1.00  1.00          
ATOM    663 HG21 VAL    40      -7.837  -6.403  -3.859  1.00  1.00          
ATOM    664 HG22 VAL    40      -9.177  -7.436  -4.359  1.00  1.00          
ATOM    665 HG23 VAL    40      -8.038  -6.826  -5.560  1.00  1.00          
ATOM    666  C   VAL    40      -6.740 -10.881  -5.289  1.00  1.00          
ATOM    667  O   VAL    40      -5.847 -10.964  -6.145  1.00  1.00          
ATOM    668  N   GLU    41      -6.948 -11.810  -4.291  1.00  1.00          
ATOM    669  HN  GLU    41      -7.679 -11.648  -3.658  1.00  1.00          
ATOM    670  CA  GLU    41      -6.156 -13.082  -4.095  1.00  1.00          
ATOM    671  HA  GLU    41      -5.108 -12.825  -4.137  1.00  1.00          
ATOM    672  CB  GLU    41      -6.452 -13.705  -2.709  1.00  1.00          
ATOM    673  HB1 GLU    41      -6.060 -14.711  -2.697  1.00  1.00          
ATOM    674  HB2 GLU    41      -7.523 -13.753  -2.579  1.00  1.00          
ATOM    675  CG  GLU    41      -5.870 -12.953  -1.514  1.00  1.00          
ATOM    676  HG1 GLU    41      -6.341 -11.983  -1.456  1.00  1.00          
ATOM    677  HG2 GLU    41      -4.807 -12.831  -1.658  1.00  1.00          
ATOM    678  CD  GLU    41      -6.102 -13.679  -0.203  1.00  1.00          
ATOM    679  OE1 GLU    41      -5.208 -14.441   0.221  1.00  1.00          
ATOM    680  OE2 GLU    41      -7.181 -13.490   0.398  1.00  1.00          
ATOM    681  C   GLU    41      -6.445 -14.160  -5.187  1.00  1.00          
ATOM    682  O   GLU    41      -5.529 -14.908  -5.569  1.00  1.00          
ATOM    683  N   GLU    42      -7.733 -14.199  -5.664  1.00  1.00          
ATOM    684  HN  GLU    42      -8.370 -13.556  -5.289  1.00  1.00          
ATOM    685  CA  GLU    42      -8.241 -15.144  -6.708  1.00  1.00          
ATOM    686  HA  GLU    42      -7.747 -16.091  -6.555  1.00  1.00          
ATOM    687  CB  GLU    42      -9.754 -15.348  -6.525  1.00  1.00          
ATOM    688  HB1 GLU    42     -10.174 -15.660  -7.470  1.00  1.00          
ATOM    689  HB2 GLU    42     -10.193 -14.399  -6.246  1.00  1.00          
ATOM    690  CG  GLU    42     -10.128 -16.400  -5.465  1.00  1.00          
ATOM    691  HG1 GLU    42     -11.041 -16.098  -4.963  1.00  1.00          
ATOM    692  HG2 GLU    42      -9.329 -16.457  -4.741  1.00  1.00          
ATOM    693  CD  GLU    42     -10.343 -17.788  -6.050  1.00  1.00          
ATOM    694  OE1 GLU    42     -11.404 -18.017  -6.671  1.00  1.00          
ATOM    695  OE2 GLU    42      -9.448 -18.645  -5.886  1.00  1.00          
ATOM    696  C   GLU    42      -7.966 -14.678  -8.166  1.00  1.00          
ATOM    697  O   GLU    42      -7.851 -15.532  -9.064  1.00  1.00          
ATOM    698  N   PHE    43      -7.863 -13.330  -8.362  1.00  1.00          
ATOM    699  HN  PHE    43      -7.937 -12.758  -7.569  1.00  1.00          
ATOM    700  CA  PHE    43      -7.604 -12.686  -9.673  1.00  1.00          
ATOM    701  HA  PHE    43      -7.862 -13.398 -10.445  1.00  1.00          
ATOM    702  CB  PHE    43      -8.487 -11.424  -9.835  1.00  1.00          
ATOM    703  HB1 PHE    43      -7.853 -10.550  -9.784  1.00  1.00          
ATOM    704  HB2 PHE    43      -9.194 -11.389  -9.022  1.00  1.00          
ATOM    705  CG  PHE    43      -9.276 -11.347 -11.127  1.00  1.00          
ATOM    706  CD1 PHE    43     -10.564 -11.868 -11.206  1.00  1.00          
ATOM    707  HD1 PHE    43     -10.997 -12.342 -10.337  1.00  1.00          
ATOM    708  CD2 PHE    43      -8.737 -10.740 -12.258  1.00  1.00          
ATOM    709  HD2 PHE    43      -7.740 -10.329 -12.214  1.00  1.00          
ATOM    710  CE1 PHE    43     -11.290 -11.788 -12.379  1.00  1.00          
ATOM    711  HE1 PHE    43     -12.288 -12.196 -12.425  1.00  1.00          
ATOM    712  CE2 PHE    43      -9.462 -10.660 -13.432  1.00  1.00          
ATOM    713  HE2 PHE    43      -9.031 -10.188 -14.303  1.00  1.00          
ATOM    714  CZ  PHE    43     -10.739 -11.184 -13.492  1.00  1.00          
ATOM    715  HZ  PHE    43     -11.306 -11.121 -14.409  1.00  1.00          
ATOM    716  C   PHE    43      -6.116 -12.316  -9.823  1.00  1.00          
ATOM    717  O   PHE    43      -5.436 -12.046  -8.809  1.00  1.00          
ATOM    718  N   VAL    44      -5.646 -12.290 -11.099  1.00  1.00          
ATOM    719  HN  VAL    44      -6.276 -12.457 -11.830  1.00  1.00          
ATOM    720  CA  VAL    44      -4.253 -11.972 -11.451  1.00  1.00          
ATOM    721  HA  VAL    44      -3.713 -11.937 -10.512  1.00  1.00          
ATOM    722  CB  VAL    44      -3.627 -13.177 -12.308  1.00  1.00          
ATOM    723  HB  VAL    44      -4.051 -14.083 -11.887  1.00  1.00          
ATOM    724  CG1 VAL    44      -3.969 -13.214 -13.814  1.00  1.00          
ATOM    725 HG11 VAL    44      -5.012 -12.979 -13.954  1.00  1.00          
ATOM    726 HG12 VAL    44      -3.761 -14.197 -14.212  1.00  1.00          
ATOM    727 HG13 VAL    44      -3.357 -12.481 -14.331  1.00  1.00          
ATOM    728  CG2 VAL    44      -2.115 -13.281 -12.114  1.00  1.00          
ATOM    729 HG21 VAL    44      -1.894 -13.608 -11.106  1.00  1.00          
ATOM    730 HG22 VAL    44      -1.667 -12.313 -12.281  1.00  1.00          
ATOM    731 HG23 VAL    44      -1.711 -13.991 -12.820  1.00  1.00          
ATOM    732  C   VAL    44      -4.173 -10.529 -12.072  1.00  1.00          
ATOM    733  O   VAL    44      -5.123 -10.090 -12.753  1.00  1.00          
ATOM    734  N   PHE    45      -3.024  -9.853 -11.825  1.00  1.00          
ATOM    735  HN  PHE    45      -2.310 -10.311 -11.336  1.00  1.00          
ATOM    736  CA  PHE    45      -2.760  -8.460 -12.291  1.00  1.00          
ATOM    737  HA  PHE    45      -3.609  -8.149 -12.882  1.00  1.00          
ATOM    738  CB  PHE    45      -2.596  -7.484 -11.088  1.00  1.00          
ATOM    739  HB1 PHE    45      -2.402  -6.494 -11.480  1.00  1.00          
ATOM    740  HB2 PHE    45      -1.745  -7.793 -10.507  1.00  1.00          
ATOM    741  CG  PHE    45      -3.782  -7.372 -10.139  1.00  1.00          
ATOM    742  CD1 PHE    45      -3.855  -8.180  -9.013  1.00  1.00          
ATOM    743  HD1 PHE    45      -3.068  -8.895  -8.822  1.00  1.00          
ATOM    744  CD2 PHE    45      -4.802  -6.457 -10.368  1.00  1.00          
ATOM    745  HD2 PHE    45      -4.759  -5.823 -11.241  1.00  1.00          
ATOM    746  CE1 PHE    45      -4.918  -8.079  -8.137  1.00  1.00          
ATOM    747  HE1 PHE    45      -4.959  -8.717  -7.266  1.00  1.00          
ATOM    748  CE2 PHE    45      -5.869  -6.355  -9.495  1.00  1.00          
ATOM    749  HE2 PHE    45      -6.657  -5.640  -9.685  1.00  1.00          
ATOM    750  CZ  PHE    45      -5.927  -7.166  -8.377  1.00  1.00          
ATOM    751  HZ  PHE    45      -6.758  -7.085  -7.691  1.00  1.00          
ATOM    752  C   PHE    45      -1.496  -8.411 -13.176  1.00  1.00          
ATOM    753  O   PHE    45      -0.585  -9.239 -13.001  1.00  1.00          
ATOM    754  N   LYS    46      -1.461  -7.419 -14.111  1.00  1.00          
ATOM    755  HN  LYS    46      -2.215  -6.796 -14.144  1.00  1.00          
ATOM    756  CA  LYS    46      -0.337  -7.215 -15.069  1.00  1.00          
ATOM    757  HA  LYS    46       0.244  -8.125 -15.090  1.00  1.00          
ATOM    758  CB  LYS    46      -0.874  -6.933 -16.487  1.00  1.00          
ATOM    759  HB1 LYS    46      -0.082  -6.487 -17.073  1.00  1.00          
ATOM    760  HB2 LYS    46      -1.688  -6.229 -16.413  1.00  1.00          
ATOM    761  CG  LYS    46      -1.381  -8.167 -17.233  1.00  1.00          
ATOM    762  HG1 LYS    46      -2.151  -8.641 -16.640  1.00  1.00          
ATOM    763  HG2 LYS    46      -0.560  -8.855 -17.375  1.00  1.00          
ATOM    764  CD  LYS    46      -1.959  -7.804 -18.591  1.00  1.00          
ATOM    765  HD1 LYS    46      -1.178  -7.371 -19.200  1.00  1.00          
ATOM    766  HD2 LYS    46      -2.751  -7.084 -18.453  1.00  1.00          
ATOM    767  CE  LYS    46      -2.519  -9.025 -19.303  1.00  1.00          
ATOM    768  HE1 LYS    46      -3.269  -9.481 -18.671  1.00  1.00          
ATOM    769  HE2 LYS    46      -1.717  -9.728 -19.471  1.00  1.00          
ATOM    770  NZ  LYS    46      -3.136  -8.676 -20.612  1.00  1.00          
ATOM    771  HZ1 LYS    46      -2.398  -8.563 -21.336  1.00  1.00          
ATOM    772  HZ2 LYS    46      -3.666  -7.785 -20.532  1.00  1.00          
ATOM    773  HZ3 LYS    46      -3.789  -9.428 -20.912  1.00  1.00          
ATOM    774  C   LYS    46       0.572  -6.065 -14.623  1.00  1.00          
ATOM    775  O   LYS    46       0.070  -5.042 -14.119  1.00  1.00          
ATOM    776  N   CYS    47       1.910  -6.257 -14.833  1.00  1.00          
ATOM    777  HN  CYS    47       2.196  -7.098 -15.249  1.00  1.00          
ATOM    778  CA  CYS    47       2.953  -5.266 -14.472  1.00  1.00          
ATOM    779  HA  CYS    47       2.533  -4.623 -13.712  1.00  1.00          
ATOM    780  HB1 CYS    47       4.711  -6.497 -14.684  1.00  1.00          
ATOM    781  HB2 CYS    47       3.904  -6.672 -13.134  1.00  1.00          
ATOM    782  C   CYS    47       3.345  -4.372 -15.704  1.00  1.00          
ATOM    783  O   CYS    47       3.766  -4.951 -16.732  1.00  1.00          
ATOM    784  CB  CYS    47       4.208  -5.966 -13.888  1.00  1.00          
ATOM    785  SG  CYS    47       5.427  -4.827 -13.126  1.00  1.00          
ATOM    786  N   PRO    48       3.164  -2.947 -15.672  1.00  1.00          
ATOM    787  CA  PRO    48       3.583  -2.056 -16.816  1.00  1.00          
ATOM    788  HA  PRO    48       3.246  -2.481 -17.754  1.00  1.00          
ATOM    789  CB  PRO    48       2.813  -0.732 -16.554  1.00  1.00          
ATOM    790  HB1 PRO    48       1.880  -0.736 -17.109  1.00  1.00          
ATOM    791  HB2 PRO    48       3.419   0.101 -16.888  1.00  1.00          
ATOM    792  CG  PRO    48       2.565  -0.676 -15.066  1.00  1.00          
ATOM    793  HG1 PRO    48       1.637  -0.148 -14.863  1.00  1.00          
ATOM    794  HG2 PRO    48       3.389  -0.167 -14.575  1.00  1.00          
ATOM    795  CD  PRO    48       2.475  -2.119 -14.597  1.00  1.00          
ATOM    796  HD1 PRO    48       1.438  -2.422 -14.504  1.00  1.00          
ATOM    797  HD2 PRO    48       2.978  -2.245 -13.647  1.00  1.00          
ATOM    798  C   PRO    48       5.134  -1.808 -16.941  1.00  1.00          
ATOM    799  O   PRO    48       5.580  -1.215 -17.942  1.00  1.00          
ATOM    800  N   VAL    49       5.914  -2.285 -15.914  1.00  1.00          
ATOM    801  HN  VAL    49       5.466  -2.773 -15.190  1.00  1.00          
ATOM    802  CA  VAL    49       7.410  -2.126 -15.828  1.00  1.00          
ATOM    803  HA  VAL    49       7.655  -1.220 -16.367  1.00  1.00          
ATOM    804  CB  VAL    49       7.997  -1.978 -14.329  1.00  1.00          
ATOM    805  HB  VAL    49       8.270  -2.973 -13.995  1.00  1.00          
ATOM    806  CG1 VAL    49       9.286  -1.133 -14.304  1.00  1.00          
ATOM    807 HG11 VAL    49       9.728  -1.179 -13.319  1.00  1.00          
ATOM    808 HG12 VAL    49       9.051  -0.107 -14.545  1.00  1.00          
ATOM    809 HG13 VAL    49       9.985  -1.521 -15.031  1.00  1.00          
ATOM    810  CG2 VAL    49       7.014  -1.365 -13.292  1.00  1.00          
ATOM    811 HG21 VAL    49       7.520  -0.592 -12.735  1.00  1.00          
ATOM    812 HG22 VAL    49       6.661  -2.128 -12.608  1.00  1.00          
ATOM    813 HG23 VAL    49       6.169  -0.937 -13.811  1.00  1.00          
ATOM    814  C   VAL    49       8.125  -3.313 -16.556  1.00  1.00          
ATOM    815  O   VAL    49       8.993  -3.056 -17.414  1.00  1.00          
ATOM    816  N   CYS    50       7.739  -4.573 -16.193  1.00  1.00          
ATOM    817  HN  CYS    50       7.043  -4.666 -15.510  1.00  1.00          
ATOM    818  CA  CYS    50       8.316  -5.799 -16.777  1.00  1.00          
ATOM    819  HA  CYS    50       9.232  -5.497 -17.267  1.00  1.00          
ATOM    820  HB1 CYS    50       9.375  -6.333 -15.000  1.00  1.00          
ATOM    821  HB2 CYS    50       9.172  -7.660 -16.127  1.00  1.00          
ATOM    822  C   CYS    50       7.403  -6.411 -17.860  1.00  1.00          
ATOM    823  O   CYS    50       7.904  -6.697 -18.965  1.00  1.00          
ATOM    824  CB  CYS    50       8.686  -6.811 -15.671  1.00  1.00          
ATOM    825  SG  CYS    50       7.291  -7.452 -14.676  1.00  1.00          
ATOM    826  N   GLY    51       6.086  -6.606 -17.531  1.00  1.00          
ATOM    827  HN  GLY    51       5.807  -6.447 -16.602  1.00  1.00          
ATOM    828  CA  GLY    51       5.095  -7.163 -18.482  1.00  1.00          
ATOM    829  HA1 GLY    51       5.587  -7.312 -19.433  1.00  1.00          
ATOM    830  HA2 GLY    51       4.309  -6.438 -18.617  1.00  1.00          
ATOM    831  C   GLY    51       4.452  -8.493 -18.053  1.00  1.00          
ATOM    832  O   GLY    51       3.428  -8.877 -18.644  1.00  1.00          
ATOM    833  N   GLU    52       5.054  -9.183 -17.026  1.00  1.00          
ATOM    834  HN  GLU    52       5.868  -8.795 -16.642  1.00  1.00          
ATOM    835  CA  GLU    52       4.571 -10.482 -16.473  1.00  1.00          
ATOM    836  HA  GLU    52       4.185 -11.058 -17.302  1.00  1.00          
ATOM    837  CB  GLU    52       5.752 -11.251 -15.856  1.00  1.00          
ATOM    838  HB1 GLU    52       5.394 -11.825 -15.014  1.00  1.00          
ATOM    839  HB2 GLU    52       6.489 -10.542 -15.511  1.00  1.00          
ATOM    840  CG  GLU    52       6.425 -12.204 -16.834  1.00  1.00          
ATOM    841  HG1 GLU    52       6.781 -11.636 -17.680  1.00  1.00          
ATOM    842  HG2 GLU    52       5.697 -12.928 -17.168  1.00  1.00          
ATOM    843  CD  GLU    52       7.596 -12.946 -16.222  1.00  1.00          
ATOM    844  OE1 GLU    52       8.722 -12.408 -16.254  1.00  1.00          
ATOM    845  OE2 GLU    52       7.387 -14.067 -15.710  1.00  1.00          
ATOM    846  C   GLU    52       3.428 -10.301 -15.440  1.00  1.00          
ATOM    847  O   GLU    52       3.339  -9.245 -14.787  1.00  1.00          
ATOM    848  N   GLU    53       2.574 -11.365 -15.317  1.00  1.00          
ATOM    849  HN  GLU    53       2.767 -12.169 -15.843  1.00  1.00          
ATOM    850  CA  GLU    53       1.381 -11.411 -14.420  1.00  1.00          
ATOM    851  HA  GLU    53       0.974 -10.414 -14.346  1.00  1.00          
ATOM    852  CB  GLU    53       0.304 -12.324 -15.040  1.00  1.00          
ATOM    853  HB1 GLU    53      -0.391 -12.615 -14.270  1.00  1.00          
ATOM    854  HB2 GLU    53       0.784 -13.211 -15.429  1.00  1.00          
ATOM    855  CG  GLU    53      -0.490 -11.674 -16.179  1.00  1.00          
ATOM    856  HG1 GLU    53       0.205 -11.287 -16.910  1.00  1.00          
ATOM    857  HG2 GLU    53      -1.072 -10.861 -15.773  1.00  1.00          
ATOM    858  CD  GLU    53      -1.434 -12.638 -16.870  1.00  1.00          
ATOM    859  OE1 GLU    53      -0.962 -13.427 -17.715  1.00  1.00          
ATOM    860  OE2 GLU    53      -2.647 -12.589 -16.586  1.00  1.00          
ATOM    861  C   GLU    53       1.742 -11.898 -13.004  1.00  1.00          
ATOM    862  O   GLU    53       2.536 -12.846 -12.861  1.00  1.00          
ATOM    863  N   PHE    54       1.139 -11.222 -11.991  1.00  1.00          
ATOM    864  HN  PHE    54       0.487 -10.527 -12.219  1.00  1.00          
ATOM    865  CA  PHE    54       1.337 -11.502 -10.546  1.00  1.00          
ATOM    866  HA  PHE    54       1.840 -12.458 -10.483  1.00  1.00          
ATOM    867  CB  PHE    54       2.251 -10.415  -9.864  1.00  1.00          
ATOM    868  HB1 PHE    54       3.228 -10.459 -10.326  1.00  1.00          
ATOM    869  HB2 PHE    54       2.361 -10.669  -8.822  1.00  1.00          
ATOM    870  CG  PHE    54       1.785  -8.954  -9.918  1.00  1.00          
ATOM    871  CD1 PHE    54       0.995  -8.436  -8.904  1.00  1.00          
ATOM    872  HD1 PHE    54       0.722  -9.067  -8.071  1.00  1.00          
ATOM    873  CD2 PHE    54       2.129  -8.132 -10.980  1.00  1.00          
ATOM    874  HD2 PHE    54       2.747  -8.523 -11.775  1.00  1.00          
ATOM    875  CE1 PHE    54       0.556  -7.126  -8.947  1.00  1.00          
ATOM    876  HE1 PHE    54      -0.059  -6.735  -8.150  1.00  1.00          
ATOM    877  CE2 PHE    54       1.694  -6.820 -11.026  1.00  1.00          
ATOM    878  HE2 PHE    54       1.965  -6.188 -11.856  1.00  1.00          
ATOM    879  CZ  PHE    54       0.905  -6.318 -10.009  1.00  1.00          
ATOM    880  HZ  PHE    54       0.563  -5.295 -10.046  1.00  1.00          
ATOM    881  C   PHE    54      -0.034 -11.653  -9.849  1.00  1.00          
ATOM    882  O   PHE    54      -0.969 -10.889 -10.162  1.00  1.00          
ATOM    883  N   TYR    55      -0.119 -12.615  -8.898  1.00  1.00          
ATOM    884  HN  TYR    55       0.686 -13.125  -8.672  1.00  1.00          
ATOM    885  CA  TYR    55      -1.363 -12.935  -8.148  1.00  1.00          
ATOM    886  HA  TYR    55      -2.197 -12.602  -8.746  1.00  1.00          
ATOM    887  CB  TYR    55      -1.477 -14.469  -7.949  1.00  1.00          
ATOM    888  HB1 TYR    55      -2.236 -14.667  -7.207  1.00  1.00          
ATOM    889  HB2 TYR    55      -0.532 -14.841  -7.584  1.00  1.00          
ATOM    890  CG  TYR    55      -1.827 -15.271  -9.202  1.00  1.00          
ATOM    891  CD1 TYR    55      -0.826 -15.803 -10.011  1.00  1.00          
ATOM    892  HD1 TYR    55       0.206 -15.632  -9.747  1.00  1.00          
ATOM    893  CD2 TYR    55      -3.152 -15.506  -9.566  1.00  1.00          
ATOM    894  HD2 TYR    55      -3.945 -15.100  -8.957  1.00  1.00          
ATOM    895  CE1 TYR    55      -1.135 -16.542 -11.138  1.00  1.00          
ATOM    896  HE1 TYR    55      -0.342 -16.947 -11.751  1.00  1.00          
ATOM    897  CE2 TYR    55      -3.465 -16.242 -10.694  1.00  1.00          
ATOM    898  HE2 TYR    55      -4.498 -16.413 -10.957  1.00  1.00          
ATOM    899  CZ  TYR    55      -2.453 -16.758 -11.475  1.00  1.00          
ATOM    900  OH  TYR    55      -2.762 -17.493 -12.597  1.00  1.00          
ATOM    901  HH  TYR    55      -3.405 -18.168 -12.371  1.00  1.00          
ATOM    902  C   TYR    55      -1.424 -12.224  -6.782  1.00  1.00          
ATOM    903  O   TYR    55      -0.370 -11.935  -6.183  1.00  1.00          
ATOM    904  N   GLY    56      -2.689 -11.949  -6.310  1.00  1.00          
ATOM    905  HN  GLY    56      -3.450 -12.205  -6.872  1.00  1.00          
ATOM    906  CA  GLY    56      -2.969 -11.294  -4.993  1.00  1.00          
ATOM    907  HA1 GLY    56      -3.977 -10.905  -5.012  1.00  1.00          
ATOM    908  HA2 GLY    56      -2.288 -10.464  -4.875  1.00  1.00          
ATOM    909  C   GLY    56      -2.816 -12.227  -3.760  1.00  1.00          
ATOM    910  O   GLY    56      -2.881 -11.750  -2.615  1.00  1.00          
ATOM    911  N   LYS    57      -2.617 -13.552  -4.048  1.00  1.00          
ATOM    912  HN  LYS    57      -2.606 -13.783  -5.000  1.00  1.00          
ATOM    913  CA  LYS    57      -2.389 -14.631  -3.044  1.00  1.00          
ATOM    914  HA  LYS    57      -2.947 -14.368  -2.158  1.00  1.00          
ATOM    915  CB  LYS    57      -2.919 -15.974  -3.588  1.00  1.00          
ATOM    916  HB1 LYS    57      -2.089 -16.532  -3.999  1.00  1.00          
ATOM    917  HB2 LYS    57      -3.626 -15.772  -4.378  1.00  1.00          
ATOM    918  CG  LYS    57      -3.613 -16.853  -2.543  1.00  1.00          
ATOM    919  HG1 LYS    57      -4.380 -16.276  -2.050  1.00  1.00          
ATOM    920  HG2 LYS    57      -2.882 -17.174  -1.816  1.00  1.00          
ATOM    921  CD  LYS    57      -4.252 -18.086  -3.178  1.00  1.00          
ATOM    922  HD1 LYS    57      -3.482 -18.648  -3.689  1.00  1.00          
ATOM    923  HD2 LYS    57      -4.994 -17.762  -3.892  1.00  1.00          
ATOM    924  CE  LYS    57      -4.928 -18.985  -2.136  1.00  1.00          
ATOM    925  HE1 LYS    57      -4.326 -18.991  -1.240  1.00  1.00          
ATOM    926  HE2 LYS    57      -4.997 -19.992  -2.525  1.00  1.00          
ATOM    927  NZ  LYS    57      -6.303 -18.515  -1.790  1.00  1.00          
ATOM    928  HZ1 LYS    57      -6.733 -19.150  -1.086  1.00  1.00          
ATOM    929  HZ2 LYS    57      -6.901 -18.503  -2.640  1.00  1.00          
ATOM    930  HZ3 LYS    57      -6.264 -17.553  -1.395  1.00  1.00          
ATOM    931  C   LYS    57      -0.874 -14.755  -2.662  1.00  1.00          
ATOM    932  O   LYS    57      -0.554 -15.326  -1.604  1.00  1.00          
ATOM    933  N   THR    58       0.013 -14.210  -3.547  1.00  1.00          
ATOM    934  HN  THR    58      -0.349 -13.780  -4.350  1.00  1.00          
ATOM    935  CA  THR    58       1.493 -14.204  -3.378  1.00  1.00          
ATOM    936  HA  THR    58       1.736 -14.989  -2.675  1.00  1.00          
ATOM    937  CB  THR    58       2.235 -14.516  -4.729  1.00  1.00          
ATOM    938  HB  THR    58       3.276 -14.255  -4.602  1.00  1.00          
ATOM    939  OG1 THR    58       1.700 -13.726  -5.798  1.00  1.00          
ATOM    940  HG1 THR    58       0.791 -13.491  -5.598  1.00  1.00          
ATOM    941  CG2 THR    58       2.157 -15.999  -5.108  1.00  1.00          
ATOM    942 HG21 THR    58       2.463 -16.606  -4.270  1.00  1.00          
ATOM    943 HG22 THR    58       2.810 -16.189  -5.947  1.00  1.00          
ATOM    944 HG23 THR    58       1.138 -16.245  -5.381  1.00  1.00          
ATOM    945  C   THR    58       2.013 -12.847  -2.784  1.00  1.00          
ATOM    946  O   THR    58       3.244 -12.651  -2.648  1.00  1.00          
ATOM    947  N   LEU    59       1.051 -11.941  -2.376  1.00  1.00          
ATOM    948  HN  LEU    59       0.111 -12.217  -2.445  1.00  1.00          
ATOM    949  CA  LEU    59       1.347 -10.603  -1.784  1.00  1.00          
ATOM    950  HA  LEU    59       2.256 -10.253  -2.244  1.00  1.00          
ATOM    951  CB  LEU    59       0.194  -9.605  -2.082  1.00  1.00          
ATOM    952  HB1 LEU    59      -0.209  -9.264  -1.136  1.00  1.00          
ATOM    953  HB2 LEU    59      -0.585 -10.141  -2.603  1.00  1.00          
ATOM    954  CG  LEU    59       0.539  -8.353  -2.918  1.00  1.00          
ATOM    955  HG  LEU    59       1.597  -8.149  -2.859  1.00  1.00          
ATOM    956  CD1 LEU    59       0.179  -8.558  -4.386  1.00  1.00          
ATOM    957 HD11 LEU    59       0.648  -7.790  -4.982  1.00  1.00          
ATOM    958 HD12 LEU    59      -0.893  -8.502  -4.506  1.00  1.00          
ATOM    959 HD13 LEU    59       0.528  -9.529  -4.710  1.00  1.00          
ATOM    960  CD2 LEU    59      -0.199  -7.140  -2.364  1.00  1.00          
ATOM    961 HD21 LEU    59      -0.085  -6.307  -3.043  1.00  1.00          
ATOM    962 HD22 LEU    59       0.213  -6.878  -1.401  1.00  1.00          
ATOM    963 HD23 LEU    59      -1.248  -7.374  -2.255  1.00  1.00          
ATOM    964  C   LEU    59       1.576 -10.701  -0.224  1.00  1.00          
ATOM    965  O   LEU    59       1.091 -11.689   0.366  1.00  1.00          
ATOM    966  N   PRO    60       2.291  -9.689   0.512  1.00  1.00          
ATOM    967  CA  PRO    60       2.542  -9.770   2.005  1.00  1.00          
ATOM    968  HA  PRO    60       3.000 -10.718   2.259  1.00  1.00          
ATOM    969  CB  PRO    60       3.541  -8.618   2.284  1.00  1.00          
ATOM    970  HB1 PRO    60       4.331  -8.957   2.948  1.00  1.00          
ATOM    971  HB2 PRO    60       3.013  -7.795   2.748  1.00  1.00          
ATOM    972  CG  PRO    60       4.076  -8.238   0.941  1.00  1.00          
ATOM    973  HG1 PRO    60       4.889  -8.898   0.663  1.00  1.00          
ATOM    974  HG2 PRO    60       4.412  -7.208   0.945  1.00  1.00          
ATOM    975  CD  PRO    60       2.916  -8.416   0.005  1.00  1.00          
ATOM    976  HD1 PRO    60       3.258  -8.528  -1.012  1.00  1.00          
ATOM    977  HD2 PRO    60       2.228  -7.584   0.088  1.00  1.00          
ATOM    978  C   PRO    60       1.277  -9.594   2.870  1.00  1.00          
ATOM    979  O   PRO    60       0.309  -8.953   2.429  1.00  1.00          
ATOM    980  N   ARG    61       1.326 -10.175   4.109  1.00  1.00          
ATOM    981  HN  ARG    61       2.150 -10.644   4.354  1.00  1.00          
ATOM    982  CA  ARG    61       0.215 -10.152   5.121  1.00  1.00          
ATOM    983  HA  ARG    61      -0.676 -10.465   4.596  1.00  1.00          
ATOM    984  CB  ARG    61       0.482 -11.181   6.232  1.00  1.00          
ATOM    985  HB1 ARG    61      -0.032 -10.867   7.128  1.00  1.00          
ATOM    986  HB2 ARG    61       1.544 -11.214   6.428  1.00  1.00          
ATOM    987  CG  ARG    61       0.014 -12.587   5.877  1.00  1.00          
ATOM    988  HG1 ARG    61       0.531 -12.912   4.985  1.00  1.00          
ATOM    989  HG2 ARG    61      -1.048 -12.565   5.687  1.00  1.00          
ATOM    990  CD  ARG    61       0.286 -13.582   6.994  1.00  1.00          
ATOM    991  HD1 ARG    61      -0.206 -13.242   7.892  1.00  1.00          
ATOM    992  HD2 ARG    61       1.352 -13.636   7.163  1.00  1.00          
ATOM    993  NE  ARG    61      -0.219 -14.938   6.652  1.00  1.00          
ATOM    994  HE  ARG    61      -0.687 -15.011   5.795  1.00  1.00          
ATOM    995  CZ  ARG    61      -0.105 -16.080   7.398  1.00  1.00          
ATOM    996  NH1 ARG    61       0.508 -16.135   8.596  1.00  1.00          
ATOM    997 HH11 ARG    61       0.912 -15.309   8.988  1.00  1.00          
ATOM    998 HH12 ARG    61       0.558 -17.001   9.092  1.00  1.00          
ATOM    999  NH2 ARG    61      -0.629 -17.199   6.917  1.00  1.00          
ATOM   1000 HH21 ARG    61      -1.095 -17.194   6.032  1.00  1.00          
ATOM   1001 HH22 ARG    61      -0.562 -18.048   7.442  1.00  1.00          
ATOM   1002  C   ARG    61      -0.090  -8.754   5.739  1.00  1.00          
ATOM   1003  O   ARG    61      -1.190  -8.561   6.297  1.00  1.00          
ATOM   1004  N   ARG    62       0.883  -7.787   5.613  1.00  1.00          
ATOM   1005  HN  ARG    62       1.677  -7.969   5.070  1.00  1.00          
ATOM   1006  CA  ARG    62       0.757  -6.390   6.122  1.00  1.00          
ATOM   1007  HA  ARG    62       0.193  -6.431   7.042  1.00  1.00          
ATOM   1008  CB  ARG    62       2.140  -5.819   6.419  1.00  1.00          
ATOM   1009  HB1 ARG    62       2.128  -4.758   6.227  1.00  1.00          
ATOM   1010  HB2 ARG    62       2.860  -6.289   5.765  1.00  1.00          
ATOM   1011  CG  ARG    62       2.583  -6.042   7.863  1.00  1.00          
ATOM   1012  HG1 ARG    62       2.496  -7.095   8.091  1.00  1.00          
ATOM   1013  HG2 ARG    62       1.927  -5.480   8.515  1.00  1.00          
ATOM   1014  CD  ARG    62       4.030  -5.600   8.114  1.00  1.00          
ATOM   1015  HD1 ARG    62       4.186  -5.502   9.181  1.00  1.00          
ATOM   1016  HD2 ARG    62       4.183  -4.639   7.644  1.00  1.00          
ATOM   1017  NE  ARG    62       5.037  -6.563   7.573  1.00  1.00          
ATOM   1018  HE  ARG    62       4.687  -7.438   7.301  1.00  1.00          
ATOM   1019  CZ  ARG    62       6.378  -6.352   7.404  1.00  1.00          
ATOM   1020  NH1 ARG    62       7.002  -5.209   7.753  1.00  1.00          
ATOM   1021 HH11 ARG    62       6.480  -4.459   8.159  1.00  1.00          
ATOM   1022 HH12 ARG    62       7.986  -5.112   7.606  1.00  1.00          
ATOM   1023  NH2 ARG    62       7.109  -7.325   6.880  1.00  1.00          
ATOM   1024 HH21 ARG    62       6.677  -8.189   6.618  1.00  1.00          
ATOM   1025 HH22 ARG    62       8.091  -7.197   6.744  1.00  1.00          
ATOM   1026  C   ARG    62      -0.001  -5.469   5.128  1.00  1.00          
ATOM   1027  O   ARG    62      -0.718  -4.554   5.566  1.00  1.00          
ATOM   1028  N   GLU    63       0.185  -5.737   3.781  1.00  1.00          
ATOM   1029  HN  GLU    63       0.812  -6.451   3.540  1.00  1.00          
ATOM   1030  CA  GLU    63      -0.483  -5.013   2.644  1.00  1.00          
ATOM   1031  HA  GLU    63      -0.363  -3.958   2.832  1.00  1.00          
ATOM   1032  CB  GLU    63       0.205  -5.347   1.315  1.00  1.00          
ATOM   1033  HB1 GLU    63      -0.504  -5.212   0.514  1.00  1.00          
ATOM   1034  HB2 GLU    63       0.520  -6.379   1.336  1.00  1.00          
ATOM   1035  CG  GLU    63       1.430  -4.481   1.023  1.00  1.00          
ATOM   1036  HG1 GLU    63       2.159  -4.643   1.802  1.00  1.00          
ATOM   1037  HG2 GLU    63       1.126  -3.445   1.029  1.00  1.00          
ATOM   1038  CD  GLU    63       2.082  -4.780  -0.322  1.00  1.00          
ATOM   1039  OE1 GLU    63       3.211  -5.309  -0.323  1.00  1.00          
ATOM   1040  OE2 GLU    63       1.478  -4.459  -1.374  1.00  1.00          
ATOM   1041  C   GLU    63      -2.004  -5.306   2.532  1.00  1.00          
ATOM   1042  O   GLU    63      -2.757  -4.448   2.046  1.00  1.00          
ATOM   1043  N   ALA    64      -2.424  -6.543   2.991  1.00  1.00          
ATOM   1044  HN  ALA    64      -1.733  -7.165   3.292  1.00  1.00          
ATOM   1045  CA  ALA    64      -3.851  -7.021   3.050  1.00  1.00          
ATOM   1046  HA  ALA    64      -4.267  -6.928   2.057  1.00  1.00          
ATOM   1047  CB  ALA    64      -3.891  -8.493   3.436  1.00  1.00          
ATOM   1048  HB1 ALA    64      -4.908  -8.853   3.373  1.00  1.00          
ATOM   1049  HB2 ALA    64      -3.528  -8.612   4.446  1.00  1.00          
ATOM   1050  HB3 ALA    64      -3.268  -9.059   2.760  1.00  1.00          
ATOM   1051  C   ALA    64      -4.728  -6.188   4.032  1.00  1.00          
ATOM   1052  O   ALA    64      -5.934  -6.023   3.800  1.00  1.00          
ATOM   1053  N   GLU    65      -4.064  -5.680   5.132  1.00  1.00          
ATOM   1054  HN  GLU    65      -3.124  -5.930   5.241  1.00  1.00          
ATOM   1055  CA  GLU    65      -4.661  -4.777   6.179  1.00  1.00          
ATOM   1056  HA  GLU    65      -5.616  -5.197   6.458  1.00  1.00          
ATOM   1057  CB  GLU    65      -3.764  -4.716   7.427  1.00  1.00          
ATOM   1058  HB1 GLU    65      -4.016  -3.828   7.989  1.00  1.00          
ATOM   1059  HB2 GLU    65      -2.735  -4.649   7.110  1.00  1.00          
ATOM   1060  CG  GLU    65      -3.898  -5.921   8.355  1.00  1.00          
ATOM   1061  HG1 GLU    65      -3.647  -6.815   7.801  1.00  1.00          
ATOM   1062  HG2 GLU    65      -4.921  -5.986   8.695  1.00  1.00          
ATOM   1063  CD  GLU    65      -2.989  -5.830   9.566  1.00  1.00          
ATOM   1064  OE1 GLU    65      -1.820  -6.254   9.463  1.00  1.00          
ATOM   1065  OE2 GLU    65      -3.448  -5.334  10.617  1.00  1.00          
ATOM   1066  C   GLU    65      -4.904  -3.336   5.637  1.00  1.00          
ATOM   1067  O   GLU    65      -5.807  -2.638   6.122  1.00  1.00          
ATOM   1068  N   LYS    66      -4.061  -2.925   4.618  1.00  1.00          
ATOM   1069  HN  LYS    66      -3.348  -3.544   4.353  1.00  1.00          
ATOM   1070  CA  LYS    66      -4.141  -1.614   3.877  1.00  1.00          
ATOM   1071  HA  LYS    66      -4.193  -0.833   4.622  1.00  1.00          
ATOM   1072  CB  LYS    66      -2.892  -1.379   3.008  1.00  1.00          
ATOM   1073  HB1 LYS    66      -3.119  -0.611   2.282  1.00  1.00          
ATOM   1074  HB2 LYS    66      -2.660  -2.293   2.484  1.00  1.00          
ATOM   1075  CG  LYS    66      -1.646  -0.949   3.780  1.00  1.00          
ATOM   1076  HG1 LYS    66      -1.381  -1.727   4.480  1.00  1.00          
ATOM   1077  HG2 LYS    66      -1.860  -0.036   4.316  1.00  1.00          
ATOM   1078  CD  LYS    66      -0.473  -0.706   2.844  1.00  1.00          
ATOM   1079  HD1 LYS    66      -0.743   0.062   2.135  1.00  1.00          
ATOM   1080  HD2 LYS    66      -0.248  -1.620   2.318  1.00  1.00          
ATOM   1081  CE  LYS    66       0.761  -0.260   3.609  1.00  1.00          
ATOM   1082  HE1 LYS    66       1.028  -1.032   4.317  1.00  1.00          
ATOM   1083  HE2 LYS    66       0.530   0.650   4.140  1.00  1.00          
ATOM   1084  NZ  LYS    66       1.917  -0.012   2.706  1.00  1.00          
ATOM   1085  HZ1 LYS    66       2.282   0.951   2.850  1.00  1.00          
ATOM   1086  HZ2 LYS    66       1.625  -0.116   1.714  1.00  1.00          
ATOM   1087  HZ3 LYS    66       2.677  -0.693   2.905  1.00  1.00          
ATOM   1088  C   LYS    66      -5.405  -1.510   2.980  1.00  1.00          
ATOM   1089  O   LYS    66      -5.903  -0.399   2.742  1.00  1.00          
ATOM   1090  N   VAL    67      -5.900  -2.708   2.492  1.00  1.00          
ATOM   1091  HN  VAL    67      -5.401  -3.522   2.717  1.00  1.00          
ATOM   1092  CA  VAL    67      -7.146  -2.879   1.637  1.00  1.00          
ATOM   1093  HA  VAL    67      -7.070  -2.150   0.837  1.00  1.00          
ATOM   1094  CB  VAL    67      -7.300  -4.336   0.963  1.00  1.00          
ATOM   1095  HB  VAL    67      -7.701  -5.001   1.715  1.00  1.00          
ATOM   1096  CG1 VAL    67      -8.282  -4.338  -0.231  1.00  1.00          
ATOM   1097 HG11 VAL    67      -9.277  -4.113   0.123  1.00  1.00          
ATOM   1098 HG12 VAL    67      -8.276  -5.309  -0.702  1.00  1.00          
ATOM   1099 HG13 VAL    67      -7.977  -3.587  -0.947  1.00  1.00          
ATOM   1100  CG2 VAL    67      -5.971  -4.936   0.462  1.00  1.00          
ATOM   1101 HG21 VAL    67      -5.627  -4.378  -0.397  1.00  1.00          
ATOM   1102 HG22 VAL    67      -6.123  -5.968   0.185  1.00  1.00          
ATOM   1103 HG23 VAL    67      -5.232  -4.879   1.248  1.00  1.00          
ATOM   1104  C   VAL    67      -8.421  -2.511   2.492  1.00  1.00          
ATOM   1105  O   VAL    67      -9.346  -1.894   1.965  1.00  1.00          
ATOM   1106  N   PHE    68      -8.439  -2.927   3.807  1.00  1.00          
ATOM   1107  HN  PHE    68      -7.742  -3.540   4.124  1.00  1.00          
ATOM   1108  CA  PHE    68      -9.503  -2.592   4.824  1.00  1.00          
ATOM   1109  HA  PHE    68     -10.443  -3.012   4.483  1.00  1.00          
ATOM   1110  CB  PHE    68      -9.123  -3.235   6.174  1.00  1.00          
ATOM   1111  HB1 PHE    68      -9.193  -2.480   6.944  1.00  1.00          
ATOM   1112  HB2 PHE    68      -8.101  -3.576   6.116  1.00  1.00          
ATOM   1113  CG  PHE    68      -9.968  -4.414   6.608  1.00  1.00          
ATOM   1114  CD1 PHE    68      -9.597  -5.713   6.280  1.00  1.00          
ATOM   1115  HD1 PHE    68      -8.704  -5.875   5.696  1.00  1.00          
ATOM   1116  CD2 PHE    68     -11.119  -4.226   7.366  1.00  1.00          
ATOM   1117  HD2 PHE    68     -11.420  -3.224   7.631  1.00  1.00          
ATOM   1118  CE1 PHE    68     -10.354  -6.794   6.695  1.00  1.00          
ATOM   1119  HE1 PHE    68     -10.053  -7.798   6.434  1.00  1.00          
ATOM   1120  CE2 PHE    68     -11.878  -5.303   7.780  1.00  1.00          
ATOM   1121  HE2 PHE    68     -12.771  -5.141   8.365  1.00  1.00          
ATOM   1122  CZ  PHE    68     -11.496  -6.588   7.445  1.00  1.00          
ATOM   1123  HZ  PHE    68     -12.089  -7.430   7.769  1.00  1.00          
ATOM   1124  C   PHE    68      -9.679  -1.054   5.056  1.00  1.00          
ATOM   1125  O   PHE    68     -10.775  -0.605   5.420  1.00  1.00          
ATOM   1126  N   GLU    69      -8.551  -0.285   4.832  1.00  1.00          
ATOM   1127  HN  GLU    69      -7.763  -0.745   4.481  1.00  1.00          
ATOM   1128  CA  GLU    69      -8.443   1.192   5.008  1.00  1.00          
ATOM   1129  HA  GLU    69      -8.881   1.428   5.967  1.00  1.00          
ATOM   1130  CB  GLU    69      -6.947   1.586   5.046  1.00  1.00          
ATOM   1131  HB1 GLU    69      -6.628   1.823   4.042  1.00  1.00          
ATOM   1132  HB2 GLU    69      -6.379   0.739   5.399  1.00  1.00          
ATOM   1133  CG  GLU    69      -6.622   2.781   5.946  1.00  1.00          
ATOM   1134  HG1 GLU    69      -6.989   2.573   6.940  1.00  1.00          
ATOM   1135  HG2 GLU    69      -7.132   3.648   5.551  1.00  1.00          
ATOM   1136  CD  GLU    69      -5.134   3.083   6.022  1.00  1.00          
ATOM   1137  OE1 GLU    69      -4.595   3.674   5.062  1.00  1.00          
ATOM   1138  OE2 GLU    69      -4.509   2.732   7.046  1.00  1.00          
ATOM   1139  C   GLU    69      -9.214   1.994   3.916  1.00  1.00          
ATOM   1140  O   GLU    69      -9.885   2.978   4.264  1.00  1.00          
ATOM   1141  N   LEU    70      -9.110   1.556   2.607  1.00  1.00          
ATOM   1142  HN  LEU    70      -8.516   0.805   2.412  1.00  1.00          
ATOM   1143  CA  LEU    70      -9.829   2.185   1.439  1.00  1.00          
ATOM   1144  HA  LEU    70      -9.645   3.250   1.524  1.00  1.00          
ATOM   1145  CB  LEU    70      -9.287   1.700   0.048  1.00  1.00          
ATOM   1146  HB1 LEU    70      -8.383   2.242  -0.168  1.00  1.00          
ATOM   1147  HB2 LEU    70     -10.013   1.983  -0.674  1.00  1.00          
ATOM   1148  CG  LEU    70      -8.996   0.195  -0.186  1.00  1.00          
ATOM   1149  HG  LEU    70      -8.749  -0.268   0.759  1.00  1.00          
ATOM   1150  CD1 LEU    70     -10.218  -0.516  -0.756  1.00  1.00          
ATOM   1151 HD11 LEU    70     -10.060  -1.586  -0.739  1.00  1.00          
ATOM   1152 HD12 LEU    70     -10.377  -0.191  -1.773  1.00  1.00          
ATOM   1153 HD13 LEU    70     -11.085  -0.270  -0.160  1.00  1.00          
ATOM   1154  CD2 LEU    70      -7.806   0.024  -1.121  1.00  1.00          
ATOM   1155 HD21 LEU    70      -7.757  -1.002  -1.460  1.00  1.00          
ATOM   1156 HD22 LEU    70      -6.895   0.273  -0.598  1.00  1.00          
ATOM   1157 HD23 LEU    70      -7.922   0.677  -1.972  1.00  1.00          
ATOM   1158  C   LEU    70     -11.373   1.987   1.512  1.00  1.00          
ATOM   1159  O   LEU    70     -12.134   2.895   1.140  1.00  1.00          
ATOM   1160  N   LEU    71     -11.784   0.771   2.002  1.00  1.00          
ATOM   1161  HN  LEU    71     -11.086   0.116   2.213  1.00  1.00          
ATOM   1162  CA  LEU    71     -13.199   0.356   2.240  1.00  1.00          
ATOM   1163  HA  LEU    71     -13.763   0.606   1.357  1.00  1.00          
ATOM   1164  CB  LEU    71     -13.260  -1.167   2.456  1.00  1.00          
ATOM   1165  HB1 LEU    71     -14.146  -1.382   3.034  1.00  1.00          
ATOM   1166  HB2 LEU    71     -12.397  -1.456   3.040  1.00  1.00          
ATOM   1167  CG  LEU    71     -13.288  -2.029   1.183  1.00  1.00          
ATOM   1168  HG  LEU    71     -13.164  -1.397   0.318  1.00  1.00          
ATOM   1169  CD1 LEU    71     -12.147  -3.033   1.182  1.00  1.00          
ATOM   1170 HD11 LEU    71     -11.205  -2.503   1.168  1.00  1.00          
ATOM   1171 HD12 LEU    71     -12.220  -3.658   0.306  1.00  1.00          
ATOM   1172 HD13 LEU    71     -12.198  -3.644   2.067  1.00  1.00          
ATOM   1173  CD2 LEU    71     -14.623  -2.746   1.055  1.00  1.00          
ATOM   1174 HD21 LEU    71     -14.602  -3.393   0.190  1.00  1.00          
ATOM   1175 HD22 LEU    71     -15.409  -2.015   0.936  1.00  1.00          
ATOM   1176 HD23 LEU    71     -14.814  -3.335   1.940  1.00  1.00          
ATOM   1177  C   LEU    71     -13.856   1.087   3.457  1.00  1.00          
ATOM   1178  O   LEU    71     -15.050   1.425   3.397  1.00  1.00          
ATOM   1179  N   ASN    72     -13.034   1.313   4.541  1.00  1.00          
ATOM   1180  HN  ASN    72     -12.098   1.021   4.473  1.00  1.00          
ATOM   1181  CA  ASN    72     -13.440   1.994   5.806  1.00  1.00          
ATOM   1182  HA  ASN    72     -14.442   1.664   6.041  1.00  1.00          
ATOM   1183  CB  ASN    72     -12.512   1.554   6.941  1.00  1.00          
ATOM   1184  HB1 ASN    72     -12.456   2.341   7.678  1.00  1.00          
ATOM   1185  HB2 ASN    72     -11.526   1.373   6.539  1.00  1.00          
ATOM   1186  CG  ASN    72     -12.988   0.287   7.626  1.00  1.00          
ATOM   1187  OD1 ASN    72     -12.934  -0.803   7.055  1.00  1.00          
ATOM   1188  ND2 ASN    72     -13.458   0.424   8.859  1.00  1.00          
ATOM   1189 HD21 ASN    72     -13.474   1.322   9.251  1.00  1.00          
ATOM   1190 HD22 ASN    72     -13.769  -0.379   9.327  1.00  1.00          
ATOM   1191  C   ASN    72     -13.448   3.544   5.718  1.00  1.00          
ATOM   1192  O   ASN    72     -14.280   4.182   6.390  1.00  1.00          
ATOM   1193  N   ASP    73     -12.524   4.111   4.883  1.00  1.00          
ATOM   1194  HN  ASP    73     -11.957   3.514   4.357  1.00  1.00          
ATOM   1195  CA  ASP    73     -12.367   5.571   4.687  1.00  1.00          
ATOM   1196  HA  ASP    73     -12.853   6.050   5.527  1.00  1.00          
ATOM   1197  CB  ASP    73     -10.859   5.931   4.724  1.00  1.00          
ATOM   1198  HB1 ASP    73     -10.475   5.915   3.716  1.00  1.00          
ATOM   1199  HB2 ASP    73     -10.336   5.195   5.314  1.00  1.00          
ATOM   1200  CG  ASP    73     -10.590   7.305   5.323  1.00  1.00          
ATOM   1201  OD1 ASP    73     -10.854   8.315   4.635  1.00  1.00          
ATOM   1202  OD2 ASP    73     -10.116   7.368   6.477  1.00  1.00          
ATOM   1203  C   ASP    73     -13.099   6.036   3.387  1.00  1.00          
ATOM   1204  O   ASP    73     -12.512   6.625   2.440  1.00  1.00          
ATOM   1205  N   PHE    74     -14.424   5.737   3.388  1.00  1.00          
ATOM   1206  HN  PHE    74     -14.759   5.233   4.154  1.00  1.00          
ATOM   1207  CA  PHE    74     -15.377   6.081   2.304  1.00  1.00          
ATOM   1208  HA  PHE    74     -14.812   6.156   1.388  1.00  1.00          
ATOM   1209  CB  PHE    74     -16.431   4.965   2.145  1.00  1.00          
ATOM   1210  HB1 PHE    74     -17.407   5.374   2.368  1.00  1.00          
ATOM   1211  HB2 PHE    74     -16.214   4.177   2.849  1.00  1.00          
ATOM   1212  CG  PHE    74     -16.497   4.340   0.761  1.00  1.00          
ATOM   1213  CD1 PHE    74     -15.668   3.275   0.408  1.00  1.00          
ATOM   1214  HD1 PHE    74     -14.959   2.895   1.129  1.00  1.00          
ATOM   1215  CD2 PHE    74     -17.401   4.812  -0.184  1.00  1.00          
ATOM   1216  HD2 PHE    74     -18.053   5.635   0.071  1.00  1.00          
ATOM   1217  CE1 PHE    74     -15.740   2.707  -0.849  1.00  1.00          
ATOM   1218  HE1 PHE    74     -15.090   1.884  -1.108  1.00  1.00          
ATOM   1219  CE2 PHE    74     -17.473   4.245  -1.443  1.00  1.00          
ATOM   1220  HE2 PHE    74     -18.179   4.624  -2.166  1.00  1.00          
ATOM   1221  CZ  PHE    74     -16.643   3.192  -1.774  1.00  1.00          
ATOM   1222  HZ  PHE    74     -16.700   2.748  -2.757  1.00  1.00          
ATOM   1223  C   PHE    74     -16.064   7.430   2.566  1.00  1.00          
ATOM   1224  O   PHE    74     -16.342   7.781   3.723  1.00  1.00          
ATOM   1225  N   LYS    75     -16.345   8.186   1.442  1.00  1.00          
ATOM   1226  HN  LYS    75     -16.106   7.786   0.580  1.00  1.00          
ATOM   1227  CA  LYS    75     -16.981   9.574   1.391  1.00  1.00          
ATOM   1228  HA  LYS    75     -17.230   9.733   0.349  1.00  1.00          
ATOM   1229  CB  LYS    75     -18.306   9.741   2.220  1.00  1.00          
ATOM   1230  HB1 LYS    75     -18.359  10.754   2.591  1.00  1.00          
ATOM   1231  HB2 LYS    75     -18.277   9.063   3.062  1.00  1.00          
ATOM   1232  CG  LYS    75     -19.570   9.455   1.426  1.00  1.00          
ATOM   1233  HG1 LYS    75     -19.478   8.486   0.959  1.00  1.00          
ATOM   1234  HG2 LYS    75     -19.687  10.215   0.667  1.00  1.00          
ATOM   1235  CD  LYS    75     -20.801   9.459   2.327  1.00  1.00          
ATOM   1236  HD1 LYS    75     -20.853  10.410   2.838  1.00  1.00          
ATOM   1237  HD2 LYS    75     -20.699   8.665   3.055  1.00  1.00          
ATOM   1238  CE  LYS    75     -22.093   9.254   1.530  1.00  1.00          
ATOM   1239  HE1 LYS    75     -22.855   8.851   2.184  1.00  1.00          
ATOM   1240  HE2 LYS    75     -21.897   8.551   0.734  1.00  1.00          
ATOM   1241  NZ  LYS    75     -22.595  10.528   0.935  1.00  1.00          
ATOM   1242  HZ1 LYS    75     -22.066  10.752   0.068  1.00  1.00          
ATOM   1243  HZ2 LYS    75     -22.473  11.309   1.612  1.00  1.00          
ATOM   1244  HZ3 LYS    75     -23.603  10.441   0.702  1.00  1.00          
ATOM   1245  C   LYS    75     -15.957  10.674   1.761  1.00  1.00          
ATOM   1246  O   LYS    75     -15.480  10.734   2.919  1.00  1.00          
ATOM   1247  N   GLY    76     -15.614  11.494   0.732  1.00  1.00          
ATOM   1248  HN  GLY    76     -16.034  11.341  -0.140  1.00  1.00          
ATOM   1249  CA  GLY    76     -14.651  12.595   0.866  1.00  1.00          
ATOM   1250  HA1 GLY    76     -13.866  12.287   1.541  1.00  1.00          
ATOM   1251  HA2 GLY    76     -15.157  13.450   1.290  1.00  1.00          
ATOM   1252  C   GLY    76     -14.025  12.999  -0.458  1.00  1.00          
ATOM   1253  O   GLY    76     -14.391  14.058  -1.005  1.00  1.00          
ATOM   1254  N   GLY    77     -13.089  12.142  -0.950  1.00  1.00          
ATOM   1255  HN  GLY    77     -12.885  11.334  -0.436  1.00  1.00          
ATOM   1256  CA  GLY    77     -12.365  12.375  -2.221  1.00  1.00          
ATOM   1257  HA1 GLY    77     -11.311  12.461  -1.997  1.00  1.00          
ATOM   1258  HA2 GLY    77     -12.700  13.311  -2.639  1.00  1.00          
ATOM   1259  C   GLY    77     -12.541  11.287  -3.285  1.00  1.00          
ATOM   1260  O   GLY    77     -11.601  11.072  -4.073  1.00  1.00          
ATOM   1261  N   ILE    78     -13.729  10.616  -3.301  1.00  1.00          
ATOM   1262  HN  ILE    78     -14.405  10.858  -2.636  1.00  1.00          
ATOM   1263  CA  ILE    78     -14.055   9.535  -4.278  1.00  1.00          
ATOM   1264  HA  ILE    78     -13.224   9.468  -4.971  1.00  1.00          
ATOM   1265  CB  ILE    78     -14.285   8.078  -3.623  1.00  1.00          
ATOM   1266  HB  ILE    78     -15.313   8.025  -3.295  1.00  1.00          
ATOM   1267  CG1 ILE    78     -13.357   7.776  -2.416  1.00  1.00          
ATOM   1268 HG11 ILE    78     -12.680   8.609  -2.276  1.00  1.00          
ATOM   1269 HG12 ILE    78     -12.785   6.885  -2.622  1.00  1.00          
ATOM   1270  CG2 ILE    78     -14.062   6.944  -4.653  1.00  1.00          
ATOM   1271 HG21 ILE    78     -14.611   7.167  -5.557  1.00  1.00          
ATOM   1272 HG22 ILE    78     -14.412   6.008  -4.242  1.00  1.00          
ATOM   1273 HG23 ILE    78     -13.009   6.865  -4.881  1.00  1.00          
ATOM   1274  CD1 ILE    78     -14.104   7.558  -1.118  1.00  1.00          
ATOM   1275 HD11 ILE    78     -14.678   8.442  -0.880  1.00  1.00          
ATOM   1276 HD12 ILE    78     -13.398   7.364  -0.324  1.00  1.00          
ATOM   1277 HD13 ILE    78     -14.770   6.714  -1.222  1.00  1.00          
ATOM   1278  C   ILE    78     -15.308   9.982  -5.069  1.00  1.00          
ATOM   1279  O   ILE    78     -16.370  10.216  -4.462  1.00  1.00          
ATOM   1280  N   ASP    79     -15.134  10.090  -6.412  1.00  1.00          
ATOM   1281  HN  ASP    79     -14.247   9.892  -6.779  1.00  1.00          
ATOM   1282  CA  ASP    79     -16.200  10.488  -7.355  1.00  1.00          
ATOM   1283  HA  ASP    79     -17.123  10.546  -6.796  1.00  1.00          
ATOM   1284  CB  ASP    79     -15.902  11.868  -7.968  1.00  1.00          
ATOM   1285  HB1 ASP    79     -16.448  11.965  -8.894  1.00  1.00          
ATOM   1286  HB2 ASP    79     -14.845  11.943  -8.171  1.00  1.00          
ATOM   1287  CG  ASP    79     -16.299  13.014  -7.052  1.00  1.00          
ATOM   1288  OD1 ASP    79     -15.392  13.678  -6.508  1.00  1.00          
ATOM   1289  OD2 ASP    79     -17.516  13.251  -6.884  1.00  1.00          
ATOM   1290  C   ASP    79     -16.367   9.439  -8.456  1.00  1.00          
ATOM   1291  O   ASP    79     -15.369   9.004  -9.067  1.00  1.00          
ATOM   1292  N   TRP    80     -17.649   9.026  -8.669  1.00  1.00          
ATOM   1293  HN  TRP    80     -18.351   9.424  -8.112  1.00  1.00          
ATOM   1294  CA  TRP    80     -18.065   8.009  -9.693  1.00  1.00          
ATOM   1295  HA  TRP    80     -17.284   7.264  -9.721  1.00  1.00          
ATOM   1296  CB  TRP    80     -19.368   7.313  -9.266  1.00  1.00          
ATOM   1297  HB1 TRP    80     -19.786   6.791 -10.114  1.00  1.00          
ATOM   1298  HB2 TRP    80     -20.071   8.058  -8.923  1.00  1.00          
ATOM   1299  CG  TRP    80     -19.169   6.307  -8.145  1.00  1.00          
ATOM   1300  CD1 TRP    80     -19.391   6.544  -6.819  1.00  1.00          
ATOM   1301  HD1 TRP    80     -19.745   7.485  -6.425  1.00  1.00          
ATOM   1302  CD2 TRP    80     -18.703   4.930  -8.229  1.00  1.00          
ATOM   1303  NE1 TRP    80     -19.095   5.430  -6.076  1.00  1.00          
ATOM   1304  HE1 TRP    80     -19.175   5.361  -5.101  1.00  1.00          
ATOM   1305  CE2 TRP    80     -18.674   4.429  -6.910  1.00  1.00          
ATOM   1306  CE3 TRP    80     -18.306   4.066  -9.277  1.00  1.00          
ATOM   1307  HE3 TRP    80     -18.313   4.397 -10.304  1.00  1.00          
ATOM   1308  CZ2 TRP    80     -18.271   3.129  -6.610  1.00  1.00          
ATOM   1309  HZ2 TRP    80     -18.253   2.759  -5.596  1.00  1.00          
ATOM   1310  CZ3 TRP    80     -17.909   2.777  -8.969  1.00  1.00          
ATOM   1311  HZ3 TRP    80     -17.604   2.102  -9.759  1.00  1.00          
ATOM   1312  CH2 TRP    80     -17.894   2.321  -7.647  1.00  1.00          
ATOM   1313  HH2 TRP    80     -17.575   1.308  -7.453  1.00  1.00          
ATOM   1314  C   TRP    80     -18.210   8.581 -11.130  1.00  1.00          
ATOM   1315  O   TRP    80     -17.950   7.851 -12.102  1.00  1.00          
ATOM   1316  N   GLU    81     -18.632   9.883 -11.229  1.00  1.00          
ATOM   1317  HN  GLU    81     -18.821  10.362 -10.396  1.00  1.00          
ATOM   1318  CA  GLU    81     -18.823  10.631 -12.519  1.00  1.00          
ATOM   1319  HA  GLU    81     -19.262   9.941 -13.225  1.00  1.00          
ATOM   1320  CB  GLU    81     -19.801  11.809 -12.323  1.00  1.00          
ATOM   1321  HB1 GLU    81     -19.668  12.505 -13.137  1.00  1.00          
ATOM   1322  HB2 GLU    81     -19.558  12.308 -11.397  1.00  1.00          
ATOM   1323  CG  GLU    81     -21.276  11.411 -12.273  1.00  1.00          
ATOM   1324  HG1 GLU    81     -21.414  10.696 -11.476  1.00  1.00          
ATOM   1325  HG2 GLU    81     -21.544  10.955 -13.215  1.00  1.00          
ATOM   1326  CD  GLU    81     -22.191  12.596 -12.029  1.00  1.00          
ATOM   1327  OE1 GLU    81     -22.409  12.944 -10.849  1.00  1.00          
ATOM   1328  OE2 GLU    81     -22.693  13.174 -13.017  1.00  1.00          
ATOM   1329  C   GLU    81     -17.492  11.159 -13.127  1.00  1.00          
ATOM   1330  O   GLU    81     -17.354  11.175 -14.364  1.00  1.00          
ATOM   1331  N   ASN    82     -16.547  11.581 -12.234  1.00  1.00          
ATOM   1332  HN  ASN    82     -16.764  11.528 -11.281  1.00  1.00          
ATOM   1333  CA  ASN    82     -15.209  12.112 -12.609  1.00  1.00          
ATOM   1334  HA  ASN    82     -15.290  12.507 -13.611  1.00  1.00          
ATOM   1335  CB  ASN    82     -14.834  13.262 -11.661  1.00  1.00          
ATOM   1336  HB1 ASN    82     -13.760  13.375 -11.649  1.00  1.00          
ATOM   1337  HB2 ASN    82     -15.177  13.023 -10.665  1.00  1.00          
ATOM   1338  CG  ASN    82     -15.451  14.585 -12.077  1.00  1.00          
ATOM   1339  OD1 ASN    82     -16.545  14.941 -11.636  1.00  1.00          
ATOM   1340  ND2 ASN    82     -14.753  15.321 -12.936  1.00  1.00          
ATOM   1341 HD21 ASN    82     -13.892  14.972 -13.249  1.00  1.00          
ATOM   1342 HD22 ASN    82     -15.129  16.179 -13.222  1.00  1.00          
ATOM   1343  C   ASN    82     -14.090  11.029 -12.597  1.00  1.00          
ATOM   1344  O   ASN    82     -13.014  11.254 -13.179  1.00  1.00          
ATOM   1345  N   LYS    83     -14.365   9.822 -11.944  1.00  1.00          
ATOM   1346  HN  LYS    83     -15.254   9.736 -11.541  1.00  1.00          
ATOM   1347  CA  LYS    83     -13.433   8.623 -11.790  1.00  1.00          
ATOM   1348  HA  LYS    83     -13.974   7.939 -11.145  1.00  1.00          
ATOM   1349  CB  LYS    83     -13.206   7.870 -13.151  1.00  1.00          
ATOM   1350  HB1 LYS    83     -12.300   7.286 -13.080  1.00  1.00          
ATOM   1351  HB2 LYS    83     -13.089   8.602 -13.935  1.00  1.00          
ATOM   1352  CG  LYS    83     -14.343   6.943 -13.540  1.00  1.00          
ATOM   1353  HG1 LYS    83     -15.259   7.512 -13.597  1.00  1.00          
ATOM   1354  HG2 LYS    83     -14.440   6.172 -12.788  1.00  1.00          
ATOM   1355  CD  LYS    83     -14.081   6.286 -14.884  1.00  1.00          
ATOM   1356  HD1 LYS    83     -13.142   5.753 -14.838  1.00  1.00          
ATOM   1357  HD2 LYS    83     -14.024   7.054 -15.642  1.00  1.00          
ATOM   1358  CE  LYS    83     -15.187   5.313 -15.253  1.00  1.00          
ATOM   1359  HE1 LYS    83     -16.123   5.849 -15.296  1.00  1.00          
ATOM   1360  HE2 LYS    83     -15.244   4.548 -14.492  1.00  1.00          
ATOM   1361  NZ  LYS    83     -14.938   4.664 -16.569  1.00  1.00          
ATOM   1362  HZ1 LYS    83     -13.954   4.827 -16.866  1.00  1.00          
ATOM   1363  HZ2 LYS    83     -15.576   5.060 -17.288  1.00  1.00          
ATOM   1364  HZ3 LYS    83     -15.103   3.640 -16.498  1.00  1.00          
ATOM   1365  C   LYS    83     -12.093   8.949 -11.022  1.00  1.00          
ATOM   1366  O   LYS    83     -10.958   8.649 -11.484  1.00  1.00          
ATOM   1367  N   ARG    84     -12.280   9.578  -9.829  1.00  1.00          
ATOM   1368  HN  ARG    84     -13.197   9.781  -9.556  1.00  1.00          
ATOM   1369  CA  ARG    84     -11.177   9.973  -8.915  1.00  1.00          
ATOM   1370  HA  ARG    84     -10.248   9.735  -9.415  1.00  1.00          
ATOM   1371  CB  ARG    84     -11.199  11.488  -8.602  1.00  1.00          
ATOM   1372  HB1 ARG    84     -10.545  11.673  -7.762  1.00  1.00          
ATOM   1373  HB2 ARG    84     -12.204  11.766  -8.325  1.00  1.00          
ATOM   1374  CG  ARG    84     -10.759  12.395  -9.761  1.00  1.00          
ATOM   1375  HG1 ARG    84     -11.394  12.192 -10.613  1.00  1.00          
ATOM   1376  HG2 ARG    84      -9.736  12.160 -10.014  1.00  1.00          
ATOM   1377  CD  ARG    84     -10.846  13.887  -9.411  1.00  1.00          
ATOM   1378  HD1 ARG    84     -11.771  14.060  -8.880  1.00  1.00          
ATOM   1379  HD2 ARG    84     -10.850  14.462 -10.328  1.00  1.00          
ATOM   1380  NE  ARG    84      -9.710  14.353  -8.562  1.00  1.00          
ATOM   1381  HE  ARG    84      -9.050  13.668  -8.321  1.00  1.00          
ATOM   1382  CZ  ARG    84      -9.489  15.622  -8.092  1.00  1.00          
ATOM   1383  NH1 ARG    84     -10.311  16.662  -8.334  1.00  1.00          
ATOM   1384 HH11 ARG    84     -11.137  16.530  -8.883  1.00  1.00          
ATOM   1385 HH12 ARG    84     -10.096  17.567  -7.966  1.00  1.00          
ATOM   1386  NH2 ARG    84      -8.407  15.842  -7.358  1.00  1.00          
ATOM   1387 HH21 ARG    84      -7.777  15.091  -7.158  1.00  1.00          
ATOM   1388 HH22 ARG    84      -8.220  16.759  -7.004  1.00  1.00          
ATOM   1389  C   ARG    84     -11.241   9.161  -7.617  1.00  1.00          
ATOM   1390  O   ARG    84     -12.313   9.074  -6.983  1.00  1.00          
ATOM   1391  N   VAL    85     -10.077   8.561  -7.263  1.00  1.00          
ATOM   1392  HN  VAL    85      -9.301   8.687  -7.846  1.00  1.00          
ATOM   1393  CA  VAL    85      -9.904   7.718  -6.039  1.00  1.00          
ATOM   1394  HA  VAL    85     -10.812   7.810  -5.456  1.00  1.00          
ATOM   1395  CB  VAL    85      -9.646   6.150  -6.330  1.00  1.00          
ATOM   1396  HB  VAL    85      -8.581   6.030  -6.499  1.00  1.00          
ATOM   1397  CG1 VAL    85     -10.035   5.258  -5.126  1.00  1.00          
ATOM   1398 HG11 VAL    85     -11.101   5.079  -5.142  1.00  1.00          
ATOM   1399 HG12 VAL    85      -9.770   5.759  -4.207  1.00  1.00          
ATOM   1400 HG13 VAL    85      -9.511   4.313  -5.184  1.00  1.00          
ATOM   1401  CG2 VAL    85     -10.393   5.597  -7.571  1.00  1.00          
ATOM   1402 HG21 VAL    85     -10.481   6.377  -8.314  1.00  1.00          
ATOM   1403 HG22 VAL    85     -11.379   5.269  -7.279  1.00  1.00          
ATOM   1404 HG23 VAL    85      -9.849   4.761  -7.991  1.00  1.00          
ATOM   1405  C   VAL    85      -8.733   8.306  -5.209  1.00  1.00          
ATOM   1406  O   VAL    85      -7.655   8.571  -5.773  1.00  1.00          
ATOM   1407  N   LYS    86      -8.991   8.498  -3.887  1.00  1.00          
ATOM   1408  HN  LYS    86      -9.890   8.294  -3.556  1.00  1.00          
ATOM   1409  CA  LYS    86      -8.000   9.027  -2.925  1.00  1.00          
ATOM   1410  HA  LYS    86      -7.071   9.173  -3.455  1.00  1.00          
ATOM   1411  CB  LYS    86      -8.473  10.381  -2.362  1.00  1.00          
ATOM   1412  HB1 LYS    86      -8.009  10.529  -1.398  1.00  1.00          
ATOM   1413  HB2 LYS    86      -9.545  10.332  -2.223  1.00  1.00          
ATOM   1414  CG  LYS    86      -8.139  11.597  -3.250  1.00  1.00          
ATOM   1415  HG1 LYS    86      -8.972  12.293  -3.242  1.00  1.00          
ATOM   1416  HG2 LYS    86      -7.974  11.254  -4.259  1.00  1.00          
ATOM   1417  CD  LYS    86      -6.886  12.335  -2.776  1.00  1.00          
ATOM   1418  HD1 LYS    86      -6.049  11.653  -2.800  1.00  1.00          
ATOM   1419  HD2 LYS    86      -7.043  12.682  -1.765  1.00  1.00          
ATOM   1420  CE  LYS    86      -6.575  13.533  -3.661  1.00  1.00          
ATOM   1421  HE1 LYS    86      -7.425  14.199  -3.653  1.00  1.00          
ATOM   1422  HE2 LYS    86      -6.402  13.184  -4.668  1.00  1.00          
ATOM   1423  NZ  LYS    86      -5.372  14.274  -3.191  1.00  1.00          
ATOM   1424  HZ1 LYS    86      -5.657  15.075  -2.592  1.00  1.00          
ATOM   1425  HZ2 LYS    86      -4.837  14.638  -4.005  1.00  1.00          
ATOM   1426  HZ3 LYS    86      -4.756  13.644  -2.640  1.00  1.00          
ATOM   1427  C   LYS    86      -7.759   8.043  -1.773  1.00  1.00          
ATOM   1428  O   LYS    86      -8.720   7.452  -1.243  1.00  1.00          
ATOM   1429  N   LEU    87      -6.457   7.890  -1.420  1.00  1.00          
ATOM   1430  HN  LEU    87      -5.788   8.401  -1.914  1.00  1.00          
ATOM   1431  CA  LEU    87      -5.975   7.022  -0.331  1.00  1.00          
ATOM   1432  HA  LEU    87      -6.839   6.619   0.176  1.00  1.00          
ATOM   1433  CB  LEU    87      -5.117   5.864  -0.882  1.00  1.00          
ATOM   1434  HB1 LEU    87      -4.350   5.647  -0.155  1.00  1.00          
ATOM   1435  HB2 LEU    87      -4.637   6.212  -1.785  1.00  1.00          
ATOM   1436  CG  LEU    87      -5.861   4.550  -1.208  1.00  1.00          
ATOM   1437  HG  LEU    87      -6.926   4.721  -1.180  1.00  1.00          
ATOM   1438  CD1 LEU    87      -5.511   4.050  -2.604  1.00  1.00          
ATOM   1439 HD11 LEU    87      -5.965   4.693  -3.341  1.00  1.00          
ATOM   1440 HD12 LEU    87      -5.887   3.044  -2.725  1.00  1.00          
ATOM   1441 HD13 LEU    87      -4.438   4.049  -2.733  1.00  1.00          
ATOM   1442  CD2 LEU    87      -5.525   3.478  -0.176  1.00  1.00          
ATOM   1443 HD21 LEU    87      -5.823   3.815   0.806  1.00  1.00          
ATOM   1444 HD22 LEU    87      -4.462   3.285  -0.184  1.00  1.00          
ATOM   1445 HD23 LEU    87      -6.051   2.566  -0.418  1.00  1.00          
ATOM   1446  C   LEU    87      -5.175   7.851   0.674  1.00  1.00          
ATOM   1447  O   LEU    87      -4.291   8.640   0.276  1.00  1.00          
ATOM   1448  N   LYS    88      -5.529   7.665   1.963  1.00  1.00          
ATOM   1449  HN  LYS    88      -6.253   7.036   2.148  1.00  1.00          
ATOM   1450  HA  LYS    88      -4.275   9.146   2.707  1.00  1.00          
ATOM   1451  CB  LYS    88      -5.962   8.982   4.017  1.00  1.00          
ATOM   1452  HB1 LYS    88      -5.562   9.062   5.017  1.00  1.00          
ATOM   1453  HB2 LYS    88      -6.824   8.332   4.036  1.00  1.00          
ATOM   1454  CG  LYS    88      -6.418  10.364   3.571  1.00  1.00          
ATOM   1455  HG1 LYS    88      -6.771  10.305   2.552  1.00  1.00          
ATOM   1456  HG2 LYS    88      -5.579  11.042   3.624  1.00  1.00          
ATOM   1457  CD  LYS    88      -7.543  10.896   4.457  1.00  1.00          
ATOM   1458  HD1 LYS    88      -7.194  10.910   5.482  1.00  1.00          
ATOM   1459  HD2 LYS    88      -8.391  10.233   4.375  1.00  1.00          
ATOM   1460  CE  LYS    88      -7.980  12.309   4.053  1.00  1.00          
ATOM   1461  HE1 LYS    88      -7.103  12.879   3.782  1.00  1.00          
ATOM   1462  HE2 LYS    88      -8.465  12.784   4.896  1.00  1.00          
ATOM   1463  NZ  LYS    88      -8.931  12.307   2.900  1.00  1.00          
ATOM   1464  HZ1 LYS    88      -8.916  11.381   2.426  1.00  1.00          
ATOM   1465  HZ2 LYS    88      -8.663  13.040   2.213  1.00  1.00          
ATOM   1466  HZ3 LYS    88      -9.898  12.499   3.233  1.00  1.00          
ATOM   1467  CA  LYS    88      -4.895   8.357   3.108  1.00  1.00          
ATOM   1468  C   LYS    88      -4.008   7.403   3.912  1.00  1.00          
ATOM   1469  OT1 LYS    88      -4.429   6.247   4.147  1.00  1.00          
ATOM   1470  OT2 LYS    88      -2.897   7.822   4.299  1.00  1.00          
END
