
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   83 (  707),  selected   83 , name 2a07_J
# Molecule2: number of CA atoms   87 ( 1451),  selected   87 , name T0476.pdb
# PARAMETERS: 2a07_J.T0476.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      A       2           -
LGA    -       -      K       3           -
LGA    -       -      C       4           -
LGA    I   502_J      P       5          2.970
LGA    V   503_J      I       6          3.685
LGA    R   504_J      C       7           -
LGA    -       -      G       8           -
LGA    -       -      S       9           -
LGA    P   505_J      P      10           #
LGA    P   506_J      -       -           -
LGA    F   507_J      L      11          4.754
LGA    T   508_J      K      12          1.865
LGA    Y   509_J      W      13          0.929
LGA    A   510_J      E      14          1.860
LGA    T   511_J      E      15          2.234
LGA    L   512_J      L      16          1.254
LGA    I   513_J      I      17          2.557
LGA    R   514_J      E      18          3.731
LGA    Q   515_J      E      19          3.745
LGA    A   516_J      M      20          3.823
LGA    I   517_J      L      21          4.459
LGA    M   518_J      I      22          3.308
LGA    E   519_J      I      23          2.018
LGA    S   520_J      E      24          3.943
LGA    S   521_J      N      25          3.085
LGA    D   522_J      F      26           #
LGA    R   523_J      E      27          3.143
LGA    Q   524_J      E      28          3.038
LGA    L   525_J      I      29          0.979
LGA    -       -      V      30           -
LGA    -       -      K      31           -
LGA    T   526_J      D      32          2.114
LGA    L   527_J      R      33          1.638
LGA    N   528_J      E      34          2.082
LGA    E   529_J      R      35          2.060
LGA    I   530_J      F      36          1.553
LGA    Y   531_J      L      37          1.358
LGA    S   532_J      A      38          2.518
LGA    W   533_J      Q      39          2.634
LGA    F   534_J      V      40          1.365
LGA    T   535_J      E      41          1.407
LGA    R   536_J      E      42          2.285
LGA    T   537_J      F      43          2.352
LGA    F   538_J      V      44          2.673
LGA    -       -      F      45           -
LGA    -       -      K      46           -
LGA    -       -      C      47           -
LGA    -       -      P      48           -
LGA    -       -      V      49           -
LGA    -       -      C      50           -
LGA    -       -      G      51           -
LGA    -       -      E      52           -
LGA    -       -      E      53           -
LGA    A   539_J      F      54          3.369
LGA    Y   540_J      Y      55          4.097
LGA    F   541_J      G      56          1.812
LGA    R   542_J      K      57          0.908
LGA    R   543_J      T      58          3.098
LGA    N   544_J      L      59          4.436
LGA    A   545_J      P      60          4.903
LGA    A   546_J      R      61          2.354
LGA    T   547_J      R      62          1.856
LGA    W   548_J      E      63          2.095
LGA    K   549_J      A      64          1.566
LGA    N   550_J      E      65          1.623
LGA    A   551_J      K      66          1.922
LGA    V   552_J      V      67          1.494
LGA    R   553_J      F      68          2.154
LGA    H   554_J      E      69          2.474
LGA    N   555_J      L      70          3.324
LGA    L   556_J      L      71          3.806
LGA    -       -      N      72           -
LGA    S   557_J      D      73          1.832
LGA    L   558_J      F      74           #
LGA    H   559_J      K      75           -
LGA    K   560_J      G      76          3.461
LGA    C   561_J      G      77          3.978
LGA    F   562_J      I      78          4.443
LGA    V   563_J      -       -           -
LGA    R   564_J      -       -           -
LGA    V   565_J      -       -           -
LGA    E   566_J      -       -           -
LGA    N   567_J      -       -           -
LGA    V   568_J      -       -           -
LGA    K   569_J      -       -           -
LGA    G   570_J      -       -           -
LGA    A   571_J      -       -           -
LGA    V   572_J      -       -           -
LGA    W   573_J      -       -           -
LGA    T   574_J      -       -           -
LGA    V   575_J      D      79           #
LGA    D   576_J      W      80          3.328
LGA    E   577_J      E      81          4.530
LGA    V   578_J      N      82          2.595
LGA    -       -      K      83           -
LGA    E   579_J      R      84          3.939
LGA    Y   580_J      V      85          3.411
LGA    Q   581_J      K      86           #
LGA    K   582_J      L      87           -
LGA    R   583_J      K      88           -
LGA    R   584_J      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   83   87    5.0     60    2.90    10.00     44.418     1.997

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.677249 * X  +  -0.081572 * Y  +   0.731218 * Z  + -44.135162
  Y_new =   0.404835 * X  +   0.871179 * Y  +  -0.277771 * Z  + -89.265358
  Z_new =  -0.614363 * X  +   0.484143 * Y  +   0.623028 * Z  + -46.403847 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.660608   -2.480984  [ DEG:    37.8501   -142.1499 ]
  Theta =   0.661578    2.480014  [ DEG:    37.9057    142.0943 ]
  Phi   =   0.538774   -2.602819  [ DEG:    30.8694   -149.1306 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2a07_J                                        
REMARK     2: T0476.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2a07_J.T0476.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   83   87   5.0   60   2.90   10.00  44.418
REMARK  ---------------------------------------------------------- 
MOLECULE 2a07_J
HEADER    TRANSCRIPTION/DNA                       16-JUN-05   2A07              
TITLE     CRYSTAL STRUCTURE OF FOXP2 BOUND SPECIFICALLY TO DNA.                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: FORKHEAD BOX PROTEIN P2;                                   
COMPND   3 CHAIN: F, G, H, I, J, K;                                             
COMPND   4 FRAGMENT: FOXP2 FORKHEAD DOMAIN;                                     
COMPND   5 SYNONYM: CAG REPEAT PROTEIN 44, TRINUCLEOTIDE REPEAT-                
COMPND   6 CONTAINING GENE 10 PROTEIN;                                          
COMPND   7 ENGINEERED: YES;                                                     
COMPND   8 MUTATION: YES;                                                       
COMPND   9 MOL_ID: 2;                                                           
COMPND  10 MOLECULE: 5'-                                                        
COMPND  11 D(*AP*AP*CP*TP*AP*TP*GP*AP*AP*AP*CP*AP*AP*AP*TP*TP*TP*TP*CP          
COMPND  12 *CP*T)-3';                                                           
COMPND  13 CHAIN: A, C;                                                         
COMPND  14 ENGINEERED: YES;                                                     
COMPND  15 OTHER_DETAILS: PROMOTER ELEMENT OF A FOXP REGULATED GENE,            
COMPND  16 PLUS STRAND;                                                         
COMPND  17 MOL_ID: 3;                                                           
COMPND  18 MOLECULE: 5'-                                                        
COMPND  19 D(*TP*TP*AP*GP*GP*AP*AP*AP*AP*TP*TP*TP*GP*TP*TP*TP*CP*AP*TP          
COMPND  20 *AP*G)-3';                                                           
COMPND  21 CHAIN: B, D;                                                         
COMPND  22 ENGINEERED: YES;                                                     
COMPND  23 OTHER_DETAILS: PROMOTER ELEMENT OF A FOXP REGULATED GENE,            
COMPND  24 MINUS STRAND                                                         
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: FOXP2, CAGH44, TNRC10;                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 MOL_ID: 2;                                                           
SOURCE   8 SYNTHETIC: YES;                                                      
SOURCE   9 OTHER_DETAILS: DNA IS SYNTHESIZED BY SOLID PHASE METHOD;             
SOURCE  10 MOL_ID: 3;                                                           
SOURCE  11 SYNTHETIC: YES;                                                      
SOURCE  12 OTHER_DETAILS: DNA IS SYNTHESIZED BY SOLID PHASE METHOD              
KEYWDS    FORKHEAD, DOUBLE-HELIX, SWAPPING, HOMODIMER, MONOMER,                 
KEYWDS   2 WINGED-HELIX, MAGNESIUM                                              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.C.STROUD,Y.WU,D.L.BATES,A.HAN,K.NOWICK,S.PAABO,H.TONG,              
AUTHOR   2 L.CHEN                                                               
REVDAT   1   31-JAN-06 2A07    0                                                
JRNL        AUTH   J.C.STROUD,Y.WU,D.L.BATES,A.HAN,K.NOWICK,S.PAABO,            
JRNL        AUTH 2 H.TONG,L.CHEN                                                
JRNL        TITL   STRUCTURE OF THE FORKHEAD DOMAIN OF FOXP2 BOUND TO           
JRNL        TITL 2 DNA.                                                         
JRNL        REF    STRUCTURE                     V.  14   159 2006              
JRNL        REFN   ASTM STRUE6  UK ISSN 0969-2126                               
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  2A07 F  502   594  UNP    O15409   FOXP2_HUMAN    502    594             
DBREF  2A07 G  502   594  UNP    O15409   FOXP2_HUMAN    502    594             
DBREF  2A07 H  502   594  UNP    O15409   FOXP2_HUMAN    502    594             
DBREF  2A07 I  502   594  UNP    O15409   FOXP2_HUMAN    502    594             
DBREF  2A07 J  502   594  UNP    O15409   FOXP2_HUMAN    502    594             
DBREF  2A07 K  502   594  UNP    O15409   FOXP2_HUMAN    502    594             
SEQRES   1 F   93  ILE VAL ARG PRO PRO PHE THR TYR ALA THR LEU ILE ARG          
SEQRES   2 F   93  GLN ALA ILE MET GLU SER SER ASP ARG GLN LEU THR LEU          
SEQRES   3 F   93  ASN GLU ILE TYR SER TRP PHE THR ARG THR PHE ALA TYR          
SEQRES   4 F   93  PHE ARG ARG ASN ALA ALA THR TRP LYS ASN ALA VAL ARG          
SEQRES   5 F   93  HIS ASN LEU SER LEU HIS LYS CYS PHE VAL ARG VAL GLU          
SEQRES   6 F   93  ASN VAL LYS GLY ALA VAL TRP THR VAL ASP GLU VAL GLU          
SEQRES   7 F   93  TYR GLN LYS ARG ARG SER GLN LYS ILE THR GLY SER PRO          
SEQRES   8 F   93  THR LEU                                                      
SEQRES   1 G   93  ILE VAL ARG PRO PRO PHE THR TYR ALA THR LEU ILE ARG          
SEQRES   2 G   93  GLN ALA ILE MET GLU SER SER ASP ARG GLN LEU THR LEU          
SEQRES   3 G   93  ASN GLU ILE TYR SER TRP PHE THR ARG THR PHE ALA TYR          
SEQRES   4 G   93  PHE ARG ARG ASN ALA ALA THR TRP LYS ASN ALA VAL ARG          
SEQRES   5 G   93  HIS ASN LEU SER LEU HIS LYS CYS PHE VAL ARG VAL GLU          
SEQRES   6 G   93  ASN VAL LYS GLY ALA VAL TRP THR VAL ASP GLU VAL GLU          
SEQRES   7 G   93  TYR GLN LYS ARG ARG SER GLN LYS ILE THR GLY SER PRO          
SEQRES   8 G   93  THR LEU                                                      
SEQRES   1 H   93  ILE VAL ARG PRO PRO PHE THR TYR ALA THR LEU ILE ARG          
SEQRES   2 H   93  GLN ALA ILE MET GLU SER SER ASP ARG GLN LEU THR LEU          
SEQRES   3 H   93  ASN GLU ILE TYR SER TRP PHE THR ARG THR PHE ALA TYR          
SEQRES   4 H   93  PHE ARG ARG ASN ALA ALA THR TRP LYS ASN ALA VAL ARG          
SEQRES   5 H   93  HIS ASN LEU SER LEU HIS LYS CYS PHE VAL ARG VAL GLU          
SEQRES   6 H   93  ASN VAL LYS GLY ALA VAL TRP THR VAL ASP GLU VAL GLU          
SEQRES   7 H   93  TYR GLN LYS ARG ARG SER GLN LYS ILE THR GLY SER PRO          
SEQRES   8 H   93  THR LEU                                                      
SEQRES   1 I   93  ILE VAL ARG PRO PRO PHE THR TYR ALA THR LEU ILE ARG          
SEQRES   2 I   93  GLN ALA ILE MET GLU SER SER ASP ARG GLN LEU THR LEU          
SEQRES   3 I   93  ASN GLU ILE TYR SER TRP PHE THR ARG THR PHE ALA TYR          
SEQRES   4 I   93  PHE ARG ARG ASN ALA ALA THR TRP LYS ASN ALA VAL ARG          
SEQRES   5 I   93  HIS ASN LEU SER LEU HIS LYS CYS PHE VAL ARG VAL GLU          
SEQRES   6 I   93  ASN VAL LYS GLY ALA VAL TRP THR VAL ASP GLU VAL GLU          
SEQRES   7 I   93  TYR GLN LYS ARG ARG SER GLN LYS ILE THR GLY SER PRO          
SEQRES   8 I   93  THR LEU                                                      
SEQRES   1 J   93  ILE VAL ARG PRO PRO PHE THR TYR ALA THR LEU ILE ARG          
SEQRES   2 J   93  GLN ALA ILE MET GLU SER SER ASP ARG GLN LEU THR LEU          
SEQRES   3 J   93  ASN GLU ILE TYR SER TRP PHE THR ARG THR PHE ALA TYR          
SEQRES   4 J   93  PHE ARG ARG ASN ALA ALA THR TRP LYS ASN ALA VAL ARG          
SEQRES   5 J   93  HIS ASN LEU SER LEU HIS LYS CYS PHE VAL ARG VAL GLU          
SEQRES   6 J   93  ASN VAL LYS GLY ALA VAL TRP THR VAL ASP GLU VAL GLU          
SEQRES   7 J   93  TYR GLN LYS ARG ARG SER GLN LYS ILE THR GLY SER PRO          
SEQRES   8 J   93  THR LEU                                                      
SEQRES   1 K   93  ILE VAL ARG PRO PRO PHE THR TYR ALA THR LEU ILE ARG          
SEQRES   2 K   93  GLN ALA ILE MET GLU SER SER ASP ARG GLN LEU THR LEU          
SEQRES   3 K   93  ASN GLU ILE TYR SER TRP PHE THR ARG THR PHE ALA TYR          
SEQRES   4 K   93  PHE ARG ARG ASN ALA ALA THR TRP LYS ASN ALA VAL ARG          
SEQRES   5 K   93  HIS ASN LEU SER LEU HIS LYS CYS PHE VAL ARG VAL GLU          
SEQRES   6 K   93  ASN VAL LYS GLY ALA VAL TRP THR VAL ASP GLU VAL GLU          
SEQRES   7 K   93  TYR GLN LYS ARG ARG SER GLN LYS ILE THR GLY SER PRO          
SEQRES   8 K   93  THR LEU                                                      
SEQRES   1 A   21   DA  DA  DC  DT  DA  DT  DG  DA  DA  DA  DC  DA  DA          
SEQRES   2 A   21   DA  DT  DT  DT  DT  DC  DC  DT                              
SEQRES   1 B   21   DT  DT  DA  DG  DG  DA  DA  DA  DA  DT  DT  DT  DG          
SEQRES   2 B   21   DT  DT  DT  DC  DA  DT  DA  DG                              
SEQRES   1 C   21   DA  DA  DC  DT  DA  DT  DG  DA  DA  DA  DC  DA  DA          
SEQRES   2 C   21   DA  DT  DT  DT  DT  DC  DC  DT                              
SEQRES   1 D   21   DT  DT  DA  DG  DG  DA  DA  DA  DA  DT  DT  DT  DG          
SEQRES   2 D   21   DT  DT  DT  DC  DA  DT  DA  DG                              
HET     MG    601       1                                                       
HET     MG    602       1                                                       
HET     MG    603       1                                                       
HET     MG    604       1                                                       
HET     MG    605       1                                                       
HET     MG    606       1                                                       
HETNAM      MG MAGNESIUM ION                                                    
FORMUL  11   MG    6(MG 2+)                                                     
FORMUL  17  HOH   *581(H2 O)                                                    
CRYST1   67.542  124.210   67.666  90.00 110.81  90.00 P 1 21 1     12          
ATOM   2740  N   ILE J 502       7.749 -13.175  -9.239  1.00 16.57           N  
ATOM   2741  CA  ILE J 502       6.422 -12.485  -9.141  1.00 18.03           C  
ATOM   2742  C   ILE J 502       6.645 -10.969  -9.161  1.00 19.31           C  
ATOM   2743  O   ILE J 502       7.540 -10.456  -8.490  1.00 18.85           O  
ATOM   2744  CB  ILE J 502       5.684 -12.920  -7.850  1.00 17.79           C  
ATOM   2745  CG1 ILE J 502       5.320 -14.404  -7.961  1.00 19.28           C  
ATOM   2746  CG2 ILE J 502       4.413 -12.083  -7.638  1.00 20.28           C  
ATOM   2747  CD1 ILE J 502       4.677 -14.993  -6.723  1.00 20.24           C  
ATOM   2748  N   VAL J 503       5.833 -10.266  -9.950  1.00 19.57           N  
ATOM   2749  CA  VAL J 503       5.944  -8.816 -10.104  1.00 21.87           C  
ATOM   2750  C   VAL J 503       4.648  -8.146  -9.645  1.00 20.57           C  
ATOM   2751  O   VAL J 503       3.563  -8.618  -9.974  1.00 18.80           O  
ATOM   2752  CB  VAL J 503       6.181  -8.439 -11.589  1.00 23.87           C  
ATOM   2753  CG1 VAL J 503       6.201  -6.926 -11.752  1.00 28.86           C  
ATOM   2754  CG2 VAL J 503       7.488  -9.040 -12.079  1.00 28.48           C  
ATOM   2755  N   ARG J 504       4.744  -7.067  -8.880  1.00 20.15           N  
ATOM   2756  CA  ARG J 504       3.511  -6.404  -8.467  1.00 21.12           C  
ATOM   2757  C   ARG J 504       3.029  -5.571  -9.646  1.00 19.58           C  
ATOM   2758  O   ARG J 504       3.829  -5.051 -10.421  1.00 18.54           O  
ATOM   2759  CB  ARG J 504       3.730  -5.508  -7.242  1.00 22.69           C  
ATOM   2760  CG  ARG J 504       4.327  -4.146  -7.532  1.00 24.08           C  
ATOM   2761  CD  ARG J 504       4.607  -3.423  -6.226  1.00 23.04           C  
ATOM   2762  NE  ARG J 504       3.395  -3.175  -5.451  1.00 23.79           N  
ATOM   2763  CZ  ARG J 504       3.388  -2.880  -4.154  1.00 24.28           C  
ATOM   2764  NH1 ARG J 504       4.536  -2.806  -3.489  1.00 23.28           N  
ATOM   2765  NH2 ARG J 504       2.240  -2.639  -3.525  1.00 24.95           N  
ATOM   2766  N   PRO J 505       1.712  -5.432  -9.798  1.00 20.34           N  
ATOM   2767  CA  PRO J 505       1.184  -4.643 -10.915  1.00 19.76           C  
ATOM   2768  C   PRO J 505       1.675  -3.204 -10.826  1.00 19.08           C  
ATOM   2769  O   PRO J 505       1.738  -2.632  -9.737  1.00 17.69           O  
ATOM   2770  CB  PRO J 505      -0.333  -4.732 -10.723  1.00 21.10           C  
ATOM   2771  CG  PRO J 505      -0.522  -5.942  -9.834  1.00 22.87           C  
ATOM   2772  CD  PRO J 505       0.630  -5.867  -8.899  1.00 21.40           C  
ATOM   2773  N   PRO J 506       2.014  -2.594 -11.971  1.00 19.64           N  
ATOM   2774  CA  PRO J 506       2.500  -1.216 -12.033  1.00 20.03           C  
ATOM   2775  C   PRO J 506       1.377  -0.183 -11.951  1.00 21.08           C  
ATOM   2776  O   PRO J 506       1.213   0.632 -12.857  1.00 21.16           O  
ATOM   2777  CB  PRO J 506       3.212  -1.171 -13.379  1.00 21.17           C  
ATOM   2778  CG  PRO J 506       2.345  -2.021 -14.221  1.00 19.64           C  
ATOM   2779  CD  PRO J 506       2.020  -3.205 -13.316  1.00 21.30           C  
ATOM   2780  N   PHE J 507       0.603  -0.228 -10.870  1.00 17.27           N  
ATOM   2781  CA  PHE J 507      -0.496   0.717 -10.668  1.00 17.99           C  
ATOM   2782  C   PHE J 507      -0.623   0.945  -9.170  1.00 16.81           C  
ATOM   2783  O   PHE J 507      -0.210   0.097  -8.382  1.00 15.87           O  
ATOM   2784  CB  PHE J 507      -1.822   0.150 -11.192  1.00 17.71           C  
ATOM   2785  CG  PHE J 507      -1.794  -0.226 -12.641  1.00 21.37           C  
ATOM   2786  CD1 PHE J 507      -1.649  -1.555 -13.023  1.00 22.14           C  
ATOM   2787  CD2 PHE J 507      -1.890   0.750 -13.627  1.00 23.09           C  
ATOM   2788  CE1 PHE J 507      -1.597  -1.912 -14.373  1.00 25.89           C  
ATOM   2789  CE2 PHE J 507      -1.839   0.410 -14.980  1.00 24.81           C  
ATOM   2790  CZ  PHE J 507      -1.692  -0.928 -15.353  1.00 27.20           C  
ATOM   2791  N   THR J 508      -1.190   2.080  -8.777  1.00 15.54           N  
ATOM   2792  CA  THR J 508      -1.364   2.370  -7.352  1.00 15.27           C  
ATOM   2793  C   THR J 508      -2.508   1.545  -6.779  1.00 13.95           C  
ATOM   2794  O   THR J 508      -3.326   0.988  -7.516  1.00 13.42           O  
ATOM   2795  CB  THR J 508      -1.736   3.845  -7.096  1.00 15.47           C  
ATOM   2796  OG1 THR J 508      -2.962   4.130  -7.778  1.00 14.19           O  
ATOM   2797  CG2 THR J 508      -0.626   4.789  -7.579  1.00 14.78           C  
ATOM   2798  N   TYR J 509      -2.580   1.483  -5.454  1.00 11.85           N  
ATOM   2799  CA  TYR J 509      -3.662   0.736  -4.823  1.00 12.97           C  
ATOM   2800  C   TYR J 509      -4.989   1.365  -5.213  1.00 12.13           C  
ATOM   2801  O   TYR J 509      -5.963   0.664  -5.484  1.00 13.11           O  
ATOM   2802  CB  TYR J 509      -3.497   0.731  -3.299  1.00 10.74           C  
ATOM   2803  CG  TYR J 509      -2.746  -0.490  -2.820  1.00 12.46           C  
ATOM   2804  CD1 TYR J 509      -1.411  -0.418  -2.421  1.00 14.06           C  
ATOM   2805  CD2 TYR J 509      -3.364  -1.741  -2.825  1.00 11.62           C  
ATOM   2806  CE1 TYR J 509      -0.708  -1.574  -2.044  1.00 14.50           C  
ATOM   2807  CE2 TYR J 509      -2.676  -2.885  -2.454  1.00 14.72           C  
ATOM   2808  CZ  TYR J 509      -1.352  -2.801  -2.071  1.00 16.01           C  
ATOM   2809  OH  TYR J 509      -0.680  -3.971  -1.767  1.00 15.54           O  
ATOM   2810  N   ALA J 510      -5.012   2.693  -5.250  1.00 12.76           N  
ATOM   2811  CA  ALA J 510      -6.225   3.419  -5.614  1.00 13.94           C  
ATOM   2812  C   ALA J 510      -6.681   3.011  -7.013  1.00 14.98           C  
ATOM   2813  O   ALA J 510      -7.852   2.711  -7.232  1.00 14.51           O  
ATOM   2814  CB  ALA J 510      -5.968   4.937  -5.553  1.00 15.43           C  
ATOM   2815  N   THR J 511      -5.753   2.983  -7.959  1.00 13.48           N  
ATOM   2816  CA  THR J 511      -6.106   2.615  -9.322  1.00 16.38           C  
ATOM   2817  C   THR J 511      -6.651   1.184  -9.408  1.00 15.15           C  
ATOM   2818  O   THR J 511      -7.644   0.927 -10.098  1.00 16.79           O  
ATOM   2819  CB  THR J 511      -4.885   2.806 -10.254  1.00 16.09           C  
ATOM   2820  OG1 THR J 511      -4.583   4.205 -10.340  1.00 16.90           O  
ATOM   2821  CG2 THR J 511      -5.173   2.276 -11.658  1.00 16.51           C  
ATOM   2822  N   LEU J 512      -6.006   0.265  -8.696  1.00 13.93           N  
ATOM   2823  CA  LEU J 512      -6.408  -1.146  -8.657  1.00 15.71           C  
ATOM   2824  C   LEU J 512      -7.789  -1.338  -8.031  1.00 15.73           C  
ATOM   2825  O   LEU J 512      -8.617  -2.112  -8.532  1.00 14.69           O  
ATOM   2826  CB  LEU J 512      -5.383  -1.949  -7.853  1.00 17.12           C  
ATOM   2827  CG  LEU J 512      -4.330  -2.804  -8.560  1.00 24.14           C  
ATOM   2828  CD1 LEU J 512      -3.935  -2.218  -9.891  1.00 25.28           C  
ATOM   2829  CD2 LEU J 512      -3.124  -2.947  -7.639  1.00 23.23           C  
ATOM   2830  N   ILE J 513      -8.030  -0.654  -6.916  1.00 15.32           N  
ATOM   2831  CA  ILE J 513      -9.317  -0.750  -6.240  1.00 15.64           C  
ATOM   2832  C   ILE J 513     -10.418  -0.220  -7.168  1.00 16.83           C  
ATOM   2833  O   ILE J 513     -11.487  -0.830  -7.311  1.00 15.13           O  
ATOM   2834  CB  ILE J 513      -9.306   0.060  -4.920  1.00 16.15           C  
ATOM   2835  CG1 ILE J 513      -8.299  -0.556  -3.942  1.00 14.89           C  
ATOM   2836  CG2 ILE J 513     -10.695   0.084  -4.306  1.00 15.92           C  
ATOM   2837  CD1 ILE J 513      -8.037   0.301  -2.704  1.00 16.51           C  
ATOM   2838  N   ARG J 514     -10.156   0.914  -7.803  1.00 17.96           N  
ATOM   2839  CA  ARG J 514     -11.138   1.503  -8.715  1.00 20.06           C  
ATOM   2840  C   ARG J 514     -11.430   0.522  -9.844  1.00 21.26           C  
ATOM   2841  O   ARG J 514     -12.584   0.361 -10.268  1.00 18.89           O  
ATOM   2842  CB  ARG J 514     -10.602   2.807  -9.306  1.00 22.52           C  
ATOM   2843  CG  ARG J 514     -11.365   3.294 -10.527  1.00 24.37           C  
ATOM   2844  CD  ARG J 514     -10.939   4.709 -10.880  1.00 30.91           C  
ATOM   2845  NE  ARG J 514     -11.608   5.242 -12.063  1.00 32.45           N  
ATOM   2846  CZ  ARG J 514     -11.274   4.947 -13.315  1.00 35.12           C  
ATOM   2847  NH1 ARG J 514     -10.270   4.113 -13.562  1.00 34.73           N  
ATOM   2848  NH2 ARG J 514     -11.942   5.497 -14.325  1.00 35.55           N  
ATOM   2849  N   GLN J 515     -10.378  -0.132 -10.329  1.00 19.99           N  
ATOM   2850  CA  GLN J 515     -10.529  -1.096 -11.415  1.00 20.53           C  
ATOM   2851  C   GLN J 515     -11.477  -2.209 -10.994  1.00 20.25           C  
ATOM   2852  O   GLN J 515     -12.410  -2.556 -11.736  1.00 19.79           O  
ATOM   2853  CB  GLN J 515      -9.172  -1.693 -11.798  1.00 20.99           C  
ATOM   2854  CG  GLN J 515      -9.198  -2.565 -13.039  1.00 25.60           C  
ATOM   2855  CD  GLN J 515      -9.644  -1.786 -14.288  1.00 29.50           C  
ATOM   2856  OE1 GLN J 515      -9.289  -0.631 -14.470  1.00 29.45           O  
ATOM   2857  NE2 GLN J 515     -10.412  -2.432 -15.147  1.00 30.90           N  
ATOM   2858  N   ALA J 516     -11.235  -2.769  -9.810  1.00 17.69           N  
ATOM   2859  CA  ALA J 516     -12.071  -3.839  -9.277  1.00 18.69           C  
ATOM   2860  C   ALA J 516     -13.539  -3.428  -9.257  1.00 20.12           C  
ATOM   2861  O   ALA J 516     -14.405  -4.159  -9.739  1.00 20.24           O  
ATOM   2862  CB  ALA J 516     -11.626  -4.206  -7.855  1.00 16.17           C  
ATOM   2863  N   ILE J 517     -13.818  -2.270  -8.675  1.00 18.87           N  
ATOM   2864  CA  ILE J 517     -15.186  -1.782  -8.582  1.00 20.17           C  
ATOM   2865  C   ILE J 517     -15.807  -1.481  -9.951  1.00 22.20           C  
ATOM   2866  O   ILE J 517     -16.965  -1.826 -10.205  1.00 23.09           O  
ATOM   2867  CB  ILE J 517     -15.240  -0.513  -7.713  1.00 19.93           C  
ATOM   2868  CG1 ILE J 517     -14.785  -0.851  -6.291  1.00 19.69           C  
ATOM   2869  CG2 ILE J 517     -16.649   0.075  -7.717  1.00 20.88           C  
ATOM   2870  CD1 ILE J 517     -14.624   0.367  -5.399  1.00 21.32           C  
ATOM   2871  N   MET J 518     -15.046  -0.836 -10.827  1.00 23.25           N  
ATOM   2872  CA  MET J 518     -15.554  -0.498 -12.146  1.00 27.01           C  
ATOM   2873  C   MET J 518     -15.911  -1.738 -12.955  1.00 27.68           C  
ATOM   2874  O   MET J 518     -16.812  -1.694 -13.791  1.00 28.09           O  
ATOM   2875  CB  MET J 518     -14.534   0.347 -12.916  1.00 29.48           C  
ATOM   2876  CG  MET J 518     -14.328   1.744 -12.351  1.00 34.44           C  
ATOM   2877  SD  MET J 518     -15.838   2.743 -12.383  1.00 45.14           S  
ATOM   2878  CE  MET J 518     -15.558   3.730 -13.855  1.00 39.89           C  
ATOM   2879  N   GLU J 519     -15.217  -2.844 -12.702  1.00 26.34           N  
ATOM   2880  CA  GLU J 519     -15.475  -4.082 -13.434  1.00 25.95           C  
ATOM   2881  C   GLU J 519     -16.670  -4.864 -12.910  1.00 26.64           C  
ATOM   2882  O   GLU J 519     -17.144  -5.794 -13.565  1.00 26.45           O  
ATOM   2883  CB  GLU J 519     -14.234  -4.987 -13.408  1.00 24.86           C  
ATOM   2884  CG  GLU J 519     -13.065  -4.433 -14.189  1.00 24.58           C  
ATOM   2885  CD  GLU J 519     -11.885  -5.389 -14.253  1.00 23.94           C  
ATOM   2886  OE1 GLU J 519     -10.882  -5.023 -14.890  1.00 24.88           O  
ATOM   2887  OE2 GLU J 519     -11.958  -6.493 -13.673  1.00 26.36           O  
ATOM   2888  N   SER J 520     -17.159  -4.502 -11.729  1.00 23.97           N  
ATOM   2889  CA  SER J 520     -18.293  -5.218 -11.156  1.00 25.03           C  
ATOM   2890  C   SER J 520     -19.575  -4.803 -11.880  1.00 24.85           C  
ATOM   2891  O   SER J 520     -19.702  -3.665 -12.330  1.00 24.39           O  
ATOM   2892  CB  SER J 520     -18.406  -4.928  -9.656  1.00 24.32           C  
ATOM   2893  OG  SER J 520     -18.571  -3.544  -9.426  1.00 25.15           O  
ATOM   2894  N   SER J 521     -20.522  -5.727 -11.979  1.00 26.88           N  
ATOM   2895  CA  SER J 521     -21.783  -5.469 -12.675  1.00 29.72           C  
ATOM   2896  C   SER J 521     -22.607  -4.275 -12.165  1.00 29.53           C  
ATOM   2897  O   SER J 521     -23.270  -3.596 -12.949  1.00 30.56           O  
ATOM   2898  CB  SER J 521     -22.643  -6.737 -12.652  1.00 31.18           C  
ATOM   2899  OG  SER J 521     -22.893  -7.168 -11.326  1.00 35.06           O  
ATOM   2900  N   ASP J 522     -22.558  -4.021 -10.860  1.00 28.30           N  
ATOM   2901  CA  ASP J 522     -23.319  -2.928 -10.250  1.00 27.41           C  
ATOM   2902  C   ASP J 522     -22.411  -1.816  -9.727  1.00 27.07           C  
ATOM   2903  O   ASP J 522     -22.838  -0.979  -8.934  1.00 25.99           O  
ATOM   2904  CB  ASP J 522     -24.154  -3.472  -9.091  1.00 29.17           C  
ATOM   2905  CG  ASP J 522     -25.149  -4.523  -9.535  1.00 31.42           C  
ATOM   2906  OD1 ASP J 522     -25.384  -5.485  -8.769  1.00 32.93           O  
ATOM   2907  OD2 ASP J 522     -25.705  -4.376 -10.645  1.00 31.58           O  
ATOM   2908  N   ARG J 523     -21.161  -1.810 -10.177  1.00 25.75           N  
ATOM   2909  CA  ARG J 523     -20.190  -0.807  -9.739  1.00 25.85           C  
ATOM   2910  C   ARG J 523     -20.155  -0.674  -8.217  1.00 23.56           C  
ATOM   2911  O   ARG J 523     -20.200   0.431  -7.675  1.00 22.03           O  
ATOM   2912  CB  ARG J 523     -20.494   0.556 -10.369  1.00 30.85           C  
ATOM   2913  CG  ARG J 523     -19.997   0.716 -11.796  1.00 37.82           C  
ATOM   2914  CD  ARG J 523     -20.107   2.166 -12.236  1.00 45.30           C  
ATOM   2915  NE  ARG J 523     -19.467   3.066 -11.278  1.00 50.65           N  
ATOM   2916  CZ  ARG J 523     -19.433   4.391 -11.395  1.00 54.09           C  
ATOM   2917  NH1 ARG J 523     -20.003   4.985 -12.437  1.00 54.94           N  
ATOM   2918  NH2 ARG J 523     -18.835   5.126 -10.465  1.00 54.29           N  
ATOM   2919  N   GLN J 524     -20.063  -1.814  -7.542  1.00 21.97           N  
ATOM   2920  CA  GLN J 524     -19.995  -1.866  -6.090  1.00 21.04           C  
ATOM   2921  C   GLN J 524     -19.485  -3.229  -5.668  1.00 21.20           C  
ATOM   2922  O   GLN J 524     -19.822  -4.249  -6.284  1.00 21.13           O  
ATOM   2923  CB  GLN J 524     -21.375  -1.634  -5.463  1.00 22.38           C  
ATOM   2924  CG  GLN J 524     -22.445  -2.598  -5.955  1.00 22.21           C  
ATOM   2925  CD  GLN J 524     -23.740  -2.490  -5.158  1.00 25.75           C  
ATOM   2926  OE1 GLN J 524     -24.107  -1.411  -4.685  1.00 22.77           O  
ATOM   2927  NE2 GLN J 524     -24.441  -3.611  -5.018  1.00 24.61           N  
ATOM   2928  N   LEU J 525     -18.679  -3.248  -4.614  1.00 18.36           N  
ATOM   2929  CA  LEU J 525     -18.119  -4.491  -4.090  1.00 18.01           C  
ATOM   2930  C   LEU J 525     -17.920  -4.399  -2.588  1.00 17.36           C  
ATOM   2931  O   LEU J 525     -17.569  -3.342  -2.065  1.00 16.72           O  
ATOM   2932  CB  LEU J 525     -16.752  -4.787  -4.720  1.00 14.31           C  
ATOM   2933  CG  LEU J 525     -16.595  -5.219  -6.179  1.00 18.24           C  
ATOM   2934  CD1 LEU J 525     -15.082  -5.382  -6.452  1.00 17.95           C  
ATOM   2935  CD2 LEU J 525     -17.320  -6.550  -6.443  1.00 15.88           C  
ATOM   2936  N   THR J 526     -18.151  -5.503  -1.890  1.00 16.37           N  
ATOM   2937  CA  THR J 526     -17.917  -5.533  -0.454  1.00 16.59           C  
ATOM   2938  C   THR J 526     -16.396  -5.613  -0.311  1.00 17.49           C  
ATOM   2939  O   THR J 526     -15.684  -5.897  -1.287  1.00 13.51           O  
ATOM   2940  CB  THR J 526     -18.497  -6.789   0.208  1.00 18.67           C  
ATOM   2941  OG1 THR J 526     -17.838  -7.949  -0.317  1.00 17.35           O  
ATOM   2942  CG2 THR J 526     -19.993  -6.895  -0.051  1.00 19.31           C  
ATOM   2943  N   LEU J 527     -15.893  -5.386   0.898  1.00 16.01           N  
ATOM   2944  CA  LEU J 527     -14.445  -5.463   1.118  1.00 16.52           C  
ATOM   2945  C   LEU J 527     -13.898  -6.845   0.729  1.00 16.83           C  
ATOM   2946  O   LEU J 527     -12.888  -6.949   0.034  1.00 14.08           O  
ATOM   2947  CB  LEU J 527     -14.115  -5.180   2.589  1.00 14.72           C  
ATOM   2948  CG  LEU J 527     -12.644  -5.347   2.993  1.00 13.48           C  
ATOM   2949  CD1 LEU J 527     -11.784  -4.344   2.240  1.00 12.38           C  
ATOM   2950  CD2 LEU J 527     -12.499  -5.143   4.500  1.00 16.11           C  
ATOM   2951  N   ASN J 528     -14.575  -7.908   1.156  1.00 17.22           N  
ATOM   2952  CA  ASN J 528     -14.099  -9.250   0.837  1.00 18.34           C  
ATOM   2953  C   ASN J 528     -14.086  -9.537  -0.660  1.00 18.69           C  
ATOM   2954  O   ASN J 528     -13.234 -10.285  -1.145  1.00 17.73           O  
ATOM   2955  CB  ASN J 528     -14.925 -10.313   1.560  1.00 21.59           C  
ATOM   2956  CG  ASN J 528     -14.236 -11.662   1.568  1.00 24.59           C  
ATOM   2957  OD1 ASN J 528     -14.772 -12.656   1.067  1.00 26.03           O  
ATOM   2958  ND2 ASN J 528     -13.033 -11.702   2.133  1.00 21.03           N  
ATOM   2959  N   GLU J 529     -15.033  -8.955  -1.390  1.00 17.79           N  
ATOM   2960  CA  GLU J 529     -15.105  -9.128  -2.840  1.00 18.55           C  
ATOM   2961  C   GLU J 529     -13.917  -8.412  -3.477  1.00 18.11           C  
ATOM   2962  O   GLU J 529     -13.368  -8.863  -4.491  1.00 14.87           O  
ATOM   2963  CB  GLU J 529     -16.427  -8.565  -3.381  1.00 20.03           C  
ATOM   2964  CG  GLU J 529     -17.623  -9.490  -3.144  1.00 20.80           C  
ATOM   2965  CD  GLU J 529     -18.958  -8.871  -3.543  1.00 25.93           C  
ATOM   2966  OE1 GLU J 529     -19.903  -9.651  -3.804  1.00 28.53           O  
ATOM   2967  OE2 GLU J 529     -19.079  -7.620  -3.589  1.00 23.22           O  
ATOM   2968  N   ILE J 530     -13.510  -7.292  -2.877  1.00 15.24           N  
ATOM   2969  CA  ILE J 530     -12.357  -6.570  -3.400  1.00 14.28           C  
ATOM   2970  C   ILE J 530     -11.091  -7.405  -3.159  1.00 13.63           C  
ATOM   2971  O   ILE J 530     -10.236  -7.498  -4.045  1.00 14.65           O  
ATOM   2972  CB  ILE J 530     -12.224  -5.172  -2.752  1.00 15.65           C  
ATOM   2973  CG1 ILE J 530     -13.354  -4.277  -3.274  1.00 14.63           C  
ATOM   2974  CG2 ILE J 530     -10.871  -4.548  -3.095  1.00 12.52           C  
ATOM   2975  CD1 ILE J 530     -13.522  -2.965  -2.501  1.00 20.26           C  
ATOM   2976  N   TYR J 531     -10.966  -8.001  -1.975  1.00 12.05           N  
ATOM   2977  CA  TYR J 531      -9.816  -8.868  -1.684  1.00 14.34           C  
ATOM   2978  C   TYR J 531      -9.779  -9.983  -2.744  1.00 15.18           C  
ATOM   2979  O   TYR J 531      -8.736 -10.276  -3.342  1.00 13.20           O  
ATOM   2980  CB  TYR J 531      -9.969  -9.551  -0.320  1.00 13.23           C  
ATOM   2981  CG  TYR J 531      -9.832  -8.695   0.929  1.00 13.33           C  
ATOM   2982  CD1 TYR J 531     -10.333  -9.154   2.151  1.00 12.73           C  
ATOM   2983  CD2 TYR J 531      -9.177  -7.464   0.910  1.00 13.77           C  
ATOM   2984  CE1 TYR J 531     -10.185  -8.408   3.330  1.00 14.82           C  
ATOM   2985  CE2 TYR J 531      -9.017  -6.706   2.095  1.00 14.79           C  
ATOM   2986  CZ  TYR J 531      -9.524  -7.190   3.294  1.00 14.27           C  
ATOM   2987  OH  TYR J 531      -9.363  -6.474   4.466  1.00 14.41           O  
ATOM   2988  N   SER J 532     -10.932 -10.607  -2.976  1.00 15.54           N  
ATOM   2989  CA  SER J 532     -11.002 -11.698  -3.956  1.00 16.79           C  
ATOM   2990  C   SER J 532     -10.533 -11.296  -5.347  1.00 17.48           C  
ATOM   2991  O   SER J 532      -9.881 -12.093  -6.025  1.00 19.01           O  
ATOM   2992  CB  SER J 532     -12.423 -12.257  -4.038  1.00 16.71           C  
ATOM   2993  OG  SER J 532     -12.792 -12.815  -2.793  1.00 19.25           O  
ATOM   2994  N   TRP J 533     -10.867 -10.074  -5.775  1.00 15.97           N  
ATOM   2995  CA  TRP J 533     -10.460  -9.579  -7.090  1.00 15.28           C  
ATOM   2996  C   TRP J 533      -8.934  -9.475  -7.147  1.00 16.93           C  
ATOM   2997  O   TRP J 533      -8.312  -9.833  -8.146  1.00 16.24           O  
ATOM   2998  CB  TRP J 533     -11.064  -8.198  -7.362  1.00 16.11           C  
ATOM   2999  CG  TRP J 533     -10.735  -7.645  -8.725  1.00 17.31           C  
ATOM   3000  CD1 TRP J 533     -11.445  -7.832  -9.882  1.00 18.64           C  
ATOM   3001  CD2 TRP J 533      -9.629  -6.797  -9.069  1.00 17.24           C  
ATOM   3002  NE1 TRP J 533     -10.853  -7.149 -10.913  1.00 18.72           N  
ATOM   3003  CE2 TRP J 533      -9.737  -6.508 -10.442  1.00 18.40           C  
ATOM   3004  CE3 TRP J 533      -8.557  -6.251  -8.345  1.00 16.26           C  
ATOM   3005  CZ2 TRP J 533      -8.811  -5.696 -11.112  1.00 19.38           C  
ATOM   3006  CZ3 TRP J 533      -7.642  -5.442  -9.011  1.00 15.90           C  
ATOM   3007  CH2 TRP J 533      -7.771  -5.173 -10.375  1.00 16.82           C  
ATOM   3008  N   PHE J 534      -8.338  -8.954  -6.076  1.00 16.55           N  
ATOM   3009  CA  PHE J 534      -6.882  -8.829  -6.007  1.00 16.31           C  
ATOM   3010  C   PHE J 534      -6.189 -10.191  -6.121  1.00 16.17           C  
ATOM   3011  O   PHE J 534      -5.283 -10.364  -6.936  1.00 17.13           O  
ATOM   3012  CB  PHE J 534      -6.471  -8.161  -4.686  1.00 14.53           C  
ATOM   3013  CG  PHE J 534      -6.432  -6.654  -4.752  1.00 15.16           C  
ATOM   3014  CD1 PHE J 534      -5.211  -5.981  -4.786  1.00 17.03           C  
ATOM   3015  CD2 PHE J 534      -7.609  -5.909  -4.798  1.00 14.26           C  
ATOM   3016  CE1 PHE J 534      -5.157  -4.574  -4.866  1.00 15.21           C  
ATOM   3017  CE2 PHE J 534      -7.570  -4.509  -4.877  1.00 13.32           C  
ATOM   3018  CZ  PHE J 534      -6.349  -3.839  -4.912  1.00 14.97           C  
ATOM   3019  N   THR J 535      -6.616 -11.162  -5.322  1.00 16.61           N  
ATOM   3020  CA  THR J 535      -5.967 -12.474  -5.349  1.00 19.12           C  
ATOM   3021  C   THR J 535      -6.195 -13.239  -6.648  1.00 19.72           C  
ATOM   3022  O   THR J 535      -5.303 -13.952  -7.130  1.00 18.94           O  
ATOM   3023  CB  THR J 535      -6.416 -13.356  -4.164  1.00 21.14           C  
ATOM   3024  OG1 THR J 535      -7.779 -13.745  -4.346  1.00 23.69           O  
ATOM   3025  CG2 THR J 535      -6.290 -12.600  -2.856  1.00 18.95           C  
ATOM   3026  N   ARG J 536      -7.384 -13.099  -7.219  1.00 20.39           N  
ATOM   3027  CA  ARG J 536      -7.719 -13.782  -8.467  1.00 21.31           C  
ATOM   3028  C   ARG J 536      -6.962 -13.204  -9.659  1.00 21.02           C  
ATOM   3029  O   ARG J 536      -6.561 -13.926 -10.580  1.00 21.28           O  
ATOM   3030  CB  ARG J 536      -9.226 -13.649  -8.716  1.00 24.01           C  
ATOM   3031  CG  ARG J 536      -9.690 -13.949 -10.126  1.00 29.92           C  
ATOM   3032  CD  ARG J 536     -11.013 -13.224 -10.409  1.00 31.04           C  
ATOM   3033  NE  ARG J 536     -11.842 -13.191  -9.211  1.00 31.40           N  
ATOM   3034  CZ  ARG J 536     -12.732 -12.243  -8.931  1.00 29.56           C  
ATOM   3035  NH1 ARG J 536     -12.932 -11.232  -9.765  1.00 30.58           N  
ATOM   3036  NH2 ARG J 536     -13.406 -12.301  -7.799  1.00 27.44           N  
ATOM   3037  N   THR J 537      -6.734 -11.901  -9.615  1.00 17.01           N  
ATOM   3038  CA  THR J 537      -6.108 -11.204 -10.720  1.00 17.11           C  
ATOM   3039  C   THR J 537      -4.594 -11.205 -10.796  1.00 19.03           C  
ATOM   3040  O   THR J 537      -4.041 -11.282 -11.892  1.00 18.84           O  
ATOM   3041  CB  THR J 537      -6.617  -9.762 -10.746  1.00 17.05           C  
ATOM   3042  OG1 THR J 537      -8.048  -9.795 -10.729  1.00 17.38           O  
ATOM   3043  CG2 THR J 537      -6.150  -9.030 -12.006  1.00 17.81           C  
ATOM   3044  N   PHE J 538      -3.915 -11.116  -9.656  1.00 16.10           N  
ATOM   3045  CA  PHE J 538      -2.451 -11.089  -9.684  1.00 17.17           C  
ATOM   3046  C   PHE J 538      -1.790 -12.010  -8.681  1.00 15.82           C  
ATOM   3047  O   PHE J 538      -2.193 -12.074  -7.520  1.00 15.45           O  
ATOM   3048  CB  PHE J 538      -1.916  -9.680  -9.418  1.00 16.97           C  
ATOM   3049  CG  PHE J 538      -2.616  -8.601 -10.180  1.00 17.71           C  
ATOM   3050  CD1 PHE J 538      -3.699  -7.927  -9.621  1.00 16.93           C  
ATOM   3051  CD2 PHE J 538      -2.180  -8.235 -11.451  1.00 18.77           C  
ATOM   3052  CE1 PHE J 538      -4.337  -6.899 -10.319  1.00 15.21           C  
ATOM   3053  CE2 PHE J 538      -2.813  -7.211 -12.157  1.00 17.83           C  
ATOM   3054  CZ  PHE J 538      -3.894  -6.541 -11.587  1.00 19.28           C  
ATOM   3055  N   ALA J 539      -0.736 -12.690  -9.129  1.00 13.80           N  
ATOM   3056  CA  ALA J 539       0.014 -13.607  -8.274  1.00 13.67           C  
ATOM   3057  C   ALA J 539       0.567 -12.877  -7.055  1.00 11.18           C  
ATOM   3058  O   ALA J 539       0.642 -13.443  -5.968  1.00 13.27           O  
ATOM   3059  CB  ALA J 539       1.185 -14.238  -9.078  1.00 12.85           C  
ATOM   3060  N   TYR J 540       0.963 -11.627  -7.247  1.00 13.21           N  
ATOM   3061  CA  TYR J 540       1.528 -10.817  -6.162  1.00 14.05           C  
ATOM   3062  C   TYR J 540       0.648 -10.814  -4.921  1.00 13.05           C  
ATOM   3063  O   TYR J 540       1.156 -10.826  -3.792  1.00 12.15           O  
ATOM   3064  CB  TYR J 540       1.742  -9.372  -6.638  1.00 13.45           C  
ATOM   3065  CG  TYR J 540       2.335  -8.443  -5.590  1.00 16.42           C  
ATOM   3066  CD1 TYR J 540       3.696  -8.489  -5.278  1.00 17.85           C  
ATOM   3067  CD2 TYR J 540       1.536  -7.510  -4.915  1.00 16.04           C  
ATOM   3068  CE1 TYR J 540       4.254  -7.630  -4.325  1.00 19.48           C  
ATOM   3069  CE2 TYR J 540       2.090  -6.637  -3.954  1.00 18.07           C  
ATOM   3070  CZ  TYR J 540       3.445  -6.704  -3.670  1.00 19.93           C  
ATOM   3071  OH  TYR J 540       4.024  -5.836  -2.761  1.00 20.88           O  
ATOM   3072  N   PHE J 541      -0.669 -10.805  -5.114  1.00 12.31           N  
ATOM   3073  CA  PHE J 541      -1.570 -10.767  -3.969  1.00 13.34           C  
ATOM   3074  C   PHE J 541      -1.960 -12.123  -3.392  1.00 16.44           C  
ATOM   3075  O   PHE J 541      -2.897 -12.225  -2.594  1.00 17.51           O  
ATOM   3076  CB  PHE J 541      -2.814  -9.928  -4.314  1.00 11.64           C  
ATOM   3077  CG  PHE J 541      -2.482  -8.507  -4.685  1.00 11.96           C  
ATOM   3078  CD1 PHE J 541      -2.609  -8.072  -5.992  1.00 12.41           C  
ATOM   3079  CD2 PHE J 541      -1.960  -7.631  -3.733  1.00 12.64           C  
ATOM   3080  CE1 PHE J 541      -2.221  -6.796  -6.361  1.00 14.19           C  
ATOM   3081  CE2 PHE J 541      -1.561  -6.334  -4.089  1.00 11.20           C  
ATOM   3082  CZ  PHE J 541      -1.691  -5.918  -5.400  1.00 12.73           C  
ATOM   3083  N   ARG J 542      -1.240 -13.169  -3.781  1.00 17.62           N  
ATOM   3084  CA  ARG J 542      -1.513 -14.487  -3.234  1.00 18.98           C  
ATOM   3085  C   ARG J 542      -0.548 -14.818  -2.097  1.00 19.64           C  
ATOM   3086  O   ARG J 542      -0.301 -15.981  -1.801  1.00 20.46           O  
ATOM   3087  CB  ARG J 542      -1.445 -15.557  -4.330  1.00 20.51           C  
ATOM   3088  CG  ARG J 542      -2.654 -15.521  -5.244  1.00 21.11           C  
ATOM   3089  CD  ARG J 542      -2.467 -16.365  -6.508  1.00 25.44           C  
ATOM   3090  NE  ARG J 542      -3.235 -15.738  -7.573  1.00 26.70           N  
ATOM   3091  CZ  ARG J 542      -2.920 -15.760  -8.855  1.00 25.02           C  
ATOM   3092  NH1 ARG J 542      -1.835 -16.405  -9.278  1.00 21.78           N  
ATOM   3093  NH2 ARG J 542      -3.671 -15.081  -9.710  1.00 27.26           N  
ATOM   3094  N   ARG J 543       0.014 -13.780  -1.481  1.00 17.73           N  
ATOM   3095  CA  ARG J 543       0.910 -13.949  -0.346  1.00 18.03           C  
ATOM   3096  C   ARG J 543       0.958 -12.648   0.441  1.00 18.38           C  
ATOM   3097  O   ARG J 543       0.552 -11.599  -0.066  1.00 18.00           O  
ATOM   3098  CB  ARG J 543       2.327 -14.321  -0.804  1.00 21.45           C  
ATOM   3099  CG  ARG J 543       2.986 -13.306  -1.726  1.00 23.34           C  
ATOM   3100  CD  ARG J 543       2.913 -13.783  -3.165  1.00 28.20           C  
ATOM   3101  NE  ARG J 543       3.659 -15.025  -3.336  1.00 28.76           N  
ATOM   3102  CZ  ARG J 543       3.286 -16.027  -4.126  1.00 30.27           C  
ATOM   3103  NH1 ARG J 543       2.166 -15.943  -4.827  1.00 27.92           N  
ATOM   3104  NH2 ARG J 543       4.039 -17.119  -4.213  1.00 30.90           N  
ATOM   3105  N   ASN J 544       1.456 -12.725   1.670  1.00 18.96           N  
ATOM   3106  CA  ASN J 544       1.579 -11.561   2.541  1.00 20.19           C  
ATOM   3107  C   ASN J 544       0.263 -10.782   2.655  1.00 19.41           C  
ATOM   3108  O   ASN J 544       0.240  -9.555   2.592  1.00 18.12           O  
ATOM   3109  CB  ASN J 544       2.701 -10.668   2.016  1.00 22.74           C  
ATOM   3110  CG  ASN J 544       4.020 -11.415   1.910  1.00 25.37           C  
ATOM   3111  OD1 ASN J 544       4.710 -11.344   0.895  1.00 26.87           O  
ATOM   3112  ND2 ASN J 544       4.369 -12.148   2.965  1.00 28.04           N  
ATOM   3113  N   ALA J 545      -0.831 -11.508   2.852  1.00 18.59           N  
ATOM   3114  CA  ALA J 545      -2.138 -10.876   2.960  1.00 20.49           C  
ATOM   3115  C   ALA J 545      -2.181  -9.804   4.042  1.00 21.21           C  
ATOM   3116  O   ALA J 545      -2.788  -8.752   3.851  1.00 19.78           O  
ATOM   3117  CB  ALA J 545      -3.201 -11.935   3.232  1.00 20.96           C  
ATOM   3118  N   ALA J 546      -1.534 -10.060   5.176  1.00 22.91           N  
ATOM   3119  CA  ALA J 546      -1.546  -9.091   6.267  1.00 23.83           C  
ATOM   3120  C   ALA J 546      -1.103  -7.718   5.773  1.00 24.61           C  
ATOM   3121  O   ALA J 546      -1.635  -6.696   6.206  1.00 24.16           O  
ATOM   3122  CB  ALA J 546      -0.653  -9.562   7.406  1.00 25.76           C  
ATOM   3123  N   THR J 547      -0.143  -7.695   4.856  1.00 20.89           N  
ATOM   3124  CA  THR J 547       0.344  -6.436   4.313  1.00 20.32           C  
ATOM   3125  C   THR J 547      -0.581  -5.782   3.285  1.00 17.75           C  
ATOM   3126  O   THR J 547      -0.981  -4.636   3.455  1.00 14.53           O  
ATOM   3127  CB  THR J 547       1.728  -6.597   3.640  1.00 23.93           C  
ATOM   3128  OG1 THR J 547       2.696  -6.978   4.623  1.00 29.53           O  
ATOM   3129  CG2 THR J 547       2.161  -5.287   2.993  1.00 24.65           C  
ATOM   3130  N   TRP J 548      -0.907  -6.491   2.203  1.00 14.31           N  
ATOM   3131  CA  TRP J 548      -1.737  -5.855   1.192  1.00 13.46           C  
ATOM   3132  C   TRP J 548      -3.209  -5.625   1.555  1.00 12.42           C  
ATOM   3133  O   TRP J 548      -3.821  -4.690   1.042  1.00 12.48           O  
ATOM   3134  CB  TRP J 548      -1.616  -6.591  -0.155  1.00 12.45           C  
ATOM   3135  CG  TRP J 548      -2.224  -7.943  -0.217  1.00 12.36           C  
ATOM   3136  CD1 TRP J 548      -1.594  -9.149  -0.055  1.00 11.19           C  
ATOM   3137  CD2 TRP J 548      -3.585  -8.235  -0.520  1.00 12.40           C  
ATOM   3138  NE1 TRP J 548      -2.490 -10.179  -0.253  1.00 12.36           N  
ATOM   3139  CE2 TRP J 548      -3.720  -9.642  -0.543  1.00 13.81           C  
ATOM   3140  CE3 TRP J 548      -4.706  -7.438  -0.794  1.00 13.50           C  
ATOM   3141  CZ2 TRP J 548      -4.942 -10.273  -0.812  1.00 14.40           C  
ATOM   3142  CZ3 TRP J 548      -5.923  -8.067  -1.064  1.00 14.28           C  
ATOM   3143  CH2 TRP J 548      -6.025  -9.474  -1.074  1.00 14.68           C  
ATOM   3144  N   LYS J 549      -3.785  -6.457   2.417  1.00 12.41           N  
ATOM   3145  CA  LYS J 549      -5.184  -6.237   2.803  1.00 12.35           C  
ATOM   3146  C   LYS J 549      -5.271  -4.968   3.657  1.00 13.46           C  
ATOM   3147  O   LYS J 549      -6.256  -4.219   3.596  1.00 13.34           O  
ATOM   3148  CB  LYS J 549      -5.727  -7.435   3.567  1.00 12.21           C  
ATOM   3149  CG  LYS J 549      -5.971  -8.642   2.662  1.00 13.41           C  
ATOM   3150  CD  LYS J 549      -6.604  -9.803   3.432  1.00 16.02           C  
ATOM   3151  CE  LYS J 549      -6.973 -10.932   2.493  1.00 16.23           C  
ATOM   3152  NZ  LYS J 549      -7.663 -12.032   3.247  1.00 19.63           N  
ATOM   3153  N   ASN J 550      -4.218  -4.733   4.432  1.00 11.84           N  
ATOM   3154  CA  ASN J 550      -4.116  -3.547   5.270  1.00 14.67           C  
ATOM   3155  C   ASN J 550      -4.022  -2.351   4.316  1.00 13.86           C  
ATOM   3156  O   ASN J 550      -4.681  -1.325   4.508  1.00 14.40           O  
ATOM   3157  CB  ASN J 550      -2.874  -3.683   6.168  1.00 15.55           C  
ATOM   3158  CG  ASN J 550      -2.688  -2.510   7.117  1.00 19.92           C  
ATOM   3159  OD1 ASN J 550      -3.593  -1.709   7.334  1.00 19.03           O  
ATOM   3160  ND2 ASN J 550      -1.493  -2.424   7.712  1.00 23.82           N  
ATOM   3161  N   ALA J 551      -3.228  -2.492   3.255  1.00 14.06           N  
ATOM   3162  CA  ALA J 551      -3.098  -1.417   2.275  1.00 14.06           C  
ATOM   3163  C   ALA J 551      -4.445  -1.107   1.642  1.00 13.77           C  
ATOM   3164  O   ALA J 551      -4.799   0.053   1.451  1.00 13.81           O  
ATOM   3165  CB  ALA J 551      -2.087  -1.808   1.177  1.00 13.15           C  
ATOM   3166  N   VAL J 552      -5.188  -2.151   1.289  1.00 11.90           N  
ATOM   3167  CA  VAL J 552      -6.495  -1.943   0.672  1.00 11.57           C  
ATOM   3168  C   VAL J 552      -7.455  -1.203   1.613  1.00 10.99           C  
ATOM   3169  O   VAL J 552      -8.106  -0.231   1.207  1.00 12.19           O  
ATOM   3170  CB  VAL J 552      -7.128  -3.292   0.258  1.00 11.97           C  
ATOM   3171  CG1 VAL J 552      -8.592  -3.097  -0.109  1.00 13.04           C  
ATOM   3172  CG2 VAL J 552      -6.347  -3.883  -0.927  1.00 12.37           C  
ATOM   3173  N   ARG J 553      -7.564  -1.661   2.854  1.00 11.01           N  
ATOM   3174  CA  ARG J 553      -8.468  -1.001   3.806  1.00 13.24           C  
ATOM   3175  C   ARG J 553      -8.039   0.454   4.034  1.00 12.26           C  
ATOM   3176  O   ARG J 553      -8.869   1.361   4.095  1.00 10.35           O  
ATOM   3177  CB  ARG J 553      -8.483  -1.736   5.150  1.00 13.81           C  
ATOM   3178  CG  ARG J 553      -9.070  -3.142   5.097  1.00 14.66           C  
ATOM   3179  CD  ARG J 553      -9.217  -3.710   6.505  1.00 14.36           C  
ATOM   3180  NE  ARG J 553      -7.956  -3.752   7.249  1.00 17.06           N  
ATOM   3181  CZ  ARG J 553      -7.084  -4.759   7.218  1.00 18.04           C  
ATOM   3182  NH1 ARG J 553      -7.321  -5.828   6.466  1.00 15.67           N  
ATOM   3183  NH2 ARG J 553      -5.989  -4.721   7.976  1.00 16.65           N  
ATOM   3184  N   HIS J 554      -6.733   0.657   4.182  1.00 11.94           N  
ATOM   3185  CA  HIS J 554      -6.188   1.997   4.383  1.00 13.80           C  
ATOM   3186  C   HIS J 554      -6.570   2.909   3.217  1.00 12.78           C  
ATOM   3187  O   HIS J 554      -7.026   4.037   3.419  1.00 12.09           O  
ATOM   3188  CB  HIS J 554      -4.661   1.918   4.520  1.00 13.16           C  
ATOM   3189  CG  HIS J 554      -3.971   3.242   4.412  1.00 13.75           C  
ATOM   3190  ND1 HIS J 554      -3.945   4.164   5.438  1.00 13.43           N  
ATOM   3191  CD2 HIS J 554      -3.290   3.807   3.382  1.00 13.75           C  
ATOM   3192  CE1 HIS J 554      -3.281   5.239   5.047  1.00 16.02           C  
ATOM   3193  NE2 HIS J 554      -2.875   5.046   3.802  1.00 14.45           N  
ATOM   3194  N   ASN J 555      -6.386   2.422   1.992  1.00 12.05           N  
ATOM   3195  CA  ASN J 555      -6.730   3.218   0.825  1.00 11.35           C  
ATOM   3196  C   ASN J 555      -8.234   3.518   0.729  1.00 12.30           C  
ATOM   3197  O   ASN J 555      -8.641   4.644   0.404  1.00 11.28           O  
ATOM   3198  CB  ASN J 555      -6.242   2.525  -0.451  1.00 12.59           C  
ATOM   3199  CG  ASN J 555      -4.813   2.883  -0.791  1.00 10.51           C  
ATOM   3200  OD1 ASN J 555      -3.846   2.300  -0.254  1.00 13.73           O  
ATOM   3201  ND2 ASN J 555      -4.662   3.848  -1.674  1.00  9.41           N  
ATOM   3202  N   LEU J 556      -9.060   2.522   1.026  1.00 12.08           N  
ATOM   3203  CA  LEU J 556     -10.502   2.727   0.978  1.00 13.53           C  
ATOM   3204  C   LEU J 556     -10.928   3.845   1.937  1.00 14.99           C  
ATOM   3205  O   LEU J 556     -11.731   4.701   1.564  1.00 13.87           O  
ATOM   3206  CB  LEU J 556     -11.235   1.427   1.322  1.00 13.34           C  
ATOM   3207  CG  LEU J 556     -11.159   0.374   0.211  1.00 12.29           C  
ATOM   3208  CD1 LEU J 556     -11.664  -0.960   0.748  1.00 14.81           C  
ATOM   3209  CD2 LEU J 556     -11.985   0.829  -1.015  1.00 13.31           C  
ATOM   3210  N   SER J 557     -10.391   3.854   3.156  1.00 15.75           N  
ATOM   3211  CA  SER J 557     -10.759   4.888   4.133  1.00 18.59           C  
ATOM   3212  C   SER J 557     -10.114   6.232   3.850  1.00 17.84           C  
ATOM   3213  O   SER J 557     -10.778   7.263   3.869  1.00 18.00           O  
ATOM   3214  CB  SER J 557     -10.362   4.480   5.558  1.00 19.27           C  
ATOM   3215  OG  SER J 557     -11.192   3.463   6.070  1.00 23.25           O  
ATOM   3216  N   LEU J 558      -8.815   6.215   3.582  1.00 16.96           N  
ATOM   3217  CA  LEU J 558      -8.071   7.458   3.352  1.00 16.39           C  
ATOM   3218  C   LEU J 558      -8.559   8.325   2.200  1.00 17.04           C  
ATOM   3219  O   LEU J 558      -8.750   9.532   2.353  1.00 16.98           O  
ATOM   3220  CB  LEU J 558      -6.583   7.162   3.133  1.00 17.92           C  
ATOM   3221  CG  LEU J 558      -5.700   8.421   3.129  1.00 19.84           C  
ATOM   3222  CD1 LEU J 558      -5.708   9.021   4.536  1.00 21.84           C  
ATOM   3223  CD2 LEU J 558      -4.267   8.087   2.697  1.00 19.21           C  
ATOM   3224  N   HIS J 559      -8.754   7.709   1.044  1.00 16.75           N  
ATOM   3225  CA  HIS J 559      -9.158   8.436  -0.136  1.00 17.68           C  
ATOM   3226  C   HIS J 559     -10.655   8.662  -0.250  1.00 18.90           C  
ATOM   3227  O   HIS J 559     -11.446   7.715  -0.199  1.00 16.96           O  
ATOM   3228  CB  HIS J 559      -8.613   7.714  -1.363  1.00 18.74           C  
ATOM   3229  CG  HIS J 559      -7.131   7.519  -1.318  1.00 21.16           C  
ATOM   3230  ND1 HIS J 559      -6.250   8.571  -1.177  1.00 22.55           N  
ATOM   3231  CD2 HIS J 559      -6.375   6.396  -1.355  1.00 20.17           C  
ATOM   3232  CE1 HIS J 559      -5.013   8.104  -1.128  1.00 22.83           C  
ATOM   3233  NE2 HIS J 559      -5.062   6.787  -1.233  1.00 20.84           N  
ATOM   3234  N   LYS J 560     -11.020   9.930  -0.404  1.00 18.87           N  
ATOM   3235  CA  LYS J 560     -12.413  10.349  -0.523  1.00 23.48           C  
ATOM   3236  C   LYS J 560     -13.087   9.778  -1.766  1.00 23.53           C  
ATOM   3237  O   LYS J 560     -14.314   9.686  -1.819  1.00 24.02           O  
ATOM   3238  CB  LYS J 560     -12.504  11.877  -0.569  1.00 26.53           C  
ATOM   3239  CG  LYS J 560     -11.872  12.591   0.610  1.00 31.82           C  
ATOM   3240  CD  LYS J 560     -12.617  12.332   1.907  1.00 34.19           C  
ATOM   3241  CE  LYS J 560     -12.005  13.138   3.043  1.00 36.39           C  
ATOM   3242  NZ  LYS J 560     -12.636  12.848   4.363  1.00 37.19           N  
ATOM   3243  N   CYS J 561     -12.303   9.408  -2.773  1.00 23.13           N  
ATOM   3244  CA  CYS J 561     -12.902   8.848  -3.981  1.00 23.18           C  
ATOM   3245  C   CYS J 561     -13.583   7.503  -3.710  1.00 22.01           C  
ATOM   3246  O   CYS J 561     -14.415   7.056  -4.503  1.00 24.02           O  
ATOM   3247  CB  CYS J 561     -11.858   8.701  -5.089  1.00 24.57           C  
ATOM   3248  SG  CYS J 561     -10.505   7.586  -4.705  1.00 27.66           S  
ATOM   3249  N   PHE J 562     -13.242   6.858  -2.597  1.00 18.17           N  
ATOM   3250  CA  PHE J 562     -13.873   5.579  -2.265  1.00 18.44           C  
ATOM   3251  C   PHE J 562     -14.915   5.821  -1.187  1.00 18.98           C  
ATOM   3252  O   PHE J 562     -14.601   6.202  -0.054  1.00 17.00           O  
ATOM   3253  CB  PHE J 562     -12.828   4.555  -1.806  1.00 16.31           C  
ATOM   3254  CG  PHE J 562     -11.787   4.276  -2.844  1.00 15.47           C  
ATOM   3255  CD1 PHE J 562     -10.443   4.528  -2.580  1.00 14.88           C  
ATOM   3256  CD2 PHE J 562     -12.153   3.831  -4.117  1.00 14.33           C  
ATOM   3257  CE1 PHE J 562      -9.474   4.359  -3.563  1.00 13.86           C  
ATOM   3258  CE2 PHE J 562     -11.190   3.655  -5.114  1.00 15.48           C  
ATOM   3259  CZ  PHE J 562      -9.842   3.922  -4.831  1.00 14.96           C  
ATOM   3260  N   VAL J 563     -16.169   5.595  -1.544  1.00 18.15           N  
ATOM   3261  CA  VAL J 563     -17.262   5.847  -0.614  1.00 19.68           C  
ATOM   3262  C   VAL J 563     -17.972   4.581  -0.191  1.00 17.57           C  
ATOM   3263  O   VAL J 563     -18.421   3.806  -1.031  1.00 17.24           O  
ATOM   3264  CB  VAL J 563     -18.291   6.796  -1.251  1.00 22.04           C  
ATOM   3265  CG1 VAL J 563     -19.401   7.129  -0.254  1.00 22.43           C  
ATOM   3266  CG2 VAL J 563     -17.587   8.060  -1.723  1.00 24.45           C  
ATOM   3267  N   ARG J 564     -18.052   4.382   1.118  1.00 16.10           N  
ATOM   3268  CA  ARG J 564     -18.720   3.233   1.703  1.00 17.40           C  
ATOM   3269  C   ARG J 564     -20.227   3.492   1.667  1.00 18.38           C  
ATOM   3270  O   ARG J 564     -20.700   4.530   2.151  1.00 16.06           O  
ATOM   3271  CB  ARG J 564     -18.252   3.050   3.145  1.00 18.51           C  
ATOM   3272  CG  ARG J 564     -18.939   1.936   3.902  1.00 19.80           C  
ATOM   3273  CD  ARG J 564     -18.231   1.672   5.227  1.00 22.71           C  
ATOM   3274  NE  ARG J 564     -18.900   0.631   6.000  1.00 24.03           N  
ATOM   3275  CZ  ARG J 564     -20.023   0.816   6.687  1.00 26.02           C  
ATOM   3276  NH1 ARG J 564     -20.605   2.009   6.706  1.00 25.82           N  
ATOM   3277  NH2 ARG J 564     -20.569  -0.196   7.347  1.00 25.98           N  
ATOM   3278  N   VAL J 565     -20.970   2.552   1.091  1.00 16.65           N  
ATOM   3279  CA  VAL J 565     -22.425   2.674   0.984  1.00 16.30           C  
ATOM   3280  C   VAL J 565     -23.046   1.532   1.757  1.00 17.04           C  
ATOM   3281  O   VAL J 565     -22.992   0.369   1.352  1.00 17.26           O  
ATOM   3282  CB  VAL J 565     -22.889   2.613  -0.494  1.00 16.73           C  
ATOM   3283  CG1 VAL J 565     -24.410   2.659  -0.578  1.00 16.52           C  
ATOM   3284  CG2 VAL J 565     -22.289   3.776  -1.268  1.00 16.95           C  
ATOM   3285  N   GLU J 566     -23.621   1.868   2.897  1.00 15.72           N  
ATOM   3286  CA  GLU J 566     -24.239   0.878   3.744  1.00 17.73           C  
ATOM   3287  C   GLU J 566     -25.531   0.399   3.092  1.00 18.29           C  
ATOM   3288  O   GLU J 566     -26.223   1.181   2.438  1.00 16.63           O  
ATOM   3289  CB  GLU J 566     -24.525   1.511   5.109  1.00 21.20           C  
ATOM   3290  CG  GLU J 566     -24.501   0.548   6.253  1.00 25.53           C  
ATOM   3291  CD  GLU J 566     -24.447   1.243   7.603  1.00 27.45           C  
ATOM   3292  OE1 GLU J 566     -23.535   2.073   7.825  1.00 26.80           O  
ATOM   3293  OE2 GLU J 566     -25.311   0.942   8.446  1.00 29.60           O  
ATOM   3294  N   ASN J 567     -25.830  -0.889   3.243  1.00 19.76           N  
ATOM   3295  CA  ASN J 567     -27.060  -1.448   2.694  1.00 23.31           C  
ATOM   3296  C   ASN J 567     -27.635  -2.490   3.649  1.00 24.61           C  
ATOM   3297  O   ASN J 567     -27.078  -2.728   4.723  1.00 23.15           O  
ATOM   3298  CB  ASN J 567     -26.846  -2.046   1.287  1.00 24.06           C  
ATOM   3299  CG  ASN J 567     -25.731  -3.080   1.233  1.00 25.16           C  
ATOM   3300  OD1 ASN J 567     -25.565  -3.889   2.141  1.00 26.05           O  
ATOM   3301  ND2 ASN J 567     -24.977  -3.070   0.139  1.00 25.22           N  
ATOM   3302  N   VAL J 568     -28.747  -3.114   3.270  1.00 28.40           N  
ATOM   3303  CA  VAL J 568     -29.373  -4.104   4.144  1.00 32.16           C  
ATOM   3304  C   VAL J 568     -28.449  -5.227   4.609  1.00 33.34           C  
ATOM   3305  O   VAL J 568     -28.485  -5.609   5.776  1.00 35.58           O  
ATOM   3306  CB  VAL J 568     -30.625  -4.738   3.489  1.00 33.10           C  
ATOM   3307  CG1 VAL J 568     -31.697  -3.684   3.301  1.00 33.02           C  
ATOM   3308  CG2 VAL J 568     -30.263  -5.356   2.149  1.00 34.04           C  
ATOM   3309  N   LYS J 569     -27.610  -5.742   3.714  1.00 35.71           N  
ATOM   3310  CA  LYS J 569     -26.711  -6.837   4.074  1.00 36.73           C  
ATOM   3311  C   LYS J 569     -25.296  -6.456   4.492  1.00 35.86           C  
ATOM   3312  O   LYS J 569     -24.397  -7.300   4.502  1.00 37.45           O  
ATOM   3313  CB  LYS J 569     -26.647  -7.853   2.930  1.00 40.35           C  
ATOM   3314  CG  LYS J 569     -27.877  -8.740   2.848  1.00 45.40           C  
ATOM   3315  CD  LYS J 569     -28.078  -9.482   4.166  1.00 49.24           C  
ATOM   3316  CE  LYS J 569     -29.325 -10.346   4.149  1.00 50.63           C  
ATOM   3317  NZ  LYS J 569     -29.512 -11.021   5.463  1.00 51.85           N  
ATOM   3318  N   GLY J 570     -25.090  -5.194   4.848  1.00 32.72           N  
ATOM   3319  CA  GLY J 570     -23.767  -4.764   5.265  1.00 27.86           C  
ATOM   3320  C   GLY J 570     -23.357  -3.467   4.602  1.00 26.63           C  
ATOM   3321  O   GLY J 570     -23.982  -2.432   4.825  1.00 26.84           O  
ATOM   3322  N   ALA J 571     -22.306  -3.515   3.789  1.00 21.39           N  
ATOM   3323  CA  ALA J 571     -21.837  -2.320   3.101  1.00 20.51           C  
ATOM   3324  C   ALA J 571     -20.995  -2.663   1.893  1.00 20.20           C  
ATOM   3325  O   ALA J 571     -20.302  -3.679   1.873  1.00 22.17           O  
ATOM   3326  CB  ALA J 571     -21.030  -1.452   4.050  1.00 18.37           C  
ATOM   3327  N   VAL J 572     -21.057  -1.807   0.884  1.00 19.05           N  
ATOM   3328  CA  VAL J 572     -20.287  -2.009  -0.329  1.00 18.76           C  
ATOM   3329  C   VAL J 572     -19.470  -0.758  -0.531  1.00 18.73           C  
ATOM   3330  O   VAL J 572     -19.821   0.315  -0.026  1.00 18.42           O  
ATOM   3331  CB  VAL J 572     -21.188  -2.182  -1.578  1.00 19.47           C  
ATOM   3332  CG1 VAL J 572     -21.991  -3.482  -1.477  1.00 19.94           C  
ATOM   3333  CG2 VAL J 572     -22.123  -0.973  -1.724  1.00 19.71           C  
ATOM   3334  N   TRP J 573     -18.380  -0.901  -1.266  1.00 16.92           N  
ATOM   3335  CA  TRP J 573     -17.528   0.222  -1.582  1.00 16.90           C  
ATOM   3336  C   TRP J 573     -17.839   0.629  -3.016  1.00 17.40           C  
ATOM   3337  O   TRP J 573     -18.061  -0.231  -3.877  1.00 18.35           O  
ATOM   3338  CB  TRP J 573     -16.044  -0.168  -1.421  1.00 15.87           C  
ATOM   3339  CG  TRP J 573     -15.652  -0.283   0.031  1.00 15.31           C  
ATOM   3340  CD1 TRP J 573     -15.654  -1.410   0.798  1.00 14.90           C  
ATOM   3341  CD2 TRP J 573     -15.279   0.794   0.902  1.00 16.55           C  
ATOM   3342  NE1 TRP J 573     -15.311  -1.101   2.096  1.00 16.46           N  
ATOM   3343  CE2 TRP J 573     -15.079   0.245   2.185  1.00 15.62           C  
ATOM   3344  CE3 TRP J 573     -15.109   2.173   0.721  1.00 15.33           C  
ATOM   3345  CZ2 TRP J 573     -14.696   1.026   3.287  1.00 16.25           C  
ATOM   3346  CZ3 TRP J 573     -14.728   2.951   1.822  1.00 14.90           C  
ATOM   3347  CH2 TRP J 573     -14.533   2.372   3.084  1.00 13.50           C  
ATOM   3348  N   THR J 574     -17.870   1.937  -3.258  1.00 15.25           N  
ATOM   3349  CA  THR J 574     -18.152   2.494  -4.573  1.00 17.41           C  
ATOM   3350  C   THR J 574     -17.102   3.542  -4.882  1.00 17.72           C  
ATOM   3351  O   THR J 574     -16.351   3.950  -3.988  1.00 17.78           O  
ATOM   3352  CB  THR J 574     -19.519   3.203  -4.595  1.00 18.47           C  
ATOM   3353  OG1 THR J 574     -19.484   4.313  -3.685  1.00 17.13           O  
ATOM   3354  CG2 THR J 574     -20.615   2.243  -4.161  1.00 18.82           C  
ATOM   3355  N   VAL J 575     -17.068   4.003  -6.127  1.00 18.59           N  
ATOM   3356  CA  VAL J 575     -16.094   5.007  -6.541  1.00 22.39           C  
ATOM   3357  C   VAL J 575     -16.690   6.343  -6.981  1.00 25.85           C  
ATOM   3358  O   VAL J 575     -17.558   6.393  -7.856  1.00 26.52           O  
ATOM   3359  CB  VAL J 575     -15.227   4.499  -7.717  1.00 23.89           C  
ATOM   3360  CG1 VAL J 575     -14.256   5.589  -8.151  1.00 24.40           C  
ATOM   3361  CG2 VAL J 575     -14.471   3.250  -7.313  1.00 23.68           C  
ATOM   3362  N   ASP J 576     -16.226   7.430  -6.368  1.00 26.38           N  
ATOM   3363  CA  ASP J 576     -16.687   8.758  -6.758  1.00 28.59           C  
ATOM   3364  C   ASP J 576     -15.697   9.158  -7.846  1.00 30.21           C  
ATOM   3365  O   ASP J 576     -14.630   9.706  -7.560  1.00 29.97           O  
ATOM   3366  CB  ASP J 576     -16.619   9.732  -5.578  1.00 29.49           C  
ATOM   3367  CG  ASP J 576     -17.111  11.127  -5.940  1.00 31.71           C  
ATOM   3368  OD1 ASP J 576     -17.376  11.923  -5.013  1.00 31.12           O  
ATOM   3369  OD2 ASP J 576     -17.224  11.433  -7.145  1.00 32.47           O  
ATOM   3370  N   GLU J 577     -16.055   8.853  -9.092  1.00 32.90           N  
ATOM   3371  CA  GLU J 577     -15.205   9.128 -10.246  1.00 36.20           C  
ATOM   3372  C   GLU J 577     -14.709  10.569 -10.335  1.00 38.25           C  
ATOM   3373  O   GLU J 577     -13.535  10.804 -10.626  1.00 39.46           O  
ATOM   3374  CB  GLU J 577     -15.944   8.749 -11.532  1.00 36.86           C  
ATOM   3375  CG  GLU J 577     -15.110   8.836 -12.808  1.00 38.46           C  
ATOM   3376  CD  GLU J 577     -13.927   7.877 -12.832  1.00 40.16           C  
ATOM   3377  OE1 GLU J 577     -13.898   6.922 -12.023  1.00 38.39           O  
ATOM   3378  OE2 GLU J 577     -13.024   8.076 -13.679  1.00 39.86           O  
ATOM   3379  N   VAL J 578     -15.595  11.532 -10.093  1.00 39.57           N  
ATOM   3380  CA  VAL J 578     -15.201  12.936 -10.148  1.00 41.53           C  
ATOM   3381  C   VAL J 578     -14.066  13.169  -9.166  1.00 41.86           C  
ATOM   3382  O   VAL J 578     -13.092  13.859  -9.469  1.00 42.36           O  
ATOM   3383  CB  VAL J 578     -16.363  13.874  -9.769  1.00 41.58           C  
ATOM   3384  CG1 VAL J 578     -15.883  15.325  -9.786  1.00 42.78           C  
ATOM   3385  CG2 VAL J 578     -17.518  13.684 -10.735  1.00 42.17           C  
ATOM   3386  N   GLU J 579     -14.205  12.583  -7.983  1.00 42.28           N  
ATOM   3387  CA  GLU J 579     -13.200  12.719  -6.944  1.00 42.30           C  
ATOM   3388  C   GLU J 579     -11.922  12.008  -7.389  1.00 42.64           C  
ATOM   3389  O   GLU J 579     -10.830  12.562  -7.291  1.00 42.13           O  
ATOM   3390  CB  GLU J 579     -13.726  12.110  -5.644  1.00 43.08           C  
ATOM   3391  CG  GLU J 579     -13.124  12.699  -4.384  1.00 45.76           C  
ATOM   3392  CD  GLU J 579     -13.281  14.213  -4.304  1.00 47.98           C  
ATOM   3393  OE1 GLU J 579     -14.361  14.729  -4.668  1.00 49.15           O  
ATOM   3394  OE2 GLU J 579     -12.325  14.886  -3.866  1.00 47.97           O  
ATOM   3395  N   TYR J 580     -12.062  10.785  -7.893  1.00 43.31           N  
ATOM   3396  CA  TYR J 580     -10.903  10.023  -8.347  1.00 45.06           C  
ATOM   3397  C   TYR J 580     -10.095  10.835  -9.360  1.00 47.68           C  
ATOM   3398  O   TYR J 580      -8.866  10.833  -9.331  1.00 46.61           O  
ATOM   3399  CB  TYR J 580     -11.339   8.703  -8.994  1.00 42.50           C  
ATOM   3400  CG  TYR J 580     -10.181   7.889  -9.544  1.00 41.18           C  
ATOM   3401  CD1 TYR J 580      -9.377   7.114  -8.702  1.00 40.25           C  
ATOM   3402  CD2 TYR J 580      -9.864   7.924 -10.903  1.00 39.68           C  
ATOM   3403  CE1 TYR J 580      -8.284   6.395  -9.203  1.00 38.12           C  
ATOM   3404  CE2 TYR J 580      -8.777   7.214 -11.414  1.00 39.27           C  
ATOM   3405  CZ  TYR J 580      -7.989   6.451 -10.558  1.00 40.25           C  
ATOM   3406  OH  TYR J 580      -6.911   5.758 -11.065  1.00 37.52           O  
ATOM   3407  N   GLN J 581     -10.794  11.535 -10.247  1.00 51.41           N  
ATOM   3408  CA  GLN J 581     -10.138  12.338 -11.272  1.00 55.66           C  
ATOM   3409  C   GLN J 581      -9.331  13.513 -10.734  1.00 57.96           C  
ATOM   3410  O   GLN J 581      -8.388  13.965 -11.383  1.00 58.50           O  
ATOM   3411  CB  GLN J 581     -11.166  12.836 -12.286  1.00 55.45           C  
ATOM   3412  CG  GLN J 581     -11.755  11.733 -13.148  1.00 55.86           C  
ATOM   3413  CD  GLN J 581     -10.686  10.830 -13.739  1.00 55.77           C  
ATOM   3414  OE1 GLN J 581      -9.609  11.291 -14.116  1.00 56.73           O  
ATOM   3415  NE2 GLN J 581     -10.984   9.541 -13.833  1.00 55.10           N  
ATOM   3416  N   LYS J 582      -9.699  14.014  -9.560  1.00 61.69           N  
ATOM   3417  CA  LYS J 582      -8.971  15.126  -8.959  1.00 65.19           C  
ATOM   3418  C   LYS J 582      -7.636  14.611  -8.430  1.00 67.90           C  
ATOM   3419  O   LYS J 582      -7.563  13.514  -7.870  1.00 67.82           O  
ATOM   3420  CB  LYS J 582      -9.784  15.756  -7.827  1.00 65.80           C  
ATOM   3421  CG  LYS J 582     -11.037  16.474  -8.297  1.00 66.43           C  
ATOM   3422  CD  LYS J 582     -11.724  17.188  -7.146  1.00 67.97           C  
ATOM   3423  CE  LYS J 582     -12.965  17.928  -7.614  1.00 68.97           C  
ATOM   3424  NZ  LYS J 582     -13.638  18.642  -6.490  1.00 69.45           N  
ATOM   3425  N   ARG J 583      -6.588  15.412  -8.611  1.00 71.24           N  
ATOM   3426  CA  ARG J 583      -5.235  15.052  -8.195  1.00 75.02           C  
ATOM   3427  C   ARG J 583      -4.607  14.145  -9.247  1.00 76.35           C  
ATOM   3428  O   ARG J 583      -3.403  13.892  -9.228  1.00 77.41           O  
ATOM   3429  CB  ARG J 583      -5.234  14.360  -6.826  1.00 76.84           C  
ATOM   3430  CG  ARG J 583      -5.225  15.329  -5.654  1.00 80.21           C  
ATOM   3431  CD  ARG J 583      -3.975  16.196  -5.702  1.00 82.41           C  
ATOM   3432  NE  ARG J 583      -3.934  17.187  -4.633  1.00 84.32           N  
ATOM   3433  CZ  ARG J 583      -2.986  18.110  -4.512  1.00 85.02           C  
ATOM   3434  NH1 ARG J 583      -1.998  18.171  -5.397  1.00 85.27           N  
ATOM   3435  NH2 ARG J 583      -3.025  18.975  -3.508  1.00 86.14           N  
ATOM   3436  N   ARG J 584      -5.438  13.661 -10.165  1.00 77.64           N  
ATOM   3437  CA  ARG J 584      -4.980  12.810 -11.255  1.00 78.53           C  
ATOM   3438  C   ARG J 584      -5.229  13.533 -12.576  1.00 78.91           C  
ATOM   3439  O   ARG J 584      -6.018  13.015 -13.397  1.00 79.32           O  
ATOM   3440  CB  ARG J 584      -5.722  11.464 -11.256  1.00 78.80           C  
ATOM   3441  CG  ARG J 584      -5.243  10.456 -10.213  1.00 79.05           C  
ATOM   3442  CD  ARG J 584      -6.079  10.496  -8.942  1.00 79.30           C  
ATOM   3443  NE  ARG J 584      -5.696   9.446  -7.999  1.00 79.42           N  
ATOM   3444  CZ  ARG J 584      -6.366   9.152  -6.887  1.00 78.96           C  
ATOM   3445  NH1 ARG J 584      -7.464   9.824  -6.570  1.00 78.47           N  
ATOM   3446  NH2 ARG J 584      -5.935   8.186  -6.086  1.00 78.48           N  
TER    3447      ARG J 584                                                      
END
MOLECULE T0476.pdb
ATOM     20  N   ALA     2       2.300  -1.329  -3.219  1.00  1.00          
ATOM     21  HN  ALA     2       2.119  -0.600  -3.850  1.00  1.00          
ATOM     22  CA  ALA     2       2.425  -2.698  -3.762  1.00  1.00          
ATOM     23  HA  ALA     2       2.430  -3.385  -2.927  1.00  1.00          
ATOM     24  CB  ALA     2       1.232  -3.027  -4.654  1.00  1.00          
ATOM     25  HB1 ALA     2       0.366  -3.248  -4.041  1.00  1.00          
ATOM     26  HB2 ALA     2       1.466  -3.884  -5.266  1.00  1.00          
ATOM     27  HB3 ALA     2       1.012  -2.181  -5.288  1.00  1.00          
ATOM     28  C   ALA     2       3.737  -2.860  -4.536  1.00  1.00          
ATOM     29  O   ALA     2       4.162  -1.925  -5.237  1.00  1.00          
ATOM     30  N   LYS     3       4.348  -4.064  -4.398  1.00  1.00          
ATOM     31  HN  LYS     3       3.910  -4.743  -3.851  1.00  1.00          
ATOM     32  CA  LYS     3       5.630  -4.420  -5.036  1.00  1.00          
ATOM     33  HA  LYS     3       5.927  -3.593  -5.664  1.00  1.00          
ATOM     34  CB  LYS     3       6.703  -4.642  -3.963  1.00  1.00          
ATOM     35  HB1 LYS     3       7.090  -5.646  -4.059  1.00  1.00          
ATOM     36  HB2 LYS     3       6.247  -4.534  -2.991  1.00  1.00          
ATOM     37  CG  LYS     3       7.866  -3.669  -4.054  1.00  1.00          
ATOM     38  HG1 LYS     3       7.478  -2.663  -4.070  1.00  1.00          
ATOM     39  HG2 LYS     3       8.415  -3.861  -4.963  1.00  1.00          
ATOM     40  CD  LYS     3       8.812  -3.819  -2.864  1.00  1.00          
ATOM     41  HD1 LYS     3       9.239  -4.812  -2.884  1.00  1.00          
ATOM     42  HD2 LYS     3       8.242  -3.692  -1.954  1.00  1.00          
ATOM     43  CE  LYS     3       9.950  -2.788  -2.891  1.00  1.00          
ATOM     44  HE1 LYS     3      10.366  -2.698  -1.895  1.00  1.00          
ATOM     45  HE2 LYS     3       9.543  -1.834  -3.190  1.00  1.00          
ATOM     46  NZ  LYS     3      11.048  -3.157  -3.838  1.00  1.00          
ATOM     47  HZ1 LYS     3      10.919  -4.134  -4.171  1.00  1.00          
ATOM     48  HZ2 LYS     3      11.970  -3.084  -3.363  1.00  1.00          
ATOM     49  HZ3 LYS     3      11.041  -2.517  -4.658  1.00  1.00          
ATOM     50  C   LYS     3       5.489  -5.670  -5.903  1.00  1.00          
ATOM     51  O   LYS     3       4.818  -6.637  -5.496  1.00  1.00          
ATOM     52  N   CYS     4       6.139  -5.626  -7.110  1.00  1.00          
ATOM     53  HN  CYS     4       6.610  -4.798  -7.337  1.00  1.00          
ATOM     54  CA  CYS     4       6.151  -6.739  -8.115  1.00  1.00          
ATOM     55  HA  CYS     4       5.134  -7.092  -8.210  1.00  1.00          
ATOM     56  HB1 CYS     4       7.690  -6.064  -9.456  1.00  1.00          
ATOM     57  HB2 CYS     4       6.138  -5.314  -9.733  1.00  1.00          
ATOM     58  C   CYS     4       7.052  -7.958  -7.664  1.00  1.00          
ATOM     59  O   CYS     4       8.242  -7.720  -7.359  1.00  1.00          
ATOM     60  CB  CYS     4       6.628  -6.236  -9.499  1.00  1.00          
ATOM     61  SG  CYS     4       6.315  -7.399 -10.876  1.00  1.00          
ATOM     62  ZN  CYS     4       7.178  -6.267 -12.689  1.00  1.00          
ATOM     63  N   PRO     5       6.504  -9.279  -7.551  1.00  1.00          
ATOM     64  CA  PRO     5       7.350 -10.468  -7.168  1.00  1.00          
ATOM     65  HA  PRO     5       7.965 -10.222  -6.313  1.00  1.00          
ATOM     66  CB  PRO     5       6.300 -11.538  -6.750  1.00  1.00          
ATOM     67  HB1 PRO     5       6.133 -11.486  -5.679  1.00  1.00          
ATOM     68  HB2 PRO     5       6.670 -12.522  -7.004  1.00  1.00          
ATOM     69  CG  PRO     5       5.042 -11.205  -7.513  1.00  1.00          
ATOM     70  HG1 PRO     5       4.168 -11.526  -6.955  1.00  1.00          
ATOM     71  HG2 PRO     5       5.061 -11.696  -8.482  1.00  1.00          
ATOM     72  CD  PRO     5       5.048  -9.697  -7.681  1.00  1.00          
ATOM     73  HD1 PRO     5       4.459  -9.227  -6.903  1.00  1.00          
ATOM     74  HD2 PRO     5       4.661  -9.417  -8.652  1.00  1.00          
ATOM     75  C   PRO     5       8.310 -10.999  -8.302  1.00  1.00          
ATOM     76  O   PRO     5       9.092 -11.941  -8.056  1.00  1.00          
ATOM     77  N   ILE     6       8.243 -10.351  -9.506  1.00  1.00          
ATOM     78  HN  ILE     6       7.662  -9.568  -9.601  1.00  1.00          
ATOM     79  CA  ILE     6       9.041 -10.718 -10.711  1.00  1.00          
ATOM     80  HA  ILE     6       9.414 -11.721 -10.556  1.00  1.00          
ATOM     81  CB  ILE     6       8.166 -10.709 -12.075  1.00  1.00          
ATOM     82  HB  ILE     6       8.010  -9.665 -12.339  1.00  1.00          
ATOM     83  CG1 ILE     6       6.780 -11.397 -11.928  1.00  1.00          
ATOM     84 HG11 ILE     6       6.684 -11.787 -10.923  1.00  1.00          
ATOM     85 HG12 ILE     6       6.717 -12.214 -12.630  1.00  1.00          
ATOM     86  CG2 ILE     6       8.885 -11.402 -13.266  1.00  1.00          
ATOM     87 HG21 ILE     6       8.195 -11.508 -14.089  1.00  1.00          
ATOM     88 HG22 ILE     6       9.234 -12.376 -12.960  1.00  1.00          
ATOM     89 HG23 ILE     6       9.727 -10.799 -13.576  1.00  1.00          
ATOM     90  CD1 ILE     6       5.603 -10.477 -12.185  1.00  1.00          
ATOM     91 HD11 ILE     6       5.734  -9.980 -13.135  1.00  1.00          
ATOM     92 HD12 ILE     6       5.545  -9.738 -11.398  1.00  1.00          
ATOM     93 HD13 ILE     6       4.690 -11.054 -12.203  1.00  1.00          
ATOM     94  C   ILE     6      10.267  -9.754 -10.836  1.00  1.00          
ATOM     95  O   ILE     6      11.410 -10.247 -10.885  1.00  1.00          
ATOM     96  N   CYS     7       9.997  -8.409 -10.880  1.00  1.00          
ATOM     97  HN  CYS     7       9.068  -8.099 -10.752  1.00  1.00          
ATOM     98  CA  CYS     7      11.045  -7.379 -11.052  1.00  1.00          
ATOM     99  HA  CYS     7      11.937  -7.900 -11.371  1.00  1.00          
ATOM    100  HB1 CYS     7      10.463  -6.971 -13.068  1.00  1.00          
ATOM    101  HB2 CYS     7      11.466  -5.723 -12.357  1.00  1.00          
ATOM    102  C   CYS     7      11.386  -6.643  -9.742  1.00  1.00          
ATOM    103  O   CYS     7      12.579  -6.407  -9.475  1.00  1.00          
ATOM    104  CB  CYS     7      10.644  -6.397 -12.176  1.00  1.00          
ATOM    105  SG  CYS     7       9.154  -5.367 -11.862  1.00  1.00          
ATOM    106  N   GLY     8      10.326  -6.300  -8.947  1.00  1.00          
ATOM    107  HN  GLY     8       9.429  -6.536  -9.259  1.00  1.00          
ATOM    108  CA  GLY     8      10.463  -5.587  -7.658  1.00  1.00          
ATOM    109  HA1 GLY     8      11.409  -5.858  -7.215  1.00  1.00          
ATOM    110  HA2 GLY     8       9.671  -5.911  -7.002  1.00  1.00          
ATOM    111  C   GLY     8      10.398  -4.062  -7.773  1.00  1.00          
ATOM    112  O   GLY     8      11.113  -3.371  -7.024  1.00  1.00          
ATOM    113  N   SER     9       9.543  -3.559  -8.714  1.00  1.00          
ATOM    114  HN  SER     9       9.028  -4.201  -9.268  1.00  1.00          
ATOM    115  CA  SER     9       9.353  -2.108  -8.955  1.00  1.00          
ATOM    116  HA  SER     9      10.245  -1.616  -8.608  1.00  1.00          
ATOM    117  CB  SER     9       9.190  -1.838 -10.450  1.00  1.00          
ATOM    118  HB1 SER     9       8.515  -1.007 -10.590  1.00  1.00          
ATOM    119  HB2 SER     9       8.784  -2.717 -10.929  1.00  1.00          
ATOM    120  OG  SER     9      10.434  -1.523 -11.050  1.00  1.00          
ATOM    121  HG  SER     9      11.071  -1.296 -10.369  1.00  1.00          
ATOM    122  C   SER     9       8.118  -1.543  -8.168  1.00  1.00          
ATOM    123  O   SER     9       7.155  -2.318  -7.998  1.00  1.00          
ATOM    124  N   PRO    10       8.068  -0.182  -7.677  1.00  1.00          
ATOM    125  CA  PRO    10       6.894   0.366  -6.898  1.00  1.00          
ATOM    126  HA  PRO    10       6.675  -0.274  -6.053  1.00  1.00          
ATOM    127  CB  PRO    10       7.377   1.745  -6.389  1.00  1.00          
ATOM    128  HB1 PRO    10       7.094   1.885  -5.351  1.00  1.00          
ATOM    129  HB2 PRO    10       6.922   2.521  -6.992  1.00  1.00          
ATOM    130  CG  PRO    10       8.860   1.719  -6.557  1.00  1.00          
ATOM    131  HG1 PRO    10       9.323   1.230  -5.709  1.00  1.00          
ATOM    132  HG2 PRO    10       9.246   2.726  -6.667  1.00  1.00          
ATOM    133  CD  PRO    10       9.089   0.921  -7.810  1.00  1.00          
ATOM    134  HD1 PRO    10      10.092   0.531  -7.830  1.00  1.00          
ATOM    135  HD2 PRO    10       8.896   1.526  -8.686  1.00  1.00          
ATOM    136  C   PRO    10       5.597   0.545  -7.715  1.00  1.00          
ATOM    137  O   PRO    10       5.643   0.957  -8.890  1.00  1.00          
ATOM    138  N   LEU    11       4.473   0.213  -7.043  1.00  1.00          
ATOM    139  HN  LEU    11       4.572  -0.110  -6.123  1.00  1.00          
ATOM    140  CA  LEU    11       3.105   0.301  -7.592  1.00  1.00          
ATOM    141  HA  LEU    11       3.157   0.823  -8.536  1.00  1.00          
ATOM    142  CB  LEU    11       2.505  -1.103  -7.823  1.00  1.00          
ATOM    143  HB1 LEU    11       1.435  -0.986  -7.961  1.00  1.00          
ATOM    144  HB2 LEU    11       2.671  -1.689  -6.932  1.00  1.00          
ATOM    145  CG  LEU    11       3.057  -1.892  -9.022  1.00  1.00          
ATOM    146  HG  LEU    11       4.007  -1.471  -9.320  1.00  1.00          
ATOM    147  CD1 LEU    11       3.294  -3.342  -8.631  1.00  1.00          
ATOM    148 HD11 LEU    11       2.387  -3.756  -8.216  1.00  1.00          
ATOM    149 HD12 LEU    11       4.082  -3.393  -7.896  1.00  1.00          
ATOM    150 HD13 LEU    11       3.580  -3.909  -9.505  1.00  1.00          
ATOM    151  CD2 LEU    11       2.100  -1.814 -10.209  1.00  1.00          
ATOM    152 HD21 LEU    11       1.811  -0.785 -10.370  1.00  1.00          
ATOM    153 HD22 LEU    11       1.222  -2.406 -10.003  1.00  1.00          
ATOM    154 HD23 LEU    11       2.591  -2.193 -11.094  1.00  1.00          
ATOM    155  C   LEU    11       2.200   1.084  -6.640  1.00  1.00          
ATOM    156  O   LEU    11       2.354   0.979  -5.405  1.00  1.00          
ATOM    157  N   LYS    12       1.248   1.846  -7.239  1.00  1.00          
ATOM    158  HN  LYS    12       1.205   1.847  -8.218  1.00  1.00          
ATOM    159  CA  LYS    12       0.268   2.672  -6.500  1.00  1.00          
ATOM    160  HA  LYS    12       0.655   2.832  -5.504  1.00  1.00          
ATOM    161  CB  LYS    12       0.071   4.039  -7.188  1.00  1.00          
ATOM    162  HB1 LYS    12      -0.862   4.462  -6.847  1.00  1.00          
ATOM    163  HB2 LYS    12       0.009   3.879  -8.253  1.00  1.00          
ATOM    164  CG  LYS    12       1.177   5.060  -6.932  1.00  1.00          
ATOM    165  HG1 LYS    12       2.125   4.636  -7.231  1.00  1.00          
ATOM    166  HG2 LYS    12       1.202   5.296  -5.878  1.00  1.00          
ATOM    167  CD  LYS    12       0.933   6.337  -7.719  1.00  1.00          
ATOM    168  HD1 LYS    12       0.002   6.777  -7.392  1.00  1.00          
ATOM    169  HD2 LYS    12       0.868   6.093  -8.769  1.00  1.00          
ATOM    170  CE  LYS    12       2.054   7.343  -7.518  1.00  1.00          
ATOM    171  HE1 LYS    12       2.989   6.884  -7.799  1.00  1.00          
ATOM    172  HE2 LYS    12       2.087   7.622  -6.476  1.00  1.00          
ATOM    173  NZ  LYS    12       1.848   8.568  -8.341  1.00  1.00          
ATOM    174  HZ1 LYS    12       0.845   8.844  -8.326  1.00  1.00          
ATOM    175  HZ2 LYS    12       2.133   8.389  -9.324  1.00  1.00          
ATOM    176  HZ3 LYS    12       2.418   9.351  -7.963  1.00  1.00          
ATOM    177  C   LYS    12      -1.081   1.956  -6.396  1.00  1.00          
ATOM    178  O   LYS    12      -1.559   1.377  -7.390  1.00  1.00          
ATOM    179  N   TRP    13      -1.672   1.996  -5.160  1.00  1.00          
ATOM    180  HN  TRP    13      -1.181   2.442  -4.438  1.00  1.00          
ATOM    181  CA  TRP    13      -3.017   1.404  -4.824  1.00  1.00          
ATOM    182  HA  TRP    13      -3.015   0.400  -5.221  1.00  1.00          
ATOM    183  CB  TRP    13      -3.201   1.310  -3.305  1.00  1.00          
ATOM    184  HB1 TRP    13      -4.256   1.293  -3.074  1.00  1.00          
ATOM    185  HB2 TRP    13      -2.746   2.171  -2.837  1.00  1.00          
ATOM    186  CG  TRP    13      -2.569   0.062  -2.712  1.00  1.00          
ATOM    187  CD1 TRP    13      -1.316  -0.023  -2.173  1.00  1.00          
ATOM    188  HD1 TRP    13      -0.631   0.809  -2.108  1.00  1.00          
ATOM    189  CD2 TRP    13      -3.138  -1.276  -2.597  1.00  1.00          
ATOM    190  NE1 TRP    13      -1.061  -1.302  -1.745  1.00  1.00          
ATOM    191  HE1 TRP    13      -0.226  -1.604  -1.327  1.00  1.00          
ATOM    192  CE2 TRP    13      -2.156  -2.089  -1.988  1.00  1.00          
ATOM    193  CE3 TRP    13      -4.371  -1.874  -2.944  1.00  1.00          
ATOM    194  HE3 TRP    13      -5.157  -1.299  -3.410  1.00  1.00          
ATOM    195  CZ2 TRP    13      -2.361  -3.447  -1.724  1.00  1.00          
ATOM    196  HZ2 TRP    13      -1.601  -4.066  -1.262  1.00  1.00          
ATOM    197  CZ3 TRP    13      -4.566  -3.216  -2.675  1.00  1.00          
ATOM    198  HZ3 TRP    13      -5.504  -3.685  -2.935  1.00  1.00          
ATOM    199  CH2 TRP    13      -3.565  -3.989  -2.072  1.00  1.00          
ATOM    200  HH2 TRP    13      -3.762  -5.034  -1.877  1.00  1.00          
ATOM    201  C   TRP    13      -4.207   2.161  -5.486  1.00  1.00          
ATOM    202  O   TRP    13      -5.280   1.571  -5.690  1.00  1.00          
ATOM    203  N   GLU    14      -3.968   3.482  -5.801  1.00  1.00          
ATOM    204  HN  GLU    14      -3.096   3.848  -5.548  1.00  1.00          
ATOM    205  CA  GLU    14      -4.922   4.411  -6.497  1.00  1.00          
ATOM    206  HA  GLU    14      -5.875   4.335  -5.994  1.00  1.00          
ATOM    207  CB  GLU    14      -4.427   5.865  -6.398  1.00  1.00          
ATOM    208  HB1 GLU    14      -4.913   6.447  -7.167  1.00  1.00          
ATOM    209  HB2 GLU    14      -3.361   5.878  -6.573  1.00  1.00          
ATOM    210  CG  GLU    14      -4.688   6.541  -5.055  1.00  1.00          
ATOM    211  HG1 GLU    14      -4.184   5.982  -4.281  1.00  1.00          
ATOM    212  HG2 GLU    14      -5.752   6.539  -4.866  1.00  1.00          
ATOM    213  CD  GLU    14      -4.193   7.975  -5.018  1.00  1.00          
ATOM    214  OE1 GLU    14      -4.994   8.888  -5.307  1.00  1.00          
ATOM    215  OE2 GLU    14      -3.003   8.183  -4.699  1.00  1.00          
ATOM    216  C   GLU    14      -5.129   4.058  -8.000  1.00  1.00          
ATOM    217  O   GLU    14      -6.217   4.314  -8.541  1.00  1.00          
ATOM    218  N   GLU    15      -4.055   3.473  -8.649  1.00  1.00          
ATOM    219  HN  GLU    15      -3.230   3.319  -8.128  1.00  1.00          
ATOM    220  CA  GLU    15      -4.048   3.031 -10.086  1.00  1.00          
ATOM    221  HA  GLU    15      -4.509   3.819 -10.662  1.00  1.00          
ATOM    222  CB  GLU    15      -2.604   2.844 -10.589  1.00  1.00          
ATOM    223  HB1 GLU    15      -2.622   2.205 -11.460  1.00  1.00          
ATOM    224  HB2 GLU    15      -2.029   2.360  -9.813  1.00  1.00          
ATOM    225  CG  GLU    15      -1.895   4.143 -10.965  1.00  1.00          
ATOM    226  HG1 GLU    15      -1.851   4.779 -10.092  1.00  1.00          
ATOM    227  HG2 GLU    15      -2.462   4.638 -11.739  1.00  1.00          
ATOM    228  CD  GLU    15      -0.482   3.918 -11.472  1.00  1.00          
ATOM    229  OE1 GLU    15      -0.304   3.799 -12.703  1.00  1.00          
ATOM    230  OE2 GLU    15       0.448   3.863 -10.638  1.00  1.00          
ATOM    231  C   GLU    15      -4.856   1.726 -10.327  1.00  1.00          
ATOM    232  O   GLU    15      -5.487   1.583 -11.386  1.00  1.00          
ATOM    233  N   LEU    16      -4.815   0.793  -9.313  1.00  1.00          
ATOM    234  HN  LEU    16      -4.272   1.013  -8.527  1.00  1.00          
ATOM    235  CA  LEU    16      -5.531  -0.525  -9.302  1.00  1.00          
ATOM    236  HA  LEU    16      -5.286  -1.030 -10.224  1.00  1.00          
ATOM    237  CB  LEU    16      -5.014  -1.371  -8.126  1.00  1.00          
ATOM    238  HB1 LEU    16      -5.761  -2.115  -7.894  1.00  1.00          
ATOM    239  HB2 LEU    16      -4.901  -0.721  -7.271  1.00  1.00          
ATOM    240  CG  LEU    16      -3.682  -2.089  -8.365  1.00  1.00          
ATOM    241  HG  LEU    16      -3.230  -1.706  -9.269  1.00  1.00          
ATOM    242  CD1 LEU    16      -2.723  -1.829  -7.213  1.00  1.00          
ATOM    243 HD11 LEU    16      -2.434  -0.789  -7.217  1.00  1.00          
ATOM    244 HD12 LEU    16      -1.845  -2.446  -7.329  1.00  1.00          
ATOM    245 HD13 LEU    16      -3.209  -2.064  -6.275  1.00  1.00          
ATOM    246  CD2 LEU    16      -3.906  -3.581  -8.543  1.00  1.00          
ATOM    247 HD21 LEU    16      -4.651  -3.744  -9.307  1.00  1.00          
ATOM    248 HD22 LEU    16      -4.247  -4.007  -7.610  1.00  1.00          
ATOM    249 HD23 LEU    16      -2.980  -4.051  -8.836  1.00  1.00          
ATOM    250  C   LEU    16      -7.082  -0.392  -9.222  1.00  1.00          
ATOM    251  O   LEU    16      -7.797  -1.152  -9.894  1.00  1.00          
ATOM    252  N   ILE    17      -7.564   0.589  -8.376  1.00  1.00          
ATOM    253  HN  ILE    17      -6.905   1.114  -7.878  1.00  1.00          
ATOM    254  CA  ILE    17      -9.021   0.920  -8.154  1.00  1.00          
ATOM    255  HA  ILE    17      -9.547  -0.023  -8.086  1.00  1.00          
ATOM    256  CB  ILE    17      -9.283   1.731  -6.766  1.00  1.00          
ATOM    257  HB  ILE    17      -9.012   2.758  -6.972  1.00  1.00          
ATOM    258  CG1 ILE    17      -8.423   1.252  -5.486  1.00  1.00          
ATOM    259 HG11 ILE    17      -8.829   1.751  -4.615  1.00  1.00          
ATOM    260 HG12 ILE    17      -7.411   1.598  -5.620  1.00  1.00          
ATOM    261  CG2 ILE    17     -10.798   1.759  -6.372  1.00  1.00          
ATOM    262 HG21 ILE    17     -11.113   0.765  -6.095  1.00  1.00          
ATOM    263 HG22 ILE    17     -11.380   2.095  -7.220  1.00  1.00          
ATOM    264 HG23 ILE    17     -10.945   2.433  -5.542  1.00  1.00          
ATOM    265  CD1 ILE    17      -8.315  -0.266  -5.133  1.00  1.00          
ATOM    266 HD11 ILE    17      -8.367  -0.391  -4.061  1.00  1.00          
ATOM    267 HD12 ILE    17      -7.375  -0.655  -5.494  1.00  1.00          
ATOM    268 HD13 ILE    17      -9.128  -0.801  -5.599  1.00  1.00          
ATOM    269  C   ILE    17      -9.605   1.706  -9.392  1.00  1.00          
ATOM    270  O   ILE    17     -10.742   1.429  -9.806  1.00  1.00          
ATOM    271  N   GLU    18      -8.789   2.673  -9.944  1.00  1.00          
ATOM    272  HN  GLU    18      -7.909   2.811  -9.536  1.00  1.00          
ATOM    273  CA  GLU    18      -9.137   3.532 -11.124  1.00  1.00          
ATOM    274  HA  GLU    18     -10.094   3.986 -10.916  1.00  1.00          
ATOM    275  CB  GLU    18      -8.092   4.649 -11.264  1.00  1.00          
ATOM    276  HB1 GLU    18      -7.478   4.443 -12.126  1.00  1.00          
ATOM    277  HB2 GLU    18      -7.468   4.653 -10.384  1.00  1.00          
ATOM    278  CG  GLU    18      -8.691   6.039 -11.426  1.00  1.00          
ATOM    279  HG1 GLU    18      -9.296   6.259 -10.558  1.00  1.00          
ATOM    280  HG2 GLU    18      -9.313   6.049 -12.308  1.00  1.00          
ATOM    281  CD  GLU    18      -7.632   7.113 -11.566  1.00  1.00          
ATOM    282  OE1 GLU    18      -7.356   7.526 -12.712  1.00  1.00          
ATOM    283  OE2 GLU    18      -7.077   7.544 -10.532  1.00  1.00          
ATOM    284  C   GLU    18      -9.252   2.738 -12.462  1.00  1.00          
ATOM    285  O   GLU    18     -10.109   3.070 -13.297  1.00  1.00          
ATOM    286  N   GLU    19      -8.371   1.695 -12.623  1.00  1.00          
ATOM    287  HN  GLU    19      -7.726   1.518 -11.907  1.00  1.00          
ATOM    288  CA  GLU    19      -8.326   0.776 -13.795  1.00  1.00          
ATOM    289  HA  GLU    19      -8.483   1.363 -14.687  1.00  1.00          
ATOM    290  CB  GLU    19      -6.951   0.112 -13.876  1.00  1.00          
ATOM    291  HB1 GLU    19      -7.044  -0.762 -14.480  1.00  1.00          
ATOM    292  HB2 GLU    19      -6.669  -0.194 -12.881  1.00  1.00          
ATOM    293  CG  GLU    19      -5.837   0.985 -14.458  1.00  1.00          
ATOM    294  HG1 GLU    19      -5.715   1.857 -13.831  1.00  1.00          
ATOM    295  HG2 GLU    19      -6.124   1.295 -15.452  1.00  1.00          
ATOM    296  CD  GLU    19      -4.511   0.255 -14.541  1.00  1.00          
ATOM    297  OE1 GLU    19      -3.762   0.268 -13.542  1.00  1.00          
ATOM    298  OE2 GLU    19      -4.221  -0.332 -15.606  1.00  1.00          
ATOM    299  C   GLU    19      -9.394  -0.352 -13.738  1.00  1.00          
ATOM    300  O   GLU    19      -9.772  -0.895 -14.796  1.00  1.00          
ATOM    301  N   MET    20      -9.869  -0.662 -12.495  1.00  1.00          
ATOM    302  HN  MET    20      -9.596  -0.098 -11.738  1.00  1.00          
ATOM    303  CA  MET    20     -10.851  -1.732 -12.224  1.00  1.00          
ATOM    304  HA  MET    20     -10.869  -2.350 -13.108  1.00  1.00          
ATOM    305  CB  MET    20     -10.362  -2.600 -11.039  1.00  1.00          
ATOM    306  HB1 MET    20     -11.204  -3.141 -10.644  1.00  1.00          
ATOM    307  HB2 MET    20      -9.976  -1.948 -10.271  1.00  1.00          
ATOM    308  CG  MET    20      -9.271  -3.611 -11.399  1.00  1.00          
ATOM    309  HG1 MET    20      -8.427  -3.078 -11.810  1.00  1.00          
ATOM    310  HG2 MET    20      -9.661  -4.290 -12.143  1.00  1.00          
ATOM    311  SD  MET    20      -8.712  -4.575  -9.980  1.00  1.00          
ATOM    312  CE  MET    20      -9.788  -6.004 -10.086  1.00  1.00          
ATOM    313  HE1 MET    20      -9.826  -6.498  -9.128  1.00  1.00          
ATOM    314  HE2 MET    20      -9.405  -6.688 -10.829  1.00  1.00          
ATOM    315  HE3 MET    20     -10.781  -5.687 -10.369  1.00  1.00          
ATOM    316  C   MET    20     -12.301  -1.185 -11.975  1.00  1.00          
ATOM    317  O   MET    20     -13.238  -1.979 -11.741  1.00  1.00          
ATOM    318  N   LEU    21     -12.478   0.177 -12.072  1.00  1.00          
ATOM    319  HN  LEU    21     -11.693   0.723 -12.292  1.00  1.00          
ATOM    320  CA  LEU    21     -13.782   0.887 -11.867  1.00  1.00          
ATOM    321  HA  LEU    21     -14.289   0.374 -11.064  1.00  1.00          
ATOM    322  CB  LEU    21     -13.467   2.336 -11.407  1.00  1.00          
ATOM    323  HB1 LEU    21     -13.584   2.989 -12.261  1.00  1.00          
ATOM    324  HB2 LEU    21     -12.435   2.372 -11.093  1.00  1.00          
ATOM    325  CG  LEU    21     -14.335   2.892 -10.262  1.00  1.00          
ATOM    326  HG  LEU    21     -15.254   2.327 -10.201  1.00  1.00          
ATOM    327  CD1 LEU    21     -13.620   2.772  -8.918  1.00  1.00          
ATOM    328 HD11 LEU    21     -12.795   3.469  -8.885  1.00  1.00          
ATOM    329 HD12 LEU    21     -13.246   1.766  -8.798  1.00  1.00          
ATOM    330 HD13 LEU    21     -14.313   2.996  -8.120  1.00  1.00          
ATOM    331  CD2 LEU    21     -14.700   4.342 -10.537  1.00  1.00          
ATOM    332 HD21 LEU    21     -15.350   4.393 -11.397  1.00  1.00          
ATOM    333 HD22 LEU    21     -13.801   4.908 -10.730  1.00  1.00          
ATOM    334 HD23 LEU    21     -15.207   4.754  -9.677  1.00  1.00          
ATOM    335  C   LEU    21     -14.727   0.863 -13.135  1.00  1.00          
ATOM    336  O   LEU    21     -15.767   1.563 -13.176  1.00  1.00          
ATOM    337  N   ILE    22     -14.367  -0.011 -14.121  1.00  1.00          
ATOM    338  HN  ILE    22     -13.573  -0.559 -13.970  1.00  1.00          
ATOM    339  CA  ILE    22     -15.104  -0.215 -15.411  1.00  1.00          
ATOM    340  HA  ILE    22     -15.610   0.719 -15.613  1.00  1.00          
ATOM    341  CB  ILE    22     -14.139  -0.497 -16.648  1.00  1.00          
ATOM    342  HB  ILE    22     -14.761  -0.873 -17.439  1.00  1.00          
ATOM    343  CG1 ILE    22     -12.992  -1.534 -16.396  1.00  1.00          
ATOM    344 HG11 ILE    22     -13.044  -1.877 -15.372  1.00  1.00          
ATOM    345 HG12 ILE    22     -12.038  -1.053 -16.559  1.00  1.00          
ATOM    346  CG2 ILE    22     -13.533   0.810 -17.141  1.00  1.00          
ATOM    347 HG21 ILE    22     -12.992   1.277 -16.331  1.00  1.00          
ATOM    348 HG22 ILE    22     -14.317   1.471 -17.478  1.00  1.00          
ATOM    349 HG23 ILE    22     -12.856   0.608 -17.957  1.00  1.00          
ATOM    350  CD1 ILE    22     -13.061  -2.746 -17.301  1.00  1.00          
ATOM    351 HD11 ILE    22     -12.869  -2.447 -18.322  1.00  1.00          
ATOM    352 HD12 ILE    22     -14.045  -3.187 -17.235  1.00  1.00          
ATOM    353 HD13 ILE    22     -12.320  -3.470 -16.994  1.00  1.00          
ATOM    354  C   ILE    22     -16.215  -1.322 -15.323  1.00  1.00          
ATOM    355  O   ILE    22     -17.017  -1.469 -16.268  1.00  1.00          
ATOM    356  N   ILE    23     -16.246  -2.055 -14.171  1.00  1.00          
ATOM    357  HN  ILE    23     -15.585  -1.830 -13.484  1.00  1.00          
ATOM    358  CA  ILE    23     -17.214  -3.161 -13.879  1.00  1.00          
ATOM    359  HA  ILE    23     -17.643  -3.471 -14.825  1.00  1.00          
ATOM    360  CB  ILE    23     -16.551  -4.456 -13.175  1.00  1.00          
ATOM    361  HB  ILE    23     -16.448  -4.234 -12.120  1.00  1.00          
ATOM    362  CG1 ILE    23     -15.152  -4.836 -13.744  1.00  1.00          
ATOM    363 HG11 ILE    23     -14.885  -4.128 -14.517  1.00  1.00          
ATOM    364 HG12 ILE    23     -15.205  -5.823 -14.174  1.00  1.00          
ATOM    365  CG2 ILE    23     -17.446  -5.719 -13.302  1.00  1.00          
ATOM    366 HG21 ILE    23     -17.422  -6.076 -14.321  1.00  1.00          
ATOM    367 HG22 ILE    23     -18.461  -5.469 -13.032  1.00  1.00          
ATOM    368 HG23 ILE    23     -17.079  -6.490 -12.640  1.00  1.00          
ATOM    369  CD1 ILE    23     -14.038  -4.841 -12.711  1.00  1.00          
ATOM    370 HD11 ILE    23     -14.212  -5.629 -11.994  1.00  1.00          
ATOM    371 HD12 ILE    23     -14.012  -3.887 -12.201  1.00  1.00          
ATOM    372 HD13 ILE    23     -13.090  -5.007 -13.204  1.00  1.00          
ATOM    373  C   ILE    23     -18.357  -2.596 -12.990  1.00  1.00          
ATOM    374  O   ILE    23     -18.095  -1.832 -12.042  1.00  1.00          
ATOM    375  N   GLU    24     -19.615  -3.011 -13.335  1.00  1.00          
ATOM    376  HN  GLU    24     -19.700  -3.609 -14.107  1.00  1.00          
ATOM    377  CA  GLU    24     -20.878  -2.622 -12.613  1.00  1.00          
ATOM    378  HA  GLU    24     -20.795  -1.568 -12.408  1.00  1.00          
ATOM    379  CB  GLU    24     -22.112  -2.847 -13.495  1.00  1.00          
ATOM    380  HB1 GLU    24     -22.982  -2.924 -12.859  1.00  1.00          
ATOM    381  HB2 GLU    24     -21.989  -3.775 -14.032  1.00  1.00          
ATOM    382  CG  GLU    24     -22.360  -1.739 -14.511  1.00  1.00          
ATOM    383  HG1 GLU    24     -21.510  -1.680 -15.176  1.00  1.00          
ATOM    384  HG2 GLU    24     -22.468  -0.802 -13.983  1.00  1.00          
ATOM    385  CD  GLU    24     -23.610  -1.974 -15.337  1.00  1.00          
ATOM    386  OE1 GLU    24     -23.513  -2.654 -16.379  1.00  1.00          
ATOM    387  OE2 GLU    24     -24.686  -1.479 -14.939  1.00  1.00          
ATOM    388  C   GLU    24     -21.069  -3.339 -11.252  1.00  1.00          
ATOM    389  O   GLU    24     -21.730  -2.783 -10.360  1.00  1.00          
ATOM    390  N   ASN    25     -20.478  -4.575 -11.123  1.00  1.00          
ATOM    391  HN  ASN    25     -20.016  -4.937 -11.907  1.00  1.00          
ATOM    392  CA  ASN    25     -20.485  -5.413  -9.877  1.00  1.00          
ATOM    393  HA  ASN    25     -21.503  -5.455  -9.519  1.00  1.00          
ATOM    394  CB  ASN    25     -20.018  -6.835 -10.202  1.00  1.00          
ATOM    395  HB1 ASN    25     -19.629  -7.294  -9.305  1.00  1.00          
ATOM    396  HB2 ASN    25     -19.237  -6.792 -10.946  1.00  1.00          
ATOM    397  CG  ASN    25     -21.139  -7.703 -10.735  1.00  1.00          
ATOM    398  OD1 ASN    25     -21.366  -7.775 -11.943  1.00  1.00          
ATOM    399  ND2 ASN    25     -21.847  -8.370  -9.832  1.00  1.00          
ATOM    400 HD21 ASN    25     -21.609  -8.265  -8.887  1.00  1.00          
ATOM    401 HD22 ASN    25     -22.580  -8.940 -10.146  1.00  1.00          
ATOM    402  C   ASN    25     -19.587  -4.826  -8.745  1.00  1.00          
ATOM    403  O   ASN    25     -19.800  -5.128  -7.561  1.00  1.00          
ATOM    404  N   PHE    26     -18.579  -3.974  -9.164  1.00  1.00          
ATOM    405  HN  PHE    26     -18.479  -3.886 -10.131  1.00  1.00          
ATOM    406  CA  PHE    26     -17.585  -3.264  -8.287  1.00  1.00          
ATOM    407  HA  PHE    26     -17.010  -4.031  -7.794  1.00  1.00          
ATOM    408  CB  PHE    26     -16.615  -2.431  -9.145  1.00  1.00          
ATOM    409  HB1 PHE    26     -16.916  -1.401  -9.104  1.00  1.00          
ATOM    410  HB2 PHE    26     -16.679  -2.767 -10.166  1.00  1.00          
ATOM    411  CG  PHE    26     -15.159  -2.522  -8.700  1.00  1.00          
ATOM    412  CD1 PHE    26     -14.630  -1.587  -7.813  1.00  1.00          
ATOM    413  HD1 PHE    26     -15.259  -0.786  -7.451  1.00  1.00          
ATOM    414  CD2 PHE    26     -14.325  -3.548  -9.152  1.00  1.00          
ATOM    415  HD2 PHE    26     -14.718  -4.283  -9.840  1.00  1.00          
ATOM    416  CE1 PHE    26     -13.316  -1.672  -7.392  1.00  1.00          
ATOM    417  HE1 PHE    26     -12.922  -0.940  -6.702  1.00  1.00          
ATOM    418  CE2 PHE    26     -13.012  -3.634  -8.730  1.00  1.00          
ATOM    419  HE2 PHE    26     -12.384  -4.438  -9.082  1.00  1.00          
ATOM    420  CZ  PHE    26     -12.508  -2.696  -7.849  1.00  1.00          
ATOM    421  HZ  PHE    26     -11.480  -2.761  -7.520  1.00  1.00          
ATOM    422  C   PHE    26     -18.221  -2.379  -7.186  1.00  1.00          
ATOM    423  O   PHE    26     -17.657  -2.266  -6.085  1.00  1.00          
ATOM    424  N   GLU    27     -19.401  -1.766  -7.527  1.00  1.00          
ATOM    425  HN  GLU    27     -19.712  -1.879  -8.450  1.00  1.00          
ATOM    426  CA  GLU    27     -20.248  -0.926  -6.599  1.00  1.00          
ATOM    427  HA  GLU    27     -19.621  -0.140  -6.211  1.00  1.00          
ATOM    428  CB  GLU    27     -21.426  -0.290  -7.359  1.00  1.00          
ATOM    429  HB1 GLU    27     -22.166   0.029  -6.640  1.00  1.00          
ATOM    430  HB2 GLU    27     -21.866  -1.036  -8.002  1.00  1.00          
ATOM    431  CG  GLU    27     -21.055   0.915  -8.220  1.00  1.00          
ATOM    432  HG1 GLU    27     -20.294   0.616  -8.927  1.00  1.00          
ATOM    433  HG2 GLU    27     -20.662   1.691  -7.579  1.00  1.00          
ATOM    434  CD  GLU    27     -22.238   1.474  -8.985  1.00  1.00          
ATOM    435  OE1 GLU    27     -22.504   0.988 -10.104  1.00  1.00          
ATOM    436  OE2 GLU    27     -22.900   2.396  -8.465  1.00  1.00          
ATOM    437  C   GLU    27     -20.810  -1.753  -5.397  1.00  1.00          
ATOM    438  O   GLU    27     -21.054  -1.194  -4.316  1.00  1.00          
ATOM    439  N   GLU    28     -20.997  -3.093  -5.650  1.00  1.00          
ATOM    440  HN  GLU    28     -20.774  -3.414  -6.558  1.00  1.00          
ATOM    441  CA  GLU    28     -21.472  -4.102  -4.659  1.00  1.00          
ATOM    442  HA  GLU    28     -22.153  -3.600  -3.987  1.00  1.00          
ATOM    443  CB  GLU    28     -22.229  -5.230  -5.379  1.00  1.00          
ATOM    444  HB1 GLU    28     -22.140  -6.133  -4.791  1.00  1.00          
ATOM    445  HB2 GLU    28     -21.762  -5.395  -6.343  1.00  1.00          
ATOM    446  CG  GLU    28     -23.724  -4.942  -5.591  1.00  1.00          
ATOM    447  HG1 GLU    28     -24.047  -5.388  -6.524  1.00  1.00          
ATOM    448  HG2 GLU    28     -23.864  -3.873  -5.642  1.00  1.00          
ATOM    449  CD  GLU    28     -24.602  -5.487  -4.473  1.00  1.00          
ATOM    450  OE1 GLU    28     -24.852  -6.711  -4.457  1.00  1.00          
ATOM    451  OE2 GLU    28     -25.035  -4.688  -3.616  1.00  1.00          
ATOM    452  C   GLU    28     -20.313  -4.697  -3.816  1.00  1.00          
ATOM    453  O   GLU    28     -20.512  -4.990  -2.625  1.00  1.00          
ATOM    454  N   ILE    29     -19.100  -4.858  -4.465  1.00  1.00          
ATOM    455  HN  ILE    29     -19.056  -4.577  -5.402  1.00  1.00          
ATOM    456  CA  ILE    29     -17.826  -5.391  -3.839  1.00  1.00          
ATOM    457  HA  ILE    29     -18.119  -6.251  -3.247  1.00  1.00          
ATOM    458  CB  ILE    29     -16.741  -5.905  -4.933  1.00  1.00          
ATOM    459  HB  ILE    29     -16.436  -5.047  -5.515  1.00  1.00          
ATOM    460  CG1 ILE    29     -17.347  -6.982  -5.891  1.00  1.00          
ATOM    461 HG11 ILE    29     -18.421  -6.990  -5.770  1.00  1.00          
ATOM    462 HG12 ILE    29     -16.959  -7.948  -5.606  1.00  1.00          
ATOM    463  CG2 ILE    29     -15.462  -6.544  -4.282  1.00  1.00          
ATOM    464 HG21 ILE    29     -14.576  -6.253  -4.832  1.00  1.00          
ATOM    465 HG22 ILE    29     -15.553  -7.620  -4.293  1.00  1.00          
ATOM    466 HG23 ILE    29     -15.380  -6.204  -3.259  1.00  1.00          
ATOM    467  CD1 ILE    29     -17.050  -6.801  -7.383  1.00  1.00          
ATOM    468 HD11 ILE    29     -16.128  -6.252  -7.511  1.00  1.00          
ATOM    469 HD12 ILE    29     -17.859  -6.262  -7.849  1.00  1.00          
ATOM    470 HD13 ILE    29     -16.953  -7.772  -7.848  1.00  1.00          
ATOM    471  C   ILE    29     -17.214  -4.327  -2.842  1.00  1.00          
ATOM    472  O   ILE    29     -16.719  -4.716  -1.772  1.00  1.00          
ATOM    473  N   VAL    30     -17.268  -3.006  -3.232  1.00  1.00          
ATOM    474  HN  VAL    30     -17.681  -2.807  -4.098  1.00  1.00          
ATOM    475  CA  VAL    30     -16.734  -1.828  -2.423  1.00  1.00          
ATOM    476  HA  VAL    30     -15.699  -2.078  -2.227  1.00  1.00          
ATOM    477  CB  VAL    30     -16.721  -0.442  -3.218  1.00  1.00          
ATOM    478  HB  VAL    30     -16.463   0.331  -2.501  1.00  1.00          
ATOM    479  CG1 VAL    30     -15.615  -0.442  -4.273  1.00  1.00          
ATOM    480 HG11 VAL    30     -15.795  -1.240  -4.979  1.00  1.00          
ATOM    481 HG12 VAL    30     -14.659  -0.591  -3.794  1.00  1.00          
ATOM    482 HG13 VAL    30     -15.614   0.505  -4.794  1.00  1.00          
ATOM    483  CG2 VAL    30     -18.069  -0.038  -3.897  1.00  1.00          
ATOM    484 HG21 VAL    30     -18.619  -0.929  -4.165  1.00  1.00          
ATOM    485 HG22 VAL    30     -17.860   0.536  -4.785  1.00  1.00          
ATOM    486 HG23 VAL    30     -18.665   0.560  -3.215  1.00  1.00          
ATOM    487  C   VAL    30     -17.415  -1.633  -1.014  1.00  1.00          
ATOM    488  O   VAL    30     -16.859  -0.932  -0.153  1.00  1.00          
ATOM    489  N   LYS    31     -18.636  -2.226  -0.863  1.00  1.00          
ATOM    490  HN  LYS    31     -19.028  -2.656  -1.650  1.00  1.00          
ATOM    491  CA  LYS    31     -19.444  -2.219   0.392  1.00  1.00          
ATOM    492  HA  LYS    31     -19.268  -1.274   0.885  1.00  1.00          
ATOM    493  CB  LYS    31     -20.940  -2.313   0.040  1.00  1.00          
ATOM    494  HB1 LYS    31     -21.470  -2.734   0.881  1.00  1.00          
ATOM    495  HB2 LYS    31     -21.052  -2.971  -0.812  1.00  1.00          
ATOM    496  CG  LYS    31     -21.584  -0.977  -0.315  1.00  1.00          
ATOM    497  HG1 LYS    31     -21.051  -0.540  -1.148  1.00  1.00          
ATOM    498  HG2 LYS    31     -21.524  -0.319   0.538  1.00  1.00          
ATOM    499  CD  LYS    31     -23.045  -1.151  -0.700  1.00  1.00          
ATOM    500  HD1 LYS    31     -23.576  -1.590   0.132  1.00  1.00          
ATOM    501  HD2 LYS    31     -23.107  -1.807  -1.556  1.00  1.00          
ATOM    502  CE  LYS    31     -23.687   0.179  -1.051  1.00  1.00          
ATOM    503  HE1 LYS    31     -23.146   0.619  -1.876  1.00  1.00          
ATOM    504  HE2 LYS    31     -23.625   0.831  -0.192  1.00  1.00          
ATOM    505  NZ  LYS    31     -25.115   0.020  -1.436  1.00  1.00          
ATOM    506  HZ1 LYS    31     -25.704   0.696  -0.909  1.00  1.00          
ATOM    507  HZ2 LYS    31     -25.437  -0.944  -1.220  1.00  1.00          
ATOM    508  HZ3 LYS    31     -25.232   0.194  -2.454  1.00  1.00          
ATOM    509  C   LYS    31     -19.066  -3.363   1.384  1.00  1.00          
ATOM    510  O   LYS    31     -19.371  -3.241   2.589  1.00  1.00          
ATOM    511  N   ASP    32     -18.396  -4.444   0.865  1.00  1.00          
ATOM    512  HN  ASP    32     -18.170  -4.432  -0.083  1.00  1.00          
ATOM    513  CA  ASP    32     -17.971  -5.618   1.658  1.00  1.00          
ATOM    514  HA  ASP    32     -18.111  -5.363   2.699  1.00  1.00          
ATOM    515  CB  ASP    32     -18.850  -6.851   1.334  1.00  1.00          
ATOM    516  HB1 ASP    32     -18.332  -7.743   1.651  1.00  1.00          
ATOM    517  HB2 ASP    32     -19.015  -6.897   0.269  1.00  1.00          
ATOM    518  CG  ASP    32     -20.200  -6.811   2.024  1.00  1.00          
ATOM    519  OD1 ASP    32     -20.245  -7.024   3.253  1.00  1.00          
ATOM    520  OD2 ASP    32     -21.210  -6.566   1.333  1.00  1.00          
ATOM    521  C   ASP    32     -16.477  -5.937   1.447  1.00  1.00          
ATOM    522  O   ASP    32     -16.038  -6.313   0.338  1.00  1.00          
ATOM    523  N   ARG    33     -15.696  -5.696   2.541  1.00  1.00          
ATOM    524  HN  ARG    33     -16.114  -5.203   3.272  1.00  1.00          
ATOM    525  CA  ARG    33     -14.203  -5.966   2.657  1.00  1.00          
ATOM    526  HA  ARG    33     -13.747  -5.429   1.839  1.00  1.00          
ATOM    527  CB  ARG    33     -13.602  -5.390   3.997  1.00  1.00          
ATOM    528  HB1 ARG    33     -13.539  -4.316   3.898  1.00  1.00          
ATOM    529  HB2 ARG    33     -12.598  -5.775   4.096  1.00  1.00          
ATOM    530  CG  ARG    33     -14.364  -5.685   5.329  1.00  1.00          
ATOM    531  HG1 ARG    33     -13.681  -6.081   6.070  1.00  1.00          
ATOM    532  HG2 ARG    33     -15.143  -6.407   5.134  1.00  1.00          
ATOM    533  CD  ARG    33     -14.998  -4.414   5.870  1.00  1.00          
ATOM    534  HD1 ARG    33     -15.615  -3.981   5.098  1.00  1.00          
ATOM    535  HD2 ARG    33     -14.211  -3.721   6.131  1.00  1.00          
ATOM    536  NE  ARG    33     -15.833  -4.661   7.070  1.00  1.00          
ATOM    537  HE  ARG    33     -15.828  -5.580   7.413  1.00  1.00          
ATOM    538  CZ  ARG    33     -16.606  -3.750   7.740  1.00  1.00          
ATOM    539  NH1 ARG    33     -16.704  -2.449   7.390  1.00  1.00          
ATOM    540 HH11 ARG    33     -16.194  -2.102   6.603  1.00  1.00          
ATOM    541 HH12 ARG    33     -17.284  -1.831   7.920  1.00  1.00          
ATOM    542  NH2 ARG    33     -17.294  -4.164   8.792  1.00  1.00          
ATOM    543 HH21 ARG    33     -17.242  -5.121   9.077  1.00  1.00          
ATOM    544 HH22 ARG    33     -17.866  -3.520   9.300  1.00  1.00          
ATOM    545  C   ARG    33     -13.775  -7.453   2.472  1.00  1.00          
ATOM    546  O   ARG    33     -12.675  -7.709   1.954  1.00  1.00          
ATOM    547  N   GLU    34     -14.667  -8.401   2.897  1.00  1.00          
ATOM    548  HN  GLU    34     -15.495  -8.092   3.316  1.00  1.00          
ATOM    549  CA  GLU    34     -14.475  -9.886   2.784  1.00  1.00          
ATOM    550  HA  GLU    34     -13.504 -10.117   3.193  1.00  1.00          
ATOM    551  CB  GLU    34     -15.540 -10.592   3.625  1.00  1.00          
ATOM    552  HB1 GLU    34     -16.262 -11.039   2.963  1.00  1.00          
ATOM    553  HB2 GLU    34     -16.036  -9.854   4.236  1.00  1.00          
ATOM    554  CG  GLU    34     -14.990 -11.675   4.546  1.00  1.00          
ATOM    555  HG1 GLU    34     -14.239 -11.239   5.188  1.00  1.00          
ATOM    556  HG2 GLU    34     -14.541 -12.449   3.942  1.00  1.00          
ATOM    557  CD  GLU    34     -16.066 -12.303   5.413  1.00  1.00          
ATOM    558  OE1 GLU    34     -16.255 -11.841   6.559  1.00  1.00          
ATOM    559  OE2 GLU    34     -16.719 -13.259   4.945  1.00  1.00          
ATOM    560  C   GLU    34     -14.514 -10.404   1.313  1.00  1.00          
ATOM    561  O   GLU    34     -13.832 -11.393   0.994  1.00  1.00          
ATOM    562  N   ARG    35     -15.331  -9.710   0.452  1.00  1.00          
ATOM    563  HN  ARG    35     -15.848  -8.961   0.818  1.00  1.00          
ATOM    564  CA  ARG    35     -15.478  -9.994  -1.009  1.00  1.00          
ATOM    565  HA  ARG    35     -15.418 -11.066  -1.131  1.00  1.00          
ATOM    566  CB  ARG    35     -16.844  -9.520  -1.541  1.00  1.00          
ATOM    567  HB1 ARG    35     -16.792  -9.468  -2.618  1.00  1.00          
ATOM    568  HB2 ARG    35     -17.038  -8.531  -1.156  1.00  1.00          
ATOM    569  CG  ARG    35     -18.031 -10.418  -1.163  1.00  1.00          
ATOM    570  HG1 ARG    35     -18.078 -10.489  -0.085  1.00  1.00          
ATOM    571  HG2 ARG    35     -17.868 -11.400  -1.579  1.00  1.00          
ATOM    572  CD  ARG    35     -19.369  -9.878  -1.689  1.00  1.00          
ATOM    573  HD1 ARG    35     -19.407  -8.815  -1.500  1.00  1.00          
ATOM    574  HD2 ARG    35     -20.176 -10.363  -1.158  1.00  1.00          
ATOM    575  NE  ARG    35     -19.561 -10.110  -3.154  1.00  1.00          
ATOM    576  HE  ARG    35     -18.986 -10.795  -3.555  1.00  1.00          
ATOM    577  CZ  ARG    35     -20.439  -9.469  -3.988  1.00  1.00          
ATOM    578  NH1 ARG    35     -21.296  -8.515  -3.576  1.00  1.00          
ATOM    579 HH11 ARG    35     -21.313  -8.240  -2.614  1.00  1.00          
ATOM    580 HH12 ARG    35     -21.916  -8.082  -4.230  1.00  1.00          
ATOM    581  NH2 ARG    35     -20.453  -9.807  -5.271  1.00  1.00          
ATOM    582 HH21 ARG    35     -19.831 -10.513  -5.608  1.00  1.00          
ATOM    583 HH22 ARG    35     -21.085  -9.354  -5.900  1.00  1.00          
ATOM    584  C   ARG    35     -14.353  -9.351  -1.865  1.00  1.00          
ATOM    585  O   ARG    35     -13.937  -9.953  -2.870  1.00  1.00          
ATOM    586  N   PHE    36     -13.872  -8.120  -1.439  1.00  1.00          
ATOM    587  HN  PHE    36     -14.272  -7.734  -0.632  1.00  1.00          
ATOM    588  CA  PHE    36     -12.788  -7.335  -2.119  1.00  1.00          
ATOM    589  HA  PHE    36     -13.032  -7.321  -3.175  1.00  1.00          
ATOM    590  CB  PHE    36     -12.768  -5.860  -1.604  1.00  1.00          
ATOM    591  HB1 PHE    36     -12.121  -5.808  -0.739  1.00  1.00          
ATOM    592  HB2 PHE    36     -13.766  -5.584  -1.306  1.00  1.00          
ATOM    593  CG  PHE    36     -12.276  -4.810  -2.611  1.00  1.00          
ATOM    594  CD1 PHE    36     -13.182  -4.017  -3.308  1.00  1.00          
ATOM    595  HD1 PHE    36     -14.239  -4.142  -3.138  1.00  1.00          
ATOM    596  CD2 PHE    36     -10.912  -4.619  -2.851  1.00  1.00          
ATOM    597  HD2 PHE    36     -10.191  -5.227  -2.322  1.00  1.00          
ATOM    598  CE1 PHE    36     -12.745  -3.066  -4.213  1.00  1.00          
ATOM    599  HE1 PHE    36     -13.462  -2.457  -4.749  1.00  1.00          
ATOM    600  CE2 PHE    36     -10.477  -3.670  -3.756  1.00  1.00          
ATOM    601  HE2 PHE    36      -9.420  -3.537  -3.933  1.00  1.00          
ATOM    602  CZ  PHE    36     -11.394  -2.894  -4.437  1.00  1.00          
ATOM    603  HZ  PHE    36     -11.055  -2.152  -5.144  1.00  1.00          
ATOM    604  C   PHE    36     -11.381  -7.994  -1.962  1.00  1.00          
ATOM    605  O   PHE    36     -10.656  -8.096  -2.957  1.00  1.00          
ATOM    606  N   LEU    37     -11.045  -8.465  -0.705  1.00  1.00          
ATOM    607  HN  LEU    37     -11.712  -8.391   0.008  1.00  1.00          
ATOM    608  CA  LEU    37      -9.748  -9.152  -0.357  1.00  1.00          
ATOM    609  HA  LEU    37      -8.952  -8.547  -0.765  1.00  1.00          
ATOM    610  CB  LEU    37      -9.569  -9.231   1.169  1.00  1.00          
ATOM    611  HB1 LEU    37      -8.934 -10.076   1.387  1.00  1.00          
ATOM    612  HB2 LEU    37     -10.538  -9.411   1.609  1.00  1.00          
ATOM    613  CG  LEU    37      -8.960  -7.990   1.838  1.00  1.00          
ATOM    614  HG  LEU    37      -9.017  -7.151   1.159  1.00  1.00          
ATOM    615  CD1 LEU    37      -9.735  -7.625   3.094  1.00  1.00          
ATOM    616 HD11 LEU    37      -9.264  -6.779   3.570  1.00  1.00          
ATOM    617 HD12 LEU    37      -9.736  -8.465   3.774  1.00  1.00          
ATOM    618 HD13 LEU    37     -10.751  -7.371   2.833  1.00  1.00          
ATOM    619  CD2 LEU    37      -7.493  -8.232   2.176  1.00  1.00          
ATOM    620 HD21 LEU    37      -7.421  -8.983   2.948  1.00  1.00          
ATOM    621 HD22 LEU    37      -7.048  -7.312   2.526  1.00  1.00          
ATOM    622 HD23 LEU    37      -6.971  -8.571   1.294  1.00  1.00          
ATOM    623  C   LEU    37      -9.625 -10.575  -0.974  1.00  1.00          
ATOM    624  O   LEU    37      -8.521 -10.988  -1.362  1.00  1.00          
ATOM    625  N   ALA    38     -10.798 -11.295  -1.035  1.00  1.00          
ATOM    626  HN  ALA    38     -11.594 -10.860  -0.661  1.00  1.00          
ATOM    627  CA  ALA    38     -10.947 -12.662  -1.630  1.00  1.00          
ATOM    628  HA  ALA    38     -10.133 -13.267  -1.257  1.00  1.00          
ATOM    629  CB  ALA    38     -12.249 -13.289  -1.162  1.00  1.00          
ATOM    630  HB1 ALA    38     -13.082 -12.721  -1.550  1.00  1.00          
ATOM    631  HB2 ALA    38     -12.280 -13.285  -0.084  1.00  1.00          
ATOM    632  HB3 ALA    38     -12.308 -14.305  -1.522  1.00  1.00          
ATOM    633  C   ALA    38     -10.885 -12.664  -3.184  1.00  1.00          
ATOM    634  O   ALA    38     -10.445 -13.661  -3.780  1.00  1.00          
ATOM    635  N   GLN    39     -11.334 -11.518  -3.802  1.00  1.00          
ATOM    636  HN  GLN    39     -11.679 -10.803  -3.227  1.00  1.00          
ATOM    637  CA  GLN    39     -11.334 -11.274  -5.273  1.00  1.00          
ATOM    638  HA  GLN    39     -11.622 -12.199  -5.749  1.00  1.00          
ATOM    639  CB  GLN    39     -12.363 -10.202  -5.635  1.00  1.00          
ATOM    640  HB1 GLN    39     -11.849  -9.350  -6.053  1.00  1.00          
ATOM    641  HB2 GLN    39     -12.880  -9.896  -4.736  1.00  1.00          
ATOM    642  CG  GLN    39     -13.400 -10.677  -6.644  1.00  1.00          
ATOM    643  HG1 GLN    39     -13.877 -11.568  -6.261  1.00  1.00          
ATOM    644  HG2 GLN    39     -12.897 -10.910  -7.571  1.00  1.00          
ATOM    645  CD  GLN    39     -14.469  -9.637  -6.925  1.00  1.00          
ATOM    646  OE1 GLN    39     -15.366  -9.414  -6.110  1.00  1.00          
ATOM    647  NE2 GLN    39     -14.376  -8.993  -8.084  1.00  1.00          
ATOM    648 HE21 GLN    39     -13.634  -9.222  -8.682  1.00  1.00          
ATOM    649 HE22 GLN    39     -15.051  -8.313  -8.293  1.00  1.00          
ATOM    650  C   GLN    39      -9.942 -10.870  -5.820  1.00  1.00          
ATOM    651  O   GLN    39      -9.610 -11.243  -6.947  1.00  1.00          
ATOM    652  N   VAL    40      -9.143 -10.104  -4.991  1.00  1.00          
ATOM    653  HN  VAL    40      -9.520  -9.838  -4.126  1.00  1.00          
ATOM    654  CA  VAL    40      -7.728  -9.640  -5.307  1.00  1.00          
ATOM    655  HA  VAL    40      -7.751  -9.261  -6.322  1.00  1.00          
ATOM    656  CB  VAL    40      -7.265  -8.421  -4.339  1.00  1.00          
ATOM    657  HB  VAL    40      -7.399  -8.743  -3.318  1.00  1.00          
ATOM    658  CG1 VAL    40      -5.795  -7.949  -4.503  1.00  1.00          
ATOM    659 HG11 VAL    40      -5.139  -8.808  -4.525  1.00  1.00          
ATOM    660 HG12 VAL    40      -5.525  -7.310  -3.674  1.00  1.00          
ATOM    661 HG13 VAL    40      -5.699  -7.397  -5.425  1.00  1.00          
ATOM    662  CG2 VAL    40      -8.144  -7.179  -4.545  1.00  1.00          
ATOM    663 HG21 VAL    40      -7.837  -6.403  -3.859  1.00  1.00          
ATOM    664 HG22 VAL    40      -9.177  -7.436  -4.359  1.00  1.00          
ATOM    665 HG23 VAL    40      -8.038  -6.826  -5.560  1.00  1.00          
ATOM    666  C   VAL    40      -6.740 -10.881  -5.289  1.00  1.00          
ATOM    667  O   VAL    40      -5.847 -10.964  -6.145  1.00  1.00          
ATOM    668  N   GLU    41      -6.948 -11.810  -4.291  1.00  1.00          
ATOM    669  HN  GLU    41      -7.679 -11.648  -3.658  1.00  1.00          
ATOM    670  CA  GLU    41      -6.156 -13.082  -4.095  1.00  1.00          
ATOM    671  HA  GLU    41      -5.108 -12.825  -4.137  1.00  1.00          
ATOM    672  CB  GLU    41      -6.452 -13.705  -2.709  1.00  1.00          
ATOM    673  HB1 GLU    41      -6.060 -14.711  -2.697  1.00  1.00          
ATOM    674  HB2 GLU    41      -7.523 -13.753  -2.579  1.00  1.00          
ATOM    675  CG  GLU    41      -5.870 -12.953  -1.514  1.00  1.00          
ATOM    676  HG1 GLU    41      -6.341 -11.983  -1.456  1.00  1.00          
ATOM    677  HG2 GLU    41      -4.807 -12.831  -1.658  1.00  1.00          
ATOM    678  CD  GLU    41      -6.102 -13.679  -0.203  1.00  1.00          
ATOM    679  OE1 GLU    41      -5.208 -14.441   0.221  1.00  1.00          
ATOM    680  OE2 GLU    41      -7.181 -13.490   0.398  1.00  1.00          
ATOM    681  C   GLU    41      -6.445 -14.160  -5.187  1.00  1.00          
ATOM    682  O   GLU    41      -5.529 -14.908  -5.569  1.00  1.00          
ATOM    683  N   GLU    42      -7.733 -14.199  -5.664  1.00  1.00          
ATOM    684  HN  GLU    42      -8.370 -13.556  -5.289  1.00  1.00          
ATOM    685  CA  GLU    42      -8.241 -15.144  -6.708  1.00  1.00          
ATOM    686  HA  GLU    42      -7.747 -16.091  -6.555  1.00  1.00          
ATOM    687  CB  GLU    42      -9.754 -15.348  -6.525  1.00  1.00          
ATOM    688  HB1 GLU    42     -10.174 -15.660  -7.470  1.00  1.00          
ATOM    689  HB2 GLU    42     -10.193 -14.399  -6.246  1.00  1.00          
ATOM    690  CG  GLU    42     -10.128 -16.400  -5.465  1.00  1.00          
ATOM    691  HG1 GLU    42     -11.041 -16.098  -4.963  1.00  1.00          
ATOM    692  HG2 GLU    42      -9.329 -16.457  -4.741  1.00  1.00          
ATOM    693  CD  GLU    42     -10.343 -17.788  -6.050  1.00  1.00          
ATOM    694  OE1 GLU    42     -11.404 -18.017  -6.671  1.00  1.00          
ATOM    695  OE2 GLU    42      -9.448 -18.645  -5.886  1.00  1.00          
ATOM    696  C   GLU    42      -7.966 -14.678  -8.166  1.00  1.00          
ATOM    697  O   GLU    42      -7.851 -15.532  -9.064  1.00  1.00          
ATOM    698  N   PHE    43      -7.863 -13.330  -8.362  1.00  1.00          
ATOM    699  HN  PHE    43      -7.937 -12.758  -7.569  1.00  1.00          
ATOM    700  CA  PHE    43      -7.604 -12.686  -9.673  1.00  1.00          
ATOM    701  HA  PHE    43      -7.862 -13.398 -10.445  1.00  1.00          
ATOM    702  CB  PHE    43      -8.487 -11.424  -9.835  1.00  1.00          
ATOM    703  HB1 PHE    43      -7.853 -10.550  -9.784  1.00  1.00          
ATOM    704  HB2 PHE    43      -9.194 -11.389  -9.022  1.00  1.00          
ATOM    705  CG  PHE    43      -9.276 -11.347 -11.127  1.00  1.00          
ATOM    706  CD1 PHE    43     -10.564 -11.868 -11.206  1.00  1.00          
ATOM    707  HD1 PHE    43     -10.997 -12.342 -10.337  1.00  1.00          
ATOM    708  CD2 PHE    43      -8.737 -10.740 -12.258  1.00  1.00          
ATOM    709  HD2 PHE    43      -7.740 -10.329 -12.214  1.00  1.00          
ATOM    710  CE1 PHE    43     -11.290 -11.788 -12.379  1.00  1.00          
ATOM    711  HE1 PHE    43     -12.288 -12.196 -12.425  1.00  1.00          
ATOM    712  CE2 PHE    43      -9.462 -10.660 -13.432  1.00  1.00          
ATOM    713  HE2 PHE    43      -9.031 -10.188 -14.303  1.00  1.00          
ATOM    714  CZ  PHE    43     -10.739 -11.184 -13.492  1.00  1.00          
ATOM    715  HZ  PHE    43     -11.306 -11.121 -14.409  1.00  1.00          
ATOM    716  C   PHE    43      -6.116 -12.316  -9.823  1.00  1.00          
ATOM    717  O   PHE    43      -5.436 -12.046  -8.809  1.00  1.00          
ATOM    718  N   VAL    44      -5.646 -12.290 -11.099  1.00  1.00          
ATOM    719  HN  VAL    44      -6.276 -12.457 -11.830  1.00  1.00          
ATOM    720  CA  VAL    44      -4.253 -11.972 -11.451  1.00  1.00          
ATOM    721  HA  VAL    44      -3.713 -11.937 -10.512  1.00  1.00          
ATOM    722  CB  VAL    44      -3.627 -13.177 -12.308  1.00  1.00          
ATOM    723  HB  VAL    44      -4.051 -14.083 -11.887  1.00  1.00          
ATOM    724  CG1 VAL    44      -3.969 -13.214 -13.814  1.00  1.00          
ATOM    725 HG11 VAL    44      -5.012 -12.979 -13.954  1.00  1.00          
ATOM    726 HG12 VAL    44      -3.761 -14.197 -14.212  1.00  1.00          
ATOM    727 HG13 VAL    44      -3.357 -12.481 -14.331  1.00  1.00          
ATOM    728  CG2 VAL    44      -2.115 -13.281 -12.114  1.00  1.00          
ATOM    729 HG21 VAL    44      -1.894 -13.608 -11.106  1.00  1.00          
ATOM    730 HG22 VAL    44      -1.667 -12.313 -12.281  1.00  1.00          
ATOM    731 HG23 VAL    44      -1.711 -13.991 -12.820  1.00  1.00          
ATOM    732  C   VAL    44      -4.173 -10.529 -12.072  1.00  1.00          
ATOM    733  O   VAL    44      -5.123 -10.090 -12.753  1.00  1.00          
ATOM    734  N   PHE    45      -3.024  -9.853 -11.825  1.00  1.00          
ATOM    735  HN  PHE    45      -2.310 -10.311 -11.336  1.00  1.00          
ATOM    736  CA  PHE    45      -2.760  -8.460 -12.291  1.00  1.00          
ATOM    737  HA  PHE    45      -3.609  -8.149 -12.882  1.00  1.00          
ATOM    738  CB  PHE    45      -2.596  -7.484 -11.088  1.00  1.00          
ATOM    739  HB1 PHE    45      -2.402  -6.494 -11.480  1.00  1.00          
ATOM    740  HB2 PHE    45      -1.745  -7.793 -10.507  1.00  1.00          
ATOM    741  CG  PHE    45      -3.782  -7.372 -10.139  1.00  1.00          
ATOM    742  CD1 PHE    45      -3.855  -8.180  -9.013  1.00  1.00          
ATOM    743  HD1 PHE    45      -3.068  -8.895  -8.822  1.00  1.00          
ATOM    744  CD2 PHE    45      -4.802  -6.457 -10.368  1.00  1.00          
ATOM    745  HD2 PHE    45      -4.759  -5.823 -11.241  1.00  1.00          
ATOM    746  CE1 PHE    45      -4.918  -8.079  -8.137  1.00  1.00          
ATOM    747  HE1 PHE    45      -4.959  -8.717  -7.266  1.00  1.00          
ATOM    748  CE2 PHE    45      -5.869  -6.355  -9.495  1.00  1.00          
ATOM    749  HE2 PHE    45      -6.657  -5.640  -9.685  1.00  1.00          
ATOM    750  CZ  PHE    45      -5.927  -7.166  -8.377  1.00  1.00          
ATOM    751  HZ  PHE    45      -6.758  -7.085  -7.691  1.00  1.00          
ATOM    752  C   PHE    45      -1.496  -8.411 -13.176  1.00  1.00          
ATOM    753  O   PHE    45      -0.585  -9.239 -13.001  1.00  1.00          
ATOM    754  N   LYS    46      -1.461  -7.419 -14.111  1.00  1.00          
ATOM    755  HN  LYS    46      -2.215  -6.796 -14.144  1.00  1.00          
ATOM    756  CA  LYS    46      -0.337  -7.215 -15.069  1.00  1.00          
ATOM    757  HA  LYS    46       0.244  -8.125 -15.090  1.00  1.00          
ATOM    758  CB  LYS    46      -0.874  -6.933 -16.487  1.00  1.00          
ATOM    759  HB1 LYS    46      -0.082  -6.487 -17.073  1.00  1.00          
ATOM    760  HB2 LYS    46      -1.688  -6.229 -16.413  1.00  1.00          
ATOM    761  CG  LYS    46      -1.381  -8.167 -17.233  1.00  1.00          
ATOM    762  HG1 LYS    46      -2.151  -8.641 -16.640  1.00  1.00          
ATOM    763  HG2 LYS    46      -0.560  -8.855 -17.375  1.00  1.00          
ATOM    764  CD  LYS    46      -1.959  -7.804 -18.591  1.00  1.00          
ATOM    765  HD1 LYS    46      -1.178  -7.371 -19.200  1.00  1.00          
ATOM    766  HD2 LYS    46      -2.751  -7.084 -18.453  1.00  1.00          
ATOM    767  CE  LYS    46      -2.519  -9.025 -19.303  1.00  1.00          
ATOM    768  HE1 LYS    46      -3.269  -9.481 -18.671  1.00  1.00          
ATOM    769  HE2 LYS    46      -1.717  -9.728 -19.471  1.00  1.00          
ATOM    770  NZ  LYS    46      -3.136  -8.676 -20.612  1.00  1.00          
ATOM    771  HZ1 LYS    46      -2.398  -8.563 -21.336  1.00  1.00          
ATOM    772  HZ2 LYS    46      -3.666  -7.785 -20.532  1.00  1.00          
ATOM    773  HZ3 LYS    46      -3.789  -9.428 -20.912  1.00  1.00          
ATOM    774  C   LYS    46       0.572  -6.065 -14.623  1.00  1.00          
ATOM    775  O   LYS    46       0.070  -5.042 -14.119  1.00  1.00          
ATOM    776  N   CYS    47       1.910  -6.257 -14.833  1.00  1.00          
ATOM    777  HN  CYS    47       2.196  -7.098 -15.249  1.00  1.00          
ATOM    778  CA  CYS    47       2.953  -5.266 -14.472  1.00  1.00          
ATOM    779  HA  CYS    47       2.533  -4.623 -13.712  1.00  1.00          
ATOM    780  HB1 CYS    47       4.711  -6.497 -14.684  1.00  1.00          
ATOM    781  HB2 CYS    47       3.904  -6.672 -13.134  1.00  1.00          
ATOM    782  C   CYS    47       3.345  -4.372 -15.704  1.00  1.00          
ATOM    783  O   CYS    47       3.766  -4.951 -16.732  1.00  1.00          
ATOM    784  CB  CYS    47       4.208  -5.966 -13.888  1.00  1.00          
ATOM    785  SG  CYS    47       5.427  -4.827 -13.126  1.00  1.00          
ATOM    786  N   PRO    48       3.164  -2.947 -15.672  1.00  1.00          
ATOM    787  CA  PRO    48       3.583  -2.056 -16.816  1.00  1.00          
ATOM    788  HA  PRO    48       3.246  -2.481 -17.754  1.00  1.00          
ATOM    789  CB  PRO    48       2.813  -0.732 -16.554  1.00  1.00          
ATOM    790  HB1 PRO    48       1.880  -0.736 -17.109  1.00  1.00          
ATOM    791  HB2 PRO    48       3.419   0.101 -16.888  1.00  1.00          
ATOM    792  CG  PRO    48       2.565  -0.676 -15.066  1.00  1.00          
ATOM    793  HG1 PRO    48       1.637  -0.148 -14.863  1.00  1.00          
ATOM    794  HG2 PRO    48       3.389  -0.167 -14.575  1.00  1.00          
ATOM    795  CD  PRO    48       2.475  -2.119 -14.597  1.00  1.00          
ATOM    796  HD1 PRO    48       1.438  -2.422 -14.504  1.00  1.00          
ATOM    797  HD2 PRO    48       2.978  -2.245 -13.647  1.00  1.00          
ATOM    798  C   PRO    48       5.134  -1.808 -16.941  1.00  1.00          
ATOM    799  O   PRO    48       5.580  -1.215 -17.942  1.00  1.00          
ATOM    800  N   VAL    49       5.914  -2.285 -15.914  1.00  1.00          
ATOM    801  HN  VAL    49       5.466  -2.773 -15.190  1.00  1.00          
ATOM    802  CA  VAL    49       7.410  -2.126 -15.828  1.00  1.00          
ATOM    803  HA  VAL    49       7.655  -1.220 -16.367  1.00  1.00          
ATOM    804  CB  VAL    49       7.997  -1.978 -14.329  1.00  1.00          
ATOM    805  HB  VAL    49       8.270  -2.973 -13.995  1.00  1.00          
ATOM    806  CG1 VAL    49       9.286  -1.133 -14.304  1.00  1.00          
ATOM    807 HG11 VAL    49       9.728  -1.179 -13.319  1.00  1.00          
ATOM    808 HG12 VAL    49       9.051  -0.107 -14.545  1.00  1.00          
ATOM    809 HG13 VAL    49       9.985  -1.521 -15.031  1.00  1.00          
ATOM    810  CG2 VAL    49       7.014  -1.365 -13.292  1.00  1.00          
ATOM    811 HG21 VAL    49       7.520  -0.592 -12.735  1.00  1.00          
ATOM    812 HG22 VAL    49       6.661  -2.128 -12.608  1.00  1.00          
ATOM    813 HG23 VAL    49       6.169  -0.937 -13.811  1.00  1.00          
ATOM    814  C   VAL    49       8.125  -3.313 -16.556  1.00  1.00          
ATOM    815  O   VAL    49       8.993  -3.056 -17.414  1.00  1.00          
ATOM    816  N   CYS    50       7.739  -4.573 -16.193  1.00  1.00          
ATOM    817  HN  CYS    50       7.043  -4.666 -15.510  1.00  1.00          
ATOM    818  CA  CYS    50       8.316  -5.799 -16.777  1.00  1.00          
ATOM    819  HA  CYS    50       9.232  -5.497 -17.267  1.00  1.00          
ATOM    820  HB1 CYS    50       9.375  -6.333 -15.000  1.00  1.00          
ATOM    821  HB2 CYS    50       9.172  -7.660 -16.127  1.00  1.00          
ATOM    822  C   CYS    50       7.403  -6.411 -17.860  1.00  1.00          
ATOM    823  O   CYS    50       7.904  -6.697 -18.965  1.00  1.00          
ATOM    824  CB  CYS    50       8.686  -6.811 -15.671  1.00  1.00          
ATOM    825  SG  CYS    50       7.291  -7.452 -14.676  1.00  1.00          
ATOM    826  N   GLY    51       6.086  -6.606 -17.531  1.00  1.00          
ATOM    827  HN  GLY    51       5.807  -6.447 -16.602  1.00  1.00          
ATOM    828  CA  GLY    51       5.095  -7.163 -18.482  1.00  1.00          
ATOM    829  HA1 GLY    51       5.587  -7.312 -19.433  1.00  1.00          
ATOM    830  HA2 GLY    51       4.309  -6.438 -18.617  1.00  1.00          
ATOM    831  C   GLY    51       4.452  -8.493 -18.053  1.00  1.00          
ATOM    832  O   GLY    51       3.428  -8.877 -18.644  1.00  1.00          
ATOM    833  N   GLU    52       5.054  -9.183 -17.026  1.00  1.00          
ATOM    834  HN  GLU    52       5.868  -8.795 -16.642  1.00  1.00          
ATOM    835  CA  GLU    52       4.571 -10.482 -16.473  1.00  1.00          
ATOM    836  HA  GLU    52       4.185 -11.058 -17.302  1.00  1.00          
ATOM    837  CB  GLU    52       5.752 -11.251 -15.856  1.00  1.00          
ATOM    838  HB1 GLU    52       5.394 -11.825 -15.014  1.00  1.00          
ATOM    839  HB2 GLU    52       6.489 -10.542 -15.511  1.00  1.00          
ATOM    840  CG  GLU    52       6.425 -12.204 -16.834  1.00  1.00          
ATOM    841  HG1 GLU    52       6.781 -11.636 -17.680  1.00  1.00          
ATOM    842  HG2 GLU    52       5.697 -12.928 -17.168  1.00  1.00          
ATOM    843  CD  GLU    52       7.596 -12.946 -16.222  1.00  1.00          
ATOM    844  OE1 GLU    52       8.722 -12.408 -16.254  1.00  1.00          
ATOM    845  OE2 GLU    52       7.387 -14.067 -15.710  1.00  1.00          
ATOM    846  C   GLU    52       3.428 -10.301 -15.440  1.00  1.00          
ATOM    847  O   GLU    52       3.339  -9.245 -14.787  1.00  1.00          
ATOM    848  N   GLU    53       2.574 -11.365 -15.317  1.00  1.00          
ATOM    849  HN  GLU    53       2.767 -12.169 -15.843  1.00  1.00          
ATOM    850  CA  GLU    53       1.381 -11.411 -14.420  1.00  1.00          
ATOM    851  HA  GLU    53       0.974 -10.414 -14.346  1.00  1.00          
ATOM    852  CB  GLU    53       0.304 -12.324 -15.040  1.00  1.00          
ATOM    853  HB1 GLU    53      -0.391 -12.615 -14.270  1.00  1.00          
ATOM    854  HB2 GLU    53       0.784 -13.211 -15.429  1.00  1.00          
ATOM    855  CG  GLU    53      -0.490 -11.674 -16.179  1.00  1.00          
ATOM    856  HG1 GLU    53       0.205 -11.287 -16.910  1.00  1.00          
ATOM    857  HG2 GLU    53      -1.072 -10.861 -15.773  1.00  1.00          
ATOM    858  CD  GLU    53      -1.434 -12.638 -16.870  1.00  1.00          
ATOM    859  OE1 GLU    53      -0.962 -13.427 -17.715  1.00  1.00          
ATOM    860  OE2 GLU    53      -2.647 -12.589 -16.586  1.00  1.00          
ATOM    861  C   GLU    53       1.742 -11.898 -13.004  1.00  1.00          
ATOM    862  O   GLU    53       2.536 -12.846 -12.861  1.00  1.00          
ATOM    863  N   PHE    54       1.139 -11.222 -11.991  1.00  1.00          
ATOM    864  HN  PHE    54       0.487 -10.527 -12.219  1.00  1.00          
ATOM    865  CA  PHE    54       1.337 -11.502 -10.546  1.00  1.00          
ATOM    866  HA  PHE    54       1.840 -12.458 -10.483  1.00  1.00          
ATOM    867  CB  PHE    54       2.251 -10.415  -9.864  1.00  1.00          
ATOM    868  HB1 PHE    54       3.228 -10.459 -10.326  1.00  1.00          
ATOM    869  HB2 PHE    54       2.361 -10.669  -8.822  1.00  1.00          
ATOM    870  CG  PHE    54       1.785  -8.954  -9.918  1.00  1.00          
ATOM    871  CD1 PHE    54       0.995  -8.436  -8.904  1.00  1.00          
ATOM    872  HD1 PHE    54       0.722  -9.067  -8.071  1.00  1.00          
ATOM    873  CD2 PHE    54       2.129  -8.132 -10.980  1.00  1.00          
ATOM    874  HD2 PHE    54       2.747  -8.523 -11.775  1.00  1.00          
ATOM    875  CE1 PHE    54       0.556  -7.126  -8.947  1.00  1.00          
ATOM    876  HE1 PHE    54      -0.059  -6.735  -8.150  1.00  1.00          
ATOM    877  CE2 PHE    54       1.694  -6.820 -11.026  1.00  1.00          
ATOM    878  HE2 PHE    54       1.965  -6.188 -11.856  1.00  1.00          
ATOM    879  CZ  PHE    54       0.905  -6.318 -10.009  1.00  1.00          
ATOM    880  HZ  PHE    54       0.563  -5.295 -10.046  1.00  1.00          
ATOM    881  C   PHE    54      -0.034 -11.653  -9.849  1.00  1.00          
ATOM    882  O   PHE    54      -0.969 -10.889 -10.162  1.00  1.00          
ATOM    883  N   TYR    55      -0.119 -12.615  -8.898  1.00  1.00          
ATOM    884  HN  TYR    55       0.686 -13.125  -8.672  1.00  1.00          
ATOM    885  CA  TYR    55      -1.363 -12.935  -8.148  1.00  1.00          
ATOM    886  HA  TYR    55      -2.197 -12.602  -8.746  1.00  1.00          
ATOM    887  CB  TYR    55      -1.477 -14.469  -7.949  1.00  1.00          
ATOM    888  HB1 TYR    55      -2.236 -14.667  -7.207  1.00  1.00          
ATOM    889  HB2 TYR    55      -0.532 -14.841  -7.584  1.00  1.00          
ATOM    890  CG  TYR    55      -1.827 -15.271  -9.202  1.00  1.00          
ATOM    891  CD1 TYR    55      -0.826 -15.803 -10.011  1.00  1.00          
ATOM    892  HD1 TYR    55       0.206 -15.632  -9.747  1.00  1.00          
ATOM    893  CD2 TYR    55      -3.152 -15.506  -9.566  1.00  1.00          
ATOM    894  HD2 TYR    55      -3.945 -15.100  -8.957  1.00  1.00          
ATOM    895  CE1 TYR    55      -1.135 -16.542 -11.138  1.00  1.00          
ATOM    896  HE1 TYR    55      -0.342 -16.947 -11.751  1.00  1.00          
ATOM    897  CE2 TYR    55      -3.465 -16.242 -10.694  1.00  1.00          
ATOM    898  HE2 TYR    55      -4.498 -16.413 -10.957  1.00  1.00          
ATOM    899  CZ  TYR    55      -2.453 -16.758 -11.475  1.00  1.00          
ATOM    900  OH  TYR    55      -2.762 -17.493 -12.597  1.00  1.00          
ATOM    901  HH  TYR    55      -3.405 -18.168 -12.371  1.00  1.00          
ATOM    902  C   TYR    55      -1.424 -12.224  -6.782  1.00  1.00          
ATOM    903  O   TYR    55      -0.370 -11.935  -6.183  1.00  1.00          
ATOM    904  N   GLY    56      -2.689 -11.949  -6.310  1.00  1.00          
ATOM    905  HN  GLY    56      -3.450 -12.205  -6.872  1.00  1.00          
ATOM    906  CA  GLY    56      -2.969 -11.294  -4.993  1.00  1.00          
ATOM    907  HA1 GLY    56      -3.977 -10.905  -5.012  1.00  1.00          
ATOM    908  HA2 GLY    56      -2.288 -10.464  -4.875  1.00  1.00          
ATOM    909  C   GLY    56      -2.816 -12.227  -3.760  1.00  1.00          
ATOM    910  O   GLY    56      -2.881 -11.750  -2.615  1.00  1.00          
ATOM    911  N   LYS    57      -2.617 -13.552  -4.048  1.00  1.00          
ATOM    912  HN  LYS    57      -2.606 -13.783  -5.000  1.00  1.00          
ATOM    913  CA  LYS    57      -2.389 -14.631  -3.044  1.00  1.00          
ATOM    914  HA  LYS    57      -2.947 -14.368  -2.158  1.00  1.00          
ATOM    915  CB  LYS    57      -2.919 -15.974  -3.588  1.00  1.00          
ATOM    916  HB1 LYS    57      -2.089 -16.532  -3.999  1.00  1.00          
ATOM    917  HB2 LYS    57      -3.626 -15.772  -4.378  1.00  1.00          
ATOM    918  CG  LYS    57      -3.613 -16.853  -2.543  1.00  1.00          
ATOM    919  HG1 LYS    57      -4.380 -16.276  -2.050  1.00  1.00          
ATOM    920  HG2 LYS    57      -2.882 -17.174  -1.816  1.00  1.00          
ATOM    921  CD  LYS    57      -4.252 -18.086  -3.178  1.00  1.00          
ATOM    922  HD1 LYS    57      -3.482 -18.648  -3.689  1.00  1.00          
ATOM    923  HD2 LYS    57      -4.994 -17.762  -3.892  1.00  1.00          
ATOM    924  CE  LYS    57      -4.928 -18.985  -2.136  1.00  1.00          
ATOM    925  HE1 LYS    57      -4.326 -18.991  -1.240  1.00  1.00          
ATOM    926  HE2 LYS    57      -4.997 -19.992  -2.525  1.00  1.00          
ATOM    927  NZ  LYS    57      -6.303 -18.515  -1.790  1.00  1.00          
ATOM    928  HZ1 LYS    57      -6.733 -19.150  -1.086  1.00  1.00          
ATOM    929  HZ2 LYS    57      -6.901 -18.503  -2.640  1.00  1.00          
ATOM    930  HZ3 LYS    57      -6.264 -17.553  -1.395  1.00  1.00          
ATOM    931  C   LYS    57      -0.874 -14.755  -2.662  1.00  1.00          
ATOM    932  O   LYS    57      -0.554 -15.326  -1.604  1.00  1.00          
ATOM    933  N   THR    58       0.013 -14.210  -3.547  1.00  1.00          
ATOM    934  HN  THR    58      -0.349 -13.780  -4.350  1.00  1.00          
ATOM    935  CA  THR    58       1.493 -14.204  -3.378  1.00  1.00          
ATOM    936  HA  THR    58       1.736 -14.989  -2.675  1.00  1.00          
ATOM    937  CB  THR    58       2.235 -14.516  -4.729  1.00  1.00          
ATOM    938  HB  THR    58       3.276 -14.255  -4.602  1.00  1.00          
ATOM    939  OG1 THR    58       1.700 -13.726  -5.798  1.00  1.00          
ATOM    940  HG1 THR    58       0.791 -13.491  -5.598  1.00  1.00          
ATOM    941  CG2 THR    58       2.157 -15.999  -5.108  1.00  1.00          
ATOM    942 HG21 THR    58       2.463 -16.606  -4.270  1.00  1.00          
ATOM    943 HG22 THR    58       2.810 -16.189  -5.947  1.00  1.00          
ATOM    944 HG23 THR    58       1.138 -16.245  -5.381  1.00  1.00          
ATOM    945  C   THR    58       2.013 -12.847  -2.784  1.00  1.00          
ATOM    946  O   THR    58       3.244 -12.651  -2.648  1.00  1.00          
ATOM    947  N   LEU    59       1.051 -11.941  -2.376  1.00  1.00          
ATOM    948  HN  LEU    59       0.111 -12.217  -2.445  1.00  1.00          
ATOM    949  CA  LEU    59       1.347 -10.603  -1.784  1.00  1.00          
ATOM    950  HA  LEU    59       2.256 -10.253  -2.244  1.00  1.00          
ATOM    951  CB  LEU    59       0.194  -9.605  -2.082  1.00  1.00          
ATOM    952  HB1 LEU    59      -0.209  -9.264  -1.136  1.00  1.00          
ATOM    953  HB2 LEU    59      -0.585 -10.141  -2.603  1.00  1.00          
ATOM    954  CG  LEU    59       0.539  -8.353  -2.918  1.00  1.00          
ATOM    955  HG  LEU    59       1.597  -8.149  -2.859  1.00  1.00          
ATOM    956  CD1 LEU    59       0.179  -8.558  -4.386  1.00  1.00          
ATOM    957 HD11 LEU    59       0.648  -7.790  -4.982  1.00  1.00          
ATOM    958 HD12 LEU    59      -0.893  -8.502  -4.506  1.00  1.00          
ATOM    959 HD13 LEU    59       0.528  -9.529  -4.710  1.00  1.00          
ATOM    960  CD2 LEU    59      -0.199  -7.140  -2.364  1.00  1.00          
ATOM    961 HD21 LEU    59      -0.085  -6.307  -3.043  1.00  1.00          
ATOM    962 HD22 LEU    59       0.213  -6.878  -1.401  1.00  1.00          
ATOM    963 HD23 LEU    59      -1.248  -7.374  -2.255  1.00  1.00          
ATOM    964  C   LEU    59       1.576 -10.701  -0.224  1.00  1.00          
ATOM    965  O   LEU    59       1.091 -11.689   0.366  1.00  1.00          
ATOM    966  N   PRO    60       2.291  -9.689   0.512  1.00  1.00          
ATOM    967  CA  PRO    60       2.542  -9.770   2.005  1.00  1.00          
ATOM    968  HA  PRO    60       3.000 -10.718   2.259  1.00  1.00          
ATOM    969  CB  PRO    60       3.541  -8.618   2.284  1.00  1.00          
ATOM    970  HB1 PRO    60       4.331  -8.957   2.948  1.00  1.00          
ATOM    971  HB2 PRO    60       3.013  -7.795   2.748  1.00  1.00          
ATOM    972  CG  PRO    60       4.076  -8.238   0.941  1.00  1.00          
ATOM    973  HG1 PRO    60       4.889  -8.898   0.663  1.00  1.00          
ATOM    974  HG2 PRO    60       4.412  -7.208   0.945  1.00  1.00          
ATOM    975  CD  PRO    60       2.916  -8.416   0.005  1.00  1.00          
ATOM    976  HD1 PRO    60       3.258  -8.528  -1.012  1.00  1.00          
ATOM    977  HD2 PRO    60       2.228  -7.584   0.088  1.00  1.00          
ATOM    978  C   PRO    60       1.277  -9.594   2.870  1.00  1.00          
ATOM    979  O   PRO    60       0.309  -8.953   2.429  1.00  1.00          
ATOM    980  N   ARG    61       1.326 -10.175   4.109  1.00  1.00          
ATOM    981  HN  ARG    61       2.150 -10.644   4.354  1.00  1.00          
ATOM    982  CA  ARG    61       0.215 -10.152   5.121  1.00  1.00          
ATOM    983  HA  ARG    61      -0.676 -10.465   4.596  1.00  1.00          
ATOM    984  CB  ARG    61       0.482 -11.181   6.232  1.00  1.00          
ATOM    985  HB1 ARG    61      -0.032 -10.867   7.128  1.00  1.00          
ATOM    986  HB2 ARG    61       1.544 -11.214   6.428  1.00  1.00          
ATOM    987  CG  ARG    61       0.014 -12.587   5.877  1.00  1.00          
ATOM    988  HG1 ARG    61       0.531 -12.912   4.985  1.00  1.00          
ATOM    989  HG2 ARG    61      -1.048 -12.565   5.687  1.00  1.00          
ATOM    990  CD  ARG    61       0.286 -13.582   6.994  1.00  1.00          
ATOM    991  HD1 ARG    61      -0.206 -13.242   7.892  1.00  1.00          
ATOM    992  HD2 ARG    61       1.352 -13.636   7.163  1.00  1.00          
ATOM    993  NE  ARG    61      -0.219 -14.938   6.652  1.00  1.00          
ATOM    994  HE  ARG    61      -0.687 -15.011   5.795  1.00  1.00          
ATOM    995  CZ  ARG    61      -0.105 -16.080   7.398  1.00  1.00          
ATOM    996  NH1 ARG    61       0.508 -16.135   8.596  1.00  1.00          
ATOM    997 HH11 ARG    61       0.912 -15.309   8.988  1.00  1.00          
ATOM    998 HH12 ARG    61       0.558 -17.001   9.092  1.00  1.00          
ATOM    999  NH2 ARG    61      -0.629 -17.199   6.917  1.00  1.00          
ATOM   1000 HH21 ARG    61      -1.095 -17.194   6.032  1.00  1.00          
ATOM   1001 HH22 ARG    61      -0.562 -18.048   7.442  1.00  1.00          
ATOM   1002  C   ARG    61      -0.090  -8.754   5.739  1.00  1.00          
ATOM   1003  O   ARG    61      -1.190  -8.561   6.297  1.00  1.00          
ATOM   1004  N   ARG    62       0.883  -7.787   5.613  1.00  1.00          
ATOM   1005  HN  ARG    62       1.677  -7.969   5.070  1.00  1.00          
ATOM   1006  CA  ARG    62       0.757  -6.390   6.122  1.00  1.00          
ATOM   1007  HA  ARG    62       0.193  -6.431   7.042  1.00  1.00          
ATOM   1008  CB  ARG    62       2.140  -5.819   6.419  1.00  1.00          
ATOM   1009  HB1 ARG    62       2.128  -4.758   6.227  1.00  1.00          
ATOM   1010  HB2 ARG    62       2.860  -6.289   5.765  1.00  1.00          
ATOM   1011  CG  ARG    62       2.583  -6.042   7.863  1.00  1.00          
ATOM   1012  HG1 ARG    62       2.496  -7.095   8.091  1.00  1.00          
ATOM   1013  HG2 ARG    62       1.927  -5.480   8.515  1.00  1.00          
ATOM   1014  CD  ARG    62       4.030  -5.600   8.114  1.00  1.00          
ATOM   1015  HD1 ARG    62       4.186  -5.502   9.181  1.00  1.00          
ATOM   1016  HD2 ARG    62       4.183  -4.639   7.644  1.00  1.00          
ATOM   1017  NE  ARG    62       5.037  -6.563   7.573  1.00  1.00          
ATOM   1018  HE  ARG    62       4.687  -7.438   7.301  1.00  1.00          
ATOM   1019  CZ  ARG    62       6.378  -6.352   7.404  1.00  1.00          
ATOM   1020  NH1 ARG    62       7.002  -5.209   7.753  1.00  1.00          
ATOM   1021 HH11 ARG    62       6.480  -4.459   8.159  1.00  1.00          
ATOM   1022 HH12 ARG    62       7.986  -5.112   7.606  1.00  1.00          
ATOM   1023  NH2 ARG    62       7.109  -7.325   6.880  1.00  1.00          
ATOM   1024 HH21 ARG    62       6.677  -8.189   6.618  1.00  1.00          
ATOM   1025 HH22 ARG    62       8.091  -7.197   6.744  1.00  1.00          
ATOM   1026  C   ARG    62      -0.001  -5.469   5.128  1.00  1.00          
ATOM   1027  O   ARG    62      -0.718  -4.554   5.566  1.00  1.00          
ATOM   1028  N   GLU    63       0.185  -5.737   3.781  1.00  1.00          
ATOM   1029  HN  GLU    63       0.812  -6.451   3.540  1.00  1.00          
ATOM   1030  CA  GLU    63      -0.483  -5.013   2.644  1.00  1.00          
ATOM   1031  HA  GLU    63      -0.363  -3.958   2.832  1.00  1.00          
ATOM   1032  CB  GLU    63       0.205  -5.347   1.315  1.00  1.00          
ATOM   1033  HB1 GLU    63      -0.504  -5.212   0.514  1.00  1.00          
ATOM   1034  HB2 GLU    63       0.520  -6.379   1.336  1.00  1.00          
ATOM   1035  CG  GLU    63       1.430  -4.481   1.023  1.00  1.00          
ATOM   1036  HG1 GLU    63       2.159  -4.643   1.802  1.00  1.00          
ATOM   1037  HG2 GLU    63       1.126  -3.445   1.029  1.00  1.00          
ATOM   1038  CD  GLU    63       2.082  -4.780  -0.322  1.00  1.00          
ATOM   1039  OE1 GLU    63       3.211  -5.309  -0.323  1.00  1.00          
ATOM   1040  OE2 GLU    63       1.478  -4.459  -1.374  1.00  1.00          
ATOM   1041  C   GLU    63      -2.004  -5.306   2.532  1.00  1.00          
ATOM   1042  O   GLU    63      -2.757  -4.448   2.046  1.00  1.00          
ATOM   1043  N   ALA    64      -2.424  -6.543   2.991  1.00  1.00          
ATOM   1044  HN  ALA    64      -1.733  -7.165   3.292  1.00  1.00          
ATOM   1045  CA  ALA    64      -3.851  -7.021   3.050  1.00  1.00          
ATOM   1046  HA  ALA    64      -4.267  -6.928   2.057  1.00  1.00          
ATOM   1047  CB  ALA    64      -3.891  -8.493   3.436  1.00  1.00          
ATOM   1048  HB1 ALA    64      -4.908  -8.853   3.373  1.00  1.00          
ATOM   1049  HB2 ALA    64      -3.528  -8.612   4.446  1.00  1.00          
ATOM   1050  HB3 ALA    64      -3.268  -9.059   2.760  1.00  1.00          
ATOM   1051  C   ALA    64      -4.728  -6.188   4.032  1.00  1.00          
ATOM   1052  O   ALA    64      -5.934  -6.023   3.800  1.00  1.00          
ATOM   1053  N   GLU    65      -4.064  -5.680   5.132  1.00  1.00          
ATOM   1054  HN  GLU    65      -3.124  -5.930   5.241  1.00  1.00          
ATOM   1055  CA  GLU    65      -4.661  -4.777   6.179  1.00  1.00          
ATOM   1056  HA  GLU    65      -5.616  -5.197   6.458  1.00  1.00          
ATOM   1057  CB  GLU    65      -3.764  -4.716   7.427  1.00  1.00          
ATOM   1058  HB1 GLU    65      -4.016  -3.828   7.989  1.00  1.00          
ATOM   1059  HB2 GLU    65      -2.735  -4.649   7.110  1.00  1.00          
ATOM   1060  CG  GLU    65      -3.898  -5.921   8.355  1.00  1.00          
ATOM   1061  HG1 GLU    65      -3.647  -6.815   7.801  1.00  1.00          
ATOM   1062  HG2 GLU    65      -4.921  -5.986   8.695  1.00  1.00          
ATOM   1063  CD  GLU    65      -2.989  -5.830   9.566  1.00  1.00          
ATOM   1064  OE1 GLU    65      -1.820  -6.254   9.463  1.00  1.00          
ATOM   1065  OE2 GLU    65      -3.448  -5.334  10.617  1.00  1.00          
ATOM   1066  C   GLU    65      -4.904  -3.336   5.637  1.00  1.00          
ATOM   1067  O   GLU    65      -5.807  -2.638   6.122  1.00  1.00          
ATOM   1068  N   LYS    66      -4.061  -2.925   4.618  1.00  1.00          
ATOM   1069  HN  LYS    66      -3.348  -3.544   4.353  1.00  1.00          
ATOM   1070  CA  LYS    66      -4.141  -1.614   3.877  1.00  1.00          
ATOM   1071  HA  LYS    66      -4.193  -0.833   4.622  1.00  1.00          
ATOM   1072  CB  LYS    66      -2.892  -1.379   3.008  1.00  1.00          
ATOM   1073  HB1 LYS    66      -3.119  -0.611   2.282  1.00  1.00          
ATOM   1074  HB2 LYS    66      -2.660  -2.293   2.484  1.00  1.00          
ATOM   1075  CG  LYS    66      -1.646  -0.949   3.780  1.00  1.00          
ATOM   1076  HG1 LYS    66      -1.381  -1.727   4.480  1.00  1.00          
ATOM   1077  HG2 LYS    66      -1.860  -0.036   4.316  1.00  1.00          
ATOM   1078  CD  LYS    66      -0.473  -0.706   2.844  1.00  1.00          
ATOM   1079  HD1 LYS    66      -0.743   0.062   2.135  1.00  1.00          
ATOM   1080  HD2 LYS    66      -0.248  -1.620   2.318  1.00  1.00          
ATOM   1081  CE  LYS    66       0.761  -0.260   3.609  1.00  1.00          
ATOM   1082  HE1 LYS    66       1.028  -1.032   4.317  1.00  1.00          
ATOM   1083  HE2 LYS    66       0.530   0.650   4.140  1.00  1.00          
ATOM   1084  NZ  LYS    66       1.917  -0.012   2.706  1.00  1.00          
ATOM   1085  HZ1 LYS    66       2.282   0.951   2.850  1.00  1.00          
ATOM   1086  HZ2 LYS    66       1.625  -0.116   1.714  1.00  1.00          
ATOM   1087  HZ3 LYS    66       2.677  -0.693   2.905  1.00  1.00          
ATOM   1088  C   LYS    66      -5.405  -1.510   2.980  1.00  1.00          
ATOM   1089  O   LYS    66      -5.903  -0.399   2.742  1.00  1.00          
ATOM   1090  N   VAL    67      -5.900  -2.708   2.492  1.00  1.00          
ATOM   1091  HN  VAL    67      -5.401  -3.522   2.717  1.00  1.00          
ATOM   1092  CA  VAL    67      -7.146  -2.879   1.637  1.00  1.00          
ATOM   1093  HA  VAL    67      -7.070  -2.150   0.837  1.00  1.00          
ATOM   1094  CB  VAL    67      -7.300  -4.336   0.963  1.00  1.00          
ATOM   1095  HB  VAL    67      -7.701  -5.001   1.715  1.00  1.00          
ATOM   1096  CG1 VAL    67      -8.282  -4.338  -0.231  1.00  1.00          
ATOM   1097 HG11 VAL    67      -9.277  -4.113   0.123  1.00  1.00          
ATOM   1098 HG12 VAL    67      -8.276  -5.309  -0.702  1.00  1.00          
ATOM   1099 HG13 VAL    67      -7.977  -3.587  -0.947  1.00  1.00          
ATOM   1100  CG2 VAL    67      -5.971  -4.936   0.462  1.00  1.00          
ATOM   1101 HG21 VAL    67      -5.627  -4.378  -0.397  1.00  1.00          
ATOM   1102 HG22 VAL    67      -6.123  -5.968   0.185  1.00  1.00          
ATOM   1103 HG23 VAL    67      -5.232  -4.879   1.248  1.00  1.00          
ATOM   1104  C   VAL    67      -8.421  -2.511   2.492  1.00  1.00          
ATOM   1105  O   VAL    67      -9.346  -1.894   1.965  1.00  1.00          
ATOM   1106  N   PHE    68      -8.439  -2.927   3.807  1.00  1.00          
ATOM   1107  HN  PHE    68      -7.742  -3.540   4.124  1.00  1.00          
ATOM   1108  CA  PHE    68      -9.503  -2.592   4.824  1.00  1.00          
ATOM   1109  HA  PHE    68     -10.443  -3.012   4.483  1.00  1.00          
ATOM   1110  CB  PHE    68      -9.123  -3.235   6.174  1.00  1.00          
ATOM   1111  HB1 PHE    68      -9.193  -2.480   6.944  1.00  1.00          
ATOM   1112  HB2 PHE    68      -8.101  -3.576   6.116  1.00  1.00          
ATOM   1113  CG  PHE    68      -9.968  -4.414   6.608  1.00  1.00          
ATOM   1114  CD1 PHE    68      -9.597  -5.713   6.280  1.00  1.00          
ATOM   1115  HD1 PHE    68      -8.704  -5.875   5.696  1.00  1.00          
ATOM   1116  CD2 PHE    68     -11.119  -4.226   7.366  1.00  1.00          
ATOM   1117  HD2 PHE    68     -11.420  -3.224   7.631  1.00  1.00          
ATOM   1118  CE1 PHE    68     -10.354  -6.794   6.695  1.00  1.00          
ATOM   1119  HE1 PHE    68     -10.053  -7.798   6.434  1.00  1.00          
ATOM   1120  CE2 PHE    68     -11.878  -5.303   7.780  1.00  1.00          
ATOM   1121  HE2 PHE    68     -12.771  -5.141   8.365  1.00  1.00          
ATOM   1122  CZ  PHE    68     -11.496  -6.588   7.445  1.00  1.00          
ATOM   1123  HZ  PHE    68     -12.089  -7.430   7.769  1.00  1.00          
ATOM   1124  C   PHE    68      -9.679  -1.054   5.056  1.00  1.00          
ATOM   1125  O   PHE    68     -10.775  -0.605   5.420  1.00  1.00          
ATOM   1126  N   GLU    69      -8.551  -0.285   4.832  1.00  1.00          
ATOM   1127  HN  GLU    69      -7.763  -0.745   4.481  1.00  1.00          
ATOM   1128  CA  GLU    69      -8.443   1.192   5.008  1.00  1.00          
ATOM   1129  HA  GLU    69      -8.881   1.428   5.967  1.00  1.00          
ATOM   1130  CB  GLU    69      -6.947   1.586   5.046  1.00  1.00          
ATOM   1131  HB1 GLU    69      -6.628   1.823   4.042  1.00  1.00          
ATOM   1132  HB2 GLU    69      -6.379   0.739   5.399  1.00  1.00          
ATOM   1133  CG  GLU    69      -6.622   2.781   5.946  1.00  1.00          
ATOM   1134  HG1 GLU    69      -6.989   2.573   6.940  1.00  1.00          
ATOM   1135  HG2 GLU    69      -7.132   3.648   5.551  1.00  1.00          
ATOM   1136  CD  GLU    69      -5.134   3.083   6.022  1.00  1.00          
ATOM   1137  OE1 GLU    69      -4.595   3.674   5.062  1.00  1.00          
ATOM   1138  OE2 GLU    69      -4.509   2.732   7.046  1.00  1.00          
ATOM   1139  C   GLU    69      -9.214   1.994   3.916  1.00  1.00          
ATOM   1140  O   GLU    69      -9.885   2.978   4.264  1.00  1.00          
ATOM   1141  N   LEU    70      -9.110   1.556   2.607  1.00  1.00          
ATOM   1142  HN  LEU    70      -8.516   0.805   2.412  1.00  1.00          
ATOM   1143  CA  LEU    70      -9.829   2.185   1.439  1.00  1.00          
ATOM   1144  HA  LEU    70      -9.645   3.250   1.524  1.00  1.00          
ATOM   1145  CB  LEU    70      -9.287   1.700   0.048  1.00  1.00          
ATOM   1146  HB1 LEU    70      -8.383   2.242  -0.168  1.00  1.00          
ATOM   1147  HB2 LEU    70     -10.013   1.983  -0.674  1.00  1.00          
ATOM   1148  CG  LEU    70      -8.996   0.195  -0.186  1.00  1.00          
ATOM   1149  HG  LEU    70      -8.749  -0.268   0.759  1.00  1.00          
ATOM   1150  CD1 LEU    70     -10.218  -0.516  -0.756  1.00  1.00          
ATOM   1151 HD11 LEU    70     -10.060  -1.586  -0.739  1.00  1.00          
ATOM   1152 HD12 LEU    70     -10.377  -0.191  -1.773  1.00  1.00          
ATOM   1153 HD13 LEU    70     -11.085  -0.270  -0.160  1.00  1.00          
ATOM   1154  CD2 LEU    70      -7.806   0.024  -1.121  1.00  1.00          
ATOM   1155 HD21 LEU    70      -7.757  -1.002  -1.460  1.00  1.00          
ATOM   1156 HD22 LEU    70      -6.895   0.273  -0.598  1.00  1.00          
ATOM   1157 HD23 LEU    70      -7.922   0.677  -1.972  1.00  1.00          
ATOM   1158  C   LEU    70     -11.373   1.987   1.512  1.00  1.00          
ATOM   1159  O   LEU    70     -12.134   2.895   1.140  1.00  1.00          
ATOM   1160  N   LEU    71     -11.784   0.771   2.002  1.00  1.00          
ATOM   1161  HN  LEU    71     -11.086   0.116   2.213  1.00  1.00          
ATOM   1162  CA  LEU    71     -13.199   0.356   2.240  1.00  1.00          
ATOM   1163  HA  LEU    71     -13.763   0.606   1.357  1.00  1.00          
ATOM   1164  CB  LEU    71     -13.260  -1.167   2.456  1.00  1.00          
ATOM   1165  HB1 LEU    71     -14.146  -1.382   3.034  1.00  1.00          
ATOM   1166  HB2 LEU    71     -12.397  -1.456   3.040  1.00  1.00          
ATOM   1167  CG  LEU    71     -13.288  -2.029   1.183  1.00  1.00          
ATOM   1168  HG  LEU    71     -13.164  -1.397   0.318  1.00  1.00          
ATOM   1169  CD1 LEU    71     -12.147  -3.033   1.182  1.00  1.00          
ATOM   1170 HD11 LEU    71     -11.205  -2.503   1.168  1.00  1.00          
ATOM   1171 HD12 LEU    71     -12.220  -3.658   0.306  1.00  1.00          
ATOM   1172 HD13 LEU    71     -12.198  -3.644   2.067  1.00  1.00          
ATOM   1173  CD2 LEU    71     -14.623  -2.746   1.055  1.00  1.00          
ATOM   1174 HD21 LEU    71     -14.602  -3.393   0.190  1.00  1.00          
ATOM   1175 HD22 LEU    71     -15.409  -2.015   0.936  1.00  1.00          
ATOM   1176 HD23 LEU    71     -14.814  -3.335   1.940  1.00  1.00          
ATOM   1177  C   LEU    71     -13.856   1.087   3.457  1.00  1.00          
ATOM   1178  O   LEU    71     -15.050   1.425   3.397  1.00  1.00          
ATOM   1179  N   ASN    72     -13.034   1.313   4.541  1.00  1.00          
ATOM   1180  HN  ASN    72     -12.098   1.021   4.473  1.00  1.00          
ATOM   1181  CA  ASN    72     -13.440   1.994   5.806  1.00  1.00          
ATOM   1182  HA  ASN    72     -14.442   1.664   6.041  1.00  1.00          
ATOM   1183  CB  ASN    72     -12.512   1.554   6.941  1.00  1.00          
ATOM   1184  HB1 ASN    72     -12.456   2.341   7.678  1.00  1.00          
ATOM   1185  HB2 ASN    72     -11.526   1.373   6.539  1.00  1.00          
ATOM   1186  CG  ASN    72     -12.988   0.287   7.626  1.00  1.00          
ATOM   1187  OD1 ASN    72     -12.934  -0.803   7.055  1.00  1.00          
ATOM   1188  ND2 ASN    72     -13.458   0.424   8.859  1.00  1.00          
ATOM   1189 HD21 ASN    72     -13.474   1.322   9.251  1.00  1.00          
ATOM   1190 HD22 ASN    72     -13.769  -0.379   9.327  1.00  1.00          
ATOM   1191  C   ASN    72     -13.448   3.544   5.718  1.00  1.00          
ATOM   1192  O   ASN    72     -14.280   4.182   6.390  1.00  1.00          
ATOM   1193  N   ASP    73     -12.524   4.111   4.883  1.00  1.00          
ATOM   1194  HN  ASP    73     -11.957   3.514   4.357  1.00  1.00          
ATOM   1195  CA  ASP    73     -12.367   5.571   4.687  1.00  1.00          
ATOM   1196  HA  ASP    73     -12.853   6.050   5.527  1.00  1.00          
ATOM   1197  CB  ASP    73     -10.859   5.931   4.724  1.00  1.00          
ATOM   1198  HB1 ASP    73     -10.475   5.915   3.716  1.00  1.00          
ATOM   1199  HB2 ASP    73     -10.336   5.195   5.314  1.00  1.00          
ATOM   1200  CG  ASP    73     -10.590   7.305   5.323  1.00  1.00          
ATOM   1201  OD1 ASP    73     -10.854   8.315   4.635  1.00  1.00          
ATOM   1202  OD2 ASP    73     -10.116   7.368   6.477  1.00  1.00          
ATOM   1203  C   ASP    73     -13.099   6.036   3.387  1.00  1.00          
ATOM   1204  O   ASP    73     -12.512   6.625   2.440  1.00  1.00          
ATOM   1205  N   PHE    74     -14.424   5.737   3.388  1.00  1.00          
ATOM   1206  HN  PHE    74     -14.759   5.233   4.154  1.00  1.00          
ATOM   1207  CA  PHE    74     -15.377   6.081   2.304  1.00  1.00          
ATOM   1208  HA  PHE    74     -14.812   6.156   1.388  1.00  1.00          
ATOM   1209  CB  PHE    74     -16.431   4.965   2.145  1.00  1.00          
ATOM   1210  HB1 PHE    74     -17.407   5.374   2.368  1.00  1.00          
ATOM   1211  HB2 PHE    74     -16.214   4.177   2.849  1.00  1.00          
ATOM   1212  CG  PHE    74     -16.497   4.340   0.761  1.00  1.00          
ATOM   1213  CD1 PHE    74     -15.668   3.275   0.408  1.00  1.00          
ATOM   1214  HD1 PHE    74     -14.959   2.895   1.129  1.00  1.00          
ATOM   1215  CD2 PHE    74     -17.401   4.812  -0.184  1.00  1.00          
ATOM   1216  HD2 PHE    74     -18.053   5.635   0.071  1.00  1.00          
ATOM   1217  CE1 PHE    74     -15.740   2.707  -0.849  1.00  1.00          
ATOM   1218  HE1 PHE    74     -15.090   1.884  -1.108  1.00  1.00          
ATOM   1219  CE2 PHE    74     -17.473   4.245  -1.443  1.00  1.00          
ATOM   1220  HE2 PHE    74     -18.179   4.624  -2.166  1.00  1.00          
ATOM   1221  CZ  PHE    74     -16.643   3.192  -1.774  1.00  1.00          
ATOM   1222  HZ  PHE    74     -16.700   2.748  -2.757  1.00  1.00          
ATOM   1223  C   PHE    74     -16.064   7.430   2.566  1.00  1.00          
ATOM   1224  O   PHE    74     -16.342   7.781   3.723  1.00  1.00          
ATOM   1225  N   LYS    75     -16.345   8.186   1.442  1.00  1.00          
ATOM   1226  HN  LYS    75     -16.106   7.786   0.580  1.00  1.00          
ATOM   1227  CA  LYS    75     -16.981   9.574   1.391  1.00  1.00          
ATOM   1228  HA  LYS    75     -17.230   9.733   0.349  1.00  1.00          
ATOM   1229  CB  LYS    75     -18.306   9.741   2.220  1.00  1.00          
ATOM   1230  HB1 LYS    75     -18.359  10.754   2.591  1.00  1.00          
ATOM   1231  HB2 LYS    75     -18.277   9.063   3.062  1.00  1.00          
ATOM   1232  CG  LYS    75     -19.570   9.455   1.426  1.00  1.00          
ATOM   1233  HG1 LYS    75     -19.478   8.486   0.959  1.00  1.00          
ATOM   1234  HG2 LYS    75     -19.687  10.215   0.667  1.00  1.00          
ATOM   1235  CD  LYS    75     -20.801   9.459   2.327  1.00  1.00          
ATOM   1236  HD1 LYS    75     -20.853  10.410   2.838  1.00  1.00          
ATOM   1237  HD2 LYS    75     -20.699   8.665   3.055  1.00  1.00          
ATOM   1238  CE  LYS    75     -22.093   9.254   1.530  1.00  1.00          
ATOM   1239  HE1 LYS    75     -22.855   8.851   2.184  1.00  1.00          
ATOM   1240  HE2 LYS    75     -21.897   8.551   0.734  1.00  1.00          
ATOM   1241  NZ  LYS    75     -22.595  10.528   0.935  1.00  1.00          
ATOM   1242  HZ1 LYS    75     -22.066  10.752   0.068  1.00  1.00          
ATOM   1243  HZ2 LYS    75     -22.473  11.309   1.612  1.00  1.00          
ATOM   1244  HZ3 LYS    75     -23.603  10.441   0.702  1.00  1.00          
ATOM   1245  C   LYS    75     -15.957  10.674   1.761  1.00  1.00          
ATOM   1246  O   LYS    75     -15.480  10.734   2.919  1.00  1.00          
ATOM   1247  N   GLY    76     -15.614  11.494   0.732  1.00  1.00          
ATOM   1248  HN  GLY    76     -16.034  11.341  -0.140  1.00  1.00          
ATOM   1249  CA  GLY    76     -14.651  12.595   0.866  1.00  1.00          
ATOM   1250  HA1 GLY    76     -13.866  12.287   1.541  1.00  1.00          
ATOM   1251  HA2 GLY    76     -15.157  13.450   1.290  1.00  1.00          
ATOM   1252  C   GLY    76     -14.025  12.999  -0.458  1.00  1.00          
ATOM   1253  O   GLY    76     -14.391  14.058  -1.005  1.00  1.00          
ATOM   1254  N   GLY    77     -13.089  12.142  -0.950  1.00  1.00          
ATOM   1255  HN  GLY    77     -12.885  11.334  -0.436  1.00  1.00          
ATOM   1256  CA  GLY    77     -12.365  12.375  -2.221  1.00  1.00          
ATOM   1257  HA1 GLY    77     -11.311  12.461  -1.997  1.00  1.00          
ATOM   1258  HA2 GLY    77     -12.700  13.311  -2.639  1.00  1.00          
ATOM   1259  C   GLY    77     -12.541  11.287  -3.285  1.00  1.00          
ATOM   1260  O   GLY    77     -11.601  11.072  -4.073  1.00  1.00          
ATOM   1261  N   ILE    78     -13.729  10.616  -3.301  1.00  1.00          
ATOM   1262  HN  ILE    78     -14.405  10.858  -2.636  1.00  1.00          
ATOM   1263  CA  ILE    78     -14.055   9.535  -4.278  1.00  1.00          
ATOM   1264  HA  ILE    78     -13.224   9.468  -4.971  1.00  1.00          
ATOM   1265  CB  ILE    78     -14.285   8.078  -3.623  1.00  1.00          
ATOM   1266  HB  ILE    78     -15.313   8.025  -3.295  1.00  1.00          
ATOM   1267  CG1 ILE    78     -13.357   7.776  -2.416  1.00  1.00          
ATOM   1268 HG11 ILE    78     -12.680   8.609  -2.276  1.00  1.00          
ATOM   1269 HG12 ILE    78     -12.785   6.885  -2.622  1.00  1.00          
ATOM   1270  CG2 ILE    78     -14.062   6.944  -4.653  1.00  1.00          
ATOM   1271 HG21 ILE    78     -14.611   7.167  -5.557  1.00  1.00          
ATOM   1272 HG22 ILE    78     -14.412   6.008  -4.242  1.00  1.00          
ATOM   1273 HG23 ILE    78     -13.009   6.865  -4.881  1.00  1.00          
ATOM   1274  CD1 ILE    78     -14.104   7.558  -1.118  1.00  1.00          
ATOM   1275 HD11 ILE    78     -14.678   8.442  -0.880  1.00  1.00          
ATOM   1276 HD12 ILE    78     -13.398   7.364  -0.324  1.00  1.00          
ATOM   1277 HD13 ILE    78     -14.770   6.714  -1.222  1.00  1.00          
ATOM   1278  C   ILE    78     -15.308   9.982  -5.069  1.00  1.00          
ATOM   1279  O   ILE    78     -16.370  10.216  -4.462  1.00  1.00          
ATOM   1280  N   ASP    79     -15.134  10.090  -6.412  1.00  1.00          
ATOM   1281  HN  ASP    79     -14.247   9.892  -6.779  1.00  1.00          
ATOM   1282  CA  ASP    79     -16.200  10.488  -7.355  1.00  1.00          
ATOM   1283  HA  ASP    79     -17.123  10.546  -6.796  1.00  1.00          
ATOM   1284  CB  ASP    79     -15.902  11.868  -7.968  1.00  1.00          
ATOM   1285  HB1 ASP    79     -16.448  11.965  -8.894  1.00  1.00          
ATOM   1286  HB2 ASP    79     -14.845  11.943  -8.171  1.00  1.00          
ATOM   1287  CG  ASP    79     -16.299  13.014  -7.052  1.00  1.00          
ATOM   1288  OD1 ASP    79     -15.392  13.678  -6.508  1.00  1.00          
ATOM   1289  OD2 ASP    79     -17.516  13.251  -6.884  1.00  1.00          
ATOM   1290  C   ASP    79     -16.367   9.439  -8.456  1.00  1.00          
ATOM   1291  O   ASP    79     -15.369   9.004  -9.067  1.00  1.00          
ATOM   1292  N   TRP    80     -17.649   9.026  -8.669  1.00  1.00          
ATOM   1293  HN  TRP    80     -18.351   9.424  -8.112  1.00  1.00          
ATOM   1294  CA  TRP    80     -18.065   8.009  -9.693  1.00  1.00          
ATOM   1295  HA  TRP    80     -17.284   7.264  -9.721  1.00  1.00          
ATOM   1296  CB  TRP    80     -19.368   7.313  -9.266  1.00  1.00          
ATOM   1297  HB1 TRP    80     -19.786   6.791 -10.114  1.00  1.00          
ATOM   1298  HB2 TRP    80     -20.071   8.058  -8.923  1.00  1.00          
ATOM   1299  CG  TRP    80     -19.169   6.307  -8.145  1.00  1.00          
ATOM   1300  CD1 TRP    80     -19.391   6.544  -6.819  1.00  1.00          
ATOM   1301  HD1 TRP    80     -19.745   7.485  -6.425  1.00  1.00          
ATOM   1302  CD2 TRP    80     -18.703   4.930  -8.229  1.00  1.00          
ATOM   1303  NE1 TRP    80     -19.095   5.430  -6.076  1.00  1.00          
ATOM   1304  HE1 TRP    80     -19.175   5.361  -5.101  1.00  1.00          
ATOM   1305  CE2 TRP    80     -18.674   4.429  -6.910  1.00  1.00          
ATOM   1306  CE3 TRP    80     -18.306   4.066  -9.277  1.00  1.00          
ATOM   1307  HE3 TRP    80     -18.313   4.397 -10.304  1.00  1.00          
ATOM   1308  CZ2 TRP    80     -18.271   3.129  -6.610  1.00  1.00          
ATOM   1309  HZ2 TRP    80     -18.253   2.759  -5.596  1.00  1.00          
ATOM   1310  CZ3 TRP    80     -17.909   2.777  -8.969  1.00  1.00          
ATOM   1311  HZ3 TRP    80     -17.604   2.102  -9.759  1.00  1.00          
ATOM   1312  CH2 TRP    80     -17.894   2.321  -7.647  1.00  1.00          
ATOM   1313  HH2 TRP    80     -17.575   1.308  -7.453  1.00  1.00          
ATOM   1314  C   TRP    80     -18.210   8.581 -11.130  1.00  1.00          
ATOM   1315  O   TRP    80     -17.950   7.851 -12.102  1.00  1.00          
ATOM   1316  N   GLU    81     -18.632   9.883 -11.229  1.00  1.00          
ATOM   1317  HN  GLU    81     -18.821  10.362 -10.396  1.00  1.00          
ATOM   1318  CA  GLU    81     -18.823  10.631 -12.519  1.00  1.00          
ATOM   1319  HA  GLU    81     -19.262   9.941 -13.225  1.00  1.00          
ATOM   1320  CB  GLU    81     -19.801  11.809 -12.323  1.00  1.00          
ATOM   1321  HB1 GLU    81     -19.668  12.505 -13.137  1.00  1.00          
ATOM   1322  HB2 GLU    81     -19.558  12.308 -11.397  1.00  1.00          
ATOM   1323  CG  GLU    81     -21.276  11.411 -12.273  1.00  1.00          
ATOM   1324  HG1 GLU    81     -21.414  10.696 -11.476  1.00  1.00          
ATOM   1325  HG2 GLU    81     -21.544  10.955 -13.215  1.00  1.00          
ATOM   1326  CD  GLU    81     -22.191  12.596 -12.029  1.00  1.00          
ATOM   1327  OE1 GLU    81     -22.409  12.944 -10.849  1.00  1.00          
ATOM   1328  OE2 GLU    81     -22.693  13.174 -13.017  1.00  1.00          
ATOM   1329  C   GLU    81     -17.492  11.159 -13.127  1.00  1.00          
ATOM   1330  O   GLU    81     -17.354  11.175 -14.364  1.00  1.00          
ATOM   1331  N   ASN    82     -16.547  11.581 -12.234  1.00  1.00          
ATOM   1332  HN  ASN    82     -16.764  11.528 -11.281  1.00  1.00          
ATOM   1333  CA  ASN    82     -15.209  12.112 -12.609  1.00  1.00          
ATOM   1334  HA  ASN    82     -15.290  12.507 -13.611  1.00  1.00          
ATOM   1335  CB  ASN    82     -14.834  13.262 -11.661  1.00  1.00          
ATOM   1336  HB1 ASN    82     -13.760  13.375 -11.649  1.00  1.00          
ATOM   1337  HB2 ASN    82     -15.177  13.023 -10.665  1.00  1.00          
ATOM   1338  CG  ASN    82     -15.451  14.585 -12.077  1.00  1.00          
ATOM   1339  OD1 ASN    82     -16.545  14.941 -11.636  1.00  1.00          
ATOM   1340  ND2 ASN    82     -14.753  15.321 -12.936  1.00  1.00          
ATOM   1341 HD21 ASN    82     -13.892  14.972 -13.249  1.00  1.00          
ATOM   1342 HD22 ASN    82     -15.129  16.179 -13.222  1.00  1.00          
ATOM   1343  C   ASN    82     -14.090  11.029 -12.597  1.00  1.00          
ATOM   1344  O   ASN    82     -13.014  11.254 -13.179  1.00  1.00          
ATOM   1345  N   LYS    83     -14.365   9.822 -11.944  1.00  1.00          
ATOM   1346  HN  LYS    83     -15.254   9.736 -11.541  1.00  1.00          
ATOM   1347  CA  LYS    83     -13.433   8.623 -11.790  1.00  1.00          
ATOM   1348  HA  LYS    83     -13.974   7.939 -11.145  1.00  1.00          
ATOM   1349  CB  LYS    83     -13.206   7.870 -13.151  1.00  1.00          
ATOM   1350  HB1 LYS    83     -12.300   7.286 -13.080  1.00  1.00          
ATOM   1351  HB2 LYS    83     -13.089   8.602 -13.935  1.00  1.00          
ATOM   1352  CG  LYS    83     -14.343   6.943 -13.540  1.00  1.00          
ATOM   1353  HG1 LYS    83     -15.259   7.512 -13.597  1.00  1.00          
ATOM   1354  HG2 LYS    83     -14.440   6.172 -12.788  1.00  1.00          
ATOM   1355  CD  LYS    83     -14.081   6.286 -14.884  1.00  1.00          
ATOM   1356  HD1 LYS    83     -13.142   5.753 -14.838  1.00  1.00          
ATOM   1357  HD2 LYS    83     -14.024   7.054 -15.642  1.00  1.00          
ATOM   1358  CE  LYS    83     -15.187   5.313 -15.253  1.00  1.00          
ATOM   1359  HE1 LYS    83     -16.123   5.849 -15.296  1.00  1.00          
ATOM   1360  HE2 LYS    83     -15.244   4.548 -14.492  1.00  1.00          
ATOM   1361  NZ  LYS    83     -14.938   4.664 -16.569  1.00  1.00          
ATOM   1362  HZ1 LYS    83     -13.954   4.827 -16.866  1.00  1.00          
ATOM   1363  HZ2 LYS    83     -15.576   5.060 -17.288  1.00  1.00          
ATOM   1364  HZ3 LYS    83     -15.103   3.640 -16.498  1.00  1.00          
ATOM   1365  C   LYS    83     -12.093   8.949 -11.022  1.00  1.00          
ATOM   1366  O   LYS    83     -10.958   8.649 -11.484  1.00  1.00          
ATOM   1367  N   ARG    84     -12.280   9.578  -9.829  1.00  1.00          
ATOM   1368  HN  ARG    84     -13.197   9.781  -9.556  1.00  1.00          
ATOM   1369  CA  ARG    84     -11.177   9.973  -8.915  1.00  1.00          
ATOM   1370  HA  ARG    84     -10.248   9.735  -9.415  1.00  1.00          
ATOM   1371  CB  ARG    84     -11.199  11.488  -8.602  1.00  1.00          
ATOM   1372  HB1 ARG    84     -10.545  11.673  -7.762  1.00  1.00          
ATOM   1373  HB2 ARG    84     -12.204  11.766  -8.325  1.00  1.00          
ATOM   1374  CG  ARG    84     -10.759  12.395  -9.761  1.00  1.00          
ATOM   1375  HG1 ARG    84     -11.394  12.192 -10.613  1.00  1.00          
ATOM   1376  HG2 ARG    84      -9.736  12.160 -10.014  1.00  1.00          
ATOM   1377  CD  ARG    84     -10.846  13.887  -9.411  1.00  1.00          
ATOM   1378  HD1 ARG    84     -11.771  14.060  -8.880  1.00  1.00          
ATOM   1379  HD2 ARG    84     -10.850  14.462 -10.328  1.00  1.00          
ATOM   1380  NE  ARG    84      -9.710  14.353  -8.562  1.00  1.00          
ATOM   1381  HE  ARG    84      -9.050  13.668  -8.321  1.00  1.00          
ATOM   1382  CZ  ARG    84      -9.489  15.622  -8.092  1.00  1.00          
ATOM   1383  NH1 ARG    84     -10.311  16.662  -8.334  1.00  1.00          
ATOM   1384 HH11 ARG    84     -11.137  16.530  -8.883  1.00  1.00          
ATOM   1385 HH12 ARG    84     -10.096  17.567  -7.966  1.00  1.00          
ATOM   1386  NH2 ARG    84      -8.407  15.842  -7.358  1.00  1.00          
ATOM   1387 HH21 ARG    84      -7.777  15.091  -7.158  1.00  1.00          
ATOM   1388 HH22 ARG    84      -8.220  16.759  -7.004  1.00  1.00          
ATOM   1389  C   ARG    84     -11.241   9.161  -7.617  1.00  1.00          
ATOM   1390  O   ARG    84     -12.313   9.074  -6.983  1.00  1.00          
ATOM   1391  N   VAL    85     -10.077   8.561  -7.263  1.00  1.00          
ATOM   1392  HN  VAL    85      -9.301   8.687  -7.846  1.00  1.00          
ATOM   1393  CA  VAL    85      -9.904   7.718  -6.039  1.00  1.00          
ATOM   1394  HA  VAL    85     -10.812   7.810  -5.456  1.00  1.00          
ATOM   1395  CB  VAL    85      -9.646   6.150  -6.330  1.00  1.00          
ATOM   1396  HB  VAL    85      -8.581   6.030  -6.499  1.00  1.00          
ATOM   1397  CG1 VAL    85     -10.035   5.258  -5.126  1.00  1.00          
ATOM   1398 HG11 VAL    85     -11.101   5.079  -5.142  1.00  1.00          
ATOM   1399 HG12 VAL    85      -9.770   5.759  -4.207  1.00  1.00          
ATOM   1400 HG13 VAL    85      -9.511   4.313  -5.184  1.00  1.00          
ATOM   1401  CG2 VAL    85     -10.393   5.597  -7.571  1.00  1.00          
ATOM   1402 HG21 VAL    85     -10.481   6.377  -8.314  1.00  1.00          
ATOM   1403 HG22 VAL    85     -11.379   5.269  -7.279  1.00  1.00          
ATOM   1404 HG23 VAL    85      -9.849   4.761  -7.991  1.00  1.00          
ATOM   1405  C   VAL    85      -8.733   8.306  -5.209  1.00  1.00          
ATOM   1406  O   VAL    85      -7.655   8.571  -5.773  1.00  1.00          
ATOM   1407  N   LYS    86      -8.991   8.498  -3.887  1.00  1.00          
ATOM   1408  HN  LYS    86      -9.890   8.294  -3.556  1.00  1.00          
ATOM   1409  CA  LYS    86      -8.000   9.027  -2.925  1.00  1.00          
ATOM   1410  HA  LYS    86      -7.071   9.173  -3.455  1.00  1.00          
ATOM   1411  CB  LYS    86      -8.473  10.381  -2.362  1.00  1.00          
ATOM   1412  HB1 LYS    86      -8.009  10.529  -1.398  1.00  1.00          
ATOM   1413  HB2 LYS    86      -9.545  10.332  -2.223  1.00  1.00          
ATOM   1414  CG  LYS    86      -8.139  11.597  -3.250  1.00  1.00          
ATOM   1415  HG1 LYS    86      -8.972  12.293  -3.242  1.00  1.00          
ATOM   1416  HG2 LYS    86      -7.974  11.254  -4.259  1.00  1.00          
ATOM   1417  CD  LYS    86      -6.886  12.335  -2.776  1.00  1.00          
ATOM   1418  HD1 LYS    86      -6.049  11.653  -2.800  1.00  1.00          
ATOM   1419  HD2 LYS    86      -7.043  12.682  -1.765  1.00  1.00          
ATOM   1420  CE  LYS    86      -6.575  13.533  -3.661  1.00  1.00          
ATOM   1421  HE1 LYS    86      -7.425  14.199  -3.653  1.00  1.00          
ATOM   1422  HE2 LYS    86      -6.402  13.184  -4.668  1.00  1.00          
ATOM   1423  NZ  LYS    86      -5.372  14.274  -3.191  1.00  1.00          
ATOM   1424  HZ1 LYS    86      -5.657  15.075  -2.592  1.00  1.00          
ATOM   1425  HZ2 LYS    86      -4.837  14.638  -4.005  1.00  1.00          
ATOM   1426  HZ3 LYS    86      -4.756  13.644  -2.640  1.00  1.00          
ATOM   1427  C   LYS    86      -7.759   8.043  -1.773  1.00  1.00          
ATOM   1428  O   LYS    86      -8.720   7.452  -1.243  1.00  1.00          
ATOM   1429  N   LEU    87      -6.457   7.890  -1.420  1.00  1.00          
ATOM   1430  HN  LEU    87      -5.788   8.401  -1.914  1.00  1.00          
ATOM   1431  CA  LEU    87      -5.975   7.022  -0.331  1.00  1.00          
ATOM   1432  HA  LEU    87      -6.839   6.619   0.176  1.00  1.00          
ATOM   1433  CB  LEU    87      -5.117   5.864  -0.882  1.00  1.00          
ATOM   1434  HB1 LEU    87      -4.350   5.647  -0.155  1.00  1.00          
ATOM   1435  HB2 LEU    87      -4.637   6.212  -1.785  1.00  1.00          
ATOM   1436  CG  LEU    87      -5.861   4.550  -1.208  1.00  1.00          
ATOM   1437  HG  LEU    87      -6.926   4.721  -1.180  1.00  1.00          
ATOM   1438  CD1 LEU    87      -5.511   4.050  -2.604  1.00  1.00          
ATOM   1439 HD11 LEU    87      -5.965   4.693  -3.341  1.00  1.00          
ATOM   1440 HD12 LEU    87      -5.887   3.044  -2.725  1.00  1.00          
ATOM   1441 HD13 LEU    87      -4.438   4.049  -2.733  1.00  1.00          
ATOM   1442  CD2 LEU    87      -5.525   3.478  -0.176  1.00  1.00          
ATOM   1443 HD21 LEU    87      -5.823   3.815   0.806  1.00  1.00          
ATOM   1444 HD22 LEU    87      -4.462   3.285  -0.184  1.00  1.00          
ATOM   1445 HD23 LEU    87      -6.051   2.566  -0.418  1.00  1.00          
ATOM   1446  C   LEU    87      -5.175   7.851   0.674  1.00  1.00          
ATOM   1447  O   LEU    87      -4.291   8.640   0.276  1.00  1.00          
ATOM   1448  N   LYS    88      -5.529   7.665   1.963  1.00  1.00          
ATOM   1449  HN  LYS    88      -6.253   7.036   2.148  1.00  1.00          
ATOM   1450  HA  LYS    88      -4.275   9.146   2.707  1.00  1.00          
ATOM   1451  CB  LYS    88      -5.962   8.982   4.017  1.00  1.00          
ATOM   1452  HB1 LYS    88      -5.562   9.062   5.017  1.00  1.00          
ATOM   1453  HB2 LYS    88      -6.824   8.332   4.036  1.00  1.00          
ATOM   1454  CG  LYS    88      -6.418  10.364   3.571  1.00  1.00          
ATOM   1455  HG1 LYS    88      -6.771  10.305   2.552  1.00  1.00          
ATOM   1456  HG2 LYS    88      -5.579  11.042   3.624  1.00  1.00          
ATOM   1457  CD  LYS    88      -7.543  10.896   4.457  1.00  1.00          
ATOM   1458  HD1 LYS    88      -7.194  10.910   5.482  1.00  1.00          
ATOM   1459  HD2 LYS    88      -8.391  10.233   4.375  1.00  1.00          
ATOM   1460  CE  LYS    88      -7.980  12.309   4.053  1.00  1.00          
ATOM   1461  HE1 LYS    88      -7.103  12.879   3.782  1.00  1.00          
ATOM   1462  HE2 LYS    88      -8.465  12.784   4.896  1.00  1.00          
ATOM   1463  NZ  LYS    88      -8.931  12.307   2.900  1.00  1.00          
ATOM   1464  HZ1 LYS    88      -8.916  11.381   2.426  1.00  1.00          
ATOM   1465  HZ2 LYS    88      -8.663  13.040   2.213  1.00  1.00          
ATOM   1466  HZ3 LYS    88      -9.898  12.499   3.233  1.00  1.00          
ATOM   1467  CA  LYS    88      -4.895   8.357   3.108  1.00  1.00          
ATOM   1468  C   LYS    88      -4.008   7.403   3.912  1.00  1.00          
ATOM   1469  OT1 LYS    88      -4.429   6.247   4.147  1.00  1.00          
ATOM   1470  OT2 LYS    88      -2.897   7.822   4.299  1.00  1.00          
END
