
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   90 (  684),  selected   90 , name 1cyj_A
# Molecule2: number of CA atoms   87 ( 1451),  selected   87 , name T0476.pdb
# PARAMETERS: 1cyj_A.T0476.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     1_A      -       -           -
LGA    D     2_A      -       -           -
LGA    L     3_A      -       -           -
LGA    A     4_A      -       -           -
LGA    L     5_A      -       -           -
LGA    G     6_A      -       -           -
LGA    A     7_A      -       -           -
LGA    Q     8_A      -       -           -
LGA    V     9_A      A       2          4.720
LGA    F    10_A      K       3           -
LGA    N    11_A      C       4           -
LGA    -       -      P       5           -
LGA    -       -      I       6           -
LGA    -       -      C       7           -
LGA    -       -      G       8           -
LGA    -       -      S       9           -
LGA    -       -      P      10           -
LGA    G    12_A      L      11          2.959
LGA    N    13_A      K      12          4.006
LGA    C    14_A      W      13          3.492
LGA    A    15_A      E      14          3.413
LGA    A    16_A      E      15          3.459
LGA    C    17_A      L      16          3.771
LGA    H    18_A      I      17          2.593
LGA    M    19_A      E      18          3.019
LGA    G    20_A      -       -           -
LGA    G    21_A      -       -           -
LGA    R    22_A      E      19          5.217
LGA    N    23_A      M      20          2.981
LGA    S    24_A      L      21           #
LGA    V    25_A      -       -           -
LGA    M    26_A      -       -           -
LGA    P    27_A      -       -           -
LGA    E    28_A      I      22          3.017
LGA    K    29_A      I      23          1.738
LGA    T    30_A      -       -           -
LGA    L    31_A      -       -           -
LGA    D    32_A      -       -           -
LGA    K    33_A      -       -           -
LGA    A    34_A      -       -           -
LGA    A    35_A      E      24          4.423
LGA    L    36_A      N      25          4.982
LGA    E    37_A      F      26           #
LGA    Q    38_A      E      27           #
LGA    Y    39_A      E      28           #
LGA    L    40_A      I      29          3.792
LGA    D    41_A      V      30           -
LGA    G    42_A      -       -           -
LGA    G    43_A      -       -           -
LGA    F    44_A      K      31          2.851
LGA    K    45_A      D      32          1.119
LGA    V    46_A      R      33          0.924
LGA    E    47_A      E      34          0.849
LGA    S    48_A      R      35          0.896
LGA    I    49_A      F      36          0.958
LGA    I    50_A      L      37          0.980
LGA    Y    51_A      A      38          0.650
LGA    Q    52_A      Q      39          1.171
LGA    V    53_A      V      40          1.674
LGA    E    54_A      E      41          1.662
LGA    N    55_A      E      42          1.950
LGA    G    56_A      F      43          1.422
LGA    K    57_A      -       -           -
LGA    G    58_A      -       -           -
LGA    A    59_A      -       -           -
LGA    M    60_A      V      44          4.448
LGA    P    61_A      F      45          2.574
LGA    -       -      K      46           -
LGA    -       -      C      47           -
LGA    -       -      P      48           -
LGA    -       -      V      49           -
LGA    -       -      C      50           -
LGA    -       -      G      51           -
LGA    -       -      E      52           -
LGA    -       -      E      53           -
LGA    -       -      F      54           -
LGA    A    62_A      Y      55          2.505
LGA    W    63_A      G      56          1.510
LGA    A    64_A      K      57          2.000
LGA    D    65_A      T      58          1.380
LGA    R    66_A      L      59          3.106
LGA    L    67_A      -       -           -
LGA    S    68_A      P      60          1.052
LGA    E    69_A      R      61          1.402
LGA    E    70_A      R      62          2.223
LGA    E    71_A      E      63          0.950
LGA    I    72_A      A      64          1.109
LGA    Q    73_A      E      65          2.424
LGA    A    74_A      K      66          1.757
LGA    V    75_A      V      67          1.767
LGA    A    76_A      -       -           -
LGA    E    77_A      F      68          1.184
LGA    Y    78_A      E      69          2.338
LGA    V    79_A      L      70          2.597
LGA    F    80_A      L      71          0.870
LGA    K    81_A      N      72          2.550
LGA    Q    82_A      D      73          4.520
LGA    A    83_A      -       -           -
LGA    T    84_A      F      74          3.585
LGA    D    85_A      K      75          1.943
LGA    A    86_A      G      76           #
LGA    A    87_A      G      77          3.204
LGA    W    88_A      I      78          1.745
LGA    K    89_A      D      79          4.935
LGA    -       -      W      80           -
LGA    -       -      E      81           -
LGA    Y    90_A      N      82          4.595
LGA    -       -      K      83           -
LGA    -       -      R      84           -
LGA    -       -      V      85           -
LGA    -       -      K      86           -
LGA    -       -      L      87           -
LGA    -       -      K      88           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   90   87    5.0     56    2.79    10.71     43.974     1.937

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.475739 * X  +   0.619392 * Y  +   0.624521 * Z  + -40.856674
  Y_new =  -0.859635 * X  +  -0.477778 * Y  +  -0.180986 * Z  + -25.303841
  Z_new =   0.186282 * X  +  -0.622962 * Y  +   0.759748 * Z  + -39.344849 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.686793    2.454799  [ DEG:   -39.3503    140.6496 ]
  Theta =  -0.187376   -2.954216  [ DEG:   -10.7359   -169.2641 ]
  Phi   =  -2.076261    1.065332  [ DEG:  -118.9610     61.0390 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1cyj_A                                        
REMARK     2: T0476.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1cyj_A.T0476.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   90   87   5.0   56   2.79   10.71  43.974
REMARK  ---------------------------------------------------------- 
MOLECULE 1cyj_A
HEADER    ELECTRON TRANSPORT PROTEIN (CYTOCHROME) 09-MAY-95   1CYJ              
TITLE     CYTOCHROME C6                                                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CYTOCHROME C6;                                             
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: CYTOCHROME C553                                             
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: CHLAMYDOMONAS REINHARDTII;                      
SOURCE   3 STRAIN: CC124;                                                       
SOURCE   4 ORGANELLE: CHLOROPLAST                                               
KEYWDS    PHOTOSYNTHESIS, CHLAMYDOMONAS                                         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    C.A.KERFELD,T.O.YEATES                                                
REVDAT   2   01-APR-03 1CYJ    1       JRNL                                     
REVDAT   1   29-JAN-96 1CYJ    0                                                
JRNL        AUTH   C.A.KERFELD,H.P.ANWAR,R.INTERRANTE,S.MERCHANT,               
JRNL        AUTH 2 T.O.YEATES                                                   
JRNL        TITL   THE STRUCTURE OF CHLOROPLAST CYTOCHROME C6 AT 1.9            
JRNL        TITL 2 A RESOLUTION: EVIDENCE FOR FUNCTIONAL                        
JRNL        TITL 3 OLIGOMERIZATION.                                             
JRNL        REF    J.MOL.BIOL.                   V. 250   627 1995              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  1CYJ A    1    90  UNP    P08197   CYC6_CHLRE      59    148             
SEQRES   1 A   90  ALA ASP LEU ALA LEU GLY ALA GLN VAL PHE ASN GLY ASN          
SEQRES   2 A   90  CYS ALA ALA CYS HIS MET GLY GLY ARG ASN SER VAL MET          
SEQRES   3 A   90  PRO GLU LYS THR LEU ASP LYS ALA ALA LEU GLU GLN TYR          
SEQRES   4 A   90  LEU ASP GLY GLY PHE LYS VAL GLU SER ILE ILE TYR GLN          
SEQRES   5 A   90  VAL GLU ASN GLY LYS GLY ALA MET PRO ALA TRP ALA ASP          
SEQRES   6 A   90  ARG LEU SER GLU GLU GLU ILE GLN ALA VAL ALA GLU TYR          
SEQRES   7 A   90  VAL PHE LYS GLN ALA THR ASP ALA ALA TRP LYS TYR              
HET     CD    300       1                                                       
HET     CD    301       1                                                       
HET     CD    302       1                                                       
HET     CD    303       1                                                       
HET    HEM    200      43                                                       
HETNAM      CD CADMIUM ION                                                      
HETNAM     HEM PROTOPORPHYRIN IX CONTAINING FE                                  
HETSYN     HEM HEME                                                             
FORMUL   2   CD    4(CD 2+)                                                     
FORMUL   6  HEM    C34 H32 FE N4 O4                                             
FORMUL   7  HOH   *72(H2 O)                                                     
CRYST1   81.600   81.600   81.600  90.00  90.00  90.00 I 2 3        24          
ATOM      1  N   ALA A   1      -8.162  -0.815  10.554  1.00 27.94           N  
ATOM      2  CA  ALA A   1      -6.728  -1.203  10.604  1.00 28.65           C  
ATOM      3  C   ALA A   1      -5.855  -0.039  10.172  1.00 28.53           C  
ATOM      4  O   ALA A   1      -6.263   1.123  10.251  1.00 29.98           O  
ATOM      5  CB  ALA A   1      -6.462  -2.426   9.703  1.00 30.11           C  
ATOM      6  N   ASP A   2      -4.674  -0.358   9.653  1.00 27.57           N  
ATOM      7  CA  ASP A   2      -3.746   0.662   9.207  1.00 25.43           C  
ATOM      8  C   ASP A   2      -4.198   1.263   7.886  1.00 24.64           C  
ATOM      9  O   ASP A   2      -3.947   0.715   6.837  1.00 24.69           O  
ATOM     10  CB  ASP A   2      -2.350   0.067   9.051  1.00 24.21           C  
ATOM     11  CG  ASP A   2      -1.269   1.117   9.052  1.00 23.82           C  
ATOM     12  OD1 ASP A   2      -1.493   2.243   8.548  1.00 23.01           O  
ATOM     13  OD2 ASP A   2      -0.181   0.818   9.576  1.00 24.69           O  
ATOM     14  N   LEU A   3      -4.848   2.410   7.936  1.00 24.29           N  
ATOM     15  CA  LEU A   3      -5.309   3.073   6.729  1.00 23.84           C  
ATOM     16  C   LEU A   3      -4.200   3.824   5.969  1.00 23.10           C  
ATOM     17  O   LEU A   3      -4.318   4.040   4.750  1.00 22.76           O  
ATOM     18  CB  LEU A   3      -6.510   3.987   7.054  1.00 25.33           C  
ATOM     19  CG  LEU A   3      -7.934   3.484   6.697  1.00 26.51           C  
ATOM     20  CD1 LEU A   3      -8.194   2.037   7.146  1.00 26.31           C  
ATOM     21  CD2 LEU A   3      -8.961   4.445   7.274  1.00 26.76           C  
ATOM     22  N   ALA A   4      -3.155   4.256   6.684  1.00 21.99           N  
ATOM     23  CA  ALA A   4      -2.031   4.952   6.064  1.00 20.38           C  
ATOM     24  C   ALA A   4      -1.275   3.943   5.178  1.00 19.85           C  
ATOM     25  O   ALA A   4      -0.846   4.271   4.071  1.00 19.67           O  
ATOM     26  CB  ALA A   4      -1.117   5.529   7.133  1.00 20.09           C  
ATOM     27  N   LEU A   5      -1.093   2.720   5.680  1.00 18.71           N  
ATOM     28  CA  LEU A   5      -0.425   1.664   4.920  1.00 18.28           C  
ATOM     29  C   LEU A   5      -1.287   1.263   3.728  1.00 18.10           C  
ATOM     30  O   LEU A   5      -0.773   0.858   2.688  1.00 18.13           O  
ATOM     31  CB  LEU A   5      -0.227   0.437   5.811  1.00 18.01           C  
ATOM     32  CG  LEU A   5       0.331  -0.843   5.198  1.00 17.51           C  
ATOM     33  CD1 LEU A   5       1.721  -0.590   4.611  1.00 16.68           C  
ATOM     34  CD2 LEU A   5       0.339  -1.927   6.258  1.00 16.88           C  
ATOM     35  N   GLY A   6      -2.602   1.284   3.936  1.00 18.55           N  
ATOM     36  CA  GLY A   6      -3.557   0.940   2.886  1.00 19.37           C  
ATOM     37  C   GLY A   6      -3.439   1.826   1.648  1.00 19.46           C  
ATOM     38  O   GLY A   6      -3.535   1.348   0.508  1.00 19.49           O  
ATOM     39  N   ALA A   7      -3.273   3.127   1.878  1.00 19.36           N  
ATOM     40  CA  ALA A   7      -3.125   4.116   0.811  1.00 19.46           C  
ATOM     41  C   ALA A   7      -1.792   3.890   0.115  1.00 19.46           C  
ATOM     42  O   ALA A   7      -1.715   3.956  -1.096  1.00 19.80           O  
ATOM     43  CB  ALA A   7      -3.195   5.542   1.392  1.00 19.50           C  
ATOM     44  N   GLN A   8      -0.742   3.630   0.887  1.00 19.44           N  
ATOM     45  CA  GLN A   8       0.569   3.378   0.326  1.00 19.99           C  
ATOM     46  C   GLN A   8       0.485   2.167  -0.603  1.00 19.47           C  
ATOM     47  O   GLN A   8       1.015   2.192  -1.717  1.00 19.19           O  
ATOM     48  CB  GLN A   8       1.548   3.108   1.463  1.00 22.45           C  
ATOM     49  CG  GLN A   8       3.024   3.040   1.093  1.00 25.60           C  
ATOM     50  CD  GLN A   8       3.832   2.336   2.185  1.00 27.98           C  
ATOM     51  OE1 GLN A   8       4.379   1.243   1.977  1.00 29.76           O  
ATOM     52  NE2 GLN A   8       3.840   2.919   3.379  1.00 28.36           N  
ATOM     53  N   VAL A   9      -0.141   1.093  -0.120  1.00 18.58           N  
ATOM     54  CA  VAL A   9      -0.318  -0.112  -0.922  1.00 17.69           C  
ATOM     55  C   VAL A   9      -1.240   0.143  -2.116  1.00 17.25           C  
ATOM     56  O   VAL A   9      -0.969  -0.339  -3.196  1.00 17.70           O  
ATOM     57  CB  VAL A   9      -0.875  -1.292  -0.087  1.00 17.59           C  
ATOM     58  CG1 VAL A   9      -1.291  -2.459  -0.996  1.00 17.11           C  
ATOM     59  CG2 VAL A   9       0.175  -1.750   0.924  1.00 18.27           C  
ATOM     60  N   PHE A  10      -2.357   0.842  -1.926  1.00 17.11           N  
ATOM     61  CA  PHE A  10      -3.241   1.115  -3.045  1.00 16.68           C  
ATOM     62  C   PHE A  10      -2.529   1.997  -4.056  1.00 17.45           C  
ATOM     63  O   PHE A  10      -2.601   1.747  -5.242  1.00 17.52           O  
ATOM     64  CB  PHE A  10      -4.520   1.809  -2.605  1.00 16.67           C  
ATOM     65  CG  PHE A  10      -5.538   1.963  -3.710  1.00 17.63           C  
ATOM     66  CD1 PHE A  10      -5.470   3.029  -4.598  1.00 18.25           C  
ATOM     67  CD2 PHE A  10      -6.561   1.021  -3.878  1.00 17.97           C  
ATOM     68  CE1 PHE A  10      -6.407   3.156  -5.638  1.00 18.48           C  
ATOM     69  CE2 PHE A  10      -7.492   1.135  -4.902  1.00 17.39           C  
ATOM     70  CZ  PHE A  10      -7.423   2.196  -5.785  1.00 17.60           C  
ATOM     71  N   ASN A  11      -1.848   3.031  -3.585  1.00 17.91           N  
ATOM     72  CA  ASN A  11      -1.147   3.948  -4.472  1.00 19.36           C  
ATOM     73  C   ASN A  11      -0.004   3.346  -5.273  1.00 19.26           C  
ATOM     74  O   ASN A  11       0.209   3.724  -6.428  1.00 19.75           O  
ATOM     75  CB  ASN A  11      -0.651   5.176  -3.703  1.00 20.14           C  
ATOM     76  CG  ASN A  11      -1.737   6.195  -3.491  1.00 22.56           C  
ATOM     77  OD1 ASN A  11      -2.880   5.991  -3.897  1.00 23.35           O  
ATOM     78  ND2 ASN A  11      -1.392   7.316  -2.871  1.00 24.55           N  
ATOM     79  N   GLY A  12       0.696   2.384  -4.688  1.00 19.20           N  
ATOM     80  CA  GLY A  12       1.829   1.765  -5.360  1.00 19.10           C  
ATOM     81  C   GLY A  12       1.605   0.497  -6.162  1.00 18.86           C  
ATOM     82  O   GLY A  12       2.500   0.074  -6.908  1.00 18.72           O  
ATOM     83  N   ASN A  13       0.423  -0.097  -6.031  1.00 18.08           N  
ATOM     84  CA  ASN A  13       0.104  -1.323  -6.743  1.00 17.84           C  
ATOM     85  C   ASN A  13      -1.221  -1.286  -7.517  1.00 17.79           C  
ATOM     86  O   ASN A  13      -1.316  -1.775  -8.625  1.00 18.03           O  
ATOM     87  CB  ASN A  13       0.016  -2.499  -5.759  1.00 18.15           C  
ATOM     88  CG  ASN A  13       1.328  -2.808  -5.070  1.00 18.08           C  
ATOM     89  OD1 ASN A  13       2.114  -3.591  -5.567  1.00 19.24           O  
ATOM     90  ND2 ASN A  13       1.522  -2.270  -3.871  1.00 17.76           N  
ATOM     91  N   CYS A  14      -2.259  -0.740  -6.910  1.00 17.84           N  
ATOM     92  CA  CYS A  14      -3.588  -0.747  -7.515  1.00 18.03           C  
ATOM     93  C   CYS A  14      -3.945   0.383  -8.463  1.00 18.84           C  
ATOM     94  O   CYS A  14      -4.807   0.225  -9.322  1.00 18.14           O  
ATOM     95  CB  CYS A  14      -4.620  -0.822  -6.393  1.00 16.77           C  
ATOM     96  SG  CYS A  14      -4.064  -1.951  -5.075  1.00 14.89           S  
ATOM     97  N   ALA A  15      -3.270   1.516  -8.290  1.00 20.12           N  
ATOM     98  CA  ALA A  15      -3.511   2.700  -9.090  1.00 21.49           C  
ATOM     99  C   ALA A  15      -3.185   2.559 -10.603  1.00 22.75           C  
ATOM    100  O   ALA A  15      -3.599   3.402 -11.405  1.00 23.77           O  
ATOM    101  CB  ALA A  15      -2.781   3.870  -8.481  1.00 21.18           C  
ATOM    102  N   ALA A  16      -2.461   1.509 -10.987  1.00 22.70           N  
ATOM    103  CA  ALA A  16      -2.135   1.293 -12.384  1.00 22.67           C  
ATOM    104  C   ALA A  16      -3.430   0.971 -13.134  1.00 23.36           C  
ATOM    105  O   ALA A  16      -3.519   1.151 -14.353  1.00 24.21           O  
ATOM    106  CB  ALA A  16      -1.134   0.146 -12.532  1.00 22.07           C  
ATOM    107  N   CYS A  17      -4.451   0.538 -12.397  1.00 23.00           N  
ATOM    108  CA  CYS A  17      -5.726   0.176 -13.002  1.00 21.90           C  
ATOM    109  C   CYS A  17      -6.968   0.813 -12.367  1.00 21.43           C  
ATOM    110  O   CYS A  17      -8.019   0.940 -13.010  1.00 20.94           O  
ATOM    111  CB  CYS A  17      -5.894  -1.329 -12.940  1.00 21.14           C  
ATOM    112  SG  CYS A  17      -4.702  -2.279 -13.915  1.00 21.58           S  
ATOM    113  N   HIS A  18      -6.855   1.177 -11.099  1.00 20.73           N  
ATOM    114  CA  HIS A  18      -7.975   1.737 -10.382  1.00 20.80           C  
ATOM    115  C   HIS A  18      -7.752   3.160  -9.984  1.00 22.28           C  
ATOM    116  O   HIS A  18      -8.183   3.570  -8.917  1.00 22.65           O  
ATOM    117  CB  HIS A  18      -8.284   0.903  -9.143  1.00 19.02           C  
ATOM    118  CG  HIS A  18      -8.667  -0.494  -9.605  1.00 17.71           C  
ATOM    119  ND1 HIS A  18      -9.800  -0.819 -10.316  1.00 16.05           N  
ATOM    120  CD2 HIS A  18      -8.070  -1.707  -9.185  1.00 18.07           C  
ATOM    121  CE1 HIS A  18      -9.886  -2.157 -10.302  1.00 16.39           C  
ATOM    122  NE2 HIS A  18      -8.955  -2.759  -9.603  1.00 16.06           N  
ATOM    123  N   MET A  19      -7.030   3.900 -10.820  1.00 23.77           N  
ATOM    124  CA  MET A  19      -6.772   5.324 -10.570  1.00 24.70           C  
ATOM    125  C   MET A  19      -8.118   5.976 -10.312  1.00 24.02           C  
ATOM    126  O   MET A  19      -9.057   5.807 -11.095  1.00 24.10           O  
ATOM    127  CB  MET A  19      -6.111   5.997 -11.792  1.00 26.55           C  
ATOM    128  CG  MET A  19      -5.738   7.457 -11.562  1.00 28.54           C  
ATOM    129  SD  MET A  19      -4.478   7.609 -10.268  1.00 31.79           S  
ATOM    130  CE  MET A  19      -3.061   7.210 -11.247  1.00 31.13           C  
ATOM    131  N   GLY A  20      -8.205   6.687  -9.194  1.00 23.15           N  
ATOM    132  CA  GLY A  20      -9.440   7.347  -8.815  1.00 22.72           C  
ATOM    133  C   GLY A  20     -10.628   6.411  -8.555  1.00 22.19           C  
ATOM    134  O   GLY A  20     -11.784   6.856  -8.627  1.00 21.90           O  
ATOM    135  N   GLY A  21     -10.355   5.139  -8.236  1.00 21.10           N  
ATOM    136  CA  GLY A  21     -11.418   4.186  -7.974  1.00 20.34           C  
ATOM    137  C   GLY A  21     -12.112   3.765  -9.234  1.00 19.97           C  
ATOM    138  O   GLY A  21     -13.173   3.175  -9.188  1.00 20.66           O  
ATOM    139  N   ARG A  22     -11.516   4.102 -10.364  1.00 20.43           N  
ATOM    140  CA  ARG A  22     -12.039   3.774 -11.688  1.00 21.08           C  
ATOM    141  C   ARG A  22     -11.603   2.384 -12.069  1.00 20.79           C  
ATOM    142  O   ARG A  22     -11.174   1.627 -11.215  1.00 20.40           O  
ATOM    143  CB  ARG A  22     -11.472   4.762 -12.719  1.00 22.62           C  
ATOM    144  CG  ARG A  22     -12.180   6.120 -12.764  1.00 23.49           C  
ATOM    145  CD  ARG A  22     -12.731   6.506 -11.400  1.00 25.24           C  
ATOM    146  NE  ARG A  22     -14.168   6.267 -11.272  1.00 26.68           N  
ATOM    147  CZ  ARG A  22     -14.843   6.160 -10.124  1.00 27.23           C  
ATOM    148  NH1 ARG A  22     -14.255   6.245  -8.939  1.00 27.77           N  
ATOM    149  NH2 ARG A  22     -16.148   6.051 -10.170  1.00 28.28           N  
ATOM    150  N   ASN A  23     -11.804   2.020 -13.330  1.00 20.58           N  
ATOM    151  CA  ASN A  23     -11.352   0.732 -13.825  1.00 21.14           C  
ATOM    152  C   ASN A  23     -11.059   0.854 -15.318  1.00 22.53           C  
ATOM    153  O   ASN A  23     -11.965   0.879 -16.167  1.00 22.66           O  
ATOM    154  CB  ASN A  23     -12.323  -0.410 -13.527  1.00 20.09           C  
ATOM    155  CG  ASN A  23     -11.669  -1.770 -13.695  1.00 19.28           C  
ATOM    156  OD1 ASN A  23     -10.707  -1.914 -14.444  1.00 18.82           O  
ATOM    157  ND2 ASN A  23     -12.171  -2.764 -12.986  1.00 18.22           N  
ATOM    158  N   SER A  24      -9.773   0.963 -15.627  1.00 23.42           N  
ATOM    159  CA  SER A  24      -9.325   1.127 -17.000  1.00 24.48           C  
ATOM    160  C   SER A  24      -9.419  -0.123 -17.885  1.00 25.02           C  
ATOM    161  O   SER A  24      -9.479  -0.006 -19.112  1.00 26.17           O  
ATOM    162  CB  SER A  24      -7.909   1.740 -17.032  1.00 24.50           C  
ATOM    163  OG  SER A  24      -6.955   0.945 -16.349  1.00 24.92           O  
ATOM    164  N   VAL A  25      -9.482  -1.309 -17.286  1.00 24.65           N  
ATOM    165  CA  VAL A  25      -9.557  -2.528 -18.071  1.00 24.03           C  
ATOM    166  C   VAL A  25     -11.011  -2.815 -18.372  1.00 24.29           C  
ATOM    167  O   VAL A  25     -11.380  -3.095 -19.500  1.00 23.93           O  
ATOM    168  CB  VAL A  25      -8.888  -3.718 -17.326  1.00 23.84           C  
ATOM    169  CG1 VAL A  25      -9.055  -4.980 -18.097  1.00 23.73           C  
ATOM    170  CG2 VAL A  25      -7.400  -3.460 -17.130  1.00 22.96           C  
ATOM    171  N   MET A  26     -11.847  -2.660 -17.357  1.00 24.97           N  
ATOM    172  CA  MET A  26     -13.271  -2.904 -17.459  1.00 25.97           C  
ATOM    173  C   MET A  26     -14.010  -1.746 -16.829  1.00 26.09           C  
ATOM    174  O   MET A  26     -14.376  -1.816 -15.666  1.00 26.73           O  
ATOM    175  CB  MET A  26     -13.588  -4.180 -16.687  1.00 27.36           C  
ATOM    176  CG  MET A  26     -14.029  -5.305 -17.553  1.00 29.60           C  
ATOM    177  SD  MET A  26     -13.881  -6.822 -16.703  1.00 32.00           S  
ATOM    178  CE  MET A  26     -12.353  -7.467 -17.468  1.00 32.80           C  
ATOM    179  N   PRO A  27     -14.297  -0.687 -17.599  1.00 26.06           N  
ATOM    180  CA  PRO A  27     -14.994   0.513 -17.133  1.00 25.69           C  
ATOM    181  C   PRO A  27     -16.111   0.371 -16.107  1.00 25.78           C  
ATOM    182  O   PRO A  27     -16.229   1.201 -15.201  1.00 26.31           O  
ATOM    183  CB  PRO A  27     -15.506   1.129 -18.437  1.00 24.87           C  
ATOM    184  CG  PRO A  27     -14.394   0.890 -19.330  1.00 24.98           C  
ATOM    185  CD  PRO A  27     -14.050  -0.580 -19.044  1.00 25.57           C  
ATOM    186  N   GLU A  28     -16.957  -0.640 -16.252  1.00 25.37           N  
ATOM    187  CA  GLU A  28     -18.062  -0.800 -15.319  1.00 25.32           C  
ATOM    188  C   GLU A  28     -17.739  -1.281 -13.916  1.00 23.86           C  
ATOM    189  O   GLU A  28     -18.424  -0.921 -12.975  1.00 23.63           O  
ATOM    190  CB  GLU A  28     -19.167  -1.629 -15.945  1.00 27.38           C  
ATOM    191  CG  GLU A  28     -20.130  -0.773 -16.758  1.00 30.96           C  
ATOM    192  CD  GLU A  28     -21.310  -0.240 -15.935  1.00 34.86           C  
ATOM    193  OE1 GLU A  28     -21.139   0.047 -14.719  1.00 37.45           O  
ATOM    194  OE2 GLU A  28     -22.425  -0.115 -16.503  1.00 35.66           O  
ATOM    195  N   LYS A  29     -16.731  -2.134 -13.791  1.00 22.76           N  
ATOM    196  CA  LYS A  29     -16.302  -2.646 -12.492  1.00 20.62           C  
ATOM    197  C   LYS A  29     -15.405  -1.640 -11.757  1.00 19.26           C  
ATOM    198  O   LYS A  29     -14.200  -1.858 -11.624  1.00 17.89           O  
ATOM    199  CB  LYS A  29     -15.547  -3.946 -12.683  1.00 21.18           C  
ATOM    200  CG  LYS A  29     -16.428  -5.159 -12.820  1.00 21.82           C  
ATOM    201  CD  LYS A  29     -16.905  -5.322 -14.220  1.00 22.06           C  
ATOM    202  CE  LYS A  29     -17.712  -6.607 -14.375  1.00 22.24           C  
ATOM    203  NZ  LYS A  29     -17.025  -7.787 -13.793  1.00 23.63           N  
ATOM    204  N   THR A  30     -16.002  -0.542 -11.301  1.00 18.74           N  
ATOM    205  CA  THR A  30     -15.281   0.499 -10.582  1.00 18.62           C  
ATOM    206  C   THR A  30     -15.262   0.223  -9.064  1.00 18.87           C  
ATOM    207  O   THR A  30     -15.958  -0.657  -8.562  1.00 18.11           O  
ATOM    208  CB  THR A  30     -15.918   1.873 -10.806  1.00 18.24           C  
ATOM    209  OG1 THR A  30     -17.184   1.905 -10.143  1.00 18.17           O  
ATOM    210  CG2 THR A  30     -16.112   2.148 -12.291  1.00 17.89           C  
ATOM    211  N   LEU A  31     -14.533   1.046  -8.320  1.00 19.22           N  
ATOM    212  CA  LEU A  31     -14.441   0.840  -6.884  1.00 19.52           C  
ATOM    213  C   LEU A  31     -15.482   1.591  -6.048  1.00 19.36           C  
ATOM    214  O   LEU A  31     -15.297   1.825  -4.847  1.00 18.19           O  
ATOM    215  CB  LEU A  31     -13.007   1.092  -6.404  1.00 20.08           C  
ATOM    216  CG  LEU A  31     -11.935   0.106  -6.887  1.00 19.78           C  
ATOM    217  CD1 LEU A  31     -11.894   0.174  -8.364  1.00 21.35           C  
ATOM    218  CD2 LEU A  31     -10.553   0.449  -6.333  1.00 19.19           C  
ATOM    219  N   ASP A  32     -16.572   1.977  -6.701  1.00 19.36           N  
ATOM    220  CA  ASP A  32     -17.650   2.657  -6.006  1.00 20.05           C  
ATOM    221  C   ASP A  32     -18.480   1.623  -5.277  1.00 19.34           C  
ATOM    222  O   ASP A  32     -18.522   0.471  -5.677  1.00 19.49           O  
ATOM    223  CB  ASP A  32     -18.532   3.410  -6.989  1.00 22.18           C  
ATOM    224  CG  ASP A  32     -17.818   4.569  -7.618  1.00 24.56           C  
ATOM    225  OD1 ASP A  32     -17.432   5.530  -6.889  1.00 27.02           O  
ATOM    226  OD2 ASP A  32     -17.614   4.495  -8.842  1.00 24.95           O  
ATOM    227  N   LYS A  33     -19.131   2.044  -4.206  1.00 19.01           N  
ATOM    228  CA  LYS A  33     -19.966   1.185  -3.389  1.00 19.12           C  
ATOM    229  C   LYS A  33     -21.001   0.391  -4.195  1.00 19.14           C  
ATOM    230  O   LYS A  33     -21.243  -0.811  -3.943  1.00 18.55           O  
ATOM    231  CB  LYS A  33     -20.673   2.054  -2.347  1.00 20.58           C  
ATOM    232  CG  LYS A  33     -21.663   1.338  -1.428  1.00 21.74           C  
ATOM    233  CD  LYS A  33     -22.399   2.351  -0.582  1.00 22.90           C  
ATOM    234  CE  LYS A  33     -23.486   1.708   0.257  1.00 23.73           C  
ATOM    235  NZ  LYS A  33     -22.932   1.158   1.517  1.00 24.83           N  
ATOM    236  N   ALA A  34     -21.633   1.080  -5.135  1.00 18.70           N  
ATOM    237  CA  ALA A  34     -22.665   0.477  -5.960  1.00 18.98           C  
ATOM    238  C   ALA A  34     -22.126  -0.483  -7.022  1.00 18.42           C  
ATOM    239  O   ALA A  34     -22.812  -1.439  -7.389  1.00 18.88           O  
ATOM    240  CB  ALA A  34     -23.561   1.570  -6.573  1.00 19.48           C  
ATOM    241  N   ALA A  35     -20.930  -0.206  -7.546  1.00 17.76           N  
ATOM    242  CA  ALA A  35     -20.301  -1.102  -8.499  1.00 17.23           C  
ATOM    243  C   ALA A  35     -19.994  -2.359  -7.701  1.00 17.17           C  
ATOM    244  O   ALA A  35     -20.317  -3.460  -8.119  1.00 16.68           O  
ATOM    245  CB  ALA A  35     -19.031  -0.518  -8.994  1.00 17.00           C  
ATOM    246  N   LEU A  36     -19.372  -2.165  -6.539  1.00 17.55           N  
ATOM    247  CA  LEU A  36     -19.013  -3.253  -5.635  1.00 17.86           C  
ATOM    248  C   LEU A  36     -20.224  -4.090  -5.268  1.00 18.66           C  
ATOM    249  O   LEU A  36     -20.167  -5.303  -5.297  1.00 18.69           O  
ATOM    250  CB  LEU A  36     -18.379  -2.710  -4.364  1.00 17.25           C  
ATOM    251  CG  LEU A  36     -16.870  -2.642  -4.107  1.00 17.72           C  
ATOM    252  CD1 LEU A  36     -16.060  -2.727  -5.356  1.00 16.94           C  
ATOM    253  CD2 LEU A  36     -16.551  -1.346  -3.377  1.00 17.13           C  
ATOM    254  N   GLU A  37     -21.309  -3.456  -4.873  1.00 19.84           N  
ATOM    255  CA  GLU A  37     -22.489  -4.228  -4.528  1.00 21.92           C  
ATOM    256  C   GLU A  37     -22.955  -5.026  -5.735  1.00 22.46           C  
ATOM    257  O   GLU A  37     -23.392  -6.159  -5.598  1.00 22.53           O  
ATOM    258  CB  GLU A  37     -23.646  -3.331  -4.115  1.00 24.20           C  
ATOM    259  CG  GLU A  37     -23.525  -2.644  -2.786  1.00 27.78           C  
ATOM    260  CD  GLU A  37     -24.621  -1.624  -2.623  1.00 31.02           C  
ATOM    261  OE1 GLU A  37     -24.462  -0.519  -3.197  1.00 32.19           O  
ATOM    262  OE2 GLU A  37     -25.657  -1.932  -1.964  1.00 33.18           O  
ATOM    263  N   GLN A  38     -22.880  -4.425  -6.916  1.00 22.78           N  
ATOM    264  CA  GLN A  38     -23.330  -5.083  -8.131  1.00 23.24           C  
ATOM    265  C   GLN A  38     -22.378  -6.134  -8.736  1.00 22.46           C  
ATOM    266  O   GLN A  38     -22.812  -7.245  -9.033  1.00 22.32           O  
ATOM    267  CB  GLN A  38     -23.715  -4.020  -9.168  1.00 25.46           C  
ATOM    268  CG  GLN A  38     -25.224  -3.596  -9.201  1.00 29.09           C  
ATOM    269  CD  GLN A  38     -25.903  -3.276  -7.840  1.00 31.17           C  
ATOM    270  OE1 GLN A  38     -26.529  -4.156  -7.218  1.00 32.34           O  
ATOM    271  NE2 GLN A  38     -25.858  -1.991  -7.421  1.00 31.16           N  
ATOM    272  N   TYR A  39     -21.079  -5.828  -8.839  1.00 21.86           N  
ATOM    273  CA  TYR A  39     -20.098  -6.745  -9.468  1.00 20.64           C  
ATOM    274  C   TYR A  39     -19.123  -7.576  -8.656  1.00 19.56           C  
ATOM    275  O   TYR A  39     -18.548  -8.515  -9.198  1.00 19.41           O  
ATOM    276  CB  TYR A  39     -19.250  -5.989 -10.499  1.00 20.47           C  
ATOM    277  CG  TYR A  39     -20.076  -5.213 -11.427  1.00 20.84           C  
ATOM    278  CD1 TYR A  39     -20.765  -5.849 -12.433  1.00 22.17           C  
ATOM    279  CD2 TYR A  39     -20.254  -3.861 -11.253  1.00 22.25           C  
ATOM    280  CE1 TYR A  39     -21.624  -5.172 -13.245  1.00 23.85           C  
ATOM    281  CE2 TYR A  39     -21.120  -3.158 -12.061  1.00 24.18           C  
ATOM    282  CZ  TYR A  39     -21.802  -3.831 -13.057  1.00 24.67           C  
ATOM    283  OH  TYR A  39     -22.670  -3.171 -13.878  1.00 26.55           O  
ATOM    284  N   LEU A  40     -18.840  -7.191  -7.412  1.00 18.92           N  
ATOM    285  CA  LEU A  40     -17.871  -7.970  -6.619  1.00 17.43           C  
ATOM    286  C   LEU A  40     -18.507  -9.201  -5.996  1.00 16.56           C  
ATOM    287  O   LEU A  40     -19.611  -9.113  -5.431  1.00 15.50           O  
ATOM    288  CB  LEU A  40     -17.205  -7.112  -5.529  1.00 16.85           C  
ATOM    289  CG  LEU A  40     -16.216  -7.807  -4.560  1.00 15.52           C  
ATOM    290  CD1 LEU A  40     -15.028  -8.410  -5.314  1.00 15.06           C  
ATOM    291  CD2 LEU A  40     -15.744  -6.826  -3.485  1.00 14.77           C  
ATOM    292  N   ASP A  41     -17.834 -10.343  -6.140  1.00 15.85           N  
ATOM    293  CA  ASP A  41     -18.330 -11.589  -5.567  1.00 15.70           C  
ATOM    294  C   ASP A  41     -18.441 -11.446  -4.060  1.00 15.10           C  
ATOM    295  O   ASP A  41     -17.482 -11.073  -3.411  1.00 15.01           O  
ATOM    296  CB  ASP A  41     -17.379 -12.733  -5.877  1.00 16.41           C  
ATOM    297  CG  ASP A  41     -17.469 -13.205  -7.315  1.00 17.98           C  
ATOM    298  OD1 ASP A  41     -18.463 -12.928  -8.011  1.00 17.49           O  
ATOM    299  OD2 ASP A  41     -16.512 -13.866  -7.763  1.00 19.22           O  
ATOM    300  N   GLY A  42     -19.598 -11.763  -3.500  1.00 14.50           N  
ATOM    301  CA  GLY A  42     -19.738 -11.631  -2.070  1.00 14.11           C  
ATOM    302  C   GLY A  42     -20.308 -10.277  -1.681  1.00 14.55           C  
ATOM    303  O   GLY A  42     -20.716 -10.090  -0.526  1.00 15.15           O  
ATOM    304  N   GLY A  43     -20.298  -9.311  -2.598  1.00 14.51           N  
ATOM    305  CA  GLY A  43     -20.877  -8.022  -2.277  1.00 14.70           C  
ATOM    306  C   GLY A  43     -19.936  -7.044  -1.635  1.00 15.43           C  
ATOM    307  O   GLY A  43     -18.724  -7.221  -1.663  1.00 15.71           O  
ATOM    308  N   PHE A  44     -20.500  -5.983  -1.076  1.00 16.03           N  
ATOM    309  CA  PHE A  44     -19.716  -4.934  -0.432  1.00 17.50           C  
ATOM    310  C   PHE A  44     -19.386  -5.247   1.045  1.00 17.39           C  
ATOM    311  O   PHE A  44     -20.151  -4.943   1.945  1.00 17.52           O  
ATOM    312  CB  PHE A  44     -20.474  -3.608  -0.578  1.00 18.47           C  
ATOM    313  CG  PHE A  44     -19.717  -2.400  -0.134  1.00 20.32           C  
ATOM    314  CD1 PHE A  44     -18.465  -2.113  -0.645  1.00 21.44           C  
ATOM    315  CD2 PHE A  44     -20.293  -1.504   0.755  1.00 21.33           C  
ATOM    316  CE1 PHE A  44     -17.800  -0.954  -0.285  1.00 22.45           C  
ATOM    317  CE2 PHE A  44     -19.629  -0.338   1.119  1.00 22.25           C  
ATOM    318  CZ  PHE A  44     -18.384  -0.062   0.597  1.00 22.79           C  
ATOM    319  N   LYS A  45     -18.214  -5.817   1.270  1.00 17.42           N  
ATOM    320  CA  LYS A  45     -17.735  -6.188   2.592  1.00 18.06           C  
ATOM    321  C   LYS A  45     -16.220  -6.210   2.439  1.00 17.95           C  
ATOM    322  O   LYS A  45     -15.716  -6.477   1.347  1.00 17.81           O  
ATOM    323  CB  LYS A  45     -18.189  -7.601   2.984  1.00 19.63           C  
ATOM    324  CG  LYS A  45     -19.688  -7.808   3.053  1.00 22.13           C  
ATOM    325  CD  LYS A  45     -20.085  -9.138   3.708  1.00 24.49           C  
ATOM    326  CE  LYS A  45     -19.588 -10.335   2.914  1.00 26.10           C  
ATOM    327  NZ  LYS A  45     -19.754 -11.617   3.686  1.00 29.06           N  
ATOM    328  N   VAL A  46     -15.510  -5.971   3.542  1.00 17.07           N  
ATOM    329  CA  VAL A  46     -14.051  -5.956   3.568  1.00 16.37           C  
ATOM    330  C   VAL A  46     -13.564  -7.323   3.157  1.00 16.57           C  
ATOM    331  O   VAL A  46     -12.593  -7.437   2.415  1.00 17.45           O  
ATOM    332  CB  VAL A  46     -13.510  -5.663   4.996  1.00 15.26           C  
ATOM    333  CG1 VAL A  46     -12.031  -5.874   5.056  1.00 14.98           C  
ATOM    334  CG2 VAL A  46     -13.814  -4.268   5.409  1.00 14.83           C  
ATOM    335  N   GLU A  47     -14.233  -8.359   3.654  1.00 15.91           N  
ATOM    336  CA  GLU A  47     -13.848  -9.728   3.335  1.00 15.71           C  
ATOM    337  C   GLU A  47     -13.885 -10.013   1.865  1.00 14.50           C  
ATOM    338  O   GLU A  47     -13.014 -10.699   1.381  1.00 14.69           O  
ATOM    339  CB  GLU A  47     -14.738 -10.741   4.014  1.00 17.13           C  
ATOM    340  CG  GLU A  47     -15.948 -10.126   4.638  1.00 20.58           C  
ATOM    341  CD  GLU A  47     -15.635  -9.607   5.998  1.00 21.92           C  
ATOM    342  OE1 GLU A  47     -14.754 -10.203   6.639  1.00 24.39           O  
ATOM    343  OE2 GLU A  47     -16.236  -8.625   6.437  1.00 22.25           O  
ATOM    344  N   SER A  48     -14.905  -9.548   1.164  1.00 13.44           N  
ATOM    345  CA  SER A  48     -15.005  -9.809  -0.271  1.00 12.93           C  
ATOM    346  C   SER A  48     -13.842  -9.174  -1.031  1.00 12.81           C  
ATOM    347  O   SER A  48     -13.334  -9.725  -1.996  1.00 12.74           O  
ATOM    348  CB  SER A  48     -16.315  -9.244  -0.810  1.00 12.85           C  
ATOM    349  OG  SER A  48     -17.394  -9.663  -0.010  1.00 13.40           O  
ATOM    350  N   ILE A  49     -13.444  -7.982  -0.610  1.00 12.84           N  
ATOM    351  CA  ILE A  49     -12.357  -7.281  -1.265  1.00 12.44           C  
ATOM    352  C   ILE A  49     -11.025  -8.008  -0.998  1.00 12.67           C  
ATOM    353  O   ILE A  49     -10.188  -8.140  -1.891  1.00 12.04           O  
ATOM    354  CB  ILE A  49     -12.329  -5.826  -0.794  1.00 11.84           C  
ATOM    355  CG1 ILE A  49     -13.666  -5.158  -1.111  1.00 11.71           C  
ATOM    356  CG2 ILE A  49     -11.274  -5.060  -1.528  1.00 12.27           C  
ATOM    357  CD1 ILE A  49     -13.836  -3.776  -0.503  1.00 11.46           C  
ATOM    358  N   ILE A  50     -10.825  -8.454   0.240  1.00 13.45           N  
ATOM    359  CA  ILE A  50      -9.605  -9.182   0.612  1.00 13.81           C  
ATOM    360  C   ILE A  50      -9.498 -10.421  -0.262  1.00 14.50           C  
ATOM    361  O   ILE A  50      -8.454 -10.658  -0.865  1.00 14.98           O  
ATOM    362  CB  ILE A  50      -9.611  -9.603   2.098  1.00 13.31           C  
ATOM    363  CG1 ILE A  50      -9.301  -8.397   2.953  1.00 13.33           C  
ATOM    364  CG2 ILE A  50      -8.577 -10.726   2.393  1.00 13.44           C  
ATOM    365  CD1 ILE A  50      -9.427  -8.685   4.393  1.00 14.33           C  
ATOM    366  N   TYR A  51     -10.574 -11.195  -0.334  1.00 15.08           N  
ATOM    367  CA  TYR A  51     -10.585 -12.410  -1.153  1.00 16.56           C  
ATOM    368  C   TYR A  51     -10.227 -12.107  -2.616  1.00 16.24           C  
ATOM    369  O   TYR A  51      -9.407 -12.796  -3.211  1.00 15.53           O  
ATOM    370  CB  TYR A  51     -11.948 -13.112  -1.081  1.00 18.61           C  
ATOM    371  CG  TYR A  51     -11.974 -14.473  -1.760  1.00 22.66           C  
ATOM    372  CD1 TYR A  51     -12.264 -14.602  -3.139  1.00 24.51           C  
ATOM    373  CD2 TYR A  51     -11.739 -15.649  -1.021  1.00 23.79           C  
ATOM    374  CE1 TYR A  51     -12.325 -15.883  -3.760  1.00 25.94           C  
ATOM    375  CE2 TYR A  51     -11.802 -16.923  -1.621  1.00 24.83           C  
ATOM    376  CZ  TYR A  51     -12.100 -17.042  -2.983  1.00 26.40           C  
ATOM    377  OH  TYR A  51     -12.242 -18.315  -3.528  1.00 27.83           O  
ATOM    378  N   GLN A  52     -10.867 -11.098  -3.195  1.00 16.37           N  
ATOM    379  CA  GLN A  52     -10.580 -10.719  -4.569  1.00 16.58           C  
ATOM    380  C   GLN A  52      -9.147 -10.202  -4.742  1.00 16.86           C  
ATOM    381  O   GLN A  52      -8.556 -10.376  -5.809  1.00 17.79           O  
ATOM    382  CB  GLN A  52     -11.595  -9.697  -5.095  1.00 16.61           C  
ATOM    383  CG  GLN A  52     -11.217  -9.099  -6.443  1.00 16.24           C  
ATOM    384  CD  GLN A  52     -12.259  -9.287  -7.474  1.00 15.26           C  
ATOM    385  OE1 GLN A  52     -12.411  -8.472  -8.366  1.00 15.70           O  
ATOM    386  NE2 GLN A  52     -12.973 -10.375  -7.380  1.00 15.51           N  
ATOM    387  N   VAL A  53      -8.562  -9.587  -3.715  1.00 17.02           N  
ATOM    388  CA  VAL A  53      -7.180  -9.089  -3.824  1.00 16.45           C  
ATOM    389  C   VAL A  53      -6.144 -10.220  -3.810  1.00 16.27           C  
ATOM    390  O   VAL A  53      -5.224 -10.227  -4.612  1.00 15.56           O  
ATOM    391  CB  VAL A  53      -6.861  -8.078  -2.714  1.00 17.03           C  
ATOM    392  CG1 VAL A  53      -5.355  -7.835  -2.613  1.00 17.01           C  
ATOM    393  CG2 VAL A  53      -7.584  -6.765  -2.998  1.00 17.41           C  
ATOM    394  N   GLU A  54      -6.344 -11.193  -2.926  1.00 16.94           N  
ATOM    395  CA  GLU A  54      -5.449 -12.332  -2.792  1.00 18.00           C  
ATOM    396  C   GLU A  54      -5.469 -13.337  -3.888  1.00 18.01           C  
ATOM    397  O   GLU A  54      -4.425 -13.891  -4.189  1.00 17.80           O  
ATOM    398  CB  GLU A  54      -5.734 -13.107  -1.533  1.00 18.96           C  
ATOM    399  CG  GLU A  54      -5.982 -12.256  -0.354  1.00 21.40           C  
ATOM    400  CD  GLU A  54      -5.797 -13.031   0.901  1.00 24.02           C  
ATOM    401  OE1 GLU A  54      -6.475 -14.071   1.071  1.00 25.12           O  
ATOM    402  OE2 GLU A  54      -4.943 -12.617   1.707  1.00 25.97           O  
ATOM    403  N   ASN A  55      -6.650 -13.623  -4.435  1.00 18.75           N  
ATOM    404  CA  ASN A  55      -6.800 -14.644  -5.493  1.00 19.90           C  
ATOM    405  C   ASN A  55      -7.004 -14.135  -6.894  1.00 20.10           C  
ATOM    406  O   ASN A  55      -7.113 -14.932  -7.810  1.00 20.11           O  
ATOM    407  CB  ASN A  55      -7.984 -15.569  -5.212  1.00 21.21           C  
ATOM    408  CG  ASN A  55      -7.867 -16.278  -3.907  1.00 23.08           C  
ATOM    409  OD1 ASN A  55      -6.989 -17.120  -3.712  1.00 25.18           O  
ATOM    410  ND2 ASN A  55      -8.721 -15.902  -2.969  1.00 23.64           N  
ATOM    411  N   GLY A  56      -7.152 -12.819  -7.040  1.00 20.64           N  
ATOM    412  CA  GLY A  56      -7.376 -12.215  -8.351  1.00 20.08           C  
ATOM    413  C   GLY A  56      -8.738 -12.510  -8.955  1.00 19.89           C  
ATOM    414  O   GLY A  56      -9.594 -13.114  -8.316  1.00 19.39           O  
ATOM    415  N   LYS A  57      -8.952 -12.023 -10.171  1.00 20.23           N  
ATOM    416  CA  LYS A  57     -10.209 -12.254 -10.889  1.00 21.03           C  
ATOM    417  C   LYS A  57     -10.040 -11.778 -12.327  1.00 21.09           C  
ATOM    418  O   LYS A  57      -9.890 -10.580 -12.597  1.00 20.65           O  
ATOM    419  CB  LYS A  57     -11.381 -11.554 -10.190  1.00 21.98           C  
ATOM    420  CG  LYS A  57     -12.777 -11.858 -10.743  1.00 23.44           C  
ATOM    421  CD  LYS A  57     -13.110 -13.352 -10.806  1.00 24.95           C  
ATOM    422  CE  LYS A  57     -13.625 -13.944  -9.498  1.00 25.78           C  
ATOM    423  NZ  LYS A  57     -12.600 -14.182  -8.460  1.00 27.62           N  
ATOM    424  N   GLY A  58      -9.991 -12.751 -13.233  1.00 21.54           N  
ATOM    425  CA  GLY A  58      -9.807 -12.478 -14.647  1.00 21.52           C  
ATOM    426  C   GLY A  58      -8.559 -11.666 -14.945  1.00 21.95           C  
ATOM    427  O   GLY A  58      -7.434 -12.077 -14.627  1.00 22.89           O  
ATOM    428  N   ALA A  59      -8.761 -10.468 -15.494  1.00 21.34           N  
ATOM    429  CA  ALA A  59      -7.669  -9.559 -15.846  1.00 21.03           C  
ATOM    430  C   ALA A  59      -7.030  -8.884 -14.636  1.00 20.64           C  
ATOM    431  O   ALA A  59      -6.106  -8.072 -14.785  1.00 20.61           O  
ATOM    432  CB  ALA A  59      -8.158  -8.502 -16.860  1.00 21.07           C  
ATOM    433  N   MET A  60      -7.609  -9.129 -13.457  1.00 19.70           N  
ATOM    434  CA  MET A  60      -7.059  -8.607 -12.220  1.00 17.82           C  
ATOM    435  C   MET A  60      -6.138  -9.697 -11.700  1.00 17.45           C  
ATOM    436  O   MET A  60      -6.584 -10.831 -11.451  1.00 16.70           O  
ATOM    437  CB  MET A  60      -8.145  -8.359 -11.183  1.00 17.73           C  
ATOM    438  CG  MET A  60      -7.526  -8.033  -9.851  1.00 16.94           C  
ATOM    439  SD  MET A  60      -8.460  -6.951  -8.894  1.00 15.58           S  
ATOM    440  CE  MET A  60      -7.860  -7.451  -7.270  1.00 15.95           C  
ATOM    441  N   PRO A  61      -4.847  -9.373 -11.507  1.00 17.32           N  
ATOM    442  CA  PRO A  61      -3.897 -10.381 -11.010  1.00 17.53           C  
ATOM    443  C   PRO A  61      -4.186 -10.673  -9.546  1.00 17.06           C  
ATOM    444  O   PRO A  61      -4.880  -9.904  -8.881  1.00 16.61           O  
ATOM    445  CB  PRO A  61      -2.523  -9.685 -11.127  1.00 17.18           C  
ATOM    446  CG  PRO A  61      -2.807  -8.348 -11.787  1.00 17.48           C  
ATOM    447  CD  PRO A  61      -4.246  -8.034 -11.481  1.00 17.22           C  
ATOM    448  N   ALA A  62      -3.619 -11.776  -9.074  1.00 17.12           N  
ATOM    449  CA  ALA A  62      -3.719 -12.216  -7.693  1.00 16.33           C  
ATOM    450  C   ALA A  62      -2.568 -11.521  -6.982  1.00 16.05           C  
ATOM    451  O   ALA A  62      -1.515 -11.289  -7.595  1.00 17.38           O  
ATOM    452  CB  ALA A  62      -3.541 -13.730  -7.634  1.00 16.79           C  
ATOM    453  N   TRP A  63      -2.738 -11.194  -5.710  1.00 14.69           N  
ATOM    454  CA  TRP A  63      -1.689 -10.492  -4.989  1.00 14.13           C  
ATOM    455  C   TRP A  63      -1.051 -11.275  -3.876  1.00 14.39           C  
ATOM    456  O   TRP A  63      -0.164 -10.782  -3.206  1.00 14.76           O  
ATOM    457  CB  TRP A  63      -2.225  -9.161  -4.470  1.00 12.56           C  
ATOM    458  CG  TRP A  63      -2.533  -8.215  -5.599  1.00 12.24           C  
ATOM    459  CD1 TRP A  63      -3.717  -8.103  -6.290  1.00 12.72           C  
ATOM    460  CD2 TRP A  63      -1.606  -7.358  -6.272  1.00 13.00           C  
ATOM    461  NE1 TRP A  63      -3.572  -7.255  -7.368  1.00 11.95           N  
ATOM    462  CE2 TRP A  63      -2.288  -6.783  -7.378  1.00 12.35           C  
ATOM    463  CE3 TRP A  63      -0.267  -7.017  -6.048  1.00 12.98           C  
ATOM    464  CZ2 TRP A  63      -1.673  -5.896  -8.251  1.00 12.64           C  
ATOM    465  CZ3 TRP A  63       0.340  -6.128  -6.915  1.00 13.77           C  
ATOM    466  CH2 TRP A  63      -0.361  -5.577  -8.005  1.00 13.39           C  
ATOM    467  N   ALA A  64      -1.502 -12.495  -3.670  1.00 14.74           N  
ATOM    468  CA  ALA A  64      -0.952 -13.308  -2.614  1.00 15.41           C  
ATOM    469  C   ALA A  64       0.564 -13.484  -2.639  1.00 16.08           C  
ATOM    470  O   ALA A  64       1.179 -13.663  -1.593  1.00 15.21           O  
ATOM    471  CB  ALA A  64      -1.609 -14.644  -2.626  1.00 15.11           C  
ATOM    472  N   ASP A  65       1.159 -13.439  -3.827  1.00 16.76           N  
ATOM    473  CA  ASP A  65       2.604 -13.656  -3.986  1.00 17.91           C  
ATOM    474  C   ASP A  65       3.465 -12.423  -3.860  1.00 18.36           C  
ATOM    475  O   ASP A  65       4.684 -12.534  -3.764  1.00 17.96           O  
ATOM    476  CB  ASP A  65       2.919 -14.251  -5.359  1.00 19.09           C  
ATOM    477  CG  ASP A  65       2.416 -15.661  -5.517  1.00 22.05           C  
ATOM    478  OD1 ASP A  65       2.385 -16.405  -4.505  1.00 23.56           O  
ATOM    479  OD2 ASP A  65       2.070 -16.041  -6.661  1.00 23.46           O  
ATOM    480  N   ARG A  66       2.826 -11.258  -3.937  1.00 18.52           N  
ATOM    481  CA  ARG A  66       3.526  -9.993  -3.911  1.00 18.29           C  
ATOM    482  C   ARG A  66       3.348  -9.164  -2.643  1.00 18.37           C  
ATOM    483  O   ARG A  66       4.217  -8.365  -2.284  1.00 18.31           O  
ATOM    484  CB  ARG A  66       3.074  -9.191  -5.135  1.00 18.03           C  
ATOM    485  CG  ARG A  66       3.166  -9.974  -6.440  1.00 17.96           C  
ATOM    486  CD  ARG A  66       2.641  -9.168  -7.617  1.00 18.87           C  
ATOM    487  NE  ARG A  66       3.489  -8.008  -7.867  1.00 20.40           N  
ATOM    488  CZ  ARG A  66       3.268  -7.089  -8.804  1.00 21.02           C  
ATOM    489  NH1 ARG A  66       2.206  -7.190  -9.614  1.00 20.88           N  
ATOM    490  NH2 ARG A  66       4.100  -6.046  -8.906  1.00 20.68           N  
ATOM    491  N   LEU A  67       2.192  -9.282  -2.000  1.00 17.85           N  
ATOM    492  CA  LEU A  67       1.945  -8.502  -0.797  1.00 17.26           C  
ATOM    493  C   LEU A  67       1.928  -9.364   0.454  1.00 16.75           C  
ATOM    494  O   LEU A  67       1.922 -10.583   0.373  1.00 16.81           O  
ATOM    495  CB  LEU A  67       0.620  -7.746  -0.916  1.00 17.19           C  
ATOM    496  CG  LEU A  67       0.428  -6.908  -2.173  1.00 16.90           C  
ATOM    497  CD1 LEU A  67      -0.880  -6.136  -2.080  1.00 16.69           C  
ATOM    498  CD2 LEU A  67       1.592  -5.964  -2.345  1.00 17.32           C  
ATOM    499  N   SER A  68       2.060  -8.713   1.601  1.00 16.23           N  
ATOM    500  CA  SER A  68       2.013  -9.428   2.847  1.00 16.08           C  
ATOM    501  C   SER A  68       0.556  -9.432   3.266  1.00 17.03           C  
ATOM    502  O   SER A  68      -0.256  -8.620   2.786  1.00 16.46           O  
ATOM    503  CB  SER A  68       2.835  -8.710   3.902  1.00 15.59           C  
ATOM    504  OG  SER A  68       2.272  -7.445   4.168  1.00 14.60           O  
ATOM    505  N   GLU A  69       0.246 -10.334   4.190  1.00 18.26           N  
ATOM    506  CA  GLU A  69      -1.085 -10.531   4.757  1.00 19.35           C  
ATOM    507  C   GLU A  69      -1.615  -9.249   5.384  1.00 19.21           C  
ATOM    508  O   GLU A  69      -2.794  -8.905   5.272  1.00 19.19           O  
ATOM    509  CB  GLU A  69      -0.986 -11.621   5.813  1.00 21.01           C  
ATOM    510  CG  GLU A  69      -2.278 -12.136   6.326  1.00 24.94           C  
ATOM    511  CD  GLU A  69      -3.125 -12.743   5.228  1.00 27.52           C  
ATOM    512  OE1 GLU A  69      -2.594 -13.467   4.349  1.00 28.62           O  
ATOM    513  OE2 GLU A  69      -4.343 -12.477   5.248  1.00 29.30           O  
ATOM    514  N   GLU A  70      -0.732  -8.503   6.006  1.00 18.68           N  
ATOM    515  CA  GLU A  70      -1.203  -7.314   6.620  1.00 18.72           C  
ATOM    516  C   GLU A  70      -1.431  -6.228   5.595  1.00 17.60           C  
ATOM    517  O   GLU A  70      -2.327  -5.414   5.744  1.00 16.71           O  
ATOM    518  CB  GLU A  70      -0.284  -6.887   7.737  1.00 20.37           C  
ATOM    519  CG  GLU A  70       0.941  -6.189   7.334  1.00 22.53           C  
ATOM    520  CD  GLU A  70       1.376  -5.239   8.430  1.00 24.68           C  
ATOM    521  OE1 GLU A  70       0.542  -4.982   9.342  1.00 25.22           O  
ATOM    522  OE2 GLU A  70       2.539  -4.750   8.375  1.00 25.94           O  
ATOM    523  N   GLU A  71      -0.647  -6.235   4.534  1.00 17.21           N  
ATOM    524  CA  GLU A  71      -0.828  -5.249   3.497  1.00 17.25           C  
ATOM    525  C   GLU A  71      -2.167  -5.439   2.796  1.00 17.00           C  
ATOM    526  O   GLU A  71      -2.806  -4.462   2.417  1.00 17.25           O  
ATOM    527  CB  GLU A  71       0.311  -5.331   2.495  1.00 18.13           C  
ATOM    528  CG  GLU A  71       1.571  -4.678   3.025  1.00 19.74           C  
ATOM    529  CD  GLU A  71       2.743  -4.891   2.130  1.00 21.28           C  
ATOM    530  OE1 GLU A  71       2.742  -5.881   1.361  1.00 21.21           O  
ATOM    531  OE2 GLU A  71       3.681  -4.079   2.215  1.00 23.32           O  
ATOM    532  N   ILE A  72      -2.558  -6.695   2.597  1.00 17.18           N  
ATOM    533  CA  ILE A  72      -3.819  -7.047   1.942  1.00 17.34           C  
ATOM    534  C   ILE A  72      -5.013  -6.584   2.777  1.00 17.34           C  
ATOM    535  O   ILE A  72      -5.972  -6.021   2.239  1.00 17.21           O  
ATOM    536  CB  ILE A  72      -3.926  -8.580   1.666  1.00 17.25           C  
ATOM    537  CG1 ILE A  72      -2.871  -9.014   0.646  1.00 17.50           C  
ATOM    538  CG2 ILE A  72      -5.307  -8.928   1.143  1.00 17.36           C  
ATOM    539  CD1 ILE A  72      -2.892 -10.519   0.319  1.00 18.81           C  
ATOM    540  N   GLN A  73      -4.949  -6.811   4.084  1.00 17.43           N  
ATOM    541  CA  GLN A  73      -6.016  -6.388   4.978  1.00 18.40           C  
ATOM    542  C   GLN A  73      -6.132  -4.856   4.984  1.00 17.75           C  
ATOM    543  O   GLN A  73      -7.230  -4.327   4.925  1.00 17.46           O  
ATOM    544  CB  GLN A  73      -5.806  -6.933   6.406  1.00 20.40           C  
ATOM    545  CG  GLN A  73      -6.754  -8.087   6.802  1.00 24.47           C  
ATOM    546  CD  GLN A  73      -6.177  -9.497   6.526  1.00 27.83           C  
ATOM    547  OE1 GLN A  73      -6.460 -10.450   7.261  1.00 29.16           O  
ATOM    548  NE2 GLN A  73      -5.373  -9.626   5.471  1.00 29.57           N  
ATOM    549  N   ALA A  74      -4.998  -4.152   5.014  1.00 16.93           N  
ATOM    550  CA  ALA A  74      -4.969  -2.685   4.998  1.00 15.84           C  
ATOM    551  C   ALA A  74      -5.581  -2.060   3.712  1.00 14.96           C  
ATOM    552  O   ALA A  74      -6.370  -1.085   3.785  1.00 14.42           O  
ATOM    553  CB  ALA A  74      -3.521  -2.207   5.167  1.00 16.04           C  
ATOM    554  N   VAL A  75      -5.140  -2.565   2.551  1.00 13.71           N  
ATOM    555  CA  VAL A  75      -5.617  -2.078   1.257  1.00 12.93           C  
ATOM    556  C   VAL A  75      -7.126  -2.305   1.112  1.00 12.70           C  
ATOM    557  O   VAL A  75      -7.849  -1.441   0.649  1.00 12.79           O  
ATOM    558  CB  VAL A  75      -4.799  -2.681   0.045  1.00 12.02           C  
ATOM    559  CG1 VAL A  75      -5.233  -4.104  -0.310  1.00 10.14           C  
ATOM    560  CG2 VAL A  75      -4.919  -1.755  -1.195  1.00 12.08           C  
ATOM    561  N   ALA A  76      -7.585  -3.461   1.558  1.00 13.11           N  
ATOM    562  CA  ALA A  76      -8.989  -3.822   1.534  1.00 13.85           C  
ATOM    563  C   ALA A  76      -9.828  -2.851   2.356  1.00 14.74           C  
ATOM    564  O   ALA A  76     -10.895  -2.434   1.915  1.00 14.79           O  
ATOM    565  CB  ALA A  76      -9.162  -5.234   2.079  1.00 12.18           C  
ATOM    566  N   GLU A  77      -9.382  -2.556   3.578  1.00 15.32           N  
ATOM    567  CA  GLU A  77     -10.113  -1.645   4.459  1.00 16.48           C  
ATOM    568  C   GLU A  77     -10.074  -0.215   3.957  1.00 15.81           C  
ATOM    569  O   GLU A  77     -10.998   0.561   4.185  1.00 15.44           O  
ATOM    570  CB  GLU A  77      -9.597  -1.765   5.914  1.00 20.09           C  
ATOM    571  CG  GLU A  77      -9.455  -3.250   6.363  1.00 24.81           C  
ATOM    572  CD  GLU A  77      -9.808  -3.533   7.825  1.00 27.95           C  
ATOM    573  OE1 GLU A  77     -10.756  -2.901   8.343  1.00 30.12           O  
ATOM    574  OE2 GLU A  77      -9.160  -4.433   8.436  1.00 29.48           O  
ATOM    575  N   TYR A  78      -8.977   0.124   3.294  1.00 15.88           N  
ATOM    576  CA  TYR A  78      -8.801   1.429   2.710  1.00 16.83           C  
ATOM    577  C   TYR A  78      -9.769   1.589   1.542  1.00 17.05           C  
ATOM    578  O   TYR A  78     -10.311   2.663   1.307  1.00 17.26           O  
ATOM    579  CB  TYR A  78      -7.364   1.587   2.211  1.00 17.24           C  
ATOM    580  CG  TYR A  78      -7.164   2.850   1.417  1.00 17.60           C  
ATOM    581  CD1 TYR A  78      -7.125   4.105   2.040  1.00 18.60           C  
ATOM    582  CD2 TYR A  78      -7.054   2.797   0.040  1.00 18.74           C  
ATOM    583  CE1 TYR A  78      -6.975   5.280   1.301  1.00 18.82           C  
ATOM    584  CE2 TYR A  78      -6.918   3.949  -0.720  1.00 20.06           C  
ATOM    585  CZ  TYR A  78      -6.868   5.191  -0.083  1.00 20.26           C  
ATOM    586  OH  TYR A  78      -6.660   6.298  -0.872  1.00 21.99           O  
ATOM    587  N   VAL A  79      -9.883   0.556   0.726  1.00 17.06           N  
ATOM    588  CA  VAL A  79     -10.777   0.621  -0.404  1.00 17.01           C  
ATOM    589  C   VAL A  79     -12.205   0.692   0.119  1.00 17.64           C  
ATOM    590  O   VAL A  79     -13.042   1.380  -0.461  1.00 17.52           O  
ATOM    591  CB  VAL A  79     -10.603  -0.612  -1.324  1.00 15.33           C  
ATOM    592  CG1 VAL A  79     -11.723  -0.687  -2.350  1.00 12.79           C  
ATOM    593  CG2 VAL A  79      -9.275  -0.525  -2.017  1.00 14.81           C  
ATOM    594  N   PHE A  80     -12.471  -0.040   1.198  1.00 17.93           N  
ATOM    595  CA  PHE A  80     -13.795  -0.088   1.789  1.00 18.74           C  
ATOM    596  C   PHE A  80     -14.180   1.283   2.303  1.00 19.81           C  
ATOM    597  O   PHE A  80     -15.297   1.765   2.059  1.00 20.03           O  
ATOM    598  CB  PHE A  80     -13.835  -1.138   2.914  1.00 18.74           C  
ATOM    599  CG  PHE A  80     -15.212  -1.375   3.508  1.00 18.73           C  
ATOM    600  CD1 PHE A  80     -16.187  -2.054   2.797  1.00 18.66           C  
ATOM    601  CD2 PHE A  80     -15.516  -0.928   4.783  1.00 19.58           C  
ATOM    602  CE1 PHE A  80     -17.446  -2.289   3.344  1.00 19.15           C  
ATOM    603  CE2 PHE A  80     -16.790  -1.162   5.340  1.00 19.75           C  
ATOM    604  CZ  PHE A  80     -17.750  -1.845   4.605  1.00 19.46           C  
ATOM    605  N   LYS A  81     -13.236   1.914   2.995  1.00 20.66           N  
ATOM    606  CA  LYS A  81     -13.420   3.234   3.577  1.00 21.15           C  
ATOM    607  C   LYS A  81     -13.730   4.269   2.508  1.00 21.17           C  
ATOM    608  O   LYS A  81     -14.620   5.104   2.694  1.00 20.87           O  
ATOM    609  CB  LYS A  81     -12.160   3.611   4.369  1.00 22.58           C  
ATOM    610  CG  LYS A  81     -11.838   5.113   4.427  1.00 25.01           C  
ATOM    611  CD  LYS A  81     -12.791   5.911   5.321  1.00 26.97           C  
ATOM    612  CE  LYS A  81     -12.632   5.538   6.800  1.00 28.39           C  
ATOM    613  NZ  LYS A  81     -13.440   6.435   7.665  1.00 29.57           N  
ATOM    614  N   GLN A  82     -13.003   4.202   1.390  1.00 21.41           N  
ATOM    615  CA  GLN A  82     -13.171   5.124   0.262  1.00 22.24           C  
ATOM    616  C   GLN A  82     -14.541   5.066  -0.411  1.00 22.69           C  
ATOM    617  O   GLN A  82     -15.093   6.094  -0.785  1.00 22.06           O  
ATOM    618  CB  GLN A  82     -12.095   4.873  -0.789  1.00 22.76           C  
ATOM    619  CG  GLN A  82     -10.699   5.310  -0.378  1.00 23.90           C  
ATOM    620  CD  GLN A  82     -10.584   6.818  -0.244  1.00 24.70           C  
ATOM    621  OE1 GLN A  82     -10.465   7.528  -1.231  1.00 24.94           O  
ATOM    622  NE2 GLN A  82     -10.646   7.307   0.981  1.00 25.65           N  
ATOM    623  N   ALA A  83     -15.072   3.858  -0.573  1.00 23.80           N  
ATOM    624  CA  ALA A  83     -16.376   3.663  -1.217  1.00 24.95           C  
ATOM    625  C   ALA A  83     -17.518   4.116  -0.311  1.00 25.55           C  
ATOM    626  O   ALA A  83     -18.491   4.712  -0.751  1.00 25.87           O  
ATOM    627  CB  ALA A  83     -16.548   2.211  -1.603  1.00 24.40           C  
ATOM    628  N   THR A  84     -17.396   3.789   0.963  1.00 26.75           N  
ATOM    629  CA  THR A  84     -18.383   4.156   1.972  1.00 28.03           C  
ATOM    630  C   THR A  84     -18.563   5.678   1.984  1.00 29.38           C  
ATOM    631  O   THR A  84     -19.689   6.181   1.876  1.00 30.15           O  
ATOM    632  CB  THR A  84     -17.927   3.667   3.389  1.00 27.30           C  
ATOM    633  OG1 THR A  84     -17.898   2.236   3.418  1.00 26.99           O  
ATOM    634  CG2 THR A  84     -18.866   4.153   4.473  1.00 27.33           C  
ATOM    635  N   ASP A  85     -17.446   6.393   2.106  1.00 30.03           N  
ATOM    636  CA  ASP A  85     -17.431   7.846   2.156  1.00 30.80           C  
ATOM    637  C   ASP A  85     -17.486   8.432   0.765  1.00 31.16           C  
ATOM    638  O   ASP A  85     -17.423   9.637   0.610  1.00 30.76           O  
ATOM    639  CB  ASP A  85     -16.141   8.353   2.825  1.00 31.19           C  
ATOM    640  CG  ASP A  85     -16.032   7.984   4.305  1.00 31.50           C  
ATOM    641  OD1 ASP A  85     -16.911   7.300   4.865  1.00 31.81           O  
ATOM    642  OD2 ASP A  85     -15.033   8.396   4.917  1.00 32.00           O  
ATOM    643  N   ALA A  86     -17.473   7.585  -0.251  1.00 32.10           N  
ATOM    644  CA  ALA A  86     -17.526   8.067  -1.630  1.00 33.32           C  
ATOM    645  C   ALA A  86     -16.426   9.112  -1.894  1.00 34.23           C  
ATOM    646  O   ALA A  86     -16.656  10.123  -2.559  1.00 34.82           O  
ATOM    647  CB  ALA A  86     -18.922   8.663  -1.927  1.00 32.63           C  
ATOM    648  N   ALA A  87     -15.222   8.844  -1.407  1.00 34.77           N  
ATOM    649  CA  ALA A  87     -14.098   9.763  -1.557  1.00 34.96           C  
ATOM    650  C   ALA A  87     -13.205   9.690  -2.809  1.00 35.70           C  
ATOM    651  O   ALA A  87     -12.218  10.433  -2.883  1.00 35.75           O  
ATOM    652  CB  ALA A  87     -13.235   9.693  -0.319  1.00 34.25           C  
ATOM    653  N   TRP A  88     -13.541   8.849  -3.794  1.00 36.39           N  
ATOM    654  CA  TRP A  88     -12.708   8.711  -5.021  1.00 37.04           C  
ATOM    655  C   TRP A  88     -12.749   9.944  -5.963  1.00 38.71           C  
ATOM    656  O   TRP A  88     -13.792  10.247  -6.583  1.00 39.19           O  
ATOM    657  CB  TRP A  88     -13.096   7.454  -5.822  1.00 35.16           C  
ATOM    658  CG  TRP A  88     -13.114   6.144  -5.058  1.00 32.13           C  
ATOM    659  CD1 TRP A  88     -14.221   5.440  -4.672  1.00 30.88           C  
ATOM    660  CD2 TRP A  88     -11.985   5.336  -4.707  1.00 30.35           C  
ATOM    661  NE1 TRP A  88     -13.850   4.242  -4.127  1.00 30.29           N  
ATOM    662  CE2 TRP A  88     -12.483   4.148  -4.138  1.00 29.68           C  
ATOM    663  CE3 TRP A  88     -10.596   5.493  -4.824  1.00 29.67           C  
ATOM    664  CZ2 TRP A  88     -11.647   3.124  -3.696  1.00 28.36           C  
ATOM    665  CZ3 TRP A  88      -9.769   4.470  -4.381  1.00 28.41           C  
ATOM    666  CH2 TRP A  88     -10.300   3.304  -3.827  1.00 28.04           C  
ATOM    667  N   LYS A  89     -11.592  10.586  -6.136  1.00 39.81           N  
ATOM    668  CA  LYS A  89     -11.459  11.802  -6.959  1.00 40.99           C  
ATOM    669  C   LYS A  89     -10.777  11.564  -8.322  1.00 41.36           C  
ATOM    670  O   LYS A  89      -9.546  11.587  -8.423  1.00 41.53           O  
ATOM    671  CB  LYS A  89     -10.686  12.881  -6.157  1.00 41.61           C  
ATOM    672  CG  LYS A  89     -10.910  12.840  -4.610  1.00 41.54           C  
ATOM    673  CD  LYS A  89     -10.431  14.091  -3.856  1.00 41.68           C  
ATOM    674  CE  LYS A  89      -8.984  14.472  -4.180  1.00 41.79           C  
ATOM    675  NZ  LYS A  89      -7.983  13.408  -3.882  1.00 42.08           N  
ATOM    676  N   TYR A  90     -11.594  11.409  -9.368  1.00 41.85           N  
ATOM    677  CA  TYR A  90     -11.121  11.147 -10.745  1.00 42.05           C  
ATOM    678  C   TYR A  90     -11.435  12.257 -11.797  1.00 42.27           C  
ATOM    679  O   TYR A  90     -12.033  13.295 -11.428  1.00 42.32           O  
ATOM    680  CB  TYR A  90     -11.697   9.803 -11.217  1.00 41.34           C  
ATOM    681  CG  TYR A  90     -13.211   9.729 -11.104  0.50 40.61           C  
ATOM    682  CD1 TYR A  90     -13.828   9.476  -9.885  0.50 40.07           C  
ATOM    683  CD2 TYR A  90     -14.016   9.916 -12.215  0.50 40.61           C  
ATOM    684  OXT TYR A  90     -11.079  12.087 -12.992  1.00 42.35           O  
TER     685      TYR A  90                                                      
END
MOLECULE T0476.pdb
ATOM     20  N   ALA     2       2.300  -1.329  -3.219  1.00  1.00          
ATOM     21  HN  ALA     2       2.119  -0.600  -3.850  1.00  1.00          
ATOM     22  CA  ALA     2       2.425  -2.698  -3.762  1.00  1.00          
ATOM     23  HA  ALA     2       2.430  -3.385  -2.927  1.00  1.00          
ATOM     24  CB  ALA     2       1.232  -3.027  -4.654  1.00  1.00          
ATOM     25  HB1 ALA     2       0.366  -3.248  -4.041  1.00  1.00          
ATOM     26  HB2 ALA     2       1.466  -3.884  -5.266  1.00  1.00          
ATOM     27  HB3 ALA     2       1.012  -2.181  -5.288  1.00  1.00          
ATOM     28  C   ALA     2       3.737  -2.860  -4.536  1.00  1.00          
ATOM     29  O   ALA     2       4.162  -1.925  -5.237  1.00  1.00          
ATOM     30  N   LYS     3       4.348  -4.064  -4.398  1.00  1.00          
ATOM     31  HN  LYS     3       3.910  -4.743  -3.851  1.00  1.00          
ATOM     32  CA  LYS     3       5.630  -4.420  -5.036  1.00  1.00          
ATOM     33  HA  LYS     3       5.927  -3.593  -5.664  1.00  1.00          
ATOM     34  CB  LYS     3       6.703  -4.642  -3.963  1.00  1.00          
ATOM     35  HB1 LYS     3       7.090  -5.646  -4.059  1.00  1.00          
ATOM     36  HB2 LYS     3       6.247  -4.534  -2.991  1.00  1.00          
ATOM     37  CG  LYS     3       7.866  -3.669  -4.054  1.00  1.00          
ATOM     38  HG1 LYS     3       7.478  -2.663  -4.070  1.00  1.00          
ATOM     39  HG2 LYS     3       8.415  -3.861  -4.963  1.00  1.00          
ATOM     40  CD  LYS     3       8.812  -3.819  -2.864  1.00  1.00          
ATOM     41  HD1 LYS     3       9.239  -4.812  -2.884  1.00  1.00          
ATOM     42  HD2 LYS     3       8.242  -3.692  -1.954  1.00  1.00          
ATOM     43  CE  LYS     3       9.950  -2.788  -2.891  1.00  1.00          
ATOM     44  HE1 LYS     3      10.366  -2.698  -1.895  1.00  1.00          
ATOM     45  HE2 LYS     3       9.543  -1.834  -3.190  1.00  1.00          
ATOM     46  NZ  LYS     3      11.048  -3.157  -3.838  1.00  1.00          
ATOM     47  HZ1 LYS     3      10.919  -4.134  -4.171  1.00  1.00          
ATOM     48  HZ2 LYS     3      11.970  -3.084  -3.363  1.00  1.00          
ATOM     49  HZ3 LYS     3      11.041  -2.517  -4.658  1.00  1.00          
ATOM     50  C   LYS     3       5.489  -5.670  -5.903  1.00  1.00          
ATOM     51  O   LYS     3       4.818  -6.637  -5.496  1.00  1.00          
ATOM     52  N   CYS     4       6.139  -5.626  -7.110  1.00  1.00          
ATOM     53  HN  CYS     4       6.610  -4.798  -7.337  1.00  1.00          
ATOM     54  CA  CYS     4       6.151  -6.739  -8.115  1.00  1.00          
ATOM     55  HA  CYS     4       5.134  -7.092  -8.210  1.00  1.00          
ATOM     56  HB1 CYS     4       7.690  -6.064  -9.456  1.00  1.00          
ATOM     57  HB2 CYS     4       6.138  -5.314  -9.733  1.00  1.00          
ATOM     58  C   CYS     4       7.052  -7.958  -7.664  1.00  1.00          
ATOM     59  O   CYS     4       8.242  -7.720  -7.359  1.00  1.00          
ATOM     60  CB  CYS     4       6.628  -6.236  -9.499  1.00  1.00          
ATOM     61  SG  CYS     4       6.315  -7.399 -10.876  1.00  1.00          
ATOM     62  ZN  CYS     4       7.178  -6.267 -12.689  1.00  1.00          
ATOM     63  N   PRO     5       6.504  -9.279  -7.551  1.00  1.00          
ATOM     64  CA  PRO     5       7.350 -10.468  -7.168  1.00  1.00          
ATOM     65  HA  PRO     5       7.965 -10.222  -6.313  1.00  1.00          
ATOM     66  CB  PRO     5       6.300 -11.538  -6.750  1.00  1.00          
ATOM     67  HB1 PRO     5       6.133 -11.486  -5.679  1.00  1.00          
ATOM     68  HB2 PRO     5       6.670 -12.522  -7.004  1.00  1.00          
ATOM     69  CG  PRO     5       5.042 -11.205  -7.513  1.00  1.00          
ATOM     70  HG1 PRO     5       4.168 -11.526  -6.955  1.00  1.00          
ATOM     71  HG2 PRO     5       5.061 -11.696  -8.482  1.00  1.00          
ATOM     72  CD  PRO     5       5.048  -9.697  -7.681  1.00  1.00          
ATOM     73  HD1 PRO     5       4.459  -9.227  -6.903  1.00  1.00          
ATOM     74  HD2 PRO     5       4.661  -9.417  -8.652  1.00  1.00          
ATOM     75  C   PRO     5       8.310 -10.999  -8.302  1.00  1.00          
ATOM     76  O   PRO     5       9.092 -11.941  -8.056  1.00  1.00          
ATOM     77  N   ILE     6       8.243 -10.351  -9.506  1.00  1.00          
ATOM     78  HN  ILE     6       7.662  -9.568  -9.601  1.00  1.00          
ATOM     79  CA  ILE     6       9.041 -10.718 -10.711  1.00  1.00          
ATOM     80  HA  ILE     6       9.414 -11.721 -10.556  1.00  1.00          
ATOM     81  CB  ILE     6       8.166 -10.709 -12.075  1.00  1.00          
ATOM     82  HB  ILE     6       8.010  -9.665 -12.339  1.00  1.00          
ATOM     83  CG1 ILE     6       6.780 -11.397 -11.928  1.00  1.00          
ATOM     84 HG11 ILE     6       6.684 -11.787 -10.923  1.00  1.00          
ATOM     85 HG12 ILE     6       6.717 -12.214 -12.630  1.00  1.00          
ATOM     86  CG2 ILE     6       8.885 -11.402 -13.266  1.00  1.00          
ATOM     87 HG21 ILE     6       8.195 -11.508 -14.089  1.00  1.00          
ATOM     88 HG22 ILE     6       9.234 -12.376 -12.960  1.00  1.00          
ATOM     89 HG23 ILE     6       9.727 -10.799 -13.576  1.00  1.00          
ATOM     90  CD1 ILE     6       5.603 -10.477 -12.185  1.00  1.00          
ATOM     91 HD11 ILE     6       5.734  -9.980 -13.135  1.00  1.00          
ATOM     92 HD12 ILE     6       5.545  -9.738 -11.398  1.00  1.00          
ATOM     93 HD13 ILE     6       4.690 -11.054 -12.203  1.00  1.00          
ATOM     94  C   ILE     6      10.267  -9.754 -10.836  1.00  1.00          
ATOM     95  O   ILE     6      11.410 -10.247 -10.885  1.00  1.00          
ATOM     96  N   CYS     7       9.997  -8.409 -10.880  1.00  1.00          
ATOM     97  HN  CYS     7       9.068  -8.099 -10.752  1.00  1.00          
ATOM     98  CA  CYS     7      11.045  -7.379 -11.052  1.00  1.00          
ATOM     99  HA  CYS     7      11.937  -7.900 -11.371  1.00  1.00          
ATOM    100  HB1 CYS     7      10.463  -6.971 -13.068  1.00  1.00          
ATOM    101  HB2 CYS     7      11.466  -5.723 -12.357  1.00  1.00          
ATOM    102  C   CYS     7      11.386  -6.643  -9.742  1.00  1.00          
ATOM    103  O   CYS     7      12.579  -6.407  -9.475  1.00  1.00          
ATOM    104  CB  CYS     7      10.644  -6.397 -12.176  1.00  1.00          
ATOM    105  SG  CYS     7       9.154  -5.367 -11.862  1.00  1.00          
ATOM    106  N   GLY     8      10.326  -6.300  -8.947  1.00  1.00          
ATOM    107  HN  GLY     8       9.429  -6.536  -9.259  1.00  1.00          
ATOM    108  CA  GLY     8      10.463  -5.587  -7.658  1.00  1.00          
ATOM    109  HA1 GLY     8      11.409  -5.858  -7.215  1.00  1.00          
ATOM    110  HA2 GLY     8       9.671  -5.911  -7.002  1.00  1.00          
ATOM    111  C   GLY     8      10.398  -4.062  -7.773  1.00  1.00          
ATOM    112  O   GLY     8      11.113  -3.371  -7.024  1.00  1.00          
ATOM    113  N   SER     9       9.543  -3.559  -8.714  1.00  1.00          
ATOM    114  HN  SER     9       9.028  -4.201  -9.268  1.00  1.00          
ATOM    115  CA  SER     9       9.353  -2.108  -8.955  1.00  1.00          
ATOM    116  HA  SER     9      10.245  -1.616  -8.608  1.00  1.00          
ATOM    117  CB  SER     9       9.190  -1.838 -10.450  1.00  1.00          
ATOM    118  HB1 SER     9       8.515  -1.007 -10.590  1.00  1.00          
ATOM    119  HB2 SER     9       8.784  -2.717 -10.929  1.00  1.00          
ATOM    120  OG  SER     9      10.434  -1.523 -11.050  1.00  1.00          
ATOM    121  HG  SER     9      11.071  -1.296 -10.369  1.00  1.00          
ATOM    122  C   SER     9       8.118  -1.543  -8.168  1.00  1.00          
ATOM    123  O   SER     9       7.155  -2.318  -7.998  1.00  1.00          
ATOM    124  N   PRO    10       8.068  -0.182  -7.677  1.00  1.00          
ATOM    125  CA  PRO    10       6.894   0.366  -6.898  1.00  1.00          
ATOM    126  HA  PRO    10       6.675  -0.274  -6.053  1.00  1.00          
ATOM    127  CB  PRO    10       7.377   1.745  -6.389  1.00  1.00          
ATOM    128  HB1 PRO    10       7.094   1.885  -5.351  1.00  1.00          
ATOM    129  HB2 PRO    10       6.922   2.521  -6.992  1.00  1.00          
ATOM    130  CG  PRO    10       8.860   1.719  -6.557  1.00  1.00          
ATOM    131  HG1 PRO    10       9.323   1.230  -5.709  1.00  1.00          
ATOM    132  HG2 PRO    10       9.246   2.726  -6.667  1.00  1.00          
ATOM    133  CD  PRO    10       9.089   0.921  -7.810  1.00  1.00          
ATOM    134  HD1 PRO    10      10.092   0.531  -7.830  1.00  1.00          
ATOM    135  HD2 PRO    10       8.896   1.526  -8.686  1.00  1.00          
ATOM    136  C   PRO    10       5.597   0.545  -7.715  1.00  1.00          
ATOM    137  O   PRO    10       5.643   0.957  -8.890  1.00  1.00          
ATOM    138  N   LEU    11       4.473   0.213  -7.043  1.00  1.00          
ATOM    139  HN  LEU    11       4.572  -0.110  -6.123  1.00  1.00          
ATOM    140  CA  LEU    11       3.105   0.301  -7.592  1.00  1.00          
ATOM    141  HA  LEU    11       3.157   0.823  -8.536  1.00  1.00          
ATOM    142  CB  LEU    11       2.505  -1.103  -7.823  1.00  1.00          
ATOM    143  HB1 LEU    11       1.435  -0.986  -7.961  1.00  1.00          
ATOM    144  HB2 LEU    11       2.671  -1.689  -6.932  1.00  1.00          
ATOM    145  CG  LEU    11       3.057  -1.892  -9.022  1.00  1.00          
ATOM    146  HG  LEU    11       4.007  -1.471  -9.320  1.00  1.00          
ATOM    147  CD1 LEU    11       3.294  -3.342  -8.631  1.00  1.00          
ATOM    148 HD11 LEU    11       2.387  -3.756  -8.216  1.00  1.00          
ATOM    149 HD12 LEU    11       4.082  -3.393  -7.896  1.00  1.00          
ATOM    150 HD13 LEU    11       3.580  -3.909  -9.505  1.00  1.00          
ATOM    151  CD2 LEU    11       2.100  -1.814 -10.209  1.00  1.00          
ATOM    152 HD21 LEU    11       1.811  -0.785 -10.370  1.00  1.00          
ATOM    153 HD22 LEU    11       1.222  -2.406 -10.003  1.00  1.00          
ATOM    154 HD23 LEU    11       2.591  -2.193 -11.094  1.00  1.00          
ATOM    155  C   LEU    11       2.200   1.084  -6.640  1.00  1.00          
ATOM    156  O   LEU    11       2.354   0.979  -5.405  1.00  1.00          
ATOM    157  N   LYS    12       1.248   1.846  -7.239  1.00  1.00          
ATOM    158  HN  LYS    12       1.205   1.847  -8.218  1.00  1.00          
ATOM    159  CA  LYS    12       0.268   2.672  -6.500  1.00  1.00          
ATOM    160  HA  LYS    12       0.655   2.832  -5.504  1.00  1.00          
ATOM    161  CB  LYS    12       0.071   4.039  -7.188  1.00  1.00          
ATOM    162  HB1 LYS    12      -0.862   4.462  -6.847  1.00  1.00          
ATOM    163  HB2 LYS    12       0.009   3.879  -8.253  1.00  1.00          
ATOM    164  CG  LYS    12       1.177   5.060  -6.932  1.00  1.00          
ATOM    165  HG1 LYS    12       2.125   4.636  -7.231  1.00  1.00          
ATOM    166  HG2 LYS    12       1.202   5.296  -5.878  1.00  1.00          
ATOM    167  CD  LYS    12       0.933   6.337  -7.719  1.00  1.00          
ATOM    168  HD1 LYS    12       0.002   6.777  -7.392  1.00  1.00          
ATOM    169  HD2 LYS    12       0.868   6.093  -8.769  1.00  1.00          
ATOM    170  CE  LYS    12       2.054   7.343  -7.518  1.00  1.00          
ATOM    171  HE1 LYS    12       2.989   6.884  -7.799  1.00  1.00          
ATOM    172  HE2 LYS    12       2.087   7.622  -6.476  1.00  1.00          
ATOM    173  NZ  LYS    12       1.848   8.568  -8.341  1.00  1.00          
ATOM    174  HZ1 LYS    12       0.845   8.844  -8.326  1.00  1.00          
ATOM    175  HZ2 LYS    12       2.133   8.389  -9.324  1.00  1.00          
ATOM    176  HZ3 LYS    12       2.418   9.351  -7.963  1.00  1.00          
ATOM    177  C   LYS    12      -1.081   1.956  -6.396  1.00  1.00          
ATOM    178  O   LYS    12      -1.559   1.377  -7.390  1.00  1.00          
ATOM    179  N   TRP    13      -1.672   1.996  -5.160  1.00  1.00          
ATOM    180  HN  TRP    13      -1.181   2.442  -4.438  1.00  1.00          
ATOM    181  CA  TRP    13      -3.017   1.404  -4.824  1.00  1.00          
ATOM    182  HA  TRP    13      -3.015   0.400  -5.221  1.00  1.00          
ATOM    183  CB  TRP    13      -3.201   1.310  -3.305  1.00  1.00          
ATOM    184  HB1 TRP    13      -4.256   1.293  -3.074  1.00  1.00          
ATOM    185  HB2 TRP    13      -2.746   2.171  -2.837  1.00  1.00          
ATOM    186  CG  TRP    13      -2.569   0.062  -2.712  1.00  1.00          
ATOM    187  CD1 TRP    13      -1.316  -0.023  -2.173  1.00  1.00          
ATOM    188  HD1 TRP    13      -0.631   0.809  -2.108  1.00  1.00          
ATOM    189  CD2 TRP    13      -3.138  -1.276  -2.597  1.00  1.00          
ATOM    190  NE1 TRP    13      -1.061  -1.302  -1.745  1.00  1.00          
ATOM    191  HE1 TRP    13      -0.226  -1.604  -1.327  1.00  1.00          
ATOM    192  CE2 TRP    13      -2.156  -2.089  -1.988  1.00  1.00          
ATOM    193  CE3 TRP    13      -4.371  -1.874  -2.944  1.00  1.00          
ATOM    194  HE3 TRP    13      -5.157  -1.299  -3.410  1.00  1.00          
ATOM    195  CZ2 TRP    13      -2.361  -3.447  -1.724  1.00  1.00          
ATOM    196  HZ2 TRP    13      -1.601  -4.066  -1.262  1.00  1.00          
ATOM    197  CZ3 TRP    13      -4.566  -3.216  -2.675  1.00  1.00          
ATOM    198  HZ3 TRP    13      -5.504  -3.685  -2.935  1.00  1.00          
ATOM    199  CH2 TRP    13      -3.565  -3.989  -2.072  1.00  1.00          
ATOM    200  HH2 TRP    13      -3.762  -5.034  -1.877  1.00  1.00          
ATOM    201  C   TRP    13      -4.207   2.161  -5.486  1.00  1.00          
ATOM    202  O   TRP    13      -5.280   1.571  -5.690  1.00  1.00          
ATOM    203  N   GLU    14      -3.968   3.482  -5.801  1.00  1.00          
ATOM    204  HN  GLU    14      -3.096   3.848  -5.548  1.00  1.00          
ATOM    205  CA  GLU    14      -4.922   4.411  -6.497  1.00  1.00          
ATOM    206  HA  GLU    14      -5.875   4.335  -5.994  1.00  1.00          
ATOM    207  CB  GLU    14      -4.427   5.865  -6.398  1.00  1.00          
ATOM    208  HB1 GLU    14      -4.913   6.447  -7.167  1.00  1.00          
ATOM    209  HB2 GLU    14      -3.361   5.878  -6.573  1.00  1.00          
ATOM    210  CG  GLU    14      -4.688   6.541  -5.055  1.00  1.00          
ATOM    211  HG1 GLU    14      -4.184   5.982  -4.281  1.00  1.00          
ATOM    212  HG2 GLU    14      -5.752   6.539  -4.866  1.00  1.00          
ATOM    213  CD  GLU    14      -4.193   7.975  -5.018  1.00  1.00          
ATOM    214  OE1 GLU    14      -4.994   8.888  -5.307  1.00  1.00          
ATOM    215  OE2 GLU    14      -3.003   8.183  -4.699  1.00  1.00          
ATOM    216  C   GLU    14      -5.129   4.058  -8.000  1.00  1.00          
ATOM    217  O   GLU    14      -6.217   4.314  -8.541  1.00  1.00          
ATOM    218  N   GLU    15      -4.055   3.473  -8.649  1.00  1.00          
ATOM    219  HN  GLU    15      -3.230   3.319  -8.128  1.00  1.00          
ATOM    220  CA  GLU    15      -4.048   3.031 -10.086  1.00  1.00          
ATOM    221  HA  GLU    15      -4.509   3.819 -10.662  1.00  1.00          
ATOM    222  CB  GLU    15      -2.604   2.844 -10.589  1.00  1.00          
ATOM    223  HB1 GLU    15      -2.622   2.205 -11.460  1.00  1.00          
ATOM    224  HB2 GLU    15      -2.029   2.360  -9.813  1.00  1.00          
ATOM    225  CG  GLU    15      -1.895   4.143 -10.965  1.00  1.00          
ATOM    226  HG1 GLU    15      -1.851   4.779 -10.092  1.00  1.00          
ATOM    227  HG2 GLU    15      -2.462   4.638 -11.739  1.00  1.00          
ATOM    228  CD  GLU    15      -0.482   3.918 -11.472  1.00  1.00          
ATOM    229  OE1 GLU    15      -0.304   3.799 -12.703  1.00  1.00          
ATOM    230  OE2 GLU    15       0.448   3.863 -10.638  1.00  1.00          
ATOM    231  C   GLU    15      -4.856   1.726 -10.327  1.00  1.00          
ATOM    232  O   GLU    15      -5.487   1.583 -11.386  1.00  1.00          
ATOM    233  N   LEU    16      -4.815   0.793  -9.313  1.00  1.00          
ATOM    234  HN  LEU    16      -4.272   1.013  -8.527  1.00  1.00          
ATOM    235  CA  LEU    16      -5.531  -0.525  -9.302  1.00  1.00          
ATOM    236  HA  LEU    16      -5.286  -1.030 -10.224  1.00  1.00          
ATOM    237  CB  LEU    16      -5.014  -1.371  -8.126  1.00  1.00          
ATOM    238  HB1 LEU    16      -5.761  -2.115  -7.894  1.00  1.00          
ATOM    239  HB2 LEU    16      -4.901  -0.721  -7.271  1.00  1.00          
ATOM    240  CG  LEU    16      -3.682  -2.089  -8.365  1.00  1.00          
ATOM    241  HG  LEU    16      -3.230  -1.706  -9.269  1.00  1.00          
ATOM    242  CD1 LEU    16      -2.723  -1.829  -7.213  1.00  1.00          
ATOM    243 HD11 LEU    16      -2.434  -0.789  -7.217  1.00  1.00          
ATOM    244 HD12 LEU    16      -1.845  -2.446  -7.329  1.00  1.00          
ATOM    245 HD13 LEU    16      -3.209  -2.064  -6.275  1.00  1.00          
ATOM    246  CD2 LEU    16      -3.906  -3.581  -8.543  1.00  1.00          
ATOM    247 HD21 LEU    16      -4.651  -3.744  -9.307  1.00  1.00          
ATOM    248 HD22 LEU    16      -4.247  -4.007  -7.610  1.00  1.00          
ATOM    249 HD23 LEU    16      -2.980  -4.051  -8.836  1.00  1.00          
ATOM    250  C   LEU    16      -7.082  -0.392  -9.222  1.00  1.00          
ATOM    251  O   LEU    16      -7.797  -1.152  -9.894  1.00  1.00          
ATOM    252  N   ILE    17      -7.564   0.589  -8.376  1.00  1.00          
ATOM    253  HN  ILE    17      -6.905   1.114  -7.878  1.00  1.00          
ATOM    254  CA  ILE    17      -9.021   0.920  -8.154  1.00  1.00          
ATOM    255  HA  ILE    17      -9.547  -0.023  -8.086  1.00  1.00          
ATOM    256  CB  ILE    17      -9.283   1.731  -6.766  1.00  1.00          
ATOM    257  HB  ILE    17      -9.012   2.758  -6.972  1.00  1.00          
ATOM    258  CG1 ILE    17      -8.423   1.252  -5.486  1.00  1.00          
ATOM    259 HG11 ILE    17      -8.829   1.751  -4.615  1.00  1.00          
ATOM    260 HG12 ILE    17      -7.411   1.598  -5.620  1.00  1.00          
ATOM    261  CG2 ILE    17     -10.798   1.759  -6.372  1.00  1.00          
ATOM    262 HG21 ILE    17     -11.113   0.765  -6.095  1.00  1.00          
ATOM    263 HG22 ILE    17     -11.380   2.095  -7.220  1.00  1.00          
ATOM    264 HG23 ILE    17     -10.945   2.433  -5.542  1.00  1.00          
ATOM    265  CD1 ILE    17      -8.315  -0.266  -5.133  1.00  1.00          
ATOM    266 HD11 ILE    17      -8.367  -0.391  -4.061  1.00  1.00          
ATOM    267 HD12 ILE    17      -7.375  -0.655  -5.494  1.00  1.00          
ATOM    268 HD13 ILE    17      -9.128  -0.801  -5.599  1.00  1.00          
ATOM    269  C   ILE    17      -9.605   1.706  -9.392  1.00  1.00          
ATOM    270  O   ILE    17     -10.742   1.429  -9.806  1.00  1.00          
ATOM    271  N   GLU    18      -8.789   2.673  -9.944  1.00  1.00          
ATOM    272  HN  GLU    18      -7.909   2.811  -9.536  1.00  1.00          
ATOM    273  CA  GLU    18      -9.137   3.532 -11.124  1.00  1.00          
ATOM    274  HA  GLU    18     -10.094   3.986 -10.916  1.00  1.00          
ATOM    275  CB  GLU    18      -8.092   4.649 -11.264  1.00  1.00          
ATOM    276  HB1 GLU    18      -7.478   4.443 -12.126  1.00  1.00          
ATOM    277  HB2 GLU    18      -7.468   4.653 -10.384  1.00  1.00          
ATOM    278  CG  GLU    18      -8.691   6.039 -11.426  1.00  1.00          
ATOM    279  HG1 GLU    18      -9.296   6.259 -10.558  1.00  1.00          
ATOM    280  HG2 GLU    18      -9.313   6.049 -12.308  1.00  1.00          
ATOM    281  CD  GLU    18      -7.632   7.113 -11.566  1.00  1.00          
ATOM    282  OE1 GLU    18      -7.356   7.526 -12.712  1.00  1.00          
ATOM    283  OE2 GLU    18      -7.077   7.544 -10.532  1.00  1.00          
ATOM    284  C   GLU    18      -9.252   2.738 -12.462  1.00  1.00          
ATOM    285  O   GLU    18     -10.109   3.070 -13.297  1.00  1.00          
ATOM    286  N   GLU    19      -8.371   1.695 -12.623  1.00  1.00          
ATOM    287  HN  GLU    19      -7.726   1.518 -11.907  1.00  1.00          
ATOM    288  CA  GLU    19      -8.326   0.776 -13.795  1.00  1.00          
ATOM    289  HA  GLU    19      -8.483   1.363 -14.687  1.00  1.00          
ATOM    290  CB  GLU    19      -6.951   0.112 -13.876  1.00  1.00          
ATOM    291  HB1 GLU    19      -7.044  -0.762 -14.480  1.00  1.00          
ATOM    292  HB2 GLU    19      -6.669  -0.194 -12.881  1.00  1.00          
ATOM    293  CG  GLU    19      -5.837   0.985 -14.458  1.00  1.00          
ATOM    294  HG1 GLU    19      -5.715   1.857 -13.831  1.00  1.00          
ATOM    295  HG2 GLU    19      -6.124   1.295 -15.452  1.00  1.00          
ATOM    296  CD  GLU    19      -4.511   0.255 -14.541  1.00  1.00          
ATOM    297  OE1 GLU    19      -3.762   0.268 -13.542  1.00  1.00          
ATOM    298  OE2 GLU    19      -4.221  -0.332 -15.606  1.00  1.00          
ATOM    299  C   GLU    19      -9.394  -0.352 -13.738  1.00  1.00          
ATOM    300  O   GLU    19      -9.772  -0.895 -14.796  1.00  1.00          
ATOM    301  N   MET    20      -9.869  -0.662 -12.495  1.00  1.00          
ATOM    302  HN  MET    20      -9.596  -0.098 -11.738  1.00  1.00          
ATOM    303  CA  MET    20     -10.851  -1.732 -12.224  1.00  1.00          
ATOM    304  HA  MET    20     -10.869  -2.350 -13.108  1.00  1.00          
ATOM    305  CB  MET    20     -10.362  -2.600 -11.039  1.00  1.00          
ATOM    306  HB1 MET    20     -11.204  -3.141 -10.644  1.00  1.00          
ATOM    307  HB2 MET    20      -9.976  -1.948 -10.271  1.00  1.00          
ATOM    308  CG  MET    20      -9.271  -3.611 -11.399  1.00  1.00          
ATOM    309  HG1 MET    20      -8.427  -3.078 -11.810  1.00  1.00          
ATOM    310  HG2 MET    20      -9.661  -4.290 -12.143  1.00  1.00          
ATOM    311  SD  MET    20      -8.712  -4.575  -9.980  1.00  1.00          
ATOM    312  CE  MET    20      -9.788  -6.004 -10.086  1.00  1.00          
ATOM    313  HE1 MET    20      -9.826  -6.498  -9.128  1.00  1.00          
ATOM    314  HE2 MET    20      -9.405  -6.688 -10.829  1.00  1.00          
ATOM    315  HE3 MET    20     -10.781  -5.687 -10.369  1.00  1.00          
ATOM    316  C   MET    20     -12.301  -1.185 -11.975  1.00  1.00          
ATOM    317  O   MET    20     -13.238  -1.979 -11.741  1.00  1.00          
ATOM    318  N   LEU    21     -12.478   0.177 -12.072  1.00  1.00          
ATOM    319  HN  LEU    21     -11.693   0.723 -12.292  1.00  1.00          
ATOM    320  CA  LEU    21     -13.782   0.887 -11.867  1.00  1.00          
ATOM    321  HA  LEU    21     -14.289   0.374 -11.064  1.00  1.00          
ATOM    322  CB  LEU    21     -13.467   2.336 -11.407  1.00  1.00          
ATOM    323  HB1 LEU    21     -13.584   2.989 -12.261  1.00  1.00          
ATOM    324  HB2 LEU    21     -12.435   2.372 -11.093  1.00  1.00          
ATOM    325  CG  LEU    21     -14.335   2.892 -10.262  1.00  1.00          
ATOM    326  HG  LEU    21     -15.254   2.327 -10.201  1.00  1.00          
ATOM    327  CD1 LEU    21     -13.620   2.772  -8.918  1.00  1.00          
ATOM    328 HD11 LEU    21     -12.795   3.469  -8.885  1.00  1.00          
ATOM    329 HD12 LEU    21     -13.246   1.766  -8.798  1.00  1.00          
ATOM    330 HD13 LEU    21     -14.313   2.996  -8.120  1.00  1.00          
ATOM    331  CD2 LEU    21     -14.700   4.342 -10.537  1.00  1.00          
ATOM    332 HD21 LEU    21     -15.350   4.393 -11.397  1.00  1.00          
ATOM    333 HD22 LEU    21     -13.801   4.908 -10.730  1.00  1.00          
ATOM    334 HD23 LEU    21     -15.207   4.754  -9.677  1.00  1.00          
ATOM    335  C   LEU    21     -14.727   0.863 -13.135  1.00  1.00          
ATOM    336  O   LEU    21     -15.767   1.563 -13.176  1.00  1.00          
ATOM    337  N   ILE    22     -14.367  -0.011 -14.121  1.00  1.00          
ATOM    338  HN  ILE    22     -13.573  -0.559 -13.970  1.00  1.00          
ATOM    339  CA  ILE    22     -15.104  -0.215 -15.411  1.00  1.00          
ATOM    340  HA  ILE    22     -15.610   0.719 -15.613  1.00  1.00          
ATOM    341  CB  ILE    22     -14.139  -0.497 -16.648  1.00  1.00          
ATOM    342  HB  ILE    22     -14.761  -0.873 -17.439  1.00  1.00          
ATOM    343  CG1 ILE    22     -12.992  -1.534 -16.396  1.00  1.00          
ATOM    344 HG11 ILE    22     -13.044  -1.877 -15.372  1.00  1.00          
ATOM    345 HG12 ILE    22     -12.038  -1.053 -16.559  1.00  1.00          
ATOM    346  CG2 ILE    22     -13.533   0.810 -17.141  1.00  1.00          
ATOM    347 HG21 ILE    22     -12.992   1.277 -16.331  1.00  1.00          
ATOM    348 HG22 ILE    22     -14.317   1.471 -17.478  1.00  1.00          
ATOM    349 HG23 ILE    22     -12.856   0.608 -17.957  1.00  1.00          
ATOM    350  CD1 ILE    22     -13.061  -2.746 -17.301  1.00  1.00          
ATOM    351 HD11 ILE    22     -12.869  -2.447 -18.322  1.00  1.00          
ATOM    352 HD12 ILE    22     -14.045  -3.187 -17.235  1.00  1.00          
ATOM    353 HD13 ILE    22     -12.320  -3.470 -16.994  1.00  1.00          
ATOM    354  C   ILE    22     -16.215  -1.322 -15.323  1.00  1.00          
ATOM    355  O   ILE    22     -17.017  -1.469 -16.268  1.00  1.00          
ATOM    356  N   ILE    23     -16.246  -2.055 -14.171  1.00  1.00          
ATOM    357  HN  ILE    23     -15.585  -1.830 -13.484  1.00  1.00          
ATOM    358  CA  ILE    23     -17.214  -3.161 -13.879  1.00  1.00          
ATOM    359  HA  ILE    23     -17.643  -3.471 -14.825  1.00  1.00          
ATOM    360  CB  ILE    23     -16.551  -4.456 -13.175  1.00  1.00          
ATOM    361  HB  ILE    23     -16.448  -4.234 -12.120  1.00  1.00          
ATOM    362  CG1 ILE    23     -15.152  -4.836 -13.744  1.00  1.00          
ATOM    363 HG11 ILE    23     -14.885  -4.128 -14.517  1.00  1.00          
ATOM    364 HG12 ILE    23     -15.205  -5.823 -14.174  1.00  1.00          
ATOM    365  CG2 ILE    23     -17.446  -5.719 -13.302  1.00  1.00          
ATOM    366 HG21 ILE    23     -17.422  -6.076 -14.321  1.00  1.00          
ATOM    367 HG22 ILE    23     -18.461  -5.469 -13.032  1.00  1.00          
ATOM    368 HG23 ILE    23     -17.079  -6.490 -12.640  1.00  1.00          
ATOM    369  CD1 ILE    23     -14.038  -4.841 -12.711  1.00  1.00          
ATOM    370 HD11 ILE    23     -14.212  -5.629 -11.994  1.00  1.00          
ATOM    371 HD12 ILE    23     -14.012  -3.887 -12.201  1.00  1.00          
ATOM    372 HD13 ILE    23     -13.090  -5.007 -13.204  1.00  1.00          
ATOM    373  C   ILE    23     -18.357  -2.596 -12.990  1.00  1.00          
ATOM    374  O   ILE    23     -18.095  -1.832 -12.042  1.00  1.00          
ATOM    375  N   GLU    24     -19.615  -3.011 -13.335  1.00  1.00          
ATOM    376  HN  GLU    24     -19.700  -3.609 -14.107  1.00  1.00          
ATOM    377  CA  GLU    24     -20.878  -2.622 -12.613  1.00  1.00          
ATOM    378  HA  GLU    24     -20.795  -1.568 -12.408  1.00  1.00          
ATOM    379  CB  GLU    24     -22.112  -2.847 -13.495  1.00  1.00          
ATOM    380  HB1 GLU    24     -22.982  -2.924 -12.859  1.00  1.00          
ATOM    381  HB2 GLU    24     -21.989  -3.775 -14.032  1.00  1.00          
ATOM    382  CG  GLU    24     -22.360  -1.739 -14.511  1.00  1.00          
ATOM    383  HG1 GLU    24     -21.510  -1.680 -15.176  1.00  1.00          
ATOM    384  HG2 GLU    24     -22.468  -0.802 -13.983  1.00  1.00          
ATOM    385  CD  GLU    24     -23.610  -1.974 -15.337  1.00  1.00          
ATOM    386  OE1 GLU    24     -23.513  -2.654 -16.379  1.00  1.00          
ATOM    387  OE2 GLU    24     -24.686  -1.479 -14.939  1.00  1.00          
ATOM    388  C   GLU    24     -21.069  -3.339 -11.252  1.00  1.00          
ATOM    389  O   GLU    24     -21.730  -2.783 -10.360  1.00  1.00          
ATOM    390  N   ASN    25     -20.478  -4.575 -11.123  1.00  1.00          
ATOM    391  HN  ASN    25     -20.016  -4.937 -11.907  1.00  1.00          
ATOM    392  CA  ASN    25     -20.485  -5.413  -9.877  1.00  1.00          
ATOM    393  HA  ASN    25     -21.503  -5.455  -9.519  1.00  1.00          
ATOM    394  CB  ASN    25     -20.018  -6.835 -10.202  1.00  1.00          
ATOM    395  HB1 ASN    25     -19.629  -7.294  -9.305  1.00  1.00          
ATOM    396  HB2 ASN    25     -19.237  -6.792 -10.946  1.00  1.00          
ATOM    397  CG  ASN    25     -21.139  -7.703 -10.735  1.00  1.00          
ATOM    398  OD1 ASN    25     -21.366  -7.775 -11.943  1.00  1.00          
ATOM    399  ND2 ASN    25     -21.847  -8.370  -9.832  1.00  1.00          
ATOM    400 HD21 ASN    25     -21.609  -8.265  -8.887  1.00  1.00          
ATOM    401 HD22 ASN    25     -22.580  -8.940 -10.146  1.00  1.00          
ATOM    402  C   ASN    25     -19.587  -4.826  -8.745  1.00  1.00          
ATOM    403  O   ASN    25     -19.800  -5.128  -7.561  1.00  1.00          
ATOM    404  N   PHE    26     -18.579  -3.974  -9.164  1.00  1.00          
ATOM    405  HN  PHE    26     -18.479  -3.886 -10.131  1.00  1.00          
ATOM    406  CA  PHE    26     -17.585  -3.264  -8.287  1.00  1.00          
ATOM    407  HA  PHE    26     -17.010  -4.031  -7.794  1.00  1.00          
ATOM    408  CB  PHE    26     -16.615  -2.431  -9.145  1.00  1.00          
ATOM    409  HB1 PHE    26     -16.916  -1.401  -9.104  1.00  1.00          
ATOM    410  HB2 PHE    26     -16.679  -2.767 -10.166  1.00  1.00          
ATOM    411  CG  PHE    26     -15.159  -2.522  -8.700  1.00  1.00          
ATOM    412  CD1 PHE    26     -14.630  -1.587  -7.813  1.00  1.00          
ATOM    413  HD1 PHE    26     -15.259  -0.786  -7.451  1.00  1.00          
ATOM    414  CD2 PHE    26     -14.325  -3.548  -9.152  1.00  1.00          
ATOM    415  HD2 PHE    26     -14.718  -4.283  -9.840  1.00  1.00          
ATOM    416  CE1 PHE    26     -13.316  -1.672  -7.392  1.00  1.00          
ATOM    417  HE1 PHE    26     -12.922  -0.940  -6.702  1.00  1.00          
ATOM    418  CE2 PHE    26     -13.012  -3.634  -8.730  1.00  1.00          
ATOM    419  HE2 PHE    26     -12.384  -4.438  -9.082  1.00  1.00          
ATOM    420  CZ  PHE    26     -12.508  -2.696  -7.849  1.00  1.00          
ATOM    421  HZ  PHE    26     -11.480  -2.761  -7.520  1.00  1.00          
ATOM    422  C   PHE    26     -18.221  -2.379  -7.186  1.00  1.00          
ATOM    423  O   PHE    26     -17.657  -2.266  -6.085  1.00  1.00          
ATOM    424  N   GLU    27     -19.401  -1.766  -7.527  1.00  1.00          
ATOM    425  HN  GLU    27     -19.712  -1.879  -8.450  1.00  1.00          
ATOM    426  CA  GLU    27     -20.248  -0.926  -6.599  1.00  1.00          
ATOM    427  HA  GLU    27     -19.621  -0.140  -6.211  1.00  1.00          
ATOM    428  CB  GLU    27     -21.426  -0.290  -7.359  1.00  1.00          
ATOM    429  HB1 GLU    27     -22.166   0.029  -6.640  1.00  1.00          
ATOM    430  HB2 GLU    27     -21.866  -1.036  -8.002  1.00  1.00          
ATOM    431  CG  GLU    27     -21.055   0.915  -8.220  1.00  1.00          
ATOM    432  HG1 GLU    27     -20.294   0.616  -8.927  1.00  1.00          
ATOM    433  HG2 GLU    27     -20.662   1.691  -7.579  1.00  1.00          
ATOM    434  CD  GLU    27     -22.238   1.474  -8.985  1.00  1.00          
ATOM    435  OE1 GLU    27     -22.504   0.988 -10.104  1.00  1.00          
ATOM    436  OE2 GLU    27     -22.900   2.396  -8.465  1.00  1.00          
ATOM    437  C   GLU    27     -20.810  -1.753  -5.397  1.00  1.00          
ATOM    438  O   GLU    27     -21.054  -1.194  -4.316  1.00  1.00          
ATOM    439  N   GLU    28     -20.997  -3.093  -5.650  1.00  1.00          
ATOM    440  HN  GLU    28     -20.774  -3.414  -6.558  1.00  1.00          
ATOM    441  CA  GLU    28     -21.472  -4.102  -4.659  1.00  1.00          
ATOM    442  HA  GLU    28     -22.153  -3.600  -3.987  1.00  1.00          
ATOM    443  CB  GLU    28     -22.229  -5.230  -5.379  1.00  1.00          
ATOM    444  HB1 GLU    28     -22.140  -6.133  -4.791  1.00  1.00          
ATOM    445  HB2 GLU    28     -21.762  -5.395  -6.343  1.00  1.00          
ATOM    446  CG  GLU    28     -23.724  -4.942  -5.591  1.00  1.00          
ATOM    447  HG1 GLU    28     -24.047  -5.388  -6.524  1.00  1.00          
ATOM    448  HG2 GLU    28     -23.864  -3.873  -5.642  1.00  1.00          
ATOM    449  CD  GLU    28     -24.602  -5.487  -4.473  1.00  1.00          
ATOM    450  OE1 GLU    28     -24.852  -6.711  -4.457  1.00  1.00          
ATOM    451  OE2 GLU    28     -25.035  -4.688  -3.616  1.00  1.00          
ATOM    452  C   GLU    28     -20.313  -4.697  -3.816  1.00  1.00          
ATOM    453  O   GLU    28     -20.512  -4.990  -2.625  1.00  1.00          
ATOM    454  N   ILE    29     -19.100  -4.858  -4.465  1.00  1.00          
ATOM    455  HN  ILE    29     -19.056  -4.577  -5.402  1.00  1.00          
ATOM    456  CA  ILE    29     -17.826  -5.391  -3.839  1.00  1.00          
ATOM    457  HA  ILE    29     -18.119  -6.251  -3.247  1.00  1.00          
ATOM    458  CB  ILE    29     -16.741  -5.905  -4.933  1.00  1.00          
ATOM    459  HB  ILE    29     -16.436  -5.047  -5.515  1.00  1.00          
ATOM    460  CG1 ILE    29     -17.347  -6.982  -5.891  1.00  1.00          
ATOM    461 HG11 ILE    29     -18.421  -6.990  -5.770  1.00  1.00          
ATOM    462 HG12 ILE    29     -16.959  -7.948  -5.606  1.00  1.00          
ATOM    463  CG2 ILE    29     -15.462  -6.544  -4.282  1.00  1.00          
ATOM    464 HG21 ILE    29     -14.576  -6.253  -4.832  1.00  1.00          
ATOM    465 HG22 ILE    29     -15.553  -7.620  -4.293  1.00  1.00          
ATOM    466 HG23 ILE    29     -15.380  -6.204  -3.259  1.00  1.00          
ATOM    467  CD1 ILE    29     -17.050  -6.801  -7.383  1.00  1.00          
ATOM    468 HD11 ILE    29     -16.128  -6.252  -7.511  1.00  1.00          
ATOM    469 HD12 ILE    29     -17.859  -6.262  -7.849  1.00  1.00          
ATOM    470 HD13 ILE    29     -16.953  -7.772  -7.848  1.00  1.00          
ATOM    471  C   ILE    29     -17.214  -4.327  -2.842  1.00  1.00          
ATOM    472  O   ILE    29     -16.719  -4.716  -1.772  1.00  1.00          
ATOM    473  N   VAL    30     -17.268  -3.006  -3.232  1.00  1.00          
ATOM    474  HN  VAL    30     -17.681  -2.807  -4.098  1.00  1.00          
ATOM    475  CA  VAL    30     -16.734  -1.828  -2.423  1.00  1.00          
ATOM    476  HA  VAL    30     -15.699  -2.078  -2.227  1.00  1.00          
ATOM    477  CB  VAL    30     -16.721  -0.442  -3.218  1.00  1.00          
ATOM    478  HB  VAL    30     -16.463   0.331  -2.501  1.00  1.00          
ATOM    479  CG1 VAL    30     -15.615  -0.442  -4.273  1.00  1.00          
ATOM    480 HG11 VAL    30     -15.795  -1.240  -4.979  1.00  1.00          
ATOM    481 HG12 VAL    30     -14.659  -0.591  -3.794  1.00  1.00          
ATOM    482 HG13 VAL    30     -15.614   0.505  -4.794  1.00  1.00          
ATOM    483  CG2 VAL    30     -18.069  -0.038  -3.897  1.00  1.00          
ATOM    484 HG21 VAL    30     -18.619  -0.929  -4.165  1.00  1.00          
ATOM    485 HG22 VAL    30     -17.860   0.536  -4.785  1.00  1.00          
ATOM    486 HG23 VAL    30     -18.665   0.560  -3.215  1.00  1.00          
ATOM    487  C   VAL    30     -17.415  -1.633  -1.014  1.00  1.00          
ATOM    488  O   VAL    30     -16.859  -0.932  -0.153  1.00  1.00          
ATOM    489  N   LYS    31     -18.636  -2.226  -0.863  1.00  1.00          
ATOM    490  HN  LYS    31     -19.028  -2.656  -1.650  1.00  1.00          
ATOM    491  CA  LYS    31     -19.444  -2.219   0.392  1.00  1.00          
ATOM    492  HA  LYS    31     -19.268  -1.274   0.885  1.00  1.00          
ATOM    493  CB  LYS    31     -20.940  -2.313   0.040  1.00  1.00          
ATOM    494  HB1 LYS    31     -21.470  -2.734   0.881  1.00  1.00          
ATOM    495  HB2 LYS    31     -21.052  -2.971  -0.812  1.00  1.00          
ATOM    496  CG  LYS    31     -21.584  -0.977  -0.315  1.00  1.00          
ATOM    497  HG1 LYS    31     -21.051  -0.540  -1.148  1.00  1.00          
ATOM    498  HG2 LYS    31     -21.524  -0.319   0.538  1.00  1.00          
ATOM    499  CD  LYS    31     -23.045  -1.151  -0.700  1.00  1.00          
ATOM    500  HD1 LYS    31     -23.576  -1.590   0.132  1.00  1.00          
ATOM    501  HD2 LYS    31     -23.107  -1.807  -1.556  1.00  1.00          
ATOM    502  CE  LYS    31     -23.687   0.179  -1.051  1.00  1.00          
ATOM    503  HE1 LYS    31     -23.146   0.619  -1.876  1.00  1.00          
ATOM    504  HE2 LYS    31     -23.625   0.831  -0.192  1.00  1.00          
ATOM    505  NZ  LYS    31     -25.115   0.020  -1.436  1.00  1.00          
ATOM    506  HZ1 LYS    31     -25.704   0.696  -0.909  1.00  1.00          
ATOM    507  HZ2 LYS    31     -25.437  -0.944  -1.220  1.00  1.00          
ATOM    508  HZ3 LYS    31     -25.232   0.194  -2.454  1.00  1.00          
ATOM    509  C   LYS    31     -19.066  -3.363   1.384  1.00  1.00          
ATOM    510  O   LYS    31     -19.371  -3.241   2.589  1.00  1.00          
ATOM    511  N   ASP    32     -18.396  -4.444   0.865  1.00  1.00          
ATOM    512  HN  ASP    32     -18.170  -4.432  -0.083  1.00  1.00          
ATOM    513  CA  ASP    32     -17.971  -5.618   1.658  1.00  1.00          
ATOM    514  HA  ASP    32     -18.111  -5.363   2.699  1.00  1.00          
ATOM    515  CB  ASP    32     -18.850  -6.851   1.334  1.00  1.00          
ATOM    516  HB1 ASP    32     -18.332  -7.743   1.651  1.00  1.00          
ATOM    517  HB2 ASP    32     -19.015  -6.897   0.269  1.00  1.00          
ATOM    518  CG  ASP    32     -20.200  -6.811   2.024  1.00  1.00          
ATOM    519  OD1 ASP    32     -20.245  -7.024   3.253  1.00  1.00          
ATOM    520  OD2 ASP    32     -21.210  -6.566   1.333  1.00  1.00          
ATOM    521  C   ASP    32     -16.477  -5.937   1.447  1.00  1.00          
ATOM    522  O   ASP    32     -16.038  -6.313   0.338  1.00  1.00          
ATOM    523  N   ARG    33     -15.696  -5.696   2.541  1.00  1.00          
ATOM    524  HN  ARG    33     -16.114  -5.203   3.272  1.00  1.00          
ATOM    525  CA  ARG    33     -14.203  -5.966   2.657  1.00  1.00          
ATOM    526  HA  ARG    33     -13.747  -5.429   1.839  1.00  1.00          
ATOM    527  CB  ARG    33     -13.602  -5.390   3.997  1.00  1.00          
ATOM    528  HB1 ARG    33     -13.539  -4.316   3.898  1.00  1.00          
ATOM    529  HB2 ARG    33     -12.598  -5.775   4.096  1.00  1.00          
ATOM    530  CG  ARG    33     -14.364  -5.685   5.329  1.00  1.00          
ATOM    531  HG1 ARG    33     -13.681  -6.081   6.070  1.00  1.00          
ATOM    532  HG2 ARG    33     -15.143  -6.407   5.134  1.00  1.00          
ATOM    533  CD  ARG    33     -14.998  -4.414   5.870  1.00  1.00          
ATOM    534  HD1 ARG    33     -15.615  -3.981   5.098  1.00  1.00          
ATOM    535  HD2 ARG    33     -14.211  -3.721   6.131  1.00  1.00          
ATOM    536  NE  ARG    33     -15.833  -4.661   7.070  1.00  1.00          
ATOM    537  HE  ARG    33     -15.828  -5.580   7.413  1.00  1.00          
ATOM    538  CZ  ARG    33     -16.606  -3.750   7.740  1.00  1.00          
ATOM    539  NH1 ARG    33     -16.704  -2.449   7.390  1.00  1.00          
ATOM    540 HH11 ARG    33     -16.194  -2.102   6.603  1.00  1.00          
ATOM    541 HH12 ARG    33     -17.284  -1.831   7.920  1.00  1.00          
ATOM    542  NH2 ARG    33     -17.294  -4.164   8.792  1.00  1.00          
ATOM    543 HH21 ARG    33     -17.242  -5.121   9.077  1.00  1.00          
ATOM    544 HH22 ARG    33     -17.866  -3.520   9.300  1.00  1.00          
ATOM    545  C   ARG    33     -13.775  -7.453   2.472  1.00  1.00          
ATOM    546  O   ARG    33     -12.675  -7.709   1.954  1.00  1.00          
ATOM    547  N   GLU    34     -14.667  -8.401   2.897  1.00  1.00          
ATOM    548  HN  GLU    34     -15.495  -8.092   3.316  1.00  1.00          
ATOM    549  CA  GLU    34     -14.475  -9.886   2.784  1.00  1.00          
ATOM    550  HA  GLU    34     -13.504 -10.117   3.193  1.00  1.00          
ATOM    551  CB  GLU    34     -15.540 -10.592   3.625  1.00  1.00          
ATOM    552  HB1 GLU    34     -16.262 -11.039   2.963  1.00  1.00          
ATOM    553  HB2 GLU    34     -16.036  -9.854   4.236  1.00  1.00          
ATOM    554  CG  GLU    34     -14.990 -11.675   4.546  1.00  1.00          
ATOM    555  HG1 GLU    34     -14.239 -11.239   5.188  1.00  1.00          
ATOM    556  HG2 GLU    34     -14.541 -12.449   3.942  1.00  1.00          
ATOM    557  CD  GLU    34     -16.066 -12.303   5.413  1.00  1.00          
ATOM    558  OE1 GLU    34     -16.255 -11.841   6.559  1.00  1.00          
ATOM    559  OE2 GLU    34     -16.719 -13.259   4.945  1.00  1.00          
ATOM    560  C   GLU    34     -14.514 -10.404   1.313  1.00  1.00          
ATOM    561  O   GLU    34     -13.832 -11.393   0.994  1.00  1.00          
ATOM    562  N   ARG    35     -15.331  -9.710   0.452  1.00  1.00          
ATOM    563  HN  ARG    35     -15.848  -8.961   0.818  1.00  1.00          
ATOM    564  CA  ARG    35     -15.478  -9.994  -1.009  1.00  1.00          
ATOM    565  HA  ARG    35     -15.418 -11.066  -1.131  1.00  1.00          
ATOM    566  CB  ARG    35     -16.844  -9.520  -1.541  1.00  1.00          
ATOM    567  HB1 ARG    35     -16.792  -9.468  -2.618  1.00  1.00          
ATOM    568  HB2 ARG    35     -17.038  -8.531  -1.156  1.00  1.00          
ATOM    569  CG  ARG    35     -18.031 -10.418  -1.163  1.00  1.00          
ATOM    570  HG1 ARG    35     -18.078 -10.489  -0.085  1.00  1.00          
ATOM    571  HG2 ARG    35     -17.868 -11.400  -1.579  1.00  1.00          
ATOM    572  CD  ARG    35     -19.369  -9.878  -1.689  1.00  1.00          
ATOM    573  HD1 ARG    35     -19.407  -8.815  -1.500  1.00  1.00          
ATOM    574  HD2 ARG    35     -20.176 -10.363  -1.158  1.00  1.00          
ATOM    575  NE  ARG    35     -19.561 -10.110  -3.154  1.00  1.00          
ATOM    576  HE  ARG    35     -18.986 -10.795  -3.555  1.00  1.00          
ATOM    577  CZ  ARG    35     -20.439  -9.469  -3.988  1.00  1.00          
ATOM    578  NH1 ARG    35     -21.296  -8.515  -3.576  1.00  1.00          
ATOM    579 HH11 ARG    35     -21.313  -8.240  -2.614  1.00  1.00          
ATOM    580 HH12 ARG    35     -21.916  -8.082  -4.230  1.00  1.00          
ATOM    581  NH2 ARG    35     -20.453  -9.807  -5.271  1.00  1.00          
ATOM    582 HH21 ARG    35     -19.831 -10.513  -5.608  1.00  1.00          
ATOM    583 HH22 ARG    35     -21.085  -9.354  -5.900  1.00  1.00          
ATOM    584  C   ARG    35     -14.353  -9.351  -1.865  1.00  1.00          
ATOM    585  O   ARG    35     -13.937  -9.953  -2.870  1.00  1.00          
ATOM    586  N   PHE    36     -13.872  -8.120  -1.439  1.00  1.00          
ATOM    587  HN  PHE    36     -14.272  -7.734  -0.632  1.00  1.00          
ATOM    588  CA  PHE    36     -12.788  -7.335  -2.119  1.00  1.00          
ATOM    589  HA  PHE    36     -13.032  -7.321  -3.175  1.00  1.00          
ATOM    590  CB  PHE    36     -12.768  -5.860  -1.604  1.00  1.00          
ATOM    591  HB1 PHE    36     -12.121  -5.808  -0.739  1.00  1.00          
ATOM    592  HB2 PHE    36     -13.766  -5.584  -1.306  1.00  1.00          
ATOM    593  CG  PHE    36     -12.276  -4.810  -2.611  1.00  1.00          
ATOM    594  CD1 PHE    36     -13.182  -4.017  -3.308  1.00  1.00          
ATOM    595  HD1 PHE    36     -14.239  -4.142  -3.138  1.00  1.00          
ATOM    596  CD2 PHE    36     -10.912  -4.619  -2.851  1.00  1.00          
ATOM    597  HD2 PHE    36     -10.191  -5.227  -2.322  1.00  1.00          
ATOM    598  CE1 PHE    36     -12.745  -3.066  -4.213  1.00  1.00          
ATOM    599  HE1 PHE    36     -13.462  -2.457  -4.749  1.00  1.00          
ATOM    600  CE2 PHE    36     -10.477  -3.670  -3.756  1.00  1.00          
ATOM    601  HE2 PHE    36      -9.420  -3.537  -3.933  1.00  1.00          
ATOM    602  CZ  PHE    36     -11.394  -2.894  -4.437  1.00  1.00          
ATOM    603  HZ  PHE    36     -11.055  -2.152  -5.144  1.00  1.00          
ATOM    604  C   PHE    36     -11.381  -7.994  -1.962  1.00  1.00          
ATOM    605  O   PHE    36     -10.656  -8.096  -2.957  1.00  1.00          
ATOM    606  N   LEU    37     -11.045  -8.465  -0.705  1.00  1.00          
ATOM    607  HN  LEU    37     -11.712  -8.391   0.008  1.00  1.00          
ATOM    608  CA  LEU    37      -9.748  -9.152  -0.357  1.00  1.00          
ATOM    609  HA  LEU    37      -8.952  -8.547  -0.765  1.00  1.00          
ATOM    610  CB  LEU    37      -9.569  -9.231   1.169  1.00  1.00          
ATOM    611  HB1 LEU    37      -8.934 -10.076   1.387  1.00  1.00          
ATOM    612  HB2 LEU    37     -10.538  -9.411   1.609  1.00  1.00          
ATOM    613  CG  LEU    37      -8.960  -7.990   1.838  1.00  1.00          
ATOM    614  HG  LEU    37      -9.017  -7.151   1.159  1.00  1.00          
ATOM    615  CD1 LEU    37      -9.735  -7.625   3.094  1.00  1.00          
ATOM    616 HD11 LEU    37      -9.264  -6.779   3.570  1.00  1.00          
ATOM    617 HD12 LEU    37      -9.736  -8.465   3.774  1.00  1.00          
ATOM    618 HD13 LEU    37     -10.751  -7.371   2.833  1.00  1.00          
ATOM    619  CD2 LEU    37      -7.493  -8.232   2.176  1.00  1.00          
ATOM    620 HD21 LEU    37      -7.421  -8.983   2.948  1.00  1.00          
ATOM    621 HD22 LEU    37      -7.048  -7.312   2.526  1.00  1.00          
ATOM    622 HD23 LEU    37      -6.971  -8.571   1.294  1.00  1.00          
ATOM    623  C   LEU    37      -9.625 -10.575  -0.974  1.00  1.00          
ATOM    624  O   LEU    37      -8.521 -10.988  -1.362  1.00  1.00          
ATOM    625  N   ALA    38     -10.798 -11.295  -1.035  1.00  1.00          
ATOM    626  HN  ALA    38     -11.594 -10.860  -0.661  1.00  1.00          
ATOM    627  CA  ALA    38     -10.947 -12.662  -1.630  1.00  1.00          
ATOM    628  HA  ALA    38     -10.133 -13.267  -1.257  1.00  1.00          
ATOM    629  CB  ALA    38     -12.249 -13.289  -1.162  1.00  1.00          
ATOM    630  HB1 ALA    38     -13.082 -12.721  -1.550  1.00  1.00          
ATOM    631  HB2 ALA    38     -12.280 -13.285  -0.084  1.00  1.00          
ATOM    632  HB3 ALA    38     -12.308 -14.305  -1.522  1.00  1.00          
ATOM    633  C   ALA    38     -10.885 -12.664  -3.184  1.00  1.00          
ATOM    634  O   ALA    38     -10.445 -13.661  -3.780  1.00  1.00          
ATOM    635  N   GLN    39     -11.334 -11.518  -3.802  1.00  1.00          
ATOM    636  HN  GLN    39     -11.679 -10.803  -3.227  1.00  1.00          
ATOM    637  CA  GLN    39     -11.334 -11.274  -5.273  1.00  1.00          
ATOM    638  HA  GLN    39     -11.622 -12.199  -5.749  1.00  1.00          
ATOM    639  CB  GLN    39     -12.363 -10.202  -5.635  1.00  1.00          
ATOM    640  HB1 GLN    39     -11.849  -9.350  -6.053  1.00  1.00          
ATOM    641  HB2 GLN    39     -12.880  -9.896  -4.736  1.00  1.00          
ATOM    642  CG  GLN    39     -13.400 -10.677  -6.644  1.00  1.00          
ATOM    643  HG1 GLN    39     -13.877 -11.568  -6.261  1.00  1.00          
ATOM    644  HG2 GLN    39     -12.897 -10.910  -7.571  1.00  1.00          
ATOM    645  CD  GLN    39     -14.469  -9.637  -6.925  1.00  1.00          
ATOM    646  OE1 GLN    39     -15.366  -9.414  -6.110  1.00  1.00          
ATOM    647  NE2 GLN    39     -14.376  -8.993  -8.084  1.00  1.00          
ATOM    648 HE21 GLN    39     -13.634  -9.222  -8.682  1.00  1.00          
ATOM    649 HE22 GLN    39     -15.051  -8.313  -8.293  1.00  1.00          
ATOM    650  C   GLN    39      -9.942 -10.870  -5.820  1.00  1.00          
ATOM    651  O   GLN    39      -9.610 -11.243  -6.947  1.00  1.00          
ATOM    652  N   VAL    40      -9.143 -10.104  -4.991  1.00  1.00          
ATOM    653  HN  VAL    40      -9.520  -9.838  -4.126  1.00  1.00          
ATOM    654  CA  VAL    40      -7.728  -9.640  -5.307  1.00  1.00          
ATOM    655  HA  VAL    40      -7.751  -9.261  -6.322  1.00  1.00          
ATOM    656  CB  VAL    40      -7.265  -8.421  -4.339  1.00  1.00          
ATOM    657  HB  VAL    40      -7.399  -8.743  -3.318  1.00  1.00          
ATOM    658  CG1 VAL    40      -5.795  -7.949  -4.503  1.00  1.00          
ATOM    659 HG11 VAL    40      -5.139  -8.808  -4.525  1.00  1.00          
ATOM    660 HG12 VAL    40      -5.525  -7.310  -3.674  1.00  1.00          
ATOM    661 HG13 VAL    40      -5.699  -7.397  -5.425  1.00  1.00          
ATOM    662  CG2 VAL    40      -8.144  -7.179  -4.545  1.00  1.00          
ATOM    663 HG21 VAL    40      -7.837  -6.403  -3.859  1.00  1.00          
ATOM    664 HG22 VAL    40      -9.177  -7.436  -4.359  1.00  1.00          
ATOM    665 HG23 VAL    40      -8.038  -6.826  -5.560  1.00  1.00          
ATOM    666  C   VAL    40      -6.740 -10.881  -5.289  1.00  1.00          
ATOM    667  O   VAL    40      -5.847 -10.964  -6.145  1.00  1.00          
ATOM    668  N   GLU    41      -6.948 -11.810  -4.291  1.00  1.00          
ATOM    669  HN  GLU    41      -7.679 -11.648  -3.658  1.00  1.00          
ATOM    670  CA  GLU    41      -6.156 -13.082  -4.095  1.00  1.00          
ATOM    671  HA  GLU    41      -5.108 -12.825  -4.137  1.00  1.00          
ATOM    672  CB  GLU    41      -6.452 -13.705  -2.709  1.00  1.00          
ATOM    673  HB1 GLU    41      -6.060 -14.711  -2.697  1.00  1.00          
ATOM    674  HB2 GLU    41      -7.523 -13.753  -2.579  1.00  1.00          
ATOM    675  CG  GLU    41      -5.870 -12.953  -1.514  1.00  1.00          
ATOM    676  HG1 GLU    41      -6.341 -11.983  -1.456  1.00  1.00          
ATOM    677  HG2 GLU    41      -4.807 -12.831  -1.658  1.00  1.00          
ATOM    678  CD  GLU    41      -6.102 -13.679  -0.203  1.00  1.00          
ATOM    679  OE1 GLU    41      -5.208 -14.441   0.221  1.00  1.00          
ATOM    680  OE2 GLU    41      -7.181 -13.490   0.398  1.00  1.00          
ATOM    681  C   GLU    41      -6.445 -14.160  -5.187  1.00  1.00          
ATOM    682  O   GLU    41      -5.529 -14.908  -5.569  1.00  1.00          
ATOM    683  N   GLU    42      -7.733 -14.199  -5.664  1.00  1.00          
ATOM    684  HN  GLU    42      -8.370 -13.556  -5.289  1.00  1.00          
ATOM    685  CA  GLU    42      -8.241 -15.144  -6.708  1.00  1.00          
ATOM    686  HA  GLU    42      -7.747 -16.091  -6.555  1.00  1.00          
ATOM    687  CB  GLU    42      -9.754 -15.348  -6.525  1.00  1.00          
ATOM    688  HB1 GLU    42     -10.174 -15.660  -7.470  1.00  1.00          
ATOM    689  HB2 GLU    42     -10.193 -14.399  -6.246  1.00  1.00          
ATOM    690  CG  GLU    42     -10.128 -16.400  -5.465  1.00  1.00          
ATOM    691  HG1 GLU    42     -11.041 -16.098  -4.963  1.00  1.00          
ATOM    692  HG2 GLU    42      -9.329 -16.457  -4.741  1.00  1.00          
ATOM    693  CD  GLU    42     -10.343 -17.788  -6.050  1.00  1.00          
ATOM    694  OE1 GLU    42     -11.404 -18.017  -6.671  1.00  1.00          
ATOM    695  OE2 GLU    42      -9.448 -18.645  -5.886  1.00  1.00          
ATOM    696  C   GLU    42      -7.966 -14.678  -8.166  1.00  1.00          
ATOM    697  O   GLU    42      -7.851 -15.532  -9.064  1.00  1.00          
ATOM    698  N   PHE    43      -7.863 -13.330  -8.362  1.00  1.00          
ATOM    699  HN  PHE    43      -7.937 -12.758  -7.569  1.00  1.00          
ATOM    700  CA  PHE    43      -7.604 -12.686  -9.673  1.00  1.00          
ATOM    701  HA  PHE    43      -7.862 -13.398 -10.445  1.00  1.00          
ATOM    702  CB  PHE    43      -8.487 -11.424  -9.835  1.00  1.00          
ATOM    703  HB1 PHE    43      -7.853 -10.550  -9.784  1.00  1.00          
ATOM    704  HB2 PHE    43      -9.194 -11.389  -9.022  1.00  1.00          
ATOM    705  CG  PHE    43      -9.276 -11.347 -11.127  1.00  1.00          
ATOM    706  CD1 PHE    43     -10.564 -11.868 -11.206  1.00  1.00          
ATOM    707  HD1 PHE    43     -10.997 -12.342 -10.337  1.00  1.00          
ATOM    708  CD2 PHE    43      -8.737 -10.740 -12.258  1.00  1.00          
ATOM    709  HD2 PHE    43      -7.740 -10.329 -12.214  1.00  1.00          
ATOM    710  CE1 PHE    43     -11.290 -11.788 -12.379  1.00  1.00          
ATOM    711  HE1 PHE    43     -12.288 -12.196 -12.425  1.00  1.00          
ATOM    712  CE2 PHE    43      -9.462 -10.660 -13.432  1.00  1.00          
ATOM    713  HE2 PHE    43      -9.031 -10.188 -14.303  1.00  1.00          
ATOM    714  CZ  PHE    43     -10.739 -11.184 -13.492  1.00  1.00          
ATOM    715  HZ  PHE    43     -11.306 -11.121 -14.409  1.00  1.00          
ATOM    716  C   PHE    43      -6.116 -12.316  -9.823  1.00  1.00          
ATOM    717  O   PHE    43      -5.436 -12.046  -8.809  1.00  1.00          
ATOM    718  N   VAL    44      -5.646 -12.290 -11.099  1.00  1.00          
ATOM    719  HN  VAL    44      -6.276 -12.457 -11.830  1.00  1.00          
ATOM    720  CA  VAL    44      -4.253 -11.972 -11.451  1.00  1.00          
ATOM    721  HA  VAL    44      -3.713 -11.937 -10.512  1.00  1.00          
ATOM    722  CB  VAL    44      -3.627 -13.177 -12.308  1.00  1.00          
ATOM    723  HB  VAL    44      -4.051 -14.083 -11.887  1.00  1.00          
ATOM    724  CG1 VAL    44      -3.969 -13.214 -13.814  1.00  1.00          
ATOM    725 HG11 VAL    44      -5.012 -12.979 -13.954  1.00  1.00          
ATOM    726 HG12 VAL    44      -3.761 -14.197 -14.212  1.00  1.00          
ATOM    727 HG13 VAL    44      -3.357 -12.481 -14.331  1.00  1.00          
ATOM    728  CG2 VAL    44      -2.115 -13.281 -12.114  1.00  1.00          
ATOM    729 HG21 VAL    44      -1.894 -13.608 -11.106  1.00  1.00          
ATOM    730 HG22 VAL    44      -1.667 -12.313 -12.281  1.00  1.00          
ATOM    731 HG23 VAL    44      -1.711 -13.991 -12.820  1.00  1.00          
ATOM    732  C   VAL    44      -4.173 -10.529 -12.072  1.00  1.00          
ATOM    733  O   VAL    44      -5.123 -10.090 -12.753  1.00  1.00          
ATOM    734  N   PHE    45      -3.024  -9.853 -11.825  1.00  1.00          
ATOM    735  HN  PHE    45      -2.310 -10.311 -11.336  1.00  1.00          
ATOM    736  CA  PHE    45      -2.760  -8.460 -12.291  1.00  1.00          
ATOM    737  HA  PHE    45      -3.609  -8.149 -12.882  1.00  1.00          
ATOM    738  CB  PHE    45      -2.596  -7.484 -11.088  1.00  1.00          
ATOM    739  HB1 PHE    45      -2.402  -6.494 -11.480  1.00  1.00          
ATOM    740  HB2 PHE    45      -1.745  -7.793 -10.507  1.00  1.00          
ATOM    741  CG  PHE    45      -3.782  -7.372 -10.139  1.00  1.00          
ATOM    742  CD1 PHE    45      -3.855  -8.180  -9.013  1.00  1.00          
ATOM    743  HD1 PHE    45      -3.068  -8.895  -8.822  1.00  1.00          
ATOM    744  CD2 PHE    45      -4.802  -6.457 -10.368  1.00  1.00          
ATOM    745  HD2 PHE    45      -4.759  -5.823 -11.241  1.00  1.00          
ATOM    746  CE1 PHE    45      -4.918  -8.079  -8.137  1.00  1.00          
ATOM    747  HE1 PHE    45      -4.959  -8.717  -7.266  1.00  1.00          
ATOM    748  CE2 PHE    45      -5.869  -6.355  -9.495  1.00  1.00          
ATOM    749  HE2 PHE    45      -6.657  -5.640  -9.685  1.00  1.00          
ATOM    750  CZ  PHE    45      -5.927  -7.166  -8.377  1.00  1.00          
ATOM    751  HZ  PHE    45      -6.758  -7.085  -7.691  1.00  1.00          
ATOM    752  C   PHE    45      -1.496  -8.411 -13.176  1.00  1.00          
ATOM    753  O   PHE    45      -0.585  -9.239 -13.001  1.00  1.00          
ATOM    754  N   LYS    46      -1.461  -7.419 -14.111  1.00  1.00          
ATOM    755  HN  LYS    46      -2.215  -6.796 -14.144  1.00  1.00          
ATOM    756  CA  LYS    46      -0.337  -7.215 -15.069  1.00  1.00          
ATOM    757  HA  LYS    46       0.244  -8.125 -15.090  1.00  1.00          
ATOM    758  CB  LYS    46      -0.874  -6.933 -16.487  1.00  1.00          
ATOM    759  HB1 LYS    46      -0.082  -6.487 -17.073  1.00  1.00          
ATOM    760  HB2 LYS    46      -1.688  -6.229 -16.413  1.00  1.00          
ATOM    761  CG  LYS    46      -1.381  -8.167 -17.233  1.00  1.00          
ATOM    762  HG1 LYS    46      -2.151  -8.641 -16.640  1.00  1.00          
ATOM    763  HG2 LYS    46      -0.560  -8.855 -17.375  1.00  1.00          
ATOM    764  CD  LYS    46      -1.959  -7.804 -18.591  1.00  1.00          
ATOM    765  HD1 LYS    46      -1.178  -7.371 -19.200  1.00  1.00          
ATOM    766  HD2 LYS    46      -2.751  -7.084 -18.453  1.00  1.00          
ATOM    767  CE  LYS    46      -2.519  -9.025 -19.303  1.00  1.00          
ATOM    768  HE1 LYS    46      -3.269  -9.481 -18.671  1.00  1.00          
ATOM    769  HE2 LYS    46      -1.717  -9.728 -19.471  1.00  1.00          
ATOM    770  NZ  LYS    46      -3.136  -8.676 -20.612  1.00  1.00          
ATOM    771  HZ1 LYS    46      -2.398  -8.563 -21.336  1.00  1.00          
ATOM    772  HZ2 LYS    46      -3.666  -7.785 -20.532  1.00  1.00          
ATOM    773  HZ3 LYS    46      -3.789  -9.428 -20.912  1.00  1.00          
ATOM    774  C   LYS    46       0.572  -6.065 -14.623  1.00  1.00          
ATOM    775  O   LYS    46       0.070  -5.042 -14.119  1.00  1.00          
ATOM    776  N   CYS    47       1.910  -6.257 -14.833  1.00  1.00          
ATOM    777  HN  CYS    47       2.196  -7.098 -15.249  1.00  1.00          
ATOM    778  CA  CYS    47       2.953  -5.266 -14.472  1.00  1.00          
ATOM    779  HA  CYS    47       2.533  -4.623 -13.712  1.00  1.00          
ATOM    780  HB1 CYS    47       4.711  -6.497 -14.684  1.00  1.00          
ATOM    781  HB2 CYS    47       3.904  -6.672 -13.134  1.00  1.00          
ATOM    782  C   CYS    47       3.345  -4.372 -15.704  1.00  1.00          
ATOM    783  O   CYS    47       3.766  -4.951 -16.732  1.00  1.00          
ATOM    784  CB  CYS    47       4.208  -5.966 -13.888  1.00  1.00          
ATOM    785  SG  CYS    47       5.427  -4.827 -13.126  1.00  1.00          
ATOM    786  N   PRO    48       3.164  -2.947 -15.672  1.00  1.00          
ATOM    787  CA  PRO    48       3.583  -2.056 -16.816  1.00  1.00          
ATOM    788  HA  PRO    48       3.246  -2.481 -17.754  1.00  1.00          
ATOM    789  CB  PRO    48       2.813  -0.732 -16.554  1.00  1.00          
ATOM    790  HB1 PRO    48       1.880  -0.736 -17.109  1.00  1.00          
ATOM    791  HB2 PRO    48       3.419   0.101 -16.888  1.00  1.00          
ATOM    792  CG  PRO    48       2.565  -0.676 -15.066  1.00  1.00          
ATOM    793  HG1 PRO    48       1.637  -0.148 -14.863  1.00  1.00          
ATOM    794  HG2 PRO    48       3.389  -0.167 -14.575  1.00  1.00          
ATOM    795  CD  PRO    48       2.475  -2.119 -14.597  1.00  1.00          
ATOM    796  HD1 PRO    48       1.438  -2.422 -14.504  1.00  1.00          
ATOM    797  HD2 PRO    48       2.978  -2.245 -13.647  1.00  1.00          
ATOM    798  C   PRO    48       5.134  -1.808 -16.941  1.00  1.00          
ATOM    799  O   PRO    48       5.580  -1.215 -17.942  1.00  1.00          
ATOM    800  N   VAL    49       5.914  -2.285 -15.914  1.00  1.00          
ATOM    801  HN  VAL    49       5.466  -2.773 -15.190  1.00  1.00          
ATOM    802  CA  VAL    49       7.410  -2.126 -15.828  1.00  1.00          
ATOM    803  HA  VAL    49       7.655  -1.220 -16.367  1.00  1.00          
ATOM    804  CB  VAL    49       7.997  -1.978 -14.329  1.00  1.00          
ATOM    805  HB  VAL    49       8.270  -2.973 -13.995  1.00  1.00          
ATOM    806  CG1 VAL    49       9.286  -1.133 -14.304  1.00  1.00          
ATOM    807 HG11 VAL    49       9.728  -1.179 -13.319  1.00  1.00          
ATOM    808 HG12 VAL    49       9.051  -0.107 -14.545  1.00  1.00          
ATOM    809 HG13 VAL    49       9.985  -1.521 -15.031  1.00  1.00          
ATOM    810  CG2 VAL    49       7.014  -1.365 -13.292  1.00  1.00          
ATOM    811 HG21 VAL    49       7.520  -0.592 -12.735  1.00  1.00          
ATOM    812 HG22 VAL    49       6.661  -2.128 -12.608  1.00  1.00          
ATOM    813 HG23 VAL    49       6.169  -0.937 -13.811  1.00  1.00          
ATOM    814  C   VAL    49       8.125  -3.313 -16.556  1.00  1.00          
ATOM    815  O   VAL    49       8.993  -3.056 -17.414  1.00  1.00          
ATOM    816  N   CYS    50       7.739  -4.573 -16.193  1.00  1.00          
ATOM    817  HN  CYS    50       7.043  -4.666 -15.510  1.00  1.00          
ATOM    818  CA  CYS    50       8.316  -5.799 -16.777  1.00  1.00          
ATOM    819  HA  CYS    50       9.232  -5.497 -17.267  1.00  1.00          
ATOM    820  HB1 CYS    50       9.375  -6.333 -15.000  1.00  1.00          
ATOM    821  HB2 CYS    50       9.172  -7.660 -16.127  1.00  1.00          
ATOM    822  C   CYS    50       7.403  -6.411 -17.860  1.00  1.00          
ATOM    823  O   CYS    50       7.904  -6.697 -18.965  1.00  1.00          
ATOM    824  CB  CYS    50       8.686  -6.811 -15.671  1.00  1.00          
ATOM    825  SG  CYS    50       7.291  -7.452 -14.676  1.00  1.00          
ATOM    826  N   GLY    51       6.086  -6.606 -17.531  1.00  1.00          
ATOM    827  HN  GLY    51       5.807  -6.447 -16.602  1.00  1.00          
ATOM    828  CA  GLY    51       5.095  -7.163 -18.482  1.00  1.00          
ATOM    829  HA1 GLY    51       5.587  -7.312 -19.433  1.00  1.00          
ATOM    830  HA2 GLY    51       4.309  -6.438 -18.617  1.00  1.00          
ATOM    831  C   GLY    51       4.452  -8.493 -18.053  1.00  1.00          
ATOM    832  O   GLY    51       3.428  -8.877 -18.644  1.00  1.00          
ATOM    833  N   GLU    52       5.054  -9.183 -17.026  1.00  1.00          
ATOM    834  HN  GLU    52       5.868  -8.795 -16.642  1.00  1.00          
ATOM    835  CA  GLU    52       4.571 -10.482 -16.473  1.00  1.00          
ATOM    836  HA  GLU    52       4.185 -11.058 -17.302  1.00  1.00          
ATOM    837  CB  GLU    52       5.752 -11.251 -15.856  1.00  1.00          
ATOM    838  HB1 GLU    52       5.394 -11.825 -15.014  1.00  1.00          
ATOM    839  HB2 GLU    52       6.489 -10.542 -15.511  1.00  1.00          
ATOM    840  CG  GLU    52       6.425 -12.204 -16.834  1.00  1.00          
ATOM    841  HG1 GLU    52       6.781 -11.636 -17.680  1.00  1.00          
ATOM    842  HG2 GLU    52       5.697 -12.928 -17.168  1.00  1.00          
ATOM    843  CD  GLU    52       7.596 -12.946 -16.222  1.00  1.00          
ATOM    844  OE1 GLU    52       8.722 -12.408 -16.254  1.00  1.00          
ATOM    845  OE2 GLU    52       7.387 -14.067 -15.710  1.00  1.00          
ATOM    846  C   GLU    52       3.428 -10.301 -15.440  1.00  1.00          
ATOM    847  O   GLU    52       3.339  -9.245 -14.787  1.00  1.00          
ATOM    848  N   GLU    53       2.574 -11.365 -15.317  1.00  1.00          
ATOM    849  HN  GLU    53       2.767 -12.169 -15.843  1.00  1.00          
ATOM    850  CA  GLU    53       1.381 -11.411 -14.420  1.00  1.00          
ATOM    851  HA  GLU    53       0.974 -10.414 -14.346  1.00  1.00          
ATOM    852  CB  GLU    53       0.304 -12.324 -15.040  1.00  1.00          
ATOM    853  HB1 GLU    53      -0.391 -12.615 -14.270  1.00  1.00          
ATOM    854  HB2 GLU    53       0.784 -13.211 -15.429  1.00  1.00          
ATOM    855  CG  GLU    53      -0.490 -11.674 -16.179  1.00  1.00          
ATOM    856  HG1 GLU    53       0.205 -11.287 -16.910  1.00  1.00          
ATOM    857  HG2 GLU    53      -1.072 -10.861 -15.773  1.00  1.00          
ATOM    858  CD  GLU    53      -1.434 -12.638 -16.870  1.00  1.00          
ATOM    859  OE1 GLU    53      -0.962 -13.427 -17.715  1.00  1.00          
ATOM    860  OE2 GLU    53      -2.647 -12.589 -16.586  1.00  1.00          
ATOM    861  C   GLU    53       1.742 -11.898 -13.004  1.00  1.00          
ATOM    862  O   GLU    53       2.536 -12.846 -12.861  1.00  1.00          
ATOM    863  N   PHE    54       1.139 -11.222 -11.991  1.00  1.00          
ATOM    864  HN  PHE    54       0.487 -10.527 -12.219  1.00  1.00          
ATOM    865  CA  PHE    54       1.337 -11.502 -10.546  1.00  1.00          
ATOM    866  HA  PHE    54       1.840 -12.458 -10.483  1.00  1.00          
ATOM    867  CB  PHE    54       2.251 -10.415  -9.864  1.00  1.00          
ATOM    868  HB1 PHE    54       3.228 -10.459 -10.326  1.00  1.00          
ATOM    869  HB2 PHE    54       2.361 -10.669  -8.822  1.00  1.00          
ATOM    870  CG  PHE    54       1.785  -8.954  -9.918  1.00  1.00          
ATOM    871  CD1 PHE    54       0.995  -8.436  -8.904  1.00  1.00          
ATOM    872  HD1 PHE    54       0.722  -9.067  -8.071  1.00  1.00          
ATOM    873  CD2 PHE    54       2.129  -8.132 -10.980  1.00  1.00          
ATOM    874  HD2 PHE    54       2.747  -8.523 -11.775  1.00  1.00          
ATOM    875  CE1 PHE    54       0.556  -7.126  -8.947  1.00  1.00          
ATOM    876  HE1 PHE    54      -0.059  -6.735  -8.150  1.00  1.00          
ATOM    877  CE2 PHE    54       1.694  -6.820 -11.026  1.00  1.00          
ATOM    878  HE2 PHE    54       1.965  -6.188 -11.856  1.00  1.00          
ATOM    879  CZ  PHE    54       0.905  -6.318 -10.009  1.00  1.00          
ATOM    880  HZ  PHE    54       0.563  -5.295 -10.046  1.00  1.00          
ATOM    881  C   PHE    54      -0.034 -11.653  -9.849  1.00  1.00          
ATOM    882  O   PHE    54      -0.969 -10.889 -10.162  1.00  1.00          
ATOM    883  N   TYR    55      -0.119 -12.615  -8.898  1.00  1.00          
ATOM    884  HN  TYR    55       0.686 -13.125  -8.672  1.00  1.00          
ATOM    885  CA  TYR    55      -1.363 -12.935  -8.148  1.00  1.00          
ATOM    886  HA  TYR    55      -2.197 -12.602  -8.746  1.00  1.00          
ATOM    887  CB  TYR    55      -1.477 -14.469  -7.949  1.00  1.00          
ATOM    888  HB1 TYR    55      -2.236 -14.667  -7.207  1.00  1.00          
ATOM    889  HB2 TYR    55      -0.532 -14.841  -7.584  1.00  1.00          
ATOM    890  CG  TYR    55      -1.827 -15.271  -9.202  1.00  1.00          
ATOM    891  CD1 TYR    55      -0.826 -15.803 -10.011  1.00  1.00          
ATOM    892  HD1 TYR    55       0.206 -15.632  -9.747  1.00  1.00          
ATOM    893  CD2 TYR    55      -3.152 -15.506  -9.566  1.00  1.00          
ATOM    894  HD2 TYR    55      -3.945 -15.100  -8.957  1.00  1.00          
ATOM    895  CE1 TYR    55      -1.135 -16.542 -11.138  1.00  1.00          
ATOM    896  HE1 TYR    55      -0.342 -16.947 -11.751  1.00  1.00          
ATOM    897  CE2 TYR    55      -3.465 -16.242 -10.694  1.00  1.00          
ATOM    898  HE2 TYR    55      -4.498 -16.413 -10.957  1.00  1.00          
ATOM    899  CZ  TYR    55      -2.453 -16.758 -11.475  1.00  1.00          
ATOM    900  OH  TYR    55      -2.762 -17.493 -12.597  1.00  1.00          
ATOM    901  HH  TYR    55      -3.405 -18.168 -12.371  1.00  1.00          
ATOM    902  C   TYR    55      -1.424 -12.224  -6.782  1.00  1.00          
ATOM    903  O   TYR    55      -0.370 -11.935  -6.183  1.00  1.00          
ATOM    904  N   GLY    56      -2.689 -11.949  -6.310  1.00  1.00          
ATOM    905  HN  GLY    56      -3.450 -12.205  -6.872  1.00  1.00          
ATOM    906  CA  GLY    56      -2.969 -11.294  -4.993  1.00  1.00          
ATOM    907  HA1 GLY    56      -3.977 -10.905  -5.012  1.00  1.00          
ATOM    908  HA2 GLY    56      -2.288 -10.464  -4.875  1.00  1.00          
ATOM    909  C   GLY    56      -2.816 -12.227  -3.760  1.00  1.00          
ATOM    910  O   GLY    56      -2.881 -11.750  -2.615  1.00  1.00          
ATOM    911  N   LYS    57      -2.617 -13.552  -4.048  1.00  1.00          
ATOM    912  HN  LYS    57      -2.606 -13.783  -5.000  1.00  1.00          
ATOM    913  CA  LYS    57      -2.389 -14.631  -3.044  1.00  1.00          
ATOM    914  HA  LYS    57      -2.947 -14.368  -2.158  1.00  1.00          
ATOM    915  CB  LYS    57      -2.919 -15.974  -3.588  1.00  1.00          
ATOM    916  HB1 LYS    57      -2.089 -16.532  -3.999  1.00  1.00          
ATOM    917  HB2 LYS    57      -3.626 -15.772  -4.378  1.00  1.00          
ATOM    918  CG  LYS    57      -3.613 -16.853  -2.543  1.00  1.00          
ATOM    919  HG1 LYS    57      -4.380 -16.276  -2.050  1.00  1.00          
ATOM    920  HG2 LYS    57      -2.882 -17.174  -1.816  1.00  1.00          
ATOM    921  CD  LYS    57      -4.252 -18.086  -3.178  1.00  1.00          
ATOM    922  HD1 LYS    57      -3.482 -18.648  -3.689  1.00  1.00          
ATOM    923  HD2 LYS    57      -4.994 -17.762  -3.892  1.00  1.00          
ATOM    924  CE  LYS    57      -4.928 -18.985  -2.136  1.00  1.00          
ATOM    925  HE1 LYS    57      -4.326 -18.991  -1.240  1.00  1.00          
ATOM    926  HE2 LYS    57      -4.997 -19.992  -2.525  1.00  1.00          
ATOM    927  NZ  LYS    57      -6.303 -18.515  -1.790  1.00  1.00          
ATOM    928  HZ1 LYS    57      -6.733 -19.150  -1.086  1.00  1.00          
ATOM    929  HZ2 LYS    57      -6.901 -18.503  -2.640  1.00  1.00          
ATOM    930  HZ3 LYS    57      -6.264 -17.553  -1.395  1.00  1.00          
ATOM    931  C   LYS    57      -0.874 -14.755  -2.662  1.00  1.00          
ATOM    932  O   LYS    57      -0.554 -15.326  -1.604  1.00  1.00          
ATOM    933  N   THR    58       0.013 -14.210  -3.547  1.00  1.00          
ATOM    934  HN  THR    58      -0.349 -13.780  -4.350  1.00  1.00          
ATOM    935  CA  THR    58       1.493 -14.204  -3.378  1.00  1.00          
ATOM    936  HA  THR    58       1.736 -14.989  -2.675  1.00  1.00          
ATOM    937  CB  THR    58       2.235 -14.516  -4.729  1.00  1.00          
ATOM    938  HB  THR    58       3.276 -14.255  -4.602  1.00  1.00          
ATOM    939  OG1 THR    58       1.700 -13.726  -5.798  1.00  1.00          
ATOM    940  HG1 THR    58       0.791 -13.491  -5.598  1.00  1.00          
ATOM    941  CG2 THR    58       2.157 -15.999  -5.108  1.00  1.00          
ATOM    942 HG21 THR    58       2.463 -16.606  -4.270  1.00  1.00          
ATOM    943 HG22 THR    58       2.810 -16.189  -5.947  1.00  1.00          
ATOM    944 HG23 THR    58       1.138 -16.245  -5.381  1.00  1.00          
ATOM    945  C   THR    58       2.013 -12.847  -2.784  1.00  1.00          
ATOM    946  O   THR    58       3.244 -12.651  -2.648  1.00  1.00          
ATOM    947  N   LEU    59       1.051 -11.941  -2.376  1.00  1.00          
ATOM    948  HN  LEU    59       0.111 -12.217  -2.445  1.00  1.00          
ATOM    949  CA  LEU    59       1.347 -10.603  -1.784  1.00  1.00          
ATOM    950  HA  LEU    59       2.256 -10.253  -2.244  1.00  1.00          
ATOM    951  CB  LEU    59       0.194  -9.605  -2.082  1.00  1.00          
ATOM    952  HB1 LEU    59      -0.209  -9.264  -1.136  1.00  1.00          
ATOM    953  HB2 LEU    59      -0.585 -10.141  -2.603  1.00  1.00          
ATOM    954  CG  LEU    59       0.539  -8.353  -2.918  1.00  1.00          
ATOM    955  HG  LEU    59       1.597  -8.149  -2.859  1.00  1.00          
ATOM    956  CD1 LEU    59       0.179  -8.558  -4.386  1.00  1.00          
ATOM    957 HD11 LEU    59       0.648  -7.790  -4.982  1.00  1.00          
ATOM    958 HD12 LEU    59      -0.893  -8.502  -4.506  1.00  1.00          
ATOM    959 HD13 LEU    59       0.528  -9.529  -4.710  1.00  1.00          
ATOM    960  CD2 LEU    59      -0.199  -7.140  -2.364  1.00  1.00          
ATOM    961 HD21 LEU    59      -0.085  -6.307  -3.043  1.00  1.00          
ATOM    962 HD22 LEU    59       0.213  -6.878  -1.401  1.00  1.00          
ATOM    963 HD23 LEU    59      -1.248  -7.374  -2.255  1.00  1.00          
ATOM    964  C   LEU    59       1.576 -10.701  -0.224  1.00  1.00          
ATOM    965  O   LEU    59       1.091 -11.689   0.366  1.00  1.00          
ATOM    966  N   PRO    60       2.291  -9.689   0.512  1.00  1.00          
ATOM    967  CA  PRO    60       2.542  -9.770   2.005  1.00  1.00          
ATOM    968  HA  PRO    60       3.000 -10.718   2.259  1.00  1.00          
ATOM    969  CB  PRO    60       3.541  -8.618   2.284  1.00  1.00          
ATOM    970  HB1 PRO    60       4.331  -8.957   2.948  1.00  1.00          
ATOM    971  HB2 PRO    60       3.013  -7.795   2.748  1.00  1.00          
ATOM    972  CG  PRO    60       4.076  -8.238   0.941  1.00  1.00          
ATOM    973  HG1 PRO    60       4.889  -8.898   0.663  1.00  1.00          
ATOM    974  HG2 PRO    60       4.412  -7.208   0.945  1.00  1.00          
ATOM    975  CD  PRO    60       2.916  -8.416   0.005  1.00  1.00          
ATOM    976  HD1 PRO    60       3.258  -8.528  -1.012  1.00  1.00          
ATOM    977  HD2 PRO    60       2.228  -7.584   0.088  1.00  1.00          
ATOM    978  C   PRO    60       1.277  -9.594   2.870  1.00  1.00          
ATOM    979  O   PRO    60       0.309  -8.953   2.429  1.00  1.00          
ATOM    980  N   ARG    61       1.326 -10.175   4.109  1.00  1.00          
ATOM    981  HN  ARG    61       2.150 -10.644   4.354  1.00  1.00          
ATOM    982  CA  ARG    61       0.215 -10.152   5.121  1.00  1.00          
ATOM    983  HA  ARG    61      -0.676 -10.465   4.596  1.00  1.00          
ATOM    984  CB  ARG    61       0.482 -11.181   6.232  1.00  1.00          
ATOM    985  HB1 ARG    61      -0.032 -10.867   7.128  1.00  1.00          
ATOM    986  HB2 ARG    61       1.544 -11.214   6.428  1.00  1.00          
ATOM    987  CG  ARG    61       0.014 -12.587   5.877  1.00  1.00          
ATOM    988  HG1 ARG    61       0.531 -12.912   4.985  1.00  1.00          
ATOM    989  HG2 ARG    61      -1.048 -12.565   5.687  1.00  1.00          
ATOM    990  CD  ARG    61       0.286 -13.582   6.994  1.00  1.00          
ATOM    991  HD1 ARG    61      -0.206 -13.242   7.892  1.00  1.00          
ATOM    992  HD2 ARG    61       1.352 -13.636   7.163  1.00  1.00          
ATOM    993  NE  ARG    61      -0.219 -14.938   6.652  1.00  1.00          
ATOM    994  HE  ARG    61      -0.687 -15.011   5.795  1.00  1.00          
ATOM    995  CZ  ARG    61      -0.105 -16.080   7.398  1.00  1.00          
ATOM    996  NH1 ARG    61       0.508 -16.135   8.596  1.00  1.00          
ATOM    997 HH11 ARG    61       0.912 -15.309   8.988  1.00  1.00          
ATOM    998 HH12 ARG    61       0.558 -17.001   9.092  1.00  1.00          
ATOM    999  NH2 ARG    61      -0.629 -17.199   6.917  1.00  1.00          
ATOM   1000 HH21 ARG    61      -1.095 -17.194   6.032  1.00  1.00          
ATOM   1001 HH22 ARG    61      -0.562 -18.048   7.442  1.00  1.00          
ATOM   1002  C   ARG    61      -0.090  -8.754   5.739  1.00  1.00          
ATOM   1003  O   ARG    61      -1.190  -8.561   6.297  1.00  1.00          
ATOM   1004  N   ARG    62       0.883  -7.787   5.613  1.00  1.00          
ATOM   1005  HN  ARG    62       1.677  -7.969   5.070  1.00  1.00          
ATOM   1006  CA  ARG    62       0.757  -6.390   6.122  1.00  1.00          
ATOM   1007  HA  ARG    62       0.193  -6.431   7.042  1.00  1.00          
ATOM   1008  CB  ARG    62       2.140  -5.819   6.419  1.00  1.00          
ATOM   1009  HB1 ARG    62       2.128  -4.758   6.227  1.00  1.00          
ATOM   1010  HB2 ARG    62       2.860  -6.289   5.765  1.00  1.00          
ATOM   1011  CG  ARG    62       2.583  -6.042   7.863  1.00  1.00          
ATOM   1012  HG1 ARG    62       2.496  -7.095   8.091  1.00  1.00          
ATOM   1013  HG2 ARG    62       1.927  -5.480   8.515  1.00  1.00          
ATOM   1014  CD  ARG    62       4.030  -5.600   8.114  1.00  1.00          
ATOM   1015  HD1 ARG    62       4.186  -5.502   9.181  1.00  1.00          
ATOM   1016  HD2 ARG    62       4.183  -4.639   7.644  1.00  1.00          
ATOM   1017  NE  ARG    62       5.037  -6.563   7.573  1.00  1.00          
ATOM   1018  HE  ARG    62       4.687  -7.438   7.301  1.00  1.00          
ATOM   1019  CZ  ARG    62       6.378  -6.352   7.404  1.00  1.00          
ATOM   1020  NH1 ARG    62       7.002  -5.209   7.753  1.00  1.00          
ATOM   1021 HH11 ARG    62       6.480  -4.459   8.159  1.00  1.00          
ATOM   1022 HH12 ARG    62       7.986  -5.112   7.606  1.00  1.00          
ATOM   1023  NH2 ARG    62       7.109  -7.325   6.880  1.00  1.00          
ATOM   1024 HH21 ARG    62       6.677  -8.189   6.618  1.00  1.00          
ATOM   1025 HH22 ARG    62       8.091  -7.197   6.744  1.00  1.00          
ATOM   1026  C   ARG    62      -0.001  -5.469   5.128  1.00  1.00          
ATOM   1027  O   ARG    62      -0.718  -4.554   5.566  1.00  1.00          
ATOM   1028  N   GLU    63       0.185  -5.737   3.781  1.00  1.00          
ATOM   1029  HN  GLU    63       0.812  -6.451   3.540  1.00  1.00          
ATOM   1030  CA  GLU    63      -0.483  -5.013   2.644  1.00  1.00          
ATOM   1031  HA  GLU    63      -0.363  -3.958   2.832  1.00  1.00          
ATOM   1032  CB  GLU    63       0.205  -5.347   1.315  1.00  1.00          
ATOM   1033  HB1 GLU    63      -0.504  -5.212   0.514  1.00  1.00          
ATOM   1034  HB2 GLU    63       0.520  -6.379   1.336  1.00  1.00          
ATOM   1035  CG  GLU    63       1.430  -4.481   1.023  1.00  1.00          
ATOM   1036  HG1 GLU    63       2.159  -4.643   1.802  1.00  1.00          
ATOM   1037  HG2 GLU    63       1.126  -3.445   1.029  1.00  1.00          
ATOM   1038  CD  GLU    63       2.082  -4.780  -0.322  1.00  1.00          
ATOM   1039  OE1 GLU    63       3.211  -5.309  -0.323  1.00  1.00          
ATOM   1040  OE2 GLU    63       1.478  -4.459  -1.374  1.00  1.00          
ATOM   1041  C   GLU    63      -2.004  -5.306   2.532  1.00  1.00          
ATOM   1042  O   GLU    63      -2.757  -4.448   2.046  1.00  1.00          
ATOM   1043  N   ALA    64      -2.424  -6.543   2.991  1.00  1.00          
ATOM   1044  HN  ALA    64      -1.733  -7.165   3.292  1.00  1.00          
ATOM   1045  CA  ALA    64      -3.851  -7.021   3.050  1.00  1.00          
ATOM   1046  HA  ALA    64      -4.267  -6.928   2.057  1.00  1.00          
ATOM   1047  CB  ALA    64      -3.891  -8.493   3.436  1.00  1.00          
ATOM   1048  HB1 ALA    64      -4.908  -8.853   3.373  1.00  1.00          
ATOM   1049  HB2 ALA    64      -3.528  -8.612   4.446  1.00  1.00          
ATOM   1050  HB3 ALA    64      -3.268  -9.059   2.760  1.00  1.00          
ATOM   1051  C   ALA    64      -4.728  -6.188   4.032  1.00  1.00          
ATOM   1052  O   ALA    64      -5.934  -6.023   3.800  1.00  1.00          
ATOM   1053  N   GLU    65      -4.064  -5.680   5.132  1.00  1.00          
ATOM   1054  HN  GLU    65      -3.124  -5.930   5.241  1.00  1.00          
ATOM   1055  CA  GLU    65      -4.661  -4.777   6.179  1.00  1.00          
ATOM   1056  HA  GLU    65      -5.616  -5.197   6.458  1.00  1.00          
ATOM   1057  CB  GLU    65      -3.764  -4.716   7.427  1.00  1.00          
ATOM   1058  HB1 GLU    65      -4.016  -3.828   7.989  1.00  1.00          
ATOM   1059  HB2 GLU    65      -2.735  -4.649   7.110  1.00  1.00          
ATOM   1060  CG  GLU    65      -3.898  -5.921   8.355  1.00  1.00          
ATOM   1061  HG1 GLU    65      -3.647  -6.815   7.801  1.00  1.00          
ATOM   1062  HG2 GLU    65      -4.921  -5.986   8.695  1.00  1.00          
ATOM   1063  CD  GLU    65      -2.989  -5.830   9.566  1.00  1.00          
ATOM   1064  OE1 GLU    65      -1.820  -6.254   9.463  1.00  1.00          
ATOM   1065  OE2 GLU    65      -3.448  -5.334  10.617  1.00  1.00          
ATOM   1066  C   GLU    65      -4.904  -3.336   5.637  1.00  1.00          
ATOM   1067  O   GLU    65      -5.807  -2.638   6.122  1.00  1.00          
ATOM   1068  N   LYS    66      -4.061  -2.925   4.618  1.00  1.00          
ATOM   1069  HN  LYS    66      -3.348  -3.544   4.353  1.00  1.00          
ATOM   1070  CA  LYS    66      -4.141  -1.614   3.877  1.00  1.00          
ATOM   1071  HA  LYS    66      -4.193  -0.833   4.622  1.00  1.00          
ATOM   1072  CB  LYS    66      -2.892  -1.379   3.008  1.00  1.00          
ATOM   1073  HB1 LYS    66      -3.119  -0.611   2.282  1.00  1.00          
ATOM   1074  HB2 LYS    66      -2.660  -2.293   2.484  1.00  1.00          
ATOM   1075  CG  LYS    66      -1.646  -0.949   3.780  1.00  1.00          
ATOM   1076  HG1 LYS    66      -1.381  -1.727   4.480  1.00  1.00          
ATOM   1077  HG2 LYS    66      -1.860  -0.036   4.316  1.00  1.00          
ATOM   1078  CD  LYS    66      -0.473  -0.706   2.844  1.00  1.00          
ATOM   1079  HD1 LYS    66      -0.743   0.062   2.135  1.00  1.00          
ATOM   1080  HD2 LYS    66      -0.248  -1.620   2.318  1.00  1.00          
ATOM   1081  CE  LYS    66       0.761  -0.260   3.609  1.00  1.00          
ATOM   1082  HE1 LYS    66       1.028  -1.032   4.317  1.00  1.00          
ATOM   1083  HE2 LYS    66       0.530   0.650   4.140  1.00  1.00          
ATOM   1084  NZ  LYS    66       1.917  -0.012   2.706  1.00  1.00          
ATOM   1085  HZ1 LYS    66       2.282   0.951   2.850  1.00  1.00          
ATOM   1086  HZ2 LYS    66       1.625  -0.116   1.714  1.00  1.00          
ATOM   1087  HZ3 LYS    66       2.677  -0.693   2.905  1.00  1.00          
ATOM   1088  C   LYS    66      -5.405  -1.510   2.980  1.00  1.00          
ATOM   1089  O   LYS    66      -5.903  -0.399   2.742  1.00  1.00          
ATOM   1090  N   VAL    67      -5.900  -2.708   2.492  1.00  1.00          
ATOM   1091  HN  VAL    67      -5.401  -3.522   2.717  1.00  1.00          
ATOM   1092  CA  VAL    67      -7.146  -2.879   1.637  1.00  1.00          
ATOM   1093  HA  VAL    67      -7.070  -2.150   0.837  1.00  1.00          
ATOM   1094  CB  VAL    67      -7.300  -4.336   0.963  1.00  1.00          
ATOM   1095  HB  VAL    67      -7.701  -5.001   1.715  1.00  1.00          
ATOM   1096  CG1 VAL    67      -8.282  -4.338  -0.231  1.00  1.00          
ATOM   1097 HG11 VAL    67      -9.277  -4.113   0.123  1.00  1.00          
ATOM   1098 HG12 VAL    67      -8.276  -5.309  -0.702  1.00  1.00          
ATOM   1099 HG13 VAL    67      -7.977  -3.587  -0.947  1.00  1.00          
ATOM   1100  CG2 VAL    67      -5.971  -4.936   0.462  1.00  1.00          
ATOM   1101 HG21 VAL    67      -5.627  -4.378  -0.397  1.00  1.00          
ATOM   1102 HG22 VAL    67      -6.123  -5.968   0.185  1.00  1.00          
ATOM   1103 HG23 VAL    67      -5.232  -4.879   1.248  1.00  1.00          
ATOM   1104  C   VAL    67      -8.421  -2.511   2.492  1.00  1.00          
ATOM   1105  O   VAL    67      -9.346  -1.894   1.965  1.00  1.00          
ATOM   1106  N   PHE    68      -8.439  -2.927   3.807  1.00  1.00          
ATOM   1107  HN  PHE    68      -7.742  -3.540   4.124  1.00  1.00          
ATOM   1108  CA  PHE    68      -9.503  -2.592   4.824  1.00  1.00          
ATOM   1109  HA  PHE    68     -10.443  -3.012   4.483  1.00  1.00          
ATOM   1110  CB  PHE    68      -9.123  -3.235   6.174  1.00  1.00          
ATOM   1111  HB1 PHE    68      -9.193  -2.480   6.944  1.00  1.00          
ATOM   1112  HB2 PHE    68      -8.101  -3.576   6.116  1.00  1.00          
ATOM   1113  CG  PHE    68      -9.968  -4.414   6.608  1.00  1.00          
ATOM   1114  CD1 PHE    68      -9.597  -5.713   6.280  1.00  1.00          
ATOM   1115  HD1 PHE    68      -8.704  -5.875   5.696  1.00  1.00          
ATOM   1116  CD2 PHE    68     -11.119  -4.226   7.366  1.00  1.00          
ATOM   1117  HD2 PHE    68     -11.420  -3.224   7.631  1.00  1.00          
ATOM   1118  CE1 PHE    68     -10.354  -6.794   6.695  1.00  1.00          
ATOM   1119  HE1 PHE    68     -10.053  -7.798   6.434  1.00  1.00          
ATOM   1120  CE2 PHE    68     -11.878  -5.303   7.780  1.00  1.00          
ATOM   1121  HE2 PHE    68     -12.771  -5.141   8.365  1.00  1.00          
ATOM   1122  CZ  PHE    68     -11.496  -6.588   7.445  1.00  1.00          
ATOM   1123  HZ  PHE    68     -12.089  -7.430   7.769  1.00  1.00          
ATOM   1124  C   PHE    68      -9.679  -1.054   5.056  1.00  1.00          
ATOM   1125  O   PHE    68     -10.775  -0.605   5.420  1.00  1.00          
ATOM   1126  N   GLU    69      -8.551  -0.285   4.832  1.00  1.00          
ATOM   1127  HN  GLU    69      -7.763  -0.745   4.481  1.00  1.00          
ATOM   1128  CA  GLU    69      -8.443   1.192   5.008  1.00  1.00          
ATOM   1129  HA  GLU    69      -8.881   1.428   5.967  1.00  1.00          
ATOM   1130  CB  GLU    69      -6.947   1.586   5.046  1.00  1.00          
ATOM   1131  HB1 GLU    69      -6.628   1.823   4.042  1.00  1.00          
ATOM   1132  HB2 GLU    69      -6.379   0.739   5.399  1.00  1.00          
ATOM   1133  CG  GLU    69      -6.622   2.781   5.946  1.00  1.00          
ATOM   1134  HG1 GLU    69      -6.989   2.573   6.940  1.00  1.00          
ATOM   1135  HG2 GLU    69      -7.132   3.648   5.551  1.00  1.00          
ATOM   1136  CD  GLU    69      -5.134   3.083   6.022  1.00  1.00          
ATOM   1137  OE1 GLU    69      -4.595   3.674   5.062  1.00  1.00          
ATOM   1138  OE2 GLU    69      -4.509   2.732   7.046  1.00  1.00          
ATOM   1139  C   GLU    69      -9.214   1.994   3.916  1.00  1.00          
ATOM   1140  O   GLU    69      -9.885   2.978   4.264  1.00  1.00          
ATOM   1141  N   LEU    70      -9.110   1.556   2.607  1.00  1.00          
ATOM   1142  HN  LEU    70      -8.516   0.805   2.412  1.00  1.00          
ATOM   1143  CA  LEU    70      -9.829   2.185   1.439  1.00  1.00          
ATOM   1144  HA  LEU    70      -9.645   3.250   1.524  1.00  1.00          
ATOM   1145  CB  LEU    70      -9.287   1.700   0.048  1.00  1.00          
ATOM   1146  HB1 LEU    70      -8.383   2.242  -0.168  1.00  1.00          
ATOM   1147  HB2 LEU    70     -10.013   1.983  -0.674  1.00  1.00          
ATOM   1148  CG  LEU    70      -8.996   0.195  -0.186  1.00  1.00          
ATOM   1149  HG  LEU    70      -8.749  -0.268   0.759  1.00  1.00          
ATOM   1150  CD1 LEU    70     -10.218  -0.516  -0.756  1.00  1.00          
ATOM   1151 HD11 LEU    70     -10.060  -1.586  -0.739  1.00  1.00          
ATOM   1152 HD12 LEU    70     -10.377  -0.191  -1.773  1.00  1.00          
ATOM   1153 HD13 LEU    70     -11.085  -0.270  -0.160  1.00  1.00          
ATOM   1154  CD2 LEU    70      -7.806   0.024  -1.121  1.00  1.00          
ATOM   1155 HD21 LEU    70      -7.757  -1.002  -1.460  1.00  1.00          
ATOM   1156 HD22 LEU    70      -6.895   0.273  -0.598  1.00  1.00          
ATOM   1157 HD23 LEU    70      -7.922   0.677  -1.972  1.00  1.00          
ATOM   1158  C   LEU    70     -11.373   1.987   1.512  1.00  1.00          
ATOM   1159  O   LEU    70     -12.134   2.895   1.140  1.00  1.00          
ATOM   1160  N   LEU    71     -11.784   0.771   2.002  1.00  1.00          
ATOM   1161  HN  LEU    71     -11.086   0.116   2.213  1.00  1.00          
ATOM   1162  CA  LEU    71     -13.199   0.356   2.240  1.00  1.00          
ATOM   1163  HA  LEU    71     -13.763   0.606   1.357  1.00  1.00          
ATOM   1164  CB  LEU    71     -13.260  -1.167   2.456  1.00  1.00          
ATOM   1165  HB1 LEU    71     -14.146  -1.382   3.034  1.00  1.00          
ATOM   1166  HB2 LEU    71     -12.397  -1.456   3.040  1.00  1.00          
ATOM   1167  CG  LEU    71     -13.288  -2.029   1.183  1.00  1.00          
ATOM   1168  HG  LEU    71     -13.164  -1.397   0.318  1.00  1.00          
ATOM   1169  CD1 LEU    71     -12.147  -3.033   1.182  1.00  1.00          
ATOM   1170 HD11 LEU    71     -11.205  -2.503   1.168  1.00  1.00          
ATOM   1171 HD12 LEU    71     -12.220  -3.658   0.306  1.00  1.00          
ATOM   1172 HD13 LEU    71     -12.198  -3.644   2.067  1.00  1.00          
ATOM   1173  CD2 LEU    71     -14.623  -2.746   1.055  1.00  1.00          
ATOM   1174 HD21 LEU    71     -14.602  -3.393   0.190  1.00  1.00          
ATOM   1175 HD22 LEU    71     -15.409  -2.015   0.936  1.00  1.00          
ATOM   1176 HD23 LEU    71     -14.814  -3.335   1.940  1.00  1.00          
ATOM   1177  C   LEU    71     -13.856   1.087   3.457  1.00  1.00          
ATOM   1178  O   LEU    71     -15.050   1.425   3.397  1.00  1.00          
ATOM   1179  N   ASN    72     -13.034   1.313   4.541  1.00  1.00          
ATOM   1180  HN  ASN    72     -12.098   1.021   4.473  1.00  1.00          
ATOM   1181  CA  ASN    72     -13.440   1.994   5.806  1.00  1.00          
ATOM   1182  HA  ASN    72     -14.442   1.664   6.041  1.00  1.00          
ATOM   1183  CB  ASN    72     -12.512   1.554   6.941  1.00  1.00          
ATOM   1184  HB1 ASN    72     -12.456   2.341   7.678  1.00  1.00          
ATOM   1185  HB2 ASN    72     -11.526   1.373   6.539  1.00  1.00          
ATOM   1186  CG  ASN    72     -12.988   0.287   7.626  1.00  1.00          
ATOM   1187  OD1 ASN    72     -12.934  -0.803   7.055  1.00  1.00          
ATOM   1188  ND2 ASN    72     -13.458   0.424   8.859  1.00  1.00          
ATOM   1189 HD21 ASN    72     -13.474   1.322   9.251  1.00  1.00          
ATOM   1190 HD22 ASN    72     -13.769  -0.379   9.327  1.00  1.00          
ATOM   1191  C   ASN    72     -13.448   3.544   5.718  1.00  1.00          
ATOM   1192  O   ASN    72     -14.280   4.182   6.390  1.00  1.00          
ATOM   1193  N   ASP    73     -12.524   4.111   4.883  1.00  1.00          
ATOM   1194  HN  ASP    73     -11.957   3.514   4.357  1.00  1.00          
ATOM   1195  CA  ASP    73     -12.367   5.571   4.687  1.00  1.00          
ATOM   1196  HA  ASP    73     -12.853   6.050   5.527  1.00  1.00          
ATOM   1197  CB  ASP    73     -10.859   5.931   4.724  1.00  1.00          
ATOM   1198  HB1 ASP    73     -10.475   5.915   3.716  1.00  1.00          
ATOM   1199  HB2 ASP    73     -10.336   5.195   5.314  1.00  1.00          
ATOM   1200  CG  ASP    73     -10.590   7.305   5.323  1.00  1.00          
ATOM   1201  OD1 ASP    73     -10.854   8.315   4.635  1.00  1.00          
ATOM   1202  OD2 ASP    73     -10.116   7.368   6.477  1.00  1.00          
ATOM   1203  C   ASP    73     -13.099   6.036   3.387  1.00  1.00          
ATOM   1204  O   ASP    73     -12.512   6.625   2.440  1.00  1.00          
ATOM   1205  N   PHE    74     -14.424   5.737   3.388  1.00  1.00          
ATOM   1206  HN  PHE    74     -14.759   5.233   4.154  1.00  1.00          
ATOM   1207  CA  PHE    74     -15.377   6.081   2.304  1.00  1.00          
ATOM   1208  HA  PHE    74     -14.812   6.156   1.388  1.00  1.00          
ATOM   1209  CB  PHE    74     -16.431   4.965   2.145  1.00  1.00          
ATOM   1210  HB1 PHE    74     -17.407   5.374   2.368  1.00  1.00          
ATOM   1211  HB2 PHE    74     -16.214   4.177   2.849  1.00  1.00          
ATOM   1212  CG  PHE    74     -16.497   4.340   0.761  1.00  1.00          
ATOM   1213  CD1 PHE    74     -15.668   3.275   0.408  1.00  1.00          
ATOM   1214  HD1 PHE    74     -14.959   2.895   1.129  1.00  1.00          
ATOM   1215  CD2 PHE    74     -17.401   4.812  -0.184  1.00  1.00          
ATOM   1216  HD2 PHE    74     -18.053   5.635   0.071  1.00  1.00          
ATOM   1217  CE1 PHE    74     -15.740   2.707  -0.849  1.00  1.00          
ATOM   1218  HE1 PHE    74     -15.090   1.884  -1.108  1.00  1.00          
ATOM   1219  CE2 PHE    74     -17.473   4.245  -1.443  1.00  1.00          
ATOM   1220  HE2 PHE    74     -18.179   4.624  -2.166  1.00  1.00          
ATOM   1221  CZ  PHE    74     -16.643   3.192  -1.774  1.00  1.00          
ATOM   1222  HZ  PHE    74     -16.700   2.748  -2.757  1.00  1.00          
ATOM   1223  C   PHE    74     -16.064   7.430   2.566  1.00  1.00          
ATOM   1224  O   PHE    74     -16.342   7.781   3.723  1.00  1.00          
ATOM   1225  N   LYS    75     -16.345   8.186   1.442  1.00  1.00          
ATOM   1226  HN  LYS    75     -16.106   7.786   0.580  1.00  1.00          
ATOM   1227  CA  LYS    75     -16.981   9.574   1.391  1.00  1.00          
ATOM   1228  HA  LYS    75     -17.230   9.733   0.349  1.00  1.00          
ATOM   1229  CB  LYS    75     -18.306   9.741   2.220  1.00  1.00          
ATOM   1230  HB1 LYS    75     -18.359  10.754   2.591  1.00  1.00          
ATOM   1231  HB2 LYS    75     -18.277   9.063   3.062  1.00  1.00          
ATOM   1232  CG  LYS    75     -19.570   9.455   1.426  1.00  1.00          
ATOM   1233  HG1 LYS    75     -19.478   8.486   0.959  1.00  1.00          
ATOM   1234  HG2 LYS    75     -19.687  10.215   0.667  1.00  1.00          
ATOM   1235  CD  LYS    75     -20.801   9.459   2.327  1.00  1.00          
ATOM   1236  HD1 LYS    75     -20.853  10.410   2.838  1.00  1.00          
ATOM   1237  HD2 LYS    75     -20.699   8.665   3.055  1.00  1.00          
ATOM   1238  CE  LYS    75     -22.093   9.254   1.530  1.00  1.00          
ATOM   1239  HE1 LYS    75     -22.855   8.851   2.184  1.00  1.00          
ATOM   1240  HE2 LYS    75     -21.897   8.551   0.734  1.00  1.00          
ATOM   1241  NZ  LYS    75     -22.595  10.528   0.935  1.00  1.00          
ATOM   1242  HZ1 LYS    75     -22.066  10.752   0.068  1.00  1.00          
ATOM   1243  HZ2 LYS    75     -22.473  11.309   1.612  1.00  1.00          
ATOM   1244  HZ3 LYS    75     -23.603  10.441   0.702  1.00  1.00          
ATOM   1245  C   LYS    75     -15.957  10.674   1.761  1.00  1.00          
ATOM   1246  O   LYS    75     -15.480  10.734   2.919  1.00  1.00          
ATOM   1247  N   GLY    76     -15.614  11.494   0.732  1.00  1.00          
ATOM   1248  HN  GLY    76     -16.034  11.341  -0.140  1.00  1.00          
ATOM   1249  CA  GLY    76     -14.651  12.595   0.866  1.00  1.00          
ATOM   1250  HA1 GLY    76     -13.866  12.287   1.541  1.00  1.00          
ATOM   1251  HA2 GLY    76     -15.157  13.450   1.290  1.00  1.00          
ATOM   1252  C   GLY    76     -14.025  12.999  -0.458  1.00  1.00          
ATOM   1253  O   GLY    76     -14.391  14.058  -1.005  1.00  1.00          
ATOM   1254  N   GLY    77     -13.089  12.142  -0.950  1.00  1.00          
ATOM   1255  HN  GLY    77     -12.885  11.334  -0.436  1.00  1.00          
ATOM   1256  CA  GLY    77     -12.365  12.375  -2.221  1.00  1.00          
ATOM   1257  HA1 GLY    77     -11.311  12.461  -1.997  1.00  1.00          
ATOM   1258  HA2 GLY    77     -12.700  13.311  -2.639  1.00  1.00          
ATOM   1259  C   GLY    77     -12.541  11.287  -3.285  1.00  1.00          
ATOM   1260  O   GLY    77     -11.601  11.072  -4.073  1.00  1.00          
ATOM   1261  N   ILE    78     -13.729  10.616  -3.301  1.00  1.00          
ATOM   1262  HN  ILE    78     -14.405  10.858  -2.636  1.00  1.00          
ATOM   1263  CA  ILE    78     -14.055   9.535  -4.278  1.00  1.00          
ATOM   1264  HA  ILE    78     -13.224   9.468  -4.971  1.00  1.00          
ATOM   1265  CB  ILE    78     -14.285   8.078  -3.623  1.00  1.00          
ATOM   1266  HB  ILE    78     -15.313   8.025  -3.295  1.00  1.00          
ATOM   1267  CG1 ILE    78     -13.357   7.776  -2.416  1.00  1.00          
ATOM   1268 HG11 ILE    78     -12.680   8.609  -2.276  1.00  1.00          
ATOM   1269 HG12 ILE    78     -12.785   6.885  -2.622  1.00  1.00          
ATOM   1270  CG2 ILE    78     -14.062   6.944  -4.653  1.00  1.00          
ATOM   1271 HG21 ILE    78     -14.611   7.167  -5.557  1.00  1.00          
ATOM   1272 HG22 ILE    78     -14.412   6.008  -4.242  1.00  1.00          
ATOM   1273 HG23 ILE    78     -13.009   6.865  -4.881  1.00  1.00          
ATOM   1274  CD1 ILE    78     -14.104   7.558  -1.118  1.00  1.00          
ATOM   1275 HD11 ILE    78     -14.678   8.442  -0.880  1.00  1.00          
ATOM   1276 HD12 ILE    78     -13.398   7.364  -0.324  1.00  1.00          
ATOM   1277 HD13 ILE    78     -14.770   6.714  -1.222  1.00  1.00          
ATOM   1278  C   ILE    78     -15.308   9.982  -5.069  1.00  1.00          
ATOM   1279  O   ILE    78     -16.370  10.216  -4.462  1.00  1.00          
ATOM   1280  N   ASP    79     -15.134  10.090  -6.412  1.00  1.00          
ATOM   1281  HN  ASP    79     -14.247   9.892  -6.779  1.00  1.00          
ATOM   1282  CA  ASP    79     -16.200  10.488  -7.355  1.00  1.00          
ATOM   1283  HA  ASP    79     -17.123  10.546  -6.796  1.00  1.00          
ATOM   1284  CB  ASP    79     -15.902  11.868  -7.968  1.00  1.00          
ATOM   1285  HB1 ASP    79     -16.448  11.965  -8.894  1.00  1.00          
ATOM   1286  HB2 ASP    79     -14.845  11.943  -8.171  1.00  1.00          
ATOM   1287  CG  ASP    79     -16.299  13.014  -7.052  1.00  1.00          
ATOM   1288  OD1 ASP    79     -15.392  13.678  -6.508  1.00  1.00          
ATOM   1289  OD2 ASP    79     -17.516  13.251  -6.884  1.00  1.00          
ATOM   1290  C   ASP    79     -16.367   9.439  -8.456  1.00  1.00          
ATOM   1291  O   ASP    79     -15.369   9.004  -9.067  1.00  1.00          
ATOM   1292  N   TRP    80     -17.649   9.026  -8.669  1.00  1.00          
ATOM   1293  HN  TRP    80     -18.351   9.424  -8.112  1.00  1.00          
ATOM   1294  CA  TRP    80     -18.065   8.009  -9.693  1.00  1.00          
ATOM   1295  HA  TRP    80     -17.284   7.264  -9.721  1.00  1.00          
ATOM   1296  CB  TRP    80     -19.368   7.313  -9.266  1.00  1.00          
ATOM   1297  HB1 TRP    80     -19.786   6.791 -10.114  1.00  1.00          
ATOM   1298  HB2 TRP    80     -20.071   8.058  -8.923  1.00  1.00          
ATOM   1299  CG  TRP    80     -19.169   6.307  -8.145  1.00  1.00          
ATOM   1300  CD1 TRP    80     -19.391   6.544  -6.819  1.00  1.00          
ATOM   1301  HD1 TRP    80     -19.745   7.485  -6.425  1.00  1.00          
ATOM   1302  CD2 TRP    80     -18.703   4.930  -8.229  1.00  1.00          
ATOM   1303  NE1 TRP    80     -19.095   5.430  -6.076  1.00  1.00          
ATOM   1304  HE1 TRP    80     -19.175   5.361  -5.101  1.00  1.00          
ATOM   1305  CE2 TRP    80     -18.674   4.429  -6.910  1.00  1.00          
ATOM   1306  CE3 TRP    80     -18.306   4.066  -9.277  1.00  1.00          
ATOM   1307  HE3 TRP    80     -18.313   4.397 -10.304  1.00  1.00          
ATOM   1308  CZ2 TRP    80     -18.271   3.129  -6.610  1.00  1.00          
ATOM   1309  HZ2 TRP    80     -18.253   2.759  -5.596  1.00  1.00          
ATOM   1310  CZ3 TRP    80     -17.909   2.777  -8.969  1.00  1.00          
ATOM   1311  HZ3 TRP    80     -17.604   2.102  -9.759  1.00  1.00          
ATOM   1312  CH2 TRP    80     -17.894   2.321  -7.647  1.00  1.00          
ATOM   1313  HH2 TRP    80     -17.575   1.308  -7.453  1.00  1.00          
ATOM   1314  C   TRP    80     -18.210   8.581 -11.130  1.00  1.00          
ATOM   1315  O   TRP    80     -17.950   7.851 -12.102  1.00  1.00          
ATOM   1316  N   GLU    81     -18.632   9.883 -11.229  1.00  1.00          
ATOM   1317  HN  GLU    81     -18.821  10.362 -10.396  1.00  1.00          
ATOM   1318  CA  GLU    81     -18.823  10.631 -12.519  1.00  1.00          
ATOM   1319  HA  GLU    81     -19.262   9.941 -13.225  1.00  1.00          
ATOM   1320  CB  GLU    81     -19.801  11.809 -12.323  1.00  1.00          
ATOM   1321  HB1 GLU    81     -19.668  12.505 -13.137  1.00  1.00          
ATOM   1322  HB2 GLU    81     -19.558  12.308 -11.397  1.00  1.00          
ATOM   1323  CG  GLU    81     -21.276  11.411 -12.273  1.00  1.00          
ATOM   1324  HG1 GLU    81     -21.414  10.696 -11.476  1.00  1.00          
ATOM   1325  HG2 GLU    81     -21.544  10.955 -13.215  1.00  1.00          
ATOM   1326  CD  GLU    81     -22.191  12.596 -12.029  1.00  1.00          
ATOM   1327  OE1 GLU    81     -22.409  12.944 -10.849  1.00  1.00          
ATOM   1328  OE2 GLU    81     -22.693  13.174 -13.017  1.00  1.00          
ATOM   1329  C   GLU    81     -17.492  11.159 -13.127  1.00  1.00          
ATOM   1330  O   GLU    81     -17.354  11.175 -14.364  1.00  1.00          
ATOM   1331  N   ASN    82     -16.547  11.581 -12.234  1.00  1.00          
ATOM   1332  HN  ASN    82     -16.764  11.528 -11.281  1.00  1.00          
ATOM   1333  CA  ASN    82     -15.209  12.112 -12.609  1.00  1.00          
ATOM   1334  HA  ASN    82     -15.290  12.507 -13.611  1.00  1.00          
ATOM   1335  CB  ASN    82     -14.834  13.262 -11.661  1.00  1.00          
ATOM   1336  HB1 ASN    82     -13.760  13.375 -11.649  1.00  1.00          
ATOM   1337  HB2 ASN    82     -15.177  13.023 -10.665  1.00  1.00          
ATOM   1338  CG  ASN    82     -15.451  14.585 -12.077  1.00  1.00          
ATOM   1339  OD1 ASN    82     -16.545  14.941 -11.636  1.00  1.00          
ATOM   1340  ND2 ASN    82     -14.753  15.321 -12.936  1.00  1.00          
ATOM   1341 HD21 ASN    82     -13.892  14.972 -13.249  1.00  1.00          
ATOM   1342 HD22 ASN    82     -15.129  16.179 -13.222  1.00  1.00          
ATOM   1343  C   ASN    82     -14.090  11.029 -12.597  1.00  1.00          
ATOM   1344  O   ASN    82     -13.014  11.254 -13.179  1.00  1.00          
ATOM   1345  N   LYS    83     -14.365   9.822 -11.944  1.00  1.00          
ATOM   1346  HN  LYS    83     -15.254   9.736 -11.541  1.00  1.00          
ATOM   1347  CA  LYS    83     -13.433   8.623 -11.790  1.00  1.00          
ATOM   1348  HA  LYS    83     -13.974   7.939 -11.145  1.00  1.00          
ATOM   1349  CB  LYS    83     -13.206   7.870 -13.151  1.00  1.00          
ATOM   1350  HB1 LYS    83     -12.300   7.286 -13.080  1.00  1.00          
ATOM   1351  HB2 LYS    83     -13.089   8.602 -13.935  1.00  1.00          
ATOM   1352  CG  LYS    83     -14.343   6.943 -13.540  1.00  1.00          
ATOM   1353  HG1 LYS    83     -15.259   7.512 -13.597  1.00  1.00          
ATOM   1354  HG2 LYS    83     -14.440   6.172 -12.788  1.00  1.00          
ATOM   1355  CD  LYS    83     -14.081   6.286 -14.884  1.00  1.00          
ATOM   1356  HD1 LYS    83     -13.142   5.753 -14.838  1.00  1.00          
ATOM   1357  HD2 LYS    83     -14.024   7.054 -15.642  1.00  1.00          
ATOM   1358  CE  LYS    83     -15.187   5.313 -15.253  1.00  1.00          
ATOM   1359  HE1 LYS    83     -16.123   5.849 -15.296  1.00  1.00          
ATOM   1360  HE2 LYS    83     -15.244   4.548 -14.492  1.00  1.00          
ATOM   1361  NZ  LYS    83     -14.938   4.664 -16.569  1.00  1.00          
ATOM   1362  HZ1 LYS    83     -13.954   4.827 -16.866  1.00  1.00          
ATOM   1363  HZ2 LYS    83     -15.576   5.060 -17.288  1.00  1.00          
ATOM   1364  HZ3 LYS    83     -15.103   3.640 -16.498  1.00  1.00          
ATOM   1365  C   LYS    83     -12.093   8.949 -11.022  1.00  1.00          
ATOM   1366  O   LYS    83     -10.958   8.649 -11.484  1.00  1.00          
ATOM   1367  N   ARG    84     -12.280   9.578  -9.829  1.00  1.00          
ATOM   1368  HN  ARG    84     -13.197   9.781  -9.556  1.00  1.00          
ATOM   1369  CA  ARG    84     -11.177   9.973  -8.915  1.00  1.00          
ATOM   1370  HA  ARG    84     -10.248   9.735  -9.415  1.00  1.00          
ATOM   1371  CB  ARG    84     -11.199  11.488  -8.602  1.00  1.00          
ATOM   1372  HB1 ARG    84     -10.545  11.673  -7.762  1.00  1.00          
ATOM   1373  HB2 ARG    84     -12.204  11.766  -8.325  1.00  1.00          
ATOM   1374  CG  ARG    84     -10.759  12.395  -9.761  1.00  1.00          
ATOM   1375  HG1 ARG    84     -11.394  12.192 -10.613  1.00  1.00          
ATOM   1376  HG2 ARG    84      -9.736  12.160 -10.014  1.00  1.00          
ATOM   1377  CD  ARG    84     -10.846  13.887  -9.411  1.00  1.00          
ATOM   1378  HD1 ARG    84     -11.771  14.060  -8.880  1.00  1.00          
ATOM   1379  HD2 ARG    84     -10.850  14.462 -10.328  1.00  1.00          
ATOM   1380  NE  ARG    84      -9.710  14.353  -8.562  1.00  1.00          
ATOM   1381  HE  ARG    84      -9.050  13.668  -8.321  1.00  1.00          
ATOM   1382  CZ  ARG    84      -9.489  15.622  -8.092  1.00  1.00          
ATOM   1383  NH1 ARG    84     -10.311  16.662  -8.334  1.00  1.00          
ATOM   1384 HH11 ARG    84     -11.137  16.530  -8.883  1.00  1.00          
ATOM   1385 HH12 ARG    84     -10.096  17.567  -7.966  1.00  1.00          
ATOM   1386  NH2 ARG    84      -8.407  15.842  -7.358  1.00  1.00          
ATOM   1387 HH21 ARG    84      -7.777  15.091  -7.158  1.00  1.00          
ATOM   1388 HH22 ARG    84      -8.220  16.759  -7.004  1.00  1.00          
ATOM   1389  C   ARG    84     -11.241   9.161  -7.617  1.00  1.00          
ATOM   1390  O   ARG    84     -12.313   9.074  -6.983  1.00  1.00          
ATOM   1391  N   VAL    85     -10.077   8.561  -7.263  1.00  1.00          
ATOM   1392  HN  VAL    85      -9.301   8.687  -7.846  1.00  1.00          
ATOM   1393  CA  VAL    85      -9.904   7.718  -6.039  1.00  1.00          
ATOM   1394  HA  VAL    85     -10.812   7.810  -5.456  1.00  1.00          
ATOM   1395  CB  VAL    85      -9.646   6.150  -6.330  1.00  1.00          
ATOM   1396  HB  VAL    85      -8.581   6.030  -6.499  1.00  1.00          
ATOM   1397  CG1 VAL    85     -10.035   5.258  -5.126  1.00  1.00          
ATOM   1398 HG11 VAL    85     -11.101   5.079  -5.142  1.00  1.00          
ATOM   1399 HG12 VAL    85      -9.770   5.759  -4.207  1.00  1.00          
ATOM   1400 HG13 VAL    85      -9.511   4.313  -5.184  1.00  1.00          
ATOM   1401  CG2 VAL    85     -10.393   5.597  -7.571  1.00  1.00          
ATOM   1402 HG21 VAL    85     -10.481   6.377  -8.314  1.00  1.00          
ATOM   1403 HG22 VAL    85     -11.379   5.269  -7.279  1.00  1.00          
ATOM   1404 HG23 VAL    85      -9.849   4.761  -7.991  1.00  1.00          
ATOM   1405  C   VAL    85      -8.733   8.306  -5.209  1.00  1.00          
ATOM   1406  O   VAL    85      -7.655   8.571  -5.773  1.00  1.00          
ATOM   1407  N   LYS    86      -8.991   8.498  -3.887  1.00  1.00          
ATOM   1408  HN  LYS    86      -9.890   8.294  -3.556  1.00  1.00          
ATOM   1409  CA  LYS    86      -8.000   9.027  -2.925  1.00  1.00          
ATOM   1410  HA  LYS    86      -7.071   9.173  -3.455  1.00  1.00          
ATOM   1411  CB  LYS    86      -8.473  10.381  -2.362  1.00  1.00          
ATOM   1412  HB1 LYS    86      -8.009  10.529  -1.398  1.00  1.00          
ATOM   1413  HB2 LYS    86      -9.545  10.332  -2.223  1.00  1.00          
ATOM   1414  CG  LYS    86      -8.139  11.597  -3.250  1.00  1.00          
ATOM   1415  HG1 LYS    86      -8.972  12.293  -3.242  1.00  1.00          
ATOM   1416  HG2 LYS    86      -7.974  11.254  -4.259  1.00  1.00          
ATOM   1417  CD  LYS    86      -6.886  12.335  -2.776  1.00  1.00          
ATOM   1418  HD1 LYS    86      -6.049  11.653  -2.800  1.00  1.00          
ATOM   1419  HD2 LYS    86      -7.043  12.682  -1.765  1.00  1.00          
ATOM   1420  CE  LYS    86      -6.575  13.533  -3.661  1.00  1.00          
ATOM   1421  HE1 LYS    86      -7.425  14.199  -3.653  1.00  1.00          
ATOM   1422  HE2 LYS    86      -6.402  13.184  -4.668  1.00  1.00          
ATOM   1423  NZ  LYS    86      -5.372  14.274  -3.191  1.00  1.00          
ATOM   1424  HZ1 LYS    86      -5.657  15.075  -2.592  1.00  1.00          
ATOM   1425  HZ2 LYS    86      -4.837  14.638  -4.005  1.00  1.00          
ATOM   1426  HZ3 LYS    86      -4.756  13.644  -2.640  1.00  1.00          
ATOM   1427  C   LYS    86      -7.759   8.043  -1.773  1.00  1.00          
ATOM   1428  O   LYS    86      -8.720   7.452  -1.243  1.00  1.00          
ATOM   1429  N   LEU    87      -6.457   7.890  -1.420  1.00  1.00          
ATOM   1430  HN  LEU    87      -5.788   8.401  -1.914  1.00  1.00          
ATOM   1431  CA  LEU    87      -5.975   7.022  -0.331  1.00  1.00          
ATOM   1432  HA  LEU    87      -6.839   6.619   0.176  1.00  1.00          
ATOM   1433  CB  LEU    87      -5.117   5.864  -0.882  1.00  1.00          
ATOM   1434  HB1 LEU    87      -4.350   5.647  -0.155  1.00  1.00          
ATOM   1435  HB2 LEU    87      -4.637   6.212  -1.785  1.00  1.00          
ATOM   1436  CG  LEU    87      -5.861   4.550  -1.208  1.00  1.00          
ATOM   1437  HG  LEU    87      -6.926   4.721  -1.180  1.00  1.00          
ATOM   1438  CD1 LEU    87      -5.511   4.050  -2.604  1.00  1.00          
ATOM   1439 HD11 LEU    87      -5.965   4.693  -3.341  1.00  1.00          
ATOM   1440 HD12 LEU    87      -5.887   3.044  -2.725  1.00  1.00          
ATOM   1441 HD13 LEU    87      -4.438   4.049  -2.733  1.00  1.00          
ATOM   1442  CD2 LEU    87      -5.525   3.478  -0.176  1.00  1.00          
ATOM   1443 HD21 LEU    87      -5.823   3.815   0.806  1.00  1.00          
ATOM   1444 HD22 LEU    87      -4.462   3.285  -0.184  1.00  1.00          
ATOM   1445 HD23 LEU    87      -6.051   2.566  -0.418  1.00  1.00          
ATOM   1446  C   LEU    87      -5.175   7.851   0.674  1.00  1.00          
ATOM   1447  O   LEU    87      -4.291   8.640   0.276  1.00  1.00          
ATOM   1448  N   LYS    88      -5.529   7.665   1.963  1.00  1.00          
ATOM   1449  HN  LYS    88      -6.253   7.036   2.148  1.00  1.00          
ATOM   1450  HA  LYS    88      -4.275   9.146   2.707  1.00  1.00          
ATOM   1451  CB  LYS    88      -5.962   8.982   4.017  1.00  1.00          
ATOM   1452  HB1 LYS    88      -5.562   9.062   5.017  1.00  1.00          
ATOM   1453  HB2 LYS    88      -6.824   8.332   4.036  1.00  1.00          
ATOM   1454  CG  LYS    88      -6.418  10.364   3.571  1.00  1.00          
ATOM   1455  HG1 LYS    88      -6.771  10.305   2.552  1.00  1.00          
ATOM   1456  HG2 LYS    88      -5.579  11.042   3.624  1.00  1.00          
ATOM   1457  CD  LYS    88      -7.543  10.896   4.457  1.00  1.00          
ATOM   1458  HD1 LYS    88      -7.194  10.910   5.482  1.00  1.00          
ATOM   1459  HD2 LYS    88      -8.391  10.233   4.375  1.00  1.00          
ATOM   1460  CE  LYS    88      -7.980  12.309   4.053  1.00  1.00          
ATOM   1461  HE1 LYS    88      -7.103  12.879   3.782  1.00  1.00          
ATOM   1462  HE2 LYS    88      -8.465  12.784   4.896  1.00  1.00          
ATOM   1463  NZ  LYS    88      -8.931  12.307   2.900  1.00  1.00          
ATOM   1464  HZ1 LYS    88      -8.916  11.381   2.426  1.00  1.00          
ATOM   1465  HZ2 LYS    88      -8.663  13.040   2.213  1.00  1.00          
ATOM   1466  HZ3 LYS    88      -9.898  12.499   3.233  1.00  1.00          
ATOM   1467  CA  LYS    88      -4.895   8.357   3.108  1.00  1.00          
ATOM   1468  C   LYS    88      -4.008   7.403   3.912  1.00  1.00          
ATOM   1469  OT1 LYS    88      -4.429   6.247   4.147  1.00  1.00          
ATOM   1470  OT2 LYS    88      -2.897   7.822   4.299  1.00  1.00          
END
