
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  126 (  976),  selected  126 , name 2z7a_D
# Molecule2: number of CA atoms  117 ( 1867),  selected  117 , name T0475.pdb
# PARAMETERS: 2z7a_D.T0475.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      N       2           -
LGA    S     7_D      S       3          1.956
LGA    P     8_D      E       4          1.965
LGA    A     9_D      I       5          2.010
LGA    L    10_D      E       6          1.893
LGA    I    11_D      L       7          2.017
LGA    A    12_D      P       8          1.200
LGA    S    13_D      V       9          1.113
LGA    Q    14_D      Q      10          1.641
LGA    S    15_D      K      11          1.080
LGA    S    16_D      Q      12          0.955
LGA    W    17_D      L      13          1.243
LGA    R    18_D      E      14          1.535
LGA    C    19_D      A      15          1.559
LGA    V    20_D      Y      16          1.438
LGA    Q    21_D      N      17          1.155
LGA    A    22_D      A      18          1.666
LGA    H    23_D      R      19          1.445
LGA    D    24_D      D      20          1.447
LGA    R    25_D      I      21          2.091
LGA    E    26_D      D      22          1.984
LGA    G    27_D      A      23          2.127
LGA    W    28_D      F      24          1.407
LGA    L    29_D      M      25          1.252
LGA    A    30_D      A      26          1.163
LGA    L    31_D      W      27          1.723
LGA    M    32_D      W      28          1.436
LGA    A    33_D      A      29          0.449
LGA    D    34_D      D      30          0.704
LGA    D    35_D      D      31          1.183
LGA    V    36_D      C      32          1.301
LGA    V    37_D      Q      33          1.722
LGA    I    38_D      Y      34          2.003
LGA    E    39_D      Y      35          2.307
LGA    D    40_D      A      36          4.067
LGA    P    41_D      F      37          3.601
LGA    I    42_D      P      38          3.276
LGA    G    43_D      -       -           -
LGA    K    44_D      -       -           -
LGA    S    45_D      -       -           -
LGA    V    46_D      -       -           -
LGA    T    47_D      -       -           -
LGA    N    48_D      -       -           -
LGA    P    49_D      -       -           -
LGA    D    50_D      -       -           -
LGA    G    51_D      A      39          5.530
LGA    S    52_D      T      40          2.285
LGA    -       -      L      41           -
LGA    G    53_D      L      42          2.814
LGA    I    54_D      A      43          2.079
LGA    K    55_D      G      44          2.165
LGA    G    56_D      N      45          1.075
LGA    K    57_D      A      46          1.762
LGA    E    58_D      A      47          1.597
LGA    A    59_D      E      48          0.907
LGA    V    60_D      I      49          1.420
LGA    G    61_D      R      50          2.729
LGA    A    62_D      V      51          1.897
LGA    F    63_D      R      52          0.450
LGA    F    64_D      H      53          2.381
LGA    D    65_D      I      54          2.656
LGA    T    66_D      E      55          1.799
LGA    H    67_D      R      56          1.706
LGA    I    68_D      F      57          2.122
LGA    A    69_D      K      58          3.034
LGA    A    70_D      E      59          3.155
LGA    N    71_D      P      60          4.350
LGA    R    72_D      D      61          2.879
LGA    L    73_D      L      62          2.166
LGA    T    74_D      Y      63          1.877
LGA    V    75_D      G      64          1.721
LGA    T    76_D      E      65          2.099
LGA    C    77_D      L      66          2.038
LGA    E    78_D      L      67          1.448
LGA    E    79_D      T      68          1.713
LGA    T    80_D      R      69          2.325
LGA    F    81_D      V      70          2.024
LGA    P    82_D      I      71          2.122
LGA    S    83_D      V      72          1.177
LGA    S    84_D      G      73          3.633
LGA    S    85_D      -       -           -
LGA    P    86_D      -       -           -
LGA    D    87_D      N      74          2.043
LGA    E    88_D      V      75          1.316
LGA    I    89_D      V      76          1.588
LGA    A    90_D      I      77          1.718
LGA    H    91_D      D      78          3.263
LGA    I    92_D      H      79          2.401
LGA    L    93_D      E      80          1.745
LGA    V    94_D      T      81          1.579
LGA    L    95_D      V      82          1.729
LGA    H    96_D      T      83          1.581
LGA    S    97_D      R      84          2.258
LGA    E    98_D      -       -           -
LGA    F    99_D      -       -           -
LGA    F   103_D      N      85          2.723
LGA    T   104_D      F      86          4.802
LGA    -       -      P      87           -
LGA    -       -      E      88           -
LGA    -       -      G      89           -
LGA    -       -      K      90           -
LGA    S   105_D      G      91          1.694
LGA    E   106_D      E      92          1.250
LGA    V   107_D      V      93          1.307
LGA    R   108_D      D      94          1.236
LGA    G   109_D      V      95          2.960
LGA    V   110_D      A      96          2.416
LGA    F   111_D      C      97          2.282
LGA    T   112_D      I      98          1.254
LGA    Y   113_D      Y      99          1.083
LGA    R   114_D      E     100          0.914
LGA    V   115_D      V     101          1.046
LGA    N   116_D      E     102          1.317
LGA    K   117_D      N     103          1.477
LGA    A   118_D      G     104          2.718
LGA    G   119_D      -       -           -
LGA    L   120_D      R     105          1.163
LGA    I   121_D      I     106          1.372
LGA    T   122_D      A     107          1.817
LGA    N   123_D      K     108          1.972
LGA    M   124_D      A     109          1.987
LGA    R   125_D      W     110          1.645
LGA    G   126_D      F     111          1.587
LGA    Y   127_D      K     112          2.066
LGA    W   128_D      I     113          1.697
LGA    N   129_D      G     114          5.350
LGA    L   130_D      -       -           -
LGA    D   131_D      -       -           -
LGA    M   132_D      E     115          1.124
LGA    M   133_D      P     116          1.100
LGA    T   134_D      R     117          2.344
LGA    F   135_D      I     118          4.624

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  126  117    5.0    111    2.17    12.61     69.951     4.893

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.286527 * X  +   0.132625 * Y  +   0.948848 * Z  + -29.934978
  Y_new =   0.175740 * X  +  -0.980844 * Y  +   0.084028 * Z  +  -4.054457
  Z_new =   0.941816 * X  +   0.142675 * Y  +  -0.304346 * Z  +  16.802174 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.703223   -0.438370  [ DEG:   154.8832    -25.1168 ]
  Theta =  -1.227993   -1.913600  [ DEG:   -70.3588   -109.6412 ]
  Phi   =   0.550175   -2.591417  [ DEG:    31.5227   -148.4773 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2z7a_D                                        
REMARK     2: T0475.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2z7a_D.T0475.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  126  117   5.0  111   2.17   12.61  69.951
REMARK  ---------------------------------------------------------- 
MOLECULE 2z7a_D
HEADER    ISOMERASE                               17-AUG-07   2Z7A              
TITLE     X-RAY CRYSTAL STRUCTURE OF RV0760C FROM MYCOBACTERIUM                 
TITLE    2 TUBERCULOSIS AT 2.10 ANGSTROM RESOLUTION                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PUTATIVE STEROID ISOMERASE;                                
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MYCOBACTERIUM TUBERCULOSIS H37RV;               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: H37RV;                                                       
SOURCE   5 ATCC: 25618;                                                         
SOURCE   6 GENE: RV0760C, MT0785;                                               
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)PLYSS;                            
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_VECTOR: PDEST15-RV0760C;                           
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: PGST-0760C                                
KEYWDS    ALPHA+BETA CONICAL BARREL, STRUCTURAL GENOMICS, TB                    
KEYWDS   2 STRUCTURAL GENOMICS CONSORTIUM, TBSGC, ISOMERASE                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.M.CHERNEY,C.R.GAREN,M.N.G.JAMES,TB STRUCTURAL GENOMICS              
AUTHOR   2 CONSORTIUM (TBSGC)                                                   
REVDAT   1   11-SEP-07 2Z7A    0                                                
JRNL        AUTH   M.M.CHERNEY,C.R.GAREN,M.N.G.JAMES                            
JRNL        TITL   CRYSTAL STRUCTURE OF MYCOBACTERIUM TUBERCULOSIS              
JRNL        TITL 2 RV0760C AT 1.50 A RESOLUTION, A STRUCTURAL HOMOLOG           
JRNL        TITL 3 OF KETOSTEROID ISOMERASE                                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.10 ANGSTROMS.                                          
DBREF  2Z7A A    1   139  UNP    P71817   P71817_MYCTU     1    139             
DBREF  2Z7A B    1   139  UNP    P71817   P71817_MYCTU     1    139             
DBREF  2Z7A C    1   139  UNP    P71817   P71817_MYCTU     1    139             
DBREF  2Z7A D    1   139  UNP    P71817   P71817_MYCTU     1    139             
SEQRES   1 A  139  MET THR GLN THR THR GLN SER PRO ALA LEU ILE ALA SER          
SEQRES   2 A  139  GLN SER SER TRP ARG CYS VAL GLN ALA HIS ASP ARG GLU          
SEQRES   3 A  139  GLY TRP LEU ALA LEU MET ALA ASP ASP VAL VAL ILE GLU          
SEQRES   4 A  139  ASP PRO ILE GLY LYS SER VAL THR ASN PRO ASP GLY SER          
SEQRES   5 A  139  GLY ILE LYS GLY LYS GLU ALA VAL GLY ALA PHE PHE ASP          
SEQRES   6 A  139  THR HIS ILE ALA ALA ASN ARG LEU THR VAL THR CYS GLU          
SEQRES   7 A  139  GLU THR PHE PRO SER SER SER PRO ASP GLU ILE ALA HIS          
SEQRES   8 A  139  ILE LEU VAL LEU HIS SER GLU PHE ASP GLY GLY PHE THR          
SEQRES   9 A  139  SER GLU VAL ARG GLY VAL PHE THR TYR ARG VAL ASN LYS          
SEQRES  10 A  139  ALA GLY LEU ILE THR ASN MET ARG GLY TYR TRP ASN LEU          
SEQRES  11 A  139  ASP MET MET THR PHE GLY ASN GLN GLU                          
SEQRES   1 B  139  MET THR GLN THR THR GLN SER PRO ALA LEU ILE ALA SER          
SEQRES   2 B  139  GLN SER SER TRP ARG CYS VAL GLN ALA HIS ASP ARG GLU          
SEQRES   3 B  139  GLY TRP LEU ALA LEU MET ALA ASP ASP VAL VAL ILE GLU          
SEQRES   4 B  139  ASP PRO ILE GLY LYS SER VAL THR ASN PRO ASP GLY SER          
SEQRES   5 B  139  GLY ILE LYS GLY LYS GLU ALA VAL GLY ALA PHE PHE ASP          
SEQRES   6 B  139  THR HIS ILE ALA ALA ASN ARG LEU THR VAL THR CYS GLU          
SEQRES   7 B  139  GLU THR PHE PRO SER SER SER PRO ASP GLU ILE ALA HIS          
SEQRES   8 B  139  ILE LEU VAL LEU HIS SER GLU PHE ASP GLY GLY PHE THR          
SEQRES   9 B  139  SER GLU VAL ARG GLY VAL PHE THR TYR ARG VAL ASN LYS          
SEQRES  10 B  139  ALA GLY LEU ILE THR ASN MET ARG GLY TYR TRP ASN LEU          
SEQRES  11 B  139  ASP MET MET THR PHE GLY ASN GLN GLU                          
SEQRES   1 C  139  MET THR GLN THR THR GLN SER PRO ALA LEU ILE ALA SER          
SEQRES   2 C  139  GLN SER SER TRP ARG CYS VAL GLN ALA HIS ASP ARG GLU          
SEQRES   3 C  139  GLY TRP LEU ALA LEU MET ALA ASP ASP VAL VAL ILE GLU          
SEQRES   4 C  139  ASP PRO ILE GLY LYS SER VAL THR ASN PRO ASP GLY SER          
SEQRES   5 C  139  GLY ILE LYS GLY LYS GLU ALA VAL GLY ALA PHE PHE ASP          
SEQRES   6 C  139  THR HIS ILE ALA ALA ASN ARG LEU THR VAL THR CYS GLU          
SEQRES   7 C  139  GLU THR PHE PRO SER SER SER PRO ASP GLU ILE ALA HIS          
SEQRES   8 C  139  ILE LEU VAL LEU HIS SER GLU PHE ASP GLY GLY PHE THR          
SEQRES   9 C  139  SER GLU VAL ARG GLY VAL PHE THR TYR ARG VAL ASN LYS          
SEQRES  10 C  139  ALA GLY LEU ILE THR ASN MET ARG GLY TYR TRP ASN LEU          
SEQRES  11 C  139  ASP MET MET THR PHE GLY ASN GLN GLU                          
SEQRES   1 D  139  MET THR GLN THR THR GLN SER PRO ALA LEU ILE ALA SER          
SEQRES   2 D  139  GLN SER SER TRP ARG CYS VAL GLN ALA HIS ASP ARG GLU          
SEQRES   3 D  139  GLY TRP LEU ALA LEU MET ALA ASP ASP VAL VAL ILE GLU          
SEQRES   4 D  139  ASP PRO ILE GLY LYS SER VAL THR ASN PRO ASP GLY SER          
SEQRES   5 D  139  GLY ILE LYS GLY LYS GLU ALA VAL GLY ALA PHE PHE ASP          
SEQRES   6 D  139  THR HIS ILE ALA ALA ASN ARG LEU THR VAL THR CYS GLU          
SEQRES   7 D  139  GLU THR PHE PRO SER SER SER PRO ASP GLU ILE ALA HIS          
SEQRES   8 D  139  ILE LEU VAL LEU HIS SER GLU PHE ASP GLY GLY PHE THR          
SEQRES   9 D  139  SER GLU VAL ARG GLY VAL PHE THR TYR ARG VAL ASN LYS          
SEQRES  10 D  139  ALA GLY LEU ILE THR ASN MET ARG GLY TYR TRP ASN LEU          
SEQRES  11 D  139  ASP MET MET THR PHE GLY ASN GLN GLU                          
HET    ACT  B 140       4                                                       
HET    ACT  B 141       4                                                       
HET    ACT  A 140       4                                                       
HET    ACT  C 140       4                                                       
HETNAM     ACT ACETATE ION                                                      
FORMUL   5  ACT    4(C2 H3 O2 1-)                                               
FORMUL   9  HOH   *332(H2 O)                                                    
CRYST1   38.968   83.239  164.691  90.00  90.00  90.00 P 21 21 21   16          
ATOM   3048  N   SER D   7      -1.252  -4.802   1.204  1.00 51.83           N  
ATOM   3049  CA  SER D   7      -0.390  -5.267   0.074  1.00 51.82           C  
ATOM   3050  C   SER D   7      -0.981  -6.481  -0.653  1.00 50.54           C  
ATOM   3051  O   SER D   7      -1.674  -7.319  -0.020  1.00 50.45           O  
ATOM   3052  CB  SER D   7       1.055  -5.567   0.567  1.00 52.84           C  
ATOM   3053  OG  SER D   7       1.181  -6.852   1.200  1.00 54.01           O  
ATOM   3054  N   PRO D   8      -0.696  -6.606  -1.970  1.00 49.39           N  
ATOM   3055  CA  PRO D   8      -1.148  -7.792  -2.769  1.00 48.74           C  
ATOM   3056  C   PRO D   8      -0.664  -9.138  -2.158  1.00 49.67           C  
ATOM   3057  O   PRO D   8      -1.430 -10.100  -2.044  1.00 47.97           O  
ATOM   3058  CB  PRO D   8      -0.536  -7.556  -4.159  1.00 47.18           C  
ATOM   3059  CG  PRO D   8      -0.095  -6.127  -4.189  1.00 46.97           C  
ATOM   3060  CD  PRO D   8       0.082  -5.643  -2.781  1.00 49.39           C  
ATOM   3061  N   ALA D   9       0.603  -9.167  -1.738  1.00 50.95           N  
ATOM   3062  CA  ALA D   9       1.191 -10.342  -1.120  1.00 51.49           C  
ATOM   3063  C   ALA D   9       0.476 -10.687   0.191  1.00 51.51           C  
ATOM   3064  O   ALA D   9       0.266 -11.869   0.468  1.00 52.30           O  
ATOM   3065  CB  ALA D   9       2.695 -10.147  -0.906  1.00 50.84           C  
ATOM   3066  N   LEU D  10       0.084  -9.677   0.973  1.00 51.59           N  
ATOM   3067  CA  LEU D  10      -0.677  -9.905   2.235  1.00 51.29           C  
ATOM   3068  C   LEU D  10      -2.072 -10.446   1.971  1.00 50.76           C  
ATOM   3069  O   LEU D  10      -2.481 -11.409   2.627  1.00 50.09           O  
ATOM   3070  CB  LEU D  10      -0.780  -8.644   3.106  1.00 50.99           C  
ATOM   3071  CG  LEU D  10      -1.462  -8.810   4.482  1.00 51.97           C  
ATOM   3072  CD1 LEU D  10      -0.825  -9.921   5.325  1.00 47.83           C  
ATOM   3073  CD2 LEU D  10      -1.508  -7.502   5.296  1.00 51.33           C  
ATOM   3074  N   ILE D  11      -2.785  -9.810   1.033  1.00 50.57           N  
ATOM   3075  CA  ILE D  11      -4.066 -10.312   0.522  1.00 51.35           C  
ATOM   3076  C   ILE D  11      -3.885 -11.787   0.153  1.00 51.58           C  
ATOM   3077  O   ILE D  11      -4.453 -12.662   0.812  1.00 53.18           O  
ATOM   3078  CB  ILE D  11      -4.628  -9.506  -0.725  1.00 50.98           C  
ATOM   3079  CG1 ILE D  11      -4.995  -8.025  -0.419  1.00 53.13           C  
ATOM   3080  CG2 ILE D  11      -5.775 -10.261  -1.400  1.00 49.61           C  
ATOM   3081  CD1 ILE D  11      -5.926  -7.756   0.797  1.00 52.39           C  
ATOM   3082  N   ALA D  12      -3.090 -12.056  -0.883  1.00 51.95           N  
ATOM   3083  CA  ALA D  12      -2.901 -13.415  -1.400  1.00 51.62           C  
ATOM   3084  C   ALA D  12      -2.532 -14.475  -0.335  1.00 51.44           C  
ATOM   3085  O   ALA D  12      -3.025 -15.600  -0.410  1.00 50.68           O  
ATOM   3086  CB  ALA D  12      -1.891 -13.427  -2.542  1.00 51.81           C  
ATOM   3087  N   SER D  13      -1.685 -14.129   0.644  1.00 51.19           N  
ATOM   3088  CA  SER D  13      -1.336 -15.123   1.666  1.00 51.45           C  
ATOM   3089  C   SER D  13      -2.554 -15.498   2.478  1.00 51.74           C  
ATOM   3090  O   SER D  13      -2.956 -16.663   2.470  1.00 53.15           O  
ATOM   3091  CB  SER D  13      -0.130 -14.758   2.547  1.00 51.18           C  
ATOM   3092  OG  SER D  13       0.133 -13.379   2.597  1.00 52.59           O  
ATOM   3093  N   GLN D  14      -3.153 -14.499   3.131  1.00 52.49           N  
ATOM   3094  CA  GLN D  14      -4.419 -14.602   3.895  1.00 51.91           C  
ATOM   3095  C   GLN D  14      -5.567 -15.319   3.182  1.00 51.86           C  
ATOM   3096  O   GLN D  14      -6.315 -16.054   3.812  1.00 51.34           O  
ATOM   3097  CB  GLN D  14      -4.881 -13.199   4.323  1.00 52.89           C  
ATOM   3098  CG  GLN D  14      -3.852 -12.447   5.157  1.00 52.54           C  
ATOM   3099  CD  GLN D  14      -4.415 -11.196   5.791  1.00 55.94           C  
ATOM   3100  OE1 GLN D  14      -4.883 -10.289   5.106  1.00 52.80           O  
ATOM   3101  NE2 GLN D  14      -4.364 -11.141   7.116  1.00 59.43           N  
ATOM   3102  N   SER D  15      -5.696 -15.095   1.872  1.00 52.88           N  
ATOM   3103  CA  SER D  15      -6.716 -15.755   1.048  1.00 53.26           C  
ATOM   3104  C   SER D  15      -6.427 -17.231   0.893  1.00 54.09           C  
ATOM   3105  O   SER D  15      -7.316 -18.076   1.076  1.00 54.32           O  
ATOM   3106  CB  SER D  15      -6.805 -15.098  -0.322  1.00 53.22           C  
ATOM   3107  OG  SER D  15      -7.321 -13.781  -0.226  1.00 55.93           O  
ATOM   3108  N   SER D  16      -5.172 -17.524   0.541  1.00 54.25           N  
ATOM   3109  CA  SER D  16      -4.641 -18.868   0.496  1.00 53.63           C  
ATOM   3110  C   SER D  16      -5.003 -19.677   1.753  1.00 53.87           C  
ATOM   3111  O   SER D  16      -5.533 -20.782   1.635  1.00 53.65           O  
ATOM   3112  CB  SER D  16      -3.118 -18.809   0.236  1.00 53.22           C  
ATOM   3113  OG  SER D  16      -2.477 -19.991   0.653  1.00 51.70           O  
ATOM   3114  N   TRP D  17      -4.748 -19.119   2.938  1.00 55.05           N  
ATOM   3115  CA  TRP D  17      -5.113 -19.757   4.223  1.00 57.48           C  
ATOM   3116  C   TRP D  17      -6.614 -20.056   4.332  1.00 58.92           C  
ATOM   3117  O   TRP D  17      -7.030 -21.096   4.886  1.00 58.93           O  
ATOM   3118  CB  TRP D  17      -4.703 -18.893   5.444  1.00 57.96           C  
ATOM   3119  CG  TRP D  17      -3.302 -18.295   5.408  1.00 59.54           C  
ATOM   3120  CD1 TRP D  17      -2.200 -18.793   4.753  1.00 59.25           C  
ATOM   3121  CD2 TRP D  17      -2.862 -17.105   6.081  1.00 61.28           C  
ATOM   3122  NE1 TRP D  17      -1.116 -17.977   4.965  1.00 61.18           N  
ATOM   3123  CE2 TRP D  17      -1.489 -16.933   5.772  1.00 62.47           C  
ATOM   3124  CE3 TRP D  17      -3.494 -16.162   6.910  1.00 62.29           C  
ATOM   3125  CZ2 TRP D  17      -0.733 -15.852   6.266  1.00 59.87           C  
ATOM   3126  CZ3 TRP D  17      -2.741 -15.081   7.401  1.00 61.43           C  
ATOM   3127  CH2 TRP D  17      -1.375 -14.939   7.076  1.00 60.73           C  
ATOM   3128  N   ARG D  18      -7.410 -19.124   3.811  1.00 58.94           N  
ATOM   3129  CA  ARG D  18      -8.862 -19.221   3.810  1.00 59.21           C  
ATOM   3130  C   ARG D  18      -9.348 -20.344   2.871  1.00 58.71           C  
ATOM   3131  O   ARG D  18     -10.085 -21.224   3.324  1.00 57.86           O  
ATOM   3132  CB  ARG D  18      -9.444 -17.857   3.436  1.00 59.25           C  
ATOM   3133  CG  ARG D  18     -10.829 -17.514   3.994  1.00 61.53           C  
ATOM   3134  CD  ARG D  18     -11.153 -16.008   3.780  1.00 59.56           C  
ATOM   3135  NE  ARG D  18     -10.488 -15.373   2.624  1.00 62.62           N  
ATOM   3136  CZ  ARG D  18     -10.855 -15.527   1.344  1.00 65.77           C  
ATOM   3137  NH1 ARG D  18     -11.882 -16.314   1.016  1.00 66.34           N  
ATOM   3138  NH2 ARG D  18     -10.184 -14.900   0.377  1.00 62.20           N  
ATOM   3139  N   CYS D  19      -8.926 -20.344   1.598  1.00 57.96           N  
ATOM   3140  CA  CYS D  19      -9.323 -21.423   0.676  1.00 58.39           C  
ATOM   3141  C   CYS D  19      -8.766 -22.778   1.093  1.00 59.56           C  
ATOM   3142  O   CYS D  19      -9.356 -23.828   0.793  1.00 59.18           O  
ATOM   3143  CB  CYS D  19      -8.885 -21.144  -0.739  1.00 58.43           C  
ATOM   3144  SG  CYS D  19      -9.415 -19.589  -1.367  1.00 60.65           S  
ATOM   3145  N   VAL D  20      -7.638 -22.747   1.807  1.00 60.30           N  
ATOM   3146  CA  VAL D  20      -7.077 -23.950   2.418  1.00 60.39           C  
ATOM   3147  C   VAL D  20      -7.934 -24.526   3.576  1.00 61.01           C  
ATOM   3148  O   VAL D  20      -8.271 -25.708   3.558  1.00 61.46           O  
ATOM   3149  CB  VAL D  20      -5.569 -23.765   2.763  1.00 59.20           C  
ATOM   3150  CG1 VAL D  20      -5.136 -24.628   3.947  1.00 59.13           C  
ATOM   3151  CG2 VAL D  20      -4.737 -24.075   1.536  1.00 59.00           C  
ATOM   3152  N   GLN D  21      -8.293 -23.714   4.566  1.00 61.80           N  
ATOM   3153  CA  GLN D  21      -9.142 -24.209   5.663  1.00 63.41           C  
ATOM   3154  C   GLN D  21     -10.574 -24.566   5.205  1.00 64.04           C  
ATOM   3155  O   GLN D  21     -11.216 -25.483   5.743  1.00 64.02           O  
ATOM   3156  CB  GLN D  21      -9.230 -23.173   6.779  1.00 63.19           C  
ATOM   3157  CG  GLN D  21      -7.940 -22.914   7.504  1.00 64.04           C  
ATOM   3158  CD  GLN D  21      -8.029 -21.710   8.410  1.00 66.39           C  
ATOM   3159  OE1 GLN D  21      -7.678 -21.782   9.592  1.00 70.13           O  
ATOM   3160  NE2 GLN D  21      -8.505 -20.594   7.868  1.00 63.44           N  
ATOM   3161  N   ALA D  22     -11.056 -23.811   4.221  1.00 64.99           N  
ATOM   3162  CA  ALA D  22     -12.418 -23.908   3.714  1.00 65.43           C  
ATOM   3163  C   ALA D  22     -12.520 -24.875   2.542  1.00 66.11           C  
ATOM   3164  O   ALA D  22     -13.598 -25.036   1.955  1.00 66.37           O  
ATOM   3165  CB  ALA D  22     -12.941 -22.519   3.328  1.00 65.25           C  
ATOM   3166  N   HIS D  23     -11.402 -25.523   2.214  1.00 66.43           N  
ATOM   3167  CA  HIS D  23     -11.374 -26.639   1.259  1.00 66.73           C  
ATOM   3168  C   HIS D  23     -11.866 -26.269  -0.145  1.00 66.69           C  
ATOM   3169  O   HIS D  23     -12.366 -27.133  -0.885  1.00 66.58           O  
ATOM   3170  CB  HIS D  23     -12.181 -27.836   1.788  1.00 67.48           C  
ATOM   3171  CG  HIS D  23     -11.530 -28.555   2.929  1.00 69.13           C  
ATOM   3172  ND1 HIS D  23     -11.387 -27.994   4.179  1.00 71.96           N  
ATOM   3173  CD2 HIS D  23     -11.005 -29.800   3.013  1.00 70.24           C  
ATOM   3174  CE1 HIS D  23     -10.789 -28.856   4.981  1.00 72.61           C  
ATOM   3175  NE2 HIS D  23     -10.548 -29.961   4.297  1.00 72.01           N  
ATOM   3176  N   ASP D  24     -11.721 -24.986  -0.500  1.00 65.88           N  
ATOM   3177  CA  ASP D  24     -12.084 -24.479  -1.825  1.00 64.95           C  
ATOM   3178  C   ASP D  24     -10.942 -24.759  -2.830  1.00 64.57           C  
ATOM   3179  O   ASP D  24     -10.058 -23.923  -3.045  1.00 64.43           O  
ATOM   3180  CB  ASP D  24     -12.467 -22.975  -1.750  1.00 64.51           C  
ATOM   3181  CG  ASP D  24     -12.991 -22.415  -3.080  1.00 64.73           C  
ATOM   3182  OD1 ASP D  24     -13.231 -23.195  -4.030  1.00 64.32           O  
ATOM   3183  OD2 ASP D  24     -13.174 -21.176  -3.175  1.00 66.70           O  
ATOM   3184  N   ARG D  25     -10.983 -25.949  -3.437  1.00 64.36           N  
ATOM   3185  CA  ARG D  25      -9.998 -26.375  -4.438  1.00 64.09           C  
ATOM   3186  C   ARG D  25      -9.849 -25.377  -5.570  1.00 64.17           C  
ATOM   3187  O   ARG D  25      -8.728 -25.010  -5.939  1.00 64.43           O  
ATOM   3188  CB  ARG D  25     -10.371 -27.740  -5.014  1.00 63.90           C  
ATOM   3189  CG  ARG D  25      -9.280 -28.378  -5.856  1.00 62.22           C  
ATOM   3190  CD  ARG D  25      -9.573 -29.867  -6.111  1.00 62.61           C  
ATOM   3191  NE  ARG D  25      -8.494 -30.536  -6.833  1.00 59.61           N  
ATOM   3192  CZ  ARG D  25      -8.039 -30.159  -8.027  1.00 62.45           C  
ATOM   3193  NH1 ARG D  25      -8.548 -29.096  -8.649  1.00 63.45           N  
ATOM   3194  NH2 ARG D  25      -7.056 -30.845  -8.600  1.00 64.37           N  
ATOM   3195  N   GLU D  26     -10.989 -24.947  -6.100  1.00 64.31           N  
ATOM   3196  CA  GLU D  26     -11.070 -24.033  -7.241  1.00 64.77           C  
ATOM   3197  C   GLU D  26     -10.582 -22.625  -6.858  1.00 62.70           C  
ATOM   3198  O   GLU D  26      -9.981 -21.914  -7.672  1.00 62.24           O  
ATOM   3199  CB  GLU D  26     -12.521 -23.972  -7.761  1.00 64.76           C  
ATOM   3200  CG  GLU D  26     -13.504 -25.002  -7.104  1.00 68.33           C  
ATOM   3201  CD  GLU D  26     -14.998 -24.667  -7.344  1.00 68.31           C  
ATOM   3202  OE1 GLU D  26     -15.333 -24.227  -8.477  1.00 69.94           O  
ATOM   3203  OE2 GLU D  26     -15.821 -24.848  -6.403  1.00 70.08           O  
ATOM   3204  N   GLY D  27     -10.851 -22.236  -5.613  1.00 61.78           N  
ATOM   3205  CA  GLY D  27     -10.507 -20.902  -5.111  1.00 60.31           C  
ATOM   3206  C   GLY D  27      -9.017 -20.766  -4.836  1.00 59.59           C  
ATOM   3207  O   GLY D  27      -8.381 -19.784  -5.252  1.00 59.17           O  
ATOM   3208  N   TRP D  28      -8.471 -21.763  -4.145  1.00 58.03           N  
ATOM   3209  CA  TRP D  28      -7.040 -21.872  -3.913  1.00 58.24           C  
ATOM   3210  C   TRP D  28      -6.184 -21.691  -5.175  1.00 58.83           C  
ATOM   3211  O   TRP D  28      -5.236 -20.936  -5.150  1.00 59.13           O  
ATOM   3212  CB  TRP D  28      -6.730 -23.208  -3.244  1.00 56.66           C  
ATOM   3213  CG  TRP D  28      -5.397 -23.227  -2.559  1.00 56.88           C  
ATOM   3214  CD1 TRP D  28      -4.900 -22.282  -1.695  1.00 54.39           C  
ATOM   3215  CD2 TRP D  28      -4.398 -24.255  -2.651  1.00 55.80           C  
ATOM   3216  NE1 TRP D  28      -3.652 -22.654  -1.259  1.00 53.92           N  
ATOM   3217  CE2 TRP D  28      -3.318 -23.861  -1.825  1.00 55.83           C  
ATOM   3218  CE3 TRP D  28      -4.301 -25.462  -3.366  1.00 54.92           C  
ATOM   3219  CZ2 TRP D  28      -2.163 -24.641  -1.685  1.00 55.63           C  
ATOM   3220  CZ3 TRP D  28      -3.160 -26.239  -3.219  1.00 54.35           C  
ATOM   3221  CH2 TRP D  28      -2.104 -25.823  -2.389  1.00 54.95           C  
ATOM   3222  N   LEU D  29      -6.545 -22.357  -6.275  1.00 60.56           N  
ATOM   3223  CA  LEU D  29      -5.805 -22.280  -7.551  1.00 61.63           C  
ATOM   3224  C   LEU D  29      -5.957 -20.954  -8.297  1.00 62.49           C  
ATOM   3225  O   LEU D  29      -5.030 -20.529  -9.002  1.00 62.33           O  
ATOM   3226  CB  LEU D  29      -6.202 -23.424  -8.499  1.00 61.38           C  
ATOM   3227  CG  LEU D  29      -6.083 -24.878  -8.029  1.00 63.44           C  
ATOM   3228  CD1 LEU D  29      -6.385 -25.847  -9.177  1.00 65.58           C  
ATOM   3229  CD2 LEU D  29      -4.692 -25.167  -7.440  1.00 65.48           C  
ATOM   3230  N   ALA D  30      -7.124 -20.317  -8.174  1.00 62.82           N  
ATOM   3231  CA  ALA D  30      -7.353 -19.013  -8.832  1.00 62.66           C  
ATOM   3232  C   ALA D  30      -6.361 -18.012  -8.289  1.00 62.49           C  
ATOM   3233  O   ALA D  30      -5.974 -17.068  -8.994  1.00 63.06           O  
ATOM   3234  CB  ALA D  30      -8.784 -18.516  -8.623  1.00 61.94           C  
ATOM   3235  N   LEU D  31      -5.958 -18.233  -7.030  1.00 61.68           N  
ATOM   3236  CA  LEU D  31      -4.875 -17.483  -6.390  1.00 60.57           C  
ATOM   3237  C   LEU D  31      -3.498 -17.693  -7.042  1.00 59.85           C  
ATOM   3238  O   LEU D  31      -2.639 -16.805  -6.963  1.00 60.16           O  
ATOM   3239  CB  LEU D  31      -4.798 -17.827  -4.905  1.00 60.37           C  
ATOM   3240  CG  LEU D  31      -5.987 -17.430  -4.019  1.00 62.08           C  
ATOM   3241  CD1 LEU D  31      -5.981 -18.244  -2.737  1.00 61.03           C  
ATOM   3242  CD2 LEU D  31      -6.036 -15.917  -3.704  1.00 60.38           C  
ATOM   3243  N   MET D  32      -3.312 -18.839  -7.706  1.00 58.73           N  
ATOM   3244  CA  MET D  32      -2.010 -19.278  -8.187  1.00 58.39           C  
ATOM   3245  C   MET D  32      -1.711 -18.738  -9.574  1.00 59.01           C  
ATOM   3246  O   MET D  32      -2.575 -18.785 -10.469  1.00 58.20           O  
ATOM   3247  CB  MET D  32      -1.910 -20.819  -8.234  1.00 57.91           C  
ATOM   3248  CG  MET D  32      -2.021 -21.573  -6.890  1.00 58.93           C  
ATOM   3249  SD  MET D  32      -1.186 -20.785  -5.485  1.00 61.84           S  
ATOM   3250  CE  MET D  32      -1.921 -21.663  -4.099  1.00 55.66           C  
ATOM   3251  N   ALA D  33      -0.477 -18.242  -9.751  1.00 58.78           N  
ATOM   3252  CA  ALA D  33       0.102 -18.000 -11.083  1.00 57.20           C  
ATOM   3253  C   ALA D  33       0.160 -19.318 -11.858  1.00 56.71           C  
ATOM   3254  O   ALA D  33      -0.004 -20.397 -11.289  1.00 55.34           O  
ATOM   3255  CB  ALA D  33       1.488 -17.355 -10.972  1.00 56.71           C  
ATOM   3256  N   ASP D  34       0.356 -19.242 -13.168  1.00 58.22           N  
ATOM   3257  CA  ASP D  34       0.325 -20.470 -13.960  1.00 59.64           C  
ATOM   3258  C   ASP D  34       1.613 -21.316 -13.806  1.00 60.31           C  
ATOM   3259  O   ASP D  34       1.566 -22.548 -13.939  1.00 61.17           O  
ATOM   3260  CB  ASP D  34      -0.094 -20.196 -15.427  1.00 60.81           C  
ATOM   3261  CG  ASP D  34      -1.648 -20.306 -15.643  1.00 61.65           C  
ATOM   3262  OD1 ASP D  34      -2.154 -21.456 -15.797  1.00 59.19           O  
ATOM   3263  OD2 ASP D  34      -2.343 -19.253 -15.646  1.00 57.27           O  
ATOM   3264  N   ASP D  35       2.736 -20.661 -13.491  1.00 59.77           N  
ATOM   3265  CA  ASP D  35       3.985 -21.362 -13.121  1.00 59.66           C  
ATOM   3266  C   ASP D  35       4.345 -21.234 -11.606  1.00 57.49           C  
ATOM   3267  O   ASP D  35       5.485 -20.909 -11.236  1.00 58.36           O  
ATOM   3268  CB  ASP D  35       5.154 -20.927 -14.035  1.00 59.77           C  
ATOM   3269  CG  ASP D  35       5.498 -19.444 -13.908  1.00 63.41           C  
ATOM   3270  OD1 ASP D  35       4.658 -18.672 -13.403  1.00 64.14           O  
ATOM   3271  OD2 ASP D  35       6.629 -19.056 -14.301  1.00 69.06           O  
ATOM   3272  N   VAL D  36       3.354 -21.470 -10.742  1.00 53.57           N  
ATOM   3273  CA  VAL D  36       3.549 -21.451  -9.288  1.00 48.67           C  
ATOM   3274  C   VAL D  36       4.495 -22.578  -8.862  1.00 46.79           C  
ATOM   3275  O   VAL D  36       4.450 -23.692  -9.406  1.00 45.39           O  
ATOM   3276  CB  VAL D  36       2.204 -21.603  -8.518  1.00 47.78           C  
ATOM   3277  CG1 VAL D  36       1.610 -22.968  -8.767  1.00 47.36           C  
ATOM   3278  CG2 VAL D  36       2.397 -21.363  -7.003  1.00 44.27           C  
ATOM   3279  N   VAL D  37       5.384 -22.278  -7.917  1.00 44.69           N  
ATOM   3280  CA  VAL D  37       6.154 -23.348  -7.273  1.00 44.04           C  
ATOM   3281  C   VAL D  37       5.823 -23.337  -5.780  1.00 42.94           C  
ATOM   3282  O   VAL D  37       6.042 -22.341  -5.083  1.00 43.93           O  
ATOM   3283  CB  VAL D  37       7.721 -23.291  -7.575  1.00 43.50           C  
ATOM   3284  CG1 VAL D  37       8.443 -24.463  -6.911  1.00 43.24           C  
ATOM   3285  CG2 VAL D  37       7.998 -23.307  -9.077  1.00 42.96           C  
ATOM   3286  N   ILE D  38       5.285 -24.440  -5.287  1.00 42.20           N  
ATOM   3287  CA  ILE D  38       5.118 -24.563  -3.846  1.00 41.66           C  
ATOM   3288  C   ILE D  38       6.207 -25.446  -3.237  1.00 41.43           C  
ATOM   3289  O   ILE D  38       6.413 -26.600  -3.641  1.00 41.18           O  
ATOM   3290  CB  ILE D  38       3.660 -24.996  -3.466  1.00 42.36           C  
ATOM   3291  CG1 ILE D  38       2.699 -23.851  -3.804  0.50 42.22           C  
ATOM   3292  CG2 ILE D  38       3.566 -25.400  -1.967  1.00 37.77           C  
ATOM   3293  CD1 ILE D  38       1.267 -24.244  -3.988  1.00 47.58           C  
ATOM   3294  N   GLU D  39       6.914 -24.891  -2.260  1.00 40.87           N  
ATOM   3295  CA  GLU D  39       7.913 -25.659  -1.531  1.00 40.10           C  
ATOM   3296  C   GLU D  39       7.560 -25.571  -0.091  1.00 40.05           C  
ATOM   3297  O   GLU D  39       8.074 -24.703   0.626  1.00 39.13           O  
ATOM   3298  CB  GLU D  39       9.318 -25.116  -1.732  1.00 38.26           C  
ATOM   3299  CG  GLU D  39       9.722 -25.137  -3.147  1.00 40.93           C  
ATOM   3300  CD  GLU D  39      10.947 -24.325  -3.360  1.00 43.66           C  
ATOM   3301  OE1 GLU D  39      10.805 -23.261  -3.998  1.00 36.76           O  
ATOM   3302  OE2 GLU D  39      12.043 -24.738  -2.858  1.00 41.65           O  
ATOM   3303  N   ASP D  40       6.696 -26.495   0.325  1.00 39.91           N  
ATOM   3304  CA  ASP D  40       6.133 -26.500   1.666  1.00 39.85           C  
ATOM   3305  C   ASP D  40       6.292 -27.914   2.299  1.00 39.63           C  
ATOM   3306  O   ASP D  40       5.399 -28.765   2.182  1.00 39.77           O  
ATOM   3307  CB  ASP D  40       4.675 -26.026   1.573  1.00 40.99           C  
ATOM   3308  CG  ASP D  40       3.955 -26.004   2.913  1.00 44.59           C  
ATOM   3309  OD1 ASP D  40       4.618 -25.895   3.978  1.00 43.95           O  
ATOM   3310  OD2 ASP D  40       2.693 -26.062   2.878  1.00 48.33           O  
ATOM   3311  N   PRO D  41       7.466 -28.170   2.939  1.00 38.18           N  
ATOM   3312  CA  PRO D  41       8.525 -27.153   3.139  1.00 35.61           C  
ATOM   3313  C   PRO D  41       9.563 -27.097   1.984  1.00 34.45           C  
ATOM   3314  O   PRO D  41       9.471 -27.828   1.002  1.00 35.57           O  
ATOM   3315  CB  PRO D  41       9.204 -27.626   4.417  1.00 33.59           C  
ATOM   3316  CG  PRO D  41       9.127 -29.146   4.320  1.00 34.65           C  
ATOM   3317  CD  PRO D  41       7.911 -29.489   3.435  1.00 37.41           C  
ATOM   3318  N   ILE D  42      10.533 -26.208   2.112  1.00 34.31           N  
ATOM   3319  CA  ILE D  42      11.753 -26.265   1.302  1.00 33.60           C  
ATOM   3320  C   ILE D  42      12.568 -27.522   1.642  1.00 31.26           C  
ATOM   3321  O   ILE D  42      12.817 -27.788   2.796  1.00 32.43           O  
ATOM   3322  CB  ILE D  42      12.605 -24.988   1.521  1.00 32.10           C  
ATOM   3323  CG1 ILE D  42      11.794 -23.745   1.149  1.00 31.76           C  
ATOM   3324  CG2 ILE D  42      13.961 -25.057   0.772  1.00 30.03           C  
ATOM   3325  CD1 ILE D  42      12.303 -22.489   1.905  1.00 27.56           C  
ATOM   3326  N   GLY D  43      12.980 -28.278   0.631  1.00 32.54           N  
ATOM   3327  CA  GLY D  43      13.787 -29.486   0.830  1.00 35.05           C  
ATOM   3328  C   GLY D  43      12.916 -30.728   0.770  1.00 36.98           C  
ATOM   3329  O   GLY D  43      11.683 -30.619   0.681  1.00 35.10           O  
ATOM   3330  N   LYS D  44      13.532 -31.912   0.868  1.00 37.90           N  
ATOM   3331  CA  LYS D  44      12.755 -33.146   0.709  1.00 40.20           C  
ATOM   3332  C   LYS D  44      12.000 -33.468   1.968  1.00 38.35           C  
ATOM   3333  O   LYS D  44      12.589 -33.540   3.045  1.00 38.73           O  
ATOM   3334  CB  LYS D  44      13.640 -34.329   0.310  1.00 41.28           C  
ATOM   3335  CG  LYS D  44      13.757 -34.551  -1.200  1.00 44.80           C  
ATOM   3336  CD  LYS D  44      14.722 -35.699  -1.523  1.00 45.41           C  
ATOM   3337  CE  LYS D  44      16.194 -35.296  -1.272  1.00 52.30           C  
ATOM   3338  NZ  LYS D  44      16.768 -34.570  -2.451  1.00 54.64           N  
ATOM   3339  N   SER D  45      10.692 -33.690   1.810  1.00 39.05           N  
ATOM   3340  CA  SER D  45       9.763 -34.062   2.914  1.00 38.37           C  
ATOM   3341  C   SER D  45       8.581 -34.832   2.317  1.00 38.60           C  
ATOM   3342  O   SER D  45       8.500 -34.970   1.099  1.00 37.64           O  
ATOM   3343  CB  SER D  45       9.268 -32.795   3.633  1.00 37.31           C  
ATOM   3344  OG  SER D  45       8.858 -33.050   4.969  1.00 37.09           O  
ATOM   3345  N   VAL D  46       7.668 -35.342   3.146  1.00 38.99           N  
ATOM   3346  CA  VAL D  46       6.437 -35.978   2.619  1.00 41.26           C  
ATOM   3347  C   VAL D  46       5.769 -35.076   1.549  1.00 43.36           C  
ATOM   3348  O   VAL D  46       5.369 -35.568   0.470  1.00 44.58           O  
ATOM   3349  CB  VAL D  46       5.382 -36.303   3.741  1.00 41.46           C  
ATOM   3350  CG1 VAL D  46       4.215 -37.152   3.177  1.00 44.00           C  
ATOM   3351  CG2 VAL D  46       6.022 -37.015   4.943  1.00 44.45           C  
ATOM   3352  N   THR D  47       5.675 -33.766   1.867  1.00 44.66           N  
ATOM   3353  CA  THR D  47       4.953 -32.746   1.069  1.00 43.70           C  
ATOM   3354  C   THR D  47       5.792 -32.084  -0.037  1.00 43.98           C  
ATOM   3355  O   THR D  47       5.282 -31.275  -0.853  1.00 43.02           O  
ATOM   3356  CB  THR D  47       4.320 -31.680   1.974  1.00 44.33           C  
ATOM   3357  OG1 THR D  47       5.280 -31.199   2.910  1.00 42.17           O  
ATOM   3358  CG2 THR D  47       3.131 -32.271   2.748  1.00 44.23           C  
ATOM   3359  N   ASN D  48       7.074 -32.434  -0.071  1.00 43.00           N  
ATOM   3360  CA  ASN D  48       7.967 -32.025  -1.173  1.00 44.62           C  
ATOM   3361  C   ASN D  48       8.871 -33.223  -1.497  1.00 44.83           C  
ATOM   3362  O   ASN D  48       9.998 -33.280  -1.024  1.00 44.86           O  
ATOM   3363  CB  ASN D  48       8.788 -30.768  -0.781  1.00 40.97           C  
ATOM   3364  CG  ASN D  48       9.581 -30.169  -1.964  1.00 42.93           C  
ATOM   3365  OD1 ASN D  48       9.451 -30.587  -3.131  1.00 37.48           O  
ATOM   3366  ND2 ASN D  48      10.388 -29.156  -1.661  1.00 40.02           N  
ATOM   3367  N   PRO D  49       8.339 -34.220  -2.231  1.00 46.19           N  
ATOM   3368  CA  PRO D  49       9.038 -35.501  -2.414  1.00 46.66           C  
ATOM   3369  C   PRO D  49      10.404 -35.440  -3.082  1.00 48.13           C  
ATOM   3370  O   PRO D  49      11.300 -36.192  -2.679  1.00 48.91           O  
ATOM   3371  CB  PRO D  49       8.070 -36.304  -3.276  1.00 46.43           C  
ATOM   3372  CG  PRO D  49       6.721 -35.714  -2.961  1.00 46.33           C  
ATOM   3373  CD  PRO D  49       7.000 -34.244  -2.857  1.00 46.19           C  
ATOM   3374  N   ASP D  50      10.576 -34.584  -4.091  1.00 49.31           N  
ATOM   3375  CA  ASP D  50      11.897 -34.433  -4.768  1.00 51.02           C  
ATOM   3376  C   ASP D  50      12.766 -33.241  -4.267  1.00 50.10           C  
ATOM   3377  O   ASP D  50      13.851 -32.968  -4.813  1.00 51.25           O  
ATOM   3378  CB  ASP D  50      11.704 -34.334  -6.290  1.00 52.00           C  
ATOM   3379  CG  ASP D  50      10.684 -33.269  -6.670  1.00 59.53           C  
ATOM   3380  OD1 ASP D  50      10.833 -32.116  -6.200  1.00 64.21           O  
ATOM   3381  OD2 ASP D  50       9.712 -33.582  -7.406  1.00 64.54           O  
ATOM   3382  N   GLY D  51      12.276 -32.525  -3.259  1.00 48.15           N  
ATOM   3383  CA  GLY D  51      12.920 -31.318  -2.755  1.00 46.24           C  
ATOM   3384  C   GLY D  51      12.914 -30.128  -3.698  1.00 45.77           C  
ATOM   3385  O   GLY D  51      13.466 -29.086  -3.377  1.00 43.71           O  
ATOM   3386  N   SER D  52      12.325 -30.270  -4.882  1.00 45.66           N  
ATOM   3387  CA  SER D  52      12.354 -29.149  -5.802  1.00 47.98           C  
ATOM   3388  C   SER D  52      11.043 -28.319  -5.870  1.00 48.29           C  
ATOM   3389  O   SER D  52      10.948 -27.370  -6.661  1.00 47.94           O  
ATOM   3390  CB  SER D  52      12.836 -29.617  -7.173  1.00 48.18           C  
ATOM   3391  OG  SER D  52      11.874 -30.484  -7.774  1.00 53.57           O  
ATOM   3392  N   GLY D  53      10.055 -28.678  -5.034  1.00 48.46           N  
ATOM   3393  CA  GLY D  53       8.753 -28.015  -5.018  1.00 49.12           C  
ATOM   3394  C   GLY D  53       7.649 -28.643  -5.877  1.00 50.81           C  
ATOM   3395  O   GLY D  53       7.889 -29.581  -6.644  1.00 50.03           O  
ATOM   3396  N   ILE D  54       6.431 -28.111  -5.754  1.00 52.58           N  
ATOM   3397  CA  ILE D  54       5.294 -28.545  -6.601  1.00 53.92           C  
ATOM   3398  C   ILE D  54       5.098 -27.513  -7.723  1.00 54.58           C  
ATOM   3399  O   ILE D  54       4.871 -26.343  -7.444  1.00 54.13           O  
ATOM   3400  CB  ILE D  54       3.987 -28.780  -5.761  1.00 54.13           C  
ATOM   3401  CG1 ILE D  54       4.234 -29.647  -4.505  1.00 52.79           C  
ATOM   3402  CG2 ILE D  54       2.913 -29.410  -6.607  1.00 53.64           C  
ATOM   3403  CD1 ILE D  54       4.725 -31.106  -4.785  1.00 53.90           C  
ATOM   3404  N   LYS D  55       5.219 -27.948  -8.978  1.00 56.45           N  
ATOM   3405  CA  LYS D  55       5.311 -27.026 -10.138  1.00 58.27           C  
ATOM   3406  C   LYS D  55       4.066 -26.946 -11.070  1.00 59.42           C  
ATOM   3407  O   LYS D  55       3.695 -27.930 -11.734  1.00 57.67           O  
ATOM   3408  CB  LYS D  55       6.563 -27.344 -10.985  1.00 59.12           C  
ATOM   3409  CG  LYS D  55       7.858 -27.612 -10.190  1.00 58.89           C  
ATOM   3410  CD  LYS D  55       8.980 -28.172 -11.076  1.00 59.03           C  
ATOM   3411  CE  LYS D  55       9.988 -28.993 -10.278  1.00 61.89           C  
ATOM   3412  NZ  LYS D  55       9.339 -30.201  -9.655  1.00 61.24           N  
ATOM   3413  N   GLY D  56       3.464 -25.751 -11.125  1.00 60.86           N  
ATOM   3414  CA  GLY D  56       2.272 -25.468 -11.956  1.00 62.89           C  
ATOM   3415  C   GLY D  56       0.900 -25.730 -11.327  1.00 63.77           C  
ATOM   3416  O   GLY D  56       0.782 -26.555 -10.414  1.00 64.23           O  
ATOM   3417  N   LYS D  57      -0.141 -25.049 -11.840  1.00 64.67           N  
ATOM   3418  CA  LYS D  57      -1.541 -25.214 -11.365  1.00 65.61           C  
ATOM   3419  C   LYS D  57      -2.029 -26.683 -11.210  1.00 65.59           C  
ATOM   3420  O   LYS D  57      -2.763 -27.009 -10.261  1.00 65.96           O  
ATOM   3421  CB  LYS D  57      -2.526 -24.366 -12.207  1.00 65.00           C  
ATOM   3422  CG  LYS D  57      -2.829 -22.973 -11.591  1.00 66.38           C  
ATOM   3423  CD  LYS D  57      -3.575 -22.026 -12.546  1.00 66.71           C  
ATOM   3424  CE  LYS D  57      -4.578 -21.136 -11.797  1.00 70.82           C  
ATOM   3425  NZ  LYS D  57      -4.827 -19.780 -12.428  1.00 71.15           N  
ATOM   3426  N   GLU D  58      -1.600 -27.549 -12.130  1.00 65.29           N  
ATOM   3427  CA  GLU D  58      -1.951 -28.972 -12.137  1.00 64.84           C  
ATOM   3428  C   GLU D  58      -1.375 -29.775 -10.960  1.00 64.24           C  
ATOM   3429  O   GLU D  58      -2.126 -30.489 -10.268  1.00 63.70           O  
ATOM   3430  CB  GLU D  58      -1.534 -29.601 -13.474  1.00 65.79           C  
ATOM   3431  CG  GLU D  58      -1.509 -31.137 -13.477  1.00 70.84           C  
ATOM   3432  CD  GLU D  58      -2.014 -31.761 -14.777  1.00 76.95           C  
ATOM   3433  OE1 GLU D  58      -2.109 -33.015 -14.820  1.00 76.45           O  
ATOM   3434  OE2 GLU D  58      -2.324 -31.004 -15.740  1.00 79.70           O  
ATOM   3435  N   ALA D  59      -0.052 -29.676 -10.753  1.00 62.72           N  
ATOM   3436  CA  ALA D  59       0.650 -30.428  -9.693  1.00 60.78           C  
ATOM   3437  C   ALA D  59       0.206 -29.983  -8.284  1.00 59.33           C  
ATOM   3438  O   ALA D  59       0.143 -30.793  -7.339  1.00 57.64           O  
ATOM   3439  CB  ALA D  59       2.151 -30.283  -9.862  1.00 60.82           C  
ATOM   3440  N   VAL D  60      -0.093 -28.687  -8.179  1.00 58.19           N  
ATOM   3441  CA  VAL D  60      -0.641 -28.061  -6.978  1.00 58.26           C  
ATOM   3442  C   VAL D  60      -2.064 -28.567  -6.777  1.00 58.41           C  
ATOM   3443  O   VAL D  60      -2.458 -28.886  -5.650  1.00 59.01           O  
ATOM   3444  CB  VAL D  60      -0.587 -26.509  -7.072  1.00 58.20           C  
ATOM   3445  CG1 VAL D  60      -1.360 -25.854  -5.943  1.00 57.18           C  
ATOM   3446  CG2 VAL D  60       0.857 -26.025  -7.077  1.00 58.60           C  
ATOM   3447  N   GLY D  61      -2.823 -28.658  -7.875  1.00 59.10           N  
ATOM   3448  CA  GLY D  61      -4.103 -29.341  -7.875  1.00 57.99           C  
ATOM   3449  C   GLY D  61      -4.004 -30.652  -7.117  1.00 59.22           C  
ATOM   3450  O   GLY D  61      -4.697 -30.851  -6.106  1.00 58.88           O  
ATOM   3451  N   ALA D  62      -3.122 -31.535  -7.590  1.00 59.72           N  
ATOM   3452  CA  ALA D  62      -2.858 -32.847  -6.952  1.00 60.51           C  
ATOM   3453  C   ALA D  62      -2.335 -32.732  -5.514  1.00 60.26           C  
ATOM   3454  O   ALA D  62      -2.558 -33.619  -4.691  1.00 59.63           O  
ATOM   3455  CB  ALA D  62      -1.891 -33.696  -7.815  1.00 60.23           C  
ATOM   3456  N   PHE D  63      -1.639 -31.632  -5.236  1.00 60.79           N  
ATOM   3457  CA  PHE D  63      -1.177 -31.316  -3.890  1.00 61.08           C  
ATOM   3458  C   PHE D  63      -2.375 -31.140  -2.958  1.00 60.86           C  
ATOM   3459  O   PHE D  63      -2.381 -31.689  -1.841  1.00 60.58           O  
ATOM   3460  CB  PHE D  63      -0.294 -30.059  -3.911  1.00 61.04           C  
ATOM   3461  CG  PHE D  63       0.290 -29.701  -2.585  1.00 61.52           C  
ATOM   3462  CD1 PHE D  63       1.508 -30.249  -2.172  1.00 64.00           C  
ATOM   3463  CD2 PHE D  63      -0.370 -28.808  -1.737  1.00 62.01           C  
ATOM   3464  CE1 PHE D  63       2.061 -29.902  -0.909  1.00 64.44           C  
ATOM   3465  CE2 PHE D  63       0.164 -28.458  -0.482  1.00 61.81           C  
ATOM   3466  CZ  PHE D  63       1.378 -29.000  -0.066  1.00 61.91           C  
ATOM   3467  N   PHE D  64      -3.373 -30.384  -3.440  1.00 60.84           N  
ATOM   3468  CA  PHE D  64      -4.648 -30.163  -2.733  1.00 60.99           C  
ATOM   3469  C   PHE D  64      -5.316 -31.486  -2.349  1.00 60.34           C  
ATOM   3470  O   PHE D  64      -5.587 -31.738  -1.167  1.00 59.68           O  
ATOM   3471  CB  PHE D  64      -5.625 -29.292  -3.565  1.00 60.24           C  
ATOM   3472  CG  PHE D  64      -6.848 -28.826  -2.779  1.00 61.04           C  
ATOM   3473  CD1 PHE D  64      -6.864 -27.569  -2.171  1.00 60.40           C  
ATOM   3474  CD2 PHE D  64      -7.972 -29.664  -2.618  1.00 62.29           C  
ATOM   3475  CE1 PHE D  64      -7.984 -27.140  -1.430  1.00 60.03           C  
ATOM   3476  CE2 PHE D  64      -9.102 -29.247  -1.866  1.00 58.07           C  
ATOM   3477  CZ  PHE D  64      -9.104 -27.996  -1.279  1.00 58.28           C  
ATOM   3478  N   ASP D  65      -5.569 -32.319  -3.358  1.00 60.67           N  
ATOM   3479  CA  ASP D  65      -6.235 -33.613  -3.175  1.00 61.26           C  
ATOM   3480  C   ASP D  65      -5.505 -34.462  -2.126  1.00 62.20           C  
ATOM   3481  O   ASP D  65      -6.149 -35.065  -1.251  1.00 61.83           O  
ATOM   3482  CB  ASP D  65      -6.326 -34.372  -4.518  1.00 61.40           C  
ATOM   3483  CG  ASP D  65      -6.934 -33.526  -5.637  1.00 58.09           C  
ATOM   3484  OD1 ASP D  65      -7.624 -32.539  -5.311  1.00 56.46           O  
ATOM   3485  OD2 ASP D  65      -6.719 -33.844  -6.832  1.00 53.92           O  
ATOM   3486  N   THR D  66      -4.164 -34.451  -2.192  1.00 62.74           N  
ATOM   3487  CA  THR D  66      -3.330 -35.368  -1.432  1.00 63.03           C  
ATOM   3488  C   THR D  66      -3.218 -35.016   0.033  1.00 63.29           C  
ATOM   3489  O   THR D  66      -3.355 -35.915   0.883  1.00 63.77           O  
ATOM   3490  CB  THR D  66      -1.923 -35.464  -2.008  1.00 63.74           C  
ATOM   3491  OG1 THR D  66      -1.986 -35.979  -3.343  1.00 67.37           O  
ATOM   3492  CG2 THR D  66      -1.064 -36.389  -1.149  1.00 63.67           C  
ATOM   3493  N   HIS D  67      -2.968 -33.727   0.320  1.00 63.38           N  
ATOM   3494  CA  HIS D  67      -2.687 -33.237   1.698  1.00 62.78           C  
ATOM   3495  C   HIS D  67      -3.772 -32.355   2.335  1.00 63.38           C  
ATOM   3496  O   HIS D  67      -3.948 -32.389   3.551  1.00 63.39           O  
ATOM   3497  CB  HIS D  67      -1.332 -32.512   1.769  1.00 61.77           C  
ATOM   3498  CG  HIS D  67      -0.177 -33.312   1.241  1.00 59.27           C  
ATOM   3499  ND1 HIS D  67       0.216 -34.514   1.795  1.00 54.23           N  
ATOM   3500  CD2 HIS D  67       0.673 -33.078   0.210  1.00 55.45           C  
ATOM   3501  CE1 HIS D  67       1.252 -34.984   1.122  1.00 54.18           C  
ATOM   3502  NE2 HIS D  67       1.547 -34.136   0.154  1.00 48.79           N  
ATOM   3503  N   ILE D  68      -4.494 -31.572   1.530  1.00 64.83           N  
ATOM   3504  CA  ILE D  68      -5.507 -30.635   2.070  1.00 65.90           C  
ATOM   3505  C   ILE D  68      -6.934 -31.190   2.072  1.00 67.69           C  
ATOM   3506  O   ILE D  68      -7.623 -31.123   3.091  1.00 68.45           O  
ATOM   3507  CB  ILE D  68      -5.490 -29.242   1.361  1.00 65.06           C  
ATOM   3508  CG1 ILE D  68      -4.099 -28.601   1.461  1.00 64.45           C  
ATOM   3509  CG2 ILE D  68      -6.554 -28.321   1.963  1.00 62.66           C  
ATOM   3510  CD1 ILE D  68      -3.716 -27.740   0.274  1.00 60.89           C  
ATOM   3511  N   ALA D  69      -7.384 -31.720   0.937  1.00 69.03           N  
ATOM   3512  CA  ALA D  69      -8.769 -32.196   0.814  1.00 70.19           C  
ATOM   3513  C   ALA D  69      -9.082 -33.306   1.819  1.00 71.30           C  
ATOM   3514  O   ALA D  69     -10.237 -33.484   2.213  1.00 71.50           O  
ATOM   3515  CB  ALA D  69      -9.064 -32.650  -0.612  1.00 69.64           C  
ATOM   3516  N   ALA D  70      -8.048 -34.040   2.238  1.00 72.56           N  
ATOM   3517  CA  ALA D  70      -8.193 -35.079   3.257  1.00 73.72           C  
ATOM   3518  C   ALA D  70      -8.207 -34.509   4.681  1.00 74.37           C  
ATOM   3519  O   ALA D  70      -8.605 -35.206   5.627  1.00 75.43           O  
ATOM   3520  CB  ALA D  70      -7.076 -36.120   3.105  1.00 73.91           C  
ATOM   3521  N   ASN D  71      -7.823 -33.232   4.808  1.00 74.09           N  
ATOM   3522  CA  ASN D  71      -7.317 -32.632   6.059  1.00 73.29           C  
ATOM   3523  C   ASN D  71      -8.247 -31.628   6.767  1.00 73.37           C  
ATOM   3524  O   ASN D  71      -8.819 -30.754   6.131  1.00 73.89           O  
ATOM   3525  CB  ASN D  71      -5.989 -31.933   5.735  1.00 72.52           C  
ATOM   3526  CG  ASN D  71      -5.137 -31.671   6.954  1.00 71.83           C  
ATOM   3527  OD1 ASN D  71      -5.618 -31.687   8.090  1.00 68.03           O  
ATOM   3528  ND2 ASN D  71      -3.848 -31.423   6.723  1.00 70.72           N  
ATOM   3529  N   ARG D  72      -8.361 -31.736   8.088  1.00 72.92           N  
ATOM   3530  CA  ARG D  72      -9.065 -30.725   8.895  1.00 73.33           C  
ATOM   3531  C   ARG D  72      -8.055 -29.688   9.442  1.00 71.36           C  
ATOM   3532  O   ARG D  72      -7.672 -29.703  10.631  1.00 70.32           O  
ATOM   3533  CB  ARG D  72      -9.910 -31.379  10.011  1.00 73.55           C  
ATOM   3534  CG  ARG D  72     -10.936 -30.450  10.680  1.00 75.03           C  
ATOM   3535  CD  ARG D  72     -11.891 -31.228  11.588  1.00 76.25           C  
ATOM   3536  NE  ARG D  72     -13.175 -31.523  10.930  1.00 84.22           N  
ATOM   3537  CZ  ARG D  72     -14.018 -32.496  11.288  1.00 86.21           C  
ATOM   3538  NH1 ARG D  72     -13.724 -33.304  12.302  1.00 86.89           N  
ATOM   3539  NH2 ARG D  72     -15.163 -32.671  10.626  1.00 85.65           N  
ATOM   3540  N   LEU D  73      -7.660 -28.783   8.540  1.00 69.82           N  
ATOM   3541  CA  LEU D  73      -6.524 -27.875   8.730  1.00 68.06           C  
ATOM   3542  C   LEU D  73      -6.877 -26.524   9.351  1.00 66.44           C  
ATOM   3543  O   LEU D  73      -7.791 -25.841   8.896  1.00 65.30           O  
ATOM   3544  CB  LEU D  73      -5.811 -27.650   7.387  1.00 68.37           C  
ATOM   3545  CG  LEU D  73      -4.287 -27.519   7.369  1.00 68.40           C  
ATOM   3546  CD1 LEU D  73      -3.740 -27.729   5.945  1.00 69.80           C  
ATOM   3547  CD2 LEU D  73      -3.824 -26.192   7.966  1.00 71.26           C  
ATOM   3548  N   THR D  74      -6.138 -26.159  10.398  1.00 65.37           N  
ATOM   3549  CA  THR D  74      -6.182 -24.806  10.955  1.00 64.46           C  
ATOM   3550  C   THR D  74      -4.839 -24.101  10.686  1.00 63.79           C  
ATOM   3551  O   THR D  74      -3.785 -24.587  11.111  1.00 64.20           O  
ATOM   3552  CB  THR D  74      -6.469 -24.785  12.506  1.00 65.00           C  
ATOM   3553  OG1 THR D  74      -7.356 -25.852  12.870  1.00 64.56           O  
ATOM   3554  CG2 THR D  74      -7.066 -23.441  12.942  1.00 63.00           C  
ATOM   3555  N   VAL D  75      -4.887 -22.975   9.965  1.00 61.73           N  
ATOM   3556  CA  VAL D  75      -3.763 -22.053   9.863  1.00 59.22           C  
ATOM   3557  C   VAL D  75      -3.902 -21.017  10.976  1.00 58.39           C  
ATOM   3558  O   VAL D  75      -4.952 -20.386  11.109  1.00 58.88           O  
ATOM   3559  CB  VAL D  75      -3.763 -21.278   8.513  1.00 59.75           C  
ATOM   3560  CG1 VAL D  75      -2.416 -20.648   8.275  1.00 57.94           C  
ATOM   3561  CG2 VAL D  75      -4.150 -22.180   7.342  1.00 59.10           C  
ATOM   3562  N   THR D  76      -2.863 -20.819  11.775  1.00 56.53           N  
ATOM   3563  CA  THR D  76      -2.855 -19.689  12.702  1.00 55.61           C  
ATOM   3564  C   THR D  76      -1.710 -18.758  12.327  1.00 55.13           C  
ATOM   3565  O   THR D  76      -0.542 -19.104  12.542  1.00 54.59           O  
ATOM   3566  CB  THR D  76      -2.700 -20.149  14.184  1.00 56.26           C  
ATOM   3567  OG1 THR D  76      -3.780 -21.028  14.525  1.00 60.07           O  
ATOM   3568  CG2 THR D  76      -2.697 -18.967  15.166  1.00 54.03           C  
ATOM   3569  N   CYS D  77      -2.028 -17.586  11.769  1.00 53.55           N  
ATOM   3570  CA  CYS D  77      -1.003 -16.543  11.589  1.00 52.10           C  
ATOM   3571  C   CYS D  77      -0.581 -15.887  12.904  1.00 51.36           C  
ATOM   3572  O   CYS D  77      -1.295 -15.023  13.436  1.00 51.37           O  
ATOM   3573  CB  CYS D  77      -1.427 -15.447  10.614  1.00 51.93           C  
ATOM   3574  SG  CYS D  77      -0.206 -14.087  10.591  1.00 52.36           S  
ATOM   3575  N   GLU D  78       0.590 -16.274  13.403  1.00 49.60           N  
ATOM   3576  CA  GLU D  78       1.128 -15.685  14.620  1.00 48.10           C  
ATOM   3577  C   GLU D  78       1.782 -14.309  14.438  1.00 47.81           C  
ATOM   3578  O   GLU D  78       1.773 -13.506  15.376  1.00 47.71           O  
ATOM   3579  CB  GLU D  78       2.103 -16.644  15.270  1.00 48.10           C  
ATOM   3580  CG  GLU D  78       2.969 -16.025  16.321  1.00 46.64           C  
ATOM   3581  CD  GLU D  78       4.044 -16.966  16.770  1.00 50.91           C  
ATOM   3582  OE1 GLU D  78       3.770 -18.191  16.833  1.00 49.65           O  
ATOM   3583  OE2 GLU D  78       5.153 -16.469  17.066  1.00 52.12           O  
ATOM   3584  N   GLU D  79       2.382 -14.041  13.268  1.00 46.40           N  
ATOM   3585  CA  GLU D  79       3.034 -12.722  13.034  1.00 44.02           C  
ATOM   3586  C   GLU D  79       3.329 -12.505  11.595  1.00 43.05           C  
ATOM   3587  O   GLU D  79       3.558 -13.457  10.862  1.00 43.73           O  
ATOM   3588  CB  GLU D  79       4.315 -12.530  13.851  1.00 42.54           C  
ATOM   3589  CG  GLU D  79       4.943 -11.117  13.750  1.00 45.86           C  
ATOM   3590  CD  GLU D  79       5.982 -10.848  14.838  1.00 45.09           C  
ATOM   3591  OE1 GLU D  79       6.453 -11.839  15.435  1.00 46.73           O  
ATOM   3592  OE2 GLU D  79       6.323  -9.655  15.105  1.00 46.54           O  
ATOM   3593  N   THR D  80       3.321 -11.243  11.184  1.00 41.44           N  
ATOM   3594  CA  THR D  80       3.619 -10.894   9.816  1.00 40.74           C  
ATOM   3595  C   THR D  80       4.876 -10.013   9.791  1.00 40.99           C  
ATOM   3596  O   THR D  80       5.141  -9.202  10.713  1.00 39.75           O  
ATOM   3597  CB  THR D  80       2.371 -10.256   9.104  1.00 41.14           C  
ATOM   3598  OG1 THR D  80       1.337 -11.248   9.009  1.00 44.22           O  
ATOM   3599  CG2 THR D  80       2.678  -9.784   7.699  1.00 39.67           C  
ATOM   3600  N   PHE D  81       5.658 -10.237   8.736  1.00 40.87           N  
ATOM   3601  CA  PHE D  81       6.883  -9.496   8.403  1.00 38.88           C  
ATOM   3602  C   PHE D  81       6.811  -9.053   6.949  1.00 39.93           C  
ATOM   3603  O   PHE D  81       7.056  -9.827   6.021  1.00 39.24           O  
ATOM   3604  CB  PHE D  81       8.095 -10.359   8.651  1.00 37.98           C  
ATOM   3605  CG  PHE D  81       8.335 -10.631  10.092  1.00 33.35           C  
ATOM   3606  CD1 PHE D  81       9.128  -9.792  10.824  1.00 27.04           C  
ATOM   3607  CD2 PHE D  81       7.768 -11.718  10.707  1.00 33.70           C  
ATOM   3608  CE1 PHE D  81       9.361 -10.013  12.156  1.00 33.89           C  
ATOM   3609  CE2 PHE D  81       8.029 -11.975  12.064  1.00 35.22           C  
ATOM   3610  CZ  PHE D  81       8.822 -11.119  12.782  1.00 33.77           C  
ATOM   3611  N   PRO D  82       6.405  -7.793   6.751  1.00 40.50           N  
ATOM   3612  CA  PRO D  82       6.353  -7.161   5.434  1.00 39.78           C  
ATOM   3613  C   PRO D  82       7.784  -6.947   4.955  1.00 37.33           C  
ATOM   3614  O   PRO D  82       8.684  -6.748   5.782  1.00 35.37           O  
ATOM   3615  CB  PRO D  82       5.691  -5.785   5.725  1.00 40.48           C  
ATOM   3616  CG  PRO D  82       5.086  -5.912   7.117  1.00 42.83           C  
ATOM   3617  CD  PRO D  82       5.971  -6.886   7.837  1.00 41.64           C  
ATOM   3618  N   SER D  83       8.003  -6.995   3.655  1.00 35.71           N  
ATOM   3619  CA  SER D  83       9.264  -6.502   3.103  1.00 37.33           C  
ATOM   3620  C   SER D  83       9.092  -5.005   2.665  1.00 39.84           C  
ATOM   3621  O   SER D  83       8.189  -4.314   3.167  1.00 39.66           O  
ATOM   3622  CB  SER D  83       9.732  -7.381   1.928  1.00 36.81           C  
ATOM   3623  OG  SER D  83       8.927  -7.180   0.769  1.00 28.92           O  
ATOM   3624  N   SER D  84       9.961  -4.538   1.761  1.00 40.44           N  
ATOM   3625  CA  SER D  84       9.837  -3.246   1.070  1.00 40.14           C  
ATOM   3626  C   SER D  84       9.340  -3.461  -0.372  1.00 41.82           C  
ATOM   3627  O   SER D  84       9.290  -2.521  -1.174  1.00 42.78           O  
ATOM   3628  CB  SER D  84      11.163  -2.514   1.067  1.00 37.25           C  
ATOM   3629  OG  SER D  84      11.668  -2.405   2.393  1.00 38.37           O  
ATOM   3630  N   SER D  85       8.981  -4.701  -0.700  1.00 42.09           N  
ATOM   3631  CA  SER D  85       8.186  -4.943  -1.880  1.00 43.96           C  
ATOM   3632  C   SER D  85       6.744  -5.236  -1.424  1.00 46.27           C  
ATOM   3633  O   SER D  85       6.543  -5.940  -0.424  1.00 45.47           O  
ATOM   3634  CB  SER D  85       8.756  -6.083  -2.715  1.00 44.12           C  
ATOM   3635  OG  SER D  85       8.102  -6.225  -3.970  1.00 44.39           O  
ATOM   3636  N   PRO D  86       5.736  -4.626  -2.105  1.00 47.44           N  
ATOM   3637  CA  PRO D  86       4.321  -4.983  -1.909  1.00 46.90           C  
ATOM   3638  C   PRO D  86       4.019  -6.429  -2.318  1.00 47.59           C  
ATOM   3639  O   PRO D  86       2.991  -6.993  -1.889  1.00 47.72           O  
ATOM   3640  CB  PRO D  86       3.590  -4.017  -2.845  1.00 47.28           C  
ATOM   3641  CG  PRO D  86       4.615  -3.614  -3.855  1.00 47.94           C  
ATOM   3642  CD  PRO D  86       5.879  -3.511  -3.067  1.00 47.56           C  
ATOM   3643  N   ASP D  87       4.944  -7.022  -3.092  1.00 46.30           N  
ATOM   3644  CA  ASP D  87       4.787  -8.340  -3.715  1.00 44.60           C  
ATOM   3645  C   ASP D  87       5.460  -9.515  -2.978  1.00 42.89           C  
ATOM   3646  O   ASP D  87       5.421 -10.657  -3.459  1.00 42.07           O  
ATOM   3647  CB  ASP D  87       5.325  -8.282  -5.149  1.00 44.98           C  
ATOM   3648  CG  ASP D  87       4.413  -7.478  -6.093  1.00 49.02           C  
ATOM   3649  OD1 ASP D  87       3.335  -7.009  -5.633  1.00 52.78           O  
ATOM   3650  OD2 ASP D  87       4.771  -7.346  -7.286  1.00 51.56           O  
ATOM   3651  N   GLU D  88       6.073  -9.239  -1.832  1.00 40.41           N  
ATOM   3652  CA  GLU D  88       6.737 -10.274  -1.055  1.00 40.27           C  
ATOM   3653  C   GLU D  88       6.568 -10.059   0.454  1.00 39.67           C  
ATOM   3654  O   GLU D  88       6.846  -8.979   0.983  1.00 37.98           O  
ATOM   3655  CB  GLU D  88       8.233 -10.375  -1.454  1.00 39.77           C  
ATOM   3656  CG  GLU D  88       8.479 -10.912  -2.899  1.00 38.90           C  
ATOM   3657  CD  GLU D  88       9.909 -11.372  -3.153  1.00 41.93           C  
ATOM   3658  OE1 GLU D  88      10.341 -12.403  -2.556  1.00 41.22           O  
ATOM   3659  OE2 GLU D  88      10.586 -10.726  -3.983  1.00 40.30           O  
ATOM   3660  N   ILE D  89       6.141 -11.124   1.124  1.00 39.27           N  
ATOM   3661  CA  ILE D  89       5.783 -11.129   2.531  1.00 38.14           C  
ATOM   3662  C   ILE D  89       6.230 -12.436   3.248  1.00 37.17           C  
ATOM   3663  O   ILE D  89       6.312 -13.507   2.648  1.00 35.71           O  
ATOM   3664  CB  ILE D  89       4.248 -10.947   2.676  1.00 38.44           C  
ATOM   3665  CG1 ILE D  89       3.893 -10.355   4.036  1.00 42.86           C  
ATOM   3666  CG2 ILE D  89       3.493 -12.267   2.473  1.00 37.75           C  
ATOM   3667  CD1 ILE D  89       2.665  -9.422   3.995  1.00 42.51           C  
ATOM   3668  N   ALA D  90       6.489 -12.332   4.544  1.00 37.11           N  
ATOM   3669  CA  ALA D  90       6.863 -13.476   5.338  1.00 37.43           C  
ATOM   3670  C   ALA D  90       5.934 -13.534   6.533  1.00 39.22           C  
ATOM   3671  O   ALA D  90       5.492 -12.500   6.995  1.00 39.07           O  
ATOM   3672  CB  ALA D  90       8.293 -13.334   5.791  1.00 36.02           C  
ATOM   3673  N   HIS D  91       5.651 -14.732   7.041  1.00 39.94           N  
ATOM   3674  CA  HIS D  91       4.860 -14.891   8.258  1.00 39.97           C  
ATOM   3675  C   HIS D  91       5.414 -16.015   9.120  1.00 41.76           C  
ATOM   3676  O   HIS D  91       6.062 -16.942   8.611  1.00 42.79           O  
ATOM   3677  CB  HIS D  91       3.420 -15.326   7.936  1.00 40.34           C  
ATOM   3678  CG  HIS D  91       2.751 -14.520   6.877  1.00 38.38           C  
ATOM   3679  ND1 HIS D  91       2.046 -13.371   7.155  1.00 41.53           N  
ATOM   3680  CD2 HIS D  91       2.669 -14.703   5.537  1.00 40.85           C  
ATOM   3681  CE1 HIS D  91       1.567 -12.869   6.028  1.00 45.66           C  
ATOM   3682  NE2 HIS D  91       1.920 -13.664   5.031  1.00 41.42           N  
ATOM   3683  N   ILE D  92       5.133 -15.950  10.418  1.00 40.70           N  
ATOM   3684  CA  ILE D  92       5.174 -17.142  11.251  1.00 41.29           C  
ATOM   3685  C   ILE D  92       3.717 -17.681  11.286  1.00 41.39           C  
ATOM   3686  O   ILE D  92       2.763 -16.928  11.563  1.00 40.63           O  
ATOM   3687  CB  ILE D  92       5.736 -16.816  12.618  1.00 40.56           C  
ATOM   3688  CG1 ILE D  92       7.002 -15.961  12.458  1.00 44.84           C  
ATOM   3689  CG2 ILE D  92       6.036 -18.094  13.431  1.00 45.18           C  
ATOM   3690  CD1 ILE D  92       7.338 -15.165  13.677  1.00 51.97           C  
ATOM   3691  N   LEU D  93       3.562 -18.956  10.917  1.00 40.63           N  
ATOM   3692  CA  LEU D  93       2.307 -19.706  10.949  1.00 40.14           C  
ATOM   3693  C   LEU D  93       2.426 -20.963  11.843  1.00 43.05           C  
ATOM   3694  O   LEU D  93       3.481 -21.608  11.937  1.00 42.11           O  
ATOM   3695  CB  LEU D  93       1.871 -20.126   9.526  1.00 39.71           C  
ATOM   3696  CG  LEU D  93       1.884 -19.026   8.449  1.00 39.76           C  
ATOM   3697  CD1 LEU D  93       1.412 -19.489   7.099  1.00 38.10           C  
ATOM   3698  CD2 LEU D  93       1.037 -17.817   8.862  1.00 43.20           C  
ATOM   3699  N   VAL D  94       1.331 -21.300  12.515  1.00 44.59           N  
ATOM   3700  CA  VAL D  94       1.200 -22.611  13.129  1.00 45.03           C  
ATOM   3701  C   VAL D  94       0.247 -23.401  12.246  1.00 45.84           C  
ATOM   3702  O   VAL D  94      -0.847 -22.948  11.963  1.00 46.11           O  
ATOM   3703  CB  VAL D  94       0.716 -22.514  14.561  1.00 44.60           C  
ATOM   3704  CG1 VAL D  94       0.698 -23.871  15.175  1.00 46.22           C  
ATOM   3705  CG2 VAL D  94       1.651 -21.617  15.343  1.00 41.13           C  
ATOM   3706  N   LEU D  95       0.707 -24.547  11.757  1.00 46.76           N  
ATOM   3707  CA  LEU D  95      -0.089 -25.379  10.862  1.00 48.42           C  
ATOM   3708  C   LEU D  95      -0.586 -26.581  11.641  1.00 49.58           C  
ATOM   3709  O   LEU D  95       0.213 -27.381  12.158  1.00 49.21           O  
ATOM   3710  CB  LEU D  95       0.711 -25.794   9.620  1.00 48.57           C  
ATOM   3711  CG  LEU D  95       0.501 -25.078   8.272  1.00 46.36           C  
ATOM   3712  CD1 LEU D  95       0.149 -23.597   8.402  1.00 39.37           C  
ATOM   3713  CD2 LEU D  95       1.722 -25.291   7.356  1.00 47.41           C  
ATOM   3714  N   HIS D  96      -1.912 -26.669  11.742  1.00 50.75           N  
ATOM   3715  CA  HIS D  96      -2.578 -27.669  12.560  1.00 52.22           C  
ATOM   3716  C   HIS D  96      -3.454 -28.598  11.722  1.00 53.45           C  
ATOM   3717  O   HIS D  96      -4.359 -28.154  11.021  1.00 53.16           O  
ATOM   3718  CB  HIS D  96      -3.381 -27.011  13.676  1.00 52.87           C  
ATOM   3719  CG  HIS D  96      -3.872 -27.987  14.698  1.00 55.30           C  
ATOM   3720  ND1 HIS D  96      -3.116 -28.356  15.794  1.00 53.60           N  
ATOM   3721  CD2 HIS D  96      -5.024 -28.704  14.767  1.00 55.68           C  
ATOM   3722  CE1 HIS D  96      -3.790 -29.248  16.503  1.00 57.88           C  
ATOM   3723  NE2 HIS D  96      -4.951 -29.472  15.904  1.00 58.52           N  
ATOM   3724  N   SER D  97      -3.157 -29.895  11.808  1.00 55.06           N  
ATOM   3725  CA  SER D  97      -3.684 -30.892  10.890  1.00 56.25           C  
ATOM   3726  C   SER D  97      -4.459 -31.990  11.597  1.00 58.57           C  
ATOM   3727  O   SER D  97      -4.166 -32.342  12.742  1.00 58.26           O  
ATOM   3728  CB  SER D  97      -2.547 -31.487  10.076  1.00 55.19           C  
ATOM   3729  OG  SER D  97      -2.321 -30.718   8.922  1.00 53.10           O  
ATOM   3730  N   GLU D  98      -5.463 -32.518  10.906  1.00 62.12           N  
ATOM   3731  CA  GLU D  98      -6.331 -33.573  11.445  1.00 66.01           C  
ATOM   3732  C   GLU D  98      -6.945 -34.365  10.289  1.00 66.96           C  
ATOM   3733  O   GLU D  98      -7.608 -33.798   9.417  1.00 67.76           O  
ATOM   3734  CB  GLU D  98      -7.456 -32.985  12.333  1.00 66.25           C  
ATOM   3735  CG  GLU D  98      -7.038 -32.461  13.731  1.00 67.18           C  
ATOM   3736  CD  GLU D  98      -8.199 -32.374  14.740  1.00 69.02           C  
ATOM   3737  OE1 GLU D  98      -8.129 -31.546  15.690  1.00 71.14           O  
ATOM   3738  OE2 GLU D  98      -9.182 -33.144  14.590  1.00 73.25           O  
ATOM   3739  N   PHE D  99      -6.718 -35.673  10.271  1.00 68.49           N  
ATOM   3740  CA  PHE D  99      -7.408 -36.550   9.306  1.00 70.44           C  
ATOM   3741  C   PHE D  99      -8.361 -37.502  10.060  1.00 71.01           C  
ATOM   3742  O   PHE D  99      -9.358 -37.994   9.486  1.00 71.31           O  
ATOM   3743  CB  PHE D  99      -6.411 -37.338   8.421  1.00 70.47           C  
ATOM   3744  CG  PHE D  99      -5.172 -36.558   8.046  1.00 70.37           C  
ATOM   3745  CD1 PHE D  99      -4.148 -36.346   8.985  1.00 68.36           C  
ATOM   3746  CD2 PHE D  99      -5.026 -36.038   6.753  1.00 70.40           C  
ATOM   3747  CE1 PHE D  99      -3.011 -35.611   8.650  1.00 68.98           C  
ATOM   3748  CE2 PHE D  99      -3.882 -35.309   6.399  1.00 69.85           C  
ATOM   3749  CZ  PHE D  99      -2.875 -35.098   7.347  1.00 70.47           C  
ATOM   3750  N   PHE D 103      -6.010 -38.153  15.197  1.00 64.45           N  
ATOM   3751  CA  PHE D 103      -4.562 -37.892  14.904  1.00 65.13           C  
ATOM   3752  C   PHE D 103      -4.246 -36.475  14.397  1.00 64.39           C  
ATOM   3753  O   PHE D 103      -4.512 -36.113  13.228  1.00 63.11           O  
ATOM   3754  CB  PHE D 103      -3.996 -38.915  13.914  1.00 65.46           C  
ATOM   3755  CG  PHE D 103      -2.541 -38.679  13.563  1.00 65.72           C  
ATOM   3756  CD1 PHE D 103      -1.526 -38.953  14.499  1.00 61.79           C  
ATOM   3757  CD2 PHE D 103      -2.186 -38.175  12.290  1.00 66.17           C  
ATOM   3758  CE1 PHE D 103      -0.187 -38.734  14.181  1.00 60.68           C  
ATOM   3759  CE2 PHE D 103      -0.848 -37.949  11.963  1.00 64.09           C  
ATOM   3760  CZ  PHE D 103       0.157 -38.229  12.912  1.00 61.90           C  
ATOM   3761  N   THR D 104      -3.634 -35.709  15.294  1.00 63.33           N  
ATOM   3762  CA  THR D 104      -3.234 -34.352  15.017  1.00 62.78           C  
ATOM   3763  C   THR D 104      -1.730 -34.233  14.745  1.00 61.11           C  
ATOM   3764  O   THR D 104      -0.929 -35.018  15.255  1.00 61.74           O  
ATOM   3765  CB  THR D 104      -3.687 -33.387  16.161  1.00 63.61           C  
ATOM   3766  OG1 THR D 104      -3.016 -33.692  17.404  1.00 64.59           O  
ATOM   3767  CG2 THR D 104      -5.203 -33.486  16.365  1.00 64.61           C  
ATOM   3768  N   SER D 105      -1.366 -33.278  13.897  1.00 59.10           N  
ATOM   3769  CA  SER D 105       0.013 -32.804  13.777  1.00 56.52           C  
ATOM   3770  C   SER D 105       0.009 -31.275  13.820  1.00 56.03           C  
ATOM   3771  O   SER D 105      -0.964 -30.623  13.417  1.00 56.04           O  
ATOM   3772  CB  SER D 105       0.645 -33.259  12.465  1.00 55.65           C  
ATOM   3773  OG  SER D 105       0.442 -32.292  11.456  1.00 52.98           O  
ATOM   3774  N   GLU D 106       1.108 -30.709  14.290  1.00 54.07           N  
ATOM   3775  CA  GLU D 106       1.266 -29.262  14.318  1.00 52.86           C  
ATOM   3776  C   GLU D 106       2.714 -28.881  14.041  1.00 49.49           C  
ATOM   3777  O   GLU D 106       3.634 -29.499  14.583  1.00 48.57           O  
ATOM   3778  CB  GLU D 106       0.864 -28.723  15.678  1.00 52.94           C  
ATOM   3779  CG  GLU D 106       0.510 -27.265  15.685  1.00 56.73           C  
ATOM   3780  CD  GLU D 106      -0.223 -26.888  16.956  1.00 62.19           C  
ATOM   3781  OE1 GLU D 106       0.395 -26.969  18.039  1.00 60.83           O  
ATOM   3782  OE2 GLU D 106      -1.422 -26.540  16.867  1.00 66.95           O  
ATOM   3783  N   VAL D 107       2.896 -27.871  13.195  1.00 46.98           N  
ATOM   3784  CA  VAL D 107       4.217 -27.295  12.942  1.00 45.13           C  
ATOM   3785  C   VAL D 107       4.152 -25.770  12.828  1.00 45.52           C  
ATOM   3786  O   VAL D 107       3.268 -25.212  12.174  1.00 44.69           O  
ATOM   3787  CB  VAL D 107       4.904 -27.922  11.694  1.00 44.73           C  
ATOM   3788  CG1 VAL D 107       4.156 -27.591  10.385  1.00 37.97           C  
ATOM   3789  CG2 VAL D 107       6.354 -27.513  11.645  1.00 43.02           C  
ATOM   3790  N   ARG D 108       5.085 -25.105  13.499  1.00 45.25           N  
ATOM   3791  CA  ARG D 108       5.204 -23.659  13.438  1.00 43.70           C  
ATOM   3792  C   ARG D 108       6.455 -23.330  12.604  1.00 43.65           C  
ATOM   3793  O   ARG D 108       7.554 -23.847  12.874  1.00 43.51           O  
ATOM   3794  CB  ARG D 108       5.306 -23.108  14.865  1.00 44.07           C  
ATOM   3795  CG  ARG D 108       5.666 -21.652  14.967  1.00 43.69           C  
ATOM   3796  CD  ARG D 108       5.514 -21.145  16.391  1.00 43.64           C  
ATOM   3797  NE  ARG D 108       5.962 -19.769  16.448  1.00 43.22           N  
ATOM   3798  CZ  ARG D 108       7.216 -19.412  16.679  1.00 45.67           C  
ATOM   3799  NH1 ARG D 108       8.124 -20.353  16.926  1.00 44.29           N  
ATOM   3800  NH2 ARG D 108       7.560 -18.120  16.700  1.00 41.24           N  
ATOM   3801  N   GLY D 109       6.281 -22.524  11.567  1.00 41.34           N  
ATOM   3802  CA  GLY D 109       7.431 -22.085  10.789  1.00 41.34           C  
ATOM   3803  C   GLY D 109       7.271 -20.728  10.115  1.00 40.14           C  
ATOM   3804  O   GLY D 109       6.195 -20.112  10.168  1.00 39.43           O  
ATOM   3805  N   VAL D 110       8.357 -20.266   9.487  1.00 38.77           N  
ATOM   3806  CA  VAL D 110       8.311 -19.128   8.577  1.00 35.77           C  
ATOM   3807  C   VAL D 110       7.871 -19.600   7.190  1.00 36.42           C  
ATOM   3808  O   VAL D 110       8.297 -20.665   6.675  1.00 37.17           O  
ATOM   3809  CB  VAL D 110       9.658 -18.393   8.511  1.00 36.63           C  
ATOM   3810  CG1 VAL D 110       9.659 -17.363   7.398  1.00 34.21           C  
ATOM   3811  CG2 VAL D 110       9.980 -17.739   9.873  1.00 34.90           C  
ATOM   3812  N   PHE D 111       6.990 -18.807   6.593  1.00 35.89           N  
ATOM   3813  CA  PHE D 111       6.415 -19.102   5.310  1.00 34.24           C  
ATOM   3814  C   PHE D 111       6.516 -17.801   4.573  1.00 34.71           C  
ATOM   3815  O   PHE D 111       6.261 -16.764   5.140  1.00 35.78           O  
ATOM   3816  CB  PHE D 111       4.955 -19.580   5.458  1.00 32.62           C  
ATOM   3817  CG  PHE D 111       4.808 -20.919   6.143  1.00 34.25           C  
ATOM   3818  CD1 PHE D 111       4.608 -22.085   5.393  1.00 30.78           C  
ATOM   3819  CD2 PHE D 111       4.869 -21.011   7.524  1.00 25.57           C  
ATOM   3820  CE1 PHE D 111       4.470 -23.303   6.017  1.00 30.50           C  
ATOM   3821  CE2 PHE D 111       4.737 -22.210   8.176  1.00 31.31           C  
ATOM   3822  CZ  PHE D 111       4.534 -23.386   7.433  1.00 32.32           C  
ATOM   3823  N   THR D 112       6.954 -17.852   3.323  1.00 36.79           N  
ATOM   3824  CA  THR D 112       7.160 -16.663   2.519  1.00 37.67           C  
ATOM   3825  C   THR D 112       6.327 -16.786   1.233  1.00 37.89           C  
ATOM   3826  O   THR D 112       6.067 -17.907   0.773  1.00 36.00           O  
ATOM   3827  CB  THR D 112       8.726 -16.425   2.180  1.00 39.02           C  
ATOM   3828  OG1 THR D 112       9.213 -17.412   1.249  1.00 35.10           O  
ATOM   3829  CG2 THR D 112       9.597 -16.416   3.449  1.00 36.77           C  
ATOM   3830  N   TYR D 113       5.931 -15.644   0.643  1.00 38.37           N  
ATOM   3831  CA  TYR D 113       5.065 -15.650  -0.543  1.00 38.85           C  
ATOM   3832  C   TYR D 113       5.550 -14.641  -1.522  1.00 38.98           C  
ATOM   3833  O   TYR D 113       5.975 -13.548  -1.137  1.00 40.93           O  
ATOM   3834  CB  TYR D 113       3.596 -15.308  -0.187  1.00 40.41           C  
ATOM   3835  CG  TYR D 113       2.868 -16.323   0.676  1.00 38.57           C  
ATOM   3836  CD1 TYR D 113       1.912 -17.158   0.115  1.00 38.77           C  
ATOM   3837  CD2 TYR D 113       3.155 -16.462   2.042  1.00 35.00           C  
ATOM   3838  CE1 TYR D 113       1.230 -18.094   0.877  1.00 39.10           C  
ATOM   3839  CE2 TYR D 113       2.478 -17.406   2.821  1.00 39.61           C  
ATOM   3840  CZ  TYR D 113       1.507 -18.216   2.222  1.00 43.05           C  
ATOM   3841  OH  TYR D 113       0.814 -19.168   2.943  1.00 43.72           O  
ATOM   3842  N   ARG D 114       5.485 -15.007  -2.785  1.00 39.10           N  
ATOM   3843  CA  ARG D 114       5.756 -14.087  -3.844  1.00 41.35           C  
ATOM   3844  C   ARG D 114       4.603 -14.123  -4.867  1.00 43.31           C  
ATOM   3845  O   ARG D 114       4.174 -15.190  -5.316  1.00 43.70           O  
ATOM   3846  CB  ARG D 114       7.088 -14.398  -4.522  1.00 40.30           C  
ATOM   3847  CG  ARG D 114       7.560 -13.301  -5.489  1.00 44.28           C  
ATOM   3848  CD  ARG D 114       8.541 -13.801  -6.529  1.00 45.36           C  
ATOM   3849  NE  ARG D 114       8.787 -12.779  -7.549  1.00 53.39           N  
ATOM   3850  CZ  ARG D 114       8.158 -12.700  -8.725  1.00 57.66           C  
ATOM   3851  NH1 ARG D 114       7.224 -13.582  -9.075  1.00 57.91           N  
ATOM   3852  NH2 ARG D 114       8.465 -11.726  -9.558  1.00 57.46           N  
ATOM   3853  N   VAL D 115       4.133 -12.936  -5.226  1.00 44.88           N  
ATOM   3854  CA  VAL D 115       3.077 -12.756  -6.198  1.00 45.99           C  
ATOM   3855  C   VAL D 115       3.689 -11.998  -7.359  1.00 48.75           C  
ATOM   3856  O   VAL D 115       4.570 -11.126  -7.148  1.00 48.46           O  
ATOM   3857  CB  VAL D 115       1.833 -11.993  -5.583  1.00 45.81           C  
ATOM   3858  CG1 VAL D 115       1.294 -12.738  -4.354  1.00 46.28           C  
ATOM   3859  CG2 VAL D 115       2.132 -10.530  -5.233  1.00 41.38           C  
ATOM   3860  N   ASN D 116       3.279 -12.344  -8.578  1.00 51.54           N  
ATOM   3861  CA  ASN D 116       3.671 -11.539  -9.754  1.00 55.43           C  
ATOM   3862  C   ASN D 116       2.929 -10.156  -9.789  1.00 57.91           C  
ATOM   3863  O   ASN D 116       2.331  -9.738  -8.778  1.00 58.86           O  
ATOM   3864  CB  ASN D 116       3.493 -12.343 -11.040  1.00 54.45           C  
ATOM   3865  CG  ASN D 116       2.067 -12.742 -11.276  1.00 55.78           C  
ATOM   3866  OD1 ASN D 116       1.145 -12.163 -10.695  1.00 58.85           O  
ATOM   3867  ND2 ASN D 116       1.866 -13.744 -12.123  1.00 54.86           N  
ATOM   3868  N   LYS D 117       2.974  -9.436 -10.913  1.00 60.35           N  
ATOM   3869  CA  LYS D 117       2.355  -8.088 -10.965  1.00 62.16           C  
ATOM   3870  C   LYS D 117       0.825  -8.091 -11.171  1.00 62.34           C  
ATOM   3871  O   LYS D 117       0.159  -7.085 -10.903  1.00 63.72           O  
ATOM   3872  CB  LYS D 117       3.083  -7.145 -11.935  1.00 62.23           C  
ATOM   3873  CG  LYS D 117       3.001  -7.508 -13.425  1.00 63.60           C  
ATOM   3874  CD  LYS D 117       3.623  -6.368 -14.260  1.00 64.14           C  
ATOM   3875  CE  LYS D 117       3.261  -6.430 -15.751  1.00 66.94           C  
ATOM   3876  NZ  LYS D 117       2.118  -5.534 -16.079  1.00 66.73           N  
ATOM   3877  N   ALA D 118       0.290  -9.230 -11.610  1.00 61.68           N  
ATOM   3878  CA  ALA D 118      -1.150  -9.519 -11.557  1.00 61.33           C  
ATOM   3879  C   ALA D 118      -1.701  -9.664 -10.132  1.00 60.66           C  
ATOM   3880  O   ALA D 118      -2.923  -9.623  -9.939  1.00 62.36           O  
ATOM   3881  CB  ALA D 118      -1.466 -10.791 -12.351  1.00 60.71           C  
ATOM   3882  N   GLY D 119      -0.819  -9.846  -9.148  1.00 58.83           N  
ATOM   3883  CA  GLY D 119      -1.216 -10.174  -7.780  1.00 56.44           C  
ATOM   3884  C   GLY D 119      -1.415 -11.671  -7.551  1.00 55.80           C  
ATOM   3885  O   GLY D 119      -1.915 -12.077  -6.480  1.00 55.36           O  
ATOM   3886  N   LEU D 120      -1.031 -12.489  -8.543  1.00 54.15           N  
ATOM   3887  CA  LEU D 120      -1.088 -13.968  -8.444  1.00 53.64           C  
ATOM   3888  C   LEU D 120       0.197 -14.585  -7.802  1.00 53.21           C  
ATOM   3889  O   LEU D 120       1.298 -14.043  -7.991  1.00 51.35           O  
ATOM   3890  CB  LEU D 120      -1.299 -14.597  -9.838  1.00 54.35           C  
ATOM   3891  CG  LEU D 120      -2.556 -14.357 -10.689  1.00 56.37           C  
ATOM   3892  CD1 LEU D 120      -2.204 -14.469 -12.166  1.00 61.80           C  
ATOM   3893  CD2 LEU D 120      -3.686 -15.327 -10.337  1.00 58.90           C  
ATOM   3894  N   ILE D 121       0.031 -15.716  -7.093  1.00 51.38           N  
ATOM   3895  CA  ILE D 121       1.110 -16.432  -6.356  1.00 51.05           C  
ATOM   3896  C   ILE D 121       2.077 -17.243  -7.247  1.00 49.47           C  
ATOM   3897  O   ILE D 121       1.689 -18.257  -7.847  1.00 49.73           O  
ATOM   3898  CB  ILE D 121       0.526 -17.420  -5.299  1.00 50.81           C  
ATOM   3899  CG1 ILE D 121      -0.298 -16.692  -4.237  1.00 47.71           C  
ATOM   3900  CG2 ILE D 121       1.650 -18.270  -4.626  1.00 50.70           C  
ATOM   3901  CD1 ILE D 121      -1.193 -17.636  -3.465  1.00 44.37           C  
ATOM   3902  N   THR D 122       3.331 -16.807  -7.319  1.00 47.70           N  
ATOM   3903  CA  THR D 122       4.377 -17.566  -8.044  1.00 46.31           C  
ATOM   3904  C   THR D 122       5.137 -18.544  -7.137  1.00 45.15           C  
ATOM   3905  O   THR D 122       5.532 -19.628  -7.585  1.00 44.83           O  
ATOM   3906  CB  THR D 122       5.406 -16.636  -8.636  1.00 45.37           C  
ATOM   3907  OG1 THR D 122       5.918 -15.821  -7.581  1.00 47.29           O  
ATOM   3908  CG2 THR D 122       4.768 -15.758  -9.720  1.00 45.71           C  
ATOM   3909  N   ASN D 123       5.354 -18.141  -5.877  1.00 42.85           N  
ATOM   3910  CA  ASN D 123       6.143 -18.932  -4.915  1.00 41.32           C  
ATOM   3911  C   ASN D 123       5.547 -18.906  -3.535  1.00 39.33           C  
ATOM   3912  O   ASN D 123       5.119 -17.857  -3.044  1.00 38.82           O  
ATOM   3913  CB  ASN D 123       7.612 -18.460  -4.837  1.00 39.91           C  
ATOM   3914  CG  ASN D 123       8.298 -18.434  -6.199  1.00 42.50           C  
ATOM   3915  OD1 ASN D 123       8.967 -19.399  -6.595  1.00 40.34           O  
ATOM   3916  ND2 ASN D 123       8.129 -17.325  -6.930  1.00 36.40           N  
ATOM   3917  N   MET D 124       5.539 -20.078  -2.919  1.00 36.69           N  
ATOM   3918  CA  MET D 124       5.156 -20.232  -1.549  1.00 37.74           C  
ATOM   3919  C   MET D 124       6.204 -21.137  -0.901  1.00 35.42           C  
ATOM   3920  O   MET D 124       6.401 -22.271  -1.314  1.00 34.18           O  
ATOM   3921  CB  MET D 124       3.771 -20.860  -1.446  1.00 38.74           C  
ATOM   3922  CG  MET D 124       3.035 -20.601  -0.114  1.00 47.21           C  
ATOM   3923  SD  MET D 124       3.788 -21.122   1.463  1.00 65.35           S  
ATOM   3924  CE  MET D 124       3.937 -22.883   1.190  1.00 62.68           C  
ATOM   3925  N   ARG D 125       6.855 -20.641   0.138  1.00 34.50           N  
ATOM   3926  CA  ARG D 125       8.032 -21.359   0.682  1.00 33.31           C  
ATOM   3927  C   ARG D 125       7.999 -21.470   2.176  1.00 31.45           C  
ATOM   3928  O   ARG D 125       7.837 -20.488   2.854  1.00 30.88           O  
ATOM   3929  CB  ARG D 125       9.317 -20.683   0.211  1.00 32.06           C  
ATOM   3930  CG  ARG D 125       9.347 -20.477  -1.273  1.00 28.30           C  
ATOM   3931  CD  ARG D 125      10.716 -20.034  -1.710  1.00 34.13           C  
ATOM   3932  NE  ARG D 125      11.564 -21.177  -2.075  1.00 34.11           N  
ATOM   3933  CZ  ARG D 125      12.827 -21.306  -1.695  1.00 32.11           C  
ATOM   3934  NH1 ARG D 125      13.361 -20.377  -0.904  1.00 23.59           N  
ATOM   3935  NH2 ARG D 125      13.541 -22.347  -2.090  1.00 23.03           N  
ATOM   3936  N   GLY D 126       8.129 -22.687   2.678  1.00 31.41           N  
ATOM   3937  CA  GLY D 126       8.011 -22.957   4.123  1.00 29.94           C  
ATOM   3938  C   GLY D 126       9.297 -23.420   4.774  1.00 29.91           C  
ATOM   3939  O   GLY D 126       9.937 -24.389   4.325  1.00 30.91           O  
ATOM   3940  N   TYR D 127       9.680 -22.749   5.850  1.00 30.18           N  
ATOM   3941  CA  TYR D 127      10.870 -23.137   6.564  1.00 31.01           C  
ATOM   3942  C   TYR D 127      10.423 -23.904   7.782  1.00 32.94           C  
ATOM   3943  O   TYR D 127      10.340 -23.351   8.870  1.00 33.67           O  
ATOM   3944  CB  TYR D 127      11.709 -21.933   6.984  1.00 30.55           C  
ATOM   3945  CG  TYR D 127      12.254 -21.160   5.813  1.00 32.04           C  
ATOM   3946  CD1 TYR D 127      13.586 -21.291   5.453  1.00 33.25           C  
ATOM   3947  CD2 TYR D 127      11.442 -20.290   5.065  1.00 29.23           C  
ATOM   3948  CE1 TYR D 127      14.101 -20.623   4.403  1.00 28.75           C  
ATOM   3949  CE2 TYR D 127      11.960 -19.605   3.979  1.00 29.40           C  
ATOM   3950  CZ  TYR D 127      13.313 -19.779   3.659  1.00 30.77           C  
ATOM   3951  OH  TYR D 127      13.898 -19.134   2.574  1.00 31.12           O  
ATOM   3952  N   TRP D 128      10.154 -25.197   7.580  1.00 33.60           N  
ATOM   3953  CA  TRP D 128       9.958 -26.118   8.669  1.00 33.41           C  
ATOM   3954  C   TRP D 128      10.459 -27.506   8.222  1.00 34.41           C  
ATOM   3955  O   TRP D 128      10.763 -27.731   7.033  1.00 32.64           O  
ATOM   3956  CB  TRP D 128       8.471 -26.150   9.069  1.00 35.23           C  
ATOM   3957  CG  TRP D 128       7.502 -26.518   7.935  1.00 34.42           C  
ATOM   3958  CD1 TRP D 128       6.963 -25.674   7.006  1.00 36.26           C  
ATOM   3959  CD2 TRP D 128       6.965 -27.819   7.653  1.00 35.38           C  
ATOM   3960  NE1 TRP D 128       6.144 -26.385   6.125  1.00 38.50           N  
ATOM   3961  CE2 TRP D 128       6.126 -27.698   6.512  1.00 35.15           C  
ATOM   3962  CE3 TRP D 128       7.153 -29.089   8.221  1.00 39.62           C  
ATOM   3963  CZ2 TRP D 128       5.436 -28.780   5.968  1.00 37.47           C  
ATOM   3964  CZ3 TRP D 128       6.478 -30.188   7.649  1.00 37.24           C  
ATOM   3965  CH2 TRP D 128       5.628 -30.017   6.541  1.00 36.30           C  
ATOM   3966  N   ASN D 129      10.546 -28.433   9.172  1.00 35.64           N  
ATOM   3967  CA  ASN D 129      10.787 -29.849   8.838  1.00 36.61           C  
ATOM   3968  C   ASN D 129      10.032 -30.778   9.783  1.00 38.43           C  
ATOM   3969  O   ASN D 129       9.569 -30.331  10.818  1.00 38.03           O  
ATOM   3970  CB  ASN D 129      12.301 -30.150   8.734  1.00 35.52           C  
ATOM   3971  CG  ASN D 129      13.057 -29.818  10.010  1.00 31.48           C  
ATOM   3972  OD1 ASN D 129      12.589 -30.107  11.068  1.00 36.73           O  
ATOM   3973  ND2 ASN D 129      14.202 -29.188   9.896  1.00 28.71           N  
ATOM   3974  N   LEU D 130       9.880 -32.066   9.431  1.00 41.54           N  
ATOM   3975  CA  LEU D 130       9.161 -33.036  10.319  1.00 42.43           C  
ATOM   3976  C   LEU D 130       9.753 -33.153  11.729  1.00 43.38           C  
ATOM   3977  O   LEU D 130       9.046 -33.511  12.672  1.00 44.16           O  
ATOM   3978  CB  LEU D 130       9.002 -34.408   9.674  1.00 42.35           C  
ATOM   3979  CG  LEU D 130       8.290 -34.389   8.307  1.00 43.56           C  
ATOM   3980  CD1 LEU D 130       8.799 -35.538   7.437  1.00 48.46           C  
ATOM   3981  CD2 LEU D 130       6.753 -34.369   8.394  1.00 43.36           C  
ATOM   3982  N   ASP D 131      11.026 -32.807  11.887  1.00 43.51           N  
ATOM   3983  CA  ASP D 131      11.635 -32.705  13.220  1.00 44.80           C  
ATOM   3984  C   ASP D 131      11.055 -31.634  14.155  1.00 44.39           C  
ATOM   3985  O   ASP D 131      11.146 -31.744  15.384  1.00 43.47           O  
ATOM   3986  CB  ASP D 131      13.128 -32.437  13.068  1.00 45.39           C  
ATOM   3987  CG  ASP D 131      13.932 -33.695  12.935  1.00 48.08           C  
ATOM   3988  OD1 ASP D 131      13.387 -34.820  13.095  1.00 46.03           O  
ATOM   3989  OD2 ASP D 131      15.142 -33.534  12.688  1.00 51.74           O  
ATOM   3990  N   MET D 132      10.485 -30.592  13.566  1.00 45.66           N  
ATOM   3991  CA  MET D 132       9.891 -29.469  14.303  1.00 46.74           C  
ATOM   3992  C   MET D 132       8.419 -29.703  14.632  1.00 48.08           C  
ATOM   3993  O   MET D 132       7.781 -28.924  15.356  1.00 47.07           O  
ATOM   3994  CB  MET D 132      10.000 -28.207  13.445  1.00 46.44           C  
ATOM   3995  CG  MET D 132      11.433 -27.665  13.349  1.00 47.27           C  
ATOM   3996  SD  MET D 132      11.636 -26.714  11.856  1.00 45.02           S  
ATOM   3997  CE  MET D 132      10.590 -25.285  12.244  1.00 44.61           C  
ATOM   3998  N   MET D 133       7.885 -30.764  14.042  1.00 49.93           N  
ATOM   3999  CA  MET D 133       6.474 -31.057  14.089  1.00 52.48           C  
ATOM   4000  C   MET D 133       6.192 -31.886  15.337  1.00 53.11           C  
ATOM   4001  O   MET D 133       6.996 -32.740  15.746  1.00 51.55           O  
ATOM   4002  CB  MET D 133       6.066 -31.778  12.797  1.00 51.68           C  
ATOM   4003  CG  MET D 133       4.608 -32.122  12.706  1.00 55.05           C  
ATOM   4004  SD  MET D 133       4.118 -32.731  11.084  1.00 56.28           S  
ATOM   4005  CE  MET D 133       3.997 -31.224  10.111  1.00 55.17           C  
ATOM   4006  N   THR D 134       5.060 -31.582  15.966  1.00 55.46           N  
ATOM   4007  CA  THR D 134       4.554 -32.346  17.102  1.00 57.00           C  
ATOM   4008  C   THR D 134       3.279 -33.079  16.690  1.00 58.27           C  
ATOM   4009  O   THR D 134       2.592 -32.692  15.729  1.00 58.15           O  
ATOM   4010  CB  THR D 134       4.268 -31.439  18.284  1.00 56.90           C  
ATOM   4011  OG1 THR D 134       3.319 -30.437  17.891  1.00 61.15           O  
ATOM   4012  CG2 THR D 134       5.563 -30.762  18.746  1.00 56.60           C  
ATOM   4013  N   PHE D 135       2.964 -34.153  17.405  1.00 60.01           N  
ATOM   4014  CA  PHE D 135       1.851 -35.009  16.990  1.00 60.40           C  
ATOM   4015  C   PHE D 135       0.809 -35.253  18.078  1.00 61.22           C  
ATOM   4016  O   PHE D 135       0.890 -34.714  19.197  1.00 61.59           O  
ATOM   4017  CB  PHE D 135       2.366 -36.309  16.371  1.00 59.80           C  
ATOM   4018  CG  PHE D 135       3.262 -36.094  15.185  1.00 57.54           C  
ATOM   4019  CD1 PHE D 135       2.726 -35.728  13.947  1.00 56.86           C  
ATOM   4020  CD2 PHE D 135       4.636 -36.247  15.306  1.00 56.02           C  
ATOM   4021  CE1 PHE D 135       3.558 -35.528  12.842  1.00 58.15           C  
ATOM   4022  CE2 PHE D 135       5.490 -36.043  14.215  1.00 54.86           C  
ATOM   4023  CZ  PHE D 135       4.964 -35.680  12.983  1.00 59.14           C  
TER    4024      PHE D 135                                                      
END
MOLECULE T0475.pdb
ATOM     20  N   ASN     2       1.831  -2.392  -0.522  1.00  0.00
ATOM     21  HN  ASN     2       1.726  -2.331   0.453  1.00  0.00
ATOM     22  CA  ASN     2       2.075  -3.725  -1.109  1.00  0.00
ATOM     23  HA  ASN     2       2.284  -3.607  -2.174  1.00  0.00
ATOM     24  CB  ASN     2       3.299  -4.390  -0.422  1.00  0.00
ATOM     25  HB1 ASN     2       3.466  -5.372  -0.859  1.00  0.00
ATOM     26  HB2 ASN     2       3.089  -4.514   0.636  1.00  0.00
ATOM     27  CG  ASN     2       4.590  -3.576  -0.565  1.00  0.00
ATOM     28  OD1 ASN     2       5.324  -3.715  -1.546  1.00  0.00
ATOM     29  ND2 ASN     2       4.857  -2.700   0.401  1.00  0.00
ATOM     30 HD21 ASN     2       4.224  -2.628   1.148  1.00  0.00
ATOM     31 HD22 ASN     2       5.675  -2.167   0.331  1.00  0.00
ATOM     32  C   ASN     2       0.785  -4.553  -0.964  1.00  0.00
ATOM     33  O   ASN     2       0.810  -5.738  -0.618  1.00  0.00
ATOM     34  N   SER     3      -0.341  -3.891  -1.292  1.00  0.00
ATOM     35  HN  SER     3      -0.247  -3.002  -1.689  1.00  0.00
ATOM     36  CA  SER     3      -1.702  -4.409  -1.095  1.00  0.00
ATOM     37  HA  SER     3      -1.797  -4.700  -0.049  1.00  0.00
ATOM     38  CB  SER     3      -2.716  -3.279  -1.383  1.00  0.00
ATOM     39  HB1 SER     3      -2.599  -2.492  -0.645  1.00  0.00
ATOM     40  HB2 SER     3      -3.729  -3.660  -1.328  1.00  0.00
ATOM     41  OG  SER     3      -2.512  -2.719  -2.675  1.00  0.00
ATOM     42  HG  SER     3      -3.361  -2.595  -3.107  1.00  0.00
ATOM     43  C   SER     3      -1.979  -5.633  -1.981  1.00  0.00
ATOM     44  O   SER     3      -2.523  -6.626  -1.511  1.00  0.00
ATOM     45  N   GLU     4      -1.554  -5.549  -3.257  1.00  0.00
ATOM     46  HN  GLU     4      -1.122  -4.715  -3.539  1.00  0.00
ATOM     47  CA  GLU     4      -1.720  -6.638  -4.252  1.00  0.00
ATOM     48  HA  GLU     4      -2.760  -6.955  -4.203  1.00  0.00
ATOM     49  CB  GLU     4      -1.434  -6.132  -5.697  1.00  0.00
ATOM     50  HB1 GLU     4      -2.105  -5.307  -5.907  1.00  0.00
ATOM     51  HB2 GLU     4      -1.659  -6.934  -6.393  1.00  0.00
ATOM     52  CG  GLU     4       0.018  -5.661  -5.984  1.00  0.00
ATOM     53  HG1 GLU     4       0.166  -5.630  -7.063  1.00  0.00
ATOM     54  HG2 GLU     4       0.703  -6.396  -5.571  1.00  0.00
ATOM     55  CD  GLU     4       0.366  -4.277  -5.399  1.00  0.00
ATOM     56  OE1 GLU     4       0.009  -3.255  -6.022  1.00  0.00
ATOM     57  OE2 GLU     4       0.991  -4.208  -4.319  1.00  0.00
ATOM     58  C   GLU     4      -0.837  -7.869  -3.943  1.00  0.00
ATOM     59  O   GLU     4      -0.931  -8.886  -4.637  1.00  0.00
ATOM     60  N   ILE     5       0.041  -7.744  -2.937  1.00  0.00
ATOM     61  HN  ILE     5       0.146  -6.866  -2.519  1.00  0.00
ATOM     62  CA  ILE     5       0.867  -8.854  -2.432  1.00  0.00
ATOM     63  HA  ILE     5       0.966  -9.608  -3.214  1.00  0.00
ATOM     64  CB  ILE     5       2.303  -8.347  -2.025  1.00  0.00
ATOM     65  HB  ILE     5       2.196  -7.811  -1.085  1.00  0.00
ATOM     66  CG1 ILE     5       2.896  -7.353  -3.082  1.00  0.00
ATOM     67 HG11 ILE     5       3.865  -7.007  -2.738  1.00  0.00
ATOM     68 HG12 ILE     5       2.244  -6.502  -3.163  1.00  0.00
ATOM     69  CG2 ILE     5       3.271  -9.523  -1.775  1.00  0.00
ATOM     70 HG21 ILE     5       4.228  -9.142  -1.435  1.00  0.00
ATOM     71 HG22 ILE     5       3.417 -10.078  -2.691  1.00  0.00
ATOM     72 HG23 ILE     5       2.862 -10.182  -1.021  1.00  0.00
ATOM     73  CD1 ILE     5       3.082  -7.904  -4.488  1.00  0.00
ATOM     74 HD11 ILE     5       2.126  -8.218  -4.887  1.00  0.00
ATOM     75 HD12 ILE     5       3.755  -8.751  -4.459  1.00  0.00
ATOM     76 HD13 ILE     5       3.501  -7.137  -5.121  1.00  0.00
ATOM     77  C   ILE     5       0.167  -9.486  -1.207  1.00  0.00
ATOM     78  O   ILE     5       0.309 -10.683  -0.936  1.00  0.00
ATOM     79  N   GLU     6      -0.598  -8.649  -0.477  1.00  0.00
ATOM     80  HN  GLU     6      -0.624  -7.699  -0.730  1.00  0.00
ATOM     81  CA  GLU     6      -1.393  -9.075   0.691  1.00  0.00
ATOM     82  HA  GLU     6      -0.790  -9.767   1.280  1.00  0.00
ATOM     83  CB  GLU     6      -1.739  -7.844   1.574  1.00  0.00
ATOM     84  HB1 GLU     6      -2.373  -8.164   2.398  1.00  0.00
ATOM     85  HB2 GLU     6      -2.291  -7.131   0.971  1.00  0.00
ATOM     86  CG  GLU     6      -0.519  -7.120   2.167  1.00  0.00
ATOM     87  HG1 GLU     6       0.145  -6.834   1.353  1.00  0.00
ATOM     88  HG2 GLU     6       0.011  -7.810   2.816  1.00  0.00
ATOM     89  CD  GLU     6      -0.894  -5.858   2.968  1.00  0.00
ATOM     90  OE1 GLU     6      -1.011  -5.932   4.215  1.00  0.00
ATOM     91  OE2 GLU     6      -1.101  -4.793   2.350  1.00  0.00
ATOM     92  C   GLU     6      -2.691  -9.790   0.261  1.00  0.00
ATOM     93  O   GLU     6      -3.153 -10.698   0.961  1.00  0.00
ATOM     94  N   LEU     7      -3.271  -9.367  -0.887  1.00  0.00
ATOM     95  HN  LEU     7      -2.808  -8.685  -1.417  1.00  0.00
ATOM     96  CA  LEU     7      -4.562  -9.911  -1.391  1.00  0.00
ATOM     97  HA  LEU     7      -5.292  -9.732  -0.607  1.00  0.00
ATOM     98  CB  LEU     7      -5.054  -9.182  -2.681  1.00  0.00
ATOM     99  HB1 LEU     7      -5.975  -9.663  -3.009  1.00  0.00
ATOM    100  HB2 LEU     7      -4.310  -9.334  -3.456  1.00  0.00
ATOM    101  CG  LEU     7      -5.325  -7.651  -2.562  1.00  0.00
ATOM    102  HG  LEU     7      -4.402  -7.168  -2.287  1.00  0.00
ATOM    103  CD1 LEU     7      -5.756  -7.043  -3.913  1.00  0.00
ATOM    104 HD11 LEU     7      -6.661  -7.526  -4.269  1.00  0.00
ATOM    105 HD12 LEU     7      -4.968  -7.181  -4.640  1.00  0.00
ATOM    106 HD13 LEU     7      -5.941  -5.982  -3.792  1.00  0.00
ATOM    107  CD2 LEU     7      -6.353  -7.346  -1.453  1.00  0.00
ATOM    108 HD21 LEU     7      -5.982  -7.713  -0.505  1.00  0.00
ATOM    109 HD22 LEU     7      -7.295  -7.830  -1.678  1.00  0.00
ATOM    110 HD23 LEU     7      -6.509  -6.276  -1.383  1.00  0.00
ATOM    111  C   LEU     7      -4.504 -11.450  -1.632  1.00  0.00
ATOM    112  O   LEU     7      -5.411 -12.157  -1.175  1.00  0.00
ATOM    113  N   PRO     8      -3.462 -12.011  -2.364  1.00  0.00
ATOM    114  CA  PRO     8      -3.309 -13.478  -2.527  1.00  0.00
ATOM    115  HA  PRO     8      -4.145 -13.893  -3.088  1.00  0.00
ATOM    116  CB  PRO     8      -1.994 -13.649  -3.366  1.00  0.00
ATOM    117  HB1 PRO     8      -2.245 -13.908  -4.388  1.00  0.00
ATOM    118  HB2 PRO     8      -1.376 -14.442  -2.953  1.00  0.00
ATOM    119  CG  PRO     8      -1.308 -12.325  -3.298  1.00  0.00
ATOM    120  HG1 PRO     8      -0.750 -12.142  -4.212  1.00  0.00
ATOM    121  HG2 PRO     8      -0.632 -12.298  -2.447  1.00  0.00
ATOM    122  CD  PRO     8      -2.402 -11.297  -3.131  1.00  0.00
ATOM    123  HD1 PRO     8      -2.780 -10.972  -4.098  1.00  0.00
ATOM    124  HD2 PRO     8      -2.035 -10.447  -2.573  1.00  0.00
ATOM    125  C   PRO     8      -3.231 -14.208  -1.181  1.00  0.00
ATOM    126  O   PRO     8      -4.115 -14.994  -0.842  1.00  0.00
ATOM    127  N   VAL     9      -2.209 -13.860  -0.401  1.00  0.00
ATOM    128  HN  VAL     9      -1.703 -13.049  -0.636  1.00  0.00
ATOM    129  CA  VAL     9      -1.812 -14.612   0.800  1.00  0.00
ATOM    130  HA  VAL     9      -1.660 -15.641   0.491  1.00  0.00
ATOM    131  CB  VAL     9      -0.455 -14.070   1.348  1.00  0.00
ATOM    132  HB  VAL     9      -0.147 -14.712   2.173  1.00  0.00
ATOM    133  CG1 VAL     9       0.641 -14.156   0.254  1.00  0.00
ATOM    134 HG11 VAL     9       0.368 -13.532  -0.588  1.00  0.00
ATOM    135 HG12 VAL     9       0.746 -15.182  -0.082  1.00  0.00
ATOM    136 HG13 VAL     9       1.587 -13.820   0.657  1.00  0.00
ATOM    137  CG2 VAL     9      -0.593 -12.627   1.896  1.00  0.00
ATOM    138 HG21 VAL     9      -0.958 -11.972   1.115  1.00  0.00
ATOM    139 HG22 VAL     9       0.366 -12.271   2.239  1.00  0.00
ATOM    140 HG23 VAL     9      -1.292 -12.614   2.725  1.00  0.00
ATOM    141  C   VAL     9      -2.901 -14.601   1.905  1.00  0.00
ATOM    142  O   VAL     9      -3.020 -15.564   2.666  1.00  0.00
ATOM    143  N   GLN    10      -3.705 -13.515   1.950  1.00  0.00
ATOM    144  HN  GLN    10      -3.532 -12.787   1.318  1.00  0.00
ATOM    145  CA  GLN    10      -4.839 -13.376   2.888  1.00  0.00
ATOM    146  HA  GLN    10      -4.480 -13.600   3.893  1.00  0.00
ATOM    147  CB  GLN    10      -5.375 -11.914   2.859  1.00  0.00
ATOM    148  HB1 GLN    10      -5.608 -11.659   1.829  1.00  0.00
ATOM    149  HB2 GLN    10      -4.587 -11.252   3.197  1.00  0.00
ATOM    150  CG  GLN    10      -6.630 -11.627   3.718  1.00  0.00
ATOM    151  HG1 GLN    10      -7.444 -12.248   3.358  1.00  0.00
ATOM    152  HG2 GLN    10      -6.905 -10.587   3.587  1.00  0.00
ATOM    153  CD  GLN    10      -6.435 -11.892   5.211  1.00  0.00
ATOM    154  OE1 GLN    10      -6.001 -11.016   5.954  1.00  0.00
ATOM    155  NE2 GLN    10      -6.762 -13.097   5.655  1.00  0.00
ATOM    156 HE21 GLN    10      -7.111 -13.751   5.008  1.00  0.00
ATOM    157 HE22 GLN    10      -6.644 -13.289   6.609  1.00  0.00
ATOM    158  C   GLN    10      -5.951 -14.368   2.514  1.00  0.00
ATOM    159  O   GLN    10      -6.354 -15.200   3.335  1.00  0.00
ATOM    160  N   LYS    11      -6.395 -14.286   1.244  1.00  0.00
ATOM    161  HN  LYS    11      -5.949 -13.656   0.636  1.00  0.00
ATOM    162  CA  LYS    11      -7.508 -15.103   0.710  1.00  0.00
ATOM    163  HA  LYS    11      -8.378 -14.924   1.338  1.00  0.00
ATOM    164  CB  LYS    11      -7.846 -14.648  -0.732  1.00  0.00
ATOM    165  HB1 LYS    11      -8.562 -15.342  -1.167  1.00  0.00
ATOM    166  HB2 LYS    11      -6.938 -14.674  -1.329  1.00  0.00
ATOM    167  CG  LYS    11      -8.439 -13.225  -0.830  1.00  0.00
ATOM    168  HG1 LYS    11      -8.591 -12.983  -1.878  1.00  0.00
ATOM    169  HG2 LYS    11      -7.731 -12.521  -0.403  1.00  0.00
ATOM    170  CD  LYS    11      -9.782 -13.097  -0.085  1.00  0.00
ATOM    171  HD1 LYS    11      -9.626 -13.325   0.969  1.00  0.00
ATOM    172  HD2 LYS    11     -10.482 -13.816  -0.497  1.00  0.00
ATOM    173  CE  LYS    11     -10.403 -11.699  -0.200  1.00  0.00
ATOM    174  HE1 LYS    11     -10.562 -11.460  -1.242  1.00  0.00
ATOM    175  HE2 LYS    11      -9.730 -10.971   0.239  1.00  0.00
ATOM    176  NZ  LYS    11     -11.702 -11.633   0.510  1.00  0.00
ATOM    177  HZ1 LYS    11     -12.109 -10.686   0.416  1.00  0.00
ATOM    178  HZ2 LYS    11     -11.567 -11.843   1.519  1.00  0.00
ATOM    179  HZ3 LYS    11     -12.367 -12.326   0.112  1.00  0.00
ATOM    180  C   LYS    11      -7.180 -16.603   0.734  1.00  0.00
ATOM    181  O   LYS    11      -8.057 -17.429   0.977  1.00  0.00
ATOM    182  N   GLN    12      -5.904 -16.925   0.497  1.00  0.00
ATOM    183  HN  GLN    12      -5.262 -16.197   0.364  1.00  0.00
ATOM    184  CA  GLN    12      -5.412 -18.308   0.438  1.00  0.00
ATOM    185  HA  GLN    12      -6.116 -18.882  -0.161  1.00  0.00
ATOM    186  CB  GLN    12      -4.038 -18.347  -0.253  1.00  0.00
ATOM    187  HB1 GLN    12      -3.615 -19.342  -0.140  1.00  0.00
ATOM    188  HB2 GLN    12      -3.378 -17.634   0.241  1.00  0.00
ATOM    189  CG  GLN    12      -4.076 -18.013  -1.754  1.00  0.00
ATOM    190  HG1 GLN    12      -4.619 -17.084  -1.892  1.00  0.00
ATOM    191  HG2 GLN    12      -4.592 -18.806  -2.280  1.00  0.00
ATOM    192  CD  GLN    12      -2.692 -17.850  -2.370  1.00  0.00
ATOM    193  OE1 GLN    12      -2.513 -17.092  -3.318  1.00  0.00
ATOM    194  NE2 GLN    12      -1.704 -18.584  -1.862  1.00  0.00
ATOM    195 HE21 GLN    12      -1.901 -19.190  -1.120  1.00  0.00
ATOM    196 HE22 GLN    12      -0.821 -18.502  -2.263  1.00  0.00
ATOM    197  C   GLN    12      -5.310 -18.928   1.840  1.00  0.00
ATOM    198  O   GLN    12      -5.658 -20.085   2.024  1.00  0.00
ATOM    199  N   LEU    13      -4.802 -18.148   2.810  1.00  0.00
ATOM    200  HN  LEU    13      -4.515 -17.235   2.577  1.00  0.00
ATOM    201  CA  LEU    13      -4.660 -18.600   4.211  1.00  0.00
ATOM    202  HA  LEU    13      -4.023 -19.485   4.218  1.00  0.00
ATOM    203  CB  LEU    13      -4.000 -17.499   5.062  1.00  0.00
ATOM    204  HB1 LEU    13      -4.586 -16.593   4.943  1.00  0.00
ATOM    205  HB2 LEU    13      -3.007 -17.308   4.661  1.00  0.00
ATOM    206  CG  LEU    13      -3.869 -17.811   6.587  1.00  0.00
ATOM    207  HG  LEU    13      -4.781 -18.277   6.921  1.00  0.00
ATOM    208  CD1 LEU    13      -2.741 -18.824   6.881  1.00  0.00
ATOM    209 HD11 LEU    13      -2.683 -19.003   7.947  1.00  0.00
ATOM    210 HD12 LEU    13      -1.792 -18.435   6.532  1.00  0.00
ATOM    211 HD13 LEU    13      -2.952 -19.760   6.376  1.00  0.00
ATOM    212  CD2 LEU    13      -3.726 -16.522   7.391  1.00  0.00
ATOM    213 HD21 LEU    13      -3.726 -16.755   8.445  1.00  0.00
ATOM    214 HD22 LEU    13      -4.561 -15.868   7.172  1.00  0.00
ATOM    215 HD23 LEU    13      -2.801 -16.024   7.132  1.00  0.00
ATOM    216  C   LEU    13      -6.039 -18.958   4.803  1.00  0.00
ATOM    217  O   LEU    13      -6.199 -20.004   5.451  1.00  0.00
ATOM    218  N   GLU    14      -7.012 -18.054   4.579  1.00  0.00
ATOM    219  HN  GLU    14      -6.762 -17.194   4.166  1.00  0.00
ATOM    220  CA  GLU    14      -8.427 -18.274   4.938  1.00  0.00
ATOM    221  HA  GLU    14      -8.482 -18.402   6.018  1.00  0.00
ATOM    222  CB  GLU    14      -9.279 -17.045   4.529  1.00  0.00
ATOM    223  HB1 GLU    14     -10.327 -17.249   4.740  1.00  0.00
ATOM    224  HB2 GLU    14      -9.167 -16.886   3.459  1.00  0.00
ATOM    225  CG  GLU    14      -8.896 -15.744   5.249  1.00  0.00
ATOM    226  HG1 GLU    14      -7.833 -15.558   5.093  1.00  0.00
ATOM    227  HG2 GLU    14      -9.070 -15.875   6.311  1.00  0.00
ATOM    228  CD  GLU    14      -9.693 -14.526   4.750  1.00  0.00
ATOM    229  OE1 GLU    14     -10.749 -14.201   5.342  1.00  0.00
ATOM    230  OE2 GLU    14      -9.272 -13.890   3.756  1.00  0.00
ATOM    231  C   GLU    14      -8.950 -19.548   4.253  1.00  0.00
ATOM    232  O   GLU    14      -9.468 -20.433   4.916  1.00  0.00
ATOM    233  N   ALA    15      -8.711 -19.634   2.933  1.00  0.00
ATOM    234  HN  ALA    15      -8.204 -18.905   2.512  1.00  0.00
ATOM    235  CA  ALA    15      -9.156 -20.758   2.076  1.00  0.00
ATOM    236  HA  ALA    15     -10.235 -20.852   2.189  1.00  0.00
ATOM    237  CB  ALA    15      -8.862 -20.438   0.601  1.00  0.00
ATOM    238  HB1 ALA    15      -7.792 -20.355   0.451  1.00  0.00
ATOM    239  HB2 ALA    15      -9.327 -19.499   0.328  1.00  0.00
ATOM    240  HB3 ALA    15      -9.255 -21.223  -0.034  1.00  0.00
ATOM    241  C   ALA    15      -8.495 -22.102   2.478  1.00  0.00
ATOM    242  O   ALA    15      -9.058 -23.168   2.217  1.00  0.00
ATOM    243  N   TYR    16      -7.294 -22.028   3.098  1.00  0.00
ATOM    244  HN  TYR    16      -6.919 -21.135   3.279  1.00  0.00
ATOM    245  CA  TYR    16      -6.514 -23.215   3.518  1.00  0.00
ATOM    246  HA  TYR    16      -6.377 -23.844   2.639  1.00  0.00
ATOM    247  CB  TYR    16      -5.116 -22.780   4.043  1.00  0.00
ATOM    248  HB1 TYR    16      -5.253 -22.145   4.912  1.00  0.00
ATOM    249  HB2 TYR    16      -4.621 -22.198   3.274  1.00  0.00
ATOM    250  CG  TYR    16      -4.166 -23.936   4.432  1.00  0.00
ATOM    251  CD1 TYR    16      -3.688 -24.087   5.742  1.00  0.00
ATOM    252  HD1 TYR    16      -3.991 -23.371   6.499  1.00  0.00
ATOM    253  CD2 TYR    16      -3.752 -24.875   3.481  1.00  0.00
ATOM    254  HD2 TYR    16      -4.105 -24.781   2.460  1.00  0.00
ATOM    255  CE1 TYR    16      -2.836 -25.128   6.080  1.00  0.00
ATOM    256  HE1 TYR    16      -2.482 -25.225   7.100  1.00  0.00
ATOM    257  CE2 TYR    16      -2.904 -25.913   3.816  1.00  0.00
ATOM    258  HE2 TYR    16      -2.602 -26.625   3.059  1.00  0.00
ATOM    259  CZ  TYR    16      -2.448 -26.037   5.113  1.00  0.00
ATOM    260  OH  TYR    16      -1.602 -27.080   5.440  1.00  0.00
ATOM    261  HH  TYR    16      -1.856 -27.442   6.292  1.00  0.00
ATOM    262  C   TYR    16      -7.276 -24.016   4.589  1.00  0.00
ATOM    263  O   TYR    16      -7.355 -25.252   4.525  1.00  0.00
ATOM    264  N   ASN    17      -7.845 -23.289   5.560  1.00  0.00
ATOM    265  HN  ASN    17      -7.732 -22.312   5.539  1.00  0.00
ATOM    266  CA  ASN    17      -8.637 -23.887   6.651  1.00  0.00
ATOM    267  HA  ASN    17      -8.283 -24.908   6.797  1.00  0.00
ATOM    268  CB  ASN    17      -8.405 -23.104   7.979  1.00  0.00
ATOM    269  HB1 ASN    17      -7.345 -23.123   8.218  1.00  0.00
ATOM    270  HB2 ASN    17      -8.938 -23.600   8.780  1.00  0.00
ATOM    271  CG  ASN    17      -8.859 -21.642   7.940  1.00  0.00
ATOM    272  OD1 ASN    17      -9.998 -21.326   8.280  1.00  0.00
ATOM    273  ND2 ASN    17      -7.969 -20.740   7.540  1.00  0.00
ATOM    274 HD21 ASN    17      -7.069 -21.047   7.289  1.00  0.00
ATOM    275 HD22 ASN    17      -8.244 -19.800   7.514  1.00  0.00
ATOM    276  C   ASN    17     -10.139 -23.952   6.270  1.00  0.00
ATOM    277  O   ASN    17     -10.847 -24.858   6.711  1.00  0.00
ATOM    278  N   ALA    18     -10.592 -23.015   5.405  1.00  0.00
ATOM    279  HN  ALA    18      -9.945 -22.382   5.033  1.00  0.00
ATOM    280  CA  ALA    18     -12.017 -22.899   4.977  1.00  0.00
ATOM    281  HA  ALA    18     -12.645 -23.109   5.841  1.00  0.00
ATOM    282  CB  ALA    18     -12.330 -21.469   4.502  1.00  0.00
ATOM    283  HB1 ALA    18     -12.057 -20.761   5.270  1.00  0.00
ATOM    284  HB2 ALA    18     -13.389 -21.372   4.287  1.00  0.00
ATOM    285  HB3 ALA    18     -11.764 -21.251   3.601  1.00  0.00
ATOM    286  C   ALA    18     -12.372 -23.904   3.864  1.00  0.00
ATOM    287  O   ALA    18     -13.549 -24.058   3.525  1.00  0.00
ATOM    288  N   ARG    19     -11.335 -24.564   3.304  1.00  0.00
ATOM    289  HN  ARG    19     -10.428 -24.285   3.558  1.00  0.00
ATOM    290  CA  ARG    19     -11.463 -25.664   2.322  1.00  0.00
ATOM    291  HA  ARG    19     -10.461 -26.039   2.155  1.00  0.00
ATOM    292  CB  ARG    19     -12.324 -26.837   2.881  1.00  0.00
ATOM    293  HB1 ARG    19     -12.258 -27.674   2.191  1.00  0.00
ATOM    294  HB2 ARG    19     -13.358 -26.514   2.925  1.00  0.00
ATOM    295  CG  ARG    19     -11.926 -27.336   4.286  1.00  0.00
ATOM    296  HG1 ARG    19     -12.522 -28.212   4.517  1.00  0.00
ATOM    297  HG2 ARG    19     -12.152 -26.559   5.010  1.00  0.00
ATOM    298  CD  ARG    19     -10.443 -27.704   4.416  1.00  0.00
ATOM    299  HD1 ARG    19      -9.841 -26.820   4.237  1.00  0.00
ATOM    300  HD2 ARG    19     -10.192 -28.462   3.681  1.00  0.00
ATOM    301  NE  ARG    19     -10.151 -28.205   5.768  1.00  0.00
ATOM    302  HE  ARG    19      -9.995 -27.527   6.467  1.00  0.00
ATOM    303  CZ  ARG    19     -10.113 -29.498   6.120  1.00  0.00
ATOM    304  NH1 ARG    19     -10.315 -30.461   5.228  1.00  0.00
ATOM    305 HH11 ARG    19     -10.508 -30.236   4.271  1.00  0.00
ATOM    306 HH12 ARG    19     -10.261 -31.424   5.505  1.00  0.00
ATOM    307  NH2 ARG    19      -9.892 -29.827   7.378  1.00  0.00
ATOM    308 HH21 ARG    19      -9.761 -29.112   8.073  1.00  0.00
ATOM    309 HH22 ARG    19      -9.844 -30.791   7.648  1.00  0.00
ATOM    310  C   ARG    19     -11.996 -25.167   0.958  1.00  0.00
ATOM    311  O   ARG    19     -12.864 -25.800   0.338  1.00  0.00
ATOM    312  N   ASP    20     -11.443 -24.037   0.485  1.00  0.00
ATOM    313  HN  ASP    20     -10.788 -23.570   1.041  1.00  0.00
ATOM    314  CA  ASP    20     -11.769 -23.468  -0.838  1.00  0.00
ATOM    315  HA  ASP    20     -12.541 -24.077  -1.307  1.00  0.00
ATOM    316  CB  ASP    20     -12.309 -22.010  -0.689  1.00  0.00
ATOM    317  HB1 ASP    20     -12.380 -21.558  -1.674  1.00  0.00
ATOM    318  HB2 ASP    20     -11.601 -21.429  -0.100  1.00  0.00
ATOM    319  CG  ASP    20     -13.689 -21.930  -0.008  1.00  0.00
ATOM    320  OD1 ASP    20     -13.750 -21.843   1.238  1.00  0.00
ATOM    321  OD2 ASP    20     -14.720 -21.948  -0.721  1.00  0.00
ATOM    322  C   ASP    20     -10.514 -23.492  -1.734  1.00  0.00
ATOM    323  O   ASP    20      -9.717 -22.558  -1.696  1.00  0.00
ATOM    324  N   ILE    21     -10.357 -24.561  -2.547  1.00  0.00
ATOM    325  HN  ILE    21     -11.052 -25.252  -2.550  1.00  0.00
ATOM    326  CA  ILE    21      -9.181 -24.730  -3.438  1.00  0.00
ATOM    327  HA  ILE    21      -8.300 -24.483  -2.847  1.00  0.00
ATOM    328  CB  ILE    21      -9.016 -26.233  -3.930  1.00  0.00
ATOM    329  HB  ILE    21     -10.004 -26.599  -4.190  1.00  0.00
ATOM    330  CG1 ILE    21      -8.453 -27.132  -2.779  1.00  0.00
ATOM    331 HG11 ILE    21      -8.531 -28.173  -3.071  1.00  0.00
ATOM    332 HG12 ILE    21      -9.039 -26.979  -1.884  1.00  0.00
ATOM    333  CG2 ILE    21      -8.127 -26.369  -5.205  1.00  0.00
ATOM    334 HG21 ILE    21      -8.582 -25.828  -6.025  1.00  0.00
ATOM    335 HG22 ILE    21      -8.032 -27.412  -5.477  1.00  0.00
ATOM    336 HG23 ILE    21      -7.143 -25.959  -5.009  1.00  0.00
ATOM    337  CD1 ILE    21      -6.996 -26.864  -2.418  1.00  0.00
ATOM    338 HD11 ILE    21      -6.719 -27.483  -1.577  1.00  0.00
ATOM    339 HD12 ILE    21      -6.874 -25.824  -2.152  1.00  0.00
ATOM    340 HD13 ILE    21      -6.361 -27.100  -3.261  1.00  0.00
ATOM    341  C   ILE    21      -9.226 -23.742  -4.620  1.00  0.00
ATOM    342  O   ILE    21      -8.175 -23.315  -5.100  1.00  0.00
ATOM    343  N   ASP    22     -10.438 -23.351  -5.061  1.00  0.00
ATOM    344  HN  ASP    22     -11.243 -23.708  -4.615  1.00  0.00
ATOM    345  CA  ASP    22     -10.607 -22.411  -6.196  1.00  0.00
ATOM    346  HA  ASP    22     -10.117 -22.864  -7.058  1.00  0.00
ATOM    347  CB  ASP    22     -12.108 -22.225  -6.538  1.00  0.00
ATOM    348  HB1 ASP    22     -12.633 -21.874  -5.655  1.00  0.00
ATOM    349  HB2 ASP    22     -12.527 -23.188  -6.818  1.00  0.00
ATOM    350  CG  ASP    22     -12.355 -21.231  -7.695  1.00  0.00
ATOM    351  OD1 ASP    22     -12.735 -20.066  -7.435  1.00  0.00
ATOM    352  OD2 ASP    22     -12.135 -21.609  -8.867  1.00  0.00
ATOM    353  C   ASP    22      -9.928 -21.047  -5.907  1.00  0.00
ATOM    354  O   ASP    22      -9.220 -20.518  -6.762  1.00  0.00
ATOM    355  N   ALA    23     -10.136 -20.511  -4.691  1.00  0.00
ATOM    356  HN  ALA    23     -10.740 -20.975  -4.074  1.00  0.00
ATOM    357  CA  ALA    23      -9.486 -19.252  -4.239  1.00  0.00
ATOM    358  HA  ALA    23      -9.458 -18.561  -5.080  1.00  0.00
ATOM    359  CB  ALA    23     -10.297 -18.602  -3.105  1.00  0.00
ATOM    360  HB1 ALA    23      -9.839 -17.662  -2.810  1.00  0.00
ATOM    361  HB2 ALA    23     -10.332 -19.265  -2.252  1.00  0.00
ATOM    362  HB3 ALA    23     -11.309 -18.413  -3.447  1.00  0.00
ATOM    363  C   ALA    23      -8.040 -19.511  -3.791  1.00  0.00
ATOM    364  O   ALA    23      -7.160 -18.659  -3.967  1.00  0.00
ATOM    365  N   PHE    24      -7.810 -20.712  -3.236  1.00  0.00
ATOM    366  HN  PHE    24      -8.575 -21.307  -3.083  1.00  0.00
ATOM    367  CA  PHE    24      -6.473 -21.176  -2.830  1.00  0.00
ATOM    368  HA  PHE    24      -6.009 -20.382  -2.243  1.00  0.00
ATOM    369  CB  PHE    24      -6.615 -22.440  -1.934  1.00  0.00
ATOM    370  HB1 PHE    24      -6.963 -23.265  -2.547  1.00  0.00
ATOM    371  HB2 PHE    24      -7.362 -22.246  -1.173  1.00  0.00
ATOM    372  CG  PHE    24      -5.339 -22.878  -1.225  1.00  0.00
ATOM    373  CD1 PHE    24      -4.521 -23.871  -1.754  1.00  0.00
ATOM    374  HD1 PHE    24      -4.808 -24.367  -2.671  1.00  0.00
ATOM    375  CD2 PHE    24      -4.940 -22.263  -0.047  1.00  0.00
ATOM    376  HD2 PHE    24      -5.561 -21.491   0.389  1.00  0.00
ATOM    377  CE1 PHE    24      -3.356 -24.232  -1.120  1.00  0.00
ATOM    378  HE1 PHE    24      -2.732 -25.002  -1.545  1.00  0.00
ATOM    379  CE2 PHE    24      -3.775 -22.635   0.590  1.00  0.00
ATOM    380  HE2 PHE    24      -3.483 -22.147   1.511  1.00  0.00
ATOM    381  CZ  PHE    24      -2.979 -23.615   0.050  1.00  0.00
ATOM    382  HZ  PHE    24      -2.058 -23.904   0.544  1.00  0.00
ATOM    383  C   PHE    24      -5.585 -21.459  -4.071  1.00  0.00
ATOM    384  O   PHE    24      -4.392 -21.704  -3.933  1.00  0.00
ATOM    385  N   MET    25      -6.184 -21.461  -5.282  1.00  0.00
ATOM    386  HN  MET    25      -7.161 -21.385  -5.318  1.00  0.00
ATOM    387  CA  MET    25      -5.445 -21.605  -6.559  1.00  0.00
ATOM    388  HA  MET    25      -4.407 -21.823  -6.325  1.00  0.00
ATOM    389  CB  MET    25      -6.016 -22.776  -7.413  1.00  0.00
ATOM    390  HB1 MET    25      -7.067 -22.579  -7.602  1.00  0.00
ATOM    391  HB2 MET    25      -5.940 -23.689  -6.834  1.00  0.00
ATOM    392  CG  MET    25      -5.310 -23.025  -8.775  1.00  0.00
ATOM    393  HG1 MET    25      -5.016 -22.072  -9.200  1.00  0.00
ATOM    394  HG2 MET    25      -6.019 -23.489  -9.446  1.00  0.00
ATOM    395  SD  MET    25      -3.840 -24.101  -8.708  1.00  0.00
ATOM    396  CE  MET    25      -2.690 -23.286  -7.583  1.00  0.00
ATOM    397  HE1 MET    25      -1.756 -23.833  -7.570  1.00  0.00
ATOM    398  HE2 MET    25      -3.107 -23.276  -6.587  1.00  0.00
ATOM    399  HE3 MET    25      -2.510 -22.271  -7.910  1.00  0.00
ATOM    400  C   MET    25      -5.483 -20.303  -7.374  1.00  0.00
ATOM    401  O   MET    25      -4.536 -20.015  -8.120  1.00  0.00
ATOM    402  N   ALA    26      -6.576 -19.524  -7.206  1.00  0.00
ATOM    403  HN  ALA    26      -7.206 -19.764  -6.502  1.00  0.00
ATOM    404  CA  ALA    26      -6.870 -18.324  -8.030  1.00  0.00
ATOM    405  HA  ALA    26      -7.098 -18.668  -9.039  1.00  0.00
ATOM    406  CB  ALA    26      -8.111 -17.596  -7.486  1.00  0.00
ATOM    407  HB1 ALA    26      -8.955 -18.274  -7.463  1.00  0.00
ATOM    408  HB2 ALA    26      -8.354 -16.752  -8.122  1.00  0.00
ATOM    409  HB3 ALA    26      -7.918 -17.241  -6.478  1.00  0.00
ATOM    410  C   ALA    26      -5.690 -17.354  -8.081  1.00  0.00
ATOM    411  O   ALA    26      -5.165 -17.037  -9.147  1.00  0.00
ATOM    412  N   TRP    27      -5.237 -16.978  -6.894  1.00  0.00
ATOM    413  HN  TRP    27      -5.569 -17.449  -6.099  1.00  0.00
ATOM    414  CA  TRP    27      -4.272 -15.899  -6.699  1.00  0.00
ATOM    415  HA  TRP    27      -4.541 -15.083  -7.366  1.00  0.00
ATOM    416  CB  TRP    27      -4.404 -15.411  -5.253  1.00  0.00
ATOM    417  HB1 TRP    27      -3.650 -14.657  -5.074  1.00  0.00
ATOM    418  HB2 TRP    27      -4.223 -16.240  -4.578  1.00  0.00
ATOM    419  CG  TRP    27      -5.746 -14.806  -4.899  1.00  0.00
ATOM    420  CD1 TRP    27      -6.813 -15.425  -4.298  1.00  0.00
ATOM    421  HD1 TRP    27      -6.834 -16.466  -4.002  1.00  0.00
ATOM    422  CD2 TRP    27      -6.140 -13.442  -5.103  1.00  0.00
ATOM    423  NE1 TRP    27      -7.838 -14.529  -4.128  1.00  0.00
ATOM    424  HE1 TRP    27      -8.707 -14.731  -3.721  1.00  0.00
ATOM    425  CE2 TRP    27      -7.451 -13.309  -4.615  1.00  0.00
ATOM    426  CE3 TRP    27      -5.497 -12.321  -5.646  1.00  0.00
ATOM    427  HE3 TRP    27      -4.487 -12.389  -6.033  1.00  0.00
ATOM    428  CZ2 TRP    27      -8.137 -12.102  -4.667  1.00  0.00
ATOM    429  HZ2 TRP    27      -9.148 -12.004  -4.298  1.00  0.00
ATOM    430  CZ3 TRP    27      -6.182 -11.125  -5.699  1.00  0.00
ATOM    431  HZ3 TRP    27      -5.704 -10.246  -6.113  1.00  0.00
ATOM    432  CH2 TRP    27      -7.489 -11.021  -5.207  1.00  0.00
ATOM    433  HH2 TRP    27      -7.991 -10.060  -5.267  1.00  0.00
ATOM    434  C   TRP    27      -2.813 -16.314  -7.008  1.00  0.00
ATOM    435  O   TRP    27      -1.888 -15.520  -6.805  1.00  0.00
ATOM    436  N   TRP    28      -2.618 -17.549  -7.499  1.00  0.00
ATOM    437  HN  TRP    28      -3.388 -18.151  -7.573  1.00  0.00
ATOM    438  CA  TRP    28      -1.309 -18.047  -7.951  1.00  0.00
ATOM    439  HA  TRP    28      -0.524 -17.501  -7.429  1.00  0.00
ATOM    440  CB  TRP    28      -1.163 -19.564  -7.650  1.00  0.00
ATOM    441  HB1 TRP    28      -0.191 -19.902  -7.996  1.00  0.00
ATOM    442  HB2 TRP    28      -1.929 -20.106  -8.194  1.00  0.00
ATOM    443  CG  TRP    28      -1.297 -19.941  -6.191  1.00  0.00
ATOM    444  CD1 TRP    28      -2.412 -19.826  -5.411  1.00  0.00
ATOM    445  HD1 TRP    28      -3.365 -19.415  -5.743  1.00  0.00
ATOM    446  CD2 TRP    28      -0.291 -20.536  -5.349  1.00  0.00
ATOM    447  NE1 TRP    28      -2.155 -20.305  -4.159  1.00  0.00
ATOM    448  HE1 TRP    28      -2.801 -20.329  -3.422  1.00  0.00
ATOM    449  CE2 TRP    28      -0.869 -20.737  -4.089  1.00  0.00
ATOM    450  CE3 TRP    28       1.037 -20.908  -5.540  1.00  0.00
ATOM    451  HE3 TRP    28       1.520 -20.774  -6.499  1.00  0.00
ATOM    452  CZ2 TRP    28      -0.174 -21.298  -3.021  1.00  0.00
ATOM    453  HZ2 TRP    28      -0.632 -21.445  -2.052  1.00  0.00
ATOM    454  CZ3 TRP    28       1.731 -21.467  -4.485  1.00  0.00
ATOM    455  HZ3 TRP    28       2.764 -21.760  -4.617  1.00  0.00
ATOM    456  CH2 TRP    28       1.127 -21.653  -3.235  1.00  0.00
ATOM    457  HH2 TRP    28       1.710 -22.092  -2.434  1.00  0.00
ATOM    458  C   TRP    28      -1.162 -17.807  -9.463  1.00  0.00
ATOM    459  O   TRP    28      -2.148 -17.552 -10.168  1.00  0.00
ATOM    460  N   ALA    29       0.084 -17.865  -9.940  1.00  0.00
ATOM    461  HN  ALA    29       0.820 -17.910  -9.299  1.00  0.00
ATOM    462  CA  ALA    29       0.402 -17.858 -11.384  1.00  0.00
ATOM    463  HA  ALA    29      -0.268 -17.158 -11.880  1.00  0.00
ATOM    464  CB  ALA    29       1.851 -17.391 -11.618  1.00  0.00
ATOM    465  HB1 ALA    29       1.980 -16.392 -11.220  1.00  0.00
ATOM    466  HB2 ALA    29       2.066 -17.379 -12.680  1.00  0.00
ATOM    467  HB3 ALA    29       2.542 -18.065 -11.123  1.00  0.00
ATOM    468  C   ALA    29       0.186 -19.261 -11.971  1.00  0.00
ATOM    469  O   ALA    29       0.322 -20.257 -11.255  1.00  0.00
ATOM    470  N   ASP    30      -0.136 -19.337 -13.276  1.00  0.00
ATOM    471  HN  ASP    30      -0.232 -18.505 -13.787  1.00  0.00
ATOM    472  CA  ASP    30      -0.360 -20.632 -13.968  1.00  0.00
ATOM    473  HA  ASP    30      -1.069 -21.201 -13.371  1.00  0.00
ATOM    474  CB  ASP    30      -0.975 -20.409 -15.375  1.00  0.00
ATOM    475  HB1 ASP    30      -0.286 -19.812 -15.967  1.00  0.00
ATOM    476  HB2 ASP    30      -1.901 -19.854 -15.268  1.00  0.00
ATOM    477  CG  ASP    30      -1.287 -21.721 -16.139  1.00  0.00
ATOM    478  OD1 ASP    30      -0.682 -21.975 -17.205  1.00  0.00
ATOM    479  OD2 ASP    30      -2.136 -22.508 -15.671  1.00  0.00
ATOM    480  C   ASP    30       0.946 -21.444 -14.073  1.00  0.00
ATOM    481  O   ASP    30       0.921 -22.672 -14.123  1.00  0.00
ATOM    482  N   ASP    31       2.086 -20.743 -14.091  1.00  0.00
ATOM    483  HN  ASP    31       2.032 -19.765 -14.057  1.00  0.00
ATOM    484  CA  ASP    31       3.425 -21.361 -14.163  1.00  0.00
ATOM    485  HA  ASP    31       3.309 -22.413 -14.416  1.00  0.00
ATOM    486  CB  ASP    31       4.258 -20.668 -15.283  1.00  0.00
ATOM    487  HB1 ASP    31       3.670 -20.644 -16.196  1.00  0.00
ATOM    488  HB2 ASP    31       5.148 -21.261 -15.470  1.00  0.00
ATOM    489  CG  ASP    31       4.679 -19.220 -14.947  1.00  0.00
ATOM    490  OD1 ASP    31       5.893 -18.910 -14.968  1.00  0.00
ATOM    491  OD2 ASP    31       3.794 -18.390 -14.651  1.00  0.00
ATOM    492  C   ASP    31       4.145 -21.271 -12.798  1.00  0.00
ATOM    493  O   ASP    31       5.368 -21.436 -12.735  1.00  0.00
ATOM    494  N   CYS    32       3.372 -21.042 -11.708  1.00  0.00
ATOM    495  HN  CYS    32       2.397 -21.033 -11.820  1.00  0.00
ATOM    496  CA  CYS    32       3.929 -20.815 -10.357  1.00  0.00
ATOM    497  HA  CYS    32       4.586 -19.948 -10.425  1.00  0.00
ATOM    498  CB  CYS    32       2.822 -20.500  -9.334  1.00  0.00
ATOM    499  HB1 CYS    32       2.121 -21.327  -9.285  1.00  0.00
ATOM    500  HB2 CYS    32       2.292 -19.608  -9.643  1.00  0.00
ATOM    501  SG  CYS    32       3.442 -20.205  -7.661  1.00  0.00
ATOM    502  HG  CYS    32       3.893 -18.961  -7.609  1.00  0.00
ATOM    503  C   CYS    32       4.746 -22.018  -9.858  1.00  0.00
ATOM    504  O   CYS    32       4.315 -23.164  -9.982  1.00  0.00
ATOM    505  N   GLN    33       5.931 -21.735  -9.310  1.00  0.00
ATOM    506  HN  GLN    33       6.211 -20.795  -9.266  1.00  0.00
ATOM    507  CA  GLN    33       6.820 -22.757  -8.747  1.00  0.00
ATOM    508  HA  GLN    33       6.676 -23.687  -9.300  1.00  0.00
ATOM    509  CB  GLN    33       8.293 -22.308  -8.888  1.00  0.00
ATOM    510  HB1 GLN    33       8.940 -23.107  -8.534  1.00  0.00
ATOM    511  HB2 GLN    33       8.455 -21.432  -8.264  1.00  0.00
ATOM    512  CG  GLN    33       8.708 -21.948 -10.324  1.00  0.00
ATOM    513  HG1 GLN    33       9.714 -21.544 -10.306  1.00  0.00
ATOM    514  HG2 GLN    33       8.029 -21.185 -10.687  1.00  0.00
ATOM    515  CD  GLN    33       8.666 -23.115 -11.312  1.00  0.00
ATOM    516  OE1 GLN    33       9.627 -23.873 -11.448  1.00  0.00
ATOM    517  NE2 GLN    33       7.557 -23.249 -12.021  1.00  0.00
ATOM    518 HE21 GLN    33       6.829 -22.608 -11.869  1.00  0.00
ATOM    519 HE22 GLN    33       7.515 -23.970 -12.683  1.00  0.00
ATOM    520  C   GLN    33       6.458 -22.984  -7.273  1.00  0.00
ATOM    521  O   GLN    33       6.003 -22.058  -6.590  1.00  0.00
ATOM    522  N   TYR    34       6.660 -24.215  -6.795  1.00  0.00
ATOM    523  HN  TYR    34       7.018 -24.897  -7.399  1.00  0.00
ATOM    524  CA  TYR    34       6.366 -24.598  -5.412  1.00  0.00
ATOM    525  HA  TYR    34       6.364 -23.697  -4.801  1.00  0.00
ATOM    526  CB  TYR    34       4.974 -25.271  -5.320  1.00  0.00
ATOM    527  HB1 TYR    34       5.006 -26.231  -5.824  1.00  0.00
ATOM    528  HB2 TYR    34       4.250 -24.644  -5.830  1.00  0.00
ATOM    529  CG  TYR    34       4.468 -25.493  -3.889  1.00  0.00
ATOM    530  CD1 TYR    34       4.474 -26.760  -3.296  1.00  0.00
ATOM    531  HD1 TYR    34       4.842 -27.610  -3.864  1.00  0.00
ATOM    532  CD2 TYR    34       3.989 -24.416  -3.132  1.00  0.00
ATOM    533  HD2 TYR    34       3.970 -23.424  -3.573  1.00  0.00
ATOM    534  CE1 TYR    34       4.013 -26.943  -2.007  1.00  0.00
ATOM    535  HE1 TYR    34       4.024 -27.931  -1.565  1.00  0.00
ATOM    536  CE2 TYR    34       3.532 -24.598  -1.845  1.00  0.00
ATOM    537  HE2 TYR    34       3.165 -23.751  -1.278  1.00  0.00
ATOM    538  CZ  TYR    34       3.548 -25.860  -1.285  1.00  0.00
ATOM    539  OH  TYR    34       3.076 -26.040  -0.005  1.00  0.00
ATOM    540  HH  TYR    34       3.708 -26.559   0.500  1.00  0.00
ATOM    541  C   TYR    34       7.470 -25.531  -4.911  1.00  0.00
ATOM    542  O   TYR    34       7.623 -26.639  -5.427  1.00  0.00
ATOM    543  N   TYR    35       8.258 -25.050  -3.939  1.00  0.00
ATOM    544  HN  TYR    35       8.090 -24.143  -3.617  1.00  0.00
ATOM    545  CA  TYR    35       9.360 -25.806  -3.322  1.00  0.00
ATOM    546  HA  TYR    35       9.523 -26.709  -3.909  1.00  0.00
ATOM    547  CB  TYR    35      10.675 -24.980  -3.310  1.00  0.00
ATOM    548  HB1 TYR    35      11.435 -25.539  -2.770  1.00  0.00
ATOM    549  HB2 TYR    35      10.501 -24.053  -2.779  1.00  0.00
ATOM    550  CG  TYR    35      11.248 -24.622  -4.699  1.00  0.00
ATOM    551  CD1 TYR    35      12.419 -25.220  -5.176  1.00  0.00
ATOM    552  HD1 TYR    35      12.920 -25.960  -4.560  1.00  0.00
ATOM    553  CD2 TYR    35      10.630 -23.674  -5.519  1.00  0.00
ATOM    554  HD2 TYR    35       9.721 -23.191  -5.173  1.00  0.00
ATOM    555  CE1 TYR    35      12.942 -24.893  -6.412  1.00  0.00
ATOM    556  HE1 TYR    35      13.843 -25.374  -6.758  1.00  0.00
ATOM    557  CE2 TYR    35      11.150 -23.347  -6.756  1.00  0.00
ATOM    558  HE2 TYR    35      10.646 -22.616  -7.370  1.00  0.00
ATOM    559  CZ  TYR    35      12.306 -23.952  -7.197  1.00  0.00
ATOM    560  OH  TYR    35      12.820 -23.623  -8.433  1.00  0.00
ATOM    561  HH  TYR    35      13.041 -24.430  -8.909  1.00  0.00
ATOM    562  C   TYR    35       9.000 -26.224  -1.887  1.00  0.00
ATOM    563  O   TYR    35       8.172 -25.588  -1.222  1.00  0.00
ATOM    564  N   ALA    36       9.647 -27.307  -1.441  1.00  0.00
ATOM    565  HN  ALA    36      10.233 -27.776  -2.069  1.00  0.00
ATOM    566  CA  ALA    36       9.560 -27.833  -0.072  1.00  0.00
ATOM    567  HA  ALA    36       8.812 -27.261   0.480  1.00  0.00
ATOM    568  CB  ALA    36       9.131 -29.308  -0.103  1.00  0.00
ATOM    569  HB1 ALA    36       8.176 -29.395  -0.605  1.00  0.00
ATOM    570  HB2 ALA    36       9.038 -29.687   0.907  1.00  0.00
ATOM    571  HB3 ALA    36       9.868 -29.893  -0.640  1.00  0.00
ATOM    572  C   ALA    36      10.919 -27.677   0.619  1.00  0.00
ATOM    573  O   ALA    36      11.950 -27.634  -0.064  1.00  0.00
ATOM    574  N   PHE    37      10.898 -27.616   1.965  1.00  0.00
ATOM    575  HN  PHE    37      10.028 -27.690   2.410  1.00  0.00
ATOM    576  CA  PHE    37      12.100 -27.441   2.814  1.00  0.00
ATOM    577  HA  PHE    37      12.490 -26.449   2.624  1.00  0.00
ATOM    578  CB  PHE    37      11.685 -27.538   4.308  1.00  0.00
ATOM    579  HB1 PHE    37      11.206 -28.496   4.474  1.00  0.00
ATOM    580  HB2 PHE    37      10.960 -26.758   4.518  1.00  0.00
ATOM    581  CG  PHE    37      12.829 -27.390   5.318  1.00  0.00
ATOM    582  CD1 PHE    37      13.502 -26.179   5.459  1.00  0.00
ATOM    583  HD1 PHE    37      13.222 -25.338   4.834  1.00  0.00
ATOM    584  CD2 PHE    37      13.216 -28.454   6.136  1.00  0.00
ATOM    585  HD2 PHE    37      12.715 -29.408   6.039  1.00  0.00
ATOM    586  CE1 PHE    37      14.520 -26.033   6.380  1.00  0.00
ATOM    587  HE1 PHE    37      15.030 -25.081   6.474  1.00  0.00
ATOM    588  CE2 PHE    37      14.239 -28.307   7.056  1.00  0.00
ATOM    589  HE2 PHE    37      14.527 -29.141   7.681  1.00  0.00
ATOM    590  CZ  PHE    37      14.888 -27.095   7.179  1.00  0.00
ATOM    591  HZ  PHE    37      15.684 -26.978   7.901  1.00  0.00
ATOM    592  C   PHE    37      13.194 -28.502   2.500  1.00  0.00
ATOM    593  O   PHE    37      12.892 -29.697   2.556  1.00  0.00
ATOM    594  N   PRO    38      14.479 -28.106   2.177  1.00  0.00
ATOM    595  CA  PRO    38      14.924 -26.691   2.008  1.00  0.00
ATOM    596  HA  PRO    38      14.537 -26.075   2.819  1.00  0.00
ATOM    597  CB  PRO    38      16.467 -26.797   2.147  1.00  0.00
ATOM    598  HB1 PRO    38      16.750 -26.680   3.192  1.00  0.00
ATOM    599  HB2 PRO    38      16.955 -26.023   1.563  1.00  0.00
ATOM    600  CG  PRO    38      16.797 -28.171   1.643  1.00  0.00
ATOM    601  HG1 PRO    38      17.713 -28.531   2.101  1.00  0.00
ATOM    602  HG2 PRO    38      16.911 -28.148   0.562  1.00  0.00
ATOM    603  CD  PRO    38      15.623 -29.050   2.037  1.00  0.00
ATOM    604  HD1 PRO    38      15.819 -29.546   2.982  1.00  0.00
ATOM    605  HD2 PRO    38      15.416 -29.784   1.272  1.00  0.00
ATOM    606  C   PRO    38      14.491 -26.046   0.650  1.00  0.00
ATOM    607  O   PRO    38      13.769 -25.041   0.647  1.00  0.00
ATOM    608  N   ALA    39      14.901 -26.646  -0.492  1.00  0.00
ATOM    609  HN  ALA    39      15.417 -27.473  -0.427  1.00  0.00
ATOM    610  CA  ALA    39      14.593 -26.127  -1.842  1.00  0.00
ATOM    611  HA  ALA    39      13.665 -25.552  -1.792  1.00  0.00
ATOM    612  CB  ALA    39      15.713 -25.178  -2.326  1.00  0.00
ATOM    613  HB1 ALA    39      15.457 -24.768  -3.297  1.00  0.00
ATOM    614  HB2 ALA    39      16.645 -25.720  -2.403  1.00  0.00
ATOM    615  HB3 ALA    39      15.834 -24.365  -1.618  1.00  0.00
ATOM    616  C   ALA    39      14.388 -27.300  -2.818  1.00  0.00
ATOM    617  O   ALA    39      15.294 -27.665  -3.577  1.00  0.00
ATOM    618  N   THR    40      13.197 -27.913  -2.761  1.00  0.00
ATOM    619  HN  THR    40      12.521 -27.561  -2.142  1.00  0.00
ATOM    620  CA  THR    40      12.851 -29.096  -3.572  1.00  0.00
ATOM    621  HA  THR    40      13.657 -29.283  -4.280  1.00  0.00
ATOM    622  CB  THR    40      12.707 -30.356  -2.654  1.00  0.00
ATOM    623  HB  THR    40      11.946 -30.151  -1.903  1.00  0.00
ATOM    624  OG1 THR    40      13.957 -30.590  -1.979  1.00  0.00
ATOM    625  HG1 THR    40      13.879 -30.308  -1.067  1.00  0.00
ATOM    626  CG2 THR    40      12.296 -31.623  -3.435  1.00  0.00
ATOM    627 HG21 THR    40      13.015 -31.819  -4.220  1.00  0.00
ATOM    628 HG22 THR    40      11.315 -31.481  -3.876  1.00  0.00
ATOM    629 HG23 THR    40      12.264 -32.471  -2.765  1.00  0.00
ATOM    630  C   THR    40      11.555 -28.827  -4.355  1.00  0.00
ATOM    631  O   THR    40      10.466 -28.807  -3.771  1.00  0.00
ATOM    632  N   LEU    41      11.690 -28.604  -5.676  1.00  0.00
ATOM    633  HN  LEU    41      12.579 -28.711  -6.077  1.00  0.00
ATOM    634  CA  LEU    41      10.568 -28.232  -6.559  1.00  0.00
ATOM    635  HA  LEU    41      10.075 -27.367  -6.120  1.00  0.00
ATOM    636  CB  LEU    41      11.113 -27.835  -7.964  1.00  0.00
ATOM    637  HB1 LEU    41      11.598 -28.707  -8.395  1.00  0.00
ATOM    638  HB2 LEU    41      11.871 -27.070  -7.827  1.00  0.00
ATOM    639  CG  LEU    41      10.063 -27.304  -8.992  1.00  0.00
ATOM    640  HG  LEU    41       9.269 -28.028  -9.069  1.00  0.00
ATOM    641  CD1 LEU    41       9.414 -25.991  -8.514  1.00  0.00
ATOM    642 HD11 LEU    41      10.169 -25.224  -8.402  1.00  0.00
ATOM    643 HD12 LEU    41       8.924 -26.152  -7.563  1.00  0.00
ATOM    644 HD13 LEU    41       8.676 -25.665  -9.237  1.00  0.00
ATOM    645  CD2 LEU    41      10.680 -27.145 -10.400  1.00  0.00
ATOM    646 HD21 LEU    41      11.474 -26.407 -10.375  1.00  0.00
ATOM    647 HD22 LEU    41       9.918 -26.826 -11.099  1.00  0.00
ATOM    648 HD23 LEU    41      11.084 -28.094 -10.729  1.00  0.00
ATOM    649  C   LEU    41       9.549 -29.387  -6.673  1.00  0.00
ATOM    650  O   LEU    41       9.794 -30.377  -7.366  1.00  0.00
ATOM    651  N   LEU    42       8.424 -29.257  -5.947  1.00  0.00
ATOM    652  HN  LEU    42       8.353 -28.502  -5.331  1.00  0.00
ATOM    653  CA  LEU    42       7.306 -30.217  -6.004  1.00  0.00
ATOM    654  HA  LEU    42       7.720 -31.215  -6.065  1.00  0.00
ATOM    655  CB  LEU    42       6.422 -30.119  -4.726  1.00  0.00
ATOM    656  HB1 LEU    42       5.673 -30.904  -4.778  1.00  0.00
ATOM    657  HB2 LEU    42       5.906 -29.161  -4.745  1.00  0.00
ATOM    658  CG  LEU    42       7.155 -30.235  -3.352  1.00  0.00
ATOM    659  HG  LEU    42       7.771 -29.352  -3.218  1.00  0.00
ATOM    660  CD1 LEU    42       6.145 -30.250  -2.183  1.00  0.00
ATOM    661 HD11 LEU    42       5.491 -31.112  -2.265  1.00  0.00
ATOM    662 HD12 LEU    42       5.550 -29.348  -2.206  1.00  0.00
ATOM    663 HD13 LEU    42       6.679 -30.295  -1.243  1.00  0.00
ATOM    664  CD2 LEU    42       8.099 -31.459  -3.304  1.00  0.00
ATOM    665 HD21 LEU    42       8.577 -31.515  -2.336  1.00  0.00
ATOM    666 HD22 LEU    42       8.861 -31.355  -4.065  1.00  0.00
ATOM    667 HD23 LEU    42       7.537 -32.369  -3.483  1.00  0.00
ATOM    668  C   LEU    42       6.434 -29.958  -7.246  1.00  0.00
ATOM    669  O   LEU    42       5.915 -30.902  -7.860  1.00  0.00
ATOM    670  N   ALA    43       6.281 -28.670  -7.605  1.00  0.00
ATOM    671  HN  ALA    43       6.814 -27.988  -7.142  1.00  0.00
ATOM    672  CA  ALA    43       5.338 -28.239  -8.656  1.00  0.00
ATOM    673  HA  ALA    43       5.126 -29.084  -9.309  1.00  0.00
ATOM    674  CB  ALA    43       4.025 -27.815  -7.996  1.00  0.00
ATOM    675  HB1 ALA    43       3.306 -27.524  -8.754  1.00  0.00
ATOM    676  HB2 ALA    43       4.205 -26.979  -7.333  1.00  0.00
ATOM    677  HB3 ALA    43       3.620 -28.641  -7.424  1.00  0.00
ATOM    678  C   ALA    43       5.919 -27.088  -9.495  1.00  0.00
ATOM    679  O   ALA    43       6.235 -26.030  -8.953  1.00  0.00
ATOM    680  N   GLY    44       6.037 -27.307 -10.819  1.00  0.00
ATOM    681  HN  GLY    44       5.759 -28.179 -11.171  1.00  0.00
ATOM    682  CA  GLY    44       6.553 -26.303 -11.758  1.00  0.00
ATOM    683  HA1 GLY    44       7.207 -26.802 -12.463  1.00  0.00
ATOM    684  HA2 GLY    44       7.132 -25.564 -11.218  1.00  0.00
ATOM    685  C   GLY    44       5.441 -25.590 -12.533  1.00  0.00
ATOM    686  O   GLY    44       5.641 -25.190 -13.688  1.00  0.00
ATOM    687  N   ASN    45       4.307 -25.374 -11.842  1.00  0.00
ATOM    688  HN  ASN    45       4.350 -25.502 -10.870  1.00  0.00
ATOM    689  CA  ASN    45       3.029 -24.853 -12.409  1.00  0.00
ATOM    690  HA  ASN    45       3.173 -23.789 -12.573  1.00  0.00
ATOM    691  CB  ASN    45       2.606 -25.511 -13.767  1.00  0.00
ATOM    692  HB1 ASN    45       3.409 -25.382 -14.484  1.00  0.00
ATOM    693  HB2 ASN    45       1.735 -24.993 -14.147  1.00  0.00
ATOM    694  CG  ASN    45       2.271 -27.002 -13.667  1.00  0.00
ATOM    695  OD1 ASN    45       1.137 -27.384 -13.375  1.00  0.00
ATOM    696  ND2 ASN    45       3.246 -27.850 -13.945  1.00  0.00
ATOM    697 HD21 ASN    45       4.118 -27.483 -14.196  1.00  0.00
ATOM    698 HD22 ASN    45       3.059 -28.809 -13.885  1.00  0.00
ATOM    699  C   ASN    45       1.893 -25.018 -11.376  1.00  0.00
ATOM    700  O   ASN    45       1.989 -25.849 -10.466  1.00  0.00
ATOM    701  N   ALA    46       0.798 -24.256 -11.582  1.00  0.00
ATOM    702  HN  ALA    46       0.750 -23.746 -12.414  1.00  0.00
ATOM    703  CA  ALA    46      -0.338 -24.151 -10.638  1.00  0.00
ATOM    704  HA  ALA    46       0.060 -23.852  -9.672  1.00  0.00
ATOM    705  CB  ALA    46      -1.298 -23.046 -11.110  1.00  0.00
ATOM    706  HB1 ALA    46      -2.094 -22.908 -10.387  1.00  0.00
ATOM    707  HB2 ALA    46      -1.728 -23.316 -12.068  1.00  0.00
ATOM    708  HB3 ALA    46      -0.757 -22.114 -11.218  1.00  0.00
ATOM    709  C   ALA    46      -1.103 -25.482 -10.467  1.00  0.00
ATOM    710  O   ALA    46      -1.540 -25.816  -9.361  1.00  0.00
ATOM    711  N   ALA    47      -1.235 -26.238 -11.569  1.00  0.00
ATOM    712  HN  ALA    47      -0.755 -25.965 -12.382  1.00  0.00
ATOM    713  CA  ALA    47      -2.052 -27.468 -11.611  1.00  0.00
ATOM    714  HA  ALA    47      -3.072 -27.190 -11.352  1.00  0.00
ATOM    715  CB  ALA    47      -2.072 -28.062 -13.023  1.00  0.00
ATOM    716  HB1 ALA    47      -1.077 -28.410 -13.288  1.00  0.00
ATOM    717  HB2 ALA    47      -2.388 -27.309 -13.732  1.00  0.00
ATOM    718  HB3 ALA    47      -2.766 -28.896 -13.059  1.00  0.00
ATOM    719  C   ALA    47      -1.556 -28.516 -10.610  1.00  0.00
ATOM    720  O   ALA    47      -2.352 -29.223  -9.997  1.00  0.00
ATOM    721  N   GLU    48      -0.233 -28.614 -10.469  1.00  0.00
ATOM    722  HN  GLU    48       0.342 -28.017 -11.000  1.00  0.00
ATOM    723  CA  GLU    48       0.402 -29.568  -9.545  1.00  0.00
ATOM    724  HA  GLU    48      -0.139 -30.512  -9.619  1.00  0.00
ATOM    725  CB  GLU    48       1.867 -29.812  -9.970  1.00  0.00
ATOM    726  HB1 GLU    48       2.267 -30.649  -9.402  1.00  0.00
ATOM    727  HB2 GLU    48       2.450 -28.928  -9.739  1.00  0.00
ATOM    728  CG  GLU    48       2.051 -30.115 -11.465  1.00  0.00
ATOM    729  HG1 GLU    48       1.758 -29.236 -12.036  1.00  0.00
ATOM    730  HG2 GLU    48       1.391 -30.934 -11.741  1.00  0.00
ATOM    731  CD  GLU    48       3.504 -30.470 -11.823  1.00  0.00
ATOM    732  OE1 GLU    48       4.355 -29.560 -11.862  1.00  0.00
ATOM    733  OE2 GLU    48       3.797 -31.653 -12.083  1.00  0.00
ATOM    734  C   GLU    48       0.311 -29.068  -8.083  1.00  0.00
ATOM    735  O   GLU    48       0.176 -29.872  -7.152  1.00  0.00
ATOM    736  N   ILE    49       0.366 -27.724  -7.907  1.00  0.00
ATOM    737  HN  ILE    49       0.462 -27.157  -8.704  1.00  0.00
ATOM    738  CA  ILE    49       0.289 -27.064  -6.580  1.00  0.00
ATOM    739  HA  ILE    49       1.096 -27.457  -5.965  1.00  0.00
ATOM    740  CB  ILE    49       0.469 -25.495  -6.690  1.00  0.00
ATOM    741  HB  ILE    49      -0.315 -25.121  -7.346  1.00  0.00
ATOM    742  CG1 ILE    49       1.846 -25.144  -7.321  1.00  0.00
ATOM    743 HG11 ILE    49       1.937 -25.649  -8.277  1.00  0.00
ATOM    744 HG12 ILE    49       2.634 -25.501  -6.672  1.00  0.00
ATOM    745  CG2 ILE    49       0.297 -24.792  -5.316  1.00  0.00
ATOM    746 HG21 ILE    49       1.051 -25.147  -4.623  1.00  0.00
ATOM    747 HG22 ILE    49      -0.685 -25.006  -4.913  1.00  0.00
ATOM    748 HG23 ILE    49       0.399 -23.721  -5.439  1.00  0.00
ATOM    749  CD1 ILE    49       2.103 -23.670  -7.561  1.00  0.00
ATOM    750 HD11 ILE    49       1.338 -23.263  -8.208  1.00  0.00
ATOM    751 HD12 ILE    49       3.069 -23.547  -8.031  1.00  0.00
ATOM    752 HD13 ILE    49       2.098 -23.141  -6.619  1.00  0.00
ATOM    753  C   ILE    49      -1.055 -27.367  -5.898  1.00  0.00
ATOM    754  O   ILE    49      -1.088 -27.781  -4.727  1.00  0.00
ATOM    755  N   ARG    50      -2.158 -27.149  -6.646  1.00  0.00
ATOM    756  HN  ARG    50      -2.046 -26.855  -7.582  1.00  0.00
ATOM    757  CA  ARG    50      -3.520 -27.338  -6.116  1.00  0.00
ATOM    758  HA  ARG    50      -3.600 -26.716  -5.224  1.00  0.00
ATOM    759  CB  ARG    50      -4.611 -26.869  -7.122  1.00  0.00
ATOM    760  HB1 ARG    50      -4.481 -25.804  -7.291  1.00  0.00
ATOM    761  HB2 ARG    50      -5.590 -27.021  -6.675  1.00  0.00
ATOM    762  CG  ARG    50      -4.592 -27.580  -8.493  1.00  0.00
ATOM    763  HG1 ARG    50      -4.813 -28.633  -8.340  1.00  0.00
ATOM    764  HG2 ARG    50      -3.598 -27.490  -8.915  1.00  0.00
ATOM    765  CD  ARG    50      -5.596 -27.004  -9.492  1.00  0.00
ATOM    766  HD1 ARG    50      -5.375 -25.950  -9.646  1.00  0.00
ATOM    767  HD2 ARG    50      -6.595 -27.100  -9.080  1.00  0.00
ATOM    768  NE  ARG    50      -5.558 -27.703 -10.798  1.00  0.00
ATOM    769  HE  ARG    50      -5.351 -28.667 -10.777  1.00  0.00
ATOM    770  CZ  ARG    50      -5.793 -27.131 -11.995  1.00  0.00
ATOM    771  NH1 ARG    50      -6.067 -25.835 -12.087  1.00  0.00
ATOM    772 HH11 ARG    50      -6.107 -25.271 -11.264  1.00  0.00
ATOM    773 HH12 ARG    50      -6.224 -25.413 -12.988  1.00  0.00
ATOM    774  NH2 ARG    50      -5.749 -27.866 -13.097  1.00  0.00
ATOM    775 HH21 ARG    50      -5.543 -28.847 -13.045  1.00  0.00
ATOM    776 HH22 ARG    50      -5.925 -27.449 -13.992  1.00  0.00
ATOM    777  C   ARG    50      -3.740 -28.803  -5.705  1.00  0.00
ATOM    778  O   ARG    50      -4.128 -29.045  -4.574  1.00  0.00
ATOM    779  N   VAL    51      -3.408 -29.760  -6.610  1.00  0.00
ATOM    780  HN  VAL    51      -2.984 -29.477  -7.452  1.00  0.00
ATOM    781  CA  VAL    51      -3.637 -31.211  -6.391  1.00  0.00
ATOM    782  HA  VAL    51      -4.704 -31.352  -6.235  1.00  0.00
ATOM    783  CB  VAL    51      -3.214 -32.066  -7.648  1.00  0.00
ATOM    784  HB  VAL    51      -2.162 -31.866  -7.847  1.00  0.00
ATOM    785  CG1 VAL    51      -3.369 -33.593  -7.393  1.00  0.00
ATOM    786 HG11 VAL    51      -4.403 -33.823  -7.163  1.00  0.00
ATOM    787 HG12 VAL    51      -2.745 -33.892  -6.559  1.00  0.00
ATOM    788 HG13 VAL    51      -3.067 -34.144  -8.275  1.00  0.00
ATOM    789  CG2 VAL    51      -4.019 -31.637  -8.900  1.00  0.00
ATOM    790 HG21 VAL    51      -5.072 -31.835  -8.747  1.00  0.00
ATOM    791 HG22 VAL    51      -3.674 -32.188  -9.766  1.00  0.00
ATOM    792 HG23 VAL    51      -3.881 -30.576  -9.080  1.00  0.00
ATOM    793  C   VAL    51      -2.891 -31.695  -5.136  1.00  0.00
ATOM    794  O   VAL    51      -3.461 -32.419  -4.314  1.00  0.00
ATOM    795  N   ARG    52      -1.635 -31.228  -4.987  1.00  0.00
ATOM    796  HN  ARG    52      -1.264 -30.665  -5.700  1.00  0.00
ATOM    797  CA  ARG    52      -0.787 -31.528  -3.816  1.00  0.00
ATOM    798  HA  ARG    52      -0.610 -32.599  -3.805  1.00  0.00
ATOM    799  CB  ARG    52       0.581 -30.793  -3.923  1.00  0.00
ATOM    800  HB1 ARG    52       0.399 -29.724  -3.949  1.00  0.00
ATOM    801  HB2 ARG    52       1.051 -31.077  -4.858  1.00  0.00
ATOM    802  CG  ARG    52       1.589 -31.090  -2.777  1.00  0.00
ATOM    803  HG1 ARG    52       1.032 -31.227  -1.851  1.00  0.00
ATOM    804  HG2 ARG    52       2.244 -30.234  -2.662  1.00  0.00
ATOM    805  CD  ARG    52       2.462 -32.347  -3.023  1.00  0.00
ATOM    806  HD1 ARG    52       3.163 -32.435  -2.209  1.00  0.00
ATOM    807  HD2 ARG    52       3.018 -32.207  -3.944  1.00  0.00
ATOM    808  NE  ARG    52       1.695 -33.613  -3.138  1.00  0.00
ATOM    809  HE  ARG    52       0.724 -33.541  -3.267  1.00  0.00
ATOM    810  CZ  ARG    52       2.234 -34.846  -3.134  1.00  0.00
ATOM    811  NH1 ARG    52       3.523 -35.031  -2.888  1.00  0.00
ATOM    812 HH11 ARG    52       4.121 -34.248  -2.699  1.00  0.00
ATOM    813 HH12 ARG    52       3.910 -35.958  -2.895  1.00  0.00
ATOM    814  NH2 ARG    52       1.462 -35.896  -3.349  1.00  0.00
ATOM    815 HH21 ARG    52       0.479 -35.774  -3.517  1.00  0.00
ATOM    816 HH22 ARG    52       1.850 -36.820  -3.358  1.00  0.00
ATOM    817  C   ARG    52      -1.503 -31.133  -2.509  1.00  0.00
ATOM    818  O   ARG    52      -1.497 -31.883  -1.526  1.00  0.00
ATOM    819  N   HIS    53      -2.128 -29.944  -2.525  1.00  0.00
ATOM    820  HN  HIS    53      -2.103 -29.412  -3.355  1.00  0.00
ATOM    821  CA  HIS    53      -2.855 -29.406  -1.362  1.00  0.00
ATOM    822  HA  HIS    53      -2.267 -29.645  -0.476  1.00  0.00
ATOM    823  CB  HIS    53      -2.965 -27.871  -1.457  1.00  0.00
ATOM    824  HB1 HIS    53      -3.635 -27.503  -0.681  1.00  0.00
ATOM    825  HB2 HIS    53      -3.366 -27.600  -2.427  1.00  0.00
ATOM    826  CG  HIS    53      -1.648 -27.161  -1.283  1.00  0.00
ATOM    827  ND1 HIS    53      -1.079 -26.368  -2.258  1.00  0.00
ATOM    828  HD1 HIS    53      -1.440 -26.224  -3.161  1.00  0.00
ATOM    829  CD2 HIS    53      -0.817 -27.093  -0.214  1.00  0.00
ATOM    830  HD2 HIS    53      -0.952 -27.596   0.738  1.00  0.00
ATOM    831  CE1 HIS    53       0.038 -25.842  -1.797  1.00  0.00
ATOM    832  HE1 HIS    53       0.695 -25.175  -2.338  1.00  0.00
ATOM    833  NE2 HIS    53       0.216 -26.263  -0.560  1.00  0.00
ATOM    834  HE2 HIS    53       0.983 -26.034   0.015  1.00  0.00
ATOM    835  C   HIS    53      -4.242 -30.048  -1.190  1.00  0.00
ATOM    836  O   HIS    53      -4.702 -30.155  -0.073  1.00  0.00
ATOM    837  N   ILE    54      -4.888 -30.480  -2.288  1.00  0.00
ATOM    838  HN  ILE    54      -4.454 -30.385  -3.158  1.00  0.00
ATOM    839  CA  ILE    54      -6.223 -31.128  -2.237  1.00  0.00
ATOM    840  HA  ILE    54      -6.912 -30.438  -1.750  1.00  0.00
ATOM    841  CB  ILE    54      -6.754 -31.421  -3.692  1.00  0.00
ATOM    842  HB  ILE    54      -5.970 -31.954  -4.221  1.00  0.00
ATOM    843  CG1 ILE    54      -7.043 -30.094  -4.455  1.00  0.00
ATOM    844 HG11 ILE    54      -6.175 -29.451  -4.396  1.00  0.00
ATOM    845 HG12 ILE    54      -7.875 -29.586  -3.988  1.00  0.00
ATOM    846  CG2 ILE    54      -8.005 -32.322  -3.689  1.00  0.00
ATOM    847 HG21 ILE    54      -8.326 -32.509  -4.706  1.00  0.00
ATOM    848 HG22 ILE    54      -8.805 -31.837  -3.149  1.00  0.00
ATOM    849 HG23 ILE    54      -7.775 -33.267  -3.209  1.00  0.00
ATOM    850  CD1 ILE    54      -7.383 -30.256  -5.923  1.00  0.00
ATOM    851 HD11 ILE    54      -6.574 -30.774  -6.425  1.00  0.00
ATOM    852 HD12 ILE    54      -7.516 -29.281  -6.368  1.00  0.00
ATOM    853 HD13 ILE    54      -8.294 -30.825  -6.023  1.00  0.00
ATOM    854  C   ILE    54      -6.139 -32.425  -1.408  1.00  0.00
ATOM    855  O   ILE    54      -7.042 -32.737  -0.627  1.00  0.00
ATOM    856  N   GLU    55      -5.011 -33.137  -1.584  1.00  0.00
ATOM    857  HN  GLU    55      -4.387 -32.842  -2.287  1.00  0.00
ATOM    858  CA  GLU    55      -4.661 -34.337  -0.799  1.00  0.00
ATOM    859  HA  GLU    55      -5.442 -35.081  -0.961  1.00  0.00
ATOM    860  CB  GLU    55      -3.309 -34.900  -1.311  1.00  0.00
ATOM    861  HB1 GLU    55      -3.057 -35.796  -0.746  1.00  0.00
ATOM    862  HB2 GLU    55      -2.533 -34.154  -1.141  1.00  0.00
ATOM    863  CG  GLU    55      -3.303 -35.260  -2.811  1.00  0.00
ATOM    864  HG1 GLU    55      -3.646 -34.396  -3.377  1.00  0.00
ATOM    865  HG2 GLU    55      -3.998 -36.075  -2.980  1.00  0.00
ATOM    866  CD  GLU    55      -1.912 -35.671  -3.321  1.00  0.00
ATOM    867  OE1 GLU    55      -1.504 -36.835  -3.108  1.00  0.00
ATOM    868  OE2 GLU    55      -1.201 -34.826  -3.908  1.00  0.00
ATOM    869  C   GLU    55      -4.589 -34.001   0.707  1.00  0.00
ATOM    870  O   GLU    55      -5.053 -34.776   1.547  1.00  0.00
ATOM    871  N   ARG    56      -4.022 -32.822   1.019  1.00  0.00
ATOM    872  HN  ARG    56      -3.640 -32.283   0.290  1.00  0.00
ATOM    873  CA  ARG    56      -3.933 -32.309   2.403  1.00  0.00
ATOM    874  HA  ARG    56      -3.552 -33.117   3.025  1.00  0.00
ATOM    875  CB  ARG    56      -2.925 -31.123   2.465  1.00  0.00
ATOM    876  HB1 ARG    56      -3.324 -30.300   1.880  1.00  0.00
ATOM    877  HB2 ARG    56      -1.991 -31.438   2.009  1.00  0.00
ATOM    878  CG  ARG    56      -2.610 -30.595   3.886  1.00  0.00
ATOM    879  HG1 ARG    56      -3.521 -30.187   4.312  1.00  0.00
ATOM    880  HG2 ARG    56      -1.874 -29.805   3.809  1.00  0.00
ATOM    881  CD  ARG    56      -2.065 -31.690   4.833  1.00  0.00
ATOM    882  HD1 ARG    56      -2.833 -32.446   4.967  1.00  0.00
ATOM    883  HD2 ARG    56      -1.841 -31.244   5.798  1.00  0.00
ATOM    884  NE  ARG    56      -0.838 -32.328   4.315  1.00  0.00
ATOM    885  HE  ARG    56      -0.259 -31.772   3.752  1.00  0.00
ATOM    886  CZ  ARG    56      -0.454 -33.590   4.565  1.00  0.00
ATOM    887  NH1 ARG    56      -1.223 -34.418   5.262  1.00  0.00
ATOM    888 HH11 ARG    56      -2.117 -34.112   5.603  1.00  0.00
ATOM    889 HH12 ARG    56      -0.919 -35.355   5.446  1.00  0.00
ATOM    890  NH2 ARG    56       0.694 -34.032   4.076  1.00  0.00
ATOM    891 HH21 ARG    56       1.269 -33.433   3.517  1.00  0.00
ATOM    892 HH22 ARG    56       0.996 -34.974   4.261  1.00  0.00
ATOM    893  C   ARG    56      -5.334 -31.891   2.936  1.00  0.00
ATOM    894  O   ARG    56      -5.620 -32.033   4.128  1.00  0.00
ATOM    895  N   PHE    57      -6.204 -31.392   2.029  1.00  0.00
ATOM    896  HN  PHE    57      -5.910 -31.324   1.097  1.00  0.00
ATOM    897  CA  PHE    57      -7.585 -30.948   2.363  1.00  0.00
ATOM    898  HA  PHE    57      -7.532 -30.378   3.288  1.00  0.00
ATOM    899  CB  PHE    57      -8.155 -30.015   1.240  1.00  0.00
ATOM    900  HB1 PHE    57      -9.239 -29.995   1.315  1.00  0.00
ATOM    901  HB2 PHE    57      -7.892 -30.433   0.277  1.00  0.00
ATOM    902  CG  PHE    57      -7.661 -28.555   1.239  1.00  0.00
ATOM    903  CD1 PHE    57      -6.323 -28.234   1.443  1.00  0.00
ATOM    904  HD1 PHE    57      -5.612 -29.028   1.633  1.00  0.00
ATOM    905  CD2 PHE    57      -8.549 -27.500   0.998  1.00  0.00
ATOM    906  HD2 PHE    57      -9.600 -27.716   0.836  1.00  0.00
ATOM    907  CE1 PHE    57      -5.887 -26.925   1.408  1.00  0.00
ATOM    908  HE1 PHE    57      -4.841 -26.702   1.568  1.00  0.00
ATOM    909  CE2 PHE    57      -8.111 -26.188   0.969  1.00  0.00
ATOM    910  HE2 PHE    57      -8.813 -25.386   0.782  1.00  0.00
ATOM    911  CZ  PHE    57      -6.779 -25.904   1.172  1.00  0.00
ATOM    912  HZ  PHE    57      -6.434 -24.879   1.146  1.00  0.00
ATOM    913  C   PHE    57      -8.536 -32.152   2.606  1.00  0.00
ATOM    914  O   PHE    57      -9.682 -31.953   3.023  1.00  0.00
ATOM    915  N   LYS    58      -8.074 -33.393   2.318  1.00  0.00
ATOM    916  HN  LYS    58      -7.206 -33.481   1.866  1.00  0.00
ATOM    917  CA  LYS    58      -8.839 -34.627   2.627  1.00  0.00
ATOM    918  HA  LYS    58      -9.859 -34.477   2.281  1.00  0.00
ATOM    919  CB  LYS    58      -8.243 -35.850   1.885  1.00  0.00
ATOM    920  HB1 LYS    58      -8.840 -36.730   2.113  1.00  0.00
ATOM    921  HB2 LYS    58      -7.231 -36.015   2.245  1.00  0.00
ATOM    922  CG  LYS    58      -8.181 -35.689   0.356  1.00  0.00
ATOM    923  HG1 LYS    58      -7.812 -36.613  -0.078  1.00  0.00
ATOM    924  HG2 LYS    58      -7.483 -34.889   0.124  1.00  0.00
ATOM    925  CD  LYS    58      -9.552 -35.346  -0.276  1.00  0.00
ATOM    926  HD1 LYS    58      -9.987 -34.502   0.249  1.00  0.00
ATOM    927  HD2 LYS    58     -10.211 -36.201  -0.182  1.00  0.00
ATOM    928  CE  LYS    58      -9.426 -34.987  -1.757  1.00  0.00
ATOM    929  HE1 LYS    58      -9.070 -35.848  -2.300  1.00  0.00
ATOM    930  HE2 LYS    58      -8.711 -34.181  -1.866  1.00  0.00
ATOM    931  NZ  LYS    58     -10.715 -34.548  -2.334  1.00  0.00
ATOM    932  HZ1 LYS    58     -11.058 -33.699  -1.837  1.00  0.00
ATOM    933  HZ2 LYS    58     -11.426 -35.302  -2.237  1.00  0.00
ATOM    934  HZ3 LYS    58     -10.596 -34.324  -3.338  1.00  0.00
ATOM    935  C   LYS    58      -8.880 -34.902   4.139  1.00  0.00
ATOM    936  O   LYS    58      -9.810 -35.558   4.624  1.00  0.00
ATOM    937  N   GLU    59      -7.848 -34.424   4.866  1.00  0.00
ATOM    938  HN  GLU    59      -7.096 -34.001   4.395  1.00  0.00
ATOM    939  CA  GLU    59      -7.802 -34.505   6.334  1.00  0.00
ATOM    940  HA  GLU    59      -8.011 -35.534   6.612  1.00  0.00
ATOM    941  CB  GLU    59      -6.395 -34.117   6.888  1.00  0.00
ATOM    942  HB1 GLU    59      -6.483 -33.914   7.951  1.00  0.00
ATOM    943  HB2 GLU    59      -6.068 -33.205   6.395  1.00  0.00
ATOM    944  CG  GLU    59      -5.294 -35.190   6.700  1.00  0.00
ATOM    945  HG1 GLU    59      -5.636 -36.116   7.159  1.00  0.00
ATOM    946  HG2 GLU    59      -4.403 -34.863   7.228  1.00  0.00
ATOM    947  CD  GLU    59      -4.917 -35.468   5.229  1.00  0.00
ATOM    948  OE1 GLU    59      -5.500 -36.392   4.608  1.00  0.00
ATOM    949  OE2 GLU    59      -4.030 -34.772   4.698  1.00  0.00
ATOM    950  C   GLU    59      -8.893 -33.597   6.933  1.00  0.00
ATOM    951  O   GLU    59      -8.849 -32.384   6.724  1.00  0.00
ATOM    952  N   PRO    60      -9.906 -34.161   7.674  1.00  0.00
ATOM    953  CA  PRO    60     -10.942 -33.342   8.356  1.00  0.00
ATOM    954  HA  PRO    60     -11.427 -32.665   7.661  1.00  0.00
ATOM    955  CB  PRO    60     -11.959 -34.398   8.862  1.00  0.00
ATOM    956  HB1 PRO    60     -12.746 -34.531   8.122  1.00  0.00
ATOM    957  HB2 PRO    60     -12.407 -34.076   9.797  1.00  0.00
ATOM    958  CG  PRO    60     -11.148 -35.653   9.029  1.00  0.00
ATOM    959  HG1 PRO    60     -11.783 -36.527   8.927  1.00  0.00
ATOM    960  HG2 PRO    60     -10.668 -35.659  10.006  1.00  0.00
ATOM    961  CD  PRO    60     -10.112 -35.619   7.924  1.00  0.00
ATOM    962  HD1 PRO    60     -10.484 -36.107   7.030  1.00  0.00
ATOM    963  HD2 PRO    60      -9.189 -36.089   8.251  1.00  0.00
ATOM    964  C   PRO    60     -10.324 -32.526   9.518  1.00  0.00
ATOM    965  O   PRO    60     -10.854 -31.489   9.933  1.00  0.00
ATOM    966  N   ASP    61      -9.169 -33.022   9.991  1.00  0.00
ATOM    967  HN  ASP    61      -8.815 -33.826   9.561  1.00  0.00
ATOM    968  CA  ASP    61      -8.383 -32.455  11.093  1.00  0.00
ATOM    969  HA  ASP    61      -9.070 -32.015  11.810  1.00  0.00
ATOM    970  CB  ASP    61      -7.609 -33.601  11.794  1.00  0.00
ATOM    971  HB1 ASP    61      -8.322 -34.253  12.287  1.00  0.00
ATOM    972  HB2 ASP    61      -6.956 -33.183  12.556  1.00  0.00
ATOM    973  CG  ASP    61      -6.756 -34.455  10.824  1.00  0.00
ATOM    974  OD1 ASP    61      -5.547 -34.192  10.674  1.00  0.00
ATOM    975  OD2 ASP    61      -7.305 -35.406  10.215  1.00  0.00
ATOM    976  C   ASP    61      -7.413 -31.352  10.623  1.00  0.00
ATOM    977  O   ASP    61      -6.754 -30.720  11.462  1.00  0.00
ATOM    978  N   LEU    62      -7.318 -31.129   9.291  1.00  0.00
ATOM    979  HN  LEU    62      -7.811 -31.708   8.679  1.00  0.00
ATOM    980  CA  LEU    62      -6.494 -30.040   8.727  1.00  0.00
ATOM    981  HA  LEU    62      -5.474 -30.172   9.090  1.00  0.00
ATOM    982  CB  LEU    62      -6.475 -30.062   7.168  1.00  0.00
ATOM    983  HB1 LEU    62      -7.502 -30.058   6.817  1.00  0.00
ATOM    984  HB2 LEU    62      -6.010 -30.990   6.844  1.00  0.00
ATOM    985  CG  LEU    62      -5.719 -28.856   6.503  1.00  0.00
ATOM    986  HG  LEU    62      -6.098 -27.939   6.942  1.00  0.00
ATOM    987  CD1 LEU    62      -4.214 -28.898   6.824  1.00  0.00
ATOM    988 HD11 LEU    62      -3.776 -29.810   6.436  1.00  0.00
ATOM    989 HD12 LEU    62      -4.069 -28.860   7.897  1.00  0.00
ATOM    990 HD13 LEU    62      -3.724 -28.045   6.374  1.00  0.00
ATOM    991  CD2 LEU    62      -5.976 -28.767   4.987  1.00  0.00
ATOM    992 HD21 LEU    62      -5.614 -29.663   4.497  1.00  0.00
ATOM    993 HD22 LEU    62      -5.466 -27.904   4.578  1.00  0.00
ATOM    994 HD23 LEU    62      -7.039 -28.667   4.805  1.00  0.00
ATOM    995  C   LEU    62      -7.024 -28.673   9.193  1.00  0.00
ATOM    996  O   LEU    62      -8.181 -28.332   8.930  1.00  0.00
ATOM    997  N   TYR    63      -6.169 -27.902   9.876  1.00  0.00
ATOM    998  HN  TYR    63      -5.303 -28.282  10.141  1.00  0.00
ATOM    999  CA  TYR    63      -6.484 -26.522  10.257  1.00  0.00
ATOM   1000  HA  TYR    63      -7.120 -26.093   9.484  1.00  0.00
ATOM   1001  CB  TYR    63      -7.248 -26.497  11.610  1.00  0.00
ATOM   1002  HB1 TYR    63      -6.596 -26.860  12.393  1.00  0.00
ATOM   1003  HB2 TYR    63      -8.108 -27.157  11.545  1.00  0.00
ATOM   1004  CG  TYR    63      -7.756 -25.106  12.011  1.00  0.00
ATOM   1005  CD1 TYR    63      -8.895 -24.564  11.412  1.00  0.00
ATOM   1006  HD1 TYR    63      -9.432 -25.148  10.672  1.00  0.00
ATOM   1007  CD2 TYR    63      -7.089 -24.331  12.963  1.00  0.00
ATOM   1008  HD2 TYR    63      -6.204 -24.733  13.447  1.00  0.00
ATOM   1009  CE1 TYR    63      -9.355 -23.305  11.754  1.00  0.00
ATOM   1010  HE1 TYR    63     -10.241 -22.910  11.279  1.00  0.00
ATOM   1011  CE2 TYR    63      -7.548 -23.074  13.309  1.00  0.00
ATOM   1012  HE2 TYR    63      -7.014 -22.493  14.052  1.00  0.00
ATOM   1013  CZ  TYR    63      -8.674 -22.562  12.699  1.00  0.00
ATOM   1014  OH  TYR    63      -9.124 -21.307  13.039  1.00  0.00
ATOM   1015  HH  TYR    63      -8.371 -20.697  13.085  1.00  0.00
ATOM   1016  C   TYR    63      -5.186 -25.702  10.342  1.00  0.00
ATOM   1017  O   TYR    63      -4.316 -26.004  11.162  1.00  0.00
ATOM   1018  N   GLY    64      -5.066 -24.667   9.493  1.00  0.00
ATOM   1019  HN  GLY    64      -5.752 -24.532   8.814  1.00  0.00
ATOM   1020  CA  GLY    64      -3.939 -23.738   9.559  1.00  0.00
ATOM   1021  HA1 GLY    64      -3.723 -23.383   8.558  1.00  0.00
ATOM   1022  HA2 GLY    64      -3.058 -24.241   9.944  1.00  0.00
ATOM   1023  C   GLY    64      -4.286 -22.551  10.439  1.00  0.00
ATOM   1024  O   GLY    64      -5.040 -21.668  10.015  1.00  0.00
ATOM   1025  N   GLU    65      -3.767 -22.554  11.678  1.00  0.00
ATOM   1026  HN  GLU    65      -3.223 -23.324  11.955  1.00  0.00
ATOM   1027  CA  GLU    65      -3.981 -21.460  12.641  1.00  0.00
ATOM   1028  HA  GLU    65      -4.893 -20.934  12.359  1.00  0.00
ATOM   1029  CB  GLU    65      -4.157 -22.022  14.079  1.00  0.00
ATOM   1030  HB1 GLU    65      -3.276 -22.602  14.337  1.00  0.00
ATOM   1031  HB2 GLU    65      -5.016 -22.682  14.086  1.00  0.00
ATOM   1032  CG  GLU    65      -4.365 -20.940  15.164  1.00  0.00
ATOM   1033  HG1 GLU    65      -5.112 -20.237  14.811  1.00  0.00
ATOM   1034  HG2 GLU    65      -3.430 -20.404  15.301  1.00  0.00
ATOM   1035  CD  GLU    65      -4.810 -21.501  16.529  1.00  0.00
ATOM   1036  OE1 GLU    65      -3.973 -22.103  17.236  1.00  0.00
ATOM   1037  OE2 GLU    65      -5.989 -21.319  16.912  1.00  0.00
ATOM   1038  C   GLU    65      -2.805 -20.484  12.573  1.00  0.00
ATOM   1039  O   GLU    65      -1.716 -20.782  13.081  1.00  0.00
ATOM   1040  N   LEU    66      -3.025 -19.335  11.914  1.00  0.00
ATOM   1041  HN  LEU    66      -3.920 -19.164  11.554  1.00  0.00
ATOM   1042  CA  LEU    66      -1.977 -18.329  11.725  1.00  0.00
ATOM   1043  HA  LEU    66      -1.106 -18.842  11.325  1.00  0.00
ATOM   1044  CB  LEU    66      -2.394 -17.227  10.735  1.00  0.00
ATOM   1045  HB1 LEU    66      -3.212 -16.659  11.175  1.00  0.00
ATOM   1046  HB2 LEU    66      -2.770 -17.702   9.831  1.00  0.00
ATOM   1047  CG  LEU    66      -1.236 -16.235  10.348  1.00  0.00
ATOM   1048  HG  LEU    66      -0.560 -16.154  11.204  1.00  0.00
ATOM   1049  CD1 LEU    66      -0.385 -16.773   9.174  1.00  0.00
ATOM   1050 HD11 LEU    66       0.388 -16.056   8.929  1.00  0.00
ATOM   1051 HD12 LEU    66      -1.017 -16.932   8.304  1.00  0.00
ATOM   1052 HD13 LEU    66       0.076 -17.713   9.455  1.00  0.00
ATOM   1053  CD2 LEU    66      -1.774 -14.828  10.053  1.00  0.00
ATOM   1054 HD21 LEU    66      -2.436 -14.862   9.196  1.00  0.00
ATOM   1055 HD22 LEU    66      -0.950 -14.162   9.843  1.00  0.00
ATOM   1056 HD23 LEU    66      -2.318 -14.458  10.911  1.00  0.00
ATOM   1057  C   LEU    66      -1.596 -17.678  13.066  1.00  0.00
ATOM   1058  O   LEU    66      -2.457 -17.389  13.903  1.00  0.00
ATOM   1059  N   LEU    67      -0.296 -17.458  13.229  1.00  0.00
ATOM   1060  HN  LEU    67       0.304 -17.721  12.501  1.00  0.00
ATOM   1061  CA  LEU    67       0.300 -16.857  14.426  1.00  0.00
ATOM   1062  HA  LEU    67      -0.420 -16.849  15.242  1.00  0.00
ATOM   1063  CB  LEU    67       1.533 -17.710  14.815  1.00  0.00
ATOM   1064  HB1 LEU    67       1.818 -17.465  15.834  1.00  0.00
ATOM   1065  HB2 LEU    67       2.362 -17.437  14.158  1.00  0.00
ATOM   1066  CG  LEU    67       1.325 -19.248  14.715  1.00  0.00
ATOM   1067  HG  LEU    67       0.803 -19.457  13.785  1.00  0.00
ATOM   1068  CD1 LEU    67       2.662 -19.982  14.639  1.00  0.00
ATOM   1069 HD11 LEU    67       3.244 -19.789  15.531  1.00  0.00
ATOM   1070 HD12 LEU    67       3.205 -19.626  13.771  1.00  0.00
ATOM   1071 HD13 LEU    67       2.493 -21.046  14.539  1.00  0.00
ATOM   1072  CD2 LEU    67       0.450 -19.774  15.865  1.00  0.00
ATOM   1073 HD21 LEU    67      -0.520 -19.295  15.822  1.00  0.00
ATOM   1074 HD22 LEU    67       0.919 -19.555  16.815  1.00  0.00
ATOM   1075 HD23 LEU    67       0.324 -20.845  15.765  1.00  0.00
ATOM   1076  C   LEU    67       0.747 -15.437  14.081  1.00  0.00
ATOM   1077  O   LEU    67       0.355 -14.454  14.717  1.00  0.00
ATOM   1078  N   THR    68       1.537 -15.371  13.005  1.00  0.00
ATOM   1079  HN  THR    68       1.670 -16.197  12.483  1.00  0.00
ATOM   1080  CA  THR    68       2.230 -14.158  12.560  1.00  0.00
ATOM   1081  HA  THR    68       1.645 -13.294  12.870  1.00  0.00
ATOM   1082  CB  THR    68       3.651 -14.075  13.235  1.00  0.00
ATOM   1083  HB  THR    68       4.168 -15.016  13.050  1.00  0.00
ATOM   1084  OG1 THR    68       3.499 -13.930  14.661  1.00  0.00
ATOM   1085  HG1 THR    68       3.252 -13.020  14.868  1.00  0.00
ATOM   1086  CG2 THR    68       4.528 -12.927  12.695  1.00  0.00
ATOM   1087 HG21 THR    68       4.726 -13.084  11.641  1.00  0.00
ATOM   1088 HG22 THR    68       5.465 -12.902  13.233  1.00  0.00
ATOM   1089 HG23 THR    68       4.015 -11.981  12.824  1.00  0.00
ATOM   1090  C   THR    68       2.355 -14.164  11.029  1.00  0.00
ATOM   1091  O   THR    68       2.523 -15.218  10.420  1.00  0.00
ATOM   1092  N   ARG    69       2.257 -12.973  10.430  1.00  0.00
ATOM   1093  HN  ARG    69       2.025 -12.200  10.978  1.00  0.00
ATOM   1094  CA  ARG    69       2.482 -12.752   9.001  1.00  0.00
ATOM   1095  HA  ARG    69       3.107 -13.561   8.627  1.00  0.00
ATOM   1096  CB  ARG    69       1.137 -12.746   8.221  1.00  0.00
ATOM   1097  HB1 ARG    69       0.721 -13.750   8.239  1.00  0.00
ATOM   1098  HB2 ARG    69       1.324 -12.469   7.189  1.00  0.00
ATOM   1099  CG  ARG    69       0.092 -11.782   8.808  1.00  0.00
ATOM   1100  HG1 ARG    69       0.529 -10.788   8.858  1.00  0.00
ATOM   1101  HG2 ARG    69      -0.149 -12.105   9.814  1.00  0.00
ATOM   1102  CD  ARG    69      -1.205 -11.704   8.003  1.00  0.00
ATOM   1103  HD1 ARG    69      -1.619 -12.701   7.892  1.00  0.00
ATOM   1104  HD2 ARG    69      -0.986 -11.296   7.020  1.00  0.00
ATOM   1105  NE  ARG    69      -2.195 -10.844   8.682  1.00  0.00
ATOM   1106  HE  ARG    69      -2.097 -10.746   9.658  1.00  0.00
ATOM   1107  CZ  ARG    69      -3.204 -10.199   8.083  1.00  0.00
ATOM   1108  NH1 ARG    69      -3.389 -10.298   6.771  1.00  0.00
ATOM   1109 HH11 ARG    69      -2.775 -10.859   6.216  1.00  0.00
ATOM   1110 HH12 ARG    69      -4.145  -9.809   6.327  1.00  0.00
ATOM   1111  NH2 ARG    69      -4.023  -9.449   8.808  1.00  0.00
ATOM   1112 HH21 ARG    69      -3.895  -9.373   9.800  1.00  0.00
ATOM   1113 HH22 ARG    69      -4.775  -8.947   8.368  1.00  0.00
ATOM   1114  C   ARG    69       3.235 -11.423   8.819  1.00  0.00
ATOM   1115  O   ARG    69       2.846 -10.392   9.386  1.00  0.00
ATOM   1116  N   VAL    70       4.342 -11.464   8.066  1.00  0.00
ATOM   1117  HN  VAL    70       4.627 -12.333   7.703  1.00  0.00
ATOM   1118  CA  VAL    70       5.139 -10.268   7.727  1.00  0.00
ATOM   1119  HA  VAL    70       4.607  -9.388   8.089  1.00  0.00
ATOM   1120  CB  VAL    70       6.573 -10.288   8.399  1.00  0.00
ATOM   1121  HB  VAL    70       7.070  -9.362   8.142  1.00  0.00
ATOM   1122  CG1 VAL    70       6.464 -10.341   9.939  1.00  0.00
ATOM   1123 HG11 VAL    70       5.949 -11.249  10.237  1.00  0.00
ATOM   1124 HG12 VAL    70       5.908  -9.485  10.300  1.00  0.00
ATOM   1125 HG13 VAL    70       7.453 -10.331  10.382  1.00  0.00
ATOM   1126  CG2 VAL    70       7.456 -11.443   7.878  1.00  0.00
ATOM   1127 HG21 VAL    70       7.015 -12.395   8.154  1.00  0.00
ATOM   1128 HG22 VAL    70       8.449 -11.375   8.305  1.00  0.00
ATOM   1129 HG23 VAL    70       7.533 -11.390   6.797  1.00  0.00
ATOM   1130  C   VAL    70       5.254 -10.159   6.205  1.00  0.00
ATOM   1131  O   VAL    70       5.202 -11.171   5.510  1.00  0.00
ATOM   1132  N   ILE    71       5.408  -8.934   5.688  1.00  0.00
ATOM   1133  HN  ILE    71       5.460  -8.167   6.296  1.00  0.00
ATOM   1134  CA  ILE    71       5.504  -8.694   4.237  1.00  0.00
ATOM   1135  HA  ILE    71       5.712  -9.652   3.753  1.00  0.00
ATOM   1136  CB  ILE    71       4.140  -8.162   3.640  1.00  0.00
ATOM   1137  HB  ILE    71       3.419  -8.972   3.729  1.00  0.00
ATOM   1138  CG1 ILE    71       4.286  -7.810   2.124  1.00  0.00
ATOM   1139 HG11 ILE    71       4.695  -8.665   1.597  1.00  0.00
ATOM   1140 HG12 ILE    71       4.961  -6.973   2.010  1.00  0.00
ATOM   1141  CG2 ILE    71       3.573  -6.976   4.453  1.00  0.00
ATOM   1142 HG21 ILE    71       3.444  -7.275   5.485  1.00  0.00
ATOM   1143 HG22 ILE    71       2.614  -6.672   4.050  1.00  0.00
ATOM   1144 HG23 ILE    71       4.260  -6.140   4.406  1.00  0.00
ATOM   1145  CD1 ILE    71       2.987  -7.439   1.443  1.00  0.00
ATOM   1146 HD11 ILE    71       2.543  -6.583   1.935  1.00  0.00
ATOM   1147 HD12 ILE    71       2.301  -8.274   1.484  1.00  0.00
ATOM   1148 HD13 ILE    71       3.185  -7.192   0.410  1.00  0.00
ATOM   1149  C   ILE    71       6.677  -7.743   3.926  1.00  0.00
ATOM   1150  O   ILE    71       6.729  -6.606   4.414  1.00  0.00
ATOM   1151  N   VAL    72       7.647  -8.257   3.143  1.00  0.00
ATOM   1152  HN  VAL    72       7.561  -9.189   2.860  1.00  0.00
ATOM   1153  CA  VAL    72       8.823  -7.508   2.680  1.00  0.00
ATOM   1154  HA  VAL    72       8.838  -6.531   3.166  1.00  0.00
ATOM   1155  CB  VAL    72      10.159  -8.271   3.052  1.00  0.00
ATOM   1156  HB  VAL    72      10.197  -9.188   2.462  1.00  0.00
ATOM   1157  CG1 VAL    72      11.412  -7.431   2.695  1.00  0.00
ATOM   1158 HG11 VAL    72      11.407  -6.504   3.256  1.00  0.00
ATOM   1159 HG12 VAL    72      11.416  -7.203   1.634  1.00  0.00
ATOM   1160 HG13 VAL    72      12.309  -7.988   2.937  1.00  0.00
ATOM   1161  CG2 VAL    72      10.166  -8.680   4.549  1.00  0.00
ATOM   1162 HG21 VAL    72      11.070  -9.230   4.774  1.00  0.00
ATOM   1163 HG22 VAL    72       9.307  -9.308   4.762  1.00  0.00
ATOM   1164 HG23 VAL    72      10.121  -7.794   5.173  1.00  0.00
ATOM   1165  C   VAL    72       8.709  -7.316   1.152  1.00  0.00
ATOM   1166  O   VAL    72       9.061  -8.215   0.377  1.00  0.00
ATOM   1167  N   GLY    73       8.172  -6.154   0.742  1.00  0.00
ATOM   1168  HN  GLY    73       7.902  -5.501   1.421  1.00  0.00
ATOM   1169  CA  GLY    73       7.972  -5.828  -0.676  1.00  0.00
ATOM   1170  HA1 GLY    73       8.932  -5.852  -1.185  1.00  0.00
ATOM   1171  HA2 GLY    73       7.580  -4.822  -0.740  1.00  0.00
ATOM   1172  C   GLY    73       6.996  -6.771  -1.386  1.00  0.00
ATOM   1173  O   GLY    73       5.793  -6.767  -1.097  1.00  0.00
ATOM   1174  N   ASN    74       7.526  -7.594  -2.308  1.00  0.00
ATOM   1175  HN  ASN    74       8.498  -7.567  -2.448  1.00  0.00
ATOM   1176  CA  ASN    74       6.729  -8.548  -3.117  1.00  0.00
ATOM   1177  HA  ASN    74       5.713  -8.166  -3.186  1.00  0.00
ATOM   1178  CB  ASN    74       7.314  -8.665  -4.555  1.00  0.00
ATOM   1179  HB1 ASN    74       7.322  -7.683  -5.010  1.00  0.00
ATOM   1180  HB2 ASN    74       6.675  -9.315  -5.146  1.00  0.00
ATOM   1181  CG  ASN    74       8.750  -9.214  -4.594  1.00  0.00
ATOM   1182  OD1 ASN    74       9.585  -8.891  -3.742  1.00  0.00
ATOM   1183  ND2 ASN    74       9.037 -10.074  -5.557  1.00  0.00
ATOM   1184 HD21 ASN    74       8.325 -10.315  -6.189  1.00  0.00
ATOM   1185 HD22 ASN    74       9.943 -10.438  -5.598  1.00  0.00
ATOM   1186  C   ASN    74       6.680  -9.946  -2.463  1.00  0.00
ATOM   1187  O   ASN    74       6.224 -10.908  -3.082  1.00  0.00
ATOM   1188  N   VAL    75       7.108 -10.034  -1.201  1.00  0.00
ATOM   1189  HN  VAL    75       7.260  -9.199  -0.708  1.00  0.00
ATOM   1190  CA  VAL    75       7.309 -11.315  -0.489  1.00  0.00
ATOM   1191  HA  VAL    75       6.945 -12.129  -1.117  1.00  0.00
ATOM   1192  CB  VAL    75       8.848 -11.555  -0.195  1.00  0.00
ATOM   1193  HB  VAL    75       9.218 -10.684   0.349  1.00  0.00
ATOM   1194  CG1 VAL    75       9.087 -12.801   0.696  1.00  0.00
ATOM   1195 HG11 VAL    75       8.592 -12.672   1.653  1.00  0.00
ATOM   1196 HG12 VAL    75      10.147 -12.937   0.863  1.00  0.00
ATOM   1197 HG13 VAL    75       8.687 -13.683   0.207  1.00  0.00
ATOM   1198  CG2 VAL    75       9.662 -11.661  -1.510  1.00  0.00
ATOM   1199 HG21 VAL    75       9.314 -12.507  -2.091  1.00  0.00
ATOM   1200 HG22 VAL    75      10.714 -11.794  -1.282  1.00  0.00
ATOM   1201 HG23 VAL    75       9.541 -10.755  -2.094  1.00  0.00
ATOM   1202  C   VAL    75       6.515 -11.301   0.828  1.00  0.00
ATOM   1203  O   VAL    75       6.544 -10.301   1.540  1.00  0.00
ATOM   1204  N   VAL    76       5.783 -12.395   1.139  1.00  0.00
ATOM   1205  HN  VAL    76       5.728 -13.126   0.488  1.00  0.00
ATOM   1206  CA  VAL    76       5.064 -12.541   2.428  1.00  0.00
ATOM   1207  HA  VAL    76       5.338 -11.701   3.071  1.00  0.00
ATOM   1208  CB  VAL    76       3.493 -12.528   2.262  1.00  0.00
ATOM   1209  HB  VAL    76       3.200 -13.449   1.754  1.00  0.00
ATOM   1210  CG1 VAL    76       2.783 -12.508   3.646  1.00  0.00
ATOM   1211 HG11 VAL    76       1.711 -12.534   3.510  1.00  0.00
ATOM   1212 HG12 VAL    76       3.049 -11.606   4.184  1.00  0.00
ATOM   1213 HG13 VAL    76       3.086 -13.371   4.232  1.00  0.00
ATOM   1214  CG2 VAL    76       3.019 -11.344   1.389  1.00  0.00
ATOM   1215 HG21 VAL    76       3.486 -11.397   0.411  1.00  0.00
ATOM   1216 HG22 VAL    76       3.288 -10.408   1.859  1.00  0.00
ATOM   1217 HG23 VAL    76       1.945 -11.385   1.269  1.00  0.00
ATOM   1218  C   VAL    76       5.475 -13.854   3.126  1.00  0.00
ATOM   1219  O   VAL    76       5.559 -14.898   2.492  1.00  0.00
ATOM   1220  N   ILE    77       5.734 -13.766   4.433  1.00  0.00
ATOM   1221  HN  ILE    77       5.813 -12.878   4.816  1.00  0.00
ATOM   1222  CA  ILE    77       5.916 -14.910   5.337  1.00  0.00
ATOM   1223  HA  ILE    77       6.176 -15.798   4.765  1.00  0.00
ATOM   1224  CB  ILE    77       7.073 -14.588   6.362  1.00  0.00
ATOM   1225  HB  ILE    77       6.847 -13.610   6.770  1.00  0.00
ATOM   1226  CG1 ILE    77       8.463 -14.486   5.659  1.00  0.00
ATOM   1227 HG11 ILE    77       9.137 -13.928   6.297  1.00  0.00
ATOM   1228 HG12 ILE    77       8.355 -13.959   4.723  1.00  0.00
ATOM   1229  CG2 ILE    77       7.119 -15.560   7.574  1.00  0.00
ATOM   1230 HG21 ILE    77       7.923 -15.265   8.242  1.00  0.00
ATOM   1231 HG22 ILE    77       7.286 -16.571   7.234  1.00  0.00
ATOM   1232 HG23 ILE    77       6.178 -15.513   8.111  1.00  0.00
ATOM   1233  CD1 ILE    77       9.122 -15.813   5.355  1.00  0.00
ATOM   1234 HD11 ILE    77       8.436 -16.442   4.804  1.00  0.00
ATOM   1235 HD12 ILE    77       9.395 -16.301   6.279  1.00  0.00
ATOM   1236 HD13 ILE    77      10.007 -15.641   4.763  1.00  0.00
ATOM   1237  C   ILE    77       4.599 -15.127   6.100  1.00  0.00
ATOM   1238  O   ILE    77       4.265 -14.325   6.974  1.00  0.00
ATOM   1239  N   ASP    78       3.831 -16.161   5.735  1.00  0.00
ATOM   1240  HN  ASP    78       4.024 -16.623   4.895  1.00  0.00
ATOM   1241  CA  ASP    78       2.693 -16.628   6.545  1.00  0.00
ATOM   1242  HA  ASP    78       2.361 -15.800   7.176  1.00  0.00
ATOM   1243  CB  ASP    78       1.495 -17.090   5.663  1.00  0.00
ATOM   1244  HB1 ASP    78       0.808 -17.681   6.263  1.00  0.00
ATOM   1245  HB2 ASP    78       1.871 -17.715   4.859  1.00  0.00
ATOM   1246  CG  ASP    78       0.722 -15.907   5.051  1.00  0.00
ATOM   1247  OD1 ASP    78      -0.279 -15.444   5.664  1.00  0.00
ATOM   1248  OD2 ASP    78       1.123 -15.426   3.972  1.00  0.00
ATOM   1249  C   ASP    78       3.178 -17.755   7.453  1.00  0.00
ATOM   1250  O   ASP    78       3.447 -18.863   6.993  1.00  0.00
ATOM   1251  N   HIS    79       3.324 -17.435   8.743  1.00  0.00
ATOM   1252  HN  HIS    79       3.119 -16.519   9.012  1.00  0.00
ATOM   1253  CA  HIS    79       3.748 -18.381   9.770  1.00  0.00
ATOM   1254  HA  HIS    79       4.225 -19.233   9.284  1.00  0.00
ATOM   1255  CB  HIS    79       4.778 -17.711  10.721  1.00  0.00
ATOM   1256  HB1 HIS    79       4.334 -16.814  11.146  1.00  0.00
ATOM   1257  HB2 HIS    79       5.650 -17.421  10.147  1.00  0.00
ATOM   1258  CG  HIS    79       5.266 -18.576  11.867  1.00  0.00
ATOM   1259  ND1 HIS    79       5.141 -19.954  11.901  1.00  0.00
ATOM   1260  HD1 HIS    79       4.729 -20.508  11.208  1.00  0.00
ATOM   1261  CD2 HIS    79       5.881 -18.238  13.023  1.00  0.00
ATOM   1262  HD2 HIS    79       6.149 -17.237  13.337  1.00  0.00
ATOM   1263  CE1 HIS    79       5.651 -20.417  13.021  1.00  0.00
ATOM   1264  HE1 HIS    79       5.647 -21.450  13.340  1.00  0.00
ATOM   1265  NE2 HIS    79       6.108 -19.397  13.721  1.00  0.00
ATOM   1266  HE2 HIS    79       6.411 -19.446  14.651  1.00  0.00
ATOM   1267  C   HIS    79       2.505 -18.858  10.529  1.00  0.00
ATOM   1268  O   HIS    79       1.921 -18.112  11.330  1.00  0.00
ATOM   1269  N   GLU    80       2.124 -20.108  10.258  1.00  0.00
ATOM   1270  HN  GLU    80       2.686 -20.635   9.644  1.00  0.00
ATOM   1271  CA  GLU    80       0.924 -20.760  10.804  1.00  0.00
ATOM   1272  HA  GLU    80       0.514 -20.115  11.578  1.00  0.00
ATOM   1273  CB  GLU    80      -0.175 -20.959   9.682  1.00  0.00
ATOM   1274  HB1 GLU    80      -0.900 -20.154   9.758  1.00  0.00
ATOM   1275  HB2 GLU    80      -0.700 -21.893   9.862  1.00  0.00
ATOM   1276  CG  GLU    80       0.335 -20.987   8.215  1.00  0.00
ATOM   1277  HG1 GLU    80       0.813 -20.034   8.008  1.00  0.00
ATOM   1278  HG2 GLU    80      -0.520 -21.089   7.549  1.00  0.00
ATOM   1279  CD  GLU    80       1.327 -22.123   7.905  1.00  0.00
ATOM   1280  OE1 GLU    80       0.900 -23.297   7.853  1.00  0.00
ATOM   1281  OE2 GLU    80       2.529 -21.843   7.704  1.00  0.00
ATOM   1282  C   GLU    80       1.303 -22.088  11.480  1.00  0.00
ATOM   1283  O   GLU    80       2.444 -22.541  11.390  1.00  0.00
ATOM   1284  N   THR    81       0.341 -22.666  12.209  1.00  0.00
ATOM   1285  HN  THR    81      -0.501 -22.191  12.319  1.00  0.00
ATOM   1286  CA  THR    81       0.474 -23.983  12.842  1.00  0.00
ATOM   1287  HA  THR    81       1.480 -24.371  12.650  1.00  0.00
ATOM   1288  CB  THR    81       0.261 -23.908  14.389  1.00  0.00
ATOM   1289  HB  THR    81      -0.787 -23.710  14.592  1.00  0.00
ATOM   1290  OG1 THR    81       1.039 -22.837  14.930  1.00  0.00
ATOM   1291  HG1 THR    81       1.976 -23.062  14.888  1.00  0.00
ATOM   1292  CG2 THR    81       0.660 -25.216  15.097  1.00  0.00
ATOM   1293 HG21 THR    81       0.482 -25.123  16.161  1.00  0.00
ATOM   1294 HG22 THR    81       1.711 -25.421  14.928  1.00  0.00
ATOM   1295 HG23 THR    81       0.070 -26.040  14.711  1.00  0.00
ATOM   1296  C   THR    81      -0.563 -24.926  12.218  1.00  0.00
ATOM   1297  O   THR    81      -1.772 -24.750  12.420  1.00  0.00
ATOM   1298  N   VAL    82      -0.083 -25.896  11.437  1.00  0.00
ATOM   1299  HN  VAL    82       0.879 -25.935  11.288  1.00  0.00
ATOM   1300  CA  VAL    82      -0.929 -26.888  10.775  1.00  0.00
ATOM   1301  HA  VAL    82      -1.840 -26.394  10.432  1.00  0.00
ATOM   1302  CB  VAL    82      -0.208 -27.516   9.527  1.00  0.00
ATOM   1303  HB  VAL    82       0.646 -28.088   9.892  1.00  0.00
ATOM   1304  CG1 VAL    82      -1.137 -28.498   8.783  1.00  0.00
ATOM   1305 HG11 VAL    82      -1.435 -29.296   9.457  1.00  0.00
ATOM   1306 HG12 VAL    82      -0.621 -28.927   7.934  1.00  0.00
ATOM   1307 HG13 VAL    82      -2.021 -27.976   8.438  1.00  0.00
ATOM   1308  CG2 VAL    82       0.337 -26.425   8.585  1.00  0.00
ATOM   1309 HG21 VAL    82       0.824 -26.885   7.735  1.00  0.00
ATOM   1310 HG22 VAL    82       1.059 -25.812   9.117  1.00  0.00
ATOM   1311 HG23 VAL    82      -0.475 -25.799   8.238  1.00  0.00
ATOM   1312  C   VAL    82      -1.296 -28.010  11.758  1.00  0.00
ATOM   1313  O   VAL    82      -0.461 -28.864  12.069  1.00  0.00
ATOM   1314  N   THR    83      -2.536 -27.975  12.262  1.00  0.00
ATOM   1315  HN  THR    83      -3.078 -27.181  12.119  1.00  0.00
ATOM   1316  CA  THR    83      -3.105 -29.082  13.035  1.00  0.00
ATOM   1317  HA  THR    83      -2.412 -29.323  13.839  1.00  0.00
ATOM   1318  CB  THR    83      -4.481 -28.685  13.668  1.00  0.00
ATOM   1319  HB  THR    83      -5.160 -28.404  12.867  1.00  0.00
ATOM   1320  OG1 THR    83      -4.309 -27.544  14.529  1.00  0.00
ATOM   1321  HG1 THR    83      -3.679 -26.932  14.133  1.00  0.00
ATOM   1322  CG2 THR    83      -5.123 -29.845  14.468  1.00  0.00
ATOM   1323 HG21 THR    83      -4.452 -30.164  15.257  1.00  0.00
ATOM   1324 HG22 THR    83      -5.319 -30.683  13.809  1.00  0.00
ATOM   1325 HG23 THR    83      -6.058 -29.516  14.906  1.00  0.00
ATOM   1326  C   THR    83      -3.273 -30.305  12.114  1.00  0.00
ATOM   1327  O   THR    83      -3.958 -30.228  11.087  1.00  0.00
ATOM   1328  N   ARG    84      -2.578 -31.394  12.467  1.00  0.00
ATOM   1329  HN  ARG    84      -1.972 -31.324  13.232  1.00  0.00
ATOM   1330  CA  ARG    84      -2.657 -32.694  11.781  1.00  0.00
ATOM   1331  HA  ARG    84      -3.432 -32.655  11.018  1.00  0.00
ATOM   1332  CB  ARG    84      -1.281 -33.031  11.121  1.00  0.00
ATOM   1333  HB1 ARG    84      -1.383 -33.960  10.565  1.00  0.00
ATOM   1334  HB2 ARG    84      -0.548 -33.183  11.909  1.00  0.00
ATOM   1335  CG  ARG    84      -0.732 -31.946  10.157  1.00  0.00
ATOM   1336  HG1 ARG    84      -0.660 -31.004  10.698  1.00  0.00
ATOM   1337  HG2 ARG    84      -1.423 -31.826   9.334  1.00  0.00
ATOM   1338  CD  ARG    84       0.658 -32.295   9.587  1.00  0.00
ATOM   1339  HD1 ARG    84       0.579 -33.224   9.033  1.00  0.00
ATOM   1340  HD2 ARG    84       1.346 -32.434  10.413  1.00  0.00
ATOM   1341  NE  ARG    84       1.205 -31.246   8.692  1.00  0.00
ATOM   1342  HE  ARG    84       0.848 -30.336   8.810  1.00  0.00
ATOM   1343  CZ  ARG    84       2.180 -31.435   7.775  1.00  0.00
ATOM   1344  NH1 ARG    84       2.668 -32.650   7.536  1.00  0.00
ATOM   1345 HH11 ARG    84       2.318 -33.441   8.044  1.00  0.00
ATOM   1346 HH12 ARG    84       3.395 -32.782   6.857  1.00  0.00
ATOM   1347  NH2 ARG    84       2.654 -30.397   7.089  1.00  0.00
ATOM   1348 HH21 ARG    84       2.292 -29.477   7.252  1.00  0.00
ATOM   1349 HH22 ARG    84       3.387 -30.528   6.414  1.00  0.00
ATOM   1350  C   ARG    84      -3.039 -33.762  12.825  1.00  0.00
ATOM   1351  O   ARG    84      -3.453 -33.417  13.938  1.00  0.00
ATOM   1352  N   ASN    85      -2.949 -35.050  12.453  1.00  0.00
ATOM   1353  HN  ASN    85      -2.807 -35.252  11.503  1.00  0.00
ATOM   1354  CA  ASN    85      -3.068 -36.183  13.401  1.00  0.00
ATOM   1355  HA  ASN    85      -3.227 -35.777  14.401  1.00  0.00
ATOM   1356  CB  ASN    85      -4.278 -37.105  13.042  1.00  0.00
ATOM   1357  HB1 ASN    85      -4.060 -38.119  13.370  1.00  0.00
ATOM   1358  HB2 ASN    85      -4.403 -37.118  11.968  1.00  0.00
ATOM   1359  CG  ASN    85      -5.617 -36.685  13.664  1.00  0.00
ATOM   1360  OD1 ASN    85      -6.453 -37.533  13.983  1.00  0.00
ATOM   1361  ND2 ASN    85      -5.859 -35.394  13.817  1.00  0.00
ATOM   1362 HD21 ASN    85      -5.182 -34.752  13.529  1.00  0.00
ATOM   1363 HD22 ASN    85      -6.711 -35.132  14.223  1.00  0.00
ATOM   1364  C   ASN    85      -1.755 -36.982  13.410  1.00  0.00
ATOM   1365  O   ASN    85      -1.404 -37.632  12.418  1.00  0.00
ATOM   1366  N   PHE    86      -1.007 -36.881  14.523  1.00  0.00
ATOM   1367  HN  PHE    86      -1.294 -36.250  15.215  1.00  0.00
ATOM   1368  CA  PHE    86       0.217 -37.682  14.766  1.00  0.00
ATOM   1369  HA  PHE    86       0.519 -38.136  13.820  1.00  0.00
ATOM   1370  CB  PHE    86       1.375 -36.779  15.290  1.00  0.00
ATOM   1371  HB1 PHE    86       2.135 -37.406  15.746  1.00  0.00
ATOM   1372  HB2 PHE    86       0.983 -36.113  16.047  1.00  0.00
ATOM   1373  CG  PHE    86       2.077 -35.904  14.242  1.00  0.00
ATOM   1374  CD1 PHE    86       3.156 -35.097  14.611  1.00  0.00
ATOM   1375  HD1 PHE    86       3.492 -35.097  15.642  1.00  0.00
ATOM   1376  CD2 PHE    86       1.674 -35.879  12.903  1.00  0.00
ATOM   1377  HD2 PHE    86       0.841 -36.492  12.584  1.00  0.00
ATOM   1378  CE1 PHE    86       3.798 -34.301  13.681  1.00  0.00
ATOM   1379  HE1 PHE    86       4.630 -33.680  13.983  1.00  0.00
ATOM   1380  CE2 PHE    86       2.321 -35.081  11.980  1.00  0.00
ATOM   1381  HE2 PHE    86       1.997 -35.076  10.951  1.00  0.00
ATOM   1382  CZ  PHE    86       3.381 -34.297  12.368  1.00  0.00
ATOM   1383  HZ  PHE    86       3.888 -33.670  11.641  1.00  0.00
ATOM   1384  C   PHE    86      -0.083 -38.813  15.772  1.00  0.00
ATOM   1385  O   PHE    86      -0.908 -38.631  16.671  1.00  0.00
ATOM   1386  N   PRO    87       0.586 -40.007  15.644  1.00  0.00
ATOM   1387  CA  PRO    87       0.304 -41.188  16.506  1.00  0.00
ATOM   1388  HA  PRO    87      -0.753 -41.430  16.487  1.00  0.00
ATOM   1389  CB  PRO    87       1.090 -42.324  15.810  1.00  0.00
ATOM   1390  HB1 PRO    87       0.450 -42.828  15.088  1.00  0.00
ATOM   1391  HB2 PRO    87       1.439 -43.050  16.538  1.00  0.00
ATOM   1392  CG  PRO    87       2.225 -41.625  15.135  1.00  0.00
ATOM   1393  HG1 PRO    87       2.594 -42.216  14.303  1.00  0.00
ATOM   1394  HG2 PRO    87       3.031 -41.449  15.847  1.00  0.00
ATOM   1395  CD  PRO    87       1.650 -40.316  14.643  1.00  0.00
ATOM   1396  HD1 PRO    87       1.221 -40.430  13.654  1.00  0.00
ATOM   1397  HD2 PRO    87       2.411 -39.543  14.634  1.00  0.00
ATOM   1398  C   PRO    87       0.735 -41.013  17.986  1.00  0.00
ATOM   1399  O   PRO    87       0.406 -41.861  18.826  1.00  0.00
ATOM   1400  N   GLU    88       1.487 -39.932  18.296  1.00  0.00
ATOM   1401  HN  GLU    88       1.811 -39.361  17.568  1.00  0.00
ATOM   1402  CA  GLU    88       1.846 -39.587  19.694  1.00  0.00
ATOM   1403  HA  GLU    88       1.801 -40.508  20.274  1.00  0.00
ATOM   1404  CB  GLU    88       3.298 -39.019  19.810  1.00  0.00
ATOM   1405  HB1 GLU    88       3.992 -39.824  19.590  1.00  0.00
ATOM   1406  HB2 GLU    88       3.468 -38.713  20.839  1.00  0.00
ATOM   1407  CG  GLU    88       3.637 -37.816  18.889  1.00  0.00
ATOM   1408  HG1 GLU    88       4.235 -37.099  19.455  1.00  0.00
ATOM   1409  HG2 GLU    88       2.711 -37.325  18.599  1.00  0.00
ATOM   1410  CD  GLU    88       4.401 -38.201  17.607  1.00  0.00
ATOM   1411  OE1 GLU    88       3.776 -38.731  16.671  1.00  0.00
ATOM   1412  OE2 GLU    88       5.635 -37.981  17.541  1.00  0.00
ATOM   1413  C   GLU    88       0.823 -38.610  20.322  1.00  0.00
ATOM   1414  O   GLU    88       0.815 -38.439  21.545  1.00  0.00
ATOM   1415  N   GLY    89      -0.036 -37.962  19.498  1.00  0.00
ATOM   1416  HN  GLY    89       0.070 -38.056  18.526  1.00  0.00
ATOM   1417  CA  GLY    89      -1.120 -37.115  20.036  1.00  0.00
ATOM   1418  HA1 GLY    89      -0.733 -36.528  20.864  1.00  0.00
ATOM   1419  HA2 GLY    89      -1.902 -37.760  20.417  1.00  0.00
ATOM   1420  C   GLY    89      -1.738 -36.173  19.008  1.00  0.00
ATOM   1421  O   GLY    89      -2.265 -36.634  17.995  1.00  0.00
ATOM   1422  N   LYS    90      -1.688 -34.849  19.296  1.00  0.00
ATOM   1423  HN  LYS    90      -1.292 -34.580  20.148  1.00  0.00
ATOM   1424  CA  LYS    90      -2.228 -33.784  18.429  1.00  0.00
ATOM   1425  HA  LYS    90      -3.308 -33.929  18.384  1.00  0.00
ATOM   1426  CB  LYS    90      -1.953 -32.399  19.091  1.00  0.00
ATOM   1427  HB1 LYS    90      -0.889 -32.329  19.303  1.00  0.00
ATOM   1428  HB2 LYS    90      -2.482 -32.361  20.036  1.00  0.00
ATOM   1429  CG  LYS    90      -2.358 -31.147  18.270  1.00  0.00
ATOM   1430  HG1 LYS    90      -1.761 -31.127  17.361  1.00  0.00
ATOM   1431  HG2 LYS    90      -2.120 -30.263  18.854  1.00  0.00
ATOM   1432  CD  LYS    90      -3.857 -31.081  17.883  1.00  0.00
ATOM   1433  HD1 LYS    90      -4.078 -31.901  17.205  1.00  0.00
ATOM   1434  HD2 LYS    90      -4.036 -30.146  17.364  1.00  0.00
ATOM   1435  CE  LYS    90      -4.812 -31.157  19.088  1.00  0.00
ATOM   1436  HE1 LYS    90      -4.460 -30.494  19.864  1.00  0.00
ATOM   1437  HE2 LYS    90      -4.825 -32.172  19.468  1.00  0.00
ATOM   1438  NZ  LYS    90      -6.199 -30.777  18.717  1.00  0.00
ATOM   1439  HZ1 LYS    90      -6.576 -31.434  18.006  1.00  0.00
ATOM   1440  HZ2 LYS    90      -6.210 -29.813  18.321  1.00  0.00
ATOM   1441  HZ3 LYS    90      -6.816 -30.796  19.553  1.00  0.00
ATOM   1442  C   LYS    90      -1.669 -33.871  16.986  1.00  0.00
ATOM   1443  O   LYS    90      -2.296 -34.497  16.132  1.00  0.00
ATOM   1444  N   GLY    91      -0.478 -33.289  16.736  1.00  0.00
ATOM   1445  HN  GLY    91       0.003 -32.854  17.467  1.00  0.00
ATOM   1446  CA  GLY    91       0.113 -33.291  15.396  1.00  0.00
ATOM   1447  HA1 GLY    91      -0.475 -33.914  14.730  1.00  0.00
ATOM   1448  HA2 GLY    91       1.103 -33.721  15.472  1.00  0.00
ATOM   1449  C   GLY    91       0.249 -31.907  14.791  1.00  0.00
ATOM   1450  O   GLY    91       0.259 -31.760  13.567  1.00  0.00
ATOM   1451  N   GLU    92       0.402 -30.891  15.643  1.00  0.00
ATOM   1452  HN  GLU    92       0.538 -31.090  16.594  1.00  0.00
ATOM   1453  CA  GLU    92       0.411 -29.488  15.201  1.00  0.00
ATOM   1454  HA  GLU    92      -0.198 -29.405  14.301  1.00  0.00
ATOM   1455  CB  GLU    92      -0.210 -28.587  16.309  1.00  0.00
ATOM   1456  HB1 GLU    92      -1.247 -28.882  16.459  1.00  0.00
ATOM   1457  HB2 GLU    92      -0.200 -27.559  15.966  1.00  0.00
ATOM   1458  CG  GLU    92       0.511 -28.654  17.679  1.00  0.00
ATOM   1459  HG1 GLU    92       1.559 -28.392  17.534  1.00  0.00
ATOM   1460  HG2 GLU    92       0.465 -29.680  18.035  1.00  0.00
ATOM   1461  CD  GLU    92      -0.076 -27.730  18.754  1.00  0.00
ATOM   1462  OE1 GLU    92      -0.596 -28.231  19.775  1.00  0.00
ATOM   1463  OE2 GLU    92       0.010 -26.494  18.591  1.00  0.00
ATOM   1464  C   GLU    92       1.855 -29.069  14.862  1.00  0.00
ATOM   1465  O   GLU    92       2.758 -29.163  15.701  1.00  0.00
ATOM   1466  N   VAL    93       2.091 -28.670  13.592  1.00  0.00
ATOM   1467  HN  VAL    93       1.333 -28.599  12.963  1.00  0.00
ATOM   1468  CA  VAL    93       3.437 -28.330  13.109  1.00  0.00
ATOM   1469  HA  VAL    93       4.136 -28.473  13.938  1.00  0.00
ATOM   1470  CB  VAL    93       3.893 -29.287  11.940  1.00  0.00
ATOM   1471  HB  VAL    93       4.913 -29.019  11.665  1.00  0.00
ATOM   1472  CG1 VAL    93       3.922 -30.751  12.432  1.00  0.00
ATOM   1473 HG11 VAL    93       2.920 -31.068  12.705  1.00  0.00
ATOM   1474 HG12 VAL    93       4.560 -30.833  13.302  1.00  0.00
ATOM   1475 HG13 VAL    93       4.300 -31.398  11.653  1.00  0.00
ATOM   1476  CG2 VAL    93       3.006 -29.154  10.680  1.00  0.00
ATOM   1477 HG21 VAL    93       1.980 -29.407  10.925  1.00  0.00
ATOM   1478 HG22 VAL    93       3.360 -29.821   9.903  1.00  0.00
ATOM   1479 HG23 VAL    93       3.042 -28.135  10.314  1.00  0.00
ATOM   1480  C   VAL    93       3.493 -26.853  12.707  1.00  0.00
ATOM   1481  O   VAL    93       2.693 -26.383  11.896  1.00  0.00
ATOM   1482  N   ASP    94       4.421 -26.119  13.325  1.00  0.00
ATOM   1483  HN  ASP    94       5.019 -26.570  13.963  1.00  0.00
ATOM   1484  CA  ASP    94       4.590 -24.676  13.099  1.00  0.00
ATOM   1485  HA  ASP    94       3.610 -24.233  12.925  1.00  0.00
ATOM   1486  CB  ASP    94       5.220 -24.007  14.345  1.00  0.00
ATOM   1487  HB1 ASP    94       5.388 -22.954  14.128  1.00  0.00
ATOM   1488  HB2 ASP    94       6.183 -24.469  14.550  1.00  0.00
ATOM   1489  CG  ASP    94       4.342 -24.122  15.607  1.00  0.00
ATOM   1490  OD1 ASP    94       4.199 -25.244  16.141  1.00  0.00
ATOM   1491  OD2 ASP    94       3.815 -23.093  16.083  1.00  0.00
ATOM   1492  C   ASP    94       5.467 -24.462  11.857  1.00  0.00
ATOM   1493  O   ASP    94       6.667 -24.705  11.899  1.00  0.00
ATOM   1494  N   VAL    95       4.844 -24.006  10.764  1.00  0.00
ATOM   1495  HN  VAL    95       3.900 -23.767  10.842  1.00  0.00
ATOM   1496  CA  VAL    95       5.474 -23.850   9.440  1.00  0.00
ATOM   1497  HA  VAL    95       6.475 -24.278   9.461  1.00  0.00
ATOM   1498  CB  VAL    95       4.616 -24.600   8.339  1.00  0.00
ATOM   1499  HB  VAL    95       3.704 -24.046   8.214  1.00  0.00
ATOM   1500  CG1 VAL    95       5.309 -24.625   6.956  1.00  0.00
ATOM   1501 HG11 VAL    95       5.489 -23.609   6.618  1.00  0.00
ATOM   1502 HG12 VAL    95       4.680 -25.130   6.235  1.00  0.00
ATOM   1503 HG13 VAL    95       6.254 -25.146   7.033  1.00  0.00
ATOM   1504  CG2 VAL    95       4.215 -26.020   8.799  1.00  0.00
ATOM   1505 HG21 VAL    95       3.629 -25.959   9.713  1.00  0.00
ATOM   1506 HG22 VAL    95       5.102 -26.609   8.986  1.00  0.00
ATOM   1507 HG23 VAL    95       3.621 -26.503   8.031  1.00  0.00
ATOM   1508  C   VAL    95       5.557 -22.353   9.085  1.00  0.00
ATOM   1509  O   VAL    95       4.736 -21.559   9.544  1.00  0.00
ATOM   1510  N   ALA    96       6.583 -21.973   8.314  1.00  0.00
ATOM   1511  HN  ALA    96       7.309 -22.602   8.168  1.00  0.00
ATOM   1512  CA  ALA    96       6.671 -20.654   7.672  1.00  0.00
ATOM   1513  HA  ALA    96       5.835 -20.037   8.010  1.00  0.00
ATOM   1514  CB  ALA    96       7.980 -19.942   8.058  1.00  0.00
ATOM   1515  HB1 ALA    96       8.015 -19.803   9.132  1.00  0.00
ATOM   1516  HB2 ALA    96       8.025 -18.974   7.577  1.00  0.00
ATOM   1517  HB3 ALA    96       8.833 -20.535   7.748  1.00  0.00
ATOM   1518  C   ALA    96       6.565 -20.844   6.153  1.00  0.00
ATOM   1519  O   ALA    96       7.519 -21.300   5.508  1.00  0.00
ATOM   1520  N   CYS    97       5.387 -20.537   5.597  1.00  0.00
ATOM   1521  HN  CYS    97       4.653 -20.258   6.180  1.00  0.00
ATOM   1522  CA  CYS    97       5.136 -20.600   4.158  1.00  0.00
ATOM   1523  HA  CYS    97       5.833 -21.314   3.713  1.00  0.00
ATOM   1524  CB  CYS    97       3.695 -21.078   3.890  1.00  0.00
ATOM   1525  HB1 CYS    97       3.517 -21.101   2.822  1.00  0.00
ATOM   1526  HB2 CYS    97       2.997 -20.395   4.352  1.00  0.00
ATOM   1527  SG  CYS    97       3.345 -22.732   4.533  1.00  0.00
ATOM   1528  HG  CYS    97       2.775 -22.594   5.722  1.00  0.00
ATOM   1529  C   CYS    97       5.387 -19.209   3.562  1.00  0.00
ATOM   1530  O   CYS    97       4.641 -18.262   3.822  1.00  0.00
ATOM   1531  N   ILE    98       6.480 -19.101   2.804  1.00  0.00
ATOM   1532  HN  ILE    98       7.002 -19.913   2.642  1.00  0.00
ATOM   1533  CA  ILE    98       6.934 -17.849   2.180  1.00  0.00
ATOM   1534  HA  ILE    98       6.455 -17.017   2.702  1.00  0.00
ATOM   1535  CB  ILE    98       8.501 -17.678   2.336  1.00  0.00
ATOM   1536  HB  ILE    98       8.687 -17.488   3.387  1.00  0.00
ATOM   1537  CG1 ILE    98       9.025 -16.440   1.527  1.00  0.00
ATOM   1538 HG11 ILE    98       8.550 -15.545   1.910  1.00  0.00
ATOM   1539 HG12 ILE    98       8.756 -16.554   0.485  1.00  0.00
ATOM   1540  CG2 ILE    98       9.270 -18.977   1.998  1.00  0.00
ATOM   1541 HG21 ILE    98      10.334 -18.829   2.137  1.00  0.00
ATOM   1542 HG22 ILE    98       9.081 -19.261   0.972  1.00  0.00
ATOM   1543 HG23 ILE    98       8.935 -19.778   2.650  1.00  0.00
ATOM   1544  CD1 ILE    98      10.530 -16.210   1.574  1.00  0.00
ATOM   1545 HD11 ILE    98      11.047 -17.061   1.148  1.00  0.00
ATOM   1546 HD12 ILE    98      10.849 -16.068   2.596  1.00  0.00
ATOM   1547 HD13 ILE    98      10.770 -15.325   1.000  1.00  0.00
ATOM   1548  C   ILE    98       6.500 -17.817   0.702  1.00  0.00
ATOM   1549  O   ILE    98       6.639 -18.801  -0.012  1.00  0.00
ATOM   1550  N   TYR    99       5.959 -16.675   0.255  1.00  0.00
ATOM   1551  HN  TYR    99       5.921 -15.917   0.861  1.00  0.00
ATOM   1552  CA  TYR    99       5.429 -16.498  -1.110  1.00  0.00
ATOM   1553  HA  TYR    99       5.624 -17.406  -1.680  1.00  0.00
ATOM   1554  CB  TYR    99       3.895 -16.233  -1.087  1.00  0.00
ATOM   1555  HB1 TYR    99       3.512 -16.290  -2.104  1.00  0.00
ATOM   1556  HB2 TYR    99       3.708 -15.233  -0.706  1.00  0.00
ATOM   1557  CG  TYR    99       3.089 -17.221  -0.227  1.00  0.00
ATOM   1558  CD1 TYR    99       2.606 -18.425  -0.749  1.00  0.00
ATOM   1559  HD1 TYR    99       2.793 -18.660  -1.787  1.00  0.00
ATOM   1560  CD2 TYR    99       2.826 -16.947   1.118  1.00  0.00
ATOM   1561  HD2 TYR    99       3.189 -16.020   1.550  1.00  0.00
ATOM   1562  CE1 TYR    99       1.893 -19.310   0.036  1.00  0.00
ATOM   1563  HE1 TYR    99       1.530 -20.238  -0.389  1.00  0.00
ATOM   1564  CE2 TYR    99       2.112 -17.830   1.902  1.00  0.00
ATOM   1565  HE2 TYR    99       1.922 -17.591   2.943  1.00  0.00
ATOM   1566  CZ  TYR    99       1.647 -19.007   1.361  1.00  0.00
ATOM   1567  OH  TYR    99       0.941 -19.891   2.150  1.00  0.00
ATOM   1568  HH  TYR    99       0.481 -19.401   2.843  1.00  0.00
ATOM   1569  C   TYR    99       6.133 -15.323  -1.793  1.00  0.00
ATOM   1570  O   TYR    99       6.636 -14.416  -1.131  1.00  0.00
ATOM   1571  N   GLU   100       6.140 -15.362  -3.120  1.00  0.00
ATOM   1572  HN  GLU   100       5.799 -16.168  -3.552  1.00  0.00
ATOM   1573  CA  GLU   100       6.635 -14.292  -3.986  1.00  0.00
ATOM   1574  HA  GLU   100       6.837 -13.403  -3.389  1.00  0.00
ATOM   1575  CB  GLU   100       7.924 -14.756  -4.689  1.00  0.00
ATOM   1576  HB1 GLU   100       7.710 -15.675  -5.228  1.00  0.00
ATOM   1577  HB2 GLU   100       8.666 -14.976  -3.929  1.00  0.00
ATOM   1578  CG  GLU   100       8.539 -13.747  -5.672  1.00  0.00
ATOM   1579  HG1 GLU   100       9.022 -12.957  -5.104  1.00  0.00
ATOM   1580  HG2 GLU   100       7.746 -13.305  -6.273  1.00  0.00
ATOM   1581  CD  GLU   100       9.573 -14.401  -6.605  1.00  0.00
ATOM   1582  OE1 GLU   100      10.791 -14.386  -6.294  1.00  0.00
ATOM   1583  OE2 GLU   100       9.166 -14.934  -7.661  1.00  0.00
ATOM   1584  C   GLU   100       5.548 -13.992  -5.020  1.00  0.00
ATOM   1585  O   GLU   100       5.161 -14.879  -5.779  1.00  0.00
ATOM   1586  N   VAL   101       5.052 -12.755  -5.023  1.00  0.00
ATOM   1587  HN  VAL   101       5.439 -12.110  -4.407  1.00  0.00
ATOM   1588  CA  VAL   101       3.972 -12.303  -5.902  1.00  0.00
ATOM   1589  HA  VAL   101       3.516 -13.172  -6.376  1.00  0.00
ATOM   1590  CB  VAL   101       2.862 -11.562  -5.069  1.00  0.00
ATOM   1591  HB  VAL   101       3.329 -10.703  -4.590  1.00  0.00
ATOM   1592  CG1 VAL   101       1.715 -11.036  -5.970  1.00  0.00
ATOM   1593 HG11 VAL   101       1.243 -11.864  -6.486  1.00  0.00
ATOM   1594 HG12 VAL   101       2.108 -10.340  -6.704  1.00  0.00
ATOM   1595 HG13 VAL   101       0.975 -10.526  -5.364  1.00  0.00
ATOM   1596  CG2 VAL   101       2.309 -12.478  -3.948  1.00  0.00
ATOM   1597 HG21 VAL   101       1.829 -13.343  -4.391  1.00  0.00
ATOM   1598 HG22 VAL   101       1.583 -11.934  -3.354  1.00  0.00
ATOM   1599 HG23 VAL   101       3.117 -12.808  -3.305  1.00  0.00
ATOM   1600  C   VAL   101       4.542 -11.376  -6.989  1.00  0.00
ATOM   1601  O   VAL   101       5.094 -10.313  -6.680  1.00  0.00
ATOM   1602  N   GLU   102       4.414 -11.797  -8.255  1.00  0.00
ATOM   1603  HN  GLU   102       4.015 -12.676  -8.413  1.00  0.00
ATOM   1604  CA  GLU   102       4.833 -11.014  -9.426  1.00  0.00
ATOM   1605  HA  GLU   102       5.103 -10.015  -9.088  1.00  0.00
ATOM   1606  CB  GLU   102       6.062 -11.670 -10.097  1.00  0.00
ATOM   1607  HB1 GLU   102       5.778 -12.660 -10.438  1.00  0.00
ATOM   1608  HB2 GLU   102       6.847 -11.774  -9.356  1.00  0.00
ATOM   1609  CG  GLU   102       6.631 -10.893 -11.295  1.00  0.00
ATOM   1610  HG1 GLU   102       6.831  -9.871 -10.984  1.00  0.00
ATOM   1611  HG2 GLU   102       5.880 -10.874 -12.075  1.00  0.00
ATOM   1612  CD  GLU   102       7.921 -11.503 -11.871  1.00  0.00
ATOM   1613  OE1 GLU   102       7.840 -12.466 -12.663  1.00  0.00
ATOM   1614  OE2 GLU   102       9.026 -11.036 -11.517  1.00  0.00
ATOM   1615  C   GLU   102       3.654 -10.904 -10.411  1.00  0.00
ATOM   1616  O   GLU   102       2.986 -11.901 -10.698  1.00  0.00
ATOM   1617  N   ASN   103       3.415  -9.671 -10.900  1.00  0.00
ATOM   1618  HN  ASN   103       4.039  -8.959 -10.649  1.00  0.00
ATOM   1619  CA  ASN   103       2.282  -9.312 -11.789  1.00  0.00
ATOM   1620  HA  ASN   103       2.366  -8.247 -11.968  1.00  0.00
ATOM   1621  CB  ASN   103       2.369 -10.049 -13.169  1.00  0.00
ATOM   1622  HB1 ASN   103       1.503  -9.781 -13.766  1.00  0.00
ATOM   1623  HB2 ASN   103       2.346 -11.118 -12.998  1.00  0.00
ATOM   1624  CG  ASN   103       3.638  -9.702 -13.971  1.00  0.00
ATOM   1625  OD1 ASN   103       3.676  -8.714 -14.704  1.00  0.00
ATOM   1626  ND2 ASN   103       4.669 -10.528 -13.866  1.00  0.00
ATOM   1627 HD21 ASN   103       4.576 -11.319 -13.290  1.00  0.00
ATOM   1628 HD22 ASN   103       5.485 -10.318 -14.365  1.00  0.00
ATOM   1629  C   ASN   103       0.907  -9.560 -11.102  1.00  0.00
ATOM   1630  O   ASN   103      -0.110  -9.771 -11.776  1.00  0.00
ATOM   1631  N   GLY   104       0.884  -9.459  -9.754  1.00  0.00
ATOM   1632  HN  GLY   104       1.727  -9.269  -9.290  1.00  0.00
ATOM   1633  CA  GLY   104      -0.350  -9.611  -8.961  1.00  0.00
ATOM   1634  HA1 GLY   104      -1.184  -9.203  -9.520  1.00  0.00
ATOM   1635  HA2 GLY   104      -0.237  -9.035  -8.053  1.00  0.00
ATOM   1636  C   GLY   104      -0.682 -11.057  -8.573  1.00  0.00
ATOM   1637  O   GLY   104      -1.597 -11.294  -7.775  1.00  0.00
ATOM   1638  N   ARG   105       0.078 -12.022  -9.117  1.00  0.00
ATOM   1639  HN  ARG   105       0.847 -11.758  -9.666  1.00  0.00
ATOM   1640  CA  ARG   105      -0.132 -13.466  -8.876  1.00  0.00
ATOM   1641  HA  ARG   105      -0.949 -13.597  -8.168  1.00  0.00
ATOM   1642  CB  ARG   105      -0.469 -14.204 -10.201  1.00  0.00
ATOM   1643  HB1 ARG   105      -0.617 -15.260  -9.986  1.00  0.00
ATOM   1644  HB2 ARG   105       0.373 -14.106 -10.876  1.00  0.00
ATOM   1645  CG  ARG   105      -1.723 -13.684 -10.940  1.00  0.00
ATOM   1646  HG1 ARG   105      -1.778 -14.170 -11.911  1.00  0.00
ATOM   1647  HG2 ARG   105      -1.617 -12.616 -11.093  1.00  0.00
ATOM   1648  CD  ARG   105      -3.043 -13.942 -10.190  1.00  0.00
ATOM   1649  HD1 ARG   105      -2.951 -13.596  -9.168  1.00  0.00
ATOM   1650  HD2 ARG   105      -3.248 -15.009 -10.193  1.00  0.00
ATOM   1651  NE  ARG   105      -4.156 -13.215 -10.838  1.00  0.00
ATOM   1652  HE  ARG   105      -3.928 -12.348 -11.233  1.00  0.00
ATOM   1653  CZ  ARG   105      -5.432 -13.615 -10.931  1.00  0.00
ATOM   1654  NH1 ARG   105      -5.830 -14.779 -10.457  1.00  0.00
ATOM   1655 HH11 ARG   105      -5.176 -15.394 -10.017  1.00  0.00
ATOM   1656 HH12 ARG   105      -6.792 -15.061 -10.546  1.00  0.00
ATOM   1657  NH2 ARG   105      -6.311 -12.827 -11.526  1.00  0.00
ATOM   1658 HH21 ARG   105      -6.021 -11.944 -11.902  1.00  0.00
ATOM   1659 HH22 ARG   105      -7.269 -13.112 -11.617  1.00  0.00
ATOM   1660  C   ARG   105       1.146 -14.039  -8.272  1.00  0.00
ATOM   1661  O   ARG   105       2.232 -13.543  -8.565  1.00  0.00
ATOM   1662  N   ILE   106       1.022 -15.070  -7.430  1.00  0.00
ATOM   1663  HN  ILE   106       0.127 -15.399  -7.216  1.00  0.00
ATOM   1664  CA  ILE   106       2.186 -15.718  -6.820  1.00  0.00
ATOM   1665  HA  ILE   106       2.800 -14.933  -6.371  1.00  0.00
ATOM   1666  CB  ILE   106       1.775 -16.720  -5.683  1.00  0.00
ATOM   1667  HB  ILE   106       1.107 -17.458  -6.117  1.00  0.00
ATOM   1668  CG1 ILE   106       1.012 -15.962  -4.557  1.00  0.00
ATOM   1669 HG11 ILE   106       0.097 -15.544  -4.965  1.00  0.00
ATOM   1670 HG12 ILE   106       1.631 -15.156  -4.189  1.00  0.00
ATOM   1671  CG2 ILE   106       3.001 -17.477  -5.105  1.00  0.00
ATOM   1672 HG21 ILE   106       3.696 -16.769  -4.671  1.00  0.00
ATOM   1673 HG22 ILE   106       3.498 -18.025  -5.896  1.00  0.00
ATOM   1674 HG23 ILE   106       2.677 -18.174  -4.342  1.00  0.00
ATOM   1675  CD1 ILE   106       0.637 -16.813  -3.369  1.00  0.00
ATOM   1676 HD11 ILE   106       0.046 -17.658  -3.701  1.00  0.00
ATOM   1677 HD12 ILE   106       0.058 -16.222  -2.674  1.00  0.00
ATOM   1678 HD13 ILE   106       1.531 -17.170  -2.877  1.00  0.00
ATOM   1679  C   ILE   106       3.015 -16.423  -7.904  1.00  0.00
ATOM   1680  O   ILE   106       2.582 -17.414  -8.479  1.00  0.00
ATOM   1681  N   ALA   107       4.199 -15.862  -8.177  1.00  0.00
ATOM   1682  HN  ALA   107       4.455 -15.062  -7.676  1.00  0.00
ATOM   1683  CA  ALA   107       5.130 -16.371  -9.187  1.00  0.00
ATOM   1684  HA  ALA   107       4.568 -16.617 -10.084  1.00  0.00
ATOM   1685  CB  ALA   107       6.154 -15.279  -9.543  1.00  0.00
ATOM   1686  HB1 ALA   107       5.640 -14.397  -9.917  1.00  0.00
ATOM   1687  HB2 ALA   107       6.832 -15.640 -10.305  1.00  0.00
ATOM   1688  HB3 ALA   107       6.723 -15.006  -8.660  1.00  0.00
ATOM   1689  C   ALA   107       5.851 -17.624  -8.674  1.00  0.00
ATOM   1690  O   ALA   107       6.074 -18.580  -9.430  1.00  0.00
ATOM   1691  N   LYS   108       6.194 -17.607  -7.375  1.00  0.00
ATOM   1692  HN  LYS   108       5.915 -16.832  -6.831  1.00  0.00
ATOM   1693  CA  LYS   108       6.942 -18.685  -6.701  1.00  0.00
ATOM   1694  HA  LYS   108       6.708 -19.631  -7.187  1.00  0.00
ATOM   1695  CB  LYS   108       8.472 -18.426  -6.773  1.00  0.00
ATOM   1696  HB1 LYS   108       8.980 -19.140  -6.128  1.00  0.00
ATOM   1697  HB2 LYS   108       8.670 -17.427  -6.397  1.00  0.00
ATOM   1698  CG  LYS   108       9.079 -18.538  -8.184  1.00  0.00
ATOM   1699  HG1 LYS   108       8.475 -17.946  -8.865  1.00  0.00
ATOM   1700  HG2 LYS   108       9.045 -19.574  -8.498  1.00  0.00
ATOM   1701  CD  LYS   108      10.537 -18.048  -8.262  1.00  0.00
ATOM   1702  HD1 LYS   108      11.166 -18.699  -7.662  1.00  0.00
ATOM   1703  HD2 LYS   108      10.592 -17.037  -7.867  1.00  0.00
ATOM   1704  CE  LYS   108      11.059 -18.041  -9.707  1.00  0.00
ATOM   1705  HE1 LYS   108      10.418 -17.410 -10.314  1.00  0.00
ATOM   1706  HE2 LYS   108      11.037 -19.050 -10.101  1.00  0.00
ATOM   1707  NZ  LYS   108      12.447 -17.533  -9.804  1.00  0.00
ATOM   1708  HZ1 LYS   108      12.491 -16.547  -9.472  1.00  0.00
ATOM   1709  HZ2 LYS   108      12.773 -17.570 -10.790  1.00  0.00
ATOM   1710  HZ3 LYS   108      13.078 -18.110  -9.219  1.00  0.00
ATOM   1711  C   LYS   108       6.513 -18.750  -5.239  1.00  0.00
ATOM   1712  O   LYS   108       6.220 -17.721  -4.642  1.00  0.00
ATOM   1713  N   ALA   109       6.502 -19.953  -4.665  1.00  0.00
ATOM   1714  HN  ALA   109       6.737 -20.734  -5.208  1.00  0.00
ATOM   1715  CA  ALA   109       6.172 -20.164  -3.255  1.00  0.00
ATOM   1716  HA  ALA   109       6.435 -19.255  -2.705  1.00  0.00
ATOM   1717  CB  ALA   109       4.675 -20.420  -3.061  1.00  0.00
ATOM   1718  HB1 ALA   109       4.110 -19.584  -3.452  1.00  0.00
ATOM   1719  HB2 ALA   109       4.451 -20.530  -2.004  1.00  0.00
ATOM   1720  HB3 ALA   109       4.380 -21.325  -3.582  1.00  0.00
ATOM   1721  C   ALA   109       6.998 -21.320  -2.707  1.00  0.00
ATOM   1722  O   ALA   109       7.227 -22.318  -3.385  1.00  0.00
ATOM   1723  N   TRP   110       7.465 -21.142  -1.486  1.00  0.00
ATOM   1724  HN  TRP   110       7.229 -20.320  -1.027  1.00  0.00
ATOM   1725  CA  TRP   110       8.314 -22.088  -0.766  1.00  0.00
ATOM   1726  HA  TRP   110       8.312 -23.046  -1.280  1.00  0.00
ATOM   1727  CB  TRP   110       9.773 -21.523  -0.680  1.00  0.00
ATOM   1728  HB1 TRP   110      10.456 -22.341  -0.472  1.00  0.00
ATOM   1729  HB2 TRP   110       9.837 -20.806   0.130  1.00  0.00
ATOM   1730  CG  TRP   110      10.254 -20.819  -1.942  1.00  0.00
ATOM   1731  CD1 TRP   110      10.829 -21.392  -3.027  1.00  0.00
ATOM   1732  HD1 TRP   110      11.029 -22.441  -3.116  1.00  0.00
ATOM   1733  CD2 TRP   110      10.173 -19.414  -2.249  1.00  0.00
ATOM   1734  NE1 TRP   110      11.114 -20.458  -3.978  1.00  0.00
ATOM   1735  HE1 TRP   110      11.535 -20.638  -4.845  1.00  0.00
ATOM   1736  CE2 TRP   110      10.722 -19.236  -3.527  1.00  0.00
ATOM   1737  CE3 TRP   110       9.684 -18.298  -1.572  1.00  0.00
ATOM   1738  HE3 TRP   110       9.250 -18.392  -0.588  1.00  0.00
ATOM   1739  CZ2 TRP   110      10.812 -17.991  -4.134  1.00  0.00
ATOM   1740  HZ2 TRP   110      11.239 -17.864  -5.121  1.00  0.00
ATOM   1741  CZ3 TRP   110       9.770 -17.060  -2.173  1.00  0.00
ATOM   1742  HZ3 TRP   110       9.399 -16.182  -1.657  1.00  0.00
ATOM   1743  CH2 TRP   110      10.328 -16.917  -3.446  1.00  0.00
ATOM   1744  HH2 TRP   110      10.376 -15.926  -3.883  1.00  0.00
ATOM   1745  C   TRP   110       7.708 -22.259   0.635  1.00  0.00
ATOM   1746  O   TRP   110       6.983 -21.371   1.105  1.00  0.00
ATOM   1747  N   PHE   111       7.969 -23.381   1.302  1.00  0.00
ATOM   1748  HN  PHE   111       8.426 -24.118   0.848  1.00  0.00
ATOM   1749  CA  PHE   111       7.574 -23.541   2.713  1.00  0.00
ATOM   1750  HA  PHE   111       7.517 -22.541   3.155  1.00  0.00
ATOM   1751  CB  PHE   111       6.172 -24.216   2.858  1.00  0.00
ATOM   1752  HB1 PHE   111       5.495 -23.767   2.137  1.00  0.00
ATOM   1753  HB2 PHE   111       5.784 -24.007   3.851  1.00  0.00
ATOM   1754  CG  PHE   111       6.127 -25.733   2.651  1.00  0.00
ATOM   1755  CD1 PHE   111       6.113 -26.601   3.748  1.00  0.00
ATOM   1756  HD1 PHE   111       6.134 -26.191   4.750  1.00  0.00
ATOM   1757  CD2 PHE   111       6.102 -26.292   1.375  1.00  0.00
ATOM   1758  HD2 PHE   111       6.113 -25.645   0.507  1.00  0.00
ATOM   1759  CE1 PHE   111       6.072 -27.967   3.576  1.00  0.00
ATOM   1760  HE1 PHE   111       6.066 -28.618   4.446  1.00  0.00
ATOM   1761  CE2 PHE   111       6.058 -27.666   1.203  1.00  0.00
ATOM   1762  HE2 PHE   111       6.036 -28.085   0.203  1.00  0.00
ATOM   1763  CZ  PHE   111       6.044 -28.503   2.302  1.00  0.00
ATOM   1764  HZ  PHE   111       6.010 -29.578   2.166  1.00  0.00
ATOM   1765  C   PHE   111       8.658 -24.311   3.463  1.00  0.00
ATOM   1766  O   PHE   111       9.311 -25.203   2.897  1.00  0.00
ATOM   1767  N   LYS   112       8.853 -23.944   4.733  1.00  0.00
ATOM   1768  HN  LYS   112       8.345 -23.179   5.081  1.00  0.00
ATOM   1769  CA  LYS   112       9.775 -24.624   5.639  1.00  0.00
ATOM   1770  HA  LYS   112      10.080 -25.557   5.172  1.00  0.00
ATOM   1771  CB  LYS   112      11.048 -23.763   5.904  1.00  0.00
ATOM   1772  HB1 LYS   112      11.567 -23.625   4.959  1.00  0.00
ATOM   1773  HB2 LYS   112      11.705 -24.320   6.568  1.00  0.00
ATOM   1774  CG  LYS   112      10.812 -22.366   6.527  1.00  0.00
ATOM   1775  HG1 LYS   112      10.194 -22.481   7.412  1.00  0.00
ATOM   1776  HG2 LYS   112      10.289 -21.745   5.807  1.00  0.00
ATOM   1777  CD  LYS   112      12.137 -21.673   6.926  1.00  0.00
ATOM   1778  HD1 LYS   112      12.744 -21.538   6.035  1.00  0.00
ATOM   1779  HD2 LYS   112      12.672 -22.314   7.619  1.00  0.00
ATOM   1780  CE  LYS   112      11.934 -20.306   7.597  1.00  0.00
ATOM   1781  HE1 LYS   112      11.281 -20.419   8.454  1.00  0.00
ATOM   1782  HE2 LYS   112      11.476 -19.624   6.889  1.00  0.00
ATOM   1783  NZ  LYS   112      13.224 -19.721   8.052  1.00  0.00
ATOM   1784  HZ1 LYS   112      13.667 -20.339   8.762  1.00  0.00
ATOM   1785  HZ2 LYS   112      13.065 -18.784   8.468  1.00  0.00
ATOM   1786  HZ3 LYS   112      13.871 -19.623   7.246  1.00  0.00
ATOM   1787  C   LYS   112       9.041 -24.961   6.939  1.00  0.00
ATOM   1788  O   LYS   112       8.473 -24.080   7.585  1.00  0.00
ATOM   1789  N   ILE   113       9.040 -26.250   7.322  1.00  0.00
ATOM   1790  HN  ILE   113       9.508 -26.906   6.774  1.00  0.00
ATOM   1791  CA  ILE   113       8.370 -26.703   8.547  1.00  0.00
ATOM   1792  HA  ILE   113       7.521 -26.041   8.731  1.00  0.00
ATOM   1793  CB  ILE   113       7.816 -28.165   8.418  1.00  0.00
ATOM   1794  HB  ILE   113       8.638 -28.807   8.123  1.00  0.00
ATOM   1795  CG1 ILE   113       6.712 -28.224   7.318  1.00  0.00
ATOM   1796 HG11 ILE   113       7.049 -27.713   6.424  1.00  0.00
ATOM   1797 HG12 ILE   113       5.829 -27.716   7.680  1.00  0.00
ATOM   1798  CG2 ILE   113       7.259 -28.692   9.777  1.00  0.00
ATOM   1799 HG21 ILE   113       6.885 -29.702   9.653  1.00  0.00
ATOM   1800 HG22 ILE   113       6.450 -28.056  10.113  1.00  0.00
ATOM   1801 HG23 ILE   113       8.045 -28.690  10.523  1.00  0.00
ATOM   1802  CD1 ILE   113       6.289 -29.624   6.937  1.00  0.00
ATOM   1803 HD11 ILE   113       7.147 -30.184   6.587  1.00  0.00
ATOM   1804 HD12 ILE   113       5.550 -29.574   6.153  1.00  0.00
ATOM   1805 HD13 ILE   113       5.865 -30.117   7.799  1.00  0.00
ATOM   1806  C   ILE   113       9.363 -26.597   9.707  1.00  0.00
ATOM   1807  O   ILE   113      10.473 -27.147   9.642  1.00  0.00
ATOM   1808  N   GLY   114       8.949 -25.855  10.735  1.00  0.00
ATOM   1809  HN  GLY   114       8.035 -25.487  10.695  1.00  0.00
ATOM   1810  CA  GLY   114       9.788 -25.579  11.902  1.00  0.00
ATOM   1811  HA1 GLY   114       9.270 -24.872  12.536  1.00  0.00
ATOM   1812  HA2 GLY   114      10.716 -25.124  11.570  1.00  0.00
ATOM   1813  C   GLY   114      10.096 -26.827  12.718  1.00  0.00
ATOM   1814  O   GLY   114      11.252 -27.278  12.764  1.00  0.00
ATOM   1815  N   GLU   115       9.053 -27.397  13.343  1.00  0.00
ATOM   1816  HN  GLU   115       8.162 -26.994  13.241  1.00  0.00
ATOM   1817  CA  GLU   115       9.172 -28.619  14.151  1.00  0.00
ATOM   1818  HA  GLU   115       9.852 -29.295  13.644  1.00  0.00
ATOM   1819  CB  GLU   115       9.728 -28.287  15.575  1.00  0.00
ATOM   1820  HB1 GLU   115      10.550 -27.585  15.476  1.00  0.00
ATOM   1821  HB2 GLU   115      10.109 -29.202  16.018  1.00  0.00
ATOM   1822  CG  GLU   115       8.686 -27.683  16.540  1.00  0.00
ATOM   1823  HG1 GLU   115       7.840 -28.377  16.594  1.00  0.00
ATOM   1824  HG2 GLU   115       8.331 -26.745  16.126  1.00  0.00
ATOM   1825  CD  GLU   115       9.222 -27.446  17.960  1.00  0.00
ATOM   1826  OE1 GLU   115       9.196 -28.387  18.779  1.00  0.00
ATOM   1827  OE2 GLU   115       9.645 -26.314  18.276  1.00  0.00
ATOM   1828  C   GLU   115       7.789 -29.299  14.272  1.00  0.00
ATOM   1829  O   GLU   115       6.761 -28.666  13.976  1.00  0.00
ATOM   1830  N   PRO   116       7.741 -30.602  14.687  1.00  0.00
ATOM   1831  CA  PRO   116       6.494 -31.239  15.173  1.00  0.00
ATOM   1832  HA  PRO   116       5.641 -30.943  14.576  1.00  0.00
ATOM   1833  CB  PRO   116       6.790 -32.733  14.950  1.00  0.00
ATOM   1834  HB1 PRO   116       6.506 -32.996  13.942  1.00  0.00
ATOM   1835  HB2 PRO   116       6.227 -33.346  15.649  1.00  0.00
ATOM   1836  CG  PRO   116       8.272 -32.873  15.146  1.00  0.00
ATOM   1837  HG1 PRO   116       8.648 -33.718  14.577  1.00  0.00
ATOM   1838  HG2 PRO   116       8.494 -33.012  16.201  1.00  0.00
ATOM   1839  CD  PRO   116       8.876 -31.579  14.638  1.00  0.00
ATOM   1840  HD1 PRO   116       9.233 -31.695  13.621  1.00  0.00
ATOM   1841  HD2 PRO   116       9.687 -31.253  15.282  1.00  0.00
ATOM   1842  C   PRO   116       6.206 -30.918  16.661  1.00  0.00
ATOM   1843  O   PRO   116       7.129 -30.919  17.488  1.00  0.00
ATOM   1844  N   ARG   117       4.924 -30.616  16.993  1.00  0.00
ATOM   1845  HN  ARG   117       4.262 -30.532  16.275  1.00  0.00
ATOM   1846  CA  ARG   117       4.478 -30.391  18.393  1.00  0.00
ATOM   1847  HA  ARG   117       5.260 -30.770  19.040  1.00  0.00
ATOM   1848  CB  ARG   117       4.276 -28.879  18.700  1.00  0.00
ATOM   1849  HB1 ARG   117       3.834 -28.780  19.688  1.00  0.00
ATOM   1850  HB2 ARG   117       3.586 -28.466  17.969  1.00  0.00
ATOM   1851  CG  ARG   117       5.565 -28.041  18.664  1.00  0.00
ATOM   1852  HG1 ARG   117       5.961 -28.057  17.652  1.00  0.00
ATOM   1853  HG2 ARG   117       6.297 -28.484  19.334  1.00  0.00
ATOM   1854  CD  ARG   117       5.337 -26.586  19.081  1.00  0.00
ATOM   1855  HD1 ARG   117       4.955 -26.564  20.096  1.00  0.00
ATOM   1856  HD2 ARG   117       4.603 -26.141  18.414  1.00  0.00
ATOM   1857  NE  ARG   117       6.581 -25.804  19.027  1.00  0.00
ATOM   1858  HE  ARG   117       7.418 -26.293  19.188  1.00  0.00
ATOM   1859  CZ  ARG   117       6.657 -24.493  18.783  1.00  0.00
ATOM   1860  NH1 ARG   117       5.561 -23.791  18.512  1.00  0.00
ATOM   1861 HH11 ARG   117       4.663 -24.247  18.479  1.00  0.00
ATOM   1862 HH12 ARG   117       5.617 -22.807  18.348  1.00  0.00
ATOM   1863  NH2 ARG   117       7.837 -23.897  18.772  1.00  0.00
ATOM   1864 HH21 ARG   117       8.673 -24.434  18.945  1.00  0.00
ATOM   1865 HH22 ARG   117       7.911 -22.914  18.593  1.00  0.00
ATOM   1866  C   ARG   117       3.185 -31.163  18.716  1.00  0.00
ATOM   1867  O   ARG   117       2.409 -31.535  17.826  1.00  0.00
ATOM   1868  N   ILE   118       2.974 -31.375  20.032  1.00  0.00
ATOM   1869  HN  ILE   118       3.617 -30.990  20.664  1.00  0.00
ATOM   1870  CA  ILE   118       1.835 -32.123  20.603  1.00  0.00
ATOM   1871  HA  ILE   118       1.035 -32.176  19.864  1.00  0.00
ATOM   1872  CB  ILE   118       2.265 -33.596  21.008  1.00  0.00
ATOM   1873  HB  ILE   118       3.094 -33.515  21.708  1.00  0.00
ATOM   1874  CG1 ILE   118       2.754 -34.407  19.770  1.00  0.00
ATOM   1875 HG11 ILE   118       3.130 -35.368  20.099  1.00  0.00
ATOM   1876 HG12 ILE   118       3.559 -33.868  19.289  1.00  0.00
ATOM   1877  CG2 ILE   118       1.130 -34.358  21.729  1.00  0.00
ATOM   1878 HG21 ILE   118       0.866 -33.840  22.644  1.00  0.00
ATOM   1879 HG22 ILE   118       1.449 -35.363  21.972  1.00  0.00
ATOM   1880 HG23 ILE   118       0.255 -34.405  21.084  1.00  0.00
ATOM   1881  CD1 ILE   118       1.695 -34.665  18.720  1.00  0.00
ATOM   1882 HD11 ILE   118       0.912 -35.278  19.142  1.00  0.00
ATOM   1883 HD12 ILE   118       2.138 -35.173  17.878  1.00  0.00
ATOM   1884 HD13 ILE   118       1.271 -33.722  18.393  1.00  0.00
ATOM   1885  C   ILE   118       1.334 -31.368  21.850  1.00  0.00
ATOM   1886  O   ILE   118       2.152 -30.899  22.641  1.00  0.00
END
