
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  133 ( 1020),  selected  133 , name 2a15_A
# Molecule2: number of CA atoms  117 ( 1867),  selected  117 , name T0475.pdb
# PARAMETERS: 2a15_A.T0475.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T     5_A      -       -           -
LGA    Q     6_A      N       2           #
LGA    S     7_A      S       3          1.557
LGA    P     8_A      E       4          1.672
LGA    A     9_A      I       5          1.783
LGA    L    10_A      E       6          1.495
LGA    I    11_A      L       7          1.419
LGA    A    12_A      P       8          0.959
LGA    S    13_A      V       9          0.798
LGA    Q    14_A      Q      10          0.978
LGA    S    15_A      K      11          0.844
LGA    S    16_A      Q      12          0.693
LGA    W    17_A      L      13          1.191
LGA    R    18_A      E      14          1.411
LGA    C    19_A      A      15          1.299
LGA    V    20_A      Y      16          1.540
LGA    Q    21_A      N      17          2.274
LGA    A    22_A      A      18          2.130
LGA    H    23_A      R      19          1.039
LGA    D    24_A      D      20          1.125
LGA    R    25_A      I      21          1.512
LGA    E    26_A      D      22          1.698
LGA    G    27_A      A      23          1.911
LGA    W    28_A      F      24          1.279
LGA    L    29_A      M      25          1.329
LGA    A    30_A      A      26          1.267
LGA    L    31_A      W      27          1.659
LGA    M    32_A      W      28          1.322
LGA    A    33_A      A      29          0.502
LGA    D    34_A      D      30          1.071
LGA    D    35_A      D      31          1.526
LGA    V    36_A      C      32          1.340
LGA    V    37_A      Q      33          1.808
LGA    I    38_A      Y      34          2.071
LGA    E    39_A      Y      35          2.396
LGA    D    40_A      A      36          4.062
LGA    P    41_A      F      37          3.489
LGA    I    42_A      P      38          3.207
LGA    G    43_A      -       -           -
LGA    K    44_A      -       -           -
LGA    S    45_A      -       -           -
LGA    V    46_A      -       -           -
LGA    T    47_A      -       -           -
LGA    N    48_A      -       -           -
LGA    P    49_A      -       -           -
LGA    D    50_A      -       -           -
LGA    G    51_A      A      39          5.788
LGA    S    52_A      T      40          1.881
LGA    G    53_A      L      41          2.300
LGA    I    54_A      L      42          2.236
LGA    K    55_A      A      43          1.588
LGA    -       -      G      44           -
LGA    G    56_A      N      45          1.335
LGA    K    57_A      A      46          1.958
LGA    E    58_A      A      47          2.008
LGA    A    59_A      E      48          1.316
LGA    V    60_A      I      49          1.290
LGA    G    61_A      R      50          2.236
LGA    A    62_A      V      51          1.750
LGA    F    63_A      R      52          0.568
LGA    F    64_A      H      53          1.463
LGA    D    65_A      I      54          1.651
LGA    T    66_A      E      55          1.298
LGA    H    67_A      R      56          2.203
LGA    I    68_A      -       -           -
LGA    A    69_A      F      57          0.499
LGA    A    70_A      K      58          1.487
LGA    N    71_A      E      59          2.520
LGA    R    72_A      P      60          3.720
LGA    -       -      D      61           -
LGA    L    73_A      L      62          2.219
LGA    T    74_A      Y      63          1.368
LGA    V    75_A      G      64          1.259
LGA    T    76_A      E      65          1.894
LGA    C    77_A      L      66          1.836
LGA    E    78_A      L      67          1.016
LGA    E    79_A      T      68          1.380
LGA    T    80_A      R      69          1.946
LGA    F    81_A      V      70          1.571
LGA    P    82_A      I      71          1.939
LGA    S    83_A      V      72          1.234
LGA    S    84_A      G      73          3.731
LGA    S    85_A      -       -           -
LGA    P    86_A      -       -           -
LGA    D    87_A      N      74          1.899
LGA    E    88_A      V      75          1.258
LGA    I    89_A      V      76          1.653
LGA    A    90_A      I      77          1.542
LGA    H    91_A      D      78          2.930
LGA    I    92_A      H      79          2.132
LGA    L    93_A      E      80          1.563
LGA    V    94_A      T      81          1.435
LGA    L    95_A      V      82          1.434
LGA    H    96_A      T      83          1.233
LGA    S    97_A      R      84          1.819
LGA    E    98_A      N      85          2.973
LGA    F    99_A      F      86          5.720
LGA    D   100_A      -       -           -
LGA    G   101_A      -       -           -
LGA    G   102_A      -       -           -
LGA    F   103_A      -       -           -
LGA    T   104_A      -       -           -
LGA    S   105_A      P      87           #
LGA    -       -      E      88           -
LGA    -       -      G      89           -
LGA    -       -      K      90           -
LGA    -       -      G      91           -
LGA    E   106_A      E      92          1.156
LGA    V   107_A      V      93          1.262
LGA    R   108_A      D      94          1.255
LGA    G   109_A      V      95          2.690
LGA    V   110_A      A      96          2.301
LGA    F   111_A      C      97          2.301
LGA    T   112_A      I      98          1.291
LGA    Y   113_A      Y      99          1.106
LGA    R   114_A      E     100          0.777
LGA    V   115_A      V     101          0.785
LGA    N   116_A      E     102          1.146
LGA    K   117_A      N     103          1.586
LGA    A   118_A      G     104          2.683
LGA    G   119_A      -       -           -
LGA    L   120_A      R     105          1.153
LGA    I   121_A      I     106          1.314
LGA    T   122_A      A     107          1.898
LGA    N   123_A      K     108          2.075
LGA    M   124_A      A     109          2.127
LGA    R   125_A      W     110          1.605
LGA    G   126_A      F     111          1.694
LGA    Y   127_A      K     112          2.223
LGA    W   128_A      I     113          1.863
LGA    N   129_A      G     114          5.367
LGA    L   130_A      -       -           -
LGA    D   131_A      -       -           -
LGA    M   132_A      E     115          1.249
LGA    M   133_A      P     116          0.660
LGA    T   134_A      R     117          1.551
LGA    F   135_A      I     118          3.372
LGA    G   136_A      -       -           -
LGA    N   137_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  133  117    5.0    109    2.03    13.76     73.146     5.119

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.665248 * X  +  -0.571843 * Y  +  -0.480043 * Z  + -11.322639
  Y_new =   0.178737 * X  +  -0.502281 * Y  +   0.846030 * Z  + -30.818443
  Z_new =  -0.724913 * X  +  -0.648621 * Y  +  -0.231932 * Z  +  -1.319227 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.914206    1.227387  [ DEG:  -109.6759     70.3241 ]
  Theta =   0.810908    2.330685  [ DEG:    46.4616    133.5384 ]
  Phi   =   0.262478   -2.879114  [ DEG:    15.0389   -164.9611 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2a15_A                                        
REMARK     2: T0475.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2a15_A.T0475.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  133  117   5.0  109   2.03   13.76  73.146
REMARK  ---------------------------------------------------------- 
MOLECULE 2a15_A
HEADER    UNKNOWN FUNCTION                        17-JUN-05   2A15              
TITLE     X-RAY CRYSTAL STRUCTURE OF RV0760 FROM MYCOBACTERIUM                  
TITLE    2 TUBERCULOSIS AT 1.68 ANGSTROM RESOLUTION                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN RV0760C;                              
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES;                                                     
COMPND   5 OTHER_DETAILS: SIMILARITY WITH PDB IDS 1BUQ, 1CQS, 1E3R,             
COMPND   6 1E3V, 1OH0 ETC. SUGGESTS  THAT THIS PROTEIN IS KETOSTEROID           
COMPND   7 ISOMERASE                                                            
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MYCOBACTERIUM TUBERCULOSIS;                     
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: RV0760;                                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA                                   
KEYWDS    BETA-ALPHA-BARREL, STRUCTURAL GENOMICS, PSI, PROTEIN                  
KEYWDS   2 STRUCTURE INITIATIVE, TB STRUCTURAL GENOMICS CONSORTIUM,             
KEYWDS   3 TBSGC                                                                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    C.R.GAREN,M.M.CHERNEY,M.N.G.JAMES,TB STRUCTURAL GENOMICS              
AUTHOR   2 CONSORTIUM (TBSGC)                                                   
REVDAT   2   14-NOV-06 2A15    1       AUTHOR COMPND KEYWDS REMARK              
REVDAT   1   11-OCT-05 2A15    0                                                
JRNL        AUTH   C.R.GAREN,M.M.CHERNEY,M.N.G.JAMES                            
JRNL        TITL   X-RAY CRYSTAL STRUCTURE OF RV0760 FROM                       
JRNL        TITL 2 MYCOBACTERIUM TUBERCULOSIS AT 1.68 ANGSTROM                  
JRNL        TITL 3 RESOLUTION                                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.68 ANGSTROMS.                                          
DBREF  2A15 A    1   139  UNP    P71817   P71817_MYCTU     1    139             
SEQRES   1 A  139  MET THR GLN THR THR GLN SER PRO ALA LEU ILE ALA SER          
SEQRES   2 A  139  GLN SER SER TRP ARG CYS VAL GLN ALA HIS ASP ARG GLU          
SEQRES   3 A  139  GLY TRP LEU ALA LEU MET ALA ASP ASP VAL VAL ILE GLU          
SEQRES   4 A  139  ASP PRO ILE GLY LYS SER VAL THR ASN PRO ASP GLY SER          
SEQRES   5 A  139  GLY ILE LYS GLY LYS GLU ALA VAL GLY ALA PHE PHE ASP          
SEQRES   6 A  139  THR HIS ILE ALA ALA ASN ARG LEU THR VAL THR CYS GLU          
SEQRES   7 A  139  GLU THR PHE PRO SER SER SER PRO ASP GLU ILE ALA HIS          
SEQRES   8 A  139  ILE LEU VAL LEU HIS SER GLU PHE ASP GLY GLY PHE THR          
SEQRES   9 A  139  SER GLU VAL ARG GLY VAL PHE THR TYR ARG VAL ASN LYS          
SEQRES  10 A  139  ALA GLY LEU ILE THR ASN MET ARG GLY TYR TRP ASN LEU          
SEQRES  11 A  139  ASP MET MET THR PHE GLY ASN GLN GLU                          
HET    NCA   1001       9                                                       
HETNAM     NCA NICOTINAMIDE                                                     
FORMUL   2  NCA    C6 H6 N2 O                                                   
FORMUL   3  HOH   *190(H2 O)                                                    
CRYST1   55.600   55.600  104.740  90.00  90.00 120.00 P 32 1 2      6          
ATOM      1  N   THR A   5      -4.502   0.803   1.801  1.00 52.81           N  
ATOM      2  CA  THR A   5      -4.957  -0.530   1.308  1.00 48.60           C  
ATOM      3  C   THR A   5      -3.849  -1.577   1.390  1.00 45.21           C  
ATOM      4  O   THR A   5      -2.659  -1.254   1.425  1.00 47.41           O  
ATOM      5  CB  THR A   5      -5.498  -0.479  -0.147  1.00 49.18           C  
ATOM      6  OG1 THR A   5      -4.520   0.113  -1.015  1.00 54.77           O  
ATOM      7  CG2 THR A   5      -6.807   0.302  -0.216  1.00 49.78           C  
ATOM      8  N   GLN A   6      -4.271  -2.840   1.396  1.00 36.99           N  
ATOM      9  CA  GLN A   6      -3.384  -3.982   1.585  1.00 30.13           C  
ATOM     10  C   GLN A   6      -2.554  -4.309   0.362  1.00 23.63           C  
ATOM     11  O   GLN A   6      -2.980  -4.097  -0.783  1.00 22.33           O  
ATOM     12  CB  GLN A   6      -4.230  -5.176   1.936  1.00 29.80           C  
ATOM     13  CG  GLN A   6      -4.992  -4.994   3.227  1.00 33.07           C  
ATOM     14  CD  GLN A   6      -5.751  -6.236   3.567  1.00 33.76           C  
ATOM     15  OE1 GLN A   6      -6.282  -6.910   2.671  1.00 33.87           O  
ATOM     16  NE2 GLN A   6      -5.788  -6.579   4.854  1.00 39.65           N  
ATOM     17  N   SER A   7      -1.352  -4.854   0.588  1.00 19.04           N  
ATOM     18  CA  SER A   7      -0.461  -5.139  -0.504  1.00 16.94           C  
ATOM     19  C   SER A   7      -0.948  -6.391  -1.275  1.00 14.87           C  
ATOM     20  O   SER A   7      -1.648  -7.215  -0.685  1.00 17.30           O  
ATOM     21  CB  SER A   7       0.971  -5.386  -0.007  0.50 18.44           C  
ATOM     23  OG  SER A   7       1.132  -6.776   0.230  0.50 12.74           O  
ATOM     25  N   PRO A   8      -0.559  -6.542  -2.553  1.00 14.20           N  
ATOM     26  CA  PRO A   8      -0.900  -7.747  -3.306  1.00 16.63           C  
ATOM     27  C   PRO A   8      -0.381  -9.006  -2.599  1.00 19.26           C  
ATOM     28  O   PRO A   8      -1.049 -10.032  -2.601  1.00 16.27           O  
ATOM     29  CB  PRO A   8      -0.134  -7.573  -4.615  1.00 18.60           C  
ATOM     30  CG  PRO A   8      -0.006  -6.076  -4.778  1.00 24.10           C  
ATOM     31  CD  PRO A   8       0.178  -5.570  -3.397  1.00 17.71           C  
ATOM     32  N   ALA A   9       0.806  -8.927  -2.010  1.00 15.63           N  
ATOM     33  CA  ALA A   9       1.297 -10.113  -1.245  1.00 15.17           C  
ATOM     34  C   ALA A   9       0.468 -10.469  -0.036  1.00 15.65           C  
ATOM     35  O   ALA A   9       0.249 -11.688   0.226  1.00 15.48           O  
ATOM     36  CB  ALA A   9       2.820  -9.972  -0.888  1.00 12.55           C  
ATOM     37  N   LEU A  10       0.001  -9.458   0.732  1.00 11.31           N  
ATOM     38  CA  LEU A  10      -0.768  -9.703   1.895  1.00 14.45           C  
ATOM     39  C   LEU A  10      -2.132 -10.257   1.449  1.00 16.16           C  
ATOM     40  O   LEU A  10      -2.633 -11.205   2.027  1.00 16.20           O  
ATOM     41  CB  LEU A  10      -0.975  -8.439   2.705  1.00 15.30           C  
ATOM     42  CG  LEU A  10      -1.772  -8.647   3.989  1.00 14.87           C  
ATOM     43  CD1 LEU A  10      -1.187  -9.700   4.933  1.00 18.37           C  
ATOM     44  CD2 LEU A  10      -1.994  -7.299   4.723  1.00 18.92           C  
ATOM     45  N   ILE A  11      -2.709  -9.641   0.421  1.00 15.58           N  
ATOM     46  CA  ILE A  11      -3.992 -10.135  -0.110  1.00 17.20           C  
ATOM     47  C   ILE A  11      -3.938 -11.613  -0.515  1.00 17.96           C  
ATOM     48  O   ILE A  11      -4.794 -12.395  -0.092  1.00 17.92           O  
ATOM     49  CB  ILE A  11      -4.512  -9.253  -1.262  1.00 18.19           C  
ATOM     50  CG1 ILE A  11      -4.907  -7.895  -0.676  1.00 19.37           C  
ATOM     51  CG2 ILE A  11      -5.745  -9.956  -1.932  1.00 20.61           C  
ATOM     52  CD1 ILE A  11      -5.128  -6.795  -1.699  1.00 23.28           C  
ATOM     53  N   ALA A  12      -2.910 -11.970  -1.274  1.00 14.20           N  
ATOM     54  CA  ALA A  12      -2.708 -13.338  -1.793  1.00 14.43           C  
ATOM     55  C   ALA A  12      -2.481 -14.300  -0.633  1.00 17.17           C  
ATOM     56  O   ALA A  12      -3.093 -15.361  -0.588  1.00 14.77           O  
ATOM     57  CB  ALA A  12      -1.612 -13.405  -2.803  1.00 16.94           C  
ATOM     58  N   SER A  13      -1.631 -13.932   0.333  1.00 17.32           N  
ATOM     59  CA  SER A  13      -1.407 -14.862   1.440  1.00 15.67           C  
ATOM     60  C   SER A  13      -2.627 -15.026   2.348  1.00 17.06           C  
ATOM     61  O   SER A  13      -3.001 -16.153   2.673  1.00 18.83           O  
ATOM     62  CB  SER A  13      -0.112 -14.600   2.216  0.35 20.80           C  
ATOM     64  OG  SER A  13       0.223 -13.250   2.183  0.35  4.39           O  
ATOM     66  N   GLN A  14      -3.283 -13.928   2.737  1.00 15.87           N  
ATOM     67  CA  GLN A  14      -4.492 -14.035   3.522  1.00 15.88           C  
ATOM     68  C   GLN A  14      -5.570 -14.795   2.746  1.00 18.53           C  
ATOM     69  O   GLN A  14      -6.256 -15.641   3.323  1.00 19.29           O  
ATOM     70  CB  GLN A  14      -4.991 -12.671   3.962  1.00 21.34           C  
ATOM     71  CG  GLN A  14      -4.074 -12.023   4.979  1.00 20.55           C  
ATOM     72  CD  GLN A  14      -4.646 -10.747   5.570  1.00 27.89           C  
ATOM     73  OE1 GLN A  14      -5.379 -10.028   4.907  1.00 27.07           O  
ATOM     74  NE2 GLN A  14      -4.285 -10.456   6.823  1.00 31.06           N  
ATOM     75  N   SER A  15      -5.685 -14.533   1.441  1.00 18.26           N  
ATOM     76  CA  SER A  15      -6.682 -15.259   0.642  1.00 18.05           C  
ATOM     77  C   SER A  15      -6.397 -16.752   0.611  1.00 18.58           C  
ATOM     78  O   SER A  15      -7.332 -17.546   0.689  1.00 16.96           O  
ATOM     79  CB  SER A  15      -6.796 -14.724  -0.782  1.00 18.05           C  
ATOM     80  OG  SER A  15      -7.415 -13.447  -0.717  1.00 18.12           O  
ATOM     81  N   SER A  16      -5.113 -17.116   0.532  1.00 14.36           N  
ATOM     82  CA  SER A  16      -4.753 -18.521   0.467  1.00 15.65           C  
ATOM     83  C   SER A  16      -5.232 -19.285   1.720  1.00 19.10           C  
ATOM     84  O   SER A  16      -5.790 -20.383   1.588  1.00 19.33           O  
ATOM     85  CB  SER A  16      -3.251 -18.692   0.186  1.00 16.16           C  
ATOM     86  OG  SER A  16      -2.477 -18.420   1.351  1.00 18.05           O  
ATOM     87  N   TRP A  17      -5.096 -18.688   2.917  1.00 18.02           N  
ATOM     88  CA  TRP A  17      -5.571 -19.364   4.138  1.00 20.78           C  
ATOM     89  C   TRP A  17      -7.087 -19.379   4.243  1.00 20.35           C  
ATOM     90  O   TRP A  17      -7.658 -20.341   4.704  1.00 20.27           O  
ATOM     91  CB  TRP A  17      -4.753 -19.178   5.431  0.35 25.91           C  
ATOM     93  CG  TRP A  17      -4.502 -17.813   5.921  0.35 12.80           C  
ATOM     95  CD1 TRP A  17      -5.382 -16.998   6.544  0.35 20.84           C  
ATOM     97  CD2 TRP A  17      -3.241 -17.123   5.912  0.35 26.11           C  
ATOM     99  NE1 TRP A  17      -4.768 -15.816   6.899  0.35 24.59           N  
ATOM    101  CE2 TRP A  17      -3.451 -15.870   6.521  0.35 17.81           C  
ATOM    103  CE3 TRP A  17      -1.957 -17.442   5.438  0.35  7.05           C  
ATOM    105  CZ2 TRP A  17      -2.426 -14.918   6.660  0.35 23.27           C  
ATOM    107  CZ3 TRP A  17      -0.937 -16.499   5.576  0.35 14.96           C  
ATOM    109  CH2 TRP A  17      -1.180 -15.254   6.189  0.35 15.04           C  
ATOM    111  N   ARG A  18      -7.711 -18.304   3.793  1.00 21.94           N  
ATOM    112  CA  ARG A  18      -9.162 -18.224   3.734  1.00 21.95           C  
ATOM    113  C   ARG A  18      -9.710 -19.362   2.863  1.00 18.31           C  
ATOM    114  O   ARG A  18     -10.690 -20.015   3.240  1.00 20.51           O  
ATOM    115  CB  ARG A  18      -9.571 -16.856   3.197  1.00 24.91           C  
ATOM    116  CG  ARG A  18      -9.590 -15.861   4.320  1.00 39.43           C  
ATOM    117  CD  ARG A  18      -9.443 -14.440   3.859  1.00 57.31           C  
ATOM    118  NE  ARG A  18      -9.159 -13.558   4.990  1.00 64.81           N  
ATOM    119  CZ  ARG A  18      -8.787 -12.288   4.880  1.00 69.03           C  
ATOM    120  NH1 ARG A  18      -8.551 -11.576   5.974  1.00 76.30           N  
ATOM    121  NH2 ARG A  18      -8.653 -11.727   3.684  1.00 71.59           N  
ATOM    122  N   CYS A  19      -9.075 -19.598   1.716  1.00 17.54           N  
ATOM    123  CA  CYS A  19      -9.525 -20.685   0.832  1.00 19.30           C  
ATOM    124  C   CYS A  19      -9.282 -22.059   1.478  1.00 20.89           C  
ATOM    125  O   CYS A  19     -10.105 -22.982   1.348  1.00 20.05           O  
ATOM    126  CB  CYS A  19      -8.843 -20.610  -0.516  1.00 17.95           C  
ATOM    127  SG  CYS A  19      -9.396 -19.241  -1.556  1.00 20.81           S  
ATOM    128  N   VAL A  20      -8.162 -22.197   2.196  1.00 18.53           N  
ATOM    129  CA  VAL A  20      -7.928 -23.424   2.946  1.00 20.29           C  
ATOM    130  C   VAL A  20      -9.070 -23.626   3.944  1.00 21.00           C  
ATOM    131  O   VAL A  20      -9.663 -24.713   4.013  1.00 22.28           O  
ATOM    132  CB  VAL A  20      -6.516 -23.481   3.633  1.00 15.03           C  
ATOM    133  CG1 VAL A  20      -6.419 -24.683   4.607  1.00 19.80           C  
ATOM    134  CG2 VAL A  20      -5.414 -23.597   2.562  1.00 14.81           C  
ATOM    135  N   GLN A  21      -9.392 -22.587   4.708  1.00 19.80           N  
ATOM    136  CA  GLN A  21     -10.383 -22.713   5.789  1.00 20.43           C  
ATOM    137  C   GLN A  21     -11.786 -22.980   5.199  1.00 18.22           C  
ATOM    138  O   GLN A  21     -12.587 -23.707   5.789  1.00 24.55           O  
ATOM    139  CB  GLN A  21     -10.362 -21.532   6.774  0.65 20.53           C  
ATOM    141  CG  GLN A  21      -9.010 -21.291   7.492  0.65 26.54           C  
ATOM    143  CD  GLN A  21      -8.535 -22.381   8.500  0.65 33.66           C  
ATOM    145  OE1 GLN A  21      -7.592 -23.127   8.225  0.65 12.79           O  
ATOM    147  NE2 GLN A  21      -9.148 -22.415   9.680  0.65 34.58           N  
ATOM    149  N   ALA A  22     -12.036 -22.415   4.023  1.00 17.96           N  
ATOM    150  CA  ALA A  22     -13.315 -22.573   3.320  1.00 17.59           C  
ATOM    151  C   ALA A  22     -13.405 -23.891   2.539  1.00 22.62           C  
ATOM    152  O   ALA A  22     -14.420 -24.150   1.858  1.00 21.74           O  
ATOM    153  CB  ALA A  22     -13.526 -21.393   2.394  1.00 19.33           C  
ATOM    154  N   HIS A  23     -12.342 -24.706   2.582  1.00 15.98           N  
ATOM    155  CA  HIS A  23     -12.311 -25.960   1.800  1.00 15.96           C  
ATOM    156  C   HIS A  23     -12.555 -25.720   0.330  1.00 22.42           C  
ATOM    157  O   HIS A  23     -13.348 -26.425  -0.317  1.00 18.66           O  
ATOM    158  CB  HIS A  23     -13.334 -26.992   2.357  1.00 18.21           C  
ATOM    159  CG  HIS A  23     -13.147 -27.344   3.803  1.00 26.05           C  
ATOM    160  ND1 HIS A  23     -11.966 -27.151   4.486  1.00 39.25           N  
ATOM    161  CD2 HIS A  23     -13.996 -27.922   4.686  1.00 44.47           C  
ATOM    162  CE1 HIS A  23     -12.107 -27.568   5.733  1.00 29.37           C  
ATOM    163  NE2 HIS A  23     -13.326 -28.047   5.877  1.00 40.27           N  
ATOM    164  N   ASP A  24     -11.864 -24.718  -0.216  1.00 15.15           N  
ATOM    165  CA  ASP A  24     -12.168 -24.231  -1.562  1.00 16.97           C  
ATOM    166  C   ASP A  24     -10.998 -24.409  -2.508  1.00 18.42           C  
ATOM    167  O   ASP A  24     -10.159 -23.522  -2.661  1.00 15.65           O  
ATOM    168  CB  ASP A  24     -12.672 -22.779  -1.474  1.00 19.49           C  
ATOM    169  CG  ASP A  24     -12.947 -22.136  -2.836  1.00 22.69           C  
ATOM    170  OD1 ASP A  24     -13.041 -22.824  -3.886  1.00 19.85           O  
ATOM    171  OD2 ASP A  24     -13.050 -20.880  -2.850  1.00 26.12           O  
ATOM    172  N   ARG A  25     -10.961 -25.567  -3.168  1.00 15.58           N  
ATOM    173  CA  ARG A  25      -9.868 -25.934  -4.041  1.00 13.27           C  
ATOM    174  C   ARG A  25      -9.802 -24.999  -5.244  1.00 17.30           C  
ATOM    175  O   ARG A  25      -8.739 -24.496  -5.579  1.00 13.74           O  
ATOM    176  CB  ARG A  25      -9.993 -27.405  -4.472  1.00 15.41           C  
ATOM    177  CG  ARG A  25      -8.859 -27.928  -5.326  1.00 13.71           C  
ATOM    178  CD  ARG A  25      -9.340 -29.260  -5.893  1.00 15.80           C  
ATOM    179  NE  ARG A  25      -8.310 -30.181  -6.386  1.00 13.86           N  
ATOM    180  CZ  ARG A  25      -7.882 -30.276  -7.630  1.00 16.49           C  
ATOM    181  NH1 ARG A  25      -8.377 -29.477  -8.586  1.00 17.51           N  
ATOM    182  NH2 ARG A  25      -6.975 -31.206  -7.938  1.00 17.88           N  
ATOM    183  N   GLU A  26     -10.953 -24.729  -5.876  1.00 14.58           N  
ATOM    184  CA  GLU A  26     -10.967 -23.842  -7.035  1.00 16.35           C  
ATOM    185  C   GLU A  26     -10.460 -22.441  -6.675  1.00 11.28           C  
ATOM    186  O   GLU A  26      -9.632 -21.890  -7.390  1.00 17.97           O  
ATOM    187  CB  GLU A  26     -12.392 -23.760  -7.614  1.00 18.28           C  
ATOM    188  CG  GLU A  26     -12.743 -24.989  -8.434  1.00 30.49           C  
ATOM    189  CD  GLU A  26     -14.177 -24.957  -8.978  1.00 32.80           C  
ATOM    190  OE1 GLU A  26     -14.655 -26.036  -9.443  1.00 42.13           O  
ATOM    191  OE2 GLU A  26     -14.810 -23.857  -8.928  1.00 30.37           O  
ATOM    192  N   GLY A  27     -10.917 -21.921  -5.531  1.00 16.41           N  
ATOM    193  CA  GLY A  27     -10.567 -20.565  -5.111  1.00 17.54           C  
ATOM    194  C   GLY A  27      -9.078 -20.510  -4.773  1.00 18.12           C  
ATOM    195  O   GLY A  27      -8.390 -19.567  -5.146  1.00 17.74           O  
ATOM    196  N   TRP A  28      -8.583 -21.563  -4.134  1.00 14.89           N  
ATOM    197  CA  TRP A  28      -7.134 -21.661  -3.813  1.00 15.51           C  
ATOM    198  C   TRP A  28      -6.247 -21.682  -5.073  1.00 15.16           C  
ATOM    199  O   TRP A  28      -5.298 -20.892  -5.196  1.00 18.99           O  
ATOM    200  CB  TRP A  28      -6.921 -22.894  -2.898  1.00 12.56           C  
ATOM    201  CG  TRP A  28      -5.551 -22.968  -2.217  1.00 13.82           C  
ATOM    202  CD1 TRP A  28      -5.143 -22.310  -1.075  1.00 17.32           C  
ATOM    203  CD2 TRP A  28      -4.465 -23.762  -2.640  1.00 16.48           C  
ATOM    204  NE1 TRP A  28      -3.826 -22.662  -0.769  1.00 14.93           N  
ATOM    205  CE2 TRP A  28      -3.393 -23.549  -1.718  1.00 15.62           C  
ATOM    206  CE3 TRP A  28      -4.277 -24.665  -3.705  1.00 15.59           C  
ATOM    207  CZ2 TRP A  28      -2.161 -24.218  -1.837  1.00 17.17           C  
ATOM    208  CZ3 TRP A  28      -3.054 -25.315  -3.821  1.00 20.85           C  
ATOM    209  CH2 TRP A  28      -2.009 -25.083  -2.885  1.00 15.11           C  
ATOM    210  N   LEU A  29      -6.574 -22.534  -6.057  1.00 12.02           N  
ATOM    211  CA  LEU A  29      -5.854 -22.621  -7.311  1.00 14.41           C  
ATOM    212  C   LEU A  29      -5.868 -21.295  -8.113  1.00 13.60           C  
ATOM    213  O   LEU A  29      -4.889 -20.949  -8.781  1.00 17.44           O  
ATOM    214  CB  LEU A  29      -6.399 -23.795  -8.133  1.00 19.79           C  
ATOM    215  CG  LEU A  29      -6.029 -25.157  -7.523  1.00 16.56           C  
ATOM    216  CD1 LEU A  29      -6.677 -26.275  -8.330  1.00 18.38           C  
ATOM    217  CD2 LEU A  29      -4.517 -25.354  -7.583  1.00 21.44           C  
ATOM    218  N   ALA A  30      -6.981 -20.565  -8.014  1.00 17.82           N  
ATOM    219  CA  ALA A  30      -7.155 -19.317  -8.764  1.00 19.33           C  
ATOM    220  C   ALA A  30      -6.192 -18.240  -8.257  1.00 18.47           C  
ATOM    221  O   ALA A  30      -5.887 -17.282  -8.969  1.00 20.75           O  
ATOM    222  CB  ALA A  30      -8.595 -18.826  -8.655  1.00 21.46           C  
ATOM    223  N   LEU A  31      -5.703 -18.414  -7.022  1.00 14.92           N  
ATOM    224  CA  LEU A  31      -4.666 -17.495  -6.476  1.00 14.65           C  
ATOM    225  C   LEU A  31      -3.274 -17.698  -7.037  1.00 16.69           C  
ATOM    226  O   LEU A  31      -2.389 -16.823  -6.830  1.00 16.30           O  
ATOM    227  CB  LEU A  31      -4.598 -17.641  -4.950  1.00 14.47           C  
ATOM    228  CG  LEU A  31      -5.873 -17.415  -4.148  1.00 18.19           C  
ATOM    229  CD1 LEU A  31      -5.669 -17.775  -2.704  1.00 19.53           C  
ATOM    230  CD2 LEU A  31      -6.423 -16.003  -4.251  1.00 23.37           C  
ATOM    231  N   MET A  32      -3.060 -18.828  -7.729  1.00 16.24           N  
ATOM    232  CA  MET A  32      -1.735 -19.283  -8.142  1.00 17.48           C  
ATOM    233  C   MET A  32      -1.434 -18.915  -9.567  1.00 19.41           C  
ATOM    234  O   MET A  32      -2.296 -19.055 -10.450  1.00 18.30           O  
ATOM    235  CB  MET A  32      -1.587 -20.810  -8.017  1.00 19.14           C  
ATOM    236  CG  MET A  32      -2.022 -21.347  -6.686  1.00 19.78           C  
ATOM    237  SD  MET A  32      -0.956 -20.731  -5.361  1.00 15.97           S  
ATOM    238  CE  MET A  32      -1.927 -21.267  -3.968  1.00 17.39           C  
ATOM    239  N   ALA A  33      -0.206 -18.451  -9.780  1.00 15.42           N  
ATOM    240  CA  ALA A  33       0.331 -18.287 -11.133  1.00 19.38           C  
ATOM    241  C   ALA A  33       0.469 -19.618 -11.832  1.00 20.84           C  
ATOM    242  O   ALA A  33       0.592 -20.664 -11.199  1.00 17.48           O  
ATOM    243  CB  ALA A  33       1.709 -17.589 -11.098  1.00 19.82           C  
ATOM    244  N   ASP A  34       0.469 -19.584 -13.162  1.00 23.55           N  
ATOM    245  CA  ASP A  34       0.697 -20.798 -13.925  1.00 23.85           C  
ATOM    246  C   ASP A  34       2.045 -21.424 -13.651  1.00 22.07           C  
ATOM    247  O   ASP A  34       2.176 -22.626 -13.753  1.00 24.94           O  
ATOM    248  CB  ASP A  34       0.536 -20.553 -15.425  1.00 27.16           C  
ATOM    249  CG  ASP A  34      -0.929 -20.390 -15.847  1.00 33.47           C  
ATOM    250  OD1 ASP A  34      -1.860 -20.609 -15.031  1.00 36.72           O  
ATOM    251  OD2 ASP A  34      -1.146 -20.037 -17.026  1.00 44.34           O  
ATOM    252  N   ASP A  35       3.044 -20.616 -13.277  1.00 20.81           N  
ATOM    253  CA  ASP A  35       4.355 -21.159 -12.969  1.00 18.53           C  
ATOM    254  C   ASP A  35       4.649 -21.267 -11.463  1.00 15.63           C  
ATOM    255  O   ASP A  35       5.828 -21.305 -11.072  1.00 19.09           O  
ATOM    256  CB  ASP A  35       5.461 -20.363 -13.666  1.00 22.28           C  
ATOM    257  CG  ASP A  35       5.557 -18.909 -13.176  1.00 22.56           C  
ATOM    258  OD1 ASP A  35       4.767 -18.455 -12.322  1.00 25.77           O  
ATOM    259  OD2 ASP A  35       6.460 -18.192 -13.680  1.00 34.46           O  
ATOM    260  N   VAL A  36       3.592 -21.379 -10.659  1.00 16.84           N  
ATOM    261  CA  VAL A  36       3.724 -21.480  -9.211  1.00 15.25           C  
ATOM    262  C   VAL A  36       4.663 -22.641  -8.830  1.00 16.72           C  
ATOM    263  O   VAL A  36       4.681 -23.694  -9.495  1.00 16.33           O  
ATOM    264  CB  VAL A  36       2.358 -21.587  -8.517  1.00 18.19           C  
ATOM    265  CG1 VAL A  36       1.622 -22.907  -8.931  1.00 16.57           C  
ATOM    266  CG2 VAL A  36       2.498 -21.435  -6.995  1.00 18.30           C  
ATOM    267  N   VAL A  37       5.478 -22.413  -7.792  1.00 13.58           N  
ATOM    268  CA  VAL A  37       6.259 -23.497  -7.196  1.00 14.15           C  
ATOM    269  C   VAL A  37       5.981 -23.442  -5.701  1.00 14.13           C  
ATOM    270  O   VAL A  37       6.210 -22.417  -5.050  1.00 13.97           O  
ATOM    271  CB  VAL A  37       7.795 -23.370  -7.476  1.00 13.90           C  
ATOM    272  CG1 VAL A  37       8.589 -24.488  -6.762  1.00 11.96           C  
ATOM    273  CG2 VAL A  37       8.089 -23.361  -8.993  1.00 13.51           C  
ATOM    274  N   ILE A  38       5.457 -24.535  -5.162  1.00 12.27           N  
ATOM    275  CA  ILE A  38       5.169 -24.608  -3.722  1.00 12.63           C  
ATOM    276  C   ILE A  38       6.216 -25.470  -3.046  1.00 13.02           C  
ATOM    277  O   ILE A  38       6.355 -26.669  -3.354  1.00 12.43           O  
ATOM    278  CB  ILE A  38       3.757 -25.232  -3.436  1.00 16.69           C  
ATOM    279  CG1 ILE A  38       2.682 -24.309  -4.025  0.50 12.47           C  
ATOM    281  CG2 ILE A  38       3.507 -25.454  -1.919  1.00 16.19           C  
ATOM    282  CD1 ILE A  38       1.286 -24.649  -3.638  0.50 17.21           C  
ATOM    284  N   GLU A  39       6.947 -24.857  -2.115  1.00 12.14           N  
ATOM    285  CA  GLU A  39       7.982 -25.568  -1.376  1.00 12.16           C  
ATOM    286  C   GLU A  39       7.563 -25.570   0.068  1.00 13.31           C  
ATOM    287  O   GLU A  39       7.978 -24.717   0.873  1.00 13.88           O  
ATOM    288  CB  GLU A  39       9.363 -24.915  -1.578  1.00 10.39           C  
ATOM    289  CG  GLU A  39       9.915 -25.143  -2.951  1.00 11.29           C  
ATOM    290  CD  GLU A  39      11.152 -24.268  -3.164  1.00 15.83           C  
ATOM    291  OE1 GLU A  39      10.992 -23.150  -3.674  1.00 14.99           O  
ATOM    292  OE2 GLU A  39      12.258 -24.684  -2.797  1.00 14.61           O  
ATOM    293  N   ASP A  40       6.667 -26.499   0.397  1.00 12.06           N  
ATOM    294  CA  ASP A  40       6.159 -26.568   1.755  1.00 11.33           C  
ATOM    295  C   ASP A  40       6.473 -27.947   2.336  1.00 16.22           C  
ATOM    296  O   ASP A  40       5.693 -28.891   2.172  1.00 15.04           O  
ATOM    297  CB  ASP A  40       4.631 -26.339   1.732  1.00 14.72           C  
ATOM    298  CG  ASP A  40       3.955 -26.671   3.070  1.00 18.77           C  
ATOM    299  OD1 ASP A  40       4.558 -26.414   4.131  1.00 17.05           O  
ATOM    300  OD2 ASP A  40       2.825 -27.219   3.062  1.00 21.99           O  
ATOM    301  N   PRO A  41       7.621 -28.088   3.003  1.00 11.22           N  
ATOM    302  CA  PRO A  41       8.661 -27.081   3.274  1.00 11.42           C  
ATOM    303  C   PRO A  41       9.685 -27.048   2.161  1.00 11.32           C  
ATOM    304  O   PRO A  41       9.621 -27.839   1.226  1.00 12.07           O  
ATOM    305  CB  PRO A  41       9.350 -27.650   4.528  1.00 10.43           C  
ATOM    306  CG  PRO A  41       9.302 -29.170   4.315  1.00 11.10           C  
ATOM    307  CD  PRO A  41       7.989 -29.428   3.526  1.00 10.38           C  
ATOM    308  N   ILE A  42      10.651 -26.118   2.275  1.00  9.74           N  
ATOM    309  CA  ILE A  42      11.822 -26.137   1.414  1.00  9.15           C  
ATOM    310  C   ILE A  42      12.668 -27.379   1.795  1.00  9.71           C  
ATOM    311  O   ILE A  42      12.884 -27.643   2.990  1.00 11.82           O  
ATOM    312  CB  ILE A  42      12.676 -24.890   1.685  1.00 11.48           C  
ATOM    313  CG1 ILE A  42      11.887 -23.625   1.372  1.00 10.22           C  
ATOM    314  CG2 ILE A  42      13.961 -24.954   0.854  1.00 12.59           C  
ATOM    315  CD1 ILE A  42      12.542 -22.370   1.996  1.00 11.21           C  
ATOM    316  N   GLY A  43      13.115 -28.114   0.785  1.00 13.45           N  
ATOM    317  CA  GLY A  43      13.914 -29.334   0.981  1.00 12.02           C  
ATOM    318  C   GLY A  43      13.028 -30.571   1.047  1.00 11.52           C  
ATOM    319  O   GLY A  43      11.802 -30.474   1.178  1.00 12.55           O  
ATOM    320  N   LYS A  44      13.671 -31.738   1.046  1.00 12.07           N  
ATOM    321  CA  LYS A  44      12.914 -32.991   0.862  1.00 13.31           C  
ATOM    322  C   LYS A  44      12.139 -33.341   2.127  1.00 12.41           C  
ATOM    323  O   LYS A  44      12.695 -33.325   3.252  1.00 13.79           O  
ATOM    324  CB  LYS A  44      13.877 -34.138   0.472  1.00 16.07           C  
ATOM    325  CG  LYS A  44      13.157 -35.448   0.142  1.00 22.80           C  
ATOM    326  CD  LYS A  44      14.187 -36.479  -0.393  1.00 26.50           C  
ATOM    327  CE  LYS A  44      13.535 -37.790  -0.814  1.00 48.80           C  
ATOM    328  NZ  LYS A  44      13.007 -38.578   0.345  1.00 46.61           N  
ATOM    329  N   SER A  45      10.851 -33.664   1.955  1.00 13.38           N  
ATOM    330  CA  SER A  45       9.965 -34.022   3.061  1.00 13.10           C  
ATOM    331  C   SER A  45       8.739 -34.702   2.482  1.00 13.32           C  
ATOM    332  O   SER A  45       8.598 -34.793   1.250  1.00 12.18           O  
ATOM    333  CB  SER A  45       9.553 -32.813   3.913  1.00 11.89           C  
ATOM    334  OG  SER A  45       9.050 -33.178   5.214  1.00 13.98           O  
ATOM    335  N   VAL A  46       7.864 -35.176   3.372  1.00 15.38           N  
ATOM    336  CA  VAL A  46       6.638 -35.884   2.928  1.00 14.45           C  
ATOM    337  C   VAL A  46       5.827 -35.014   1.940  1.00 18.60           C  
ATOM    338  O   VAL A  46       5.335 -35.504   0.917  1.00 16.55           O  
ATOM    339  CB  VAL A  46       5.762 -36.269   4.119  1.00 18.05           C  
ATOM    340  CG1 VAL A  46       4.400 -36.846   3.637  1.00 23.58           C  
ATOM    341  CG2 VAL A  46       6.523 -37.289   5.006  1.00 17.32           C  
ATOM    342  N   THR A  47       5.738 -33.728   2.243  1.00 13.22           N  
ATOM    343  CA  THR A  47       4.955 -32.769   1.443  1.00 14.16           C  
ATOM    344  C   THR A  47       5.792 -32.071   0.331  1.00 16.60           C  
ATOM    345  O   THR A  47       5.278 -31.177  -0.352  1.00 18.15           O  
ATOM    346  CB  THR A  47       4.327 -31.718   2.378  1.00 13.71           C  
ATOM    347  OG1 THR A  47       5.363 -31.172   3.211  1.00 13.45           O  
ATOM    348  CG2 THR A  47       3.294 -32.355   3.335  1.00 13.66           C  
ATOM    349  N   ASN A  48       7.061 -32.483   0.174  1.00 14.65           N  
ATOM    350  CA  ASN A  48       7.949 -32.035  -0.900  1.00 12.49           C  
ATOM    351  C   ASN A  48       8.873 -33.190  -1.280  1.00 16.22           C  
ATOM    352  O   ASN A  48      10.064 -33.151  -1.058  1.00 12.90           O  
ATOM    353  CB  ASN A  48       8.727 -30.761  -0.454  1.00 11.36           C  
ATOM    354  CG  ASN A  48       9.527 -30.121  -1.591  1.00 15.20           C  
ATOM    355  OD1 ASN A  48       9.554 -30.623  -2.698  1.00 15.71           O  
ATOM    356  ND2 ASN A  48      10.222 -29.010  -1.292  1.00 12.53           N  
ATOM    357  N   PRO A  49       8.297 -34.283  -1.829  1.00 14.97           N  
ATOM    358  CA  PRO A  49       9.009 -35.560  -1.873  1.00 20.91           C  
ATOM    359  C   PRO A  49      10.308 -35.576  -2.671  1.00 20.29           C  
ATOM    360  O   PRO A  49      11.210 -36.356  -2.341  1.00 26.29           O  
ATOM    361  CB  PRO A  49       7.964 -36.513  -2.480  1.00 21.06           C  
ATOM    362  CG  PRO A  49       6.647 -35.876  -2.185  0.50 20.11           C  
ATOM    364  CD  PRO A  49       6.921 -34.410  -2.353  1.00 20.27           C  
ATOM    365  N   ASP A  50      10.435 -34.730  -3.695  1.00 21.89           N  
ATOM    366  CA  ASP A  50      11.691 -34.692  -4.432  1.00 22.13           C  
ATOM    367  C   ASP A  50      12.635 -33.566  -4.002  1.00 25.20           C  
ATOM    368  O   ASP A  50      13.751 -33.455  -4.512  1.00 23.67           O  
ATOM    369  CB  ASP A  50      11.484 -34.724  -5.961  1.00 31.51           C  
ATOM    370  CG  ASP A  50      11.054 -33.377  -6.565  1.00 43.22           C  
ATOM    371  OD1 ASP A  50      10.992 -32.329  -5.880  1.00 36.26           O  
ATOM    372  OD2 ASP A  50      10.768 -33.378  -7.782  1.00 58.71           O  
ATOM    373  N   GLY A  51      12.179 -32.738  -3.068  1.00 16.51           N  
ATOM    374  CA  GLY A  51      12.997 -31.646  -2.546  1.00 14.58           C  
ATOM    375  C   GLY A  51      13.115 -30.401  -3.397  1.00 17.49           C  
ATOM    376  O   GLY A  51      13.811 -29.471  -3.006  1.00 19.74           O  
ATOM    377  N   SER A  52      12.475 -30.385  -4.563  1.00 15.06           N  
ATOM    378  CA  SER A  52      12.597 -29.220  -5.431  1.00 18.90           C  
ATOM    379  C   SER A  52      11.274 -28.460  -5.609  1.00 18.69           C  
ATOM    380  O   SER A  52      11.191 -27.526  -6.424  1.00 20.40           O  
ATOM    381  CB  SER A  52      13.192 -29.641  -6.785  1.00 23.08           C  
ATOM    382  OG  SER A  52      12.227 -30.323  -7.550  1.00 30.65           O  
ATOM    383  N   GLY A  53      10.262 -28.801  -4.809  1.00 14.85           N  
ATOM    384  CA  GLY A  53       8.986 -28.078  -4.897  1.00 13.19           C  
ATOM    385  C   GLY A  53       7.965 -28.732  -5.827  1.00 14.42           C  
ATOM    386  O   GLY A  53       8.316 -29.596  -6.652  1.00 18.02           O  
ATOM    387  N   ILE A  54       6.718 -28.328  -5.649  1.00 14.78           N  
ATOM    388  CA  ILE A  54       5.579 -28.858  -6.415  1.00 14.40           C  
ATOM    389  C   ILE A  54       5.281 -27.790  -7.468  1.00 14.91           C  
ATOM    390  O   ILE A  54       5.060 -26.614  -7.120  1.00 16.96           O  
ATOM    391  CB  ILE A  54       4.343 -29.053  -5.521  1.00 16.42           C  
ATOM    392  CG1 ILE A  54       4.680 -29.853  -4.245  1.00 19.86           C  
ATOM    393  CG2 ILE A  54       3.223 -29.741  -6.354  1.00 20.36           C  
ATOM    394  CD1 ILE A  54       5.091 -31.260  -4.477  1.00 25.06           C  
ATOM    395  N   LYS A  55       5.323 -28.168  -8.741  1.00 15.45           N  
ATOM    396  CA  LYS A  55       5.388 -27.143  -9.804  1.00 19.75           C  
ATOM    397  C   LYS A  55       4.179 -27.185 -10.716  1.00 25.71           C  
ATOM    398  O   LYS A  55       3.856 -28.253 -11.236  1.00 21.94           O  
ATOM    399  CB  LYS A  55       6.657 -27.299 -10.655  1.00 20.05           C  
ATOM    400  CG  LYS A  55       7.934 -27.222  -9.881  1.00 30.52           C  
ATOM    401  CD  LYS A  55       9.112 -27.464 -10.811  1.00 41.10           C  
ATOM    402  CE  LYS A  55      10.355 -27.828 -10.027  1.00 53.07           C  
ATOM    403  NZ  LYS A  55      10.683 -26.764  -9.061  1.00 51.59           N  
ATOM    404  N   GLY A  56       3.534 -26.026 -10.892  1.00 27.53           N  
ATOM    405  CA  GLY A  56       2.420 -25.886 -11.822  1.00 23.38           C  
ATOM    406  C   GLY A  56       1.076 -26.226 -11.224  1.00 25.90           C  
ATOM    407  O   GLY A  56       0.978 -26.968 -10.236  1.00 24.90           O  
ATOM    408  N   LYS A  57       0.021 -25.694 -11.835  1.00 24.01           N  
ATOM    409  CA  LYS A  57      -1.287 -25.765 -11.210  1.00 24.65           C  
ATOM    410  C   LYS A  57      -1.888 -27.177 -11.059  1.00 28.43           C  
ATOM    411  O   LYS A  57      -2.606 -27.446 -10.076  1.00 28.89           O  
ATOM    412  CB  LYS A  57      -2.233 -24.753 -11.843  1.00 27.32           C  
ATOM    413  CG  LYS A  57      -1.805 -23.332 -11.492  1.00 29.21           C  
ATOM    414  CD  LYS A  57      -2.658 -22.283 -12.176  1.00 40.53           C  
ATOM    415  CE  LYS A  57      -4.068 -22.286 -11.623  1.00 33.55           C  
ATOM    416  NZ  LYS A  57      -4.618 -20.921 -11.676  1.00 33.03           N  
ATOM    417  N   GLU A  58      -1.558 -28.087 -11.972  1.00 25.92           N  
ATOM    418  CA  GLU A  58      -2.075 -29.461 -11.849  1.00 24.52           C  
ATOM    419  C   GLU A  58      -1.546 -30.207 -10.636  1.00 27.75           C  
ATOM    420  O   GLU A  58      -2.328 -30.781  -9.839  1.00 27.48           O  
ATOM    421  CB  GLU A  58      -1.752 -30.278 -13.094  1.00 29.82           C  
ATOM    422  CG  GLU A  58      -2.375 -31.664 -13.052  1.00 38.41           C  
ATOM    423  CD  GLU A  58      -1.541 -32.685 -13.771  1.00 64.19           C  
ATOM    424  OE1 GLU A  58      -0.981 -33.572 -13.088  1.00 78.72           O  
ATOM    425  OE2 GLU A  58      -1.428 -32.588 -15.012  1.00 66.34           O  
ATOM    426  N   ALA A  59      -0.215 -30.197 -10.513  1.00 27.14           N  
ATOM    427  CA  ALA A  59       0.484 -30.875  -9.424  1.00 23.84           C  
ATOM    428  C   ALA A  59       0.174 -30.169  -8.116  1.00 19.50           C  
ATOM    429  O   ALA A  59       0.107 -30.819  -7.074  1.00 21.33           O  
ATOM    430  CB  ALA A  59       1.975 -30.906  -9.678  1.00 22.43           C  
ATOM    431  N   VAL A  60       0.010 -28.840  -8.145  1.00 19.15           N  
ATOM    432  CA  VAL A  60      -0.324 -28.149  -6.917  1.00 15.46           C  
ATOM    433  C   VAL A  60      -1.784 -28.452  -6.509  1.00 15.50           C  
ATOM    434  O   VAL A  60      -2.139 -28.381  -5.349  1.00 18.19           O  
ATOM    435  CB  VAL A  60       0.053 -26.611  -6.868  0.65 22.49           C  
ATOM    437  CG1 VAL A  60       1.507 -26.398  -7.328  0.65 20.93           C  
ATOM    439  CG2 VAL A  60      -0.888 -25.775  -7.658  0.65 21.89           C  
ATOM    441  N   GLY A  61      -2.617 -28.772  -7.500  1.00 18.38           N  
ATOM    442  CA  GLY A  61      -3.984 -29.237  -7.201  1.00 17.88           C  
ATOM    443  C   GLY A  61      -3.937 -30.573  -6.441  1.00 13.66           C  
ATOM    444  O   GLY A  61      -4.662 -30.744  -5.442  1.00 16.60           O  
ATOM    445  N   ALA A  62      -3.101 -31.504  -6.903  1.00 17.58           N  
ATOM    446  CA  ALA A  62      -2.922 -32.799  -6.225  1.00 19.79           C  
ATOM    447  C   ALA A  62      -2.379 -32.566  -4.831  1.00 19.42           C  
ATOM    448  O   ALA A  62      -2.777 -33.207  -3.877  1.00 16.42           O  
ATOM    449  CB  ALA A  62      -2.009 -33.735  -6.997  1.00 20.63           C  
ATOM    450  N   PHE A  63      -1.468 -31.605  -4.707  1.00 17.31           N  
ATOM    451  CA  PHE A  63      -0.966 -31.227  -3.368  1.00 15.02           C  
ATOM    452  C   PHE A  63      -2.081 -30.750  -2.435  1.00 14.41           C  
ATOM    453  O   PHE A  63      -2.145 -31.164  -1.280  1.00 16.15           O  
ATOM    454  CB  PHE A  63       0.157 -30.167  -3.526  1.00 16.49           C  
ATOM    455  CG  PHE A  63       0.635 -29.559  -2.223  1.00 17.53           C  
ATOM    456  CD1 PHE A  63       1.682 -30.142  -1.510  1.00 16.78           C  
ATOM    457  CD2 PHE A  63       0.052 -28.413  -1.721  1.00 16.35           C  
ATOM    458  CE1 PHE A  63       2.113 -29.584  -0.311  1.00 16.35           C  
ATOM    459  CE2 PHE A  63       0.488 -27.859  -0.525  1.00 21.98           C  
ATOM    460  CZ  PHE A  63       1.533 -28.461   0.177  1.00 20.19           C  
ATOM    461  N   PHE A  64      -2.960 -29.878  -2.931  1.00 12.68           N  
ATOM    462  CA  PHE A  64      -4.095 -29.456  -2.137  1.00 13.20           C  
ATOM    463  C   PHE A  64      -4.909 -30.712  -1.671  1.00 11.98           C  
ATOM    464  O   PHE A  64      -5.281 -30.816  -0.505  1.00 13.20           O  
ATOM    465  CB  PHE A  64      -4.981 -28.492  -2.945  1.00 15.33           C  
ATOM    466  CG  PHE A  64      -6.197 -27.992  -2.195  1.00 16.31           C  
ATOM    467  CD1 PHE A  64      -6.178 -26.739  -1.557  1.00 19.93           C  
ATOM    468  CD2 PHE A  64      -7.373 -28.756  -2.131  1.00 17.77           C  
ATOM    469  CE1 PHE A  64      -7.290 -26.263  -0.871  1.00 17.49           C  
ATOM    470  CE2 PHE A  64      -8.501 -28.291  -1.444  1.00 15.26           C  
ATOM    471  CZ  PHE A  64      -8.465 -27.037  -0.795  1.00 17.14           C  
ATOM    472  N   ASP A  65      -5.188 -31.603  -2.605  1.00 16.66           N  
ATOM    473  CA  ASP A  65      -6.048 -32.767  -2.323  1.00 14.41           C  
ATOM    474  C   ASP A  65      -5.484 -33.614  -1.186  1.00 15.05           C  
ATOM    475  O   ASP A  65      -6.184 -33.928  -0.216  1.00 17.76           O  
ATOM    476  CB  ASP A  65      -6.212 -33.587  -3.609  1.00 13.86           C  
ATOM    477  CG  ASP A  65      -6.994 -32.826  -4.687  1.00 12.18           C  
ATOM    478  OD1 ASP A  65      -7.753 -31.878  -4.340  1.00 16.14           O  
ATOM    479  OD2 ASP A  65      -6.857 -33.219  -5.866  1.00 16.67           O  
ATOM    480  N   THR A  66      -4.195 -33.916  -1.278  1.00 16.67           N  
ATOM    481  CA  THR A  66      -3.569 -34.901  -0.383  1.00 18.10           C  
ATOM    482  C   THR A  66      -3.099 -34.239   0.917  1.00 19.32           C  
ATOM    483  O   THR A  66      -3.275 -34.764   2.025  1.00 17.98           O  
ATOM    484  CB  THR A  66      -2.367 -35.553  -1.085  1.00 24.05           C  
ATOM    485  OG1 THR A  66      -2.797 -36.181  -2.310  1.00 22.05           O  
ATOM    486  CG2 THR A  66      -1.695 -36.594  -0.180  1.00 21.99           C  
ATOM    487  N   HIS A  67      -2.459 -33.073   0.754  1.00 16.19           N  
ATOM    488  CA  HIS A  67      -1.797 -32.397   1.871  1.00 17.85           C  
ATOM    489  C   HIS A  67      -2.460 -31.150   2.475  1.00 19.73           C  
ATOM    490  O   HIS A  67      -1.901 -30.520   3.413  1.00 18.02           O  
ATOM    491  CB  HIS A  67      -0.338 -32.099   1.469  1.00 14.80           C  
ATOM    492  CG  HIS A  67       0.420 -33.317   1.062  1.00 18.13           C  
ATOM    493  ND1 HIS A  67       0.651 -34.376   1.918  1.00 21.64           N  
ATOM    494  CD2 HIS A  67       0.982 -33.659  -0.117  1.00 20.54           C  
ATOM    495  CE1 HIS A  67       1.338 -35.308   1.280  1.00 17.53           C  
ATOM    496  NE2 HIS A  67       1.567 -34.888   0.052  1.00 20.54           N  
ATOM    497  N   ILE A  68      -3.654 -30.797   1.989  1.00 14.78           N  
ATOM    498  CA  ILE A  68      -4.440 -29.739   2.615  1.00 15.79           C  
ATOM    499  C   ILE A  68      -5.831 -30.267   3.002  1.00 13.52           C  
ATOM    500  O   ILE A  68      -6.261 -30.117   4.136  1.00 16.93           O  
ATOM    501  CB  ILE A  68      -4.563 -28.478   1.701  1.00 13.50           C  
ATOM    502  CG1 ILE A  68      -3.157 -27.826   1.542  1.00 14.58           C  
ATOM    503  CG2 ILE A  68      -5.512 -27.462   2.343  1.00 16.54           C  
ATOM    504  CD1 ILE A  68      -3.082 -26.618   0.592  1.00 15.03           C  
ATOM    505  N   ALA A  69      -6.501 -30.858   2.024  1.00 16.57           N  
ATOM    506  CA  ALA A  69      -7.882 -31.320   2.214  1.00 16.03           C  
ATOM    507  C   ALA A  69      -7.959 -32.667   2.965  1.00 13.88           C  
ATOM    508  O   ALA A  69      -8.565 -32.729   4.022  1.00 16.55           O  
ATOM    509  CB  ALA A  69      -8.596 -31.380   0.843  1.00 19.18           C  
ATOM    510  N   ALA A  70      -7.369 -33.714   2.391  1.00 14.59           N  
ATOM    511  CA  ALA A  70      -7.470 -35.078   2.992  1.00 16.96           C  
ATOM    512  C   ALA A  70      -6.869 -35.167   4.413  1.00 21.99           C  
ATOM    513  O   ALA A  70      -7.269 -36.021   5.229  1.00 20.77           O  
ATOM    514  CB  ALA A  70      -6.896 -36.114   2.087  1.00 18.68           C  
ATOM    515  N   ASN A  71      -5.889 -34.311   4.712  1.00 20.59           N  
ATOM    516  CA  ASN A  71      -5.309 -34.271   6.048  1.00 17.96           C  
ATOM    517  C   ASN A  71      -5.922 -33.237   7.005  1.00 18.47           C  
ATOM    518  O   ASN A  71      -5.416 -33.025   8.122  1.00 18.14           O  
ATOM    519  CB  ASN A  71      -3.759 -34.144   5.951  1.00 21.16           C  
ATOM    520  CG  ASN A  71      -3.313 -32.762   5.501  1.00 26.50           C  
ATOM    521  OD1 ASN A  71      -2.129 -32.364   5.665  1.00 22.32           O  
ATOM    522  ND2 ASN A  71      -4.248 -32.006   4.942  1.00 16.70           N  
ATOM    523  N   ARG A  72      -7.045 -32.617   6.612  1.00 13.31           N  
ATOM    524  CA  ARG A  72      -7.752 -31.648   7.464  1.00 14.40           C  
ATOM    525  C   ARG A  72      -6.864 -30.512   7.980  1.00 13.17           C  
ATOM    526  O   ARG A  72      -6.985 -30.099   9.140  1.00 17.23           O  
ATOM    527  CB  ARG A  72      -8.432 -32.334   8.665  1.00 21.39           C  
ATOM    528  CG  ARG A  72      -9.551 -33.275   8.258  1.00 34.07           C  
ATOM    529  CD  ARG A  72     -10.420 -33.632   9.456  1.00 40.27           C  
ATOM    530  NE  ARG A  72     -11.829 -33.692   9.068  1.00 59.85           N  
ATOM    531  CZ  ARG A  72     -12.410 -34.740   8.493  1.00 44.97           C  
ATOM    532  NH1 ARG A  72     -11.716 -35.850   8.231  1.00 40.54           N  
ATOM    533  NH2 ARG A  72     -13.693 -34.675   8.178  1.00 70.09           N  
ATOM    534  N   LEU A  73      -5.959 -30.049   7.109  1.00 17.06           N  
ATOM    535  CA  LEU A  73      -5.018 -28.970   7.462  1.00 15.51           C  
ATOM    536  C   LEU A  73      -5.756 -27.705   7.906  1.00 16.49           C  
ATOM    537  O   LEU A  73      -6.733 -27.264   7.242  1.00 19.03           O  
ATOM    538  CB  LEU A  73      -4.120 -28.683   6.256  1.00 12.60           C  
ATOM    539  CG  LEU A  73      -3.047 -27.602   6.552  1.00 13.58           C  
ATOM    540  CD1 LEU A  73      -1.975 -28.223   7.474  1.00 21.23           C  
ATOM    541  CD2 LEU A  73      -2.445 -27.074   5.236  1.00 17.11           C  
ATOM    542  N   THR A  74      -5.343 -27.131   9.033  1.00 13.91           N  
ATOM    543  CA  THR A  74      -5.745 -25.780   9.377  1.00 15.32           C  
ATOM    544  C   THR A  74      -4.473 -24.922   9.383  1.00 18.13           C  
ATOM    545  O   THR A  74      -3.372 -25.420   9.642  1.00 15.73           O  
ATOM    546  CB  THR A  74      -6.459 -25.675  10.702  1.00 18.08           C  
ATOM    547  OG1 THR A  74      -5.554 -25.965  11.769  1.00 19.05           O  
ATOM    548  CG2 THR A  74      -7.660 -26.661  10.756  1.00 21.68           C  
ATOM    549  N   VAL A  75      -4.661 -23.639   9.078  1.00 17.96           N  
ATOM    550  CA  VAL A  75      -3.560 -22.679   8.993  1.00 14.89           C  
ATOM    551  C   VAL A  75      -3.939 -21.463   9.837  1.00 21.13           C  
ATOM    552  O   VAL A  75      -5.004 -20.853   9.623  1.00 26.83           O  
ATOM    553  CB  VAL A  75      -3.300 -22.271   7.521  1.00 15.73           C  
ATOM    554  CG1 VAL A  75      -2.080 -21.317   7.448  1.00 20.96           C  
ATOM    555  CG2 VAL A  75      -3.023 -23.475   6.651  1.00 22.11           C  
ATOM    556  N   THR A  76      -3.094 -21.117  10.797  1.00 17.77           N  
ATOM    557  CA  THR A  76      -3.313 -19.973  11.677  1.00 17.71           C  
ATOM    558  C   THR A  76      -2.153 -18.994  11.493  1.00 19.41           C  
ATOM    559  O   THR A  76      -1.013 -19.409  11.589  1.00 16.00           O  
ATOM    560  CB  THR A  76      -3.382 -20.417  13.145  1.00 19.99           C  
ATOM    561  OG1 THR A  76      -4.465 -21.355  13.290  1.00 32.50           O  
ATOM    562  CG2 THR A  76      -3.647 -19.246  14.070  1.00 26.56           C  
ATOM    563  N   CYS A  77      -2.442 -17.724  11.198  1.00 14.67           N  
ATOM    564  CA  CYS A  77      -1.367 -16.700  11.137  1.00 17.04           C  
ATOM    565  C   CYS A  77      -1.020 -16.149  12.526  1.00 20.07           C  
ATOM    566  O   CYS A  77      -1.850 -15.501  13.197  1.00 22.54           O  
ATOM    567  CB  CYS A  77      -1.766 -15.569  10.200  1.00 15.97           C  
ATOM    568  SG  CYS A  77      -0.410 -14.394   9.993  1.00 19.33           S  
ATOM    569  N   GLU A  78       0.195 -16.422  12.988  1.00 15.51           N  
ATOM    570  CA  GLU A  78       0.637 -15.910  14.275  1.00 14.44           C  
ATOM    571  C   GLU A  78       1.170 -14.470  14.181  1.00 18.49           C  
ATOM    572  O   GLU A  78       0.931 -13.630  15.052  1.00 19.13           O  
ATOM    573  CB  GLU A  78       1.712 -16.802  14.869  1.00 19.19           C  
ATOM    574  CG  GLU A  78       2.210 -16.340  16.217  1.00 20.94           C  
ATOM    575  CD  GLU A  78       3.369 -17.178  16.710  1.00 34.65           C  
ATOM    576  OE1 GLU A  78       3.137 -18.366  17.005  1.00 30.92           O  
ATOM    577  OE2 GLU A  78       4.503 -16.659  16.782  1.00 28.75           O  
ATOM    578  N   GLU A  79       1.940 -14.208  13.137  1.00 15.78           N  
ATOM    579  CA  GLU A  79       2.602 -12.900  12.990  1.00 14.30           C  
ATOM    580  C   GLU A  79       2.943 -12.685  11.525  1.00 14.31           C  
ATOM    581  O   GLU A  79       3.213 -13.638  10.792  1.00 14.38           O  
ATOM    582  CB  GLU A  79       3.852 -12.856  13.853  1.00 15.56           C  
ATOM    583  CG  GLU A  79       4.446 -11.464  13.944  1.00 24.74           C  
ATOM    584  CD  GLU A  79       5.522 -11.333  14.976  1.00 25.40           C  
ATOM    585  OE1 GLU A  79       6.034 -12.370  15.506  1.00 24.37           O  
ATOM    586  OE2 GLU A  79       5.870 -10.155  15.214  1.00 31.57           O  
ATOM    587  N   THR A  80       2.948 -11.410  11.106  1.00 12.47           N  
ATOM    588  CA  THR A  80       3.160 -11.071   9.711  1.00 11.64           C  
ATOM    589  C   THR A  80       4.307 -10.082   9.616  1.00 13.52           C  
ATOM    590  O   THR A  80       4.388  -9.145  10.427  1.00 14.85           O  
ATOM    591  CB  THR A  80       1.886 -10.436   9.079  1.00 13.25           C  
ATOM    592  OG1 THR A  80       0.855 -11.447   8.964  1.00 13.73           O  
ATOM    593  CG2 THR A  80       2.168  -9.836   7.705  1.00 13.01           C  
ATOM    594  N   PHE A  81       5.169 -10.316   8.626  1.00 10.56           N  
ATOM    595  CA  PHE A  81       6.351  -9.491   8.355  1.00 12.18           C  
ATOM    596  C   PHE A  81       6.349  -9.016   6.896  1.00  7.25           C  
ATOM    597  O   PHE A  81       6.840  -9.659   5.975  1.00 11.75           O  
ATOM    598  CB  PHE A  81       7.637 -10.283   8.645  1.00 11.37           C  
ATOM    599  CG  PHE A  81       7.796 -10.655  10.094  1.00 11.53           C  
ATOM    600  CD1 PHE A  81       8.441  -9.794  10.973  1.00 14.83           C  
ATOM    601  CD2 PHE A  81       7.276 -11.866  10.587  1.00 11.95           C  
ATOM    602  CE1 PHE A  81       8.619 -10.124  12.308  1.00 15.54           C  
ATOM    603  CE2 PHE A  81       7.464 -12.213  11.932  1.00 14.92           C  
ATOM    604  CZ  PHE A  81       8.140 -11.340  12.781  1.00 14.99           C  
ATOM    605  N   PRO A  82       5.767  -7.814   6.666  1.00 10.47           N  
ATOM    606  CA  PRO A  82       5.864  -7.175   5.388  1.00 11.05           C  
ATOM    607  C   PRO A  82       7.348  -6.962   5.022  1.00 11.18           C  
ATOM    608  O   PRO A  82       8.201  -6.843   5.954  1.00 11.96           O  
ATOM    609  CB  PRO A  82       5.218  -5.797   5.665  1.00 11.22           C  
ATOM    610  CG  PRO A  82       4.325  -6.010   6.781  1.00 14.95           C  
ATOM    611  CD  PRO A  82       5.038  -6.996   7.656  1.00 12.04           C  
ATOM    612  N   SER A  83       7.662  -6.925   3.725  1.00 10.47           N  
ATOM    613  CA  SER A  83       9.003  -6.464   3.312  1.00  9.80           C  
ATOM    614  C   SER A  83       8.868  -5.029   2.801  1.00 12.07           C  
ATOM    615  O   SER A  83       7.869  -4.373   3.106  1.00 11.11           O  
ATOM    616  CB  SER A  83       9.583  -7.363   2.216  1.00 11.13           C  
ATOM    617  OG  SER A  83       8.884  -7.212   0.995  1.00 12.14           O  
ATOM    618  N   SER A  84       9.847  -4.590   2.029  1.00  8.89           N  
ATOM    619  CA  SER A  84       9.743  -3.258   1.369  1.00 10.34           C  
ATOM    620  C   SER A  84       9.253  -3.370  -0.063  1.00 14.80           C  
ATOM    621  O   SER A  84       9.254  -2.391  -0.841  1.00 15.74           O  
ATOM    622  CB  SER A  84      11.078  -2.500   1.448  1.00 12.10           C  
ATOM    623  OG  SER A  84      11.353  -2.229   2.804  1.00 11.31           O  
ATOM    624  N   SER A  85       8.858  -4.584  -0.430  1.00 15.09           N  
ATOM    625  CA  SER A  85       8.267  -4.857  -1.727  1.00 11.78           C  
ATOM    626  C   SER A  85       6.800  -5.238  -1.503  1.00 15.21           C  
ATOM    627  O   SER A  85       6.505  -6.126  -0.710  1.00 13.46           O  
ATOM    628  CB  SER A  85       8.944  -6.056  -2.402  1.00 13.61           C  
ATOM    629  OG  SER A  85       8.209  -6.422  -3.572  1.00 15.57           O  
ATOM    630  N   PRO A  86       5.858  -4.598  -2.221  1.00 16.43           N  
ATOM    631  CA  PRO A  86       4.439  -5.014  -2.099  1.00 16.16           C  
ATOM    632  C   PRO A  86       4.161  -6.453  -2.593  1.00 13.24           C  
ATOM    633  O   PRO A  86       3.048  -6.955  -2.397  1.00 16.70           O  
ATOM    634  CB  PRO A  86       3.712  -4.023  -3.055  1.00 16.31           C  
ATOM    635  CG  PRO A  86       4.645  -2.800  -3.042  0.50 11.23           C  
ATOM    637  CD  PRO A  86       6.003  -3.445  -3.145  1.00 19.20           C  
ATOM    638  N   ASP A  87       5.146  -7.068  -3.238  1.00 11.83           N  
ATOM    639  CA  ASP A  87       4.974  -8.397  -3.826  1.00 14.39           C  
ATOM    640  C   ASP A  87       5.625  -9.543  -3.075  1.00 11.24           C  
ATOM    641  O   ASP A  87       5.538 -10.681  -3.524  1.00 12.39           O  
ATOM    642  CB  ASP A  87       5.449  -8.404  -5.269  1.00 11.40           C  
ATOM    643  CG  ASP A  87       4.594  -7.451  -6.187  1.00 17.19           C  
ATOM    644  OD1 ASP A  87       3.529  -6.974  -5.739  1.00 21.82           O  
ATOM    645  OD2 ASP A  87       5.042  -7.197  -7.305  1.00 29.94           O  
ATOM    646  N   GLU A  88       6.244  -9.236  -1.942  1.00  9.11           N  
ATOM    647  CA  GLU A  88       6.862 -10.298  -1.080  1.00 10.30           C  
ATOM    648  C   GLU A  88       6.558 -10.067   0.367  1.00 10.86           C  
ATOM    649  O   GLU A  88       6.635  -8.931   0.879  1.00 11.67           O  
ATOM    650  CB  GLU A  88       8.377 -10.398  -1.316  1.00 11.78           C  
ATOM    651  CG  GLU A  88       8.755 -10.700  -2.758  1.00 13.37           C  
ATOM    652  CD  GLU A  88      10.125 -11.299  -2.933  1.00 19.99           C  
ATOM    653  OE1 GLU A  88      10.442 -12.341  -2.317  1.00 17.26           O  
ATOM    654  OE2 GLU A  88      10.892 -10.744  -3.748  1.00 17.51           O  
ATOM    655  N   ILE A  89       6.216 -11.154   1.062  1.00  8.84           N  
ATOM    656  CA  ILE A  89       5.841 -11.081   2.441  1.00  7.93           C  
ATOM    657  C   ILE A  89       6.213 -12.422   3.146  1.00  8.48           C  
ATOM    658  O   ILE A  89       6.337 -13.450   2.490  1.00 10.59           O  
ATOM    659  CB  ILE A  89       4.299 -10.761   2.592  1.00  8.68           C  
ATOM    660  CG1 ILE A  89       3.939 -10.370   4.029  1.00  9.42           C  
ATOM    661  CG2 ILE A  89       3.467 -11.992   2.152  1.00  9.86           C  
ATOM    662  CD1 ILE A  89       2.535  -9.686   4.111  1.00 12.81           C  
ATOM    663  N   ALA A  90       6.407 -12.335   4.460  1.00 10.07           N  
ATOM    664  CA  ALA A  90       6.634 -13.546   5.295  1.00  8.98           C  
ATOM    665  C   ALA A  90       5.663 -13.578   6.480  1.00 10.75           C  
ATOM    666  O   ALA A  90       5.219 -12.536   6.959  1.00 10.53           O  
ATOM    667  CB  ALA A  90       8.083 -13.547   5.797  1.00 10.55           C  
ATOM    668  N   HIS A  91       5.368 -14.770   7.003  1.00  9.71           N  
ATOM    669  CA  HIS A  91       4.451 -14.913   8.142  1.00 11.99           C  
ATOM    670  C   HIS A  91       4.990 -16.034   8.995  1.00 10.93           C  
ATOM    671  O   HIS A  91       5.681 -16.922   8.481  1.00 12.55           O  
ATOM    672  CB  HIS A  91       3.062 -15.338   7.673  1.00 11.93           C  
ATOM    673  CG  HIS A  91       2.423 -14.425   6.669  1.00 11.48           C  
ATOM    674  ND1 HIS A  91       1.680 -13.316   7.030  1.00 13.48           N  
ATOM    675  CD2 HIS A  91       2.348 -14.513   5.320  1.00 14.60           C  
ATOM    676  CE1 HIS A  91       1.215 -12.738   5.929  1.00 12.93           C  
ATOM    677  NE2 HIS A  91       1.607 -13.448   4.883  1.00 13.84           N  
ATOM    678  N   ILE A  92       4.707 -15.974  10.285  1.00  9.27           N  
ATOM    679  CA  ILE A  92       4.833 -17.153  11.134  1.00 10.71           C  
ATOM    680  C   ILE A  92       3.451 -17.792  11.127  1.00 14.07           C  
ATOM    681  O   ILE A  92       2.451 -17.165  11.523  1.00 14.55           O  
ATOM    682  CB  ILE A  92       5.210 -16.804  12.578  1.00 14.61           C  
ATOM    683  CG1 ILE A  92       6.418 -15.847  12.651  0.65 17.34           C  
ATOM    685  CG2 ILE A  92       5.283 -18.100  13.389  1.00 13.35           C  
ATOM    686  CD1 ILE A  92       7.584 -16.247  11.831  0.65 17.94           C  
ATOM    688  N   LEU A  93       3.389 -19.027  10.644  1.00 11.07           N  
ATOM    689  CA  LEU A  93       2.121 -19.772  10.624  1.00 11.09           C  
ATOM    690  C   LEU A  93       2.217 -21.011  11.501  1.00 12.74           C  
ATOM    691  O   LEU A  93       3.286 -21.643  11.619  1.00 11.25           O  
ATOM    692  CB  LEU A  93       1.767 -20.221   9.215  1.00 12.06           C  
ATOM    693  CG  LEU A  93       1.744 -19.210   8.069  1.00 13.81           C  
ATOM    694  CD1 LEU A  93       1.344 -19.900   6.773  1.00 14.21           C  
ATOM    695  CD2 LEU A  93       0.789 -18.089   8.453  1.00 14.18           C  
ATOM    696  N   VAL A  94       1.067 -21.367  12.068  1.00 13.47           N  
ATOM    697  CA  VAL A  94       0.945 -22.629  12.784  1.00 12.01           C  
ATOM    698  C   VAL A  94       0.037 -23.514  11.955  1.00 15.66           C  
ATOM    699  O   VAL A  94      -1.105 -23.126  11.638  1.00 15.70           O  
ATOM    700  CB  VAL A  94       0.411 -22.417  14.210  1.00 12.42           C  
ATOM    701  CG1 VAL A  94       0.140 -23.769  14.886  1.00 19.66           C  
ATOM    702  CG2 VAL A  94       1.411 -21.616  15.063  1.00 19.92           C  
ATOM    703  N   LEU A  95       0.549 -24.695  11.595  1.00 12.54           N  
ATOM    704  CA  LEU A  95      -0.186 -25.662  10.768  1.00 11.59           C  
ATOM    705  C   LEU A  95      -0.617 -26.820  11.649  1.00 17.85           C  
ATOM    706  O   LEU A  95       0.181 -27.305  12.444  1.00 14.11           O  
ATOM    707  CB  LEU A  95       0.663 -26.207   9.614  1.00 11.40           C  
ATOM    708  CG  LEU A  95       1.358 -25.186   8.692  1.00 15.10           C  
ATOM    709  CD1 LEU A  95       2.087 -25.956   7.618  1.00 19.92           C  
ATOM    710  CD2 LEU A  95       0.401 -24.178   8.120  1.00 24.60           C  
ATOM    711  N   HIS A  96      -1.893 -27.219  11.558  1.00 16.66           N  
ATOM    712  CA  HIS A  96      -2.383 -28.401  12.303  1.00 13.97           C  
ATOM    713  C   HIS A  96      -2.999 -29.359  11.306  1.00 16.61           C  
ATOM    714  O   HIS A  96      -3.728 -28.943  10.417  1.00 17.09           O  
ATOM    715  CB  HIS A  96      -3.390 -27.939  13.349  0.35 14.40           C  
ATOM    717  CG  HIS A  96      -3.966 -29.043  14.165  0.35 10.67           C  
ATOM    719  ND1 HIS A  96      -4.961 -29.872  13.692  0.35 16.97           N  
ATOM    721  CD2 HIS A  96      -3.704 -29.449  15.429  0.35 20.55           C  
ATOM    723  CE1 HIS A  96      -5.276 -30.751  14.627  0.35 17.30           C  
ATOM    725  NE2 HIS A  96      -4.531 -30.513  15.691  0.35 19.85           N  
ATOM    727  N   SER A  97      -2.721 -30.652  11.438  1.00 15.67           N  
ATOM    728  CA  SER A  97      -3.323 -31.591  10.497  1.00 16.81           C  
ATOM    729  C   SER A  97      -3.515 -32.931  11.170  1.00 20.90           C  
ATOM    730  O   SER A  97      -3.170 -33.092  12.351  1.00 19.56           O  
ATOM    731  CB  SER A  97      -2.474 -31.702   9.230  1.00 19.51           C  
ATOM    732  OG  SER A  97      -1.273 -32.407   9.490  1.00 24.25           O  
ATOM    733  N   GLU A  98      -4.088 -33.865  10.423  1.00 18.49           N  
ATOM    734  CA  GLU A  98      -4.439 -35.180  10.961  1.00 22.49           C  
ATOM    735  C   GLU A  98      -3.812 -36.252  10.122  1.00 24.91           C  
ATOM    736  O   GLU A  98      -3.632 -36.092   8.907  1.00 24.13           O  
ATOM    737  CB  GLU A  98      -5.959 -35.367  10.986  1.00 23.40           C  
ATOM    738  CG  GLU A  98      -6.609 -34.591  12.085  1.00 21.46           C  
ATOM    739  CD  GLU A  98      -8.116 -34.696  12.040  1.00 54.59           C  
ATOM    740  OE1 GLU A  98      -8.617 -35.741  11.573  1.00 54.59           O  
ATOM    741  OE2 GLU A  98      -8.796 -33.736  12.468  1.00 56.80           O  
ATOM    742  N   PHE A  99      -3.448 -37.361  10.773  1.00 20.54           N  
ATOM    743  CA  PHE A  99      -2.890 -38.475  10.029  1.00 20.56           C  
ATOM    744  C   PHE A  99      -3.276 -39.800  10.706  1.00 21.01           C  
ATOM    745  O   PHE A  99      -3.747 -39.810  11.850  1.00 22.75           O  
ATOM    746  CB  PHE A  99      -1.382 -38.359   9.895  1.00 19.75           C  
ATOM    747  CG  PHE A  99      -0.645 -38.511  11.198  1.00 29.10           C  
ATOM    748  CD1 PHE A  99       0.111 -39.649  11.444  1.00 26.28           C  
ATOM    749  CD2 PHE A  99      -0.748 -37.535  12.198  1.00 20.51           C  
ATOM    750  CE1 PHE A  99       0.783 -39.806  12.671  1.00 24.65           C  
ATOM    751  CE2 PHE A  99      -0.072 -37.684  13.432  1.00 20.44           C  
ATOM    752  CZ  PHE A  99       0.689 -38.830  13.648  1.00 19.84           C  
ATOM    753  N   ASP A 100      -3.120 -40.882   9.948  1.00 27.87           N  
ATOM    754  CA  ASP A 100      -3.345 -42.249  10.443  1.00 30.56           C  
ATOM    755  C   ASP A 100      -4.649 -42.399  11.231  1.00 33.29           C  
ATOM    756  O   ASP A 100      -4.677 -42.982  12.316  1.00 39.93           O  
ATOM    757  CB  ASP A 100      -2.130 -42.722  11.274  1.00 25.18           C  
ATOM    758  CG  ASP A 100      -0.862 -42.824  10.448  1.00 39.02           C  
ATOM    759  OD1 ASP A 100       0.222 -43.044  11.041  1.00 54.72           O  
ATOM    760  OD2 ASP A 100      -0.933 -42.680   9.203  1.00 60.64           O  
ATOM    761  N   GLY A 101      -5.726 -41.846  10.688  1.00 38.07           N  
ATOM    762  CA  GLY A 101      -7.040 -41.990  11.300  1.00 37.24           C  
ATOM    763  C   GLY A 101      -7.348 -41.094  12.483  1.00 40.66           C  
ATOM    764  O   GLY A 101      -8.109 -41.481  13.375  1.00 46.70           O  
ATOM    765  N   GLY A 102      -6.777 -39.891  12.509  1.00 31.80           N  
ATOM    766  CA  GLY A 102      -7.227 -38.905  13.483  1.00 30.79           C  
ATOM    767  C   GLY A 102      -6.224 -38.454  14.526  1.00 21.65           C  
ATOM    768  O   GLY A 102      -6.523 -37.549  15.322  1.00 33.08           O  
ATOM    769  N   PHE A 103      -5.045 -39.081  14.543  1.00 24.43           N  
ATOM    770  CA  PHE A 103      -3.916 -38.529  15.309  1.00 17.92           C  
ATOM    771  C   PHE A 103      -3.578 -37.168  14.695  1.00 22.64           C  
ATOM    772  O   PHE A 103      -3.854 -36.938  13.517  1.00 22.14           O  
ATOM    773  CB  PHE A 103      -2.746 -39.490  15.261  1.00 20.03           C  
ATOM    774  CG  PHE A 103      -2.961 -40.649  16.165  1.00 22.79           C  
ATOM    775  CD1 PHE A 103      -3.489 -41.849  15.696  1.00 30.97           C  
ATOM    776  CD2 PHE A 103      -2.730 -40.479  17.510  1.00 19.68           C  
ATOM    777  CE1 PHE A 103      -3.751 -42.917  16.607  1.00 18.28           C  
ATOM    778  CE2 PHE A 103      -2.983 -41.507  18.402  1.00 34.99           C  
ATOM    779  CZ  PHE A 103      -3.492 -42.707  17.946  1.00 19.96           C  
ATOM    780  N   THR A 104      -2.988 -36.286  15.482  1.00 15.56           N  
ATOM    781  CA  THR A 104      -2.807 -34.882  15.063  1.00 18.34           C  
ATOM    782  C   THR A 104      -1.340 -34.534  15.089  1.00 23.25           C  
ATOM    783  O   THR A 104      -0.586 -35.055  15.914  1.00 16.54           O  
ATOM    784  CB  THR A 104      -3.567 -33.864  15.978  1.00 18.73           C  
ATOM    785  OG1 THR A 104      -3.070 -33.918  17.315  1.00 26.57           O  
ATOM    786  CG2 THR A 104      -5.067 -34.120  16.014  1.00 21.40           C  
ATOM    787  N   SER A 105      -0.926 -33.664  14.175  1.00 17.68           N  
ATOM    788  CA  SER A 105       0.408 -33.076  14.292  1.00 15.47           C  
ATOM    789  C   SER A 105       0.321 -31.587  14.057  1.00 16.32           C  
ATOM    790  O   SER A 105      -0.642 -31.088  13.436  1.00 21.21           O  
ATOM    791  CB  SER A 105       1.415 -33.736  13.362  1.00 22.40           C  
ATOM    792  OG  SER A 105       1.080 -33.540  12.003  1.00 29.81           O  
ATOM    793  N   GLU A 106       1.300 -30.864  14.583  1.00 13.98           N  
ATOM    794  CA  GLU A 106       1.286 -29.410  14.449  1.00 13.56           C  
ATOM    795  C   GLU A 106       2.721 -28.977  14.188  1.00 14.38           C  
ATOM    796  O   GLU A 106       3.669 -29.620  14.649  1.00 13.06           O  
ATOM    797  CB  GLU A 106       0.756 -28.839  15.756  1.00 16.52           C  
ATOM    798  CG  GLU A 106       0.774 -27.358  15.923  1.00 29.32           C  
ATOM    799  CD  GLU A 106       0.069 -26.963  17.217  1.00 37.67           C  
ATOM    800  OE1 GLU A 106      -0.873 -27.687  17.613  1.00 53.10           O  
ATOM    801  OE2 GLU A 106       0.443 -25.951  17.835  1.00 43.03           O  
ATOM    802  N   VAL A 107       2.896 -27.909  13.410  1.00 15.36           N  
ATOM    803  CA  VAL A 107       4.234 -27.357  13.209  1.00 13.96           C  
ATOM    804  C   VAL A 107       4.101 -25.827  13.119  1.00 12.80           C  
ATOM    805  O   VAL A 107       3.102 -25.336  12.586  1.00 12.53           O  
ATOM    806  CB  VAL A 107       5.014 -27.966  12.002  1.00 16.41           C  
ATOM    807  CG1 VAL A 107       4.515 -27.390  10.664  1.00 17.27           C  
ATOM    808  CG2 VAL A 107       6.522 -27.687  12.172  1.00 17.12           C  
ATOM    809  N   ARG A 108       5.095 -25.112  13.650  1.00 11.79           N  
ATOM    810  CA  ARG A 108       5.136 -23.649  13.571  1.00 11.65           C  
ATOM    811  C   ARG A 108       6.351 -23.295  12.727  1.00 11.66           C  
ATOM    812  O   ARG A 108       7.495 -23.728  13.027  1.00 14.05           O  
ATOM    813  CB  ARG A 108       5.257 -23.099  14.984  1.00 17.91           C  
ATOM    814  CG  ARG A 108       5.354 -21.570  15.072  1.00 15.01           C  
ATOM    815  CD  ARG A 108       5.079 -21.148  16.522  1.00 18.60           C  
ATOM    816  NE  ARG A 108       5.504 -19.779  16.708  1.00 24.01           N  
ATOM    817  CZ  ARG A 108       6.768 -19.423  16.884  1.00 20.62           C  
ATOM    818  NH1 ARG A 108       7.728 -20.360  16.924  1.00 21.38           N  
ATOM    819  NH2 ARG A 108       7.071 -18.142  17.009  1.00 21.19           N  
ATOM    820  N   GLY A 109       6.150 -22.541  11.645  1.00 10.60           N  
ATOM    821  CA  GLY A 109       7.268 -22.290  10.699  1.00 10.28           C  
ATOM    822  C   GLY A 109       7.144 -20.895  10.114  1.00 13.14           C  
ATOM    823  O   GLY A 109       6.119 -20.227  10.335  1.00 12.36           O  
ATOM    824  N   VAL A 110       8.191 -20.474   9.409  1.00 11.62           N  
ATOM    825  CA  VAL A 110       8.169 -19.225   8.675  1.00  9.66           C  
ATOM    826  C   VAL A 110       7.742 -19.592   7.262  1.00  9.77           C  
ATOM    827  O   VAL A 110       8.275 -20.536   6.651  1.00  8.81           O  
ATOM    828  CB  VAL A 110       9.560 -18.551   8.623  1.00 11.66           C  
ATOM    829  CG1 VAL A 110       9.632 -17.508   7.478  1.00 14.23           C  
ATOM    830  CG2 VAL A 110       9.856 -17.870   9.974  1.00 13.02           C  
ATOM    831  N   PHE A 111       6.771 -18.847   6.725  1.00  9.26           N  
ATOM    832  CA  PHE A 111       6.379 -19.061   5.333  1.00  9.24           C  
ATOM    833  C   PHE A 111       6.534 -17.759   4.547  1.00 10.55           C  
ATOM    834  O   PHE A 111       6.069 -16.709   5.005  1.00 11.32           O  
ATOM    835  CB  PHE A 111       4.932 -19.561   5.244  1.00 12.47           C  
ATOM    836  CG  PHE A 111       4.777 -20.957   5.809  1.00 12.60           C  
ATOM    837  CD1 PHE A 111       4.643 -22.058   4.971  1.00 19.58           C  
ATOM    838  CD2 PHE A 111       4.815 -21.131   7.185  1.00 17.31           C  
ATOM    839  CE1 PHE A 111       4.527 -23.340   5.554  1.00 15.04           C  
ATOM    840  CE2 PHE A 111       4.709 -22.409   7.748  1.00 18.26           C  
ATOM    841  CZ  PHE A 111       4.575 -23.470   6.920  1.00 13.88           C  
ATOM    842  N   THR A 112       7.197 -17.853   3.409  1.00  8.71           N  
ATOM    843  CA  THR A 112       7.403 -16.701   2.538  1.00  9.72           C  
ATOM    844  C   THR A 112       6.554 -16.831   1.308  1.00 11.94           C  
ATOM    845  O   THR A 112       6.341 -17.926   0.788  1.00  9.38           O  
ATOM    846  CB  THR A 112       8.893 -16.482   2.125  1.00 10.44           C  
ATOM    847  OG1 THR A 112       9.384 -17.560   1.307  1.00 11.49           O  
ATOM    848  CG2 THR A 112       9.777 -16.330   3.406  1.00  9.82           C  
ATOM    849  N   TYR A 113       6.061 -15.697   0.834  1.00 12.26           N  
ATOM    850  CA  TYR A 113       5.240 -15.694  -0.375  1.00  8.49           C  
ATOM    851  C   TYR A 113       5.770 -14.637  -1.337  1.00 11.92           C  
ATOM    852  O   TYR A 113       6.174 -13.559  -0.909  1.00 12.23           O  
ATOM    853  CB  TYR A 113       3.780 -15.319  -0.083  1.00 11.50           C  
ATOM    854  CG  TYR A 113       3.027 -16.283   0.827  1.00 11.94           C  
ATOM    855  CD1 TYR A 113       1.957 -17.054   0.334  1.00 15.18           C  
ATOM    856  CD2 TYR A 113       3.362 -16.398   2.174  1.00 11.79           C  
ATOM    857  CE1 TYR A 113       1.267 -17.918   1.175  1.00 16.83           C  
ATOM    858  CE2 TYR A 113       2.683 -17.278   3.014  1.00 12.54           C  
ATOM    859  CZ  TYR A 113       1.624 -18.018   2.504  1.00 15.48           C  
ATOM    860  OH  TYR A 113       0.948 -18.873   3.345  1.00 16.88           O  
ATOM    861  N   ARG A 114       5.714 -14.968  -2.612  1.00 10.18           N  
ATOM    862  CA  ARG A 114       5.995 -13.980  -3.675  1.00 10.49           C  
ATOM    863  C   ARG A 114       4.795 -13.994  -4.630  1.00 13.90           C  
ATOM    864  O   ARG A 114       4.315 -15.060  -5.006  1.00 11.40           O  
ATOM    865  CB  ARG A 114       7.276 -14.345  -4.420  1.00 11.24           C  
ATOM    866  CG  ARG A 114       7.687 -13.255  -5.482  1.00 14.35           C  
ATOM    867  CD  ARG A 114       8.839 -13.732  -6.325  1.00 18.79           C  
ATOM    868  NE  ARG A 114       9.165 -12.774  -7.397  1.00 25.64           N  
ATOM    869  CZ  ARG A 114       8.571 -12.716  -8.596  1.00 40.86           C  
ATOM    870  NH1 ARG A 114       7.577 -13.546  -8.920  1.00 21.50           N  
ATOM    871  NH2 ARG A 114       8.969 -11.796  -9.485  1.00 33.04           N  
ATOM    872  N   VAL A 115       4.337 -12.812  -5.035  1.00 11.92           N  
ATOM    873  CA  VAL A 115       3.347 -12.711  -6.144  1.00 14.46           C  
ATOM    874  C   VAL A 115       3.971 -11.999  -7.341  1.00 18.28           C  
ATOM    875  O   VAL A 115       4.979 -11.266  -7.213  1.00 14.74           O  
ATOM    876  CB  VAL A 115       2.016 -12.015  -5.713  1.00 12.81           C  
ATOM    877  CG1 VAL A 115       1.337 -12.748  -4.601  1.00 14.25           C  
ATOM    878  CG2 VAL A 115       2.248 -10.547  -5.275  1.00 16.34           C  
ATOM    879  N   ASN A 116       3.423 -12.254  -8.526  1.00 17.32           N  
ATOM    880  CA  ASN A 116       3.823 -11.477  -9.707  1.00 18.63           C  
ATOM    881  C   ASN A 116       3.030 -10.159  -9.744  1.00 14.32           C  
ATOM    882  O   ASN A 116       2.256  -9.861  -8.829  1.00 20.03           O  
ATOM    883  CB  ASN A 116       3.662 -12.322 -10.977  1.00 19.03           C  
ATOM    884  CG  ASN A 116       2.219 -12.752 -11.227  1.00 14.50           C  
ATOM    885  OD1 ASN A 116       1.263 -12.160 -10.692  1.00 19.19           O  
ATOM    886  ND2 ASN A 116       2.051 -13.801 -12.029  1.00 19.47           N  
ATOM    887  N   LYS A 117       3.240  -9.353 -10.790  1.00 25.34           N  
ATOM    888  CA  LYS A 117       2.580  -8.031 -10.903  1.00 26.89           C  
ATOM    889  C   LYS A 117       1.056  -8.094 -10.994  1.00 28.53           C  
ATOM    890  O   LYS A 117       0.339  -7.197 -10.484  1.00 26.86           O  
ATOM    891  CB  LYS A 117       3.168  -7.221 -12.065  1.00 27.35           C  
ATOM    892  CG  LYS A 117       4.559  -6.661 -11.767  1.00 32.57           C  
ATOM    893  CD  LYS A 117       4.634  -5.948 -10.403  1.00 37.00           C  
ATOM    894  CE  LYS A 117       6.038  -5.400 -10.139  1.00 51.61           C  
ATOM    895  NZ  LYS A 117       6.043  -4.494  -8.947  1.00 53.34           N  
ATOM    896  N   ALA A 118       0.571  -9.196 -11.578  1.00 27.78           N  
ATOM    897  CA  ALA A 118      -0.845  -9.527 -11.596  1.00 27.72           C  
ATOM    898  C   ALA A 118      -1.424  -9.931 -10.244  1.00 26.31           C  
ATOM    899  O   ALA A 118      -2.641 -10.013 -10.085  1.00 28.89           O  
ATOM    900  CB  ALA A 118      -1.108 -10.632 -12.651  1.00 29.74           C  
ATOM    901  N   GLY A 119      -0.555 -10.209  -9.260  1.00 19.79           N  
ATOM    902  CA  GLY A 119      -1.015 -10.474  -7.918  1.00 16.40           C  
ATOM    903  C   GLY A 119      -1.158 -11.970  -7.632  1.00 11.20           C  
ATOM    904  O   GLY A 119      -1.686 -12.326  -6.560  1.00 15.34           O  
ATOM    905  N   LEU A 120      -0.715 -12.779  -8.591  1.00 15.00           N  
ATOM    906  CA  LEU A 120      -0.845 -14.261  -8.442  1.00 18.69           C  
ATOM    907  C   LEU A 120       0.393 -14.806  -7.749  1.00 15.06           C  
ATOM    908  O   LEU A 120       1.512 -14.337  -7.996  1.00 16.07           O  
ATOM    909  CB  LEU A 120      -1.016 -14.943  -9.804  1.00 19.54           C  
ATOM    910  CG  LEU A 120      -2.342 -14.533 -10.496  1.00 19.26           C  
ATOM    911  CD1 LEU A 120      -2.532 -15.395 -11.735  1.00 21.71           C  
ATOM    912  CD2 LEU A 120      -3.526 -14.611  -9.518  1.00 17.10           C  
ATOM    913  N   ILE A 121       0.186 -15.831  -6.919  1.00 15.23           N  
ATOM    914  CA  ILE A 121       1.294 -16.452  -6.193  1.00 13.37           C  
ATOM    915  C   ILE A 121       2.245 -17.228  -7.106  1.00 13.82           C  
ATOM    916  O   ILE A 121       1.855 -18.179  -7.820  1.00 15.02           O  
ATOM    917  CB  ILE A 121       0.784 -17.378  -5.048  1.00 12.91           C  
ATOM    918  CG1 ILE A 121      -0.005 -16.592  -4.009  1.00 13.83           C  
ATOM    919  CG2 ILE A 121       1.983 -18.109  -4.370  1.00 12.02           C  
ATOM    920  CD1 ILE A 121      -0.862 -17.442  -3.064  1.00 14.31           C  
ATOM    921  N   THR A 122       3.518 -16.846  -7.079  1.00 12.88           N  
ATOM    922  CA  THR A 122       4.531 -17.555  -7.830  1.00 12.41           C  
ATOM    923  C   THR A 122       5.357 -18.495  -6.936  1.00 12.38           C  
ATOM    924  O   THR A 122       5.945 -19.435  -7.415  1.00 13.97           O  
ATOM    925  CB  THR A 122       5.502 -16.598  -8.599  1.00 17.09           C  
ATOM    926  OG1 THR A 122       6.232 -15.769  -7.659  1.00 15.62           O  
ATOM    927  CG2 THR A 122       4.686 -15.702  -9.554  1.00 19.53           C  
ATOM    928  N   ASN A 123       5.453 -18.175  -5.658  1.00 13.37           N  
ATOM    929  CA  ASN A 123       6.286 -18.990  -4.757  1.00 12.35           C  
ATOM    930  C   ASN A 123       5.675 -18.954  -3.389  1.00 12.96           C  
ATOM    931  O   ASN A 123       5.320 -17.885  -2.911  1.00 11.81           O  
ATOM    932  CB  ASN A 123       7.705 -18.381  -4.642  1.00 13.35           C  
ATOM    933  CG  ASN A 123       8.425 -18.373  -5.942  1.00 17.05           C  
ATOM    934  OD1 ASN A 123       9.076 -19.365  -6.310  1.00 19.40           O  
ATOM    935  ND2 ASN A 123       8.292 -17.282  -6.682  1.00 10.58           N  
ATOM    936  N   MET A 124       5.508 -20.124  -2.773  1.00 10.98           N  
ATOM    937  CA  MET A 124       5.242 -20.186  -1.342  1.00 12.27           C  
ATOM    938  C   MET A 124       6.278 -21.153  -0.780  1.00 12.79           C  
ATOM    939  O   MET A 124       6.402 -22.279  -1.268  1.00 10.83           O  
ATOM    940  CB  MET A 124       3.821 -20.666  -1.015  1.00 12.89           C  
ATOM    941  CG  MET A 124       3.511 -20.649   0.483  0.35 18.22           C  
ATOM    943  SD  MET A 124       3.961 -22.165   1.357  0.35 34.40           S  
ATOM    945  CE  MET A 124       2.522 -23.182   1.059  0.35 11.13           C  
ATOM    947  N   ARG A 125       7.016 -20.710   0.227  1.00  9.68           N  
ATOM    948  CA  ARG A 125       8.175 -21.503   0.722  1.00  8.66           C  
ATOM    949  C   ARG A 125       8.101 -21.560   2.236  1.00  9.29           C  
ATOM    950  O   ARG A 125       7.924 -20.526   2.940  1.00 11.47           O  
ATOM    951  CB  ARG A 125       9.516 -20.882   0.316  1.00  8.70           C  
ATOM    952  CG  ARG A 125       9.508 -20.455  -1.187  1.00  9.91           C  
ATOM    953  CD  ARG A 125      10.889 -19.984  -1.633  1.00 15.53           C  
ATOM    954  NE  ARG A 125      11.768 -21.137  -1.866  1.00 12.63           N  
ATOM    955  CZ  ARG A 125      12.991 -21.264  -1.359  1.00 15.05           C  
ATOM    956  NH1 ARG A 125      13.513 -20.273  -0.623  1.00 13.28           N  
ATOM    957  NH2 ARG A 125      13.719 -22.356  -1.647  1.00 15.36           N  
ATOM    958  N   GLY A 126       8.185 -22.785   2.761  1.00  9.28           N  
ATOM    959  CA  GLY A 126       8.097 -22.976   4.222  1.00  8.07           C  
ATOM    960  C   GLY A 126       9.400 -23.436   4.898  1.00 10.17           C  
ATOM    961  O   GLY A 126      10.100 -24.346   4.388  1.00 10.72           O  
ATOM    962  N   TYR A 127       9.711 -22.804   6.031  1.00  8.58           N  
ATOM    963  CA  TYR A 127      10.907 -23.129   6.833  1.00  9.27           C  
ATOM    964  C   TYR A 127      10.444 -23.955   8.010  1.00  7.62           C  
ATOM    965  O   TYR A 127      10.134 -23.454   9.095  1.00 10.03           O  
ATOM    966  CB  TYR A 127      11.647 -21.840   7.285  1.00 10.92           C  
ATOM    967  CG  TYR A 127      12.233 -21.126   6.117  1.00  9.34           C  
ATOM    968  CD1 TYR A 127      13.622 -21.262   5.805  1.00  8.59           C  
ATOM    969  CD2 TYR A 127      11.434 -20.244   5.311  1.00  8.54           C  
ATOM    970  CE1 TYR A 127      14.191 -20.599   4.688  1.00  8.56           C  
ATOM    971  CE2 TYR A 127      12.019 -19.563   4.208  1.00 10.79           C  
ATOM    972  CZ  TYR A 127      13.366 -19.746   3.885  1.00 11.90           C  
ATOM    973  OH  TYR A 127      13.884 -19.068   2.793  1.00 11.10           O  
ATOM    974  N   TRP A 128      10.374 -25.275   7.752  1.00  9.34           N  
ATOM    975  CA  TRP A 128      10.155 -26.244   8.823  1.00 10.51           C  
ATOM    976  C   TRP A 128      10.608 -27.625   8.358  1.00  9.61           C  
ATOM    977  O   TRP A 128      10.943 -27.835   7.193  1.00  9.70           O  
ATOM    978  CB  TRP A 128       8.682 -26.292   9.269  1.00 10.91           C  
ATOM    979  CG  TRP A 128       7.711 -26.711   8.162  1.00 10.89           C  
ATOM    980  CD1 TRP A 128       7.158 -25.893   7.205  1.00 12.42           C  
ATOM    981  CD2 TRP A 128       7.169 -28.030   7.926  1.00 12.97           C  
ATOM    982  NE1 TRP A 128       6.329 -26.631   6.370  1.00 14.53           N  
ATOM    983  CE2 TRP A 128       6.305 -27.935   6.805  1.00 14.71           C  
ATOM    984  CE3 TRP A 128       7.333 -29.284   8.554  1.00 16.42           C  
ATOM    985  CZ2 TRP A 128       5.604 -29.054   6.287  1.00 13.27           C  
ATOM    986  CZ3 TRP A 128       6.627 -30.381   8.049  1.00 13.62           C  
ATOM    987  CH2 TRP A 128       5.777 -30.259   6.933  1.00 14.16           C  
ATOM    988  N   ASN A 129      10.628 -28.551   9.322  1.00 10.79           N  
ATOM    989  CA  ASN A 129      10.955 -29.949   9.014  1.00 10.21           C  
ATOM    990  C   ASN A 129      10.226 -30.869   9.998  1.00  9.01           C  
ATOM    991  O   ASN A 129       9.627 -30.410  10.998  1.00 11.11           O  
ATOM    992  CB  ASN A 129      12.478 -30.140   8.975  1.00 10.66           C  
ATOM    993  CG  ASN A 129      13.144 -29.915  10.341  1.00 14.61           C  
ATOM    994  OD1 ASN A 129      12.700 -30.455  11.369  1.00 14.26           O  
ATOM    995  ND2 ASN A 129      14.184 -29.102  10.356  1.00 13.08           N  
ATOM    996  N   LEU A 130      10.237 -32.175   9.653  1.00 10.81           N  
ATOM    997  CA  LEU A 130       9.479 -33.138  10.418  1.00 12.08           C  
ATOM    998  C   LEU A 130       9.918 -33.156  11.883  1.00  9.82           C  
ATOM    999  O   LEU A 130       9.078 -33.378  12.789  1.00 13.29           O  
ATOM   1000  CB  LEU A 130       9.630 -34.511   9.762  1.00 12.47           C  
ATOM   1001  CG  LEU A 130       8.986 -34.678   8.367  1.00 14.46           C  
ATOM   1002  CD1 LEU A 130       9.588 -35.915   7.617  1.00 19.87           C  
ATOM   1003  CD2 LEU A 130       7.491 -34.827   8.560  1.00 14.75           C  
ATOM   1004  N   ASP A 131      11.210 -32.913  12.116  1.00 11.61           N  
ATOM   1005  CA  ASP A 131      11.716 -32.868  13.502  1.00 12.13           C  
ATOM   1006  C   ASP A 131      11.100 -31.728  14.368  1.00 12.91           C  
ATOM   1007  O   ASP A 131      11.161 -31.782  15.598  1.00 16.85           O  
ATOM   1008  CB  ASP A 131      13.233 -32.787  13.533  1.00 15.40           C  
ATOM   1009  CG  ASP A 131      13.890 -34.088  13.091  1.00 20.25           C  
ATOM   1010  OD1 ASP A 131      13.433 -35.156  13.530  1.00 24.57           O  
ATOM   1011  OD2 ASP A 131      14.879 -34.038  12.359  1.00 28.12           O  
ATOM   1012  N   MET A 132      10.559 -30.677  13.730  1.00 11.72           N  
ATOM   1013  CA  MET A 132       9.901 -29.589  14.446  1.00 15.23           C  
ATOM   1014  C   MET A 132       8.454 -29.849  14.821  1.00 15.65           C  
ATOM   1015  O   MET A 132       7.865 -29.114  15.611  1.00 14.48           O  
ATOM   1016  CB  MET A 132      10.006 -28.303  13.611  1.00 13.15           C  
ATOM   1017  CG  MET A 132      11.460 -27.937  13.368  1.00 13.91           C  
ATOM   1018  SD  MET A 132      11.780 -26.723  12.050  1.00 14.76           S  
ATOM   1019  CE  MET A 132      10.776 -25.338  12.536  1.00 17.52           C  
ATOM   1020  N   MET A 133       7.870 -30.895  14.245  1.00 11.99           N  
ATOM   1021  CA  MET A 133       6.465 -31.184  14.516  1.00 12.74           C  
ATOM   1022  C   MET A 133       6.217 -31.661  15.925  1.00 15.23           C  
ATOM   1023  O   MET A 133       7.088 -32.307  16.522  1.00 15.84           O  
ATOM   1024  CB  MET A 133       5.932 -32.196  13.527  1.00 13.63           C  
ATOM   1025  CG  MET A 133       6.173 -31.834  12.073  1.00 20.64           C  
ATOM   1026  SD  MET A 133       4.763 -32.360  11.141  0.40 26.03           S  
ATOM   1028  CE  MET A 133       4.629 -33.986  11.799  0.40  2.00           C  
ATOM   1030  N   THR A 134       5.066 -31.283  16.475  1.00 15.30           N  
ATOM   1031  CA  THR A 134       4.601 -31.802  17.762  1.00 17.65           C  
ATOM   1032  C   THR A 134       3.331 -32.589  17.552  1.00 20.27           C  
ATOM   1033  O   THR A 134       2.607 -32.373  16.561  1.00 16.10           O  
ATOM   1034  CB  THR A 134       4.395 -30.694  18.803  1.00 19.47           C  
ATOM   1035  OG1 THR A 134       3.469 -29.737  18.283  1.00 22.08           O  
ATOM   1036  CG2 THR A 134       5.724 -29.995  19.082  1.00 21.20           C  
ATOM   1037  N   PHE A 135       3.059 -33.543  18.448  1.00 15.70           N  
ATOM   1038  CA  PHE A 135       1.965 -34.484  18.199  1.00 16.35           C  
ATOM   1039  C   PHE A 135       0.827 -34.512  19.222  1.00 22.85           C  
ATOM   1040  O   PHE A 135       1.028 -34.140  20.356  1.00 25.92           O  
ATOM   1041  CB  PHE A 135       2.543 -35.906  18.038  1.00 16.25           C  
ATOM   1042  CG  PHE A 135       3.404 -36.072  16.819  1.00 13.65           C  
ATOM   1043  CD1 PHE A 135       2.849 -36.437  15.589  1.00 15.55           C  
ATOM   1044  CD2 PHE A 135       4.766 -35.865  16.901  1.00 11.46           C  
ATOM   1045  CE1 PHE A 135       3.675 -36.601  14.449  1.00 17.20           C  
ATOM   1046  CE2 PHE A 135       5.602 -35.992  15.782  1.00 15.26           C  
ATOM   1047  CZ  PHE A 135       5.061 -36.379  14.555  1.00 15.27           C  
ATOM   1048  N   GLY A 136      -0.345 -35.010  18.800  1.00 25.73           N  
ATOM   1049  CA  GLY A 136      -1.502 -35.170  19.670  1.00 30.60           C  
ATOM   1050  C   GLY A 136      -2.420 -36.362  19.398  1.00 28.48           C  
ATOM   1051  O   GLY A 136      -2.303 -37.062  18.368  1.00 24.77           O  
ATOM   1052  N   ASN A 137      -3.349 -36.535  20.343  1.00 30.80           N  
ATOM   1053  CA  ASN A 137      -4.140 -37.764  20.603  1.00 40.93           C  
ATOM   1054  C   ASN A 137      -3.396 -38.846  21.416  1.00 33.13           C  
ATOM   1055  O   ASN A 137      -2.486 -39.494  20.893  1.00 29.10           O  
ATOM   1056  CB  ASN A 137      -4.756 -38.341  19.327  1.00 46.24           C  
ATOM   1057  CG  ASN A 137      -6.005 -37.606  18.911  1.00 50.88           C  
ATOM   1058  OD1 ASN A 137      -6.075 -36.375  19.007  1.00 54.12           O  
ATOM   1059  ND2 ASN A 137      -7.009 -38.353  18.456  1.00 62.86           N  
TER    1060      ASN A 137                                                      
END
MOLECULE T0475.pdb
ATOM     20  N   ASN     2       1.831  -2.392  -0.522  1.00  0.00
ATOM     21  HN  ASN     2       1.726  -2.331   0.453  1.00  0.00
ATOM     22  CA  ASN     2       2.075  -3.725  -1.109  1.00  0.00
ATOM     23  HA  ASN     2       2.284  -3.607  -2.174  1.00  0.00
ATOM     24  CB  ASN     2       3.299  -4.390  -0.422  1.00  0.00
ATOM     25  HB1 ASN     2       3.466  -5.372  -0.859  1.00  0.00
ATOM     26  HB2 ASN     2       3.089  -4.514   0.636  1.00  0.00
ATOM     27  CG  ASN     2       4.590  -3.576  -0.565  1.00  0.00
ATOM     28  OD1 ASN     2       5.324  -3.715  -1.546  1.00  0.00
ATOM     29  ND2 ASN     2       4.857  -2.700   0.401  1.00  0.00
ATOM     30 HD21 ASN     2       4.224  -2.628   1.148  1.00  0.00
ATOM     31 HD22 ASN     2       5.675  -2.167   0.331  1.00  0.00
ATOM     32  C   ASN     2       0.785  -4.553  -0.964  1.00  0.00
ATOM     33  O   ASN     2       0.810  -5.738  -0.618  1.00  0.00
ATOM     34  N   SER     3      -0.341  -3.891  -1.292  1.00  0.00
ATOM     35  HN  SER     3      -0.247  -3.002  -1.689  1.00  0.00
ATOM     36  CA  SER     3      -1.702  -4.409  -1.095  1.00  0.00
ATOM     37  HA  SER     3      -1.797  -4.700  -0.049  1.00  0.00
ATOM     38  CB  SER     3      -2.716  -3.279  -1.383  1.00  0.00
ATOM     39  HB1 SER     3      -2.599  -2.492  -0.645  1.00  0.00
ATOM     40  HB2 SER     3      -3.729  -3.660  -1.328  1.00  0.00
ATOM     41  OG  SER     3      -2.512  -2.719  -2.675  1.00  0.00
ATOM     42  HG  SER     3      -3.361  -2.595  -3.107  1.00  0.00
ATOM     43  C   SER     3      -1.979  -5.633  -1.981  1.00  0.00
ATOM     44  O   SER     3      -2.523  -6.626  -1.511  1.00  0.00
ATOM     45  N   GLU     4      -1.554  -5.549  -3.257  1.00  0.00
ATOM     46  HN  GLU     4      -1.122  -4.715  -3.539  1.00  0.00
ATOM     47  CA  GLU     4      -1.720  -6.638  -4.252  1.00  0.00
ATOM     48  HA  GLU     4      -2.760  -6.955  -4.203  1.00  0.00
ATOM     49  CB  GLU     4      -1.434  -6.132  -5.697  1.00  0.00
ATOM     50  HB1 GLU     4      -2.105  -5.307  -5.907  1.00  0.00
ATOM     51  HB2 GLU     4      -1.659  -6.934  -6.393  1.00  0.00
ATOM     52  CG  GLU     4       0.018  -5.661  -5.984  1.00  0.00
ATOM     53  HG1 GLU     4       0.166  -5.630  -7.063  1.00  0.00
ATOM     54  HG2 GLU     4       0.703  -6.396  -5.571  1.00  0.00
ATOM     55  CD  GLU     4       0.366  -4.277  -5.399  1.00  0.00
ATOM     56  OE1 GLU     4       0.009  -3.255  -6.022  1.00  0.00
ATOM     57  OE2 GLU     4       0.991  -4.208  -4.319  1.00  0.00
ATOM     58  C   GLU     4      -0.837  -7.869  -3.943  1.00  0.00
ATOM     59  O   GLU     4      -0.931  -8.886  -4.637  1.00  0.00
ATOM     60  N   ILE     5       0.041  -7.744  -2.937  1.00  0.00
ATOM     61  HN  ILE     5       0.146  -6.866  -2.519  1.00  0.00
ATOM     62  CA  ILE     5       0.867  -8.854  -2.432  1.00  0.00
ATOM     63  HA  ILE     5       0.966  -9.608  -3.214  1.00  0.00
ATOM     64  CB  ILE     5       2.303  -8.347  -2.025  1.00  0.00
ATOM     65  HB  ILE     5       2.196  -7.811  -1.085  1.00  0.00
ATOM     66  CG1 ILE     5       2.896  -7.353  -3.082  1.00  0.00
ATOM     67 HG11 ILE     5       3.865  -7.007  -2.738  1.00  0.00
ATOM     68 HG12 ILE     5       2.244  -6.502  -3.163  1.00  0.00
ATOM     69  CG2 ILE     5       3.271  -9.523  -1.775  1.00  0.00
ATOM     70 HG21 ILE     5       4.228  -9.142  -1.435  1.00  0.00
ATOM     71 HG22 ILE     5       3.417 -10.078  -2.691  1.00  0.00
ATOM     72 HG23 ILE     5       2.862 -10.182  -1.021  1.00  0.00
ATOM     73  CD1 ILE     5       3.082  -7.904  -4.488  1.00  0.00
ATOM     74 HD11 ILE     5       2.126  -8.218  -4.887  1.00  0.00
ATOM     75 HD12 ILE     5       3.755  -8.751  -4.459  1.00  0.00
ATOM     76 HD13 ILE     5       3.501  -7.137  -5.121  1.00  0.00
ATOM     77  C   ILE     5       0.167  -9.486  -1.207  1.00  0.00
ATOM     78  O   ILE     5       0.309 -10.683  -0.936  1.00  0.00
ATOM     79  N   GLU     6      -0.598  -8.649  -0.477  1.00  0.00
ATOM     80  HN  GLU     6      -0.624  -7.699  -0.730  1.00  0.00
ATOM     81  CA  GLU     6      -1.393  -9.075   0.691  1.00  0.00
ATOM     82  HA  GLU     6      -0.790  -9.767   1.280  1.00  0.00
ATOM     83  CB  GLU     6      -1.739  -7.844   1.574  1.00  0.00
ATOM     84  HB1 GLU     6      -2.373  -8.164   2.398  1.00  0.00
ATOM     85  HB2 GLU     6      -2.291  -7.131   0.971  1.00  0.00
ATOM     86  CG  GLU     6      -0.519  -7.120   2.167  1.00  0.00
ATOM     87  HG1 GLU     6       0.145  -6.834   1.353  1.00  0.00
ATOM     88  HG2 GLU     6       0.011  -7.810   2.816  1.00  0.00
ATOM     89  CD  GLU     6      -0.894  -5.858   2.968  1.00  0.00
ATOM     90  OE1 GLU     6      -1.011  -5.932   4.215  1.00  0.00
ATOM     91  OE2 GLU     6      -1.101  -4.793   2.350  1.00  0.00
ATOM     92  C   GLU     6      -2.691  -9.790   0.261  1.00  0.00
ATOM     93  O   GLU     6      -3.153 -10.698   0.961  1.00  0.00
ATOM     94  N   LEU     7      -3.271  -9.367  -0.887  1.00  0.00
ATOM     95  HN  LEU     7      -2.808  -8.685  -1.417  1.00  0.00
ATOM     96  CA  LEU     7      -4.562  -9.911  -1.391  1.00  0.00
ATOM     97  HA  LEU     7      -5.292  -9.732  -0.607  1.00  0.00
ATOM     98  CB  LEU     7      -5.054  -9.182  -2.681  1.00  0.00
ATOM     99  HB1 LEU     7      -5.975  -9.663  -3.009  1.00  0.00
ATOM    100  HB2 LEU     7      -4.310  -9.334  -3.456  1.00  0.00
ATOM    101  CG  LEU     7      -5.325  -7.651  -2.562  1.00  0.00
ATOM    102  HG  LEU     7      -4.402  -7.168  -2.287  1.00  0.00
ATOM    103  CD1 LEU     7      -5.756  -7.043  -3.913  1.00  0.00
ATOM    104 HD11 LEU     7      -6.661  -7.526  -4.269  1.00  0.00
ATOM    105 HD12 LEU     7      -4.968  -7.181  -4.640  1.00  0.00
ATOM    106 HD13 LEU     7      -5.941  -5.982  -3.792  1.00  0.00
ATOM    107  CD2 LEU     7      -6.353  -7.346  -1.453  1.00  0.00
ATOM    108 HD21 LEU     7      -5.982  -7.713  -0.505  1.00  0.00
ATOM    109 HD22 LEU     7      -7.295  -7.830  -1.678  1.00  0.00
ATOM    110 HD23 LEU     7      -6.509  -6.276  -1.383  1.00  0.00
ATOM    111  C   LEU     7      -4.504 -11.450  -1.632  1.00  0.00
ATOM    112  O   LEU     7      -5.411 -12.157  -1.175  1.00  0.00
ATOM    113  N   PRO     8      -3.462 -12.011  -2.364  1.00  0.00
ATOM    114  CA  PRO     8      -3.309 -13.478  -2.527  1.00  0.00
ATOM    115  HA  PRO     8      -4.145 -13.893  -3.088  1.00  0.00
ATOM    116  CB  PRO     8      -1.994 -13.649  -3.366  1.00  0.00
ATOM    117  HB1 PRO     8      -2.245 -13.908  -4.388  1.00  0.00
ATOM    118  HB2 PRO     8      -1.376 -14.442  -2.953  1.00  0.00
ATOM    119  CG  PRO     8      -1.308 -12.325  -3.298  1.00  0.00
ATOM    120  HG1 PRO     8      -0.750 -12.142  -4.212  1.00  0.00
ATOM    121  HG2 PRO     8      -0.632 -12.298  -2.447  1.00  0.00
ATOM    122  CD  PRO     8      -2.402 -11.297  -3.131  1.00  0.00
ATOM    123  HD1 PRO     8      -2.780 -10.972  -4.098  1.00  0.00
ATOM    124  HD2 PRO     8      -2.035 -10.447  -2.573  1.00  0.00
ATOM    125  C   PRO     8      -3.231 -14.208  -1.181  1.00  0.00
ATOM    126  O   PRO     8      -4.115 -14.994  -0.842  1.00  0.00
ATOM    127  N   VAL     9      -2.209 -13.860  -0.401  1.00  0.00
ATOM    128  HN  VAL     9      -1.703 -13.049  -0.636  1.00  0.00
ATOM    129  CA  VAL     9      -1.812 -14.612   0.800  1.00  0.00
ATOM    130  HA  VAL     9      -1.660 -15.641   0.491  1.00  0.00
ATOM    131  CB  VAL     9      -0.455 -14.070   1.348  1.00  0.00
ATOM    132  HB  VAL     9      -0.147 -14.712   2.173  1.00  0.00
ATOM    133  CG1 VAL     9       0.641 -14.156   0.254  1.00  0.00
ATOM    134 HG11 VAL     9       0.368 -13.532  -0.588  1.00  0.00
ATOM    135 HG12 VAL     9       0.746 -15.182  -0.082  1.00  0.00
ATOM    136 HG13 VAL     9       1.587 -13.820   0.657  1.00  0.00
ATOM    137  CG2 VAL     9      -0.593 -12.627   1.896  1.00  0.00
ATOM    138 HG21 VAL     9      -0.958 -11.972   1.115  1.00  0.00
ATOM    139 HG22 VAL     9       0.366 -12.271   2.239  1.00  0.00
ATOM    140 HG23 VAL     9      -1.292 -12.614   2.725  1.00  0.00
ATOM    141  C   VAL     9      -2.901 -14.601   1.905  1.00  0.00
ATOM    142  O   VAL     9      -3.020 -15.564   2.666  1.00  0.00
ATOM    143  N   GLN    10      -3.705 -13.515   1.950  1.00  0.00
ATOM    144  HN  GLN    10      -3.532 -12.787   1.318  1.00  0.00
ATOM    145  CA  GLN    10      -4.839 -13.376   2.888  1.00  0.00
ATOM    146  HA  GLN    10      -4.480 -13.600   3.893  1.00  0.00
ATOM    147  CB  GLN    10      -5.375 -11.914   2.859  1.00  0.00
ATOM    148  HB1 GLN    10      -5.608 -11.659   1.829  1.00  0.00
ATOM    149  HB2 GLN    10      -4.587 -11.252   3.197  1.00  0.00
ATOM    150  CG  GLN    10      -6.630 -11.627   3.718  1.00  0.00
ATOM    151  HG1 GLN    10      -7.444 -12.248   3.358  1.00  0.00
ATOM    152  HG2 GLN    10      -6.905 -10.587   3.587  1.00  0.00
ATOM    153  CD  GLN    10      -6.435 -11.892   5.211  1.00  0.00
ATOM    154  OE1 GLN    10      -6.001 -11.016   5.954  1.00  0.00
ATOM    155  NE2 GLN    10      -6.762 -13.097   5.655  1.00  0.00
ATOM    156 HE21 GLN    10      -7.111 -13.751   5.008  1.00  0.00
ATOM    157 HE22 GLN    10      -6.644 -13.289   6.609  1.00  0.00
ATOM    158  C   GLN    10      -5.951 -14.368   2.514  1.00  0.00
ATOM    159  O   GLN    10      -6.354 -15.200   3.335  1.00  0.00
ATOM    160  N   LYS    11      -6.395 -14.286   1.244  1.00  0.00
ATOM    161  HN  LYS    11      -5.949 -13.656   0.636  1.00  0.00
ATOM    162  CA  LYS    11      -7.508 -15.103   0.710  1.00  0.00
ATOM    163  HA  LYS    11      -8.378 -14.924   1.338  1.00  0.00
ATOM    164  CB  LYS    11      -7.846 -14.648  -0.732  1.00  0.00
ATOM    165  HB1 LYS    11      -8.562 -15.342  -1.167  1.00  0.00
ATOM    166  HB2 LYS    11      -6.938 -14.674  -1.329  1.00  0.00
ATOM    167  CG  LYS    11      -8.439 -13.225  -0.830  1.00  0.00
ATOM    168  HG1 LYS    11      -8.591 -12.983  -1.878  1.00  0.00
ATOM    169  HG2 LYS    11      -7.731 -12.521  -0.403  1.00  0.00
ATOM    170  CD  LYS    11      -9.782 -13.097  -0.085  1.00  0.00
ATOM    171  HD1 LYS    11      -9.626 -13.325   0.969  1.00  0.00
ATOM    172  HD2 LYS    11     -10.482 -13.816  -0.497  1.00  0.00
ATOM    173  CE  LYS    11     -10.403 -11.699  -0.200  1.00  0.00
ATOM    174  HE1 LYS    11     -10.562 -11.460  -1.242  1.00  0.00
ATOM    175  HE2 LYS    11      -9.730 -10.971   0.239  1.00  0.00
ATOM    176  NZ  LYS    11     -11.702 -11.633   0.510  1.00  0.00
ATOM    177  HZ1 LYS    11     -12.109 -10.686   0.416  1.00  0.00
ATOM    178  HZ2 LYS    11     -11.567 -11.843   1.519  1.00  0.00
ATOM    179  HZ3 LYS    11     -12.367 -12.326   0.112  1.00  0.00
ATOM    180  C   LYS    11      -7.180 -16.603   0.734  1.00  0.00
ATOM    181  O   LYS    11      -8.057 -17.429   0.977  1.00  0.00
ATOM    182  N   GLN    12      -5.904 -16.925   0.497  1.00  0.00
ATOM    183  HN  GLN    12      -5.262 -16.197   0.364  1.00  0.00
ATOM    184  CA  GLN    12      -5.412 -18.308   0.438  1.00  0.00
ATOM    185  HA  GLN    12      -6.116 -18.882  -0.161  1.00  0.00
ATOM    186  CB  GLN    12      -4.038 -18.347  -0.253  1.00  0.00
ATOM    187  HB1 GLN    12      -3.615 -19.342  -0.140  1.00  0.00
ATOM    188  HB2 GLN    12      -3.378 -17.634   0.241  1.00  0.00
ATOM    189  CG  GLN    12      -4.076 -18.013  -1.754  1.00  0.00
ATOM    190  HG1 GLN    12      -4.619 -17.084  -1.892  1.00  0.00
ATOM    191  HG2 GLN    12      -4.592 -18.806  -2.280  1.00  0.00
ATOM    192  CD  GLN    12      -2.692 -17.850  -2.370  1.00  0.00
ATOM    193  OE1 GLN    12      -2.513 -17.092  -3.318  1.00  0.00
ATOM    194  NE2 GLN    12      -1.704 -18.584  -1.862  1.00  0.00
ATOM    195 HE21 GLN    12      -1.901 -19.190  -1.120  1.00  0.00
ATOM    196 HE22 GLN    12      -0.821 -18.502  -2.263  1.00  0.00
ATOM    197  C   GLN    12      -5.310 -18.928   1.840  1.00  0.00
ATOM    198  O   GLN    12      -5.658 -20.085   2.024  1.00  0.00
ATOM    199  N   LEU    13      -4.802 -18.148   2.810  1.00  0.00
ATOM    200  HN  LEU    13      -4.515 -17.235   2.577  1.00  0.00
ATOM    201  CA  LEU    13      -4.660 -18.600   4.211  1.00  0.00
ATOM    202  HA  LEU    13      -4.023 -19.485   4.218  1.00  0.00
ATOM    203  CB  LEU    13      -4.000 -17.499   5.062  1.00  0.00
ATOM    204  HB1 LEU    13      -4.586 -16.593   4.943  1.00  0.00
ATOM    205  HB2 LEU    13      -3.007 -17.308   4.661  1.00  0.00
ATOM    206  CG  LEU    13      -3.869 -17.811   6.587  1.00  0.00
ATOM    207  HG  LEU    13      -4.781 -18.277   6.921  1.00  0.00
ATOM    208  CD1 LEU    13      -2.741 -18.824   6.881  1.00  0.00
ATOM    209 HD11 LEU    13      -2.683 -19.003   7.947  1.00  0.00
ATOM    210 HD12 LEU    13      -1.792 -18.435   6.532  1.00  0.00
ATOM    211 HD13 LEU    13      -2.952 -19.760   6.376  1.00  0.00
ATOM    212  CD2 LEU    13      -3.726 -16.522   7.391  1.00  0.00
ATOM    213 HD21 LEU    13      -3.726 -16.755   8.445  1.00  0.00
ATOM    214 HD22 LEU    13      -4.561 -15.868   7.172  1.00  0.00
ATOM    215 HD23 LEU    13      -2.801 -16.024   7.132  1.00  0.00
ATOM    216  C   LEU    13      -6.039 -18.958   4.803  1.00  0.00
ATOM    217  O   LEU    13      -6.199 -20.004   5.451  1.00  0.00
ATOM    218  N   GLU    14      -7.012 -18.054   4.579  1.00  0.00
ATOM    219  HN  GLU    14      -6.762 -17.194   4.166  1.00  0.00
ATOM    220  CA  GLU    14      -8.427 -18.274   4.938  1.00  0.00
ATOM    221  HA  GLU    14      -8.482 -18.402   6.018  1.00  0.00
ATOM    222  CB  GLU    14      -9.279 -17.045   4.529  1.00  0.00
ATOM    223  HB1 GLU    14     -10.327 -17.249   4.740  1.00  0.00
ATOM    224  HB2 GLU    14      -9.167 -16.886   3.459  1.00  0.00
ATOM    225  CG  GLU    14      -8.896 -15.744   5.249  1.00  0.00
ATOM    226  HG1 GLU    14      -7.833 -15.558   5.093  1.00  0.00
ATOM    227  HG2 GLU    14      -9.070 -15.875   6.311  1.00  0.00
ATOM    228  CD  GLU    14      -9.693 -14.526   4.750  1.00  0.00
ATOM    229  OE1 GLU    14     -10.749 -14.201   5.342  1.00  0.00
ATOM    230  OE2 GLU    14      -9.272 -13.890   3.756  1.00  0.00
ATOM    231  C   GLU    14      -8.950 -19.548   4.253  1.00  0.00
ATOM    232  O   GLU    14      -9.468 -20.433   4.916  1.00  0.00
ATOM    233  N   ALA    15      -8.711 -19.634   2.933  1.00  0.00
ATOM    234  HN  ALA    15      -8.204 -18.905   2.512  1.00  0.00
ATOM    235  CA  ALA    15      -9.156 -20.758   2.076  1.00  0.00
ATOM    236  HA  ALA    15     -10.235 -20.852   2.189  1.00  0.00
ATOM    237  CB  ALA    15      -8.862 -20.438   0.601  1.00  0.00
ATOM    238  HB1 ALA    15      -7.792 -20.355   0.451  1.00  0.00
ATOM    239  HB2 ALA    15      -9.327 -19.499   0.328  1.00  0.00
ATOM    240  HB3 ALA    15      -9.255 -21.223  -0.034  1.00  0.00
ATOM    241  C   ALA    15      -8.495 -22.102   2.478  1.00  0.00
ATOM    242  O   ALA    15      -9.058 -23.168   2.217  1.00  0.00
ATOM    243  N   TYR    16      -7.294 -22.028   3.098  1.00  0.00
ATOM    244  HN  TYR    16      -6.919 -21.135   3.279  1.00  0.00
ATOM    245  CA  TYR    16      -6.514 -23.215   3.518  1.00  0.00
ATOM    246  HA  TYR    16      -6.377 -23.844   2.639  1.00  0.00
ATOM    247  CB  TYR    16      -5.116 -22.780   4.043  1.00  0.00
ATOM    248  HB1 TYR    16      -5.253 -22.145   4.912  1.00  0.00
ATOM    249  HB2 TYR    16      -4.621 -22.198   3.274  1.00  0.00
ATOM    250  CG  TYR    16      -4.166 -23.936   4.432  1.00  0.00
ATOM    251  CD1 TYR    16      -3.688 -24.087   5.742  1.00  0.00
ATOM    252  HD1 TYR    16      -3.991 -23.371   6.499  1.00  0.00
ATOM    253  CD2 TYR    16      -3.752 -24.875   3.481  1.00  0.00
ATOM    254  HD2 TYR    16      -4.105 -24.781   2.460  1.00  0.00
ATOM    255  CE1 TYR    16      -2.836 -25.128   6.080  1.00  0.00
ATOM    256  HE1 TYR    16      -2.482 -25.225   7.100  1.00  0.00
ATOM    257  CE2 TYR    16      -2.904 -25.913   3.816  1.00  0.00
ATOM    258  HE2 TYR    16      -2.602 -26.625   3.059  1.00  0.00
ATOM    259  CZ  TYR    16      -2.448 -26.037   5.113  1.00  0.00
ATOM    260  OH  TYR    16      -1.602 -27.080   5.440  1.00  0.00
ATOM    261  HH  TYR    16      -1.856 -27.442   6.292  1.00  0.00
ATOM    262  C   TYR    16      -7.276 -24.016   4.589  1.00  0.00
ATOM    263  O   TYR    16      -7.355 -25.252   4.525  1.00  0.00
ATOM    264  N   ASN    17      -7.845 -23.289   5.560  1.00  0.00
ATOM    265  HN  ASN    17      -7.732 -22.312   5.539  1.00  0.00
ATOM    266  CA  ASN    17      -8.637 -23.887   6.651  1.00  0.00
ATOM    267  HA  ASN    17      -8.283 -24.908   6.797  1.00  0.00
ATOM    268  CB  ASN    17      -8.405 -23.104   7.979  1.00  0.00
ATOM    269  HB1 ASN    17      -7.345 -23.123   8.218  1.00  0.00
ATOM    270  HB2 ASN    17      -8.938 -23.600   8.780  1.00  0.00
ATOM    271  CG  ASN    17      -8.859 -21.642   7.940  1.00  0.00
ATOM    272  OD1 ASN    17      -9.998 -21.326   8.280  1.00  0.00
ATOM    273  ND2 ASN    17      -7.969 -20.740   7.540  1.00  0.00
ATOM    274 HD21 ASN    17      -7.069 -21.047   7.289  1.00  0.00
ATOM    275 HD22 ASN    17      -8.244 -19.800   7.514  1.00  0.00
ATOM    276  C   ASN    17     -10.139 -23.952   6.270  1.00  0.00
ATOM    277  O   ASN    17     -10.847 -24.858   6.711  1.00  0.00
ATOM    278  N   ALA    18     -10.592 -23.015   5.405  1.00  0.00
ATOM    279  HN  ALA    18      -9.945 -22.382   5.033  1.00  0.00
ATOM    280  CA  ALA    18     -12.017 -22.899   4.977  1.00  0.00
ATOM    281  HA  ALA    18     -12.645 -23.109   5.841  1.00  0.00
ATOM    282  CB  ALA    18     -12.330 -21.469   4.502  1.00  0.00
ATOM    283  HB1 ALA    18     -12.057 -20.761   5.270  1.00  0.00
ATOM    284  HB2 ALA    18     -13.389 -21.372   4.287  1.00  0.00
ATOM    285  HB3 ALA    18     -11.764 -21.251   3.601  1.00  0.00
ATOM    286  C   ALA    18     -12.372 -23.904   3.864  1.00  0.00
ATOM    287  O   ALA    18     -13.549 -24.058   3.525  1.00  0.00
ATOM    288  N   ARG    19     -11.335 -24.564   3.304  1.00  0.00
ATOM    289  HN  ARG    19     -10.428 -24.285   3.558  1.00  0.00
ATOM    290  CA  ARG    19     -11.463 -25.664   2.322  1.00  0.00
ATOM    291  HA  ARG    19     -10.461 -26.039   2.155  1.00  0.00
ATOM    292  CB  ARG    19     -12.324 -26.837   2.881  1.00  0.00
ATOM    293  HB1 ARG    19     -12.258 -27.674   2.191  1.00  0.00
ATOM    294  HB2 ARG    19     -13.358 -26.514   2.925  1.00  0.00
ATOM    295  CG  ARG    19     -11.926 -27.336   4.286  1.00  0.00
ATOM    296  HG1 ARG    19     -12.522 -28.212   4.517  1.00  0.00
ATOM    297  HG2 ARG    19     -12.152 -26.559   5.010  1.00  0.00
ATOM    298  CD  ARG    19     -10.443 -27.704   4.416  1.00  0.00
ATOM    299  HD1 ARG    19      -9.841 -26.820   4.237  1.00  0.00
ATOM    300  HD2 ARG    19     -10.192 -28.462   3.681  1.00  0.00
ATOM    301  NE  ARG    19     -10.151 -28.205   5.768  1.00  0.00
ATOM    302  HE  ARG    19      -9.995 -27.527   6.467  1.00  0.00
ATOM    303  CZ  ARG    19     -10.113 -29.498   6.120  1.00  0.00
ATOM    304  NH1 ARG    19     -10.315 -30.461   5.228  1.00  0.00
ATOM    305 HH11 ARG    19     -10.508 -30.236   4.271  1.00  0.00
ATOM    306 HH12 ARG    19     -10.261 -31.424   5.505  1.00  0.00
ATOM    307  NH2 ARG    19      -9.892 -29.827   7.378  1.00  0.00
ATOM    308 HH21 ARG    19      -9.761 -29.112   8.073  1.00  0.00
ATOM    309 HH22 ARG    19      -9.844 -30.791   7.648  1.00  0.00
ATOM    310  C   ARG    19     -11.996 -25.167   0.958  1.00  0.00
ATOM    311  O   ARG    19     -12.864 -25.800   0.338  1.00  0.00
ATOM    312  N   ASP    20     -11.443 -24.037   0.485  1.00  0.00
ATOM    313  HN  ASP    20     -10.788 -23.570   1.041  1.00  0.00
ATOM    314  CA  ASP    20     -11.769 -23.468  -0.838  1.00  0.00
ATOM    315  HA  ASP    20     -12.541 -24.077  -1.307  1.00  0.00
ATOM    316  CB  ASP    20     -12.309 -22.010  -0.689  1.00  0.00
ATOM    317  HB1 ASP    20     -12.380 -21.558  -1.674  1.00  0.00
ATOM    318  HB2 ASP    20     -11.601 -21.429  -0.100  1.00  0.00
ATOM    319  CG  ASP    20     -13.689 -21.930  -0.008  1.00  0.00
ATOM    320  OD1 ASP    20     -13.750 -21.843   1.238  1.00  0.00
ATOM    321  OD2 ASP    20     -14.720 -21.948  -0.721  1.00  0.00
ATOM    322  C   ASP    20     -10.514 -23.492  -1.734  1.00  0.00
ATOM    323  O   ASP    20      -9.717 -22.558  -1.696  1.00  0.00
ATOM    324  N   ILE    21     -10.357 -24.561  -2.547  1.00  0.00
ATOM    325  HN  ILE    21     -11.052 -25.252  -2.550  1.00  0.00
ATOM    326  CA  ILE    21      -9.181 -24.730  -3.438  1.00  0.00
ATOM    327  HA  ILE    21      -8.300 -24.483  -2.847  1.00  0.00
ATOM    328  CB  ILE    21      -9.016 -26.233  -3.930  1.00  0.00
ATOM    329  HB  ILE    21     -10.004 -26.599  -4.190  1.00  0.00
ATOM    330  CG1 ILE    21      -8.453 -27.132  -2.779  1.00  0.00
ATOM    331 HG11 ILE    21      -8.531 -28.173  -3.071  1.00  0.00
ATOM    332 HG12 ILE    21      -9.039 -26.979  -1.884  1.00  0.00
ATOM    333  CG2 ILE    21      -8.127 -26.369  -5.205  1.00  0.00
ATOM    334 HG21 ILE    21      -8.582 -25.828  -6.025  1.00  0.00
ATOM    335 HG22 ILE    21      -8.032 -27.412  -5.477  1.00  0.00
ATOM    336 HG23 ILE    21      -7.143 -25.959  -5.009  1.00  0.00
ATOM    337  CD1 ILE    21      -6.996 -26.864  -2.418  1.00  0.00
ATOM    338 HD11 ILE    21      -6.719 -27.483  -1.577  1.00  0.00
ATOM    339 HD12 ILE    21      -6.874 -25.824  -2.152  1.00  0.00
ATOM    340 HD13 ILE    21      -6.361 -27.100  -3.261  1.00  0.00
ATOM    341  C   ILE    21      -9.226 -23.742  -4.620  1.00  0.00
ATOM    342  O   ILE    21      -8.175 -23.315  -5.100  1.00  0.00
ATOM    343  N   ASP    22     -10.438 -23.351  -5.061  1.00  0.00
ATOM    344  HN  ASP    22     -11.243 -23.708  -4.615  1.00  0.00
ATOM    345  CA  ASP    22     -10.607 -22.411  -6.196  1.00  0.00
ATOM    346  HA  ASP    22     -10.117 -22.864  -7.058  1.00  0.00
ATOM    347  CB  ASP    22     -12.108 -22.225  -6.538  1.00  0.00
ATOM    348  HB1 ASP    22     -12.633 -21.874  -5.655  1.00  0.00
ATOM    349  HB2 ASP    22     -12.527 -23.188  -6.818  1.00  0.00
ATOM    350  CG  ASP    22     -12.355 -21.231  -7.695  1.00  0.00
ATOM    351  OD1 ASP    22     -12.735 -20.066  -7.435  1.00  0.00
ATOM    352  OD2 ASP    22     -12.135 -21.609  -8.867  1.00  0.00
ATOM    353  C   ASP    22      -9.928 -21.047  -5.907  1.00  0.00
ATOM    354  O   ASP    22      -9.220 -20.518  -6.762  1.00  0.00
ATOM    355  N   ALA    23     -10.136 -20.511  -4.691  1.00  0.00
ATOM    356  HN  ALA    23     -10.740 -20.975  -4.074  1.00  0.00
ATOM    357  CA  ALA    23      -9.486 -19.252  -4.239  1.00  0.00
ATOM    358  HA  ALA    23      -9.458 -18.561  -5.080  1.00  0.00
ATOM    359  CB  ALA    23     -10.297 -18.602  -3.105  1.00  0.00
ATOM    360  HB1 ALA    23      -9.839 -17.662  -2.810  1.00  0.00
ATOM    361  HB2 ALA    23     -10.332 -19.265  -2.252  1.00  0.00
ATOM    362  HB3 ALA    23     -11.309 -18.413  -3.447  1.00  0.00
ATOM    363  C   ALA    23      -8.040 -19.511  -3.791  1.00  0.00
ATOM    364  O   ALA    23      -7.160 -18.659  -3.967  1.00  0.00
ATOM    365  N   PHE    24      -7.810 -20.712  -3.236  1.00  0.00
ATOM    366  HN  PHE    24      -8.575 -21.307  -3.083  1.00  0.00
ATOM    367  CA  PHE    24      -6.473 -21.176  -2.830  1.00  0.00
ATOM    368  HA  PHE    24      -6.009 -20.382  -2.243  1.00  0.00
ATOM    369  CB  PHE    24      -6.615 -22.440  -1.934  1.00  0.00
ATOM    370  HB1 PHE    24      -6.963 -23.265  -2.547  1.00  0.00
ATOM    371  HB2 PHE    24      -7.362 -22.246  -1.173  1.00  0.00
ATOM    372  CG  PHE    24      -5.339 -22.878  -1.225  1.00  0.00
ATOM    373  CD1 PHE    24      -4.521 -23.871  -1.754  1.00  0.00
ATOM    374  HD1 PHE    24      -4.808 -24.367  -2.671  1.00  0.00
ATOM    375  CD2 PHE    24      -4.940 -22.263  -0.047  1.00  0.00
ATOM    376  HD2 PHE    24      -5.561 -21.491   0.389  1.00  0.00
ATOM    377  CE1 PHE    24      -3.356 -24.232  -1.120  1.00  0.00
ATOM    378  HE1 PHE    24      -2.732 -25.002  -1.545  1.00  0.00
ATOM    379  CE2 PHE    24      -3.775 -22.635   0.590  1.00  0.00
ATOM    380  HE2 PHE    24      -3.483 -22.147   1.511  1.00  0.00
ATOM    381  CZ  PHE    24      -2.979 -23.615   0.050  1.00  0.00
ATOM    382  HZ  PHE    24      -2.058 -23.904   0.544  1.00  0.00
ATOM    383  C   PHE    24      -5.585 -21.459  -4.071  1.00  0.00
ATOM    384  O   PHE    24      -4.392 -21.704  -3.933  1.00  0.00
ATOM    385  N   MET    25      -6.184 -21.461  -5.282  1.00  0.00
ATOM    386  HN  MET    25      -7.161 -21.385  -5.318  1.00  0.00
ATOM    387  CA  MET    25      -5.445 -21.605  -6.559  1.00  0.00
ATOM    388  HA  MET    25      -4.407 -21.823  -6.325  1.00  0.00
ATOM    389  CB  MET    25      -6.016 -22.776  -7.413  1.00  0.00
ATOM    390  HB1 MET    25      -7.067 -22.579  -7.602  1.00  0.00
ATOM    391  HB2 MET    25      -5.940 -23.689  -6.834  1.00  0.00
ATOM    392  CG  MET    25      -5.310 -23.025  -8.775  1.00  0.00
ATOM    393  HG1 MET    25      -5.016 -22.072  -9.200  1.00  0.00
ATOM    394  HG2 MET    25      -6.019 -23.489  -9.446  1.00  0.00
ATOM    395  SD  MET    25      -3.840 -24.101  -8.708  1.00  0.00
ATOM    396  CE  MET    25      -2.690 -23.286  -7.583  1.00  0.00
ATOM    397  HE1 MET    25      -1.756 -23.833  -7.570  1.00  0.00
ATOM    398  HE2 MET    25      -3.107 -23.276  -6.587  1.00  0.00
ATOM    399  HE3 MET    25      -2.510 -22.271  -7.910  1.00  0.00
ATOM    400  C   MET    25      -5.483 -20.303  -7.374  1.00  0.00
ATOM    401  O   MET    25      -4.536 -20.015  -8.120  1.00  0.00
ATOM    402  N   ALA    26      -6.576 -19.524  -7.206  1.00  0.00
ATOM    403  HN  ALA    26      -7.206 -19.764  -6.502  1.00  0.00
ATOM    404  CA  ALA    26      -6.870 -18.324  -8.030  1.00  0.00
ATOM    405  HA  ALA    26      -7.098 -18.668  -9.039  1.00  0.00
ATOM    406  CB  ALA    26      -8.111 -17.596  -7.486  1.00  0.00
ATOM    407  HB1 ALA    26      -8.955 -18.274  -7.463  1.00  0.00
ATOM    408  HB2 ALA    26      -8.354 -16.752  -8.122  1.00  0.00
ATOM    409  HB3 ALA    26      -7.918 -17.241  -6.478  1.00  0.00
ATOM    410  C   ALA    26      -5.690 -17.354  -8.081  1.00  0.00
ATOM    411  O   ALA    26      -5.165 -17.037  -9.147  1.00  0.00
ATOM    412  N   TRP    27      -5.237 -16.978  -6.894  1.00  0.00
ATOM    413  HN  TRP    27      -5.569 -17.449  -6.099  1.00  0.00
ATOM    414  CA  TRP    27      -4.272 -15.899  -6.699  1.00  0.00
ATOM    415  HA  TRP    27      -4.541 -15.083  -7.366  1.00  0.00
ATOM    416  CB  TRP    27      -4.404 -15.411  -5.253  1.00  0.00
ATOM    417  HB1 TRP    27      -3.650 -14.657  -5.074  1.00  0.00
ATOM    418  HB2 TRP    27      -4.223 -16.240  -4.578  1.00  0.00
ATOM    419  CG  TRP    27      -5.746 -14.806  -4.899  1.00  0.00
ATOM    420  CD1 TRP    27      -6.813 -15.425  -4.298  1.00  0.00
ATOM    421  HD1 TRP    27      -6.834 -16.466  -4.002  1.00  0.00
ATOM    422  CD2 TRP    27      -6.140 -13.442  -5.103  1.00  0.00
ATOM    423  NE1 TRP    27      -7.838 -14.529  -4.128  1.00  0.00
ATOM    424  HE1 TRP    27      -8.707 -14.731  -3.721  1.00  0.00
ATOM    425  CE2 TRP    27      -7.451 -13.309  -4.615  1.00  0.00
ATOM    426  CE3 TRP    27      -5.497 -12.321  -5.646  1.00  0.00
ATOM    427  HE3 TRP    27      -4.487 -12.389  -6.033  1.00  0.00
ATOM    428  CZ2 TRP    27      -8.137 -12.102  -4.667  1.00  0.00
ATOM    429  HZ2 TRP    27      -9.148 -12.004  -4.298  1.00  0.00
ATOM    430  CZ3 TRP    27      -6.182 -11.125  -5.699  1.00  0.00
ATOM    431  HZ3 TRP    27      -5.704 -10.246  -6.113  1.00  0.00
ATOM    432  CH2 TRP    27      -7.489 -11.021  -5.207  1.00  0.00
ATOM    433  HH2 TRP    27      -7.991 -10.060  -5.267  1.00  0.00
ATOM    434  C   TRP    27      -2.813 -16.314  -7.008  1.00  0.00
ATOM    435  O   TRP    27      -1.888 -15.520  -6.805  1.00  0.00
ATOM    436  N   TRP    28      -2.618 -17.549  -7.499  1.00  0.00
ATOM    437  HN  TRP    28      -3.388 -18.151  -7.573  1.00  0.00
ATOM    438  CA  TRP    28      -1.309 -18.047  -7.951  1.00  0.00
ATOM    439  HA  TRP    28      -0.524 -17.501  -7.429  1.00  0.00
ATOM    440  CB  TRP    28      -1.163 -19.564  -7.650  1.00  0.00
ATOM    441  HB1 TRP    28      -0.191 -19.902  -7.996  1.00  0.00
ATOM    442  HB2 TRP    28      -1.929 -20.106  -8.194  1.00  0.00
ATOM    443  CG  TRP    28      -1.297 -19.941  -6.191  1.00  0.00
ATOM    444  CD1 TRP    28      -2.412 -19.826  -5.411  1.00  0.00
ATOM    445  HD1 TRP    28      -3.365 -19.415  -5.743  1.00  0.00
ATOM    446  CD2 TRP    28      -0.291 -20.536  -5.349  1.00  0.00
ATOM    447  NE1 TRP    28      -2.155 -20.305  -4.159  1.00  0.00
ATOM    448  HE1 TRP    28      -2.801 -20.329  -3.422  1.00  0.00
ATOM    449  CE2 TRP    28      -0.869 -20.737  -4.089  1.00  0.00
ATOM    450  CE3 TRP    28       1.037 -20.908  -5.540  1.00  0.00
ATOM    451  HE3 TRP    28       1.520 -20.774  -6.499  1.00  0.00
ATOM    452  CZ2 TRP    28      -0.174 -21.298  -3.021  1.00  0.00
ATOM    453  HZ2 TRP    28      -0.632 -21.445  -2.052  1.00  0.00
ATOM    454  CZ3 TRP    28       1.731 -21.467  -4.485  1.00  0.00
ATOM    455  HZ3 TRP    28       2.764 -21.760  -4.617  1.00  0.00
ATOM    456  CH2 TRP    28       1.127 -21.653  -3.235  1.00  0.00
ATOM    457  HH2 TRP    28       1.710 -22.092  -2.434  1.00  0.00
ATOM    458  C   TRP    28      -1.162 -17.807  -9.463  1.00  0.00
ATOM    459  O   TRP    28      -2.148 -17.552 -10.168  1.00  0.00
ATOM    460  N   ALA    29       0.084 -17.865  -9.940  1.00  0.00
ATOM    461  HN  ALA    29       0.820 -17.910  -9.299  1.00  0.00
ATOM    462  CA  ALA    29       0.402 -17.858 -11.384  1.00  0.00
ATOM    463  HA  ALA    29      -0.268 -17.158 -11.880  1.00  0.00
ATOM    464  CB  ALA    29       1.851 -17.391 -11.618  1.00  0.00
ATOM    465  HB1 ALA    29       1.980 -16.392 -11.220  1.00  0.00
ATOM    466  HB2 ALA    29       2.066 -17.379 -12.680  1.00  0.00
ATOM    467  HB3 ALA    29       2.542 -18.065 -11.123  1.00  0.00
ATOM    468  C   ALA    29       0.186 -19.261 -11.971  1.00  0.00
ATOM    469  O   ALA    29       0.322 -20.257 -11.255  1.00  0.00
ATOM    470  N   ASP    30      -0.136 -19.337 -13.276  1.00  0.00
ATOM    471  HN  ASP    30      -0.232 -18.505 -13.787  1.00  0.00
ATOM    472  CA  ASP    30      -0.360 -20.632 -13.968  1.00  0.00
ATOM    473  HA  ASP    30      -1.069 -21.201 -13.371  1.00  0.00
ATOM    474  CB  ASP    30      -0.975 -20.409 -15.375  1.00  0.00
ATOM    475  HB1 ASP    30      -0.286 -19.812 -15.967  1.00  0.00
ATOM    476  HB2 ASP    30      -1.901 -19.854 -15.268  1.00  0.00
ATOM    477  CG  ASP    30      -1.287 -21.721 -16.139  1.00  0.00
ATOM    478  OD1 ASP    30      -0.682 -21.975 -17.205  1.00  0.00
ATOM    479  OD2 ASP    30      -2.136 -22.508 -15.671  1.00  0.00
ATOM    480  C   ASP    30       0.946 -21.444 -14.073  1.00  0.00
ATOM    481  O   ASP    30       0.921 -22.672 -14.123  1.00  0.00
ATOM    482  N   ASP    31       2.086 -20.743 -14.091  1.00  0.00
ATOM    483  HN  ASP    31       2.032 -19.765 -14.057  1.00  0.00
ATOM    484  CA  ASP    31       3.425 -21.361 -14.163  1.00  0.00
ATOM    485  HA  ASP    31       3.309 -22.413 -14.416  1.00  0.00
ATOM    486  CB  ASP    31       4.258 -20.668 -15.283  1.00  0.00
ATOM    487  HB1 ASP    31       3.670 -20.644 -16.196  1.00  0.00
ATOM    488  HB2 ASP    31       5.148 -21.261 -15.470  1.00  0.00
ATOM    489  CG  ASP    31       4.679 -19.220 -14.947  1.00  0.00
ATOM    490  OD1 ASP    31       5.893 -18.910 -14.968  1.00  0.00
ATOM    491  OD2 ASP    31       3.794 -18.390 -14.651  1.00  0.00
ATOM    492  C   ASP    31       4.145 -21.271 -12.798  1.00  0.00
ATOM    493  O   ASP    31       5.368 -21.436 -12.735  1.00  0.00
ATOM    494  N   CYS    32       3.372 -21.042 -11.708  1.00  0.00
ATOM    495  HN  CYS    32       2.397 -21.033 -11.820  1.00  0.00
ATOM    496  CA  CYS    32       3.929 -20.815 -10.357  1.00  0.00
ATOM    497  HA  CYS    32       4.586 -19.948 -10.425  1.00  0.00
ATOM    498  CB  CYS    32       2.822 -20.500  -9.334  1.00  0.00
ATOM    499  HB1 CYS    32       2.121 -21.327  -9.285  1.00  0.00
ATOM    500  HB2 CYS    32       2.292 -19.608  -9.643  1.00  0.00
ATOM    501  SG  CYS    32       3.442 -20.205  -7.661  1.00  0.00
ATOM    502  HG  CYS    32       3.893 -18.961  -7.609  1.00  0.00
ATOM    503  C   CYS    32       4.746 -22.018  -9.858  1.00  0.00
ATOM    504  O   CYS    32       4.315 -23.164  -9.982  1.00  0.00
ATOM    505  N   GLN    33       5.931 -21.735  -9.310  1.00  0.00
ATOM    506  HN  GLN    33       6.211 -20.795  -9.266  1.00  0.00
ATOM    507  CA  GLN    33       6.820 -22.757  -8.747  1.00  0.00
ATOM    508  HA  GLN    33       6.676 -23.687  -9.300  1.00  0.00
ATOM    509  CB  GLN    33       8.293 -22.308  -8.888  1.00  0.00
ATOM    510  HB1 GLN    33       8.940 -23.107  -8.534  1.00  0.00
ATOM    511  HB2 GLN    33       8.455 -21.432  -8.264  1.00  0.00
ATOM    512  CG  GLN    33       8.708 -21.948 -10.324  1.00  0.00
ATOM    513  HG1 GLN    33       9.714 -21.544 -10.306  1.00  0.00
ATOM    514  HG2 GLN    33       8.029 -21.185 -10.687  1.00  0.00
ATOM    515  CD  GLN    33       8.666 -23.115 -11.312  1.00  0.00
ATOM    516  OE1 GLN    33       9.627 -23.873 -11.448  1.00  0.00
ATOM    517  NE2 GLN    33       7.557 -23.249 -12.021  1.00  0.00
ATOM    518 HE21 GLN    33       6.829 -22.608 -11.869  1.00  0.00
ATOM    519 HE22 GLN    33       7.515 -23.970 -12.683  1.00  0.00
ATOM    520  C   GLN    33       6.458 -22.984  -7.273  1.00  0.00
ATOM    521  O   GLN    33       6.003 -22.058  -6.590  1.00  0.00
ATOM    522  N   TYR    34       6.660 -24.215  -6.795  1.00  0.00
ATOM    523  HN  TYR    34       7.018 -24.897  -7.399  1.00  0.00
ATOM    524  CA  TYR    34       6.366 -24.598  -5.412  1.00  0.00
ATOM    525  HA  TYR    34       6.364 -23.697  -4.801  1.00  0.00
ATOM    526  CB  TYR    34       4.974 -25.271  -5.320  1.00  0.00
ATOM    527  HB1 TYR    34       5.006 -26.231  -5.824  1.00  0.00
ATOM    528  HB2 TYR    34       4.250 -24.644  -5.830  1.00  0.00
ATOM    529  CG  TYR    34       4.468 -25.493  -3.889  1.00  0.00
ATOM    530  CD1 TYR    34       4.474 -26.760  -3.296  1.00  0.00
ATOM    531  HD1 TYR    34       4.842 -27.610  -3.864  1.00  0.00
ATOM    532  CD2 TYR    34       3.989 -24.416  -3.132  1.00  0.00
ATOM    533  HD2 TYR    34       3.970 -23.424  -3.573  1.00  0.00
ATOM    534  CE1 TYR    34       4.013 -26.943  -2.007  1.00  0.00
ATOM    535  HE1 TYR    34       4.024 -27.931  -1.565  1.00  0.00
ATOM    536  CE2 TYR    34       3.532 -24.598  -1.845  1.00  0.00
ATOM    537  HE2 TYR    34       3.165 -23.751  -1.278  1.00  0.00
ATOM    538  CZ  TYR    34       3.548 -25.860  -1.285  1.00  0.00
ATOM    539  OH  TYR    34       3.076 -26.040  -0.005  1.00  0.00
ATOM    540  HH  TYR    34       3.708 -26.559   0.500  1.00  0.00
ATOM    541  C   TYR    34       7.470 -25.531  -4.911  1.00  0.00
ATOM    542  O   TYR    34       7.623 -26.639  -5.427  1.00  0.00
ATOM    543  N   TYR    35       8.258 -25.050  -3.939  1.00  0.00
ATOM    544  HN  TYR    35       8.090 -24.143  -3.617  1.00  0.00
ATOM    545  CA  TYR    35       9.360 -25.806  -3.322  1.00  0.00
ATOM    546  HA  TYR    35       9.523 -26.709  -3.909  1.00  0.00
ATOM    547  CB  TYR    35      10.675 -24.980  -3.310  1.00  0.00
ATOM    548  HB1 TYR    35      11.435 -25.539  -2.770  1.00  0.00
ATOM    549  HB2 TYR    35      10.501 -24.053  -2.779  1.00  0.00
ATOM    550  CG  TYR    35      11.248 -24.622  -4.699  1.00  0.00
ATOM    551  CD1 TYR    35      12.419 -25.220  -5.176  1.00  0.00
ATOM    552  HD1 TYR    35      12.920 -25.960  -4.560  1.00  0.00
ATOM    553  CD2 TYR    35      10.630 -23.674  -5.519  1.00  0.00
ATOM    554  HD2 TYR    35       9.721 -23.191  -5.173  1.00  0.00
ATOM    555  CE1 TYR    35      12.942 -24.893  -6.412  1.00  0.00
ATOM    556  HE1 TYR    35      13.843 -25.374  -6.758  1.00  0.00
ATOM    557  CE2 TYR    35      11.150 -23.347  -6.756  1.00  0.00
ATOM    558  HE2 TYR    35      10.646 -22.616  -7.370  1.00  0.00
ATOM    559  CZ  TYR    35      12.306 -23.952  -7.197  1.00  0.00
ATOM    560  OH  TYR    35      12.820 -23.623  -8.433  1.00  0.00
ATOM    561  HH  TYR    35      13.041 -24.430  -8.909  1.00  0.00
ATOM    562  C   TYR    35       9.000 -26.224  -1.887  1.00  0.00
ATOM    563  O   TYR    35       8.172 -25.588  -1.222  1.00  0.00
ATOM    564  N   ALA    36       9.647 -27.307  -1.441  1.00  0.00
ATOM    565  HN  ALA    36      10.233 -27.776  -2.069  1.00  0.00
ATOM    566  CA  ALA    36       9.560 -27.833  -0.072  1.00  0.00
ATOM    567  HA  ALA    36       8.812 -27.261   0.480  1.00  0.00
ATOM    568  CB  ALA    36       9.131 -29.308  -0.103  1.00  0.00
ATOM    569  HB1 ALA    36       8.176 -29.395  -0.605  1.00  0.00
ATOM    570  HB2 ALA    36       9.038 -29.687   0.907  1.00  0.00
ATOM    571  HB3 ALA    36       9.868 -29.893  -0.640  1.00  0.00
ATOM    572  C   ALA    36      10.919 -27.677   0.619  1.00  0.00
ATOM    573  O   ALA    36      11.950 -27.634  -0.064  1.00  0.00
ATOM    574  N   PHE    37      10.898 -27.616   1.965  1.00  0.00
ATOM    575  HN  PHE    37      10.028 -27.690   2.410  1.00  0.00
ATOM    576  CA  PHE    37      12.100 -27.441   2.814  1.00  0.00
ATOM    577  HA  PHE    37      12.490 -26.449   2.624  1.00  0.00
ATOM    578  CB  PHE    37      11.685 -27.538   4.308  1.00  0.00
ATOM    579  HB1 PHE    37      11.206 -28.496   4.474  1.00  0.00
ATOM    580  HB2 PHE    37      10.960 -26.758   4.518  1.00  0.00
ATOM    581  CG  PHE    37      12.829 -27.390   5.318  1.00  0.00
ATOM    582  CD1 PHE    37      13.502 -26.179   5.459  1.00  0.00
ATOM    583  HD1 PHE    37      13.222 -25.338   4.834  1.00  0.00
ATOM    584  CD2 PHE    37      13.216 -28.454   6.136  1.00  0.00
ATOM    585  HD2 PHE    37      12.715 -29.408   6.039  1.00  0.00
ATOM    586  CE1 PHE    37      14.520 -26.033   6.380  1.00  0.00
ATOM    587  HE1 PHE    37      15.030 -25.081   6.474  1.00  0.00
ATOM    588  CE2 PHE    37      14.239 -28.307   7.056  1.00  0.00
ATOM    589  HE2 PHE    37      14.527 -29.141   7.681  1.00  0.00
ATOM    590  CZ  PHE    37      14.888 -27.095   7.179  1.00  0.00
ATOM    591  HZ  PHE    37      15.684 -26.978   7.901  1.00  0.00
ATOM    592  C   PHE    37      13.194 -28.502   2.500  1.00  0.00
ATOM    593  O   PHE    37      12.892 -29.697   2.556  1.00  0.00
ATOM    594  N   PRO    38      14.479 -28.106   2.177  1.00  0.00
ATOM    595  CA  PRO    38      14.924 -26.691   2.008  1.00  0.00
ATOM    596  HA  PRO    38      14.537 -26.075   2.819  1.00  0.00
ATOM    597  CB  PRO    38      16.467 -26.797   2.147  1.00  0.00
ATOM    598  HB1 PRO    38      16.750 -26.680   3.192  1.00  0.00
ATOM    599  HB2 PRO    38      16.955 -26.023   1.563  1.00  0.00
ATOM    600  CG  PRO    38      16.797 -28.171   1.643  1.00  0.00
ATOM    601  HG1 PRO    38      17.713 -28.531   2.101  1.00  0.00
ATOM    602  HG2 PRO    38      16.911 -28.148   0.562  1.00  0.00
ATOM    603  CD  PRO    38      15.623 -29.050   2.037  1.00  0.00
ATOM    604  HD1 PRO    38      15.819 -29.546   2.982  1.00  0.00
ATOM    605  HD2 PRO    38      15.416 -29.784   1.272  1.00  0.00
ATOM    606  C   PRO    38      14.491 -26.046   0.650  1.00  0.00
ATOM    607  O   PRO    38      13.769 -25.041   0.647  1.00  0.00
ATOM    608  N   ALA    39      14.901 -26.646  -0.492  1.00  0.00
ATOM    609  HN  ALA    39      15.417 -27.473  -0.427  1.00  0.00
ATOM    610  CA  ALA    39      14.593 -26.127  -1.842  1.00  0.00
ATOM    611  HA  ALA    39      13.665 -25.552  -1.792  1.00  0.00
ATOM    612  CB  ALA    39      15.713 -25.178  -2.326  1.00  0.00
ATOM    613  HB1 ALA    39      15.457 -24.768  -3.297  1.00  0.00
ATOM    614  HB2 ALA    39      16.645 -25.720  -2.403  1.00  0.00
ATOM    615  HB3 ALA    39      15.834 -24.365  -1.618  1.00  0.00
ATOM    616  C   ALA    39      14.388 -27.300  -2.818  1.00  0.00
ATOM    617  O   ALA    39      15.294 -27.665  -3.577  1.00  0.00
ATOM    618  N   THR    40      13.197 -27.913  -2.761  1.00  0.00
ATOM    619  HN  THR    40      12.521 -27.561  -2.142  1.00  0.00
ATOM    620  CA  THR    40      12.851 -29.096  -3.572  1.00  0.00
ATOM    621  HA  THR    40      13.657 -29.283  -4.280  1.00  0.00
ATOM    622  CB  THR    40      12.707 -30.356  -2.654  1.00  0.00
ATOM    623  HB  THR    40      11.946 -30.151  -1.903  1.00  0.00
ATOM    624  OG1 THR    40      13.957 -30.590  -1.979  1.00  0.00
ATOM    625  HG1 THR    40      13.879 -30.308  -1.067  1.00  0.00
ATOM    626  CG2 THR    40      12.296 -31.623  -3.435  1.00  0.00
ATOM    627 HG21 THR    40      13.015 -31.819  -4.220  1.00  0.00
ATOM    628 HG22 THR    40      11.315 -31.481  -3.876  1.00  0.00
ATOM    629 HG23 THR    40      12.264 -32.471  -2.765  1.00  0.00
ATOM    630  C   THR    40      11.555 -28.827  -4.355  1.00  0.00
ATOM    631  O   THR    40      10.466 -28.807  -3.771  1.00  0.00
ATOM    632  N   LEU    41      11.690 -28.604  -5.676  1.00  0.00
ATOM    633  HN  LEU    41      12.579 -28.711  -6.077  1.00  0.00
ATOM    634  CA  LEU    41      10.568 -28.232  -6.559  1.00  0.00
ATOM    635  HA  LEU    41      10.075 -27.367  -6.120  1.00  0.00
ATOM    636  CB  LEU    41      11.113 -27.835  -7.964  1.00  0.00
ATOM    637  HB1 LEU    41      11.598 -28.707  -8.395  1.00  0.00
ATOM    638  HB2 LEU    41      11.871 -27.070  -7.827  1.00  0.00
ATOM    639  CG  LEU    41      10.063 -27.304  -8.992  1.00  0.00
ATOM    640  HG  LEU    41       9.269 -28.028  -9.069  1.00  0.00
ATOM    641  CD1 LEU    41       9.414 -25.991  -8.514  1.00  0.00
ATOM    642 HD11 LEU    41      10.169 -25.224  -8.402  1.00  0.00
ATOM    643 HD12 LEU    41       8.924 -26.152  -7.563  1.00  0.00
ATOM    644 HD13 LEU    41       8.676 -25.665  -9.237  1.00  0.00
ATOM    645  CD2 LEU    41      10.680 -27.145 -10.400  1.00  0.00
ATOM    646 HD21 LEU    41      11.474 -26.407 -10.375  1.00  0.00
ATOM    647 HD22 LEU    41       9.918 -26.826 -11.099  1.00  0.00
ATOM    648 HD23 LEU    41      11.084 -28.094 -10.729  1.00  0.00
ATOM    649  C   LEU    41       9.549 -29.387  -6.673  1.00  0.00
ATOM    650  O   LEU    41       9.794 -30.377  -7.366  1.00  0.00
ATOM    651  N   LEU    42       8.424 -29.257  -5.947  1.00  0.00
ATOM    652  HN  LEU    42       8.353 -28.502  -5.331  1.00  0.00
ATOM    653  CA  LEU    42       7.306 -30.217  -6.004  1.00  0.00
ATOM    654  HA  LEU    42       7.720 -31.215  -6.065  1.00  0.00
ATOM    655  CB  LEU    42       6.422 -30.119  -4.726  1.00  0.00
ATOM    656  HB1 LEU    42       5.673 -30.904  -4.778  1.00  0.00
ATOM    657  HB2 LEU    42       5.906 -29.161  -4.745  1.00  0.00
ATOM    658  CG  LEU    42       7.155 -30.235  -3.352  1.00  0.00
ATOM    659  HG  LEU    42       7.771 -29.352  -3.218  1.00  0.00
ATOM    660  CD1 LEU    42       6.145 -30.250  -2.183  1.00  0.00
ATOM    661 HD11 LEU    42       5.491 -31.112  -2.265  1.00  0.00
ATOM    662 HD12 LEU    42       5.550 -29.348  -2.206  1.00  0.00
ATOM    663 HD13 LEU    42       6.679 -30.295  -1.243  1.00  0.00
ATOM    664  CD2 LEU    42       8.099 -31.459  -3.304  1.00  0.00
ATOM    665 HD21 LEU    42       8.577 -31.515  -2.336  1.00  0.00
ATOM    666 HD22 LEU    42       8.861 -31.355  -4.065  1.00  0.00
ATOM    667 HD23 LEU    42       7.537 -32.369  -3.483  1.00  0.00
ATOM    668  C   LEU    42       6.434 -29.958  -7.246  1.00  0.00
ATOM    669  O   LEU    42       5.915 -30.902  -7.860  1.00  0.00
ATOM    670  N   ALA    43       6.281 -28.670  -7.605  1.00  0.00
ATOM    671  HN  ALA    43       6.814 -27.988  -7.142  1.00  0.00
ATOM    672  CA  ALA    43       5.338 -28.239  -8.656  1.00  0.00
ATOM    673  HA  ALA    43       5.126 -29.084  -9.309  1.00  0.00
ATOM    674  CB  ALA    43       4.025 -27.815  -7.996  1.00  0.00
ATOM    675  HB1 ALA    43       3.306 -27.524  -8.754  1.00  0.00
ATOM    676  HB2 ALA    43       4.205 -26.979  -7.333  1.00  0.00
ATOM    677  HB3 ALA    43       3.620 -28.641  -7.424  1.00  0.00
ATOM    678  C   ALA    43       5.919 -27.088  -9.495  1.00  0.00
ATOM    679  O   ALA    43       6.235 -26.030  -8.953  1.00  0.00
ATOM    680  N   GLY    44       6.037 -27.307 -10.819  1.00  0.00
ATOM    681  HN  GLY    44       5.759 -28.179 -11.171  1.00  0.00
ATOM    682  CA  GLY    44       6.553 -26.303 -11.758  1.00  0.00
ATOM    683  HA1 GLY    44       7.207 -26.802 -12.463  1.00  0.00
ATOM    684  HA2 GLY    44       7.132 -25.564 -11.218  1.00  0.00
ATOM    685  C   GLY    44       5.441 -25.590 -12.533  1.00  0.00
ATOM    686  O   GLY    44       5.641 -25.190 -13.688  1.00  0.00
ATOM    687  N   ASN    45       4.307 -25.374 -11.842  1.00  0.00
ATOM    688  HN  ASN    45       4.350 -25.502 -10.870  1.00  0.00
ATOM    689  CA  ASN    45       3.029 -24.853 -12.409  1.00  0.00
ATOM    690  HA  ASN    45       3.173 -23.789 -12.573  1.00  0.00
ATOM    691  CB  ASN    45       2.606 -25.511 -13.767  1.00  0.00
ATOM    692  HB1 ASN    45       3.409 -25.382 -14.484  1.00  0.00
ATOM    693  HB2 ASN    45       1.735 -24.993 -14.147  1.00  0.00
ATOM    694  CG  ASN    45       2.271 -27.002 -13.667  1.00  0.00
ATOM    695  OD1 ASN    45       1.137 -27.384 -13.375  1.00  0.00
ATOM    696  ND2 ASN    45       3.246 -27.850 -13.945  1.00  0.00
ATOM    697 HD21 ASN    45       4.118 -27.483 -14.196  1.00  0.00
ATOM    698 HD22 ASN    45       3.059 -28.809 -13.885  1.00  0.00
ATOM    699  C   ASN    45       1.893 -25.018 -11.376  1.00  0.00
ATOM    700  O   ASN    45       1.989 -25.849 -10.466  1.00  0.00
ATOM    701  N   ALA    46       0.798 -24.256 -11.582  1.00  0.00
ATOM    702  HN  ALA    46       0.750 -23.746 -12.414  1.00  0.00
ATOM    703  CA  ALA    46      -0.338 -24.151 -10.638  1.00  0.00
ATOM    704  HA  ALA    46       0.060 -23.852  -9.672  1.00  0.00
ATOM    705  CB  ALA    46      -1.298 -23.046 -11.110  1.00  0.00
ATOM    706  HB1 ALA    46      -2.094 -22.908 -10.387  1.00  0.00
ATOM    707  HB2 ALA    46      -1.728 -23.316 -12.068  1.00  0.00
ATOM    708  HB3 ALA    46      -0.757 -22.114 -11.218  1.00  0.00
ATOM    709  C   ALA    46      -1.103 -25.482 -10.467  1.00  0.00
ATOM    710  O   ALA    46      -1.540 -25.816  -9.361  1.00  0.00
ATOM    711  N   ALA    47      -1.235 -26.238 -11.569  1.00  0.00
ATOM    712  HN  ALA    47      -0.755 -25.965 -12.382  1.00  0.00
ATOM    713  CA  ALA    47      -2.052 -27.468 -11.611  1.00  0.00
ATOM    714  HA  ALA    47      -3.072 -27.190 -11.352  1.00  0.00
ATOM    715  CB  ALA    47      -2.072 -28.062 -13.023  1.00  0.00
ATOM    716  HB1 ALA    47      -1.077 -28.410 -13.288  1.00  0.00
ATOM    717  HB2 ALA    47      -2.388 -27.309 -13.732  1.00  0.00
ATOM    718  HB3 ALA    47      -2.766 -28.896 -13.059  1.00  0.00
ATOM    719  C   ALA    47      -1.556 -28.516 -10.610  1.00  0.00
ATOM    720  O   ALA    47      -2.352 -29.223  -9.997  1.00  0.00
ATOM    721  N   GLU    48      -0.233 -28.614 -10.469  1.00  0.00
ATOM    722  HN  GLU    48       0.342 -28.017 -11.000  1.00  0.00
ATOM    723  CA  GLU    48       0.402 -29.568  -9.545  1.00  0.00
ATOM    724  HA  GLU    48      -0.139 -30.512  -9.619  1.00  0.00
ATOM    725  CB  GLU    48       1.867 -29.812  -9.970  1.00  0.00
ATOM    726  HB1 GLU    48       2.267 -30.649  -9.402  1.00  0.00
ATOM    727  HB2 GLU    48       2.450 -28.928  -9.739  1.00  0.00
ATOM    728  CG  GLU    48       2.051 -30.115 -11.465  1.00  0.00
ATOM    729  HG1 GLU    48       1.758 -29.236 -12.036  1.00  0.00
ATOM    730  HG2 GLU    48       1.391 -30.934 -11.741  1.00  0.00
ATOM    731  CD  GLU    48       3.504 -30.470 -11.823  1.00  0.00
ATOM    732  OE1 GLU    48       4.355 -29.560 -11.862  1.00  0.00
ATOM    733  OE2 GLU    48       3.797 -31.653 -12.083  1.00  0.00
ATOM    734  C   GLU    48       0.311 -29.068  -8.083  1.00  0.00
ATOM    735  O   GLU    48       0.176 -29.872  -7.152  1.00  0.00
ATOM    736  N   ILE    49       0.366 -27.724  -7.907  1.00  0.00
ATOM    737  HN  ILE    49       0.462 -27.157  -8.704  1.00  0.00
ATOM    738  CA  ILE    49       0.289 -27.064  -6.580  1.00  0.00
ATOM    739  HA  ILE    49       1.096 -27.457  -5.965  1.00  0.00
ATOM    740  CB  ILE    49       0.469 -25.495  -6.690  1.00  0.00
ATOM    741  HB  ILE    49      -0.315 -25.121  -7.346  1.00  0.00
ATOM    742  CG1 ILE    49       1.846 -25.144  -7.321  1.00  0.00
ATOM    743 HG11 ILE    49       1.937 -25.649  -8.277  1.00  0.00
ATOM    744 HG12 ILE    49       2.634 -25.501  -6.672  1.00  0.00
ATOM    745  CG2 ILE    49       0.297 -24.792  -5.316  1.00  0.00
ATOM    746 HG21 ILE    49       1.051 -25.147  -4.623  1.00  0.00
ATOM    747 HG22 ILE    49      -0.685 -25.006  -4.913  1.00  0.00
ATOM    748 HG23 ILE    49       0.399 -23.721  -5.439  1.00  0.00
ATOM    749  CD1 ILE    49       2.103 -23.670  -7.561  1.00  0.00
ATOM    750 HD11 ILE    49       1.338 -23.263  -8.208  1.00  0.00
ATOM    751 HD12 ILE    49       3.069 -23.547  -8.031  1.00  0.00
ATOM    752 HD13 ILE    49       2.098 -23.141  -6.619  1.00  0.00
ATOM    753  C   ILE    49      -1.055 -27.367  -5.898  1.00  0.00
ATOM    754  O   ILE    49      -1.088 -27.781  -4.727  1.00  0.00
ATOM    755  N   ARG    50      -2.158 -27.149  -6.646  1.00  0.00
ATOM    756  HN  ARG    50      -2.046 -26.855  -7.582  1.00  0.00
ATOM    757  CA  ARG    50      -3.520 -27.338  -6.116  1.00  0.00
ATOM    758  HA  ARG    50      -3.600 -26.716  -5.224  1.00  0.00
ATOM    759  CB  ARG    50      -4.611 -26.869  -7.122  1.00  0.00
ATOM    760  HB1 ARG    50      -4.481 -25.804  -7.291  1.00  0.00
ATOM    761  HB2 ARG    50      -5.590 -27.021  -6.675  1.00  0.00
ATOM    762  CG  ARG    50      -4.592 -27.580  -8.493  1.00  0.00
ATOM    763  HG1 ARG    50      -4.813 -28.633  -8.340  1.00  0.00
ATOM    764  HG2 ARG    50      -3.598 -27.490  -8.915  1.00  0.00
ATOM    765  CD  ARG    50      -5.596 -27.004  -9.492  1.00  0.00
ATOM    766  HD1 ARG    50      -5.375 -25.950  -9.646  1.00  0.00
ATOM    767  HD2 ARG    50      -6.595 -27.100  -9.080  1.00  0.00
ATOM    768  NE  ARG    50      -5.558 -27.703 -10.798  1.00  0.00
ATOM    769  HE  ARG    50      -5.351 -28.667 -10.777  1.00  0.00
ATOM    770  CZ  ARG    50      -5.793 -27.131 -11.995  1.00  0.00
ATOM    771  NH1 ARG    50      -6.067 -25.835 -12.087  1.00  0.00
ATOM    772 HH11 ARG    50      -6.107 -25.271 -11.264  1.00  0.00
ATOM    773 HH12 ARG    50      -6.224 -25.413 -12.988  1.00  0.00
ATOM    774  NH2 ARG    50      -5.749 -27.866 -13.097  1.00  0.00
ATOM    775 HH21 ARG    50      -5.543 -28.847 -13.045  1.00  0.00
ATOM    776 HH22 ARG    50      -5.925 -27.449 -13.992  1.00  0.00
ATOM    777  C   ARG    50      -3.740 -28.803  -5.705  1.00  0.00
ATOM    778  O   ARG    50      -4.128 -29.045  -4.574  1.00  0.00
ATOM    779  N   VAL    51      -3.408 -29.760  -6.610  1.00  0.00
ATOM    780  HN  VAL    51      -2.984 -29.477  -7.452  1.00  0.00
ATOM    781  CA  VAL    51      -3.637 -31.211  -6.391  1.00  0.00
ATOM    782  HA  VAL    51      -4.704 -31.352  -6.235  1.00  0.00
ATOM    783  CB  VAL    51      -3.214 -32.066  -7.648  1.00  0.00
ATOM    784  HB  VAL    51      -2.162 -31.866  -7.847  1.00  0.00
ATOM    785  CG1 VAL    51      -3.369 -33.593  -7.393  1.00  0.00
ATOM    786 HG11 VAL    51      -4.403 -33.823  -7.163  1.00  0.00
ATOM    787 HG12 VAL    51      -2.745 -33.892  -6.559  1.00  0.00
ATOM    788 HG13 VAL    51      -3.067 -34.144  -8.275  1.00  0.00
ATOM    789  CG2 VAL    51      -4.019 -31.637  -8.900  1.00  0.00
ATOM    790 HG21 VAL    51      -5.072 -31.835  -8.747  1.00  0.00
ATOM    791 HG22 VAL    51      -3.674 -32.188  -9.766  1.00  0.00
ATOM    792 HG23 VAL    51      -3.881 -30.576  -9.080  1.00  0.00
ATOM    793  C   VAL    51      -2.891 -31.695  -5.136  1.00  0.00
ATOM    794  O   VAL    51      -3.461 -32.419  -4.314  1.00  0.00
ATOM    795  N   ARG    52      -1.635 -31.228  -4.987  1.00  0.00
ATOM    796  HN  ARG    52      -1.264 -30.665  -5.700  1.00  0.00
ATOM    797  CA  ARG    52      -0.787 -31.528  -3.816  1.00  0.00
ATOM    798  HA  ARG    52      -0.610 -32.599  -3.805  1.00  0.00
ATOM    799  CB  ARG    52       0.581 -30.793  -3.923  1.00  0.00
ATOM    800  HB1 ARG    52       0.399 -29.724  -3.949  1.00  0.00
ATOM    801  HB2 ARG    52       1.051 -31.077  -4.858  1.00  0.00
ATOM    802  CG  ARG    52       1.589 -31.090  -2.777  1.00  0.00
ATOM    803  HG1 ARG    52       1.032 -31.227  -1.851  1.00  0.00
ATOM    804  HG2 ARG    52       2.244 -30.234  -2.662  1.00  0.00
ATOM    805  CD  ARG    52       2.462 -32.347  -3.023  1.00  0.00
ATOM    806  HD1 ARG    52       3.163 -32.435  -2.209  1.00  0.00
ATOM    807  HD2 ARG    52       3.018 -32.207  -3.944  1.00  0.00
ATOM    808  NE  ARG    52       1.695 -33.613  -3.138  1.00  0.00
ATOM    809  HE  ARG    52       0.724 -33.541  -3.267  1.00  0.00
ATOM    810  CZ  ARG    52       2.234 -34.846  -3.134  1.00  0.00
ATOM    811  NH1 ARG    52       3.523 -35.031  -2.888  1.00  0.00
ATOM    812 HH11 ARG    52       4.121 -34.248  -2.699  1.00  0.00
ATOM    813 HH12 ARG    52       3.910 -35.958  -2.895  1.00  0.00
ATOM    814  NH2 ARG    52       1.462 -35.896  -3.349  1.00  0.00
ATOM    815 HH21 ARG    52       0.479 -35.774  -3.517  1.00  0.00
ATOM    816 HH22 ARG    52       1.850 -36.820  -3.358  1.00  0.00
ATOM    817  C   ARG    52      -1.503 -31.133  -2.509  1.00  0.00
ATOM    818  O   ARG    52      -1.497 -31.883  -1.526  1.00  0.00
ATOM    819  N   HIS    53      -2.128 -29.944  -2.525  1.00  0.00
ATOM    820  HN  HIS    53      -2.103 -29.412  -3.355  1.00  0.00
ATOM    821  CA  HIS    53      -2.855 -29.406  -1.362  1.00  0.00
ATOM    822  HA  HIS    53      -2.267 -29.645  -0.476  1.00  0.00
ATOM    823  CB  HIS    53      -2.965 -27.871  -1.457  1.00  0.00
ATOM    824  HB1 HIS    53      -3.635 -27.503  -0.681  1.00  0.00
ATOM    825  HB2 HIS    53      -3.366 -27.600  -2.427  1.00  0.00
ATOM    826  CG  HIS    53      -1.648 -27.161  -1.283  1.00  0.00
ATOM    827  ND1 HIS    53      -1.079 -26.368  -2.258  1.00  0.00
ATOM    828  HD1 HIS    53      -1.440 -26.224  -3.161  1.00  0.00
ATOM    829  CD2 HIS    53      -0.817 -27.093  -0.214  1.00  0.00
ATOM    830  HD2 HIS    53      -0.952 -27.596   0.738  1.00  0.00
ATOM    831  CE1 HIS    53       0.038 -25.842  -1.797  1.00  0.00
ATOM    832  HE1 HIS    53       0.695 -25.175  -2.338  1.00  0.00
ATOM    833  NE2 HIS    53       0.216 -26.263  -0.560  1.00  0.00
ATOM    834  HE2 HIS    53       0.983 -26.034   0.015  1.00  0.00
ATOM    835  C   HIS    53      -4.242 -30.048  -1.190  1.00  0.00
ATOM    836  O   HIS    53      -4.702 -30.155  -0.073  1.00  0.00
ATOM    837  N   ILE    54      -4.888 -30.480  -2.288  1.00  0.00
ATOM    838  HN  ILE    54      -4.454 -30.385  -3.158  1.00  0.00
ATOM    839  CA  ILE    54      -6.223 -31.128  -2.237  1.00  0.00
ATOM    840  HA  ILE    54      -6.912 -30.438  -1.750  1.00  0.00
ATOM    841  CB  ILE    54      -6.754 -31.421  -3.692  1.00  0.00
ATOM    842  HB  ILE    54      -5.970 -31.954  -4.221  1.00  0.00
ATOM    843  CG1 ILE    54      -7.043 -30.094  -4.455  1.00  0.00
ATOM    844 HG11 ILE    54      -6.175 -29.451  -4.396  1.00  0.00
ATOM    845 HG12 ILE    54      -7.875 -29.586  -3.988  1.00  0.00
ATOM    846  CG2 ILE    54      -8.005 -32.322  -3.689  1.00  0.00
ATOM    847 HG21 ILE    54      -8.326 -32.509  -4.706  1.00  0.00
ATOM    848 HG22 ILE    54      -8.805 -31.837  -3.149  1.00  0.00
ATOM    849 HG23 ILE    54      -7.775 -33.267  -3.209  1.00  0.00
ATOM    850  CD1 ILE    54      -7.383 -30.256  -5.923  1.00  0.00
ATOM    851 HD11 ILE    54      -6.574 -30.774  -6.425  1.00  0.00
ATOM    852 HD12 ILE    54      -7.516 -29.281  -6.368  1.00  0.00
ATOM    853 HD13 ILE    54      -8.294 -30.825  -6.023  1.00  0.00
ATOM    854  C   ILE    54      -6.139 -32.425  -1.408  1.00  0.00
ATOM    855  O   ILE    54      -7.042 -32.737  -0.627  1.00  0.00
ATOM    856  N   GLU    55      -5.011 -33.137  -1.584  1.00  0.00
ATOM    857  HN  GLU    55      -4.387 -32.842  -2.287  1.00  0.00
ATOM    858  CA  GLU    55      -4.661 -34.337  -0.799  1.00  0.00
ATOM    859  HA  GLU    55      -5.442 -35.081  -0.961  1.00  0.00
ATOM    860  CB  GLU    55      -3.309 -34.900  -1.311  1.00  0.00
ATOM    861  HB1 GLU    55      -3.057 -35.796  -0.746  1.00  0.00
ATOM    862  HB2 GLU    55      -2.533 -34.154  -1.141  1.00  0.00
ATOM    863  CG  GLU    55      -3.303 -35.260  -2.811  1.00  0.00
ATOM    864  HG1 GLU    55      -3.646 -34.396  -3.377  1.00  0.00
ATOM    865  HG2 GLU    55      -3.998 -36.075  -2.980  1.00  0.00
ATOM    866  CD  GLU    55      -1.912 -35.671  -3.321  1.00  0.00
ATOM    867  OE1 GLU    55      -1.504 -36.835  -3.108  1.00  0.00
ATOM    868  OE2 GLU    55      -1.201 -34.826  -3.908  1.00  0.00
ATOM    869  C   GLU    55      -4.589 -34.001   0.707  1.00  0.00
ATOM    870  O   GLU    55      -5.053 -34.776   1.547  1.00  0.00
ATOM    871  N   ARG    56      -4.022 -32.822   1.019  1.00  0.00
ATOM    872  HN  ARG    56      -3.640 -32.283   0.290  1.00  0.00
ATOM    873  CA  ARG    56      -3.933 -32.309   2.403  1.00  0.00
ATOM    874  HA  ARG    56      -3.552 -33.117   3.025  1.00  0.00
ATOM    875  CB  ARG    56      -2.925 -31.123   2.465  1.00  0.00
ATOM    876  HB1 ARG    56      -3.324 -30.300   1.880  1.00  0.00
ATOM    877  HB2 ARG    56      -1.991 -31.438   2.009  1.00  0.00
ATOM    878  CG  ARG    56      -2.610 -30.595   3.886  1.00  0.00
ATOM    879  HG1 ARG    56      -3.521 -30.187   4.312  1.00  0.00
ATOM    880  HG2 ARG    56      -1.874 -29.805   3.809  1.00  0.00
ATOM    881  CD  ARG    56      -2.065 -31.690   4.833  1.00  0.00
ATOM    882  HD1 ARG    56      -2.833 -32.446   4.967  1.00  0.00
ATOM    883  HD2 ARG    56      -1.841 -31.244   5.798  1.00  0.00
ATOM    884  NE  ARG    56      -0.838 -32.328   4.315  1.00  0.00
ATOM    885  HE  ARG    56      -0.259 -31.772   3.752  1.00  0.00
ATOM    886  CZ  ARG    56      -0.454 -33.590   4.565  1.00  0.00
ATOM    887  NH1 ARG    56      -1.223 -34.418   5.262  1.00  0.00
ATOM    888 HH11 ARG    56      -2.117 -34.112   5.603  1.00  0.00
ATOM    889 HH12 ARG    56      -0.919 -35.355   5.446  1.00  0.00
ATOM    890  NH2 ARG    56       0.694 -34.032   4.076  1.00  0.00
ATOM    891 HH21 ARG    56       1.269 -33.433   3.517  1.00  0.00
ATOM    892 HH22 ARG    56       0.996 -34.974   4.261  1.00  0.00
ATOM    893  C   ARG    56      -5.334 -31.891   2.936  1.00  0.00
ATOM    894  O   ARG    56      -5.620 -32.033   4.128  1.00  0.00
ATOM    895  N   PHE    57      -6.204 -31.392   2.029  1.00  0.00
ATOM    896  HN  PHE    57      -5.910 -31.324   1.097  1.00  0.00
ATOM    897  CA  PHE    57      -7.585 -30.948   2.363  1.00  0.00
ATOM    898  HA  PHE    57      -7.532 -30.378   3.288  1.00  0.00
ATOM    899  CB  PHE    57      -8.155 -30.015   1.240  1.00  0.00
ATOM    900  HB1 PHE    57      -9.239 -29.995   1.315  1.00  0.00
ATOM    901  HB2 PHE    57      -7.892 -30.433   0.277  1.00  0.00
ATOM    902  CG  PHE    57      -7.661 -28.555   1.239  1.00  0.00
ATOM    903  CD1 PHE    57      -6.323 -28.234   1.443  1.00  0.00
ATOM    904  HD1 PHE    57      -5.612 -29.028   1.633  1.00  0.00
ATOM    905  CD2 PHE    57      -8.549 -27.500   0.998  1.00  0.00
ATOM    906  HD2 PHE    57      -9.600 -27.716   0.836  1.00  0.00
ATOM    907  CE1 PHE    57      -5.887 -26.925   1.408  1.00  0.00
ATOM    908  HE1 PHE    57      -4.841 -26.702   1.568  1.00  0.00
ATOM    909  CE2 PHE    57      -8.111 -26.188   0.969  1.00  0.00
ATOM    910  HE2 PHE    57      -8.813 -25.386   0.782  1.00  0.00
ATOM    911  CZ  PHE    57      -6.779 -25.904   1.172  1.00  0.00
ATOM    912  HZ  PHE    57      -6.434 -24.879   1.146  1.00  0.00
ATOM    913  C   PHE    57      -8.536 -32.152   2.606  1.00  0.00
ATOM    914  O   PHE    57      -9.682 -31.953   3.023  1.00  0.00
ATOM    915  N   LYS    58      -8.074 -33.393   2.318  1.00  0.00
ATOM    916  HN  LYS    58      -7.206 -33.481   1.866  1.00  0.00
ATOM    917  CA  LYS    58      -8.839 -34.627   2.627  1.00  0.00
ATOM    918  HA  LYS    58      -9.859 -34.477   2.281  1.00  0.00
ATOM    919  CB  LYS    58      -8.243 -35.850   1.885  1.00  0.00
ATOM    920  HB1 LYS    58      -8.840 -36.730   2.113  1.00  0.00
ATOM    921  HB2 LYS    58      -7.231 -36.015   2.245  1.00  0.00
ATOM    922  CG  LYS    58      -8.181 -35.689   0.356  1.00  0.00
ATOM    923  HG1 LYS    58      -7.812 -36.613  -0.078  1.00  0.00
ATOM    924  HG2 LYS    58      -7.483 -34.889   0.124  1.00  0.00
ATOM    925  CD  LYS    58      -9.552 -35.346  -0.276  1.00  0.00
ATOM    926  HD1 LYS    58      -9.987 -34.502   0.249  1.00  0.00
ATOM    927  HD2 LYS    58     -10.211 -36.201  -0.182  1.00  0.00
ATOM    928  CE  LYS    58      -9.426 -34.987  -1.757  1.00  0.00
ATOM    929  HE1 LYS    58      -9.070 -35.848  -2.300  1.00  0.00
ATOM    930  HE2 LYS    58      -8.711 -34.181  -1.866  1.00  0.00
ATOM    931  NZ  LYS    58     -10.715 -34.548  -2.334  1.00  0.00
ATOM    932  HZ1 LYS    58     -11.058 -33.699  -1.837  1.00  0.00
ATOM    933  HZ2 LYS    58     -11.426 -35.302  -2.237  1.00  0.00
ATOM    934  HZ3 LYS    58     -10.596 -34.324  -3.338  1.00  0.00
ATOM    935  C   LYS    58      -8.880 -34.902   4.139  1.00  0.00
ATOM    936  O   LYS    58      -9.810 -35.558   4.624  1.00  0.00
ATOM    937  N   GLU    59      -7.848 -34.424   4.866  1.00  0.00
ATOM    938  HN  GLU    59      -7.096 -34.001   4.395  1.00  0.00
ATOM    939  CA  GLU    59      -7.802 -34.505   6.334  1.00  0.00
ATOM    940  HA  GLU    59      -8.011 -35.534   6.612  1.00  0.00
ATOM    941  CB  GLU    59      -6.395 -34.117   6.888  1.00  0.00
ATOM    942  HB1 GLU    59      -6.483 -33.914   7.951  1.00  0.00
ATOM    943  HB2 GLU    59      -6.068 -33.205   6.395  1.00  0.00
ATOM    944  CG  GLU    59      -5.294 -35.190   6.700  1.00  0.00
ATOM    945  HG1 GLU    59      -5.636 -36.116   7.159  1.00  0.00
ATOM    946  HG2 GLU    59      -4.403 -34.863   7.228  1.00  0.00
ATOM    947  CD  GLU    59      -4.917 -35.468   5.229  1.00  0.00
ATOM    948  OE1 GLU    59      -5.500 -36.392   4.608  1.00  0.00
ATOM    949  OE2 GLU    59      -4.030 -34.772   4.698  1.00  0.00
ATOM    950  C   GLU    59      -8.893 -33.597   6.933  1.00  0.00
ATOM    951  O   GLU    59      -8.849 -32.384   6.724  1.00  0.00
ATOM    952  N   PRO    60      -9.906 -34.161   7.674  1.00  0.00
ATOM    953  CA  PRO    60     -10.942 -33.342   8.356  1.00  0.00
ATOM    954  HA  PRO    60     -11.427 -32.665   7.661  1.00  0.00
ATOM    955  CB  PRO    60     -11.959 -34.398   8.862  1.00  0.00
ATOM    956  HB1 PRO    60     -12.746 -34.531   8.122  1.00  0.00
ATOM    957  HB2 PRO    60     -12.407 -34.076   9.797  1.00  0.00
ATOM    958  CG  PRO    60     -11.148 -35.653   9.029  1.00  0.00
ATOM    959  HG1 PRO    60     -11.783 -36.527   8.927  1.00  0.00
ATOM    960  HG2 PRO    60     -10.668 -35.659  10.006  1.00  0.00
ATOM    961  CD  PRO    60     -10.112 -35.619   7.924  1.00  0.00
ATOM    962  HD1 PRO    60     -10.484 -36.107   7.030  1.00  0.00
ATOM    963  HD2 PRO    60      -9.189 -36.089   8.251  1.00  0.00
ATOM    964  C   PRO    60     -10.324 -32.526   9.518  1.00  0.00
ATOM    965  O   PRO    60     -10.854 -31.489   9.933  1.00  0.00
ATOM    966  N   ASP    61      -9.169 -33.022   9.991  1.00  0.00
ATOM    967  HN  ASP    61      -8.815 -33.826   9.561  1.00  0.00
ATOM    968  CA  ASP    61      -8.383 -32.455  11.093  1.00  0.00
ATOM    969  HA  ASP    61      -9.070 -32.015  11.810  1.00  0.00
ATOM    970  CB  ASP    61      -7.609 -33.601  11.794  1.00  0.00
ATOM    971  HB1 ASP    61      -8.322 -34.253  12.287  1.00  0.00
ATOM    972  HB2 ASP    61      -6.956 -33.183  12.556  1.00  0.00
ATOM    973  CG  ASP    61      -6.756 -34.455  10.824  1.00  0.00
ATOM    974  OD1 ASP    61      -5.547 -34.192  10.674  1.00  0.00
ATOM    975  OD2 ASP    61      -7.305 -35.406  10.215  1.00  0.00
ATOM    976  C   ASP    61      -7.413 -31.352  10.623  1.00  0.00
ATOM    977  O   ASP    61      -6.754 -30.720  11.462  1.00  0.00
ATOM    978  N   LEU    62      -7.318 -31.129   9.291  1.00  0.00
ATOM    979  HN  LEU    62      -7.811 -31.708   8.679  1.00  0.00
ATOM    980  CA  LEU    62      -6.494 -30.040   8.727  1.00  0.00
ATOM    981  HA  LEU    62      -5.474 -30.172   9.090  1.00  0.00
ATOM    982  CB  LEU    62      -6.475 -30.062   7.168  1.00  0.00
ATOM    983  HB1 LEU    62      -7.502 -30.058   6.817  1.00  0.00
ATOM    984  HB2 LEU    62      -6.010 -30.990   6.844  1.00  0.00
ATOM    985  CG  LEU    62      -5.719 -28.856   6.503  1.00  0.00
ATOM    986  HG  LEU    62      -6.098 -27.939   6.942  1.00  0.00
ATOM    987  CD1 LEU    62      -4.214 -28.898   6.824  1.00  0.00
ATOM    988 HD11 LEU    62      -3.776 -29.810   6.436  1.00  0.00
ATOM    989 HD12 LEU    62      -4.069 -28.860   7.897  1.00  0.00
ATOM    990 HD13 LEU    62      -3.724 -28.045   6.374  1.00  0.00
ATOM    991  CD2 LEU    62      -5.976 -28.767   4.987  1.00  0.00
ATOM    992 HD21 LEU    62      -5.614 -29.663   4.497  1.00  0.00
ATOM    993 HD22 LEU    62      -5.466 -27.904   4.578  1.00  0.00
ATOM    994 HD23 LEU    62      -7.039 -28.667   4.805  1.00  0.00
ATOM    995  C   LEU    62      -7.024 -28.673   9.193  1.00  0.00
ATOM    996  O   LEU    62      -8.181 -28.332   8.930  1.00  0.00
ATOM    997  N   TYR    63      -6.169 -27.902   9.876  1.00  0.00
ATOM    998  HN  TYR    63      -5.303 -28.282  10.141  1.00  0.00
ATOM    999  CA  TYR    63      -6.484 -26.522  10.257  1.00  0.00
ATOM   1000  HA  TYR    63      -7.120 -26.093   9.484  1.00  0.00
ATOM   1001  CB  TYR    63      -7.248 -26.497  11.610  1.00  0.00
ATOM   1002  HB1 TYR    63      -6.596 -26.860  12.393  1.00  0.00
ATOM   1003  HB2 TYR    63      -8.108 -27.157  11.545  1.00  0.00
ATOM   1004  CG  TYR    63      -7.756 -25.106  12.011  1.00  0.00
ATOM   1005  CD1 TYR    63      -8.895 -24.564  11.412  1.00  0.00
ATOM   1006  HD1 TYR    63      -9.432 -25.148  10.672  1.00  0.00
ATOM   1007  CD2 TYR    63      -7.089 -24.331  12.963  1.00  0.00
ATOM   1008  HD2 TYR    63      -6.204 -24.733  13.447  1.00  0.00
ATOM   1009  CE1 TYR    63      -9.355 -23.305  11.754  1.00  0.00
ATOM   1010  HE1 TYR    63     -10.241 -22.910  11.279  1.00  0.00
ATOM   1011  CE2 TYR    63      -7.548 -23.074  13.309  1.00  0.00
ATOM   1012  HE2 TYR    63      -7.014 -22.493  14.052  1.00  0.00
ATOM   1013  CZ  TYR    63      -8.674 -22.562  12.699  1.00  0.00
ATOM   1014  OH  TYR    63      -9.124 -21.307  13.039  1.00  0.00
ATOM   1015  HH  TYR    63      -8.371 -20.697  13.085  1.00  0.00
ATOM   1016  C   TYR    63      -5.186 -25.702  10.342  1.00  0.00
ATOM   1017  O   TYR    63      -4.316 -26.004  11.162  1.00  0.00
ATOM   1018  N   GLY    64      -5.066 -24.667   9.493  1.00  0.00
ATOM   1019  HN  GLY    64      -5.752 -24.532   8.814  1.00  0.00
ATOM   1020  CA  GLY    64      -3.939 -23.738   9.559  1.00  0.00
ATOM   1021  HA1 GLY    64      -3.723 -23.383   8.558  1.00  0.00
ATOM   1022  HA2 GLY    64      -3.058 -24.241   9.944  1.00  0.00
ATOM   1023  C   GLY    64      -4.286 -22.551  10.439  1.00  0.00
ATOM   1024  O   GLY    64      -5.040 -21.668  10.015  1.00  0.00
ATOM   1025  N   GLU    65      -3.767 -22.554  11.678  1.00  0.00
ATOM   1026  HN  GLU    65      -3.223 -23.324  11.955  1.00  0.00
ATOM   1027  CA  GLU    65      -3.981 -21.460  12.641  1.00  0.00
ATOM   1028  HA  GLU    65      -4.893 -20.934  12.359  1.00  0.00
ATOM   1029  CB  GLU    65      -4.157 -22.022  14.079  1.00  0.00
ATOM   1030  HB1 GLU    65      -3.276 -22.602  14.337  1.00  0.00
ATOM   1031  HB2 GLU    65      -5.016 -22.682  14.086  1.00  0.00
ATOM   1032  CG  GLU    65      -4.365 -20.940  15.164  1.00  0.00
ATOM   1033  HG1 GLU    65      -5.112 -20.237  14.811  1.00  0.00
ATOM   1034  HG2 GLU    65      -3.430 -20.404  15.301  1.00  0.00
ATOM   1035  CD  GLU    65      -4.810 -21.501  16.529  1.00  0.00
ATOM   1036  OE1 GLU    65      -3.973 -22.103  17.236  1.00  0.00
ATOM   1037  OE2 GLU    65      -5.989 -21.319  16.912  1.00  0.00
ATOM   1038  C   GLU    65      -2.805 -20.484  12.573  1.00  0.00
ATOM   1039  O   GLU    65      -1.716 -20.782  13.081  1.00  0.00
ATOM   1040  N   LEU    66      -3.025 -19.335  11.914  1.00  0.00
ATOM   1041  HN  LEU    66      -3.920 -19.164  11.554  1.00  0.00
ATOM   1042  CA  LEU    66      -1.977 -18.329  11.725  1.00  0.00
ATOM   1043  HA  LEU    66      -1.106 -18.842  11.325  1.00  0.00
ATOM   1044  CB  LEU    66      -2.394 -17.227  10.735  1.00  0.00
ATOM   1045  HB1 LEU    66      -3.212 -16.659  11.175  1.00  0.00
ATOM   1046  HB2 LEU    66      -2.770 -17.702   9.831  1.00  0.00
ATOM   1047  CG  LEU    66      -1.236 -16.235  10.348  1.00  0.00
ATOM   1048  HG  LEU    66      -0.560 -16.154  11.204  1.00  0.00
ATOM   1049  CD1 LEU    66      -0.385 -16.773   9.174  1.00  0.00
ATOM   1050 HD11 LEU    66       0.388 -16.056   8.929  1.00  0.00
ATOM   1051 HD12 LEU    66      -1.017 -16.932   8.304  1.00  0.00
ATOM   1052 HD13 LEU    66       0.076 -17.713   9.455  1.00  0.00
ATOM   1053  CD2 LEU    66      -1.774 -14.828  10.053  1.00  0.00
ATOM   1054 HD21 LEU    66      -2.436 -14.862   9.196  1.00  0.00
ATOM   1055 HD22 LEU    66      -0.950 -14.162   9.843  1.00  0.00
ATOM   1056 HD23 LEU    66      -2.318 -14.458  10.911  1.00  0.00
ATOM   1057  C   LEU    66      -1.596 -17.678  13.066  1.00  0.00
ATOM   1058  O   LEU    66      -2.457 -17.389  13.903  1.00  0.00
ATOM   1059  N   LEU    67      -0.296 -17.458  13.229  1.00  0.00
ATOM   1060  HN  LEU    67       0.304 -17.721  12.501  1.00  0.00
ATOM   1061  CA  LEU    67       0.300 -16.857  14.426  1.00  0.00
ATOM   1062  HA  LEU    67      -0.420 -16.849  15.242  1.00  0.00
ATOM   1063  CB  LEU    67       1.533 -17.710  14.815  1.00  0.00
ATOM   1064  HB1 LEU    67       1.818 -17.465  15.834  1.00  0.00
ATOM   1065  HB2 LEU    67       2.362 -17.437  14.158  1.00  0.00
ATOM   1066  CG  LEU    67       1.325 -19.248  14.715  1.00  0.00
ATOM   1067  HG  LEU    67       0.803 -19.457  13.785  1.00  0.00
ATOM   1068  CD1 LEU    67       2.662 -19.982  14.639  1.00  0.00
ATOM   1069 HD11 LEU    67       3.244 -19.789  15.531  1.00  0.00
ATOM   1070 HD12 LEU    67       3.205 -19.626  13.771  1.00  0.00
ATOM   1071 HD13 LEU    67       2.493 -21.046  14.539  1.00  0.00
ATOM   1072  CD2 LEU    67       0.450 -19.774  15.865  1.00  0.00
ATOM   1073 HD21 LEU    67      -0.520 -19.295  15.822  1.00  0.00
ATOM   1074 HD22 LEU    67       0.919 -19.555  16.815  1.00  0.00
ATOM   1075 HD23 LEU    67       0.324 -20.845  15.765  1.00  0.00
ATOM   1076  C   LEU    67       0.747 -15.437  14.081  1.00  0.00
ATOM   1077  O   LEU    67       0.355 -14.454  14.717  1.00  0.00
ATOM   1078  N   THR    68       1.537 -15.371  13.005  1.00  0.00
ATOM   1079  HN  THR    68       1.670 -16.197  12.483  1.00  0.00
ATOM   1080  CA  THR    68       2.230 -14.158  12.560  1.00  0.00
ATOM   1081  HA  THR    68       1.645 -13.294  12.870  1.00  0.00
ATOM   1082  CB  THR    68       3.651 -14.075  13.235  1.00  0.00
ATOM   1083  HB  THR    68       4.168 -15.016  13.050  1.00  0.00
ATOM   1084  OG1 THR    68       3.499 -13.930  14.661  1.00  0.00
ATOM   1085  HG1 THR    68       3.252 -13.020  14.868  1.00  0.00
ATOM   1086  CG2 THR    68       4.528 -12.927  12.695  1.00  0.00
ATOM   1087 HG21 THR    68       4.726 -13.084  11.641  1.00  0.00
ATOM   1088 HG22 THR    68       5.465 -12.902  13.233  1.00  0.00
ATOM   1089 HG23 THR    68       4.015 -11.981  12.824  1.00  0.00
ATOM   1090  C   THR    68       2.355 -14.164  11.029  1.00  0.00
ATOM   1091  O   THR    68       2.523 -15.218  10.420  1.00  0.00
ATOM   1092  N   ARG    69       2.257 -12.973  10.430  1.00  0.00
ATOM   1093  HN  ARG    69       2.025 -12.200  10.978  1.00  0.00
ATOM   1094  CA  ARG    69       2.482 -12.752   9.001  1.00  0.00
ATOM   1095  HA  ARG    69       3.107 -13.561   8.627  1.00  0.00
ATOM   1096  CB  ARG    69       1.137 -12.746   8.221  1.00  0.00
ATOM   1097  HB1 ARG    69       0.721 -13.750   8.239  1.00  0.00
ATOM   1098  HB2 ARG    69       1.324 -12.469   7.189  1.00  0.00
ATOM   1099  CG  ARG    69       0.092 -11.782   8.808  1.00  0.00
ATOM   1100  HG1 ARG    69       0.529 -10.788   8.858  1.00  0.00
ATOM   1101  HG2 ARG    69      -0.149 -12.105   9.814  1.00  0.00
ATOM   1102  CD  ARG    69      -1.205 -11.704   8.003  1.00  0.00
ATOM   1103  HD1 ARG    69      -1.619 -12.701   7.892  1.00  0.00
ATOM   1104  HD2 ARG    69      -0.986 -11.296   7.020  1.00  0.00
ATOM   1105  NE  ARG    69      -2.195 -10.844   8.682  1.00  0.00
ATOM   1106  HE  ARG    69      -2.097 -10.746   9.658  1.00  0.00
ATOM   1107  CZ  ARG    69      -3.204 -10.199   8.083  1.00  0.00
ATOM   1108  NH1 ARG    69      -3.389 -10.298   6.771  1.00  0.00
ATOM   1109 HH11 ARG    69      -2.775 -10.859   6.216  1.00  0.00
ATOM   1110 HH12 ARG    69      -4.145  -9.809   6.327  1.00  0.00
ATOM   1111  NH2 ARG    69      -4.023  -9.449   8.808  1.00  0.00
ATOM   1112 HH21 ARG    69      -3.895  -9.373   9.800  1.00  0.00
ATOM   1113 HH22 ARG    69      -4.775  -8.947   8.368  1.00  0.00
ATOM   1114  C   ARG    69       3.235 -11.423   8.819  1.00  0.00
ATOM   1115  O   ARG    69       2.846 -10.392   9.386  1.00  0.00
ATOM   1116  N   VAL    70       4.342 -11.464   8.066  1.00  0.00
ATOM   1117  HN  VAL    70       4.627 -12.333   7.703  1.00  0.00
ATOM   1118  CA  VAL    70       5.139 -10.268   7.727  1.00  0.00
ATOM   1119  HA  VAL    70       4.607  -9.388   8.089  1.00  0.00
ATOM   1120  CB  VAL    70       6.573 -10.288   8.399  1.00  0.00
ATOM   1121  HB  VAL    70       7.070  -9.362   8.142  1.00  0.00
ATOM   1122  CG1 VAL    70       6.464 -10.341   9.939  1.00  0.00
ATOM   1123 HG11 VAL    70       5.949 -11.249  10.237  1.00  0.00
ATOM   1124 HG12 VAL    70       5.908  -9.485  10.300  1.00  0.00
ATOM   1125 HG13 VAL    70       7.453 -10.331  10.382  1.00  0.00
ATOM   1126  CG2 VAL    70       7.456 -11.443   7.878  1.00  0.00
ATOM   1127 HG21 VAL    70       7.015 -12.395   8.154  1.00  0.00
ATOM   1128 HG22 VAL    70       8.449 -11.375   8.305  1.00  0.00
ATOM   1129 HG23 VAL    70       7.533 -11.390   6.797  1.00  0.00
ATOM   1130  C   VAL    70       5.254 -10.159   6.205  1.00  0.00
ATOM   1131  O   VAL    70       5.202 -11.171   5.510  1.00  0.00
ATOM   1132  N   ILE    71       5.408  -8.934   5.688  1.00  0.00
ATOM   1133  HN  ILE    71       5.460  -8.167   6.296  1.00  0.00
ATOM   1134  CA  ILE    71       5.504  -8.694   4.237  1.00  0.00
ATOM   1135  HA  ILE    71       5.712  -9.652   3.753  1.00  0.00
ATOM   1136  CB  ILE    71       4.140  -8.162   3.640  1.00  0.00
ATOM   1137  HB  ILE    71       3.419  -8.972   3.729  1.00  0.00
ATOM   1138  CG1 ILE    71       4.286  -7.810   2.124  1.00  0.00
ATOM   1139 HG11 ILE    71       4.695  -8.665   1.597  1.00  0.00
ATOM   1140 HG12 ILE    71       4.961  -6.973   2.010  1.00  0.00
ATOM   1141  CG2 ILE    71       3.573  -6.976   4.453  1.00  0.00
ATOM   1142 HG21 ILE    71       3.444  -7.275   5.485  1.00  0.00
ATOM   1143 HG22 ILE    71       2.614  -6.672   4.050  1.00  0.00
ATOM   1144 HG23 ILE    71       4.260  -6.140   4.406  1.00  0.00
ATOM   1145  CD1 ILE    71       2.987  -7.439   1.443  1.00  0.00
ATOM   1146 HD11 ILE    71       2.543  -6.583   1.935  1.00  0.00
ATOM   1147 HD12 ILE    71       2.301  -8.274   1.484  1.00  0.00
ATOM   1148 HD13 ILE    71       3.185  -7.192   0.410  1.00  0.00
ATOM   1149  C   ILE    71       6.677  -7.743   3.926  1.00  0.00
ATOM   1150  O   ILE    71       6.729  -6.606   4.414  1.00  0.00
ATOM   1151  N   VAL    72       7.647  -8.257   3.143  1.00  0.00
ATOM   1152  HN  VAL    72       7.561  -9.189   2.860  1.00  0.00
ATOM   1153  CA  VAL    72       8.823  -7.508   2.680  1.00  0.00
ATOM   1154  HA  VAL    72       8.838  -6.531   3.166  1.00  0.00
ATOM   1155  CB  VAL    72      10.159  -8.271   3.052  1.00  0.00
ATOM   1156  HB  VAL    72      10.197  -9.188   2.462  1.00  0.00
ATOM   1157  CG1 VAL    72      11.412  -7.431   2.695  1.00  0.00
ATOM   1158 HG11 VAL    72      11.407  -6.504   3.256  1.00  0.00
ATOM   1159 HG12 VAL    72      11.416  -7.203   1.634  1.00  0.00
ATOM   1160 HG13 VAL    72      12.309  -7.988   2.937  1.00  0.00
ATOM   1161  CG2 VAL    72      10.166  -8.680   4.549  1.00  0.00
ATOM   1162 HG21 VAL    72      11.070  -9.230   4.774  1.00  0.00
ATOM   1163 HG22 VAL    72       9.307  -9.308   4.762  1.00  0.00
ATOM   1164 HG23 VAL    72      10.121  -7.794   5.173  1.00  0.00
ATOM   1165  C   VAL    72       8.709  -7.316   1.152  1.00  0.00
ATOM   1166  O   VAL    72       9.061  -8.215   0.377  1.00  0.00
ATOM   1167  N   GLY    73       8.172  -6.154   0.742  1.00  0.00
ATOM   1168  HN  GLY    73       7.902  -5.501   1.421  1.00  0.00
ATOM   1169  CA  GLY    73       7.972  -5.828  -0.676  1.00  0.00
ATOM   1170  HA1 GLY    73       8.932  -5.852  -1.185  1.00  0.00
ATOM   1171  HA2 GLY    73       7.580  -4.822  -0.740  1.00  0.00
ATOM   1172  C   GLY    73       6.996  -6.771  -1.386  1.00  0.00
ATOM   1173  O   GLY    73       5.793  -6.767  -1.097  1.00  0.00
ATOM   1174  N   ASN    74       7.526  -7.594  -2.308  1.00  0.00
ATOM   1175  HN  ASN    74       8.498  -7.567  -2.448  1.00  0.00
ATOM   1176  CA  ASN    74       6.729  -8.548  -3.117  1.00  0.00
ATOM   1177  HA  ASN    74       5.713  -8.166  -3.186  1.00  0.00
ATOM   1178  CB  ASN    74       7.314  -8.665  -4.555  1.00  0.00
ATOM   1179  HB1 ASN    74       7.322  -7.683  -5.010  1.00  0.00
ATOM   1180  HB2 ASN    74       6.675  -9.315  -5.146  1.00  0.00
ATOM   1181  CG  ASN    74       8.750  -9.214  -4.594  1.00  0.00
ATOM   1182  OD1 ASN    74       9.585  -8.891  -3.742  1.00  0.00
ATOM   1183  ND2 ASN    74       9.037 -10.074  -5.557  1.00  0.00
ATOM   1184 HD21 ASN    74       8.325 -10.315  -6.189  1.00  0.00
ATOM   1185 HD22 ASN    74       9.943 -10.438  -5.598  1.00  0.00
ATOM   1186  C   ASN    74       6.680  -9.946  -2.463  1.00  0.00
ATOM   1187  O   ASN    74       6.224 -10.908  -3.082  1.00  0.00
ATOM   1188  N   VAL    75       7.108 -10.034  -1.201  1.00  0.00
ATOM   1189  HN  VAL    75       7.260  -9.199  -0.708  1.00  0.00
ATOM   1190  CA  VAL    75       7.309 -11.315  -0.489  1.00  0.00
ATOM   1191  HA  VAL    75       6.945 -12.129  -1.117  1.00  0.00
ATOM   1192  CB  VAL    75       8.848 -11.555  -0.195  1.00  0.00
ATOM   1193  HB  VAL    75       9.218 -10.684   0.349  1.00  0.00
ATOM   1194  CG1 VAL    75       9.087 -12.801   0.696  1.00  0.00
ATOM   1195 HG11 VAL    75       8.592 -12.672   1.653  1.00  0.00
ATOM   1196 HG12 VAL    75      10.147 -12.937   0.863  1.00  0.00
ATOM   1197 HG13 VAL    75       8.687 -13.683   0.207  1.00  0.00
ATOM   1198  CG2 VAL    75       9.662 -11.661  -1.510  1.00  0.00
ATOM   1199 HG21 VAL    75       9.314 -12.507  -2.091  1.00  0.00
ATOM   1200 HG22 VAL    75      10.714 -11.794  -1.282  1.00  0.00
ATOM   1201 HG23 VAL    75       9.541 -10.755  -2.094  1.00  0.00
ATOM   1202  C   VAL    75       6.515 -11.301   0.828  1.00  0.00
ATOM   1203  O   VAL    75       6.544 -10.301   1.540  1.00  0.00
ATOM   1204  N   VAL    76       5.783 -12.395   1.139  1.00  0.00
ATOM   1205  HN  VAL    76       5.728 -13.126   0.488  1.00  0.00
ATOM   1206  CA  VAL    76       5.064 -12.541   2.428  1.00  0.00
ATOM   1207  HA  VAL    76       5.338 -11.701   3.071  1.00  0.00
ATOM   1208  CB  VAL    76       3.493 -12.528   2.262  1.00  0.00
ATOM   1209  HB  VAL    76       3.200 -13.449   1.754  1.00  0.00
ATOM   1210  CG1 VAL    76       2.783 -12.508   3.646  1.00  0.00
ATOM   1211 HG11 VAL    76       1.711 -12.534   3.510  1.00  0.00
ATOM   1212 HG12 VAL    76       3.049 -11.606   4.184  1.00  0.00
ATOM   1213 HG13 VAL    76       3.086 -13.371   4.232  1.00  0.00
ATOM   1214  CG2 VAL    76       3.019 -11.344   1.389  1.00  0.00
ATOM   1215 HG21 VAL    76       3.486 -11.397   0.411  1.00  0.00
ATOM   1216 HG22 VAL    76       3.288 -10.408   1.859  1.00  0.00
ATOM   1217 HG23 VAL    76       1.945 -11.385   1.269  1.00  0.00
ATOM   1218  C   VAL    76       5.475 -13.854   3.126  1.00  0.00
ATOM   1219  O   VAL    76       5.559 -14.898   2.492  1.00  0.00
ATOM   1220  N   ILE    77       5.734 -13.766   4.433  1.00  0.00
ATOM   1221  HN  ILE    77       5.813 -12.878   4.816  1.00  0.00
ATOM   1222  CA  ILE    77       5.916 -14.910   5.337  1.00  0.00
ATOM   1223  HA  ILE    77       6.176 -15.798   4.765  1.00  0.00
ATOM   1224  CB  ILE    77       7.073 -14.588   6.362  1.00  0.00
ATOM   1225  HB  ILE    77       6.847 -13.610   6.770  1.00  0.00
ATOM   1226  CG1 ILE    77       8.463 -14.486   5.659  1.00  0.00
ATOM   1227 HG11 ILE    77       9.137 -13.928   6.297  1.00  0.00
ATOM   1228 HG12 ILE    77       8.355 -13.959   4.723  1.00  0.00
ATOM   1229  CG2 ILE    77       7.119 -15.560   7.574  1.00  0.00
ATOM   1230 HG21 ILE    77       7.923 -15.265   8.242  1.00  0.00
ATOM   1231 HG22 ILE    77       7.286 -16.571   7.234  1.00  0.00
ATOM   1232 HG23 ILE    77       6.178 -15.513   8.111  1.00  0.00
ATOM   1233  CD1 ILE    77       9.122 -15.813   5.355  1.00  0.00
ATOM   1234 HD11 ILE    77       8.436 -16.442   4.804  1.00  0.00
ATOM   1235 HD12 ILE    77       9.395 -16.301   6.279  1.00  0.00
ATOM   1236 HD13 ILE    77      10.007 -15.641   4.763  1.00  0.00
ATOM   1237  C   ILE    77       4.599 -15.127   6.100  1.00  0.00
ATOM   1238  O   ILE    77       4.265 -14.325   6.974  1.00  0.00
ATOM   1239  N   ASP    78       3.831 -16.161   5.735  1.00  0.00
ATOM   1240  HN  ASP    78       4.024 -16.623   4.895  1.00  0.00
ATOM   1241  CA  ASP    78       2.693 -16.628   6.545  1.00  0.00
ATOM   1242  HA  ASP    78       2.361 -15.800   7.176  1.00  0.00
ATOM   1243  CB  ASP    78       1.495 -17.090   5.663  1.00  0.00
ATOM   1244  HB1 ASP    78       0.808 -17.681   6.263  1.00  0.00
ATOM   1245  HB2 ASP    78       1.871 -17.715   4.859  1.00  0.00
ATOM   1246  CG  ASP    78       0.722 -15.907   5.051  1.00  0.00
ATOM   1247  OD1 ASP    78      -0.279 -15.444   5.664  1.00  0.00
ATOM   1248  OD2 ASP    78       1.123 -15.426   3.972  1.00  0.00
ATOM   1249  C   ASP    78       3.178 -17.755   7.453  1.00  0.00
ATOM   1250  O   ASP    78       3.447 -18.863   6.993  1.00  0.00
ATOM   1251  N   HIS    79       3.324 -17.435   8.743  1.00  0.00
ATOM   1252  HN  HIS    79       3.119 -16.519   9.012  1.00  0.00
ATOM   1253  CA  HIS    79       3.748 -18.381   9.770  1.00  0.00
ATOM   1254  HA  HIS    79       4.225 -19.233   9.284  1.00  0.00
ATOM   1255  CB  HIS    79       4.778 -17.711  10.721  1.00  0.00
ATOM   1256  HB1 HIS    79       4.334 -16.814  11.146  1.00  0.00
ATOM   1257  HB2 HIS    79       5.650 -17.421  10.147  1.00  0.00
ATOM   1258  CG  HIS    79       5.266 -18.576  11.867  1.00  0.00
ATOM   1259  ND1 HIS    79       5.141 -19.954  11.901  1.00  0.00
ATOM   1260  HD1 HIS    79       4.729 -20.508  11.208  1.00  0.00
ATOM   1261  CD2 HIS    79       5.881 -18.238  13.023  1.00  0.00
ATOM   1262  HD2 HIS    79       6.149 -17.237  13.337  1.00  0.00
ATOM   1263  CE1 HIS    79       5.651 -20.417  13.021  1.00  0.00
ATOM   1264  HE1 HIS    79       5.647 -21.450  13.340  1.00  0.00
ATOM   1265  NE2 HIS    79       6.108 -19.397  13.721  1.00  0.00
ATOM   1266  HE2 HIS    79       6.411 -19.446  14.651  1.00  0.00
ATOM   1267  C   HIS    79       2.505 -18.858  10.529  1.00  0.00
ATOM   1268  O   HIS    79       1.921 -18.112  11.330  1.00  0.00
ATOM   1269  N   GLU    80       2.124 -20.108  10.258  1.00  0.00
ATOM   1270  HN  GLU    80       2.686 -20.635   9.644  1.00  0.00
ATOM   1271  CA  GLU    80       0.924 -20.760  10.804  1.00  0.00
ATOM   1272  HA  GLU    80       0.514 -20.115  11.578  1.00  0.00
ATOM   1273  CB  GLU    80      -0.175 -20.959   9.682  1.00  0.00
ATOM   1274  HB1 GLU    80      -0.900 -20.154   9.758  1.00  0.00
ATOM   1275  HB2 GLU    80      -0.700 -21.893   9.862  1.00  0.00
ATOM   1276  CG  GLU    80       0.335 -20.987   8.215  1.00  0.00
ATOM   1277  HG1 GLU    80       0.813 -20.034   8.008  1.00  0.00
ATOM   1278  HG2 GLU    80      -0.520 -21.089   7.549  1.00  0.00
ATOM   1279  CD  GLU    80       1.327 -22.123   7.905  1.00  0.00
ATOM   1280  OE1 GLU    80       0.900 -23.297   7.853  1.00  0.00
ATOM   1281  OE2 GLU    80       2.529 -21.843   7.704  1.00  0.00
ATOM   1282  C   GLU    80       1.303 -22.088  11.480  1.00  0.00
ATOM   1283  O   GLU    80       2.444 -22.541  11.390  1.00  0.00
ATOM   1284  N   THR    81       0.341 -22.666  12.209  1.00  0.00
ATOM   1285  HN  THR    81      -0.501 -22.191  12.319  1.00  0.00
ATOM   1286  CA  THR    81       0.474 -23.983  12.842  1.00  0.00
ATOM   1287  HA  THR    81       1.480 -24.371  12.650  1.00  0.00
ATOM   1288  CB  THR    81       0.261 -23.908  14.389  1.00  0.00
ATOM   1289  HB  THR    81      -0.787 -23.710  14.592  1.00  0.00
ATOM   1290  OG1 THR    81       1.039 -22.837  14.930  1.00  0.00
ATOM   1291  HG1 THR    81       1.976 -23.062  14.888  1.00  0.00
ATOM   1292  CG2 THR    81       0.660 -25.216  15.097  1.00  0.00
ATOM   1293 HG21 THR    81       0.482 -25.123  16.161  1.00  0.00
ATOM   1294 HG22 THR    81       1.711 -25.421  14.928  1.00  0.00
ATOM   1295 HG23 THR    81       0.070 -26.040  14.711  1.00  0.00
ATOM   1296  C   THR    81      -0.563 -24.926  12.218  1.00  0.00
ATOM   1297  O   THR    81      -1.772 -24.750  12.420  1.00  0.00
ATOM   1298  N   VAL    82      -0.083 -25.896  11.437  1.00  0.00
ATOM   1299  HN  VAL    82       0.879 -25.935  11.288  1.00  0.00
ATOM   1300  CA  VAL    82      -0.929 -26.888  10.775  1.00  0.00
ATOM   1301  HA  VAL    82      -1.840 -26.394  10.432  1.00  0.00
ATOM   1302  CB  VAL    82      -0.208 -27.516   9.527  1.00  0.00
ATOM   1303  HB  VAL    82       0.646 -28.088   9.892  1.00  0.00
ATOM   1304  CG1 VAL    82      -1.137 -28.498   8.783  1.00  0.00
ATOM   1305 HG11 VAL    82      -1.435 -29.296   9.457  1.00  0.00
ATOM   1306 HG12 VAL    82      -0.621 -28.927   7.934  1.00  0.00
ATOM   1307 HG13 VAL    82      -2.021 -27.976   8.438  1.00  0.00
ATOM   1308  CG2 VAL    82       0.337 -26.425   8.585  1.00  0.00
ATOM   1309 HG21 VAL    82       0.824 -26.885   7.735  1.00  0.00
ATOM   1310 HG22 VAL    82       1.059 -25.812   9.117  1.00  0.00
ATOM   1311 HG23 VAL    82      -0.475 -25.799   8.238  1.00  0.00
ATOM   1312  C   VAL    82      -1.296 -28.010  11.758  1.00  0.00
ATOM   1313  O   VAL    82      -0.461 -28.864  12.069  1.00  0.00
ATOM   1314  N   THR    83      -2.536 -27.975  12.262  1.00  0.00
ATOM   1315  HN  THR    83      -3.078 -27.181  12.119  1.00  0.00
ATOM   1316  CA  THR    83      -3.105 -29.082  13.035  1.00  0.00
ATOM   1317  HA  THR    83      -2.412 -29.323  13.839  1.00  0.00
ATOM   1318  CB  THR    83      -4.481 -28.685  13.668  1.00  0.00
ATOM   1319  HB  THR    83      -5.160 -28.404  12.867  1.00  0.00
ATOM   1320  OG1 THR    83      -4.309 -27.544  14.529  1.00  0.00
ATOM   1321  HG1 THR    83      -3.679 -26.932  14.133  1.00  0.00
ATOM   1322  CG2 THR    83      -5.123 -29.845  14.468  1.00  0.00
ATOM   1323 HG21 THR    83      -4.452 -30.164  15.257  1.00  0.00
ATOM   1324 HG22 THR    83      -5.319 -30.683  13.809  1.00  0.00
ATOM   1325 HG23 THR    83      -6.058 -29.516  14.906  1.00  0.00
ATOM   1326  C   THR    83      -3.273 -30.305  12.114  1.00  0.00
ATOM   1327  O   THR    83      -3.958 -30.228  11.087  1.00  0.00
ATOM   1328  N   ARG    84      -2.578 -31.394  12.467  1.00  0.00
ATOM   1329  HN  ARG    84      -1.972 -31.324  13.232  1.00  0.00
ATOM   1330  CA  ARG    84      -2.657 -32.694  11.781  1.00  0.00
ATOM   1331  HA  ARG    84      -3.432 -32.655  11.018  1.00  0.00
ATOM   1332  CB  ARG    84      -1.281 -33.031  11.121  1.00  0.00
ATOM   1333  HB1 ARG    84      -1.383 -33.960  10.565  1.00  0.00
ATOM   1334  HB2 ARG    84      -0.548 -33.183  11.909  1.00  0.00
ATOM   1335  CG  ARG    84      -0.732 -31.946  10.157  1.00  0.00
ATOM   1336  HG1 ARG    84      -0.660 -31.004  10.698  1.00  0.00
ATOM   1337  HG2 ARG    84      -1.423 -31.826   9.334  1.00  0.00
ATOM   1338  CD  ARG    84       0.658 -32.295   9.587  1.00  0.00
ATOM   1339  HD1 ARG    84       0.579 -33.224   9.033  1.00  0.00
ATOM   1340  HD2 ARG    84       1.346 -32.434  10.413  1.00  0.00
ATOM   1341  NE  ARG    84       1.205 -31.246   8.692  1.00  0.00
ATOM   1342  HE  ARG    84       0.848 -30.336   8.810  1.00  0.00
ATOM   1343  CZ  ARG    84       2.180 -31.435   7.775  1.00  0.00
ATOM   1344  NH1 ARG    84       2.668 -32.650   7.536  1.00  0.00
ATOM   1345 HH11 ARG    84       2.318 -33.441   8.044  1.00  0.00
ATOM   1346 HH12 ARG    84       3.395 -32.782   6.857  1.00  0.00
ATOM   1347  NH2 ARG    84       2.654 -30.397   7.089  1.00  0.00
ATOM   1348 HH21 ARG    84       2.292 -29.477   7.252  1.00  0.00
ATOM   1349 HH22 ARG    84       3.387 -30.528   6.414  1.00  0.00
ATOM   1350  C   ARG    84      -3.039 -33.762  12.825  1.00  0.00
ATOM   1351  O   ARG    84      -3.453 -33.417  13.938  1.00  0.00
ATOM   1352  N   ASN    85      -2.949 -35.050  12.453  1.00  0.00
ATOM   1353  HN  ASN    85      -2.807 -35.252  11.503  1.00  0.00
ATOM   1354  CA  ASN    85      -3.068 -36.183  13.401  1.00  0.00
ATOM   1355  HA  ASN    85      -3.227 -35.777  14.401  1.00  0.00
ATOM   1356  CB  ASN    85      -4.278 -37.105  13.042  1.00  0.00
ATOM   1357  HB1 ASN    85      -4.060 -38.119  13.370  1.00  0.00
ATOM   1358  HB2 ASN    85      -4.403 -37.118  11.968  1.00  0.00
ATOM   1359  CG  ASN    85      -5.617 -36.685  13.664  1.00  0.00
ATOM   1360  OD1 ASN    85      -6.453 -37.533  13.983  1.00  0.00
ATOM   1361  ND2 ASN    85      -5.859 -35.394  13.817  1.00  0.00
ATOM   1362 HD21 ASN    85      -5.182 -34.752  13.529  1.00  0.00
ATOM   1363 HD22 ASN    85      -6.711 -35.132  14.223  1.00  0.00
ATOM   1364  C   ASN    85      -1.755 -36.982  13.410  1.00  0.00
ATOM   1365  O   ASN    85      -1.404 -37.632  12.418  1.00  0.00
ATOM   1366  N   PHE    86      -1.007 -36.881  14.523  1.00  0.00
ATOM   1367  HN  PHE    86      -1.294 -36.250  15.215  1.00  0.00
ATOM   1368  CA  PHE    86       0.217 -37.682  14.766  1.00  0.00
ATOM   1369  HA  PHE    86       0.519 -38.136  13.820  1.00  0.00
ATOM   1370  CB  PHE    86       1.375 -36.779  15.290  1.00  0.00
ATOM   1371  HB1 PHE    86       2.135 -37.406  15.746  1.00  0.00
ATOM   1372  HB2 PHE    86       0.983 -36.113  16.047  1.00  0.00
ATOM   1373  CG  PHE    86       2.077 -35.904  14.242  1.00  0.00
ATOM   1374  CD1 PHE    86       3.156 -35.097  14.611  1.00  0.00
ATOM   1375  HD1 PHE    86       3.492 -35.097  15.642  1.00  0.00
ATOM   1376  CD2 PHE    86       1.674 -35.879  12.903  1.00  0.00
ATOM   1377  HD2 PHE    86       0.841 -36.492  12.584  1.00  0.00
ATOM   1378  CE1 PHE    86       3.798 -34.301  13.681  1.00  0.00
ATOM   1379  HE1 PHE    86       4.630 -33.680  13.983  1.00  0.00
ATOM   1380  CE2 PHE    86       2.321 -35.081  11.980  1.00  0.00
ATOM   1381  HE2 PHE    86       1.997 -35.076  10.951  1.00  0.00
ATOM   1382  CZ  PHE    86       3.381 -34.297  12.368  1.00  0.00
ATOM   1383  HZ  PHE    86       3.888 -33.670  11.641  1.00  0.00
ATOM   1384  C   PHE    86      -0.083 -38.813  15.772  1.00  0.00
ATOM   1385  O   PHE    86      -0.908 -38.631  16.671  1.00  0.00
ATOM   1386  N   PRO    87       0.586 -40.007  15.644  1.00  0.00
ATOM   1387  CA  PRO    87       0.304 -41.188  16.506  1.00  0.00
ATOM   1388  HA  PRO    87      -0.753 -41.430  16.487  1.00  0.00
ATOM   1389  CB  PRO    87       1.090 -42.324  15.810  1.00  0.00
ATOM   1390  HB1 PRO    87       0.450 -42.828  15.088  1.00  0.00
ATOM   1391  HB2 PRO    87       1.439 -43.050  16.538  1.00  0.00
ATOM   1392  CG  PRO    87       2.225 -41.625  15.135  1.00  0.00
ATOM   1393  HG1 PRO    87       2.594 -42.216  14.303  1.00  0.00
ATOM   1394  HG2 PRO    87       3.031 -41.449  15.847  1.00  0.00
ATOM   1395  CD  PRO    87       1.650 -40.316  14.643  1.00  0.00
ATOM   1396  HD1 PRO    87       1.221 -40.430  13.654  1.00  0.00
ATOM   1397  HD2 PRO    87       2.411 -39.543  14.634  1.00  0.00
ATOM   1398  C   PRO    87       0.735 -41.013  17.986  1.00  0.00
ATOM   1399  O   PRO    87       0.406 -41.861  18.826  1.00  0.00
ATOM   1400  N   GLU    88       1.487 -39.932  18.296  1.00  0.00
ATOM   1401  HN  GLU    88       1.811 -39.361  17.568  1.00  0.00
ATOM   1402  CA  GLU    88       1.846 -39.587  19.694  1.00  0.00
ATOM   1403  HA  GLU    88       1.801 -40.508  20.274  1.00  0.00
ATOM   1404  CB  GLU    88       3.298 -39.019  19.810  1.00  0.00
ATOM   1405  HB1 GLU    88       3.992 -39.824  19.590  1.00  0.00
ATOM   1406  HB2 GLU    88       3.468 -38.713  20.839  1.00  0.00
ATOM   1407  CG  GLU    88       3.637 -37.816  18.889  1.00  0.00
ATOM   1408  HG1 GLU    88       4.235 -37.099  19.455  1.00  0.00
ATOM   1409  HG2 GLU    88       2.711 -37.325  18.599  1.00  0.00
ATOM   1410  CD  GLU    88       4.401 -38.201  17.607  1.00  0.00
ATOM   1411  OE1 GLU    88       3.776 -38.731  16.671  1.00  0.00
ATOM   1412  OE2 GLU    88       5.635 -37.981  17.541  1.00  0.00
ATOM   1413  C   GLU    88       0.823 -38.610  20.322  1.00  0.00
ATOM   1414  O   GLU    88       0.815 -38.439  21.545  1.00  0.00
ATOM   1415  N   GLY    89      -0.036 -37.962  19.498  1.00  0.00
ATOM   1416  HN  GLY    89       0.070 -38.056  18.526  1.00  0.00
ATOM   1417  CA  GLY    89      -1.120 -37.115  20.036  1.00  0.00
ATOM   1418  HA1 GLY    89      -0.733 -36.528  20.864  1.00  0.00
ATOM   1419  HA2 GLY    89      -1.902 -37.760  20.417  1.00  0.00
ATOM   1420  C   GLY    89      -1.738 -36.173  19.008  1.00  0.00
ATOM   1421  O   GLY    89      -2.265 -36.634  17.995  1.00  0.00
ATOM   1422  N   LYS    90      -1.688 -34.849  19.296  1.00  0.00
ATOM   1423  HN  LYS    90      -1.292 -34.580  20.148  1.00  0.00
ATOM   1424  CA  LYS    90      -2.228 -33.784  18.429  1.00  0.00
ATOM   1425  HA  LYS    90      -3.308 -33.929  18.384  1.00  0.00
ATOM   1426  CB  LYS    90      -1.953 -32.399  19.091  1.00  0.00
ATOM   1427  HB1 LYS    90      -0.889 -32.329  19.303  1.00  0.00
ATOM   1428  HB2 LYS    90      -2.482 -32.361  20.036  1.00  0.00
ATOM   1429  CG  LYS    90      -2.358 -31.147  18.270  1.00  0.00
ATOM   1430  HG1 LYS    90      -1.761 -31.127  17.361  1.00  0.00
ATOM   1431  HG2 LYS    90      -2.120 -30.263  18.854  1.00  0.00
ATOM   1432  CD  LYS    90      -3.857 -31.081  17.883  1.00  0.00
ATOM   1433  HD1 LYS    90      -4.078 -31.901  17.205  1.00  0.00
ATOM   1434  HD2 LYS    90      -4.036 -30.146  17.364  1.00  0.00
ATOM   1435  CE  LYS    90      -4.812 -31.157  19.088  1.00  0.00
ATOM   1436  HE1 LYS    90      -4.460 -30.494  19.864  1.00  0.00
ATOM   1437  HE2 LYS    90      -4.825 -32.172  19.468  1.00  0.00
ATOM   1438  NZ  LYS    90      -6.199 -30.777  18.717  1.00  0.00
ATOM   1439  HZ1 LYS    90      -6.576 -31.434  18.006  1.00  0.00
ATOM   1440  HZ2 LYS    90      -6.210 -29.813  18.321  1.00  0.00
ATOM   1441  HZ3 LYS    90      -6.816 -30.796  19.553  1.00  0.00
ATOM   1442  C   LYS    90      -1.669 -33.871  16.986  1.00  0.00
ATOM   1443  O   LYS    90      -2.296 -34.497  16.132  1.00  0.00
ATOM   1444  N   GLY    91      -0.478 -33.289  16.736  1.00  0.00
ATOM   1445  HN  GLY    91       0.003 -32.854  17.467  1.00  0.00
ATOM   1446  CA  GLY    91       0.113 -33.291  15.396  1.00  0.00
ATOM   1447  HA1 GLY    91      -0.475 -33.914  14.730  1.00  0.00
ATOM   1448  HA2 GLY    91       1.103 -33.721  15.472  1.00  0.00
ATOM   1449  C   GLY    91       0.249 -31.907  14.791  1.00  0.00
ATOM   1450  O   GLY    91       0.259 -31.760  13.567  1.00  0.00
ATOM   1451  N   GLU    92       0.402 -30.891  15.643  1.00  0.00
ATOM   1452  HN  GLU    92       0.538 -31.090  16.594  1.00  0.00
ATOM   1453  CA  GLU    92       0.411 -29.488  15.201  1.00  0.00
ATOM   1454  HA  GLU    92      -0.198 -29.405  14.301  1.00  0.00
ATOM   1455  CB  GLU    92      -0.210 -28.587  16.309  1.00  0.00
ATOM   1456  HB1 GLU    92      -1.247 -28.882  16.459  1.00  0.00
ATOM   1457  HB2 GLU    92      -0.200 -27.559  15.966  1.00  0.00
ATOM   1458  CG  GLU    92       0.511 -28.654  17.679  1.00  0.00
ATOM   1459  HG1 GLU    92       1.559 -28.392  17.534  1.00  0.00
ATOM   1460  HG2 GLU    92       0.465 -29.680  18.035  1.00  0.00
ATOM   1461  CD  GLU    92      -0.076 -27.730  18.754  1.00  0.00
ATOM   1462  OE1 GLU    92      -0.596 -28.231  19.775  1.00  0.00
ATOM   1463  OE2 GLU    92       0.010 -26.494  18.591  1.00  0.00
ATOM   1464  C   GLU    92       1.855 -29.069  14.862  1.00  0.00
ATOM   1465  O   GLU    92       2.758 -29.163  15.701  1.00  0.00
ATOM   1466  N   VAL    93       2.091 -28.670  13.592  1.00  0.00
ATOM   1467  HN  VAL    93       1.333 -28.599  12.963  1.00  0.00
ATOM   1468  CA  VAL    93       3.437 -28.330  13.109  1.00  0.00
ATOM   1469  HA  VAL    93       4.136 -28.473  13.938  1.00  0.00
ATOM   1470  CB  VAL    93       3.893 -29.287  11.940  1.00  0.00
ATOM   1471  HB  VAL    93       4.913 -29.019  11.665  1.00  0.00
ATOM   1472  CG1 VAL    93       3.922 -30.751  12.432  1.00  0.00
ATOM   1473 HG11 VAL    93       2.920 -31.068  12.705  1.00  0.00
ATOM   1474 HG12 VAL    93       4.560 -30.833  13.302  1.00  0.00
ATOM   1475 HG13 VAL    93       4.300 -31.398  11.653  1.00  0.00
ATOM   1476  CG2 VAL    93       3.006 -29.154  10.680  1.00  0.00
ATOM   1477 HG21 VAL    93       1.980 -29.407  10.925  1.00  0.00
ATOM   1478 HG22 VAL    93       3.360 -29.821   9.903  1.00  0.00
ATOM   1479 HG23 VAL    93       3.042 -28.135  10.314  1.00  0.00
ATOM   1480  C   VAL    93       3.493 -26.853  12.707  1.00  0.00
ATOM   1481  O   VAL    93       2.693 -26.383  11.896  1.00  0.00
ATOM   1482  N   ASP    94       4.421 -26.119  13.325  1.00  0.00
ATOM   1483  HN  ASP    94       5.019 -26.570  13.963  1.00  0.00
ATOM   1484  CA  ASP    94       4.590 -24.676  13.099  1.00  0.00
ATOM   1485  HA  ASP    94       3.610 -24.233  12.925  1.00  0.00
ATOM   1486  CB  ASP    94       5.220 -24.007  14.345  1.00  0.00
ATOM   1487  HB1 ASP    94       5.388 -22.954  14.128  1.00  0.00
ATOM   1488  HB2 ASP    94       6.183 -24.469  14.550  1.00  0.00
ATOM   1489  CG  ASP    94       4.342 -24.122  15.607  1.00  0.00
ATOM   1490  OD1 ASP    94       4.199 -25.244  16.141  1.00  0.00
ATOM   1491  OD2 ASP    94       3.815 -23.093  16.083  1.00  0.00
ATOM   1492  C   ASP    94       5.467 -24.462  11.857  1.00  0.00
ATOM   1493  O   ASP    94       6.667 -24.705  11.899  1.00  0.00
ATOM   1494  N   VAL    95       4.844 -24.006  10.764  1.00  0.00
ATOM   1495  HN  VAL    95       3.900 -23.767  10.842  1.00  0.00
ATOM   1496  CA  VAL    95       5.474 -23.850   9.440  1.00  0.00
ATOM   1497  HA  VAL    95       6.475 -24.278   9.461  1.00  0.00
ATOM   1498  CB  VAL    95       4.616 -24.600   8.339  1.00  0.00
ATOM   1499  HB  VAL    95       3.704 -24.046   8.214  1.00  0.00
ATOM   1500  CG1 VAL    95       5.309 -24.625   6.956  1.00  0.00
ATOM   1501 HG11 VAL    95       5.489 -23.609   6.618  1.00  0.00
ATOM   1502 HG12 VAL    95       4.680 -25.130   6.235  1.00  0.00
ATOM   1503 HG13 VAL    95       6.254 -25.146   7.033  1.00  0.00
ATOM   1504  CG2 VAL    95       4.215 -26.020   8.799  1.00  0.00
ATOM   1505 HG21 VAL    95       3.629 -25.959   9.713  1.00  0.00
ATOM   1506 HG22 VAL    95       5.102 -26.609   8.986  1.00  0.00
ATOM   1507 HG23 VAL    95       3.621 -26.503   8.031  1.00  0.00
ATOM   1508  C   VAL    95       5.557 -22.353   9.085  1.00  0.00
ATOM   1509  O   VAL    95       4.736 -21.559   9.544  1.00  0.00
ATOM   1510  N   ALA    96       6.583 -21.973   8.314  1.00  0.00
ATOM   1511  HN  ALA    96       7.309 -22.602   8.168  1.00  0.00
ATOM   1512  CA  ALA    96       6.671 -20.654   7.672  1.00  0.00
ATOM   1513  HA  ALA    96       5.835 -20.037   8.010  1.00  0.00
ATOM   1514  CB  ALA    96       7.980 -19.942   8.058  1.00  0.00
ATOM   1515  HB1 ALA    96       8.015 -19.803   9.132  1.00  0.00
ATOM   1516  HB2 ALA    96       8.025 -18.974   7.577  1.00  0.00
ATOM   1517  HB3 ALA    96       8.833 -20.535   7.748  1.00  0.00
ATOM   1518  C   ALA    96       6.565 -20.844   6.153  1.00  0.00
ATOM   1519  O   ALA    96       7.519 -21.300   5.508  1.00  0.00
ATOM   1520  N   CYS    97       5.387 -20.537   5.597  1.00  0.00
ATOM   1521  HN  CYS    97       4.653 -20.258   6.180  1.00  0.00
ATOM   1522  CA  CYS    97       5.136 -20.600   4.158  1.00  0.00
ATOM   1523  HA  CYS    97       5.833 -21.314   3.713  1.00  0.00
ATOM   1524  CB  CYS    97       3.695 -21.078   3.890  1.00  0.00
ATOM   1525  HB1 CYS    97       3.517 -21.101   2.822  1.00  0.00
ATOM   1526  HB2 CYS    97       2.997 -20.395   4.352  1.00  0.00
ATOM   1527  SG  CYS    97       3.345 -22.732   4.533  1.00  0.00
ATOM   1528  HG  CYS    97       2.775 -22.594   5.722  1.00  0.00
ATOM   1529  C   CYS    97       5.387 -19.209   3.562  1.00  0.00
ATOM   1530  O   CYS    97       4.641 -18.262   3.822  1.00  0.00
ATOM   1531  N   ILE    98       6.480 -19.101   2.804  1.00  0.00
ATOM   1532  HN  ILE    98       7.002 -19.913   2.642  1.00  0.00
ATOM   1533  CA  ILE    98       6.934 -17.849   2.180  1.00  0.00
ATOM   1534  HA  ILE    98       6.455 -17.017   2.702  1.00  0.00
ATOM   1535  CB  ILE    98       8.501 -17.678   2.336  1.00  0.00
ATOM   1536  HB  ILE    98       8.687 -17.488   3.387  1.00  0.00
ATOM   1537  CG1 ILE    98       9.025 -16.440   1.527  1.00  0.00
ATOM   1538 HG11 ILE    98       8.550 -15.545   1.910  1.00  0.00
ATOM   1539 HG12 ILE    98       8.756 -16.554   0.485  1.00  0.00
ATOM   1540  CG2 ILE    98       9.270 -18.977   1.998  1.00  0.00
ATOM   1541 HG21 ILE    98      10.334 -18.829   2.137  1.00  0.00
ATOM   1542 HG22 ILE    98       9.081 -19.261   0.972  1.00  0.00
ATOM   1543 HG23 ILE    98       8.935 -19.778   2.650  1.00  0.00
ATOM   1544  CD1 ILE    98      10.530 -16.210   1.574  1.00  0.00
ATOM   1545 HD11 ILE    98      11.047 -17.061   1.148  1.00  0.00
ATOM   1546 HD12 ILE    98      10.849 -16.068   2.596  1.00  0.00
ATOM   1547 HD13 ILE    98      10.770 -15.325   1.000  1.00  0.00
ATOM   1548  C   ILE    98       6.500 -17.817   0.702  1.00  0.00
ATOM   1549  O   ILE    98       6.639 -18.801  -0.012  1.00  0.00
ATOM   1550  N   TYR    99       5.959 -16.675   0.255  1.00  0.00
ATOM   1551  HN  TYR    99       5.921 -15.917   0.861  1.00  0.00
ATOM   1552  CA  TYR    99       5.429 -16.498  -1.110  1.00  0.00
ATOM   1553  HA  TYR    99       5.624 -17.406  -1.680  1.00  0.00
ATOM   1554  CB  TYR    99       3.895 -16.233  -1.087  1.00  0.00
ATOM   1555  HB1 TYR    99       3.512 -16.290  -2.104  1.00  0.00
ATOM   1556  HB2 TYR    99       3.708 -15.233  -0.706  1.00  0.00
ATOM   1557  CG  TYR    99       3.089 -17.221  -0.227  1.00  0.00
ATOM   1558  CD1 TYR    99       2.606 -18.425  -0.749  1.00  0.00
ATOM   1559  HD1 TYR    99       2.793 -18.660  -1.787  1.00  0.00
ATOM   1560  CD2 TYR    99       2.826 -16.947   1.118  1.00  0.00
ATOM   1561  HD2 TYR    99       3.189 -16.020   1.550  1.00  0.00
ATOM   1562  CE1 TYR    99       1.893 -19.310   0.036  1.00  0.00
ATOM   1563  HE1 TYR    99       1.530 -20.238  -0.389  1.00  0.00
ATOM   1564  CE2 TYR    99       2.112 -17.830   1.902  1.00  0.00
ATOM   1565  HE2 TYR    99       1.922 -17.591   2.943  1.00  0.00
ATOM   1566  CZ  TYR    99       1.647 -19.007   1.361  1.00  0.00
ATOM   1567  OH  TYR    99       0.941 -19.891   2.150  1.00  0.00
ATOM   1568  HH  TYR    99       0.481 -19.401   2.843  1.00  0.00
ATOM   1569  C   TYR    99       6.133 -15.323  -1.793  1.00  0.00
ATOM   1570  O   TYR    99       6.636 -14.416  -1.131  1.00  0.00
ATOM   1571  N   GLU   100       6.140 -15.362  -3.120  1.00  0.00
ATOM   1572  HN  GLU   100       5.799 -16.168  -3.552  1.00  0.00
ATOM   1573  CA  GLU   100       6.635 -14.292  -3.986  1.00  0.00
ATOM   1574  HA  GLU   100       6.837 -13.403  -3.389  1.00  0.00
ATOM   1575  CB  GLU   100       7.924 -14.756  -4.689  1.00  0.00
ATOM   1576  HB1 GLU   100       7.710 -15.675  -5.228  1.00  0.00
ATOM   1577  HB2 GLU   100       8.666 -14.976  -3.929  1.00  0.00
ATOM   1578  CG  GLU   100       8.539 -13.747  -5.672  1.00  0.00
ATOM   1579  HG1 GLU   100       9.022 -12.957  -5.104  1.00  0.00
ATOM   1580  HG2 GLU   100       7.746 -13.305  -6.273  1.00  0.00
ATOM   1581  CD  GLU   100       9.573 -14.401  -6.605  1.00  0.00
ATOM   1582  OE1 GLU   100      10.791 -14.386  -6.294  1.00  0.00
ATOM   1583  OE2 GLU   100       9.166 -14.934  -7.661  1.00  0.00
ATOM   1584  C   GLU   100       5.548 -13.992  -5.020  1.00  0.00
ATOM   1585  O   GLU   100       5.161 -14.879  -5.779  1.00  0.00
ATOM   1586  N   VAL   101       5.052 -12.755  -5.023  1.00  0.00
ATOM   1587  HN  VAL   101       5.439 -12.110  -4.407  1.00  0.00
ATOM   1588  CA  VAL   101       3.972 -12.303  -5.902  1.00  0.00
ATOM   1589  HA  VAL   101       3.516 -13.172  -6.376  1.00  0.00
ATOM   1590  CB  VAL   101       2.862 -11.562  -5.069  1.00  0.00
ATOM   1591  HB  VAL   101       3.329 -10.703  -4.590  1.00  0.00
ATOM   1592  CG1 VAL   101       1.715 -11.036  -5.970  1.00  0.00
ATOM   1593 HG11 VAL   101       1.243 -11.864  -6.486  1.00  0.00
ATOM   1594 HG12 VAL   101       2.108 -10.340  -6.704  1.00  0.00
ATOM   1595 HG13 VAL   101       0.975 -10.526  -5.364  1.00  0.00
ATOM   1596  CG2 VAL   101       2.309 -12.478  -3.948  1.00  0.00
ATOM   1597 HG21 VAL   101       1.829 -13.343  -4.391  1.00  0.00
ATOM   1598 HG22 VAL   101       1.583 -11.934  -3.354  1.00  0.00
ATOM   1599 HG23 VAL   101       3.117 -12.808  -3.305  1.00  0.00
ATOM   1600  C   VAL   101       4.542 -11.376  -6.989  1.00  0.00
ATOM   1601  O   VAL   101       5.094 -10.313  -6.680  1.00  0.00
ATOM   1602  N   GLU   102       4.414 -11.797  -8.255  1.00  0.00
ATOM   1603  HN  GLU   102       4.015 -12.676  -8.413  1.00  0.00
ATOM   1604  CA  GLU   102       4.833 -11.014  -9.426  1.00  0.00
ATOM   1605  HA  GLU   102       5.103 -10.015  -9.088  1.00  0.00
ATOM   1606  CB  GLU   102       6.062 -11.670 -10.097  1.00  0.00
ATOM   1607  HB1 GLU   102       5.778 -12.660 -10.438  1.00  0.00
ATOM   1608  HB2 GLU   102       6.847 -11.774  -9.356  1.00  0.00
ATOM   1609  CG  GLU   102       6.631 -10.893 -11.295  1.00  0.00
ATOM   1610  HG1 GLU   102       6.831  -9.871 -10.984  1.00  0.00
ATOM   1611  HG2 GLU   102       5.880 -10.874 -12.075  1.00  0.00
ATOM   1612  CD  GLU   102       7.921 -11.503 -11.871  1.00  0.00
ATOM   1613  OE1 GLU   102       7.840 -12.466 -12.663  1.00  0.00
ATOM   1614  OE2 GLU   102       9.026 -11.036 -11.517  1.00  0.00
ATOM   1615  C   GLU   102       3.654 -10.904 -10.411  1.00  0.00
ATOM   1616  O   GLU   102       2.986 -11.901 -10.698  1.00  0.00
ATOM   1617  N   ASN   103       3.415  -9.671 -10.900  1.00  0.00
ATOM   1618  HN  ASN   103       4.039  -8.959 -10.649  1.00  0.00
ATOM   1619  CA  ASN   103       2.282  -9.312 -11.789  1.00  0.00
ATOM   1620  HA  ASN   103       2.366  -8.247 -11.968  1.00  0.00
ATOM   1621  CB  ASN   103       2.369 -10.049 -13.169  1.00  0.00
ATOM   1622  HB1 ASN   103       1.503  -9.781 -13.766  1.00  0.00
ATOM   1623  HB2 ASN   103       2.346 -11.118 -12.998  1.00  0.00
ATOM   1624  CG  ASN   103       3.638  -9.702 -13.971  1.00  0.00
ATOM   1625  OD1 ASN   103       3.676  -8.714 -14.704  1.00  0.00
ATOM   1626  ND2 ASN   103       4.669 -10.528 -13.866  1.00  0.00
ATOM   1627 HD21 ASN   103       4.576 -11.319 -13.290  1.00  0.00
ATOM   1628 HD22 ASN   103       5.485 -10.318 -14.365  1.00  0.00
ATOM   1629  C   ASN   103       0.907  -9.560 -11.102  1.00  0.00
ATOM   1630  O   ASN   103      -0.110  -9.771 -11.776  1.00  0.00
ATOM   1631  N   GLY   104       0.884  -9.459  -9.754  1.00  0.00
ATOM   1632  HN  GLY   104       1.727  -9.269  -9.290  1.00  0.00
ATOM   1633  CA  GLY   104      -0.350  -9.611  -8.961  1.00  0.00
ATOM   1634  HA1 GLY   104      -1.184  -9.203  -9.520  1.00  0.00
ATOM   1635  HA2 GLY   104      -0.237  -9.035  -8.053  1.00  0.00
ATOM   1636  C   GLY   104      -0.682 -11.057  -8.573  1.00  0.00
ATOM   1637  O   GLY   104      -1.597 -11.294  -7.775  1.00  0.00
ATOM   1638  N   ARG   105       0.078 -12.022  -9.117  1.00  0.00
ATOM   1639  HN  ARG   105       0.847 -11.758  -9.666  1.00  0.00
ATOM   1640  CA  ARG   105      -0.132 -13.466  -8.876  1.00  0.00
ATOM   1641  HA  ARG   105      -0.949 -13.597  -8.168  1.00  0.00
ATOM   1642  CB  ARG   105      -0.469 -14.204 -10.201  1.00  0.00
ATOM   1643  HB1 ARG   105      -0.617 -15.260  -9.986  1.00  0.00
ATOM   1644  HB2 ARG   105       0.373 -14.106 -10.876  1.00  0.00
ATOM   1645  CG  ARG   105      -1.723 -13.684 -10.940  1.00  0.00
ATOM   1646  HG1 ARG   105      -1.778 -14.170 -11.911  1.00  0.00
ATOM   1647  HG2 ARG   105      -1.617 -12.616 -11.093  1.00  0.00
ATOM   1648  CD  ARG   105      -3.043 -13.942 -10.190  1.00  0.00
ATOM   1649  HD1 ARG   105      -2.951 -13.596  -9.168  1.00  0.00
ATOM   1650  HD2 ARG   105      -3.248 -15.009 -10.193  1.00  0.00
ATOM   1651  NE  ARG   105      -4.156 -13.215 -10.838  1.00  0.00
ATOM   1652  HE  ARG   105      -3.928 -12.348 -11.233  1.00  0.00
ATOM   1653  CZ  ARG   105      -5.432 -13.615 -10.931  1.00  0.00
ATOM   1654  NH1 ARG   105      -5.830 -14.779 -10.457  1.00  0.00
ATOM   1655 HH11 ARG   105      -5.176 -15.394 -10.017  1.00  0.00
ATOM   1656 HH12 ARG   105      -6.792 -15.061 -10.546  1.00  0.00
ATOM   1657  NH2 ARG   105      -6.311 -12.827 -11.526  1.00  0.00
ATOM   1658 HH21 ARG   105      -6.021 -11.944 -11.902  1.00  0.00
ATOM   1659 HH22 ARG   105      -7.269 -13.112 -11.617  1.00  0.00
ATOM   1660  C   ARG   105       1.146 -14.039  -8.272  1.00  0.00
ATOM   1661  O   ARG   105       2.232 -13.543  -8.565  1.00  0.00
ATOM   1662  N   ILE   106       1.022 -15.070  -7.430  1.00  0.00
ATOM   1663  HN  ILE   106       0.127 -15.399  -7.216  1.00  0.00
ATOM   1664  CA  ILE   106       2.186 -15.718  -6.820  1.00  0.00
ATOM   1665  HA  ILE   106       2.800 -14.933  -6.371  1.00  0.00
ATOM   1666  CB  ILE   106       1.775 -16.720  -5.683  1.00  0.00
ATOM   1667  HB  ILE   106       1.107 -17.458  -6.117  1.00  0.00
ATOM   1668  CG1 ILE   106       1.012 -15.962  -4.557  1.00  0.00
ATOM   1669 HG11 ILE   106       0.097 -15.544  -4.965  1.00  0.00
ATOM   1670 HG12 ILE   106       1.631 -15.156  -4.189  1.00  0.00
ATOM   1671  CG2 ILE   106       3.001 -17.477  -5.105  1.00  0.00
ATOM   1672 HG21 ILE   106       3.696 -16.769  -4.671  1.00  0.00
ATOM   1673 HG22 ILE   106       3.498 -18.025  -5.896  1.00  0.00
ATOM   1674 HG23 ILE   106       2.677 -18.174  -4.342  1.00  0.00
ATOM   1675  CD1 ILE   106       0.637 -16.813  -3.369  1.00  0.00
ATOM   1676 HD11 ILE   106       0.046 -17.658  -3.701  1.00  0.00
ATOM   1677 HD12 ILE   106       0.058 -16.222  -2.674  1.00  0.00
ATOM   1678 HD13 ILE   106       1.531 -17.170  -2.877  1.00  0.00
ATOM   1679  C   ILE   106       3.015 -16.423  -7.904  1.00  0.00
ATOM   1680  O   ILE   106       2.582 -17.414  -8.479  1.00  0.00
ATOM   1681  N   ALA   107       4.199 -15.862  -8.177  1.00  0.00
ATOM   1682  HN  ALA   107       4.455 -15.062  -7.676  1.00  0.00
ATOM   1683  CA  ALA   107       5.130 -16.371  -9.187  1.00  0.00
ATOM   1684  HA  ALA   107       4.568 -16.617 -10.084  1.00  0.00
ATOM   1685  CB  ALA   107       6.154 -15.279  -9.543  1.00  0.00
ATOM   1686  HB1 ALA   107       5.640 -14.397  -9.917  1.00  0.00
ATOM   1687  HB2 ALA   107       6.832 -15.640 -10.305  1.00  0.00
ATOM   1688  HB3 ALA   107       6.723 -15.006  -8.660  1.00  0.00
ATOM   1689  C   ALA   107       5.851 -17.624  -8.674  1.00  0.00
ATOM   1690  O   ALA   107       6.074 -18.580  -9.430  1.00  0.00
ATOM   1691  N   LYS   108       6.194 -17.607  -7.375  1.00  0.00
ATOM   1692  HN  LYS   108       5.915 -16.832  -6.831  1.00  0.00
ATOM   1693  CA  LYS   108       6.942 -18.685  -6.701  1.00  0.00
ATOM   1694  HA  LYS   108       6.708 -19.631  -7.187  1.00  0.00
ATOM   1695  CB  LYS   108       8.472 -18.426  -6.773  1.00  0.00
ATOM   1696  HB1 LYS   108       8.980 -19.140  -6.128  1.00  0.00
ATOM   1697  HB2 LYS   108       8.670 -17.427  -6.397  1.00  0.00
ATOM   1698  CG  LYS   108       9.079 -18.538  -8.184  1.00  0.00
ATOM   1699  HG1 LYS   108       8.475 -17.946  -8.865  1.00  0.00
ATOM   1700  HG2 LYS   108       9.045 -19.574  -8.498  1.00  0.00
ATOM   1701  CD  LYS   108      10.537 -18.048  -8.262  1.00  0.00
ATOM   1702  HD1 LYS   108      11.166 -18.699  -7.662  1.00  0.00
ATOM   1703  HD2 LYS   108      10.592 -17.037  -7.867  1.00  0.00
ATOM   1704  CE  LYS   108      11.059 -18.041  -9.707  1.00  0.00
ATOM   1705  HE1 LYS   108      10.418 -17.410 -10.314  1.00  0.00
ATOM   1706  HE2 LYS   108      11.037 -19.050 -10.101  1.00  0.00
ATOM   1707  NZ  LYS   108      12.447 -17.533  -9.804  1.00  0.00
ATOM   1708  HZ1 LYS   108      12.491 -16.547  -9.472  1.00  0.00
ATOM   1709  HZ2 LYS   108      12.773 -17.570 -10.790  1.00  0.00
ATOM   1710  HZ3 LYS   108      13.078 -18.110  -9.219  1.00  0.00
ATOM   1711  C   LYS   108       6.513 -18.750  -5.239  1.00  0.00
ATOM   1712  O   LYS   108       6.220 -17.721  -4.642  1.00  0.00
ATOM   1713  N   ALA   109       6.502 -19.953  -4.665  1.00  0.00
ATOM   1714  HN  ALA   109       6.737 -20.734  -5.208  1.00  0.00
ATOM   1715  CA  ALA   109       6.172 -20.164  -3.255  1.00  0.00
ATOM   1716  HA  ALA   109       6.435 -19.255  -2.705  1.00  0.00
ATOM   1717  CB  ALA   109       4.675 -20.420  -3.061  1.00  0.00
ATOM   1718  HB1 ALA   109       4.110 -19.584  -3.452  1.00  0.00
ATOM   1719  HB2 ALA   109       4.451 -20.530  -2.004  1.00  0.00
ATOM   1720  HB3 ALA   109       4.380 -21.325  -3.582  1.00  0.00
ATOM   1721  C   ALA   109       6.998 -21.320  -2.707  1.00  0.00
ATOM   1722  O   ALA   109       7.227 -22.318  -3.385  1.00  0.00
ATOM   1723  N   TRP   110       7.465 -21.142  -1.486  1.00  0.00
ATOM   1724  HN  TRP   110       7.229 -20.320  -1.027  1.00  0.00
ATOM   1725  CA  TRP   110       8.314 -22.088  -0.766  1.00  0.00
ATOM   1726  HA  TRP   110       8.312 -23.046  -1.280  1.00  0.00
ATOM   1727  CB  TRP   110       9.773 -21.523  -0.680  1.00  0.00
ATOM   1728  HB1 TRP   110      10.456 -22.341  -0.472  1.00  0.00
ATOM   1729  HB2 TRP   110       9.837 -20.806   0.130  1.00  0.00
ATOM   1730  CG  TRP   110      10.254 -20.819  -1.942  1.00  0.00
ATOM   1731  CD1 TRP   110      10.829 -21.392  -3.027  1.00  0.00
ATOM   1732  HD1 TRP   110      11.029 -22.441  -3.116  1.00  0.00
ATOM   1733  CD2 TRP   110      10.173 -19.414  -2.249  1.00  0.00
ATOM   1734  NE1 TRP   110      11.114 -20.458  -3.978  1.00  0.00
ATOM   1735  HE1 TRP   110      11.535 -20.638  -4.845  1.00  0.00
ATOM   1736  CE2 TRP   110      10.722 -19.236  -3.527  1.00  0.00
ATOM   1737  CE3 TRP   110       9.684 -18.298  -1.572  1.00  0.00
ATOM   1738  HE3 TRP   110       9.250 -18.392  -0.588  1.00  0.00
ATOM   1739  CZ2 TRP   110      10.812 -17.991  -4.134  1.00  0.00
ATOM   1740  HZ2 TRP   110      11.239 -17.864  -5.121  1.00  0.00
ATOM   1741  CZ3 TRP   110       9.770 -17.060  -2.173  1.00  0.00
ATOM   1742  HZ3 TRP   110       9.399 -16.182  -1.657  1.00  0.00
ATOM   1743  CH2 TRP   110      10.328 -16.917  -3.446  1.00  0.00
ATOM   1744  HH2 TRP   110      10.376 -15.926  -3.883  1.00  0.00
ATOM   1745  C   TRP   110       7.708 -22.259   0.635  1.00  0.00
ATOM   1746  O   TRP   110       6.983 -21.371   1.105  1.00  0.00
ATOM   1747  N   PHE   111       7.969 -23.381   1.302  1.00  0.00
ATOM   1748  HN  PHE   111       8.426 -24.118   0.848  1.00  0.00
ATOM   1749  CA  PHE   111       7.574 -23.541   2.713  1.00  0.00
ATOM   1750  HA  PHE   111       7.517 -22.541   3.155  1.00  0.00
ATOM   1751  CB  PHE   111       6.172 -24.216   2.858  1.00  0.00
ATOM   1752  HB1 PHE   111       5.495 -23.767   2.137  1.00  0.00
ATOM   1753  HB2 PHE   111       5.784 -24.007   3.851  1.00  0.00
ATOM   1754  CG  PHE   111       6.127 -25.733   2.651  1.00  0.00
ATOM   1755  CD1 PHE   111       6.113 -26.601   3.748  1.00  0.00
ATOM   1756  HD1 PHE   111       6.134 -26.191   4.750  1.00  0.00
ATOM   1757  CD2 PHE   111       6.102 -26.292   1.375  1.00  0.00
ATOM   1758  HD2 PHE   111       6.113 -25.645   0.507  1.00  0.00
ATOM   1759  CE1 PHE   111       6.072 -27.967   3.576  1.00  0.00
ATOM   1760  HE1 PHE   111       6.066 -28.618   4.446  1.00  0.00
ATOM   1761  CE2 PHE   111       6.058 -27.666   1.203  1.00  0.00
ATOM   1762  HE2 PHE   111       6.036 -28.085   0.203  1.00  0.00
ATOM   1763  CZ  PHE   111       6.044 -28.503   2.302  1.00  0.00
ATOM   1764  HZ  PHE   111       6.010 -29.578   2.166  1.00  0.00
ATOM   1765  C   PHE   111       8.658 -24.311   3.463  1.00  0.00
ATOM   1766  O   PHE   111       9.311 -25.203   2.897  1.00  0.00
ATOM   1767  N   LYS   112       8.853 -23.944   4.733  1.00  0.00
ATOM   1768  HN  LYS   112       8.345 -23.179   5.081  1.00  0.00
ATOM   1769  CA  LYS   112       9.775 -24.624   5.639  1.00  0.00
ATOM   1770  HA  LYS   112      10.080 -25.557   5.172  1.00  0.00
ATOM   1771  CB  LYS   112      11.048 -23.763   5.904  1.00  0.00
ATOM   1772  HB1 LYS   112      11.567 -23.625   4.959  1.00  0.00
ATOM   1773  HB2 LYS   112      11.705 -24.320   6.568  1.00  0.00
ATOM   1774  CG  LYS   112      10.812 -22.366   6.527  1.00  0.00
ATOM   1775  HG1 LYS   112      10.194 -22.481   7.412  1.00  0.00
ATOM   1776  HG2 LYS   112      10.289 -21.745   5.807  1.00  0.00
ATOM   1777  CD  LYS   112      12.137 -21.673   6.926  1.00  0.00
ATOM   1778  HD1 LYS   112      12.744 -21.538   6.035  1.00  0.00
ATOM   1779  HD2 LYS   112      12.672 -22.314   7.619  1.00  0.00
ATOM   1780  CE  LYS   112      11.934 -20.306   7.597  1.00  0.00
ATOM   1781  HE1 LYS   112      11.281 -20.419   8.454  1.00  0.00
ATOM   1782  HE2 LYS   112      11.476 -19.624   6.889  1.00  0.00
ATOM   1783  NZ  LYS   112      13.224 -19.721   8.052  1.00  0.00
ATOM   1784  HZ1 LYS   112      13.667 -20.339   8.762  1.00  0.00
ATOM   1785  HZ2 LYS   112      13.065 -18.784   8.468  1.00  0.00
ATOM   1786  HZ3 LYS   112      13.871 -19.623   7.246  1.00  0.00
ATOM   1787  C   LYS   112       9.041 -24.961   6.939  1.00  0.00
ATOM   1788  O   LYS   112       8.473 -24.080   7.585  1.00  0.00
ATOM   1789  N   ILE   113       9.040 -26.250   7.322  1.00  0.00
ATOM   1790  HN  ILE   113       9.508 -26.906   6.774  1.00  0.00
ATOM   1791  CA  ILE   113       8.370 -26.703   8.547  1.00  0.00
ATOM   1792  HA  ILE   113       7.521 -26.041   8.731  1.00  0.00
ATOM   1793  CB  ILE   113       7.816 -28.165   8.418  1.00  0.00
ATOM   1794  HB  ILE   113       8.638 -28.807   8.123  1.00  0.00
ATOM   1795  CG1 ILE   113       6.712 -28.224   7.318  1.00  0.00
ATOM   1796 HG11 ILE   113       7.049 -27.713   6.424  1.00  0.00
ATOM   1797 HG12 ILE   113       5.829 -27.716   7.680  1.00  0.00
ATOM   1798  CG2 ILE   113       7.259 -28.692   9.777  1.00  0.00
ATOM   1799 HG21 ILE   113       6.885 -29.702   9.653  1.00  0.00
ATOM   1800 HG22 ILE   113       6.450 -28.056  10.113  1.00  0.00
ATOM   1801 HG23 ILE   113       8.045 -28.690  10.523  1.00  0.00
ATOM   1802  CD1 ILE   113       6.289 -29.624   6.937  1.00  0.00
ATOM   1803 HD11 ILE   113       7.147 -30.184   6.587  1.00  0.00
ATOM   1804 HD12 ILE   113       5.550 -29.574   6.153  1.00  0.00
ATOM   1805 HD13 ILE   113       5.865 -30.117   7.799  1.00  0.00
ATOM   1806  C   ILE   113       9.363 -26.597   9.707  1.00  0.00
ATOM   1807  O   ILE   113      10.473 -27.147   9.642  1.00  0.00
ATOM   1808  N   GLY   114       8.949 -25.855  10.735  1.00  0.00
ATOM   1809  HN  GLY   114       8.035 -25.487  10.695  1.00  0.00
ATOM   1810  CA  GLY   114       9.788 -25.579  11.902  1.00  0.00
ATOM   1811  HA1 GLY   114       9.270 -24.872  12.536  1.00  0.00
ATOM   1812  HA2 GLY   114      10.716 -25.124  11.570  1.00  0.00
ATOM   1813  C   GLY   114      10.096 -26.827  12.718  1.00  0.00
ATOM   1814  O   GLY   114      11.252 -27.278  12.764  1.00  0.00
ATOM   1815  N   GLU   115       9.053 -27.397  13.343  1.00  0.00
ATOM   1816  HN  GLU   115       8.162 -26.994  13.241  1.00  0.00
ATOM   1817  CA  GLU   115       9.172 -28.619  14.151  1.00  0.00
ATOM   1818  HA  GLU   115       9.852 -29.295  13.644  1.00  0.00
ATOM   1819  CB  GLU   115       9.728 -28.287  15.575  1.00  0.00
ATOM   1820  HB1 GLU   115      10.550 -27.585  15.476  1.00  0.00
ATOM   1821  HB2 GLU   115      10.109 -29.202  16.018  1.00  0.00
ATOM   1822  CG  GLU   115       8.686 -27.683  16.540  1.00  0.00
ATOM   1823  HG1 GLU   115       7.840 -28.377  16.594  1.00  0.00
ATOM   1824  HG2 GLU   115       8.331 -26.745  16.126  1.00  0.00
ATOM   1825  CD  GLU   115       9.222 -27.446  17.960  1.00  0.00
ATOM   1826  OE1 GLU   115       9.196 -28.387  18.779  1.00  0.00
ATOM   1827  OE2 GLU   115       9.645 -26.314  18.276  1.00  0.00
ATOM   1828  C   GLU   115       7.789 -29.299  14.272  1.00  0.00
ATOM   1829  O   GLU   115       6.761 -28.666  13.976  1.00  0.00
ATOM   1830  N   PRO   116       7.741 -30.602  14.687  1.00  0.00
ATOM   1831  CA  PRO   116       6.494 -31.239  15.173  1.00  0.00
ATOM   1832  HA  PRO   116       5.641 -30.943  14.576  1.00  0.00
ATOM   1833  CB  PRO   116       6.790 -32.733  14.950  1.00  0.00
ATOM   1834  HB1 PRO   116       6.506 -32.996  13.942  1.00  0.00
ATOM   1835  HB2 PRO   116       6.227 -33.346  15.649  1.00  0.00
ATOM   1836  CG  PRO   116       8.272 -32.873  15.146  1.00  0.00
ATOM   1837  HG1 PRO   116       8.648 -33.718  14.577  1.00  0.00
ATOM   1838  HG2 PRO   116       8.494 -33.012  16.201  1.00  0.00
ATOM   1839  CD  PRO   116       8.876 -31.579  14.638  1.00  0.00
ATOM   1840  HD1 PRO   116       9.233 -31.695  13.621  1.00  0.00
ATOM   1841  HD2 PRO   116       9.687 -31.253  15.282  1.00  0.00
ATOM   1842  C   PRO   116       6.206 -30.918  16.661  1.00  0.00
ATOM   1843  O   PRO   116       7.129 -30.919  17.488  1.00  0.00
ATOM   1844  N   ARG   117       4.924 -30.616  16.993  1.00  0.00
ATOM   1845  HN  ARG   117       4.262 -30.532  16.275  1.00  0.00
ATOM   1846  CA  ARG   117       4.478 -30.391  18.393  1.00  0.00
ATOM   1847  HA  ARG   117       5.260 -30.770  19.040  1.00  0.00
ATOM   1848  CB  ARG   117       4.276 -28.879  18.700  1.00  0.00
ATOM   1849  HB1 ARG   117       3.834 -28.780  19.688  1.00  0.00
ATOM   1850  HB2 ARG   117       3.586 -28.466  17.969  1.00  0.00
ATOM   1851  CG  ARG   117       5.565 -28.041  18.664  1.00  0.00
ATOM   1852  HG1 ARG   117       5.961 -28.057  17.652  1.00  0.00
ATOM   1853  HG2 ARG   117       6.297 -28.484  19.334  1.00  0.00
ATOM   1854  CD  ARG   117       5.337 -26.586  19.081  1.00  0.00
ATOM   1855  HD1 ARG   117       4.955 -26.564  20.096  1.00  0.00
ATOM   1856  HD2 ARG   117       4.603 -26.141  18.414  1.00  0.00
ATOM   1857  NE  ARG   117       6.581 -25.804  19.027  1.00  0.00
ATOM   1858  HE  ARG   117       7.418 -26.293  19.188  1.00  0.00
ATOM   1859  CZ  ARG   117       6.657 -24.493  18.783  1.00  0.00
ATOM   1860  NH1 ARG   117       5.561 -23.791  18.512  1.00  0.00
ATOM   1861 HH11 ARG   117       4.663 -24.247  18.479  1.00  0.00
ATOM   1862 HH12 ARG   117       5.617 -22.807  18.348  1.00  0.00
ATOM   1863  NH2 ARG   117       7.837 -23.897  18.772  1.00  0.00
ATOM   1864 HH21 ARG   117       8.673 -24.434  18.945  1.00  0.00
ATOM   1865 HH22 ARG   117       7.911 -22.914  18.593  1.00  0.00
ATOM   1866  C   ARG   117       3.185 -31.163  18.716  1.00  0.00
ATOM   1867  O   ARG   117       2.409 -31.535  17.826  1.00  0.00
ATOM   1868  N   ILE   118       2.974 -31.375  20.032  1.00  0.00
ATOM   1869  HN  ILE   118       3.617 -30.990  20.664  1.00  0.00
ATOM   1870  CA  ILE   118       1.835 -32.123  20.603  1.00  0.00
ATOM   1871  HA  ILE   118       1.035 -32.176  19.864  1.00  0.00
ATOM   1872  CB  ILE   118       2.265 -33.596  21.008  1.00  0.00
ATOM   1873  HB  ILE   118       3.094 -33.515  21.708  1.00  0.00
ATOM   1874  CG1 ILE   118       2.754 -34.407  19.770  1.00  0.00
ATOM   1875 HG11 ILE   118       3.130 -35.368  20.099  1.00  0.00
ATOM   1876 HG12 ILE   118       3.559 -33.868  19.289  1.00  0.00
ATOM   1877  CG2 ILE   118       1.130 -34.358  21.729  1.00  0.00
ATOM   1878 HG21 ILE   118       0.866 -33.840  22.644  1.00  0.00
ATOM   1879 HG22 ILE   118       1.449 -35.363  21.972  1.00  0.00
ATOM   1880 HG23 ILE   118       0.255 -34.405  21.084  1.00  0.00
ATOM   1881  CD1 ILE   118       1.695 -34.665  18.720  1.00  0.00
ATOM   1882 HD11 ILE   118       0.912 -35.278  19.142  1.00  0.00
ATOM   1883 HD12 ILE   118       2.138 -35.173  17.878  1.00  0.00
ATOM   1884 HD13 ILE   118       1.271 -33.722  18.393  1.00  0.00
ATOM   1885  C   ILE   118       1.334 -31.368  21.850  1.00  0.00
ATOM   1886  O   ILE   118       2.152 -30.899  22.641  1.00  0.00
END
