
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  123 (  957),  selected  123 , name 1gs3_A
# Molecule2: number of CA atoms  117 ( 1867),  selected  117 , name T0475.pdb
# PARAMETERS: 1gs3_A.T0475.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    N     2_A      -       -           -
LGA    L     3_A      -       -           -
LGA    P     4_A      -       -           -
LGA    T     5_A      -       -           -
LGA    A     6_A      N       2          1.836
LGA    Q     7_A      S       3          3.183
LGA    E     8_A      E       4          3.444
LGA    V     9_A      I       5          2.471
LGA    Q    10_A      E       6          2.945
LGA    G    11_A      L       7          3.657
LGA    L    12_A      P       8          2.633
LGA    M    13_A      V       9          1.479
LGA    A    14_A      Q      10          2.101
LGA    R    15_A      K      11          1.777
LGA    Y    16_A      Q      12          1.406
LGA    I    17_A      L      13          0.877
LGA    E    18_A      E      14          0.309
LGA    L    19_A      A      15          0.524
LGA    V    20_A      Y      16          0.396
LGA    D    21_A      N      17          0.826
LGA    V    22_A      A      18          1.373
LGA    G    23_A      R      19          1.825
LGA    D    24_A      D      20          1.536
LGA    I    25_A      I      21          1.938
LGA    E    26_A      D      22          2.750
LGA    A    27_A      A      23          2.457
LGA    I    28_A      F      24          1.164
LGA    V    29_A      M      25          2.017
LGA    Q    30_A      A      26          2.236
LGA    M    31_A      W      27          2.163
LGA    F    32_A      W      28          1.373
LGA    A    33_A      A      29          0.640
LGA    D    34_A      D      30          0.687
LGA    D    35_A      D      31          0.763
LGA    A    36_A      C      32          0.649
LGA    T    37_A      Q      33          0.753
LGA    V    38_A      Y      34          0.678
LGA    E    39_A      Y      35          0.984
LGA    N    40_A      A      36          2.218
LGA    P    41_A      F      37          2.728
LGA    F    42_A      -       -           -
LGA    G    43_A      P      38          1.872
LGA    Q    44_A      A      39          4.718
LGA    P    45_A      T      40          2.025
LGA    P    46_A      L      41          0.826
LGA    I    47_A      L      42          2.095
LGA    H    48_A      A      43          2.412
LGA    -       -      G      44           -
LGA    G    49_A      N      45          1.127
LGA    R    50_A      A      46          1.867
LGA    E    51_A      A      47          2.048
LGA    Q    52_A      E      48          1.194
LGA    I    53_A      I      49          0.888
LGA    A    54_A      R      50          1.840
LGA    A    55_A      V      51          1.941
LGA    F    56_A      R      52          0.737
LGA    F    57_A      H      53          0.425
LGA    R    58_A      I      54          1.425
LGA    Q    59_A      E      55          1.643
LGA    G    60_A      R      56          1.529
LGA    L    61_A      F      57          1.840
LGA    -       -      K      58           -
LGA    -       -      E      59           -
LGA    -       -      P      60           -
LGA    K    65_A      D      61          1.918
LGA    V    66_A      L      62          0.578
LGA    R    67_A      Y      63          0.683
LGA    A    68_A      G      64          0.812
LGA    C    69_A      E      65          2.211
LGA    L    70_A      L      66          1.671
LGA    T    71_A      L      67          0.168
LGA    G    72_A      T      68          1.633
LGA    P    73_A      R      69          3.578
LGA    V    74_A      -       -           -
LGA    R    75_A      V      70          1.571
LGA    A    76_A      I      71          1.491
LGA    S    77_A      V      72          2.590
LGA    H    78_A      G      73          2.852
LGA    N    79_A      N      74          3.796
LGA    G    80_A      -       -           -
LGA    C    81_A      V      75          1.556
LGA    G    82_A      V      76          1.555
LGA    A    83_A      I      77          1.515
LGA    M    84_A      D      78          2.330
LGA    P    85_A      H      79          1.659
LGA    F    86_A      E      80          1.309
LGA    R    87_A      T      81          1.172
LGA    V    88_A      V      82          0.962
LGA    E    89_A      T      83          0.737
LGA    M    90_A      R      84          1.340
LGA    V    91_A      N      85          1.397
LGA    W    92_A      F      86          3.456
LGA    N    93_A      -       -           -
LGA    G    94_A      P      87          5.670
LGA    Q    95_A      E      88          5.495
LGA    -       -      G      89           -
LGA    P    96_A      K      90          2.185
LGA    C    97_A      G      91          1.007
LGA    A    98_A      E      92          0.574
LGA    L    99_A      V      93          0.634
LGA    D   100_A      D      94          0.563
LGA    V   101_A      V      95          1.045
LGA    I   102_A      A      96          1.058
LGA    D   103_A      C      97          1.694
LGA    V   104_A      I      98          1.364
LGA    M   105_A      Y      99          0.711
LGA    R   106_A      E     100          0.639
LGA    F   107_A      V     101          0.681
LGA    D   108_A      E     102          1.666
LGA    E   109_A      N     103          0.706
LGA    H   110_A      G     104          3.082
LGA    G   111_A      -       -           -
LGA    R   112_A      R     105          1.344
LGA    I   113_A      I     106          1.012
LGA    Q   114_A      A     107          0.975
LGA    T   115_A      K     108          0.431
LGA    M   116_A      A     109          0.595
LGA    Q   117_A      W     110          1.023
LGA    A   118_A      F     111          0.650
LGA    F   119_A      K     112          1.599
LGA    W   120_A      I     113          1.611
LGA    S   121_A      G     114          4.634
LGA    E   122_A      -       -           -
LGA    V   123_A      -       -           -
LGA    N   124_A      E     115          1.219
LGA    L   125_A      P     116          0.887
LGA    S   126_A      R     117          0.584
LGA    V   127_A      I     118          3.022

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  123  117    5.0    112    1.97    14.29     85.860     5.410

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.520105 * X  +  -0.801680 * Y  +  -0.294619 * Z  +  56.699661
  Y_new =  -0.060906 * X  +  -0.378879 * Y  +   0.923440 * Z  + -31.673710
  Z_new =  -0.851928 * X  +  -0.462341 * Y  +  -0.245884 * Z  +  42.902954 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.059578    1.082015  [ DEG:  -118.0051     61.9949 ]
  Theta =   1.019657    2.121936  [ DEG:    58.4220    121.5780 ]
  Phi   =  -0.116573    3.025020  [ DEG:    -6.6791    173.3209 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1gs3_A                                        
REMARK     2: T0475.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1gs3_A.T0475.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  123  117   5.0  112   1.97   14.29  85.860
REMARK  ---------------------------------------------------------- 
MOLECULE 1gs3_A
HEADER    ISOMERASE                               27-DEC-01   1GS3              
TITLE     HIGH RESOLUTION CRYSTAL STRUCTURE OF PI DELTA-5-3-                    
TITLE    2 KETOSTEROID ISOMERASE MUTANTS Y30F/Y55F/Y115F/ D38N                  
TITLE    3 (Y32F/Y57F/Y119F/D40N, PI NUMBERING)COMPLEXED WITH                   
TITLE    4 EQUILENIN AT 2.1 A RESOLUTION                                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: STEROID DELTA-ISOMERASE;                                   
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: DELTA-5-3-KETOSTEROID ISOMERASE;                            
COMPND   5 EC: 5.3.3.1;                                                         
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS PUTIDA;                             
SOURCE   3 STRAIN: BIOTYPE B;                                                   
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)                                  
KEYWDS    ISOMERASE                                                             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.SHIN,N.-C.HA,B.-H.OH                                                
REVDAT   1   23-JAN-03 1GS3    0                                                
JRNL        AUTH   G.CHOI,S.SHIN,S.-G.YUN,D.S.JANG,G.H.NAM,B.-H.HONG,           
JRNL        AUTH 2 H.-C.LEE,B.-H.OH,K.Y.CHOI                                    
JRNL        TITL   CONTRIBUTION OF A LOW-BARRIER HYDROGEN BOND TO               
JRNL        TITL 2 CATALYSIS BY DELTA-5-3-KETOSTEROID ISOMERASE IS              
JRNL        TITL 3 NOT EXTREMELY HIGH COMPARED TO THAT OF AN ORDINARY           
JRNL        TITL 4 HYDROGEN BOND. LOW-BARRIER HYDROGEN BOND OF PI KSI           
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.10 ANGSTROMS.                                          
DBREF  1GS3 A    1   131  UNP    P07445   SDIS_PSEPU       1    131             
SEQRES   1 A  131  MET ASN LEU PRO THR ALA GLN GLU VAL GLN GLY LEU MET          
SEQRES   2 A  131  ALA ARG TYR ILE GLU LEU VAL ASP VAL GLY ASP ILE GLU          
SEQRES   3 A  131  ALA ILE VAL GLN MET PHE ALA ASP ASP ALA THR VAL GLU          
SEQRES   4 A  131  ASN PRO PHE GLY GLN PRO PRO ILE HIS GLY ARG GLU GLN          
SEQRES   5 A  131  ILE ALA ALA PHE PHE ARG GLN GLY LEU GLY GLY GLY LYS          
SEQRES   6 A  131  VAL ARG ALA CYS LEU THR GLY PRO VAL ARG ALA SER HIS          
SEQRES   7 A  131  ASN GLY CYS GLY ALA MET PRO PHE ARG VAL GLU MET VAL          
SEQRES   8 A  131  TRP ASN GLY GLN PRO CYS ALA LEU ASP VAL ILE ASP VAL          
SEQRES   9 A  131  MET ARG PHE ASP GLU HIS GLY ARG ILE GLN THR MET GLN          
SEQRES  10 A  131  ALA PHE TRP SER GLU VAL ASN LEU SER VAL ARG GLU PRO          
SEQRES  11 A  131  GLN                                                          
HET    EQU  A 801      20                                                       
HETNAM     EQU EQUILENIN                                                        
FORMUL   2  EQU    C18 H18 O2                                                   
FORMUL   3  HOH   *38(H2 O)                                                     
CRYST1   36.319   96.237   74.431  90.00  90.00  90.00 C 2 2 21      8          
ATOM      1  N   ASN A   2      -1.743  -5.384 -11.036  1.00 42.95           N  
ATOM      2  CA  ASN A   2      -0.251  -5.262 -11.110  1.00 42.74           C  
ATOM      3  C   ASN A   2       0.449  -5.780  -9.866  1.00 40.46           C  
ATOM      4  O   ASN A   2      -0.189  -6.343  -8.974  1.00 40.06           O  
ATOM      5  CB  ASN A   2       0.157  -3.804 -11.330  1.00 45.00           C  
ATOM      6  CG  ASN A   2      -0.407  -3.229 -12.614  1.00 20.00           C  
ATOM      7  OD1 ASN A   2      -0.446  -3.904 -13.643  1.00 20.00           O  
ATOM      8  ND2 ASN A   2      -0.845  -1.977 -12.558  1.00 20.00           N  
ATOM      9  N   LEU A   3       1.765  -5.585  -9.819  1.00 36.91           N  
ATOM     10  CA  LEU A   3       2.559  -6.030  -8.687  1.00 33.91           C  
ATOM     11  C   LEU A   3       1.881  -5.500  -7.433  1.00 31.65           C  
ATOM     12  O   LEU A   3       1.854  -4.296  -7.197  1.00 32.71           O  
ATOM     13  CB  LEU A   3       3.982  -5.487  -8.794  1.00 33.19           C  
ATOM     14  CG  LEU A   3       5.065  -6.274  -8.053  1.00 33.40           C  
ATOM     15  CD1 LEU A   3       5.109  -7.694  -8.568  1.00 35.01           C  
ATOM     16  CD2 LEU A   3       6.412  -5.618  -8.261  1.00 34.23           C  
ATOM     17  N   PRO A   4       1.295  -6.396  -6.624  1.00 30.17           N  
ATOM     18  CA  PRO A   4       0.625  -5.948  -5.404  1.00 28.42           C  
ATOM     19  C   PRO A   4       1.496  -5.067  -4.534  1.00 26.43           C  
ATOM     20  O   PRO A   4       2.718  -5.185  -4.515  1.00 28.45           O  
ATOM     21  CB  PRO A   4       0.241  -7.256  -4.713  1.00 27.94           C  
ATOM     22  CG  PRO A   4       1.226  -8.233  -5.238  1.00 30.03           C  
ATOM     23  CD  PRO A   4       1.306  -7.864  -6.695  1.00 29.29           C  
ATOM     24  N   THR A   5       0.848  -4.167  -3.819  1.00 24.44           N  
ATOM     25  CA  THR A   5       1.549  -3.264  -2.936  1.00 22.23           C  
ATOM     26  C   THR A   5       1.652  -3.976  -1.600  1.00 21.84           C  
ATOM     27  O   THR A   5       1.021  -5.013  -1.403  1.00 21.05           O  
ATOM     28  CB  THR A   5       0.765  -1.962  -2.788  1.00 22.24           C  
ATOM     29  OG1 THR A   5      -0.501  -2.223  -2.160  1.00 18.18           O  
ATOM     30  CG2 THR A   5       0.521  -1.356  -4.168  1.00 21.52           C  
ATOM     31  N   ALA A   6       2.447  -3.427  -0.690  1.00 21.60           N  
ATOM     32  CA  ALA A   6       2.617  -4.036   0.618  1.00 22.86           C  
ATOM     33  C   ALA A   6       1.275  -4.405   1.238  1.00 23.06           C  
ATOM     34  O   ALA A   6       1.066  -5.552   1.622  1.00 24.12           O  
ATOM     35  CB  ALA A   6       3.382  -3.097   1.541  1.00 22.75           C  
ATOM     36  N   GLN A   7       0.362  -3.441   1.319  1.00 24.23           N  
ATOM     37  CA  GLN A   7      -0.954  -3.682   1.912  1.00 25.06           C  
ATOM     38  C   GLN A   7      -1.729  -4.749   1.173  1.00 23.42           C  
ATOM     39  O   GLN A   7      -2.468  -5.518   1.778  1.00 24.00           O  
ATOM     40  CB  GLN A   7      -1.766  -2.389   1.941  1.00 29.24           C  
ATOM     41  CG  GLN A   7      -1.059  -1.278   2.694  1.00 34.73           C  
ATOM     42  CD  GLN A   7      -1.884  -0.020   2.825  1.00 37.38           C  
ATOM     43  OE1 GLN A   7      -1.444   0.956   3.438  1.00 39.74           O  
ATOM     44  NE2 GLN A   7      -3.088  -0.030   2.254  1.00 38.05           N  
ATOM     45  N   GLU A   8      -1.557  -4.791  -0.139  1.00 21.95           N  
ATOM     46  CA  GLU A   8      -2.232  -5.779  -0.956  1.00 21.39           C  
ATOM     47  C   GLU A   8      -1.688  -7.169  -0.684  1.00 20.93           C  
ATOM     48  O   GLU A   8      -2.418  -8.161  -0.770  1.00 22.97           O  
ATOM     49  CB  GLU A   8      -2.072  -5.430  -2.435  1.00 21.57           C  
ATOM     50  CG  GLU A   8      -3.135  -4.475  -2.915  1.00 24.11           C  
ATOM     51  CD  GLU A   8      -2.808  -3.814  -4.237  1.00 26.24           C  
ATOM     52  OE1 GLU A   8      -3.718  -3.162  -4.799  1.00 27.35           O  
ATOM     53  OE2 GLU A   8      -1.654  -3.930  -4.708  1.00 27.26           O  
ATOM     54  N   VAL A   9      -0.402  -7.239  -0.353  1.00 20.28           N  
ATOM     55  CA  VAL A   9       0.240  -8.514  -0.066  1.00 17.54           C  
ATOM     56  C   VAL A   9      -0.268  -9.074   1.259  1.00 15.83           C  
ATOM     57  O   VAL A   9      -0.555 -10.264   1.373  1.00 14.59           O  
ATOM     58  CB  VAL A   9       1.773  -8.358  -0.020  1.00 17.11           C  
ATOM     59  CG1 VAL A   9       2.434  -9.691   0.296  1.00 17.05           C  
ATOM     60  CG2 VAL A   9       2.268  -7.840  -1.358  1.00 18.01           C  
ATOM     61  N   GLN A  10      -0.388  -8.213   2.260  1.00 14.99           N  
ATOM     62  CA  GLN A  10      -0.885  -8.650   3.560  1.00 14.38           C  
ATOM     63  C   GLN A  10      -2.239  -9.314   3.392  1.00 13.42           C  
ATOM     64  O   GLN A  10      -2.564 -10.274   4.090  1.00 15.02           O  
ATOM     65  CB  GLN A  10      -1.044  -7.472   4.513  1.00 13.46           C  
ATOM     66  CG  GLN A  10       0.242  -6.797   4.870  1.00 17.21           C  
ATOM     67  CD  GLN A  10       0.075  -5.839   6.025  1.00 19.22           C  
ATOM     68  OE1 GLN A  10      -0.726  -4.898   5.962  1.00 16.52           O  
ATOM     69  NE2 GLN A  10       0.833  -6.073   7.099  1.00 18.24           N  
ATOM     70  N   GLY A  11      -3.027  -8.793   2.459  1.00 12.82           N  
ATOM     71  CA  GLY A  11      -4.347  -9.337   2.214  1.00 14.50           C  
ATOM     72  C   GLY A  11      -4.344 -10.660   1.487  1.00 14.17           C  
ATOM     73  O   GLY A  11      -4.998 -11.610   1.919  1.00 16.03           O  
ATOM     74  N   LEU A  12      -3.610 -10.732   0.380  1.00 12.54           N  
ATOM     75  CA  LEU A  12      -3.555 -11.961  -0.389  1.00 11.62           C  
ATOM     76  C   LEU A  12      -3.057 -13.116   0.451  1.00 12.27           C  
ATOM     77  O   LEU A  12      -3.623 -14.213   0.402  1.00 11.53           O  
ATOM     78  CB  LEU A  12      -2.656 -11.793  -1.611  1.00 12.62           C  
ATOM     79  CG  LEU A  12      -3.265 -10.951  -2.735  1.00 14.44           C  
ATOM     80  CD1 LEU A  12      -2.252 -10.784  -3.856  1.00 16.84           C  
ATOM     81  CD2 LEU A  12      -4.515 -11.625  -3.250  1.00 13.35           C  
ATOM     82  N   MET A  13      -2.003 -12.873   1.225  1.00 11.65           N  
ATOM     83  CA  MET A  13      -1.434 -13.927   2.055  1.00 11.11           C  
ATOM     84  C   MET A  13      -2.366 -14.349   3.166  1.00 10.75           C  
ATOM     85  O   MET A  13      -2.461 -15.529   3.486  1.00 10.93           O  
ATOM     86  CB  MET A  13      -0.070 -13.496   2.596  1.00 10.24           C  
ATOM     87  CG  MET A  13       0.934 -13.284   1.457  1.00 12.49           C  
ATOM     88  SD  MET A  13       2.651 -13.035   1.948  1.00 13.76           S  
ATOM     89  CE  MET A  13       3.066 -14.668   2.543  1.00 13.20           C  
ATOM     90  N   ALA A  14      -3.087 -13.395   3.733  1.00 11.32           N  
ATOM     91  CA  ALA A  14      -4.034 -13.720   4.797  1.00 12.55           C  
ATOM     92  C   ALA A  14      -5.203 -14.500   4.201  1.00 13.02           C  
ATOM     93  O   ALA A  14      -5.780 -15.382   4.850  1.00 12.61           O  
ATOM     94  CB  ALA A  14      -4.537 -12.456   5.449  1.00  9.83           C  
ATOM     95  N   ARG A  15      -5.549 -14.153   2.962  1.00 15.29           N  
ATOM     96  CA  ARG A  15      -6.642 -14.795   2.230  1.00 16.07           C  
ATOM     97  C   ARG A  15      -6.273 -16.260   2.028  1.00 16.21           C  
ATOM     98  O   ARG A  15      -7.076 -17.174   2.263  1.00 13.78           O  
ATOM     99  CB  ARG A  15      -6.825 -14.111   0.874  1.00 16.81           C  
ATOM    100  CG  ARG A  15      -7.648 -14.909  -0.110  1.00 19.46           C  
ATOM    101  CD  ARG A  15      -9.124 -14.640   0.035  1.00 20.75           C  
ATOM    102  NE  ARG A  15      -9.917 -15.515  -0.827  1.00 22.04           N  
ATOM    103  CZ  ARG A  15      -9.707 -15.689  -2.131  1.00 23.15           C  
ATOM    104  NH1 ARG A  15      -8.718 -15.051  -2.751  1.00 23.17           N  
ATOM    105  NH2 ARG A  15     -10.496 -16.503  -2.825  1.00 24.42           N  
ATOM    106  N   TYR A  16      -5.036 -16.456   1.582  1.00 15.23           N  
ATOM    107  CA  TYR A  16      -4.479 -17.777   1.347  1.00 15.17           C  
ATOM    108  C   TYR A  16      -4.661 -18.685   2.576  1.00 15.83           C  
ATOM    109  O   TYR A  16      -5.084 -19.839   2.445  1.00 14.03           O  
ATOM    110  CB  TYR A  16      -2.992 -17.630   1.007  1.00 13.45           C  
ATOM    111  CG  TYR A  16      -2.238 -18.927   0.912  1.00 12.35           C  
ATOM    112  CD1 TYR A  16      -2.235 -19.673  -0.269  1.00  9.25           C  
ATOM    113  CD2 TYR A  16      -1.516 -19.406   2.000  1.00 10.62           C  
ATOM    114  CE1 TYR A  16      -1.520 -20.870  -0.357  1.00  9.17           C  
ATOM    115  CE2 TYR A  16      -0.801 -20.591   1.924  1.00  7.90           C  
ATOM    116  CZ  TYR A  16      -0.803 -21.321   0.747  1.00  9.85           C  
ATOM    117  OH  TYR A  16      -0.081 -22.498   0.682  1.00  9.63           O  
ATOM    118  N   ILE A  17      -4.337 -18.174   3.766  1.00 17.21           N  
ATOM    119  CA  ILE A  17      -4.485 -18.980   4.981  1.00 18.17           C  
ATOM    120  C   ILE A  17      -5.966 -19.272   5.240  1.00 17.80           C  
ATOM    121  O   ILE A  17      -6.326 -20.350   5.704  1.00 18.58           O  
ATOM    122  CB  ILE A  17      -3.872 -18.272   6.217  1.00 20.40           C  
ATOM    123  CG1 ILE A  17      -2.356 -18.141   6.049  1.00 21.10           C  
ATOM    124  CG2 ILE A  17      -4.169 -19.067   7.492  1.00 18.99           C  
ATOM    125  CD1 ILE A  17      -1.613 -19.469   6.034  1.00 22.27           C  
ATOM    126  N   GLU A  18      -6.819 -18.306   4.929  1.00 19.01           N  
ATOM    127  CA  GLU A  18      -8.258 -18.470   5.108  1.00 20.63           C  
ATOM    128  C   GLU A  18      -8.690 -19.690   4.304  1.00 18.47           C  
ATOM    129  O   GLU A  18      -9.353 -20.593   4.816  1.00 19.09           O  
ATOM    130  CB  GLU A  18      -9.003 -17.242   4.576  1.00 24.17           C  
ATOM    131  CG  GLU A  18     -10.201 -16.833   5.397  1.00 31.97           C  
ATOM    132  CD  GLU A  18      -9.855 -15.758   6.406  1.00 36.96           C  
ATOM    133  OE1 GLU A  18      -9.804 -14.570   6.009  1.00 39.73           O  
ATOM    134  OE2 GLU A  18      -9.617 -16.097   7.591  1.00 39.52           O  
ATOM    135  N   LEU A  19      -8.295 -19.703   3.037  1.00 16.29           N  
ATOM    136  CA  LEU A  19      -8.638 -20.792   2.150  1.00 15.05           C  
ATOM    137  C   LEU A  19      -8.060 -22.104   2.637  1.00 15.70           C  
ATOM    138  O   LEU A  19      -8.772 -23.101   2.737  1.00 18.87           O  
ATOM    139  CB  LEU A  19      -8.147 -20.489   0.736  1.00 13.11           C  
ATOM    140  CG  LEU A  19      -8.807 -19.258   0.117  1.00 11.18           C  
ATOM    141  CD1 LEU A  19      -8.305 -19.053  -1.311  1.00 11.95           C  
ATOM    142  CD2 LEU A  19     -10.318 -19.460   0.134  1.00  8.69           C  
ATOM    143  N   VAL A  20      -6.768 -22.121   2.940  1.00 14.86           N  
ATOM    144  CA  VAL A  20      -6.156 -23.350   3.416  1.00 13.35           C  
ATOM    145  C   VAL A  20      -6.902 -23.850   4.654  1.00 13.39           C  
ATOM    146  O   VAL A  20      -7.094 -25.049   4.828  1.00 14.43           O  
ATOM    147  CB  VAL A  20      -4.676 -23.149   3.773  1.00 12.40           C  
ATOM    148  CG1 VAL A  20      -4.115 -24.423   4.347  1.00 11.55           C  
ATOM    149  CG2 VAL A  20      -3.891 -22.752   2.539  1.00 14.65           C  
ATOM    150  N   ASP A  21      -7.344 -22.925   5.499  1.00 15.54           N  
ATOM    151  CA  ASP A  21      -8.062 -23.297   6.711  1.00 16.08           C  
ATOM    152  C   ASP A  21      -9.396 -23.983   6.428  1.00 16.53           C  
ATOM    153  O   ASP A  21      -9.753 -24.945   7.104  1.00 17.10           O  
ATOM    154  CB  ASP A  21      -8.283 -22.066   7.592  1.00 17.64           C  
ATOM    155  CG  ASP A  21      -8.953 -22.406   8.922  1.00 20.23           C  
ATOM    156  OD1 ASP A  21      -8.474 -23.329   9.629  1.00 17.08           O  
ATOM    157  OD2 ASP A  21      -9.958 -21.737   9.265  1.00 22.12           O  
ATOM    158  N   VAL A  22     -10.141 -23.497   5.442  1.00 15.71           N  
ATOM    159  CA  VAL A  22     -11.420 -24.126   5.125  1.00 13.17           C  
ATOM    160  C   VAL A  22     -11.254 -25.270   4.128  1.00 13.49           C  
ATOM    161  O   VAL A  22     -12.178 -26.050   3.909  1.00 13.17           O  
ATOM    162  CB  VAL A  22     -12.427 -23.124   4.550  1.00 13.50           C  
ATOM    163  CG1 VAL A  22     -12.541 -21.935   5.480  1.00 14.09           C  
ATOM    164  CG2 VAL A  22     -12.001 -22.688   3.159  1.00 12.07           C  
ATOM    165  N   GLY A  23     -10.078 -25.367   3.521  1.00 11.22           N  
ATOM    166  CA  GLY A  23      -9.833 -26.441   2.585  1.00 13.13           C  
ATOM    167  C   GLY A  23     -10.453 -26.331   1.204  1.00 14.13           C  
ATOM    168  O   GLY A  23     -10.618 -27.351   0.531  1.00 17.21           O  
ATOM    169  N   ASP A  24     -10.804 -25.122   0.768  1.00 13.81           N  
ATOM    170  CA  ASP A  24     -11.387 -24.930  -0.565  1.00 11.89           C  
ATOM    171  C   ASP A  24     -10.228 -25.055  -1.564  1.00 12.54           C  
ATOM    172  O   ASP A  24      -9.589 -24.066  -1.947  1.00 10.38           O  
ATOM    173  CB  ASP A  24     -12.030 -23.542  -0.665  1.00 13.30           C  
ATOM    174  CG  ASP A  24     -12.880 -23.373  -1.911  1.00 13.81           C  
ATOM    175  OD1 ASP A  24     -12.456 -23.826  -2.995  1.00 13.97           O  
ATOM    176  OD2 ASP A  24     -13.969 -22.772  -1.811  1.00 15.44           O  
ATOM    177  N   ILE A  25      -9.965 -26.283  -1.990  1.00 12.60           N  
ATOM    178  CA  ILE A  25      -8.850 -26.559  -2.891  1.00 13.49           C  
ATOM    179  C   ILE A  25      -8.831 -25.844  -4.235  1.00 15.65           C  
ATOM    180  O   ILE A  25      -7.778 -25.357  -4.656  1.00 16.30           O  
ATOM    181  CB  ILE A  25      -8.703 -28.084  -3.109  1.00 13.89           C  
ATOM    182  CG1 ILE A  25      -8.415 -28.750  -1.758  1.00 13.30           C  
ATOM    183  CG2 ILE A  25      -7.590 -28.375  -4.110  1.00 10.72           C  
ATOM    184  CD1 ILE A  25      -8.019 -30.193  -1.850  1.00 16.79           C  
ATOM    185  N   GLU A  26      -9.973 -25.767  -4.908  1.00 16.31           N  
ATOM    186  CA  GLU A  26     -10.014 -25.096  -6.198  1.00 18.15           C  
ATOM    187  C   GLU A  26      -9.689 -23.620  -6.037  1.00 18.86           C  
ATOM    188  O   GLU A  26      -8.983 -23.032  -6.858  1.00 20.00           O  
ATOM    189  CB  GLU A  26     -11.381 -25.293  -6.853  1.00 21.56           C  
ATOM    190  CG  GLU A  26     -11.546 -26.696  -7.427  1.00 28.71           C  
ATOM    191  CD  GLU A  26     -12.977 -27.210  -7.363  1.00 32.93           C  
ATOM    192  OE1 GLU A  26     -13.206 -28.364  -7.806  1.00 34.56           O  
ATOM    193  OE2 GLU A  26     -13.863 -26.466  -6.869  1.00 35.79           O  
ATOM    194  N   ALA A  27     -10.186 -23.026  -4.963  1.00 16.99           N  
ATOM    195  CA  ALA A  27      -9.924 -21.624  -4.707  1.00 16.61           C  
ATOM    196  C   ALA A  27      -8.437 -21.420  -4.384  1.00 16.52           C  
ATOM    197  O   ALA A  27      -7.827 -20.432  -4.800  1.00 17.61           O  
ATOM    198  CB  ALA A  27     -10.794 -21.145  -3.556  1.00 14.53           C  
ATOM    199  N   ILE A  28      -7.848 -22.357  -3.652  1.00 15.75           N  
ATOM    200  CA  ILE A  28      -6.438 -22.242  -3.297  1.00 15.49           C  
ATOM    201  C   ILE A  28      -5.553 -22.312  -4.538  1.00 15.99           C  
ATOM    202  O   ILE A  28      -4.717 -21.434  -4.769  1.00 15.95           O  
ATOM    203  CB  ILE A  28      -6.009 -23.368  -2.342  1.00 14.51           C  
ATOM    204  CG1 ILE A  28      -6.666 -23.169  -0.976  1.00 14.20           C  
ATOM    205  CG2 ILE A  28      -4.490 -23.416  -2.245  1.00 12.97           C  
ATOM    206  CD1 ILE A  28      -6.498 -24.359  -0.046  1.00 14.84           C  
ATOM    207  N   VAL A  29      -5.739 -23.364  -5.327  1.00 15.78           N  
ATOM    208  CA  VAL A  29      -4.950 -23.560  -6.531  1.00 15.39           C  
ATOM    209  C   VAL A  29      -5.017 -22.356  -7.467  1.00 16.15           C  
ATOM    210  O   VAL A  29      -4.056 -22.061  -8.187  1.00 17.04           O  
ATOM    211  CB  VAL A  29      -5.414 -24.821  -7.301  1.00 16.55           C  
ATOM    212  CG1 VAL A  29      -4.578 -24.989  -8.567  1.00 15.41           C  
ATOM    213  CG2 VAL A  29      -5.287 -26.062  -6.410  1.00 14.35           C  
ATOM    214  N   GLN A  30      -6.151 -21.660  -7.441  1.00 17.27           N  
ATOM    215  CA  GLN A  30      -6.391 -20.493  -8.293  1.00 16.57           C  
ATOM    216  C   GLN A  30      -5.569 -19.243  -7.955  1.00 16.25           C  
ATOM    217  O   GLN A  30      -5.425 -18.347  -8.793  1.00 14.36           O  
ATOM    218  CB  GLN A  30      -7.875 -20.140  -8.260  1.00 22.20           C  
ATOM    219  CG  GLN A  30      -8.352 -19.376  -9.469  1.00 27.75           C  
ATOM    220  CD  GLN A  30      -8.444 -20.256 -10.699  1.00 32.48           C  
ATOM    221  OE1 GLN A  30      -9.153 -21.265 -10.693  1.00 34.99           O  
ATOM    222  NE2 GLN A  30      -7.729 -19.879 -11.766  1.00 33.31           N  
ATOM    223  N   MET A  31      -5.038 -19.174  -6.736  1.00 13.35           N  
ATOM    224  CA  MET A  31      -4.232 -18.030  -6.334  1.00 13.08           C  
ATOM    225  C   MET A  31      -2.835 -18.090  -6.940  1.00 12.37           C  
ATOM    226  O   MET A  31      -2.132 -17.086  -6.969  1.00  9.64           O  
ATOM    227  CB  MET A  31      -4.096 -17.958  -4.810  1.00 14.87           C  
ATOM    228  CG  MET A  31      -5.359 -17.539  -4.080  1.00 18.12           C  
ATOM    229  SD  MET A  31      -5.015 -17.086  -2.363  1.00 22.86           S  
ATOM    230  CE  MET A  31      -4.467 -15.364  -2.572  1.00 21.28           C  
ATOM    231  N   PHE A  32      -2.425 -19.266  -7.410  1.00 10.65           N  
ATOM    232  CA  PHE A  32      -1.097 -19.402  -7.996  1.00 11.37           C  
ATOM    233  C   PHE A  32      -1.085 -19.108  -9.483  1.00 12.23           C  
ATOM    234  O   PHE A  32      -2.107 -19.232 -10.156  1.00 12.61           O  
ATOM    235  CB  PHE A  32      -0.556 -20.818  -7.801  1.00 11.58           C  
ATOM    236  CG  PHE A  32      -0.357 -21.201  -6.374  1.00 10.75           C  
ATOM    237  CD1 PHE A  32      -1.423 -21.651  -5.607  1.00 12.71           C  
ATOM    238  CD2 PHE A  32       0.896 -21.110  -5.792  1.00 11.42           C  
ATOM    239  CE1 PHE A  32      -1.242 -22.009  -4.267  1.00 11.16           C  
ATOM    240  CE2 PHE A  32       1.086 -21.461  -4.460  1.00 11.51           C  
ATOM    241  CZ  PHE A  32       0.007 -21.915  -3.698  1.00 11.37           C  
ATOM    242  N   ALA A  33       0.076 -18.711  -9.993  1.00 11.79           N  
ATOM    243  CA  ALA A  33       0.222 -18.471 -11.421  1.00 13.76           C  
ATOM    244  C   ALA A  33       0.162 -19.883 -12.012  1.00 15.17           C  
ATOM    245  O   ALA A  33       0.374 -20.863 -11.292  1.00 13.58           O  
ATOM    246  CB  ALA A  33       1.560 -17.830 -11.721  1.00 12.02           C  
ATOM    247  N   ASP A  34      -0.112 -19.994 -13.308  1.00 16.69           N  
ATOM    248  CA  ASP A  34      -0.231 -21.306 -13.933  1.00 17.55           C  
ATOM    249  C   ASP A  34       1.052 -22.123 -13.927  1.00 18.13           C  
ATOM    250  O   ASP A  34       1.013 -23.356 -13.846  1.00 18.76           O  
ATOM    251  CB  ASP A  34      -0.749 -21.175 -15.374  1.00 17.15           C  
ATOM    252  CG  ASP A  34       0.202 -20.409 -16.282  1.00 19.02           C  
ATOM    253  OD1 ASP A  34       0.199 -19.161 -16.243  1.00 20.01           O  
ATOM    254  OD2 ASP A  34       0.955 -21.064 -17.034  1.00 17.43           O  
ATOM    255  N   ASP A  35       2.187 -21.438 -13.993  1.00 18.01           N  
ATOM    256  CA  ASP A  35       3.477 -22.109 -14.022  1.00 17.04           C  
ATOM    257  C   ASP A  35       4.262 -21.935 -12.725  1.00 16.24           C  
ATOM    258  O   ASP A  35       5.479 -22.094 -12.711  1.00 14.82           O  
ATOM    259  CB  ASP A  35       4.293 -21.560 -15.191  1.00 19.02           C  
ATOM    260  CG  ASP A  35       4.576 -20.077 -15.049  1.00 19.18           C  
ATOM    261  OD1 ASP A  35       3.668 -19.341 -14.613  1.00 22.18           O  
ATOM    262  OD2 ASP A  35       5.699 -19.643 -15.374  1.00 22.15           O  
ATOM    263  N   ALA A  36       3.565 -21.620 -11.639  1.00 14.67           N  
ATOM    264  CA  ALA A  36       4.200 -21.404 -10.339  1.00 14.45           C  
ATOM    265  C   ALA A  36       5.021 -22.582  -9.824  1.00 15.25           C  
ATOM    266  O   ALA A  36       4.833 -23.714 -10.257  1.00 18.13           O  
ATOM    267  CB  ALA A  36       3.135 -21.041  -9.312  1.00 13.39           C  
ATOM    268  N   THR A  37       5.936 -22.309  -8.897  1.00 15.46           N  
ATOM    269  CA  THR A  37       6.760 -23.364  -8.307  1.00 15.70           C  
ATOM    270  C   THR A  37       6.659 -23.294  -6.797  1.00 16.31           C  
ATOM    271  O   THR A  37       6.737 -22.218  -6.205  1.00 19.56           O  
ATOM    272  CB  THR A  37       8.248 -23.253  -8.700  1.00 14.31           C  
ATOM    273  OG1 THR A  37       8.799 -22.048  -8.163  1.00 18.31           O  
ATOM    274  CG2 THR A  37       8.396 -23.241 -10.201  1.00 13.27           C  
ATOM    275  N   VAL A  38       6.468 -24.446  -6.176  1.00 15.00           N  
ATOM    276  CA  VAL A  38       6.340 -24.518  -4.739  1.00 12.64           C  
ATOM    277  C   VAL A  38       7.419 -25.413  -4.166  1.00 13.78           C  
ATOM    278  O   VAL A  38       7.677 -26.491  -4.698  1.00 13.70           O  
ATOM    279  CB  VAL A  38       4.969 -25.090  -4.362  1.00 11.43           C  
ATOM    280  CG1 VAL A  38       4.921 -25.420  -2.899  1.00 10.66           C  
ATOM    281  CG2 VAL A  38       3.890 -24.098  -4.707  1.00  9.30           C  
ATOM    282  N   GLU A  39       8.058 -24.947  -3.094  1.00 14.70           N  
ATOM    283  CA  GLU A  39       9.086 -25.709  -2.382  1.00 16.68           C  
ATOM    284  C   GLU A  39       8.575 -25.894  -0.961  1.00 17.40           C  
ATOM    285  O   GLU A  39       8.636 -24.975  -0.140  1.00 15.98           O  
ATOM    286  CB  GLU A  39      10.411 -24.953  -2.370  1.00 19.04           C  
ATOM    287  CG  GLU A  39      11.073 -24.923  -3.728  1.00 22.51           C  
ATOM    288  CD  GLU A  39      12.218 -23.955  -3.794  1.00 26.00           C  
ATOM    289  OE1 GLU A  39      11.976 -22.733  -3.674  1.00 27.08           O  
ATOM    290  OE2 GLU A  39      13.365 -24.416  -3.966  1.00 28.93           O  
ATOM    291  N   ASN A  40       8.059 -27.088  -0.688  1.00 17.99           N  
ATOM    292  CA  ASN A  40       7.491 -27.416   0.610  1.00 18.82           C  
ATOM    293  C   ASN A  40       7.864 -28.854   0.972  1.00 19.28           C  
ATOM    294  O   ASN A  40       7.390 -29.800   0.354  1.00 21.31           O  
ATOM    295  CB  ASN A  40       5.969 -27.280   0.538  1.00 17.17           C  
ATOM    296  CG  ASN A  40       5.319 -27.141   1.905  1.00 18.38           C  
ATOM    297  OD1 ASN A  40       5.837 -27.608   2.919  1.00 16.54           O  
ATOM    298  ND2 ASN A  40       4.153 -26.510   1.926  1.00 19.01           N  
ATOM    299  N   PRO A  41       8.760 -29.034   1.947  1.00 20.68           N  
ATOM    300  CA  PRO A  41       9.427 -27.972   2.701  1.00 21.58           C  
ATOM    301  C   PRO A  41      10.614 -27.431   1.903  1.00 22.49           C  
ATOM    302  O   PRO A  41      11.041 -28.039   0.920  1.00 22.32           O  
ATOM    303  CB  PRO A  41       9.861 -28.685   3.980  1.00 22.41           C  
ATOM    304  CG  PRO A  41      10.186 -30.055   3.480  1.00 22.14           C  
ATOM    305  CD  PRO A  41       9.041 -30.355   2.539  1.00 20.70           C  
ATOM    306  N   PHE A  42      11.135 -26.281   2.316  1.00 23.16           N  
ATOM    307  CA  PHE A  42      12.280 -25.701   1.628  1.00 25.12           C  
ATOM    308  C   PHE A  42      13.416 -26.697   1.729  1.00 24.39           C  
ATOM    309  O   PHE A  42      13.685 -27.237   2.804  1.00 22.93           O  
ATOM    310  CB  PHE A  42      12.715 -24.391   2.281  1.00 25.86           C  
ATOM    311  CG  PHE A  42      13.928 -23.770   1.638  1.00 28.18           C  
ATOM    312  CD1 PHE A  42      13.823 -23.095   0.429  1.00 27.29           C  
ATOM    313  CD2 PHE A  42      15.179 -23.863   2.248  1.00 28.41           C  
ATOM    314  CE1 PHE A  42      14.942 -22.519  -0.158  1.00 29.11           C  
ATOM    315  CE2 PHE A  42      16.304 -23.289   1.670  1.00 28.37           C  
ATOM    316  CZ  PHE A  42      16.187 -22.616   0.467  1.00 28.77           C  
ATOM    317  N   GLY A  43      14.076 -26.932   0.603  1.00 25.64           N  
ATOM    318  CA  GLY A  43      15.180 -27.871   0.577  1.00 28.49           C  
ATOM    319  C   GLY A  43      14.859 -29.080  -0.275  1.00 30.03           C  
ATOM    320  O   GLY A  43      15.752 -29.698  -0.858  1.00 31.23           O  
ATOM    321  N   GLN A  44      13.577 -29.421  -0.340  1.00 31.04           N  
ATOM    322  CA  GLN A  44      13.123 -30.554  -1.132  1.00 32.27           C  
ATOM    323  C   GLN A  44      12.941 -30.090  -2.573  1.00 31.95           C  
ATOM    324  O   GLN A  44      12.877 -28.888  -2.848  1.00 31.57           O  
ATOM    325  CB  GLN A  44      11.786 -31.063  -0.590  1.00 35.89           C  
ATOM    326  CG  GLN A  44      11.732 -32.560  -0.395  1.00 40.43           C  
ATOM    327  CD  GLN A  44      12.895 -33.059   0.434  1.00 44.07           C  
ATOM    328  OE1 GLN A  44      13.138 -32.568   1.538  1.00 45.42           O  
ATOM    329  NE2 GLN A  44      13.626 -34.039  -0.094  1.00 46.42           N  
ATOM    330  N   PRO A  45      12.875 -31.033  -3.522  1.00 30.13           N  
ATOM    331  CA  PRO A  45      12.690 -30.608  -4.909  1.00 29.25           C  
ATOM    332  C   PRO A  45      11.312 -29.960  -5.051  1.00 27.00           C  
ATOM    333  O   PRO A  45      10.319 -30.460  -4.530  1.00 25.34           O  
ATOM    334  CB  PRO A  45      12.832 -31.914  -5.689  1.00 30.88           C  
ATOM    335  CG  PRO A  45      12.337 -32.942  -4.718  1.00 32.69           C  
ATOM    336  CD  PRO A  45      12.993 -32.497  -3.431  1.00 32.39           C  
ATOM    337  N   PRO A  46      11.243 -28.832  -5.758  1.00 25.42           N  
ATOM    338  CA  PRO A  46      10.001 -28.089  -5.975  1.00 24.65           C  
ATOM    339  C   PRO A  46       8.991 -28.752  -6.885  1.00 23.11           C  
ATOM    340  O   PRO A  46       9.346 -29.561  -7.743  1.00 21.56           O  
ATOM    341  CB  PRO A  46      10.494 -26.779  -6.567  1.00 26.16           C  
ATOM    342  CG  PRO A  46      11.638 -27.237  -7.411  1.00 27.52           C  
ATOM    343  CD  PRO A  46      12.358 -28.206  -6.489  1.00 26.86           C  
ATOM    344  N   ILE A  47       7.724 -28.406  -6.682  1.00 21.84           N  
ATOM    345  CA  ILE A  47       6.666 -28.921  -7.520  1.00 19.99           C  
ATOM    346  C   ILE A  47       6.401 -27.751  -8.449  1.00 19.95           C  
ATOM    347  O   ILE A  47       6.566 -26.595  -8.055  1.00 20.28           O  
ATOM    348  CB  ILE A  47       5.413 -29.286  -6.715  1.00 21.45           C  
ATOM    349  CG1 ILE A  47       4.722 -28.036  -6.205  1.00 23.27           C  
ATOM    350  CG2 ILE A  47       5.797 -30.141  -5.529  1.00 21.41           C  
ATOM    351  CD1 ILE A  47       3.431 -28.361  -5.500  1.00 26.96           C  
ATOM    352  N   HIS A  48       6.001 -28.037  -9.681  1.00 19.56           N  
ATOM    353  CA  HIS A  48       5.792 -26.980 -10.663  1.00 18.19           C  
ATOM    354  C   HIS A  48       4.462 -27.043 -11.396  1.00 15.52           C  
ATOM    355  O   HIS A  48       4.045 -28.103 -11.851  1.00 15.33           O  
ATOM    356  CB  HIS A  48       6.940 -27.030 -11.683  1.00 21.54           C  
ATOM    357  CG  HIS A  48       6.813 -26.041 -12.799  1.00 26.73           C  
ATOM    358  ND1 HIS A  48       7.272 -24.744 -12.703  1.00 29.20           N  
ATOM    359  CD2 HIS A  48       6.277 -26.159 -14.039  1.00 29.57           C  
ATOM    360  CE1 HIS A  48       7.024 -24.106 -13.835  1.00 30.38           C  
ATOM    361  NE2 HIS A  48       6.420 -24.942 -14.661  1.00 31.89           N  
ATOM    362  N   GLY A  49       3.803 -25.898 -11.522  1.00 13.31           N  
ATOM    363  CA  GLY A  49       2.542 -25.856 -12.245  1.00 13.54           C  
ATOM    364  C   GLY A  49       1.304 -26.169 -11.431  1.00 13.14           C  
ATOM    365  O   GLY A  49       1.366 -26.934 -10.470  1.00 13.05           O  
ATOM    366  N   ARG A  50       0.175 -25.589 -11.831  1.00 12.85           N  
ATOM    367  CA  ARG A  50      -1.074 -25.796 -11.123  1.00 13.74           C  
ATOM    368  C   ARG A  50      -1.509 -27.245 -11.001  1.00 15.73           C  
ATOM    369  O   ARG A  50      -2.107 -27.622  -9.998  1.00 17.91           O  
ATOM    370  CB  ARG A  50      -2.190 -24.989 -11.769  1.00 13.33           C  
ATOM    371  CG  ARG A  50      -2.226 -23.542 -11.348  1.00 15.86           C  
ATOM    372  CD  ARG A  50      -3.343 -22.837 -12.076  1.00 16.14           C  
ATOM    373  NE  ARG A  50      -3.501 -21.446 -11.675  1.00 19.17           N  
ATOM    374  CZ  ARG A  50      -4.330 -20.604 -12.280  1.00 20.98           C  
ATOM    375  NH1 ARG A  50      -5.063 -21.025 -13.306  1.00 20.68           N  
ATOM    376  NH2 ARG A  50      -4.431 -19.347 -11.871  1.00 23.53           N  
ATOM    377  N   GLU A  51      -1.232 -28.079 -11.995  1.00 16.48           N  
ATOM    378  CA  GLU A  51      -1.649 -29.462 -11.847  1.00 16.76           C  
ATOM    379  C   GLU A  51      -0.972 -30.068 -10.623  1.00 16.31           C  
ATOM    380  O   GLU A  51      -1.643 -30.588  -9.729  1.00 16.00           O  
ATOM    381  CB  GLU A  51      -1.327 -30.305 -13.087  1.00 19.52           C  
ATOM    382  CG  GLU A  51      -1.718 -31.774 -12.882  1.00 23.49           C  
ATOM    383  CD  GLU A  51      -1.319 -32.687 -14.023  1.00 25.96           C  
ATOM    384  OE1 GLU A  51      -0.167 -32.595 -14.507  1.00 27.74           O  
ATOM    385  OE2 GLU A  51      -2.159 -33.518 -14.424  1.00 29.16           O  
ATOM    386  N   GLN A  52       0.354 -29.993 -10.569  1.00 15.87           N  
ATOM    387  CA  GLN A  52       1.075 -30.548  -9.436  1.00 16.48           C  
ATOM    388  C   GLN A  52       0.711 -29.876  -8.107  1.00 16.86           C  
ATOM    389  O   GLN A  52       0.646 -30.531  -7.065  1.00 15.40           O  
ATOM    390  CB  GLN A  52       2.584 -30.475  -9.689  1.00 18.07           C  
ATOM    391  CG  GLN A  52       3.080 -31.592 -10.610  1.00 23.51           C  
ATOM    392  CD  GLN A  52       4.503 -31.392 -11.105  1.00 26.46           C  
ATOM    393  OE1 GLN A  52       5.443 -31.220 -10.318  1.00 26.51           O  
ATOM    394  NE2 GLN A  52       4.673 -31.424 -12.428  1.00 28.82           N  
ATOM    395  N   ILE A  53       0.449 -28.575  -8.141  1.00 15.62           N  
ATOM    396  CA  ILE A  53       0.092 -27.858  -6.924  1.00 14.19           C  
ATOM    397  C   ILE A  53      -1.254 -28.346  -6.394  1.00 14.31           C  
ATOM    398  O   ILE A  53      -1.425 -28.556  -5.190  1.00 12.76           O  
ATOM    399  CB  ILE A  53       0.042 -26.338  -7.178  1.00 15.46           C  
ATOM    400  CG1 ILE A  53       1.423 -25.854  -7.645  1.00 13.14           C  
ATOM    401  CG2 ILE A  53      -0.384 -25.604  -5.904  1.00 15.28           C  
ATOM    402  CD1 ILE A  53       1.475 -24.396  -8.023  1.00 13.75           C  
ATOM    403  N   ALA A  54      -2.216 -28.531  -7.288  1.00 13.79           N  
ATOM    404  CA  ALA A  54      -3.520 -29.017  -6.868  1.00 13.79           C  
ATOM    405  C   ALA A  54      -3.303 -30.395  -6.259  1.00 14.08           C  
ATOM    406  O   ALA A  54      -3.812 -30.703  -5.177  1.00 16.09           O  
ATOM    407  CB  ALA A  54      -4.454 -29.105  -8.056  1.00 13.35           C  
ATOM    408  N   ALA A  55      -2.525 -31.221  -6.948  1.00 13.69           N  
ATOM    409  CA  ALA A  55      -2.240 -32.558  -6.452  1.00 13.97           C  
ATOM    410  C   ALA A  55      -1.708 -32.484  -5.011  1.00 14.33           C  
ATOM    411  O   ALA A  55      -2.183 -33.189  -4.124  1.00 13.14           O  
ATOM    412  CB  ALA A  55      -1.234 -33.239  -7.352  1.00 13.64           C  
ATOM    413  N   PHE A  56      -0.728 -31.619  -4.784  1.00 14.24           N  
ATOM    414  CA  PHE A  56      -0.144 -31.465  -3.460  1.00 15.31           C  
ATOM    415  C   PHE A  56      -1.182 -31.120  -2.395  1.00 16.56           C  
ATOM    416  O   PHE A  56      -1.270 -31.779  -1.355  1.00 15.05           O  
ATOM    417  CB  PHE A  56       0.912 -30.364  -3.488  1.00 17.51           C  
ATOM    418  CG  PHE A  56       1.380 -29.932  -2.127  1.00 16.62           C  
ATOM    419  CD1 PHE A  56       2.261 -30.717  -1.397  1.00 17.78           C  
ATOM    420  CD2 PHE A  56       0.948 -28.728  -1.584  1.00 15.72           C  
ATOM    421  CE1 PHE A  56       2.713 -30.305  -0.142  1.00 19.31           C  
ATOM    422  CE2 PHE A  56       1.392 -28.308  -0.332  1.00 16.26           C  
ATOM    423  CZ  PHE A  56       2.277 -29.096   0.392  1.00 19.12           C  
ATOM    424  N   PHE A  57      -1.965 -30.082  -2.658  1.00 15.58           N  
ATOM    425  CA  PHE A  57      -2.963 -29.643  -1.698  1.00 18.57           C  
ATOM    426  C   PHE A  57      -4.074 -30.647  -1.464  1.00 19.20           C  
ATOM    427  O   PHE A  57      -4.573 -30.778  -0.349  1.00 18.41           O  
ATOM    428  CB  PHE A  57      -3.554 -28.298  -2.124  1.00 17.25           C  
ATOM    429  CG  PHE A  57      -2.640 -27.132  -1.870  1.00 19.05           C  
ATOM    430  CD1 PHE A  57      -1.847 -26.611  -2.888  1.00 19.58           C  
ATOM    431  CD2 PHE A  57      -2.569 -26.555  -0.605  1.00 19.14           C  
ATOM    432  CE1 PHE A  57      -0.994 -25.524  -2.652  1.00 18.02           C  
ATOM    433  CE2 PHE A  57      -1.721 -25.469  -0.354  1.00 18.87           C  
ATOM    434  CZ  PHE A  57      -0.933 -24.953  -1.384  1.00 18.82           C  
ATOM    435  N   ARG A  58      -4.455 -31.365  -2.510  1.00 21.29           N  
ATOM    436  CA  ARG A  58      -5.509 -32.354  -2.371  1.00 24.30           C  
ATOM    437  C   ARG A  58      -5.008 -33.442  -1.431  1.00 24.43           C  
ATOM    438  O   ARG A  58      -5.733 -33.908  -0.558  1.00 25.51           O  
ATOM    439  CB  ARG A  58      -5.859 -32.925  -3.742  1.00 25.95           C  
ATOM    440  CG  ARG A  58      -7.149 -33.701  -3.776  1.00 29.96           C  
ATOM    441  CD  ARG A  58      -7.686 -33.796  -5.192  1.00 31.98           C  
ATOM    442  NE  ARG A  58      -8.295 -32.547  -5.650  1.00 35.59           N  
ATOM    443  CZ  ARG A  58      -9.333 -31.947  -5.062  1.00 38.51           C  
ATOM    444  NH1 ARG A  58      -9.891 -32.468  -3.973  1.00 39.24           N  
ATOM    445  NH2 ARG A  58      -9.838 -30.832  -5.576  1.00 38.40           N  
ATOM    446  N   GLN A  59      -3.745 -33.812  -1.604  1.00 25.47           N  
ATOM    447  CA  GLN A  59      -3.095 -34.833  -0.792  1.00 26.75           C  
ATOM    448  C   GLN A  59      -2.958 -34.407   0.672  1.00 26.41           C  
ATOM    449  O   GLN A  59      -3.139 -35.217   1.582  1.00 26.80           O  
ATOM    450  CB  GLN A  59      -1.701 -35.112  -1.352  1.00 28.88           C  
ATOM    451  CG  GLN A  59      -0.967 -36.244  -0.671  1.00 33.65           C  
ATOM    452  CD  GLN A  59      -1.233 -37.581  -1.333  1.00 36.73           C  
ATOM    453  OE1 GLN A  59      -0.789 -37.824  -2.460  1.00 38.53           O  
ATOM    454  NE2 GLN A  59      -1.963 -38.457  -0.644  1.00 37.23           N  
ATOM    455  N   GLY A  60      -2.636 -33.133   0.883  1.00 25.13           N  
ATOM    456  CA  GLY A  60      -2.445 -32.614   2.227  1.00 26.08           C  
ATOM    457  C   GLY A  60      -3.697 -32.276   3.016  1.00 26.13           C  
ATOM    458  O   GLY A  60      -3.780 -32.562   4.209  1.00 25.85           O  
ATOM    459  N   LEU A  61      -4.667 -31.654   2.361  1.00 26.74           N  
ATOM    460  CA  LEU A  61      -5.902 -31.288   3.025  1.00 26.91           C  
ATOM    461  C   LEU A  61      -6.974 -32.320   2.717  1.00 27.30           C  
ATOM    462  O   LEU A  61      -7.797 -32.632   3.570  1.00 28.69           O  
ATOM    463  CB  LEU A  61      -6.366 -29.910   2.563  1.00 27.59           C  
ATOM    464  CG  LEU A  61      -5.546 -28.676   2.963  1.00 28.07           C  
ATOM    465  CD1 LEU A  61      -4.121 -28.795   2.470  1.00 27.99           C  
ATOM    466  CD2 LEU A  61      -6.198 -27.440   2.368  1.00 28.37           C  
ATOM    467  N   LYS A  65      -8.908 -33.326   8.071  1.00 41.02           N  
ATOM    468  CA  LYS A  65      -9.002 -32.511   9.278  1.00 41.21           C  
ATOM    469  C   LYS A  65      -7.771 -31.620   9.460  1.00 39.08           C  
ATOM    470  O   LYS A  65      -6.826 -31.991  10.157  1.00 39.60           O  
ATOM    471  CB  LYS A  65      -9.167 -33.402  10.520  1.00 44.32           C  
ATOM    472  CG  LYS A  65      -9.131 -32.632  11.853  1.00 47.17           C  
ATOM    473  CD  LYS A  65      -9.252 -33.556  13.074  1.00 49.91           C  
ATOM    474  CE  LYS A  65      -9.103 -32.779  14.395  1.00 50.83           C  
ATOM    475  NZ  LYS A  65      -9.185 -33.644  15.620  1.00 51.38           N  
ATOM    476  N   VAL A  66      -7.783 -30.445   8.842  1.00 35.17           N  
ATOM    477  CA  VAL A  66      -6.655 -29.539   8.967  1.00 32.72           C  
ATOM    478  C   VAL A  66      -7.083 -28.095   9.102  1.00 32.18           C  
ATOM    479  O   VAL A  66      -7.809 -27.575   8.257  1.00 31.41           O  
ATOM    480  CB  VAL A  66      -5.708 -29.638   7.755  1.00 31.49           C  
ATOM    481  CG1 VAL A  66      -4.597 -28.618   7.892  1.00 30.13           C  
ATOM    482  CG2 VAL A  66      -5.123 -31.034   7.659  1.00 30.97           C  
ATOM    483  N   ARG A  67      -6.643 -27.451  10.179  1.00 32.28           N  
ATOM    484  CA  ARG A  67      -6.951 -26.043  10.391  1.00 30.76           C  
ATOM    485  C   ARG A  67      -5.632 -25.279  10.408  1.00 27.44           C  
ATOM    486  O   ARG A  67      -4.595 -25.811  10.804  1.00 24.24           O  
ATOM    487  CB  ARG A  67      -7.734 -25.830  11.696  1.00 34.79           C  
ATOM    488  CG  ARG A  67      -7.064 -26.333  12.965  1.00 41.78           C  
ATOM    489  CD  ARG A  67      -7.942 -26.089  14.212  1.00 47.65           C  
ATOM    490  NE  ARG A  67      -7.525 -24.933  15.019  1.00 53.13           N  
ATOM    491  CZ  ARG A  67      -7.655 -23.654  14.659  1.00 55.61           C  
ATOM    492  NH1 ARG A  67      -8.200 -23.335  13.490  1.00 57.11           N  
ATOM    493  NH2 ARG A  67      -7.235 -22.688  15.469  1.00 55.53           N  
ATOM    494  N   ALA A  68      -5.670 -24.040   9.941  1.00 24.72           N  
ATOM    495  CA  ALA A  68      -4.473 -23.218   9.882  1.00 23.36           C  
ATOM    496  C   ALA A  68      -4.819 -21.829  10.352  1.00 23.17           C  
ATOM    497  O   ALA A  68      -5.981 -21.431  10.305  1.00 24.50           O  
ATOM    498  CB  ALA A  68      -3.952 -23.166   8.461  1.00 22.16           C  
ATOM    499  N   CYS A  69      -3.821 -21.084  10.805  1.00 22.01           N  
ATOM    500  CA  CYS A  69      -4.076 -19.730  11.267  1.00 21.85           C  
ATOM    501  C   CYS A  69      -2.804 -18.937  11.460  1.00 20.74           C  
ATOM    502  O   CYS A  69      -1.810 -19.467  11.960  1.00 19.91           O  
ATOM    503  CB  CYS A  69      -4.847 -19.774  12.581  1.00 23.08           C  
ATOM    504  SG  CYS A  69      -4.119 -20.928  13.742  1.00 29.68           S  
ATOM    505  N   LEU A  70      -2.846 -17.668  11.056  1.00 20.18           N  
ATOM    506  CA  LEU A  70      -1.711 -16.766  11.199  1.00 19.88           C  
ATOM    507  C   LEU A  70      -1.372 -16.669  12.677  1.00 19.92           C  
ATOM    508  O   LEU A  70      -2.269 -16.495  13.500  1.00 20.77           O  
ATOM    509  CB  LEU A  70      -2.073 -15.371  10.694  1.00 17.84           C  
ATOM    510  CG  LEU A  70      -2.250 -15.146   9.198  1.00 20.04           C  
ATOM    511  CD1 LEU A  70      -2.765 -13.733   8.981  1.00 19.56           C  
ATOM    512  CD2 LEU A  70      -0.921 -15.364   8.462  1.00 18.94           C  
ATOM    513  N   THR A  71      -0.088 -16.771  13.018  1.00 18.25           N  
ATOM    514  CA  THR A  71       0.328 -16.692  14.415  1.00 16.28           C  
ATOM    515  C   THR A  71       1.007 -15.360  14.692  1.00 16.39           C  
ATOM    516  O   THR A  71       1.471 -15.108  15.800  1.00 15.82           O  
ATOM    517  CB  THR A  71       1.302 -17.825  14.768  1.00 17.80           C  
ATOM    518  OG1 THR A  71       2.393 -17.820  13.839  1.00 19.73           O  
ATOM    519  CG2 THR A  71       0.599 -19.164  14.713  1.00 15.84           C  
ATOM    520  N   GLY A  72       1.067 -14.523  13.664  1.00 13.88           N  
ATOM    521  CA  GLY A  72       1.678 -13.219  13.777  1.00 14.04           C  
ATOM    522  C   GLY A  72       1.281 -12.420  12.555  1.00 13.14           C  
ATOM    523  O   GLY A  72       0.711 -12.984  11.620  1.00 15.71           O  
ATOM    524  N   PRO A  73       1.551 -11.111  12.518  1.00 12.34           N  
ATOM    525  CA  PRO A  73       1.156 -10.373  11.320  1.00 10.79           C  
ATOM    526  C   PRO A  73       1.975 -10.747  10.094  1.00 10.51           C  
ATOM    527  O   PRO A  73       3.009 -11.399  10.189  1.00 11.23           O  
ATOM    528  CB  PRO A  73       1.346  -8.916  11.741  1.00 11.88           C  
ATOM    529  CG  PRO A  73       2.453  -9.002  12.739  1.00 11.87           C  
ATOM    530  CD  PRO A  73       2.074 -10.197  13.552  1.00 13.14           C  
ATOM    531  N   VAL A  74       1.496 -10.329   8.936  1.00 11.14           N  
ATOM    532  CA  VAL A  74       2.169 -10.606   7.681  1.00 11.59           C  
ATOM    533  C   VAL A  74       3.200  -9.527   7.367  1.00 12.27           C  
ATOM    534  O   VAL A  74       2.878  -8.338   7.254  1.00 11.28           O  
ATOM    535  CB  VAL A  74       1.153 -10.667   6.518  1.00 10.39           C  
ATOM    536  CG1 VAL A  74       1.856 -11.003   5.231  1.00  9.85           C  
ATOM    537  CG2 VAL A  74       0.074 -11.699   6.825  1.00 11.84           C  
ATOM    538  N   ARG A  75       4.452  -9.933   7.237  1.00 11.78           N  
ATOM    539  CA  ARG A  75       5.490  -8.982   6.896  1.00 12.46           C  
ATOM    540  C   ARG A  75       5.506  -8.871   5.369  1.00 15.06           C  
ATOM    541  O   ARG A  75       5.464  -9.890   4.670  1.00 16.94           O  
ATOM    542  CB  ARG A  75       6.838  -9.466   7.413  1.00 10.36           C  
ATOM    543  CG  ARG A  75       7.073  -9.199   8.884  1.00 12.19           C  
ATOM    544  CD  ARG A  75       6.107  -9.940   9.793  1.00 12.08           C  
ATOM    545  NE  ARG A  75       6.702 -10.061  11.120  1.00 16.07           N  
ATOM    546  CZ  ARG A  75       6.243 -10.839  12.098  1.00 15.62           C  
ATOM    547  NH1 ARG A  75       5.160 -11.585  11.926  1.00 13.90           N  
ATOM    548  NH2 ARG A  75       6.894 -10.886  13.250  1.00 16.73           N  
ATOM    549  N   ALA A  76       5.552  -7.650   4.847  1.00 15.75           N  
ATOM    550  CA  ALA A  76       5.560  -7.464   3.396  1.00 17.30           C  
ATOM    551  C   ALA A  76       6.571  -6.423   2.935  1.00 19.50           C  
ATOM    552  O   ALA A  76       6.921  -5.510   3.689  1.00 20.27           O  
ATOM    553  CB  ALA A  76       4.168  -7.067   2.922  1.00 15.87           C  
ATOM    554  N   SER A  77       7.037  -6.568   1.694  1.00 20.15           N  
ATOM    555  CA  SER A  77       7.987  -5.622   1.114  1.00 21.34           C  
ATOM    556  C   SER A  77       7.294  -4.829   0.007  1.00 21.37           C  
ATOM    557  O   SER A  77       6.080  -4.912  -0.170  1.00 19.69           O  
ATOM    558  CB  SER A  77       9.198  -6.341   0.529  1.00 21.55           C  
ATOM    559  OG  SER A  77       8.844  -7.022  -0.654  1.00 23.30           O  
ATOM    560  N   HIS A  78       8.072  -4.069  -0.752  1.00 23.31           N  
ATOM    561  CA  HIS A  78       7.500  -3.255  -1.812  1.00 23.82           C  
ATOM    562  C   HIS A  78       7.738  -3.784  -3.210  1.00 24.60           C  
ATOM    563  O   HIS A  78       7.433  -3.103  -4.192  1.00 26.67           O  
ATOM    564  CB  HIS A  78       8.022  -1.826  -1.697  1.00 24.59           C  
ATOM    565  CG  HIS A  78       7.596  -1.136  -0.441  1.00 22.27           C  
ATOM    566  ND1 HIS A  78       6.281  -0.817  -0.181  1.00 24.08           N  
ATOM    567  CD2 HIS A  78       8.304  -0.728   0.637  1.00 21.87           C  
ATOM    568  CE1 HIS A  78       6.198  -0.241   1.005  1.00 20.93           C  
ATOM    569  NE2 HIS A  78       7.411  -0.176   1.522  1.00 20.67           N  
ATOM    570  N   ASN A  79       8.291  -4.987  -3.314  1.00 23.19           N  
ATOM    571  CA  ASN A  79       8.515  -5.561  -4.632  1.00 21.60           C  
ATOM    572  C   ASN A  79       7.696  -6.834  -4.834  1.00 20.74           C  
ATOM    573  O   ASN A  79       8.085  -7.735  -5.576  1.00 19.74           O  
ATOM    574  CB  ASN A  79      10.018  -5.806  -4.900  1.00 21.73           C  
ATOM    575  CG  ASN A  79      10.673  -6.731  -3.891  1.00 21.10           C  
ATOM    576  OD1 ASN A  79      11.789  -7.210  -4.113  1.00 22.62           O  
ATOM    577  ND2 ASN A  79       9.995  -6.983  -2.777  1.00 21.56           N  
ATOM    578  N   GLY A  80       6.549  -6.887  -4.165  1.00 19.40           N  
ATOM    579  CA  GLY A  80       5.653  -8.020  -4.295  1.00 18.27           C  
ATOM    580  C   GLY A  80       6.043  -9.276  -3.548  1.00 17.68           C  
ATOM    581  O   GLY A  80       5.723 -10.382  -3.989  1.00 16.57           O  
ATOM    582  N   CYS A  81       6.731  -9.120  -2.423  1.00 16.76           N  
ATOM    583  CA  CYS A  81       7.137 -10.274  -1.633  1.00 16.98           C  
ATOM    584  C   CYS A  81       6.569 -10.177  -0.219  1.00 15.39           C  
ATOM    585  O   CYS A  81       6.345  -9.082   0.306  1.00 13.29           O  
ATOM    586  CB  CYS A  81       8.668 -10.384  -1.574  1.00 19.04           C  
ATOM    587  SG  CYS A  81       9.470 -11.142  -3.030  1.00 26.25           S  
ATOM    588  N   GLY A  82       6.328 -11.333   0.387  1.00 13.10           N  
ATOM    589  CA  GLY A  82       5.804 -11.362   1.734  1.00  9.35           C  
ATOM    590  C   GLY A  82       6.214 -12.634   2.442  1.00  7.98           C  
ATOM    591  O   GLY A  82       6.564 -13.622   1.810  1.00  9.89           O  
ATOM    592  N   ALA A  83       6.179 -12.600   3.764  1.00  5.37           N  
ATOM    593  CA  ALA A  83       6.529 -13.750   4.578  1.00  4.07           C  
ATOM    594  C   ALA A  83       5.576 -13.732   5.773  1.00  5.97           C  
ATOM    595  O   ALA A  83       5.307 -12.672   6.337  1.00  4.99           O  
ATOM    596  CB  ALA A  83       7.974 -13.634   5.039  1.00  5.41           C  
ATOM    597  N   MET A  84       5.063 -14.892   6.161  1.00  5.68           N  
ATOM    598  CA  MET A  84       4.123 -14.937   7.270  1.00  6.41           C  
ATOM    599  C   MET A  84       4.315 -16.113   8.211  1.00  7.91           C  
ATOM    600  O   MET A  84       4.708 -17.196   7.792  1.00  4.25           O  
ATOM    601  CB  MET A  84       2.690 -14.969   6.729  1.00  9.76           C  
ATOM    602  CG  MET A  84       2.369 -16.190   5.872  1.00 12.94           C  
ATOM    603  SD  MET A  84       0.700 -16.149   5.143  1.00 19.27           S  
ATOM    604  CE  MET A  84       0.801 -17.551   3.981  1.00 15.88           C  
ATOM    605  N   PRO A  85       4.045 -15.904   9.509  1.00  8.95           N  
ATOM    606  CA  PRO A  85       4.181 -16.961  10.510  1.00 10.78           C  
ATOM    607  C   PRO A  85       2.801 -17.595  10.739  1.00  9.53           C  
ATOM    608  O   PRO A  85       1.809 -16.880  10.893  1.00  9.94           O  
ATOM    609  CB  PRO A  85       4.673 -16.195  11.733  1.00 11.57           C  
ATOM    610  CG  PRO A  85       3.854 -14.933  11.649  1.00  9.65           C  
ATOM    611  CD  PRO A  85       3.877 -14.587  10.159  1.00 11.32           C  
ATOM    612  N   PHE A  86       2.722 -18.920  10.744  1.00  8.96           N  
ATOM    613  CA  PHE A  86       1.432 -19.565  10.968  1.00 10.32           C  
ATOM    614  C   PHE A  86       1.573 -20.990  11.452  1.00 11.76           C  
ATOM    615  O   PHE A  86       2.620 -21.625  11.284  1.00 11.70           O  
ATOM    616  CB  PHE A  86       0.577 -19.528   9.688  1.00 10.95           C  
ATOM    617  CG  PHE A  86       1.138 -20.346   8.542  1.00  9.97           C  
ATOM    618  CD1 PHE A  86       0.691 -21.639   8.308  1.00 12.69           C  
ATOM    619  CD2 PHE A  86       2.109 -19.812   7.695  1.00 12.57           C  
ATOM    620  CE1 PHE A  86       1.198 -22.396   7.245  1.00 10.49           C  
ATOM    621  CE2 PHE A  86       2.628 -20.555   6.627  1.00 12.65           C  
ATOM    622  CZ  PHE A  86       2.168 -21.849   6.404  1.00 13.29           C  
ATOM    623  N   ARG A  87       0.510 -21.488  12.060  1.00 13.86           N  
ATOM    624  CA  ARG A  87       0.499 -22.842  12.579  1.00 18.35           C  
ATOM    625  C   ARG A  87      -0.494 -23.727  11.851  1.00 19.73           C  
ATOM    626  O   ARG A  87      -1.611 -23.305  11.545  1.00 18.53           O  
ATOM    627  CB  ARG A  87       0.164 -22.836  14.067  1.00 20.73           C  
ATOM    628  CG  ARG A  87      -0.334 -24.179  14.563  1.00 24.83           C  
ATOM    629  CD  ARG A  87      -0.382 -24.203  16.057  1.00 30.89           C  
ATOM    630  NE  ARG A  87       0.965 -24.151  16.610  1.00 38.14           N  
ATOM    631  CZ  ARG A  87       1.243 -24.200  17.908  1.00 42.43           C  
ATOM    632  NH1 ARG A  87       0.259 -24.299  18.796  1.00 42.67           N  
ATOM    633  NH2 ARG A  87       2.506 -24.159  18.321  1.00 45.14           N  
ATOM    634  N   VAL A  88      -0.077 -24.961  11.590  1.00 21.69           N  
ATOM    635  CA  VAL A  88      -0.917 -25.936  10.910  1.00 24.89           C  
ATOM    636  C   VAL A  88      -1.229 -27.063  11.877  1.00 29.06           C  
ATOM    637  O   VAL A  88      -0.319 -27.717  12.388  1.00 29.69           O  
ATOM    638  CB  VAL A  88      -0.206 -26.562   9.688  1.00 23.79           C  
ATOM    639  CG1 VAL A  88      -1.124 -27.576   9.016  1.00 23.81           C  
ATOM    640  CG2 VAL A  88       0.207 -25.487   8.710  1.00 22.23           C  
ATOM    641  N   GLU A  89      -2.511 -27.291  12.138  1.00 32.78           N  
ATOM    642  CA  GLU A  89      -2.904 -28.373  13.028  1.00 37.77           C  
ATOM    643  C   GLU A  89      -3.491 -29.524  12.225  1.00 40.93           C  
ATOM    644  O   GLU A  89      -4.186 -29.306  11.230  1.00 41.33           O  
ATOM    645  CB  GLU A  89      -3.934 -27.890  14.047  1.00 37.63           C  
ATOM    646  CG  GLU A  89      -3.347 -27.121  15.197  1.00 39.25           C  
ATOM    647  CD  GLU A  89      -4.380 -26.808  16.251  1.00 41.24           C  
ATOM    648  OE1 GLU A  89      -5.279 -25.987  15.978  1.00 41.35           O  
ATOM    649  OE2 GLU A  89      -4.297 -27.391  17.352  1.00 43.21           O  
ATOM    650  N   MET A  90      -3.208 -30.749  12.652  1.00 45.13           N  
ATOM    651  CA  MET A  90      -3.737 -31.922  11.967  1.00 49.44           C  
ATOM    652  C   MET A  90      -3.834 -33.134  12.882  1.00 51.52           C  
ATOM    653  O   MET A  90      -3.659 -33.034  14.097  1.00 51.80           O  
ATOM    654  CB  MET A  90      -2.869 -32.281  10.762  1.00 50.02           C  
ATOM    655  CG  MET A  90      -1.448 -32.649  11.118  1.00 51.18           C  
ATOM    656  SD  MET A  90      -0.366 -31.225  11.136  1.00 53.58           S  
ATOM    657  CE  MET A  90       0.464 -31.464   9.589  1.00 51.11           C  
ATOM    658  N   VAL A  91      -4.121 -34.281  12.277  1.00 54.80           N  
ATOM    659  CA  VAL A  91      -4.240 -35.533  13.005  1.00 57.57           C  
ATOM    660  C   VAL A  91      -3.571 -36.638  12.209  1.00 59.15           C  
ATOM    661  O   VAL A  91      -4.196 -37.263  11.355  1.00 59.03           O  
ATOM    662  CB  VAL A  91      -5.708 -35.911  13.231  1.00 57.39           C  
ATOM    663  CG1 VAL A  91      -5.791 -37.292  13.855  1.00 58.15           C  
ATOM    664  CG2 VAL A  91      -6.370 -34.885  14.130  1.00 57.31           C  
ATOM    665  N   TRP A  92      -2.296 -36.868  12.491  1.00 61.50           N  
ATOM    666  CA  TRP A  92      -1.537 -37.891  11.796  1.00 64.22           C  
ATOM    667  C   TRP A  92      -1.797 -39.280  12.370  1.00 64.83           C  
ATOM    668  O   TRP A  92      -1.637 -39.508  13.571  1.00 65.63           O  
ATOM    669  CB  TRP A  92      -0.049 -37.564  11.861  1.00 66.50           C  
ATOM    670  CG  TRP A  92       0.802 -38.551  11.140  1.00 69.82           C  
ATOM    671  CD1 TRP A  92       0.414 -39.387  10.129  1.00 70.81           C  
ATOM    672  CD2 TRP A  92       2.199 -38.780  11.338  1.00 71.30           C  
ATOM    673  NE1 TRP A  92       1.487 -40.121   9.684  1.00 71.82           N  
ATOM    674  CE2 TRP A  92       2.595 -39.769  10.410  1.00 71.88           C  
ATOM    675  CE3 TRP A  92       3.156 -38.245  12.208  1.00 71.67           C  
ATOM    676  CZ2 TRP A  92       3.909 -40.235  10.327  1.00 72.80           C  
ATOM    677  CZ3 TRP A  92       4.463 -38.709  12.126  1.00 72.63           C  
ATOM    678  CH2 TRP A  92       4.826 -39.694  11.191  1.00 73.12           C  
ATOM    679  N   ASN A  93      -2.188 -40.203  11.493  1.00 64.97           N  
ATOM    680  CA  ASN A  93      -2.497 -41.582  11.869  1.00 64.29           C  
ATOM    681  C   ASN A  93      -3.179 -41.671  13.225  1.00 63.70           C  
ATOM    682  O   ASN A  93      -2.733 -42.393  14.118  1.00 63.73           O  
ATOM    683  CB  ASN A  93      -1.233 -42.450  11.853  1.00 64.32           C  
ATOM    684  CG  ASN A  93      -0.865 -42.917  10.452  1.00 64.14           C  
ATOM    685  OD1 ASN A  93      -0.586 -42.110   9.566  1.00 63.58           O  
ATOM    686  ND2 ASN A  93      -0.870 -44.229  10.248  1.00 64.00           N  
ATOM    687  N   GLY A  94      -4.269 -40.920  13.362  1.00 62.80           N  
ATOM    688  CA  GLY A  94      -5.028 -40.915  14.597  1.00 61.68           C  
ATOM    689  C   GLY A  94      -4.485 -39.969  15.646  1.00 60.60           C  
ATOM    690  O   GLY A  94      -5.226 -39.514  16.519  1.00 60.70           O  
ATOM    691  N   GLN A  95      -3.196 -39.659  15.562  1.00 59.33           N  
ATOM    692  CA  GLN A  95      -2.580 -38.774  16.540  1.00 58.02           C  
ATOM    693  C   GLN A  95      -2.576 -37.309  16.131  1.00 55.79           C  
ATOM    694  O   GLN A  95      -2.190 -36.958  15.013  1.00 55.13           O  
ATOM    695  CB  GLN A  95      -1.151 -39.229  16.836  1.00 59.76           C  
ATOM    696  CG  GLN A  95      -0.562 -38.601  18.088  1.00 61.72           C  
ATOM    697  CD  GLN A  95       0.551 -39.440  18.689  1.00 62.36           C  
ATOM    698  OE1 GLN A  95       0.357 -40.618  19.003  1.00 62.32           O  
ATOM    699  NE2 GLN A  95       1.720 -38.835  18.862  1.00 63.08           N  
ATOM    700  N   PRO A  96      -3.022 -36.431  17.042  1.00 53.63           N  
ATOM    701  CA  PRO A  96      -3.086 -34.985  16.817  1.00 51.91           C  
ATOM    702  C   PRO A  96      -1.717 -34.326  16.985  1.00 49.81           C  
ATOM    703  O   PRO A  96      -0.965 -34.667  17.904  1.00 51.27           O  
ATOM    704  CB  PRO A  96      -4.079 -34.525  17.878  1.00 52.78           C  
ATOM    705  CG  PRO A  96      -3.772 -35.445  19.017  1.00 52.87           C  
ATOM    706  CD  PRO A  96      -3.648 -36.788  18.329  1.00 53.10           C  
ATOM    707  N   CYS A  97      -1.393 -33.387  16.100  1.00 45.73           N  
ATOM    708  CA  CYS A  97      -0.114 -32.689  16.171  1.00 41.45           C  
ATOM    709  C   CYS A  97      -0.137 -31.357  15.434  1.00 37.72           C  
ATOM    710  O   CYS A  97      -0.971 -31.129  14.558  1.00 36.04           O  
ATOM    711  CB  CYS A  97       1.000 -33.572  15.613  1.00 42.16           C  
ATOM    712  SG  CYS A  97       0.633 -34.251  13.993  1.00 46.35           S  
ATOM    713  N   ALA A  98       0.789 -30.478  15.802  1.00 34.28           N  
ATOM    714  CA  ALA A  98       0.880 -29.157  15.202  1.00 30.38           C  
ATOM    715  C   ALA A  98       2.254 -28.889  14.606  1.00 27.87           C  
ATOM    716  O   ALA A  98       3.276 -29.348  15.119  1.00 26.42           O  
ATOM    717  CB  ALA A  98       0.550 -28.094  16.236  1.00 29.82           C  
ATOM    718  N   LEU A  99       2.257 -28.130  13.518  1.00 25.53           N  
ATOM    719  CA  LEU A  99       3.477 -27.774  12.807  1.00 21.65           C  
ATOM    720  C   LEU A  99       3.560 -26.249  12.693  1.00 20.82           C  
ATOM    721  O   LEU A  99       2.585 -25.599  12.312  1.00 19.58           O  
ATOM    722  CB  LEU A  99       3.438 -28.413  11.421  1.00 19.71           C  
ATOM    723  CG  LEU A  99       4.660 -28.317  10.515  1.00 20.27           C  
ATOM    724  CD1 LEU A  99       5.897 -28.849  11.245  1.00 18.18           C  
ATOM    725  CD2 LEU A  99       4.389 -29.115   9.237  1.00 17.89           C  
ATOM    726  N   ASP A 100       4.712 -25.680  13.054  1.00 19.40           N  
ATOM    727  CA  ASP A 100       4.920 -24.234  12.984  1.00 17.45           C  
ATOM    728  C   ASP A 100       5.636 -23.942  11.691  1.00 14.60           C  
ATOM    729  O   ASP A 100       6.729 -24.440  11.457  1.00 15.48           O  
ATOM    730  CB  ASP A 100       5.770 -23.743  14.151  1.00 18.79           C  
ATOM    731  CG  ASP A 100       5.057 -23.856  15.469  1.00 20.73           C  
ATOM    732  OD1 ASP A 100       3.902 -23.375  15.555  1.00 22.92           O  
ATOM    733  OD2 ASP A 100       5.649 -24.419  16.413  1.00 20.35           O  
ATOM    734  N   VAL A 101       5.027 -23.118  10.858  1.00 13.06           N  
ATOM    735  CA  VAL A 101       5.604 -22.820   9.559  1.00 13.06           C  
ATOM    736  C   VAL A 101       5.681 -21.342   9.244  1.00 13.26           C  
ATOM    737  O   VAL A 101       4.918 -20.538   9.781  1.00 16.87           O  
ATOM    738  CB  VAL A 101       4.762 -23.470   8.436  1.00 12.40           C  
ATOM    739  CG1 VAL A 101       5.426 -23.243   7.078  1.00 13.42           C  
ATOM    740  CG2 VAL A 101       4.580 -24.950   8.708  1.00 12.44           C  
ATOM    741  N   ILE A 102       6.634 -20.988   8.389  1.00 11.73           N  
ATOM    742  CA  ILE A 102       6.753 -19.625   7.905  1.00 10.07           C  
ATOM    743  C   ILE A 102       6.804 -19.764   6.390  1.00 10.10           C  
ATOM    744  O   ILE A 102       7.610 -20.532   5.864  1.00 10.42           O  
ATOM    745  CB  ILE A 102       8.022 -18.891   8.396  1.00  9.53           C  
ATOM    746  CG1 ILE A 102       7.745 -18.215   9.741  1.00  4.99           C  
ATOM    747  CG2 ILE A 102       8.424 -17.798   7.394  1.00  5.72           C  
ATOM    748  CD1 ILE A 102       8.966 -17.554  10.352  1.00  3.07           C  
ATOM    749  N   ASP A 103       5.912 -19.048   5.707  1.00  9.38           N  
ATOM    750  CA  ASP A 103       5.830 -19.057   4.248  1.00  8.74           C  
ATOM    751  C   ASP A 103       6.398 -17.786   3.611  1.00 10.69           C  
ATOM    752  O   ASP A 103       6.165 -16.685   4.112  1.00 12.21           O  
ATOM    753  CB  ASP A 103       4.376 -19.167   3.830  1.00 10.20           C  
ATOM    754  CG  ASP A 103       3.937 -20.592   3.593  1.00  8.87           C  
ATOM    755  OD1 ASP A 103       4.595 -21.538   4.077  1.00 10.00           O  
ATOM    756  OD2 ASP A 103       2.909 -20.753   2.918  1.00  6.47           O  
ATOM    757  N   VAL A 104       7.145 -17.936   2.517  1.00 11.38           N  
ATOM    758  CA  VAL A 104       7.680 -16.777   1.788  1.00 11.65           C  
ATOM    759  C   VAL A 104       7.200 -16.886   0.348  1.00 10.90           C  
ATOM    760  O   VAL A 104       7.577 -17.807  -0.379  1.00  9.55           O  
ATOM    761  CB  VAL A 104       9.222 -16.716   1.789  1.00 10.39           C  
ATOM    762  CG1 VAL A 104       9.675 -15.501   1.009  1.00 10.96           C  
ATOM    763  CG2 VAL A 104       9.747 -16.621   3.209  1.00  9.99           C  
ATOM    764  N   MET A 105       6.362 -15.944  -0.064  1.00 11.53           N  
ATOM    765  CA  MET A 105       5.811 -15.980  -1.411  1.00 12.06           C  
ATOM    766  C   MET A 105       6.190 -14.772  -2.233  1.00 13.53           C  
ATOM    767  O   MET A 105       6.434 -13.701  -1.699  1.00 13.10           O  
ATOM    768  CB  MET A 105       4.285 -16.032  -1.360  1.00 14.56           C  
ATOM    769  CG  MET A 105       3.690 -16.978  -0.334  1.00 12.02           C  
ATOM    770  SD  MET A 105       1.907 -16.778  -0.333  1.00 12.27           S  
ATOM    771  CE  MET A 105       1.409 -18.522  -0.412  1.00 11.48           C  
ATOM    772  N   ARG A 106       6.226 -14.954  -3.543  1.00 13.69           N  
ATOM    773  CA  ARG A 106       6.515 -13.855  -4.436  1.00 16.96           C  
ATOM    774  C   ARG A 106       5.369 -13.811  -5.421  1.00 17.67           C  
ATOM    775  O   ARG A 106       5.051 -14.819  -6.059  1.00 19.29           O  
ATOM    776  CB  ARG A 106       7.820 -14.073  -5.172  1.00 19.46           C  
ATOM    777  CG  ARG A 106       8.154 -12.932  -6.088  1.00 25.64           C  
ATOM    778  CD  ARG A 106       9.588 -13.021  -6.515  1.00 31.56           C  
ATOM    779  NE  ARG A 106      10.035 -11.779  -7.131  1.00 37.84           N  
ATOM    780  CZ  ARG A 106      11.309 -11.491  -7.370  1.00 40.92           C  
ATOM    781  NH1 ARG A 106      12.260 -12.364  -7.042  1.00 42.59           N  
ATOM    782  NH2 ARG A 106      11.631 -10.333  -7.935  1.00 42.74           N  
ATOM    783  N   PHE A 107       4.729 -12.654  -5.525  1.00 15.86           N  
ATOM    784  CA  PHE A 107       3.606 -12.501  -6.442  1.00 17.28           C  
ATOM    785  C   PHE A 107       4.048 -11.981  -7.804  1.00 17.17           C  
ATOM    786  O   PHE A 107       5.133 -11.419  -7.930  1.00 16.81           O  
ATOM    787  CB  PHE A 107       2.559 -11.562  -5.833  1.00 14.11           C  
ATOM    788  CG  PHE A 107       1.896 -12.115  -4.602  1.00 14.46           C  
ATOM    789  CD1 PHE A 107       2.498 -11.990  -3.355  1.00 14.37           C  
ATOM    790  CD2 PHE A 107       0.693 -12.799  -4.700  1.00 13.47           C  
ATOM    791  CE1 PHE A 107       1.908 -12.543  -2.219  1.00 17.30           C  
ATOM    792  CE2 PHE A 107       0.087 -13.359  -3.574  1.00 16.16           C  
ATOM    793  CZ  PHE A 107       0.695 -13.233  -2.326  1.00 16.85           C  
ATOM    794  N   ASP A 108       3.207 -12.180  -8.821  1.00 19.10           N  
ATOM    795  CA  ASP A 108       3.512 -11.704 -10.169  1.00 20.87           C  
ATOM    796  C   ASP A 108       2.689 -10.455 -10.495  1.00 23.51           C  
ATOM    797  O   ASP A 108       1.874 -10.010  -9.681  1.00 23.07           O  
ATOM    798  CB  ASP A 108       3.257 -12.804 -11.218  1.00 19.60           C  
ATOM    799  CG  ASP A 108       1.773 -13.135 -11.412  1.00 19.20           C  
ATOM    800  OD1 ASP A 108       1.501 -14.164 -12.066  1.00 18.08           O  
ATOM    801  OD2 ASP A 108       0.880 -12.395 -10.939  1.00 17.44           O  
ATOM    802  N   GLU A 109       2.901  -9.893 -11.684  1.00 26.89           N  
ATOM    803  CA  GLU A 109       2.196  -8.683 -12.097  1.00 29.81           C  
ATOM    804  C   GLU A 109       0.690  -8.845 -12.207  1.00 30.34           C  
ATOM    805  O   GLU A 109       0.001  -7.936 -12.663  1.00 31.71           O  
ATOM    806  CB  GLU A 109       2.762  -8.145 -13.425  1.00 32.58           C  
ATOM    807  CG  GLU A 109       2.757  -9.110 -14.610  1.00 37.57           C  
ATOM    808  CD  GLU A 109       3.805 -10.210 -14.493  1.00 40.76           C  
ATOM    809  OE1 GLU A 109       4.961  -9.896 -14.136  1.00 43.30           O  
ATOM    810  OE2 GLU A 109       3.479 -11.386 -14.771  1.00 43.53           O  
ATOM    811  N   HIS A 110       0.175  -9.996 -11.781  1.00 29.10           N  
ATOM    812  CA  HIS A 110      -1.258 -10.252 -11.836  1.00 28.43           C  
ATOM    813  C   HIS A 110      -1.816 -10.571 -10.466  1.00 26.47           C  
ATOM    814  O   HIS A 110      -3.001 -10.848 -10.334  1.00 27.45           O  
ATOM    815  CB  HIS A 110      -1.569 -11.411 -12.787  1.00 30.20           C  
ATOM    816  CG  HIS A 110      -1.117 -11.166 -14.192  1.00 35.28           C  
ATOM    817  ND1 HIS A 110       0.189 -11.352 -14.598  1.00 37.58           N  
ATOM    818  CD2 HIS A 110      -1.781 -10.687 -15.270  1.00 36.02           C  
ATOM    819  CE1 HIS A 110       0.309 -10.995 -15.864  1.00 36.85           C  
ATOM    820  NE2 HIS A 110      -0.870 -10.587 -16.295  1.00 37.72           N  
ATOM    821  N   GLY A 111      -0.961 -10.535  -9.450  1.00 24.42           N  
ATOM    822  CA  GLY A 111      -1.407 -10.828  -8.103  1.00 22.02           C  
ATOM    823  C   GLY A 111      -1.493 -12.320  -7.828  1.00 20.60           C  
ATOM    824  O   GLY A 111      -2.182 -12.760  -6.905  1.00 17.18           O  
ATOM    825  N   ARG A 112      -0.808 -13.107  -8.643  1.00 18.57           N  
ATOM    826  CA  ARG A 112      -0.817 -14.538  -8.441  1.00 19.21           C  
ATOM    827  C   ARG A 112       0.514 -14.955  -7.832  1.00 17.55           C  
ATOM    828  O   ARG A 112       1.554 -14.357  -8.117  1.00 17.91           O  
ATOM    829  CB  ARG A 112      -1.038 -15.265  -9.767  1.00 22.22           C  
ATOM    830  CG  ARG A 112      -2.395 -15.005 -10.394  1.00 29.19           C  
ATOM    831  CD  ARG A 112      -2.726 -16.064 -11.445  1.00 34.79           C  
ATOM    832  NE  ARG A 112      -2.881 -15.512 -12.790  1.00 39.70           N  
ATOM    833  CZ  ARG A 112      -3.835 -14.659 -13.149  1.00 42.15           C  
ATOM    834  NH1 ARG A 112      -4.731 -14.250 -12.259  1.00 43.99           N  
ATOM    835  NH2 ARG A 112      -3.897 -14.216 -14.402  1.00 42.84           N  
ATOM    836  N   ILE A 113       0.477 -15.968  -6.978  1.00 15.25           N  
ATOM    837  CA  ILE A 113       1.689 -16.463  -6.350  1.00 13.82           C  
ATOM    838  C   ILE A 113       2.522 -17.066  -7.461  1.00 14.06           C  
ATOM    839  O   ILE A 113       2.074 -17.985  -8.138  1.00 13.06           O  
ATOM    840  CB  ILE A 113       1.380 -17.560  -5.332  1.00 14.27           C  
ATOM    841  CG1 ILE A 113       0.426 -17.023  -4.264  1.00 13.82           C  
ATOM    842  CG2 ILE A 113       2.681 -18.060  -4.708  1.00 13.33           C  
ATOM    843  CD1 ILE A 113      -0.171 -18.102  -3.381  1.00 15.65           C  
ATOM    844  N   GLN A 114       3.726 -16.543  -7.655  1.00 15.95           N  
ATOM    845  CA  GLN A 114       4.616 -17.042  -8.700  1.00 15.96           C  
ATOM    846  C   GLN A 114       5.572 -18.081  -8.137  1.00 16.25           C  
ATOM    847  O   GLN A 114       5.926 -19.059  -8.794  1.00 16.91           O  
ATOM    848  CB  GLN A 114       5.409 -15.892  -9.294  1.00 17.68           C  
ATOM    849  CG  GLN A 114       6.159 -16.263 -10.539  1.00 26.30           C  
ATOM    850  CD  GLN A 114       7.045 -15.136 -11.009  1.00 31.42           C  
ATOM    851  OE1 GLN A 114       8.027 -14.782 -10.343  1.00 35.60           O  
ATOM    852  NE2 GLN A 114       6.701 -14.547 -12.156  1.00 34.62           N  
ATOM    853  N   THR A 115       6.014 -17.858  -6.915  1.00 15.52           N  
ATOM    854  CA  THR A 115       6.909 -18.800  -6.287  1.00 16.16           C  
ATOM    855  C   THR A 115       6.619 -18.737  -4.804  1.00 15.49           C  
ATOM    856  O   THR A 115       6.318 -17.671  -4.270  1.00 13.99           O  
ATOM    857  CB  THR A 115       8.374 -18.465  -6.580  1.00 14.78           C  
ATOM    858  OG1 THR A 115       9.215 -19.292  -5.772  1.00 21.23           O  
ATOM    859  CG2 THR A 115       8.662 -17.021  -6.287  1.00 19.31           C  
ATOM    860  N   MET A 116       6.695 -19.889  -4.147  1.00 15.27           N  
ATOM    861  CA  MET A 116       6.391 -19.977  -2.735  1.00 15.14           C  
ATOM    862  C   MET A 116       7.349 -20.944  -2.049  1.00 14.38           C  
ATOM    863  O   MET A 116       7.653 -22.007  -2.584  1.00 14.79           O  
ATOM    864  CB  MET A 116       4.940 -20.449  -2.590  1.00 18.25           C  
ATOM    865  CG  MET A 116       4.413 -20.505  -1.176  1.00 24.57           C  
ATOM    866  SD  MET A 116       4.236 -22.187  -0.574  1.00 31.79           S  
ATOM    867  CE  MET A 116       2.493 -22.412  -0.695  1.00 26.90           C  
ATOM    868  N   GLN A 117       7.830 -20.574  -0.869  1.00 13.38           N  
ATOM    869  CA  GLN A 117       8.754 -21.424  -0.124  1.00 13.31           C  
ATOM    870  C   GLN A 117       8.283 -21.577   1.309  1.00 12.48           C  
ATOM    871  O   GLN A 117       7.970 -20.594   1.978  1.00 13.10           O  
ATOM    872  CB  GLN A 117      10.152 -20.824  -0.126  1.00 16.57           C  
ATOM    873  CG  GLN A 117      10.723 -20.602  -1.505  1.00 20.74           C  
ATOM    874  CD  GLN A 117      12.024 -19.838  -1.462  1.00 22.63           C  
ATOM    875  OE1 GLN A 117      12.080 -18.719  -0.952  1.00 23.89           O  
ATOM    876  NE2 GLN A 117      13.085 -20.433  -2.003  1.00 25.24           N  
ATOM    877  N   ALA A 118       8.254 -22.812   1.783  1.00 11.90           N  
ATOM    878  CA  ALA A 118       7.800 -23.091   3.124  1.00 12.06           C  
ATOM    879  C   ALA A 118       8.959 -23.500   4.006  1.00 13.53           C  
ATOM    880  O   ALA A 118       9.687 -24.438   3.697  1.00 14.00           O  
ATOM    881  CB  ALA A 118       6.764 -24.187   3.087  1.00 14.22           C  
ATOM    882  N   PHE A 119       9.135 -22.795   5.112  1.00 13.07           N  
ATOM    883  CA  PHE A 119      10.214 -23.131   6.008  1.00 12.61           C  
ATOM    884  C   PHE A 119       9.686 -23.884   7.218  1.00 13.10           C  
ATOM    885  O   PHE A 119       8.842 -23.379   7.957  1.00 13.37           O  
ATOM    886  CB  PHE A 119      10.960 -21.868   6.439  1.00 13.31           C  
ATOM    887  CG  PHE A 119      11.738 -21.211   5.320  1.00 14.55           C  
ATOM    888  CD1 PHE A 119      11.093 -20.444   4.361  1.00 14.00           C  
ATOM    889  CD2 PHE A 119      13.114 -21.381   5.220  1.00 14.32           C  
ATOM    890  CE1 PHE A 119      11.801 -19.852   3.316  1.00 14.96           C  
ATOM    891  CE2 PHE A 119      13.836 -20.794   4.176  1.00 16.83           C  
ATOM    892  CZ  PHE A 119      13.174 -20.027   3.222  1.00 14.22           C  
ATOM    893  N   TRP A 120      10.182 -25.109   7.391  1.00 13.56           N  
ATOM    894  CA  TRP A 120       9.804 -25.969   8.509  1.00 13.19           C  
ATOM    895  C   TRP A 120      10.512 -27.313   8.402  1.00 14.80           C  
ATOM    896  O   TRP A 120      10.959 -27.708   7.327  1.00 15.16           O  
ATOM    897  CB  TRP A 120       8.288 -26.216   8.544  1.00 11.84           C  
ATOM    898  CG  TRP A 120       7.749 -27.021   7.382  1.00 12.54           C  
ATOM    899  CD1 TRP A 120       7.275 -26.537   6.198  1.00 11.13           C  
ATOM    900  CD2 TRP A 120       7.647 -28.453   7.297  1.00 13.76           C  
ATOM    901  NE1 TRP A 120       6.887 -27.572   5.383  1.00 10.80           N  
ATOM    902  CE2 TRP A 120       7.105 -28.758   6.031  1.00 12.15           C  
ATOM    903  CE3 TRP A 120       7.964 -29.506   8.168  1.00 13.82           C  
ATOM    904  CZ2 TRP A 120       6.871 -30.073   5.610  1.00 14.28           C  
ATOM    905  CZ3 TRP A 120       7.732 -30.818   7.748  1.00 15.28           C  
ATOM    906  CH2 TRP A 120       7.191 -31.086   6.479  1.00 14.84           C  
ATOM    907  N   SER A 121      10.628 -27.998   9.533  1.00 15.80           N  
ATOM    908  CA  SER A 121      11.238 -29.317   9.578  1.00 17.31           C  
ATOM    909  C   SER A 121      10.700 -29.990  10.827  1.00 18.02           C  
ATOM    910  O   SER A 121       9.833 -29.441  11.508  1.00 19.73           O  
ATOM    911  CB  SER A 121      12.764 -29.227   9.641  1.00 16.11           C  
ATOM    912  OG  SER A 121      13.195 -28.788  10.916  1.00 17.13           O  
ATOM    913  N   GLU A 122      11.221 -31.166  11.143  1.00 19.80           N  
ATOM    914  CA  GLU A 122      10.753 -31.906  12.305  1.00 21.42           C  
ATOM    915  C   GLU A 122      10.851 -31.126  13.612  1.00 20.82           C  
ATOM    916  O   GLU A 122      10.017 -31.301  14.498  1.00 21.32           O  
ATOM    917  CB  GLU A 122      11.510 -33.236  12.429  1.00 22.27           C  
ATOM    918  CG  GLU A 122      11.494 -34.069  11.154  1.00 26.71           C  
ATOM    919  CD  GLU A 122      12.643 -33.732  10.202  1.00 28.92           C  
ATOM    920  OE1 GLU A 122      13.140 -32.582  10.245  1.00 29.31           O  
ATOM    921  OE2 GLU A 122      13.040 -34.616   9.404  1.00 28.81           O  
ATOM    922  N   VAL A 123      11.847 -30.255  13.729  1.00 20.72           N  
ATOM    923  CA  VAL A 123      12.022 -29.489  14.960  1.00 21.37           C  
ATOM    924  C   VAL A 123      10.854 -28.553  15.266  1.00 21.25           C  
ATOM    925  O   VAL A 123      10.754 -28.017  16.365  1.00 21.85           O  
ATOM    926  CB  VAL A 123      13.337 -28.666  14.934  1.00 22.55           C  
ATOM    927  CG1 VAL A 123      14.541 -29.608  14.900  1.00 22.26           C  
ATOM    928  CG2 VAL A 123      13.353 -27.735  13.726  1.00 23.10           C  
ATOM    929  N   ASN A 124       9.966 -28.371  14.295  1.00 22.44           N  
ATOM    930  CA  ASN A 124       8.808 -27.501  14.474  1.00 21.84           C  
ATOM    931  C   ASN A 124       7.540 -28.312  14.628  1.00 24.52           C  
ATOM    932  O   ASN A 124       6.462 -27.758  14.837  1.00 23.65           O  
ATOM    933  CB  ASN A 124       8.646 -26.573  13.281  1.00 18.27           C  
ATOM    934  CG  ASN A 124       9.857 -25.730  13.048  1.00 16.89           C  
ATOM    935  OD1 ASN A 124      10.554 -25.890  12.043  1.00 19.55           O  
ATOM    936  ND2 ASN A 124      10.132 -24.824  13.980  1.00 12.84           N  
ATOM    937  N   LEU A 125       7.680 -29.626  14.515  1.00 27.24           N  
ATOM    938  CA  LEU A 125       6.554 -30.541  14.630  1.00 30.07           C  
ATOM    939  C   LEU A 125       6.299 -30.901  16.089  1.00 32.03           C  
ATOM    940  O   LEU A 125       7.051 -31.668  16.680  1.00 33.60           O  
ATOM    941  CB  LEU A 125       6.852 -31.804  13.817  1.00 30.77           C  
ATOM    942  CG  LEU A 125       5.756 -32.838  13.575  1.00 30.76           C  
ATOM    943  CD1 LEU A 125       6.263 -33.813  12.538  1.00 29.94           C  
ATOM    944  CD2 LEU A 125       5.381 -33.558  14.867  1.00 31.15           C  
ATOM    945  N   SER A 126       5.240 -30.344  16.667  1.00 33.51           N  
ATOM    946  CA  SER A 126       4.889 -30.629  18.054  1.00 35.64           C  
ATOM    947  C   SER A 126       3.748 -31.631  18.056  1.00 36.90           C  
ATOM    948  O   SER A 126       2.614 -31.277  17.746  1.00 37.24           O  
ATOM    949  CB  SER A 126       4.419 -29.359  18.770  1.00 36.76           C  
ATOM    950  OG  SER A 126       5.368 -28.315  18.663  1.00 40.32           O  
ATOM    951  N   VAL A 127       4.031 -32.881  18.397  1.00 37.95           N  
ATOM    952  CA  VAL A 127       2.969 -33.873  18.415  1.00 39.66           C  
ATOM    953  C   VAL A 127       2.596 -34.275  19.833  1.00 38.99           C  
ATOM    954  O   VAL A 127       1.672 -33.705  20.415  1.00 39.03           O  
ATOM    955  CB  VAL A 127       3.358 -35.133  17.617  1.00 40.51           C  
ATOM    956  CG1 VAL A 127       4.599 -35.768  18.214  1.00 42.17           C  
ATOM    957  CG2 VAL A 127       2.197 -36.115  17.613  1.00 42.17           C  
TER     958      VAL A 127                                                      
END
MOLECULE T0475.pdb
ATOM     20  N   ASN     2       1.831  -2.392  -0.522  1.00  0.00
ATOM     21  HN  ASN     2       1.726  -2.331   0.453  1.00  0.00
ATOM     22  CA  ASN     2       2.075  -3.725  -1.109  1.00  0.00
ATOM     23  HA  ASN     2       2.284  -3.607  -2.174  1.00  0.00
ATOM     24  CB  ASN     2       3.299  -4.390  -0.422  1.00  0.00
ATOM     25  HB1 ASN     2       3.466  -5.372  -0.859  1.00  0.00
ATOM     26  HB2 ASN     2       3.089  -4.514   0.636  1.00  0.00
ATOM     27  CG  ASN     2       4.590  -3.576  -0.565  1.00  0.00
ATOM     28  OD1 ASN     2       5.324  -3.715  -1.546  1.00  0.00
ATOM     29  ND2 ASN     2       4.857  -2.700   0.401  1.00  0.00
ATOM     30 HD21 ASN     2       4.224  -2.628   1.148  1.00  0.00
ATOM     31 HD22 ASN     2       5.675  -2.167   0.331  1.00  0.00
ATOM     32  C   ASN     2       0.785  -4.553  -0.964  1.00  0.00
ATOM     33  O   ASN     2       0.810  -5.738  -0.618  1.00  0.00
ATOM     34  N   SER     3      -0.341  -3.891  -1.292  1.00  0.00
ATOM     35  HN  SER     3      -0.247  -3.002  -1.689  1.00  0.00
ATOM     36  CA  SER     3      -1.702  -4.409  -1.095  1.00  0.00
ATOM     37  HA  SER     3      -1.797  -4.700  -0.049  1.00  0.00
ATOM     38  CB  SER     3      -2.716  -3.279  -1.383  1.00  0.00
ATOM     39  HB1 SER     3      -2.599  -2.492  -0.645  1.00  0.00
ATOM     40  HB2 SER     3      -3.729  -3.660  -1.328  1.00  0.00
ATOM     41  OG  SER     3      -2.512  -2.719  -2.675  1.00  0.00
ATOM     42  HG  SER     3      -3.361  -2.595  -3.107  1.00  0.00
ATOM     43  C   SER     3      -1.979  -5.633  -1.981  1.00  0.00
ATOM     44  O   SER     3      -2.523  -6.626  -1.511  1.00  0.00
ATOM     45  N   GLU     4      -1.554  -5.549  -3.257  1.00  0.00
ATOM     46  HN  GLU     4      -1.122  -4.715  -3.539  1.00  0.00
ATOM     47  CA  GLU     4      -1.720  -6.638  -4.252  1.00  0.00
ATOM     48  HA  GLU     4      -2.760  -6.955  -4.203  1.00  0.00
ATOM     49  CB  GLU     4      -1.434  -6.132  -5.697  1.00  0.00
ATOM     50  HB1 GLU     4      -2.105  -5.307  -5.907  1.00  0.00
ATOM     51  HB2 GLU     4      -1.659  -6.934  -6.393  1.00  0.00
ATOM     52  CG  GLU     4       0.018  -5.661  -5.984  1.00  0.00
ATOM     53  HG1 GLU     4       0.166  -5.630  -7.063  1.00  0.00
ATOM     54  HG2 GLU     4       0.703  -6.396  -5.571  1.00  0.00
ATOM     55  CD  GLU     4       0.366  -4.277  -5.399  1.00  0.00
ATOM     56  OE1 GLU     4       0.009  -3.255  -6.022  1.00  0.00
ATOM     57  OE2 GLU     4       0.991  -4.208  -4.319  1.00  0.00
ATOM     58  C   GLU     4      -0.837  -7.869  -3.943  1.00  0.00
ATOM     59  O   GLU     4      -0.931  -8.886  -4.637  1.00  0.00
ATOM     60  N   ILE     5       0.041  -7.744  -2.937  1.00  0.00
ATOM     61  HN  ILE     5       0.146  -6.866  -2.519  1.00  0.00
ATOM     62  CA  ILE     5       0.867  -8.854  -2.432  1.00  0.00
ATOM     63  HA  ILE     5       0.966  -9.608  -3.214  1.00  0.00
ATOM     64  CB  ILE     5       2.303  -8.347  -2.025  1.00  0.00
ATOM     65  HB  ILE     5       2.196  -7.811  -1.085  1.00  0.00
ATOM     66  CG1 ILE     5       2.896  -7.353  -3.082  1.00  0.00
ATOM     67 HG11 ILE     5       3.865  -7.007  -2.738  1.00  0.00
ATOM     68 HG12 ILE     5       2.244  -6.502  -3.163  1.00  0.00
ATOM     69  CG2 ILE     5       3.271  -9.523  -1.775  1.00  0.00
ATOM     70 HG21 ILE     5       4.228  -9.142  -1.435  1.00  0.00
ATOM     71 HG22 ILE     5       3.417 -10.078  -2.691  1.00  0.00
ATOM     72 HG23 ILE     5       2.862 -10.182  -1.021  1.00  0.00
ATOM     73  CD1 ILE     5       3.082  -7.904  -4.488  1.00  0.00
ATOM     74 HD11 ILE     5       2.126  -8.218  -4.887  1.00  0.00
ATOM     75 HD12 ILE     5       3.755  -8.751  -4.459  1.00  0.00
ATOM     76 HD13 ILE     5       3.501  -7.137  -5.121  1.00  0.00
ATOM     77  C   ILE     5       0.167  -9.486  -1.207  1.00  0.00
ATOM     78  O   ILE     5       0.309 -10.683  -0.936  1.00  0.00
ATOM     79  N   GLU     6      -0.598  -8.649  -0.477  1.00  0.00
ATOM     80  HN  GLU     6      -0.624  -7.699  -0.730  1.00  0.00
ATOM     81  CA  GLU     6      -1.393  -9.075   0.691  1.00  0.00
ATOM     82  HA  GLU     6      -0.790  -9.767   1.280  1.00  0.00
ATOM     83  CB  GLU     6      -1.739  -7.844   1.574  1.00  0.00
ATOM     84  HB1 GLU     6      -2.373  -8.164   2.398  1.00  0.00
ATOM     85  HB2 GLU     6      -2.291  -7.131   0.971  1.00  0.00
ATOM     86  CG  GLU     6      -0.519  -7.120   2.167  1.00  0.00
ATOM     87  HG1 GLU     6       0.145  -6.834   1.353  1.00  0.00
ATOM     88  HG2 GLU     6       0.011  -7.810   2.816  1.00  0.00
ATOM     89  CD  GLU     6      -0.894  -5.858   2.968  1.00  0.00
ATOM     90  OE1 GLU     6      -1.011  -5.932   4.215  1.00  0.00
ATOM     91  OE2 GLU     6      -1.101  -4.793   2.350  1.00  0.00
ATOM     92  C   GLU     6      -2.691  -9.790   0.261  1.00  0.00
ATOM     93  O   GLU     6      -3.153 -10.698   0.961  1.00  0.00
ATOM     94  N   LEU     7      -3.271  -9.367  -0.887  1.00  0.00
ATOM     95  HN  LEU     7      -2.808  -8.685  -1.417  1.00  0.00
ATOM     96  CA  LEU     7      -4.562  -9.911  -1.391  1.00  0.00
ATOM     97  HA  LEU     7      -5.292  -9.732  -0.607  1.00  0.00
ATOM     98  CB  LEU     7      -5.054  -9.182  -2.681  1.00  0.00
ATOM     99  HB1 LEU     7      -5.975  -9.663  -3.009  1.00  0.00
ATOM    100  HB2 LEU     7      -4.310  -9.334  -3.456  1.00  0.00
ATOM    101  CG  LEU     7      -5.325  -7.651  -2.562  1.00  0.00
ATOM    102  HG  LEU     7      -4.402  -7.168  -2.287  1.00  0.00
ATOM    103  CD1 LEU     7      -5.756  -7.043  -3.913  1.00  0.00
ATOM    104 HD11 LEU     7      -6.661  -7.526  -4.269  1.00  0.00
ATOM    105 HD12 LEU     7      -4.968  -7.181  -4.640  1.00  0.00
ATOM    106 HD13 LEU     7      -5.941  -5.982  -3.792  1.00  0.00
ATOM    107  CD2 LEU     7      -6.353  -7.346  -1.453  1.00  0.00
ATOM    108 HD21 LEU     7      -5.982  -7.713  -0.505  1.00  0.00
ATOM    109 HD22 LEU     7      -7.295  -7.830  -1.678  1.00  0.00
ATOM    110 HD23 LEU     7      -6.509  -6.276  -1.383  1.00  0.00
ATOM    111  C   LEU     7      -4.504 -11.450  -1.632  1.00  0.00
ATOM    112  O   LEU     7      -5.411 -12.157  -1.175  1.00  0.00
ATOM    113  N   PRO     8      -3.462 -12.011  -2.364  1.00  0.00
ATOM    114  CA  PRO     8      -3.309 -13.478  -2.527  1.00  0.00
ATOM    115  HA  PRO     8      -4.145 -13.893  -3.088  1.00  0.00
ATOM    116  CB  PRO     8      -1.994 -13.649  -3.366  1.00  0.00
ATOM    117  HB1 PRO     8      -2.245 -13.908  -4.388  1.00  0.00
ATOM    118  HB2 PRO     8      -1.376 -14.442  -2.953  1.00  0.00
ATOM    119  CG  PRO     8      -1.308 -12.325  -3.298  1.00  0.00
ATOM    120  HG1 PRO     8      -0.750 -12.142  -4.212  1.00  0.00
ATOM    121  HG2 PRO     8      -0.632 -12.298  -2.447  1.00  0.00
ATOM    122  CD  PRO     8      -2.402 -11.297  -3.131  1.00  0.00
ATOM    123  HD1 PRO     8      -2.780 -10.972  -4.098  1.00  0.00
ATOM    124  HD2 PRO     8      -2.035 -10.447  -2.573  1.00  0.00
ATOM    125  C   PRO     8      -3.231 -14.208  -1.181  1.00  0.00
ATOM    126  O   PRO     8      -4.115 -14.994  -0.842  1.00  0.00
ATOM    127  N   VAL     9      -2.209 -13.860  -0.401  1.00  0.00
ATOM    128  HN  VAL     9      -1.703 -13.049  -0.636  1.00  0.00
ATOM    129  CA  VAL     9      -1.812 -14.612   0.800  1.00  0.00
ATOM    130  HA  VAL     9      -1.660 -15.641   0.491  1.00  0.00
ATOM    131  CB  VAL     9      -0.455 -14.070   1.348  1.00  0.00
ATOM    132  HB  VAL     9      -0.147 -14.712   2.173  1.00  0.00
ATOM    133  CG1 VAL     9       0.641 -14.156   0.254  1.00  0.00
ATOM    134 HG11 VAL     9       0.368 -13.532  -0.588  1.00  0.00
ATOM    135 HG12 VAL     9       0.746 -15.182  -0.082  1.00  0.00
ATOM    136 HG13 VAL     9       1.587 -13.820   0.657  1.00  0.00
ATOM    137  CG2 VAL     9      -0.593 -12.627   1.896  1.00  0.00
ATOM    138 HG21 VAL     9      -0.958 -11.972   1.115  1.00  0.00
ATOM    139 HG22 VAL     9       0.366 -12.271   2.239  1.00  0.00
ATOM    140 HG23 VAL     9      -1.292 -12.614   2.725  1.00  0.00
ATOM    141  C   VAL     9      -2.901 -14.601   1.905  1.00  0.00
ATOM    142  O   VAL     9      -3.020 -15.564   2.666  1.00  0.00
ATOM    143  N   GLN    10      -3.705 -13.515   1.950  1.00  0.00
ATOM    144  HN  GLN    10      -3.532 -12.787   1.318  1.00  0.00
ATOM    145  CA  GLN    10      -4.839 -13.376   2.888  1.00  0.00
ATOM    146  HA  GLN    10      -4.480 -13.600   3.893  1.00  0.00
ATOM    147  CB  GLN    10      -5.375 -11.914   2.859  1.00  0.00
ATOM    148  HB1 GLN    10      -5.608 -11.659   1.829  1.00  0.00
ATOM    149  HB2 GLN    10      -4.587 -11.252   3.197  1.00  0.00
ATOM    150  CG  GLN    10      -6.630 -11.627   3.718  1.00  0.00
ATOM    151  HG1 GLN    10      -7.444 -12.248   3.358  1.00  0.00
ATOM    152  HG2 GLN    10      -6.905 -10.587   3.587  1.00  0.00
ATOM    153  CD  GLN    10      -6.435 -11.892   5.211  1.00  0.00
ATOM    154  OE1 GLN    10      -6.001 -11.016   5.954  1.00  0.00
ATOM    155  NE2 GLN    10      -6.762 -13.097   5.655  1.00  0.00
ATOM    156 HE21 GLN    10      -7.111 -13.751   5.008  1.00  0.00
ATOM    157 HE22 GLN    10      -6.644 -13.289   6.609  1.00  0.00
ATOM    158  C   GLN    10      -5.951 -14.368   2.514  1.00  0.00
ATOM    159  O   GLN    10      -6.354 -15.200   3.335  1.00  0.00
ATOM    160  N   LYS    11      -6.395 -14.286   1.244  1.00  0.00
ATOM    161  HN  LYS    11      -5.949 -13.656   0.636  1.00  0.00
ATOM    162  CA  LYS    11      -7.508 -15.103   0.710  1.00  0.00
ATOM    163  HA  LYS    11      -8.378 -14.924   1.338  1.00  0.00
ATOM    164  CB  LYS    11      -7.846 -14.648  -0.732  1.00  0.00
ATOM    165  HB1 LYS    11      -8.562 -15.342  -1.167  1.00  0.00
ATOM    166  HB2 LYS    11      -6.938 -14.674  -1.329  1.00  0.00
ATOM    167  CG  LYS    11      -8.439 -13.225  -0.830  1.00  0.00
ATOM    168  HG1 LYS    11      -8.591 -12.983  -1.878  1.00  0.00
ATOM    169  HG2 LYS    11      -7.731 -12.521  -0.403  1.00  0.00
ATOM    170  CD  LYS    11      -9.782 -13.097  -0.085  1.00  0.00
ATOM    171  HD1 LYS    11      -9.626 -13.325   0.969  1.00  0.00
ATOM    172  HD2 LYS    11     -10.482 -13.816  -0.497  1.00  0.00
ATOM    173  CE  LYS    11     -10.403 -11.699  -0.200  1.00  0.00
ATOM    174  HE1 LYS    11     -10.562 -11.460  -1.242  1.00  0.00
ATOM    175  HE2 LYS    11      -9.730 -10.971   0.239  1.00  0.00
ATOM    176  NZ  LYS    11     -11.702 -11.633   0.510  1.00  0.00
ATOM    177  HZ1 LYS    11     -12.109 -10.686   0.416  1.00  0.00
ATOM    178  HZ2 LYS    11     -11.567 -11.843   1.519  1.00  0.00
ATOM    179  HZ3 LYS    11     -12.367 -12.326   0.112  1.00  0.00
ATOM    180  C   LYS    11      -7.180 -16.603   0.734  1.00  0.00
ATOM    181  O   LYS    11      -8.057 -17.429   0.977  1.00  0.00
ATOM    182  N   GLN    12      -5.904 -16.925   0.497  1.00  0.00
ATOM    183  HN  GLN    12      -5.262 -16.197   0.364  1.00  0.00
ATOM    184  CA  GLN    12      -5.412 -18.308   0.438  1.00  0.00
ATOM    185  HA  GLN    12      -6.116 -18.882  -0.161  1.00  0.00
ATOM    186  CB  GLN    12      -4.038 -18.347  -0.253  1.00  0.00
ATOM    187  HB1 GLN    12      -3.615 -19.342  -0.140  1.00  0.00
ATOM    188  HB2 GLN    12      -3.378 -17.634   0.241  1.00  0.00
ATOM    189  CG  GLN    12      -4.076 -18.013  -1.754  1.00  0.00
ATOM    190  HG1 GLN    12      -4.619 -17.084  -1.892  1.00  0.00
ATOM    191  HG2 GLN    12      -4.592 -18.806  -2.280  1.00  0.00
ATOM    192  CD  GLN    12      -2.692 -17.850  -2.370  1.00  0.00
ATOM    193  OE1 GLN    12      -2.513 -17.092  -3.318  1.00  0.00
ATOM    194  NE2 GLN    12      -1.704 -18.584  -1.862  1.00  0.00
ATOM    195 HE21 GLN    12      -1.901 -19.190  -1.120  1.00  0.00
ATOM    196 HE22 GLN    12      -0.821 -18.502  -2.263  1.00  0.00
ATOM    197  C   GLN    12      -5.310 -18.928   1.840  1.00  0.00
ATOM    198  O   GLN    12      -5.658 -20.085   2.024  1.00  0.00
ATOM    199  N   LEU    13      -4.802 -18.148   2.810  1.00  0.00
ATOM    200  HN  LEU    13      -4.515 -17.235   2.577  1.00  0.00
ATOM    201  CA  LEU    13      -4.660 -18.600   4.211  1.00  0.00
ATOM    202  HA  LEU    13      -4.023 -19.485   4.218  1.00  0.00
ATOM    203  CB  LEU    13      -4.000 -17.499   5.062  1.00  0.00
ATOM    204  HB1 LEU    13      -4.586 -16.593   4.943  1.00  0.00
ATOM    205  HB2 LEU    13      -3.007 -17.308   4.661  1.00  0.00
ATOM    206  CG  LEU    13      -3.869 -17.811   6.587  1.00  0.00
ATOM    207  HG  LEU    13      -4.781 -18.277   6.921  1.00  0.00
ATOM    208  CD1 LEU    13      -2.741 -18.824   6.881  1.00  0.00
ATOM    209 HD11 LEU    13      -2.683 -19.003   7.947  1.00  0.00
ATOM    210 HD12 LEU    13      -1.792 -18.435   6.532  1.00  0.00
ATOM    211 HD13 LEU    13      -2.952 -19.760   6.376  1.00  0.00
ATOM    212  CD2 LEU    13      -3.726 -16.522   7.391  1.00  0.00
ATOM    213 HD21 LEU    13      -3.726 -16.755   8.445  1.00  0.00
ATOM    214 HD22 LEU    13      -4.561 -15.868   7.172  1.00  0.00
ATOM    215 HD23 LEU    13      -2.801 -16.024   7.132  1.00  0.00
ATOM    216  C   LEU    13      -6.039 -18.958   4.803  1.00  0.00
ATOM    217  O   LEU    13      -6.199 -20.004   5.451  1.00  0.00
ATOM    218  N   GLU    14      -7.012 -18.054   4.579  1.00  0.00
ATOM    219  HN  GLU    14      -6.762 -17.194   4.166  1.00  0.00
ATOM    220  CA  GLU    14      -8.427 -18.274   4.938  1.00  0.00
ATOM    221  HA  GLU    14      -8.482 -18.402   6.018  1.00  0.00
ATOM    222  CB  GLU    14      -9.279 -17.045   4.529  1.00  0.00
ATOM    223  HB1 GLU    14     -10.327 -17.249   4.740  1.00  0.00
ATOM    224  HB2 GLU    14      -9.167 -16.886   3.459  1.00  0.00
ATOM    225  CG  GLU    14      -8.896 -15.744   5.249  1.00  0.00
ATOM    226  HG1 GLU    14      -7.833 -15.558   5.093  1.00  0.00
ATOM    227  HG2 GLU    14      -9.070 -15.875   6.311  1.00  0.00
ATOM    228  CD  GLU    14      -9.693 -14.526   4.750  1.00  0.00
ATOM    229  OE1 GLU    14     -10.749 -14.201   5.342  1.00  0.00
ATOM    230  OE2 GLU    14      -9.272 -13.890   3.756  1.00  0.00
ATOM    231  C   GLU    14      -8.950 -19.548   4.253  1.00  0.00
ATOM    232  O   GLU    14      -9.468 -20.433   4.916  1.00  0.00
ATOM    233  N   ALA    15      -8.711 -19.634   2.933  1.00  0.00
ATOM    234  HN  ALA    15      -8.204 -18.905   2.512  1.00  0.00
ATOM    235  CA  ALA    15      -9.156 -20.758   2.076  1.00  0.00
ATOM    236  HA  ALA    15     -10.235 -20.852   2.189  1.00  0.00
ATOM    237  CB  ALA    15      -8.862 -20.438   0.601  1.00  0.00
ATOM    238  HB1 ALA    15      -7.792 -20.355   0.451  1.00  0.00
ATOM    239  HB2 ALA    15      -9.327 -19.499   0.328  1.00  0.00
ATOM    240  HB3 ALA    15      -9.255 -21.223  -0.034  1.00  0.00
ATOM    241  C   ALA    15      -8.495 -22.102   2.478  1.00  0.00
ATOM    242  O   ALA    15      -9.058 -23.168   2.217  1.00  0.00
ATOM    243  N   TYR    16      -7.294 -22.028   3.098  1.00  0.00
ATOM    244  HN  TYR    16      -6.919 -21.135   3.279  1.00  0.00
ATOM    245  CA  TYR    16      -6.514 -23.215   3.518  1.00  0.00
ATOM    246  HA  TYR    16      -6.377 -23.844   2.639  1.00  0.00
ATOM    247  CB  TYR    16      -5.116 -22.780   4.043  1.00  0.00
ATOM    248  HB1 TYR    16      -5.253 -22.145   4.912  1.00  0.00
ATOM    249  HB2 TYR    16      -4.621 -22.198   3.274  1.00  0.00
ATOM    250  CG  TYR    16      -4.166 -23.936   4.432  1.00  0.00
ATOM    251  CD1 TYR    16      -3.688 -24.087   5.742  1.00  0.00
ATOM    252  HD1 TYR    16      -3.991 -23.371   6.499  1.00  0.00
ATOM    253  CD2 TYR    16      -3.752 -24.875   3.481  1.00  0.00
ATOM    254  HD2 TYR    16      -4.105 -24.781   2.460  1.00  0.00
ATOM    255  CE1 TYR    16      -2.836 -25.128   6.080  1.00  0.00
ATOM    256  HE1 TYR    16      -2.482 -25.225   7.100  1.00  0.00
ATOM    257  CE2 TYR    16      -2.904 -25.913   3.816  1.00  0.00
ATOM    258  HE2 TYR    16      -2.602 -26.625   3.059  1.00  0.00
ATOM    259  CZ  TYR    16      -2.448 -26.037   5.113  1.00  0.00
ATOM    260  OH  TYR    16      -1.602 -27.080   5.440  1.00  0.00
ATOM    261  HH  TYR    16      -1.856 -27.442   6.292  1.00  0.00
ATOM    262  C   TYR    16      -7.276 -24.016   4.589  1.00  0.00
ATOM    263  O   TYR    16      -7.355 -25.252   4.525  1.00  0.00
ATOM    264  N   ASN    17      -7.845 -23.289   5.560  1.00  0.00
ATOM    265  HN  ASN    17      -7.732 -22.312   5.539  1.00  0.00
ATOM    266  CA  ASN    17      -8.637 -23.887   6.651  1.00  0.00
ATOM    267  HA  ASN    17      -8.283 -24.908   6.797  1.00  0.00
ATOM    268  CB  ASN    17      -8.405 -23.104   7.979  1.00  0.00
ATOM    269  HB1 ASN    17      -7.345 -23.123   8.218  1.00  0.00
ATOM    270  HB2 ASN    17      -8.938 -23.600   8.780  1.00  0.00
ATOM    271  CG  ASN    17      -8.859 -21.642   7.940  1.00  0.00
ATOM    272  OD1 ASN    17      -9.998 -21.326   8.280  1.00  0.00
ATOM    273  ND2 ASN    17      -7.969 -20.740   7.540  1.00  0.00
ATOM    274 HD21 ASN    17      -7.069 -21.047   7.289  1.00  0.00
ATOM    275 HD22 ASN    17      -8.244 -19.800   7.514  1.00  0.00
ATOM    276  C   ASN    17     -10.139 -23.952   6.270  1.00  0.00
ATOM    277  O   ASN    17     -10.847 -24.858   6.711  1.00  0.00
ATOM    278  N   ALA    18     -10.592 -23.015   5.405  1.00  0.00
ATOM    279  HN  ALA    18      -9.945 -22.382   5.033  1.00  0.00
ATOM    280  CA  ALA    18     -12.017 -22.899   4.977  1.00  0.00
ATOM    281  HA  ALA    18     -12.645 -23.109   5.841  1.00  0.00
ATOM    282  CB  ALA    18     -12.330 -21.469   4.502  1.00  0.00
ATOM    283  HB1 ALA    18     -12.057 -20.761   5.270  1.00  0.00
ATOM    284  HB2 ALA    18     -13.389 -21.372   4.287  1.00  0.00
ATOM    285  HB3 ALA    18     -11.764 -21.251   3.601  1.00  0.00
ATOM    286  C   ALA    18     -12.372 -23.904   3.864  1.00  0.00
ATOM    287  O   ALA    18     -13.549 -24.058   3.525  1.00  0.00
ATOM    288  N   ARG    19     -11.335 -24.564   3.304  1.00  0.00
ATOM    289  HN  ARG    19     -10.428 -24.285   3.558  1.00  0.00
ATOM    290  CA  ARG    19     -11.463 -25.664   2.322  1.00  0.00
ATOM    291  HA  ARG    19     -10.461 -26.039   2.155  1.00  0.00
ATOM    292  CB  ARG    19     -12.324 -26.837   2.881  1.00  0.00
ATOM    293  HB1 ARG    19     -12.258 -27.674   2.191  1.00  0.00
ATOM    294  HB2 ARG    19     -13.358 -26.514   2.925  1.00  0.00
ATOM    295  CG  ARG    19     -11.926 -27.336   4.286  1.00  0.00
ATOM    296  HG1 ARG    19     -12.522 -28.212   4.517  1.00  0.00
ATOM    297  HG2 ARG    19     -12.152 -26.559   5.010  1.00  0.00
ATOM    298  CD  ARG    19     -10.443 -27.704   4.416  1.00  0.00
ATOM    299  HD1 ARG    19      -9.841 -26.820   4.237  1.00  0.00
ATOM    300  HD2 ARG    19     -10.192 -28.462   3.681  1.00  0.00
ATOM    301  NE  ARG    19     -10.151 -28.205   5.768  1.00  0.00
ATOM    302  HE  ARG    19      -9.995 -27.527   6.467  1.00  0.00
ATOM    303  CZ  ARG    19     -10.113 -29.498   6.120  1.00  0.00
ATOM    304  NH1 ARG    19     -10.315 -30.461   5.228  1.00  0.00
ATOM    305 HH11 ARG    19     -10.508 -30.236   4.271  1.00  0.00
ATOM    306 HH12 ARG    19     -10.261 -31.424   5.505  1.00  0.00
ATOM    307  NH2 ARG    19      -9.892 -29.827   7.378  1.00  0.00
ATOM    308 HH21 ARG    19      -9.761 -29.112   8.073  1.00  0.00
ATOM    309 HH22 ARG    19      -9.844 -30.791   7.648  1.00  0.00
ATOM    310  C   ARG    19     -11.996 -25.167   0.958  1.00  0.00
ATOM    311  O   ARG    19     -12.864 -25.800   0.338  1.00  0.00
ATOM    312  N   ASP    20     -11.443 -24.037   0.485  1.00  0.00
ATOM    313  HN  ASP    20     -10.788 -23.570   1.041  1.00  0.00
ATOM    314  CA  ASP    20     -11.769 -23.468  -0.838  1.00  0.00
ATOM    315  HA  ASP    20     -12.541 -24.077  -1.307  1.00  0.00
ATOM    316  CB  ASP    20     -12.309 -22.010  -0.689  1.00  0.00
ATOM    317  HB1 ASP    20     -12.380 -21.558  -1.674  1.00  0.00
ATOM    318  HB2 ASP    20     -11.601 -21.429  -0.100  1.00  0.00
ATOM    319  CG  ASP    20     -13.689 -21.930  -0.008  1.00  0.00
ATOM    320  OD1 ASP    20     -13.750 -21.843   1.238  1.00  0.00
ATOM    321  OD2 ASP    20     -14.720 -21.948  -0.721  1.00  0.00
ATOM    322  C   ASP    20     -10.514 -23.492  -1.734  1.00  0.00
ATOM    323  O   ASP    20      -9.717 -22.558  -1.696  1.00  0.00
ATOM    324  N   ILE    21     -10.357 -24.561  -2.547  1.00  0.00
ATOM    325  HN  ILE    21     -11.052 -25.252  -2.550  1.00  0.00
ATOM    326  CA  ILE    21      -9.181 -24.730  -3.438  1.00  0.00
ATOM    327  HA  ILE    21      -8.300 -24.483  -2.847  1.00  0.00
ATOM    328  CB  ILE    21      -9.016 -26.233  -3.930  1.00  0.00
ATOM    329  HB  ILE    21     -10.004 -26.599  -4.190  1.00  0.00
ATOM    330  CG1 ILE    21      -8.453 -27.132  -2.779  1.00  0.00
ATOM    331 HG11 ILE    21      -8.531 -28.173  -3.071  1.00  0.00
ATOM    332 HG12 ILE    21      -9.039 -26.979  -1.884  1.00  0.00
ATOM    333  CG2 ILE    21      -8.127 -26.369  -5.205  1.00  0.00
ATOM    334 HG21 ILE    21      -8.582 -25.828  -6.025  1.00  0.00
ATOM    335 HG22 ILE    21      -8.032 -27.412  -5.477  1.00  0.00
ATOM    336 HG23 ILE    21      -7.143 -25.959  -5.009  1.00  0.00
ATOM    337  CD1 ILE    21      -6.996 -26.864  -2.418  1.00  0.00
ATOM    338 HD11 ILE    21      -6.719 -27.483  -1.577  1.00  0.00
ATOM    339 HD12 ILE    21      -6.874 -25.824  -2.152  1.00  0.00
ATOM    340 HD13 ILE    21      -6.361 -27.100  -3.261  1.00  0.00
ATOM    341  C   ILE    21      -9.226 -23.742  -4.620  1.00  0.00
ATOM    342  O   ILE    21      -8.175 -23.315  -5.100  1.00  0.00
ATOM    343  N   ASP    22     -10.438 -23.351  -5.061  1.00  0.00
ATOM    344  HN  ASP    22     -11.243 -23.708  -4.615  1.00  0.00
ATOM    345  CA  ASP    22     -10.607 -22.411  -6.196  1.00  0.00
ATOM    346  HA  ASP    22     -10.117 -22.864  -7.058  1.00  0.00
ATOM    347  CB  ASP    22     -12.108 -22.225  -6.538  1.00  0.00
ATOM    348  HB1 ASP    22     -12.633 -21.874  -5.655  1.00  0.00
ATOM    349  HB2 ASP    22     -12.527 -23.188  -6.818  1.00  0.00
ATOM    350  CG  ASP    22     -12.355 -21.231  -7.695  1.00  0.00
ATOM    351  OD1 ASP    22     -12.735 -20.066  -7.435  1.00  0.00
ATOM    352  OD2 ASP    22     -12.135 -21.609  -8.867  1.00  0.00
ATOM    353  C   ASP    22      -9.928 -21.047  -5.907  1.00  0.00
ATOM    354  O   ASP    22      -9.220 -20.518  -6.762  1.00  0.00
ATOM    355  N   ALA    23     -10.136 -20.511  -4.691  1.00  0.00
ATOM    356  HN  ALA    23     -10.740 -20.975  -4.074  1.00  0.00
ATOM    357  CA  ALA    23      -9.486 -19.252  -4.239  1.00  0.00
ATOM    358  HA  ALA    23      -9.458 -18.561  -5.080  1.00  0.00
ATOM    359  CB  ALA    23     -10.297 -18.602  -3.105  1.00  0.00
ATOM    360  HB1 ALA    23      -9.839 -17.662  -2.810  1.00  0.00
ATOM    361  HB2 ALA    23     -10.332 -19.265  -2.252  1.00  0.00
ATOM    362  HB3 ALA    23     -11.309 -18.413  -3.447  1.00  0.00
ATOM    363  C   ALA    23      -8.040 -19.511  -3.791  1.00  0.00
ATOM    364  O   ALA    23      -7.160 -18.659  -3.967  1.00  0.00
ATOM    365  N   PHE    24      -7.810 -20.712  -3.236  1.00  0.00
ATOM    366  HN  PHE    24      -8.575 -21.307  -3.083  1.00  0.00
ATOM    367  CA  PHE    24      -6.473 -21.176  -2.830  1.00  0.00
ATOM    368  HA  PHE    24      -6.009 -20.382  -2.243  1.00  0.00
ATOM    369  CB  PHE    24      -6.615 -22.440  -1.934  1.00  0.00
ATOM    370  HB1 PHE    24      -6.963 -23.265  -2.547  1.00  0.00
ATOM    371  HB2 PHE    24      -7.362 -22.246  -1.173  1.00  0.00
ATOM    372  CG  PHE    24      -5.339 -22.878  -1.225  1.00  0.00
ATOM    373  CD1 PHE    24      -4.521 -23.871  -1.754  1.00  0.00
ATOM    374  HD1 PHE    24      -4.808 -24.367  -2.671  1.00  0.00
ATOM    375  CD2 PHE    24      -4.940 -22.263  -0.047  1.00  0.00
ATOM    376  HD2 PHE    24      -5.561 -21.491   0.389  1.00  0.00
ATOM    377  CE1 PHE    24      -3.356 -24.232  -1.120  1.00  0.00
ATOM    378  HE1 PHE    24      -2.732 -25.002  -1.545  1.00  0.00
ATOM    379  CE2 PHE    24      -3.775 -22.635   0.590  1.00  0.00
ATOM    380  HE2 PHE    24      -3.483 -22.147   1.511  1.00  0.00
ATOM    381  CZ  PHE    24      -2.979 -23.615   0.050  1.00  0.00
ATOM    382  HZ  PHE    24      -2.058 -23.904   0.544  1.00  0.00
ATOM    383  C   PHE    24      -5.585 -21.459  -4.071  1.00  0.00
ATOM    384  O   PHE    24      -4.392 -21.704  -3.933  1.00  0.00
ATOM    385  N   MET    25      -6.184 -21.461  -5.282  1.00  0.00
ATOM    386  HN  MET    25      -7.161 -21.385  -5.318  1.00  0.00
ATOM    387  CA  MET    25      -5.445 -21.605  -6.559  1.00  0.00
ATOM    388  HA  MET    25      -4.407 -21.823  -6.325  1.00  0.00
ATOM    389  CB  MET    25      -6.016 -22.776  -7.413  1.00  0.00
ATOM    390  HB1 MET    25      -7.067 -22.579  -7.602  1.00  0.00
ATOM    391  HB2 MET    25      -5.940 -23.689  -6.834  1.00  0.00
ATOM    392  CG  MET    25      -5.310 -23.025  -8.775  1.00  0.00
ATOM    393  HG1 MET    25      -5.016 -22.072  -9.200  1.00  0.00
ATOM    394  HG2 MET    25      -6.019 -23.489  -9.446  1.00  0.00
ATOM    395  SD  MET    25      -3.840 -24.101  -8.708  1.00  0.00
ATOM    396  CE  MET    25      -2.690 -23.286  -7.583  1.00  0.00
ATOM    397  HE1 MET    25      -1.756 -23.833  -7.570  1.00  0.00
ATOM    398  HE2 MET    25      -3.107 -23.276  -6.587  1.00  0.00
ATOM    399  HE3 MET    25      -2.510 -22.271  -7.910  1.00  0.00
ATOM    400  C   MET    25      -5.483 -20.303  -7.374  1.00  0.00
ATOM    401  O   MET    25      -4.536 -20.015  -8.120  1.00  0.00
ATOM    402  N   ALA    26      -6.576 -19.524  -7.206  1.00  0.00
ATOM    403  HN  ALA    26      -7.206 -19.764  -6.502  1.00  0.00
ATOM    404  CA  ALA    26      -6.870 -18.324  -8.030  1.00  0.00
ATOM    405  HA  ALA    26      -7.098 -18.668  -9.039  1.00  0.00
ATOM    406  CB  ALA    26      -8.111 -17.596  -7.486  1.00  0.00
ATOM    407  HB1 ALA    26      -8.955 -18.274  -7.463  1.00  0.00
ATOM    408  HB2 ALA    26      -8.354 -16.752  -8.122  1.00  0.00
ATOM    409  HB3 ALA    26      -7.918 -17.241  -6.478  1.00  0.00
ATOM    410  C   ALA    26      -5.690 -17.354  -8.081  1.00  0.00
ATOM    411  O   ALA    26      -5.165 -17.037  -9.147  1.00  0.00
ATOM    412  N   TRP    27      -5.237 -16.978  -6.894  1.00  0.00
ATOM    413  HN  TRP    27      -5.569 -17.449  -6.099  1.00  0.00
ATOM    414  CA  TRP    27      -4.272 -15.899  -6.699  1.00  0.00
ATOM    415  HA  TRP    27      -4.541 -15.083  -7.366  1.00  0.00
ATOM    416  CB  TRP    27      -4.404 -15.411  -5.253  1.00  0.00
ATOM    417  HB1 TRP    27      -3.650 -14.657  -5.074  1.00  0.00
ATOM    418  HB2 TRP    27      -4.223 -16.240  -4.578  1.00  0.00
ATOM    419  CG  TRP    27      -5.746 -14.806  -4.899  1.00  0.00
ATOM    420  CD1 TRP    27      -6.813 -15.425  -4.298  1.00  0.00
ATOM    421  HD1 TRP    27      -6.834 -16.466  -4.002  1.00  0.00
ATOM    422  CD2 TRP    27      -6.140 -13.442  -5.103  1.00  0.00
ATOM    423  NE1 TRP    27      -7.838 -14.529  -4.128  1.00  0.00
ATOM    424  HE1 TRP    27      -8.707 -14.731  -3.721  1.00  0.00
ATOM    425  CE2 TRP    27      -7.451 -13.309  -4.615  1.00  0.00
ATOM    426  CE3 TRP    27      -5.497 -12.321  -5.646  1.00  0.00
ATOM    427  HE3 TRP    27      -4.487 -12.389  -6.033  1.00  0.00
ATOM    428  CZ2 TRP    27      -8.137 -12.102  -4.667  1.00  0.00
ATOM    429  HZ2 TRP    27      -9.148 -12.004  -4.298  1.00  0.00
ATOM    430  CZ3 TRP    27      -6.182 -11.125  -5.699  1.00  0.00
ATOM    431  HZ3 TRP    27      -5.704 -10.246  -6.113  1.00  0.00
ATOM    432  CH2 TRP    27      -7.489 -11.021  -5.207  1.00  0.00
ATOM    433  HH2 TRP    27      -7.991 -10.060  -5.267  1.00  0.00
ATOM    434  C   TRP    27      -2.813 -16.314  -7.008  1.00  0.00
ATOM    435  O   TRP    27      -1.888 -15.520  -6.805  1.00  0.00
ATOM    436  N   TRP    28      -2.618 -17.549  -7.499  1.00  0.00
ATOM    437  HN  TRP    28      -3.388 -18.151  -7.573  1.00  0.00
ATOM    438  CA  TRP    28      -1.309 -18.047  -7.951  1.00  0.00
ATOM    439  HA  TRP    28      -0.524 -17.501  -7.429  1.00  0.00
ATOM    440  CB  TRP    28      -1.163 -19.564  -7.650  1.00  0.00
ATOM    441  HB1 TRP    28      -0.191 -19.902  -7.996  1.00  0.00
ATOM    442  HB2 TRP    28      -1.929 -20.106  -8.194  1.00  0.00
ATOM    443  CG  TRP    28      -1.297 -19.941  -6.191  1.00  0.00
ATOM    444  CD1 TRP    28      -2.412 -19.826  -5.411  1.00  0.00
ATOM    445  HD1 TRP    28      -3.365 -19.415  -5.743  1.00  0.00
ATOM    446  CD2 TRP    28      -0.291 -20.536  -5.349  1.00  0.00
ATOM    447  NE1 TRP    28      -2.155 -20.305  -4.159  1.00  0.00
ATOM    448  HE1 TRP    28      -2.801 -20.329  -3.422  1.00  0.00
ATOM    449  CE2 TRP    28      -0.869 -20.737  -4.089  1.00  0.00
ATOM    450  CE3 TRP    28       1.037 -20.908  -5.540  1.00  0.00
ATOM    451  HE3 TRP    28       1.520 -20.774  -6.499  1.00  0.00
ATOM    452  CZ2 TRP    28      -0.174 -21.298  -3.021  1.00  0.00
ATOM    453  HZ2 TRP    28      -0.632 -21.445  -2.052  1.00  0.00
ATOM    454  CZ3 TRP    28       1.731 -21.467  -4.485  1.00  0.00
ATOM    455  HZ3 TRP    28       2.764 -21.760  -4.617  1.00  0.00
ATOM    456  CH2 TRP    28       1.127 -21.653  -3.235  1.00  0.00
ATOM    457  HH2 TRP    28       1.710 -22.092  -2.434  1.00  0.00
ATOM    458  C   TRP    28      -1.162 -17.807  -9.463  1.00  0.00
ATOM    459  O   TRP    28      -2.148 -17.552 -10.168  1.00  0.00
ATOM    460  N   ALA    29       0.084 -17.865  -9.940  1.00  0.00
ATOM    461  HN  ALA    29       0.820 -17.910  -9.299  1.00  0.00
ATOM    462  CA  ALA    29       0.402 -17.858 -11.384  1.00  0.00
ATOM    463  HA  ALA    29      -0.268 -17.158 -11.880  1.00  0.00
ATOM    464  CB  ALA    29       1.851 -17.391 -11.618  1.00  0.00
ATOM    465  HB1 ALA    29       1.980 -16.392 -11.220  1.00  0.00
ATOM    466  HB2 ALA    29       2.066 -17.379 -12.680  1.00  0.00
ATOM    467  HB3 ALA    29       2.542 -18.065 -11.123  1.00  0.00
ATOM    468  C   ALA    29       0.186 -19.261 -11.971  1.00  0.00
ATOM    469  O   ALA    29       0.322 -20.257 -11.255  1.00  0.00
ATOM    470  N   ASP    30      -0.136 -19.337 -13.276  1.00  0.00
ATOM    471  HN  ASP    30      -0.232 -18.505 -13.787  1.00  0.00
ATOM    472  CA  ASP    30      -0.360 -20.632 -13.968  1.00  0.00
ATOM    473  HA  ASP    30      -1.069 -21.201 -13.371  1.00  0.00
ATOM    474  CB  ASP    30      -0.975 -20.409 -15.375  1.00  0.00
ATOM    475  HB1 ASP    30      -0.286 -19.812 -15.967  1.00  0.00
ATOM    476  HB2 ASP    30      -1.901 -19.854 -15.268  1.00  0.00
ATOM    477  CG  ASP    30      -1.287 -21.721 -16.139  1.00  0.00
ATOM    478  OD1 ASP    30      -0.682 -21.975 -17.205  1.00  0.00
ATOM    479  OD2 ASP    30      -2.136 -22.508 -15.671  1.00  0.00
ATOM    480  C   ASP    30       0.946 -21.444 -14.073  1.00  0.00
ATOM    481  O   ASP    30       0.921 -22.672 -14.123  1.00  0.00
ATOM    482  N   ASP    31       2.086 -20.743 -14.091  1.00  0.00
ATOM    483  HN  ASP    31       2.032 -19.765 -14.057  1.00  0.00
ATOM    484  CA  ASP    31       3.425 -21.361 -14.163  1.00  0.00
ATOM    485  HA  ASP    31       3.309 -22.413 -14.416  1.00  0.00
ATOM    486  CB  ASP    31       4.258 -20.668 -15.283  1.00  0.00
ATOM    487  HB1 ASP    31       3.670 -20.644 -16.196  1.00  0.00
ATOM    488  HB2 ASP    31       5.148 -21.261 -15.470  1.00  0.00
ATOM    489  CG  ASP    31       4.679 -19.220 -14.947  1.00  0.00
ATOM    490  OD1 ASP    31       5.893 -18.910 -14.968  1.00  0.00
ATOM    491  OD2 ASP    31       3.794 -18.390 -14.651  1.00  0.00
ATOM    492  C   ASP    31       4.145 -21.271 -12.798  1.00  0.00
ATOM    493  O   ASP    31       5.368 -21.436 -12.735  1.00  0.00
ATOM    494  N   CYS    32       3.372 -21.042 -11.708  1.00  0.00
ATOM    495  HN  CYS    32       2.397 -21.033 -11.820  1.00  0.00
ATOM    496  CA  CYS    32       3.929 -20.815 -10.357  1.00  0.00
ATOM    497  HA  CYS    32       4.586 -19.948 -10.425  1.00  0.00
ATOM    498  CB  CYS    32       2.822 -20.500  -9.334  1.00  0.00
ATOM    499  HB1 CYS    32       2.121 -21.327  -9.285  1.00  0.00
ATOM    500  HB2 CYS    32       2.292 -19.608  -9.643  1.00  0.00
ATOM    501  SG  CYS    32       3.442 -20.205  -7.661  1.00  0.00
ATOM    502  HG  CYS    32       3.893 -18.961  -7.609  1.00  0.00
ATOM    503  C   CYS    32       4.746 -22.018  -9.858  1.00  0.00
ATOM    504  O   CYS    32       4.315 -23.164  -9.982  1.00  0.00
ATOM    505  N   GLN    33       5.931 -21.735  -9.310  1.00  0.00
ATOM    506  HN  GLN    33       6.211 -20.795  -9.266  1.00  0.00
ATOM    507  CA  GLN    33       6.820 -22.757  -8.747  1.00  0.00
ATOM    508  HA  GLN    33       6.676 -23.687  -9.300  1.00  0.00
ATOM    509  CB  GLN    33       8.293 -22.308  -8.888  1.00  0.00
ATOM    510  HB1 GLN    33       8.940 -23.107  -8.534  1.00  0.00
ATOM    511  HB2 GLN    33       8.455 -21.432  -8.264  1.00  0.00
ATOM    512  CG  GLN    33       8.708 -21.948 -10.324  1.00  0.00
ATOM    513  HG1 GLN    33       9.714 -21.544 -10.306  1.00  0.00
ATOM    514  HG2 GLN    33       8.029 -21.185 -10.687  1.00  0.00
ATOM    515  CD  GLN    33       8.666 -23.115 -11.312  1.00  0.00
ATOM    516  OE1 GLN    33       9.627 -23.873 -11.448  1.00  0.00
ATOM    517  NE2 GLN    33       7.557 -23.249 -12.021  1.00  0.00
ATOM    518 HE21 GLN    33       6.829 -22.608 -11.869  1.00  0.00
ATOM    519 HE22 GLN    33       7.515 -23.970 -12.683  1.00  0.00
ATOM    520  C   GLN    33       6.458 -22.984  -7.273  1.00  0.00
ATOM    521  O   GLN    33       6.003 -22.058  -6.590  1.00  0.00
ATOM    522  N   TYR    34       6.660 -24.215  -6.795  1.00  0.00
ATOM    523  HN  TYR    34       7.018 -24.897  -7.399  1.00  0.00
ATOM    524  CA  TYR    34       6.366 -24.598  -5.412  1.00  0.00
ATOM    525  HA  TYR    34       6.364 -23.697  -4.801  1.00  0.00
ATOM    526  CB  TYR    34       4.974 -25.271  -5.320  1.00  0.00
ATOM    527  HB1 TYR    34       5.006 -26.231  -5.824  1.00  0.00
ATOM    528  HB2 TYR    34       4.250 -24.644  -5.830  1.00  0.00
ATOM    529  CG  TYR    34       4.468 -25.493  -3.889  1.00  0.00
ATOM    530  CD1 TYR    34       4.474 -26.760  -3.296  1.00  0.00
ATOM    531  HD1 TYR    34       4.842 -27.610  -3.864  1.00  0.00
ATOM    532  CD2 TYR    34       3.989 -24.416  -3.132  1.00  0.00
ATOM    533  HD2 TYR    34       3.970 -23.424  -3.573  1.00  0.00
ATOM    534  CE1 TYR    34       4.013 -26.943  -2.007  1.00  0.00
ATOM    535  HE1 TYR    34       4.024 -27.931  -1.565  1.00  0.00
ATOM    536  CE2 TYR    34       3.532 -24.598  -1.845  1.00  0.00
ATOM    537  HE2 TYR    34       3.165 -23.751  -1.278  1.00  0.00
ATOM    538  CZ  TYR    34       3.548 -25.860  -1.285  1.00  0.00
ATOM    539  OH  TYR    34       3.076 -26.040  -0.005  1.00  0.00
ATOM    540  HH  TYR    34       3.708 -26.559   0.500  1.00  0.00
ATOM    541  C   TYR    34       7.470 -25.531  -4.911  1.00  0.00
ATOM    542  O   TYR    34       7.623 -26.639  -5.427  1.00  0.00
ATOM    543  N   TYR    35       8.258 -25.050  -3.939  1.00  0.00
ATOM    544  HN  TYR    35       8.090 -24.143  -3.617  1.00  0.00
ATOM    545  CA  TYR    35       9.360 -25.806  -3.322  1.00  0.00
ATOM    546  HA  TYR    35       9.523 -26.709  -3.909  1.00  0.00
ATOM    547  CB  TYR    35      10.675 -24.980  -3.310  1.00  0.00
ATOM    548  HB1 TYR    35      11.435 -25.539  -2.770  1.00  0.00
ATOM    549  HB2 TYR    35      10.501 -24.053  -2.779  1.00  0.00
ATOM    550  CG  TYR    35      11.248 -24.622  -4.699  1.00  0.00
ATOM    551  CD1 TYR    35      12.419 -25.220  -5.176  1.00  0.00
ATOM    552  HD1 TYR    35      12.920 -25.960  -4.560  1.00  0.00
ATOM    553  CD2 TYR    35      10.630 -23.674  -5.519  1.00  0.00
ATOM    554  HD2 TYR    35       9.721 -23.191  -5.173  1.00  0.00
ATOM    555  CE1 TYR    35      12.942 -24.893  -6.412  1.00  0.00
ATOM    556  HE1 TYR    35      13.843 -25.374  -6.758  1.00  0.00
ATOM    557  CE2 TYR    35      11.150 -23.347  -6.756  1.00  0.00
ATOM    558  HE2 TYR    35      10.646 -22.616  -7.370  1.00  0.00
ATOM    559  CZ  TYR    35      12.306 -23.952  -7.197  1.00  0.00
ATOM    560  OH  TYR    35      12.820 -23.623  -8.433  1.00  0.00
ATOM    561  HH  TYR    35      13.041 -24.430  -8.909  1.00  0.00
ATOM    562  C   TYR    35       9.000 -26.224  -1.887  1.00  0.00
ATOM    563  O   TYR    35       8.172 -25.588  -1.222  1.00  0.00
ATOM    564  N   ALA    36       9.647 -27.307  -1.441  1.00  0.00
ATOM    565  HN  ALA    36      10.233 -27.776  -2.069  1.00  0.00
ATOM    566  CA  ALA    36       9.560 -27.833  -0.072  1.00  0.00
ATOM    567  HA  ALA    36       8.812 -27.261   0.480  1.00  0.00
ATOM    568  CB  ALA    36       9.131 -29.308  -0.103  1.00  0.00
ATOM    569  HB1 ALA    36       8.176 -29.395  -0.605  1.00  0.00
ATOM    570  HB2 ALA    36       9.038 -29.687   0.907  1.00  0.00
ATOM    571  HB3 ALA    36       9.868 -29.893  -0.640  1.00  0.00
ATOM    572  C   ALA    36      10.919 -27.677   0.619  1.00  0.00
ATOM    573  O   ALA    36      11.950 -27.634  -0.064  1.00  0.00
ATOM    574  N   PHE    37      10.898 -27.616   1.965  1.00  0.00
ATOM    575  HN  PHE    37      10.028 -27.690   2.410  1.00  0.00
ATOM    576  CA  PHE    37      12.100 -27.441   2.814  1.00  0.00
ATOM    577  HA  PHE    37      12.490 -26.449   2.624  1.00  0.00
ATOM    578  CB  PHE    37      11.685 -27.538   4.308  1.00  0.00
ATOM    579  HB1 PHE    37      11.206 -28.496   4.474  1.00  0.00
ATOM    580  HB2 PHE    37      10.960 -26.758   4.518  1.00  0.00
ATOM    581  CG  PHE    37      12.829 -27.390   5.318  1.00  0.00
ATOM    582  CD1 PHE    37      13.502 -26.179   5.459  1.00  0.00
ATOM    583  HD1 PHE    37      13.222 -25.338   4.834  1.00  0.00
ATOM    584  CD2 PHE    37      13.216 -28.454   6.136  1.00  0.00
ATOM    585  HD2 PHE    37      12.715 -29.408   6.039  1.00  0.00
ATOM    586  CE1 PHE    37      14.520 -26.033   6.380  1.00  0.00
ATOM    587  HE1 PHE    37      15.030 -25.081   6.474  1.00  0.00
ATOM    588  CE2 PHE    37      14.239 -28.307   7.056  1.00  0.00
ATOM    589  HE2 PHE    37      14.527 -29.141   7.681  1.00  0.00
ATOM    590  CZ  PHE    37      14.888 -27.095   7.179  1.00  0.00
ATOM    591  HZ  PHE    37      15.684 -26.978   7.901  1.00  0.00
ATOM    592  C   PHE    37      13.194 -28.502   2.500  1.00  0.00
ATOM    593  O   PHE    37      12.892 -29.697   2.556  1.00  0.00
ATOM    594  N   PRO    38      14.479 -28.106   2.177  1.00  0.00
ATOM    595  CA  PRO    38      14.924 -26.691   2.008  1.00  0.00
ATOM    596  HA  PRO    38      14.537 -26.075   2.819  1.00  0.00
ATOM    597  CB  PRO    38      16.467 -26.797   2.147  1.00  0.00
ATOM    598  HB1 PRO    38      16.750 -26.680   3.192  1.00  0.00
ATOM    599  HB2 PRO    38      16.955 -26.023   1.563  1.00  0.00
ATOM    600  CG  PRO    38      16.797 -28.171   1.643  1.00  0.00
ATOM    601  HG1 PRO    38      17.713 -28.531   2.101  1.00  0.00
ATOM    602  HG2 PRO    38      16.911 -28.148   0.562  1.00  0.00
ATOM    603  CD  PRO    38      15.623 -29.050   2.037  1.00  0.00
ATOM    604  HD1 PRO    38      15.819 -29.546   2.982  1.00  0.00
ATOM    605  HD2 PRO    38      15.416 -29.784   1.272  1.00  0.00
ATOM    606  C   PRO    38      14.491 -26.046   0.650  1.00  0.00
ATOM    607  O   PRO    38      13.769 -25.041   0.647  1.00  0.00
ATOM    608  N   ALA    39      14.901 -26.646  -0.492  1.00  0.00
ATOM    609  HN  ALA    39      15.417 -27.473  -0.427  1.00  0.00
ATOM    610  CA  ALA    39      14.593 -26.127  -1.842  1.00  0.00
ATOM    611  HA  ALA    39      13.665 -25.552  -1.792  1.00  0.00
ATOM    612  CB  ALA    39      15.713 -25.178  -2.326  1.00  0.00
ATOM    613  HB1 ALA    39      15.457 -24.768  -3.297  1.00  0.00
ATOM    614  HB2 ALA    39      16.645 -25.720  -2.403  1.00  0.00
ATOM    615  HB3 ALA    39      15.834 -24.365  -1.618  1.00  0.00
ATOM    616  C   ALA    39      14.388 -27.300  -2.818  1.00  0.00
ATOM    617  O   ALA    39      15.294 -27.665  -3.577  1.00  0.00
ATOM    618  N   THR    40      13.197 -27.913  -2.761  1.00  0.00
ATOM    619  HN  THR    40      12.521 -27.561  -2.142  1.00  0.00
ATOM    620  CA  THR    40      12.851 -29.096  -3.572  1.00  0.00
ATOM    621  HA  THR    40      13.657 -29.283  -4.280  1.00  0.00
ATOM    622  CB  THR    40      12.707 -30.356  -2.654  1.00  0.00
ATOM    623  HB  THR    40      11.946 -30.151  -1.903  1.00  0.00
ATOM    624  OG1 THR    40      13.957 -30.590  -1.979  1.00  0.00
ATOM    625  HG1 THR    40      13.879 -30.308  -1.067  1.00  0.00
ATOM    626  CG2 THR    40      12.296 -31.623  -3.435  1.00  0.00
ATOM    627 HG21 THR    40      13.015 -31.819  -4.220  1.00  0.00
ATOM    628 HG22 THR    40      11.315 -31.481  -3.876  1.00  0.00
ATOM    629 HG23 THR    40      12.264 -32.471  -2.765  1.00  0.00
ATOM    630  C   THR    40      11.555 -28.827  -4.355  1.00  0.00
ATOM    631  O   THR    40      10.466 -28.807  -3.771  1.00  0.00
ATOM    632  N   LEU    41      11.690 -28.604  -5.676  1.00  0.00
ATOM    633  HN  LEU    41      12.579 -28.711  -6.077  1.00  0.00
ATOM    634  CA  LEU    41      10.568 -28.232  -6.559  1.00  0.00
ATOM    635  HA  LEU    41      10.075 -27.367  -6.120  1.00  0.00
ATOM    636  CB  LEU    41      11.113 -27.835  -7.964  1.00  0.00
ATOM    637  HB1 LEU    41      11.598 -28.707  -8.395  1.00  0.00
ATOM    638  HB2 LEU    41      11.871 -27.070  -7.827  1.00  0.00
ATOM    639  CG  LEU    41      10.063 -27.304  -8.992  1.00  0.00
ATOM    640  HG  LEU    41       9.269 -28.028  -9.069  1.00  0.00
ATOM    641  CD1 LEU    41       9.414 -25.991  -8.514  1.00  0.00
ATOM    642 HD11 LEU    41      10.169 -25.224  -8.402  1.00  0.00
ATOM    643 HD12 LEU    41       8.924 -26.152  -7.563  1.00  0.00
ATOM    644 HD13 LEU    41       8.676 -25.665  -9.237  1.00  0.00
ATOM    645  CD2 LEU    41      10.680 -27.145 -10.400  1.00  0.00
ATOM    646 HD21 LEU    41      11.474 -26.407 -10.375  1.00  0.00
ATOM    647 HD22 LEU    41       9.918 -26.826 -11.099  1.00  0.00
ATOM    648 HD23 LEU    41      11.084 -28.094 -10.729  1.00  0.00
ATOM    649  C   LEU    41       9.549 -29.387  -6.673  1.00  0.00
ATOM    650  O   LEU    41       9.794 -30.377  -7.366  1.00  0.00
ATOM    651  N   LEU    42       8.424 -29.257  -5.947  1.00  0.00
ATOM    652  HN  LEU    42       8.353 -28.502  -5.331  1.00  0.00
ATOM    653  CA  LEU    42       7.306 -30.217  -6.004  1.00  0.00
ATOM    654  HA  LEU    42       7.720 -31.215  -6.065  1.00  0.00
ATOM    655  CB  LEU    42       6.422 -30.119  -4.726  1.00  0.00
ATOM    656  HB1 LEU    42       5.673 -30.904  -4.778  1.00  0.00
ATOM    657  HB2 LEU    42       5.906 -29.161  -4.745  1.00  0.00
ATOM    658  CG  LEU    42       7.155 -30.235  -3.352  1.00  0.00
ATOM    659  HG  LEU    42       7.771 -29.352  -3.218  1.00  0.00
ATOM    660  CD1 LEU    42       6.145 -30.250  -2.183  1.00  0.00
ATOM    661 HD11 LEU    42       5.491 -31.112  -2.265  1.00  0.00
ATOM    662 HD12 LEU    42       5.550 -29.348  -2.206  1.00  0.00
ATOM    663 HD13 LEU    42       6.679 -30.295  -1.243  1.00  0.00
ATOM    664  CD2 LEU    42       8.099 -31.459  -3.304  1.00  0.00
ATOM    665 HD21 LEU    42       8.577 -31.515  -2.336  1.00  0.00
ATOM    666 HD22 LEU    42       8.861 -31.355  -4.065  1.00  0.00
ATOM    667 HD23 LEU    42       7.537 -32.369  -3.483  1.00  0.00
ATOM    668  C   LEU    42       6.434 -29.958  -7.246  1.00  0.00
ATOM    669  O   LEU    42       5.915 -30.902  -7.860  1.00  0.00
ATOM    670  N   ALA    43       6.281 -28.670  -7.605  1.00  0.00
ATOM    671  HN  ALA    43       6.814 -27.988  -7.142  1.00  0.00
ATOM    672  CA  ALA    43       5.338 -28.239  -8.656  1.00  0.00
ATOM    673  HA  ALA    43       5.126 -29.084  -9.309  1.00  0.00
ATOM    674  CB  ALA    43       4.025 -27.815  -7.996  1.00  0.00
ATOM    675  HB1 ALA    43       3.306 -27.524  -8.754  1.00  0.00
ATOM    676  HB2 ALA    43       4.205 -26.979  -7.333  1.00  0.00
ATOM    677  HB3 ALA    43       3.620 -28.641  -7.424  1.00  0.00
ATOM    678  C   ALA    43       5.919 -27.088  -9.495  1.00  0.00
ATOM    679  O   ALA    43       6.235 -26.030  -8.953  1.00  0.00
ATOM    680  N   GLY    44       6.037 -27.307 -10.819  1.00  0.00
ATOM    681  HN  GLY    44       5.759 -28.179 -11.171  1.00  0.00
ATOM    682  CA  GLY    44       6.553 -26.303 -11.758  1.00  0.00
ATOM    683  HA1 GLY    44       7.207 -26.802 -12.463  1.00  0.00
ATOM    684  HA2 GLY    44       7.132 -25.564 -11.218  1.00  0.00
ATOM    685  C   GLY    44       5.441 -25.590 -12.533  1.00  0.00
ATOM    686  O   GLY    44       5.641 -25.190 -13.688  1.00  0.00
ATOM    687  N   ASN    45       4.307 -25.374 -11.842  1.00  0.00
ATOM    688  HN  ASN    45       4.350 -25.502 -10.870  1.00  0.00
ATOM    689  CA  ASN    45       3.029 -24.853 -12.409  1.00  0.00
ATOM    690  HA  ASN    45       3.173 -23.789 -12.573  1.00  0.00
ATOM    691  CB  ASN    45       2.606 -25.511 -13.767  1.00  0.00
ATOM    692  HB1 ASN    45       3.409 -25.382 -14.484  1.00  0.00
ATOM    693  HB2 ASN    45       1.735 -24.993 -14.147  1.00  0.00
ATOM    694  CG  ASN    45       2.271 -27.002 -13.667  1.00  0.00
ATOM    695  OD1 ASN    45       1.137 -27.384 -13.375  1.00  0.00
ATOM    696  ND2 ASN    45       3.246 -27.850 -13.945  1.00  0.00
ATOM    697 HD21 ASN    45       4.118 -27.483 -14.196  1.00  0.00
ATOM    698 HD22 ASN    45       3.059 -28.809 -13.885  1.00  0.00
ATOM    699  C   ASN    45       1.893 -25.018 -11.376  1.00  0.00
ATOM    700  O   ASN    45       1.989 -25.849 -10.466  1.00  0.00
ATOM    701  N   ALA    46       0.798 -24.256 -11.582  1.00  0.00
ATOM    702  HN  ALA    46       0.750 -23.746 -12.414  1.00  0.00
ATOM    703  CA  ALA    46      -0.338 -24.151 -10.638  1.00  0.00
ATOM    704  HA  ALA    46       0.060 -23.852  -9.672  1.00  0.00
ATOM    705  CB  ALA    46      -1.298 -23.046 -11.110  1.00  0.00
ATOM    706  HB1 ALA    46      -2.094 -22.908 -10.387  1.00  0.00
ATOM    707  HB2 ALA    46      -1.728 -23.316 -12.068  1.00  0.00
ATOM    708  HB3 ALA    46      -0.757 -22.114 -11.218  1.00  0.00
ATOM    709  C   ALA    46      -1.103 -25.482 -10.467  1.00  0.00
ATOM    710  O   ALA    46      -1.540 -25.816  -9.361  1.00  0.00
ATOM    711  N   ALA    47      -1.235 -26.238 -11.569  1.00  0.00
ATOM    712  HN  ALA    47      -0.755 -25.965 -12.382  1.00  0.00
ATOM    713  CA  ALA    47      -2.052 -27.468 -11.611  1.00  0.00
ATOM    714  HA  ALA    47      -3.072 -27.190 -11.352  1.00  0.00
ATOM    715  CB  ALA    47      -2.072 -28.062 -13.023  1.00  0.00
ATOM    716  HB1 ALA    47      -1.077 -28.410 -13.288  1.00  0.00
ATOM    717  HB2 ALA    47      -2.388 -27.309 -13.732  1.00  0.00
ATOM    718  HB3 ALA    47      -2.766 -28.896 -13.059  1.00  0.00
ATOM    719  C   ALA    47      -1.556 -28.516 -10.610  1.00  0.00
ATOM    720  O   ALA    47      -2.352 -29.223  -9.997  1.00  0.00
ATOM    721  N   GLU    48      -0.233 -28.614 -10.469  1.00  0.00
ATOM    722  HN  GLU    48       0.342 -28.017 -11.000  1.00  0.00
ATOM    723  CA  GLU    48       0.402 -29.568  -9.545  1.00  0.00
ATOM    724  HA  GLU    48      -0.139 -30.512  -9.619  1.00  0.00
ATOM    725  CB  GLU    48       1.867 -29.812  -9.970  1.00  0.00
ATOM    726  HB1 GLU    48       2.267 -30.649  -9.402  1.00  0.00
ATOM    727  HB2 GLU    48       2.450 -28.928  -9.739  1.00  0.00
ATOM    728  CG  GLU    48       2.051 -30.115 -11.465  1.00  0.00
ATOM    729  HG1 GLU    48       1.758 -29.236 -12.036  1.00  0.00
ATOM    730  HG2 GLU    48       1.391 -30.934 -11.741  1.00  0.00
ATOM    731  CD  GLU    48       3.504 -30.470 -11.823  1.00  0.00
ATOM    732  OE1 GLU    48       4.355 -29.560 -11.862  1.00  0.00
ATOM    733  OE2 GLU    48       3.797 -31.653 -12.083  1.00  0.00
ATOM    734  C   GLU    48       0.311 -29.068  -8.083  1.00  0.00
ATOM    735  O   GLU    48       0.176 -29.872  -7.152  1.00  0.00
ATOM    736  N   ILE    49       0.366 -27.724  -7.907  1.00  0.00
ATOM    737  HN  ILE    49       0.462 -27.157  -8.704  1.00  0.00
ATOM    738  CA  ILE    49       0.289 -27.064  -6.580  1.00  0.00
ATOM    739  HA  ILE    49       1.096 -27.457  -5.965  1.00  0.00
ATOM    740  CB  ILE    49       0.469 -25.495  -6.690  1.00  0.00
ATOM    741  HB  ILE    49      -0.315 -25.121  -7.346  1.00  0.00
ATOM    742  CG1 ILE    49       1.846 -25.144  -7.321  1.00  0.00
ATOM    743 HG11 ILE    49       1.937 -25.649  -8.277  1.00  0.00
ATOM    744 HG12 ILE    49       2.634 -25.501  -6.672  1.00  0.00
ATOM    745  CG2 ILE    49       0.297 -24.792  -5.316  1.00  0.00
ATOM    746 HG21 ILE    49       1.051 -25.147  -4.623  1.00  0.00
ATOM    747 HG22 ILE    49      -0.685 -25.006  -4.913  1.00  0.00
ATOM    748 HG23 ILE    49       0.399 -23.721  -5.439  1.00  0.00
ATOM    749  CD1 ILE    49       2.103 -23.670  -7.561  1.00  0.00
ATOM    750 HD11 ILE    49       1.338 -23.263  -8.208  1.00  0.00
ATOM    751 HD12 ILE    49       3.069 -23.547  -8.031  1.00  0.00
ATOM    752 HD13 ILE    49       2.098 -23.141  -6.619  1.00  0.00
ATOM    753  C   ILE    49      -1.055 -27.367  -5.898  1.00  0.00
ATOM    754  O   ILE    49      -1.088 -27.781  -4.727  1.00  0.00
ATOM    755  N   ARG    50      -2.158 -27.149  -6.646  1.00  0.00
ATOM    756  HN  ARG    50      -2.046 -26.855  -7.582  1.00  0.00
ATOM    757  CA  ARG    50      -3.520 -27.338  -6.116  1.00  0.00
ATOM    758  HA  ARG    50      -3.600 -26.716  -5.224  1.00  0.00
ATOM    759  CB  ARG    50      -4.611 -26.869  -7.122  1.00  0.00
ATOM    760  HB1 ARG    50      -4.481 -25.804  -7.291  1.00  0.00
ATOM    761  HB2 ARG    50      -5.590 -27.021  -6.675  1.00  0.00
ATOM    762  CG  ARG    50      -4.592 -27.580  -8.493  1.00  0.00
ATOM    763  HG1 ARG    50      -4.813 -28.633  -8.340  1.00  0.00
ATOM    764  HG2 ARG    50      -3.598 -27.490  -8.915  1.00  0.00
ATOM    765  CD  ARG    50      -5.596 -27.004  -9.492  1.00  0.00
ATOM    766  HD1 ARG    50      -5.375 -25.950  -9.646  1.00  0.00
ATOM    767  HD2 ARG    50      -6.595 -27.100  -9.080  1.00  0.00
ATOM    768  NE  ARG    50      -5.558 -27.703 -10.798  1.00  0.00
ATOM    769  HE  ARG    50      -5.351 -28.667 -10.777  1.00  0.00
ATOM    770  CZ  ARG    50      -5.793 -27.131 -11.995  1.00  0.00
ATOM    771  NH1 ARG    50      -6.067 -25.835 -12.087  1.00  0.00
ATOM    772 HH11 ARG    50      -6.107 -25.271 -11.264  1.00  0.00
ATOM    773 HH12 ARG    50      -6.224 -25.413 -12.988  1.00  0.00
ATOM    774  NH2 ARG    50      -5.749 -27.866 -13.097  1.00  0.00
ATOM    775 HH21 ARG    50      -5.543 -28.847 -13.045  1.00  0.00
ATOM    776 HH22 ARG    50      -5.925 -27.449 -13.992  1.00  0.00
ATOM    777  C   ARG    50      -3.740 -28.803  -5.705  1.00  0.00
ATOM    778  O   ARG    50      -4.128 -29.045  -4.574  1.00  0.00
ATOM    779  N   VAL    51      -3.408 -29.760  -6.610  1.00  0.00
ATOM    780  HN  VAL    51      -2.984 -29.477  -7.452  1.00  0.00
ATOM    781  CA  VAL    51      -3.637 -31.211  -6.391  1.00  0.00
ATOM    782  HA  VAL    51      -4.704 -31.352  -6.235  1.00  0.00
ATOM    783  CB  VAL    51      -3.214 -32.066  -7.648  1.00  0.00
ATOM    784  HB  VAL    51      -2.162 -31.866  -7.847  1.00  0.00
ATOM    785  CG1 VAL    51      -3.369 -33.593  -7.393  1.00  0.00
ATOM    786 HG11 VAL    51      -4.403 -33.823  -7.163  1.00  0.00
ATOM    787 HG12 VAL    51      -2.745 -33.892  -6.559  1.00  0.00
ATOM    788 HG13 VAL    51      -3.067 -34.144  -8.275  1.00  0.00
ATOM    789  CG2 VAL    51      -4.019 -31.637  -8.900  1.00  0.00
ATOM    790 HG21 VAL    51      -5.072 -31.835  -8.747  1.00  0.00
ATOM    791 HG22 VAL    51      -3.674 -32.188  -9.766  1.00  0.00
ATOM    792 HG23 VAL    51      -3.881 -30.576  -9.080  1.00  0.00
ATOM    793  C   VAL    51      -2.891 -31.695  -5.136  1.00  0.00
ATOM    794  O   VAL    51      -3.461 -32.419  -4.314  1.00  0.00
ATOM    795  N   ARG    52      -1.635 -31.228  -4.987  1.00  0.00
ATOM    796  HN  ARG    52      -1.264 -30.665  -5.700  1.00  0.00
ATOM    797  CA  ARG    52      -0.787 -31.528  -3.816  1.00  0.00
ATOM    798  HA  ARG    52      -0.610 -32.599  -3.805  1.00  0.00
ATOM    799  CB  ARG    52       0.581 -30.793  -3.923  1.00  0.00
ATOM    800  HB1 ARG    52       0.399 -29.724  -3.949  1.00  0.00
ATOM    801  HB2 ARG    52       1.051 -31.077  -4.858  1.00  0.00
ATOM    802  CG  ARG    52       1.589 -31.090  -2.777  1.00  0.00
ATOM    803  HG1 ARG    52       1.032 -31.227  -1.851  1.00  0.00
ATOM    804  HG2 ARG    52       2.244 -30.234  -2.662  1.00  0.00
ATOM    805  CD  ARG    52       2.462 -32.347  -3.023  1.00  0.00
ATOM    806  HD1 ARG    52       3.163 -32.435  -2.209  1.00  0.00
ATOM    807  HD2 ARG    52       3.018 -32.207  -3.944  1.00  0.00
ATOM    808  NE  ARG    52       1.695 -33.613  -3.138  1.00  0.00
ATOM    809  HE  ARG    52       0.724 -33.541  -3.267  1.00  0.00
ATOM    810  CZ  ARG    52       2.234 -34.846  -3.134  1.00  0.00
ATOM    811  NH1 ARG    52       3.523 -35.031  -2.888  1.00  0.00
ATOM    812 HH11 ARG    52       4.121 -34.248  -2.699  1.00  0.00
ATOM    813 HH12 ARG    52       3.910 -35.958  -2.895  1.00  0.00
ATOM    814  NH2 ARG    52       1.462 -35.896  -3.349  1.00  0.00
ATOM    815 HH21 ARG    52       0.479 -35.774  -3.517  1.00  0.00
ATOM    816 HH22 ARG    52       1.850 -36.820  -3.358  1.00  0.00
ATOM    817  C   ARG    52      -1.503 -31.133  -2.509  1.00  0.00
ATOM    818  O   ARG    52      -1.497 -31.883  -1.526  1.00  0.00
ATOM    819  N   HIS    53      -2.128 -29.944  -2.525  1.00  0.00
ATOM    820  HN  HIS    53      -2.103 -29.412  -3.355  1.00  0.00
ATOM    821  CA  HIS    53      -2.855 -29.406  -1.362  1.00  0.00
ATOM    822  HA  HIS    53      -2.267 -29.645  -0.476  1.00  0.00
ATOM    823  CB  HIS    53      -2.965 -27.871  -1.457  1.00  0.00
ATOM    824  HB1 HIS    53      -3.635 -27.503  -0.681  1.00  0.00
ATOM    825  HB2 HIS    53      -3.366 -27.600  -2.427  1.00  0.00
ATOM    826  CG  HIS    53      -1.648 -27.161  -1.283  1.00  0.00
ATOM    827  ND1 HIS    53      -1.079 -26.368  -2.258  1.00  0.00
ATOM    828  HD1 HIS    53      -1.440 -26.224  -3.161  1.00  0.00
ATOM    829  CD2 HIS    53      -0.817 -27.093  -0.214  1.00  0.00
ATOM    830  HD2 HIS    53      -0.952 -27.596   0.738  1.00  0.00
ATOM    831  CE1 HIS    53       0.038 -25.842  -1.797  1.00  0.00
ATOM    832  HE1 HIS    53       0.695 -25.175  -2.338  1.00  0.00
ATOM    833  NE2 HIS    53       0.216 -26.263  -0.560  1.00  0.00
ATOM    834  HE2 HIS    53       0.983 -26.034   0.015  1.00  0.00
ATOM    835  C   HIS    53      -4.242 -30.048  -1.190  1.00  0.00
ATOM    836  O   HIS    53      -4.702 -30.155  -0.073  1.00  0.00
ATOM    837  N   ILE    54      -4.888 -30.480  -2.288  1.00  0.00
ATOM    838  HN  ILE    54      -4.454 -30.385  -3.158  1.00  0.00
ATOM    839  CA  ILE    54      -6.223 -31.128  -2.237  1.00  0.00
ATOM    840  HA  ILE    54      -6.912 -30.438  -1.750  1.00  0.00
ATOM    841  CB  ILE    54      -6.754 -31.421  -3.692  1.00  0.00
ATOM    842  HB  ILE    54      -5.970 -31.954  -4.221  1.00  0.00
ATOM    843  CG1 ILE    54      -7.043 -30.094  -4.455  1.00  0.00
ATOM    844 HG11 ILE    54      -6.175 -29.451  -4.396  1.00  0.00
ATOM    845 HG12 ILE    54      -7.875 -29.586  -3.988  1.00  0.00
ATOM    846  CG2 ILE    54      -8.005 -32.322  -3.689  1.00  0.00
ATOM    847 HG21 ILE    54      -8.326 -32.509  -4.706  1.00  0.00
ATOM    848 HG22 ILE    54      -8.805 -31.837  -3.149  1.00  0.00
ATOM    849 HG23 ILE    54      -7.775 -33.267  -3.209  1.00  0.00
ATOM    850  CD1 ILE    54      -7.383 -30.256  -5.923  1.00  0.00
ATOM    851 HD11 ILE    54      -6.574 -30.774  -6.425  1.00  0.00
ATOM    852 HD12 ILE    54      -7.516 -29.281  -6.368  1.00  0.00
ATOM    853 HD13 ILE    54      -8.294 -30.825  -6.023  1.00  0.00
ATOM    854  C   ILE    54      -6.139 -32.425  -1.408  1.00  0.00
ATOM    855  O   ILE    54      -7.042 -32.737  -0.627  1.00  0.00
ATOM    856  N   GLU    55      -5.011 -33.137  -1.584  1.00  0.00
ATOM    857  HN  GLU    55      -4.387 -32.842  -2.287  1.00  0.00
ATOM    858  CA  GLU    55      -4.661 -34.337  -0.799  1.00  0.00
ATOM    859  HA  GLU    55      -5.442 -35.081  -0.961  1.00  0.00
ATOM    860  CB  GLU    55      -3.309 -34.900  -1.311  1.00  0.00
ATOM    861  HB1 GLU    55      -3.057 -35.796  -0.746  1.00  0.00
ATOM    862  HB2 GLU    55      -2.533 -34.154  -1.141  1.00  0.00
ATOM    863  CG  GLU    55      -3.303 -35.260  -2.811  1.00  0.00
ATOM    864  HG1 GLU    55      -3.646 -34.396  -3.377  1.00  0.00
ATOM    865  HG2 GLU    55      -3.998 -36.075  -2.980  1.00  0.00
ATOM    866  CD  GLU    55      -1.912 -35.671  -3.321  1.00  0.00
ATOM    867  OE1 GLU    55      -1.504 -36.835  -3.108  1.00  0.00
ATOM    868  OE2 GLU    55      -1.201 -34.826  -3.908  1.00  0.00
ATOM    869  C   GLU    55      -4.589 -34.001   0.707  1.00  0.00
ATOM    870  O   GLU    55      -5.053 -34.776   1.547  1.00  0.00
ATOM    871  N   ARG    56      -4.022 -32.822   1.019  1.00  0.00
ATOM    872  HN  ARG    56      -3.640 -32.283   0.290  1.00  0.00
ATOM    873  CA  ARG    56      -3.933 -32.309   2.403  1.00  0.00
ATOM    874  HA  ARG    56      -3.552 -33.117   3.025  1.00  0.00
ATOM    875  CB  ARG    56      -2.925 -31.123   2.465  1.00  0.00
ATOM    876  HB1 ARG    56      -3.324 -30.300   1.880  1.00  0.00
ATOM    877  HB2 ARG    56      -1.991 -31.438   2.009  1.00  0.00
ATOM    878  CG  ARG    56      -2.610 -30.595   3.886  1.00  0.00
ATOM    879  HG1 ARG    56      -3.521 -30.187   4.312  1.00  0.00
ATOM    880  HG2 ARG    56      -1.874 -29.805   3.809  1.00  0.00
ATOM    881  CD  ARG    56      -2.065 -31.690   4.833  1.00  0.00
ATOM    882  HD1 ARG    56      -2.833 -32.446   4.967  1.00  0.00
ATOM    883  HD2 ARG    56      -1.841 -31.244   5.798  1.00  0.00
ATOM    884  NE  ARG    56      -0.838 -32.328   4.315  1.00  0.00
ATOM    885  HE  ARG    56      -0.259 -31.772   3.752  1.00  0.00
ATOM    886  CZ  ARG    56      -0.454 -33.590   4.565  1.00  0.00
ATOM    887  NH1 ARG    56      -1.223 -34.418   5.262  1.00  0.00
ATOM    888 HH11 ARG    56      -2.117 -34.112   5.603  1.00  0.00
ATOM    889 HH12 ARG    56      -0.919 -35.355   5.446  1.00  0.00
ATOM    890  NH2 ARG    56       0.694 -34.032   4.076  1.00  0.00
ATOM    891 HH21 ARG    56       1.269 -33.433   3.517  1.00  0.00
ATOM    892 HH22 ARG    56       0.996 -34.974   4.261  1.00  0.00
ATOM    893  C   ARG    56      -5.334 -31.891   2.936  1.00  0.00
ATOM    894  O   ARG    56      -5.620 -32.033   4.128  1.00  0.00
ATOM    895  N   PHE    57      -6.204 -31.392   2.029  1.00  0.00
ATOM    896  HN  PHE    57      -5.910 -31.324   1.097  1.00  0.00
ATOM    897  CA  PHE    57      -7.585 -30.948   2.363  1.00  0.00
ATOM    898  HA  PHE    57      -7.532 -30.378   3.288  1.00  0.00
ATOM    899  CB  PHE    57      -8.155 -30.015   1.240  1.00  0.00
ATOM    900  HB1 PHE    57      -9.239 -29.995   1.315  1.00  0.00
ATOM    901  HB2 PHE    57      -7.892 -30.433   0.277  1.00  0.00
ATOM    902  CG  PHE    57      -7.661 -28.555   1.239  1.00  0.00
ATOM    903  CD1 PHE    57      -6.323 -28.234   1.443  1.00  0.00
ATOM    904  HD1 PHE    57      -5.612 -29.028   1.633  1.00  0.00
ATOM    905  CD2 PHE    57      -8.549 -27.500   0.998  1.00  0.00
ATOM    906  HD2 PHE    57      -9.600 -27.716   0.836  1.00  0.00
ATOM    907  CE1 PHE    57      -5.887 -26.925   1.408  1.00  0.00
ATOM    908  HE1 PHE    57      -4.841 -26.702   1.568  1.00  0.00
ATOM    909  CE2 PHE    57      -8.111 -26.188   0.969  1.00  0.00
ATOM    910  HE2 PHE    57      -8.813 -25.386   0.782  1.00  0.00
ATOM    911  CZ  PHE    57      -6.779 -25.904   1.172  1.00  0.00
ATOM    912  HZ  PHE    57      -6.434 -24.879   1.146  1.00  0.00
ATOM    913  C   PHE    57      -8.536 -32.152   2.606  1.00  0.00
ATOM    914  O   PHE    57      -9.682 -31.953   3.023  1.00  0.00
ATOM    915  N   LYS    58      -8.074 -33.393   2.318  1.00  0.00
ATOM    916  HN  LYS    58      -7.206 -33.481   1.866  1.00  0.00
ATOM    917  CA  LYS    58      -8.839 -34.627   2.627  1.00  0.00
ATOM    918  HA  LYS    58      -9.859 -34.477   2.281  1.00  0.00
ATOM    919  CB  LYS    58      -8.243 -35.850   1.885  1.00  0.00
ATOM    920  HB1 LYS    58      -8.840 -36.730   2.113  1.00  0.00
ATOM    921  HB2 LYS    58      -7.231 -36.015   2.245  1.00  0.00
ATOM    922  CG  LYS    58      -8.181 -35.689   0.356  1.00  0.00
ATOM    923  HG1 LYS    58      -7.812 -36.613  -0.078  1.00  0.00
ATOM    924  HG2 LYS    58      -7.483 -34.889   0.124  1.00  0.00
ATOM    925  CD  LYS    58      -9.552 -35.346  -0.276  1.00  0.00
ATOM    926  HD1 LYS    58      -9.987 -34.502   0.249  1.00  0.00
ATOM    927  HD2 LYS    58     -10.211 -36.201  -0.182  1.00  0.00
ATOM    928  CE  LYS    58      -9.426 -34.987  -1.757  1.00  0.00
ATOM    929  HE1 LYS    58      -9.070 -35.848  -2.300  1.00  0.00
ATOM    930  HE2 LYS    58      -8.711 -34.181  -1.866  1.00  0.00
ATOM    931  NZ  LYS    58     -10.715 -34.548  -2.334  1.00  0.00
ATOM    932  HZ1 LYS    58     -11.058 -33.699  -1.837  1.00  0.00
ATOM    933  HZ2 LYS    58     -11.426 -35.302  -2.237  1.00  0.00
ATOM    934  HZ3 LYS    58     -10.596 -34.324  -3.338  1.00  0.00
ATOM    935  C   LYS    58      -8.880 -34.902   4.139  1.00  0.00
ATOM    936  O   LYS    58      -9.810 -35.558   4.624  1.00  0.00
ATOM    937  N   GLU    59      -7.848 -34.424   4.866  1.00  0.00
ATOM    938  HN  GLU    59      -7.096 -34.001   4.395  1.00  0.00
ATOM    939  CA  GLU    59      -7.802 -34.505   6.334  1.00  0.00
ATOM    940  HA  GLU    59      -8.011 -35.534   6.612  1.00  0.00
ATOM    941  CB  GLU    59      -6.395 -34.117   6.888  1.00  0.00
ATOM    942  HB1 GLU    59      -6.483 -33.914   7.951  1.00  0.00
ATOM    943  HB2 GLU    59      -6.068 -33.205   6.395  1.00  0.00
ATOM    944  CG  GLU    59      -5.294 -35.190   6.700  1.00  0.00
ATOM    945  HG1 GLU    59      -5.636 -36.116   7.159  1.00  0.00
ATOM    946  HG2 GLU    59      -4.403 -34.863   7.228  1.00  0.00
ATOM    947  CD  GLU    59      -4.917 -35.468   5.229  1.00  0.00
ATOM    948  OE1 GLU    59      -5.500 -36.392   4.608  1.00  0.00
ATOM    949  OE2 GLU    59      -4.030 -34.772   4.698  1.00  0.00
ATOM    950  C   GLU    59      -8.893 -33.597   6.933  1.00  0.00
ATOM    951  O   GLU    59      -8.849 -32.384   6.724  1.00  0.00
ATOM    952  N   PRO    60      -9.906 -34.161   7.674  1.00  0.00
ATOM    953  CA  PRO    60     -10.942 -33.342   8.356  1.00  0.00
ATOM    954  HA  PRO    60     -11.427 -32.665   7.661  1.00  0.00
ATOM    955  CB  PRO    60     -11.959 -34.398   8.862  1.00  0.00
ATOM    956  HB1 PRO    60     -12.746 -34.531   8.122  1.00  0.00
ATOM    957  HB2 PRO    60     -12.407 -34.076   9.797  1.00  0.00
ATOM    958  CG  PRO    60     -11.148 -35.653   9.029  1.00  0.00
ATOM    959  HG1 PRO    60     -11.783 -36.527   8.927  1.00  0.00
ATOM    960  HG2 PRO    60     -10.668 -35.659  10.006  1.00  0.00
ATOM    961  CD  PRO    60     -10.112 -35.619   7.924  1.00  0.00
ATOM    962  HD1 PRO    60     -10.484 -36.107   7.030  1.00  0.00
ATOM    963  HD2 PRO    60      -9.189 -36.089   8.251  1.00  0.00
ATOM    964  C   PRO    60     -10.324 -32.526   9.518  1.00  0.00
ATOM    965  O   PRO    60     -10.854 -31.489   9.933  1.00  0.00
ATOM    966  N   ASP    61      -9.169 -33.022   9.991  1.00  0.00
ATOM    967  HN  ASP    61      -8.815 -33.826   9.561  1.00  0.00
ATOM    968  CA  ASP    61      -8.383 -32.455  11.093  1.00  0.00
ATOM    969  HA  ASP    61      -9.070 -32.015  11.810  1.00  0.00
ATOM    970  CB  ASP    61      -7.609 -33.601  11.794  1.00  0.00
ATOM    971  HB1 ASP    61      -8.322 -34.253  12.287  1.00  0.00
ATOM    972  HB2 ASP    61      -6.956 -33.183  12.556  1.00  0.00
ATOM    973  CG  ASP    61      -6.756 -34.455  10.824  1.00  0.00
ATOM    974  OD1 ASP    61      -5.547 -34.192  10.674  1.00  0.00
ATOM    975  OD2 ASP    61      -7.305 -35.406  10.215  1.00  0.00
ATOM    976  C   ASP    61      -7.413 -31.352  10.623  1.00  0.00
ATOM    977  O   ASP    61      -6.754 -30.720  11.462  1.00  0.00
ATOM    978  N   LEU    62      -7.318 -31.129   9.291  1.00  0.00
ATOM    979  HN  LEU    62      -7.811 -31.708   8.679  1.00  0.00
ATOM    980  CA  LEU    62      -6.494 -30.040   8.727  1.00  0.00
ATOM    981  HA  LEU    62      -5.474 -30.172   9.090  1.00  0.00
ATOM    982  CB  LEU    62      -6.475 -30.062   7.168  1.00  0.00
ATOM    983  HB1 LEU    62      -7.502 -30.058   6.817  1.00  0.00
ATOM    984  HB2 LEU    62      -6.010 -30.990   6.844  1.00  0.00
ATOM    985  CG  LEU    62      -5.719 -28.856   6.503  1.00  0.00
ATOM    986  HG  LEU    62      -6.098 -27.939   6.942  1.00  0.00
ATOM    987  CD1 LEU    62      -4.214 -28.898   6.824  1.00  0.00
ATOM    988 HD11 LEU    62      -3.776 -29.810   6.436  1.00  0.00
ATOM    989 HD12 LEU    62      -4.069 -28.860   7.897  1.00  0.00
ATOM    990 HD13 LEU    62      -3.724 -28.045   6.374  1.00  0.00
ATOM    991  CD2 LEU    62      -5.976 -28.767   4.987  1.00  0.00
ATOM    992 HD21 LEU    62      -5.614 -29.663   4.497  1.00  0.00
ATOM    993 HD22 LEU    62      -5.466 -27.904   4.578  1.00  0.00
ATOM    994 HD23 LEU    62      -7.039 -28.667   4.805  1.00  0.00
ATOM    995  C   LEU    62      -7.024 -28.673   9.193  1.00  0.00
ATOM    996  O   LEU    62      -8.181 -28.332   8.930  1.00  0.00
ATOM    997  N   TYR    63      -6.169 -27.902   9.876  1.00  0.00
ATOM    998  HN  TYR    63      -5.303 -28.282  10.141  1.00  0.00
ATOM    999  CA  TYR    63      -6.484 -26.522  10.257  1.00  0.00
ATOM   1000  HA  TYR    63      -7.120 -26.093   9.484  1.00  0.00
ATOM   1001  CB  TYR    63      -7.248 -26.497  11.610  1.00  0.00
ATOM   1002  HB1 TYR    63      -6.596 -26.860  12.393  1.00  0.00
ATOM   1003  HB2 TYR    63      -8.108 -27.157  11.545  1.00  0.00
ATOM   1004  CG  TYR    63      -7.756 -25.106  12.011  1.00  0.00
ATOM   1005  CD1 TYR    63      -8.895 -24.564  11.412  1.00  0.00
ATOM   1006  HD1 TYR    63      -9.432 -25.148  10.672  1.00  0.00
ATOM   1007  CD2 TYR    63      -7.089 -24.331  12.963  1.00  0.00
ATOM   1008  HD2 TYR    63      -6.204 -24.733  13.447  1.00  0.00
ATOM   1009  CE1 TYR    63      -9.355 -23.305  11.754  1.00  0.00
ATOM   1010  HE1 TYR    63     -10.241 -22.910  11.279  1.00  0.00
ATOM   1011  CE2 TYR    63      -7.548 -23.074  13.309  1.00  0.00
ATOM   1012  HE2 TYR    63      -7.014 -22.493  14.052  1.00  0.00
ATOM   1013  CZ  TYR    63      -8.674 -22.562  12.699  1.00  0.00
ATOM   1014  OH  TYR    63      -9.124 -21.307  13.039  1.00  0.00
ATOM   1015  HH  TYR    63      -8.371 -20.697  13.085  1.00  0.00
ATOM   1016  C   TYR    63      -5.186 -25.702  10.342  1.00  0.00
ATOM   1017  O   TYR    63      -4.316 -26.004  11.162  1.00  0.00
ATOM   1018  N   GLY    64      -5.066 -24.667   9.493  1.00  0.00
ATOM   1019  HN  GLY    64      -5.752 -24.532   8.814  1.00  0.00
ATOM   1020  CA  GLY    64      -3.939 -23.738   9.559  1.00  0.00
ATOM   1021  HA1 GLY    64      -3.723 -23.383   8.558  1.00  0.00
ATOM   1022  HA2 GLY    64      -3.058 -24.241   9.944  1.00  0.00
ATOM   1023  C   GLY    64      -4.286 -22.551  10.439  1.00  0.00
ATOM   1024  O   GLY    64      -5.040 -21.668  10.015  1.00  0.00
ATOM   1025  N   GLU    65      -3.767 -22.554  11.678  1.00  0.00
ATOM   1026  HN  GLU    65      -3.223 -23.324  11.955  1.00  0.00
ATOM   1027  CA  GLU    65      -3.981 -21.460  12.641  1.00  0.00
ATOM   1028  HA  GLU    65      -4.893 -20.934  12.359  1.00  0.00
ATOM   1029  CB  GLU    65      -4.157 -22.022  14.079  1.00  0.00
ATOM   1030  HB1 GLU    65      -3.276 -22.602  14.337  1.00  0.00
ATOM   1031  HB2 GLU    65      -5.016 -22.682  14.086  1.00  0.00
ATOM   1032  CG  GLU    65      -4.365 -20.940  15.164  1.00  0.00
ATOM   1033  HG1 GLU    65      -5.112 -20.237  14.811  1.00  0.00
ATOM   1034  HG2 GLU    65      -3.430 -20.404  15.301  1.00  0.00
ATOM   1035  CD  GLU    65      -4.810 -21.501  16.529  1.00  0.00
ATOM   1036  OE1 GLU    65      -3.973 -22.103  17.236  1.00  0.00
ATOM   1037  OE2 GLU    65      -5.989 -21.319  16.912  1.00  0.00
ATOM   1038  C   GLU    65      -2.805 -20.484  12.573  1.00  0.00
ATOM   1039  O   GLU    65      -1.716 -20.782  13.081  1.00  0.00
ATOM   1040  N   LEU    66      -3.025 -19.335  11.914  1.00  0.00
ATOM   1041  HN  LEU    66      -3.920 -19.164  11.554  1.00  0.00
ATOM   1042  CA  LEU    66      -1.977 -18.329  11.725  1.00  0.00
ATOM   1043  HA  LEU    66      -1.106 -18.842  11.325  1.00  0.00
ATOM   1044  CB  LEU    66      -2.394 -17.227  10.735  1.00  0.00
ATOM   1045  HB1 LEU    66      -3.212 -16.659  11.175  1.00  0.00
ATOM   1046  HB2 LEU    66      -2.770 -17.702   9.831  1.00  0.00
ATOM   1047  CG  LEU    66      -1.236 -16.235  10.348  1.00  0.00
ATOM   1048  HG  LEU    66      -0.560 -16.154  11.204  1.00  0.00
ATOM   1049  CD1 LEU    66      -0.385 -16.773   9.174  1.00  0.00
ATOM   1050 HD11 LEU    66       0.388 -16.056   8.929  1.00  0.00
ATOM   1051 HD12 LEU    66      -1.017 -16.932   8.304  1.00  0.00
ATOM   1052 HD13 LEU    66       0.076 -17.713   9.455  1.00  0.00
ATOM   1053  CD2 LEU    66      -1.774 -14.828  10.053  1.00  0.00
ATOM   1054 HD21 LEU    66      -2.436 -14.862   9.196  1.00  0.00
ATOM   1055 HD22 LEU    66      -0.950 -14.162   9.843  1.00  0.00
ATOM   1056 HD23 LEU    66      -2.318 -14.458  10.911  1.00  0.00
ATOM   1057  C   LEU    66      -1.596 -17.678  13.066  1.00  0.00
ATOM   1058  O   LEU    66      -2.457 -17.389  13.903  1.00  0.00
ATOM   1059  N   LEU    67      -0.296 -17.458  13.229  1.00  0.00
ATOM   1060  HN  LEU    67       0.304 -17.721  12.501  1.00  0.00
ATOM   1061  CA  LEU    67       0.300 -16.857  14.426  1.00  0.00
ATOM   1062  HA  LEU    67      -0.420 -16.849  15.242  1.00  0.00
ATOM   1063  CB  LEU    67       1.533 -17.710  14.815  1.00  0.00
ATOM   1064  HB1 LEU    67       1.818 -17.465  15.834  1.00  0.00
ATOM   1065  HB2 LEU    67       2.362 -17.437  14.158  1.00  0.00
ATOM   1066  CG  LEU    67       1.325 -19.248  14.715  1.00  0.00
ATOM   1067  HG  LEU    67       0.803 -19.457  13.785  1.00  0.00
ATOM   1068  CD1 LEU    67       2.662 -19.982  14.639  1.00  0.00
ATOM   1069 HD11 LEU    67       3.244 -19.789  15.531  1.00  0.00
ATOM   1070 HD12 LEU    67       3.205 -19.626  13.771  1.00  0.00
ATOM   1071 HD13 LEU    67       2.493 -21.046  14.539  1.00  0.00
ATOM   1072  CD2 LEU    67       0.450 -19.774  15.865  1.00  0.00
ATOM   1073 HD21 LEU    67      -0.520 -19.295  15.822  1.00  0.00
ATOM   1074 HD22 LEU    67       0.919 -19.555  16.815  1.00  0.00
ATOM   1075 HD23 LEU    67       0.324 -20.845  15.765  1.00  0.00
ATOM   1076  C   LEU    67       0.747 -15.437  14.081  1.00  0.00
ATOM   1077  O   LEU    67       0.355 -14.454  14.717  1.00  0.00
ATOM   1078  N   THR    68       1.537 -15.371  13.005  1.00  0.00
ATOM   1079  HN  THR    68       1.670 -16.197  12.483  1.00  0.00
ATOM   1080  CA  THR    68       2.230 -14.158  12.560  1.00  0.00
ATOM   1081  HA  THR    68       1.645 -13.294  12.870  1.00  0.00
ATOM   1082  CB  THR    68       3.651 -14.075  13.235  1.00  0.00
ATOM   1083  HB  THR    68       4.168 -15.016  13.050  1.00  0.00
ATOM   1084  OG1 THR    68       3.499 -13.930  14.661  1.00  0.00
ATOM   1085  HG1 THR    68       3.252 -13.020  14.868  1.00  0.00
ATOM   1086  CG2 THR    68       4.528 -12.927  12.695  1.00  0.00
ATOM   1087 HG21 THR    68       4.726 -13.084  11.641  1.00  0.00
ATOM   1088 HG22 THR    68       5.465 -12.902  13.233  1.00  0.00
ATOM   1089 HG23 THR    68       4.015 -11.981  12.824  1.00  0.00
ATOM   1090  C   THR    68       2.355 -14.164  11.029  1.00  0.00
ATOM   1091  O   THR    68       2.523 -15.218  10.420  1.00  0.00
ATOM   1092  N   ARG    69       2.257 -12.973  10.430  1.00  0.00
ATOM   1093  HN  ARG    69       2.025 -12.200  10.978  1.00  0.00
ATOM   1094  CA  ARG    69       2.482 -12.752   9.001  1.00  0.00
ATOM   1095  HA  ARG    69       3.107 -13.561   8.627  1.00  0.00
ATOM   1096  CB  ARG    69       1.137 -12.746   8.221  1.00  0.00
ATOM   1097  HB1 ARG    69       0.721 -13.750   8.239  1.00  0.00
ATOM   1098  HB2 ARG    69       1.324 -12.469   7.189  1.00  0.00
ATOM   1099  CG  ARG    69       0.092 -11.782   8.808  1.00  0.00
ATOM   1100  HG1 ARG    69       0.529 -10.788   8.858  1.00  0.00
ATOM   1101  HG2 ARG    69      -0.149 -12.105   9.814  1.00  0.00
ATOM   1102  CD  ARG    69      -1.205 -11.704   8.003  1.00  0.00
ATOM   1103  HD1 ARG    69      -1.619 -12.701   7.892  1.00  0.00
ATOM   1104  HD2 ARG    69      -0.986 -11.296   7.020  1.00  0.00
ATOM   1105  NE  ARG    69      -2.195 -10.844   8.682  1.00  0.00
ATOM   1106  HE  ARG    69      -2.097 -10.746   9.658  1.00  0.00
ATOM   1107  CZ  ARG    69      -3.204 -10.199   8.083  1.00  0.00
ATOM   1108  NH1 ARG    69      -3.389 -10.298   6.771  1.00  0.00
ATOM   1109 HH11 ARG    69      -2.775 -10.859   6.216  1.00  0.00
ATOM   1110 HH12 ARG    69      -4.145  -9.809   6.327  1.00  0.00
ATOM   1111  NH2 ARG    69      -4.023  -9.449   8.808  1.00  0.00
ATOM   1112 HH21 ARG    69      -3.895  -9.373   9.800  1.00  0.00
ATOM   1113 HH22 ARG    69      -4.775  -8.947   8.368  1.00  0.00
ATOM   1114  C   ARG    69       3.235 -11.423   8.819  1.00  0.00
ATOM   1115  O   ARG    69       2.846 -10.392   9.386  1.00  0.00
ATOM   1116  N   VAL    70       4.342 -11.464   8.066  1.00  0.00
ATOM   1117  HN  VAL    70       4.627 -12.333   7.703  1.00  0.00
ATOM   1118  CA  VAL    70       5.139 -10.268   7.727  1.00  0.00
ATOM   1119  HA  VAL    70       4.607  -9.388   8.089  1.00  0.00
ATOM   1120  CB  VAL    70       6.573 -10.288   8.399  1.00  0.00
ATOM   1121  HB  VAL    70       7.070  -9.362   8.142  1.00  0.00
ATOM   1122  CG1 VAL    70       6.464 -10.341   9.939  1.00  0.00
ATOM   1123 HG11 VAL    70       5.949 -11.249  10.237  1.00  0.00
ATOM   1124 HG12 VAL    70       5.908  -9.485  10.300  1.00  0.00
ATOM   1125 HG13 VAL    70       7.453 -10.331  10.382  1.00  0.00
ATOM   1126  CG2 VAL    70       7.456 -11.443   7.878  1.00  0.00
ATOM   1127 HG21 VAL    70       7.015 -12.395   8.154  1.00  0.00
ATOM   1128 HG22 VAL    70       8.449 -11.375   8.305  1.00  0.00
ATOM   1129 HG23 VAL    70       7.533 -11.390   6.797  1.00  0.00
ATOM   1130  C   VAL    70       5.254 -10.159   6.205  1.00  0.00
ATOM   1131  O   VAL    70       5.202 -11.171   5.510  1.00  0.00
ATOM   1132  N   ILE    71       5.408  -8.934   5.688  1.00  0.00
ATOM   1133  HN  ILE    71       5.460  -8.167   6.296  1.00  0.00
ATOM   1134  CA  ILE    71       5.504  -8.694   4.237  1.00  0.00
ATOM   1135  HA  ILE    71       5.712  -9.652   3.753  1.00  0.00
ATOM   1136  CB  ILE    71       4.140  -8.162   3.640  1.00  0.00
ATOM   1137  HB  ILE    71       3.419  -8.972   3.729  1.00  0.00
ATOM   1138  CG1 ILE    71       4.286  -7.810   2.124  1.00  0.00
ATOM   1139 HG11 ILE    71       4.695  -8.665   1.597  1.00  0.00
ATOM   1140 HG12 ILE    71       4.961  -6.973   2.010  1.00  0.00
ATOM   1141  CG2 ILE    71       3.573  -6.976   4.453  1.00  0.00
ATOM   1142 HG21 ILE    71       3.444  -7.275   5.485  1.00  0.00
ATOM   1143 HG22 ILE    71       2.614  -6.672   4.050  1.00  0.00
ATOM   1144 HG23 ILE    71       4.260  -6.140   4.406  1.00  0.00
ATOM   1145  CD1 ILE    71       2.987  -7.439   1.443  1.00  0.00
ATOM   1146 HD11 ILE    71       2.543  -6.583   1.935  1.00  0.00
ATOM   1147 HD12 ILE    71       2.301  -8.274   1.484  1.00  0.00
ATOM   1148 HD13 ILE    71       3.185  -7.192   0.410  1.00  0.00
ATOM   1149  C   ILE    71       6.677  -7.743   3.926  1.00  0.00
ATOM   1150  O   ILE    71       6.729  -6.606   4.414  1.00  0.00
ATOM   1151  N   VAL    72       7.647  -8.257   3.143  1.00  0.00
ATOM   1152  HN  VAL    72       7.561  -9.189   2.860  1.00  0.00
ATOM   1153  CA  VAL    72       8.823  -7.508   2.680  1.00  0.00
ATOM   1154  HA  VAL    72       8.838  -6.531   3.166  1.00  0.00
ATOM   1155  CB  VAL    72      10.159  -8.271   3.052  1.00  0.00
ATOM   1156  HB  VAL    72      10.197  -9.188   2.462  1.00  0.00
ATOM   1157  CG1 VAL    72      11.412  -7.431   2.695  1.00  0.00
ATOM   1158 HG11 VAL    72      11.407  -6.504   3.256  1.00  0.00
ATOM   1159 HG12 VAL    72      11.416  -7.203   1.634  1.00  0.00
ATOM   1160 HG13 VAL    72      12.309  -7.988   2.937  1.00  0.00
ATOM   1161  CG2 VAL    72      10.166  -8.680   4.549  1.00  0.00
ATOM   1162 HG21 VAL    72      11.070  -9.230   4.774  1.00  0.00
ATOM   1163 HG22 VAL    72       9.307  -9.308   4.762  1.00  0.00
ATOM   1164 HG23 VAL    72      10.121  -7.794   5.173  1.00  0.00
ATOM   1165  C   VAL    72       8.709  -7.316   1.152  1.00  0.00
ATOM   1166  O   VAL    72       9.061  -8.215   0.377  1.00  0.00
ATOM   1167  N   GLY    73       8.172  -6.154   0.742  1.00  0.00
ATOM   1168  HN  GLY    73       7.902  -5.501   1.421  1.00  0.00
ATOM   1169  CA  GLY    73       7.972  -5.828  -0.676  1.00  0.00
ATOM   1170  HA1 GLY    73       8.932  -5.852  -1.185  1.00  0.00
ATOM   1171  HA2 GLY    73       7.580  -4.822  -0.740  1.00  0.00
ATOM   1172  C   GLY    73       6.996  -6.771  -1.386  1.00  0.00
ATOM   1173  O   GLY    73       5.793  -6.767  -1.097  1.00  0.00
ATOM   1174  N   ASN    74       7.526  -7.594  -2.308  1.00  0.00
ATOM   1175  HN  ASN    74       8.498  -7.567  -2.448  1.00  0.00
ATOM   1176  CA  ASN    74       6.729  -8.548  -3.117  1.00  0.00
ATOM   1177  HA  ASN    74       5.713  -8.166  -3.186  1.00  0.00
ATOM   1178  CB  ASN    74       7.314  -8.665  -4.555  1.00  0.00
ATOM   1179  HB1 ASN    74       7.322  -7.683  -5.010  1.00  0.00
ATOM   1180  HB2 ASN    74       6.675  -9.315  -5.146  1.00  0.00
ATOM   1181  CG  ASN    74       8.750  -9.214  -4.594  1.00  0.00
ATOM   1182  OD1 ASN    74       9.585  -8.891  -3.742  1.00  0.00
ATOM   1183  ND2 ASN    74       9.037 -10.074  -5.557  1.00  0.00
ATOM   1184 HD21 ASN    74       8.325 -10.315  -6.189  1.00  0.00
ATOM   1185 HD22 ASN    74       9.943 -10.438  -5.598  1.00  0.00
ATOM   1186  C   ASN    74       6.680  -9.946  -2.463  1.00  0.00
ATOM   1187  O   ASN    74       6.224 -10.908  -3.082  1.00  0.00
ATOM   1188  N   VAL    75       7.108 -10.034  -1.201  1.00  0.00
ATOM   1189  HN  VAL    75       7.260  -9.199  -0.708  1.00  0.00
ATOM   1190  CA  VAL    75       7.309 -11.315  -0.489  1.00  0.00
ATOM   1191  HA  VAL    75       6.945 -12.129  -1.117  1.00  0.00
ATOM   1192  CB  VAL    75       8.848 -11.555  -0.195  1.00  0.00
ATOM   1193  HB  VAL    75       9.218 -10.684   0.349  1.00  0.00
ATOM   1194  CG1 VAL    75       9.087 -12.801   0.696  1.00  0.00
ATOM   1195 HG11 VAL    75       8.592 -12.672   1.653  1.00  0.00
ATOM   1196 HG12 VAL    75      10.147 -12.937   0.863  1.00  0.00
ATOM   1197 HG13 VAL    75       8.687 -13.683   0.207  1.00  0.00
ATOM   1198  CG2 VAL    75       9.662 -11.661  -1.510  1.00  0.00
ATOM   1199 HG21 VAL    75       9.314 -12.507  -2.091  1.00  0.00
ATOM   1200 HG22 VAL    75      10.714 -11.794  -1.282  1.00  0.00
ATOM   1201 HG23 VAL    75       9.541 -10.755  -2.094  1.00  0.00
ATOM   1202  C   VAL    75       6.515 -11.301   0.828  1.00  0.00
ATOM   1203  O   VAL    75       6.544 -10.301   1.540  1.00  0.00
ATOM   1204  N   VAL    76       5.783 -12.395   1.139  1.00  0.00
ATOM   1205  HN  VAL    76       5.728 -13.126   0.488  1.00  0.00
ATOM   1206  CA  VAL    76       5.064 -12.541   2.428  1.00  0.00
ATOM   1207  HA  VAL    76       5.338 -11.701   3.071  1.00  0.00
ATOM   1208  CB  VAL    76       3.493 -12.528   2.262  1.00  0.00
ATOM   1209  HB  VAL    76       3.200 -13.449   1.754  1.00  0.00
ATOM   1210  CG1 VAL    76       2.783 -12.508   3.646  1.00  0.00
ATOM   1211 HG11 VAL    76       1.711 -12.534   3.510  1.00  0.00
ATOM   1212 HG12 VAL    76       3.049 -11.606   4.184  1.00  0.00
ATOM   1213 HG13 VAL    76       3.086 -13.371   4.232  1.00  0.00
ATOM   1214  CG2 VAL    76       3.019 -11.344   1.389  1.00  0.00
ATOM   1215 HG21 VAL    76       3.486 -11.397   0.411  1.00  0.00
ATOM   1216 HG22 VAL    76       3.288 -10.408   1.859  1.00  0.00
ATOM   1217 HG23 VAL    76       1.945 -11.385   1.269  1.00  0.00
ATOM   1218  C   VAL    76       5.475 -13.854   3.126  1.00  0.00
ATOM   1219  O   VAL    76       5.559 -14.898   2.492  1.00  0.00
ATOM   1220  N   ILE    77       5.734 -13.766   4.433  1.00  0.00
ATOM   1221  HN  ILE    77       5.813 -12.878   4.816  1.00  0.00
ATOM   1222  CA  ILE    77       5.916 -14.910   5.337  1.00  0.00
ATOM   1223  HA  ILE    77       6.176 -15.798   4.765  1.00  0.00
ATOM   1224  CB  ILE    77       7.073 -14.588   6.362  1.00  0.00
ATOM   1225  HB  ILE    77       6.847 -13.610   6.770  1.00  0.00
ATOM   1226  CG1 ILE    77       8.463 -14.486   5.659  1.00  0.00
ATOM   1227 HG11 ILE    77       9.137 -13.928   6.297  1.00  0.00
ATOM   1228 HG12 ILE    77       8.355 -13.959   4.723  1.00  0.00
ATOM   1229  CG2 ILE    77       7.119 -15.560   7.574  1.00  0.00
ATOM   1230 HG21 ILE    77       7.923 -15.265   8.242  1.00  0.00
ATOM   1231 HG22 ILE    77       7.286 -16.571   7.234  1.00  0.00
ATOM   1232 HG23 ILE    77       6.178 -15.513   8.111  1.00  0.00
ATOM   1233  CD1 ILE    77       9.122 -15.813   5.355  1.00  0.00
ATOM   1234 HD11 ILE    77       8.436 -16.442   4.804  1.00  0.00
ATOM   1235 HD12 ILE    77       9.395 -16.301   6.279  1.00  0.00
ATOM   1236 HD13 ILE    77      10.007 -15.641   4.763  1.00  0.00
ATOM   1237  C   ILE    77       4.599 -15.127   6.100  1.00  0.00
ATOM   1238  O   ILE    77       4.265 -14.325   6.974  1.00  0.00
ATOM   1239  N   ASP    78       3.831 -16.161   5.735  1.00  0.00
ATOM   1240  HN  ASP    78       4.024 -16.623   4.895  1.00  0.00
ATOM   1241  CA  ASP    78       2.693 -16.628   6.545  1.00  0.00
ATOM   1242  HA  ASP    78       2.361 -15.800   7.176  1.00  0.00
ATOM   1243  CB  ASP    78       1.495 -17.090   5.663  1.00  0.00
ATOM   1244  HB1 ASP    78       0.808 -17.681   6.263  1.00  0.00
ATOM   1245  HB2 ASP    78       1.871 -17.715   4.859  1.00  0.00
ATOM   1246  CG  ASP    78       0.722 -15.907   5.051  1.00  0.00
ATOM   1247  OD1 ASP    78      -0.279 -15.444   5.664  1.00  0.00
ATOM   1248  OD2 ASP    78       1.123 -15.426   3.972  1.00  0.00
ATOM   1249  C   ASP    78       3.178 -17.755   7.453  1.00  0.00
ATOM   1250  O   ASP    78       3.447 -18.863   6.993  1.00  0.00
ATOM   1251  N   HIS    79       3.324 -17.435   8.743  1.00  0.00
ATOM   1252  HN  HIS    79       3.119 -16.519   9.012  1.00  0.00
ATOM   1253  CA  HIS    79       3.748 -18.381   9.770  1.00  0.00
ATOM   1254  HA  HIS    79       4.225 -19.233   9.284  1.00  0.00
ATOM   1255  CB  HIS    79       4.778 -17.711  10.721  1.00  0.00
ATOM   1256  HB1 HIS    79       4.334 -16.814  11.146  1.00  0.00
ATOM   1257  HB2 HIS    79       5.650 -17.421  10.147  1.00  0.00
ATOM   1258  CG  HIS    79       5.266 -18.576  11.867  1.00  0.00
ATOM   1259  ND1 HIS    79       5.141 -19.954  11.901  1.00  0.00
ATOM   1260  HD1 HIS    79       4.729 -20.508  11.208  1.00  0.00
ATOM   1261  CD2 HIS    79       5.881 -18.238  13.023  1.00  0.00
ATOM   1262  HD2 HIS    79       6.149 -17.237  13.337  1.00  0.00
ATOM   1263  CE1 HIS    79       5.651 -20.417  13.021  1.00  0.00
ATOM   1264  HE1 HIS    79       5.647 -21.450  13.340  1.00  0.00
ATOM   1265  NE2 HIS    79       6.108 -19.397  13.721  1.00  0.00
ATOM   1266  HE2 HIS    79       6.411 -19.446  14.651  1.00  0.00
ATOM   1267  C   HIS    79       2.505 -18.858  10.529  1.00  0.00
ATOM   1268  O   HIS    79       1.921 -18.112  11.330  1.00  0.00
ATOM   1269  N   GLU    80       2.124 -20.108  10.258  1.00  0.00
ATOM   1270  HN  GLU    80       2.686 -20.635   9.644  1.00  0.00
ATOM   1271  CA  GLU    80       0.924 -20.760  10.804  1.00  0.00
ATOM   1272  HA  GLU    80       0.514 -20.115  11.578  1.00  0.00
ATOM   1273  CB  GLU    80      -0.175 -20.959   9.682  1.00  0.00
ATOM   1274  HB1 GLU    80      -0.900 -20.154   9.758  1.00  0.00
ATOM   1275  HB2 GLU    80      -0.700 -21.893   9.862  1.00  0.00
ATOM   1276  CG  GLU    80       0.335 -20.987   8.215  1.00  0.00
ATOM   1277  HG1 GLU    80       0.813 -20.034   8.008  1.00  0.00
ATOM   1278  HG2 GLU    80      -0.520 -21.089   7.549  1.00  0.00
ATOM   1279  CD  GLU    80       1.327 -22.123   7.905  1.00  0.00
ATOM   1280  OE1 GLU    80       0.900 -23.297   7.853  1.00  0.00
ATOM   1281  OE2 GLU    80       2.529 -21.843   7.704  1.00  0.00
ATOM   1282  C   GLU    80       1.303 -22.088  11.480  1.00  0.00
ATOM   1283  O   GLU    80       2.444 -22.541  11.390  1.00  0.00
ATOM   1284  N   THR    81       0.341 -22.666  12.209  1.00  0.00
ATOM   1285  HN  THR    81      -0.501 -22.191  12.319  1.00  0.00
ATOM   1286  CA  THR    81       0.474 -23.983  12.842  1.00  0.00
ATOM   1287  HA  THR    81       1.480 -24.371  12.650  1.00  0.00
ATOM   1288  CB  THR    81       0.261 -23.908  14.389  1.00  0.00
ATOM   1289  HB  THR    81      -0.787 -23.710  14.592  1.00  0.00
ATOM   1290  OG1 THR    81       1.039 -22.837  14.930  1.00  0.00
ATOM   1291  HG1 THR    81       1.976 -23.062  14.888  1.00  0.00
ATOM   1292  CG2 THR    81       0.660 -25.216  15.097  1.00  0.00
ATOM   1293 HG21 THR    81       0.482 -25.123  16.161  1.00  0.00
ATOM   1294 HG22 THR    81       1.711 -25.421  14.928  1.00  0.00
ATOM   1295 HG23 THR    81       0.070 -26.040  14.711  1.00  0.00
ATOM   1296  C   THR    81      -0.563 -24.926  12.218  1.00  0.00
ATOM   1297  O   THR    81      -1.772 -24.750  12.420  1.00  0.00
ATOM   1298  N   VAL    82      -0.083 -25.896  11.437  1.00  0.00
ATOM   1299  HN  VAL    82       0.879 -25.935  11.288  1.00  0.00
ATOM   1300  CA  VAL    82      -0.929 -26.888  10.775  1.00  0.00
ATOM   1301  HA  VAL    82      -1.840 -26.394  10.432  1.00  0.00
ATOM   1302  CB  VAL    82      -0.208 -27.516   9.527  1.00  0.00
ATOM   1303  HB  VAL    82       0.646 -28.088   9.892  1.00  0.00
ATOM   1304  CG1 VAL    82      -1.137 -28.498   8.783  1.00  0.00
ATOM   1305 HG11 VAL    82      -1.435 -29.296   9.457  1.00  0.00
ATOM   1306 HG12 VAL    82      -0.621 -28.927   7.934  1.00  0.00
ATOM   1307 HG13 VAL    82      -2.021 -27.976   8.438  1.00  0.00
ATOM   1308  CG2 VAL    82       0.337 -26.425   8.585  1.00  0.00
ATOM   1309 HG21 VAL    82       0.824 -26.885   7.735  1.00  0.00
ATOM   1310 HG22 VAL    82       1.059 -25.812   9.117  1.00  0.00
ATOM   1311 HG23 VAL    82      -0.475 -25.799   8.238  1.00  0.00
ATOM   1312  C   VAL    82      -1.296 -28.010  11.758  1.00  0.00
ATOM   1313  O   VAL    82      -0.461 -28.864  12.069  1.00  0.00
ATOM   1314  N   THR    83      -2.536 -27.975  12.262  1.00  0.00
ATOM   1315  HN  THR    83      -3.078 -27.181  12.119  1.00  0.00
ATOM   1316  CA  THR    83      -3.105 -29.082  13.035  1.00  0.00
ATOM   1317  HA  THR    83      -2.412 -29.323  13.839  1.00  0.00
ATOM   1318  CB  THR    83      -4.481 -28.685  13.668  1.00  0.00
ATOM   1319  HB  THR    83      -5.160 -28.404  12.867  1.00  0.00
ATOM   1320  OG1 THR    83      -4.309 -27.544  14.529  1.00  0.00
ATOM   1321  HG1 THR    83      -3.679 -26.932  14.133  1.00  0.00
ATOM   1322  CG2 THR    83      -5.123 -29.845  14.468  1.00  0.00
ATOM   1323 HG21 THR    83      -4.452 -30.164  15.257  1.00  0.00
ATOM   1324 HG22 THR    83      -5.319 -30.683  13.809  1.00  0.00
ATOM   1325 HG23 THR    83      -6.058 -29.516  14.906  1.00  0.00
ATOM   1326  C   THR    83      -3.273 -30.305  12.114  1.00  0.00
ATOM   1327  O   THR    83      -3.958 -30.228  11.087  1.00  0.00
ATOM   1328  N   ARG    84      -2.578 -31.394  12.467  1.00  0.00
ATOM   1329  HN  ARG    84      -1.972 -31.324  13.232  1.00  0.00
ATOM   1330  CA  ARG    84      -2.657 -32.694  11.781  1.00  0.00
ATOM   1331  HA  ARG    84      -3.432 -32.655  11.018  1.00  0.00
ATOM   1332  CB  ARG    84      -1.281 -33.031  11.121  1.00  0.00
ATOM   1333  HB1 ARG    84      -1.383 -33.960  10.565  1.00  0.00
ATOM   1334  HB2 ARG    84      -0.548 -33.183  11.909  1.00  0.00
ATOM   1335  CG  ARG    84      -0.732 -31.946  10.157  1.00  0.00
ATOM   1336  HG1 ARG    84      -0.660 -31.004  10.698  1.00  0.00
ATOM   1337  HG2 ARG    84      -1.423 -31.826   9.334  1.00  0.00
ATOM   1338  CD  ARG    84       0.658 -32.295   9.587  1.00  0.00
ATOM   1339  HD1 ARG    84       0.579 -33.224   9.033  1.00  0.00
ATOM   1340  HD2 ARG    84       1.346 -32.434  10.413  1.00  0.00
ATOM   1341  NE  ARG    84       1.205 -31.246   8.692  1.00  0.00
ATOM   1342  HE  ARG    84       0.848 -30.336   8.810  1.00  0.00
ATOM   1343  CZ  ARG    84       2.180 -31.435   7.775  1.00  0.00
ATOM   1344  NH1 ARG    84       2.668 -32.650   7.536  1.00  0.00
ATOM   1345 HH11 ARG    84       2.318 -33.441   8.044  1.00  0.00
ATOM   1346 HH12 ARG    84       3.395 -32.782   6.857  1.00  0.00
ATOM   1347  NH2 ARG    84       2.654 -30.397   7.089  1.00  0.00
ATOM   1348 HH21 ARG    84       2.292 -29.477   7.252  1.00  0.00
ATOM   1349 HH22 ARG    84       3.387 -30.528   6.414  1.00  0.00
ATOM   1350  C   ARG    84      -3.039 -33.762  12.825  1.00  0.00
ATOM   1351  O   ARG    84      -3.453 -33.417  13.938  1.00  0.00
ATOM   1352  N   ASN    85      -2.949 -35.050  12.453  1.00  0.00
ATOM   1353  HN  ASN    85      -2.807 -35.252  11.503  1.00  0.00
ATOM   1354  CA  ASN    85      -3.068 -36.183  13.401  1.00  0.00
ATOM   1355  HA  ASN    85      -3.227 -35.777  14.401  1.00  0.00
ATOM   1356  CB  ASN    85      -4.278 -37.105  13.042  1.00  0.00
ATOM   1357  HB1 ASN    85      -4.060 -38.119  13.370  1.00  0.00
ATOM   1358  HB2 ASN    85      -4.403 -37.118  11.968  1.00  0.00
ATOM   1359  CG  ASN    85      -5.617 -36.685  13.664  1.00  0.00
ATOM   1360  OD1 ASN    85      -6.453 -37.533  13.983  1.00  0.00
ATOM   1361  ND2 ASN    85      -5.859 -35.394  13.817  1.00  0.00
ATOM   1362 HD21 ASN    85      -5.182 -34.752  13.529  1.00  0.00
ATOM   1363 HD22 ASN    85      -6.711 -35.132  14.223  1.00  0.00
ATOM   1364  C   ASN    85      -1.755 -36.982  13.410  1.00  0.00
ATOM   1365  O   ASN    85      -1.404 -37.632  12.418  1.00  0.00
ATOM   1366  N   PHE    86      -1.007 -36.881  14.523  1.00  0.00
ATOM   1367  HN  PHE    86      -1.294 -36.250  15.215  1.00  0.00
ATOM   1368  CA  PHE    86       0.217 -37.682  14.766  1.00  0.00
ATOM   1369  HA  PHE    86       0.519 -38.136  13.820  1.00  0.00
ATOM   1370  CB  PHE    86       1.375 -36.779  15.290  1.00  0.00
ATOM   1371  HB1 PHE    86       2.135 -37.406  15.746  1.00  0.00
ATOM   1372  HB2 PHE    86       0.983 -36.113  16.047  1.00  0.00
ATOM   1373  CG  PHE    86       2.077 -35.904  14.242  1.00  0.00
ATOM   1374  CD1 PHE    86       3.156 -35.097  14.611  1.00  0.00
ATOM   1375  HD1 PHE    86       3.492 -35.097  15.642  1.00  0.00
ATOM   1376  CD2 PHE    86       1.674 -35.879  12.903  1.00  0.00
ATOM   1377  HD2 PHE    86       0.841 -36.492  12.584  1.00  0.00
ATOM   1378  CE1 PHE    86       3.798 -34.301  13.681  1.00  0.00
ATOM   1379  HE1 PHE    86       4.630 -33.680  13.983  1.00  0.00
ATOM   1380  CE2 PHE    86       2.321 -35.081  11.980  1.00  0.00
ATOM   1381  HE2 PHE    86       1.997 -35.076  10.951  1.00  0.00
ATOM   1382  CZ  PHE    86       3.381 -34.297  12.368  1.00  0.00
ATOM   1383  HZ  PHE    86       3.888 -33.670  11.641  1.00  0.00
ATOM   1384  C   PHE    86      -0.083 -38.813  15.772  1.00  0.00
ATOM   1385  O   PHE    86      -0.908 -38.631  16.671  1.00  0.00
ATOM   1386  N   PRO    87       0.586 -40.007  15.644  1.00  0.00
ATOM   1387  CA  PRO    87       0.304 -41.188  16.506  1.00  0.00
ATOM   1388  HA  PRO    87      -0.753 -41.430  16.487  1.00  0.00
ATOM   1389  CB  PRO    87       1.090 -42.324  15.810  1.00  0.00
ATOM   1390  HB1 PRO    87       0.450 -42.828  15.088  1.00  0.00
ATOM   1391  HB2 PRO    87       1.439 -43.050  16.538  1.00  0.00
ATOM   1392  CG  PRO    87       2.225 -41.625  15.135  1.00  0.00
ATOM   1393  HG1 PRO    87       2.594 -42.216  14.303  1.00  0.00
ATOM   1394  HG2 PRO    87       3.031 -41.449  15.847  1.00  0.00
ATOM   1395  CD  PRO    87       1.650 -40.316  14.643  1.00  0.00
ATOM   1396  HD1 PRO    87       1.221 -40.430  13.654  1.00  0.00
ATOM   1397  HD2 PRO    87       2.411 -39.543  14.634  1.00  0.00
ATOM   1398  C   PRO    87       0.735 -41.013  17.986  1.00  0.00
ATOM   1399  O   PRO    87       0.406 -41.861  18.826  1.00  0.00
ATOM   1400  N   GLU    88       1.487 -39.932  18.296  1.00  0.00
ATOM   1401  HN  GLU    88       1.811 -39.361  17.568  1.00  0.00
ATOM   1402  CA  GLU    88       1.846 -39.587  19.694  1.00  0.00
ATOM   1403  HA  GLU    88       1.801 -40.508  20.274  1.00  0.00
ATOM   1404  CB  GLU    88       3.298 -39.019  19.810  1.00  0.00
ATOM   1405  HB1 GLU    88       3.992 -39.824  19.590  1.00  0.00
ATOM   1406  HB2 GLU    88       3.468 -38.713  20.839  1.00  0.00
ATOM   1407  CG  GLU    88       3.637 -37.816  18.889  1.00  0.00
ATOM   1408  HG1 GLU    88       4.235 -37.099  19.455  1.00  0.00
ATOM   1409  HG2 GLU    88       2.711 -37.325  18.599  1.00  0.00
ATOM   1410  CD  GLU    88       4.401 -38.201  17.607  1.00  0.00
ATOM   1411  OE1 GLU    88       3.776 -38.731  16.671  1.00  0.00
ATOM   1412  OE2 GLU    88       5.635 -37.981  17.541  1.00  0.00
ATOM   1413  C   GLU    88       0.823 -38.610  20.322  1.00  0.00
ATOM   1414  O   GLU    88       0.815 -38.439  21.545  1.00  0.00
ATOM   1415  N   GLY    89      -0.036 -37.962  19.498  1.00  0.00
ATOM   1416  HN  GLY    89       0.070 -38.056  18.526  1.00  0.00
ATOM   1417  CA  GLY    89      -1.120 -37.115  20.036  1.00  0.00
ATOM   1418  HA1 GLY    89      -0.733 -36.528  20.864  1.00  0.00
ATOM   1419  HA2 GLY    89      -1.902 -37.760  20.417  1.00  0.00
ATOM   1420  C   GLY    89      -1.738 -36.173  19.008  1.00  0.00
ATOM   1421  O   GLY    89      -2.265 -36.634  17.995  1.00  0.00
ATOM   1422  N   LYS    90      -1.688 -34.849  19.296  1.00  0.00
ATOM   1423  HN  LYS    90      -1.292 -34.580  20.148  1.00  0.00
ATOM   1424  CA  LYS    90      -2.228 -33.784  18.429  1.00  0.00
ATOM   1425  HA  LYS    90      -3.308 -33.929  18.384  1.00  0.00
ATOM   1426  CB  LYS    90      -1.953 -32.399  19.091  1.00  0.00
ATOM   1427  HB1 LYS    90      -0.889 -32.329  19.303  1.00  0.00
ATOM   1428  HB2 LYS    90      -2.482 -32.361  20.036  1.00  0.00
ATOM   1429  CG  LYS    90      -2.358 -31.147  18.270  1.00  0.00
ATOM   1430  HG1 LYS    90      -1.761 -31.127  17.361  1.00  0.00
ATOM   1431  HG2 LYS    90      -2.120 -30.263  18.854  1.00  0.00
ATOM   1432  CD  LYS    90      -3.857 -31.081  17.883  1.00  0.00
ATOM   1433  HD1 LYS    90      -4.078 -31.901  17.205  1.00  0.00
ATOM   1434  HD2 LYS    90      -4.036 -30.146  17.364  1.00  0.00
ATOM   1435  CE  LYS    90      -4.812 -31.157  19.088  1.00  0.00
ATOM   1436  HE1 LYS    90      -4.460 -30.494  19.864  1.00  0.00
ATOM   1437  HE2 LYS    90      -4.825 -32.172  19.468  1.00  0.00
ATOM   1438  NZ  LYS    90      -6.199 -30.777  18.717  1.00  0.00
ATOM   1439  HZ1 LYS    90      -6.576 -31.434  18.006  1.00  0.00
ATOM   1440  HZ2 LYS    90      -6.210 -29.813  18.321  1.00  0.00
ATOM   1441  HZ3 LYS    90      -6.816 -30.796  19.553  1.00  0.00
ATOM   1442  C   LYS    90      -1.669 -33.871  16.986  1.00  0.00
ATOM   1443  O   LYS    90      -2.296 -34.497  16.132  1.00  0.00
ATOM   1444  N   GLY    91      -0.478 -33.289  16.736  1.00  0.00
ATOM   1445  HN  GLY    91       0.003 -32.854  17.467  1.00  0.00
ATOM   1446  CA  GLY    91       0.113 -33.291  15.396  1.00  0.00
ATOM   1447  HA1 GLY    91      -0.475 -33.914  14.730  1.00  0.00
ATOM   1448  HA2 GLY    91       1.103 -33.721  15.472  1.00  0.00
ATOM   1449  C   GLY    91       0.249 -31.907  14.791  1.00  0.00
ATOM   1450  O   GLY    91       0.259 -31.760  13.567  1.00  0.00
ATOM   1451  N   GLU    92       0.402 -30.891  15.643  1.00  0.00
ATOM   1452  HN  GLU    92       0.538 -31.090  16.594  1.00  0.00
ATOM   1453  CA  GLU    92       0.411 -29.488  15.201  1.00  0.00
ATOM   1454  HA  GLU    92      -0.198 -29.405  14.301  1.00  0.00
ATOM   1455  CB  GLU    92      -0.210 -28.587  16.309  1.00  0.00
ATOM   1456  HB1 GLU    92      -1.247 -28.882  16.459  1.00  0.00
ATOM   1457  HB2 GLU    92      -0.200 -27.559  15.966  1.00  0.00
ATOM   1458  CG  GLU    92       0.511 -28.654  17.679  1.00  0.00
ATOM   1459  HG1 GLU    92       1.559 -28.392  17.534  1.00  0.00
ATOM   1460  HG2 GLU    92       0.465 -29.680  18.035  1.00  0.00
ATOM   1461  CD  GLU    92      -0.076 -27.730  18.754  1.00  0.00
ATOM   1462  OE1 GLU    92      -0.596 -28.231  19.775  1.00  0.00
ATOM   1463  OE2 GLU    92       0.010 -26.494  18.591  1.00  0.00
ATOM   1464  C   GLU    92       1.855 -29.069  14.862  1.00  0.00
ATOM   1465  O   GLU    92       2.758 -29.163  15.701  1.00  0.00
ATOM   1466  N   VAL    93       2.091 -28.670  13.592  1.00  0.00
ATOM   1467  HN  VAL    93       1.333 -28.599  12.963  1.00  0.00
ATOM   1468  CA  VAL    93       3.437 -28.330  13.109  1.00  0.00
ATOM   1469  HA  VAL    93       4.136 -28.473  13.938  1.00  0.00
ATOM   1470  CB  VAL    93       3.893 -29.287  11.940  1.00  0.00
ATOM   1471  HB  VAL    93       4.913 -29.019  11.665  1.00  0.00
ATOM   1472  CG1 VAL    93       3.922 -30.751  12.432  1.00  0.00
ATOM   1473 HG11 VAL    93       2.920 -31.068  12.705  1.00  0.00
ATOM   1474 HG12 VAL    93       4.560 -30.833  13.302  1.00  0.00
ATOM   1475 HG13 VAL    93       4.300 -31.398  11.653  1.00  0.00
ATOM   1476  CG2 VAL    93       3.006 -29.154  10.680  1.00  0.00
ATOM   1477 HG21 VAL    93       1.980 -29.407  10.925  1.00  0.00
ATOM   1478 HG22 VAL    93       3.360 -29.821   9.903  1.00  0.00
ATOM   1479 HG23 VAL    93       3.042 -28.135  10.314  1.00  0.00
ATOM   1480  C   VAL    93       3.493 -26.853  12.707  1.00  0.00
ATOM   1481  O   VAL    93       2.693 -26.383  11.896  1.00  0.00
ATOM   1482  N   ASP    94       4.421 -26.119  13.325  1.00  0.00
ATOM   1483  HN  ASP    94       5.019 -26.570  13.963  1.00  0.00
ATOM   1484  CA  ASP    94       4.590 -24.676  13.099  1.00  0.00
ATOM   1485  HA  ASP    94       3.610 -24.233  12.925  1.00  0.00
ATOM   1486  CB  ASP    94       5.220 -24.007  14.345  1.00  0.00
ATOM   1487  HB1 ASP    94       5.388 -22.954  14.128  1.00  0.00
ATOM   1488  HB2 ASP    94       6.183 -24.469  14.550  1.00  0.00
ATOM   1489  CG  ASP    94       4.342 -24.122  15.607  1.00  0.00
ATOM   1490  OD1 ASP    94       4.199 -25.244  16.141  1.00  0.00
ATOM   1491  OD2 ASP    94       3.815 -23.093  16.083  1.00  0.00
ATOM   1492  C   ASP    94       5.467 -24.462  11.857  1.00  0.00
ATOM   1493  O   ASP    94       6.667 -24.705  11.899  1.00  0.00
ATOM   1494  N   VAL    95       4.844 -24.006  10.764  1.00  0.00
ATOM   1495  HN  VAL    95       3.900 -23.767  10.842  1.00  0.00
ATOM   1496  CA  VAL    95       5.474 -23.850   9.440  1.00  0.00
ATOM   1497  HA  VAL    95       6.475 -24.278   9.461  1.00  0.00
ATOM   1498  CB  VAL    95       4.616 -24.600   8.339  1.00  0.00
ATOM   1499  HB  VAL    95       3.704 -24.046   8.214  1.00  0.00
ATOM   1500  CG1 VAL    95       5.309 -24.625   6.956  1.00  0.00
ATOM   1501 HG11 VAL    95       5.489 -23.609   6.618  1.00  0.00
ATOM   1502 HG12 VAL    95       4.680 -25.130   6.235  1.00  0.00
ATOM   1503 HG13 VAL    95       6.254 -25.146   7.033  1.00  0.00
ATOM   1504  CG2 VAL    95       4.215 -26.020   8.799  1.00  0.00
ATOM   1505 HG21 VAL    95       3.629 -25.959   9.713  1.00  0.00
ATOM   1506 HG22 VAL    95       5.102 -26.609   8.986  1.00  0.00
ATOM   1507 HG23 VAL    95       3.621 -26.503   8.031  1.00  0.00
ATOM   1508  C   VAL    95       5.557 -22.353   9.085  1.00  0.00
ATOM   1509  O   VAL    95       4.736 -21.559   9.544  1.00  0.00
ATOM   1510  N   ALA    96       6.583 -21.973   8.314  1.00  0.00
ATOM   1511  HN  ALA    96       7.309 -22.602   8.168  1.00  0.00
ATOM   1512  CA  ALA    96       6.671 -20.654   7.672  1.00  0.00
ATOM   1513  HA  ALA    96       5.835 -20.037   8.010  1.00  0.00
ATOM   1514  CB  ALA    96       7.980 -19.942   8.058  1.00  0.00
ATOM   1515  HB1 ALA    96       8.015 -19.803   9.132  1.00  0.00
ATOM   1516  HB2 ALA    96       8.025 -18.974   7.577  1.00  0.00
ATOM   1517  HB3 ALA    96       8.833 -20.535   7.748  1.00  0.00
ATOM   1518  C   ALA    96       6.565 -20.844   6.153  1.00  0.00
ATOM   1519  O   ALA    96       7.519 -21.300   5.508  1.00  0.00
ATOM   1520  N   CYS    97       5.387 -20.537   5.597  1.00  0.00
ATOM   1521  HN  CYS    97       4.653 -20.258   6.180  1.00  0.00
ATOM   1522  CA  CYS    97       5.136 -20.600   4.158  1.00  0.00
ATOM   1523  HA  CYS    97       5.833 -21.314   3.713  1.00  0.00
ATOM   1524  CB  CYS    97       3.695 -21.078   3.890  1.00  0.00
ATOM   1525  HB1 CYS    97       3.517 -21.101   2.822  1.00  0.00
ATOM   1526  HB2 CYS    97       2.997 -20.395   4.352  1.00  0.00
ATOM   1527  SG  CYS    97       3.345 -22.732   4.533  1.00  0.00
ATOM   1528  HG  CYS    97       2.775 -22.594   5.722  1.00  0.00
ATOM   1529  C   CYS    97       5.387 -19.209   3.562  1.00  0.00
ATOM   1530  O   CYS    97       4.641 -18.262   3.822  1.00  0.00
ATOM   1531  N   ILE    98       6.480 -19.101   2.804  1.00  0.00
ATOM   1532  HN  ILE    98       7.002 -19.913   2.642  1.00  0.00
ATOM   1533  CA  ILE    98       6.934 -17.849   2.180  1.00  0.00
ATOM   1534  HA  ILE    98       6.455 -17.017   2.702  1.00  0.00
ATOM   1535  CB  ILE    98       8.501 -17.678   2.336  1.00  0.00
ATOM   1536  HB  ILE    98       8.687 -17.488   3.387  1.00  0.00
ATOM   1537  CG1 ILE    98       9.025 -16.440   1.527  1.00  0.00
ATOM   1538 HG11 ILE    98       8.550 -15.545   1.910  1.00  0.00
ATOM   1539 HG12 ILE    98       8.756 -16.554   0.485  1.00  0.00
ATOM   1540  CG2 ILE    98       9.270 -18.977   1.998  1.00  0.00
ATOM   1541 HG21 ILE    98      10.334 -18.829   2.137  1.00  0.00
ATOM   1542 HG22 ILE    98       9.081 -19.261   0.972  1.00  0.00
ATOM   1543 HG23 ILE    98       8.935 -19.778   2.650  1.00  0.00
ATOM   1544  CD1 ILE    98      10.530 -16.210   1.574  1.00  0.00
ATOM   1545 HD11 ILE    98      11.047 -17.061   1.148  1.00  0.00
ATOM   1546 HD12 ILE    98      10.849 -16.068   2.596  1.00  0.00
ATOM   1547 HD13 ILE    98      10.770 -15.325   1.000  1.00  0.00
ATOM   1548  C   ILE    98       6.500 -17.817   0.702  1.00  0.00
ATOM   1549  O   ILE    98       6.639 -18.801  -0.012  1.00  0.00
ATOM   1550  N   TYR    99       5.959 -16.675   0.255  1.00  0.00
ATOM   1551  HN  TYR    99       5.921 -15.917   0.861  1.00  0.00
ATOM   1552  CA  TYR    99       5.429 -16.498  -1.110  1.00  0.00
ATOM   1553  HA  TYR    99       5.624 -17.406  -1.680  1.00  0.00
ATOM   1554  CB  TYR    99       3.895 -16.233  -1.087  1.00  0.00
ATOM   1555  HB1 TYR    99       3.512 -16.290  -2.104  1.00  0.00
ATOM   1556  HB2 TYR    99       3.708 -15.233  -0.706  1.00  0.00
ATOM   1557  CG  TYR    99       3.089 -17.221  -0.227  1.00  0.00
ATOM   1558  CD1 TYR    99       2.606 -18.425  -0.749  1.00  0.00
ATOM   1559  HD1 TYR    99       2.793 -18.660  -1.787  1.00  0.00
ATOM   1560  CD2 TYR    99       2.826 -16.947   1.118  1.00  0.00
ATOM   1561  HD2 TYR    99       3.189 -16.020   1.550  1.00  0.00
ATOM   1562  CE1 TYR    99       1.893 -19.310   0.036  1.00  0.00
ATOM   1563  HE1 TYR    99       1.530 -20.238  -0.389  1.00  0.00
ATOM   1564  CE2 TYR    99       2.112 -17.830   1.902  1.00  0.00
ATOM   1565  HE2 TYR    99       1.922 -17.591   2.943  1.00  0.00
ATOM   1566  CZ  TYR    99       1.647 -19.007   1.361  1.00  0.00
ATOM   1567  OH  TYR    99       0.941 -19.891   2.150  1.00  0.00
ATOM   1568  HH  TYR    99       0.481 -19.401   2.843  1.00  0.00
ATOM   1569  C   TYR    99       6.133 -15.323  -1.793  1.00  0.00
ATOM   1570  O   TYR    99       6.636 -14.416  -1.131  1.00  0.00
ATOM   1571  N   GLU   100       6.140 -15.362  -3.120  1.00  0.00
ATOM   1572  HN  GLU   100       5.799 -16.168  -3.552  1.00  0.00
ATOM   1573  CA  GLU   100       6.635 -14.292  -3.986  1.00  0.00
ATOM   1574  HA  GLU   100       6.837 -13.403  -3.389  1.00  0.00
ATOM   1575  CB  GLU   100       7.924 -14.756  -4.689  1.00  0.00
ATOM   1576  HB1 GLU   100       7.710 -15.675  -5.228  1.00  0.00
ATOM   1577  HB2 GLU   100       8.666 -14.976  -3.929  1.00  0.00
ATOM   1578  CG  GLU   100       8.539 -13.747  -5.672  1.00  0.00
ATOM   1579  HG1 GLU   100       9.022 -12.957  -5.104  1.00  0.00
ATOM   1580  HG2 GLU   100       7.746 -13.305  -6.273  1.00  0.00
ATOM   1581  CD  GLU   100       9.573 -14.401  -6.605  1.00  0.00
ATOM   1582  OE1 GLU   100      10.791 -14.386  -6.294  1.00  0.00
ATOM   1583  OE2 GLU   100       9.166 -14.934  -7.661  1.00  0.00
ATOM   1584  C   GLU   100       5.548 -13.992  -5.020  1.00  0.00
ATOM   1585  O   GLU   100       5.161 -14.879  -5.779  1.00  0.00
ATOM   1586  N   VAL   101       5.052 -12.755  -5.023  1.00  0.00
ATOM   1587  HN  VAL   101       5.439 -12.110  -4.407  1.00  0.00
ATOM   1588  CA  VAL   101       3.972 -12.303  -5.902  1.00  0.00
ATOM   1589  HA  VAL   101       3.516 -13.172  -6.376  1.00  0.00
ATOM   1590  CB  VAL   101       2.862 -11.562  -5.069  1.00  0.00
ATOM   1591  HB  VAL   101       3.329 -10.703  -4.590  1.00  0.00
ATOM   1592  CG1 VAL   101       1.715 -11.036  -5.970  1.00  0.00
ATOM   1593 HG11 VAL   101       1.243 -11.864  -6.486  1.00  0.00
ATOM   1594 HG12 VAL   101       2.108 -10.340  -6.704  1.00  0.00
ATOM   1595 HG13 VAL   101       0.975 -10.526  -5.364  1.00  0.00
ATOM   1596  CG2 VAL   101       2.309 -12.478  -3.948  1.00  0.00
ATOM   1597 HG21 VAL   101       1.829 -13.343  -4.391  1.00  0.00
ATOM   1598 HG22 VAL   101       1.583 -11.934  -3.354  1.00  0.00
ATOM   1599 HG23 VAL   101       3.117 -12.808  -3.305  1.00  0.00
ATOM   1600  C   VAL   101       4.542 -11.376  -6.989  1.00  0.00
ATOM   1601  O   VAL   101       5.094 -10.313  -6.680  1.00  0.00
ATOM   1602  N   GLU   102       4.414 -11.797  -8.255  1.00  0.00
ATOM   1603  HN  GLU   102       4.015 -12.676  -8.413  1.00  0.00
ATOM   1604  CA  GLU   102       4.833 -11.014  -9.426  1.00  0.00
ATOM   1605  HA  GLU   102       5.103 -10.015  -9.088  1.00  0.00
ATOM   1606  CB  GLU   102       6.062 -11.670 -10.097  1.00  0.00
ATOM   1607  HB1 GLU   102       5.778 -12.660 -10.438  1.00  0.00
ATOM   1608  HB2 GLU   102       6.847 -11.774  -9.356  1.00  0.00
ATOM   1609  CG  GLU   102       6.631 -10.893 -11.295  1.00  0.00
ATOM   1610  HG1 GLU   102       6.831  -9.871 -10.984  1.00  0.00
ATOM   1611  HG2 GLU   102       5.880 -10.874 -12.075  1.00  0.00
ATOM   1612  CD  GLU   102       7.921 -11.503 -11.871  1.00  0.00
ATOM   1613  OE1 GLU   102       7.840 -12.466 -12.663  1.00  0.00
ATOM   1614  OE2 GLU   102       9.026 -11.036 -11.517  1.00  0.00
ATOM   1615  C   GLU   102       3.654 -10.904 -10.411  1.00  0.00
ATOM   1616  O   GLU   102       2.986 -11.901 -10.698  1.00  0.00
ATOM   1617  N   ASN   103       3.415  -9.671 -10.900  1.00  0.00
ATOM   1618  HN  ASN   103       4.039  -8.959 -10.649  1.00  0.00
ATOM   1619  CA  ASN   103       2.282  -9.312 -11.789  1.00  0.00
ATOM   1620  HA  ASN   103       2.366  -8.247 -11.968  1.00  0.00
ATOM   1621  CB  ASN   103       2.369 -10.049 -13.169  1.00  0.00
ATOM   1622  HB1 ASN   103       1.503  -9.781 -13.766  1.00  0.00
ATOM   1623  HB2 ASN   103       2.346 -11.118 -12.998  1.00  0.00
ATOM   1624  CG  ASN   103       3.638  -9.702 -13.971  1.00  0.00
ATOM   1625  OD1 ASN   103       3.676  -8.714 -14.704  1.00  0.00
ATOM   1626  ND2 ASN   103       4.669 -10.528 -13.866  1.00  0.00
ATOM   1627 HD21 ASN   103       4.576 -11.319 -13.290  1.00  0.00
ATOM   1628 HD22 ASN   103       5.485 -10.318 -14.365  1.00  0.00
ATOM   1629  C   ASN   103       0.907  -9.560 -11.102  1.00  0.00
ATOM   1630  O   ASN   103      -0.110  -9.771 -11.776  1.00  0.00
ATOM   1631  N   GLY   104       0.884  -9.459  -9.754  1.00  0.00
ATOM   1632  HN  GLY   104       1.727  -9.269  -9.290  1.00  0.00
ATOM   1633  CA  GLY   104      -0.350  -9.611  -8.961  1.00  0.00
ATOM   1634  HA1 GLY   104      -1.184  -9.203  -9.520  1.00  0.00
ATOM   1635  HA2 GLY   104      -0.237  -9.035  -8.053  1.00  0.00
ATOM   1636  C   GLY   104      -0.682 -11.057  -8.573  1.00  0.00
ATOM   1637  O   GLY   104      -1.597 -11.294  -7.775  1.00  0.00
ATOM   1638  N   ARG   105       0.078 -12.022  -9.117  1.00  0.00
ATOM   1639  HN  ARG   105       0.847 -11.758  -9.666  1.00  0.00
ATOM   1640  CA  ARG   105      -0.132 -13.466  -8.876  1.00  0.00
ATOM   1641  HA  ARG   105      -0.949 -13.597  -8.168  1.00  0.00
ATOM   1642  CB  ARG   105      -0.469 -14.204 -10.201  1.00  0.00
ATOM   1643  HB1 ARG   105      -0.617 -15.260  -9.986  1.00  0.00
ATOM   1644  HB2 ARG   105       0.373 -14.106 -10.876  1.00  0.00
ATOM   1645  CG  ARG   105      -1.723 -13.684 -10.940  1.00  0.00
ATOM   1646  HG1 ARG   105      -1.778 -14.170 -11.911  1.00  0.00
ATOM   1647  HG2 ARG   105      -1.617 -12.616 -11.093  1.00  0.00
ATOM   1648  CD  ARG   105      -3.043 -13.942 -10.190  1.00  0.00
ATOM   1649  HD1 ARG   105      -2.951 -13.596  -9.168  1.00  0.00
ATOM   1650  HD2 ARG   105      -3.248 -15.009 -10.193  1.00  0.00
ATOM   1651  NE  ARG   105      -4.156 -13.215 -10.838  1.00  0.00
ATOM   1652  HE  ARG   105      -3.928 -12.348 -11.233  1.00  0.00
ATOM   1653  CZ  ARG   105      -5.432 -13.615 -10.931  1.00  0.00
ATOM   1654  NH1 ARG   105      -5.830 -14.779 -10.457  1.00  0.00
ATOM   1655 HH11 ARG   105      -5.176 -15.394 -10.017  1.00  0.00
ATOM   1656 HH12 ARG   105      -6.792 -15.061 -10.546  1.00  0.00
ATOM   1657  NH2 ARG   105      -6.311 -12.827 -11.526  1.00  0.00
ATOM   1658 HH21 ARG   105      -6.021 -11.944 -11.902  1.00  0.00
ATOM   1659 HH22 ARG   105      -7.269 -13.112 -11.617  1.00  0.00
ATOM   1660  C   ARG   105       1.146 -14.039  -8.272  1.00  0.00
ATOM   1661  O   ARG   105       2.232 -13.543  -8.565  1.00  0.00
ATOM   1662  N   ILE   106       1.022 -15.070  -7.430  1.00  0.00
ATOM   1663  HN  ILE   106       0.127 -15.399  -7.216  1.00  0.00
ATOM   1664  CA  ILE   106       2.186 -15.718  -6.820  1.00  0.00
ATOM   1665  HA  ILE   106       2.800 -14.933  -6.371  1.00  0.00
ATOM   1666  CB  ILE   106       1.775 -16.720  -5.683  1.00  0.00
ATOM   1667  HB  ILE   106       1.107 -17.458  -6.117  1.00  0.00
ATOM   1668  CG1 ILE   106       1.012 -15.962  -4.557  1.00  0.00
ATOM   1669 HG11 ILE   106       0.097 -15.544  -4.965  1.00  0.00
ATOM   1670 HG12 ILE   106       1.631 -15.156  -4.189  1.00  0.00
ATOM   1671  CG2 ILE   106       3.001 -17.477  -5.105  1.00  0.00
ATOM   1672 HG21 ILE   106       3.696 -16.769  -4.671  1.00  0.00
ATOM   1673 HG22 ILE   106       3.498 -18.025  -5.896  1.00  0.00
ATOM   1674 HG23 ILE   106       2.677 -18.174  -4.342  1.00  0.00
ATOM   1675  CD1 ILE   106       0.637 -16.813  -3.369  1.00  0.00
ATOM   1676 HD11 ILE   106       0.046 -17.658  -3.701  1.00  0.00
ATOM   1677 HD12 ILE   106       0.058 -16.222  -2.674  1.00  0.00
ATOM   1678 HD13 ILE   106       1.531 -17.170  -2.877  1.00  0.00
ATOM   1679  C   ILE   106       3.015 -16.423  -7.904  1.00  0.00
ATOM   1680  O   ILE   106       2.582 -17.414  -8.479  1.00  0.00
ATOM   1681  N   ALA   107       4.199 -15.862  -8.177  1.00  0.00
ATOM   1682  HN  ALA   107       4.455 -15.062  -7.676  1.00  0.00
ATOM   1683  CA  ALA   107       5.130 -16.371  -9.187  1.00  0.00
ATOM   1684  HA  ALA   107       4.568 -16.617 -10.084  1.00  0.00
ATOM   1685  CB  ALA   107       6.154 -15.279  -9.543  1.00  0.00
ATOM   1686  HB1 ALA   107       5.640 -14.397  -9.917  1.00  0.00
ATOM   1687  HB2 ALA   107       6.832 -15.640 -10.305  1.00  0.00
ATOM   1688  HB3 ALA   107       6.723 -15.006  -8.660  1.00  0.00
ATOM   1689  C   ALA   107       5.851 -17.624  -8.674  1.00  0.00
ATOM   1690  O   ALA   107       6.074 -18.580  -9.430  1.00  0.00
ATOM   1691  N   LYS   108       6.194 -17.607  -7.375  1.00  0.00
ATOM   1692  HN  LYS   108       5.915 -16.832  -6.831  1.00  0.00
ATOM   1693  CA  LYS   108       6.942 -18.685  -6.701  1.00  0.00
ATOM   1694  HA  LYS   108       6.708 -19.631  -7.187  1.00  0.00
ATOM   1695  CB  LYS   108       8.472 -18.426  -6.773  1.00  0.00
ATOM   1696  HB1 LYS   108       8.980 -19.140  -6.128  1.00  0.00
ATOM   1697  HB2 LYS   108       8.670 -17.427  -6.397  1.00  0.00
ATOM   1698  CG  LYS   108       9.079 -18.538  -8.184  1.00  0.00
ATOM   1699  HG1 LYS   108       8.475 -17.946  -8.865  1.00  0.00
ATOM   1700  HG2 LYS   108       9.045 -19.574  -8.498  1.00  0.00
ATOM   1701  CD  LYS   108      10.537 -18.048  -8.262  1.00  0.00
ATOM   1702  HD1 LYS   108      11.166 -18.699  -7.662  1.00  0.00
ATOM   1703  HD2 LYS   108      10.592 -17.037  -7.867  1.00  0.00
ATOM   1704  CE  LYS   108      11.059 -18.041  -9.707  1.00  0.00
ATOM   1705  HE1 LYS   108      10.418 -17.410 -10.314  1.00  0.00
ATOM   1706  HE2 LYS   108      11.037 -19.050 -10.101  1.00  0.00
ATOM   1707  NZ  LYS   108      12.447 -17.533  -9.804  1.00  0.00
ATOM   1708  HZ1 LYS   108      12.491 -16.547  -9.472  1.00  0.00
ATOM   1709  HZ2 LYS   108      12.773 -17.570 -10.790  1.00  0.00
ATOM   1710  HZ3 LYS   108      13.078 -18.110  -9.219  1.00  0.00
ATOM   1711  C   LYS   108       6.513 -18.750  -5.239  1.00  0.00
ATOM   1712  O   LYS   108       6.220 -17.721  -4.642  1.00  0.00
ATOM   1713  N   ALA   109       6.502 -19.953  -4.665  1.00  0.00
ATOM   1714  HN  ALA   109       6.737 -20.734  -5.208  1.00  0.00
ATOM   1715  CA  ALA   109       6.172 -20.164  -3.255  1.00  0.00
ATOM   1716  HA  ALA   109       6.435 -19.255  -2.705  1.00  0.00
ATOM   1717  CB  ALA   109       4.675 -20.420  -3.061  1.00  0.00
ATOM   1718  HB1 ALA   109       4.110 -19.584  -3.452  1.00  0.00
ATOM   1719  HB2 ALA   109       4.451 -20.530  -2.004  1.00  0.00
ATOM   1720  HB3 ALA   109       4.380 -21.325  -3.582  1.00  0.00
ATOM   1721  C   ALA   109       6.998 -21.320  -2.707  1.00  0.00
ATOM   1722  O   ALA   109       7.227 -22.318  -3.385  1.00  0.00
ATOM   1723  N   TRP   110       7.465 -21.142  -1.486  1.00  0.00
ATOM   1724  HN  TRP   110       7.229 -20.320  -1.027  1.00  0.00
ATOM   1725  CA  TRP   110       8.314 -22.088  -0.766  1.00  0.00
ATOM   1726  HA  TRP   110       8.312 -23.046  -1.280  1.00  0.00
ATOM   1727  CB  TRP   110       9.773 -21.523  -0.680  1.00  0.00
ATOM   1728  HB1 TRP   110      10.456 -22.341  -0.472  1.00  0.00
ATOM   1729  HB2 TRP   110       9.837 -20.806   0.130  1.00  0.00
ATOM   1730  CG  TRP   110      10.254 -20.819  -1.942  1.00  0.00
ATOM   1731  CD1 TRP   110      10.829 -21.392  -3.027  1.00  0.00
ATOM   1732  HD1 TRP   110      11.029 -22.441  -3.116  1.00  0.00
ATOM   1733  CD2 TRP   110      10.173 -19.414  -2.249  1.00  0.00
ATOM   1734  NE1 TRP   110      11.114 -20.458  -3.978  1.00  0.00
ATOM   1735  HE1 TRP   110      11.535 -20.638  -4.845  1.00  0.00
ATOM   1736  CE2 TRP   110      10.722 -19.236  -3.527  1.00  0.00
ATOM   1737  CE3 TRP   110       9.684 -18.298  -1.572  1.00  0.00
ATOM   1738  HE3 TRP   110       9.250 -18.392  -0.588  1.00  0.00
ATOM   1739  CZ2 TRP   110      10.812 -17.991  -4.134  1.00  0.00
ATOM   1740  HZ2 TRP   110      11.239 -17.864  -5.121  1.00  0.00
ATOM   1741  CZ3 TRP   110       9.770 -17.060  -2.173  1.00  0.00
ATOM   1742  HZ3 TRP   110       9.399 -16.182  -1.657  1.00  0.00
ATOM   1743  CH2 TRP   110      10.328 -16.917  -3.446  1.00  0.00
ATOM   1744  HH2 TRP   110      10.376 -15.926  -3.883  1.00  0.00
ATOM   1745  C   TRP   110       7.708 -22.259   0.635  1.00  0.00
ATOM   1746  O   TRP   110       6.983 -21.371   1.105  1.00  0.00
ATOM   1747  N   PHE   111       7.969 -23.381   1.302  1.00  0.00
ATOM   1748  HN  PHE   111       8.426 -24.118   0.848  1.00  0.00
ATOM   1749  CA  PHE   111       7.574 -23.541   2.713  1.00  0.00
ATOM   1750  HA  PHE   111       7.517 -22.541   3.155  1.00  0.00
ATOM   1751  CB  PHE   111       6.172 -24.216   2.858  1.00  0.00
ATOM   1752  HB1 PHE   111       5.495 -23.767   2.137  1.00  0.00
ATOM   1753  HB2 PHE   111       5.784 -24.007   3.851  1.00  0.00
ATOM   1754  CG  PHE   111       6.127 -25.733   2.651  1.00  0.00
ATOM   1755  CD1 PHE   111       6.113 -26.601   3.748  1.00  0.00
ATOM   1756  HD1 PHE   111       6.134 -26.191   4.750  1.00  0.00
ATOM   1757  CD2 PHE   111       6.102 -26.292   1.375  1.00  0.00
ATOM   1758  HD2 PHE   111       6.113 -25.645   0.507  1.00  0.00
ATOM   1759  CE1 PHE   111       6.072 -27.967   3.576  1.00  0.00
ATOM   1760  HE1 PHE   111       6.066 -28.618   4.446  1.00  0.00
ATOM   1761  CE2 PHE   111       6.058 -27.666   1.203  1.00  0.00
ATOM   1762  HE2 PHE   111       6.036 -28.085   0.203  1.00  0.00
ATOM   1763  CZ  PHE   111       6.044 -28.503   2.302  1.00  0.00
ATOM   1764  HZ  PHE   111       6.010 -29.578   2.166  1.00  0.00
ATOM   1765  C   PHE   111       8.658 -24.311   3.463  1.00  0.00
ATOM   1766  O   PHE   111       9.311 -25.203   2.897  1.00  0.00
ATOM   1767  N   LYS   112       8.853 -23.944   4.733  1.00  0.00
ATOM   1768  HN  LYS   112       8.345 -23.179   5.081  1.00  0.00
ATOM   1769  CA  LYS   112       9.775 -24.624   5.639  1.00  0.00
ATOM   1770  HA  LYS   112      10.080 -25.557   5.172  1.00  0.00
ATOM   1771  CB  LYS   112      11.048 -23.763   5.904  1.00  0.00
ATOM   1772  HB1 LYS   112      11.567 -23.625   4.959  1.00  0.00
ATOM   1773  HB2 LYS   112      11.705 -24.320   6.568  1.00  0.00
ATOM   1774  CG  LYS   112      10.812 -22.366   6.527  1.00  0.00
ATOM   1775  HG1 LYS   112      10.194 -22.481   7.412  1.00  0.00
ATOM   1776  HG2 LYS   112      10.289 -21.745   5.807  1.00  0.00
ATOM   1777  CD  LYS   112      12.137 -21.673   6.926  1.00  0.00
ATOM   1778  HD1 LYS   112      12.744 -21.538   6.035  1.00  0.00
ATOM   1779  HD2 LYS   112      12.672 -22.314   7.619  1.00  0.00
ATOM   1780  CE  LYS   112      11.934 -20.306   7.597  1.00  0.00
ATOM   1781  HE1 LYS   112      11.281 -20.419   8.454  1.00  0.00
ATOM   1782  HE2 LYS   112      11.476 -19.624   6.889  1.00  0.00
ATOM   1783  NZ  LYS   112      13.224 -19.721   8.052  1.00  0.00
ATOM   1784  HZ1 LYS   112      13.667 -20.339   8.762  1.00  0.00
ATOM   1785  HZ2 LYS   112      13.065 -18.784   8.468  1.00  0.00
ATOM   1786  HZ3 LYS   112      13.871 -19.623   7.246  1.00  0.00
ATOM   1787  C   LYS   112       9.041 -24.961   6.939  1.00  0.00
ATOM   1788  O   LYS   112       8.473 -24.080   7.585  1.00  0.00
ATOM   1789  N   ILE   113       9.040 -26.250   7.322  1.00  0.00
ATOM   1790  HN  ILE   113       9.508 -26.906   6.774  1.00  0.00
ATOM   1791  CA  ILE   113       8.370 -26.703   8.547  1.00  0.00
ATOM   1792  HA  ILE   113       7.521 -26.041   8.731  1.00  0.00
ATOM   1793  CB  ILE   113       7.816 -28.165   8.418  1.00  0.00
ATOM   1794  HB  ILE   113       8.638 -28.807   8.123  1.00  0.00
ATOM   1795  CG1 ILE   113       6.712 -28.224   7.318  1.00  0.00
ATOM   1796 HG11 ILE   113       7.049 -27.713   6.424  1.00  0.00
ATOM   1797 HG12 ILE   113       5.829 -27.716   7.680  1.00  0.00
ATOM   1798  CG2 ILE   113       7.259 -28.692   9.777  1.00  0.00
ATOM   1799 HG21 ILE   113       6.885 -29.702   9.653  1.00  0.00
ATOM   1800 HG22 ILE   113       6.450 -28.056  10.113  1.00  0.00
ATOM   1801 HG23 ILE   113       8.045 -28.690  10.523  1.00  0.00
ATOM   1802  CD1 ILE   113       6.289 -29.624   6.937  1.00  0.00
ATOM   1803 HD11 ILE   113       7.147 -30.184   6.587  1.00  0.00
ATOM   1804 HD12 ILE   113       5.550 -29.574   6.153  1.00  0.00
ATOM   1805 HD13 ILE   113       5.865 -30.117   7.799  1.00  0.00
ATOM   1806  C   ILE   113       9.363 -26.597   9.707  1.00  0.00
ATOM   1807  O   ILE   113      10.473 -27.147   9.642  1.00  0.00
ATOM   1808  N   GLY   114       8.949 -25.855  10.735  1.00  0.00
ATOM   1809  HN  GLY   114       8.035 -25.487  10.695  1.00  0.00
ATOM   1810  CA  GLY   114       9.788 -25.579  11.902  1.00  0.00
ATOM   1811  HA1 GLY   114       9.270 -24.872  12.536  1.00  0.00
ATOM   1812  HA2 GLY   114      10.716 -25.124  11.570  1.00  0.00
ATOM   1813  C   GLY   114      10.096 -26.827  12.718  1.00  0.00
ATOM   1814  O   GLY   114      11.252 -27.278  12.764  1.00  0.00
ATOM   1815  N   GLU   115       9.053 -27.397  13.343  1.00  0.00
ATOM   1816  HN  GLU   115       8.162 -26.994  13.241  1.00  0.00
ATOM   1817  CA  GLU   115       9.172 -28.619  14.151  1.00  0.00
ATOM   1818  HA  GLU   115       9.852 -29.295  13.644  1.00  0.00
ATOM   1819  CB  GLU   115       9.728 -28.287  15.575  1.00  0.00
ATOM   1820  HB1 GLU   115      10.550 -27.585  15.476  1.00  0.00
ATOM   1821  HB2 GLU   115      10.109 -29.202  16.018  1.00  0.00
ATOM   1822  CG  GLU   115       8.686 -27.683  16.540  1.00  0.00
ATOM   1823  HG1 GLU   115       7.840 -28.377  16.594  1.00  0.00
ATOM   1824  HG2 GLU   115       8.331 -26.745  16.126  1.00  0.00
ATOM   1825  CD  GLU   115       9.222 -27.446  17.960  1.00  0.00
ATOM   1826  OE1 GLU   115       9.196 -28.387  18.779  1.00  0.00
ATOM   1827  OE2 GLU   115       9.645 -26.314  18.276  1.00  0.00
ATOM   1828  C   GLU   115       7.789 -29.299  14.272  1.00  0.00
ATOM   1829  O   GLU   115       6.761 -28.666  13.976  1.00  0.00
ATOM   1830  N   PRO   116       7.741 -30.602  14.687  1.00  0.00
ATOM   1831  CA  PRO   116       6.494 -31.239  15.173  1.00  0.00
ATOM   1832  HA  PRO   116       5.641 -30.943  14.576  1.00  0.00
ATOM   1833  CB  PRO   116       6.790 -32.733  14.950  1.00  0.00
ATOM   1834  HB1 PRO   116       6.506 -32.996  13.942  1.00  0.00
ATOM   1835  HB2 PRO   116       6.227 -33.346  15.649  1.00  0.00
ATOM   1836  CG  PRO   116       8.272 -32.873  15.146  1.00  0.00
ATOM   1837  HG1 PRO   116       8.648 -33.718  14.577  1.00  0.00
ATOM   1838  HG2 PRO   116       8.494 -33.012  16.201  1.00  0.00
ATOM   1839  CD  PRO   116       8.876 -31.579  14.638  1.00  0.00
ATOM   1840  HD1 PRO   116       9.233 -31.695  13.621  1.00  0.00
ATOM   1841  HD2 PRO   116       9.687 -31.253  15.282  1.00  0.00
ATOM   1842  C   PRO   116       6.206 -30.918  16.661  1.00  0.00
ATOM   1843  O   PRO   116       7.129 -30.919  17.488  1.00  0.00
ATOM   1844  N   ARG   117       4.924 -30.616  16.993  1.00  0.00
ATOM   1845  HN  ARG   117       4.262 -30.532  16.275  1.00  0.00
ATOM   1846  CA  ARG   117       4.478 -30.391  18.393  1.00  0.00
ATOM   1847  HA  ARG   117       5.260 -30.770  19.040  1.00  0.00
ATOM   1848  CB  ARG   117       4.276 -28.879  18.700  1.00  0.00
ATOM   1849  HB1 ARG   117       3.834 -28.780  19.688  1.00  0.00
ATOM   1850  HB2 ARG   117       3.586 -28.466  17.969  1.00  0.00
ATOM   1851  CG  ARG   117       5.565 -28.041  18.664  1.00  0.00
ATOM   1852  HG1 ARG   117       5.961 -28.057  17.652  1.00  0.00
ATOM   1853  HG2 ARG   117       6.297 -28.484  19.334  1.00  0.00
ATOM   1854  CD  ARG   117       5.337 -26.586  19.081  1.00  0.00
ATOM   1855  HD1 ARG   117       4.955 -26.564  20.096  1.00  0.00
ATOM   1856  HD2 ARG   117       4.603 -26.141  18.414  1.00  0.00
ATOM   1857  NE  ARG   117       6.581 -25.804  19.027  1.00  0.00
ATOM   1858  HE  ARG   117       7.418 -26.293  19.188  1.00  0.00
ATOM   1859  CZ  ARG   117       6.657 -24.493  18.783  1.00  0.00
ATOM   1860  NH1 ARG   117       5.561 -23.791  18.512  1.00  0.00
ATOM   1861 HH11 ARG   117       4.663 -24.247  18.479  1.00  0.00
ATOM   1862 HH12 ARG   117       5.617 -22.807  18.348  1.00  0.00
ATOM   1863  NH2 ARG   117       7.837 -23.897  18.772  1.00  0.00
ATOM   1864 HH21 ARG   117       8.673 -24.434  18.945  1.00  0.00
ATOM   1865 HH22 ARG   117       7.911 -22.914  18.593  1.00  0.00
ATOM   1866  C   ARG   117       3.185 -31.163  18.716  1.00  0.00
ATOM   1867  O   ARG   117       2.409 -31.535  17.826  1.00  0.00
ATOM   1868  N   ILE   118       2.974 -31.375  20.032  1.00  0.00
ATOM   1869  HN  ILE   118       3.617 -30.990  20.664  1.00  0.00
ATOM   1870  CA  ILE   118       1.835 -32.123  20.603  1.00  0.00
ATOM   1871  HA  ILE   118       1.035 -32.176  19.864  1.00  0.00
ATOM   1872  CB  ILE   118       2.265 -33.596  21.008  1.00  0.00
ATOM   1873  HB  ILE   118       3.094 -33.515  21.708  1.00  0.00
ATOM   1874  CG1 ILE   118       2.754 -34.407  19.770  1.00  0.00
ATOM   1875 HG11 ILE   118       3.130 -35.368  20.099  1.00  0.00
ATOM   1876 HG12 ILE   118       3.559 -33.868  19.289  1.00  0.00
ATOM   1877  CG2 ILE   118       1.130 -34.358  21.729  1.00  0.00
ATOM   1878 HG21 ILE   118       0.866 -33.840  22.644  1.00  0.00
ATOM   1879 HG22 ILE   118       1.449 -35.363  21.972  1.00  0.00
ATOM   1880 HG23 ILE   118       0.255 -34.405  21.084  1.00  0.00
ATOM   1881  CD1 ILE   118       1.695 -34.665  18.720  1.00  0.00
ATOM   1882 HD11 ILE   118       0.912 -35.278  19.142  1.00  0.00
ATOM   1883 HD12 ILE   118       2.138 -35.173  17.878  1.00  0.00
ATOM   1884 HD13 ILE   118       1.271 -33.722  18.393  1.00  0.00
ATOM   1885  C   ILE   118       1.334 -31.368  21.850  1.00  0.00
ATOM   1886  O   ILE   118       2.152 -30.899  22.641  1.00  0.00
END
