
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   45 (  359),  selected   45 , name 2rbf_B
# Molecule2: number of CA atoms   40 (  676),  selected   40 , name T0474.pdb
# PARAMETERS: 2rbf_B.T0474.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M       9           -
LGA    T     4_B      G      10          1.746
LGA    T     5_B      R      11          0.603
LGA    M     6_B      I      12          1.031
LGA    G     7_B      L      13          1.340
LGA    V     8_B      L      14          1.358
LGA    K     9_B      D      15          0.546
LGA    L    10_B      L      16          0.292
LGA    D    11_B      S      17          0.453
LGA    D    12_B      N      18          0.191
LGA    A    13_B      E      19          0.506
LGA    T    14_B      V      20          0.525
LGA    R    15_B      I      21          0.937
LGA    E    16_B      K      22          0.864
LGA    R    17_B      Q      23          0.448
LGA    I    18_B      L      24          0.524
LGA    K    19_B      D      25          1.093
LGA    S    20_B      D      26          1.027
LGA    A    21_B      L      27          0.497
LGA    A    22_B      E      28          1.184
LGA    T    23_B      V      29          1.173
LGA    R    24_B      Q      30          0.372
LGA    I    25_B      R      31          1.087
LGA    D    26_B      N      32          1.818
LGA    R    27_B      L      33          1.089
LGA    T    28_B      P      34          0.794
LGA    P    29_B      R      35          0.993
LGA    H    30_B      A      36          0.973
LGA    W    31_B      D      37          0.409
LGA    L    32_B      L      38          0.645
LGA    I    33_B      L      39          0.741
LGA    K    34_B      R      40          0.672
LGA    Q    35_B      E      41          0.607
LGA    A    36_B      A      42          0.641
LGA    I    37_B      V      43          0.770
LGA    F    38_B      D      44          0.651
LGA    S    39_B      Q      45          0.568
LGA    Y    40_B      Y      46          0.563
LGA    L    41_B      L      47          0.808
LGA    E    42_B      I      48          0.578
LGA    Q    43_B      -       -           -
LGA    L    44_B      -       -           -
LGA    E    45_B      -       -           -
LGA    N    46_B      -       -           -
LGA    S    47_B      -       -           -
LGA    D    48_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   45   40    5.0     39    0.88    12.82     95.735     3.990

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.482940 * X  +  -0.491742 * Y  +   0.724540 * Z  + -60.895359
  Y_new =  -0.319003 * X  +  -0.671767 * Y  +  -0.668555 * Z  +  33.876408
  Z_new =   0.815479 * X  +  -0.554003 * Y  +   0.167556 * Z  +  32.417706 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.277097    1.864496  [ DEG:   -73.1723    106.8277 ]
  Theta =  -0.953556   -2.188037  [ DEG:   -54.6347   -125.3653 ]
  Phi   =  -2.557841    0.583751  [ DEG:  -146.5535     33.4465 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2rbf_B                                        
REMARK     2: T0474.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2rbf_B.T0474.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   45   40   5.0   39   0.88   12.82  95.735
REMARK  ---------------------------------------------------------- 
MOLECULE 2rbf_B
HEADER    OXIDOREDUCTASE/DNA                      18-SEP-07   2RBF              
TITLE     STRUCTURE OF THE RIBBON-HELIX-HELIX DOMAIN OF ESCHERICHIA             
TITLE    2 COLI PUTA (PUTA52) COMPLEXED WITH OPERATOR DNA (O2)                  
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: BIFUNCTIONAL PROTEIN PUTA;                                 
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: RESIDUES 1-52;                                             
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MOL_ID: 2;                                                           
COMPND   7 MOLECULE: DNA (5'-                                                   
COMPND   8 D(*DTP*DT*DTP*DGP*DCP*DGP*DGP*DTP*DTP*DGP*DCP*DAP*DCP*DCP*D          
COMPND   9 TP*DTP*DTP*DCP*DAP*DAP*DA)-3');                                      
COMPND  10 CHAIN: C;                                                            
COMPND  11 ENGINEERED: YES;                                                     
COMPND  12 OTHER_DETAILS: THE NUCLEOTIDES 211-231 OF THE PUT CONTROL            
COMPND  13 REGION IN E. COLI;                                                   
COMPND  14 MOL_ID: 3;                                                           
COMPND  15 MOLECULE: DNA (5'-                                                   
COMPND  16 D(*DTP*DTP*DTP*DGP*DAP*DAP*DAP*DGP*DGP*DTP*DGP*DCP*DAP*DAP*          
COMPND  17 DCP*DCP*DGP*DCP*DAP*DAP*DA)-3');                                     
COMPND  18 CHAIN: D;                                                            
COMPND  19 ENGINEERED: YES;                                                     
COMPND  20 OTHER_DETAILS: COMPLEMENT STRAND OF THE NUCLEOTIDES 211-             
COMPND  21 231 OF THE PUT CONTROL REGION IN E. COLI                             
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 GENE: PUTA, POAA;                                                    
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21 DE3 PLYSS;                            
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PKA8H;                                    
SOURCE   8 MOL_ID: 2;                                                           
SOURCE   9 SYNTHETIC: YES;                                                      
SOURCE  10 MOL_ID: 3;                                                           
SOURCE  11 SYNTHETIC: YES                                                       
KEYWDS    PROTEIN-DNA COMPLEX, RIBBON-HELIX-HELIX, PROLINE                      
KEYWDS   2 UTILIZATION A, PUTA, DNA-BINDING, FAD, FLAVOPROTEIN,                 
KEYWDS   3 MULTIFUNCTIONAL ENZYME, NAD, OXIDOREDUCTASE, PROLINE                 
KEYWDS   4 METABOLISM, REPRESSOR, TRANSCRIPTION, TRANSCRIPTION                  
KEYWDS   5 REGULATION, OXIDOREDUCTASE/DNA COMPLEX                               
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.J.TANNER                                                            
REVDAT   1   29-JUL-08 2RBF    0                                                
JRNL        AUTH   Y.ZHOU,J.D.LARSON,C.A.BOTTOMS,E.C.ARTURO,M.T.HENZL,          
JRNL        AUTH 2 J.L.JENKINS,J.C.NIX,D.F.BECKER,J.J.TANNER                    
JRNL        TITL   STRUCTURAL BASIS OF THE TRANSCRIPTIONAL REGULATION           
JRNL        TITL 2 OF THE PROLINE UTILIZATION REGULON BY                        
JRNL        TITL 3 MULTIFUNCTIONAL PUTA.                                        
JRNL        REF    J.MOL.BIOL.                   V. 381   174 2008              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 2.25 ANGSTROMS.                                          
DBREF  2RBF C    1    21  PDB    2RBF     2RBF             1     21             
DBREF  2RBF D    1    21  PDB    2RBF     2RBF             1     21             
DBREF  2RBF A    1    52  UNP    P09546   PUTA_ECOLI       1     52             
DBREF  2RBF B    1    52  UNP    P09546   PUTA_ECOLI       1     52             
SEQRES   1 A   54  GLY HIS MET GLY THR THR THR MET GLY VAL LYS LEU ASP          
SEQRES   2 A   54  ASP ALA THR ARG GLU ARG ILE LYS SER ALA ALA THR ARG          
SEQRES   3 A   54  ILE ASP ARG THR PRO HIS TRP LEU ILE LYS GLN ALA ILE          
SEQRES   4 A   54  PHE SER TYR LEU GLU GLN LEU GLU ASN SER ASP THR LEU          
SEQRES   5 A   54  PRO GLU                                                      
SEQRES   1 B   54  GLY HIS MET GLY THR THR THR MET GLY VAL LYS LEU ASP          
SEQRES   2 B   54  ASP ALA THR ARG GLU ARG ILE LYS SER ALA ALA THR ARG          
SEQRES   3 B   54  ILE ASP ARG THR PRO HIS TRP LEU ILE LYS GLN ALA ILE          
SEQRES   4 B   54  PHE SER TYR LEU GLU GLN LEU GLU ASN SER ASP THR LEU          
SEQRES   5 B   54  PRO GLU                                                      
SEQRES   1 C   21   DT  DT  DT  DG  DC  DG  DG  DT  DT  DG  DC  DA  DC          
SEQRES   2 C   21   DC  DT  DT  DT  DC  DA  DA  DA                              
SEQRES   1 D   21   DT  DT  DT  DG  DA  DA  DA  DG  DG  DT  DG  DC  DA          
SEQRES   2 D   21   DA  DC  DC  DG  DC  DA  DA  DA                              
FORMUL   5  HOH   *27(H2 O)                                                     
CRYST1   90.911   44.084   55.230  90.00 101.50  90.00 C 1 2 1       8          
ATOM    352  N   THR B   4     -10.629 -15.648   3.581  1.00 53.49           N  
ATOM    353  CA  THR B   4     -10.757 -14.825   4.829  1.00 53.43           C  
ATOM    354  C   THR B   4      -9.612 -13.844   5.013  1.00 52.52           C  
ATOM    355  O   THR B   4      -9.790 -12.825   5.702  1.00 52.65           O  
ATOM    356  CB  THR B   4     -10.881 -15.697   6.130  1.00 53.82           C  
ATOM    357  OG1 THR B   4      -9.645 -16.368   6.408  1.00 55.31           O  
ATOM    358  CG2 THR B   4     -12.014 -16.736   6.010  1.00 54.23           C  
ATOM    359  N   THR B   5      -8.457 -14.126   4.391  1.00 51.44           N  
ATOM    360  CA  THR B   5      -7.282 -13.225   4.451  1.00 50.50           C  
ATOM    361  C   THR B   5      -6.853 -12.647   3.107  1.00 49.67           C  
ATOM    362  O   THR B   5      -7.186 -13.166   2.046  1.00 48.76           O  
ATOM    363  CB  THR B   5      -6.024 -13.906   5.059  1.00 50.32           C  
ATOM    364  OG1 THR B   5      -5.766 -15.142   4.390  1.00 51.21           O  
ATOM    365  CG2 THR B   5      -6.198 -14.178   6.521  1.00 49.99           C  
ATOM    366  N   MET B   6      -6.166 -11.508   3.198  1.00 49.21           N  
ATOM    367  CA  MET B   6      -5.249 -11.018   2.181  1.00 48.71           C  
ATOM    368  C   MET B   6      -3.857 -11.004   2.821  1.00 47.94           C  
ATOM    369  O   MET B   6      -3.721 -11.045   4.053  1.00 47.53           O  
ATOM    370  CB  MET B   6      -5.629  -9.600   1.727  1.00 48.29           C  
ATOM    371  CG  MET B   6      -6.923  -9.552   0.926  1.00 49.23           C  
ATOM    372  SD  MET B   6      -7.285  -7.969   0.140  1.00 50.32           S  
ATOM    373  CE  MET B   6      -6.241  -8.054  -1.322  1.00 50.64           C  
ATOM    374  N   GLY B   7      -2.823 -10.930   1.986  1.00 47.11           N  
ATOM    375  CA  GLY B   7      -1.447 -10.872   2.471  1.00 46.50           C  
ATOM    376  C   GLY B   7      -0.737  -9.619   2.013  1.00 45.86           C  
ATOM    377  O   GLY B   7      -0.977  -9.141   0.919  1.00 45.22           O  
ATOM    378  N   VAL B   8       0.137  -9.086   2.863  1.00 45.11           N  
ATOM    379  CA  VAL B   8       1.004  -7.971   2.460  1.00 45.10           C  
ATOM    380  C   VAL B   8       2.467  -8.288   2.799  1.00 44.45           C  
ATOM    381  O   VAL B   8       2.798  -8.657   3.918  1.00 44.19           O  
ATOM    382  CB  VAL B   8       0.509  -6.602   3.036  1.00 45.02           C  
ATOM    383  CG1 VAL B   8       0.526  -6.601   4.568  1.00 44.94           C  
ATOM    384  CG2 VAL B   8       1.307  -5.449   2.465  1.00 45.33           C  
ATOM    385  N   LYS B   9       3.328  -8.182   1.799  1.00 44.12           N  
ATOM    386  CA  LYS B   9       4.740  -8.490   1.969  1.00 44.73           C  
ATOM    387  C   LYS B   9       5.465  -7.275   2.522  1.00 44.49           C  
ATOM    388  O   LYS B   9       5.543  -6.257   1.856  1.00 43.56           O  
ATOM    389  CB  LYS B   9       5.367  -8.961   0.650  1.00 44.87           C  
ATOM    390  CG  LYS B   9       6.563  -9.859   0.848  1.00 46.04           C  
ATOM    391  CD  LYS B   9       7.002 -10.517  -0.449  1.00 47.23           C  
ATOM    392  CE  LYS B   9       6.036 -11.605  -0.933  1.00 46.51           C  
ATOM    393  NZ  LYS B   9       6.519 -12.177  -2.214  1.00 47.36           N  
ATOM    394  N   LEU B  10       5.953  -7.394   3.759  1.00 44.69           N  
ATOM    395  CA  LEU B  10       6.623  -6.302   4.461  1.00 45.54           C  
ATOM    396  C   LEU B  10       8.039  -6.699   4.790  1.00 45.82           C  
ATOM    397  O   LEU B  10       8.310  -7.859   5.052  1.00 46.03           O  
ATOM    398  CB  LEU B  10       5.869  -5.928   5.751  1.00 45.23           C  
ATOM    399  CG  LEU B  10       4.399  -5.518   5.560  1.00 47.45           C  
ATOM    400  CD1 LEU B  10       3.695  -5.299   6.897  1.00 48.11           C  
ATOM    401  CD2 LEU B  10       4.263  -4.282   4.667  1.00 46.27           C  
ATOM    402  N   ASP B  11       8.949  -5.733   4.757  1.00 46.82           N  
ATOM    403  CA  ASP B  11      10.319  -5.972   5.204  1.00 47.41           C  
ATOM    404  C   ASP B  11      10.372  -5.799   6.709  1.00 47.31           C  
ATOM    405  O   ASP B  11       9.394  -5.351   7.328  1.00 47.10           O  
ATOM    406  CB  ASP B  11      11.337  -5.076   4.471  1.00 47.92           C  
ATOM    407  CG  ASP B  11      11.168  -3.582   4.768  1.00 49.81           C  
ATOM    408  OD1 ASP B  11      10.857  -3.195   5.919  1.00 52.78           O  
ATOM    409  OD2 ASP B  11      11.398  -2.781   3.835  1.00 52.41           O  
ATOM    410  N   ASP B  12      11.509  -6.152   7.291  1.00 47.49           N  
ATOM    411  CA  ASP B  12      11.659  -6.183   8.741  1.00 47.83           C  
ATOM    412  C   ASP B  12      11.515  -4.816   9.423  1.00 47.49           C  
ATOM    413  O   ASP B  12      10.919  -4.709  10.501  1.00 46.99           O  
ATOM    414  CB  ASP B  12      13.009  -6.801   9.120  1.00 48.23           C  
ATOM    415  CG  ASP B  12      12.960  -7.536  10.446  1.00 49.87           C  
ATOM    416  OD1 ASP B  12      11.880  -7.550  11.088  1.00 52.69           O  
ATOM    417  OD2 ASP B  12      13.993  -8.121  10.834  1.00 53.62           O  
ATOM    418  N   ALA B  13      12.075  -3.779   8.803  1.00 47.15           N  
ATOM    419  CA  ALA B  13      11.978  -2.430   9.350  1.00 47.10           C  
ATOM    420  C   ALA B  13      10.519  -1.980   9.487  1.00 46.54           C  
ATOM    421  O   ALA B  13      10.119  -1.427  10.509  1.00 45.64           O  
ATOM    422  CB  ALA B  13      12.758  -1.448   8.479  1.00 47.40           C  
ATOM    423  N   THR B  14       9.722  -2.223   8.453  1.00 46.67           N  
ATOM    424  CA  THR B  14       8.334  -1.801   8.470  1.00 46.31           C  
ATOM    425  C   THR B  14       7.591  -2.618   9.524  1.00 46.46           C  
ATOM    426  O   THR B  14       6.864  -2.061  10.334  1.00 46.66           O  
ATOM    427  CB  THR B  14       7.687  -1.927   7.088  1.00 46.80           C  
ATOM    428  OG1 THR B  14       8.528  -1.304   6.112  1.00 46.06           O  
ATOM    429  CG2 THR B  14       6.310  -1.253   7.066  1.00 47.73           C  
ATOM    430  N   ARG B  15       7.818  -3.928   9.558  1.00 46.59           N  
ATOM    431  CA  ARG B  15       7.285  -4.756  10.650  1.00 46.90           C  
ATOM    432  C   ARG B  15       7.693  -4.225  12.032  1.00 46.76           C  
ATOM    433  O   ARG B  15       6.858  -4.208  12.935  1.00 46.91           O  
ATOM    434  CB  ARG B  15       7.666  -6.234  10.487  1.00 46.65           C  
ATOM    435  CG  ARG B  15       7.086  -6.864   9.235  1.00 47.42           C  
ATOM    436  CD  ARG B  15       6.994  -8.389   9.296  1.00 48.45           C  
ATOM    437  NE  ARG B  15       8.228  -9.037   9.722  1.00 50.51           N  
ATOM    438  CZ  ARG B  15       9.293  -9.296   8.948  1.00 51.04           C  
ATOM    439  NH1 ARG B  15       9.323  -8.948   7.663  1.00 51.11           N  
ATOM    440  NH2 ARG B  15      10.354  -9.902   9.474  1.00 49.77           N  
ATOM    441  N   GLU B  16       8.939  -3.757  12.175  1.00 46.77           N  
ATOM    442  CA  GLU B  16       9.413  -3.162  13.433  1.00 47.26           C  
ATOM    443  C   GLU B  16       8.564  -1.947  13.816  1.00 47.08           C  
ATOM    444  O   GLU B  16       8.078  -1.856  14.944  1.00 47.19           O  
ATOM    445  CB  GLU B  16      10.922  -2.772  13.372  1.00 47.44           C  
ATOM    446  CG  GLU B  16      11.895  -3.943  13.490  1.00 48.04           C  
ATOM    447  CD  GLU B  16      13.381  -3.602  13.142  1.00 48.58           C  
ATOM    448  OE1 GLU B  16      13.851  -2.460  13.387  1.00 50.05           O  
ATOM    449  OE2 GLU B  16      14.090  -4.512  12.646  1.00 48.31           O  
ATOM    450  N   ARG B  17       8.372  -1.032  12.868  1.00 47.08           N  
ATOM    451  CA  ARG B  17       7.603   0.197  13.100  1.00 46.79           C  
ATOM    452  C   ARG B  17       6.159  -0.106  13.461  1.00 46.72           C  
ATOM    453  O   ARG B  17       5.561   0.557  14.321  1.00 47.04           O  
ATOM    454  CB  ARG B  17       7.582   1.073  11.844  1.00 46.83           C  
ATOM    455  CG  ARG B  17       8.897   1.663  11.417  1.00 46.86           C  
ATOM    456  CD  ARG B  17       8.759   2.260  10.033  1.00 48.29           C  
ATOM    457  NE  ARG B  17       8.001   3.514  10.019  1.00 49.64           N  
ATOM    458  CZ  ARG B  17       7.532   4.103   8.914  1.00 49.84           C  
ATOM    459  NH1 ARG B  17       6.872   5.249   9.006  1.00 49.24           N  
ATOM    460  NH2 ARG B  17       7.716   3.554   7.713  1.00 50.11           N  
ATOM    461  N   ILE B  18       5.575  -1.072  12.768  1.00 45.90           N  
ATOM    462  CA  ILE B  18       4.210  -1.440  13.057  1.00 45.59           C  
ATOM    463  C   ILE B  18       4.064  -1.912  14.493  1.00 45.42           C  
ATOM    464  O   ILE B  18       3.135  -1.500  15.186  1.00 45.54           O  
ATOM    465  CB  ILE B  18       3.660  -2.508  12.087  1.00 45.37           C  
ATOM    466  CG1 ILE B  18       3.625  -1.937  10.665  1.00 44.66           C  
ATOM    467  CG2 ILE B  18       2.258  -2.968  12.549  1.00 44.33           C  
ATOM    468  CD1 ILE B  18       3.207  -2.941   9.601  1.00 45.64           C  
ATOM    469  N   LYS B  19       4.977  -2.771  14.933  1.00 45.82           N  
ATOM    470  CA  LYS B  19       4.904  -3.331  16.264  1.00 46.18           C  
ATOM    471  C   LYS B  19       5.097  -2.244  17.325  1.00 46.36           C  
ATOM    472  O   LYS B  19       4.327  -2.160  18.275  1.00 46.12           O  
ATOM    473  CB  LYS B  19       5.953  -4.426  16.442  1.00 46.62           C  
ATOM    474  N   SER B  20       6.116  -1.412  17.162  1.00 46.63           N  
ATOM    475  CA  SER B  20       6.348  -0.332  18.121  1.00 47.61           C  
ATOM    476  C   SER B  20       5.174   0.644  18.168  1.00 47.47           C  
ATOM    477  O   SER B  20       4.820   1.117  19.227  1.00 47.35           O  
ATOM    478  CB  SER B  20       7.651   0.404  17.809  1.00 47.91           C  
ATOM    479  OG  SER B  20       7.725   0.683  16.426  1.00 50.09           O  
ATOM    480  N   ALA B  21       4.538   0.898  17.026  1.00 48.09           N  
ATOM    481  CA  ALA B  21       3.402   1.822  16.974  1.00 48.22           C  
ATOM    482  C   ALA B  21       2.154   1.243  17.620  1.00 48.54           C  
ATOM    483  O   ALA B  21       1.414   1.965  18.288  1.00 48.35           O  
ATOM    484  CB  ALA B  21       3.115   2.248  15.541  1.00 47.83           C  
ATOM    485  N   ALA B  22       1.929  -0.055  17.404  1.00 49.26           N  
ATOM    486  CA  ALA B  22       0.779  -0.793  17.963  1.00 49.67           C  
ATOM    487  C   ALA B  22       0.853  -0.912  19.489  1.00 49.45           C  
ATOM    488  O   ALA B  22      -0.165  -0.889  20.181  1.00 48.87           O  
ATOM    489  CB  ALA B  22       0.700  -2.200  17.349  1.00 49.97           C  
ATOM    490  N   THR B  23       2.065  -1.043  20.004  1.00 49.84           N  
ATOM    491  CA  THR B  23       2.266  -1.164  21.439  1.00 50.01           C  
ATOM    492  C   THR B  23       1.936   0.160  22.117  1.00 50.08           C  
ATOM    493  O   THR B  23       1.272   0.166  23.148  1.00 50.32           O  
ATOM    494  CB  THR B  23       3.703  -1.622  21.780  1.00 50.14           C  
ATOM    495  OG1 THR B  23       3.892  -2.964  21.316  1.00 50.56           O  
ATOM    496  CG2 THR B  23       3.956  -1.574  23.283  1.00 49.62           C  
ATOM    497  N   ARG B  24       2.395   1.270  21.543  1.00 49.99           N  
ATOM    498  CA  ARG B  24       2.055   2.604  22.055  1.00 50.40           C  
ATOM    499  C   ARG B  24       0.548   2.826  22.233  1.00 49.62           C  
ATOM    500  O   ARG B  24       0.120   3.428  23.222  1.00 49.30           O  
ATOM    501  CB  ARG B  24       2.619   3.699  21.136  1.00 51.00           C  
ATOM    502  CG  ARG B  24       4.129   3.902  21.269  1.00 53.57           C  
ATOM    503  CD  ARG B  24       4.719   4.595  20.034  1.00 56.81           C  
ATOM    504  NE  ARG B  24       6.162   4.339  19.888  1.00 57.57           N  
ATOM    505  CZ  ARG B  24       6.821   4.281  18.724  1.00 58.62           C  
ATOM    506  NH1 ARG B  24       6.188   4.454  17.550  1.00 58.28           N  
ATOM    507  NH2 ARG B  24       8.131   4.038  18.732  1.00 58.80           N  
ATOM    508  N   ILE B  25      -0.242   2.352  21.272  1.00 48.98           N  
ATOM    509  CA  ILE B  25      -1.687   2.575  21.266  1.00 48.62           C  
ATOM    510  C   ILE B  25      -2.520   1.418  21.844  1.00 48.09           C  
ATOM    511  O   ILE B  25      -3.758   1.485  21.825  1.00 47.33           O  
ATOM    512  CB  ILE B  25      -2.204   2.953  19.846  1.00 49.11           C  
ATOM    513  CG1 ILE B  25      -2.163   1.751  18.899  1.00 48.76           C  
ATOM    514  CG2 ILE B  25      -1.411   4.179  19.291  1.00 50.19           C  
ATOM    515  CD1 ILE B  25      -2.238   2.114  17.436  1.00 49.40           C  
ATOM    516  N   ASP B  26      -1.856   0.376  22.361  1.00 47.42           N  
ATOM    517  CA  ASP B  26      -2.541  -0.698  23.084  1.00 47.41           C  
ATOM    518  C   ASP B  26      -3.436  -1.487  22.123  1.00 47.43           C  
ATOM    519  O   ASP B  26      -4.603  -1.767  22.416  1.00 47.19           O  
ATOM    520  CB  ASP B  26      -3.344  -0.110  24.254  1.00 47.52           C  
ATOM    521  CG  ASP B  26      -3.872  -1.156  25.209  1.00 47.90           C  
ATOM    522  OD1 ASP B  26      -3.279  -2.247  25.346  1.00 48.81           O  
ATOM    523  OD2 ASP B  26      -4.904  -0.868  25.844  1.00 49.12           O  
ATOM    524  N   ARG B  27      -2.858  -1.819  20.971  1.00 47.29           N  
ATOM    525  CA  ARG B  27      -3.514  -2.570  19.900  1.00 47.63           C  
ATOM    526  C   ARG B  27      -2.527  -3.571  19.305  1.00 47.15           C  
ATOM    527  O   ARG B  27      -1.329  -3.476  19.552  1.00 47.24           O  
ATOM    528  CB  ARG B  27      -3.997  -1.610  18.805  1.00 47.97           C  
ATOM    529  CG  ARG B  27      -5.169  -0.744  19.249  1.00 48.50           C  
ATOM    530  CD  ARG B  27      -6.421  -1.601  19.380  1.00 50.13           C  
ATOM    531  NE  ARG B  27      -7.179  -1.259  20.556  1.00 51.67           N  
ATOM    532  CZ  ARG B  27      -7.910  -0.166  20.686  1.00 50.76           C  
ATOM    533  NH1 ARG B  27      -8.546   0.061  21.826  1.00 51.08           N  
ATOM    534  NH2 ARG B  27      -7.997   0.695  19.695  1.00 51.62           N  
ATOM    535  N   THR B  28      -3.020  -4.540  18.546  1.00 46.71           N  
ATOM    536  CA  THR B  28      -2.128  -5.485  17.866  1.00 46.24           C  
ATOM    537  C   THR B  28      -1.632  -4.907  16.537  1.00 46.00           C  
ATOM    538  O   THR B  28      -2.217  -3.977  16.000  1.00 46.22           O  
ATOM    539  CB  THR B  28      -2.809  -6.844  17.600  1.00 46.30           C  
ATOM    540  OG1 THR B  28      -4.037  -6.641  16.892  1.00 45.36           O  
ATOM    541  CG2 THR B  28      -3.089  -7.593  18.920  1.00 45.22           C  
ATOM    542  N   PRO B  29      -0.509  -5.427  16.024  1.00 45.88           N  
ATOM    543  CA  PRO B  29      -0.128  -5.083  14.671  1.00 45.72           C  
ATOM    544  C   PRO B  29      -1.237  -5.347  13.639  1.00 45.33           C  
ATOM    545  O   PRO B  29      -1.439  -4.518  12.751  1.00 44.91           O  
ATOM    546  CB  PRO B  29       1.112  -5.955  14.427  1.00 45.51           C  
ATOM    547  CG  PRO B  29       1.720  -6.100  15.785  1.00 45.48           C  
ATOM    548  CD  PRO B  29       0.512  -6.272  16.682  1.00 45.98           C  
ATOM    549  N   HIS B  30      -1.930  -6.482  13.771  1.00 45.52           N  
ATOM    550  CA  HIS B  30      -3.061  -6.855  12.911  1.00 45.87           C  
ATOM    551  C   HIS B  30      -4.218  -5.829  12.913  1.00 46.18           C  
ATOM    552  O   HIS B  30      -4.680  -5.384  11.844  1.00 47.02           O  
ATOM    553  CB  HIS B  30      -3.605  -8.223  13.315  1.00 45.58           C  
ATOM    554  CG  HIS B  30      -4.728  -8.686  12.449  1.00 45.80           C  
ATOM    555  ND1 HIS B  30      -6.052  -8.551  12.813  1.00 44.28           N  
ATOM    556  CD2 HIS B  30      -4.728  -9.252  11.216  1.00 44.88           C  
ATOM    557  CE1 HIS B  30      -6.814  -9.019  11.841  1.00 43.77           C  
ATOM    558  NE2 HIS B  30      -6.036  -9.448  10.866  1.00 42.62           N  
ATOM    559  N   TRP B  31      -4.686  -5.457  14.095  1.00 45.81           N  
ATOM    560  CA  TRP B  31      -5.644  -4.336  14.236  1.00 45.96           C  
ATOM    561  C   TRP B  31      -5.132  -3.070  13.519  1.00 45.74           C  
ATOM    562  O   TRP B  31      -5.858  -2.431  12.759  1.00 45.55           O  
ATOM    563  CB  TRP B  31      -5.878  -4.033  15.724  1.00 45.88           C  
ATOM    564  CG  TRP B  31      -6.875  -2.916  16.032  1.00 46.34           C  
ATOM    565  CD1 TRP B  31      -8.194  -3.062  16.365  1.00 45.69           C  
ATOM    566  CD2 TRP B  31      -6.612  -1.501  16.047  1.00 44.72           C  
ATOM    567  NE1 TRP B  31      -8.764  -1.828  16.571  1.00 45.47           N  
ATOM    568  CE2 TRP B  31      -7.814  -0.859  16.388  1.00 45.45           C  
ATOM    569  CE3 TRP B  31      -5.471  -0.718  15.810  1.00 46.06           C  
ATOM    570  CZ2 TRP B  31      -7.915   0.529  16.488  1.00 46.43           C  
ATOM    571  CZ3 TRP B  31      -5.563   0.661  15.919  1.00 46.06           C  
ATOM    572  CH2 TRP B  31      -6.776   1.270  16.255  1.00 46.58           C  
ATOM    573  N   LEU B  32      -3.867  -2.741  13.760  1.00 45.46           N  
ATOM    574  CA  LEU B  32      -3.236  -1.587  13.161  1.00 44.84           C  
ATOM    575  C   LEU B  32      -3.301  -1.602  11.652  1.00 44.77           C  
ATOM    576  O   LEU B  32      -3.688  -0.584  11.045  1.00 45.54           O  
ATOM    577  CB  LEU B  32      -1.782  -1.431  13.643  1.00 45.07           C  
ATOM    578  CG  LEU B  32      -1.123  -0.086  13.320  1.00 43.87           C  
ATOM    579  CD1 LEU B  32      -0.194   0.351  14.383  1.00 43.96           C  
ATOM    580  CD2 LEU B  32      -0.409  -0.112  11.934  1.00 47.01           C  
ATOM    581  N   ILE B  33      -2.931  -2.716  11.041  1.00 44.54           N  
ATOM    582  CA  ILE B  33      -3.013  -2.828   9.572  1.00 44.68           C  
ATOM    583  C   ILE B  33      -4.457  -2.667   9.056  1.00 44.07           C  
ATOM    584  O   ILE B  33      -4.679  -1.990   8.068  1.00 43.13           O  
ATOM    585  CB  ILE B  33      -2.369  -4.132   9.033  1.00 44.42           C  
ATOM    586  CG1 ILE B  33      -0.875  -4.130   9.342  1.00 45.46           C  
ATOM    587  CG2 ILE B  33      -2.579  -4.287   7.537  1.00 45.61           C  
ATOM    588  CD1 ILE B  33      -0.213  -5.500   9.287  1.00 44.56           C  
ATOM    589  N   LYS B  34      -5.422  -3.277   9.723  1.00 44.64           N  
ATOM    590  CA  LYS B  34      -6.842  -3.141   9.318  1.00 44.90           C  
ATOM    591  C   LYS B  34      -7.332  -1.725   9.370  1.00 43.83           C  
ATOM    592  O   LYS B  34      -7.968  -1.252   8.439  1.00 43.11           O  
ATOM    593  CB  LYS B  34      -7.770  -4.029  10.173  1.00 45.12           C  
ATOM    594  CG  LYS B  34      -7.762  -5.444   9.744  1.00 48.67           C  
ATOM    595  CD  LYS B  34      -8.712  -6.323  10.554  1.00 50.64           C  
ATOM    596  CE  LYS B  34     -10.167  -5.923  10.356  1.00 51.58           C  
ATOM    597  NZ  LYS B  34     -11.026  -7.094  10.091  1.00 52.64           N  
ATOM    598  N   GLN B  35      -7.049  -1.043  10.475  1.00 43.88           N  
ATOM    599  CA  GLN B  35      -7.397   0.364  10.604  1.00 43.61           C  
ATOM    600  C   GLN B  35      -6.720   1.221   9.564  1.00 42.25           C  
ATOM    601  O   GLN B  35      -7.318   2.176   9.072  1.00 42.64           O  
ATOM    602  CB  GLN B  35      -7.008   0.911  11.989  1.00 44.30           C  
ATOM    603  CG  GLN B  35      -7.866   0.409  13.094  1.00 47.39           C  
ATOM    604  CD  GLN B  35      -9.335   0.617  12.819  1.00 50.12           C  
ATOM    605  OE1 GLN B  35     -10.079  -0.343  12.679  1.00 54.76           O  
ATOM    606  NE2 GLN B  35      -9.749   1.864  12.700  1.00 49.80           N  
ATOM    607  N   ALA B  36      -5.452   0.923   9.272  1.00 41.47           N  
ATOM    608  CA  ALA B  36      -4.739   1.631   8.208  1.00 41.07           C  
ATOM    609  C   ALA B  36      -5.505   1.489   6.890  1.00 39.77           C  
ATOM    610  O   ALA B  36      -5.693   2.466   6.169  1.00 40.09           O  
ATOM    611  CB  ALA B  36      -3.314   1.099   8.062  1.00 41.05           C  
ATOM    612  N   ILE B  37      -5.965   0.272   6.601  1.00 39.95           N  
ATOM    613  CA  ILE B  37      -6.724  -0.012   5.384  1.00 39.78           C  
ATOM    614  C   ILE B  37      -8.065   0.740   5.354  1.00 39.81           C  
ATOM    615  O   ILE B  37      -8.351   1.455   4.390  1.00 39.75           O  
ATOM    616  CB  ILE B  37      -6.943  -1.524   5.205  1.00 40.88           C  
ATOM    617  CG1 ILE B  37      -5.608  -2.257   4.977  1.00 40.04           C  
ATOM    618  CG2 ILE B  37      -7.899  -1.824   4.029  1.00 39.76           C  
ATOM    619  CD1 ILE B  37      -5.718  -3.744   5.266  1.00 40.15           C  
ATOM    620  N   PHE B  38      -8.857   0.624   6.417  1.00 39.84           N  
ATOM    621  CA  PHE B  38     -10.107   1.402   6.522  1.00 41.50           C  
ATOM    622  C   PHE B  38      -9.893   2.889   6.374  1.00 41.54           C  
ATOM    623  O   PHE B  38     -10.691   3.544   5.722  1.00 41.47           O  
ATOM    624  CB  PHE B  38     -10.881   1.147   7.845  1.00 41.86           C  
ATOM    625  CG  PHE B  38     -11.323  -0.261   7.992  1.00 41.55           C  
ATOM    626  CD1 PHE B  38     -11.072  -0.970   9.149  1.00 44.33           C  
ATOM    627  CD2 PHE B  38     -11.951  -0.915   6.948  1.00 47.21           C  
ATOM    628  CE1 PHE B  38     -11.463  -2.320   9.272  1.00 46.16           C  
ATOM    629  CE2 PHE B  38     -12.353  -2.298   7.060  1.00 46.67           C  
ATOM    630  CZ  PHE B  38     -12.094  -2.979   8.215  1.00 44.81           C  
ATOM    631  N   SER B  39      -8.845   3.426   6.994  1.00 41.75           N  
ATOM    632  CA  SER B  39      -8.623   4.855   6.917  1.00 41.82           C  
ATOM    633  C   SER B  39      -8.284   5.251   5.467  1.00 41.76           C  
ATOM    634  O   SER B  39      -8.821   6.204   4.968  1.00 41.66           O  
ATOM    635  CB  SER B  39      -7.506   5.286   7.850  1.00 42.23           C  
ATOM    636  OG  SER B  39      -7.163   6.643   7.600  1.00 43.25           O  
ATOM    637  N   TYR B  40      -7.429   4.474   4.788  1.00 41.95           N  
ATOM    638  CA  TYR B  40      -7.019   4.815   3.440  1.00 41.35           C  
ATOM    639  C   TYR B  40      -8.182   4.716   2.473  1.00 40.72           C  
ATOM    640  O   TYR B  40      -8.324   5.544   1.606  1.00 40.65           O  
ATOM    641  CB  TYR B  40      -5.884   3.916   2.974  1.00 42.63           C  
ATOM    642  CG  TYR B  40      -5.133   4.432   1.757  1.00 43.51           C  
ATOM    643  CD1 TYR B  40      -4.417   5.626   1.804  1.00 46.96           C  
ATOM    644  CD2 TYR B  40      -5.113   3.711   0.577  1.00 46.51           C  
ATOM    645  CE1 TYR B  40      -3.718   6.097   0.663  1.00 47.53           C  
ATOM    646  CE2 TYR B  40      -4.414   4.159  -0.557  1.00 46.29           C  
ATOM    647  CZ  TYR B  40      -3.724   5.342  -0.510  1.00 45.59           C  
ATOM    648  OH  TYR B  40      -3.052   5.763  -1.628  1.00 45.71           O  
ATOM    649  N   LEU B  41      -9.005   3.696   2.619  1.00 40.60           N  
ATOM    650  CA  LEU B  41     -10.156   3.524   1.742  1.00 41.37           C  
ATOM    651  C   LEU B  41     -11.182   4.633   1.852  1.00 41.91           C  
ATOM    652  O   LEU B  41     -11.738   5.020   0.846  1.00 41.76           O  
ATOM    653  CB  LEU B  41     -10.877   2.203   2.044  1.00 41.55           C  
ATOM    654  CG  LEU B  41     -10.214   0.877   1.683  1.00 40.58           C  
ATOM    655  CD1 LEU B  41     -11.068  -0.256   2.240  1.00 41.18           C  
ATOM    656  CD2 LEU B  41     -10.088   0.749   0.184  1.00 41.06           C  
ATOM    657  N   GLU B  42     -11.456   5.086   3.077  1.00 43.68           N  
ATOM    658  CA  GLU B  42     -12.346   6.242   3.327  1.00 44.99           C  
ATOM    659  C   GLU B  42     -11.830   7.480   2.603  1.00 46.02           C  
ATOM    660  O   GLU B  42     -12.598   8.179   1.989  1.00 45.52           O  
ATOM    661  CB  GLU B  42     -12.450   6.580   4.819  1.00 44.98           C  
ATOM    662  CG  GLU B  42     -13.023   5.512   5.712  1.00 46.19           C  
ATOM    663  N   GLN B  43     -10.521   7.732   2.681  1.00 47.69           N  
ATOM    664  CA  GLN B  43      -9.905   8.814   1.925  1.00 49.21           C  
ATOM    665  C   GLN B  43     -10.143   8.681   0.421  1.00 48.91           C  
ATOM    666  O   GLN B  43     -10.569   9.636  -0.233  1.00 48.74           O  
ATOM    667  CB  GLN B  43      -8.411   8.895   2.244  1.00 50.92           C  
ATOM    668  CG  GLN B  43      -8.146   9.524   3.624  1.00 55.13           C  
ATOM    669  CD  GLN B  43      -6.856   9.086   4.261  1.00 61.62           C  
ATOM    670  OE1 GLN B  43      -6.781   8.951   5.489  1.00 66.42           O  
ATOM    671  NE2 GLN B  43      -5.819   8.864   3.441  1.00 66.64           N  
ATOM    672  N   LEU B  44      -9.902   7.494  -0.126  1.00 48.64           N  
ATOM    673  CA  LEU B  44     -10.110   7.263  -1.547  1.00 48.58           C  
ATOM    674  C   LEU B  44     -11.592   7.390  -1.912  1.00 48.93           C  
ATOM    675  O   LEU B  44     -11.922   8.027  -2.910  1.00 48.34           O  
ATOM    676  CB  LEU B  44      -9.553   5.895  -1.976  1.00 48.79           C  
ATOM    677  CG  LEU B  44      -8.053   5.692  -1.731  1.00 49.67           C  
ATOM    678  CD1 LEU B  44      -7.596   4.355  -2.318  1.00 50.35           C  
ATOM    679  CD2 LEU B  44      -7.232   6.845  -2.302  1.00 49.72           C  
ATOM    680  N   GLU B  45     -12.468   6.838  -1.079  1.00 49.31           N  
ATOM    681  CA  GLU B  45     -13.909   6.845  -1.337  1.00 50.48           C  
ATOM    682  C   GLU B  45     -14.553   8.211  -1.110  1.00 51.65           C  
ATOM    683  O   GLU B  45     -15.537   8.529  -1.768  1.00 51.29           O  
ATOM    684  CB  GLU B  45     -14.637   5.798  -0.479  1.00 50.23           C  
ATOM    685  CG  GLU B  45     -14.391   4.348  -0.907  1.00 51.21           C  
ATOM    686  CD  GLU B  45     -14.655   3.294   0.212  1.00 50.72           C  
ATOM    687  OE1 GLU B  45     -14.623   2.070  -0.089  1.00 49.66           O  
ATOM    688  OE2 GLU B  45     -14.895   3.677   1.377  1.00 47.03           O  
ATOM    689  N   ASN B  46     -14.023   8.992  -0.160  1.00 53.23           N  
ATOM    690  CA  ASN B  46     -14.488  10.363   0.076  1.00 54.75           C  
ATOM    691  C   ASN B  46     -13.873  11.413  -0.849  1.00 55.26           C  
ATOM    692  O   ASN B  46     -14.308  12.542  -0.831  1.00 55.83           O  
ATOM    693  CB  ASN B  46     -14.259  10.792   1.530  1.00 55.11           C  
ATOM    694  CG  ASN B  46     -15.160  10.060   2.513  1.00 57.44           C  
ATOM    695  OD1 ASN B  46     -16.245   9.585   2.163  1.00 61.23           O  
ATOM    696  ND2 ASN B  46     -14.711   9.971   3.759  1.00 60.12           N  
ATOM    697  N   SER B  47     -12.876  11.044  -1.644  1.00 56.30           N  
ATOM    698  CA  SER B  47     -12.237  11.964  -2.596  1.00 57.05           C  
ATOM    699  C   SER B  47     -13.110  12.219  -3.818  1.00 58.19           C  
ATOM    700  O   SER B  47     -13.950  11.390  -4.174  1.00 59.21           O  
ATOM    701  CB  SER B  47     -10.894  11.401  -3.060  1.00 57.21           C  
ATOM    702  OG  SER B  47     -10.323  12.205  -4.069  1.00 56.52           O  
ATOM    703  N   ASP B  48     -12.856  13.341  -4.492  1.00 58.94           N  
ATOM    704  CA  ASP B  48     -13.776  13.916  -5.482  1.00 59.31           C  
ATOM    705  C   ASP B  48     -13.095  14.364  -6.784  1.00 59.34           C  
ATOM    706  O   ASP B  48     -11.866  14.407  -6.882  1.00 59.59           O  
ATOM    707  CB  ASP B  48     -14.513  15.104  -4.855  1.00 59.42           C  
ATOM    708  CG  ASP B  48     -13.650  15.880  -3.869  1.00 60.50           C  
ATOM    709  OD1 ASP B  48     -13.959  17.064  -3.620  1.00 59.64           O  
ATOM    710  OD2 ASP B  48     -12.661  15.304  -3.326  1.00 62.52           O  
TER     711      ASP B  48                                                      
END
MOLECULE T0474.pdb
ATOM    111  N   MET     9     -15.513 -13.396   6.798  1.00  1.00
ATOM    112  HN  MET     9     -15.434 -14.281   7.279  1.00  0.00
ATOM    113  CA  MET     9     -14.325 -12.543   6.707  1.00  1.00
ATOM    114  HA  MET     9     -14.565 -11.671   6.099  1.00  0.00
ATOM    115  CB  MET     9     -13.908 -12.081   8.105  1.00  1.00
ATOM    116 2HB  MET     9     -13.830 -12.945   8.766  1.00  0.00
ATOM    117 3HB  MET     9     -12.943 -11.578   8.049  1.00  0.00
ATOM    118  CG  MET     9     -14.958 -11.112   8.652  1.00  1.00
ATOM    119 2HG  MET     9     -15.026 -10.238   8.004  1.00  0.00
ATOM    120 3HG  MET     9     -15.932 -11.601   8.683  1.00  0.00
ATOM    121  SD  MET     9     -14.493 -10.590  10.321  1.00  1.00
ATOM    122  CE  MET     9     -13.435  -9.204   9.838  1.00  1.00
ATOM    123 1HE  MET     9     -13.039  -8.735  10.739  1.00  0.00
ATOM    124 2HE  MET     9     -12.614  -9.570   9.222  1.00  0.00
ATOM    125 3HE  MET     9     -14.020  -8.479   9.272  1.00  0.00
ATOM    126  C   MET     9     -13.176 -13.302   6.057  1.00  1.00
ATOM    127  O   MET     9     -12.801 -14.387   6.505  1.00  1.00
ATOM    128  N   GLY    10     -12.622 -12.725   4.996  1.00  1.00
ATOM    129  HN  GLY    10     -12.966 -11.834   4.669  1.00  0.00
ATOM    130  CA  GLY    10     -11.516 -13.351   4.281  1.00  1.00
ATOM    131 1HA  GLY    10     -11.622 -14.435   4.333  1.00  0.00
ATOM    132 2HA  GLY    10     -11.539 -13.037   3.238  1.00  0.00
ATOM    133  C   GLY    10     -10.188 -12.947   4.897  1.00  1.00
ATOM    134  O   GLY    10     -10.149 -12.229   5.897  1.00  1.00
ATOM    135  N   ARG    11      -9.096 -13.412   4.297  1.00  1.00
ATOM    136  HN  ARG    11      -9.181 -14.000   3.480  1.00  0.00
ATOM    137  CA  ARG    11      -7.763 -13.096   4.791  1.00  1.00
ATOM    138  HA  ARG    11      -7.806 -12.157   5.342  1.00  0.00
ATOM    139  CB  ARG    11      -7.286 -14.202   5.726  1.00  1.00
ATOM    140 2HB  ARG    11      -6.291 -13.959   6.097  1.00  0.00
ATOM    141 3HB  ARG    11      -7.976 -14.289   6.566  1.00  0.00
ATOM    142  CG  ARG    11      -7.236 -15.532   4.970  1.00  1.00
ATOM    143 2HG  ARG    11      -8.221 -15.755   4.560  1.00  0.00
ATOM    144 3HG  ARG    11      -6.512 -15.462   4.158  1.00  0.00
ATOM    145  CD  ARG    11      -6.820 -16.647   5.930  1.00  1.00
ATOM    146 2HD  ARG    11      -5.842 -16.415   6.352  1.00  0.00
ATOM    147 3HD  ARG    11      -7.550 -16.721   6.737  1.00  0.00
ATOM    148  NE  ARG    11      -6.752 -17.919   5.222  1.00  1.00
ATOM    149  HE  ARG    11      -6.699 -17.908   4.213  1.00  0.00
ATOM    150  CZ  ARG    11      -6.759 -19.073   5.880  1.00  1.00
ATOM    151  NH1 ARG    11      -6.698 -20.199   5.223  1.00  1.00
ATOM    152 1HH1 ARG    11      -6.704 -21.076   5.725  1.00  0.00
ATOM    153 2HH1 ARG    11      -6.645 -20.194   4.214  1.00  0.00
ATOM    154  NH2 ARG    11      -6.828 -19.081   7.183  1.00  1.00
ATOM    155 1HH2 ARG    11      -6.834 -19.960   7.681  1.00  0.00
ATOM    156 2HH2 ARG    11      -6.876 -18.210   7.692  1.00  0.00
ATOM    157  C   ARG    11      -6.786 -12.948   3.631  1.00  1.00
ATOM    158  O   ARG    11      -6.886 -13.656   2.628  1.00  1.00
ATOM    159  N   ILE    12      -5.838 -12.024   3.774  1.00  1.00
ATOM    160  HN  ILE    12      -5.799 -11.470   4.618  1.00  0.00
ATOM    161  CA  ILE    12      -4.836 -11.783   2.734  1.00  1.00
ATOM    162  HA  ILE    12      -4.856 -12.613   2.027  1.00  0.00
ATOM    163  CB  ILE    12      -5.149 -10.485   1.993  1.00  1.00
ATOM    164  HB  ILE    12      -5.211  -9.665   2.708  1.00  0.00
ATOM    165  CG2 ILE    12      -4.041 -10.193   0.977  1.00  1.00
ATOM    166 1HG2 ILE    12      -4.265  -9.266   0.450  1.00  0.00
ATOM    167 2HG2 ILE    12      -3.089 -10.095   1.497  1.00  0.00
ATOM    168 3HG2 ILE    12      -3.981 -11.012   0.260  1.00  0.00
ATOM    169  CG1 ILE    12      -6.487 -10.626   1.261  1.00  1.00
ATOM    170 2HG1 ILE    12      -6.369 -11.306   0.417  1.00  0.00
ATOM    171 3HG1 ILE    12      -7.235 -11.025   1.946  1.00  0.00
ATOM    172  CD1 ILE    12      -6.941  -9.258   0.753  1.00  1.00
ATOM    173 1HD1 ILE    12      -7.893  -9.361   0.231  1.00  0.00
ATOM    174 2HD1 ILE    12      -7.061  -8.579   1.597  1.00  0.00
ATOM    175 3HD1 ILE    12      -6.193  -8.859   0.068  1.00  0.00
ATOM    176  C   ILE    12      -3.449 -11.685   3.354  1.00  1.00
ATOM    177  O   ILE    12      -3.297 -11.280   4.502  1.00  1.00
ATOM    178  N   LEU    13      -2.441 -12.058   2.581  1.00  1.00
ATOM    179  HN  LEU    13      -2.622 -12.381   1.641  1.00  0.00
ATOM    180  CA  LEU    13      -1.058 -12.018   3.047  1.00  1.00
ATOM    181  HA  LEU    13      -1.049 -12.131   4.131  1.00  0.00
ATOM    182  CB  LEU    13      -0.268 -13.170   2.414  1.00  1.00
ATOM    183 2HB  LEU    13      -0.546 -13.261   1.364  1.00  0.00
ATOM    184 3HB  LEU    13       0.798 -12.958   2.491  1.00  0.00
ATOM    185  CG  LEU    13      -0.573 -14.493   3.133  1.00  1.00
ATOM    186  HG  LEU    13      -1.612 -14.492   3.464  1.00  0.00
ATOM    187  CD1 LEU    13      -0.343 -15.669   2.177  1.00  1.00
ATOM    188 1HD1 LEU    13      -0.564 -16.606   2.689  1.00  0.00
ATOM    189 2HD1 LEU    13      -0.998 -15.567   1.311  1.00  0.00
ATOM    190 3HD1 LEU    13       0.696 -15.672   1.848  1.00  0.00
ATOM    191  CD2 LEU    13       0.352 -14.655   4.350  1.00  1.00
ATOM    192 1HD2 LEU    13       0.128 -15.594   4.858  1.00  0.00
ATOM    193 2HD2 LEU    13       1.390 -14.661   4.018  1.00  0.00
ATOM    194 3HD2 LEU    13       0.195 -13.825   5.038  1.00  0.00
ATOM    195  C   LEU    13      -0.412 -10.701   2.682  1.00  1.00
ATOM    196  O   LEU    13      -0.703 -10.115   1.639  1.00  1.00
ATOM    197  N   LEU    14       0.467 -10.241   3.563  1.00  1.00
ATOM    198  HN  LEU    14       0.663 -10.769   4.402  1.00  0.00
ATOM    199  CA  LEU    14       1.169  -8.980   3.354  1.00  1.00
ATOM    200  HA  LEU    14       0.935  -8.615   2.354  1.00  0.00
ATOM    201  CB  LEU    14       0.683  -7.948   4.388  1.00  1.00
ATOM    202 2HB  LEU    14       0.127  -8.462   5.173  1.00  0.00
ATOM    203 3HB  LEU    14       1.545  -7.444   4.824  1.00  0.00
ATOM    204  CG  LEU    14      -0.224  -6.911   3.726  1.00  1.00
ATOM    205  HG  LEU    14      -0.583  -6.216   4.485  1.00  0.00
ATOM    206  CD1 LEU    14       0.576  -6.113   2.661  1.00  1.00
ATOM    207 1HD1 LEU    14      -0.074  -5.370   2.199  1.00  0.00
ATOM    208 2HD1 LEU    14       1.417  -5.612   3.139  1.00  0.00
ATOM    209 3HD1 LEU    14       0.946  -6.797   1.897  1.00  0.00
ATOM    210  CD2 LEU    14      -1.438  -7.627   3.095  1.00  1.00
ATOM    211 1HD2 LEU    14      -2.095  -6.890   2.633  1.00  0.00
ATOM    212 2HD2 LEU    14      -1.092  -8.331   2.337  1.00  0.00
ATOM    213 3HD2 LEU    14      -1.985  -8.167   3.869  1.00  0.00
ATOM    214  C   LEU    14       2.679  -9.170   3.464  1.00  1.00
ATOM    215  O   LEU    14       3.182  -9.797   4.399  1.00  1.00
ATOM    216  N   ASP    15       3.393  -8.610   2.493  1.00  1.00
ATOM    217  HN  ASP    15       2.926  -8.109   1.751  1.00  0.00
ATOM    218  CA  ASP    15       4.851  -8.698   2.462  1.00  1.00
ATOM    219  HA  ASP    15       5.173  -9.440   3.193  1.00  0.00
ATOM    220  CB  ASP    15       5.315  -9.130   1.075  1.00  1.00
ATOM    221 2HB  ASP    15       4.890  -8.463   0.325  1.00  0.00
ATOM    222 3HB  ASP    15       6.402  -9.082   1.024  1.00  0.00
ATOM    223  CG  ASP    15       4.857 -10.559   0.802  1.00  1.00
ATOM    224  OD1 ASP    15       4.446 -11.217   1.744  1.00  1.00
ATOM    225  OD2 ASP    15       4.921 -10.972  -0.343  1.00  1.00
ATOM    226 2HD  ASP    15       4.616 -11.877  -0.440  1.00  0.00
ATOM    227  C   ASP    15       5.475  -7.350   2.811  1.00  1.00
ATOM    228  O   ASP    15       5.377  -6.390   2.043  1.00  1.00
ATOM    229  N   LEU    16       6.122  -7.285   3.974  1.00  1.00
ATOM    230  HN  LEU    16       6.173  -8.102   4.566  1.00  0.00
ATOM    231  CA  LEU    16       6.771  -6.053   4.430  1.00  1.00
ATOM    232  HA  LEU    16       6.836  -5.363   3.589  1.00  0.00
ATOM    233  CB  LEU    16       5.942  -5.405   5.542  1.00  1.00
ATOM    234 2HB  LEU    16       5.703  -6.152   6.299  1.00  0.00
ATOM    235 3HB  LEU    16       6.514  -4.597   5.997  1.00  0.00
ATOM    236  CG  LEU    16       4.641  -4.842   4.951  1.00  1.00
ATOM    237  HG  LEU    16       4.182  -5.600   4.316  1.00  0.00
ATOM    238  CD1 LEU    16       3.679  -4.488   6.091  1.00  1.00
ATOM    239 1HD1 LEU    16       2.748  -4.100   5.676  1.00  0.00
ATOM    240 2HD1 LEU    16       3.469  -5.382   6.679  1.00  0.00
ATOM    241 3HD1 LEU    16       4.135  -3.732   6.729  1.00  0.00
ATOM    242  CD2 LEU    16       4.924  -3.580   4.103  1.00  1.00
ATOM    243 1HD2 LEU    16       3.991  -3.197   3.688  1.00  0.00
ATOM    244 2HD2 LEU    16       5.380  -2.816   4.732  1.00  0.00
ATOM    245 3HD2 LEU    16       5.603  -3.835   3.290  1.00  0.00
ATOM    246  C   LEU    16       8.175  -6.345   4.937  1.00  1.00
ATOM    247  O   LEU    16       8.442  -7.414   5.487  1.00  1.00
ATOM    248  N   SER    17       9.070  -5.384   4.746  1.00  1.00
ATOM    249  HN  SER    17       8.799  -4.524   4.291  1.00  0.00
ATOM    250  CA  SER    17      10.447  -5.538   5.181  1.00  1.00
ATOM    251  HA  SER    17      10.846  -6.462   4.762  1.00  0.00
ATOM    252  CB  SER    17      11.284  -4.360   4.677  1.00  1.00
ATOM    253 2HB  SER    17      10.709  -3.439   4.771  1.00  0.00
ATOM    254 3HB  SER    17      12.196  -4.282   5.269  1.00  0.00
ATOM    255  OG  SER    17      11.621  -4.572   3.312  1.00  1.00
ATOM    256  HG  SER    17      12.145  -3.827   3.009  1.00  0.00
ATOM    257  C   SER    17      10.515  -5.614   6.703  1.00  1.00
ATOM    258  O   SER    17       9.580  -5.216   7.397  1.00  1.00
ATOM    259  N   ASN    18      11.626  -6.130   7.212  1.00  1.00
ATOM    260  HN  ASN    18      12.366  -6.443   6.600  1.00  0.00
ATOM    261  CA  ASN    18      11.809  -6.259   8.652  1.00  1.00
ATOM    262  HA  ASN    18      10.994  -6.860   9.056  1.00  0.00
ATOM    263  CB  ASN    18      13.138  -6.955   8.951  1.00  1.00
ATOM    264 2HB  ASN    18      13.934  -6.476   8.382  1.00  0.00
ATOM    265 3HB  ASN    18      13.359  -6.873  10.015  1.00  0.00
ATOM    266  CG  ASN    18      13.053  -8.428   8.564  1.00  1.00
ATOM    267  OD1 ASN    18      12.406  -9.215   9.254  1.00  1.00
ATOM    268  ND2 ASN    18      13.669  -8.848   7.493  1.00  1.00
ATOM    269 1HD2 ASN    18      14.192  -8.183   6.941  1.00  0.00
ATOM    270 2HD2 ASN    18      13.620  -9.821   7.224  1.00  0.00
ATOM    271  C   ASN    18      11.791  -4.887   9.318  1.00  1.00
ATOM    272  O   ASN    18      11.239  -4.722  10.405  1.00  1.00
ATOM    273  N   GLU    19      12.397  -3.906   8.659  1.00  1.00
ATOM    274  HN  GLU    19      12.835  -4.089   7.767  1.00  0.00
ATOM    275  CA  GLU    19      12.445  -2.553   9.199  1.00  1.00
ATOM    276  HA  GLU    19      13.001  -2.571  10.137  1.00  0.00
ATOM    277  CB  GLU    19      13.159  -1.622   8.213  1.00  1.00
ATOM    278 2HB  GLU    19      12.722  -1.743   7.222  1.00  0.00
ATOM    279 3HB  GLU    19      13.039  -0.589   8.540  1.00  0.00
ATOM    280  CG  GLU    19      14.651  -1.968   8.157  1.00  1.00
ATOM    281 2HG  GLU    19      15.188  -1.170   7.646  1.00  0.00
ATOM    282 3HG  GLU    19      15.037  -2.068   9.171  1.00  0.00
ATOM    283  CD  GLU    19      14.860  -3.279   7.406  1.00  1.00
ATOM    284  OE1 GLU    19      13.967  -3.667   6.671  1.00  1.00
ATOM    285  OE2 GLU    19      15.911  -3.875   7.576  1.00  1.00
ATOM    286 2HE  GLU    19      15.974  -4.690   7.073  1.00  0.00
ATOM    287  C   GLU    19      11.035  -2.034   9.467  1.00  1.00
ATOM    288  O   GLU    19      10.807  -1.306  10.431  1.00  1.00
ATOM    289  N   VAL    20      10.092  -2.422   8.618  1.00  1.00
ATOM    290  HN  VAL    20      10.326  -3.021   7.839  1.00  0.00
ATOM    291  CA  VAL    20       8.705  -1.999   8.784  1.00  1.00
ATOM    292  HA  VAL    20       8.680  -0.915   8.890  1.00  0.00
ATOM    293  CB  VAL    20       7.890  -2.400   7.552  1.00  1.00
ATOM    294  HB  VAL    20       8.005  -3.470   7.375  1.00  0.00
ATOM    295  CG1 VAL    20       6.412  -2.082   7.784  1.00  1.00
ATOM    296 1HG1 VAL    20       5.835  -2.371   6.906  1.00  0.00
ATOM    297 2HG1 VAL    20       6.053  -2.636   8.652  1.00  0.00
ATOM    298 3HG1 VAL    20       6.294  -1.013   7.961  1.00  0.00
ATOM    299  CG2 VAL    20       8.396  -1.626   6.332  1.00  1.00
ATOM    300 1HG2 VAL    20       7.818  -1.914   5.454  1.00  0.00
ATOM    301 2HG2 VAL    20       8.282  -0.557   6.508  1.00  0.00
ATOM    302 3HG2 VAL    20       9.448  -1.857   6.166  1.00  0.00
ATOM    303  C   VAL    20       8.099  -2.635  10.035  1.00  1.00
ATOM    304  O   VAL    20       7.400  -1.970  10.801  1.00  1.00
ATOM    305  N   ILE    21       8.368  -3.920  10.235  1.00  1.00
ATOM    306  HN  ILE    21       8.948  -4.427   9.581  1.00  0.00
ATOM    307  CA  ILE    21       7.838  -4.626  11.395  1.00  1.00
ATOM    308  HA  ILE    21       6.752  -4.676  11.313  1.00  0.00
ATOM    309  CB  ILE    21       8.401  -6.053  11.442  1.00  1.00
ATOM    310  HB  ILE    21       9.480  -6.011  11.588  1.00  0.00
ATOM    311  CG2 ILE    21       7.762  -6.825  12.599  1.00  1.00
ATOM    312 1HG2 ILE    21       8.167  -7.837  12.630  1.00  0.00
ATOM    313 2HG2 ILE    21       7.980  -6.318  13.538  1.00  0.00
ATOM    314 3HG2 ILE    21       6.683  -6.871  12.453  1.00  0.00
ATOM    315  CG1 ILE    21       8.093  -6.768  10.120  1.00  1.00
ATOM    316 2HG1 ILE    21       7.014  -6.874  10.009  1.00  0.00
ATOM    317 3HG1 ILE    21       8.487  -6.180   9.291  1.00  0.00
ATOM    318  CD1 ILE    21       8.742  -8.158  10.110  1.00  1.00
ATOM    319 1HD1 ILE    21       8.517  -8.660   9.169  1.00  0.00
ATOM    320 2HD1 ILE    21       9.822  -8.055  10.218  1.00  0.00
ATOM    321 3HD1 ILE    21       8.349  -8.748  10.938  1.00  0.00
ATOM    322  C   ILE    21       8.208  -3.875  12.668  1.00  1.00
ATOM    323  O   ILE    21       7.418  -3.804  13.610  1.00  1.00
ATOM    324  N   LYS    22       9.407  -3.303  12.684  1.00  1.00
ATOM    325  HN  LYS    22      10.021  -3.389  11.887  1.00  0.00
ATOM    326  CA  LYS    22       9.862  -2.545  13.839  1.00  1.00
ATOM    327  HA  LYS    22       9.776  -3.171  14.728  1.00  0.00
ATOM    328  CB  LYS    22      11.326  -2.139  13.654  1.00  1.00
ATOM    329 2HB  LYS    22      11.435  -1.587  12.721  1.00  0.00
ATOM    330 3HB  LYS    22      11.638  -1.510  14.488  1.00  0.00
ATOM    331  CG  LYS    22      12.196  -3.398  13.609  1.00  1.00
ATOM    332 2HG  LYS    22      12.104  -3.937  14.552  1.00  0.00
ATOM    333 3HG  LYS    22      11.865  -4.039  12.792  1.00  0.00
ATOM    334  CD  LYS    22      13.656  -3.003  13.388  1.00  1.00
ATOM    335 2HD  LYS    22      13.751  -2.478  12.437  1.00  0.00
ATOM    336 3HD  LYS    22      13.982  -2.350  14.197  1.00  0.00
ATOM    337  CE  LYS    22      14.526  -4.260  13.365  1.00  1.00
ATOM    338 2HE  LYS    22      15.573  -3.977  13.253  1.00  0.00
ATOM    339 3HE  LYS    22      14.401  -4.808  14.299  1.00  0.00
ATOM    340  NZ  LYS    22      14.117  -5.125  12.221  1.00  1.00
ATOM    341 1HZ  LYS    22      14.695  -5.954  12.211  1.00  0.00
ATOM    342 2HZ  LYS    22      13.148  -5.389  12.327  1.00  0.00
ATOM    343 3HZ  LYS    22      14.235  -4.619  11.355  1.00  0.00
ATOM    344  C   LYS    22       8.997  -1.298  14.019  1.00  1.00
ATOM    345  O   LYS    22       8.652  -0.924  15.142  1.00  1.00
ATOM    346  N   GLN    23       8.653  -0.656  12.901  1.00  1.00
ATOM    347  HN  GLN    23       8.963  -1.001  12.004  1.00  0.00
ATOM    348  CA  GLN    23       7.831   0.548  12.941  1.00  1.00
ATOM    349  HA  GLN    23       8.313   1.285  13.583  1.00  0.00
ATOM    350  CB  GLN    23       7.694   1.124  11.528  1.00  1.00
ATOM    351 2HB  GLN    23       7.276   0.365  10.866  1.00  0.00
ATOM    352 3HB  GLN    23       7.032   1.989  11.552  1.00  0.00
ATOM    353  CG  GLN    23       9.064   1.547  11.014  1.00  1.00
ATOM    354 2HG  GLN    23       9.476   2.313  11.671  1.00  0.00
ATOM    355 3HG  GLN    23       9.730   0.683  11.009  1.00  0.00
ATOM    356  CD  GLN    23       8.947   2.103   9.601  1.00  1.00
ATOM    357  OE1 GLN    23       8.083   2.938   9.330  1.00  1.00
ATOM    358  NE2 GLN    23       9.773   1.691   8.681  1.00  1.00
ATOM    359 1HE2 GLN    23      10.473   1.006   8.928  1.00  0.00
ATOM    360 2HE2 GLN    23       9.710   2.051   7.740  1.00  0.00
ATOM    361  C   GLN    23       6.452   0.220  13.503  1.00  1.00
ATOM    362  O   GLN    23       5.946   0.913  14.386  1.00  1.00
ATOM    363  N   LEU    24       5.850  -0.844  12.982  1.00  1.00
ATOM    364  HN  LEU    24       6.307  -1.381  12.259  1.00  0.00
ATOM    365  CA  LEU    24       4.528  -1.263  13.434  1.00  1.00
ATOM    366  HA  LEU    24       3.832  -0.435  13.298  1.00  0.00
ATOM    367  CB  LEU    24       4.052  -2.459  12.603  1.00  1.00
ATOM    368 2HB  LEU    24       4.837  -3.215  12.575  1.00  0.00
ATOM    369 3HB  LEU    24       3.157  -2.882  13.059  1.00  0.00
ATOM    370  CG  LEU    24       3.729  -2.005  11.170  1.00  1.00
ATOM    371  HG  LEU    24       4.544  -1.383  10.801  1.00  0.00
ATOM    372  CD1 LEU    24       3.585  -3.238  10.273  1.00  1.00
ATOM    373 1HD1 LEU    24       3.368  -2.923   9.252  1.00  0.00
ATOM    374 2HD1 LEU    24       4.514  -3.808  10.287  1.00  0.00
ATOM    375 3HD1 LEU    24       2.771  -3.863  10.641  1.00  0.00
ATOM    376  CD2 LEU    24       2.418  -1.188  11.137  1.00  1.00
ATOM    377 1HD2 LEU    24       2.206  -0.873  10.115  1.00  0.00
ATOM    378 2HD2 LEU    24       1.597  -1.805  11.503  1.00  0.00
ATOM    379 3HD2 LEU    24       2.523  -0.309  11.773  1.00  0.00
ATOM    380  C   LEU    24       4.564  -1.644  14.905  1.00  1.00
ATOM    381  O   LEU    24       3.670  -1.288  15.668  1.00  1.00
ATOM    382  N   ASP    25       5.605  -2.358  15.302  1.00  1.00
ATOM    383  HN  ASP    25       6.321  -2.624  14.641  1.00  0.00
ATOM    384  CA  ASP    25       5.743  -2.776  16.690  1.00  1.00
ATOM    385  HA  ASP    25       4.924  -3.451  16.938  1.00  0.00
ATOM    386  CB  ASP    25       7.073  -3.509  16.877  1.00  1.00
ATOM    387 2HB  ASP    25       7.177  -4.272  16.106  1.00  0.00
ATOM    388 3HB  ASP    25       7.893  -2.797  16.790  1.00  0.00
ATOM    389  CG  ASP    25       7.121  -4.168  18.249  1.00  1.00
ATOM    390  OD1 ASP    25       6.068  -4.331  18.843  1.00  1.00
ATOM    391  OD2 ASP    25       8.210  -4.500  18.686  1.00  1.00
ATOM    392 2HD  ASP    25       8.165  -4.909  19.554  1.00  0.00
ATOM    393  C   ASP    25       5.692  -1.566  17.617  1.00  1.00
ATOM    394  O   ASP    25       4.993  -1.581  18.629  1.00  1.00
ATOM    395  N   ASP    26       6.427  -0.517  17.264  1.00  1.00
ATOM    396  HN  ASP    26       6.985  -0.545  16.423  1.00  0.00
ATOM    397  CA  ASP    26       6.444   0.690  18.080  1.00  1.00
ATOM    398  HA  ASP    26       6.825   0.440  19.070  1.00  0.00
ATOM    399  CB  ASP    26       7.360   1.736  17.441  1.00  1.00
ATOM    400 2HB  ASP    26       8.317   1.276  17.195  1.00  0.00
ATOM    401 3HB  ASP    26       6.898   2.112  16.528  1.00  0.00
ATOM    402  CG  ASP    26       7.587   2.893  18.406  1.00  1.00
ATOM    403  OD1 ASP    26       6.816   3.016  19.343  1.00  1.00
ATOM    404  OD2 ASP    26       8.529   3.639  18.196  1.00  1.00
ATOM    405 2HD  ASP    26       8.611   4.343  18.843  1.00  0.00
ATOM    406  C   ASP    26       5.032   1.249  18.217  1.00  1.00
ATOM    407  O   ASP    26       4.614   1.651  19.302  1.00  1.00
ATOM    408  N   LEU    27       4.300   1.259  17.110  1.00  1.00
ATOM    409  HN  LEU    27       4.690   0.919  16.243  1.00  0.00
ATOM    410  CA  LEU    27       2.929   1.754  17.111  1.00  1.00
ATOM    411  HA  LEU    27       2.919   2.741  17.572  1.00  0.00
ATOM    412  CB  LEU    27       2.416   1.878  15.672  1.00  1.00
ATOM    413 2HB  LEU    27       2.812   1.057  15.074  1.00  0.00
ATOM    414 3HB  LEU    27       1.327   1.836  15.670  1.00  0.00
ATOM    415  CG  LEU    27       2.881   3.225  15.071  1.00  1.00
ATOM    416  HG  LEU    27       3.841   3.501  15.506  1.00  0.00
ATOM    417  CD1 LEU    27       3.027   3.090  13.565  1.00  1.00
ATOM    418 1HD1 LEU    27       3.358   4.039  13.144  1.00  0.00
ATOM    419 2HD1 LEU    27       3.762   2.317  13.339  1.00  0.00
ATOM    420 3HD1 LEU    27       2.066   2.815  13.130  1.00  0.00
ATOM    421  CD2 LEU    27       1.846   4.321  15.376  1.00  1.00
ATOM    422 1HD2 LEU    27       2.181   5.267  14.952  1.00  0.00
ATOM    423 2HD2 LEU    27       0.886   4.046  14.938  1.00  0.00
ATOM    424 3HD2 LEU    27       1.735   4.426  16.455  1.00  0.00
ATOM    425  C   LEU    27       2.024   0.830  17.918  1.00  1.00
ATOM    426  O   LEU    27       1.076   1.278  18.558  1.00  1.00
ATOM    427  N   GLU    28       2.323  -0.461  17.875  1.00  1.00
ATOM    428  HN  GLU    28       3.112  -0.779  17.331  1.00  0.00
ATOM    429  CA  GLU    28       1.536  -1.444  18.599  1.00  1.00
ATOM    430  HA  GLU    28       0.481  -1.288  18.371  1.00  0.00
ATOM    431  CB  GLU    28       1.944  -2.847  18.147  1.00  1.00
ATOM    432 2HB  GLU    28       3.031  -2.923  18.137  1.00  0.00
ATOM    433 3HB  GLU    28       1.535  -3.585  18.838  1.00  0.00
ATOM    434  CG  GLU    28       1.401  -3.112  16.740  1.00  1.00
ATOM    435 2HG  GLU    28       0.318  -3.226  16.785  1.00  0.00
ATOM    436 3HG  GLU    28       1.647  -2.271  16.092  1.00  0.00
ATOM    437  CD  GLU    28       2.021  -4.385  16.175  1.00  1.00
ATOM    438  OE1 GLU    28       1.807  -5.434  16.759  1.00  1.00
ATOM    439  OE2 GLU    28       2.705  -4.290  15.169  1.00  1.00
ATOM    440 2HE  GLU    28       3.064  -5.129  14.871  1.00  0.00
ATOM    441  C   GLU    28       1.744  -1.301  20.103  1.00  1.00
ATOM    442  O   GLU    28       0.820  -1.498  20.886  1.00  1.00
ATOM    443  N   VAL    29       2.967  -0.967  20.496  1.00  1.00
ATOM    444  HN  VAL    29       3.699  -0.817  19.817  1.00  0.00
ATOM    445  CA  VAL    29       3.278  -0.811  21.916  1.00  1.00
ATOM    446  HA  VAL    29       3.008  -1.731  22.435  1.00  0.00
ATOM    447  CB  VAL    29       4.780  -0.558  22.093  1.00  1.00
ATOM    448  HB  VAL    29       5.090   0.246  21.426  1.00  0.00
ATOM    449  CG1 VAL    29       5.075  -0.157  23.544  1.00  1.00
ATOM    450 1HG1 VAL    29       6.143   0.023  23.663  1.00  0.00
ATOM    451 2HG1 VAL    29       4.524   0.751  23.789  1.00  0.00
ATOM    452 3HG1 VAL    29       4.766  -0.961  24.213  1.00  0.00
ATOM    453  CG2 VAL    29       5.558  -1.832  21.749  1.00  1.00
ATOM    454 1HG2 VAL    29       6.626  -1.651  21.870  1.00  0.00
ATOM    455 2HG2 VAL    29       5.248  -2.638  22.415  1.00  0.00
ATOM    456 3HG2 VAL    29       5.353  -2.115  20.717  1.00  0.00
ATOM    457  C   VAL    29       2.490   0.350  22.522  1.00  1.00
ATOM    458  O   VAL    29       1.838   0.200  23.555  1.00  1.00
ATOM    459  N   GLN    30       2.565   1.506  21.876  1.00  1.00
ATOM    460  HN  GLN    30       3.114   1.580  21.032  1.00  0.00
ATOM    461  CA  GLN    30       1.864   2.689  22.362  1.00  1.00
ATOM    462  HA  GLN    30       2.189   2.889  23.383  1.00  0.00
ATOM    463  CB  GLN    30       2.206   3.900  21.487  1.00  1.00
ATOM    464 2HB  GLN    30       1.589   4.748  21.782  1.00  0.00
ATOM    465 3HB  GLN    30       3.258   4.154  21.613  1.00  0.00
ATOM    466  CG  GLN    30       1.937   3.559  20.033  1.00  1.00
ATOM    467 2HG  GLN    30       2.480   2.652  19.767  1.00  0.00
ATOM    468 3HG  GLN    30       0.869   3.392  19.892  1.00  0.00
ATOM    469  CD  GLN    30       2.394   4.705  19.137  1.00  1.00
ATOM    470  OE1 GLN    30       3.594   4.951  19.007  1.00  1.00
ATOM    471  NE2 GLN    30       1.507   5.426  18.510  1.00  1.00
ATOM    472 1HE2 GLN    30       0.529   5.206  18.633  1.00  0.00
ATOM    473 2HE2 GLN    30       1.796   6.188  17.915  1.00  0.00
ATOM    474  C   GLN    30       0.361   2.454  22.363  1.00  1.00
ATOM    475  O   GLN    30      -0.341   2.869  23.283  1.00  1.00
ATOM    476  N   ARG    31      -0.127   1.784  21.325  1.00  1.00
ATOM    477  HN  ARG    31       0.492   1.461  20.595  1.00  0.00
ATOM    478  CA  ARG    31      -1.554   1.498  21.209  1.00  1.00
ATOM    479  HA  ARG    31      -2.114   2.326  21.644  1.00  0.00
ATOM    480  CB  ARG    31      -1.929   1.363  19.725  1.00  1.00
ATOM    481 2HB  ARG    31      -1.128   0.846  19.197  1.00  0.00
ATOM    482 3HB  ARG    31      -2.851   0.788  19.638  1.00  0.00
ATOM    483  CG  ARG    31      -2.137   2.754  19.099  1.00  1.00
ATOM    484 2HG  ARG    31      -1.427   3.455  19.537  1.00  0.00
ATOM    485 3HG  ARG    31      -1.972   2.693  18.023  1.00  0.00
ATOM    486  CD  ARG    31      -3.565   3.245  19.366  1.00  1.00
ATOM    487 2HD  ARG    31      -4.277   2.508  18.994  1.00  0.00
ATOM    488 3HD  ARG    31      -3.710   3.372  20.439  1.00  0.00
ATOM    489  NE  ARG    31      -3.789   4.518  18.692  1.00  1.00
ATOM    490  HE  ARG    31      -4.150   4.506  17.749  1.00  0.00
ATOM    491  CZ  ARG    31      -3.529   5.674  19.294  1.00  1.00
ATOM    492  NH1 ARG    31      -3.751   6.794  18.668  1.00  1.00
ATOM    493 1HH1 ARG    31      -3.552   7.672  19.125  1.00  0.00
ATOM    494 2HH1 ARG    31      -4.122   6.783  17.729  1.00  0.00
ATOM    495  NH2 ARG    31      -3.046   5.687  20.508  1.00  1.00
ATOM    496 1HH2 ARG    31      -2.848   6.567  20.961  1.00  0.00
ATOM    497 2HH2 ARG    31      -2.871   4.818  20.992  1.00  0.00
ATOM    498  C   ARG    31      -1.908   0.216  21.957  1.00  1.00
ATOM    499  O   ARG    31      -3.077  -0.038  22.248  1.00  1.00
ATOM    500  N   ASN    32      -0.898  -0.584  22.265  1.00  1.00
ATOM    501  HN  ASN    32       0.046  -0.334  22.008  1.00  0.00
ATOM    502  CA  ASN    32      -1.122  -1.829  22.974  1.00  1.00
ATOM    503  HA  ASN    32      -0.177  -2.368  23.046  1.00  0.00
ATOM    504  CB  ASN    32      -1.640  -1.544  24.378  1.00  1.00
ATOM    505 2HB  ASN    32      -2.629  -1.090  24.314  1.00  0.00
ATOM    506 3HB  ASN    32      -1.710  -2.478  24.936  1.00  0.00
ATOM    507  CG  ASN    32      -0.690  -0.596  25.097  1.00  1.00
ATOM    508  OD1 ASN    32       0.488  -0.908  25.268  1.00  1.00
ATOM    509  ND2 ASN    32      -1.133   0.553  25.526  1.00  1.00
ATOM    510 1HD2 ASN    32      -2.103   0.787  25.371  1.00  0.00
ATOM    511 2HD2 ASN    32      -0.514   1.193  26.002  1.00  0.00
ATOM    512  C   ASN    32      -2.126  -2.686  22.225  1.00  1.00
ATOM    513  O   ASN    32      -2.988  -3.319  22.832  1.00  1.00
ATOM    514  N   LEU    33      -2.020  -2.698  20.896  1.00  1.00
ATOM    515  HN  LEU    33      -1.296  -2.163  20.439  1.00  0.00
ATOM    516  CA  LEU    33      -2.942  -3.481  20.071  1.00  1.00
ATOM    517  HA  LEU    33      -3.452  -4.206  20.707  1.00  0.00
ATOM    518  CB  LEU    33      -3.983  -2.541  19.444  1.00  1.00
ATOM    519 2HB  LEU    33      -3.494  -1.621  19.126  1.00  0.00
ATOM    520 3HB  LEU    33      -4.437  -3.029  18.581  1.00  0.00
ATOM    521  CG  LEU    33      -5.078  -2.208  20.477  1.00  1.00
ATOM    522  HG  LEU    33      -4.621  -2.119  21.462  1.00  0.00
ATOM    523  CD1 LEU    33      -5.744  -0.882  20.108  1.00  1.00
ATOM    524 1HD1 LEU    33      -6.510  -0.640  20.845  1.00  0.00
ATOM    525 2HD1 LEU    33      -4.994  -0.092  20.092  1.00  0.00
ATOM    526 3HD1 LEU    33      -6.203  -0.968  19.123  1.00  0.00
ATOM    527  CD2 LEU    33      -6.144  -3.319  20.517  1.00  1.00
ATOM    528 1HD2 LEU    33      -6.907  -3.072  21.255  1.00  0.00
ATOM    529 2HD2 LEU    33      -6.608  -3.412  19.535  1.00  0.00
ATOM    530 3HD2 LEU    33      -5.673  -4.264  20.787  1.00  0.00
ATOM    531  C   LEU    33      -2.191  -4.230  18.972  1.00  1.00
ATOM    532  O   LEU    33      -1.121  -3.799  18.538  1.00  1.00
ATOM    533  N   PRO    34      -2.736  -5.331  18.512  1.00  1.00
ATOM    534  CD  PRO    34      -4.004  -5.930  18.977  1.00  1.00
ATOM    535  CA  PRO    34      -2.110  -6.148  17.430  1.00  1.00
ATOM    536  HA  PRO    34      -1.111  -6.469  17.726  1.00  0.00
ATOM    537  CB  PRO    34      -3.045  -7.368  17.298  1.00  1.00
ATOM    538 2HB  PRO    34      -3.151  -7.684  16.260  1.00  0.00
ATOM    539 3HB  PRO    34      -2.649  -8.179  17.909  1.00  0.00
ATOM    540  CG  PRO    34      -4.352  -6.929  17.881  1.00  1.00
ATOM    541 2HG  PRO    34      -4.918  -6.411  17.107  1.00  0.00
ATOM    542 3HG  PRO    34      -4.919  -7.773  18.274  1.00  0.00
ATOM    543 2HD  PRO    34      -4.789  -5.183  19.093  1.00  0.00
ATOM    544 3HD  PRO    34      -3.835  -6.452  19.919  1.00  0.00
ATOM    545  C   PRO    34      -2.016  -5.378  16.112  1.00  1.00
ATOM    546  O   PRO    34      -2.805  -4.471  15.854  1.00  1.00
ATOM    547  N   ARG    35      -1.047  -5.755  15.286  1.00  1.00
ATOM    548  HN  ARG    35      -0.423  -6.505  15.547  1.00  0.00
ATOM    549  CA  ARG    35      -0.858  -5.106  13.998  1.00  1.00
ATOM    550  HA  ARG    35      -0.686  -4.042  14.160  1.00  0.00
ATOM    551  CB  ARG    35       0.359  -5.712  13.299  1.00  1.00
ATOM    552 2HB  ARG    35       0.558  -5.163  12.379  1.00  0.00
ATOM    553 3HB  ARG    35       1.225  -5.644  13.957  1.00  0.00
ATOM    554  CG  ARG    35       0.090  -7.184  12.965  1.00  1.00
ATOM    555 2HG  ARG    35      -0.310  -7.689  13.845  1.00  0.00
ATOM    556 3HG  ARG    35      -0.633  -7.246  12.151  1.00  0.00
ATOM    557  CD  ARG    35       1.394  -7.858  12.540  1.00  1.00
ATOM    558 2HD  ARG    35       1.818  -7.323  11.690  1.00  0.00
ATOM    559 3HD  ARG    35       2.101  -7.833  13.369  1.00  0.00
ATOM    560  NE  ARG    35       1.140  -9.244  12.162  1.00  1.00
ATOM    561  HE  ARG    35       0.191  -9.523  11.958  1.00  0.00
ATOM    562  CZ  ARG    35       2.129 -10.128  12.085  1.00  1.00
ATOM    563  NH1 ARG    35       1.877 -11.362  11.743  1.00  1.00
ATOM    564 1HH1 ARG    35       2.630 -12.032  11.686  1.00  0.00
ATOM    565 2HH1 ARG    35       0.930 -11.647  11.536  1.00  0.00
ATOM    566  NH2 ARG    35       3.352  -9.761  12.354  1.00  1.00
ATOM    567 1HH2 ARG    35       4.103 -10.434  12.296  1.00  0.00
ATOM    568 2HH2 ARG    35       3.547  -8.807  12.620  1.00  0.00
ATOM    569  C   ARG    35      -2.094  -5.282  13.128  1.00  1.00
ATOM    570  O   ARG    35      -2.547  -4.338  12.481  1.00  1.00
ATOM    571  N   ALA    36      -2.630  -6.497  13.102  1.00  1.00
ATOM    572  HN  ALA    36      -2.226  -7.244  13.650  1.00  0.00
ATOM    573  CA  ALA    36      -3.804  -6.780  12.288  1.00  1.00
ATOM    574  HA  ALA    36      -3.513  -6.776  11.238  1.00  0.00
ATOM    575  CB  ALA    36      -4.367  -8.157  12.647  1.00  1.00
ATOM    576 1HB  ALA    36      -5.236  -8.372  12.024  1.00  0.00
ATOM    577 2HB  ALA    36      -3.604  -8.917  12.478  1.00  0.00
ATOM    578 3HB  ALA    36      -4.662  -8.167  13.696  1.00  0.00
ATOM    579  C   ALA    36      -4.869  -5.719  12.514  1.00  1.00
ATOM    580  O   ALA    36      -5.509  -5.258  11.569  1.00  1.00
ATOM    581  N   ASP    37      -5.044  -5.323  13.768  1.00  1.00
ATOM    582  HN  ASP    37      -4.497  -5.730  14.513  1.00  0.00
ATOM    583  CA  ASP    37      -6.026  -4.299  14.095  1.00  1.00
ATOM    584  HA  ASP    37      -6.992  -4.599  13.688  1.00  0.00
ATOM    585  CB  ASP    37      -6.145  -4.162  15.615  1.00  1.00
ATOM    586 2HB  ASP    37      -6.520  -5.096  16.035  1.00  0.00
ATOM    587 3HB  ASP    37      -5.163  -3.948  16.037  1.00  0.00
ATOM    588  CG  ASP    37      -7.104  -3.029  15.964  1.00  1.00
ATOM    589  OD1 ASP    37      -6.656  -2.063  16.560  1.00  1.00
ATOM    590  OD2 ASP    37      -8.272  -3.143  15.630  1.00  1.00
ATOM    591 2HD  ASP    37      -8.817  -2.394  15.882  1.00  0.00
ATOM    592  C   ASP    37      -5.626  -2.957  13.485  1.00  1.00
ATOM    593  O   ASP    37      -6.473  -2.203  13.007  1.00  1.00
ATOM    594  N   LEU    38      -4.328  -2.669  13.504  1.00  1.00
ATOM    595  HN  LEU    38      -3.671  -3.321  13.908  1.00  0.00
ATOM    596  CA  LEU    38      -3.822  -1.419  12.949  1.00  1.00
ATOM    597  HA  LEU    38      -4.409  -0.596  13.356  1.00  0.00
ATOM    598  CB  LEU    38      -2.356  -1.230  13.347  1.00  1.00
ATOM    599 2HB  LEU    38      -1.784  -2.110  13.051  1.00  0.00
ATOM    600 3HB  LEU    38      -1.955  -0.350  12.845  1.00  0.00
ATOM    601  CG  LEU    38      -2.254  -1.042  14.869  1.00  1.00
ATOM    602  HG  LEU    38      -2.762  -1.871  15.364  1.00  0.00
ATOM    603  CD1 LEU    38      -0.777  -1.036  15.282  1.00  1.00
ATOM    604 1HD1 LEU    38      -0.701  -0.916  16.363  1.00  0.00
ATOM    605 2HD1 LEU    38      -0.314  -1.979  14.988  1.00  0.00
ATOM    606 3HD1 LEU    38      -0.265  -0.211  14.788  1.00  0.00
ATOM    607  CD2 LEU    38      -2.919   0.283  15.301  1.00  1.00
ATOM    608 1HD2 LEU    38      -2.843   0.398  16.382  1.00  0.00
ATOM    609 2HD2 LEU    38      -2.416   1.117  14.812  1.00  0.00
ATOM    610 3HD2 LEU    38      -3.970   0.272  15.012  1.00  0.00
ATOM    611  C   LEU    38      -3.947  -1.410  11.431  1.00  1.00
ATOM    612  O   LEU    38      -4.315  -0.398  10.834  1.00  1.00
ATOM    613  N   LEU    39      -3.630  -2.539  10.810  1.00  1.00
ATOM    614  HN  LEU    39      -3.336  -3.347  11.341  1.00  0.00
ATOM    615  CA  LEU    39      -3.698  -2.642   9.359  1.00  1.00
ATOM    616  HA  LEU    39      -3.057  -1.878   8.920  1.00  0.00
ATOM    617  CB  LEU    39      -3.207  -4.021   8.928  1.00  1.00
ATOM    618 2HB  LEU    39      -3.755  -4.787   9.477  1.00  0.00
ATOM    619 3HB  LEU    39      -3.378  -4.147   7.859  1.00  0.00
ATOM    620  CG  LEU    39      -1.705  -4.160   9.223  1.00  1.00
ATOM    621  HG  LEU    39      -1.522  -3.885  10.262  1.00  0.00
ATOM    622  CD1 LEU    39      -1.276  -5.619   9.008  1.00  1.00
ATOM    623 1HD1 LEU    39      -0.214  -5.724   9.231  1.00  0.00
ATOM    624 2HD1 LEU    39      -1.851  -6.268   9.669  1.00  0.00
ATOM    625 3HD1 LEU    39      -1.460  -5.903   7.972  1.00  0.00
ATOM    626  CD2 LEU    39      -0.882  -3.226   8.308  1.00  1.00
ATOM    627 1HD2 LEU    39       0.179  -3.331   8.534  1.00  0.00
ATOM    628 2HD2 LEU    39      -1.058  -3.493   7.266  1.00  0.00
ATOM    629 3HD2 LEU    39      -1.188  -2.194   8.475  1.00  0.00
ATOM    630  C   LEU    39      -5.126  -2.437   8.872  1.00  1.00
ATOM    631  O   LEU    39      -5.366  -1.701   7.915  1.00  1.00
ATOM    632  N   ARG    40      -6.072  -3.096   9.529  1.00  1.00
ATOM    633  HN  ARG    40      -5.831  -3.690  10.309  1.00  0.00
ATOM    634  CA  ARG    40      -7.470  -2.980   9.142  1.00  1.00
ATOM    635  HA  ARG    40      -7.593  -3.390   8.139  1.00  0.00
ATOM    636  CB  ARG    40      -8.347  -3.770  10.118  1.00  1.00
ATOM    637 2HB  ARG    40      -8.014  -4.808  10.146  1.00  0.00
ATOM    638 3HB  ARG    40      -8.263  -3.335  11.114  1.00  0.00
ATOM    639  CG  ARG    40      -9.806  -3.716   9.661  1.00  1.00
ATOM    640 2HG  ARG    40     -10.146  -2.681   9.653  1.00  0.00
ATOM    641 3HG  ARG    40      -9.888  -4.134   8.658  1.00  0.00
ATOM    642  CD  ARG    40     -10.672  -4.528  10.623  1.00  1.00
ATOM    643 2HD  ARG    40     -11.704  -4.527  10.270  1.00  0.00
ATOM    644 3HD  ARG    40     -10.307  -5.555  10.660  1.00  0.00
ATOM    645  NE  ARG    40     -10.617  -3.946  11.960  1.00  1.00
ATOM    646  HE  ARG    40     -10.000  -4.363  12.642  1.00  0.00
ATOM    647  CZ  ARG    40     -11.359  -2.891  12.283  1.00  1.00
ATOM    648  NH1 ARG    40     -11.296  -2.394  13.488  1.00  1.00
ATOM    649 1HH1 ARG    40     -11.859  -1.592  13.731  1.00  0.00
ATOM    650 2HH1 ARG    40     -10.686  -2.811  14.176  1.00  0.00
ATOM    651  NH2 ARG    40     -12.145  -2.349  11.393  1.00  1.00
ATOM    652 1HH2 ARG    40     -12.707  -1.547  11.640  1.00  0.00
ATOM    653 2HH2 ARG    40     -12.192  -2.732  10.460  1.00  0.00
ATOM    654  C   ARG    40      -7.895  -1.518   9.138  1.00  1.00
ATOM    655  O   ARG    40      -8.571  -1.060   8.216  1.00  1.00
ATOM    656  N   GLU    41      -7.491  -0.789  10.169  1.00  1.00
ATOM    657  HN  GLU    41      -6.936  -1.209  10.902  1.00  0.00
ATOM    658  CA  GLU    41      -7.833   0.623  10.270  1.00  1.00
ATOM    659  HA  GLU    41      -8.914   0.728  10.175  1.00  0.00
ATOM    660  CB  GLU    41      -7.397   1.170  11.631  1.00  1.00
ATOM    661 2HB  GLU    41      -6.340   0.954  11.786  1.00  0.00
ATOM    662 3HB  GLU    41      -7.555   2.248  11.655  1.00  0.00
ATOM    663  CG  GLU    41      -8.219   0.511  12.742  1.00  1.00
ATOM    664 2HG  GLU    41      -8.141  -0.573  12.655  1.00  0.00
ATOM    665 3HG  GLU    41      -7.831   0.822  13.712  1.00  0.00
ATOM    666  CD  GLU    41      -9.683   0.924  12.626  1.00  1.00
ATOM    667  OE1 GLU    41     -10.523   0.212  13.150  1.00  1.00
ATOM    668  OE2 GLU    41      -9.942   1.945  12.011  1.00  1.00
ATOM    669 2HE  GLU    41     -10.881   2.143  11.977  1.00  0.00
ATOM    670  C   GLU    41      -7.157   1.416   9.157  1.00  1.00
ATOM    671  O   GLU    41      -7.731   2.362   8.620  1.00  1.00
ATOM    672  N   ALA    42      -5.935   1.025   8.816  1.00  1.00
ATOM    673  HN  ALA    42      -5.502   0.242   9.285  1.00  0.00
ATOM    674  CA  ALA    42      -5.195   1.711   7.765  1.00  1.00
ATOM    675  HA  ALA    42      -5.063   2.753   8.054  1.00  0.00
ATOM    676  CB  ALA    42      -3.822   1.062   7.588  1.00  1.00
ATOM    677 1HB  ALA    42      -3.264   1.589   6.815  1.00  0.00
ATOM    678 2HB  ALA    42      -3.273   1.112   8.529  1.00  0.00
ATOM    679 3HB  ALA    42      -3.949   0.019   7.296  1.00  0.00
ATOM    680  C   ALA    42      -5.957   1.654   6.445  1.00  1.00
ATOM    681  O   ALA    42      -6.127   2.672   5.774  1.00  1.00
ATOM    682  N   VAL    43      -6.414   0.461   6.074  1.00  1.00
ATOM    683  HN  VAL    43      -6.254  -0.351   6.654  1.00  0.00
ATOM    684  CA  VAL    43      -7.153   0.301   4.826  1.00  1.00
ATOM    685  HA  VAL    43      -6.540   0.667   4.003  1.00  0.00
ATOM    686  CB  VAL    43      -7.464  -1.180   4.601  1.00  1.00
ATOM    687  HB  VAL    43      -8.001  -1.572   5.465  1.00  0.00
ATOM    688  CG1 VAL    43      -8.329  -1.341   3.351  1.00  1.00
ATOM    689 1HG1 VAL    43      -8.550  -2.397   3.194  1.00  0.00
ATOM    690 2HG1 VAL    43      -9.261  -0.791   3.481  1.00  0.00
ATOM    691 3HG1 VAL    43      -7.794  -0.950   2.486  1.00  0.00
ATOM    692  CG2 VAL    43      -6.156  -1.955   4.421  1.00  1.00
ATOM    693 1HG2 VAL    43      -6.377  -3.011   4.264  1.00  0.00
ATOM    694 2HG2 VAL    43      -5.618  -1.564   3.558  1.00  0.00
ATOM    695 3HG2 VAL    43      -5.541  -1.842   5.314  1.00  0.00
ATOM    696  C   VAL    43      -8.454   1.098   4.873  1.00  1.00
ATOM    697  O   VAL    43      -8.725   1.916   3.995  1.00  1.00
ATOM    698  N   ASP    44      -9.257   0.847   5.901  1.00  1.00
ATOM    699  HN  ASP    44      -8.994   0.166   6.599  1.00  0.00
ATOM    700  CA  ASP    44     -10.528   1.542   6.045  1.00  1.00
ATOM    701  HA  ASP    44     -11.207   1.200   5.263  1.00  0.00
ATOM    702  CB  ASP    44     -11.143   1.234   7.411  1.00  1.00
ATOM    703 2HB  ASP    44     -11.062   0.165   7.610  1.00  0.00
ATOM    704 3HB  ASP    44     -10.604   1.784   8.182  1.00  0.00
ATOM    705  CG  ASP    44     -12.614   1.642   7.436  1.00  1.00
ATOM    706  OD1 ASP    44     -13.227   1.654   6.381  1.00  1.00
ATOM    707  OD2 ASP    44     -13.105   1.939   8.513  1.00  1.00
ATOM    708 2HD  ASP    44     -14.031   2.185   8.455  1.00  0.00
ATOM    709  C   ASP    44     -10.318   3.044   5.904  1.00  1.00
ATOM    710  O   ASP    44     -11.076   3.725   5.217  1.00  1.00
ATOM    711  N   GLN    45      -9.273   3.550   6.546  1.00  1.00
ATOM    712  HN  GLN    45      -8.678   2.949   7.098  1.00  0.00
ATOM    713  CA  GLN    45      -8.959   4.970   6.474  1.00  1.00
ATOM    714  HA  GLN    45      -9.843   5.537   6.765  1.00  0.00
ATOM    715  CB  GLN    45      -7.818   5.297   7.443  1.00  1.00
ATOM    716 2HB  GLN    45      -7.048   4.529   7.368  1.00  0.00
ATOM    717 3HB  GLN    45      -7.391   6.266   7.186  1.00  0.00
ATOM    718  CG  GLN    45      -8.354   5.341   8.877  1.00  1.00
ATOM    719 2HG  GLN    45      -9.109   6.123   8.958  1.00  0.00
ATOM    720 3HG  GLN    45      -8.806   4.380   9.124  1.00  0.00
ATOM    721  CD  GLN    45      -7.219   5.631   9.851  1.00  1.00
ATOM    722  OE1 GLN    45      -6.424   6.544   9.625  1.00  1.00
ATOM    723  NE2 GLN    45      -7.097   4.907  10.929  1.00  1.00
ATOM    724 1HE2 GLN    45      -7.762   4.164  11.093  1.00  0.00
ATOM    725 2HE2 GLN    45      -6.351   5.088  11.584  1.00  0.00
ATOM    726  C   GLN    45      -8.566   5.364   5.053  1.00  1.00
ATOM    727  O   GLN    45      -8.921   6.442   4.575  1.00  1.00
ATOM    728  N   TYR    46      -7.828   4.486   4.386  1.00  1.00
ATOM    729  HN  TYR    46      -7.559   3.615   4.821  1.00  0.00
ATOM    730  CA  TYR    46      -7.388   4.752   3.020  1.00  1.00
ATOM    731  HA  TYR    46      -6.832   5.689   3.011  1.00  0.00
ATOM    732  CB  TYR    46      -6.472   3.628   2.537  1.00  1.00
ATOM    733 2HB  TYR    46      -5.591   3.572   3.176  1.00  0.00
ATOM    734 3HB  TYR    46      -7.001   2.676   2.587  1.00  0.00
ATOM    735  CG  TYR    46      -6.050   3.901   1.111  1.00  1.00
ATOM    736  CD1 TYR    46      -5.180   4.963   0.835  1.00  1.00
ATOM    737 1HD  TYR    46      -4.815   5.585   1.639  1.00  0.00
ATOM    738  CE1 TYR    46      -4.783   5.218  -0.482  1.00  1.00
ATOM    739 1HE  TYR    46      -4.112   6.037  -0.695  1.00  0.00
ATOM    740  CZ  TYR    46      -5.255   4.412  -1.524  1.00  1.00
ATOM    741  CE2 TYR    46      -6.124   3.349  -1.250  1.00  1.00
ATOM    742 2HE  TYR    46      -6.487   2.726  -2.054  1.00  0.00
ATOM    743  CD2 TYR    46      -6.522   3.093   0.068  1.00  1.00
ATOM    744 2HD  TYR    46      -7.192   2.273   0.280  1.00  0.00
ATOM    745  OH  TYR    46      -4.864   4.665  -2.823  1.00  1.00
ATOM    746  HH  TYR    46      -5.247   4.053  -3.456  1.00  0.00
ATOM    747  C   TYR    46      -8.587   4.882   2.086  1.00  1.00
ATOM    748  O   TYR    46      -8.663   5.812   1.284  1.00  1.00
ATOM    749  N   LEU    47      -9.521   3.946   2.202  1.00  1.00
ATOM    750  HN  LEU    47      -9.413   3.203   2.878  1.00  0.00
ATOM    751  CA  LEU    47     -10.719   3.963   1.364  1.00  1.00
ATOM    752  HA  LEU    47     -10.410   3.940   0.319  1.00  0.00
ATOM    753  CB  LEU    47     -11.583   2.731   1.653  1.00  1.00
ATOM    754 2HB  LEU    47     -11.671   2.595   2.731  1.00  0.00
ATOM    755 3HB  LEU    47     -12.574   2.875   1.223  1.00  0.00
ATOM    756  CG  LEU    47     -10.934   1.482   1.033  1.00  1.00
ATOM    757  HG  LEU    47      -9.885   1.443   1.325  1.00  0.00
ATOM    758  CD1 LEU    47     -11.649   0.228   1.554  1.00  1.00
ATOM    759 1HD1 LEU    47     -11.185  -0.661   1.126  1.00  0.00
ATOM    760 2HD1 LEU    47     -11.571   0.190   2.641  1.00  0.00
ATOM    761 3HD1 LEU    47     -12.700   0.262   1.266  1.00  0.00
ATOM    762  CD2 LEU    47     -11.025   1.534  -0.513  1.00  1.00
ATOM    763 1HD2 LEU    47     -10.558   0.646  -0.939  1.00  0.00
ATOM    764 2HD2 LEU    47     -12.072   1.571  -0.814  1.00  0.00
ATOM    765 3HD2 LEU    47     -10.511   2.423  -0.877  1.00  0.00
ATOM    766  C   LEU    47     -11.533   5.227   1.610  1.00  1.00
ATOM    767  O   LEU    47     -12.036   5.844   0.671  1.00  1.00
ATOM    768  N   ILE    48     -11.657   5.610   2.871  1.00  1.00
ATOM    769  HN  ILE    48     -11.225   5.077   3.613  1.00  0.00
ATOM    770  CA  ILE    48     -12.415   6.804   3.212  1.00  1.00
ATOM    771  HA  ILE    48     -13.439   6.684   2.859  1.00  0.00
ATOM    772  CB  ILE    48     -12.428   6.992   4.735  1.00  1.00
ATOM    773  HB  ILE    48     -11.411   6.900   5.115  1.00  0.00
ATOM    774  CG2 ILE    48     -12.973   8.378   5.090  1.00  1.00
ATOM    775 1HG2 ILE    48     -12.973   8.505   6.173  1.00  0.00
ATOM    776 2HG2 ILE    48     -12.344   9.142   4.635  1.00  0.00
ATOM    777 3HG2 ILE    48     -13.992   8.474   4.714  1.00  0.00
ATOM    778  CG1 ILE    48     -13.306   5.915   5.379  1.00  1.00
ATOM    779 2HG1 ILE    48     -14.354   6.122   5.160  1.00  0.00
ATOM    780 3HG1 ILE    48     -13.037   4.938   4.976  1.00  0.00
ATOM    781  CD1 ILE    48     -13.093   5.916   6.896  1.00  1.00
ATOM    782 1HD1 ILE    48     -13.720   5.149   7.352  1.00  0.00
ATOM    783 2HD1 ILE    48     -12.046   5.707   7.116  1.00  0.00
ATOM    784 3HD1 ILE    48     -13.362   6.892   7.300  1.00  0.00
ATOM    785  C   ILE    48     -11.797   8.028   2.543  1.00  1.00
ATOM    786  O   ILE    48     -12.506   8.858   1.976  1.00  1.00
END
