
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   57 (  458),  selected   57 , name 3bid_B
# Molecule2: number of CA atoms   60 (  910),  selected   60 , name T0472_1_51_102_100.pdb
# PARAMETERS: 3bid_B.T0472_1_51_102_100.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M       1           -
LGA    -       -      S       2           -
LGA    X     1_B      G       3          0.665
LGA    Y     2_B      W       4          0.708
LGA    F     3_B      Y       5          1.101
LGA    E     4_B      E       6          1.020
LGA    I     5_B      L       7          0.785
LGA    Y     6_B      S       8          1.004
LGA    K     7_B      K       9          0.525
LGA    D     8_B      S      10          1.473
LGA    A     9_B      S      11          2.265
LGA    K    10_B      N      12          2.840
LGA    G    11_B      D      13          1.986
LGA    E    12_B      Q      14          0.404
LGA    Y    13_B      F      15          0.613
LGA    R    14_B      K      16          0.770
LGA    W    15_B      F      17          0.920
LGA    R    16_B      V      18          0.831
LGA    L    17_B      L      19          0.506
LGA    K    18_B      K      20          0.927
LGA    A    19_B      A      21          1.995
LGA    A    20_B      G      22          1.317
LGA    N    21_B      N      23          1.006
LGA    H    22_B      G      24          0.890
LGA    E    23_B      E      25          1.011
LGA    I    24_B      V      26          1.052
LGA    I    25_B      I      27          0.939
LGA    A    26_B      L      28          1.374
LGA    Q    27_B      T      29          0.727
LGA    G    28_B      S      30          0.528
LGA    E    29_B      E      31          0.807
LGA    G    30_B      L      32          1.192
LGA    Y    31_B      Y      33          0.981
LGA    T    32_B      T      34          1.396
LGA    S    33_B      G      35          1.430
LGA    K    34_B      K      36          1.049
LGA    Q    35_B      S      37          1.378
LGA    N    36_B      G      38          1.572
LGA    C    37_B      A      39          0.991
LGA    Q    38_B      M      40          0.587
LGA    H    39_B      N      41          0.580
LGA    A    40_B      G      42          0.851
LGA    V    41_B      I      43          0.823
LGA    D    42_B      E      44          0.402
LGA    L    43_B      S      45          0.525
LGA    L    44_B      V      46          0.750
LGA    K    45_B      Q      47          1.025
LGA    S    46_B      T      48          1.249
LGA    T    47_B      N      49          1.502
LGA    T    48_B      S      50          3.939
LGA    A    49_B      P      51          3.293
LGA    A    50_B      K     102           -
LGA    T    51_B      T     103           -
LGA    P    52_B      T     104           -
LGA    V    53_B      T     105           -
LGA    K    54_B      I     106           -
LGA    E    55_B      K     107           -
LGA    V    56_B      D     108           -
LGA    L    57_B      L     109           -
LGA    -       -      T     110           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   57   60    5.0     49    1.35    24.49     78.041     3.381

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.368938 * X  +  -0.671494 * Y  +  -0.642636 * Z  +  -2.193056
  Y_new =   0.758942 * X  +   0.616783 * Y  +  -0.208771 * Z  +  -0.126663
  Z_new =   0.536555 * X  +  -0.410700 * Y  +   0.737180 * Z  +   1.530877 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.508295    2.633297  [ DEG:   -29.1232    150.8768 ]
  Theta =  -0.566350   -2.575243  [ DEG:   -32.4494   -147.5506 ]
  Phi   =   1.118313   -2.023280  [ DEG:    64.0746   -115.9254 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3bid_B                                        
REMARK     2: T0472_1_51_102_100.pdb                        
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3bid_B.T0472_1_51_102_100.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   57   60   5.0   49   1.35   24.49  78.041
REMARK  ---------------------------------------------------------- 
MOLECULE 3bid_B
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   30-NOV-07   3BID              
TITLE     CRYSTAL STRUCTURE OF THE NMB1088 PROTEIN FROM NEISSERIA               
TITLE    2 MENINGITIDIS. NORTHEAST STRUCTURAL GENOMICS CONSORTIUM               
TITLE    3 TARGET MR91                                                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UPF0339 PROTEIN NMB1088;                                   
COMPND   3 CHAIN: A, B, C, D, E, F, G, H;                                       
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: NEISSERIA MENINGITIDIS MC58;                    
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: MC58 / SEROGROUP B;                                          
SOURCE   5 GENE: NMB1088, 903505;                                               
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)+MAGIC;                           
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET21                                     
KEYWDS    ALPHA-BETA PROTEIN, STRUCTURAL GENOMICS, PSI-2, PROTEIN               
KEYWDS   2 STRUCTURE INITIATIVE, NORTHEAST STRUCTURAL GENOMICS                  
KEYWDS   3 CONSORTIUM, NESG, STRUCTURAL GENOMICS, UNKNOWN FUNCTION              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    F.FOROUHAR,H.NEELY,J.SEETHARAMAN,L.MAO,Y.FANG,R.XIAO,                 
AUTHOR   2 L.A.OWEN,M.MAGLAQUI,K.CUNNINGHAM,M.C.BARAN,T.B.ACTON,                
AUTHOR   3 G.T.MONTELIONE,L.TONG,J.F.HUNT,NORTHEAST STRUCTURAL                  
AUTHOR   4 GENOMICS CONSORTIUM (NESG)                                           
REVDAT   1   18-DEC-07 3BID    0                                                
JRNL        AUTH   F.FOROUHAR,H.NEELY,J.SEETHARAMAN,L.MAO,Y.FANG,               
JRNL        AUTH 2 R.XIAO,L.A.OWEN,M.MAGLAQUI,K.CUNNINGHAM,M.C.BARAN,           
JRNL        AUTH 3 T.B.ACTON,G.T.MONTELIONE,L.TONG,J.F.HUNT                     
JRNL        TITL   CRYSTAL STRUCTURE OF THE NMB1088 PROTEIN FROM                
JRNL        TITL 2 NEISSERIA MENINGITIDIS.                                      
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.70 ANGSTROMS.                                          
DBREF  3BID A    1    56  UNP    Q7DDI1   Y1088_NEIMB      1     56             
DBREF  3BID B    1    56  UNP    Q7DDI1   Y1088_NEIMB      1     56             
DBREF  3BID C    1    56  UNP    Q7DDI1   Y1088_NEIMB      1     56             
DBREF  3BID D    1    56  UNP    Q7DDI1   Y1088_NEIMB      1     56             
DBREF  3BID E    1    56  UNP    Q7DDI1   Y1088_NEIMB      1     56             
DBREF  3BID F    1    56  UNP    Q7DDI1   Y1088_NEIMB      1     56             
DBREF  3BID G    1    56  UNP    Q7DDI1   Y1088_NEIMB      1     56             
DBREF  3BID H    1    56  UNP    Q7DDI1   Y1088_NEIMB      1     56             
SEQRES   1 A   64  MSE TYR PHE GLU ILE TYR LYS ASP ALA LYS GLY GLU TYR          
SEQRES   2 A   64  ARG TRP ARG LEU LYS ALA ALA ASN HIS GLU ILE ILE ALA          
SEQRES   3 A   64  GLN GLY GLU GLY TYR THR SER LYS GLN ASN CYS GLN HIS          
SEQRES   4 A   64  ALA VAL ASP LEU LEU LYS SER THR THR ALA ALA THR PRO          
SEQRES   5 A   64  VAL LYS GLU VAL LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 B   64  MSE TYR PHE GLU ILE TYR LYS ASP ALA LYS GLY GLU TYR          
SEQRES   2 B   64  ARG TRP ARG LEU LYS ALA ALA ASN HIS GLU ILE ILE ALA          
SEQRES   3 B   64  GLN GLY GLU GLY TYR THR SER LYS GLN ASN CYS GLN HIS          
SEQRES   4 B   64  ALA VAL ASP LEU LEU LYS SER THR THR ALA ALA THR PRO          
SEQRES   5 B   64  VAL LYS GLU VAL LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 C   64  MSE TYR PHE GLU ILE TYR LYS ASP ALA LYS GLY GLU TYR          
SEQRES   2 C   64  ARG TRP ARG LEU LYS ALA ALA ASN HIS GLU ILE ILE ALA          
SEQRES   3 C   64  GLN GLY GLU GLY TYR THR SER LYS GLN ASN CYS GLN HIS          
SEQRES   4 C   64  ALA VAL ASP LEU LEU LYS SER THR THR ALA ALA THR PRO          
SEQRES   5 C   64  VAL LYS GLU VAL LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 D   64  MSE TYR PHE GLU ILE TYR LYS ASP ALA LYS GLY GLU TYR          
SEQRES   2 D   64  ARG TRP ARG LEU LYS ALA ALA ASN HIS GLU ILE ILE ALA          
SEQRES   3 D   64  GLN GLY GLU GLY TYR THR SER LYS GLN ASN CYS GLN HIS          
SEQRES   4 D   64  ALA VAL ASP LEU LEU LYS SER THR THR ALA ALA THR PRO          
SEQRES   5 D   64  VAL LYS GLU VAL LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 E   64  MSE TYR PHE GLU ILE TYR LYS ASP ALA LYS GLY GLU TYR          
SEQRES   2 E   64  ARG TRP ARG LEU LYS ALA ALA ASN HIS GLU ILE ILE ALA          
SEQRES   3 E   64  GLN GLY GLU GLY TYR THR SER LYS GLN ASN CYS GLN HIS          
SEQRES   4 E   64  ALA VAL ASP LEU LEU LYS SER THR THR ALA ALA THR PRO          
SEQRES   5 E   64  VAL LYS GLU VAL LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 F   64  MSE TYR PHE GLU ILE TYR LYS ASP ALA LYS GLY GLU TYR          
SEQRES   2 F   64  ARG TRP ARG LEU LYS ALA ALA ASN HIS GLU ILE ILE ALA          
SEQRES   3 F   64  GLN GLY GLU GLY TYR THR SER LYS GLN ASN CYS GLN HIS          
SEQRES   4 F   64  ALA VAL ASP LEU LEU LYS SER THR THR ALA ALA THR PRO          
SEQRES   5 F   64  VAL LYS GLU VAL LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 G   64  MSE TYR PHE GLU ILE TYR LYS ASP ALA LYS GLY GLU TYR          
SEQRES   2 G   64  ARG TRP ARG LEU LYS ALA ALA ASN HIS GLU ILE ILE ALA          
SEQRES   3 G   64  GLN GLY GLU GLY TYR THR SER LYS GLN ASN CYS GLN HIS          
SEQRES   4 G   64  ALA VAL ASP LEU LEU LYS SER THR THR ALA ALA THR PRO          
SEQRES   5 G   64  VAL LYS GLU VAL LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 H   64  MSE TYR PHE GLU ILE TYR LYS ASP ALA LYS GLY GLU TYR          
SEQRES   2 H   64  ARG TRP ARG LEU LYS ALA ALA ASN HIS GLU ILE ILE ALA          
SEQRES   3 H   64  GLN GLY GLU GLY TYR THR SER LYS GLN ASN CYS GLN HIS          
SEQRES   4 H   64  ALA VAL ASP LEU LEU LYS SER THR THR ALA ALA THR PRO          
SEQRES   5 H   64  VAL LYS GLU VAL LEU GLU HIS HIS HIS HIS HIS HIS              
HET    MSE  A   1       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  C   1       8                                                       
HET    MSE  D   1       8                                                       
HET    MSE  E   1       8                                                       
HET    MSE  F   1       8                                                       
HET    MSE  G   1       8                                                       
HET    MSE  H   1       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    8(C5 H11 N O2 SE)                                            
FORMUL   9  HOH   *28(H2 O)                                                     
CRYST1   34.743   60.040   64.370  89.39  90.81 103.97 P 1           8          
HETATM  469  N   MSE B   1       9.738   7.034  -5.034  1.00 53.10           N  
HETATM  470  CA  MSE B   1       8.498   6.422  -4.461  1.00 52.62           C  
HETATM  471  C   MSE B   1       7.314   6.583  -5.447  1.00 49.50           C  
HETATM  472  O   MSE B   1       7.001   7.696  -5.864  1.00 47.45           O  
HETATM  473  CB  MSE B   1       8.205   7.078  -3.094  1.00 57.46           C  
HETATM  474  CG  MSE B   1       7.213   6.314  -2.183  1.00 64.96           C  
HETATM  475 SE   MSE B   1       6.999   6.922  -0.264  1.00 78.41          SE  
HETATM  476  CE  MSE B   1       7.016   8.877  -0.543  1.00 71.80           C  
ATOM    477  N   TYR B   2       6.699   5.465  -5.853  1.00 47.17           N  
ATOM    478  CA  TYR B   2       5.540   5.495  -6.756  1.00 43.52           C  
ATOM    479  C   TYR B   2       4.632   4.277  -6.599  1.00 41.99           C  
ATOM    480  O   TYR B   2       5.067   3.214  -6.151  1.00 39.50           O  
ATOM    481  CB  TYR B   2       5.955   5.588  -8.227  1.00 43.70           C  
ATOM    482  CG  TYR B   2       6.759   4.405  -8.703  1.00 46.48           C  
ATOM    483  CD1 TYR B   2       8.112   4.289  -8.382  1.00 47.25           C  
ATOM    484  CD2 TYR B   2       6.165   3.383  -9.450  1.00 47.33           C  
ATOM    485  CE1 TYR B   2       8.860   3.190  -8.791  1.00 48.65           C  
ATOM    486  CE2 TYR B   2       6.903   2.270  -9.866  1.00 48.71           C  
ATOM    487  CZ  TYR B   2       8.258   2.185  -9.529  1.00 50.41           C  
ATOM    488  OH  TYR B   2       9.015   1.099  -9.934  1.00 52.38           O  
ATOM    489  N   PHE B   3       3.362   4.438  -6.971  1.00 40.05           N  
ATOM    490  CA  PHE B   3       2.404   3.334  -6.887  1.00 37.85           C  
ATOM    491  C   PHE B   3       2.395   2.609  -8.222  1.00 38.95           C  
ATOM    492  O   PHE B   3       2.723   3.192  -9.257  1.00 39.30           O  
ATOM    493  CB  PHE B   3       0.999   3.832  -6.572  1.00 32.50           C  
ATOM    494  CG  PHE B   3       0.787   4.206  -5.130  1.00 30.33           C  
ATOM    495  CD1 PHE B   3       0.951   5.517  -4.701  1.00 28.39           C  
ATOM    496  CD2 PHE B   3       0.397   3.245  -4.204  1.00 29.92           C  
ATOM    497  CE1 PHE B   3       0.702   5.881  -3.367  1.00 27.87           C  
ATOM    498  CE2 PHE B   3       0.144   3.585  -2.871  1.00 29.10           C  
ATOM    499  CZ  PHE B   3       0.304   4.911  -2.453  1.00 28.44           C  
ATOM    500  N   GLU B   4       2.012   1.337  -8.200  1.00 39.35           N  
ATOM    501  CA  GLU B   4       1.975   0.522  -9.413  1.00 39.65           C  
ATOM    502  C   GLU B   4       0.744  -0.395  -9.425  1.00 38.53           C  
ATOM    503  O   GLU B   4       0.596  -1.235  -8.543  1.00 37.37           O  
ATOM    504  CB  GLU B   4       3.251  -0.309  -9.478  1.00 41.29           C  
ATOM    505  CG  GLU B   4       3.590  -0.887 -10.826  1.00 46.20           C  
ATOM    506  CD  GLU B   4       4.927  -1.612 -10.805  1.00 52.44           C  
ATOM    507  OE1 GLU B   4       5.049  -2.641 -10.083  1.00 54.51           O  
ATOM    508  OE2 GLU B   4       5.870  -1.166 -11.513  1.00 55.32           O  
ATOM    509  N   ILE B   5      -0.124  -0.223 -10.427  1.00 35.85           N  
ATOM    510  CA  ILE B   5      -1.340  -1.015 -10.568  1.00 34.01           C  
ATOM    511  C   ILE B   5      -1.190  -2.080 -11.658  1.00 35.74           C  
ATOM    512  O   ILE B   5      -0.784  -1.771 -12.775  1.00 34.98           O  
ATOM    513  CB  ILE B   5      -2.547  -0.109 -10.903  1.00 33.43           C  
ATOM    514  CG1 ILE B   5      -2.785   0.854  -9.764  1.00 34.27           C  
ATOM    515  CG2 ILE B   5      -3.803  -0.959 -11.153  1.00 33.57           C  
ATOM    516  CD1 ILE B   5      -3.972   1.799  -9.982  1.00 31.84           C  
ATOM    517  N   TYR B   6      -1.526  -3.329 -11.332  1.00 36.00           N  
ATOM    518  CA  TYR B   6      -1.393  -4.424 -12.290  1.00 38.10           C  
ATOM    519  C   TYR B   6      -2.439  -5.514 -12.094  1.00 40.56           C  
ATOM    520  O   TYR B   6      -3.230  -5.456 -11.165  1.00 41.11           O  
ATOM    521  CB  TYR B   6      -0.002  -5.066 -12.187  1.00 37.52           C  
ATOM    522  CG  TYR B   6       0.273  -5.750 -10.866  1.00 37.17           C  
ATOM    523  CD1 TYR B   6       0.566  -5.004  -9.721  1.00 34.95           C  
ATOM    524  CD2 TYR B   6       0.183  -7.140 -10.753  1.00 35.75           C  
ATOM    525  CE1 TYR B   6       0.753  -5.621  -8.489  1.00 38.64           C  
ATOM    526  CE2 TYR B   6       0.373  -7.779  -9.531  1.00 38.95           C  
ATOM    527  CZ  TYR B   6       0.651  -7.011  -8.397  1.00 41.86           C  
ATOM    528  OH  TYR B   6       0.788  -7.625  -7.164  1.00 45.37           O  
ATOM    529  N   LYS B   7      -2.429  -6.513 -12.970  1.00 43.94           N  
ATOM    530  CA  LYS B   7      -3.371  -7.623 -12.887  1.00 48.33           C  
ATOM    531  C   LYS B   7      -2.581  -8.901 -12.584  1.00 50.19           C  
ATOM    532  O   LYS B   7      -1.669  -9.247 -13.328  1.00 50.23           O  
ATOM    533  CB  LYS B   7      -4.125  -7.752 -14.216  1.00 50.18           C  
ATOM    534  CG  LYS B   7      -5.001  -8.985 -14.313  1.00 52.98           C  
ATOM    535  CD  LYS B   7      -5.743  -9.084 -15.640  1.00 54.45           C  
ATOM    536  CE  LYS B   7      -6.758  -7.965 -15.818  1.00 55.62           C  
ATOM    537  NZ  LYS B   7      -7.604  -8.210 -17.028  1.00 56.01           N  
ATOM    538  N   ASP B   8      -2.879  -9.596 -11.488  1.00 53.17           N  
ATOM    539  CA  ASP B   8      -2.112 -10.810 -11.171  1.00 55.43           C  
ATOM    540  C   ASP B   8      -2.490 -12.021 -12.022  1.00 56.20           C  
ATOM    541  O   ASP B   8      -3.265 -11.898 -12.974  1.00 56.81           O  
ATOM    542  CB  ASP B   8      -2.203 -11.139  -9.672  1.00 57.26           C  
ATOM    543  CG  ASP B   8      -3.628 -11.201  -9.159  1.00 59.85           C  
ATOM    544  OD1 ASP B   8      -3.814 -11.123  -7.921  1.00 61.62           O  
ATOM    545  OD2 ASP B   8      -4.558 -11.339  -9.978  1.00 62.90           O  
ATOM    546  N   ALA B   9      -1.926 -13.182 -11.689  1.00 56.85           N  
ATOM    547  CA  ALA B   9      -2.183 -14.426 -12.437  1.00 57.52           C  
ATOM    548  C   ALA B   9      -3.572 -15.034 -12.222  1.00 57.67           C  
ATOM    549  O   ALA B   9      -4.093 -15.697 -13.114  1.00 59.52           O  
ATOM    550  CB  ALA B   9      -1.111 -15.464 -12.103  1.00 55.60           C  
ATOM    551  N   LYS B  10      -4.166 -14.794 -11.054  1.00 57.15           N  
ATOM    552  CA  LYS B  10      -5.483 -15.321 -10.735  1.00 55.59           C  
ATOM    553  C   LYS B  10      -6.572 -14.606 -11.507  1.00 54.28           C  
ATOM    554  O   LYS B  10      -7.610 -15.189 -11.809  1.00 55.35           O  
ATOM    555  CB  LYS B  10      -5.766 -15.193  -9.237  1.00 57.29           C  
ATOM    556  CG  LYS B  10      -5.135 -16.277  -8.378  1.00 58.11           C  
ATOM    557  CD  LYS B  10      -5.258 -15.968  -6.889  1.00 60.34           C  
ATOM    558  CE  LYS B  10      -6.705 -15.888  -6.420  1.00 61.23           C  
ATOM    559  NZ  LYS B  10      -6.812 -15.701  -4.930  1.00 61.96           N  
ATOM    560  N   GLY B  11      -6.345 -13.339 -11.816  1.00 53.39           N  
ATOM    561  CA  GLY B  11      -7.351 -12.590 -12.548  1.00 54.06           C  
ATOM    562  C   GLY B  11      -8.002 -11.431 -11.804  1.00 54.33           C  
ATOM    563  O   GLY B  11      -9.160 -11.105 -12.079  1.00 55.26           O  
ATOM    564  N   GLU B  12      -7.275 -10.804 -10.877  1.00 52.79           N  
ATOM    565  CA  GLU B  12      -7.802  -9.667 -10.117  1.00 50.58           C  
ATOM    566  C   GLU B  12      -6.833  -8.487 -10.041  1.00 48.16           C  
ATOM    567  O   GLU B  12      -5.622  -8.669 -10.091  1.00 48.93           O  
ATOM    568  CB  GLU B  12      -8.167 -10.102  -8.713  1.00 52.10           C  
ATOM    569  CG  GLU B  12      -7.001 -10.428  -7.838  1.00 54.44           C  
ATOM    570  CD  GLU B  12      -7.480 -11.116  -6.597  1.00 56.61           C  
ATOM    571  OE1 GLU B  12      -8.487 -10.633  -6.024  1.00 54.77           O  
ATOM    572  OE2 GLU B  12      -6.869 -12.137  -6.202  1.00 60.07           O  
ATOM    573  N   TYR B  13      -7.371  -7.280  -9.904  1.00 45.29           N  
ATOM    574  CA  TYR B  13      -6.558  -6.066  -9.858  1.00 44.74           C  
ATOM    575  C   TYR B  13      -5.931  -5.736  -8.510  1.00 43.04           C  
ATOM    576  O   TYR B  13      -6.584  -5.808  -7.468  1.00 42.60           O  
ATOM    577  CB  TYR B  13      -7.412  -4.866 -10.283  1.00 48.71           C  
ATOM    578  CG  TYR B  13      -7.923  -4.935 -11.693  1.00 50.74           C  
ATOM    579  CD1 TYR B  13      -7.074  -4.668 -12.777  1.00 50.60           C  
ATOM    580  CD2 TYR B  13      -9.234  -5.328 -11.949  1.00 50.55           C  
ATOM    581  CE1 TYR B  13      -7.522  -4.803 -14.086  1.00 53.07           C  
ATOM    582  CE2 TYR B  13      -9.692  -5.467 -13.243  1.00 53.34           C  
ATOM    583  CZ  TYR B  13      -8.837  -5.211 -14.312  1.00 54.91           C  
ATOM    584  OH  TYR B  13      -9.290  -5.407 -15.601  1.00 57.08           O  
ATOM    585  N   ARG B  14      -4.670  -5.332  -8.521  1.00 41.75           N  
ATOM    586  CA  ARG B  14      -4.039  -4.974  -7.261  1.00 41.18           C  
ATOM    587  C   ARG B  14      -2.971  -3.890  -7.362  1.00 38.98           C  
ATOM    588  O   ARG B  14      -2.584  -3.495  -8.454  1.00 37.53           O  
ATOM    589  CB  ARG B  14      -3.482  -6.223  -6.592  1.00 42.17           C  
ATOM    590  CG  ARG B  14      -2.856  -7.164  -7.540  1.00 42.25           C  
ATOM    591  CD  ARG B  14      -2.161  -8.236  -6.775  1.00 47.66           C  
ATOM    592  NE  ARG B  14      -2.893  -8.684  -5.606  1.00 49.24           N  
ATOM    593  CZ  ARG B  14      -2.409  -9.602  -4.786  1.00 50.83           C  
ATOM    594  NH1 ARG B  14      -3.090  -9.990  -3.712  1.00 52.24           N  
ATOM    595  NH2 ARG B  14      -1.226 -10.132  -5.060  1.00 52.63           N  
ATOM    596  N   TRP B  15      -2.510  -3.399  -6.218  1.00 37.85           N  
ATOM    597  CA  TRP B  15      -1.513  -2.334  -6.203  1.00 38.12           C  
ATOM    598  C   TRP B  15      -0.328  -2.644  -5.292  1.00 38.11           C  
ATOM    599  O   TRP B  15      -0.387  -3.558  -4.474  1.00 37.39           O  
ATOM    600  CB  TRP B  15      -2.162  -1.010  -5.754  1.00 37.90           C  
ATOM    601  CG  TRP B  15      -2.742  -1.065  -4.349  1.00 38.43           C  
ATOM    602  CD1 TRP B  15      -3.983  -1.507  -3.992  1.00 37.85           C  
ATOM    603  CD2 TRP B  15      -2.062  -0.755  -3.121  1.00 38.75           C  
ATOM    604  NE1 TRP B  15      -4.118  -1.504  -2.623  1.00 37.06           N  
ATOM    605  CE2 TRP B  15      -2.958  -1.049  -2.063  1.00 37.83           C  
ATOM    606  CE3 TRP B  15      -0.781  -0.274  -2.812  1.00 38.34           C  
ATOM    607  CZ2 TRP B  15      -2.622  -0.861  -0.719  1.00 38.74           C  
ATOM    608  CZ3 TRP B  15      -0.444  -0.092  -1.471  1.00 39.69           C  
ATOM    609  CH2 TRP B  15      -1.365  -0.389  -0.441  1.00 39.56           C  
ATOM    610  N   ARG B  16       0.744  -1.867  -5.442  1.00 40.55           N  
ATOM    611  CA  ARG B  16       1.957  -2.017  -4.633  1.00 43.33           C  
ATOM    612  C   ARG B  16       2.830  -0.752  -4.734  1.00 43.75           C  
ATOM    613  O   ARG B  16       3.010  -0.195  -5.823  1.00 42.10           O  
ATOM    614  CB  ARG B  16       2.761  -3.232  -5.107  1.00 45.94           C  
ATOM    615  CG  ARG B  16       3.321  -3.092  -6.516  1.00 50.44           C  
ATOM    616  CD  ARG B  16       4.541  -3.990  -6.717  1.00 55.08           C  
ATOM    617  NE  ARG B  16       4.181  -5.380  -6.970  1.00 58.95           N  
ATOM    618  CZ  ARG B  16       4.014  -5.903  -8.181  1.00 60.71           C  
ATOM    619  NH1 ARG B  16       3.685  -7.179  -8.303  1.00 61.82           N  
ATOM    620  NH2 ARG B  16       4.172  -5.154  -9.265  1.00 60.29           N  
ATOM    621  N   LEU B  17       3.376  -0.307  -3.603  1.00 45.44           N  
ATOM    622  CA  LEU B  17       4.229   0.889  -3.570  1.00 47.33           C  
ATOM    623  C   LEU B  17       5.717   0.545  -3.715  1.00 49.45           C  
ATOM    624  O   LEU B  17       6.274  -0.182  -2.899  1.00 49.82           O  
ATOM    625  CB  LEU B  17       4.029   1.648  -2.257  1.00 46.17           C  
ATOM    626  CG  LEU B  17       3.682   3.142  -2.346  1.00 44.52           C  
ATOM    627  CD1 LEU B  17       3.765   3.725  -0.950  1.00 45.36           C  
ATOM    628  CD2 LEU B  17       4.635   3.878  -3.261  1.00 43.48           C  
ATOM    629  N   LYS B  18       6.358   1.073  -4.750  1.00 52.46           N  
ATOM    630  CA  LYS B  18       7.767   0.807  -4.974  1.00 57.22           C  
ATOM    631  C   LYS B  18       8.647   1.984  -4.560  1.00 60.51           C  
ATOM    632  O   LYS B  18       8.247   3.147  -4.666  1.00 60.84           O  
ATOM    633  CB  LYS B  18       8.026   0.481  -6.444  1.00 57.64           C  
ATOM    634  CG  LYS B  18       7.626  -0.925  -6.873  1.00 59.61           C  
ATOM    635  CD  LYS B  18       7.917  -1.130  -8.363  1.00 60.60           C  
ATOM    636  CE  LYS B  18       7.632  -2.555  -8.830  1.00 60.89           C  
ATOM    637  NZ  LYS B  18       7.857  -2.691 -10.299  1.00 59.41           N  
ATOM    638  N   ALA B  19       9.855   1.671  -4.098  1.00 63.86           N  
ATOM    639  CA  ALA B  19      10.808   2.682  -3.664  1.00 67.71           C  
ATOM    640  C   ALA B  19      11.557   3.281  -4.849  1.00 70.69           C  
ATOM    641  O   ALA B  19      11.195   3.051  -6.006  1.00 72.22           O  
ATOM    642  CB  ALA B  19      11.785   2.073  -2.675  1.00 67.74           C  
ATOM    643  N   ALA B  20      12.606   4.048  -4.565  1.00 72.83           N  
ATOM    644  CA  ALA B  20      13.394   4.680  -5.625  1.00 74.74           C  
ATOM    645  C   ALA B  20      14.088   3.655  -6.525  1.00 76.23           C  
ATOM    646  O   ALA B  20      14.167   3.848  -7.740  1.00 76.43           O  
ATOM    647  CB  ALA B  20      14.430   5.615  -5.011  1.00 74.78           C  
ATOM    648  N   ASN B  21      14.571   2.572  -5.911  1.00 77.51           N  
ATOM    649  CA  ASN B  21      15.276   1.490  -6.602  1.00 78.67           C  
ATOM    650  C   ASN B  21      14.334   0.401  -7.119  1.00 80.02           C  
ATOM    651  O   ASN B  21      14.746  -0.744  -7.316  1.00 80.40           O  
ATOM    652  CB  ASN B  21      16.295   0.834  -5.662  1.00 77.94           C  
ATOM    653  CG  ASN B  21      15.635  -0.059  -4.609  1.00 77.91           C  
ATOM    654  OD1 ASN B  21      15.143   0.420  -3.583  1.00 76.62           O  
ATOM    655  ND2 ASN B  21      15.612  -1.365  -4.873  1.00 77.73           N  
ATOM    656  N   HIS B  22      13.072   0.754  -7.328  1.00 81.25           N  
ATOM    657  CA  HIS B  22      12.084  -0.200  -7.817  1.00 81.31           C  
ATOM    658  C   HIS B  22      11.875  -1.335  -6.801  1.00 80.29           C  
ATOM    659  O   HIS B  22      11.463  -2.437  -7.162  1.00 81.39           O  
ATOM    660  CB  HIS B  22      12.533  -0.753  -9.183  1.00 81.91           C  
ATOM    661  CG  HIS B  22      12.683   0.299 -10.244  1.00 84.26           C  
ATOM    662  ND1 HIS B  22      13.223   0.037 -11.487  1.00 84.84           N  
ATOM    663  CD2 HIS B  22      12.364   1.617 -10.246  1.00 84.94           C  
ATOM    664  CE1 HIS B  22      13.230   1.146 -12.206  1.00 84.72           C  
ATOM    665  NE2 HIS B  22      12.715   2.119 -11.478  1.00 84.74           N  
ATOM    666  N   GLU B  23      12.142  -1.052  -5.527  1.00 78.46           N  
ATOM    667  CA  GLU B  23      11.987  -2.044  -4.459  1.00 77.06           C  
ATOM    668  C   GLU B  23      10.574  -2.009  -3.867  1.00 73.76           C  
ATOM    669  O   GLU B  23      10.027  -0.938  -3.603  1.00 74.18           O  
ATOM    670  CB  GLU B  23      13.011  -1.783  -3.354  1.00 81.00           C  
ATOM    671  CG  GLU B  23      13.666  -3.032  -2.775  1.00 85.83           C  
ATOM    672  CD  GLU B  23      12.696  -3.925  -2.021  1.00 89.58           C  
ATOM    673  OE1 GLU B  23      12.045  -3.430  -1.075  1.00 91.62           O  
ATOM    674  OE2 GLU B  23      12.596  -5.125  -2.367  1.00 91.19           O  
ATOM    675  N   ILE B  24       9.986  -3.182  -3.651  1.00 69.42           N  
ATOM    676  CA  ILE B  24       8.635  -3.255  -3.105  1.00 64.94           C  
ATOM    677  C   ILE B  24       8.593  -2.868  -1.631  1.00 63.71           C  
ATOM    678  O   ILE B  24       9.246  -3.498  -0.798  1.00 62.99           O  
ATOM    679  CB  ILE B  24       8.026  -4.676  -3.244  1.00 62.46           C  
ATOM    680  CG1 ILE B  24       7.891  -5.078  -4.719  1.00 60.04           C  
ATOM    681  CG2 ILE B  24       6.667  -4.707  -2.588  1.00 61.98           C  
ATOM    682  CD1 ILE B  24       7.451  -6.514  -4.932  1.00 54.81           C  
ATOM    683  N   ILE B  25       7.806  -1.840  -1.314  1.00 62.04           N  
ATOM    684  CA  ILE B  25       7.663  -1.367   0.067  1.00 60.24           C  
ATOM    685  C   ILE B  25       6.366  -1.812   0.719  1.00 59.62           C  
ATOM    686  O   ILE B  25       6.287  -1.903   1.941  1.00 60.24           O  
ATOM    687  CB  ILE B  25       7.684   0.157   0.145  1.00 60.12           C  
ATOM    688  CG1 ILE B  25       9.033   0.672  -0.363  1.00 59.75           C  
ATOM    689  CG2 ILE B  25       7.373   0.610   1.583  1.00 59.93           C  
ATOM    690  CD1 ILE B  25       9.168   2.173  -0.334  1.00 59.09           C  
ATOM    691  N   ALA B  26       5.340  -2.057  -0.086  1.00 58.66           N  
ATOM    692  CA  ALA B  26       4.064  -2.491   0.460  1.00 58.84           C  
ATOM    693  C   ALA B  26       3.202  -3.151  -0.611  1.00 58.95           C  
ATOM    694  O   ALA B  26       3.219  -2.742  -1.769  1.00 60.47           O  
ATOM    695  CB  ALA B  26       3.328  -1.306   1.086  1.00 57.84           C  
ATOM    696  N   GLN B  27       2.466  -4.187  -0.219  1.00 58.91           N  
ATOM    697  CA  GLN B  27       1.591  -4.920  -1.129  1.00 58.94           C  
ATOM    698  C   GLN B  27       0.149  -4.695  -0.721  1.00 59.71           C  
ATOM    699  O   GLN B  27      -0.173  -4.621   0.471  1.00 59.44           O  
ATOM    700  CB  GLN B  27       1.881  -6.427  -1.077  1.00 59.39           C  
ATOM    701  CG  GLN B  27       2.734  -7.003  -2.212  1.00 59.47           C  
ATOM    702  CD  GLN B  27       2.031  -7.008  -3.574  1.00 60.39           C  
ATOM    703  OE1 GLN B  27       0.866  -7.406  -3.694  1.00 57.85           O  
ATOM    704  NE2 GLN B  27       2.754  -6.580  -4.613  1.00 61.65           N  
ATOM    705  N   GLY B  28      -0.720  -4.592  -1.720  1.00 60.72           N  
ATOM    706  CA  GLY B  28      -2.136  -4.397  -1.459  1.00 61.99           C  
ATOM    707  C   GLY B  28      -2.918  -5.697  -1.608  1.00 62.22           C  
ATOM    708  O   GLY B  28      -2.331  -6.766  -1.748  1.00 60.67           O  
ATOM    709  N   GLU B  29      -4.242  -5.606  -1.575  1.00 63.63           N  
ATOM    710  CA  GLU B  29      -5.081  -6.775  -1.714  1.00 65.77           C  
ATOM    711  C   GLU B  29      -5.860  -6.695  -3.015  1.00 65.80           C  
ATOM    712  O   GLU B  29      -5.826  -5.677  -3.714  1.00 65.90           O  
ATOM    713  CB  GLU B  29      -6.043  -6.901  -0.529  1.00 67.82           C  
ATOM    714  CG  GLU B  29      -6.440  -8.334  -0.243  1.00 72.46           C  
ATOM    715  CD  GLU B  29      -5.225  -9.216   0.030  1.00 74.86           C  
ATOM    716  OE1 GLU B  29      -5.366 -10.460   0.076  1.00 75.87           O  
ATOM    717  OE2 GLU B  29      -4.120  -8.659   0.202  1.00 76.34           O  
ATOM    718  N   GLY B  30      -6.581  -7.770  -3.324  1.00 65.23           N  
ATOM    719  CA  GLY B  30      -7.339  -7.846  -4.566  1.00 64.58           C  
ATOM    720  C   GLY B  30      -8.584  -7.004  -4.736  1.00 62.69           C  
ATOM    721  O   GLY B  30      -9.151  -6.483  -3.783  1.00 64.50           O  
ATOM    722  N   TYR B  31      -9.010  -6.876  -5.984  1.00 60.92           N  
ATOM    723  CA  TYR B  31     -10.199  -6.115  -6.294  1.00 59.57           C  
ATOM    724  C   TYR B  31     -10.921  -6.725  -7.486  1.00 61.12           C  
ATOM    725  O   TYR B  31     -10.348  -7.498  -8.257  1.00 61.57           O  
ATOM    726  CB  TYR B  31      -9.865  -4.655  -6.601  1.00 56.34           C  
ATOM    727  CG  TYR B  31      -9.485  -3.821  -5.401  1.00 52.37           C  
ATOM    728  CD1 TYR B  31      -8.179  -3.806  -4.916  1.00 49.89           C  
ATOM    729  CD2 TYR B  31     -10.430  -3.024  -4.768  1.00 49.60           C  
ATOM    730  CE1 TYR B  31      -7.826  -3.007  -3.831  1.00 47.71           C  
ATOM    731  CE2 TYR B  31     -10.093  -2.226  -3.684  1.00 47.31           C  
ATOM    732  CZ  TYR B  31      -8.791  -2.215  -3.218  1.00 47.11           C  
ATOM    733  OH  TYR B  31      -8.458  -1.396  -2.155  1.00 43.45           O  
ATOM    734  N   THR B  32     -12.187  -6.358  -7.621  1.00 62.27           N  
ATOM    735  CA  THR B  32     -13.040  -6.832  -8.687  1.00 61.76           C  
ATOM    736  C   THR B  32     -12.745  -6.153 -10.021  1.00 60.35           C  
ATOM    737  O   THR B  32     -12.218  -6.786 -10.922  1.00 60.27           O  
ATOM    738  CB  THR B  32     -14.517  -6.596  -8.323  1.00 64.56           C  
ATOM    739  OG1 THR B  32     -15.272  -6.394  -9.525  1.00 67.46           O  
ATOM    740  CG2 THR B  32     -14.656  -5.355  -7.417  1.00 65.24           C  
ATOM    741  N   SER B  33     -13.094  -4.874 -10.140  1.00 59.56           N  
ATOM    742  CA  SER B  33     -12.881  -4.116 -11.373  1.00 59.79           C  
ATOM    743  C   SER B  33     -11.658  -3.214 -11.243  1.00 60.34           C  
ATOM    744  O   SER B  33     -11.229  -2.929 -10.131  1.00 60.61           O  
ATOM    745  CB  SER B  33     -14.094  -3.237 -11.670  1.00 59.83           C  
ATOM    746  OG  SER B  33     -14.042  -2.045 -10.907  1.00 58.80           O  
ATOM    747  N   LYS B  34     -11.112  -2.745 -12.368  1.00 60.85           N  
ATOM    748  CA  LYS B  34      -9.948  -1.862 -12.330  1.00 61.48           C  
ATOM    749  C   LYS B  34     -10.342  -0.508 -11.749  1.00 61.48           C  
ATOM    750  O   LYS B  34      -9.528   0.196 -11.153  1.00 61.18           O  
ATOM    751  CB  LYS B  34      -9.367  -1.659 -13.733  1.00 59.93           C  
ATOM    752  CG  LYS B  34      -8.088  -0.839 -13.721  1.00 60.54           C  
ATOM    753  CD  LYS B  34      -7.505  -0.666 -15.105  1.00 61.77           C  
ATOM    754  CE  LYS B  34      -8.322   0.305 -15.933  1.00 62.04           C  
ATOM    755  NZ  LYS B  34      -7.705   0.506 -17.273  1.00 63.35           N  
ATOM    756  N   GLN B  35     -11.608  -0.155 -11.923  1.00 62.87           N  
ATOM    757  CA  GLN B  35     -12.117   1.112 -11.438  1.00 63.83           C  
ATOM    758  C   GLN B  35     -12.046   1.181  -9.922  1.00 62.12           C  
ATOM    759  O   GLN B  35     -11.549   2.153  -9.356  1.00 62.03           O  
ATOM    760  CB  GLN B  35     -13.556   1.303 -11.914  1.00 67.20           C  
ATOM    761  CG  GLN B  35     -14.207   2.597 -11.461  1.00 73.01           C  
ATOM    762  CD  GLN B  35     -13.561   3.829 -12.072  1.00 76.41           C  
ATOM    763  OE1 GLN B  35     -12.408   4.157 -11.780  1.00 77.72           O  
ATOM    764  NE2 GLN B  35     -14.303   4.512 -12.942  1.00 79.38           N  
ATOM    765  N   ASN B  36     -12.530   0.145  -9.255  1.00 59.79           N  
ATOM    766  CA  ASN B  36     -12.504   0.144  -7.800  1.00 57.63           C  
ATOM    767  C   ASN B  36     -11.095   0.198  -7.221  1.00 55.62           C  
ATOM    768  O   ASN B  36     -10.875   0.783  -6.167  1.00 55.27           O  
ATOM    769  CB  ASN B  36     -13.229  -1.088  -7.262  1.00 58.46           C  
ATOM    770  CG  ASN B  36     -14.692  -1.109  -7.643  1.00 59.64           C  
ATOM    771  OD1 ASN B  36     -15.388  -0.093  -7.538  1.00 61.14           O  
ATOM    772  ND2 ASN B  36     -15.173  -2.266  -8.076  1.00 59.19           N  
ATOM    773  N   CYS B  37     -10.144  -0.412  -7.916  1.00 53.42           N  
ATOM    774  CA  CYS B  37      -8.770  -0.440  -7.452  1.00 50.59           C  
ATOM    775  C   CYS B  37      -8.150   0.936  -7.521  1.00 50.32           C  
ATOM    776  O   CYS B  37      -7.413   1.353  -6.633  1.00 48.36           O  
ATOM    777  CB  CYS B  37      -7.947  -1.399  -8.301  1.00 49.24           C  
ATOM    778  SG  CYS B  37      -6.257  -1.626  -7.713  1.00 45.90           S  
ATOM    779  N   GLN B  38      -8.449   1.646  -8.596  1.00 50.60           N  
ATOM    780  CA  GLN B  38      -7.906   2.975  -8.777  1.00 50.52           C  
ATOM    781  C   GLN B  38      -8.468   3.961  -7.745  1.00 47.94           C  
ATOM    782  O   GLN B  38      -7.769   4.869  -7.289  1.00 47.86           O  
ATOM    783  CB  GLN B  38      -8.193   3.438 -10.204  1.00 53.18           C  
ATOM    784  CG  GLN B  38      -7.411   4.655 -10.629  1.00 59.56           C  
ATOM    785  CD  GLN B  38      -7.608   4.952 -12.098  1.00 63.51           C  
ATOM    786  OE1 GLN B  38      -7.346   4.097 -12.945  1.00 65.41           O  
ATOM    787  NE2 GLN B  38      -8.074   6.163 -12.415  1.00 64.55           N  
ATOM    788  N   HIS B  39      -9.724   3.771  -7.366  1.00 45.55           N  
ATOM    789  CA  HIS B  39     -10.368   4.636  -6.384  1.00 42.63           C  
ATOM    790  C   HIS B  39      -9.719   4.463  -5.018  1.00 40.53           C  
ATOM    791  O   HIS B  39      -9.523   5.437  -4.297  1.00 40.34           O  
ATOM    792  CB  HIS B  39     -11.863   4.303  -6.318  1.00 44.61           C  
ATOM    793  CG  HIS B  39     -12.661   5.225  -5.448  1.00 45.68           C  
ATOM    794  ND1 HIS B  39     -12.682   6.589  -5.631  1.00 46.19           N  
ATOM    795  CD2 HIS B  39     -13.454   4.973  -4.379  1.00 46.29           C  
ATOM    796  CE1 HIS B  39     -13.450   7.142  -4.706  1.00 47.30           C  
ATOM    797  NE2 HIS B  39     -13.928   6.183  -3.934  1.00 47.97           N  
ATOM    798  N   ALA B  40      -9.389   3.220  -4.666  1.00 39.32           N  
ATOM    799  CA  ALA B  40      -8.739   2.920  -3.393  1.00 36.35           C  
ATOM    800  C   ALA B  40      -7.393   3.628  -3.311  1.00 35.10           C  
ATOM    801  O   ALA B  40      -7.084   4.228  -2.291  1.00 35.66           O  
ATOM    802  CB  ALA B  40      -8.549   1.424  -3.251  1.00 35.77           C  
ATOM    803  N   VAL B  41      -6.612   3.576  -4.390  1.00 34.22           N  
ATOM    804  CA  VAL B  41      -5.306   4.220  -4.412  1.00 35.70           C  
ATOM    805  C   VAL B  41      -5.391   5.725  -4.238  1.00 37.98           C  
ATOM    806  O   VAL B  41      -4.580   6.311  -3.528  1.00 38.97           O  
ATOM    807  CB  VAL B  41      -4.547   3.901  -5.711  1.00 37.42           C  
ATOM    808  CG1 VAL B  41      -3.226   4.653  -5.754  1.00 38.97           C  
ATOM    809  CG2 VAL B  41      -4.283   2.399  -5.808  1.00 38.40           C  
ATOM    810  N   ASP B  42      -6.379   6.355  -4.871  1.00 41.44           N  
ATOM    811  CA  ASP B  42      -6.548   7.803  -4.745  1.00 43.33           C  
ATOM    812  C   ASP B  42      -6.882   8.185  -3.308  1.00 42.29           C  
ATOM    813  O   ASP B  42      -6.433   9.227  -2.810  1.00 41.99           O  
ATOM    814  CB  ASP B  42      -7.645   8.320  -5.691  1.00 48.50           C  
ATOM    815  CG  ASP B  42      -7.226   8.272  -7.159  1.00 53.73           C  
ATOM    816  OD1 ASP B  42      -6.085   8.703  -7.481  1.00 56.00           O  
ATOM    817  OD2 ASP B  42      -8.044   7.821  -8.001  1.00 56.79           O  
ATOM    818  N   LEU B  43      -7.679   7.357  -2.638  1.00 41.58           N  
ATOM    819  CA  LEU B  43      -8.035   7.635  -1.243  1.00 42.30           C  
ATOM    820  C   LEU B  43      -6.809   7.505  -0.329  1.00 41.68           C  
ATOM    821  O   LEU B  43      -6.623   8.319   0.578  1.00 41.28           O  
ATOM    822  CB  LEU B  43      -9.154   6.692  -0.776  1.00 41.88           C  
ATOM    823  CG  LEU B  43     -10.555   7.069  -1.311  1.00 41.69           C  
ATOM    824  CD1 LEU B  43     -11.531   5.923  -1.083  1.00 42.66           C  
ATOM    825  CD2 LEU B  43     -11.041   8.337  -0.634  1.00 38.43           C  
ATOM    826  N   LEU B  44      -5.974   6.495  -0.578  1.00 40.46           N  
ATOM    827  CA  LEU B  44      -4.773   6.298   0.217  1.00 39.61           C  
ATOM    828  C   LEU B  44      -3.854   7.493   0.085  1.00 41.12           C  
ATOM    829  O   LEU B  44      -3.346   8.001   1.080  1.00 42.27           O  
ATOM    830  CB  LEU B  44      -4.026   5.048  -0.232  1.00 37.91           C  
ATOM    831  CG  LEU B  44      -4.494   3.732   0.378  1.00 37.19           C  
ATOM    832  CD1 LEU B  44      -3.938   2.578  -0.428  1.00 36.94           C  
ATOM    833  CD2 LEU B  44      -4.042   3.659   1.832  1.00 37.12           C  
ATOM    834  N   LYS B  45      -3.637   7.954  -1.140  1.00 41.92           N  
ATOM    835  CA  LYS B  45      -2.751   9.092  -1.337  1.00 43.52           C  
ATOM    836  C   LYS B  45      -3.342  10.433  -0.886  1.00 44.67           C  
ATOM    837  O   LYS B  45      -2.613  11.416  -0.750  1.00 44.06           O  
ATOM    838  CB  LYS B  45      -2.306   9.164  -2.802  1.00 46.65           C  
ATOM    839  CG  LYS B  45      -3.435   9.186  -3.803  1.00 49.74           C  
ATOM    840  CD  LYS B  45      -2.934   8.857  -5.208  1.00 49.51           C  
ATOM    841  CE  LYS B  45      -1.960   9.894  -5.712  1.00 48.23           C  
ATOM    842  NZ  LYS B  45      -1.830   9.778  -7.176  1.00 48.40           N  
ATOM    843  N   SER B  46      -4.649  10.484  -0.644  1.00 45.45           N  
ATOM    844  CA  SER B  46      -5.260  11.727  -0.184  1.00 45.69           C  
ATOM    845  C   SER B  46      -5.120  11.781   1.335  1.00 44.93           C  
ATOM    846  O   SER B  46      -5.511  12.758   1.967  1.00 43.42           O  
ATOM    847  CB  SER B  46      -6.745  11.792  -0.550  1.00 44.89           C  
ATOM    848  OG  SER B  46      -7.511  10.992   0.325  1.00 47.95           O  
ATOM    849  N   THR B  47      -4.594  10.698   1.904  1.00 44.71           N  
ATOM    850  CA  THR B  47      -4.363  10.564   3.344  1.00 46.61           C  
ATOM    851  C   THR B  47      -3.198  11.447   3.790  1.00 47.15           C  
ATOM    852  O   THR B  47      -2.153  11.481   3.143  1.00 47.20           O  
ATOM    853  CB  THR B  47      -3.993   9.117   3.709  1.00 46.81           C  
ATOM    854  OG1 THR B  47      -5.182   8.343   3.890  1.00 48.88           O  
ATOM    855  CG2 THR B  47      -3.164   9.081   4.967  1.00 49.41           C  
ATOM    856  N   THR B  48      -3.356  12.127   4.918  1.00 47.79           N  
ATOM    857  CA  THR B  48      -2.307  13.016   5.407  1.00 49.10           C  
ATOM    858  C   THR B  48      -1.600  12.482   6.665  1.00 48.89           C  
ATOM    859  O   THR B  48      -1.909  11.390   7.138  1.00 49.28           O  
ATOM    860  CB  THR B  48      -2.910  14.425   5.671  1.00 50.20           C  
ATOM    861  OG1 THR B  48      -1.871  15.334   6.038  1.00 54.28           O  
ATOM    862  CG2 THR B  48      -3.960  14.370   6.778  1.00 48.42           C  
ATOM    863  N   ALA B  49      -0.641  13.236   7.194  1.00 47.81           N  
ATOM    864  CA  ALA B  49       0.076  12.809   8.394  1.00 47.79           C  
ATOM    865  C   ALA B  49      -0.774  13.081   9.632  1.00 47.50           C  
ATOM    866  O   ALA B  49      -0.354  12.835  10.762  1.00 47.46           O  
ATOM    867  CB  ALA B  49       1.412  13.534   8.497  1.00 48.02           C  
ATOM    868  N   ALA B  50      -1.978  13.594   9.399  1.00 46.46           N  
ATOM    869  CA  ALA B  50      -2.935  13.882  10.460  1.00 43.79           C  
ATOM    870  C   ALA B  50      -4.028  12.787  10.491  1.00 42.93           C  
ATOM    871  O   ALA B  50      -5.029  12.916  11.194  1.00 42.19           O  
ATOM    872  CB  ALA B  50      -3.559  15.257  10.236  1.00 44.81           C  
ATOM    873  N   THR B  51      -3.846  11.721   9.709  1.00 41.33           N  
ATOM    874  CA  THR B  51      -4.794  10.606   9.703  1.00 39.42           C  
ATOM    875  C   THR B  51      -4.426   9.711  10.900  1.00 37.73           C  
ATOM    876  O   THR B  51      -3.304   9.177  10.980  1.00 35.90           O  
ATOM    877  CB  THR B  51      -4.698   9.772   8.387  1.00 40.75           C  
ATOM    878  OG1 THR B  51      -5.163  10.560   7.284  1.00 43.79           O  
ATOM    879  CG2 THR B  51      -5.539   8.512   8.477  1.00 39.10           C  
ATOM    880  N   PRO B  52      -5.359   9.553  11.854  1.00 35.73           N  
ATOM    881  CA  PRO B  52      -5.176   8.744  13.064  1.00 36.39           C  
ATOM    882  C   PRO B  52      -4.833   7.255  12.841  1.00 38.01           C  
ATOM    883  O   PRO B  52      -5.316   6.634  11.890  1.00 37.87           O  
ATOM    884  CB  PRO B  52      -6.494   8.960  13.816  1.00 35.42           C  
ATOM    885  CG  PRO B  52      -7.476   9.295  12.726  1.00 32.78           C  
ATOM    886  CD  PRO B  52      -6.693  10.175  11.825  1.00 34.17           C  
ATOM    887  N   VAL B  53      -3.987   6.697  13.714  1.00 39.13           N  
ATOM    888  CA  VAL B  53      -3.570   5.286  13.638  1.00 38.58           C  
ATOM    889  C   VAL B  53      -4.033   4.639  14.938  1.00 38.63           C  
ATOM    890  O   VAL B  53      -3.534   4.976  16.008  1.00 40.42           O  
ATOM    891  CB  VAL B  53      -2.028   5.159  13.503  1.00 37.97           C  
ATOM    892  CG1 VAL B  53      -1.633   3.734  13.092  1.00 37.39           C  
ATOM    893  CG2 VAL B  53      -1.531   6.152  12.469  1.00 38.35           C  
ATOM    894  N   LYS B  54      -4.985   3.713  14.831  1.00 37.91           N  
ATOM    895  CA  LYS B  54      -5.578   3.053  15.991  1.00 38.35           C  
ATOM    896  C   LYS B  54      -5.337   1.546  16.059  1.00 40.43           C  
ATOM    897  O   LYS B  54      -5.367   0.845  15.042  1.00 40.06           O  
ATOM    898  CB  LYS B  54      -7.099   3.295  16.013  1.00 38.23           C  
ATOM    899  CG  LYS B  54      -7.568   4.727  16.301  1.00 37.30           C  
ATOM    900  CD  LYS B  54      -9.068   4.918  15.948  1.00 37.10           C  
ATOM    901  CE  LYS B  54      -9.571   6.363  16.216  1.00 37.60           C  
ATOM    902  NZ  LYS B  54     -10.862   6.751  15.534  1.00 35.68           N  
ATOM    903  N   GLU B  55      -5.119   1.041  17.269  1.00 43.08           N  
ATOM    904  CA  GLU B  55      -4.903  -0.389  17.451  1.00 44.22           C  
ATOM    905  C   GLU B  55      -6.009  -1.011  18.315  1.00 44.09           C  
ATOM    906  O   GLU B  55      -6.355  -0.501  19.381  1.00 43.89           O  
ATOM    907  CB  GLU B  55      -3.498  -0.637  18.037  1.00 45.62           C  
ATOM    908  CG  GLU B  55      -3.330  -1.958  18.806  1.00 49.95           C  
ATOM    909  CD  GLU B  55      -1.869  -2.388  18.989  1.00 53.79           C  
ATOM    910  OE1 GLU B  55      -1.229  -2.791  17.991  1.00 55.67           O  
ATOM    911  OE2 GLU B  55      -1.349  -2.340  20.131  1.00 54.95           O  
ATOM    912  N   VAL B  56      -6.566  -2.105  17.798  1.00 44.21           N  
ATOM    913  CA  VAL B  56      -7.629  -2.895  18.429  1.00 44.90           C  
ATOM    914  C   VAL B  56      -7.015  -3.749  19.549  1.00 47.18           C  
ATOM    915  O   VAL B  56      -6.200  -4.638  19.292  1.00 46.62           O  
ATOM    916  CB  VAL B  56      -8.276  -3.889  17.406  1.00 44.47           C  
ATOM    917  CG1 VAL B  56      -9.298  -4.782  18.085  1.00 42.94           C  
ATOM    918  CG2 VAL B  56      -8.901  -3.128  16.262  1.00 43.66           C  
ATOM    919  N   LEU B  57      -7.405  -3.483  20.788  1.00 48.47           N  
ATOM    920  CA  LEU B  57      -6.895  -4.244  21.906  1.00 49.16           C  
ATOM    921  C   LEU B  57      -8.069  -4.808  22.658  1.00 50.21           C  
ATOM    922  O   LEU B  57      -8.026  -5.999  23.050  1.00 52.94           O  
ATOM    923  CB  LEU B  57      -6.040  -3.363  22.810  1.00 47.88           C  
ATOM    924  CG  LEU B  57      -6.657  -2.094  23.370  1.00 47.34           C  
ATOM    925  CD1 LEU B  57      -7.551  -2.418  24.549  1.00 48.07           C  
ATOM    926  CD2 LEU B  57      -5.545  -1.151  23.814  1.00 47.75           C  
TER     927      LEU B  57                                                      
END
MOLECULE T0472_1_51_102_100.pdb
ATOM      1  N   MET     1       9.133  12.968  -2.784  1.00 43.14           N  
ATOM      2  CA  MET     1       8.345  11.878  -3.427  1.00 43.44           C  
ATOM      3  C   MET     1       9.259  10.975  -4.276  1.00  1.32           C  
ATOM      4  O   MET     1       9.403  11.181  -5.480  1.00  4.13           O  
ATOM      5  CB  MET     1       7.231  12.463  -4.311  1.00 41.12           C  
ATOM      6  CG  MET     1       6.300  13.433  -3.593  1.00 70.41           C  
ATOM      7  SD  MET     1       5.023  14.089  -4.687  1.00 54.53           S  
ATOM      8  CE  MET     1       4.245  15.300  -3.619  1.00 10.43           C  
ATOM      9  H1  MET     1       9.887  12.563  -2.191  1.00 37.41           H  
ATOM     10  H2  MET     1       8.518  13.561  -2.186  1.00 37.41           H  
ATOM     11  H3  MET     1       9.573  13.572  -3.511  1.00 37.41           H  
ATOM     12  HA  MET     1       7.898  11.280  -2.643  1.00 10.24           H  
ATOM     13  HB2 MET     1       7.684  12.989  -5.139  1.00 37.41           H  
ATOM     14  HB3 MET     1       6.634  11.650  -4.700  1.00 37.41           H  
ATOM     15  HG2 MET     1       5.821  12.916  -2.774  1.00 37.41           H  
ATOM     16  HG3 MET     1       6.883  14.256  -3.206  1.00 37.41           H  
ATOM     17  HE1 MET     1       3.845  14.807  -2.744  1.00 37.41           H  
ATOM     18  HE2 MET     1       3.443  15.788  -4.154  1.00 37.41           H  
ATOM     19  HE3 MET     1       4.974  16.037  -3.314  1.00 37.41           H  
ATOM     20  N   SER     2       9.886   9.990  -3.637  1.00 63.42           N  
ATOM     21  CA  SER     2      10.874   9.125  -4.307  1.00 41.35           C  
ATOM     22  C   SER     2      10.235   7.904  -4.990  1.00 44.41           C  
ATOM     23  O   SER     2      10.859   7.263  -5.836  1.00 64.32           O  
ATOM     24  CB  SER     2      11.923   8.645  -3.291  1.00 62.12           C  
ATOM     25  OG  SER     2      12.574   9.740  -2.656  1.00  2.50           O  
ATOM     26  H   SER     2       9.701   9.848  -2.682  1.00 37.41           H  
ATOM     27  HA  SER     2      11.374   9.718  -5.061  1.00 54.33           H  
ATOM     28  HB2 SER     2      11.439   8.046  -2.533  1.00 37.41           H  
ATOM     29  HB3 SER     2      12.668   8.046  -3.798  1.00 37.41           H  
ATOM     30  HG  SER     2      12.000  10.099  -1.964  1.00  4.15           H  
ATOM     31  N   GLY     3       8.992   7.593  -4.637  1.00 75.03           N  
ATOM     32  CA  GLY     3       8.365   6.357  -5.110  1.00 53.14           C  
ATOM     33  C   GLY     3       7.171   6.559  -6.038  1.00 60.02           C  
ATOM     34  O   GLY     3       6.764   7.688  -6.319  1.00 54.15           O  
ATOM     35  H   GLY     3       8.494   8.202  -4.062  1.00 37.41           H  
ATOM     36  HA2 GLY     3       9.107   5.767  -5.632  1.00 37.41           H  
ATOM     37  HA3 GLY     3       8.034   5.797  -4.247  1.00 37.41           H  
ATOM     38  N   TRP     4       6.603   5.443  -6.503  1.00 62.23           N  
ATOM     39  CA  TRP     4       5.490   5.464  -7.462  1.00 53.24           C  
ATOM     40  C   TRP     4       4.594   4.222  -7.304  1.00 54.24           C  
ATOM     41  O   TRP     4       4.936   3.281  -6.579  1.00 44.23           O  
ATOM     42  CB  TRP     4       6.036   5.524  -8.896  1.00 10.44           C  
ATOM     43  CG  TRP     4       6.747   4.270  -9.314  1.00 32.04           C  
ATOM     44  CD1 TRP     4       6.224   3.237 -10.039  1.00 71.44           C  
ATOM     45  CD2 TRP     4       8.100   3.905  -9.018  1.00 13.20           C  
ATOM     46  NE1 TRP     4       7.168   2.263 -10.217  1.00 61.42           N  
ATOM     47  CE2 TRP     4       8.328   2.647  -9.600  1.00 45.30           C  
ATOM     48  CE3 TRP     4       9.142   4.523  -8.318  1.00 25.24           C  
ATOM     49  CZ2 TRP     4       9.553   1.991  -9.506  1.00 52.13           C  
ATOM     50  CZ3 TRP     4      10.358   3.871  -8.226  1.00 73.25           C  
ATOM     51  CH2 TRP     4      10.554   2.618  -8.816  1.00  5.23           C  
ATOM     52  H   TRP     4       6.940   4.580  -6.189  1.00 37.41           H  
ATOM     53  HA  TRP     4       4.900   6.348  -7.272  1.00 54.13           H  
ATOM     54  HB2 TRP     4       5.218   5.690  -9.581  1.00 37.41           H  
ATOM     55  HB3 TRP     4       6.735   6.347  -8.976  1.00 37.41           H  
ATOM     56  HD1 TRP     4       5.211   3.205 -10.413  1.00 41.45           H  
ATOM     57  HE1 TRP     4       7.034   1.429 -10.712  1.00 73.22           H  
ATOM     58  HE3 TRP     4       9.009   5.490  -7.857  1.00 10.05           H  
ATOM     59  HZ2 TRP     4       9.714   1.021  -9.952  1.00 70.05           H  
ATOM     60  HZ3 TRP     4      11.174   4.331  -7.688  1.00 24.30           H  
ATOM     61  HH2 TRP     4      11.521   2.146  -8.716  1.00 52.45           H  
ATOM     62  N   TYR     5       3.460   4.218  -8.005  1.00 42.30           N  
ATOM     63  CA  TYR     5       2.510   3.097  -7.957  1.00 50.41           C  
ATOM     64  C   TYR     5       2.527   2.271  -9.253  1.00 31.42           C  
ATOM     65  O   TYR     5       2.631   2.816 -10.353  1.00 52.13           O  
ATOM     66  CB  TYR     5       1.087   3.616  -7.708  1.00 22.52           C  
ATOM     67  CG  TYR     5       0.862   4.157  -6.310  1.00 11.51           C  
ATOM     68  CD1 TYR     5       1.120   5.489  -6.002  1.00 21.33           C  
ATOM     69  CD2 TYR     5       0.384   3.331  -5.298  1.00 41.02           C  
ATOM     70  CE1 TYR     5       0.911   5.979  -4.726  1.00  4.11           C  
ATOM     71  CE2 TYR     5       0.172   3.815  -4.022  1.00  0.53           C  
ATOM     72  CZ  TYR     5       0.438   5.138  -3.742  1.00 23.25           C  
ATOM     73  OH  TYR     5       0.230   5.621  -2.472  1.00  1.02           O  
ATOM     74  H   TYR     5       3.255   4.990  -8.575  1.00 37.41           H  
ATOM     75  HA  TYR     5       2.793   2.454  -7.135  1.00 50.15           H  
ATOM     76  HB2 TYR     5       0.876   4.411  -8.408  1.00 37.41           H  
ATOM     77  HB3 TYR     5       0.384   2.809  -7.870  1.00 37.41           H  
ATOM     78  HD1 TYR     5       1.491   6.147  -6.776  1.00 42.22           H  
ATOM     79  HD2 TYR     5       0.177   2.292  -5.519  1.00 61.25           H  
ATOM     80  HE1 TYR     5       1.118   7.016  -4.506  1.00 44.53           H  
ATOM     81  HE2 TYR     5      -0.199   3.156  -3.251  1.00 11.50           H  
ATOM     82  HH  TYR     5      -0.161   6.501  -2.521  1.00 40.41           H  
ATOM     83  N   GLU     6       2.420   0.953  -9.109  1.00  1.12           N  
ATOM     84  CA  GLU     6       2.292   0.035 -10.252  1.00 73.13           C  
ATOM     85  C   GLU     6       1.107  -0.924 -10.061  1.00 15.03           C  
ATOM     86  O   GLU     6       1.108  -1.750  -9.148  1.00 55.41           O  
ATOM     87  CB  GLU     6       3.585  -0.776 -10.446  1.00 14.14           C  
ATOM     88  CG  GLU     6       4.684  -0.030 -11.196  1.00 40.20           C  
ATOM     89  CD  GLU     6       6.000  -0.797 -11.250  1.00 32.34           C  
ATOM     90  OE1 GLU     6       6.043  -1.972 -10.832  1.00 42.31           O  
ATOM     91  OE2 GLU     6       7.020  -0.206 -11.660  1.00 43.22           O  
ATOM     92  H   GLU     6       2.436   0.578  -8.203  1.00 37.41           H  
ATOM     93  HA  GLU     6       2.114   0.630 -11.139  1.00 53.04           H  
ATOM     94  HB2 GLU     6       3.969  -1.047  -9.474  1.00 37.41           H  
ATOM     95  HB3 GLU     6       3.355  -1.679 -10.995  1.00 37.41           H  
ATOM     96  HG2 GLU     6       4.351   0.150 -12.208  1.00 37.41           H  
ATOM     97  HG3 GLU     6       4.857   0.916 -10.703  1.00 37.41           H  
ATOM     98  N   LEU     7       0.099  -0.804 -10.920  1.00 51.22           N  
ATOM     99  CA  LEU     7      -1.074  -1.684 -10.880  1.00 22.02           C  
ATOM    100  C   LEU     7      -0.897  -2.873 -11.835  1.00 44.25           C  
ATOM    101  O   LEU     7      -0.622  -2.686 -13.018  1.00 73.34           O  
ATOM    102  CB  LEU     7      -2.338  -0.908 -11.275  1.00 53.12           C  
ATOM    103  CG  LEU     7      -3.639  -1.730 -11.252  1.00 55.32           C  
ATOM    104  CD1 LEU     7      -4.047  -2.070  -9.820  1.00  5.11           C  
ATOM    105  CD2 LEU     7      -4.758  -0.992 -11.979  1.00 32.15           C  
ATOM    106  H   LEU     7       0.145  -0.106 -11.607  1.00 37.41           H  
ATOM    107  HA  LEU     7      -1.186  -2.053  -9.870  1.00 64.54           H  
ATOM    108  HB2 LEU     7      -2.450  -0.071 -10.597  1.00 37.41           H  
ATOM    109  HB3 LEU     7      -2.199  -0.521 -12.276  1.00 37.41           H  
ATOM    110  HG  LEU     7      -3.469  -2.663 -11.773  1.00  3.12           H  
ATOM    111 HD11 LEU     7      -4.968  -2.635  -9.832  1.00 37.41           H  
ATOM    112 HD12 LEU     7      -4.193  -1.158  -9.258  1.00 37.41           H  
ATOM    113 HD13 LEU     7      -3.270  -2.659  -9.353  1.00 37.41           H  
ATOM    114 HD21 LEU     7      -4.922  -0.031 -11.513  1.00 37.41           H  
ATOM    115 HD22 LEU     7      -5.664  -1.577 -11.930  1.00 37.41           H  
ATOM    116 HD23 LEU     7      -4.479  -0.850 -13.013  1.00 37.41           H  
ATOM    117  N   SER     8      -1.082  -4.093 -11.338  1.00 53.24           N  
ATOM    118  CA  SER     8      -0.905  -5.294 -12.171  1.00 31.23           C  
ATOM    119  C   SER     8      -2.098  -6.253 -12.064  1.00  3.22           C  
ATOM    120  O   SER     8      -2.856  -6.221 -11.093  1.00  4.32           O  
ATOM    121  CB  SER     8       0.387  -6.029 -11.787  1.00 22.41           C  
ATOM    122  OG  SER     8       0.365  -6.445 -10.429  1.00 32.24           O  
ATOM    123  H   SER     8      -1.343  -4.193 -10.399  1.00 37.41           H  
ATOM    124  HA  SER     8      -0.827  -4.968 -13.201  1.00  5.52           H  
ATOM    125  HB2 SER     8       0.503  -6.901 -12.413  1.00 37.41           H  
ATOM    126  HB3 SER     8       1.230  -5.369 -11.934  1.00 37.41           H  
ATOM    127  HG  SER     8       0.420  -5.670  -9.855  1.00 21.24           H  
ATOM    128  N   LYS     9      -2.262  -7.100 -13.083  1.00 41.30           N  
ATOM    129  CA  LYS     9      -3.341  -8.094 -13.117  1.00  1.00           C  
ATOM    130  C   LYS     9      -2.853  -9.472 -12.635  1.00 12.02           C  
ATOM    131  O   LYS     9      -1.749  -9.905 -12.965  1.00 63.01           O  
ATOM    132  CB  LYS     9      -3.907  -8.213 -14.543  1.00 61.51           C  
ATOM    133  CG  LYS     9      -4.926  -9.340 -14.712  1.00 32.33           C  
ATOM    134  CD  LYS     9      -5.360  -9.520 -16.166  1.00 51.24           C  
ATOM    135  CE  LYS     9      -6.254  -8.383 -16.648  1.00 54.22           C  
ATOM    136  NZ  LYS     9      -7.603  -8.424 -16.015  1.00  4.21           N  
ATOM    137  H   LYS     9      -1.635  -7.058 -13.834  1.00 37.41           H  
ATOM    138  HA  LYS     9      -4.129  -7.754 -12.456  1.00  4.52           H  
ATOM    139  HB2 LYS     9      -4.388  -7.280 -14.804  1.00 37.41           H  
ATOM    140  HB3 LYS     9      -3.089  -8.389 -15.229  1.00 37.41           H  
ATOM    141  HG2 LYS     9      -4.483 -10.264 -14.367  1.00 37.41           H  
ATOM    142  HG3 LYS     9      -5.797  -9.117 -14.110  1.00 37.41           H  
ATOM    143  HD2 LYS     9      -4.481  -9.560 -16.793  1.00 37.41           H  
ATOM    144  HD3 LYS     9      -5.904 -10.452 -16.252  1.00 37.41           H  
ATOM    145  HE2 LYS     9      -5.784  -7.440 -16.411  1.00 37.41           H  
ATOM    146  HE3 LYS     9      -6.370  -8.464 -17.721  1.00 37.41           H  
ATOM    147  HZ1 LYS     9      -7.523  -8.381 -14.981  1.00 37.41           H  
ATOM    148  HZ2 LYS     9      -8.096  -9.303 -16.277  1.00 37.41           H  
ATOM    149  HZ3 LYS     9      -8.176  -7.617 -16.339  1.00 37.41           H  
ATOM    150  N   SER    10      -3.690 -10.150 -11.857  1.00 65.03           N  
ATOM    151  CA  SER    10      -3.397 -11.504 -11.370  1.00 12.31           C  
ATOM    152  C   SER    10      -4.045 -12.568 -12.267  1.00 71.11           C  
ATOM    153  O   SER    10      -4.752 -12.244 -13.222  1.00 21.42           O  
ATOM    154  CB  SER    10      -3.901 -11.663  -9.930  1.00 51.44           C  
ATOM    155  OG  SER    10      -3.702 -12.985  -9.453  1.00 44.32           O  
ATOM    156  H   SER    10      -4.536  -9.729 -11.601  1.00 37.41           H  
ATOM    157  HA  SER    10      -2.324 -11.642 -11.386  1.00 20.04           H  
ATOM    158  HB2 SER    10      -3.365 -10.981  -9.286  1.00 37.41           H  
ATOM    159  HB3 SER    10      -4.956 -11.436  -9.894  1.00 37.41           H  
ATOM    160  HG  SER    10      -3.002 -12.984  -8.787  1.00 52.12           H  
ATOM    161  N   SER    11      -3.824 -13.840 -11.940  1.00 53.25           N  
ATOM    162  CA  SER    11      -4.365 -14.958 -12.731  1.00 71.22           C  
ATOM    163  C   SER    11      -5.902 -14.955 -12.751  1.00 61.02           C  
ATOM    164  O   SER    11      -6.521 -15.438 -13.700  1.00 23.10           O  
ATOM    165  CB  SER    11      -3.860 -16.297 -12.177  1.00  2.01           C  
ATOM    166  OG  SER    11      -4.259 -16.475 -10.828  1.00 23.05           O  
ATOM    167  H   SER    11      -3.289 -14.037 -11.141  1.00 37.41           H  
ATOM    168  HA  SER    11      -4.009 -14.845 -13.746  1.00 14.14           H  
ATOM    169  HB2 SER    11      -4.265 -17.106 -12.768  1.00 37.41           H  
ATOM    170  HB3 SER    11      -2.782 -16.322 -12.225  1.00 37.41           H  
ATOM    171  HG  SER    11      -3.986 -17.352 -10.525  1.00 23.22           H  
ATOM    172  N   ASN    12      -6.515 -14.408 -11.700  1.00 44.53           N  
ATOM    173  CA  ASN    12      -7.983 -14.299 -11.614  1.00 72.42           C  
ATOM    174  C   ASN    12      -8.499 -13.016 -12.289  1.00 55.44           C  
ATOM    175  O   ASN    12      -9.666 -12.652 -12.137  1.00 71.03           O  
ATOM    176  CB  ASN    12      -8.429 -14.300 -10.146  1.00 11.22           C  
ATOM    177  CG  ASN    12      -7.960 -15.522  -9.387  1.00 12.42           C  
ATOM    178  OD1 ASN    12      -7.781 -16.594  -9.957  1.00 23.32           O  
ATOM    179  ND2 ASN    12      -7.765 -15.376  -8.092  1.00 33.33           N  
ATOM    180  H   ASN    12      -5.968 -14.085 -10.951  1.00 37.41           H  
ATOM    181  HA  ASN    12      -8.414 -15.156 -12.111  1.00 44.30           H  
ATOM    182  HB2 ASN    12      -8.032 -13.422  -9.655  1.00 37.41           H  
ATOM    183  HB3 ASN    12      -9.509 -14.270 -10.103  1.00 37.41           H  
ATOM    184 HD21 ASN    12      -7.934 -14.496  -7.693  1.00 37.41           H  
ATOM    185 HD22 ASN    12      -7.463 -16.156  -7.583  1.00 37.41           H  
ATOM    186  N   ASP    13      -7.615 -12.331 -13.021  1.00 50.41           N  
ATOM    187  CA  ASP    13      -7.914 -11.021 -13.626  1.00 62.51           C  
ATOM    188  C   ASP    13      -8.024  -9.907 -12.568  1.00 12.43           C  
ATOM    189  O   ASP    13      -8.190  -8.735 -12.913  1.00 50.44           O  
ATOM    190  CB  ASP    13      -9.186 -11.065 -14.493  1.00 13.34           C  
ATOM    191  CG  ASP    13      -8.954 -11.755 -15.823  1.00 73.13           C  
ATOM    192  OD1 ASP    13      -8.463 -11.087 -16.760  1.00 10.25           O  
ATOM    193  OD2 ASP    13      -9.254 -12.964 -15.938  1.00 60.13           O  
ATOM    194  H   ASP    13      -6.725 -12.718 -13.165  1.00 37.41           H  
ATOM    195  HA  ASP    13      -7.078 -10.779 -14.267  1.00 70.42           H  
ATOM    196  HB2 ASP    13      -9.962 -11.595 -13.960  1.00 37.41           H  
ATOM    197  HB3 ASP    13      -9.520 -10.054 -14.686  1.00 37.41           H  
ATOM    198  N   GLN    14      -7.900 -10.275 -11.292  1.00 32.13           N  
ATOM    199  CA  GLN    14      -7.973  -9.309 -10.191  1.00 61.21           C  
ATOM    200  C   GLN    14      -6.763  -8.367 -10.199  1.00 42.43           C  
ATOM    201  O   GLN    14      -5.650  -8.771 -10.534  1.00 44.04           O  
ATOM    202  CB  GLN    14      -8.056 -10.042  -8.848  1.00 55.01           C  
ATOM    203  CG  GLN    14      -9.291 -10.920  -8.699  1.00 41.00           C  
ATOM    204  CD  GLN    14      -9.368 -11.589  -7.339  1.00 63.31           C  
ATOM    205  OE1 GLN    14      -8.861 -12.691  -7.139  1.00 40.21           O  
ATOM    206  NE2 GLN    14      -9.989 -10.919  -6.388  1.00 52.14           N  
ATOM    207  H   GLN    14      -7.752 -11.216 -11.085  1.00 37.41           H  
ATOM    208  HA  GLN    14      -8.873  -8.721 -10.324  1.00 31.13           H  
ATOM    209  HB2 GLN    14      -7.182 -10.668  -8.739  1.00 37.41           H  
ATOM    210  HB3 GLN    14      -8.063  -9.309  -8.050  1.00 37.41           H  
ATOM    211  HG2 GLN    14     -10.173 -10.309  -8.835  1.00 37.41           H  
ATOM    212  HG3 GLN    14      -9.267 -11.687  -9.461  1.00 37.41           H  
ATOM    213 HE21 GLN    14     -10.356 -10.040  -6.606  1.00 37.41           H  
ATOM    214 HE22 GLN    14     -10.067 -11.336  -5.507  1.00 37.41           H  
ATOM    215  N   PHE    15      -6.984  -7.119  -9.814  1.00 34.33           N  
ATOM    216  CA  PHE    15      -5.946  -6.088  -9.886  1.00 11.02           C  
ATOM    217  C   PHE    15      -5.339  -5.799  -8.506  1.00 12.22           C  
ATOM    218  O   PHE    15      -6.057  -5.669  -7.517  1.00  5.21           O  
ATOM    219  CB  PHE    15      -6.550  -4.800 -10.462  1.00 74.34           C  
ATOM    220  CG  PHE    15      -7.348  -5.021 -11.726  1.00 43.43           C  
ATOM    221  CD1 PHE    15      -6.715  -5.122 -12.954  1.00 11.24           C  
ATOM    222  CD2 PHE    15      -8.732  -5.131 -11.680  1.00 33.13           C  
ATOM    223  CE1 PHE    15      -7.443  -5.326 -14.110  1.00 51.03           C  
ATOM    224  CE2 PHE    15      -9.463  -5.335 -12.835  1.00  2.13           C  
ATOM    225  CZ  PHE    15      -8.818  -5.432 -14.050  1.00 45.41           C  
ATOM    226  H   PHE    15      -7.868  -6.879  -9.467  1.00 37.41           H  
ATOM    227  HA  PHE    15      -5.167  -6.437 -10.549  1.00 73.33           H  
ATOM    228  HB2 PHE    15      -7.207  -4.356  -9.725  1.00 37.41           H  
ATOM    229  HB3 PHE    15      -5.753  -4.104 -10.686  1.00 37.41           H  
ATOM    230  HD1 PHE    15      -5.639  -5.040 -13.004  1.00 42.24           H  
ATOM    231  HD2 PHE    15      -9.239  -5.057 -10.729  1.00 24.11           H  
ATOM    232  HE1 PHE    15      -6.938  -5.402 -15.060  1.00 73.33           H  
ATOM    233  HE2 PHE    15     -10.539  -5.417 -12.786  1.00 13.42           H  
ATOM    234  HZ  PHE    15      -9.388  -5.589 -14.953  1.00 71.34           H  
ATOM    235  N   LYS    16      -4.013  -5.695  -8.446  1.00 31.41           N  
ATOM    236  CA  LYS    16      -3.332  -5.276  -7.216  1.00 15.33           C  
ATOM    237  C   LYS    16      -2.193  -4.297  -7.539  1.00  4.33           C  
ATOM    238  O   LYS    16      -1.420  -4.510  -8.477  1.00 10.15           O  
ATOM    239  CB  LYS    16      -2.802  -6.487  -6.416  1.00 42.11           C  
ATOM    240  CG  LYS    16      -1.604  -7.217  -7.030  1.00 31.14           C  
ATOM    241  CD  LYS    16      -1.976  -8.053  -8.255  1.00 13.43           C  
ATOM    242  CE  LYS    16      -0.779  -8.849  -8.774  1.00 54.14           C  
ATOM    243  NZ  LYS    16      -0.218  -9.756  -7.733  1.00 10.20           N  
ATOM    244  H   LYS    16      -3.479  -5.908  -9.244  1.00 37.41           H  
ATOM    245  HA  LYS    16      -4.059  -4.752  -6.607  1.00 12.31           H  
ATOM    246  HB2 LYS    16      -2.508  -6.144  -5.433  1.00 37.41           H  
ATOM    247  HB3 LYS    16      -3.608  -7.198  -6.302  1.00 37.41           H  
ATOM    248  HG2 LYS    16      -0.865  -6.486  -7.324  1.00 37.41           H  
ATOM    249  HG3 LYS    16      -1.177  -7.871  -6.280  1.00 37.41           H  
ATOM    250  HD2 LYS    16      -2.762  -8.742  -7.982  1.00 37.41           H  
ATOM    251  HD3 LYS    16      -2.328  -7.394  -9.037  1.00 37.41           H  
ATOM    252  HE2 LYS    16      -1.095  -9.442  -9.619  1.00 37.41           H  
ATOM    253  HE3 LYS    16      -0.010  -8.159  -9.088  1.00 37.41           H  
ATOM    254  HZ1 LYS    16      -0.943 -10.432  -7.415  1.00 37.41           H  
ATOM    255  HZ2 LYS    16       0.107  -9.206  -6.912  1.00 37.41           H  
ATOM    256  HZ3 LYS    16       0.589 -10.290  -8.116  1.00 37.41           H  
ATOM    257  N   PHE    17      -2.108  -3.208  -6.777  1.00 74.03           N  
ATOM    258  CA  PHE    17      -1.075  -2.191  -7.000  1.00 53.02           C  
ATOM    259  C   PHE    17      -0.005  -2.223  -5.901  1.00 30.43           C  
ATOM    260  O   PHE    17      -0.299  -2.478  -4.730  1.00 23.23           O  
ATOM    261  CB  PHE    17      -1.699  -0.787  -7.109  1.00 61.40           C  
ATOM    262  CG  PHE    17      -2.509  -0.354  -5.908  1.00 22.44           C  
ATOM    263  CD1 PHE    17      -3.851  -0.698  -5.797  1.00 25.42           C  
ATOM    264  CD2 PHE    17      -1.934   0.413  -4.902  1.00 11.02           C  
ATOM    265  CE1 PHE    17      -4.599  -0.289  -4.707  1.00  3.25           C  
ATOM    266  CE2 PHE    17      -2.679   0.826  -3.812  1.00 61.51           C  
ATOM    267  CZ  PHE    17      -4.013   0.475  -3.714  1.00 53.33           C  
ATOM    268  H   PHE    17      -2.748  -3.087  -6.047  1.00 37.41           H  
ATOM    269  HA  PHE    17      -0.593  -2.422  -7.942  1.00 71.45           H  
ATOM    270  HB2 PHE    17      -0.910  -0.063  -7.253  1.00 37.41           H  
ATOM    271  HB3 PHE    17      -2.350  -0.763  -7.974  1.00 37.41           H  
ATOM    272  HD1 PHE    17      -4.311  -1.293  -6.572  1.00 23.54           H  
ATOM    273  HD2 PHE    17      -0.891   0.688  -4.976  1.00 22.11           H  
ATOM    274  HE1 PHE    17      -5.642  -0.566  -4.633  1.00 15.40           H  
ATOM    275  HE2 PHE    17      -2.218   1.422  -3.036  1.00 34.02           H  
ATOM    276  HZ  PHE    17      -4.597   0.797  -2.862  1.00  5.30           H  
ATOM    277  N   VAL    18       1.239  -1.967  -6.293  1.00 22.04           N  
ATOM    278  CA  VAL    18       2.366  -1.971  -5.355  1.00 54.43           C  
ATOM    279  C   VAL    18       3.086  -0.611  -5.328  1.00 22.02           C  
ATOM    280  O   VAL    18       3.423  -0.044  -6.371  1.00 23.21           O  
ATOM    281  CB  VAL    18       3.384  -3.091  -5.700  1.00 44.42           C  
ATOM    282  CG1 VAL    18       2.765  -4.472  -5.488  1.00 41.30           C  
ATOM    283  CG2 VAL    18       3.901  -2.944  -7.134  1.00 73.52           C  
ATOM    284  H   VAL    18       1.409  -1.778  -7.239  1.00 37.41           H  
ATOM    285  HA  VAL    18       1.973  -2.169  -4.366  1.00 54.53           H  
ATOM    286  HB  VAL    18       4.227  -2.997  -5.027  1.00 60.00           H  
ATOM    287 HG11 VAL    18       2.445  -4.568  -4.460  1.00 37.41           H  
ATOM    288 HG12 VAL    18       3.498  -5.236  -5.708  1.00 37.41           H  
ATOM    289 HG13 VAL    18       1.913  -4.592  -6.142  1.00 37.41           H  
ATOM    290 HG21 VAL    18       3.072  -3.005  -7.826  1.00 37.41           H  
ATOM    291 HG22 VAL    18       4.605  -3.735  -7.348  1.00 37.41           H  
ATOM    292 HG23 VAL    18       4.391  -1.987  -7.246  1.00 37.41           H  
ATOM    293  N   LEU    19       3.304  -0.092  -4.125  1.00 52.03           N  
ATOM    294  CA  LEU    19       4.021   1.173  -3.934  1.00 24.34           C  
ATOM    295  C   LEU    19       5.504   0.916  -3.629  1.00 42.15           C  
ATOM    296  O   LEU    19       5.838   0.190  -2.691  1.00 31.33           O  
ATOM    297  CB  LEU    19       3.377   1.971  -2.791  1.00 55.15           C  
ATOM    298  CG  LEU    19       4.090   3.280  -2.402  1.00 63.53           C  
ATOM    299  CD1 LEU    19       4.113   4.265  -3.570  1.00 65.03           C  
ATOM    300  CD2 LEU    19       3.432   3.907  -1.174  1.00 62.21           C  
ATOM    301  H   LEU    19       2.973  -0.572  -3.337  1.00 37.41           H  
ATOM    302  HA  LEU    19       3.946   1.745  -4.850  1.00 24.45           H  
ATOM    303  HB2 LEU    19       2.363   2.209  -3.079  1.00 37.41           H  
ATOM    304  HB3 LEU    19       3.342   1.335  -1.918  1.00 37.41           H  
ATOM    305  HG  LEU    19       5.116   3.054  -2.147  1.00 54.21           H  
ATOM    306 HD11 LEU    19       3.100   4.489  -3.876  1.00 37.41           H  
ATOM    307 HD12 LEU    19       4.650   3.830  -4.401  1.00 37.41           H  
ATOM    308 HD13 LEU    19       4.605   5.176  -3.263  1.00 37.41           H  
ATOM    309 HD21 LEU    19       2.399   4.136  -1.392  1.00 37.41           H  
ATOM    310 HD22 LEU    19       3.954   4.817  -0.911  1.00 37.41           H  
ATOM    311 HD23 LEU    19       3.481   3.216  -0.344  1.00 37.41           H  
ATOM    312  N   LYS    20       6.390   1.506  -4.431  1.00 33.45           N  
ATOM    313  CA  LYS    20       7.837   1.352  -4.228  1.00 63.43           C  
ATOM    314  C   LYS    20       8.451   2.586  -3.550  1.00 41.42           C  
ATOM    315  O   LYS    20       8.049   3.714  -3.819  1.00 10.34           O  
ATOM    316  CB  LYS    20       8.554   1.068  -5.563  1.00  1.45           C  
ATOM    317  CG  LYS    20       8.383  -0.369  -6.067  1.00  2.44           C  
ATOM    318  CD  LYS    20       6.992  -0.637  -6.637  1.00 64.21           C  
ATOM    319  CE  LYS    20       6.845  -0.091  -8.043  1.00  4.33           C  
ATOM    320  NZ  LYS    20       7.743  -0.793  -9.006  1.00 70.21           N  
ATOM    321  H   LYS    20       6.064   2.064  -5.171  1.00 37.41           H  
ATOM    322  HA  LYS    20       7.985   0.502  -3.574  1.00 54.55           H  
ATOM    323  HB2 LYS    20       8.168   1.740  -6.317  1.00 37.41           H  
ATOM    324  HB3 LYS    20       9.612   1.256  -5.438  1.00 37.41           H  
ATOM    325  HG2 LYS    20       9.116  -0.555  -6.838  1.00 37.41           H  
ATOM    326  HG3 LYS    20       8.560  -1.046  -5.242  1.00 37.41           H  
ATOM    327  HD2 LYS    20       6.824  -1.702  -6.663  1.00 37.41           H  
ATOM    328  HD3 LYS    20       6.254  -0.170  -6.002  1.00 37.41           H  
ATOM    329  HE2 LYS    20       5.822  -0.223  -8.359  1.00 37.41           H  
ATOM    330  HE3 LYS    20       7.088   0.960  -8.036  1.00 37.41           H  
ATOM    331  HZ1 LYS    20       7.384  -1.753  -9.195  1.00 37.41           H  
ATOM    332  HZ2 LYS    20       8.705  -0.861  -8.622  1.00 37.41           H  
ATOM    333  HZ3 LYS    20       7.778  -0.275  -9.907  1.00 37.41           H  
ATOM    334  N   ALA    21       9.428   2.352  -2.671  1.00 15.14           N  
ATOM    335  CA  ALA    21      10.115   3.432  -1.950  1.00 74.41           C  
ATOM    336  C   ALA    21      10.840   4.396  -2.906  1.00 70.03           C  
ATOM    337  O   ALA    21      10.640   5.609  -2.844  1.00  2.32           O  
ATOM    338  CB  ALA    21      11.103   2.839  -0.948  1.00 55.31           C  
ATOM    339  H   ALA    21       9.690   1.424  -2.493  1.00 37.41           H  
ATOM    340  HA  ALA    21       9.370   3.986  -1.395  1.00 43.44           H  
ATOM    341  HB1 ALA    21      10.578   2.178  -0.273  1.00 37.41           H  
ATOM    342  HB2 ALA    21      11.566   3.636  -0.383  1.00 37.41           H  
ATOM    343  HB3 ALA    21      11.864   2.284  -1.476  1.00 37.41           H  
ATOM    344  N   GLY    22      11.682   3.840  -3.777  1.00 32.43           N  
ATOM    345  CA  GLY    22      12.417   4.656  -4.743  1.00 65.25           C  
ATOM    346  C   GLY    22      13.304   3.833  -5.674  1.00 43.13           C  
ATOM    347  O   GLY    22      13.199   3.930  -6.893  1.00 21.33           O  
ATOM    348  H   GLY    22      11.811   2.873  -3.760  1.00 37.41           H  
ATOM    349  HA2 GLY    22      11.707   5.212  -5.340  1.00 37.41           H  
ATOM    350  HA3 GLY    22      13.041   5.357  -4.203  1.00 37.41           H  
ATOM    351  N   ASN    23      14.167   3.000  -5.096  1.00 64.32           N  
ATOM    352  CA  ASN    23      15.101   2.174  -5.885  1.00 13.20           C  
ATOM    353  C   ASN    23      14.403   0.985  -6.576  1.00 64.53           C  
ATOM    354  O   ASN    23      15.057   0.162  -7.218  1.00  4.43           O  
ATOM    355  CB  ASN    23      16.222   1.642  -4.984  1.00  5.33           C  
ATOM    356  CG  ASN    23      15.692   0.766  -3.862  1.00 25.22           C  
ATOM    357  OD1 ASN    23      15.512  -0.435  -4.025  1.00 20.42           O  
ATOM    358  ND2 ASN    23      15.436   1.361  -2.714  1.00 32.25           N  
ATOM    359  H   ASN    23      14.195   2.951  -4.116  1.00 37.41           H  
ATOM    360  HA  ASN    23      15.538   2.805  -6.645  1.00 42.31           H  
ATOM    361  HB2 ASN    23      16.909   1.057  -5.580  1.00 37.41           H  
ATOM    362  HB3 ASN    23      16.754   2.477  -4.550  1.00 37.41           H  
ATOM    363 HD21 ASN    23      15.594   2.326  -2.643  1.00 37.41           H  
ATOM    364 HD22 ASN    23      15.105   0.811  -1.974  1.00 37.41           H  
ATOM    365  N   GLY    24      13.081   0.900  -6.452  1.00 13.42           N  
ATOM    366  CA  GLY    24      12.345  -0.253  -6.968  1.00 11.14           C  
ATOM    367  C   GLY    24      11.843  -1.172  -5.857  1.00 21.53           C  
ATOM    368  O   GLY    24      10.939  -1.981  -6.068  1.00 12.42           O  
ATOM    369  H   GLY    24      12.597   1.636  -6.028  1.00 37.41           H  
ATOM    370  HA2 GLY    24      11.496   0.104  -7.533  1.00 37.41           H  
ATOM    371  HA3 GLY    24      12.987  -0.822  -7.628  1.00 37.41           H  
ATOM    372  N   GLU    25      12.440  -1.042  -4.675  1.00 54.13           N  
ATOM    373  CA  GLU    25      12.017  -1.788  -3.482  1.00  3.13           C  
ATOM    374  C   GLU    25      10.554  -1.474  -3.113  1.00 52.25           C  
ATOM    375  O   GLU    25      10.193  -0.313  -2.913  1.00 55.42           O  
ATOM    376  CB  GLU    25      12.945  -1.435  -2.311  1.00  1.11           C  
ATOM    377  CG  GLU    25      12.583  -2.096  -0.987  1.00 25.03           C  
ATOM    378  CD  GLU    25      13.518  -1.679   0.136  1.00  2.32           C  
ATOM    379  OE1 GLU    25      13.394  -0.538   0.625  1.00 33.43           O  
ATOM    380  OE2 GLU    25      14.398  -2.480   0.521  1.00  5.43           O  
ATOM    381  H   GLU    25      13.201  -0.430  -4.600  1.00 37.41           H  
ATOM    382  HA  GLU    25      12.108  -2.843  -3.697  1.00 33.42           H  
ATOM    383  HB2 GLU    25      13.952  -1.731  -2.569  1.00 37.41           H  
ATOM    384  HB3 GLU    25      12.927  -0.361  -2.168  1.00 37.41           H  
ATOM    385  HG2 GLU    25      11.573  -1.816  -0.721  1.00 37.41           H  
ATOM    386  HG3 GLU    25      12.637  -3.170  -1.106  1.00 37.41           H  
ATOM    387  N   VAL    26       9.719  -2.509  -3.029  1.00 55.41           N  
ATOM    388  CA  VAL    26       8.293  -2.340  -2.714  1.00 44.33           C  
ATOM    389  C   VAL    26       8.057  -2.237  -1.197  1.00 35.44           C  
ATOM    390  O   VAL    26       8.505  -3.089  -0.430  1.00 45.23           O  
ATOM    391  CB  VAL    26       7.450  -3.517  -3.277  1.00 24.14           C  
ATOM    392  CG1 VAL    26       5.963  -3.324  -2.972  1.00 40.43           C  
ATOM    393  CG2 VAL    26       7.683  -3.679  -4.781  1.00 75.21           C  
ATOM    394  H   VAL    26      10.068  -3.414  -3.178  1.00 37.41           H  
ATOM    395  HA  VAL    26       7.954  -1.427  -3.185  1.00 33.13           H  
ATOM    396  HB  VAL    26       7.775  -4.426  -2.788  1.00 11.33           H  
ATOM    397 HG11 VAL    26       5.401  -4.152  -3.378  1.00 37.41           H  
ATOM    398 HG12 VAL    26       5.616  -2.402  -3.420  1.00 37.41           H  
ATOM    399 HG13 VAL    26       5.816  -3.281  -1.903  1.00 37.41           H  
ATOM    400 HG21 VAL    26       8.738  -3.827  -4.969  1.00 37.41           H  
ATOM    401 HG22 VAL    26       7.349  -2.791  -5.299  1.00 37.41           H  
ATOM    402 HG23 VAL    26       7.133  -4.535  -5.142  1.00 37.41           H  
ATOM    403  N   ILE    27       7.346  -1.191  -0.773  1.00  4.41           N  
ATOM    404  CA  ILE    27       7.030  -0.986   0.647  1.00  4.54           C  
ATOM    405  C   ILE    27       5.568  -1.348   0.975  1.00  3.14           C  
ATOM    406  O   ILE    27       5.275  -1.837   2.064  1.00 23.10           O  
ATOM    407  CB  ILE    27       7.318   0.477   1.088  1.00 42.43           C  
ATOM    408  CG1 ILE    27       6.607   1.478   0.157  1.00 33.30           C  
ATOM    409  CG2 ILE    27       8.823   0.740   1.129  1.00 23.50           C  
ATOM    410  CD1 ILE    27       6.893   2.933   0.474  1.00 42.13           C  
ATOM    411  H   ILE    27       7.027  -0.540  -1.431  1.00 37.41           H  
ATOM    412  HA  ILE    27       7.677  -1.639   1.224  1.00 11.11           H  
ATOM    413  HB  ILE    27       6.937   0.603   2.092  1.00 11.11           H  
ATOM    414 HG12 ILE    27       6.919   1.298  -0.862  1.00 37.41           H  
ATOM    415 HG13 ILE    27       5.538   1.329   0.228  1.00 37.41           H  
ATOM    416 HG21 ILE    27       9.236   0.637   0.137  1.00 37.41           H  
ATOM    417 HG22 ILE    27       9.296   0.029   1.791  1.00 37.41           H  
ATOM    418 HG23 ILE    27       9.003   1.742   1.492  1.00 37.41           H  
ATOM    419 HD11 ILE    27       7.949   3.129   0.359  1.00 37.41           H  
ATOM    420 HD12 ILE    27       6.595   3.151   1.491  1.00 37.41           H  
ATOM    421 HD13 ILE    27       6.337   3.563  -0.205  1.00 37.41           H  
ATOM    422  N   LEU    28       4.654  -1.107   0.029  1.00  4.22           N  
ATOM    423  CA  LEU    28       3.226  -1.431   0.210  1.00 60.34           C  
ATOM    424  C   LEU    28       2.710  -2.337  -0.916  1.00 13.24           C  
ATOM    425  O   LEU    28       2.926  -2.061  -2.095  1.00 51.11           O  
ATOM    426  CB  LEU    28       2.365  -0.148   0.265  1.00 13.32           C  
ATOM    427  CG  LEU    28       2.170   0.493   1.654  1.00  1.30           C  
ATOM    428  CD1 LEU    28       1.429  -0.455   2.592  1.00 51.54           C  
ATOM    429  CD2 LEU    28       3.503   0.911   2.258  1.00 11.51           C  
ATOM    430  H   LEU    28       4.943  -0.701  -0.816  1.00 37.41           H  
ATOM    431  HA  LEU    28       3.123  -1.959   1.150  1.00 32.34           H  
ATOM    432  HB2 LEU    28       2.821   0.588  -0.381  1.00 37.41           H  
ATOM    433  HB3 LEU    28       1.384  -0.381  -0.133  1.00 37.41           H  
ATOM    434  HG  LEU    28       1.565   1.381   1.544  1.00 21.42           H  
ATOM    435 HD11 LEU    28       0.466  -0.702   2.169  1.00 37.41           H  
ATOM    436 HD12 LEU    28       1.288   0.023   3.552  1.00 37.41           H  
ATOM    437 HD13 LEU    28       2.006  -1.358   2.725  1.00 37.41           H  
ATOM    438 HD21 LEU    28       4.121   0.040   2.408  1.00 37.41           H  
ATOM    439 HD22 LEU    28       3.333   1.397   3.207  1.00 37.41           H  
ATOM    440 HD23 LEU    28       4.005   1.595   1.589  1.00 37.41           H  
ATOM    441  N   THR    29       2.027  -3.415  -0.540  1.00 42.25           N  
ATOM    442  CA  THR    29       1.398  -4.329  -1.505  1.00  3.53           C  
ATOM    443  C   THR    29      -0.089  -4.530  -1.181  1.00 50.11           C  
ATOM    444  O   THR    29      -0.436  -5.182  -0.195  1.00  2.20           O  
ATOM    445  CB  THR    29       2.089  -5.715  -1.513  1.00  3.43           C  
ATOM    446  OG1 THR    29       3.497  -5.570  -1.777  1.00 62.22           O  
ATOM    447  CG2 THR    29       1.467  -6.643  -2.559  1.00 43.44           C  
ATOM    448  H   THR    29       1.947  -3.611   0.416  1.00 37.41           H  
ATOM    449  HA  THR    29       1.489  -3.897  -2.495  1.00 31.01           H  
ATOM    450  HB  THR    29       1.965  -6.167  -0.537  1.00 62.51           H  
ATOM    451  HG1 THR    29       3.867  -4.912  -1.174  1.00 71.20           H  
ATOM    452 HG21 THR    29       0.423  -6.800  -2.327  1.00 37.41           H  
ATOM    453 HG22 THR    29       1.983  -7.592  -2.552  1.00 37.41           H  
ATOM    454 HG23 THR    29       1.555  -6.194  -3.538  1.00 37.41           H  
ATOM    455  N   SER    30      -0.966  -3.964  -2.002  1.00 12.02           N  
ATOM    456  CA  SER    30      -2.415  -4.109  -1.802  1.00 32.42           C  
ATOM    457  C   SER    30      -2.917  -5.478  -2.279  1.00 71.31           C  
ATOM    458  O   SER    30      -2.366  -6.063  -3.210  1.00 12.20           O  
ATOM    459  CB  SER    30      -3.166  -2.992  -2.529  1.00 40.31           C  
ATOM    460  OG  SER    30      -2.809  -1.723  -2.009  1.00 75.03           O  
ATOM    461  H   SER    30      -0.637  -3.433  -2.762  1.00 37.41           H  
ATOM    462  HA  SER    30      -2.609  -4.024  -0.740  1.00 24.21           H  
ATOM    463  HB2 SER    30      -2.917  -3.016  -3.581  1.00 37.41           H  
ATOM    464  HB3 SER    30      -4.230  -3.132  -2.406  1.00 37.41           H  
ATOM    465  HG  SER    30      -3.596  -1.280  -1.671  1.00 71.43           H  
ATOM    466  N   GLU    31      -3.971  -5.977  -1.634  1.00 73.33           N  
ATOM    467  CA  GLU    31      -4.517  -7.305  -1.944  1.00  3.32           C  
ATOM    468  C   GLU    31      -5.400  -7.270  -3.211  1.00 40.31           C  
ATOM    469  O   GLU    31      -5.730  -6.200  -3.721  1.00 52.34           O  
ATOM    470  CB  GLU    31      -5.301  -7.835  -0.729  1.00 60.41           C  
ATOM    471  CG  GLU    31      -5.616  -9.328  -0.785  1.00 21.24           C  
ATOM    472  CD  GLU    31      -6.150  -9.867   0.533  1.00 21.13           C  
ATOM    473  OE1 GLU    31      -5.332 -10.197   1.419  1.00 42.33           O  
ATOM    474  OE2 GLU    31      -7.384  -9.967   0.691  1.00 53.31           O  
ATOM    475  H   GLU    31      -4.396  -5.440  -0.936  1.00 37.41           H  
ATOM    476  HA  GLU    31      -3.681  -7.966  -2.130  1.00 12.32           H  
ATOM    477  HB2 GLU    31      -4.719  -7.649   0.163  1.00 37.41           H  
ATOM    478  HB3 GLU    31      -6.235  -7.293  -0.653  1.00 37.41           H  
ATOM    479  HG2 GLU    31      -6.357  -9.497  -1.555  1.00 37.41           H  
ATOM    480  HG3 GLU    31      -4.713  -9.865  -1.038  1.00 37.41           H  
ATOM    481  N   LEU    32      -5.778  -8.448  -3.709  1.00 31.41           N  
ATOM    482  CA  LEU    32      -6.494  -8.574  -4.988  1.00 40.14           C  
ATOM    483  C   LEU    32      -7.866  -7.870  -5.000  1.00 75.44           C  
ATOM    484  O   LEU    32      -8.808  -8.295  -4.327  1.00 53.22           O  
ATOM    485  CB  LEU    32      -6.674 -10.060  -5.335  1.00 14.41           C  
ATOM    486  CG  LEU    32      -5.371 -10.842  -5.569  1.00 55.35           C  
ATOM    487  CD1 LEU    32      -5.662 -12.309  -5.881  1.00 43.45           C  
ATOM    488  CD2 LEU    32      -4.552 -10.204  -6.689  1.00 22.01           C  
ATOM    489  H   LEU    32      -5.565  -9.259  -3.210  1.00 37.41           H  
ATOM    490  HA  LEU    32      -5.873  -8.122  -5.748  1.00 11.12           H  
ATOM    491  HB2 LEU    32      -7.213 -10.533  -4.525  1.00 37.41           H  
ATOM    492  HB3 LEU    32      -7.275 -10.130  -6.231  1.00 37.41           H  
ATOM    493  HG  LEU    32      -4.779 -10.810  -4.665  1.00 11.42           H  
ATOM    494 HD11 LEU    32      -6.278 -12.376  -6.768  1.00 37.41           H  
ATOM    495 HD12 LEU    32      -6.182 -12.758  -5.048  1.00 37.41           H  
ATOM    496 HD13 LEU    32      -4.733 -12.834  -6.048  1.00 37.41           H  
ATOM    497 HD21 LEU    32      -3.639 -10.763  -6.829  1.00 37.41           H  
ATOM    498 HD22 LEU    32      -4.311  -9.185  -6.426  1.00 37.41           H  
ATOM    499 HD23 LEU    32      -5.123 -10.214  -7.606  1.00 37.41           H  
ATOM    500  N   TYR    33      -7.965  -6.790  -5.775  1.00 11.35           N  
ATOM    501  CA  TYR    33      -9.249  -6.138  -6.051  1.00 11.52           C  
ATOM    502  C   TYR    33      -9.951  -6.803  -7.244  1.00 23.01           C  
ATOM    503  O   TYR    33      -9.325  -7.082  -8.265  1.00 43.55           O  
ATOM    504  CB  TYR    33      -9.043  -4.646  -6.357  1.00 50.44           C  
ATOM    505  CG  TYR    33      -8.682  -3.799  -5.149  1.00 53.22           C  
ATOM    506  CD1 TYR    33      -7.393  -3.804  -4.627  1.00 25.22           C  
ATOM    507  CD2 TYR    33      -9.634  -2.992  -4.534  1.00 32.12           C  
ATOM    508  CE1 TYR    33      -7.065  -3.030  -3.529  1.00 54.14           C  
ATOM    509  CE2 TYR    33      -9.312  -2.216  -3.437  1.00  5.53           C  
ATOM    510  CZ  TYR    33      -8.029  -2.239  -2.939  1.00 72.32           C  
ATOM    511  OH  TYR    33      -7.713  -1.471  -1.839  1.00 32.34           O  
ATOM    512  H   TYR    33      -7.147  -6.415  -6.167  1.00 37.41           H  
ATOM    513  HA  TYR    33      -9.875  -6.236  -5.174  1.00 51.34           H  
ATOM    514  HB2 TYR    33      -8.246  -4.543  -7.080  1.00 37.41           H  
ATOM    515  HB3 TYR    33      -9.954  -4.247  -6.783  1.00 37.41           H  
ATOM    516  HD1 TYR    33      -6.640  -4.426  -5.091  1.00 54.13           H  
ATOM    517  HD2 TYR    33     -10.641  -2.976  -4.925  1.00 75.03           H  
ATOM    518  HE1 TYR    33      -6.057  -3.047  -3.139  1.00 13.12           H  
ATOM    519  HE2 TYR    33     -10.066  -1.596  -2.976  1.00 52.15           H  
ATOM    520  HH  TYR    33      -6.843  -1.077  -1.960  1.00 61.43           H  
ATOM    521  N   THR    34     -11.253  -7.044  -7.126  1.00 23.34           N  
ATOM    522  CA  THR    34     -12.024  -7.667  -8.217  1.00  0.23           C  
ATOM    523  C   THR    34     -12.409  -6.652  -9.305  1.00 51.22           C  
ATOM    524  O   THR    34     -13.006  -7.010 -10.319  1.00 71.32           O  
ATOM    525  CB  THR    34     -13.311  -8.338  -7.688  1.00 34.04           C  
ATOM    526  OG1 THR    34     -14.136  -7.365  -7.029  1.00 52.13           O  
ATOM    527  CG2 THR    34     -12.980  -9.470  -6.719  1.00 45.25           C  
ATOM    528  H   THR    34     -11.710  -6.807  -6.291  1.00 37.41           H  
ATOM    529  HA  THR    34     -11.406  -8.433  -8.663  1.00 53.15           H  
ATOM    530  HB  THR    34     -13.856  -8.750  -8.526  1.00 11.22           H  
ATOM    531  HG1 THR    34     -14.964  -7.264  -7.518  1.00 54.02           H  
ATOM    532 HG21 THR    34     -13.896  -9.921  -6.365  1.00 37.41           H  
ATOM    533 HG22 THR    34     -12.426  -9.076  -5.879  1.00 37.41           H  
ATOM    534 HG23 THR    34     -12.384 -10.216  -7.225  1.00 37.41           H  
ATOM    535  N   GLY    35     -12.063  -5.386  -9.087  1.00 32.43           N  
ATOM    536  CA  GLY    35     -12.350  -4.339 -10.064  1.00 11.33           C  
ATOM    537  C   GLY    35     -11.308  -3.223 -10.037  1.00  4.14           C  
ATOM    538  O   GLY    35     -10.841  -2.834  -8.963  1.00  4.34           O  
ATOM    539  H   GLY    35     -11.606  -5.156  -8.253  1.00 37.41           H  
ATOM    540  HA2 GLY    35     -12.372  -4.774 -11.052  1.00 37.41           H  
ATOM    541  HA3 GLY    35     -13.319  -3.918  -9.847  1.00 37.41           H  
ATOM    542  N   LYS    36     -10.949  -2.697 -11.208  1.00 34.30           N  
ATOM    543  CA  LYS    36      -9.908  -1.662 -11.301  1.00 51.21           C  
ATOM    544  C   LYS    36     -10.348  -0.358 -10.615  1.00 14.33           C  
ATOM    545  O   LYS    36      -9.536   0.323  -9.991  1.00 14.21           O  
ATOM    546  CB  LYS    36      -9.538  -1.392 -12.767  1.00 64.03           C  
ATOM    547  CG  LYS    36      -8.450  -0.329 -12.934  1.00  4.43           C  
ATOM    548  CD  LYS    36      -7.999  -0.180 -14.384  1.00 75.05           C  
ATOM    549  CE  LYS    36      -7.329  -1.447 -14.907  1.00 30.43           C  
ATOM    550  NZ  LYS    36      -6.824  -1.274 -16.294  1.00 15.40           N  
ATOM    551  H   LYS    36     -11.399  -2.997 -12.026  1.00 37.41           H  
ATOM    552  HA  LYS    36      -9.034  -2.040 -10.788  1.00 74.12           H  
ATOM    553  HB2 LYS    36      -9.188  -2.313 -13.213  1.00 37.41           H  
ATOM    554  HB3 LYS    36     -10.421  -1.060 -13.295  1.00 37.41           H  
ATOM    555  HG2 LYS    36      -8.839   0.620 -12.593  1.00 37.41           H  
ATOM    556  HG3 LYS    36      -7.597  -0.602 -12.327  1.00 37.41           H  
ATOM    557  HD2 LYS    36      -8.861   0.037 -14.998  1.00 37.41           H  
ATOM    558  HD3 LYS    36      -7.297   0.641 -14.448  1.00 37.41           H  
ATOM    559  HE2 LYS    36      -6.500  -1.696 -14.262  1.00 37.41           H  
ATOM    560  HE3 LYS    36      -8.049  -2.252 -14.894  1.00 37.41           H  
ATOM    561  HZ1 LYS    36      -6.090  -0.537 -16.322  1.00 37.41           H  
ATOM    562  HZ2 LYS    36      -7.605  -0.997 -16.924  1.00 37.41           H  
ATOM    563  HZ3 LYS    36      -6.413  -2.166 -16.637  1.00 37.41           H  
ATOM    564  N   SER    37     -11.637  -0.030 -10.725  1.00 24.11           N  
ATOM    565  CA  SER    37     -12.206   1.158 -10.064  1.00 42.53           C  
ATOM    566  C   SER    37     -11.841   1.196  -8.573  1.00  4.25           C  
ATOM    567  O   SER    37     -11.376   2.213  -8.064  1.00 74.34           O  
ATOM    568  CB  SER    37     -13.737   1.184 -10.222  1.00 65.24           C  
ATOM    569  OG  SER    37     -14.322   2.265  -9.504  1.00 74.54           O  
ATOM    570  H   SER    37     -12.221  -0.594 -11.276  1.00 37.41           H  
ATOM    571  HA  SER    37     -11.790   2.033 -10.546  1.00 22.04           H  
ATOM    572  HB2 SER    37     -13.988   1.292 -11.268  1.00 37.41           H  
ATOM    573  HB3 SER    37     -14.152   0.258  -9.851  1.00 37.41           H  
ATOM    574  HG  SER    37     -13.892   3.093  -9.764  1.00  1.20           H  
ATOM    575  N   GLY    38     -12.040   0.071  -7.881  1.00  5.13           N  
ATOM    576  CA  GLY    38     -11.691  -0.019  -6.465  1.00 65.42           C  
ATOM    577  C   GLY    38     -10.193   0.119  -6.202  1.00 20.51           C  
ATOM    578  O   GLY    38      -9.782   0.729  -5.212  1.00 35.31           O  
ATOM    579  H   GLY    38     -12.434  -0.701  -8.334  1.00 37.41           H  
ATOM    580  HA2 GLY    38     -12.210   0.762  -5.929  1.00 37.41           H  
ATOM    581  HA3 GLY    38     -12.021  -0.977  -6.089  1.00 37.41           H  
ATOM    582  N   ALA    39      -9.375  -0.451  -7.084  1.00 14.51           N  
ATOM    583  CA  ALA    39      -7.916  -0.366  -6.955  1.00  2.15           C  
ATOM    584  C   ALA    39      -7.414   1.079  -7.131  1.00 43.23           C  
ATOM    585  O   ALA    39      -6.716   1.617  -6.269  1.00 65.03           O  
ATOM    586  CB  ALA    39      -7.246  -1.290  -7.966  1.00 22.11           C  
ATOM    587  H   ALA    39      -9.761  -0.943  -7.840  1.00 37.41           H  
ATOM    588  HA  ALA    39      -7.651  -0.706  -5.963  1.00 55.24           H  
ATOM    589  HB1 ALA    39      -7.593  -2.301  -7.816  1.00 37.41           H  
ATOM    590  HB2 ALA    39      -6.173  -1.255  -7.833  1.00 37.41           H  
ATOM    591  HB3 ALA    39      -7.492  -0.971  -8.970  1.00 37.41           H  
ATOM    592  N   MET    40      -7.786   1.701  -8.247  1.00  3.10           N  
ATOM    593  CA  MET    40      -7.380   3.081  -8.541  1.00 23.33           C  
ATOM    594  C   MET    40      -7.929   4.060  -7.491  1.00 42.24           C  
ATOM    595  O   MET    40      -7.181   4.866  -6.930  1.00 12.52           O  
ATOM    596  CB  MET    40      -7.850   3.485  -9.942  1.00 43.41           C  
ATOM    597  CG  MET    40      -7.287   2.606 -11.050  1.00 13.52           C  
ATOM    598  SD  MET    40      -5.482   2.610 -11.093  1.00 32.52           S  
ATOM    599  CE  MET    40      -5.155   4.329 -11.473  1.00 52.20           C  
ATOM    600  H   MET    40      -8.347   1.222  -8.892  1.00 37.41           H  
ATOM    601  HA  MET    40      -6.300   3.117  -8.513  1.00 73.45           H  
ATOM    602  HB2 MET    40      -8.930   3.426  -9.979  1.00 37.41           H  
ATOM    603  HB3 MET    40      -7.548   4.505 -10.132  1.00 37.41           H  
ATOM    604  HG2 MET    40      -7.627   1.592 -10.894  1.00 37.41           H  
ATOM    605  HG3 MET    40      -7.658   2.964 -12.000  1.00 37.41           H  
ATOM    606  HE1 MET    40      -5.544   4.955 -10.683  1.00 37.41           H  
ATOM    607  HE2 MET    40      -5.633   4.590 -12.407  1.00 37.41           H  
ATOM    608  HE3 MET    40      -4.089   4.482 -11.560  1.00 37.41           H  
ATOM    609  N   ASN    41      -9.235   3.982  -7.223  1.00 54.43           N  
ATOM    610  CA  ASN    41      -9.854   4.788  -6.164  1.00 55.45           C  
ATOM    611  C   ASN    41      -9.162   4.529  -4.817  1.00 34.44           C  
ATOM    612  O   ASN    41      -9.037   5.428  -3.983  1.00  2.44           O  
ATOM    613  CB  ASN    41     -11.353   4.477  -6.067  1.00 74.23           C  
ATOM    614  CG  ASN    41     -12.070   5.347  -5.048  1.00 64.35           C  
ATOM    615  OD1 ASN    41     -12.499   6.456  -5.352  1.00 42.11           O  
ATOM    616  ND2 ASN    41     -12.216   4.850  -3.835  1.00 53.21           N  
ATOM    617  H   ASN    41      -9.797   3.376  -7.756  1.00 37.41           H  
ATOM    618  HA  ASN    41      -9.726   5.831  -6.426  1.00 43.51           H  
ATOM    619  HB2 ASN    41     -11.811   4.637  -7.032  1.00 37.41           H  
ATOM    620  HB3 ASN    41     -11.482   3.442  -5.784  1.00 37.41           H  
ATOM    621 HD21 ASN    41     -11.856   3.955  -3.653  1.00 37.41           H  
ATOM    622 HD22 ASN    41     -12.684   5.392  -3.169  1.00 37.41           H  
ATOM    623  N   GLY    42      -8.703   3.292  -4.623  1.00 72.21           N  
ATOM    624  CA  GLY    42      -7.892   2.966  -3.460  1.00 21.21           C  
ATOM    625  C   GLY    42      -6.599   3.775  -3.407  1.00 52.31           C  
ATOM    626  O   GLY    42      -6.209   4.261  -2.346  1.00 32.41           O  
ATOM    627  H   GLY    42      -8.924   2.590  -5.273  1.00 37.41           H  
ATOM    628  HA2 GLY    42      -8.468   3.161  -2.565  1.00 37.41           H  
ATOM    629  HA3 GLY    42      -7.644   1.915  -3.494  1.00 37.41           H  
ATOM    630  N   ILE    43      -5.946   3.944  -4.562  1.00 11.41           N  
ATOM    631  CA  ILE    43      -4.716   4.744  -4.647  1.00 54.22           C  
ATOM    632  C   ILE    43      -4.993   6.213  -4.287  1.00 64.31           C  
ATOM    633  O   ILE    43      -4.294   6.809  -3.465  1.00 51.11           O  
ATOM    634  CB  ILE    43      -4.089   4.680  -6.067  1.00 51.41           C  
ATOM    635  CG1 ILE    43      -3.778   3.224  -6.457  1.00 75.32           C  
ATOM    636  CG2 ILE    43      -2.826   5.540  -6.136  1.00 72.23           C  
ATOM    637  CD1 ILE    43      -3.219   3.066  -7.857  1.00 23.24           C  
ATOM    638  H   ILE    43      -6.306   3.531  -5.378  1.00 37.41           H  
ATOM    639  HA  ILE    43      -4.005   4.338  -3.940  1.00 25.12           H  
ATOM    640  HB  ILE    43      -4.804   5.086  -6.769  1.00  3.44           H  
ATOM    641 HG12 ILE    43      -3.053   2.817  -5.767  1.00 37.41           H  
ATOM    642 HG13 ILE    43      -4.688   2.642  -6.397  1.00 37.41           H  
ATOM    643 HG21 ILE    43      -3.074   6.568  -5.907  1.00 37.41           H  
ATOM    644 HG22 ILE    43      -2.403   5.486  -7.128  1.00 37.41           H  
ATOM    645 HG23 ILE    43      -2.102   5.178  -5.418  1.00 37.41           H  
ATOM    646 HD11 ILE    43      -2.285   3.604  -7.936  1.00 37.41           H  
ATOM    647 HD12 ILE    43      -3.924   3.461  -8.573  1.00 37.41           H  
ATOM    648 HD13 ILE    43      -3.049   2.019  -8.060  1.00 37.41           H  
ATOM    649  N   GLU    44      -6.028   6.785  -4.900  1.00 42.02           N  
ATOM    650  CA  GLU    44      -6.435   8.163  -4.607  1.00 44.20           C  
ATOM    651  C   GLU    44      -6.822   8.313  -3.125  1.00  2.01           C  
ATOM    652  O   GLU    44      -6.565   9.348  -2.500  1.00 34.34           O  
ATOM    653  CB  GLU    44      -7.601   8.575  -5.518  1.00 34.11           C  
ATOM    654  CG  GLU    44      -7.288   8.430  -7.007  1.00 35.01           C  
ATOM    655  CD  GLU    44      -8.408   8.934  -7.906  1.00  4.40           C  
ATOM    656  OE1 GLU    44      -9.376   8.180  -8.143  1.00 31.35           O  
ATOM    657  OE2 GLU    44      -8.320  10.084  -8.388  1.00 62.22           O  
ATOM    658  H   GLU    44      -6.532   6.269  -5.567  1.00 37.41           H  
ATOM    659  HA  GLU    44      -5.590   8.806  -4.810  1.00 63.15           H  
ATOM    660  HB2 GLU    44      -8.458   7.956  -5.288  1.00 37.41           H  
ATOM    661  HB3 GLU    44      -7.850   9.608  -5.321  1.00 37.41           H  
ATOM    662  HG2 GLU    44      -6.389   8.987  -7.227  1.00 37.41           H  
ATOM    663  HG3 GLU    44      -7.118   7.383  -7.220  1.00 37.41           H  
ATOM    664  N   SER    45      -7.431   7.267  -2.566  1.00 71.45           N  
ATOM    665  CA  SER    45      -7.729   7.223  -1.129  1.00 64.43           C  
ATOM    666  C   SER    45      -6.431   7.303  -0.315  1.00 65.20           C  
ATOM    667  O   SER    45      -6.324   8.094   0.620  1.00  1.10           O  
ATOM    668  CB  SER    45      -8.501   5.943  -0.769  1.00 20.41           C  
ATOM    669  OG  SER    45      -8.892   5.931   0.598  1.00 73.31           O  
ATOM    670  H   SER    45      -7.690   6.509  -3.131  1.00 37.41           H  
ATOM    671  HA  SER    45      -8.342   8.082  -0.891  1.00  1.13           H  
ATOM    672  HB2 SER    45      -9.387   5.876  -1.383  1.00 37.41           H  
ATOM    673  HB3 SER    45      -7.873   5.081  -0.956  1.00 37.41           H  
ATOM    674  HG  SER    45      -9.836   5.743   0.653  1.00 53.44           H  
ATOM    675  N   VAL    46      -5.434   6.494  -0.694  1.00 74.53           N  
ATOM    676  CA  VAL    46      -4.112   6.532  -0.050  1.00 11.12           C  
ATOM    677  C   VAL    46      -3.501   7.945  -0.102  1.00 70.22           C  
ATOM    678  O   VAL    46      -2.893   8.401   0.865  1.00 14.22           O  
ATOM    679  CB  VAL    46      -3.124   5.524  -0.701  1.00 73.43           C  
ATOM    680  CG1 VAL    46      -1.738   5.622  -0.063  1.00 33.41           C  
ATOM    681  CG2 VAL    46      -3.657   4.095  -0.600  1.00 62.22           C  
ATOM    682  H   VAL    46      -5.590   5.855  -1.422  1.00 37.41           H  
ATOM    683  HA  VAL    46      -4.244   6.251   0.987  1.00 62.22           H  
ATOM    684  HB  VAL    46      -3.028   5.773  -1.751  1.00  4.22           H  
ATOM    685 HG11 VAL    46      -1.332   6.610  -0.227  1.00 37.41           H  
ATOM    686 HG12 VAL    46      -1.082   4.887  -0.508  1.00 37.41           H  
ATOM    687 HG13 VAL    46      -1.816   5.437   0.999  1.00 37.41           H  
ATOM    688 HG21 VAL    46      -3.758   3.819   0.441  1.00 37.41           H  
ATOM    689 HG22 VAL    46      -2.970   3.416  -1.086  1.00 37.41           H  
ATOM    690 HG23 VAL    46      -4.622   4.034  -1.081  1.00 37.41           H  
ATOM    691  N   GLN    47      -3.678   8.636  -1.229  1.00 30.23           N  
ATOM    692  CA  GLN    47      -3.191  10.017  -1.383  1.00 64.14           C  
ATOM    693  C   GLN    47      -3.807  10.953  -0.324  1.00 44.51           C  
ATOM    694  O   GLN    47      -3.102  11.757   0.290  1.00  0.02           O  
ATOM    695  CB  GLN    47      -3.496  10.537  -2.801  1.00 41.10           C  
ATOM    696  CG  GLN    47      -2.785   9.760  -3.907  1.00 73.03           C  
ATOM    697  CD  GLN    47      -3.121  10.267  -5.302  1.00 65.41           C  
ATOM    698  OE1 GLN    47      -4.214  10.765  -5.555  1.00 11.23           O  
ATOM    699  NE2 GLN    47      -2.184  10.153  -6.220  1.00 25.01           N  
ATOM    700  H   GLN    47      -4.141   8.207  -1.980  1.00 37.41           H  
ATOM    701  HA  GLN    47      -2.119  10.002  -1.244  1.00 60.45           H  
ATOM    702  HB2 GLN    47      -4.562  10.475  -2.975  1.00 37.41           H  
ATOM    703  HB3 GLN    47      -3.191  11.572  -2.867  1.00 37.41           H  
ATOM    704  HG2 GLN    47      -1.717   9.842  -3.760  1.00 37.41           H  
ATOM    705  HG3 GLN    47      -3.075   8.721  -3.842  1.00 37.41           H  
ATOM    706 HE21 GLN    47      -1.327   9.753  -5.962  1.00 37.41           H  
ATOM    707 HE22 GLN    47      -2.384  10.471  -7.122  1.00 37.41           H  
ATOM    708  N   THR    48      -5.118  10.835  -0.104  1.00 62.12           N  
ATOM    709  CA  THR    48      -5.808  11.628   0.934  1.00 52.31           C  
ATOM    710  C   THR    48      -5.457  11.143   2.351  1.00 45.00           C  
ATOM    711  O   THR    48      -5.382  11.935   3.290  1.00 12.34           O  
ATOM    712  CB  THR    48      -7.347  11.585   0.756  1.00 31.54           C  
ATOM    713  OG1 THR    48      -7.705  12.112  -0.530  1.00 41.12           O  
ATOM    714  CG2 THR    48      -8.066  12.382   1.845  1.00 24.32           C  
ATOM    715  H   THR    48      -5.640  10.209  -0.657  1.00 37.41           H  
ATOM    716  HA  THR    48      -5.487  12.658   0.831  1.00  2.23           H  
ATOM    717  HB  THR    48      -7.671  10.554   0.812  1.00 51.41           H  
ATOM    718  HG1 THR    48      -7.278  12.971  -0.651  1.00 32.15           H  
ATOM    719 HG21 THR    48      -7.766  13.418   1.791  1.00 37.41           H  
ATOM    720 HG22 THR    48      -7.810  11.985   2.817  1.00 37.41           H  
ATOM    721 HG23 THR    48      -9.135  12.310   1.699  1.00 37.41           H  
ATOM    722  N   ASN    49      -5.245   9.839   2.496  1.00 41.45           N  
ATOM    723  CA  ASN    49      -4.900   9.234   3.791  1.00 12.32           C  
ATOM    724  C   ASN    49      -3.433   9.498   4.172  1.00 34.54           C  
ATOM    725  O   ASN    49      -3.088   9.548   5.350  1.00 72.52           O  
ATOM    726  CB  ASN    49      -5.175   7.726   3.753  1.00 32.14           C  
ATOM    727  CG  ASN    49      -6.646   7.410   3.544  1.00 51.32           C  
ATOM    728  OD1 ASN    49      -7.524   8.100   4.048  1.00  4.51           O  
ATOM    729  ND2 ASN    49      -6.927   6.377   2.783  1.00 14.21           N  
ATOM    730  H   ASN    49      -5.328   9.258   1.710  1.00 37.41           H  
ATOM    731  HA  ASN    49      -5.536   9.684   4.542  1.00 40.24           H  
ATOM    732  HB2 ASN    49      -4.611   7.284   2.944  1.00 37.41           H  
ATOM    733  HB3 ASN    49      -4.860   7.283   4.689  1.00 37.41           H  
ATOM    734 HD21 ASN    49      -6.185   5.872   2.403  1.00 37.41           H  
ATOM    735 HD22 ASN    49      -7.868   6.173   2.610  1.00 37.41           H  
ATOM    736  N   SER    50      -2.581   9.658   3.161  1.00 54.03           N  
ATOM    737  CA  SER    50      -1.131   9.866   3.356  1.00 14.11           C  
ATOM    738  C   SER    50      -0.802  10.941   4.421  1.00 44.35           C  
ATOM    739  O   SER    50       0.011  10.692   5.313  1.00 31.31           O  
ATOM    740  CB  SER    50      -0.464  10.223   2.014  1.00 15.02           C  
ATOM    741  OG  SER    50       0.913  10.533   2.172  1.00 20.01           O  
ATOM    742  H   SER    50      -2.933   9.635   2.249  1.00 37.41           H  
ATOM    743  HA  SER    50      -0.725   8.922   3.695  1.00 71.31           H  
ATOM    744  HB2 SER    50      -0.552   9.384   1.339  1.00 37.41           H  
ATOM    745  HB3 SER    50      -0.965  11.079   1.584  1.00 37.41           H  
ATOM    746  HG  SER    50       1.437   9.729   2.070  1.00 12.52           H  
ATOM    747  N   PRO    51      -1.402  12.156   4.354  1.00 52.03           N  
ATOM    748  CA  PRO    51      -1.169  13.199   5.370  1.00  4.43           C  
ATOM    749  C   PRO    51      -1.944  12.952   6.677  1.00 52.32           C  
ATOM    750  O   PRO    51      -1.650  13.558   7.711  1.00 44.31           O  
ATOM    751  CB  PRO    51      -1.670  14.471   4.675  1.00 73.13           C  
ATOM    752  CG  PRO    51      -2.748  13.994   3.764  1.00 43.32           C  
ATOM    753  CD  PRO    51      -2.319  12.627   3.293  1.00 42.13           C  
ATOM    754  HA  PRO    51      -0.116  13.299   5.596  1.00 13.20           H  
ATOM    755  HB2 PRO    51      -2.049  15.171   5.410  1.00 37.41           H  
ATOM    756  HB3 PRO    51      -0.861  14.927   4.123  1.00 37.41           H  
ATOM    757  HG2 PRO    51      -3.684  13.930   4.302  1.00 37.41           H  
ATOM    758  HG3 PRO    51      -2.845  14.667   2.925  1.00 37.41           H  
ATOM    759  HD2 PRO    51      -3.173  11.972   3.205  1.00 37.41           H  
ATOM    760  HD3 PRO    51      -1.803  12.700   2.346  1.00 37.41           H  
ATOM   1531  N   LYS   102       1.852   9.862  -1.651  1.00 64.32           N  
ATOM   1532  CA  LYS   102       1.064  11.005  -2.128  1.00 23.43           C  
ATOM   1533  C   LYS   102       1.444  11.394  -3.572  1.00 33.45           C  
ATOM   1534  O   LYS   102       1.112  12.486  -4.037  1.00 42.10           O  
ATOM   1535  CB  LYS   102       1.271  12.209  -1.191  1.00 55.44           C  
ATOM   1536  CG  LYS   102       2.708  12.725  -1.150  1.00  1.32           C  
ATOM   1537  CD  LYS   102       2.859  13.962  -0.259  1.00 41.23           C  
ATOM   1538  CE  LYS   102       2.866  13.628   1.232  1.00 74.51           C  
ATOM   1539  NZ  LYS   102       1.570  13.084   1.723  1.00 50.10           N  
ATOM   1540  H   LYS   102       2.756  10.017  -1.318  1.00 37.41           H  
ATOM   1541  HA  LYS   102       0.019  10.726  -2.107  1.00 64.40           H  
ATOM   1542  HB2 LYS   102       0.630  13.016  -1.516  1.00 37.41           H  
ATOM   1543  HB3 LYS   102       0.985  11.920  -0.188  1.00 37.41           H  
ATOM   1544  HG2 LYS   102       3.349  11.942  -0.772  1.00 37.41           H  
ATOM   1545  HG3 LYS   102       3.013  12.979  -2.156  1.00 37.41           H  
ATOM   1546  HD2 LYS   102       3.791  14.452  -0.504  1.00 37.41           H  
ATOM   1547  HD3 LYS   102       2.040  14.640  -0.461  1.00 37.41           H  
ATOM   1548  HE2 LYS   102       3.639  12.897   1.416  1.00 37.41           H  
ATOM   1549  HE3 LYS   102       3.096  14.528   1.784  1.00 37.41           H  
ATOM   1550  HZ1 LYS   102       1.407  12.130   1.341  1.00 37.41           H  
ATOM   1551  HZ2 LYS   102       0.784  13.703   1.435  1.00 37.41           H  
ATOM   1552  HZ3 LYS   102       1.582  13.028   2.761  1.00 37.41           H  
ATOM   1553  N   THR   103       2.137  10.496  -4.280  1.00 35.15           N  
ATOM   1554  CA  THR   103       2.586  10.777  -5.656  1.00 14.31           C  
ATOM   1555  C   THR   103       1.483  10.510  -6.689  1.00 53.11           C  
ATOM   1556  O   THR   103       0.536   9.766  -6.433  1.00 73.50           O  
ATOM   1557  CB  THR   103       3.836   9.947  -6.053  1.00 70.12           C  
ATOM   1558  OG1 THR   103       4.388  10.449  -7.285  1.00 22.34           O  
ATOM   1559  CG2 THR   103       3.496   8.467  -6.228  1.00 71.24           C  
ATOM   1560  H   THR   103       2.344   9.626  -3.875  1.00 37.41           H  
ATOM   1561  HA  THR   103       2.855  11.823  -5.706  1.00 31.50           H  
ATOM   1562  HB  THR   103       4.577  10.041  -5.271  1.00 71.21           H  
ATOM   1563  HG1 THR   103       5.226  10.002  -7.467  1.00  4.21           H  
ATOM   1564 HG21 THR   103       2.754   8.354  -7.008  1.00 37.41           H  
ATOM   1565 HG22 THR   103       3.105   8.073  -5.301  1.00 37.41           H  
ATOM   1566 HG23 THR   103       4.387   7.920  -6.501  1.00 37.41           H  
ATOM   1567  N   THR   104       1.620  11.120  -7.862  1.00 31.13           N  
ATOM   1568  CA  THR   104       0.651  10.944  -8.954  1.00 32.22           C  
ATOM   1569  C   THR   104       1.164   9.969 -10.024  1.00 70.41           C  
ATOM   1570  O   THR   104       0.440   9.627 -10.960  1.00 30.14           O  
ATOM   1571  CB  THR   104       0.320  12.293  -9.635  1.00 24.42           C  
ATOM   1572  OG1 THR   104       1.515  12.875 -10.180  1.00 51.34           O  
ATOM   1573  CG2 THR   104      -0.316  13.266  -8.646  1.00 55.23           C  
ATOM   1574  H   THR   104       2.391  11.714  -8.001  1.00 37.41           H  
ATOM   1575  HA  THR   104      -0.262  10.545  -8.531  1.00 50.10           H  
ATOM   1576  HB  THR   104      -0.380  12.111 -10.439  1.00 22.41           H  
ATOM   1577  HG1 THR   104       1.423  12.956 -11.139  1.00 11.44           H  
ATOM   1578 HG21 THR   104       0.356  13.430  -7.814  1.00 37.41           H  
ATOM   1579 HG22 THR   104      -1.245  12.854  -8.280  1.00 37.41           H  
ATOM   1580 HG23 THR   104      -0.512  14.208  -9.140  1.00 37.41           H  
ATOM   1581  N   THR   105       2.415   9.529  -9.891  1.00 14.23           N  
ATOM   1582  CA  THR   105       3.013   8.591 -10.854  1.00 20.42           C  
ATOM   1583  C   THR   105       2.410   7.184 -10.712  1.00 74.13           C  
ATOM   1584  O   THR   105       2.790   6.416  -9.825  1.00 51.22           O  
ATOM   1585  CB  THR   105       4.554   8.505 -10.693  1.00 44.42           C  
ATOM   1586  OG1 THR   105       5.134   9.813 -10.815  1.00 24.24           O  
ATOM   1587  CG2 THR   105       5.172   7.579 -11.742  1.00 75.21           C  
ATOM   1588  H   THR   105       2.952   9.843  -9.134  1.00 37.41           H  
ATOM   1589  HA  THR   105       2.800   8.962 -11.848  1.00 23.14           H  
ATOM   1590  HB  THR   105       4.779   8.113  -9.709  1.00 13.31           H  
ATOM   1591  HG1 THR   105       5.239  10.030 -11.749  1.00  0.32           H  
ATOM   1592 HG21 THR   105       4.931   7.940 -12.731  1.00 37.41           H  
ATOM   1593 HG22 THR   105       4.782   6.578 -11.620  1.00 37.41           H  
ATOM   1594 HG23 THR   105       6.247   7.561 -11.620  1.00 37.41           H  
ATOM   1595  N   ILE   106       1.457   6.855 -11.586  1.00 44.22           N  
ATOM   1596  CA  ILE   106       0.781   5.551 -11.555  1.00 73.12           C  
ATOM   1597  C   ILE   106       0.951   4.798 -12.887  1.00 32.44           C  
ATOM   1598  O   ILE   106       0.569   5.296 -13.949  1.00 45.14           O  
ATOM   1599  CB  ILE   106      -0.734   5.710 -11.255  1.00 50.10           C  
ATOM   1600  CG1 ILE   106      -0.945   6.476  -9.937  1.00 42.04           C  
ATOM   1601  CG2 ILE   106      -1.417   4.342 -11.201  1.00 24.13           C  
ATOM   1602  CD1 ILE   106      -2.399   6.734  -9.598  1.00 63.53           C  
ATOM   1603  H   ILE   106       1.195   7.511 -12.268  1.00 37.41           H  
ATOM   1604  HA  ILE   106       1.224   4.963 -10.762  1.00 62.42           H  
ATOM   1605  HB  ILE   106      -1.179   6.273 -12.064  1.00 14.02           H  
ATOM   1606 HG12 ILE   106      -0.517   5.907  -9.125  1.00 37.41           H  
ATOM   1607 HG13 ILE   106      -0.445   7.434 -10.000  1.00 37.41           H  
ATOM   1608 HG21 ILE   106      -2.471   4.473 -11.004  1.00 37.41           H  
ATOM   1609 HG22 ILE   106      -0.976   3.749 -10.415  1.00 37.41           H  
ATOM   1610 HG23 ILE   106      -1.290   3.837 -12.148  1.00 37.41           H  
ATOM   1611 HD11 ILE   106      -2.861   7.300 -10.394  1.00 37.41           H  
ATOM   1612 HD12 ILE   106      -2.460   7.294  -8.678  1.00 37.41           H  
ATOM   1613 HD13 ILE   106      -2.915   5.792  -9.480  1.00 37.41           H  
ATOM   1614  N   LYS   107       1.515   3.593 -12.819  1.00 22.22           N  
ATOM   1615  CA  LYS   107       1.743   2.759 -14.007  1.00 24.23           C  
ATOM   1616  C   LYS   107       0.701   1.631 -14.109  1.00 55.21           C  
ATOM   1617  O   LYS   107       0.537   0.849 -13.173  1.00 60.10           O  
ATOM   1618  CB  LYS   107       3.146   2.138 -13.951  1.00 24.43           C  
ATOM   1619  CG  LYS   107       4.284   3.155 -13.897  1.00  0.22           C  
ATOM   1620  CD  LYS   107       5.643   2.470 -13.746  1.00 71.45           C  
ATOM   1621  CE  LYS   107       6.791   3.473 -13.728  1.00 74.43           C  
ATOM   1622  NZ  LYS   107       6.956   4.166 -15.033  1.00 72.12           N  
ATOM   1623  H   LYS   107       1.794   3.251 -11.944  1.00 37.41           H  
ATOM   1624  HA  LYS   107       1.671   3.389 -14.883  1.00  2.54           H  
ATOM   1625  HB2 LYS   107       3.213   1.511 -13.071  1.00 37.41           H  
ATOM   1626  HB3 LYS   107       3.287   1.521 -14.828  1.00 37.41           H  
ATOM   1627  HG2 LYS   107       4.282   3.731 -14.810  1.00 37.41           H  
ATOM   1628  HG3 LYS   107       4.126   3.813 -13.053  1.00 37.41           H  
ATOM   1629  HD2 LYS   107       5.653   1.912 -12.821  1.00 37.41           H  
ATOM   1630  HD3 LYS   107       5.786   1.791 -14.575  1.00 37.41           H  
ATOM   1631  HE2 LYS   107       6.598   4.212 -12.962  1.00 37.41           H  
ATOM   1632  HE3 LYS   107       7.706   2.948 -13.492  1.00 37.41           H  
ATOM   1633  HZ1 LYS   107       6.062   4.614 -15.319  1.00 37.41           H  
ATOM   1634  HZ2 LYS   107       7.240   3.485 -15.767  1.00 37.41           H  
ATOM   1635  HZ3 LYS   107       7.689   4.900 -14.960  1.00 37.41           H  
ATOM   1636  N   ASP   108      -0.007   1.550 -15.237  1.00 71.14           N  
ATOM   1637  CA  ASP   108      -0.917   0.431 -15.488  1.00 54.31           C  
ATOM   1638  C   ASP   108      -0.181  -0.710 -16.218  1.00 22.43           C  
ATOM   1639  O   ASP   108       0.368  -0.516 -17.308  1.00  0.32           O  
ATOM   1640  CB  ASP   108      -2.132   0.895 -16.310  1.00 64.04           C  
ATOM   1641  CG  ASP   108      -3.160  -0.211 -16.509  1.00 60.11           C  
ATOM   1642  OD1 ASP   108      -2.911  -1.126 -17.321  1.00 25.55           O  
ATOM   1643  OD2 ASP   108      -4.223  -0.178 -15.856  1.00 52.43           O  
ATOM   1644  H   ASP   108       0.073   2.261 -15.910  1.00 37.41           H  
ATOM   1645  HA  ASP   108      -1.265   0.064 -14.531  1.00  2.35           H  
ATOM   1646  HB2 ASP   108      -2.607   1.722 -15.801  1.00 37.41           H  
ATOM   1647  HB3 ASP   108      -1.795   1.228 -17.283  1.00 37.41           H  
ATOM   1648  N   LEU   109      -0.162  -1.889 -15.604  1.00 62.34           N  
ATOM   1649  CA  LEU   109       0.457  -3.083 -16.201  1.00  5.54           C  
ATOM   1650  C   LEU   109      -0.608  -4.150 -16.514  1.00 34.51           C  
ATOM   1651  O   LEU   109      -0.292  -5.320 -16.745  1.00 53.33           O  
ATOM   1652  CB  LEU   109       1.511  -3.663 -15.239  1.00  3.13           C  
ATOM   1653  CG  LEU   109       2.597  -2.676 -14.772  1.00 74.52           C  
ATOM   1654  CD1 LEU   109       3.544  -3.347 -13.782  1.00 30.34           C  
ATOM   1655  CD2 LEU   109       3.368  -2.116 -15.964  1.00 45.23           C  
ATOM   1656  H   LEU   109      -0.561  -1.960 -14.712  1.00 37.41           H  
ATOM   1657  HA  LEU   109       0.938  -2.791 -17.124  1.00 40.53           H  
ATOM   1658  HB2 LEU   109       0.999  -4.041 -14.364  1.00 37.41           H  
ATOM   1659  HB3 LEU   109       2.000  -4.493 -15.732  1.00 37.41           H  
ATOM   1660  HG  LEU   109       2.122  -1.847 -14.264  1.00 50.13           H  
ATOM   1661 HD11 LEU   109       4.065  -4.160 -14.269  1.00 37.41           H  
ATOM   1662 HD12 LEU   109       2.977  -3.734 -12.948  1.00 37.41           H  
ATOM   1663 HD13 LEU   109       4.262  -2.624 -13.421  1.00 37.41           H  
ATOM   1664 HD21 LEU   109       2.687  -1.608 -16.630  1.00 37.41           H  
ATOM   1665 HD22 LEU   109       3.852  -2.925 -16.494  1.00 37.41           H  
ATOM   1666 HD23 LEU   109       4.117  -1.419 -15.616  1.00 37.41           H  
ATOM   1667  N   THR   110      -1.872  -3.731 -16.530  1.00  1.33           N  
ATOM   1668  CA  THR   110      -2.999  -4.655 -16.729  1.00 62.42           C  
ATOM   1669  C   THR   110      -3.425  -4.709 -18.201  1.00 13.21           C  
ATOM   1670  O   THR   110      -3.577  -5.787 -18.780  1.00 25.20           O  
ATOM   1671  CB  THR   110      -4.222  -4.245 -15.871  1.00  1.14           C  
ATOM   1672  OG1 THR   110      -4.816  -3.037 -16.381  1.00 74.21           O  
ATOM   1673  CG2 THR   110      -3.816  -4.028 -14.418  1.00 41.22           C  
ATOM   1674  H   THR   110      -2.054  -2.773 -16.421  1.00 37.41           H  
ATOM   1675  HA  THR   110      -2.684  -5.642 -16.420  1.00 10.12           H  
ATOM   1676  HB  THR   110      -4.954  -5.040 -15.907  1.00 33.15           H  
ATOM   1677  HG1 THR   110      -4.211  -2.293 -16.242  1.00  4.31           H  
ATOM   1678 HG21 THR   110      -4.673  -3.694 -13.851  1.00 37.41           H  
ATOM   1679 HG22 THR   110      -3.039  -3.277 -14.368  1.00 37.41           H  
ATOM   1680 HG23 THR   110      -3.449  -4.955 -14.001  1.00 37.41           H  
END
