
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  242 ( 1916),  selected  242 , name 3d2l_C
# Molecule2: number of CA atoms  129 ( 2079),  selected  129 , name T0471_20_148.pdb
# PARAMETERS: 3d2l_C.T0471_20_148.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_C      -       -           -
LGA    A     2_C      -       -           -
LGA    Y     3_C      -       -           -
LGA    E     4_C      -       -           -
LGA    Q     5_C      -       -           -
LGA    F     6_C      -       -           -
LGA    A     7_C      -       -           -
LGA    Y     8_C      -       -           -
LGA    V     9_C      -       -           -
LGA    Y    10_C      -       -           -
LGA    D    11_C      -       -           -
LGA    E    12_C      -       -           -
LGA    L    13_C      -       -           -
LGA    X    14_C      -       -           -
LGA    Q    15_C      -       -           -
LGA    D    16_C      -       -           -
LGA    V    17_C      H    20_A          4.643
LGA    P    18_C      M    21_A          4.882
LGA    Y    19_C      W    22_A          3.189
LGA    P    20_C      N    23_A          2.336
LGA    E    21_C      D    24_A          2.129
LGA    W    22_C      L    25_A          1.878
LGA    V    23_C      A    26_A          0.592
LGA    A    24_C      V    27_A          1.020
LGA    W    25_C      Y    28_A          1.713
LGA    V    26_C      I    29_A          0.961
LGA    L    27_C      I    30_A          2.243
LGA    E    28_C      R    31_A          3.089
LGA    Q    29_C      C    32_A          2.404
LGA    V    30_C      S    33_A          2.405
LGA    E    31_C      G    34_A          3.023
LGA    P    32_C      P    35_A          3.523
LGA    G    33_C      G    36_A          2.867
LGA    K    34_C      T    37_A          1.830
LGA    R    35_C      R    38_A          1.114
LGA    I    36_C      V    39_A          0.769
LGA    A    37_C      V    40_A          1.261
LGA    D    38_C      E    41_A          1.172
LGA    I    39_C      V    42_A          1.117
LGA    G    40_C      G    43_A          1.154
LGA    C    41_C      A    44_A          1.447
LGA    G    42_C      G    45_A          2.221
LGA    T    43_C      R    46_A          1.729
LGA    -       -      F    47_A           -
LGA    G    44_C      L    48_A          1.286
LGA    T    45_C      Y    49_A          1.428
LGA    A    46_C      V    50_A          1.047
LGA    T    47_C      S    51_A          1.830
LGA    L    48_C      D    52_A          1.143
LGA    L    49_C      Y    53_A          1.489
LGA    L    50_C      I    54_A          2.430
LGA    A    51_C      R    55_A          1.957
LGA    D    52_C      K    56_A          3.272
LGA    -       -      H    57_A           -
LGA    H    53_C      S    58_A          2.693
LGA    -       -      K    59_A           -
LGA    Y    54_C      V    60_A          1.180
LGA    E    55_C      D    61_A          1.009
LGA    V    56_C      L    62_A          1.160
LGA    T    57_C      V    63_A          0.786
LGA    G    58_C      L    64_A          0.435
LGA    V    59_C      T    65_A          0.272
LGA    D    60_C      D    66_A          1.029
LGA    L    61_C      I    67_A          1.645
LGA    S    62_C      K    68_A          3.303
LGA    E    63_C      P    69_A          2.515
LGA    E    64_C      S    70_A          2.409
LGA    X    65_C      -       -           -
LGA    L    66_C      -       -           -
LGA    E    67_C      H    71_A          1.437
LGA    I    68_C      -       -           -
LGA    A    69_C      G    72_A           #
LGA    Q    70_C      G    73_A          3.617
LGA    E    71_C      -       -           -
LGA    K    72_C      -       -           -
LGA    A    73_C      -       -           -
LGA    X    74_C      -       -           -
LGA    E    75_C      -       -           -
LGA    T    76_C      -       -           -
LGA    N    77_C      -       -           -
LGA    R    78_C      -       -           -
LGA    H    79_C      -       -           -
LGA    V    80_C      -       -           -
LGA    D    81_C      -       -           -
LGA    F    82_C      I    74_A          2.110
LGA    W    83_C      V    75_A          1.015
LGA    V    84_C      R    76_A          1.099
LGA    Q    85_C      D    77_A          2.539
LGA    D    86_C      D    78_A          3.964
LGA    X    87_C      I    79_A          3.494
LGA    R    88_C      T    80_A          4.373
LGA    E    89_C      S    81_A          2.934
LGA    L    90_C      P    82_A          3.917
LGA    E    91_C      R    83_A          2.511
LGA    -       -      M    84_A           -
LGA    -       -      E    85_A           -
LGA    L    92_C      I    86_A          0.709
LGA    P    93_C      Y    87_A           #
LGA    E    94_C      R    88_A          5.297
LGA    P    95_C      G    89_A          1.611
LGA    V    96_C      A    90_A          0.890
LGA    D    97_C      A    91_A          1.293
LGA    A    98_C      L    92_A          1.256
LGA    I    99_C      I    93_A          0.795
LGA    T   100_C      Y    94_A          1.552
LGA    I   101_C      S    95_A          1.436
LGA    L   102_C      I    96_A          3.711
LGA    C   103_C      -       -           -
LGA    D   104_C      -       -           -
LGA    S   105_C      R    97_A          2.491
LGA    L   106_C      P    98_A          1.790
LGA    N   107_C      P    99_A          4.099
LGA    Y   108_C      -       -           -
LGA    L   109_C      -       -           -
LGA    Q   110_C      A   100_A          5.074
LGA    T   111_C      E   101_A          3.318
LGA    E   112_C      -       -           -
LGA    A   113_C      -       -           -
LGA    D   114_C      I   102_A          2.511
LGA    V   115_C      H   103_A          2.520
LGA    K   116_C      S   104_A          2.055
LGA    Q   117_C      S   105_A          2.304
LGA    T   118_C      L   106_A          2.740
LGA    F   119_C      M   107_A          2.412
LGA    D   120_C      R   108_A          2.199
LGA    S   121_C      V   109_A          2.524
LGA    A   122_C      A   110_A          2.912
LGA    A   123_C      D   111_A          2.222
LGA    R   124_C      A   112_A          2.099
LGA    L   125_C      V   113_A          2.709
LGA    L   126_C      G   114_A          2.591
LGA    T   127_C      -       -           -
LGA    D   128_C      -       -           -
LGA    G   129_C      -       -           -
LGA    G   130_C      A   115_A          2.264
LGA    K   131_C      R   116_A          1.189
LGA    L   132_C      L   117_A          1.265
LGA    L   133_C      I   118_A          1.548
LGA    F   134_C      I   119_A          2.037
LGA    D   135_C      K   120_A          0.909
LGA    V   136_C      P   121_A          1.066
LGA    H   137_C      L   122_A          0.772
LGA    S   138_C      T   123_A          2.026
LGA    P   139_C      G   124_A          2.514
LGA    Y   140_C      -       -           -
LGA    K   141_C      -       -           -
LGA    X   142_C      -       -           -
LGA    E   143_C      -       -           -
LGA    T   144_C      -       -           -
LGA    L   145_C      -       -           -
LGA    F   146_C      -       -           -
LGA    N   147_C      -       -           -
LGA    G   148_C      -       -           -
LGA    K   149_C      -       -           -
LGA    T   150_C      -       -           -
LGA    Y   151_C      -       -           -
LGA    A   152_C      -       -           -
LGA    T   153_C      -       -           -
LGA    H   154_C      -       -           -
LGA    A   155_C      -       -           -
LGA    E   156_C      -       -           -
LGA    Q   157_C      -       -           -
LGA    S   158_C      -       -           -
LGA    S   159_C      -       -           -
LGA    Y   160_C      -       -           -
LGA    I   161_C      -       -           -
LGA    W   162_C      -       -           -
LGA    F   163_C      -       -           -
LGA    A   164_C      -       -           -
LGA    D   165_C      -       -           -
LGA    P   166_C      -       -           -
LGA    G   167_C      -       -           -
LGA    E   168_C      -       -           -
LGA    E   169_C      -       -           -
LGA    P   170_C      -       -           -
LGA    L   171_C      -       -           -
LGA    S   172_C      -       -           -
LGA    V   173_C      -       -           -
LGA    V   174_C      -       -           -
LGA    H   175_C      -       -           -
LGA    E   176_C      -       -           -
LGA    L   177_C      -       -           -
LGA    T   178_C      -       -           -
LGA    F   179_C      -       -           -
LGA    F   180_C      -       -           -
LGA    I   181_C      -       -           -
LGA    E   182_C      -       -           -
LGA    G   183_C      -       -           -
LGA    E   184_C      -       -           -
LGA    D   185_C      -       -           -
LGA    G   186_C      -       -           -
LGA    R   187_C      -       -           -
LGA    Y   188_C      -       -           -
LGA    D   189_C      -       -           -
LGA    R   190_C      -       -           -
LGA    V   191_C      -       -           -
LGA    D   192_C      -       -           -
LGA    E   193_C      -       -           -
LGA    T   194_C      -       -           -
LGA    H   195_C      -       -           -
LGA    H   196_C      -       -           -
LGA    Q   197_C      -       -           -
LGA    R   198_C      -       -           -
LGA    T   199_C      E   125_A          1.034
LGA    Y   200_C      D   126_A          1.499
LGA    P   201_C      -       -           -
LGA    P   202_C      -       -           -
LGA    E   203_C      -       -           -
LGA    Q   204_C      -       -           -
LGA    Y   205_C      I   127_A          3.017
LGA    I   206_C      V   128_A           -
LGA    T   207_C      -       -           -
LGA    W   208_C      T   129_A          1.696
LGA    L   209_C      -       -           -
LGA    R   210_C      -       -           -
LGA    E   211_C      E   130_A          4.725
LGA    A   212_C      R   131_A           -
LGA    G   213_C      -       -           -
LGA    F   214_C      -       -           -
LGA    R   215_C      K   132_A          4.957
LGA    V   216_C      M   133_A          3.629
LGA    C   217_C      -       -           -
LGA    A   218_C      K   134_A          4.262
LGA    V   219_C      L   135_A          0.597
LGA    T   220_C      V   136_A          2.630
LGA    G   221_C      N   137_A          4.153
LGA    D   222_C      -       -           -
LGA    F   223_C      Y   138_A          3.361
LGA    K   224_C      G   139_A          3.262
LGA    S   225_C      R   140_A           #
LGA    D   226_C      T   141_A           -
LGA    A   227_C      -       -           -
LGA    P   228_C      -       -           -
LGA    T   229_C      -       -           -
LGA    E   230_C      -       -           -
LGA    T   231_C      -       -           -
LGA    A   232_C      -       -           -
LGA    E   233_C      -       -           -
LGA    R   234_C      -       -           -
LGA    I   235_C      Y   142_A          3.443
LGA    F   236_C      F   143_A          0.911
LGA    F   237_C      Y   144_A          1.764
LGA    V   238_C      E   145_A          2.238
LGA    A   239_C      Y   146_A          1.342
LGA    E   240_C      I   147_A          1.020
LGA    K   241_C      A   148_A          0.990
LGA    I   242_C      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  242  129    5.0    118    2.46    10.17     60.852     4.606

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.730201 * X  +   0.467897 * Y  +   0.497874 * Z  + -44.905151
  Y_new =  -0.515581 * X  +  -0.855505 * Y  +   0.047825 * Z  +  36.180283
  Z_new =   0.448311 * X  +  -0.221772 * Y  +   0.865930 * Z  + -70.105049 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.250720    2.890872  [ DEG:   -14.3652    165.6348 ]
  Theta =  -0.464875   -2.676718  [ DEG:   -26.6354   -153.3646 ]
  Phi   =  -2.526798    0.614795  [ DEG:  -144.7748     35.2252 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3d2l_C                                        
REMARK     2: T0471_20_148.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3d2l_C.T0471_20_148.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  242  129   5.0  118   2.46   10.17  60.852
REMARK  ---------------------------------------------------------- 
MOLECULE 3d2l_C
HEADER    TRANSFERASE                             08-MAY-08   3D2L              
TITLE     CRYSTAL STRUCTURE OF SAM-DEPENDENT METHYLTRANSFERASE                  
TITLE    2 (ZP_00538691.1) FROM EXIGUOBACTERIUM SP. 255-15 AT 1.90 A            
TITLE    3 RESOLUTION                                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SAM-DEPENDENT METHYLTRANSFERASE;                           
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: EXIGUOBACTERIUM SIBIRICUM 255-15;               
SOURCE   3 GENE: ZP_00538691.1, EXIGDRAFT_1659;                                 
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    ZP_00538691.1, SAM-DEPENDENT METHYLTRANSFERASE, STRUCTURAL            
KEYWDS   2 GENOMICS, JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG,                
KEYWDS   3 PROTEIN STRUCTURE INITIATIVE, PSI-2, METHYLTRANSFERASE               
KEYWDS   4 DOMAIN                                                               
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   20-MAY-08 3D2L    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF SAM-DEPENDENT                           
JRNL        TITL 2 METHYLTRANSFERASE (ZP_00538691.1) FROM                       
JRNL        TITL 3 EXIGUOBACTERIUM SP. 255-15 AT 1.90 A RESOLUTION              
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  3D2L A    1   242  UNP    Q41FK2   Q41FK2_9BACI     1    242             
DBREF  3D2L B    1   242  UNP    Q41FK2   Q41FK2_9BACI     1    242             
DBREF  3D2L C    1   242  UNP    Q41FK2   Q41FK2_9BACI     1    242             
DBREF  3D2L D    1   242  UNP    Q41FK2   Q41FK2_9BACI     1    242             
SEQRES   1 A  243  GLY MSE ALA TYR GLU GLN PHE ALA TYR VAL TYR ASP GLU          
SEQRES   2 A  243  LEU MSE GLN ASP VAL PRO TYR PRO GLU TRP VAL ALA TRP          
SEQRES   3 A  243  VAL LEU GLU GLN VAL GLU PRO GLY LYS ARG ILE ALA ASP          
SEQRES   4 A  243  ILE GLY CYS GLY THR GLY THR ALA THR LEU LEU LEU ALA          
SEQRES   5 A  243  ASP HIS TYR GLU VAL THR GLY VAL ASP LEU SER GLU GLU          
SEQRES   6 A  243  MSE LEU GLU ILE ALA GLN GLU LYS ALA MSE GLU THR ASN          
SEQRES   7 A  243  ARG HIS VAL ASP PHE TRP VAL GLN ASP MSE ARG GLU LEU          
SEQRES   8 A  243  GLU LEU PRO GLU PRO VAL ASP ALA ILE THR ILE LEU CYS          
SEQRES   9 A  243  ASP SER LEU ASN TYR LEU GLN THR GLU ALA ASP VAL LYS          
SEQRES  10 A  243  GLN THR PHE ASP SER ALA ALA ARG LEU LEU THR ASP GLY          
SEQRES  11 A  243  GLY LYS LEU LEU PHE ASP VAL HIS SER PRO TYR LYS MSE          
SEQRES  12 A  243  GLU THR LEU PHE ASN GLY LYS THR TYR ALA THR HIS ALA          
SEQRES  13 A  243  GLU GLN SER SER TYR ILE TRP PHE ALA ASP PRO GLY GLU          
SEQRES  14 A  243  GLU PRO LEU SER VAL VAL HIS GLU LEU THR PHE PHE ILE          
SEQRES  15 A  243  GLU GLY GLU ASP GLY ARG TYR ASP ARG VAL ASP GLU THR          
SEQRES  16 A  243  HIS HIS GLN ARG THR TYR PRO PRO GLU GLN TYR ILE THR          
SEQRES  17 A  243  TRP LEU ARG GLU ALA GLY PHE ARG VAL CYS ALA VAL THR          
SEQRES  18 A  243  GLY ASP PHE LYS SER ASP ALA PRO THR GLU THR ALA GLU          
SEQRES  19 A  243  ARG ILE PHE PHE VAL ALA GLU LYS ILE                          
SEQRES   1 B  243  GLY MSE ALA TYR GLU GLN PHE ALA TYR VAL TYR ASP GLU          
SEQRES   2 B  243  LEU MSE GLN ASP VAL PRO TYR PRO GLU TRP VAL ALA TRP          
SEQRES   3 B  243  VAL LEU GLU GLN VAL GLU PRO GLY LYS ARG ILE ALA ASP          
SEQRES   4 B  243  ILE GLY CYS GLY THR GLY THR ALA THR LEU LEU LEU ALA          
SEQRES   5 B  243  ASP HIS TYR GLU VAL THR GLY VAL ASP LEU SER GLU GLU          
SEQRES   6 B  243  MSE LEU GLU ILE ALA GLN GLU LYS ALA MSE GLU THR ASN          
SEQRES   7 B  243  ARG HIS VAL ASP PHE TRP VAL GLN ASP MSE ARG GLU LEU          
SEQRES   8 B  243  GLU LEU PRO GLU PRO VAL ASP ALA ILE THR ILE LEU CYS          
SEQRES   9 B  243  ASP SER LEU ASN TYR LEU GLN THR GLU ALA ASP VAL LYS          
SEQRES  10 B  243  GLN THR PHE ASP SER ALA ALA ARG LEU LEU THR ASP GLY          
SEQRES  11 B  243  GLY LYS LEU LEU PHE ASP VAL HIS SER PRO TYR LYS MSE          
SEQRES  12 B  243  GLU THR LEU PHE ASN GLY LYS THR TYR ALA THR HIS ALA          
SEQRES  13 B  243  GLU GLN SER SER TYR ILE TRP PHE ALA ASP PRO GLY GLU          
SEQRES  14 B  243  GLU PRO LEU SER VAL VAL HIS GLU LEU THR PHE PHE ILE          
SEQRES  15 B  243  GLU GLY GLU ASP GLY ARG TYR ASP ARG VAL ASP GLU THR          
SEQRES  16 B  243  HIS HIS GLN ARG THR TYR PRO PRO GLU GLN TYR ILE THR          
SEQRES  17 B  243  TRP LEU ARG GLU ALA GLY PHE ARG VAL CYS ALA VAL THR          
SEQRES  18 B  243  GLY ASP PHE LYS SER ASP ALA PRO THR GLU THR ALA GLU          
SEQRES  19 B  243  ARG ILE PHE PHE VAL ALA GLU LYS ILE                          
SEQRES   1 C  243  GLY MSE ALA TYR GLU GLN PHE ALA TYR VAL TYR ASP GLU          
SEQRES   2 C  243  LEU MSE GLN ASP VAL PRO TYR PRO GLU TRP VAL ALA TRP          
SEQRES   3 C  243  VAL LEU GLU GLN VAL GLU PRO GLY LYS ARG ILE ALA ASP          
SEQRES   4 C  243  ILE GLY CYS GLY THR GLY THR ALA THR LEU LEU LEU ALA          
SEQRES   5 C  243  ASP HIS TYR GLU VAL THR GLY VAL ASP LEU SER GLU GLU          
SEQRES   6 C  243  MSE LEU GLU ILE ALA GLN GLU LYS ALA MSE GLU THR ASN          
SEQRES   7 C  243  ARG HIS VAL ASP PHE TRP VAL GLN ASP MSE ARG GLU LEU          
SEQRES   8 C  243  GLU LEU PRO GLU PRO VAL ASP ALA ILE THR ILE LEU CYS          
SEQRES   9 C  243  ASP SER LEU ASN TYR LEU GLN THR GLU ALA ASP VAL LYS          
SEQRES  10 C  243  GLN THR PHE ASP SER ALA ALA ARG LEU LEU THR ASP GLY          
SEQRES  11 C  243  GLY LYS LEU LEU PHE ASP VAL HIS SER PRO TYR LYS MSE          
SEQRES  12 C  243  GLU THR LEU PHE ASN GLY LYS THR TYR ALA THR HIS ALA          
SEQRES  13 C  243  GLU GLN SER SER TYR ILE TRP PHE ALA ASP PRO GLY GLU          
SEQRES  14 C  243  GLU PRO LEU SER VAL VAL HIS GLU LEU THR PHE PHE ILE          
SEQRES  15 C  243  GLU GLY GLU ASP GLY ARG TYR ASP ARG VAL ASP GLU THR          
SEQRES  16 C  243  HIS HIS GLN ARG THR TYR PRO PRO GLU GLN TYR ILE THR          
SEQRES  17 C  243  TRP LEU ARG GLU ALA GLY PHE ARG VAL CYS ALA VAL THR          
SEQRES  18 C  243  GLY ASP PHE LYS SER ASP ALA PRO THR GLU THR ALA GLU          
SEQRES  19 C  243  ARG ILE PHE PHE VAL ALA GLU LYS ILE                          
SEQRES   1 D  243  GLY MSE ALA TYR GLU GLN PHE ALA TYR VAL TYR ASP GLU          
SEQRES   2 D  243  LEU MSE GLN ASP VAL PRO TYR PRO GLU TRP VAL ALA TRP          
SEQRES   3 D  243  VAL LEU GLU GLN VAL GLU PRO GLY LYS ARG ILE ALA ASP          
SEQRES   4 D  243  ILE GLY CYS GLY THR GLY THR ALA THR LEU LEU LEU ALA          
SEQRES   5 D  243  ASP HIS TYR GLU VAL THR GLY VAL ASP LEU SER GLU GLU          
SEQRES   6 D  243  MSE LEU GLU ILE ALA GLN GLU LYS ALA MSE GLU THR ASN          
SEQRES   7 D  243  ARG HIS VAL ASP PHE TRP VAL GLN ASP MSE ARG GLU LEU          
SEQRES   8 D  243  GLU LEU PRO GLU PRO VAL ASP ALA ILE THR ILE LEU CYS          
SEQRES   9 D  243  ASP SER LEU ASN TYR LEU GLN THR GLU ALA ASP VAL LYS          
SEQRES  10 D  243  GLN THR PHE ASP SER ALA ALA ARG LEU LEU THR ASP GLY          
SEQRES  11 D  243  GLY LYS LEU LEU PHE ASP VAL HIS SER PRO TYR LYS MSE          
SEQRES  12 D  243  GLU THR LEU PHE ASN GLY LYS THR TYR ALA THR HIS ALA          
SEQRES  13 D  243  GLU GLN SER SER TYR ILE TRP PHE ALA ASP PRO GLY GLU          
SEQRES  14 D  243  GLU PRO LEU SER VAL VAL HIS GLU LEU THR PHE PHE ILE          
SEQRES  15 D  243  GLU GLY GLU ASP GLY ARG TYR ASP ARG VAL ASP GLU THR          
SEQRES  16 D  243  HIS HIS GLN ARG THR TYR PRO PRO GLU GLN TYR ILE THR          
SEQRES  17 D  243  TRP LEU ARG GLU ALA GLY PHE ARG VAL CYS ALA VAL THR          
SEQRES  18 D  243  GLY ASP PHE LYS SER ASP ALA PRO THR GLU THR ALA GLU          
SEQRES  19 D  243  ARG ILE PHE PHE VAL ALA GLU LYS ILE                          
HET    MSE  A  14      13                                                       
HET    MSE  A  65       8                                                       
HET    MSE  A  74       8                                                       
HET    MSE  A  87       8                                                       
HET    MSE  A 142      13                                                       
HET    MSE  B  14      13                                                       
HET    MSE  B  65       8                                                       
HET    MSE  B  74       8                                                       
HET    MSE  B  87       8                                                       
HET    MSE  B 142      13                                                       
HET    MSE  C   1       8                                                       
HET    MSE  C  14      13                                                       
HET    MSE  C  65       8                                                       
HET    MSE  C  74       8                                                       
HET    MSE  C  87       8                                                       
HET    MSE  C 142      13                                                       
HET    MSE  D  14       8                                                       
HET    MSE  D  65      13                                                       
HET    MSE  D  74       8                                                       
HET    MSE  D  87       8                                                       
HET    MSE  D 142      13                                                       
HET     MG  A 243       1                                                       
HET     MG  B 243       1                                                       
HET     MG  B 244       1                                                       
HET     MG  C 243       1                                                       
HET     MG  D 243       1                                                       
HET     MG  D 244       1                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      MG MAGNESIUM ION                                                    
FORMUL   1  MSE    21(C5 H11 N O2 SE)                                           
FORMUL   5   MG    6(MG 2+)                                                     
FORMUL  11  HOH   *516(H2 O)                                                    
CRYST1   67.830   70.920   77.190 116.57 104.63 102.32 P 1           4          
HETATM 3869  N   MSE C   1     -17.020  -5.269 -24.503  1.00 42.44           N  
HETATM 3870  CA  MSE C   1     -15.687  -5.039 -25.147  1.00 42.77           C  
HETATM 3871  C   MSE C   1     -14.629  -6.048 -24.667  1.00 41.85           C  
HETATM 3872  O   MSE C   1     -14.705  -6.552 -23.539  1.00 39.82           O  
HETATM 3873  CB  MSE C   1     -15.185  -3.599 -24.903  1.00 42.79           C  
HETATM 3874  CG  MSE C   1     -16.007  -2.471 -25.582  1.00 46.05           C  
HETATM 3875 SE   MSE C   1     -16.316  -2.643 -27.569  0.75 51.30          SE  
HETATM 3876  CE  MSE C   1     -14.635  -3.791 -27.951  1.00 60.08           C  
ATOM   3877  N   ALA C   2     -13.636  -6.311 -25.523  1.00 41.42           N  
ATOM   3878  CA  ALA C   2     -12.549  -7.262 -25.219  1.00 41.84           C  
ATOM   3879  C   ALA C   2     -11.786  -6.936 -23.939  1.00 41.19           C  
ATOM   3880  O   ALA C   2     -11.446  -7.852 -23.203  1.00 37.59           O  
ATOM   3881  CB  ALA C   2     -11.573  -7.377 -26.396  1.00 42.89           C  
ATOM   3882  N   TYR C   3     -11.516  -5.656 -23.654  1.00 41.36           N  
ATOM   3883  CA  TYR C   3     -10.785  -5.296 -22.405  1.00 42.64           C  
ATOM   3884  C   TYR C   3     -11.721  -5.381 -21.193  1.00 44.99           C  
ATOM   3885  O   TYR C   3     -11.283  -5.708 -20.086  1.00 42.34           O  
ATOM   3886  CB  TYR C   3     -10.156  -3.889 -22.472  1.00 41.51           C  
ATOM   3887  CG  TYR C   3     -11.121  -2.733 -22.205  1.00 40.34           C  
ATOM   3888  CD1 TYR C   3     -11.896  -2.171 -23.231  1.00 28.83           C  
ATOM   3889  CD2 TYR C   3     -11.250  -2.197 -20.913  1.00 44.00           C  
ATOM   3890  CE1 TYR C   3     -12.789  -1.123 -22.962  1.00 36.08           C  
ATOM   3891  CE2 TYR C   3     -12.142  -1.140 -20.650  1.00 39.25           C  
ATOM   3892  CZ  TYR C   3     -12.884  -0.603 -21.667  1.00 34.33           C  
ATOM   3893  OH  TYR C   3     -13.728   0.435 -21.353  1.00 33.43           O  
ATOM   3894  N   GLU C   4     -13.002  -5.067 -21.422  1.00 47.81           N  
ATOM   3895  CA  GLU C   4     -14.029  -5.103 -20.388  1.00 52.28           C  
ATOM   3896  C   GLU C   4     -14.437  -6.551 -20.206  1.00 57.37           C  
ATOM   3897  O   GLU C   4     -14.265  -7.361 -21.125  1.00 58.77           O  
ATOM   3898  CB  GLU C   4     -15.250  -4.267 -20.802  1.00 51.57           C  
ATOM   3899  N   GLN C   5     -14.940  -6.906 -19.022  1.00 59.88           N  
ATOM   3900  CA  GLN C   5     -15.419  -8.266 -18.789  1.00 61.12           C  
ATOM   3901  C   GLN C   5     -14.229  -9.218 -18.932  1.00 60.89           C  
ATOM   3902  O   GLN C   5     -14.172 -10.258 -18.268  1.00 61.64           O  
ATOM   3903  CB  GLN C   5     -16.582  -8.616 -19.750  1.00 61.60           C  
ATOM   3904  N   PHE C   6     -13.304  -8.864 -19.831  1.00 59.34           N  
ATOM   3905  CA  PHE C   6     -12.024  -9.540 -19.958  1.00 56.69           C  
ATOM   3906  C   PHE C   6     -11.285  -9.334 -18.651  1.00 54.28           C  
ATOM   3907  O   PHE C   6     -10.570 -10.221 -18.183  1.00 53.47           O  
ATOM   3908  CB  PHE C   6     -11.188  -8.917 -21.070  1.00 56.54           C  
ATOM   3909  CG  PHE C   6      -9.741  -9.271 -20.998  1.00 55.06           C  
ATOM   3910  CD1 PHE C   6      -9.218 -10.246 -21.816  1.00 58.54           C  
ATOM   3911  CD2 PHE C   6      -8.905  -8.662 -20.070  1.00 56.15           C  
ATOM   3912  CE1 PHE C   6      -7.889 -10.596 -21.721  1.00 59.50           C  
ATOM   3913  CE2 PHE C   6      -7.580  -9.017 -19.961  1.00 55.27           C  
ATOM   3914  CZ  PHE C   6      -7.070  -9.981 -20.790  1.00 59.27           C  
ATOM   3915  N   ALA C   7     -11.413  -8.128 -18.093  1.00 50.84           N  
ATOM   3916  CA  ALA C   7     -10.791  -7.833 -16.815  1.00 50.53           C  
ATOM   3917  C   ALA C   7     -11.407  -8.766 -15.772  1.00 48.96           C  
ATOM   3918  O   ALA C   7     -10.728  -9.216 -14.872  1.00 46.17           O  
ATOM   3919  CB  ALA C   7     -10.994  -6.368 -16.431  1.00 49.34           C  
ATOM   3920  N   TYR C   8     -12.692  -9.080 -15.911  1.00 50.49           N  
ATOM   3921  CA  TYR C   8     -13.320  -9.939 -14.914  1.00 52.83           C  
ATOM   3922  C   TYR C   8     -12.736 -11.326 -14.987  1.00 52.59           C  
ATOM   3923  O   TYR C   8     -12.462 -11.918 -13.952  1.00 54.92           O  
ATOM   3924  CB  TYR C   8     -14.856  -9.987 -15.007  1.00 53.76           C  
ATOM   3925  CG  TYR C   8     -15.469  -9.677 -13.646  1.00 57.56           C  
ATOM   3926  CD1 TYR C   8     -15.047 -10.351 -12.471  1.00 52.95           C  
ATOM   3927  CD2 TYR C   8     -16.433  -8.675 -13.515  1.00 56.95           C  
ATOM   3928  CE1 TYR C   8     -15.588 -10.026 -11.214  1.00 53.96           C  
ATOM   3929  CE2 TYR C   8     -16.980  -8.350 -12.268  1.00 57.95           C  
ATOM   3930  CZ  TYR C   8     -16.567  -9.023 -11.127  1.00 57.39           C  
ATOM   3931  OH  TYR C   8     -17.147  -8.679  -9.919  1.00 59.25           O  
ATOM   3932  N   VAL C   9     -12.480 -11.834 -16.190  1.00 52.66           N  
ATOM   3933  CA  VAL C   9     -11.915 -13.179 -16.300  1.00 52.75           C  
ATOM   3934  C   VAL C   9     -10.593 -13.227 -15.566  1.00 51.34           C  
ATOM   3935  O   VAL C   9     -10.333 -14.185 -14.871  1.00 50.57           O  
ATOM   3936  CB  VAL C   9     -11.760 -13.722 -17.764  1.00 52.96           C  
ATOM   3937  CG1 VAL C   9     -13.089 -13.568 -18.543  1.00 51.65           C  
ATOM   3938  CG2 VAL C   9     -10.552 -13.087 -18.490  1.00 52.79           C  
ATOM   3939  N   TYR C  10      -9.785 -12.181 -15.676  1.00 51.15           N  
ATOM   3940  CA  TYR C  10      -8.482 -12.133 -15.008  1.00 49.90           C  
ATOM   3941  C   TYR C  10      -8.489 -12.480 -13.493  1.00 49.91           C  
ATOM   3942  O   TYR C  10      -7.479 -12.973 -12.952  1.00 48.59           O  
ATOM   3943  CB  TYR C  10      -7.828 -10.783 -15.243  1.00 53.51           C  
ATOM   3944  CG  TYR C  10      -6.438 -10.739 -14.712  1.00 51.81           C  
ATOM   3945  CD1 TYR C  10      -5.399 -11.358 -15.409  1.00 61.71           C  
ATOM   3946  CD2 TYR C  10      -6.150 -10.116 -13.501  1.00 59.58           C  
ATOM   3947  CE1 TYR C  10      -4.085 -11.355 -14.915  1.00 59.28           C  
ATOM   3948  CE2 TYR C  10      -4.829 -10.097 -12.989  1.00 61.62           C  
ATOM   3949  CZ  TYR C  10      -3.803 -10.716 -13.710  1.00 61.61           C  
ATOM   3950  OH  TYR C  10      -2.508 -10.729 -13.229  1.00 55.37           O  
ATOM   3951  N   ASP C  11      -9.595 -12.213 -12.801  1.00 48.71           N  
ATOM   3952  CA  ASP C  11      -9.745 -12.689 -11.405  1.00 48.46           C  
ATOM   3953  C   ASP C  11      -9.728 -14.249 -11.357  1.00 48.50           C  
ATOM   3954  O   ASP C  11      -9.292 -14.867 -10.376  1.00 49.52           O  
ATOM   3955  CB  ASP C  11     -11.023 -12.122 -10.777  1.00 47.08           C  
ATOM   3956  CG  ASP C  11     -10.925 -10.605 -10.507  1.00 48.11           C  
ATOM   3957  OD1 ASP C  11      -9.838 -10.038 -10.735  1.00 50.38           O  
ATOM   3958  OD2 ASP C  11     -11.915  -9.976 -10.058  1.00 38.00           O  
ATOM   3959  N   GLU C  12     -10.171 -14.857 -12.448  1.00 47.59           N  
ATOM   3960  CA  GLU C  12     -10.198 -16.302 -12.636  1.00 48.17           C  
ATOM   3961  C   GLU C  12      -8.750 -16.846 -12.646  1.00 47.92           C  
ATOM   3962  O   GLU C  12      -8.452 -17.795 -11.936  1.00 48.00           O  
ATOM   3963  CB  GLU C  12     -10.977 -16.630 -13.949  1.00 48.84           C  
ATOM   3964  CG  GLU C  12     -11.984 -17.761 -13.847  1.00 52.69           C  
ATOM   3965  CD  GLU C  12     -13.062 -17.709 -14.951  1.00 50.26           C  
ATOM   3966  OE1 GLU C  12     -12.816 -17.106 -16.012  1.00 51.57           O  
ATOM   3967  OE2 GLU C  12     -14.162 -18.276 -14.760  1.00 47.71           O  
ATOM   3968  N   LEU C  13      -7.838 -16.234 -13.404  1.00 46.37           N  
ATOM   3969  CA  LEU C  13      -6.437 -16.696 -13.420  1.00 47.81           C  
ATOM   3970  C   LEU C  13      -5.794 -16.600 -12.017  1.00 50.57           C  
ATOM   3971  O   LEU C  13      -4.853 -17.360 -11.673  1.00 50.22           O  
ATOM   3972  CB  LEU C  13      -5.614 -15.882 -14.437  1.00 45.84           C  
ATOM   3973  CG  LEU C  13      -4.091 -16.161 -14.560  1.00 48.39           C  
ATOM   3974  CD1 LEU C  13      -3.487 -15.698 -15.889  1.00 46.41           C  
ATOM   3975  CD2 LEU C  13      -3.283 -15.549 -13.410  1.00 41.35           C  
HETATM 3976  N   MSE C  14      -6.341 -15.681 -11.215  1.00 51.48           N  
HETATM 3977  CA  MSE C  14      -5.793 -15.445  -9.875  0.50 49.89           C  
HETATM 3979  C   MSE C  14      -6.683 -16.013  -8.770  1.00 50.30           C  
HETATM 3980  O   MSE C  14      -6.356 -15.887  -7.594  1.00 48.16           O  
HETATM 3981  CB  MSE C  14      -5.525 -13.948  -9.656  0.50 49.91           C  
HETATM 3983  CG  MSE C  14      -4.449 -13.359 -10.570  0.50 42.29           C  
HETATM 3985 SE   MSE C  14      -2.580 -13.812 -10.102  0.38 40.02          SE  
HETATM 3987  CE  MSE C  14      -2.371 -12.708  -8.419  0.50 35.62           C  
ATOM   3989  N   GLN C  15      -7.763 -16.690  -9.152  1.00 50.32           N  
ATOM   3990  CA  GLN C  15      -8.716 -17.273  -8.181  1.00 51.24           C  
ATOM   3991  C   GLN C  15      -8.130 -18.032  -6.983  1.00 50.62           C  
ATOM   3992  O   GLN C  15      -8.697 -17.979  -5.886  1.00 49.70           O  
ATOM   3993  CB  GLN C  15      -9.793 -18.106  -8.890  1.00 51.99           C  
ATOM   3994  CG  GLN C  15      -9.389 -19.487  -9.375  1.00 54.69           C  
ATOM   3995  CD  GLN C  15     -10.539 -20.154 -10.108  1.00 53.52           C  
ATOM   3996  OE1 GLN C  15     -11.146 -19.563 -11.007  1.00 60.10           O  
ATOM   3997  NE2 GLN C  15     -10.848 -21.390  -9.728  1.00 62.81           N  
ATOM   3998  N   ASP C  16      -7.001 -18.704  -7.170  1.00 49.46           N  
ATOM   3999  CA  ASP C  16      -6.384 -19.444  -6.057  1.00 50.36           C  
ATOM   4000  C   ASP C  16      -5.290 -18.685  -5.314  1.00 47.26           C  
ATOM   4001  O   ASP C  16      -4.617 -19.272  -4.456  1.00 48.33           O  
ATOM   4002  CB  ASP C  16      -5.849 -20.803  -6.539  1.00 52.45           C  
ATOM   4003  CG  ASP C  16      -6.924 -21.647  -7.202  1.00 57.11           C  
ATOM   4004  OD1 ASP C  16      -8.097 -21.585  -6.764  1.00 65.56           O  
ATOM   4005  OD2 ASP C  16      -6.594 -22.356  -8.173  1.00 64.94           O  
ATOM   4006  N   VAL C  17      -5.133 -17.388  -5.598  1.00 43.80           N  
ATOM   4007  CA  VAL C  17      -4.115 -16.573  -4.912  1.00 42.45           C  
ATOM   4008  C   VAL C  17      -4.565 -16.260  -3.468  1.00 41.08           C  
ATOM   4009  O   VAL C  17      -5.664 -15.738  -3.270  1.00 39.87           O  
ATOM   4010  CB  VAL C  17      -3.791 -15.279  -5.701  1.00 42.15           C  
ATOM   4011  CG1 VAL C  17      -2.694 -14.487  -5.020  1.00 38.13           C  
ATOM   4012  CG2 VAL C  17      -3.353 -15.637  -7.111  1.00 45.14           C  
ATOM   4013  N   PRO C  18      -3.729 -16.614  -2.463  1.00 40.45           N  
ATOM   4014  CA  PRO C  18      -4.053 -16.427  -1.048  1.00 38.62           C  
ATOM   4015  C   PRO C  18      -3.802 -15.007  -0.527  1.00 35.46           C  
ATOM   4016  O   PRO C  18      -2.896 -14.759   0.279  1.00 34.30           O  
ATOM   4017  CB  PRO C  18      -3.140 -17.432  -0.369  1.00 38.22           C  
ATOM   4018  CG  PRO C  18      -1.935 -17.443  -1.209  1.00 37.29           C  
ATOM   4019  CD  PRO C  18      -2.409 -17.260  -2.616  1.00 39.89           C  
ATOM   4020  N   TYR C  19      -4.645 -14.094  -0.980  1.00 32.93           N  
ATOM   4021  CA  TYR C  19      -4.580 -12.697  -0.577  1.00 33.25           C  
ATOM   4022  C   TYR C  19      -4.573 -12.453   0.942  1.00 32.75           C  
ATOM   4023  O   TYR C  19      -3.931 -11.508   1.395  1.00 33.64           O  
ATOM   4024  CB  TYR C  19      -5.702 -11.921  -1.236  1.00 32.81           C  
ATOM   4025  CG  TYR C  19      -5.550 -11.845  -2.742  1.00 34.64           C  
ATOM   4026  CD1 TYR C  19      -4.580 -11.032  -3.320  1.00 36.28           C  
ATOM   4027  CD2 TYR C  19      -6.376 -12.573  -3.586  1.00 33.85           C  
ATOM   4028  CE1 TYR C  19      -4.446 -10.947  -4.712  1.00 38.79           C  
ATOM   4029  CE2 TYR C  19      -6.250 -12.488  -4.963  1.00 40.63           C  
ATOM   4030  CZ  TYR C  19      -5.282 -11.679  -5.517  1.00 34.71           C  
ATOM   4031  OH  TYR C  19      -5.162 -11.599  -6.869  1.00 37.87           O  
ATOM   4032  N   PRO C  20      -5.311 -13.269   1.728  1.00 30.58           N  
ATOM   4033  CA  PRO C  20      -5.245 -13.104   3.163  1.00 31.59           C  
ATOM   4034  C   PRO C  20      -3.834 -13.114   3.720  1.00 30.63           C  
ATOM   4035  O   PRO C  20      -3.560 -12.434   4.705  1.00 31.92           O  
ATOM   4036  CB  PRO C  20      -6.063 -14.308   3.681  1.00 31.34           C  
ATOM   4037  CG  PRO C  20      -7.105 -14.487   2.634  1.00 31.67           C  
ATOM   4038  CD  PRO C  20      -6.293 -14.311   1.361  1.00 32.24           C  
ATOM   4039  N   GLU C  21      -2.935 -13.879   3.112  1.00 33.90           N  
ATOM   4040  CA  GLU C  21      -1.543 -13.924   3.577  1.00 33.90           C  
ATOM   4041  C   GLU C  21      -0.883 -12.547   3.449  1.00 31.91           C  
ATOM   4042  O   GLU C  21      -0.059 -12.156   4.274  1.00 28.21           O  
ATOM   4043  CB  GLU C  21      -0.747 -15.006   2.821  1.00 36.28           C  
ATOM   4044  CG  GLU C  21      -1.295 -16.407   3.068  1.00 38.49           C  
ATOM   4045  CD  GLU C  21      -0.611 -17.533   2.260  1.00 43.02           C  
ATOM   4046  OE1 GLU C  21       0.476 -17.327   1.671  1.00 54.27           O  
ATOM   4047  OE2 GLU C  21      -1.185 -18.653   2.230  1.00 55.45           O  
ATOM   4048  N   TRP C  22      -1.231 -11.798   2.407  1.00 30.77           N  
ATOM   4049  CA  TRP C  22      -0.692 -10.450   2.275  1.00 31.41           C  
ATOM   4050  C   TRP C  22      -1.331  -9.519   3.282  1.00 31.70           C  
ATOM   4051  O   TRP C  22      -0.677  -8.622   3.811  1.00 31.85           O  
ATOM   4052  CB  TRP C  22      -0.973  -9.881   0.903  1.00 31.56           C  
ATOM   4053  CG  TRP C  22      -0.035 -10.279  -0.148  1.00 33.81           C  
ATOM   4054  CD1 TRP C  22       1.007  -9.554  -0.607  1.00 35.12           C  
ATOM   4055  CD2 TRP C  22      -0.091 -11.465  -0.951  1.00 34.21           C  
ATOM   4056  NE1 TRP C  22       1.625 -10.217  -1.623  1.00 28.08           N  
ATOM   4057  CE2 TRP C  22       0.966 -11.392  -1.862  1.00 28.13           C  
ATOM   4058  CE3 TRP C  22      -0.936 -12.574  -0.987  1.00 34.28           C  
ATOM   4059  CZ2 TRP C  22       1.226 -12.398  -2.793  1.00 34.00           C  
ATOM   4060  CZ3 TRP C  22      -0.692 -13.565  -1.925  1.00 36.34           C  
ATOM   4061  CH2 TRP C  22       0.379 -13.474  -2.809  1.00 34.92           C  
ATOM   4062  N   VAL C  23      -2.621  -9.725   3.524  1.00 31.73           N  
ATOM   4063  CA  VAL C  23      -3.354  -8.903   4.463  1.00 30.11           C  
ATOM   4064  C   VAL C  23      -2.850  -9.153   5.879  1.00 30.01           C  
ATOM   4065  O   VAL C  23      -2.799  -8.210   6.680  1.00 29.52           O  
ATOM   4066  CB  VAL C  23      -4.883  -9.120   4.332  1.00 30.27           C  
ATOM   4067  CG1 VAL C  23      -5.634  -8.328   5.392  1.00 26.34           C  
ATOM   4068  CG2 VAL C  23      -5.337  -8.686   2.908  1.00 25.04           C  
ATOM   4069  N   ALA C  24      -2.467 -10.393   6.196  1.00 31.47           N  
ATOM   4070  CA  ALA C  24      -1.946 -10.709   7.536  1.00 30.82           C  
ATOM   4071  C   ALA C  24      -0.631  -9.982   7.771  1.00 31.68           C  
ATOM   4072  O   ALA C  24      -0.392  -9.481   8.858  1.00 33.19           O  
ATOM   4073  CB  ALA C  24      -1.804 -12.229   7.775  1.00 29.44           C  
ATOM   4074  N   TRP C  25       0.213  -9.913   6.754  1.00 32.43           N  
ATOM   4075  CA  TRP C  25       1.483  -9.174   6.838  1.00 31.21           C  
ATOM   4076  C   TRP C  25       1.255  -7.672   7.088  1.00 31.48           C  
ATOM   4077  O   TRP C  25       1.914  -7.078   7.939  1.00 28.41           O  
ATOM   4078  CB  TRP C  25       2.276  -9.393   5.546  1.00 33.12           C  
ATOM   4079  CG  TRP C  25       3.503  -8.542   5.382  1.00 32.66           C  
ATOM   4080  CD1 TRP C  25       4.582  -8.474   6.206  1.00 33.59           C  
ATOM   4081  CD2 TRP C  25       3.789  -7.687   4.277  1.00 27.38           C  
ATOM   4082  NE1 TRP C  25       5.512  -7.603   5.694  1.00 30.93           N  
ATOM   4083  CE2 TRP C  25       5.053  -7.112   4.508  1.00 27.27           C  
ATOM   4084  CE3 TRP C  25       3.079  -7.331   3.120  1.00 31.99           C  
ATOM   4085  CZ2 TRP C  25       5.640  -6.206   3.625  1.00 28.93           C  
ATOM   4086  CZ3 TRP C  25       3.671  -6.437   2.237  1.00 32.77           C  
ATOM   4087  CH2 TRP C  25       4.944  -5.888   2.505  1.00 29.37           C  
ATOM   4088  N   VAL C  26       0.317  -7.049   6.361  1.00 30.58           N  
ATOM   4089  CA  VAL C  26       0.029  -5.627   6.604  1.00 29.95           C  
ATOM   4090  C   VAL C  26      -0.421  -5.439   8.059  1.00 31.14           C  
ATOM   4091  O   VAL C  26       0.043  -4.518   8.752  1.00 31.95           O  
ATOM   4092  CB  VAL C  26      -1.016  -5.053   5.640  1.00 30.89           C  
ATOM   4093  CG1 VAL C  26      -1.323  -3.615   6.012  1.00 27.25           C  
ATOM   4094  CG2 VAL C  26      -0.494  -5.123   4.216  1.00 28.58           C  
ATOM   4095  N   LEU C  27      -1.278  -6.352   8.520  1.00 30.70           N  
ATOM   4096  CA  LEU C  27      -1.813  -6.337   9.895  1.00 30.51           C  
ATOM   4097  C   LEU C  27      -0.725  -6.381  10.991  1.00 32.93           C  
ATOM   4098  O   LEU C  27      -0.946  -5.921  12.132  1.00 31.08           O  
ATOM   4099  CB  LEU C  27      -2.829  -7.473  10.071  1.00 30.75           C  
ATOM   4100  CG  LEU C  27      -4.227  -7.252   9.471  1.00 30.70           C  
ATOM   4101  CD1 LEU C  27      -5.034  -8.543   9.461  1.00 35.87           C  
ATOM   4102  CD2 LEU C  27      -4.973  -6.170  10.245  1.00 30.41           C  
ATOM   4103  N   GLU C  28       0.443  -6.911  10.645  1.00 34.08           N  
ATOM   4104  CA  GLU C  28       1.559  -6.994  11.583  1.00 37.04           C  
ATOM   4105  C   GLU C  28       2.358  -5.707  11.605  1.00 35.46           C  
ATOM   4106  O   GLU C  28       3.078  -5.464  12.552  1.00 35.44           O  
ATOM   4107  CB  GLU C  28       2.502  -8.122  11.187  1.00 36.75           C  
ATOM   4108  CG  GLU C  28       1.853  -9.491  11.095  1.00 43.96           C  
ATOM   4109  CD  GLU C  28       2.808 -10.597  10.605  1.00 46.39           C  
ATOM   4110  OE1 GLU C  28       3.850 -10.290   9.955  1.00 58.44           O  
ATOM   4111  OE2 GLU C  28       2.489 -11.784  10.852  1.00 58.39           O  
ATOM   4112  N   GLN C  29       2.247  -4.901  10.548  1.00 34.69           N  
ATOM   4113  CA  GLN C  29       3.004  -3.658  10.399  1.00 34.24           C  
ATOM   4114  C   GLN C  29       2.189  -2.386  10.563  1.00 35.08           C  
ATOM   4115  O   GLN C  29       2.755  -1.347  10.891  1.00 36.26           O  
ATOM   4116  CB  GLN C  29       3.629  -3.596   8.994  1.00 35.17           C  
ATOM   4117  CG  GLN C  29       4.396  -4.852   8.557  1.00 38.51           C  
ATOM   4118  CD  GLN C  29       5.519  -5.248   9.500  1.00 41.88           C  
ATOM   4119  OE1 GLN C  29       6.186  -4.394  10.094  1.00 34.57           O  
ATOM   4120  NE2 GLN C  29       5.737  -6.561   9.640  1.00 43.76           N  
ATOM   4121  N   VAL C  30       0.882  -2.439  10.307  1.00 34.73           N  
ATOM   4122  CA  VAL C  30       0.043  -1.240  10.395  1.00 35.34           C  
ATOM   4123  C   VAL C  30      -1.158  -1.479  11.305  1.00 35.17           C  
ATOM   4124  O   VAL C  30      -1.938  -2.393  11.078  1.00 35.00           O  
ATOM   4125  CB  VAL C  30      -0.418  -0.769   8.986  1.00 36.07           C  
ATOM   4126  CG1 VAL C  30      -1.198   0.555   9.069  1.00 36.44           C  
ATOM   4127  CG2 VAL C  30       0.765  -0.596   8.072  1.00 32.75           C  
ATOM   4128  N   GLU C  31      -1.291  -0.634  12.331  1.00 34.77           N  
ATOM   4129  CA  GLU C  31      -2.353  -0.747  13.318  1.00 36.59           C  
ATOM   4130  C   GLU C  31      -3.701  -0.726  12.645  1.00 35.04           C  
ATOM   4131  O   GLU C  31      -3.956   0.177  11.868  1.00 34.49           O  
ATOM   4132  CB  GLU C  31      -2.320   0.432  14.300  1.00 37.50           C  
ATOM   4133  CG  GLU C  31      -1.092   0.521  15.214  1.00 44.52           C  
ATOM   4134  CD  GLU C  31       0.178   1.094  14.562  1.00 53.14           C  
ATOM   4135  OE1 GLU C  31       0.225   1.285  13.315  1.00 52.58           O  
ATOM   4136  OE2 GLU C  31       1.145   1.345  15.328  1.00 58.59           O  
ATOM   4137  N   PRO C  32      -4.570  -1.719  12.928  1.00 34.53           N  
ATOM   4138  CA  PRO C  32      -5.932  -1.706  12.372  1.00 33.99           C  
ATOM   4139  C   PRO C  32      -6.667  -0.384  12.623  1.00 34.00           C  
ATOM   4140  O   PRO C  32      -6.469   0.249  13.657  1.00 35.61           O  
ATOM   4141  CB  PRO C  32      -6.612  -2.875  13.091  1.00 34.21           C  
ATOM   4142  CG  PRO C  32      -5.486  -3.830  13.342  1.00 33.22           C  
ATOM   4143  CD  PRO C  32      -4.317  -2.945  13.705  1.00 34.52           C  
ATOM   4144  N   GLY C  33      -7.476   0.047  11.665  1.00 33.40           N  
ATOM   4145  CA  GLY C  33      -8.198   1.312  11.783  1.00 34.19           C  
ATOM   4146  C   GLY C  33      -7.506   2.484  11.103  1.00 34.11           C  
ATOM   4147  O   GLY C  33      -8.155   3.470  10.767  1.00 36.72           O  
ATOM   4148  N   LYS C  34      -6.202   2.396  10.887  1.00 32.84           N  
ATOM   4149  CA  LYS C  34      -5.481   3.484  10.247  1.00 33.70           C  
ATOM   4150  C   LYS C  34      -5.888   3.585   8.773  1.00 34.82           C  
ATOM   4151  O   LYS C  34      -6.622   2.725   8.252  1.00 33.27           O  
ATOM   4152  CB  LYS C  34      -3.961   3.331  10.429  1.00 35.50           C  
ATOM   4153  CG  LYS C  34      -3.515   3.454  11.890  1.00 32.61           C  
ATOM   4154  CD  LYS C  34      -2.005   3.453  12.026  1.00 36.38           C  
ATOM   4155  N   ARG C  35      -5.442   4.662   8.130  1.00 35.34           N  
ATOM   4156  CA  ARG C  35      -5.755   4.949   6.726  1.00 36.20           C  
ATOM   4157  C   ARG C  35      -4.638   4.429   5.844  1.00 33.79           C  
ATOM   4158  O   ARG C  35      -3.465   4.667   6.124  1.00 33.24           O  
ATOM   4159  CB  ARG C  35      -5.873   6.453   6.514  1.00 36.35           C  
ATOM   4160  CG  ARG C  35      -6.883   7.150   7.412  1.00 39.58           C  
ATOM   4161  CD  ARG C  35      -6.703   8.653   7.294  1.00 42.23           C  
ATOM   4162  NE  ARG C  35      -5.373   9.071   7.759  1.00 46.73           N  
ATOM   4163  CZ  ARG C  35      -5.108   9.715   8.896  1.00 49.49           C  
ATOM   4164  NH1 ARG C  35      -6.081  10.083   9.724  1.00 52.36           N  
ATOM   4165  NH2 ARG C  35      -3.846  10.019   9.198  1.00 43.38           N  
ATOM   4166  N   ILE C  36      -5.015   3.736   4.776  1.00 33.22           N  
ATOM   4167  CA  ILE C  36      -4.077   3.124   3.850  1.00 32.33           C  
ATOM   4168  C   ILE C  36      -4.480   3.395   2.412  1.00 32.35           C  
ATOM   4169  O   ILE C  36      -5.679   3.294   2.076  1.00 33.21           O  
ATOM   4170  CB  ILE C  36      -4.062   1.584   4.037  1.00 32.62           C  
ATOM   4171  CG1 ILE C  36      -3.467   1.193   5.398  1.00 34.34           C  
ATOM   4172  CG2 ILE C  36      -3.297   0.907   2.923  1.00 34.80           C  
ATOM   4173  CD1 ILE C  36      -3.386  -0.313   5.626  1.00 31.99           C  
ATOM   4174  N   ALA C  37      -3.502   3.773   1.580  1.00 29.68           N  
ATOM   4175  CA  ALA C  37      -3.701   3.901   0.139  1.00 29.33           C  
ATOM   4176  C   ALA C  37      -3.071   2.638  -0.487  1.00 31.60           C  
ATOM   4177  O   ALA C  37      -1.859   2.407  -0.370  1.00 30.95           O  
ATOM   4178  CB  ALA C  37      -3.068   5.191  -0.432  1.00 27.77           C  
ATOM   4179  N   ASP C  38      -3.908   1.797  -1.088  1.00 29.94           N  
ATOM   4180  CA  ASP C  38      -3.445   0.568  -1.740  1.00 31.48           C  
ATOM   4181  C   ASP C  38      -3.358   0.942  -3.198  1.00 30.39           C  
ATOM   4182  O   ASP C  38      -4.385   1.157  -3.869  1.00 31.00           O  
ATOM   4183  CB  ASP C  38      -4.411  -0.579  -1.511  1.00 32.95           C  
ATOM   4184  CG  ASP C  38      -3.930  -1.885  -2.118  1.00 37.30           C  
ATOM   4185  OD1 ASP C  38      -2.694  -2.164  -2.185  1.00 32.76           O  
ATOM   4186  OD2 ASP C  38      -4.822  -2.654  -2.512  1.00 34.07           O  
ATOM   4187  N   ILE C  39      -2.128   1.063  -3.669  1.00 31.21           N  
ATOM   4188  CA  ILE C  39      -1.872   1.561  -4.990  1.00 33.19           C  
ATOM   4189  C   ILE C  39      -1.416   0.428  -5.900  1.00 33.79           C  
ATOM   4190  O   ILE C  39      -0.784  -0.519  -5.470  1.00 34.89           O  
ATOM   4191  CB  ILE C  39      -0.985   2.850  -4.957  1.00 34.11           C  
ATOM   4192  CG1 ILE C  39       0.437   2.575  -4.580  1.00 38.96           C  
ATOM   4193  CG2 ILE C  39      -1.563   3.941  -3.968  1.00 31.75           C  
ATOM   4194  CD1 ILE C  39       1.227   3.844  -4.444  1.00 38.06           C  
ATOM   4195  N   GLY C  40      -1.775   0.532  -7.176  1.00 35.46           N  
ATOM   4196  CA  GLY C  40      -1.606  -0.580  -8.117  1.00 36.61           C  
ATOM   4197  C   GLY C  40      -2.540  -1.714  -7.666  1.00 35.89           C  
ATOM   4198  O   GLY C  40      -2.179  -2.880  -7.726  1.00 35.54           O  
ATOM   4199  N   CYS C  41      -3.746  -1.359  -7.216  1.00 32.99           N  
ATOM   4200  CA  CYS C  41      -4.677  -2.333  -6.647  1.00 33.93           C  
ATOM   4201  C   CYS C  41      -5.366  -3.256  -7.643  1.00 32.14           C  
ATOM   4202  O   CYS C  41      -5.978  -4.236  -7.242  1.00 31.27           O  
ATOM   4203  CB  CYS C  41      -5.745  -1.625  -5.812  1.00 33.65           C  
ATOM   4204  SG  CYS C  41      -6.837  -0.565  -6.714  1.00 32.20           S  
ATOM   4205  N   GLY C  42      -5.280  -2.945  -8.932  1.00 34.60           N  
ATOM   4206  CA  GLY C  42      -5.887  -3.782  -9.951  1.00 34.19           C  
ATOM   4207  C   GLY C  42      -7.371  -3.883  -9.697  1.00 33.02           C  
ATOM   4208  O   GLY C  42      -8.031  -2.856  -9.533  1.00 32.06           O  
ATOM   4209  N   THR C  43      -7.876  -5.120  -9.631  1.00 33.09           N  
ATOM   4210  CA  THR C  43      -9.316  -5.398  -9.406  1.00 34.13           C  
ATOM   4211  C   THR C  43      -9.690  -5.419  -7.927  1.00 34.17           C  
ATOM   4212  O   THR C  43     -10.792  -5.842  -7.570  1.00 33.35           O  
ATOM   4213  CB  THR C  43      -9.785  -6.681 -10.111  1.00 33.55           C  
ATOM   4214  OG1 THR C  43      -9.000  -7.787  -9.676  1.00 30.53           O  
ATOM   4215  CG2 THR C  43      -9.650  -6.538 -11.631  1.00 33.10           C  
ATOM   4216  N   GLY C  44      -8.757  -4.972  -7.073  1.00 32.31           N  
ATOM   4217  CA  GLY C  44      -9.032  -4.762  -5.650  1.00 29.97           C  
ATOM   4218  C   GLY C  44      -9.315  -5.948  -4.746  1.00 31.25           C  
ATOM   4219  O   GLY C  44      -9.829  -5.759  -3.637  1.00 29.85           O  
ATOM   4220  N   THR C  45      -8.959  -7.165  -5.162  1.00 32.67           N  
ATOM   4221  CA  THR C  45      -9.217  -8.344  -4.298  1.00 32.42           C  
ATOM   4222  C   THR C  45      -8.602  -8.172  -2.894  1.00 31.87           C  
ATOM   4223  O   THR C  45      -9.289  -8.360  -1.885  1.00 32.32           O  
ATOM   4224  CB  THR C  45      -8.772  -9.677  -4.970  1.00 33.02           C  
ATOM   4225  OG1 THR C  45      -9.314  -9.754  -6.297  1.00 31.72           O  
ATOM   4226  CG2 THR C  45      -9.251 -10.874  -4.175  1.00 33.45           C  
ATOM   4227  N   ALA C  46      -7.309  -7.835  -2.820  1.00 31.07           N  
ATOM   4228  CA  ALA C  46      -6.653  -7.594  -1.543  1.00 29.61           C  
ATOM   4229  C   ALA C  46      -7.165  -6.309  -0.914  1.00 29.77           C  
ATOM   4230  O   ALA C  46      -7.313  -6.245   0.304  1.00 32.53           O  
ATOM   4231  CB  ALA C  46      -5.136  -7.506  -1.713  1.00 27.34           C  
ATOM   4232  N   THR C  47      -7.452  -5.300  -1.751  1.00 29.99           N  
ATOM   4233  CA  THR C  47      -7.923  -3.993  -1.285  1.00 29.38           C  
ATOM   4234  C   THR C  47      -9.189  -4.079  -0.438  1.00 29.30           C  
ATOM   4235  O   THR C  47      -9.333  -3.345   0.546  1.00 29.74           O  
ATOM   4236  CB  THR C  47      -8.209  -3.056  -2.480  1.00 29.58           C  
ATOM   4237  OG1 THR C  47      -7.127  -3.127  -3.414  1.00 32.91           O  
ATOM   4238  CG2 THR C  47      -8.426  -1.623  -2.013  1.00 27.18           C  
ATOM   4239  N   LEU C  48     -10.106  -4.954  -0.847  1.00 30.19           N  
ATOM   4240  CA  LEU C  48     -11.371  -5.135  -0.151  1.00 30.96           C  
ATOM   4241  C   LEU C  48     -11.166  -5.897   1.144  1.00 29.97           C  
ATOM   4242  O   LEU C  48     -11.866  -5.638   2.108  1.00 29.05           O  
ATOM   4243  CB  LEU C  48     -12.408  -5.842  -1.032  1.00 29.93           C  
ATOM   4244  CG  LEU C  48     -12.889  -5.091  -2.282  1.00 34.25           C  
ATOM   4245  CD1 LEU C  48     -13.897  -5.939  -3.038  1.00 37.83           C  
ATOM   4246  CD2 LEU C  48     -13.480  -3.744  -1.926  1.00 35.14           C  
ATOM   4247  N   LEU C  49     -10.195  -6.818   1.180  1.00 31.58           N  
ATOM   4248  CA  LEU C  49      -9.870  -7.532   2.433  1.00 29.88           C  
ATOM   4249  C   LEU C  49      -9.256  -6.541   3.429  1.00 30.53           C  
ATOM   4250  O   LEU C  49      -9.493  -6.631   4.627  1.00 32.08           O  
ATOM   4251  CB  LEU C  49      -8.919  -8.706   2.194  1.00 28.96           C  
ATOM   4252  CG  LEU C  49      -9.449  -9.875   1.374  1.00 28.70           C  
ATOM   4253  CD1 LEU C  49      -8.344 -10.888   1.103  1.00 26.93           C  
ATOM   4254  CD2 LEU C  49     -10.647 -10.530   2.077  1.00 26.17           C  
ATOM   4255  N   LEU C  50      -8.422  -5.629   2.935  1.00 31.60           N  
ATOM   4256  CA  LEU C  50      -7.854  -4.567   3.768  1.00 30.55           C  
ATOM   4257  C   LEU C  50      -8.953  -3.658   4.315  1.00 29.32           C  
ATOM   4258  O   LEU C  50      -8.863  -3.202   5.441  1.00 31.17           O  
ATOM   4259  CB  LEU C  50      -6.849  -3.723   2.974  1.00 31.15           C  
ATOM   4260  CG  LEU C  50      -5.501  -4.363   2.612  1.00 32.41           C  
ATOM   4261  CD1 LEU C  50      -4.726  -3.463   1.658  1.00 30.65           C  
ATOM   4262  CD2 LEU C  50      -4.688  -4.627   3.853  1.00 31.19           C  
ATOM   4263  N   ALA C  51      -9.977  -3.387   3.501  1.00 31.10           N  
ATOM   4264  CA  ALA C  51     -11.104  -2.529   3.896  1.00 30.56           C  
ATOM   4265  C   ALA C  51     -11.824  -3.032   5.159  1.00 31.91           C  
ATOM   4266  O   ALA C  51     -12.469  -2.241   5.859  1.00 30.82           O  
ATOM   4267  CB  ALA C  51     -12.076  -2.382   2.750  1.00 29.59           C  
ATOM   4268  N   ASP C  52     -11.697  -4.330   5.461  1.00 30.58           N  
ATOM   4269  CA  ASP C  52     -12.287  -4.903   6.692  1.00 31.62           C  
ATOM   4270  C   ASP C  52     -11.494  -4.556   7.967  1.00 30.81           C  
ATOM   4271  O   ASP C  52     -11.933  -4.887   9.054  1.00 30.03           O  
ATOM   4272  CB  ASP C  52     -12.412  -6.423   6.571  1.00 30.56           C  
ATOM   4273  CG  ASP C  52     -13.388  -6.838   5.484  1.00 35.88           C  
ATOM   4274  OD1 ASP C  52     -14.266  -6.023   5.131  1.00 36.90           O  
ATOM   4275  OD2 ASP C  52     -13.289  -7.979   4.983  1.00 33.66           O  
ATOM   4276  N   HIS C  53     -10.326  -3.916   7.820  1.00 30.41           N  
ATOM   4277  CA  HIS C  53      -9.485  -3.527   8.957  1.00 31.23           C  
ATOM   4278  C   HIS C  53      -9.027  -2.071   8.967  1.00 30.91           C  
ATOM   4279  O   HIS C  53      -8.655  -1.553  10.012  1.00 31.34           O  
ATOM   4280  CB  HIS C  53      -8.240  -4.392   8.964  1.00 33.45           C  
ATOM   4281  CG  HIS C  53      -8.526  -5.853   8.940  1.00 34.07           C  
ATOM   4282  ND1 HIS C  53      -8.820  -6.569  10.078  1.00 34.92           N  
ATOM   4283  CD2 HIS C  53      -8.551  -6.736   7.915  1.00 34.57           C  
ATOM   4284  CE1 HIS C  53      -9.013  -7.834   9.754  1.00 38.64           C  
ATOM   4285  NE2 HIS C  53      -8.855  -7.963   8.449  1.00 31.65           N  
ATOM   4286  N   TYR C  54      -9.043  -1.421   7.810  1.00 31.57           N  
ATOM   4287  CA  TYR C  54      -8.537  -0.064   7.683  1.00 31.72           C  
ATOM   4288  C   TYR C  54      -9.462   0.816   6.854  1.00 31.74           C  
ATOM   4289  O   TYR C  54     -10.380   0.323   6.216  1.00 31.82           O  
ATOM   4290  CB  TYR C  54      -7.207  -0.105   6.943  1.00 31.60           C  
ATOM   4291  CG  TYR C  54      -6.137  -1.002   7.533  1.00 33.20           C  
ATOM   4292  CD1 TYR C  54      -5.305  -0.549   8.542  1.00 30.13           C  
ATOM   4293  CD2 TYR C  54      -5.921  -2.291   7.036  1.00 35.30           C  
ATOM   4294  CE1 TYR C  54      -4.310  -1.367   9.067  1.00 37.45           C  
ATOM   4295  CE2 TYR C  54      -4.919  -3.120   7.565  1.00 30.74           C  
ATOM   4296  CZ  TYR C  54      -4.121  -2.651   8.576  1.00 34.29           C  
ATOM   4297  OH  TYR C  54      -3.095  -3.427   9.095  1.00 28.22           O  
ATOM   4298  N   GLU C  55      -9.191   2.118   6.871  1.00 32.82           N  
ATOM   4299  CA  GLU C  55      -9.877   3.070   6.017  1.00 34.25           C  
ATOM   4300  C   GLU C  55      -9.005   3.021   4.770  1.00 33.55           C  
ATOM   4301  O   GLU C  55      -7.894   3.512   4.787  1.00 35.10           O  
ATOM   4302  CB  GLU C  55      -9.908   4.482   6.625  1.00 34.64           C  
ATOM   4303  CG  GLU C  55     -10.415   4.594   8.057  1.00 40.11           C  
ATOM   4304  CD  GLU C  55     -11.888   4.245   8.198  1.00 51.49           C  
ATOM   4305  OE1 GLU C  55     -12.443   3.583   7.298  1.00 56.68           O  
ATOM   4306  OE2 GLU C  55     -12.500   4.632   9.218  1.00 59.88           O  
ATOM   4307  N   VAL C  56      -9.507   2.420   3.696  1.00 33.53           N  
ATOM   4308  CA  VAL C  56      -8.722   2.188   2.493  1.00 31.74           C  
ATOM   4309  C   VAL C  56      -9.144   2.981   1.258  1.00 31.78           C  
ATOM   4310  O   VAL C  56     -10.333   3.172   0.989  1.00 32.15           O  
ATOM   4311  CB  VAL C  56      -8.776   0.687   2.121  1.00 33.15           C  
ATOM   4312  CG1 VAL C  56      -8.060   0.410   0.796  1.00 35.80           C  
ATOM   4313  CG2 VAL C  56      -8.202  -0.135   3.218  1.00 29.58           C  
ATOM   4314  N   THR C  57      -8.133   3.436   0.526  1.00 31.30           N  
ATOM   4315  CA  THR C  57      -8.264   4.096  -0.767  1.00 31.58           C  
ATOM   4316  C   THR C  57      -7.501   3.232  -1.786  1.00 32.64           C  
ATOM   4317  O   THR C  57      -6.311   2.927  -1.583  1.00 33.50           O  
ATOM   4318  CB  THR C  57      -7.640   5.481  -0.740  1.00 31.31           C  
ATOM   4319  OG1 THR C  57      -8.343   6.284   0.207  1.00 32.97           O  
ATOM   4320  CG2 THR C  57      -7.694   6.148  -2.120  1.00 34.67           C  
ATOM   4321  N   GLY C  58      -8.193   2.799  -2.842  1.00 30.97           N  
ATOM   4322  CA  GLY C  58      -7.598   2.003  -3.907  1.00 29.57           C  
ATOM   4323  C   GLY C  58      -7.261   2.926  -5.067  1.00 31.41           C  
ATOM   4324  O   GLY C  58      -8.093   3.731  -5.484  1.00 30.79           O  
ATOM   4325  N   VAL C  59      -6.052   2.789  -5.594  1.00 29.85           N  
ATOM   4326  CA  VAL C  59      -5.563   3.592  -6.690  1.00 31.10           C  
ATOM   4327  C   VAL C  59      -4.970   2.667  -7.754  1.00 32.44           C  
ATOM   4328  O   VAL C  59      -4.107   1.808  -7.460  1.00 31.17           O  
ATOM   4329  CB  VAL C  59      -4.475   4.598  -6.225  1.00 32.76           C  
ATOM   4330  CG1 VAL C  59      -3.876   5.333  -7.430  1.00 31.92           C  
ATOM   4331  CG2 VAL C  59      -5.042   5.612  -5.215  1.00 33.50           C  
ATOM   4332  N   ASP C  60      -5.478   2.789  -8.976  1.00 31.72           N  
ATOM   4333  CA  ASP C  60      -4.923   2.065 -10.102  1.00 33.60           C  
ATOM   4334  C   ASP C  60      -5.074   2.929 -11.349  1.00 33.01           C  
ATOM   4335  O   ASP C  60      -5.968   3.766 -11.419  1.00 33.72           O  
ATOM   4336  CB  ASP C  60      -5.595   0.709 -10.284  1.00 33.31           C  
ATOM   4337  CG  ASP C  60      -4.782  -0.227 -11.153  1.00 34.41           C  
ATOM   4338  OD1 ASP C  60      -3.826  -0.836 -10.635  1.00 37.21           O  
ATOM   4339  OD2 ASP C  60      -5.105  -0.378 -12.347  1.00 37.51           O  
ATOM   4340  N   LEU C  61      -4.210   2.723 -12.335  1.00 34.54           N  
ATOM   4341  CA  LEU C  61      -4.286   3.480 -13.571  1.00 35.49           C  
ATOM   4342  C   LEU C  61      -5.410   2.897 -14.470  1.00 36.49           C  
ATOM   4343  O   LEU C  61      -5.947   3.593 -15.328  1.00 36.11           O  
ATOM   4344  CB  LEU C  61      -2.928   3.460 -14.295  1.00 36.84           C  
ATOM   4345  CG  LEU C  61      -2.484   4.727 -15.025  1.00 39.32           C  
ATOM   4346  CD1 LEU C  61      -1.314   4.421 -15.944  1.00 41.49           C  
ATOM   4347  CD2 LEU C  61      -3.596   5.345 -15.814  1.00 41.94           C  
ATOM   4348  N   SER C  62      -5.800   1.645 -14.241  1.00 36.00           N  
ATOM   4349  CA  SER C  62      -6.825   0.989 -15.039  1.00 35.91           C  
ATOM   4350  C   SER C  62      -8.249   1.296 -14.545  1.00 35.45           C  
ATOM   4351  O   SER C  62      -8.661   0.869 -13.463  1.00 34.51           O  
ATOM   4352  CB  SER C  62      -6.600  -0.524 -15.048  1.00 37.75           C  
ATOM   4353  OG  SER C  62      -7.506  -1.168 -15.926  1.00 39.74           O  
ATOM   4354  N   GLU C  63      -9.006   2.012 -15.369  1.00 35.79           N  
ATOM   4355  CA  GLU C  63     -10.384   2.374 -15.051  1.00 36.26           C  
ATOM   4356  C   GLU C  63     -11.244   1.126 -14.996  1.00 35.50           C  
ATOM   4357  O   GLU C  63     -12.088   0.986 -14.096  1.00 35.52           O  
ATOM   4358  CB  GLU C  63     -10.956   3.347 -16.081  1.00 34.78           C  
ATOM   4359  CG  GLU C  63     -10.078   4.567 -16.264  1.00 40.19           C  
ATOM   4360  CD  GLU C  63     -10.805   5.759 -16.821  1.00 37.68           C  
ATOM   4361  OE1 GLU C  63     -11.906   5.588 -17.384  1.00 41.51           O  
ATOM   4362  OE2 GLU C  63     -10.262   6.881 -16.702  1.00 50.20           O  
ATOM   4363  N   GLU C  64     -11.017   0.212 -15.936  1.00 35.12           N  
ATOM   4364  CA  GLU C  64     -11.760  -1.030 -15.967  1.00 36.02           C  
ATOM   4365  C   GLU C  64     -11.581  -1.885 -14.747  1.00 36.80           C  
ATOM   4366  O   GLU C  64     -12.569  -2.357 -14.180  1.00 36.33           O  
ATOM   4367  CB  GLU C  64     -11.384  -1.877 -17.175  1.00 38.97           C  
ATOM   4368  CG  GLU C  64     -12.352  -3.063 -17.388  1.00 44.51           C  
ATOM   4369  CD  GLU C  64     -13.842  -2.642 -17.446  1.00 49.88           C  
ATOM   4370  OE1 GLU C  64     -14.156  -1.480 -17.825  1.00 44.59           O  
ATOM   4371  OE2 GLU C  64     -14.710  -3.489 -17.121  1.00 51.10           O  
HETATM 4372  N   MSE C  65     -10.322  -2.130 -14.354  1.00 35.82           N  
HETATM 4373  CA  MSE C  65     -10.059  -2.954 -13.201  1.00 36.34           C  
HETATM 4374  C   MSE C  65     -10.695  -2.317 -11.987  1.00 32.75           C  
HETATM 4375  O   MSE C  65     -11.302  -3.012 -11.188  1.00 33.13           O  
HETATM 4376  CB  MSE C  65      -8.556  -3.173 -13.014  1.00 32.97           C  
HETATM 4377  CG  MSE C  65      -7.942  -4.073 -14.083  1.00 40.22           C  
HETATM 4378 SE   MSE C  65      -6.101  -4.699 -13.657  0.75 50.96          SE  
HETATM 4379  CE  MSE C  65      -5.096  -2.980 -13.525  1.00 57.19           C  
ATOM   4380  N   LEU C  66     -10.575  -0.991 -11.856  1.00 33.46           N  
ATOM   4381  CA  LEU C  66     -11.212  -0.274 -10.748  1.00 31.71           C  
ATOM   4382  C   LEU C  66     -12.746  -0.342 -10.799  1.00 31.67           C  
ATOM   4383  O   LEU C  66     -13.395  -0.253  -9.760  1.00 31.65           O  
ATOM   4384  CB  LEU C  66     -10.816   1.187 -10.731  1.00 32.25           C  
ATOM   4385  CG  LEU C  66      -9.400   1.536 -10.292  1.00 30.11           C  
ATOM   4386  CD1 LEU C  66      -9.326   3.061 -10.315  1.00 26.59           C  
ATOM   4387  CD2 LEU C  66      -9.105   0.940  -8.921  1.00 26.46           C  
ATOM   4388  N   GLU C  67     -13.302  -0.437 -12.006  1.00 33.14           N  
ATOM   4389  CA  GLU C  67     -14.749  -0.603 -12.201  1.00 33.79           C  
ATOM   4390  C   GLU C  67     -15.162  -1.935 -11.570  1.00 33.09           C  
ATOM   4391  O   GLU C  67     -16.150  -2.002 -10.831  1.00 31.93           O  
ATOM   4392  CB  GLU C  67     -15.083  -0.519 -13.700  1.00 35.94           C  
ATOM   4393  CG  GLU C  67     -16.538  -0.731 -14.113  1.00 35.00           C  
ATOM   4394  CD  GLU C  67     -16.781  -0.388 -15.600  1.00 39.95           C  
ATOM   4395  OE1 GLU C  67     -16.266   0.651 -16.077  1.00 50.60           O  
ATOM   4396  OE2 GLU C  67     -17.511  -1.143 -16.292  1.00 53.58           O  
ATOM   4397  N   ILE C  68     -14.361  -2.976 -11.817  1.00 33.19           N  
ATOM   4398  CA  ILE C  68     -14.587  -4.296 -11.223  1.00 31.32           C  
ATOM   4399  C   ILE C  68     -14.389  -4.241  -9.715  1.00 29.28           C  
ATOM   4400  O   ILE C  68     -15.179  -4.798  -8.979  1.00 29.03           O  
ATOM   4401  CB  ILE C  68     -13.658  -5.359 -11.825  1.00 31.09           C  
ATOM   4402  CG1 ILE C  68     -14.023  -5.622 -13.260  1.00 31.17           C  
ATOM   4403  CG2 ILE C  68     -13.700  -6.662 -11.020  1.00 30.80           C  
ATOM   4404  CD1 ILE C  68     -13.080  -6.548 -13.915  1.00 41.69           C  
ATOM   4405  N   ALA C  69     -13.301  -3.611  -9.263  1.00 30.23           N  
ATOM   4406  CA  ALA C  69     -13.037  -3.428  -7.840  1.00 29.21           C  
ATOM   4407  C   ALA C  69     -14.242  -2.770  -7.187  1.00 28.18           C  
ATOM   4408  O   ALA C  69     -14.669  -3.160  -6.111  1.00 27.66           O  
ATOM   4409  CB  ALA C  69     -11.761  -2.541  -7.619  1.00 28.90           C  
ATOM   4410  N   GLN C  70     -14.761  -1.751  -7.855  1.00 30.22           N  
ATOM   4411  CA  GLN C  70     -15.908  -0.982  -7.361  1.00 30.87           C  
ATOM   4412  C   GLN C  70     -17.162  -1.832  -7.252  1.00 30.60           C  
ATOM   4413  O   GLN C  70     -17.919  -1.682  -6.294  1.00 28.56           O  
ATOM   4414  CB  GLN C  70     -16.174   0.209  -8.265  1.00 30.61           C  
ATOM   4415  CG  GLN C  70     -17.302   1.087  -7.767  1.00 34.66           C  
ATOM   4416  CD  GLN C  70     -17.491   2.310  -8.619  1.00 35.64           C  
ATOM   4417  OE1 GLN C  70     -17.422   2.243  -9.855  1.00 44.87           O  
ATOM   4418  NE2 GLN C  70     -17.759   3.442  -7.969  1.00 37.42           N  
ATOM   4419  N   GLU C  71     -17.376  -2.716  -8.231  1.00 32.89           N  
ATOM   4420  CA  GLU C  71     -18.531  -3.626  -8.219  1.00 32.75           C  
ATOM   4421  C   GLU C  71     -18.416  -4.568  -7.038  1.00 30.24           C  
ATOM   4422  O   GLU C  71     -19.376  -4.814  -6.329  1.00 31.09           O  
ATOM   4423  CB  GLU C  71     -18.592  -4.532  -9.454  1.00 33.64           C  
ATOM   4424  CG  GLU C  71     -18.754  -3.893 -10.806  1.00 38.38           C  
ATOM   4425  CD  GLU C  71     -19.357  -4.881 -11.828  1.00 41.21           C  
ATOM   4426  OE1 GLU C  71     -19.281  -6.124 -11.607  1.00 48.96           O  
ATOM   4427  OE2 GLU C  71     -19.936  -4.407 -12.838  1.00 43.48           O  
ATOM   4428  N   LYS C  72     -17.233  -5.137  -6.855  1.00 29.19           N  
ATOM   4429  CA  LYS C  72     -17.030  -6.069  -5.754  1.00 29.12           C  
ATOM   4430  C   LYS C  72     -17.206  -5.430  -4.391  1.00 27.54           C  
ATOM   4431  O   LYS C  72     -17.650  -6.089  -3.453  1.00 29.92           O  
ATOM   4432  CB  LYS C  72     -15.673  -6.757  -5.879  1.00 30.90           C  
ATOM   4433  CG  LYS C  72     -15.530  -7.557  -7.183  1.00 31.39           C  
ATOM   4434  CD  LYS C  72     -14.305  -8.447  -7.205  1.00 34.79           C  
ATOM   4435  CE  LYS C  72     -13.057  -7.697  -7.019  1.00 32.70           C  
ATOM   4436  NZ  LYS C  72     -11.873  -8.572  -7.181  1.00 30.14           N  
ATOM   4437  N   ALA C  73     -16.869  -4.151  -4.268  1.00 27.59           N  
ATOM   4438  CA  ALA C  73     -17.044  -3.423  -3.010  1.00 28.03           C  
ATOM   4439  C   ALA C  73     -18.521  -3.234  -2.804  1.00 28.90           C  
ATOM   4440  O   ALA C  73     -19.066  -3.426  -1.721  1.00 31.19           O  
ATOM   4441  CB  ALA C  73     -16.341  -2.057  -3.068  1.00 27.32           C  
HETATM 4442  N   MSE C  74     -19.165  -2.845  -3.887  1.00 30.67           N  
HETATM 4443  CA  MSE C  74     -20.584  -2.623  -3.892  1.00 30.85           C  
HETATM 4444  C   MSE C  74     -21.210  -3.933  -3.427  1.00 28.26           C  
HETATM 4445  O   MSE C  74     -21.826  -3.978  -2.350  1.00 30.44           O  
HETATM 4446  CB  MSE C  74     -20.944  -2.132  -5.284  1.00 32.63           C  
HETATM 4447  CG  MSE C  74     -22.392  -1.835  -5.544  1.00 31.45           C  
HETATM 4448 SE   MSE C  74     -23.161  -3.623  -5.849  0.75 41.95          SE  
HETATM 4449  CE  MSE C  74     -23.987  -3.852  -4.108  1.00 50.10           C  
ATOM   4450  N   GLU C  75     -21.006  -5.004  -4.221  1.00 28.68           N  
ATOM   4451  CA  GLU C  75     -21.522  -6.361  -3.913  1.00 32.29           C  
ATOM   4452  C   GLU C  75     -21.363  -6.820  -2.468  1.00 30.71           C  
ATOM   4453  O   GLU C  75     -22.221  -7.478  -1.929  1.00 31.61           O  
ATOM   4454  CB  GLU C  75     -20.857  -7.408  -4.832  1.00 31.22           C  
ATOM   4455  CG  GLU C  75     -21.357  -7.375  -6.271  1.00 35.70           C  
ATOM   4456  CD  GLU C  75     -20.554  -8.235  -7.235  1.00 36.56           C  
ATOM   4457  OE1 GLU C  75     -19.552  -8.869  -6.835  1.00 48.20           O  
ATOM   4458  OE2 GLU C  75     -20.925  -8.253  -8.421  1.00 41.06           O  
ATOM   4459  N   THR C  76     -20.258  -6.477  -1.833  1.00 32.10           N  
ATOM   4460  CA  THR C  76     -20.018  -6.933  -0.472  1.00 31.09           C  
ATOM   4461  C   THR C  76     -20.243  -5.850   0.587  1.00 31.80           C  
ATOM   4462  O   THR C  76     -19.849  -6.012   1.748  1.00 31.38           O  
ATOM   4463  CB  THR C  76     -18.608  -7.531  -0.398  1.00 29.14           C  
ATOM   4464  OG1 THR C  76     -17.655  -6.536  -0.780  1.00 26.72           O  
ATOM   4465  CG2 THR C  76     -18.515  -8.694  -1.369  1.00 27.38           C  
ATOM   4466  N   ASN C  77     -20.880  -4.748   0.182  1.00 32.62           N  
ATOM   4467  CA  ASN C  77     -21.215  -3.633   1.081  1.00 31.96           C  
ATOM   4468  C   ASN C  77     -20.010  -2.946   1.738  1.00 32.64           C  
ATOM   4469  O   ASN C  77     -20.060  -2.543   2.900  1.00 32.09           O  
ATOM   4470  CB  ASN C  77     -22.173  -4.137   2.152  1.00 33.54           C  
ATOM   4471  CG  ASN C  77     -23.056  -3.048   2.704  1.00 37.36           C  
ATOM   4472  OD1 ASN C  77     -23.162  -1.961   2.139  1.00 47.01           O  
ATOM   4473  ND2 ASN C  77     -23.715  -3.343   3.809  1.00 40.94           N  
ATOM   4474  N   ARG C  78     -18.920  -2.828   0.990  1.00 31.24           N  
ATOM   4475  CA  ARG C  78     -17.721  -2.174   1.485  1.00 32.27           C  
ATOM   4476  C   ARG C  78     -17.600  -0.814   0.849  1.00 32.72           C  
ATOM   4477  O   ARG C  78     -18.065  -0.596  -0.280  1.00 32.19           O  
ATOM   4478  CB  ARG C  78     -16.487  -2.994   1.167  1.00 32.09           C  
ATOM   4479  CG  ARG C  78     -16.302  -4.200   2.066  1.00 35.02           C  
ATOM   4480  CD  ARG C  78     -15.468  -5.199   1.323  1.00 37.84           C  
ATOM   4481  NE  ARG C  78     -15.050  -6.352   2.100  1.00 35.50           N  
ATOM   4482  CZ  ARG C  78     -14.851  -7.559   1.574  1.00 38.68           C  
ATOM   4483  NH1 ARG C  78     -15.138  -7.800   0.299  1.00 34.90           N  
ATOM   4484  NH2 ARG C  78     -14.426  -8.552   2.342  1.00 40.94           N  
ATOM   4485  N   HIS C  79     -16.975   0.098   1.587  1.00 33.14           N  
ATOM   4486  CA  HIS C  79     -16.788   1.457   1.128  1.00 32.76           C  
ATOM   4487  C   HIS C  79     -15.328   1.860   1.003  1.00 32.39           C  
ATOM   4488  O   HIS C  79     -14.657   2.181   1.980  1.00 31.63           O  
ATOM   4489  CB  HIS C  79     -17.580   2.392   2.017  1.00 32.76           C  
ATOM   4490  CG  HIS C  79     -19.058   2.239   1.845  1.00 32.77           C  
ATOM   4491  ND1 HIS C  79     -19.847   1.552   2.741  1.00 35.09           N  
ATOM   4492  CD2 HIS C  79     -19.886   2.648   0.852  1.00 34.43           C  
ATOM   4493  CE1 HIS C  79     -21.102   1.580   2.330  1.00 31.68           C  
ATOM   4494  NE2 HIS C  79     -21.151   2.239   1.186  1.00 36.62           N  
ATOM   4495  N   VAL C  80     -14.856   1.824  -0.232  1.00 31.44           N  
ATOM   4496  CA  VAL C  80     -13.494   2.183  -0.573  1.00 32.51           C  
ATOM   4497  C   VAL C  80     -13.535   3.192  -1.718  1.00 32.72           C  
ATOM   4498  O   VAL C  80     -14.246   2.989  -2.700  1.00 30.23           O  
ATOM   4499  CB  VAL C  80     -12.704   0.936  -1.026  1.00 32.73           C  
ATOM   4500  CG1 VAL C  80     -11.310   1.317  -1.512  1.00 31.98           C  
ATOM   4501  CG2 VAL C  80     -12.654  -0.092   0.102  1.00 32.67           C  
ATOM   4502  N   ASP C  81     -12.812   4.297  -1.577  1.00 32.59           N  
ATOM   4503  CA  ASP C  81     -12.716   5.272  -2.659  1.00 33.32           C  
ATOM   4504  C   ASP C  81     -11.715   4.709  -3.629  1.00 31.86           C  
ATOM   4505  O   ASP C  81     -10.607   4.392  -3.217  1.00 32.31           O  
ATOM   4506  CB  ASP C  81     -12.159   6.610  -2.162  1.00 36.98           C  
ATOM   4507  CG  ASP C  81     -13.154   7.409  -1.359  1.00 41.24           C  
ATOM   4508  OD1 ASP C  81     -14.377   7.145  -1.456  1.00 41.20           O  
ATOM   4509  OD2 ASP C  81     -12.689   8.320  -0.638  1.00 49.61           O  
ATOM   4510  N   PHE C  82     -12.092   4.557  -4.896  1.00 30.44           N  
ATOM   4511  CA  PHE C  82     -11.151   4.087  -5.907  1.00 30.53           C  
ATOM   4512  C   PHE C  82     -10.798   5.250  -6.830  1.00 29.86           C  
ATOM   4513  O   PHE C  82     -11.672   5.859  -7.410  1.00 31.97           O  
ATOM   4514  CB  PHE C  82     -11.705   2.906  -6.696  1.00 31.83           C  
ATOM   4515  CG  PHE C  82     -11.822   1.651  -5.896  1.00 34.56           C  
ATOM   4516  CD1 PHE C  82     -10.726   0.830  -5.719  1.00 37.01           C  
ATOM   4517  CD2 PHE C  82     -13.037   1.281  -5.331  1.00 35.70           C  
ATOM   4518  CE1 PHE C  82     -10.815  -0.332  -4.960  1.00 37.70           C  
ATOM   4519  CE2 PHE C  82     -13.152   0.103  -4.595  1.00 35.36           C  
ATOM   4520  CZ  PHE C  82     -12.031  -0.702  -4.404  1.00 38.33           C  
ATOM   4521  N   TRP C  83      -9.517   5.560  -6.963  1.00 30.62           N  
ATOM   4522  CA  TRP C  83      -9.102   6.668  -7.807  1.00 31.11           C  
ATOM   4523  C   TRP C  83      -8.220   6.194  -8.951  1.00 31.02           C  
ATOM   4524  O   TRP C  83      -7.315   5.382  -8.763  1.00 29.51           O  
ATOM   4525  CB  TRP C  83      -8.373   7.736  -6.985  1.00 35.13           C  
ATOM   4526  CG  TRP C  83      -9.195   8.339  -5.851  1.00 39.33           C  
ATOM   4527  CD1 TRP C  83      -8.847   8.400  -4.531  1.00 41.92           C  
ATOM   4528  CD2 TRP C  83     -10.510   8.926  -5.939  1.00 49.11           C  
ATOM   4529  NE1 TRP C  83      -9.836   9.018  -3.797  1.00 42.47           N  
ATOM   4530  CE2 TRP C  83     -10.871   9.346  -4.635  1.00 50.91           C  
ATOM   4531  CE3 TRP C  83     -11.413   9.155  -6.995  1.00 46.64           C  
ATOM   4532  CZ2 TRP C  83     -12.102   9.975  -4.358  1.00 47.75           C  
ATOM   4533  CZ3 TRP C  83     -12.636   9.777  -6.719  1.00 44.23           C  
ATOM   4534  CH2 TRP C  83     -12.963  10.182  -5.410  1.00 45.72           C  
ATOM   4535  N   VAL C  84      -8.517   6.683 -10.155  1.00 31.63           N  
ATOM   4536  CA  VAL C  84      -7.704   6.366 -11.318  1.00 33.59           C  
ATOM   4537  C   VAL C  84      -6.488   7.275 -11.262  1.00 33.95           C  
ATOM   4538  O   VAL C  84      -6.624   8.485 -11.416  1.00 36.07           O  
ATOM   4539  CB  VAL C  84      -8.439   6.579 -12.654  1.00 33.81           C  
ATOM   4540  CG1 VAL C  84      -7.495   6.259 -13.809  1.00 35.47           C  
ATOM   4541  CG2 VAL C  84      -9.646   5.675 -12.722  1.00 31.84           C  
ATOM   4542  N   GLN C  85      -5.320   6.693 -11.028  1.00 33.33           N  
ATOM   4543  CA  GLN C  85      -4.059   7.444 -10.947  1.00 35.71           C  
ATOM   4544  C   GLN C  85      -2.879   6.564 -11.271  1.00 35.45           C  
ATOM   4545  O   GLN C  85      -2.923   5.337 -11.100  1.00 35.48           O  
ATOM   4546  CB  GLN C  85      -3.800   8.002  -9.551  1.00 34.89           C  
ATOM   4547  CG  GLN C  85      -4.844   8.949  -9.024  1.00 38.89           C  
ATOM   4548  CD  GLN C  85      -4.353   9.801  -7.868  1.00 40.62           C  
ATOM   4549  OE1 GLN C  85      -3.205   9.703  -7.437  1.00 41.62           O  
ATOM   4550  NE2 GLN C  85      -5.225  10.670  -7.383  1.00 50.02           N  
ATOM   4551  N   ASP C  86      -1.814   7.217 -11.696  1.00 35.11           N  
ATOM   4552  CA  ASP C  86      -0.557   6.574 -12.011  1.00 35.70           C  
ATOM   4553  C   ASP C  86       0.259   6.643 -10.722  1.00 37.49           C  
ATOM   4554  O   ASP C  86       0.479   7.738 -10.198  1.00 37.77           O  
ATOM   4555  CB  ASP C  86       0.093   7.369 -13.138  1.00 36.30           C  
ATOM   4556  CG  ASP C  86       1.373   6.762 -13.635  1.00 38.69           C  
ATOM   4557  OD1 ASP C  86       2.183   6.239 -12.842  1.00 34.15           O  
ATOM   4558  OD2 ASP C  86       1.595   6.861 -14.850  1.00 45.48           O  
HETATM 4559  N   MSE C  87       0.708   5.490 -10.203  1.00 37.11           N  
HETATM 4560  CA  MSE C  87       1.479   5.456  -8.927  1.00 36.16           C  
HETATM 4561  C   MSE C  87       2.753   6.304  -8.957  1.00 34.92           C  
HETATM 4562  O   MSE C  87       3.191   6.799  -7.931  1.00 37.73           O  
HETATM 4563  CB  MSE C  87       1.825   4.014  -8.516  1.00 37.50           C  
HETATM 4564  CG  MSE C  87       2.850   3.311  -9.405  1.00 33.53           C  
HETATM 4565 SE   MSE C  87       3.248   1.523  -8.826  0.75 36.46          SE  
HETATM 4566  CE  MSE C  87       1.480   0.695  -9.127  1.00 35.27           C  
ATOM   4567  N   ARG C  88       3.340   6.483 -10.138  1.00 33.84           N  
ATOM   4568  CA  ARG C  88       4.527   7.309 -10.297  1.00 33.23           C  
ATOM   4569  C   ARG C  88       4.289   8.762  -9.926  1.00 35.17           C  
ATOM   4570  O   ARG C  88       5.215   9.463  -9.542  1.00 35.29           O  
ATOM   4571  CB  ARG C  88       5.042   7.232 -11.734  1.00 32.33           C  
ATOM   4572  CG  ARG C  88       5.510   5.842 -12.110  1.00 33.88           C  
ATOM   4573  CD  ARG C  88       5.924   5.761 -13.547  1.00 35.10           C  
ATOM   4574  NE  ARG C  88       4.781   5.938 -14.430  1.00 38.65           N  
ATOM   4575  CZ  ARG C  88       4.868   6.072 -15.749  1.00 39.77           C  
ATOM   4576  NH1 ARG C  88       6.037   6.043 -16.374  1.00 38.80           N  
ATOM   4577  NH2 ARG C  88       3.772   6.240 -16.461  1.00 48.14           N  
ATOM   4578  N   GLU C  89       3.045   9.213 -10.032  1.00 37.85           N  
ATOM   4579  CA  GLU C  89       2.698  10.602  -9.752  1.00 41.00           C  
ATOM   4580  C   GLU C  89       1.407  10.630  -8.951  1.00 40.52           C  
ATOM   4581  O   GLU C  89       0.472  11.349  -9.271  1.00 41.26           O  
ATOM   4582  CB  GLU C  89       2.589  11.394 -11.068  1.00 40.39           C  
ATOM   4583  CG  GLU C  89       1.656  10.779 -12.108  1.00 46.30           C  
ATOM   4584  CD  GLU C  89       1.647  11.529 -13.452  1.00 46.90           C  
ATOM   4585  OE1 GLU C  89       2.144  12.683 -13.537  1.00 52.17           O  
ATOM   4586  OE2 GLU C  89       1.118  10.948 -14.427  1.00 55.82           O  
ATOM   4587  N   LEU C  90       1.392   9.822  -7.897  1.00 40.87           N  
ATOM   4588  CA  LEU C  90       0.258   9.660  -7.001  1.00 42.23           C  
ATOM   4589  C   LEU C  90      -0.069  11.022  -6.380  1.00 44.72           C  
ATOM   4590  O   LEU C  90       0.833  11.777  -6.044  1.00 45.08           O  
ATOM   4591  CB  LEU C  90       0.660   8.665  -5.907  1.00 42.11           C  
ATOM   4592  CG  LEU C  90      -0.302   7.838  -5.079  1.00 43.84           C  
ATOM   4593  CD1 LEU C  90       0.482   7.387  -3.843  1.00 43.47           C  
ATOM   4594  CD2 LEU C  90      -1.561   8.574  -4.682  1.00 52.12           C  
ATOM   4595  N   GLU C  91      -1.353  11.347  -6.252  1.00 45.77           N  
ATOM   4596  CA  GLU C  91      -1.773  12.619  -5.658  1.00 46.06           C  
ATOM   4597  C   GLU C  91      -3.135  12.442  -4.986  1.00 47.19           C  
ATOM   4598  O   GLU C  91      -4.151  12.336  -5.672  1.00 48.29           O  
ATOM   4599  CB  GLU C  91      -1.837  13.721  -6.725  1.00 46.66           C  
ATOM   4600  N   LEU C  92      -3.154  12.402  -3.654  1.00 46.84           N  
ATOM   4601  CA  LEU C  92      -4.391  12.191  -2.888  1.00 48.19           C  
ATOM   4602  C   LEU C  92      -4.823  13.395  -2.043  1.00 49.15           C  
ATOM   4603  O   LEU C  92      -3.977  14.156  -1.556  1.00 48.86           O  
ATOM   4604  CB  LEU C  92      -4.263  10.949  -2.007  1.00 48.77           C  
ATOM   4605  CG  LEU C  92      -4.379   9.662  -2.814  1.00 49.51           C  
ATOM   4606  CD1 LEU C  92      -3.894   8.457  -2.028  1.00 40.53           C  
ATOM   4607  CD2 LEU C  92      -5.823   9.501  -3.276  1.00 49.92           C  
ATOM   4608  N   PRO C  93      -6.151  13.545  -1.844  1.00 51.54           N  
ATOM   4609  CA  PRO C  93      -6.714  14.680  -1.128  1.00 52.17           C  
ATOM   4610  C   PRO C  93      -6.552  14.622   0.385  1.00 52.97           C  
ATOM   4611  O   PRO C  93      -6.282  15.656   0.988  1.00 55.33           O  
ATOM   4612  CB  PRO C  93      -8.192  14.622  -1.508  1.00 52.28           C  
ATOM   4613  CG  PRO C  93      -8.461  13.180  -1.725  1.00 51.48           C  
ATOM   4614  CD  PRO C  93      -7.204  12.604  -2.285  1.00 52.65           C  
ATOM   4615  N   GLU C  94      -6.720  13.444   0.992  1.00 52.20           N  
ATOM   4616  CA  GLU C  94      -6.594  13.302   2.448  1.00 50.85           C  
ATOM   4617  C   GLU C  94      -5.301  12.574   2.844  1.00 48.96           C  
ATOM   4618  O   GLU C  94      -4.712  11.860   2.028  1.00 48.78           O  
ATOM   4619  CB  GLU C  94      -7.817  12.575   3.034  1.00 51.21           C  
ATOM   4620  CG  GLU C  94      -9.132  13.389   3.034  1.00 51.24           C  
ATOM   4621  CD  GLU C  94      -9.138  14.589   4.003  1.00 57.64           C  
ATOM   4622  OE1 GLU C  94      -8.361  14.622   4.982  1.00 59.21           O  
ATOM   4623  OE2 GLU C  94      -9.955  15.510   3.798  1.00 64.26           O  
ATOM   4624  N   PRO C  95      -4.845  12.769   4.101  1.00 46.72           N  
ATOM   4625  CA  PRO C  95      -3.647  12.080   4.585  1.00 44.44           C  
ATOM   4626  C   PRO C  95      -3.828  10.575   4.666  1.00 41.24           C  
ATOM   4627  O   PRO C  95      -4.961  10.109   4.778  1.00 40.49           O  
ATOM   4628  CB  PRO C  95      -3.470  12.630   6.007  1.00 44.43           C  
ATOM   4629  CG  PRO C  95      -4.273  13.873   6.060  1.00 44.91           C  
ATOM   4630  CD  PRO C  95      -5.413  13.654   5.137  1.00 46.36           C  
ATOM   4631  N   VAL C  96      -2.723   9.832   4.572  1.00 38.98           N  
ATOM   4632  CA  VAL C  96      -2.731   8.368   4.752  1.00 35.88           C  
ATOM   4633  C   VAL C  96      -1.581   7.987   5.657  1.00 34.47           C  
ATOM   4634  O   VAL C  96      -0.494   8.560   5.571  1.00 34.30           O  
ATOM   4635  CB  VAL C  96      -2.617   7.534   3.424  1.00 36.03           C  
ATOM   4636  CG1 VAL C  96      -3.791   7.809   2.491  1.00 32.47           C  
ATOM   4637  CG2 VAL C  96      -1.294   7.782   2.724  1.00 36.41           C  
ATOM   4638  N   ASP C  97      -1.828   6.998   6.512  1.00 33.51           N  
ATOM   4639  CA  ASP C  97      -0.831   6.494   7.443  1.00 32.41           C  
ATOM   4640  C   ASP C  97       0.134   5.479   6.807  1.00 31.30           C  
ATOM   4641  O   ASP C  97       1.231   5.267   7.318  1.00 30.34           O  
ATOM   4642  CB  ASP C  97      -1.536   5.864   8.650  1.00 33.08           C  
ATOM   4643  CG  ASP C  97      -2.458   6.847   9.374  1.00 35.56           C  
ATOM   4644  OD1 ASP C  97      -1.962   7.877   9.885  1.00 38.09           O  
ATOM   4645  OD2 ASP C  97      -3.680   6.571   9.453  1.00 33.62           O  
ATOM   4646  N   ALA C  98      -0.302   4.835   5.723  1.00 30.96           N  
ATOM   4647  CA  ALA C  98       0.502   3.852   5.006  1.00 29.99           C  
ATOM   4648  C   ALA C  98       0.117   3.738   3.534  1.00 30.54           C  
ATOM   4649  O   ALA C  98      -1.035   3.995   3.128  1.00 30.79           O  
ATOM   4650  CB  ALA C  98       0.371   2.484   5.641  1.00 29.21           C  
ATOM   4651  N   ILE C  99       1.095   3.315   2.757  1.00 29.71           N  
ATOM   4652  CA  ILE C  99       0.903   3.016   1.364  1.00 30.48           C  
ATOM   4653  C   ILE C  99       1.306   1.547   1.181  1.00 30.77           C  
ATOM   4654  O   ILE C  99       2.316   1.082   1.731  1.00 28.82           O  
ATOM   4655  CB  ILE C  99       1.712   3.956   0.442  1.00 32.18           C  
ATOM   4656  CG1 ILE C  99       1.260   5.412   0.647  1.00 32.07           C  
ATOM   4657  CG2 ILE C  99       1.570   3.501  -1.032  1.00 30.81           C  
ATOM   4658  CD1 ILE C  99       1.929   6.438  -0.274  1.00 31.25           C  
ATOM   4659  N   THR C 100       0.466   0.798   0.471  1.00 29.67           N  
ATOM   4660  CA  THR C 100       0.765  -0.584   0.141  1.00 28.22           C  
ATOM   4661  C   THR C 100       0.768  -0.718  -1.375  1.00 29.40           C  
ATOM   4662  O   THR C 100      -0.088  -0.131  -2.046  1.00 29.04           O  
ATOM   4663  CB  THR C 100      -0.271  -1.571   0.782  1.00 30.09           C  
ATOM   4664  OG1 THR C 100      -1.606  -1.279   0.319  1.00 32.73           O  
ATOM   4665  CG2 THR C 100      -0.255  -1.450   2.289  1.00 26.72           C  
ATOM   4666  N   ILE C 101       1.742  -1.465  -1.901  1.00 29.00           N  
ATOM   4667  CA  ILE C 101       1.836  -1.815  -3.312  1.00 28.57           C  
ATOM   4668  C   ILE C 101       2.038  -3.323  -3.271  1.00 31.40           C  
ATOM   4669  O   ILE C 101       3.152  -3.835  -3.133  1.00 30.78           O  
ATOM   4670  CB  ILE C 101       2.956  -1.088  -4.076  1.00 29.33           C  
ATOM   4671  CG1 ILE C 101       3.051   0.371  -3.617  1.00 31.02           C  
ATOM   4672  CG2 ILE C 101       2.710  -1.203  -5.600  1.00 25.03           C  
ATOM   4673  CD1 ILE C 101       4.164   1.195  -4.297  1.00 28.39           C  
ATOM   4674  N   LEU C 102       0.932  -4.049  -3.370  1.00 30.79           N  
ATOM   4675  CA  LEU C 102       0.967  -5.486  -3.192  1.00 30.47           C  
ATOM   4676  C   LEU C 102       0.972  -6.356  -4.459  1.00 31.02           C  
ATOM   4677  O   LEU C 102       0.660  -5.890  -5.580  1.00 30.91           O  
ATOM   4678  CB  LEU C 102      -0.187  -5.877  -2.245  1.00 32.12           C  
ATOM   4679  CG  LEU C 102      -0.345  -5.073  -0.935  1.00 27.92           C  
ATOM   4680  CD1 LEU C 102      -1.610  -5.530  -0.173  1.00 35.48           C  
ATOM   4681  CD2 LEU C 102       0.886  -5.211  -0.032  1.00 28.75           C  
ATOM   4682  N   CYS C 103       1.389  -7.605  -4.260  1.00 32.39           N  
ATOM   4683  CA  CYS C 103       1.358  -8.671  -5.287  1.00 31.94           C  
ATOM   4684  C   CYS C 103       2.088  -8.350  -6.556  1.00 31.61           C  
ATOM   4685  O   CYS C 103       1.528  -8.429  -7.660  1.00 28.86           O  
ATOM   4686  CB  CYS C 103      -0.101  -9.025  -5.601  1.00 34.89           C  
ATOM   4687  SG  CYS C 103      -1.081  -9.370  -4.098  1.00 39.32           S  
ATOM   4688  N   ASP C 104       3.355  -8.007  -6.385  1.00 31.12           N  
ATOM   4689  CA  ASP C 104       4.281  -7.652  -7.461  1.00 29.75           C  
ATOM   4690  C   ASP C 104       3.747  -6.561  -8.409  1.00 28.71           C  
ATOM   4691  O   ASP C 104       4.205  -6.425  -9.537  1.00 29.85           O  
ATOM   4692  CB  ASP C 104       4.831  -8.897  -8.193  1.00 30.21           C  
ATOM   4693  CG  ASP C 104       3.737  -9.823  -8.747  1.00 33.20           C  
ATOM   4694  OD1 ASP C 104       3.285 -10.714  -8.006  1.00 29.99           O  
ATOM   4695  OD2 ASP C 104       3.363  -9.701  -9.948  1.00 26.94           O  
ATOM   4696  N   SER C 105       2.810  -5.750  -7.911  1.00 29.60           N  
ATOM   4697  CA  SER C 105       2.283  -4.639  -8.670  1.00 32.46           C  
ATOM   4698  C   SER C 105       3.373  -3.620  -9.031  1.00 29.96           C  
ATOM   4699  O   SER C 105       3.396  -3.084 -10.152  1.00 29.18           O  
ATOM   4700  CB  SER C 105       1.171  -3.949  -7.904  1.00 34.66           C  
ATOM   4701  OG  SER C 105       0.691  -2.921  -8.709  1.00 36.08           O  
ATOM   4702  N   LEU C 106       4.291  -3.367  -8.090  1.00 31.81           N  
ATOM   4703  CA  LEU C 106       5.405  -2.455  -8.346  1.00 28.70           C  
ATOM   4704  C   LEU C 106       6.269  -2.922  -9.509  1.00 29.21           C  
ATOM   4705  O   LEU C 106       6.942  -2.110 -10.115  1.00 30.30           O  
ATOM   4706  CB  LEU C 106       6.310  -2.341  -7.101  1.00 29.73           C  
ATOM   4707  CG  LEU C 106       7.356  -1.218  -7.107  1.00 29.06           C  
ATOM   4708  CD1 LEU C 106       6.626   0.115  -6.947  1.00 34.51           C  
ATOM   4709  CD2 LEU C 106       8.436  -1.415  -6.042  1.00 27.31           C  
ATOM   4710  N   ASN C 107       6.298  -4.235  -9.782  1.00 30.51           N  
ATOM   4711  CA  ASN C 107       7.139  -4.813 -10.861  1.00 27.75           C  
ATOM   4712  C   ASN C 107       6.635  -4.510 -12.267  1.00 28.31           C  
ATOM   4713  O   ASN C 107       7.327  -4.795 -13.211  1.00 28.84           O  
ATOM   4714  CB  ASN C 107       7.354  -6.341 -10.688  1.00 27.76           C  
ATOM   4715  CG  ASN C 107       8.213  -6.708  -9.486  1.00 25.09           C  
ATOM   4716  OD1 ASN C 107       7.802  -7.475  -8.638  1.00 28.29           O  
ATOM   4717  ND2 ASN C 107       9.411  -6.147  -9.414  1.00 26.75           N  
ATOM   4718  N   TYR C 108       5.426  -3.968 -12.410  1.00 29.64           N  
ATOM   4719  CA  TYR C 108       4.929  -3.516 -13.711  1.00 29.77           C  
ATOM   4720  C   TYR C 108       5.608  -2.231 -14.184  1.00 29.30           C  
ATOM   4721  O   TYR C 108       5.532  -1.906 -15.362  1.00 28.36           O  
ATOM   4722  CB  TYR C 108       3.385  -3.387 -13.734  1.00 32.50           C  
ATOM   4723  CG  TYR C 108       2.729  -4.744 -13.654  1.00 31.65           C  
ATOM   4724  CD1 TYR C 108       2.678  -5.572 -14.776  1.00 36.16           C  
ATOM   4725  CD2 TYR C 108       2.204  -5.224 -12.460  1.00 34.86           C  
ATOM   4726  CE1 TYR C 108       2.103  -6.822 -14.723  1.00 34.45           C  
ATOM   4727  CE2 TYR C 108       1.619  -6.480 -12.393  1.00 34.92           C  
ATOM   4728  CZ  TYR C 108       1.592  -7.271 -13.525  1.00 37.04           C  
ATOM   4729  OH  TYR C 108       1.034  -8.512 -13.463  1.00 40.65           O  
ATOM   4730  N   LEU C 109       6.280  -1.511 -13.278  1.00 30.07           N  
ATOM   4731  CA  LEU C 109       7.045  -0.325 -13.672  1.00 30.01           C  
ATOM   4732  C   LEU C 109       8.131  -0.814 -14.633  1.00 28.61           C  
ATOM   4733  O   LEU C 109       8.653  -1.923 -14.493  1.00 29.90           O  
ATOM   4734  CB  LEU C 109       7.604   0.426 -12.453  1.00 29.10           C  
ATOM   4735  CG  LEU C 109       6.551   0.941 -11.466  1.00 29.12           C  
ATOM   4736  CD1 LEU C 109       7.226   1.608 -10.235  1.00 23.49           C  
ATOM   4737  CD2 LEU C 109       5.569   1.870 -12.127  1.00 26.22           C  
ATOM   4738  N   GLN C 110       8.450   0.001 -15.625  1.00 31.75           N  
ATOM   4739  CA  GLN C 110       9.372  -0.411 -16.677  1.00 32.30           C  
ATOM   4740  C   GLN C 110      10.786   0.124 -16.578  1.00 33.50           C  
ATOM   4741  O   GLN C 110      11.723  -0.546 -17.026  1.00 35.18           O  
ATOM   4742  CB  GLN C 110       8.746  -0.082 -18.027  1.00 33.80           C  
ATOM   4743  CG  GLN C 110       7.526  -0.960 -18.281  1.00 36.62           C  
ATOM   4744  CD  GLN C 110       6.744  -0.608 -19.533  1.00 34.97           C  
ATOM   4745  OE1 GLN C 110       7.029   0.381 -20.205  1.00 45.89           O  
ATOM   4746  NE2 GLN C 110       5.743  -1.425 -19.846  1.00 35.90           N  
ATOM   4747  N   THR C 111      10.966   1.308 -15.991  1.00 31.36           N  
ATOM   4748  CA  THR C 111      12.297   1.872 -15.874  1.00 30.96           C  
ATOM   4749  C   THR C 111      12.661   2.127 -14.426  1.00 30.39           C  
ATOM   4750  O   THR C 111      11.796   2.143 -13.552  1.00 27.27           O  
ATOM   4751  CB  THR C 111      12.388   3.230 -16.588  1.00 32.40           C  
ATOM   4752  OG1 THR C 111      11.597   4.178 -15.862  1.00 32.42           O  
ATOM   4753  CG2 THR C 111      11.901   3.134 -18.029  1.00 30.36           C  
ATOM   4754  N   GLU C 112      13.948   2.376 -14.202  1.00 29.38           N  
ATOM   4755  CA  GLU C 112      14.449   2.701 -12.884  1.00 30.86           C  
ATOM   4756  C   GLU C 112      13.879   4.049 -12.419  1.00 29.60           C  
ATOM   4757  O   GLU C 112      13.494   4.199 -11.262  1.00 26.45           O  
ATOM   4758  CB  GLU C 112      15.981   2.725 -12.894  1.00 32.19           C  
ATOM   4759  CG  GLU C 112      16.604   1.399 -13.327  1.00 35.02           C  
ATOM   4760  CD  GLU C 112      18.118   1.377 -13.274  1.00 34.05           C  
ATOM   4761  OE1 GLU C 112      18.728   2.204 -12.556  1.00 38.93           O  
ATOM   4762  OE2 GLU C 112      18.695   0.515 -13.965  1.00 44.36           O  
ATOM   4763  N   ALA C 113      13.818   5.025 -13.324  1.00 28.77           N  
ATOM   4764  CA  ALA C 113      13.254   6.342 -12.997  1.00 29.17           C  
ATOM   4765  C   ALA C 113      11.815   6.204 -12.465  1.00 27.17           C  
ATOM   4766  O   ALA C 113      11.439   6.902 -11.527  1.00 27.80           O  
ATOM   4767  CB  ALA C 113      13.290   7.261 -14.211  1.00 27.78           C  
ATOM   4768  N   ASP C 114      11.043   5.294 -13.060  1.00 26.80           N  
ATOM   4769  CA  ASP C 114       9.649   5.015 -12.674  1.00 27.42           C  
ATOM   4770  C   ASP C 114       9.520   4.578 -11.222  1.00 27.60           C  
ATOM   4771  O   ASP C 114       8.548   4.908 -10.537  1.00 27.70           O  
ATOM   4772  CB  ASP C 114       9.063   3.856 -13.510  1.00 28.44           C  
ATOM   4773  CG  ASP C 114       8.813   4.201 -14.981  1.00 27.51           C  
ATOM   4774  OD1 ASP C 114       8.812   5.382 -15.351  1.00 37.18           O  
ATOM   4775  OD2 ASP C 114       8.593   3.250 -15.769  1.00 32.12           O  
ATOM   4776  N   VAL C 115      10.470   3.765 -10.773  1.00 28.06           N  
ATOM   4777  CA  VAL C 115      10.449   3.257  -9.401  1.00 27.16           C  
ATOM   4778  C   VAL C 115      10.790   4.426  -8.482  1.00 27.47           C  
ATOM   4779  O   VAL C 115      10.101   4.666  -7.519  1.00 27.33           O  
ATOM   4780  CB  VAL C 115      11.444   2.095  -9.192  1.00 28.69           C  
ATOM   4781  CG1 VAL C 115      11.392   1.635  -7.754  1.00 25.47           C  
ATOM   4782  CG2 VAL C 115      11.131   0.911 -10.138  1.00 27.58           C  
ATOM   4783  N   LYS C 116      11.852   5.159  -8.808  1.00 29.17           N  
ATOM   4784  CA  LYS C 116      12.247   6.327  -8.023  1.00 28.88           C  
ATOM   4785  C   LYS C 116      11.090   7.326  -7.930  1.00 28.98           C  
ATOM   4786  O   LYS C 116      10.767   7.791  -6.845  1.00 31.75           O  
ATOM   4787  CB  LYS C 116      13.521   6.956  -8.605  1.00 30.74           C  
ATOM   4788  CG  LYS C 116      14.787   6.177  -8.200  1.00 28.64           C  
ATOM   4789  CD  LYS C 116      16.070   6.717  -8.788  1.00 32.32           C  
ATOM   4790  CE  LYS C 116      16.297   6.206 -10.187  1.00 38.43           C  
ATOM   4791  NZ  LYS C 116      17.647   6.575 -10.660  1.00 34.80           N  
ATOM   4792  N   GLN C 117      10.451   7.634  -9.048  1.00 29.77           N  
ATOM   4793  CA  GLN C 117       9.291   8.529  -9.041  1.00 30.51           C  
ATOM   4794  C   GLN C 117       8.213   8.022  -8.113  1.00 28.56           C  
ATOM   4795  O   GLN C 117       7.626   8.799  -7.369  1.00 29.31           O  
ATOM   4796  CB  GLN C 117       8.635   8.604 -10.386  1.00 32.88           C  
ATOM   4797  CG  GLN C 117       9.344   9.324 -11.460  1.00 35.66           C  
ATOM   4798  CD  GLN C 117       8.434   9.393 -12.656  1.00 43.27           C  
ATOM   4799  OE1 GLN C 117       7.385  10.041 -12.588  1.00 48.22           O  
ATOM   4800  NE2 GLN C 117       8.792   8.694 -13.741  1.00 38.31           N  
ATOM   4801  N   THR C 118       7.930   6.724  -8.197  1.00 28.95           N  
ATOM   4802  CA  THR C 118       6.927   6.095  -7.356  1.00 28.53           C  
ATOM   4803  C   THR C 118       7.279   6.275  -5.900  1.00 28.58           C  
ATOM   4804  O   THR C 118       6.435   6.721  -5.128  1.00 30.50           O  
ATOM   4805  CB  THR C 118       6.729   4.609  -7.695  1.00 27.79           C  
ATOM   4806  OG1 THR C 118       6.454   4.482  -9.095  1.00 29.97           O  
ATOM   4807  CG2 THR C 118       5.570   3.999  -6.886  1.00 28.21           C  
ATOM   4808  N   PHE C 119       8.523   5.969  -5.518  1.00 28.07           N  
ATOM   4809  CA  PHE C 119       8.938   6.134  -4.127  1.00 28.94           C  
ATOM   4810  C   PHE C 119       8.887   7.601  -3.691  1.00 27.91           C  
ATOM   4811  O   PHE C 119       8.478   7.902  -2.574  1.00 29.18           O  
ATOM   4812  CB  PHE C 119      10.341   5.568  -3.857  1.00 28.01           C  
ATOM   4813  CG  PHE C 119      10.456   4.073  -4.006  1.00 31.34           C  
ATOM   4814  CD1 PHE C 119       9.332   3.252  -3.988  1.00 29.54           C  
ATOM   4815  CD2 PHE C 119      11.708   3.478  -4.069  1.00 31.68           C  
ATOM   4816  CE1 PHE C 119       9.463   1.869  -4.096  1.00 28.84           C  
ATOM   4817  CE2 PHE C 119      11.833   2.106  -4.181  1.00 32.18           C  
ATOM   4818  CZ  PHE C 119      10.713   1.302  -4.176  1.00 32.95           C  
ATOM   4819  N   ASP C 120       9.281   8.507  -4.578  1.00 28.85           N  
ATOM   4820  CA  ASP C 120       9.252   9.929  -4.266  1.00 28.67           C  
ATOM   4821  C   ASP C 120       7.822  10.423  -4.034  1.00 29.64           C  
ATOM   4822  O   ASP C 120       7.588  11.296  -3.203  1.00 28.34           O  
ATOM   4823  CB  ASP C 120       9.907  10.748  -5.392  1.00 31.51           C  
ATOM   4824  CG  ASP C 120      11.431  10.583  -5.439  1.00 31.84           C  
ATOM   4825  OD1 ASP C 120      12.004   9.952  -4.539  1.00 35.81           O  
ATOM   4826  OD2 ASP C 120      12.045  11.079  -6.401  1.00 39.32           O  
ATOM   4827  N   SER C 121       6.876   9.879  -4.795  1.00 29.79           N  
ATOM   4828  CA  SER C 121       5.480  10.274  -4.685  1.00 31.79           C  
ATOM   4829  C   SER C 121       4.896   9.759  -3.402  1.00 30.98           C  
ATOM   4830  O   SER C 121       4.067  10.445  -2.793  1.00 31.97           O  
ATOM   4831  CB  SER C 121       4.684   9.726  -5.852  1.00 31.66           C  
ATOM   4832  OG  SER C 121       5.252  10.184  -7.058  1.00 41.44           O  
ATOM   4833  N   ALA C 122       5.321   8.547  -3.019  1.00 30.18           N  
ATOM   4834  CA  ALA C 122       4.879   7.903  -1.782  1.00 29.54           C  
ATOM   4835  C   ALA C 122       5.342   8.699  -0.579  1.00 29.54           C  
ATOM   4836  O   ALA C 122       4.559   8.934   0.329  1.00 32.02           O  
ATOM   4837  CB  ALA C 122       5.397   6.490  -1.693  1.00 28.09           C  
ATOM   4838  N   ALA C 123       6.624   9.083  -0.573  1.00 30.96           N  
ATOM   4839  CA  ALA C 123       7.226   9.883   0.504  1.00 29.98           C  
ATOM   4840  C   ALA C 123       6.527  11.239   0.643  1.00 32.51           C  
ATOM   4841  O   ALA C 123       6.345  11.761   1.746  1.00 34.79           O  
ATOM   4842  CB  ALA C 123       8.745  10.095   0.241  1.00 31.41           C  
ATOM   4843  N   ARG C 124       6.140  11.803  -0.490  1.00 32.22           N  
ATOM   4844  CA  ARG C 124       5.447  13.064  -0.532  1.00 33.39           C  
ATOM   4845  C   ARG C 124       4.048  12.941   0.103  1.00 33.54           C  
ATOM   4846  O   ARG C 124       3.611  13.842   0.790  1.00 35.78           O  
ATOM   4847  CB  ARG C 124       5.395  13.515  -1.993  1.00 33.92           C  
ATOM   4848  CG  ARG C 124       5.118  14.930  -2.206  1.00 37.78           C  
ATOM   4849  CD  ARG C 124       5.614  15.404  -3.579  1.00 37.12           C  
ATOM   4850  NE  ARG C 124       5.045  14.673  -4.715  1.00 44.25           N  
ATOM   4851  CZ  ARG C 124       5.703  13.845  -5.527  1.00 39.33           C  
ATOM   4852  NH1 ARG C 124       6.995  13.604  -5.378  1.00 43.02           N  
ATOM   4853  NH2 ARG C 124       5.049  13.267  -6.522  1.00 48.11           N  
ATOM   4854  N   LEU C 125       3.370  11.814  -0.077  1.00 35.55           N  
ATOM   4855  CA  LEU C 125       2.034  11.631   0.492  1.00 35.75           C  
ATOM   4856  C   LEU C 125       2.114  11.368   1.998  1.00 35.78           C  
ATOM   4857  O   LEU C 125       1.315  11.876   2.779  1.00 39.63           O  
ATOM   4858  CB  LEU C 125       1.296  10.470  -0.215  1.00 37.44           C  
ATOM   4859  CG  LEU C 125      -0.248  10.494  -0.355  1.00 40.84           C  
ATOM   4860  CD1 LEU C 125      -0.767   9.205  -1.036  1.00 43.59           C  
ATOM   4861  CD2 LEU C 125      -0.993  10.748   0.972  1.00 50.32           C  
ATOM   4862  N   LEU C 126       3.095  10.592   2.414  1.00 36.38           N  
ATOM   4863  CA  LEU C 126       3.221  10.211   3.816  1.00 35.27           C  
ATOM   4864  C   LEU C 126       3.848  11.290   4.699  1.00 36.05           C  
ATOM   4865  O   LEU C 126       4.627  12.132   4.242  1.00 36.62           O  
ATOM   4866  CB  LEU C 126       4.063   8.938   3.918  1.00 35.17           C  
ATOM   4867  CG  LEU C 126       3.517   7.678   3.245  1.00 30.83           C  
ATOM   4868  CD1 LEU C 126       4.628   6.667   3.119  1.00 24.44           C  
ATOM   4869  CD2 LEU C 126       2.319   7.102   3.995  1.00 29.68           C  
ATOM   4870  N   THR C 127       3.505  11.259   5.979  1.00 36.34           N  
ATOM   4871  CA  THR C 127       4.142  12.156   6.933  1.00 36.31           C  
ATOM   4872  C   THR C 127       5.116  11.318   7.758  1.00 36.70           C  
ATOM   4873  O   THR C 127       5.171  10.091   7.636  1.00 34.86           O  
ATOM   4874  CB  THR C 127       3.128  12.883   7.821  1.00 37.04           C  
ATOM   4875  OG1 THR C 127       2.273  11.935   8.469  1.00 36.74           O  
ATOM   4876  CG2 THR C 127       2.280  13.831   6.989  1.00 34.40           C  
ATOM   4877  N   ASP C 128       5.913  11.998   8.563  1.00 36.52           N  
ATOM   4878  CA  ASP C 128       6.881  11.369   9.430  1.00 37.30           C  
ATOM   4879  C   ASP C 128       6.257  10.142  10.105  1.00 35.15           C  
ATOM   4880  O   ASP C 128       5.204  10.241  10.730  1.00 36.02           O  
ATOM   4881  CB  ASP C 128       7.322  12.413  10.465  1.00 37.42           C  
ATOM   4882  CG  ASP C 128       8.429  11.935  11.363  1.00 43.84           C  
ATOM   4883  OD1 ASP C 128       8.801  10.736  11.329  1.00 37.91           O  
ATOM   4884  OD2 ASP C 128       8.927  12.790  12.133  1.00 46.65           O  
ATOM   4885  N   GLY C 129       6.890   8.984   9.940  1.00 34.15           N  
ATOM   4886  CA  GLY C 129       6.420   7.743  10.551  1.00 33.24           C  
ATOM   4887  C   GLY C 129       5.441   6.929   9.714  1.00 32.22           C  
ATOM   4888  O   GLY C 129       5.056   5.832  10.115  1.00 33.08           O  
ATOM   4889  N   GLY C 130       5.024   7.466   8.565  1.00 31.68           N  
ATOM   4890  CA  GLY C 130       4.121   6.767   7.663  1.00 29.66           C  
ATOM   4891  C   GLY C 130       4.866   5.578   7.080  1.00 29.77           C  
ATOM   4892  O   GLY C 130       6.087   5.616   6.956  1.00 28.93           O  
ATOM   4893  N   LYS C 131       4.137   4.520   6.737  1.00 31.51           N  
ATOM   4894  CA  LYS C 131       4.744   3.288   6.230  1.00 31.08           C  
ATOM   4895  C   LYS C 131       4.487   3.033   4.768  1.00 30.25           C  
ATOM   4896  O   LYS C 131       3.410   3.295   4.268  1.00 30.29           O  
ATOM   4897  CB  LYS C 131       4.256   2.072   7.048  1.00 32.72           C  
ATOM   4898  CG  LYS C 131       4.913   1.931   8.422  1.00 38.41           C  
ATOM   4899  N   LEU C 132       5.504   2.517   4.093  1.00 29.26           N  
ATOM   4900  CA  LEU C 132       5.395   2.066   2.730  1.00 30.28           C  
ATOM   4901  C   LEU C 132       5.676   0.572   2.731  1.00 30.63           C  
ATOM   4902  O   LEU C 132       6.742   0.136   3.136  1.00 29.71           O  
ATOM   4903  CB  LEU C 132       6.365   2.793   1.809  1.00 31.81           C  
ATOM   4904  CG  LEU C 132       6.464   2.266   0.373  1.00 28.93           C  
ATOM   4905  CD1 LEU C 132       5.090   2.200  -0.359  1.00 24.27           C  
ATOM   4906  CD2 LEU C 132       7.435   3.136  -0.341  1.00 31.83           C  
ATOM   4907  N   LEU C 133       4.688  -0.211   2.318  1.00 30.89           N  
ATOM   4908  CA  LEU C 133       4.846  -1.641   2.223  1.00 30.28           C  
ATOM   4909  C   LEU C 133       4.690  -2.094   0.792  1.00 29.50           C  
ATOM   4910  O   LEU C 133       3.734  -1.711   0.103  1.00 29.78           O  
ATOM   4911  CB  LEU C 133       3.822  -2.384   3.078  1.00 31.02           C  
ATOM   4912  CG  LEU C 133       4.002  -2.616   4.571  1.00 31.33           C  
ATOM   4913  CD1 LEU C 133       4.032  -1.312   5.316  1.00 36.99           C  
ATOM   4914  CD2 LEU C 133       2.867  -3.486   5.058  1.00 32.18           C  
ATOM   4915  N   PHE C 134       5.598  -2.958   0.360  1.00 29.93           N  
ATOM   4916  CA  PHE C 134       5.457  -3.577  -0.971  1.00 29.15           C  
ATOM   4917  C   PHE C 134       6.216  -4.880  -1.048  1.00 28.18           C  
ATOM   4918  O   PHE C 134       7.128  -5.125  -0.264  1.00 27.50           O  
ATOM   4919  CB  PHE C 134       5.911  -2.661  -2.098  1.00 31.39           C  
ATOM   4920  CG  PHE C 134       7.370  -2.332  -2.077  1.00 26.98           C  
ATOM   4921  CD1 PHE C 134       8.297  -3.109  -2.790  1.00 23.89           C  
ATOM   4922  CD2 PHE C 134       7.819  -1.207  -1.405  1.00 29.56           C  
ATOM   4923  CE1 PHE C 134       9.662  -2.772  -2.812  1.00 25.22           C  
ATOM   4924  CE2 PHE C 134       9.170  -0.871  -1.421  1.00 30.25           C  
ATOM   4925  CZ  PHE C 134      10.092  -1.657  -2.125  1.00 27.44           C  
ATOM   4926  N   ASP C 135       5.788  -5.727  -1.979  1.00 25.76           N  
ATOM   4927  CA  ASP C 135       6.407  -7.012  -2.236  1.00 27.70           C  
ATOM   4928  C   ASP C 135       6.666  -7.149  -3.721  1.00 27.43           C  
ATOM   4929  O   ASP C 135       5.838  -6.746  -4.535  1.00 30.33           O  
ATOM   4930  CB  ASP C 135       5.553  -8.181  -1.689  1.00 28.93           C  
ATOM   4931  CG  ASP C 135       4.205  -8.298  -2.346  1.00 31.57           C  
ATOM   4932  OD1 ASP C 135       3.278  -7.518  -1.987  1.00 27.53           O  
ATOM   4933  OD2 ASP C 135       4.059  -9.218  -3.184  1.00 34.00           O  
ATOM   4934  N   VAL C 136       7.798  -7.751  -4.054  1.00 26.13           N  
ATOM   4935  CA  VAL C 136       8.260  -7.866  -5.418  1.00 29.12           C  
ATOM   4936  C   VAL C 136       8.844  -9.243  -5.725  1.00 29.15           C  
ATOM   4937  O   VAL C 136       9.200 -10.011  -4.832  1.00 30.49           O  
ATOM   4938  CB  VAL C 136       9.354  -6.792  -5.689  1.00 29.18           C  
ATOM   4939  CG1 VAL C 136       8.733  -5.407  -5.807  1.00 29.00           C  
ATOM   4940  CG2 VAL C 136      10.457  -6.835  -4.589  1.00 26.52           C  
ATOM   4941  N   HIS C 137       8.931  -9.569  -6.999  1.00 29.76           N  
ATOM   4942  CA  HIS C 137       9.595 -10.797  -7.402  1.00 28.62           C  
ATOM   4943  C   HIS C 137      11.072 -10.707  -7.039  1.00 30.83           C  
ATOM   4944  O   HIS C 137      11.665  -9.625  -7.126  1.00 31.10           O  
ATOM   4945  CB  HIS C 137       9.563 -10.986  -8.922  1.00 29.99           C  
ATOM   4946  CG  HIS C 137       8.195 -11.049  -9.504  1.00 25.74           C  
ATOM   4947  ND1 HIS C 137       7.208 -11.847  -8.975  1.00 25.62           N  
ATOM   4948  CD2 HIS C 137       7.659 -10.439 -10.583  1.00 26.92           C  
ATOM   4949  CE1 HIS C 137       6.108 -11.706  -9.692  1.00 22.89           C  
ATOM   4950  NE2 HIS C 137       6.358 -10.862 -10.681  1.00 26.23           N  
ATOM   4951  N   SER C 138      11.652 -11.844  -6.662  1.00 31.87           N  
ATOM   4952  CA  SER C 138      13.089 -11.943  -6.400  1.00 31.37           C  
ATOM   4953  C   SER C 138      13.784 -12.187  -7.740  1.00 31.25           C  
ATOM   4954  O   SER C 138      13.141 -12.648  -8.689  1.00 29.73           O  
ATOM   4955  CB  SER C 138      13.392 -13.116  -5.486  1.00 30.37           C  
ATOM   4956  OG  SER C 138      13.123 -14.326  -6.166  1.00 31.66           O  
ATOM   4957  N   PRO C 139      15.086 -11.844  -7.840  1.00 29.90           N  
ATOM   4958  CA  PRO C 139      15.809 -12.168  -9.079  1.00 27.94           C  
ATOM   4959  C   PRO C 139      15.769 -13.684  -9.359  1.00 27.90           C  
ATOM   4960  O   PRO C 139      15.677 -14.099 -10.511  1.00 28.84           O  
ATOM   4961  CB  PRO C 139      17.229 -11.654  -8.806  1.00 28.09           C  
ATOM   4962  CG  PRO C 139      17.060 -10.590  -7.718  1.00 25.92           C  
ATOM   4963  CD  PRO C 139      15.918 -11.093  -6.879  1.00 31.03           C  
ATOM   4964  N   TYR C 140      15.781 -14.500  -8.306  1.00 29.13           N  
ATOM   4965  CA  TYR C 140      15.701 -15.955  -8.449  1.00 29.63           C  
ATOM   4966  C   TYR C 140      14.451 -16.416  -9.190  1.00 28.99           C  
ATOM   4967  O   TYR C 140      14.501 -17.329 -10.021  1.00 28.37           O  
ATOM   4968  CB  TYR C 140      15.719 -16.623  -7.077  1.00 30.79           C  
ATOM   4969  CG  TYR C 140      15.760 -18.132  -7.167  1.00 38.47           C  
ATOM   4970  CD1 TYR C 140      16.874 -18.776  -7.705  1.00 39.93           C  
ATOM   4971  CD2 TYR C 140      14.699 -18.919  -6.710  1.00 39.41           C  
ATOM   4972  CE1 TYR C 140      16.922 -20.148  -7.803  1.00 38.61           C  
ATOM   4973  CE2 TYR C 140      14.743 -20.298  -6.802  1.00 31.90           C  
ATOM   4974  CZ  TYR C 140      15.857 -20.900  -7.349  1.00 34.18           C  
ATOM   4975  OH  TYR C 140      15.924 -22.254  -7.453  1.00 38.66           O  
ATOM   4976  N   LYS C 141      13.320 -15.809  -8.858  1.00 29.34           N  
ATOM   4977  CA  LYS C 141      12.061 -16.148  -9.508  1.00 31.60           C  
ATOM   4978  C   LYS C 141      12.107 -15.861 -11.023  1.00 30.17           C  
ATOM   4979  O   LYS C 141      11.595 -16.622 -11.853  1.00 30.88           O  
ATOM   4980  CB  LYS C 141      10.908 -15.396  -8.846  1.00 29.13           C  
ATOM   4981  CG  LYS C 141       9.561 -15.691  -9.510  1.00 37.39           C  
ATOM   4982  CD  LYS C 141       8.442 -15.189  -8.674  1.00 38.05           C  
ATOM   4983  CE  LYS C 141       7.103 -15.701  -9.150  1.00 35.43           C  
ATOM   4984  NZ  LYS C 141       6.107 -15.334  -8.123  1.00 34.90           N  
HETATM 4985  N   MSE C 142      12.757 -14.762 -11.363  1.00 32.74           N  
HETATM 4986  CA  MSE C 142      12.885 -14.323 -12.738  0.50 33.33           C  
HETATM 4988  C   MSE C 142      13.696 -15.330 -13.563  1.00 34.51           C  
HETATM 4989  O   MSE C 142      13.347 -15.642 -14.704  1.00 36.92           O  
HETATM 4990  CB  MSE C 142      13.573 -12.958 -12.740  0.50 32.79           C  
HETATM 4992  CG  MSE C 142      13.301 -12.149 -13.944  0.50 32.51           C  
HETATM 4994 SE   MSE C 142      11.439 -11.658 -14.025  0.38 29.58          SE  
HETATM 4996  CE  MSE C 142      11.310 -10.424 -12.565  0.50 41.56           C  
ATOM   4998  N   GLU C 143      14.782 -15.818 -12.961  1.00 36.94           N  
ATOM   4999  CA  GLU C 143      15.699 -16.780 -13.571  1.00 36.77           C  
ATOM   5000  C   GLU C 143      15.160 -18.221 -13.574  1.00 38.18           C  
ATOM   5001  O   GLU C 143      15.692 -19.071 -14.289  1.00 40.48           O  
ATOM   5002  CB  GLU C 143      17.044 -16.772 -12.821  1.00 36.05           C  
ATOM   5003  CG  GLU C 143      17.732 -15.422 -12.753  1.00 39.77           C  
ATOM   5004  N   THR C 144      14.116 -18.498 -12.797  1.00 36.05           N  
ATOM   5005  CA  THR C 144      13.543 -19.837 -12.715  1.00 35.82           C  
ATOM   5006  C   THR C 144      12.094 -19.925 -13.247  1.00 36.53           C  
ATOM   5007  O   THR C 144      11.899 -20.282 -14.409  1.00 40.88           O  
ATOM   5008  CB  THR C 144      13.667 -20.374 -11.269  1.00 34.89           C  
ATOM   5009  OG1 THR C 144      12.995 -19.490 -10.357  1.00 33.24           O  
ATOM   5010  CG2 THR C 144      15.142 -20.455 -10.873  1.00 34.21           C  
ATOM   5011  N   LEU C 145      11.097 -19.552 -12.444  1.00 34.98           N  
ATOM   5012  CA  LEU C 145       9.683 -19.667 -12.834  1.00 36.16           C  
ATOM   5013  C   LEU C 145       9.234 -18.856 -14.047  1.00 35.34           C  
ATOM   5014  O   LEU C 145       8.220 -19.192 -14.666  1.00 36.00           O  
ATOM   5015  CB  LEU C 145       8.770 -19.292 -11.675  1.00 37.90           C  
ATOM   5016  CG  LEU C 145       8.783 -20.218 -10.463  1.00 40.00           C  
ATOM   5017  CD1 LEU C 145       7.874 -19.654  -9.395  1.00 40.13           C  
ATOM   5018  CD2 LEU C 145       8.342 -21.621 -10.867  1.00 40.36           C  
ATOM   5019  N   PHE C 146       9.940 -17.773 -14.358  1.00 34.29           N  
ATOM   5020  CA  PHE C 146       9.594 -16.936 -15.510  1.00 34.58           C  
ATOM   5021  C   PHE C 146      10.627 -17.068 -16.611  1.00 35.74           C  
ATOM   5022  O   PHE C 146      10.669 -16.241 -17.521  1.00 35.48           O  
ATOM   5023  CB  PHE C 146       9.458 -15.458 -15.095  1.00 32.39           C  
ATOM   5024  CG  PHE C 146       8.310 -15.169 -14.149  1.00 33.74           C  
ATOM   5025  CD1 PHE C 146       7.132 -15.909 -14.183  1.00 36.95           C  
ATOM   5026  CD2 PHE C 146       8.368 -14.067 -13.298  1.00 34.36           C  
ATOM   5027  CE1 PHE C 146       6.063 -15.587 -13.358  1.00 34.83           C  
ATOM   5028  CE2 PHE C 146       7.305 -13.738 -12.473  1.00 34.01           C  
ATOM   5029  CZ  PHE C 146       6.146 -14.498 -12.504  1.00 36.51           C  
ATOM   5030  N   ASN C 147      11.437 -18.125 -16.548  1.00 36.71           N  
ATOM   5031  CA  ASN C 147      12.511 -18.316 -17.503  1.00 37.73           C  
ATOM   5032  C   ASN C 147      12.156 -19.352 -18.556  1.00 36.89           C  
ATOM   5033  O   ASN C 147      12.657 -20.472 -18.542  1.00 37.49           O  
ATOM   5034  CB  ASN C 147      13.792 -18.705 -16.769  1.00 36.87           C  
ATOM   5035  CG  ASN C 147      15.016 -18.611 -17.648  1.00 39.07           C  
ATOM   5036  OD1 ASN C 147      14.934 -18.193 -18.808  1.00 42.59           O  
ATOM   5037  ND2 ASN C 147      16.167 -18.992 -17.099  1.00 40.06           N  
ATOM   5038  N   GLY C 148      11.278 -18.960 -19.464  1.00 36.22           N  
ATOM   5039  CA  GLY C 148      10.847 -19.836 -20.542  1.00 36.50           C  
ATOM   5040  C   GLY C 148       9.845 -20.886 -20.113  1.00 36.52           C  
ATOM   5041  O   GLY C 148       9.922 -22.032 -20.560  1.00 37.02           O  
ATOM   5042  N   LYS C 149       8.879 -20.480 -19.288  1.00 36.09           N  
ATOM   5043  CA  LYS C 149       7.865 -21.392 -18.741  1.00 34.93           C  
ATOM   5044  C   LYS C 149       6.466 -21.169 -19.326  1.00 35.29           C  
ATOM   5045  O   LYS C 149       6.115 -20.056 -19.725  1.00 36.27           O  
ATOM   5046  CB  LYS C 149       7.810 -21.238 -17.216  1.00 34.16           C  
ATOM   5047  CG  LYS C 149       9.111 -21.559 -16.518  1.00 32.22           C  
ATOM   5048  CD  LYS C 149       9.584 -22.994 -16.780  1.00 38.33           C  
ATOM   5049  CE  LYS C 149      10.732 -23.391 -15.870  1.00 40.37           C  
ATOM   5050  NZ  LYS C 149      11.954 -22.608 -16.146  1.00 48.51           N  
ATOM   5051  N   THR C 150       5.674 -22.241 -19.379  1.00 34.85           N  
ATOM   5052  CA  THR C 150       4.290 -22.203 -19.894  1.00 34.10           C  
ATOM   5053  C   THR C 150       3.337 -22.565 -18.776  1.00 33.14           C  
ATOM   5054  O   THR C 150       3.577 -23.500 -18.022  1.00 33.67           O  
ATOM   5055  CB  THR C 150       4.079 -23.175 -21.091  1.00 33.72           C  
ATOM   5056  OG1 THR C 150       5.020 -22.849 -22.114  1.00 36.81           O  
ATOM   5057  CG2 THR C 150       2.644 -23.036 -21.694  1.00 33.41           C  
ATOM   5058  N   TYR C 151       2.284 -21.788 -18.639  1.00 32.00           N  
ATOM   5059  CA  TYR C 151       1.280 -22.011 -17.608  1.00 31.67           C  
ATOM   5060  C   TYR C 151      -0.048 -21.997 -18.327  1.00 32.55           C  
ATOM   5061  O   TYR C 151      -0.228 -21.219 -19.247  1.00 32.12           O  
ATOM   5062  CB  TYR C 151       1.337 -20.890 -16.561  1.00 30.77           C  
ATOM   5063  CG  TYR C 151       2.662 -20.846 -15.899  1.00 29.44           C  
ATOM   5064  CD1 TYR C 151       3.011 -21.824 -14.966  1.00 30.36           C  
ATOM   5065  CD2 TYR C 151       3.597 -19.866 -16.208  1.00 30.19           C  
ATOM   5066  CE1 TYR C 151       4.250 -21.831 -14.375  1.00 31.46           C  
ATOM   5067  CE2 TYR C 151       4.851 -19.858 -15.600  1.00 32.48           C  
ATOM   5068  CZ  TYR C 151       5.162 -20.840 -14.673  1.00 32.83           C  
ATOM   5069  OH  TYR C 151       6.390 -20.858 -14.043  1.00 34.09           O  
ATOM   5070  N   ALA C 152      -0.966 -22.867 -17.932  1.00 32.81           N  
ATOM   5071  CA  ALA C 152      -2.241 -22.952 -18.622  1.00 32.29           C  
ATOM   5072  C   ALA C 152      -3.235 -23.693 -17.764  1.00 32.81           C  
ATOM   5073  O   ALA C 152      -2.870 -24.621 -17.046  1.00 35.43           O  
ATOM   5074  CB  ALA C 152      -2.067 -23.686 -19.951  1.00 29.75           C  
ATOM   5075  N   THR C 153      -4.488 -23.266 -17.799  1.00 33.58           N  
ATOM   5076  CA  THR C 153      -5.519 -23.993 -17.096  1.00 34.95           C  
ATOM   5077  C   THR C 153      -6.881 -23.573 -17.580  1.00 34.30           C  
ATOM   5078  O   THR C 153      -7.003 -22.702 -18.451  1.00 35.42           O  
ATOM   5079  CB  THR C 153      -5.381 -23.943 -15.558  1.00 37.00           C  
ATOM   5080  OG1 THR C 153      -6.139 -25.021 -15.002  1.00 47.09           O  
ATOM   5081  CG2 THR C 153      -5.830 -22.615 -14.972  1.00 34.45           C  
ATOM   5082  N   HIS C 154      -7.896 -24.279 -17.102  1.00 33.27           N  
ATOM   5083  CA  HIS C 154      -9.267 -24.008 -17.482  1.00 33.59           C  
ATOM   5084  C   HIS C 154     -10.012 -23.548 -16.252  1.00 35.91           C  
ATOM   5085  O   HIS C 154      -9.865 -24.136 -15.187  1.00 34.59           O  
ATOM   5086  CB  HIS C 154     -10.003 -25.253 -17.989  1.00 32.86           C  
ATOM   5087  CG  HIS C 154      -9.330 -25.962 -19.124  1.00 33.10           C  
ATOM   5088  ND1 HIS C 154      -9.100 -25.367 -20.342  1.00 30.33           N  
ATOM   5089  CD2 HIS C 154      -8.887 -27.234 -19.237  1.00 28.84           C  
ATOM   5090  CE1 HIS C 154      -8.513 -26.234 -21.148  1.00 29.16           C  
ATOM   5091  NE2 HIS C 154      -8.370 -27.373 -20.500  1.00 29.23           N  
ATOM   5092  N   ALA C 155     -10.793 -22.485 -16.403  1.00 38.23           N  
ATOM   5093  CA  ALA C 155     -11.677 -22.003 -15.343  1.00 38.87           C  
ATOM   5094  C   ALA C 155     -13.074 -22.201 -15.905  1.00 37.56           C  
ATOM   5095  O   ALA C 155     -13.227 -22.822 -16.947  1.00 37.31           O  
ATOM   5096  CB  ALA C 155     -11.387 -20.551 -15.009  1.00 39.72           C  
ATOM   5097  N   GLU C 156     -14.102 -21.695 -15.241  1.00 38.38           N  
ATOM   5098  CA  GLU C 156     -15.471 -21.884 -15.742  1.00 38.62           C  
ATOM   5099  C   GLU C 156     -15.801 -20.996 -16.962  1.00 38.62           C  
ATOM   5100  O   GLU C 156     -16.451 -21.433 -17.913  1.00 37.11           O  
ATOM   5101  CB  GLU C 156     -16.483 -21.587 -14.616  1.00 39.64           C  
ATOM   5102  N   GLN C 157     -15.379 -19.736 -16.903  1.00 39.91           N  
ATOM   5103  CA  GLN C 157     -15.700 -18.749 -17.955  1.00 39.63           C  
ATOM   5104  C   GLN C 157     -14.608 -18.632 -19.026  1.00 39.06           C  
ATOM   5105  O   GLN C 157     -14.873 -18.194 -20.153  1.00 38.94           O  
ATOM   5106  CB  GLN C 157     -15.974 -17.369 -17.317  1.00 37.73           C  
ATOM   5107  N   SER C 158     -13.382 -19.011 -18.669  1.00 37.79           N  
ATOM   5108  CA  SER C 158     -12.270 -18.913 -19.592  1.00 37.67           C  
ATOM   5109  C   SER C 158     -11.100 -19.885 -19.314  1.00 37.14           C  
ATOM   5110  O   SER C 158     -10.966 -20.458 -18.220  1.00 36.14           O  
ATOM   5111  CB  SER C 158     -11.744 -17.470 -19.602  1.00 35.78           C  
ATOM   5112  OG  SER C 158     -11.073 -17.123 -18.395  1.00 37.46           O  
ATOM   5113  N   SER C 159     -10.262 -20.046 -20.331  1.00 33.91           N  
ATOM   5114  CA  SER C 159      -9.051 -20.855 -20.230  1.00 33.09           C  
ATOM   5115  C   SER C 159      -7.959 -19.912 -20.644  1.00 32.24           C  
ATOM   5116  O   SER C 159      -8.220 -18.954 -21.370  1.00 32.26           O  
ATOM   5117  CB  SER C 159      -9.096 -22.058 -21.192  1.00 32.98           C  
ATOM   5118  OG  SER C 159     -10.185 -22.920 -20.916  1.00 33.17           O  
ATOM   5119  N   TYR C 160      -6.742 -20.164 -20.200  1.00 32.30           N  
ATOM   5120  CA  TYR C 160      -5.631 -19.341 -20.616  1.00 31.10           C  
ATOM   5121  C   TYR C 160      -4.388 -20.135 -20.853  1.00 29.43           C  
ATOM   5122  O   TYR C 160      -4.220 -21.241 -20.329  1.00 32.76           O  
ATOM   5123  CB  TYR C 160      -5.311 -18.239 -19.582  1.00 32.32           C  
ATOM   5124  CG  TYR C 160      -4.716 -18.774 -18.312  1.00 32.27           C  
ATOM   5125  CD1 TYR C 160      -3.344 -18.957 -18.187  1.00 34.75           C  
ATOM   5126  CD2 TYR C 160      -5.524 -19.129 -17.246  1.00 31.49           C  
ATOM   5127  CE1 TYR C 160      -2.810 -19.479 -17.028  1.00 30.02           C  
ATOM   5128  CE2 TYR C 160      -5.001 -19.635 -16.110  1.00 34.32           C  
ATOM   5129  CZ  TYR C 160      -3.647 -19.806 -16.000  1.00 35.36           C  
ATOM   5130  OH  TYR C 160      -3.135 -20.320 -14.837  1.00 28.85           O  
ATOM   5131  N   ILE C 161      -3.515 -19.533 -21.649  1.00 31.50           N  
ATOM   5132  CA  ILE C 161      -2.194 -20.021 -21.946  1.00 31.30           C  
ATOM   5133  C   ILE C 161      -1.230 -18.873 -21.707  1.00 33.91           C  
ATOM   5134  O   ILE C 161      -1.257 -17.836 -22.414  1.00 35.24           O  
ATOM   5135  CB  ILE C 161      -2.037 -20.513 -23.375  1.00 31.87           C  
ATOM   5136  CG1 ILE C 161      -2.981 -21.702 -23.639  1.00 35.68           C  
ATOM   5137  CG2 ILE C 161      -0.595 -20.934 -23.602  1.00 30.31           C  
ATOM   5138  CD1 ILE C 161      -2.947 -22.262 -25.067  1.00 29.55           C  
ATOM   5139  N   TRP C 162      -0.348 -19.085 -20.735  1.00 33.61           N  
ATOM   5140  CA  TRP C 162       0.615 -18.087 -20.311  1.00 34.05           C  
ATOM   5141  C   TRP C 162       2.086 -18.496 -20.527  1.00 33.30           C  
ATOM   5142  O   TRP C 162       2.554 -19.481 -19.957  1.00 34.37           O  
ATOM   5143  CB  TRP C 162       0.294 -17.770 -18.838  1.00 37.41           C  
ATOM   5144  CG  TRP C 162       1.227 -16.865 -18.135  1.00 40.12           C  
ATOM   5145  CD1 TRP C 162       2.145 -16.021 -18.687  1.00 43.85           C  
ATOM   5146  CD2 TRP C 162       1.243 -16.612 -16.736  1.00 43.05           C  
ATOM   5147  NE1 TRP C 162       2.786 -15.321 -17.712  1.00 42.96           N  
ATOM   5148  CE2 TRP C 162       2.253 -15.657 -16.498  1.00 45.45           C  
ATOM   5149  CE3 TRP C 162       0.537 -17.138 -15.651  1.00 46.41           C  
ATOM   5150  CZ2 TRP C 162       2.576 -15.200 -15.205  1.00 45.33           C  
ATOM   5151  CZ3 TRP C 162       0.856 -16.690 -14.352  1.00 47.14           C  
ATOM   5152  CH2 TRP C 162       1.870 -15.728 -14.150  1.00 45.31           C  
ATOM   5153  N   PHE C 163       2.792 -17.723 -21.360  1.00 30.77           N  
ATOM   5154  CA  PHE C 163       4.214 -17.897 -21.614  1.00 33.52           C  
ATOM   5155  C   PHE C 163       4.959 -16.800 -20.848  1.00 35.29           C  
ATOM   5156  O   PHE C 163       4.639 -15.609 -20.970  1.00 34.28           O  
ATOM   5157  CB  PHE C 163       4.596 -17.789 -23.096  1.00 36.45           C  
ATOM   5158  CG  PHE C 163       3.932 -18.804 -23.987  1.00 41.47           C  
ATOM   5159  CD1 PHE C 163       3.634 -20.093 -23.534  1.00 44.10           C  
ATOM   5160  CD2 PHE C 163       3.689 -18.493 -25.317  1.00 45.18           C  
ATOM   5161  CE1 PHE C 163       3.037 -21.012 -24.369  1.00 44.17           C  
ATOM   5162  CE2 PHE C 163       3.104 -19.410 -26.158  1.00 48.06           C  
ATOM   5163  CZ  PHE C 163       2.778 -20.671 -25.686  1.00 45.36           C  
ATOM   5164  N   ALA C 164       5.913 -17.233 -20.029  1.00 34.15           N  
ATOM   5165  CA  ALA C 164       6.755 -16.359 -19.254  1.00 33.70           C  
ATOM   5166  C   ALA C 164       8.180 -16.531 -19.772  1.00 35.29           C  
ATOM   5167  O   ALA C 164       8.810 -17.578 -19.571  1.00 37.72           O  
ATOM   5168  CB  ALA C 164       6.650 -16.715 -17.774  1.00 30.79           C  
ATOM   5169  N   ASP C 165       8.685 -15.510 -20.451  1.00 35.86           N  
ATOM   5170  CA  ASP C 165      10.052 -15.525 -20.973  1.00 37.38           C  
ATOM   5171  C   ASP C 165      10.784 -14.249 -20.539  1.00 37.72           C  
ATOM   5172  O   ASP C 165      10.157 -13.208 -20.324  1.00 36.98           O  
ATOM   5173  CB  ASP C 165      10.055 -15.635 -22.509  1.00 38.98           C  
ATOM   5174  CG  ASP C 165       9.339 -16.880 -23.018  1.00 42.85           C  
ATOM   5175  OD1 ASP C 165      10.043 -17.844 -23.411  1.00 45.44           O  
ATOM   5176  OD2 ASP C 165       8.081 -16.909 -23.001  1.00 49.61           O  
ATOM   5177  N   PRO C 166      12.116 -14.316 -20.407  1.00 37.31           N  
ATOM   5178  CA  PRO C 166      12.810 -13.085 -20.054  1.00 37.53           C  
ATOM   5179  C   PRO C 166      12.689 -12.026 -21.165  1.00 36.17           C  
ATOM   5180  O   PRO C 166      12.553 -12.376 -22.324  1.00 32.86           O  
ATOM   5181  CB  PRO C 166      14.267 -13.533 -19.857  1.00 38.41           C  
ATOM   5182  CG  PRO C 166      14.383 -14.817 -20.607  1.00 39.90           C  
ATOM   5183  CD  PRO C 166      13.032 -15.458 -20.566  1.00 38.77           C  
ATOM   5184  N   GLY C 167      12.713 -10.753 -20.778  1.00 35.34           N  
ATOM   5185  CA  GLY C 167      12.604  -9.627 -21.702  1.00 34.89           C  
ATOM   5186  C   GLY C 167      13.944  -8.989 -22.012  1.00 34.66           C  
ATOM   5187  O   GLY C 167      14.991  -9.571 -21.753  1.00 35.08           O  
ATOM   5188  N   GLU C 168      13.909  -7.766 -22.524  1.00 35.38           N  
ATOM   5189  CA  GLU C 168      15.125  -7.075 -22.956  1.00 36.86           C  
ATOM   5190  C   GLU C 168      16.087  -6.676 -21.834  1.00 37.15           C  
ATOM   5191  O   GLU C 168      17.297  -6.787 -22.018  1.00 38.12           O  
ATOM   5192  CB  GLU C 168      14.779  -5.852 -23.835  1.00 36.51           C  
ATOM   5193  N   GLU C 169      15.569  -6.212 -20.696  1.00 36.93           N  
ATOM   5194  CA  GLU C 169      16.419  -5.786 -19.580  1.00 36.64           C  
ATOM   5195  C   GLU C 169      16.690  -6.938 -18.615  1.00 35.81           C  
ATOM   5196  O   GLU C 169      15.912  -7.883 -18.548  1.00 34.94           O  
ATOM   5197  CB  GLU C 169      15.798  -4.604 -18.815  1.00 36.63           C  
ATOM   5198  CG  GLU C 169      15.636  -3.322 -19.650  1.00 38.83           C  
ATOM   5199  CD  GLU C 169      16.958  -2.693 -20.087  1.00 44.45           C  
ATOM   5200  OE1 GLU C 169      17.972  -2.805 -19.359  1.00 39.31           O  
ATOM   5201  OE2 GLU C 169      16.975  -2.060 -21.171  1.00 52.15           O  
ATOM   5202  N   PRO C 170      17.830  -6.895 -17.914  1.00 33.74           N  
ATOM   5203  CA  PRO C 170      18.083  -7.941 -16.934  1.00 34.02           C  
ATOM   5204  C   PRO C 170      16.951  -8.036 -15.912  1.00 32.52           C  
ATOM   5205  O   PRO C 170      16.320  -7.039 -15.585  1.00 33.34           O  
ATOM   5206  CB  PRO C 170      19.382  -7.494 -16.251  1.00 34.72           C  
ATOM   5207  CG  PRO C 170      19.675  -6.119 -16.752  1.00 35.54           C  
ATOM   5208  CD  PRO C 170      18.942  -5.936 -18.017  1.00 32.61           C  
ATOM   5209  N   LEU C 171      16.695  -9.237 -15.422  1.00 32.40           N  
ATOM   5210  CA  LEU C 171      15.635  -9.487 -14.449  1.00 30.01           C  
ATOM   5211  C   LEU C 171      14.241  -9.000 -14.902  1.00 29.80           C  
ATOM   5212  O   LEU C 171      13.414  -8.621 -14.091  1.00 27.08           O  
ATOM   5213  CB  LEU C 171      16.014  -8.921 -13.087  1.00 29.77           C  
ATOM   5214  CG  LEU C 171      17.358  -9.436 -12.554  1.00 26.88           C  
ATOM   5215  CD1 LEU C 171      17.710  -8.746 -11.295  1.00 20.66           C  
ATOM   5216  CD2 LEU C 171      17.346 -10.951 -12.369  1.00 31.07           C  
ATOM   5217  N   SER C 172      13.991  -9.033 -16.205  1.00 31.32           N  
ATOM   5218  CA  SER C 172      12.674  -8.674 -16.782  1.00 32.30           C  
ATOM   5219  C   SER C 172      11.964  -9.889 -17.419  1.00 32.79           C  
ATOM   5220  O   SER C 172      12.603 -10.888 -17.786  1.00 30.98           O  
ATOM   5221  CB  SER C 172      12.819  -7.579 -17.844  1.00 30.08           C  
ATOM   5222  OG  SER C 172      13.664  -7.996 -18.884  1.00 32.44           O  
ATOM   5223  N   VAL C 173      10.642  -9.788 -17.554  1.00 30.60           N  
ATOM   5224  CA  VAL C 173       9.847 -10.862 -18.121  1.00 31.16           C  
ATOM   5225  C   VAL C 173       8.758 -10.264 -18.997  1.00 28.90           C  
ATOM   5226  O   VAL C 173       8.226  -9.190 -18.694  1.00 23.94           O  
ATOM   5227  CB  VAL C 173       9.204 -11.771 -17.004  1.00 30.34           C  
ATOM   5228  CG1 VAL C 173       8.332 -10.967 -16.081  1.00 34.15           C  
ATOM   5229  CG2 VAL C 173       8.402 -12.914 -17.597  1.00 27.60           C  
ATOM   5230  N   VAL C 174       8.497 -10.945 -20.109  1.00 32.01           N  
ATOM   5231  CA  VAL C 174       7.411 -10.615 -21.013  1.00 30.29           C  
ATOM   5232  C   VAL C 174       6.395 -11.735 -20.772  1.00 34.21           C  
ATOM   5233  O   VAL C 174       6.694 -12.923 -20.971  1.00 34.47           O  
ATOM   5234  CB  VAL C 174       7.800 -10.644 -22.492  1.00 32.34           C  
ATOM   5235  CG1 VAL C 174       6.568 -10.316 -23.331  1.00 23.68           C  
ATOM   5236  CG2 VAL C 174       8.926  -9.668 -22.790  1.00 24.83           C  
ATOM   5237  N   HIS C 175       5.231 -11.361 -20.253  1.00 33.75           N  
ATOM   5238  CA  HIS C 175       4.174 -12.316 -20.000  1.00 31.93           C  
ATOM   5239  C   HIS C 175       3.267 -12.294 -21.227  1.00 33.25           C  
ATOM   5240  O   HIS C 175       2.441 -11.381 -21.335  1.00 32.29           O  
ATOM   5241  CB  HIS C 175       3.359 -11.899 -18.784  1.00 30.15           C  
ATOM   5242  CG  HIS C 175       4.111 -11.968 -17.489  1.00 29.66           C  
ATOM   5243  ND1 HIS C 175       4.779 -13.103 -17.086  1.00 31.30           N  
ATOM   5244  CD2 HIS C 175       4.240 -11.072 -16.480  1.00 27.37           C  
ATOM   5245  CE1 HIS C 175       5.317 -12.892 -15.894  1.00 35.71           C  
ATOM   5246  NE2 HIS C 175       4.992 -11.672 -15.499  1.00 31.63           N  
ATOM   5247  N   GLU C 176       3.445 -13.253 -22.152  1.00 34.19           N  
ATOM   5248  CA  GLU C 176       2.578 -13.364 -23.356  1.00 33.51           C  
ATOM   5249  C   GLU C 176       1.379 -14.209 -22.925  1.00 35.02           C  
ATOM   5250  O   GLU C 176       1.486 -15.414 -22.665  1.00 35.73           O  
ATOM   5251  CB  GLU C 176       3.284 -14.004 -24.562  1.00 34.30           C  
ATOM   5252  CG  GLU C 176       4.395 -13.171 -25.235  1.00 32.11           C  
ATOM   5253  CD  GLU C 176       3.907 -11.960 -25.999  1.00 43.26           C  
ATOM   5254  OE1 GLU C 176       2.687 -11.677 -26.008  1.00 49.34           O  
ATOM   5255  OE2 GLU C 176       4.765 -11.284 -26.612  1.00 48.36           O  
ATOM   5256  N   LEU C 177       0.233 -13.550 -22.846  1.00 36.16           N  
ATOM   5257  CA  LEU C 177      -0.975 -14.157 -22.330  1.00 35.53           C  
ATOM   5258  C   LEU C 177      -2.024 -14.321 -23.440  1.00 35.30           C  
ATOM   5259  O   LEU C 177      -2.138 -13.482 -24.354  1.00 36.71           O  
ATOM   5260  CB  LEU C 177      -1.508 -13.241 -21.214  1.00 34.56           C  
ATOM   5261  CG  LEU C 177      -1.919 -13.850 -19.866  1.00 41.56           C  
ATOM   5262  CD1 LEU C 177      -0.745 -14.589 -19.249  1.00 37.05           C  
ATOM   5263  CD2 LEU C 177      -2.389 -12.787 -18.892  1.00 37.50           C  
ATOM   5264  N   THR C 178      -2.766 -15.427 -23.385  1.00 36.71           N  
ATOM   5265  CA  THR C 178      -3.901 -15.649 -24.288  1.00 35.38           C  
ATOM   5266  C   THR C 178      -5.047 -16.271 -23.494  1.00 35.31           C  
ATOM   5267  O   THR C 178      -4.855 -17.284 -22.803  1.00 36.28           O  
ATOM   5268  CB  THR C 178      -3.555 -16.544 -25.477  1.00 36.36           C  
ATOM   5269  OG1 THR C 178      -2.503 -15.931 -26.239  1.00 40.82           O  
ATOM   5270  CG2 THR C 178      -4.804 -16.736 -26.370  1.00 35.83           C  
ATOM   5271  N   PHE C 179      -6.216 -15.637 -23.583  1.00 35.07           N  
ATOM   5272  CA  PHE C 179      -7.443 -16.088 -22.936  1.00 34.18           C  
ATOM   5273  C   PHE C 179      -8.475 -16.468 -23.984  1.00 34.46           C  
ATOM   5274  O   PHE C 179      -8.677 -15.727 -24.964  1.00 32.48           O  
ATOM   5275  CB  PHE C 179      -8.063 -14.966 -22.104  1.00 35.91           C  
ATOM   5276  CG  PHE C 179      -7.148 -14.415 -21.049  1.00 39.88           C  
ATOM   5277  CD1 PHE C 179      -6.238 -13.389 -21.352  1.00 44.00           C  
ATOM   5278  CD2 PHE C 179      -7.191 -14.912 -19.763  1.00 41.61           C  
ATOM   5279  CE1 PHE C 179      -5.376 -12.882 -20.376  1.00 45.83           C  
ATOM   5280  CE2 PHE C 179      -6.337 -14.414 -18.780  1.00 42.47           C  
ATOM   5281  CZ  PHE C 179      -5.431 -13.396 -19.091  1.00 40.96           C  
ATOM   5282  N   PHE C 180      -9.128 -17.612 -23.758  1.00 33.01           N  
ATOM   5283  CA  PHE C 180     -10.249 -18.069 -24.562  1.00 32.54           C  
ATOM   5284  C   PHE C 180     -11.458 -17.984 -23.641  1.00 33.68           C  
ATOM   5285  O   PHE C 180     -11.572 -18.759 -22.689  1.00 33.23           O  
ATOM   5286  CB  PHE C 180     -10.038 -19.502 -25.065  1.00 33.10           C  
ATOM   5287  CG  PHE C 180      -8.907 -19.635 -26.051  1.00 27.00           C  
ATOM   5288  CD1 PHE C 180      -9.129 -19.438 -27.394  1.00 25.76           C  
ATOM   5289  CD2 PHE C 180      -7.632 -19.937 -25.632  1.00 28.10           C  
ATOM   5290  CE1 PHE C 180      -8.114 -19.562 -28.301  1.00 28.07           C  
ATOM   5291  CE2 PHE C 180      -6.606 -20.073 -26.552  1.00 31.18           C  
ATOM   5292  CZ  PHE C 180      -6.867 -19.866 -27.895  1.00 30.76           C  
ATOM   5293  N   ILE C 181     -12.348 -17.040 -23.937  1.00 34.94           N  
ATOM   5294  CA  ILE C 181     -13.518 -16.732 -23.094  1.00 35.50           C  
ATOM   5295  C   ILE C 181     -14.796 -17.277 -23.678  1.00 33.09           C  
ATOM   5296  O   ILE C 181     -15.148 -16.917 -24.793  1.00 32.58           O  
ATOM   5297  CB  ILE C 181     -13.673 -15.183 -22.920  1.00 34.79           C  
ATOM   5298  CG1 ILE C 181     -12.397 -14.575 -22.299  1.00 35.28           C  
ATOM   5299  CG2 ILE C 181     -14.889 -14.863 -22.058  1.00 37.23           C  
ATOM   5300  CD1 ILE C 181     -12.363 -13.052 -22.265  1.00 36.51           C  
ATOM   5301  N   GLU C 182     -15.513 -18.118 -22.935  1.00 31.72           N  
ATOM   5302  CA  GLU C 182     -16.754 -18.688 -23.461  1.00 34.40           C  
ATOM   5303  C   GLU C 182     -17.840 -17.649 -23.730  1.00 36.82           C  
ATOM   5304  O   GLU C 182     -18.078 -16.768 -22.919  1.00 37.52           O  
ATOM   5305  CB  GLU C 182     -17.320 -19.771 -22.541  1.00 33.60           C  
ATOM   5306  CG  GLU C 182     -18.380 -20.629 -23.244  1.00 38.35           C  
ATOM   5307  CD  GLU C 182     -18.848 -21.806 -22.419  1.00 37.24           C  
ATOM   5308  OE1 GLU C 182     -18.754 -21.728 -21.183  1.00 47.15           O  
ATOM   5309  OE2 GLU C 182     -19.331 -22.795 -23.008  1.00 44.60           O  
ATOM   5310  N   GLY C 183     -18.516 -17.778 -24.862  1.00 37.44           N  
ATOM   5311  CA  GLY C 183     -19.585 -16.866 -25.236  1.00 39.17           C  
ATOM   5312  C   GLY C 183     -20.938 -17.465 -24.910  1.00 40.57           C  
ATOM   5313  O   GLY C 183     -21.036 -18.640 -24.538  1.00 40.43           O  
ATOM   5314  N   GLU C 184     -21.985 -16.655 -25.062  1.00 42.08           N  
ATOM   5315  CA  GLU C 184     -23.347 -17.092 -24.769  1.00 42.86           C  
ATOM   5316  C   GLU C 184     -23.739 -18.316 -25.584  1.00 44.06           C  
ATOM   5317  O   GLU C 184     -24.511 -19.147 -25.108  1.00 45.51           O  
ATOM   5318  CB  GLU C 184     -24.346 -15.952 -25.003  1.00 43.59           C  
ATOM   5319  N   ASP C 185     -23.186 -18.443 -26.797  1.00 44.94           N  
ATOM   5320  CA  ASP C 185     -23.479 -19.570 -27.697  1.00 44.14           C  
ATOM   5321  C   ASP C 185     -22.495 -20.754 -27.607  1.00 43.42           C  
ATOM   5322  O   ASP C 185     -22.460 -21.600 -28.498  1.00 44.33           O  
ATOM   5323  CB  ASP C 185     -23.565 -19.075 -29.152  1.00 45.34           C  
ATOM   5324  CG  ASP C 185     -22.233 -18.552 -29.695  1.00 46.17           C  
ATOM   5325  OD1 ASP C 185     -21.238 -18.464 -28.940  1.00 43.62           O  
ATOM   5326  OD2 ASP C 185     -22.194 -18.228 -30.899  1.00 50.69           O  
ATOM   5327  N   GLY C 186     -21.685 -20.812 -26.555  1.00 42.71           N  
ATOM   5328  CA  GLY C 186     -20.768 -21.948 -26.377  1.00 41.87           C  
ATOM   5329  C   GLY C 186     -19.476 -21.932 -27.195  1.00 41.07           C  
ATOM   5330  O   GLY C 186     -18.626 -22.813 -27.029  1.00 39.27           O  
ATOM   5331  N   ARG C 187     -19.336 -20.938 -28.075  1.00 39.38           N  
ATOM   5332  CA  ARG C 187     -18.130 -20.736 -28.850  1.00 36.52           C  
ATOM   5333  C   ARG C 187     -17.275 -19.742 -28.064  1.00 35.03           C  
ATOM   5334  O   ARG C 187     -17.772 -19.054 -27.183  1.00 35.21           O  
ATOM   5335  CB  ARG C 187     -18.463 -20.231 -30.250  1.00 35.77           C  
ATOM   5336  CG  ARG C 187     -19.261 -21.228 -31.082  1.00 34.66           C  
ATOM   5337  CD  ARG C 187     -19.387 -20.727 -32.505  1.00 36.13           C  
ATOM   5338  NE  ARG C 187     -18.066 -20.674 -33.128  1.00 39.42           N  
ATOM   5339  CZ  ARG C 187     -17.699 -19.839 -34.097  1.00 38.35           C  
ATOM   5340  NH1 ARG C 187     -18.529 -18.924 -34.566  1.00 36.01           N  
ATOM   5341  NH2 ARG C 187     -16.460 -19.891 -34.569  1.00 40.63           N  
ATOM   5342  N   TYR C 188     -15.992 -19.663 -28.384  1.00 33.98           N  
ATOM   5343  CA  TYR C 188     -15.053 -18.850 -27.629  1.00 31.92           C  
ATOM   5344  C   TYR C 188     -14.482 -17.663 -28.401  1.00 32.60           C  
ATOM   5345  O   TYR C 188     -14.373 -17.683 -29.638  1.00 32.84           O  
ATOM   5346  CB  TYR C 188     -13.897 -19.731 -27.116  1.00 30.58           C  
ATOM   5347  CG  TYR C 188     -14.303 -20.716 -26.037  1.00 29.86           C  
ATOM   5348  CD1 TYR C 188     -15.108 -21.795 -26.331  1.00 27.15           C  
ATOM   5349  CD2 TYR C 188     -13.866 -20.569 -24.724  1.00 31.17           C  
ATOM   5350  CE1 TYR C 188     -15.485 -22.689 -25.354  1.00 27.98           C  
ATOM   5351  CE2 TYR C 188     -14.253 -21.460 -23.731  1.00 31.44           C  
ATOM   5352  CZ  TYR C 188     -15.069 -22.511 -24.060  1.00 30.42           C  
ATOM   5353  OH  TYR C 188     -15.471 -23.429 -23.112  1.00 35.52           O  
ATOM   5354  N   ASP C 189     -14.154 -16.610 -27.644  1.00 34.26           N  
ATOM   5355  CA  ASP C 189     -13.483 -15.423 -28.173  1.00 34.06           C  
ATOM   5356  C   ASP C 189     -12.073 -15.382 -27.604  1.00 31.66           C  
ATOM   5357  O   ASP C 189     -11.856 -15.654 -26.429  1.00 32.56           O  
ATOM   5358  CB  ASP C 189     -14.268 -14.161 -27.876  1.00 34.70           C  
ATOM   5359  CG  ASP C 189     -15.586 -14.139 -28.600  1.00 43.64           C  
ATOM   5360  OD1 ASP C 189     -15.667 -13.486 -29.695  1.00 32.91           O  
ATOM   5361  OD2 ASP C 189     -16.522 -14.843 -28.130  1.00 47.67           O  
ATOM   5362  N   ARG C 190     -11.103 -15.113 -28.465  1.00 31.15           N  
ATOM   5363  CA  ARG C 190      -9.701 -15.054 -28.063  1.00 32.13           C  
ATOM   5364  C   ARG C 190      -9.210 -13.609 -27.795  1.00 32.57           C  
ATOM   5365  O   ARG C 190      -9.477 -12.707 -28.577  1.00 32.83           O  
ATOM   5366  CB  ARG C 190      -8.833 -15.679 -29.150  1.00 29.91           C  
ATOM   5367  CG  ARG C 190      -7.352 -15.700 -28.806  1.00 30.58           C  
ATOM   5368  CD  ARG C 190      -6.574 -16.378 -29.886  1.00 32.38           C  
ATOM   5369  NE  ARG C 190      -5.155 -16.317 -29.605  1.00 29.62           N  
ATOM   5370  CZ  ARG C 190      -4.227 -17.042 -30.220  1.00 39.30           C  
ATOM   5371  NH1 ARG C 190      -4.550 -17.942 -31.145  1.00 37.94           N  
ATOM   5372  NH2 ARG C 190      -2.953 -16.901 -29.868  1.00 41.04           N  
ATOM   5373  N   VAL C 191      -8.486 -13.425 -26.690  1.00 34.03           N  
ATOM   5374  CA  VAL C 191      -7.875 -12.132 -26.322  1.00 34.36           C  
ATOM   5375  C   VAL C 191      -6.390 -12.373 -25.997  1.00 33.96           C  
ATOM   5376  O   VAL C 191      -6.072 -13.225 -25.175  1.00 33.79           O  
ATOM   5377  CB  VAL C 191      -8.552 -11.471 -25.114  1.00 35.50           C  
ATOM   5378  CG1 VAL C 191      -7.939 -10.098 -24.880  1.00 39.15           C  
ATOM   5379  CG2 VAL C 191     -10.053 -11.331 -25.325  1.00 31.91           C  
ATOM   5380  N   ASP C 192      -5.495 -11.672 -26.692  1.00 32.95           N  
ATOM   5381  CA  ASP C 192      -4.048 -11.826 -26.500  1.00 34.94           C  
ATOM   5382  C   ASP C 192      -3.502 -10.550 -25.900  1.00 35.62           C  
ATOM   5383  O   ASP C 192      -3.761  -9.465 -26.416  1.00 32.51           O  
ATOM   5384  CB  ASP C 192      -3.320 -12.040 -27.824  1.00 36.93           C  
ATOM   5385  CG  ASP C 192      -3.813 -13.245 -28.579  1.00 39.97           C  
ATOM   5386  OD1 ASP C 192      -3.986 -14.303 -27.938  1.00 44.80           O  
ATOM   5387  OD2 ASP C 192      -3.991 -13.119 -29.809  1.00 41.91           O  
ATOM   5388  N   GLU C 193      -2.722 -10.707 -24.842  1.00 34.87           N  
ATOM   5389  CA  GLU C 193      -2.129  -9.607 -24.114  1.00 37.26           C  
ATOM   5390  C   GLU C 193      -0.659  -9.854 -23.764  1.00 36.01           C  
ATOM   5391  O   GLU C 193      -0.214 -11.000 -23.666  1.00 36.43           O  
ATOM   5392  CB  GLU C 193      -2.868  -9.409 -22.804  1.00 38.79           C  
ATOM   5393  CG  GLU C 193      -4.184  -8.744 -22.945  1.00 40.33           C  
ATOM   5394  CD  GLU C 193      -4.666  -8.189 -21.632  1.00 45.03           C  
ATOM   5395  OE1 GLU C 193      -4.151  -8.631 -20.573  1.00 47.48           O  
ATOM   5396  OE2 GLU C 193      -5.561  -7.322 -21.654  1.00 50.80           O  
ATOM   5397  N   THR C 194       0.069  -8.760 -23.561  1.00 32.35           N  
ATOM   5398  CA  THR C 194       1.460  -8.837 -23.201  1.00 32.19           C  
ATOM   5399  C   THR C 194       1.671  -7.871 -22.060  1.00 31.27           C  
ATOM   5400  O   THR C 194       1.401  -6.685 -22.187  1.00 30.17           O  
ATOM   5401  CB  THR C 194       2.376  -8.499 -24.380  1.00 33.37           C  
ATOM   5402  OG1 THR C 194       1.955  -9.248 -25.530  1.00 38.96           O  
ATOM   5403  CG2 THR C 194       3.845  -8.831 -24.053  1.00 29.90           C  
ATOM   5404  N   HIS C 195       2.130  -8.413 -20.941  1.00 31.93           N  
ATOM   5405  CA  HIS C 195       2.419  -7.661 -19.738  1.00 33.04           C  
ATOM   5406  C   HIS C 195       3.913  -7.742 -19.545  1.00 31.01           C  
ATOM   5407  O   HIS C 195       4.543  -8.723 -19.924  1.00 30.46           O  
ATOM   5408  CB  HIS C 195       1.692  -8.264 -18.519  1.00 33.87           C  
ATOM   5409  CG  HIS C 195       0.206  -8.297 -18.673  1.00 38.47           C  
ATOM   5410  ND1 HIS C 195      -0.589  -7.197 -18.446  1.00 46.78           N  
ATOM   5411  CD2 HIS C 195      -0.626  -9.280 -19.087  1.00 47.41           C  
ATOM   5412  CE1 HIS C 195      -1.847  -7.502 -18.701  1.00 41.66           C  
ATOM   5413  NE2 HIS C 195      -1.897  -8.759 -19.093  1.00 41.22           N  
ATOM   5414  N   HIS C 196       4.467  -6.689 -18.966  1.00 30.90           N  
ATOM   5415  CA  HIS C 196       5.890  -6.586 -18.728  1.00 28.46           C  
ATOM   5416  C   HIS C 196       6.126  -6.309 -17.280  1.00 26.99           C  
ATOM   5417  O   HIS C 196       5.518  -5.398 -16.726  1.00 25.44           O  
ATOM   5418  CB  HIS C 196       6.479  -5.448 -19.568  1.00 29.46           C  
ATOM   5419  CG  HIS C 196       6.394  -5.699 -21.036  1.00 27.98           C  
ATOM   5420  ND1 HIS C 196       7.287  -6.511 -21.695  1.00 29.57           N  
ATOM   5421  CD2 HIS C 196       5.497  -5.289 -21.962  1.00 31.41           C  
ATOM   5422  CE1 HIS C 196       6.951  -6.583 -22.972  1.00 31.68           C  
ATOM   5423  NE2 HIS C 196       5.868  -5.853 -23.160  1.00 31.17           N  
ATOM   5424  N   GLN C 197       6.983  -7.129 -16.670  1.00 24.55           N  
ATOM   5425  CA  GLN C 197       7.415  -6.944 -15.315  1.00 25.42           C  
ATOM   5426  C   GLN C 197       8.941  -6.981 -15.290  1.00 27.11           C  
ATOM   5427  O   GLN C 197       9.578  -7.621 -16.133  1.00 25.04           O  
ATOM   5428  CB  GLN C 197       6.861  -8.027 -14.352  1.00 24.49           C  
ATOM   5429  CG  GLN C 197       5.371  -7.862 -14.016  1.00 22.44           C  
ATOM   5430  CD  GLN C 197       4.958  -8.766 -12.886  1.00 21.19           C  
ATOM   5431  OE1 GLN C 197       5.241  -9.950 -12.924  1.00 25.85           O  
ATOM   5432  NE2 GLN C 197       4.279  -8.211 -11.873  1.00 17.62           N  
ATOM   5433  N   ARG C 198       9.504  -6.299 -14.300  1.00 27.33           N  
ATOM   5434  CA  ARG C 198      10.942  -6.174 -14.127  1.00 26.49           C  
ATOM   5435  C   ARG C 198      11.243  -5.985 -12.648  1.00 24.97           C  
ATOM   5436  O   ARG C 198      10.586  -5.208 -11.974  1.00 24.38           O  
ATOM   5437  CB  ARG C 198      11.462  -4.988 -14.955  1.00 26.97           C  
ATOM   5438  CG  ARG C 198      12.911  -4.644 -14.705  1.00 25.11           C  
ATOM   5439  CD  ARG C 198      13.373  -3.523 -15.623  1.00 26.13           C  
ATOM   5440  NE  ARG C 198      14.789  -3.283 -15.415  1.00 28.32           N  
ATOM   5441  CZ  ARG C 198      15.495  -2.326 -15.999  1.00 28.73           C  
ATOM   5442  NH1 ARG C 198      14.928  -1.472 -16.845  1.00 29.54           N  
ATOM   5443  NH2 ARG C 198      16.781  -2.223 -15.709  1.00 27.75           N  
ATOM   5444  N   THR C 199      12.244  -6.697 -12.160  1.00 22.38           N  
ATOM   5445  CA  THR C 199      12.625  -6.592 -10.762  1.00 24.83           C  
ATOM   5446  C   THR C 199      14.103  -6.229 -10.702  1.00 24.73           C  
ATOM   5447  O   THR C 199      14.744  -5.998 -11.749  1.00 26.40           O  
ATOM   5448  CB  THR C 199      12.233  -7.854  -9.982  1.00 21.82           C  
ATOM   5449  OG1 THR C 199      12.227  -7.560  -8.587  1.00 17.07           O  
ATOM   5450  CG2 THR C 199      13.161  -9.053 -10.251  1.00 25.50           C  
ATOM   5451  N   TYR C 200      14.590  -6.058  -9.488  1.00 27.23           N  
ATOM   5452  CA  TYR C 200      15.979  -5.690  -9.203  1.00 25.73           C  
ATOM   5453  C   TYR C 200      16.421  -6.438  -7.964  1.00 25.64           C  
ATOM   5454  O   TYR C 200      15.583  -6.947  -7.211  1.00 26.63           O  
ATOM   5455  CB  TYR C 200      16.091  -4.185  -8.969  1.00 22.71           C  
ATOM   5456  CG  TYR C 200      15.651  -3.338 -10.139  1.00 24.00           C  
ATOM   5457  CD1 TYR C 200      14.297  -3.054 -10.340  1.00 20.42           C  
ATOM   5458  CD2 TYR C 200      16.583  -2.795 -11.040  1.00 19.29           C  
ATOM   5459  CE1 TYR C 200      13.875  -2.274 -11.402  1.00 21.16           C  
ATOM   5460  CE2 TYR C 200      16.171  -2.010 -12.103  1.00 18.86           C  
ATOM   5461  CZ  TYR C 200      14.808  -1.754 -12.288  1.00 17.85           C  
ATOM   5462  OH  TYR C 200      14.359  -0.984 -13.345  1.00 23.67           O  
ATOM   5463  N   PRO C 201      17.748  -6.543  -7.738  1.00 28.90           N  
ATOM   5464  CA  PRO C 201      18.167  -7.167  -6.495  1.00 29.09           C  
ATOM   5465  C   PRO C 201      17.639  -6.311  -5.335  1.00 29.39           C  
ATOM   5466  O   PRO C 201      17.531  -5.091  -5.482  1.00 27.68           O  
ATOM   5467  CB  PRO C 201      19.698  -7.116  -6.560  1.00 29.59           C  
ATOM   5468  CG  PRO C 201      20.024  -6.921  -7.992  1.00 31.67           C  
ATOM   5469  CD  PRO C 201      18.896  -6.134  -8.564  1.00 30.96           C  
ATOM   5470  N   PRO C 202      17.323  -6.926  -4.186  1.00 29.34           N  
ATOM   5471  CA  PRO C 202      16.787  -6.123  -3.078  1.00 28.88           C  
ATOM   5472  C   PRO C 202      17.620  -4.894  -2.691  1.00 28.54           C  
ATOM   5473  O   PRO C 202      17.046  -3.869  -2.332  1.00 28.11           O  
ATOM   5474  CB  PRO C 202      16.692  -7.120  -1.920  1.00 28.81           C  
ATOM   5475  CG  PRO C 202      16.779  -8.420  -2.512  1.00 30.56           C  
ATOM   5476  CD  PRO C 202      17.421  -8.348  -3.837  1.00 28.20           C  
ATOM   5477  N   GLU C 203      18.947  -5.000  -2.788  1.00 28.42           N  
ATOM   5478  CA  GLU C 203      19.864  -3.906  -2.479  1.00 29.18           C  
ATOM   5479  C   GLU C 203      19.542  -2.653  -3.299  1.00 28.16           C  
ATOM   5480  O   GLU C 203      19.643  -1.544  -2.797  1.00 26.14           O  
ATOM   5481  CB  GLU C 203      21.335  -4.319  -2.721  1.00 31.39           C  
ATOM   5482  CG  GLU C 203      21.813  -5.550  -1.919  1.00 40.38           C  
ATOM   5483  CD  GLU C 203      21.064  -6.861  -2.270  1.00 49.46           C  
ATOM   5484  OE1 GLU C 203      20.869  -7.165  -3.471  1.00 35.30           O  
ATOM   5485  OE2 GLU C 203      20.683  -7.599  -1.328  1.00 59.58           O  
ATOM   5486  N   GLN C 204      19.147  -2.827  -4.556  1.00 28.50           N  
ATOM   5487  CA  GLN C 204      18.807  -1.687  -5.409  1.00 29.40           C  
ATOM   5488  C   GLN C 204      17.562  -0.949  -4.910  1.00 29.01           C  
ATOM   5489  O   GLN C 204      17.533   0.288  -4.843  1.00 27.78           O  
ATOM   5490  CB  GLN C 204      18.580  -2.149  -6.832  1.00 31.39           C  
ATOM   5491  CG  GLN C 204      18.329  -1.019  -7.826  1.00 36.77           C  
ATOM   5492  CD  GLN C 204      19.444   0.025  -7.840  1.00 36.78           C  
ATOM   5493  OE1 GLN C 204      20.333  -0.042  -8.674  1.00 39.37           O  
ATOM   5494  NE2 GLN C 204      19.410   0.974  -6.896  1.00 36.95           N  
ATOM   5495  N   TYR C 205      16.537  -1.711  -4.557  1.00 28.31           N  
ATOM   5496  CA  TYR C 205      15.309  -1.138  -4.009  1.00 28.49           C  
ATOM   5497  C   TYR C 205      15.606  -0.428  -2.701  1.00 26.88           C  
ATOM   5498  O   TYR C 205      15.050   0.642  -2.434  1.00 28.28           O  
ATOM   5499  CB  TYR C 205      14.248  -2.215  -3.774  1.00 30.54           C  
ATOM   5500  CG  TYR C 205      13.524  -2.701  -5.017  1.00 29.63           C  
ATOM   5501  CD1 TYR C 205      12.669  -1.838  -5.717  1.00 31.13           C  
ATOM   5502  CD2 TYR C 205      13.639  -4.037  -5.463  1.00 31.00           C  
ATOM   5503  CE1 TYR C 205      11.968  -2.265  -6.839  1.00 29.32           C  
ATOM   5504  CE2 TYR C 205      12.924  -4.484  -6.586  1.00 33.94           C  
ATOM   5505  CZ  TYR C 205      12.095  -3.589  -7.271  1.00 31.70           C  
ATOM   5506  OH  TYR C 205      11.381  -3.976  -8.381  1.00 29.12           O  
ATOM   5507  N   ILE C 206      16.482  -1.025  -1.890  1.00 27.61           N  
ATOM   5508  CA  ILE C 206      16.887  -0.429  -0.602  1.00 26.71           C  
ATOM   5509  C   ILE C 206      17.521   0.963  -0.826  1.00 26.44           C  
ATOM   5510  O   ILE C 206      17.156   1.933  -0.167  1.00 24.54           O  
ATOM   5511  CB  ILE C 206      17.840  -1.360   0.218  1.00 27.66           C  
ATOM   5512  CG1 ILE C 206      17.089  -2.627   0.672  1.00 28.85           C  
ATOM   5513  CG2 ILE C 206      18.402  -0.593   1.405  1.00 27.89           C  
ATOM   5514  CD1 ILE C 206      17.950  -3.686   1.390  1.00 26.10           C  
ATOM   5515  N   THR C 207      18.408   1.063  -1.807  1.00 27.94           N  
ATOM   5516  CA  THR C 207      19.056   2.331  -2.133  1.00 28.94           C  
ATOM   5517  C   THR C 207      18.056   3.383  -2.539  1.00 27.13           C  
ATOM   5518  O   THR C 207      18.061   4.468  -1.983  1.00 26.99           O  
ATOM   5519  CB  THR C 207      20.102   2.144  -3.230  1.00 32.10           C  
ATOM   5520  OG1 THR C 207      21.138   1.306  -2.709  1.00 30.08           O  
ATOM   5521  CG2 THR C 207      20.705   3.502  -3.673  1.00 29.84           C  
ATOM   5522  N   TRP C 208      17.179   3.046  -3.479  1.00 29.31           N  
ATOM   5523  CA  TRP C 208      16.154   3.978  -3.962  1.00 26.91           C  
ATOM   5524  C   TRP C 208      15.226   4.447  -2.856  1.00 26.71           C  
ATOM   5525  O   TRP C 208      14.815   5.600  -2.858  1.00 28.88           O  
ATOM   5526  CB  TRP C 208      15.345   3.386  -5.112  1.00 27.38           C  
ATOM   5527  CG  TRP C 208      16.108   3.138  -6.384  1.00 26.75           C  
ATOM   5528  CD1 TRP C 208      17.151   3.876  -6.882  1.00 31.21           C  
ATOM   5529  CD2 TRP C 208      15.807   2.150  -7.383  1.00 32.17           C  
ATOM   5530  NE1 TRP C 208      17.548   3.371  -8.108  1.00 26.23           N  
ATOM   5531  CE2 TRP C 208      16.732   2.322  -8.438  1.00 31.30           C  
ATOM   5532  CE3 TRP C 208      14.847   1.132  -7.487  1.00 33.26           C  
ATOM   5533  CZ2 TRP C 208      16.733   1.503  -9.568  1.00 28.41           C  
ATOM   5534  CZ3 TRP C 208      14.856   0.314  -8.613  1.00 31.65           C  
ATOM   5535  CH2 TRP C 208      15.792   0.511  -9.638  1.00 28.02           C  
ATOM   5536  N   LEU C 209      14.914   3.567  -1.909  1.00 23.78           N  
ATOM   5537  CA  LEU C 209      14.064   3.914  -0.790  1.00 24.91           C  
ATOM   5538  C   LEU C 209      14.731   4.938   0.119  1.00 26.91           C  
ATOM   5539  O   LEU C 209      14.071   5.877   0.601  1.00 29.44           O  
ATOM   5540  CB  LEU C 209      13.701   2.669   0.026  1.00 23.73           C  
ATOM   5541  CG  LEU C 209      12.591   1.820  -0.579  1.00 24.85           C  
ATOM   5542  CD1 LEU C 209      12.496   0.456   0.120  1.00 22.18           C  
ATOM   5543  CD2 LEU C 209      11.266   2.578  -0.528  1.00 27.20           C  
ATOM   5544  N   ARG C 210      16.028   4.743   0.340  1.00 24.93           N  
ATOM   5545  CA  ARG C 210      16.813   5.625   1.152  1.00 26.37           C  
ATOM   5546  C   ARG C 210      16.936   6.946   0.460  1.00 27.59           C  
ATOM   5547  O   ARG C 210      16.773   7.997   1.103  1.00 28.02           O  
ATOM   5548  CB  ARG C 210      18.180   5.028   1.444  1.00 27.20           C  
ATOM   5549  CG  ARG C 210      18.112   3.829   2.384  1.00 24.96           C  
ATOM   5550  CD  ARG C 210      19.468   3.173   2.603  1.00 28.23           C  
ATOM   5551  NE  ARG C 210      19.349   2.038   3.527  1.00 28.79           N  
ATOM   5552  CZ  ARG C 210      20.189   1.011   3.587  1.00 27.20           C  
ATOM   5553  NH1 ARG C 210      21.243   0.951   2.768  1.00 26.22           N  
ATOM   5554  NH2 ARG C 210      19.971   0.030   4.472  1.00 22.03           N  
ATOM   5555  N   GLU C 211      17.187   6.899  -0.849  1.00 28.44           N  
ATOM   5556  CA  GLU C 211      17.292   8.121  -1.649  1.00 29.22           C  
ATOM   5557  C   GLU C 211      15.972   8.907  -1.626  1.00 29.24           C  
ATOM   5558  O   GLU C 211      15.997  10.134  -1.670  1.00 31.15           O  
ATOM   5559  CB  GLU C 211      17.751   7.804  -3.074  1.00 28.82           C  
ATOM   5560  CG  GLU C 211      19.240   7.375  -3.209  1.00 29.74           C  
ATOM   5561  CD  GLU C 211      19.563   6.825  -4.622  1.00 33.17           C  
ATOM   5562  OE1 GLU C 211      18.640   6.819  -5.487  1.00 34.16           O  
ATOM   5563  OE2 GLU C 211      20.724   6.403  -4.867  1.00 36.28           O  
ATOM   5564  N   ALA C 212      14.835   8.214  -1.524  1.00 30.24           N  
ATOM   5565  CA  ALA C 212      13.506   8.853  -1.407  1.00 28.62           C  
ATOM   5566  C   ALA C 212      13.185   9.388  -0.002  1.00 28.93           C  
ATOM   5567  O   ALA C 212      12.142   9.989   0.190  1.00 29.05           O  
ATOM   5568  CB  ALA C 212      12.403   7.870  -1.817  1.00 27.49           C  
ATOM   5569  N   GLY C 213      14.054   9.153   0.981  1.00 27.58           N  
ATOM   5570  CA  GLY C 213      13.800   9.597   2.357  1.00 28.42           C  
ATOM   5571  C   GLY C 213      13.096   8.597   3.274  1.00 27.81           C  
ATOM   5572  O   GLY C 213      12.445   8.988   4.239  1.00 27.95           O  
ATOM   5573  N   PHE C 214      13.192   7.308   2.957  1.00 27.67           N  
ATOM   5574  CA  PHE C 214      12.654   6.246   3.826  1.00 27.90           C  
ATOM   5575  C   PHE C 214      13.750   5.523   4.586  1.00 28.74           C  
ATOM   5576  O   PHE C 214      14.865   5.360   4.080  1.00 26.98           O  
ATOM   5577  CB  PHE C 214      11.979   5.150   3.018  1.00 24.40           C  
ATOM   5578  CG  PHE C 214      10.709   5.574   2.388  1.00 23.85           C  
ATOM   5579  CD1 PHE C 214       9.527   5.479   3.084  1.00 26.04           C  
ATOM   5580  CD2 PHE C 214      10.698   6.083   1.089  1.00 26.71           C  
ATOM   5581  CE1 PHE C 214       8.359   5.861   2.521  1.00 26.65           C  
ATOM   5582  CE2 PHE C 214       9.520   6.473   0.529  1.00 26.47           C  
ATOM   5583  CZ  PHE C 214       8.358   6.348   1.239  1.00 22.96           C  
ATOM   5584  N   ARG C 215      13.416   5.084   5.798  1.00 30.51           N  
ATOM   5585  CA  ARG C 215      14.279   4.193   6.544  1.00 27.95           C  
ATOM   5586  C   ARG C 215      13.708   2.816   6.234  1.00 28.56           C  
ATOM   5587  O   ARG C 215      12.505   2.603   6.392  1.00 28.62           O  
ATOM   5588  CB  ARG C 215      14.255   4.456   8.035  1.00 30.04           C  
ATOM   5589  CG  ARG C 215      15.101   3.472   8.818  1.00 27.45           C  
ATOM   5590  CD  ARG C 215      15.169   3.808  10.273  1.00 31.07           C  
ATOM   5591  NE  ARG C 215      13.852   3.866  10.862  1.00 33.65           N  
ATOM   5592  CZ  ARG C 215      13.197   2.838  11.390  1.00 39.75           C  
ATOM   5593  NH1 ARG C 215      13.736   1.624  11.431  1.00 40.35           N  
ATOM   5594  NH2 ARG C 215      11.985   3.037  11.884  1.00 41.48           N  
ATOM   5595  N   VAL C 216      14.554   1.913   5.750  1.00 27.98           N  
ATOM   5596  CA  VAL C 216      14.147   0.547   5.413  1.00 28.23           C  
ATOM   5597  C   VAL C 216      14.113  -0.252   6.719  1.00 28.18           C  
ATOM   5598  O   VAL C 216      15.140  -0.460   7.385  1.00 26.46           O  
ATOM   5599  CB  VAL C 216      15.090  -0.068   4.342  1.00 30.19           C  
ATOM   5600  CG1 VAL C 216      14.639  -1.481   3.935  1.00 27.70           C  
ATOM   5601  CG2 VAL C 216      15.136   0.842   3.120  1.00 26.96           C  
ATOM   5602  N   CYS C 217      12.916  -0.680   7.099  1.00 29.18           N  
ATOM   5603  CA  CYS C 217      12.716  -1.375   8.369  1.00 31.33           C  
ATOM   5604  C   CYS C 217      12.993  -2.862   8.329  1.00 31.31           C  
ATOM   5605  O   CYS C 217      13.660  -3.400   9.228  1.00 32.77           O  
ATOM   5606  CB  CYS C 217      11.290  -1.163   8.865  1.00 32.30           C  
ATOM   5607  SG  CYS C 217      10.851   0.550   9.012  1.00 40.20           S  
ATOM   5608  N   ALA C 218      12.499  -3.518   7.291  1.00 28.30           N  
ATOM   5609  CA  ALA C 218      12.616  -4.949   7.170  1.00 29.42           C  
ATOM   5610  C   ALA C 218      12.571  -5.345   5.710  1.00 29.31           C  
ATOM   5611  O   ALA C 218      11.872  -4.729   4.932  1.00 27.45           O  
ATOM   5612  CB  ALA C 218      11.455  -5.629   7.957  1.00 31.12           C  
ATOM   5613  N   VAL C 219      13.374  -6.333   5.336  1.00 30.03           N  
ATOM   5614  CA  VAL C 219      13.376  -6.910   3.976  1.00 29.89           C  
ATOM   5615  C   VAL C 219      13.367  -8.393   4.259  1.00 28.77           C  
ATOM   5616  O   VAL C 219      14.302  -8.914   4.821  1.00 29.51           O  
ATOM   5617  CB  VAL C 219      14.606  -6.514   3.167  1.00 29.77           C  
ATOM   5618  CG1 VAL C 219      14.586  -7.182   1.786  1.00 31.91           C  
ATOM   5619  CG2 VAL C 219      14.664  -4.977   3.058  1.00 30.32           C  
ATOM   5620  N   THR C 220      12.269  -9.042   3.929  1.00 30.52           N  
ATOM   5621  CA  THR C 220      12.060 -10.437   4.243  1.00 29.62           C  
ATOM   5622  C   THR C 220      11.608 -11.204   2.997  1.00 29.01           C  
ATOM   5623  O   THR C 220      11.297 -10.613   1.953  1.00 28.55           O  
ATOM   5624  CB  THR C 220      11.020 -10.572   5.367  1.00 28.36           C  
ATOM   5625  OG1 THR C 220       9.778 -10.010   4.939  1.00 30.21           O  
ATOM   5626  CG2 THR C 220      11.474  -9.844   6.606  1.00 29.04           C  
ATOM   5627  N   GLY C 221      11.639 -12.529   3.094  1.00 29.55           N  
ATOM   5628  CA  GLY C 221      11.306 -13.393   1.966  1.00 29.14           C  
ATOM   5629  C   GLY C 221      10.148 -14.340   2.233  1.00 30.94           C  
ATOM   5630  O   GLY C 221      10.023 -14.894   3.324  1.00 31.76           O  
ATOM   5631  N   ASP C 222       9.305 -14.497   1.230  1.00 31.53           N  
ATOM   5632  CA  ASP C 222       8.221 -15.490   1.165  1.00 33.28           C  
ATOM   5633  C   ASP C 222       7.312 -15.603   2.360  1.00 33.85           C  
ATOM   5634  O   ASP C 222       7.011 -16.697   2.814  1.00 33.87           O  
ATOM   5635  CB  ASP C 222       8.817 -16.862   0.805  1.00 33.37           C  
ATOM   5636  CG  ASP C 222       9.511 -16.847  -0.549  1.00 36.23           C  
ATOM   5637  OD1 ASP C 222       9.078 -16.071  -1.401  1.00 34.82           O  
ATOM   5638  OD2 ASP C 222      10.478 -17.597  -0.770  1.00 38.67           O  
ATOM   5639  N   PHE C 223       6.880 -14.457   2.855  1.00 35.24           N  
ATOM   5640  CA  PHE C 223       5.967 -14.375   4.005  1.00 36.84           C  
ATOM   5641  C   PHE C 223       6.592 -14.786   5.343  1.00 37.49           C  
ATOM   5642  O   PHE C 223       5.870 -14.912   6.310  1.00 40.63           O  
ATOM   5643  CB  PHE C 223       4.663 -15.148   3.760  1.00 36.01           C  
ATOM   5644  CG  PHE C 223       3.880 -14.677   2.573  1.00 34.53           C  
ATOM   5645  CD1 PHE C 223       2.955 -13.653   2.700  1.00 34.23           C  
ATOM   5646  CD2 PHE C 223       4.030 -15.289   1.338  1.00 34.66           C  
ATOM   5647  CE1 PHE C 223       2.218 -13.215   1.600  1.00 31.45           C  
ATOM   5648  CE2 PHE C 223       3.297 -14.862   0.227  1.00 33.02           C  
ATOM   5649  CZ  PHE C 223       2.379 -13.840   0.356  1.00 30.04           C  
ATOM   5650  N   LYS C 224       7.921 -14.955   5.393  1.00 38.01           N  
ATOM   5651  CA  LYS C 224       8.646 -15.299   6.615  1.00 39.16           C  
ATOM   5652  C   LYS C 224       9.204 -14.013   7.251  1.00 39.18           C  
ATOM   5653  O   LYS C 224       9.203 -12.955   6.633  1.00 36.12           O  
ATOM   5654  CB  LYS C 224       9.789 -16.273   6.306  1.00 40.50           C  
ATOM   5655  CG  LYS C 224       9.369 -17.522   5.535  1.00 43.36           C  
ATOM   5656  N   SER C 225       9.735 -14.149   8.462  1.00 39.29           N  
ATOM   5657  CA  SER C 225      10.255 -13.036   9.269  1.00 39.43           C  
ATOM   5658  C   SER C 225      11.691 -12.687   9.042  1.00 37.38           C  
ATOM   5659  O   SER C 225      12.161 -11.688   9.572  1.00 37.29           O  
ATOM   5660  CB  SER C 225      10.164 -13.387  10.770  1.00 39.16           C  
ATOM   5661  OG  SER C 225       8.823 -13.341  11.221  1.00 53.02           O  
ATOM   5662  N   ASP C 226      12.380 -13.500   8.255  1.00 36.59           N  
ATOM   5663  CA  ASP C 226      13.807 -13.377   8.088  1.00 38.35           C  
ATOM   5664  C   ASP C 226      14.194 -12.822   6.739  1.00 37.37           C  
ATOM   5665  O   ASP C 226      13.364 -12.766   5.817  1.00 34.86           O  
ATOM   5666  CB  ASP C 226      14.385 -14.777   8.305  1.00 42.46           C  
ATOM   5667  CG  ASP C 226      13.768 -15.466   9.553  1.00 52.66           C  
ATOM   5668  OD1 ASP C 226      14.269 -15.229  10.686  1.00 46.89           O  
ATOM   5669  OD2 ASP C 226      12.764 -16.231   9.384  1.00 51.36           O  
ATOM   5670  N   ALA C 227      15.442 -12.374   6.643  1.00 36.72           N  
ATOM   5671  CA  ALA C 227      15.982 -11.869   5.396  1.00 37.39           C  
ATOM   5672  C   ALA C 227      15.748 -12.971   4.372  1.00 37.47           C  
ATOM   5673  O   ALA C 227      15.662 -14.146   4.740  1.00 35.57           O  
ATOM   5674  CB  ALA C 227      17.461 -11.551   5.528  1.00 36.19           C  
ATOM   5675  N   PRO C 228      15.589 -12.599   3.095  1.00 36.94           N  
ATOM   5676  CA  PRO C 228      15.307 -13.636   2.112  1.00 37.50           C  
ATOM   5677  C   PRO C 228      16.505 -14.553   1.862  1.00 37.54           C  
ATOM   5678  O   PRO C 228      17.649 -14.117   2.001  1.00 38.35           O  
ATOM   5679  CB  PRO C 228      14.924 -12.846   0.857  1.00 36.84           C  
ATOM   5680  CG  PRO C 228      15.532 -11.511   1.026  1.00 40.13           C  
ATOM   5681  CD  PRO C 228      15.625 -11.253   2.503  1.00 35.95           C  
ATOM   5682  N   THR C 229      16.207 -15.810   1.542  1.00 37.28           N  
ATOM   5683  CA  THR C 229      17.211 -16.808   1.208  1.00 38.88           C  
ATOM   5684  C   THR C 229      17.547 -16.705  -0.274  1.00 38.18           C  
ATOM   5685  O   THR C 229      16.869 -15.996  -1.032  1.00 39.29           O  
ATOM   5686  CB  THR C 229      16.716 -18.239   1.527  1.00 38.37           C  
ATOM   5687  OG1 THR C 229      15.632 -18.584   0.662  1.00 42.31           O  
ATOM   5688  CG2 THR C 229      16.248 -18.335   2.979  1.00 39.33           C  
ATOM   5689  N   GLU C 230      18.587 -17.418  -0.695  1.00 38.18           N  
ATOM   5690  CA  GLU C 230      19.011 -17.420  -2.110  1.00 38.82           C  
ATOM   5691  C   GLU C 230      17.915 -17.968  -3.052  1.00 37.68           C  
ATOM   5692  O   GLU C 230      17.921 -17.678  -4.246  1.00 39.97           O  
ATOM   5693  CB  GLU C 230      20.319 -18.223  -2.280  1.00 38.55           C  
ATOM   5694  N   THR C 231      16.966 -18.728  -2.519  1.00 35.61           N  
ATOM   5695  CA  THR C 231      15.880 -19.283  -3.328  1.00 37.02           C  
ATOM   5696  C   THR C 231      14.507 -18.651  -3.023  1.00 34.97           C  
ATOM   5697  O   THR C 231      13.457 -19.204  -3.386  1.00 35.66           O  
ATOM   5698  CB  THR C 231      15.813 -20.795  -3.116  1.00 37.75           C  
ATOM   5699  OG1 THR C 231      15.678 -21.061  -1.715  1.00 46.35           O  
ATOM   5700  CG2 THR C 231      17.094 -21.449  -3.598  1.00 36.65           C  
ATOM   5701  N   ALA C 232      14.489 -17.489  -2.371  1.00 34.71           N  
ATOM   5702  CA  ALA C 232      13.201 -16.829  -2.096  1.00 34.89           C  
ATOM   5703  C   ALA C 232      12.619 -16.375  -3.442  1.00 32.60           C  
ATOM   5704  O   ALA C 232      13.364 -15.950  -4.335  1.00 34.29           O  
ATOM   5705  CB  ALA C 232      13.366 -15.636  -1.148  1.00 33.19           C  
ATOM   5706  N   GLU C 233      11.305 -16.498  -3.583  1.00 32.36           N  
ATOM   5707  CA  GLU C 233      10.593 -16.092  -4.775  1.00 34.07           C  
ATOM   5708  C   GLU C 233       9.941 -14.712  -4.682  1.00 30.75           C  
ATOM   5709  O   GLU C 233       9.667 -14.093  -5.706  1.00 30.58           O  
ATOM   5710  CB  GLU C 233       9.489 -17.116  -5.078  1.00 34.88           C  
ATOM   5711  CG  GLU C 233      10.021 -18.449  -5.529  1.00 41.45           C  
ATOM   5712  CD  GLU C 233       8.941 -19.487  -5.763  1.00 39.55           C  
ATOM   5713  OE1 GLU C 233       7.732 -19.171  -5.656  1.00 41.19           O  
ATOM   5714  OE2 GLU C 233       9.324 -20.642  -6.066  1.00 53.76           O  
ATOM   5715  N   ARG C 234       9.655 -14.265  -3.461  1.00 30.25           N  
ATOM   5716  CA  ARG C 234       8.953 -13.001  -3.239  1.00 30.17           C  
ATOM   5717  C   ARG C 234       9.622 -12.281  -2.127  1.00 28.97           C  
ATOM   5718  O   ARG C 234       9.870 -12.857  -1.068  1.00 29.03           O  
ATOM   5719  CB  ARG C 234       7.471 -13.241  -2.910  1.00 29.84           C  
ATOM   5720  CG  ARG C 234       6.578 -11.994  -2.910  1.00 29.86           C  
ATOM   5721  CD  ARG C 234       5.108 -12.375  -2.778  1.00 30.95           C  
ATOM   5722  NE  ARG C 234       4.646 -13.084  -3.974  1.00 32.95           N  
ATOM   5723  CZ  ARG C 234       4.312 -12.495  -5.123  1.00 30.21           C  
ATOM   5724  NH1 ARG C 234       4.346 -11.176  -5.242  1.00 36.04           N  
ATOM   5725  NH2 ARG C 234       3.936 -13.230  -6.156  1.00 34.21           N  
ATOM   5726  N   ILE C 235       9.971 -11.025  -2.372  1.00 29.47           N  
ATOM   5727  CA  ILE C 235      10.652 -10.245  -1.338  1.00 28.36           C  
ATOM   5728  C   ILE C 235       9.735  -9.119  -0.879  1.00 27.41           C  
ATOM   5729  O   ILE C 235       9.187  -8.374  -1.711  1.00 27.21           O  
ATOM   5730  CB  ILE C 235      11.999  -9.717  -1.830  1.00 29.88           C  
ATOM   5731  CG1 ILE C 235      12.844 -10.900  -2.336  1.00 36.84           C  
ATOM   5732  CG2 ILE C 235      12.742  -9.045  -0.662  1.00 21.71           C  
ATOM   5733  CD1 ILE C 235      14.130 -10.520  -2.933  1.00 38.27           C  
ATOM   5734  N   PHE C 236       9.601  -9.010   0.435  1.00 27.72           N  
ATOM   5735  CA  PHE C 236       8.735  -8.054   1.106  1.00 28.83           C  
ATOM   5736  C   PHE C 236       9.526  -6.954   1.773  1.00 27.95           C  
ATOM   5737  O   PHE C 236      10.464  -7.234   2.512  1.00 27.21           O  
ATOM   5738  CB  PHE C 236       7.944  -8.782   2.188  1.00 28.92           C  
ATOM   5739  CG  PHE C 236       6.955  -9.775   1.641  1.00 32.70           C  
ATOM   5740  CD1 PHE C 236       7.378 -11.034   1.203  1.00 33.75           C  
ATOM   5741  CD2 PHE C 236       5.610  -9.464   1.593  1.00 30.73           C  
ATOM   5742  CE1 PHE C 236       6.487 -11.923   0.681  1.00 30.55           C  
ATOM   5743  CE2 PHE C 236       4.701 -10.345   1.082  1.00 26.33           C  
ATOM   5744  CZ  PHE C 236       5.138 -11.591   0.632  1.00 29.69           C  
ATOM   5745  N   PHE C 237       9.159  -5.706   1.495  1.00 29.32           N  
ATOM   5746  CA  PHE C 237       9.813  -4.533   2.099  1.00 29.53           C  
ATOM   5747  C   PHE C 237       8.872  -3.724   2.969  1.00 28.60           C  
ATOM   5748  O   PHE C 237       7.724  -3.512   2.598  1.00 28.31           O  
ATOM   5749  CB  PHE C 237      10.303  -3.596   1.007  1.00 27.51           C  
ATOM   5750  CG  PHE C 237      11.347  -4.179   0.106  1.00 29.63           C  
ATOM   5751  CD1 PHE C 237      11.002  -5.062  -0.914  1.00 30.17           C  
ATOM   5752  CD2 PHE C 237      12.663  -3.781   0.216  1.00 34.12           C  
ATOM   5753  CE1 PHE C 237      11.978  -5.584  -1.764  1.00 33.32           C  
ATOM   5754  CE2 PHE C 237      13.632  -4.291  -0.618  1.00 29.70           C  
ATOM   5755  CZ  PHE C 237      13.295  -5.195  -1.606  1.00 31.31           C  
ATOM   5756  N   VAL C 238       9.351  -3.311   4.147  1.00 27.47           N  
ATOM   5757  CA  VAL C 238       8.644  -2.395   5.028  1.00 27.57           C  
ATOM   5758  C   VAL C 238       9.604  -1.200   5.200  1.00 29.66           C  
ATOM   5759  O   VAL C 238      10.778  -1.390   5.577  1.00 29.46           O  
ATOM   5760  CB  VAL C 238       8.345  -2.952   6.440  1.00 30.75           C  
ATOM   5761  CG1 VAL C 238       7.660  -1.878   7.262  1.00 26.81           C  
ATOM   5762  CG2 VAL C 238       7.483  -4.247   6.393  1.00 25.82           C  
ATOM   5763  N   ALA C 239       9.117  -0.002   4.862  1.00 30.69           N  
ATOM   5764  CA  ALA C 239       9.878   1.237   4.946  1.00 29.75           C  
ATOM   5765  C   ALA C 239       9.077   2.263   5.736  1.00 29.54           C  
ATOM   5766  O   ALA C 239       7.862   2.221   5.752  1.00 31.45           O  
ATOM   5767  CB  ALA C 239      10.196   1.768   3.540  1.00 30.01           C  
ATOM   5768  N   GLU C 240       9.765   3.200   6.368  1.00 30.16           N  
ATOM   5769  CA  GLU C 240       9.120   4.264   7.143  1.00 31.55           C  
ATOM   5770  C   GLU C 240       9.681   5.634   6.728  1.00 30.15           C  
ATOM   5771  O   GLU C 240      10.904   5.823   6.593  1.00 29.32           O  
ATOM   5772  CB  GLU C 240       9.330   4.035   8.637  1.00 32.16           C  
ATOM   5773  CG  GLU C 240       8.574   4.999   9.539  1.00 35.71           C  
ATOM   5774  CD  GLU C 240       8.693   4.636  11.023  1.00 37.17           C  
ATOM   5775  OE1 GLU C 240       8.430   3.463  11.370  1.00 45.30           O  
ATOM   5776  OE2 GLU C 240       9.017   5.524  11.850  1.00 42.30           O  
ATOM   5777  N   LYS C 241       8.789   6.591   6.533  1.00 30.17           N  
ATOM   5778  CA  LYS C 241       9.233   7.924   6.144  1.00 31.59           C  
ATOM   5779  C   LYS C 241       9.925   8.584   7.334  1.00 32.69           C  
ATOM   5780  O   LYS C 241       9.411   8.595   8.455  1.00 33.06           O  
ATOM   5781  CB  LYS C 241       8.093   8.802   5.633  1.00 32.60           C  
ATOM   5782  CG  LYS C 241       8.629  10.024   4.892  1.00 31.63           C  
ATOM   5783  CD  LYS C 241       7.637  11.090   4.770  1.00 39.15           C  
ATOM   5784  CE  LYS C 241       8.262  12.322   4.155  1.00 33.08           C  
ATOM   5785  NZ  LYS C 241       7.178  13.194   3.690  1.00 33.18           N  
ATOM   5786  N   ILE C 242      11.108   9.108   7.073  1.00 32.88           N  
ATOM   5787  CA  ILE C 242      11.885   9.818   8.066  1.00 34.60           C  
ATOM   5788  C   ILE C 242      11.260  11.198   8.248  1.00 37.36           C  
ATOM   5789  O   ILE C 242      10.799  11.804   7.273  1.00 39.21           O  
ATOM   5790  CB  ILE C 242      13.352   9.899   7.628  1.00 33.77           C  
ATOM   5791  CG1 ILE C 242      13.969   8.503   7.717  1.00 32.56           C  
ATOM   5792  CG2 ILE C 242      14.134  10.860   8.502  1.00 31.55           C  
ATOM   5793  CD1 ILE C 242      15.244   8.339   6.943  1.00 29.69           C  
ATOM   5794  OXT ILE C 242      11.161  11.706   9.367  1.00 38.86           O  
TER    5795      ILE C 242                                                      
END
MOLECULE T0471_20_148.pdb
ATOM    271  N   HIS A  20      -3.309 -17.290  -1.586  1.00  0.00           N  
ATOM    272  CA  HIS A  20      -2.266 -18.093  -0.934  1.00  0.00           C  
ATOM    273  C   HIS A  20      -1.204 -17.212  -0.244  1.00  0.00           C  
ATOM    274  O   HIS A  20      -1.188 -17.090   0.983  1.00  0.00           O  
ATOM    275  CB  HIS A  20      -1.605 -19.021  -1.962  1.00  0.00           C  
ATOM    276  CG  HIS A  20      -0.585 -19.946  -1.372  1.00  0.00           C  
ATOM    277  ND1 HIS A  20       0.755 -19.654  -1.409  1.00  0.00           N  
ATOM    278  CD2 HIS A  20      -0.759 -21.138  -0.754  1.00  0.00           C  
ATOM    279  CE1 HIS A  20       1.364 -20.664  -0.818  1.00  0.00           C  
ATOM    280  NE2 HIS A  20       0.487 -21.588  -0.405  1.00  0.00           N  
ATOM    281  H   HIS A  20      -3.227 -17.091  -2.542  1.00  0.00           H  
ATOM    282  HA  HIS A  20      -2.747 -18.703  -0.179  1.00  0.00           H  
ATOM    283  HB2 HIS A  20      -2.367 -19.626  -2.434  1.00  0.00           H  
ATOM    284  HB3 HIS A  20      -1.115 -18.421  -2.716  1.00  0.00           H  
ATOM    285  HD2 HIS A  20      -1.697 -21.641  -0.571  1.00  0.00           H  
ATOM    286  HE1 HIS A  20       2.433 -20.736  -0.682  1.00  0.00           H  
ATOM    287  HE2 HIS A  20       0.671 -22.296   0.248  1.00  0.00           H  
ATOM    288  N   MET A  21      -0.330 -16.591  -1.035  1.00  0.00           N  
ATOM    289  CA  MET A  21       0.750 -15.753  -0.492  1.00  0.00           C  
ATOM    290  C   MET A  21       0.239 -14.368  -0.058  1.00  0.00           C  
ATOM    291  O   MET A  21       0.786 -13.753   0.859  1.00  0.00           O  
ATOM    292  CB  MET A  21       1.874 -15.599  -1.525  1.00  0.00           C  
ATOM    293  CG  MET A  21       2.520 -16.918  -1.930  1.00  0.00           C  
ATOM    294  SD  MET A  21       3.890 -16.698  -3.086  1.00  0.00           S  
ATOM    295  CE  MET A  21       4.381 -18.401  -3.349  1.00  0.00           C  
ATOM    296  H   MET A  21      -0.401 -16.708  -2.008  1.00  0.00           H  
ATOM    297  HA  MET A  21       1.148 -16.257   0.378  1.00  0.00           H  
ATOM    298  HB2 MET A  21       1.470 -15.135  -2.414  1.00  0.00           H  
ATOM    299  HB3 MET A  21       2.641 -14.959  -1.114  1.00  0.00           H  
ATOM    300  HG2 MET A  21       2.893 -17.408  -1.043  1.00  0.00           H  
ATOM    301  HG3 MET A  21       1.771 -17.542  -2.399  1.00  0.00           H  
ATOM    302  HE1 MET A  21       4.680 -18.839  -2.408  1.00  0.00           H  
ATOM    303  HE2 MET A  21       5.211 -18.434  -4.041  1.00  0.00           H  
ATOM    304  HE3 MET A  21       3.549 -18.956  -3.757  1.00  0.00           H  
ATOM    305  N   TRP A  22      -0.811 -13.880  -0.718  1.00  0.00           N  
ATOM    306  CA  TRP A  22      -1.400 -12.575  -0.378  1.00  0.00           C  
ATOM    307  C   TRP A  22      -2.029 -12.593   1.023  1.00  0.00           C  
ATOM    308  O   TRP A  22      -2.142 -11.556   1.678  1.00  0.00           O  
ATOM    309  CB  TRP A  22      -2.468 -12.180  -1.403  1.00  0.00           C  
ATOM    310  CG  TRP A  22      -1.973 -12.158  -2.819  1.00  0.00           C  
ATOM    311  CD1 TRP A  22      -2.036 -13.177  -3.721  1.00  0.00           C  
ATOM    312  CD2 TRP A  22      -1.346 -11.062  -3.493  1.00  0.00           C  
ATOM    313  NE1 TRP A  22      -1.487 -12.785  -4.915  1.00  0.00           N  
ATOM    314  CE2 TRP A  22      -1.055 -11.489  -4.801  1.00  0.00           C  
ATOM    315  CE3 TRP A  22      -1.004  -9.761  -3.117  1.00  0.00           C  
ATOM    316  CZ2 TRP A  22      -0.445 -10.660  -5.737  1.00  0.00           C  
ATOM    317  CZ3 TRP A  22      -0.392  -8.940  -4.044  1.00  0.00           C  
ATOM    318  CH2 TRP A  22      -0.115  -9.393  -5.341  1.00  0.00           C  
ATOM    319  H   TRP A  22      -1.199 -14.405  -1.449  1.00  0.00           H  
ATOM    320  HA  TRP A  22      -0.608 -11.841  -0.398  1.00  0.00           H  
ATOM    321  HB2 TRP A  22      -3.286 -12.884  -1.350  1.00  0.00           H  
ATOM    322  HB3 TRP A  22      -2.839 -11.193  -1.164  1.00  0.00           H  
ATOM    323  HD1 TRP A  22      -2.458 -14.151  -3.510  1.00  0.00           H  
ATOM    324  HE1 TRP A  22      -1.416 -13.342  -5.719  1.00  0.00           H  
ATOM    325  HE3 TRP A  22      -1.207  -9.395  -2.120  1.00  0.00           H  
ATOM    326  HZ2 TRP A  22      -0.224 -10.995  -6.739  1.00  0.00           H  
ATOM    327  HZ3 TRP A  22      -0.117  -7.931  -3.770  1.00  0.00           H  
ATOM    328  HH2 TRP A  22       0.365  -8.717  -6.034  1.00  0.00           H  
ATOM    329  N   ASN A  23      -2.438 -13.783   1.467  1.00  0.00           N  
ATOM    330  CA  ASN A  23      -3.106 -13.955   2.764  1.00  0.00           C  
ATOM    331  C   ASN A  23      -2.230 -13.455   3.927  1.00  0.00           C  
ATOM    332  O   ASN A  23      -2.673 -12.647   4.748  1.00  0.00           O  
ATOM    333  CB  ASN A  23      -3.461 -15.433   2.969  1.00  0.00           C  
ATOM    334  CG  ASN A  23      -4.377 -15.661   4.158  1.00  0.00           C  
ATOM    335  OD1 ASN A  23      -3.923 -15.869   5.280  1.00  0.00           O  
ATOM    336  ND2 ASN A  23      -5.673 -15.633   3.920  1.00  0.00           N  
ATOM    337  H   ASN A  23      -2.290 -14.572   0.904  1.00  0.00           H  
ATOM    338  HA  ASN A  23      -4.018 -13.376   2.743  1.00  0.00           H  
ATOM    339  HB2 ASN A  23      -3.956 -15.802   2.083  1.00  0.00           H  
ATOM    340  HB3 ASN A  23      -2.552 -16.000   3.123  1.00  0.00           H  
ATOM    341 HD21 ASN A  23      -5.971 -15.470   3.003  1.00  0.00           H  
ATOM    342 HD22 ASN A  23      -6.284 -15.783   4.671  1.00  0.00           H  
ATOM    343  N   ASP A  24      -0.988 -13.938   3.989  1.00  0.00           N  
ATOM    344  CA  ASP A  24      -0.048 -13.519   5.037  1.00  0.00           C  
ATOM    345  C   ASP A  24       0.273 -12.020   4.933  1.00  0.00           C  
ATOM    346  O   ASP A  24       0.351 -11.315   5.943  1.00  0.00           O  
ATOM    347  CB  ASP A  24       1.245 -14.336   4.946  1.00  0.00           C  
ATOM    348  CG  ASP A  24       1.000 -15.826   5.097  1.00  0.00           C  
ATOM    349  OD1 ASP A  24       0.675 -16.272   6.217  1.00  0.00           O  
ATOM    350  OD2 ASP A  24       1.133 -16.559   4.097  1.00  0.00           O  
ATOM    351  H   ASP A  24      -0.695 -14.592   3.319  1.00  0.00           H  
ATOM    352  HA  ASP A  24      -0.515 -13.709   5.994  1.00  0.00           H  
ATOM    353  HB2 ASP A  24       1.712 -14.158   3.986  1.00  0.00           H  
ATOM    354  HB3 ASP A  24       1.920 -14.020   5.729  1.00  0.00           H  
ATOM    355  N   LEU A  25       0.454 -11.539   3.702  1.00  0.00           N  
ATOM    356  CA  LEU A  25       0.729 -10.119   3.457  1.00  0.00           C  
ATOM    357  C   LEU A  25      -0.386  -9.229   4.033  1.00  0.00           C  
ATOM    358  O   LEU A  25      -0.113  -8.250   4.728  1.00  0.00           O  
ATOM    359  CB  LEU A  25       0.892  -9.861   1.950  1.00  0.00           C  
ATOM    360  CG  LEU A  25       1.194  -8.401   1.562  1.00  0.00           C  
ATOM    361  CD1 LEU A  25       2.510  -7.932   2.181  1.00  0.00           C  
ATOM    362  CD2 LEU A  25       1.223  -8.239   0.044  1.00  0.00           C  
ATOM    363  H   LEU A  25       0.403 -12.154   2.940  1.00  0.00           H  
ATOM    364  HA  LEU A  25       1.657  -9.876   3.955  1.00  0.00           H  
ATOM    365  HB2 LEU A  25       1.698 -10.484   1.585  1.00  0.00           H  
ATOM    366  HB3 LEU A  25      -0.022 -10.161   1.455  1.00  0.00           H  
ATOM    367  HG  LEU A  25       0.408  -7.769   1.948  1.00  0.00           H  
ATOM    368 HD11 LEU A  25       3.318  -8.561   1.833  1.00  0.00           H  
ATOM    369 HD12 LEU A  25       2.445  -7.993   3.258  1.00  0.00           H  
ATOM    370 HD13 LEU A  25       2.699  -6.909   1.890  1.00  0.00           H  
ATOM    371 HD21 LEU A  25       1.993  -8.873  -0.374  1.00  0.00           H  
ATOM    372 HD22 LEU A  25       1.432  -7.209  -0.204  1.00  0.00           H  
ATOM    373 HD23 LEU A  25       0.265  -8.520  -0.367  1.00  0.00           H  
ATOM    374  N   ALA A  26      -1.641  -9.586   3.748  1.00  0.00           N  
ATOM    375  CA  ALA A  26      -2.799  -8.845   4.264  1.00  0.00           C  
ATOM    376  C   ALA A  26      -2.760  -8.734   5.797  1.00  0.00           C  
ATOM    377  O   ALA A  26      -2.931  -7.650   6.357  1.00  0.00           O  
ATOM    378  CB  ALA A  26      -4.097  -9.508   3.811  1.00  0.00           C  
ATOM    379  H   ALA A  26      -1.793 -10.366   3.172  1.00  0.00           H  
ATOM    380  HA  ALA A  26      -2.768  -7.849   3.844  1.00  0.00           H  
ATOM    381  HB1 ALA A  26      -4.122  -9.550   2.732  1.00  0.00           H  
ATOM    382  HB2 ALA A  26      -4.941  -8.932   4.168  1.00  0.00           H  
ATOM    383  HB3 ALA A  26      -4.151 -10.511   4.212  1.00  0.00           H  
ATOM    384  N   VAL A  27      -2.520  -9.863   6.466  1.00  0.00           N  
ATOM    385  CA  VAL A  27      -2.407  -9.889   7.929  1.00  0.00           C  
ATOM    386  C   VAL A  27      -1.297  -8.942   8.417  1.00  0.00           C  
ATOM    387  O   VAL A  27      -1.488  -8.176   9.366  1.00  0.00           O  
ATOM    388  CB  VAL A  27      -2.128 -11.322   8.452  1.00  0.00           C  
ATOM    389  CG1 VAL A  27      -2.026 -11.335   9.978  1.00  0.00           C  
ATOM    390  CG2 VAL A  27      -3.210 -12.291   7.971  1.00  0.00           C  
ATOM    391  H   VAL A  27      -2.416 -10.699   5.963  1.00  0.00           H  
ATOM    392  HA  VAL A  27      -3.352  -9.557   8.339  1.00  0.00           H  
ATOM    393  HB  VAL A  27      -1.178 -11.652   8.048  1.00  0.00           H  
ATOM    394 HG11 VAL A  27      -1.223 -10.684  10.293  1.00  0.00           H  
ATOM    395 HG12 VAL A  27      -1.827 -12.341  10.320  1.00  0.00           H  
ATOM    396 HG13 VAL A  27      -2.957 -10.989  10.405  1.00  0.00           H  
ATOM    397 HG21 VAL A  27      -2.997 -13.285   8.339  1.00  0.00           H  
ATOM    398 HG22 VAL A  27      -3.227 -12.306   6.891  1.00  0.00           H  
ATOM    399 HG23 VAL A  27      -4.175 -11.970   8.340  1.00  0.00           H  
ATOM    400  N   TYR A  28      -0.141  -8.993   7.754  1.00  0.00           N  
ATOM    401  CA  TYR A  28       0.984  -8.105   8.080  1.00  0.00           C  
ATOM    402  C   TYR A  28       0.574  -6.624   7.973  1.00  0.00           C  
ATOM    403  O   TYR A  28       0.876  -5.819   8.858  1.00  0.00           O  
ATOM    404  CB  TYR A  28       2.174  -8.397   7.153  1.00  0.00           C  
ATOM    405  CG  TYR A  28       3.422  -7.582   7.459  1.00  0.00           C  
ATOM    406  CD1 TYR A  28       4.192  -7.849   8.588  1.00  0.00           C  
ATOM    407  CD2 TYR A  28       3.842  -6.560   6.610  1.00  0.00           C  
ATOM    408  CE1 TYR A  28       5.339  -7.124   8.860  1.00  0.00           C  
ATOM    409  CE2 TYR A  28       4.986  -5.830   6.879  1.00  0.00           C  
ATOM    410  CZ  TYR A  28       5.732  -6.116   8.004  1.00  0.00           C  
ATOM    411  OH  TYR A  28       6.883  -5.403   8.265  1.00  0.00           O  
ATOM    412  H   TYR A  28      -0.039  -9.648   7.028  1.00  0.00           H  
ATOM    413  HA  TYR A  28       1.278  -8.309   9.101  1.00  0.00           H  
ATOM    414  HB2 TYR A  28       2.436  -9.443   7.236  1.00  0.00           H  
ATOM    415  HB3 TYR A  28       1.882  -8.190   6.132  1.00  0.00           H  
ATOM    416  HD1 TYR A  28       3.884  -8.637   9.260  1.00  0.00           H  
ATOM    417  HD2 TYR A  28       3.257  -6.334   5.730  1.00  0.00           H  
ATOM    418  HE1 TYR A  28       5.921  -7.348   9.742  1.00  0.00           H  
ATOM    419  HE2 TYR A  28       5.291  -5.040   6.207  1.00  0.00           H  
ATOM    420  HH  TYR A  28       6.807  -4.520   7.878  1.00  0.00           H  
ATOM    421  N   ILE A  29      -0.123  -6.277   6.891  1.00  0.00           N  
ATOM    422  CA  ILE A  29      -0.602  -4.906   6.677  1.00  0.00           C  
ATOM    423  C   ILE A  29      -1.570  -4.464   7.788  1.00  0.00           C  
ATOM    424  O   ILE A  29      -1.442  -3.367   8.335  1.00  0.00           O  
ATOM    425  CB  ILE A  29      -1.299  -4.762   5.299  1.00  0.00           C  
ATOM    426  CG1 ILE A  29      -0.322  -5.118   4.165  1.00  0.00           C  
ATOM    427  CG2 ILE A  29      -1.848  -3.346   5.111  1.00  0.00           C  
ATOM    428  CD1 ILE A  29      -0.948  -5.097   2.782  1.00  0.00           C  
ATOM    429  H   ILE A  29      -0.318  -6.962   6.213  1.00  0.00           H  
ATOM    430  HA  ILE A  29       0.260  -4.251   6.689  1.00  0.00           H  
ATOM    431  HB  ILE A  29      -2.133  -5.449   5.272  1.00  0.00           H  
ATOM    432 HG12 ILE A  29       0.495  -4.411   4.167  1.00  0.00           H  
ATOM    433 HG13 ILE A  29       0.069  -6.110   4.335  1.00  0.00           H  
ATOM    434 HG21 ILE A  29      -2.301  -3.261   4.134  1.00  0.00           H  
ATOM    435 HG22 ILE A  29      -1.044  -2.629   5.198  1.00  0.00           H  
ATOM    436 HG23 ILE A  29      -2.592  -3.144   5.869  1.00  0.00           H  
ATOM    437 HD11 ILE A  29      -1.765  -5.804   2.744  1.00  0.00           H  
ATOM    438 HD12 ILE A  29      -0.205  -5.367   2.047  1.00  0.00           H  
ATOM    439 HD13 ILE A  29      -1.321  -4.106   2.568  1.00  0.00           H  
ATOM    440  N   ILE A  30      -2.531  -5.329   8.125  1.00  0.00           N  
ATOM    441  CA  ILE A  30      -3.503  -5.041   9.193  1.00  0.00           C  
ATOM    442  C   ILE A  30      -2.792  -4.738  10.522  1.00  0.00           C  
ATOM    443  O   ILE A  30      -3.102  -3.755  11.202  1.00  0.00           O  
ATOM    444  CB  ILE A  30      -4.482  -6.229   9.402  1.00  0.00           C  
ATOM    445  CG1 ILE A  30      -5.277  -6.506   8.115  1.00  0.00           C  
ATOM    446  CG2 ILE A  30      -5.431  -5.954  10.573  1.00  0.00           C  
ATOM    447  CD1 ILE A  30      -6.188  -7.716   8.202  1.00  0.00           C  
ATOM    448  H   ILE A  30      -2.587  -6.185   7.649  1.00  0.00           H  
ATOM    449  HA  ILE A  30      -4.078  -4.173   8.897  1.00  0.00           H  
ATOM    450  HB  ILE A  30      -3.896  -7.104   9.648  1.00  0.00           H  
ATOM    451 HG12 ILE A  30      -5.893  -5.650   7.887  1.00  0.00           H  
ATOM    452 HG13 ILE A  30      -4.586  -6.671   7.299  1.00  0.00           H  
ATOM    453 HG21 ILE A  30      -6.102  -6.792  10.698  1.00  0.00           H  
ATOM    454 HG22 ILE A  30      -6.007  -5.062  10.372  1.00  0.00           H  
ATOM    455 HG23 ILE A  30      -4.859  -5.815  11.479  1.00  0.00           H  
ATOM    456 HD11 ILE A  30      -5.600  -8.598   8.408  1.00  0.00           H  
ATOM    457 HD12 ILE A  30      -6.708  -7.841   7.264  1.00  0.00           H  
ATOM    458 HD13 ILE A  30      -6.907  -7.570   8.994  1.00  0.00           H  
ATOM    459  N   ARG A  31      -1.827  -5.586  10.874  1.00  0.00           N  
ATOM    460  CA  ARG A  31      -1.046  -5.420  12.108  1.00  0.00           C  
ATOM    461  C   ARG A  31      -0.262  -4.095  12.112  1.00  0.00           C  
ATOM    462  O   ARG A  31      -0.064  -3.478  13.161  1.00  0.00           O  
ATOM    463  CB  ARG A  31      -0.074  -6.599  12.274  1.00  0.00           C  
ATOM    464  CG  ARG A  31      -0.764  -7.958  12.371  1.00  0.00           C  
ATOM    465  CD  ARG A  31       0.240  -9.109  12.421  1.00  0.00           C  
ATOM    466  NE  ARG A  31       1.129  -9.022  13.577  1.00  0.00           N  
ATOM    467  CZ  ARG A  31       2.041  -9.909  13.871  1.00  0.00           C  
ATOM    468  NH1 ARG A  31       2.219 -10.955  13.125  1.00  0.00           N  
ATOM    469  NH2 ARG A  31       2.774  -9.745  14.919  1.00  0.00           N  
ATOM    470  H   ARG A  31      -1.634  -6.352  10.288  1.00  0.00           H  
ATOM    471  HA  ARG A  31      -1.738  -5.416  12.939  1.00  0.00           H  
ATOM    472  HB2 ARG A  31       0.597  -6.619  11.425  1.00  0.00           H  
ATOM    473  HB3 ARG A  31       0.508  -6.449  13.174  1.00  0.00           H  
ATOM    474  HG2 ARG A  31      -1.366  -7.981  13.269  1.00  0.00           H  
ATOM    475  HG3 ARG A  31      -1.403  -8.086  11.508  1.00  0.00           H  
ATOM    476  HD2 ARG A  31      -0.304 -10.041  12.469  1.00  0.00           H  
ATOM    477  HD3 ARG A  31       0.835  -9.090  11.519  1.00  0.00           H  
ATOM    478  HE  ARG A  31       1.030  -8.249  14.171  1.00  0.00           H  
ATOM    479 HH11 ARG A  31       1.657 -11.092  12.309  1.00  0.00           H  
ATOM    480 HH12 ARG A  31       2.908 -11.630  13.375  1.00  0.00           H  
ATOM    481 HH21 ARG A  31       2.639  -8.940  15.497  1.00  0.00           H  
ATOM    482 HH22 ARG A  31       3.471 -10.417  15.150  1.00  0.00           H  
ATOM    483  N   CYS A  32       0.176  -3.660  10.933  1.00  0.00           N  
ATOM    484  CA  CYS A  32       0.976  -2.432  10.803  1.00  0.00           C  
ATOM    485  C   CYS A  32       0.107  -1.175  10.617  1.00  0.00           C  
ATOM    486  O   CYS A  32       0.633  -0.063  10.543  1.00  0.00           O  
ATOM    487  CB  CYS A  32       1.953  -2.556   9.626  1.00  0.00           C  
ATOM    488  SG  CYS A  32       3.143  -3.908   9.785  1.00  0.00           S  
ATOM    489  H   CYS A  32      -0.040  -4.178  10.126  1.00  0.00           H  
ATOM    490  HA  CYS A  32       1.550  -2.317  11.712  1.00  0.00           H  
ATOM    491  HB2 CYS A  32       1.395  -2.721   8.717  1.00  0.00           H  
ATOM    492  HB3 CYS A  32       2.516  -1.636   9.534  1.00  0.00           H  
ATOM    493  HG  CYS A  32       2.566  -5.017   9.342  1.00  0.00           H  
ATOM    494  N   SER A  33      -1.215  -1.346  10.543  1.00  0.00           N  
ATOM    495  CA  SER A  33      -2.129  -0.214  10.288  1.00  0.00           C  
ATOM    496  C   SER A  33      -3.162  -0.028  11.413  1.00  0.00           C  
ATOM    497  O   SER A  33      -3.035   0.877  12.242  1.00  0.00           O  
ATOM    498  CB  SER A  33      -2.850  -0.406   8.944  1.00  0.00           C  
ATOM    499  OG  SER A  33      -3.576  -1.626   8.913  1.00  0.00           O  
ATOM    500  H   SER A  33      -1.587  -2.245  10.658  1.00  0.00           H  
ATOM    501  HA  SER A  33      -1.530   0.685  10.229  1.00  0.00           H  
ATOM    502  HB2 SER A  33      -3.538   0.411   8.784  1.00  0.00           H  
ATOM    503  HB3 SER A  33      -2.120  -0.419   8.148  1.00  0.00           H  
ATOM    504  HG  SER A  33      -3.044  -2.303   8.482  1.00  0.00           H  
ATOM    505  N   GLY A  34      -4.188  -0.877  11.432  1.00  0.00           N  
ATOM    506  CA  GLY A  34      -5.245  -0.765  12.437  1.00  0.00           C  
ATOM    507  C   GLY A  34      -6.542  -0.163  11.884  1.00  0.00           C  
ATOM    508  O   GLY A  34      -6.509   0.667  10.972  1.00  0.00           O  
ATOM    509  H   GLY A  34      -4.232  -1.588  10.756  1.00  0.00           H  
ATOM    510  HA2 GLY A  34      -5.456  -1.752  12.822  1.00  0.00           H  
ATOM    511  HA3 GLY A  34      -4.895  -0.144  13.252  1.00  0.00           H  
ATOM    512  N   PRO A  35      -7.711  -0.564  12.421  1.00  0.00           N  
ATOM    513  CA  PRO A  35      -9.023  -0.067  11.955  1.00  0.00           C  
ATOM    514  C   PRO A  35      -9.199   1.454  12.134  1.00  0.00           C  
ATOM    515  O   PRO A  35      -9.022   1.987  13.233  1.00  0.00           O  
ATOM    516  CB  PRO A  35     -10.032  -0.830  12.832  1.00  0.00           C  
ATOM    517  CG  PRO A  35      -9.274  -1.999  13.371  1.00  0.00           C  
ATOM    518  CD  PRO A  35      -7.855  -1.531  13.523  1.00  0.00           C  
ATOM    519  HA  PRO A  35      -9.187  -0.321  10.916  1.00  0.00           H  
ATOM    520  HB2 PRO A  35     -10.383  -0.188  13.629  1.00  0.00           H  
ATOM    521  HB3 PRO A  35     -10.871  -1.150  12.230  1.00  0.00           H  
ATOM    522  HG2 PRO A  35      -9.680  -2.292  14.330  1.00  0.00           H  
ATOM    523  HG3 PRO A  35      -9.325  -2.824  12.675  1.00  0.00           H  
ATOM    524  HD2 PRO A  35      -7.713  -1.049  14.481  1.00  0.00           H  
ATOM    525  HD3 PRO A  35      -7.167  -2.356  13.407  1.00  0.00           H  
ATOM    526  N   GLY A  36      -9.551   2.150  11.052  1.00  0.00           N  
ATOM    527  CA  GLY A  36      -9.817   3.588  11.135  1.00  0.00           C  
ATOM    528  C   GLY A  36      -8.794   4.454  10.404  1.00  0.00           C  
ATOM    529  O   GLY A  36      -9.050   5.633  10.144  1.00  0.00           O  
ATOM    530  H   GLY A  36      -9.644   1.684  10.190  1.00  0.00           H  
ATOM    531  HA2 GLY A  36     -10.791   3.779  10.711  1.00  0.00           H  
ATOM    532  HA3 GLY A  36      -9.835   3.881  12.177  1.00  0.00           H  
ATOM    533  N   THR A  37      -7.628   3.893  10.089  1.00  0.00           N  
ATOM    534  CA  THR A  37      -6.589   4.642   9.363  1.00  0.00           C  
ATOM    535  C   THR A  37      -6.660   4.376   7.854  1.00  0.00           C  
ATOM    536  O   THR A  37      -7.448   3.546   7.397  1.00  0.00           O  
ATOM    537  CB  THR A  37      -5.164   4.313   9.873  1.00  0.00           C  
ATOM    538  OG1 THR A  37      -4.211   5.212   9.280  1.00  0.00           O  
ATOM    539  CG2 THR A  37      -4.775   2.875   9.549  1.00  0.00           C  
ATOM    540  H   THR A  37      -7.460   2.961  10.345  1.00  0.00           H  
ATOM    541  HA  THR A  37      -6.767   5.697   9.530  1.00  0.00           H  
ATOM    542  HB  THR A  37      -5.146   4.443  10.947  1.00  0.00           H  
ATOM    543  HG1 THR A  37      -3.469   5.338   9.890  1.00  0.00           H  
ATOM    544 HG21 THR A  37      -5.487   2.198   9.997  1.00  0.00           H  
ATOM    545 HG22 THR A  37      -3.789   2.670   9.943  1.00  0.00           H  
ATOM    546 HG23 THR A  37      -4.769   2.733   8.478  1.00  0.00           H  
ATOM    547  N   ARG A  38      -5.834   5.078   7.080  1.00  0.00           N  
ATOM    548  CA  ARG A  38      -5.875   4.976   5.619  1.00  0.00           C  
ATOM    549  C   ARG A  38      -4.642   4.249   5.047  1.00  0.00           C  
ATOM    550  O   ARG A  38      -3.500   4.629   5.310  1.00  0.00           O  
ATOM    551  CB  ARG A  38      -5.993   6.378   5.006  1.00  0.00           C  
ATOM    552  CG  ARG A  38      -7.150   7.198   5.576  1.00  0.00           C  
ATOM    553  CD  ARG A  38      -7.396   8.482   4.787  1.00  0.00           C  
ATOM    554  NE  ARG A  38      -8.394   9.341   5.427  1.00  0.00           N  
ATOM    555  CZ  ARG A  38      -9.668   9.055   5.529  1.00  0.00           C  
ATOM    556  NH1 ARG A  38     -10.150   7.955   5.043  1.00  0.00           N  
ATOM    557  NH2 ARG A  38     -10.466   9.874   6.124  1.00  0.00           N  
ATOM    558  H   ARG A  38      -5.182   5.678   7.499  1.00  0.00           H  
ATOM    559  HA  ARG A  38      -6.758   4.411   5.354  1.00  0.00           H  
ATOM    560  HB2 ARG A  38      -5.073   6.918   5.185  1.00  0.00           H  
ATOM    561  HB3 ARG A  38      -6.139   6.279   3.943  1.00  0.00           H  
ATOM    562  HG2 ARG A  38      -8.048   6.599   5.551  1.00  0.00           H  
ATOM    563  HG3 ARG A  38      -6.921   7.456   6.602  1.00  0.00           H  
ATOM    564  HD2 ARG A  38      -6.466   9.028   4.713  1.00  0.00           H  
ATOM    565  HD3 ARG A  38      -7.738   8.223   3.795  1.00  0.00           H  
ATOM    566  HE  ARG A  38      -8.079  10.188   5.809  1.00  0.00           H  
ATOM    567 HH11 ARG A  38      -9.552   7.310   4.581  1.00  0.00           H  
ATOM    568 HH12 ARG A  38     -11.124   7.755   5.144  1.00  0.00           H  
ATOM    569 HH21 ARG A  38     -10.110  10.725   6.505  1.00  0.00           H  
ATOM    570 HH22 ARG A  38     -11.435   9.649   6.210  1.00  0.00           H  
ATOM    571  N   VAL A  39      -4.890   3.200   4.263  1.00  0.00           N  
ATOM    572  CA  VAL A  39      -3.824   2.449   3.581  1.00  0.00           C  
ATOM    573  C   VAL A  39      -4.066   2.449   2.061  1.00  0.00           C  
ATOM    574  O   VAL A  39      -5.190   2.251   1.617  1.00  0.00           O  
ATOM    575  CB  VAL A  39      -3.755   0.984   4.089  1.00  0.00           C  
ATOM    576  CG1 VAL A  39      -2.597   0.233   3.438  1.00  0.00           C  
ATOM    577  CG2 VAL A  39      -3.641   0.944   5.613  1.00  0.00           C  
ATOM    578  H   VAL A  39      -5.822   2.920   4.134  1.00  0.00           H  
ATOM    579  HA  VAL A  39      -2.877   2.932   3.790  1.00  0.00           H  
ATOM    580  HB  VAL A  39      -4.675   0.485   3.808  1.00  0.00           H  
ATOM    581 HG11 VAL A  39      -2.573  -0.785   3.803  1.00  0.00           H  
ATOM    582 HG12 VAL A  39      -1.665   0.724   3.685  1.00  0.00           H  
ATOM    583 HG13 VAL A  39      -2.726   0.227   2.366  1.00  0.00           H  
ATOM    584 HG21 VAL A  39      -3.604  -0.083   5.946  1.00  0.00           H  
ATOM    585 HG22 VAL A  39      -4.500   1.432   6.052  1.00  0.00           H  
ATOM    586 HG23 VAL A  39      -2.741   1.455   5.922  1.00  0.00           H  
ATOM    587  N   VAL A  40      -3.023   2.674   1.266  1.00  0.00           N  
ATOM    588  CA  VAL A  40      -3.184   2.800  -0.193  1.00  0.00           C  
ATOM    589  C   VAL A  40      -2.719   1.540  -0.951  1.00  0.00           C  
ATOM    590  O   VAL A  40      -1.576   1.100  -0.808  1.00  0.00           O  
ATOM    591  CB  VAL A  40      -2.408   4.028  -0.738  1.00  0.00           C  
ATOM    592  CG1 VAL A  40      -2.622   4.191  -2.243  1.00  0.00           C  
ATOM    593  CG2 VAL A  40      -2.812   5.300   0.009  1.00  0.00           C  
ATOM    594  H   VAL A  40      -2.129   2.755   1.659  1.00  0.00           H  
ATOM    595  HA  VAL A  40      -4.237   2.955  -0.397  1.00  0.00           H  
ATOM    596  HB  VAL A  40      -1.352   3.861  -0.567  1.00  0.00           H  
ATOM    597 HG11 VAL A  40      -2.262   3.311  -2.758  1.00  0.00           H  
ATOM    598 HG12 VAL A  40      -2.080   5.058  -2.595  1.00  0.00           H  
ATOM    599 HG13 VAL A  40      -3.676   4.321  -2.448  1.00  0.00           H  
ATOM    600 HG21 VAL A  40      -3.869   5.486  -0.134  1.00  0.00           H  
ATOM    601 HG22 VAL A  40      -2.245   6.138  -0.371  1.00  0.00           H  
ATOM    602 HG23 VAL A  40      -2.609   5.178   1.064  1.00  0.00           H  
ATOM    603  N   GLU A  41      -3.620   0.969  -1.754  1.00  0.00           N  
ATOM    604  CA  GLU A  41      -3.287  -0.144  -2.658  1.00  0.00           C  
ATOM    605  C   GLU A  41      -3.057   0.379  -4.088  1.00  0.00           C  
ATOM    606  O   GLU A  41      -4.005   0.737  -4.792  1.00  0.00           O  
ATOM    607  CB  GLU A  41      -4.412  -1.197  -2.653  1.00  0.00           C  
ATOM    608  CG  GLU A  41      -4.171  -2.384  -3.590  1.00  0.00           C  
ATOM    609  CD  GLU A  41      -5.277  -3.435  -3.516  1.00  0.00           C  
ATOM    610  OE1 GLU A  41      -6.346  -3.230  -4.134  1.00  0.00           O  
ATOM    611  OE2 GLU A  41      -5.088  -4.463  -2.834  1.00  0.00           O  
ATOM    612  H   GLU A  41      -4.541   1.305  -1.740  1.00  0.00           H  
ATOM    613  HA  GLU A  41      -2.373  -0.603  -2.303  1.00  0.00           H  
ATOM    614  HB2 GLU A  41      -4.522  -1.580  -1.648  1.00  0.00           H  
ATOM    615  HB3 GLU A  41      -5.337  -0.718  -2.946  1.00  0.00           H  
ATOM    616  HG2 GLU A  41      -4.110  -2.017  -4.604  1.00  0.00           H  
ATOM    617  HG3 GLU A  41      -3.232  -2.849  -3.324  1.00  0.00           H  
ATOM    618  N   VAL A  42      -1.793   0.433  -4.504  1.00  0.00           N  
ATOM    619  CA  VAL A  42      -1.424   0.967  -5.823  1.00  0.00           C  
ATOM    620  C   VAL A  42      -1.389  -0.135  -6.895  1.00  0.00           C  
ATOM    621  O   VAL A  42      -0.714  -1.156  -6.734  1.00  0.00           O  
ATOM    622  CB  VAL A  42      -0.045   1.676  -5.774  1.00  0.00           C  
ATOM    623  CG1 VAL A  42       0.320   2.258  -7.141  1.00  0.00           C  
ATOM    624  CG2 VAL A  42      -0.037   2.763  -4.699  1.00  0.00           C  
ATOM    625  H   VAL A  42      -1.086   0.103  -3.911  1.00  0.00           H  
ATOM    626  HA  VAL A  42      -2.168   1.703  -6.103  1.00  0.00           H  
ATOM    627  HB  VAL A  42       0.705   0.940  -5.512  1.00  0.00           H  
ATOM    628 HG11 VAL A  42      -0.416   2.993  -7.430  1.00  0.00           H  
ATOM    629 HG12 VAL A  42       0.344   1.466  -7.877  1.00  0.00           H  
ATOM    630 HG13 VAL A  42       1.293   2.725  -7.087  1.00  0.00           H  
ATOM    631 HG21 VAL A  42       0.937   3.229  -4.661  1.00  0.00           H  
ATOM    632 HG22 VAL A  42      -0.260   2.322  -3.737  1.00  0.00           H  
ATOM    633 HG23 VAL A  42      -0.784   3.509  -4.933  1.00  0.00           H  
ATOM    634  N   GLY A  43      -2.107   0.092  -7.995  1.00  0.00           N  
ATOM    635  CA  GLY A  43      -2.167  -0.885  -9.078  1.00  0.00           C  
ATOM    636  C   GLY A  43      -3.231  -1.953  -8.852  1.00  0.00           C  
ATOM    637  O   GLY A  43      -3.057  -3.108  -9.243  1.00  0.00           O  
ATOM    638  H   GLY A  43      -2.606   0.936  -8.072  1.00  0.00           H  
ATOM    639  HA2 GLY A  43      -2.390  -0.367  -9.998  1.00  0.00           H  
ATOM    640  HA3 GLY A  43      -1.205  -1.367  -9.173  1.00  0.00           H  
ATOM    641  N   ALA A  44      -4.344  -1.552  -8.244  1.00  0.00           N  
ATOM    642  CA  ALA A  44      -5.420  -2.480  -7.880  1.00  0.00           C  
ATOM    643  C   ALA A  44      -6.080  -3.129  -9.112  1.00  0.00           C  
ATOM    644  O   ALA A  44      -5.798  -4.283  -9.442  1.00  0.00           O  
ATOM    645  CB  ALA A  44      -6.458  -1.750  -7.039  1.00  0.00           C  
ATOM    646  H   ALA A  44      -4.449  -0.600  -8.028  1.00  0.00           H  
ATOM    647  HA  ALA A  44      -4.988  -3.260  -7.267  1.00  0.00           H  
ATOM    648  HB1 ALA A  44      -6.897  -0.949  -7.619  1.00  0.00           H  
ATOM    649  HB2 ALA A  44      -5.984  -1.337  -6.160  1.00  0.00           H  
ATOM    650  HB3 ALA A  44      -7.231  -2.440  -6.739  1.00  0.00           H  
ATOM    651  N   GLY A  45      -6.955  -2.382  -9.790  1.00  0.00           N  
ATOM    652  CA  GLY A  45      -7.653  -2.899 -10.969  1.00  0.00           C  
ATOM    653  C   GLY A  45      -8.501  -4.144 -10.694  1.00  0.00           C  
ATOM    654  O   GLY A  45      -9.724  -4.057 -10.570  1.00  0.00           O  
ATOM    655  H   GLY A  45      -7.121  -1.456  -9.496  1.00  0.00           H  
ATOM    656  HA2 GLY A  45      -8.298  -2.121 -11.354  1.00  0.00           H  
ATOM    657  HA3 GLY A  45      -6.920  -3.140 -11.726  1.00  0.00           H  
ATOM    658  N   ARG A  46      -7.844  -5.304 -10.606  1.00  0.00           N  
ATOM    659  CA  ARG A  46      -8.531  -6.587 -10.386  1.00  0.00           C  
ATOM    660  C   ARG A  46      -8.082  -7.268  -9.078  1.00  0.00           C  
ATOM    661  O   ARG A  46      -8.707  -8.226  -8.624  1.00  0.00           O  
ATOM    662  CB  ARG A  46      -8.272  -7.530 -11.573  1.00  0.00           C  
ATOM    663  CG  ARG A  46      -8.779  -6.992 -12.908  1.00  0.00           C  
ATOM    664  CD  ARG A  46      -8.433  -7.921 -14.067  1.00  0.00           C  
ATOM    665  NE  ARG A  46      -8.921  -7.403 -15.343  1.00  0.00           N  
ATOM    666  CZ  ARG A  46      -8.659  -7.938 -16.502  1.00  0.00           C  
ATOM    667  NH1 ARG A  46      -7.924  -9.001 -16.592  1.00  0.00           N  
ATOM    668  NH2 ARG A  46      -9.138  -7.403 -17.576  1.00  0.00           N  
ATOM    669  H   ARG A  46      -6.868  -5.296 -10.691  1.00  0.00           H  
ATOM    670  HA  ARG A  46      -9.593  -6.390 -10.323  1.00  0.00           H  
ATOM    671  HB2 ARG A  46      -7.207  -7.700 -11.658  1.00  0.00           H  
ATOM    672  HB3 ARG A  46      -8.763  -8.475 -11.381  1.00  0.00           H  
ATOM    673  HG2 ARG A  46      -9.853  -6.887 -12.856  1.00  0.00           H  
ATOM    674  HG3 ARG A  46      -8.332  -6.024 -13.089  1.00  0.00           H  
ATOM    675  HD2 ARG A  46      -7.358  -8.027 -14.119  1.00  0.00           H  
ATOM    676  HD3 ARG A  46      -8.880  -8.889 -13.886  1.00  0.00           H  
ATOM    677  HE  ARG A  46      -9.481  -6.602 -15.321  1.00  0.00           H  
ATOM    678 HH11 ARG A  46      -7.551  -9.423 -15.768  1.00  0.00           H  
ATOM    679 HH12 ARG A  46      -7.728  -9.391 -17.485  1.00  0.00           H  
ATOM    680 HH21 ARG A  46      -9.703  -6.582 -17.512  1.00  0.00           H  
ATOM    681 HH22 ARG A  46      -8.948  -7.812 -18.465  1.00  0.00           H  
ATOM    682  N   PHE A  47      -7.010  -6.765  -8.461  1.00  0.00           N  
ATOM    683  CA  PHE A  47      -6.460  -7.375  -7.236  1.00  0.00           C  
ATOM    684  C   PHE A  47      -7.255  -6.974  -5.979  1.00  0.00           C  
ATOM    685  O   PHE A  47      -6.824  -7.227  -4.853  1.00  0.00           O  
ATOM    686  CB  PHE A  47      -4.982  -6.989  -7.078  1.00  0.00           C  
ATOM    687  CG  PHE A  47      -4.100  -7.526  -8.180  1.00  0.00           C  
ATOM    688  CD1 PHE A  47      -3.843  -6.772  -9.318  1.00  0.00           C  
ATOM    689  CD2 PHE A  47      -3.532  -8.791  -8.081  1.00  0.00           C  
ATOM    690  CE1 PHE A  47      -3.041  -7.266 -10.328  1.00  0.00           C  
ATOM    691  CE2 PHE A  47      -2.728  -9.287  -9.089  1.00  0.00           C  
ATOM    692  CZ  PHE A  47      -2.483  -8.524 -10.214  1.00  0.00           C  
ATOM    693  H   PHE A  47      -6.576  -5.966  -8.830  1.00  0.00           H  
ATOM    694  HA  PHE A  47      -6.524  -8.448  -7.349  1.00  0.00           H  
ATOM    695  HB2 PHE A  47      -4.897  -5.911  -7.075  1.00  0.00           H  
ATOM    696  HB3 PHE A  47      -4.614  -7.374  -6.138  1.00  0.00           H  
ATOM    697  HD1 PHE A  47      -4.276  -5.787  -9.410  1.00  0.00           H  
ATOM    698  HD2 PHE A  47      -3.721  -9.390  -7.202  1.00  0.00           H  
ATOM    699  HE1 PHE A  47      -2.850  -6.669 -11.208  1.00  0.00           H  
ATOM    700  HE2 PHE A  47      -2.292 -10.271  -8.999  1.00  0.00           H  
ATOM    701  HZ  PHE A  47      -1.857  -8.911 -11.005  1.00  0.00           H  
ATOM    702  N   LEU A  48      -8.446  -6.415  -6.190  1.00  0.00           N  
ATOM    703  CA  LEU A  48      -9.297  -5.898  -5.107  1.00  0.00           C  
ATOM    704  C   LEU A  48      -9.533  -6.934  -3.991  1.00  0.00           C  
ATOM    705  O   LEU A  48      -9.777  -6.569  -2.844  1.00  0.00           O  
ATOM    706  CB  LEU A  48     -10.652  -5.462  -5.682  1.00  0.00           C  
ATOM    707  CG  LEU A  48     -10.586  -4.588  -6.947  1.00  0.00           C  
ATOM    708  CD1 LEU A  48     -11.984  -4.178  -7.391  1.00  0.00           C  
ATOM    709  CD2 LEU A  48      -9.707  -3.360  -6.722  1.00  0.00           C  
ATOM    710  H   LEU A  48      -8.767  -6.345  -7.108  1.00  0.00           H  
ATOM    711  HA  LEU A  48      -8.805  -5.035  -4.684  1.00  0.00           H  
ATOM    712  HB2 LEU A  48     -11.221  -6.352  -5.916  1.00  0.00           H  
ATOM    713  HB3 LEU A  48     -11.180  -4.910  -4.918  1.00  0.00           H  
ATOM    714  HG  LEU A  48     -10.146  -5.166  -7.748  1.00  0.00           H  
ATOM    715 HD11 LEU A  48     -12.575  -5.063  -7.583  1.00  0.00           H  
ATOM    716 HD12 LEU A  48     -11.918  -3.590  -8.295  1.00  0.00           H  
ATOM    717 HD13 LEU A  48     -12.454  -3.593  -6.614  1.00  0.00           H  
ATOM    718 HD21 LEU A  48     -10.109  -2.771  -5.910  1.00  0.00           H  
ATOM    719 HD22 LEU A  48      -9.684  -2.762  -7.621  1.00  0.00           H  
ATOM    720 HD23 LEU A  48      -8.703  -3.674  -6.475  1.00  0.00           H  
ATOM    721  N   TYR A  49      -9.462  -8.223  -4.337  1.00  0.00           N  
ATOM    722  CA  TYR A  49      -9.723  -9.309  -3.376  1.00  0.00           C  
ATOM    723  C   TYR A  49      -8.758  -9.273  -2.173  1.00  0.00           C  
ATOM    724  O   TYR A  49      -9.095  -9.748  -1.087  1.00  0.00           O  
ATOM    725  CB  TYR A  49      -9.652 -10.681  -4.074  1.00  0.00           C  
ATOM    726  CG  TYR A  49      -8.276 -11.056  -4.610  1.00  0.00           C  
ATOM    727  CD1 TYR A  49      -7.445 -11.926  -3.908  1.00  0.00           C  
ATOM    728  CD2 TYR A  49      -7.813 -10.546  -5.819  1.00  0.00           C  
ATOM    729  CE1 TYR A  49      -6.199 -12.274  -4.395  1.00  0.00           C  
ATOM    730  CE2 TYR A  49      -6.566 -10.890  -6.310  1.00  0.00           C  
ATOM    731  CZ  TYR A  49      -5.765 -11.753  -5.595  1.00  0.00           C  
ATOM    732  OH  TYR A  49      -4.523 -12.099  -6.082  1.00  0.00           O  
ATOM    733  H   TYR A  49      -9.233  -8.450  -5.260  1.00  0.00           H  
ATOM    734  HA  TYR A  49     -10.729  -9.170  -3.004  1.00  0.00           H  
ATOM    735  HB2 TYR A  49      -9.951 -11.445  -3.371  1.00  0.00           H  
ATOM    736  HB3 TYR A  49     -10.345 -10.684  -4.906  1.00  0.00           H  
ATOM    737  HD1 TYR A  49      -7.786 -12.331  -2.966  1.00  0.00           H  
ATOM    738  HD2 TYR A  49      -8.441  -9.868  -6.378  1.00  0.00           H  
ATOM    739  HE1 TYR A  49      -5.571 -12.951  -3.835  1.00  0.00           H  
ATOM    740  HE2 TYR A  49      -6.225 -10.480  -7.250  1.00  0.00           H  
ATOM    741  HH  TYR A  49      -4.046 -11.301  -6.338  1.00  0.00           H  
ATOM    742  N   VAL A  50      -7.560  -8.724  -2.376  1.00  0.00           N  
ATOM    743  CA  VAL A  50      -6.570  -8.607  -1.295  1.00  0.00           C  
ATOM    744  C   VAL A  50      -6.976  -7.522  -0.284  1.00  0.00           C  
ATOM    745  O   VAL A  50      -7.146  -7.792   0.908  1.00  0.00           O  
ATOM    746  CB  VAL A  50      -5.162  -8.274  -1.854  1.00  0.00           C  
ATOM    747  CG1 VAL A  50      -4.125  -8.219  -0.731  1.00  0.00           C  
ATOM    748  CG2 VAL A  50      -4.755  -9.285  -2.924  1.00  0.00           C  
ATOM    749  H   VAL A  50      -7.335  -8.381  -3.268  1.00  0.00           H  
ATOM    750  HA  VAL A  50      -6.519  -9.560  -0.786  1.00  0.00           H  
ATOM    751  HB  VAL A  50      -5.206  -7.297  -2.317  1.00  0.00           H  
ATOM    752 HG11 VAL A  50      -4.412  -7.469  -0.008  1.00  0.00           H  
ATOM    753 HG12 VAL A  50      -3.159  -7.967  -1.144  1.00  0.00           H  
ATOM    754 HG13 VAL A  50      -4.065  -9.183  -0.244  1.00  0.00           H  
ATOM    755 HG21 VAL A  50      -4.732 -10.276  -2.494  1.00  0.00           H  
ATOM    756 HG22 VAL A  50      -3.774  -9.036  -3.302  1.00  0.00           H  
ATOM    757 HG23 VAL A  50      -5.468  -9.261  -3.735  1.00  0.00           H  
ATOM    758  N   SER A  51      -7.136  -6.296  -0.774  1.00  0.00           N  
ATOM    759  CA  SER A  51      -7.519  -5.156   0.069  1.00  0.00           C  
ATOM    760  C   SER A  51      -8.935  -5.308   0.652  1.00  0.00           C  
ATOM    761  O   SER A  51      -9.202  -4.875   1.779  1.00  0.00           O  
ATOM    762  CB  SER A  51      -7.420  -3.856  -0.737  1.00  0.00           C  
ATOM    763  OG  SER A  51      -8.182  -3.927  -1.934  1.00  0.00           O  
ATOM    764  H   SER A  51      -6.977  -6.143  -1.731  1.00  0.00           H  
ATOM    765  HA  SER A  51      -6.814  -5.106   0.889  1.00  0.00           H  
ATOM    766  HB2 SER A  51      -7.787  -3.031  -0.143  1.00  0.00           H  
ATOM    767  HB3 SER A  51      -6.386  -3.677  -0.997  1.00  0.00           H  
ATOM    768  HG  SER A  51      -7.580  -3.876  -2.697  1.00  0.00           H  
ATOM    769  N   ASP A  52      -9.842  -5.917  -0.112  1.00  0.00           N  
ATOM    770  CA  ASP A  52     -11.216  -6.147   0.357  1.00  0.00           C  
ATOM    771  C   ASP A  52     -11.232  -7.063   1.590  1.00  0.00           C  
ATOM    772  O   ASP A  52     -12.028  -6.867   2.512  1.00  0.00           O  
ATOM    773  CB  ASP A  52     -12.082  -6.742  -0.761  1.00  0.00           C  
ATOM    774  CG  ASP A  52     -13.520  -6.976  -0.319  1.00  0.00           C  
ATOM    775  OD1 ASP A  52     -14.241  -5.987  -0.053  1.00  0.00           O  
ATOM    776  OD2 ASP A  52     -13.940  -8.149  -0.230  1.00  0.00           O  
ATOM    777  H   ASP A  52      -9.585  -6.213  -1.010  1.00  0.00           H  
ATOM    778  HA  ASP A  52     -11.625  -5.186   0.638  1.00  0.00           H  
ATOM    779  HB2 ASP A  52     -12.089  -6.062  -1.602  1.00  0.00           H  
ATOM    780  HB3 ASP A  52     -11.658  -7.686  -1.075  1.00  0.00           H  
ATOM    781  N   TYR A  53     -10.329  -8.041   1.612  1.00  0.00           N  
ATOM    782  CA  TYR A  53     -10.191  -8.950   2.755  1.00  0.00           C  
ATOM    783  C   TYR A  53     -10.002  -8.156   4.061  1.00  0.00           C  
ATOM    784  O   TYR A  53     -10.584  -8.483   5.095  1.00  0.00           O  
ATOM    785  CB  TYR A  53      -9.001  -9.894   2.521  1.00  0.00           C  
ATOM    786  CG  TYR A  53      -8.808 -10.945   3.601  1.00  0.00           C  
ATOM    787  CD1 TYR A  53      -9.547 -12.125   3.591  1.00  0.00           C  
ATOM    788  CD2 TYR A  53      -7.881 -10.763   4.624  1.00  0.00           C  
ATOM    789  CE1 TYR A  53      -9.368 -13.089   4.566  1.00  0.00           C  
ATOM    790  CE2 TYR A  53      -7.699 -11.723   5.603  1.00  0.00           C  
ATOM    791  CZ  TYR A  53      -8.444 -12.883   5.569  1.00  0.00           C  
ATOM    792  OH  TYR A  53      -8.260 -13.845   6.539  1.00  0.00           O  
ATOM    793  H   TYR A  53      -9.739  -8.159   0.838  1.00  0.00           H  
ATOM    794  HA  TYR A  53     -11.097  -9.535   2.826  1.00  0.00           H  
ATOM    795  HB2 TYR A  53      -9.145 -10.411   1.583  1.00  0.00           H  
ATOM    796  HB3 TYR A  53      -8.094  -9.309   2.462  1.00  0.00           H  
ATOM    797  HD1 TYR A  53     -10.271 -12.284   2.807  1.00  0.00           H  
ATOM    798  HD2 TYR A  53      -7.298  -9.853   4.650  1.00  0.00           H  
ATOM    799  HE1 TYR A  53      -9.953 -13.998   4.540  1.00  0.00           H  
ATOM    800  HE2 TYR A  53      -6.974 -11.561   6.389  1.00  0.00           H  
ATOM    801  HH  TYR A  53      -8.136 -13.417   7.398  1.00  0.00           H  
ATOM    802  N   ILE A  54      -9.206  -7.094   3.991  1.00  0.00           N  
ATOM    803  CA  ILE A  54      -8.954  -6.236   5.151  1.00  0.00           C  
ATOM    804  C   ILE A  54     -10.204  -5.424   5.542  1.00  0.00           C  
ATOM    805  O   ILE A  54     -10.563  -5.348   6.721  1.00  0.00           O  
ATOM    806  CB  ILE A  54      -7.772  -5.270   4.882  1.00  0.00           C  
ATOM    807  CG1 ILE A  54      -6.504  -6.071   4.533  1.00  0.00           C  
ATOM    808  CG2 ILE A  54      -7.525  -4.359   6.087  1.00  0.00           C  
ATOM    809  CD1 ILE A  54      -5.290  -5.211   4.223  1.00  0.00           C  
ATOM    810  H   ILE A  54      -8.776  -6.879   3.135  1.00  0.00           H  
ATOM    811  HA  ILE A  54      -8.685  -6.876   5.980  1.00  0.00           H  
ATOM    812  HB  ILE A  54      -8.036  -4.646   4.040  1.00  0.00           H  
ATOM    813 HG12 ILE A  54      -6.248  -6.711   5.365  1.00  0.00           H  
ATOM    814 HG13 ILE A  54      -6.704  -6.684   3.665  1.00  0.00           H  
ATOM    815 HG21 ILE A  54      -8.412  -3.775   6.289  1.00  0.00           H  
ATOM    816 HG22 ILE A  54      -6.700  -3.693   5.875  1.00  0.00           H  
ATOM    817 HG23 ILE A  54      -7.286  -4.961   6.952  1.00  0.00           H  
ATOM    818 HD11 ILE A  54      -5.060  -4.584   5.073  1.00  0.00           H  
ATOM    819 HD12 ILE A  54      -5.499  -4.590   3.364  1.00  0.00           H  
ATOM    820 HD13 ILE A  54      -4.444  -5.848   4.007  1.00  0.00           H  
ATOM    821  N   ARG A  55     -10.877  -4.834   4.550  1.00  0.00           N  
ATOM    822  CA  ARG A  55     -12.045  -3.978   4.815  1.00  0.00           C  
ATOM    823  C   ARG A  55     -13.297  -4.806   5.172  1.00  0.00           C  
ATOM    824  O   ARG A  55     -14.282  -4.270   5.683  1.00  0.00           O  
ATOM    825  CB  ARG A  55     -12.333  -3.058   3.616  1.00  0.00           C  
ATOM    826  CG  ARG A  55     -12.988  -3.756   2.427  1.00  0.00           C  
ATOM    827  CD  ARG A  55     -13.267  -2.786   1.279  1.00  0.00           C  
ATOM    828  NE  ARG A  55     -12.049  -2.397   0.563  1.00  0.00           N  
ATOM    829  CZ  ARG A  55     -11.540  -1.193   0.548  1.00  0.00           C  
ATOM    830  NH1 ARG A  55     -12.056  -0.241   1.262  1.00  0.00           N  
ATOM    831  NH2 ARG A  55     -10.503  -0.949  -0.185  1.00  0.00           N  
ATOM    832  H   ARG A  55     -10.584  -4.976   3.623  1.00  0.00           H  
ATOM    833  HA  ARG A  55     -11.798  -3.359   5.667  1.00  0.00           H  
ATOM    834  HB2 ARG A  55     -12.987  -2.261   3.940  1.00  0.00           H  
ATOM    835  HB3 ARG A  55     -11.400  -2.625   3.280  1.00  0.00           H  
ATOM    836  HG2 ARG A  55     -12.329  -4.534   2.072  1.00  0.00           H  
ATOM    837  HG3 ARG A  55     -13.922  -4.194   2.750  1.00  0.00           H  
ATOM    838  HD2 ARG A  55     -13.939  -3.264   0.581  1.00  0.00           H  
ATOM    839  HD3 ARG A  55     -13.741  -1.900   1.680  1.00  0.00           H  
ATOM    840  HE  ARG A  55     -11.606  -3.088   0.028  1.00  0.00           H  
ATOM    841 HH11 ARG A  55     -12.851  -0.422   1.831  1.00  0.00           H  
ATOM    842 HH12 ARG A  55     -11.654   0.670   1.237  1.00  0.00           H  
ATOM    843 HH21 ARG A  55     -10.103  -1.682  -0.736  1.00  0.00           H  
ATOM    844 HH22 ARG A  55     -10.105  -0.032  -0.203  1.00  0.00           H  
ATOM    845  N   LYS A  56     -13.270  -6.106   4.870  1.00  0.00           N  
ATOM    846  CA  LYS A  56     -14.344  -7.022   5.284  1.00  0.00           C  
ATOM    847  C   LYS A  56     -14.288  -7.299   6.797  1.00  0.00           C  
ATOM    848  O   LYS A  56     -15.321  -7.441   7.454  1.00  0.00           O  
ATOM    849  CB  LYS A  56     -14.259  -8.352   4.511  1.00  0.00           C  
ATOM    850  CG  LYS A  56     -14.834  -8.311   3.094  1.00  0.00           C  
ATOM    851  CD  LYS A  56     -16.342  -8.046   3.095  1.00  0.00           C  
ATOM    852  CE  LYS A  56     -16.992  -8.383   1.751  1.00  0.00           C  
ATOM    853  NZ  LYS A  56     -16.470  -7.554   0.632  1.00  0.00           N  
ATOM    854  H   LYS A  56     -12.517  -6.457   4.346  1.00  0.00           H  
ATOM    855  HA  LYS A  56     -15.288  -6.546   5.056  1.00  0.00           H  
ATOM    856  HB2 LYS A  56     -13.220  -8.642   4.440  1.00  0.00           H  
ATOM    857  HB3 LYS A  56     -14.791  -9.113   5.067  1.00  0.00           H  
ATOM    858  HG2 LYS A  56     -14.340  -7.526   2.539  1.00  0.00           H  
ATOM    859  HG3 LYS A  56     -14.645  -9.262   2.615  1.00  0.00           H  
ATOM    860  HD2 LYS A  56     -16.804  -8.652   3.862  1.00  0.00           H  
ATOM    861  HD3 LYS A  56     -16.513  -7.001   3.313  1.00  0.00           H  
ATOM    862  HE2 LYS A  56     -16.805  -9.424   1.527  1.00  0.00           H  
ATOM    863  HE3 LYS A  56     -18.058  -8.225   1.835  1.00  0.00           H  
ATOM    864  HZ1 LYS A  56     -15.437  -7.668   0.550  1.00  0.00           H  
ATOM    865  HZ2 LYS A  56     -16.683  -6.551   0.796  1.00  0.00           H  
ATOM    866  HZ3 LYS A  56     -16.909  -7.846  -0.263  1.00  0.00           H  
ATOM    867  N   HIS A  57     -13.075  -7.382   7.343  1.00  0.00           N  
ATOM    868  CA  HIS A  57     -12.884  -7.653   8.776  1.00  0.00           C  
ATOM    869  C   HIS A  57     -12.860  -6.363   9.615  1.00  0.00           C  
ATOM    870  O   HIS A  57     -13.476  -6.293  10.682  1.00  0.00           O  
ATOM    871  CB  HIS A  57     -11.585  -8.440   8.999  1.00  0.00           C  
ATOM    872  CG  HIS A  57     -11.636  -9.854   8.496  1.00  0.00           C  
ATOM    873  ND1 HIS A  57     -11.631 -10.923   9.362  1.00  0.00           N  
ATOM    874  CD2 HIS A  57     -11.679 -10.321   7.223  1.00  0.00           C  
ATOM    875  CE1 HIS A  57     -11.671 -12.004   8.602  1.00  0.00           C  
ATOM    876  NE2 HIS A  57     -11.701 -11.689   7.303  1.00  0.00           N  
ATOM    877  H   HIS A  57     -12.288  -7.265   6.768  1.00  0.00           H  
ATOM    878  HA  HIS A  57     -13.715  -8.260   9.108  1.00  0.00           H  
ATOM    879  HB2 HIS A  57     -10.775  -7.937   8.491  1.00  0.00           H  
ATOM    880  HB3 HIS A  57     -11.369  -8.472  10.059  1.00  0.00           H  
ATOM    881  HD2 HIS A  57     -11.701  -9.733   6.319  1.00  0.00           H  
ATOM    882  HE1 HIS A  57     -11.679 -13.014   8.982  1.00  0.00           H  
ATOM    883  HE2 HIS A  57     -11.930 -12.302   6.571  1.00  0.00           H  
ATOM    884  N   SER A  58     -12.151  -5.345   9.130  1.00  0.00           N  
ATOM    885  CA  SER A  58     -11.943  -4.106   9.892  1.00  0.00           C  
ATOM    886  C   SER A  58     -12.251  -2.855   9.067  1.00  0.00           C  
ATOM    887  O   SER A  58     -12.045  -2.831   7.854  1.00  0.00           O  
ATOM    888  CB  SER A  58     -10.495  -4.047  10.394  1.00  0.00           C  
ATOM    889  OG  SER A  58      -9.565  -4.111   9.321  1.00  0.00           O  
ATOM    890  H   SER A  58     -11.756  -5.423   8.238  1.00  0.00           H  
ATOM    891  HA  SER A  58     -12.601  -4.119  10.742  1.00  0.00           H  
ATOM    892  HB2 SER A  58     -10.339  -3.125  10.924  1.00  0.00           H  
ATOM    893  HB3 SER A  58     -10.315  -4.878  11.062  1.00  0.00           H  
ATOM    894  HG  SER A  58     -10.014  -4.402   8.518  1.00  0.00           H  
ATOM    895  N   LYS A  59     -12.733  -1.805   9.739  1.00  0.00           N  
ATOM    896  CA  LYS A  59     -13.016  -0.524   9.082  1.00  0.00           C  
ATOM    897  C   LYS A  59     -11.722   0.280   8.862  1.00  0.00           C  
ATOM    898  O   LYS A  59     -11.537   1.375   9.392  1.00  0.00           O  
ATOM    899  CB  LYS A  59     -14.047   0.281   9.897  1.00  0.00           C  
ATOM    900  CG  LYS A  59     -14.380   1.667   9.330  1.00  0.00           C  
ATOM    901  CD  LYS A  59     -14.779   1.618   7.855  1.00  0.00           C  
ATOM    902  CE  LYS A  59     -15.131   3.003   7.314  1.00  0.00           C  
ATOM    903  NZ  LYS A  59     -14.009   3.976   7.455  1.00  0.00           N  
ATOM    904  H   LYS A  59     -12.904  -1.894  10.702  1.00  0.00           H  
ATOM    905  HA  LYS A  59     -13.444  -0.746   8.112  1.00  0.00           H  
ATOM    906  HB2 LYS A  59     -14.962  -0.290   9.946  1.00  0.00           H  
ATOM    907  HB3 LYS A  59     -13.667   0.410  10.901  1.00  0.00           H  
ATOM    908  HG2 LYS A  59     -15.200   2.082   9.897  1.00  0.00           H  
ATOM    909  HG3 LYS A  59     -13.513   2.306   9.439  1.00  0.00           H  
ATOM    910  HD2 LYS A  59     -13.955   1.219   7.282  1.00  0.00           H  
ATOM    911  HD3 LYS A  59     -15.638   0.971   7.747  1.00  0.00           H  
ATOM    912  HE2 LYS A  59     -15.381   2.911   6.268  1.00  0.00           H  
ATOM    913  HE3 LYS A  59     -15.990   3.378   7.853  1.00  0.00           H  
ATOM    914  HZ1 LYS A  59     -13.721   4.053   8.452  1.00  0.00           H  
ATOM    915  HZ2 LYS A  59     -14.307   4.916   7.123  1.00  0.00           H  
ATOM    916  HZ3 LYS A  59     -13.189   3.675   6.892  1.00  0.00           H  
ATOM    917  N   VAL A  60     -10.807  -0.306   8.109  1.00  0.00           N  
ATOM    918  CA  VAL A  60      -9.617   0.410   7.643  1.00  0.00           C  
ATOM    919  C   VAL A  60      -9.909   1.087   6.300  1.00  0.00           C  
ATOM    920  O   VAL A  60     -10.300   0.426   5.333  1.00  0.00           O  
ATOM    921  CB  VAL A  60      -8.404  -0.534   7.472  1.00  0.00           C  
ATOM    922  CG1 VAL A  60      -7.154   0.246   7.060  1.00  0.00           C  
ATOM    923  CG2 VAL A  60      -8.151  -1.337   8.746  1.00  0.00           C  
ATOM    924  H   VAL A  60     -10.928  -1.251   7.869  1.00  0.00           H  
ATOM    925  HA  VAL A  60      -9.364   1.167   8.378  1.00  0.00           H  
ATOM    926  HB  VAL A  60      -8.637  -1.225   6.681  1.00  0.00           H  
ATOM    927 HG11 VAL A  60      -7.334   0.744   6.117  1.00  0.00           H  
ATOM    928 HG12 VAL A  60      -6.320  -0.434   6.952  1.00  0.00           H  
ATOM    929 HG13 VAL A  60      -6.920   0.984   7.815  1.00  0.00           H  
ATOM    930 HG21 VAL A  60      -9.030  -1.918   8.987  1.00  0.00           H  
ATOM    931 HG22 VAL A  60      -7.933  -0.662   9.561  1.00  0.00           H  
ATOM    932 HG23 VAL A  60      -7.310  -2.001   8.596  1.00  0.00           H  
ATOM    933  N   ASP A  61      -9.724   2.399   6.240  1.00  0.00           N  
ATOM    934  CA  ASP A  61      -9.986   3.159   5.018  1.00  0.00           C  
ATOM    935  C   ASP A  61      -8.897   2.905   3.967  1.00  0.00           C  
ATOM    936  O   ASP A  61      -8.025   3.742   3.723  1.00  0.00           O  
ATOM    937  CB  ASP A  61     -10.106   4.651   5.341  1.00  0.00           C  
ATOM    938  CG  ASP A  61     -11.317   4.945   6.208  1.00  0.00           C  
ATOM    939  OD1 ASP A  61     -11.210   4.855   7.447  1.00  0.00           O  
ATOM    940  OD2 ASP A  61     -12.391   5.256   5.650  1.00  0.00           O  
ATOM    941  H   ASP A  61      -9.393   2.869   7.031  1.00  0.00           H  
ATOM    942  HA  ASP A  61     -10.931   2.815   4.617  1.00  0.00           H  
ATOM    943  HB2 ASP A  61      -9.217   4.975   5.867  1.00  0.00           H  
ATOM    944  HB3 ASP A  61     -10.195   5.210   4.421  1.00  0.00           H  
ATOM    945  N   LEU A  62      -8.943   1.723   3.366  1.00  0.00           N  
ATOM    946  CA  LEU A  62      -7.961   1.323   2.364  1.00  0.00           C  
ATOM    947  C   LEU A  62      -8.357   1.861   0.975  1.00  0.00           C  
ATOM    948  O   LEU A  62      -9.370   1.452   0.398  1.00  0.00           O  
ATOM    949  CB  LEU A  62      -7.828  -0.214   2.358  1.00  0.00           C  
ATOM    950  CG  LEU A  62      -6.464  -0.771   1.901  1.00  0.00           C  
ATOM    951  CD1 LEU A  62      -6.350  -2.255   2.242  1.00  0.00           C  
ATOM    952  CD2 LEU A  62      -6.248  -0.547   0.405  1.00  0.00           C  
ATOM    953  H   LEU A  62      -9.653   1.094   3.615  1.00  0.00           H  
ATOM    954  HA  LEU A  62      -7.010   1.755   2.646  1.00  0.00           H  
ATOM    955  HB2 LEU A  62      -8.017  -0.570   3.361  1.00  0.00           H  
ATOM    956  HB3 LEU A  62      -8.591  -0.618   1.707  1.00  0.00           H  
ATOM    957  HG  LEU A  62      -5.678  -0.252   2.433  1.00  0.00           H  
ATOM    958 HD11 LEU A  62      -5.395  -2.631   1.906  1.00  0.00           H  
ATOM    959 HD12 LEU A  62      -7.144  -2.802   1.754  1.00  0.00           H  
ATOM    960 HD13 LEU A  62      -6.430  -2.386   3.312  1.00  0.00           H  
ATOM    961 HD21 LEU A  62      -6.253   0.514   0.195  1.00  0.00           H  
ATOM    962 HD22 LEU A  62      -7.040  -1.026  -0.151  1.00  0.00           H  
ATOM    963 HD23 LEU A  62      -5.297  -0.966   0.110  1.00  0.00           H  
ATOM    964  N   VAL A  63      -7.538   2.769   0.445  1.00  0.00           N  
ATOM    965  CA  VAL A  63      -7.821   3.449  -0.821  1.00  0.00           C  
ATOM    966  C   VAL A  63      -7.158   2.729  -2.001  1.00  0.00           C  
ATOM    967  O   VAL A  63      -5.964   2.440  -1.974  1.00  0.00           O  
ATOM    968  CB  VAL A  63      -7.325   4.919  -0.779  1.00  0.00           C  
ATOM    969  CG1 VAL A  63      -7.659   5.650  -2.081  1.00  0.00           C  
ATOM    970  CG2 VAL A  63      -7.915   5.650   0.427  1.00  0.00           C  
ATOM    971  H   VAL A  63      -6.708   2.984   0.917  1.00  0.00           H  
ATOM    972  HA  VAL A  63      -8.893   3.458  -0.969  1.00  0.00           H  
ATOM    973  HB  VAL A  63      -6.248   4.908  -0.671  1.00  0.00           H  
ATOM    974 HG11 VAL A  63      -7.199   5.135  -2.913  1.00  0.00           H  
ATOM    975 HG12 VAL A  63      -7.282   6.662  -2.036  1.00  0.00           H  
ATOM    976 HG13 VAL A  63      -8.730   5.672  -2.221  1.00  0.00           H  
ATOM    977 HG21 VAL A  63      -8.993   5.660   0.353  1.00  0.00           H  
ATOM    978 HG22 VAL A  63      -7.546   6.665   0.451  1.00  0.00           H  
ATOM    979 HG23 VAL A  63      -7.622   5.140   1.335  1.00  0.00           H  
ATOM    980  N   LEU A  64      -7.944   2.446  -3.031  1.00  0.00           N  
ATOM    981  CA  LEU A  64      -7.459   1.732  -4.218  1.00  0.00           C  
ATOM    982  C   LEU A  64      -7.175   2.724  -5.353  1.00  0.00           C  
ATOM    983  O   LEU A  64      -8.047   3.517  -5.707  1.00  0.00           O  
ATOM    984  CB  LEU A  64      -8.520   0.715  -4.660  1.00  0.00           C  
ATOM    985  CG  LEU A  64      -9.166  -0.086  -3.517  1.00  0.00           C  
ATOM    986  CD1 LEU A  64     -10.238  -1.028  -4.049  1.00  0.00           C  
ATOM    987  CD2 LEU A  64      -8.111  -0.854  -2.728  1.00  0.00           C  
ATOM    988  H   LEU A  64      -8.879   2.731  -3.003  1.00  0.00           H  
ATOM    989  HA  LEU A  64      -6.547   1.209  -3.961  1.00  0.00           H  
ATOM    990  HB2 LEU A  64      -9.303   1.247  -5.187  1.00  0.00           H  
ATOM    991  HB3 LEU A  64      -8.060   0.017  -5.346  1.00  0.00           H  
ATOM    992  HG  LEU A  64      -9.647   0.605  -2.839  1.00  0.00           H  
ATOM    993 HD11 LEU A  64      -9.795  -1.719  -4.751  1.00  0.00           H  
ATOM    994 HD12 LEU A  64     -11.008  -0.456  -4.547  1.00  0.00           H  
ATOM    995 HD13 LEU A  64     -10.674  -1.580  -3.229  1.00  0.00           H  
ATOM    996 HD21 LEU A  64      -8.588  -1.405  -1.930  1.00  0.00           H  
ATOM    997 HD22 LEU A  64      -7.398  -0.161  -2.306  1.00  0.00           H  
ATOM    998 HD23 LEU A  64      -7.598  -1.543  -3.383  1.00  0.00           H  
ATOM    999  N   THR A  65      -5.966   2.688  -5.917  1.00  0.00           N  
ATOM   1000  CA  THR A  65      -5.570   3.666  -6.951  1.00  0.00           C  
ATOM   1001  C   THR A  65      -4.919   3.008  -8.181  1.00  0.00           C  
ATOM   1002  O   THR A  65      -3.970   2.229  -8.055  1.00  0.00           O  
ATOM   1003  CB  THR A  65      -4.582   4.723  -6.391  1.00  0.00           C  
ATOM   1004  OG1 THR A  65      -3.362   4.098  -5.961  1.00  0.00           O  
ATOM   1005  CG2 THR A  65      -5.196   5.493  -5.224  1.00  0.00           C  
ATOM   1006  H   THR A  65      -5.324   2.001  -5.635  1.00  0.00           H  
ATOM   1007  HA  THR A  65      -6.463   4.186  -7.273  1.00  0.00           H  
ATOM   1008  HB  THR A  65      -4.352   5.426  -7.180  1.00  0.00           H  
ATOM   1009  HG1 THR A  65      -2.615   4.590  -6.315  1.00  0.00           H  
ATOM   1010 HG21 THR A  65      -4.481   6.212  -4.850  1.00  0.00           H  
ATOM   1011 HG22 THR A  65      -5.460   4.804  -4.433  1.00  0.00           H  
ATOM   1012 HG23 THR A  65      -6.082   6.011  -5.561  1.00  0.00           H  
ATOM   1013  N   ASP A  66      -5.441   3.335  -9.369  1.00  0.00           N  
ATOM   1014  CA  ASP A  66      -4.832   2.932 -10.649  1.00  0.00           C  
ATOM   1015  C   ASP A  66      -5.587   3.555 -11.843  1.00  0.00           C  
ATOM   1016  O   ASP A  66      -6.798   3.773 -11.787  1.00  0.00           O  
ATOM   1017  CB  ASP A  66      -4.743   1.398 -10.783  1.00  0.00           C  
ATOM   1018  CG  ASP A  66      -6.091   0.693 -10.764  1.00  0.00           C  
ATOM   1019  OD1 ASP A  66      -6.638   0.475  -9.666  1.00  0.00           O  
ATOM   1020  OD2 ASP A  66      -6.581   0.303 -11.849  1.00  0.00           O  
ATOM   1021  H   ASP A  66      -6.266   3.869  -9.386  1.00  0.00           H  
ATOM   1022  HA  ASP A  66      -3.826   3.333 -10.653  1.00  0.00           H  
ATOM   1023  HB2 ASP A  66      -4.247   1.154 -11.713  1.00  0.00           H  
ATOM   1024  HB3 ASP A  66      -4.148   1.013  -9.965  1.00  0.00           H  
ATOM   1025  N   ILE A  67      -4.855   3.850 -12.923  1.00  0.00           N  
ATOM   1026  CA  ILE A  67      -5.420   4.555 -14.084  1.00  0.00           C  
ATOM   1027  C   ILE A  67      -6.473   3.705 -14.818  1.00  0.00           C  
ATOM   1028  O   ILE A  67      -6.185   2.597 -15.278  1.00  0.00           O  
ATOM   1029  CB  ILE A  67      -4.309   4.968 -15.089  1.00  0.00           C  
ATOM   1030  CG1 ILE A  67      -3.265   5.865 -14.397  1.00  0.00           C  
ATOM   1031  CG2 ILE A  67      -4.912   5.680 -16.304  1.00  0.00           C  
ATOM   1032  CD1 ILE A  67      -2.122   6.293 -15.298  1.00  0.00           C  
ATOM   1033  H   ILE A  67      -3.912   3.579 -12.945  1.00  0.00           H  
ATOM   1034  HA  ILE A  67      -5.895   5.459 -13.721  1.00  0.00           H  
ATOM   1035  HB  ILE A  67      -3.822   4.068 -15.438  1.00  0.00           H  
ATOM   1036 HG12 ILE A  67      -3.748   6.759 -14.034  1.00  0.00           H  
ATOM   1037 HG13 ILE A  67      -2.840   5.328 -13.559  1.00  0.00           H  
ATOM   1038 HG21 ILE A  67      -5.614   5.022 -16.797  1.00  0.00           H  
ATOM   1039 HG22 ILE A  67      -4.125   5.946 -16.995  1.00  0.00           H  
ATOM   1040 HG23 ILE A  67      -5.423   6.574 -15.981  1.00  0.00           H  
ATOM   1041 HD11 ILE A  67      -1.432   6.908 -14.737  1.00  0.00           H  
ATOM   1042 HD12 ILE A  67      -2.510   6.860 -16.132  1.00  0.00           H  
ATOM   1043 HD13 ILE A  67      -1.604   5.420 -15.667  1.00  0.00           H  
ATOM   1044  N   LYS A  68      -7.685   4.250 -14.935  1.00  0.00           N  
ATOM   1045  CA  LYS A  68      -8.806   3.572 -15.601  1.00  0.00           C  
ATOM   1046  C   LYS A  68      -9.085   2.188 -14.983  1.00  0.00           C  
ATOM   1047  O   LYS A  68      -8.771   1.153 -15.578  1.00  0.00           O  
ATOM   1048  CB  LYS A  68      -8.549   3.445 -17.113  1.00  0.00           C  
ATOM   1049  CG  LYS A  68      -8.338   4.785 -17.816  1.00  0.00           C  
ATOM   1050  CD  LYS A  68      -8.135   4.622 -19.321  1.00  0.00           C  
ATOM   1051  CE  LYS A  68      -9.369   4.041 -20.006  1.00  0.00           C  
ATOM   1052  NZ  LYS A  68      -9.177   3.908 -21.475  1.00  0.00           N  
ATOM   1053  H   LYS A  68      -7.836   5.142 -14.557  1.00  0.00           H  
ATOM   1054  HA  LYS A  68      -9.682   4.188 -15.454  1.00  0.00           H  
ATOM   1055  HB2 LYS A  68      -7.667   2.840 -17.266  1.00  0.00           H  
ATOM   1056  HB3 LYS A  68      -9.396   2.951 -17.569  1.00  0.00           H  
ATOM   1057  HG2 LYS A  68      -9.206   5.409 -17.648  1.00  0.00           H  
ATOM   1058  HG3 LYS A  68      -7.465   5.266 -17.395  1.00  0.00           H  
ATOM   1059  HD2 LYS A  68      -7.923   5.590 -19.752  1.00  0.00           H  
ATOM   1060  HD3 LYS A  68      -7.295   3.962 -19.492  1.00  0.00           H  
ATOM   1061  HE2 LYS A  68      -9.573   3.064 -19.591  1.00  0.00           H  
ATOM   1062  HE3 LYS A  68     -10.211   4.693 -19.819  1.00  0.00           H  
ATOM   1063  HZ1 LYS A  68      -8.409   3.238 -21.679  1.00  0.00           H  
ATOM   1064  HZ2 LYS A  68      -8.932   4.832 -21.888  1.00  0.00           H  
ATOM   1065  HZ3 LYS A  68     -10.052   3.564 -21.920  1.00  0.00           H  
ATOM   1066  N   PRO A  69      -9.674   2.160 -13.771  1.00  0.00           N  
ATOM   1067  CA  PRO A  69      -9.979   0.910 -13.047  1.00  0.00           C  
ATOM   1068  C   PRO A  69     -11.069   0.063 -13.727  1.00  0.00           C  
ATOM   1069  O   PRO A  69     -11.769   0.523 -14.630  1.00  0.00           O  
ATOM   1070  CB  PRO A  69     -10.463   1.395 -11.667  1.00  0.00           C  
ATOM   1071  CG  PRO A  69     -10.049   2.827 -11.585  1.00  0.00           C  
ATOM   1072  CD  PRO A  69     -10.077   3.340 -12.994  1.00  0.00           C  
ATOM   1073  HA  PRO A  69      -9.090   0.305 -12.924  1.00  0.00           H  
ATOM   1074  HB2 PRO A  69     -11.538   1.294 -11.599  1.00  0.00           H  
ATOM   1075  HB3 PRO A  69      -9.996   0.806 -10.891  1.00  0.00           H  
ATOM   1076  HG2 PRO A  69     -10.745   3.379 -10.968  1.00  0.00           H  
ATOM   1077  HG3 PRO A  69      -9.049   2.899 -11.178  1.00  0.00           H  
ATOM   1078  HD2 PRO A  69     -11.074   3.663 -13.263  1.00  0.00           H  
ATOM   1079  HD3 PRO A  69      -9.369   4.147 -13.119  1.00  0.00           H  
ATOM   1080  N   SER A  70     -11.216  -1.181 -13.271  1.00  0.00           N  
ATOM   1081  CA  SER A  70     -12.190  -2.115 -13.860  1.00  0.00           C  
ATOM   1082  C   SER A  70     -13.554  -2.070 -13.155  1.00  0.00           C  
ATOM   1083  O   SER A  70     -14.558  -2.510 -13.715  1.00  0.00           O  
ATOM   1084  CB  SER A  70     -11.644  -3.550 -13.820  1.00  0.00           C  
ATOM   1085  OG  SER A  70     -10.458  -3.676 -14.593  1.00  0.00           O  
ATOM   1086  H   SER A  70     -10.652  -1.483 -12.529  1.00  0.00           H  
ATOM   1087  HA  SER A  70     -12.332  -1.832 -14.894  1.00  0.00           H  
ATOM   1088  HB2 SER A  70     -11.419  -3.820 -12.798  1.00  0.00           H  
ATOM   1089  HB3 SER A  70     -12.387  -4.228 -14.214  1.00  0.00           H  
ATOM   1090  HG  SER A  70     -10.041  -2.808 -14.693  1.00  0.00           H  
ATOM   1091  N   HIS A  71     -13.598  -1.536 -11.933  1.00  0.00           N  
ATOM   1092  CA  HIS A  71     -14.834  -1.556 -11.129  1.00  0.00           C  
ATOM   1093  C   HIS A  71     -15.153  -0.184 -10.510  1.00  0.00           C  
ATOM   1094  O   HIS A  71     -14.256   0.612 -10.223  1.00  0.00           O  
ATOM   1095  CB  HIS A  71     -14.728  -2.620 -10.027  1.00  0.00           C  
ATOM   1096  CG  HIS A  71     -14.532  -4.011 -10.559  1.00  0.00           C  
ATOM   1097  ND1 HIS A  71     -15.579  -4.727 -11.086  1.00  0.00           N  
ATOM   1098  CD2 HIS A  71     -13.405  -4.762 -10.634  1.00  0.00           C  
ATOM   1099  CE1 HIS A  71     -15.074  -5.886 -11.468  1.00  0.00           C  
ATOM   1100  NE2 HIS A  71     -13.761  -5.953 -11.215  1.00  0.00           N  
ATOM   1101  H   HIS A  71     -12.795  -1.111 -11.567  1.00  0.00           H  
ATOM   1102  HA  HIS A  71     -15.650  -1.825 -11.788  1.00  0.00           H  
ATOM   1103  HB2 HIS A  71     -13.891  -2.386  -9.385  1.00  0.00           H  
ATOM   1104  HB3 HIS A  71     -15.637  -2.613  -9.440  1.00  0.00           H  
ATOM   1105  HD2 HIS A  71     -12.417  -4.480 -10.305  1.00  0.00           H  
ATOM   1106  HE1 HIS A  71     -15.647  -6.678 -11.929  1.00  0.00           H  
ATOM   1107  HE2 HIS A  71     -13.143  -6.624 -11.577  1.00  0.00           H  
ATOM   1108  N   GLY A  72     -16.446   0.077 -10.299  1.00  0.00           N  
ATOM   1109  CA  GLY A  72     -16.889   1.362  -9.761  1.00  0.00           C  
ATOM   1110  C   GLY A  72     -16.638   1.514  -8.262  1.00  0.00           C  
ATOM   1111  O   GLY A  72     -17.378   0.972  -7.435  1.00  0.00           O  
ATOM   1112  H   GLY A  72     -17.111  -0.614 -10.508  1.00  0.00           H  
ATOM   1113  HA2 GLY A  72     -16.371   2.155 -10.280  1.00  0.00           H  
ATOM   1114  HA3 GLY A  72     -17.948   1.465  -9.947  1.00  0.00           H  
ATOM   1115  N   GLY A  73     -15.601   2.271  -7.913  1.00  0.00           N  
ATOM   1116  CA  GLY A  73     -15.240   2.470  -6.511  1.00  0.00           C  
ATOM   1117  C   GLY A  73     -13.751   2.738  -6.323  1.00  0.00           C  
ATOM   1118  O   GLY A  73     -13.336   3.331  -5.329  1.00  0.00           O  
ATOM   1119  H   GLY A  73     -15.076   2.709  -8.614  1.00  0.00           H  
ATOM   1120  HA2 GLY A  73     -15.796   3.311  -6.124  1.00  0.00           H  
ATOM   1121  HA3 GLY A  73     -15.509   1.586  -5.949  1.00  0.00           H  
ATOM   1122  N   ILE A  74     -12.948   2.289  -7.285  1.00  0.00           N  
ATOM   1123  CA  ILE A  74     -11.500   2.510  -7.264  1.00  0.00           C  
ATOM   1124  C   ILE A  74     -11.159   3.908  -7.808  1.00  0.00           C  
ATOM   1125  O   ILE A  74     -11.815   4.401  -8.730  1.00  0.00           O  
ATOM   1126  CB  ILE A  74     -10.747   1.433  -8.101  1.00  0.00           C  
ATOM   1127  CG1 ILE A  74     -10.967   0.017  -7.527  1.00  0.00           C  
ATOM   1128  CG2 ILE A  74      -9.252   1.745  -8.171  1.00  0.00           C  
ATOM   1129  CD1 ILE A  74     -12.371  -0.530  -7.704  1.00  0.00           C  
ATOM   1130  H   ILE A  74     -13.338   1.795  -8.033  1.00  0.00           H  
ATOM   1131  HA  ILE A  74     -11.163   2.441  -6.238  1.00  0.00           H  
ATOM   1132  HB  ILE A  74     -11.138   1.465  -9.110  1.00  0.00           H  
ATOM   1133 HG12 ILE A  74     -10.289  -0.670  -8.012  1.00  0.00           H  
ATOM   1134 HG13 ILE A  74     -10.753   0.032  -6.468  1.00  0.00           H  
ATOM   1135 HG21 ILE A  74      -8.841   1.774  -7.173  1.00  0.00           H  
ATOM   1136 HG22 ILE A  74      -9.103   2.703  -8.649  1.00  0.00           H  
ATOM   1137 HG23 ILE A  74      -8.750   0.978  -8.744  1.00  0.00           H  
ATOM   1138 HD11 ILE A  74     -12.621  -0.553  -8.756  1.00  0.00           H  
ATOM   1139 HD12 ILE A  74     -13.073   0.101  -7.179  1.00  0.00           H  
ATOM   1140 HD13 ILE A  74     -12.418  -1.532  -7.302  1.00  0.00           H  
ATOM   1141  N   VAL A  75     -10.139   4.543  -7.236  1.00  0.00           N  
ATOM   1142  CA  VAL A  75      -9.725   5.880  -7.666  1.00  0.00           C  
ATOM   1143  C   VAL A  75      -8.954   5.818  -8.996  1.00  0.00           C  
ATOM   1144  O   VAL A  75      -8.035   5.018  -9.161  1.00  0.00           O  
ATOM   1145  CB  VAL A  75      -8.855   6.578  -6.588  1.00  0.00           C  
ATOM   1146  CG1 VAL A  75      -8.566   8.029  -6.973  1.00  0.00           C  
ATOM   1147  CG2 VAL A  75      -9.531   6.503  -5.217  1.00  0.00           C  
ATOM   1148  H   VAL A  75      -9.642   4.098  -6.519  1.00  0.00           H  
ATOM   1149  HA  VAL A  75     -10.622   6.471  -7.809  1.00  0.00           H  
ATOM   1150  HB  VAL A  75      -7.910   6.053  -6.525  1.00  0.00           H  
ATOM   1151 HG11 VAL A  75      -7.949   8.488  -6.214  1.00  0.00           H  
ATOM   1152 HG12 VAL A  75      -9.496   8.573  -7.058  1.00  0.00           H  
ATOM   1153 HG13 VAL A  75      -8.048   8.055  -7.921  1.00  0.00           H  
ATOM   1154 HG21 VAL A  75     -10.496   6.988  -5.260  1.00  0.00           H  
ATOM   1155 HG22 VAL A  75      -8.913   6.998  -4.482  1.00  0.00           H  
ATOM   1156 HG23 VAL A  75      -9.661   5.468  -4.935  1.00  0.00           H  
ATOM   1157  N   ARG A  76      -9.342   6.670  -9.941  1.00  0.00           N  
ATOM   1158  CA  ARG A  76      -8.762   6.663 -11.292  1.00  0.00           C  
ATOM   1159  C   ARG A  76      -7.650   7.716 -11.459  1.00  0.00           C  
ATOM   1160  O   ARG A  76      -7.423   8.218 -12.564  1.00  0.00           O  
ATOM   1161  CB  ARG A  76      -9.878   6.917 -12.319  1.00  0.00           C  
ATOM   1162  CG  ARG A  76     -10.711   8.176 -12.038  1.00  0.00           C  
ATOM   1163  CD  ARG A  76     -10.813   9.087 -13.258  1.00  0.00           C  
ATOM   1164  NE  ARG A  76      -9.506   9.591 -13.671  1.00  0.00           N  
ATOM   1165  CZ  ARG A  76      -9.298  10.764 -14.202  1.00  0.00           C  
ATOM   1166  NH1 ARG A  76     -10.287  11.562 -14.467  1.00  0.00           N  
ATOM   1167  NH2 ARG A  76      -8.089  11.133 -14.482  1.00  0.00           N  
ATOM   1168  H   ARG A  76     -10.038   7.320  -9.729  1.00  0.00           H  
ATOM   1169  HA  ARG A  76      -8.341   5.685 -11.473  1.00  0.00           H  
ATOM   1170  HB2 ARG A  76      -9.433   7.009 -13.300  1.00  0.00           H  
ATOM   1171  HB3 ARG A  76     -10.544   6.066 -12.320  1.00  0.00           H  
ATOM   1172  HG2 ARG A  76     -11.709   7.878 -11.747  1.00  0.00           H  
ATOM   1173  HG3 ARG A  76     -10.253   8.727 -11.228  1.00  0.00           H  
ATOM   1174  HD2 ARG A  76     -11.249   8.529 -14.074  1.00  0.00           H  
ATOM   1175  HD3 ARG A  76     -11.454   9.923 -13.013  1.00  0.00           H  
ATOM   1176  HE  ARG A  76      -8.734   9.012 -13.524  1.00  0.00           H  
ATOM   1177 HH11 ARG A  76     -11.225  11.280 -14.269  1.00  0.00           H  
ATOM   1178 HH12 ARG A  76     -10.107  12.461 -14.861  1.00  0.00           H  
ATOM   1179 HH21 ARG A  76      -7.320  10.525 -14.287  1.00  0.00           H  
ATOM   1180 HH22 ARG A  76      -7.925  12.026 -14.894  1.00  0.00           H  
ATOM   1181  N   ASP A  77      -6.942   8.031 -10.382  1.00  0.00           N  
ATOM   1182  CA  ASP A  77      -5.922   9.085 -10.415  1.00  0.00           C  
ATOM   1183  C   ASP A  77      -4.735   8.706 -11.321  1.00  0.00           C  
ATOM   1184  O   ASP A  77      -4.314   7.548 -11.383  1.00  0.00           O  
ATOM   1185  CB  ASP A  77      -5.441   9.405  -8.995  1.00  0.00           C  
ATOM   1186  CG  ASP A  77      -4.905   8.183  -8.270  1.00  0.00           C  
ATOM   1187  OD1 ASP A  77      -5.687   7.237  -8.053  1.00  0.00           O  
ATOM   1188  OD2 ASP A  77      -3.711   8.175  -7.910  1.00  0.00           O  
ATOM   1189  H   ASP A  77      -7.079   7.525  -9.549  1.00  0.00           H  
ATOM   1190  HA  ASP A  77      -6.391   9.970 -10.825  1.00  0.00           H  
ATOM   1191  HB2 ASP A  77      -4.658  10.149  -9.045  1.00  0.00           H  
ATOM   1192  HB3 ASP A  77      -6.269   9.803  -8.424  1.00  0.00           H  
ATOM   1193  N   ASP A  78      -4.213   9.692 -12.043  1.00  0.00           N  
ATOM   1194  CA  ASP A  78      -3.092   9.472 -12.955  1.00  0.00           C  
ATOM   1195  C   ASP A  78      -1.786   9.219 -12.182  1.00  0.00           C  
ATOM   1196  O   ASP A  78      -1.012  10.143 -11.937  1.00  0.00           O  
ATOM   1197  CB  ASP A  78      -2.935  10.679 -13.888  1.00  0.00           C  
ATOM   1198  CG  ASP A  78      -4.211  10.980 -14.659  1.00  0.00           C  
ATOM   1199  OD1 ASP A  78      -5.133  11.591 -14.077  1.00  0.00           O  
ATOM   1200  OD2 ASP A  78      -4.294  10.613 -15.850  1.00  0.00           O  
ATOM   1201  H   ASP A  78      -4.595  10.591 -11.967  1.00  0.00           H  
ATOM   1202  HA  ASP A  78      -3.317   8.597 -13.552  1.00  0.00           H  
ATOM   1203  HB2 ASP A  78      -2.675  11.549 -13.301  1.00  0.00           H  
ATOM   1204  HB3 ASP A  78      -2.142  10.480 -14.596  1.00  0.00           H  
ATOM   1205  N   ILE A  79      -1.556   7.959 -11.800  1.00  0.00           N  
ATOM   1206  CA  ILE A  79      -0.368   7.562 -11.015  1.00  0.00           C  
ATOM   1207  C   ILE A  79       0.956   8.091 -11.618  1.00  0.00           C  
ATOM   1208  O   ILE A  79       1.945   8.261 -10.909  1.00  0.00           O  
ATOM   1209  CB  ILE A  79      -0.294   6.013 -10.870  1.00  0.00           C  
ATOM   1210  CG1 ILE A  79       0.848   5.593  -9.922  1.00  0.00           C  
ATOM   1211  CG2 ILE A  79      -0.129   5.346 -12.235  1.00  0.00           C  
ATOM   1212  CD1 ILE A  79       0.678   6.083  -8.497  1.00  0.00           C  
ATOM   1213  H   ILE A  79      -2.224   7.275 -12.022  1.00  0.00           H  
ATOM   1214  HA  ILE A  79      -0.483   7.982 -10.025  1.00  0.00           H  
ATOM   1215  HB  ILE A  79      -1.233   5.675 -10.453  1.00  0.00           H  
ATOM   1216 HG12 ILE A  79       0.904   4.514  -9.891  1.00  0.00           H  
ATOM   1217 HG13 ILE A  79       1.784   5.983 -10.297  1.00  0.00           H  
ATOM   1218 HG21 ILE A  79      -0.977   5.587 -12.859  1.00  0.00           H  
ATOM   1219 HG22 ILE A  79      -0.069   4.275 -12.110  1.00  0.00           H  
ATOM   1220 HG23 ILE A  79       0.776   5.703 -12.706  1.00  0.00           H  
ATOM   1221 HD11 ILE A  79      -0.256   5.715  -8.097  1.00  0.00           H  
ATOM   1222 HD12 ILE A  79       0.674   7.163  -8.485  1.00  0.00           H  
ATOM   1223 HD13 ILE A  79       1.496   5.720  -7.892  1.00  0.00           H  
ATOM   1224  N   THR A  80       0.966   8.356 -12.927  1.00  0.00           N  
ATOM   1225  CA  THR A  80       2.154   8.918 -13.599  1.00  0.00           C  
ATOM   1226  C   THR A  80       2.554  10.282 -13.003  1.00  0.00           C  
ATOM   1227  O   THR A  80       3.737  10.624 -12.936  1.00  0.00           O  
ATOM   1228  CB  THR A  80       1.925   9.078 -15.126  1.00  0.00           C  
ATOM   1229  OG1 THR A  80       3.079   9.665 -15.748  1.00  0.00           O  
ATOM   1230  CG2 THR A  80       0.693   9.931 -15.419  1.00  0.00           C  
ATOM   1231  H   THR A  80       0.163   8.168 -13.453  1.00  0.00           H  
ATOM   1232  HA  THR A  80       2.972   8.225 -13.453  1.00  0.00           H  
ATOM   1233  HB  THR A  80       1.768   8.096 -15.551  1.00  0.00           H  
ATOM   1234  HG1 THR A  80       2.814  10.097 -16.576  1.00  0.00           H  
ATOM   1235 HG21 THR A  80       0.826  10.915 -14.992  1.00  0.00           H  
ATOM   1236 HG22 THR A  80      -0.181   9.468 -14.986  1.00  0.00           H  
ATOM   1237 HG23 THR A  80       0.560  10.017 -16.489  1.00  0.00           H  
ATOM   1238  N   SER A  81       1.554  11.046 -12.565  1.00  0.00           N  
ATOM   1239  CA  SER A  81       1.769  12.351 -11.916  1.00  0.00           C  
ATOM   1240  C   SER A  81       0.480  12.816 -11.217  1.00  0.00           C  
ATOM   1241  O   SER A  81      -0.224  13.703 -11.707  1.00  0.00           O  
ATOM   1242  CB  SER A  81       2.233  13.411 -12.932  1.00  0.00           C  
ATOM   1243  OG  SER A  81       2.441  14.676 -12.312  1.00  0.00           O  
ATOM   1244  H   SER A  81       0.636  10.718 -12.667  1.00  0.00           H  
ATOM   1245  HA  SER A  81       2.538  12.222 -11.166  1.00  0.00           H  
ATOM   1246  HB2 SER A  81       3.162  13.091 -13.382  1.00  0.00           H  
ATOM   1247  HB3 SER A  81       1.483  13.522 -13.702  1.00  0.00           H  
ATOM   1248  HG  SER A  81       3.343  14.721 -11.968  1.00  0.00           H  
ATOM   1249  N   PRO A  82       0.128  12.189 -10.075  1.00  0.00           N  
ATOM   1250  CA  PRO A  82      -1.125  12.462  -9.362  1.00  0.00           C  
ATOM   1251  C   PRO A  82      -0.997  13.512  -8.243  1.00  0.00           C  
ATOM   1252  O   PRO A  82       0.104  13.893  -7.841  1.00  0.00           O  
ATOM   1253  CB  PRO A  82      -1.440  11.089  -8.770  1.00  0.00           C  
ATOM   1254  CG  PRO A  82      -0.098  10.510  -8.435  1.00  0.00           C  
ATOM   1255  CD  PRO A  82       0.905  11.134  -9.391  1.00  0.00           C  
ATOM   1256  HA  PRO A  82      -1.916  12.752 -10.039  1.00  0.00           H  
ATOM   1257  HB2 PRO A  82      -2.059  11.201  -7.889  1.00  0.00           H  
ATOM   1258  HB3 PRO A  82      -1.956  10.487  -9.503  1.00  0.00           H  
ATOM   1259  HG2 PRO A  82       0.160  10.752  -7.413  1.00  0.00           H  
ATOM   1260  HG3 PRO A  82      -0.121   9.437  -8.566  1.00  0.00           H  
ATOM   1261  HD2 PRO A  82       1.734  11.562  -8.843  1.00  0.00           H  
ATOM   1262  HD3 PRO A  82       1.261  10.398 -10.098  1.00  0.00           H  
ATOM   1263  N   ARG A  83      -2.143  13.972  -7.741  1.00  0.00           N  
ATOM   1264  CA  ARG A  83      -2.182  14.906  -6.612  1.00  0.00           C  
ATOM   1265  C   ARG A  83      -1.712  14.234  -5.308  1.00  0.00           C  
ATOM   1266  O   ARG A  83      -2.269  13.221  -4.883  1.00  0.00           O  
ATOM   1267  CB  ARG A  83      -3.609  15.445  -6.433  1.00  0.00           C  
ATOM   1268  CG  ARG A  83      -3.981  16.578  -7.384  1.00  0.00           C  
ATOM   1269  CD  ARG A  83      -3.238  17.865  -7.040  1.00  0.00           C  
ATOM   1270  NE  ARG A  83      -3.686  18.998  -7.847  1.00  0.00           N  
ATOM   1271  CZ  ARG A  83      -4.071  20.145  -7.353  1.00  0.00           C  
ATOM   1272  NH1 ARG A  83      -4.163  20.314  -6.071  1.00  0.00           N  
ATOM   1273  NH2 ARG A  83      -4.397  21.112  -8.145  1.00  0.00           N  
ATOM   1274  H   ARG A  83      -2.989  13.675  -8.141  1.00  0.00           H  
ATOM   1275  HA  ARG A  83      -1.520  15.731  -6.839  1.00  0.00           H  
ATOM   1276  HB2 ARG A  83      -4.307  14.634  -6.587  1.00  0.00           H  
ATOM   1277  HB3 ARG A  83      -3.718  15.807  -5.422  1.00  0.00           H  
ATOM   1278  HG2 ARG A  83      -3.732  16.287  -8.395  1.00  0.00           H  
ATOM   1279  HG3 ARG A  83      -5.045  16.758  -7.312  1.00  0.00           H  
ATOM   1280  HD2 ARG A  83      -3.400  18.092  -5.996  1.00  0.00           H  
ATOM   1281  HD3 ARG A  83      -2.181  17.711  -7.211  1.00  0.00           H  
ATOM   1282  HE  ARG A  83      -3.672  18.893  -8.820  1.00  0.00           H  
ATOM   1283 HH11 ARG A  83      -3.944  19.562  -5.452  1.00  0.00           H  
ATOM   1284 HH12 ARG A  83      -4.448  21.193  -5.702  1.00  0.00           H  
ATOM   1285 HH21 ARG A  83      -4.359  20.980  -9.135  1.00  0.00           H  
ATOM   1286 HH22 ARG A  83      -4.678  21.991  -7.769  1.00  0.00           H  
ATOM   1287  N   MET A  84      -0.701  14.819  -4.664  1.00  0.00           N  
ATOM   1288  CA  MET A  84      -0.164  14.275  -3.406  1.00  0.00           C  
ATOM   1289  C   MET A  84      -1.242  14.231  -2.308  1.00  0.00           C  
ATOM   1290  O   MET A  84      -1.236  13.348  -1.446  1.00  0.00           O  
ATOM   1291  CB  MET A  84       1.033  15.112  -2.936  1.00  0.00           C  
ATOM   1292  CG  MET A  84       2.179  15.153  -3.940  1.00  0.00           C  
ATOM   1293  SD  MET A  84       2.810  13.508  -4.342  1.00  0.00           S  
ATOM   1294  CE  MET A  84       3.422  12.971  -2.747  1.00  0.00           C  
ATOM   1295  H   MET A  84      -0.304  15.635  -5.042  1.00  0.00           H  
ATOM   1296  HA  MET A  84       0.170  13.265  -3.601  1.00  0.00           H  
ATOM   1297  HB2 MET A  84       0.703  16.126  -2.757  1.00  0.00           H  
ATOM   1298  HB3 MET A  84       1.408  14.697  -2.011  1.00  0.00           H  
ATOM   1299  HG2 MET A  84       1.827  15.621  -4.848  1.00  0.00           H  
ATOM   1300  HG3 MET A  84       2.985  15.742  -3.524  1.00  0.00           H  
ATOM   1301  HE1 MET A  84       3.846  11.983  -2.841  1.00  0.00           H  
ATOM   1302  HE2 MET A  84       2.608  12.948  -2.037  1.00  0.00           H  
ATOM   1303  HE3 MET A  84       4.181  13.657  -2.402  1.00  0.00           H  
ATOM   1304  N   GLU A  85      -2.172  15.185  -2.366  1.00  0.00           N  
ATOM   1305  CA  GLU A  85      -3.293  15.276  -1.414  1.00  0.00           C  
ATOM   1306  C   GLU A  85      -4.097  13.962  -1.318  1.00  0.00           C  
ATOM   1307  O   GLU A  85      -4.794  13.726  -0.330  1.00  0.00           O  
ATOM   1308  CB  GLU A  85      -4.217  16.432  -1.832  1.00  0.00           C  
ATOM   1309  CG  GLU A  85      -4.729  16.312  -3.265  1.00  0.00           C  
ATOM   1310  CD  GLU A  85      -5.400  17.578  -3.779  1.00  0.00           C  
ATOM   1311  OE1 GLU A  85      -4.703  18.605  -3.933  1.00  0.00           O  
ATOM   1312  OE2 GLU A  85      -6.617  17.546  -4.056  1.00  0.00           O  
ATOM   1313  H   GLU A  85      -2.099  15.862  -3.071  1.00  0.00           H  
ATOM   1314  HA  GLU A  85      -2.878  15.498  -0.441  1.00  0.00           H  
ATOM   1315  HB2 GLU A  85      -5.069  16.459  -1.167  1.00  0.00           H  
ATOM   1316  HB3 GLU A  85      -3.674  17.364  -1.742  1.00  0.00           H  
ATOM   1317  HG2 GLU A  85      -3.893  16.084  -3.911  1.00  0.00           H  
ATOM   1318  HG3 GLU A  85      -5.440  15.498  -3.308  1.00  0.00           H  
ATOM   1319  N   ILE A  86      -3.996  13.116  -2.345  1.00  0.00           N  
ATOM   1320  CA  ILE A  86      -4.689  11.820  -2.363  1.00  0.00           C  
ATOM   1321  C   ILE A  86      -4.038  10.813  -1.395  1.00  0.00           C  
ATOM   1322  O   ILE A  86      -4.728  10.045  -0.725  1.00  0.00           O  
ATOM   1323  CB  ILE A  86      -4.697  11.217  -3.794  1.00  0.00           C  
ATOM   1324  CG1 ILE A  86      -5.349  12.199  -4.783  1.00  0.00           C  
ATOM   1325  CG2 ILE A  86      -5.422   9.868  -3.815  1.00  0.00           C  
ATOM   1326  CD1 ILE A  86      -5.312  11.732  -6.222  1.00  0.00           C  
ATOM   1327  H   ILE A  86      -3.444  13.368  -3.114  1.00  0.00           H  
ATOM   1328  HA  ILE A  86      -5.715  11.984  -2.060  1.00  0.00           H  
ATOM   1329  HB  ILE A  86      -3.670  11.049  -4.092  1.00  0.00           H  
ATOM   1330 HG12 ILE A  86      -6.385  12.344  -4.511  1.00  0.00           H  
ATOM   1331 HG13 ILE A  86      -4.835  13.148  -4.731  1.00  0.00           H  
ATOM   1332 HG21 ILE A  86      -5.381   9.450  -4.811  1.00  0.00           H  
ATOM   1333 HG22 ILE A  86      -6.454  10.006  -3.527  1.00  0.00           H  
ATOM   1334 HG23 ILE A  86      -4.944   9.190  -3.123  1.00  0.00           H  
ATOM   1335 HD11 ILE A  86      -5.842  10.795  -6.312  1.00  0.00           H  
ATOM   1336 HD12 ILE A  86      -4.286  11.596  -6.530  1.00  0.00           H  
ATOM   1337 HD13 ILE A  86      -5.781  12.471  -6.854  1.00  0.00           H  
ATOM   1338  N   TYR A  87      -2.706  10.832  -1.323  1.00  0.00           N  
ATOM   1339  CA  TYR A  87      -1.957   9.886  -0.482  1.00  0.00           C  
ATOM   1340  C   TYR A  87      -1.650  10.479   0.908  1.00  0.00           C  
ATOM   1341  O   TYR A  87      -1.394   9.747   1.866  1.00  0.00           O  
ATOM   1342  CB  TYR A  87      -0.643   9.491  -1.174  1.00  0.00           C  
ATOM   1343  CG  TYR A  87      -0.812   9.041  -2.615  1.00  0.00           C  
ATOM   1344  CD1 TYR A  87      -0.296   9.797  -3.663  1.00  0.00           C  
ATOM   1345  CD2 TYR A  87      -1.485   7.864  -2.927  1.00  0.00           C  
ATOM   1346  CE1 TYR A  87      -0.443   9.393  -4.975  1.00  0.00           C  
ATOM   1347  CE2 TYR A  87      -1.637   7.455  -4.239  1.00  0.00           C  
ATOM   1348  CZ  TYR A  87      -1.113   8.222  -5.258  1.00  0.00           C  
ATOM   1349  OH  TYR A  87      -1.254   7.819  -6.564  1.00  0.00           O  
ATOM   1350  H   TYR A  87      -2.214  11.495  -1.848  1.00  0.00           H  
ATOM   1351  HA  TYR A  87      -2.564   9.001  -0.354  1.00  0.00           H  
ATOM   1352  HB2 TYR A  87       0.025  10.339  -1.169  1.00  0.00           H  
ATOM   1353  HB3 TYR A  87      -0.184   8.679  -0.625  1.00  0.00           H  
ATOM   1354  HD1 TYR A  87       0.230  10.714  -3.439  1.00  0.00           H  
ATOM   1355  HD2 TYR A  87      -1.895   7.264  -2.127  1.00  0.00           H  
ATOM   1356  HE1 TYR A  87      -0.034   9.996  -5.774  1.00  0.00           H  
ATOM   1357  HE2 TYR A  87      -2.164   6.537  -4.461  1.00  0.00           H  
ATOM   1358  HH  TYR A  87      -2.194   7.737  -6.782  1.00  0.00           H  
ATOM   1359  N   ARG A  88      -1.665  11.809   1.007  1.00  0.00           N  
ATOM   1360  CA  ARG A  88      -1.361  12.497   2.269  1.00  0.00           C  
ATOM   1361  C   ARG A  88      -2.358  12.135   3.376  1.00  0.00           C  
ATOM   1362  O   ARG A  88      -3.572  12.148   3.173  1.00  0.00           O  
ATOM   1363  CB  ARG A  88      -1.333  14.015   2.059  1.00  0.00           C  
ATOM   1364  CG  ARG A  88      -0.140  14.484   1.236  1.00  0.00           C  
ATOM   1365  CD  ARG A  88      -0.223  15.968   0.896  1.00  0.00           C  
ATOM   1366  NE  ARG A  88      -0.217  16.808   2.092  1.00  0.00           N  
ATOM   1367  CZ  ARG A  88      -0.230  18.113   2.071  1.00  0.00           C  
ATOM   1368  NH1 ARG A  88      -0.266  18.755   0.948  1.00  0.00           N  
ATOM   1369  NH2 ARG A  88      -0.213  18.774   3.181  1.00  0.00           N  
ATOM   1370  H   ARG A  88      -1.889  12.340   0.214  1.00  0.00           H  
ATOM   1371  HA  ARG A  88      -0.377  12.177   2.581  1.00  0.00           H  
ATOM   1372  HB2 ARG A  88      -2.239  14.315   1.550  1.00  0.00           H  
ATOM   1373  HB3 ARG A  88      -1.293  14.504   3.023  1.00  0.00           H  
ATOM   1374  HG2 ARG A  88       0.764  14.307   1.801  1.00  0.00           H  
ATOM   1375  HG3 ARG A  88      -0.106  13.912   0.321  1.00  0.00           H  
ATOM   1376  HD2 ARG A  88       0.625  16.229   0.279  1.00  0.00           H  
ATOM   1377  HD3 ARG A  88      -1.135  16.147   0.343  1.00  0.00           H  
ATOM   1378  HE  ARG A  88      -0.196  16.358   2.961  1.00  0.00           H  
ATOM   1379 HH11 ARG A  88      -0.287  18.253   0.086  1.00  0.00           H  
ATOM   1380 HH12 ARG A  88      -0.265  19.753   0.945  1.00  0.00           H  
ATOM   1381 HH21 ARG A  88      -0.187  18.287   4.051  1.00  0.00           H  
ATOM   1382 HH22 ARG A  88      -0.228  19.771   3.167  1.00  0.00           H  
ATOM   1383  N   GLY A  89      -1.827  11.826   4.554  1.00  0.00           N  
ATOM   1384  CA  GLY A  89      -2.665  11.413   5.674  1.00  0.00           C  
ATOM   1385  C   GLY A  89      -2.770   9.896   5.819  1.00  0.00           C  
ATOM   1386  O   GLY A  89      -3.371   9.400   6.774  1.00  0.00           O  
ATOM   1387  H   GLY A  89      -0.855  11.890   4.669  1.00  0.00           H  
ATOM   1388  HA2 GLY A  89      -2.251  11.819   6.585  1.00  0.00           H  
ATOM   1389  HA3 GLY A  89      -3.659  11.818   5.538  1.00  0.00           H  
ATOM   1390  N   ALA A  90      -2.205   9.157   4.862  1.00  0.00           N  
ATOM   1391  CA  ALA A  90      -2.181   7.691   4.928  1.00  0.00           C  
ATOM   1392  C   ALA A  90      -1.063   7.189   5.857  1.00  0.00           C  
ATOM   1393  O   ALA A  90      -0.087   7.897   6.112  1.00  0.00           O  
ATOM   1394  CB  ALA A  90      -2.013   7.101   3.530  1.00  0.00           C  
ATOM   1395  H   ALA A  90      -1.803   9.607   4.087  1.00  0.00           H  
ATOM   1396  HA  ALA A  90      -3.135   7.358   5.318  1.00  0.00           H  
ATOM   1397  HB1 ALA A  90      -2.051   6.022   3.585  1.00  0.00           H  
ATOM   1398  HB2 ALA A  90      -1.062   7.407   3.120  1.00  0.00           H  
ATOM   1399  HB3 ALA A  90      -2.809   7.455   2.891  1.00  0.00           H  
ATOM   1400  N   ALA A  91      -1.215   5.965   6.361  1.00  0.00           N  
ATOM   1401  CA  ALA A  91      -0.222   5.367   7.264  1.00  0.00           C  
ATOM   1402  C   ALA A  91       0.648   4.315   6.553  1.00  0.00           C  
ATOM   1403  O   ALA A  91       1.778   4.045   6.968  1.00  0.00           O  
ATOM   1404  CB  ALA A  91      -0.925   4.746   8.468  1.00  0.00           C  
ATOM   1405  H   ALA A  91      -2.018   5.455   6.130  1.00  0.00           H  
ATOM   1406  HA  ALA A  91       0.421   6.159   7.628  1.00  0.00           H  
ATOM   1407  HB1 ALA A  91      -1.547   3.926   8.140  1.00  0.00           H  
ATOM   1408  HB2 ALA A  91      -1.541   5.493   8.948  1.00  0.00           H  
ATOM   1409  HB3 ALA A  91      -0.189   4.383   9.170  1.00  0.00           H  
ATOM   1410  N   LEU A  92       0.126   3.723   5.480  1.00  0.00           N  
ATOM   1411  CA  LEU A  92       0.851   2.671   4.760  1.00  0.00           C  
ATOM   1412  C   LEU A  92       0.454   2.645   3.273  1.00  0.00           C  
ATOM   1413  O   LEU A  92      -0.720   2.774   2.931  1.00  0.00           O  
ATOM   1414  CB  LEU A  92       0.576   1.310   5.435  1.00  0.00           C  
ATOM   1415  CG  LEU A  92       1.569   0.171   5.120  1.00  0.00           C  
ATOM   1416  CD1 LEU A  92       1.449  -0.944   6.159  1.00  0.00           C  
ATOM   1417  CD2 LEU A  92       1.346  -0.400   3.719  1.00  0.00           C  
ATOM   1418  H   LEU A  92      -0.762   3.996   5.166  1.00  0.00           H  
ATOM   1419  HA  LEU A  92       1.908   2.892   4.832  1.00  0.00           H  
ATOM   1420  HB2 LEU A  92       0.577   1.466   6.506  1.00  0.00           H  
ATOM   1421  HB3 LEU A  92      -0.414   0.985   5.146  1.00  0.00           H  
ATOM   1422  HG  LEU A  92       2.578   0.563   5.170  1.00  0.00           H  
ATOM   1423 HD11 LEU A  92       0.446  -1.348   6.145  1.00  0.00           H  
ATOM   1424 HD12 LEU A  92       1.662  -0.545   7.140  1.00  0.00           H  
ATOM   1425 HD13 LEU A  92       2.156  -1.729   5.931  1.00  0.00           H  
ATOM   1426 HD21 LEU A  92       1.503   0.375   2.984  1.00  0.00           H  
ATOM   1427 HD22 LEU A  92       0.337  -0.774   3.636  1.00  0.00           H  
ATOM   1428 HD23 LEU A  92       2.043  -1.206   3.542  1.00  0.00           H  
ATOM   1429  N   ILE A  93       1.444   2.487   2.397  1.00  0.00           N  
ATOM   1430  CA  ILE A  93       1.214   2.414   0.948  1.00  0.00           C  
ATOM   1431  C   ILE A  93       1.937   1.196   0.347  1.00  0.00           C  
ATOM   1432  O   ILE A  93       3.146   1.048   0.510  1.00  0.00           O  
ATOM   1433  CB  ILE A  93       1.720   3.697   0.231  1.00  0.00           C  
ATOM   1434  CG1 ILE A  93       1.050   4.954   0.818  1.00  0.00           C  
ATOM   1435  CG2 ILE A  93       1.475   3.608  -1.276  1.00  0.00           C  
ATOM   1436  CD1 ILE A  93       1.505   6.253   0.178  1.00  0.00           C  
ATOM   1437  H   ILE A  93       2.361   2.413   2.732  1.00  0.00           H  
ATOM   1438  HA  ILE A  93       0.149   2.316   0.773  1.00  0.00           H  
ATOM   1439  HB  ILE A  93       2.788   3.765   0.388  1.00  0.00           H  
ATOM   1440 HG12 ILE A  93      -0.020   4.880   0.684  1.00  0.00           H  
ATOM   1441 HG13 ILE A  93       1.269   5.012   1.875  1.00  0.00           H  
ATOM   1442 HG21 ILE A  93       1.852   4.500  -1.757  1.00  0.00           H  
ATOM   1443 HG22 ILE A  93       0.415   3.518  -1.466  1.00  0.00           H  
ATOM   1444 HG23 ILE A  93       1.986   2.742  -1.675  1.00  0.00           H  
ATOM   1445 HD11 ILE A  93       1.005   7.082   0.655  1.00  0.00           H  
ATOM   1446 HD12 ILE A  93       1.259   6.244  -0.873  1.00  0.00           H  
ATOM   1447 HD13 ILE A  93       2.573   6.361   0.297  1.00  0.00           H  
ATOM   1448  N   TYR A  94       1.202   0.326  -0.343  1.00  0.00           N  
ATOM   1449  CA  TYR A  94       1.806  -0.857  -0.976  1.00  0.00           C  
ATOM   1450  C   TYR A  94       1.392  -0.976  -2.452  1.00  0.00           C  
ATOM   1451  O   TYR A  94       0.310  -0.538  -2.841  1.00  0.00           O  
ATOM   1452  CB  TYR A  94       1.446  -2.137  -0.199  1.00  0.00           C  
ATOM   1453  CG  TYR A  94      -0.039  -2.459  -0.129  1.00  0.00           C  
ATOM   1454  CD1 TYR A  94      -0.576  -3.525  -0.848  1.00  0.00           C  
ATOM   1455  CD2 TYR A  94      -0.899  -1.712   0.669  1.00  0.00           C  
ATOM   1456  CE1 TYR A  94      -1.923  -3.834  -0.771  1.00  0.00           C  
ATOM   1457  CE2 TYR A  94      -2.246  -2.013   0.746  1.00  0.00           C  
ATOM   1458  CZ  TYR A  94      -2.753  -3.075   0.028  1.00  0.00           C  
ATOM   1459  OH  TYR A  94      -4.093  -3.379   0.112  1.00  0.00           O  
ATOM   1460  H   TYR A  94       0.237   0.482  -0.437  1.00  0.00           H  
ATOM   1461  HA  TYR A  94       2.880  -0.728  -0.941  1.00  0.00           H  
ATOM   1462  HB2 TYR A  94       1.941  -2.977  -0.664  1.00  0.00           H  
ATOM   1463  HB3 TYR A  94       1.809  -2.040   0.816  1.00  0.00           H  
ATOM   1464  HD1 TYR A  94       0.075  -4.118  -1.474  1.00  0.00           H  
ATOM   1465  HD2 TYR A  94      -0.502  -0.879   1.231  1.00  0.00           H  
ATOM   1466  HE1 TYR A  94      -2.318  -4.665  -1.337  1.00  0.00           H  
ATOM   1467  HE2 TYR A  94      -2.896  -1.419   1.372  1.00  0.00           H  
ATOM   1468  HH  TYR A  94      -4.609  -2.634  -0.199  1.00  0.00           H  
ATOM   1469  N   SER A  95       2.264  -1.561  -3.274  1.00  0.00           N  
ATOM   1470  CA  SER A  95       2.023  -1.653  -4.727  1.00  0.00           C  
ATOM   1471  C   SER A  95       2.096  -3.098  -5.240  1.00  0.00           C  
ATOM   1472  O   SER A  95       2.888  -3.912  -4.754  1.00  0.00           O  
ATOM   1473  CB  SER A  95       3.031  -0.783  -5.491  1.00  0.00           C  
ATOM   1474  OG  SER A  95       4.372  -1.152  -5.193  1.00  0.00           O  
ATOM   1475  H   SER A  95       3.091  -1.940  -2.901  1.00  0.00           H  
ATOM   1476  HA  SER A  95       1.027  -1.275  -4.920  1.00  0.00           H  
ATOM   1477  HB2 SER A  95       2.870  -0.895  -6.554  1.00  0.00           H  
ATOM   1478  HB3 SER A  95       2.888   0.253  -5.216  1.00  0.00           H  
ATOM   1479  HG  SER A  95       4.963  -0.445  -5.459  1.00  0.00           H  
ATOM   1480  N   ILE A  96       1.263  -3.409  -6.234  1.00  0.00           N  
ATOM   1481  CA  ILE A  96       1.219  -4.754  -6.821  1.00  0.00           C  
ATOM   1482  C   ILE A  96       2.265  -4.916  -7.944  1.00  0.00           C  
ATOM   1483  O   ILE A  96       1.968  -4.693  -9.121  1.00  0.00           O  
ATOM   1484  CB  ILE A  96      -0.192  -5.073  -7.388  1.00  0.00           C  
ATOM   1485  CG1 ILE A  96      -1.282  -4.794  -6.336  1.00  0.00           C  
ATOM   1486  CG2 ILE A  96      -0.266  -6.523  -7.869  1.00  0.00           C  
ATOM   1487  CD1 ILE A  96      -1.151  -5.615  -5.070  1.00  0.00           C  
ATOM   1488  H   ILE A  96       0.653  -2.718  -6.577  1.00  0.00           H  
ATOM   1489  HA  ILE A  96       1.436  -5.467  -6.037  1.00  0.00           H  
ATOM   1490  HB  ILE A  96      -0.361  -4.432  -8.243  1.00  0.00           H  
ATOM   1491 HG12 ILE A  96      -1.240  -3.752  -6.054  1.00  0.00           H  
ATOM   1492 HG13 ILE A  96      -2.251  -5.003  -6.767  1.00  0.00           H  
ATOM   1493 HG21 ILE A  96       0.468  -6.684  -8.645  1.00  0.00           H  
ATOM   1494 HG22 ILE A  96      -1.252  -6.724  -8.261  1.00  0.00           H  
ATOM   1495 HG23 ILE A  96      -0.067  -7.191  -7.042  1.00  0.00           H  
ATOM   1496 HD11 ILE A  96      -1.963  -5.373  -4.401  1.00  0.00           H  
ATOM   1497 HD12 ILE A  96      -0.209  -5.392  -4.589  1.00  0.00           H  
ATOM   1498 HD13 ILE A  96      -1.191  -6.667  -5.316  1.00  0.00           H  
ATOM   1499  N   ARG A  97       3.492  -5.289  -7.558  1.00  0.00           N  
ATOM   1500  CA  ARG A  97       4.618  -5.487  -8.499  1.00  0.00           C  
ATOM   1501  C   ARG A  97       4.710  -4.346  -9.538  1.00  0.00           C  
ATOM   1502  O   ARG A  97       4.164  -4.448 -10.641  1.00  0.00           O  
ATOM   1503  CB  ARG A  97       4.507  -6.853  -9.213  1.00  0.00           C  
ATOM   1504  CG  ARG A  97       5.850  -7.486  -9.612  1.00  0.00           C  
ATOM   1505  CD  ARG A  97       6.654  -6.636 -10.600  1.00  0.00           C  
ATOM   1506  NE  ARG A  97       5.926  -6.388 -11.845  1.00  0.00           N  
ATOM   1507  CZ  ARG A  97       6.492  -6.170 -13.005  1.00  0.00           C  
ATOM   1508  NH1 ARG A  97       7.782  -6.204 -13.141  1.00  0.00           N  
ATOM   1509  NH2 ARG A  97       5.751  -5.933 -14.039  1.00  0.00           N  
ATOM   1510  H   ARG A  97       3.652  -5.431  -6.602  1.00  0.00           H  
ATOM   1511  HA  ARG A  97       5.526  -5.480  -7.911  1.00  0.00           H  
ATOM   1512  HB2 ARG A  97       3.996  -7.543  -8.557  1.00  0.00           H  
ATOM   1513  HB3 ARG A  97       3.914  -6.728 -10.109  1.00  0.00           H  
ATOM   1514  HG2 ARG A  97       6.444  -7.626  -8.721  1.00  0.00           H  
ATOM   1515  HG3 ARG A  97       5.657  -8.452 -10.062  1.00  0.00           H  
ATOM   1516  HD2 ARG A  97       6.880  -5.688 -10.134  1.00  0.00           H  
ATOM   1517  HD3 ARG A  97       7.577  -7.151 -10.827  1.00  0.00           H  
ATOM   1518  HE  ARG A  97       4.948  -6.370 -11.801  1.00  0.00           H  
ATOM   1519 HH11 ARG A  97       8.367  -6.402 -12.357  1.00  0.00           H  
ATOM   1520 HH12 ARG A  97       8.191  -6.032 -14.035  1.00  0.00           H  
ATOM   1521 HH21 ARG A  97       4.759  -5.920 -13.943  1.00  0.00           H  
ATOM   1522 HH22 ARG A  97       6.171  -5.771 -14.930  1.00  0.00           H  
ATOM   1523  N   PRO A  98       5.404  -3.248  -9.200  1.00  0.00           N  
ATOM   1524  CA  PRO A  98       5.545  -2.098 -10.095  1.00  0.00           C  
ATOM   1525  C   PRO A  98       6.761  -2.212 -11.039  1.00  0.00           C  
ATOM   1526  O   PRO A  98       7.725  -2.922 -10.738  1.00  0.00           O  
ATOM   1527  CB  PRO A  98       5.721  -0.940  -9.105  1.00  0.00           C  
ATOM   1528  CG  PRO A  98       6.388  -1.541  -7.903  1.00  0.00           C  
ATOM   1529  CD  PRO A  98       6.107  -3.030  -7.924  1.00  0.00           C  
ATOM   1530  HA  PRO A  98       4.650  -1.940 -10.681  1.00  0.00           H  
ATOM   1531  HB2 PRO A  98       6.332  -0.167  -9.552  1.00  0.00           H  
ATOM   1532  HB3 PRO A  98       4.752  -0.532  -8.853  1.00  0.00           H  
ATOM   1533  HG2 PRO A  98       7.454  -1.363  -7.951  1.00  0.00           H  
ATOM   1534  HG3 PRO A  98       5.983  -1.099  -7.002  1.00  0.00           H  
ATOM   1535  HD2 PRO A  98       7.034  -3.588  -7.900  1.00  0.00           H  
ATOM   1536  HD3 PRO A  98       5.481  -3.309  -7.088  1.00  0.00           H  
ATOM   1537  N   PRO A  99       6.719  -1.531 -12.209  1.00  0.00           N  
ATOM   1538  CA  PRO A  99       7.859  -1.488 -13.147  1.00  0.00           C  
ATOM   1539  C   PRO A  99       9.172  -1.065 -12.464  1.00  0.00           C  
ATOM   1540  O   PRO A  99       9.168  -0.197 -11.590  1.00  0.00           O  
ATOM   1541  CB  PRO A  99       7.431  -0.433 -14.173  1.00  0.00           C  
ATOM   1542  CG  PRO A  99       5.940  -0.461 -14.143  1.00  0.00           C  
ATOM   1543  CD  PRO A  99       5.559  -0.770 -12.718  1.00  0.00           C  
ATOM   1544  HA  PRO A  99       8.000  -2.440 -13.639  1.00  0.00           H  
ATOM   1545  HB2 PRO A  99       7.817   0.535 -13.881  1.00  0.00           H  
ATOM   1546  HB3 PRO A  99       7.813  -0.695 -15.148  1.00  0.00           H  
ATOM   1547  HG2 PRO A  99       5.547   0.502 -14.437  1.00  0.00           H  
ATOM   1548  HG3 PRO A  99       5.575  -1.233 -14.805  1.00  0.00           H  
ATOM   1549  HD2 PRO A  99       5.422   0.143 -12.155  1.00  0.00           H  
ATOM   1550  HD3 PRO A  99       4.660  -1.370 -12.688  1.00  0.00           H  
ATOM   1551  N   ALA A 100      10.293  -1.645 -12.905  1.00  0.00           N  
ATOM   1552  CA  ALA A 100      11.601  -1.464 -12.242  1.00  0.00           C  
ATOM   1553  C   ALA A 100      12.229  -0.080 -12.508  1.00  0.00           C  
ATOM   1554  O   ALA A 100      13.429   0.035 -12.773  1.00  0.00           O  
ATOM   1555  CB  ALA A 100      12.552  -2.571 -12.689  1.00  0.00           C  
ATOM   1556  H   ALA A 100      10.245  -2.208 -13.707  1.00  0.00           H  
ATOM   1557  HA  ALA A 100      11.448  -1.572 -11.177  1.00  0.00           H  
ATOM   1558  HB1 ALA A 100      12.756  -2.468 -13.745  1.00  0.00           H  
ATOM   1559  HB2 ALA A 100      12.098  -3.534 -12.504  1.00  0.00           H  
ATOM   1560  HB3 ALA A 100      13.478  -2.500 -12.135  1.00  0.00           H  
ATOM   1561  N   GLU A 101      11.423   0.972 -12.412  1.00  0.00           N  
ATOM   1562  CA  GLU A 101      11.910   2.338 -12.612  1.00  0.00           C  
ATOM   1563  C   GLU A 101      11.249   3.329 -11.636  1.00  0.00           C  
ATOM   1564  O   GLU A 101      11.855   4.334 -11.264  1.00  0.00           O  
ATOM   1565  CB  GLU A 101      11.647   2.787 -14.058  1.00  0.00           C  
ATOM   1566  CG  GLU A 101      10.165   2.918 -14.401  1.00  0.00           C  
ATOM   1567  CD  GLU A 101       9.923   3.409 -15.820  1.00  0.00           C  
ATOM   1568  OE1 GLU A 101      10.481   4.462 -16.193  1.00  0.00           O  
ATOM   1569  OE2 GLU A 101       9.159   2.754 -16.560  1.00  0.00           O  
ATOM   1570  H   GLU A 101      10.483   0.828 -12.210  1.00  0.00           H  
ATOM   1571  HA  GLU A 101      12.977   2.342 -12.435  1.00  0.00           H  
ATOM   1572  HB2 GLU A 101      12.120   3.747 -14.216  1.00  0.00           H  
ATOM   1573  HB3 GLU A 101      12.088   2.066 -14.732  1.00  0.00           H  
ATOM   1574  HG2 GLU A 101       9.695   1.952 -14.283  1.00  0.00           H  
ATOM   1575  HG3 GLU A 101       9.712   3.619 -13.713  1.00  0.00           H  
ATOM   1576  N   ILE A 102      10.014   3.038 -11.210  1.00  0.00           N  
ATOM   1577  CA  ILE A 102       9.219   3.996 -10.420  1.00  0.00           C  
ATOM   1578  C   ILE A 102       9.374   3.818  -8.897  1.00  0.00           C  
ATOM   1579  O   ILE A 102       8.921   4.668  -8.129  1.00  0.00           O  
ATOM   1580  CB  ILE A 102       7.713   3.910 -10.776  1.00  0.00           C  
ATOM   1581  CG1 ILE A 102       7.163   2.503 -10.483  1.00  0.00           C  
ATOM   1582  CG2 ILE A 102       7.481   4.290 -12.239  1.00  0.00           C  
ATOM   1583  CD1 ILE A 102       5.674   2.365 -10.736  1.00  0.00           C  
ATOM   1584  H   ILE A 102       9.627   2.164 -11.431  1.00  0.00           H  
ATOM   1585  HA  ILE A 102       9.559   4.990 -10.679  1.00  0.00           H  
ATOM   1586  HB  ILE A 102       7.186   4.625 -10.162  1.00  0.00           H  
ATOM   1587 HG12 ILE A 102       7.670   1.785 -11.111  1.00  0.00           H  
ATOM   1588 HG13 ILE A 102       7.347   2.259  -9.447  1.00  0.00           H  
ATOM   1589 HG21 ILE A 102       7.809   5.306 -12.405  1.00  0.00           H  
ATOM   1590 HG22 ILE A 102       6.428   4.210 -12.470  1.00  0.00           H  
ATOM   1591 HG23 ILE A 102       8.040   3.622 -12.879  1.00  0.00           H  
ATOM   1592 HD11 ILE A 102       5.136   3.071 -10.120  1.00  0.00           H  
ATOM   1593 HD12 ILE A 102       5.360   1.361 -10.490  1.00  0.00           H  
ATOM   1594 HD13 ILE A 102       5.464   2.561 -11.777  1.00  0.00           H  
ATOM   1595  N   HIS A 103      10.001   2.725  -8.466  1.00  0.00           N  
ATOM   1596  CA  HIS A 103      10.195   2.446  -7.029  1.00  0.00           C  
ATOM   1597  C   HIS A 103      10.772   3.659  -6.274  1.00  0.00           C  
ATOM   1598  O   HIS A 103      10.244   4.066  -5.234  1.00  0.00           O  
ATOM   1599  CB  HIS A 103      11.127   1.247  -6.849  1.00  0.00           C  
ATOM   1600  CG  HIS A 103      10.627  -0.018  -7.475  1.00  0.00           C  
ATOM   1601  ND1 HIS A 103      10.269  -0.066  -8.798  1.00  0.00           N  
ATOM   1602  CD2 HIS A 103      10.453  -1.246  -6.926  1.00  0.00           C  
ATOM   1603  CE1 HIS A 103       9.891  -1.311  -9.023  1.00  0.00           C  
ATOM   1604  NE2 HIS A 103       9.983  -2.064  -7.921  1.00  0.00           N  
ATOM   1605  H   HIS A 103      10.334   2.076  -9.123  1.00  0.00           H  
ATOM   1606  HA  HIS A 103       9.229   2.202  -6.607  1.00  0.00           H  
ATOM   1607  HB2 HIS A 103      12.083   1.477  -7.295  1.00  0.00           H  
ATOM   1608  HB3 HIS A 103      11.266   1.064  -5.793  1.00  0.00           H  
ATOM   1609  HD2 HIS A 103      10.649  -1.530  -5.903  1.00  0.00           H  
ATOM   1610  HE1 HIS A 103       9.550  -1.677  -9.979  1.00  0.00           H  
ATOM   1611  HE2 HIS A 103      10.006  -3.040  -7.906  1.00  0.00           H  
ATOM   1612  N   SER A 104      11.852   4.234  -6.805  1.00  0.00           N  
ATOM   1613  CA  SER A 104      12.486   5.417  -6.196  1.00  0.00           C  
ATOM   1614  C   SER A 104      11.494   6.587  -6.046  1.00  0.00           C  
ATOM   1615  O   SER A 104      11.584   7.372  -5.096  1.00  0.00           O  
ATOM   1616  CB  SER A 104      13.698   5.867  -7.022  1.00  0.00           C  
ATOM   1617  OG  SER A 104      13.336   6.154  -8.364  1.00  0.00           O  
ATOM   1618  H   SER A 104      12.244   3.847  -7.616  1.00  0.00           H  
ATOM   1619  HA  SER A 104      12.829   5.130  -5.211  1.00  0.00           H  
ATOM   1620  HB2 SER A 104      14.123   6.757  -6.581  1.00  0.00           H  
ATOM   1621  HB3 SER A 104      14.440   5.081  -7.025  1.00  0.00           H  
ATOM   1622  HG  SER A 104      14.099   5.995  -8.937  1.00  0.00           H  
ATOM   1623  N   SER A 105      10.547   6.699  -6.983  1.00  0.00           N  
ATOM   1624  CA  SER A 105       9.483   7.715  -6.894  1.00  0.00           C  
ATOM   1625  C   SER A 105       8.472   7.344  -5.807  1.00  0.00           C  
ATOM   1626  O   SER A 105       8.028   8.195  -5.041  1.00  0.00           O  
ATOM   1627  CB  SER A 105       8.760   7.891  -8.241  1.00  0.00           C  
ATOM   1628  OG  SER A 105       9.614   8.471  -9.215  1.00  0.00           O  
ATOM   1629  H   SER A 105      10.559   6.085  -7.747  1.00  0.00           H  
ATOM   1630  HA  SER A 105       9.948   8.654  -6.623  1.00  0.00           H  
ATOM   1631  HB2 SER A 105       8.430   6.927  -8.601  1.00  0.00           H  
ATOM   1632  HB3 SER A 105       7.902   8.535  -8.107  1.00  0.00           H  
ATOM   1633  HG  SER A 105      10.034   7.774  -9.729  1.00  0.00           H  
ATOM   1634  N   LEU A 106       8.127   6.063  -5.733  1.00  0.00           N  
ATOM   1635  CA  LEU A 106       7.234   5.562  -4.687  1.00  0.00           C  
ATOM   1636  C   LEU A 106       7.789   5.885  -3.290  1.00  0.00           C  
ATOM   1637  O   LEU A 106       7.044   6.270  -2.384  1.00  0.00           O  
ATOM   1638  CB  LEU A 106       7.048   4.047  -4.848  1.00  0.00           C  
ATOM   1639  CG  LEU A 106       6.336   3.599  -6.139  1.00  0.00           C  
ATOM   1640  CD1 LEU A 106       6.250   2.076  -6.210  1.00  0.00           C  
ATOM   1641  CD2 LEU A 106       4.944   4.220  -6.232  1.00  0.00           C  
ATOM   1642  H   LEU A 106       8.484   5.433  -6.396  1.00  0.00           H  
ATOM   1643  HA  LEU A 106       6.276   6.050  -4.806  1.00  0.00           H  
ATOM   1644  HB2 LEU A 106       8.027   3.587  -4.828  1.00  0.00           H  
ATOM   1645  HB3 LEU A 106       6.483   3.682  -4.005  1.00  0.00           H  
ATOM   1646  HG  LEU A 106       6.908   3.936  -6.993  1.00  0.00           H  
ATOM   1647 HD11 LEU A 106       5.682   1.704  -5.368  1.00  0.00           H  
ATOM   1648 HD12 LEU A 106       7.245   1.658  -6.185  1.00  0.00           H  
ATOM   1649 HD13 LEU A 106       5.762   1.784  -7.129  1.00  0.00           H  
ATOM   1650 HD21 LEU A 106       4.351   3.911  -5.383  1.00  0.00           H  
ATOM   1651 HD22 LEU A 106       4.464   3.894  -7.143  1.00  0.00           H  
ATOM   1652 HD23 LEU A 106       5.029   5.297  -6.239  1.00  0.00           H  
ATOM   1653  N   MET A 107       9.107   5.739  -3.133  1.00  0.00           N  
ATOM   1654  CA  MET A 107       9.784   6.055  -1.870  1.00  0.00           C  
ATOM   1655  C   MET A 107       9.578   7.523  -1.462  1.00  0.00           C  
ATOM   1656  O   MET A 107       9.241   7.815  -0.315  1.00  0.00           O  
ATOM   1657  CB  MET A 107      11.290   5.767  -1.969  1.00  0.00           C  
ATOM   1658  CG  MET A 107      11.636   4.312  -2.262  1.00  0.00           C  
ATOM   1659  SD  MET A 107      13.415   4.006  -2.228  1.00  0.00           S  
ATOM   1660  CE  MET A 107      13.786   4.366  -0.511  1.00  0.00           C  
ATOM   1661  H   MET A 107       9.636   5.397  -3.887  1.00  0.00           H  
ATOM   1662  HA  MET A 107       9.360   5.421  -1.103  1.00  0.00           H  
ATOM   1663  HB2 MET A 107      11.708   6.377  -2.758  1.00  0.00           H  
ATOM   1664  HB3 MET A 107      11.758   6.042  -1.033  1.00  0.00           H  
ATOM   1665  HG2 MET A 107      11.164   3.684  -1.519  1.00  0.00           H  
ATOM   1666  HG3 MET A 107      11.260   4.054  -3.241  1.00  0.00           H  
ATOM   1667  HE1 MET A 107      13.538   5.395  -0.297  1.00  0.00           H  
ATOM   1668  HE2 MET A 107      14.838   4.204  -0.328  1.00  0.00           H  
ATOM   1669  HE3 MET A 107      13.206   3.715   0.128  1.00  0.00           H  
ATOM   1670  N   ARG A 108       9.792   8.448  -2.401  1.00  0.00           N  
ATOM   1671  CA  ARG A 108       9.663   9.883  -2.106  1.00  0.00           C  
ATOM   1672  C   ARG A 108       8.198  10.297  -1.893  1.00  0.00           C  
ATOM   1673  O   ARG A 108       7.922  11.270  -1.195  1.00  0.00           O  
ATOM   1674  CB  ARG A 108      10.306  10.746  -3.206  1.00  0.00           C  
ATOM   1675  CG  ARG A 108       9.675  10.593  -4.585  1.00  0.00           C  
ATOM   1676  CD  ARG A 108      10.262  11.583  -5.585  1.00  0.00           C  
ATOM   1677  NE  ARG A 108       9.982  12.965  -5.202  1.00  0.00           N  
ATOM   1678  CZ  ARG A 108      10.893  13.881  -5.018  1.00  0.00           C  
ATOM   1679  NH1 ARG A 108      12.150  13.601  -5.169  1.00  0.00           N  
ATOM   1680  NH2 ARG A 108      10.542  15.078  -4.679  1.00  0.00           N  
ATOM   1681  H   ARG A 108      10.043   8.161  -3.305  1.00  0.00           H  
ATOM   1682  HA  ARG A 108      10.194  10.063  -1.180  1.00  0.00           H  
ATOM   1683  HB2 ARG A 108      10.234  11.786  -2.916  1.00  0.00           H  
ATOM   1684  HB3 ARG A 108      11.352  10.480  -3.281  1.00  0.00           H  
ATOM   1685  HG2 ARG A 108       9.852   9.589  -4.942  1.00  0.00           H  
ATOM   1686  HG3 ARG A 108       8.611  10.765  -4.506  1.00  0.00           H  
ATOM   1687  HD2 ARG A 108      11.332  11.438  -5.638  1.00  0.00           H  
ATOM   1688  HD3 ARG A 108       9.827  11.396  -6.557  1.00  0.00           H  
ATOM   1689  HE  ARG A 108       9.044  13.215  -5.077  1.00  0.00           H  
ATOM   1690 HH11 ARG A 108      12.427  12.684  -5.427  1.00  0.00           H  
ATOM   1691 HH12 ARG A 108      12.839  14.310  -5.019  1.00  0.00           H  
ATOM   1692 HH21 ARG A 108       9.577  15.299  -4.556  1.00  0.00           H  
ATOM   1693 HH22 ARG A 108      11.238  15.782  -4.546  1.00  0.00           H  
ATOM   1694  N   VAL A 109       7.261   9.563  -2.498  1.00  0.00           N  
ATOM   1695  CA  VAL A 109       5.831   9.780  -2.235  1.00  0.00           C  
ATOM   1696  C   VAL A 109       5.496   9.416  -0.783  1.00  0.00           C  
ATOM   1697  O   VAL A 109       4.915  10.217  -0.047  1.00  0.00           O  
ATOM   1698  CB  VAL A 109       4.935   8.948  -3.189  1.00  0.00           C  
ATOM   1699  CG1 VAL A 109       3.454   9.113  -2.840  1.00  0.00           C  
ATOM   1700  CG2 VAL A 109       5.190   9.335  -4.646  1.00  0.00           C  
ATOM   1701  H   VAL A 109       7.532   8.868  -3.136  1.00  0.00           H  
ATOM   1702  HA  VAL A 109       5.618  10.830  -2.391  1.00  0.00           H  
ATOM   1703  HB  VAL A 109       5.193   7.904  -3.066  1.00  0.00           H  
ATOM   1704 HG11 VAL A 109       2.856   8.509  -3.508  1.00  0.00           H  
ATOM   1705 HG12 VAL A 109       3.169  10.150  -2.943  1.00  0.00           H  
ATOM   1706 HG13 VAL A 109       3.285   8.794  -1.821  1.00  0.00           H  
ATOM   1707 HG21 VAL A 109       4.936  10.375  -4.795  1.00  0.00           H  
ATOM   1708 HG22 VAL A 109       4.583   8.721  -5.295  1.00  0.00           H  
ATOM   1709 HG23 VAL A 109       6.233   9.182  -4.883  1.00  0.00           H  
ATOM   1710  N   ALA A 110       5.886   8.207  -0.375  1.00  0.00           N  
ATOM   1711  CA  ALA A 110       5.703   7.759   1.008  1.00  0.00           C  
ATOM   1712  C   ALA A 110       6.450   8.677   1.988  1.00  0.00           C  
ATOM   1713  O   ALA A 110       5.978   8.941   3.094  1.00  0.00           O  
ATOM   1714  CB  ALA A 110       6.174   6.317   1.165  1.00  0.00           C  
ATOM   1715  H   ALA A 110       6.307   7.599  -1.023  1.00  0.00           H  
ATOM   1716  HA  ALA A 110       4.644   7.794   1.228  1.00  0.00           H  
ATOM   1717  HB1 ALA A 110       7.237   6.262   0.976  1.00  0.00           H  
ATOM   1718  HB2 ALA A 110       5.651   5.687   0.460  1.00  0.00           H  
ATOM   1719  HB3 ALA A 110       5.970   5.977   2.172  1.00  0.00           H  
ATOM   1720  N   ASP A 111       7.617   9.162   1.563  1.00  0.00           N  
ATOM   1721  CA  ASP A 111       8.422  10.091   2.364  1.00  0.00           C  
ATOM   1722  C   ASP A 111       7.747  11.472   2.460  1.00  0.00           C  
ATOM   1723  O   ASP A 111       7.796  12.131   3.499  1.00  0.00           O  
ATOM   1724  CB  ASP A 111       9.824  10.224   1.747  1.00  0.00           C  
ATOM   1725  CG  ASP A 111      10.809  10.926   2.666  1.00  0.00           C  
ATOM   1726  OD1 ASP A 111      11.061  12.137   2.480  1.00  0.00           O  
ATOM   1727  OD2 ASP A 111      11.336  10.268   3.589  1.00  0.00           O  
ATOM   1728  H   ASP A 111       7.954   8.876   0.688  1.00  0.00           H  
ATOM   1729  HA  ASP A 111       8.513   9.678   3.358  1.00  0.00           H  
ATOM   1730  HB2 ASP A 111      10.207   9.238   1.527  1.00  0.00           H  
ATOM   1731  HB3 ASP A 111       9.751  10.786   0.825  1.00  0.00           H  
ATOM   1732  N   ALA A 112       7.114  11.896   1.370  1.00  0.00           N  
ATOM   1733  CA  ALA A 112       6.418  13.187   1.325  1.00  0.00           C  
ATOM   1734  C   ALA A 112       5.141  13.183   2.180  1.00  0.00           C  
ATOM   1735  O   ALA A 112       4.803  14.187   2.810  1.00  0.00           O  
ATOM   1736  CB  ALA A 112       6.078  13.549  -0.116  1.00  0.00           C  
ATOM   1737  H   ALA A 112       7.123  11.332   0.568  1.00  0.00           H  
ATOM   1738  HA  ALA A 112       7.092  13.943   1.708  1.00  0.00           H  
ATOM   1739  HB1 ALA A 112       6.984  13.589  -0.702  1.00  0.00           H  
ATOM   1740  HB2 ALA A 112       5.590  14.512  -0.141  1.00  0.00           H  
ATOM   1741  HB3 ALA A 112       5.417  12.800  -0.528  1.00  0.00           H  
ATOM   1742  N   VAL A 113       4.428  12.058   2.182  1.00  0.00           N  
ATOM   1743  CA  VAL A 113       3.170  11.937   2.932  1.00  0.00           C  
ATOM   1744  C   VAL A 113       3.395  11.445   4.374  1.00  0.00           C  
ATOM   1745  O   VAL A 113       2.616  11.765   5.273  1.00  0.00           O  
ATOM   1746  CB  VAL A 113       2.177  10.986   2.215  1.00  0.00           C  
ATOM   1747  CG1 VAL A 113       1.939  11.448   0.778  1.00  0.00           C  
ATOM   1748  CG2 VAL A 113       2.669   9.538   2.248  1.00  0.00           C  
ATOM   1749  H   VAL A 113       4.748  11.292   1.658  1.00  0.00           H  
ATOM   1750  HA  VAL A 113       2.717  12.919   2.973  1.00  0.00           H  
ATOM   1751  HB  VAL A 113       1.231  11.032   2.739  1.00  0.00           H  
ATOM   1752 HG11 VAL A 113       1.248  10.775   0.289  1.00  0.00           H  
ATOM   1753 HG12 VAL A 113       2.877  11.455   0.240  1.00  0.00           H  
ATOM   1754 HG13 VAL A 113       1.522  12.446   0.786  1.00  0.00           H  
ATOM   1755 HG21 VAL A 113       1.962   8.902   1.734  1.00  0.00           H  
ATOM   1756 HG22 VAL A 113       2.766   9.211   3.274  1.00  0.00           H  
ATOM   1757 HG23 VAL A 113       3.631   9.473   1.759  1.00  0.00           H  
ATOM   1758  N   GLY A 114       4.462  10.674   4.586  1.00  0.00           N  
ATOM   1759  CA  GLY A 114       4.748  10.117   5.907  1.00  0.00           C  
ATOM   1760  C   GLY A 114       4.053   8.779   6.151  1.00  0.00           C  
ATOM   1761  O   GLY A 114       3.212   8.662   7.044  1.00  0.00           O  
ATOM   1762  H   GLY A 114       5.060  10.478   3.837  1.00  0.00           H  
ATOM   1763  HA2 GLY A 114       5.816   9.975   5.999  1.00  0.00           H  
ATOM   1764  HA3 GLY A 114       4.426  10.822   6.662  1.00  0.00           H  
ATOM   1765  N   ALA A 115       4.407   7.770   5.355  1.00  0.00           N  
ATOM   1766  CA  ALA A 115       3.782   6.442   5.448  1.00  0.00           C  
ATOM   1767  C   ALA A 115       4.790   5.314   5.171  1.00  0.00           C  
ATOM   1768  O   ALA A 115       5.893   5.555   4.677  1.00  0.00           O  
ATOM   1769  CB  ALA A 115       2.611   6.353   4.471  1.00  0.00           C  
ATOM   1770  H   ALA A 115       5.108   7.919   4.684  1.00  0.00           H  
ATOM   1771  HA  ALA A 115       3.393   6.320   6.451  1.00  0.00           H  
ATOM   1772  HB1 ALA A 115       2.129   5.390   4.568  1.00  0.00           H  
ATOM   1773  HB2 ALA A 115       2.975   6.472   3.461  1.00  0.00           H  
ATOM   1774  HB3 ALA A 115       1.898   7.135   4.691  1.00  0.00           H  
ATOM   1775  N   ARG A 116       4.410   4.074   5.490  1.00  0.00           N  
ATOM   1776  CA  ARG A 116       5.275   2.917   5.234  1.00  0.00           C  
ATOM   1777  C   ARG A 116       5.037   2.351   3.828  1.00  0.00           C  
ATOM   1778  O   ARG A 116       3.940   1.892   3.515  1.00  0.00           O  
ATOM   1779  CB  ARG A 116       5.031   1.814   6.275  1.00  0.00           C  
ATOM   1780  CG  ARG A 116       5.953   0.604   6.111  1.00  0.00           C  
ATOM   1781  CD  ARG A 116       5.555  -0.556   7.021  1.00  0.00           C  
ATOM   1782  NE  ARG A 116       5.487  -0.170   8.432  1.00  0.00           N  
ATOM   1783  CZ  ARG A 116       6.044  -0.846   9.405  1.00  0.00           C  
ATOM   1784  NH1 ARG A 116       6.788  -1.876   9.152  1.00  0.00           N  
ATOM   1785  NH2 ARG A 116       5.868  -0.474  10.633  1.00  0.00           N  
ATOM   1786  H   ARG A 116       3.530   3.933   5.906  1.00  0.00           H  
ATOM   1787  HA  ARG A 116       6.302   3.246   5.309  1.00  0.00           H  
ATOM   1788  HB2 ARG A 116       5.183   2.227   7.263  1.00  0.00           H  
ATOM   1789  HB3 ARG A 116       4.007   1.475   6.190  1.00  0.00           H  
ATOM   1790  HG2 ARG A 116       5.909   0.268   5.085  1.00  0.00           H  
ATOM   1791  HG3 ARG A 116       6.967   0.900   6.346  1.00  0.00           H  
ATOM   1792  HD2 ARG A 116       4.585  -0.918   6.713  1.00  0.00           H  
ATOM   1793  HD3 ARG A 116       6.283  -1.347   6.905  1.00  0.00           H  
ATOM   1794  HE  ARG A 116       4.966   0.621   8.658  1.00  0.00           H  
ATOM   1795 HH11 ARG A 116       6.945  -2.165   8.204  1.00  0.00           H  
ATOM   1796 HH12 ARG A 116       7.205  -2.384   9.901  1.00  0.00           H  
ATOM   1797 HH21 ARG A 116       5.311   0.324  10.840  1.00  0.00           H  
ATOM   1798 HH22 ARG A 116       6.290  -0.995  11.373  1.00  0.00           H  
ATOM   1799  N   LEU A 117       6.067   2.377   2.992  1.00  0.00           N  
ATOM   1800  CA  LEU A 117       5.979   1.830   1.633  1.00  0.00           C  
ATOM   1801  C   LEU A 117       6.319   0.331   1.620  1.00  0.00           C  
ATOM   1802  O   LEU A 117       7.369  -0.072   2.106  1.00  0.00           O  
ATOM   1803  CB  LEU A 117       6.936   2.583   0.695  1.00  0.00           C  
ATOM   1804  CG  LEU A 117       6.964   2.079  -0.758  1.00  0.00           C  
ATOM   1805  CD1 LEU A 117       5.624   2.325  -1.446  1.00  0.00           C  
ATOM   1806  CD2 LEU A 117       8.105   2.731  -1.535  1.00  0.00           C  
ATOM   1807  H   LEU A 117       6.912   2.773   3.292  1.00  0.00           H  
ATOM   1808  HA  LEU A 117       4.964   1.964   1.283  1.00  0.00           H  
ATOM   1809  HB2 LEU A 117       6.652   3.627   0.688  1.00  0.00           H  
ATOM   1810  HB3 LEU A 117       7.935   2.505   1.099  1.00  0.00           H  
ATOM   1811  HG  LEU A 117       7.136   1.011  -0.753  1.00  0.00           H  
ATOM   1812 HD11 LEU A 117       5.673   1.975  -2.467  1.00  0.00           H  
ATOM   1813 HD12 LEU A 117       5.400   3.383  -1.439  1.00  0.00           H  
ATOM   1814 HD13 LEU A 117       4.847   1.789  -0.921  1.00  0.00           H  
ATOM   1815 HD21 LEU A 117       9.046   2.502  -1.055  1.00  0.00           H  
ATOM   1816 HD22 LEU A 117       7.964   3.803  -1.556  1.00  0.00           H  
ATOM   1817 HD23 LEU A 117       8.117   2.351  -2.547  1.00  0.00           H  
ATOM   1818  N   ILE A 118       5.427  -0.491   1.072  1.00  0.00           N  
ATOM   1819  CA  ILE A 118       5.672  -1.935   0.947  1.00  0.00           C  
ATOM   1820  C   ILE A 118       5.624  -2.385  -0.521  1.00  0.00           C  
ATOM   1821  O   ILE A 118       4.574  -2.347  -1.164  1.00  0.00           O  
ATOM   1822  CB  ILE A 118       4.648  -2.763   1.769  1.00  0.00           C  
ATOM   1823  CG1 ILE A 118       4.744  -2.404   3.264  1.00  0.00           C  
ATOM   1824  CG2 ILE A 118       4.869  -4.264   1.557  1.00  0.00           C  
ATOM   1825  CD1 ILE A 118       3.804  -3.193   4.155  1.00  0.00           C  
ATOM   1826  H   ILE A 118       4.579  -0.123   0.745  1.00  0.00           H  
ATOM   1827  HA  ILE A 118       6.660  -2.141   1.340  1.00  0.00           H  
ATOM   1828  HB  ILE A 118       3.658  -2.518   1.410  1.00  0.00           H  
ATOM   1829 HG12 ILE A 118       5.751  -2.588   3.607  1.00  0.00           H  
ATOM   1830 HG13 ILE A 118       4.516  -1.354   3.389  1.00  0.00           H  
ATOM   1831 HG21 ILE A 118       4.767  -4.501   0.508  1.00  0.00           H  
ATOM   1832 HG22 ILE A 118       4.135  -4.821   2.121  1.00  0.00           H  
ATOM   1833 HG23 ILE A 118       5.859  -4.536   1.892  1.00  0.00           H  
ATOM   1834 HD11 ILE A 118       4.019  -4.248   4.065  1.00  0.00           H  
ATOM   1835 HD12 ILE A 118       2.782  -3.006   3.857  1.00  0.00           H  
ATOM   1836 HD13 ILE A 118       3.939  -2.887   5.182  1.00  0.00           H  
ATOM   1837  N   ILE A 119       6.769  -2.808  -1.048  1.00  0.00           N  
ATOM   1838  CA  ILE A 119       6.854  -3.296  -2.427  1.00  0.00           C  
ATOM   1839  C   ILE A 119       7.164  -4.801  -2.457  1.00  0.00           C  
ATOM   1840  O   ILE A 119       8.202  -5.246  -1.960  1.00  0.00           O  
ATOM   1841  CB  ILE A 119       7.934  -2.526  -3.233  1.00  0.00           C  
ATOM   1842  CG1 ILE A 119       7.591  -1.026  -3.284  1.00  0.00           C  
ATOM   1843  CG2 ILE A 119       8.072  -3.101  -4.645  1.00  0.00           C  
ATOM   1844  CD1 ILE A 119       8.622  -0.178  -4.004  1.00  0.00           C  
ATOM   1845  H   ILE A 119       7.581  -2.796  -0.496  1.00  0.00           H  
ATOM   1846  HA  ILE A 119       5.895  -3.129  -2.901  1.00  0.00           H  
ATOM   1847  HB  ILE A 119       8.881  -2.651  -2.729  1.00  0.00           H  
ATOM   1848 HG12 ILE A 119       6.645  -0.896  -3.789  1.00  0.00           H  
ATOM   1849 HG13 ILE A 119       7.504  -0.652  -2.274  1.00  0.00           H  
ATOM   1850 HG21 ILE A 119       7.130  -3.010  -5.167  1.00  0.00           H  
ATOM   1851 HG22 ILE A 119       8.349  -4.144  -4.586  1.00  0.00           H  
ATOM   1852 HG23 ILE A 119       8.836  -2.559  -5.183  1.00  0.00           H  
ATOM   1853 HD11 ILE A 119       9.577  -0.276  -3.509  1.00  0.00           H  
ATOM   1854 HD12 ILE A 119       8.311   0.857  -3.984  1.00  0.00           H  
ATOM   1855 HD13 ILE A 119       8.712  -0.507  -5.029  1.00  0.00           H  
ATOM   1856  N   LYS A 120       6.252  -5.583  -3.035  1.00  0.00           N  
ATOM   1857  CA  LYS A 120       6.437  -7.036  -3.145  1.00  0.00           C  
ATOM   1858  C   LYS A 120       6.620  -7.467  -4.614  1.00  0.00           C  
ATOM   1859  O   LYS A 120       5.644  -7.752  -5.314  1.00  0.00           O  
ATOM   1860  CB  LYS A 120       5.236  -7.774  -2.531  1.00  0.00           C  
ATOM   1861  CG  LYS A 120       5.456  -9.279  -2.364  1.00  0.00           C  
ATOM   1862  CD  LYS A 120       4.167 -10.009  -1.988  1.00  0.00           C  
ATOM   1863  CE  LYS A 120       3.169 -10.019  -3.140  1.00  0.00           C  
ATOM   1864  NZ  LYS A 120       3.653 -10.832  -4.289  1.00  0.00           N  
ATOM   1865  H   LYS A 120       5.434  -5.176  -3.391  1.00  0.00           H  
ATOM   1866  HA  LYS A 120       7.328  -7.301  -2.592  1.00  0.00           H  
ATOM   1867  HB2 LYS A 120       5.032  -7.353  -1.556  1.00  0.00           H  
ATOM   1868  HB3 LYS A 120       4.372  -7.623  -3.164  1.00  0.00           H  
ATOM   1869  HG2 LYS A 120       5.829  -9.684  -3.294  1.00  0.00           H  
ATOM   1870  HG3 LYS A 120       6.188  -9.439  -1.585  1.00  0.00           H  
ATOM   1871  HD2 LYS A 120       4.406 -11.030  -1.727  1.00  0.00           H  
ATOM   1872  HD3 LYS A 120       3.718  -9.515  -1.137  1.00  0.00           H  
ATOM   1873  HE2 LYS A 120       2.236 -10.435  -2.787  1.00  0.00           H  
ATOM   1874  HE3 LYS A 120       3.005  -9.002  -3.471  1.00  0.00           H  
ATOM   1875  HZ1 LYS A 120       3.601 -11.845  -4.057  1.00  0.00           H  
ATOM   1876  HZ2 LYS A 120       4.641 -10.594  -4.511  1.00  0.00           H  
ATOM   1877  HZ3 LYS A 120       3.069 -10.654  -5.130  1.00  0.00           H  
ATOM   1878  N   PRO A 121       7.872  -7.494  -5.111  1.00  0.00           N  
ATOM   1879  CA  PRO A 121       8.173  -7.922  -6.479  1.00  0.00           C  
ATOM   1880  C   PRO A 121       8.499  -9.423  -6.581  1.00  0.00           C  
ATOM   1881  O   PRO A 121       8.370 -10.167  -5.607  1.00  0.00           O  
ATOM   1882  CB  PRO A 121       9.405  -7.077  -6.798  1.00  0.00           C  
ATOM   1883  CG  PRO A 121      10.141  -6.981  -5.495  1.00  0.00           C  
ATOM   1884  CD  PRO A 121       9.101  -7.093  -4.395  1.00  0.00           C  
ATOM   1885  HA  PRO A 121       7.373  -7.677  -7.163  1.00  0.00           H  
ATOM   1886  HB2 PRO A 121      10.001  -7.567  -7.557  1.00  0.00           H  
ATOM   1887  HB3 PRO A 121       9.097  -6.103  -7.150  1.00  0.00           H  
ATOM   1888  HG2 PRO A 121      10.855  -7.790  -5.417  1.00  0.00           H  
ATOM   1889  HG3 PRO A 121      10.651  -6.029  -5.433  1.00  0.00           H  
ATOM   1890  HD2 PRO A 121       9.391  -7.848  -3.678  1.00  0.00           H  
ATOM   1891  HD3 PRO A 121       8.968  -6.140  -3.903  1.00  0.00           H  
ATOM   1892  N   LEU A 122       8.902  -9.867  -7.772  1.00  0.00           N  
ATOM   1893  CA  LEU A 122       9.347 -11.249  -7.976  1.00  0.00           C  
ATOM   1894  C   LEU A 122      10.875 -11.317  -8.118  1.00  0.00           C  
ATOM   1895  O   LEU A 122      11.547 -10.292  -8.253  1.00  0.00           O  
ATOM   1896  CB  LEU A 122       8.679 -11.858  -9.223  1.00  0.00           C  
ATOM   1897  CG  LEU A 122       7.190 -12.233  -9.083  1.00  0.00           C  
ATOM   1898  CD1 LEU A 122       6.974 -13.191  -7.913  1.00  0.00           C  
ATOM   1899  CD2 LEU A 122       6.318 -10.988  -8.936  1.00  0.00           C  
ATOM   1900  H   LEU A 122       8.903  -9.254  -8.536  1.00  0.00           H  
ATOM   1901  HA  LEU A 122       9.057 -11.826  -7.107  1.00  0.00           H  
ATOM   1902  HB2 LEU A 122       8.771 -11.149 -10.035  1.00  0.00           H  
ATOM   1903  HB3 LEU A 122       9.224 -12.750  -9.492  1.00  0.00           H  
ATOM   1904  HG  LEU A 122       6.878 -12.748  -9.983  1.00  0.00           H  
ATOM   1905 HD11 LEU A 122       7.268 -12.710  -6.991  1.00  0.00           H  
ATOM   1906 HD12 LEU A 122       7.572 -14.078  -8.061  1.00  0.00           H  
ATOM   1907 HD13 LEU A 122       5.931 -13.467  -7.859  1.00  0.00           H  
ATOM   1908 HD21 LEU A 122       6.455 -10.349  -9.795  1.00  0.00           H  
ATOM   1909 HD22 LEU A 122       6.597 -10.452  -8.040  1.00  0.00           H  
ATOM   1910 HD23 LEU A 122       5.280 -11.281  -8.869  1.00  0.00           H  
ATOM   1911  N   THR A 123      11.416 -12.533  -8.091  1.00  0.00           N  
ATOM   1912  CA  THR A 123      12.864 -12.751  -8.245  1.00  0.00           C  
ATOM   1913  C   THR A 123      13.396 -12.185  -9.573  1.00  0.00           C  
ATOM   1914  O   THR A 123      13.064 -12.677 -10.652  1.00  0.00           O  
ATOM   1915  CB  THR A 123      13.227 -14.259  -8.151  1.00  0.00           C  
ATOM   1916  OG1 THR A 123      14.571 -14.480  -8.612  1.00  0.00           O  
ATOM   1917  CG2 THR A 123      12.258 -15.122  -8.959  1.00  0.00           C  
ATOM   1918  H   THR A 123      10.829 -13.307  -7.963  1.00  0.00           H  
ATOM   1919  HA  THR A 123      13.358 -12.238  -7.430  1.00  0.00           H  
ATOM   1920  HB  THR A 123      13.165 -14.558  -7.113  1.00  0.00           H  
ATOM   1921  HG1 THR A 123      14.566 -14.559  -9.575  1.00  0.00           H  
ATOM   1922 HG21 THR A 123      11.252 -14.975  -8.594  1.00  0.00           H  
ATOM   1923 HG22 THR A 123      12.529 -16.162  -8.852  1.00  0.00           H  
ATOM   1924 HG23 THR A 123      12.308 -14.844 -10.002  1.00  0.00           H  
ATOM   1925  N   GLY A 124      14.215 -11.138  -9.485  1.00  0.00           N  
ATOM   1926  CA  GLY A 124      14.791 -10.520 -10.681  1.00  0.00           C  
ATOM   1927  C   GLY A 124      14.399  -9.055 -10.851  1.00  0.00           C  
ATOM   1928  O   GLY A 124      14.886  -8.378 -11.761  1.00  0.00           O  
ATOM   1929  H   GLY A 124      14.432 -10.776  -8.599  1.00  0.00           H  
ATOM   1930  HA2 GLY A 124      15.868 -10.582 -10.616  1.00  0.00           H  
ATOM   1931  HA3 GLY A 124      14.465 -11.067 -11.554  1.00  0.00           H  
ATOM   1932  N   GLU A 125      13.529  -8.558  -9.975  1.00  0.00           N  
ATOM   1933  CA  GLU A 125      13.073  -7.169 -10.031  1.00  0.00           C  
ATOM   1934  C   GLU A 125      13.890  -6.299  -9.066  1.00  0.00           C  
ATOM   1935  O   GLU A 125      13.901  -6.537  -7.856  1.00  0.00           O  
ATOM   1936  CB  GLU A 125      11.580  -7.075  -9.671  1.00  0.00           C  
ATOM   1937  CG  GLU A 125      10.684  -8.062 -10.420  1.00  0.00           C  
ATOM   1938  CD  GLU A 125      10.817  -7.966 -11.930  1.00  0.00           C  
ATOM   1939  OE1 GLU A 125      11.395  -8.891 -12.539  1.00  0.00           O  
ATOM   1940  OE2 GLU A 125      10.346  -6.968 -12.515  1.00  0.00           O  
ATOM   1941  H   GLU A 125      13.197  -9.132  -9.259  1.00  0.00           H  
ATOM   1942  HA  GLU A 125      13.218  -6.807 -11.040  1.00  0.00           H  
ATOM   1943  HB2 GLU A 125      11.468  -7.259  -8.611  1.00  0.00           H  
ATOM   1944  HB3 GLU A 125      11.235  -6.073  -9.886  1.00  0.00           H  
ATOM   1945  HG2 GLU A 125      10.948  -9.065 -10.114  1.00  0.00           H  
ATOM   1946  HG3 GLU A 125       9.655  -7.869 -10.150  1.00  0.00           H  
ATOM   1947  N   ASP A 126      14.590  -5.309  -9.606  1.00  0.00           N  
ATOM   1948  CA  ASP A 126      15.377  -4.383  -8.781  1.00  0.00           C  
ATOM   1949  C   ASP A 126      14.540  -3.152  -8.383  1.00  0.00           C  
ATOM   1950  O   ASP A 126      13.481  -2.893  -8.954  1.00  0.00           O  
ATOM   1951  CB  ASP A 126      16.655  -3.952  -9.518  1.00  0.00           C  
ATOM   1952  CG  ASP A 126      17.689  -3.360  -8.571  1.00  0.00           C  
ATOM   1953  OD1 ASP A 126      17.735  -2.122  -8.416  1.00  0.00           O  
ATOM   1954  OD2 ASP A 126      18.442  -4.138  -7.949  1.00  0.00           O  
ATOM   1955  H   ASP A 126      14.581  -5.202 -10.576  1.00  0.00           H  
ATOM   1956  HA  ASP A 126      15.658  -4.910  -7.877  1.00  0.00           H  
ATOM   1957  HB2 ASP A 126      17.090  -4.811 -10.009  1.00  0.00           H  
ATOM   1958  HB3 ASP A 126      16.402  -3.208 -10.261  1.00  0.00           H  
ATOM   1959  N   ILE A 127      15.029  -2.398  -7.403  1.00  0.00           N  
ATOM   1960  CA  ILE A 127      14.284  -1.262  -6.844  1.00  0.00           C  
ATOM   1961  C   ILE A 127      14.795   0.092  -7.375  1.00  0.00           C  
ATOM   1962  O   ILE A 127      14.030   1.044  -7.512  1.00  0.00           O  
ATOM   1963  CB  ILE A 127      14.380  -1.269  -5.294  1.00  0.00           C  
ATOM   1964  CG1 ILE A 127      13.899  -2.619  -4.734  1.00  0.00           C  
ATOM   1965  CG2 ILE A 127      13.574  -0.122  -4.688  1.00  0.00           C  
ATOM   1966  CD1 ILE A 127      14.029  -2.746  -3.228  1.00  0.00           C  
ATOM   1967  H   ILE A 127      15.915  -2.607  -7.044  1.00  0.00           H  
ATOM   1968  HA  ILE A 127      13.242  -1.373  -7.118  1.00  0.00           H  
ATOM   1969  HB  ILE A 127      15.418  -1.127  -5.024  1.00  0.00           H  
ATOM   1970 HG12 ILE A 127      12.858  -2.756  -4.986  1.00  0.00           H  
ATOM   1971 HG13 ILE A 127      14.478  -3.413  -5.185  1.00  0.00           H  
ATOM   1972 HG21 ILE A 127      12.535  -0.226  -4.962  1.00  0.00           H  
ATOM   1973 HG22 ILE A 127      13.951   0.821  -5.058  1.00  0.00           H  
ATOM   1974 HG23 ILE A 127      13.666  -0.145  -3.612  1.00  0.00           H  
ATOM   1975 HD11 ILE A 127      15.062  -2.616  -2.942  1.00  0.00           H  
ATOM   1976 HD12 ILE A 127      13.692  -3.725  -2.921  1.00  0.00           H  
ATOM   1977 HD13 ILE A 127      13.424  -1.991  -2.747  1.00  0.00           H  
ATOM   1978  N   VAL A 128      16.088   0.163  -7.690  1.00  0.00           N  
ATOM   1979  CA  VAL A 128      16.742   1.431  -8.044  1.00  0.00           C  
ATOM   1980  C   VAL A 128      16.614   2.442  -6.889  1.00  0.00           C  
ATOM   1981  O   VAL A 128      15.705   3.274  -6.861  1.00  0.00           O  
ATOM   1982  CB  VAL A 128      16.178   2.048  -9.353  1.00  0.00           C  
ATOM   1983  CG1 VAL A 128      16.977   3.286  -9.766  1.00  0.00           C  
ATOM   1984  CG2 VAL A 128      16.162   1.011 -10.474  1.00  0.00           C  
ATOM   1985  H   VAL A 128      16.617  -0.659  -7.696  1.00  0.00           H  
ATOM   1986  HA  VAL A 128      17.793   1.218  -8.196  1.00  0.00           H  
ATOM   1987  HB  VAL A 128      15.157   2.357  -9.168  1.00  0.00           H  
ATOM   1988 HG11 VAL A 128      16.567   3.694 -10.679  1.00  0.00           H  
ATOM   1989 HG12 VAL A 128      18.010   3.013  -9.927  1.00  0.00           H  
ATOM   1990 HG13 VAL A 128      16.921   4.031  -8.984  1.00  0.00           H  
ATOM   1991 HG21 VAL A 128      15.532   0.179 -10.188  1.00  0.00           H  
ATOM   1992 HG22 VAL A 128      17.166   0.656 -10.653  1.00  0.00           H  
ATOM   1993 HG23 VAL A 128      15.773   1.461 -11.378  1.00  0.00           H  
ATOM   1994  N   THR A 129      17.531   2.351  -5.931  1.00  0.00           N  
ATOM   1995  CA  THR A 129      17.422   3.108  -4.677  1.00  0.00           C  
ATOM   1996  C   THR A 129      18.791   3.325  -4.019  1.00  0.00           C  
ATOM   1997  O   THR A 129      19.808   2.808  -4.484  1.00  0.00           O  
ATOM   1998  CB  THR A 129      16.494   2.370  -3.670  1.00  0.00           C  
ATOM   1999  OG1 THR A 129      16.506   3.022  -2.389  1.00  0.00           O  
ATOM   2000  CG2 THR A 129      16.922   0.916  -3.492  1.00  0.00           C  
ATOM   2001  H   THR A 129      18.308   1.768  -6.071  1.00  0.00           H  
ATOM   2002  HA  THR A 129      16.984   4.070  -4.899  1.00  0.00           H  
ATOM   2003  HB  THR A 129      15.486   2.385  -4.058  1.00  0.00           H  
ATOM   2004  HG1 THR A 129      15.823   3.706  -2.366  1.00  0.00           H  
ATOM   2005 HG21 THR A 129      16.873   0.405  -4.443  1.00  0.00           H  
ATOM   2006 HG22 THR A 129      16.263   0.428  -2.788  1.00  0.00           H  
ATOM   2007 HG23 THR A 129      17.935   0.881  -3.116  1.00  0.00           H  
ATOM   2008  N   GLU A 130      18.809   4.092  -2.932  1.00  0.00           N  
ATOM   2009  CA  GLU A 130      20.028   4.300  -2.139  1.00  0.00           C  
ATOM   2010  C   GLU A 130      20.066   3.327  -0.946  1.00  0.00           C  
ATOM   2011  O   GLU A 130      20.844   3.500  -0.003  1.00  0.00           O  
ATOM   2012  CB  GLU A 130      20.141   5.765  -1.660  1.00  0.00           C  
ATOM   2013  CG  GLU A 130      19.033   6.233  -0.712  1.00  0.00           C  
ATOM   2014  CD  GLU A 130      17.663   6.313  -1.370  1.00  0.00           C  
ATOM   2015  OE1 GLU A 130      16.841   5.399  -1.158  1.00  0.00           O  
ATOM   2016  OE2 GLU A 130      17.403   7.283  -2.113  1.00  0.00           O  
ATOM   2017  H   GLU A 130      17.974   4.521  -2.646  1.00  0.00           H  
ATOM   2018  HA  GLU A 130      20.875   4.080  -2.778  1.00  0.00           H  
ATOM   2019  HB2 GLU A 130      21.087   5.887  -1.150  1.00  0.00           H  
ATOM   2020  HB3 GLU A 130      20.135   6.410  -2.528  1.00  0.00           H  
ATOM   2021  HG2 GLU A 130      18.977   5.544   0.118  1.00  0.00           H  
ATOM   2022  HG3 GLU A 130      19.293   7.215  -0.337  1.00  0.00           H  
ATOM   2023  N   ARG A 131      19.210   2.299  -1.015  1.00  0.00           N  
ATOM   2024  CA  ARG A 131      19.170   1.208  -0.028  1.00  0.00           C  
ATOM   2025  C   ARG A 131      18.562   1.635   1.319  1.00  0.00           C  
ATOM   2026  O   ARG A 131      18.944   1.117   2.371  1.00  0.00           O  
ATOM   2027  CB  ARG A 131      20.570   0.596   0.176  1.00  0.00           C  
ATOM   2028  CG  ARG A 131      21.023  -0.299  -0.976  1.00  0.00           C  
ATOM   2029  CD  ARG A 131      22.418  -0.869  -0.740  1.00  0.00           C  
ATOM   2030  NE  ARG A 131      22.739  -1.946  -1.676  1.00  0.00           N  
ATOM   2031  CZ  ARG A 131      23.926  -2.471  -1.816  1.00  0.00           C  
ATOM   2032  NH1 ARG A 131      24.944  -1.968  -1.191  1.00  0.00           N  
ATOM   2033  NH2 ARG A 131      24.094  -3.487  -2.601  1.00  0.00           N  
ATOM   2034  H   ARG A 131      18.572   2.278  -1.760  1.00  0.00           H  
ATOM   2035  HA  ARG A 131      18.529   0.442  -0.443  1.00  0.00           H  
ATOM   2036  HB2 ARG A 131      21.288   1.397   0.288  1.00  0.00           H  
ATOM   2037  HB3 ARG A 131      20.566   0.004   1.081  1.00  0.00           H  
ATOM   2038  HG2 ARG A 131      20.324  -1.118  -1.078  1.00  0.00           H  
ATOM   2039  HG3 ARG A 131      21.029   0.283  -1.888  1.00  0.00           H  
ATOM   2040  HD2 ARG A 131      23.142  -0.076  -0.857  1.00  0.00           H  
ATOM   2041  HD3 ARG A 131      22.470  -1.255   0.269  1.00  0.00           H  
ATOM   2042  HE  ARG A 131      22.002  -2.321  -2.203  1.00  0.00           H  
ATOM   2043 HH11 ARG A 131      24.822  -1.175  -0.602  1.00  0.00           H  
ATOM   2044 HH12 ARG A 131      25.849  -2.373  -1.300  1.00  0.00           H  
ATOM   2045 HH21 ARG A 131      23.315  -3.867  -3.099  1.00  0.00           H  
ATOM   2046 HH22 ARG A 131      24.996  -3.900  -2.700  1.00  0.00           H  
ATOM   2047  N   LYS A 132      17.601   2.558   1.290  1.00  0.00           N  
ATOM   2048  CA  LYS A 132      16.826   2.885   2.497  1.00  0.00           C  
ATOM   2049  C   LYS A 132      15.727   1.836   2.750  1.00  0.00           C  
ATOM   2050  O   LYS A 132      15.222   1.709   3.865  1.00  0.00           O  
ATOM   2051  CB  LYS A 132      16.198   4.283   2.400  1.00  0.00           C  
ATOM   2052  CG  LYS A 132      17.208   5.427   2.412  1.00  0.00           C  
ATOM   2053  CD  LYS A 132      16.529   6.784   2.618  1.00  0.00           C  
ATOM   2054  CE  LYS A 132      15.548   7.118   1.497  1.00  0.00           C  
ATOM   2055  NZ  LYS A 132      14.841   8.403   1.742  1.00  0.00           N  
ATOM   2056  H   LYS A 132      17.419   3.039   0.452  1.00  0.00           H  
ATOM   2057  HA  LYS A 132      17.509   2.870   3.336  1.00  0.00           H  
ATOM   2058  HB2 LYS A 132      15.631   4.345   1.482  1.00  0.00           H  
ATOM   2059  HB3 LYS A 132      15.524   4.418   3.235  1.00  0.00           H  
ATOM   2060  HG2 LYS A 132      17.914   5.263   3.216  1.00  0.00           H  
ATOM   2061  HG3 LYS A 132      17.736   5.436   1.468  1.00  0.00           H  
ATOM   2062  HD2 LYS A 132      15.994   6.768   3.556  1.00  0.00           H  
ATOM   2063  HD3 LYS A 132      17.291   7.551   2.655  1.00  0.00           H  
ATOM   2064  HE2 LYS A 132      16.091   7.192   0.568  1.00  0.00           H  
ATOM   2065  HE3 LYS A 132      14.816   6.325   1.422  1.00  0.00           H  
ATOM   2066  HZ1 LYS A 132      14.247   8.331   2.595  1.00  0.00           H  
ATOM   2067  HZ2 LYS A 132      14.234   8.638   0.933  1.00  0.00           H  
ATOM   2068  HZ3 LYS A 132      15.529   9.170   1.879  1.00  0.00           H  
ATOM   2069  N   MET A 133      15.359   1.091   1.705  1.00  0.00           N  
ATOM   2070  CA  MET A 133      14.364   0.017   1.830  1.00  0.00           C  
ATOM   2071  C   MET A 133      14.986  -1.243   2.447  1.00  0.00           C  
ATOM   2072  O   MET A 133      16.188  -1.480   2.322  1.00  0.00           O  
ATOM   2073  CB  MET A 133      13.748  -0.311   0.463  1.00  0.00           C  
ATOM   2074  CG  MET A 133      12.982   0.853  -0.146  1.00  0.00           C  
ATOM   2075  SD  MET A 133      12.149   0.420  -1.685  1.00  0.00           S  
ATOM   2076  CE  MET A 133      10.985  -0.816  -1.112  1.00  0.00           C  
ATOM   2077  H   MET A 133      15.768   1.263   0.833  1.00  0.00           H  
ATOM   2078  HA  MET A 133      13.581   0.370   2.489  1.00  0.00           H  
ATOM   2079  HB2 MET A 133      14.539  -0.592  -0.218  1.00  0.00           H  
ATOM   2080  HB3 MET A 133      13.069  -1.146   0.575  1.00  0.00           H  
ATOM   2081  HG2 MET A 133      12.238   1.185   0.564  1.00  0.00           H  
ATOM   2082  HG3 MET A 133      13.673   1.660  -0.341  1.00  0.00           H  
ATOM   2083  HE1 MET A 133      11.525  -1.652  -0.690  1.00  0.00           H  
ATOM   2084  HE2 MET A 133      10.385  -1.159  -1.941  1.00  0.00           H  
ATOM   2085  HE3 MET A 133      10.344  -0.385  -0.357  1.00  0.00           H  
ATOM   2086  N   LYS A 134      14.160  -2.050   3.106  1.00  0.00           N  
ATOM   2087  CA  LYS A 134      14.649  -3.221   3.847  1.00  0.00           C  
ATOM   2088  C   LYS A 134      13.765  -4.464   3.637  1.00  0.00           C  
ATOM   2089  O   LYS A 134      12.562  -4.359   3.396  1.00  0.00           O  
ATOM   2090  CB  LYS A 134      14.752  -2.870   5.339  1.00  0.00           C  
ATOM   2091  CG  LYS A 134      13.474  -2.269   5.923  1.00  0.00           C  
ATOM   2092  CD  LYS A 134      13.685  -1.680   7.321  1.00  0.00           C  
ATOM   2093  CE  LYS A 134      14.532  -0.403   7.305  1.00  0.00           C  
ATOM   2094  NZ  LYS A 134      15.954  -0.651   6.936  1.00  0.00           N  
ATOM   2095  H   LYS A 134      13.196  -1.856   3.094  1.00  0.00           H  
ATOM   2096  HA  LYS A 134      15.641  -3.448   3.481  1.00  0.00           H  
ATOM   2097  HB2 LYS A 134      14.989  -3.767   5.894  1.00  0.00           H  
ATOM   2098  HB3 LYS A 134      15.553  -2.156   5.472  1.00  0.00           H  
ATOM   2099  HG2 LYS A 134      13.124  -1.485   5.266  1.00  0.00           H  
ATOM   2100  HG3 LYS A 134      12.723  -3.045   5.982  1.00  0.00           H  
ATOM   2101  HD2 LYS A 134      12.720  -1.445   7.745  1.00  0.00           H  
ATOM   2102  HD3 LYS A 134      14.176  -2.418   7.940  1.00  0.00           H  
ATOM   2103  HE2 LYS A 134      14.107   0.286   6.589  1.00  0.00           H  
ATOM   2104  HE3 LYS A 134      14.500   0.043   8.288  1.00  0.00           H  
ATOM   2105  HZ1 LYS A 134      16.023  -0.972   5.952  1.00  0.00           H  
ATOM   2106  HZ2 LYS A 134      16.365  -1.379   7.555  1.00  0.00           H  
ATOM   2107  HZ3 LYS A 134      16.509   0.224   7.040  1.00  0.00           H  
ATOM   2108  N   LEU A 135      14.385  -5.640   3.734  1.00  0.00           N  
ATOM   2109  CA  LEU A 135      13.706  -6.921   3.479  1.00  0.00           C  
ATOM   2110  C   LEU A 135      12.920  -7.429   4.703  1.00  0.00           C  
ATOM   2111  O   LEU A 135      13.419  -7.429   5.831  1.00  0.00           O  
ATOM   2112  CB  LEU A 135      14.736  -7.981   3.052  1.00  0.00           C  
ATOM   2113  CG  LEU A 135      14.170  -9.385   2.766  1.00  0.00           C  
ATOM   2114  CD1 LEU A 135      13.187  -9.357   1.595  1.00  0.00           C  
ATOM   2115  CD2 LEU A 135      15.302 -10.378   2.502  1.00  0.00           C  
ATOM   2116  H   LEU A 135      15.334  -5.650   3.981  1.00  0.00           H  
ATOM   2117  HA  LEU A 135      13.014  -6.767   2.663  1.00  0.00           H  
ATOM   2118  HB2 LEU A 135      15.235  -7.628   2.158  1.00  0.00           H  
ATOM   2119  HB3 LEU A 135      15.473  -8.068   3.838  1.00  0.00           H  
ATOM   2120  HG  LEU A 135      13.629  -9.726   3.637  1.00  0.00           H  
ATOM   2121 HD11 LEU A 135      12.794 -10.350   1.430  1.00  0.00           H  
ATOM   2122 HD12 LEU A 135      13.694  -9.019   0.702  1.00  0.00           H  
ATOM   2123 HD13 LEU A 135      12.373  -8.683   1.822  1.00  0.00           H  
ATOM   2124 HD21 LEU A 135      14.886 -11.353   2.289  1.00  0.00           H  
ATOM   2125 HD22 LEU A 135      15.935 -10.443   3.375  1.00  0.00           H  
ATOM   2126 HD23 LEU A 135      15.888 -10.045   1.657  1.00  0.00           H  
ATOM   2127  N   VAL A 136      11.688  -7.872   4.459  1.00  0.00           N  
ATOM   2128  CA  VAL A 136      10.839  -8.473   5.494  1.00  0.00           C  
ATOM   2129  C   VAL A 136      10.341  -9.859   5.054  1.00  0.00           C  
ATOM   2130  O   VAL A 136       9.939 -10.047   3.906  1.00  0.00           O  
ATOM   2131  CB  VAL A 136       9.609  -7.584   5.807  1.00  0.00           C  
ATOM   2132  CG1 VAL A 136       8.782  -8.174   6.950  1.00  0.00           C  
ATOM   2133  CG2 VAL A 136      10.036  -6.153   6.123  1.00  0.00           C  
ATOM   2134  H   VAL A 136      11.331  -7.788   3.552  1.00  0.00           H  
ATOM   2135  HA  VAL A 136      11.427  -8.577   6.398  1.00  0.00           H  
ATOM   2136  HB  VAL A 136       8.984  -7.559   4.925  1.00  0.00           H  
ATOM   2137 HG11 VAL A 136       8.429  -9.156   6.671  1.00  0.00           H  
ATOM   2138 HG12 VAL A 136       7.936  -7.534   7.153  1.00  0.00           H  
ATOM   2139 HG13 VAL A 136       9.394  -8.251   7.838  1.00  0.00           H  
ATOM   2140 HG21 VAL A 136      10.691  -6.151   6.984  1.00  0.00           H  
ATOM   2141 HG22 VAL A 136       9.163  -5.553   6.336  1.00  0.00           H  
ATOM   2142 HG23 VAL A 136      10.559  -5.735   5.275  1.00  0.00           H  
ATOM   2143  N   ASN A 137      10.367 -10.823   5.972  1.00  0.00           N  
ATOM   2144  CA  ASN A 137       9.903 -12.185   5.684  1.00  0.00           C  
ATOM   2145  C   ASN A 137       8.766 -12.590   6.634  1.00  0.00           C  
ATOM   2146  O   ASN A 137       9.007 -12.952   7.787  1.00  0.00           O  
ATOM   2147  CB  ASN A 137      11.066 -13.178   5.809  1.00  0.00           C  
ATOM   2148  CG  ASN A 137      12.192 -12.871   4.840  1.00  0.00           C  
ATOM   2149  OD1 ASN A 137      13.101 -12.102   5.142  1.00  0.00           O  
ATOM   2150  ND2 ASN A 137      12.150 -13.476   3.670  1.00  0.00           N  
ATOM   2151  H   ASN A 137      10.706 -10.615   6.871  1.00  0.00           H  
ATOM   2152  HA  ASN A 137       9.532 -12.207   4.667  1.00  0.00           H  
ATOM   2153  HB2 ASN A 137      11.461 -13.138   6.815  1.00  0.00           H  
ATOM   2154  HB3 ASN A 137      10.705 -14.178   5.612  1.00  0.00           H  
ATOM   2155 HD21 ASN A 137      11.406 -14.085   3.488  1.00  0.00           H  
ATOM   2156 HD22 ASN A 137      12.868 -13.288   3.029  1.00  0.00           H  
ATOM   2157  N   TYR A 138       7.526 -12.521   6.154  1.00  0.00           N  
ATOM   2158  CA  TYR A 138       6.363 -12.866   6.982  1.00  0.00           C  
ATOM   2159  C   TYR A 138       5.881 -14.294   6.678  1.00  0.00           C  
ATOM   2160  O   TYR A 138       5.320 -14.562   5.615  1.00  0.00           O  
ATOM   2161  CB  TYR A 138       5.227 -11.853   6.763  1.00  0.00           C  
ATOM   2162  CG  TYR A 138       4.157 -11.892   7.843  1.00  0.00           C  
ATOM   2163  CD1 TYR A 138       2.912 -12.467   7.610  1.00  0.00           C  
ATOM   2164  CD2 TYR A 138       4.401 -11.351   9.102  1.00  0.00           C  
ATOM   2165  CE1 TYR A 138       1.943 -12.500   8.597  1.00  0.00           C  
ATOM   2166  CE2 TYR A 138       3.438 -11.380  10.092  1.00  0.00           C  
ATOM   2167  CZ  TYR A 138       2.211 -11.955   9.837  1.00  0.00           C  
ATOM   2168  OH  TYR A 138       1.249 -11.984  10.825  1.00  0.00           O  
ATOM   2169  H   TYR A 138       7.388 -12.241   5.223  1.00  0.00           H  
ATOM   2170  HA  TYR A 138       6.673 -12.823   8.019  1.00  0.00           H  
ATOM   2171  HB2 TYR A 138       5.643 -10.855   6.746  1.00  0.00           H  
ATOM   2172  HB3 TYR A 138       4.753 -12.053   5.812  1.00  0.00           H  
ATOM   2173  HD1 TYR A 138       2.705 -12.892   6.639  1.00  0.00           H  
ATOM   2174  HD2 TYR A 138       5.363 -10.900   9.302  1.00  0.00           H  
ATOM   2175  HE1 TYR A 138       0.983 -12.951   8.394  1.00  0.00           H  
ATOM   2176  HE2 TYR A 138       3.650 -10.953  11.062  1.00  0.00           H  
ATOM   2177  HH  TYR A 138       0.779 -12.828  10.787  1.00  0.00           H  
ATOM   2178  N   GLY A 139       6.121 -15.212   7.613  1.00  0.00           N  
ATOM   2179  CA  GLY A 139       5.768 -16.611   7.411  1.00  0.00           C  
ATOM   2180  C   GLY A 139       6.670 -17.297   6.393  1.00  0.00           C  
ATOM   2181  O   GLY A 139       7.663 -17.938   6.747  1.00  0.00           O  
ATOM   2182  H   GLY A 139       6.545 -14.940   8.448  1.00  0.00           H  
ATOM   2183  HA2 GLY A 139       5.850 -17.129   8.356  1.00  0.00           H  
ATOM   2184  HA3 GLY A 139       4.745 -16.670   7.068  1.00  0.00           H  
ATOM   2185  N   ARG A 140       6.332 -17.139   5.119  1.00  0.00           N  
ATOM   2186  CA  ARG A 140       7.097 -17.744   4.020  1.00  0.00           C  
ATOM   2187  C   ARG A 140       7.333 -16.751   2.867  1.00  0.00           C  
ATOM   2188  O   ARG A 140       8.248 -16.931   2.058  1.00  0.00           O  
ATOM   2189  CB  ARG A 140       6.383 -18.995   3.502  1.00  0.00           C  
ATOM   2190  CG  ARG A 140       6.387 -20.148   4.499  1.00  0.00           C  
ATOM   2191  CD  ARG A 140       5.685 -21.368   3.936  1.00  0.00           C  
ATOM   2192  NE  ARG A 140       5.735 -22.505   4.854  1.00  0.00           N  
ATOM   2193  CZ  ARG A 140       6.106 -23.707   4.508  1.00  0.00           C  
ATOM   2194  NH1 ARG A 140       6.405 -23.975   3.277  1.00  0.00           N  
ATOM   2195  NH2 ARG A 140       6.173 -24.644   5.393  1.00  0.00           N  
ATOM   2196  H   ARG A 140       5.544 -16.590   4.911  1.00  0.00           H  
ATOM   2197  HA  ARG A 140       8.054 -18.045   4.415  1.00  0.00           H  
ATOM   2198  HB2 ARG A 140       5.356 -18.743   3.276  1.00  0.00           H  
ATOM   2199  HB3 ARG A 140       6.871 -19.329   2.596  1.00  0.00           H  
ATOM   2200  HG2 ARG A 140       7.411 -20.410   4.731  1.00  0.00           H  
ATOM   2201  HG3 ARG A 140       5.881 -19.835   5.401  1.00  0.00           H  
ATOM   2202  HD2 ARG A 140       4.658 -21.106   3.753  1.00  0.00           H  
ATOM   2203  HD3 ARG A 140       6.157 -21.643   3.003  1.00  0.00           H  
ATOM   2204  HE  ARG A 140       5.488 -22.346   5.788  1.00  0.00           H  
ATOM   2205 HH11 ARG A 140       6.351 -23.263   2.586  1.00  0.00           H  
ATOM   2206 HH12 ARG A 140       6.695 -24.899   3.025  1.00  0.00           H  
ATOM   2207 HH21 ARG A 140       5.941 -24.451   6.346  1.00  0.00           H  
ATOM   2208 HH22 ARG A 140       6.466 -25.560   5.123  1.00  0.00           H  
ATOM   2209  N   THR A 141       6.504 -15.710   2.791  1.00  0.00           N  
ATOM   2210  CA  THR A 141       6.636 -14.687   1.742  1.00  0.00           C  
ATOM   2211  C   THR A 141       7.679 -13.625   2.116  1.00  0.00           C  
ATOM   2212  O   THR A 141       7.941 -13.379   3.298  1.00  0.00           O  
ATOM   2213  CB  THR A 141       5.285 -13.987   1.445  1.00  0.00           C  
ATOM   2214  OG1 THR A 141       5.442 -13.050   0.367  1.00  0.00           O  
ATOM   2215  CG2 THR A 141       4.746 -13.260   2.675  1.00  0.00           C  
ATOM   2216  H   THR A 141       5.783 -15.624   3.453  1.00  0.00           H  
ATOM   2217  HA  THR A 141       6.961 -15.184   0.836  1.00  0.00           H  
ATOM   2218  HB  THR A 141       4.568 -14.740   1.149  1.00  0.00           H  
ATOM   2219  HG1 THR A 141       4.812 -13.255  -0.328  1.00  0.00           H  
ATOM   2220 HG21 THR A 141       3.805 -12.788   2.432  1.00  0.00           H  
ATOM   2221 HG22 THR A 141       5.454 -12.506   2.992  1.00  0.00           H  
ATOM   2222 HG23 THR A 141       4.594 -13.969   3.477  1.00  0.00           H  
ATOM   2223  N   TYR A 142       8.266 -12.989   1.103  1.00  0.00           N  
ATOM   2224  CA  TYR A 142       9.302 -11.971   1.318  1.00  0.00           C  
ATOM   2225  C   TYR A 142       9.057 -10.729   0.448  1.00  0.00           C  
ATOM   2226  O   TYR A 142       8.628 -10.834  -0.703  1.00  0.00           O  
ATOM   2227  CB  TYR A 142      10.698 -12.553   1.036  1.00  0.00           C  
ATOM   2228  CG  TYR A 142      10.925 -12.987  -0.405  1.00  0.00           C  
ATOM   2229  CD1 TYR A 142      10.339 -14.145  -0.906  1.00  0.00           C  
ATOM   2230  CD2 TYR A 142      11.735 -12.241  -1.258  1.00  0.00           C  
ATOM   2231  CE1 TYR A 142      10.550 -14.544  -2.211  1.00  0.00           C  
ATOM   2232  CE2 TYR A 142      11.949 -12.635  -2.565  1.00  0.00           C  
ATOM   2233  CZ  TYR A 142      11.354 -13.786  -3.037  1.00  0.00           C  
ATOM   2234  OH  TYR A 142      11.567 -14.183  -4.340  1.00  0.00           O  
ATOM   2235  H   TYR A 142       7.988 -13.199   0.188  1.00  0.00           H  
ATOM   2236  HA  TYR A 142       9.257 -11.672   2.358  1.00  0.00           H  
ATOM   2237  HB2 TYR A 142      11.443 -11.809   1.278  1.00  0.00           H  
ATOM   2238  HB3 TYR A 142      10.849 -13.416   1.669  1.00  0.00           H  
ATOM   2239  HD1 TYR A 142       9.708 -14.736  -0.257  1.00  0.00           H  
ATOM   2240  HD2 TYR A 142      12.201 -11.339  -0.886  1.00  0.00           H  
ATOM   2241  HE1 TYR A 142      10.084 -15.446  -2.581  1.00  0.00           H  
ATOM   2242  HE2 TYR A 142      12.579 -12.042  -3.210  1.00  0.00           H  
ATOM   2243  HH  TYR A 142      10.714 -14.303  -4.777  1.00  0.00           H  
ATOM   2244  N   PHE A 143       9.332  -9.557   1.012  1.00  0.00           N  
ATOM   2245  CA  PHE A 143       9.126  -8.281   0.315  1.00  0.00           C  
ATOM   2246  C   PHE A 143      10.007  -7.173   0.911  1.00  0.00           C  
ATOM   2247  O   PHE A 143      10.644  -7.366   1.942  1.00  0.00           O  
ATOM   2248  CB  PHE A 143       7.642  -7.879   0.373  1.00  0.00           C  
ATOM   2249  CG  PHE A 143       7.029  -7.987   1.751  1.00  0.00           C  
ATOM   2250  CD1 PHE A 143       7.082  -6.924   2.642  1.00  0.00           C  
ATOM   2251  CD2 PHE A 143       6.403  -9.161   2.155  1.00  0.00           C  
ATOM   2252  CE1 PHE A 143       6.527  -7.030   3.902  1.00  0.00           C  
ATOM   2253  CE2 PHE A 143       5.846  -9.269   3.414  1.00  0.00           C  
ATOM   2254  CZ  PHE A 143       5.909  -8.204   4.289  1.00  0.00           C  
ATOM   2255  H   PHE A 143       9.681  -9.546   1.929  1.00  0.00           H  
ATOM   2256  HA  PHE A 143       9.410  -8.424  -0.719  1.00  0.00           H  
ATOM   2257  HB2 PHE A 143       7.541  -6.856   0.041  1.00  0.00           H  
ATOM   2258  HB3 PHE A 143       7.079  -8.519  -0.293  1.00  0.00           H  
ATOM   2259  HD1 PHE A 143       7.563  -6.004   2.342  1.00  0.00           H  
ATOM   2260  HD2 PHE A 143       6.350  -9.996   1.471  1.00  0.00           H  
ATOM   2261  HE1 PHE A 143       6.575  -6.195   4.587  1.00  0.00           H  
ATOM   2262  HE2 PHE A 143       5.365 -10.188   3.715  1.00  0.00           H  
ATOM   2263  HZ  PHE A 143       5.477  -8.287   5.276  1.00  0.00           H  
ATOM   2264  N   TYR A 144      10.039  -6.012   0.260  1.00  0.00           N  
ATOM   2265  CA  TYR A 144      10.862  -4.886   0.726  1.00  0.00           C  
ATOM   2266  C   TYR A 144       9.995  -3.695   1.153  1.00  0.00           C  
ATOM   2267  O   TYR A 144       9.222  -3.158   0.358  1.00  0.00           O  
ATOM   2268  CB  TYR A 144      11.848  -4.448  -0.370  1.00  0.00           C  
ATOM   2269  CG  TYR A 144      12.985  -5.429  -0.604  1.00  0.00           C  
ATOM   2270  CD1 TYR A 144      12.821  -6.541  -1.424  1.00  0.00           C  
ATOM   2271  CD2 TYR A 144      14.223  -5.242   0.003  1.00  0.00           C  
ATOM   2272  CE1 TYR A 144      13.857  -7.436  -1.630  1.00  0.00           C  
ATOM   2273  CE2 TYR A 144      15.262  -6.130  -0.202  1.00  0.00           C  
ATOM   2274  CZ  TYR A 144      15.074  -7.225  -1.017  1.00  0.00           C  
ATOM   2275  OH  TYR A 144      16.111  -8.115  -1.220  1.00  0.00           O  
ATOM   2276  H   TYR A 144       9.487  -5.900  -0.546  1.00  0.00           H  
ATOM   2277  HA  TYR A 144      11.428  -5.223   1.586  1.00  0.00           H  
ATOM   2278  HB2 TYR A 144      11.313  -4.331  -1.302  1.00  0.00           H  
ATOM   2279  HB3 TYR A 144      12.282  -3.495  -0.093  1.00  0.00           H  
ATOM   2280  HD1 TYR A 144      11.867  -6.704  -1.905  1.00  0.00           H  
ATOM   2281  HD2 TYR A 144      14.370  -4.383   0.642  1.00  0.00           H  
ATOM   2282  HE1 TYR A 144      13.709  -8.292  -2.272  1.00  0.00           H  
ATOM   2283  HE2 TYR A 144      16.214  -5.966   0.280  1.00  0.00           H  
ATOM   2284  HH  TYR A 144      16.577  -8.262  -0.383  1.00  0.00           H  
ATOM   2285  N   GLU A 145      10.130  -3.278   2.411  1.00  0.00           N  
ATOM   2286  CA  GLU A 145       9.373  -2.132   2.929  1.00  0.00           C  
ATOM   2287  C   GLU A 145      10.283  -0.914   3.159  1.00  0.00           C  
ATOM   2288  O   GLU A 145      11.510  -1.006   3.086  1.00  0.00           O  
ATOM   2289  CB  GLU A 145       8.656  -2.490   4.244  1.00  0.00           C  
ATOM   2290  CG  GLU A 145       9.598  -2.679   5.431  1.00  0.00           C  
ATOM   2291  CD  GLU A 145       8.875  -2.925   6.753  1.00  0.00           C  
ATOM   2292  OE1 GLU A 145       7.627  -3.019   6.763  1.00  0.00           O  
ATOM   2293  OE2 GLU A 145       9.559  -3.018   7.794  1.00  0.00           O  
ATOM   2294  H   GLU A 145      10.756  -3.746   3.004  1.00  0.00           H  
ATOM   2295  HA  GLU A 145       8.628  -1.868   2.191  1.00  0.00           H  
ATOM   2296  HB2 GLU A 145       7.961  -1.697   4.486  1.00  0.00           H  
ATOM   2297  HB3 GLU A 145       8.102  -3.407   4.101  1.00  0.00           H  
ATOM   2298  HG2 GLU A 145      10.240  -3.524   5.231  1.00  0.00           H  
ATOM   2299  HG3 GLU A 145      10.203  -1.788   5.533  1.00  0.00           H  
ATOM   2300  N   TYR A 146       9.661   0.226   3.435  1.00  0.00           N  
ATOM   2301  CA  TYR A 146      10.376   1.471   3.722  1.00  0.00           C  
ATOM   2302  C   TYR A 146       9.567   2.343   4.690  1.00  0.00           C  
ATOM   2303  O   TYR A 146       8.480   2.816   4.359  1.00  0.00           O  
ATOM   2304  CB  TYR A 146      10.656   2.224   2.413  1.00  0.00           C  
ATOM   2305  CG  TYR A 146      11.178   3.645   2.590  1.00  0.00           C  
ATOM   2306  CD1 TYR A 146      12.426   3.887   3.155  1.00  0.00           C  
ATOM   2307  CD2 TYR A 146      10.423   4.743   2.178  1.00  0.00           C  
ATOM   2308  CE1 TYR A 146      12.904   5.177   3.306  1.00  0.00           C  
ATOM   2309  CE2 TYR A 146      10.896   6.035   2.328  1.00  0.00           C  
ATOM   2310  CZ  TYR A 146      12.136   6.246   2.892  1.00  0.00           C  
ATOM   2311  OH  TYR A 146      12.618   7.532   3.036  1.00  0.00           O  
ATOM   2312  H   TYR A 146       8.681   0.234   3.437  1.00  0.00           H  
ATOM   2313  HA  TYR A 146      11.318   1.214   4.189  1.00  0.00           H  
ATOM   2314  HB2 TYR A 146      11.397   1.670   1.852  1.00  0.00           H  
ATOM   2315  HB3 TYR A 146       9.743   2.271   1.835  1.00  0.00           H  
ATOM   2316  HD1 TYR A 146      13.027   3.051   3.481  1.00  0.00           H  
ATOM   2317  HD2 TYR A 146       9.450   4.576   1.738  1.00  0.00           H  
ATOM   2318  HE1 TYR A 146      13.876   5.343   3.748  1.00  0.00           H  
ATOM   2319  HE2 TYR A 146      10.294   6.871   2.002  1.00  0.00           H  
ATOM   2320  HH  TYR A 146      11.916   8.107   3.372  1.00  0.00           H  
ATOM   2321  N   ILE A 147      10.098   2.544   5.891  1.00  0.00           N  
ATOM   2322  CA  ILE A 147       9.393   3.306   6.924  1.00  0.00           C  
ATOM   2323  C   ILE A 147       9.696   4.806   6.814  1.00  0.00           C  
ATOM   2324  O   ILE A 147      10.769   5.270   7.206  1.00  0.00           O  
ATOM   2325  CB  ILE A 147       9.746   2.812   8.357  1.00  0.00           C  
ATOM   2326  CG1 ILE A 147       9.280   1.359   8.570  1.00  0.00           C  
ATOM   2327  CG2 ILE A 147       9.126   3.726   9.417  1.00  0.00           C  
ATOM   2328  CD1 ILE A 147      10.117   0.322   7.847  1.00  0.00           C  
ATOM   2329  H   ILE A 147      10.989   2.183   6.085  1.00  0.00           H  
ATOM   2330  HA  ILE A 147       8.331   3.158   6.773  1.00  0.00           H  
ATOM   2331  HB  ILE A 147      10.820   2.856   8.471  1.00  0.00           H  
ATOM   2332 HG12 ILE A 147       9.311   1.125   9.624  1.00  0.00           H  
ATOM   2333 HG13 ILE A 147       8.262   1.265   8.216  1.00  0.00           H  
ATOM   2334 HG21 ILE A 147       9.381   3.361  10.402  1.00  0.00           H  
ATOM   2335 HG22 ILE A 147       8.051   3.734   9.305  1.00  0.00           H  
ATOM   2336 HG23 ILE A 147       9.508   4.730   9.297  1.00  0.00           H  
ATOM   2337 HD11 ILE A 147      11.145   0.397   8.170  1.00  0.00           H  
ATOM   2338 HD12 ILE A 147      10.060   0.492   6.781  1.00  0.00           H  
ATOM   2339 HD13 ILE A 147       9.740  -0.664   8.073  1.00  0.00           H  
ATOM   2340  N   ALA A 148       8.752   5.554   6.256  1.00  0.00           N  
ATOM   2341  CA  ALA A 148       8.853   7.012   6.207  1.00  0.00           C  
ATOM   2342  C   ALA A 148       8.148   7.628   7.420  1.00  0.00           C  
ATOM   2343  O   ALA A 148       6.930   7.794   7.428  1.00  0.00           O  
ATOM   2344  CB  ALA A 148       8.265   7.547   4.908  1.00  0.00           C  
ATOM   2345  H   ALA A 148       7.965   5.114   5.866  1.00  0.00           H  
ATOM   2346  HA  ALA A 148       9.902   7.279   6.239  1.00  0.00           H  
ATOM   2347  HB1 ALA A 148       7.215   7.300   4.858  1.00  0.00           H  
ATOM   2348  HB2 ALA A 148       8.779   7.101   4.068  1.00  0.00           H  
ATOM   2349  HB3 ALA A 148       8.384   8.620   4.873  1.00  0.00           H  
END
