
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   95 ( 1414),  selected   95 , name 2cqa_A
# Molecule2: number of CA atoms   66 ( 1132),  selected   66 , name T0468.pdb
# PARAMETERS: 2cqa_A.T0468.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      -       -           -
LGA    S     2_A      -       -           -
LGA    S     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    K     8_A      -       -           -
LGA    E     9_A      -       -           -
LGA    E    10_A      -       -           -
LGA    T    11_A      -       -           -
LGA    E    12_A      -       -           -
LGA    I    13_A      D      12          5.027
LGA    I    14_A      V      13          2.362
LGA    E    15_A      Y      14          3.026
LGA    G    16_A      Y      15          1.585
LGA    E    17_A      M      16          4.317
LGA    V    18_A      Q      17          1.419
LGA    V    19_A      I      18           #
LGA    E    20_A      K      19          4.395
LGA    I    21_A      -       -           -
LGA    Q    22_A      -       -           -
LGA    I    23_A      T      23          2.688
LGA    D    24_A      I      24          2.648
LGA    R    25_A      E      25          4.782
LGA    P    26_A      -       -           -
LGA    A    27_A      -       -           -
LGA    T    28_A      K      26          3.170
LGA    G    29_A      V      27          2.993
LGA    T    30_A      D      28          3.928
LGA    -       -      G      29           -
LGA    -       -      R      30           -
LGA    G    31_A      N      31          3.129
LGA    S    32_A      L      32          3.208
LGA    K    33_A      R      33          2.081
LGA    V    34_A      N      34          2.260
LGA    G    35_A      Y      35          2.421
LGA    K    36_A      T      36          1.089
LGA    L    37_A      L      37          1.823
LGA    T    38_A      P      38          1.024
LGA    L    39_A      A      39          1.108
LGA    K    40_A      Y      40          2.738
LGA    T    41_A      D      41          2.970
LGA    -       -      E      42           -
LGA    T    42_A      D      43          2.387
LGA    E    43_A      G      44          3.194
LGA    M    44_A      V      45          1.895
LGA    E    45_A      K      46          1.179
LGA    T    46_A      K      47          0.504
LGA    I    47_A      Q      48          0.861
LGA    Y    48_A      I      49          0.989
LGA    D    49_A      T      50          2.255
LGA    L    50_A      F      51          1.550
LGA    G    51_A      R      52          3.423
LGA    T    52_A      -       -           -
LGA    K    53_A      -       -           -
LGA    M    54_A      -       -           -
LGA    I    55_A      -       -           -
LGA    E    56_A      -       -           -
LGA    S    57_A      -       -           -
LGA    L    58_A      -       -           -
LGA    T    59_A      -       -           -
LGA    K    60_A      -       -           -
LGA    D    61_A      -       -           -
LGA    K    62_A      -       -           -
LGA    V    63_A      -       -           -
LGA    Q    64_A      -       -           -
LGA    A    65_A      -       -           -
LGA    G    66_A      -       -           -
LGA    D    67_A      A      66          2.800
LGA    V    68_A      F      67          2.334
LGA    I    69_A      L      68          0.948
LGA    T    70_A      R      69          1.019
LGA    I    71_A      L      70          1.503
LGA    D    72_A      Y      71          2.950
LGA    K    73_A      V      72          3.601
LGA    A    74_A      K      88          3.088
LGA    T    75_A      -       -           -
LGA    G    76_A      -       -           -
LGA    K    77_A      S      89          2.705
LGA    I    78_A      Y      90          1.717
LGA    S    79_A      E      91          1.082
LGA    K    80_A      E      92          1.086
LGA    L    81_A      I      93          1.986
LGA    G    82_A      Q      94          1.240
LGA    R    83_A      K      95          1.539
LGA    S    84_A      A      96          3.186
LGA    -       -      D      97           -
LGA    -       -      L      98           -
LGA    F    85_A      P      99          3.971
LGA    T    86_A      E     100          1.571
LGA    R    87_A      K     101          3.677
LGA    A    88_A      V     102           #
LGA    R    89_A      K     103           -
LGA    S    90_A      D     104           -
LGA    G    91_A      K     105           -
LGA    P    92_A      F     106           -
LGA    S    93_A      T     107           -
LGA    S    94_A      I     108           -
LGA    G    95_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   95   66    5.0     53    2.63     1.89     53.758     1.944

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.135372 * X  +  -0.879217 * Y  +   0.456784 * Z  +  -0.466319
  Y_new =   0.372518 * X  +   0.472367 * Y  +   0.798811 * Z  +   0.471618
  Z_new =  -0.918099 * X  +   0.062023 * Y  +   0.391469 * Z  +   1.447067 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.157131   -2.984461  [ DEG:     9.0030   -170.9970 ]
  Theta =   1.163256    1.978337  [ DEG:    66.6497    113.3503 ]
  Phi   =   1.222236   -1.919357  [ DEG:    70.0290   -109.9710 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2cqa_A                                        
REMARK     2: T0468.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2cqa_A.T0468.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   95   66   5.0   53   2.63    1.89  53.758
REMARK  ---------------------------------------------------------- 
MOLECULE 2cqa_A
HEADER    HYDROLASE                               19-MAY-05   2CQA              
TITLE     SOLUTION STRUCTURE OF RSGI RUH-039, A FRAGMENT OF C-                  
TITLE    2 TERMINAL DOMAIN OF RUVB-LIKE 2 FROM HUMAN CDNA                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: RUVB-LIKE 2;                                               
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: C-TERMINAL DOMAIN (RESIDUES 132-213);                      
COMPND   5 SYNONYM: 48-KDA TATA BOX-BINDING PROTEIN-INTERACTING                 
COMPND   6 PROTEIN, 48-KDA TBP-INTERACTING PROTEIN, TIP49B,                     
COMPND   7 REPRESSING PONTIN 52, REPTIN 52, 51 KDA ERYTHROCYTE                  
COMPND   8 CYTOSOLIC PROTEIN, ECP-51, TIP60-ASSOCIATED PROTEIN 54-              
COMPND   9 BETA, TAP54-BETA, CGI-46;                                            
COMPND  10 EC: 3.6.1.-;                                                         
COMPND  11 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: RUVBL2, TIP48, TIP49B;                                         
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P041004-05;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    RUVB LIKE 2, TIP48, TIP49B, REPTIN 52, ECP-51, TAP54-BETA,            
KEYWDS   2 STRUCTURAL GENOMICS, NPPSFA, NATIONAL PROJECT ON PROTEIN             
KEYWDS   3 STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN STRUCTURAL                 
KEYWDS   4 GENOMICS/PROTEOMICS INITIATIVE, RSGI                                 
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    T.ABE,H.HIROTA,K.SAITO,S.KOSHIBA,T.KIGAWA,S.YOKOYAMA,RIKEN            
AUTHOR   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)                     
REVDAT   1   19-NOV-05 2CQA    0                                                
JRNL        AUTH   T.ABE,H.HIROTA,K.SAITO,S.KOSHIBA,T.KIGAWA,                   
JRNL        AUTH 2 S.YOKOYAMA                                                   
JRNL        TITL   SOLUTION STRUCTURE OF RSGI RUH-039, A FRAGMENT OF            
JRNL        TITL 2 C-TERMINAL DOMAIN OF RUVB-LIKE 2 FROM HUMAN CDNA             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2CQA A    8    89  UNP    Q9Y230   RUVB2_HUMAN    131    212             
SEQRES   1 A   95  GLY SER SER GLY SER SER GLY LYS GLU GLU THR GLU ILE          
SEQRES   2 A   95  ILE GLU GLY GLU VAL VAL GLU ILE GLN ILE ASP ARG PRO          
SEQRES   3 A   95  ALA THR GLY THR GLY SER LYS VAL GLY LYS LEU THR LEU          
SEQRES   4 A   95  LYS THR THR GLU MET GLU THR ILE TYR ASP LEU GLY THR          
SEQRES   5 A   95  LYS MET ILE GLU SER LEU THR LYS ASP LYS VAL GLN ALA          
SEQRES   6 A   95  GLY ASP VAL ILE THR ILE ASP LYS ALA THR GLY LYS ILE          
SEQRES   7 A   95  SER LYS LEU GLY ARG SER PHE THR ARG ALA ARG SER GLY          
SEQRES   8 A   95  PRO SER SER GLY                                              
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1     -28.937 -19.984  13.934  1.00  0.00           N  
ATOM      2  CA  GLY A   1     -29.408 -20.704  12.764  1.00  0.00           C  
ATOM      3  C   GLY A   1     -28.329 -21.568  12.143  1.00  0.00           C  
ATOM      4  O   GLY A   1     -27.213 -21.645  12.657  1.00  0.00           O  
ATOM      5  HA2 GLY A   1     -30.237 -21.332  13.052  1.00  0.00           H  
ATOM      6  HA3 GLY A   1     -29.748 -19.989  12.029  1.00  0.00           H  
ATOM      7  H1  GLY A   1     -28.481 -19.123  13.826  1.00  0.00           H  
ATOM      8  N   SER A   2     -28.662 -22.222  11.035  1.00  0.00           N  
ATOM      9  CA  SER A   2     -27.714 -23.090  10.345  1.00  0.00           C  
ATOM     10  C   SER A   2     -26.742 -22.271   9.500  1.00  0.00           C  
ATOM     11  O   SER A   2     -25.536 -22.513   9.512  1.00  0.00           O  
ATOM     12  CB  SER A   2     -28.458 -24.092   9.460  1.00  0.00           C  
ATOM     13  OG  SER A   2     -27.556 -24.825   8.649  1.00  0.00           O  
ATOM     14  H   SER A   2     -29.567 -22.119  10.673  1.00  0.00           H  
ATOM     15  HA  SER A   2     -27.154 -23.630  11.094  1.00  0.00           H  
ATOM     16  HB2 SER A   2     -29.006 -24.782  10.084  1.00  0.00           H  
ATOM     17  HB3 SER A   2     -29.148 -23.559   8.820  1.00  0.00           H  
ATOM     18  HG  SER A   2     -27.644 -24.544   7.736  1.00  0.00           H  
ATOM     19  N   SER A   3     -27.279 -21.300   8.766  1.00  0.00           N  
ATOM     20  CA  SER A   3     -26.461 -20.447   7.912  1.00  0.00           C  
ATOM     21  C   SER A   3     -25.225 -19.955   8.659  1.00  0.00           C  
ATOM     22  O   SER A   3     -25.327 -19.399   9.752  1.00  0.00           O  
ATOM     23  CB  SER A   3     -27.280 -19.254   7.415  1.00  0.00           C  
ATOM     24  OG  SER A   3     -26.523 -18.453   6.524  1.00  0.00           O  
ATOM     25  H   SER A   3     -28.248 -21.157   8.800  1.00  0.00           H  
ATOM     26  HA  SER A   3     -26.144 -21.035   7.064  1.00  0.00           H  
ATOM     27  HB2 SER A   3     -28.158 -19.612   6.899  1.00  0.00           H  
ATOM     28  HB3 SER A   3     -27.579 -18.649   8.259  1.00  0.00           H  
ATOM     29  HG  SER A   3     -26.208 -17.672   6.985  1.00  0.00           H  
ATOM     30  N   GLY A   4     -24.057 -20.164   8.059  1.00  0.00           N  
ATOM     31  CA  GLY A   4     -22.818 -19.736   8.681  1.00  0.00           C  
ATOM     32  C   GLY A   4     -21.809 -20.861   8.798  1.00  0.00           C  
ATOM     33  O   GLY A   4     -22.156 -21.977   9.185  1.00  0.00           O  
ATOM     34  H   GLY A   4     -24.037 -20.611   7.188  1.00  0.00           H  
ATOM     35  HA2 GLY A   4     -22.388 -18.940   8.090  1.00  0.00           H  
ATOM     36  HA3 GLY A   4     -23.036 -19.359   9.670  1.00  0.00           H  
ATOM     37  N   SER A   5     -20.557 -20.569   8.462  1.00  0.00           N  
ATOM     38  CA  SER A   5     -19.495 -21.567   8.526  1.00  0.00           C  
ATOM     39  C   SER A   5     -18.149 -20.910   8.816  1.00  0.00           C  
ATOM     40  O   SER A   5     -18.019 -19.687   8.770  1.00  0.00           O  
ATOM     41  CB  SER A   5     -19.422 -22.350   7.214  1.00  0.00           C  
ATOM     42  OG  SER A   5     -18.623 -23.511   7.356  1.00  0.00           O  
ATOM     43  H   SER A   5     -20.343 -19.661   8.161  1.00  0.00           H  
ATOM     44  HA  SER A   5     -19.730 -22.249   9.330  1.00  0.00           H  
ATOM     45  HB2 SER A   5     -20.417 -22.646   6.919  1.00  0.00           H  
ATOM     46  HB3 SER A   5     -18.991 -21.722   6.447  1.00  0.00           H  
ATOM     47  HG  SER A   5     -18.389 -23.847   6.489  1.00  0.00           H  
ATOM     48  N   SER A   6     -17.148 -21.733   9.114  1.00  0.00           N  
ATOM     49  CA  SER A   6     -15.812 -21.233   9.415  1.00  0.00           C  
ATOM     50  C   SER A   6     -15.070 -20.863   8.134  1.00  0.00           C  
ATOM     51  O   SER A   6     -14.382 -21.691   7.539  1.00  0.00           O  
ATOM     52  CB  SER A   6     -15.016 -22.282  10.194  1.00  0.00           C  
ATOM     53  OG  SER A   6     -15.026 -23.531   9.524  1.00  0.00           O  
ATOM     54  H   SER A   6     -17.314 -22.699   9.135  1.00  0.00           H  
ATOM     55  HA  SER A   6     -15.918 -20.348  10.024  1.00  0.00           H  
ATOM     56  HB2 SER A   6     -13.994 -21.951  10.297  1.00  0.00           H  
ATOM     57  HB3 SER A   6     -15.454 -22.408  11.174  1.00  0.00           H  
ATOM     58  HG  SER A   6     -14.133 -23.882   9.488  1.00  0.00           H  
ATOM     59  N   GLY A   7     -15.213 -19.608   7.716  1.00  0.00           N  
ATOM     60  CA  GLY A   7     -14.551 -19.148   6.509  1.00  0.00           C  
ATOM     61  C   GLY A   7     -14.038 -17.728   6.635  1.00  0.00           C  
ATOM     62  O   GLY A   7     -13.089 -17.466   7.376  1.00  0.00           O  
ATOM     63  H   GLY A   7     -15.774 -18.991   8.231  1.00  0.00           H  
ATOM     64  HA2 GLY A   7     -13.720 -19.804   6.296  1.00  0.00           H  
ATOM     65  HA3 GLY A   7     -15.253 -19.194   5.689  1.00  0.00           H  
ATOM     66  N   LYS A   8     -14.662 -16.808   5.909  1.00  0.00           N  
ATOM     67  CA  LYS A   8     -14.264 -15.406   5.942  1.00  0.00           C  
ATOM     68  C   LYS A   8     -12.810 -15.244   5.512  1.00  0.00           C  
ATOM     69  O   LYS A   8     -12.041 -14.527   6.150  1.00  0.00           O  
ATOM     70  CB  LYS A   8     -14.458 -14.831   7.346  1.00  0.00           C  
ATOM     71  CG  LYS A   8     -14.299 -13.323   7.414  1.00  0.00           C  
ATOM     72  CD  LYS A   8     -15.131 -12.724   8.536  1.00  0.00           C  
ATOM     73  CE  LYS A   8     -14.735 -11.282   8.815  1.00  0.00           C  
ATOM     74  NZ  LYS A   8     -15.246 -10.354   7.768  1.00  0.00           N  
ATOM     75  H   LYS A   8     -15.412 -17.078   5.338  1.00  0.00           H  
ATOM     76  HA  LYS A   8     -14.894 -14.866   5.251  1.00  0.00           H  
ATOM     77  HB2 LYS A   8     -15.450 -15.084   7.691  1.00  0.00           H  
ATOM     78  HB3 LYS A   8     -13.732 -15.279   8.009  1.00  0.00           H  
ATOM     79  HG2 LYS A   8     -13.260 -13.086   7.586  1.00  0.00           H  
ATOM     80  HG3 LYS A   8     -14.617 -12.894   6.474  1.00  0.00           H  
ATOM     81  HD2 LYS A   8     -16.173 -12.751   8.254  1.00  0.00           H  
ATOM     82  HD3 LYS A   8     -14.984 -13.308   9.432  1.00  0.00           H  
ATOM     83  HE2 LYS A   8     -15.139 -10.990   9.772  1.00  0.00           H  
ATOM     84  HE3 LYS A   8     -13.658 -11.218   8.846  1.00  0.00           H  
ATOM     85  HZ1 LYS A   8     -15.883 -10.861   7.122  1.00  0.00           H  
ATOM     86  HZ2 LYS A   8     -14.454  -9.963   7.219  1.00  0.00           H  
ATOM     87  HZ3 LYS A   8     -15.768  -9.571   8.210  1.00  0.00           H  
ATOM     88  N   GLU A   9     -12.441 -15.913   4.423  1.00  0.00           N  
ATOM     89  CA  GLU A   9     -11.078 -15.842   3.909  1.00  0.00           C  
ATOM     90  C   GLU A   9     -10.919 -14.664   2.953  1.00  0.00           C  
ATOM     91  O   GLU A   9     -10.185 -14.744   1.969  1.00  0.00           O  
ATOM     92  CB  GLU A   9     -10.710 -17.144   3.195  1.00  0.00           C  
ATOM     93  CG  GLU A   9     -11.575 -17.438   1.981  1.00  0.00           C  
ATOM     94  CD  GLU A   9     -11.019 -16.832   0.708  1.00  0.00           C  
ATOM     95  OE1 GLU A   9      -9.986 -17.332   0.214  1.00  0.00           O  
ATOM     96  OE2 GLU A   9     -11.616 -15.856   0.206  1.00  0.00           O  
ATOM     97  H   GLU A   9     -13.099 -16.468   3.957  1.00  0.00           H  
ATOM     98  HA  GLU A   9     -10.414 -15.702   4.748  1.00  0.00           H  
ATOM     99  HB2 GLU A   9      -9.680 -17.086   2.873  1.00  0.00           H  
ATOM    100  HB3 GLU A   9     -10.813 -17.963   3.892  1.00  0.00           H  
ATOM    101  HG2 GLU A   9     -11.641 -18.509   1.853  1.00  0.00           H  
ATOM    102  HG3 GLU A   9     -12.562 -17.037   2.153  1.00  0.00           H  
ATOM    103  N   GLU A  10     -11.612 -13.569   3.251  1.00  0.00           N  
ATOM    104  CA  GLU A  10     -11.548 -12.374   2.418  1.00  0.00           C  
ATOM    105  C   GLU A  10     -11.600 -11.111   3.273  1.00  0.00           C  
ATOM    106  O   GLU A  10     -12.608 -10.826   3.921  1.00  0.00           O  
ATOM    107  CB  GLU A  10     -12.699 -12.367   1.409  1.00  0.00           C  
ATOM    108  CG  GLU A  10     -12.370 -11.641   0.116  1.00  0.00           C  
ATOM    109  CD  GLU A  10     -12.659 -10.154   0.193  1.00  0.00           C  
ATOM    110  OE1 GLU A  10     -11.780  -9.403   0.664  1.00  0.00           O  
ATOM    111  OE2 GLU A  10     -13.763  -9.741  -0.219  1.00  0.00           O  
ATOM    112  H   GLU A  10     -12.180 -13.565   4.051  1.00  0.00           H  
ATOM    113  HA  GLU A  10     -10.612 -12.394   1.882  1.00  0.00           H  
ATOM    114  HB2 GLU A  10     -12.958 -13.388   1.169  1.00  0.00           H  
ATOM    115  HB3 GLU A  10     -13.554 -11.885   1.860  1.00  0.00           H  
ATOM    116  HG2 GLU A  10     -11.321 -11.777  -0.102  1.00  0.00           H  
ATOM    117  HG3 GLU A  10     -12.961 -12.066  -0.681  1.00  0.00           H  
ATOM    118  N   THR A  11     -10.505 -10.357   3.270  1.00  0.00           N  
ATOM    119  CA  THR A  11     -10.423  -9.125   4.046  1.00  0.00           C  
ATOM    120  C   THR A  11     -10.235  -7.915   3.138  1.00  0.00           C  
ATOM    121  O   THR A  11      -9.469  -7.963   2.176  1.00  0.00           O  
ATOM    122  CB  THR A  11      -9.266  -9.177   5.061  1.00  0.00           C  
ATOM    123  OG1 THR A  11      -9.399 -10.330   5.899  1.00  0.00           O  
ATOM    124  CG2 THR A  11      -9.241  -7.921   5.918  1.00  0.00           C  
ATOM    125  H   THR A  11      -9.734 -10.637   2.734  1.00  0.00           H  
ATOM    126  HA  THR A  11     -11.348  -9.013   4.592  1.00  0.00           H  
ATOM    127  HB  THR A  11      -8.333  -9.242   4.517  1.00  0.00           H  
ATOM    128  HG1 THR A  11      -8.942 -10.177   6.729  1.00  0.00           H  
ATOM    129 HG21 THR A  11      -9.472  -8.178   6.941  1.00  0.00           H  
ATOM    130 HG22 THR A  11      -9.974  -7.219   5.549  1.00  0.00           H  
ATOM    131 HG23 THR A  11      -8.260  -7.473   5.873  1.00  0.00           H  
ATOM    132  N   GLU A  12     -10.938  -6.832   3.451  1.00  0.00           N  
ATOM    133  CA  GLU A  12     -10.847  -5.608   2.661  1.00  0.00           C  
ATOM    134  C   GLU A  12      -9.770  -4.681   3.218  1.00  0.00           C  
ATOM    135  O   GLU A  12      -9.916  -3.459   3.193  1.00  0.00           O  
ATOM    136  CB  GLU A  12     -12.196  -4.887   2.641  1.00  0.00           C  
ATOM    137  CG  GLU A  12     -13.301  -5.681   1.963  1.00  0.00           C  
ATOM    138  CD  GLU A  12     -13.186  -5.665   0.452  1.00  0.00           C  
ATOM    139  OE1 GLU A  12     -12.059  -5.833  -0.060  1.00  0.00           O  
ATOM    140  OE2 GLU A  12     -14.224  -5.486  -0.220  1.00  0.00           O  
ATOM    141  H   GLU A  12     -11.532  -6.855   4.230  1.00  0.00           H  
ATOM    142  HA  GLU A  12     -10.581  -5.884   1.652  1.00  0.00           H  
ATOM    143  HB2 GLU A  12     -12.498  -4.685   3.657  1.00  0.00           H  
ATOM    144  HB3 GLU A  12     -12.082  -3.950   2.116  1.00  0.00           H  
ATOM    145  HG2 GLU A  12     -13.251  -6.705   2.302  1.00  0.00           H  
ATOM    146  HG3 GLU A  12     -14.254  -5.257   2.242  1.00  0.00           H  
ATOM    147  N   ILE A  13      -8.691  -5.272   3.719  1.00  0.00           N  
ATOM    148  CA  ILE A  13      -7.590  -4.499   4.281  1.00  0.00           C  
ATOM    149  C   ILE A  13      -6.242  -5.096   3.888  1.00  0.00           C  
ATOM    150  O   ILE A  13      -6.068  -6.315   3.892  1.00  0.00           O  
ATOM    151  CB  ILE A  13      -7.678  -4.427   5.817  1.00  0.00           C  
ATOM    152  CG1 ILE A  13      -9.126  -4.201   6.256  1.00  0.00           C  
ATOM    153  CG2 ILE A  13      -6.779  -3.320   6.348  1.00  0.00           C  
ATOM    154  CD1 ILE A  13      -9.560  -2.754   6.187  1.00  0.00           C  
ATOM    155  H   ILE A  13      -8.633  -6.249   3.711  1.00  0.00           H  
ATOM    156  HA  ILE A  13      -7.654  -3.494   3.889  1.00  0.00           H  
ATOM    157  HB  ILE A  13      -7.330  -5.366   6.219  1.00  0.00           H  
ATOM    158 HG12 ILE A  13      -9.782  -4.774   5.620  1.00  0.00           H  
ATOM    159 HG13 ILE A  13      -9.241  -4.534   7.277  1.00  0.00           H  
ATOM    160 HG21 ILE A  13      -5.747  -3.576   6.164  1.00  0.00           H  
ATOM    161 HG22 ILE A  13      -7.015  -2.394   5.846  1.00  0.00           H  
ATOM    162 HG23 ILE A  13      -6.938  -3.205   7.410  1.00  0.00           H  
ATOM    163 HD11 ILE A  13      -9.377  -2.370   5.194  1.00  0.00           H  
ATOM    164 HD12 ILE A  13     -10.613  -2.681   6.414  1.00  0.00           H  
ATOM    165 HD13 ILE A  13      -8.997  -2.174   6.905  1.00  0.00           H  
ATOM    166  N   ILE A  14      -5.293  -4.229   3.552  1.00  0.00           N  
ATOM    167  CA  ILE A  14      -3.961  -4.671   3.160  1.00  0.00           C  
ATOM    168  C   ILE A  14      -2.883  -3.814   3.814  1.00  0.00           C  
ATOM    169  O   ILE A  14      -2.907  -2.588   3.718  1.00  0.00           O  
ATOM    170  CB  ILE A  14      -3.779  -4.624   1.630  1.00  0.00           C  
ATOM    171  CG1 ILE A  14      -5.113  -4.895   0.929  1.00  0.00           C  
ATOM    172  CG2 ILE A  14      -2.729  -5.633   1.191  1.00  0.00           C  
ATOM    173  CD1 ILE A  14      -5.100  -4.551  -0.544  1.00  0.00           C  
ATOM    174  H   ILE A  14      -5.493  -3.270   3.568  1.00  0.00           H  
ATOM    175  HA  ILE A  14      -3.840  -5.695   3.485  1.00  0.00           H  
ATOM    176  HB  ILE A  14      -3.433  -3.638   1.361  1.00  0.00           H  
ATOM    177 HG12 ILE A  14      -5.354  -5.942   1.023  1.00  0.00           H  
ATOM    178 HG13 ILE A  14      -5.886  -4.306   1.402  1.00  0.00           H  
ATOM    179 HG21 ILE A  14      -2.958  -6.600   1.613  1.00  0.00           H  
ATOM    180 HG22 ILE A  14      -2.727  -5.703   0.114  1.00  0.00           H  
ATOM    181 HG23 ILE A  14      -1.757  -5.312   1.533  1.00  0.00           H  
ATOM    182 HD11 ILE A  14      -4.135  -4.793  -0.963  1.00  0.00           H  
ATOM    183 HD12 ILE A  14      -5.867  -5.115  -1.053  1.00  0.00           H  
ATOM    184 HD13 ILE A  14      -5.289  -3.494  -0.668  1.00  0.00           H  
ATOM    185  N   GLU A  15      -1.936  -4.470   4.479  1.00  0.00           N  
ATOM    186  CA  GLU A  15      -0.848  -3.768   5.148  1.00  0.00           C  
ATOM    187  C   GLU A  15       0.504  -4.204   4.593  1.00  0.00           C  
ATOM    188  O   GLU A  15       0.811  -5.394   4.539  1.00  0.00           O  
ATOM    189  CB  GLU A  15      -0.898  -4.022   6.656  1.00  0.00           C  
ATOM    190  CG  GLU A  15       0.300  -3.469   7.408  1.00  0.00           C  
ATOM    191  CD  GLU A  15       0.365  -3.956   8.842  1.00  0.00           C  
ATOM    192  OE1 GLU A  15      -0.702  -4.073   9.479  1.00  0.00           O  
ATOM    193  OE2 GLU A  15       1.485  -4.220   9.328  1.00  0.00           O  
ATOM    194  H   GLU A  15      -1.971  -5.448   4.520  1.00  0.00           H  
ATOM    195  HA  GLU A  15      -0.974  -2.710   4.967  1.00  0.00           H  
ATOM    196  HB2 GLU A  15      -1.791  -3.566   7.057  1.00  0.00           H  
ATOM    197  HB3 GLU A  15      -0.943  -5.087   6.827  1.00  0.00           H  
ATOM    198  HG2 GLU A  15       1.201  -3.775   6.899  1.00  0.00           H  
ATOM    199  HG3 GLU A  15       0.239  -2.390   7.412  1.00  0.00           H  
ATOM    200  N   GLY A  16       1.311  -3.229   4.180  1.00  0.00           N  
ATOM    201  CA  GLY A  16       2.620  -3.532   3.633  1.00  0.00           C  
ATOM    202  C   GLY A  16       3.648  -2.469   3.968  1.00  0.00           C  
ATOM    203  O   GLY A  16       3.325  -1.463   4.597  1.00  0.00           O  
ATOM    204  H   GLY A  16       1.013  -2.298   4.247  1.00  0.00           H  
ATOM    205  HA2 GLY A  16       2.955  -4.478   4.031  1.00  0.00           H  
ATOM    206  HA3 GLY A  16       2.539  -3.613   2.559  1.00  0.00           H  
ATOM    207  N   GLU A  17       4.888  -2.694   3.547  1.00  0.00           N  
ATOM    208  CA  GLU A  17       5.966  -1.747   3.808  1.00  0.00           C  
ATOM    209  C   GLU A  17       6.071  -0.719   2.685  1.00  0.00           C  
ATOM    210  O   GLU A  17       6.547  -1.022   1.592  1.00  0.00           O  
ATOM    211  CB  GLU A  17       7.297  -2.486   3.962  1.00  0.00           C  
ATOM    212  CG  GLU A  17       8.495  -1.561   4.096  1.00  0.00           C  
ATOM    213  CD  GLU A  17       9.816  -2.298   3.994  1.00  0.00           C  
ATOM    214  OE1 GLU A  17      10.306  -2.787   5.033  1.00  0.00           O  
ATOM    215  OE2 GLU A  17      10.359  -2.388   2.873  1.00  0.00           O  
ATOM    216  H   GLU A  17       5.083  -3.516   3.049  1.00  0.00           H  
ATOM    217  HA  GLU A  17       5.741  -1.234   4.730  1.00  0.00           H  
ATOM    218  HB2 GLU A  17       7.249  -3.110   4.844  1.00  0.00           H  
ATOM    219  HB3 GLU A  17       7.449  -3.114   3.097  1.00  0.00           H  
ATOM    220  HG2 GLU A  17       8.452  -0.821   3.312  1.00  0.00           H  
ATOM    221  HG3 GLU A  17       8.448  -1.068   5.057  1.00  0.00           H  
ATOM    222  N   VAL A  18       5.621   0.501   2.966  1.00  0.00           N  
ATOM    223  CA  VAL A  18       5.664   1.576   1.981  1.00  0.00           C  
ATOM    224  C   VAL A  18       6.978   1.561   1.208  1.00  0.00           C  
ATOM    225  O   VAL A  18       7.994   2.072   1.680  1.00  0.00           O  
ATOM    226  CB  VAL A  18       5.488   2.954   2.647  1.00  0.00           C  
ATOM    227  CG1 VAL A  18       5.244   4.027   1.597  1.00  0.00           C  
ATOM    228  CG2 VAL A  18       4.351   2.915   3.655  1.00  0.00           C  
ATOM    229  H   VAL A  18       5.253   0.682   3.855  1.00  0.00           H  
ATOM    230  HA  VAL A  18       4.848   1.427   1.289  1.00  0.00           H  
ATOM    231  HB  VAL A  18       6.400   3.196   3.172  1.00  0.00           H  
ATOM    232 HG11 VAL A  18       4.184   4.118   1.414  1.00  0.00           H  
ATOM    233 HG12 VAL A  18       5.633   4.971   1.950  1.00  0.00           H  
ATOM    234 HG13 VAL A  18       5.744   3.753   0.679  1.00  0.00           H  
ATOM    235 HG21 VAL A  18       3.741   2.043   3.478  1.00  0.00           H  
ATOM    236 HG22 VAL A  18       4.757   2.873   4.655  1.00  0.00           H  
ATOM    237 HG23 VAL A  18       3.746   3.804   3.551  1.00  0.00           H  
ATOM    238  N   VAL A  19       6.951   0.972   0.016  1.00  0.00           N  
ATOM    239  CA  VAL A  19       8.140   0.892  -0.823  1.00  0.00           C  
ATOM    240  C   VAL A  19       8.370   2.197  -1.577  1.00  0.00           C  
ATOM    241  O   VAL A  19       9.432   2.809  -1.466  1.00  0.00           O  
ATOM    242  CB  VAL A  19       8.033  -0.262  -1.839  1.00  0.00           C  
ATOM    243  CG1 VAL A  19       9.233  -0.264  -2.773  1.00  0.00           C  
ATOM    244  CG2 VAL A  19       7.904  -1.595  -1.119  1.00  0.00           C  
ATOM    245  H   VAL A  19       6.112   0.582  -0.305  1.00  0.00           H  
ATOM    246  HA  VAL A  19       8.989   0.702  -0.184  1.00  0.00           H  
ATOM    247  HB  VAL A  19       7.144  -0.110  -2.432  1.00  0.00           H  
ATOM    248 HG11 VAL A  19       8.892  -0.261  -3.798  1.00  0.00           H  
ATOM    249 HG12 VAL A  19       9.835   0.614  -2.589  1.00  0.00           H  
ATOM    250 HG13 VAL A  19       9.825  -1.150  -2.595  1.00  0.00           H  
ATOM    251 HG21 VAL A  19       6.941  -1.651  -0.635  1.00  0.00           H  
ATOM    252 HG22 VAL A  19       7.996  -2.401  -1.832  1.00  0.00           H  
ATOM    253 HG23 VAL A  19       8.685  -1.681  -0.377  1.00  0.00           H  
ATOM    254  N   GLU A  20       7.367   2.618  -2.341  1.00  0.00           N  
ATOM    255  CA  GLU A  20       7.461   3.851  -3.112  1.00  0.00           C  
ATOM    256  C   GLU A  20       6.103   4.541  -3.205  1.00  0.00           C  
ATOM    257  O   GLU A  20       5.060   3.885  -3.185  1.00  0.00           O  
ATOM    258  CB  GLU A  20       7.994   3.561  -4.517  1.00  0.00           C  
ATOM    259  CG  GLU A  20       8.540   4.790  -5.227  1.00  0.00           C  
ATOM    260  CD  GLU A  20      10.007   5.031  -4.930  1.00  0.00           C  
ATOM    261  OE1 GLU A  20      10.360   5.148  -3.737  1.00  0.00           O  
ATOM    262  OE2 GLU A  20      10.803   5.104  -5.890  1.00  0.00           O  
ATOM    263  H   GLU A  20       6.545   2.086  -2.388  1.00  0.00           H  
ATOM    264  HA  GLU A  20       8.150   4.509  -2.604  1.00  0.00           H  
ATOM    265  HB2 GLU A  20       8.786   2.831  -4.444  1.00  0.00           H  
ATOM    266  HB3 GLU A  20       7.194   3.152  -5.115  1.00  0.00           H  
ATOM    267  HG2 GLU A  20       8.421   4.657  -6.291  1.00  0.00           H  
ATOM    268  HG3 GLU A  20       7.976   5.654  -4.907  1.00  0.00           H  
ATOM    269  N   ILE A  21       6.124   5.865  -3.304  1.00  0.00           N  
ATOM    270  CA  ILE A  21       4.894   6.643  -3.399  1.00  0.00           C  
ATOM    271  C   ILE A  21       4.982   7.674  -4.519  1.00  0.00           C  
ATOM    272  O   ILE A  21       5.556   8.749  -4.343  1.00  0.00           O  
ATOM    273  CB  ILE A  21       4.580   7.365  -2.076  1.00  0.00           C  
ATOM    274  CG1 ILE A  21       4.342   6.347  -0.958  1.00  0.00           C  
ATOM    275  CG2 ILE A  21       3.369   8.270  -2.241  1.00  0.00           C  
ATOM    276  CD1 ILE A  21       4.734   6.851   0.413  1.00  0.00           C  
ATOM    277  H   ILE A  21       6.985   6.330  -3.314  1.00  0.00           H  
ATOM    278  HA  ILE A  21       4.084   5.961  -3.616  1.00  0.00           H  
ATOM    279  HB  ILE A  21       5.428   7.980  -1.817  1.00  0.00           H  
ATOM    280 HG12 ILE A  21       3.295   6.091  -0.930  1.00  0.00           H  
ATOM    281 HG13 ILE A  21       4.920   5.457  -1.163  1.00  0.00           H  
ATOM    282 HG21 ILE A  21       2.693   8.122  -1.412  1.00  0.00           H  
ATOM    283 HG22 ILE A  21       3.690   9.301  -2.261  1.00  0.00           H  
ATOM    284 HG23 ILE A  21       2.864   8.032  -3.165  1.00  0.00           H  
ATOM    285 HD11 ILE A  21       4.259   6.244   1.169  1.00  0.00           H  
ATOM    286 HD12 ILE A  21       5.807   6.794   0.525  1.00  0.00           H  
ATOM    287 HD13 ILE A  21       4.415   7.877   0.523  1.00  0.00           H  
ATOM    288  N   GLN A  22       4.408   7.340  -5.670  1.00  0.00           N  
ATOM    289  CA  GLN A  22       4.420   8.238  -6.819  1.00  0.00           C  
ATOM    290  C   GLN A  22       3.172   9.114  -6.839  1.00  0.00           C  
ATOM    291  O   GLN A  22       2.065   8.642  -6.571  1.00  0.00           O  
ATOM    292  CB  GLN A  22       4.516   7.438  -8.118  1.00  0.00           C  
ATOM    293  CG  GLN A  22       4.459   8.299  -9.369  1.00  0.00           C  
ATOM    294  CD  GLN A  22       3.917   7.549 -10.570  1.00  0.00           C  
ATOM    295  OE1 GLN A  22       4.622   6.752 -11.190  1.00  0.00           O  
ATOM    296  NE2 GLN A  22       2.657   7.800 -10.906  1.00  0.00           N  
ATOM    297  H   GLN A  22       3.966   6.469  -5.749  1.00  0.00           H  
ATOM    298  HA  GLN A  22       5.288   8.874  -6.733  1.00  0.00           H  
ATOM    299  HB2 GLN A  22       5.449   6.893  -8.124  1.00  0.00           H  
ATOM    300  HB3 GLN A  22       3.698   6.733  -8.155  1.00  0.00           H  
ATOM    301  HG2 GLN A  22       3.820   9.149  -9.178  1.00  0.00           H  
ATOM    302  HG3 GLN A  22       5.456   8.644  -9.600  1.00  0.00           H  
ATOM    303 HE21 GLN A  22       2.155   8.449 -10.368  1.00  0.00           H  
ATOM    304 HE22 GLN A  22       2.280   7.330 -11.678  1.00  0.00           H  
ATOM    305  N   ILE A  23       3.355  10.391  -7.156  1.00  0.00           N  
ATOM    306  CA  ILE A  23       2.244  11.332  -7.211  1.00  0.00           C  
ATOM    307  C   ILE A  23       2.221  12.080  -8.541  1.00  0.00           C  
ATOM    308  O   ILE A  23       3.171  12.783  -8.885  1.00  0.00           O  
ATOM    309  CB  ILE A  23       2.314  12.354  -6.062  1.00  0.00           C  
ATOM    310  CG1 ILE A  23       1.978  11.681  -4.730  1.00  0.00           C  
ATOM    311  CG2 ILE A  23       1.368  13.516  -6.328  1.00  0.00           C  
ATOM    312  CD1 ILE A  23       0.540  11.222  -4.631  1.00  0.00           C  
ATOM    313  H   ILE A  23       4.260  10.707  -7.359  1.00  0.00           H  
ATOM    314  HA  ILE A  23       1.326  10.770  -7.111  1.00  0.00           H  
ATOM    315  HB  ILE A  23       3.320  12.743  -6.016  1.00  0.00           H  
ATOM    316 HG12 ILE A  23       2.610  10.817  -4.601  1.00  0.00           H  
ATOM    317 HG13 ILE A  23       2.160  12.379  -3.926  1.00  0.00           H  
ATOM    318 HG21 ILE A  23       1.110  13.991  -5.393  1.00  0.00           H  
ATOM    319 HG22 ILE A  23       1.852  14.234  -6.973  1.00  0.00           H  
ATOM    320 HG23 ILE A  23       0.472  13.149  -6.805  1.00  0.00           H  
ATOM    321 HD11 ILE A  23       0.400  10.337  -5.234  1.00  0.00           H  
ATOM    322 HD12 ILE A  23       0.302  10.999  -3.602  1.00  0.00           H  
ATOM    323 HD13 ILE A  23      -0.113  12.006  -4.988  1.00  0.00           H  
ATOM    324  N   ASP A  24       1.131  11.922  -9.283  1.00  0.00           N  
ATOM    325  CA  ASP A  24       0.982  12.585 -10.573  1.00  0.00           C  
ATOM    326  C   ASP A  24       0.369  13.971 -10.406  1.00  0.00           C  
ATOM    327  O   ASP A  24      -0.624  14.139  -9.698  1.00  0.00           O  
ATOM    328  CB  ASP A  24       0.115  11.739 -11.508  1.00  0.00           C  
ATOM    329  CG  ASP A  24       0.444  11.970 -12.969  1.00  0.00           C  
ATOM    330  OD1 ASP A  24       1.590  12.372 -13.264  1.00  0.00           O  
ATOM    331  OD2 ASP A  24      -0.443  11.747 -13.819  1.00  0.00           O  
ATOM    332  H   ASP A  24       0.407  11.347  -8.954  1.00  0.00           H  
ATOM    333  HA  ASP A  24       1.965  12.690 -11.007  1.00  0.00           H  
ATOM    334  HB2 ASP A  24       0.270  10.694 -11.284  1.00  0.00           H  
ATOM    335  HB3 ASP A  24      -0.923  11.988 -11.347  1.00  0.00           H  
ATOM    336  N   ARG A  25       0.967  14.960 -11.061  1.00  0.00           N  
ATOM    337  CA  ARG A  25       0.480  16.333 -10.982  1.00  0.00           C  
ATOM    338  C   ARG A  25      -0.597  16.589 -12.033  1.00  0.00           C  
ATOM    339  O   ARG A  25      -0.666  15.919 -13.063  1.00  0.00           O  
ATOM    340  CB  ARG A  25       1.636  17.317 -11.172  1.00  0.00           C  
ATOM    341  CG  ARG A  25       2.320  17.710  -9.872  1.00  0.00           C  
ATOM    342  CD  ARG A  25       3.788  18.039 -10.093  1.00  0.00           C  
ATOM    343  NE  ARG A  25       4.445  18.464  -8.860  1.00  0.00           N  
ATOM    344  CZ  ARG A  25       5.564  19.179  -8.831  1.00  0.00           C  
ATOM    345  NH1 ARG A  25       6.147  19.549  -9.964  1.00  0.00           N  
ATOM    346  NH2 ARG A  25       6.103  19.526  -7.669  1.00  0.00           N  
ATOM    347  H   ARG A  25       1.755  14.764 -11.610  1.00  0.00           H  
ATOM    348  HA  ARG A  25       0.053  16.478 -10.002  1.00  0.00           H  
ATOM    349  HB2 ARG A  25       2.374  16.868 -11.819  1.00  0.00           H  
ATOM    350  HB3 ARG A  25       1.257  18.213 -11.638  1.00  0.00           H  
ATOM    351  HG2 ARG A  25       1.826  18.579  -9.464  1.00  0.00           H  
ATOM    352  HG3 ARG A  25       2.244  16.889  -9.174  1.00  0.00           H  
ATOM    353  HD2 ARG A  25       4.288  17.160 -10.471  1.00  0.00           H  
ATOM    354  HD3 ARG A  25       3.860  18.834 -10.820  1.00  0.00           H  
ATOM    355  HE  ARG A  25       4.032  18.201  -8.011  1.00  0.00           H  
ATOM    356 HH11 ARG A  25       5.743  19.289 -10.841  1.00  0.00           H  
ATOM    357 HH12 ARG A  25       6.988  20.089  -9.940  1.00  0.00           H  
ATOM    358 HH21 ARG A  25       5.666  19.251  -6.814  1.00  0.00           H  
ATOM    359 HH22 ARG A  25       6.944  20.066  -7.650  1.00  0.00           H  
ATOM    360  N   PRO A  26      -1.459  17.582 -11.766  1.00  0.00           N  
ATOM    361  CA  PRO A  26      -2.548  17.949 -12.676  1.00  0.00           C  
ATOM    362  C   PRO A  26      -2.039  18.602 -13.955  1.00  0.00           C  
ATOM    363  O   PRO A  26      -2.808  18.855 -14.882  1.00  0.00           O  
ATOM    364  CB  PRO A  26      -3.371  18.947 -11.857  1.00  0.00           C  
ATOM    365  CG  PRO A  26      -2.407  19.524 -10.880  1.00  0.00           C  
ATOM    366  CD  PRO A  26      -1.435  18.422 -10.557  1.00  0.00           C  
ATOM    367  HA  PRO A  26      -3.160  17.095 -12.927  1.00  0.00           H  
ATOM    368  HB2 PRO A  26      -3.775  19.706 -12.512  1.00  0.00           H  
ATOM    369  HB3 PRO A  26      -4.177  18.429 -11.358  1.00  0.00           H  
ATOM    370  HG2 PRO A  26      -1.890  20.360 -11.325  1.00  0.00           H  
ATOM    371  HG3 PRO A  26      -2.929  19.835  -9.989  1.00  0.00           H  
ATOM    372  HD2 PRO A  26      -0.448  18.826 -10.387  1.00  0.00           H  
ATOM    373  HD3 PRO A  26      -1.770  17.865  -9.695  1.00  0.00           H  
ATOM    374  N   ALA A  27      -0.738  18.873 -14.000  1.00  0.00           N  
ATOM    375  CA  ALA A  27      -0.126  19.494 -15.168  1.00  0.00           C  
ATOM    376  C   ALA A  27      -0.778  19.001 -16.456  1.00  0.00           C  
ATOM    377  O   ALA A  27      -1.064  19.787 -17.360  1.00  0.00           O  
ATOM    378  CB  ALA A  27       1.370  19.218 -15.191  1.00  0.00           C  
ATOM    379  H   ALA A  27      -0.177  18.647 -13.229  1.00  0.00           H  
ATOM    380  HA  ALA A  27      -0.269  20.562 -15.090  1.00  0.00           H  
ATOM    381  HB1 ALA A  27       1.769  19.480 -16.159  1.00  0.00           H  
ATOM    382  HB2 ALA A  27       1.856  19.807 -14.428  1.00  0.00           H  
ATOM    383  HB3 ALA A  27       1.543  18.168 -15.002  1.00  0.00           H  
ATOM    384  N   THR A  28      -1.008  17.695 -16.535  1.00  0.00           N  
ATOM    385  CA  THR A  28      -1.623  17.096 -17.713  1.00  0.00           C  
ATOM    386  C   THR A  28      -2.253  15.749 -17.381  1.00  0.00           C  
ATOM    387  O   THR A  28      -1.704  14.971 -16.601  1.00  0.00           O  
ATOM    388  CB  THR A  28      -0.597  16.905 -18.846  1.00  0.00           C  
ATOM    389  OG1 THR A  28       0.082  18.139 -19.105  1.00  0.00           O  
ATOM    390  CG2 THR A  28      -1.279  16.419 -20.116  1.00  0.00           C  
ATOM    391  H   THR A  28      -0.757  17.119 -15.782  1.00  0.00           H  
ATOM    392  HA  THR A  28      -2.395  17.767 -18.063  1.00  0.00           H  
ATOM    393  HB  THR A  28       0.125  16.163 -18.536  1.00  0.00           H  
ATOM    394  HG1 THR A  28       0.997  17.959 -19.334  1.00  0.00           H  
ATOM    395 HG21 THR A  28      -1.003  17.060 -20.941  1.00  0.00           H  
ATOM    396 HG22 THR A  28      -2.350  16.445 -19.983  1.00  0.00           H  
ATOM    397 HG23 THR A  28      -0.967  15.408 -20.327  1.00  0.00           H  
ATOM    398  N   GLY A  29      -3.410  15.478 -17.978  1.00  0.00           N  
ATOM    399  CA  GLY A  29      -4.095  14.223 -17.732  1.00  0.00           C  
ATOM    400  C   GLY A  29      -5.601  14.384 -17.683  1.00  0.00           C  
ATOM    401  O   GLY A  29      -6.240  14.643 -18.705  1.00  0.00           O  
ATOM    402  H   GLY A  29      -3.801  16.135 -18.590  1.00  0.00           H  
ATOM    403  HA2 GLY A  29      -3.844  13.527 -18.519  1.00  0.00           H  
ATOM    404  HA3 GLY A  29      -3.757  13.820 -16.788  1.00  0.00           H  
ATOM    405  N   THR A  30      -6.173  14.230 -16.494  1.00  0.00           N  
ATOM    406  CA  THR A  30      -7.614  14.357 -16.316  1.00  0.00           C  
ATOM    407  C   THR A  30      -7.950  15.451 -15.309  1.00  0.00           C  
ATOM    408  O   THR A  30      -8.799  16.305 -15.565  1.00  0.00           O  
ATOM    409  CB  THR A  30      -8.242  13.032 -15.845  1.00  0.00           C  
ATOM    410  OG1 THR A  30      -7.523  12.524 -14.715  1.00  0.00           O  
ATOM    411  CG2 THR A  30      -8.232  12.000 -16.962  1.00  0.00           C  
ATOM    412  H   THR A  30      -5.612  14.024 -15.718  1.00  0.00           H  
ATOM    413  HA  THR A  30      -8.047  14.616 -17.271  1.00  0.00           H  
ATOM    414  HB  THR A  30      -9.266  13.219 -15.555  1.00  0.00           H  
ATOM    415  HG1 THR A  30      -7.827  11.635 -14.515  1.00  0.00           H  
ATOM    416 HG21 THR A  30      -7.538  11.211 -16.719  1.00  0.00           H  
ATOM    417 HG22 THR A  30      -7.931  12.473 -17.886  1.00  0.00           H  
ATOM    418 HG23 THR A  30      -9.223  11.587 -17.078  1.00  0.00           H  
ATOM    419  N   GLY A  31      -7.277  15.421 -14.163  1.00  0.00           N  
ATOM    420  CA  GLY A  31      -7.518  16.416 -13.134  1.00  0.00           C  
ATOM    421  C   GLY A  31      -7.503  15.824 -11.740  1.00  0.00           C  
ATOM    422  O   GLY A  31      -6.666  16.187 -10.912  1.00  0.00           O  
ATOM    423  H   GLY A  31      -6.612  14.716 -14.014  1.00  0.00           H  
ATOM    424  HA2 GLY A  31      -6.754  17.177 -13.199  1.00  0.00           H  
ATOM    425  HA3 GLY A  31      -8.482  16.872 -13.309  1.00  0.00           H  
ATOM    426  N   SER A  32      -8.433  14.910 -11.476  1.00  0.00           N  
ATOM    427  CA  SER A  32      -8.526  14.271 -10.169  1.00  0.00           C  
ATOM    428  C   SER A  32      -7.166  13.747  -9.721  1.00  0.00           C  
ATOM    429  O   SER A  32      -6.532  12.954 -10.419  1.00  0.00           O  
ATOM    430  CB  SER A  32      -9.539  13.124 -10.211  1.00  0.00           C  
ATOM    431  OG  SER A  32     -10.867  13.617 -10.198  1.00  0.00           O  
ATOM    432  H   SER A  32      -9.071  14.663 -12.177  1.00  0.00           H  
ATOM    433  HA  SER A  32      -8.864  15.012  -9.461  1.00  0.00           H  
ATOM    434  HB2 SER A  32      -9.389  12.549 -11.112  1.00  0.00           H  
ATOM    435  HB3 SER A  32      -9.395  12.489  -9.349  1.00  0.00           H  
ATOM    436  HG  SER A  32     -11.252  13.525 -11.073  1.00  0.00           H  
ATOM    437  N   LYS A  33      -6.721  14.195  -8.552  1.00  0.00           N  
ATOM    438  CA  LYS A  33      -5.435  13.772  -8.008  1.00  0.00           C  
ATOM    439  C   LYS A  33      -5.293  12.254  -8.069  1.00  0.00           C  
ATOM    440  O   LYS A  33      -6.116  11.520  -7.522  1.00  0.00           O  
ATOM    441  CB  LYS A  33      -5.288  14.251  -6.563  1.00  0.00           C  
ATOM    442  CG  LYS A  33      -5.247  15.764  -6.425  1.00  0.00           C  
ATOM    443  CD  LYS A  33      -4.944  16.185  -4.996  1.00  0.00           C  
ATOM    444  CE  LYS A  33      -4.242  17.533  -4.949  1.00  0.00           C  
ATOM    445  NZ  LYS A  33      -3.947  17.957  -3.553  1.00  0.00           N  
ATOM    446  H   LYS A  33      -7.271  14.826  -8.042  1.00  0.00           H  
ATOM    447  HA  LYS A  33      -4.658  14.219  -8.609  1.00  0.00           H  
ATOM    448  HB2 LYS A  33      -6.122  13.881  -5.986  1.00  0.00           H  
ATOM    449  HB3 LYS A  33      -4.372  13.848  -6.154  1.00  0.00           H  
ATOM    450  HG2 LYS A  33      -4.477  16.155  -7.074  1.00  0.00           H  
ATOM    451  HG3 LYS A  33      -6.205  16.168  -6.715  1.00  0.00           H  
ATOM    452  HD2 LYS A  33      -5.872  16.256  -4.448  1.00  0.00           H  
ATOM    453  HD3 LYS A  33      -4.309  15.440  -4.537  1.00  0.00           H  
ATOM    454  HE2 LYS A  33      -3.315  17.461  -5.498  1.00  0.00           H  
ATOM    455  HE3 LYS A  33      -4.877  18.272  -5.414  1.00  0.00           H  
ATOM    456  HZ1 LYS A  33      -2.992  17.649  -3.280  1.00  0.00           H  
ATOM    457  HZ2 LYS A  33      -4.635  17.533  -2.899  1.00  0.00           H  
ATOM    458  HZ3 LYS A  33      -4.002  18.992  -3.474  1.00  0.00           H  
ATOM    459  N   VAL A  34      -4.241  11.789  -8.737  1.00  0.00           N  
ATOM    460  CA  VAL A  34      -3.989  10.359  -8.866  1.00  0.00           C  
ATOM    461  C   VAL A  34      -2.538  10.025  -8.537  1.00  0.00           C  
ATOM    462  O   VAL A  34      -1.621  10.756  -8.910  1.00  0.00           O  
ATOM    463  CB  VAL A  34      -4.309   9.859 -10.287  1.00  0.00           C  
ATOM    464  CG1 VAL A  34      -5.584  10.507 -10.807  1.00  0.00           C  
ATOM    465  CG2 VAL A  34      -3.142  10.134 -11.223  1.00  0.00           C  
ATOM    466  H   VAL A  34      -3.620  12.424  -9.151  1.00  0.00           H  
ATOM    467  HA  VAL A  34      -4.634   9.842  -8.171  1.00  0.00           H  
ATOM    468  HB  VAL A  34      -4.466   8.791 -10.245  1.00  0.00           H  
ATOM    469 HG11 VAL A  34      -5.331  11.365 -11.412  1.00  0.00           H  
ATOM    470 HG12 VAL A  34      -6.134   9.793 -11.403  1.00  0.00           H  
ATOM    471 HG13 VAL A  34      -6.192  10.823  -9.972  1.00  0.00           H  
ATOM    472 HG21 VAL A  34      -2.313   9.494 -10.961  1.00  0.00           H  
ATOM    473 HG22 VAL A  34      -3.442   9.934 -12.242  1.00  0.00           H  
ATOM    474 HG23 VAL A  34      -2.843  11.167 -11.134  1.00  0.00           H  
ATOM    475  N   GLY A  35      -2.337   8.915  -7.834  1.00  0.00           N  
ATOM    476  CA  GLY A  35      -0.995   8.502  -7.467  1.00  0.00           C  
ATOM    477  C   GLY A  35      -0.831   6.996  -7.468  1.00  0.00           C  
ATOM    478  O   GLY A  35      -1.805   6.257  -7.612  1.00  0.00           O  
ATOM    479  H   GLY A  35      -3.106   8.371  -7.564  1.00  0.00           H  
ATOM    480  HA2 GLY A  35      -0.293   8.932  -8.166  1.00  0.00           H  
ATOM    481  HA3 GLY A  35      -0.774   8.875  -6.477  1.00  0.00           H  
ATOM    482  N   LYS A  36       0.407   6.537  -7.310  1.00  0.00           N  
ATOM    483  CA  LYS A  36       0.697   5.108  -7.295  1.00  0.00           C  
ATOM    484  C   LYS A  36       1.528   4.736  -6.071  1.00  0.00           C  
ATOM    485  O   LYS A  36       2.618   5.270  -5.861  1.00  0.00           O  
ATOM    486  CB  LYS A  36       1.440   4.704  -8.571  1.00  0.00           C  
ATOM    487  CG  LYS A  36       0.554   4.669  -9.804  1.00  0.00           C  
ATOM    488  CD  LYS A  36       1.094   3.710 -10.852  1.00  0.00           C  
ATOM    489  CE  LYS A  36       2.190   4.356 -11.686  1.00  0.00           C  
ATOM    490  NZ  LYS A  36       1.635   5.082 -12.862  1.00  0.00           N  
ATOM    491  H   LYS A  36       1.143   7.176  -7.201  1.00  0.00           H  
ATOM    492  HA  LYS A  36      -0.243   4.579  -7.252  1.00  0.00           H  
ATOM    493  HB2 LYS A  36       2.238   5.409  -8.746  1.00  0.00           H  
ATOM    494  HB3 LYS A  36       1.863   3.720  -8.430  1.00  0.00           H  
ATOM    495  HG2 LYS A  36      -0.437   4.349  -9.516  1.00  0.00           H  
ATOM    496  HG3 LYS A  36       0.504   5.661 -10.229  1.00  0.00           H  
ATOM    497  HD2 LYS A  36       1.500   2.841 -10.356  1.00  0.00           H  
ATOM    498  HD3 LYS A  36       0.286   3.410 -11.504  1.00  0.00           H  
ATOM    499  HE2 LYS A  36       2.732   5.053 -11.067  1.00  0.00           H  
ATOM    500  HE3 LYS A  36       2.861   3.585 -12.034  1.00  0.00           H  
ATOM    501  HZ1 LYS A  36       1.595   4.449 -13.687  1.00  0.00           H  
ATOM    502  HZ2 LYS A  36       2.237   5.897 -13.095  1.00  0.00           H  
ATOM    503  HZ3 LYS A  36       0.675   5.423 -12.653  1.00  0.00           H  
ATOM    504  N   LEU A  37       1.009   3.815  -5.267  1.00  0.00           N  
ATOM    505  CA  LEU A  37       1.704   3.369  -4.064  1.00  0.00           C  
ATOM    506  C   LEU A  37       2.136   1.912  -4.194  1.00  0.00           C  
ATOM    507  O   LEU A  37       1.405   1.081  -4.733  1.00  0.00           O  
ATOM    508  CB  LEU A  37       0.803   3.537  -2.839  1.00  0.00           C  
ATOM    509  CG  LEU A  37       1.158   2.683  -1.623  1.00  0.00           C  
ATOM    510  CD1 LEU A  37       2.376   3.250  -0.908  1.00  0.00           C  
ATOM    511  CD2 LEU A  37      -0.025   2.591  -0.671  1.00  0.00           C  
ATOM    512  H   LEU A  37       0.136   3.425  -5.486  1.00  0.00           H  
ATOM    513  HA  LEU A  37       2.582   3.983  -3.942  1.00  0.00           H  
ATOM    514  HB2 LEU A  37       0.844   4.574  -2.539  1.00  0.00           H  
ATOM    515  HB3 LEU A  37      -0.207   3.290  -3.135  1.00  0.00           H  
ATOM    516  HG  LEU A  37       1.402   1.682  -1.951  1.00  0.00           H  
ATOM    517 HD11 LEU A  37       3.274   2.887  -1.384  1.00  0.00           H  
ATOM    518 HD12 LEU A  37       2.364   2.938   0.126  1.00  0.00           H  
ATOM    519 HD13 LEU A  37       2.351   4.329  -0.958  1.00  0.00           H  
ATOM    520 HD21 LEU A  37      -0.418   3.580  -0.488  1.00  0.00           H  
ATOM    521 HD22 LEU A  37       0.297   2.153   0.263  1.00  0.00           H  
ATOM    522 HD23 LEU A  37      -0.795   1.974  -1.112  1.00  0.00           H  
ATOM    523  N   THR A  38       3.332   1.609  -3.695  1.00  0.00           N  
ATOM    524  CA  THR A  38       3.862   0.253  -3.755  1.00  0.00           C  
ATOM    525  C   THR A  38       4.189  -0.271  -2.361  1.00  0.00           C  
ATOM    526  O   THR A  38       4.857   0.402  -1.575  1.00  0.00           O  
ATOM    527  CB  THR A  38       5.130   0.183  -4.627  1.00  0.00           C  
ATOM    528  OG1 THR A  38       4.845   0.671  -5.943  1.00  0.00           O  
ATOM    529  CG2 THR A  38       5.650  -1.244  -4.711  1.00  0.00           C  
ATOM    530  H   THR A  38       3.868   2.315  -3.279  1.00  0.00           H  
ATOM    531  HA  THR A  38       3.108  -0.381  -4.199  1.00  0.00           H  
ATOM    532  HB  THR A  38       5.892   0.803  -4.178  1.00  0.00           H  
ATOM    533  HG1 THR A  38       4.501   1.566  -5.885  1.00  0.00           H  
ATOM    534 HG21 THR A  38       4.871  -1.890  -5.089  1.00  0.00           H  
ATOM    535 HG22 THR A  38       5.950  -1.576  -3.729  1.00  0.00           H  
ATOM    536 HG23 THR A  38       6.499  -1.278  -5.377  1.00  0.00           H  
ATOM    537  N   LEU A  39       3.715  -1.475  -2.060  1.00  0.00           N  
ATOM    538  CA  LEU A  39       3.957  -2.090  -0.760  1.00  0.00           C  
ATOM    539  C   LEU A  39       4.422  -3.534  -0.919  1.00  0.00           C  
ATOM    540  O   LEU A  39       3.889  -4.283  -1.739  1.00  0.00           O  
ATOM    541  CB  LEU A  39       2.690  -2.042   0.094  1.00  0.00           C  
ATOM    542  CG  LEU A  39       2.571  -0.857   1.053  1.00  0.00           C  
ATOM    543  CD1 LEU A  39       2.355   0.436   0.280  1.00  0.00           C  
ATOM    544  CD2 LEU A  39       1.438  -1.084   2.043  1.00  0.00           C  
ATOM    545  H   LEU A  39       3.189  -1.962  -2.728  1.00  0.00           H  
ATOM    546  HA  LEU A  39       4.736  -1.527  -0.267  1.00  0.00           H  
ATOM    547  HB2 LEU A  39       1.842  -2.013  -0.573  1.00  0.00           H  
ATOM    548  HB3 LEU A  39       2.652  -2.949   0.681  1.00  0.00           H  
ATOM    549  HG  LEU A  39       3.491  -0.761   1.612  1.00  0.00           H  
ATOM    550 HD11 LEU A  39       3.305   0.806  -0.073  1.00  0.00           H  
ATOM    551 HD12 LEU A  39       1.900   1.171   0.927  1.00  0.00           H  
ATOM    552 HD13 LEU A  39       1.705   0.247  -0.562  1.00  0.00           H  
ATOM    553 HD21 LEU A  39       0.682  -0.323   1.905  1.00  0.00           H  
ATOM    554 HD22 LEU A  39       1.824  -1.027   3.051  1.00  0.00           H  
ATOM    555 HD23 LEU A  39       1.004  -2.058   1.877  1.00  0.00           H  
ATOM    556  N   LYS A  40       5.418  -3.920  -0.128  1.00  0.00           N  
ATOM    557  CA  LYS A  40       5.953  -5.276  -0.178  1.00  0.00           C  
ATOM    558  C   LYS A  40       5.214  -6.189   0.795  1.00  0.00           C  
ATOM    559  O   LYS A  40       5.489  -6.187   1.996  1.00  0.00           O  
ATOM    560  CB  LYS A  40       7.448  -5.267   0.149  1.00  0.00           C  
ATOM    561  CG  LYS A  40       8.145  -6.584  -0.154  1.00  0.00           C  
ATOM    562  CD  LYS A  40       9.615  -6.537   0.227  1.00  0.00           C  
ATOM    563  CE  LYS A  40       9.797  -6.420   1.733  1.00  0.00           C  
ATOM    564  NZ  LYS A  40      11.149  -6.871   2.165  1.00  0.00           N  
ATOM    565  H   LYS A  40       5.803  -3.277   0.504  1.00  0.00           H  
ATOM    566  HA  LYS A  40       5.815  -5.651  -1.181  1.00  0.00           H  
ATOM    567  HB2 LYS A  40       7.928  -4.490  -0.427  1.00  0.00           H  
ATOM    568  HB3 LYS A  40       7.573  -5.053   1.201  1.00  0.00           H  
ATOM    569  HG2 LYS A  40       7.664  -7.372   0.405  1.00  0.00           H  
ATOM    570  HG3 LYS A  40       8.063  -6.788  -1.211  1.00  0.00           H  
ATOM    571  HD2 LYS A  40      10.095  -7.443  -0.112  1.00  0.00           H  
ATOM    572  HD3 LYS A  40      10.074  -5.683  -0.250  1.00  0.00           H  
ATOM    573  HE2 LYS A  40       9.663  -5.387   2.019  1.00  0.00           H  
ATOM    574  HE3 LYS A  40       9.050  -7.028   2.221  1.00  0.00           H  
ATOM    575  HZ1 LYS A  40      11.743  -6.049   2.393  1.00  0.00           H  
ATOM    576  HZ2 LYS A  40      11.604  -7.413   1.403  1.00  0.00           H  
ATOM    577  HZ3 LYS A  40      11.071  -7.475   3.007  1.00  0.00           H  
ATOM    578  N   THR A  41       4.275  -6.969   0.270  1.00  0.00           N  
ATOM    579  CA  THR A  41       3.496  -7.886   1.091  1.00  0.00           C  
ATOM    580  C   THR A  41       3.546  -9.303   0.531  1.00  0.00           C  
ATOM    581  O   THR A  41       3.407  -9.511  -0.675  1.00  0.00           O  
ATOM    582  CB  THR A  41       2.026  -7.439   1.194  1.00  0.00           C  
ATOM    583  OG1 THR A  41       1.303  -7.860   0.031  1.00  0.00           O  
ATOM    584  CG2 THR A  41       1.929  -5.929   1.338  1.00  0.00           C  
ATOM    585  H   THR A  41       4.102  -6.925  -0.694  1.00  0.00           H  
ATOM    586  HA  THR A  41       3.921  -7.887   2.084  1.00  0.00           H  
ATOM    587  HB  THR A  41       1.586  -7.899   2.068  1.00  0.00           H  
ATOM    588  HG1 THR A  41       1.248  -8.818   0.018  1.00  0.00           H  
ATOM    589 HG21 THR A  41       2.914  -5.518   1.502  1.00  0.00           H  
ATOM    590 HG22 THR A  41       1.295  -5.687   2.178  1.00  0.00           H  
ATOM    591 HG23 THR A  41       1.508  -5.507   0.438  1.00  0.00           H  
ATOM    592  N   THR A  42       3.745 -10.278   1.414  1.00  0.00           N  
ATOM    593  CA  THR A  42       3.814 -11.675   1.008  1.00  0.00           C  
ATOM    594  C   THR A  42       4.994 -11.919   0.074  1.00  0.00           C  
ATOM    595  O   THR A  42       4.828 -12.435  -1.030  1.00  0.00           O  
ATOM    596  CB  THR A  42       2.518 -12.120   0.304  1.00  0.00           C  
ATOM    597  OG1 THR A  42       1.384 -11.806   1.120  1.00  0.00           O  
ATOM    598  CG2 THR A  42       2.544 -13.614   0.016  1.00  0.00           C  
ATOM    599  H   THR A  42       3.849 -10.049   2.361  1.00  0.00           H  
ATOM    600  HA  THR A  42       3.940 -12.276   1.897  1.00  0.00           H  
ATOM    601  HB  THR A  42       2.435 -11.590  -0.634  1.00  0.00           H  
ATOM    602  HG1 THR A  42       1.519 -12.158   2.004  1.00  0.00           H  
ATOM    603 HG21 THR A  42       2.947 -13.784  -0.971  1.00  0.00           H  
ATOM    604 HG22 THR A  42       1.540 -14.008   0.068  1.00  0.00           H  
ATOM    605 HG23 THR A  42       3.163 -14.110   0.748  1.00  0.00           H  
ATOM    606  N   GLU A  43       6.187 -11.545   0.526  1.00  0.00           N  
ATOM    607  CA  GLU A  43       7.396 -11.724  -0.270  1.00  0.00           C  
ATOM    608  C   GLU A  43       7.189 -11.215  -1.694  1.00  0.00           C  
ATOM    609  O   GLU A  43       7.860 -11.659  -2.626  1.00  0.00           O  
ATOM    610  CB  GLU A  43       7.802 -13.198  -0.298  1.00  0.00           C  
ATOM    611  CG  GLU A  43       8.699 -13.604   0.859  1.00  0.00           C  
ATOM    612  CD  GLU A  43       7.919 -13.914   2.122  1.00  0.00           C  
ATOM    613  OE1 GLU A  43       6.754 -14.350   2.007  1.00  0.00           O  
ATOM    614  OE2 GLU A  43       8.473 -13.721   3.225  1.00  0.00           O  
ATOM    615  H   GLU A  43       6.256 -11.139   1.415  1.00  0.00           H  
ATOM    616  HA  GLU A  43       8.185 -11.151   0.192  1.00  0.00           H  
ATOM    617  HB2 GLU A  43       6.909 -13.806  -0.264  1.00  0.00           H  
ATOM    618  HB3 GLU A  43       8.327 -13.397  -1.220  1.00  0.00           H  
ATOM    619  HG2 GLU A  43       9.257 -14.484   0.575  1.00  0.00           H  
ATOM    620  HG3 GLU A  43       9.386 -12.796   1.066  1.00  0.00           H  
ATOM    621  N   MET A  44       6.256 -10.283  -1.853  1.00  0.00           N  
ATOM    622  CA  MET A  44       5.961  -9.713  -3.164  1.00  0.00           C  
ATOM    623  C   MET A  44       5.384  -8.307  -3.028  1.00  0.00           C  
ATOM    624  O   MET A  44       4.649  -8.017  -2.084  1.00  0.00           O  
ATOM    625  CB  MET A  44       4.980 -10.608  -3.923  1.00  0.00           C  
ATOM    626  CG  MET A  44       3.521 -10.257  -3.678  1.00  0.00           C  
ATOM    627  SD  MET A  44       2.396 -11.187  -4.737  1.00  0.00           S  
ATOM    628  CE  MET A  44       0.811 -10.651  -4.098  1.00  0.00           C  
ATOM    629  H   MET A  44       5.754  -9.969  -1.073  1.00  0.00           H  
ATOM    630  HA  MET A  44       6.887  -9.658  -3.717  1.00  0.00           H  
ATOM    631  HB2 MET A  44       5.177 -10.520  -4.981  1.00  0.00           H  
ATOM    632  HB3 MET A  44       5.138 -11.633  -3.620  1.00  0.00           H  
ATOM    633  HG2 MET A  44       3.282 -10.472  -2.646  1.00  0.00           H  
ATOM    634  HG3 MET A  44       3.383  -9.203  -3.865  1.00  0.00           H  
ATOM    635  HE1 MET A  44       0.202 -11.515  -3.875  1.00  0.00           H  
ATOM    636  HE2 MET A  44       0.962 -10.076  -3.196  1.00  0.00           H  
ATOM    637  HE3 MET A  44       0.313 -10.040  -4.837  1.00  0.00           H  
ATOM    638  N   GLU A  45       5.723  -7.440  -3.975  1.00  0.00           N  
ATOM    639  CA  GLU A  45       5.238  -6.064  -3.959  1.00  0.00           C  
ATOM    640  C   GLU A  45       4.054  -5.892  -4.907  1.00  0.00           C  
ATOM    641  O   GLU A  45       4.038  -6.450  -6.006  1.00  0.00           O  
ATOM    642  CB  GLU A  45       6.361  -5.100  -4.349  1.00  0.00           C  
ATOM    643  CG  GLU A  45       7.173  -4.603  -3.165  1.00  0.00           C  
ATOM    644  CD  GLU A  45       8.519  -4.037  -3.578  1.00  0.00           C  
ATOM    645  OE1 GLU A  45       8.553  -3.213  -4.515  1.00  0.00           O  
ATOM    646  OE2 GLU A  45       9.537  -4.418  -2.963  1.00  0.00           O  
ATOM    647  H   GLU A  45       6.313  -7.730  -4.702  1.00  0.00           H  
ATOM    648  HA  GLU A  45       4.915  -5.838  -2.954  1.00  0.00           H  
ATOM    649  HB2 GLU A  45       7.029  -5.602  -5.032  1.00  0.00           H  
ATOM    650  HB3 GLU A  45       5.928  -4.245  -4.846  1.00  0.00           H  
ATOM    651  HG2 GLU A  45       6.615  -3.828  -2.660  1.00  0.00           H  
ATOM    652  HG3 GLU A  45       7.338  -5.426  -2.487  1.00  0.00           H  
ATOM    653  N   THR A  46       3.064  -5.119  -4.474  1.00  0.00           N  
ATOM    654  CA  THR A  46       1.876  -4.875  -5.282  1.00  0.00           C  
ATOM    655  C   THR A  46       1.561  -3.385  -5.362  1.00  0.00           C  
ATOM    656  O   THR A  46       1.593  -2.681  -4.353  1.00  0.00           O  
ATOM    657  CB  THR A  46       0.650  -5.617  -4.716  1.00  0.00           C  
ATOM    658  OG1 THR A  46       0.916  -7.023  -4.652  1.00  0.00           O  
ATOM    659  CG2 THR A  46      -0.579  -5.366  -5.576  1.00  0.00           C  
ATOM    660  H   THR A  46       3.137  -4.702  -3.590  1.00  0.00           H  
ATOM    661  HA  THR A  46       2.068  -5.246  -6.278  1.00  0.00           H  
ATOM    662  HB  THR A  46       0.455  -5.250  -3.719  1.00  0.00           H  
ATOM    663  HG1 THR A  46       0.851  -7.401  -5.532  1.00  0.00           H  
ATOM    664 HG21 THR A  46      -0.850  -6.277  -6.090  1.00  0.00           H  
ATOM    665 HG22 THR A  46      -0.360  -4.595  -6.301  1.00  0.00           H  
ATOM    666 HG23 THR A  46      -1.398  -5.050  -4.949  1.00  0.00           H  
ATOM    667  N   ILE A  47       1.258  -2.913  -6.566  1.00  0.00           N  
ATOM    668  CA  ILE A  47       0.936  -1.507  -6.776  1.00  0.00           C  
ATOM    669  C   ILE A  47      -0.529  -1.225  -6.459  1.00  0.00           C  
ATOM    670  O   ILE A  47      -1.405  -2.040  -6.750  1.00  0.00           O  
ATOM    671  CB  ILE A  47       1.230  -1.072  -8.223  1.00  0.00           C  
ATOM    672  CG1 ILE A  47       2.673  -1.417  -8.600  1.00  0.00           C  
ATOM    673  CG2 ILE A  47       0.976   0.419  -8.391  1.00  0.00           C  
ATOM    674  CD1 ILE A  47       2.937  -1.369 -10.089  1.00  0.00           C  
ATOM    675  H   ILE A  47       1.251  -3.524  -7.331  1.00  0.00           H  
ATOM    676  HA  ILE A  47       1.556  -0.921  -6.112  1.00  0.00           H  
ATOM    677  HB  ILE A  47       0.557  -1.604  -8.879  1.00  0.00           H  
ATOM    678 HG12 ILE A  47       3.340  -0.716  -8.123  1.00  0.00           H  
ATOM    679 HG13 ILE A  47       2.898  -2.415  -8.254  1.00  0.00           H  
ATOM    680 HG21 ILE A  47       1.192   0.927  -7.464  1.00  0.00           H  
ATOM    681 HG22 ILE A  47       1.613   0.807  -9.171  1.00  0.00           H  
ATOM    682 HG23 ILE A  47      -0.059   0.580  -8.657  1.00  0.00           H  
ATOM    683 HD11 ILE A  47       2.089  -0.927 -10.591  1.00  0.00           H  
ATOM    684 HD12 ILE A  47       3.819  -0.777 -10.280  1.00  0.00           H  
ATOM    685 HD13 ILE A  47       3.089  -2.373 -10.459  1.00  0.00           H  
ATOM    686  N   TYR A  48      -0.788  -0.066  -5.865  1.00  0.00           N  
ATOM    687  CA  TYR A  48      -2.147   0.324  -5.509  1.00  0.00           C  
ATOM    688  C   TYR A  48      -2.483   1.701  -6.071  1.00  0.00           C  
ATOM    689  O   TYR A  48      -1.702   2.645  -5.941  1.00  0.00           O  
ATOM    690  CB  TYR A  48      -2.318   0.324  -3.989  1.00  0.00           C  
ATOM    691  CG  TYR A  48      -2.135  -1.038  -3.359  1.00  0.00           C  
ATOM    692  CD1 TYR A  48      -2.968  -2.097  -3.694  1.00  0.00           C  
ATOM    693  CD2 TYR A  48      -1.130  -1.264  -2.427  1.00  0.00           C  
ATOM    694  CE1 TYR A  48      -2.805  -3.343  -3.120  1.00  0.00           C  
ATOM    695  CE2 TYR A  48      -0.958  -2.507  -1.848  1.00  0.00           C  
ATOM    696  CZ  TYR A  48      -1.799  -3.544  -2.198  1.00  0.00           C  
ATOM    697  OH  TYR A  48      -1.632  -4.782  -1.622  1.00  0.00           O  
ATOM    698  H   TYR A  48      -0.047   0.542  -5.659  1.00  0.00           H  
ATOM    699  HA  TYR A  48      -2.823  -0.402  -5.937  1.00  0.00           H  
ATOM    700  HB2 TYR A  48      -1.590   0.992  -3.552  1.00  0.00           H  
ATOM    701  HB3 TYR A  48      -3.311   0.672  -3.746  1.00  0.00           H  
ATOM    702  HD1 TYR A  48      -3.755  -1.938  -4.416  1.00  0.00           H  
ATOM    703  HD2 TYR A  48      -0.473  -0.450  -2.154  1.00  0.00           H  
ATOM    704  HE1 TYR A  48      -3.463  -4.156  -3.393  1.00  0.00           H  
ATOM    705  HE2 TYR A  48      -0.170  -2.664  -1.126  1.00  0.00           H  
ATOM    706  HH  TYR A  48      -2.394  -5.333  -1.823  1.00  0.00           H  
ATOM    707  N   ASP A  49      -3.651   1.809  -6.695  1.00  0.00           N  
ATOM    708  CA  ASP A  49      -4.094   3.071  -7.275  1.00  0.00           C  
ATOM    709  C   ASP A  49      -4.667   3.992  -6.202  1.00  0.00           C  
ATOM    710  O   ASP A  49      -5.618   3.636  -5.506  1.00  0.00           O  
ATOM    711  CB  ASP A  49      -5.143   2.818  -8.360  1.00  0.00           C  
ATOM    712  CG  ASP A  49      -5.923   4.069  -8.714  1.00  0.00           C  
ATOM    713  OD1 ASP A  49      -6.908   4.373  -8.009  1.00  0.00           O  
ATOM    714  OD2 ASP A  49      -5.548   4.744  -9.695  1.00  0.00           O  
ATOM    715  H   ASP A  49      -4.230   1.021  -6.765  1.00  0.00           H  
ATOM    716  HA  ASP A  49      -3.236   3.551  -7.722  1.00  0.00           H  
ATOM    717  HB2 ASP A  49      -4.649   2.460  -9.252  1.00  0.00           H  
ATOM    718  HB3 ASP A  49      -5.838   2.068  -8.012  1.00  0.00           H  
ATOM    719  N   LEU A  50      -4.081   5.177  -6.072  1.00  0.00           N  
ATOM    720  CA  LEU A  50      -4.531   6.150  -5.083  1.00  0.00           C  
ATOM    721  C   LEU A  50      -5.419   7.210  -5.727  1.00  0.00           C  
ATOM    722  O   LEU A  50      -5.042   7.829  -6.721  1.00  0.00           O  
ATOM    723  CB  LEU A  50      -3.330   6.814  -4.408  1.00  0.00           C  
ATOM    724  CG  LEU A  50      -2.101   5.929  -4.202  1.00  0.00           C  
ATOM    725  CD1 LEU A  50      -0.848   6.778  -4.059  1.00  0.00           C  
ATOM    726  CD2 LEU A  50      -2.285   5.038  -2.982  1.00  0.00           C  
ATOM    727  H   LEU A  50      -3.326   5.404  -6.655  1.00  0.00           H  
ATOM    728  HA  LEU A  50      -5.106   5.621  -4.336  1.00  0.00           H  
ATOM    729  HB2 LEU A  50      -3.033   7.655  -5.016  1.00  0.00           H  
ATOM    730  HB3 LEU A  50      -3.651   7.168  -3.439  1.00  0.00           H  
ATOM    731  HG  LEU A  50      -1.975   5.291  -5.066  1.00  0.00           H  
ATOM    732 HD11 LEU A  50      -0.155   6.290  -3.391  1.00  0.00           H  
ATOM    733 HD12 LEU A  50      -1.113   7.746  -3.660  1.00  0.00           H  
ATOM    734 HD13 LEU A  50      -0.387   6.904  -5.028  1.00  0.00           H  
ATOM    735 HD21 LEU A  50      -1.325   4.861  -2.518  1.00  0.00           H  
ATOM    736 HD22 LEU A  50      -2.715   4.095  -3.286  1.00  0.00           H  
ATOM    737 HD23 LEU A  50      -2.942   5.524  -2.277  1.00  0.00           H  
ATOM    738  N   GLY A  51      -6.599   7.417  -5.150  1.00  0.00           N  
ATOM    739  CA  GLY A  51      -7.521   8.404  -5.680  1.00  0.00           C  
ATOM    740  C   GLY A  51      -7.233   9.801  -5.164  1.00  0.00           C  
ATOM    741  O   GLY A  51      -6.112  10.296  -5.281  1.00  0.00           O  
ATOM    742  H   GLY A  51      -6.846   6.893  -4.359  1.00  0.00           H  
ATOM    743  HA2 GLY A  51      -7.448   8.407  -6.757  1.00  0.00           H  
ATOM    744  HA3 GLY A  51      -8.526   8.129  -5.398  1.00  0.00           H  
ATOM    745  N   THR A  52      -8.249  10.440  -4.594  1.00  0.00           N  
ATOM    746  CA  THR A  52      -8.102  11.789  -4.061  1.00  0.00           C  
ATOM    747  C   THR A  52      -8.187  11.791  -2.539  1.00  0.00           C  
ATOM    748  O   THR A  52      -7.739  12.732  -1.883  1.00  0.00           O  
ATOM    749  CB  THR A  52      -9.178  12.737  -4.626  1.00  0.00           C  
ATOM    750  OG1 THR A  52      -9.213  12.641  -6.054  1.00  0.00           O  
ATOM    751  CG2 THR A  52      -8.900  14.174  -4.215  1.00  0.00           C  
ATOM    752  H   THR A  52      -9.119   9.992  -4.530  1.00  0.00           H  
ATOM    753  HA  THR A  52      -7.132  12.160  -4.359  1.00  0.00           H  
ATOM    754  HB  THR A  52     -10.139  12.442  -4.229  1.00  0.00           H  
ATOM    755  HG1 THR A  52      -8.334  12.797  -6.407  1.00  0.00           H  
ATOM    756 HG21 THR A  52      -7.884  14.258  -3.860  1.00  0.00           H  
ATOM    757 HG22 THR A  52      -9.582  14.462  -3.428  1.00  0.00           H  
ATOM    758 HG23 THR A  52      -9.039  14.824  -5.065  1.00  0.00           H  
ATOM    759  N   LYS A  53      -8.763  10.732  -1.982  1.00  0.00           N  
ATOM    760  CA  LYS A  53      -8.907  10.610  -0.536  1.00  0.00           C  
ATOM    761  C   LYS A  53      -7.745   9.821   0.061  1.00  0.00           C  
ATOM    762  O   LYS A  53      -7.376  10.022   1.218  1.00  0.00           O  
ATOM    763  CB  LYS A  53     -10.231   9.928  -0.189  1.00  0.00           C  
ATOM    764  CG  LYS A  53     -11.415  10.879  -0.161  1.00  0.00           C  
ATOM    765  CD  LYS A  53     -12.702  10.158   0.206  1.00  0.00           C  
ATOM    766  CE  LYS A  53     -13.816  11.138   0.539  1.00  0.00           C  
ATOM    767  NZ  LYS A  53     -14.240  11.921  -0.654  1.00  0.00           N  
ATOM    768  H   LYS A  53      -9.101  10.013  -2.557  1.00  0.00           H  
ATOM    769  HA  LYS A  53      -8.902  11.605  -0.117  1.00  0.00           H  
ATOM    770  HB2 LYS A  53     -10.430   9.161  -0.922  1.00  0.00           H  
ATOM    771  HB3 LYS A  53     -10.142   9.469   0.786  1.00  0.00           H  
ATOM    772  HG2 LYS A  53     -11.228  11.652   0.570  1.00  0.00           H  
ATOM    773  HG3 LYS A  53     -11.530  11.325  -1.138  1.00  0.00           H  
ATOM    774  HD2 LYS A  53     -13.013   9.547  -0.629  1.00  0.00           H  
ATOM    775  HD3 LYS A  53     -12.518   9.529   1.066  1.00  0.00           H  
ATOM    776  HE2 LYS A  53     -14.663  10.586   0.917  1.00  0.00           H  
ATOM    777  HE3 LYS A  53     -13.463  11.819   1.299  1.00  0.00           H  
ATOM    778  HZ1 LYS A  53     -15.026  12.555  -0.404  1.00  0.00           H  
ATOM    779  HZ2 LYS A  53     -14.554  11.279  -1.410  1.00  0.00           H  
ATOM    780  HZ3 LYS A  53     -13.447  12.493  -1.007  1.00  0.00           H  
ATOM    781  N   MET A  54      -7.173   8.925  -0.737  1.00  0.00           N  
ATOM    782  CA  MET A  54      -6.051   8.108  -0.287  1.00  0.00           C  
ATOM    783  C   MET A  54      -4.795   8.956  -0.120  1.00  0.00           C  
ATOM    784  O   MET A  54      -3.973   8.697   0.761  1.00  0.00           O  
ATOM    785  CB  MET A  54      -5.788   6.975  -1.280  1.00  0.00           C  
ATOM    786  CG  MET A  54      -6.764   5.817  -1.154  1.00  0.00           C  
ATOM    787  SD  MET A  54      -6.302   4.404  -2.175  1.00  0.00           S  
ATOM    788  CE  MET A  54      -7.200   3.087  -1.357  1.00  0.00           C  
ATOM    789  H   MET A  54      -7.511   8.810  -1.649  1.00  0.00           H  
ATOM    790  HA  MET A  54      -6.315   7.682   0.670  1.00  0.00           H  
ATOM    791  HB2 MET A  54      -5.857   7.368  -2.284  1.00  0.00           H  
ATOM    792  HB3 MET A  54      -4.790   6.595  -1.118  1.00  0.00           H  
ATOM    793  HG2 MET A  54      -6.798   5.502  -0.122  1.00  0.00           H  
ATOM    794  HG3 MET A  54      -7.744   6.156  -1.456  1.00  0.00           H  
ATOM    795  HE1 MET A  54      -7.586   2.402  -2.096  1.00  0.00           H  
ATOM    796  HE2 MET A  54      -6.536   2.561  -0.687  1.00  0.00           H  
ATOM    797  HE3 MET A  54      -8.020   3.508  -0.793  1.00  0.00           H  
ATOM    798  N   ILE A  55      -4.651   9.967  -0.969  1.00  0.00           N  
ATOM    799  CA  ILE A  55      -3.494  10.852  -0.914  1.00  0.00           C  
ATOM    800  C   ILE A  55      -3.527  11.722   0.339  1.00  0.00           C  
ATOM    801  O   ILE A  55      -2.538  11.817   1.066  1.00  0.00           O  
ATOM    802  CB  ILE A  55      -3.421  11.761  -2.154  1.00  0.00           C  
ATOM    803  CG1 ILE A  55      -3.190  10.925  -3.415  1.00  0.00           C  
ATOM    804  CG2 ILE A  55      -2.317  12.796  -1.989  1.00  0.00           C  
ATOM    805  CD1 ILE A  55      -3.182  11.741  -4.688  1.00  0.00           C  
ATOM    806  H   ILE A  55      -5.339  10.123  -1.649  1.00  0.00           H  
ATOM    807  HA  ILE A  55      -2.605  10.238  -0.890  1.00  0.00           H  
ATOM    808  HB  ILE A  55      -4.360  12.286  -2.246  1.00  0.00           H  
ATOM    809 HG12 ILE A  55      -2.238  10.424  -3.336  1.00  0.00           H  
ATOM    810 HG13 ILE A  55      -3.975  10.187  -3.497  1.00  0.00           H  
ATOM    811 HG21 ILE A  55      -2.372  13.512  -2.795  1.00  0.00           H  
ATOM    812 HG22 ILE A  55      -2.442  13.307  -1.045  1.00  0.00           H  
ATOM    813 HG23 ILE A  55      -1.356  12.303  -2.009  1.00  0.00           H  
ATOM    814 HD11 ILE A  55      -2.462  12.541  -4.599  1.00  0.00           H  
ATOM    815 HD12 ILE A  55      -2.916  11.107  -5.520  1.00  0.00           H  
ATOM    816 HD13 ILE A  55      -4.164  12.159  -4.854  1.00  0.00           H  
ATOM    817  N   GLU A  56      -4.670  12.353   0.584  1.00  0.00           N  
ATOM    818  CA  GLU A  56      -4.831  13.214   1.751  1.00  0.00           C  
ATOM    819  C   GLU A  56      -4.286  12.538   3.006  1.00  0.00           C  
ATOM    820  O   GLU A  56      -3.757  13.198   3.899  1.00  0.00           O  
ATOM    821  CB  GLU A  56      -6.306  13.570   1.950  1.00  0.00           C  
ATOM    822  CG  GLU A  56      -6.886  14.412   0.826  1.00  0.00           C  
ATOM    823  CD  GLU A  56      -8.005  15.320   1.295  1.00  0.00           C  
ATOM    824  OE1 GLU A  56      -8.718  14.940   2.248  1.00  0.00           O  
ATOM    825  OE2 GLU A  56      -8.169  16.411   0.709  1.00  0.00           O  
ATOM    826  H   GLU A  56      -5.423  12.238  -0.032  1.00  0.00           H  
ATOM    827  HA  GLU A  56      -4.273  14.121   1.574  1.00  0.00           H  
ATOM    828  HB2 GLU A  56      -6.878  12.656   2.020  1.00  0.00           H  
ATOM    829  HB3 GLU A  56      -6.408  14.120   2.874  1.00  0.00           H  
ATOM    830  HG2 GLU A  56      -6.100  15.023   0.408  1.00  0.00           H  
ATOM    831  HG3 GLU A  56      -7.272  13.754   0.062  1.00  0.00           H  
ATOM    832  N   SER A  57      -4.419  11.217   3.064  1.00  0.00           N  
ATOM    833  CA  SER A  57      -3.944  10.451   4.211  1.00  0.00           C  
ATOM    834  C   SER A  57      -2.420  10.401   4.237  1.00  0.00           C  
ATOM    835  O   SER A  57      -1.802  10.502   5.297  1.00  0.00           O  
ATOM    836  CB  SER A  57      -4.511   9.030   4.172  1.00  0.00           C  
ATOM    837  OG  SER A  57      -5.928   9.046   4.212  1.00  0.00           O  
ATOM    838  H   SER A  57      -4.849  10.746   2.320  1.00  0.00           H  
ATOM    839  HA  SER A  57      -4.293  10.944   5.106  1.00  0.00           H  
ATOM    840  HB2 SER A  57      -4.194   8.543   3.263  1.00  0.00           H  
ATOM    841  HB3 SER A  57      -4.145   8.476   5.024  1.00  0.00           H  
ATOM    842  HG  SER A  57      -6.223   8.985   5.124  1.00  0.00           H  
ATOM    843  N   LEU A  58      -1.819  10.244   3.063  1.00  0.00           N  
ATOM    844  CA  LEU A  58      -0.366  10.181   2.949  1.00  0.00           C  
ATOM    845  C   LEU A  58       0.259  11.551   3.192  1.00  0.00           C  
ATOM    846  O   LEU A  58       1.454  11.660   3.472  1.00  0.00           O  
ATOM    847  CB  LEU A  58       0.035   9.663   1.567  1.00  0.00           C  
ATOM    848  CG  LEU A  58      -0.567   8.319   1.153  1.00  0.00           C  
ATOM    849  CD1 LEU A  58       0.302   7.648   0.101  1.00  0.00           C  
ATOM    850  CD2 LEU A  58      -0.736   7.416   2.364  1.00  0.00           C  
ATOM    851  H   LEU A  58      -2.365  10.169   2.253  1.00  0.00           H  
ATOM    852  HA  LEU A  58      -0.004   9.495   3.700  1.00  0.00           H  
ATOM    853  HB2 LEU A  58      -0.266  10.399   0.837  1.00  0.00           H  
ATOM    854  HB3 LEU A  58       1.111   9.563   1.551  1.00  0.00           H  
ATOM    855  HG  LEU A  58      -1.544   8.488   0.721  1.00  0.00           H  
ATOM    856 HD11 LEU A  58       1.341   7.754   0.370  1.00  0.00           H  
ATOM    857 HD12 LEU A  58       0.129   8.113  -0.859  1.00  0.00           H  
ATOM    858 HD13 LEU A  58       0.049   6.599   0.042  1.00  0.00           H  
ATOM    859 HD21 LEU A  58      -0.758   6.384   2.043  1.00  0.00           H  
ATOM    860 HD22 LEU A  58      -1.662   7.656   2.867  1.00  0.00           H  
ATOM    861 HD23 LEU A  58       0.090   7.564   3.043  1.00  0.00           H  
ATOM    862  N   THR A  59      -0.555  12.596   3.087  1.00  0.00           N  
ATOM    863  CA  THR A  59      -0.084  13.959   3.295  1.00  0.00           C  
ATOM    864  C   THR A  59      -0.197  14.360   4.762  1.00  0.00           C  
ATOM    865  O   THR A  59       0.777  14.802   5.372  1.00  0.00           O  
ATOM    866  CB  THR A  59      -0.873  14.965   2.437  1.00  0.00           C  
ATOM    867  OG1 THR A  59      -2.238  15.011   2.867  1.00  0.00           O  
ATOM    868  CG2 THR A  59      -0.812  14.585   0.965  1.00  0.00           C  
ATOM    869  H   THR A  59      -1.497  12.445   2.862  1.00  0.00           H  
ATOM    870  HA  THR A  59       0.954  14.001   2.999  1.00  0.00           H  
ATOM    871  HB  THR A  59      -0.431  15.944   2.560  1.00  0.00           H  
ATOM    872  HG1 THR A  59      -2.418  15.865   3.268  1.00  0.00           H  
ATOM    873 HG21 THR A  59      -1.812  14.561   0.559  1.00  0.00           H  
ATOM    874 HG22 THR A  59      -0.358  13.610   0.863  1.00  0.00           H  
ATOM    875 HG23 THR A  59      -0.223  15.314   0.430  1.00  0.00           H  
ATOM    876  N   LYS A  60      -1.390  14.203   5.323  1.00  0.00           N  
ATOM    877  CA  LYS A  60      -1.632  14.548   6.720  1.00  0.00           C  
ATOM    878  C   LYS A  60      -0.558  13.947   7.621  1.00  0.00           C  
ATOM    879  O   LYS A  60      -0.173  14.543   8.627  1.00  0.00           O  
ATOM    880  CB  LYS A  60      -3.014  14.057   7.155  1.00  0.00           C  
ATOM    881  CG  LYS A  60      -3.227  14.099   8.659  1.00  0.00           C  
ATOM    882  CD  LYS A  60      -2.803  12.797   9.319  1.00  0.00           C  
ATOM    883  CE  LYS A  60      -3.941  11.788   9.342  1.00  0.00           C  
ATOM    884  NZ  LYS A  60      -5.000  12.167  10.317  1.00  0.00           N  
ATOM    885  H   LYS A  60      -2.128  13.846   4.785  1.00  0.00           H  
ATOM    886  HA  LYS A  60      -1.596  15.623   6.806  1.00  0.00           H  
ATOM    887  HB2 LYS A  60      -3.767  14.675   6.689  1.00  0.00           H  
ATOM    888  HB3 LYS A  60      -3.142  13.037   6.824  1.00  0.00           H  
ATOM    889  HG2 LYS A  60      -2.644  14.907   9.074  1.00  0.00           H  
ATOM    890  HG3 LYS A  60      -4.275  14.269   8.860  1.00  0.00           H  
ATOM    891  HD2 LYS A  60      -1.975  12.377   8.768  1.00  0.00           H  
ATOM    892  HD3 LYS A  60      -2.496  13.002  10.335  1.00  0.00           H  
ATOM    893  HE2 LYS A  60      -4.375  11.732   8.355  1.00  0.00           H  
ATOM    894  HE3 LYS A  60      -3.541  10.821   9.614  1.00  0.00           H  
ATOM    895  HZ1 LYS A  60      -5.498  13.019   9.990  1.00  0.00           H  
ATOM    896  HZ2 LYS A  60      -4.576  12.362  11.247  1.00  0.00           H  
ATOM    897  HZ3 LYS A  60      -5.687  11.394  10.417  1.00  0.00           H  
ATOM    898  N   ASP A  61      -0.079  12.763   7.254  1.00  0.00           N  
ATOM    899  CA  ASP A  61       0.952  12.082   8.029  1.00  0.00           C  
ATOM    900  C   ASP A  61       2.263  12.019   7.251  1.00  0.00           C  
ATOM    901  O   ASP A  61       3.227  11.389   7.688  1.00  0.00           O  
ATOM    902  CB  ASP A  61       0.494  10.670   8.396  1.00  0.00           C  
ATOM    903  CG  ASP A  61      -0.299  10.636   9.688  1.00  0.00           C  
ATOM    904  OD1 ASP A  61       0.227  11.104  10.719  1.00  0.00           O  
ATOM    905  OD2 ASP A  61      -1.445  10.141   9.667  1.00  0.00           O  
ATOM    906  H   ASP A  61      -0.427  12.338   6.442  1.00  0.00           H  
ATOM    907  HA  ASP A  61       1.112  12.645   8.935  1.00  0.00           H  
ATOM    908  HB2 ASP A  61      -0.128  10.282   7.603  1.00  0.00           H  
ATOM    909  HB3 ASP A  61       1.361  10.036   8.511  1.00  0.00           H  
ATOM    910  N   LYS A  62       2.292  12.676   6.097  1.00  0.00           N  
ATOM    911  CA  LYS A  62       3.484  12.696   5.258  1.00  0.00           C  
ATOM    912  C   LYS A  62       4.122  11.312   5.186  1.00  0.00           C  
ATOM    913  O   LYS A  62       5.339  11.170   5.317  1.00  0.00           O  
ATOM    914  CB  LYS A  62       4.497  13.709   5.797  1.00  0.00           C  
ATOM    915  CG  LYS A  62       3.895  15.071   6.093  1.00  0.00           C  
ATOM    916  CD  LYS A  62       3.384  15.157   7.522  1.00  0.00           C  
ATOM    917  CE  LYS A  62       4.529  15.283   8.517  1.00  0.00           C  
ATOM    918  NZ  LYS A  62       4.045  15.653   9.875  1.00  0.00           N  
ATOM    919  H   LYS A  62       1.492  13.160   5.802  1.00  0.00           H  
ATOM    920  HA  LYS A  62       3.186  12.993   4.264  1.00  0.00           H  
ATOM    921  HB2 LYS A  62       4.924  13.320   6.710  1.00  0.00           H  
ATOM    922  HB3 LYS A  62       5.284  13.837   5.068  1.00  0.00           H  
ATOM    923  HG2 LYS A  62       4.651  15.828   5.947  1.00  0.00           H  
ATOM    924  HG3 LYS A  62       3.072  15.245   5.415  1.00  0.00           H  
ATOM    925  HD2 LYS A  62       2.744  16.021   7.617  1.00  0.00           H  
ATOM    926  HD3 LYS A  62       2.821  14.262   7.748  1.00  0.00           H  
ATOM    927  HE2 LYS A  62       5.046  14.338   8.573  1.00  0.00           H  
ATOM    928  HE3 LYS A  62       5.210  16.045   8.166  1.00  0.00           H  
ATOM    929  HZ1 LYS A  62       3.413  14.912  10.243  1.00  0.00           H  
ATOM    930  HZ2 LYS A  62       3.523  16.551   9.837  1.00  0.00           H  
ATOM    931  HZ3 LYS A  62       4.851  15.760  10.525  1.00  0.00           H  
ATOM    932  N   VAL A  63       3.294  10.294   4.975  1.00  0.00           N  
ATOM    933  CA  VAL A  63       3.779   8.921   4.883  1.00  0.00           C  
ATOM    934  C   VAL A  63       4.856   8.789   3.812  1.00  0.00           C  
ATOM    935  O   VAL A  63       4.651   9.174   2.661  1.00  0.00           O  
ATOM    936  CB  VAL A  63       2.632   7.942   4.566  1.00  0.00           C  
ATOM    937  CG1 VAL A  63       3.161   6.520   4.451  1.00  0.00           C  
ATOM    938  CG2 VAL A  63       1.548   8.032   5.628  1.00  0.00           C  
ATOM    939  H   VAL A  63       2.335  10.469   4.878  1.00  0.00           H  
ATOM    940  HA  VAL A  63       4.200   8.651   5.840  1.00  0.00           H  
ATOM    941  HB  VAL A  63       2.201   8.220   3.616  1.00  0.00           H  
ATOM    942 HG11 VAL A  63       3.529   6.195   5.414  1.00  0.00           H  
ATOM    943 HG12 VAL A  63       2.366   5.865   4.128  1.00  0.00           H  
ATOM    944 HG13 VAL A  63       3.966   6.492   3.731  1.00  0.00           H  
ATOM    945 HG21 VAL A  63       1.977   7.831   6.598  1.00  0.00           H  
ATOM    946 HG22 VAL A  63       1.119   9.024   5.623  1.00  0.00           H  
ATOM    947 HG23 VAL A  63       0.775   7.307   5.416  1.00  0.00           H  
ATOM    948  N   GLN A  64       6.003   8.242   4.199  1.00  0.00           N  
ATOM    949  CA  GLN A  64       7.114   8.060   3.271  1.00  0.00           C  
ATOM    950  C   GLN A  64       7.548   6.598   3.224  1.00  0.00           C  
ATOM    951  O   GLN A  64       7.045   5.766   3.977  1.00  0.00           O  
ATOM    952  CB  GLN A  64       8.295   8.942   3.676  1.00  0.00           C  
ATOM    953  CG  GLN A  64       8.101  10.412   3.339  1.00  0.00           C  
ATOM    954  CD  GLN A  64       8.601  10.763   1.951  1.00  0.00           C  
ATOM    955  OE1 GLN A  64       9.727  11.234   1.786  1.00  0.00           O  
ATOM    956  NE2 GLN A  64       7.767  10.533   0.944  1.00  0.00           N  
ATOM    957  H   GLN A  64       6.106   7.955   5.130  1.00  0.00           H  
ATOM    958  HA  GLN A  64       6.776   8.354   2.289  1.00  0.00           H  
ATOM    959  HB2 GLN A  64       8.444   8.856   4.743  1.00  0.00           H  
ATOM    960  HB3 GLN A  64       9.182   8.593   3.167  1.00  0.00           H  
ATOM    961  HG2 GLN A  64       7.047  10.644   3.393  1.00  0.00           H  
ATOM    962  HG3 GLN A  64       8.638  11.007   4.061  1.00  0.00           H  
ATOM    963 HE21 GLN A  64       6.885  10.157   1.152  1.00  0.00           H  
ATOM    964 HE22 GLN A  64       8.064  10.752   0.038  1.00  0.00           H  
ATOM    965  N   ALA A  65       8.485   6.294   2.332  1.00  0.00           N  
ATOM    966  CA  ALA A  65       8.988   4.933   2.186  1.00  0.00           C  
ATOM    967  C   ALA A  65       9.683   4.466   3.462  1.00  0.00           C  
ATOM    968  O   ALA A  65      10.207   5.274   4.227  1.00  0.00           O  
ATOM    969  CB  ALA A  65       9.940   4.846   1.003  1.00  0.00           C  
ATOM    970  H   ALA A  65       8.847   7.001   1.759  1.00  0.00           H  
ATOM    971  HA  ALA A  65       8.147   4.285   1.990  1.00  0.00           H  
ATOM    972  HB1 ALA A  65       9.515   5.373   0.161  1.00  0.00           H  
ATOM    973  HB2 ALA A  65      10.886   5.293   1.267  1.00  0.00           H  
ATOM    974  HB3 ALA A  65      10.092   3.810   0.740  1.00  0.00           H  
ATOM    975  N   GLY A  66       9.683   3.155   3.685  1.00  0.00           N  
ATOM    976  CA  GLY A  66      10.315   2.603   4.869  1.00  0.00           C  
ATOM    977  C   GLY A  66       9.323   2.336   5.983  1.00  0.00           C  
ATOM    978  O   GLY A  66       9.506   1.412   6.777  1.00  0.00           O  
ATOM    979  H   GLY A  66       9.249   2.558   3.040  1.00  0.00           H  
ATOM    980  HA2 GLY A  66      10.802   1.678   4.604  1.00  0.00           H  
ATOM    981  HA3 GLY A  66      11.058   3.302   5.224  1.00  0.00           H  
ATOM    982  N   ASP A  67       8.273   3.147   6.047  1.00  0.00           N  
ATOM    983  CA  ASP A  67       7.250   2.994   7.074  1.00  0.00           C  
ATOM    984  C   ASP A  67       6.211   1.956   6.656  1.00  0.00           C  
ATOM    985  O   ASP A  67       6.219   1.477   5.521  1.00  0.00           O  
ATOM    986  CB  ASP A  67       6.567   4.334   7.347  1.00  0.00           C  
ATOM    987  CG  ASP A  67       7.349   5.194   8.321  1.00  0.00           C  
ATOM    988  OD1 ASP A  67       7.552   4.753   9.472  1.00  0.00           O  
ATOM    989  OD2 ASP A  67       7.757   6.308   7.932  1.00  0.00           O  
ATOM    990  H   ASP A  67       8.184   3.865   5.386  1.00  0.00           H  
ATOM    991  HA  ASP A  67       7.734   2.656   7.978  1.00  0.00           H  
ATOM    992  HB2 ASP A  67       6.466   4.876   6.418  1.00  0.00           H  
ATOM    993  HB3 ASP A  67       5.586   4.154   7.762  1.00  0.00           H  
ATOM    994  N   VAL A  68       5.321   1.612   7.581  1.00  0.00           N  
ATOM    995  CA  VAL A  68       4.277   0.632   7.309  1.00  0.00           C  
ATOM    996  C   VAL A  68       2.892   1.262   7.405  1.00  0.00           C  
ATOM    997  O   VAL A  68       2.507   1.780   8.454  1.00  0.00           O  
ATOM    998  CB  VAL A  68       4.357  -0.558   8.284  1.00  0.00           C  
ATOM    999  CG1 VAL A  68       3.062  -1.356   8.260  1.00  0.00           C  
ATOM   1000  CG2 VAL A  68       5.545  -1.445   7.946  1.00  0.00           C  
ATOM   1001  H   VAL A  68       5.367   2.028   8.467  1.00  0.00           H  
ATOM   1002  HA  VAL A  68       4.422   0.257   6.306  1.00  0.00           H  
ATOM   1003  HB  VAL A  68       4.496  -0.170   9.282  1.00  0.00           H  
ATOM   1004 HG11 VAL A  68       2.744  -1.495   7.237  1.00  0.00           H  
ATOM   1005 HG12 VAL A  68       3.222  -2.319   8.723  1.00  0.00           H  
ATOM   1006 HG13 VAL A  68       2.298  -0.819   8.803  1.00  0.00           H  
ATOM   1007 HG21 VAL A  68       5.327  -2.463   8.234  1.00  0.00           H  
ATOM   1008 HG22 VAL A  68       5.734  -1.405   6.883  1.00  0.00           H  
ATOM   1009 HG23 VAL A  68       6.417  -1.098   8.480  1.00  0.00           H  
ATOM   1010  N   ILE A  69       2.148   1.214   6.305  1.00  0.00           N  
ATOM   1011  CA  ILE A  69       0.806   1.779   6.267  1.00  0.00           C  
ATOM   1012  C   ILE A  69      -0.208   0.754   5.768  1.00  0.00           C  
ATOM   1013  O   ILE A  69       0.145  -0.194   5.065  1.00  0.00           O  
ATOM   1014  CB  ILE A  69       0.745   3.025   5.364  1.00  0.00           C  
ATOM   1015  CG1 ILE A  69       1.016   2.641   3.909  1.00  0.00           C  
ATOM   1016  CG2 ILE A  69       1.745   4.070   5.836  1.00  0.00           C  
ATOM   1017  CD1 ILE A  69      -0.215   2.162   3.171  1.00  0.00           C  
ATOM   1018  H   ILE A  69       2.511   0.787   5.501  1.00  0.00           H  
ATOM   1019  HA  ILE A  69       0.539   2.073   7.272  1.00  0.00           H  
ATOM   1020  HB  ILE A  69      -0.244   3.449   5.439  1.00  0.00           H  
ATOM   1021 HG12 ILE A  69       1.404   3.499   3.382  1.00  0.00           H  
ATOM   1022 HG13 ILE A  69       1.749   1.848   3.883  1.00  0.00           H  
ATOM   1023 HG21 ILE A  69       2.601   4.072   5.178  1.00  0.00           H  
ATOM   1024 HG22 ILE A  69       1.280   5.044   5.824  1.00  0.00           H  
ATOM   1025 HG23 ILE A  69       2.064   3.836   6.842  1.00  0.00           H  
ATOM   1026 HD11 ILE A  69      -1.100   2.519   3.677  1.00  0.00           H  
ATOM   1027 HD12 ILE A  69      -0.200   2.540   2.160  1.00  0.00           H  
ATOM   1028 HD13 ILE A  69      -0.224   1.081   3.152  1.00  0.00           H  
ATOM   1029  N   THR A  70      -1.471   0.952   6.134  1.00  0.00           N  
ATOM   1030  CA  THR A  70      -2.537   0.047   5.723  1.00  0.00           C  
ATOM   1031  C   THR A  70      -3.422   0.686   4.660  1.00  0.00           C  
ATOM   1032  O   THR A  70      -3.323   1.885   4.395  1.00  0.00           O  
ATOM   1033  CB  THR A  70      -3.410  -0.371   6.921  1.00  0.00           C  
ATOM   1034  OG1 THR A  70      -3.895   0.791   7.603  1.00  0.00           O  
ATOM   1035  CG2 THR A  70      -2.624  -1.242   7.888  1.00  0.00           C  
ATOM   1036  H   THR A  70      -1.689   1.727   6.694  1.00  0.00           H  
ATOM   1037  HA  THR A  70      -2.080  -0.841   5.311  1.00  0.00           H  
ATOM   1038  HB  THR A  70      -4.252  -0.939   6.551  1.00  0.00           H  
ATOM   1039  HG1 THR A  70      -4.165   1.451   6.960  1.00  0.00           H  
ATOM   1040 HG21 THR A  70      -2.412  -0.682   8.787  1.00  0.00           H  
ATOM   1041 HG22 THR A  70      -1.696  -1.545   7.426  1.00  0.00           H  
ATOM   1042 HG23 THR A  70      -3.204  -2.117   8.138  1.00  0.00           H  
ATOM   1043  N   ILE A  71      -4.289  -0.120   4.056  1.00  0.00           N  
ATOM   1044  CA  ILE A  71      -5.193   0.369   3.022  1.00  0.00           C  
ATOM   1045  C   ILE A  71      -6.572  -0.268   3.154  1.00  0.00           C  
ATOM   1046  O   ILE A  71      -6.724  -1.481   3.008  1.00  0.00           O  
ATOM   1047  CB  ILE A  71      -4.642   0.088   1.612  1.00  0.00           C  
ATOM   1048  CG1 ILE A  71      -3.399   0.941   1.348  1.00  0.00           C  
ATOM   1049  CG2 ILE A  71      -5.710   0.357   0.562  1.00  0.00           C  
ATOM   1050  CD1 ILE A  71      -2.487   0.366   0.286  1.00  0.00           C  
ATOM   1051  H   ILE A  71      -4.320  -1.065   4.310  1.00  0.00           H  
ATOM   1052  HA  ILE A  71      -5.289   1.438   3.143  1.00  0.00           H  
ATOM   1053  HB  ILE A  71      -4.371  -0.956   1.557  1.00  0.00           H  
ATOM   1054 HG12 ILE A  71      -3.706   1.922   1.024  1.00  0.00           H  
ATOM   1055 HG13 ILE A  71      -2.830   1.028   2.262  1.00  0.00           H  
ATOM   1056 HG21 ILE A  71      -5.974  -0.569   0.072  1.00  0.00           H  
ATOM   1057 HG22 ILE A  71      -6.584   0.775   1.038  1.00  0.00           H  
ATOM   1058 HG23 ILE A  71      -5.328   1.055  -0.168  1.00  0.00           H  
ATOM   1059 HD11 ILE A  71      -2.505  -0.713   0.341  1.00  0.00           H  
ATOM   1060 HD12 ILE A  71      -2.825   0.683  -0.690  1.00  0.00           H  
ATOM   1061 HD13 ILE A  71      -1.478   0.718   0.449  1.00  0.00           H  
ATOM   1062  N   ASP A  72      -7.575   0.558   3.427  1.00  0.00           N  
ATOM   1063  CA  ASP A  72      -8.944   0.076   3.574  1.00  0.00           C  
ATOM   1064  C   ASP A  72      -9.707   0.198   2.259  1.00  0.00           C  
ATOM   1065  O   ASP A  72     -10.098   1.293   1.855  1.00  0.00           O  
ATOM   1066  CB  ASP A  72      -9.667   0.859   4.672  1.00  0.00           C  
ATOM   1067  CG  ASP A  72     -10.800   0.067   5.297  1.00  0.00           C  
ATOM   1068  OD1 ASP A  72     -11.498  -0.656   4.555  1.00  0.00           O  
ATOM   1069  OD2 ASP A  72     -10.986   0.170   6.527  1.00  0.00           O  
ATOM   1070  H   ASP A  72      -7.392   1.515   3.531  1.00  0.00           H  
ATOM   1071  HA  ASP A  72      -8.901  -0.964   3.856  1.00  0.00           H  
ATOM   1072  HB2 ASP A  72      -8.961   1.114   5.448  1.00  0.00           H  
ATOM   1073  HB3 ASP A  72     -10.075   1.765   4.250  1.00  0.00           H  
ATOM   1074  N   LYS A  73      -9.916  -0.934   1.595  1.00  0.00           N  
ATOM   1075  CA  LYS A  73     -10.634  -0.957   0.326  1.00  0.00           C  
ATOM   1076  C   LYS A  73     -12.131  -0.765   0.543  1.00  0.00           C  
ATOM   1077  O   LYS A  73     -12.855  -0.369  -0.370  1.00  0.00           O  
ATOM   1078  CB  LYS A  73     -10.377  -2.276  -0.405  1.00  0.00           C  
ATOM   1079  CG  LYS A  73      -8.922  -2.713  -0.380  1.00  0.00           C  
ATOM   1080  CD  LYS A  73      -8.730  -4.048  -1.080  1.00  0.00           C  
ATOM   1081  CE  LYS A  73      -8.625  -3.875  -2.588  1.00  0.00           C  
ATOM   1082  NZ  LYS A  73      -9.126  -5.072  -3.320  1.00  0.00           N  
ATOM   1083  H   LYS A  73      -9.580  -1.776   1.970  1.00  0.00           H  
ATOM   1084  HA  LYS A  73     -10.263  -0.142  -0.279  1.00  0.00           H  
ATOM   1085  HB2 LYS A  73     -10.972  -3.051   0.057  1.00  0.00           H  
ATOM   1086  HB3 LYS A  73     -10.681  -2.168  -1.436  1.00  0.00           H  
ATOM   1087  HG2 LYS A  73      -8.323  -1.967  -0.878  1.00  0.00           H  
ATOM   1088  HG3 LYS A  73      -8.603  -2.808   0.649  1.00  0.00           H  
ATOM   1089  HD2 LYS A  73      -7.821  -4.506  -0.718  1.00  0.00           H  
ATOM   1090  HD3 LYS A  73      -9.572  -4.688  -0.857  1.00  0.00           H  
ATOM   1091  HE2 LYS A  73      -9.209  -3.016  -2.880  1.00  0.00           H  
ATOM   1092  HE3 LYS A  73      -7.589  -3.712  -2.847  1.00  0.00           H  
ATOM   1093  HZ1 LYS A  73      -9.708  -4.778  -4.129  1.00  0.00           H  
ATOM   1094  HZ2 LYS A  73      -9.704  -5.662  -2.687  1.00  0.00           H  
ATOM   1095  HZ3 LYS A  73      -8.326  -5.638  -3.668  1.00  0.00           H  
ATOM   1096  N   ALA A  74     -12.588  -1.046   1.758  1.00  0.00           N  
ATOM   1097  CA  ALA A  74     -13.999  -0.903   2.096  1.00  0.00           C  
ATOM   1098  C   ALA A  74     -14.431   0.559   2.035  1.00  0.00           C  
ATOM   1099  O   ALA A  74     -15.437   0.894   1.409  1.00  0.00           O  
ATOM   1100  CB  ALA A  74     -14.273  -1.479   3.477  1.00  0.00           C  
ATOM   1101  H   ALA A  74     -11.962  -1.358   2.445  1.00  0.00           H  
ATOM   1102  HA  ALA A  74     -14.574  -1.468   1.376  1.00  0.00           H  
ATOM   1103  HB1 ALA A  74     -13.754  -0.892   4.221  1.00  0.00           H  
ATOM   1104  HB2 ALA A  74     -15.334  -1.453   3.674  1.00  0.00           H  
ATOM   1105  HB3 ALA A  74     -13.924  -2.500   3.517  1.00  0.00           H  
ATOM   1106  N   THR A  75     -13.666   1.426   2.692  1.00  0.00           N  
ATOM   1107  CA  THR A  75     -13.970   2.850   2.713  1.00  0.00           C  
ATOM   1108  C   THR A  75     -13.013   3.631   1.820  1.00  0.00           C  
ATOM   1109  O   THR A  75     -13.292   4.766   1.437  1.00  0.00           O  
ATOM   1110  CB  THR A  75     -13.900   3.418   4.143  1.00  0.00           C  
ATOM   1111  OG1 THR A  75     -14.007   4.845   4.109  1.00  0.00           O  
ATOM   1112  CG2 THR A  75     -12.598   3.018   4.821  1.00  0.00           C  
ATOM   1113  H   THR A  75     -12.877   1.096   3.172  1.00  0.00           H  
ATOM   1114  HA  THR A  75     -14.978   2.982   2.345  1.00  0.00           H  
ATOM   1115  HB  THR A  75     -14.724   3.016   4.715  1.00  0.00           H  
ATOM   1116  HG1 THR A  75     -13.150   5.226   3.899  1.00  0.00           H  
ATOM   1117 HG21 THR A  75     -12.309   3.782   5.526  1.00  0.00           H  
ATOM   1118 HG22 THR A  75     -11.824   2.904   4.075  1.00  0.00           H  
ATOM   1119 HG23 THR A  75     -12.735   2.081   5.341  1.00  0.00           H  
ATOM   1120  N   GLY A  76     -11.881   3.015   1.492  1.00  0.00           N  
ATOM   1121  CA  GLY A  76     -10.899   3.668   0.646  1.00  0.00           C  
ATOM   1122  C   GLY A  76     -10.010   4.622   1.420  1.00  0.00           C  
ATOM   1123  O   GLY A  76      -9.491   5.588   0.862  1.00  0.00           O  
ATOM   1124  H   GLY A  76     -11.711   2.110   1.827  1.00  0.00           H  
ATOM   1125  HA2 GLY A  76     -10.282   2.914   0.181  1.00  0.00           H  
ATOM   1126  HA3 GLY A  76     -11.416   4.221  -0.124  1.00  0.00           H  
ATOM   1127  N   LYS A  77      -9.836   4.352   2.709  1.00  0.00           N  
ATOM   1128  CA  LYS A  77      -9.005   5.193   3.561  1.00  0.00           C  
ATOM   1129  C   LYS A  77      -7.721   4.469   3.955  1.00  0.00           C  
ATOM   1130  O   LYS A  77      -7.671   3.238   3.966  1.00  0.00           O  
ATOM   1131  CB  LYS A  77      -9.777   5.604   4.817  1.00  0.00           C  
ATOM   1132  CG  LYS A  77     -10.656   6.826   4.619  1.00  0.00           C  
ATOM   1133  CD  LYS A  77     -10.909   7.551   5.931  1.00  0.00           C  
ATOM   1134  CE  LYS A  77     -11.764   6.716   6.871  1.00  0.00           C  
ATOM   1135  NZ  LYS A  77     -11.892   7.349   8.214  1.00  0.00           N  
ATOM   1136  H   LYS A  77     -10.277   3.566   3.096  1.00  0.00           H  
ATOM   1137  HA  LYS A  77      -8.747   6.079   3.002  1.00  0.00           H  
ATOM   1138  HB2 LYS A  77     -10.406   4.780   5.124  1.00  0.00           H  
ATOM   1139  HB3 LYS A  77      -9.070   5.818   5.606  1.00  0.00           H  
ATOM   1140  HG2 LYS A  77     -10.166   7.504   3.935  1.00  0.00           H  
ATOM   1141  HG3 LYS A  77     -11.602   6.514   4.202  1.00  0.00           H  
ATOM   1142  HD2 LYS A  77      -9.962   7.754   6.409  1.00  0.00           H  
ATOM   1143  HD3 LYS A  77     -11.417   8.482   5.725  1.00  0.00           H  
ATOM   1144  HE2 LYS A  77     -12.747   6.606   6.441  1.00  0.00           H  
ATOM   1145  HE3 LYS A  77     -11.310   5.743   6.983  1.00  0.00           H  
ATOM   1146  HZ1 LYS A  77     -11.058   7.941   8.409  1.00  0.00           H  
ATOM   1147  HZ2 LYS A  77     -11.963   6.617   8.948  1.00  0.00           H  
ATOM   1148  HZ3 LYS A  77     -12.743   7.945   8.248  1.00  0.00           H  
ATOM   1149  N   ILE A  78      -6.689   5.238   4.278  1.00  0.00           N  
ATOM   1150  CA  ILE A  78      -5.406   4.669   4.675  1.00  0.00           C  
ATOM   1151  C   ILE A  78      -5.029   5.096   6.090  1.00  0.00           C  
ATOM   1152  O   ILE A  78      -5.269   6.235   6.491  1.00  0.00           O  
ATOM   1153  CB  ILE A  78      -4.282   5.087   3.709  1.00  0.00           C  
ATOM   1154  CG1 ILE A  78      -4.442   4.372   2.366  1.00  0.00           C  
ATOM   1155  CG2 ILE A  78      -2.921   4.782   4.318  1.00  0.00           C  
ATOM   1156  CD1 ILE A  78      -3.800   5.107   1.210  1.00  0.00           C  
ATOM   1157  H   ILE A  78      -6.790   6.213   4.250  1.00  0.00           H  
ATOM   1158  HA  ILE A  78      -5.497   3.593   4.647  1.00  0.00           H  
ATOM   1159  HB  ILE A  78      -4.350   6.152   3.553  1.00  0.00           H  
ATOM   1160 HG12 ILE A  78      -3.992   3.394   2.429  1.00  0.00           H  
ATOM   1161 HG13 ILE A  78      -5.496   4.265   2.148  1.00  0.00           H  
ATOM   1162 HG21 ILE A  78      -3.031   4.035   5.090  1.00  0.00           H  
ATOM   1163 HG22 ILE A  78      -2.259   4.409   3.551  1.00  0.00           H  
ATOM   1164 HG23 ILE A  78      -2.508   5.683   4.744  1.00  0.00           H  
ATOM   1165 HD11 ILE A  78      -2.877   5.559   1.539  1.00  0.00           H  
ATOM   1166 HD12 ILE A  78      -3.596   4.411   0.410  1.00  0.00           H  
ATOM   1167 HD13 ILE A  78      -4.471   5.876   0.856  1.00  0.00           H  
ATOM   1168  N   SER A  79      -4.437   4.173   6.842  1.00  0.00           N  
ATOM   1169  CA  SER A  79      -4.028   4.453   8.214  1.00  0.00           C  
ATOM   1170  C   SER A  79      -2.567   4.074   8.433  1.00  0.00           C  
ATOM   1171  O   SER A  79      -2.034   3.193   7.759  1.00  0.00           O  
ATOM   1172  CB  SER A  79      -4.917   3.690   9.198  1.00  0.00           C  
ATOM   1173  OG  SER A  79      -6.139   4.373   9.416  1.00  0.00           O  
ATOM   1174  H   SER A  79      -4.273   3.283   6.466  1.00  0.00           H  
ATOM   1175  HA  SER A  79      -4.144   5.513   8.384  1.00  0.00           H  
ATOM   1176  HB2 SER A  79      -5.133   2.710   8.800  1.00  0.00           H  
ATOM   1177  HB3 SER A  79      -4.401   3.590  10.142  1.00  0.00           H  
ATOM   1178  HG  SER A  79      -6.713   4.254   8.657  1.00  0.00           H  
ATOM   1179  N   LYS A  80      -1.923   4.747   9.381  1.00  0.00           N  
ATOM   1180  CA  LYS A  80      -0.524   4.483   9.692  1.00  0.00           C  
ATOM   1181  C   LYS A  80      -0.398   3.637  10.955  1.00  0.00           C  
ATOM   1182  O   LYS A  80      -1.111   3.856  11.936  1.00  0.00           O  
ATOM   1183  CB  LYS A  80       0.238   5.799   9.869  1.00  0.00           C  
ATOM   1184  CG  LYS A  80       1.709   5.704   9.505  1.00  0.00           C  
ATOM   1185  CD  LYS A  80       2.308   7.076   9.243  1.00  0.00           C  
ATOM   1186  CE  LYS A  80       2.737   7.751  10.537  1.00  0.00           C  
ATOM   1187  NZ  LYS A  80       1.615   8.494  11.174  1.00  0.00           N  
ATOM   1188  H   LYS A  80      -2.404   5.439   9.885  1.00  0.00           H  
ATOM   1189  HA  LYS A  80      -0.097   3.939   8.864  1.00  0.00           H  
ATOM   1190  HB2 LYS A  80      -0.220   6.552   9.243  1.00  0.00           H  
ATOM   1191  HB3 LYS A  80       0.163   6.108  10.901  1.00  0.00           H  
ATOM   1192  HG2 LYS A  80       2.243   5.239  10.319  1.00  0.00           H  
ATOM   1193  HG3 LYS A  80       1.811   5.101   8.614  1.00  0.00           H  
ATOM   1194  HD2 LYS A  80       3.172   6.967   8.604  1.00  0.00           H  
ATOM   1195  HD3 LYS A  80       1.570   7.694   8.752  1.00  0.00           H  
ATOM   1196  HE2 LYS A  80       3.093   6.997  11.221  1.00  0.00           H  
ATOM   1197  HE3 LYS A  80       3.537   8.443  10.317  1.00  0.00           H  
ATOM   1198  HZ1 LYS A  80       1.949   8.980  12.031  1.00  0.00           H  
ATOM   1199  HZ2 LYS A  80       0.855   7.835  11.437  1.00  0.00           H  
ATOM   1200  HZ3 LYS A  80       1.234   9.201  10.515  1.00  0.00           H  
ATOM   1201  N   LEU A  81       0.514   2.671  10.925  1.00  0.00           N  
ATOM   1202  CA  LEU A  81       0.735   1.793  12.069  1.00  0.00           C  
ATOM   1203  C   LEU A  81       2.146   1.965  12.623  1.00  0.00           C  
ATOM   1204  O   LEU A  81       2.356   1.927  13.835  1.00  0.00           O  
ATOM   1205  CB  LEU A  81       0.507   0.334  11.668  1.00  0.00           C  
ATOM   1206  CG  LEU A  81      -0.635   0.079  10.683  1.00  0.00           C  
ATOM   1207  CD1 LEU A  81      -0.148   0.225   9.250  1.00  0.00           C  
ATOM   1208  CD2 LEU A  81      -1.234  -1.302  10.907  1.00  0.00           C  
ATOM   1209  H   LEU A  81       1.051   2.545  10.116  1.00  0.00           H  
ATOM   1210  HA  LEU A  81       0.025   2.062  12.836  1.00  0.00           H  
ATOM   1211  HB2 LEU A  81       1.418  -0.032  11.219  1.00  0.00           H  
ATOM   1212  HB3 LEU A  81       0.301  -0.227  12.568  1.00  0.00           H  
ATOM   1213  HG  LEU A  81      -1.413   0.813  10.848  1.00  0.00           H  
ATOM   1214 HD11 LEU A  81       0.889   0.522   9.252  1.00  0.00           H  
ATOM   1215 HD12 LEU A  81      -0.737   0.976   8.745  1.00  0.00           H  
ATOM   1216 HD13 LEU A  81      -0.252  -0.720   8.737  1.00  0.00           H  
ATOM   1217 HD21 LEU A  81      -1.083  -1.597  11.936  1.00  0.00           H  
ATOM   1218 HD22 LEU A  81      -0.750  -2.014  10.255  1.00  0.00           H  
ATOM   1219 HD23 LEU A  81      -2.291  -1.275  10.691  1.00  0.00           H  
ATOM   1220  N   GLY A  82       3.108   2.158  11.727  1.00  0.00           N  
ATOM   1221  CA  GLY A  82       4.487   2.336  12.146  1.00  0.00           C  
ATOM   1222  C   GLY A  82       5.407   1.273  11.578  1.00  0.00           C  
ATOM   1223  O   GLY A  82       5.785   1.330  10.409  1.00  0.00           O  
ATOM   1224  H   GLY A  82       2.882   2.180  10.774  1.00  0.00           H  
ATOM   1225  HA2 GLY A  82       4.829   3.306  11.818  1.00  0.00           H  
ATOM   1226  HA3 GLY A  82       4.531   2.295  13.225  1.00  0.00           H  
ATOM   1227  N   ARG A  83       5.769   0.301  12.409  1.00  0.00           N  
ATOM   1228  CA  ARG A  83       6.653  -0.778  11.985  1.00  0.00           C  
ATOM   1229  C   ARG A  83       5.932  -2.122  12.032  1.00  0.00           C  
ATOM   1230  O   ARG A  83       4.784  -2.208  12.470  1.00  0.00           O  
ATOM   1231  CB  ARG A  83       7.898  -0.824  12.871  1.00  0.00           C  
ATOM   1232  CG  ARG A  83       9.032   0.059  12.376  1.00  0.00           C  
ATOM   1233  CD  ARG A  83       8.746   1.530  12.637  1.00  0.00           C  
ATOM   1234  NE  ARG A  83       9.087   1.918  14.004  1.00  0.00           N  
ATOM   1235  CZ  ARG A  83       8.783   3.101  14.528  1.00  0.00           C  
ATOM   1236  NH1 ARG A  83       8.137   4.005  13.805  1.00  0.00           N  
ATOM   1237  NH2 ARG A  83       9.126   3.381  15.779  1.00  0.00           N  
ATOM   1238  H   ARG A  83       5.434   0.310  13.331  1.00  0.00           H  
ATOM   1239  HA  ARG A  83       6.953  -0.580  10.967  1.00  0.00           H  
ATOM   1240  HB2 ARG A  83       7.630  -0.503  13.867  1.00  0.00           H  
ATOM   1241  HB3 ARG A  83       8.257  -1.842  12.915  1.00  0.00           H  
ATOM   1242  HG2 ARG A  83       9.941  -0.217  12.889  1.00  0.00           H  
ATOM   1243  HG3 ARG A  83       9.155  -0.092  11.314  1.00  0.00           H  
ATOM   1244  HD2 ARG A  83       9.329   2.123  11.949  1.00  0.00           H  
ATOM   1245  HD3 ARG A  83       7.696   1.714  12.471  1.00  0.00           H  
ATOM   1246  HE  ARG A  83       9.564   1.266  14.555  1.00  0.00           H  
ATOM   1247 HH11 ARG A  83       7.877   3.797  12.862  1.00  0.00           H  
ATOM   1248 HH12 ARG A  83       7.909   4.894  14.203  1.00  0.00           H  
ATOM   1249 HH21 ARG A  83       9.614   2.702  16.327  1.00  0.00           H  
ATOM   1250 HH22 ARG A  83       8.899   4.270  16.173  1.00  0.00           H  
ATOM   1251  N   SER A  84       6.613  -3.170  11.579  1.00  0.00           N  
ATOM   1252  CA  SER A  84       6.036  -4.508  11.565  1.00  0.00           C  
ATOM   1253  C   SER A  84       7.125  -5.571  11.682  1.00  0.00           C  
ATOM   1254  O   SER A  84       8.311  -5.280  11.523  1.00  0.00           O  
ATOM   1255  CB  SER A  84       5.231  -4.727  10.282  1.00  0.00           C  
ATOM   1256  OG  SER A  84       4.396  -5.867  10.392  1.00  0.00           O  
ATOM   1257  H   SER A  84       7.524  -3.037  11.243  1.00  0.00           H  
ATOM   1258  HA  SER A  84       5.374  -4.593  12.414  1.00  0.00           H  
ATOM   1259  HB2 SER A  84       4.614  -3.862  10.096  1.00  0.00           H  
ATOM   1260  HB3 SER A  84       5.911  -4.871   9.455  1.00  0.00           H  
ATOM   1261  HG  SER A  84       3.596  -5.729   9.881  1.00  0.00           H  
ATOM   1262  N   PHE A  85       6.714  -6.803  11.962  1.00  0.00           N  
ATOM   1263  CA  PHE A  85       7.654  -7.909  12.103  1.00  0.00           C  
ATOM   1264  C   PHE A  85       7.563  -8.854  10.908  1.00  0.00           C  
ATOM   1265  O   PHE A  85       6.685  -9.715  10.847  1.00  0.00           O  
ATOM   1266  CB  PHE A  85       7.380  -8.678  13.397  1.00  0.00           C  
ATOM   1267  CG  PHE A  85       8.017  -8.059  14.608  1.00  0.00           C  
ATOM   1268  CD1 PHE A  85       9.397  -8.035  14.745  1.00  0.00           C  
ATOM   1269  CD2 PHE A  85       7.239  -7.501  15.609  1.00  0.00           C  
ATOM   1270  CE1 PHE A  85       9.985  -7.466  15.858  1.00  0.00           C  
ATOM   1271  CE2 PHE A  85       7.823  -6.931  16.725  1.00  0.00           C  
ATOM   1272  CZ  PHE A  85       9.198  -6.913  16.849  1.00  0.00           C  
ATOM   1273  H   PHE A  85       5.756  -6.972  12.078  1.00  0.00           H  
ATOM   1274  HA  PHE A  85       8.648  -7.494  12.144  1.00  0.00           H  
ATOM   1275  HB2 PHE A  85       6.314  -8.715  13.566  1.00  0.00           H  
ATOM   1276  HB3 PHE A  85       7.760  -9.683  13.297  1.00  0.00           H  
ATOM   1277  HD1 PHE A  85      10.013  -8.466  13.971  1.00  0.00           H  
ATOM   1278  HD2 PHE A  85       6.162  -7.514  15.513  1.00  0.00           H  
ATOM   1279  HE1 PHE A  85      11.061  -7.454  15.953  1.00  0.00           H  
ATOM   1280  HE2 PHE A  85       7.204  -6.499  17.497  1.00  0.00           H  
ATOM   1281  HZ  PHE A  85       9.656  -6.469  17.720  1.00  0.00           H  
ATOM   1282  N   THR A  86       8.478  -8.686   9.958  1.00  0.00           N  
ATOM   1283  CA  THR A  86       8.502  -9.522   8.765  1.00  0.00           C  
ATOM   1284  C   THR A  86       9.465 -10.692   8.931  1.00  0.00           C  
ATOM   1285  O   THR A  86      10.588 -10.522   9.405  1.00  0.00           O  
ATOM   1286  CB  THR A  86       8.908  -8.712   7.518  1.00  0.00           C  
ATOM   1287  OG1 THR A  86       8.125  -7.515   7.436  1.00  0.00           O  
ATOM   1288  CG2 THR A  86       8.721  -9.534   6.253  1.00  0.00           C  
ATOM   1289  H   THR A  86       9.152  -7.983  10.064  1.00  0.00           H  
ATOM   1290  HA  THR A  86       7.505  -9.908   8.607  1.00  0.00           H  
ATOM   1291  HB  THR A  86       9.952  -8.444   7.607  1.00  0.00           H  
ATOM   1292  HG1 THR A  86       7.344  -7.680   6.901  1.00  0.00           H  
ATOM   1293 HG21 THR A  86       7.668  -9.708   6.088  1.00  0.00           H  
ATOM   1294 HG22 THR A  86       9.230 -10.480   6.360  1.00  0.00           H  
ATOM   1295 HG23 THR A  86       9.133  -8.997   5.412  1.00  0.00           H  
ATOM   1296  N   ARG A  87       9.018 -11.881   8.537  1.00  0.00           N  
ATOM   1297  CA  ARG A  87       9.841 -13.079   8.644  1.00  0.00           C  
ATOM   1298  C   ARG A  87      10.634 -13.310   7.361  1.00  0.00           C  
ATOM   1299  O   ARG A  87      10.062 -13.559   6.301  1.00  0.00           O  
ATOM   1300  CB  ARG A  87       8.967 -14.299   8.942  1.00  0.00           C  
ATOM   1301  CG  ARG A  87       8.379 -14.300  10.344  1.00  0.00           C  
ATOM   1302  CD  ARG A  87       7.096 -15.112  10.409  1.00  0.00           C  
ATOM   1303  NE  ARG A  87       7.357 -16.531  10.637  1.00  0.00           N  
ATOM   1304  CZ  ARG A  87       7.607 -17.049  11.834  1.00  0.00           C  
ATOM   1305  NH1 ARG A  87       7.629 -16.270  12.906  1.00  0.00           N  
ATOM   1306  NH2 ARG A  87       7.834 -18.350  11.960  1.00  0.00           N  
ATOM   1307  H   ARG A  87       8.114 -11.953   8.168  1.00  0.00           H  
ATOM   1308  HA  ARG A  87      10.533 -12.936   9.461  1.00  0.00           H  
ATOM   1309  HB2 ARG A  87       8.151 -14.324   8.234  1.00  0.00           H  
ATOM   1310  HB3 ARG A  87       9.563 -15.192   8.824  1.00  0.00           H  
ATOM   1311  HG2 ARG A  87       9.099 -14.729  11.026  1.00  0.00           H  
ATOM   1312  HG3 ARG A  87       8.167 -13.282  10.636  1.00  0.00           H  
ATOM   1313  HD2 ARG A  87       6.487 -14.734  11.217  1.00  0.00           H  
ATOM   1314  HD3 ARG A  87       6.565 -14.999   9.476  1.00  0.00           H  
ATOM   1315  HE  ARG A  87       7.345 -17.125   9.858  1.00  0.00           H  
ATOM   1316 HH11 ARG A  87       7.457 -15.289  12.814  1.00  0.00           H  
ATOM   1317 HH12 ARG A  87       7.817 -16.664  13.806  1.00  0.00           H  
ATOM   1318 HH21 ARG A  87       7.818 -18.941  11.154  1.00  0.00           H  
ATOM   1319 HH22 ARG A  87       8.023 -18.740  12.862  1.00  0.00           H  
ATOM   1320  N   ALA A  88      11.957 -13.225   7.467  1.00  0.00           N  
ATOM   1321  CA  ALA A  88      12.829 -13.425   6.316  1.00  0.00           C  
ATOM   1322  C   ALA A  88      13.752 -14.620   6.529  1.00  0.00           C  
ATOM   1323  O   ALA A  88      14.089 -14.962   7.663  1.00  0.00           O  
ATOM   1324  CB  ALA A  88      13.642 -12.169   6.045  1.00  0.00           C  
ATOM   1325  H   ALA A  88      12.355 -13.024   8.339  1.00  0.00           H  
ATOM   1326  HA  ALA A  88      12.205 -13.614   5.454  1.00  0.00           H  
ATOM   1327  HB1 ALA A  88      14.027 -12.201   5.035  1.00  0.00           H  
ATOM   1328  HB2 ALA A  88      13.013 -11.300   6.163  1.00  0.00           H  
ATOM   1329  HB3 ALA A  88      14.465 -12.115   6.742  1.00  0.00           H  
ATOM   1330  N   ARG A  89      14.158 -15.251   5.432  1.00  0.00           N  
ATOM   1331  CA  ARG A  89      15.041 -16.409   5.500  1.00  0.00           C  
ATOM   1332  C   ARG A  89      16.505 -15.978   5.490  1.00  0.00           C  
ATOM   1333  O   ARG A  89      16.926 -15.191   4.641  1.00  0.00           O  
ATOM   1334  CB  ARG A  89      14.770 -17.354   4.327  1.00  0.00           C  
ATOM   1335  CG  ARG A  89      13.629 -18.326   4.582  1.00  0.00           C  
ATOM   1336  CD  ARG A  89      12.288 -17.727   4.188  1.00  0.00           C  
ATOM   1337  NE  ARG A  89      12.170 -17.548   2.743  1.00  0.00           N  
ATOM   1338  CZ  ARG A  89      11.139 -16.949   2.159  1.00  0.00           C  
ATOM   1339  NH1 ARG A  89      10.142 -16.472   2.891  1.00  0.00           N  
ATOM   1340  NH2 ARG A  89      11.104 -16.824   0.839  1.00  0.00           N  
ATOM   1341  H   ARG A  89      13.856 -14.930   4.556  1.00  0.00           H  
ATOM   1342  HA  ARG A  89      14.838 -16.928   6.424  1.00  0.00           H  
ATOM   1343  HB2 ARG A  89      14.524 -16.766   3.455  1.00  0.00           H  
ATOM   1344  HB3 ARG A  89      15.663 -17.925   4.127  1.00  0.00           H  
ATOM   1345  HG2 ARG A  89      13.795 -19.221   3.999  1.00  0.00           H  
ATOM   1346  HG3 ARG A  89      13.609 -18.576   5.632  1.00  0.00           H  
ATOM   1347  HD2 ARG A  89      11.501 -18.386   4.525  1.00  0.00           H  
ATOM   1348  HD3 ARG A  89      12.184 -16.767   4.670  1.00  0.00           H  
ATOM   1349  HE  ARG A  89      12.896 -17.893   2.183  1.00  0.00           H  
ATOM   1350 HH11 ARG A  89      10.166 -16.564   3.887  1.00  0.00           H  
ATOM   1351 HH12 ARG A  89       9.367 -16.020   2.449  1.00  0.00           H  
ATOM   1352 HH21 ARG A  89      11.854 -17.182   0.282  1.00  0.00           H  
ATOM   1353 HH22 ARG A  89      10.328 -16.373   0.400  1.00  0.00           H  
ATOM   1354  N   SER A  90      17.276 -16.496   6.440  1.00  0.00           N  
ATOM   1355  CA  SER A  90      18.692 -16.162   6.544  1.00  0.00           C  
ATOM   1356  C   SER A  90      19.557 -17.411   6.400  1.00  0.00           C  
ATOM   1357  O   SER A  90      20.438 -17.474   5.545  1.00  0.00           O  
ATOM   1358  CB  SER A  90      18.980 -15.480   7.883  1.00  0.00           C  
ATOM   1359  OG  SER A  90      18.692 -14.094   7.821  1.00  0.00           O  
ATOM   1360  H   SER A  90      16.882 -17.118   7.088  1.00  0.00           H  
ATOM   1361  HA  SER A  90      18.930 -15.479   5.743  1.00  0.00           H  
ATOM   1362  HB2 SER A  90      18.369 -15.928   8.651  1.00  0.00           H  
ATOM   1363  HB3 SER A  90      20.022 -15.608   8.131  1.00  0.00           H  
ATOM   1364  HG  SER A  90      19.205 -13.629   8.486  1.00  0.00           H  
ATOM   1365  N   GLY A  91      19.298 -18.403   7.245  1.00  0.00           N  
ATOM   1366  CA  GLY A  91      20.060 -19.637   7.198  1.00  0.00           C  
ATOM   1367  C   GLY A  91      20.758 -19.939   8.509  1.00  0.00           C  
ATOM   1368  O   GLY A  91      20.179 -20.525   9.423  1.00  0.00           O  
ATOM   1369  H   GLY A  91      18.582 -18.297   7.907  1.00  0.00           H  
ATOM   1370  HA2 GLY A  91      19.392 -20.451   6.961  1.00  0.00           H  
ATOM   1371  HA3 GLY A  91      20.804 -19.557   6.418  1.00  0.00           H  
ATOM   1372  N   PRO A  92      22.032 -19.535   8.613  1.00  0.00           N  
ATOM   1373  CA  PRO A  92      22.838 -19.756   9.817  1.00  0.00           C  
ATOM   1374  C   PRO A  92      22.369 -18.904  10.992  1.00  0.00           C  
ATOM   1375  O   PRO A  92      22.519 -17.683  10.984  1.00  0.00           O  
ATOM   1376  CB  PRO A  92      24.246 -19.341   9.384  1.00  0.00           C  
ATOM   1377  CG  PRO A  92      24.031 -18.374   8.271  1.00  0.00           C  
ATOM   1378  CD  PRO A  92      22.786 -18.830   7.561  1.00  0.00           C  
ATOM   1379  HA  PRO A  92      22.840 -20.797  10.108  1.00  0.00           H  
ATOM   1380  HB2 PRO A  92      24.759 -18.880  10.215  1.00  0.00           H  
ATOM   1381  HB3 PRO A  92      24.794 -20.210   9.051  1.00  0.00           H  
ATOM   1382  HG2 PRO A  92      23.892 -17.380   8.670  1.00  0.00           H  
ATOM   1383  HG3 PRO A  92      24.875 -18.396   7.598  1.00  0.00           H  
ATOM   1384  HD2 PRO A  92      22.230 -17.981   7.192  1.00  0.00           H  
ATOM   1385  HD3 PRO A  92      23.037 -19.500   6.752  1.00  0.00           H  
ATOM   1386  N   SER A  93      21.802 -19.556  12.001  1.00  0.00           N  
ATOM   1387  CA  SER A  93      21.308 -18.857  13.182  1.00  0.00           C  
ATOM   1388  C   SER A  93      22.419 -18.683  14.213  1.00  0.00           C  
ATOM   1389  O   SER A  93      23.169 -19.616  14.498  1.00  0.00           O  
ATOM   1390  CB  SER A  93      20.137 -19.623  13.801  1.00  0.00           C  
ATOM   1391  OG  SER A  93      20.555 -20.885  14.291  1.00  0.00           O  
ATOM   1392  H   SER A  93      21.711 -20.531  11.948  1.00  0.00           H  
ATOM   1393  HA  SER A  93      20.965 -17.882  12.871  1.00  0.00           H  
ATOM   1394  HB2 SER A  93      19.728 -19.051  14.620  1.00  0.00           H  
ATOM   1395  HB3 SER A  93      19.374 -19.775  13.052  1.00  0.00           H  
ATOM   1396  HG  SER A  93      20.397 -20.931  15.237  1.00  0.00           H  
ATOM   1397  N   SER A  94      22.515 -17.480  14.771  1.00  0.00           N  
ATOM   1398  CA  SER A  94      23.536 -17.180  15.769  1.00  0.00           C  
ATOM   1399  C   SER A  94      22.898 -16.729  17.079  1.00  0.00           C  
ATOM   1400  O   SER A  94      23.281 -17.182  18.157  1.00  0.00           O  
ATOM   1401  CB  SER A  94      24.484 -16.097  15.250  1.00  0.00           C  
ATOM   1402  OG  SER A  94      25.552 -16.665  14.513  1.00  0.00           O  
ATOM   1403  H   SER A  94      21.887 -16.777  14.503  1.00  0.00           H  
ATOM   1404  HA  SER A  94      24.099 -18.083  15.948  1.00  0.00           H  
ATOM   1405  HB2 SER A  94      23.938 -15.422  14.608  1.00  0.00           H  
ATOM   1406  HB3 SER A  94      24.890 -15.548  16.086  1.00  0.00           H  
ATOM   1407  HG  SER A  94      26.382 -16.271  14.796  1.00  0.00           H  
ATOM   1408  N   GLY A  95      21.923 -15.832  16.977  1.00  0.00           N  
ATOM   1409  CA  GLY A  95      21.247 -15.334  18.162  1.00  0.00           C  
ATOM   1410  C   GLY A  95      22.187 -14.606  19.102  1.00  0.00           C  
ATOM   1411  O   GLY A  95      21.792 -14.204  20.197  1.00  0.00           O  
ATOM   1412  H   GLY A  95      21.659 -15.506  16.092  1.00  0.00           H  
ATOM   1413  HA2 GLY A  95      20.463 -14.657  17.857  1.00  0.00           H  
ATOM   1414  HA3 GLY A  95      20.805 -16.167  18.687  1.00  0.00           H  
TER    1415      GLY A  95                                                      
END
MOLECULE T0468.pdb
ATOM    185  N   ASP    12      -6.755 -10.308   3.985  1.00 12.21           N 
ATOM    186  CA  ASP    12      -6.859  -9.287   2.934  1.00 33.51           C 
ATOM    187  C   ASP    12      -6.284  -7.930   3.403  1.00 64.11           C 
ATOM    188  O   ASP    12      -6.983  -6.911   3.401  1.00 41.40           O 
ATOM    189  CB  ASP    12      -8.326  -9.114   2.513  1.00 35.33           C 
ATOM    190  CG  ASP    12      -8.953 -10.396   1.984  1.00 14.03           C 
ATOM    191  OD1 ASP    12      -9.635 -11.096   2.761  1.00 65.45           O 
ATOM    192  OD2 ASP    12      -8.782 -10.698   0.785  1.00 41.34           O 
ATOM    193  H   ASP    12      -7.551 -10.537   4.502  1.00 37.79           H 
ATOM    194  HA  ASP    12      -6.288  -9.627   2.080  1.00 64.25           H 
ATOM    195 1HB  ASP    12      -8.384  -8.360   1.738  1.00 37.79           H 
ATOM    196 2HB  ASP    12      -8.898  -8.782   3.367  1.00 37.79           H 
ATOM    197  N   VAL    13      -5.011  -7.923   3.803  1.00 62.31           N 
ATOM    198  CA  VAL    13      -4.353  -6.703   4.297  1.00 31.13           C 
ATOM    199  C   VAL    13      -3.027  -6.434   3.559  1.00 41.04           C 
ATOM    200  O   VAL    13      -2.209  -7.337   3.373  1.00 71.53           O 
ATOM    201  CB  VAL    13      -4.077  -6.783   5.822  1.00 63.35           C 
ATOM    202  CG1 VAL    13      -3.481  -5.472   6.340  1.00 61.54           C 
ATOM    203  CG2 VAL    13      -5.352  -7.133   6.587  1.00 52.43           C 
ATOM    204  H   VAL    13      -4.498  -8.758   3.765  1.00 37.79           H 
ATOM    205  HA  VAL    13      -5.022  -5.870   4.120  1.00  0.02           H 
ATOM    206  HB  VAL    13      -3.355  -7.571   5.993  1.00 25.11           H 
ATOM    207 1HG1 VAL    13      -4.162  -4.657   6.134  1.00 37.79           H 
ATOM    208 2HG1 VAL    13      -2.537  -5.282   5.850  1.00 37.79           H 
ATOM    209 3HG1 VAL    13      -3.320  -5.543   7.407  1.00 37.79           H 
ATOM    210 1HG2 VAL    13      -5.736  -8.080   6.234  1.00 37.79           H 
ATOM    211 2HG2 VAL    13      -6.092  -6.364   6.427  1.00 37.79           H 
ATOM    212 3HG2 VAL    13      -5.132  -7.206   7.644  1.00 37.79           H 
ATOM    213  N   TYR    14      -2.823  -5.183   3.149  1.00 60.21           N 
ATOM    214  CA  TYR    14      -1.619  -4.782   2.404  1.00 33.52           C 
ATOM    215  C   TYR    14      -0.818  -3.712   3.167  1.00 44.32           C 
ATOM    216  O   TYR    14      -1.349  -3.040   4.051  1.00 34.22           O 
ATOM    217  CB  TYR    14      -2.012  -4.255   1.014  1.00  5.31           C 
ATOM    218  CG  TYR    14      -2.644  -5.308   0.115  1.00 12.14           C 
ATOM    219  CD1 TYR    14      -3.896  -5.843   0.407  1.00 13.42           C 
ATOM    220  CD2 TYR    14      -1.988  -5.768  -1.024  1.00 24.04           C 
ATOM    221  CE1 TYR    14      -4.474  -6.800  -0.404  1.00 72.51           C 
ATOM    222  CE2 TYR    14      -2.562  -6.725  -1.841  1.00 12.41           C 
ATOM    223  CZ  TYR    14      -3.804  -7.238  -1.526  1.00 63.34           C 
ATOM    224  OH  TYR    14      -4.378  -8.190  -2.338  1.00 24.30           O 
ATOM    225  H   TYR    14      -3.502  -4.504   3.357  1.00 37.79           H 
ATOM    226  HA  TYR    14      -0.996  -5.657   2.280  1.00 31.15           H 
ATOM    227 1HB  TYR    14      -1.128  -3.877   0.517  1.00 37.79           H 
ATOM    228 2HB  TYR    14      -2.721  -3.449   1.132  1.00 37.79           H 
ATOM    229  HD1 TYR    14      -4.421  -5.498   1.288  1.00 24.25           H 
ATOM    230  HD2 TYR    14      -1.015  -5.365  -1.269  1.00 14.40           H 
ATOM    231  HE1 TYR    14      -5.445  -7.202  -0.154  1.00 12.25           H 
ATOM    232  HE2 TYR    14      -2.036  -7.068  -2.721  1.00  3.53           H 
ATOM    233  HH  TYR    14      -5.329  -8.028  -2.403  1.00 64.32           H 
ATOM    234  N   TYR    15       0.461  -3.556   2.824  1.00 14.52           N 
ATOM    235  CA  TYR    15       1.344  -2.600   3.511  1.00 60.32           C 
ATOM    236  C   TYR    15       2.191  -1.796   2.505  1.00 34.34           C 
ATOM    237  O   TYR    15       2.812  -2.366   1.616  1.00 54.44           O 
ATOM    238  CB  TYR    15       2.256  -3.353   4.493  1.00 35.11           C 
ATOM    239  CG  TYR    15       1.495  -4.238   5.469  1.00 33.22           C 
ATOM    240  CD1 TYR    15       0.989  -3.726   6.659  1.00 14.40           C 
ATOM    241  CD2 TYR    15       1.272  -5.584   5.188  1.00 63.45           C 
ATOM    242  CE1 TYR    15       0.286  -4.527   7.539  1.00 45.31           C 
ATOM    243  CE2 TYR    15       0.571  -6.390   6.063  1.00 71.42           C 
ATOM    244  CZ  TYR    15       0.081  -5.858   7.236  1.00 23.24           C 
ATOM    245  OH  TYR    15      -0.621  -6.657   8.109  1.00 31.44           O 
ATOM    246  H   TYR    15       0.827  -4.106   2.103  1.00 37.79           H 
ATOM    247  HA  TYR    15       0.722  -1.912   4.070  1.00 70.42           H 
ATOM    248 1HB  TYR    15       2.828  -2.637   5.068  1.00 37.79           H 
ATOM    249 2HB  TYR    15       2.938  -3.982   3.936  1.00 37.79           H 
ATOM    250  HD1 TYR    15       1.153  -2.684   6.895  1.00  4.31           H 
ATOM    251  HD2 TYR    15       1.659  -5.999   4.268  1.00 63.25           H 
ATOM    252  HE1 TYR    15      -0.099  -4.109   8.459  1.00 61.02           H 
ATOM    253  HE2 TYR    15       0.408  -7.430   5.825  1.00 61.22           H 
ATOM    254  HH  TYR    15      -0.212  -7.526   8.147  1.00 35.24           H 
ATOM    255  N   MET    16       2.226  -0.472   2.666  1.00 22.02           N 
ATOM    256  CA  MET    16       2.891   0.431   1.701  1.00 30.21           C 
ATOM    257  C   MET    16       3.878   1.388   2.407  1.00 20.15           C 
ATOM    258  O   MET    16       3.795   1.581   3.610  1.00 52.31           O 
ATOM    259  CB  MET    16       1.809   1.231   0.952  1.00 61.44           C 
ATOM    260  CG  MET    16       2.342   2.314   0.024  1.00 32.01           C 
ATOM    261  SD  MET    16       1.023   3.299  -0.713  1.00 14.34           S 
ATOM    262  CE  MET    16       0.182   2.063  -1.698  1.00 60.32           C 
ATOM    263  H   MET    16       1.798  -0.084   3.458  1.00 37.79           H 
ATOM    264  HA  MET    16       3.438  -0.174   0.990  1.00 52.34           H 
ATOM    265 1HB  MET    16       1.158   1.700   1.677  1.00 37.79           H 
ATOM    266 2HB  MET    16       1.223   0.543   0.359  1.00 37.79           H 
ATOM    267 1HG  MET    16       2.910   1.846  -0.767  1.00 37.79           H 
ATOM    268 2HG  MET    16       2.988   2.970   0.590  1.00 37.79           H 
ATOM    269 1HE  MET    16      -0.194   1.283  -1.054  1.00 37.79           H 
ATOM    270 2HE  MET    16       0.873   1.639  -2.412  1.00 37.79           H 
ATOM    271 3HE  MET    16      -0.641   2.524  -2.224  1.00 37.79           H 
ATOM    272  N   GLN    17       4.824   1.972   1.665  1.00  0.22           N 
ATOM    273  CA  GLN    17       5.749   2.967   2.244  1.00 71.35           C 
ATOM    274  C   GLN    17       5.752   4.280   1.434  1.00 33.21           C 
ATOM    275  O   GLN    17       5.711   4.262   0.202  1.00 31.34           O 
ATOM    276  CB  GLN    17       7.173   2.396   2.332  1.00 33.20           C 
ATOM    277  CG  GLN    17       8.157   3.304   3.072  1.00 64.35           C 
ATOM    278  CD  GLN    17       9.541   2.691   3.223  1.00 62.11           C 
ATOM    279  OE1 GLN    17       9.994   1.921   2.384  1.00 33.21           O 
ATOM    280  NE2 GLN    17      10.226   3.031   4.299  1.00 40.53           N 
ATOM    281  H   GLN    17       4.909   1.732   0.718  1.00 37.79           H 
ATOM    282  HA  GLN    17       5.404   3.189   3.247  1.00 44.40           H 
ATOM    283 1HB  GLN    17       7.547   2.235   1.330  1.00 37.79           H 
ATOM    284 2HB  GLN    17       7.135   1.446   2.848  1.00 37.79           H 
ATOM    285 1HG  GLN    17       7.762   3.508   4.059  1.00 37.79           H 
ATOM    286 2HG  GLN    17       8.250   4.232   2.528  1.00 37.79           H 
ATOM    287 1HE2 GLN    17       9.813   3.651   4.936  1.00 37.79           H 
ATOM    288 2HE2 GLN    17      11.118   2.649   4.413  1.00 37.79           H 
ATOM    289  N   ILE    18       5.808   5.415   2.137  1.00 62.45           N 
ATOM    290  CA  ILE    18       5.784   6.742   1.494  1.00 33.54           C 
ATOM    291  C   ILE    18       7.132   7.094   0.832  1.00 44.41           C 
ATOM    292  O   ILE    18       8.168   7.141   1.497  1.00  3.42           O 
ATOM    293  CB  ILE    18       5.418   7.856   2.516  1.00  1.53           C 
ATOM    294  CG1 ILE    18       4.019   7.615   3.105  1.00  4.23           C 
ATOM    295  CG2 ILE    18       5.500   9.243   1.870  1.00 14.24           C 
ATOM    296  CD1 ILE    18       2.897   7.711   2.091  1.00 14.41           C 
ATOM    297  H   ILE    18       5.870   5.361   3.115  1.00 37.79           H 
ATOM    298  HA  ILE    18       5.018   6.723   0.730  1.00 32.21           H 
ATOM    299  HB  ILE    18       6.142   7.823   3.318  1.00 52.01           H 
ATOM    300 1HG1 ILE    18       3.829   8.346   3.878  1.00 37.79           H 
ATOM    301 2HG1 ILE    18       3.985   6.627   3.539  1.00 37.79           H 
ATOM    302 1HG2 ILE    18       5.210   9.996   2.589  1.00 37.79           H 
ATOM    303 2HG2 ILE    18       4.836   9.287   1.018  1.00 37.79           H 
ATOM    304 3HG2 ILE    18       6.513   9.432   1.543  1.00 37.79           H 
ATOM    305 1HD1 ILE    18       3.054   6.985   1.308  1.00 37.79           H 
ATOM    306 2HD1 ILE    18       2.877   8.703   1.665  1.00 37.79           H 
ATOM    307 3HD1 ILE    18       1.954   7.512   2.581  1.00 37.79           H 
ATOM    308  N   LYS    19       7.103   7.347  -0.480  1.00 71.22           N 
ATOM    309  CA  LYS    19       8.312   7.732  -1.232  1.00 22.23           C 
ATOM    310  C   LYS    19       8.320   9.236  -1.572  1.00 73.33           C 
ATOM    311  O   LYS    19       9.362   9.891  -1.514  1.00 14.43           O 
ATOM    312  CB  LYS    19       8.417   6.907  -2.527  1.00 50.21           C 
ATOM    313  CG  LYS    19       9.768   7.036  -3.230  1.00 65.40           C 
ATOM    314  CD  LYS    19       9.837   6.230  -4.533  1.00 55.10           C 
ATOM    315  CE  LYS    19       9.231   6.973  -5.724  1.00  3.52           C 
ATOM    316  NZ  LYS    19       7.780   7.247  -5.552  1.00 10.24           N 
ATOM    317  H   LYS    19       6.255   7.251  -0.957  1.00 37.79           H 
ATOM    318  HA  LYS    19       9.171   7.516  -0.611  1.00  1.44           H 
ATOM    319 1HB  LYS    19       7.644   7.228  -3.212  1.00 37.79           H 
ATOM    320 2HB  LYS    19       8.260   5.864  -2.287  1.00 37.79           H 
ATOM    321 1HG  LYS    19      10.540   6.682  -2.560  1.00 37.79           H 
ATOM    322 2HG  LYS    19       9.944   8.078  -3.457  1.00 37.79           H 
ATOM    323 1HD  LYS    19       9.307   5.297  -4.396  1.00 37.79           H 
ATOM    324 2HD  LYS    19      10.873   6.020  -4.753  1.00 37.79           H 
ATOM    325 1HE  LYS    19       9.369   6.372  -6.612  1.00 37.79           H 
ATOM    326 2HE  LYS    19       9.750   7.912  -5.848  1.00 37.79           H 
ATOM    327 1HZ  LYS    19       7.274   6.371  -5.314  1.00 37.79           H 
ATOM    328 2HZ  LYS    19       7.384   7.629  -6.435  1.00 37.79           H 
ATOM    329 3HZ  LYS    19       7.631   7.943  -4.794  1.00 37.79           H 
ATOM    359  N   THR    23       2.543  14.615  -6.920  1.00 32.03           N 
ATOM    360  CA  THR    23       2.394  13.842  -8.163  1.00 40.22           C 
ATOM    361  C   THR    23       1.090  14.204  -8.894  1.00 63.53           C 
ATOM    362  O   THR    23       0.002  14.087  -8.329  1.00 51.11           O 
ATOM    363  CB  THR    23       2.399  12.319  -7.871  1.00 14.13           C 
ATOM    364  OG1 THR    23       3.550  11.969  -7.083  1.00 72.41           O 
ATOM    365  CG2 THR    23       2.398  11.503  -9.162  1.00 53.24           C 
ATOM    366  H   THR    23       1.841  14.557  -6.238  1.00 37.79           H 
ATOM    367  HA  THR    23       3.235  14.068  -8.807  1.00 31.53           H 
ATOM    368  HB  THR    23       1.507  12.074  -7.310  1.00  2.24           H 
ATOM    369  HG1 THR    23       3.398  12.237  -6.169  1.00 11.12           H 
ATOM    370 1HG2 THR    23       3.278  11.742  -9.741  1.00 37.79           H 
ATOM    371 2HG2 THR    23       1.514  11.736  -9.737  1.00 37.79           H 
ATOM    372 3HG2 THR    23       2.402  10.449  -8.921  1.00 37.79           H 
ATOM    373  N   ILE    24       1.201  14.641 -10.151  1.00 10.44           N 
ATOM    374  CA  ILE    24       0.024  15.024 -10.949  1.00 43.51           C 
ATOM    375  C   ILE    24      -0.129  14.142 -12.200  1.00 34.25           C 
ATOM    376  O   ILE    24       0.860  13.738 -12.818  1.00 53.20           O 
ATOM    377  CB  ILE    24       0.101  16.512 -11.396  1.00 23.41           C 
ATOM    378  CG1 ILE    24       0.157  17.447 -10.172  1.00 43.53           C 
ATOM    379  CG2 ILE    24      -1.085  16.875 -12.300  1.00 14.33           C 
ATOM    380  CD1 ILE    24      -1.059  17.359  -9.269  1.00 60.21           C 
ATOM    381  H   ILE    24       2.094  14.713 -10.552  1.00 37.79           H 
ATOM    382  HA  ILE    24      -0.856  14.902 -10.330  1.00 73.21           H 
ATOM    383  HB  ILE    24       1.007  16.639 -11.974  1.00  0.51           H 
ATOM    384 1HG1 ILE    24       0.244  18.470 -10.511  1.00 37.79           H 
ATOM    385 2HG1 ILE    24       1.026  17.201  -9.576  1.00 37.79           H 
ATOM    386 1HG2 ILE    24      -2.011  16.718 -11.766  1.00 37.79           H 
ATOM    387 2HG2 ILE    24      -1.074  16.253 -13.185  1.00 37.79           H 
ATOM    388 3HG2 ILE    24      -1.011  17.913 -12.596  1.00 37.79           H 
ATOM    389 1HD1 ILE    24      -1.945  17.614  -9.832  1.00 37.79           H 
ATOM    390 2HD1 ILE    24      -0.945  18.049  -8.446  1.00 37.79           H 
ATOM    391 3HD1 ILE    24      -1.153  16.354  -8.884  1.00 37.79           H 
ATOM    392  N   GLU    25      -1.372  13.839 -12.558  1.00  1.11           N 
ATOM    393  CA  GLU    25      -1.676  13.130 -13.803  1.00 31.25           C 
ATOM    394  C   GLU    25      -2.875  13.783 -14.504  1.00 53.51           C 
ATOM    395  O   GLU    25      -3.972  13.855 -13.948  1.00 71.12           O 
ATOM    396  CB  GLU    25      -1.945  11.647 -13.522  1.00 22.10           C 
ATOM    397  CG  GLU    25      -2.101  10.803 -14.782  1.00 23.14           C 
ATOM    398  CD  GLU    25      -2.106   9.312 -14.487  1.00  4.24           C 
ATOM    399  OE1 GLU    25      -1.010   8.711 -14.404  1.00 20.25           O 
ATOM    400  OE2 GLU    25      -3.199   8.733 -14.326  1.00 52.21           O 
ATOM    401  H   GLU    25      -2.112  14.090 -11.962  1.00 37.79           H 
ATOM    402  HA  GLU    25      -0.812  13.213 -14.452  1.00 20.33           H 
ATOM    403 1HB  GLU    25      -2.852  11.558 -12.939  1.00 37.79           H 
ATOM    404 2HB  GLU    25      -1.121  11.249 -12.947  1.00 37.79           H 
ATOM    405 1HG  GLU    25      -1.279  11.021 -15.451  1.00 37.79           H 
ATOM    406 2HG  GLU    25      -3.032  11.066 -15.265  1.00 37.79           H 
ATOM    407  N   LYS    26      -2.661  14.276 -15.721  1.00 23.25           N 
ATOM    408  CA  LYS    26      -3.683  15.071 -16.408  1.00 74.20           C 
ATOM    409  C   LYS    26      -4.649  14.198 -17.237  1.00 15.21           C 
ATOM    410  O   LYS    26      -4.302  13.712 -18.318  1.00 70.15           O 
ATOM    411  CB  LYS    26      -3.022  16.125 -17.313  1.00 14.51           C 
ATOM    412  CG  LYS    26      -3.924  17.325 -17.587  1.00 65.40           C 
ATOM    413  CD  LYS    26      -3.520  18.091 -18.845  1.00 41.11           C 
ATOM    414  CE  LYS    26      -2.123  18.686 -18.738  1.00 33.21           C 
ATOM    415  NZ  LYS    26      -1.794  19.513 -19.927  1.00 11.22           N 
ATOM    416  H   LYS    26      -1.804  14.102 -16.167  1.00 37.79           H 
ATOM    417  HA  LYS    26      -4.255  15.586 -15.647  1.00 70.32           H 
ATOM    418 1HB  LYS    26      -2.765  15.667 -18.258  1.00 37.79           H 
ATOM    419 2HB  LYS    26      -2.117  16.478 -16.837  1.00 37.79           H 
ATOM    420 1HG  LYS    26      -3.871  17.998 -16.741  1.00 37.79           H 
ATOM    421 2HG  LYS    26      -4.936  16.979 -17.697  1.00 37.79           H 
ATOM    422 1HD  LYS    26      -4.229  18.893 -19.006  1.00 37.79           H 
ATOM    423 2HD  LYS    26      -3.547  17.418 -19.690  1.00 37.79           H 
ATOM    424 1HE  LYS    26      -1.405  17.883 -18.659  1.00 37.79           H 
ATOM    425 2HE  LYS    26      -2.072  19.305 -17.855  1.00 37.79           H 
ATOM    426 1HZ  LYS    26      -1.791  18.925 -20.784  1.00 37.79           H 
ATOM    427 2HZ  LYS    26      -0.858  19.947 -19.814  1.00 37.79           H 
ATOM    428 3HZ  LYS    26      -2.503  20.267 -20.042  1.00 37.79           H 
ATOM    429  N   VAL    27      -5.868  14.020 -16.730  1.00 23.40           N 
ATOM    430  CA  VAL    27      -6.905  13.242 -17.423  1.00 62.43           C 
ATOM    431  C   VAL    27      -8.067  14.153 -17.862  1.00 72.24           C 
ATOM    432  O   VAL    27      -8.495  15.025 -17.104  1.00  4.24           O 
ATOM    433  CB  VAL    27      -7.450  12.112 -16.512  1.00 53.43           C 
ATOM    434  CG1 VAL    27      -8.499  11.269 -17.235  1.00 22.24           C 
ATOM    435  CG2 VAL    27      -6.308  11.235 -15.997  1.00 74.42           C 
ATOM    436  H   VAL    27      -6.080  14.423 -15.860  1.00 37.79           H 
ATOM    437  HA  VAL    27      -6.461  12.791 -18.303  1.00 34.45           H 
ATOM    438  HB  VAL    27      -7.926  12.574 -15.657  1.00 13.30           H 
ATOM    439 1HG1 VAL    27      -8.854  10.490 -16.575  1.00 37.79           H 
ATOM    440 2HG1 VAL    27      -8.061  10.821 -18.116  1.00 37.79           H 
ATOM    441 3HG1 VAL    27      -9.329  11.896 -17.527  1.00 37.79           H 
ATOM    442 1HG2 VAL    27      -6.707  10.448 -15.373  1.00 37.79           H 
ATOM    443 2HG2 VAL    27      -5.623  11.838 -15.419  1.00 37.79           H 
ATOM    444 3HG2 VAL    27      -5.781  10.796 -16.833  1.00 37.79           H 
ATOM    445  N   ASP    28      -8.568  13.953 -19.088  1.00 24.21           N 
ATOM    446  CA  ASP    28      -9.622  14.813 -19.661  1.00 52.20           C 
ATOM    447  C   ASP    28      -9.163  16.282 -19.765  1.00 20.24           C 
ATOM    448  O   ASP    28      -9.984  17.203 -19.788  1.00 13.40           O 
ATOM    449  CB  ASP    28     -10.914  14.724 -18.830  1.00 45.33           C 
ATOM    450  CG  ASP    28     -11.663  13.415 -19.025  1.00  1.24           C 
ATOM    451  OD1 ASP    28     -12.508  13.340 -19.942  1.00 21.33           O 
ATOM    452  OD2 ASP    28     -11.431  12.463 -18.252  1.00 75.30           O 
ATOM    453  H   ASP    28      -8.226  13.203 -19.623  1.00 37.79           H 
ATOM    454  HA  ASP    28      -9.826  14.452 -20.661  1.00 23.50           H 
ATOM    455 1HB  ASP    28     -11.570  15.538 -19.110  1.00 37.79           H 
ATOM    456 2HB  ASP    28     -10.665  14.821 -17.783  1.00 37.79           H 
ATOM    457  N   GLY    29      -7.852  16.491 -19.857  1.00  1.23           N 
ATOM    458  CA  GLY    29      -7.301  17.845 -19.871  1.00 25.13           C 
ATOM    459  C   GLY    29      -7.297  18.494 -18.487  1.00 70.02           C 
ATOM    460  O   GLY    29      -7.035  19.691 -18.348  1.00 71.05           O 
ATOM    461  H   GLY    29      -7.250  15.719 -19.927  1.00 37.79           H 
ATOM    462 1HA  GLY    29      -7.888  18.457 -20.542  1.00 37.79           H 
ATOM    463 2HA  GLY    29      -6.287  17.802 -20.237  1.00 37.79           H 
ATOM    464  N   ARG    30      -7.581  17.692 -17.463  1.00 63.23           N 
ATOM    465  CA  ARG    30      -7.655  18.170 -16.078  1.00 45.05           C 
ATOM    466  C   ARG    30      -6.577  17.506 -15.203  1.00 65.51           C 
ATOM    467  O   ARG    30      -6.403  16.287 -15.230  1.00 34.34           O 
ATOM    468  CB  ARG    30      -9.054  17.883 -15.513  1.00 64.14           C 
ATOM    469  CG  ARG    30     -10.169  18.599 -16.274  1.00  1.21           C 
ATOM    470  CD  ARG    30     -11.553  18.200 -15.775  1.00 74.11           C 
ATOM    471  NE  ARG    30     -11.891  16.822 -16.127  1.00 74.13           N 
ATOM    472  CZ  ARG    30     -12.425  15.962 -15.302  1.00 33.22           C 
ATOM    473  NH1 ARG    30     -12.674  16.292 -14.076  1.00  3.02           N 
ATOM    474  NH2 ARG    30     -12.725  14.774 -15.710  1.00 24.22           N 
ATOM    475  H   ARG    30      -7.748  16.743 -17.642  1.00 37.79           H 
ATOM    476  HA  ARG    30      -7.491  19.240 -16.082  1.00 64.11           H 
ATOM    477 1HB  ARG    30      -9.087  18.205 -14.481  1.00 37.79           H 
ATOM    478 2HB  ARG    30      -9.239  16.817 -15.554  1.00 37.79           H 
ATOM    479 1HG  ARG    30     -10.091  18.350 -17.324  1.00 37.79           H 
ATOM    480 2HG  ARG    30     -10.050  19.665 -16.148  1.00 37.79           H 
ATOM    481 1HD  ARG    30     -12.286  18.862 -16.215  1.00 37.79           H 
ATOM    482 2HD  ARG    30     -11.578  18.305 -14.699  1.00 37.79           H 
ATOM    483  HE  ARG    30     -11.718  16.537 -17.045  1.00 44.31           H 
ATOM    484 1HH1 ARG    30     -12.458  17.210 -13.751  1.00 37.79           H 
ATOM    485 2HH1 ARG    30     -13.075  15.621 -13.456  1.00 37.79           H 
ATOM    486 1HH2 ARG    30     -12.544  14.509 -16.651  1.00 37.79           H 
ATOM    487 2HH2 ARG    30     -13.137  14.120 -15.074  1.00 37.79           H 
ATOM    488  N   ASN    31      -5.855  18.313 -14.432  1.00  1.22           N 
ATOM    489  CA  ASN    31      -4.756  17.813 -13.598  1.00 24.12           C 
ATOM    490  C   ASN    31      -5.276  17.154 -12.309  1.00 43.30           C 
ATOM    491  O   ASN    31      -5.799  17.829 -11.419  1.00 11.01           O 
ATOM    492  CB  ASN    31      -3.803  18.961 -13.254  1.00 25.03           C 
ATOM    493  CG  ASN    31      -3.169  19.569 -14.491  1.00  0.33           C 
ATOM    494  OD1 ASN    31      -3.727  20.468 -15.110  1.00 63.32           O 
ATOM    495  ND2 ASN    31      -2.002  19.083 -14.868  1.00 75.00           N 
ATOM    496  H   ASN    31      -6.069  19.270 -14.412  1.00 37.79           H 
ATOM    497  HA  ASN    31      -4.214  17.074 -14.173  1.00 14.35           H 
ATOM    498 1HB  ASN    31      -3.018  18.594 -12.608  1.00 37.79           H 
ATOM    499 2HB  ASN    31      -4.354  19.735 -12.738  1.00 37.79           H 
ATOM    500 1HD2 ASN    31      -1.604  18.362 -14.341  1.00 37.79           H 
ATOM    501 2HD2 ASN    31      -1.575  19.479 -15.657  1.00 37.79           H 
ATOM    502  N   LEU    32      -5.141  15.831 -12.225  1.00 74.42           N 
ATOM    503  CA  LEU    32      -5.543  15.078 -11.030  1.00 50.01           C 
ATOM    504  C   LEU    32      -4.350  14.865 -10.085  1.00 63.41           C 
ATOM    505  O   LEU    32      -3.212  14.721 -10.530  1.00 24.31           O 
ATOM    506  CB  LEU    32      -6.141  13.722 -11.433  1.00 53.15           C 
ATOM    507  CG  LEU    32      -7.352  13.794 -12.381  1.00 22.11           C 
ATOM    508  CD1 LEU    32      -7.854  12.395 -12.724  1.00 35.54           C 
ATOM    509  CD2 LEU    32      -8.474  14.633 -11.769  1.00 34.41           C 
ATOM    510  H   LEU    32      -4.767  15.343 -12.990  1.00 37.79           H 
ATOM    511  HA  LEU    32      -6.299  15.653 -10.509  1.00 74.20           H 
ATOM    512 1HB  LEU    32      -6.447  13.205 -10.533  1.00 37.79           H 
ATOM    513 2HB  LEU    32      -5.366  13.139 -11.914  1.00 37.79           H 
ATOM    514  HG  LEU    32      -7.046  14.269 -13.302  1.00 73.44           H 
ATOM    515 1HD1 LEU    32      -8.698  12.470 -13.396  1.00 37.79           H 
ATOM    516 2HD1 LEU    32      -8.159  11.887 -11.820  1.00 37.79           H 
ATOM    517 3HD1 LEU    32      -7.063  11.835 -13.202  1.00 37.79           H 
ATOM    518 1HD2 LEU    32      -8.116  15.636 -11.584  1.00 37.79           H 
ATOM    519 2HD2 LEU    32      -8.793  14.189 -10.838  1.00 37.79           H 
ATOM    520 3HD2 LEU    32      -9.311  14.672 -12.454  1.00 37.79           H 
ATOM    521  N   ARG    33      -4.617  14.855  -8.783  1.00 23.22           N 
ATOM    522  CA  ARG    33      -3.567  14.659  -7.775  1.00 62.34           C 
ATOM    523  C   ARG    33      -3.680  13.266  -7.131  1.00 41.45           C 
ATOM    524  O   ARG    33      -4.560  13.023  -6.302  1.00 55.31           O 
ATOM    525  CB  ARG    33      -3.672  15.757  -6.702  1.00  0.52           C 
ATOM    526  CG  ARG    33      -2.536  15.761  -5.681  1.00 63.32           C 
ATOM    527  CD  ARG    33      -2.727  16.864  -4.642  1.00 45.22           C 
ATOM    528  NE  ARG    33      -1.581  16.987  -3.743  1.00  0.41           N 
ATOM    529  CZ  ARG    33      -1.532  17.804  -2.724  1.00 64.12           C 
ATOM    530  NH1 ARG    33      -2.559  18.521  -2.392  1.00 31.31           N 
ATOM    531  NH2 ARG    33      -0.456  17.885  -2.021  1.00 33.22           N 
ATOM    532  H   ARG    33      -5.544  14.990  -8.485  1.00 37.79           H 
ATOM    533  HA  ARG    33      -2.607  14.740  -8.269  1.00 24.55           H 
ATOM    534 1HB  ARG    33      -4.604  15.629  -6.169  1.00 37.79           H 
ATOM    535 2HB  ARG    33      -3.683  16.719  -7.195  1.00 37.79           H 
ATOM    536 1HG  ARG    33      -1.599  15.923  -6.198  1.00 37.79           H 
ATOM    537 2HG  ARG    33      -2.509  14.805  -5.177  1.00 37.79           H 
ATOM    538 1HD  ARG    33      -3.609  16.641  -4.058  1.00 37.79           H 
ATOM    539 2HD  ARG    33      -2.869  17.804  -5.156  1.00 37.79           H 
ATOM    540  HE  ARG    33      -0.795  16.437  -3.930  1.00 73.45           H 
ATOM    541 1HH1 ARG    33      -3.405  18.456  -2.916  1.00 37.79           H 
ATOM    542 2HH1 ARG    33      -2.501  19.134  -1.608  1.00 37.79           H 
ATOM    543 1HH2 ARG    33       0.337  17.323  -2.256  1.00 37.79           H 
ATOM    544 2HH2 ARG    33      -0.410  18.511  -1.247  1.00 37.79           H 
ATOM    545  N   ASN    34      -2.787  12.354  -7.517  1.00 10.04           N 
ATOM    546  CA  ASN    34      -2.822  10.967  -7.029  1.00 60.55           C 
ATOM    547  C   ASN    34      -1.435  10.491  -6.569  1.00  4.14           C 
ATOM    548  O   ASN    34      -0.415  11.062  -6.944  1.00  5.43           O 
ATOM    549  CB  ASN    34      -3.363  10.038  -8.125  1.00 44.12           C 
ATOM    550  CG  ASN    34      -2.622  10.199  -9.441  1.00 55.23           C 
ATOM    551  OD1 ASN    34      -3.003  10.999 -10.285  1.00 41.25           O 
ATOM    552  ND2 ASN    34      -1.556   9.444  -9.632  1.00 15.13           N 
ATOM    553  H   ASN    34      -2.080  12.618  -8.145  1.00 37.79           H 
ATOM    554  HA  ASN    34      -3.493  10.931  -6.181  1.00 11.21           H 
ATOM    555 1HB  ASN    34      -4.408  10.260  -8.292  1.00 37.79           H 
ATOM    556 2HB  ASN    34      -3.269   9.011  -7.801  1.00 37.79           H 
ATOM    557 1HD2 ASN    34      -1.291   8.823  -8.926  1.00 37.79           H 
ATOM    558 2HD2 ASN    34      -1.071   9.544 -10.480  1.00 37.79           H 
ATOM    559  N   TYR    35      -1.408   9.434  -5.759  1.00 15.25           N 
ATOM    560  CA  TYR    35      -0.150   8.884  -5.231  1.00  3.43           C 
ATOM    561  C   TYR    35       0.005   7.400  -5.604  1.00 30.03           C 
ATOM    562  O   TYR    35      -0.857   6.585  -5.281  1.00 62.53           O 
ATOM    563  CB  TYR    35      -0.117   9.028  -3.701  1.00 63.03           C 
ATOM    564  CG  TYR    35      -0.377  10.440  -3.205  1.00 12.25           C 
ATOM    565  CD1 TYR    35       0.674  11.289  -2.878  1.00 33.22           C 
ATOM    566  CD2 TYR    35      -1.677  10.921  -3.066  1.00 63.23           C 
ATOM    567  CE1 TYR    35       0.436  12.573  -2.427  1.00 75.25           C 
ATOM    568  CE2 TYR    35      -1.920  12.204  -2.617  1.00 73.00           C 
ATOM    569  CZ  TYR    35      -0.861  13.025  -2.300  1.00 71.53           C 
ATOM    570  OH  TYR    35      -1.100  14.303  -1.852  1.00 55.24           O 
ATOM    571  H   TYR    35      -2.256   9.012  -5.500  1.00 37.79           H 
ATOM    572  HA  TYR    35       0.671   9.444  -5.656  1.00 61.12           H 
ATOM    573 1HB  TYR    35       0.857   8.722  -3.342  1.00 37.79           H 
ATOM    574 2HB  TYR    35      -0.869   8.383  -3.270  1.00 37.79           H 
ATOM    575  HD1 TYR    35       1.690  10.934  -2.979  1.00 35.33           H 
ATOM    576  HD2 TYR    35      -2.506  10.275  -3.315  1.00 44.14           H 
ATOM    577  HE1 TYR    35       1.266  13.219  -2.179  1.00 61.01           H 
ATOM    578  HE2 TYR    35      -2.935  12.559  -2.517  1.00 44.11           H 
ATOM    579  HH  TYR    35      -0.428  14.897  -2.208  1.00 72.13           H 
ATOM    580  N   THR    36       1.110   7.054  -6.270  1.00 22.23           N 
ATOM    581  CA  THR    36       1.389   5.657  -6.657  1.00 51.14           C 
ATOM    582  C   THR    36       2.623   5.121  -5.921  1.00 72.41           C 
ATOM    583  O   THR    36       3.748   5.569  -6.163  1.00 25.03           O 
ATOM    584  CB  THR    36       1.619   5.525  -8.185  1.00 44.31           C 
ATOM    585  OG1 THR    36       0.479   6.024  -8.906  1.00  3.35           O 
ATOM    586  CG2 THR    36       1.874   4.072  -8.588  1.00 72.20           C 
ATOM    587  H   THR    36       1.756   7.751  -6.511  1.00 37.79           H 
ATOM    588  HA  THR    36       0.531   5.053  -6.390  1.00 55.14           H 
ATOM    589  HB  THR    36       2.486   6.113  -8.456  1.00 15.33           H 
ATOM    590  HG1 THR    36      -0.252   5.399  -8.820  1.00 22.04           H 
ATOM    591 1HG2 THR    36       1.035   3.461  -8.289  1.00 37.79           H 
ATOM    592 2HG2 THR    36       2.771   3.714  -8.103  1.00 37.79           H 
ATOM    593 3HG2 THR    36       1.998   4.011  -9.660  1.00 37.79           H 
ATOM    594  N   LEU    37       2.416   4.162  -5.026  1.00 70.25           N 
ATOM    595  CA  LEU    37       3.502   3.641  -4.187  1.00 40.24           C 
ATOM    596  C   LEU    37       3.529   2.100  -4.162  1.00 10.10           C 
ATOM    597  O   LEU    37       2.503   1.444  -4.367  1.00 75.41           O 
ATOM    598  CB  LEU    37       3.359   4.184  -2.758  1.00 13.44           C 
ATOM    599  CG  LEU    37       3.492   5.710  -2.607  1.00 33.22           C 
ATOM    600  CD1 LEU    37       3.225   6.140  -1.168  1.00 74.33           C 
ATOM    601  CD2 LEU    37       4.873   6.172  -3.056  1.00 22.54           C 
ATOM    602  H   LEU    37       1.511   3.790  -4.924  1.00 37.79           H 
ATOM    603  HA  LEU    37       4.436   3.994  -4.600  1.00 20.12           H 
ATOM    604 1HB  LEU    37       4.116   3.718  -2.143  1.00 37.79           H 
ATOM    605 2HB  LEU    37       2.388   3.891  -2.384  1.00 37.79           H 
ATOM    606  HG  LEU    37       2.758   6.193  -3.238  1.00  3.32           H 
ATOM    607 1HD1 LEU    37       2.228   5.839  -0.880  1.00 37.79           H 
ATOM    608 2HD1 LEU    37       3.310   7.215  -1.089  1.00 37.79           H 
ATOM    609 3HD1 LEU    37       3.945   5.673  -0.510  1.00 37.79           H 
ATOM    610 1HD2 LEU    37       4.951   7.243  -2.936  1.00 37.79           H 
ATOM    611 2HD2 LEU    37       5.016   5.918  -4.096  1.00 37.79           H 
ATOM    612 3HD2 LEU    37       5.630   5.686  -2.459  1.00 37.79           H 
ATOM    613  N   PRO    38       4.717   1.502  -3.917  1.00 45.52           N 
ATOM    614  CA  PRO    38       4.864   0.044  -3.793  1.00 72.33           C 
ATOM    615  C   PRO    38       4.266  -0.500  -2.484  1.00 23.45           C 
ATOM    616  O   PRO    38       4.337   0.143  -1.434  1.00 11.12           O 
ATOM    617  CB  PRO    38       6.393  -0.179  -3.822  1.00 10.41           C 
ATOM    618  CG  PRO    38       6.988   1.140  -4.208  1.00 72.03           C 
ATOM    619  CD  PRO    38       6.009   2.186  -3.755  1.00  0.25           C 
ATOM    620  HA  PRO    38       4.407  -0.467  -4.630  1.00 23.21           H 
ATOM    621 1HB  PRO    38       6.631  -0.943  -4.548  1.00 37.79           H 
ATOM    622 2HB  PRO    38       6.736  -0.495  -2.845  1.00 37.79           H 
ATOM    623 1HG  PRO    38       7.118   1.187  -5.280  1.00 37.79           H 
ATOM    624 2HG  PRO    38       7.940   1.276  -3.711  1.00 37.79           H 
ATOM    625 1HD  PRO    38       6.066   3.062  -4.386  1.00 37.79           H 
ATOM    626 2HD  PRO    38       6.184   2.450  -2.721  1.00 37.79           H 
ATOM    627  N   ALA    39       3.684  -1.691  -2.550  1.00 72.41           N 
ATOM    628  CA  ALA    39       3.067  -2.316  -1.380  1.00 65.43           C 
ATOM    629  C   ALA    39       3.434  -3.804  -1.272  1.00 60.21           C 
ATOM    630  O   ALA    39       4.017  -4.379  -2.184  1.00  2.30           O 
ATOM    631  CB  ALA    39       1.552  -2.146  -1.436  1.00 22.12           C 
ATOM    632  H   ALA    39       3.669  -2.165  -3.406  1.00 37.79           H 
ATOM    633  HA  ALA    39       3.429  -1.805  -0.498  1.00 43.35           H 
ATOM    634 1HB  ALA    39       1.157  -2.695  -2.280  1.00 37.79           H 
ATOM    635 2HB  ALA    39       1.310  -1.100  -1.545  1.00 37.79           H 
ATOM    636 3HB  ALA    39       1.111  -2.523  -0.523  1.00 37.79           H 
ATOM    637  N   TYR    40       3.103  -4.410  -0.139  1.00  4.15           N 
ATOM    638  CA  TYR    40       3.288  -5.850   0.074  1.00 14.44           C 
ATOM    639  C   TYR    40       2.104  -6.416   0.866  1.00 55.05           C 
ATOM    640  O   TYR    40       1.624  -5.782   1.804  1.00 30.21           O 
ATOM    641  CB  TYR    40       4.591  -6.133   0.843  1.00 74.11           C 
ATOM    642  CG  TYR    40       5.861  -5.700   0.127  1.00 71.00           C 
ATOM    643  CD1 TYR    40       6.502  -6.545  -0.771  1.00  5.20           C 
ATOM    644  CD2 TYR    40       6.424  -4.449   0.360  1.00 44.35           C 
ATOM    645  CE1 TYR    40       7.665  -6.158  -1.411  1.00 70.40           C 
ATOM    646  CE2 TYR    40       7.583  -4.055  -0.279  1.00  3.13           C 
ATOM    647  CZ  TYR    40       8.200  -4.913  -1.163  1.00 63.23           C 
ATOM    648  OH  TYR    40       9.362  -4.525  -1.795  1.00  0.11           O 
ATOM    649  H   TYR    40       2.729  -3.873   0.589  1.00 37.79           H 
ATOM    650  HA  TYR    40       3.330  -6.333  -0.893  1.00 12.13           H 
ATOM    651 1HB  TYR    40       4.663  -7.196   1.028  1.00 37.79           H 
ATOM    652 2HB  TYR    40       4.558  -5.616   1.792  1.00 37.79           H 
ATOM    653  HD1 TYR    40       6.081  -7.521  -0.966  1.00 34.11           H 
ATOM    654  HD2 TYR    40       5.939  -3.777   1.052  1.00  3.43           H 
ATOM    655  HE1 TYR    40       8.148  -6.831  -2.106  1.00 64.21           H 
ATOM    656  HE2 TYR    40       8.002  -3.079  -0.082  1.00 63.34           H 
ATOM    657  HH  TYR    40       9.992  -4.201  -1.134  1.00 52.13           H 
ATOM    658  N   ASP    41       1.621  -7.596   0.488  1.00 62.41           N 
ATOM    659  CA  ASP    41       0.554  -8.257   1.249  1.00 12.34           C 
ATOM    660  C   ASP    41       1.129  -8.976   2.482  1.00 40.34           C 
ATOM    661  O   ASP    41       2.339  -8.955   2.711  1.00 41.12           O 
ATOM    662  CB  ASP    41      -0.205  -9.243   0.355  1.00  0.33           C 
ATOM    663  CG  ASP    41       0.729 -10.207  -0.345  1.00 44.31           C 
ATOM    664  OD1 ASP    41       1.129  -9.917  -1.488  1.00 64.42           O 
ATOM    665  OD2 ASP    41       1.079 -11.246   0.251  1.00 21.52           O 
ATOM    666  H   ASP    41       1.986  -8.036  -0.312  1.00 37.79           H 
ATOM    667  HA  ASP    41      -0.133  -7.490   1.588  1.00 23.42           H 
ATOM    668 1HB  ASP    41      -0.760  -8.693  -0.393  1.00 37.79           H 
ATOM    669 2HB  ASP    41      -0.898  -9.812   0.961  1.00 37.79           H 
ATOM    670  N   GLU    42       0.264  -9.619   3.265  1.00 33.43           N 
ATOM    671  CA  GLU    42       0.686 -10.302   4.497  1.00 30.03           C 
ATOM    672  C   GLU    42       1.770 -11.373   4.238  1.00 44.33           C 
ATOM    673  O   GLU    42       2.614 -11.632   5.101  1.00  1.33           O 
ATOM    674  CB  GLU    42      -0.529 -10.929   5.199  1.00 31.13           C 
ATOM    675  CG  GLU    42      -0.197 -11.581   6.539  1.00 41.33           C 
ATOM    676  CD  GLU    42      -1.431 -12.061   7.288  1.00 40.40           C 
ATOM    677  OE1 GLU    42      -1.845 -11.389   8.255  1.00 71.24           O 
ATOM    678  OE2 GLU    42      -1.990 -13.113   6.913  1.00  3.14           O 
ATOM    679  H   GLU    42      -0.684  -9.624   3.020  1.00 37.79           H 
ATOM    680  HA  GLU    42       1.108  -9.551   5.152  1.00 54.42           H 
ATOM    681 1HB  GLU    42      -0.958 -11.681   4.552  1.00 37.79           H 
ATOM    682 2HB  GLU    42      -1.265 -10.156   5.373  1.00 37.79           H 
ATOM    683 1HG  GLU    42       0.324 -10.859   7.154  1.00 37.79           H 
ATOM    684 2HG  GLU    42       0.450 -12.429   6.362  1.00 37.79           H 
ATOM    685  N   ASP    43       1.760 -11.981   3.051  1.00 10.21           N 
ATOM    686  CA  ASP    43       2.767 -12.993   2.700  1.00 33.34           C 
ATOM    687  C   ASP    43       4.076 -12.326   2.227  1.00 40.05           C 
ATOM    688  O   ASP    43       5.127 -12.968   2.153  1.00 61.13           O 
ATOM    689  CB  ASP    43       2.217 -13.940   1.623  1.00 11.54           C 
ATOM    690  CG  ASP    43       3.161 -15.093   1.316  1.00 51.55           C 
ATOM    691  OD1 ASP    43       3.563 -15.803   2.261  1.00 45.42           O 
ATOM    692  OD2 ASP    43       3.492 -15.308   0.129  1.00 43.34           O 
ATOM    693  H   ASP    43       1.073 -11.743   2.394  1.00 37.79           H 
ATOM    694  HA  ASP    43       2.979 -13.567   3.593  1.00 20.33           H 
ATOM    695 1HB  ASP    43       2.049 -13.380   0.713  1.00 37.79           H 
ATOM    696 2HB  ASP    43       1.277 -14.352   1.962  1.00 37.79           H 
ATOM    697  N   GLY    44       4.004 -11.035   1.912  1.00 12.42           N 
ATOM    698  CA  GLY    44       5.191 -10.275   1.530  1.00 42.21           C 
ATOM    699  C   GLY    44       5.411 -10.188   0.022  1.00 44.44           C 
ATOM    700  O   GLY    44       6.471  -9.749  -0.430  1.00 65.25           O 
ATOM    701  H   GLY    44       3.132 -10.587   1.946  1.00 37.79           H 
ATOM    702 1HA  GLY    44       6.059 -10.735   1.980  1.00 37.79           H 
ATOM    703 2HA  GLY    44       5.095  -9.272   1.919  1.00 37.79           H 
ATOM    704  N   VAL    45       4.420 -10.600  -0.765  1.00 43.22           N 
ATOM    705  CA  VAL    45       4.533 -10.536  -2.227  1.00  2.11           C 
ATOM    706  C   VAL    45       4.348  -9.093  -2.724  1.00  0.42           C 
ATOM    707  O   VAL    45       3.403  -8.407  -2.331  1.00 64.13           O 
ATOM    708  CB  VAL    45       3.504 -11.462  -2.920  1.00 34.25           C 
ATOM    709  CG1 VAL    45       3.731 -11.503  -4.430  1.00 53.21           C 
ATOM    710  CG2 VAL    45       3.555 -12.864  -2.319  1.00 25.44           C 
ATOM    711  H   VAL    45       3.598 -10.949  -0.359  1.00 37.79           H 
ATOM    712  HA  VAL    45       5.528 -10.874  -2.496  1.00 53.41           H 
ATOM    713  HB  VAL    45       2.516 -11.059  -2.743  1.00 55.33           H 
ATOM    714 1HG1 VAL    45       3.597 -10.513  -4.841  1.00 37.79           H 
ATOM    715 2HG1 VAL    45       3.019 -12.179  -4.884  1.00 37.79           H 
ATOM    716 3HG1 VAL    45       4.734 -11.846  -4.637  1.00 37.79           H 
ATOM    717 1HG2 VAL    45       4.545 -13.276  -2.443  1.00 37.79           H 
ATOM    718 2HG2 VAL    45       2.836 -13.498  -2.820  1.00 37.79           H 
ATOM    719 3HG2 VAL    45       3.314 -12.813  -1.266  1.00 37.79           H 
ATOM    720  N   LYS    46       5.247  -8.640  -3.596  1.00 54.35           N 
ATOM    721  CA  LYS    46       5.262  -7.241  -4.027  1.00 10.30           C 
ATOM    722  C   LYS    46       3.981  -6.838  -4.779  1.00  5.11           C 
ATOM    723  O   LYS    46       3.448  -7.593  -5.594  1.00 22.04           O 
ATOM    724  CB  LYS    46       6.490  -6.958  -4.898  1.00 70.52           C 
ATOM    725  CG  LYS    46       6.629  -5.487  -5.273  1.00 32.21           C 
ATOM    726  CD  LYS    46       7.899  -5.207  -6.068  1.00 52.33           C 
ATOM    727  CE  LYS    46       8.023  -3.728  -6.407  1.00 24.42           C 
ATOM    728  NZ  LYS    46       9.285  -3.420  -7.127  1.00 32.13           N 
ATOM    729  H   LYS    46       5.913  -9.259  -3.959  1.00 37.79           H 
ATOM    730  HA  LYS    46       5.335  -6.635  -3.134  1.00 55.44           H 
ATOM    731 1HB  LYS    46       6.412  -7.534  -5.808  1.00 37.79           H 
ATOM    732 2HB  LYS    46       7.380  -7.264  -4.363  1.00 37.79           H 
ATOM    733 1HG  LYS    46       6.643  -4.896  -4.367  1.00 37.79           H 
ATOM    734 2HG  LYS    46       5.775  -5.199  -5.873  1.00 37.79           H 
ATOM    735 1HD  LYS    46       7.870  -5.774  -6.988  1.00 37.79           H 
ATOM    736 2HD  LYS    46       8.758  -5.508  -5.484  1.00 37.79           H 
ATOM    737 1HE  LYS    46       7.992  -3.155  -5.491  1.00 37.79           H 
ATOM    738 2HE  LYS    46       7.189  -3.444  -7.033  1.00 37.79           H 
ATOM    739 1HZ  LYS    46      10.105  -3.689  -6.547  1.00 37.79           H 
ATOM    740 2HZ  LYS    46       9.341  -2.403  -7.337  1.00 37.79           H 
ATOM    741 3HZ  LYS    46       9.321  -3.945  -8.021  1.00 37.79           H 
ATOM    742  N   LYS    47       3.507  -5.633  -4.485  1.00 65.11           N 
ATOM    743  CA  LYS    47       2.312  -5.055  -5.106  1.00 12.42           C 
ATOM    744  C   LYS    47       2.574  -3.587  -5.473  1.00 60.21           C 
ATOM    745  O   LYS    47       3.574  -3.002  -5.049  1.00 74.33           O 
ATOM    746  CB  LYS    47       1.117  -5.133  -4.136  1.00  2.20           C 
ATOM    747  CG  LYS    47       0.718  -6.551  -3.730  1.00 54.23           C 
ATOM    748  CD  LYS    47       0.148  -7.342  -4.903  1.00 44.32           C 
ATOM    749  CE  LYS    47      -0.235  -8.762  -4.495  1.00 52.11           C 
ATOM    750  NZ  LYS    47       0.940  -9.549  -4.035  1.00 24.05           N 
ATOM    751  H   LYS    47       3.986  -5.098  -3.821  1.00 37.79           H 
ATOM    752  HA  LYS    47       2.084  -5.609  -6.005  1.00 25.00           H 
ATOM    753 1HB  LYS    47       0.261  -4.660  -4.600  1.00 37.79           H 
ATOM    754 2HB  LYS    47       1.368  -4.588  -3.236  1.00 37.79           H 
ATOM    755 1HG  LYS    47      -0.029  -6.494  -2.949  1.00 37.79           H 
ATOM    756 2HG  LYS    47       1.592  -7.066  -3.354  1.00 37.79           H 
ATOM    757 1HD  LYS    47       0.891  -7.390  -5.688  1.00 37.79           H 
ATOM    758 2HD  LYS    47      -0.733  -6.835  -5.273  1.00 37.79           H 
ATOM    759 1HE  LYS    47      -0.679  -9.261  -5.347  1.00 37.79           H 
ATOM    760 2HE  LYS    47      -0.958  -8.712  -3.694  1.00 37.79           H 
ATOM    761 1HZ  LYS    47       1.355  -9.114  -3.181  1.00 37.79           H 
ATOM    762 2HZ  LYS    47       1.663  -9.584  -4.779  1.00 37.79           H 
ATOM    763 3HZ  LYS    47       0.651 -10.520  -3.803  1.00 37.79           H 
ATOM    764  N   GLN    48       1.687  -2.994  -6.262  1.00 41.13           N 
ATOM    765  CA  GLN    48       1.772  -1.563  -6.575  1.00 14.12           C 
ATOM    766  C   GLN    48       0.375  -0.925  -6.557  1.00 12.32           C 
ATOM    767  O   GLN    48      -0.478  -1.255  -7.380  1.00  3.41           O 
ATOM    768  CB  GLN    48       2.450  -1.343  -7.935  1.00 72.20           C 
ATOM    769  CG  GLN    48       2.762   0.122  -8.229  1.00 42.23           C 
ATOM    770  CD  GLN    48       3.547   0.309  -9.513  1.00 13.05           C 
ATOM    771  OE1 GLN    48       4.777   0.300  -9.512  1.00 73.54           O 
ATOM    772  NE2 GLN    48       2.849   0.479 -10.616  1.00 31.21           N 
ATOM    773  H   GLN    48       0.958  -3.527  -6.648  1.00 37.79           H 
ATOM    774  HA  GLN    48       2.374  -1.094  -5.806  1.00 52.12           H 
ATOM    775 1HB  GLN    48       1.800  -1.716  -8.714  1.00 37.79           H 
ATOM    776 2HB  GLN    48       3.377  -1.900  -7.957  1.00 37.79           H 
ATOM    777 1HG  GLN    48       3.339   0.527  -7.410  1.00 37.79           H 
ATOM    778 2HG  GLN    48       1.831   0.666  -8.312  1.00 37.79           H 
ATOM    779 1HE2 GLN    48       1.875   0.470 -10.553  1.00 37.79           H 
ATOM    780 2HE2 GLN    48       3.339   0.619 -11.452  1.00 37.79           H 
ATOM    781  N   ILE    49       0.146  -0.011  -5.615  1.00 63.01           N 
ATOM    782  CA  ILE    49      -1.192   0.556  -5.398  1.00 42.34           C 
ATOM    783  C   ILE    49      -1.189   2.093  -5.480  1.00 34.32           C 
ATOM    784  O   ILE    49      -0.243   2.753  -5.045  1.00 62.45           O 
ATOM    785  CB  ILE    49      -1.758   0.108  -4.020  1.00 22.44           C 
ATOM    786  CG1 ILE    49      -1.835  -1.429  -3.946  1.00 34.13           C 
ATOM    787  CG2 ILE    49      -3.131   0.734  -3.753  1.00 42.50           C 
ATOM    788  CD1 ILE    49      -2.295  -1.962  -2.604  1.00 41.43           C 
ATOM    789  H   ILE    49       0.894   0.298  -5.057  1.00 37.79           H 
ATOM    790  HA  ILE    49      -1.847   0.171  -6.171  1.00 72.51           H 
ATOM    791  HB  ILE    49      -1.081   0.458  -3.254  1.00 74.33           H 
ATOM    792 1HG1 ILE    49      -0.855  -1.840  -4.145  1.00 37.79           H 
ATOM    793 2HG1 ILE    49      -2.526  -1.786  -4.694  1.00 37.79           H 
ATOM    794 1HG2 ILE    49      -3.499   0.399  -2.795  1.00 37.79           H 
ATOM    795 2HG2 ILE    49      -3.823   0.438  -4.528  1.00 37.79           H 
ATOM    796 3HG2 ILE    49      -3.042   1.812  -3.745  1.00 37.79           H 
ATOM    797 1HD1 ILE    49      -1.606  -1.646  -1.834  1.00 37.79           H 
ATOM    798 2HD1 ILE    49      -2.324  -3.041  -2.638  1.00 37.79           H 
ATOM    799 3HD1 ILE    49      -3.282  -1.582  -2.382  1.00 37.79           H 
ATOM    800  N   THR    50      -2.260   2.650  -6.049  1.00 12.32           N 
ATOM    801  CA  THR    50      -2.417   4.108  -6.182  1.00 23.40           C 
ATOM    802  C   THR    50      -3.593   4.624  -5.336  1.00 43.22           C 
ATOM    803  O   THR    50      -4.733   4.196  -5.519  1.00  1.20           O 
ATOM    804  CB  THR    50      -2.647   4.521  -7.662  1.00 13.23           C 
ATOM    805  OG1 THR    50      -1.533   4.108  -8.468  1.00 53.32           O 
ATOM    806  CG2 THR    50      -2.837   6.033  -7.801  1.00 70.42           C 
ATOM    807  H   THR    50      -2.967   2.066  -6.393  1.00 37.79           H 
ATOM    808  HA  THR    50      -1.505   4.578  -5.837  1.00 33.34           H 
ATOM    809  HB  THR    50      -3.540   4.027  -8.023  1.00 52.11           H 
ATOM    810  HG1 THR    50      -1.832   3.953  -9.375  1.00 21.21           H 
ATOM    811 1HG2 THR    50      -2.995   6.283  -8.842  1.00 37.79           H 
ATOM    812 2HG2 THR    50      -1.957   6.544  -7.440  1.00 37.79           H 
ATOM    813 3HG2 THR    50      -3.695   6.342  -7.222  1.00 37.79           H 
ATOM    814  N   PHE    51      -3.313   5.548  -4.417  1.00 61.31           N 
ATOM    815  CA  PHE    51      -4.349   6.121  -3.544  1.00 61.02           C 
ATOM    816  C   PHE    51      -4.439   7.651  -3.699  1.00  3.32           C 
ATOM    817  O   PHE    51      -3.613   8.272  -4.370  1.00 14.14           O 
ATOM    818  CB  PHE    51      -4.083   5.752  -2.072  1.00  2.33           C 
ATOM    819  CG  PHE    51      -2.799   6.319  -1.506  1.00 44.42           C 
ATOM    820  CD1 PHE    51      -1.578   5.704  -1.753  1.00 41.41           C 
ATOM    821  CD2 PHE    51      -2.818   7.465  -0.719  1.00 23.55           C 
ATOM    822  CE1 PHE    51      -0.407   6.223  -1.232  1.00 12.42           C 
ATOM    823  CE2 PHE    51      -1.649   7.986  -0.197  1.00 30.20           C 
ATOM    824  CZ  PHE    51      -0.444   7.364  -0.452  1.00 12.21           C 
ATOM    825  H   PHE    51      -2.387   5.859  -4.324  1.00 37.79           H 
ATOM    826  HA  PHE    51      -5.299   5.697  -3.839  1.00 75.34           H 
ATOM    827 1HB  PHE    51      -4.039   4.675  -1.984  1.00 37.79           H 
ATOM    828 2HB  PHE    51      -4.901   6.117  -1.466  1.00 37.79           H 
ATOM    829  HD1 PHE    51      -1.547   4.812  -2.363  1.00 53.43           H 
ATOM    830  HD2 PHE    51      -3.761   7.954  -0.517  1.00 71.12           H 
ATOM    831  HE1 PHE    51       0.535   5.734  -1.430  1.00 24.20           H 
ATOM    832  HE2 PHE    51      -1.679   8.879   0.411  1.00 10.11           H 
ATOM    833  HZ  PHE    51       0.471   7.770  -0.044  1.00 51.34           H 
ATOM    834  N   ARG    52      -5.451   8.250  -3.073  1.00 14.43           N 
ATOM    835  CA  ARG    52      -5.648   9.703  -3.126  1.00 61.04           C 
ATOM    836  C   ARG    52      -6.253  10.226  -1.813  1.00 60.55           C 
ATOM    837  O   ARG    52      -6.974   9.505  -1.120  1.00 50.23           O 
ATOM    838  CB  ARG    52      -6.553  10.078  -4.314  1.00 11.20           C 
ATOM    839  CG  ARG    52      -6.758  11.583  -4.487  1.00 12.44           C 
ATOM    840  CD  ARG    52      -7.656  11.902  -5.677  1.00 33.42           C 
ATOM    841  NE  ARG    52      -8.997  11.343  -5.518  1.00 12.14           N 
ATOM    842  CZ  ARG    52      -9.762  10.979  -6.509  1.00 71.40           C 
ATOM    843  NH1 ARG    52      -9.366  11.120  -7.735  1.00  2.21           N 
ATOM    844  NH2 ARG    52     -10.926  10.479  -6.271  1.00 34.31           N 
ATOM    845  H   ARG    52      -6.080   7.704  -2.560  1.00 37.79           H 
ATOM    846  HA  ARG    52      -4.680  10.165  -3.264  1.00 31.44           H 
ATOM    847 1HB  ARG    52      -7.521   9.617  -4.174  1.00 37.79           H 
ATOM    848 2HB  ARG    52      -6.110   9.692  -5.221  1.00 37.79           H 
ATOM    849 1HG  ARG    52      -5.796  12.053  -4.638  1.00 37.79           H 
ATOM    850 2HG  ARG    52      -7.214  11.979  -3.591  1.00 37.79           H 
ATOM    851 1HD  ARG    52      -7.206  11.491  -6.572  1.00 37.79           H 
ATOM    852 2HD  ARG    52      -7.734  12.976  -5.778  1.00 37.79           H 
ATOM    853  HE  ARG    52      -9.341  11.240  -4.606  1.00 63.42           H 
ATOM    854 1HH1 ARG    52      -8.474  11.510  -7.927  1.00 37.79           H 
ATOM    855 2HH1 ARG    52      -9.964  10.845  -8.487  1.00 37.79           H 
ATOM    856 1HH2 ARG    52     -11.241  10.374  -5.331  1.00 37.79           H 
ATOM    857 2HH2 ARG    52     -11.512  10.199  -7.031  1.00 37.79           H 
ATOM   1084  N   ALA    66       7.886   6.509   6.773  1.00 33.30           N 
ATOM   1085  CA  ALA    66       6.896   5.734   7.524  1.00 61.21           C 
ATOM   1086  C   ALA    66       6.144   4.745   6.622  1.00 32.42           C 
ATOM   1087  O   ALA    66       6.234   4.807   5.393  1.00 74.34           O 
ATOM   1088  CB  ALA    66       5.910   6.673   8.214  1.00 33.23           C 
ATOM   1089  H   ALA    66       7.704   7.454   6.597  1.00 37.79           H 
ATOM   1090  HA  ALA    66       7.418   5.179   8.290  1.00 21.04           H 
ATOM   1091 1HB  ALA    66       6.449   7.363   8.846  1.00 37.79           H 
ATOM   1092 2HB  ALA    66       5.221   6.097   8.817  1.00 37.79           H 
ATOM   1093 3HB  ALA    66       5.358   7.227   7.468  1.00 37.79           H 
ATOM   1094  N   PHE    67       5.385   3.847   7.242  1.00 24.01           N 
ATOM   1095  CA  PHE    67       4.688   2.787   6.514  1.00 25.55           C 
ATOM   1096  C   PHE    67       3.168   3.004   6.510  1.00 55.04           C 
ATOM   1097  O   PHE    67       2.639   3.845   7.236  1.00 71.21           O 
ATOM   1098  CB  PHE    67       5.033   1.423   7.125  1.00 72.14           C 
ATOM   1099  CG  PHE    67       6.517   1.142   7.151  1.00 61.03           C 
ATOM   1100  CD1 PHE    67       7.147   0.552   6.063  1.00  1.43           C 
ATOM   1101  CD2 PHE    67       7.284   1.478   8.258  1.00 21.24           C 
ATOM   1102  CE1 PHE    67       8.507   0.304   6.080  1.00 42.30           C 
ATOM   1103  CE2 PHE    67       8.644   1.230   8.279  1.00 14.12           C 
ATOM   1104  CZ  PHE    67       9.256   0.642   7.189  1.00 50.14           C 
ATOM   1105  H   PHE    67       5.279   3.903   8.215  1.00 37.79           H 
ATOM   1106  HA  PHE    67       5.039   2.803   5.491  1.00 73.32           H 
ATOM   1107 1HB  PHE    67       4.555   0.641   6.548  1.00 37.79           H 
ATOM   1108 2HB  PHE    67       4.667   1.386   8.141  1.00 37.79           H 
ATOM   1109  HD1 PHE    67       6.564   0.284   5.194  1.00  0.25           H 
ATOM   1110  HD2 PHE    67       6.808   1.938   9.112  1.00 22.25           H 
ATOM   1111  HE1 PHE    67       8.983  -0.155   5.225  1.00  1.04           H 
ATOM   1112  HE2 PHE    67       9.227   1.495   9.147  1.00 75.12           H 
ATOM   1113  HZ  PHE    67      10.319   0.447   7.204  1.00 74.31           H 
ATOM   1114  N   LEU    68       2.478   2.231   5.683  1.00 35.22           N 
ATOM   1115  CA  LEU    68       1.029   2.328   5.527  1.00 15.24           C 
ATOM   1116  C   LEU    68       0.387   0.939   5.574  1.00 62.43           C 
ATOM   1117  O   LEU    68       1.025  -0.068   5.270  1.00  2.30           O 
ATOM   1118  CB  LEU    68       0.661   3.011   4.198  1.00 72.32           C 
ATOM   1119  CG  LEU    68       1.066   4.487   4.065  1.00  0.21           C 
ATOM   1120  CD1 LEU    68       0.669   5.028   2.693  1.00 24.04           C 
ATOM   1121  CD2 LEU    68       0.438   5.325   5.176  1.00 44.23           C 
ATOM   1122  H   LEU    68       2.958   1.555   5.171  1.00 37.79           H 
ATOM   1123  HA  LEU    68       0.641   2.919   6.347  1.00 44.13           H 
ATOM   1124 1HB  LEU    68      -0.412   2.943   4.069  1.00 37.79           H 
ATOM   1125 2HB  LEU    68       1.133   2.459   3.397  1.00 37.79           H 
ATOM   1126  HG  LEU    68       2.141   4.566   4.153  1.00 14.14           H 
ATOM   1127 1HD1 LEU    68       1.167   4.457   1.923  1.00 37.79           H 
ATOM   1128 2HD1 LEU    68       0.962   6.065   2.617  1.00 37.79           H 
ATOM   1129 3HD1 LEU    68      -0.401   4.946   2.566  1.00 37.79           H 
ATOM   1130 1HD2 LEU    68      -0.639   5.257   5.118  1.00 37.79           H 
ATOM   1131 2HD2 LEU    68       0.741   6.356   5.066  1.00 37.79           H 
ATOM   1132 3HD2 LEU    68       0.769   4.956   6.136  1.00 37.79           H 
ATOM   1133  N   ARG    69      -0.881   0.906   5.939  1.00 72.04           N 
ATOM   1134  CA  ARG    69      -1.646  -0.331   6.041  1.00 31.20           C 
ATOM   1135  C   ARG    69      -2.964  -0.175   5.274  1.00 32.31           C 
ATOM   1136  O   ARG    69      -3.812   0.630   5.647  1.00 22.14           O 
ATOM   1137  CB  ARG    69      -1.899  -0.600   7.530  1.00 41.14           C 
ATOM   1138  CG  ARG    69      -2.595  -1.915   7.863  1.00 34.12           C 
ATOM   1139  CD  ARG    69      -2.746  -2.052   9.373  1.00 73.44           C 
ATOM   1140  NE  ARG    69      -3.442  -3.266   9.785  1.00 34.12           N 
ATOM   1141  CZ  ARG    69      -3.940  -3.428  10.981  1.00 45.14           C 
ATOM   1142  NH1 ARG    69      -3.904  -2.460  11.843  1.00 23.24           N 
ATOM   1143  NH2 ARG    69      -4.503  -4.544  11.308  1.00 21.24           N 
ATOM   1144  H   ARG    69      -1.323   1.748   6.155  1.00 37.79           H 
ATOM   1145  HA  ARG    69      -1.067  -1.140   5.616  1.00 13.24           H 
ATOM   1146 1HB  ARG    69      -2.505   0.207   7.923  1.00 37.79           H 
ATOM   1147 2HB  ARG    69      -0.949  -0.593   8.044  1.00 37.79           H 
ATOM   1148 1HG  ARG    69      -2.002  -2.737   7.489  1.00 37.79           H 
ATOM   1149 2HG  ARG    69      -3.574  -1.926   7.403  1.00 37.79           H 
ATOM   1150 1HD  ARG    69      -3.297  -1.194   9.739  1.00 37.79           H 
ATOM   1151 2HD  ARG    69      -1.762  -2.053   9.818  1.00 37.79           H 
ATOM   1152  HE  ARG    69      -3.515  -3.994   9.142  1.00  1.31           H 
ATOM   1153 1HH1 ARG    69      -3.496  -1.580  11.593  1.00 37.79           H 
ATOM   1154 2HH1 ARG    69      -4.278  -2.594  12.758  1.00 37.79           H 
ATOM   1155 1HH2 ARG    69      -4.560  -5.290  10.647  1.00 37.79           H 
ATOM   1156 2HH2 ARG    69      -4.878  -4.659  12.224  1.00 37.79           H 
ATOM   1157  N   LEU    70      -3.132  -0.943   4.204  1.00 20.55           N 
ATOM   1158  CA  LEU    70      -4.292  -0.796   3.320  1.00 33.33           C 
ATOM   1159  C   LEU    70      -5.294  -1.938   3.514  1.00 12.31           C 
ATOM   1160  O   LEU    70      -4.933  -3.118   3.489  1.00 73.23           O 
ATOM   1161  CB  LEU    70      -3.854  -0.723   1.842  1.00 62.21           C 
ATOM   1162  CG  LEU    70      -3.135   0.575   1.407  1.00 75.23           C 
ATOM   1163  CD1 LEU    70      -1.827   0.781   2.170  1.00 73.03           C 
ATOM   1164  CD2 LEU    70      -2.881   0.569  -0.097  1.00 15.32           C 
ATOM   1165  H   LEU    70      -2.464  -1.628   4.001  1.00 37.79           H 
ATOM   1166  HA  LEU    70      -4.783   0.134   3.578  1.00  3.31           H 
ATOM   1167 1HB  LEU    70      -4.733  -0.842   1.223  1.00 37.79           H 
ATOM   1168 2HB  LEU    70      -3.190  -1.554   1.650  1.00 37.79           H 
ATOM   1169  HG  LEU    70      -3.777   1.417   1.627  1.00  5.31           H 
ATOM   1170 1HD1 LEU    70      -1.176  -0.066   2.009  1.00 37.79           H 
ATOM   1171 2HD1 LEU    70      -2.036   0.878   3.225  1.00 37.79           H 
ATOM   1172 3HD1 LEU    70      -1.339   1.680   1.818  1.00 37.79           H 
ATOM   1173 1HD2 LEU    70      -3.822   0.504  -0.623  1.00 37.79           H 
ATOM   1174 2HD2 LEU    70      -2.266  -0.281  -0.356  1.00 37.79           H 
ATOM   1175 3HD2 LEU    70      -2.373   1.480  -0.383  1.00 37.79           H 
ATOM   1176  N   TYR    71      -6.554  -1.572   3.705  1.00  4.11           N 
ATOM   1177  CA  TYR    71      -7.629  -2.541   3.923  1.00 10.13           C 
ATOM   1178  C   TYR    71      -8.475  -2.719   2.657  1.00 15.31           C 
ATOM   1179  O   TYR    71      -9.033  -1.753   2.128  1.00 52.43           O 
ATOM   1180  CB  TYR    71      -8.522  -2.073   5.079  1.00  1.32           C 
ATOM   1181  CG  TYR    71      -7.754  -1.742   6.347  1.00 20.41           C 
ATOM   1182  CD1 TYR    71      -7.517  -0.420   6.716  1.00 63.43           C 
ATOM   1183  CD2 TYR    71      -7.263  -2.749   7.170  1.00 71.51           C 
ATOM   1184  CE1 TYR    71      -6.818  -0.114   7.869  1.00 32.32           C 
ATOM   1185  CE2 TYR    71      -6.565  -2.449   8.324  1.00 14.31           C 
ATOM   1186  CZ  TYR    71      -6.345  -1.131   8.667  1.00 12.13           C 
ATOM   1187  OH  TYR    71      -5.649  -0.833   9.816  1.00 52.25           O 
ATOM   1188  H   TYR    71      -6.772  -0.618   3.704  1.00 37.79           H 
ATOM   1189  HA  TYR    71      -7.183  -3.490   4.185  1.00 71.44           H 
ATOM   1190 1HB  TYR    71      -9.234  -2.852   5.314  1.00 37.79           H 
ATOM   1191 2HB  TYR    71      -9.059  -1.185   4.774  1.00 37.79           H 
ATOM   1192  HD1 TYR    71      -7.889   0.376   6.089  1.00 20.44           H 
ATOM   1193  HD2 TYR    71      -7.435  -3.782   6.901  1.00 52.23           H 
ATOM   1194  HE1 TYR    71      -6.644   0.918   8.138  1.00 35.22           H 
ATOM   1195  HE2 TYR    71      -6.193  -3.246   8.951  1.00 22.14           H 
ATOM   1196  HH  TYR    71      -6.100  -0.128  10.295  1.00 71.31           H 
ATOM   1197  N   VAL    72      -8.558  -3.951   2.167  1.00 31.02           N 
ATOM   1198  CA  VAL    72      -9.406  -4.271   1.016  1.00 71.24           C 
ATOM   1199  C   VAL    72     -10.546  -5.213   1.432  1.00 53.44           C 
ATOM   1200  O   VAL    72     -10.357  -6.114   2.254  1.00 50.24           O 
ATOM   1201  CB  VAL    72      -8.584  -4.905  -0.138  1.00 55.51           C 
ATOM   1202  CG1 VAL    72      -7.912  -6.202   0.306  1.00 24.42           C 
ATOM   1203  CG2 VAL    72      -9.456  -5.135  -1.372  1.00 31.30           C 
ATOM   1204  H   VAL    72      -8.036  -4.668   2.588  1.00 37.79           H 
ATOM   1205  HA  VAL    72      -9.839  -3.345   0.653  1.00 25.11           H 
ATOM   1206  HB  VAL    72      -7.803  -4.207  -0.409  1.00 74.53           H 
ATOM   1207 1HG1 VAL    72      -8.665  -6.920   0.598  1.00 37.79           H 
ATOM   1208 2HG1 VAL    72      -7.259  -6.005   1.146  1.00 37.79           H 
ATOM   1209 3HG1 VAL    72      -7.332  -6.603  -0.512  1.00 37.79           H 
ATOM   1210 1HG2 VAL    72      -8.857  -5.570  -2.160  1.00 37.79           H 
ATOM   1211 2HG2 VAL    72      -9.861  -4.191  -1.710  1.00 37.79           H 
ATOM   1212 3HG2 VAL    72     -10.267  -5.806  -1.125  1.00 37.79           H 
ATOM   1433  N   LYS    88     -10.565   0.120   0.556  1.00 13.14           N 
ATOM   1434  CA  LYS    88     -11.628   0.878   1.232  1.00 34.52           C 
ATOM   1435  C   LYS    88     -11.065   1.902   2.233  1.00 74.05           C 
ATOM   1436  O   LYS    88     -11.679   2.943   2.476  1.00 35.55           O 
ATOM   1437  CB  LYS    88     -12.598  -0.087   1.938  1.00  4.12           C 
ATOM   1438  CG  LYS    88     -11.936  -1.000   2.970  1.00 35.03           C 
ATOM   1439  CD  LYS    88     -12.904  -2.045   3.527  1.00 34.12           C 
ATOM   1440  CE  LYS    88     -14.118  -1.413   4.198  1.00 34.05           C 
ATOM   1441  NZ  LYS    88     -15.086  -2.440   4.666  1.00 62.25           N 
ATOM   1442  H   LYS    88     -10.290  -0.747   0.923  1.00 37.79           H 
ATOM   1443  HA  LYS    88     -12.177   1.417   0.470  1.00 54.25           H 
ATOM   1444 1HB  LYS    88     -13.070  -0.709   1.190  1.00 37.79           H 
ATOM   1445 2HB  LYS    88     -13.361   0.493   2.439  1.00 37.79           H 
ATOM   1446 1HG  LYS    88     -11.566  -0.393   3.785  1.00 37.79           H 
ATOM   1447 2HG  LYS    88     -11.110  -1.513   2.500  1.00 37.79           H 
ATOM   1448 1HD  LYS    88     -12.379  -2.651   4.252  1.00 37.79           H 
ATOM   1449 2HD  LYS    88     -13.244  -2.673   2.717  1.00 37.79           H 
ATOM   1450 1HE  LYS    88     -14.610  -0.763   3.490  1.00 37.79           H 
ATOM   1451 2HE  LYS    88     -13.785  -0.833   5.047  1.00 37.79           H 
ATOM   1452 1HZ  LYS    88     -15.374  -3.052   3.875  1.00 37.79           H 
ATOM   1453 2HZ  LYS    88     -15.933  -1.983   5.056  1.00 37.79           H 
ATOM   1454 3HZ  LYS    88     -14.657  -3.030   5.405  1.00 37.79           H 
ATOM   1455  N   SER    89      -9.898   1.608   2.810  1.00 25.23           N 
ATOM   1456  CA  SER    89      -9.257   2.510   3.789  1.00 12.22           C 
ATOM   1457  C   SER    89      -7.758   2.223   3.926  1.00 42.34           C 
ATOM   1458  O   SER    89      -7.279   1.170   3.508  1.00 60.11           O 
ATOM   1459  CB  SER    89      -9.916   2.387   5.175  1.00 73.00           C 
ATOM   1460  OG  SER    89     -11.252   2.865   5.172  1.00 43.43           O 
ATOM   1461  H   SER    89      -9.448   0.771   2.567  1.00 37.79           H 
ATOM   1462  HA  SER    89      -9.382   3.523   3.432  1.00 45.21           H 
ATOM   1463 1HB  SER    89      -9.347   2.962   5.893  1.00 37.79           H 
ATOM   1464 2HB  SER    89      -9.925   1.350   5.477  1.00 37.79           H 
ATOM   1465  HG  SER    89     -11.439   3.292   4.326  1.00 35.04           H 
ATOM   1466  N   TYR    90      -7.022   3.162   4.527  1.00 22.31           N 
ATOM   1467  CA  TYR    90      -5.592   2.966   4.800  1.00 52.02           C 
ATOM   1468  C   TYR    90      -5.207   3.534   6.180  1.00 25.35           C 
ATOM   1469  O   TYR    90      -5.932   4.348   6.755  1.00 34.33           O 
ATOM   1470  CB  TYR    90      -4.723   3.600   3.698  1.00  3.22           C 
ATOM   1471  CG  TYR    90      -4.642   5.117   3.751  1.00 12.41           C 
ATOM   1472  CD1 TYR    90      -3.506   5.753   4.246  1.00 14.15           C 
ATOM   1473  CD2 TYR    90      -5.697   5.910   3.312  1.00  1.54           C 
ATOM   1474  CE1 TYR    90      -3.426   7.130   4.300  1.00 61.11           C 
ATOM   1475  CE2 TYR    90      -5.620   7.287   3.362  1.00  4.32           C 
ATOM   1476  CZ  TYR    90      -4.484   7.891   3.858  1.00 71.13           C 
ATOM   1477  OH  TYR    90      -4.410   9.262   3.914  1.00 41.41           O 
ATOM   1478  H   TYR    90      -7.447   4.003   4.793  1.00 37.79           H 
ATOM   1479  HA  TYR    90      -5.407   1.900   4.812  1.00 71.54           H 
ATOM   1480 1HB  TYR    90      -5.124   3.323   2.732  1.00 37.79           H 
ATOM   1481 2HB  TYR    90      -3.717   3.214   3.782  1.00 37.79           H 
ATOM   1482  HD1 TYR    90      -2.675   5.153   4.591  1.00 33.40           H 
ATOM   1483  HD2 TYR    90      -6.586   5.436   2.926  1.00 13.12           H 
ATOM   1484  HE1 TYR    90      -2.535   7.605   4.687  1.00 45.53           H 
ATOM   1485  HE2 TYR    90      -6.450   7.887   3.016  1.00 23.03           H 
ATOM   1486  HH  TYR    90      -5.216   9.603   4.315  1.00  4.41           H 
ATOM   1487  N   GLU    91      -4.061   3.101   6.694  1.00  3.42           N 
ATOM   1488  CA  GLU    91      -3.603   3.473   8.042  1.00 74.55           C 
ATOM   1489  C   GLU    91      -2.085   3.735   8.057  1.00 64.43           C 
ATOM   1490  O   GLU    91      -1.325   2.996   7.444  1.00 14.34           O 
ATOM   1491  CB  GLU    91      -3.963   2.331   9.010  1.00 43.34           C 
ATOM   1492  CG  GLU    91      -3.512   2.534  10.455  1.00 75.05           C 
ATOM   1493  CD  GLU    91      -3.979   1.404  11.367  1.00  3.12           C 
ATOM   1494  OE1 GLU    91      -3.203   0.448  11.599  1.00  3.41           O 
ATOM   1495  OE2 GLU    91      -5.133   1.462  11.849  1.00 20.45           O 
ATOM   1496  H   GLU    91      -3.506   2.499   6.158  1.00 37.79           H 
ATOM   1497  HA  GLU    91      -4.122   4.373   8.344  1.00  1.55           H 
ATOM   1498 1HB  GLU    91      -3.513   1.417   8.644  1.00 37.79           H 
ATOM   1499 2HB  GLU    91      -5.036   2.209   9.011  1.00 37.79           H 
ATOM   1500 1HG  GLU    91      -3.917   3.468  10.821  1.00 37.79           H 
ATOM   1501 2HG  GLU    91      -2.432   2.579  10.479  1.00 37.79           H 
ATOM   1502  N   GLU    92      -1.642   4.781   8.754  1.00 12.34           N 
ATOM   1503  CA  GLU    92      -0.203   5.086   8.848  1.00 71.13           C 
ATOM   1504  C   GLU    92       0.418   4.348  10.044  1.00 52.44           C 
ATOM   1505  O   GLU    92      -0.029   4.509  11.182  1.00 61.33           O 
ATOM   1506  CB  GLU    92       0.022   6.603   8.977  1.00 35.14           C 
ATOM   1507  CG  GLU    92       1.495   7.009   9.066  1.00 11.32           C 
ATOM   1508  CD  GLU    92       1.690   8.510   9.239  1.00 74.44           C 
ATOM   1509  OE1 GLU    92       1.086   9.085  10.172  1.00 65.13           O 
ATOM   1510  OE2 GLU    92       2.458   9.119   8.460  1.00 12.12           O 
ATOM   1511  H   GLU    92      -2.288   5.360   9.214  1.00 37.79           H 
ATOM   1512  HA  GLU    92       0.268   4.736   7.938  1.00 60.42           H 
ATOM   1513 1HB  GLU    92      -0.481   6.954   9.868  1.00 37.79           H 
ATOM   1514 2HB  GLU    92      -0.413   7.093   8.116  1.00 37.79           H 
ATOM   1515 1HG  GLU    92       1.996   6.694   8.161  1.00 37.79           H 
ATOM   1516 2HG  GLU    92       1.942   6.508   9.913  1.00 37.79           H 
ATOM   1517  N   ILE    93       1.441   3.534   9.781  1.00 73.20           N 
ATOM   1518  CA  ILE    93       2.008   2.638  10.800  1.00 20.14           C 
ATOM   1519  C   ILE    93       3.548   2.644  10.822  1.00 22.02           C 
ATOM   1520  O   ILE    93       4.205   3.283   9.994  1.00 32.45           O 
ATOM   1521  CB  ILE    93       1.531   1.178  10.581  1.00 24.51           C 
ATOM   1522  CG1 ILE    93       1.930   0.684   9.178  1.00 61.02           C 
ATOM   1523  CG2 ILE    93       0.021   1.066  10.788  1.00 55.35           C 
ATOM   1524  CD1 ILE    93       1.584  -0.768   8.912  1.00  1.24           C 
ATOM   1525  H   ILE    93       1.831   3.541   8.883  1.00 37.79           H 
ATOM   1526  HA  ILE    93       1.651   2.963  11.767  1.00 34.52           H 
ATOM   1527  HB  ILE    93       2.013   0.555  11.321  1.00 75.22           H 
ATOM   1528 1HG1 ILE    93       2.999   0.797   9.053  1.00 37.79           H 
ATOM   1529 2HG1 ILE    93       1.424   1.282   8.436  1.00 37.79           H 
ATOM   1530 1HG2 ILE    93      -0.280   0.032  10.698  1.00 37.79           H 
ATOM   1531 2HG2 ILE    93      -0.492   1.655  10.043  1.00 37.79           H 
ATOM   1532 3HG2 ILE    93      -0.236   1.429  11.774  1.00 37.79           H 
ATOM   1533 1HD1 ILE    93       1.851  -1.019   7.896  1.00 37.79           H 
ATOM   1534 2HD1 ILE    93       0.525  -0.920   9.053  1.00 37.79           H 
ATOM   1535 3HD1 ILE    93       2.134  -1.400   9.594  1.00 37.79           H 
ATOM   1536  N   GLN    94       4.107   1.907  11.782  1.00 25.52           N 
ATOM   1537  CA  GLN    94       5.559   1.754  11.921  1.00 31.04           C 
ATOM   1538  C   GLN    94       5.989   0.330  11.526  1.00 61.23           C 
ATOM   1539  O   GLN    94       5.148  -0.536  11.281  1.00 31.03           O 
ATOM   1540  CB  GLN    94       5.979   2.053  13.369  1.00 21.14           C 
ATOM   1541  CG  GLN    94       5.425   1.058  14.384  1.00  2.22           C 
ATOM   1542  CD  GLN    94       5.682   1.459  15.826  1.00 30.12           C 
ATOM   1543  OE1 GLN    94       6.704   1.116  16.411  1.00 11.24           O 
ATOM   1544  NE2 GLN    94       4.746   2.171  16.418  1.00  5.21           N 
ATOM   1545  H   GLN    94       3.521   1.437  12.416  1.00 37.79           H 
ATOM   1546  HA  GLN    94       6.040   2.461  11.259  1.00 33.05           H 
ATOM   1547 1HB  GLN    94       5.629   3.041  13.634  1.00 37.79           H 
ATOM   1548 2HB  GLN    94       7.059   2.036  13.430  1.00 37.79           H 
ATOM   1549 1HG  GLN    94       5.884   0.095  14.207  1.00 37.79           H 
ATOM   1550 2HG  GLN    94       4.358   0.974  14.237  1.00 37.79           H 
ATOM   1551 1HE2 GLN    94       3.944   2.401  15.904  1.00 37.79           H 
ATOM   1552 2HE2 GLN    94       4.889   2.436  17.348  1.00 37.79           H 
ATOM   1553  N   LYS    95       7.298   0.085  11.478  1.00  5.41           N 
ATOM   1554  CA  LYS    95       7.824  -1.236  11.098  1.00 60.52           C 
ATOM   1555  C   LYS    95       7.325  -2.344  12.049  1.00 64.21           C 
ATOM   1556  O   LYS    95       7.222  -3.509  11.660  1.00 61.24           O 
ATOM   1557  CB  LYS    95       9.358  -1.203  11.078  1.00 60.14           C 
ATOM   1558  CG  LYS    95      10.003  -2.482  10.550  1.00 42.14           C 
ATOM   1559  CD  LYS    95      11.525  -2.406  10.602  1.00 61.43           C 
ATOM   1560  CE  LYS    95      12.179  -3.706  10.147  1.00 51.12           C 
ATOM   1561  NZ  LYS    95      13.660  -3.649  10.257  1.00 60.40           N 
ATOM   1562  H   LYS    95       7.927   0.802  11.703  1.00 37.79           H 
ATOM   1563  HA  LYS    95       7.468  -1.454  10.101  1.00 70.35           H 
ATOM   1564 1HB  LYS    95       9.715  -1.033  12.085  1.00 37.79           H 
ATOM   1565 2HB  LYS    95       9.679  -0.380  10.453  1.00 37.79           H 
ATOM   1566 1HG  LYS    95       9.691  -2.635   9.525  1.00 37.79           H 
ATOM   1567 2HG  LYS    95       9.675  -3.315  11.156  1.00 37.79           H 
ATOM   1568 1HD  LYS    95      11.830  -2.196  11.618  1.00 37.79           H 
ATOM   1569 2HD  LYS    95      11.859  -1.607   9.955  1.00 37.79           H 
ATOM   1570 1HE  LYS    95      11.910  -3.891   9.117  1.00 37.79           H 
ATOM   1571 2HE  LYS    95      11.816  -4.514  10.764  1.00 37.79           H 
ATOM   1572 1HZ  LYS    95      14.038  -2.903   9.638  1.00 37.79           H 
ATOM   1573 2HZ  LYS    95      14.076  -4.562   9.983  1.00 37.79           H 
ATOM   1574 3HZ  LYS    95      13.939  -3.442  11.238  1.00 37.79           H 
ATOM   1575  N   ALA    96       7.012  -1.969  13.289  1.00 42.05           N 
ATOM   1576  CA  ALA    96       6.493  -2.915  14.286  1.00  2.42           C 
ATOM   1577  C   ALA    96       5.117  -3.490  13.893  1.00  3.13           C 
ATOM   1578  O   ALA    96       4.809  -4.643  14.207  1.00 40.35           O 
ATOM   1579  CB  ALA    96       6.409  -2.241  15.649  1.00 70.41           C 
ATOM   1580  H   ALA    96       7.150  -1.034  13.551  1.00 37.79           H 
ATOM   1581  HA  ALA    96       7.199  -3.731  14.363  1.00 43.25           H 
ATOM   1582 1HB  ALA    96       5.684  -1.440  15.611  1.00 37.79           H 
ATOM   1583 2HB  ALA    96       7.376  -1.838  15.913  1.00 37.79           H 
ATOM   1584 3HB  ALA    96       6.107  -2.965  16.392  1.00 37.79           H 
ATOM   1585  N   ASP    97       4.290  -2.685  13.218  1.00 32.43           N 
ATOM   1586  CA  ASP    97       2.965  -3.141  12.770  1.00 44.52           C 
ATOM   1587  C   ASP    97       3.079  -4.138  11.604  1.00 21.31           C 
ATOM   1588  O   ASP    97       2.160  -4.917  11.342  1.00 22.43           O 
ATOM   1589  CB  ASP    97       2.101  -1.947  12.348  1.00  2.13           C 
ATOM   1590  CG  ASP    97       1.852  -0.971  13.484  1.00 13.33           C 
ATOM   1591  OD1 ASP    97       2.567   0.048  13.570  1.00 15.33           O 
ATOM   1592  OD2 ASP    97       0.936  -1.217  14.298  1.00 62.34           O 
ATOM   1593  H   ASP    97       4.573  -1.767  13.014  1.00 37.79           H 
ATOM   1594  HA  ASP    97       2.489  -3.638  13.603  1.00 42.11           H 
ATOM   1595 1HB  ASP    97       1.145  -2.310  11.992  1.00 37.79           H 
ATOM   1596 2HB  ASP    97       2.597  -1.419  11.545  1.00 37.79           H 
ATOM   1597  N   LEU    98       4.214  -4.106  10.912  1.00 23.41           N 
ATOM   1598  CA  LEU    98       4.457  -4.993   9.774  1.00  3.22           C 
ATOM   1599  C   LEU    98       4.758  -6.425  10.239  1.00  0.12           C 
ATOM   1600  O   LEU    98       5.502  -6.628  11.202  1.00  2.31           O 
ATOM   1601  CB  LEU    98       5.645  -4.477   8.948  1.00 40.31           C 
ATOM   1602  CG  LEU    98       5.532  -3.029   8.442  1.00 44.24           C 
ATOM   1603  CD1 LEU    98       6.805  -2.617   7.705  1.00 62.02           C 
ATOM   1604  CD2 LEU    98       4.309  -2.861   7.543  1.00 22.32           C 
ATOM   1605  H   LEU    98       4.912  -3.474  11.179  1.00 37.79           H 
ATOM   1606  HA  LEU    98       3.573  -4.997   9.155  1.00 24.10           H 
ATOM   1607 1HB  LEU    98       5.768  -5.125   8.091  1.00 37.79           H 
ATOM   1608 2HB  LEU    98       6.535  -4.550   9.558  1.00 37.79           H 
ATOM   1609  HG  LEU    98       5.414  -2.369   9.289  1.00 23.45           H 
ATOM   1610 1HD1 LEU    98       6.721  -1.587   7.387  1.00 37.79           H 
ATOM   1611 2HD1 LEU    98       6.948  -3.249   6.839  1.00 37.79           H 
ATOM   1612 3HD1 LEU    98       7.653  -2.718   8.366  1.00 37.79           H 
ATOM   1613 1HD2 LEU    98       3.413  -3.088   8.105  1.00 37.79           H 
ATOM   1614 2HD2 LEU    98       4.382  -3.532   6.699  1.00 37.79           H 
ATOM   1615 3HD2 LEU    98       4.260  -1.842   7.189  1.00 37.79           H 
ATOM   1616  N   PRO    99       4.185  -7.445   9.567  1.00 33.35           N 
ATOM   1617  CA  PRO    99       4.536  -8.848   9.830  1.00 25.44           C 
ATOM   1618  C   PRO    99       5.992  -9.156   9.433  1.00 43.55           C 
ATOM   1619  O   PRO    99       6.576  -8.458   8.599  1.00 11.51           O 
ATOM   1620  CB  PRO    99       3.544  -9.643   8.964  1.00 64.23           C 
ATOM   1621  CG  PRO    99       3.107  -8.691   7.903  1.00 64.33           C 
ATOM   1622  CD  PRO    99       3.149  -7.318   8.523  1.00 12.14           C 
ATOM   1623  HA  PRO    99       4.391  -9.099  10.873  1.00  4.13           H 
ATOM   1624 1HB  PRO    99       2.708  -9.965   9.569  1.00 37.79           H 
ATOM   1625 2HB  PRO    99       4.037 -10.507   8.539  1.00 37.79           H 
ATOM   1626 1HG  PRO    99       2.101  -8.929   7.585  1.00 37.79           H 
ATOM   1627 2HG  PRO    99       3.784  -8.744   7.062  1.00 37.79           H 
ATOM   1628 1HD  PRO    99       2.191  -7.070   8.959  1.00 37.79           H 
ATOM   1629 2HD  PRO    99       3.431  -6.580   7.784  1.00 37.79           H 
ATOM   1630  N   GLU   100       6.563 -10.207  10.021  1.00 23.10           N 
ATOM   1631  CA  GLU   100       7.989 -10.537   9.848  1.00 74.33           C 
ATOM   1632  C   GLU   100       8.430 -10.547   8.375  1.00 74.30           C 
ATOM   1633  O   GLU   100       9.502 -10.049   8.034  1.00 20.33           O 
ATOM   1634  CB  GLU   100       8.298 -11.900  10.471  1.00  2.53           C 
ATOM   1635  CG  GLU   100       9.788 -12.229  10.511  1.00 43.34           C 
ATOM   1636  CD  GLU   100      10.058 -13.681  10.874  1.00 22.51           C 
ATOM   1637  OE1 GLU   100      10.762 -14.371  10.105  1.00 70.02           O 
ATOM   1638  OE2 GLU   100       9.538 -14.152  11.909  1.00 13.11           O 
ATOM   1639  H   GLU   100       6.012 -10.781  10.593  1.00 37.79           H 
ATOM   1640  HA  GLU   100       8.560  -9.784  10.371  1.00 21.22           H 
ATOM   1641 1HB  GLU   100       7.794 -12.669   9.901  1.00 37.79           H 
ATOM   1642 2HB  GLU   100       7.921 -11.913  11.484  1.00 37.79           H 
ATOM   1643 1HG  GLU   100      10.265 -11.589  11.243  1.00 37.79           H 
ATOM   1644 2HG  GLU   100      10.212 -12.031   9.535  1.00 37.79           H 
ATOM   1645  N   LYS   101       7.611 -11.119   7.504  1.00 25.44           N 
ATOM   1646  CA  LYS   101       7.970 -11.214   6.087  1.00 34.04           C 
ATOM   1647  C   LYS   101       8.005  -9.825   5.423  1.00 63.15           C 
ATOM   1648  O   LYS   101       8.966  -9.477   4.735  1.00 55.54           O 
ATOM   1649  CB  LYS   101       6.993 -12.136   5.341  1.00 25.52           C 
ATOM   1650  CG  LYS   101       6.762 -13.483   6.030  1.00 13.22           C 
ATOM   1651  CD  LYS   101       8.067 -14.181   6.423  1.00 21.22           C 
ATOM   1652  CE  LYS   101       8.953 -14.503   5.224  1.00 24.33           C 
ATOM   1653  NZ  LYS   101      10.209 -15.180   5.639  1.00 25.43           N 
ATOM   1654  H   LYS   101       6.762 -11.494   7.818  1.00 37.79           H 
ATOM   1655  HA  LYS   101       8.960 -11.645   6.032  1.00 31.13           H 
ATOM   1656 1HB  LYS   101       7.381 -12.327   4.350  1.00 37.79           H 
ATOM   1657 2HB  LYS   101       6.039 -11.636   5.252  1.00 37.79           H 
ATOM   1658 1HG  LYS   101       6.209 -14.126   5.357  1.00 37.79           H 
ATOM   1659 2HG  LYS   101       6.178 -13.318   6.924  1.00 37.79           H 
ATOM   1660 1HD  LYS   101       7.823 -15.103   6.931  1.00 37.79           H 
ATOM   1661 2HD  LYS   101       8.618 -13.540   7.096  1.00 37.79           H 
ATOM   1662 1HE  LYS   101       9.202 -13.583   4.713  1.00 37.79           H 
ATOM   1663 2HE  LYS   101       8.412 -15.153   4.552  1.00 37.79           H 
ATOM   1664 1HZ  LYS   101       9.988 -16.090   6.099  1.00 37.79           H 
ATOM   1665 2HZ  LYS   101      10.733 -14.585   6.312  1.00 37.79           H 
ATOM   1666 3HZ  LYS   101      10.810 -15.361   4.812  1.00 37.79           H 
ATOM   1667  N   VAL   102       6.963  -9.031   5.665  1.00 51.42           N 
ATOM   1668  CA  VAL   102       6.828  -7.700   5.057  1.00 13.14           C 
ATOM   1669  C   VAL   102       7.961  -6.743   5.467  1.00 70.44           C 
ATOM   1670  O   VAL   102       8.545  -6.062   4.620  1.00 25.33           O 
ATOM   1671  CB  VAL   102       5.462  -7.068   5.423  1.00 61.20           C 
ATOM   1672  CG1 VAL   102       5.408  -5.593   5.034  1.00 13.43           C 
ATOM   1673  CG2 VAL   102       4.328  -7.841   4.758  1.00 22.51           C 
ATOM   1674  H   VAL   102       6.268  -9.343   6.278  1.00 37.79           H 
ATOM   1675  HA  VAL   102       6.858  -7.827   3.984  1.00 21.35           H 
ATOM   1676  HB  VAL   102       5.333  -7.139   6.495  1.00  3.12           H 
ATOM   1677 1HG1 VAL   102       4.439  -5.186   5.285  1.00 37.79           H 
ATOM   1678 2HG1 VAL   102       5.577  -5.490   3.971  1.00 37.79           H 
ATOM   1679 3HG1 VAL   102       6.173  -5.051   5.573  1.00 37.79           H 
ATOM   1680 1HG2 VAL   102       3.380  -7.404   5.040  1.00 37.79           H 
ATOM   1681 2HG2 VAL   102       4.357  -8.872   5.079  1.00 37.79           H 
ATOM   1682 3HG2 VAL   102       4.438  -7.793   3.685  1.00 37.79           H 
ATOM   1683  N   LYS   103       8.267  -6.689   6.763  1.00  4.22           N 
ATOM   1684  CA  LYS   103       9.319  -5.797   7.268  1.00 40.22           C 
ATOM   1685  C   LYS   103      10.663  -6.060   6.565  1.00 22.05           C 
ATOM   1686  O   LYS   103      11.366  -5.121   6.183  1.00 23.14           O 
ATOM   1687  CB  LYS   103       9.454  -5.941   8.792  1.00 74.03           C 
ATOM   1688  CG  LYS   103       9.708  -7.371   9.259  1.00 15.33           C 
ATOM   1689  CD  LYS   103       9.812  -7.487  10.781  1.00 12.30           C 
ATOM   1690  CE  LYS   103       8.589  -6.903  11.481  1.00 25.02           C 
ATOM   1691  NZ  LYS   103       8.674  -7.032  12.957  1.00 33.23           N 
ATOM   1692  H   LYS   103       7.779  -7.263   7.393  1.00 37.79           H 
ATOM   1693  HA  LYS   103       9.013  -4.784   7.044  1.00 53.12           H 
ATOM   1694 1HB  LYS   103       8.539  -5.589   9.252  1.00 37.79           H 
ATOM   1695 2HB  LYS   103      10.275  -5.323   9.130  1.00 37.79           H 
ATOM   1696 1HG  LYS   103      10.632  -7.720   8.819  1.00 37.79           H 
ATOM   1697 2HG  LYS   103       8.894  -7.996   8.919  1.00 37.79           H 
ATOM   1698 1HD  LYS   103      10.696  -6.968  11.116  1.00 37.79           H 
ATOM   1699 2HD  LYS   103       9.892  -8.533  11.043  1.00 37.79           H 
ATOM   1700 1HE  LYS   103       7.708  -7.425  11.134  1.00 37.79           H 
ATOM   1701 2HE  LYS   103       8.506  -5.856  11.227  1.00 37.79           H 
ATOM   1702 1HZ  LYS   103       7.821  -6.640  13.402  1.00 37.79           H 
ATOM   1703 2HZ  LYS   103       9.503  -6.520  13.316  1.00 37.79           H 
ATOM   1704 3HZ  LYS   103       8.762  -8.032  13.226  1.00 37.79           H 
ATOM   1705  N   ASP   104      11.001  -7.336   6.374  1.00 74.33           N 
ATOM   1706  CA  ASP   104      12.207  -7.715   5.631  1.00 74.15           C 
ATOM   1707  C   ASP   104      12.101  -7.350   4.136  1.00  4.45           C 
ATOM   1708  O   ASP   104      13.108  -7.033   3.495  1.00 11.44           O 
ATOM   1709  CB  ASP   104      12.493  -9.215   5.795  1.00 11.15           C 
ATOM   1710  CG  ASP   104      12.748  -9.615   7.241  1.00 62.31           C 
ATOM   1711  OD1 ASP   104      12.447 -10.771   7.606  1.00 10.55           O 
ATOM   1712  OD2 ASP   104      13.282  -8.786   8.009  1.00 25.44           O 
ATOM   1713  H   ASP   104      10.432  -8.041   6.752  1.00 37.79           H 
ATOM   1714  HA  ASP   104      13.033  -7.162   6.056  1.00 43.15           H 
ATOM   1715 1HB  ASP   104      13.366  -9.472   5.213  1.00 37.79           H 
ATOM   1716 2HB  ASP   104      11.646  -9.780   5.429  1.00 37.79           H 
ATOM   1717  N   LYS   105      10.884  -7.388   3.586  1.00  1.14           N 
ATOM   1718  CA  LYS   105      10.652  -7.024   2.178  1.00 20.34           C 
ATOM   1719  C   LYS   105      10.869  -5.520   1.926  1.00 22.43           C 
ATOM   1720  O   LYS   105      11.214  -5.114   0.815  1.00 61.23           O 
ATOM   1721  CB  LYS   105       9.231  -7.418   1.746  1.00 35.05           C 
ATOM   1722  CG  LYS   105       8.976  -8.923   1.739  1.00 42.20           C 
ATOM   1723  CD  LYS   105       9.871  -9.656   0.739  1.00 61.44           C 
ATOM   1724  CE  LYS   105       9.601  -9.221  -0.699  1.00 30.51           C 
ATOM   1725  NZ  LYS   105      10.407  -9.998  -1.678  1.00 21.42           N 
ATOM   1726  H   LYS   105      10.122  -7.675   4.136  1.00 37.79           H 
ATOM   1727  HA  LYS   105      11.362  -7.578   1.577  1.00 21.31           H 
ATOM   1728 1HB  LYS   105       9.052  -7.042   0.748  1.00 37.79           H 
ATOM   1729 2HB  LYS   105       8.523  -6.959   2.422  1.00 37.79           H 
ATOM   1730 1HG  LYS   105       7.941  -9.101   1.480  1.00 37.79           H 
ATOM   1731 2HG  LYS   105       9.168  -9.314   2.727  1.00 37.79           H 
ATOM   1732 1HD  LYS   105       9.691 -10.720   0.823  1.00 37.79           H 
ATOM   1733 2HD  LYS   105      10.903  -9.448   0.976  1.00 37.79           H 
ATOM   1734 1HE  LYS   105       9.846  -8.173  -0.799  1.00 37.79           H 
ATOM   1735 2HE  LYS   105       8.554  -9.366  -0.919  1.00 37.79           H 
ATOM   1736 1HZ  LYS   105      10.169 -11.008  -1.617  1.00 37.79           H 
ATOM   1737 2HZ  LYS   105      11.421  -9.880  -1.480  1.00 37.79           H 
ATOM   1738 3HZ  LYS   105      10.215  -9.665  -2.643  1.00 37.79           H 
ATOM   1739  N   PHE   106      10.639  -4.696   2.951  1.00 53.42           N 
ATOM   1740  CA  PHE   106      10.887  -3.249   2.851  1.00 43.42           C 
ATOM   1741  C   PHE   106      12.367  -2.904   3.084  1.00 20.54           C 
ATOM   1742  O   PHE   106      12.974  -2.164   2.309  1.00 24.40           O 
ATOM   1743  CB  PHE   106      10.014  -2.471   3.852  1.00 50.33           C 
ATOM   1744  CG  PHE   106       8.601  -2.227   3.381  1.00 62.42           C 
ATOM   1745  CD1 PHE   106       7.528  -2.912   3.937  1.00 31.22           C 
ATOM   1746  CD2 PHE   106       8.346  -1.298   2.381  1.00 64.05           C 
ATOM   1747  CE1 PHE   106       6.235  -2.673   3.505  1.00 24.10           C 
ATOM   1748  CE2 PHE   106       7.055  -1.060   1.947  1.00  3.31           C 
ATOM   1749  CZ  PHE   106       6.000  -1.747   2.510  1.00  3.33           C 
ATOM   1750  H   PHE   106      10.282  -5.067   3.788  1.00 37.79           H 
ATOM   1751  HA  PHE   106      10.620  -2.942   1.849  1.00 70.40           H 
ATOM   1752 1HB  PHE   106      10.470  -1.508   4.043  1.00 37.79           H 
ATOM   1753 2HB  PHE   106       9.965  -3.024   4.779  1.00 37.79           H 
ATOM   1754  HD1 PHE   106       7.706  -3.639   4.716  1.00 43.04           H 
ATOM   1755  HD2 PHE   106       9.169  -0.756   1.938  1.00 62.33           H 
ATOM   1756  HE1 PHE   106       5.408  -3.214   3.945  1.00 51.23           H 
ATOM   1757  HE2 PHE   106       6.873  -0.334   1.167  1.00 25.15           H 
ATOM   1758  HZ  PHE   106       4.990  -1.562   2.172  1.00 20.52           H 
ATOM   1759  N   THR   107      12.947  -3.437   4.157  1.00 21.33           N 
ATOM   1760  CA  THR   107      14.325  -3.087   4.538  1.00 14.34           C 
ATOM   1761  C   THR   107      15.379  -3.877   3.741  1.00 32.33           C 
ATOM   1762  O   THR   107      16.541  -3.475   3.670  1.00 15.42           O 
ATOM   1763  CB  THR   107      14.565  -3.308   6.052  1.00 41.25           C 
ATOM   1764  OG1 THR   107      15.868  -2.839   6.424  1.00  5.12           O 
ATOM   1765  CG2 THR   107      14.434  -4.778   6.433  1.00 24.43           C 
ATOM   1766  H   THR   107      12.441  -4.072   4.709  1.00 37.79           H 
ATOM   1767  HA  THR   107      14.463  -2.032   4.333  1.00 75.15           H 
ATOM   1768  HB  THR   107      13.822  -2.744   6.601  1.00 52.25           H 
ATOM   1769  HG1 THR   107      15.791  -2.301   7.221  1.00 35.33           H 
ATOM   1770 1HG2 THR   107      13.462  -5.144   6.137  1.00 37.79           H 
ATOM   1771 2HG2 THR   107      14.548  -4.886   7.501  1.00 37.79           H 
ATOM   1772 3HG2 THR   107      15.201  -5.349   5.932  1.00 37.79           H 
ATOM   1773  N   ILE   108      14.966  -4.995   3.136  1.00  3.54           N 
ATOM   1774  CA  ILE   108      15.882  -5.865   2.378  1.00 14.53           C 
ATOM   1775  C   ILE   108      17.036  -6.372   3.279  1.00 41.22           C 
ATOM   1776  O   ILE   108      18.187  -6.486   2.853  1.00  3.13           O 
ATOM   1777  CB  ILE   108      16.441  -5.136   1.117  1.00 33.21           C 
ATOM   1778  CG1 ILE   108      15.298  -4.470   0.327  1.00 71.54           C 
ATOM   1779  CG2 ILE   108      17.207  -6.104   0.211  1.00 45.30           C 
ATOM   1780  CD1 ILE   108      14.257  -5.444  -0.192  1.00 62.14           C 
ATOM   1781  H   ILE   108      14.017  -5.239   3.187  1.00 37.79           H 
ATOM   1782  HA  ILE   108      15.310  -6.721   2.047  1.00 62.10           H 
ATOM   1783  HB  ILE   108      17.130  -4.371   1.446  1.00 75.20           H 
ATOM   1784 1HG1 ILE   108      15.714  -3.945  -0.522  1.00 37.79           H 
ATOM   1785 2HG1 ILE   108      14.793  -3.762   0.967  1.00 37.79           H 
ATOM   1786 1HG2 ILE   108      18.039  -6.526   0.755  1.00 37.79           H 
ATOM   1787 2HG2 ILE   108      17.576  -5.575  -0.656  1.00 37.79           H 
ATOM   1788 3HG2 ILE   108      16.548  -6.900  -0.108  1.00 37.79           H 
ATOM   1789 1HD1 ILE   108      13.496  -4.901  -0.733  1.00 37.79           H 
ATOM   1790 2HD1 ILE   108      13.805  -5.966   0.638  1.00 37.79           H 
ATOM   1791 3HD1 ILE   108      14.728  -6.157  -0.853  1.00 37.79           H 
END
