
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  106 (  781),  selected  106 , name 1ue6_C
# Molecule2: number of CA atoms   75 ( 1234),  selected   75 , name T0466.pdb
# PARAMETERS: 1ue6_C.T0466.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     3_C      -       -           -
LGA    D     4_C      -       -           -
LGA    T     5_C      -       -           -
LGA    T     6_C      -       -           -
LGA    I     7_C      -       -           -
LGA    T     8_C      -       -           -
LGA    I     9_C      -       -           -
LGA    V    10_C      -       -           -
LGA    G    11_C      L      19          0.864
LGA    N    12_C      K      20          1.026
LGA    L    13_C      F      21          2.041
LGA    T    14_C      S      22          2.273
LGA    A    15_C      A      23          1.678
LGA    D    16_C      L      24          3.701
LGA    P    17_C      R      25          5.626
LGA    E    18_C      R      26          3.876
LGA    L    19_C      E      27          2.955
LGA    R    20_C      V      28          3.779
LGA    F    21_C      R      29          2.278
LGA    T    22_C      I      30          3.325
LGA    P    23_C      -       -           -
LGA    S    24_C      Q      31          2.907
LGA    G    25_C      N      32           -
LGA    -       -      E      33           -
LGA    -       -      D      34           -
LGA    -       -      G      35           -
LGA    -       -      S      36           -
LGA    -       -      V      37           -
LGA    -       -      S      38           -
LGA    -       -      D      39           -
LGA    A    26_C      E      40          4.408
LGA    A    27_C      I      41          1.780
LGA    -       -      K      42           -
LGA    V    28_C      E      43          2.096
LGA    A    29_C      R      44          1.037
LGA    N    30_C      T      45          0.746
LGA    F    31_C      Y      46          1.216
LGA    T    32_C      D      47          2.313
LGA    V    33_C      L      48          1.518
LGA    A    34_C      K      49          0.743
LGA    S    35_C      S      50          0.760
LGA    T    36_C      K      51          0.871
LGA    P    37_C      G      52          3.959
LGA    E    51_C      Q      53          3.581
LGA    A    52_C      G      54          1.983
LGA    L    53_C      R      55          3.248
LGA    F    54_C      M      56          2.286
LGA    L    55_C      I      57          1.298
LGA    R    56_C      Q      58          0.495
LGA    C    57_C      V      59          0.791
LGA    N    58_C      S      60          0.453
LGA    I    59_C      I      61          0.891
LGA    W    60_C      P      62          1.033
LGA    R    61_C      A      63          1.295
LGA    E    62_C      S      64          2.788
LGA    A    63_C      V      65          1.361
LGA    A    64_C      P      66          4.135
LGA    E    65_C      L      67          3.050
LGA    N    66_C      -       -           -
LGA    V    67_C      K      68          2.545
LGA    A    68_C      -       -           -
LGA    E    69_C      -       -           -
LGA    S    70_C      E      69          2.020
LGA    L    71_C      F      70          2.091
LGA    T    72_C      D      71          3.767
LGA    R    73_C      Y      72          3.331
LGA    G    74_C      N      73          2.088
LGA    A    75_C      A      74          1.857
LGA    R    76_C      R      75          1.505
LGA    V    77_C      V      76          0.898
LGA    I    78_C      E      77          0.395
LGA    V    79_C      L      78          1.335
LGA    S    80_C      I      79          3.221
LGA    G    81_C      N      80          2.890
LGA    R    82_C      P      81          4.075
LGA    L    83_C      I      82          2.970
LGA    K    84_C      -       -           -
LGA    Q    85_C      -       -           -
LGA    R    86_C      -       -           -
LGA    S    87_C      -       -           -
LGA    F    88_C      -       -           -
LGA    E    89_C      -       -           -
LGA    T    90_C      -       -           -
LGA    R    91_C      -       -           -
LGA    E    92_C      -       -           -
LGA    G    93_C      -       -           -
LGA    E    94_C      -       -           -
LGA    K    95_C      -       -           -
LGA    R    96_C      -       -           -
LGA    T    97_C      -       -           -
LGA    V    98_C      -       -           -
LGA    I    99_C      W      98          3.072
LGA    E   100_C      Y      99          1.284
LGA    V   101_C      I     100          1.025
LGA    E   102_C      K     101          0.879
LGA    V   103_C      A     102          0.801
LGA    D   104_C      D     103          0.987
LGA    E   105_C      D     104          2.064
LGA    I   106_C      I     105          1.238
LGA    G   107_C      V     106          0.752
LGA    P   108_C      L     107          2.105
LGA    S   109_C      T     108          2.606
LGA    L   110_C      -       -           -
LGA    R   111_C      -       -           -
LGA    Y   112_C      -       -           -
LGA    A   113_C      -       -           -
LGA    T   114_C      -       -           -
LGA    A   115_C      -       -           -
LGA    K   116_C      -       -           -
LGA    V   117_C      -       -           -
LGA    N   118_C      -       -           -
LGA    K   119_C      -       -           -
LGA    A   120_C      -       -           -
LGA    S   121_C      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  106   75    5.0     66    2.40    12.12     63.007     2.636

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.777221 * X  +   0.628624 * Y  +   0.027563 * Z  + -54.823975
  Y_new =   0.495704 * X  +  -0.584724 * Y  +  -0.642164 * Z  +  89.909874
  Z_new =  -0.387563 * X  +   0.512766 * Y  +  -0.766072 * Z  +  84.783615 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.551738   -0.589855  [ DEG:   146.2038    -33.7962 ]
  Theta =   0.397986    2.743606  [ DEG:    22.8029    157.1971 ]
  Phi   =   0.567744   -2.573848  [ DEG:    32.5294   -147.4706 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ue6_C                                        
REMARK     2: T0466.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ue6_C.T0466.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  106   75   5.0   66   2.40   12.12  63.007
REMARK  ---------------------------------------------------------- 
MOLECULE 1ue6_C
HEADER    DNA BINDING PROTEIN                     09-MAY-03   1UE6              
TITLE     CRYSTAL STRUCTURE OF THE SINGLE-STRANDED DNA-BINDING                  
TITLE    2 PROTEIN FROM MYCOBACTERIUM TUBERCULOSIS                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SINGLE-STRAND BINDING PROTEIN;                             
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: SINGLE-STRANDED DNA-BINDING PROTEIN;                        
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MYCOBACTERIUM TUBERCULOSIS;                     
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET11D                                    
KEYWDS    OLIGONUCLEOTIDE BINDING FOLD, DNA-BINDING PROTEIN,                    
KEYWDS   2 STRUCTURAL GENOMICS, PSI, PROTEIN STRUCTURE INITIATIVE, TB           
KEYWDS   3 STRUCTURAL GENOMICS CONSORTIUM, TBSGC                                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.SAIKRISHNAN,J.JEYAKANTHAN,J.VENKATESH,N.ACHARYA,K.SEKAR,            
AUTHOR   2 U.VARSHNEY,M.VIJAYAN,TB STRUCTURAL GENOMICS CONSORTIUM               
AUTHOR   3 (TBSGC)                                                              
REVDAT   2   01-FEB-05 1UE6    1       AUTHOR KEYWDS REMARK                     
REVDAT   1   10-FEB-04 1UE6    0                                                
JRNL        AUTH   K.SAIKRISHNAN,J.JEYAKANTHAN,J.VENKATESH,N.ACHARYA,           
JRNL        AUTH 2 K.SEKAR,U.VARSHNEY,M.VIJAYAN                                 
JRNL        TITL   STRUCTURE OF MYCOBACTERIUM TUBERCULOSIS                      
JRNL        TITL 2 SINGLE-STRANDED DNA-BINDING PROTEIN. VARIABILITY             
JRNL        TITL 3 IN QUATERNARY STRUCTURE AND ITS IMPLICATIONS                 
JRNL        REF    J.MOL.BIOL.                   V. 331   385 2003              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 2.70 ANGSTROMS.                                          
DBREF  1UE6 A    1   164  UNP    P0A610   SSB_MYCTU        1    164             
DBREF  1UE6 B    1   164  UNP    P0A610   SSB_MYCTU        1    164             
DBREF  1UE6 C    1   164  UNP    P0A610   SSB_MYCTU        1    164             
DBREF  1UE6 D    1   164  UNP    P0A610   SSB_MYCTU        1    164             
SEQRES   1 A  164  MET ALA GLY ASP THR THR ILE THR ILE VAL GLY ASN LEU          
SEQRES   2 A  164  THR ALA ASP PRO GLU LEU ARG PHE THR PRO SER GLY ALA          
SEQRES   3 A  164  ALA VAL ALA ASN PHE THR VAL ALA SER THR PRO ARG ILE          
SEQRES   4 A  164  TYR ASP ARG GLN THR GLY GLU TRP LYS ASP GLY GLU ALA          
SEQRES   5 A  164  LEU PHE LEU ARG CYS ASN ILE TRP ARG GLU ALA ALA GLU          
SEQRES   6 A  164  ASN VAL ALA GLU SER LEU THR ARG GLY ALA ARG VAL ILE          
SEQRES   7 A  164  VAL SER GLY ARG LEU LYS GLN ARG SER PHE GLU THR ARG          
SEQRES   8 A  164  GLU GLY GLU LYS ARG THR VAL ILE GLU VAL GLU VAL ASP          
SEQRES   9 A  164  GLU ILE GLY PRO SER LEU ARG TYR ALA THR ALA LYS VAL          
SEQRES  10 A  164  ASN LYS ALA SER ARG SER GLY GLY PHE GLY SER GLY SER          
SEQRES  11 A  164  ARG PRO ALA PRO ALA GLN THR SER SER ALA SER GLY ASP          
SEQRES  12 A  164  ASP PRO TRP GLY SER ALA PRO ALA SER GLY SER PHE GLY          
SEQRES  13 A  164  GLY GLY ASP ASP GLU PRO PRO PHE                              
SEQRES   1 B  164  MET ALA GLY ASP THR THR ILE THR ILE VAL GLY ASN LEU          
SEQRES   2 B  164  THR ALA ASP PRO GLU LEU ARG PHE THR PRO SER GLY ALA          
SEQRES   3 B  164  ALA VAL ALA ASN PHE THR VAL ALA SER THR PRO ARG ILE          
SEQRES   4 B  164  TYR ASP ARG GLN THR GLY GLU TRP LYS ASP GLY GLU ALA          
SEQRES   5 B  164  LEU PHE LEU ARG CYS ASN ILE TRP ARG GLU ALA ALA GLU          
SEQRES   6 B  164  ASN VAL ALA GLU SER LEU THR ARG GLY ALA ARG VAL ILE          
SEQRES   7 B  164  VAL SER GLY ARG LEU LYS GLN ARG SER PHE GLU THR ARG          
SEQRES   8 B  164  GLU GLY GLU LYS ARG THR VAL ILE GLU VAL GLU VAL ASP          
SEQRES   9 B  164  GLU ILE GLY PRO SER LEU ARG TYR ALA THR ALA LYS VAL          
SEQRES  10 B  164  ASN LYS ALA SER ARG SER GLY GLY PHE GLY SER GLY SER          
SEQRES  11 B  164  ARG PRO ALA PRO ALA GLN THR SER SER ALA SER GLY ASP          
SEQRES  12 B  164  ASP PRO TRP GLY SER ALA PRO ALA SER GLY SER PHE GLY          
SEQRES  13 B  164  GLY GLY ASP ASP GLU PRO PRO PHE                              
SEQRES   1 C  164  MET ALA GLY ASP THR THR ILE THR ILE VAL GLY ASN LEU          
SEQRES   2 C  164  THR ALA ASP PRO GLU LEU ARG PHE THR PRO SER GLY ALA          
SEQRES   3 C  164  ALA VAL ALA ASN PHE THR VAL ALA SER THR PRO ARG ILE          
SEQRES   4 C  164  TYR ASP ARG GLN THR GLY GLU TRP LYS ASP GLY GLU ALA          
SEQRES   5 C  164  LEU PHE LEU ARG CYS ASN ILE TRP ARG GLU ALA ALA GLU          
SEQRES   6 C  164  ASN VAL ALA GLU SER LEU THR ARG GLY ALA ARG VAL ILE          
SEQRES   7 C  164  VAL SER GLY ARG LEU LYS GLN ARG SER PHE GLU THR ARG          
SEQRES   8 C  164  GLU GLY GLU LYS ARG THR VAL ILE GLU VAL GLU VAL ASP          
SEQRES   9 C  164  GLU ILE GLY PRO SER LEU ARG TYR ALA THR ALA LYS VAL          
SEQRES  10 C  164  ASN LYS ALA SER ARG SER GLY GLY PHE GLY SER GLY SER          
SEQRES  11 C  164  ARG PRO ALA PRO ALA GLN THR SER SER ALA SER GLY ASP          
SEQRES  12 C  164  ASP PRO TRP GLY SER ALA PRO ALA SER GLY SER PHE GLY          
SEQRES  13 C  164  GLY GLY ASP ASP GLU PRO PRO PHE                              
SEQRES   1 D  164  MET ALA GLY ASP THR THR ILE THR ILE VAL GLY ASN LEU          
SEQRES   2 D  164  THR ALA ASP PRO GLU LEU ARG PHE THR PRO SER GLY ALA          
SEQRES   3 D  164  ALA VAL ALA ASN PHE THR VAL ALA SER THR PRO ARG ILE          
SEQRES   4 D  164  TYR ASP ARG GLN THR GLY GLU TRP LYS ASP GLY GLU ALA          
SEQRES   5 D  164  LEU PHE LEU ARG CYS ASN ILE TRP ARG GLU ALA ALA GLU          
SEQRES   6 D  164  ASN VAL ALA GLU SER LEU THR ARG GLY ALA ARG VAL ILE          
SEQRES   7 D  164  VAL SER GLY ARG LEU LYS GLN ARG SER PHE GLU THR ARG          
SEQRES   8 D  164  GLU GLY GLU LYS ARG THR VAL ILE GLU VAL GLU VAL ASP          
SEQRES   9 D  164  GLU ILE GLY PRO SER LEU ARG TYR ALA THR ALA LYS VAL          
SEQRES  10 D  164  ASN LYS ALA SER ARG SER GLY GLY PHE GLY SER GLY SER          
SEQRES  11 D  164  ARG PRO ALA PRO ALA GLN THR SER SER ALA SER GLY ASP          
SEQRES  12 D  164  ASP PRO TRP GLY SER ALA PRO ALA SER GLY SER PHE GLY          
SEQRES  13 D  164  GLY GLY ASP ASP GLU PRO PRO PHE                              
FORMUL   5  HOH   *229(H2 O)                                                    
CRYST1   60.363  117.620  175.228  90.00  90.00  90.00 I 21 21 21   32          
ATOM   1538  N   GLY C   3       0.848  -1.843 -20.876  1.00 60.34           N  
ATOM   1539  CA  GLY C   3       0.863  -2.738 -19.666  1.00 69.31           C  
ATOM   1540  C   GLY C   3       0.255  -4.113 -19.906  1.00 65.42           C  
ATOM   1541  O   GLY C   3      -0.884  -4.229 -20.367  1.00 63.98           O  
ATOM   1542  N   ASP C   4       1.007  -5.164 -19.592  1.00 55.49           N  
ATOM   1543  CA  ASP C   4       0.503  -6.513 -19.799  1.00 53.14           C  
ATOM   1544  C   ASP C   4      -0.674  -6.807 -18.892  1.00 41.76           C  
ATOM   1545  O   ASP C   4      -1.607  -7.515 -19.266  1.00 52.82           O  
ATOM   1546  CB  ASP C   4       1.600  -7.550 -19.558  1.00 63.21           C  
ATOM   1547  CG  ASP C   4       2.647  -7.553 -20.654  1.00 76.33           C  
ATOM   1548  OD1 ASP C   4       3.355  -6.534 -20.799  1.00 84.77           O  
ATOM   1549  OD2 ASP C   4       2.757  -8.574 -21.371  1.00 75.44           O  
ATOM   1550  N   THR C   5      -0.641  -6.249 -17.696  1.00 30.89           N  
ATOM   1551  CA  THR C   5      -1.710  -6.479 -16.744  1.00 38.64           C  
ATOM   1552  C   THR C   5      -2.073  -5.216 -16.000  1.00 37.70           C  
ATOM   1553  O   THR C   5      -1.358  -4.811 -15.092  1.00 50.17           O  
ATOM   1554  CB  THR C   5      -1.309  -7.544 -15.707  1.00 48.63           C  
ATOM   1555  OG1 THR C   5      -2.111  -7.387 -14.532  1.00 60.13           O  
ATOM   1556  CG2 THR C   5       0.155  -7.398 -15.323  1.00 56.50           C  
ATOM   1557  N   THR C   6      -3.193  -4.603 -16.374  1.00 40.92           N  
ATOM   1558  CA  THR C   6      -3.655  -3.381 -15.721  1.00 29.07           C  
ATOM   1559  C   THR C   6      -5.029  -3.572 -15.085  1.00 22.95           C  
ATOM   1560  O   THR C   6      -5.940  -4.090 -15.720  1.00 36.71           O  
ATOM   1561  CB  THR C   6      -3.746  -2.218 -16.728  1.00 50.65           C  
ATOM   1562  OG1 THR C   6      -4.757  -2.504 -17.701  1.00 57.02           O  
ATOM   1563  CG2 THR C   6      -2.410  -2.030 -17.442  1.00 54.84           C  
ATOM   1564  N   ILE C   7      -5.173  -3.163 -13.828  1.00 26.15           N  
ATOM   1565  CA  ILE C   7      -6.450  -3.266 -13.115  1.00 26.42           C  
ATOM   1566  C   ILE C   7      -6.854  -1.934 -12.536  1.00 27.88           C  
ATOM   1567  O   ILE C   7      -6.035  -1.036 -12.382  1.00 22.09           O  
ATOM   1568  CB  ILE C   7      -6.404  -4.209 -11.887  1.00 27.75           C  
ATOM   1569  CG1 ILE C   7      -5.009  -4.188 -11.269  1.00 40.98           C  
ATOM   1570  CG2 ILE C   7      -6.850  -5.581 -12.253  1.00 54.84           C  
ATOM   1571  CD1 ILE C   7      -4.647  -2.872 -10.636  1.00 24.48           C  
ATOM   1572  N   THR C   8      -8.138  -1.829 -12.211  1.00 37.69           N  
ATOM   1573  CA  THR C   8      -8.691  -0.656 -11.556  1.00 28.91           C  
ATOM   1574  C   THR C   8      -9.602  -1.278 -10.518  1.00 30.78           C  
ATOM   1575  O   THR C   8     -10.526  -2.015 -10.854  1.00 37.14           O  
ATOM   1576  CB  THR C   8      -9.511   0.248 -12.493  1.00 12.46           C  
ATOM   1577  OG1 THR C   8      -8.677   0.742 -13.550  1.00 43.39           O  
ATOM   1578  CG2 THR C   8     -10.029   1.435 -11.724  1.00  6.47           C  
ATOM   1579  N   ILE C   9      -9.306  -1.010  -9.252  1.00 35.54           N  
ATOM   1580  CA  ILE C   9     -10.082  -1.555  -8.149  1.00 33.68           C  
ATOM   1581  C   ILE C   9     -10.825  -0.467  -7.407  1.00 22.99           C  
ATOM   1582  O   ILE C   9     -10.457   0.703  -7.449  1.00 29.93           O  
ATOM   1583  CB  ILE C   9      -9.178  -2.285  -7.099  1.00 42.93           C  
ATOM   1584  CG1 ILE C   9      -8.405  -3.432  -7.749  1.00 42.94           C  
ATOM   1585  CG2 ILE C   9     -10.030  -2.851  -5.975  1.00 44.13           C  
ATOM   1586  CD1 ILE C   9      -7.065  -3.043  -8.312  1.00 33.75           C  
ATOM   1587  N   VAL C  10     -11.880  -0.877  -6.724  1.00 25.16           N  
ATOM   1588  CA  VAL C  10     -12.683   0.016  -5.914  1.00 26.21           C  
ATOM   1589  C   VAL C  10     -13.061  -0.817  -4.704  1.00 28.06           C  
ATOM   1590  O   VAL C  10     -13.458  -1.970  -4.841  1.00 30.05           O  
ATOM   1591  CB  VAL C  10     -13.971   0.467  -6.642  1.00 34.29           C  
ATOM   1592  CG1 VAL C  10     -14.739   1.462  -5.778  1.00 37.18           C  
ATOM   1593  CG2 VAL C  10     -13.624   1.095  -7.967  1.00 24.27           C  
ATOM   1594  N   GLY C  11     -12.913  -0.238  -3.519  1.00 34.14           N  
ATOM   1595  CA  GLY C  11     -13.241  -0.964  -2.309  1.00 39.63           C  
ATOM   1596  C   GLY C  11     -12.870  -0.215  -1.047  1.00 48.98           C  
ATOM   1597  O   GLY C  11     -12.587   0.988  -1.074  1.00 42.42           O  
ATOM   1598  N   ASN C  12     -12.864  -0.939   0.066  1.00 55.85           N  
ATOM   1599  CA  ASN C  12     -12.533  -0.347   1.344  1.00 55.36           C  
ATOM   1600  C   ASN C  12     -11.293  -0.985   1.944  1.00 56.12           C  
ATOM   1601  O   ASN C  12     -11.041  -2.182   1.787  1.00 37.49           O  
ATOM   1602  CB  ASN C  12     -13.738  -0.479   2.274  1.00 54.48           C  
ATOM   1603  CG  ASN C  12     -14.980   0.137   1.669  1.00 66.20           C  
ATOM   1604  OD1 ASN C  12     -15.077   1.361   1.535  1.00 58.46           O  
ATOM   1605  ND2 ASN C  12     -15.930  -0.708   1.274  1.00 68.97           N  
ATOM   1606  N   LEU C  13     -10.506  -0.170   2.642  1.00 54.70           N  
ATOM   1607  CA  LEU C  13      -9.248  -0.608   3.283  1.00 54.26           C  
ATOM   1608  C   LEU C  13      -8.959  -1.770   4.279  1.00 67.82           C  
ATOM   1609  O   LEU C  13      -7.729  -2.090   4.377  1.00 87.95           O  
ATOM   1610  CB  LEU C  13      -8.601   0.733   3.811  1.00 22.40           C  
ATOM   1611  CG  LEU C  13      -8.145   1.883   2.869  1.00 34.07           C  
ATOM   1612  CD1 LEU C  13      -7.249   2.834   3.644  1.00 28.66           C  
ATOM   1613  CD2 LEU C  13      -7.392   1.325   1.676  1.00 30.26           C  
ATOM   1614  N   THR C  14      -9.892  -2.445   4.986  1.00 60.42           N  
ATOM   1615  CA  THR C  14      -9.661  -3.396   6.127  1.00 59.20           C  
ATOM   1616  C   THR C  14      -8.896  -2.702   7.265  1.00 58.02           C  
ATOM   1617  O   THR C  14      -9.134  -2.983   8.465  1.00 70.49           O  
ATOM   1618  CB  THR C  14      -8.912  -4.867   5.855  1.00 61.98           C  
ATOM   1619  OG1 THR C  14      -7.486  -4.783   5.928  1.00 54.82           O  
ATOM   1620  CG2 THR C  14      -9.384  -5.490   4.585  1.00 51.48           C  
ATOM   1621  N   ALA C  15      -8.043  -1.729   6.967  1.00 51.91           N  
ATOM   1622  CA  ALA C  15      -7.347  -1.100   8.055  1.00 52.41           C  
ATOM   1623  C   ALA C  15      -6.625   0.176   7.663  1.00 49.53           C  
ATOM   1624  O   ALA C  15      -6.726   0.625   6.536  1.00 48.05           O  
ATOM   1625  CB  ALA C  15      -6.349  -2.124   8.630  1.00 44.98           C  
ATOM   1626  N   ASP C  16      -5.874   0.746   8.604  1.00 55.06           N  
ATOM   1627  CA  ASP C  16      -5.100   1.943   8.316  1.00 53.89           C  
ATOM   1628  C   ASP C  16      -3.939   1.509   7.444  1.00 53.48           C  
ATOM   1629  O   ASP C  16      -3.437   0.394   7.579  1.00 56.85           O  
ATOM   1630  CB  ASP C  16      -4.540   2.557   9.607  1.00 69.75           C  
ATOM   1631  CG  ASP C  16      -5.554   3.405  10.358  1.00 71.93           C  
ATOM   1632  OD1 ASP C  16      -6.687   2.927  10.587  1.00 72.58           O  
ATOM   1633  OD2 ASP C  16      -5.206   4.549  10.731  1.00 68.84           O  
ATOM   1634  N   PRO C  17      -3.491   2.378   6.535  1.00 52.38           N  
ATOM   1635  CA  PRO C  17      -2.366   2.018   5.668  1.00 62.22           C  
ATOM   1636  C   PRO C  17      -1.037   2.064   6.419  1.00 62.26           C  
ATOM   1637  O   PRO C  17      -0.649   3.112   6.926  1.00 73.25           O  
ATOM   1638  CB  PRO C  17      -2.436   3.069   4.563  1.00 68.00           C  
ATOM   1639  CG  PRO C  17      -2.962   4.272   5.290  1.00 71.62           C  
ATOM   1640  CD  PRO C  17      -4.062   3.680   6.153  1.00 53.28           C  
ATOM   1641  N   GLU C  18      -0.346   0.929   6.488  1.00 66.48           N  
ATOM   1642  CA  GLU C  18       0.944   0.847   7.172  1.00 64.35           C  
ATOM   1643  C   GLU C  18       2.062   1.513   6.373  1.00 61.61           C  
ATOM   1644  O   GLU C  18       1.998   1.582   5.143  1.00 65.17           O  
ATOM   1645  CB  GLU C  18       1.300  -0.615   7.425  1.00 65.62           C  
ATOM   1646  CG  GLU C  18       0.424  -1.276   8.462  1.00 85.94           C  
ATOM   1647  CD  GLU C  18       0.401  -2.777   8.320  1.00 97.22           C  
ATOM   1648  OE1 GLU C  18      -0.216  -3.265   7.348  1.00102.87           O  
ATOM   1649  OE2 GLU C  18       1.000  -3.466   9.173  1.00103.69           O  
ATOM   1650  N   LEU C  19       3.081   2.000   7.075  1.00 44.17           N  
ATOM   1651  CA  LEU C  19       4.206   2.665   6.421  1.00 49.88           C  
ATOM   1652  C   LEU C  19       5.510   1.951   6.784  1.00 56.17           C  
ATOM   1653  O   LEU C  19       5.652   1.424   7.889  1.00 57.00           O  
ATOM   1654  CB  LEU C  19       4.277   4.134   6.846  1.00 48.26           C  
ATOM   1655  CG  LEU C  19       4.547   5.176   5.754  1.00 53.45           C  
ATOM   1656  CD1 LEU C  19       4.716   6.534   6.409  1.00 63.29           C  
ATOM   1657  CD2 LEU C  19       5.789   4.826   4.957  1.00 54.85           C  
ATOM   1658  N   ARG C  20       6.460   1.940   5.853  1.00 58.87           N  
ATOM   1659  CA  ARG C  20       7.735   1.266   6.069  1.00 58.63           C  
ATOM   1660  C   ARG C  20       8.863   1.925   5.287  1.00 63.01           C  
ATOM   1661  O   ARG C  20       8.631   2.554   4.252  1.00 59.88           O  
ATOM   1662  CB  ARG C  20       7.613  -0.203   5.655  1.00 57.00           C  
ATOM   1663  CG  ARG C  20       6.706  -1.030   6.559  1.00 68.45           C  
ATOM   1664  CD  ARG C  20       6.292  -2.333   5.902  1.00 80.72           C  
ATOM   1665  NE  ARG C  20       7.427  -3.027   5.301  1.00 91.84           N  
ATOM   1666  CZ  ARG C  20       7.350  -4.212   4.706  1.00 96.95           C  
ATOM   1667  NH1 ARG C  20       6.186  -4.848   4.631  1.00 90.68           N  
ATOM   1668  NH2 ARG C  20       8.436  -4.758   4.177  1.00103.85           N  
ATOM   1669  N   PHE C  21      10.085   1.780   5.792  1.00 71.43           N  
ATOM   1670  CA  PHE C  21      11.250   2.359   5.137  1.00 79.87           C  
ATOM   1671  C   PHE C  21      12.397   1.380   4.946  1.00 94.09           C  
ATOM   1672  O   PHE C  21      12.314   0.424   4.169  1.00 91.61           O  
ATOM   1673  CB  PHE C  21      11.808   3.545   5.931  1.00 72.92           C  
ATOM   1674  CG  PHE C  21      10.950   4.763   5.906  1.00 64.79           C  
ATOM   1675  CD1 PHE C  21       9.994   4.972   6.888  1.00 51.08           C  
ATOM   1676  CD2 PHE C  21      11.111   5.715   4.908  1.00 60.16           C  
ATOM   1677  CE1 PHE C  21       9.209   6.115   6.878  1.00 50.16           C  
ATOM   1678  CE2 PHE C  21      10.333   6.859   4.889  1.00 65.76           C  
ATOM   1679  CZ  PHE C  21       9.380   7.061   5.877  1.00 57.65           C  
ATOM   1680  N   THR C  22      13.463   1.661   5.692  1.00111.86           N  
ATOM   1681  CA  THR C  22      14.722   0.926   5.675  1.00118.63           C  
ATOM   1682  C   THR C  22      15.563   1.609   4.600  1.00120.06           C  
ATOM   1683  O   THR C  22      15.171   1.628   3.433  1.00122.54           O  
ATOM   1684  CB  THR C  22      14.495  -0.546   5.325  1.00129.85           C  
ATOM   1685  N   PRO C  23      16.709   2.213   4.983  1.00114.48           N  
ATOM   1686  CA  PRO C  23      17.580   2.892   4.014  1.00108.98           C  
ATOM   1687  C   PRO C  23      17.573   2.129   2.689  1.00101.52           C  
ATOM   1688  O   PRO C  23      17.755   2.696   1.610  1.00 90.65           O  
ATOM   1689  CB  PRO C  23      18.929   2.883   4.719  1.00109.92           C  
ATOM   1690  CG  PRO C  23      18.518   3.146   6.147  1.00106.21           C  
ATOM   1691  CD  PRO C  23      17.312   2.231   6.331  1.00111.62           C  
ATOM   1692  N   SER C  24      17.352   0.826   2.805  1.00 98.91           N  
ATOM   1693  CA  SER C  24      17.239  -0.067   1.669  1.00102.67           C  
ATOM   1694  C   SER C  24      15.735  -0.091   1.411  1.00106.80           C  
ATOM   1695  O   SER C  24      14.965  -0.597   2.232  1.00110.29           O  
ATOM   1696  CB  SER C  24      17.720  -1.459   2.057  1.00105.57           C  
ATOM   1697  OG  SER C  24      17.001  -1.929   3.184  1.00106.46           O  
ATOM   1698  N   GLY C  25      15.312   0.469   0.284  1.00105.50           N  
ATOM   1699  CA  GLY C  25      13.894   0.517  -0.010  1.00 94.54           C  
ATOM   1700  C   GLY C  25      13.275   1.628   0.818  1.00 97.43           C  
ATOM   1701  O   GLY C  25      12.987   1.436   2.003  1.00 90.32           O  
ATOM   1702  N   ALA C  26      13.085   2.791   0.192  1.00 96.74           N  
ATOM   1703  CA  ALA C  26      12.519   3.974   0.840  1.00 83.49           C  
ATOM   1704  C   ALA C  26      11.142   3.733   1.450  1.00 76.51           C  
ATOM   1705  O   ALA C  26      10.846   2.643   1.935  1.00 76.15           O  
ATOM   1706  CB  ALA C  26      12.449   5.132  -0.160  1.00 81.67           C  
ATOM   1707  N   ALA C  27      10.301   4.761   1.423  1.00 73.25           N  
ATOM   1708  CA  ALA C  27       8.960   4.671   1.990  1.00 59.77           C  
ATOM   1709  C   ALA C  27       8.079   3.702   1.210  1.00 52.92           C  
ATOM   1710  O   ALA C  27       8.026   3.739  -0.021  1.00 40.64           O  
ATOM   1711  CB  ALA C  27       8.323   6.047   2.020  1.00 69.20           C  
ATOM   1712  N   VAL C  28       7.384   2.834   1.934  1.00 35.86           N  
ATOM   1713  CA  VAL C  28       6.519   1.860   1.300  1.00 44.70           C  
ATOM   1714  C   VAL C  28       5.255   1.616   2.107  1.00 53.04           C  
ATOM   1715  O   VAL C  28       5.304   1.119   3.234  1.00 48.60           O  
ATOM   1716  CB  VAL C  28       7.253   0.517   1.099  1.00 52.18           C  
ATOM   1717  CG1 VAL C  28       6.263  -0.576   0.702  1.00 42.50           C  
ATOM   1718  CG2 VAL C  28       8.317   0.675   0.028  1.00 52.73           C  
ATOM   1719  N   ALA C  29       4.117   1.965   1.518  1.00 54.05           N  
ATOM   1720  CA  ALA C  29       2.845   1.774   2.190  1.00 46.52           C  
ATOM   1721  C   ALA C  29       2.241   0.455   1.764  1.00 39.23           C  
ATOM   1722  O   ALA C  29       2.412   0.030   0.623  1.00 35.60           O  
ATOM   1723  CB  ALA C  29       1.893   2.915   1.844  1.00 53.61           C  
ATOM   1724  N   ASN C  30       1.549  -0.195   2.691  1.00 34.40           N  
ATOM   1725  CA  ASN C  30       0.878  -1.454   2.405  1.00 36.38           C  
ATOM   1726  C   ASN C  30      -0.500  -1.390   3.032  1.00 40.97           C  
ATOM   1727  O   ASN C  30      -0.700  -0.713   4.037  1.00 39.38           O  
ATOM   1728  CB  ASN C  30       1.636  -2.655   2.983  1.00 48.81           C  
ATOM   1729  CG  ASN C  30       3.024  -2.820   2.385  1.00 63.33           C  
ATOM   1730  OD1 ASN C  30       3.197  -2.825   1.165  1.00 75.08           O  
ATOM   1731  ND2 ASN C  30       4.023  -2.971   3.247  1.00 74.76           N  
ATOM   1732  N   PHE C  31      -1.446  -2.086   2.416  1.00 44.52           N  
ATOM   1733  CA  PHE C  31      -2.820  -2.157   2.889  1.00 40.20           C  
ATOM   1734  C   PHE C  31      -3.567  -3.081   1.951  1.00 42.21           C  
ATOM   1735  O   PHE C  31      -3.075  -3.384   0.867  1.00 49.35           O  
ATOM   1736  CB  PHE C  31      -3.479  -0.775   2.876  1.00 47.39           C  
ATOM   1737  CG  PHE C  31      -3.360  -0.052   1.568  1.00 44.56           C  
ATOM   1738  CD1 PHE C  31      -2.251   0.735   1.294  1.00 55.54           C  
ATOM   1739  CD2 PHE C  31      -4.351  -0.162   0.602  1.00 49.28           C  
ATOM   1740  CE1 PHE C  31      -2.131   1.404   0.076  1.00 49.36           C  
ATOM   1741  CE2 PHE C  31      -4.237   0.503  -0.622  1.00 50.29           C  
ATOM   1742  CZ  PHE C  31      -3.124   1.286  -0.883  1.00 34.39           C  
ATOM   1743  N   THR C  32      -4.735  -3.557   2.360  1.00 37.15           N  
ATOM   1744  CA  THR C  32      -5.506  -4.415   1.476  1.00 46.05           C  
ATOM   1745  C   THR C  32      -6.870  -3.786   1.246  1.00 53.71           C  
ATOM   1746  O   THR C  32      -7.553  -3.397   2.197  1.00 49.00           O  
ATOM   1747  CB  THR C  32      -5.712  -5.836   2.043  1.00 38.36           C  
ATOM   1748  OG1 THR C  32      -6.611  -5.786   3.151  1.00 49.29           O  
ATOM   1749  CG2 THR C  32      -4.403  -6.422   2.484  1.00 23.13           C  
ATOM   1750  N   VAL C  33      -7.256  -3.674  -0.023  1.00 51.07           N  
ATOM   1751  CA  VAL C  33      -8.548  -3.095  -0.369  1.00 50.17           C  
ATOM   1752  C   VAL C  33      -9.590  -4.210  -0.438  1.00 45.61           C  
ATOM   1753  O   VAL C  33      -9.339  -5.277  -0.993  1.00 47.72           O  
ATOM   1754  CB  VAL C  33      -8.470  -2.298  -1.704  1.00 29.88           C  
ATOM   1755  CG1 VAL C  33      -7.769  -3.096  -2.770  1.00 54.60           C  
ATOM   1756  CG2 VAL C  33      -9.857  -1.938  -2.166  1.00 51.49           C  
ATOM   1757  N   ALA C  34     -10.752  -3.967   0.162  1.00 56.30           N  
ATOM   1758  CA  ALA C  34     -11.817  -4.962   0.192  1.00 60.73           C  
ATOM   1759  C   ALA C  34     -12.910  -4.706  -0.835  1.00 63.90           C  
ATOM   1760  O   ALA C  34     -13.750  -3.823  -0.660  1.00 62.17           O  
ATOM   1761  CB  ALA C  34     -12.421  -5.022   1.585  1.00 60.97           C  
ATOM   1762  N   SER C  35     -12.883  -5.482  -1.913  1.00 66.58           N  
ATOM   1763  CA  SER C  35     -13.879  -5.375  -2.971  1.00 76.85           C  
ATOM   1764  C   SER C  35     -14.757  -6.613  -2.799  1.00 89.47           C  
ATOM   1765  O   SER C  35     -14.277  -7.648  -2.336  1.00 96.07           O  
ATOM   1766  CB  SER C  35     -13.203  -5.377  -4.349  1.00 71.73           C  
ATOM   1767  OG  SER C  35     -12.357  -4.248  -4.525  1.00 55.62           O  
ATOM   1768  N   THR C  36     -16.034  -6.523  -3.157  1.00 98.67           N  
ATOM   1769  CA  THR C  36     -16.917  -7.674  -2.987  1.00105.04           C  
ATOM   1770  C   THR C  36     -17.642  -8.210  -4.225  1.00110.36           C  
ATOM   1771  O   THR C  36     -17.628  -9.417  -4.474  1.00112.68           O  
ATOM   1772  CB  THR C  36     -17.967  -7.396  -1.891  1.00102.49           C  
ATOM   1773  OG1 THR C  36     -18.637  -6.160  -2.169  1.00105.00           O  
ATOM   1774  CG2 THR C  36     -17.305  -7.318  -0.524  1.00 97.51           C  
ATOM   1775  N   PRO C  37     -18.279  -7.330  -5.021  1.00112.50           N  
ATOM   1776  CA  PRO C  37     -18.999  -7.784  -6.217  1.00116.14           C  
ATOM   1777  C   PRO C  37     -18.134  -8.466  -7.278  1.00117.27           C  
ATOM   1778  O   PRO C  37     -18.405  -8.254  -8.480  1.00113.31           O  
ATOM   1779  CB  PRO C  37     -19.640  -6.497  -6.731  1.00116.76           C  
ATOM   1780  CG  PRO C  37     -18.633  -5.463  -6.354  1.00111.02           C  
ATOM   1781  CD  PRO C  37     -18.292  -5.859  -4.938  1.00113.37           C  
ATOM   1782  N   GLU C  51     -19.082 -13.226  -2.428  1.00 82.38           N  
ATOM   1783  CA  GLU C  51     -17.868 -13.318  -3.283  1.00 80.11           C  
ATOM   1784  C   GLU C  51     -16.631 -12.863  -2.511  1.00 80.26           C  
ATOM   1785  O   GLU C  51     -15.726 -13.657  -2.265  1.00 88.68           O  
ATOM   1786  CB  GLU C  51     -18.051 -12.465  -4.534  1.00 89.56           C  
ATOM   1787  N   ALA C  52     -16.601 -11.584  -2.138  1.00 70.92           N  
ATOM   1788  CA  ALA C  52     -15.494 -10.989  -1.384  1.00 68.07           C  
ATOM   1789  C   ALA C  52     -14.102 -11.243  -1.962  1.00 66.81           C  
ATOM   1790  O   ALA C  52     -13.656 -12.386  -2.057  1.00 72.49           O  
ATOM   1791  CB  ALA C  52     -15.537 -11.458   0.059  1.00 52.78           C  
ATOM   1792  N   LEU C  53     -13.415 -10.163  -2.327  1.00 59.45           N  
ATOM   1793  CA  LEU C  53     -12.069 -10.235  -2.892  1.00 52.99           C  
ATOM   1794  C   LEU C  53     -11.178  -9.269  -2.112  1.00 48.23           C  
ATOM   1795  O   LEU C  53     -11.521  -8.103  -1.937  1.00 53.18           O  
ATOM   1796  CB  LEU C  53     -12.118  -9.872  -4.391  1.00 43.96           C  
ATOM   1797  CG  LEU C  53     -10.922  -9.810  -5.361  1.00 38.33           C  
ATOM   1798  CD1 LEU C  53     -10.536  -8.372  -5.537  1.00 39.68           C  
ATOM   1799  CD2 LEU C  53      -9.740 -10.643  -4.897  1.00 21.28           C  
ATOM   1800  N   PHE C  54     -10.041  -9.759  -1.627  1.00 49.94           N  
ATOM   1801  CA  PHE C  54      -9.122  -8.925  -0.860  1.00 49.38           C  
ATOM   1802  C   PHE C  54      -7.813  -8.738  -1.620  1.00 52.86           C  
ATOM   1803  O   PHE C  54      -7.196  -9.720  -2.042  1.00 59.04           O  
ATOM   1804  CB  PHE C  54      -8.842  -9.566   0.502  1.00 54.13           C  
ATOM   1805  CG  PHE C  54     -10.082  -9.864   1.301  1.00 69.97           C  
ATOM   1806  CD1 PHE C  54     -10.907 -10.933   0.960  1.00 75.36           C  
ATOM   1807  CD2 PHE C  54     -10.433  -9.070   2.393  1.00 70.35           C  
ATOM   1808  CE1 PHE C  54     -12.062 -11.205   1.692  1.00 78.59           C  
ATOM   1809  CE2 PHE C  54     -11.585  -9.335   3.131  1.00 69.91           C  
ATOM   1810  CZ  PHE C  54     -12.401 -10.404   2.780  1.00 75.57           C  
ATOM   1811  N   LEU C  55      -7.382  -7.485  -1.785  1.00 37.69           N  
ATOM   1812  CA  LEU C  55      -6.153  -7.212  -2.520  1.00 42.24           C  
ATOM   1813  C   LEU C  55      -5.133  -6.395  -1.759  1.00 43.34           C  
ATOM   1814  O   LEU C  55      -5.403  -5.251  -1.403  1.00 40.06           O  
ATOM   1815  CB  LEU C  55      -6.479  -6.495  -3.831  1.00 29.34           C  
ATOM   1816  CG  LEU C  55      -7.497  -7.211  -4.713  1.00 44.71           C  
ATOM   1817  CD1 LEU C  55      -7.911  -6.324  -5.885  1.00 38.32           C  
ATOM   1818  CD2 LEU C  55      -6.890  -8.520  -5.189  1.00 19.94           C  
ATOM   1819  N   ARG C  56      -3.958  -6.982  -1.529  1.00 44.24           N  
ATOM   1820  CA  ARG C  56      -2.869  -6.299  -0.825  1.00 51.30           C  
ATOM   1821  C   ARG C  56      -2.199  -5.352  -1.820  1.00 40.92           C  
ATOM   1822  O   ARG C  56      -1.731  -5.774  -2.875  1.00 44.56           O  
ATOM   1823  CB  ARG C  56      -1.851  -7.322  -0.306  1.00 51.40           C  
ATOM   1824  CG  ARG C  56      -1.412  -7.140   1.146  1.00 67.29           C  
ATOM   1825  CD  ARG C  56      -0.625  -5.856   1.369  1.00 93.71           C  
ATOM   1826  NE  ARG C  56      -0.006  -5.800   2.695  1.00106.15           N  
ATOM   1827  CZ  ARG C  56      -0.673  -5.737   3.845  1.00106.50           C  
ATOM   1828  NH1 ARG C  56      -1.999  -5.719   3.857  1.00104.15           N  
ATOM   1829  NH2 ARG C  56      -0.008  -5.692   4.990  1.00107.21           N  
ATOM   1830  N   CYS C  57      -2.144  -4.072  -1.484  1.00 40.31           N  
ATOM   1831  CA  CYS C  57      -1.550  -3.094  -2.388  1.00 49.13           C  
ATOM   1832  C   CYS C  57      -0.275  -2.466  -1.838  1.00 46.78           C  
ATOM   1833  O   CYS C  57      -0.034  -2.481  -0.633  1.00 45.35           O  
ATOM   1834  CB  CYS C  57      -2.565  -1.988  -2.693  1.00 34.81           C  
ATOM   1835  SG  CYS C  57      -4.193  -2.609  -3.034  1.00 37.60           S  
ATOM   1836  N   ASN C  58       0.522  -1.892  -2.735  1.00 46.93           N  
ATOM   1837  CA  ASN C  58       1.770  -1.253  -2.355  1.00 42.85           C  
ATOM   1838  C   ASN C  58       1.964   0.070  -3.074  1.00 48.35           C  
ATOM   1839  O   ASN C  58       1.793   0.148  -4.291  1.00 50.71           O  
ATOM   1840  CB  ASN C  58       2.948  -2.154  -2.712  1.00 38.50           C  
ATOM   1841  CG  ASN C  58       2.641  -3.612  -2.512  1.00 43.55           C  
ATOM   1842  OD1 ASN C  58       2.264  -4.030  -1.419  1.00 37.24           O  
ATOM   1843  ND2 ASN C  58       2.804  -4.404  -3.574  1.00 35.18           N  
ATOM   1844  N   ILE C  59       2.313   1.110  -2.317  1.00 48.08           N  
ATOM   1845  CA  ILE C  59       2.588   2.416  -2.899  1.00 43.09           C  
ATOM   1846  C   ILE C  59       4.040   2.694  -2.550  1.00 47.67           C  
ATOM   1847  O   ILE C  59       4.550   2.187  -1.551  1.00 41.16           O  
ATOM   1848  CB  ILE C  59       1.715   3.547  -2.318  1.00 46.89           C  
ATOM   1849  CG1 ILE C  59       0.560   2.964  -1.510  1.00 43.10           C  
ATOM   1850  CG2 ILE C  59       1.179   4.429  -3.479  1.00 25.67           C  
ATOM   1851  CD1 ILE C  59      -0.407   2.173  -2.350  1.00 69.79           C  
ATOM   1852  N   TRP C  60       4.706   3.494  -3.371  1.00 57.42           N  
ATOM   1853  CA  TRP C  60       6.107   3.791  -3.141  1.00 67.28           C  
ATOM   1854  C   TRP C  60       6.439   5.265  -3.017  1.00 72.19           C  
ATOM   1855  O   TRP C  60       5.886   6.108  -3.724  1.00 76.85           O  
ATOM   1856  CB  TRP C  60       6.960   3.166  -4.254  1.00 73.78           C  
ATOM   1857  CG  TRP C  60       7.785   1.998  -3.784  1.00 87.68           C  
ATOM   1858  CD1 TRP C  60       9.045   2.037  -3.250  1.00 87.29           C  
ATOM   1859  CD2 TRP C  60       7.370   0.630  -3.726  1.00 88.91           C  
ATOM   1860  NE1 TRP C  60       9.434   0.780  -2.858  1.00 82.51           N  
ATOM   1861  CE2 TRP C  60       8.426  -0.102  -3.136  1.00 91.12           C  
ATOM   1862  CE3 TRP C  60       6.204  -0.047  -4.107  1.00 92.82           C  
ATOM   1863  CZ2 TRP C  60       8.350  -1.482  -2.923  1.00100.31           C  
ATOM   1864  CZ3 TRP C  60       6.129  -1.419  -3.895  1.00105.05           C  
ATOM   1865  CH2 TRP C  60       7.196  -2.121  -3.305  1.00109.96           C  
ATOM   1866  N   ARG C  61       7.347   5.560  -2.093  1.00 73.18           N  
ATOM   1867  CA  ARG C  61       7.813   6.914  -1.871  1.00 70.94           C  
ATOM   1868  C   ARG C  61       6.673   7.871  -1.544  1.00 69.52           C  
ATOM   1869  O   ARG C  61       5.760   7.519  -0.796  1.00 63.50           O  
ATOM   1870  CB  ARG C  61       8.557   7.377  -3.119  1.00 73.38           C  
ATOM   1871  CG  ARG C  61       9.399   6.274  -3.739  1.00 79.54           C  
ATOM   1872  CD  ARG C  61       9.057   6.083  -5.209  1.00 95.33           C  
ATOM   1873  NE  ARG C  61       9.473   4.774  -5.709  1.00101.61           N  
ATOM   1874  CZ  ARG C  61       9.198   4.317  -6.927  1.00 99.88           C  
ATOM   1875  NH1 ARG C  61       8.508   5.065  -7.779  1.00 96.45           N  
ATOM   1876  NH2 ARG C  61       9.597   3.106  -7.288  1.00103.00           N  
ATOM   1877  N   GLU C  62       6.744   9.075  -2.110  1.00 68.65           N  
ATOM   1878  CA  GLU C  62       5.738  10.118  -1.901  1.00 79.87           C  
ATOM   1879  C   GLU C  62       4.341   9.594  -1.593  1.00 75.75           C  
ATOM   1880  O   GLU C  62       3.903   9.587  -0.443  1.00 72.08           O  
ATOM   1881  CB  GLU C  62       5.646  11.025  -3.132  1.00 94.80           C  
ATOM   1882  CG  GLU C  62       6.775  12.028  -3.297  1.00114.59           C  
ATOM   1883  CD  GLU C  62       6.503  13.009  -4.429  1.00123.56           C  
ATOM   1884  OE1 GLU C  62       6.384  12.561  -5.591  1.00133.69           O  
ATOM   1885  OE2 GLU C  62       6.402  14.226  -4.156  1.00117.79           O  
ATOM   1886  N   ALA C  63       3.641   9.178  -2.641  1.00 72.97           N  
ATOM   1887  CA  ALA C  63       2.291   8.661  -2.509  1.00 71.38           C  
ATOM   1888  C   ALA C  63       2.147   7.844  -1.232  1.00 66.76           C  
ATOM   1889  O   ALA C  63       1.206   8.042  -0.461  1.00 62.30           O  
ATOM   1890  CB  ALA C  63       1.947   7.804  -3.725  1.00 75.29           C  
ATOM   1891  N   ALA C  64       3.094   6.937  -1.013  1.00 65.40           N  
ATOM   1892  CA  ALA C  64       3.058   6.092   0.165  1.00 67.57           C  
ATOM   1893  C   ALA C  64       2.714   6.858   1.427  1.00 66.18           C  
ATOM   1894  O   ALA C  64       1.768   6.516   2.146  1.00 56.54           O  
ATOM   1895  N   GLU C  65       3.477   7.910   1.688  1.00 60.35           N  
ATOM   1896  CA  GLU C  65       3.269   8.718   2.874  1.00 65.44           C  
ATOM   1897  C   GLU C  65       1.903   9.388   2.860  1.00 63.98           C  
ATOM   1898  O   GLU C  65       1.164   9.319   3.849  1.00 60.57           O  
ATOM   1899  CB  GLU C  65       4.392   9.747   2.989  1.00 68.35           C  
ATOM   1900  CG  GLU C  65       5.765   9.104   2.897  1.00 86.18           C  
ATOM   1901  CD  GLU C  65       6.899  10.064   3.175  1.00 94.28           C  
ATOM   1902  OE1 GLU C  65       6.954  11.135   2.529  1.00100.04           O  
ATOM   1903  OE2 GLU C  65       7.742   9.739   4.039  1.00 96.71           O  
ATOM   1904  N   ASN C  66       1.568  10.029   1.741  1.00 55.78           N  
ATOM   1905  CA  ASN C  66       0.274  10.689   1.615  1.00 53.76           C  
ATOM   1906  C   ASN C  66      -0.804   9.675   1.992  1.00 43.64           C  
ATOM   1907  O   ASN C  66      -1.659   9.944   2.829  1.00 33.89           O  
ATOM   1908  CB  ASN C  66       0.051  11.188   0.181  1.00 49.59           C  
ATOM   1909  CG  ASN C  66       1.055  12.251  -0.231  1.00 53.02           C  
ATOM   1910  OD1 ASN C  66       1.355  13.167   0.533  1.00 69.99           O  
ATOM   1911  ND2 ASN C  66       1.568  12.141  -1.449  1.00 58.97           N  
ATOM   1912  N   VAL C  67      -0.747   8.499   1.381  1.00 35.30           N  
ATOM   1913  CA  VAL C  67      -1.711   7.456   1.687  1.00 41.16           C  
ATOM   1914  C   VAL C  67      -1.732   7.185   3.189  1.00 40.81           C  
ATOM   1915  O   VAL C  67      -2.791   7.143   3.806  1.00 46.58           O  
ATOM   1916  CB  VAL C  67      -1.364   6.146   0.953  1.00 38.16           C  
ATOM   1917  CG1 VAL C  67      -2.282   5.034   1.407  1.00 28.75           C  
ATOM   1918  CG2 VAL C  67      -1.484   6.348  -0.548  1.00 45.87           C  
ATOM   1919  N   ALA C  68      -0.550   7.010   3.769  1.00 46.86           N  
ATOM   1920  CA  ALA C  68      -0.427   6.723   5.190  1.00 51.65           C  
ATOM   1921  C   ALA C  68      -1.016   7.820   6.072  1.00 46.75           C  
ATOM   1922  O   ALA C  68      -1.745   7.547   7.032  1.00 42.93           O  
ATOM   1923  CB  ALA C  68       1.035   6.505   5.539  1.00 55.83           C  
ATOM   1924  N   GLU C  69      -0.708   9.064   5.736  1.00 48.64           N  
ATOM   1925  CA  GLU C  69      -1.193  10.193   6.514  1.00 56.00           C  
ATOM   1926  C   GLU C  69      -2.546  10.792   6.133  1.00 51.29           C  
ATOM   1927  O   GLU C  69      -2.918  11.833   6.673  1.00 57.19           O  
ATOM   1928  CB  GLU C  69      -0.142  11.305   6.515  1.00 75.06           C  
ATOM   1929  CG  GLU C  69       0.304  11.758   5.138  1.00 87.59           C  
ATOM   1930  CD  GLU C  69       1.119  13.033   5.192  1.00 97.16           C  
ATOM   1931  OE1 GLU C  69       0.586  14.058   5.673  1.00102.45           O  
ATOM   1932  OE2 GLU C  69       2.287  13.010   4.756  1.00 85.73           O  
ATOM   1933  N   SER C  70      -3.287  10.163   5.220  1.00 59.93           N  
ATOM   1934  CA  SER C  70      -4.588  10.711   4.835  1.00 53.20           C  
ATOM   1935  C   SER C  70      -5.694   9.709   4.499  1.00 49.37           C  
ATOM   1936  O   SER C  70      -6.609  10.031   3.747  1.00 66.30           O  
ATOM   1937  CB  SER C  70      -4.424  11.688   3.667  1.00 50.87           C  
ATOM   1938  OG  SER C  70      -4.140  11.020   2.458  1.00 49.74           O  
ATOM   1939  N   LEU C  71      -5.614   8.505   5.059  1.00 47.54           N  
ATOM   1940  CA  LEU C  71      -6.621   7.463   4.844  1.00 46.18           C  
ATOM   1941  C   LEU C  71      -6.658   6.573   6.076  1.00 55.59           C  
ATOM   1942  O   LEU C  71      -5.632   6.337   6.713  1.00 67.01           O  
ATOM   1943  CB  LEU C  71      -6.289   6.582   3.627  1.00 43.62           C  
ATOM   1944  CG  LEU C  71      -6.432   7.073   2.184  1.00 36.06           C  
ATOM   1945  CD1 LEU C  71      -6.122   5.924   1.259  1.00 41.14           C  
ATOM   1946  CD2 LEU C  71      -7.837   7.567   1.919  1.00 22.61           C  
ATOM   1947  N   THR C  72      -7.838   6.067   6.408  1.00 52.33           N  
ATOM   1948  CA  THR C  72      -7.985   5.199   7.564  1.00 52.79           C  
ATOM   1949  C   THR C  72      -8.793   3.983   7.156  1.00 53.72           C  
ATOM   1950  O   THR C  72      -9.364   3.960   6.068  1.00 57.13           O  
ATOM   1951  CB  THR C  72      -8.711   5.921   8.696  1.00 55.29           C  
ATOM   1952  OG1 THR C  72     -10.035   6.275   8.271  1.00 61.50           O  
ATOM   1953  CG2 THR C  72      -7.954   7.175   9.064  1.00 60.36           C  
ATOM   1954  N   ARG C  73      -8.847   2.977   8.022  1.00 49.62           N  
ATOM   1955  CA  ARG C  73      -9.595   1.775   7.700  1.00 53.08           C  
ATOM   1956  C   ARG C  73     -10.990   2.145   7.233  1.00 49.34           C  
ATOM   1957  O   ARG C  73     -11.505   3.205   7.592  1.00 50.88           O  
ATOM   1958  CB  ARG C  73      -9.700   0.853   8.912  1.00 59.61           C  
ATOM   1959  CG  ARG C  73     -10.581   1.372  10.022  1.00 71.77           C  
ATOM   1960  CD  ARG C  73     -10.883   0.265  11.019  1.00 79.22           C  
ATOM   1961  NE  ARG C  73     -11.716  -0.782  10.433  1.00 82.18           N  
ATOM   1962  CZ  ARG C  73     -12.068  -1.898  11.061  1.00 85.33           C  
ATOM   1963  NH1 ARG C  73     -12.831  -2.793  10.449  1.00 94.40           N  
ATOM   1964  NH2 ARG C  73     -11.651  -2.127  12.297  1.00 94.13           N  
ATOM   1965  N   GLY C  74     -11.583   1.273   6.420  1.00 50.78           N  
ATOM   1966  CA  GLY C  74     -12.928   1.499   5.915  1.00 48.81           C  
ATOM   1967  C   GLY C  74     -13.133   2.540   4.823  1.00 47.02           C  
ATOM   1968  O   GLY C  74     -14.268   2.747   4.397  1.00 56.22           O  
ATOM   1969  N   ALA C  75     -12.072   3.193   4.355  1.00 36.35           N  
ATOM   1970  CA  ALA C  75     -12.230   4.205   3.312  1.00 46.72           C  
ATOM   1971  C   ALA C  75     -12.426   3.585   1.925  1.00 48.36           C  
ATOM   1972  O   ALA C  75     -11.653   2.722   1.512  1.00 61.95           O  
ATOM   1973  CB  ALA C  75     -11.017   5.157   3.299  1.00 22.08           C  
ATOM   1974  N   ARG C  76     -13.470   4.016   1.221  1.00 43.28           N  
ATOM   1975  CA  ARG C  76     -13.736   3.523  -0.125  1.00 28.61           C  
ATOM   1976  C   ARG C  76     -12.708   4.229  -0.994  1.00 33.32           C  
ATOM   1977  O   ARG C  76     -12.610   5.463  -0.981  1.00 37.98           O  
ATOM   1978  CB  ARG C  76     -15.151   3.894  -0.577  1.00 30.57           C  
ATOM   1979  CG  ARG C  76     -15.659   3.093  -1.789  1.00 35.03           C  
ATOM   1980  CD  ARG C  76     -17.099   3.466  -2.134  1.00 35.99           C  
ATOM   1981  NE  ARG C  76     -17.754   2.457  -2.964  1.00 31.15           N  
ATOM   1982  CZ  ARG C  76     -17.819   2.480  -4.293  1.00 47.02           C  
ATOM   1983  NH1 ARG C  76     -17.269   3.470  -4.995  1.00 62.94           N  
ATOM   1984  NH2 ARG C  76     -18.446   1.501  -4.924  1.00 53.28           N  
ATOM   1985  N   VAL C  77     -11.947   3.451  -1.755  1.00 24.98           N  
ATOM   1986  CA  VAL C  77     -10.895   4.021  -2.585  1.00 24.29           C  
ATOM   1987  C   VAL C  77     -10.940   3.517  -4.019  1.00 23.15           C  
ATOM   1988  O   VAL C  77     -11.570   2.499  -4.299  1.00 24.08           O  
ATOM   1989  CB  VAL C  77      -9.484   3.673  -1.989  1.00 29.74           C  
ATOM   1990  CG1 VAL C  77      -9.329   4.256  -0.608  1.00 31.56           C  
ATOM   1991  CG2 VAL C  77      -9.308   2.174  -1.892  1.00 17.37           C  
ATOM   1992  N   ILE C  78     -10.294   4.255  -4.924  1.00 21.25           N  
ATOM   1993  CA  ILE C  78     -10.181   3.843  -6.318  1.00 20.75           C  
ATOM   1994  C   ILE C  78      -8.684   3.617  -6.475  1.00 32.36           C  
ATOM   1995  O   ILE C  78      -7.889   4.493  -6.136  1.00 38.42           O  
ATOM   1996  CB  ILE C  78     -10.584   4.940  -7.329  1.00 28.05           C  
ATOM   1997  CG1 ILE C  78     -11.941   5.532  -6.968  1.00 46.34           C  
ATOM   1998  CG2 ILE C  78     -10.672   4.327  -8.747  1.00 12.72           C  
ATOM   1999  CD1 ILE C  78     -12.463   6.542  -7.992  1.00 41.99           C  
ATOM   2000  N   VAL C  79      -8.297   2.452  -6.978  1.00 33.54           N  
ATOM   2001  CA  VAL C  79      -6.884   2.131  -7.161  1.00 35.45           C  
ATOM   2002  C   VAL C  79      -6.616   1.698  -8.591  1.00 32.35           C  
ATOM   2003  O   VAL C  79      -7.378   0.927  -9.166  1.00 39.34           O  
ATOM   2004  CB  VAL C  79      -6.427   0.930  -6.262  1.00 38.83           C  
ATOM   2005  CG1 VAL C  79      -4.913   0.799  -6.284  1.00 27.90           C  
ATOM   2006  CG2 VAL C  79      -6.921   1.087  -4.861  1.00 15.80           C  
ATOM   2007  N   SER C  80      -5.531   2.187  -9.171  1.00 23.27           N  
ATOM   2008  CA  SER C  80      -5.176   1.759 -10.511  1.00 28.17           C  
ATOM   2009  C   SER C  80      -3.752   1.250 -10.372  1.00 35.31           C  
ATOM   2010  O   SER C  80      -2.966   1.792  -9.598  1.00 38.18           O  
ATOM   2011  CB  SER C  80      -5.234   2.915 -11.505  1.00 33.87           C  
ATOM   2012  OG  SER C  80      -4.100   3.748 -11.381  1.00 60.88           O  
ATOM   2013  N   GLY C  81      -3.423   0.192 -11.095  1.00 33.63           N  
ATOM   2014  CA  GLY C  81      -2.084  -0.348 -11.012  1.00 27.12           C  
ATOM   2015  C   GLY C  81      -1.956  -1.641 -11.777  1.00 27.99           C  
ATOM   2016  O   GLY C  81      -2.787  -1.969 -12.615  1.00 39.75           O  
ATOM   2017  N   ARG C  82      -0.908  -2.390 -11.486  1.00 39.25           N  
ATOM   2018  CA  ARG C  82      -0.701  -3.650 -12.162  1.00 36.14           C  
ATOM   2019  C   ARG C  82      -0.635  -4.770 -11.153  1.00 33.55           C  
ATOM   2020  O   ARG C  82      -0.465  -4.529  -9.964  1.00 39.69           O  
ATOM   2021  CB  ARG C  82       0.584  -3.607 -12.981  1.00 35.48           C  
ATOM   2022  CG  ARG C  82       1.781  -3.047 -12.265  1.00 36.27           C  
ATOM   2023  CD  ARG C  82       3.065  -3.369 -13.027  1.00 76.06           C  
ATOM   2024  NE  ARG C  82       2.879  -3.408 -14.483  1.00 98.27           N  
ATOM   2025  CZ  ARG C  82       2.509  -4.488 -15.173  1.00100.95           C  
ATOM   2026  NH1 ARG C  82       2.282  -5.635 -14.542  1.00 99.42           N  
ATOM   2027  NH2 ARG C  82       2.363  -4.426 -16.494  1.00 84.16           N  
ATOM   2028  N   LEU C  83      -0.791  -5.995 -11.635  1.00 37.08           N  
ATOM   2029  CA  LEU C  83      -0.740  -7.152 -10.764  1.00 35.95           C  
ATOM   2030  C   LEU C  83       0.686  -7.629 -10.597  1.00 32.30           C  
ATOM   2031  O   LEU C  83       1.476  -7.590 -11.532  1.00 33.42           O  
ATOM   2032  CB  LEU C  83      -1.595  -8.280 -11.333  1.00 42.94           C  
ATOM   2033  CG  LEU C  83      -3.071  -7.922 -11.462  1.00 34.77           C  
ATOM   2034  CD1 LEU C  83      -3.866  -9.169 -11.772  1.00 44.39           C  
ATOM   2035  CD2 LEU C  83      -3.551  -7.299 -10.165  1.00 45.26           C  
ATOM   2036  N   LYS C  84       1.008  -8.078  -9.393  1.00 37.39           N  
ATOM   2037  CA  LYS C  84       2.345  -8.569  -9.105  1.00 42.44           C  
ATOM   2038  C   LYS C  84       2.221  -9.864  -8.328  1.00 44.06           C  
ATOM   2039  O   LYS C  84       1.216 -10.093  -7.661  1.00 59.25           O  
ATOM   2040  CB  LYS C  84       3.108  -7.536  -8.279  1.00 47.03           C  
ATOM   2041  CG  LYS C  84       4.604  -7.744  -8.249  1.00 63.21           C  
ATOM   2042  CD  LYS C  84       5.311  -6.460  -7.844  1.00 67.98           C  
ATOM   2043  CE  LYS C  84       6.817  -6.590  -8.007  1.00 77.34           C  
ATOM   2044  NZ  LYS C  84       7.198  -6.952  -9.408  1.00 82.66           N  
ATOM   2045  N   GLN C  85       3.225 -10.727  -8.441  1.00 52.68           N  
ATOM   2046  CA  GLN C  85       3.227 -11.992  -7.710  1.00 47.23           C  
ATOM   2047  C   GLN C  85       4.355 -11.814  -6.727  1.00 41.92           C  
ATOM   2048  O   GLN C  85       5.469 -11.474  -7.136  1.00 42.26           O  
ATOM   2049  CB  GLN C  85       3.515 -13.161  -8.645  1.00 45.32           C  
ATOM   2050  CG  GLN C  85       2.607 -14.364  -8.417  1.00 50.01           C  
ATOM   2051  CD  GLN C  85       2.707 -15.393  -9.537  1.00 67.42           C  
ATOM   2052  OE1 GLN C  85       3.772 -15.966  -9.778  1.00 80.88           O  
ATOM   2053  NE2 GLN C  85       1.596 -15.629 -10.227  1.00 36.15           N  
ATOM   2054  N   ARG C  86       4.094 -12.023  -5.446  1.00 46.15           N  
ATOM   2055  CA  ARG C  86       5.126 -11.824  -4.404  1.00 53.92           C  
ATOM   2056  C   ARG C  86       6.104 -12.966  -4.176  1.00 61.11           C  
ATOM   2057  O   ARG C  86       7.322 -12.817  -4.530  1.00 65.62           O  
ATOM   2058  CB  ARG C  86       4.453 -11.459  -3.089  1.00 39.67           C  
ATOM   2059  CG  ARG C  86       5.198 -10.405  -2.283  1.00 46.49           C  
ATOM   2060  CD  ARG C  86       4.492 -10.149  -0.963  1.00 38.76           C  
ATOM   2061  NE  ARG C  86       4.562 -11.333  -0.115  1.00 56.47           N  
ATOM   2062  CZ  ARG C  86       3.749 -11.589   0.903  1.00 47.22           C  
ATOM   2063  NH1 ARG C  86       2.778 -10.742   1.216  1.00 50.67           N  
ATOM   2064  NH2 ARG C  86       3.916 -12.695   1.611  1.00 53.34           N  
ATOM   2065  N   SER C  87       5.637 -14.117  -3.629  1.00 48.37           N  
ATOM   2066  CA  SER C  87       6.488 -15.277  -3.396  1.00 56.96           C  
ATOM   2067  C   SER C  87       7.178 -15.224  -2.054  1.00 51.18           C  
ATOM   2068  O   SER C  87       7.992 -14.385  -1.746  1.00 57.06           O  
ATOM   2069  CB  SER C  87       7.546 -15.496  -4.527  1.00 52.10           C  
ATOM   2070  OG  SER C  87       8.710 -14.709  -4.411  1.00 74.39           O  
ATOM   2071  N   PHE C  88       6.793 -16.189  -1.274  1.00 58.13           N  
ATOM   2072  CA  PHE C  88       7.310 -16.264   0.070  1.00 51.06           C  
ATOM   2073  C   PHE C  88       7.276 -17.660   0.653  1.00 55.74           C  
ATOM   2074  O   PHE C  88       6.492 -18.509   0.219  1.00 48.72           O  
ATOM   2075  CB  PHE C  88       6.488 -15.328   0.931  1.00 48.07           C  
ATOM   2076  CG  PHE C  88       5.045 -15.715   1.029  1.00 48.18           C  
ATOM   2077  CD1 PHE C  88       4.154 -15.407   0.012  1.00 25.06           C  
ATOM   2078  CD2 PHE C  88       4.591 -16.456   2.118  1.00 47.75           C  
ATOM   2079  CE1 PHE C  88       2.837 -15.837   0.077  1.00 34.09           C  
ATOM   2080  CE2 PHE C  88       3.274 -16.890   2.186  1.00 39.87           C  
ATOM   2081  CZ  PHE C  88       2.399 -16.583   1.165  1.00 41.15           C  
ATOM   2082  N   GLU C  89       8.128 -17.877   1.653  1.00 46.91           N  
ATOM   2083  CA  GLU C  89       8.186 -19.172   2.322  1.00 40.33           C  
ATOM   2084  C   GLU C  89       7.471 -19.200   3.668  1.00 29.99           C  
ATOM   2085  O   GLU C  89       7.713 -18.362   4.522  1.00 37.24           O  
ATOM   2086  CB  GLU C  89       9.633 -19.623   2.520  1.00 49.78           C  
ATOM   2087  CG  GLU C  89      10.265 -20.268   1.297  1.00 67.43           C  
ATOM   2088  CD  GLU C  89      11.448 -21.157   1.650  1.00 72.33           C  
ATOM   2089  OE1 GLU C  89      12.422 -20.647   2.247  1.00 72.75           O  
ATOM   2090  OE2 GLU C  89      11.400 -22.364   1.329  1.00 74.71           O  
ATOM   2091  N   THR C  90       6.594 -20.178   3.855  1.00 32.94           N  
ATOM   2092  CA  THR C  90       5.860 -20.321   5.114  1.00 44.61           C  
ATOM   2093  C   THR C  90       6.795 -20.679   6.282  1.00 45.92           C  
ATOM   2094  O   THR C  90       7.978 -20.933   6.090  1.00 33.40           O  
ATOM   2095  CB  THR C  90       4.797 -21.427   5.005  1.00 41.07           C  
ATOM   2096  OG1 THR C  90       5.432 -22.680   4.701  1.00 40.21           O  
ATOM   2097  CG2 THR C  90       3.795 -21.086   3.916  1.00 43.25           C  
ATOM   2098  N   ARG C  91       6.260 -20.708   7.495  1.00 49.63           N  
ATOM   2099  CA  ARG C  91       7.079 -21.050   8.652  1.00 52.58           C  
ATOM   2100  C   ARG C  91       7.769 -22.389   8.407  1.00 48.14           C  
ATOM   2101  O   ARG C  91       8.977 -22.533   8.617  1.00 53.69           O  
ATOM   2102  CB  ARG C  91       6.219 -21.140   9.913  1.00 45.94           C  
ATOM   2103  CG  ARG C  91       7.037 -21.246  11.173  1.00 62.77           C  
ATOM   2104  CD  ARG C  91       6.187 -21.290  12.430  1.00 69.32           C  
ATOM   2105  NE  ARG C  91       7.037 -21.093  13.602  1.00 78.44           N  
ATOM   2106  CZ  ARG C  91       7.993 -21.935  13.989  1.00 69.90           C  
ATOM   2107  NH1 ARG C  91       8.225 -23.048  13.308  1.00 84.82           N  
ATOM   2108  NH2 ARG C  91       8.741 -21.646  15.043  1.00 68.45           N  
ATOM   2109  N   GLU C  92       6.986 -23.362   7.954  1.00 44.95           N  
ATOM   2110  CA  GLU C  92       7.488 -24.701   7.668  1.00 48.32           C  
ATOM   2111  C   GLU C  92       8.506 -24.704   6.529  1.00 41.82           C  
ATOM   2112  O   GLU C  92       9.354 -25.590   6.449  1.00 57.92           O  
ATOM   2113  CB  GLU C  92       6.324 -25.652   7.345  1.00 49.85           C  
ATOM   2114  CG  GLU C  92       5.595 -26.241   8.571  1.00 57.45           C  
ATOM   2115  CD  GLU C  92       4.570 -25.295   9.200  1.00 68.28           C  
ATOM   2116  OE1 GLU C  92       4.943 -24.171   9.594  1.00 84.70           O  
ATOM   2117  OE2 GLU C  92       3.386 -25.681   9.310  1.00 75.69           O  
ATOM   2118  N   GLY C  93       8.421 -23.719   5.647  1.00 44.76           N  
ATOM   2119  CA  GLY C  93       9.376 -23.644   4.555  1.00 61.18           C  
ATOM   2120  C   GLY C  93       8.868 -23.920   3.150  1.00 69.21           C  
ATOM   2121  O   GLY C  93       9.674 -24.062   2.221  1.00 63.75           O  
ATOM   2122  N   GLU C  94       7.554 -23.992   2.970  1.00 69.00           N  
ATOM   2123  CA  GLU C  94       7.037 -24.256   1.639  1.00 79.38           C  
ATOM   2124  C   GLU C  94       6.820 -22.996   0.815  1.00 79.11           C  
ATOM   2125  O   GLU C  94       6.323 -21.988   1.317  1.00 77.99           O  
ATOM   2126  CB  GLU C  94       5.746 -25.063   1.707  1.00 87.05           C  
ATOM   2127  CG  GLU C  94       5.323 -25.575   0.340  1.00114.14           C  
ATOM   2128  CD  GLU C  94       6.448 -26.275  -0.423  1.00120.19           C  
ATOM   2129  OE1 GLU C  94       6.233 -26.623  -1.604  1.00123.17           O  
ATOM   2130  OE2 GLU C  94       7.544 -26.481   0.148  1.00126.48           O  
ATOM   2131  N   LYS C  95       7.202 -23.063  -0.460  1.00 81.40           N  
ATOM   2132  CA  LYS C  95       7.069 -21.927  -1.367  1.00 84.05           C  
ATOM   2133  C   LYS C  95       5.622 -21.546  -1.659  1.00 79.86           C  
ATOM   2134  O   LYS C  95       4.781 -22.397  -1.944  1.00 80.43           O  
ATOM   2135  CB  LYS C  95       7.807 -22.204  -2.677  1.00 91.33           C  
ATOM   2136  CG  LYS C  95       9.325 -22.215  -2.530  1.00110.32           C  
ATOM   2137  CD  LYS C  95       9.852 -23.540  -1.996  1.00112.80           C  
ATOM   2138  CE  LYS C  95      10.016 -24.555  -3.117  1.00114.81           C  
ATOM   2139  NZ  LYS C  95      10.988 -24.088  -4.153  1.00104.87           N  
ATOM   2140  N   ARG C  96       5.349 -20.249  -1.577  1.00 71.67           N  
ATOM   2141  CA  ARG C  96       4.020 -19.711  -1.813  1.00 58.34           C  
ATOM   2142  C   ARG C  96       4.136 -18.436  -2.629  1.00 56.96           C  
ATOM   2143  O   ARG C  96       5.230 -17.912  -2.825  1.00 58.08           O  
ATOM   2144  CB  ARG C  96       3.343 -19.385  -0.484  1.00 58.64           C  
ATOM   2145  CG  ARG C  96       2.978 -20.594   0.343  1.00 61.18           C  
ATOM   2146  CD  ARG C  96       1.865 -21.368  -0.327  1.00 67.90           C  
ATOM   2147  NE  ARG C  96       1.671 -22.679   0.277  1.00 72.40           N  
ATOM   2148  CZ  ARG C  96       1.268 -22.874   1.526  1.00 75.74           C  
ATOM   2149  NH1 ARG C  96       1.012 -21.835   2.312  1.00 73.49           N  
ATOM   2150  NH2 ARG C  96       1.129 -24.111   1.991  1.00 63.05           N  
ATOM   2151  N   THR C  97       2.999 -17.956  -3.119  1.00 56.91           N  
ATOM   2152  CA  THR C  97       2.930 -16.710  -3.881  1.00 51.62           C  
ATOM   2153  C   THR C  97       1.585 -16.063  -3.607  1.00 47.02           C  
ATOM   2154  O   THR C  97       0.608 -16.725  -3.233  1.00 31.55           O  
ATOM   2155  CB  THR C  97       3.040 -16.909  -5.415  1.00 43.66           C  
ATOM   2156  OG1 THR C  97       2.034 -17.833  -5.862  1.00 47.11           O  
ATOM   2157  CG2 THR C  97       4.423 -17.391  -5.797  1.00 48.29           C  
ATOM   2158  N   VAL C  98       1.528 -14.757  -3.795  1.00 44.73           N  
ATOM   2159  CA  VAL C  98       0.283 -14.069  -3.566  1.00 47.76           C  
ATOM   2160  C   VAL C  98       0.112 -12.949  -4.580  1.00 47.25           C  
ATOM   2161  O   VAL C  98       1.060 -12.237  -4.912  1.00 41.54           O  
ATOM   2162  CB  VAL C  98       0.225 -13.526  -2.113  1.00 51.88           C  
ATOM   2163  CG1 VAL C  98       1.314 -12.487  -1.900  1.00 51.74           C  
ATOM   2164  CG2 VAL C  98      -1.168 -12.977  -1.803  1.00 31.31           C  
ATOM   2165  N   ILE C  99      -1.100 -12.838  -5.108  1.00 41.68           N  
ATOM   2166  CA  ILE C  99      -1.412 -11.798  -6.065  1.00 39.19           C  
ATOM   2167  C   ILE C  99      -1.571 -10.479  -5.306  1.00 38.72           C  
ATOM   2168  O   ILE C  99      -2.354 -10.378  -4.359  1.00 26.12           O  
ATOM   2169  CB  ILE C  99      -2.718 -12.122  -6.829  1.00 39.39           C  
ATOM   2170  CG1 ILE C  99      -2.443 -13.194  -7.884  1.00 48.36           C  
ATOM   2171  CG2 ILE C  99      -3.287 -10.865  -7.471  1.00 45.97           C  
ATOM   2172  CD1 ILE C  99      -1.331 -12.834  -8.846  1.00 32.79           C  
ATOM   2173  N   GLU C 100      -0.805  -9.476  -5.706  1.00 23.54           N  
ATOM   2174  CA  GLU C 100      -0.903  -8.178  -5.073  1.00 30.33           C  
ATOM   2175  C   GLU C 100      -0.958  -7.098  -6.139  1.00 35.72           C  
ATOM   2176  O   GLU C 100      -0.775  -7.360  -7.326  1.00 34.46           O  
ATOM   2177  CB  GLU C 100       0.285  -7.939  -4.156  1.00 25.84           C  
ATOM   2178  CG  GLU C 100       0.522  -9.060  -3.165  1.00 46.83           C  
ATOM   2179  CD  GLU C 100       1.588  -8.713  -2.145  1.00 32.69           C  
ATOM   2180  OE1 GLU C 100       2.621  -8.129  -2.535  1.00 43.52           O  
ATOM   2181  OE2 GLU C 100       1.393  -9.032  -0.957  1.00 50.74           O  
ATOM   2182  N   VAL C 101      -1.190  -5.873  -5.704  1.00 30.49           N  
ATOM   2183  CA  VAL C 101      -1.289  -4.763  -6.623  1.00 31.29           C  
ATOM   2184  C   VAL C 101      -0.211  -3.728  -6.402  1.00 28.61           C  
ATOM   2185  O   VAL C 101      -0.061  -3.211  -5.298  1.00 44.90           O  
ATOM   2186  CB  VAL C 101      -2.668  -4.061  -6.468  1.00 34.06           C  
ATOM   2187  CG1 VAL C 101      -2.718  -2.804  -7.317  1.00 21.19           C  
ATOM   2188  CG2 VAL C 101      -3.788  -5.018  -6.845  1.00 22.96           C  
ATOM   2189  N   GLU C 102       0.538  -3.416  -7.450  1.00 28.46           N  
ATOM   2190  CA  GLU C 102       1.547  -2.372  -7.338  1.00 34.36           C  
ATOM   2191  C   GLU C 102       0.782  -1.114  -7.759  1.00 32.94           C  
ATOM   2192  O   GLU C 102       0.524  -0.905  -8.937  1.00 32.48           O  
ATOM   2193  CB  GLU C 102       2.720  -2.638  -8.285  1.00 27.21           C  
ATOM   2194  CG  GLU C 102       4.080  -2.117  -7.779  1.00 71.70           C  
ATOM   2195  CD  GLU C 102       4.624  -2.893  -6.567  1.00 78.84           C  
ATOM   2196  OE1 GLU C 102       4.109  -2.717  -5.440  1.00 76.38           O  
ATOM   2197  OE2 GLU C 102       5.569  -3.688  -6.746  1.00 82.62           O  
ATOM   2198  N   VAL C 103       0.401  -0.299  -6.778  1.00 29.39           N  
ATOM   2199  CA  VAL C 103      -0.362   0.912  -7.022  1.00 21.23           C  
ATOM   2200  C   VAL C 103       0.341   2.004  -7.810  1.00 24.84           C  
ATOM   2201  O   VAL C 103       1.405   2.465  -7.439  1.00 36.48           O  
ATOM   2202  CB  VAL C 103      -0.861   1.523  -5.704  1.00 24.23           C  
ATOM   2203  CG1 VAL C 103      -1.620   2.811  -5.986  1.00 30.50           C  
ATOM   2204  CG2 VAL C 103      -1.774   0.543  -4.987  1.00 12.57           C  
ATOM   2205  N   ASP C 104      -0.282   2.414  -8.906  1.00 26.52           N  
ATOM   2206  CA  ASP C 104       0.250   3.468  -9.752  1.00 28.31           C  
ATOM   2207  C   ASP C 104      -0.411   4.768  -9.303  1.00 30.37           C  
ATOM   2208  O   ASP C 104       0.232   5.807  -9.237  1.00 47.80           O  
ATOM   2209  CB  ASP C 104      -0.066   3.173 -11.228  1.00 20.73           C  
ATOM   2210  N   GLU C 105      -1.705   4.690  -8.997  1.00 36.42           N  
ATOM   2211  CA  GLU C 105      -2.491   5.823  -8.520  1.00 27.26           C  
ATOM   2212  C   GLU C 105      -3.590   5.272  -7.609  1.00 32.17           C  
ATOM   2213  O   GLU C 105      -4.160   4.215  -7.888  1.00 27.53           O  
ATOM   2214  CB  GLU C 105      -3.104   6.585  -9.691  1.00 45.89           C  
ATOM   2215  N   ILE C 106      -3.862   5.993  -6.519  1.00 31.34           N  
ATOM   2216  CA  ILE C 106      -4.865   5.625  -5.518  1.00 25.27           C  
ATOM   2217  C   ILE C 106      -5.496   6.898  -4.955  1.00 35.07           C  
ATOM   2218  O   ILE C 106      -4.815   7.912  -4.786  1.00 43.42           O  
ATOM   2219  CB  ILE C 106      -4.219   4.843  -4.357  1.00 35.62           C  
ATOM   2220  CG1 ILE C 106      -5.187   4.707  -3.179  1.00 36.81           C  
ATOM   2221  CG2 ILE C 106      -2.981   5.568  -3.876  1.00 49.54           C  
ATOM   2222  CD1 ILE C 106      -6.360   3.815  -3.438  1.00 50.76           C  
ATOM   2223  N   GLY C 107      -6.795   6.853  -4.670  1.00 44.61           N  
ATOM   2224  CA  GLY C 107      -7.476   8.026  -4.137  1.00 36.11           C  
ATOM   2225  C   GLY C 107      -8.765   7.711  -3.396  1.00 36.95           C  
ATOM   2226  O   GLY C 107      -9.346   6.638  -3.573  1.00 39.88           O  
ATOM   2227  N   PRO C 108      -9.239   8.632  -2.549  1.00 31.27           N  
ATOM   2228  CA  PRO C 108     -10.472   8.442  -1.780  1.00 32.59           C  
ATOM   2229  C   PRO C 108     -11.684   8.640  -2.700  1.00 37.35           C  
ATOM   2230  O   PRO C 108     -11.779   9.660  -3.404  1.00 24.34           O  
ATOM   2231  CB  PRO C 108     -10.397   9.537  -0.706  1.00 37.10           C  
ATOM   2232  CG  PRO C 108      -8.976  10.079  -0.789  1.00 29.85           C  
ATOM   2233  CD  PRO C 108      -8.621   9.928  -2.233  1.00 34.40           C  
ATOM   2234  N   SER C 109     -12.603   7.676  -2.683  1.00 34.70           N  
ATOM   2235  CA  SER C 109     -13.803   7.734  -3.521  1.00 44.38           C  
ATOM   2236  C   SER C 109     -14.835   8.734  -2.995  1.00 47.05           C  
ATOM   2237  O   SER C 109     -15.355   8.591  -1.878  1.00 35.25           O  
ATOM   2238  CB  SER C 109     -14.444   6.346  -3.624  1.00 35.92           C  
ATOM   2239  OG  SER C 109     -15.705   6.410  -4.271  1.00 49.82           O  
ATOM   2240  N   LEU C 110     -15.134   9.735  -3.815  1.00 37.04           N  
ATOM   2241  CA  LEU C 110     -16.086  10.766  -3.437  1.00 31.19           C  
ATOM   2242  C   LEU C 110     -17.536  10.326  -3.570  1.00 36.87           C  
ATOM   2243  O   LEU C 110     -18.442  11.157  -3.587  1.00 49.02           O  
ATOM   2244  CB  LEU C 110     -15.852  12.015  -4.280  1.00 30.71           C  
ATOM   2245  CG  LEU C 110     -14.473  12.643  -4.097  1.00 31.88           C  
ATOM   2246  CD1 LEU C 110     -14.355  13.899  -4.950  1.00 32.51           C  
ATOM   2247  CD2 LEU C 110     -14.274  12.961  -2.626  1.00 27.17           C  
ATOM   2248  N   ARG C 111     -17.763   9.021  -3.660  1.00 46.35           N  
ATOM   2249  CA  ARG C 111     -19.123   8.511  -3.790  1.00 60.35           C  
ATOM   2250  C   ARG C 111     -19.885   8.608  -2.466  1.00 66.40           C  
ATOM   2251  O   ARG C 111     -21.060   8.971  -2.458  1.00 73.70           O  
ATOM   2252  CB  ARG C 111     -19.115   7.054  -4.267  1.00 64.98           C  
ATOM   2253  CG  ARG C 111     -20.509   6.483  -4.477  1.00 70.72           C  
ATOM   2254  CD  ARG C 111     -20.519   4.980  -4.749  1.00 84.21           C  
ATOM   2255  NE  ARG C 111     -20.293   4.639  -6.152  1.00 91.90           N  
ATOM   2256  CZ  ARG C 111     -20.493   3.427  -6.661  1.00 94.31           C  
ATOM   2257  NH1 ARG C 111     -20.920   2.440  -5.885  1.00 94.21           N  
ATOM   2258  NH2 ARG C 111     -20.269   3.199  -7.948  1.00101.18           N  
ATOM   2259  N   TYR C 112     -19.219   8.281  -1.358  1.00 63.64           N  
ATOM   2260  CA  TYR C 112     -19.843   8.331  -0.033  1.00 63.80           C  
ATOM   2261  C   TYR C 112     -19.077   9.207   0.963  1.00 71.69           C  
ATOM   2262  O   TYR C 112     -19.358   9.175   2.168  1.00 73.64           O  
ATOM   2263  CB  TYR C 112     -19.954   6.923   0.561  1.00 67.55           C  
ATOM   2264  CG  TYR C 112     -20.800   5.956  -0.230  1.00 61.25           C  
ATOM   2265  CD1 TYR C 112     -20.755   4.592   0.043  1.00 60.85           C  
ATOM   2266  CD2 TYR C 112     -21.615   6.394  -1.272  1.00 63.98           C  
ATOM   2267  CE1 TYR C 112     -21.488   3.683  -0.714  1.00 69.39           C  
ATOM   2268  CE2 TYR C 112     -22.357   5.495  -2.035  1.00 69.10           C  
ATOM   2269  CZ  TYR C 112     -22.284   4.141  -1.754  1.00 70.76           C  
ATOM   2270  OH  TYR C 112     -22.966   3.247  -2.545  1.00 68.84           O  
ATOM   2271  N   ALA C 113     -18.113   9.979   0.473  1.00 62.00           N  
ATOM   2272  CA  ALA C 113     -17.320  10.831   1.342  1.00 47.42           C  
ATOM   2273  C   ALA C 113     -17.119  12.203   0.711  1.00 54.18           C  
ATOM   2274  O   ALA C 113     -17.605  12.448  -0.386  1.00 58.43           O  
ATOM   2275  CB  ALA C 113     -15.986  10.180   1.620  1.00 63.87           C  
ATOM   2276  N   THR C 114     -16.382  13.079   1.406  1.00 43.08           N  
ATOM   2277  CA  THR C 114     -16.138  14.440   0.933  1.00 47.82           C  
ATOM   2278  C   THR C 114     -14.663  14.766   0.688  1.00 47.33           C  
ATOM   2279  O   THR C 114     -14.290  15.141  -0.383  1.00 63.69           O  
ATOM   2280  CB  THR C 114     -16.740  15.447   1.887  1.00 62.18           C  
ATOM   2281  OG1 THR C 114     -18.161  15.250   1.920  1.00 62.83           O  
ATOM   2282  CG2 THR C 114     -16.423  16.852   1.424  1.00 67.02           C  
ATOM   2283  N   ALA C 115     -13.821  14.635   1.690  1.00 45.50           N  
ATOM   2284  CA  ALA C 115     -12.409  14.865   1.460  1.00 48.78           C  
ATOM   2285  C   ALA C 115     -12.021  16.256   1.111  1.00 44.26           C  
ATOM   2286  O   ALA C 115     -12.463  16.808   0.103  1.00 42.01           O  
ATOM   2287  N   LYS C 116     -11.090  16.787   1.892  1.00 39.53           N  
ATOM   2288  CA  LYS C 116     -10.574  18.115   1.694  1.00 33.15           C  
ATOM   2289  C   LYS C 116      -9.174  17.992   1.149  1.00 48.78           C  
ATOM   2290  O   LYS C 116      -8.230  17.715   1.887  1.00 47.63           O  
ATOM   2291  CB  LYS C 116     -10.574  18.878   3.025  1.00 41.05           C  
ATOM   2292  N   VAL C 117      -9.052  18.206  -0.152  1.00 55.19           N  
ATOM   2293  CA  VAL C 117      -7.779  18.076  -0.830  1.00 58.66           C  
ATOM   2294  C   VAL C 117      -6.740  19.159  -0.557  1.00 62.23           C  
ATOM   2295  O   VAL C 117      -6.832  20.274  -1.076  1.00 53.57           O  
ATOM   2296  CB  VAL C 117      -8.004  17.973  -2.352  1.00 60.08           C  
ATOM   2297  CG1 VAL C 117      -6.682  17.796  -3.074  1.00 58.19           C  
ATOM   2298  CG2 VAL C 117      -8.933  16.814  -2.648  1.00 49.24           C  
ATOM   2299  N   ASN C 118      -5.744  18.812   0.253  1.00 70.69           N  
ATOM   2300  CA  ASN C 118      -4.653  19.728   0.578  1.00 80.28           C  
ATOM   2301  C   ASN C 118      -3.469  19.275  -0.267  1.00 83.64           C  
ATOM   2302  O   ASN C 118      -3.050  18.123  -0.182  1.00 87.53           O  
ATOM   2303  CB  ASN C 118      -4.311  19.640   2.059  1.00 84.35           C  
ATOM   2304  N   LYS C 119      -2.925  20.173  -1.080  1.00 85.73           N  
ATOM   2305  CA  LYS C 119      -1.814  19.804  -1.948  1.00 89.67           C  
ATOM   2306  C   LYS C 119      -0.484  20.498  -1.663  1.00 99.08           C  
ATOM   2307  O   LYS C 119      -0.424  21.519  -0.971  1.00 99.56           O  
ATOM   2308  CB  LYS C 119      -2.213  20.028  -3.401  1.00 80.07           C  
ATOM   2309  N   ALA C 120       0.580  19.920  -2.220  1.00106.62           N  
ATOM   2310  CA  ALA C 120       1.939  20.434  -2.078  1.00108.96           C  
ATOM   2311  C   ALA C 120       2.340  21.144  -3.374  1.00114.13           C  
ATOM   2312  O   ALA C 120       1.819  20.826  -4.444  1.00118.49           O  
ATOM   2313  CB  ALA C 120       2.897  19.284  -1.789  1.00106.64           C  
ATOM   2314  N   SER C 121       3.267  22.097  -3.276  1.00115.66           N  
ATOM   2315  CA  SER C 121       3.728  22.868  -4.437  1.00112.77           C  
ATOM   2316  C   SER C 121       4.638  22.089  -5.392  1.00112.27           C  
ATOM   2317  O   SER C 121       4.433  22.198  -6.622  1.00103.13           O  
ATOM   2318  CB  SER C 121       4.433  24.137  -3.966  1.00105.59           C  
TER    2319      SER C 121                                                      
END
MOLECULE T0466.pdb
ATOM    281  N   LEU    19     -13.966  -0.653  -3.614  1.00 72.33           N 
ATOM    282  CA  LEU    19     -12.695  -0.631  -2.891  1.00 64.15           C 
ATOM    283  C   LEU    19     -12.829   0.243  -1.646  1.00 23.21           C 
ATOM    284  O   LEU    19     -12.938   1.465  -1.741  1.00 12.11           O 
ATOM    285  CB  LEU    19     -11.563  -0.105  -3.789  1.00 13.41           C 
ATOM    286  CG  LEU    19     -11.234  -0.974  -5.016  1.00 70.21           C 
ATOM    287  CD1 LEU    19     -10.125  -0.332  -5.850  1.00 43.44           C 
ATOM    288  CD2 LEU    19     -10.838  -2.387  -4.583  1.00 45.32           C 
ATOM    289  H   LEU    19     -14.169   0.069  -4.245  1.00 38.03           H 
ATOM    290  HA  LEU    19     -12.462  -1.643  -2.586  1.00 55.11           H 
ATOM    291 1HB  LEU    19     -10.669  -0.016  -3.189  1.00 45.32           H 
ATOM    292 2HB  LEU    19     -11.840   0.881  -4.136  1.00  2.50           H 
ATOM    293  HG  LEU    19     -12.112  -1.049  -5.641  1.00 41.50           H 
ATOM    294 1HD1 LEU    19     -10.444   0.645  -6.180  1.00 43.04           H 
ATOM    295 2HD1 LEU    19      -9.917  -0.951  -6.711  1.00 44.24           H 
ATOM    296 3HD1 LEU    19      -9.230  -0.236  -5.251  1.00 60.31           H 
ATOM    297 1HD2 LEU    19     -11.659  -2.843  -4.052  1.00 71.13           H 
ATOM    298 2HD2 LEU    19      -9.973  -2.341  -3.937  1.00 40.24           H 
ATOM    299 3HD2 LEU    19     -10.602  -2.978  -5.457  1.00 72.51           H 
ATOM    300  N   LYS    20     -12.840  -0.387  -0.479  1.00 73.43           N 
ATOM    301  CA  LYS    20     -13.053   0.332   0.778  1.00 62.04           C 
ATOM    302  C   LYS    20     -11.909   0.088   1.772  1.00 13.12           C 
ATOM    303  O   LYS    20     -11.455  -1.045   1.961  1.00 65.12           O 
ATOM    304  CB  LYS    20     -14.419  -0.052   1.370  1.00 73.41           C 
ATOM    305  CG  LYS    20     -15.591   0.446   0.520  1.00 44.14           C 
ATOM    306  CD  LYS    20     -16.956   0.146   1.139  1.00 11.00           C 
ATOM    307  CE  LYS    20     -17.277  -1.344   1.148  1.00  5.44           C 
ATOM    308  NZ  LYS    20     -18.661  -1.611   1.627  1.00 32.10           N 
ATOM    309  H   LYS    20     -12.705  -1.359  -0.461  1.00 38.03           H 
ATOM    310  HA  LYS    20     -13.069   1.391   0.545  1.00 11.12           H 
ATOM    311 1HB  LYS    20     -14.509   0.376   2.356  1.00 40.45           H 
ATOM    312 2HB  LYS    20     -14.479  -1.129   1.447  1.00 15.41           H 
ATOM    313 1HG  LYS    20     -15.537  -0.025  -0.454  1.00 12.12           H 
ATOM    314 2HG  LYS    20     -15.497   1.516   0.400  1.00 50.51           H 
ATOM    315 1HD  LYS    20     -17.716   0.663   0.569  1.00 30.51           H 
ATOM    316 2HD  LYS    20     -16.966   0.509   2.157  1.00 21.12           H 
ATOM    317 1HE  LYS    20     -16.577  -1.846   1.800  1.00 71.53           H 
ATOM    318 2HE  LYS    20     -17.175  -1.732   0.144  1.00 22.23           H 
ATOM    319 1HZ  LYS    20     -19.358  -1.233   0.948  1.00  4.11           H 
ATOM    320 2HZ  LYS    20     -18.816  -1.157   2.547  1.00 21.32           H 
ATOM    321 3HZ  LYS    20     -18.816  -2.632   1.732  1.00 52.21           H 
ATOM    322  N   PHE    21     -11.449   1.175   2.393  1.00 62.24           N 
ATOM    323  CA  PHE    21     -10.276   1.156   3.277  1.00 61.32           C 
ATOM    324  C   PHE    21     -10.481   0.285   4.531  1.00 12.31           C 
ATOM    325  O   PHE    21     -11.577   0.211   5.088  1.00 52.04           O 
ATOM    326  CB  PHE    21      -9.929   2.598   3.688  1.00 11.21           C 
ATOM    327  CG  PHE    21      -8.648   2.729   4.474  1.00  1.24           C 
ATOM    328  CD1 PHE    21      -7.419   2.684   3.831  1.00 42.11           C 
ATOM    329  CD2 PHE    21      -8.673   2.907   5.851  1.00 65.13           C 
ATOM    330  CE1 PHE    21      -6.242   2.812   4.543  1.00 44.33           C 
ATOM    331  CE2 PHE    21      -7.499   3.034   6.568  1.00 52.11           C 
ATOM    332  CZ  PHE    21      -6.282   2.987   5.914  1.00 73.53           C 
ATOM    333  H   PHE    21     -11.911   2.030   2.240  1.00 38.03           H 
ATOM    334  HA  PHE    21      -9.449   0.752   2.712  1.00 25.10           H 
ATOM    335 1HB  PHE    21     -10.732   2.995   4.294  1.00 34.51           H 
ATOM    336 2HB  PHE    21      -9.832   3.200   2.798  1.00 43.41           H 
ATOM    337  HD1 PHE    21      -7.387   2.548   2.760  1.00 14.33           H 
ATOM    338  HD2 PHE    21      -9.623   2.942   6.363  1.00 63.21           H 
ATOM    339  HE1 PHE    21      -5.294   2.773   4.030  1.00 51.24           H 
ATOM    340  HE2 PHE    21      -7.533   3.171   7.639  1.00  4.43           H 
ATOM    341  HZ  PHE    21      -5.364   3.087   6.474  1.00  4.10           H 
ATOM    342  N   SER    22      -9.411  -0.380   4.965  1.00 74.33           N 
ATOM    343  CA  SER    22      -9.423  -1.137   6.227  1.00 11.20           C 
ATOM    344  C   SER    22      -8.311  -0.665   7.171  1.00 14.10           C 
ATOM    345  O   SER    22      -8.586  -0.177   8.268  1.00 71.35           O 
ATOM    346  CB  SER    22      -9.277  -2.644   5.969  1.00  4.33           C 
ATOM    347  OG  SER    22     -10.410  -3.167   5.290  1.00 62.25           O 
ATOM    348  H   SER    22      -8.597  -0.380   4.417  1.00 38.03           H 
ATOM    349  HA  SER    22     -10.377  -0.961   6.709  1.00  1.01           H 
ATOM    350 1HB  SER    22      -9.168  -3.160   6.913  1.00 32.42           H 
ATOM    351 2HB  SER    22      -8.401  -2.821   5.363  1.00 13.22           H 
ATOM    352  HG  SER    22     -10.313  -4.126   5.207  1.00 10.03           H 
ATOM    353  N   ALA    23      -7.057  -0.820   6.746  1.00 13.40           N 
ATOM    354  CA  ALA    23      -5.906  -0.400   7.557  1.00 50.24           C 
ATOM    355  C   ALA    23      -4.646  -0.196   6.702  1.00 35.25           C 
ATOM    356  O   ALA    23      -4.667  -0.374   5.483  1.00 23.23           O 
ATOM    357  CB  ALA    23      -5.635  -1.429   8.651  1.00 33.12           C 
ATOM    358  H   ALA    23      -6.897  -1.225   5.867  1.00 38.03           H 
ATOM    359  HA  ALA    23      -6.160   0.539   8.034  1.00 70.41           H 
ATOM    360 1HB  ALA    23      -6.529  -1.578   9.239  1.00 50.23           H 
ATOM    361 2HB  ALA    23      -4.840  -1.075   9.291  1.00 75.13           H 
ATOM    362 3HB  ALA    23      -5.343  -2.365   8.199  1.00 74.43           H 
ATOM    363  N   LEU    24      -3.554   0.192   7.352  1.00 20.11           N 
ATOM    364  CA  LEU    24      -2.234   0.235   6.715  1.00 23.54           C 
ATOM    365  C   LEU    24      -1.416  -0.989   7.149  1.00 42.12           C 
ATOM    366  O   LEU    24      -0.880  -1.030   8.262  1.00 52.13           O 
ATOM    367  CB  LEU    24      -1.500   1.530   7.091  1.00  1.14           C 
ATOM    368  CG  LEU    24      -0.085   1.686   6.503  1.00 11.45           C 
ATOM    369  CD1 LEU    24      -0.125   1.785   4.978  1.00 32.44           C 
ATOM    370  CD2 LEU    24       0.613   2.900   7.108  1.00 63.32           C 
ATOM    371  H   LEU    24      -3.633   0.460   8.292  1.00 38.03           H 
ATOM    372  HA  LEU    24      -2.373   0.204   5.642  1.00 44.33           H 
ATOM    373 1HB  LEU    24      -1.425   1.574   8.169  1.00 41.40           H 
ATOM    374 2HB  LEU    24      -2.102   2.367   6.760  1.00  1.24           H 
ATOM    375  HG  LEU    24       0.495   0.812   6.757  1.00 72.14           H 
ATOM    376 1HD1 LEU    24      -0.719   2.638   4.685  1.00 64.44           H 
ATOM    377 2HD1 LEU    24      -0.561   0.885   4.567  1.00 65.13           H 
ATOM    378 3HD1 LEU    24       0.881   1.901   4.597  1.00  0.11           H 
ATOM    379 1HD2 LEU    24       0.064   3.797   6.860  1.00 44.42           H 
ATOM    380 2HD2 LEU    24       1.616   2.971   6.713  1.00 12.43           H 
ATOM    381 3HD2 LEU    24       0.659   2.790   8.182  1.00 73.44           H 
ATOM    382  N   ARG    25      -1.339  -1.990   6.279  1.00 42.05           N 
ATOM    383  CA  ARG    25      -0.709  -3.273   6.622  1.00 54.11           C 
ATOM    384  C   ARG    25       0.755  -3.104   7.055  1.00 43.24           C 
ATOM    385  O   ARG    25       1.128  -3.474   8.169  1.00  4.35           O 
ATOM    386  CB  ARG    25      -0.807  -4.243   5.433  1.00  3.12           C 
ATOM    387  CG  ARG    25      -0.213  -5.631   5.689  1.00 25.31           C 
ATOM    388  CD  ARG    25      -0.729  -6.258   6.985  1.00 11.22           C 
ATOM    389  NE  ARG    25      -2.158  -6.034   7.187  1.00 60.15           N 
ATOM    390  CZ  ARG    25      -2.832  -6.474   8.213  1.00 44.21           C 
ATOM    391  NH1 ARG    25      -2.299  -7.304   9.052  1.00 71.12           N 
ATOM    392  NH2 ARG    25      -4.058  -6.104   8.373  1.00  0.55           N 
ATOM    393  H   ARG    25      -1.713  -1.868   5.381  1.00 38.03           H 
ATOM    394  HA  ARG    25      -1.263  -3.691   7.453  1.00 35.01           H 
ATOM    395 1HB  ARG    25      -0.288  -3.806   4.589  1.00 54.14           H 
ATOM    396 2HB  ARG    25      -1.849  -4.366   5.170  1.00 72.51           H 
ATOM    397 1HG  ARG    25       0.864  -5.545   5.746  1.00  3.04           H 
ATOM    398 2HG  ARG    25      -0.474  -6.277   4.864  1.00 41.22           H 
ATOM    399 1HD  ARG    25      -0.185  -5.832   7.817  1.00 21.10           H 
ATOM    400 2HD  ARG    25      -0.548  -7.323   6.949  1.00 11.03           H 
ATOM    401  HE  ARG    25      -2.630  -5.469   6.537  1.00 73.15           H 
ATOM    402 1HH1 ARG    25      -1.360  -7.613   8.922  1.00 24.42           H 
ATOM    403 2HH1 ARG    25      -2.827  -7.625   9.834  1.00 14.31           H 
ATOM    404 1HH2 ARG    25      -4.475  -5.474   7.715  1.00 34.00           H 
ATOM    405 2HH2 ARG    25      -4.584  -6.431   9.156  1.00 31.21           H 
ATOM    406  N   ARG    26       1.576  -2.543   6.175  1.00 23.43           N 
ATOM    407  CA  ARG    26       2.999  -2.362   6.465  1.00 71.24           C 
ATOM    408  C   ARG    26       3.679  -1.465   5.428  1.00 73.33           C 
ATOM    409  O   ARG    26       3.462  -1.613   4.229  1.00 52.22           O 
ATOM    410  CB  ARG    26       3.706  -3.726   6.513  1.00 73.01           C 
ATOM    411  CG  ARG    26       5.213  -3.633   6.727  1.00 21.14           C 
ATOM    412  CD  ARG    26       5.863  -5.009   6.824  1.00 54.54           C 
ATOM    413  NE  ARG    26       7.309  -4.920   7.019  1.00 44.44           N 
ATOM    414  CZ  ARG    26       8.148  -5.886   6.760  1.00 30.43           C 
ATOM    415  NH1 ARG    26       7.717  -7.051   6.387  1.00 33.33           N 
ATOM    416  NH2 ARG    26       9.417  -5.692   6.913  1.00 74.11           N 
ATOM    417  H   ARG    26       1.220  -2.240   5.313  1.00 38.03           H 
ATOM    418  HA  ARG    26       3.080  -1.891   7.434  1.00 50.00           H 
ATOM    419 1HB  ARG    26       3.527  -4.245   5.580  1.00 42.12           H 
ATOM    420 2HB  ARG    26       3.284  -4.306   7.321  1.00 74.05           H 
ATOM    421 1HG  ARG    26       5.402  -3.091   7.640  1.00 52.20           H 
ATOM    422 2HG  ARG    26       5.652  -3.100   5.895  1.00 33.44           H 
ATOM    423 1HD  ARG    26       5.663  -5.557   5.912  1.00 33.04           H 
ATOM    424 2HD  ARG    26       5.433  -5.538   7.662  1.00 14.10           H 
ATOM    425  HE  ARG    26       7.668  -4.072   7.357  1.00 70.33           H 
ATOM    426 1HH1 ARG    26       6.736  -7.213   6.302  1.00 34.54           H 
ATOM    427 2HH1 ARG    26       8.362  -7.783   6.187  1.00 40.30           H 
ATOM    428 1HH2 ARG    26       9.747  -4.806   7.233  1.00 14.51           H 
ATOM    429 2HH2 ARG    26      10.063  -6.421   6.706  1.00 20.25           H 
ATOM    430  N   GLU    27       4.495  -0.530   5.899  1.00 70.42           N 
ATOM    431  CA  GLU    27       5.300   0.310   5.011  1.00 55.44           C 
ATOM    432  C   GLU    27       6.732  -0.237   4.926  1.00 34.15           C 
ATOM    433  O   GLU    27       7.556   0.013   5.809  1.00 11.52           O 
ATOM    434  CB  GLU    27       5.310   1.762   5.519  1.00 52.40           C 
ATOM    435  CG  GLU    27       3.916   2.368   5.648  1.00 52.02           C 
ATOM    436  CD  GLU    27       3.926   3.773   6.233  1.00 15.32           C 
ATOM    437  OE1 GLU    27       3.647   4.734   5.490  1.00 13.11           O 
ATOM    438  OE2 GLU    27       4.206   3.918   7.444  1.00 43.23           O 
ATOM    439  H   GLU    27       4.558  -0.398   6.869  1.00 38.03           H 
ATOM    440  HA  GLU    27       4.856   0.283   4.025  1.00  0.23           H 
ATOM    441 1HB  GLU    27       5.883   2.371   4.833  1.00 41.01           H 
ATOM    442 2HB  GLU    27       5.782   1.789   6.492  1.00 51.23           H 
ATOM    443 1HG  GLU    27       3.321   1.733   6.291  1.00 23.10           H 
ATOM    444 2HG  GLU    27       3.463   2.405   4.668  1.00 51.04           H 
ATOM    445  N   VAL    28       7.018  -0.998   3.867  1.00 44.22           N 
ATOM    446  CA  VAL    28       8.340  -1.609   3.693  1.00 51.31           C 
ATOM    447  C   VAL    28       9.398  -0.539   3.390  1.00 41.00           C 
ATOM    448  O   VAL    28       9.167   0.368   2.587  1.00  3.43           O 
ATOM    449  CB  VAL    28       8.338  -2.692   2.581  1.00 12.33           C 
ATOM    450  CG1 VAL    28       7.398  -3.838   2.949  1.00  4.31           C 
ATOM    451  CG2 VAL    28       7.956  -2.091   1.229  1.00 50.52           C 
ATOM    452  H   VAL    28       6.332  -1.134   3.182  1.00 38.03           H 
ATOM    453  HA  VAL    28       8.601  -2.091   4.629  1.00  4.04           H 
ATOM    454  HB  VAL    28       9.340  -3.094   2.499  1.00 53.41           H 
ATOM    455 1HG1 VAL    28       7.700  -4.263   3.896  1.00 34.25           H 
ATOM    456 2HG1 VAL    28       7.439  -4.600   2.185  1.00  2.32           H 
ATOM    457 3HG1 VAL    28       6.386  -3.465   3.031  1.00  0.32           H 
ATOM    458 1HG2 VAL    28       7.963  -2.865   0.474  1.00 12.01           H 
ATOM    459 2HG2 VAL    28       8.668  -1.323   0.960  1.00 34.13           H 
ATOM    460 3HG2 VAL    28       6.969  -1.657   1.293  1.00 45.13           H 
ATOM    461  N   ARG    29      10.552  -0.644   4.038  1.00 65.11           N 
ATOM    462  CA  ARG    29      11.562   0.415   3.991  1.00 44.03           C 
ATOM    463  C   ARG    29      12.873  -0.043   3.332  1.00 33.34           C 
ATOM    464  O   ARG    29      13.078  -1.227   3.063  1.00 41.20           O 
ATOM    465  CB  ARG    29      11.813   0.933   5.413  1.00 23.24           C 
ATOM    466  CG  ARG    29      10.540   1.442   6.091  1.00  1.20           C 
ATOM    467  CD  ARG    29      10.816   2.069   7.450  1.00 73.53           C 
ATOM    468  NE  ARG    29       9.590   2.569   8.073  1.00 32.04           N 
ATOM    469  CZ  ARG    29       9.551   3.535   8.950  1.00 31.52           C 
ATOM    470  NH1 ARG    29      10.645   4.102   9.349  1.00 40.11           N 
ATOM    471  NH2 ARG    29       8.415   3.926   9.429  1.00 74.23           N 
ATOM    472  H   ARG    29      10.735  -1.454   4.560  1.00 38.03           H 
ATOM    473  HA  ARG    29      11.158   1.225   3.398  1.00 13.21           H 
ATOM    474 1HB  ARG    29      12.524   1.746   5.370  1.00  4.31           H 
ATOM    475 2HB  ARG    29      12.226   0.134   6.013  1.00 71.55           H 
ATOM    476 1HG  ARG    29       9.859   0.611   6.220  1.00 32.33           H 
ATOM    477 2HG  ARG    29      10.081   2.186   5.455  1.00 75.45           H 
ATOM    478 1HD  ARG    29      11.504   2.892   7.319  1.00 43.11           H 
ATOM    479 2HD  ARG    29      11.260   1.326   8.096  1.00 73.10           H 
ATOM    480  HE  ARG    29       8.747   2.154   7.804  1.00 22.33           H 
ATOM    481 1HH1 ARG    29      11.519   3.800   8.989  1.00 73.13           H 
ATOM    482 2HH1 ARG    29      10.610   4.839  10.023  1.00 72.01           H 
ATOM    483 1HH2 ARG    29       7.571   3.486   9.133  1.00 33.41           H 
ATOM    484 2HH2 ARG    29       8.382   4.678  10.088  1.00 63.31           H 
ATOM    485  N   ILE    30      13.754   0.920   3.076  1.00 73.14           N 
ATOM    486  CA  ILE    30      15.016   0.666   2.373  1.00 64.23           C 
ATOM    487  C   ILE    30      16.035  -0.037   3.286  1.00 62.23           C 
ATOM    488  O   ILE    30      16.502   0.538   4.267  1.00 43.02           O 
ATOM    489  CB  ILE    30      15.623   1.994   1.851  1.00 24.30           C 
ATOM    490  CG1 ILE    30      14.569   2.779   1.050  1.00 41.01           C 
ATOM    491  CG2 ILE    30      16.856   1.717   0.989  1.00 23.11           C 
ATOM    492  CD1 ILE    30      14.999   4.179   0.662  1.00 31.33           C 
ATOM    493  H   ILE    30      13.552   1.832   3.373  1.00 38.03           H 
ATOM    494  HA  ILE    30      14.804   0.030   1.522  1.00 75.34           H 
ATOM    495  HB  ILE    30      15.933   2.586   2.703  1.00 24.42           H 
ATOM    496 1HG1 ILE    30      13.668   2.864   1.640  1.00 12.24           H 
ATOM    497 2HG1 ILE    30      14.342   2.244   0.139  1.00  3.52           H 
ATOM    498 1HG2 ILE    30      17.590   1.178   1.570  1.00 42.52           H 
ATOM    499 2HG2 ILE    30      17.281   2.652   0.653  1.00 61.30           H 
ATOM    500 3HG2 ILE    30      16.570   1.124   0.131  1.00 23.31           H 
ATOM    501 1HD1 ILE    30      14.219   4.645   0.078  1.00 63.31           H 
ATOM    502 2HD1 ILE    30      15.907   4.132   0.079  1.00  4.53           H 
ATOM    503 3HD1 ILE    30      15.174   4.762   1.557  1.00 52.23           H 
ATOM    504  N   GLN    31      16.374  -1.282   2.962  1.00  4.21           N 
ATOM    505  CA  GLN    31      17.310  -2.070   3.775  1.00 60.32           C 
ATOM    506  C   GLN    31      18.776  -1.760   3.426  1.00  2.41           C 
ATOM    507  O   GLN    31      19.151  -1.711   2.254  1.00  4.24           O 
ATOM    508  CB  GLN    31      17.027  -3.568   3.587  1.00 11.31           C 
ATOM    509  CG  GLN    31      17.959  -4.483   4.374  1.00 62.12           C 
ATOM    510  CD  GLN    31      17.587  -5.950   4.248  1.00 62.13           C 
ATOM    511  OE1 GLN    31      17.037  -6.384   3.238  1.00 34.24           O 
ATOM    512  NE2 GLN    31      17.878  -6.724   5.271  1.00 63.40           N 
ATOM    513  H   GLN    31      15.981  -1.687   2.161  1.00 38.03           H 
ATOM    514  HA  GLN    31      17.142  -1.816   4.813  1.00 42.34           H 
ATOM    515 1HB  GLN    31      17.124  -3.810   2.537  1.00 15.40           H 
ATOM    516 2HB  GLN    31      16.011  -3.770   3.898  1.00 23.14           H 
ATOM    517 1HG  GLN    31      17.917  -4.204   5.419  1.00 44.43           H 
ATOM    518 2HG  GLN    31      18.967  -4.352   4.010  1.00 70.45           H 
ATOM    519 1HE2 GLN    31      18.308  -6.318   6.052  1.00 10.34           H 
ATOM    520 2HE2 GLN    31      17.658  -7.674   5.205  1.00  1.20           H 
ATOM    521  N   ASN    32      19.605  -1.561   4.454  1.00 61.43           N 
ATOM    522  CA  ASN    32      21.033  -1.276   4.258  1.00 53.10           C 
ATOM    523  C   ASN    32      21.819  -2.572   3.993  1.00  4.14           C 
ATOM    524  O   ASN    32      21.450  -3.640   4.486  1.00  3.33           O 
ATOM    525  CB  ASN    32      21.611  -0.557   5.487  1.00 10.53           C 
ATOM    526  CG  ASN    32      20.880   0.737   5.808  1.00 33.41           C 
ATOM    527  OD1 ASN    32      21.215   1.804   5.303  1.00 33.32           O 
ATOM    528  ND2 ASN    32      19.882   0.657   6.666  1.00  1.53           N 
ATOM    529  H   ASN    32      19.253  -1.621   5.366  1.00 38.03           H 
ATOM    530  HA  ASN    32      21.129  -0.628   3.397  1.00 45.03           H 
ATOM    531 1HB  ASN    32      22.652  -0.326   5.308  1.00 51.23           H 
ATOM    532 2HB  ASN    32      21.538  -1.209   6.345  1.00 43.12           H 
ATOM    533 1HD2 ASN    32      19.666  -0.219   7.043  1.00 25.43           H 
ATOM    534 2HD2 ASN    32      19.405   1.480   6.892  1.00 32.52           H 
ATOM    535  N   GLU    33      22.909  -2.470   3.229  1.00  3.20           N 
ATOM    536  CA  GLU    33      23.714  -3.647   2.860  1.00 64.42           C 
ATOM    537  C   GLU    33      24.241  -4.392   4.094  1.00 63.13           C 
ATOM    538  O   GLU    33      24.360  -5.619   4.089  1.00 60.23           O 
ATOM    539  CB  GLU    33      24.897  -3.235   1.971  1.00 10.22           C 
ATOM    540  CG  GLU    33      24.491  -2.625   0.632  1.00 51.42           C 
ATOM    541  CD  GLU    33      25.688  -2.323  -0.259  1.00 23.33           C 
ATOM    542  OE1 GLU    33      26.138  -3.232  -0.986  1.00 65.51           O 
ATOM    543  OE2 GLU    33      26.192  -1.179  -0.227  1.00 52.55           O 
ATOM    544  H   GLU    33      23.186  -1.585   2.907  1.00 38.03           H 
ATOM    545  HA  GLU    33      23.077  -4.315   2.299  1.00 62.32           H 
ATOM    546 1HB  GLU    33      25.503  -4.109   1.773  1.00 13.11           H 
ATOM    547 2HB  GLU    33      25.496  -2.509   2.503  1.00 41.44           H 
ATOM    548 1HG  GLU    33      23.954  -1.704   0.816  1.00 41.14           H 
ATOM    549 2HG  GLU    33      23.841  -3.319   0.118  1.00 25.22           H 
ATOM    550  N   ASP    34      24.560  -3.641   5.144  1.00 11.03           N 
ATOM    551  CA  ASP    34      25.068  -4.211   6.395  1.00 51.43           C 
ATOM    552  C   ASP    34      24.071  -5.199   7.024  1.00 74.11           C 
ATOM    553  O   ASP    34      24.464  -6.123   7.737  1.00 72.41           O 
ATOM    554  CB  ASP    34      25.376  -3.080   7.380  1.00 43.21           C 
ATOM    555  CG  ASP    34      26.375  -2.088   6.817  1.00 72.13           C 
ATOM    556  OD1 ASP    34      25.997  -1.307   5.919  1.00 53.52           O 
ATOM    557  OD2 ASP    34      27.534  -2.068   7.277  1.00 72.11           O 
ATOM    558  H   ASP    34      24.460  -2.668   5.074  1.00 38.03           H 
ATOM    559  HA  ASP    34      25.984  -4.738   6.171  1.00 24.22           H 
ATOM    560 1HB  ASP    34      25.780  -3.499   8.291  1.00  5.34           H 
ATOM    561 2HB  ASP    34      24.461  -2.551   7.609  1.00 40.13           H 
ATOM    562  N   GLY    35      22.782  -5.000   6.754  1.00 12.34           N 
ATOM    563  CA  GLY    35      21.759  -5.885   7.299  1.00 53.01           C 
ATOM    564  C   GLY    35      20.526  -5.138   7.794  1.00 32.30           C 
ATOM    565  O   GLY    35      19.412  -5.393   7.334  1.00 42.24           O 
ATOM    566  H   GLY    35      22.524  -4.257   6.172  1.00 38.03           H 
ATOM    567 1HA  GLY    35      22.179  -6.444   8.125  1.00 45.53           H 
ATOM    568 2HA  GLY    35      21.460  -6.581   6.529  1.00  5.14           H 
ATOM    569  N   SER    36      20.727  -4.208   8.729  1.00 53.54           N 
ATOM    570  CA  SER    36      19.615  -3.444   9.326  1.00 64.41           C 
ATOM    571  C   SER    36      18.875  -2.583   8.291  1.00  1.02           C 
ATOM    572  O   SER    36      19.461  -2.101   7.318  1.00 72.14           O 
ATOM    573  CB  SER    36      20.117  -2.547  10.467  1.00 61.32           C 
ATOM    574  OG  SER    36      20.658  -3.310  11.536  1.00 44.14           O 
ATOM    575  H   SER    36      21.646  -4.033   9.034  1.00 38.03           H 
ATOM    576  HA  SER    36      18.917  -4.161   9.735  1.00 20.12           H 
ATOM    577 1HB  SER    36      19.292  -1.959  10.844  1.00 51.04           H 
ATOM    578 2HB  SER    36      20.885  -1.885  10.092  1.00 61.34           H 
ATOM    579  HG  SER    36      20.516  -2.838  12.366  1.00 33.21           H 
ATOM    580  N   VAL    37      17.586  -2.374   8.524  1.00 50.21           N 
ATOM    581  CA  VAL    37      16.742  -1.593   7.619  1.00  2.34           C 
ATOM    582  C   VAL    37      16.727  -0.107   8.015  1.00 72.32           C 
ATOM    583  O   VAL    37      16.829   0.234   9.194  1.00 40.44           O 
ATOM    584  CB  VAL    37      15.295  -2.148   7.609  1.00 20.54           C 
ATOM    585  CG1 VAL    37      14.430  -1.426   6.577  1.00 15.04           C 
ATOM    586  CG2 VAL    37      15.310  -3.654   7.353  1.00 41.23           C 
ATOM    587  H   VAL    37      17.182  -2.761   9.332  1.00 38.03           H 
ATOM    588  HA  VAL    37      17.146  -1.685   6.620  1.00 53.44           H 
ATOM    589  HB  VAL    37      14.860  -1.979   8.585  1.00  1.44           H 
ATOM    590 1HG1 VAL    37      14.385  -0.374   6.815  1.00 13.03           H 
ATOM    591 2HG1 VAL    37      13.431  -1.840   6.589  1.00 23.23           H 
ATOM    592 3HG1 VAL    37      14.858  -1.554   5.592  1.00 70.02           H 
ATOM    593 1HG2 VAL    37      15.749  -3.853   6.387  1.00 63.40           H 
ATOM    594 2HG2 VAL    37      14.299  -4.035   7.374  1.00 64.24           H 
ATOM    595 3HG2 VAL    37      15.894  -4.144   8.120  1.00 20.31           H 
ATOM    596  N   SER    38      16.607   0.767   7.021  1.00 51.31           N 
ATOM    597  CA  SER    38      16.623   2.221   7.250  1.00 72.25           C 
ATOM    598  C   SER    38      15.259   2.748   7.710  1.00 65.43           C 
ATOM    599  O   SER    38      14.267   2.016   7.760  1.00 33.54           O 
ATOM    600  CB  SER    38      17.039   2.959   5.968  1.00 62.33           C 
ATOM    601  OG  SER    38      17.008   4.368   6.146  1.00 64.51           O 
ATOM    602  H   SER    38      16.493   0.432   6.107  1.00 38.03           H 
ATOM    603  HA  SER    38      17.352   2.427   8.021  1.00 72.52           H 
ATOM    604 1HB  SER    38      16.360   2.698   5.168  1.00 62.11           H 
ATOM    605 2HB  SER    38      18.044   2.665   5.695  1.00 34.12           H 
ATOM    606  HG  SER    38      17.881   4.736   5.950  1.00  0.41           H 
ATOM    607  N   ASP    39      15.225   4.032   8.045  1.00 55.54           N 
ATOM    608  CA  ASP    39      13.990   4.710   8.437  1.00 15.11           C 
ATOM    609  C   ASP    39      13.254   5.282   7.210  1.00 72.13           C 
ATOM    610  O   ASP    39      12.102   5.710   7.305  1.00 31.44           O 
ATOM    611  CB  ASP    39      14.307   5.817   9.450  1.00 25.44           C 
ATOM    612  CG  ASP    39      15.365   6.788   8.949  1.00 25.22           C 
ATOM    613  OD1 ASP    39      16.535   6.372   8.788  1.00  1.12           O 
ATOM    614  OD2 ASP    39      15.039   7.970   8.723  1.00 64.33           O 
ATOM    615  H   ASP    39      16.062   4.546   8.027  1.00 38.03           H 
ATOM    616  HA  ASP    39      13.349   3.980   8.911  1.00  2.51           H 
ATOM    617 1HB  ASP    39      14.666   5.365  10.364  1.00 13.25           H 
ATOM    618 2HB  ASP    39      13.404   6.371   9.665  1.00 54.23           H 
ATOM    619  N   GLU    40      13.927   5.272   6.057  1.00  4.12           N 
ATOM    620  CA  GLU    40      13.331   5.738   4.797  1.00 62.14           C 
ATOM    621  C   GLU    40      12.461   4.657   4.142  1.00 71.23           C 
ATOM    622  O   GLU    40      12.790   3.470   4.172  1.00 50.15           O 
ATOM    623  CB  GLU    40      14.426   6.199   3.827  1.00 42.32           C 
ATOM    624  CG  GLU    40      15.109   7.495   4.249  1.00 12.15           C 
ATOM    625  CD  GLU    40      14.145   8.672   4.311  1.00 54.34           C 
ATOM    626  OE1 GLU    40      13.903   9.306   3.263  1.00 55.13           O 
ATOM    627  OE2 GLU    40      13.616   8.962   5.405  1.00 14.55           O 
ATOM    628  H   GLU    40      14.854   4.947   6.053  1.00 38.03           H 
ATOM    629  HA  GLU    40      12.698   6.586   5.031  1.00  1.34           H 
ATOM    630 1HB  GLU    40      13.990   6.348   2.848  1.00  3.34           H 
ATOM    631 2HB  GLU    40      15.180   5.425   3.761  1.00 65.01           H 
ATOM    632 1HG  GLU    40      15.891   7.722   3.539  1.00 60.31           H 
ATOM    633 2HG  GLU    40      15.544   7.352   5.227  1.00 11.34           H 
ATOM    634  N   ILE    41      11.370   5.088   3.518  1.00 53.25           N 
ATOM    635  CA  ILE    41      10.355   4.172   2.978  1.00 24.45           C 
ATOM    636  C   ILE    41      10.710   3.673   1.562  1.00 13.22           C 
ATOM    637  O   ILE    41      11.418   4.344   0.812  1.00 52.43           O 
ATOM    638  CB  ILE    41       8.964   4.863   2.925  1.00 31.23           C 
ATOM    639  CG1 ILE    41       8.601   5.481   4.288  1.00  1.23           C 
ATOM    640  CG2 ILE    41       7.879   3.872   2.489  1.00  0.44           C 
ATOM    641  CD1 ILE    41       8.314   4.464   5.372  1.00 34.44           C 
ATOM    642  H   ILE    41      11.247   6.057   3.405  1.00 38.03           H 
ATOM    643  HA  ILE    41      10.283   3.321   3.643  1.00  3.11           H 
ATOM    644  HB  ILE    41       9.011   5.651   2.185  1.00 23.44           H 
ATOM    645 1HG1 ILE    41       7.720   6.097   4.171  1.00 11.52           H 
ATOM    646 2HG1 ILE    41       9.420   6.100   4.626  1.00 65.22           H 
ATOM    647 1HG2 ILE    41       7.852   3.042   3.181  1.00 73.41           H 
ATOM    648 2HG2 ILE    41       8.101   3.506   1.497  1.00 60.22           H 
ATOM    649 3HG2 ILE    41       6.919   4.368   2.481  1.00 71.22           H 
ATOM    650 1HD1 ILE    41       9.166   3.808   5.490  1.00 53.12           H 
ATOM    651 2HD1 ILE    41       7.445   3.883   5.097  1.00 64.35           H 
ATOM    652 3HD1 ILE    41       8.124   4.976   6.303  1.00 11.23           H 
ATOM    653  N   LYS    42      10.209   2.488   1.209  1.00 13.55           N 
ATOM    654  CA  LYS    42      10.345   1.945  -0.149  1.00 24.51           C 
ATOM    655  C   LYS    42       8.960   1.853  -0.825  1.00 22.30           C 
ATOM    656  O   LYS    42       8.732   2.441  -1.884  1.00 24.53           O 
ATOM    657  CB  LYS    42      11.014   0.562  -0.102  1.00 24.33           C 
ATOM    658  CG  LYS    42      11.343  -0.016  -1.475  1.00 62.14           C 
ATOM    659  CD  LYS    42      12.324   0.870  -2.240  1.00 33.01           C 
ATOM    660  CE  LYS    42      12.662   0.300  -3.609  1.00 60.32           C 
ATOM    661  NZ  LYS    42      13.573   1.196  -4.369  1.00 72.54           N 
ATOM    662  H   LYS    42       9.731   1.962   1.883  1.00 38.03           H 
ATOM    663  HA  LYS    42      10.969   2.622  -0.721  1.00 72.43           H 
ATOM    664 1HB  LYS    42      10.352  -0.128   0.406  1.00 62.41           H 
ATOM    665 2HB  LYS    42      11.934   0.638   0.462  1.00 11.51           H 
ATOM    666 1HG  LYS    42      10.429  -0.103  -2.046  1.00 31.10           H 
ATOM    667 2HG  LYS    42      11.782  -0.996  -1.348  1.00 43.35           H 
ATOM    668 1HD  LYS    42      13.235   0.962  -1.663  1.00 70.42           H 
ATOM    669 2HD  LYS    42      11.883   1.848  -2.371  1.00 43.50           H 
ATOM    670 1HE  LYS    42      11.747   0.169  -4.170  1.00 25.12           H 
ATOM    671 2HE  LYS    42      13.145  -0.659  -3.478  1.00  0.15           H 
ATOM    672 1HZ  LYS    42      14.465   1.328  -3.851  1.00 32.04           H 
ATOM    673 2HZ  LYS    42      13.130   2.126  -4.508  1.00 31.13           H 
ATOM    674 3HZ  LYS    42      13.786   0.786  -5.299  1.00 43.43           H 
ATOM    675  N   GLU    43       8.043   1.109  -0.197  1.00 64.02           N 
ATOM    676  CA  GLU    43       6.634   1.039  -0.625  1.00 41.54           C 
ATOM    677  C   GLU    43       5.694   1.002   0.592  1.00 53.40           C 
ATOM    678  O   GLU    43       6.114   0.671   1.703  1.00 51.32           O 
ATOM    679  CB  GLU    43       6.377  -0.200  -1.501  1.00 32.35           C 
ATOM    680  CG  GLU    43       7.136  -0.198  -2.820  1.00 35.30           C 
ATOM    681  CD  GLU    43       6.641  -1.263  -3.794  1.00 33.11           C 
ATOM    682  OE1 GLU    43       7.330  -2.290  -3.965  1.00 42.54           O 
ATOM    683  OE2 GLU    43       5.554  -1.083  -4.391  1.00 72.45           O 
ATOM    684  H   GLU    43       8.319   0.584   0.576  1.00 38.03           H 
ATOM    685  HA  GLU    43       6.417   1.927  -1.203  1.00 15.30           H 
ATOM    686 1HB  GLU    43       5.318  -0.256  -1.721  1.00 54.03           H 
ATOM    687 2HB  GLU    43       6.663  -1.084  -0.948  1.00 72.25           H 
ATOM    688 1HG  GLU    43       8.184  -0.372  -2.616  1.00 30.51           H 
ATOM    689 2HG  GLU    43       7.023   0.773  -3.276  1.00 71.51           H 
ATOM    690  N   ARG    44       4.422   1.338   0.381  1.00 35.34           N 
ATOM    691  CA  ARG    44       3.419   1.317   1.457  1.00 73.22           C 
ATOM    692  C   ARG    44       2.285   0.326   1.132  1.00 31.44           C 
ATOM    693  O   ARG    44       1.563   0.500   0.150  1.00 74.32           O 
ATOM    694  CB  ARG    44       2.831   2.721   1.672  1.00 75.45           C 
ATOM    695  CG  ARG    44       3.879   3.821   1.843  1.00 55.22           C 
ATOM    696  CD  ARG    44       3.234   5.163   2.173  1.00 42.23           C 
ATOM    697  NE  ARG    44       4.183   6.277   2.093  1.00 60.31           N 
ATOM    698  CZ  ARG    44       4.378   7.152   3.048  1.00 64.32           C 
ATOM    699  NH1 ARG    44       3.842   6.986   4.211  1.00  3.41           N 
ATOM    700  NH2 ARG    44       5.145   8.174   2.847  1.00 25.25           N 
ATOM    701  H   ARG    44       4.147   1.604  -0.522  1.00 38.03           H 
ATOM    702  HA  ARG    44       3.910   1.000   2.366  1.00 32.01           H 
ATOM    703 1HB  ARG    44       2.212   2.703   2.558  1.00 61.32           H 
ATOM    704 2HB  ARG    44       2.212   2.975   0.822  1.00 44.33           H 
ATOM    705 1HG  ARG    44       4.441   3.916   0.924  1.00 11.35           H 
ATOM    706 2HG  ARG    44       4.546   3.548   2.648  1.00 53.45           H 
ATOM    707 1HD  ARG    44       2.829   5.114   3.174  1.00 53.14           H 
ATOM    708 2HD  ARG    44       2.431   5.342   1.472  1.00 12.03           H 
ATOM    709  HE  ARG    44       4.665   6.396   1.256  1.00 54.34           H 
ATOM    710 1HH1 ARG    44       3.278   6.181   4.391  1.00 41.03           H 
ATOM    711 2HH1 ARG    44       4.000   7.656   4.936  1.00 63.20           H 
ATOM    712 1HH2 ARG    44       5.588   8.301   1.964  1.00 33.45           H 
ATOM    713 2HH2 ARG    44       5.289   8.839   3.579  1.00 12.11           H 
ATOM    714  N   THR    45       2.131  -0.705   1.962  1.00  2.33           N 
ATOM    715  CA  THR    45       1.095  -1.733   1.748  1.00 51.21           C 
ATOM    716  C   THR    45      -0.178  -1.446   2.568  1.00 53.41           C 
ATOM    717  O   THR    45      -0.132  -1.365   3.800  1.00 11.32           O 
ATOM    718  CB  THR    45       1.618  -3.144   2.123  1.00 23.32           C 
ATOM    719  OG1 THR    45       2.821  -3.437   1.391  1.00 54.35           O 
ATOM    720  CG2 THR    45       0.570  -4.219   1.835  1.00 35.04           C 
ATOM    721  H   THR    45       2.728  -0.783   2.735  1.00 38.03           H 
ATOM    722  HA  THR    45       0.841  -1.737   0.696  1.00 73.20           H 
ATOM    723  HB  THR    45       1.844  -3.155   3.182  1.00 61.14           H 
ATOM    724  HG1 THR    45       2.946  -2.779   0.697  1.00 53.41           H 
ATOM    725 1HG2 THR    45       0.295  -4.184   0.790  1.00 41.03           H 
ATOM    726 2HG2 THR    45      -0.306  -4.043   2.441  1.00 15.34           H 
ATOM    727 3HG2 THR    45       0.978  -5.192   2.067  1.00 54.51           H 
ATOM    728  N   TYR    46      -1.311  -1.306   1.878  1.00 63.40           N 
ATOM    729  CA  TYR    46      -2.603  -1.018   2.522  1.00 72.32           C 
ATOM    730  C   TYR    46      -3.548  -2.233   2.489  1.00  1.04           C 
ATOM    731  O   TYR    46      -3.463  -3.086   1.601  1.00 65.01           O 
ATOM    732  CB  TYR    46      -3.298   0.155   1.816  1.00 33.02           C 
ATOM    733  CG  TYR    46      -2.516   1.455   1.830  1.00  4.10           C 
ATOM    734  CD1 TYR    46      -2.855   2.484   2.700  1.00 12.21           C 
ATOM    735  CD2 TYR    46      -1.453   1.658   0.960  1.00 21.03           C 
ATOM    736  CE1 TYR    46      -2.159   3.678   2.701  1.00 10.35           C 
ATOM    737  CE2 TYR    46      -0.750   2.843   0.957  1.00 52.54           C 
ATOM    738  CZ  TYR    46      -1.106   3.853   1.827  1.00 10.33           C 
ATOM    739  OH  TYR    46      -0.407   5.041   1.821  1.00  1.03           O 
ATOM    740  H   TYR    46      -1.282  -1.396   0.904  1.00 38.03           H 
ATOM    741  HA  TYR    46      -2.415  -0.746   3.554  1.00 75.12           H 
ATOM    742 1HB  TYR    46      -4.251   0.339   2.295  1.00 43.31           H 
ATOM    743 2HB  TYR    46      -3.471  -0.110   0.785  1.00  4.15           H 
ATOM    744  HD1 TYR    46      -3.675   2.338   3.388  1.00 54.12           H 
ATOM    745  HD2 TYR    46      -1.174   0.867   0.278  1.00 51.41           H 
ATOM    746  HE1 TYR    46      -2.439   4.465   3.385  1.00 41.21           H 
ATOM    747  HE2 TYR    46       0.076   2.978   0.272  1.00 62.02           H 
ATOM    748  HH  TYR    46      -0.182   5.274   0.916  1.00 21.43           H 
ATOM    749  N   ASP    47      -4.462  -2.282   3.457  1.00 31.32           N 
ATOM    750  CA  ASP    47      -5.517  -3.300   3.502  1.00 25.41           C 
ATOM    751  C   ASP    47      -6.825  -2.755   2.903  1.00 60.53           C 
ATOM    752  O   ASP    47      -7.443  -1.849   3.471  1.00 74.55           O 
ATOM    753  CB  ASP    47      -5.774  -3.726   4.954  1.00 32.23           C 
ATOM    754  CG  ASP    47      -4.574  -4.384   5.604  1.00 12.14           C 
ATOM    755  OD1 ASP    47      -4.023  -5.341   5.025  1.00 62.03           O 
ATOM    756  OD2 ASP    47      -4.175  -3.950   6.701  1.00 32.00           O 
ATOM    757  H   ASP    47      -4.426  -1.613   4.169  1.00 38.03           H 
ATOM    758  HA  ASP    47      -5.190  -4.160   2.930  1.00 74.10           H 
ATOM    759 1HB  ASP    47      -6.598  -4.426   4.975  1.00  4.43           H 
ATOM    760 2HB  ASP    47      -6.040  -2.851   5.533  1.00 73.22           H 
ATOM    761  N   LEU    48      -7.242  -3.297   1.759  1.00 63.31           N 
ATOM    762  CA  LEU    48      -8.516  -2.901   1.136  1.00 15.53           C 
ATOM    763  C   LEU    48      -9.430  -4.118   0.918  1.00 15.41           C 
ATOM    764  O   LEU    48      -8.972  -5.181   0.492  1.00 61.30           O 
ATOM    765  CB  LEU    48      -8.266  -2.205  -0.215  1.00 55.31           C 
ATOM    766  CG  LEU    48      -7.406  -0.929  -0.171  1.00 71.53           C 
ATOM    767  CD1 LEU    48      -7.264  -0.321  -1.566  1.00 41.21           C 
ATOM    768  CD2 LEU    48      -7.992   0.096   0.794  1.00 60.44           C 
ATOM    769  H   LEU    48      -6.681  -3.975   1.318  1.00 38.03           H 
ATOM    770  HA  LEU    48      -9.011  -2.207   1.802  1.00 51.14           H 
ATOM    771 1HB  LEU    48      -9.225  -1.951  -0.647  1.00 54.13           H 
ATOM    772 2HB  LEU    48      -7.778  -2.915  -0.870  1.00  3.21           H 
ATOM    773  HG  LEU    48      -6.416  -1.187   0.178  1.00 70.10           H 
ATOM    774 1HD1 LEU    48      -8.239  -0.045  -1.942  1.00  2.34           H 
ATOM    775 2HD1 LEU    48      -6.813  -1.043  -2.231  1.00 23.03           H 
ATOM    776 3HD1 LEU    48      -6.638   0.557  -1.513  1.00 65.21           H 
ATOM    777 1HD2 LEU    48      -8.034  -0.325   1.788  1.00 40.34           H 
ATOM    778 2HD2 LEU    48      -8.990   0.368   0.476  1.00 42.23           H 
ATOM    779 3HD2 LEU    48      -7.368   0.979   0.805  1.00  5.44           H 
ATOM    780  N   LYS    49     -10.724  -3.965   1.212  1.00 45.14           N 
ATOM    781  CA  LYS    49     -11.701  -5.024   0.924  1.00 60.20           C 
ATOM    782  C   LYS    49     -12.439  -4.729  -0.389  1.00 45.21           C 
ATOM    783  O   LYS    49     -12.771  -3.578  -0.681  1.00 44.14           O 
ATOM    784  CB  LYS    49     -12.718  -5.194   2.071  1.00 72.24           C 
ATOM    785  CG  LYS    49     -13.657  -4.002   2.281  1.00 52.03           C 
ATOM    786  CD  LYS    49     -13.239  -3.123   3.457  1.00  0.15           C 
ATOM    787  CE  LYS    49     -13.415  -3.841   4.792  1.00 40.23           C 
ATOM    788  NZ  LYS    49     -13.027  -2.978   5.936  1.00 22.05           N 
ATOM    789  H   LYS    49     -11.029  -3.123   1.615  1.00 38.03           H 
ATOM    790  HA  LYS    49     -11.154  -5.950   0.805  1.00  4.43           H 
ATOM    791 1HB  LYS    49     -12.173  -5.366   2.990  1.00 70.24           H 
ATOM    792 2HB  LYS    49     -13.324  -6.065   1.864  1.00  1.45           H 
ATOM    793 1HG  LYS    49     -14.656  -4.376   2.463  1.00 50.34           H 
ATOM    794 2HG  LYS    49     -13.662  -3.400   1.386  1.00 51.42           H 
ATOM    795 1HD  LYS    49     -13.846  -2.228   3.456  1.00 45.23           H 
ATOM    796 2HD  LYS    49     -12.199  -2.849   3.340  1.00 75.20           H 
ATOM    797 1HE  LYS    49     -12.796  -4.728   4.798  1.00  3.20           H 
ATOM    798 2HE  LYS    49     -14.451  -4.124   4.905  1.00 40.24           H 
ATOM    799 1HZ  LYS    49     -12.022  -2.724   5.863  1.00 73.11           H 
ATOM    800 2HZ  LYS    49     -13.184  -3.480   6.836  1.00 24.12           H 
ATOM    801 3HZ  LYS    49     -13.597  -2.107   5.936  1.00 11.23           H 
ATOM    802  N   SER    50     -12.682  -5.772  -1.180  1.00 73.12           N 
ATOM    803  CA  SER    50     -13.362  -5.624  -2.472  1.00 55.40           C 
ATOM    804  C   SER    50     -14.506  -6.635  -2.624  1.00  4.21           C 
ATOM    805  O   SER    50     -14.462  -7.735  -2.070  1.00 24.42           O 
ATOM    806  CB  SER    50     -12.362  -5.795  -3.624  1.00  3.55           C 
ATOM    807  OG  SER    50     -11.766  -7.084  -3.604  1.00 20.51           O 
ATOM    808  H   SER    50     -12.396  -6.665  -0.893  1.00 38.03           H 
ATOM    809  HA  SER    50     -13.777  -4.626  -2.519  1.00 41.42           H 
ATOM    810 1HB  SER    50     -11.584  -5.052  -3.531  1.00  3.22           H 
ATOM    811 2HB  SER    50     -12.872  -5.663  -4.567  1.00 20.24           H 
ATOM    812  HG  SER    50     -10.889  -7.030  -3.214  1.00 13.21           H 
ATOM    813  N   LYS    51     -15.541  -6.248  -3.366  1.00 54.32           N 
ATOM    814  CA  LYS    51     -16.681  -7.133  -3.628  1.00  1.12           C 
ATOM    815  C   LYS    51     -16.364  -8.142  -4.744  1.00 34.41           C 
ATOM    816  O   LYS    51     -16.046  -7.757  -5.871  1.00  1.12           O 
ATOM    817  CB  LYS    51     -17.921  -6.312  -4.013  1.00 64.33           C 
ATOM    818  CG  LYS    51     -18.490  -5.466  -2.878  1.00 72.11           C 
ATOM    819  CD  LYS    51     -18.936  -6.328  -1.697  1.00 41.12           C 
ATOM    820  CE  LYS    51     -19.703  -5.518  -0.655  1.00 62.12           C 
ATOM    821  NZ  LYS    51     -20.944  -4.916  -1.218  1.00 60.35           N 
ATOM    822  H   LYS    51     -15.537  -5.348  -3.748  1.00 38.03           H 
ATOM    823  HA  LYS    51     -16.892  -7.678  -2.718  1.00 70.32           H 
ATOM    824 1HB  LYS    51     -18.695  -6.988  -4.348  1.00 22.25           H 
ATOM    825 2HB  LYS    51     -17.662  -5.651  -4.829  1.00 60.44           H 
ATOM    826 1HG  LYS    51     -19.339  -4.909  -3.248  1.00 55.11           H 
ATOM    827 2HG  LYS    51     -17.730  -4.776  -2.539  1.00 22.35           H 
ATOM    828 1HD  LYS    51     -18.062  -6.763  -1.230  1.00 72.31           H 
ATOM    829 2HD  LYS    51     -19.578  -7.116  -2.064  1.00 35.21           H 
ATOM    830 1HE  LYS    51     -19.064  -4.728  -0.286  1.00  4.21           H 
ATOM    831 2HE  LYS    51     -19.971  -6.170   0.162  1.00 32.54           H 
ATOM    832 1HZ  LYS    51     -20.705  -4.244  -1.977  1.00 52.15           H 
ATOM    833 2HZ  LYS    51     -21.465  -4.408  -0.474  1.00 35.32           H 
ATOM    834 3HZ  LYS    51     -21.561  -5.656  -1.608  1.00 55.44           H 
ATOM    835  N   GLY    52     -16.464  -9.431  -4.428  1.00 34.23           N 
ATOM    836  CA  GLY    52     -16.205 -10.473  -5.419  1.00  2.21           C 
ATOM    837  C   GLY    52     -15.995 -11.851  -4.797  1.00 23.21           C 
ATOM    838  O   GLY    52     -16.958 -12.542  -4.457  1.00 52.40           O 
ATOM    839  H   GLY    52     -16.714  -9.679  -3.513  1.00 38.03           H 
ATOM    840 1HA  GLY    52     -15.322 -10.208  -5.982  1.00 64.35           H 
ATOM    841 2HA  GLY    52     -17.046 -10.523  -6.095  1.00 61.13           H 
ATOM    842  N   GLN    53     -14.735 -12.243  -4.632  1.00 43.02           N 
ATOM    843  CA  GLN    53     -14.388 -13.566  -4.093  1.00 50.23           C 
ATOM    844  C   GLN    53     -14.193 -13.535  -2.566  1.00 54.42           C 
ATOM    845  O   GLN    53     -13.922 -14.567  -1.947  1.00  0.02           O 
ATOM    846  CB  GLN    53     -13.117 -14.090  -4.779  1.00  1.44           C 
ATOM    847  CG  GLN    53     -13.237 -14.208  -6.297  1.00  3.50           C 
ATOM    848  CD  GLN    53     -14.342 -15.159  -6.732  1.00  3.52           C 
ATOM    849  OE1 GLN    53     -15.487 -14.762  -6.924  1.00 34.45           O 
ATOM    850  NE2 GLN    53     -14.010 -16.423  -6.889  1.00 52.20           N 
ATOM    851  H   GLN    53     -14.014 -11.629  -4.887  1.00 38.03           H 
ATOM    852  HA  GLN    53     -15.204 -14.237  -4.321  1.00 51.12           H 
ATOM    853 1HB  GLN    53     -12.882 -15.067  -4.382  1.00 55.22           H 
ATOM    854 2HB  GLN    53     -12.300 -13.417  -4.559  1.00  4.31           H 
ATOM    855 1HG  GLN    53     -12.297 -14.566  -6.692  1.00 24.50           H 
ATOM    856 2HG  GLN    53     -13.445 -13.229  -6.707  1.00 43.21           H 
ATOM    857 1HE2 GLN    53     -13.083 -16.684  -6.720  1.00 64.02           H 
ATOM    858 2HE2 GLN    53     -14.708 -17.048  -7.171  1.00 22.54           H 
ATOM    859  N   GLY    54     -14.331 -12.351  -1.966  1.00 41.33           N 
ATOM    860  CA  GLY    54     -14.203 -12.217  -0.513  1.00 14.14           C 
ATOM    861  C   GLY    54     -12.756 -12.235  -0.023  1.00 21.44           C 
ATOM    862  O   GLY    54     -12.461 -12.750   1.059  1.00 50.42           O 
ATOM    863  H   GLY    54     -14.528 -11.561  -2.511  1.00 38.03           H 
ATOM    864 1HA  GLY    54     -14.742 -13.026  -0.039  1.00 55.31           H 
ATOM    865 2HA  GLY    54     -14.654 -11.283  -0.212  1.00 22.41           H 
ATOM    866  N   ARG    55     -11.850 -11.667  -0.813  1.00 32.52           N 
ATOM    867  CA  ARG    55     -10.428 -11.619  -0.454  1.00 23.45           C 
ATOM    868  C   ARG    55      -9.956 -10.192  -0.130  1.00 43.42           C 
ATOM    869  O   ARG    55     -10.187  -9.258  -0.898  1.00 31.52           O 
ATOM    870  CB  ARG    55      -9.573 -12.210  -1.588  1.00 13.52           C 
ATOM    871  CG  ARG    55      -9.421 -13.730  -1.529  1.00 73.50           C 
ATOM    872  CD  ARG    55      -8.607 -14.163  -0.311  1.00  0.04           C 
ATOM    873  NE  ARG    55      -8.364 -15.604  -0.283  1.00 34.53           N 
ATOM    874  CZ  ARG    55      -7.361 -16.163   0.344  1.00 41.42           C 
ATOM    875  NH1 ARG    55      -6.504 -15.446   0.992  1.00 32.23           N 
ATOM    876  NH2 ARG    55      -7.222 -17.445   0.325  1.00  3.32           N 
ATOM    877  H   ARG    55     -12.140 -11.270  -1.661  1.00 38.03           H 
ATOM    878  HA  ARG    55     -10.293 -12.229   0.430  1.00  4.20           H 
ATOM    879 1HB  ARG    55      -8.584 -11.771  -1.548  1.00 62.35           H 
ATOM    880 2HB  ARG    55     -10.026 -11.953  -2.534  1.00 33.23           H 
ATOM    881 1HG  ARG    55      -8.917 -14.066  -2.424  1.00  1.41           H 
ATOM    882 2HG  ARG    55     -10.401 -14.183  -1.476  1.00 44.10           H 
ATOM    883 1HD  ARG    55      -9.144 -13.881   0.584  1.00 72.10           H 
ATOM    884 2HD  ARG    55      -7.655 -13.650  -0.332  1.00 63.33           H 
ATOM    885  HE  ARG    55      -8.996 -16.181  -0.756  1.00 12.01           H 
ATOM    886 1HH1 ARG    55      -6.602 -14.455   1.023  1.00 52.24           H 
ATOM    887 2HH1 ARG    55      -5.738 -15.887   1.461  1.00 20.33           H 
ATOM    888 1HH2 ARG    55      -7.882 -18.007  -0.169  1.00 60.20           H 
ATOM    889 2HH2 ARG    55      -6.459 -17.868   0.804  1.00 51.33           H 
ATOM    890  N   MET    56      -9.301 -10.035   1.020  1.00 44.22           N 
ATOM    891  CA  MET    56      -8.649  -8.768   1.371  1.00 42.10           C 
ATOM    892  C   MET    56      -7.379  -8.578   0.524  1.00 21.21           C 
ATOM    893  O   MET    56      -6.450  -9.382   0.592  1.00 62.50           O 
ATOM    894  CB  MET    56      -8.321  -8.727   2.875  1.00  5.31           C 
ATOM    895  CG  MET    56      -7.436  -9.873   3.359  1.00 21.35           C 
ATOM    896  SD  MET    56      -7.092  -9.790   5.133  1.00 63.43           S 
ATOM    897  CE  MET    56      -8.743  -9.946   5.817  1.00 72.51           C 
ATOM    898  H   MET    56      -9.257 -10.786   1.648  1.00 38.03           H 
ATOM    899  HA  MET    56      -9.342  -7.968   1.143  1.00 13.40           H 
ATOM    900 1HB  MET    56      -9.247  -8.759   3.431  1.00 42.31           H 
ATOM    901 2HB  MET    56      -7.816  -7.797   3.097  1.00 33.11           H 
ATOM    902 1HG  MET    56      -6.499  -9.838   2.824  1.00 20.23           H 
ATOM    903 2HG  MET    56      -7.934 -10.810   3.146  1.00 33.22           H 
ATOM    904 1HE  MET    56      -9.365  -9.140   5.452  1.00 54.42           H 
ATOM    905 2HE  MET    56      -8.693  -9.898   6.896  1.00 70.41           H 
ATOM    906 3HE  MET    56      -9.169 -10.892   5.518  1.00 21.44           H 
ATOM    907  N   ILE    57      -7.343  -7.519  -0.275  1.00 44.11           N 
ATOM    908  CA  ILE    57      -6.249  -7.320  -1.230  1.00  1.30           C 
ATOM    909  C   ILE    57      -5.142  -6.424  -0.656  1.00 62.51           C 
ATOM    910  O   ILE    57      -5.417  -5.421   0.010  1.00 61.12           O 
ATOM    911  CB  ILE    57      -6.767  -6.715  -2.562  1.00 34.42           C 
ATOM    912  CG1 ILE    57      -7.395  -5.326  -2.336  1.00 41.25           C 
ATOM    913  CG2 ILE    57      -7.776  -7.662  -3.216  1.00 71.41           C 
ATOM    914  CD1 ILE    57      -7.899  -4.667  -3.606  1.00 60.11           C 
ATOM    915  H   ILE    57      -8.059  -6.850  -0.219  1.00 38.03           H 
ATOM    916  HA  ILE    57      -5.822  -8.291  -1.451  1.00  1.23           H 
ATOM    917  HB  ILE    57      -5.925  -6.616  -3.233  1.00 62.55           H 
ATOM    918 1HG1 ILE    57      -6.653  -4.671  -1.898  1.00 53.21           H 
ATOM    919 2HG1 ILE    57      -8.230  -5.416  -1.658  1.00 43.10           H 
ATOM    920 1HG2 ILE    57      -8.603  -7.834  -2.541  1.00  4.15           H 
ATOM    921 2HG2 ILE    57      -7.296  -8.603  -3.441  1.00 61.11           H 
ATOM    922 3HG2 ILE    57      -8.146  -7.222  -4.132  1.00 22.41           H 
ATOM    923 1HD1 ILE    57      -8.330  -3.707  -3.366  1.00 64.34           H 
ATOM    924 2HD1 ILE    57      -8.651  -5.294  -4.065  1.00 32.33           H 
ATOM    925 3HD1 ILE    57      -7.076  -4.531  -4.292  1.00  1.20           H 
ATOM    926  N   GLN    58      -3.888  -6.804  -0.904  1.00 75.55           N 
ATOM    927  CA  GLN    58      -2.741  -6.021  -0.436  1.00 32.25           C 
ATOM    928  C   GLN    58      -2.276  -5.031  -1.512  1.00 23.44           C 
ATOM    929  O   GLN    58      -1.633  -5.417  -2.485  1.00 52.52           O 
ATOM    930  CB  GLN    58      -1.591  -6.967  -0.058  1.00 34.13           C 
ATOM    931  CG  GLN    58      -1.957  -7.971   1.032  1.00 64.23           C 
ATOM    932  CD  GLN    58      -2.190  -7.316   2.386  1.00 74.11           C 
ATOM    933  OE1 GLN    58      -1.273  -7.190   3.189  1.00 51.23           O 
ATOM    934  NE2 GLN    58      -3.409  -6.889   2.648  1.00 43.25           N 
ATOM    935  H   GLN    58      -3.727  -7.636  -1.410  1.00 38.03           H 
ATOM    936  HA  GLN    58      -3.044  -5.469   0.443  1.00  0.12           H 
ATOM    937 1HB  GLN    58      -0.754  -6.377   0.291  1.00 54.15           H 
ATOM    938 2HB  GLN    58      -1.288  -7.516  -0.939  1.00 73.12           H 
ATOM    939 1HG  GLN    58      -1.152  -8.688   1.130  1.00 24.40           H 
ATOM    940 2HG  GLN    58      -2.859  -8.489   0.739  1.00 52.32           H 
ATOM    941 1HE2 GLN    58      -4.102  -7.014   1.972  1.00  1.33           H 
ATOM    942 2HE2 GLN    58      -3.564  -6.449   3.513  1.00 22.43           H 
ATOM    943  N   VAL    59      -2.591  -3.753  -1.326  1.00  4.45           N 
ATOM    944  CA  VAL    59      -2.241  -2.718  -2.309  1.00 30.25           C 
ATOM    945  C   VAL    59      -0.965  -1.968  -1.905  1.00 20.54           C 
ATOM    946  O   VAL    59      -0.931  -1.287  -0.884  1.00 23.02           O 
ATOM    947  CB  VAL    59      -3.397  -1.702  -2.495  1.00 73.23           C 
ATOM    948  CG1 VAL    59      -3.020  -0.613  -3.503  1.00 53.41           C 
ATOM    949  CG2 VAL    59      -4.672  -2.424  -2.926  1.00 53.45           C 
ATOM    950  H   VAL    59      -3.072  -3.496  -0.509  1.00 38.03           H 
ATOM    951  HA  VAL    59      -2.069  -3.207  -3.259  1.00 21.45           H 
ATOM    952  HB  VAL    59      -3.585  -1.225  -1.541  1.00 43.44           H 
ATOM    953 1HG1 VAL    59      -2.152  -0.076  -3.149  1.00 23.35           H 
ATOM    954 2HG1 VAL    59      -3.844   0.075  -3.617  1.00  3.51           H 
ATOM    955 3HG1 VAL    59      -2.797  -1.067  -4.459  1.00 34.40           H 
ATOM    956 1HG2 VAL    59      -4.507  -2.916  -3.874  1.00 22.54           H 
ATOM    957 2HG2 VAL    59      -5.477  -1.709  -3.027  1.00 14.30           H 
ATOM    958 3HG2 VAL    59      -4.939  -3.160  -2.180  1.00 54.44           H 
ATOM    959  N   SER    60       0.079  -2.093  -2.720  1.00 30.53           N 
ATOM    960  CA  SER    60       1.375  -1.464  -2.423  1.00 10.42           C 
ATOM    961  C   SER    60       1.687  -0.321  -3.397  1.00 43.11           C 
ATOM    962  O   SER    60       1.704  -0.514  -4.613  1.00 35.23           O 
ATOM    963  CB  SER    60       2.503  -2.504  -2.475  1.00 30.45           C 
ATOM    964  OG  SER    60       3.745  -1.930  -2.103  1.00  4.40           O 
ATOM    965  H   SER    60      -0.022  -2.617  -3.545  1.00 38.03           H 
ATOM    966  HA  SER    60       1.325  -1.059  -1.422  1.00 23.51           H 
ATOM    967 1HB  SER    60       2.586  -2.896  -3.479  1.00 14.11           H 
ATOM    968 2HB  SER    60       2.277  -3.310  -1.794  1.00 23.24           H 
ATOM    969  HG  SER    60       4.258  -1.728  -2.897  1.00 23.32           H 
ATOM    970  N   ILE    61       1.935   0.868  -2.852  1.00 70.05           N 
ATOM    971  CA  ILE    61       2.318   2.037  -3.659  1.00 42.11           C 
ATOM    972  C   ILE    61       3.747   2.494  -3.321  1.00 11.12           C 
ATOM    973  O   ILE    61       4.185   2.377  -2.175  1.00 31.32           O 
ATOM    974  CB  ILE    61       1.331   3.218  -3.451  1.00 34.21           C 
ATOM    975  CG1 ILE    61       1.280   3.630  -1.971  1.00 45.51           C 
ATOM    976  CG2 ILE    61      -0.062   2.849  -3.965  1.00 32.31           C 
ATOM    977  CD1 ILE    61       0.366   4.804  -1.691  1.00 14.01           C 
ATOM    978  H   ILE    61       1.861   0.965  -1.878  1.00 38.03           H 
ATOM    979  HA  ILE    61       2.284   1.750  -4.703  1.00 63.33           H 
ATOM    980  HB  ILE    61       1.685   4.057  -4.037  1.00 24.11           H 
ATOM    981 1HG1 ILE    61       2.275   3.900  -1.643  1.00 72.01           H 
ATOM    982 2HG1 ILE    61       0.929   2.795  -1.382  1.00 54.50           H 
ATOM    983 1HG2 ILE    61      -0.003   2.597  -5.015  1.00 33.12           H 
ATOM    984 2HG2 ILE    61      -0.730   3.690  -3.837  1.00 73.22           H 
ATOM    985 3HG2 ILE    61      -0.441   2.000  -3.412  1.00 24.14           H 
ATOM    986 1HD1 ILE    61       0.394   5.039  -0.638  1.00 44.21           H 
ATOM    987 2HD1 ILE    61      -0.645   4.552  -1.975  1.00 54.24           H 
ATOM    988 3HD1 ILE    61       0.695   5.661  -2.258  1.00 21.04           H 
ATOM    989  N   PRO    62       4.500   3.027  -4.305  1.00 60.24           N 
ATOM    990  CA  PRO    62       5.904   3.440  -4.091  1.00 61.14           C 
ATOM    991  C   PRO    62       6.064   4.597  -3.077  1.00 70.05           C 
ATOM    992  O   PRO    62       5.137   5.376  -2.849  1.00  4.04           O 
ATOM    993  CB  PRO    62       6.364   3.878  -5.490  1.00 34.11           C 
ATOM    994  CG  PRO    62       5.106   4.211  -6.224  1.00 50.44           C 
ATOM    995  CD  PRO    62       4.057   3.273  -5.693  1.00 52.14           C 
ATOM    996  HA  PRO    62       6.507   2.602  -3.763  1.00 73.21           H 
ATOM    997 1HB  PRO    62       6.897   3.067  -5.969  1.00 72.22           H 
ATOM    998 2HB  PRO    62       7.015   4.738  -5.408  1.00 24.01           H 
ATOM    999 1HG  PRO    62       5.245   4.060  -7.286  1.00 41.45           H 
ATOM   1000 2HG  PRO    62       4.826   5.237  -6.026  1.00  2.11           H 
ATOM   1001 1HD  PRO    62       4.046   2.353  -6.262  1.00 41.22           H 
ATOM   1002 2HD  PRO    62       3.082   3.743  -5.713  1.00 24.45           H 
ATOM   1003  N   ALA    63       7.263   4.709  -2.494  1.00 32.02           N 
ATOM   1004  CA  ALA    63       7.557   5.715  -1.456  1.00 31.42           C 
ATOM   1005  C   ALA    63       7.290   7.152  -1.925  1.00 34.23           C 
ATOM   1006  O   ALA    63       6.892   8.005  -1.130  1.00 61.24           O 
ATOM   1007  CB  ALA    63       9.002   5.582  -0.990  1.00 12.05           C 
ATOM   1008  H   ALA    63       7.977   4.092  -2.764  1.00 38.03           H 
ATOM   1009  HA  ALA    63       6.918   5.507  -0.610  1.00 62.32           H 
ATOM   1010 1HB  ALA    63       9.670   5.853  -1.795  1.00 73.22           H 
ATOM   1011 2HB  ALA    63       9.191   4.560  -0.696  1.00 62.43           H 
ATOM   1012 3HB  ALA    63       9.174   6.236  -0.146  1.00 60.03           H 
ATOM   1013  N   SER    64       7.511   7.418  -3.214  1.00 23.11           N 
ATOM   1014  CA  SER    64       7.278   8.758  -3.785  1.00 33.24           C 
ATOM   1015  C   SER    64       5.822   9.213  -3.593  1.00 22.01           C 
ATOM   1016  O   SER    64       5.518  10.404  -3.678  1.00 45.23           O 
ATOM   1017  CB  SER    64       7.629   8.780  -5.280  1.00 40.12           C 
ATOM   1018  OG  SER    64       8.998   8.460  -5.499  1.00  5.30           O 
ATOM   1019  H   SER    64       7.850   6.702  -3.793  1.00 38.03           H 
ATOM   1020  HA  SER    64       7.925   9.452  -3.266  1.00 13.23           H 
ATOM   1021 1HB  SER    64       7.436   9.766  -5.680  1.00 24.42           H 
ATOM   1022 2HB  SER    64       7.019   8.056  -5.802  1.00 43.44           H 
ATOM   1023  HG  SER    64       9.067   7.551  -5.814  1.00 63.04           H 
ATOM   1024  N   VAL    65       4.930   8.260  -3.342  1.00 51.35           N 
ATOM   1025  CA  VAL    65       3.521   8.561  -3.082  1.00 50.10           C 
ATOM   1026  C   VAL    65       3.270   8.748  -1.573  1.00 32.23           C 
ATOM   1027  O   VAL    65       3.622   7.883  -0.765  1.00 31.33           O 
ATOM   1028  CB  VAL    65       2.603   7.434  -3.622  1.00 73.21           C 
ATOM   1029  CG1 VAL    65       1.129   7.794  -3.438  1.00 34.34           C 
ATOM   1030  CG2 VAL    65       2.915   7.147  -5.089  1.00 65.22           C 
ATOM   1031  H   VAL    65       5.225   7.325  -3.324  1.00 38.03           H 
ATOM   1032  HA  VAL    65       3.274   9.477  -3.601  1.00 22.10           H 
ATOM   1033  HB  VAL    65       2.800   6.533  -3.055  1.00 22.53           H 
ATOM   1034 1HG1 VAL    65       0.511   6.986  -3.807  1.00 25.14           H 
ATOM   1035 2HG1 VAL    65       0.906   8.696  -3.990  1.00 60.15           H 
ATOM   1036 3HG1 VAL    65       0.921   7.953  -2.390  1.00 73.22           H 
ATOM   1037 1HG2 VAL    65       2.298   6.330  -5.436  1.00 14.42           H 
ATOM   1038 2HG2 VAL    65       3.958   6.877  -5.190  1.00 41.42           H 
ATOM   1039 3HG2 VAL    65       2.712   8.027  -5.680  1.00 51.52           H 
ATOM   1040  N   PRO    66       2.673   9.888  -1.165  1.00 71.42           N 
ATOM   1041  CA  PRO    66       2.403  10.174   0.257  1.00  2.20           C 
ATOM   1042  C   PRO    66       1.300   9.276   0.858  1.00 35.40           C 
ATOM   1043  O   PRO    66       0.512   8.663   0.135  1.00 53.31           O 
ATOM   1044  CB  PRO    66       1.957  11.644   0.239  1.00 13.22           C 
ATOM   1045  CG  PRO    66       1.394  11.848  -1.128  1.00  4.54           C 
ATOM   1046  CD  PRO    66       2.218  10.985  -2.046  1.00 33.50           C 
ATOM   1047  HA  PRO    66       3.302  10.077   0.850  1.00 54.05           H 
ATOM   1048 1HB  PRO    66       2.811  12.287   0.413  1.00 55.23           H 
ATOM   1049 2HB  PRO    66       1.214  11.813   1.006  1.00 72.23           H 
ATOM   1050 1HG  PRO    66       1.477  12.887  -1.412  1.00 31.01           H 
ATOM   1051 2HG  PRO    66       0.358  11.537  -1.147  1.00  1.31           H 
ATOM   1052 1HD  PRO    66       3.058  11.540  -2.436  1.00 25.05           H 
ATOM   1053 2HD  PRO    66       1.610  10.605  -2.857  1.00 23.01           H 
ATOM   1054  N   LEU    67       1.255   9.210   2.186  1.00  3.11           N 
ATOM   1055  CA  LEU    67       0.232   8.438   2.902  1.00  2.22           C 
ATOM   1056  C   LEU    67      -1.144   9.128   2.822  1.00 75.53           C 
ATOM   1057  O   LEU    67      -1.235  10.357   2.860  1.00 63.14           O 
ATOM   1058  CB  LEU    67       0.650   8.278   4.373  1.00 51.50           C 
ATOM   1059  CG  LEU    67      -0.292   7.434   5.252  1.00 44.43           C 
ATOM   1060  CD1 LEU    67      -0.317   5.983   4.792  1.00 64.51           C 
ATOM   1061  CD2 LEU    67       0.112   7.520   6.719  1.00 10.50           C 
ATOM   1062  H   LEU    67       1.934   9.689   2.706  1.00 38.03           H 
ATOM   1063  HA  LEU    67       0.165   7.460   2.445  1.00 42.43           H 
ATOM   1064 1HB  LEU    67       0.724   9.264   4.808  1.00  4.33           H 
ATOM   1065 2HB  LEU    67       1.633   7.825   4.393  1.00 54.22           H 
ATOM   1066  HG  LEU    67      -1.298   7.822   5.163  1.00 25.04           H 
ATOM   1067 1HD1 LEU    67      -0.692   5.932   3.781  1.00 10.35           H 
ATOM   1068 2HD1 LEU    67      -0.961   5.411   5.444  1.00 11.35           H 
ATOM   1069 3HD1 LEU    67       0.685   5.573   4.826  1.00 33.14           H 
ATOM   1070 1HD2 LEU    67       0.091   8.552   7.038  1.00 21.15           H 
ATOM   1071 2HD2 LEU    67       1.110   7.123   6.846  1.00 35.14           H 
ATOM   1072 3HD2 LEU    67      -0.583   6.947   7.316  1.00 52.14           H 
ATOM   1073  N   LYS    68      -2.210   8.337   2.693  1.00 31.51           N 
ATOM   1074  CA  LYS    68      -3.575   8.882   2.671  1.00 60.21           C 
ATOM   1075  C   LYS    68      -4.355   8.495   3.935  1.00 13.05           C 
ATOM   1076  O   LYS    68      -4.773   7.349   4.102  1.00 40.51           O 
ATOM   1077  CB  LYS    68      -4.351   8.423   1.427  1.00 33.02           C 
ATOM   1078  CG  LYS    68      -3.828   8.986   0.103  1.00 64.12           C 
ATOM   1079  CD  LYS    68      -2.595   8.241  -0.399  1.00 43.32           C 
ATOM   1080  CE  LYS    68      -1.973   8.926  -1.613  1.00 74.33           C 
ATOM   1081  NZ  LYS    68      -2.942   9.105  -2.726  1.00 20.52           N 
ATOM   1082  H   LYS    68      -2.080   7.370   2.618  1.00 38.03           H 
ATOM   1083  HA  LYS    68      -3.495   9.962   2.643  1.00 14.13           H 
ATOM   1084 1HB  LYS    68      -5.384   8.727   1.539  1.00 74.01           H 
ATOM   1085 2HB  LYS    68      -4.311   7.343   1.376  1.00 31.14           H 
ATOM   1086 1HG  LYS    68      -3.574  10.029   0.245  1.00 32.42           H 
ATOM   1087 2HG  LYS    68      -4.607   8.907  -0.642  1.00 10.02           H 
ATOM   1088 1HD  LYS    68      -2.881   7.235  -0.672  1.00 23.05           H 
ATOM   1089 2HD  LYS    68      -1.862   8.204   0.394  1.00 10.42           H 
ATOM   1090 1HE  LYS    68      -1.145   8.328  -1.963  1.00 45.51           H 
ATOM   1091 2HE  LYS    68      -1.613   9.895  -1.313  1.00 34.11           H 
ATOM   1092 1HZ  LYS    68      -2.446   9.421  -3.586  1.00 32.10           H 
ATOM   1093 2HZ  LYS    68      -3.652   9.821  -2.476  1.00 63.14           H 
ATOM   1094 3HZ  LYS    68      -3.430   8.212  -2.932  1.00 13.33           H 
ATOM   1095  N   GLU    69      -4.551   9.471   4.812  1.00 64.53           N 
ATOM   1096  CA  GLU    69      -5.273   9.267   6.070  1.00 44.03           C 
ATOM   1097  C   GLU    69      -6.793   9.153   5.839  1.00 14.02           C 
ATOM   1098  O   GLU    69      -7.542  10.098   6.107  1.00 52.20           O 
ATOM   1099  CB  GLU    69      -4.977  10.443   7.011  1.00 43.31           C 
ATOM   1100  CG  GLU    69      -3.504  10.599   7.389  1.00 64.21           C 
ATOM   1101  CD  GLU    69      -3.088   9.730   8.570  1.00  2.14           C 
ATOM   1102  OE1 GLU    69      -3.059  10.248   9.710  1.00 74.04           O 
ATOM   1103  OE2 GLU    69      -2.785   8.537   8.370  1.00 74.11           O 
ATOM   1104  H   GLU    69      -4.198  10.362   4.611  1.00 38.03           H 
ATOM   1105  HA  GLU    69      -4.915   8.353   6.524  1.00 10.04           H 
ATOM   1106 1HB  GLU    69      -5.552  10.315   7.918  1.00 33.54           H 
ATOM   1107 2HB  GLU    69      -5.297  11.353   6.523  1.00 34.53           H 
ATOM   1108 1HG  GLU    69      -3.322  11.634   7.642  1.00 41.43           H 
ATOM   1109 2HG  GLU    69      -2.895  10.333   6.536  1.00 72.31           H 
ATOM   1110  N   PHE    70      -7.242   8.012   5.320  1.00 65.54           N 
ATOM   1111  CA  PHE    70      -8.675   7.790   5.057  1.00 10.24           C 
ATOM   1112  C   PHE    70      -9.368   7.065   6.220  1.00 31.44           C 
ATOM   1113  O   PHE    70      -8.730   6.336   6.984  1.00 13.33           O 
ATOM   1114  CB  PHE    70      -8.874   6.984   3.764  1.00 52.51           C 
ATOM   1115  CG  PHE    70      -8.493   7.725   2.503  1.00 32.13           C 
ATOM   1116  CD1 PHE    70      -8.788   9.073   2.360  1.00 51.32           C 
ATOM   1117  CD2 PHE    70      -7.857   7.070   1.456  1.00 24.41           C 
ATOM   1118  CE1 PHE    70      -8.456   9.751   1.204  1.00 22.15           C 
ATOM   1119  CE2 PHE    70      -7.522   7.747   0.298  1.00 54.44           C 
ATOM   1120  CZ  PHE    70      -7.820   9.089   0.173  1.00 63.43           C 
ATOM   1121  H   PHE    70      -6.599   7.303   5.106  1.00 38.03           H 
ATOM   1122  HA  PHE    70      -9.140   8.760   4.935  1.00 61.21           H 
ATOM   1123 1HB  PHE    70      -9.915   6.703   3.681  1.00 24.12           H 
ATOM   1124 2HB  PHE    70      -8.274   6.088   3.814  1.00  0.02           H 
ATOM   1125  HD1 PHE    70      -9.283   9.597   3.165  1.00 11.42           H 
ATOM   1126  HD2 PHE    70      -7.624   6.018   1.551  1.00 14.53           H 
ATOM   1127  HE1 PHE    70      -8.696  10.800   1.106  1.00 71.10           H 
ATOM   1128  HE2 PHE    70      -7.024   7.226  -0.508  1.00  1.14           H 
ATOM   1129  HZ  PHE    70      -7.562   9.619  -0.732  1.00 25.51           H 
ATOM   1130  N   ASP    71     -10.680   7.271   6.348  1.00 63.45           N 
ATOM   1131  CA  ASP    71     -11.475   6.607   7.389  1.00 22.44           C 
ATOM   1132  C   ASP    71     -11.839   5.165   6.993  1.00 43.34           C 
ATOM   1133  O   ASP    71     -11.631   4.748   5.851  1.00  5.53           O 
ATOM   1134  CB  ASP    71     -12.743   7.423   7.683  1.00 60.43           C 
ATOM   1135  CG  ASP    71     -13.539   7.750   6.428  1.00  5.44           C 
ATOM   1136  OD1 ASP    71     -13.103   8.641   5.662  1.00 24.11           O 
ATOM   1137  OD2 ASP    71     -14.605   7.139   6.212  1.00 44.40           O 
ATOM   1138  H   ASP    71     -11.130   7.882   5.728  1.00 38.03           H 
ATOM   1139  HA  ASP    71     -10.872   6.571   8.287  1.00 23.25           H 
ATOM   1140 1HB  ASP    71     -12.462   8.352   8.160  1.00 31.40           H 
ATOM   1141 2HB  ASP    71     -13.377   6.862   8.356  1.00 50.14           H 
ATOM   1142  N   TYR    72     -12.387   4.409   7.939  1.00 54.40           N 
ATOM   1143  CA  TYR    72     -12.694   2.995   7.708  1.00 21.44           C 
ATOM   1144  C   TYR    72     -13.829   2.819   6.679  1.00 41.34           C 
ATOM   1145  O   TYR    72     -14.887   3.438   6.789  1.00 11.10           O 
ATOM   1146  CB  TYR    72     -13.053   2.301   9.032  1.00  1.03           C 
ATOM   1147  CG  TYR    72     -13.052   0.784   8.942  1.00  3.21           C 
ATOM   1148  CD1 TYR    72     -14.237   0.069   8.842  1.00 22.44           C 
ATOM   1149  CD2 TYR    72     -11.857   0.071   8.942  1.00 34.13           C 
ATOM   1150  CE1 TYR    72     -14.233  -1.309   8.741  1.00 14.34           C 
ATOM   1151  CE2 TYR    72     -11.847  -1.307   8.847  1.00 13.42           C 
ATOM   1152  CZ  TYR    72     -13.037  -1.991   8.745  1.00 60.12           C 
ATOM   1153  OH  TYR    72     -13.032  -3.364   8.625  1.00 62.34           O 
ATOM   1154  H   TYR    72     -12.592   4.810   8.812  1.00 38.03           H 
ATOM   1155  HA  TYR    72     -11.800   2.532   7.311  1.00 60.11           H 
ATOM   1156 1HB  TYR    72     -14.039   2.619   9.345  1.00 54.01           H 
ATOM   1157 2HB  TYR    72     -12.334   2.586   9.787  1.00 34.31           H 
ATOM   1158  HD1 TYR    72     -15.176   0.605   8.839  1.00  5.23           H 
ATOM   1159  HD2 TYR    72     -10.923   0.609   9.024  1.00 52.15           H 
ATOM   1160  HE1 TYR    72     -15.168  -1.846   8.664  1.00  3.33           H 
ATOM   1161  HE2 TYR    72     -10.907  -1.842   8.850  1.00 62.23           H 
ATOM   1162  HH  TYR    72     -12.488  -3.751   9.328  1.00 23.03           H 
ATOM   1163  N   ASN    73     -13.582   1.962   5.685  1.00 13.32           N 
ATOM   1164  CA  ASN    73     -14.537   1.676   4.597  1.00  4.03           C 
ATOM   1165  C   ASN    73     -14.728   2.865   3.634  1.00 14.10           C 
ATOM   1166  O   ASN    73     -15.697   2.903   2.874  1.00  3.25           O 
ATOM   1167  CB  ASN    73     -15.894   1.214   5.147  1.00 41.54           C 
ATOM   1168  CG  ASN    73     -15.807  -0.117   5.875  1.00 64.11           C 
ATOM   1169  OD1 ASN    73     -14.941  -0.947   5.599  1.00  1.31           O 
ATOM   1170  ND2 ASN    73     -16.713  -0.339   6.806  1.00 23.20           N 
ATOM   1171  H   ASN    73     -12.724   1.494   5.682  1.00 38.03           H 
ATOM   1172  HA  ASN    73     -14.112   0.863   4.025  1.00 54.20           H 
ATOM   1173 1HB  ASN    73     -16.593   1.108   4.330  1.00 33.52           H 
ATOM   1174 2HB  ASN    73     -16.266   1.956   5.838  1.00 42.32           H 
ATOM   1175 1HD2 ASN    73     -17.383   0.356   6.974  1.00  1.51           H 
ATOM   1176 2HD2 ASN    73     -16.683  -1.191   7.284  1.00 64.11           H 
ATOM   1177  N   ALA    74     -13.795   3.815   3.642  1.00  3.42           N 
ATOM   1178  CA  ALA    74     -13.822   4.925   2.681  1.00 54.43           C 
ATOM   1179  C   ALA    74     -13.658   4.409   1.238  1.00 73.01           C 
ATOM   1180  O   ALA    74     -12.775   3.594   0.963  1.00 73.12           O 
ATOM   1181  CB  ALA    74     -12.731   5.939   3.015  1.00 22.14           C 
ATOM   1182  H   ALA    74     -13.082   3.780   4.313  1.00 38.03           H 
ATOM   1183  HA  ALA    74     -14.780   5.420   2.772  1.00 45.41           H 
ATOM   1184 1HB  ALA    74     -12.802   6.783   2.342  1.00 41.33           H 
ATOM   1185 2HB  ALA    74     -11.761   5.474   2.907  1.00 32.44           H 
ATOM   1186 3HB  ALA    74     -12.854   6.280   4.032  1.00 34.34           H 
ATOM   1187  N   ARG    75     -14.512   4.882   0.326  1.00 13.04           N 
ATOM   1188  CA  ARG    75     -14.486   4.421  -1.072  1.00 13.00           C 
ATOM   1189  C   ARG    75     -13.323   5.045  -1.861  1.00 24.42           C 
ATOM   1190  O   ARG    75     -13.255   6.266  -2.036  1.00 42.21           O 
ATOM   1191  CB  ARG    75     -15.804   4.750  -1.784  1.00 65.32           C 
ATOM   1192  CG  ARG    75     -17.039   4.090  -1.176  1.00 21.11           C 
ATOM   1193  CD  ARG    75     -18.289   4.422  -1.989  1.00 12.53           C 
ATOM   1194  NE  ARG    75     -18.418   5.863  -2.198  1.00 40.25           N 
ATOM   1195  CZ  ARG    75     -18.634   6.429  -3.356  1.00 23.40           C 
ATOM   1196  NH1 ARG    75     -18.852   5.721  -4.415  1.00 63.33           N 
ATOM   1197  NH2 ARG    75     -18.643   7.715  -3.447  1.00 23.23           N 
ATOM   1198  H   ARG    75     -15.168   5.556   0.596  1.00 38.03           H 
ATOM   1199  HA  ARG    75     -14.359   3.346  -1.061  1.00 40.51           H 
ATOM   1200 1HB  ARG    75     -15.727   4.433  -2.815  1.00 41.21           H 
ATOM   1201 2HB  ARG    75     -15.952   5.821  -1.761  1.00 74.01           H 
ATOM   1202 1HG  ARG    75     -17.169   4.448  -0.165  1.00 64.41           H 
ATOM   1203 2HG  ARG    75     -16.900   3.017  -1.167  1.00 34.31           H 
ATOM   1204 1HD  ARG    75     -19.158   4.064  -1.454  1.00 24.01           H 
ATOM   1205 2HD  ARG    75     -18.226   3.924  -2.947  1.00 62.41           H 
ATOM   1206  HE  ARG    75     -18.306   6.440  -1.419  1.00 35.10           H 
ATOM   1207 1HH1 ARG    75     -18.861   4.723  -4.359  1.00 31.31           H 
ATOM   1208 2HH1 ARG    75     -19.016   6.173  -5.288  1.00 14.15           H 
ATOM   1209 1HH2 ARG    75     -18.486   8.277  -2.638  1.00 12.33           H 
ATOM   1210 2HH2 ARG    75     -18.793   8.147  -4.335  1.00 44.00           H 
ATOM   1211  N   VAL    76     -12.430   4.194  -2.352  1.00 23.23           N 
ATOM   1212  CA  VAL    76     -11.267   4.629  -3.132  1.00 71.52           C 
ATOM   1213  C   VAL    76     -11.213   3.929  -4.502  1.00 34.20           C 
ATOM   1214  O   VAL    76     -11.861   2.904  -4.715  1.00  0.23           O 
ATOM   1215  CB  VAL    76      -9.945   4.344  -2.365  1.00 62.45           C 
ATOM   1216  CG1 VAL    76      -9.910   5.100  -1.036  1.00 24.15           C 
ATOM   1217  CG2 VAL    76      -9.759   2.844  -2.137  1.00 25.22           C 
ATOM   1218  H   VAL    76     -12.555   3.234  -2.188  1.00 38.03           H 
ATOM   1219  HA  VAL    76     -11.343   5.698  -3.291  1.00 41.24           H 
ATOM   1220  HB  VAL    76      -9.120   4.698  -2.970  1.00 15.10           H 
ATOM   1221 1HG1 VAL    76      -9.933   6.164  -1.225  1.00 20.51           H 
ATOM   1222 2HG1 VAL    76      -9.004   4.851  -0.502  1.00 64.32           H 
ATOM   1223 3HG1 VAL    76     -10.767   4.821  -0.440  1.00 45.43           H 
ATOM   1224 1HG2 VAL    76      -9.726   2.334  -3.089  1.00 32.52           H 
ATOM   1225 2HG2 VAL    76     -10.583   2.460  -1.552  1.00 51.41           H 
ATOM   1226 3HG2 VAL    76      -8.832   2.671  -1.607  1.00 53.41           H 
ATOM   1227  N   GLU    77     -10.453   4.501  -5.432  1.00 32.14           N 
ATOM   1228  CA  GLU    77     -10.163   3.849  -6.713  1.00 22.31           C 
ATOM   1229  C   GLU    77      -8.687   4.055  -7.095  1.00 72.21           C 
ATOM   1230  O   GLU    77      -8.079   5.078  -6.765  1.00 44.33           O 
ATOM   1231  CB  GLU    77     -11.103   4.349  -7.827  1.00 13.43           C 
ATOM   1232  CG  GLU    77     -11.015   5.843  -8.125  1.00 43.32           C 
ATOM   1233  CD  GLU    77     -11.925   6.257  -9.279  1.00 25.33           C 
ATOM   1234  OE1 GLU    77     -11.507   6.124 -10.449  1.00 24.54           O 
ATOM   1235  OE2 GLU    77     -13.062   6.712  -9.023  1.00 41.11           O 
ATOM   1236  H   GLU    77     -10.080   5.390  -5.259  1.00 38.03           H 
ATOM   1237  HA  GLU    77     -10.326   2.787  -6.576  1.00  5.11           H 
ATOM   1238 1HB  GLU    77     -12.122   4.122  -7.542  1.00  2.14           H 
ATOM   1239 2HB  GLU    77     -10.873   3.812  -8.737  1.00 14.51           H 
ATOM   1240 1HG  GLU    77      -9.994   6.087  -8.384  1.00 52.12           H 
ATOM   1241 2HG  GLU    77     -11.301   6.394  -7.240  1.00 50.11           H 
ATOM   1242  N   LEU    78      -8.109   3.065  -7.772  1.00 40.24           N 
ATOM   1243  CA  LEU    78      -6.675   3.073  -8.084  1.00 22.12           C 
ATOM   1244  C   LEU    78      -6.398   3.578  -9.507  1.00 42.24           C 
ATOM   1245  O   LEU    78      -7.094   3.215 -10.453  1.00 12.11           O 
ATOM   1246  CB  LEU    78      -6.097   1.662  -7.906  1.00 52.00           C 
ATOM   1247  CG  LEU    78      -6.233   1.076  -6.491  1.00 43.42           C 
ATOM   1248  CD1 LEU    78      -5.671  -0.344  -6.429  1.00 60.04           C 
ATOM   1249  CD2 LEU    78      -5.536   1.975  -5.472  1.00  3.22           C 
ATOM   1250  H   LEU    78      -8.659   2.316  -8.078  1.00 38.03           H 
ATOM   1251  HA  LEU    78      -6.188   3.737  -7.380  1.00  1.01           H 
ATOM   1252 1HB  LEU    78      -5.046   1.687  -8.161  1.00 42.52           H 
ATOM   1253 2HB  LEU    78      -6.601   1.001  -8.598  1.00 31.43           H 
ATOM   1254  HG  LEU    78      -7.281   1.027  -6.231  1.00 74.22           H 
ATOM   1255 1HD1 LEU    78      -4.619  -0.329  -6.676  1.00 55.42           H 
ATOM   1256 2HD1 LEU    78      -6.198  -0.970  -7.135  1.00 30.02           H 
ATOM   1257 3HD1 LEU    78      -5.801  -0.739  -5.432  1.00  2.23           H 
ATOM   1258 1HD2 LEU    78      -5.991   2.954  -5.487  1.00 32.14           H 
ATOM   1259 2HD2 LEU    78      -4.488   2.062  -5.724  1.00 33.34           H 
ATOM   1260 3HD2 LEU    78      -5.635   1.547  -4.486  1.00 72.01           H 
ATOM   1261  N   ILE    79      -5.368   4.417  -9.643  1.00 25.14           N 
ATOM   1262  CA  ILE    79      -4.958   4.942 -10.951  1.00 43.41           C 
ATOM   1263  C   ILE    79      -4.476   3.812 -11.886  1.00 73.05           C 
ATOM   1264  O   ILE    79      -5.153   3.457 -12.851  1.00 44.23           O 
ATOM   1265  CB  ILE    79      -3.839   6.008 -10.796  1.00 40.13           C 
ATOM   1266  CG1 ILE    79      -4.319   7.170  -9.905  1.00 12.55           C 
ATOM   1267  CG2 ILE    79      -3.382   6.525 -12.164  1.00 51.40           C 
ATOM   1268  CD1 ILE    79      -5.550   7.886 -10.433  1.00 75.21           C 
ATOM   1269  H   ILE    79      -4.882   4.704  -8.839  1.00 38.03           H 
ATOM   1270  HA  ILE    79      -5.819   5.420 -11.399  1.00 31.23           H 
ATOM   1271  HB  ILE    79      -2.991   5.531 -10.320  1.00 74.45           H 
ATOM   1272 1HG1 ILE    79      -3.526   7.899  -9.815  1.00 62.13           H 
ATOM   1273 2HG1 ILE    79      -4.560   6.787  -8.925  1.00 31.02           H 
ATOM   1274 1HG2 ILE    79      -2.995   5.703 -12.748  1.00 24.34           H 
ATOM   1275 2HG2 ILE    79      -2.605   7.264 -12.030  1.00 62.44           H 
ATOM   1276 3HG2 ILE    79      -4.218   6.971 -12.684  1.00 73.32           H 
ATOM   1277 1HD1 ILE    79      -5.834   8.667  -9.742  1.00 22.12           H 
ATOM   1278 2HD1 ILE    79      -6.362   7.181 -10.532  1.00 60.43           H 
ATOM   1279 3HD1 ILE    79      -5.329   8.321 -11.396  1.00 42.11           H 
ATOM   1280  N   ASN    80      -3.303   3.246 -11.589  1.00 21.31           N 
ATOM   1281  CA  ASN    80      -2.762   2.115 -12.362  1.00 64.23           C 
ATOM   1282  C   ASN    80      -2.489   0.894 -11.459  1.00  3.43           C 
ATOM   1283  O   ASN    80      -1.371   0.707 -10.976  1.00  4.41           O 
ATOM   1284  CB  ASN    80      -1.473   2.533 -13.090  1.00 22.30           C 
ATOM   1285  CG  ASN    80      -1.718   3.570 -14.171  1.00 21.15           C 
ATOM   1286  OD1 ASN    80      -2.761   3.576 -14.819  1.00 11.25           O 
ATOM   1287  ND2 ASN    80      -0.764   4.458 -14.373  1.00 35.24           N 
ATOM   1288  H   ASN    80      -2.786   3.599 -10.840  1.00 38.03           H 
ATOM   1289  HA  ASN    80      -3.502   1.834 -13.101  1.00 55.40           H 
ATOM   1290 1HB  ASN    80      -1.030   1.663 -13.553  1.00 70.33           H 
ATOM   1291 2HB  ASN    80      -0.777   2.945 -12.371  1.00 14.50           H 
ATOM   1292 1HD2 ASN    80       0.047   4.406 -13.823  1.00 11.45           H 
ATOM   1293 2HD2 ASN    80      -0.906   5.136 -15.063  1.00 65.41           H 
ATOM   1294  N   PRO    81      -3.527   0.078 -11.171  1.00 53.23           N 
ATOM   1295  CA  PRO    81      -3.382  -1.154 -10.376  1.00 53.25           C 
ATOM   1296  C   PRO    81      -2.892  -2.365 -11.198  1.00  1.13           C 
ATOM   1297  O   PRO    81      -3.416  -2.652 -12.278  1.00 73.44           O 
ATOM   1298  CB  PRO    81      -4.806  -1.391  -9.869  1.00 32.31           C 
ATOM   1299  CG  PRO    81      -5.685  -0.856 -10.954  1.00 61.55           C 
ATOM   1300  CD  PRO    81      -4.929   0.291 -11.593  1.00 34.01           C 
ATOM   1301  HA  PRO    81      -2.722  -1.003  -9.534  1.00  3.11           H 
ATOM   1302 1HB  PRO    81      -4.956  -0.857  -8.940  1.00 71.34           H 
ATOM   1303 2HB  PRO    81      -4.970  -2.450  -9.707  1.00 21.21           H 
ATOM   1304 1HG  PRO    81      -6.617  -0.503 -10.533  1.00 30.11           H 
ATOM   1305 2HG  PRO    81      -5.877  -1.629 -11.686  1.00 60.32           H 
ATOM   1306 1HD  PRO    81      -5.301   1.239 -11.228  1.00 22.54           H 
ATOM   1307 2HD  PRO    81      -5.015   0.247 -12.670  1.00 33.01           H 
ATOM   1308  N   ILE    82      -1.890  -3.078 -10.681  1.00 43.24           N 
ATOM   1309  CA  ILE    82      -1.396  -4.309 -11.319  1.00 41.02           C 
ATOM   1310  C   ILE    82      -1.141  -5.420 -10.281  1.00 32.45           C 
ATOM   1311  O   ILE    82      -0.425  -5.216  -9.301  1.00 34.22           O 
ATOM   1312  CB  ILE    82      -0.092  -4.064 -12.136  1.00 64.33           C 
ATOM   1313  CG1 ILE    82       1.019  -3.474 -11.247  1.00 43.23           C 
ATOM   1314  CG2 ILE    82      -0.370  -3.152 -13.332  1.00 21.32           C 
ATOM   1315  CD1 ILE    82       2.336  -3.259 -11.969  1.00 73.13           C 
ATOM   1316  H   ILE    82      -1.461  -2.768  -9.856  1.00 38.03           H 
ATOM   1317  HA  ILE    82      -2.161  -4.654 -12.007  1.00 32.21           H 
ATOM   1318  HB  ILE    82       0.240  -5.019 -12.523  1.00 22.44           H 
ATOM   1319 1HG1 ILE    82       1.203  -4.142 -10.416  1.00 71.41           H 
ATOM   1320 2HG1 ILE    82       0.698  -2.517 -10.865  1.00 34.35           H 
ATOM   1321 1HG2 ILE    82      -1.116  -3.607 -13.969  1.00 62.44           H 
ATOM   1322 2HG2 ILE    82       0.540  -3.004 -13.894  1.00 40.34           H 
ATOM   1323 3HG2 ILE    82      -0.735  -2.197 -12.980  1.00 32.53           H 
ATOM   1324 1HD1 ILE    82       2.189  -2.570 -12.787  1.00 55.44           H 
ATOM   1325 2HD1 ILE    82       2.694  -4.203 -12.352  1.00 30.45           H 
ATOM   1326 3HD1 ILE    82       3.062  -2.852 -11.281  1.00 74.40           H 
ATOM   1522  N   TRP    98      -3.272 -12.238  -1.997  1.00 52.11           N 
ATOM   1523  CA  TRP    98      -2.596 -11.809  -3.231  1.00 31.31           C 
ATOM   1524  C   TRP    98      -2.266 -10.302  -3.225  1.00 41.53           C 
ATOM   1525  O   TRP    98      -2.963  -9.494  -2.596  1.00 63.02           O 
ATOM   1526  CB  TRP    98      -3.422 -12.203  -4.470  1.00 24.41           C 
ATOM   1527  CG  TRP    98      -4.794 -11.582  -4.565  1.00  1.04           C 
ATOM   1528  CD1 TRP    98      -5.825 -11.680  -3.668  1.00 63.52           C 
ATOM   1529  CD2 TRP    98      -5.293 -10.800  -5.659  1.00 20.14           C 
ATOM   1530  NE1 TRP    98      -6.918 -10.987  -4.131  1.00 12.34           N 
ATOM   1531  CE2 TRP    98      -6.617 -10.441  -5.350  1.00 20.23           C 
ATOM   1532  CE3 TRP    98      -4.740 -10.358  -6.866  1.00 55.14           C 
ATOM   1533  CZ2 TRP    98      -7.397  -9.666  -6.204  1.00 50.04           C 
ATOM   1534  CZ3 TRP    98      -5.518  -9.593  -7.715  1.00 42.13           C 
ATOM   1535  CH2 TRP    98      -6.833  -9.253  -7.378  1.00  4.41           C 
ATOM   1536  H   TRP    98      -4.237 -12.123  -1.915  1.00 38.03           H 
ATOM   1537  HA  TRP    98      -1.656 -12.345  -3.273  1.00 23.20           H 
ATOM   1538 1HB  TRP    98      -3.547 -13.279  -4.472  1.00 44.21           H 
ATOM   1539 2HB  TRP    98      -2.874 -11.920  -5.355  1.00 10.30           H 
ATOM   1540  HD1 TRP    98      -5.773 -12.219  -2.734  1.00 74.05           H 
ATOM   1541  HE1 TRP    98      -7.776 -10.901  -3.668  1.00 53.32           H 
ATOM   1542  HE3 TRP    98      -3.725 -10.612  -7.143  1.00 44.14           H 
ATOM   1543  HZ2 TRP    98      -8.413  -9.395  -5.962  1.00 50.34           H 
ATOM   1544  HZ3 TRP    98      -5.110  -9.244  -8.652  1.00 40.34           H 
ATOM   1545  HH2 TRP    98      -7.404  -8.651  -8.071  1.00 41.45           H 
ATOM   1546  N   TYR    99      -1.190  -9.935  -3.933  1.00  2.54           N 
ATOM   1547  CA  TYR    99      -0.641  -8.572  -3.880  1.00 42.23           C 
ATOM   1548  C   TYR    99      -0.921  -7.778  -5.170  1.00 64.31           C 
ATOM   1549  O   TYR    99      -0.794  -8.292  -6.289  1.00 13.43           O 
ATOM   1550  CB  TYR    99       0.877  -8.622  -3.635  1.00 13.40           C 
ATOM   1551  CG  TYR    99       1.301  -9.557  -2.514  1.00 20.04           C 
ATOM   1552  CD1 TYR    99       1.410 -10.928  -2.732  1.00 14.32           C 
ATOM   1553  CD2 TYR    99       1.602  -9.074  -1.245  1.00  2.34           C 
ATOM   1554  CE1 TYR    99       1.805 -11.784  -1.725  1.00 51.01           C 
ATOM   1555  CE2 TYR    99       1.997  -9.928  -0.230  1.00 31.23           C 
ATOM   1556  CZ  TYR    99       2.096 -11.282  -0.476  1.00 65.03           C 
ATOM   1557  OH  TYR    99       2.502 -12.137   0.524  1.00 51.23           O 
ATOM   1558  H   TYR    99      -0.754 -10.594  -4.512  1.00 38.03           H 
ATOM   1559  HA  TYR    99      -1.107  -8.059  -3.049  1.00 12.12           H 
ATOM   1560 1HB  TYR    99       1.226  -7.627  -3.389  1.00 30.30           H 
ATOM   1561 2HB  TYR    99       1.370  -8.950  -4.540  1.00 63.42           H 
ATOM   1562  HD1 TYR    99       1.179 -11.323  -3.711  1.00 74.51           H 
ATOM   1563  HD2 TYR    99       1.524  -8.015  -1.055  1.00 23.33           H 
ATOM   1564  HE1 TYR    99       1.883 -12.845  -1.917  1.00 44.10           H 
ATOM   1565  HE2 TYR    99       2.224  -9.532   0.750  1.00 54.41           H 
ATOM   1566  HH  TYR    99       3.099 -12.804   0.150  1.00  2.41           H 
ATOM   1567  N   ILE   100      -1.292  -6.512  -4.996  1.00 53.54           N 
ATOM   1568  CA  ILE   100      -1.574  -5.603  -6.109  1.00  0.02           C 
ATOM   1569  C   ILE   100      -0.750  -4.310  -5.978  1.00 22.31           C 
ATOM   1570  O   ILE   100      -0.997  -3.486  -5.094  1.00 40.45           O 
ATOM   1571  CB  ILE   100      -3.082  -5.232  -6.161  1.00 71.22           C 
ATOM   1572  CG1 ILE   100      -3.957  -6.497  -6.166  1.00 71.54           C 
ATOM   1573  CG2 ILE   100      -3.388  -4.363  -7.382  1.00 33.23           C 
ATOM   1574  CD1 ILE   100      -5.445  -6.209  -6.151  1.00 33.02           C 
ATOM   1575  H   ILE   100      -1.375  -6.173  -4.083  1.00 38.03           H 
ATOM   1576  HA  ILE   100      -1.310  -6.101  -7.033  1.00 30.45           H 
ATOM   1577  HB  ILE   100      -3.313  -4.654  -5.278  1.00 12.22           H 
ATOM   1578 1HG1 ILE   100      -3.726  -7.091  -5.293  1.00  2.23           H 
ATOM   1579 2HG1 ILE   100      -3.744  -7.075  -7.053  1.00  3.54           H 
ATOM   1580 1HG2 ILE   100      -2.835  -3.436  -7.313  1.00 21.42           H 
ATOM   1581 2HG2 ILE   100      -4.448  -4.148  -7.416  1.00 60.35           H 
ATOM   1582 3HG2 ILE   100      -3.101  -4.886  -8.282  1.00  4.45           H 
ATOM   1583 1HD1 ILE   100      -5.719  -5.676  -7.050  1.00 42.11           H 
ATOM   1584 2HD1 ILE   100      -5.685  -5.606  -5.288  1.00 21.24           H 
ATOM   1585 3HD1 ILE   100      -5.989  -7.139  -6.101  1.00 24.33           H 
ATOM   1586  N   LYS   101       0.239  -4.139  -6.846  1.00 12.11           N 
ATOM   1587  CA  LYS   101       1.051  -2.918  -6.859  1.00 73.54           C 
ATOM   1588  C   LYS   101       0.338  -1.805  -7.648  1.00 12.02           C 
ATOM   1589  O   LYS   101      -0.107  -2.019  -8.774  1.00 32.32           O 
ATOM   1590  CB  LYS   101       2.437  -3.212  -7.457  1.00 61.50           C 
ATOM   1591  CG  LYS   101       3.256  -4.207  -6.631  1.00 73.44           C 
ATOM   1592  CD  LYS   101       4.543  -4.635  -7.339  1.00 21.22           C 
ATOM   1593  CE  LYS   101       5.499  -3.466  -7.569  1.00 64.11           C 
ATOM   1594  NZ  LYS   101       6.079  -2.944  -6.301  1.00  2.01           N 
ATOM   1595  H   LYS   101       0.427  -4.847  -7.500  1.00 38.03           H 
ATOM   1596  HA  LYS   101       1.176  -2.591  -5.832  1.00 41.33           H 
ATOM   1597 1HB  LYS   101       2.993  -2.288  -7.524  1.00  0.35           H 
ATOM   1598 2HB  LYS   101       2.308  -3.617  -8.452  1.00 23.23           H 
ATOM   1599 1HG  LYS   101       2.651  -5.085  -6.447  1.00 73.44           H 
ATOM   1600 2HG  LYS   101       3.514  -3.748  -5.688  1.00 72.03           H 
ATOM   1601 1HD  LYS   101       4.287  -5.072  -8.295  1.00 35.31           H 
ATOM   1602 2HD  LYS   101       5.043  -5.377  -6.732  1.00  5.24           H 
ATOM   1603 1HE  LYS   101       4.961  -2.669  -8.062  1.00 34.32           H 
ATOM   1604 2HE  LYS   101       6.305  -3.800  -8.205  1.00  3.21           H 
ATOM   1605 1HZ  LYS   101       6.652  -2.098  -6.493  1.00 63.31           H 
ATOM   1606 2HZ  LYS   101       6.690  -3.660  -5.858  1.00 45.02           H 
ATOM   1607 3HZ  LYS   101       5.325  -2.687  -5.631  1.00 31.44           H 
ATOM   1608  N   ALA   102       0.218  -0.624  -7.053  1.00 61.52           N 
ATOM   1609  CA  ALA   102      -0.539   0.473  -7.668  1.00  3.33           C 
ATOM   1610  C   ALA   102       0.318   1.727  -7.878  1.00  3.40           C 
ATOM   1611  O   ALA   102       1.429   1.836  -7.360  1.00 52.31           O 
ATOM   1612  CB  ALA   102      -1.755   0.806  -6.812  1.00 54.03           C 
ATOM   1613  H   ALA   102       0.648  -0.480  -6.183  1.00 38.03           H 
ATOM   1614  HA  ALA   102      -0.896   0.134  -8.632  1.00 11.12           H 
ATOM   1615 1HB  ALA   102      -1.429   1.159  -5.846  1.00 23.00           H 
ATOM   1616 2HB  ALA   102      -2.359  -0.081  -6.686  1.00 45.04           H 
ATOM   1617 3HB  ALA   102      -2.341   1.574  -7.296  1.00 54.13           H 
ATOM   1618  N   ASP   103      -0.212   2.666  -8.659  1.00 12.21           N 
ATOM   1619  CA  ASP   103       0.462   3.940  -8.912  1.00 64.42           C 
ATOM   1620  C   ASP   103       0.124   4.976  -7.823  1.00  0.21           C 
ATOM   1621  O   ASP   103       1.004   5.451  -7.108  1.00 15.41           O 
ATOM   1622  CB  ASP   103       0.057   4.465 -10.293  1.00 32.04           C 
ATOM   1623  CG  ASP   103       0.787   5.739 -10.671  1.00 53.14           C 
ATOM   1624  OD1 ASP   103       2.033   5.764 -10.573  1.00 54.02           O 
ATOM   1625  OD2 ASP   103       0.125   6.712 -11.077  1.00 11.52           O 
ATOM   1626  H   ASP   103      -1.070   2.491  -9.088  1.00 38.03           H 
ATOM   1627  HA  ASP   103       1.528   3.761  -8.905  1.00 11.53           H 
ATOM   1628 1HB  ASP   103      -1.007   4.660 -10.297  1.00 12.14           H 
ATOM   1629 2HB  ASP   103       0.280   3.712 -11.035  1.00 63.35           H 
ATOM   1630  N   ASP   104      -1.160   5.322  -7.715  1.00  3.13           N 
ATOM   1631  CA  ASP   104      -1.636   6.256  -6.692  1.00 71.02           C 
ATOM   1632  C   ASP   104      -3.047   5.875  -6.206  1.00  0.20           C 
ATOM   1633  O   ASP   104      -3.814   5.222  -6.921  1.00 51.02           O 
ATOM   1634  CB  ASP   104      -1.622   7.694  -7.233  1.00 11.24           C 
ATOM   1635  CG  ASP   104      -2.112   8.710  -6.210  1.00 23.30           C 
ATOM   1636  OD1 ASP   104      -1.689   8.633  -5.036  1.00 20.20           O 
ATOM   1637  OD2 ASP   104      -2.921   9.591  -6.571  1.00 12.23           O 
ATOM   1638  H   ASP   104      -1.803   4.945  -8.342  1.00 38.03           H 
ATOM   1639  HA  ASP   104      -0.958   6.195  -5.850  1.00 40.13           H 
ATOM   1640 1HB  ASP   104      -2.256   7.748  -8.108  1.00  4.52           H 
ATOM   1641 2HB  ASP   104      -0.611   7.954  -7.513  1.00 61.23           H 
ATOM   1642  N   ILE   105      -3.368   6.288  -4.980  1.00 32.15           N 
ATOM   1643  CA  ILE   105      -4.660   5.981  -4.350  1.00 41.35           C 
ATOM   1644  C   ILE   105      -5.524   7.247  -4.182  1.00 60.42           C 
ATOM   1645  O   ILE   105      -5.167   8.155  -3.429  1.00 60.12           O 
ATOM   1646  CB  ILE   105      -4.451   5.330  -2.955  1.00 43.41           C 
ATOM   1647  CG1 ILE   105      -3.690   3.997  -3.087  1.00 33.31           C 
ATOM   1648  CG2 ILE   105      -5.791   5.128  -2.243  1.00 10.35           C 
ATOM   1649  CD1 ILE   105      -3.415   3.310  -1.764  1.00  1.21           C 
ATOM   1650  H   ILE   105      -2.714   6.824  -4.485  1.00 38.03           H 
ATOM   1651  HA  ILE   105      -5.187   5.276  -4.981  1.00 62.24           H 
ATOM   1652  HB  ILE   105      -3.861   6.010  -2.356  1.00  0.50           H 
ATOM   1653 1HG1 ILE   105      -2.738   4.178  -3.568  1.00 32.53           H 
ATOM   1654 2HG1 ILE   105      -4.268   3.317  -3.694  1.00 13.25           H 
ATOM   1655 1HG2 ILE   105      -5.623   4.655  -1.286  1.00 22.05           H 
ATOM   1656 2HG2 ILE   105      -6.433   4.501  -2.845  1.00 64.15           H 
ATOM   1657 3HG2 ILE   105      -6.266   6.087  -2.088  1.00 74.44           H 
ATOM   1658 1HD1 ILE   105      -2.895   2.379  -1.944  1.00 25.33           H 
ATOM   1659 2HD1 ILE   105      -4.348   3.107  -1.259  1.00  0.54           H 
ATOM   1660 3HD1 ILE   105      -2.801   3.949  -1.145  1.00 11.23           H 
ATOM   1661  N   VAL   106      -6.659   7.297  -4.877  1.00 63.30           N 
ATOM   1662  CA  VAL   106      -7.599   8.426  -4.762  1.00 43.31           C 
ATOM   1663  C   VAL   106      -8.998   7.940  -4.353  1.00 22.13           C 
ATOM   1664  O   VAL   106      -9.250   6.741  -4.298  1.00 30.54           O 
ATOM   1665  CB  VAL   106      -7.700   9.217  -6.090  1.00  3.43           C 
ATOM   1666  CG1 VAL   106      -6.349   9.820  -6.469  1.00 65.25           C 
ATOM   1667  CG2 VAL   106      -8.233   8.327  -7.214  1.00 21.03           C 
ATOM   1668  H   VAL   106      -6.881   6.554  -5.483  1.00 38.03           H 
ATOM   1669  HA  VAL   106      -7.227   9.094  -3.995  1.00 32.31           H 
ATOM   1670  HB  VAL   106      -8.399  10.031  -5.945  1.00 14.53           H 
ATOM   1671 1HG1 VAL   106      -6.017  10.484  -5.683  1.00 65.21           H 
ATOM   1672 2HG1 VAL   106      -6.447  10.378  -7.391  1.00 22.24           H 
ATOM   1673 3HG1 VAL   106      -5.624   9.030  -6.603  1.00 61.32           H 
ATOM   1674 1HG2 VAL   106      -8.307   8.902  -8.125  1.00 33.22           H 
ATOM   1675 2HG2 VAL   106      -9.210   7.955  -6.946  1.00 22.33           H 
ATOM   1676 3HG2 VAL   106      -7.561   7.494  -7.367  1.00 33.51           H 
ATOM   1677  N   LEU   107      -9.903   8.871  -4.059  1.00  1.10           N 
ATOM   1678  CA  LEU   107     -11.288   8.516  -3.719  1.00  0.05           C 
ATOM   1679  C   LEU   107     -12.126   8.303  -4.988  1.00 30.30           C 
ATOM   1680  O   LEU   107     -11.865   8.920  -6.022  1.00 73.23           O 
ATOM   1681  CB  LEU   107     -11.928   9.606  -2.845  1.00 33.52           C 
ATOM   1682  CG  LEU   107     -11.286   9.800  -1.461  1.00 45.43           C 
ATOM   1683  CD1 LEU   107     -11.943  10.961  -0.718  1.00 74.32           C 
ATOM   1684  CD2 LEU   107     -11.378   8.519  -0.637  1.00  4.43           C 
ATOM   1685  H   LEU   107      -9.643   9.816  -4.076  1.00 38.03           H 
ATOM   1686  HA  LEU   107     -11.266   7.589  -3.161  1.00 54.51           H 
ATOM   1687 1HB  LEU   107     -12.971   9.360  -2.703  1.00 42.11           H 
ATOM   1688 2HB  LEU   107     -11.867  10.544  -3.380  1.00 43.34           H 
ATOM   1689  HG  LEU   107     -10.241  10.039  -1.591  1.00 13.41           H 
ATOM   1690 1HD1 LEU   107     -12.996  10.756  -0.584  1.00 14.53           H 
ATOM   1691 2HD1 LEU   107     -11.825  11.868  -1.292  1.00 54.44           H 
ATOM   1692 3HD1 LEU   107     -11.475  11.083   0.247  1.00 11.42           H 
ATOM   1693 1HD2 LEU   107     -12.417   8.256  -0.484  1.00 62.53           H 
ATOM   1694 2HD2 LEU   107     -10.902   8.672   0.320  1.00 11.32           H 
ATOM   1695 3HD2 LEU   107     -10.878   7.718  -1.160  1.00 25.04           H 
ATOM   1696  N   THR   108     -13.129   7.431  -4.899  1.00 51.23           N 
ATOM   1697  CA  THR   108     -13.996   7.125  -6.048  1.00  5.21           C 
ATOM   1698  C   THR   108     -14.769   8.370  -6.513  1.00 43.13           C 
ATOM   1699  O   THR   108     -15.734   8.790  -5.870  1.00 43.21           O 
ATOM   1700  CB  THR   108     -15.012   6.001  -5.716  1.00 21.32           C 
ATOM   1701  OG1 THR   108     -14.351   4.906  -5.062  1.00 45.23           O 
ATOM   1702  CG2 THR   108     -15.699   5.489  -6.981  1.00 75.40           C 
ATOM   1703  H   THR   108     -13.288   6.971  -4.047  1.00 38.03           H 
ATOM   1704  HA  THR   108     -13.365   6.783  -6.856  1.00 53.41           H 
ATOM   1705  HB  THR   108     -15.767   6.402  -5.055  1.00 41.42           H 
ATOM   1706  HG1 THR   108     -13.718   4.503  -5.665  1.00 55.30           H 
ATOM   1707 1HG2 THR   108     -16.392   4.702  -6.722  1.00 31.42           H 
ATOM   1708 2HG2 THR   108     -14.955   5.103  -7.665  1.00 33.42           H 
ATOM   1709 3HG2 THR   108     -16.235   6.300  -7.454  1.00 52.32           H 
END
