
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  110 ( 1782),  selected  110 , name 2k50_A
# Molecule2: number of CA atoms   75 ( 1234),  selected   75 , name T0466.pdb
# PARAMETERS: 2k50_A.T0466.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      -       -           -
LGA    K     2_A      -       -           -
LGA    P     3_A      -       -           -
LGA    E     4_A      -       -           -
LGA    H     5_A      -       -           -
LGA    R     6_A      -       -           -
LGA    M     7_A      -       -           -
LGA    D     8_A      -       -           -
LGA    T     9_A      -       -           -
LGA    I    10_A      -       -           -
LGA    S    11_A      -       -           -
LGA    K    12_A      -       -           -
LGA    L    13_A      -       -           -
LGA    E    14_A      -       -           -
LGA    E    15_A      -       -           -
LGA    G    16_A      -       -           -
LGA    A    17_A      -       -           -
LGA    E    18_A      -       -           -
LGA    T    19_A      -       -           -
LGA    P    20_A      -       -           -
LGA    V    21_A      -       -           -
LGA    T    22_A      -       -           -
LGA    G    23_A      L      19          0.881
LGA    R    24_A      K      20          0.834
LGA    V    25_A      F      21          1.088
LGA    M    26_A      S      22          1.747
LGA    K    27_A      A      23          2.265
LGA    I    28_A      L      24          1.715
LGA    S    29_A      R      25          2.397
LGA    S    30_A      R      26          4.033
LGA    P    31_A      E      27          1.384
LGA    R    32_A      V      28          2.084
LGA    T    33_A      R      29          1.301
LGA    F    34_A      I      30          1.340
LGA    -       -      Q      31           -
LGA    T    35_A      N      32          4.721
LGA    T    36_A      E      33           -
LGA    R    37_A      D      34           -
LGA    K    38_A      G      35           -
LGA    G    39_A      S      36           -
LGA    R    40_A      V      37           -
LGA    -       -      S      38           -
LGA    -       -      D      39           -
LGA    E    41_A      E      40          2.823
LGA    G    42_A      I      41          3.345
LGA    K    43_A      K      42          2.292
LGA    L    44_A      E      43          1.981
LGA    A    45_A      R      44          2.053
LGA    N    46_A      T      45          1.687
LGA    V    47_A      Y      46          0.930
LGA    I    48_A      D      47          1.380
LGA    I    49_A      L      48          0.893
LGA    A    50_A      K      49          0.968
LGA    D    51_A      S      50          1.336
LGA    D    52_A      K      51          1.402
LGA    T    53_A      G      52          0.752
LGA    -       -      Q      53           -
LGA    -       -      G      54           -
LGA    G    54_A      R      55          3.380
LGA    E    55_A      M      56          2.459
LGA    L    56_A      I      57          1.132
LGA    R    57_A      Q      58          0.770
LGA    A    58_A      V      59          0.275
LGA    V    59_A      S      60          0.740
LGA    F    60_A      I      61          2.197
LGA    W    61_A      P      62          1.917
LGA    T    62_A      A      63          0.704
LGA    E    63_A      S      64          1.385
LGA    N    64_A      V      65          2.166
LGA    I    65_A      -       -           -
LGA    K    66_A      P      66          0.303
LGA    L    67_A      L      67          3.724
LGA    L    68_A      K      68          2.559
LGA    K    69_A      -       -           -
LGA    K    70_A      E      69          4.465
LGA    F    71_A      F      70          2.126
LGA    R    72_A      D      71          3.096
LGA    E    73_A      Y      72          3.936
LGA    G    74_A      N      73          3.221
LGA    D    75_A      A      74          1.328
LGA    V    76_A      R      75          1.785
LGA    I    77_A      V      76          1.003
LGA    R    78_A      E      77          0.563
LGA    I    79_A      L      78          1.126
LGA    K    80_A      I      79          1.059
LGA    D    81_A      N      80          0.550
LGA    V    82_A      P      81          2.352
LGA    N    83_A      I      82          2.009
LGA    I    84_A      -       -           -
LGA    R    85_A      -       -           -
LGA    G    86_A      -       -           -
LGA    G    87_A      -       -           -
LGA    F    88_A      -       -           -
LGA    G    89_A      -       -           -
LGA    G    90_A      -       -           -
LGA    R    91_A      -       -           -
LGA    K    92_A      W      98          1.634
LGA    E    93_A      Y      99          1.228
LGA    A    94_A      I     100          1.022
LGA    H    95_A      K     101          0.933
LGA    L    96_A      A     102          2.268
LGA    M    97_A      D     103          3.296
LGA    P    98_A      -       -           -
LGA    R    99_A      -       -           -
LGA    S   100_A      -       -           -
LGA    T   101_A      D     104          2.835
LGA    V   102_A      I     105          2.079
LGA    E   103_A      V     106          1.964
LGA    V   104_A      L     107          1.886
LGA    L   105_A      T     108          3.104
LGA    D   106_A      -       -           -
LGA    P   107_A      -       -           -
LGA    L   108_A      -       -           -
LGA    E   109_A      -       -           -
LGA    H   110_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  110   75    5.0     65    2.14     6.15     69.735     2.900

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.183701 * X  +  -0.745739 * Y  +  -0.640411 * Z  +  -2.634976
  Y_new =  -0.972903 * X  +  -0.230994 * Y  +  -0.010091 * Z  +  -0.255221
  Z_new =  -0.140405 * X  +   0.624912 * Y  +  -0.767966 * Z  +  -2.839424 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.458540   -0.683053  [ DEG:   140.8640    -39.1360 ]
  Theta =   0.140871    3.000722  [ DEG:     8.0713    171.9287 ]
  Phi   =  -1.384176    1.757417  [ DEG:   -79.3074    100.6926 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2k50_A                                        
REMARK     2: T0466.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2k50_A.T0466.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  110   75   5.0   65   2.14    6.15  69.735
REMARK  ---------------------------------------------------------- 
MOLECULE 2k50_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   23-JUN-08   2K50              
TITLE     SOLUTION NMR STRUCTURE OF THE REPLICATION FACTOR A RELATED            
TITLE    2 PROTEIN FROM METHANOBACTERIUM THERMOAUTOTROPHICUM.                   
TITLE    3 NORTHEAST STRUCTURAL GENOMICS TARGET TR91A.                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: REPLICATION FACTOR A RELATED PROTEIN;                      
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: METHANOTHERMOBACTER                             
SOURCE   3 THERMAUTOTROPHICUS STR. DELTA H;                                     
SOURCE   4 GENE: MTH1385, MTH_1385;                                             
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)+ MAGIC;                          
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET 21-23C;                               
SOURCE   9 OTHER_DETAILS: EXPERSSION MEDIA:    MJ9 100 N15 5 C13 AND            
SOURCE  10  MJ9 100 N15 100 C13                                                 
KEYWDS    UNCHARACTERIZED PROTEIN, STRUCTURAL GENOMICS, PSI-2,                  
KEYWDS   2 PROTEIN STRUCTURE INITIATIVE, NORTHEAST STRUCTURAL GENOMICS          
KEYWDS   3 CONSORTIUM, NESG, UNKNOWN FUNCTION                                   
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    P.ROSSI,R.XIAO,M.MAGLAQUI,E.L.FOOTE,C.CICCOSANTI,G.SWAPNA,            
AUTHOR   2 T.B.ACTON,B.ROST,J.K.EVERETT,M.JIANG,R.NAIR,G.T.MONTELIONE,          
AUTHOR   3 NORTHEAST STRUCTURAL GENOMICS CONSORTIUM (NESG)                      
REVDAT   1   15-JUL-08 2K50    0                                                
JRNL        AUTH   P.ROSSI,R.XIAO,T.B.ACTON,G.T.MONTELIONE                      
JRNL        TITL   SOLUTION NMR STRUCTURE OF THE REPLICATION FACTOR A           
JRNL        TITL 2 RELATED PROTEIN FROM METHANOBACTERIUM                        
JRNL        TITL 3 THERMOAUTOTROPHICUM. NORTHEAST STRUCTURAL GENOMICS           
JRNL        TITL 4 TARGET TR91A.                                                
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2K50 A    2   107  UNP    O27438   O27438_METTH    62    167             
SEQRES   1 A  115  MET LYS PRO GLU HIS ARG MET ASP THR ILE SER LYS LEU          
SEQRES   2 A  115  GLU GLU GLY ALA GLU THR PRO VAL THR GLY ARG VAL MET          
SEQRES   3 A  115  LYS ILE SER SER PRO ARG THR PHE THR THR ARG LYS GLY          
SEQRES   4 A  115  ARG GLU GLY LYS LEU ALA ASN VAL ILE ILE ALA ASP ASP          
SEQRES   5 A  115  THR GLY GLU LEU ARG ALA VAL PHE TRP THR GLU ASN ILE          
SEQRES   6 A  115  LYS LEU LEU LYS LYS PHE ARG GLU GLY ASP VAL ILE ARG          
SEQRES   7 A  115  ILE LYS ASP VAL ASN ILE ARG GLY GLY PHE GLY GLY ARG          
SEQRES   8 A  115  LYS GLU ALA HIS LEU MET PRO ARG SER THR VAL GLU VAL          
SEQRES   9 A  115  LEU ASP PRO LEU GLU HIS HIS HIS HIS HIS HIS                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1      -3.319  -8.370 -26.120  1.00  2.22           N  
ATOM      2  CA  MET A   1      -3.799  -7.674 -24.891  1.00 20.30           C  
ATOM      3  C   MET A   1      -5.329  -7.532 -24.885  1.00  4.14           C  
ATOM      4  O   MET A   1      -5.949  -7.357 -25.934  1.00 74.04           O  
ATOM      5  CB  MET A   1      -3.165  -6.279 -24.789  1.00  0.02           C  
ATOM      6  CG  MET A   1      -1.650  -6.293 -24.638  1.00 63.22           C  
ATOM      7  SD  MET A   1      -1.104  -7.072 -23.103  1.00 54.13           S  
ATOM      8  CE  MET A   1       0.676  -6.947 -23.283  1.00  2.44           C  
ATOM      9  H1  MET A   1      -2.280  -8.444 -26.113  1.00 39.40           H  
ATOM     10  H2  MET A   1      -3.609  -7.844 -26.971  1.00 39.40           H  
ATOM     11  H3  MET A   1      -3.720  -9.331 -26.171  1.00 39.40           H  
ATOM     12  HA  MET A   1      -3.499  -8.260 -24.034  1.00 11.32           H  
ATOM     13  HB2 MET A   1      -3.410  -5.720 -25.681  1.00 39.40           H  
ATOM     14  HB3 MET A   1      -3.583  -5.768 -23.933  1.00 39.40           H  
ATOM     15  HG2 MET A   1      -1.223  -6.835 -25.470  1.00 39.40           H  
ATOM     16  HG3 MET A   1      -1.293  -5.273 -24.654  1.00 39.40           H  
ATOM     17  HE1 MET A   1       1.157  -7.378 -22.417  1.00 39.40           H  
ATOM     18  HE2 MET A   1       0.957  -5.907 -23.370  1.00 39.40           H  
ATOM     19  HE3 MET A   1       0.987  -7.479 -24.170  1.00 39.40           H  
ATOM     20  N   LYS A   2      -5.940  -7.620 -23.704  1.00 14.13           N  
ATOM     21  CA  LYS A   2      -7.373  -7.333 -23.562  1.00 61.53           C  
ATOM     22  C   LYS A   2      -7.622  -5.807 -23.547  1.00 73.44           C  
ATOM     23  O   LYS A   2      -6.794  -5.045 -23.047  1.00 41.13           O  
ATOM     24  CB  LYS A   2      -7.945  -8.007 -22.299  1.00 43.03           C  
ATOM     25  CG  LYS A   2      -7.224  -7.655 -20.998  1.00 63.24           C  
ATOM     26  CD  LYS A   2      -7.867  -8.353 -19.797  1.00  1.34           C  
ATOM     27  CE  LYS A   2      -7.155  -8.026 -18.487  1.00 21.13           C  
ATOM     28  NZ  LYS A   2      -5.755  -8.532 -18.465  1.00 13.04           N  
ATOM     29  H   LYS A   2      -5.423  -7.898 -22.918  1.00 39.40           H  
ATOM     30  HA  LYS A   2      -7.871  -7.748 -24.428  1.00 35.25           H  
ATOM     31  HB2 LYS A   2      -8.983  -7.722 -22.195  1.00 39.40           H  
ATOM     32  HB3 LYS A   2      -7.894  -9.080 -22.431  1.00 39.40           H  
ATOM     33  HG2 LYS A   2      -6.192  -7.968 -21.075  1.00 39.40           H  
ATOM     34  HG3 LYS A   2      -7.267  -6.585 -20.850  1.00 39.40           H  
ATOM     35  HD2 LYS A   2      -8.898  -8.036 -19.718  1.00 39.40           H  
ATOM     36  HD3 LYS A   2      -7.832  -9.422 -19.956  1.00 39.40           H  
ATOM     37  HE2 LYS A   2      -7.141  -6.955 -18.355  1.00 39.40           H  
ATOM     38  HE3 LYS A   2      -7.703  -8.479 -17.672  1.00 39.40           H  
ATOM     39  HZ1 LYS A   2      -5.286  -8.237 -17.590  1.00 39.40           H  
ATOM     40  HZ2 LYS A   2      -5.220  -8.151 -19.273  1.00 39.40           H  
ATOM     41  HZ3 LYS A   2      -5.744  -9.570 -18.519  1.00 39.40           H  
ATOM     42  N   PRO A   3      -8.764  -5.347 -24.109  1.00 42.54           N  
ATOM     43  CA  PRO A   3      -9.050  -3.905 -24.313  1.00 23.42           C  
ATOM     44  C   PRO A   3      -8.889  -3.029 -23.053  1.00 72.34           C  
ATOM     45  O   PRO A   3      -9.277  -3.417 -21.950  1.00 44.04           O  
ATOM     46  CB  PRO A   3     -10.519  -3.889 -24.794  1.00 44.14           C  
ATOM     47  CG  PRO A   3     -11.049  -5.256 -24.498  1.00 63.21           C  
ATOM     48  CD  PRO A   3      -9.870  -6.182 -24.600  1.00 24.13           C  
ATOM     49  HA  PRO A   3      -8.421  -3.500 -25.095  1.00 32.00           H  
ATOM     50  HB2 PRO A   3     -11.073  -3.127 -24.262  1.00 39.40           H  
ATOM     51  HB3 PRO A   3     -10.547  -3.680 -25.854  1.00 39.40           H  
ATOM     52  HG2 PRO A   3     -11.463  -5.282 -23.499  1.00 39.40           H  
ATOM     53  HG3 PRO A   3     -11.804  -5.526 -25.223  1.00 39.40           H  
ATOM     54  HD2 PRO A   3     -10.013  -7.051 -23.971  1.00 39.40           H  
ATOM     55  HD3 PRO A   3      -9.705  -6.478 -25.626  1.00 39.40           H  
ATOM     56  N   GLU A   4      -8.346  -1.821 -23.249  1.00 72.33           N  
ATOM     57  CA  GLU A   4      -8.120  -0.856 -22.157  1.00 24.21           C  
ATOM     58  C   GLU A   4      -9.421  -0.507 -21.416  1.00  1.13           C  
ATOM     59  O   GLU A   4      -9.412  -0.244 -20.212  1.00 32.22           O  
ATOM     60  CB  GLU A   4      -7.506   0.435 -22.721  1.00 30.13           C  
ATOM     61  CG  GLU A   4      -6.172   0.239 -23.431  1.00 50.33           C  
ATOM     62  CD  GLU A   4      -5.685   1.512 -24.104  1.00 63.54           C  
ATOM     63  OE1 GLU A   4      -5.065   2.355 -23.423  1.00 62.11           O  
ATOM     64  OE2 GLU A   4      -5.936   1.683 -25.318  1.00 32.14           O  
ATOM     65  H   GLU A   4      -8.087  -1.568 -24.159  1.00 39.40           H  
ATOM     66  HA  GLU A   4      -7.426  -1.298 -21.458  1.00  2.13           H  
ATOM     67  HB2 GLU A   4      -8.201   0.871 -23.425  1.00 39.40           H  
ATOM     68  HB3 GLU A   4      -7.355   1.130 -21.906  1.00 39.40           H  
ATOM     69  HG2 GLU A   4      -5.434  -0.076 -22.706  1.00 39.40           H  
ATOM     70  HG3 GLU A   4      -6.285  -0.531 -24.183  1.00 39.40           H  
ATOM     71  N   HIS A   5     -10.536  -0.501 -22.143  1.00 63.11           N  
ATOM     72  CA  HIS A   5     -11.843  -0.162 -21.561  1.00 43.42           C  
ATOM     73  C   HIS A   5     -12.370  -1.259 -20.619  1.00 61.43           C  
ATOM     74  O   HIS A   5     -13.418  -1.094 -19.991  1.00 11.01           O  
ATOM     75  CB  HIS A   5     -12.869   0.107 -22.672  1.00 73.33           C  
ATOM     76  CG  HIS A   5     -12.657   1.406 -23.393  1.00 71.42           C  
ATOM     77  ND1 HIS A   5     -12.092   1.492 -24.647  1.00 61.44           N  
ATOM     78  CD2 HIS A   5     -12.952   2.677 -23.034  1.00 33.11           C  
ATOM     79  CE1 HIS A   5     -12.048   2.752 -25.025  1.00  1.12           C  
ATOM     80  NE2 HIS A   5     -12.563   3.490 -24.068  1.00 21.44           N  
ATOM     81  H   HIS A   5     -10.479  -0.727 -23.095  1.00 39.40           H  
ATOM     82  HA  HIS A   5     -11.717   0.745 -20.985  1.00 64.32           H  
ATOM     83  HB2 HIS A   5     -12.816  -0.690 -23.399  1.00 39.40           H  
ATOM     84  HB3 HIS A   5     -13.862   0.125 -22.241  1.00 39.40           H  
ATOM     85  HD1 HIS A   5     -11.769   0.737 -25.184  1.00 13.21           H  
ATOM     86  HD2 HIS A   5     -13.411   2.993 -22.107  1.00 34.31           H  
ATOM     87  HE1 HIS A   5     -11.659   3.116 -25.964  1.00 34.24           H  
ATOM     88  HE2 HIS A   5     -12.514   4.470 -24.029  1.00 39.40           H  
ATOM     89  N   ARG A   6     -11.662  -2.382 -20.532  1.00  2.11           N  
ATOM     90  CA  ARG A   6     -12.061  -3.470 -19.635  1.00 44.12           C  
ATOM     91  C   ARG A   6     -11.461  -3.290 -18.231  1.00 52.52           C  
ATOM     92  O   ARG A   6     -10.243  -3.300 -18.056  1.00 74.22           O  
ATOM     93  CB  ARG A   6     -11.644  -4.832 -20.206  1.00 54.54           C  
ATOM     94  CG  ARG A   6     -11.891  -5.982 -19.236  1.00 71.30           C  
ATOM     95  CD  ARG A   6     -11.505  -7.330 -19.823  1.00 12.02           C  
ATOM     96  NE  ARG A   6     -11.550  -8.376 -18.808  1.00 53.25           N  
ATOM     97  CZ  ARG A   6     -12.148  -9.525 -18.950  1.00 31.43           C  
ATOM     98  NH1 ARG A   6     -12.789  -9.811 -20.036  1.00 24.10           N  
ATOM     99  NH2 ARG A   6     -12.126 -10.376 -17.982  1.00 23.23           N  
ATOM    100  H   ARG A   6     -10.851  -2.481 -21.074  1.00 39.40           H  
ATOM    101  HA  ARG A   6     -13.141  -3.446 -19.555  1.00 24.40           H  
ATOM    102  HB2 ARG A   6     -12.207  -5.019 -21.111  1.00 39.40           H  
ATOM    103  HB3 ARG A   6     -10.590  -4.806 -20.446  1.00 39.40           H  
ATOM    104  HG2 ARG A   6     -11.306  -5.815 -18.342  1.00 39.40           H  
ATOM    105  HG3 ARG A   6     -12.941  -6.000 -18.978  1.00 39.40           H  
ATOM    106  HD2 ARG A   6     -12.193  -7.573 -20.620  1.00 39.40           H  
ATOM    107  HD3 ARG A   6     -10.502  -7.265 -20.219  1.00 39.40           H  
ATOM    108  HE  ARG A   6     -11.093  -8.195 -17.955  1.00 73.03           H  
ATOM    109 HH11 ARG A   6     -12.839  -9.145 -20.776  1.00 39.40           H  
ATOM    110 HH12 ARG A   6     -13.225 -10.701 -20.137  1.00 39.40           H  
ATOM    111 HH21 ARG A   6     -11.650 -10.144 -17.131  1.00 39.40           H  
ATOM    112 HH22 ARG A   6     -12.580 -11.256 -18.078  1.00 39.40           H  
ATOM    113  N   MET A   7     -12.327  -3.123 -17.236  1.00 35.30           N  
ATOM    114  CA  MET A   7     -11.892  -2.984 -15.840  1.00 42.33           C  
ATOM    115  C   MET A   7     -12.301  -4.215 -15.011  1.00 20.44           C  
ATOM    116  O   MET A   7     -13.469  -4.383 -14.645  1.00  0.33           O  
ATOM    117  CB  MET A   7     -12.464  -1.688 -15.232  1.00 51.35           C  
ATOM    118  CG  MET A   7     -13.965  -1.516 -15.425  1.00 72.41           C  
ATOM    119  SD  MET A   7     -14.565   0.090 -14.857  1.00 35.12           S  
ATOM    120  CE  MET A   7     -14.180   0.011 -13.108  1.00 23.25           C  
ATOM    121  H   MET A   7     -13.280  -3.101 -17.440  1.00 39.40           H  
ATOM    122  HA  MET A   7     -10.810  -2.918 -15.838  1.00 51.15           H  
ATOM    123  HB2 MET A   7     -12.257  -1.679 -14.171  1.00 39.40           H  
ATOM    124  HB3 MET A   7     -11.965  -0.842 -15.689  1.00 39.40           H  
ATOM    125  HG2 MET A   7     -14.194  -1.618 -16.476  1.00 39.40           H  
ATOM    126  HG3 MET A   7     -14.475  -2.292 -14.872  1.00 39.40           H  
ATOM    127  HE1 MET A   7     -14.480   0.934 -12.635  1.00 39.40           H  
ATOM    128  HE2 MET A   7     -13.118  -0.131 -12.979  1.00 39.40           H  
ATOM    129  HE3 MET A   7     -14.710  -0.815 -12.658  1.00 39.40           H  
ATOM    130  N   ASP A   8     -11.333  -5.090 -14.749  1.00 20.01           N  
ATOM    131  CA  ASP A   8     -11.574  -6.327 -13.999  1.00 11.13           C  
ATOM    132  C   ASP A   8     -11.701  -6.078 -12.486  1.00 55.11           C  
ATOM    133  O   ASP A   8     -11.132  -5.131 -11.943  1.00 31.24           O  
ATOM    134  CB  ASP A   8     -10.443  -7.324 -14.277  1.00 63.30           C  
ATOM    135  CG  ASP A   8     -10.439  -7.807 -15.718  1.00 22.41           C  
ATOM    136  OD1 ASP A   8      -9.913  -7.094 -16.595  1.00 43.52           O  
ATOM    137  OD2 ASP A   8     -10.958  -8.914 -15.981  1.00 35.03           O  
ATOM    138  H   ASP A   8     -10.427  -4.908 -15.080  1.00 39.40           H  
ATOM    139  HA  ASP A   8     -12.504  -6.751 -14.355  1.00 75.52           H  
ATOM    140  HB2 ASP A   8      -9.492  -6.850 -14.071  1.00 39.40           H  
ATOM    141  HB3 ASP A   8     -10.555  -8.182 -13.626  1.00 39.40           H  
ATOM    142  N   THR A   9     -12.462  -6.940 -11.815  1.00 71.22           N  
ATOM    143  CA  THR A   9     -12.633  -6.870 -10.356  1.00 41.31           C  
ATOM    144  C   THR A   9     -11.544  -7.678  -9.638  1.00  3.22           C  
ATOM    145  O   THR A   9     -10.789  -8.408 -10.279  1.00 74.40           O  
ATOM    146  CB  THR A   9     -14.017  -7.408  -9.924  1.00 60.31           C  
ATOM    147  OG1 THR A   9     -14.143  -8.789 -10.299  1.00 53.52           O  
ATOM    148  CG2 THR A   9     -15.141  -6.601 -10.566  1.00 51.23           C  
ATOM    149  H   THR A   9     -12.919  -7.649 -12.311  1.00 39.40           H  
ATOM    150  HA  THR A   9     -12.560  -5.834 -10.055  1.00 44.41           H  
ATOM    151  HB  THR A   9     -14.102  -7.326  -8.848  1.00 33.05           H  
ATOM    152  HG1 THR A   9     -15.060  -9.067 -10.188  1.00 62.33           H  
ATOM    153 HG21 THR A   9     -15.062  -5.566 -10.264  1.00 39.40           H  
ATOM    154 HG22 THR A   9     -16.097  -6.994 -10.247  1.00 39.40           H  
ATOM    155 HG23 THR A   9     -15.067  -6.668 -11.641  1.00 39.40           H  
ATOM    156  N   ILE A  10     -11.479  -7.573  -8.306  1.00 61.24           N  
ATOM    157  CA  ILE A  10     -10.427  -8.245  -7.524  1.00 73.30           C  
ATOM    158  C   ILE A  10     -10.328  -9.753  -7.840  1.00 61.42           C  
ATOM    159  O   ILE A  10      -9.227 -10.298  -7.982  1.00 61.44           O  
ATOM    160  CB  ILE A  10     -10.631  -8.032  -5.999  1.00 23.42           C  
ATOM    161  CG1 ILE A  10     -10.531  -6.530  -5.664  1.00 43.32           C  
ATOM    162  CG2 ILE A  10      -9.612  -8.842  -5.190  1.00 65.34           C  
ATOM    163  CD1 ILE A  10     -10.629  -6.214  -4.182  1.00 43.41           C  
ATOM    164  H   ILE A  10     -12.148  -7.033  -7.837  1.00 39.40           H  
ATOM    165  HA  ILE A  10      -9.486  -7.786  -7.796  1.00 71.04           H  
ATOM    166  HB  ILE A  10     -11.621  -8.384  -5.741  1.00 43.45           H  
ATOM    167 HG12 ILE A  10      -9.582  -6.151  -6.016  1.00 39.40           H  
ATOM    168 HG13 ILE A  10     -11.330  -6.002  -6.167  1.00 39.40           H  
ATOM    169 HG21 ILE A  10      -9.714  -9.892  -5.424  1.00 39.40           H  
ATOM    170 HG22 ILE A  10      -9.789  -8.692  -4.135  1.00 39.40           H  
ATOM    171 HG23 ILE A  10      -8.612  -8.514  -5.436  1.00 39.40           H  
ATOM    172 HD11 ILE A  10      -9.804  -6.672  -3.658  1.00 39.40           H  
ATOM    173 HD12 ILE A  10     -11.561  -6.597  -3.794  1.00 39.40           H  
ATOM    174 HD13 ILE A  10     -10.595  -5.143  -4.040  1.00 39.40           H  
ATOM    175  N   SER A  11     -11.473 -10.421  -7.973  1.00 43.13           N  
ATOM    176  CA  SER A  11     -11.489 -11.852  -8.331  1.00 40.23           C  
ATOM    177  C   SER A  11     -11.025 -12.083  -9.779  1.00 21.23           C  
ATOM    178  O   SER A  11     -10.489 -13.140 -10.111  1.00 61.52           O  
ATOM    179  CB  SER A  11     -12.894 -12.443  -8.148  1.00 14.01           C  
ATOM    180  OG  SER A  11     -12.919 -13.836  -8.423  1.00 30.10           O  
ATOM    181  H   SER A  11     -12.325  -9.951  -7.814  1.00 39.40           H  
ATOM    182  HA  SER A  11     -10.810 -12.362  -7.666  1.00 41.41           H  
ATOM    183  HB2 SER A  11     -13.216 -12.288  -7.129  1.00 39.40           H  
ATOM    184  HB3 SER A  11     -13.581 -11.945  -8.819  1.00 39.40           H  
ATOM    185  HG  SER A  11     -13.588 -14.260  -7.867  1.00 74.33           H  
ATOM    186  N   LYS A  12     -11.224 -11.085 -10.638  1.00 61.44           N  
ATOM    187  CA  LYS A  12     -10.883 -11.205 -12.065  1.00 65.21           C  
ATOM    188  C   LYS A  12      -9.492 -10.626 -12.390  1.00 25.13           C  
ATOM    189  O   LYS A  12      -8.993 -10.797 -13.502  1.00 51.21           O  
ATOM    190  CB  LYS A  12     -11.950 -10.501 -12.921  1.00 51.13           C  
ATOM    191  CG  LYS A  12     -13.366 -11.037 -12.724  1.00 71.03           C  
ATOM    192  CD  LYS A  12     -13.487 -12.513 -13.105  1.00 12.03           C  
ATOM    193  CE  LYS A  12     -13.198 -12.751 -14.585  1.00 64.25           C  
ATOM    194  NZ  LYS A  12     -13.394 -14.175 -14.970  1.00 64.14           N  
ATOM    195  H   LYS A  12     -11.608 -10.244 -10.309  1.00 39.40           H  
ATOM    196  HA  LYS A  12     -10.881 -12.258 -12.314  1.00 75.10           H  
ATOM    197  HB2 LYS A  12     -11.951  -9.448 -12.677  1.00 39.40           H  
ATOM    198  HB3 LYS A  12     -11.689 -10.615 -13.964  1.00 39.40           H  
ATOM    199  HG2 LYS A  12     -13.639 -10.924 -11.685  1.00 39.40           H  
ATOM    200  HG3 LYS A  12     -14.045 -10.459 -13.337  1.00 39.40           H  
ATOM    201  HD2 LYS A  12     -12.784 -13.082 -12.517  1.00 39.40           H  
ATOM    202  HD3 LYS A  12     -14.491 -12.848 -12.887  1.00 39.40           H  
ATOM    203  HE2 LYS A  12     -13.863 -12.138 -15.175  1.00 39.40           H  
ATOM    204  HE3 LYS A  12     -12.175 -12.470 -14.791  1.00 39.40           H  
ATOM    205  HZ1 LYS A  12     -13.175 -14.307 -15.979  1.00 39.40           H  
ATOM    206  HZ2 LYS A  12     -14.381 -14.458 -14.801  1.00 39.40           H  
ATOM    207  HZ3 LYS A  12     -12.771 -14.789 -14.409  1.00 39.40           H  
ATOM    208  N   LEU A  13      -8.874  -9.937 -11.424  1.00 11.14           N  
ATOM    209  CA  LEU A  13      -7.537  -9.349 -11.621  1.00 52.31           C  
ATOM    210  C   LEU A  13      -6.511 -10.393 -12.093  1.00 54.22           C  
ATOM    211  O   LEU A  13      -6.298 -11.418 -11.443  1.00 23.42           O  
ATOM    212  CB  LEU A  13      -7.043  -8.679 -10.330  1.00 14.30           C  
ATOM    213  CG  LEU A  13      -7.825  -7.432  -9.892  1.00  1.23           C  
ATOM    214  CD1 LEU A  13      -7.262  -6.875  -8.591  1.00 20.45           C  
ATOM    215  CD2 LEU A  13      -7.817  -6.368 -10.987  1.00 25.10           C  
ATOM    216  H   LEU A  13      -9.330  -9.807 -10.567  1.00 39.40           H  
ATOM    217  HA  LEU A  13      -7.629  -8.591 -12.388  1.00  0.34           H  
ATOM    218  HB2 LEU A  13      -7.095  -9.407  -9.532  1.00 39.40           H  
ATOM    219  HB3 LEU A  13      -6.006  -8.396 -10.466  1.00 39.40           H  
ATOM    220  HG  LEU A  13      -8.853  -7.712  -9.710  1.00  4.43           H  
ATOM    221 HD11 LEU A  13      -7.351  -7.622  -7.813  1.00 39.40           H  
ATOM    222 HD12 LEU A  13      -7.818  -5.994  -8.303  1.00 39.40           H  
ATOM    223 HD13 LEU A  13      -6.221  -6.617  -8.725  1.00 39.40           H  
ATOM    224 HD21 LEU A  13      -8.283  -6.764 -11.878  1.00 39.40           H  
ATOM    225 HD22 LEU A  13      -6.797  -6.083 -11.209  1.00 39.40           H  
ATOM    226 HD23 LEU A  13      -8.367  -5.501 -10.651  1.00 39.40           H  
ATOM    227  N   GLU A  14      -5.883 -10.112 -13.227  1.00 21.41           N  
ATOM    228  CA  GLU A  14      -4.901 -11.012 -13.834  1.00 22.12           C  
ATOM    229  C   GLU A  14      -3.481 -10.727 -13.314  1.00 62.21           C  
ATOM    230  O   GLU A  14      -3.050  -9.573 -13.260  1.00  3.52           O  
ATOM    231  CB  GLU A  14      -4.946 -10.832 -15.359  1.00 71.01           C  
ATOM    232  CG  GLU A  14      -3.977 -11.718 -16.137  1.00 21.24           C  
ATOM    233  CD  GLU A  14      -3.882 -11.323 -17.604  1.00 33.35           C  
ATOM    234  OE1 GLU A  14      -4.935 -11.154 -18.253  1.00 11.24           O  
ATOM    235  OE2 GLU A  14      -2.753 -11.152 -18.110  1.00 22.42           O  
ATOM    236  H   GLU A  14      -6.091  -9.270 -13.679  1.00 39.40           H  
ATOM    237  HA  GLU A  14      -5.172 -12.027 -13.587  1.00 24.14           H  
ATOM    238  HB2 GLU A  14      -5.946 -11.052 -15.700  1.00 39.40           H  
ATOM    239  HB3 GLU A  14      -4.721  -9.800 -15.591  1.00 39.40           H  
ATOM    240  HG2 GLU A  14      -2.995 -11.637 -15.690  1.00 39.40           H  
ATOM    241  HG3 GLU A  14      -4.317 -12.742 -16.074  1.00 39.40           H  
ATOM    242  N   GLU A  15      -2.752 -11.777 -12.933  1.00 75.52           N  
ATOM    243  CA  GLU A  15      -1.365 -11.620 -12.473  1.00 51.33           C  
ATOM    244  C   GLU A  15      -0.436 -11.219 -13.636  1.00 12.04           C  
ATOM    245  O   GLU A  15      -0.511 -11.779 -14.733  1.00 34.44           O  
ATOM    246  CB  GLU A  15      -0.861 -12.909 -11.802  1.00 23.41           C  
ATOM    247  CG  GLU A  15      -0.866 -14.138 -12.708  1.00 11.21           C  
ATOM    248  CD  GLU A  15      -0.290 -15.371 -12.026  1.00 40.55           C  
ATOM    249  OE1 GLU A  15      -1.043 -16.082 -11.331  1.00  2.41           O  
ATOM    250  OE2 GLU A  15       0.921 -15.639 -12.182  1.00 20.43           O  
ATOM    251  H   GLU A  15      -3.152 -12.670 -12.957  1.00 39.40           H  
ATOM    252  HA  GLU A  15      -1.358 -10.823 -11.741  1.00  0.01           H  
ATOM    253  HB2 GLU A  15       0.151 -12.747 -11.461  1.00 39.40           H  
ATOM    254  HB3 GLU A  15      -1.487 -13.119 -10.945  1.00 39.40           H  
ATOM    255  HG2 GLU A  15      -1.884 -14.348 -13.005  1.00 39.40           H  
ATOM    256  HG3 GLU A  15      -0.278 -13.921 -13.590  1.00 39.40           H  
ATOM    257  N   GLY A  16       0.436 -10.243 -13.389  1.00 25.03           N  
ATOM    258  CA  GLY A  16       1.295  -9.706 -14.442  1.00  0.33           C  
ATOM    259  C   GLY A  16       0.599  -8.646 -15.295  1.00 42.44           C  
ATOM    260  O   GLY A  16       1.176  -8.132 -16.260  1.00 62.20           O  
ATOM    261  H   GLY A  16       0.506  -9.887 -12.482  1.00 39.40           H  
ATOM    262  HA2 GLY A  16       2.168  -9.263 -13.984  1.00 39.40           H  
ATOM    263  HA3 GLY A  16       1.614 -10.516 -15.084  1.00 39.40           H  
ATOM    264  N   ALA A  17      -0.645  -8.320 -14.944  1.00 61.33           N  
ATOM    265  CA  ALA A  17      -1.426  -7.320 -15.678  1.00 11.44           C  
ATOM    266  C   ALA A  17      -1.315  -5.921 -15.053  1.00 70.14           C  
ATOM    267  O   ALA A  17      -1.081  -5.774 -13.851  1.00 50.12           O  
ATOM    268  CB  ALA A  17      -2.887  -7.747 -15.741  1.00 54.03           C  
ATOM    269  H   ALA A  17      -1.051  -8.764 -14.170  1.00 39.40           H  
ATOM    270  HA  ALA A  17      -1.049  -7.279 -16.692  1.00 61.51           H  
ATOM    271  HB1 ALA A  17      -3.297  -7.775 -14.741  1.00 39.40           H  
ATOM    272  HB2 ALA A  17      -2.958  -8.730 -16.185  1.00 39.40           H  
ATOM    273  HB3 ALA A  17      -3.446  -7.043 -16.339  1.00 39.40           H  
ATOM    274  N   GLU A  18      -1.500  -4.895 -15.882  1.00 74.42           N  
ATOM    275  CA  GLU A  18      -1.497  -3.505 -15.419  1.00 71.31           C  
ATOM    276  C   GLU A  18      -2.916  -2.916 -15.516  1.00 40.44           C  
ATOM    277  O   GLU A  18      -3.428  -2.689 -16.613  1.00 33.44           O  
ATOM    278  CB  GLU A  18      -0.508  -2.691 -16.269  1.00 14.40           C  
ATOM    279  CG  GLU A  18      -0.264  -1.270 -15.775  1.00 11.51           C  
ATOM    280  CD  GLU A  18       0.850  -0.576 -16.553  1.00 61.41           C  
ATOM    281  OE1 GLU A  18       2.039  -0.792 -16.220  1.00 60.41           O  
ATOM    282  OE2 GLU A  18       0.547   0.172 -17.504  1.00 72.22           O  
ATOM    283  H   GLU A  18      -1.643  -5.077 -16.835  1.00 39.40           H  
ATOM    284  HA  GLU A  18      -1.175  -3.489 -14.384  1.00 63.34           H  
ATOM    285  HB2 GLU A  18       0.441  -3.209 -16.282  1.00 39.40           H  
ATOM    286  HB3 GLU A  18      -0.886  -2.636 -17.280  1.00 39.40           H  
ATOM    287  HG2 GLU A  18      -1.175  -0.700 -15.885  1.00 39.40           H  
ATOM    288  HG3 GLU A  18       0.013  -1.305 -14.730  1.00 39.40           H  
ATOM    289  N   THR A  19      -3.549  -2.697 -14.367  1.00 33.40           N  
ATOM    290  CA  THR A  19      -4.950  -2.238 -14.321  1.00 40.22           C  
ATOM    291  C   THR A  19      -5.235  -1.421 -13.054  1.00 33.31           C  
ATOM    292  O   THR A  19      -4.568  -1.601 -12.040  1.00 35.50           O  
ATOM    293  CB  THR A  19      -5.931  -3.442 -14.372  1.00 21.23           C  
ATOM    294  OG1 THR A  19      -7.291  -2.998 -14.239  1.00 15.13           O  
ATOM    295  CG2 THR A  19      -5.612  -4.460 -13.280  1.00 54.10           C  
ATOM    296  H   THR A  19      -3.066  -2.841 -13.522  1.00 39.40           H  
ATOM    297  HA  THR A  19      -5.129  -1.617 -15.187  1.00 24.31           H  
ATOM    298  HB  THR A  19      -5.820  -3.928 -15.332  1.00 72.33           H  
ATOM    299  HG1 THR A  19      -7.522  -2.929 -13.305  1.00 61.42           H  
ATOM    300 HG21 THR A  19      -4.606  -4.833 -13.416  1.00 39.40           H  
ATOM    301 HG22 THR A  19      -6.311  -5.282 -13.336  1.00 39.40           H  
ATOM    302 HG23 THR A  19      -5.690  -3.988 -12.312  1.00 39.40           H  
ATOM    303  N   PRO A  20      -6.210  -0.491 -13.096  1.00  4.32           N  
ATOM    304  CA  PRO A  20      -6.692   0.198 -11.884  1.00 54.41           C  
ATOM    305  C   PRO A  20      -7.588  -0.712 -11.014  1.00 11.31           C  
ATOM    306  O   PRO A  20      -8.276  -1.596 -11.527  1.00 21.14           O  
ATOM    307  CB  PRO A  20      -7.494   1.376 -12.454  1.00 61.33           C  
ATOM    308  CG  PRO A  20      -7.976   0.896 -13.783  1.00 60.43           C  
ATOM    309  CD  PRO A  20      -6.895  -0.014 -14.315  1.00 32.53           C  
ATOM    310  HA  PRO A  20      -5.871   0.569 -11.287  1.00 34.42           H  
ATOM    311  HB2 PRO A  20      -8.318   1.615 -11.793  1.00 39.40           H  
ATOM    312  HB3 PRO A  20      -6.851   2.239 -12.556  1.00 39.40           H  
ATOM    313  HG2 PRO A  20      -8.903   0.353 -13.663  1.00 39.40           H  
ATOM    314  HG3 PRO A  20      -8.121   1.738 -14.447  1.00 39.40           H  
ATOM    315  HD2 PRO A  20      -7.331  -0.839 -14.860  1.00 39.40           H  
ATOM    316  HD3 PRO A  20      -6.214   0.538 -14.948  1.00 39.40           H  
ATOM    317  N   VAL A  21      -7.572  -0.494  -9.695  1.00 53.42           N  
ATOM    318  CA  VAL A  21      -8.360  -1.310  -8.756  1.00 63.11           C  
ATOM    319  C   VAL A  21      -9.246  -0.443  -7.840  1.00  3.34           C  
ATOM    320  O   VAL A  21      -8.975   0.740  -7.631  1.00 31.24           O  
ATOM    321  CB  VAL A  21      -7.443  -2.203  -7.878  1.00 31.03           C  
ATOM    322  CG1 VAL A  21      -6.654  -3.185  -8.743  1.00 53.02           C  
ATOM    323  CG2 VAL A  21      -6.498  -1.349  -7.028  1.00 73.21           C  
ATOM    324  H   VAL A  21      -7.016   0.231  -9.341  1.00 39.40           H  
ATOM    325  HA  VAL A  21      -9.003  -1.959  -9.337  1.00 73.45           H  
ATOM    326  HB  VAL A  21      -8.072  -2.777  -7.208  1.00 44.24           H  
ATOM    327 HG11 VAL A  21      -6.017  -3.790  -8.113  1.00 39.40           H  
ATOM    328 HG12 VAL A  21      -6.045  -2.637  -9.448  1.00 39.40           H  
ATOM    329 HG13 VAL A  21      -7.338  -3.824  -9.281  1.00 39.40           H  
ATOM    330 HG21 VAL A  21      -7.075  -0.691  -6.395  1.00 39.40           H  
ATOM    331 HG22 VAL A  21      -5.863  -0.761  -7.674  1.00 39.40           H  
ATOM    332 HG23 VAL A  21      -5.886  -1.993  -6.413  1.00 39.40           H  
ATOM    333  N   THR A  22     -10.304  -1.044  -7.290  1.00 74.31           N  
ATOM    334  CA  THR A  22     -11.239  -0.329  -6.400  1.00 72.41           C  
ATOM    335  C   THR A  22     -11.689  -1.222  -5.237  1.00 21.12           C  
ATOM    336  O   THR A  22     -11.922  -2.416  -5.422  1.00 13.12           O  
ATOM    337  CB  THR A  22     -12.500   0.148  -7.166  1.00 13.12           C  
ATOM    338  OG1 THR A  22     -12.122   0.921  -8.314  1.00 22.43           O  
ATOM    339  CG2 THR A  22     -13.413   0.986  -6.271  1.00 45.31           C  
ATOM    340  H   THR A  22     -10.465  -1.992  -7.480  1.00 39.40           H  
ATOM    341  HA  THR A  22     -10.730   0.541  -6.001  1.00 14.44           H  
ATOM    342  HB  THR A  22     -13.050  -0.722  -7.499  1.00 44.40           H  
ATOM    343  HG1 THR A  22     -11.706   0.346  -8.962  1.00 14.41           H  
ATOM    344 HG21 THR A  22     -14.262   1.328  -6.845  1.00 39.40           H  
ATOM    345 HG22 THR A  22     -12.866   1.840  -5.894  1.00 39.40           H  
ATOM    346 HG23 THR A  22     -13.758   0.385  -5.443  1.00 39.40           H  
ATOM    347  N   GLY A  23     -11.815  -0.641  -4.043  1.00 72.31           N  
ATOM    348  CA  GLY A  23     -12.275  -1.405  -2.885  1.00  5.14           C  
ATOM    349  C   GLY A  23     -12.425  -0.568  -1.615  1.00  5.21           C  
ATOM    350  O   GLY A  23     -11.966   0.577  -1.549  1.00  2.23           O  
ATOM    351  H   GLY A  23     -11.587   0.310  -3.944  1.00 39.40           H  
ATOM    352  HA2 GLY A  23     -13.234  -1.844  -3.120  1.00 39.40           H  
ATOM    353  HA3 GLY A  23     -11.569  -2.202  -2.694  1.00 39.40           H  
ATOM    354  N   ARG A  24     -13.079  -1.139  -0.605  1.00 61.13           N  
ATOM    355  CA  ARG A  24     -13.242  -0.476   0.696  1.00 12.54           C  
ATOM    356  C   ARG A  24     -12.055  -0.779   1.623  1.00 14.32           C  
ATOM    357  O   ARG A  24     -11.744  -1.939   1.885  1.00 25.01           O  
ATOM    358  CB  ARG A  24     -14.554  -0.914   1.368  1.00 63.40           C  
ATOM    359  CG  ARG A  24     -15.809  -0.438   0.638  1.00 34.24           C  
ATOM    360  CD  ARG A  24     -17.080  -0.687   1.449  1.00 44.11           C  
ATOM    361  NE  ARG A  24     -18.182   0.173   1.010  1.00 73.23           N  
ATOM    362  CZ  ARG A  24     -19.430  -0.197   0.943  1.00 21.03           C  
ATOM    363  NH1 ARG A  24     -19.778  -1.409   1.232  1.00 15.52           N  
ATOM    364  NH2 ARG A  24     -20.340   0.652   0.586  1.00 55.43           N  
ATOM    365  H   ARG A  24     -13.460  -2.034  -0.734  1.00 39.40           H  
ATOM    366  HA  ARG A  24     -13.278   0.590   0.520  1.00 22.15           H  
ATOM    367  HB2 ARG A  24     -14.578  -1.994   1.414  1.00 39.40           H  
ATOM    368  HB3 ARG A  24     -14.577  -0.520   2.375  1.00 39.40           H  
ATOM    369  HG2 ARG A  24     -15.721   0.618   0.446  1.00 39.40           H  
ATOM    370  HG3 ARG A  24     -15.886  -0.966  -0.303  1.00 39.40           H  
ATOM    371  HD2 ARG A  24     -17.371  -1.722   1.334  1.00 39.40           H  
ATOM    372  HD3 ARG A  24     -16.877  -0.486   2.491  1.00 39.40           H  
ATOM    373  HE  ARG A  24     -17.964   1.097   0.775  1.00 23.40           H  
ATOM    374 HH11 ARG A  24     -19.090  -2.073   1.514  1.00 39.40           H  
ATOM    375 HH12 ARG A  24     -20.738  -1.675   1.177  1.00 39.40           H  
ATOM    376 HH21 ARG A  24     -20.087   1.596   0.365  1.00 39.40           H  
ATOM    377 HH22 ARG A  24     -21.293   0.361   0.530  1.00 39.40           H  
ATOM    378  N   VAL A  25     -11.402   0.268   2.122  1.00 22.33           N  
ATOM    379  CA  VAL A  25     -10.236   0.106   2.995  1.00  0.41           C  
ATOM    380  C   VAL A  25     -10.626  -0.495   4.354  1.00 61.31           C  
ATOM    381  O   VAL A  25     -11.231   0.177   5.189  1.00 51.20           O  
ATOM    382  CB  VAL A  25      -9.519   1.457   3.238  1.00 63.55           C  
ATOM    383  CG1 VAL A  25      -8.275   1.269   4.103  1.00  2.41           C  
ATOM    384  CG2 VAL A  25      -9.164   2.130   1.916  1.00 54.55           C  
ATOM    385  H   VAL A  25     -11.713   1.173   1.906  1.00 39.40           H  
ATOM    386  HA  VAL A  25      -9.543  -0.562   2.502  1.00 63.23           H  
ATOM    387  HB  VAL A  25     -10.200   2.107   3.771  1.00  4.14           H  
ATOM    388 HG11 VAL A  25      -7.796   2.225   4.259  1.00 39.40           H  
ATOM    389 HG12 VAL A  25      -7.585   0.601   3.607  1.00 39.40           H  
ATOM    390 HG13 VAL A  25      -8.558   0.849   5.057  1.00 39.40           H  
ATOM    391 HG21 VAL A  25      -8.649   3.061   2.111  1.00 39.40           H  
ATOM    392 HG22 VAL A  25     -10.068   2.331   1.359  1.00 39.40           H  
ATOM    393 HG23 VAL A  25      -8.522   1.480   1.339  1.00 39.40           H  
ATOM    394  N   MET A  26     -10.277  -1.759   4.567  1.00 31.24           N  
ATOM    395  CA  MET A  26     -10.545  -2.421   5.845  1.00 72.22           C  
ATOM    396  C   MET A  26      -9.393  -2.196   6.835  1.00 33.00           C  
ATOM    397  O   MET A  26      -9.613  -1.758   7.966  1.00 13.22           O  
ATOM    398  CB  MET A  26     -10.775  -3.928   5.643  1.00 12.51           C  
ATOM    399  CG  MET A  26     -11.106  -4.673   6.932  1.00 61.22           C  
ATOM    400  SD  MET A  26     -11.381  -6.438   6.677  1.00 74.53           S  
ATOM    401  CE  MET A  26      -9.809  -6.941   5.977  1.00 73.11           C  
ATOM    402  H   MET A  26      -9.836  -2.258   3.848  1.00 39.40           H  
ATOM    403  HA  MET A  26     -11.444  -1.986   6.260  1.00 43.42           H  
ATOM    404  HB2 MET A  26     -11.595  -4.066   4.954  1.00 39.40           H  
ATOM    405  HB3 MET A  26      -9.883  -4.365   5.217  1.00 39.40           H  
ATOM    406  HG2 MET A  26     -10.288  -4.549   7.626  1.00 39.40           H  
ATOM    407  HG3 MET A  26     -12.002  -4.243   7.359  1.00 39.40           H  
ATOM    408  HE1 MET A  26      -9.017  -6.731   6.680  1.00 39.40           H  
ATOM    409  HE2 MET A  26      -9.633  -6.396   5.061  1.00 39.40           H  
ATOM    410  HE3 MET A  26      -9.833  -8.000   5.767  1.00 39.40           H  
ATOM    411  N   LYS A  27      -8.164  -2.497   6.405  1.00 73.43           N  
ATOM    412  CA  LYS A  27      -6.984  -2.372   7.275  1.00  4.21           C  
ATOM    413  C   LYS A  27      -5.831  -1.641   6.569  1.00 13.43           C  
ATOM    414  O   LYS A  27      -5.619  -1.808   5.370  1.00 30.15           O  
ATOM    415  CB  LYS A  27      -6.496  -3.760   7.732  1.00 32.02           C  
ATOM    416  CG  LYS A  27      -7.578  -4.629   8.371  1.00 23.52           C  
ATOM    417  CD  LYS A  27      -8.227  -3.974   9.596  1.00 42.44           C  
ATOM    418  CE  LYS A  27      -7.329  -3.983  10.835  1.00 52.33           C  
ATOM    419  NZ  LYS A  27      -6.148  -3.086  10.704  1.00 52.12           N  
ATOM    420  H   LYS A  27      -8.044  -2.802   5.480  1.00 39.40           H  
ATOM    421  HA  LYS A  27      -7.271  -1.799   8.148  1.00 71.23           H  
ATOM    422  HB2 LYS A  27      -6.106  -4.289   6.873  1.00 39.40           H  
ATOM    423  HB3 LYS A  27      -5.700  -3.629   8.450  1.00 39.40           H  
ATOM    424  HG2 LYS A  27      -8.346  -4.820   7.635  1.00 39.40           H  
ATOM    425  HG3 LYS A  27      -7.133  -5.569   8.671  1.00 39.40           H  
ATOM    426  HD2 LYS A  27      -8.466  -2.949   9.355  1.00 39.40           H  
ATOM    427  HD3 LYS A  27      -9.141  -4.506   9.822  1.00 39.40           H  
ATOM    428  HE2 LYS A  27      -7.912  -3.662  11.684  1.00 39.40           H  
ATOM    429  HE3 LYS A  27      -6.984  -4.994  11.006  1.00 39.40           H  
ATOM    430  HZ1 LYS A  27      -6.446  -2.137  10.395  1.00 39.40           H  
ATOM    431  HZ2 LYS A  27      -5.480  -3.474  10.007  1.00 39.40           H  
ATOM    432  HZ3 LYS A  27      -5.664  -2.997  11.620  1.00 39.40           H  
ATOM    433  N   ILE A  28      -5.094  -0.836   7.328  1.00 45.20           N  
ATOM    434  CA  ILE A  28      -3.905  -0.134   6.825  1.00 34.53           C  
ATOM    435  C   ILE A  28      -2.669  -0.486   7.669  1.00 51.24           C  
ATOM    436  O   ILE A  28      -2.710  -0.427   8.899  1.00 21.31           O  
ATOM    437  CB  ILE A  28      -4.105   1.407   6.847  1.00 64.50           C  
ATOM    438  CG1 ILE A  28      -5.301   1.808   5.969  1.00 74.33           C  
ATOM    439  CG2 ILE A  28      -2.832   2.125   6.392  1.00  1.42           C  
ATOM    440  CD1 ILE A  28      -5.596   3.293   5.979  1.00 21.04           C  
ATOM    441  H   ILE A  28      -5.357  -0.700   8.262  1.00 39.40           H  
ATOM    442  HA  ILE A  28      -3.735  -0.444   5.802  1.00 61.30           H  
ATOM    443  HB  ILE A  28      -4.305   1.704   7.868  1.00 21.02           H  
ATOM    444 HG12 ILE A  28      -5.109   1.517   4.947  1.00 39.40           H  
ATOM    445 HG13 ILE A  28      -6.185   1.295   6.323  1.00 39.40           H  
ATOM    446 HG21 ILE A  28      -2.023   1.885   7.067  1.00 39.40           H  
ATOM    447 HG22 ILE A  28      -2.997   3.193   6.394  1.00 39.40           H  
ATOM    448 HG23 ILE A  28      -2.573   1.803   5.392  1.00 39.40           H  
ATOM    449 HD11 ILE A  28      -4.739   3.835   5.604  1.00 39.40           H  
ATOM    450 HD12 ILE A  28      -5.810   3.609   6.989  1.00 39.40           H  
ATOM    451 HD13 ILE A  28      -6.451   3.492   5.350  1.00 39.40           H  
ATOM    452  N   SER A  29      -1.578  -0.871   7.009  1.00 11.21           N  
ATOM    453  CA  SER A  29      -0.317  -1.171   7.705  1.00 31.14           C  
ATOM    454  C   SER A  29       0.739  -0.099   7.428  1.00 24.02           C  
ATOM    455  O   SER A  29       0.803   0.453   6.328  1.00  1.11           O  
ATOM    456  CB  SER A  29       0.217  -2.546   7.285  1.00 13.21           C  
ATOM    457  OG  SER A  29      -0.690  -3.580   7.641  1.00 54.03           O  
ATOM    458  H   SER A  29      -1.618  -0.962   6.034  1.00 39.40           H  
ATOM    459  HA  SER A  29      -0.518  -1.188   8.769  1.00 63.40           H  
ATOM    460  HB2 SER A  29       0.359  -2.565   6.214  1.00 39.40           H  
ATOM    461  HB3 SER A  29       1.164  -2.730   7.776  1.00 39.40           H  
ATOM    462  HG  SER A  29      -0.543  -4.343   7.072  1.00 42.32           H  
ATOM    463  N   SER A  30       1.568   0.185   8.428  1.00 54.42           N  
ATOM    464  CA  SER A  30       2.616   1.206   8.306  1.00 52.35           C  
ATOM    465  C   SER A  30       3.692   0.800   7.285  1.00 74.42           C  
ATOM    466  O   SER A  30       3.946  -0.387   7.070  1.00 53.11           O  
ATOM    467  CB  SER A  30       3.276   1.466   9.668  1.00 54.51           C  
ATOM    468  OG  SER A  30       3.871   0.286  10.187  1.00 51.12           O  
ATOM    469  H   SER A  30       1.478  -0.307   9.273  1.00 39.40           H  
ATOM    470  HA  SER A  30       2.145   2.120   7.968  1.00  5.25           H  
ATOM    471  HB2 SER A  30       4.043   2.219   9.556  1.00 39.40           H  
ATOM    472  HB3 SER A  30       2.531   1.819  10.365  1.00 39.40           H  
ATOM    473  HG  SER A  30       3.679   0.221  11.132  1.00 43.15           H  
ATOM    474  N   PRO A  31       4.340   1.790   6.641  1.00 53.31           N  
ATOM    475  CA  PRO A  31       5.393   1.541   5.637  1.00 72.41           C  
ATOM    476  C   PRO A  31       6.595   0.743   6.179  1.00  5.24           C  
ATOM    477  O   PRO A  31       7.083   0.986   7.285  1.00  5.34           O  
ATOM    478  CB  PRO A  31       5.833   2.958   5.219  1.00 45.25           C  
ATOM    479  CG  PRO A  31       5.360   3.850   6.318  1.00 31.13           C  
ATOM    480  CD  PRO A  31       4.089   3.230   6.818  1.00  5.21           C  
ATOM    481  HA  PRO A  31       4.991   1.025   4.776  1.00  4.32           H  
ATOM    482  HB2 PRO A  31       6.909   2.994   5.115  1.00 39.40           H  
ATOM    483  HB3 PRO A  31       5.371   3.216   4.278  1.00 39.40           H  
ATOM    484  HG2 PRO A  31       6.096   3.887   7.110  1.00 39.40           H  
ATOM    485  HG3 PRO A  31       5.170   4.844   5.934  1.00 39.40           H  
ATOM    486  HD2 PRO A  31       3.932   3.474   7.859  1.00 39.40           H  
ATOM    487  HD3 PRO A  31       3.247   3.550   6.220  1.00 39.40           H  
ATOM    488  N   ARG A  32       7.061  -0.212   5.379  1.00 13.13           N  
ATOM    489  CA  ARG A  32       8.281  -0.967   5.675  1.00  4.41           C  
ATOM    490  C   ARG A  32       9.479  -0.315   4.968  1.00  4.45           C  
ATOM    491  O   ARG A  32       9.509  -0.225   3.739  1.00 41.41           O  
ATOM    492  CB  ARG A  32       8.124  -2.424   5.213  1.00  1.24           C  
ATOM    493  CG  ARG A  32       9.357  -3.290   5.460  1.00 72.32           C  
ATOM    494  CD  ARG A  32       9.171  -4.715   4.946  1.00 25.20           C  
ATOM    495  NE  ARG A  32      10.330  -5.556   5.244  1.00 75.13           N  
ATOM    496  CZ  ARG A  32      10.549  -6.731   4.711  1.00 75.53           C  
ATOM    497  NH1 ARG A  32       9.728  -7.231   3.839  1.00 41.03           N  
ATOM    498  NH2 ARG A  32      11.599  -7.402   5.056  1.00 20.12           N  
ATOM    499  H   ARG A  32       6.566  -0.423   4.568  1.00 39.40           H  
ATOM    500  HA  ARG A  32       8.444  -0.946   6.744  1.00 63.13           H  
ATOM    501  HB2 ARG A  32       7.289  -2.866   5.740  1.00 39.40           H  
ATOM    502  HB3 ARG A  32       7.909  -2.431   4.153  1.00 39.40           H  
ATOM    503  HG2 ARG A  32      10.204  -2.846   4.955  1.00 39.40           H  
ATOM    504  HG3 ARG A  32       9.552  -3.324   6.524  1.00 39.40           H  
ATOM    505  HD2 ARG A  32       8.297  -5.143   5.415  1.00 39.40           H  
ATOM    506  HD3 ARG A  32       9.026  -4.684   3.875  1.00 39.40           H  
ATOM    507  HE  ARG A  32      10.980  -5.218   5.893  1.00 13.30           H  
ATOM    508 HH11 ARG A  32       8.916  -6.721   3.567  1.00 39.40           H  
ATOM    509 HH12 ARG A  32       9.907  -8.131   3.443  1.00 39.40           H  
ATOM    510 HH21 ARG A  32      12.231  -7.020   5.727  1.00 39.40           H  
ATOM    511 HH22 ARG A  32      11.775  -8.299   4.654  1.00 39.40           H  
ATOM    512  N   THR A  33      10.460   0.136   5.743  1.00 22.21           N  
ATOM    513  CA  THR A  33      11.590   0.902   5.197  1.00 73.42           C  
ATOM    514  C   THR A  33      12.725  -0.009   4.695  1.00 71.44           C  
ATOM    515  O   THR A  33      13.078  -1.001   5.340  1.00 21.14           O  
ATOM    516  CB  THR A  33      12.165   1.880   6.254  1.00 44.23           C  
ATOM    517  OG1 THR A  33      11.102   2.624   6.871  1.00 24.11           O  
ATOM    518  CG2 THR A  33      13.155   2.856   5.622  1.00 31.22           C  
ATOM    519  H   THR A  33      10.423  -0.042   6.707  1.00 39.40           H  
ATOM    520  HA  THR A  33      11.221   1.488   4.365  1.00 24.21           H  
ATOM    521  HB  THR A  33      12.680   1.308   7.015  1.00 42.35           H  
ATOM    522  HG1 THR A  33      11.476   3.250   7.502  1.00 32.51           H  
ATOM    523 HG21 THR A  33      13.953   2.304   5.145  1.00 39.40           H  
ATOM    524 HG22 THR A  33      13.569   3.496   6.388  1.00 39.40           H  
ATOM    525 HG23 THR A  33      12.645   3.462   4.885  1.00 39.40           H  
ATOM    526  N   PHE A  34      13.300   0.347   3.545  1.00 44.21           N  
ATOM    527  CA  PHE A  34      14.433  -0.386   2.963  1.00 40.20           C  
ATOM    528  C   PHE A  34      15.453   0.586   2.339  1.00 12.00           C  
ATOM    529  O   PHE A  34      15.098   1.687   1.916  1.00  2.21           O  
ATOM    530  CB  PHE A  34      13.938  -1.389   1.904  1.00 14.20           C  
ATOM    531  CG  PHE A  34      13.181  -0.758   0.757  1.00 64.31           C  
ATOM    532  CD1 PHE A  34      13.856  -0.268  -0.355  1.00 40.14           C  
ATOM    533  CD2 PHE A  34      11.796  -0.658   0.790  1.00  1.25           C  
ATOM    534  CE1 PHE A  34      13.167   0.309  -1.403  1.00 24.32           C  
ATOM    535  CE2 PHE A  34      11.106  -0.082  -0.258  1.00 33.31           C  
ATOM    536  CZ  PHE A  34      11.791   0.402  -1.354  1.00 73.04           C  
ATOM    537  H   PHE A  34      12.957   1.136   3.072  1.00 39.40           H  
ATOM    538  HA  PHE A  34      14.921  -0.929   3.759  1.00  1.51           H  
ATOM    539  HB2 PHE A  34      14.788  -1.915   1.493  1.00 39.40           H  
ATOM    540  HB3 PHE A  34      13.283  -2.106   2.382  1.00 39.40           H  
ATOM    541  HD1 PHE A  34      14.934  -0.341  -0.394  1.00 20.53           H  
ATOM    542  HD2 PHE A  34      11.255  -1.034   1.647  1.00  2.02           H  
ATOM    543  HE1 PHE A  34      13.704   0.688  -2.259  1.00 32.11           H  
ATOM    544  HE2 PHE A  34      10.029  -0.011  -0.220  1.00 63.23           H  
ATOM    545  HZ  PHE A  34      11.251   0.852  -2.174  1.00 71.13           H  
ATOM    546  N   THR A  35      16.715   0.168   2.266  1.00 22.31           N  
ATOM    547  CA  THR A  35      17.779   1.031   1.733  1.00 20.42           C  
ATOM    548  C   THR A  35      17.874   0.934   0.202  1.00 23.22           C  
ATOM    549  O   THR A  35      18.376  -0.055  -0.341  1.00  1.02           O  
ATOM    550  CB  THR A  35      19.157   0.674   2.348  1.00 74.44           C  
ATOM    551  OG1 THR A  35      19.099   0.767   3.782  1.00 21.20           O  
ATOM    552  CG2 THR A  35      20.257   1.594   1.821  1.00 73.12           C  
ATOM    553  H   THR A  35      16.939  -0.734   2.572  1.00 39.40           H  
ATOM    554  HA  THR A  35      17.547   2.053   2.004  1.00 15.12           H  
ATOM    555  HB  THR A  35      19.400  -0.344   2.077  1.00 41.31           H  
ATOM    556  HG1 THR A  35      19.674   1.484   4.082  1.00 42.22           H  
ATOM    557 HG21 THR A  35      21.203   1.319   2.268  1.00 39.40           H  
ATOM    558 HG22 THR A  35      20.025   2.619   2.074  1.00 39.40           H  
ATOM    559 HG23 THR A  35      20.327   1.497   0.748  1.00 39.40           H  
ATOM    560  N   THR A  36      17.385   1.966  -0.489  1.00 63.15           N  
ATOM    561  CA  THR A  36      17.458   2.028  -1.959  1.00 74.32           C  
ATOM    562  C   THR A  36      18.631   2.892  -2.434  1.00 10.21           C  
ATOM    563  O   THR A  36      19.060   3.821  -1.746  1.00 11.32           O  
ATOM    564  CB  THR A  36      16.153   2.577  -2.589  1.00 45.31           C  
ATOM    565  OG1 THR A  36      16.318   2.730  -4.010  1.00 52.55           O  
ATOM    566  CG2 THR A  36      15.758   3.918  -1.980  1.00 11.11           C  
ATOM    567  H   THR A  36      16.962   2.701  -0.001  1.00 39.40           H  
ATOM    568  HA  THR A  36      17.606   1.020  -2.323  1.00  4.43           H  
ATOM    569  HB  THR A  36      15.357   1.867  -2.404  1.00 62.15           H  
ATOM    570  HG1 THR A  36      15.986   1.942  -4.459  1.00 34.54           H  
ATOM    571 HG21 THR A  36      14.822   4.248  -2.409  1.00 39.40           H  
ATOM    572 HG22 THR A  36      16.526   4.648  -2.189  1.00 39.40           H  
ATOM    573 HG23 THR A  36      15.646   3.811  -0.911  1.00 39.40           H  
ATOM    574  N   ARG A  37      19.131   2.593  -3.630  1.00 43.10           N  
ATOM    575  CA  ARG A  37      20.282   3.306  -4.193  1.00 42.51           C  
ATOM    576  C   ARG A  37      19.868   4.645  -4.839  1.00 15.25           C  
ATOM    577  O   ARG A  37      20.717   5.458  -5.210  1.00 24.34           O  
ATOM    578  CB  ARG A  37      20.997   2.397  -5.204  1.00 31.14           C  
ATOM    579  CG  ARG A  37      22.306   2.962  -5.747  1.00 72.04           C  
ATOM    580  CD  ARG A  37      23.130   1.888  -6.448  1.00 34.51           C  
ATOM    581  NE  ARG A  37      22.368   1.205  -7.493  1.00 53.23           N  
ATOM    582  CZ  ARG A  37      22.364  -0.087  -7.677  1.00 65.12           C  
ATOM    583  NH1 ARG A  37      23.064  -0.865  -6.917  1.00 15.40           N  
ATOM    584  NH2 ARG A  37      21.662  -0.599  -8.634  1.00 73.13           N  
ATOM    585  H   ARG A  37      18.719   1.865  -4.148  1.00 39.40           H  
ATOM    586  HA  ARG A  37      20.964   3.518  -3.381  1.00 54.42           H  
ATOM    587  HB2 ARG A  37      21.211   1.453  -4.723  1.00 39.40           H  
ATOM    588  HB3 ARG A  37      20.333   2.216  -6.038  1.00 39.40           H  
ATOM    589  HG2 ARG A  37      22.085   3.749  -6.453  1.00 39.40           H  
ATOM    590  HG3 ARG A  37      22.881   3.365  -4.925  1.00 39.40           H  
ATOM    591  HD2 ARG A  37      23.998   2.352  -6.895  1.00 39.40           H  
ATOM    592  HD3 ARG A  37      23.452   1.163  -5.712  1.00 39.40           H  
ATOM    593  HE  ARG A  37      21.830   1.756  -8.094  1.00 14.31           H  
ATOM    594 HH11 ARG A  37      23.620  -0.482  -6.183  1.00 39.40           H  
ATOM    595 HH12 ARG A  37      23.038  -1.853  -7.059  1.00 39.40           H  
ATOM    596 HH21 ARG A  37      21.120  -0.005  -9.227  1.00 39.40           H  
ATOM    597 HH22 ARG A  37      21.664  -1.586  -8.784  1.00 39.40           H  
ATOM    598  N   LYS A  38      18.556   4.879  -4.949  1.00 30.23           N  
ATOM    599  CA  LYS A  38      18.030   6.163  -5.450  1.00  5.12           C  
ATOM    600  C   LYS A  38      18.400   7.339  -4.520  1.00  3.03           C  
ATOM    601  O   LYS A  38      18.309   8.504  -4.914  1.00 33.11           O  
ATOM    602  CB  LYS A  38      16.495   6.093  -5.612  1.00 12.32           C  
ATOM    603  CG  LYS A  38      16.014   5.749  -7.024  1.00 32.25           C  
ATOM    604  CD  LYS A  38      16.507   4.384  -7.508  1.00 10.44           C  
ATOM    605  CE  LYS A  38      15.931   4.036  -8.881  1.00 61.50           C  
ATOM    606  NZ  LYS A  38      16.458   2.747  -9.405  1.00 50.21           N  
ATOM    607  H   LYS A  38      17.925   4.169  -4.697  1.00 39.40           H  
ATOM    608  HA  LYS A  38      18.475   6.342  -6.420  1.00 50.24           H  
ATOM    609  HB2 LYS A  38      16.108   5.345  -4.936  1.00 39.40           H  
ATOM    610  HB3 LYS A  38      16.071   7.051  -5.341  1.00 39.40           H  
ATOM    611  HG2 LYS A  38      14.933   5.748  -7.029  1.00 39.40           H  
ATOM    612  HG3 LYS A  38      16.371   6.511  -7.705  1.00 39.40           H  
ATOM    613  HD2 LYS A  38      17.585   4.404  -7.576  1.00 39.40           H  
ATOM    614  HD3 LYS A  38      16.202   3.628  -6.797  1.00 39.40           H  
ATOM    615  HE2 LYS A  38      14.856   3.963  -8.800  1.00 39.40           H  
ATOM    616  HE3 LYS A  38      16.184   4.824  -9.576  1.00 39.40           H  
ATOM    617  HZ1 LYS A  38      16.266   1.981  -8.728  1.00 39.40           H  
ATOM    618  HZ2 LYS A  38      17.483   2.814  -9.557  1.00 39.40           H  
ATOM    619  HZ3 LYS A  38      16.000   2.516 -10.312  1.00 39.40           H  
ATOM    620  N   GLY A  39      18.806   7.026  -3.288  1.00 61.35           N  
ATOM    621  CA  GLY A  39      19.134   8.065  -2.310  1.00 45.32           C  
ATOM    622  C   GLY A  39      17.926   8.508  -1.488  1.00 45.01           C  
ATOM    623  O   GLY A  39      18.017   9.422  -0.666  1.00 44.12           O  
ATOM    624  H   GLY A  39      18.897   6.082  -3.043  1.00 39.40           H  
ATOM    625  HA2 GLY A  39      19.887   7.678  -1.638  1.00 39.40           H  
ATOM    626  HA3 GLY A  39      19.540   8.923  -2.827  1.00 39.40           H  
ATOM    627  N   ARG A  40      16.793   7.850  -1.711  1.00 64.05           N  
ATOM    628  CA  ARG A  40      15.550   8.164  -0.997  1.00 63.40           C  
ATOM    629  C   ARG A  40      15.345   7.201   0.183  1.00 72.21           C  
ATOM    630  O   ARG A  40      15.959   6.132   0.231  1.00 13.02           O  
ATOM    631  CB  ARG A  40      14.365   8.102  -1.972  1.00 52.25           C  
ATOM    632  CG  ARG A  40      14.512   9.073  -3.143  1.00 54.52           C  
ATOM    633  CD  ARG A  40      13.323   9.034  -4.099  1.00 24.04           C  
ATOM    634  NE  ARG A  40      13.589   9.809  -5.311  1.00  5.02           N  
ATOM    635  CZ  ARG A  40      12.682  10.430  -6.015  1.00 62.43           C  
ATOM    636  NH1 ARG A  40      11.436  10.393  -5.675  1.00 43.32           N  
ATOM    637  NH2 ARG A  40      13.033  11.090  -7.071  1.00 23.30           N  
ATOM    638  H   ARG A  40      16.789   7.132  -2.374  1.00 39.40           H  
ATOM    639  HA  ARG A  40      15.633   9.172  -0.612  1.00 43.32           H  
ATOM    640  HB2 ARG A  40      14.282   7.098  -2.367  1.00 39.40           H  
ATOM    641  HB3 ARG A  40      13.457   8.348  -1.438  1.00 39.40           H  
ATOM    642  HG2 ARG A  40      14.607  10.076  -2.754  1.00 39.40           H  
ATOM    643  HG3 ARG A  40      15.408   8.818  -3.692  1.00 39.40           H  
ATOM    644  HD2 ARG A  40      13.130   8.007  -4.375  1.00 39.40           H  
ATOM    645  HD3 ARG A  40      12.457   9.443  -3.598  1.00 39.40           H  
ATOM    646  HE  ARG A  40      14.518   9.861  -5.615  1.00 13.42           H  
ATOM    647 HH11 ARG A  40      11.148   9.883  -4.867  1.00 39.40           H  
ATOM    648 HH12 ARG A  40      10.759  10.878  -6.224  1.00 39.40           H  
ATOM    649 HH21 ARG A  40      13.995  11.123  -7.341  1.00 39.40           H  
ATOM    650 HH22 ARG A  40      12.342  11.557  -7.617  1.00 39.40           H  
ATOM    651  N   GLU A  41      14.502   7.589   1.139  1.00 21.52           N  
ATOM    652  CA  GLU A  41      14.287   6.793   2.360  1.00 10.43           C  
ATOM    653  C   GLU A  41      13.821   5.355   2.052  1.00  2.51           C  
ATOM    654  O   GLU A  41      14.191   4.421   2.761  1.00  4.12           O  
ATOM    655  CB  GLU A  41      13.299   7.506   3.300  1.00 22.11           C  
ATOM    656  CG  GLU A  41      11.946   7.832   2.673  1.00 13.14           C  
ATOM    657  CD  GLU A  41      11.078   8.688   3.589  1.00 23.12           C  
ATOM    658  OE1 GLU A  41      11.270   9.921   3.620  1.00 72.33           O  
ATOM    659  OE2 GLU A  41      10.217   8.131   4.301  1.00 71.13           O  
ATOM    660  H   GLU A  41      14.013   8.434   1.027  1.00 39.40           H  
ATOM    661  HA  GLU A  41      15.244   6.730   2.863  1.00 63.33           H  
ATOM    662  HB2 GLU A  41      13.126   6.878   4.162  1.00 39.40           H  
ATOM    663  HB3 GLU A  41      13.748   8.433   3.633  1.00 39.40           H  
ATOM    664  HG2 GLU A  41      12.110   8.369   1.748  1.00 39.40           H  
ATOM    665  HG3 GLU A  41      11.427   6.907   2.464  1.00 39.40           H  
ATOM    666  N   GLY A  42      13.012   5.187   0.999  1.00 24.25           N  
ATOM    667  CA  GLY A  42      12.624   3.846   0.542  1.00 61.12           C  
ATOM    668  C   GLY A  42      11.660   3.122   1.484  1.00 62.31           C  
ATOM    669  O   GLY A  42      12.050   2.683   2.562  1.00  4.23           O  
ATOM    670  H   GLY A  42      12.671   5.975   0.531  1.00 39.40           H  
ATOM    671  HA2 GLY A  42      12.157   3.937  -0.428  1.00 39.40           H  
ATOM    672  HA3 GLY A  42      13.519   3.248   0.435  1.00 39.40           H  
ATOM    673  N   LYS A  43      10.401   2.976   1.065  1.00 33.22           N  
ATOM    674  CA  LYS A  43       9.366   2.328   1.888  1.00  1.12           C  
ATOM    675  C   LYS A  43       8.308   1.614   1.035  1.00  2.14           C  
ATOM    676  O   LYS A  43       8.099   1.951  -0.133  1.00 60.31           O  
ATOM    677  CB  LYS A  43       8.679   3.358   2.799  1.00  3.25           C  
ATOM    678  CG  LYS A  43       9.561   3.859   3.930  1.00 65.33           C  
ATOM    679  CD  LYS A  43       8.932   5.028   4.673  1.00 50.43           C  
ATOM    680  CE  LYS A  43       9.739   5.394   5.905  1.00 15.32           C  
ATOM    681  NZ  LYS A  43       9.313   6.693   6.482  1.00 43.43           N  
ATOM    682  H   LYS A  43      10.160   3.300   0.179  1.00 39.40           H  
ATOM    683  HA  LYS A  43       9.857   1.592   2.509  1.00 61.14           H  
ATOM    684  HB2 LYS A  43       8.381   4.208   2.200  1.00 39.40           H  
ATOM    685  HB3 LYS A  43       7.795   2.911   3.234  1.00 39.40           H  
ATOM    686  HG2 LYS A  43       9.727   3.050   4.628  1.00 39.40           H  
ATOM    687  HG3 LYS A  43      10.510   4.176   3.518  1.00 39.40           H  
ATOM    688  HD2 LYS A  43       8.895   5.881   4.013  1.00 39.40           H  
ATOM    689  HD3 LYS A  43       7.929   4.758   4.974  1.00 39.40           H  
ATOM    690  HE2 LYS A  43       9.607   4.621   6.649  1.00 39.40           H  
ATOM    691  HE3 LYS A  43      10.782   5.456   5.633  1.00 39.40           H  
ATOM    692  HZ1 LYS A  43       9.460   7.454   5.789  1.00 39.40           H  
ATOM    693  HZ2 LYS A  43       9.869   6.906   7.335  1.00 39.40           H  
ATOM    694  HZ3 LYS A  43       8.307   6.661   6.734  1.00 39.40           H  
ATOM    695  N   LEU A  44       7.661   0.612   1.630  1.00 21.43           N  
ATOM    696  CA  LEU A  44       6.526  -0.079   1.007  1.00 30.41           C  
ATOM    697  C   LEU A  44       5.457  -0.408   2.065  1.00 73.54           C  
ATOM    698  O   LEU A  44       5.760  -0.985   3.105  1.00 11.14           O  
ATOM    699  CB  LEU A  44       7.010  -1.348   0.270  1.00 34.03           C  
ATOM    700  CG  LEU A  44       7.720  -2.420   1.132  1.00 52.12           C  
ATOM    701  CD1 LEU A  44       6.722  -3.434   1.692  1.00 72.51           C  
ATOM    702  CD2 LEU A  44       8.807  -3.130   0.327  1.00 62.34           C  
ATOM    703  H   LEU A  44       7.966   0.315   2.515  1.00 39.40           H  
ATOM    704  HA  LEU A  44       6.091   0.599   0.282  1.00 32.31           H  
ATOM    705  HB2 LEU A  44       6.153  -1.807  -0.203  1.00 39.40           H  
ATOM    706  HB3 LEU A  44       7.695  -1.035  -0.506  1.00 39.40           H  
ATOM    707  HG  LEU A  44       8.196  -1.934   1.971  1.00  1.50           H  
ATOM    708 HD11 LEU A  44       6.003  -2.925   2.318  1.00 39.40           H  
ATOM    709 HD12 LEU A  44       7.248  -4.171   2.279  1.00 39.40           H  
ATOM    710 HD13 LEU A  44       6.207  -3.923   0.877  1.00 39.40           H  
ATOM    711 HD21 LEU A  44       9.545  -2.409   0.005  1.00 39.40           H  
ATOM    712 HD22 LEU A  44       8.367  -3.603  -0.540  1.00 39.40           H  
ATOM    713 HD23 LEU A  44       9.282  -3.879   0.943  1.00 39.40           H  
ATOM    714  N   ALA A  45       4.208  -0.025   1.812  1.00 31.31           N  
ATOM    715  CA  ALA A  45       3.130  -0.215   2.792  1.00 40.55           C  
ATOM    716  C   ALA A  45       2.031  -1.141   2.261  1.00  3.23           C  
ATOM    717  O   ALA A  45       1.704  -1.114   1.079  1.00 21.05           O  
ATOM    718  CB  ALA A  45       2.533   1.134   3.184  1.00 34.44           C  
ATOM    719  H   ALA A  45       4.007   0.399   0.951  1.00 39.40           H  
ATOM    720  HA  ALA A  45       3.557  -0.659   3.682  1.00 24.02           H  
ATOM    721  HB1 ALA A  45       1.809   0.992   3.974  1.00 39.40           H  
ATOM    722  HB2 ALA A  45       2.047   1.577   2.325  1.00 39.40           H  
ATOM    723  HB3 ALA A  45       3.317   1.789   3.530  1.00 39.40           H  
ATOM    724  N   ASN A  46       1.456  -1.956   3.144  1.00 74.51           N  
ATOM    725  CA  ASN A  46       0.401  -2.897   2.753  1.00 33.10           C  
ATOM    726  C   ASN A  46      -0.976  -2.453   3.280  1.00 62.41           C  
ATOM    727  O   ASN A  46      -1.224  -2.463   4.486  1.00 53.25           O  
ATOM    728  CB  ASN A  46       0.731  -4.307   3.264  1.00 33.11           C  
ATOM    729  CG  ASN A  46       2.026  -4.846   2.678  1.00 32.24           C  
ATOM    730  OD1 ASN A  46       2.031  -5.502   1.642  1.00 71.22           O  
ATOM    731  ND2 ASN A  46       3.138  -4.581   3.335  1.00 12.14           N  
ATOM    732  H   ASN A  46       1.742  -1.921   4.079  1.00 39.40           H  
ATOM    733  HA  ASN A  46       0.363  -2.923   1.671  1.00 10.44           H  
ATOM    734  HB2 ASN A  46       0.826  -4.282   4.341  1.00 39.40           H  
ATOM    735  HB3 ASN A  46      -0.072  -4.979   2.996  1.00 39.40           H  
ATOM    736 HD21 ASN A  46       3.077  -4.056   4.159  1.00 39.40           H  
ATOM    737 HD22 ASN A  46       3.978  -4.925   2.971  1.00 39.40           H  
ATOM    738  N   VAL A  47      -1.861  -2.057   2.369  1.00  2.31           N  
ATOM    739  CA  VAL A  47      -3.234  -1.671   2.720  1.00 34.13           C  
ATOM    740  C   VAL A  47      -4.244  -2.694   2.174  1.00 53.45           C  
ATOM    741  O   VAL A  47      -4.249  -3.001   0.982  1.00  5.14           O  
ATOM    742  CB  VAL A  47      -3.586  -0.261   2.175  1.00 51.45           C  
ATOM    743  CG1 VAL A  47      -5.032   0.110   2.505  1.00 23.12           C  
ATOM    744  CG2 VAL A  47      -2.619   0.789   2.725  1.00 33.32           C  
ATOM    745  H   VAL A  47      -1.585  -2.018   1.428  1.00 39.40           H  
ATOM    746  HA  VAL A  47      -3.311  -1.646   3.800  1.00 60.31           H  
ATOM    747  HB  VAL A  47      -3.485  -0.279   1.099  1.00 50.12           H  
ATOM    748 HG11 VAL A  47      -5.246   1.103   2.135  1.00 39.40           H  
ATOM    749 HG12 VAL A  47      -5.175   0.089   3.576  1.00 39.40           H  
ATOM    750 HG13 VAL A  47      -5.702  -0.599   2.040  1.00 39.40           H  
ATOM    751 HG21 VAL A  47      -2.888   1.765   2.342  1.00 39.40           H  
ATOM    752 HG22 VAL A  47      -1.611   0.549   2.418  1.00 39.40           H  
ATOM    753 HG23 VAL A  47      -2.672   0.801   3.805  1.00 39.40           H  
ATOM    754  N   ILE A  48      -5.093  -3.223   3.050  1.00 53.20           N  
ATOM    755  CA  ILE A  48      -6.068  -4.250   2.666  1.00  4.45           C  
ATOM    756  C   ILE A  48      -7.431  -3.637   2.303  1.00 32.04           C  
ATOM    757  O   ILE A  48      -8.141  -3.107   3.165  1.00 41.21           O  
ATOM    758  CB  ILE A  48      -6.264  -5.287   3.801  1.00 71.54           C  
ATOM    759  CG1 ILE A  48      -4.913  -5.913   4.205  1.00 51.32           C  
ATOM    760  CG2 ILE A  48      -7.256  -6.372   3.374  1.00 44.21           C  
ATOM    761  CD1 ILE A  48      -4.214  -6.662   3.085  1.00 71.41           C  
ATOM    762  H   ILE A  48      -5.068  -2.916   3.980  1.00 39.40           H  
ATOM    763  HA  ILE A  48      -5.679  -4.771   1.800  1.00 21.44           H  
ATOM    764  HB  ILE A  48      -6.681  -4.773   4.656  1.00 13.33           H  
ATOM    765 HG12 ILE A  48      -4.246  -5.131   4.541  1.00 39.40           H  
ATOM    766 HG13 ILE A  48      -5.075  -6.608   5.017  1.00 39.40           H  
ATOM    767 HG21 ILE A  48      -8.211  -5.922   3.150  1.00 39.40           H  
ATOM    768 HG22 ILE A  48      -7.376  -7.087   4.175  1.00 39.40           H  
ATOM    769 HG23 ILE A  48      -6.882  -6.879   2.495  1.00 39.40           H  
ATOM    770 HD11 ILE A  48      -3.269  -7.042   3.443  1.00 39.40           H  
ATOM    771 HD12 ILE A  48      -4.040  -5.992   2.254  1.00 39.40           H  
ATOM    772 HD13 ILE A  48      -4.833  -7.485   2.761  1.00 39.40           H  
ATOM    773  N   ILE A  49      -7.784  -3.711   1.022  1.00 72.52           N  
ATOM    774  CA  ILE A  49      -9.089  -3.242   0.542  1.00 64.33           C  
ATOM    775  C   ILE A  49      -9.998  -4.430   0.186  1.00 34.34           C  
ATOM    776  O   ILE A  49      -9.532  -5.452  -0.313  1.00 31.44           O  
ATOM    777  CB  ILE A  49      -8.945  -2.311  -0.693  1.00 73.45           C  
ATOM    778  CG1 ILE A  49      -8.236  -3.042  -1.848  1.00 73.22           C  
ATOM    779  CG2 ILE A  49      -8.194  -1.031  -0.314  1.00 32.12           C  
ATOM    780  CD1 ILE A  49      -8.104  -2.211  -3.114  1.00  5.00           C  
ATOM    781  H   ILE A  49      -7.152  -4.101   0.379  1.00 39.40           H  
ATOM    782  HA  ILE A  49      -9.555  -2.676   1.339  1.00 62.21           H  
ATOM    783  HB  ILE A  49      -9.938  -2.028  -1.014  1.00 71.30           H  
ATOM    784 HG12 ILE A  49      -7.243  -3.322  -1.532  1.00 39.40           H  
ATOM    785 HG13 ILE A  49      -8.793  -3.936  -2.095  1.00 39.40           H  
ATOM    786 HG21 ILE A  49      -7.211  -1.284   0.055  1.00 39.40           H  
ATOM    787 HG22 ILE A  49      -8.742  -0.504   0.454  1.00 39.40           H  
ATOM    788 HG23 ILE A  49      -8.100  -0.396  -1.184  1.00 39.40           H  
ATOM    789 HD11 ILE A  49      -7.536  -1.317  -2.902  1.00 39.40           H  
ATOM    790 HD12 ILE A  49      -9.087  -1.938  -3.471  1.00 39.40           H  
ATOM    791 HD13 ILE A  49      -7.594  -2.787  -3.873  1.00 39.40           H  
ATOM    792  N   ALA A  50     -11.295  -4.296   0.447  1.00 61.23           N  
ATOM    793  CA  ALA A  50     -12.242  -5.392   0.211  1.00 12.42           C  
ATOM    794  C   ALA A  50     -13.327  -5.018  -0.813  1.00 70.02           C  
ATOM    795  O   ALA A  50     -13.899  -3.923  -0.771  1.00 20.42           O  
ATOM    796  CB  ALA A  50     -12.880  -5.825   1.527  1.00 32.02           C  
ATOM    797  H   ALA A  50     -11.623  -3.449   0.812  1.00 39.40           H  
ATOM    798  HA  ALA A  50     -11.684  -6.233  -0.177  1.00 72.45           H  
ATOM    799  HB1 ALA A  50     -12.104  -6.108   2.226  1.00 39.40           H  
ATOM    800  HB2 ALA A  50     -13.530  -6.671   1.352  1.00 39.40           H  
ATOM    801  HB3 ALA A  50     -13.454  -5.008   1.939  1.00 39.40           H  
ATOM    802  N   ASP A  51     -13.590  -5.940  -1.733  1.00 40.24           N  
ATOM    803  CA  ASP A  51     -14.663  -5.801  -2.722  1.00 72.14           C  
ATOM    804  C   ASP A  51     -15.582  -7.035  -2.680  1.00 75.52           C  
ATOM    805  O   ASP A  51     -15.240  -8.052  -2.073  1.00 64.33           O  
ATOM    806  CB  ASP A  51     -14.058  -5.612  -4.125  1.00 22.12           C  
ATOM    807  CG  ASP A  51     -15.101  -5.656  -5.230  1.00 20.01           C  
ATOM    808  OD1 ASP A  51     -15.948  -4.744  -5.290  1.00 61.44           O  
ATOM    809  OD2 ASP A  51     -15.094  -6.617  -6.028  1.00 61.51           O  
ATOM    810  H   ASP A  51     -13.037  -6.753  -1.753  1.00 39.40           H  
ATOM    811  HA  ASP A  51     -15.244  -4.925  -2.467  1.00 21.32           H  
ATOM    812  HB2 ASP A  51     -13.561  -4.654  -4.167  1.00 39.40           H  
ATOM    813  HB3 ASP A  51     -13.332  -6.393  -4.306  1.00 39.40           H  
ATOM    814  N   ASP A  52     -16.743  -6.942  -3.323  1.00 41.23           N  
ATOM    815  CA  ASP A  52     -17.709  -8.047  -3.356  1.00 44.31           C  
ATOM    816  C   ASP A  52     -17.069  -9.351  -3.875  1.00 64.43           C  
ATOM    817  O   ASP A  52     -17.452 -10.449  -3.467  1.00  5.45           O  
ATOM    818  CB  ASP A  52     -18.904  -7.658  -4.237  1.00 62.25           C  
ATOM    819  CG  ASP A  52     -20.040  -8.666  -4.167  1.00 64.04           C  
ATOM    820  OD1 ASP A  52     -20.055  -9.620  -4.974  1.00 24.44           O  
ATOM    821  OD2 ASP A  52     -20.932  -8.501  -3.307  1.00 43.15           O  
ATOM    822  H   ASP A  52     -16.961  -6.107  -3.790  1.00 39.40           H  
ATOM    823  HA  ASP A  52     -18.058  -8.210  -2.347  1.00 53.34           H  
ATOM    824  HB2 ASP A  52     -19.280  -6.696  -3.916  1.00 39.40           H  
ATOM    825  HB3 ASP A  52     -18.577  -7.580  -5.266  1.00 39.40           H  
ATOM    826  N   THR A  53     -16.080  -9.224  -4.759  1.00 21.54           N  
ATOM    827  CA  THR A  53     -15.457 -10.396  -5.393  1.00 40.41           C  
ATOM    828  C   THR A  53     -14.196 -10.890  -4.658  1.00 63.03           C  
ATOM    829  O   THR A  53     -13.603 -11.890  -5.063  1.00  2.03           O  
ATOM    830  CB  THR A  53     -15.076 -10.109  -6.867  1.00 71.51           C  
ATOM    831  OG1 THR A  53     -14.018  -9.134  -6.939  1.00 32.10           O  
ATOM    832  CG2 THR A  53     -16.282  -9.616  -7.661  1.00 63.04           C  
ATOM    833  H   THR A  53     -15.769  -8.325  -5.000  1.00 39.40           H  
ATOM    834  HA  THR A  53     -16.188 -11.196  -5.393  1.00 35.21           H  
ATOM    835  HB  THR A  53     -14.728 -11.030  -7.314  1.00 60.23           H  
ATOM    836  HG1 THR A  53     -14.377  -8.258  -6.745  1.00 53.03           H  
ATOM    837 HG21 THR A  53     -16.662  -8.708  -7.216  1.00 39.40           H  
ATOM    838 HG22 THR A  53     -17.055 -10.371  -7.652  1.00 39.40           H  
ATOM    839 HG23 THR A  53     -15.984  -9.418  -8.682  1.00 39.40           H  
ATOM    840  N   GLY A  54     -13.785 -10.213  -3.583  1.00 24.33           N  
ATOM    841  CA  GLY A  54     -12.567 -10.626  -2.875  1.00 14.34           C  
ATOM    842  C   GLY A  54     -11.811  -9.476  -2.207  1.00 72.21           C  
ATOM    843  O   GLY A  54     -12.116  -8.306  -2.430  1.00 75.00           O  
ATOM    844  H   GLY A  54     -14.299  -9.441  -3.267  1.00 39.40           H  
ATOM    845  HA2 GLY A  54     -12.838 -11.340  -2.114  1.00 39.40           H  
ATOM    846  HA3 GLY A  54     -11.906 -11.112  -3.578  1.00 39.40           H  
ATOM    847  N   GLU A  55     -10.828  -9.819  -1.372  1.00 31.33           N  
ATOM    848  CA  GLU A  55      -9.975  -8.827  -0.698  1.00 63.44           C  
ATOM    849  C   GLU A  55      -8.598  -8.725  -1.387  1.00 54.33           C  
ATOM    850  O   GLU A  55      -8.022  -9.734  -1.798  1.00 41.24           O  
ATOM    851  CB  GLU A  55      -9.787  -9.225   0.773  1.00 31.02           C  
ATOM    852  CG  GLU A  55     -11.095  -9.412   1.539  1.00  3.11           C  
ATOM    853  CD  GLU A  55     -10.899 -10.122   2.870  1.00 20.43           C  
ATOM    854  OE1 GLU A  55     -10.930 -11.376   2.889  1.00 32.24           O  
ATOM    855  OE2 GLU A  55     -10.705  -9.442   3.899  1.00 40.34           O  
ATOM    856  H   GLU A  55     -10.665 -10.771  -1.201  1.00 39.40           H  
ATOM    857  HA  GLU A  55     -10.466  -7.864  -0.749  1.00  4.14           H  
ATOM    858  HB2 GLU A  55      -9.238 -10.156   0.812  1.00 39.40           H  
ATOM    859  HB3 GLU A  55      -9.210  -8.459   1.271  1.00 39.40           H  
ATOM    860  HG2 GLU A  55     -11.532  -8.440   1.725  1.00 39.40           H  
ATOM    861  HG3 GLU A  55     -11.773  -9.996   0.930  1.00 39.40           H  
ATOM    862  N   LEU A  56      -8.069  -7.506  -1.501  1.00  4.23           N  
ATOM    863  CA  LEU A  56      -6.805  -7.265  -2.214  1.00 43.25           C  
ATOM    864  C   LEU A  56      -5.780  -6.524  -1.333  1.00 21.14           C  
ATOM    865  O   LEU A  56      -6.137  -5.660  -0.529  1.00  4.23           O  
ATOM    866  CB  LEU A  56      -7.076  -6.446  -3.486  1.00 10.51           C  
ATOM    867  CG  LEU A  56      -5.874  -6.272  -4.431  1.00 73.13           C  
ATOM    868  CD1 LEU A  56      -5.478  -7.607  -5.057  1.00 74.33           C  
ATOM    869  CD2 LEU A  56      -6.177  -5.236  -5.510  1.00 75.20           C  
ATOM    870  H   LEU A  56      -8.537  -6.749  -1.096  1.00 39.40           H  
ATOM    871  HA  LEU A  56      -6.390  -8.222  -2.497  1.00  2.20           H  
ATOM    872  HB2 LEU A  56      -7.873  -6.929  -4.035  1.00 39.40           H  
ATOM    873  HB3 LEU A  56      -7.418  -5.464  -3.188  1.00 39.40           H  
ATOM    874  HG  LEU A  56      -5.028  -5.915  -3.858  1.00 41.02           H  
ATOM    875 HD11 LEU A  56      -5.213  -8.306  -4.277  1.00 39.40           H  
ATOM    876 HD12 LEU A  56      -4.630  -7.463  -5.710  1.00 39.40           H  
ATOM    877 HD13 LEU A  56      -6.308  -8.002  -5.627  1.00 39.40           H  
ATOM    878 HD21 LEU A  56      -5.315  -5.124  -6.154  1.00 39.40           H  
ATOM    879 HD22 LEU A  56      -6.403  -4.286  -5.048  1.00 39.40           H  
ATOM    880 HD23 LEU A  56      -7.024  -5.561  -6.098  1.00 39.40           H  
ATOM    881  N   ARG A  57      -4.502  -6.869  -1.497  1.00 31.24           N  
ATOM    882  CA  ARG A  57      -3.407  -6.207  -0.775  1.00 74.12           C  
ATOM    883  C   ARG A  57      -2.728  -5.129  -1.643  1.00  2.11           C  
ATOM    884  O   ARG A  57      -1.971  -5.442  -2.558  1.00 73.53           O  
ATOM    885  CB  ARG A  57      -2.373  -7.254  -0.332  1.00 32.23           C  
ATOM    886  CG  ARG A  57      -1.106  -6.659   0.278  1.00 73.34           C  
ATOM    887  CD  ARG A  57      -0.127  -7.743   0.730  1.00 60.13           C  
ATOM    888  NE  ARG A  57      -0.643  -8.524   1.856  1.00 63.32           N  
ATOM    889  CZ  ARG A  57       0.108  -9.202   2.686  1.00 60.23           C  
ATOM    890  NH1 ARG A  57       1.383  -9.297   2.494  1.00 62.51           N  
ATOM    891  NH2 ARG A  57      -0.425  -9.812   3.697  1.00 53.14           N  
ATOM    892  H   ARG A  57      -4.286  -7.598  -2.119  1.00 39.40           H  
ATOM    893  HA  ARG A  57      -3.823  -5.734   0.106  1.00 14.15           H  
ATOM    894  HB2 ARG A  57      -2.828  -7.905   0.401  1.00 39.40           H  
ATOM    895  HB3 ARG A  57      -2.087  -7.844  -1.193  1.00 39.40           H  
ATOM    896  HG2 ARG A  57      -0.620  -6.037  -0.460  1.00 39.40           H  
ATOM    897  HG3 ARG A  57      -1.380  -6.055   1.133  1.00 39.40           H  
ATOM    898  HD2 ARG A  57       0.062  -8.410  -0.099  1.00 39.40           H  
ATOM    899  HD3 ARG A  57       0.801  -7.271   1.025  1.00 39.40           H  
ATOM    900  HE  ARG A  57      -1.606  -8.516   2.005  1.00 72.34           H  
ATOM    901 HH11 ARG A  57       1.804  -8.855   1.705  1.00 39.40           H  
ATOM    902 HH12 ARG A  57       1.947  -9.809   3.140  1.00 39.40           H  
ATOM    903 HH21 ARG A  57      -1.405  -9.767   3.847  1.00 39.40           H  
ATOM    904 HH22 ARG A  57       0.156 -10.324   4.332  1.00 39.40           H  
ATOM    905  N   ALA A  58      -3.009  -3.863  -1.355  1.00 73.24           N  
ATOM    906  CA  ALA A  58      -2.396  -2.743  -2.084  1.00 64.10           C  
ATOM    907  C   ALA A  58      -1.028  -2.364  -1.489  1.00 63.23           C  
ATOM    908  O   ALA A  58      -0.906  -2.131  -0.288  1.00 21.25           O  
ATOM    909  CB  ALA A  58      -3.332  -1.538  -2.072  1.00 72.34           C  
ATOM    910  H   ALA A  58      -3.647  -3.670  -0.637  1.00 39.40           H  
ATOM    911  HA  ALA A  58      -2.258  -3.049  -3.113  1.00 21.11           H  
ATOM    912  HB1 ALA A  58      -2.891  -0.734  -2.643  1.00 39.40           H  
ATOM    913  HB2 ALA A  58      -3.489  -1.213  -1.055  1.00 39.40           H  
ATOM    914  HB3 ALA A  58      -4.281  -1.813  -2.513  1.00 39.40           H  
ATOM    915  N   VAL A  59      -0.002  -2.301  -2.339  1.00 72.04           N  
ATOM    916  CA  VAL A  59       1.363  -1.986  -1.899  1.00 71.42           C  
ATOM    917  C   VAL A  59       1.767  -0.550  -2.282  1.00  4.54           C  
ATOM    918  O   VAL A  59       1.962  -0.236  -3.461  1.00 61.34           O  
ATOM    919  CB  VAL A  59       2.388  -2.984  -2.498  1.00 43.54           C  
ATOM    920  CG1 VAL A  59       3.804  -2.684  -2.003  1.00 71.13           C  
ATOM    921  CG2 VAL A  59       1.990  -4.424  -2.171  1.00 43.30           C  
ATOM    922  H   VAL A  59      -0.166  -2.470  -3.287  1.00 39.40           H  
ATOM    923  HA  VAL A  59       1.395  -2.081  -0.820  1.00 62.24           H  
ATOM    924  HB  VAL A  59       2.380  -2.872  -3.574  1.00  0.02           H  
ATOM    925 HG11 VAL A  59       4.497  -3.389  -2.440  1.00 39.40           H  
ATOM    926 HG12 VAL A  59       3.834  -2.770  -0.926  1.00 39.40           H  
ATOM    927 HG13 VAL A  59       4.083  -1.680  -2.291  1.00 39.40           H  
ATOM    928 HG21 VAL A  59       2.697  -5.107  -2.621  1.00 39.40           H  
ATOM    929 HG22 VAL A  59       1.002  -4.622  -2.562  1.00 39.40           H  
ATOM    930 HG23 VAL A  59       1.986  -4.566  -1.100  1.00 39.40           H  
ATOM    931  N   PHE A  60       1.891   0.316  -1.276  1.00  1.34           N  
ATOM    932  CA  PHE A  60       2.283   1.715  -1.486  1.00 61.41           C  
ATOM    933  C   PHE A  60       3.803   1.898  -1.351  1.00 43.25           C  
ATOM    934  O   PHE A  60       4.352   1.856  -0.250  1.00 12.45           O  
ATOM    935  CB  PHE A  60       1.557   2.635  -0.490  1.00 25.23           C  
ATOM    936  CG  PHE A  60       0.071   2.750  -0.730  1.00 63.22           C  
ATOM    937  CD1 PHE A  60      -0.770   1.668  -0.511  1.00 34.50           C  
ATOM    938  CD2 PHE A  60      -0.487   3.944  -1.174  1.00 35.24           C  
ATOM    939  CE1 PHE A  60      -2.130   1.772  -0.730  1.00 11.32           C  
ATOM    940  CE2 PHE A  60      -1.849   4.052  -1.393  1.00 10.32           C  
ATOM    941  CZ  PHE A  60      -2.669   2.964  -1.172  1.00 21.31           C  
ATOM    942  H   PHE A  60       1.706   0.008  -0.366  1.00 39.40           H  
ATOM    943  HA  PHE A  60       1.991   1.992  -2.491  1.00 32.54           H  
ATOM    944  HB2 PHE A  60       1.702   2.253   0.510  1.00 39.40           H  
ATOM    945  HB3 PHE A  60       1.984   3.628  -0.552  1.00 39.40           H  
ATOM    946  HD1 PHE A  60      -0.352   0.734  -0.166  1.00 32.04           H  
ATOM    947  HD2 PHE A  60       0.152   4.797  -1.348  1.00  3.45           H  
ATOM    948  HE1 PHE A  60      -2.772   0.922  -0.555  1.00 12.24           H  
ATOM    949  HE2 PHE A  60      -2.269   4.986  -1.739  1.00 53.43           H  
ATOM    950  HZ  PHE A  60      -3.734   3.045  -1.343  1.00 51.42           H  
ATOM    951  N   TRP A  61       4.466   2.092  -2.484  1.00 63.04           N  
ATOM    952  CA  TRP A  61       5.915   2.323  -2.533  1.00 73.03           C  
ATOM    953  C   TRP A  61       6.284   3.763  -2.126  1.00 33.41           C  
ATOM    954  O   TRP A  61       5.422   4.635  -2.059  1.00 42.11           O  
ATOM    955  CB  TRP A  61       6.463   1.982  -3.925  1.00 51.13           C  
ATOM    956  CG  TRP A  61       6.407   0.512  -4.231  1.00 45.35           C  
ATOM    957  CD1 TRP A  61       5.413  -0.159  -4.888  1.00 62.12           C  
ATOM    958  CD2 TRP A  61       7.384  -0.474  -3.870  1.00  5.55           C  
ATOM    959  NE1 TRP A  61       5.717  -1.497  -4.958  1.00 12.41           N  
ATOM    960  CE2 TRP A  61       6.919  -1.714  -4.339  1.00 44.22           C  
ATOM    961  CE3 TRP A  61       8.607  -0.425  -3.196  1.00 54.01           C  
ATOM    962  CZ2 TRP A  61       7.635  -2.896  -4.160  1.00 41.40           C  
ATOM    963  CZ3 TRP A  61       9.315  -1.598  -3.015  1.00 14.30           C  
ATOM    964  CH2 TRP A  61       8.825  -2.820  -3.492  1.00 22.32           C  
ATOM    965  H   TRP A  61       3.966   2.077  -3.326  1.00 39.40           H  
ATOM    966  HA  TRP A  61       6.367   1.650  -1.816  1.00 62.33           H  
ATOM    967  HB2 TRP A  61       5.886   2.506  -4.675  1.00 39.40           H  
ATOM    968  HB3 TRP A  61       7.496   2.297  -3.989  1.00 39.40           H  
ATOM    969  HD1 TRP A  61       4.525   0.308  -5.287  1.00  4.41           H  
ATOM    970  HE1 TRP A  61       5.161  -2.187  -5.381  1.00  2.52           H  
ATOM    971  HE3 TRP A  61       8.999   0.509  -2.819  1.00 74.33           H  
ATOM    972  HZ2 TRP A  61       7.268  -3.847  -4.522  1.00 32.23           H  
ATOM    973  HZ3 TRP A  61      10.260  -1.580  -2.493  1.00 53.41           H  
ATOM    974  HH2 TRP A  61       9.412  -3.712  -3.329  1.00 41.41           H  
ATOM    975  N   THR A  62       7.569   3.982  -1.819  1.00 50.11           N  
ATOM    976  CA  THR A  62       8.085   5.275  -1.303  1.00 43.35           C  
ATOM    977  C   THR A  62       7.410   6.516  -1.922  1.00 23.44           C  
ATOM    978  O   THR A  62       7.133   7.487  -1.218  1.00 21.12           O  
ATOM    979  CB  THR A  62       9.619   5.393  -1.515  1.00 71.05           C  
ATOM    980  OG1 THR A  62      10.094   6.682  -1.095  1.00 43.25           O  
ATOM    981  CG2 THR A  62      10.000   5.156  -2.974  1.00 14.52           C  
ATOM    982  H   THR A  62       8.199   3.240  -1.928  1.00 39.40           H  
ATOM    983  HA  THR A  62       7.903   5.288  -0.236  1.00 34.21           H  
ATOM    984  HB  THR A  62      10.104   4.639  -0.913  1.00  0.22           H  
ATOM    985  HG1 THR A  62       9.904   7.338  -1.776  1.00 62.21           H  
ATOM    986 HG21 THR A  62       9.686   4.166  -3.273  1.00 39.40           H  
ATOM    987 HG22 THR A  62      11.073   5.241  -3.084  1.00 39.40           H  
ATOM    988 HG23 THR A  62       9.516   5.892  -3.599  1.00 39.40           H  
ATOM    989  N   GLU A  63       7.134   6.489  -3.223  1.00 21.12           N  
ATOM    990  CA  GLU A  63       6.483   7.628  -3.886  1.00 21.42           C  
ATOM    991  C   GLU A  63       4.981   7.702  -3.562  1.00  1.54           C  
ATOM    992  O   GLU A  63       4.407   8.787  -3.463  1.00 34.02           O  
ATOM    993  CB  GLU A  63       6.699   7.558  -5.402  1.00 31.34           C  
ATOM    994  CG  GLU A  63       8.159   7.723  -5.817  1.00 72.40           C  
ATOM    995  CD  GLU A  63       8.746   9.051  -5.363  1.00  1.54           C  
ATOM    996  OE1 GLU A  63       8.487  10.078  -6.031  1.00 74.10           O  
ATOM    997  OE2 GLU A  63       9.461   9.081  -4.334  1.00  0.32           O  
ATOM    998  H   GLU A  63       7.372   5.694  -3.750  1.00 39.40           H  
ATOM    999  HA  GLU A  63       6.953   8.529  -3.515  1.00 24.41           H  
ATOM   1000  HB2 GLU A  63       6.347   6.601  -5.761  1.00 39.40           H  
ATOM   1001  HB3 GLU A  63       6.123   8.342  -5.874  1.00 39.40           H  
ATOM   1002  HG2 GLU A  63       8.737   6.919  -5.384  1.00 39.40           H  
ATOM   1003  HG3 GLU A  63       8.222   7.665  -6.896  1.00 39.40           H  
ATOM   1004  N   ASN A  64       4.351   6.547  -3.385  1.00 54.33           N  
ATOM   1005  CA  ASN A  64       2.921   6.480  -3.066  1.00  2.33           C  
ATOM   1006  C   ASN A  64       2.653   6.624  -1.558  1.00  1.23           C  
ATOM   1007  O   ASN A  64       1.506   6.771  -1.141  1.00 25.12           O  
ATOM   1008  CB  ASN A  64       2.334   5.165  -3.576  1.00 72.03           C  
ATOM   1009  CG  ASN A  64       2.552   4.991  -5.063  1.00  4.42           C  
ATOM   1010  OD1 ASN A  64       3.535   4.398  -5.493  1.00 74.21           O  
ATOM   1011  ND2 ASN A  64       1.648   5.522  -5.860  1.00 71.02           N  
ATOM   1012  H   ASN A  64       4.859   5.713  -3.478  1.00 39.40           H  
ATOM   1013  HA  ASN A  64       2.432   7.298  -3.578  1.00 31.31           H  
ATOM   1014  HB2 ASN A  64       2.806   4.340  -3.060  1.00 39.40           H  
ATOM   1015  HB3 ASN A  64       1.271   5.146  -3.380  1.00 39.40           H  
ATOM   1016 HD21 ASN A  64       0.895   5.995  -5.459  1.00 39.40           H  
ATOM   1017 HD22 ASN A  64       1.777   5.425  -6.824  1.00 39.40           H  
ATOM   1018  N   ILE A  65       3.708   6.573  -0.742  1.00 60.54           N  
ATOM   1019  CA  ILE A  65       3.579   6.779   0.711  1.00 71.14           C  
ATOM   1020  C   ILE A  65       2.852   8.100   1.029  1.00 44.41           C  
ATOM   1021  O   ILE A  65       2.077   8.183   1.982  1.00 13.43           O  
ATOM   1022  CB  ILE A  65       4.968   6.776   1.411  1.00 71.41           C  
ATOM   1023  CG1 ILE A  65       5.662   5.414   1.235  1.00 63.14           C  
ATOM   1024  CG2 ILE A  65       4.840   7.130   2.896  1.00 12.34           C  
ATOM   1025  CD1 ILE A  65       4.943   4.260   1.907  1.00 34.43           C  
ATOM   1026  H   ILE A  65       4.592   6.374  -1.122  1.00 39.40           H  
ATOM   1027  HA  ILE A  65       2.997   5.957   1.111  1.00 42.15           H  
ATOM   1028  HB  ILE A  65       5.575   7.539   0.944  1.00 53.34           H  
ATOM   1029 HG12 ILE A  65       5.732   5.186   0.181  1.00 39.40           H  
ATOM   1030 HG13 ILE A  65       6.661   5.468   1.649  1.00 39.40           H  
ATOM   1031 HG21 ILE A  65       4.424   8.123   2.999  1.00 39.40           H  
ATOM   1032 HG22 ILE A  65       5.815   7.101   3.361  1.00 39.40           H  
ATOM   1033 HG23 ILE A  65       4.191   6.417   3.383  1.00 39.40           H  
ATOM   1034 HD11 ILE A  65       5.487   3.344   1.731  1.00 39.40           H  
ATOM   1035 HD12 ILE A  65       3.945   4.169   1.502  1.00 39.40           H  
ATOM   1036 HD13 ILE A  65       4.885   4.442   2.971  1.00 39.40           H  
ATOM   1037  N   LYS A  66       3.092   9.125   0.211  1.00 32.04           N  
ATOM   1038  CA  LYS A  66       2.456  10.437   0.399  1.00 41.05           C  
ATOM   1039  C   LYS A  66       0.924  10.370   0.241  1.00 14.25           C  
ATOM   1040  O   LYS A  66       0.210  11.293   0.634  1.00 63.03           O  
ATOM   1041  CB  LYS A  66       3.040  11.461  -0.584  1.00 74.22           C  
ATOM   1042  CG  LYS A  66       2.770  11.150  -2.059  1.00 51.41           C  
ATOM   1043  CD  LYS A  66       3.338  12.237  -2.970  1.00 54.42           C  
ATOM   1044  CE  LYS A  66       3.041  11.973  -4.443  1.00 35.24           C  
ATOM   1045  NZ  LYS A  66       3.728  10.755  -4.950  1.00  5.31           N  
ATOM   1046  H   LYS A  66       3.715   9.001  -0.534  1.00 39.40           H  
ATOM   1047  HA  LYS A  66       2.679  10.762   1.406  1.00 42.34           H  
ATOM   1048  HB2 LYS A  66       2.620  12.432  -0.362  1.00 39.40           H  
ATOM   1049  HB3 LYS A  66       4.110  11.505  -0.440  1.00 39.40           H  
ATOM   1050  HG2 LYS A  66       3.231  10.205  -2.308  1.00 39.40           H  
ATOM   1051  HG3 LYS A  66       1.701  11.084  -2.214  1.00 39.40           H  
ATOM   1052  HD2 LYS A  66       2.904  13.188  -2.694  1.00 39.40           H  
ATOM   1053  HD3 LYS A  66       4.410  12.281  -2.833  1.00 39.40           H  
ATOM   1054  HE2 LYS A  66       1.976  11.850  -4.568  1.00 39.40           H  
ATOM   1055  HE3 LYS A  66       3.369  12.826  -5.022  1.00 39.40           H  
ATOM   1056  HZ1 LYS A  66       3.383   9.912  -4.452  1.00 39.40           H  
ATOM   1057  HZ2 LYS A  66       4.755  10.836  -4.803  1.00 39.40           H  
ATOM   1058  HZ3 LYS A  66       3.542  10.638  -5.965  1.00 39.40           H  
ATOM   1059  N   LEU A  67       0.424   9.285  -0.349  1.00 31.43           N  
ATOM   1060  CA  LEU A  67      -1.021   9.101  -0.541  1.00 62.51           C  
ATOM   1061  C   LEU A  67      -1.705   8.593   0.739  1.00 54.35           C  
ATOM   1062  O   LEU A  67      -2.919   8.727   0.901  1.00 74.40           O  
ATOM   1063  CB  LEU A  67      -1.287   8.121  -1.693  1.00 74.13           C  
ATOM   1064  CG  LEU A  67      -0.683   8.518  -3.052  1.00 15.21           C  
ATOM   1065  CD1 LEU A  67      -0.990   7.459  -4.106  1.00 71.03           C  
ATOM   1066  CD2 LEU A  67      -1.193   9.889  -3.497  1.00 63.52           C  
ATOM   1067  H   LEU A  67       1.039   8.591  -0.665  1.00 39.40           H  
ATOM   1068  HA  LEU A  67      -1.443  10.063  -0.799  1.00 51.33           H  
ATOM   1069  HB2 LEU A  67      -0.888   7.155  -1.414  1.00 39.40           H  
ATOM   1070  HB3 LEU A  67      -2.358   8.024  -1.816  1.00 39.40           H  
ATOM   1071  HG  LEU A  67       0.393   8.580  -2.953  1.00 21.32           H  
ATOM   1072 HD11 LEU A  67      -0.540   7.745  -5.046  1.00 39.40           H  
ATOM   1073 HD12 LEU A  67      -2.058   7.369  -4.232  1.00 39.40           H  
ATOM   1074 HD13 LEU A  67      -0.584   6.508  -3.791  1.00 39.40           H  
ATOM   1075 HD21 LEU A  67      -0.910  10.632  -2.766  1.00 39.40           H  
ATOM   1076 HD22 LEU A  67      -2.270   9.864  -3.589  1.00 39.40           H  
ATOM   1077 HD23 LEU A  67      -0.757  10.144  -4.453  1.00 39.40           H  
ATOM   1078  N   LEU A  68      -0.920   8.022   1.654  1.00 45.53           N  
ATOM   1079  CA  LEU A  68      -1.460   7.460   2.904  1.00 35.12           C  
ATOM   1080  C   LEU A  68      -2.078   8.545   3.806  1.00 55.33           C  
ATOM   1081  O   LEU A  68      -2.848   8.243   4.718  1.00 31.20           O  
ATOM   1082  CB  LEU A  68      -0.359   6.704   3.665  1.00 21.41           C  
ATOM   1083  CG  LEU A  68       0.230   5.487   2.929  1.00 65.10           C  
ATOM   1084  CD1 LEU A  68       1.342   4.841   3.754  1.00 14.34           C  
ATOM   1085  CD2 LEU A  68      -0.863   4.468   2.603  1.00 52.24           C  
ATOM   1086  H   LEU A  68       0.047   7.974   1.488  1.00 39.40           H  
ATOM   1087  HA  LEU A  68      -2.236   6.760   2.633  1.00  2.12           H  
ATOM   1088  HB2 LEU A  68       0.445   7.398   3.873  1.00 39.40           H  
ATOM   1089  HB3 LEU A  68      -0.770   6.364   4.606  1.00 39.40           H  
ATOM   1090  HG  LEU A  68       0.665   5.820   1.996  1.00 15.12           H  
ATOM   1091 HD11 LEU A  68       2.145   5.550   3.893  1.00 39.40           H  
ATOM   1092 HD12 LEU A  68       1.717   3.971   3.235  1.00 39.40           H  
ATOM   1093 HD13 LEU A  68       0.954   4.543   4.718  1.00 39.40           H  
ATOM   1094 HD21 LEU A  68      -1.319   4.120   3.518  1.00 39.40           H  
ATOM   1095 HD22 LEU A  68      -0.428   3.629   2.077  1.00 39.40           H  
ATOM   1096 HD23 LEU A  68      -1.614   4.930   1.979  1.00 39.40           H  
ATOM   1097  N   LYS A  69      -1.742   9.808   3.548  1.00 72.13           N  
ATOM   1098  CA  LYS A  69      -2.295  10.930   4.318  1.00 52.03           C  
ATOM   1099  C   LYS A  69      -3.681  11.351   3.791  1.00 64.31           C  
ATOM   1100  O   LYS A  69      -4.332  12.226   4.364  1.00 50.41           O  
ATOM   1101  CB  LYS A  69      -1.334  12.131   4.276  1.00  1.12           C  
ATOM   1102  CG  LYS A  69      -1.224  12.794   2.904  1.00 30.01           C  
ATOM   1103  CD  LYS A  69      -0.147  13.886   2.851  1.00 61.24           C  
ATOM   1104  CE  LYS A  69      -0.493  15.114   3.698  1.00 71.14           C  
ATOM   1105  NZ  LYS A  69      -0.371  14.859   5.158  1.00 32.33           N  
ATOM   1106  H   LYS A  69      -1.099   9.990   2.830  1.00 39.40           H  
ATOM   1107  HA  LYS A  69      -2.402  10.606   5.343  1.00 31.33           H  
ATOM   1108  HB2 LYS A  69      -1.676  12.873   4.984  1.00 39.40           H  
ATOM   1109  HB3 LYS A  69      -0.349  11.798   4.571  1.00 39.40           H  
ATOM   1110  HG2 LYS A  69      -0.979  12.037   2.173  1.00 39.40           H  
ATOM   1111  HG3 LYS A  69      -2.181  13.234   2.652  1.00 39.40           H  
ATOM   1112  HD2 LYS A  69       0.783  13.472   3.211  1.00 39.40           H  
ATOM   1113  HD3 LYS A  69      -0.023  14.198   1.823  1.00 39.40           H  
ATOM   1114  HE2 LYS A  69       0.178  15.916   3.431  1.00 39.40           H  
ATOM   1115  HE3 LYS A  69      -1.509  15.413   3.478  1.00 39.40           H  
ATOM   1116  HZ1 LYS A  69       0.539  14.406   5.369  1.00 39.40           H  
ATOM   1117  HZ2 LYS A  69      -1.137  14.240   5.483  1.00 39.40           H  
ATOM   1118  HZ3 LYS A  69      -0.423  15.756   5.683  1.00 39.40           H  
ATOM   1119  N   LYS A  70      -4.119  10.740   2.686  1.00 13.22           N  
ATOM   1120  CA  LYS A  70      -5.370  11.135   2.015  1.00  3.12           C  
ATOM   1121  C   LYS A  70      -6.609  10.411   2.571  1.00 12.24           C  
ATOM   1122  O   LYS A  70      -7.662  11.024   2.749  1.00 31.54           O  
ATOM   1123  CB  LYS A  70      -5.258  10.877   0.507  1.00 71.13           C  
ATOM   1124  CG  LYS A  70      -4.131  11.654  -0.169  1.00 61.34           C  
ATOM   1125  CD  LYS A  70      -4.060  11.370  -1.667  1.00 23.43           C  
ATOM   1126  CE  LYS A  70      -5.361  11.728  -2.379  1.00  0.33           C  
ATOM   1127  NZ  LYS A  70      -5.731  13.158  -2.192  1.00 50.01           N  
ATOM   1128  H   LYS A  70      -3.590  10.004   2.309  1.00 39.40           H  
ATOM   1129  HA  LYS A  70      -5.500  12.198   2.169  1.00 24.01           H  
ATOM   1130  HB2 LYS A  70      -5.087   9.820   0.345  1.00 39.40           H  
ATOM   1131  HB3 LYS A  70      -6.191  11.156   0.036  1.00 39.40           H  
ATOM   1132  HG2 LYS A  70      -4.296  12.710  -0.021  1.00 39.40           H  
ATOM   1133  HG3 LYS A  70      -3.190  11.369   0.286  1.00 39.40           H  
ATOM   1134  HD2 LYS A  70      -3.257  11.953  -2.095  1.00 39.40           H  
ATOM   1135  HD3 LYS A  70      -3.858  10.318  -1.814  1.00 39.40           H  
ATOM   1136  HE2 LYS A  70      -5.244  11.536  -3.435  1.00 39.40           H  
ATOM   1137  HE3 LYS A  70      -6.155  11.107  -1.989  1.00 39.40           H  
ATOM   1138  HZ1 LYS A  70      -6.578  13.385  -2.752  1.00 39.40           H  
ATOM   1139  HZ2 LYS A  70      -4.953  13.772  -2.505  1.00 39.40           H  
ATOM   1140  HZ3 LYS A  70      -5.931  13.355  -1.192  1.00 39.40           H  
ATOM   1141  N   PHE A  71      -6.490   9.109   2.837  1.00 45.22           N  
ATOM   1142  CA  PHE A  71      -7.645   8.303   3.269  1.00 11.54           C  
ATOM   1143  C   PHE A  71      -7.428   7.660   4.648  1.00 21.31           C  
ATOM   1144  O   PHE A  71      -6.305   7.578   5.148  1.00 64.20           O  
ATOM   1145  CB  PHE A  71      -7.964   7.220   2.223  1.00 42.55           C  
ATOM   1146  CG  PHE A  71      -6.814   6.282   1.928  1.00 33.32           C  
ATOM   1147  CD1 PHE A  71      -5.843   6.624   0.996  1.00 70.22           C  
ATOM   1148  CD2 PHE A  71      -6.710   5.057   2.576  1.00  2.32           C  
ATOM   1149  CE1 PHE A  71      -4.793   5.768   0.720  1.00 34.24           C  
ATOM   1150  CE2 PHE A  71      -5.661   4.198   2.302  1.00 43.30           C  
ATOM   1151  CZ  PHE A  71      -4.703   4.554   1.373  1.00 42.11           C  
ATOM   1152  H   PHE A  71      -5.614   8.682   2.754  1.00 39.40           H  
ATOM   1153  HA  PHE A  71      -8.497   8.966   3.340  1.00 64.32           H  
ATOM   1154  HB2 PHE A  71      -8.795   6.627   2.574  1.00 39.40           H  
ATOM   1155  HB3 PHE A  71      -8.245   7.701   1.296  1.00 39.40           H  
ATOM   1156  HD1 PHE A  71      -5.908   7.575   0.485  1.00 33.40           H  
ATOM   1157  HD2 PHE A  71      -7.459   4.774   3.302  1.00  3.24           H  
ATOM   1158  HE1 PHE A  71      -4.044   6.047  -0.008  1.00 22.42           H  
ATOM   1159  HE2 PHE A  71      -5.593   3.249   2.813  1.00 22.40           H  
ATOM   1160  HZ  PHE A  71      -3.884   3.883   1.156  1.00 20.13           H  
ATOM   1161  N   ARG A  72      -8.522   7.202   5.256  1.00 42.22           N  
ATOM   1162  CA  ARG A  72      -8.484   6.585   6.588  1.00 52.23           C  
ATOM   1163  C   ARG A  72      -8.796   5.081   6.524  1.00  2.23           C  
ATOM   1164  O   ARG A  72      -9.340   4.585   5.534  1.00 40.41           O  
ATOM   1165  CB  ARG A  72      -9.507   7.274   7.499  1.00 70.04           C  
ATOM   1166  CG  ARG A  72      -9.294   8.779   7.645  1.00 31.11           C  
ATOM   1167  CD  ARG A  72     -10.527   9.457   8.229  1.00 50.13           C  
ATOM   1168  NE  ARG A  72     -11.697   9.262   7.376  1.00 43.24           N  
ATOM   1169  CZ  ARG A  72     -12.836   9.871   7.533  1.00  3.04           C  
ATOM   1170  NH1 ARG A  72     -13.004  10.736   8.481  1.00  0.13           N  
ATOM   1171  NH2 ARG A  72     -13.810   9.612   6.728  1.00 72.21           N  
ATOM   1172  H   ARG A  72      -9.389   7.284   4.797  1.00 39.40           H  
ATOM   1173  HA  ARG A  72      -7.495   6.725   7.000  1.00 31.34           H  
ATOM   1174  HB2 ARG A  72     -10.496   7.108   7.096  1.00 39.40           H  
ATOM   1175  HB3 ARG A  72      -9.451   6.827   8.484  1.00 39.40           H  
ATOM   1176  HG2 ARG A  72      -8.454   8.953   8.302  1.00 39.40           H  
ATOM   1177  HG3 ARG A  72      -9.086   9.204   6.673  1.00 39.40           H  
ATOM   1178  HD2 ARG A  72     -10.729   9.039   9.204  1.00 39.40           H  
ATOM   1179  HD3 ARG A  72     -10.333  10.517   8.323  1.00 39.40           H  
ATOM   1180  HE  ARG A  72     -11.616   8.623   6.638  1.00 63.05           H  
ATOM   1181 HH11 ARG A  72     -12.255  10.952   9.102  1.00 39.40           H  
ATOM   1182 HH12 ARG A  72     -13.891  11.178   8.597  1.00 39.40           H  
ATOM   1183 HH21 ARG A  72     -13.684   8.942   5.992  1.00 39.40           H  
ATOM   1184 HH22 ARG A  72     -14.684  10.081   6.834  1.00 39.40           H  
ATOM   1185  N   GLU A  73      -8.466   4.364   7.597  1.00 23.21           N  
ATOM   1186  CA  GLU A  73      -8.759   2.931   7.689  1.00 24.33           C  
ATOM   1187  C   GLU A  73     -10.271   2.701   7.882  1.00 30.52           C  
ATOM   1188  O   GLU A  73     -10.748   2.458   8.996  1.00 53.34           O  
ATOM   1189  CB  GLU A  73      -7.956   2.296   8.843  1.00 53.31           C  
ATOM   1190  CG  GLU A  73      -8.037   0.773   8.887  1.00 13.03           C  
ATOM   1191  CD  GLU A  73      -7.322   0.161  10.087  1.00 20.34           C  
ATOM   1192  OE1 GLU A  73      -7.875   0.206  11.201  1.00 22.34           O  
ATOM   1193  OE2 GLU A  73      -6.212  -0.386   9.914  1.00 70.01           O  
ATOM   1194  H   GLU A  73      -8.012   4.806   8.344  1.00 39.40           H  
ATOM   1195  HA  GLU A  73      -8.456   2.472   6.758  1.00 24.53           H  
ATOM   1196  HB2 GLU A  73      -6.916   2.577   8.737  1.00 39.40           H  
ATOM   1197  HB3 GLU A  73      -8.327   2.685   9.782  1.00 39.40           H  
ATOM   1198  HG2 GLU A  73      -9.076   0.485   8.923  1.00 39.40           H  
ATOM   1199  HG3 GLU A  73      -7.594   0.379   7.982  1.00 39.40           H  
ATOM   1200  N   GLY A  74     -11.025   2.805   6.788  1.00 55.03           N  
ATOM   1201  CA  GLY A  74     -12.483   2.701   6.856  1.00 50.44           C  
ATOM   1202  C   GLY A  74     -13.196   3.417   5.707  1.00 44.01           C  
ATOM   1203  O   GLY A  74     -14.416   3.302   5.557  1.00 13.51           O  
ATOM   1204  H   GLY A  74     -10.587   2.939   5.922  1.00 39.40           H  
ATOM   1205  HA2 GLY A  74     -12.755   1.657   6.837  1.00 39.40           H  
ATOM   1206  HA3 GLY A  74     -12.821   3.130   7.791  1.00 39.40           H  
ATOM   1207  N   ASP A  75     -12.445   4.183   4.912  1.00 14.13           N  
ATOM   1208  CA  ASP A  75     -12.999   4.843   3.721  1.00 73.54           C  
ATOM   1209  C   ASP A  75     -12.920   3.921   2.489  1.00 64.14           C  
ATOM   1210  O   ASP A  75     -12.380   2.819   2.552  1.00 23.43           O  
ATOM   1211  CB  ASP A  75     -12.256   6.157   3.430  1.00 52.10           C  
ATOM   1212  CG  ASP A  75     -12.384   7.178   4.550  1.00  4.51           C  
ATOM   1213  OD1 ASP A  75     -13.507   7.373   5.065  1.00 35.24           O  
ATOM   1214  OD2 ASP A  75     -11.365   7.810   4.905  1.00  4.43           O  
ATOM   1215  H   ASP A  75     -11.499   4.310   5.127  1.00 39.40           H  
ATOM   1216  HA  ASP A  75     -14.040   5.064   3.918  1.00 22.02           H  
ATOM   1217  HB2 ASP A  75     -11.207   5.941   3.282  1.00 39.40           H  
ATOM   1218  HB3 ASP A  75     -12.657   6.594   2.525  1.00 39.40           H  
ATOM   1219  N   VAL A  76     -13.472   4.377   1.367  1.00 31.35           N  
ATOM   1220  CA  VAL A  76     -13.406   3.626   0.105  1.00 74.10           C  
ATOM   1221  C   VAL A  76     -12.456   4.323  -0.874  1.00 12.10           C  
ATOM   1222  O   VAL A  76     -12.494   5.543  -1.002  1.00 51.43           O  
ATOM   1223  CB  VAL A  76     -14.803   3.511  -0.551  1.00 73.24           C  
ATOM   1224  CG1 VAL A  76     -14.785   2.517  -1.712  1.00  4.33           C  
ATOM   1225  CG2 VAL A  76     -15.854   3.136   0.491  1.00 25.15           C  
ATOM   1226  H   VAL A  76     -13.934   5.240   1.381  1.00 39.40           H  
ATOM   1227  HA  VAL A  76     -13.038   2.630   0.316  1.00 61.31           H  
ATOM   1228  HB  VAL A  76     -15.064   4.483  -0.953  1.00  0.44           H  
ATOM   1229 HG11 VAL A  76     -14.519   1.535  -1.344  1.00 39.40           H  
ATOM   1230 HG12 VAL A  76     -14.059   2.833  -2.449  1.00 39.40           H  
ATOM   1231 HG13 VAL A  76     -15.764   2.476  -2.169  1.00 39.40           H  
ATOM   1232 HG21 VAL A  76     -15.523   2.270   1.044  1.00 39.40           H  
ATOM   1233 HG22 VAL A  76     -16.791   2.914  -0.001  1.00 39.40           H  
ATOM   1234 HG23 VAL A  76     -15.996   3.962   1.171  1.00 39.40           H  
ATOM   1235  N   ILE A  77     -11.607   3.564  -1.566  1.00 65.33           N  
ATOM   1236  CA  ILE A  77     -10.643   4.168  -2.497  1.00 53.43           C  
ATOM   1237  C   ILE A  77     -10.578   3.435  -3.845  1.00 54.01           C  
ATOM   1238  O   ILE A  77     -10.770   2.219  -3.929  1.00 43.51           O  
ATOM   1239  CB  ILE A  77      -9.210   4.223  -1.896  1.00  2.30           C  
ATOM   1240  CG1 ILE A  77      -8.692   2.806  -1.579  1.00 73.43           C  
ATOM   1241  CG2 ILE A  77      -9.178   5.108  -0.649  1.00 41.42           C  
ATOM   1242  CD1 ILE A  77      -7.262   2.774  -1.077  1.00  1.43           C  
ATOM   1243  H   ILE A  77     -11.625   2.589  -1.456  1.00 39.40           H  
ATOM   1244  HA  ILE A  77     -10.962   5.186  -2.682  1.00 62.40           H  
ATOM   1245  HB  ILE A  77      -8.558   4.674  -2.632  1.00 53.31           H  
ATOM   1246 HG12 ILE A  77      -9.316   2.361  -0.818  1.00 39.40           H  
ATOM   1247 HG13 ILE A  77      -8.740   2.201  -2.474  1.00 39.40           H  
ATOM   1248 HG21 ILE A  77      -9.867   4.720   0.087  1.00 39.40           H  
ATOM   1249 HG22 ILE A  77      -9.465   6.116  -0.912  1.00 39.40           H  
ATOM   1250 HG23 ILE A  77      -8.179   5.116  -0.236  1.00 39.40           H  
ATOM   1251 HD11 ILE A  77      -6.608   3.197  -1.826  1.00 39.40           H  
ATOM   1252 HD12 ILE A  77      -6.972   1.753  -0.882  1.00 39.40           H  
ATOM   1253 HD13 ILE A  77      -7.187   3.350  -0.165  1.00 39.40           H  
ATOM   1254  N   ARG A  78     -10.322   4.200  -4.901  1.00 73.21           N  
ATOM   1255  CA  ARG A  78     -10.004   3.640  -6.215  1.00 61.04           C  
ATOM   1256  C   ARG A  78      -8.567   4.007  -6.607  1.00 61.31           C  
ATOM   1257  O   ARG A  78      -8.242   5.182  -6.788  1.00 53.34           O  
ATOM   1258  CB  ARG A  78     -11.001   4.129  -7.278  1.00  4.32           C  
ATOM   1259  CG  ARG A  78     -10.612   3.762  -8.711  1.00 72.14           C  
ATOM   1260  CD  ARG A  78     -11.774   3.917  -9.692  1.00 43.11           C  
ATOM   1261  NE  ARG A  78     -12.363   5.257  -9.688  1.00 41.03           N  
ATOM   1262  CZ  ARG A  78     -13.256   5.661 -10.554  1.00 40.33           C  
ATOM   1263  NH1 ARG A  78     -13.611   4.903 -11.544  1.00 42.10           N  
ATOM   1264  NH2 ARG A  78     -13.771   6.840 -10.443  1.00 23.22           N  
ATOM   1265  H   ARG A  78     -10.355   5.175  -4.795  1.00 39.40           H  
ATOM   1266  HA  ARG A  78     -10.073   2.561  -6.140  1.00 23.45           H  
ATOM   1267  HB2 ARG A  78     -11.969   3.696  -7.069  1.00 39.40           H  
ATOM   1268  HB3 ARG A  78     -11.078   5.205  -7.213  1.00 39.40           H  
ATOM   1269  HG2 ARG A  78      -9.803   4.405  -9.028  1.00 39.40           H  
ATOM   1270  HG3 ARG A  78     -10.276   2.734  -8.728  1.00 39.40           H  
ATOM   1271  HD2 ARG A  78     -11.412   3.705 -10.688  1.00 39.40           H  
ATOM   1272  HD3 ARG A  78     -12.539   3.198  -9.434  1.00 39.40           H  
ATOM   1273  HE  ARG A  78     -12.089   5.878  -8.984  1.00  2.44           H  
ATOM   1274 HH11 ARG A  78     -13.198   4.004 -11.656  1.00 39.40           H  
ATOM   1275 HH12 ARG A  78     -14.300   5.221 -12.196  1.00 39.40           H  
ATOM   1276 HH21 ARG A  78     -13.481   7.438  -9.696  1.00 39.40           H  
ATOM   1277 HH22 ARG A  78     -14.449   7.154 -11.101  1.00 39.40           H  
ATOM   1278  N   ILE A  79      -7.708   2.998  -6.710  1.00 64.44           N  
ATOM   1279  CA  ILE A  79      -6.295   3.205  -7.032  1.00 15.21           C  
ATOM   1280  C   ILE A  79      -6.043   3.012  -8.534  1.00 41.44           C  
ATOM   1281  O   ILE A  79      -6.346   1.959  -9.097  1.00 54.44           O  
ATOM   1282  CB  ILE A  79      -5.397   2.227  -6.236  1.00 52.15           C  
ATOM   1283  CG1 ILE A  79      -5.723   2.294  -4.731  1.00  4.40           C  
ATOM   1284  CG2 ILE A  79      -3.924   2.544  -6.485  1.00 31.34           C  
ATOM   1285  CD1 ILE A  79      -4.904   1.346  -3.877  1.00 12.41           C  
ATOM   1286  H   ILE A  79      -8.035   2.084  -6.577  1.00 39.40           H  
ATOM   1287  HA  ILE A  79      -6.029   4.217  -6.755  1.00 62.11           H  
ATOM   1288  HB  ILE A  79      -5.589   1.224  -6.594  1.00 61.34           H  
ATOM   1289 HG12 ILE A  79      -5.544   3.298  -4.372  1.00 39.40           H  
ATOM   1290 HG13 ILE A  79      -6.766   2.051  -4.587  1.00 39.40           H  
ATOM   1291 HG21 ILE A  79      -3.708   2.461  -7.540  1.00 39.40           H  
ATOM   1292 HG22 ILE A  79      -3.306   1.846  -5.938  1.00 39.40           H  
ATOM   1293 HG23 ILE A  79      -3.711   3.549  -6.153  1.00 39.40           H  
ATOM   1294 HD11 ILE A  79      -3.853   1.563  -4.002  1.00 39.40           H  
ATOM   1295 HD12 ILE A  79      -5.100   0.327  -4.181  1.00 39.40           H  
ATOM   1296 HD13 ILE A  79      -5.175   1.470  -2.839  1.00 39.40           H  
ATOM   1297  N   LYS A  80      -5.482   4.025  -9.182  1.00 40.14           N  
ATOM   1298  CA  LYS A  80      -5.260   3.981 -10.627  1.00 12.41           C  
ATOM   1299  C   LYS A  80      -3.806   3.616 -10.977  1.00 31.35           C  
ATOM   1300  O   LYS A  80      -2.867   4.061 -10.316  1.00 75.15           O  
ATOM   1301  CB  LYS A  80      -5.642   5.330 -11.248  1.00 32.24           C  
ATOM   1302  CG  LYS A  80      -5.580   5.348 -12.772  1.00 44.21           C  
ATOM   1303  CD  LYS A  80      -6.059   6.678 -13.347  1.00 41.42           C  
ATOM   1304  CE  LYS A  80      -5.909   6.720 -14.861  1.00 74.11           C  
ATOM   1305  NZ  LYS A  80      -4.482   6.678 -15.284  1.00 70.21           N  
ATOM   1306  H   LYS A  80      -5.213   4.825  -8.679  1.00 39.40           H  
ATOM   1307  HA  LYS A  80      -5.911   3.219 -11.035  1.00 41.34           H  
ATOM   1308  HB2 LYS A  80      -6.651   5.577 -10.948  1.00 39.40           H  
ATOM   1309  HB3 LYS A  80      -4.971   6.089 -10.871  1.00 39.40           H  
ATOM   1310  HG2 LYS A  80      -4.558   5.181 -13.081  1.00 39.40           H  
ATOM   1311  HG3 LYS A  80      -6.205   4.554 -13.155  1.00 39.40           H  
ATOM   1312  HD2 LYS A  80      -7.103   6.813 -13.095  1.00 39.40           H  
ATOM   1313  HD3 LYS A  80      -5.477   7.480 -12.913  1.00 39.40           H  
ATOM   1314  HE2 LYS A  80      -6.426   5.872 -15.288  1.00 39.40           H  
ATOM   1315  HE3 LYS A  80      -6.356   7.634 -15.229  1.00 39.40           H  
ATOM   1316  HZ1 LYS A  80      -4.015   7.579 -15.055  1.00 39.40           H  
ATOM   1317  HZ2 LYS A  80      -4.415   6.522 -16.311  1.00 39.40           H  
ATOM   1318  HZ3 LYS A  80      -3.977   5.909 -14.796  1.00 39.40           H  
ATOM   1319  N   ASP A  81      -3.646   2.797 -12.024  1.00 44.22           N  
ATOM   1320  CA  ASP A  81      -2.325   2.396 -12.544  1.00 21.44           C  
ATOM   1321  C   ASP A  81      -1.523   1.535 -11.544  1.00 74.10           C  
ATOM   1322  O   ASP A  81      -0.636   2.032 -10.853  1.00 33.03           O  
ATOM   1323  CB  ASP A  81      -1.503   3.631 -12.950  1.00 25.13           C  
ATOM   1324  CG  ASP A  81      -2.214   4.498 -13.974  1.00 21.31           C  
ATOM   1325  OD1 ASP A  81      -2.505   4.003 -15.079  1.00 23.41           O  
ATOM   1326  OD2 ASP A  81      -2.479   5.686 -13.685  1.00 45.24           O  
ATOM   1327  H   ASP A  81      -4.446   2.451 -12.469  1.00 39.40           H  
ATOM   1328  HA  ASP A  81      -2.504   1.802 -13.430  1.00  3.03           H  
ATOM   1329  HB2 ASP A  81      -1.307   4.227 -12.069  1.00 39.40           H  
ATOM   1330  HB3 ASP A  81      -0.562   3.306 -13.371  1.00 39.40           H  
ATOM   1331  N   VAL A  82      -1.840   0.240 -11.460  1.00 32.11           N  
ATOM   1332  CA  VAL A  82      -1.087  -0.684 -10.592  1.00  1.51           C  
ATOM   1333  C   VAL A  82      -0.796  -2.020 -11.294  1.00 34.24           C  
ATOM   1334  O   VAL A  82      -1.479  -2.403 -12.248  1.00 15.53           O  
ATOM   1335  CB  VAL A  82      -1.822  -0.969  -9.251  1.00 25.02           C  
ATOM   1336  CG1 VAL A  82      -2.005   0.313  -8.447  1.00 41.55           C  
ATOM   1337  CG2 VAL A  82      -3.167  -1.653  -9.490  1.00 23.03           C  
ATOM   1338  H   VAL A  82      -2.593  -0.105 -11.985  1.00 39.40           H  
ATOM   1339  HA  VAL A  82      -0.139  -0.213 -10.358  1.00 34.10           H  
ATOM   1340  HB  VAL A  82      -1.205  -1.641  -8.668  1.00 34.05           H  
ATOM   1341 HG11 VAL A  82      -1.039   0.757  -8.247  1.00 39.40           H  
ATOM   1342 HG12 VAL A  82      -2.493   0.086  -7.509  1.00 39.40           H  
ATOM   1343 HG13 VAL A  82      -2.612   1.009  -9.007  1.00 39.40           H  
ATOM   1344 HG21 VAL A  82      -3.804  -1.003 -10.071  1.00 39.40           H  
ATOM   1345 HG22 VAL A  82      -3.639  -1.862  -8.540  1.00 39.40           H  
ATOM   1346 HG23 VAL A  82      -3.013  -2.580 -10.025  1.00 39.40           H  
ATOM   1347  N   ASN A  83       0.232  -2.720 -10.816  1.00  4.44           N  
ATOM   1348  CA  ASN A  83       0.595  -4.043 -11.343  1.00 54.02           C  
ATOM   1349  C   ASN A  83       0.190  -5.162 -10.370  1.00 41.31           C  
ATOM   1350  O   ASN A  83       0.623  -5.188  -9.216  1.00 21.32           O  
ATOM   1351  CB  ASN A  83       2.103  -4.118 -11.626  1.00  3.14           C  
ATOM   1352  CG  ASN A  83       2.531  -3.256 -12.806  1.00 44.41           C  
ATOM   1353  OD1 ASN A  83       3.628  -2.708 -12.825  1.00 10.45           O  
ATOM   1354  ND2 ASN A  83       1.683  -3.144 -13.811  1.00 42.44           N  
ATOM   1355  H   ASN A  83       0.761  -2.338 -10.083  1.00 39.40           H  
ATOM   1356  HA  ASN A  83       0.060  -4.189 -12.271  1.00 54.24           H  
ATOM   1357  HB2 ASN A  83       2.645  -3.787 -10.751  1.00 39.40           H  
ATOM   1358  HB3 ASN A  83       2.373  -5.142 -11.840  1.00 39.40           H  
ATOM   1359 HD21 ASN A  83       0.828  -3.612 -13.754  1.00 39.40           H  
ATOM   1360 HD22 ASN A  83       1.952  -2.596 -14.579  1.00 39.40           H  
ATOM   1361  N   ILE A  84      -0.641  -6.085 -10.846  1.00 23.25           N  
ATOM   1362  CA  ILE A  84      -1.115  -7.203 -10.026  1.00 53.33           C  
ATOM   1363  C   ILE A  84      -0.073  -8.335  -9.983  1.00 63.14           C  
ATOM   1364  O   ILE A  84       0.271  -8.902 -11.014  1.00 11.12           O  
ATOM   1365  CB  ILE A  84      -2.453  -7.763 -10.579  1.00 51.20           C  
ATOM   1366  CG1 ILE A  84      -3.496  -6.637 -10.720  1.00 11.31           C  
ATOM   1367  CG2 ILE A  84      -2.985  -8.885  -9.687  1.00 51.11           C  
ATOM   1368  CD1 ILE A  84      -3.809  -5.919  -9.421  1.00  1.24           C  
ATOM   1369  H   ILE A  84      -0.942  -6.016 -11.779  1.00 39.40           H  
ATOM   1370  HA  ILE A  84      -1.285  -6.839  -9.021  1.00 62.21           H  
ATOM   1371  HB  ILE A  84      -2.260  -8.182 -11.559  1.00 61.35           H  
ATOM   1372 HG12 ILE A  84      -3.132  -5.901 -11.421  1.00 39.40           H  
ATOM   1373 HG13 ILE A  84      -4.420  -7.057 -11.097  1.00 39.40           H  
ATOM   1374 HG21 ILE A  84      -3.914  -9.257 -10.092  1.00 39.40           H  
ATOM   1375 HG22 ILE A  84      -3.153  -8.508  -8.688  1.00 39.40           H  
ATOM   1376 HG23 ILE A  84      -2.264  -9.689  -9.649  1.00 39.40           H  
ATOM   1377 HD11 ILE A  84      -4.572  -5.174  -9.596  1.00 39.40           H  
ATOM   1378 HD12 ILE A  84      -2.915  -5.439  -9.049  1.00 39.40           H  
ATOM   1379 HD13 ILE A  84      -4.166  -6.631  -8.692  1.00 39.40           H  
ATOM   1380  N   ARG A  85       0.433  -8.660  -8.794  1.00 53.41           N  
ATOM   1381  CA  ARG A  85       1.447  -9.719  -8.658  1.00 12.53           C  
ATOM   1382  C   ARG A  85       0.811 -11.073  -8.286  1.00  0.35           C  
ATOM   1383  O   ARG A  85       0.846 -12.021  -9.068  1.00 43.23           O  
ATOM   1384  CB  ARG A  85       2.491  -9.328  -7.604  1.00 40.33           C  
ATOM   1385  CG  ARG A  85       3.123  -7.959  -7.828  1.00 53.04           C  
ATOM   1386  CD  ARG A  85       3.896  -7.882  -9.138  1.00 52.14           C  
ATOM   1387  NE  ARG A  85       4.489  -6.560  -9.335  1.00 42.13           N  
ATOM   1388  CZ  ARG A  85       5.453  -6.306 -10.177  1.00 14.44           C  
ATOM   1389  NH1 ARG A  85       5.981  -7.257 -10.882  1.00 45.41           N  
ATOM   1390  NH2 ARG A  85       5.902  -5.097 -10.305  1.00 61.35           N  
ATOM   1391  H   ARG A  85       0.127  -8.178  -7.996  1.00 39.40           H  
ATOM   1392  HA  ARG A  85       1.943  -9.825  -9.614  1.00  4.14           H  
ATOM   1393  HB2 ARG A  85       2.020  -9.325  -6.633  1.00 39.40           H  
ATOM   1394  HB3 ARG A  85       3.279 -10.069  -7.606  1.00 39.40           H  
ATOM   1395  HG2 ARG A  85       2.344  -7.210  -7.842  1.00 39.40           H  
ATOM   1396  HG3 ARG A  85       3.802  -7.752  -7.011  1.00 39.40           H  
ATOM   1397  HD2 ARG A  85       4.683  -8.623  -9.125  1.00 39.40           H  
ATOM   1398  HD3 ARG A  85       3.221  -8.088  -9.957  1.00 39.40           H  
ATOM   1399  HE  ARG A  85       4.132  -5.823  -8.808  1.00 43.14           H  
ATOM   1400 HH11 ARG A  85       5.652  -8.194 -10.783  1.00 39.40           H  
ATOM   1401 HH12 ARG A  85       6.717  -7.049 -11.521  1.00 39.40           H  
ATOM   1402 HH21 ARG A  85       5.515  -4.356  -9.759  1.00 39.40           H  
ATOM   1403 HH22 ARG A  85       6.634  -4.908 -10.955  1.00 39.40           H  
ATOM   1404  N   GLY A  86       0.244 -11.156  -7.082  1.00 52.13           N  
ATOM   1405  CA  GLY A  86      -0.389 -12.396  -6.633  1.00 64.43           C  
ATOM   1406  C   GLY A  86       0.572 -13.322  -5.891  1.00 42.34           C  
ATOM   1407  O   GLY A  86       0.942 -14.383  -6.397  1.00 72.04           O  
ATOM   1408  H   GLY A  86       0.261 -10.377  -6.491  1.00 39.40           H  
ATOM   1409  HA2 GLY A  86      -1.209 -12.146  -5.975  1.00 39.40           H  
ATOM   1410  HA3 GLY A  86      -0.785 -12.919  -7.493  1.00 39.40           H  
ATOM   1411  N   GLY A  87       0.963 -12.930  -4.680  1.00 23.21           N  
ATOM   1412  CA  GLY A  87       1.951 -13.697  -3.920  1.00 14.33           C  
ATOM   1413  C   GLY A  87       1.338 -14.715  -2.965  1.00 32.54           C  
ATOM   1414  O   GLY A  87       2.011 -15.197  -2.052  1.00 44.34           O  
ATOM   1415  H   GLY A  87       0.581 -12.114  -4.292  1.00 39.40           H  
ATOM   1416  HA2 GLY A  87       2.596 -14.220  -4.613  1.00 39.40           H  
ATOM   1417  HA3 GLY A  87       2.552 -13.006  -3.347  1.00 39.40           H  
ATOM   1418  N   PHE A  88       0.066 -15.044  -3.172  1.00 51.04           N  
ATOM   1419  CA  PHE A  88      -0.626 -16.022  -2.327  1.00 10.23           C  
ATOM   1420  C   PHE A  88      -1.864 -16.600  -3.031  1.00 53.50           C  
ATOM   1421  O   PHE A  88      -2.541 -15.903  -3.793  1.00 42.23           O  
ATOM   1422  CB  PHE A  88      -1.030 -15.383  -0.988  1.00 12.41           C  
ATOM   1423  CG  PHE A  88      -1.736 -16.331  -0.048  1.00 31.31           C  
ATOM   1424  CD1 PHE A  88      -1.094 -17.469   0.423  1.00 34.24           C  
ATOM   1425  CD2 PHE A  88      -3.039 -16.084   0.365  1.00 44.21           C  
ATOM   1426  CE1 PHE A  88      -1.736 -18.338   1.285  1.00 71.50           C  
ATOM   1427  CE2 PHE A  88      -3.683 -16.953   1.226  1.00 23.03           C  
ATOM   1428  CZ  PHE A  88      -3.032 -18.080   1.685  1.00 72.21           C  
ATOM   1429  H   PHE A  88      -0.421 -14.622  -3.907  1.00 39.40           H  
ATOM   1430  HA  PHE A  88       0.065 -16.832  -2.132  1.00  2.05           H  
ATOM   1431  HB2 PHE A  88      -0.141 -15.021  -0.488  1.00 39.40           H  
ATOM   1432  HB3 PHE A  88      -1.689 -14.548  -1.183  1.00 39.40           H  
ATOM   1433  HD1 PHE A  88      -0.082 -17.676   0.109  1.00 75.20           H  
ATOM   1434  HD2 PHE A  88      -3.552 -15.203   0.007  1.00 14.21           H  
ATOM   1435  HE1 PHE A  88      -1.224 -19.220   1.644  1.00 33.32           H  
ATOM   1436  HE2 PHE A  88      -4.697 -16.751   1.540  1.00 54.23           H  
ATOM   1437  HZ  PHE A  88      -3.535 -18.759   2.359  1.00 22.12           H  
ATOM   1438  N   GLY A  89      -2.147 -17.877  -2.773  1.00 33.02           N  
ATOM   1439  CA  GLY A  89      -3.335 -18.523  -3.322  1.00 70.22           C  
ATOM   1440  C   GLY A  89      -4.634 -17.961  -2.750  1.00 13.01           C  
ATOM   1441  O   GLY A  89      -5.224 -18.536  -1.827  1.00 62.23           O  
ATOM   1442  H   GLY A  89      -1.534 -18.395  -2.207  1.00 39.40           H  
ATOM   1443  HA2 GLY A  89      -3.340 -18.394  -4.396  1.00 39.40           H  
ATOM   1444  HA3 GLY A  89      -3.286 -19.580  -3.099  1.00 39.40           H  
ATOM   1445  N   GLY A  90      -5.070 -16.826  -3.287  1.00 40.22           N  
ATOM   1446  CA  GLY A  90      -6.293 -16.183  -2.817  1.00 22.14           C  
ATOM   1447  C   GLY A  90      -6.201 -14.661  -2.835  1.00 11.01           C  
ATOM   1448  O   GLY A  90      -6.440 -14.027  -3.865  1.00 14.52           O  
ATOM   1449  H   GLY A  90      -4.550 -16.414  -4.013  1.00 39.40           H  
ATOM   1450  HA2 GLY A  90      -7.111 -16.490  -3.451  1.00 39.40           H  
ATOM   1451  HA3 GLY A  90      -6.497 -16.508  -1.805  1.00 39.40           H  
ATOM   1452  N   ARG A  91      -5.849 -14.072  -1.695  1.00 70.54           N  
ATOM   1453  CA  ARG A  91      -5.694 -12.616  -1.594  1.00 23.44           C  
ATOM   1454  C   ARG A  91      -4.437 -12.128  -2.339  1.00  4.33           C  
ATOM   1455  O   ARG A  91      -3.324 -12.193  -1.815  1.00 72.40           O  
ATOM   1456  CB  ARG A  91      -5.640 -12.191  -0.117  1.00 64.15           C  
ATOM   1457  CG  ARG A  91      -6.943 -12.440   0.639  1.00 30.03           C  
ATOM   1458  CD  ARG A  91      -6.807 -12.138   2.131  1.00 53.25           C  
ATOM   1459  NE  ARG A  91      -8.079 -12.286   2.840  1.00 43.24           N  
ATOM   1460  CZ  ARG A  91      -8.213 -12.861   4.007  1.00 73.34           C  
ATOM   1461  NH1 ARG A  91      -7.203 -13.427   4.588  1.00 75.13           N  
ATOM   1462  NH2 ARG A  91      -9.371 -12.891   4.574  1.00 12.35           N  
ATOM   1463  H   ARG A  91      -5.689 -14.625  -0.902  1.00 39.40           H  
ATOM   1464  HA  ARG A  91      -6.564 -12.162  -2.051  1.00 35.15           H  
ATOM   1465  HB2 ARG A  91      -4.850 -12.744   0.374  1.00 39.40           H  
ATOM   1466  HB3 ARG A  91      -5.413 -11.135  -0.065  1.00 39.40           H  
ATOM   1467  HG2 ARG A  91      -7.715 -11.810   0.226  1.00 39.40           H  
ATOM   1468  HG3 ARG A  91      -7.223 -13.478   0.518  1.00 39.40           H  
ATOM   1469  HD2 ARG A  91      -6.084 -12.819   2.559  1.00 39.40           H  
ATOM   1470  HD3 ARG A  91      -6.456 -11.123   2.250  1.00 39.40           H  
ATOM   1471  HE  ARG A  91      -8.878 -11.907   2.419  1.00 62.32           H  
ATOM   1472 HH11 ARG A  91      -6.307 -13.429   4.148  1.00 39.40           H  
ATOM   1473 HH12 ARG A  91      -7.322 -13.866   5.478  1.00 39.40           H  
ATOM   1474 HH21 ARG A  91     -10.157 -12.474   4.120  1.00 39.40           H  
ATOM   1475 HH22 ARG A  91      -9.477 -13.320   5.470  1.00 39.40           H  
ATOM   1476  N   LYS A  92      -4.625 -11.660  -3.576  1.00 75.32           N  
ATOM   1477  CA  LYS A  92      -3.525 -11.135  -4.395  1.00 53.20           C  
ATOM   1478  C   LYS A  92      -3.048  -9.756  -3.904  1.00 72.12           C  
ATOM   1479  O   LYS A  92      -3.494  -9.252  -2.872  1.00 43.21           O  
ATOM   1480  CB  LYS A  92      -3.949 -11.041  -5.870  1.00 35.51           C  
ATOM   1481  CG  LYS A  92      -4.161 -12.397  -6.547  1.00 34.23           C  
ATOM   1482  CD  LYS A  92      -4.309 -12.251  -8.063  1.00 72.44           C  
ATOM   1483  CE  LYS A  92      -5.632 -11.602  -8.462  1.00 20.02           C  
ATOM   1484  NZ  LYS A  92      -6.758 -12.575  -8.463  1.00 43.32           N  
ATOM   1485  H   LYS A  92      -5.525 -11.676  -3.949  1.00 39.40           H  
ATOM   1486  HA  LYS A  92      -2.699 -11.829  -4.317  1.00 12.10           H  
ATOM   1487  HB2 LYS A  92      -4.874 -10.483  -5.930  1.00 39.40           H  
ATOM   1488  HB3 LYS A  92      -3.184 -10.507  -6.416  1.00 39.40           H  
ATOM   1489  HG2 LYS A  92      -3.309 -13.029  -6.340  1.00 39.40           H  
ATOM   1490  HG3 LYS A  92      -5.055 -12.856  -6.148  1.00 39.40           H  
ATOM   1491  HD2 LYS A  92      -3.499 -11.641  -8.436  1.00 39.40           H  
ATOM   1492  HD3 LYS A  92      -4.252 -13.233  -8.515  1.00 39.40           H  
ATOM   1493  HE2 LYS A  92      -5.858 -10.808  -7.763  1.00 39.40           H  
ATOM   1494  HE3 LYS A  92      -5.529 -11.186  -9.453  1.00 39.40           H  
ATOM   1495  HZ1 LYS A  92      -6.812 -13.060  -7.547  1.00 39.40           H  
ATOM   1496  HZ2 LYS A  92      -6.615 -13.288  -9.211  1.00 39.40           H  
ATOM   1497  HZ3 LYS A  92      -7.656 -12.086  -8.638  1.00 39.40           H  
ATOM   1498  N   GLU A  93      -2.155  -9.136  -4.674  1.00 31.25           N  
ATOM   1499  CA  GLU A  93      -1.551  -7.856  -4.290  1.00 60.14           C  
ATOM   1500  C   GLU A  93      -1.367  -6.939  -5.511  1.00 42.31           C  
ATOM   1501  O   GLU A  93      -1.122  -7.413  -6.624  1.00 15.44           O  
ATOM   1502  CB  GLU A  93      -0.199  -8.109  -3.608  1.00  3.34           C  
ATOM   1503  CG  GLU A  93       0.827  -8.760  -4.527  1.00 12.22           C  
ATOM   1504  CD  GLU A  93       2.079  -9.222  -3.802  1.00 71.33           C  
ATOM   1505  OE1 GLU A  93       2.954  -8.380  -3.510  1.00  1.12           O  
ATOM   1506  OE2 GLU A  93       2.202 -10.436  -3.546  1.00 43.44           O  
ATOM   1507  H   GLU A  93      -1.904  -9.538  -5.529  1.00 39.40           H  
ATOM   1508  HA  GLU A  93      -2.214  -7.370  -3.586  1.00 62.32           H  
ATOM   1509  HB2 GLU A  93       0.203  -7.166  -3.261  1.00 39.40           H  
ATOM   1510  HB3 GLU A  93      -0.352  -8.758  -2.757  1.00 39.40           H  
ATOM   1511  HG2 GLU A  93       0.369  -9.616  -5.003  1.00 39.40           H  
ATOM   1512  HG3 GLU A  93       1.113  -8.044  -5.287  1.00 39.40           H  
ATOM   1513  N   ALA A  94      -1.488  -5.632  -5.296  1.00 53.24           N  
ATOM   1514  CA  ALA A  94      -1.346  -4.641  -6.367  1.00 62.43           C  
ATOM   1515  C   ALA A  94      -0.264  -3.607  -6.028  1.00 43.15           C  
ATOM   1516  O   ALA A  94      -0.378  -2.880  -5.044  1.00 42.51           O  
ATOM   1517  CB  ALA A  94      -2.680  -3.946  -6.611  1.00 50.52           C  
ATOM   1518  H   ALA A  94      -1.677  -5.319  -4.386  1.00 39.40           H  
ATOM   1519  HA  ALA A  94      -1.065  -5.160  -7.276  1.00  1.03           H  
ATOM   1520  HB1 ALA A  94      -3.441  -4.686  -6.811  1.00 39.40           H  
ATOM   1521  HB2 ALA A  94      -2.592  -3.281  -7.458  1.00 39.40           H  
ATOM   1522  HB3 ALA A  94      -2.956  -3.376  -5.735  1.00 39.40           H  
ATOM   1523  N   HIS A  95       0.782  -3.539  -6.847  1.00 73.20           N  
ATOM   1524  CA  HIS A  95       1.895  -2.610  -6.609  1.00 54.24           C  
ATOM   1525  C   HIS A  95       1.690  -1.273  -7.337  1.00 32.31           C  
ATOM   1526  O   HIS A  95       1.474  -1.235  -8.552  1.00  4.45           O  
ATOM   1527  CB  HIS A  95       3.219  -3.254  -7.039  1.00 31.22           C  
ATOM   1528  CG  HIS A  95       3.705  -4.305  -6.086  1.00 60.11           C  
ATOM   1529  ND1 HIS A  95       4.923  -4.197  -5.464  1.00 50.03           N  
ATOM   1530  CD2 HIS A  95       3.098  -5.441  -5.669  1.00 31.02           C  
ATOM   1531  CE1 HIS A  95       5.031  -5.263  -4.691  1.00 61.31           C  
ATOM   1532  NE2 HIS A  95       3.951  -6.044  -4.784  1.00 23.45           N  
ATOM   1533  H   HIS A  95       0.810  -4.127  -7.631  1.00 39.40           H  
ATOM   1534  HA  HIS A  95       1.937  -2.415  -5.544  1.00 25.02           H  
ATOM   1535  HB2 HIS A  95       3.090  -3.720  -8.007  1.00 39.40           H  
ATOM   1536  HB3 HIS A  95       3.981  -2.490  -7.113  1.00 39.40           H  
ATOM   1537  HD2 HIS A  95       2.129  -5.806  -5.976  1.00 12.22           H  
ATOM   1538  HE1 HIS A  95       5.883  -5.475  -4.063  1.00 24.31           H  
ATOM   1539  HE2 HIS A  95       3.707  -6.754  -4.154  1.00 23.44           H  
ATOM   1540  N   LEU A  96       1.772  -0.181  -6.578  1.00 32.45           N  
ATOM   1541  CA  LEU A  96       1.546   1.170  -7.107  1.00 64.31           C  
ATOM   1542  C   LEU A  96       2.811   1.764  -7.747  1.00 70.12           C  
ATOM   1543  O   LEU A  96       3.930   1.303  -7.512  1.00 73.21           O  
ATOM   1544  CB  LEU A  96       1.050   2.103  -5.990  1.00 50.30           C  
ATOM   1545  CG  LEU A  96      -0.438   1.978  -5.619  1.00  3.31           C  
ATOM   1546  CD1 LEU A  96      -0.745   0.621  -4.987  1.00 12.11           C  
ATOM   1547  CD2 LEU A  96      -0.851   3.118  -4.689  1.00 75.10           C  
ATOM   1548  H   LEU A  96       1.990  -0.283  -5.629  1.00 39.40           H  
ATOM   1549  HA  LEU A  96       0.779   1.102  -7.867  1.00 12.51           H  
ATOM   1550  HB2 LEU A  96       1.637   1.908  -5.102  1.00 39.40           H  
ATOM   1551  HB3 LEU A  96       1.233   3.123  -6.298  1.00 39.40           H  
ATOM   1552  HG  LEU A  96      -1.029   2.059  -6.520  1.00 33.53           H  
ATOM   1553 HD11 LEU A  96      -1.801   0.557  -4.765  1.00 39.40           H  
ATOM   1554 HD12 LEU A  96      -0.178   0.509  -4.074  1.00 39.40           H  
ATOM   1555 HD13 LEU A  96      -0.477  -0.167  -5.675  1.00 39.40           H  
ATOM   1556 HD21 LEU A  96      -0.269   3.073  -3.780  1.00 39.40           H  
ATOM   1557 HD22 LEU A  96      -1.900   3.026  -4.450  1.00 39.40           H  
ATOM   1558 HD23 LEU A  96      -0.678   4.063  -5.181  1.00 39.40           H  
ATOM   1559  N   MET A  97       2.615   2.806  -8.552  1.00  4.01           N  
ATOM   1560  CA  MET A  97       3.708   3.486  -9.257  1.00  1.44           C  
ATOM   1561  C   MET A  97       3.766   4.973  -8.864  1.00 15.32           C  
ATOM   1562  O   MET A  97       2.793   5.515  -8.345  1.00 63.13           O  
ATOM   1563  CB  MET A  97       3.486   3.363 -10.768  1.00 43.24           C  
ATOM   1564  CG  MET A  97       3.187   1.945 -11.221  1.00 44.30           C  
ATOM   1565  SD  MET A  97       2.781   1.848 -12.972  1.00 53.11           S  
ATOM   1566  CE  MET A  97       2.053   0.215 -13.040  1.00  1.34           C  
ATOM   1567  H   MET A  97       1.699   3.132  -8.682  1.00 39.40           H  
ATOM   1568  HA  MET A  97       4.641   3.008  -8.989  1.00 42.02           H  
ATOM   1569  HB2 MET A  97       2.654   3.992 -11.052  1.00 39.40           H  
ATOM   1570  HB3 MET A  97       4.375   3.704 -11.282  1.00 39.40           H  
ATOM   1571  HG2 MET A  97       4.057   1.329 -11.036  1.00 39.40           H  
ATOM   1572  HG3 MET A  97       2.352   1.567 -10.651  1.00 39.40           H  
ATOM   1573  HE1 MET A  97       1.727   0.008 -14.048  1.00 39.40           H  
ATOM   1574  HE2 MET A  97       1.206   0.170 -12.370  1.00 39.40           H  
ATOM   1575  HE3 MET A  97       2.787  -0.520 -12.740  1.00 39.40           H  
ATOM   1576  N   PRO A  98       4.897   5.664  -9.117  1.00 50.34           N  
ATOM   1577  CA  PRO A  98       5.032   7.100  -8.805  1.00 31.22           C  
ATOM   1578  C   PRO A  98       3.839   7.955  -9.282  1.00 44.13           C  
ATOM   1579  O   PRO A  98       3.386   8.856  -8.574  1.00 61.42           O  
ATOM   1580  CB  PRO A  98       6.316   7.490  -9.550  1.00 74.01           C  
ATOM   1581  CG  PRO A  98       7.129   6.240  -9.568  1.00 40.21           C  
ATOM   1582  CD  PRO A  98       6.142   5.107  -9.692  1.00 51.02           C  
ATOM   1583  HA  PRO A  98       5.174   7.253  -7.744  1.00  3.22           H  
ATOM   1584  HB2 PRO A  98       6.076   7.822 -10.552  1.00 39.40           H  
ATOM   1585  HB3 PRO A  98       6.823   8.282  -9.016  1.00 39.40           H  
ATOM   1586  HG2 PRO A  98       7.800   6.251 -10.416  1.00 39.40           H  
ATOM   1587  HG3 PRO A  98       7.689   6.153  -8.648  1.00 39.40           H  
ATOM   1588  HD2 PRO A  98       6.002   4.839 -10.730  1.00 39.40           H  
ATOM   1589  HD3 PRO A  98       6.478   4.249  -9.124  1.00 39.40           H  
ATOM   1590  N   ARG A  99       3.317   7.647 -10.472  1.00 52.14           N  
ATOM   1591  CA  ARG A  99       2.223   8.430 -11.073  1.00 31.22           C  
ATOM   1592  C   ARG A  99       0.826   7.935 -10.636  1.00 73.22           C  
ATOM   1593  O   ARG A  99      -0.195   8.473 -11.078  1.00 12.10           O  
ATOM   1594  CB  ARG A  99       2.330   8.384 -12.605  1.00 74.33           C  
ATOM   1595  CG  ARG A  99       3.618   8.992 -13.157  1.00 52.12           C  
ATOM   1596  CD  ARG A  99       3.597   9.082 -14.682  1.00 22.52           C  
ATOM   1597  NE  ARG A  99       3.528   7.765 -15.317  1.00 52.44           N  
ATOM   1598  CZ  ARG A  99       2.678   7.446 -16.259  1.00 64.30           C  
ATOM   1599  NH1 ARG A  99       1.743   8.265 -16.619  1.00 32.01           N  
ATOM   1600  NH2 ARG A  99       2.739   6.287 -16.827  1.00 63.23           N  
ATOM   1601  H   ARG A  99       3.669   6.874 -10.956  1.00 39.40           H  
ATOM   1602  HA  ARG A  99       2.338   9.455 -10.751  1.00  3.23           H  
ATOM   1603  HB2 ARG A  99       2.281   7.353 -12.925  1.00 39.40           H  
ATOM   1604  HB3 ARG A  99       1.492   8.922 -13.028  1.00 39.40           H  
ATOM   1605  HG2 ARG A  99       3.742   9.985 -12.751  1.00 39.40           H  
ATOM   1606  HG3 ARG A  99       4.453   8.374 -12.857  1.00 39.40           H  
ATOM   1607  HD2 ARG A  99       2.741   9.668 -14.985  1.00 39.40           H  
ATOM   1608  HD3 ARG A  99       4.501   9.579 -15.009  1.00 39.40           H  
ATOM   1609  HE  ARG A  99       4.181   7.095 -15.041  1.00 34.22           H  
ATOM   1610 HH11 ARG A  99       1.658   9.155 -16.177  1.00 39.40           H  
ATOM   1611 HH12 ARG A  99       1.106   7.997 -17.337  1.00 39.40           H  
ATOM   1612 HH21 ARG A  99       3.436   5.628 -16.556  1.00 39.40           H  
ATOM   1613 HH22 ARG A  99       2.082   6.054 -17.542  1.00 39.40           H  
ATOM   1614  N   SER A 100       0.781   6.922  -9.774  1.00  3.44           N  
ATOM   1615  CA  SER A 100      -0.495   6.345  -9.318  1.00 41.35           C  
ATOM   1616  C   SER A 100      -1.178   7.240  -8.274  1.00  4.22           C  
ATOM   1617  O   SER A 100      -0.582   7.578  -7.248  1.00 33.45           O  
ATOM   1618  CB  SER A 100      -0.273   4.950  -8.717  1.00 10.42           C  
ATOM   1619  OG  SER A 100       0.428   4.109  -9.616  1.00 32.41           O  
ATOM   1620  H   SER A 100       1.619   6.551  -9.435  1.00 39.40           H  
ATOM   1621  HA  SER A 100      -1.146   6.254 -10.179  1.00  3.34           H  
ATOM   1622  HB2 SER A 100       0.301   5.035  -7.806  1.00 39.40           H  
ATOM   1623  HB3 SER A 100      -1.229   4.497  -8.496  1.00 39.40           H  
ATOM   1624  HG  SER A 100      -0.201   3.684 -10.213  1.00 74.34           H  
ATOM   1625  N   THR A 101      -2.426   7.617  -8.541  1.00 32.30           N  
ATOM   1626  CA  THR A 101      -3.216   8.428  -7.601  1.00 24.42           C  
ATOM   1627  C   THR A 101      -4.354   7.608  -6.978  1.00 12.05           C  
ATOM   1628  O   THR A 101      -4.784   6.596  -7.536  1.00 42.11           O  
ATOM   1629  CB  THR A 101      -3.833   9.670  -8.291  1.00 20.51           C  
ATOM   1630  OG1 THR A 101      -4.791   9.265  -9.284  1.00 34.11           O  
ATOM   1631  CG2 THR A 101      -2.754  10.531  -8.943  1.00 75.11           C  
ATOM   1632  H   THR A 101      -2.831   7.351  -9.394  1.00 39.40           H  
ATOM   1633  HA  THR A 101      -2.557   8.768  -6.812  1.00 10.21           H  
ATOM   1634  HB  THR A 101      -4.341  10.264  -7.541  1.00 73.15           H  
ATOM   1635  HG1 THR A 101      -5.653   9.130  -8.867  1.00 61.12           H  
ATOM   1636 HG21 THR A 101      -2.066  10.881  -8.187  1.00 39.40           H  
ATOM   1637 HG22 THR A 101      -3.214  11.379  -9.431  1.00 39.40           H  
ATOM   1638 HG23 THR A 101      -2.216   9.945  -9.676  1.00 39.40           H  
ATOM   1639  N   VAL A 102      -4.839   8.053  -5.818  1.00 35.04           N  
ATOM   1640  CA  VAL A 102      -5.965   7.397  -5.135  1.00 24.42           C  
ATOM   1641  C   VAL A 102      -7.109   8.391  -4.871  1.00 21.41           C  
ATOM   1642  O   VAL A 102      -6.873   9.545  -4.511  1.00 65.24           O  
ATOM   1643  CB  VAL A 102      -5.521   6.751  -3.792  1.00  3.12           C  
ATOM   1644  CG1 VAL A 102      -4.471   5.667  -4.032  1.00 11.32           C  
ATOM   1645  CG2 VAL A 102      -4.994   7.807  -2.821  1.00 64.20           C  
ATOM   1646  H   VAL A 102      -4.432   8.843  -5.407  1.00 39.40           H  
ATOM   1647  HA  VAL A 102      -6.335   6.610  -5.782  1.00 21.04           H  
ATOM   1648  HB  VAL A 102      -6.386   6.282  -3.341  1.00 35.34           H  
ATOM   1649 HG11 VAL A 102      -4.892   4.888  -4.651  1.00 39.40           H  
ATOM   1650 HG12 VAL A 102      -4.163   5.246  -3.086  1.00 39.40           H  
ATOM   1651 HG13 VAL A 102      -3.612   6.098  -4.530  1.00 39.40           H  
ATOM   1652 HG21 VAL A 102      -5.774   8.523  -2.605  1.00 39.40           H  
ATOM   1653 HG22 VAL A 102      -4.150   8.318  -3.263  1.00 39.40           H  
ATOM   1654 HG23 VAL A 102      -4.682   7.331  -1.902  1.00 39.40           H  
ATOM   1655  N   GLU A 103      -8.346   7.942  -5.058  1.00 65.22           N  
ATOM   1656  CA  GLU A 103      -9.528   8.790  -4.833  1.00 43.02           C  
ATOM   1657  C   GLU A 103     -10.533   8.110  -3.889  1.00 61.52           C  
ATOM   1658  O   GLU A 103     -10.727   6.896  -3.948  1.00  1.44           O  
ATOM   1659  CB  GLU A 103     -10.196   9.123  -6.176  1.00  3.31           C  
ATOM   1660  CG  GLU A 103     -10.526   7.899  -7.024  1.00 35.55           C  
ATOM   1661  CD  GLU A 103     -11.140   8.258  -8.368  1.00 22.11           C  
ATOM   1662  OE1 GLU A 103     -10.389   8.670  -9.280  1.00 21.24           O  
ATOM   1663  OE2 GLU A 103     -12.373   8.127  -8.520  1.00 55.45           O  
ATOM   1664  H   GLU A 103      -8.473   7.019  -5.362  1.00 39.40           H  
ATOM   1665  HA  GLU A 103      -9.194   9.710  -4.373  1.00 72.12           H  
ATOM   1666  HB2 GLU A 103     -11.115   9.660  -5.983  1.00 39.40           H  
ATOM   1667  HB3 GLU A 103      -9.533   9.760  -6.744  1.00 39.40           H  
ATOM   1668  HG2 GLU A 103      -9.616   7.345  -7.200  1.00 39.40           H  
ATOM   1669  HG3 GLU A 103     -11.223   7.276  -6.478  1.00 39.40           H  
ATOM   1670  N   VAL A 104     -11.170   8.900  -3.021  1.00 61.12           N  
ATOM   1671  CA  VAL A 104     -12.129   8.371  -2.036  1.00 64.33           C  
ATOM   1672  C   VAL A 104     -13.555   8.268  -2.618  1.00 21.32           C  
ATOM   1673  O   VAL A 104     -14.165   9.269  -2.998  1.00  3.31           O  
ATOM   1674  CB  VAL A 104     -12.141   9.227  -0.738  1.00 25.23           C  
ATOM   1675  CG1 VAL A 104     -10.808   9.102   0.004  1.00 41.20           C  
ATOM   1676  CG2 VAL A 104     -12.445  10.696  -1.044  1.00 30.23           C  
ATOM   1677  H   VAL A 104     -11.002   9.866  -3.046  1.00 39.40           H  
ATOM   1678  HA  VAL A 104     -11.801   7.372  -1.770  1.00 53.53           H  
ATOM   1679  HB  VAL A 104     -12.920   8.849  -0.088  1.00 21.52           H  
ATOM   1680 HG11 VAL A 104     -10.647   8.071   0.285  1.00 39.40           H  
ATOM   1681 HG12 VAL A 104     -10.827   9.717   0.892  1.00 39.40           H  
ATOM   1682 HG13 VAL A 104     -10.003   9.427  -0.640  1.00 39.40           H  
ATOM   1683 HG21 VAL A 104     -13.419  10.775  -1.506  1.00 39.40           H  
ATOM   1684 HG22 VAL A 104     -11.695  11.090  -1.716  1.00 39.40           H  
ATOM   1685 HG23 VAL A 104     -12.438  11.265  -0.124  1.00 39.40           H  
ATOM   1686  N   LEU A 105     -14.084   7.045  -2.672  1.00 55.40           N  
ATOM   1687  CA  LEU A 105     -15.388   6.783  -3.295  1.00 20.44           C  
ATOM   1688  C   LEU A 105     -16.468   6.369  -2.273  1.00 41.41           C  
ATOM   1689  O   LEU A 105     -16.293   6.543  -1.067  1.00 71.10           O  
ATOM   1690  CB  LEU A 105     -15.237   5.704  -4.377  1.00 65.30           C  
ATOM   1691  CG  LEU A 105     -14.291   6.062  -5.536  1.00 30.01           C  
ATOM   1692  CD1 LEU A 105     -14.308   4.967  -6.596  1.00 44.32           C  
ATOM   1693  CD2 LEU A 105     -14.661   7.416  -6.146  1.00 43.13           C  
ATOM   1694  H   LEU A 105     -13.585   6.299  -2.286  1.00 39.40           H  
ATOM   1695  HA  LEU A 105     -15.713   7.698  -3.770  1.00 53.20           H  
ATOM   1696  HB2 LEU A 105     -14.868   4.803  -3.906  1.00 39.40           H  
ATOM   1697  HB3 LEU A 105     -16.214   5.497  -4.791  1.00 39.40           H  
ATOM   1698  HG  LEU A 105     -13.281   6.133  -5.156  1.00 74.23           H  
ATOM   1699 HD11 LEU A 105     -15.310   4.855  -6.988  1.00 39.40           H  
ATOM   1700 HD12 LEU A 105     -13.989   4.035  -6.152  1.00 39.40           H  
ATOM   1701 HD13 LEU A 105     -13.635   5.231  -7.400  1.00 39.40           H  
ATOM   1702 HD21 LEU A 105     -15.673   7.381  -6.522  1.00 39.40           H  
ATOM   1703 HD22 LEU A 105     -13.983   7.644  -6.956  1.00 39.40           H  
ATOM   1704 HD23 LEU A 105     -14.585   8.183  -5.389  1.00 39.40           H  
ATOM   1705  N   ASP A 106     -17.564   5.795  -2.799  1.00 75.33           N  
ATOM   1706  CA  ASP A 106     -18.830   5.545  -2.079  1.00 23.42           C  
ATOM   1707  C   ASP A 106     -19.746   6.796  -2.170  1.00 22.11           C  
ATOM   1708  O   ASP A 106     -20.798   6.726  -2.809  1.00 42.22           O  
ATOM   1709  CB  ASP A 106     -18.629   5.028  -0.644  1.00 23.04           C  
ATOM   1710  CG  ASP A 106     -19.907   4.445  -0.061  1.00 52.02           C  
ATOM   1711  OD1 ASP A 106     -20.239   3.282  -0.390  1.00 63.11           O  
ATOM   1712  OD2 ASP A 106     -20.590   5.140   0.721  1.00 31.41           O  
ATOM   1713  H   ASP A 106     -17.522   5.512  -3.737  1.00 39.40           H  
ATOM   1714  HA  ASP A 106     -19.327   4.762  -2.641  1.00 71.34           H  
ATOM   1715  HB2 ASP A 106     -17.871   4.257  -0.649  1.00 39.40           H  
ATOM   1716  HB3 ASP A 106     -18.299   5.838  -0.011  1.00 39.40           H  
ATOM   1717  N   PRO A 107     -19.395   7.963  -1.559  1.00 11.54           N  
ATOM   1718  CA  PRO A 107     -19.912   9.249  -2.033  1.00 60.30           C  
ATOM   1719  C   PRO A 107     -19.122   9.688  -3.277  1.00 54.53           C  
ATOM   1720  O   PRO A 107     -18.120  10.404  -3.174  1.00 11.30           O  
ATOM   1721  CB  PRO A 107     -19.685  10.219  -0.851  1.00 54.42           C  
ATOM   1722  CG  PRO A 107     -19.194   9.368   0.278  1.00 24.20           C  
ATOM   1723  CD  PRO A 107     -18.577   8.147  -0.351  1.00  3.53           C  
ATOM   1724  HA  PRO A 107     -20.967   9.192  -2.274  1.00  3.21           H  
ATOM   1725  HB2 PRO A 107     -18.954  10.967  -1.124  1.00 39.40           H  
ATOM   1726  HB3 PRO A 107     -20.618  10.704  -0.598  1.00 39.40           H  
ATOM   1727  HG2 PRO A 107     -18.455   9.908   0.854  1.00 39.40           H  
ATOM   1728  HG3 PRO A 107     -20.025   9.084   0.910  1.00 39.40           H  
ATOM   1729  HD2 PRO A 107     -17.541   8.332  -0.607  1.00 39.40           H  
ATOM   1730  HD3 PRO A 107     -18.660   7.298   0.310  1.00 39.40           H  
ATOM   1731  N   LEU A 108     -19.550   9.201  -4.445  1.00 55.01           N  
ATOM   1732  CA  LEU A 108     -18.786   9.349  -5.694  1.00 71.51           C  
ATOM   1733  C   LEU A 108     -18.411  10.817  -5.969  1.00 23.04           C  
ATOM   1734  O   LEU A 108     -19.273  11.698  -5.995  1.00 61.12           O  
ATOM   1735  CB  LEU A 108     -19.594   8.768  -6.874  1.00 73.31           C  
ATOM   1736  CG  LEU A 108     -18.775   8.033  -7.958  1.00 55.14           C  
ATOM   1737  CD1 LEU A 108     -17.717   8.943  -8.579  1.00 64.15           C  
ATOM   1738  CD2 LEU A 108     -18.131   6.773  -7.383  1.00  4.24           C  
ATOM   1739  H   LEU A 108     -20.411   8.725  -4.470  1.00 39.40           H  
ATOM   1740  HA  LEU A 108     -17.875   8.777  -5.582  1.00  4.12           H  
ATOM   1741  HB2 LEU A 108     -20.320   8.073  -6.476  1.00 39.40           H  
ATOM   1742  HB3 LEU A 108     -20.131   9.579  -7.350  1.00 39.40           H  
ATOM   1743  HG  LEU A 108     -19.445   7.727  -8.750  1.00  4.42           H  
ATOM   1744 HD11 LEU A 108     -17.020   9.264  -7.819  1.00 39.40           H  
ATOM   1745 HD12 LEU A 108     -18.196   9.807  -9.015  1.00 39.40           H  
ATOM   1746 HD13 LEU A 108     -17.185   8.404  -9.350  1.00 39.40           H  
ATOM   1747 HD21 LEU A 108     -17.468   7.039  -6.572  1.00 39.40           H  
ATOM   1748 HD22 LEU A 108     -17.567   6.271  -8.157  1.00 39.40           H  
ATOM   1749 HD23 LEU A 108     -18.900   6.110  -7.015  1.00 39.40           H  
ATOM   1750  N   GLU A 109     -17.119  11.069  -6.176  1.00 25.35           N  
ATOM   1751  CA  GLU A 109     -16.627  12.426  -6.429  1.00 43.22           C  
ATOM   1752  C   GLU A 109     -16.963  12.889  -7.855  1.00 75.11           C  
ATOM   1753  O   GLU A 109     -17.697  13.861  -8.043  1.00  4.12           O  
ATOM   1754  CB  GLU A 109     -15.110  12.508  -6.193  1.00 63.41           C  
ATOM   1755  CG  GLU A 109     -14.675  12.063  -4.802  1.00 44.54           C  
ATOM   1756  CD  GLU A 109     -13.223  12.407  -4.504  1.00 73.34           C  
ATOM   1757  OE1 GLU A 109     -12.320  11.682  -4.971  1.00 13.30           O  
ATOM   1758  OE2 GLU A 109     -12.978  13.412  -3.803  1.00 65.33           O  
ATOM   1759  H   GLU A 109     -16.481  10.327  -6.152  1.00 39.40           H  
ATOM   1760  HA  GLU A 109     -17.122  13.088  -5.730  1.00 74.32           H  
ATOM   1761  HB2 GLU A 109     -14.610  11.882  -6.921  1.00 39.40           H  
ATOM   1762  HB3 GLU A 109     -14.791  13.532  -6.339  1.00 39.40           H  
ATOM   1763  HG2 GLU A 109     -15.303  12.550  -4.069  1.00 39.40           H  
ATOM   1764  HG3 GLU A 109     -14.801  10.992  -4.724  1.00 39.40           H  
ATOM   1765  N   HIS A 110     -16.423  12.195  -8.860  1.00 73.33           N  
ATOM   1766  CA  HIS A 110     -16.654  12.558 -10.272  1.00 34.43           C  
ATOM   1767  C   HIS A 110     -17.603  11.567 -10.980  1.00 34.53           C  
ATOM   1768  O   HIS A 110     -18.821  11.840 -11.041  1.00 39.40           O  
ATOM   1769  CB  HIS A 110     -15.316  12.650 -11.021  1.00 50.43           C  
ATOM   1770  CG  HIS A 110     -14.447  13.776 -10.551  1.00 34.14           C  
ATOM   1771  ND1 HIS A 110     -14.072  14.829 -11.352  1.00 74.02           N  
ATOM   1772  CD2 HIS A 110     -13.885  14.012  -9.343  1.00 54.42           C  
ATOM   1773  CE1 HIS A 110     -13.317  15.660 -10.664  1.00  3.22           C  
ATOM   1774  NE2 HIS A 110     -13.189  15.190  -9.441  1.00 63.40           N  
ATOM   1775  H   HIS A 110     -15.863  11.414  -8.653  1.00 39.40           H  
ATOM   1776  HA  HIS A 110     -17.115  13.537 -10.279  1.00 74.30           H  
ATOM   1777  HB2 HIS A 110     -14.768  11.728 -10.884  1.00 39.40           H  
ATOM   1778  HB3 HIS A 110     -15.509  12.795 -12.075  1.00 39.40           H  
ATOM   1779  HD1 HIS A 110     -14.315  14.944 -12.296  1.00 71.14           H  
ATOM   1780  HD2 HIS A 110     -13.985  13.396  -8.462  1.00 73.34           H  
ATOM   1781  HE1 HIS A 110     -12.879  16.573 -11.037  1.00 15.41           H  
ATOM   1782  HE2 HIS A 110     -12.566  15.538  -8.768  1.00 39.40           H  
TER    1783      HIS A 110                                                      
END
MOLECULE T0466.pdb
ATOM    281  N   LEU    19     -13.966  -0.653  -3.614  1.00 72.33           N 
ATOM    282  CA  LEU    19     -12.695  -0.631  -2.891  1.00 64.15           C 
ATOM    283  C   LEU    19     -12.829   0.243  -1.646  1.00 23.21           C 
ATOM    284  O   LEU    19     -12.938   1.465  -1.741  1.00 12.11           O 
ATOM    285  CB  LEU    19     -11.563  -0.105  -3.789  1.00 13.41           C 
ATOM    286  CG  LEU    19     -11.234  -0.974  -5.016  1.00 70.21           C 
ATOM    287  CD1 LEU    19     -10.125  -0.332  -5.850  1.00 43.44           C 
ATOM    288  CD2 LEU    19     -10.838  -2.387  -4.583  1.00 45.32           C 
ATOM    289  H   LEU    19     -14.169   0.069  -4.245  1.00 38.03           H 
ATOM    290  HA  LEU    19     -12.462  -1.643  -2.586  1.00 55.11           H 
ATOM    291 1HB  LEU    19     -10.669  -0.016  -3.189  1.00 45.32           H 
ATOM    292 2HB  LEU    19     -11.840   0.881  -4.136  1.00  2.50           H 
ATOM    293  HG  LEU    19     -12.112  -1.049  -5.641  1.00 41.50           H 
ATOM    294 1HD1 LEU    19     -10.444   0.645  -6.180  1.00 43.04           H 
ATOM    295 2HD1 LEU    19      -9.917  -0.951  -6.711  1.00 44.24           H 
ATOM    296 3HD1 LEU    19      -9.230  -0.236  -5.251  1.00 60.31           H 
ATOM    297 1HD2 LEU    19     -11.659  -2.843  -4.052  1.00 71.13           H 
ATOM    298 2HD2 LEU    19      -9.973  -2.341  -3.937  1.00 40.24           H 
ATOM    299 3HD2 LEU    19     -10.602  -2.978  -5.457  1.00 72.51           H 
ATOM    300  N   LYS    20     -12.840  -0.387  -0.479  1.00 73.43           N 
ATOM    301  CA  LYS    20     -13.053   0.332   0.778  1.00 62.04           C 
ATOM    302  C   LYS    20     -11.909   0.088   1.772  1.00 13.12           C 
ATOM    303  O   LYS    20     -11.455  -1.045   1.961  1.00 65.12           O 
ATOM    304  CB  LYS    20     -14.419  -0.052   1.370  1.00 73.41           C 
ATOM    305  CG  LYS    20     -15.591   0.446   0.520  1.00 44.14           C 
ATOM    306  CD  LYS    20     -16.956   0.146   1.139  1.00 11.00           C 
ATOM    307  CE  LYS    20     -17.277  -1.344   1.148  1.00  5.44           C 
ATOM    308  NZ  LYS    20     -18.661  -1.611   1.627  1.00 32.10           N 
ATOM    309  H   LYS    20     -12.705  -1.359  -0.461  1.00 38.03           H 
ATOM    310  HA  LYS    20     -13.069   1.391   0.545  1.00 11.12           H 
ATOM    311 1HB  LYS    20     -14.509   0.376   2.356  1.00 40.45           H 
ATOM    312 2HB  LYS    20     -14.479  -1.129   1.447  1.00 15.41           H 
ATOM    313 1HG  LYS    20     -15.537  -0.025  -0.454  1.00 12.12           H 
ATOM    314 2HG  LYS    20     -15.497   1.516   0.400  1.00 50.51           H 
ATOM    315 1HD  LYS    20     -17.716   0.663   0.569  1.00 30.51           H 
ATOM    316 2HD  LYS    20     -16.966   0.509   2.157  1.00 21.12           H 
ATOM    317 1HE  LYS    20     -16.577  -1.846   1.800  1.00 71.53           H 
ATOM    318 2HE  LYS    20     -17.175  -1.732   0.144  1.00 22.23           H 
ATOM    319 1HZ  LYS    20     -19.358  -1.233   0.948  1.00  4.11           H 
ATOM    320 2HZ  LYS    20     -18.816  -1.157   2.547  1.00 21.32           H 
ATOM    321 3HZ  LYS    20     -18.816  -2.632   1.732  1.00 52.21           H 
ATOM    322  N   PHE    21     -11.449   1.175   2.393  1.00 62.24           N 
ATOM    323  CA  PHE    21     -10.276   1.156   3.277  1.00 61.32           C 
ATOM    324  C   PHE    21     -10.481   0.285   4.531  1.00 12.31           C 
ATOM    325  O   PHE    21     -11.577   0.211   5.088  1.00 52.04           O 
ATOM    326  CB  PHE    21      -9.929   2.598   3.688  1.00 11.21           C 
ATOM    327  CG  PHE    21      -8.648   2.729   4.474  1.00  1.24           C 
ATOM    328  CD1 PHE    21      -7.419   2.684   3.831  1.00 42.11           C 
ATOM    329  CD2 PHE    21      -8.673   2.907   5.851  1.00 65.13           C 
ATOM    330  CE1 PHE    21      -6.242   2.812   4.543  1.00 44.33           C 
ATOM    331  CE2 PHE    21      -7.499   3.034   6.568  1.00 52.11           C 
ATOM    332  CZ  PHE    21      -6.282   2.987   5.914  1.00 73.53           C 
ATOM    333  H   PHE    21     -11.911   2.030   2.240  1.00 38.03           H 
ATOM    334  HA  PHE    21      -9.449   0.752   2.712  1.00 25.10           H 
ATOM    335 1HB  PHE    21     -10.732   2.995   4.294  1.00 34.51           H 
ATOM    336 2HB  PHE    21      -9.832   3.200   2.798  1.00 43.41           H 
ATOM    337  HD1 PHE    21      -7.387   2.548   2.760  1.00 14.33           H 
ATOM    338  HD2 PHE    21      -9.623   2.942   6.363  1.00 63.21           H 
ATOM    339  HE1 PHE    21      -5.294   2.773   4.030  1.00 51.24           H 
ATOM    340  HE2 PHE    21      -7.533   3.171   7.639  1.00  4.43           H 
ATOM    341  HZ  PHE    21      -5.364   3.087   6.474  1.00  4.10           H 
ATOM    342  N   SER    22      -9.411  -0.380   4.965  1.00 74.33           N 
ATOM    343  CA  SER    22      -9.423  -1.137   6.227  1.00 11.20           C 
ATOM    344  C   SER    22      -8.311  -0.665   7.171  1.00 14.10           C 
ATOM    345  O   SER    22      -8.586  -0.177   8.268  1.00 71.35           O 
ATOM    346  CB  SER    22      -9.277  -2.644   5.969  1.00  4.33           C 
ATOM    347  OG  SER    22     -10.410  -3.167   5.290  1.00 62.25           O 
ATOM    348  H   SER    22      -8.597  -0.380   4.417  1.00 38.03           H 
ATOM    349  HA  SER    22     -10.377  -0.961   6.709  1.00  1.01           H 
ATOM    350 1HB  SER    22      -9.168  -3.160   6.913  1.00 32.42           H 
ATOM    351 2HB  SER    22      -8.401  -2.821   5.363  1.00 13.22           H 
ATOM    352  HG  SER    22     -10.313  -4.126   5.207  1.00 10.03           H 
ATOM    353  N   ALA    23      -7.057  -0.820   6.746  1.00 13.40           N 
ATOM    354  CA  ALA    23      -5.906  -0.400   7.557  1.00 50.24           C 
ATOM    355  C   ALA    23      -4.646  -0.196   6.702  1.00 35.25           C 
ATOM    356  O   ALA    23      -4.667  -0.374   5.483  1.00 23.23           O 
ATOM    357  CB  ALA    23      -5.635  -1.429   8.651  1.00 33.12           C 
ATOM    358  H   ALA    23      -6.897  -1.225   5.867  1.00 38.03           H 
ATOM    359  HA  ALA    23      -6.160   0.539   8.034  1.00 70.41           H 
ATOM    360 1HB  ALA    23      -6.529  -1.578   9.239  1.00 50.23           H 
ATOM    361 2HB  ALA    23      -4.840  -1.075   9.291  1.00 75.13           H 
ATOM    362 3HB  ALA    23      -5.343  -2.365   8.199  1.00 74.43           H 
ATOM    363  N   LEU    24      -3.554   0.192   7.352  1.00 20.11           N 
ATOM    364  CA  LEU    24      -2.234   0.235   6.715  1.00 23.54           C 
ATOM    365  C   LEU    24      -1.416  -0.989   7.149  1.00 42.12           C 
ATOM    366  O   LEU    24      -0.880  -1.030   8.262  1.00 52.13           O 
ATOM    367  CB  LEU    24      -1.500   1.530   7.091  1.00  1.14           C 
ATOM    368  CG  LEU    24      -0.085   1.686   6.503  1.00 11.45           C 
ATOM    369  CD1 LEU    24      -0.125   1.785   4.978  1.00 32.44           C 
ATOM    370  CD2 LEU    24       0.613   2.900   7.108  1.00 63.32           C 
ATOM    371  H   LEU    24      -3.633   0.460   8.292  1.00 38.03           H 
ATOM    372  HA  LEU    24      -2.373   0.204   5.642  1.00 44.33           H 
ATOM    373 1HB  LEU    24      -1.425   1.574   8.169  1.00 41.40           H 
ATOM    374 2HB  LEU    24      -2.102   2.367   6.760  1.00  1.24           H 
ATOM    375  HG  LEU    24       0.495   0.812   6.757  1.00 72.14           H 
ATOM    376 1HD1 LEU    24      -0.719   2.638   4.685  1.00 64.44           H 
ATOM    377 2HD1 LEU    24      -0.561   0.885   4.567  1.00 65.13           H 
ATOM    378 3HD1 LEU    24       0.881   1.901   4.597  1.00  0.11           H 
ATOM    379 1HD2 LEU    24       0.064   3.797   6.860  1.00 44.42           H 
ATOM    380 2HD2 LEU    24       1.616   2.971   6.713  1.00 12.43           H 
ATOM    381 3HD2 LEU    24       0.659   2.790   8.182  1.00 73.44           H 
ATOM    382  N   ARG    25      -1.339  -1.990   6.279  1.00 42.05           N 
ATOM    383  CA  ARG    25      -0.709  -3.273   6.622  1.00 54.11           C 
ATOM    384  C   ARG    25       0.755  -3.104   7.055  1.00 43.24           C 
ATOM    385  O   ARG    25       1.128  -3.474   8.169  1.00  4.35           O 
ATOM    386  CB  ARG    25      -0.807  -4.243   5.433  1.00  3.12           C 
ATOM    387  CG  ARG    25      -0.213  -5.631   5.689  1.00 25.31           C 
ATOM    388  CD  ARG    25      -0.729  -6.258   6.985  1.00 11.22           C 
ATOM    389  NE  ARG    25      -2.158  -6.034   7.187  1.00 60.15           N 
ATOM    390  CZ  ARG    25      -2.832  -6.474   8.213  1.00 44.21           C 
ATOM    391  NH1 ARG    25      -2.299  -7.304   9.052  1.00 71.12           N 
ATOM    392  NH2 ARG    25      -4.058  -6.104   8.373  1.00  0.55           N 
ATOM    393  H   ARG    25      -1.713  -1.868   5.381  1.00 38.03           H 
ATOM    394  HA  ARG    25      -1.263  -3.691   7.453  1.00 35.01           H 
ATOM    395 1HB  ARG    25      -0.288  -3.806   4.589  1.00 54.14           H 
ATOM    396 2HB  ARG    25      -1.849  -4.366   5.170  1.00 72.51           H 
ATOM    397 1HG  ARG    25       0.864  -5.545   5.746  1.00  3.04           H 
ATOM    398 2HG  ARG    25      -0.474  -6.277   4.864  1.00 41.22           H 
ATOM    399 1HD  ARG    25      -0.185  -5.832   7.817  1.00 21.10           H 
ATOM    400 2HD  ARG    25      -0.548  -7.323   6.949  1.00 11.03           H 
ATOM    401  HE  ARG    25      -2.630  -5.469   6.537  1.00 73.15           H 
ATOM    402 1HH1 ARG    25      -1.360  -7.613   8.922  1.00 24.42           H 
ATOM    403 2HH1 ARG    25      -2.827  -7.625   9.834  1.00 14.31           H 
ATOM    404 1HH2 ARG    25      -4.475  -5.474   7.715  1.00 34.00           H 
ATOM    405 2HH2 ARG    25      -4.584  -6.431   9.156  1.00 31.21           H 
ATOM    406  N   ARG    26       1.576  -2.543   6.175  1.00 23.43           N 
ATOM    407  CA  ARG    26       2.999  -2.362   6.465  1.00 71.24           C 
ATOM    408  C   ARG    26       3.679  -1.465   5.428  1.00 73.33           C 
ATOM    409  O   ARG    26       3.462  -1.613   4.229  1.00 52.22           O 
ATOM    410  CB  ARG    26       3.706  -3.726   6.513  1.00 73.01           C 
ATOM    411  CG  ARG    26       5.213  -3.633   6.727  1.00 21.14           C 
ATOM    412  CD  ARG    26       5.863  -5.009   6.824  1.00 54.54           C 
ATOM    413  NE  ARG    26       7.309  -4.920   7.019  1.00 44.44           N 
ATOM    414  CZ  ARG    26       8.148  -5.886   6.760  1.00 30.43           C 
ATOM    415  NH1 ARG    26       7.717  -7.051   6.387  1.00 33.33           N 
ATOM    416  NH2 ARG    26       9.417  -5.692   6.913  1.00 74.11           N 
ATOM    417  H   ARG    26       1.220  -2.240   5.313  1.00 38.03           H 
ATOM    418  HA  ARG    26       3.080  -1.891   7.434  1.00 50.00           H 
ATOM    419 1HB  ARG    26       3.527  -4.245   5.580  1.00 42.12           H 
ATOM    420 2HB  ARG    26       3.284  -4.306   7.321  1.00 74.05           H 
ATOM    421 1HG  ARG    26       5.402  -3.091   7.640  1.00 52.20           H 
ATOM    422 2HG  ARG    26       5.652  -3.100   5.895  1.00 33.44           H 
ATOM    423 1HD  ARG    26       5.663  -5.557   5.912  1.00 33.04           H 
ATOM    424 2HD  ARG    26       5.433  -5.538   7.662  1.00 14.10           H 
ATOM    425  HE  ARG    26       7.668  -4.072   7.357  1.00 70.33           H 
ATOM    426 1HH1 ARG    26       6.736  -7.213   6.302  1.00 34.54           H 
ATOM    427 2HH1 ARG    26       8.362  -7.783   6.187  1.00 40.30           H 
ATOM    428 1HH2 ARG    26       9.747  -4.806   7.233  1.00 14.51           H 
ATOM    429 2HH2 ARG    26      10.063  -6.421   6.706  1.00 20.25           H 
ATOM    430  N   GLU    27       4.495  -0.530   5.899  1.00 70.42           N 
ATOM    431  CA  GLU    27       5.300   0.310   5.011  1.00 55.44           C 
ATOM    432  C   GLU    27       6.732  -0.237   4.926  1.00 34.15           C 
ATOM    433  O   GLU    27       7.556   0.013   5.809  1.00 11.52           O 
ATOM    434  CB  GLU    27       5.310   1.762   5.519  1.00 52.40           C 
ATOM    435  CG  GLU    27       3.916   2.368   5.648  1.00 52.02           C 
ATOM    436  CD  GLU    27       3.926   3.773   6.233  1.00 15.32           C 
ATOM    437  OE1 GLU    27       3.647   4.734   5.490  1.00 13.11           O 
ATOM    438  OE2 GLU    27       4.206   3.918   7.444  1.00 43.23           O 
ATOM    439  H   GLU    27       4.558  -0.398   6.869  1.00 38.03           H 
ATOM    440  HA  GLU    27       4.856   0.283   4.025  1.00  0.23           H 
ATOM    441 1HB  GLU    27       5.883   2.371   4.833  1.00 41.01           H 
ATOM    442 2HB  GLU    27       5.782   1.789   6.492  1.00 51.23           H 
ATOM    443 1HG  GLU    27       3.321   1.733   6.291  1.00 23.10           H 
ATOM    444 2HG  GLU    27       3.463   2.405   4.668  1.00 51.04           H 
ATOM    445  N   VAL    28       7.018  -0.998   3.867  1.00 44.22           N 
ATOM    446  CA  VAL    28       8.340  -1.609   3.693  1.00 51.31           C 
ATOM    447  C   VAL    28       9.398  -0.539   3.390  1.00 41.00           C 
ATOM    448  O   VAL    28       9.167   0.368   2.587  1.00  3.43           O 
ATOM    449  CB  VAL    28       8.338  -2.692   2.581  1.00 12.33           C 
ATOM    450  CG1 VAL    28       7.398  -3.838   2.949  1.00  4.31           C 
ATOM    451  CG2 VAL    28       7.956  -2.091   1.229  1.00 50.52           C 
ATOM    452  H   VAL    28       6.332  -1.134   3.182  1.00 38.03           H 
ATOM    453  HA  VAL    28       8.601  -2.091   4.629  1.00  4.04           H 
ATOM    454  HB  VAL    28       9.340  -3.094   2.499  1.00 53.41           H 
ATOM    455 1HG1 VAL    28       7.700  -4.263   3.896  1.00 34.25           H 
ATOM    456 2HG1 VAL    28       7.439  -4.600   2.185  1.00  2.32           H 
ATOM    457 3HG1 VAL    28       6.386  -3.465   3.031  1.00  0.32           H 
ATOM    458 1HG2 VAL    28       7.963  -2.865   0.474  1.00 12.01           H 
ATOM    459 2HG2 VAL    28       8.668  -1.323   0.960  1.00 34.13           H 
ATOM    460 3HG2 VAL    28       6.969  -1.657   1.293  1.00 45.13           H 
ATOM    461  N   ARG    29      10.552  -0.644   4.038  1.00 65.11           N 
ATOM    462  CA  ARG    29      11.562   0.415   3.991  1.00 44.03           C 
ATOM    463  C   ARG    29      12.873  -0.043   3.332  1.00 33.34           C 
ATOM    464  O   ARG    29      13.078  -1.227   3.063  1.00 41.20           O 
ATOM    465  CB  ARG    29      11.813   0.933   5.413  1.00 23.24           C 
ATOM    466  CG  ARG    29      10.540   1.442   6.091  1.00  1.20           C 
ATOM    467  CD  ARG    29      10.816   2.069   7.450  1.00 73.53           C 
ATOM    468  NE  ARG    29       9.590   2.569   8.073  1.00 32.04           N 
ATOM    469  CZ  ARG    29       9.551   3.535   8.950  1.00 31.52           C 
ATOM    470  NH1 ARG    29      10.645   4.102   9.349  1.00 40.11           N 
ATOM    471  NH2 ARG    29       8.415   3.926   9.429  1.00 74.23           N 
ATOM    472  H   ARG    29      10.735  -1.454   4.560  1.00 38.03           H 
ATOM    473  HA  ARG    29      11.158   1.225   3.398  1.00 13.21           H 
ATOM    474 1HB  ARG    29      12.524   1.746   5.370  1.00  4.31           H 
ATOM    475 2HB  ARG    29      12.226   0.134   6.013  1.00 71.55           H 
ATOM    476 1HG  ARG    29       9.859   0.611   6.220  1.00 32.33           H 
ATOM    477 2HG  ARG    29      10.081   2.186   5.455  1.00 75.45           H 
ATOM    478 1HD  ARG    29      11.504   2.892   7.319  1.00 43.11           H 
ATOM    479 2HD  ARG    29      11.260   1.326   8.096  1.00 73.10           H 
ATOM    480  HE  ARG    29       8.747   2.154   7.804  1.00 22.33           H 
ATOM    481 1HH1 ARG    29      11.519   3.800   8.989  1.00 73.13           H 
ATOM    482 2HH1 ARG    29      10.610   4.839  10.023  1.00 72.01           H 
ATOM    483 1HH2 ARG    29       7.571   3.486   9.133  1.00 33.41           H 
ATOM    484 2HH2 ARG    29       8.382   4.678  10.088  1.00 63.31           H 
ATOM    485  N   ILE    30      13.754   0.920   3.076  1.00 73.14           N 
ATOM    486  CA  ILE    30      15.016   0.666   2.373  1.00 64.23           C 
ATOM    487  C   ILE    30      16.035  -0.037   3.286  1.00 62.23           C 
ATOM    488  O   ILE    30      16.502   0.538   4.267  1.00 43.02           O 
ATOM    489  CB  ILE    30      15.623   1.994   1.851  1.00 24.30           C 
ATOM    490  CG1 ILE    30      14.569   2.779   1.050  1.00 41.01           C 
ATOM    491  CG2 ILE    30      16.856   1.717   0.989  1.00 23.11           C 
ATOM    492  CD1 ILE    30      14.999   4.179   0.662  1.00 31.33           C 
ATOM    493  H   ILE    30      13.552   1.832   3.373  1.00 38.03           H 
ATOM    494  HA  ILE    30      14.804   0.030   1.522  1.00 75.34           H 
ATOM    495  HB  ILE    30      15.933   2.586   2.703  1.00 24.42           H 
ATOM    496 1HG1 ILE    30      13.668   2.864   1.640  1.00 12.24           H 
ATOM    497 2HG1 ILE    30      14.342   2.244   0.139  1.00  3.52           H 
ATOM    498 1HG2 ILE    30      17.590   1.178   1.570  1.00 42.52           H 
ATOM    499 2HG2 ILE    30      17.281   2.652   0.653  1.00 61.30           H 
ATOM    500 3HG2 ILE    30      16.570   1.124   0.131  1.00 23.31           H 
ATOM    501 1HD1 ILE    30      14.219   4.645   0.078  1.00 63.31           H 
ATOM    502 2HD1 ILE    30      15.907   4.132   0.079  1.00  4.53           H 
ATOM    503 3HD1 ILE    30      15.174   4.762   1.557  1.00 52.23           H 
ATOM    504  N   GLN    31      16.374  -1.282   2.962  1.00  4.21           N 
ATOM    505  CA  GLN    31      17.310  -2.070   3.775  1.00 60.32           C 
ATOM    506  C   GLN    31      18.776  -1.760   3.426  1.00  2.41           C 
ATOM    507  O   GLN    31      19.151  -1.711   2.254  1.00  4.24           O 
ATOM    508  CB  GLN    31      17.027  -3.568   3.587  1.00 11.31           C 
ATOM    509  CG  GLN    31      17.959  -4.483   4.374  1.00 62.12           C 
ATOM    510  CD  GLN    31      17.587  -5.950   4.248  1.00 62.13           C 
ATOM    511  OE1 GLN    31      17.037  -6.384   3.238  1.00 34.24           O 
ATOM    512  NE2 GLN    31      17.878  -6.724   5.271  1.00 63.40           N 
ATOM    513  H   GLN    31      15.981  -1.687   2.161  1.00 38.03           H 
ATOM    514  HA  GLN    31      17.142  -1.816   4.813  1.00 42.34           H 
ATOM    515 1HB  GLN    31      17.124  -3.810   2.537  1.00 15.40           H 
ATOM    516 2HB  GLN    31      16.011  -3.770   3.898  1.00 23.14           H 
ATOM    517 1HG  GLN    31      17.917  -4.204   5.419  1.00 44.43           H 
ATOM    518 2HG  GLN    31      18.967  -4.352   4.010  1.00 70.45           H 
ATOM    519 1HE2 GLN    31      18.308  -6.318   6.052  1.00 10.34           H 
ATOM    520 2HE2 GLN    31      17.658  -7.674   5.205  1.00  1.20           H 
ATOM    521  N   ASN    32      19.605  -1.561   4.454  1.00 61.43           N 
ATOM    522  CA  ASN    32      21.033  -1.276   4.258  1.00 53.10           C 
ATOM    523  C   ASN    32      21.819  -2.572   3.993  1.00  4.14           C 
ATOM    524  O   ASN    32      21.450  -3.640   4.486  1.00  3.33           O 
ATOM    525  CB  ASN    32      21.611  -0.557   5.487  1.00 10.53           C 
ATOM    526  CG  ASN    32      20.880   0.737   5.808  1.00 33.41           C 
ATOM    527  OD1 ASN    32      21.215   1.804   5.303  1.00 33.32           O 
ATOM    528  ND2 ASN    32      19.882   0.657   6.666  1.00  1.53           N 
ATOM    529  H   ASN    32      19.253  -1.621   5.366  1.00 38.03           H 
ATOM    530  HA  ASN    32      21.129  -0.628   3.397  1.00 45.03           H 
ATOM    531 1HB  ASN    32      22.652  -0.326   5.308  1.00 51.23           H 
ATOM    532 2HB  ASN    32      21.538  -1.209   6.345  1.00 43.12           H 
ATOM    533 1HD2 ASN    32      19.666  -0.219   7.043  1.00 25.43           H 
ATOM    534 2HD2 ASN    32      19.405   1.480   6.892  1.00 32.52           H 
ATOM    535  N   GLU    33      22.909  -2.470   3.229  1.00  3.20           N 
ATOM    536  CA  GLU    33      23.714  -3.647   2.860  1.00 64.42           C 
ATOM    537  C   GLU    33      24.241  -4.392   4.094  1.00 63.13           C 
ATOM    538  O   GLU    33      24.360  -5.619   4.089  1.00 60.23           O 
ATOM    539  CB  GLU    33      24.897  -3.235   1.971  1.00 10.22           C 
ATOM    540  CG  GLU    33      24.491  -2.625   0.632  1.00 51.42           C 
ATOM    541  CD  GLU    33      25.688  -2.323  -0.259  1.00 23.33           C 
ATOM    542  OE1 GLU    33      26.138  -3.232  -0.986  1.00 65.51           O 
ATOM    543  OE2 GLU    33      26.192  -1.179  -0.227  1.00 52.55           O 
ATOM    544  H   GLU    33      23.186  -1.585   2.907  1.00 38.03           H 
ATOM    545  HA  GLU    33      23.077  -4.315   2.299  1.00 62.32           H 
ATOM    546 1HB  GLU    33      25.503  -4.109   1.773  1.00 13.11           H 
ATOM    547 2HB  GLU    33      25.496  -2.509   2.503  1.00 41.44           H 
ATOM    548 1HG  GLU    33      23.954  -1.704   0.816  1.00 41.14           H 
ATOM    549 2HG  GLU    33      23.841  -3.319   0.118  1.00 25.22           H 
ATOM    550  N   ASP    34      24.560  -3.641   5.144  1.00 11.03           N 
ATOM    551  CA  ASP    34      25.068  -4.211   6.395  1.00 51.43           C 
ATOM    552  C   ASP    34      24.071  -5.199   7.024  1.00 74.11           C 
ATOM    553  O   ASP    34      24.464  -6.123   7.737  1.00 72.41           O 
ATOM    554  CB  ASP    34      25.376  -3.080   7.380  1.00 43.21           C 
ATOM    555  CG  ASP    34      26.375  -2.088   6.817  1.00 72.13           C 
ATOM    556  OD1 ASP    34      25.997  -1.307   5.919  1.00 53.52           O 
ATOM    557  OD2 ASP    34      27.534  -2.068   7.277  1.00 72.11           O 
ATOM    558  H   ASP    34      24.460  -2.668   5.074  1.00 38.03           H 
ATOM    559  HA  ASP    34      25.984  -4.738   6.171  1.00 24.22           H 
ATOM    560 1HB  ASP    34      25.780  -3.499   8.291  1.00  5.34           H 
ATOM    561 2HB  ASP    34      24.461  -2.551   7.609  1.00 40.13           H 
ATOM    562  N   GLY    35      22.782  -5.000   6.754  1.00 12.34           N 
ATOM    563  CA  GLY    35      21.759  -5.885   7.299  1.00 53.01           C 
ATOM    564  C   GLY    35      20.526  -5.138   7.794  1.00 32.30           C 
ATOM    565  O   GLY    35      19.412  -5.393   7.334  1.00 42.24           O 
ATOM    566  H   GLY    35      22.524  -4.257   6.172  1.00 38.03           H 
ATOM    567 1HA  GLY    35      22.179  -6.444   8.125  1.00 45.53           H 
ATOM    568 2HA  GLY    35      21.460  -6.581   6.529  1.00  5.14           H 
ATOM    569  N   SER    36      20.727  -4.208   8.729  1.00 53.54           N 
ATOM    570  CA  SER    36      19.615  -3.444   9.326  1.00 64.41           C 
ATOM    571  C   SER    36      18.875  -2.583   8.291  1.00  1.02           C 
ATOM    572  O   SER    36      19.461  -2.101   7.318  1.00 72.14           O 
ATOM    573  CB  SER    36      20.117  -2.547  10.467  1.00 61.32           C 
ATOM    574  OG  SER    36      20.658  -3.310  11.536  1.00 44.14           O 
ATOM    575  H   SER    36      21.646  -4.033   9.034  1.00 38.03           H 
ATOM    576  HA  SER    36      18.917  -4.161   9.735  1.00 20.12           H 
ATOM    577 1HB  SER    36      19.292  -1.959  10.844  1.00 51.04           H 
ATOM    578 2HB  SER    36      20.885  -1.885  10.092  1.00 61.34           H 
ATOM    579  HG  SER    36      20.516  -2.838  12.366  1.00 33.21           H 
ATOM    580  N   VAL    37      17.586  -2.374   8.524  1.00 50.21           N 
ATOM    581  CA  VAL    37      16.742  -1.593   7.619  1.00  2.34           C 
ATOM    582  C   VAL    37      16.727  -0.107   8.015  1.00 72.32           C 
ATOM    583  O   VAL    37      16.829   0.234   9.194  1.00 40.44           O 
ATOM    584  CB  VAL    37      15.295  -2.148   7.609  1.00 20.54           C 
ATOM    585  CG1 VAL    37      14.430  -1.426   6.577  1.00 15.04           C 
ATOM    586  CG2 VAL    37      15.310  -3.654   7.353  1.00 41.23           C 
ATOM    587  H   VAL    37      17.182  -2.761   9.332  1.00 38.03           H 
ATOM    588  HA  VAL    37      17.146  -1.685   6.620  1.00 53.44           H 
ATOM    589  HB  VAL    37      14.860  -1.979   8.585  1.00  1.44           H 
ATOM    590 1HG1 VAL    37      14.385  -0.374   6.815  1.00 13.03           H 
ATOM    591 2HG1 VAL    37      13.431  -1.840   6.589  1.00 23.23           H 
ATOM    592 3HG1 VAL    37      14.858  -1.554   5.592  1.00 70.02           H 
ATOM    593 1HG2 VAL    37      15.749  -3.853   6.387  1.00 63.40           H 
ATOM    594 2HG2 VAL    37      14.299  -4.035   7.374  1.00 64.24           H 
ATOM    595 3HG2 VAL    37      15.894  -4.144   8.120  1.00 20.31           H 
ATOM    596  N   SER    38      16.607   0.767   7.021  1.00 51.31           N 
ATOM    597  CA  SER    38      16.623   2.221   7.250  1.00 72.25           C 
ATOM    598  C   SER    38      15.259   2.748   7.710  1.00 65.43           C 
ATOM    599  O   SER    38      14.267   2.016   7.760  1.00 33.54           O 
ATOM    600  CB  SER    38      17.039   2.959   5.968  1.00 62.33           C 
ATOM    601  OG  SER    38      17.008   4.368   6.146  1.00 64.51           O 
ATOM    602  H   SER    38      16.493   0.432   6.107  1.00 38.03           H 
ATOM    603  HA  SER    38      17.352   2.427   8.021  1.00 72.52           H 
ATOM    604 1HB  SER    38      16.360   2.698   5.168  1.00 62.11           H 
ATOM    605 2HB  SER    38      18.044   2.665   5.695  1.00 34.12           H 
ATOM    606  HG  SER    38      17.881   4.736   5.950  1.00  0.41           H 
ATOM    607  N   ASP    39      15.225   4.032   8.045  1.00 55.54           N 
ATOM    608  CA  ASP    39      13.990   4.710   8.437  1.00 15.11           C 
ATOM    609  C   ASP    39      13.254   5.282   7.210  1.00 72.13           C 
ATOM    610  O   ASP    39      12.102   5.710   7.305  1.00 31.44           O 
ATOM    611  CB  ASP    39      14.307   5.817   9.450  1.00 25.44           C 
ATOM    612  CG  ASP    39      15.365   6.788   8.949  1.00 25.22           C 
ATOM    613  OD1 ASP    39      16.535   6.372   8.788  1.00  1.12           O 
ATOM    614  OD2 ASP    39      15.039   7.970   8.723  1.00 64.33           O 
ATOM    615  H   ASP    39      16.062   4.546   8.027  1.00 38.03           H 
ATOM    616  HA  ASP    39      13.349   3.980   8.911  1.00  2.51           H 
ATOM    617 1HB  ASP    39      14.666   5.365  10.364  1.00 13.25           H 
ATOM    618 2HB  ASP    39      13.404   6.371   9.665  1.00 54.23           H 
ATOM    619  N   GLU    40      13.927   5.272   6.057  1.00  4.12           N 
ATOM    620  CA  GLU    40      13.331   5.738   4.797  1.00 62.14           C 
ATOM    621  C   GLU    40      12.461   4.657   4.142  1.00 71.23           C 
ATOM    622  O   GLU    40      12.790   3.470   4.172  1.00 50.15           O 
ATOM    623  CB  GLU    40      14.426   6.199   3.827  1.00 42.32           C 
ATOM    624  CG  GLU    40      15.109   7.495   4.249  1.00 12.15           C 
ATOM    625  CD  GLU    40      14.145   8.672   4.311  1.00 54.34           C 
ATOM    626  OE1 GLU    40      13.903   9.306   3.263  1.00 55.13           O 
ATOM    627  OE2 GLU    40      13.616   8.962   5.405  1.00 14.55           O 
ATOM    628  H   GLU    40      14.854   4.947   6.053  1.00 38.03           H 
ATOM    629  HA  GLU    40      12.698   6.586   5.031  1.00  1.34           H 
ATOM    630 1HB  GLU    40      13.990   6.348   2.848  1.00  3.34           H 
ATOM    631 2HB  GLU    40      15.180   5.425   3.761  1.00 65.01           H 
ATOM    632 1HG  GLU    40      15.891   7.722   3.539  1.00 60.31           H 
ATOM    633 2HG  GLU    40      15.544   7.352   5.227  1.00 11.34           H 
ATOM    634  N   ILE    41      11.370   5.088   3.518  1.00 53.25           N 
ATOM    635  CA  ILE    41      10.355   4.172   2.978  1.00 24.45           C 
ATOM    636  C   ILE    41      10.710   3.673   1.562  1.00 13.22           C 
ATOM    637  O   ILE    41      11.418   4.344   0.812  1.00 52.43           O 
ATOM    638  CB  ILE    41       8.964   4.863   2.925  1.00 31.23           C 
ATOM    639  CG1 ILE    41       8.601   5.481   4.288  1.00  1.23           C 
ATOM    640  CG2 ILE    41       7.879   3.872   2.489  1.00  0.44           C 
ATOM    641  CD1 ILE    41       8.314   4.464   5.372  1.00 34.44           C 
ATOM    642  H   ILE    41      11.247   6.057   3.405  1.00 38.03           H 
ATOM    643  HA  ILE    41      10.283   3.321   3.643  1.00  3.11           H 
ATOM    644  HB  ILE    41       9.011   5.651   2.185  1.00 23.44           H 
ATOM    645 1HG1 ILE    41       7.720   6.097   4.171  1.00 11.52           H 
ATOM    646 2HG1 ILE    41       9.420   6.100   4.626  1.00 65.22           H 
ATOM    647 1HG2 ILE    41       7.852   3.042   3.181  1.00 73.41           H 
ATOM    648 2HG2 ILE    41       8.101   3.506   1.497  1.00 60.22           H 
ATOM    649 3HG2 ILE    41       6.919   4.368   2.481  1.00 71.22           H 
ATOM    650 1HD1 ILE    41       9.166   3.808   5.490  1.00 53.12           H 
ATOM    651 2HD1 ILE    41       7.445   3.883   5.097  1.00 64.35           H 
ATOM    652 3HD1 ILE    41       8.124   4.976   6.303  1.00 11.23           H 
ATOM    653  N   LYS    42      10.209   2.488   1.209  1.00 13.55           N 
ATOM    654  CA  LYS    42      10.345   1.945  -0.149  1.00 24.51           C 
ATOM    655  C   LYS    42       8.960   1.853  -0.825  1.00 22.30           C 
ATOM    656  O   LYS    42       8.732   2.441  -1.884  1.00 24.53           O 
ATOM    657  CB  LYS    42      11.014   0.562  -0.102  1.00 24.33           C 
ATOM    658  CG  LYS    42      11.343  -0.016  -1.475  1.00 62.14           C 
ATOM    659  CD  LYS    42      12.324   0.870  -2.240  1.00 33.01           C 
ATOM    660  CE  LYS    42      12.662   0.300  -3.609  1.00 60.32           C 
ATOM    661  NZ  LYS    42      13.573   1.196  -4.369  1.00 72.54           N 
ATOM    662  H   LYS    42       9.731   1.962   1.883  1.00 38.03           H 
ATOM    663  HA  LYS    42      10.969   2.622  -0.721  1.00 72.43           H 
ATOM    664 1HB  LYS    42      10.352  -0.128   0.406  1.00 62.41           H 
ATOM    665 2HB  LYS    42      11.934   0.638   0.462  1.00 11.51           H 
ATOM    666 1HG  LYS    42      10.429  -0.103  -2.046  1.00 31.10           H 
ATOM    667 2HG  LYS    42      11.782  -0.996  -1.348  1.00 43.35           H 
ATOM    668 1HD  LYS    42      13.235   0.962  -1.663  1.00 70.42           H 
ATOM    669 2HD  LYS    42      11.883   1.848  -2.371  1.00 43.50           H 
ATOM    670 1HE  LYS    42      11.747   0.169  -4.170  1.00 25.12           H 
ATOM    671 2HE  LYS    42      13.145  -0.659  -3.478  1.00  0.15           H 
ATOM    672 1HZ  LYS    42      14.465   1.328  -3.851  1.00 32.04           H 
ATOM    673 2HZ  LYS    42      13.130   2.126  -4.508  1.00 31.13           H 
ATOM    674 3HZ  LYS    42      13.786   0.786  -5.299  1.00 43.43           H 
ATOM    675  N   GLU    43       8.043   1.109  -0.197  1.00 64.02           N 
ATOM    676  CA  GLU    43       6.634   1.039  -0.625  1.00 41.54           C 
ATOM    677  C   GLU    43       5.694   1.002   0.592  1.00 53.40           C 
ATOM    678  O   GLU    43       6.114   0.671   1.703  1.00 51.32           O 
ATOM    679  CB  GLU    43       6.377  -0.200  -1.501  1.00 32.35           C 
ATOM    680  CG  GLU    43       7.136  -0.198  -2.820  1.00 35.30           C 
ATOM    681  CD  GLU    43       6.641  -1.263  -3.794  1.00 33.11           C 
ATOM    682  OE1 GLU    43       7.330  -2.290  -3.965  1.00 42.54           O 
ATOM    683  OE2 GLU    43       5.554  -1.083  -4.391  1.00 72.45           O 
ATOM    684  H   GLU    43       8.319   0.584   0.576  1.00 38.03           H 
ATOM    685  HA  GLU    43       6.417   1.927  -1.203  1.00 15.30           H 
ATOM    686 1HB  GLU    43       5.318  -0.256  -1.721  1.00 54.03           H 
ATOM    687 2HB  GLU    43       6.663  -1.084  -0.948  1.00 72.25           H 
ATOM    688 1HG  GLU    43       8.184  -0.372  -2.616  1.00 30.51           H 
ATOM    689 2HG  GLU    43       7.023   0.773  -3.276  1.00 71.51           H 
ATOM    690  N   ARG    44       4.422   1.338   0.381  1.00 35.34           N 
ATOM    691  CA  ARG    44       3.419   1.317   1.457  1.00 73.22           C 
ATOM    692  C   ARG    44       2.285   0.326   1.132  1.00 31.44           C 
ATOM    693  O   ARG    44       1.563   0.500   0.150  1.00 74.32           O 
ATOM    694  CB  ARG    44       2.831   2.721   1.672  1.00 75.45           C 
ATOM    695  CG  ARG    44       3.879   3.821   1.843  1.00 55.22           C 
ATOM    696  CD  ARG    44       3.234   5.163   2.173  1.00 42.23           C 
ATOM    697  NE  ARG    44       4.183   6.277   2.093  1.00 60.31           N 
ATOM    698  CZ  ARG    44       4.378   7.152   3.048  1.00 64.32           C 
ATOM    699  NH1 ARG    44       3.842   6.986   4.211  1.00  3.41           N 
ATOM    700  NH2 ARG    44       5.145   8.174   2.847  1.00 25.25           N 
ATOM    701  H   ARG    44       4.147   1.604  -0.522  1.00 38.03           H 
ATOM    702  HA  ARG    44       3.910   1.000   2.366  1.00 32.01           H 
ATOM    703 1HB  ARG    44       2.212   2.703   2.558  1.00 61.32           H 
ATOM    704 2HB  ARG    44       2.212   2.975   0.822  1.00 44.33           H 
ATOM    705 1HG  ARG    44       4.441   3.916   0.924  1.00 11.35           H 
ATOM    706 2HG  ARG    44       4.546   3.548   2.648  1.00 53.45           H 
ATOM    707 1HD  ARG    44       2.829   5.114   3.174  1.00 53.14           H 
ATOM    708 2HD  ARG    44       2.431   5.342   1.472  1.00 12.03           H 
ATOM    709  HE  ARG    44       4.665   6.396   1.256  1.00 54.34           H 
ATOM    710 1HH1 ARG    44       3.278   6.181   4.391  1.00 41.03           H 
ATOM    711 2HH1 ARG    44       4.000   7.656   4.936  1.00 63.20           H 
ATOM    712 1HH2 ARG    44       5.588   8.301   1.964  1.00 33.45           H 
ATOM    713 2HH2 ARG    44       5.289   8.839   3.579  1.00 12.11           H 
ATOM    714  N   THR    45       2.131  -0.705   1.962  1.00  2.33           N 
ATOM    715  CA  THR    45       1.095  -1.733   1.748  1.00 51.21           C 
ATOM    716  C   THR    45      -0.178  -1.446   2.568  1.00 53.41           C 
ATOM    717  O   THR    45      -0.132  -1.365   3.800  1.00 11.32           O 
ATOM    718  CB  THR    45       1.618  -3.144   2.123  1.00 23.32           C 
ATOM    719  OG1 THR    45       2.821  -3.437   1.391  1.00 54.35           O 
ATOM    720  CG2 THR    45       0.570  -4.219   1.835  1.00 35.04           C 
ATOM    721  H   THR    45       2.728  -0.783   2.735  1.00 38.03           H 
ATOM    722  HA  THR    45       0.841  -1.737   0.696  1.00 73.20           H 
ATOM    723  HB  THR    45       1.844  -3.155   3.182  1.00 61.14           H 
ATOM    724  HG1 THR    45       2.946  -2.779   0.697  1.00 53.41           H 
ATOM    725 1HG2 THR    45       0.295  -4.184   0.790  1.00 41.03           H 
ATOM    726 2HG2 THR    45      -0.306  -4.043   2.441  1.00 15.34           H 
ATOM    727 3HG2 THR    45       0.978  -5.192   2.067  1.00 54.51           H 
ATOM    728  N   TYR    46      -1.311  -1.306   1.878  1.00 63.40           N 
ATOM    729  CA  TYR    46      -2.603  -1.018   2.522  1.00 72.32           C 
ATOM    730  C   TYR    46      -3.548  -2.233   2.489  1.00  1.04           C 
ATOM    731  O   TYR    46      -3.463  -3.086   1.601  1.00 65.01           O 
ATOM    732  CB  TYR    46      -3.298   0.155   1.816  1.00 33.02           C 
ATOM    733  CG  TYR    46      -2.516   1.455   1.830  1.00  4.10           C 
ATOM    734  CD1 TYR    46      -2.855   2.484   2.700  1.00 12.21           C 
ATOM    735  CD2 TYR    46      -1.453   1.658   0.960  1.00 21.03           C 
ATOM    736  CE1 TYR    46      -2.159   3.678   2.701  1.00 10.35           C 
ATOM    737  CE2 TYR    46      -0.750   2.843   0.957  1.00 52.54           C 
ATOM    738  CZ  TYR    46      -1.106   3.853   1.827  1.00 10.33           C 
ATOM    739  OH  TYR    46      -0.407   5.041   1.821  1.00  1.03           O 
ATOM    740  H   TYR    46      -1.282  -1.396   0.904  1.00 38.03           H 
ATOM    741  HA  TYR    46      -2.415  -0.746   3.554  1.00 75.12           H 
ATOM    742 1HB  TYR    46      -4.251   0.339   2.295  1.00 43.31           H 
ATOM    743 2HB  TYR    46      -3.471  -0.110   0.785  1.00  4.15           H 
ATOM    744  HD1 TYR    46      -3.675   2.338   3.388  1.00 54.12           H 
ATOM    745  HD2 TYR    46      -1.174   0.867   0.278  1.00 51.41           H 
ATOM    746  HE1 TYR    46      -2.439   4.465   3.385  1.00 41.21           H 
ATOM    747  HE2 TYR    46       0.076   2.978   0.272  1.00 62.02           H 
ATOM    748  HH  TYR    46      -0.182   5.274   0.916  1.00 21.43           H 
ATOM    749  N   ASP    47      -4.462  -2.282   3.457  1.00 31.32           N 
ATOM    750  CA  ASP    47      -5.517  -3.300   3.502  1.00 25.41           C 
ATOM    751  C   ASP    47      -6.825  -2.755   2.903  1.00 60.53           C 
ATOM    752  O   ASP    47      -7.443  -1.849   3.471  1.00 74.55           O 
ATOM    753  CB  ASP    47      -5.774  -3.726   4.954  1.00 32.23           C 
ATOM    754  CG  ASP    47      -4.574  -4.384   5.604  1.00 12.14           C 
ATOM    755  OD1 ASP    47      -4.023  -5.341   5.025  1.00 62.03           O 
ATOM    756  OD2 ASP    47      -4.175  -3.950   6.701  1.00 32.00           O 
ATOM    757  H   ASP    47      -4.426  -1.613   4.169  1.00 38.03           H 
ATOM    758  HA  ASP    47      -5.190  -4.160   2.930  1.00 74.10           H 
ATOM    759 1HB  ASP    47      -6.598  -4.426   4.975  1.00  4.43           H 
ATOM    760 2HB  ASP    47      -6.040  -2.851   5.533  1.00 73.22           H 
ATOM    761  N   LEU    48      -7.242  -3.297   1.759  1.00 63.31           N 
ATOM    762  CA  LEU    48      -8.516  -2.901   1.136  1.00 15.53           C 
ATOM    763  C   LEU    48      -9.430  -4.118   0.918  1.00 15.41           C 
ATOM    764  O   LEU    48      -8.972  -5.181   0.492  1.00 61.30           O 
ATOM    765  CB  LEU    48      -8.266  -2.205  -0.215  1.00 55.31           C 
ATOM    766  CG  LEU    48      -7.406  -0.929  -0.171  1.00 71.53           C 
ATOM    767  CD1 LEU    48      -7.264  -0.321  -1.566  1.00 41.21           C 
ATOM    768  CD2 LEU    48      -7.992   0.096   0.794  1.00 60.44           C 
ATOM    769  H   LEU    48      -6.681  -3.975   1.318  1.00 38.03           H 
ATOM    770  HA  LEU    48      -9.011  -2.207   1.802  1.00 51.14           H 
ATOM    771 1HB  LEU    48      -9.225  -1.951  -0.647  1.00 54.13           H 
ATOM    772 2HB  LEU    48      -7.778  -2.915  -0.870  1.00  3.21           H 
ATOM    773  HG  LEU    48      -6.416  -1.187   0.178  1.00 70.10           H 
ATOM    774 1HD1 LEU    48      -8.239  -0.045  -1.942  1.00  2.34           H 
ATOM    775 2HD1 LEU    48      -6.813  -1.043  -2.231  1.00 23.03           H 
ATOM    776 3HD1 LEU    48      -6.638   0.557  -1.513  1.00 65.21           H 
ATOM    777 1HD2 LEU    48      -8.034  -0.325   1.788  1.00 40.34           H 
ATOM    778 2HD2 LEU    48      -8.990   0.368   0.476  1.00 42.23           H 
ATOM    779 3HD2 LEU    48      -7.368   0.979   0.805  1.00  5.44           H 
ATOM    780  N   LYS    49     -10.724  -3.965   1.212  1.00 45.14           N 
ATOM    781  CA  LYS    49     -11.701  -5.024   0.924  1.00 60.20           C 
ATOM    782  C   LYS    49     -12.439  -4.729  -0.389  1.00 45.21           C 
ATOM    783  O   LYS    49     -12.771  -3.578  -0.681  1.00 44.14           O 
ATOM    784  CB  LYS    49     -12.718  -5.194   2.071  1.00 72.24           C 
ATOM    785  CG  LYS    49     -13.657  -4.002   2.281  1.00 52.03           C 
ATOM    786  CD  LYS    49     -13.239  -3.123   3.457  1.00  0.15           C 
ATOM    787  CE  LYS    49     -13.415  -3.841   4.792  1.00 40.23           C 
ATOM    788  NZ  LYS    49     -13.027  -2.978   5.936  1.00 22.05           N 
ATOM    789  H   LYS    49     -11.029  -3.123   1.615  1.00 38.03           H 
ATOM    790  HA  LYS    49     -11.154  -5.950   0.805  1.00  4.43           H 
ATOM    791 1HB  LYS    49     -12.173  -5.366   2.990  1.00 70.24           H 
ATOM    792 2HB  LYS    49     -13.324  -6.065   1.864  1.00  1.45           H 
ATOM    793 1HG  LYS    49     -14.656  -4.376   2.463  1.00 50.34           H 
ATOM    794 2HG  LYS    49     -13.662  -3.400   1.386  1.00 51.42           H 
ATOM    795 1HD  LYS    49     -13.846  -2.228   3.456  1.00 45.23           H 
ATOM    796 2HD  LYS    49     -12.199  -2.849   3.340  1.00 75.20           H 
ATOM    797 1HE  LYS    49     -12.796  -4.728   4.798  1.00  3.20           H 
ATOM    798 2HE  LYS    49     -14.451  -4.124   4.905  1.00 40.24           H 
ATOM    799 1HZ  LYS    49     -12.022  -2.724   5.863  1.00 73.11           H 
ATOM    800 2HZ  LYS    49     -13.184  -3.480   6.836  1.00 24.12           H 
ATOM    801 3HZ  LYS    49     -13.597  -2.107   5.936  1.00 11.23           H 
ATOM    802  N   SER    50     -12.682  -5.772  -1.180  1.00 73.12           N 
ATOM    803  CA  SER    50     -13.362  -5.624  -2.472  1.00 55.40           C 
ATOM    804  C   SER    50     -14.506  -6.635  -2.624  1.00  4.21           C 
ATOM    805  O   SER    50     -14.462  -7.735  -2.070  1.00 24.42           O 
ATOM    806  CB  SER    50     -12.362  -5.795  -3.624  1.00  3.55           C 
ATOM    807  OG  SER    50     -11.766  -7.084  -3.604  1.00 20.51           O 
ATOM    808  H   SER    50     -12.396  -6.665  -0.893  1.00 38.03           H 
ATOM    809  HA  SER    50     -13.777  -4.626  -2.519  1.00 41.42           H 
ATOM    810 1HB  SER    50     -11.584  -5.052  -3.531  1.00  3.22           H 
ATOM    811 2HB  SER    50     -12.872  -5.663  -4.567  1.00 20.24           H 
ATOM    812  HG  SER    50     -10.889  -7.030  -3.214  1.00 13.21           H 
ATOM    813  N   LYS    51     -15.541  -6.248  -3.366  1.00 54.32           N 
ATOM    814  CA  LYS    51     -16.681  -7.133  -3.628  1.00  1.12           C 
ATOM    815  C   LYS    51     -16.364  -8.142  -4.744  1.00 34.41           C 
ATOM    816  O   LYS    51     -16.046  -7.757  -5.871  1.00  1.12           O 
ATOM    817  CB  LYS    51     -17.921  -6.312  -4.013  1.00 64.33           C 
ATOM    818  CG  LYS    51     -18.490  -5.466  -2.878  1.00 72.11           C 
ATOM    819  CD  LYS    51     -18.936  -6.328  -1.697  1.00 41.12           C 
ATOM    820  CE  LYS    51     -19.703  -5.518  -0.655  1.00 62.12           C 
ATOM    821  NZ  LYS    51     -20.944  -4.916  -1.218  1.00 60.35           N 
ATOM    822  H   LYS    51     -15.537  -5.348  -3.748  1.00 38.03           H 
ATOM    823  HA  LYS    51     -16.892  -7.678  -2.718  1.00 70.32           H 
ATOM    824 1HB  LYS    51     -18.695  -6.988  -4.348  1.00 22.25           H 
ATOM    825 2HB  LYS    51     -17.662  -5.651  -4.829  1.00 60.44           H 
ATOM    826 1HG  LYS    51     -19.339  -4.909  -3.248  1.00 55.11           H 
ATOM    827 2HG  LYS    51     -17.730  -4.776  -2.539  1.00 22.35           H 
ATOM    828 1HD  LYS    51     -18.062  -6.763  -1.230  1.00 72.31           H 
ATOM    829 2HD  LYS    51     -19.578  -7.116  -2.064  1.00 35.21           H 
ATOM    830 1HE  LYS    51     -19.064  -4.728  -0.286  1.00  4.21           H 
ATOM    831 2HE  LYS    51     -19.971  -6.170   0.162  1.00 32.54           H 
ATOM    832 1HZ  LYS    51     -20.705  -4.244  -1.977  1.00 52.15           H 
ATOM    833 2HZ  LYS    51     -21.465  -4.408  -0.474  1.00 35.32           H 
ATOM    834 3HZ  LYS    51     -21.561  -5.656  -1.608  1.00 55.44           H 
ATOM    835  N   GLY    52     -16.464  -9.431  -4.428  1.00 34.23           N 
ATOM    836  CA  GLY    52     -16.205 -10.473  -5.419  1.00  2.21           C 
ATOM    837  C   GLY    52     -15.995 -11.851  -4.797  1.00 23.21           C 
ATOM    838  O   GLY    52     -16.958 -12.542  -4.457  1.00 52.40           O 
ATOM    839  H   GLY    52     -16.714  -9.679  -3.513  1.00 38.03           H 
ATOM    840 1HA  GLY    52     -15.322 -10.208  -5.982  1.00 64.35           H 
ATOM    841 2HA  GLY    52     -17.046 -10.523  -6.095  1.00 61.13           H 
ATOM    842  N   GLN    53     -14.735 -12.243  -4.632  1.00 43.02           N 
ATOM    843  CA  GLN    53     -14.388 -13.566  -4.093  1.00 50.23           C 
ATOM    844  C   GLN    53     -14.193 -13.535  -2.566  1.00 54.42           C 
ATOM    845  O   GLN    53     -13.922 -14.567  -1.947  1.00  0.02           O 
ATOM    846  CB  GLN    53     -13.117 -14.090  -4.779  1.00  1.44           C 
ATOM    847  CG  GLN    53     -13.237 -14.208  -6.297  1.00  3.50           C 
ATOM    848  CD  GLN    53     -14.342 -15.159  -6.732  1.00  3.52           C 
ATOM    849  OE1 GLN    53     -15.487 -14.762  -6.924  1.00 34.45           O 
ATOM    850  NE2 GLN    53     -14.010 -16.423  -6.889  1.00 52.20           N 
ATOM    851  H   GLN    53     -14.014 -11.629  -4.887  1.00 38.03           H 
ATOM    852  HA  GLN    53     -15.204 -14.237  -4.321  1.00 51.12           H 
ATOM    853 1HB  GLN    53     -12.882 -15.067  -4.382  1.00 55.22           H 
ATOM    854 2HB  GLN    53     -12.300 -13.417  -4.559  1.00  4.31           H 
ATOM    855 1HG  GLN    53     -12.297 -14.566  -6.692  1.00 24.50           H 
ATOM    856 2HG  GLN    53     -13.445 -13.229  -6.707  1.00 43.21           H 
ATOM    857 1HE2 GLN    53     -13.083 -16.684  -6.720  1.00 64.02           H 
ATOM    858 2HE2 GLN    53     -14.708 -17.048  -7.171  1.00 22.54           H 
ATOM    859  N   GLY    54     -14.331 -12.351  -1.966  1.00 41.33           N 
ATOM    860  CA  GLY    54     -14.203 -12.217  -0.513  1.00 14.14           C 
ATOM    861  C   GLY    54     -12.756 -12.235  -0.023  1.00 21.44           C 
ATOM    862  O   GLY    54     -12.461 -12.750   1.059  1.00 50.42           O 
ATOM    863  H   GLY    54     -14.528 -11.561  -2.511  1.00 38.03           H 
ATOM    864 1HA  GLY    54     -14.742 -13.026  -0.039  1.00 55.31           H 
ATOM    865 2HA  GLY    54     -14.654 -11.283  -0.212  1.00 22.41           H 
ATOM    866  N   ARG    55     -11.850 -11.667  -0.813  1.00 32.52           N 
ATOM    867  CA  ARG    55     -10.428 -11.619  -0.454  1.00 23.45           C 
ATOM    868  C   ARG    55      -9.956 -10.192  -0.130  1.00 43.42           C 
ATOM    869  O   ARG    55     -10.187  -9.258  -0.898  1.00 31.52           O 
ATOM    870  CB  ARG    55      -9.573 -12.210  -1.588  1.00 13.52           C 
ATOM    871  CG  ARG    55      -9.421 -13.730  -1.529  1.00 73.50           C 
ATOM    872  CD  ARG    55      -8.607 -14.163  -0.311  1.00  0.04           C 
ATOM    873  NE  ARG    55      -8.364 -15.604  -0.283  1.00 34.53           N 
ATOM    874  CZ  ARG    55      -7.361 -16.163   0.344  1.00 41.42           C 
ATOM    875  NH1 ARG    55      -6.504 -15.446   0.992  1.00 32.23           N 
ATOM    876  NH2 ARG    55      -7.222 -17.445   0.325  1.00  3.32           N 
ATOM    877  H   ARG    55     -12.140 -11.270  -1.661  1.00 38.03           H 
ATOM    878  HA  ARG    55     -10.293 -12.229   0.430  1.00  4.20           H 
ATOM    879 1HB  ARG    55      -8.584 -11.771  -1.548  1.00 62.35           H 
ATOM    880 2HB  ARG    55     -10.026 -11.953  -2.534  1.00 33.23           H 
ATOM    881 1HG  ARG    55      -8.917 -14.066  -2.424  1.00  1.41           H 
ATOM    882 2HG  ARG    55     -10.401 -14.183  -1.476  1.00 44.10           H 
ATOM    883 1HD  ARG    55      -9.144 -13.881   0.584  1.00 72.10           H 
ATOM    884 2HD  ARG    55      -7.655 -13.650  -0.332  1.00 63.33           H 
ATOM    885  HE  ARG    55      -8.996 -16.181  -0.756  1.00 12.01           H 
ATOM    886 1HH1 ARG    55      -6.602 -14.455   1.023  1.00 52.24           H 
ATOM    887 2HH1 ARG    55      -5.738 -15.887   1.461  1.00 20.33           H 
ATOM    888 1HH2 ARG    55      -7.882 -18.007  -0.169  1.00 60.20           H 
ATOM    889 2HH2 ARG    55      -6.459 -17.868   0.804  1.00 51.33           H 
ATOM    890  N   MET    56      -9.301 -10.035   1.020  1.00 44.22           N 
ATOM    891  CA  MET    56      -8.649  -8.768   1.371  1.00 42.10           C 
ATOM    892  C   MET    56      -7.379  -8.578   0.524  1.00 21.21           C 
ATOM    893  O   MET    56      -6.450  -9.382   0.592  1.00 62.50           O 
ATOM    894  CB  MET    56      -8.321  -8.727   2.875  1.00  5.31           C 
ATOM    895  CG  MET    56      -7.436  -9.873   3.359  1.00 21.35           C 
ATOM    896  SD  MET    56      -7.092  -9.790   5.133  1.00 63.43           S 
ATOM    897  CE  MET    56      -8.743  -9.946   5.817  1.00 72.51           C 
ATOM    898  H   MET    56      -9.257 -10.786   1.648  1.00 38.03           H 
ATOM    899  HA  MET    56      -9.342  -7.968   1.143  1.00 13.40           H 
ATOM    900 1HB  MET    56      -9.247  -8.759   3.431  1.00 42.31           H 
ATOM    901 2HB  MET    56      -7.816  -7.797   3.097  1.00 33.11           H 
ATOM    902 1HG  MET    56      -6.499  -9.838   2.824  1.00 20.23           H 
ATOM    903 2HG  MET    56      -7.934 -10.810   3.146  1.00 33.22           H 
ATOM    904 1HE  MET    56      -9.365  -9.140   5.452  1.00 54.42           H 
ATOM    905 2HE  MET    56      -8.693  -9.898   6.896  1.00 70.41           H 
ATOM    906 3HE  MET    56      -9.169 -10.892   5.518  1.00 21.44           H 
ATOM    907  N   ILE    57      -7.343  -7.519  -0.275  1.00 44.11           N 
ATOM    908  CA  ILE    57      -6.249  -7.320  -1.230  1.00  1.30           C 
ATOM    909  C   ILE    57      -5.142  -6.424  -0.656  1.00 62.51           C 
ATOM    910  O   ILE    57      -5.417  -5.421   0.010  1.00 61.12           O 
ATOM    911  CB  ILE    57      -6.767  -6.715  -2.562  1.00 34.42           C 
ATOM    912  CG1 ILE    57      -7.395  -5.326  -2.336  1.00 41.25           C 
ATOM    913  CG2 ILE    57      -7.776  -7.662  -3.216  1.00 71.41           C 
ATOM    914  CD1 ILE    57      -7.899  -4.667  -3.606  1.00 60.11           C 
ATOM    915  H   ILE    57      -8.059  -6.850  -0.219  1.00 38.03           H 
ATOM    916  HA  ILE    57      -5.822  -8.291  -1.451  1.00  1.23           H 
ATOM    917  HB  ILE    57      -5.925  -6.616  -3.233  1.00 62.55           H 
ATOM    918 1HG1 ILE    57      -6.653  -4.671  -1.898  1.00 53.21           H 
ATOM    919 2HG1 ILE    57      -8.230  -5.416  -1.658  1.00 43.10           H 
ATOM    920 1HG2 ILE    57      -8.603  -7.834  -2.541  1.00  4.15           H 
ATOM    921 2HG2 ILE    57      -7.296  -8.603  -3.441  1.00 61.11           H 
ATOM    922 3HG2 ILE    57      -8.146  -7.222  -4.132  1.00 22.41           H 
ATOM    923 1HD1 ILE    57      -8.330  -3.707  -3.366  1.00 64.34           H 
ATOM    924 2HD1 ILE    57      -8.651  -5.294  -4.065  1.00 32.33           H 
ATOM    925 3HD1 ILE    57      -7.076  -4.531  -4.292  1.00  1.20           H 
ATOM    926  N   GLN    58      -3.888  -6.804  -0.904  1.00 75.55           N 
ATOM    927  CA  GLN    58      -2.741  -6.021  -0.436  1.00 32.25           C 
ATOM    928  C   GLN    58      -2.276  -5.031  -1.512  1.00 23.44           C 
ATOM    929  O   GLN    58      -1.633  -5.417  -2.485  1.00 52.52           O 
ATOM    930  CB  GLN    58      -1.591  -6.967  -0.058  1.00 34.13           C 
ATOM    931  CG  GLN    58      -1.957  -7.971   1.032  1.00 64.23           C 
ATOM    932  CD  GLN    58      -2.190  -7.316   2.386  1.00 74.11           C 
ATOM    933  OE1 GLN    58      -1.273  -7.190   3.189  1.00 51.23           O 
ATOM    934  NE2 GLN    58      -3.409  -6.889   2.648  1.00 43.25           N 
ATOM    935  H   GLN    58      -3.727  -7.636  -1.410  1.00 38.03           H 
ATOM    936  HA  GLN    58      -3.044  -5.469   0.443  1.00  0.12           H 
ATOM    937 1HB  GLN    58      -0.754  -6.377   0.291  1.00 54.15           H 
ATOM    938 2HB  GLN    58      -1.288  -7.516  -0.939  1.00 73.12           H 
ATOM    939 1HG  GLN    58      -1.152  -8.688   1.130  1.00 24.40           H 
ATOM    940 2HG  GLN    58      -2.859  -8.489   0.739  1.00 52.32           H 
ATOM    941 1HE2 GLN    58      -4.102  -7.014   1.972  1.00  1.33           H 
ATOM    942 2HE2 GLN    58      -3.564  -6.449   3.513  1.00 22.43           H 
ATOM    943  N   VAL    59      -2.591  -3.753  -1.326  1.00  4.45           N 
ATOM    944  CA  VAL    59      -2.241  -2.718  -2.309  1.00 30.25           C 
ATOM    945  C   VAL    59      -0.965  -1.968  -1.905  1.00 20.54           C 
ATOM    946  O   VAL    59      -0.931  -1.287  -0.884  1.00 23.02           O 
ATOM    947  CB  VAL    59      -3.397  -1.702  -2.495  1.00 73.23           C 
ATOM    948  CG1 VAL    59      -3.020  -0.613  -3.503  1.00 53.41           C 
ATOM    949  CG2 VAL    59      -4.672  -2.424  -2.926  1.00 53.45           C 
ATOM    950  H   VAL    59      -3.072  -3.496  -0.509  1.00 38.03           H 
ATOM    951  HA  VAL    59      -2.069  -3.207  -3.259  1.00 21.45           H 
ATOM    952  HB  VAL    59      -3.585  -1.225  -1.541  1.00 43.44           H 
ATOM    953 1HG1 VAL    59      -2.152  -0.076  -3.149  1.00 23.35           H 
ATOM    954 2HG1 VAL    59      -3.844   0.075  -3.617  1.00  3.51           H 
ATOM    955 3HG1 VAL    59      -2.797  -1.067  -4.459  1.00 34.40           H 
ATOM    956 1HG2 VAL    59      -4.507  -2.916  -3.874  1.00 22.54           H 
ATOM    957 2HG2 VAL    59      -5.477  -1.709  -3.027  1.00 14.30           H 
ATOM    958 3HG2 VAL    59      -4.939  -3.160  -2.180  1.00 54.44           H 
ATOM    959  N   SER    60       0.079  -2.093  -2.720  1.00 30.53           N 
ATOM    960  CA  SER    60       1.375  -1.464  -2.423  1.00 10.42           C 
ATOM    961  C   SER    60       1.687  -0.321  -3.397  1.00 43.11           C 
ATOM    962  O   SER    60       1.704  -0.514  -4.613  1.00 35.23           O 
ATOM    963  CB  SER    60       2.503  -2.504  -2.475  1.00 30.45           C 
ATOM    964  OG  SER    60       3.745  -1.930  -2.103  1.00  4.40           O 
ATOM    965  H   SER    60      -0.022  -2.617  -3.545  1.00 38.03           H 
ATOM    966  HA  SER    60       1.325  -1.059  -1.422  1.00 23.51           H 
ATOM    967 1HB  SER    60       2.586  -2.896  -3.479  1.00 14.11           H 
ATOM    968 2HB  SER    60       2.277  -3.310  -1.794  1.00 23.24           H 
ATOM    969  HG  SER    60       4.258  -1.728  -2.897  1.00 23.32           H 
ATOM    970  N   ILE    61       1.935   0.868  -2.852  1.00 70.05           N 
ATOM    971  CA  ILE    61       2.318   2.037  -3.659  1.00 42.11           C 
ATOM    972  C   ILE    61       3.747   2.494  -3.321  1.00 11.12           C 
ATOM    973  O   ILE    61       4.185   2.377  -2.175  1.00 31.32           O 
ATOM    974  CB  ILE    61       1.331   3.218  -3.451  1.00 34.21           C 
ATOM    975  CG1 ILE    61       1.280   3.630  -1.971  1.00 45.51           C 
ATOM    976  CG2 ILE    61      -0.062   2.849  -3.965  1.00 32.31           C 
ATOM    977  CD1 ILE    61       0.366   4.804  -1.691  1.00 14.01           C 
ATOM    978  H   ILE    61       1.861   0.965  -1.878  1.00 38.03           H 
ATOM    979  HA  ILE    61       2.284   1.750  -4.703  1.00 63.33           H 
ATOM    980  HB  ILE    61       1.685   4.057  -4.037  1.00 24.11           H 
ATOM    981 1HG1 ILE    61       2.275   3.900  -1.643  1.00 72.01           H 
ATOM    982 2HG1 ILE    61       0.929   2.795  -1.382  1.00 54.50           H 
ATOM    983 1HG2 ILE    61      -0.003   2.597  -5.015  1.00 33.12           H 
ATOM    984 2HG2 ILE    61      -0.730   3.690  -3.837  1.00 73.22           H 
ATOM    985 3HG2 ILE    61      -0.441   2.000  -3.412  1.00 24.14           H 
ATOM    986 1HD1 ILE    61       0.394   5.039  -0.638  1.00 44.21           H 
ATOM    987 2HD1 ILE    61      -0.645   4.552  -1.975  1.00 54.24           H 
ATOM    988 3HD1 ILE    61       0.695   5.661  -2.258  1.00 21.04           H 
ATOM    989  N   PRO    62       4.500   3.027  -4.305  1.00 60.24           N 
ATOM    990  CA  PRO    62       5.904   3.440  -4.091  1.00 61.14           C 
ATOM    991  C   PRO    62       6.064   4.597  -3.077  1.00 70.05           C 
ATOM    992  O   PRO    62       5.137   5.376  -2.849  1.00  4.04           O 
ATOM    993  CB  PRO    62       6.364   3.878  -5.490  1.00 34.11           C 
ATOM    994  CG  PRO    62       5.106   4.211  -6.224  1.00 50.44           C 
ATOM    995  CD  PRO    62       4.057   3.273  -5.693  1.00 52.14           C 
ATOM    996  HA  PRO    62       6.507   2.602  -3.763  1.00 73.21           H 
ATOM    997 1HB  PRO    62       6.897   3.067  -5.969  1.00 72.22           H 
ATOM    998 2HB  PRO    62       7.015   4.738  -5.408  1.00 24.01           H 
ATOM    999 1HG  PRO    62       5.245   4.060  -7.286  1.00 41.45           H 
ATOM   1000 2HG  PRO    62       4.826   5.237  -6.026  1.00  2.11           H 
ATOM   1001 1HD  PRO    62       4.046   2.353  -6.262  1.00 41.22           H 
ATOM   1002 2HD  PRO    62       3.082   3.743  -5.713  1.00 24.45           H 
ATOM   1003  N   ALA    63       7.263   4.709  -2.494  1.00 32.02           N 
ATOM   1004  CA  ALA    63       7.557   5.715  -1.456  1.00 31.42           C 
ATOM   1005  C   ALA    63       7.290   7.152  -1.925  1.00 34.23           C 
ATOM   1006  O   ALA    63       6.892   8.005  -1.130  1.00 61.24           O 
ATOM   1007  CB  ALA    63       9.002   5.582  -0.990  1.00 12.05           C 
ATOM   1008  H   ALA    63       7.977   4.092  -2.764  1.00 38.03           H 
ATOM   1009  HA  ALA    63       6.918   5.507  -0.610  1.00 62.32           H 
ATOM   1010 1HB  ALA    63       9.670   5.853  -1.795  1.00 73.22           H 
ATOM   1011 2HB  ALA    63       9.191   4.560  -0.696  1.00 62.43           H 
ATOM   1012 3HB  ALA    63       9.174   6.236  -0.146  1.00 60.03           H 
ATOM   1013  N   SER    64       7.511   7.418  -3.214  1.00 23.11           N 
ATOM   1014  CA  SER    64       7.278   8.758  -3.785  1.00 33.24           C 
ATOM   1015  C   SER    64       5.822   9.213  -3.593  1.00 22.01           C 
ATOM   1016  O   SER    64       5.518  10.404  -3.678  1.00 45.23           O 
ATOM   1017  CB  SER    64       7.629   8.780  -5.280  1.00 40.12           C 
ATOM   1018  OG  SER    64       8.998   8.460  -5.499  1.00  5.30           O 
ATOM   1019  H   SER    64       7.850   6.702  -3.793  1.00 38.03           H 
ATOM   1020  HA  SER    64       7.925   9.452  -3.266  1.00 13.23           H 
ATOM   1021 1HB  SER    64       7.436   9.766  -5.680  1.00 24.42           H 
ATOM   1022 2HB  SER    64       7.019   8.056  -5.802  1.00 43.44           H 
ATOM   1023  HG  SER    64       9.067   7.551  -5.814  1.00 63.04           H 
ATOM   1024  N   VAL    65       4.930   8.260  -3.342  1.00 51.35           N 
ATOM   1025  CA  VAL    65       3.521   8.561  -3.082  1.00 50.10           C 
ATOM   1026  C   VAL    65       3.270   8.748  -1.573  1.00 32.23           C 
ATOM   1027  O   VAL    65       3.622   7.883  -0.765  1.00 31.33           O 
ATOM   1028  CB  VAL    65       2.603   7.434  -3.622  1.00 73.21           C 
ATOM   1029  CG1 VAL    65       1.129   7.794  -3.438  1.00 34.34           C 
ATOM   1030  CG2 VAL    65       2.915   7.147  -5.089  1.00 65.22           C 
ATOM   1031  H   VAL    65       5.225   7.325  -3.324  1.00 38.03           H 
ATOM   1032  HA  VAL    65       3.274   9.477  -3.601  1.00 22.10           H 
ATOM   1033  HB  VAL    65       2.800   6.533  -3.055  1.00 22.53           H 
ATOM   1034 1HG1 VAL    65       0.511   6.986  -3.807  1.00 25.14           H 
ATOM   1035 2HG1 VAL    65       0.906   8.696  -3.990  1.00 60.15           H 
ATOM   1036 3HG1 VAL    65       0.921   7.953  -2.390  1.00 73.22           H 
ATOM   1037 1HG2 VAL    65       2.298   6.330  -5.436  1.00 14.42           H 
ATOM   1038 2HG2 VAL    65       3.958   6.877  -5.190  1.00 41.42           H 
ATOM   1039 3HG2 VAL    65       2.712   8.027  -5.680  1.00 51.52           H 
ATOM   1040  N   PRO    66       2.673   9.888  -1.165  1.00 71.42           N 
ATOM   1041  CA  PRO    66       2.403  10.174   0.257  1.00  2.20           C 
ATOM   1042  C   PRO    66       1.300   9.276   0.858  1.00 35.40           C 
ATOM   1043  O   PRO    66       0.512   8.663   0.135  1.00 53.31           O 
ATOM   1044  CB  PRO    66       1.957  11.644   0.239  1.00 13.22           C 
ATOM   1045  CG  PRO    66       1.394  11.848  -1.128  1.00  4.54           C 
ATOM   1046  CD  PRO    66       2.218  10.985  -2.046  1.00 33.50           C 
ATOM   1047  HA  PRO    66       3.302  10.077   0.850  1.00 54.05           H 
ATOM   1048 1HB  PRO    66       2.811  12.287   0.413  1.00 55.23           H 
ATOM   1049 2HB  PRO    66       1.214  11.813   1.006  1.00 72.23           H 
ATOM   1050 1HG  PRO    66       1.477  12.887  -1.412  1.00 31.01           H 
ATOM   1051 2HG  PRO    66       0.358  11.537  -1.147  1.00  1.31           H 
ATOM   1052 1HD  PRO    66       3.058  11.540  -2.436  1.00 25.05           H 
ATOM   1053 2HD  PRO    66       1.610  10.605  -2.857  1.00 23.01           H 
ATOM   1054  N   LEU    67       1.255   9.210   2.186  1.00  3.11           N 
ATOM   1055  CA  LEU    67       0.232   8.438   2.902  1.00  2.22           C 
ATOM   1056  C   LEU    67      -1.144   9.128   2.822  1.00 75.53           C 
ATOM   1057  O   LEU    67      -1.235  10.357   2.860  1.00 63.14           O 
ATOM   1058  CB  LEU    67       0.650   8.278   4.373  1.00 51.50           C 
ATOM   1059  CG  LEU    67      -0.292   7.434   5.252  1.00 44.43           C 
ATOM   1060  CD1 LEU    67      -0.317   5.983   4.792  1.00 64.51           C 
ATOM   1061  CD2 LEU    67       0.112   7.520   6.719  1.00 10.50           C 
ATOM   1062  H   LEU    67       1.934   9.689   2.706  1.00 38.03           H 
ATOM   1063  HA  LEU    67       0.165   7.460   2.445  1.00 42.43           H 
ATOM   1064 1HB  LEU    67       0.724   9.264   4.808  1.00  4.33           H 
ATOM   1065 2HB  LEU    67       1.633   7.825   4.393  1.00 54.22           H 
ATOM   1066  HG  LEU    67      -1.298   7.822   5.163  1.00 25.04           H 
ATOM   1067 1HD1 LEU    67      -0.692   5.932   3.781  1.00 10.35           H 
ATOM   1068 2HD1 LEU    67      -0.961   5.411   5.444  1.00 11.35           H 
ATOM   1069 3HD1 LEU    67       0.685   5.573   4.826  1.00 33.14           H 
ATOM   1070 1HD2 LEU    67       0.091   8.552   7.038  1.00 21.15           H 
ATOM   1071 2HD2 LEU    67       1.110   7.123   6.846  1.00 35.14           H 
ATOM   1072 3HD2 LEU    67      -0.583   6.947   7.316  1.00 52.14           H 
ATOM   1073  N   LYS    68      -2.210   8.337   2.693  1.00 31.51           N 
ATOM   1074  CA  LYS    68      -3.575   8.882   2.671  1.00 60.21           C 
ATOM   1075  C   LYS    68      -4.355   8.495   3.935  1.00 13.05           C 
ATOM   1076  O   LYS    68      -4.773   7.349   4.102  1.00 40.51           O 
ATOM   1077  CB  LYS    68      -4.351   8.423   1.427  1.00 33.02           C 
ATOM   1078  CG  LYS    68      -3.828   8.986   0.103  1.00 64.12           C 
ATOM   1079  CD  LYS    68      -2.595   8.241  -0.399  1.00 43.32           C 
ATOM   1080  CE  LYS    68      -1.973   8.926  -1.613  1.00 74.33           C 
ATOM   1081  NZ  LYS    68      -2.942   9.105  -2.726  1.00 20.52           N 
ATOM   1082  H   LYS    68      -2.080   7.370   2.618  1.00 38.03           H 
ATOM   1083  HA  LYS    68      -3.495   9.962   2.643  1.00 14.13           H 
ATOM   1084 1HB  LYS    68      -5.384   8.727   1.539  1.00 74.01           H 
ATOM   1085 2HB  LYS    68      -4.311   7.343   1.376  1.00 31.14           H 
ATOM   1086 1HG  LYS    68      -3.574  10.029   0.245  1.00 32.42           H 
ATOM   1087 2HG  LYS    68      -4.607   8.907  -0.642  1.00 10.02           H 
ATOM   1088 1HD  LYS    68      -2.881   7.235  -0.672  1.00 23.05           H 
ATOM   1089 2HD  LYS    68      -1.862   8.204   0.394  1.00 10.42           H 
ATOM   1090 1HE  LYS    68      -1.145   8.328  -1.963  1.00 45.51           H 
ATOM   1091 2HE  LYS    68      -1.613   9.895  -1.313  1.00 34.11           H 
ATOM   1092 1HZ  LYS    68      -2.446   9.421  -3.586  1.00 32.10           H 
ATOM   1093 2HZ  LYS    68      -3.652   9.821  -2.476  1.00 63.14           H 
ATOM   1094 3HZ  LYS    68      -3.430   8.212  -2.932  1.00 13.33           H 
ATOM   1095  N   GLU    69      -4.551   9.471   4.812  1.00 64.53           N 
ATOM   1096  CA  GLU    69      -5.273   9.267   6.070  1.00 44.03           C 
ATOM   1097  C   GLU    69      -6.793   9.153   5.839  1.00 14.02           C 
ATOM   1098  O   GLU    69      -7.542  10.098   6.107  1.00 52.20           O 
ATOM   1099  CB  GLU    69      -4.977  10.443   7.011  1.00 43.31           C 
ATOM   1100  CG  GLU    69      -3.504  10.599   7.389  1.00 64.21           C 
ATOM   1101  CD  GLU    69      -3.088   9.730   8.570  1.00  2.14           C 
ATOM   1102  OE1 GLU    69      -3.059  10.248   9.710  1.00 74.04           O 
ATOM   1103  OE2 GLU    69      -2.785   8.537   8.370  1.00 74.11           O 
ATOM   1104  H   GLU    69      -4.198  10.362   4.611  1.00 38.03           H 
ATOM   1105  HA  GLU    69      -4.915   8.353   6.524  1.00 10.04           H 
ATOM   1106 1HB  GLU    69      -5.552  10.315   7.918  1.00 33.54           H 
ATOM   1107 2HB  GLU    69      -5.297  11.353   6.523  1.00 34.53           H 
ATOM   1108 1HG  GLU    69      -3.322  11.634   7.642  1.00 41.43           H 
ATOM   1109 2HG  GLU    69      -2.895  10.333   6.536  1.00 72.31           H 
ATOM   1110  N   PHE    70      -7.242   8.012   5.320  1.00 65.54           N 
ATOM   1111  CA  PHE    70      -8.675   7.790   5.057  1.00 10.24           C 
ATOM   1112  C   PHE    70      -9.368   7.065   6.220  1.00 31.44           C 
ATOM   1113  O   PHE    70      -8.730   6.336   6.984  1.00 13.33           O 
ATOM   1114  CB  PHE    70      -8.874   6.984   3.764  1.00 52.51           C 
ATOM   1115  CG  PHE    70      -8.493   7.725   2.503  1.00 32.13           C 
ATOM   1116  CD1 PHE    70      -8.788   9.073   2.360  1.00 51.32           C 
ATOM   1117  CD2 PHE    70      -7.857   7.070   1.456  1.00 24.41           C 
ATOM   1118  CE1 PHE    70      -8.456   9.751   1.204  1.00 22.15           C 
ATOM   1119  CE2 PHE    70      -7.522   7.747   0.298  1.00 54.44           C 
ATOM   1120  CZ  PHE    70      -7.820   9.089   0.173  1.00 63.43           C 
ATOM   1121  H   PHE    70      -6.599   7.303   5.106  1.00 38.03           H 
ATOM   1122  HA  PHE    70      -9.140   8.760   4.935  1.00 61.21           H 
ATOM   1123 1HB  PHE    70      -9.915   6.703   3.681  1.00 24.12           H 
ATOM   1124 2HB  PHE    70      -8.274   6.088   3.814  1.00  0.02           H 
ATOM   1125  HD1 PHE    70      -9.283   9.597   3.165  1.00 11.42           H 
ATOM   1126  HD2 PHE    70      -7.624   6.018   1.551  1.00 14.53           H 
ATOM   1127  HE1 PHE    70      -8.696  10.800   1.106  1.00 71.10           H 
ATOM   1128  HE2 PHE    70      -7.024   7.226  -0.508  1.00  1.14           H 
ATOM   1129  HZ  PHE    70      -7.562   9.619  -0.732  1.00 25.51           H 
ATOM   1130  N   ASP    71     -10.680   7.271   6.348  1.00 63.45           N 
ATOM   1131  CA  ASP    71     -11.475   6.607   7.389  1.00 22.44           C 
ATOM   1132  C   ASP    71     -11.839   5.165   6.993  1.00 43.34           C 
ATOM   1133  O   ASP    71     -11.631   4.748   5.851  1.00  5.53           O 
ATOM   1134  CB  ASP    71     -12.743   7.423   7.683  1.00 60.43           C 
ATOM   1135  CG  ASP    71     -13.539   7.750   6.428  1.00  5.44           C 
ATOM   1136  OD1 ASP    71     -13.103   8.641   5.662  1.00 24.11           O 
ATOM   1137  OD2 ASP    71     -14.605   7.139   6.212  1.00 44.40           O 
ATOM   1138  H   ASP    71     -11.130   7.882   5.728  1.00 38.03           H 
ATOM   1139  HA  ASP    71     -10.872   6.571   8.287  1.00 23.25           H 
ATOM   1140 1HB  ASP    71     -12.462   8.352   8.160  1.00 31.40           H 
ATOM   1141 2HB  ASP    71     -13.377   6.862   8.356  1.00 50.14           H 
ATOM   1142  N   TYR    72     -12.387   4.409   7.939  1.00 54.40           N 
ATOM   1143  CA  TYR    72     -12.694   2.995   7.708  1.00 21.44           C 
ATOM   1144  C   TYR    72     -13.829   2.819   6.679  1.00 41.34           C 
ATOM   1145  O   TYR    72     -14.887   3.438   6.789  1.00 11.10           O 
ATOM   1146  CB  TYR    72     -13.053   2.301   9.032  1.00  1.03           C 
ATOM   1147  CG  TYR    72     -13.052   0.784   8.942  1.00  3.21           C 
ATOM   1148  CD1 TYR    72     -14.237   0.069   8.842  1.00 22.44           C 
ATOM   1149  CD2 TYR    72     -11.857   0.071   8.942  1.00 34.13           C 
ATOM   1150  CE1 TYR    72     -14.233  -1.309   8.741  1.00 14.34           C 
ATOM   1151  CE2 TYR    72     -11.847  -1.307   8.847  1.00 13.42           C 
ATOM   1152  CZ  TYR    72     -13.037  -1.991   8.745  1.00 60.12           C 
ATOM   1153  OH  TYR    72     -13.032  -3.364   8.625  1.00 62.34           O 
ATOM   1154  H   TYR    72     -12.592   4.810   8.812  1.00 38.03           H 
ATOM   1155  HA  TYR    72     -11.800   2.532   7.311  1.00 60.11           H 
ATOM   1156 1HB  TYR    72     -14.039   2.619   9.345  1.00 54.01           H 
ATOM   1157 2HB  TYR    72     -12.334   2.586   9.787  1.00 34.31           H 
ATOM   1158  HD1 TYR    72     -15.176   0.605   8.839  1.00  5.23           H 
ATOM   1159  HD2 TYR    72     -10.923   0.609   9.024  1.00 52.15           H 
ATOM   1160  HE1 TYR    72     -15.168  -1.846   8.664  1.00  3.33           H 
ATOM   1161  HE2 TYR    72     -10.907  -1.842   8.850  1.00 62.23           H 
ATOM   1162  HH  TYR    72     -12.488  -3.751   9.328  1.00 23.03           H 
ATOM   1163  N   ASN    73     -13.582   1.962   5.685  1.00 13.32           N 
ATOM   1164  CA  ASN    73     -14.537   1.676   4.597  1.00  4.03           C 
ATOM   1165  C   ASN    73     -14.728   2.865   3.634  1.00 14.10           C 
ATOM   1166  O   ASN    73     -15.697   2.903   2.874  1.00  3.25           O 
ATOM   1167  CB  ASN    73     -15.894   1.214   5.147  1.00 41.54           C 
ATOM   1168  CG  ASN    73     -15.807  -0.117   5.875  1.00 64.11           C 
ATOM   1169  OD1 ASN    73     -14.941  -0.947   5.599  1.00  1.31           O 
ATOM   1170  ND2 ASN    73     -16.713  -0.339   6.806  1.00 23.20           N 
ATOM   1171  H   ASN    73     -12.724   1.494   5.682  1.00 38.03           H 
ATOM   1172  HA  ASN    73     -14.112   0.863   4.025  1.00 54.20           H 
ATOM   1173 1HB  ASN    73     -16.593   1.108   4.330  1.00 33.52           H 
ATOM   1174 2HB  ASN    73     -16.266   1.956   5.838  1.00 42.32           H 
ATOM   1175 1HD2 ASN    73     -17.383   0.356   6.974  1.00  1.51           H 
ATOM   1176 2HD2 ASN    73     -16.683  -1.191   7.284  1.00 64.11           H 
ATOM   1177  N   ALA    74     -13.795   3.815   3.642  1.00  3.42           N 
ATOM   1178  CA  ALA    74     -13.822   4.925   2.681  1.00 54.43           C 
ATOM   1179  C   ALA    74     -13.658   4.409   1.238  1.00 73.01           C 
ATOM   1180  O   ALA    74     -12.775   3.594   0.963  1.00 73.12           O 
ATOM   1181  CB  ALA    74     -12.731   5.939   3.015  1.00 22.14           C 
ATOM   1182  H   ALA    74     -13.082   3.780   4.313  1.00 38.03           H 
ATOM   1183  HA  ALA    74     -14.780   5.420   2.772  1.00 45.41           H 
ATOM   1184 1HB  ALA    74     -12.802   6.783   2.342  1.00 41.33           H 
ATOM   1185 2HB  ALA    74     -11.761   5.474   2.907  1.00 32.44           H 
ATOM   1186 3HB  ALA    74     -12.854   6.280   4.032  1.00 34.34           H 
ATOM   1187  N   ARG    75     -14.512   4.882   0.326  1.00 13.04           N 
ATOM   1188  CA  ARG    75     -14.486   4.421  -1.072  1.00 13.00           C 
ATOM   1189  C   ARG    75     -13.323   5.045  -1.861  1.00 24.42           C 
ATOM   1190  O   ARG    75     -13.255   6.266  -2.036  1.00 42.21           O 
ATOM   1191  CB  ARG    75     -15.804   4.750  -1.784  1.00 65.32           C 
ATOM   1192  CG  ARG    75     -17.039   4.090  -1.176  1.00 21.11           C 
ATOM   1193  CD  ARG    75     -18.289   4.422  -1.989  1.00 12.53           C 
ATOM   1194  NE  ARG    75     -18.418   5.863  -2.198  1.00 40.25           N 
ATOM   1195  CZ  ARG    75     -18.634   6.429  -3.356  1.00 23.40           C 
ATOM   1196  NH1 ARG    75     -18.852   5.721  -4.415  1.00 63.33           N 
ATOM   1197  NH2 ARG    75     -18.643   7.715  -3.447  1.00 23.23           N 
ATOM   1198  H   ARG    75     -15.168   5.556   0.596  1.00 38.03           H 
ATOM   1199  HA  ARG    75     -14.359   3.346  -1.061  1.00 40.51           H 
ATOM   1200 1HB  ARG    75     -15.727   4.433  -2.815  1.00 41.21           H 
ATOM   1201 2HB  ARG    75     -15.952   5.821  -1.761  1.00 74.01           H 
ATOM   1202 1HG  ARG    75     -17.169   4.448  -0.165  1.00 64.41           H 
ATOM   1203 2HG  ARG    75     -16.900   3.017  -1.167  1.00 34.31           H 
ATOM   1204 1HD  ARG    75     -19.158   4.064  -1.454  1.00 24.01           H 
ATOM   1205 2HD  ARG    75     -18.226   3.924  -2.947  1.00 62.41           H 
ATOM   1206  HE  ARG    75     -18.306   6.440  -1.419  1.00 35.10           H 
ATOM   1207 1HH1 ARG    75     -18.861   4.723  -4.359  1.00 31.31           H 
ATOM   1208 2HH1 ARG    75     -19.016   6.173  -5.288  1.00 14.15           H 
ATOM   1209 1HH2 ARG    75     -18.486   8.277  -2.638  1.00 12.33           H 
ATOM   1210 2HH2 ARG    75     -18.793   8.147  -4.335  1.00 44.00           H 
ATOM   1211  N   VAL    76     -12.430   4.194  -2.352  1.00 23.23           N 
ATOM   1212  CA  VAL    76     -11.267   4.629  -3.132  1.00 71.52           C 
ATOM   1213  C   VAL    76     -11.213   3.929  -4.502  1.00 34.20           C 
ATOM   1214  O   VAL    76     -11.861   2.904  -4.715  1.00  0.23           O 
ATOM   1215  CB  VAL    76      -9.945   4.344  -2.365  1.00 62.45           C 
ATOM   1216  CG1 VAL    76      -9.910   5.100  -1.036  1.00 24.15           C 
ATOM   1217  CG2 VAL    76      -9.759   2.844  -2.137  1.00 25.22           C 
ATOM   1218  H   VAL    76     -12.555   3.234  -2.188  1.00 38.03           H 
ATOM   1219  HA  VAL    76     -11.343   5.698  -3.291  1.00 41.24           H 
ATOM   1220  HB  VAL    76      -9.120   4.698  -2.970  1.00 15.10           H 
ATOM   1221 1HG1 VAL    76      -9.933   6.164  -1.225  1.00 20.51           H 
ATOM   1222 2HG1 VAL    76      -9.004   4.851  -0.502  1.00 64.32           H 
ATOM   1223 3HG1 VAL    76     -10.767   4.821  -0.440  1.00 45.43           H 
ATOM   1224 1HG2 VAL    76      -9.726   2.334  -3.089  1.00 32.52           H 
ATOM   1225 2HG2 VAL    76     -10.583   2.460  -1.552  1.00 51.41           H 
ATOM   1226 3HG2 VAL    76      -8.832   2.671  -1.607  1.00 53.41           H 
ATOM   1227  N   GLU    77     -10.453   4.501  -5.432  1.00 32.14           N 
ATOM   1228  CA  GLU    77     -10.163   3.849  -6.713  1.00 22.31           C 
ATOM   1229  C   GLU    77      -8.687   4.055  -7.095  1.00 72.21           C 
ATOM   1230  O   GLU    77      -8.079   5.078  -6.765  1.00 44.33           O 
ATOM   1231  CB  GLU    77     -11.103   4.349  -7.827  1.00 13.43           C 
ATOM   1232  CG  GLU    77     -11.015   5.843  -8.125  1.00 43.32           C 
ATOM   1233  CD  GLU    77     -11.925   6.257  -9.279  1.00 25.33           C 
ATOM   1234  OE1 GLU    77     -11.507   6.124 -10.449  1.00 24.54           O 
ATOM   1235  OE2 GLU    77     -13.062   6.712  -9.023  1.00 41.11           O 
ATOM   1236  H   GLU    77     -10.080   5.390  -5.259  1.00 38.03           H 
ATOM   1237  HA  GLU    77     -10.326   2.787  -6.576  1.00  5.11           H 
ATOM   1238 1HB  GLU    77     -12.122   4.122  -7.542  1.00  2.14           H 
ATOM   1239 2HB  GLU    77     -10.873   3.812  -8.737  1.00 14.51           H 
ATOM   1240 1HG  GLU    77      -9.994   6.087  -8.384  1.00 52.12           H 
ATOM   1241 2HG  GLU    77     -11.301   6.394  -7.240  1.00 50.11           H 
ATOM   1242  N   LEU    78      -8.109   3.065  -7.772  1.00 40.24           N 
ATOM   1243  CA  LEU    78      -6.675   3.073  -8.084  1.00 22.12           C 
ATOM   1244  C   LEU    78      -6.398   3.578  -9.507  1.00 42.24           C 
ATOM   1245  O   LEU    78      -7.094   3.215 -10.453  1.00 12.11           O 
ATOM   1246  CB  LEU    78      -6.097   1.662  -7.906  1.00 52.00           C 
ATOM   1247  CG  LEU    78      -6.233   1.076  -6.491  1.00 43.42           C 
ATOM   1248  CD1 LEU    78      -5.671  -0.344  -6.429  1.00 60.04           C 
ATOM   1249  CD2 LEU    78      -5.536   1.975  -5.472  1.00  3.22           C 
ATOM   1250  H   LEU    78      -8.659   2.316  -8.078  1.00 38.03           H 
ATOM   1251  HA  LEU    78      -6.188   3.737  -7.380  1.00  1.01           H 
ATOM   1252 1HB  LEU    78      -5.046   1.687  -8.161  1.00 42.52           H 
ATOM   1253 2HB  LEU    78      -6.601   1.001  -8.598  1.00 31.43           H 
ATOM   1254  HG  LEU    78      -7.281   1.027  -6.231  1.00 74.22           H 
ATOM   1255 1HD1 LEU    78      -4.619  -0.329  -6.676  1.00 55.42           H 
ATOM   1256 2HD1 LEU    78      -6.198  -0.970  -7.135  1.00 30.02           H 
ATOM   1257 3HD1 LEU    78      -5.801  -0.739  -5.432  1.00  2.23           H 
ATOM   1258 1HD2 LEU    78      -5.991   2.954  -5.487  1.00 32.14           H 
ATOM   1259 2HD2 LEU    78      -4.488   2.062  -5.724  1.00 33.34           H 
ATOM   1260 3HD2 LEU    78      -5.635   1.547  -4.486  1.00 72.01           H 
ATOM   1261  N   ILE    79      -5.368   4.417  -9.643  1.00 25.14           N 
ATOM   1262  CA  ILE    79      -4.958   4.942 -10.951  1.00 43.41           C 
ATOM   1263  C   ILE    79      -4.476   3.812 -11.886  1.00 73.05           C 
ATOM   1264  O   ILE    79      -5.153   3.457 -12.851  1.00 44.23           O 
ATOM   1265  CB  ILE    79      -3.839   6.008 -10.796  1.00 40.13           C 
ATOM   1266  CG1 ILE    79      -4.319   7.170  -9.905  1.00 12.55           C 
ATOM   1267  CG2 ILE    79      -3.382   6.525 -12.164  1.00 51.40           C 
ATOM   1268  CD1 ILE    79      -5.550   7.886 -10.433  1.00 75.21           C 
ATOM   1269  H   ILE    79      -4.882   4.704  -8.839  1.00 38.03           H 
ATOM   1270  HA  ILE    79      -5.819   5.420 -11.399  1.00 31.23           H 
ATOM   1271  HB  ILE    79      -2.991   5.531 -10.320  1.00 74.45           H 
ATOM   1272 1HG1 ILE    79      -3.526   7.899  -9.815  1.00 62.13           H 
ATOM   1273 2HG1 ILE    79      -4.560   6.787  -8.925  1.00 31.02           H 
ATOM   1274 1HG2 ILE    79      -2.995   5.703 -12.748  1.00 24.34           H 
ATOM   1275 2HG2 ILE    79      -2.605   7.264 -12.030  1.00 62.44           H 
ATOM   1276 3HG2 ILE    79      -4.218   6.971 -12.684  1.00 73.32           H 
ATOM   1277 1HD1 ILE    79      -5.834   8.667  -9.742  1.00 22.12           H 
ATOM   1278 2HD1 ILE    79      -6.362   7.181 -10.532  1.00 60.43           H 
ATOM   1279 3HD1 ILE    79      -5.329   8.321 -11.396  1.00 42.11           H 
ATOM   1280  N   ASN    80      -3.303   3.246 -11.589  1.00 21.31           N 
ATOM   1281  CA  ASN    80      -2.762   2.115 -12.362  1.00 64.23           C 
ATOM   1282  C   ASN    80      -2.489   0.894 -11.459  1.00  3.43           C 
ATOM   1283  O   ASN    80      -1.371   0.707 -10.976  1.00  4.41           O 
ATOM   1284  CB  ASN    80      -1.473   2.533 -13.090  1.00 22.30           C 
ATOM   1285  CG  ASN    80      -1.718   3.570 -14.171  1.00 21.15           C 
ATOM   1286  OD1 ASN    80      -2.761   3.576 -14.819  1.00 11.25           O 
ATOM   1287  ND2 ASN    80      -0.764   4.458 -14.373  1.00 35.24           N 
ATOM   1288  H   ASN    80      -2.786   3.599 -10.840  1.00 38.03           H 
ATOM   1289  HA  ASN    80      -3.502   1.834 -13.101  1.00 55.40           H 
ATOM   1290 1HB  ASN    80      -1.030   1.663 -13.553  1.00 70.33           H 
ATOM   1291 2HB  ASN    80      -0.777   2.945 -12.371  1.00 14.50           H 
ATOM   1292 1HD2 ASN    80       0.047   4.406 -13.823  1.00 11.45           H 
ATOM   1293 2HD2 ASN    80      -0.906   5.136 -15.063  1.00 65.41           H 
ATOM   1294  N   PRO    81      -3.527   0.078 -11.171  1.00 53.23           N 
ATOM   1295  CA  PRO    81      -3.382  -1.154 -10.376  1.00 53.25           C 
ATOM   1296  C   PRO    81      -2.892  -2.365 -11.198  1.00  1.13           C 
ATOM   1297  O   PRO    81      -3.416  -2.652 -12.278  1.00 73.44           O 
ATOM   1298  CB  PRO    81      -4.806  -1.391  -9.869  1.00 32.31           C 
ATOM   1299  CG  PRO    81      -5.685  -0.856 -10.954  1.00 61.55           C 
ATOM   1300  CD  PRO    81      -4.929   0.291 -11.593  1.00 34.01           C 
ATOM   1301  HA  PRO    81      -2.722  -1.003  -9.534  1.00  3.11           H 
ATOM   1302 1HB  PRO    81      -4.956  -0.857  -8.940  1.00 71.34           H 
ATOM   1303 2HB  PRO    81      -4.970  -2.450  -9.707  1.00 21.21           H 
ATOM   1304 1HG  PRO    81      -6.617  -0.503 -10.533  1.00 30.11           H 
ATOM   1305 2HG  PRO    81      -5.877  -1.629 -11.686  1.00 60.32           H 
ATOM   1306 1HD  PRO    81      -5.301   1.239 -11.228  1.00 22.54           H 
ATOM   1307 2HD  PRO    81      -5.015   0.247 -12.670  1.00 33.01           H 
ATOM   1308  N   ILE    82      -1.890  -3.078 -10.681  1.00 43.24           N 
ATOM   1309  CA  ILE    82      -1.396  -4.309 -11.319  1.00 41.02           C 
ATOM   1310  C   ILE    82      -1.141  -5.420 -10.281  1.00 32.45           C 
ATOM   1311  O   ILE    82      -0.425  -5.216  -9.301  1.00 34.22           O 
ATOM   1312  CB  ILE    82      -0.092  -4.064 -12.136  1.00 64.33           C 
ATOM   1313  CG1 ILE    82       1.019  -3.474 -11.247  1.00 43.23           C 
ATOM   1314  CG2 ILE    82      -0.370  -3.152 -13.332  1.00 21.32           C 
ATOM   1315  CD1 ILE    82       2.336  -3.259 -11.969  1.00 73.13           C 
ATOM   1316  H   ILE    82      -1.461  -2.768  -9.856  1.00 38.03           H 
ATOM   1317  HA  ILE    82      -2.161  -4.654 -12.007  1.00 32.21           H 
ATOM   1318  HB  ILE    82       0.240  -5.019 -12.523  1.00 22.44           H 
ATOM   1319 1HG1 ILE    82       1.203  -4.142 -10.416  1.00 71.41           H 
ATOM   1320 2HG1 ILE    82       0.698  -2.517 -10.865  1.00 34.35           H 
ATOM   1321 1HG2 ILE    82      -1.116  -3.607 -13.969  1.00 62.44           H 
ATOM   1322 2HG2 ILE    82       0.540  -3.004 -13.894  1.00 40.34           H 
ATOM   1323 3HG2 ILE    82      -0.735  -2.197 -12.980  1.00 32.53           H 
ATOM   1324 1HD1 ILE    82       2.189  -2.570 -12.787  1.00 55.44           H 
ATOM   1325 2HD1 ILE    82       2.694  -4.203 -12.352  1.00 30.45           H 
ATOM   1326 3HD1 ILE    82       3.062  -2.852 -11.281  1.00 74.40           H 
ATOM   1522  N   TRP    98      -3.272 -12.238  -1.997  1.00 52.11           N 
ATOM   1523  CA  TRP    98      -2.596 -11.809  -3.231  1.00 31.31           C 
ATOM   1524  C   TRP    98      -2.266 -10.302  -3.225  1.00 41.53           C 
ATOM   1525  O   TRP    98      -2.963  -9.494  -2.596  1.00 63.02           O 
ATOM   1526  CB  TRP    98      -3.422 -12.203  -4.470  1.00 24.41           C 
ATOM   1527  CG  TRP    98      -4.794 -11.582  -4.565  1.00  1.04           C 
ATOM   1528  CD1 TRP    98      -5.825 -11.680  -3.668  1.00 63.52           C 
ATOM   1529  CD2 TRP    98      -5.293 -10.800  -5.659  1.00 20.14           C 
ATOM   1530  NE1 TRP    98      -6.918 -10.987  -4.131  1.00 12.34           N 
ATOM   1531  CE2 TRP    98      -6.617 -10.441  -5.350  1.00 20.23           C 
ATOM   1532  CE3 TRP    98      -4.740 -10.358  -6.866  1.00 55.14           C 
ATOM   1533  CZ2 TRP    98      -7.397  -9.666  -6.204  1.00 50.04           C 
ATOM   1534  CZ3 TRP    98      -5.518  -9.593  -7.715  1.00 42.13           C 
ATOM   1535  CH2 TRP    98      -6.833  -9.253  -7.378  1.00  4.41           C 
ATOM   1536  H   TRP    98      -4.237 -12.123  -1.915  1.00 38.03           H 
ATOM   1537  HA  TRP    98      -1.656 -12.345  -3.273  1.00 23.20           H 
ATOM   1538 1HB  TRP    98      -3.547 -13.279  -4.472  1.00 44.21           H 
ATOM   1539 2HB  TRP    98      -2.874 -11.920  -5.355  1.00 10.30           H 
ATOM   1540  HD1 TRP    98      -5.773 -12.219  -2.734  1.00 74.05           H 
ATOM   1541  HE1 TRP    98      -7.776 -10.901  -3.668  1.00 53.32           H 
ATOM   1542  HE3 TRP    98      -3.725 -10.612  -7.143  1.00 44.14           H 
ATOM   1543  HZ2 TRP    98      -8.413  -9.395  -5.962  1.00 50.34           H 
ATOM   1544  HZ3 TRP    98      -5.110  -9.244  -8.652  1.00 40.34           H 
ATOM   1545  HH2 TRP    98      -7.404  -8.651  -8.071  1.00 41.45           H 
ATOM   1546  N   TYR    99      -1.190  -9.935  -3.933  1.00  2.54           N 
ATOM   1547  CA  TYR    99      -0.641  -8.572  -3.880  1.00 42.23           C 
ATOM   1548  C   TYR    99      -0.921  -7.778  -5.170  1.00 64.31           C 
ATOM   1549  O   TYR    99      -0.794  -8.292  -6.289  1.00 13.43           O 
ATOM   1550  CB  TYR    99       0.877  -8.622  -3.635  1.00 13.40           C 
ATOM   1551  CG  TYR    99       1.301  -9.557  -2.514  1.00 20.04           C 
ATOM   1552  CD1 TYR    99       1.410 -10.928  -2.732  1.00 14.32           C 
ATOM   1553  CD2 TYR    99       1.602  -9.074  -1.245  1.00  2.34           C 
ATOM   1554  CE1 TYR    99       1.805 -11.784  -1.725  1.00 51.01           C 
ATOM   1555  CE2 TYR    99       1.997  -9.928  -0.230  1.00 31.23           C 
ATOM   1556  CZ  TYR    99       2.096 -11.282  -0.476  1.00 65.03           C 
ATOM   1557  OH  TYR    99       2.502 -12.137   0.524  1.00 51.23           O 
ATOM   1558  H   TYR    99      -0.754 -10.594  -4.512  1.00 38.03           H 
ATOM   1559  HA  TYR    99      -1.107  -8.059  -3.049  1.00 12.12           H 
ATOM   1560 1HB  TYR    99       1.226  -7.627  -3.389  1.00 30.30           H 
ATOM   1561 2HB  TYR    99       1.370  -8.950  -4.540  1.00 63.42           H 
ATOM   1562  HD1 TYR    99       1.179 -11.323  -3.711  1.00 74.51           H 
ATOM   1563  HD2 TYR    99       1.524  -8.015  -1.055  1.00 23.33           H 
ATOM   1564  HE1 TYR    99       1.883 -12.845  -1.917  1.00 44.10           H 
ATOM   1565  HE2 TYR    99       2.224  -9.532   0.750  1.00 54.41           H 
ATOM   1566  HH  TYR    99       3.099 -12.804   0.150  1.00  2.41           H 
ATOM   1567  N   ILE   100      -1.292  -6.512  -4.996  1.00 53.54           N 
ATOM   1568  CA  ILE   100      -1.574  -5.603  -6.109  1.00  0.02           C 
ATOM   1569  C   ILE   100      -0.750  -4.310  -5.978  1.00 22.31           C 
ATOM   1570  O   ILE   100      -0.997  -3.486  -5.094  1.00 40.45           O 
ATOM   1571  CB  ILE   100      -3.082  -5.232  -6.161  1.00 71.22           C 
ATOM   1572  CG1 ILE   100      -3.957  -6.497  -6.166  1.00 71.54           C 
ATOM   1573  CG2 ILE   100      -3.388  -4.363  -7.382  1.00 33.23           C 
ATOM   1574  CD1 ILE   100      -5.445  -6.209  -6.151  1.00 33.02           C 
ATOM   1575  H   ILE   100      -1.375  -6.173  -4.083  1.00 38.03           H 
ATOM   1576  HA  ILE   100      -1.310  -6.101  -7.033  1.00 30.45           H 
ATOM   1577  HB  ILE   100      -3.313  -4.654  -5.278  1.00 12.22           H 
ATOM   1578 1HG1 ILE   100      -3.726  -7.091  -5.293  1.00  2.23           H 
ATOM   1579 2HG1 ILE   100      -3.744  -7.075  -7.053  1.00  3.54           H 
ATOM   1580 1HG2 ILE   100      -2.835  -3.436  -7.313  1.00 21.42           H 
ATOM   1581 2HG2 ILE   100      -4.448  -4.148  -7.416  1.00 60.35           H 
ATOM   1582 3HG2 ILE   100      -3.101  -4.886  -8.282  1.00  4.45           H 
ATOM   1583 1HD1 ILE   100      -5.719  -5.676  -7.050  1.00 42.11           H 
ATOM   1584 2HD1 ILE   100      -5.685  -5.606  -5.288  1.00 21.24           H 
ATOM   1585 3HD1 ILE   100      -5.989  -7.139  -6.101  1.00 24.33           H 
ATOM   1586  N   LYS   101       0.239  -4.139  -6.846  1.00 12.11           N 
ATOM   1587  CA  LYS   101       1.051  -2.918  -6.859  1.00 73.54           C 
ATOM   1588  C   LYS   101       0.338  -1.805  -7.648  1.00 12.02           C 
ATOM   1589  O   LYS   101      -0.107  -2.019  -8.774  1.00 32.32           O 
ATOM   1590  CB  LYS   101       2.437  -3.212  -7.457  1.00 61.50           C 
ATOM   1591  CG  LYS   101       3.256  -4.207  -6.631  1.00 73.44           C 
ATOM   1592  CD  LYS   101       4.543  -4.635  -7.339  1.00 21.22           C 
ATOM   1593  CE  LYS   101       5.499  -3.466  -7.569  1.00 64.11           C 
ATOM   1594  NZ  LYS   101       6.079  -2.944  -6.301  1.00  2.01           N 
ATOM   1595  H   LYS   101       0.427  -4.847  -7.500  1.00 38.03           H 
ATOM   1596  HA  LYS   101       1.176  -2.591  -5.832  1.00 41.33           H 
ATOM   1597 1HB  LYS   101       2.993  -2.288  -7.524  1.00  0.35           H 
ATOM   1598 2HB  LYS   101       2.308  -3.617  -8.452  1.00 23.23           H 
ATOM   1599 1HG  LYS   101       2.651  -5.085  -6.447  1.00 73.44           H 
ATOM   1600 2HG  LYS   101       3.514  -3.748  -5.688  1.00 72.03           H 
ATOM   1601 1HD  LYS   101       4.287  -5.072  -8.295  1.00 35.31           H 
ATOM   1602 2HD  LYS   101       5.043  -5.377  -6.732  1.00  5.24           H 
ATOM   1603 1HE  LYS   101       4.961  -2.669  -8.062  1.00 34.32           H 
ATOM   1604 2HE  LYS   101       6.305  -3.800  -8.205  1.00  3.21           H 
ATOM   1605 1HZ  LYS   101       6.652  -2.098  -6.493  1.00 63.31           H 
ATOM   1606 2HZ  LYS   101       6.690  -3.660  -5.858  1.00 45.02           H 
ATOM   1607 3HZ  LYS   101       5.325  -2.687  -5.631  1.00 31.44           H 
ATOM   1608  N   ALA   102       0.218  -0.624  -7.053  1.00 61.52           N 
ATOM   1609  CA  ALA   102      -0.539   0.473  -7.668  1.00  3.33           C 
ATOM   1610  C   ALA   102       0.318   1.727  -7.878  1.00  3.40           C 
ATOM   1611  O   ALA   102       1.429   1.836  -7.360  1.00 52.31           O 
ATOM   1612  CB  ALA   102      -1.755   0.806  -6.812  1.00 54.03           C 
ATOM   1613  H   ALA   102       0.648  -0.480  -6.183  1.00 38.03           H 
ATOM   1614  HA  ALA   102      -0.896   0.134  -8.632  1.00 11.12           H 
ATOM   1615 1HB  ALA   102      -1.429   1.159  -5.846  1.00 23.00           H 
ATOM   1616 2HB  ALA   102      -2.359  -0.081  -6.686  1.00 45.04           H 
ATOM   1617 3HB  ALA   102      -2.341   1.574  -7.296  1.00 54.13           H 
ATOM   1618  N   ASP   103      -0.212   2.666  -8.659  1.00 12.21           N 
ATOM   1619  CA  ASP   103       0.462   3.940  -8.912  1.00 64.42           C 
ATOM   1620  C   ASP   103       0.124   4.976  -7.823  1.00  0.21           C 
ATOM   1621  O   ASP   103       1.004   5.451  -7.108  1.00 15.41           O 
ATOM   1622  CB  ASP   103       0.057   4.465 -10.293  1.00 32.04           C 
ATOM   1623  CG  ASP   103       0.787   5.739 -10.671  1.00 53.14           C 
ATOM   1624  OD1 ASP   103       2.033   5.764 -10.573  1.00 54.02           O 
ATOM   1625  OD2 ASP   103       0.125   6.712 -11.077  1.00 11.52           O 
ATOM   1626  H   ASP   103      -1.070   2.491  -9.088  1.00 38.03           H 
ATOM   1627  HA  ASP   103       1.528   3.761  -8.905  1.00 11.53           H 
ATOM   1628 1HB  ASP   103      -1.007   4.660 -10.297  1.00 12.14           H 
ATOM   1629 2HB  ASP   103       0.280   3.712 -11.035  1.00 63.35           H 
ATOM   1630  N   ASP   104      -1.160   5.322  -7.715  1.00  3.13           N 
ATOM   1631  CA  ASP   104      -1.636   6.256  -6.692  1.00 71.02           C 
ATOM   1632  C   ASP   104      -3.047   5.875  -6.206  1.00  0.20           C 
ATOM   1633  O   ASP   104      -3.814   5.222  -6.921  1.00 51.02           O 
ATOM   1634  CB  ASP   104      -1.622   7.694  -7.233  1.00 11.24           C 
ATOM   1635  CG  ASP   104      -2.112   8.710  -6.210  1.00 23.30           C 
ATOM   1636  OD1 ASP   104      -1.689   8.633  -5.036  1.00 20.20           O 
ATOM   1637  OD2 ASP   104      -2.921   9.591  -6.571  1.00 12.23           O 
ATOM   1638  H   ASP   104      -1.803   4.945  -8.342  1.00 38.03           H 
ATOM   1639  HA  ASP   104      -0.958   6.195  -5.850  1.00 40.13           H 
ATOM   1640 1HB  ASP   104      -2.256   7.748  -8.108  1.00  4.52           H 
ATOM   1641 2HB  ASP   104      -0.611   7.954  -7.513  1.00 61.23           H 
ATOM   1642  N   ILE   105      -3.368   6.288  -4.980  1.00 32.15           N 
ATOM   1643  CA  ILE   105      -4.660   5.981  -4.350  1.00 41.35           C 
ATOM   1644  C   ILE   105      -5.524   7.247  -4.182  1.00 60.42           C 
ATOM   1645  O   ILE   105      -5.167   8.155  -3.429  1.00 60.12           O 
ATOM   1646  CB  ILE   105      -4.451   5.330  -2.955  1.00 43.41           C 
ATOM   1647  CG1 ILE   105      -3.690   3.997  -3.087  1.00 33.31           C 
ATOM   1648  CG2 ILE   105      -5.791   5.128  -2.243  1.00 10.35           C 
ATOM   1649  CD1 ILE   105      -3.415   3.310  -1.764  1.00  1.21           C 
ATOM   1650  H   ILE   105      -2.714   6.824  -4.485  1.00 38.03           H 
ATOM   1651  HA  ILE   105      -5.187   5.276  -4.981  1.00 62.24           H 
ATOM   1652  HB  ILE   105      -3.861   6.010  -2.356  1.00  0.50           H 
ATOM   1653 1HG1 ILE   105      -2.738   4.178  -3.568  1.00 32.53           H 
ATOM   1654 2HG1 ILE   105      -4.268   3.317  -3.694  1.00 13.25           H 
ATOM   1655 1HG2 ILE   105      -5.623   4.655  -1.286  1.00 22.05           H 
ATOM   1656 2HG2 ILE   105      -6.433   4.501  -2.845  1.00 64.15           H 
ATOM   1657 3HG2 ILE   105      -6.266   6.087  -2.088  1.00 74.44           H 
ATOM   1658 1HD1 ILE   105      -2.895   2.379  -1.944  1.00 25.33           H 
ATOM   1659 2HD1 ILE   105      -4.348   3.107  -1.259  1.00  0.54           H 
ATOM   1660 3HD1 ILE   105      -2.801   3.949  -1.145  1.00 11.23           H 
ATOM   1661  N   VAL   106      -6.659   7.297  -4.877  1.00 63.30           N 
ATOM   1662  CA  VAL   106      -7.599   8.426  -4.762  1.00 43.31           C 
ATOM   1663  C   VAL   106      -8.998   7.940  -4.353  1.00 22.13           C 
ATOM   1664  O   VAL   106      -9.250   6.741  -4.298  1.00 30.54           O 
ATOM   1665  CB  VAL   106      -7.700   9.217  -6.090  1.00  3.43           C 
ATOM   1666  CG1 VAL   106      -6.349   9.820  -6.469  1.00 65.25           C 
ATOM   1667  CG2 VAL   106      -8.233   8.327  -7.214  1.00 21.03           C 
ATOM   1668  H   VAL   106      -6.881   6.554  -5.483  1.00 38.03           H 
ATOM   1669  HA  VAL   106      -7.227   9.094  -3.995  1.00 32.31           H 
ATOM   1670  HB  VAL   106      -8.399  10.031  -5.945  1.00 14.53           H 
ATOM   1671 1HG1 VAL   106      -6.017  10.484  -5.683  1.00 65.21           H 
ATOM   1672 2HG1 VAL   106      -6.447  10.378  -7.391  1.00 22.24           H 
ATOM   1673 3HG1 VAL   106      -5.624   9.030  -6.603  1.00 61.32           H 
ATOM   1674 1HG2 VAL   106      -8.307   8.902  -8.125  1.00 33.22           H 
ATOM   1675 2HG2 VAL   106      -9.210   7.955  -6.946  1.00 22.33           H 
ATOM   1676 3HG2 VAL   106      -7.561   7.494  -7.367  1.00 33.51           H 
ATOM   1677  N   LEU   107      -9.903   8.871  -4.059  1.00  1.10           N 
ATOM   1678  CA  LEU   107     -11.288   8.516  -3.719  1.00  0.05           C 
ATOM   1679  C   LEU   107     -12.126   8.303  -4.988  1.00 30.30           C 
ATOM   1680  O   LEU   107     -11.865   8.920  -6.022  1.00 73.23           O 
ATOM   1681  CB  LEU   107     -11.928   9.606  -2.845  1.00 33.52           C 
ATOM   1682  CG  LEU   107     -11.286   9.800  -1.461  1.00 45.43           C 
ATOM   1683  CD1 LEU   107     -11.943  10.961  -0.718  1.00 74.32           C 
ATOM   1684  CD2 LEU   107     -11.378   8.519  -0.637  1.00  4.43           C 
ATOM   1685  H   LEU   107      -9.643   9.816  -4.076  1.00 38.03           H 
ATOM   1686  HA  LEU   107     -11.266   7.589  -3.161  1.00 54.51           H 
ATOM   1687 1HB  LEU   107     -12.971   9.360  -2.703  1.00 42.11           H 
ATOM   1688 2HB  LEU   107     -11.867  10.544  -3.380  1.00 43.34           H 
ATOM   1689  HG  LEU   107     -10.241  10.039  -1.591  1.00 13.41           H 
ATOM   1690 1HD1 LEU   107     -12.996  10.756  -0.584  1.00 14.53           H 
ATOM   1691 2HD1 LEU   107     -11.825  11.868  -1.292  1.00 54.44           H 
ATOM   1692 3HD1 LEU   107     -11.475  11.083   0.247  1.00 11.42           H 
ATOM   1693 1HD2 LEU   107     -12.417   8.256  -0.484  1.00 62.53           H 
ATOM   1694 2HD2 LEU   107     -10.902   8.672   0.320  1.00 11.32           H 
ATOM   1695 3HD2 LEU   107     -10.878   7.718  -1.160  1.00 25.04           H 
ATOM   1696  N   THR   108     -13.129   7.431  -4.899  1.00 51.23           N 
ATOM   1697  CA  THR   108     -13.996   7.125  -6.048  1.00  5.21           C 
ATOM   1698  C   THR   108     -14.769   8.370  -6.513  1.00 43.13           C 
ATOM   1699  O   THR   108     -15.734   8.790  -5.870  1.00 43.21           O 
ATOM   1700  CB  THR   108     -15.012   6.001  -5.716  1.00 21.32           C 
ATOM   1701  OG1 THR   108     -14.351   4.906  -5.062  1.00 45.23           O 
ATOM   1702  CG2 THR   108     -15.699   5.489  -6.981  1.00 75.40           C 
ATOM   1703  H   THR   108     -13.288   6.971  -4.047  1.00 38.03           H 
ATOM   1704  HA  THR   108     -13.365   6.783  -6.856  1.00 53.41           H 
ATOM   1705  HB  THR   108     -15.767   6.402  -5.055  1.00 41.42           H 
ATOM   1706  HG1 THR   108     -13.718   4.503  -5.665  1.00 55.30           H 
ATOM   1707 1HG2 THR   108     -16.392   4.702  -6.722  1.00 31.42           H 
ATOM   1708 2HG2 THR   108     -14.955   5.103  -7.665  1.00 33.42           H 
ATOM   1709 3HG2 THR   108     -16.235   6.300  -7.454  1.00 52.32           H 
END
