
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  104 (  838),  selected  104 , name 2ob9_B
# Molecule2: number of CA atoms  121 (  985),  selected  121 , name T0465.pdb
# PARAMETERS: 2ob9_B.T0465.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      E       7           -
LGA    -       -      K       8           -
LGA    -       -      V       9           -
LGA    X     1_B      Y      10           #
LGA    S     2_B      D      11          3.622
LGA    Q     3_B      L      12          5.314
LGA    T     4_B      S      13          3.676
LGA    L     5_B      F      14          4.255
LGA    K     6_B      F      15          4.454
LGA    Q     7_B      M      16          3.006
LGA    L     8_B      P      17          4.632
LGA    -       -      G      18           -
LGA    A     9_B      Q      19           #
LGA    X    10_B      T      20           -
LGA    A    11_B      -       -           -
LGA    K    12_B      -       -           -
LGA    X    13_B      I      21          2.260
LGA    A    14_B      D      22          3.330
LGA    G    15_B      A      23          2.924
LGA    F    16_B      E      24          1.350
LGA    R    17_B      E      25           #
LGA    H    18_B      V      26          0.765
LGA    K    19_B      E      27          2.740
LGA    T    20_B      V      28          2.387
LGA    V    21_B      P      29          0.138
LGA    V    22_B      I      30          4.515
LGA    V    23_B      S      31          1.380
LGA    P    24_B      K      32          4.103
LGA    E    25_B      -       -           -
LGA    W    26_B      -       -           -
LGA    E    27_B      R      33          3.222
LGA    G    28_B      F      34          3.071
LGA    V    29_B      V      35          3.736
LGA    -       -      D      36           -
LGA    -       -      K      37           -
LGA    -       -      E      38           -
LGA    -       -      G      39           -
LGA    -       -      N      40           -
LGA    -       -      V      41           -
LGA    K    30_B      V      42          1.680
LGA    V    31_B      P      43          2.751
LGA    V    32_B      F      44          2.033
LGA    L    33_B      I      45          3.538
LGA    R    34_B      F      46          2.032
LGA    E    35_B      K      47          4.372
LGA    P    36_B      A      48          2.537
LGA    S    37_B      I      49          1.378
LGA    G    38_B      T      50          1.650
LGA    -       -      T      51           -
LGA    E    39_B      D      52          4.463
LGA    A    40_B      R      53          3.984
LGA    W    41_B      I      54          1.942
LGA    L    42_B      D      55          2.436
LGA    R    43_B      E      56          3.151
LGA    W    44_B      L      57          2.879
LGA    Q    45_B      E      58          1.733
LGA    E    46_B      K      59          1.695
LGA    V    47_B      E      60          2.940
LGA    V    48_B      N      61          3.725
LGA    K    49_B      T      62          2.586
LGA    H    64_B      T      63           -
LGA    -       -      K      74           -
LGA    -       -      E      75           -
LGA    -       -      L      76           -
LGA    R    65_B      D      77          2.405
LGA    N    66_B      S      78          2.089
LGA    L    67_B      Q      79          2.904
LGA    C    68_B      R      80          2.796
LGA    A    69_B      F      81          1.297
LGA    D    70_B      Y      82          2.100
LGA    V    71_B      A      83          2.750
LGA    V    72_B      R      84          1.734
LGA    L    73_B      I      85          0.965
LGA    F    74_B      A      86          1.632
LGA    I    75_B      V      87          1.507
LGA    D    76_B      E      88          1.724
LGA    V    77_B      T      89          2.342
LGA    L    78_B      T      90          2.153
LGA    C    79_B      V      91          3.107
LGA    -       -      Y      92           -
LGA    D    80_B      P      93          4.591
LGA    T    81_B      -       -           -
LGA    D    82_B      -       -           -
LGA    K    83_B      -       -           -
LGA    Q    84_B      -       -           -
LGA    P    85_B      -       -           -
LGA    V    86_B      T      94          1.862
LGA    F    87_B      F      95          3.166
LGA    S    88_B      K      96          3.805
LGA    V    89_B      -       -           -
LGA    D    90_B      -       -           -
LGA    E    91_B      A      97           #
LGA    E    92_B      K      98           -
LGA    -       -      E      99           -
LGA    -       -      L     100           -
LGA    -       -      R     101           -
LGA    -       -      E     102           -
LGA    -       -      A     103           -
LGA    -       -      Y     104           -
LGA    -       -      K     105           -
LGA    -       -      T     106           -
LGA    E    93_B      E     107          5.038
LGA    Q    94_B      D     108          1.614
LGA    V    95_B      P     109          1.685
LGA    R    96_B      V     110          3.302
LGA    E    97_B      E     111          3.366
LGA    I    98_B      V     112          4.190
LGA    Y    99_B      A     113          4.271
LGA    G   100_B      K     114          3.470
LGA    -       -      R     115           -
LGA    -       -      V     116           -
LGA    -       -      L     117           -
LGA    -       -      S     118           -
LGA    -       -      V     119           -
LGA    P   101_B      G     120          4.198
LGA    -       -      G     121           -
LGA    V   102_B      E     122          3.909
LGA    H   103_B      Y     123          3.158
LGA    S   104_B      A     124          3.605
LGA    R   105_B      N     125          2.378
LGA    L   106_B      W     126          0.741
LGA    L   107_B      L     127          1.689
LGA    K   108_B      N     128          0.800
LGA    Q   109_B      K     129          2.232
LGA    A   110_B      A     130          2.883
LGA    L   111_B      I     131          2.674
LGA    D   112_B      E     132          3.203
LGA    L   113_B      I     133          3.887
LGA    I   114_B      N     134          4.995
LGA    N   115_B      G     135           #
LGA    -       -      F     136           -
LGA    N   116_B      D     137          5.018
LGA    A   117_B      -       -           -
LGA    D   118_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  104  121    5.0     83    3.07     7.23     39.561     2.622

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.940088 * X  +   0.338919 * Y  +  -0.037001 * Z  +  -6.129017
  Y_new =   0.340565 * X  +   0.938565 * Y  +  -0.055778 * Z  +  -4.613141
  Z_new =   0.015824 * X  +  -0.065037 * Y  +  -0.997757 * Z  +  48.967361 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -3.076501    0.065091  [ DEG:  -176.2705      3.7295 ]
  Theta =  -0.015825   -3.125768  [ DEG:    -0.9067   -179.0933 ]
  Phi   =   2.794029   -0.347564  [ DEG:   160.0861    -19.9139 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ob9_B                                        
REMARK     2: T0465.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ob9_B.T0465.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  104  121   5.0   83   3.07    7.23  39.561
REMARK  ---------------------------------------------------------- 
MOLECULE 2ob9_B
HEADER    CHAPERONE                               18-DEC-06   2OB9              
TITLE     STRUCTURE OF BACTERIOPHAGE HK97 TAIL ASSEMBLY CHAPERONE               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TAIL ASSEMBLY CHAPERONE;                                   
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACTERIOPHAGE HK97;                             
SOURCE   3 ORGANISM_COMMON: VIRUS;                                              
SOURCE   4 GENE: HK97P121;                                                      
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: P11 (MODIFIED PET VECTOR)                 
KEYWDS    BACTERIOPHAGE HK97, MORPHOGENESIS, TAIL ASSEMBLY CHAPERONE            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    T.E.MCGRATH,A.TUITE,D.BONA,V.SARIDAKIS,A.M.EDWARDS,                   
AUTHOR   2 K.MAXWELL,N.Y.CHIRGADZE                                              
REVDAT   1   18-DEC-07 2OB9    0                                                
JRNL        AUTH   A.TUITE,T.E.MCGRATH,D.BONA,A.M.EDWARDS,                      
JRNL        AUTH 2 N.Y.CHIRGADZE,K.MAXWELL                                      
JRNL        TITL   STRUCTURE OF BACTERIOPHAGE HK97 TAIL ASSEMBLY                
JRNL        TITL 2 CHAPERONE                                                    
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.30 ANGSTROMS.                                          
DBREF  2OB9 A    1   128  UNP    Q9MCS6   Q9MCS6_BPHK7     1    128             
DBREF  2OB9 B    1   128  UNP    Q9MCS6   Q9MCS6_BPHK7     1    128             
SEQRES   1 A  130  GLY HIS MSE SER GLN THR LEU LYS GLN LEU ALA MSE ALA          
SEQRES   2 A  130  LYS MSE ALA GLY PHE ARG HIS LYS THR VAL VAL VAL PRO          
SEQRES   3 A  130  GLU TRP GLU GLY VAL LYS VAL VAL LEU ARG GLU PRO SER          
SEQRES   4 A  130  GLY GLU ALA TRP LEU ARG TRP GLN GLU VAL VAL LYS GLY          
SEQRES   5 A  130  GLY GLY ASP ASP GLU ASN VAL SER VAL SER GLU LYS ALA          
SEQRES   6 A  130  HIS ARG ASN LEU CYS ALA ASP VAL VAL LEU PHE ILE ASP          
SEQRES   7 A  130  VAL LEU CYS ASP THR ASP LYS GLN PRO VAL PHE SER VAL          
SEQRES   8 A  130  ASP GLU GLU GLU GLN VAL ARG GLU ILE TYR GLY PRO VAL          
SEQRES   9 A  130  HIS SER ARG LEU LEU LYS GLN ALA LEU ASP LEU ILE ASN          
SEQRES  10 A  130  ASN ALA ASP GLU ALA ARG GLU LYS SER GLN PRO PRO ALA          
SEQRES   1 B  130  GLY HIS MSE SER GLN THR LEU LYS GLN LEU ALA MSE ALA          
SEQRES   2 B  130  LYS MSE ALA GLY PHE ARG HIS LYS THR VAL VAL VAL PRO          
SEQRES   3 B  130  GLU TRP GLU GLY VAL LYS VAL VAL LEU ARG GLU PRO SER          
SEQRES   4 B  130  GLY GLU ALA TRP LEU ARG TRP GLN GLU VAL VAL LYS GLY          
SEQRES   5 B  130  GLY GLY ASP ASP GLU ASN VAL SER VAL SER GLU LYS ALA          
SEQRES   6 B  130  HIS ARG ASN LEU CYS ALA ASP VAL VAL LEU PHE ILE ASP          
SEQRES   7 B  130  VAL LEU CYS ASP THR ASP LYS GLN PRO VAL PHE SER VAL          
SEQRES   8 B  130  ASP GLU GLU GLU GLN VAL ARG GLU ILE TYR GLY PRO VAL          
SEQRES   9 B  130  HIS SER ARG LEU LEU LYS GLN ALA LEU ASP LEU ILE ASN          
SEQRES  10 B  130  ASN ALA ASP GLU ALA ARG GLU LYS SER GLN PRO PRO ALA          
HET    MSE  A  10       8                                                       
HET    MSE  A  13       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  10       8                                                       
HET    MSE  B  13       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    5(C5 H11 N O2 SE)                                            
FORMUL   3  HOH   *53(H2 O)                                                     
CRYST1  101.140  101.140   63.382  90.00  90.00  90.00 I 4          16          
HETATM  859  N   MSE B   1      46.633  -9.183  31.733  1.00 49.53           N  
HETATM  860  CA  MSE B   1      45.991  -9.711  30.478  1.00 49.99           C  
HETATM  861  C   MSE B   1      44.462  -9.724  30.578  1.00 49.62           C  
HETATM  862  O   MSE B   1      43.800  -9.038  29.809  1.00 50.22           O  
HETATM  863  CB  MSE B   1      46.564 -11.084  30.066  1.00 50.22           C  
HETATM  864  CG  MSE B   1      46.878 -11.214  28.550  1.00 51.14           C  
HETATM  865 SE   MSE B   1      47.789  -9.636  27.722  0.60 53.02          SE  
HETATM  866  CE  MSE B   1      46.291  -8.923  26.704  1.00 48.86           C  
ATOM    867  N   SER B   2      43.898 -10.476  31.522  1.00 49.57           N  
ATOM    868  CA  SER B   2      42.469 -10.313  31.853  1.00 49.52           C  
ATOM    869  C   SER B   2      42.297  -9.011  32.661  1.00 49.03           C  
ATOM    870  O   SER B   2      41.295  -8.295  32.558  1.00 48.38           O  
ATOM    871  CB  SER B   2      41.891 -11.540  32.587  1.00 49.67           C  
ATOM    872  OG  SER B   2      42.611 -11.840  33.773  1.00 50.21           O  
ATOM    873  N   GLN B   3      43.319  -8.688  33.441  1.00 48.87           N  
ATOM    874  CA  GLN B   3      43.360  -7.388  34.088  1.00 48.11           C  
ATOM    875  C   GLN B   3      43.529  -6.246  33.081  1.00 46.95           C  
ATOM    876  O   GLN B   3      42.948  -5.185  33.271  1.00 46.74           O  
ATOM    877  CB  GLN B   3      44.456  -7.354  35.139  1.00 48.64           C  
ATOM    878  CG  GLN B   3      44.226  -6.271  36.180  1.00 50.96           C  
ATOM    879  CD  GLN B   3      45.486  -5.524  36.548  1.00 52.05           C  
ATOM    880  OE1 GLN B   3      45.532  -4.302  36.441  1.00 54.58           O  
ATOM    881  NE2 GLN B   3      46.512  -6.251  36.990  1.00 52.46           N  
ATOM    882  N   THR B   4      44.302  -6.436  32.013  1.00 45.79           N  
ATOM    883  CA  THR B   4      44.414  -5.355  31.037  1.00 45.63           C  
ATOM    884  C   THR B   4      43.161  -5.173  30.171  1.00 44.38           C  
ATOM    885  O   THR B   4      42.788  -4.049  29.859  1.00 45.59           O  
ATOM    886  CB  THR B   4      45.799  -5.286  30.214  1.00 46.41           C  
ATOM    887  OG1 THR B   4      45.626  -5.632  28.831  1.00 47.74           O  
ATOM    888  CG2 THR B   4      46.941  -6.088  30.867  1.00 46.15           C  
ATOM    889  N   LEU B   5      42.496  -6.281  29.835  1.00 43.33           N  
ATOM    890  CA  LEU B   5      41.215  -6.286  29.127  1.00 41.36           C  
ATOM    891  C   LEU B   5      40.109  -5.574  29.917  1.00 41.04           C  
ATOM    892  O   LEU B   5      39.350  -4.798  29.345  1.00 40.48           O  
ATOM    893  CB  LEU B   5      40.787  -7.732  28.822  1.00 41.48           C  
ATOM    894  CG  LEU B   5      39.347  -7.989  28.328  1.00 40.92           C  
ATOM    895  CD1 LEU B   5      38.965  -7.140  27.103  1.00 35.97           C  
ATOM    896  CD2 LEU B   5      39.139  -9.477  28.047  1.00 40.84           C  
ATOM    897  N   LYS B   6      40.001  -5.860  31.216  1.00 40.41           N  
ATOM    898  CA  LYS B   6      39.011  -5.206  32.068  1.00 40.51           C  
ATOM    899  C   LYS B   6      39.251  -3.726  32.096  1.00 39.66           C  
ATOM    900  O   LYS B   6      38.330  -2.963  31.974  1.00 39.18           O  
ATOM    901  CB  LYS B   6      39.051  -5.744  33.495  1.00 41.33           C  
ATOM    902  CG  LYS B   6      38.100  -5.038  34.466  1.00 43.18           C  
ATOM    903  CD  LYS B   6      37.987  -5.862  35.757  1.00 46.11           C  
ATOM    904  CE  LYS B   6      36.624  -5.718  36.437  1.00 44.83           C  
ATOM    905  NZ  LYS B   6      36.210  -7.089  36.891  1.00 48.71           N  
ATOM    906  N   GLN B   7      40.506  -3.325  32.260  1.00 39.67           N  
ATOM    907  CA  GLN B   7      40.880  -1.919  32.227  1.00 39.18           C  
ATOM    908  C   GLN B   7      40.583  -1.274  30.898  1.00 38.52           C  
ATOM    909  O   GLN B   7      40.207  -0.088  30.846  1.00 38.39           O  
ATOM    910  CB  GLN B   7      42.363  -1.753  32.471  1.00 39.99           C  
ATOM    911  CG  GLN B   7      42.790  -2.018  33.880  1.00 43.58           C  
ATOM    912  CD  GLN B   7      44.243  -1.655  34.080  1.00 46.47           C  
ATOM    913  OE1 GLN B   7      45.111  -2.525  34.230  1.00 44.20           O  
ATOM    914  NE2 GLN B   7      44.520  -0.354  34.055  1.00 48.44           N  
ATOM    915  N   LEU B   8      40.808  -2.029  29.826  1.00 37.97           N  
ATOM    916  CA  LEU B   8      40.454  -1.573  28.483  1.00 38.08           C  
ATOM    917  C   LEU B   8      38.939  -1.358  28.356  1.00 38.53           C  
ATOM    918  O   LEU B   8      38.509  -0.330  27.849  1.00 38.49           O  
ATOM    919  CB  LEU B   8      40.996  -2.534  27.403  1.00 38.03           C  
ATOM    920  CG  LEU B   8      42.479  -2.423  27.018  1.00 35.70           C  
ATOM    921  CD1 LEU B   8      42.924  -3.611  26.174  1.00 35.50           C  
ATOM    922  CD2 LEU B   8      42.706  -1.130  26.264  1.00 32.64           C  
ATOM    923  N   ALA B   9      38.168  -2.313  28.867  1.00 38.60           N  
ATOM    924  CA  ALA B   9      36.717  -2.310  28.851  1.00 39.57           C  
ATOM    925  C   ALA B   9      36.129  -1.294  29.800  1.00 41.30           C  
ATOM    926  O   ALA B   9      34.995  -0.841  29.591  1.00 41.93           O  
ATOM    927  CB  ALA B   9      36.186  -3.709  29.221  1.00 39.38           C  
HETATM  928  N   MSE B  10      36.888  -0.943  30.837  1.00 43.26           N  
HETATM  929  CA  MSE B  10      36.473   0.029  31.837  1.00 46.02           C  
HETATM  930  C   MSE B  10      36.854   1.470  31.501  1.00 47.54           C  
HETATM  931  O   MSE B  10      36.362   2.375  32.155  1.00 48.34           O  
HETATM  932  CB  MSE B  10      37.022  -0.321  33.231  1.00 45.52           C  
HETATM  933  CG  MSE B  10      36.207  -1.365  34.008  1.00 46.89           C  
HETATM  934 SE   MSE B  10      34.297  -0.901  34.216  0.80 52.54          SE  
HETATM  935  CE  MSE B  10      34.455   0.532  35.525  1.00 48.97           C  
ATOM    936  N   ALA B  11      37.724   1.697  30.521  1.00 49.25           N  
ATOM    937  CA  ALA B  11      38.130   3.078  30.212  1.00 51.91           C  
ATOM    938  C   ALA B  11      37.033   3.965  29.609  1.00 53.85           C  
ATOM    939  O   ALA B  11      36.312   3.558  28.703  1.00 53.41           O  
ATOM    940  CB  ALA B  11      39.363   3.109  29.325  1.00 51.62           C  
ATOM    941  N   LYS B  12      36.941   5.188  30.126  1.00 56.60           N  
ATOM    942  CA  LYS B  12      36.169   6.263  29.514  1.00 59.89           C  
ATOM    943  C   LYS B  12      36.770   6.642  28.148  1.00 61.83           C  
ATOM    944  O   LYS B  12      37.980   6.889  28.036  1.00 61.66           O  
ATOM    945  CB  LYS B  12      36.121   7.463  30.464  1.00 59.98           C  
ATOM    946  CG  LYS B  12      35.357   7.163  31.749  1.00 60.85           C  
ATOM    947  CD  LYS B  12      35.272   8.363  32.698  1.00 61.26           C  
ATOM    948  CE  LYS B  12      34.296   8.098  33.854  1.00 62.63           C  
ATOM    949  NZ  LYS B  12      34.772   7.011  34.764  1.00 60.73           N  
HETATM  950  N   MSE B  13      35.928   6.665  27.114  1.00 64.26           N  
HETATM  951  CA  MSE B  13      36.417   6.751  25.732  1.00 67.90           C  
HETATM  952  C   MSE B  13      35.819   7.872  24.883  1.00 67.52           C  
HETATM  953  O   MSE B  13      36.532   8.487  24.078  1.00 68.83           O  
HETATM  954  CB  MSE B  13      36.262   5.397  25.007  1.00 67.71           C  
HETATM  955  CG  MSE B  13      37.135   5.262  23.729  1.00 69.91           C  
HETATM  956 SE   MSE B  13      37.912   3.449  23.410  0.80 74.08          SE  
HETATM  957  CE  MSE B  13      39.211   3.940  22.001  1.00 71.73           C  
ATOM    958  N   ALA B  14      34.536   8.147  25.058  1.00 67.31           N  
ATOM    959  CA  ALA B  14      33.794   9.018  24.120  1.00 67.63           C  
ATOM    960  C   ALA B  14      33.541   8.292  22.787  1.00 67.27           C  
ATOM    961  O   ALA B  14      33.074   7.149  22.791  1.00 67.08           O  
ATOM    962  CB  ALA B  14      34.492  10.378  23.909  1.00 67.53           C  
ATOM    963  N   GLY B  15      33.857   8.939  21.662  1.00 66.99           N  
ATOM    964  CA  GLY B  15      33.526   8.410  20.331  1.00 66.17           C  
ATOM    965  C   GLY B  15      32.027   8.406  20.026  1.00 65.89           C  
ATOM    966  O   GLY B  15      31.561   7.608  19.195  1.00 65.70           O  
ATOM    967  N   PHE B  16      31.284   9.311  20.671  1.00 65.16           N  
ATOM    968  CA  PHE B  16      29.827   9.374  20.550  1.00 65.07           C  
ATOM    969  C   PHE B  16      29.299   9.672  19.135  1.00 64.34           C  
ATOM    970  O   PHE B  16      29.989  10.300  18.321  1.00 63.68           O  
ATOM    971  CB  PHE B  16      29.260  10.430  21.509  1.00 65.85           C  
ATOM    972  CG  PHE B  16      29.551  10.168  22.967  1.00 68.26           C  
ATOM    973  CD1 PHE B  16      29.087   9.004  23.597  1.00 69.43           C  
ATOM    974  CD2 PHE B  16      30.266  11.110  23.727  1.00 69.86           C  
ATOM    975  CE1 PHE B  16      29.340   8.773  24.946  1.00 69.57           C  
ATOM    976  CE2 PHE B  16      30.530  10.887  25.087  1.00 69.69           C  
ATOM    977  CZ  PHE B  16      30.066   9.725  25.700  1.00 69.13           C  
ATOM    978  N   ARG B  17      28.075   9.208  18.856  1.00 63.80           N  
ATOM    979  CA  ARG B  17      27.302   9.626  17.667  1.00 63.94           C  
ATOM    980  C   ARG B  17      27.017  11.147  17.738  1.00 62.38           C  
ATOM    981  O   ARG B  17      26.581  11.643  18.783  1.00 62.51           O  
ATOM    982  CB  ARG B  17      25.957   8.870  17.600  1.00 63.88           C  
ATOM    983  CG  ARG B  17      25.813   7.780  16.515  1.00 66.88           C  
ATOM    984  CD  ARG B  17      24.310   7.500  16.156  1.00 65.86           C  
ATOM    985  NE  ARG B  17      23.974   6.062  16.196  1.00 71.42           N  
ATOM    986  CZ  ARG B  17      22.753   5.529  16.014  1.00 73.20           C  
ATOM    987  NH1 ARG B  17      21.684   6.296  15.767  1.00 72.14           N  
ATOM    988  NH2 ARG B  17      22.596   4.202  16.080  1.00 72.57           N  
ATOM    989  N   HIS B  18      27.267  11.859  16.642  1.00 60.96           N  
ATOM    990  CA  HIS B  18      26.898  13.279  16.498  1.00 59.98           C  
ATOM    991  C   HIS B  18      25.961  13.489  15.308  1.00 59.16           C  
ATOM    992  O   HIS B  18      26.067  12.783  14.307  1.00 58.95           O  
ATOM    993  CB  HIS B  18      28.139  14.170  16.341  1.00 59.73           C  
ATOM    994  CG  HIS B  18      28.925  14.324  17.605  1.00 60.15           C  
ATOM    995  ND1 HIS B  18      29.915  13.440  17.976  1.00 61.92           N  
ATOM    996  CD2 HIS B  18      28.855  15.245  18.593  1.00 59.77           C  
ATOM    997  CE1 HIS B  18      30.421  13.808  19.141  1.00 61.78           C  
ATOM    998  NE2 HIS B  18      29.800  14.904  19.532  1.00 62.26           N  
ATOM    999  N   LYS B  19      25.042  14.446  15.438  1.00 57.86           N  
ATOM   1000  CA  LYS B  19      24.121  14.802  14.374  1.00 57.36           C  
ATOM   1001  C   LYS B  19      23.937  16.313  14.240  1.00 56.40           C  
ATOM   1002  O   LYS B  19      23.745  17.013  15.221  1.00 56.89           O  
ATOM   1003  CB  LYS B  19      22.746  14.155  14.577  1.00 57.93           C  
ATOM   1004  CG  LYS B  19      21.917  14.132  13.265  1.00 59.24           C  
ATOM   1005  CD  LYS B  19      20.403  14.327  13.470  1.00 60.84           C  
ATOM   1006  CE  LYS B  19      19.647  14.296  12.106  1.00 60.97           C  
ATOM   1007  NZ  LYS B  19      20.069  13.168  11.177  1.00 62.45           N  
ATOM   1008  N   THR B  20      23.955  16.789  13.008  1.00 55.52           N  
ATOM   1009  CA  THR B  20      23.748  18.188  12.692  1.00 55.18           C  
ATOM   1010  C   THR B  20      22.313  18.402  12.245  1.00 55.42           C  
ATOM   1011  O   THR B  20      21.867  17.838  11.221  1.00 56.07           O  
ATOM   1012  CB  THR B  20      24.680  18.663  11.549  1.00 54.73           C  
ATOM   1013  OG1 THR B  20      26.043  18.511  11.949  1.00 54.67           O  
ATOM   1014  CG2 THR B  20      24.428  20.107  11.208  1.00 53.66           C  
ATOM   1015  N   VAL B  21      21.609  19.253  12.981  1.00 55.16           N  
ATOM   1016  CA  VAL B  21      20.252  19.627  12.628  1.00 54.86           C  
ATOM   1017  C   VAL B  21      20.110  21.132  12.666  1.00 54.55           C  
ATOM   1018  O   VAL B  21      20.834  21.804  13.389  1.00 55.36           O  
ATOM   1019  CB  VAL B  21      19.195  18.946  13.557  1.00 55.16           C  
ATOM   1020  CG1 VAL B  21      19.524  17.498  13.758  1.00 55.36           C  
ATOM   1021  CG2 VAL B  21      19.038  19.645  14.888  1.00 53.53           C  
ATOM   1022  N   VAL B  22      19.193  21.674  11.882  1.00 54.25           N  
ATOM   1023  CA  VAL B  22      18.914  23.098  11.980  1.00 53.94           C  
ATOM   1024  C   VAL B  22      17.629  23.273  12.763  1.00 53.55           C  
ATOM   1025  O   VAL B  22      16.801  22.355  12.799  1.00 53.65           O  
ATOM   1026  CB  VAL B  22      18.915  23.829  10.595  1.00 53.49           C  
ATOM   1027  CG1 VAL B  22      19.947  23.198   9.680  1.00 53.44           C  
ATOM   1028  CG2 VAL B  22      17.556  23.793   9.936  1.00 54.14           C  
ATOM   1029  N   VAL B  23      17.478  24.430  13.406  1.00 53.34           N  
ATOM   1030  CA  VAL B  23      16.288  24.710  14.225  1.00 53.41           C  
ATOM   1031  C   VAL B  23      15.535  25.963  13.766  1.00 53.33           C  
ATOM   1032  O   VAL B  23      16.000  27.088  13.951  1.00 52.44           O  
ATOM   1033  CB  VAL B  23      16.579  24.546  15.779  1.00 53.90           C  
ATOM   1034  CG1 VAL B  23      18.065  24.660  16.121  1.00 53.99           C  
ATOM   1035  CG2 VAL B  23      15.608  25.293  16.732  1.00 52.85           C  
ATOM   1036  N   PRO B  24      14.386  25.746  13.090  1.00 54.04           N  
ATOM   1037  CA  PRO B  24      13.598  26.835  12.501  1.00 54.53           C  
ATOM   1038  C   PRO B  24      13.036  27.819  13.514  1.00 54.81           C  
ATOM   1039  O   PRO B  24      12.831  28.974  13.166  1.00 55.45           O  
ATOM   1040  CB  PRO B  24      12.473  26.101  11.768  1.00 53.98           C  
ATOM   1041  CG  PRO B  24      13.032  24.742  11.506  1.00 54.59           C  
ATOM   1042  CD  PRO B  24      13.787  24.437  12.764  1.00 53.94           C  
ATOM   1043  N   GLU B  25      12.805  27.381  14.745  1.00 54.35           N  
ATOM   1044  CA  GLU B  25      12.393  28.296  15.798  1.00 54.97           C  
ATOM   1045  C   GLU B  25      13.493  29.270  16.178  1.00 55.40           C  
ATOM   1046  O   GLU B  25      13.217  30.326  16.752  1.00 57.26           O  
ATOM   1047  CB  GLU B  25      11.932  27.538  17.045  1.00 54.53           C  
ATOM   1048  CG  GLU B  25      10.707  26.689  16.834  1.00 55.72           C  
ATOM   1049  CD  GLU B  25      10.980  25.273  16.264  1.00 58.69           C  
ATOM   1050  OE1 GLU B  25      12.020  25.035  15.589  1.00 59.78           O  
ATOM   1051  OE2 GLU B  25      10.120  24.389  16.490  1.00 57.44           O  
ATOM   1052  N   TRP B  26      14.739  28.918  15.866  1.00 55.22           N  
ATOM   1053  CA  TRP B  26      15.875  29.754  16.190  1.00 54.51           C  
ATOM   1054  C   TRP B  26      16.550  30.224  14.882  1.00 54.69           C  
ATOM   1055  O   TRP B  26      17.723  29.900  14.578  1.00 55.32           O  
ATOM   1056  CB  TRP B  26      16.854  29.004  17.118  1.00 54.61           C  
ATOM   1057  CG  TRP B  26      16.278  28.433  18.436  1.00 53.21           C  
ATOM   1058  CD1 TRP B  26      15.109  28.777  19.055  1.00 55.48           C  
ATOM   1059  CD2 TRP B  26      16.895  27.446  19.275  1.00 53.90           C  
ATOM   1060  NE1 TRP B  26      14.950  28.046  20.223  1.00 55.78           N  
ATOM   1061  CE2 TRP B  26      16.042  27.232  20.379  1.00 55.81           C  
ATOM   1062  CE3 TRP B  26      18.093  26.706  19.190  1.00 55.10           C  
ATOM   1063  CZ2 TRP B  26      16.335  26.275  21.385  1.00 56.22           C  
ATOM   1064  CZ3 TRP B  26      18.394  25.790  20.208  1.00 55.03           C  
ATOM   1065  CH2 TRP B  26      17.513  25.583  21.282  1.00 55.04           C  
ATOM   1066  N   GLU B  27      15.772  30.954  14.093  1.00 53.77           N  
ATOM   1067  CA  GLU B  27      16.194  31.527  12.815  1.00 53.43           C  
ATOM   1068  C   GLU B  27      16.957  30.546  11.885  1.00 51.92           C  
ATOM   1069  O   GLU B  27      17.832  30.930  11.141  1.00 52.02           O  
ATOM   1070  CB  GLU B  27      16.962  32.842  13.082  1.00 53.88           C  
ATOM   1071  CG  GLU B  27      16.192  33.807  14.074  1.00 55.37           C  
ATOM   1072  CD  GLU B  27      16.926  35.141  14.440  1.00 55.14           C  
ATOM   1073  OE1 GLU B  27      17.966  35.459  13.884  1.00 53.77           O  
ATOM   1074  OE2 GLU B  27      16.424  35.911  15.306  1.00 62.23           O  
ATOM   1075  N   GLY B  28      16.606  29.275  11.918  1.00 50.48           N  
ATOM   1076  CA  GLY B  28      17.319  28.270  11.134  1.00 49.83           C  
ATOM   1077  C   GLY B  28      18.731  27.911  11.610  1.00 48.96           C  
ATOM   1078  O   GLY B  28      19.481  27.338  10.866  1.00 46.92           O  
ATOM   1079  N   VAL B  29      19.085  28.234  12.860  1.00 49.41           N  
ATOM   1080  CA  VAL B  29      20.465  28.023  13.338  1.00 48.91           C  
ATOM   1081  C   VAL B  29      20.795  26.535  13.340  1.00 48.78           C  
ATOM   1082  O   VAL B  29      19.919  25.663  13.500  1.00 47.72           O  
ATOM   1083  CB  VAL B  29      20.725  28.638  14.763  1.00 50.01           C  
ATOM   1084  CG1 VAL B  29      19.998  27.825  15.886  1.00 48.73           C  
ATOM   1085  CG2 VAL B  29      22.253  28.801  15.037  1.00 49.37           C  
ATOM   1086  N   LYS B  30      22.071  26.271  13.151  1.00 48.70           N  
ATOM   1087  CA  LYS B  30      22.572  24.942  12.999  1.00 50.47           C  
ATOM   1088  C   LYS B  30      23.084  24.502  14.357  1.00 49.75           C  
ATOM   1089  O   LYS B  30      23.728  25.265  15.068  1.00 50.85           O  
ATOM   1090  CB  LYS B  30      23.690  24.919  11.950  1.00 49.91           C  
ATOM   1091  CG  LYS B  30      23.972  23.538  11.398  1.00 51.77           C  
ATOM   1092  CD  LYS B  30      24.976  23.546  10.257  1.00 53.09           C  
ATOM   1093  CE  LYS B  30      26.370  23.838  10.765  1.00 58.99           C  
ATOM   1094  NZ  LYS B  30      26.584  23.282  12.143  1.00 58.65           N  
ATOM   1095  N   VAL B  31      22.803  23.266  14.699  1.00 49.10           N  
ATOM   1096  CA  VAL B  31      23.094  22.757  16.024  1.00 48.72           C  
ATOM   1097  C   VAL B  31      23.740  21.365  15.808  1.00 48.10           C  
ATOM   1098  O   VAL B  31      23.441  20.694  14.828  1.00 47.20           O  
ATOM   1099  CB  VAL B  31      21.753  22.765  16.849  1.00 49.58           C  
ATOM   1100  CG1 VAL B  31      21.471  21.513  17.578  1.00 48.01           C  
ATOM   1101  CG2 VAL B  31      21.653  24.006  17.747  1.00 49.85           C  
ATOM   1102  N   VAL B  32      24.669  20.977  16.677  1.00 47.54           N  
ATOM   1103  CA  VAL B  32      25.190  19.616  16.691  1.00 47.09           C  
ATOM   1104  C   VAL B  32      24.627  18.899  17.920  1.00 48.10           C  
ATOM   1105  O   VAL B  32      24.655  19.422  19.015  1.00 48.08           O  
ATOM   1106  CB  VAL B  32      26.746  19.558  16.646  1.00 46.39           C  
ATOM   1107  CG1 VAL B  32      27.231  18.116  16.684  1.00 43.77           C  
ATOM   1108  CG2 VAL B  32      27.273  20.219  15.372  1.00 46.34           C  
ATOM   1109  N   LEU B  33      24.100  17.702  17.725  1.00 49.92           N  
ATOM   1110  CA  LEU B  33      23.539  16.903  18.829  1.00 50.62           C  
ATOM   1111  C   LEU B  33      24.365  15.649  19.027  1.00 50.87           C  
ATOM   1112  O   LEU B  33      24.871  15.069  18.071  1.00 50.36           O  
ATOM   1113  CB  LEU B  33      22.078  16.560  18.546  1.00 50.73           C  
ATOM   1114  CG  LEU B  33      21.096  17.747  18.563  1.00 51.69           C  
ATOM   1115  CD1 LEU B  33      19.740  17.227  18.066  1.00 52.74           C  
ATOM   1116  CD2 LEU B  33      20.968  18.469  19.964  1.00 53.34           C  
ATOM   1117  N   ARG B  34      24.536  15.249  20.278  1.00 51.76           N  
ATOM   1118  CA  ARG B  34      25.298  14.023  20.567  1.00 52.42           C  
ATOM   1119  C   ARG B  34      24.556  13.184  21.606  1.00 52.86           C  
ATOM   1120  O   ARG B  34      23.654  13.678  22.269  1.00 52.84           O  
ATOM   1121  CB  ARG B  34      26.714  14.366  21.067  1.00 52.12           C  
ATOM   1122  CG  ARG B  34      26.675  15.182  22.351  1.00 49.49           C  
ATOM   1123  CD  ARG B  34      28.053  15.548  22.776  1.00 48.48           C  
ATOM   1124  NE  ARG B  34      28.045  16.144  24.113  1.00 48.83           N  
ATOM   1125  CZ  ARG B  34      29.109  16.668  24.726  1.00 48.42           C  
ATOM   1126  NH1 ARG B  34      30.301  16.711  24.138  1.00 44.98           N  
ATOM   1127  NH2 ARG B  34      28.962  17.183  25.933  1.00 48.09           N  
ATOM   1128  N   GLU B  35      24.931  11.915  21.732  1.00 53.74           N  
ATOM   1129  CA  GLU B  35      24.389  11.069  22.785  1.00 54.96           C  
ATOM   1130  C   GLU B  35      24.826  11.640  24.122  1.00 54.20           C  
ATOM   1131  O   GLU B  35      25.921  12.204  24.227  1.00 53.76           O  
ATOM   1132  CB  GLU B  35      24.924   9.642  22.704  1.00 54.80           C  
ATOM   1133  CG  GLU B  35      25.036   9.042  21.335  1.00 57.36           C  
ATOM   1134  CD  GLU B  35      25.801   7.718  21.363  1.00 57.60           C  
ATOM   1135  OE1 GLU B  35      26.725   7.523  20.530  1.00 61.22           O  
ATOM   1136  OE2 GLU B  35      25.472   6.881  22.238  1.00 60.50           O  
ATOM   1137  N   PRO B  36      23.966  11.523  25.145  1.00 54.31           N  
ATOM   1138  CA  PRO B  36      24.417  11.950  26.484  1.00 54.63           C  
ATOM   1139  C   PRO B  36      25.492  11.028  27.075  1.00 55.32           C  
ATOM   1140  O   PRO B  36      25.474   9.819  26.852  1.00 55.72           O  
ATOM   1141  CB  PRO B  36      23.142  11.921  27.330  1.00 54.76           C  
ATOM   1142  CG  PRO B  36      22.180  11.056  26.575  1.00 55.57           C  
ATOM   1143  CD  PRO B  36      22.567  11.060  25.117  1.00 53.63           C  
ATOM   1144  N   SER B  37      26.434  11.606  27.802  1.00 55.86           N  
ATOM   1145  CA  SER B  37      27.442  10.827  28.466  1.00 56.01           C  
ATOM   1146  C   SER B  37      26.841  10.063  29.630  1.00 56.45           C  
ATOM   1147  O   SER B  37      25.809  10.454  30.190  1.00 56.20           O  
ATOM   1148  CB  SER B  37      28.596  11.705  28.956  1.00 55.83           C  
ATOM   1149  OG  SER B  37      28.208  12.532  30.041  1.00 56.63           O  
ATOM   1150  N   GLY B  38      27.505   8.950  29.965  1.00 56.73           N  
ATOM   1151  CA  GLY B  38      27.284   8.230  31.205  1.00 56.19           C  
ATOM   1152  C   GLY B  38      27.279   9.154  32.397  1.00 55.87           C  
ATOM   1153  O   GLY B  38      26.455   8.961  33.278  1.00 56.95           O  
ATOM   1154  N   GLU B  39      28.178  10.150  32.429  1.00 55.61           N  
ATOM   1155  CA  GLU B  39      28.217  11.139  33.521  0.50 55.59           C  
ATOM   1157  C   GLU B  39      26.935  11.982  33.623  1.00 55.30           C  
ATOM   1158  O   GLU B  39      26.423  12.215  34.716  1.00 55.48           O  
ATOM   1159  CB  GLU B  39      29.452  12.048  33.391  0.50 55.65           C  
ATOM   1161  CG  GLU B  39      29.705  12.955  34.590  0.50 55.17           C  
ATOM   1163  CD  GLU B  39      31.057  13.674  34.539  0.50 56.05           C  
ATOM   1165  OE1 GLU B  39      31.159  14.781  35.126  0.50 55.26           O  
ATOM   1167  OE2 GLU B  39      32.015  13.134  33.925  0.50 55.19           O  
ATOM   1169  N   ALA B  40      26.420  12.438  32.483  1.00 54.78           N  
ATOM   1170  CA  ALA B  40      25.135  13.172  32.407  1.00 53.01           C  
ATOM   1171  C   ALA B  40      23.964  12.335  32.923  1.00 51.97           C  
ATOM   1172  O   ALA B  40      23.127  12.825  33.669  1.00 51.30           O  
ATOM   1173  CB  ALA B  40      24.875  13.597  30.978  1.00 52.23           C  
ATOM   1174  N   TRP B  41      23.930  11.068  32.504  1.00 51.43           N  
ATOM   1175  CA  TRP B  41      22.925  10.091  32.927  1.00 51.08           C  
ATOM   1176  C   TRP B  41      22.985   9.822  34.442  1.00 51.50           C  
ATOM   1177  O   TRP B  41      21.968   9.516  35.062  1.00 51.34           O  
ATOM   1178  CB  TRP B  41      23.115   8.763  32.176  1.00 49.92           C  
ATOM   1179  CG  TRP B  41      22.466   8.641  30.820  1.00 48.43           C  
ATOM   1180  CD1 TRP B  41      23.079   8.302  29.660  1.00 46.29           C  
ATOM   1181  CD2 TRP B  41      21.070   8.809  30.500  1.00 48.66           C  
ATOM   1182  NE1 TRP B  41      22.169   8.260  28.632  1.00 44.57           N  
ATOM   1183  CE2 TRP B  41      20.930   8.555  29.114  1.00 46.31           C  
ATOM   1184  CE3 TRP B  41      19.924   9.119  31.256  1.00 47.46           C  
ATOM   1185  CZ2 TRP B  41      19.706   8.623  28.461  1.00 46.33           C  
ATOM   1186  CZ3 TRP B  41      18.710   9.183  30.607  1.00 46.94           C  
ATOM   1187  CH2 TRP B  41      18.612   8.949  29.213  1.00 47.43           C  
ATOM   1188  N   LEU B  42      24.166   9.930  35.037  1.00 52.42           N  
ATOM   1189  CA  LEU B  42      24.282   9.802  36.506  1.00 54.03           C  
ATOM   1190  C   LEU B  42      23.678  11.009  37.251  1.00 54.05           C  
ATOM   1191  O   LEU B  42      23.013  10.852  38.263  1.00 54.36           O  
ATOM   1192  CB  LEU B  42      25.735   9.580  36.916  1.00 54.24           C  
ATOM   1193  CG  LEU B  42      25.996   8.830  38.207  1.00 56.42           C  
ATOM   1194  CD1 LEU B  42      27.287   8.050  38.084  1.00 57.93           C  
ATOM   1195  CD2 LEU B  42      26.023   9.784  39.425  1.00 60.57           C  
ATOM   1196  N   ARG B  43      23.903  12.205  36.725  1.00 54.65           N  
ATOM   1197  CA  ARG B  43      23.300  13.433  37.243  1.00 55.19           C  
ATOM   1198  C   ARG B  43      21.792  13.517  37.021  1.00 54.48           C  
ATOM   1199  O   ARG B  43      21.092  14.051  37.859  1.00 54.43           O  
ATOM   1200  CB  ARG B  43      23.960  14.652  36.601  1.00 55.99           C  
ATOM   1201  CG  ARG B  43      25.230  15.121  37.286  1.00 59.81           C  
ATOM   1202  CD  ARG B  43      25.737  16.416  36.630  1.00 65.89           C  
ATOM   1203  NE  ARG B  43      26.619  16.140  35.489  1.00 67.16           N  
ATOM   1204  CZ  ARG B  43      26.358  16.459  34.222  1.00 67.99           C  
ATOM   1205  NH1 ARG B  43      25.228  17.080  33.901  1.00 70.15           N  
ATOM   1206  NH2 ARG B  43      27.246  16.169  33.273  1.00 66.49           N  
ATOM   1207  N   TRP B  44      21.314  13.012  35.883  1.00 54.29           N  
ATOM   1208  CA  TRP B  44      19.881  12.935  35.563  1.00 54.18           C  
ATOM   1209  C   TRP B  44      19.113  12.054  36.557  1.00 55.38           C  
ATOM   1210  O   TRP B  44      18.017  12.414  37.008  1.00 54.94           O  
ATOM   1211  CB  TRP B  44      19.701  12.402  34.140  1.00 52.80           C  
ATOM   1212  CG  TRP B  44      18.257  12.165  33.716  1.00 51.87           C  
ATOM   1213  CD1 TRP B  44      17.430  13.059  33.096  1.00 50.44           C  
ATOM   1214  CD2 TRP B  44      17.490  10.951  33.862  1.00 51.37           C  
ATOM   1215  NE1 TRP B  44      16.198  12.488  32.852  1.00 49.98           N  
ATOM   1216  CE2 TRP B  44      16.206  11.197  33.309  1.00 50.90           C  
ATOM   1217  CE3 TRP B  44      17.763   9.679  34.394  1.00 49.79           C  
ATOM   1218  CZ2 TRP B  44      15.203  10.220  33.271  1.00 50.76           C  
ATOM   1219  CZ3 TRP B  44      16.753   8.710  34.376  1.00 50.04           C  
ATOM   1220  CH2 TRP B  44      15.494   8.988  33.813  1.00 50.43           C  
ATOM   1221  N   GLN B  45      19.699  10.892  36.865  1.00 56.89           N  
ATOM   1222  CA  GLN B  45      19.202   9.980  37.887  1.00 58.60           C  
ATOM   1223  C   GLN B  45      19.093  10.667  39.250  1.00 59.43           C  
ATOM   1224  O   GLN B  45      18.118  10.474  39.983  1.00 59.38           O  
ATOM   1225  CB  GLN B  45      20.153   8.793  38.026  1.00 59.11           C  
ATOM   1226  CG  GLN B  45      19.917   7.636  37.081  1.00 60.85           C  
ATOM   1227  CD  GLN B  45      20.564   6.358  37.601  1.00 63.32           C  
ATOM   1228  OE1 GLN B  45      21.762   6.124  37.411  1.00 64.33           O  
ATOM   1229  NE2 GLN B  45      19.771   5.528  38.267  1.00 63.61           N  
ATOM   1230  N   GLU B  46      20.109  11.462  39.583  1.00 60.39           N  
ATOM   1231  CA  GLU B  46      20.157  12.180  40.856  1.00 61.49           C  
ATOM   1232  C   GLU B  46      19.010  13.168  40.964  1.00 61.00           C  
ATOM   1233  O   GLU B  46      18.396  13.289  42.009  1.00 60.76           O  
ATOM   1234  CB  GLU B  46      21.502  12.891  41.037  1.00 61.61           C  
ATOM   1235  CG  GLU B  46      22.679  11.936  41.222  1.00 63.19           C  
ATOM   1236  CD  GLU B  46      23.992  12.659  41.493  1.00 63.55           C  
ATOM   1237  OE1 GLU B  46      24.815  12.772  40.548  1.00 66.66           O  
ATOM   1238  OE2 GLU B  46      24.192  13.110  42.647  1.00 64.02           O  
ATOM   1239  N   VAL B  47      18.707  13.863  39.871  1.00 61.31           N  
ATOM   1240  CA  VAL B  47      17.546  14.749  39.861  1.00 60.96           C  
ATOM   1241  C   VAL B  47      16.222  13.949  39.949  1.00 61.26           C  
ATOM   1242  O   VAL B  47      15.403  14.199  40.835  1.00 60.85           O  
ATOM   1243  CB  VAL B  47      17.550  15.698  38.651  1.00 60.63           C  
ATOM   1244  CG1 VAL B  47      16.401  16.644  38.757  1.00 59.95           C  
ATOM   1245  CG2 VAL B  47      18.850  16.470  38.579  1.00 60.53           C  
ATOM   1246  N   VAL B  48      16.037  12.987  39.036  1.00 61.73           N  
ATOM   1247  CA  VAL B  48      14.810  12.170  38.964  1.00 61.71           C  
ATOM   1248  C   VAL B  48      14.385  11.608  40.326  1.00 62.11           C  
ATOM   1249  O   VAL B  48      13.208  11.670  40.681  1.00 62.22           O  
ATOM   1250  CB  VAL B  48      14.922  11.053  37.872  1.00 61.72           C  
ATOM   1251  CG1 VAL B  48      13.928   9.921  38.107  1.00 61.34           C  
ATOM   1252  CG2 VAL B  48      14.701  11.648  36.501  1.00 60.68           C  
ATOM   1253  N   LYS B  49      15.344  11.083  41.087  1.00 62.60           N  
ATOM   1254  CA  LYS B  49      15.083  10.583  42.434  1.00 62.99           C  
ATOM   1255  C   LYS B  49      15.244  11.693  43.475  1.00 62.86           C  
ATOM   1256  O   LYS B  49      15.385  11.413  44.671  1.00 62.97           O  
ATOM   1257  CB  LYS B  49      16.005   9.402  42.761  1.00 63.24           C  
ATOM   1258  CG  LYS B  49      16.034   8.282  41.652  1.00 63.54           C  
ATOM   1259  CD  LYS B  49      16.897   7.016  42.366  1.00 63.34           C  
ATOM   1260  CE  LYS B  49      16.860   5.921  41.180  1.00 64.40           C  
ATOM   1261  NZ  LYS B  49      17.852   4.840  41.540  1.00 63.90           N  
ATOM   1262  N   HIS B  64       7.563  19.138  38.381  1.00 68.73           N  
ATOM   1263  CA  HIS B  64       8.625  19.797  37.600  1.00 69.07           C  
ATOM   1264  C   HIS B  64       9.998  19.100  37.718  1.00 68.36           C  
ATOM   1265  O   HIS B  64      10.992  19.611  37.203  1.00 68.12           O  
ATOM   1266  CB  HIS B  64       8.775  21.262  38.038  1.00 69.42           C  
ATOM   1267  CG  HIS B  64       7.537  22.085  37.864  1.00 71.30           C  
ATOM   1268  ND1 HIS B  64       6.450  21.986  38.709  1.00 72.04           N  
ATOM   1269  CD2 HIS B  64       7.224  23.049  36.961  1.00 73.07           C  
ATOM   1270  CE1 HIS B  64       5.515  22.839  38.326  1.00 72.63           C  
ATOM   1271  NE2 HIS B  64       5.957  23.497  37.268  1.00 73.62           N  
ATOM   1272  N   ARG B  65      10.050  17.955  38.406  1.00 68.01           N  
ATOM   1273  CA  ARG B  65      11.331  17.316  38.761  1.00 67.56           C  
ATOM   1274  C   ARG B  65      11.910  16.439  37.653  1.00 66.97           C  
ATOM   1275  O   ARG B  65      13.127  16.323  37.541  1.00 66.75           O  
ATOM   1276  CB  ARG B  65      11.243  16.548  40.090  1.00 67.61           C  
ATOM   1277  CG  ARG B  65      12.583  16.458  40.836  1.00 67.89           C  
ATOM   1278  CD  ARG B  65      12.402  16.298  42.350  1.00 67.61           C  
ATOM   1279  NE  ARG B  65      12.575  14.919  42.800  1.00 67.70           N  
ATOM   1280  CZ  ARG B  65      12.354  14.484  44.046  1.00 68.35           C  
ATOM   1281  NH1 ARG B  65      11.927  15.313  44.991  1.00 68.22           N  
ATOM   1282  NH2 ARG B  65      12.555  13.204  44.353  1.00 67.68           N  
ATOM   1283  N   ASN B  66      11.039  15.828  36.852  1.00 66.61           N  
ATOM   1284  CA  ASN B  66      11.444  15.176  35.607  1.00 66.52           C  
ATOM   1285  C   ASN B  66      12.131  16.129  34.639  1.00 66.02           C  
ATOM   1286  O   ASN B  66      12.976  15.700  33.833  1.00 65.56           O  
ATOM   1287  CB  ASN B  66      10.238  14.577  34.885  1.00 67.22           C  
ATOM   1288  CG  ASN B  66      10.232  13.064  34.895  1.00 67.92           C  
ATOM   1289  OD1 ASN B  66      10.973  12.412  34.151  1.00 70.48           O  
ATOM   1290  ND2 ASN B  66       9.363  12.495  35.716  1.00 69.04           N  
ATOM   1291  N   LEU B  67      11.747  17.406  34.687  1.00 65.08           N  
ATOM   1292  CA  LEU B  67      12.323  18.372  33.761  1.00 64.72           C  
ATOM   1293  C   LEU B  67      13.612  19.029  34.282  1.00 63.92           C  
ATOM   1294  O   LEU B  67      14.523  19.272  33.513  1.00 64.29           O  
ATOM   1295  CB  LEU B  67      11.289  19.399  33.297  1.00 65.26           C  
ATOM   1296  CG  LEU B  67      10.357  19.010  32.133  1.00 66.21           C  
ATOM   1297  CD1 LEU B  67       9.359  17.890  32.491  1.00 66.24           C  
ATOM   1298  CD2 LEU B  67       9.618  20.269  31.602  1.00 65.17           C  
ATOM   1299  N   CYS B  68      13.717  19.304  35.576  1.00 63.23           N  
ATOM   1300  CA  CYS B  68      15.016  19.708  36.116  1.00 62.33           C  
ATOM   1301  C   CYS B  68      15.978  18.678  35.552  1.00 60.66           C  
ATOM   1302  O   CYS B  68      17.089  19.015  35.107  1.00 60.91           O  
ATOM   1303  CB  CYS B  68      15.050  19.650  37.651  1.00 62.60           C  
ATOM   1304  SG  CYS B  68      14.431  21.097  38.581  1.00 66.76           S  
ATOM   1305  N   ALA B  69      15.503  17.421  35.549  1.00 58.36           N  
ATOM   1306  CA  ALA B  69      16.281  16.251  35.155  1.00 55.64           C  
ATOM   1307  C   ALA B  69      16.609  16.289  33.679  1.00 54.04           C  
ATOM   1308  O   ALA B  69      17.757  16.144  33.327  1.00 54.32           O  
ATOM   1309  CB  ALA B  69      15.559  14.947  35.533  1.00 54.70           C  
ATOM   1310  N   ASP B  70      15.611  16.470  32.823  1.00 52.46           N  
ATOM   1311  CA  ASP B  70      15.860  16.507  31.397  1.00 52.56           C  
ATOM   1312  C   ASP B  70      16.684  17.716  30.987  1.00 52.43           C  
ATOM   1313  O   ASP B  70      17.359  17.676  29.981  1.00 52.92           O  
ATOM   1314  CB  ASP B  70      14.564  16.493  30.616  1.00 52.70           C  
ATOM   1315  CG  ASP B  70      13.962  15.115  30.484  1.00 52.95           C  
ATOM   1316  OD1 ASP B  70      14.503  14.103  30.997  1.00 50.45           O  
ATOM   1317  OD2 ASP B  70      12.903  15.052  29.841  1.00 55.04           O  
ATOM   1318  N   VAL B  71      16.630  18.788  31.767  1.00 52.37           N  
ATOM   1319  CA  VAL B  71      17.501  19.937  31.530  1.00 53.05           C  
ATOM   1320  C   VAL B  71      18.986  19.548  31.541  1.00 53.54           C  
ATOM   1321  O   VAL B  71      19.717  19.898  30.608  1.00 54.17           O  
ATOM   1322  CB  VAL B  71      17.149  21.138  32.474  1.00 53.34           C  
ATOM   1323  CG1 VAL B  71      18.331  22.135  32.636  1.00 53.67           C  
ATOM   1324  CG2 VAL B  71      15.887  21.840  31.964  1.00 51.39           C  
ATOM   1325  N   VAL B  72      19.412  18.784  32.555  1.00 54.19           N  
ATOM   1326  CA  VAL B  72      20.784  18.220  32.623  1.00 54.35           C  
ATOM   1327  C   VAL B  72      21.159  17.335  31.443  1.00 54.22           C  
ATOM   1328  O   VAL B  72      22.273  17.437  30.920  1.00 54.28           O  
ATOM   1329  CB  VAL B  72      21.126  17.494  34.009  1.00 54.84           C  
ATOM   1330  CG1 VAL B  72      19.944  17.408  34.899  1.00 54.74           C  
ATOM   1331  CG2 VAL B  72      21.779  16.111  33.817  1.00 53.16           C  
ATOM   1332  N   LEU B  73      20.256  16.457  31.021  1.00 54.41           N  
ATOM   1333  CA  LEU B  73      20.528  15.718  29.784  1.00 53.84           C  
ATOM   1334  C   LEU B  73      20.712  16.691  28.628  1.00 53.64           C  
ATOM   1335  O   LEU B  73      21.636  16.539  27.830  1.00 54.66           O  
ATOM   1336  CB  LEU B  73      19.401  14.755  29.446  1.00 53.72           C  
ATOM   1337  CG  LEU B  73      19.428  13.407  30.137  1.00 54.79           C  
ATOM   1338  CD1 LEU B  73      18.309  12.557  29.580  1.00 52.63           C  
ATOM   1339  CD2 LEU B  73      20.786  12.708  29.999  1.00 54.14           C  
ATOM   1340  N   PHE B  74      19.828  17.690  28.537  1.00 52.57           N  
ATOM   1341  CA  PHE B  74      19.810  18.593  27.384  1.00 51.29           C  
ATOM   1342  C   PHE B  74      21.099  19.424  27.228  1.00 51.21           C  
ATOM   1343  O   PHE B  74      21.610  19.660  26.106  1.00 51.08           O  
ATOM   1344  CB  PHE B  74      18.542  19.465  27.399  1.00 50.64           C  
ATOM   1345  CG  PHE B  74      18.598  20.591  26.431  1.00 51.64           C  
ATOM   1346  CD1 PHE B  74      18.293  20.387  25.096  1.00 49.10           C  
ATOM   1347  CD2 PHE B  74      19.042  21.850  26.838  1.00 51.09           C  
ATOM   1348  CE1 PHE B  74      18.381  21.430  24.196  1.00 51.03           C  
ATOM   1349  CE2 PHE B  74      19.162  22.909  25.899  1.00 50.21           C  
ATOM   1350  CZ  PHE B  74      18.819  22.699  24.609  1.00 48.16           C  
ATOM   1351  N   ILE B  75      21.637  19.833  28.365  1.00 50.92           N  
ATOM   1352  CA  ILE B  75      22.854  20.653  28.435  1.00 50.93           C  
ATOM   1353  C   ILE B  75      24.078  19.828  28.075  1.00 51.39           C  
ATOM   1354  O   ILE B  75      25.098  20.366  27.593  1.00 50.92           O  
ATOM   1355  CB  ILE B  75      23.016  21.195  29.841  1.00 50.88           C  
ATOM   1356  CG1 ILE B  75      22.207  22.468  29.998  1.00 50.33           C  
ATOM   1357  CG2 ILE B  75      24.497  21.392  30.210  1.00 51.60           C  
ATOM   1358  CD1 ILE B  75      22.093  22.898  31.507  1.00 52.99           C  
ATOM   1359  N   ASP B  76      23.969  18.515  28.306  1.00 51.20           N  
ATOM   1360  CA  ASP B  76      25.003  17.620  27.860  1.00 52.10           C  
ATOM   1361  C   ASP B  76      24.906  17.311  26.361  1.00 51.68           C  
ATOM   1362  O   ASP B  76      25.919  17.071  25.748  1.00 52.30           O  
ATOM   1363  CB  ASP B  76      25.014  16.307  28.653  1.00 52.50           C  
ATOM   1364  CG  ASP B  76      26.317  15.560  28.476  1.00 55.28           C  
ATOM   1365  OD1 ASP B  76      27.372  16.129  28.880  1.00 56.47           O  
ATOM   1366  OD2 ASP B  76      26.296  14.438  27.904  1.00 56.79           O  
ATOM   1367  N   VAL B  77      23.703  17.284  25.787  1.00 51.36           N  
ATOM   1368  CA  VAL B  77      23.559  16.930  24.350  1.00 51.37           C  
ATOM   1369  C   VAL B  77      23.735  18.073  23.339  1.00 50.08           C  
ATOM   1370  O   VAL B  77      24.101  17.819  22.236  1.00 51.01           O  
ATOM   1371  CB  VAL B  77      22.209  16.160  24.029  1.00 51.77           C  
ATOM   1372  CG1 VAL B  77      21.994  14.970  24.975  1.00 52.17           C  
ATOM   1373  CG2 VAL B  77      20.963  17.087  24.015  1.00 50.97           C  
ATOM   1374  N   LEU B  78      23.450  19.319  23.721  1.00 50.24           N  
ATOM   1375  CA  LEU B  78      23.336  20.441  22.782  1.00 49.33           C  
ATOM   1376  C   LEU B  78      24.651  21.155  22.602  1.00 48.90           C  
ATOM   1377  O   LEU B  78      25.186  21.792  23.540  1.00 49.68           O  
ATOM   1378  CB  LEU B  78      22.211  21.428  23.151  1.00 48.78           C  
ATOM   1379  CG  LEU B  78      22.073  22.635  22.175  1.00 50.67           C  
ATOM   1380  CD1 LEU B  78      21.141  22.281  21.040  1.00 50.68           C  
ATOM   1381  CD2 LEU B  78      21.610  23.976  22.839  1.00 48.72           C  
ATOM   1382  N   CYS B  79      25.153  21.051  21.379  1.00 48.17           N  
ATOM   1383  CA  CYS B  79      26.498  21.441  21.033  1.00 48.42           C  
ATOM   1384  C   CYS B  79      26.458  22.382  19.860  1.00 48.79           C  
ATOM   1385  O   CYS B  79      25.471  22.407  19.114  1.00 46.08           O  
ATOM   1386  CB  CYS B  79      27.310  20.212  20.610  1.00 48.11           C  
ATOM   1387  SG  CYS B  79      27.677  19.053  21.918  1.00 49.22           S  
ATOM   1388  N   ASP B  80      27.570  23.113  19.732  1.00 49.90           N  
ATOM   1389  CA  ASP B  80      27.834  24.032  18.628  0.50 51.27           C  
ATOM   1391  C   ASP B  80      28.519  23.298  17.497  1.00 51.53           C  
ATOM   1392  O   ASP B  80      28.869  22.139  17.624  1.00 51.55           O  
ATOM   1393  CB  ASP B  80      28.744  25.181  19.068  0.50 51.22           C  
ATOM   1395  CG  ASP B  80      28.017  26.224  19.867  0.50 53.73           C  
ATOM   1397  OD1 ASP B  80      27.472  25.823  20.920  0.50 56.36           O  
ATOM   1399  OD2 ASP B  80      27.984  27.426  19.455  0.50 53.49           O  
ATOM   1401  N   THR B  81      28.715  23.990  16.388  1.00 53.06           N  
ATOM   1402  CA  THR B  81      29.373  23.404  15.230  1.00 54.83           C  
ATOM   1403  C   THR B  81      30.770  22.857  15.499  1.00 55.18           C  
ATOM   1404  O   THR B  81      31.282  22.053  14.701  1.00 55.69           O  
ATOM   1405  CB  THR B  81      29.394  24.375  14.047  1.00 54.81           C  
ATOM   1406  OG1 THR B  81      30.015  23.718  12.939  1.00 58.25           O  
ATOM   1407  CG2 THR B  81      30.184  25.647  14.388  1.00 55.95           C  
ATOM   1408  N   ASP B  82      31.391  23.288  16.601  1.00 55.49           N  
ATOM   1409  CA  ASP B  82      32.678  22.783  17.083  0.50 55.78           C  
ATOM   1411  C   ASP B  82      32.506  21.552  17.981  1.00 56.10           C  
ATOM   1412  O   ASP B  82      33.458  21.123  18.643  1.00 56.47           O  
ATOM   1413  CB  ASP B  82      33.450  23.886  17.835  0.50 55.81           C  
ATOM   1415  CG  ASP B  82      32.724  24.386  19.098  0.50 56.26           C  
ATOM   1417  OD1 ASP B  82      31.478  24.290  19.187  0.50 55.74           O  
ATOM   1419  OD2 ASP B  82      33.408  24.901  20.009  0.50 56.67           O  
ATOM   1421  N   LYS B  83      31.280  21.022  18.039  1.00 56.00           N  
ATOM   1422  CA  LYS B  83      30.946  19.820  18.814  1.00 56.34           C  
ATOM   1423  C   LYS B  83      31.168  19.978  20.318  1.00 55.12           C  
ATOM   1424  O   LYS B  83      31.346  18.976  21.031  1.00 54.34           O  
ATOM   1425  CB  LYS B  83      31.722  18.593  18.275  1.00 56.57           C  
ATOM   1426  CG  LYS B  83      31.358  18.146  16.848  1.00 56.05           C  
ATOM   1427  CD  LYS B  83      32.274  16.992  16.429  1.00 58.69           C  
ATOM   1428  CE  LYS B  83      32.010  16.490  14.998  1.00 61.75           C  
ATOM   1429  NZ  LYS B  83      31.144  15.238  14.959  1.00 64.29           N  
ATOM   1430  N   GLN B  84      31.169  21.231  20.789  1.00 53.94           N  
ATOM   1431  CA  GLN B  84      31.294  21.524  22.224  1.00 53.66           C  
ATOM   1432  C   GLN B  84      29.941  21.973  22.760  1.00 52.77           C  
ATOM   1433  O   GLN B  84      29.247  22.728  22.097  1.00 51.96           O  
ATOM   1434  CB  GLN B  84      32.340  22.629  22.510  1.00 54.30           C  
ATOM   1435  CG  GLN B  84      33.802  22.352  22.053  1.00 57.24           C  
ATOM   1436  CD  GLN B  84      34.395  21.022  22.564  1.00 61.11           C  
ATOM   1437  OE1 GLN B  84      34.147  20.585  23.705  1.00 60.58           O  
ATOM   1438  NE2 GLN B  84      35.197  20.380  21.706  1.00 63.40           N  
ATOM   1439  N   PRO B  85      29.574  21.520  23.977  1.00 52.50           N  
ATOM   1440  CA  PRO B  85      28.303  21.887  24.586  1.00 52.78           C  
ATOM   1441  C   PRO B  85      28.093  23.407  24.612  1.00 52.26           C  
ATOM   1442  O   PRO B  85      29.009  24.129  24.974  1.00 52.26           O  
ATOM   1443  CB  PRO B  85      28.420  21.319  26.013  1.00 52.24           C  
ATOM   1444  CG  PRO B  85      29.868  21.053  26.214  1.00 52.67           C  
ATOM   1445  CD  PRO B  85      30.355  20.650  24.871  1.00 52.68           C  
ATOM   1446  N   VAL B  86      26.910  23.888  24.226  1.00 52.10           N  
ATOM   1447  CA  VAL B  86      26.684  25.361  24.283  1.00 51.95           C  
ATOM   1448  C   VAL B  86      26.528  25.928  25.698  1.00 52.17           C  
ATOM   1449  O   VAL B  86      26.980  27.038  25.959  1.00 53.21           O  
ATOM   1450  CB  VAL B  86      25.596  25.915  23.298  1.00 50.82           C  
ATOM   1451  CG1 VAL B  86      24.927  24.839  22.532  1.00 50.30           C  
ATOM   1452  CG2 VAL B  86      24.600  26.792  23.994  1.00 50.46           C  
ATOM   1453  N   PHE B  87      25.925  25.147  26.592  1.00 52.62           N  
ATOM   1454  CA  PHE B  87      25.738  25.500  28.004  1.00 53.00           C  
ATOM   1455  C   PHE B  87      26.642  24.670  28.904  1.00 53.94           C  
ATOM   1456  O   PHE B  87      26.994  23.559  28.552  1.00 54.33           O  
ATOM   1457  CB  PHE B  87      24.287  25.261  28.424  1.00 51.68           C  
ATOM   1458  CG  PHE B  87      23.295  26.069  27.657  1.00 51.19           C  
ATOM   1459  CD1 PHE B  87      23.092  27.422  27.961  1.00 48.24           C  
ATOM   1460  CD2 PHE B  87      22.541  25.474  26.626  1.00 50.98           C  
ATOM   1461  CE1 PHE B  87      22.166  28.163  27.268  1.00 47.03           C  
ATOM   1462  CE2 PHE B  87      21.604  26.219  25.904  1.00 48.60           C  
ATOM   1463  CZ  PHE B  87      21.419  27.563  26.221  1.00 50.70           C  
ATOM   1464  N   SER B  88      27.010  25.207  30.066  1.00 55.28           N  
ATOM   1465  CA  SER B  88      27.788  24.452  31.060  1.00 56.73           C  
ATOM   1466  C   SER B  88      26.880  24.006  32.201  1.00 57.92           C  
ATOM   1467  O   SER B  88      25.854  24.638  32.448  1.00 58.87           O  
ATOM   1468  CB  SER B  88      28.896  25.321  31.617  1.00 56.57           C  
ATOM   1469  OG  SER B  88      28.347  26.465  32.239  1.00 56.80           O  
ATOM   1470  N   VAL B  89      27.256  22.930  32.896  1.00 59.11           N  
ATOM   1471  CA  VAL B  89      26.452  22.365  34.008  1.00 60.00           C  
ATOM   1472  C   VAL B  89      26.073  23.387  35.093  1.00 60.70           C  
ATOM   1473  O   VAL B  89      25.077  23.196  35.798  1.00 61.38           O  
ATOM   1474  CB  VAL B  89      27.156  21.145  34.716  1.00 60.23           C  
ATOM   1475  CG1 VAL B  89      27.629  20.107  33.699  1.00 59.81           C  
ATOM   1476  CG2 VAL B  89      28.318  21.615  35.598  1.00 60.06           C  
ATOM   1477  N   ASP B  90      26.874  24.450  35.230  1.00 60.48           N  
ATOM   1478  CA  ASP B  90      26.590  25.528  36.167  1.00 60.53           C  
ATOM   1479  C   ASP B  90      25.410  26.413  35.719  1.00 60.38           C  
ATOM   1480  O   ASP B  90      24.885  27.197  36.519  1.00 60.37           O  
ATOM   1481  CB  ASP B  90      27.843  26.390  36.383  1.00 60.86           C  
ATOM   1482  CG  ASP B  90      28.924  25.679  37.222  1.00 62.89           C  
ATOM   1483  OD1 ASP B  90      28.761  24.487  37.596  1.00 64.53           O  
ATOM   1484  OD2 ASP B  90      29.953  26.327  37.527  1.00 65.50           O  
ATOM   1485  N   GLU B  91      25.004  26.290  34.451  1.00 59.54           N  
ATOM   1486  CA  GLU B  91      23.944  27.127  33.876  1.00 58.86           C  
ATOM   1487  C   GLU B  91      22.604  26.410  33.843  1.00 58.03           C  
ATOM   1488  O   GLU B  91      21.702  26.805  33.099  1.00 57.65           O  
ATOM   1489  CB  GLU B  91      24.298  27.579  32.455  1.00 58.85           C  
ATOM   1490  CG  GLU B  91      25.605  28.307  32.331  1.00 59.54           C  
ATOM   1491  CD  GLU B  91      25.889  28.727  30.906  1.00 60.72           C  
ATOM   1492  OE1 GLU B  91      26.380  27.899  30.096  1.00 58.18           O  
ATOM   1493  OE2 GLU B  91      25.628  29.911  30.604  1.00 62.64           O  
ATOM   1494  N   GLU B  92      22.487  25.367  34.652  1.00 57.60           N  
ATOM   1495  CA  GLU B  92      21.287  24.546  34.757  1.00 57.98           C  
ATOM   1496  C   GLU B  92      20.042  25.364  35.106  1.00 57.59           C  
ATOM   1497  O   GLU B  92      19.069  25.344  34.357  1.00 58.43           O  
ATOM   1498  CB  GLU B  92      21.515  23.465  35.805  1.00 58.56           C  
ATOM   1499  CG  GLU B  92      20.691  22.198  35.662  1.00 61.41           C  
ATOM   1500  CD  GLU B  92      20.808  21.330  36.914  1.00 65.62           C  
ATOM   1501  OE1 GLU B  92      21.863  20.673  37.099  1.00 67.89           O  
ATOM   1502  OE2 GLU B  92      19.854  21.313  37.727  1.00 66.67           O  
ATOM   1503  N   GLU B  93      20.086  26.098  36.216  1.00 56.88           N  
ATOM   1504  CA  GLU B  93      18.957  26.904  36.689  1.00 56.41           C  
ATOM   1505  C   GLU B  93      18.475  27.946  35.690  1.00 55.98           C  
ATOM   1506  O   GLU B  93      17.271  28.232  35.618  1.00 56.08           O  
ATOM   1507  CB  GLU B  93      19.275  27.602  38.022  1.00 56.23           C  
ATOM   1508  CG  GLU B  93      18.071  28.361  38.573  1.00 57.26           C  
ATOM   1509  CD  GLU B  93      18.439  29.580  39.425  1.00 59.42           C  
ATOM   1510  OE1 GLU B  93      19.174  29.419  40.438  1.00 57.19           O  
ATOM   1511  OE2 GLU B  93      17.963  30.696  39.082  1.00 58.36           O  
ATOM   1512  N   GLN B  94      19.404  28.541  34.950  1.00 55.17           N  
ATOM   1513  CA  GLN B  94      19.013  29.482  33.906  1.00 54.62           C  
ATOM   1514  C   GLN B  94      18.367  28.764  32.725  1.00 53.84           C  
ATOM   1515  O   GLN B  94      17.395  29.263  32.155  1.00 53.75           O  
ATOM   1516  CB  GLN B  94      20.186  30.341  33.447  1.00 54.93           C  
ATOM   1517  CG  GLN B  94      20.799  31.200  34.558  1.00 57.21           C  
ATOM   1518  CD  GLN B  94      21.998  30.527  35.232  1.00 60.13           C  
ATOM   1519  OE1 GLN B  94      21.870  29.526  35.955  1.00 61.29           O  
ATOM   1520  NE2 GLN B  94      23.177  31.081  34.989  1.00 59.98           N  
ATOM   1521  N   VAL B  95      18.879  27.593  32.347  1.00 52.95           N  
ATOM   1522  CA  VAL B  95      18.244  26.867  31.240  1.00 52.39           C  
ATOM   1523  C   VAL B  95      16.871  26.393  31.728  1.00 52.02           C  
ATOM   1524  O   VAL B  95      15.918  26.430  30.982  1.00 51.87           O  
ATOM   1525  CB  VAL B  95      19.131  25.689  30.613  1.00 52.88           C  
ATOM   1526  CG1 VAL B  95      18.389  24.943  29.447  1.00 51.18           C  
ATOM   1527  CG2 VAL B  95      20.498  26.197  30.136  1.00 50.92           C  
ATOM   1528  N   ARG B  96      16.793  25.965  32.987  1.00 51.83           N  
ATOM   1529  CA  ARG B  96      15.545  25.553  33.651  1.00 52.29           C  
ATOM   1530  C   ARG B  96      14.347  26.512  33.460  1.00 52.40           C  
ATOM   1531  O   ARG B  96      13.191  26.065  33.391  1.00 52.63           O  
ATOM   1532  CB  ARG B  96      15.807  25.344  35.163  1.00 52.67           C  
ATOM   1533  CG  ARG B  96      15.771  23.896  35.659  1.00 53.44           C  
ATOM   1534  CD  ARG B  96      16.923  23.529  36.618  1.00 54.93           C  
ATOM   1535  NE  ARG B  96      16.997  24.368  37.816  1.00 57.25           N  
ATOM   1536  CZ  ARG B  96      17.794  24.126  38.863  1.00 57.27           C  
ATOM   1537  NH1 ARG B  96      18.570  23.049  38.874  1.00 57.35           N  
ATOM   1538  NH2 ARG B  96      17.807  24.951  39.911  1.00 54.47           N  
ATOM   1539  N   GLU B  97      14.611  27.822  33.404  1.00 52.16           N  
ATOM   1540  CA  GLU B  97      13.530  28.803  33.333  1.00 52.06           C  
ATOM   1541  C   GLU B  97      13.058  29.092  31.917  1.00 50.85           C  
ATOM   1542  O   GLU B  97      11.934  29.526  31.720  1.00 50.34           O  
ATOM   1543  CB  GLU B  97      13.818  30.092  34.132  1.00 52.08           C  
ATOM   1544  CG  GLU B  97      15.261  30.531  34.208  1.00 54.47           C  
ATOM   1545  CD  GLU B  97      15.513  31.611  35.272  1.00 55.38           C  
ATOM   1546  OE1 GLU B  97      14.978  32.735  35.115  1.00 59.89           O  
ATOM   1547  OE2 GLU B  97      16.255  31.349  36.256  1.00 58.46           O  
ATOM   1548  N   ILE B  98      13.897  28.819  30.925  1.00 50.26           N  
ATOM   1549  CA  ILE B  98      13.482  28.987  29.535  1.00 49.66           C  
ATOM   1550  C   ILE B  98      13.181  27.675  28.778  1.00 49.75           C  
ATOM   1551  O   ILE B  98      12.719  27.701  27.646  1.00 49.25           O  
ATOM   1552  CB  ILE B  98      14.476  29.925  28.734  1.00 50.24           C  
ATOM   1553  CG1 ILE B  98      15.935  29.435  28.765  1.00 50.10           C  
ATOM   1554  CG2 ILE B  98      14.438  31.381  29.293  1.00 49.40           C  
ATOM   1555  CD1 ILE B  98      16.207  28.058  28.116  1.00 46.95           C  
ATOM   1556  N   TYR B  99      13.432  26.536  29.417  1.00 49.36           N  
ATOM   1557  CA  TYR B  99      13.356  25.235  28.776  1.00 49.78           C  
ATOM   1558  C   TYR B  99      11.902  24.892  28.452  1.00 49.81           C  
ATOM   1559  O   TYR B  99      11.071  24.838  29.343  1.00 48.32           O  
ATOM   1560  CB  TYR B  99      13.970  24.168  29.694  1.00 51.07           C  
ATOM   1561  CG  TYR B  99      14.006  22.756  29.141  1.00 51.20           C  
ATOM   1562  CD1 TYR B  99      15.083  22.314  28.400  1.00 50.36           C  
ATOM   1563  CD2 TYR B  99      12.969  21.846  29.402  1.00 52.54           C  
ATOM   1564  CE1 TYR B  99      15.130  21.022  27.897  1.00 53.46           C  
ATOM   1565  CE2 TYR B  99      13.009  20.554  28.899  1.00 53.50           C  
ATOM   1566  CZ  TYR B  99      14.100  20.149  28.143  1.00 53.87           C  
ATOM   1567  OH  TYR B  99      14.184  18.863  27.618  1.00 55.70           O  
ATOM   1568  N   GLY B 100      11.623  24.655  27.169  1.00 49.52           N  
ATOM   1569  CA  GLY B 100      10.291  24.279  26.734  1.00 49.99           C  
ATOM   1570  C   GLY B 100      10.332  23.184  25.691  1.00 49.91           C  
ATOM   1571  O   GLY B 100      11.383  22.587  25.480  1.00 48.93           O  
ATOM   1572  N   PRO B 101       9.167  22.907  25.039  1.00 50.75           N  
ATOM   1573  CA  PRO B 101       9.057  21.887  23.975  1.00 50.28           C  
ATOM   1574  C   PRO B 101      10.108  21.989  22.856  1.00 50.95           C  
ATOM   1575  O   PRO B 101      10.568  20.940  22.363  1.00 52.50           O  
ATOM   1576  CB  PRO B 101       7.645  22.084  23.434  1.00 50.17           C  
ATOM   1577  CG  PRO B 101       6.858  22.696  24.581  1.00 48.97           C  
ATOM   1578  CD  PRO B 101       7.859  23.560  25.305  1.00 49.82           C  
ATOM   1579  N   VAL B 102      10.504  23.187  22.448  1.00 50.50           N  
ATOM   1580  CA  VAL B 102      11.568  23.281  21.421  1.00 50.38           C  
ATOM   1581  C   VAL B 102      12.866  22.596  21.936  1.00 50.76           C  
ATOM   1582  O   VAL B 102      13.443  21.803  21.207  1.00 50.48           O  
ATOM   1583  CB  VAL B 102      11.863  24.732  20.965  1.00 50.66           C  
ATOM   1584  CG1 VAL B 102      13.145  24.824  20.030  1.00 49.56           C  
ATOM   1585  CG2 VAL B 102      10.691  25.331  20.310  1.00 49.44           C  
ATOM   1586  N   HIS B 103      13.285  22.863  23.193  1.00 49.89           N  
ATOM   1587  CA  HIS B 103      14.457  22.159  23.759  1.00 48.83           C  
ATOM   1588  C   HIS B 103      14.262  20.646  23.895  1.00 48.77           C  
ATOM   1589  O   HIS B 103      15.182  19.880  23.628  1.00 49.00           O  
ATOM   1590  CB  HIS B 103      14.926  22.742  25.099  1.00 48.24           C  
ATOM   1591  CG  HIS B 103      15.119  24.222  25.091  1.00 48.95           C  
ATOM   1592  ND1 HIS B 103      14.094  25.101  25.335  1.00 49.71           N  
ATOM   1593  CD2 HIS B 103      16.222  24.986  24.896  1.00 52.52           C  
ATOM   1594  CE1 HIS B 103      14.545  26.342  25.247  1.00 48.49           C  
ATOM   1595  NE2 HIS B 103      15.832  26.299  24.998  1.00 47.01           N  
ATOM   1596  N   SER B 104      13.082  20.205  24.316  1.00 48.81           N  
ATOM   1597  CA  SER B 104      12.857  18.781  24.499  1.00 48.78           C  
ATOM   1598  C   SER B 104      12.673  17.994  23.197  1.00 48.22           C  
ATOM   1599  O   SER B 104      12.960  16.779  23.163  1.00 48.17           O  
ATOM   1600  CB  SER B 104      11.677  18.503  25.429  1.00 48.45           C  
ATOM   1601  OG  SER B 104      10.505  19.013  24.864  1.00 51.40           O  
ATOM   1602  N   ARG B 105      12.197  18.654  22.147  1.00 47.60           N  
ATOM   1603  CA  ARG B 105      12.243  18.042  20.809  1.00 47.69           C  
ATOM   1604  C   ARG B 105      13.684  17.867  20.333  1.00 48.02           C  
ATOM   1605  O   ARG B 105      13.965  16.986  19.559  1.00 48.38           O  
ATOM   1606  CB  ARG B 105      11.423  18.820  19.769  1.00 47.64           C  
ATOM   1607  CG  ARG B 105       9.930  18.580  19.854  1.00 47.31           C  
ATOM   1608  CD  ARG B 105       9.174  19.248  18.684  1.00 46.56           C  
ATOM   1609  NE  ARG B 105       9.278  20.709  18.700  1.00 48.28           N  
ATOM   1610  CZ  ARG B 105       8.422  21.542  19.296  1.00 45.44           C  
ATOM   1611  NH1 ARG B 105       7.383  21.092  19.979  1.00 47.90           N  
ATOM   1612  NH2 ARG B 105       8.603  22.841  19.203  1.00 44.59           N  
ATOM   1613  N   LEU B 106      14.602  18.693  20.826  1.00 49.31           N  
ATOM   1614  CA  LEU B 106      16.029  18.541  20.478  1.00 49.66           C  
ATOM   1615  C   LEU B 106      16.651  17.414  21.286  1.00 49.47           C  
ATOM   1616  O   LEU B 106      17.437  16.639  20.756  1.00 49.77           O  
ATOM   1617  CB  LEU B 106      16.824  19.852  20.634  1.00 48.93           C  
ATOM   1618  CG  LEU B 106      16.456  20.965  19.653  1.00 49.33           C  
ATOM   1619  CD1 LEU B 106      17.159  22.272  20.045  1.00 48.80           C  
ATOM   1620  CD2 LEU B 106      16.776  20.557  18.199  1.00 45.58           C  
ATOM   1621  N   LEU B 107      16.276  17.328  22.555  1.00 49.81           N  
ATOM   1622  CA  LEU B 107      16.673  16.200  23.409  1.00 50.07           C  
ATOM   1623  C   LEU B 107      16.162  14.830  22.932  1.00 50.46           C  
ATOM   1624  O   LEU B 107      16.921  13.877  22.959  1.00 52.32           O  
ATOM   1625  CB  LEU B 107      16.281  16.460  24.867  1.00 49.11           C  
ATOM   1626  CG  LEU B 107      16.540  15.313  25.841  1.00 48.72           C  
ATOM   1627  CD1 LEU B 107      18.073  15.107  26.033  1.00 49.43           C  
ATOM   1628  CD2 LEU B 107      15.906  15.670  27.148  1.00 47.88           C  
ATOM   1629  N   LYS B 108      14.901  14.722  22.510  1.00 51.28           N  
ATOM   1630  CA  LYS B 108      14.379  13.505  21.851  1.00 51.56           C  
ATOM   1631  C   LYS B 108      15.241  13.002  20.670  1.00 51.35           C  
ATOM   1632  O   LYS B 108      15.473  11.810  20.548  1.00 52.04           O  
ATOM   1633  CB  LYS B 108      12.938  13.733  21.367  1.00 52.44           C  
ATOM   1634  CG  LYS B 108      12.203  12.491  20.726  1.00 53.17           C  
ATOM   1635  CD  LYS B 108      12.527  12.299  19.204  1.00 56.79           C  
ATOM   1636  CE  LYS B 108      11.721  11.133  18.544  1.00 56.96           C  
ATOM   1637  NZ  LYS B 108      10.491  11.655  17.861  1.00 60.41           N  
ATOM   1638  N   GLN B 109      15.665  13.911  19.791  1.00 51.29           N  
ATOM   1639  CA  GLN B 109      16.525  13.615  18.640  1.00 51.19           C  
ATOM   1640  C   GLN B 109      17.929  13.221  19.054  1.00 51.10           C  
ATOM   1641  O   GLN B 109      18.523  12.380  18.406  1.00 52.37           O  
ATOM   1642  CB  GLN B 109      16.632  14.820  17.728  1.00 52.09           C  
ATOM   1643  CG  GLN B 109      15.388  15.103  16.911  1.00 55.23           C  
ATOM   1644  CD  GLN B 109      15.565  16.279  15.973  1.00 59.28           C  
ATOM   1645  OE1 GLN B 109      16.176  16.163  14.908  1.00 63.43           O  
ATOM   1646  NE2 GLN B 109      15.004  17.414  16.350  1.00 61.66           N  
ATOM   1647  N   ALA B 110      18.460  13.817  20.130  1.00 50.47           N  
ATOM   1648  CA  ALA B 110      19.731  13.391  20.677  1.00 50.31           C  
ATOM   1649  C   ALA B 110      19.659  12.015  21.330  1.00 50.91           C  
ATOM   1650  O   ALA B 110      20.636  11.254  21.248  1.00 50.58           O  
ATOM   1651  CB  ALA B 110      20.282  14.384  21.642  1.00 49.16           C  
ATOM   1652  N   LEU B 111      18.535  11.702  21.991  1.00 51.37           N  
ATOM   1653  CA  LEU B 111      18.381  10.388  22.599  1.00 51.59           C  
ATOM   1654  C   LEU B 111      18.218   9.330  21.539  1.00 52.31           C  
ATOM   1655  O   LEU B 111      18.618   8.207  21.777  1.00 53.74           O  
ATOM   1656  CB  LEU B 111      17.237  10.321  23.618  1.00 51.64           C  
ATOM   1657  CG  LEU B 111      17.379  11.178  24.885  1.00 51.23           C  
ATOM   1658  CD1 LEU B 111      16.037  11.430  25.626  1.00 51.15           C  
ATOM   1659  CD2 LEU B 111      18.427  10.657  25.841  1.00 51.88           C  
ATOM   1660  N   ASP B 112      17.664   9.674  20.376  1.00 53.00           N  
ATOM   1661  CA  ASP B 112      17.496   8.733  19.263  1.00 53.98           C  
ATOM   1662  C   ASP B 112      18.839   8.240  18.731  1.00 53.90           C  
ATOM   1663  O   ASP B 112      18.888   7.227  18.069  1.00 53.94           O  
ATOM   1664  CB  ASP B 112      16.776   9.396  18.066  1.00 55.21           C  
ATOM   1665  CG  ASP B 112      15.257   9.614  18.273  1.00 58.19           C  
ATOM   1666  OD1 ASP B 112      14.695   9.280  19.355  1.00 59.52           O  
ATOM   1667  OD2 ASP B 112      14.634  10.153  17.312  1.00 58.88           O  
ATOM   1668  N   LEU B 113      19.914   8.980  18.988  1.00 54.06           N  
ATOM   1669  CA  LEU B 113      21.235   8.642  18.456  1.00 54.45           C  
ATOM   1670  C   LEU B 113      21.844   7.445  19.187  1.00 55.45           C  
ATOM   1671  O   LEU B 113      22.804   6.837  18.701  1.00 55.39           O  
ATOM   1672  CB  LEU B 113      22.197   9.849  18.507  1.00 53.29           C  
ATOM   1673  CG  LEU B 113      21.879  11.105  17.684  1.00 51.00           C  
ATOM   1674  CD1 LEU B 113      22.813  12.223  18.103  1.00 46.87           C  
ATOM   1675  CD2 LEU B 113      21.965  10.868  16.171  1.00 47.66           C  
ATOM   1676  N   ILE B 114      21.274   7.114  20.348  1.00 56.21           N  
ATOM   1677  CA  ILE B 114      21.772   6.024  21.159  1.00 56.89           C  
ATOM   1678  C   ILE B 114      21.574   4.699  20.438  1.00 57.96           C  
ATOM   1679  O   ILE B 114      20.456   4.334  20.086  1.00 58.54           O  
ATOM   1680  CB  ILE B 114      21.104   5.978  22.545  1.00 56.99           C  
ATOM   1681  CG1 ILE B 114      21.426   7.255  23.320  1.00 55.49           C  
ATOM   1682  CG2 ILE B 114      21.569   4.726  23.319  1.00 56.32           C  
ATOM   1683  CD1 ILE B 114      20.752   7.334  24.699  1.00 57.09           C  
ATOM   1684  N   ASN B 115      22.691   4.013  20.196  1.00 59.03           N  
ATOM   1685  CA  ASN B 115      22.733   2.673  19.606  1.00 59.43           C  
ATOM   1686  C   ASN B 115      22.126   1.693  20.613  1.00 59.31           C  
ATOM   1687  O   ASN B 115      22.834   1.000  21.317  1.00 59.82           O  
ATOM   1688  CB  ASN B 115      24.208   2.336  19.308  1.00 59.22           C  
ATOM   1689  CG  ASN B 115      24.390   1.144  18.400  1.00 60.37           C  
ATOM   1690  OD1 ASN B 115      23.652   0.963  17.410  1.00 61.72           O  
ATOM   1691  ND2 ASN B 115      25.431   0.330  18.698  1.00 58.80           N  
ATOM   1692  N   ASN B 116      20.804   1.720  20.714  1.00 59.50           N  
ATOM   1693  CA  ASN B 116      19.997   0.838  21.564  1.00 60.01           C  
ATOM   1694  C   ASN B 116      19.995  -0.583  20.947  1.00 59.76           C  
ATOM   1695  O   ASN B 116      19.908  -0.702  19.730  1.00 59.37           O  
ATOM   1696  CB  ASN B 116      18.591   1.488  21.652  1.00 60.07           C  
ATOM   1697  CG  ASN B 116      17.451   0.505  21.953  1.00 62.83           C  
ATOM   1698  OD1 ASN B 116      17.045  -0.311  21.108  1.00 64.52           O  
ATOM   1699  ND2 ASN B 116      16.869   0.645  23.141  1.00 66.06           N  
ATOM   1700  N   ALA B 117      20.128  -1.643  21.754  1.00 59.68           N  
ATOM   1701  CA  ALA B 117      20.034  -3.028  21.222  1.00 60.51           C  
ATOM   1702  C   ALA B 117      18.574  -3.483  21.127  1.00 61.11           C  
ATOM   1703  O   ALA B 117      17.773  -3.120  21.986  1.00 61.95           O  
ATOM   1704  CB  ALA B 117      20.845  -4.006  22.056  1.00 59.74           C  
ATOM   1705  N   ASP B 118      18.224  -4.265  20.102  1.00 61.82           N  
ATOM   1706  CA  ASP B 118      16.790  -4.557  19.789  1.00 62.54           C  
ATOM   1707  C   ASP B 118      16.282  -3.813  18.531  1.00 62.61           C  
ATOM   1708  O   ASP B 118      16.062  -2.585  18.548  1.00 62.35           O  
ATOM   1709  CB  ASP B 118      15.876  -4.236  20.993  1.00 62.61           C  
ATOM   1710  CG  ASP B 118      14.462  -4.738  20.815  1.00 62.97           C  
ATOM   1711  OD1 ASP B 118      14.279  -5.902  20.394  1.00 63.34           O  
ATOM   1712  OD2 ASP B 118      13.529  -3.967  21.126  1.00 63.22           O  
TER    1713      ASP B 118                                                      
END
MOLECULE T0465.pdb
ATOM      1  N   GLU     7      39.181 -18.735  26.768  1.00 35.74           N  
ATOM      2  CA  GLU     7      38.293 -18.388  27.927  1.00 35.74           C  
ATOM      3  CB  GLU     7      36.984 -19.212  27.923  1.00 35.95           C  
ATOM      4  CG  GLU     7      36.957 -20.406  28.946  1.00 37.55           C  
ATOM      5  CD  GLU     7      35.986 -21.556  28.570  1.00 37.74           C  
ATOM      6  OE1 GLU     7      35.161 -21.412  27.614  1.00 39.56           O  
ATOM      7  OE2 GLU     7      36.068 -22.622  29.249  1.00 41.55           O  
ATOM      8  C   GLU     7      39.006 -18.539  29.273  1.00 34.40           C  
ATOM      9  O   GLU     7      39.106 -17.566  30.008  1.00 34.63           O  
ATOM     10  N   LYS     8      39.512 -19.734  29.596  1.00 33.05           N  
ATOM     11  CA  LYS     8      40.036 -19.984  30.948  1.00 31.69           C  
ATOM     12  CB  LYS     8      40.792 -21.302  31.047  1.00 31.72           C  
ATOM     13  CG  LYS     8      39.830 -22.450  31.184  1.00 31.94           C  
ATOM     14  CD  LYS     8      39.426 -22.651  32.677  1.00 31.74           C  
ATOM     15  CE  LYS     8      38.629 -23.960  32.730  1.00 31.25           C  
ATOM     16  NZ  LYS     8      39.312 -24.858  33.695  1.00 31.01           N  
ATOM     17  C   LYS     8      40.795 -18.843  31.627  1.00 30.68           C  
ATOM     18  O   LYS     8      40.556 -18.598  32.818  1.00 31.53           O  
ATOM     19  N   VAL     9      41.667 -18.128  30.892  1.00 28.15           N  
ATOM     20  CA  VAL     9      42.164 -16.793  31.343  1.00 25.60           C  
ATOM     21  CB  VAL     9      43.695 -16.795  31.785  1.00 26.03           C  
ATOM     22  CG1 VAL     9      44.649 -17.284  30.653  1.00 27.43           C  
ATOM     23  CG2 VAL     9      44.111 -15.433  32.402  1.00 27.28           C  
ATOM     24  C   VAL     9      41.772 -15.657  30.366  1.00 22.74           C  
ATOM     25  O   VAL     9      42.379 -15.475  29.305  1.00 23.05           O  
ATOM     26  N   TYR    10      40.728 -14.922  30.746  1.00 18.97           N  
ATOM     27  CA  TYR    10      40.061 -13.910  29.908  1.00 14.92           C  
ATOM     28  CB  TYR    10      38.718 -13.553  30.541  1.00 15.61           C  
ATOM     29  CG  TYR    10      37.710 -14.662  30.537  1.00 15.84           C  
ATOM     30  CD1 TYR    10      36.904 -14.872  29.420  1.00 16.74           C  
ATOM     31  CE1 TYR    10      35.980 -15.883  29.403  1.00 17.07           C  
ATOM     32  CZ  TYR    10      35.823 -16.698  30.508  1.00 15.22           C  
ATOM     33  OH  TYR    10      34.875 -17.702  30.455  1.00 14.31           O  
ATOM     34  CE2 TYR    10      36.603 -16.499  31.650  1.00 15.67           C  
ATOM     35  CD2 TYR    10      37.536 -15.478  31.658  1.00 14.34           C  
ATOM     36  C   TYR    10      40.838 -12.604  29.797  1.00 11.90           C  
ATOM     37  O   TYR    10      41.562 -12.260  30.714  1.00 11.56           O  
ATOM     38  N   ASP    11      40.637 -11.852  28.713  1.00  7.48           N  
ATOM     39  CA  ASP    11      41.538 -10.760  28.381  1.00  4.06           C  
ATOM     40  CB  ASP    11      42.265 -11.010  27.035  1.00  3.92           C  
ATOM     41  CG  ASP    11      42.927  -9.738  26.431  1.00  4.77           C  
ATOM     42  OD1 ASP    11      42.837  -8.625  26.983  1.00  2.00           O  
ATOM     43  OD2 ASP    11      43.540  -9.866  25.350  1.00  4.72           O  
ATOM     44  C   ASP    11      40.800  -9.440  28.463  1.00  2.15           C  
ATOM     45  O   ASP    11      39.897  -9.141  27.731  1.00  2.00           O  
ATOM     46  N   LEU    12      41.190  -8.654  29.417  1.00  2.00           N  
ATOM     47  CA  LEU    12      40.387  -7.534  29.686  1.00  2.00           C  
ATOM     48  CB  LEU    12      40.126  -7.459  31.181  1.00  2.00           C  
ATOM     49  CG  LEU    12      39.614  -8.713  31.920  1.00  2.00           C  
ATOM     50  CD1 LEU    12      40.109  -8.741  33.367  1.00  2.00           C  
ATOM     51  CD2 LEU    12      38.076  -8.903  31.838  1.00  2.00           C  
ATOM     52  C   LEU    12      41.003  -6.263  29.202  1.00  2.00           C  
ATOM     53  O   LEU    12      40.435  -5.242  29.411  1.00  2.00           O  
ATOM     54  N   SER    13      42.124  -6.292  28.510  1.00  2.00           N  
ATOM     55  CA  SER    13      42.616  -5.082  27.843  1.00  2.00           C  
ATOM     56  CB  SER    13      43.754  -5.333  26.841  1.00  2.00           C  
ATOM     57  OG  SER    13      43.879  -6.689  26.373  1.00  2.00           O  
ATOM     58  C   SER    13      41.529  -4.341  27.149  1.00  2.00           C  
ATOM     59  O   SER    13      41.547  -3.158  27.191  1.00  2.00           O  
ATOM     60  N   PHE    14      40.565  -5.032  26.552  1.00  2.00           N  
ATOM     61  CA  PHE    14      39.562  -4.417  25.681  1.00  2.00           C  
ATOM     62  CB  PHE    14      38.816  -5.425  24.859  1.00  2.00           C  
ATOM     63  CG  PHE    14      39.686  -6.428  24.165  1.00  2.00           C  
ATOM     64  CD1 PHE    14      40.719  -6.030  23.344  1.00  2.00           C  
ATOM     65  CE1 PHE    14      41.480  -6.974  22.723  1.00  2.00           C  
ATOM     66  CZ  PHE    14      41.179  -8.301  22.859  1.00  2.00           C  
ATOM     67  CE2 PHE    14      40.133  -8.694  23.636  1.00  2.00           C  
ATOM     68  CD2 PHE    14      39.413  -7.773  24.296  1.00  2.00           C  
ATOM     69  C   PHE    14      38.502  -3.609  26.382  1.00  2.00           C  
ATOM     70  O   PHE    14      37.622  -2.934  25.731  1.00  2.00           O  
ATOM     71  N   PHE    15      38.504  -3.701  27.703  1.00  2.20           N  
ATOM     72  CA  PHE    15      37.459  -3.028  28.506  1.00  5.00           C  
ATOM     73  CB  PHE    15      36.753  -4.068  29.406  1.00  3.46           C  
ATOM     74  CG  PHE    15      35.994  -5.147  28.630  1.00  2.00           C  
ATOM     75  CD1 PHE    15      34.777  -4.865  28.012  1.00  2.00           C  
ATOM     76  CE1 PHE    15      34.106  -5.880  27.298  1.00  2.00           C  
ATOM     77  CZ  PHE    15      34.649  -7.109  27.203  1.00  2.00           C  
ATOM     78  CE2 PHE    15      35.815  -7.364  27.781  1.00  2.00           C  
ATOM     79  CD2 PHE    15      36.489  -6.407  28.485  1.00  2.00           C  
ATOM     80  C   PHE    15      38.109  -1.927  29.293  1.00  8.24           C  
ATOM     81  O   PHE    15      37.448  -1.241  30.029  1.00  9.45           O  
ATOM     82  N   MET    16      39.421  -1.736  29.119  1.00 13.00           N  
ATOM     83  CA  MET    16      40.097  -0.549  29.669  1.00 18.94           C  
ATOM     84  CB  MET    16      41.381  -1.004  30.281  1.00 16.16           C  
ATOM     85  CG  MET    16      41.078  -1.510  31.594  1.00 16.44           C  
ATOM     86  SD  MET    16      42.327  -2.822  31.983  1.00 30.70          SE  
ATOM     87  CE  MET    16      43.973  -1.683  32.072  1.00 33.27           C  
ATOM     88  C   MET    16      40.241   0.642  28.694  1.00 18.98           C  
ATOM     89  O   MET    16      39.950   0.483  27.539  1.00 18.36           O  
ATOM     90  N   PRO    17      40.667   1.849  29.150  1.00 22.20           N  
ATOM     91  CA  PRO    17      40.533   3.050  28.205  1.00 23.49           C  
ATOM     92  CB  PRO    17      40.550   4.281  29.145  1.00 23.77           C  
ATOM     93  CG  PRO    17      40.856   3.672  30.629  1.00 24.25           C  
ATOM     94  CD  PRO    17      41.321   2.214  30.430  1.00 22.54           C  
ATOM     95  C   PRO    17      41.665   3.079  27.116  1.00 25.81           C  
ATOM     96  O   PRO    17      42.853   3.257  27.433  1.00 26.39           O  
ATOM     97  N   GLY    18      41.284   2.853  25.850  1.00 27.16           N  
ATOM     98  CA  GLY    18      42.128   2.118  24.852  1.00 26.72           C  
ATOM     99  C   GLY    18      41.203   1.008  24.346  1.00 27.34           C  
ATOM    100  O   GLY    18      41.438  -0.166  24.587  1.00 26.98           O  
ATOM    101  N   GLN    19      40.192   1.451  23.592  1.00 28.31           N  
ATOM    102  CA  GLN    19      38.850   0.916  23.420  1.00 29.72           C  
ATOM    103  CB  GLN    19      38.311   0.547  24.747  1.00 29.30           C  
ATOM    104  CG  GLN    19      37.996   1.806  25.460  1.00 30.00           C  
ATOM    105  CD  GLN    19      36.705   1.742  26.088  1.00 31.41           C  
ATOM    106  OE1 GLN    19      36.383   0.754  26.723  1.00 34.42           O  
ATOM    107  NE2 GLN    19      35.926   2.807  25.965  1.00 36.02           N  
ATOM    108  C   GLN    19      37.928   2.107  22.981  1.00 31.46           C  
ATOM    109  O   GLN    19      38.005   3.201  23.558  1.00 30.65           O  
ATOM    110  N   THR    20      37.013   1.873  22.033  1.00 33.63           N  
ATOM    111  CA  THR    20      36.372   2.942  21.259  1.00 35.03           C  
ATOM    112  CB  THR    20      35.409   2.408  20.173  1.00 34.00           C  
ATOM    113  OG1 THR    20      36.116   1.612  19.222  1.00 30.50           O  
ATOM    114  CG2 THR    20      34.792   3.540  19.441  1.00 33.25           C  
ATOM    115  C   THR    20      35.642   3.890  22.181  1.00 38.23           C  
ATOM    116  O   THR    20      34.451   4.055  22.073  1.00 38.53           O  
ATOM    117  N   ILE    21      36.355   4.473  23.132  1.00 42.14           N  
ATOM    118  CA  ILE    21      35.726   5.447  24.020  1.00 46.02           C  
ATOM    119  CB  ILE    21      36.580   5.899  25.407  1.00 46.89           C  
ATOM    120  CG1 ILE    21      35.653   6.218  26.632  1.00 46.90           C  
ATOM    121  CD1 ILE    21      34.225   6.965  26.324  1.00 48.39           C  
ATOM    122  CG2 ILE    21      37.783   6.919  25.177  1.00 48.24           C  
ATOM    123  C   ILE    21      35.285   6.473  23.013  1.00 47.40           C  
ATOM    124  O   ILE    21      36.018   7.352  22.560  1.00 47.65           O  
ATOM    125  N   ASP    22      34.059   6.214  22.598  1.00 49.79           N  
ATOM    126  CA  ASP    22      33.397   6.930  21.556  1.00 51.42           C  
ATOM    127  CB  ASP    22      32.361   6.034  20.824  1.00 52.13           C  
ATOM    128  CG  ASP    22      32.055   6.505  19.368  1.00 54.54           C  
ATOM    129  OD1 ASP    22      31.388   7.588  19.250  1.00 56.75           O  
ATOM    130  OD2 ASP    22      32.433   5.782  18.370  1.00 51.30           O  
ATOM    131  C   ASP    22      32.746   8.052  22.320  1.00 52.10           C  
ATOM    132  O   ASP    22      31.615   7.945  22.835  1.00 52.12           O  
ATOM    133  N   ALA    23      33.545   9.109  22.458  1.00 52.47           N  
ATOM    134  CA  ALA    23      33.010  10.440  22.371  1.00 51.86           C  
ATOM    135  CB  ALA    23      34.132  11.493  22.011  1.00 52.38           C  
ATOM    136  C   ALA    23      32.034  10.275  21.226  1.00 51.09           C  
ATOM    137  O   ALA    23      32.423   9.928  20.099  1.00 50.98           O  
ATOM    138  N   GLU    24      30.756  10.449  21.538  1.00 50.03           N  
ATOM    139  CA  GLU    24      29.774  10.722  20.494  1.00 47.56           C  
ATOM    140  CB  GLU    24      28.384  10.986  21.115  1.00 47.16           C  
ATOM    141  CG  GLU    24      27.880   9.859  22.054  1.00 48.48           C  
ATOM    142  CD  GLU    24      27.516   8.534  21.286  1.00 56.04           C  
ATOM    143  OE1 GLU    24      26.455   8.513  20.587  1.00 56.34           O  
ATOM    144  OE2 GLU    24      28.289   7.510  21.362  1.00 57.71           O  
ATOM    145  C   GLU    24      30.327  11.853  19.585  1.00 45.64           C  
ATOM    146  O   GLU    24      30.845  11.570  18.546  1.00 46.00           O  
ATOM    147  N   GLU    25      30.344  13.110  20.025  1.00 44.59           N  
ATOM    148  CA  GLU    25      30.313  14.269  19.108  1.00 40.46           C  
ATOM    149  CB  GLU    25      31.702  14.685  18.742  1.00 41.26           C  
ATOM    150  CG  GLU    25      31.765  16.136  18.358  1.00 42.09           C  
ATOM    151  CD  GLU    25      32.346  16.971  19.481  1.00 43.84           C  
ATOM    152  OE1 GLU    25      32.775  18.119  19.196  1.00 43.62           O  
ATOM    153  OE2 GLU    25      32.429  16.455  20.631  1.00 43.14           O  
ATOM    154  C   GLU    25      29.505  13.895  17.860  1.00 37.47           C  
ATOM    155  O   GLU    25      30.030  13.317  16.939  1.00 36.40           O  
ATOM    156  N   VAL    26      28.212  14.160  17.886  1.00 33.76           N  
ATOM    157  CA  VAL    26      27.338  13.829  16.795  1.00 30.97           C  
ATOM    158  CB  VAL    26      26.341  12.723  17.212  1.00 30.09           C  
ATOM    159  CG1 VAL    26      25.156  12.687  16.310  1.00 30.98           C  
ATOM    160  CG2 VAL    26      26.990  11.392  17.219  1.00 31.70           C  
ATOM    161  C   VAL    26      26.628  15.136  16.402  1.00 29.39           C  
ATOM    162  O   VAL    26      26.017  15.768  17.237  1.00 29.58           O  
ATOM    163  N   GLU    27      26.742  15.567  15.144  1.00 28.50           N  
ATOM    164  CA  GLU    27      26.029  16.755  14.611  1.00 27.08           C  
ATOM    165  CB  GLU    27      26.785  17.303  13.462  1.00 28.15           C  
ATOM    166  CG  GLU    27      28.027  18.091  13.769  1.00 35.26           C  
ATOM    167  CD  GLU    27      28.381  18.981  12.525  1.00 47.82           C  
ATOM    168  OE1 GLU    27      28.926  20.126  12.709  1.00 51.23           O  
ATOM    169  OE2 GLU    27      28.057  18.543  11.355  1.00 50.12           O  
ATOM    170  C   GLU    27      24.682  16.397  14.047  1.00 24.93           C  
ATOM    171  O   GLU    27      24.551  15.450  13.295  1.00 23.11           O  
ATOM    172  N   VAL    28      23.685  17.172  14.414  1.00 23.19           N  
ATOM    173  CA  VAL    28      22.295  16.903  14.082  1.00 23.34           C  
ATOM    174  CB  VAL    28      21.467  16.262  15.271  1.00 23.67           C  
ATOM    175  CG1 VAL    28      20.054  15.818  14.790  1.00 22.72           C  
ATOM    176  CG2 VAL    28      22.201  15.108  15.980  1.00 23.34           C  
ATOM    177  C   VAL    28      21.631  18.247  13.934  1.00 22.82           C  
ATOM    178  O   VAL    28      21.636  19.032  14.921  1.00 22.97           O  
ATOM    179  N   PRO    29      20.977  18.484  12.785  1.00 21.91           N  
ATOM    180  CA  PRO    29      20.230  19.741  12.554  1.00 22.28           C  
ATOM    181  CB  PRO    29      20.113  19.824  11.060  1.00 20.75           C  
ATOM    182  CG  PRO    29      20.166  18.348  10.613  1.00 22.38           C  
ATOM    183  CD  PRO    29      20.866  17.548  11.662  1.00 22.24           C  
ATOM    184  C   PRO    29      18.848  19.747  13.206  1.00 22.63           C  
ATOM    185  O   PRO    29      17.863  19.288  12.632  1.00 23.83           O  
ATOM    186  N   ILE    30      18.779  20.327  14.386  1.00 22.66           N  
ATOM    187  CA  ILE    30      17.586  20.238  15.212  1.00 22.68           C  
ATOM    188  CB  ILE    30      17.945  20.495  16.673  1.00 21.69           C  
ATOM    189  CG1 ILE    30      18.722  19.301  17.263  1.00 23.56           C  
ATOM    190  CD1 ILE    30      17.941  17.994  17.342  1.00 17.06           C  
ATOM    191  CG2 ILE    30      16.731  20.965  17.463  1.00 23.03           C  
ATOM    192  C   ILE    30      16.532  21.227  14.724  1.00 22.72           C  
ATOM    193  O   ILE    30      15.375  20.884  14.710  1.00 21.85           O  
ATOM    194  N   SER    31      16.966  22.434  14.334  1.00 21.86           N  
ATOM    195  CA  SER    31      16.103  23.452  13.691  1.00 21.54           C  
ATOM    196  CB  SER    31      15.760  24.540  14.738  1.00 21.33           C  
ATOM    197  OG  SER    31      15.406  25.727  14.071  1.00 19.90           O  
ATOM    198  C   SER    31      16.777  24.115  12.442  1.00 20.42           C  
ATOM    199  O   SER    31      17.955  24.563  12.491  1.00 20.06           O  
ATOM    200  N   LYS    32      16.036  24.195  11.350  1.00 18.41           N  
ATOM    201  CA  LYS    32      16.443  25.017  10.170  1.00 18.79           C  
ATOM    202  CB  LYS    32      15.567  24.738   8.931  1.00 17.19           C  
ATOM    203  CG  LYS    32      15.526  23.289   8.432  1.00 19.09           C  
ATOM    204  CD  LYS    32      14.440  23.131   7.330  1.00 19.68           C  
ATOM    205  CE  LYS    32      13.656  21.760   7.361  1.00 24.64           C  
ATOM    206  NZ  LYS    32      12.941  21.381   6.012  1.00 24.01           N  
ATOM    207  C   LYS    32      16.481  26.558  10.440  1.00 18.43           C  
ATOM    208  O   LYS    32      16.786  27.310   9.540  1.00 19.11           O  
ATOM    209  N   ARG    33      16.168  26.996  11.668  1.00 18.15           N  
ATOM    210  CA  ARG    33      16.051  28.410  12.014  1.00 18.44           C  
ATOM    211  CB  ARG    33      15.032  28.650  13.136  1.00 16.04           C  
ATOM    212  CG  ARG    33      13.570  28.311  12.826  1.00 19.41           C  
ATOM    213  CD  ARG    33      12.768  28.212  14.131  1.00 23.06           C  
ATOM    214  NE  ARG    33      13.378  29.140  15.055  1.00 26.92           N  
ATOM    215  CZ  ARG    33      13.494  29.018  16.359  1.00 31.11           C  
ATOM    216  NH1 ARG    33      13.079  27.965  17.045  1.00 31.62           N  
ATOM    217  NH2 ARG    33      14.132  29.976  16.974  1.00 36.23           N  
ATOM    218  C   ARG    33      17.413  28.898  12.481  1.00 18.70           C  
ATOM    219  O   ARG    33      17.624  30.092  12.611  1.00 18.79           O  
ATOM    220  N   PHE    34      18.343  27.991  12.739  1.00 17.86           N  
ATOM    221  CA  PHE    34      19.658  28.471  13.113  1.00 18.49           C  
ATOM    222  CB  PHE    34      20.200  27.723  14.334  1.00 18.10           C  
ATOM    223  CG  PHE    34      19.237  27.686  15.474  1.00 21.15           C  
ATOM    224  CD1 PHE    34      18.803  28.861  16.073  1.00 19.98           C  
ATOM    225  CE1 PHE    34      17.904  28.804  17.136  1.00 22.04           C  
ATOM    226  CZ  PHE    34      17.428  27.577  17.573  1.00 20.31           C  
ATOM    227  CE2 PHE    34      17.845  26.409  16.960  1.00 22.90           C  
ATOM    228  CD2 PHE    34      18.732  26.476  15.927  1.00 21.98           C  
ATOM    229  C   PHE    34      20.615  28.412  11.942  1.00 17.40           C  
ATOM    230  O   PHE    34      20.977  27.329  11.509  1.00 18.58           O  
ATOM    231  N   VAL    35      21.032  29.564  11.427  1.00 17.81           N  
ATOM    232  CA  VAL    35      21.938  29.578  10.277  1.00 18.90           C  
ATOM    233  CB  VAL    35      21.234  29.899   8.907  1.00 19.48           C  
ATOM    234  CG1 VAL    35      20.233  28.788   8.541  1.00 19.67           C  
ATOM    235  CG2 VAL    35      20.532  31.242   8.903  1.00 15.46           C  
ATOM    236  C   VAL    35      23.095  30.492  10.560  1.00 21.01           C  
ATOM    237  O   VAL    35      22.996  31.400  11.394  1.00 21.13           O  
ATOM    238  N   ASP    36      24.217  30.193   9.921  1.00 22.30           N  
ATOM    239  CA  ASP    36      25.357  31.027  10.004  1.00 24.87           C  
ATOM    240  CB  ASP    36      26.662  30.191   9.847  1.00 25.48           C  
ATOM    241  CG  ASP    36      26.851  29.549   8.442  1.00 26.45           C  
ATOM    242  OD1 ASP    36      26.271  29.988   7.422  1.00 29.01           O  
ATOM    243  OD2 ASP    36      27.645  28.600   8.331  1.00 25.54           O  
ATOM    244  C   ASP    36      25.253  32.210   9.006  1.00 26.21           C  
ATOM    245  O   ASP    36      24.199  32.476   8.436  1.00 26.70           O  
ATOM    246  N   LYS    37      26.332  32.952   8.829  1.00 27.60           N  
ATOM    247  CA  LYS    37      26.327  34.114   7.908  1.00 29.41           C  
ATOM    248  CB  LYS    37      27.422  35.136   8.338  1.00 30.68           C  
ATOM    249  CG  LYS    37      28.869  34.509   8.547  1.00 32.91           C  
ATOM    250  CD  LYS    37      29.741  34.640   7.224  1.00 33.76           C  
ATOM    251  CE  LYS    37      31.120  33.853   7.227  1.00 33.44           C  
ATOM    252  NZ  LYS    37      31.141  32.320   7.448  1.00 29.89           N  
ATOM    253  C   LYS    37      26.414  33.733   6.374  1.00 29.68           C  
ATOM    254  O   LYS    37      26.113  34.576   5.510  1.00 30.90           O  
ATOM    255  N   GLU    38      26.836  32.492   6.050  1.00 28.71           N  
ATOM    256  CA  GLU    38      26.718  31.906   4.707  1.00 27.77           C  
ATOM    257  CB  GLU    38      27.766  30.842   4.538  1.00 28.57           C  
ATOM    258  CG  GLU    38      29.183  31.337   4.609  1.00 32.19           C  
ATOM    259  CD  GLU    38      30.130  30.532   3.733  1.00 34.30           C  
ATOM    260  OE1 GLU    38      30.173  29.257   3.825  1.00 32.45           O  
ATOM    261  OE2 GLU    38      30.833  31.223   2.948  1.00 37.07           O  
ATOM    262  C   GLU    38      25.375  31.233   4.377  1.00 25.79           C  
ATOM    263  O   GLU    38      25.250  30.616   3.307  1.00 25.99           O  
ATOM    264  N   GLY    39      24.424  31.286   5.312  1.00 23.87           N  
ATOM    265  CA  GLY    39      23.039  30.877   5.112  1.00 21.45           C  
ATOM    266  C   GLY    39      22.677  29.433   5.387  1.00 20.65           C  
ATOM    267  O   GLY    39      21.528  29.059   5.149  1.00 21.85           O  
ATOM    268  N   ASN    40      23.638  28.634   5.877  1.00 18.13           N  
ATOM    269  CA  ASN    40      23.470  27.204   6.160  1.00 16.01           C  
ATOM    270  CB  ASN    40      24.734  26.441   5.871  1.00 14.98           C  
ATOM    271  CG  ASN    40      25.188  26.589   4.463  1.00 16.86           C  
ATOM    272  OD1 ASN    40      26.375  26.843   4.247  1.00 19.11           O  
ATOM    273  ND2 ASN    40      24.269  26.412   3.465  1.00 14.60           N  
ATOM    274  C   ASN    40      23.162  26.876   7.579  1.00 14.92           C  
ATOM    275  O   ASN    40      23.571  27.593   8.483  1.00 13.89           O  
ATOM    276  N   VAL    41      22.499  25.733   7.746  1.00 14.61           N  
ATOM    277  CA  VAL    41      21.974  25.293   9.050  1.00 15.50           C  
ATOM    278  CB  VAL    41      21.113  24.010   8.965  1.00 14.66           C  
ATOM    279  CG1 VAL    41      20.631  23.607  10.297  1.00 15.90           C  
ATOM    280  CG2 VAL    41      19.921  24.226   8.127  1.00 14.73           C  
ATOM    281  C   VAL    41      23.178  25.046   9.946  1.00 14.95           C  
ATOM    282  O   VAL    41      24.240  24.666   9.486  1.00 15.40           O  
ATOM    283  N   VAL    42      22.986  25.332  11.224  1.00 16.20           N  
ATOM    284  CA  VAL    42      24.032  25.216  12.215  1.00 16.32           C  
ATOM    285  CB  VAL    42      24.089  26.484  13.130  1.00 16.13           C  
ATOM    286  CG1 VAL    42      24.907  26.185  14.282  1.00 12.82           C  
ATOM    287  CG2 VAL    42      24.721  27.694  12.380  1.00 16.83           C  
ATOM    288  C   VAL    42      23.628  23.975  12.989  1.00 16.49           C  
ATOM    289  O   VAL    42      22.633  24.054  13.698  1.00 18.46           O  
ATOM    290  N   PRO    43      24.290  22.815  12.773  1.00 15.85           N  
ATOM    291  CA  PRO    43      23.793  21.708  13.578  1.00 16.52           C  
ATOM    292  CB  PRO    43      24.360  20.469  12.872  1.00 15.23           C  
ATOM    293  CG  PRO    43      25.483  20.945  12.023  1.00 15.28           C  
ATOM    294  CD  PRO    43      25.366  22.398  11.838  1.00 16.43           C  
ATOM    295  C   PRO    43      24.175  21.763  15.093  1.00 15.94           C  
ATOM    296  O   PRO    43      25.091  22.431  15.448  1.00 16.11           O  
ATOM    297  N   PHE    44      23.384  21.116  15.944  1.00 16.71           N  
ATOM    298  CA  PHE    44      23.702  20.855  17.311  1.00 16.38           C  
ATOM    299  CB  PHE    44      22.427  20.390  17.938  1.00 16.80           C  
ATOM    300  CG  PHE    44      21.552  21.510  18.406  1.00 14.20           C  
ATOM    301  CD1 PHE    44      21.293  22.595  17.602  1.00 16.26           C  
ATOM    302  CE1 PHE    44      20.475  23.624  18.074  1.00 18.61           C  
ATOM    303  CZ  PHE    44      19.956  23.593  19.343  1.00 17.71           C  
ATOM    304  CE2 PHE    44      20.255  22.535  20.162  1.00 18.00           C  
ATOM    305  CD2 PHE    44      21.053  21.500  19.662  1.00 14.14           C  
ATOM    306  C   PHE    44      24.705  19.722  17.330  1.00 17.91           C  
ATOM    307  O   PHE    44      24.671  18.857  16.509  1.00 17.55           O  
ATOM    308  N   ILE    45      25.619  19.780  18.273  1.00 18.92           N  
ATOM    309  CA  ILE    45      26.551  18.742  18.576  1.00 20.12           C  
ATOM    310  CB  ILE    45      27.952  19.337  18.578  1.00 19.78           C  
ATOM    311  CG1 ILE    45      28.196  19.976  17.227  1.00 19.58           C  
ATOM    312  CD1 ILE    45      29.511  20.804  17.084  1.00 21.12           C  
ATOM    313  CG2 ILE    45      28.954  18.309  18.888  1.00 20.15           C  
ATOM    314  C   ILE    45      26.182  18.128  19.956  1.00 21.88           C  
ATOM    315  O   ILE    45      26.085  18.830  21.017  1.00 20.95           O  
ATOM    316  N   PHE    46      25.955  16.807  19.901  1.00 22.08           N  
ATOM    317  CA  PHE    46      25.628  15.975  21.027  1.00 20.65           C  
ATOM    318  CB  PHE    46      24.387  15.150  20.738  1.00 20.49           C  
ATOM    319  CG  PHE    46      23.106  15.982  20.505  1.00 21.76           C  
ATOM    320  CD1 PHE    46      22.763  16.424  19.233  1.00 22.02           C  
ATOM    321  CE1 PHE    46      21.562  17.132  19.018  1.00 20.75           C  
ATOM    322  CZ  PHE    46      20.708  17.390  20.056  1.00 20.72           C  
ATOM    323  CE2 PHE    46      21.034  16.985  21.313  1.00 22.02           C  
ATOM    324  CD2 PHE    46      22.212  16.237  21.528  1.00 19.25           C  
ATOM    325  C   PHE    46      26.802  15.052  21.275  1.00 20.65           C  
ATOM    326  O   PHE    46      27.582  14.743  20.373  1.00 20.57           O  
ATOM    327  N   LYS    47      26.951  14.683  22.532  1.00 20.09           N  
ATOM    328  CA  LYS    47      27.899  13.667  22.996  1.00 20.81           C  
ATOM    329  CB  LYS    47      29.237  14.307  23.205  1.00 21.53           C  
ATOM    330  CG  LYS    47      30.384  13.391  23.398  1.00 22.96           C  
ATOM    331  CD  LYS    47      31.402  14.305  24.114  1.00 29.24           C  
ATOM    332  CE  LYS    47      32.737  13.751  24.049  1.00 32.61           C  
ATOM    333  NZ  LYS    47      32.558  12.431  24.712  1.00 34.05           N  
ATOM    334  C   LYS    47      27.409  13.102  24.314  1.00 19.79           C  
ATOM    335  O   LYS    47      27.245  13.830  25.256  1.00 20.41           O  
ATOM    336  N   ALA    48      27.087  11.814  24.358  1.00 20.88           N  
ATOM    337  CA  ALA    48      26.654  11.134  25.608  1.00 19.76           C  
ATOM    338  CB  ALA    48      26.795   9.661  25.445  1.00 20.00           C  
ATOM    339  C   ALA    48      27.403  11.604  26.889  1.00 19.29           C  
ATOM    340  O   ALA    48      28.644  11.778  26.940  1.00 20.25           O  
ATOM    341  N   ILE    49      26.653  11.781  27.952  1.00 17.21           N  
ATOM    342  CA  ILE    49      27.326  11.959  29.244  1.00 16.14           C  
ATOM    343  CB  ILE    49      26.473  12.966  30.111  1.00 16.78           C  
ATOM    344  CG1 ILE    49      25.018  12.476  30.248  1.00 13.52           C  
ATOM    345  CD1 ILE    49      24.302  13.052  31.425  1.00  9.35           C  
ATOM    346  CG2 ILE    49      26.384  14.221  29.328  1.00 14.98           C  
ATOM    347  C   ILE    49      27.658  10.552  29.912  1.00 16.39           C  
ATOM    348  O   ILE    49      27.504   9.481  29.263  1.00 13.99           O  
ATOM    349  N   THR    50      28.148  10.523  31.147  1.00 13.70           N  
ATOM    350  CA  THR    50      28.545   9.220  31.594  1.00 13.79           C  
ATOM    351  CB  THR    50      29.728   9.284  32.451  1.00 13.53           C  
ATOM    352  OG1 THR    50      29.377  10.085  33.558  1.00 14.42           O  
ATOM    353  CG2 THR    50      30.871   9.955  31.688  1.00 13.83           C  
ATOM    354  C   THR    50      27.393   8.651  32.372  1.00 13.57           C  
ATOM    355  O   THR    50      26.437   9.395  32.747  1.00 13.76           O  
ATOM    356  N   THR    51      27.443   7.343  32.578  1.00 11.47           N  
ATOM    357  CA  THR    51      26.469   6.683  33.402  1.00 11.31           C  
ATOM    358  CB  THR    51      26.713   5.219  33.308  1.00 13.10           C  
ATOM    359  OG1 THR    51      26.506   4.793  31.928  1.00 11.78           O  
ATOM    360  CG2 THR    51      25.855   4.445  34.369  1.00 12.02           C  
ATOM    361  C   THR    51      26.480   7.148  34.855  1.00 11.29           C  
ATOM    362  O   THR    51      25.432   7.331  35.465  1.00 12.45           O  
ATOM    363  N   ASP    52      27.654   7.429  35.382  1.00 11.03           N  
ATOM    364  CA  ASP    52      27.794   8.028  36.693  1.00 12.55           C  
ATOM    365  CB  ASP    52      29.302   8.302  37.004  1.00 14.43           C  
ATOM    366  CG  ASP    52      30.072   7.039  37.591  1.00 19.31           C  
ATOM    367  OD1 ASP    52      29.485   5.940  37.513  1.00 27.02           O  
ATOM    368  OD2 ASP    52      31.215   7.128  38.174  1.00 21.55           O  
ATOM    369  C   ASP    52      27.039   9.359  36.765  1.00 12.87           C  
ATOM    370  O   ASP    52      26.404   9.659  37.772  1.00 13.89           O  
ATOM    371  N   ARG    53      27.144  10.154  35.725  1.00 11.18           N  
ATOM    372  CA  ARG    53      26.554  11.466  35.716  1.00 12.54           C  
ATOM    373  CB  ARG    53      27.034  12.310  34.549  1.00 12.60           C  
ATOM    374  CG  ARG    53      26.504  13.716  34.582  1.00  7.78           C  
ATOM    375  CD  ARG    53      26.875  14.388  35.878  1.00 12.76           C  
ATOM    376  NE  ARG    53      26.392  15.761  35.832  1.00 16.78           N  
ATOM    377  CZ  ARG    53      25.997  16.516  36.869  1.00 21.58           C  
ATOM    378  NH1 ARG    53      25.979  16.073  38.109  1.00 19.67           N  
ATOM    379  NH2 ARG    53      25.599  17.759  36.645  1.00 22.77           N  
ATOM    380  C   ARG    53      25.069  11.439  35.639  1.00 13.23           C  
ATOM    381  O   ARG    53      24.429  12.339  36.159  1.00 14.35           O  
ATOM    382  N   ILE    54      24.519  10.433  34.977  1.00 14.38           N  
ATOM    383  CA  ILE    54      23.074  10.265  34.856  1.00 14.31           C  
ATOM    384  CB  ILE    54      22.821   9.224  33.760  1.00 13.66           C  
ATOM    385  CG1 ILE    54      23.237   9.784  32.407  1.00 11.73           C  
ATOM    386  CD1 ILE    54      23.364   8.749  31.309  1.00 16.69           C  
ATOM    387  CG2 ILE    54      21.396   8.788  33.723  1.00 13.08           C  
ATOM    388  C   ILE    54      22.477   9.825  36.218  1.00 16.60           C  
ATOM    389  O   ILE    54      21.343  10.159  36.642  1.00 15.70           O  
ATOM    390  N   ASP    55      23.287   9.057  36.913  1.00 19.23           N  
ATOM    391  CA  ASP    55      22.971   8.671  38.220  1.00 20.82           C  
ATOM    392  CB  ASP    55      24.020   7.729  38.706  1.00 22.62           C  
ATOM    393  CG  ASP    55      23.760   6.294  38.217  1.00 30.74           C  
ATOM    394  OD1 ASP    55      22.550   5.892  38.097  1.00 38.79           O  
ATOM    395  OD2 ASP    55      24.750   5.552  37.960  1.00 38.29           O  
ATOM    396  C   ASP    55      22.935   9.850  39.103  1.00 20.50           C  
ATOM    397  O   ASP    55      22.053   9.929  39.905  1.00 22.08           O  
ATOM    398  N   GLU    56      23.871  10.774  38.997  1.00 19.54           N  
ATOM    399  CA  GLU    56      23.833  11.857  39.918  1.00 19.49           C  
ATOM    400  CB  GLU    56      25.232  12.336  40.268  1.00 19.24           C  
ATOM    401  CG  GLU    56      26.047  12.911  39.175  1.00 22.89           C  
ATOM    402  CD  GLU    56      27.353  13.501  39.679  1.00 26.77           C  
ATOM    403  OE1 GLU    56      28.376  13.652  38.938  1.00 27.13           O  
ATOM    404  OE2 GLU    56      27.342  13.862  40.862  1.00 33.80           O  
ATOM    405  C   GLU    56      22.793  12.959  39.566  1.00 20.35           C  
ATOM    406  O   GLU    56      22.294  13.626  40.426  1.00 21.27           O  
ATOM    407  N   LEU    57      22.404  13.078  38.311  1.00 20.26           N  
ATOM    408  CA  LEU    57      21.223  13.808  37.956  1.00 20.88           C  
ATOM    409  CB  LEU    57      21.043  13.874  36.447  1.00 19.79           C  
ATOM    410  CG  LEU    57      22.077  14.767  35.888  1.00 18.91           C  
ATOM    411  CD1 LEU    57      22.169  14.565  34.395  1.00 19.95           C  
ATOM    412  CD2 LEU    57      21.690  16.131  36.278  1.00 20.37           C  
ATOM    413  C   LEU    57      19.951  13.210  38.436  1.00 22.31           C  
ATOM    414  O   LEU    57      19.012  13.937  38.705  1.00 21.27           O  
ATOM    415  N   GLU    58      19.853  11.891  38.437  1.00 24.47           N  
ATOM    416  CA  GLU    58      18.597  11.284  38.856  1.00 27.45           C  
ATOM    417  CB  GLU    58      18.550   9.793  38.546  1.00 27.98           C  
ATOM    418  CG  GLU    58      17.126   9.266  38.632  1.00 32.73           C  
ATOM    419  CD  GLU    58      17.039   7.888  39.235  1.00 39.29           C  
ATOM    420  OE1 GLU    58      17.705   6.990  38.662  1.00 43.68           O  
ATOM    421  OE2 GLU    58      16.308   7.696  40.264  1.00 41.02           O  
ATOM    422  C   GLU    58      18.445  11.496  40.342  1.00 28.37           C  
ATOM    423  O   GLU    58      17.355  11.787  40.820  1.00 28.80           O  
ATOM    424  N   LYS    59      19.561  11.318  41.046  1.00 29.98           N  
ATOM    425  CA  LYS    59      19.761  11.714  42.437  1.00 31.92           C  
ATOM    426  CB  LYS    59      21.215  11.434  42.854  1.00 32.83           C  
ATOM    427  CG  LYS    59      21.472  11.494  44.370  1.00 34.60           C  
ATOM    428  CD  LYS    59      22.905  11.967  44.742  1.00 34.73           C  
ATOM    429  CE  LYS    59      22.932  12.688  46.155  1.00 37.52           C  
ATOM    430  NZ  LYS    59      22.483  14.144  46.060  1.00 39.04           N  
ATOM    431  C   LYS    59      19.396  13.177  42.736  1.00 31.08           C  
ATOM    432  O   LYS    59      18.800  13.445  43.751  1.00 31.43           O  
ATOM    433  N   GLU    60      19.742  14.104  41.856  1.00 30.65           N  
ATOM    434  CA  GLU    60      19.404  15.530  42.002  1.00 30.83           C  
ATOM    435  CB  GLU    60      20.158  16.326  40.923  1.00 31.45           C  
ATOM    436  CG  GLU    60      20.852  17.680  41.276  1.00 33.28           C  
ATOM    437  CD  GLU    60      22.096  17.934  40.353  1.00 33.99           C  
ATOM    438  OE1 GLU    60      23.208  17.444  40.700  1.00 39.01           O  
ATOM    439  OE2 GLU    60      21.979  18.595  39.272  1.00 36.33           O  
ATOM    440  C   GLU    60      17.919  15.833  41.801  1.00 29.28           C  
ATOM    441  O   GLU    60      17.413  16.842  42.281  1.00 28.68           O  
ATOM    442  N   ASN    61      17.226  14.986  41.067  1.00 28.25           N  
ATOM    443  CA  ASN    61      15.863  15.292  40.701  1.00 28.16           C  
ATOM    444  CB  ASN    61      15.683  15.229  39.185  1.00 27.11           C  
ATOM    445  CG  ASN    61      16.277  16.453  38.487  1.00 26.22           C  
ATOM    446  OD1 ASN    61      15.596  17.461  38.363  1.00 25.01           O  
ATOM    447  ND2 ASN    61      17.553  16.376  38.038  1.00 20.95           N  
ATOM    448  C   ASN    61      14.881  14.413  41.411  1.00 28.78           C  
ATOM    449  O   ASN    61      13.741  14.277  40.983  1.00 28.18           O  
ATOM    450  N   THR    62      15.339  13.813  42.506  1.00 30.76           N  
ATOM    451  CA  THR    62      14.504  12.932  43.346  1.00 32.67           C  
ATOM    452  CB  THR    62      14.939  11.427  43.286  1.00 33.62           C  
ATOM    453  OG1 THR    62      16.366  11.329  43.294  1.00 36.59           O  
ATOM    454  CG2 THR    62      14.442  10.751  42.009  1.00 34.57           C  
ATOM    455  C   THR    62      14.382  13.402  44.797  1.00 32.26           C  
ATOM    456  O   THR    62      15.376  13.736  45.461  1.00 32.05           O  
ATOM    457  N   THR    63      13.142  13.411  45.271  1.00 32.61           N  
ATOM    458  CA  THR    63      12.764  14.129  46.513  1.00 32.78           C  
ATOM    459  CB  THR    63      12.224  15.562  46.193  1.00 32.81           C  
ATOM    460  OG1 THR    63      10.915  15.466  45.620  1.00 33.11           O  
ATOM    461  CG2 THR    63      13.164  16.319  45.196  1.00 32.27           C  
ATOM    462  C   THR    63      11.738  13.365  47.342  1.00 32.32           C  
ATOM    463  O   THR    63      11.068  12.473  46.826  1.00 32.12           O  
ATOM    464  N   LYS    74      11.319   8.612  46.903  1.00 37.42           N  
ATOM    465  CA  LYS    74      10.152   8.090  46.185  1.00 36.53           C  
ATOM    466  CB  LYS    74       9.010   7.662  47.174  1.00 36.19           C  
ATOM    467  CG  LYS    74       8.084   8.786  47.704  1.00 33.82           C  
ATOM    468  CD  LYS    74       8.119   8.904  49.245  1.00 31.41           C  
ATOM    469  CE  LYS    74       7.051   8.058  49.986  1.00 26.31           C  
ATOM    470  NZ  LYS    74       7.482   6.670  50.235  1.00 23.93           N  
ATOM    471  C   LYS    74       9.632   9.030  45.058  1.00 36.33           C  
ATOM    472  O   LYS    74       8.726   8.641  44.314  1.00 36.59           O  
ATOM    473  N   GLU    75      10.190  10.239  44.915  1.00 35.58           N  
ATOM    474  CA  GLU    75       9.659  11.189  43.906  1.00 35.18           C  
ATOM    475  CB  GLU    75       8.762  12.218  44.585  1.00 35.76           C  
ATOM    476  CG  GLU    75       7.851  12.973  43.613  1.00 38.40           C  
ATOM    477  CD  GLU    75       6.904  12.038  42.873  1.00 40.91           C  
ATOM    478  OE1 GLU    75       6.086  11.341  43.516  1.00 40.97           O  
ATOM    479  OE2 GLU    75       6.978  12.006  41.637  1.00 41.99           O  
ATOM    480  C   GLU    75      10.640  11.889  42.919  1.00 34.29           C  
ATOM    481  O   GLU    75      11.349  12.846  43.270  1.00 33.48           O  
ATOM    482  N   LEU    76      10.616  11.433  41.667  1.00 33.59           N  
ATOM    483  CA  LEU    76      11.447  11.975  40.573  1.00 32.82           C  
ATOM    484  CB  LEU    76      12.040  10.816  39.749  1.00 32.65           C  
ATOM    485  CG  LEU    76      12.845  11.067  38.451  1.00 32.53           C  
ATOM    486  CD1 LEU    76      14.275  11.543  38.719  1.00 28.46           C  
ATOM    487  CD2 LEU    76      12.854   9.822  37.564  1.00 32.27           C  
ATOM    488  C   LEU    76      10.706  12.948  39.634  1.00 33.01           C  
ATOM    489  O   LEU    76       9.575  12.678  39.211  1.00 33.18           O  
ATOM    490  N   ASP    77      11.353  14.067  39.299  1.00 32.53           N  
ATOM    491  CA  ASP    77      10.834  15.006  38.310  1.00 32.48           C  
ATOM    492  CB  ASP    77      11.226  16.449  38.676  1.00 32.94           C  
ATOM    493  CG  ASP    77      10.532  17.513  37.791  1.00 35.11           C  
ATOM    494  OD1 ASP    77      10.001  17.201  36.698  1.00 36.56           O  
ATOM    495  OD2 ASP    77      10.534  18.700  38.175  1.00 37.85           O  
ATOM    496  C   ASP    77      11.415  14.641  36.964  1.00 32.39           C  
ATOM    497  O   ASP    77      12.437  15.202  36.554  1.00 31.80           O  
ATOM    498  N   SER    78      10.759  13.706  36.280  1.00 32.31           N  
ATOM    499  CA  SER    78      11.246  13.190  34.991  1.00 32.25           C  
ATOM    500  CB  SER    78      10.196  12.316  34.306  1.00 32.46           C  
ATOM    501  OG  SER    78       9.976  11.136  35.020  1.00 33.62           O  
ATOM    502  C   SER    78      11.556  14.300  34.040  1.00 31.58           C  
ATOM    503  O   SER    78      12.667  14.390  33.523  1.00 32.23           O  
ATOM    504  N   GLN    79      10.541  15.119  33.801  1.00 30.92           N  
ATOM    505  CA  GLN    79      10.585  16.227  32.860  1.00 31.08           C  
ATOM    506  CB  GLN    79       9.472  17.242  33.225  1.00 32.51           C  
ATOM    507  CG  GLN    79       8.882  18.026  32.049  1.00 37.21           C  
ATOM    508  CD  GLN    79       7.928  17.155  31.243  1.00 41.23           C  
ATOM    509  OE1 GLN    79       8.331  16.099  30.678  1.00 41.13           O  
ATOM    510  NE2 GLN    79       6.654  17.576  31.195  1.00 40.07           N  
ATOM    511  C   GLN    79      11.924  16.911  32.980  1.00 28.93           C  
ATOM    512  O   GLN    79      12.715  16.964  32.037  1.00 28.03           O  
ATOM    513  N   ARG    80      12.142  17.379  34.199  1.00 27.01           N  
ATOM    514  CA  ARG    80      13.266  18.147  34.593  1.00 25.70           C  
ATOM    515  CB  ARG    80      13.042  18.444  36.042  1.00 26.46           C  
ATOM    516  CG  ARG    80      14.013  19.352  36.663  1.00 30.51           C  
ATOM    517  CD  ARG    80      13.706  20.742  36.297  1.00 38.40           C  
ATOM    518  NE  ARG    80      14.934  21.501  36.448  1.00 42.71           N  
ATOM    519  CZ  ARG    80      15.094  22.747  36.037  1.00 42.09           C  
ATOM    520  NH1 ARG    80      14.082  23.387  35.447  1.00 39.34           N  
ATOM    521  NH2 ARG    80      16.285  23.323  36.205  1.00 43.29           N  
ATOM    522  C   ARG    80      14.578  17.391  34.419  1.00 23.77           C  
ATOM    523  O   ARG    80      15.557  17.952  33.965  1.00 22.48           O  
ATOM    524  N   PHE    81      14.562  16.121  34.810  1.00 22.62           N  
ATOM    525  CA  PHE    81      15.674  15.177  34.754  1.00 21.65           C  
ATOM    526  CB  PHE    81      15.186  13.890  35.376  1.00 20.76           C  
ATOM    527  CG  PHE    81      16.046  12.718  35.155  1.00 20.61           C  
ATOM    528  CD1 PHE    81      17.400  12.736  35.488  1.00 19.36           C  
ATOM    529  CE1 PHE    81      18.207  11.589  35.309  1.00 20.60           C  
ATOM    530  CZ  PHE    81      17.636  10.416  34.832  1.00 20.54           C  
ATOM    531  CE2 PHE    81      16.235  10.388  34.534  1.00 20.20           C  
ATOM    532  CD2 PHE    81      15.471  11.521  34.698  1.00 20.38           C  
ATOM    533  C   PHE    81      16.124  14.915  33.338  1.00 22.06           C  
ATOM    534  O   PHE    81      17.323  14.919  33.077  1.00 22.40           O  
ATOM    535  N   TYR    82      15.179  14.704  32.420  1.00 22.60           N  
ATOM    536  CA  TYR    82      15.504  14.474  31.012  1.00 23.05           C  
ATOM    537  CB  TYR    82      14.260  13.970  30.275  1.00 25.87           C  
ATOM    538  CG  TYR    82      13.846  12.610  30.765  1.00 28.95           C  
ATOM    539  CD1 TYR    82      14.789  11.657  31.090  1.00 30.67           C  
ATOM    540  CE1 TYR    82      14.425  10.389  31.553  1.00 31.68           C  
ATOM    541  CZ  TYR    82      13.074  10.072  31.713  1.00 34.49           C  
ATOM    542  OH  TYR    82      12.679   8.818  32.175  1.00 33.95           O  
ATOM    543  CE2 TYR    82      12.090  11.008  31.394  1.00 35.76           C  
ATOM    544  CD2 TYR    82      12.498  12.284  30.910  1.00 35.17           C  
ATOM    545  C   TYR    82      16.085  15.715  30.365  1.00 21.43           C  
ATOM    546  O   TYR    82      17.107  15.703  29.686  1.00 21.08           O  
ATOM    547  N   ALA    83      15.441  16.831  30.613  1.00 21.02           N  
ATOM    548  CA  ALA    83      15.958  18.117  30.162  1.00 20.02           C  
ATOM    549  CB  ALA    83      15.016  19.328  30.671  1.00 20.01           C  
ATOM    550  C   ALA    83      17.405  18.313  30.598  1.00 19.29           C  
ATOM    551  O   ALA    83      18.208  18.791  29.818  1.00 20.55           O  
ATOM    552  N   ARG    84      17.745  17.965  31.843  1.00 18.86           N  
ATOM    553  CA  ARG    84      19.065  18.240  32.395  1.00 18.13           C  
ATOM    554  CB  ARG    84      19.093  17.972  33.866  1.00 18.11           C  
ATOM    555  CG  ARG    84      17.917  18.552  34.588  1.00 22.10           C  
ATOM    556  CD  ARG    84      18.145  19.825  35.369  1.00 24.88           C  
ATOM    557  NE  ARG    84      19.550  20.050  35.601  1.00 30.12           N  
ATOM    558  CZ  ARG    84      20.191  19.778  36.714  1.00 32.36           C  
ATOM    559  NH1 ARG    84      19.530  19.249  37.759  1.00 32.45           N  
ATOM    560  NH2 ARG    84      21.509  20.040  36.755  1.00 34.28           N  
ATOM    561  C   ARG    84      20.059  17.357  31.728  1.00 17.71           C  
ATOM    562  O   ARG    84      21.138  17.790  31.448  1.00 19.18           O  
ATOM    563  N   ILE    85      19.691  16.117  31.451  1.00 16.84           N  
ATOM    564  CA  ILE    85      20.486  15.227  30.614  1.00 15.98           C  
ATOM    565  CB  ILE    85      19.819  13.795  30.430  1.00 15.46           C  
ATOM    566  CG1 ILE    85      19.684  13.029  31.765  1.00 15.19           C  
ATOM    567  CD1 ILE    85      18.822  11.659  31.682  1.00 17.17           C  
ATOM    568  CG2 ILE    85      20.605  12.946  29.425  1.00 15.25           C  
ATOM    569  C   ILE    85      20.758  15.814  29.246  1.00 16.66           C  
ATOM    570  O   ILE    85      21.910  15.714  28.753  1.00 15.24           O  
ATOM    571  N   ALA    86      19.684  16.364  28.618  1.00 16.05           N  
ATOM    572  CA  ALA    86      19.765  16.965  27.273  1.00 15.77           C  
ATOM    573  CB  ALA    86      18.392  17.342  26.829  1.00 15.34           C  
ATOM    574  C   ALA    86      20.736  18.193  27.266  1.00 15.80           C  
ATOM    575  O   ALA    86      21.575  18.371  26.373  1.00 15.99           O  
ATOM    576  N   VAL    87      20.616  19.031  28.281  1.00 14.85           N  
ATOM    577  CA  VAL    87      21.425  20.178  28.389  1.00 14.50           C  
ATOM    578  CB  VAL    87      20.934  20.969  29.639  1.00 14.01           C  
ATOM    579  CG1 VAL    87      21.980  22.001  30.162  1.00 12.70           C  
ATOM    580  CG2 VAL    87      19.664  21.689  29.271  1.00 12.19           C  
ATOM    581  C   VAL    87      22.871  19.688  28.380  1.00 16.46           C  
ATOM    582  O   VAL    87      23.624  20.072  27.537  1.00 17.67           O  
ATOM    583  N   GLU    88      23.208  18.722  29.235  1.00 17.32           N  
ATOM    584  CA  GLU    88      24.580  18.225  29.418  1.00 17.61           C  
ATOM    585  CB  GLU    88      24.629  17.598  30.822  1.00 16.62           C  
ATOM    586  CG  GLU    88      24.829  18.630  31.957  1.00 21.54           C  
ATOM    587  CD  GLU    88      24.663  18.089  33.413  1.00 24.56           C  
ATOM    588  OE1 GLU    88      25.102  16.923  33.658  1.00 33.12           O  
ATOM    589  OE2 GLU    88      24.140  18.839  34.353  1.00 27.44           O  
ATOM    590  C   GLU    88      25.073  17.268  28.231  1.00 16.44           C  
ATOM    591  O   GLU    88      26.262  17.186  27.880  1.00 12.07           O  
ATOM    592  N   THR    89      24.149  16.619  27.545  1.00 15.07           N  
ATOM    593  CA  THR    89      24.499  15.958  26.263  1.00 15.29           C  
ATOM    594  CB  THR    89      23.333  15.068  25.935  1.00 15.03           C  
ATOM    595  OG1 THR    89      23.106  14.290  27.112  1.00 14.26           O  
ATOM    596  CG2 THR    89      23.429  14.211  24.681  1.00  9.85           C  
ATOM    597  C   THR    89      24.745  16.968  25.133  1.00 17.04           C  
ATOM    598  O   THR    89      25.364  16.663  24.154  1.00 16.92           O  
ATOM    599  N   THR    90      24.271  18.197  25.281  1.00 19.54           N  
ATOM    600  CA  THR    90      24.367  19.178  24.188  1.00 19.61           C  
ATOM    601  CB  THR    90      23.059  19.992  23.956  1.00 20.32           C  
ATOM    602  OG1 THR    90      21.956  19.068  23.762  1.00 21.12           O  
ATOM    603  CG2 THR    90      23.129  20.885  22.693  1.00 17.16           C  
ATOM    604  C   THR    90      25.664  19.969  24.358  1.00 19.62           C  
ATOM    605  O   THR    90      25.778  20.873  25.215  1.00 20.43           O  
ATOM    606  N   VAL    91      26.638  19.616  23.514  1.00 18.48           N  
ATOM    607  CA  VAL    91      27.956  20.284  23.521  1.00 18.81           C  
ATOM    608  CB  VAL    91      28.987  19.557  22.567  1.00 19.72           C  
ATOM    609  CG1 VAL    91      30.346  20.051  22.846  1.00 19.45           C  
ATOM    610  CG2 VAL    91      28.966  18.123  22.745  1.00 19.46           C  
ATOM    611  C   VAL    91      27.880  21.695  22.968  1.00 18.01           C  
ATOM    612  O   VAL    91      28.627  22.606  23.392  1.00 18.62           O  
ATOM    613  N   TYR    92      27.096  21.815  21.901  1.00 17.56           N  
ATOM    614  CA  TYR    92      26.975  23.058  21.165  1.00 16.59           C  
ATOM    615  CB  TYR    92      27.926  23.062  20.032  1.00 14.55           C  
ATOM    616  CG  TYR    92      27.800  24.286  19.121  1.00 16.38           C  
ATOM    617  CD1 TYR    92      28.114  25.548  19.620  1.00 15.65           C  
ATOM    618  CE1 TYR    92      28.031  26.708  18.811  1.00 18.60           C  
ATOM    619  CZ  TYR    92      27.647  26.599  17.494  1.00 18.37           C  
ATOM    620  OH  TYR    92      27.639  27.766  16.803  1.00 17.93           O  
ATOM    621  CE2 TYR    92      27.239  25.332  16.963  1.00 19.18           C  
ATOM    622  CD2 TYR    92      27.321  24.191  17.778  1.00 13.34           C  
ATOM    623  C   TYR    92      25.592  23.144  20.599  1.00 15.93           C  
ATOM    624  O   TYR    92      25.267  22.347  19.755  1.00 15.58           O  
ATOM    625  N   PRO    93      24.764  24.096  21.067  1.00 17.21           N  
ATOM    626  CA  PRO    93      24.973  25.187  22.027  1.00 18.35           C  
ATOM    627  CB  PRO    93      23.739  26.087  21.770  1.00 16.15           C  
ATOM    628  CG  PRO    93      22.750  25.233  21.411  1.00 18.69           C  
ATOM    629  CD  PRO    93      23.370  24.125  20.572  1.00 17.17           C  
ATOM    630  C   PRO    93      24.956  24.638  23.459  1.00 18.34           C  
ATOM    631  O   PRO    93      24.095  23.797  23.709  1.00 19.20           O  
ATOM    632  N   THR    94      25.907  25.017  24.338  1.00 17.97           N  
ATOM    633  CA  THR    94      25.741  24.685  25.739  1.00 18.77           C  
ATOM    634  CB  THR    94      26.911  24.958  26.644  1.00 19.57           C  
ATOM    635  OG1 THR    94      28.055  24.414  26.061  1.00 30.93           O  
ATOM    636  CG2 THR    94      26.748  24.246  28.082  1.00 18.54           C  
ATOM    637  C   THR    94      24.872  25.781  26.259  1.00 17.08           C  
ATOM    638  O   THR    94      25.356  26.933  26.354  1.00 15.50           O  
ATOM    639  N   PHE    95      23.684  25.367  26.709  1.00 13.94           N  
ATOM    640  CA  PHE    95      22.720  26.234  27.390  1.00 13.94           C  
ATOM    641  CB  PHE    95      21.434  25.519  27.470  1.00 10.07           C  
ATOM    642  CG  PHE    95      20.861  25.281  26.174  1.00 10.86           C  
ATOM    643  CD1 PHE    95      20.812  26.315  25.204  1.00 10.65           C  
ATOM    644  CE1 PHE    95      20.206  26.099  23.929  1.00 13.83           C  
ATOM    645  CZ  PHE    95      19.670  24.782  23.602  1.00 13.30           C  
ATOM    646  CE2 PHE    95      19.782  23.777  24.520  1.00 14.98           C  
ATOM    647  CD2 PHE    95      20.394  24.029  25.825  1.00 13.69           C  
ATOM    648  C   PHE    95      23.134  26.721  28.760  1.00 13.50           C  
ATOM    649  O   PHE    95      22.522  27.645  29.302  1.00 14.82           O  
ATOM    650  N   LYS    96      24.252  26.209  29.267  1.00 14.30           N  
ATOM    651  CA  LYS    96      24.787  26.724  30.505  1.00 13.87           C  
ATOM    652  CB  LYS    96      25.631  25.685  31.168  1.00 13.85           C  
ATOM    653  CG  LYS    96      24.882  24.489  31.510  1.00 16.80           C  
ATOM    654  CD  LYS    96      25.766  23.655  32.396  1.00 20.99           C  
ATOM    655  CE  LYS    96      24.983  22.448  32.681  1.00 26.00           C  
ATOM    656  NZ  LYS    96      25.546  21.790  33.869  1.00 31.16           N  
ATOM    657  C   LYS    96      25.620  27.907  30.259  1.00 14.53           C  
ATOM    658  O   LYS    96      26.070  28.554  31.190  1.00 14.15           O  
ATOM    659  N   ALA    97      25.833  28.208  28.991  1.00 15.05           N  
ATOM    660  CA  ALA    97      26.764  29.230  28.608  1.00 14.58           C  
ATOM    661  CB  ALA    97      26.938  29.240  27.092  1.00 15.32           C  
ATOM    662  C   ALA    97      26.289  30.586  29.114  1.00 15.45           C  
ATOM    663  O   ALA    97      25.145  31.031  28.898  1.00 12.20           O  
ATOM    664  N   LYS    98      27.201  31.281  29.770  1.00 16.58           N  
ATOM    665  CA  LYS    98      26.907  32.603  30.258  1.00 17.66           C  
ATOM    666  CB  LYS    98      28.137  33.298  30.847  1.00 18.84           C  
ATOM    667  CG  LYS    98      27.783  34.579  31.612  1.00 20.38           C  
ATOM    668  CD  LYS    98      26.602  34.313  32.641  1.00 25.48           C  
ATOM    669  CE  LYS    98      26.522  35.316  33.835  1.00 26.15           C  
ATOM    670  NZ  LYS    98      27.555  35.040  34.864  1.00 27.46           N  
ATOM    671  C   LYS    98      26.235  33.524  29.233  1.00 18.86           C  
ATOM    672  O   LYS    98      25.284  34.231  29.589  1.00 18.04           O  
ATOM    673  N   GLU    99      26.729  33.546  27.998  1.00 18.87           N  
ATOM    674  CA  GLU    99      26.246  34.500  27.014  1.00 22.52           C  
ATOM    675  CB  GLU    99      27.095  34.335  25.775  1.00 22.40           C  
ATOM    676  CG  GLU    99      27.145  35.580  24.818  1.00 30.66           C  
ATOM    677  CD  GLU    99      27.966  35.274  23.465  1.00 31.73           C  
ATOM    678  OE1 GLU    99      28.905  34.383  23.507  1.00 35.39           O  
ATOM    679  OE2 GLU    99      27.613  35.880  22.379  1.00 38.64           O  
ATOM    680  C   GLU    99      24.772  34.230  26.662  1.00 20.40           C  
ATOM    681  O   GLU    99      24.047  35.139  26.263  1.00 20.54           O  
ATOM    682  N   LEU   100      24.351  32.969  26.759  1.00 18.76           N  
ATOM    683  CA  LEU   100      22.956  32.571  26.461  1.00 18.78           C  
ATOM    684  CB  LEU   100      22.870  31.071  26.089  1.00 17.50           C  
ATOM    685  CG  LEU   100      23.339  30.554  24.717  1.00 17.80           C  
ATOM    686  CD1 LEU   100      23.200  29.053  24.515  1.00 14.79           C  
ATOM    687  CD2 LEU   100      22.644  31.317  23.541  1.00 14.11           C  
ATOM    688  C   LEU   100      22.093  32.846  27.674  1.00 19.30           C  
ATOM    689  O   LEU   100      20.909  33.219  27.555  1.00 20.76           O  
ATOM    690  N   ARG   101      22.666  32.605  28.846  1.00 18.77           N  
ATOM    691  CA  ARG   101      21.999  32.879  30.089  1.00 19.74           C  
ATOM    692  CB  ARG   101      22.821  32.375  31.282  1.00 18.50           C  
ATOM    693  CG  ARG   101      22.515  30.935  31.584  1.00 19.94           C  
ATOM    694  CD  ARG   101      23.192  30.478  32.879  1.00 22.23           C  
ATOM    695  NE  ARG   101      24.565  30.112  32.673  1.00 16.11           N  
ATOM    696  CZ  ARG   101      25.593  30.694  33.261  1.00 17.66           C  
ATOM    697  NH1 ARG   101      25.429  31.692  34.111  1.00 17.42           N  
ATOM    698  NH2 ARG   101      26.805  30.273  32.984  1.00 14.05           N  
ATOM    699  C   ARG   101      21.667  34.354  30.141  1.00 19.76           C  
ATOM    700  O   ARG   101      20.492  34.677  30.302  1.00 19.71           O  
ATOM    701  N   GLU   102      22.671  35.218  29.939  1.00 19.83           N  
ATOM    702  CA  GLU   102      22.483  36.675  29.867  1.00 22.91           C  
ATOM    703  CB  GLU   102      23.818  37.482  29.690  1.00 23.94           C  
ATOM    704  CG  GLU   102      24.910  37.244  30.767  1.00 29.27           C  
ATOM    705  CD  GLU   102      25.233  38.447  31.686  1.00 36.61           C  
ATOM    706  OE1 GLU   102      25.157  39.610  31.232  1.00 39.33           O  
ATOM    707  OE2 GLU   102      25.617  38.228  32.872  1.00 39.86           O  
ATOM    708  C   GLU   102      21.481  37.117  28.797  1.00 22.86           C  
ATOM    709  O   GLU   102      20.624  37.947  29.104  1.00 24.92           O  
ATOM    710  N   ALA   103      21.581  36.584  27.568  1.00 22.16           N  
ATOM    711  CA  ALA   103      20.672  36.995  26.446  1.00 20.87           C  
ATOM    712  CB  ALA   103      21.159  36.494  25.149  1.00 19.77           C  
ATOM    713  C   ALA   103      19.256  36.581  26.566  1.00 20.67           C  
ATOM    714  O   ALA   103      18.342  37.288  26.077  1.00 20.43           O  
ATOM    715  N   TYR   104      19.053  35.382  27.096  1.00 20.97           N  
ATOM    716  CA  TYR   104      17.719  34.868  27.275  1.00 20.47           C  
ATOM    717  CB  TYR   104      17.660  33.381  27.027  1.00 19.90           C  
ATOM    718  CG  TYR   104      17.652  33.208  25.534  1.00 21.25           C  
ATOM    719  CD1 TYR   104      16.455  33.360  24.806  1.00 15.71           C  
ATOM    720  CE1 TYR   104      16.422  33.242  23.497  1.00 18.68           C  
ATOM    721  CZ  TYR   104      17.593  33.008  22.795  1.00 20.05           C  
ATOM    722  OH  TYR   104      17.538  32.892  21.397  1.00 19.95           O  
ATOM    723  CE2 TYR   104      18.828  32.946  23.461  1.00 21.95           C  
ATOM    724  CD2 TYR   104      18.844  33.060  24.834  1.00 20.82           C  
ATOM    725  C   TYR   104      17.153  35.261  28.596  1.00 21.13           C  
ATOM    726  O   TYR   104      15.944  35.098  28.827  1.00 21.96           O  
ATOM    727  N   LYS   105      18.009  35.873  29.410  1.00 21.62           N  
ATOM    728  CA  LYS   105      17.630  36.387  30.716  1.00 22.93           C  
ATOM    729  CB  LYS   105      16.617  37.532  30.591  1.00 23.91           C  
ATOM    730  CG  LYS   105      17.273  38.921  30.447  1.00 27.24           C  
ATOM    731  CD  LYS   105      17.195  39.533  29.029  1.00 30.95           C  
ATOM    732  CE  LYS   105      18.261  40.704  28.892  1.00 34.64           C  
ATOM    733  NZ  LYS   105      19.113  40.640  27.616  1.00 37.74           N  
ATOM    734  C   LYS   105      17.162  35.290  31.711  1.00 22.05           C  
ATOM    735  O   LYS   105      16.191  35.436  32.430  1.00 21.46           O  
ATOM    736  N   THR   106      17.864  34.173  31.748  1.00 21.64           N  
ATOM    737  CA  THR   106      17.491  33.186  32.728  1.00 20.92           C  
ATOM    738  CB  THR   106      16.259  32.265  32.262  1.00 20.46           C  
ATOM    739  OG1 THR   106      15.976  31.226  33.229  1.00 22.59           O  
ATOM    740  CG2 THR   106      16.487  31.670  30.914  1.00 22.45           C  
ATOM    741  C   THR   106      18.767  32.487  33.143  1.00 19.43           C  
ATOM    742  O   THR   106      19.568  32.128  32.286  1.00 19.04           O  
ATOM    743  N   GLU   107      18.967  32.363  34.455  1.00 17.95           N  
ATOM    744  CA  GLU   107      20.007  31.510  34.937  1.00 18.97           C  
ATOM    745  CB  GLU   107      20.415  31.932  36.338  1.00 18.37           C  
ATOM    746  CG  GLU   107      21.141  33.242  36.407  1.00 23.02           C  
ATOM    747  CD  GLU   107      22.411  33.339  35.569  1.00 26.50           C  
ATOM    748  OE1 GLU   107      23.304  32.496  35.789  1.00 31.41           O  
ATOM    749  OE2 GLU   107      22.518  34.272  34.712  1.00 25.88           O  
ATOM    750  C   GLU   107      19.710  29.974  34.852  1.00 18.34           C  
ATOM    751  O   GLU   107      20.574  29.177  35.139  1.00 19.20           O  
ATOM    752  N   ASP   108      18.508  29.573  34.439  1.00 18.56           N  
ATOM    753  CA  ASP   108      18.150  28.171  34.281  1.00 19.20           C  
ATOM    754  CB  ASP   108      16.678  27.998  34.487  1.00 19.68           C  
ATOM    755  CG  ASP   108      16.269  26.536  34.662  1.00 23.28           C  
ATOM    756  OD1 ASP   108      17.152  25.626  34.525  1.00 24.31           O  
ATOM    757  OD2 ASP   108      15.028  26.314  34.935  1.00 25.02           O  
ATOM    758  C   ASP   108      18.426  27.670  32.880  1.00 19.38           C  
ATOM    759  O   ASP   108      17.761  28.075  31.955  1.00 20.67           O  
ATOM    760  N   PRO   109      19.404  26.766  32.721  1.00 18.70           N  
ATOM    761  CA  PRO   109      19.829  26.330  31.437  1.00 17.64           C  
ATOM    762  CB  PRO   109      20.954  25.379  31.771  1.00 18.20           C  
ATOM    763  CG  PRO   109      21.416  25.852  33.127  1.00 17.19           C  
ATOM    764  CD  PRO   109      20.184  26.144  33.799  1.00 18.29           C  
ATOM    765  C   PRO   109      18.716  25.599  30.706  1.00 18.72           C  
ATOM    766  O   PRO   109      18.639  25.641  29.462  1.00 19.42           O  
ATOM    767  N   VAL   110      17.831  24.963  31.441  1.00 17.84           N  
ATOM    768  CA  VAL   110      16.708  24.297  30.828  1.00 18.02           C  
ATOM    769  CB  VAL   110      16.053  23.419  31.860  1.00 17.83           C  
ATOM    770  CG1 VAL   110      14.598  23.029  31.451  1.00 17.31           C  
ATOM    771  CG2 VAL   110      16.969  22.236  32.173  1.00 17.10           C  
ATOM    772  C   VAL   110      15.656  25.308  30.322  1.00 18.23           C  
ATOM    773  O   VAL   110      14.988  25.046  29.365  1.00 19.68           O  
ATOM    774  N   GLU   111      15.518  26.443  30.968  1.00 17.58           N  
ATOM    775  CA  GLU   111      14.668  27.494  30.448  1.00 19.64           C  
ATOM    776  CB  GLU   111      14.290  28.520  31.546  1.00 19.89           C  
ATOM    777  CG  GLU   111      13.332  29.633  31.091  1.00 22.87           C  
ATOM    778  CD  GLU   111      11.894  29.165  30.963  1.00 32.09           C  
ATOM    779  OE1 GLU   111      11.608  28.007  31.377  1.00 33.07           O  
ATOM    780  OE2 GLU   111      11.027  29.954  30.468  1.00 36.91           O  
ATOM    781  C   GLU   111      15.389  28.165  29.276  1.00 19.09           C  
ATOM    782  O   GLU   111      14.775  28.493  28.279  1.00 20.67           O  
ATOM    783  N   VAL   112      16.702  28.331  29.346  1.00 20.18           N  
ATOM    784  CA  VAL   112      17.425  28.747  28.136  1.00 18.33           C  
ATOM    785  CB  VAL   112      18.932  28.712  28.290  1.00 19.12           C  
ATOM    786  CG1 VAL   112      19.558  29.416  27.112  1.00 20.86           C  
ATOM    787  CG2 VAL   112      19.381  29.344  29.525  1.00 17.22           C  
ATOM    788  C   VAL   112      17.087  27.804  26.981  1.00 17.59           C  
ATOM    789  O   VAL   112      16.879  28.247  25.891  1.00 18.55           O  
ATOM    790  N   ALA   113      17.088  26.503  27.190  1.00 15.88           N  
ATOM    791  CA  ALA   113      16.682  25.583  26.119  1.00 15.33           C  
ATOM    792  CB  ALA   113      16.696  24.102  26.628  1.00 14.31           C  
ATOM    793  C   ALA   113      15.303  25.958  25.531  1.00 14.88           C  
ATOM    794  O   ALA   113      15.181  26.130  24.350  1.00 15.68           O  
ATOM    795  N   LYS   114      14.284  26.113  26.365  1.00 15.49           N  
ATOM    796  CA  LYS   114      12.922  26.379  25.894  1.00 15.81           C  
ATOM    797  CB  LYS   114      11.977  26.418  27.033  1.00 14.89           C  
ATOM    798  CG  LYS   114      11.769  25.047  27.610  1.00 15.66           C  
ATOM    799  CD  LYS   114      11.092  25.255  28.888  1.00 19.06           C  
ATOM    800  CE  LYS   114      11.239  24.085  29.808  1.00 27.60           C  
ATOM    801  NZ  LYS   114      10.194  23.110  29.414  1.00 31.05           N  
ATOM    802  C   LYS   114      12.868  27.693  25.174  1.00 15.99           C  
ATOM    803  O   LYS   114      12.114  27.825  24.264  1.00 15.70           O  
ATOM    804  N   ARG   115      13.722  28.641  25.520  1.00 14.94           N  
ATOM    805  CA  ARG   115      13.610  29.916  24.844  1.00 15.18           C  
ATOM    806  CB  ARG   115      14.048  31.059  25.756  1.00 15.14           C  
ATOM    807  CG  ARG   115      13.301  30.970  27.047  1.00 14.34           C  
ATOM    808  CD  ARG   115      13.597  32.177  27.954  1.00 11.12           C  
ATOM    809  NE  ARG   115      12.713  32.171  29.150  1.00 17.67           N  
ATOM    810  CZ  ARG   115      12.737  33.069  30.153  1.00 14.23           C  
ATOM    811  NH1 ARG   115      13.615  34.046  30.104  1.00 11.07           N  
ATOM    812  NH2 ARG   115      11.866  33.016  31.177  1.00 11.91           N  
ATOM    813  C   ARG   115      14.387  29.848  23.537  1.00 16.52           C  
ATOM    814  O   ARG   115      13.929  30.381  22.568  1.00 18.06           O  
ATOM    815  N   VAL   116      15.528  29.155  23.473  1.00 17.00           N  
ATOM    816  CA  VAL   116      16.218  28.965  22.184  1.00 16.71           C  
ATOM    817  CB  VAL   116      17.631  28.418  22.377  1.00 17.42           C  
ATOM    818  CG1 VAL   116      18.396  28.290  21.037  1.00 16.73           C  
ATOM    819  CG2 VAL   116      18.432  29.310  23.353  1.00 18.31           C  
ATOM    820  C   VAL   116      15.424  28.122  21.162  1.00 17.18           C  
ATOM    821  O   VAL   116      15.290  28.493  20.014  1.00 18.29           O  
ATOM    822  N   LEU   117      14.870  27.006  21.616  1.00 16.52           N  
ATOM    823  CA  LEU   117      14.097  26.103  20.812  1.00 13.53           C  
ATOM    824  CB  LEU   117      14.410  24.676  21.274  1.00 14.08           C  
ATOM    825  CG  LEU   117      15.884  24.200  21.182  1.00  9.14           C  
ATOM    826  CD1 LEU   117      16.161  22.922  21.816  1.00 13.23           C  
ATOM    827  CD2 LEU   117      16.182  23.943  19.787  1.00 16.66           C  
ATOM    828  C   LEU   117      12.600  26.405  20.992  1.00 15.03           C  
ATOM    829  O   LEU   117      11.802  25.609  21.585  1.00 12.93           O  
ATOM    830  N   SER   118      12.227  27.585  20.477  1.00 16.24           N  
ATOM    831  CA  SER   118      10.937  28.164  20.830  1.00 17.43           C  
ATOM    832  CB  SER   118      10.964  29.665  20.704  1.00 18.75           C  
ATOM    833  OG  SER   118      11.532  30.081  19.468  1.00 22.89           O  
ATOM    834  C   SER   118       9.837  27.657  20.022  1.00 16.27           C  
ATOM    835  O   SER   118       8.774  28.161  20.160  1.00 19.93           O  
ATOM    836  N   VAL   119      10.088  26.641  19.199  1.00 16.27           N  
ATOM    837  CA  VAL   119       9.084  25.896  18.460  1.00 13.82           C  
ATOM    838  CB  VAL   119       9.365  25.849  16.946  1.00 14.78           C  
ATOM    839  CG1 VAL   119       8.351  24.907  16.193  1.00  8.31           C  
ATOM    840  CG2 VAL   119       9.361  27.300  16.359  1.00  9.89           C  
ATOM    841  C   VAL   119       8.942  24.519  19.088  1.00 15.59           C  
ATOM    842  O   VAL   119       9.915  23.853  19.310  1.00 15.06           O  
ATOM    843  N   GLY   120       7.679  24.167  19.408  1.00 15.45           N  
ATOM    844  CA  GLY   120       7.387  23.160  20.340  1.00 16.69           C  
ATOM    845  C   GLY   120       8.176  21.948  19.905  1.00 18.23           C  
ATOM    846  O   GLY   120       8.964  21.418  20.708  1.00 20.27           O  
ATOM    847  N   GLY   121       7.956  21.514  18.642  1.00 17.18           N  
ATOM    848  CA  GLY   121       8.465  20.259  18.062  1.00 14.00           C  
ATOM    849  C   GLY   121       9.957  20.166  18.011  1.00 14.68           C  
ATOM    850  O   GLY   121      10.486  19.049  18.092  1.00 15.91           O  
ATOM    851  N   GLU   122      10.631  21.300  17.867  1.00 12.64           N  
ATOM    852  CA  GLU   122      12.102  21.387  18.043  1.00 15.75           C  
ATOM    853  CB  GLU   122      12.629  22.812  17.811  1.00 11.87           C  
ATOM    854  CG  GLU   122      12.345  23.334  16.464  1.00 14.03           C  
ATOM    855  CD  GLU   122      12.839  24.794  16.282  1.00 20.32           C  
ATOM    856  OE1 GLU   122      13.080  25.492  17.313  1.00 19.47           O  
ATOM    857  OE2 GLU   122      13.003  25.237  15.084  1.00 25.71           O  
ATOM    858  C   GLU   122      12.574  21.032  19.420  1.00 15.49           C  
ATOM    859  O   GLU   122      13.510  20.282  19.609  1.00 16.98           O  
ATOM    860  N   TYR   123      11.929  21.618  20.404  1.00 16.30           N  
ATOM    861  CA  TYR   123      12.206  21.201  21.762  1.00 15.43           C  
ATOM    862  CB  TYR   123      11.367  22.039  22.714  1.00 16.38           C  
ATOM    863  CG  TYR   123      11.788  21.835  24.120  1.00 16.07           C  
ATOM    864  CD1 TYR   123      12.901  22.435  24.598  1.00 15.49           C  
ATOM    865  CE1 TYR   123      13.321  22.232  25.929  1.00 19.45           C  
ATOM    866  CZ  TYR   123      12.607  21.400  26.760  1.00 16.23           C  
ATOM    867  OH  TYR   123      13.029  21.228  28.042  1.00 17.35           O  
ATOM    868  CE2 TYR   123      11.451  20.786  26.305  1.00 16.29           C  
ATOM    869  CD2 TYR   123      11.054  20.995  24.970  1.00 16.54           C  
ATOM    870  C   TYR   123      12.018  19.706  22.019  1.00 13.89           C  
ATOM    871  O   TYR   123      12.854  19.054  22.589  1.00 13.53           O  
ATOM    872  N   ALA   124      10.893  19.135  21.618  1.00 13.85           N  
ATOM    873  CA  ALA   124      10.664  17.698  21.851  1.00 12.51           C  
ATOM    874  CB  ALA   124       9.251  17.323  21.367  1.00 13.01           C  
ATOM    875  C   ALA   124      11.715  16.813  21.153  1.00 13.94           C  
ATOM    876  O   ALA   124      12.071  15.705  21.639  1.00 14.53           O  
ATOM    877  N   ASN   125      12.168  17.284  19.990  1.00 14.15           N  
ATOM    878  CA  ASN   125      13.077  16.585  19.125  1.00 14.44           C  
ATOM    879  CB  ASN   125      13.086  17.238  17.722  1.00 14.09           C  
ATOM    880  CG  ASN   125      12.038  16.581  16.752  1.00 21.07           C  
ATOM    881  OD1 ASN   125      11.484  15.501  17.037  1.00 20.17           O  
ATOM    882  ND2 ASN   125      11.804  17.223  15.577  1.00 22.67           N  
ATOM    883  C   ASN   125      14.464  16.678  19.719  1.00 14.47           C  
ATOM    884  O   ASN   125      15.260  15.754  19.612  1.00 15.58           O  
ATOM    885  N   TRP   126      14.784  17.826  20.278  1.00 14.60           N  
ATOM    886  CA  TRP   126      16.078  17.955  20.929  1.00 15.28           C  
ATOM    887  CB  TRP   126      16.285  19.394  21.284  1.00 12.16           C  
ATOM    888  CG  TRP   126      17.431  19.564  22.190  1.00 13.11           C  
ATOM    889  CD1 TRP   126      18.750  19.451  21.869  1.00 11.13           C  
ATOM    890  NE1 TRP   126      19.528  19.739  22.965  1.00 15.14           N  
ATOM    891  CE2 TRP   126      18.703  20.016  24.026  1.00 14.65           C  
ATOM    892  CD2 TRP   126      17.381  19.901  23.577  1.00 12.08           C  
ATOM    893  CE3 TRP   126      16.333  20.148  24.484  1.00 16.02           C  
ATOM    894  CZ3 TRP   126      16.634  20.443  25.781  1.00 12.31           C  
ATOM    895  CH2 TRP   126      17.976  20.548  26.201  1.00 14.89           C  
ATOM    896  CZ2 TRP   126      19.009  20.343  25.347  1.00 14.05           C  
ATOM    897  C   TRP   126      16.159  17.029  22.161  1.00 15.61           C  
ATOM    898  O   TRP   126      17.132  16.306  22.358  1.00 18.88           O  
ATOM    899  N   LEU   127      15.115  16.987  22.965  1.00 16.22           N  
ATOM    900  CA  LEU   127      15.132  16.101  24.094  1.00 15.64           C  
ATOM    901  CB  LEU   127      13.843  16.208  24.864  1.00 15.94           C  
ATOM    902  CG  LEU   127      13.773  17.319  25.868  1.00 17.47           C  
ATOM    903  CD1 LEU   127      12.303  17.328  26.334  1.00 20.47           C  
ATOM    904  CD2 LEU   127      14.644  16.961  27.022  1.00 13.54           C  
ATOM    905  C   LEU   127      15.229  14.708  23.661  1.00 16.81           C  
ATOM    906  O   LEU   127      16.055  13.983  24.202  1.00 17.88           O  
ATOM    907  N   ASN   128      14.360  14.262  22.746  1.00 16.02           N  
ATOM    908  CA  ASN   128      14.436  12.858  22.319  1.00 17.58           C  
ATOM    909  CB  ASN   128      13.314  12.495  21.357  1.00 17.78           C  
ATOM    910  CG  ASN   128      11.937  12.828  21.916  1.00 22.92           C  
ATOM    911  OD1 ASN   128      11.699  12.772  23.126  1.00 25.33           O  
ATOM    912  ND2 ASN   128      11.014  13.187  21.030  1.00 29.82           N  
ATOM    913  C   ASN   128      15.769  12.405  21.739  1.00 17.84           C  
ATOM    914  O   ASN   128      16.188  11.266  21.908  1.00 19.12           O  
ATOM    915  N   LYS   129      16.445  13.298  21.035  1.00 19.51           N  
ATOM    916  CA  LYS   129      17.692  12.910  20.408  1.00 19.48           C  
ATOM    917  CB  LYS   129      18.081  13.913  19.346  1.00 20.26           C  
ATOM    918  CG  LYS   129      19.414  13.588  18.664  1.00 21.78           C  
ATOM    919  CD  LYS   129      19.190  12.721  17.385  1.00 27.59           C  
ATOM    920  CE  LYS   129      20.441  11.828  17.201  1.00 30.64           C  
ATOM    921  NZ  LYS   129      20.401  11.136  15.856  1.00 33.95           N  
ATOM    922  C   LYS   129      18.809  12.747  21.416  1.00 19.18           C  
ATOM    923  O   LYS   129      19.707  11.937  21.227  1.00 19.20           O  
ATOM    924  N   ALA   130      18.767  13.574  22.449  1.00 20.02           N  
ATOM    925  CA  ALA   130      19.708  13.568  23.554  1.00 20.13           C  
ATOM    926  CB  ALA   130      19.414  14.706  24.495  1.00 19.64           C  
ATOM    927  C   ALA   130      19.562  12.237  24.271  1.00 21.11           C  
ATOM    928  O   ALA   130      20.533  11.502  24.488  1.00 22.72           O  
ATOM    929  N   ILE   131      18.345  11.894  24.619  1.00 21.52           N  
ATOM    930  CA  ILE   131      18.102  10.614  25.248  1.00 22.82           C  
ATOM    931  CB  ILE   131      16.631  10.528  25.537  1.00 22.98           C  
ATOM    932  CG1 ILE   131      16.396  11.404  26.767  1.00 27.62           C  
ATOM    933  CD1 ILE   131      15.067  12.122  26.740  1.00 34.83           C  
ATOM    934  CG2 ILE   131      16.145   9.072  25.644  1.00 21.71           C  
ATOM    935  C   ILE   131      18.569   9.486  24.352  1.00 23.21           C  
ATOM    936  O   ILE   131      19.058   8.481  24.796  1.00 22.74           O  
ATOM    937  N   GLU   132      18.429   9.658  23.054  1.00 24.60           N  
ATOM    938  CA  GLU   132      18.835   8.588  22.169  1.00 24.37           C  
ATOM    939  CB  GLU   132      18.042   8.714  20.878  1.00 25.81           C  
ATOM    940  CG  GLU   132      18.554   7.818  19.734  1.00 35.33           C  
ATOM    941  CD  GLU   132      18.513   8.516  18.357  1.00 43.54           C  
ATOM    942  OE1 GLU   132      17.449   9.139  18.028  1.00 45.27           O  
ATOM    943  OE2 GLU   132      19.561   8.442  17.639  1.00 47.03           O  
ATOM    944  C   GLU   132      20.370   8.574  21.984  1.00 21.86           C  
ATOM    945  O   GLU   132      20.975   7.520  21.946  1.00 21.77           O  
ATOM    946  N   ILE   133      21.018   9.731  21.935  1.00 19.79           N  
ATOM    947  CA  ILE   133      22.458   9.795  21.961  1.00 18.10           C  
ATOM    948  CB  ILE   133      22.912  11.272  21.930  1.00 19.34           C  
ATOM    949  CG1 ILE   133      22.800  11.863  20.515  1.00 19.81           C  
ATOM    950  CD1 ILE   133      23.852  11.401  19.558  1.00 14.42           C  
ATOM    951  CG2 ILE   133      24.341  11.447  22.330  1.00 19.41           C  
ATOM    952  C   ILE   133      23.033   9.070  23.217  1.00 19.24           C  
ATOM    953  O   ILE   133      24.218   8.662  23.211  1.00 19.36           O  
ATOM    954  N   ASN   134      22.225   8.886  24.288  1.00 17.13           N  
ATOM    955  CA  ASN   134      22.755   8.298  25.497  1.00 16.69           C  
ATOM    956  CB  ASN   134      22.278   9.040  26.772  1.00 14.46           C  
ATOM    957  CG  ASN   134      23.027  10.305  27.045  1.00 13.06           C  
ATOM    958  OD1 ASN   134      24.174  10.339  27.526  1.00  9.50           O  
ATOM    959  ND2 ASN   134      22.384  11.394  26.738  1.00 10.02           N  
ATOM    960  C   ASN   134      22.468   6.772  25.579  1.00 17.41           C  
ATOM    961  O   ASN   134      22.554   6.228  26.626  1.00 18.12           O  
ATOM    962  N   GLY   135      22.150   6.106  24.475  1.00 18.71           N  
ATOM    963  CA  GLY   135      21.886   4.666  24.393  1.00 20.20           C  
ATOM    964  C   GLY   135      20.513   4.287  24.893  1.00 22.51           C  
ATOM    965  O   GLY   135      20.181   3.132  24.901  1.00 23.03           O  
ATOM    966  N   PHE   136      19.696   5.230  25.332  1.00 25.31           N  
ATOM    967  CA  PHE   136      18.362   4.863  25.833  1.00 28.47           C  
ATOM    968  CB  PHE   136      17.843   5.850  26.837  1.00 26.84           C  
ATOM    969  CG  PHE   136      18.691   5.958  28.042  1.00 25.32           C  
ATOM    970  CD1 PHE   136      18.764   4.904  28.938  1.00 24.90           C  
ATOM    971  CE1 PHE   136      19.557   5.002  30.043  1.00 25.29           C  
ATOM    972  CZ  PHE   136      20.289   6.187  30.249  1.00 25.56           C  
ATOM    973  CE2 PHE   136      20.207   7.229  29.357  1.00 23.45           C  
ATOM    974  CD2 PHE   136      19.444   7.096  28.264  1.00 23.61           C  
ATOM    975  C   PHE   136      17.344   4.740  24.739  1.00 32.43           C  
ATOM    976  O   PHE   136      16.962   5.729  24.089  1.00 34.00           O  
ATOM    977  N   ASP   137      16.873   3.519  24.551  1.00 36.29           N  
ATOM    978  CA  ASP   137      15.985   3.202  23.433  1.00 39.70           C  
ATOM    979  CB  ASP   137      14.639   3.981  23.521  1.00 41.05           C  
ATOM    980  CG  ASP   137      13.510   3.315  22.694  1.00 46.24           C  
ATOM    981  OD1 ASP   137      13.565   2.067  22.529  1.00 50.49           O  
ATOM    982  OD2 ASP   137      12.575   4.032  22.201  1.00 53.64           O  
ATOM    983  C   ASP   137      16.743   3.382  22.078  1.00 40.01           C  
ATOM    984  O   ASP   137      17.027   2.342  21.447  1.00 40.81           O  
ATOM    985  OXT ASP   137      17.121   4.487  21.606  1.00 40.01           O  
END
