
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   84 ( 1322),  selected   84 , name 2heq_A
# Molecule2: number of CA atoms   67 ( 1113),  selected   67 , name T0462_77_143.pdb
# PARAMETERS: 2heq_A.T0462_77_143.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      E      77           -
LGA    A     2_A      L      78           -
LGA    G     3_A      P      79           -
LGA    D     4_A      L      80           -
LGA    P     5_A      -       -           -
LGA    L     6_A      -       -           -
LGA    P     7_A      -       -           -
LGA    K     8_A      -       -           -
LGA    Y     9_A      -       -           -
LGA    W    10_A      I      81          5.024
LGA    S    11_A      L      82          2.183
LGA    Y    12_A      A      83          1.483
LGA    P    13_A      D      84          3.083
LGA    V    14_A      D      85          3.822
LGA    G    15_A      G      86          3.017
LGA    L    16_A      -       -           -
LGA    A    17_A      T      87          1.751
LGA    V    18_A      Y      88          1.684
LGA    E    19_A      E      89          2.333
LGA    I    20_A      I      90          3.112
LGA    N    21_A      T      91          4.067
LGA    N    22_A      K      92          5.141
LGA    N    23_A      L      93          2.256
LGA    A    24_A      N      94           #
LGA    -       -      G      95           -
LGA    -       -      G      96           -
LGA    -       -      R      97           -
LGA    -       -      R      98           -
LGA    -       -      F      99           -
LGA    R    25_A      L     100          1.666
LGA    Y    26_A      F     101          3.132
LGA    G    27_A      R     102          2.367
LGA    C    28_A      M     103          1.980
LGA    P    29_A      K     104          2.653
LGA    H    30_A      N     105          3.772
LGA    H    31_A      L     106          3.786
LGA    -       -      G     107           -
LGA    V    32_A      I     108          2.153
LGA    G    33_A      E     109          2.686
LGA    -       -      S     110           -
LGA    -       -      G     111           -
LGA    R    34_A      K     112          1.592
LGA    K    35_A      K     113          1.602
LGA    G    36_A      I     114          1.107
LGA    K    37_A      Q     115          0.375
LGA    I    38_A      V     116          0.342
LGA    I    39_A      S     117          1.113
LGA    E    40_A      G     118          1.227
LGA    H    41_A      R     119          3.328
LGA    L    42_A      -       -           -
LGA    H    43_A      -       -           -
LGA    S    44_A      -       -           -
LGA    A    45_A      -       -           -
LGA    T    46_A      -       -           -
LGA    Y    47_A      -       -           -
LGA    D    48_A      -       -           -
LGA    Y    49_A      -       -           -
LGA    A    50_A      R     120          1.440
LGA    V    51_A      Y     121          0.887
LGA    S    52_A      Y     122          0.776
LGA    D    53_A      I     123          0.632
LGA    E    54_A      E     124          1.561
LGA    T    55_A      -       -           -
LGA    G    56_A      G     125          1.315
LGA    D    57_A      R     126          0.398
LGA    I    58_A      E     127          0.802
LGA    T    59_A      I     128          0.699
LGA    Y    60_A      D     129          2.921
LGA    F    61_A      L     130          3.192
LGA    -       -      G     131           -
LGA    -       -      Y     132           -
LGA    -       -      G     133           -
LGA    -       -      E     134           -
LGA    K    62_A      A     135          0.638
LGA    E    63_A      T     136          2.518
LGA    H    64_A      K     137          2.213
LGA    E    65_A      I     138          0.841
LGA    L    66_A      W     139          2.957
LGA    T    67_A      V     140          0.609
LGA    P    68_A      R     141          1.924
LGA    L    69_A      R     142          2.304
LGA    K    70_A      V     143          3.058
LGA    G    71_A      -       -           -
LGA    G    72_A      -       -           -
LGA    L    73_A      -       -           -
LGA    A    74_A      -       -           -
LGA    Y    75_A      -       -           -
LGA    V    76_A      -       -           -
LGA    L    77_A      -       -           -
LGA    E    78_A      -       -           -
LGA    H    79_A      -       -           -
LGA    H    80_A      -       -           -
LGA    H    81_A      -       -           -
LGA    H    82_A      -       -           -
LGA    H    83_A      -       -           -
LGA    H    84_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   84   67    5.0     50    2.42    12.00     54.905     1.986

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.731695 * X  +  -0.445247 * Y  +  -0.516118 * Z  +  39.872814
  Y_new =  -0.133603 * X  +  -0.648812 * Y  +   0.749128 * Z  +   3.765740
  Z_new =  -0.668411 * X  +   0.617088 * Y  +   0.415246 * Z  +  47.940605 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.978483   -2.163110  [ DEG:    56.0629   -123.9371 ]
  Theta =   0.732070    2.409523  [ DEG:    41.9445    138.0555 ]
  Phi   =  -2.960988    0.180604  [ DEG:  -169.6521     10.3479 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2heq_A                                        
REMARK     2: T0462_77_143.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2heq_A.T0462_77_143.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   84   67   5.0   50   2.42   12.00  54.905
REMARK  ---------------------------------------------------------- 
MOLECULE 2heq_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   21-JUN-06   2HEQ              
TITLE     NMR STRUCTURE OF BACILLUS SUBTILIS PROTEIN YORP, NORTHEAST            
TITLE    2 STRUCTURAL GENOMICS TARGET SR399.                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: YORP PROTEIN;                                              
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS SUBTILIS;                              
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: YORP;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(LAMDA DE3) PMGK;                      
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET21                                     
KEYWDS    SH3-LIKE, NMR STRUCTURE, BSU2030, YORP, NESG, STRUCTURAL              
KEYWDS   2 GENOMICS, PSI-2, PROTEIN STRUCTURE INITIATIVE, NORTHEAST             
KEYWDS   3 STRUCTURAL GENOMICS CONSORTIUM                                       
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    T.A.RAMELOT,J.R.CORT,D.WANG,H.JANJUA,K.CUNNINGHAM,L.-C.MA,            
AUTHOR   2 R.XIAO,J.LIU,M.BARAN,G.V.T.SWAPNA,T.B.ACTON,B.ROST,                  
AUTHOR   3 G.M.MONTELIONE,M.A.KENNEDY,NORTHEAST STRUCTURAL GENOMICS             
AUTHOR   4 CONSORTIUM (NESG)                                                    
REVDAT   1   15-AUG-06 2HEQ    0                                                
JRNL        AUTH   T.A.RAMELOT,J.R.CORT,R.XIAO,G.V.T.SWAPNA,T.B.ACTON,          
JRNL        AUTH 2 G.T.MONTELIONE,M.A.KENNEDY                                   
JRNL        TITL   NMR STRUCTURE OF BACILLUS SUBTILIS PROTEIN YORP,             
JRNL        TITL 2 NORTHEAST STRUCTURAL GENOMICS TARGET SR399.                  
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2HEQ A    7    76  UNP    O31898   O31898_BACSU     2     71             
SEQRES   1 A   84  MET ALA GLY ASP PRO LEU PRO LYS TYR TRP SER TYR PRO          
SEQRES   2 A   84  VAL GLY LEU ALA VAL GLU ILE ASN ASN ASN ALA ARG TYR          
SEQRES   3 A   84  GLY CYS PRO HIS HIS VAL GLY ARG LYS GLY LYS ILE ILE          
SEQRES   4 A   84  GLU HIS LEU HIS SER ALA THR TYR ASP TYR ALA VAL SER          
SEQRES   5 A   84  ASP GLU THR GLY ASP ILE THR TYR PHE LYS GLU HIS GLU          
SEQRES   6 A   84  LEU THR PRO LEU LYS GLY GLY LEU ALA TYR VAL LEU GLU          
SEQRES   7 A   84  HIS HIS HIS HIS HIS HIS                                      
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1       8.731   5.232  13.175  1.00  0.00           N  
ATOM      2  CA  MET A   1       8.006   4.761  11.975  1.00  0.00           C  
ATOM      3  C   MET A   1       7.970   5.857  10.922  1.00  0.00           C  
ATOM      4  O   MET A   1       7.294   6.870  11.093  1.00  0.00           O  
ATOM      5  CB  MET A   1       6.571   4.342  12.324  1.00  0.00           C  
ATOM      6  CG  MET A   1       6.477   3.138  13.249  1.00  0.00           C  
ATOM      7  SD  MET A   1       7.070   3.481  14.917  1.00  0.00           S  
ATOM      8  CE  MET A   1       6.840   1.882  15.695  1.00  0.00           C  
ATOM      9  HA  MET A   1       8.536   3.909  11.574  1.00  0.00           H  
ATOM     10  HB2 MET A   1       6.075   5.172  12.808  1.00  0.00           H  
ATOM     11  HB3 MET A   1       6.048   4.106  11.409  1.00  0.00           H  
ATOM     12  HG2 MET A   1       5.443   2.828  13.309  1.00  0.00           H  
ATOM     13  HG3 MET A   1       7.065   2.334  12.831  1.00  0.00           H  
ATOM     14  HE1 MET A   1       5.797   1.606  15.649  1.00  0.00           H  
ATOM     15  HE2 MET A   1       7.151   1.937  16.729  1.00  0.00           H  
ATOM     16  HE3 MET A   1       7.432   1.141  15.180  1.00  0.00           H  
ATOM     17  H1  MET A   1       8.759   4.483  13.896  1.00  0.00           H  
ATOM     18  H2  MET A   1       8.251   6.069  13.575  1.00  0.00           H  
ATOM     19  H3  MET A   1       9.709   5.493  12.918  1.00  0.00           H  
ATOM     20  N   ALA A   2       8.711   5.658   9.842  1.00  0.00           N  
ATOM     21  CA  ALA A   2       8.753   6.621   8.751  1.00  0.00           C  
ATOM     22  C   ALA A   2       9.151   5.934   7.455  1.00  0.00           C  
ATOM     23  O   ALA A   2       9.918   4.968   7.466  1.00  0.00           O  
ATOM     24  CB  ALA A   2       9.723   7.750   9.068  1.00  0.00           C  
ATOM     25  H   ALA A   2       9.245   4.834   9.771  1.00  0.00           H  
ATOM     26  HA  ALA A   2       7.765   7.044   8.637  1.00  0.00           H  
ATOM     27  HB1 ALA A   2       9.426   8.231   9.988  1.00  0.00           H  
ATOM     28  HB2 ALA A   2       9.711   8.472   8.264  1.00  0.00           H  
ATOM     29  HB3 ALA A   2      10.721   7.349   9.177  1.00  0.00           H  
ATOM     30  N   GLY A   3       8.618   6.420   6.349  1.00  0.00           N  
ATOM     31  CA  GLY A   3       8.952   5.858   5.059  1.00  0.00           C  
ATOM     32  C   GLY A   3       7.725   5.579   4.224  1.00  0.00           C  
ATOM     33  O   GLY A   3       6.629   5.412   4.758  1.00  0.00           O  
ATOM     34  H   GLY A   3       7.978   7.161   6.407  1.00  0.00           H  
ATOM     35  HA2 GLY A   3       9.586   6.555   4.530  1.00  0.00           H  
ATOM     36  HA3 GLY A   3       9.492   4.937   5.209  1.00  0.00           H  
ATOM     37  N   ASP A   4       7.902   5.538   2.915  1.00  0.00           N  
ATOM     38  CA  ASP A   4       6.799   5.276   2.004  1.00  0.00           C  
ATOM     39  C   ASP A   4       6.790   3.812   1.582  1.00  0.00           C  
ATOM     40  O   ASP A   4       7.699   3.339   0.901  1.00  0.00           O  
ATOM     41  CB  ASP A   4       6.872   6.197   0.777  1.00  0.00           C  
ATOM     42  CG  ASP A   4       8.173   6.078  -0.002  1.00  0.00           C  
ATOM     43  OD1 ASP A   4       9.253   6.309   0.590  1.00  0.00           O  
ATOM     44  OD2 ASP A   4       8.119   5.803  -1.220  1.00  0.00           O  
ATOM     45  H   ASP A   4       8.800   5.685   2.547  1.00  0.00           H  
ATOM     46  HA  ASP A   4       5.882   5.482   2.537  1.00  0.00           H  
ATOM     47  HB2 ASP A   4       6.059   5.955   0.109  1.00  0.00           H  
ATOM     48  HB3 ASP A   4       6.766   7.221   1.102  1.00  0.00           H  
ATOM     49  N   PRO A   5       5.761   3.065   2.004  1.00  0.00           N  
ATOM     50  CA  PRO A   5       5.633   1.646   1.703  1.00  0.00           C  
ATOM     51  C   PRO A   5       4.860   1.391   0.410  1.00  0.00           C  
ATOM     52  O   PRO A   5       4.276   0.324   0.227  1.00  0.00           O  
ATOM     53  CB  PRO A   5       4.849   1.139   2.909  1.00  0.00           C  
ATOM     54  CG  PRO A   5       3.949   2.272   3.278  1.00  0.00           C  
ATOM     55  CD  PRO A   5       4.634   3.542   2.828  1.00  0.00           C  
ATOM     56  HA  PRO A   5       6.594   1.155   1.659  1.00  0.00           H  
ATOM     57  HB2 PRO A   5       4.289   0.258   2.633  1.00  0.00           H  
ATOM     58  HB3 PRO A   5       5.533   0.902   3.711  1.00  0.00           H  
ATOM     59  HG2 PRO A   5       2.998   2.163   2.775  1.00  0.00           H  
ATOM     60  HG3 PRO A   5       3.803   2.286   4.349  1.00  0.00           H  
ATOM     61  HD2 PRO A   5       3.958   4.144   2.240  1.00  0.00           H  
ATOM     62  HD3 PRO A   5       4.989   4.099   3.681  1.00  0.00           H  
ATOM     63  N   LEU A   6       4.878   2.368  -0.487  1.00  0.00           N  
ATOM     64  CA  LEU A   6       4.138   2.281  -1.738  1.00  0.00           C  
ATOM     65  C   LEU A   6       4.932   1.469  -2.761  1.00  0.00           C  
ATOM     66  O   LEU A   6       5.989   1.898  -3.221  1.00  0.00           O  
ATOM     67  CB  LEU A   6       3.843   3.697  -2.264  1.00  0.00           C  
ATOM     68  CG  LEU A   6       2.850   3.799  -3.431  1.00  0.00           C  
ATOM     69  CD1 LEU A   6       2.237   5.189  -3.474  1.00  0.00           C  
ATOM     70  CD2 LEU A   6       3.534   3.501  -4.757  1.00  0.00           C  
ATOM     71  H   LEU A   6       5.420   3.163  -0.310  1.00  0.00           H  
ATOM     72  HA  LEU A   6       3.204   1.776  -1.539  1.00  0.00           H  
ATOM     73  HB2 LEU A   6       3.455   4.283  -1.443  1.00  0.00           H  
ATOM     74  HB3 LEU A   6       4.777   4.138  -2.582  1.00  0.00           H  
ATOM     75  HG  LEU A   6       2.055   3.081  -3.289  1.00  0.00           H  
ATOM     76 HD11 LEU A   6       1.497   5.232  -4.260  1.00  0.00           H  
ATOM     77 HD12 LEU A   6       3.010   5.917  -3.667  1.00  0.00           H  
ATOM     78 HD13 LEU A   6       1.766   5.403  -2.526  1.00  0.00           H  
ATOM     79 HD21 LEU A   6       4.340   4.203  -4.912  1.00  0.00           H  
ATOM     80 HD22 LEU A   6       2.820   3.593  -5.562  1.00  0.00           H  
ATOM     81 HD23 LEU A   6       3.931   2.498  -4.742  1.00  0.00           H  
ATOM     82  N   PRO A   7       4.440   0.271  -3.115  1.00  0.00           N  
ATOM     83  CA  PRO A   7       5.089  -0.592  -4.097  1.00  0.00           C  
ATOM     84  C   PRO A   7       4.837  -0.110  -5.523  1.00  0.00           C  
ATOM     85  O   PRO A   7       5.772   0.134  -6.285  1.00  0.00           O  
ATOM     86  CB  PRO A   7       4.438  -1.967  -3.869  1.00  0.00           C  
ATOM     87  CG  PRO A   7       3.533  -1.809  -2.686  1.00  0.00           C  
ATOM     88  CD  PRO A   7       3.222  -0.345  -2.583  1.00  0.00           C  
ATOM     89  HA  PRO A   7       6.153  -0.657  -3.923  1.00  0.00           H  
ATOM     90  HB2 PRO A   7       3.882  -2.252  -4.750  1.00  0.00           H  
ATOM     91  HB3 PRO A   7       5.209  -2.700  -3.677  1.00  0.00           H  
ATOM     92  HG2 PRO A   7       2.625  -2.374  -2.842  1.00  0.00           H  
ATOM     93  HG3 PRO A   7       4.036  -2.149  -1.793  1.00  0.00           H  
ATOM     94  HD2 PRO A   7       2.363  -0.095  -3.190  1.00  0.00           H  
ATOM     95  HD3 PRO A   7       3.060  -0.058  -1.555  1.00  0.00           H  
ATOM     96  N   LYS A   8       3.562   0.022  -5.877  1.00  0.00           N  
ATOM     97  CA  LYS A   8       3.177   0.514  -7.192  1.00  0.00           C  
ATOM     98  C   LYS A   8       1.718   0.954  -7.190  1.00  0.00           C  
ATOM     99  O   LYS A   8       1.419   2.134  -7.369  1.00  0.00           O  
ATOM    100  CB  LYS A   8       3.399  -0.557  -8.263  1.00  0.00           C  
ATOM    101  CG  LYS A   8       3.109  -0.077  -9.673  1.00  0.00           C  
ATOM    102  CD  LYS A   8       3.417  -1.148 -10.703  1.00  0.00           C  
ATOM    103  CE  LYS A   8       3.186  -0.641 -12.116  1.00  0.00           C  
ATOM    104  NZ  LYS A   8       4.047   0.529 -12.435  1.00  0.00           N  
ATOM    105  H   LYS A   8       2.862  -0.214  -5.233  1.00  0.00           H  
ATOM    106  HA  LYS A   8       3.795   1.370  -7.417  1.00  0.00           H  
ATOM    107  HB2 LYS A   8       4.427  -0.882  -8.219  1.00  0.00           H  
ATOM    108  HB3 LYS A   8       2.756  -1.399  -8.052  1.00  0.00           H  
ATOM    109  HG2 LYS A   8       2.065   0.187  -9.747  1.00  0.00           H  
ATOM    110  HG3 LYS A   8       3.715   0.793  -9.881  1.00  0.00           H  
ATOM    111  HD2 LYS A   8       4.450  -1.445 -10.603  1.00  0.00           H  
ATOM    112  HD3 LYS A   8       2.775  -2.000 -10.525  1.00  0.00           H  
ATOM    113  HE2 LYS A   8       3.404  -1.439 -12.813  1.00  0.00           H  
ATOM    114  HE3 LYS A   8       2.149  -0.354 -12.215  1.00  0.00           H  
ATOM    115  HZ1 LYS A   8       3.960   0.771 -13.446  1.00  0.00           H  
ATOM    116  HZ2 LYS A   8       5.045   0.311 -12.224  1.00  0.00           H  
ATOM    117  HZ3 LYS A   8       3.753   1.358 -11.867  1.00  0.00           H  
ATOM    118  N   TYR A   9       0.812   0.005  -6.990  1.00  0.00           N  
ATOM    119  CA  TYR A   9      -0.606   0.320  -6.949  1.00  0.00           C  
ATOM    120  C   TYR A   9      -1.294  -0.437  -5.814  1.00  0.00           C  
ATOM    121  O   TYR A   9      -1.626   0.148  -4.787  1.00  0.00           O  
ATOM    122  CB  TYR A   9      -1.268  -0.009  -8.291  1.00  0.00           C  
ATOM    123  CG  TYR A   9      -2.676   0.528  -8.430  1.00  0.00           C  
ATOM    124  CD1 TYR A   9      -3.739  -0.074  -7.773  1.00  0.00           C  
ATOM    125  CD2 TYR A   9      -2.939   1.642  -9.218  1.00  0.00           C  
ATOM    126  CE1 TYR A   9      -5.023   0.414  -7.893  1.00  0.00           C  
ATOM    127  CE2 TYR A   9      -4.223   2.137  -9.344  1.00  0.00           C  
ATOM    128  CZ  TYR A   9      -5.260   1.518  -8.678  1.00  0.00           C  
ATOM    129  OH  TYR A   9      -6.538   2.006  -8.795  1.00  0.00           O  
ATOM    130  H   TYR A   9       1.100  -0.927  -6.878  1.00  0.00           H  
ATOM    131  HA  TYR A   9      -0.701   1.381  -6.763  1.00  0.00           H  
ATOM    132  HB2 TYR A   9      -0.676   0.413  -9.089  1.00  0.00           H  
ATOM    133  HB3 TYR A   9      -1.309  -1.083  -8.411  1.00  0.00           H  
ATOM    134  HD1 TYR A   9      -3.552  -0.939  -7.156  1.00  0.00           H  
ATOM    135  HD2 TYR A   9      -2.124   2.123  -9.736  1.00  0.00           H  
ATOM    136  HE1 TYR A   9      -5.835  -0.069  -7.372  1.00  0.00           H  
ATOM    137  HE2 TYR A   9      -4.410   3.005  -9.961  1.00  0.00           H  
ATOM    138  HH  TYR A   9      -6.906   2.158  -7.909  1.00  0.00           H  
ATOM    139  N   TRP A  10      -1.477  -1.741  -5.990  1.00  0.00           N  
ATOM    140  CA  TRP A  10      -2.233  -2.540  -5.027  1.00  0.00           C  
ATOM    141  C   TRP A  10      -1.390  -2.917  -3.814  1.00  0.00           C  
ATOM    142  O   TRP A  10      -0.432  -3.688  -3.922  1.00  0.00           O  
ATOM    143  CB  TRP A  10      -2.784  -3.811  -5.686  1.00  0.00           C  
ATOM    144  CG  TRP A  10      -3.809  -3.534  -6.741  1.00  0.00           C  
ATOM    145  CD1 TRP A  10      -5.037  -2.971  -6.558  1.00  0.00           C  
ATOM    146  CD2 TRP A  10      -3.703  -3.822  -8.142  1.00  0.00           C  
ATOM    147  NE1 TRP A  10      -5.697  -2.878  -7.759  1.00  0.00           N  
ATOM    148  CE2 TRP A  10      -4.901  -3.396  -8.747  1.00  0.00           C  
ATOM    149  CE3 TRP A  10      -2.711  -4.397  -8.943  1.00  0.00           C  
ATOM    150  CZ2 TRP A  10      -5.132  -3.524 -10.116  1.00  0.00           C  
ATOM    151  CZ3 TRP A  10      -2.940  -4.522 -10.300  1.00  0.00           C  
ATOM    152  CH2 TRP A  10      -4.143  -4.088 -10.874  1.00  0.00           C  
ATOM    153  H   TRP A  10      -1.094  -2.176  -6.785  1.00  0.00           H  
ATOM    154  HA  TRP A  10      -3.063  -1.939  -4.690  1.00  0.00           H  
ATOM    155  HB2 TRP A  10      -1.972  -4.352  -6.147  1.00  0.00           H  
ATOM    156  HB3 TRP A  10      -3.241  -4.431  -4.930  1.00  0.00           H  
ATOM    157  HD1 TRP A  10      -5.420  -2.643  -5.604  1.00  0.00           H  
ATOM    158  HE1 TRP A  10      -6.597  -2.493  -7.890  1.00  0.00           H  
ATOM    159  HE3 TRP A  10      -1.778  -4.737  -8.519  1.00  0.00           H  
ATOM    160  HZ2 TRP A  10      -6.053  -3.193 -10.574  1.00  0.00           H  
ATOM    161  HZ3 TRP A  10      -2.185  -4.961 -10.934  1.00  0.00           H  
ATOM    162  HH2 TRP A  10      -4.277  -4.206 -11.940  1.00  0.00           H  
ATOM    163  N   SER A  11      -1.751  -2.367  -2.664  1.00  0.00           N  
ATOM    164  CA  SER A  11      -1.096  -2.711  -1.415  1.00  0.00           C  
ATOM    165  C   SER A  11      -1.735  -3.961  -0.804  1.00  0.00           C  
ATOM    166  O   SER A  11      -1.039  -4.830  -0.276  1.00  0.00           O  
ATOM    167  CB  SER A  11      -1.188  -1.539  -0.436  1.00  0.00           C  
ATOM    168  OG  SER A  11      -0.835  -0.321  -1.071  1.00  0.00           O  
ATOM    169  H   SER A  11      -2.466  -1.690  -2.658  1.00  0.00           H  
ATOM    170  HA  SER A  11      -0.058  -2.915  -1.625  1.00  0.00           H  
ATOM    171  HB2 SER A  11      -2.198  -1.459  -0.066  1.00  0.00           H  
ATOM    172  HB3 SER A  11      -0.513  -1.709   0.389  1.00  0.00           H  
ATOM    173  HG  SER A  11      -1.610   0.024  -1.548  1.00  0.00           H  
ATOM    174  N   TYR A  12      -3.058  -4.055  -0.892  1.00  0.00           N  
ATOM    175  CA  TYR A  12      -3.782  -5.180  -0.312  1.00  0.00           C  
ATOM    176  C   TYR A  12      -4.075  -6.241  -1.374  1.00  0.00           C  
ATOM    177  O   TYR A  12      -4.518  -5.924  -2.482  1.00  0.00           O  
ATOM    178  CB  TYR A  12      -5.092  -4.708   0.327  1.00  0.00           C  
ATOM    179  CG  TYR A  12      -4.912  -3.655   1.404  1.00  0.00           C  
ATOM    180  CD1 TYR A  12      -4.123  -3.900   2.520  1.00  0.00           C  
ATOM    181  CD2 TYR A  12      -5.543  -2.419   1.307  1.00  0.00           C  
ATOM    182  CE1 TYR A  12      -3.963  -2.943   3.507  1.00  0.00           C  
ATOM    183  CE2 TYR A  12      -5.386  -1.457   2.285  1.00  0.00           C  
ATOM    184  CZ  TYR A  12      -4.598  -1.725   3.384  1.00  0.00           C  
ATOM    185  OH  TYR A  12      -4.449  -0.770   4.366  1.00  0.00           O  
ATOM    186  H   TYR A  12      -3.562  -3.352  -1.363  1.00  0.00           H  
ATOM    187  HA  TYR A  12      -3.157  -5.617   0.454  1.00  0.00           H  
ATOM    188  HB2 TYR A  12      -5.725  -4.287  -0.442  1.00  0.00           H  
ATOM    189  HB3 TYR A  12      -5.593  -5.557   0.771  1.00  0.00           H  
ATOM    190  HD1 TYR A  12      -3.626  -4.854   2.613  1.00  0.00           H  
ATOM    191  HD2 TYR A  12      -6.159  -2.212   0.446  1.00  0.00           H  
ATOM    192  HE1 TYR A  12      -3.344  -3.152   4.367  1.00  0.00           H  
ATOM    193  HE2 TYR A  12      -5.884  -0.504   2.188  1.00  0.00           H  
ATOM    194  HH  TYR A  12      -3.514  -0.679   4.593  1.00  0.00           H  
ATOM    195  N   PRO A  13      -3.827  -7.517  -1.049  1.00  0.00           N  
ATOM    196  CA  PRO A  13      -4.032  -8.633  -1.974  1.00  0.00           C  
ATOM    197  C   PRO A  13      -5.473  -9.149  -1.984  1.00  0.00           C  
ATOM    198  O   PRO A  13      -6.314  -8.718  -1.191  1.00  0.00           O  
ATOM    199  CB  PRO A  13      -3.095  -9.700  -1.413  1.00  0.00           C  
ATOM    200  CG  PRO A  13      -3.093  -9.459   0.058  1.00  0.00           C  
ATOM    201  CD  PRO A  13      -3.313  -7.977   0.254  1.00  0.00           C  
ATOM    202  HA  PRO A  13      -3.732  -8.379  -2.979  1.00  0.00           H  
ATOM    203  HB2 PRO A  13      -3.475 -10.683  -1.656  1.00  0.00           H  
ATOM    204  HB3 PRO A  13      -2.109  -9.575  -1.835  1.00  0.00           H  
ATOM    205  HG2 PRO A  13      -3.893 -10.019   0.521  1.00  0.00           H  
ATOM    206  HG3 PRO A  13      -2.142  -9.751   0.476  1.00  0.00           H  
ATOM    207  HD2 PRO A  13      -4.039  -7.801   1.033  1.00  0.00           H  
ATOM    208  HD3 PRO A  13      -2.380  -7.487   0.490  1.00  0.00           H  
ATOM    209  N   VAL A  14      -5.750 -10.076  -2.893  1.00  0.00           N  
ATOM    210  CA  VAL A  14      -7.059 -10.704  -2.983  1.00  0.00           C  
ATOM    211  C   VAL A  14      -7.212 -11.770  -1.902  1.00  0.00           C  
ATOM    212  O   VAL A  14      -6.298 -12.563  -1.663  1.00  0.00           O  
ATOM    213  CB  VAL A  14      -7.280 -11.349  -4.370  1.00  0.00           C  
ATOM    214  CG1 VAL A  14      -8.603 -12.099  -4.424  1.00  0.00           C  
ATOM    215  CG2 VAL A  14      -7.228 -10.294  -5.462  1.00  0.00           C  
ATOM    216  H   VAL A  14      -5.044 -10.352  -3.525  1.00  0.00           H  
ATOM    217  HA  VAL A  14      -7.812  -9.939  -2.837  1.00  0.00           H  
ATOM    218  HB  VAL A  14      -6.483 -12.056  -4.546  1.00  0.00           H  
ATOM    219 HG11 VAL A  14      -8.720 -12.553  -5.398  1.00  0.00           H  
ATOM    220 HG12 VAL A  14      -9.415 -11.409  -4.248  1.00  0.00           H  
ATOM    221 HG13 VAL A  14      -8.613 -12.868  -3.665  1.00  0.00           H  
ATOM    222 HG21 VAL A  14      -7.387 -10.761  -6.422  1.00  0.00           H  
ATOM    223 HG22 VAL A  14      -6.262  -9.811  -5.452  1.00  0.00           H  
ATOM    224 HG23 VAL A  14      -8.000  -9.558  -5.290  1.00  0.00           H  
ATOM    225  N   GLY A  15      -8.365 -11.779  -1.249  1.00  0.00           N  
ATOM    226  CA  GLY A  15      -8.628 -12.748  -0.207  1.00  0.00           C  
ATOM    227  C   GLY A  15      -8.394 -12.180   1.176  1.00  0.00           C  
ATOM    228  O   GLY A  15      -8.588 -12.868   2.180  1.00  0.00           O  
ATOM    229  H   GLY A  15      -9.057 -11.117  -1.484  1.00  0.00           H  
ATOM    230  HA2 GLY A  15      -9.656 -13.071  -0.282  1.00  0.00           H  
ATOM    231  HA3 GLY A  15      -7.983 -13.602  -0.350  1.00  0.00           H  
ATOM    232  N   LEU A  16      -7.990 -10.921   1.230  1.00  0.00           N  
ATOM    233  CA  LEU A  16      -7.728 -10.262   2.495  1.00  0.00           C  
ATOM    234  C   LEU A  16      -9.029  -9.793   3.133  1.00  0.00           C  
ATOM    235  O   LEU A  16      -9.864  -9.159   2.480  1.00  0.00           O  
ATOM    236  CB  LEU A  16      -6.785  -9.071   2.289  1.00  0.00           C  
ATOM    237  CG  LEU A  16      -6.367  -8.349   3.573  1.00  0.00           C  
ATOM    238  CD1 LEU A  16      -5.569  -9.279   4.473  1.00  0.00           C  
ATOM    239  CD2 LEU A  16      -5.563  -7.100   3.249  1.00  0.00           C  
ATOM    240  H   LEU A  16      -7.866 -10.421   0.396  1.00  0.00           H  
ATOM    241  HA  LEU A  16      -7.254 -10.975   3.150  1.00  0.00           H  
ATOM    242  HB2 LEU A  16      -5.894  -9.428   1.794  1.00  0.00           H  
ATOM    243  HB3 LEU A  16      -7.274  -8.356   1.644  1.00  0.00           H  
ATOM    244  HG  LEU A  16      -7.252  -8.047   4.112  1.00  0.00           H  
ATOM    245 HD11 LEU A  16      -4.682  -9.607   3.951  1.00  0.00           H  
ATOM    246 HD12 LEU A  16      -6.173 -10.137   4.731  1.00  0.00           H  
ATOM    247 HD13 LEU A  16      -5.286  -8.755   5.372  1.00  0.00           H  
ATOM    248 HD21 LEU A  16      -6.163  -6.426   2.657  1.00  0.00           H  
ATOM    249 HD22 LEU A  16      -4.678  -7.376   2.695  1.00  0.00           H  
ATOM    250 HD23 LEU A  16      -5.272  -6.611   4.167  1.00  0.00           H  
ATOM    251  N   ALA A  17      -9.210 -10.133   4.400  1.00  0.00           N  
ATOM    252  CA  ALA A  17     -10.351  -9.657   5.158  1.00  0.00           C  
ATOM    253  C   ALA A  17     -10.087  -8.246   5.667  1.00  0.00           C  
ATOM    254  O   ALA A  17      -9.052  -7.978   6.283  1.00  0.00           O  
ATOM    255  CB  ALA A  17     -10.651 -10.597   6.313  1.00  0.00           C  
ATOM    256  H   ALA A  17      -8.557 -10.724   4.838  1.00  0.00           H  
ATOM    257  HA  ALA A  17     -11.208  -9.640   4.499  1.00  0.00           H  
ATOM    258  HB1 ALA A  17     -10.844 -11.587   5.928  1.00  0.00           H  
ATOM    259  HB2 ALA A  17     -11.518 -10.241   6.849  1.00  0.00           H  
ATOM    260  HB3 ALA A  17      -9.802 -10.627   6.979  1.00  0.00           H  
ATOM    261  N   VAL A  18     -11.015  -7.345   5.398  1.00  0.00           N  
ATOM    262  CA  VAL A  18     -10.878  -5.955   5.801  1.00  0.00           C  
ATOM    263  C   VAL A  18     -12.175  -5.457   6.422  1.00  0.00           C  
ATOM    264  O   VAL A  18     -13.212  -6.110   6.317  1.00  0.00           O  
ATOM    265  CB  VAL A  18     -10.513  -5.040   4.606  1.00  0.00           C  
ATOM    266  CG1 VAL A  18      -9.136  -5.382   4.054  1.00  0.00           C  
ATOM    267  CG2 VAL A  18     -11.568  -5.138   3.511  1.00  0.00           C  
ATOM    268  H   VAL A  18     -11.830  -7.622   4.924  1.00  0.00           H  
ATOM    269  HA  VAL A  18     -10.087  -5.894   6.534  1.00  0.00           H  
ATOM    270  HB  VAL A  18     -10.487  -4.019   4.957  1.00  0.00           H  
ATOM    271 HG11 VAL A  18      -8.395  -5.241   4.825  1.00  0.00           H  
ATOM    272 HG12 VAL A  18      -8.912  -4.737   3.218  1.00  0.00           H  
ATOM    273 HG13 VAL A  18      -9.126  -6.411   3.728  1.00  0.00           H  
ATOM    274 HG21 VAL A  18     -12.527  -4.834   3.906  1.00  0.00           H  
ATOM    275 HG22 VAL A  18     -11.631  -6.159   3.162  1.00  0.00           H  
ATOM    276 HG23 VAL A  18     -11.296  -4.494   2.689  1.00  0.00           H  
ATOM    277  N   GLU A  19     -12.110  -4.313   7.075  1.00  0.00           N  
ATOM    278  CA  GLU A  19     -13.300  -3.665   7.588  1.00  0.00           C  
ATOM    279  C   GLU A  19     -13.452  -2.294   6.947  1.00  0.00           C  
ATOM    280  O   GLU A  19     -12.460  -1.649   6.598  1.00  0.00           O  
ATOM    281  CB  GLU A  19     -13.246  -3.542   9.114  1.00  0.00           C  
ATOM    282  CG  GLU A  19     -12.054  -2.754   9.639  1.00  0.00           C  
ATOM    283  CD  GLU A  19     -12.089  -2.598  11.142  1.00  0.00           C  
ATOM    284  OE1 GLU A  19     -12.783  -1.681  11.631  1.00  0.00           O  
ATOM    285  OE2 GLU A  19     -11.448  -3.405  11.847  1.00  0.00           O  
ATOM    286  H   GLU A  19     -11.236  -3.889   7.219  1.00  0.00           H  
ATOM    287  HA  GLU A  19     -14.149  -4.274   7.312  1.00  0.00           H  
ATOM    288  HB2 GLU A  19     -14.146  -3.051   9.451  1.00  0.00           H  
ATOM    289  HB3 GLU A  19     -13.210  -4.535   9.542  1.00  0.00           H  
ATOM    290  HG2 GLU A  19     -11.145  -3.270   9.367  1.00  0.00           H  
ATOM    291  HG3 GLU A  19     -12.059  -1.772   9.189  1.00  0.00           H  
ATOM    292  N   ILE A  20     -14.688  -1.864   6.774  1.00  0.00           N  
ATOM    293  CA  ILE A  20     -14.965  -0.568   6.184  1.00  0.00           C  
ATOM    294  C   ILE A  20     -15.067   0.480   7.280  1.00  0.00           C  
ATOM    295  O   ILE A  20     -16.045   0.513   8.028  1.00  0.00           O  
ATOM    296  CB  ILE A  20     -16.279  -0.556   5.361  1.00  0.00           C  
ATOM    297  CG1 ILE A  20     -16.283  -1.642   4.278  1.00  0.00           C  
ATOM    298  CG2 ILE A  20     -16.487   0.813   4.728  1.00  0.00           C  
ATOM    299  CD1 ILE A  20     -16.747  -2.999   4.766  1.00  0.00           C  
ATOM    300  H   ILE A  20     -15.437  -2.428   7.067  1.00  0.00           H  
ATOM    301  HA  ILE A  20     -14.146  -0.316   5.529  1.00  0.00           H  
ATOM    302  HB  ILE A  20     -17.100  -0.732   6.040  1.00  0.00           H  
ATOM    303 HG12 ILE A  20     -16.939  -1.340   3.476  1.00  0.00           H  
ATOM    304 HG13 ILE A  20     -15.281  -1.756   3.889  1.00  0.00           H  
ATOM    305 HG21 ILE A  20     -16.539   1.562   5.505  1.00  0.00           H  
ATOM    306 HG22 ILE A  20     -17.407   0.813   4.163  1.00  0.00           H  
ATOM    307 HG23 ILE A  20     -15.659   1.034   4.071  1.00  0.00           H  
ATOM    308 HD11 ILE A  20     -16.736  -3.699   3.943  1.00  0.00           H  
ATOM    309 HD12 ILE A  20     -17.754  -2.919   5.160  1.00  0.00           H  
ATOM    310 HD13 ILE A  20     -16.084  -3.347   5.542  1.00  0.00           H  
ATOM    311  N   ASN A  21     -14.055   1.325   7.386  1.00  0.00           N  
ATOM    312  CA  ASN A  21     -14.056   2.378   8.391  1.00  0.00           C  
ATOM    313  C   ASN A  21     -15.026   3.491   7.999  1.00  0.00           C  
ATOM    314  O   ASN A  21     -15.410   3.616   6.834  1.00  0.00           O  
ATOM    315  CB  ASN A  21     -12.647   2.946   8.607  1.00  0.00           C  
ATOM    316  CG  ASN A  21     -11.971   3.356   7.315  1.00  0.00           C  
ATOM    317  OD1 ASN A  21     -12.214   4.442   6.796  1.00  0.00           O  
ATOM    318  ND2 ASN A  21     -11.082   2.513   6.815  1.00  0.00           N  
ATOM    319  H   ASN A  21     -13.296   1.247   6.766  1.00  0.00           H  
ATOM    320  HA  ASN A  21     -14.398   1.939   9.317  1.00  0.00           H  
ATOM    321  HB2 ASN A  21     -12.713   3.814   9.245  1.00  0.00           H  
ATOM    322  HB3 ASN A  21     -12.038   2.197   9.090  1.00  0.00           H  
ATOM    323 HD21 ASN A  21     -10.902   1.678   7.305  1.00  0.00           H  
ATOM    324 HD22 ASN A  21     -10.642   2.750   5.974  1.00  0.00           H  
ATOM    325  N   ASN A  22     -15.407   4.306   8.976  1.00  0.00           N  
ATOM    326  CA  ASN A  22     -16.416   5.352   8.775  1.00  0.00           C  
ATOM    327  C   ASN A  22     -15.853   6.580   8.065  1.00  0.00           C  
ATOM    328  O   ASN A  22     -16.343   7.688   8.248  1.00  0.00           O  
ATOM    329  CB  ASN A  22     -17.028   5.770  10.119  1.00  0.00           C  
ATOM    330  CG  ASN A  22     -18.178   4.879  10.554  1.00  0.00           C  
ATOM    331  OD1 ASN A  22     -19.339   5.167  10.272  1.00  0.00           O  
ATOM    332  ND2 ASN A  22     -17.869   3.792  11.246  1.00  0.00           N  
ATOM    333  H   ASN A  22     -15.004   4.200   9.864  1.00  0.00           H  
ATOM    334  HA  ASN A  22     -17.190   4.936   8.156  1.00  0.00           H  
ATOM    335  HB2 ASN A  22     -16.264   5.732  10.880  1.00  0.00           H  
ATOM    336  HB3 ASN A  22     -17.394   6.784  10.037  1.00  0.00           H  
ATOM    337 HD21 ASN A  22     -16.922   3.617  11.441  1.00  0.00           H  
ATOM    338 HD22 ASN A  22     -18.604   3.203  11.541  1.00  0.00           H  
ATOM    339  N   ASN A  23     -14.857   6.372   7.222  1.00  0.00           N  
ATOM    340  CA  ASN A  23     -14.271   7.470   6.458  1.00  0.00           C  
ATOM    341  C   ASN A  23     -14.794   7.451   5.030  1.00  0.00           C  
ATOM    342  O   ASN A  23     -14.486   8.327   4.223  1.00  0.00           O  
ATOM    343  CB  ASN A  23     -12.742   7.419   6.476  1.00  0.00           C  
ATOM    344  CG  ASN A  23     -12.179   7.678   7.859  1.00  0.00           C  
ATOM    345  OD1 ASN A  23     -11.993   8.826   8.262  1.00  0.00           O  
ATOM    346  ND2 ASN A  23     -11.887   6.616   8.588  1.00  0.00           N  
ATOM    347  H   ASN A  23     -14.524   5.459   7.095  1.00  0.00           H  
ATOM    348  HA  ASN A  23     -14.593   8.392   6.922  1.00  0.00           H  
ATOM    349  HB2 ASN A  23     -12.416   6.440   6.153  1.00  0.00           H  
ATOM    350  HB3 ASN A  23     -12.350   8.167   5.801  1.00  0.00           H  
ATOM    351 HD21 ASN A  23     -12.046   5.729   8.198  1.00  0.00           H  
ATOM    352 HD22 ASN A  23     -11.519   6.757   9.490  1.00  0.00           H  
ATOM    353  N   ALA A  24     -15.600   6.441   4.727  1.00  0.00           N  
ATOM    354  CA  ALA A  24     -16.318   6.377   3.460  1.00  0.00           C  
ATOM    355  C   ALA A  24     -17.718   6.956   3.645  1.00  0.00           C  
ATOM    356  O   ALA A  24     -18.630   6.699   2.856  1.00  0.00           O  
ATOM    357  CB  ALA A  24     -16.382   4.942   2.957  1.00  0.00           C  
ATOM    358  H   ALA A  24     -15.712   5.714   5.376  1.00  0.00           H  
ATOM    359  HA  ALA A  24     -15.780   6.974   2.735  1.00  0.00           H  
ATOM    360  HB1 ALA A  24     -16.910   4.915   2.015  1.00  0.00           H  
ATOM    361  HB2 ALA A  24     -16.900   4.330   3.679  1.00  0.00           H  
ATOM    362  HB3 ALA A  24     -15.380   4.563   2.817  1.00  0.00           H  
ATOM    363  N   ARG A  25     -17.852   7.743   4.712  1.00  0.00           N  
ATOM    364  CA  ARG A  25     -19.096   8.412   5.080  1.00  0.00           C  
ATOM    365  C   ARG A  25     -19.745   9.093   3.875  1.00  0.00           C  
ATOM    366  O   ARG A  25     -20.913   8.852   3.570  1.00  0.00           O  
ATOM    367  CB  ARG A  25     -18.784   9.432   6.176  1.00  0.00           C  
ATOM    368  CG  ARG A  25     -19.959  10.287   6.616  1.00  0.00           C  
ATOM    369  CD  ARG A  25     -19.522  11.319   7.649  1.00  0.00           C  
ATOM    370  NE  ARG A  25     -19.182  10.712   8.941  1.00  0.00           N  
ATOM    371  CZ  ARG A  25     -17.935  10.480   9.371  1.00  0.00           C  
ATOM    372  NH1 ARG A  25     -16.890  10.732   8.592  1.00  0.00           N  
ATOM    373  NH2 ARG A  25     -17.739   9.983  10.585  1.00  0.00           N  
ATOM    374  H   ARG A  25     -17.070   7.880   5.286  1.00  0.00           H  
ATOM    375  HA  ARG A  25     -19.776   7.671   5.473  1.00  0.00           H  
ATOM    376  HB2 ARG A  25     -18.419   8.900   7.040  1.00  0.00           H  
ATOM    377  HB3 ARG A  25     -18.006  10.090   5.819  1.00  0.00           H  
ATOM    378  HG2 ARG A  25     -20.366  10.798   5.757  1.00  0.00           H  
ATOM    379  HG3 ARG A  25     -20.714   9.649   7.054  1.00  0.00           H  
ATOM    380  HD2 ARG A  25     -18.657  11.844   7.272  1.00  0.00           H  
ATOM    381  HD3 ARG A  25     -20.330  12.023   7.796  1.00  0.00           H  
ATOM    382  HE  ARG A  25     -19.937  10.489   9.539  1.00  0.00           H  
ATOM    383 HH11 ARG A  25     -17.020  11.103   7.668  1.00  0.00           H  
ATOM    384 HH12 ARG A  25     -15.953  10.542   8.920  1.00  0.00           H  
ATOM    385 HH21 ARG A  25     -18.524   9.781  11.187  1.00  0.00           H  
ATOM    386 HH22 ARG A  25     -16.806   9.815  10.916  1.00  0.00           H  
ATOM    387  N   TYR A  26     -18.981   9.931   3.189  1.00  0.00           N  
ATOM    388  CA  TYR A  26     -19.469  10.588   1.991  1.00  0.00           C  
ATOM    389  C   TYR A  26     -18.998   9.830   0.760  1.00  0.00           C  
ATOM    390  O   TYR A  26     -17.955  10.135   0.183  1.00  0.00           O  
ATOM    391  CB  TYR A  26     -19.012  12.048   1.938  1.00  0.00           C  
ATOM    392  CG  TYR A  26     -19.628  12.907   3.017  1.00  0.00           C  
ATOM    393  CD1 TYR A  26     -20.937  13.353   2.906  1.00  0.00           C  
ATOM    394  CD2 TYR A  26     -18.903  13.266   4.147  1.00  0.00           C  
ATOM    395  CE1 TYR A  26     -21.510  14.133   3.890  1.00  0.00           C  
ATOM    396  CE2 TYR A  26     -19.470  14.045   5.137  1.00  0.00           C  
ATOM    397  CZ  TYR A  26     -20.772  14.478   5.002  1.00  0.00           C  
ATOM    398  OH  TYR A  26     -21.342  15.255   5.985  1.00  0.00           O  
ATOM    399  H   TYR A  26     -18.056  10.099   3.488  1.00  0.00           H  
ATOM    400  HA  TYR A  26     -20.548  10.560   2.018  1.00  0.00           H  
ATOM    401  HB2 TYR A  26     -17.940  12.086   2.054  1.00  0.00           H  
ATOM    402  HB3 TYR A  26     -19.282  12.468   0.979  1.00  0.00           H  
ATOM    403  HD1 TYR A  26     -21.512  13.081   2.034  1.00  0.00           H  
ATOM    404  HD2 TYR A  26     -17.883  12.925   4.247  1.00  0.00           H  
ATOM    405  HE1 TYR A  26     -22.529  14.471   3.785  1.00  0.00           H  
ATOM    406  HE2 TYR A  26     -18.893  14.315   6.008  1.00  0.00           H  
ATOM    407  HH  TYR A  26     -22.186  14.861   6.255  1.00  0.00           H  
ATOM    408  N   GLY A  27     -19.765   8.817   0.396  1.00  0.00           N  
ATOM    409  CA  GLY A  27     -19.425   7.980  -0.734  1.00  0.00           C  
ATOM    410  C   GLY A  27     -20.153   6.659  -0.659  1.00  0.00           C  
ATOM    411  O   GLY A  27     -20.593   6.117  -1.672  1.00  0.00           O  
ATOM    412  H   GLY A  27     -20.579   8.628   0.909  1.00  0.00           H  
ATOM    413  HA2 GLY A  27     -19.700   8.488  -1.648  1.00  0.00           H  
ATOM    414  HA3 GLY A  27     -18.362   7.800  -0.734  1.00  0.00           H  
ATOM    415  N   CYS A  28     -20.283   6.145   0.556  1.00  0.00           N  
ATOM    416  CA  CYS A  28     -21.051   4.937   0.808  1.00  0.00           C  
ATOM    417  C   CYS A  28     -21.899   5.132   2.061  1.00  0.00           C  
ATOM    418  O   CYS A  28     -21.552   4.654   3.144  1.00  0.00           O  
ATOM    419  CB  CYS A  28     -20.125   3.728   0.959  1.00  0.00           C  
ATOM    420  SG  CYS A  28     -19.117   3.390  -0.504  1.00  0.00           S  
ATOM    421  H   CYS A  28     -19.843   6.593   1.315  1.00  0.00           H  
ATOM    422  HA  CYS A  28     -21.708   4.779  -0.035  1.00  0.00           H  
ATOM    423  HB2 CYS A  28     -19.455   3.897   1.788  1.00  0.00           H  
ATOM    424  HB3 CYS A  28     -20.721   2.849   1.159  1.00  0.00           H  
ATOM    425  HG  CYS A  28     -19.351   4.355  -1.384  1.00  0.00           H  
ATOM    426  N   PRO A  29     -23.018   5.862   1.926  1.00  0.00           N  
ATOM    427  CA  PRO A  29     -23.858   6.242   3.063  1.00  0.00           C  
ATOM    428  C   PRO A  29     -24.451   5.036   3.776  1.00  0.00           C  
ATOM    429  O   PRO A  29     -25.162   4.227   3.173  1.00  0.00           O  
ATOM    430  CB  PRO A  29     -24.959   7.103   2.433  1.00  0.00           C  
ATOM    431  CG  PRO A  29     -24.978   6.716   0.996  1.00  0.00           C  
ATOM    432  CD  PRO A  29     -23.563   6.358   0.650  1.00  0.00           C  
ATOM    433  HA  PRO A  29     -23.302   6.834   3.777  1.00  0.00           H  
ATOM    434  HB2 PRO A  29     -25.904   6.892   2.913  1.00  0.00           H  
ATOM    435  HB3 PRO A  29     -24.712   8.147   2.554  1.00  0.00           H  
ATOM    436  HG2 PRO A  29     -25.627   5.863   0.852  1.00  0.00           H  
ATOM    437  HG3 PRO A  29     -25.312   7.548   0.396  1.00  0.00           H  
ATOM    438  HD2 PRO A  29     -23.540   5.586  -0.107  1.00  0.00           H  
ATOM    439  HD3 PRO A  29     -23.024   7.232   0.316  1.00  0.00           H  
ATOM    440  N   HIS A  30     -24.121   4.913   5.058  1.00  0.00           N  
ATOM    441  CA  HIS A  30     -24.636   3.843   5.910  1.00  0.00           C  
ATOM    442  C   HIS A  30     -24.178   2.472   5.406  1.00  0.00           C  
ATOM    443  O   HIS A  30     -24.848   1.458   5.595  1.00  0.00           O  
ATOM    444  CB  HIS A  30     -26.167   3.925   5.988  1.00  0.00           C  
ATOM    445  CG  HIS A  30     -26.760   3.128   7.107  1.00  0.00           C  
ATOM    446  ND1 HIS A  30     -27.617   2.071   6.904  1.00  0.00           N  
ATOM    447  CD2 HIS A  30     -26.624   3.248   8.450  1.00  0.00           C  
ATOM    448  CE1 HIS A  30     -27.984   1.576   8.070  1.00  0.00           C  
ATOM    449  NE2 HIS A  30     -27.394   2.270   9.023  1.00  0.00           N  
ATOM    450  H   HIS A  30     -23.511   5.572   5.450  1.00  0.00           H  
ATOM    451  HA  HIS A  30     -24.225   3.992   6.895  1.00  0.00           H  
ATOM    452  HB2 HIS A  30     -26.457   4.956   6.126  1.00  0.00           H  
ATOM    453  HB3 HIS A  30     -26.586   3.562   5.060  1.00  0.00           H  
ATOM    454  HD1 HIS A  30     -27.917   1.733   6.021  1.00  0.00           H  
ATOM    455  HD2 HIS A  30     -26.022   3.979   8.970  1.00  0.00           H  
ATOM    456  HE1 HIS A  30     -28.653   0.743   8.220  1.00  0.00           H  
ATOM    457  HE2 HIS A  30     -27.605   2.205   9.990  1.00  0.00           H  
ATOM    458  N   HIS A  31     -23.016   2.452   4.776  1.00  0.00           N  
ATOM    459  CA  HIS A  31     -22.407   1.204   4.319  1.00  0.00           C  
ATOM    460  C   HIS A  31     -21.047   1.050   4.996  1.00  0.00           C  
ATOM    461  O   HIS A  31     -20.219   0.225   4.610  1.00  0.00           O  
ATOM    462  CB  HIS A  31     -22.252   1.205   2.788  1.00  0.00           C  
ATOM    463  CG  HIS A  31     -22.125  -0.163   2.172  1.00  0.00           C  
ATOM    464  ND1 HIS A  31     -21.046  -0.993   2.380  1.00  0.00           N  
ATOM    465  CD2 HIS A  31     -22.953  -0.836   1.335  1.00  0.00           C  
ATOM    466  CE1 HIS A  31     -21.213  -2.111   1.700  1.00  0.00           C  
ATOM    467  NE2 HIS A  31     -22.364  -2.044   1.055  1.00  0.00           N  
ATOM    468  H   HIS A  31     -22.550   3.302   4.614  1.00  0.00           H  
ATOM    469  HA  HIS A  31     -23.047   0.388   4.618  1.00  0.00           H  
ATOM    470  HB2 HIS A  31     -23.115   1.682   2.349  1.00  0.00           H  
ATOM    471  HB3 HIS A  31     -21.368   1.769   2.526  1.00  0.00           H  
ATOM    472  HD1 HIS A  31     -20.273  -0.797   2.958  1.00  0.00           H  
ATOM    473  HD2 HIS A  31     -23.902  -0.483   0.956  1.00  0.00           H  
ATOM    474  HE1 HIS A  31     -20.522  -2.941   1.673  1.00  0.00           H  
ATOM    475  HE2 HIS A  31     -22.608  -2.626   0.289  1.00  0.00           H  
ATOM    476  N   VAL A  32     -20.836   1.852   6.025  1.00  0.00           N  
ATOM    477  CA  VAL A  32     -19.564   1.890   6.723  1.00  0.00           C  
ATOM    478  C   VAL A  32     -19.723   1.414   8.160  1.00  0.00           C  
ATOM    479  O   VAL A  32     -20.792   1.553   8.755  1.00  0.00           O  
ATOM    480  CB  VAL A  32     -18.965   3.312   6.710  1.00  0.00           C  
ATOM    481  CG1 VAL A  32     -18.591   3.717   5.297  1.00  0.00           C  
ATOM    482  CG2 VAL A  32     -19.942   4.321   7.296  1.00  0.00           C  
ATOM    483  H   VAL A  32     -21.563   2.427   6.338  1.00  0.00           H  
ATOM    484  HA  VAL A  32     -18.882   1.229   6.208  1.00  0.00           H  
ATOM    485  HB  VAL A  32     -18.071   3.314   7.312  1.00  0.00           H  
ATOM    486 HG11 VAL A  32     -19.475   3.711   4.676  1.00  0.00           H  
ATOM    487 HG12 VAL A  32     -17.869   3.017   4.903  1.00  0.00           H  
ATOM    488 HG13 VAL A  32     -18.165   4.709   5.308  1.00  0.00           H  
ATOM    489 HG21 VAL A  32     -20.187   4.038   8.309  1.00  0.00           H  
ATOM    490 HG22 VAL A  32     -20.843   4.339   6.699  1.00  0.00           H  
ATOM    491 HG23 VAL A  32     -19.491   5.302   7.296  1.00  0.00           H  
ATOM    492  N   GLY A  33     -18.658   0.845   8.706  1.00  0.00           N  
ATOM    493  CA  GLY A  33     -18.699   0.333  10.058  1.00  0.00           C  
ATOM    494  C   GLY A  33     -18.897  -1.168  10.101  1.00  0.00           C  
ATOM    495  O   GLY A  33     -19.188  -1.725  11.156  1.00  0.00           O  
ATOM    496  H   GLY A  33     -17.824   0.781   8.187  1.00  0.00           H  
ATOM    497  HA2 GLY A  33     -17.772   0.580  10.552  1.00  0.00           H  
ATOM    498  HA3 GLY A  33     -19.513   0.807  10.585  1.00  0.00           H  
ATOM    499  N   ARG A  34     -18.738  -1.823   8.955  1.00  0.00           N  
ATOM    500  CA  ARG A  34     -18.892  -3.273   8.869  1.00  0.00           C  
ATOM    501  C   ARG A  34     -17.617  -3.901   8.326  1.00  0.00           C  
ATOM    502  O   ARG A  34     -16.607  -3.219   8.177  1.00  0.00           O  
ATOM    503  CB  ARG A  34     -20.076  -3.646   7.973  1.00  0.00           C  
ATOM    504  CG  ARG A  34     -21.381  -3.005   8.401  1.00  0.00           C  
ATOM    505  CD  ARG A  34     -22.572  -3.642   7.711  1.00  0.00           C  
ATOM    506  NE  ARG A  34     -22.517  -3.514   6.259  1.00  0.00           N  
ATOM    507  CZ  ARG A  34     -23.549  -3.150   5.505  1.00  0.00           C  
ATOM    508  NH1 ARG A  34     -24.710  -2.811   6.058  1.00  0.00           N  
ATOM    509  NH2 ARG A  34     -23.412  -3.127   4.189  1.00  0.00           N  
ATOM    510  H   ARG A  34     -18.498  -1.321   8.151  1.00  0.00           H  
ATOM    511  HA  ARG A  34     -19.068  -3.650   9.866  1.00  0.00           H  
ATOM    512  HB2 ARG A  34     -19.861  -3.334   6.962  1.00  0.00           H  
ATOM    513  HB3 ARG A  34     -20.203  -4.718   7.992  1.00  0.00           H  
ATOM    514  HG2 ARG A  34     -21.494  -3.124   9.469  1.00  0.00           H  
ATOM    515  HG3 ARG A  34     -21.353  -1.954   8.155  1.00  0.00           H  
ATOM    516  HD2 ARG A  34     -22.587  -4.691   7.961  1.00  0.00           H  
ATOM    517  HD3 ARG A  34     -23.473  -3.173   8.070  1.00  0.00           H  
ATOM    518  HE  ARG A  34     -21.663  -3.749   5.813  1.00  0.00           H  
ATOM    519 HH11 ARG A  34     -24.821  -2.827   7.061  1.00  0.00           H  
ATOM    520 HH12 ARG A  34     -25.487  -2.537   5.476  1.00  0.00           H  
ATOM    521 HH21 ARG A  34     -22.529  -3.383   3.775  1.00  0.00           H  
ATOM    522 HH22 ARG A  34     -24.186  -2.875   3.604  1.00  0.00           H  
ATOM    523  N   LYS A  35     -17.663  -5.193   8.032  1.00  0.00           N  
ATOM    524  CA  LYS A  35     -16.498  -5.892   7.506  1.00  0.00           C  
ATOM    525  C   LYS A  35     -16.795  -6.487   6.134  1.00  0.00           C  
ATOM    526  O   LYS A  35     -17.956  -6.690   5.770  1.00  0.00           O  
ATOM    527  CB  LYS A  35     -16.057  -6.991   8.472  1.00  0.00           C  
ATOM    528  CG  LYS A  35     -15.670  -6.474   9.849  1.00  0.00           C  
ATOM    529  CD  LYS A  35     -15.344  -7.605  10.818  1.00  0.00           C  
ATOM    530  CE  LYS A  35     -16.594  -8.309  11.340  1.00  0.00           C  
ATOM    531  NZ  LYS A  35     -17.341  -9.034  10.277  1.00  0.00           N  
ATOM    532  H   LYS A  35     -18.498  -5.694   8.171  1.00  0.00           H  
ATOM    533  HA  LYS A  35     -15.700  -5.173   7.408  1.00  0.00           H  
ATOM    534  HB2 LYS A  35     -16.868  -7.695   8.590  1.00  0.00           H  
ATOM    535  HB3 LYS A  35     -15.205  -7.504   8.051  1.00  0.00           H  
ATOM    536  HG2 LYS A  35     -14.802  -5.840   9.752  1.00  0.00           H  
ATOM    537  HG3 LYS A  35     -16.492  -5.898  10.248  1.00  0.00           H  
ATOM    538  HD2 LYS A  35     -14.725  -8.329  10.312  1.00  0.00           H  
ATOM    539  HD3 LYS A  35     -14.800  -7.195  11.658  1.00  0.00           H  
ATOM    540  HE2 LYS A  35     -16.297  -9.019  12.098  1.00  0.00           H  
ATOM    541  HE3 LYS A  35     -17.245  -7.570  11.785  1.00  0.00           H  
ATOM    542  HZ1 LYS A  35     -16.680  -9.586   9.686  1.00  0.00           H  
ATOM    543  HZ2 LYS A  35     -17.859  -8.357   9.669  1.00  0.00           H  
ATOM    544  HZ3 LYS A  35     -18.029  -9.686  10.707  1.00  0.00           H  
ATOM    545  N   GLY A  36     -15.741  -6.763   5.378  1.00  0.00           N  
ATOM    546  CA  GLY A  36     -15.897  -7.314   4.050  1.00  0.00           C  
ATOM    547  C   GLY A  36     -14.681  -8.112   3.615  1.00  0.00           C  
ATOM    548  O   GLY A  36     -13.719  -8.255   4.375  1.00  0.00           O  
ATOM    549  H   GLY A  36     -14.838  -6.591   5.729  1.00  0.00           H  
ATOM    550  HA2 GLY A  36     -16.764  -7.960   4.038  1.00  0.00           H  
ATOM    551  HA3 GLY A  36     -16.052  -6.506   3.351  1.00  0.00           H  
ATOM    552  N   LYS A  37     -14.725  -8.638   2.402  1.00  0.00           N  
ATOM    553  CA  LYS A  37     -13.629  -9.443   1.868  1.00  0.00           C  
ATOM    554  C   LYS A  37     -13.228  -8.933   0.484  1.00  0.00           C  
ATOM    555  O   LYS A  37     -14.075  -8.816  -0.406  1.00  0.00           O  
ATOM    556  CB  LYS A  37     -14.070 -10.909   1.775  1.00  0.00           C  
ATOM    557  CG  LYS A  37     -12.933 -11.907   1.639  1.00  0.00           C  
ATOM    558  CD  LYS A  37     -12.144 -12.028   2.931  1.00  0.00           C  
ATOM    559  CE  LYS A  37     -11.856 -13.485   3.275  1.00  0.00           C  
ATOM    560  NZ  LYS A  37     -10.992 -14.147   2.264  1.00  0.00           N  
ATOM    561  H   LYS A  37     -15.527  -8.493   1.848  1.00  0.00           H  
ATOM    562  HA  LYS A  37     -12.786  -9.363   2.539  1.00  0.00           H  
ATOM    563  HB2 LYS A  37     -14.626 -11.158   2.664  1.00  0.00           H  
ATOM    564  HB3 LYS A  37     -14.717 -11.021   0.917  1.00  0.00           H  
ATOM    565  HG2 LYS A  37     -13.342 -12.874   1.387  1.00  0.00           H  
ATOM    566  HG3 LYS A  37     -12.268 -11.579   0.852  1.00  0.00           H  
ATOM    567  HD2 LYS A  37     -11.207 -11.502   2.822  1.00  0.00           H  
ATOM    568  HD3 LYS A  37     -12.716 -11.585   3.734  1.00  0.00           H  
ATOM    569  HE2 LYS A  37     -11.362 -13.523   4.234  1.00  0.00           H  
ATOM    570  HE3 LYS A  37     -12.795 -14.015   3.334  1.00  0.00           H  
ATOM    571  HZ1 LYS A  37     -11.446 -14.125   1.324  1.00  0.00           H  
ATOM    572  HZ2 LYS A  37     -10.825 -15.143   2.531  1.00  0.00           H  
ATOM    573  HZ3 LYS A  37     -10.072 -13.663   2.205  1.00  0.00           H  
ATOM    574  N   ILE A  38     -11.947  -8.620   0.311  1.00  0.00           N  
ATOM    575  CA  ILE A  38     -11.439  -8.174  -0.983  1.00  0.00           C  
ATOM    576  C   ILE A  38     -11.351  -9.358  -1.936  1.00  0.00           C  
ATOM    577  O   ILE A  38     -10.545 -10.265  -1.733  1.00  0.00           O  
ATOM    578  CB  ILE A  38     -10.048  -7.515  -0.856  1.00  0.00           C  
ATOM    579  CG1 ILE A  38     -10.111  -6.323   0.102  1.00  0.00           C  
ATOM    580  CG2 ILE A  38      -9.538  -7.074  -2.223  1.00  0.00           C  
ATOM    581  CD1 ILE A  38      -8.773  -5.653   0.328  1.00  0.00           C  
ATOM    582  H   ILE A  38     -11.325  -8.700   1.070  1.00  0.00           H  
ATOM    583  HA  ILE A  38     -12.131  -7.449  -1.385  1.00  0.00           H  
ATOM    584  HB  ILE A  38      -9.361  -8.247  -0.463  1.00  0.00           H  
ATOM    585 HG12 ILE A  38     -10.787  -5.583  -0.301  1.00  0.00           H  
ATOM    586 HG13 ILE A  38     -10.482  -6.659   1.057  1.00  0.00           H  
ATOM    587 HG21 ILE A  38      -9.450  -7.936  -2.869  1.00  0.00           H  
ATOM    588 HG22 ILE A  38      -8.570  -6.606  -2.113  1.00  0.00           H  
ATOM    589 HG23 ILE A  38     -10.231  -6.369  -2.656  1.00  0.00           H  
ATOM    590 HD11 ILE A  38      -8.389  -5.288  -0.614  1.00  0.00           H  
ATOM    591 HD12 ILE A  38      -8.079  -6.368   0.746  1.00  0.00           H  
ATOM    592 HD13 ILE A  38      -8.894  -4.826   1.012  1.00  0.00           H  
ATOM    593  N   ILE A  39     -12.180  -9.352  -2.967  1.00  0.00           N  
ATOM    594  CA  ILE A  39     -12.273 -10.499  -3.863  1.00  0.00           C  
ATOM    595  C   ILE A  39     -11.699 -10.201  -5.246  1.00  0.00           C  
ATOM    596  O   ILE A  39     -11.286 -11.113  -5.959  1.00  0.00           O  
ATOM    597  CB  ILE A  39     -13.732 -10.984  -4.007  1.00  0.00           C  
ATOM    598  CG1 ILE A  39     -14.641  -9.838  -4.466  1.00  0.00           C  
ATOM    599  CG2 ILE A  39     -14.224 -11.566  -2.687  1.00  0.00           C  
ATOM    600  CD1 ILE A  39     -16.078 -10.252  -4.693  1.00  0.00           C  
ATOM    601  H   ILE A  39     -12.742  -8.559  -3.133  1.00  0.00           H  
ATOM    602  HA  ILE A  39     -11.700 -11.303  -3.420  1.00  0.00           H  
ATOM    603  HB  ILE A  39     -13.753 -11.770  -4.748  1.00  0.00           H  
ATOM    604 HG12 ILE A  39     -14.638  -9.062  -3.714  1.00  0.00           H  
ATOM    605 HG13 ILE A  39     -14.260  -9.434  -5.392  1.00  0.00           H  
ATOM    606 HG21 ILE A  39     -15.251 -11.881  -2.794  1.00  0.00           H  
ATOM    607 HG22 ILE A  39     -14.155 -10.814  -1.915  1.00  0.00           H  
ATOM    608 HG23 ILE A  39     -13.614 -12.415  -2.418  1.00  0.00           H  
ATOM    609 HD11 ILE A  39     -16.499 -10.613  -3.767  1.00  0.00           H  
ATOM    610 HD12 ILE A  39     -16.114 -11.036  -5.437  1.00  0.00           H  
ATOM    611 HD13 ILE A  39     -16.647  -9.402  -5.040  1.00  0.00           H  
ATOM    612  N   GLU A  40     -11.667  -8.928  -5.615  1.00  0.00           N  
ATOM    613  CA  GLU A  40     -11.150  -8.519  -6.919  1.00  0.00           C  
ATOM    614  C   GLU A  40     -10.276  -7.279  -6.792  1.00  0.00           C  
ATOM    615  O   GLU A  40     -10.365  -6.540  -5.807  1.00  0.00           O  
ATOM    616  CB  GLU A  40     -12.297  -8.230  -7.897  1.00  0.00           C  
ATOM    617  CG  GLU A  40     -13.004  -9.470  -8.425  1.00  0.00           C  
ATOM    618  CD  GLU A  40     -12.142 -10.270  -9.379  1.00  0.00           C  
ATOM    619  OE1 GLU A  40     -11.827  -9.760 -10.474  1.00  0.00           O  
ATOM    620  OE2 GLU A  40     -11.789 -11.416  -9.050  1.00  0.00           O  
ATOM    621  H   GLU A  40     -11.991  -8.243  -4.994  1.00  0.00           H  
ATOM    622  HA  GLU A  40     -10.553  -9.329  -7.308  1.00  0.00           H  
ATOM    623  HB2 GLU A  40     -13.029  -7.615  -7.402  1.00  0.00           H  
ATOM    624  HB3 GLU A  40     -11.900  -7.686  -8.743  1.00  0.00           H  
ATOM    625  HG2 GLU A  40     -13.270 -10.102  -7.589  1.00  0.00           H  
ATOM    626  HG3 GLU A  40     -13.901  -9.164  -8.943  1.00  0.00           H  
ATOM    627  N   HIS A  41      -9.432  -7.064  -7.789  1.00  0.00           N  
ATOM    628  CA  HIS A  41      -8.605  -5.870  -7.865  1.00  0.00           C  
ATOM    629  C   HIS A  41      -9.098  -4.971  -8.987  1.00  0.00           C  
ATOM    630  O   HIS A  41      -9.400  -5.445 -10.085  1.00  0.00           O  
ATOM    631  CB  HIS A  41      -7.134  -6.231  -8.102  1.00  0.00           C  
ATOM    632  CG  HIS A  41      -6.386  -6.605  -6.861  1.00  0.00           C  
ATOM    633  ND1 HIS A  41      -5.292  -7.439  -6.864  1.00  0.00           N  
ATOM    634  CD2 HIS A  41      -6.557  -6.221  -5.575  1.00  0.00           C  
ATOM    635  CE1 HIS A  41      -4.822  -7.551  -5.637  1.00  0.00           C  
ATOM    636  NE2 HIS A  41      -5.570  -6.820  -4.832  1.00  0.00           N  
ATOM    637  H   HIS A  41      -9.371  -7.728  -8.517  1.00  0.00           H  
ATOM    638  HA  HIS A  41      -8.693  -5.340  -6.927  1.00  0.00           H  
ATOM    639  HB2 HIS A  41      -7.083  -7.068  -8.781  1.00  0.00           H  
ATOM    640  HB3 HIS A  41      -6.633  -5.383  -8.550  1.00  0.00           H  
ATOM    641  HD1 HIS A  41      -4.909  -7.889  -7.660  1.00  0.00           H  
ATOM    642  HD2 HIS A  41      -7.327  -5.560  -5.203  1.00  0.00           H  
ATOM    643  HE1 HIS A  41      -3.965  -8.139  -5.342  1.00  0.00           H  
ATOM    644  HE2 HIS A  41      -5.299  -6.538  -3.925  1.00  0.00           H  
ATOM    645  N   LEU A  42      -9.193  -3.686  -8.703  1.00  0.00           N  
ATOM    646  CA  LEU A  42      -9.630  -2.710  -9.687  1.00  0.00           C  
ATOM    647  C   LEU A  42      -8.528  -1.700  -9.936  1.00  0.00           C  
ATOM    648  O   LEU A  42      -7.710  -1.439  -9.056  1.00  0.00           O  
ATOM    649  CB  LEU A  42     -10.882  -1.973  -9.195  1.00  0.00           C  
ATOM    650  CG  LEU A  42     -12.138  -2.829  -9.029  1.00  0.00           C  
ATOM    651  CD1 LEU A  42     -13.240  -2.019  -8.361  1.00  0.00           C  
ATOM    652  CD2 LEU A  42     -12.604  -3.347 -10.378  1.00  0.00           C  
ATOM    653  H   LEU A  42      -8.952  -3.373  -7.801  1.00  0.00           H  
ATOM    654  HA  LEU A  42      -9.855  -3.227 -10.609  1.00  0.00           H  
ATOM    655  HB2 LEU A  42     -10.654  -1.523  -8.240  1.00  0.00           H  
ATOM    656  HB3 LEU A  42     -11.105  -1.184  -9.898  1.00  0.00           H  
ATOM    657  HG  LEU A  42     -11.913  -3.677  -8.399  1.00  0.00           H  
ATOM    658 HD11 LEU A  42     -13.496  -1.174  -8.985  1.00  0.00           H  
ATOM    659 HD12 LEU A  42     -12.893  -1.663  -7.402  1.00  0.00           H  
ATOM    660 HD13 LEU A  42     -14.113  -2.639  -8.223  1.00  0.00           H  
ATOM    661 HD21 LEU A  42     -12.843  -2.511 -11.018  1.00  0.00           H  
ATOM    662 HD22 LEU A  42     -13.480  -3.964 -10.246  1.00  0.00           H  
ATOM    663 HD23 LEU A  42     -11.815  -3.930 -10.831  1.00  0.00           H  
ATOM    664  N   HIS A  43      -8.493  -1.143 -11.135  1.00  0.00           N  
ATOM    665  CA  HIS A  43      -7.618  -0.020 -11.404  1.00  0.00           C  
ATOM    666  C   HIS A  43      -8.473   1.218 -11.648  1.00  0.00           C  
ATOM    667  O   HIS A  43      -9.090   1.383 -12.702  1.00  0.00           O  
ATOM    668  CB  HIS A  43      -6.632  -0.294 -12.563  1.00  0.00           C  
ATOM    669  CG  HIS A  43      -7.242  -0.425 -13.927  1.00  0.00           C  
ATOM    670  ND1 HIS A  43      -7.310   0.625 -14.818  1.00  0.00           N  
ATOM    671  CD2 HIS A  43      -7.786  -1.489 -14.563  1.00  0.00           C  
ATOM    672  CE1 HIS A  43      -7.871   0.216 -15.938  1.00  0.00           C  
ATOM    673  NE2 HIS A  43      -8.169  -1.061 -15.811  1.00  0.00           N  
ATOM    674  H   HIS A  43      -9.085  -1.484 -11.846  1.00  0.00           H  
ATOM    675  HA  HIS A  43      -7.046   0.151 -10.503  1.00  0.00           H  
ATOM    676  HB2 HIS A  43      -5.921   0.516 -12.607  1.00  0.00           H  
ATOM    677  HB3 HIS A  43      -6.099  -1.211 -12.351  1.00  0.00           H  
ATOM    678  HD1 HIS A  43      -6.995   1.549 -14.647  1.00  0.00           H  
ATOM    679  HD2 HIS A  43      -7.895  -2.488 -14.164  1.00  0.00           H  
ATOM    680  HE1 HIS A  43      -8.050   0.823 -16.813  1.00  0.00           H  
ATOM    681  HE2 HIS A  43      -8.699  -1.585 -16.457  1.00  0.00           H  
ATOM    682  N   SER A  44      -8.548   2.049 -10.629  1.00  0.00           N  
ATOM    683  CA  SER A  44      -9.390   3.227 -10.639  1.00  0.00           C  
ATOM    684  C   SER A  44      -8.965   4.144  -9.498  1.00  0.00           C  
ATOM    685  O   SER A  44      -8.726   3.688  -8.384  1.00  0.00           O  
ATOM    686  CB  SER A  44     -10.866   2.817 -10.491  1.00  0.00           C  
ATOM    687  OG  SER A  44     -11.741   3.931 -10.610  1.00  0.00           O  
ATOM    688  H   SER A  44      -8.005   1.865  -9.824  1.00  0.00           H  
ATOM    689  HA  SER A  44      -9.249   3.738 -11.580  1.00  0.00           H  
ATOM    690  HB2 SER A  44     -11.112   2.103 -11.262  1.00  0.00           H  
ATOM    691  HB3 SER A  44     -11.014   2.358  -9.524  1.00  0.00           H  
ATOM    692  HG  SER A  44     -12.082   4.173  -9.738  1.00  0.00           H  
ATOM    693  N   ALA A  45      -8.900   5.434  -9.772  1.00  0.00           N  
ATOM    694  CA  ALA A  45      -8.397   6.396  -8.799  1.00  0.00           C  
ATOM    695  C   ALA A  45      -9.427   6.622  -7.706  1.00  0.00           C  
ATOM    696  O   ALA A  45      -9.147   7.222  -6.668  1.00  0.00           O  
ATOM    697  CB  ALA A  45      -8.042   7.707  -9.486  1.00  0.00           C  
ATOM    698  H   ALA A  45      -9.235   5.754 -10.638  1.00  0.00           H  
ATOM    699  HA  ALA A  45      -7.499   5.988  -8.359  1.00  0.00           H  
ATOM    700  HB1 ALA A  45      -7.334   7.517 -10.280  1.00  0.00           H  
ATOM    701  HB2 ALA A  45      -7.604   8.382  -8.766  1.00  0.00           H  
ATOM    702  HB3 ALA A  45      -8.936   8.149  -9.899  1.00  0.00           H  
ATOM    703  N   THR A  46     -10.631   6.145  -7.962  1.00  0.00           N  
ATOM    704  CA  THR A  46     -11.705   6.225  -7.004  1.00  0.00           C  
ATOM    705  C   THR A  46     -11.755   4.973  -6.133  1.00  0.00           C  
ATOM    706  O   THR A  46     -12.022   5.057  -4.933  1.00  0.00           O  
ATOM    707  CB  THR A  46     -13.049   6.406  -7.727  1.00  0.00           C  
ATOM    708  OG1 THR A  46     -13.145   5.457  -8.801  1.00  0.00           O  
ATOM    709  CG2 THR A  46     -13.184   7.818  -8.277  1.00  0.00           C  
ATOM    710  H   THR A  46     -10.803   5.734  -8.833  1.00  0.00           H  
ATOM    711  HA  THR A  46     -11.536   7.088  -6.376  1.00  0.00           H  
ATOM    712  HB  THR A  46     -13.851   6.229  -7.024  1.00  0.00           H  
ATOM    713  HG1 THR A  46     -13.916   5.674  -9.351  1.00  0.00           H  
ATOM    714 HG21 THR A  46     -13.136   8.529  -7.464  1.00  0.00           H  
ATOM    715 HG22 THR A  46     -14.130   7.918  -8.786  1.00  0.00           H  
ATOM    716 HG23 THR A  46     -12.379   8.012  -8.970  1.00  0.00           H  
ATOM    717  N   TYR A  47     -11.470   3.817  -6.738  1.00  0.00           N  
ATOM    718  CA  TYR A  47     -11.611   2.529  -6.056  1.00  0.00           C  
ATOM    719  C   TYR A  47     -10.539   1.553  -6.528  1.00  0.00           C  
ATOM    720  O   TYR A  47     -10.367   1.348  -7.729  1.00  0.00           O  
ATOM    721  CB  TYR A  47     -12.994   1.918  -6.323  1.00  0.00           C  
ATOM    722  CG  TYR A  47     -14.153   2.821  -5.957  1.00  0.00           C  
ATOM    723  CD1 TYR A  47     -14.455   3.091  -4.628  1.00  0.00           C  
ATOM    724  CD2 TYR A  47     -14.935   3.413  -6.940  1.00  0.00           C  
ATOM    725  CE1 TYR A  47     -15.505   3.922  -4.290  1.00  0.00           C  
ATOM    726  CE2 TYR A  47     -15.985   4.247  -6.610  1.00  0.00           C  
ATOM    727  CZ  TYR A  47     -16.265   4.498  -5.284  1.00  0.00           C  
ATOM    728  OH  TYR A  47     -17.310   5.328  -4.953  1.00  0.00           O  
ATOM    729  H   TYR A  47     -11.122   3.833  -7.659  1.00  0.00           H  
ATOM    730  HA  TYR A  47     -11.494   2.694  -4.995  1.00  0.00           H  
ATOM    731  HB2 TYR A  47     -13.077   1.688  -7.375  1.00  0.00           H  
ATOM    732  HB3 TYR A  47     -13.091   1.005  -5.754  1.00  0.00           H  
ATOM    733  HD1 TYR A  47     -13.855   2.639  -3.851  1.00  0.00           H  
ATOM    734  HD2 TYR A  47     -14.715   3.213  -7.980  1.00  0.00           H  
ATOM    735  HE1 TYR A  47     -15.723   4.119  -3.251  1.00  0.00           H  
ATOM    736  HE2 TYR A  47     -16.582   4.697  -7.389  1.00  0.00           H  
ATOM    737  HH  TYR A  47     -17.105   5.792  -4.134  1.00  0.00           H  
ATOM    738  N   ASP A  48      -9.842   0.937  -5.581  1.00  0.00           N  
ATOM    739  CA  ASP A  48      -8.741   0.034  -5.909  1.00  0.00           C  
ATOM    740  C   ASP A  48      -9.170  -1.421  -5.777  1.00  0.00           C  
ATOM    741  O   ASP A  48      -8.581  -2.311  -6.397  1.00  0.00           O  
ATOM    742  CB  ASP A  48      -7.539   0.265  -4.987  1.00  0.00           C  
ATOM    743  CG  ASP A  48      -7.134   1.718  -4.874  1.00  0.00           C  
ATOM    744  OD1 ASP A  48      -6.631   2.288  -5.865  1.00  0.00           O  
ATOM    745  OD2 ASP A  48      -7.294   2.287  -3.778  1.00  0.00           O  
ATOM    746  H   ASP A  48     -10.073   1.090  -4.641  1.00  0.00           H  
ATOM    747  HA  ASP A  48      -8.446   0.221  -6.930  1.00  0.00           H  
ATOM    748  HB2 ASP A  48      -7.781  -0.094  -3.999  1.00  0.00           H  
ATOM    749  HB3 ASP A  48      -6.696  -0.296  -5.366  1.00  0.00           H  
ATOM    750  N   TYR A  49     -10.185  -1.677  -4.959  1.00  0.00           N  
ATOM    751  CA  TYR A  49     -10.572  -3.050  -4.652  1.00  0.00           C  
ATOM    752  C   TYR A  49     -12.081  -3.241  -4.742  1.00  0.00           C  
ATOM    753  O   TYR A  49     -12.851  -2.284  -4.646  1.00  0.00           O  
ATOM    754  CB  TYR A  49     -10.113  -3.438  -3.241  1.00  0.00           C  
ATOM    755  CG  TYR A  49      -8.676  -3.086  -2.927  1.00  0.00           C  
ATOM    756  CD1 TYR A  49      -7.625  -3.679  -3.614  1.00  0.00           C  
ATOM    757  CD2 TYR A  49      -8.376  -2.163  -1.935  1.00  0.00           C  
ATOM    758  CE1 TYR A  49      -6.313  -3.360  -3.321  1.00  0.00           C  
ATOM    759  CE2 TYR A  49      -7.068  -1.840  -1.639  1.00  0.00           C  
ATOM    760  CZ  TYR A  49      -6.041  -2.439  -2.335  1.00  0.00           C  
ATOM    761  OH  TYR A  49      -4.735  -2.128  -2.030  1.00  0.00           O  
ATOM    762  H   TYR A  49     -10.692  -0.931  -4.565  1.00  0.00           H  
ATOM    763  HA  TYR A  49     -10.091  -3.698  -5.367  1.00  0.00           H  
ATOM    764  HB2 TYR A  49     -10.738  -2.935  -2.519  1.00  0.00           H  
ATOM    765  HB3 TYR A  49     -10.225  -4.505  -3.122  1.00  0.00           H  
ATOM    766  HD1 TYR A  49      -7.842  -4.398  -4.389  1.00  0.00           H  
ATOM    767  HD2 TYR A  49      -9.182  -1.693  -1.390  1.00  0.00           H  
ATOM    768  HE1 TYR A  49      -5.509  -3.831  -3.865  1.00  0.00           H  
ATOM    769  HE2 TYR A  49      -6.854  -1.116  -0.867  1.00  0.00           H  
ATOM    770  HH  TYR A  49      -4.453  -1.359  -2.549  1.00  0.00           H  
ATOM    771  N   ALA A  50     -12.489  -4.487  -4.920  1.00  0.00           N  
ATOM    772  CA  ALA A  50     -13.892  -4.851  -4.852  1.00  0.00           C  
ATOM    773  C   ALA A  50     -14.122  -5.683  -3.602  1.00  0.00           C  
ATOM    774  O   ALA A  50     -13.601  -6.798  -3.482  1.00  0.00           O  
ATOM    775  CB  ALA A  50     -14.317  -5.619  -6.093  1.00  0.00           C  
ATOM    776  H   ALA A  50     -11.824  -5.189  -5.090  1.00  0.00           H  
ATOM    777  HA  ALA A  50     -14.478  -3.945  -4.787  1.00  0.00           H  
ATOM    778  HB1 ALA A  50     -15.382  -5.796  -6.058  1.00  0.00           H  
ATOM    779  HB2 ALA A  50     -13.798  -6.563  -6.123  1.00  0.00           H  
ATOM    780  HB3 ALA A  50     -14.075  -5.045  -6.974  1.00  0.00           H  
ATOM    781  N   VAL A  51     -14.882  -5.137  -2.673  1.00  0.00           N  
ATOM    782  CA  VAL A  51     -15.058  -5.754  -1.373  1.00  0.00           C  
ATOM    783  C   VAL A  51     -16.465  -6.303  -1.214  1.00  0.00           C  
ATOM    784  O   VAL A  51     -17.451  -5.590  -1.403  1.00  0.00           O  
ATOM    785  CB  VAL A  51     -14.764  -4.748  -0.240  1.00  0.00           C  
ATOM    786  CG1 VAL A  51     -14.956  -5.386   1.127  1.00  0.00           C  
ATOM    787  CG2 VAL A  51     -13.355  -4.201  -0.374  1.00  0.00           C  
ATOM    788  H   VAL A  51     -15.360  -4.299  -2.871  1.00  0.00           H  
ATOM    789  HA  VAL A  51     -14.354  -6.570  -1.294  1.00  0.00           H  
ATOM    790  HB  VAL A  51     -15.455  -3.923  -0.327  1.00  0.00           H  
ATOM    791 HG11 VAL A  51     -14.718  -4.668   1.897  1.00  0.00           H  
ATOM    792 HG12 VAL A  51     -14.307  -6.244   1.221  1.00  0.00           H  
ATOM    793 HG13 VAL A  51     -15.984  -5.699   1.232  1.00  0.00           H  
ATOM    794 HG21 VAL A  51     -13.167  -3.493   0.419  1.00  0.00           H  
ATOM    795 HG22 VAL A  51     -13.251  -3.711  -1.330  1.00  0.00           H  
ATOM    796 HG23 VAL A  51     -12.646  -5.013  -0.306  1.00  0.00           H  
ATOM    797  N   SER A  52     -16.550  -7.575  -0.881  1.00  0.00           N  
ATOM    798  CA  SER A  52     -17.826  -8.201  -0.612  1.00  0.00           C  
ATOM    799  C   SER A  52     -18.189  -8.009   0.855  1.00  0.00           C  
ATOM    800  O   SER A  52     -17.536  -8.558   1.743  1.00  0.00           O  
ATOM    801  CB  SER A  52     -17.770  -9.686  -0.980  1.00  0.00           C  
ATOM    802  OG  SER A  52     -16.603 -10.301  -0.455  1.00  0.00           O  
ATOM    803  H   SER A  52     -15.728  -8.107  -0.800  1.00  0.00           H  
ATOM    804  HA  SER A  52     -18.571  -7.714  -1.224  1.00  0.00           H  
ATOM    805  HB2 SER A  52     -18.638 -10.188  -0.579  1.00  0.00           H  
ATOM    806  HB3 SER A  52     -17.762  -9.788  -2.054  1.00  0.00           H  
ATOM    807  HG  SER A  52     -15.822  -9.917  -0.870  1.00  0.00           H  
ATOM    808  N   ASP A  53     -19.197  -7.182   1.100  1.00  0.00           N  
ATOM    809  CA  ASP A  53     -19.650  -6.896   2.457  1.00  0.00           C  
ATOM    810  C   ASP A  53     -20.210  -8.162   3.096  1.00  0.00           C  
ATOM    811  O   ASP A  53     -20.737  -9.033   2.399  1.00  0.00           O  
ATOM    812  CB  ASP A  53     -20.721  -5.795   2.421  1.00  0.00           C  
ATOM    813  CG  ASP A  53     -21.146  -5.310   3.795  1.00  0.00           C  
ATOM    814  OD1 ASP A  53     -21.857  -6.052   4.501  1.00  0.00           O  
ATOM    815  OD2 ASP A  53     -20.804  -4.163   4.155  1.00  0.00           O  
ATOM    816  H   ASP A  53     -19.658  -6.753   0.343  1.00  0.00           H  
ATOM    817  HA  ASP A  53     -18.803  -6.554   3.030  1.00  0.00           H  
ATOM    818  HB2 ASP A  53     -20.334  -4.952   1.873  1.00  0.00           H  
ATOM    819  HB3 ASP A  53     -21.594  -6.176   1.911  1.00  0.00           H  
ATOM    820  N   GLU A  54     -20.098  -8.260   4.415  1.00  0.00           N  
ATOM    821  CA  GLU A  54     -20.554  -9.439   5.144  1.00  0.00           C  
ATOM    822  C   GLU A  54     -22.059  -9.682   4.966  1.00  0.00           C  
ATOM    823  O   GLU A  54     -22.539 -10.804   5.148  1.00  0.00           O  
ATOM    824  CB  GLU A  54     -20.200  -9.316   6.628  1.00  0.00           C  
ATOM    825  CG  GLU A  54     -20.659  -8.014   7.270  1.00  0.00           C  
ATOM    826  CD  GLU A  54     -20.297  -7.930   8.740  1.00  0.00           C  
ATOM    827  OE1 GLU A  54     -19.164  -7.519   9.059  1.00  0.00           O  
ATOM    828  OE2 GLU A  54     -21.150  -8.277   9.587  1.00  0.00           O  
ATOM    829  H   GLU A  54     -19.692  -7.515   4.916  1.00  0.00           H  
ATOM    830  HA  GLU A  54     -20.026 -10.290   4.737  1.00  0.00           H  
ATOM    831  HB2 GLU A  54     -20.658 -10.134   7.163  1.00  0.00           H  
ATOM    832  HB3 GLU A  54     -19.126  -9.385   6.737  1.00  0.00           H  
ATOM    833  HG2 GLU A  54     -20.191  -7.189   6.754  1.00  0.00           H  
ATOM    834  HG3 GLU A  54     -21.732  -7.938   7.173  1.00  0.00           H  
ATOM    835  N   THR A  55     -22.795  -8.638   4.598  1.00  0.00           N  
ATOM    836  CA  THR A  55     -24.227  -8.761   4.343  1.00  0.00           C  
ATOM    837  C   THR A  55     -24.498  -9.395   2.975  1.00  0.00           C  
ATOM    838  O   THR A  55     -25.636  -9.741   2.656  1.00  0.00           O  
ATOM    839  CB  THR A  55     -24.932  -7.391   4.422  1.00  0.00           C  
ATOM    840  OG1 THR A  55     -24.247  -6.430   3.608  1.00  0.00           O  
ATOM    841  CG2 THR A  55     -24.992  -6.893   5.862  1.00  0.00           C  
ATOM    842  H   THR A  55     -22.364  -7.755   4.506  1.00  0.00           H  
ATOM    843  HA  THR A  55     -24.645  -9.400   5.108  1.00  0.00           H  
ATOM    844  HB  THR A  55     -25.942  -7.502   4.056  1.00  0.00           H  
ATOM    845  HG1 THR A  55     -23.389  -6.213   4.018  1.00  0.00           H  
ATOM    846 HG21 THR A  55     -23.989  -6.819   6.259  1.00  0.00           H  
ATOM    847 HG22 THR A  55     -25.567  -7.586   6.459  1.00  0.00           H  
ATOM    848 HG23 THR A  55     -25.462  -5.920   5.886  1.00  0.00           H  
ATOM    849  N   GLY A  56     -23.448  -9.554   2.178  1.00  0.00           N  
ATOM    850  CA  GLY A  56     -23.590 -10.162   0.868  1.00  0.00           C  
ATOM    851  C   GLY A  56     -23.667  -9.136  -0.245  1.00  0.00           C  
ATOM    852  O   GLY A  56     -24.054  -9.454  -1.367  1.00  0.00           O  
ATOM    853  H   GLY A  56     -22.561  -9.261   2.487  1.00  0.00           H  
ATOM    854  HA2 GLY A  56     -22.743 -10.808   0.688  1.00  0.00           H  
ATOM    855  HA3 GLY A  56     -24.492 -10.757   0.855  1.00  0.00           H  
ATOM    856  N   ASP A  57     -23.301  -7.903   0.068  1.00  0.00           N  
ATOM    857  CA  ASP A  57     -23.345  -6.821  -0.910  1.00  0.00           C  
ATOM    858  C   ASP A  57     -21.941  -6.483  -1.403  1.00  0.00           C  
ATOM    859  O   ASP A  57     -21.084  -6.086  -0.622  1.00  0.00           O  
ATOM    860  CB  ASP A  57     -23.991  -5.584  -0.287  1.00  0.00           C  
ATOM    861  CG  ASP A  57     -24.035  -4.404  -1.235  1.00  0.00           C  
ATOM    862  OD1 ASP A  57     -24.862  -4.412  -2.171  1.00  0.00           O  
ATOM    863  OD2 ASP A  57     -23.250  -3.453  -1.044  1.00  0.00           O  
ATOM    864  H   ASP A  57     -22.995  -7.711   0.978  1.00  0.00           H  
ATOM    865  HA  ASP A  57     -23.943  -7.151  -1.745  1.00  0.00           H  
ATOM    866  HB2 ASP A  57     -25.003  -5.823   0.002  1.00  0.00           H  
ATOM    867  HB3 ASP A  57     -23.431  -5.297   0.590  1.00  0.00           H  
ATOM    868  N   ILE A  58     -21.705  -6.658  -2.693  1.00  0.00           N  
ATOM    869  CA  ILE A  58     -20.394  -6.360  -3.260  1.00  0.00           C  
ATOM    870  C   ILE A  58     -20.286  -4.875  -3.585  1.00  0.00           C  
ATOM    871  O   ILE A  58     -21.053  -4.346  -4.393  1.00  0.00           O  
ATOM    872  CB  ILE A  58     -20.116  -7.195  -4.527  1.00  0.00           C  
ATOM    873  CG1 ILE A  58     -20.208  -8.691  -4.202  1.00  0.00           C  
ATOM    874  CG2 ILE A  58     -18.744  -6.855  -5.102  1.00  0.00           C  
ATOM    875  CD1 ILE A  58     -19.976  -9.592  -5.398  1.00  0.00           C  
ATOM    876  H   ILE A  58     -22.419  -6.984  -3.279  1.00  0.00           H  
ATOM    877  HA  ILE A  58     -19.650  -6.609  -2.520  1.00  0.00           H  
ATOM    878  HB  ILE A  58     -20.861  -6.948  -5.266  1.00  0.00           H  
ATOM    879 HG12 ILE A  58     -19.467  -8.937  -3.456  1.00  0.00           H  
ATOM    880 HG13 ILE A  58     -21.191  -8.906  -3.809  1.00  0.00           H  
ATOM    881 HG21 ILE A  58     -18.709  -5.806  -5.353  1.00  0.00           H  
ATOM    882 HG22 ILE A  58     -18.572  -7.445  -5.991  1.00  0.00           H  
ATOM    883 HG23 ILE A  58     -17.982  -7.077  -4.371  1.00  0.00           H  
ATOM    884 HD11 ILE A  58     -18.994  -9.406  -5.800  1.00  0.00           H  
ATOM    885 HD12 ILE A  58     -20.720  -9.385  -6.152  1.00  0.00           H  
ATOM    886 HD13 ILE A  58     -20.051 -10.625  -5.092  1.00  0.00           H  
ATOM    887  N   THR A  59     -19.347  -4.203  -2.937  1.00  0.00           N  
ATOM    888  CA  THR A  59     -19.143  -2.780  -3.137  1.00  0.00           C  
ATOM    889  C   THR A  59     -17.698  -2.514  -3.550  1.00  0.00           C  
ATOM    890  O   THR A  59     -16.825  -3.362  -3.362  1.00  0.00           O  
ATOM    891  CB  THR A  59     -19.465  -1.996  -1.850  1.00  0.00           C  
ATOM    892  OG1 THR A  59     -20.632  -2.543  -1.234  1.00  0.00           O  
ATOM    893  CG2 THR A  59     -19.702  -0.520  -2.143  1.00  0.00           C  
ATOM    894  H   THR A  59     -18.759  -4.685  -2.307  1.00  0.00           H  
ATOM    895  HA  THR A  59     -19.807  -2.449  -3.923  1.00  0.00           H  
ATOM    896  HB  THR A  59     -18.629  -2.086  -1.171  1.00  0.00           H  
ATOM    897  HG1 THR A  59     -20.994  -3.241  -1.792  1.00  0.00           H  
ATOM    898 HG21 THR A  59     -20.535  -0.416  -2.823  1.00  0.00           H  
ATOM    899 HG22 THR A  59     -18.818  -0.095  -2.592  1.00  0.00           H  
ATOM    900 HG23 THR A  59     -19.923  -0.001  -1.222  1.00  0.00           H  
ATOM    901  N   TYR A  60     -17.441  -1.349  -4.114  1.00  0.00           N  
ATOM    902  CA  TYR A  60     -16.101  -1.003  -4.555  1.00  0.00           C  
ATOM    903  C   TYR A  60     -15.492  -0.015  -3.572  1.00  0.00           C  
ATOM    904  O   TYR A  60     -16.159   0.929  -3.154  1.00  0.00           O  
ATOM    905  CB  TYR A  60     -16.155  -0.409  -5.967  1.00  0.00           C  
ATOM    906  CG  TYR A  60     -17.182  -1.085  -6.847  1.00  0.00           C  
ATOM    907  CD1 TYR A  60     -17.067  -2.429  -7.178  1.00  0.00           C  
ATOM    908  CD2 TYR A  60     -18.281  -0.384  -7.322  1.00  0.00           C  
ATOM    909  CE1 TYR A  60     -18.022  -3.056  -7.955  1.00  0.00           C  
ATOM    910  CE2 TYR A  60     -19.235  -1.000  -8.105  1.00  0.00           C  
ATOM    911  CZ  TYR A  60     -19.105  -2.337  -8.416  1.00  0.00           C  
ATOM    912  OH  TYR A  60     -20.066  -2.959  -9.179  1.00  0.00           O  
ATOM    913  H   TYR A  60     -18.164  -0.697  -4.224  1.00  0.00           H  
ATOM    914  HA  TYR A  60     -15.509  -1.907  -4.567  1.00  0.00           H  
ATOM    915  HB2 TYR A  60     -16.408   0.639  -5.904  1.00  0.00           H  
ATOM    916  HB3 TYR A  60     -15.188  -0.518  -6.437  1.00  0.00           H  
ATOM    917  HD1 TYR A  60     -16.217  -2.989  -6.816  1.00  0.00           H  
ATOM    918  HD2 TYR A  60     -18.380   0.662  -7.078  1.00  0.00           H  
ATOM    919  HE1 TYR A  60     -17.916  -4.101  -8.203  1.00  0.00           H  
ATOM    920  HE2 TYR A  60     -20.084  -0.437  -8.465  1.00  0.00           H  
ATOM    921  HH  TYR A  60     -20.516  -3.631  -8.632  1.00  0.00           H  
ATOM    922  N   PHE A  61     -14.243  -0.237  -3.191  1.00  0.00           N  
ATOM    923  CA  PHE A  61     -13.595   0.598  -2.186  1.00  0.00           C  
ATOM    924  C   PHE A  61     -12.160   0.921  -2.576  1.00  0.00           C  
ATOM    925  O   PHE A  61     -11.573   0.273  -3.442  1.00  0.00           O  
ATOM    926  CB  PHE A  61     -13.613  -0.085  -0.815  1.00  0.00           C  
ATOM    927  CG  PHE A  61     -14.975  -0.162  -0.184  1.00  0.00           C  
ATOM    928  CD1 PHE A  61     -15.547   0.961   0.393  1.00  0.00           C  
ATOM    929  CD2 PHE A  61     -15.683  -1.352  -0.171  1.00  0.00           C  
ATOM    930  CE1 PHE A  61     -16.797   0.895   0.976  1.00  0.00           C  
ATOM    931  CE2 PHE A  61     -16.932  -1.425   0.411  1.00  0.00           C  
ATOM    932  CZ  PHE A  61     -17.491  -0.298   0.983  1.00  0.00           C  
ATOM    933  H   PHE A  61     -13.731  -0.971  -3.606  1.00  0.00           H  
ATOM    934  HA  PHE A  61     -14.152   1.522  -2.121  1.00  0.00           H  
ATOM    935  HB2 PHE A  61     -13.242  -1.093  -0.921  1.00  0.00           H  
ATOM    936  HB3 PHE A  61     -12.966   0.461  -0.143  1.00  0.00           H  
ATOM    937  HD1 PHE A  61     -15.003   1.893   0.387  1.00  0.00           H  
ATOM    938  HD2 PHE A  61     -15.245  -2.232  -0.619  1.00  0.00           H  
ATOM    939  HE1 PHE A  61     -17.232   1.778   1.421  1.00  0.00           H  
ATOM    940  HE2 PHE A  61     -17.473  -2.359   0.414  1.00  0.00           H  
ATOM    941  HZ  PHE A  61     -18.468  -0.353   1.439  1.00  0.00           H  
ATOM    942  N   LYS A  62     -11.605   1.924  -1.922  1.00  0.00           N  
ATOM    943  CA  LYS A  62     -10.241   2.357  -2.166  1.00  0.00           C  
ATOM    944  C   LYS A  62      -9.406   2.088  -0.916  1.00  0.00           C  
ATOM    945  O   LYS A  62      -9.967   1.895   0.164  1.00  0.00           O  
ATOM    946  CB  LYS A  62     -10.249   3.845  -2.548  1.00  0.00           C  
ATOM    947  CG  LYS A  62      -8.877   4.457  -2.778  1.00  0.00           C  
ATOM    948  CD  LYS A  62      -8.941   5.749  -3.588  1.00  0.00           C  
ATOM    949  CE  LYS A  62      -9.642   6.882  -2.851  1.00  0.00           C  
ATOM    950  NZ  LYS A  62     -11.113   6.677  -2.747  1.00  0.00           N  
ATOM    951  H   LYS A  62     -12.128   2.386  -1.236  1.00  0.00           H  
ATOM    952  HA  LYS A  62      -9.847   1.777  -2.989  1.00  0.00           H  
ATOM    953  HB2 LYS A  62     -10.820   3.965  -3.456  1.00  0.00           H  
ATOM    954  HB3 LYS A  62     -10.736   4.401  -1.759  1.00  0.00           H  
ATOM    955  HG2 LYS A  62      -8.428   4.672  -1.822  1.00  0.00           H  
ATOM    956  HG3 LYS A  62      -8.266   3.743  -3.309  1.00  0.00           H  
ATOM    957  HD2 LYS A  62      -7.933   6.062  -3.818  1.00  0.00           H  
ATOM    958  HD3 LYS A  62      -9.470   5.552  -4.509  1.00  0.00           H  
ATOM    959  HE2 LYS A  62      -9.229   6.953  -1.857  1.00  0.00           H  
ATOM    960  HE3 LYS A  62      -9.454   7.805  -3.381  1.00  0.00           H  
ATOM    961  HZ1 LYS A  62     -11.599   7.599  -2.687  1.00  0.00           H  
ATOM    962  HZ2 LYS A  62     -11.341   6.125  -1.887  1.00  0.00           H  
ATOM    963  HZ3 LYS A  62     -11.467   6.162  -3.580  1.00  0.00           H  
ATOM    964  N   GLU A  63      -8.081   2.060  -1.062  1.00  0.00           N  
ATOM    965  CA  GLU A  63      -7.173   1.736   0.047  1.00  0.00           C  
ATOM    966  C   GLU A  63      -7.429   2.615   1.277  1.00  0.00           C  
ATOM    967  O   GLU A  63      -7.236   2.183   2.410  1.00  0.00           O  
ATOM    968  CB  GLU A  63      -5.718   1.891  -0.401  1.00  0.00           C  
ATOM    969  CG  GLU A  63      -5.384   1.090  -1.648  1.00  0.00           C  
ATOM    970  CD  GLU A  63      -3.936   1.216  -2.072  1.00  0.00           C  
ATOM    971  OE1 GLU A  63      -3.489   2.348  -2.358  1.00  0.00           O  
ATOM    972  OE2 GLU A  63      -3.242   0.179  -2.141  1.00  0.00           O  
ATOM    973  H   GLU A  63      -7.694   2.251  -1.954  1.00  0.00           H  
ATOM    974  HA  GLU A  63      -7.345   0.705   0.320  1.00  0.00           H  
ATOM    975  HB2 GLU A  63      -5.524   2.934  -0.604  1.00  0.00           H  
ATOM    976  HB3 GLU A  63      -5.069   1.562   0.397  1.00  0.00           H  
ATOM    977  HG2 GLU A  63      -5.594   0.049  -1.458  1.00  0.00           H  
ATOM    978  HG3 GLU A  63      -6.009   1.438  -2.454  1.00  0.00           H  
ATOM    979  N   HIS A  64      -7.879   3.840   1.041  1.00  0.00           N  
ATOM    980  CA  HIS A  64      -8.132   4.792   2.119  1.00  0.00           C  
ATOM    981  C   HIS A  64      -9.421   4.453   2.880  1.00  0.00           C  
ATOM    982  O   HIS A  64      -9.598   4.853   4.032  1.00  0.00           O  
ATOM    983  CB  HIS A  64      -8.208   6.210   1.536  1.00  0.00           C  
ATOM    984  CG  HIS A  64      -8.532   7.281   2.534  1.00  0.00           C  
ATOM    985  ND1 HIS A  64      -9.811   7.738   2.745  1.00  0.00           N  
ATOM    986  CD2 HIS A  64      -7.739   7.991   3.371  1.00  0.00           C  
ATOM    987  CE1 HIS A  64      -9.796   8.682   3.665  1.00  0.00           C  
ATOM    988  NE2 HIS A  64      -8.550   8.857   4.061  1.00  0.00           N  
ATOM    989  H   HIS A  64      -8.042   4.113   0.115  1.00  0.00           H  
ATOM    990  HA  HIS A  64      -7.300   4.743   2.806  1.00  0.00           H  
ATOM    991  HB2 HIS A  64      -7.255   6.457   1.092  1.00  0.00           H  
ATOM    992  HB3 HIS A  64      -8.969   6.232   0.769  1.00  0.00           H  
ATOM    993  HD1 HIS A  64     -10.626   7.404   2.283  1.00  0.00           H  
ATOM    994  HD2 HIS A  64      -6.668   7.892   3.476  1.00  0.00           H  
ATOM    995  HE1 HIS A  64     -10.657   9.220   4.033  1.00  0.00           H  
ATOM    996  HE2 HIS A  64      -8.273   9.405   4.837  1.00  0.00           H  
ATOM    997  N   GLU A  65     -10.306   3.702   2.243  1.00  0.00           N  
ATOM    998  CA  GLU A  65     -11.612   3.401   2.820  1.00  0.00           C  
ATOM    999  C   GLU A  65     -11.615   2.062   3.556  1.00  0.00           C  
ATOM   1000  O   GLU A  65     -12.626   1.681   4.148  1.00  0.00           O  
ATOM   1001  CB  GLU A  65     -12.694   3.382   1.734  1.00  0.00           C  
ATOM   1002  CG  GLU A  65     -13.227   4.757   1.347  1.00  0.00           C  
ATOM   1003  CD  GLU A  65     -12.196   5.645   0.683  1.00  0.00           C  
ATOM   1004  OE1 GLU A  65     -11.952   5.477  -0.530  1.00  0.00           O  
ATOM   1005  OE2 GLU A  65     -11.645   6.534   1.365  1.00  0.00           O  
ATOM   1006  H   GLU A  65     -10.074   3.324   1.367  1.00  0.00           H  
ATOM   1007  HA  GLU A  65     -11.846   4.184   3.527  1.00  0.00           H  
ATOM   1008  HB2 GLU A  65     -12.284   2.921   0.847  1.00  0.00           H  
ATOM   1009  HB3 GLU A  65     -13.524   2.786   2.084  1.00  0.00           H  
ATOM   1010  HG2 GLU A  65     -14.054   4.626   0.666  1.00  0.00           H  
ATOM   1011  HG3 GLU A  65     -13.580   5.250   2.241  1.00  0.00           H  
ATOM   1012  N   LEU A  66     -10.493   1.355   3.534  1.00  0.00           N  
ATOM   1013  CA  LEU A  66     -10.444   0.018   4.114  1.00  0.00           C  
ATOM   1014  C   LEU A  66      -9.385  -0.098   5.200  1.00  0.00           C  
ATOM   1015  O   LEU A  66      -8.362   0.588   5.173  1.00  0.00           O  
ATOM   1016  CB  LEU A  66     -10.180  -1.021   3.025  1.00  0.00           C  
ATOM   1017  CG  LEU A  66     -11.278  -1.151   1.969  1.00  0.00           C  
ATOM   1018  CD1 LEU A  66     -10.890  -2.188   0.930  1.00  0.00           C  
ATOM   1019  CD2 LEU A  66     -12.604  -1.520   2.619  1.00  0.00           C  
ATOM   1020  H   LEU A  66      -9.685   1.737   3.132  1.00  0.00           H  
ATOM   1021  HA  LEU A  66     -11.409  -0.182   4.554  1.00  0.00           H  
ATOM   1022  HB2 LEU A  66      -9.258  -0.761   2.526  1.00  0.00           H  
ATOM   1023  HB3 LEU A  66     -10.053  -1.984   3.499  1.00  0.00           H  
ATOM   1024  HG  LEU A  66     -11.401  -0.202   1.466  1.00  0.00           H  
ATOM   1025 HD11 LEU A  66     -11.684  -2.282   0.205  1.00  0.00           H  
ATOM   1026 HD12 LEU A  66     -10.732  -3.139   1.415  1.00  0.00           H  
ATOM   1027 HD13 LEU A  66      -9.981  -1.880   0.433  1.00  0.00           H  
ATOM   1028 HD21 LEU A  66     -12.869  -0.768   3.348  1.00  0.00           H  
ATOM   1029 HD22 LEU A  66     -12.510  -2.479   3.108  1.00  0.00           H  
ATOM   1030 HD23 LEU A  66     -13.373  -1.574   1.863  1.00  0.00           H  
ATOM   1031  N   THR A  67      -9.652  -0.972   6.158  1.00  0.00           N  
ATOM   1032  CA  THR A  67      -8.709  -1.272   7.223  1.00  0.00           C  
ATOM   1033  C   THR A  67      -8.539  -2.788   7.345  1.00  0.00           C  
ATOM   1034  O   THR A  67      -9.515  -3.506   7.550  1.00  0.00           O  
ATOM   1035  CB  THR A  67      -9.201  -0.699   8.566  1.00  0.00           C  
ATOM   1036  OG1 THR A  67      -9.592   0.670   8.396  1.00  0.00           O  
ATOM   1037  CG2 THR A  67      -8.119  -0.787   9.634  1.00  0.00           C  
ATOM   1038  H   THR A  67     -10.525  -1.424   6.158  1.00  0.00           H  
ATOM   1039  HA  THR A  67      -7.758  -0.822   6.976  1.00  0.00           H  
ATOM   1040  HB  THR A  67     -10.057  -1.271   8.893  1.00  0.00           H  
ATOM   1041  HG1 THR A  67      -8.824   1.194   8.114  1.00  0.00           H  
ATOM   1042 HG21 THR A  67      -7.814  -1.815   9.755  1.00  0.00           H  
ATOM   1043 HG22 THR A  67      -8.507  -0.414  10.571  1.00  0.00           H  
ATOM   1044 HG23 THR A  67      -7.268  -0.193   9.335  1.00  0.00           H  
ATOM   1045  N   PRO A  68      -7.307  -3.298   7.195  1.00  0.00           N  
ATOM   1046  CA  PRO A  68      -7.041  -4.742   7.225  1.00  0.00           C  
ATOM   1047  C   PRO A  68      -7.385  -5.388   8.568  1.00  0.00           C  
ATOM   1048  O   PRO A  68      -7.201  -4.790   9.630  1.00  0.00           O  
ATOM   1049  CB  PRO A  68      -5.537  -4.843   6.950  1.00  0.00           C  
ATOM   1050  CG  PRO A  68      -4.985  -3.499   7.281  1.00  0.00           C  
ATOM   1051  CD  PRO A  68      -6.079  -2.515   6.979  1.00  0.00           C  
ATOM   1052  HA  PRO A  68      -7.583  -5.250   6.442  1.00  0.00           H  
ATOM   1053  HB2 PRO A  68      -5.106  -5.613   7.574  1.00  0.00           H  
ATOM   1054  HB3 PRO A  68      -5.377  -5.088   5.910  1.00  0.00           H  
ATOM   1055  HG2 PRO A  68      -4.723  -3.458   8.328  1.00  0.00           H  
ATOM   1056  HG3 PRO A  68      -4.118  -3.296   6.670  1.00  0.00           H  
ATOM   1057  HD2 PRO A  68      -6.030  -1.674   7.655  1.00  0.00           H  
ATOM   1058  HD3 PRO A  68      -6.012  -2.181   5.953  1.00  0.00           H  
ATOM   1059  N   LEU A  69      -7.904  -6.607   8.508  1.00  0.00           N  
ATOM   1060  CA  LEU A  69      -8.210  -7.367   9.709  1.00  0.00           C  
ATOM   1061  C   LEU A  69      -7.054  -8.297  10.051  1.00  0.00           C  
ATOM   1062  O   LEU A  69      -6.300  -8.715   9.169  1.00  0.00           O  
ATOM   1063  CB  LEU A  69      -9.493  -8.182   9.521  1.00  0.00           C  
ATOM   1064  CG  LEU A  69     -10.770  -7.360   9.330  1.00  0.00           C  
ATOM   1065  CD1 LEU A  69     -11.955  -8.276   9.074  1.00  0.00           C  
ATOM   1066  CD2 LEU A  69     -11.027  -6.485  10.549  1.00  0.00           C  
ATOM   1067  H   LEU A  69      -8.085  -7.011   7.628  1.00  0.00           H  
ATOM   1068  HA  LEU A  69      -8.350  -6.669  10.520  1.00  0.00           H  
ATOM   1069  HB2 LEU A  69      -9.367  -8.816   8.655  1.00  0.00           H  
ATOM   1070  HB3 LEU A  69      -9.624  -8.812  10.388  1.00  0.00           H  
ATOM   1071  HG  LEU A  69     -10.653  -6.716   8.471  1.00  0.00           H  
ATOM   1072 HD11 LEU A  69     -12.849  -7.682   8.953  1.00  0.00           H  
ATOM   1073 HD12 LEU A  69     -12.078  -8.949   9.910  1.00  0.00           H  
ATOM   1074 HD13 LEU A  69     -11.778  -8.848   8.174  1.00  0.00           H  
ATOM   1075 HD21 LEU A  69     -11.922  -5.900  10.392  1.00  0.00           H  
ATOM   1076 HD22 LEU A  69     -10.187  -5.824  10.701  1.00  0.00           H  
ATOM   1077 HD23 LEU A  69     -11.154  -7.111  11.420  1.00  0.00           H  
ATOM   1078  N   LYS A  70      -6.912  -8.616  11.329  1.00  0.00           N  
ATOM   1079  CA  LYS A  70      -5.831  -9.479  11.782  1.00  0.00           C  
ATOM   1080  C   LYS A  70      -6.387 -10.647  12.587  1.00  0.00           C  
ATOM   1081  O   LYS A  70      -7.387 -10.502  13.293  1.00  0.00           O  
ATOM   1082  CB  LYS A  70      -4.835  -8.679  12.623  1.00  0.00           C  
ATOM   1083  CG  LYS A  70      -4.219  -7.507  11.873  1.00  0.00           C  
ATOM   1084  CD  LYS A  70      -3.348  -6.662  12.780  1.00  0.00           C  
ATOM   1085  CE  LYS A  70      -2.786  -5.455  12.045  1.00  0.00           C  
ATOM   1086  NZ  LYS A  70      -2.001  -4.573  12.950  1.00  0.00           N  
ATOM   1087  H   LYS A  70      -7.553  -8.270  11.983  1.00  0.00           H  
ATOM   1088  HA  LYS A  70      -5.325  -9.866  10.910  1.00  0.00           H  
ATOM   1089  HB2 LYS A  70      -5.340  -8.297  13.497  1.00  0.00           H  
ATOM   1090  HB3 LYS A  70      -4.037  -9.336  12.935  1.00  0.00           H  
ATOM   1091  HG2 LYS A  70      -3.616  -7.888  11.063  1.00  0.00           H  
ATOM   1092  HG3 LYS A  70      -5.013  -6.892  11.475  1.00  0.00           H  
ATOM   1093  HD2 LYS A  70      -3.940  -6.321  13.616  1.00  0.00           H  
ATOM   1094  HD3 LYS A  70      -2.528  -7.266  13.140  1.00  0.00           H  
ATOM   1095  HE2 LYS A  70      -2.145  -5.801  11.248  1.00  0.00           H  
ATOM   1096  HE3 LYS A  70      -3.606  -4.889  11.626  1.00  0.00           H  
ATOM   1097  HZ1 LYS A  70      -1.722  -3.702  12.453  1.00  0.00           H  
ATOM   1098  HZ2 LYS A  70      -1.139  -5.067  13.272  1.00  0.00           H  
ATOM   1099  HZ3 LYS A  70      -2.570  -4.319  13.785  1.00  0.00           H  
ATOM   1100  N   GLY A  71      -5.733 -11.796  12.483  1.00  0.00           N  
ATOM   1101  CA  GLY A  71      -6.217 -12.991  13.144  1.00  0.00           C  
ATOM   1102  C   GLY A  71      -5.967 -12.964  14.635  1.00  0.00           C  
ATOM   1103  O   GLY A  71      -6.817 -13.386  15.426  1.00  0.00           O  
ATOM   1104  H   GLY A  71      -4.897 -11.829  11.961  1.00  0.00           H  
ATOM   1105  HA2 GLY A  71      -7.280 -13.080  12.966  1.00  0.00           H  
ATOM   1106  HA3 GLY A  71      -5.719 -13.850  12.724  1.00  0.00           H  
ATOM   1107  N   GLY A  72      -4.804 -12.460  15.022  1.00  0.00           N  
ATOM   1108  CA  GLY A  72      -4.470 -12.370  16.427  1.00  0.00           C  
ATOM   1109  C   GLY A  72      -3.004 -12.635  16.688  1.00  0.00           C  
ATOM   1110  O   GLY A  72      -2.157 -11.783  16.411  1.00  0.00           O  
ATOM   1111  H   GLY A  72      -4.167 -12.142  14.344  1.00  0.00           H  
ATOM   1112  HA2 GLY A  72      -4.715 -11.378  16.784  1.00  0.00           H  
ATOM   1113  HA3 GLY A  72      -5.059 -13.091  16.973  1.00  0.00           H  
ATOM   1114  N   LEU A  73      -2.712 -13.825  17.218  1.00  0.00           N  
ATOM   1115  CA  LEU A  73      -1.348 -14.218  17.571  1.00  0.00           C  
ATOM   1116  C   LEU A  73      -0.794 -13.320  18.674  1.00  0.00           C  
ATOM   1117  O   LEU A  73       0.420 -13.202  18.849  1.00  0.00           O  
ATOM   1118  CB  LEU A  73      -0.416 -14.191  16.348  1.00  0.00           C  
ATOM   1119  CG  LEU A  73      -0.590 -15.339  15.344  1.00  0.00           C  
ATOM   1120  CD1 LEU A  73      -1.879 -15.191  14.547  1.00  0.00           C  
ATOM   1121  CD2 LEU A  73       0.608 -15.410  14.411  1.00  0.00           C  
ATOM   1122  H   LEU A  73      -3.441 -14.459  17.379  1.00  0.00           H  
ATOM   1123  HA  LEU A  73      -1.392 -15.231  17.950  1.00  0.00           H  
ATOM   1124  HB2 LEU A  73      -0.578 -13.259  15.825  1.00  0.00           H  
ATOM   1125  HB3 LEU A  73       0.604 -14.207  16.702  1.00  0.00           H  
ATOM   1126  HG  LEU A  73      -0.643 -16.273  15.886  1.00  0.00           H  
ATOM   1127 HD11 LEU A  73      -1.966 -16.011  13.849  1.00  0.00           H  
ATOM   1128 HD12 LEU A  73      -1.861 -14.256  14.002  1.00  0.00           H  
ATOM   1129 HD13 LEU A  73      -2.722 -15.200  15.220  1.00  0.00           H  
ATOM   1130 HD21 LEU A  73       1.507 -15.563  14.991  1.00  0.00           H  
ATOM   1131 HD22 LEU A  73       0.691 -14.486  13.856  1.00  0.00           H  
ATOM   1132 HD23 LEU A  73       0.480 -16.233  13.722  1.00  0.00           H  
ATOM   1133  N   ALA A  74      -1.691 -12.717  19.442  1.00  0.00           N  
ATOM   1134  CA  ALA A  74      -1.306 -11.791  20.492  1.00  0.00           C  
ATOM   1135  C   ALA A  74      -1.477 -12.423  21.867  1.00  0.00           C  
ATOM   1136  O   ALA A  74      -1.054 -11.858  22.876  1.00  0.00           O  
ATOM   1137  CB  ALA A  74      -2.132 -10.519  20.391  1.00  0.00           C  
ATOM   1138  H   ALA A  74      -2.648 -12.904  19.298  1.00  0.00           H  
ATOM   1139  HA  ALA A  74      -0.267 -11.532  20.348  1.00  0.00           H  
ATOM   1140  HB1 ALA A  74      -2.001 -10.084  19.412  1.00  0.00           H  
ATOM   1141  HB2 ALA A  74      -1.808  -9.819  21.145  1.00  0.00           H  
ATOM   1142  HB3 ALA A  74      -3.176 -10.756  20.542  1.00  0.00           H  
ATOM   1143  N   TYR A  75      -2.115 -13.586  21.906  1.00  0.00           N  
ATOM   1144  CA  TYR A  75      -2.340 -14.294  23.161  1.00  0.00           C  
ATOM   1145  C   TYR A  75      -1.692 -15.678  23.116  1.00  0.00           C  
ATOM   1146  O   TYR A  75      -1.767 -16.451  24.073  1.00  0.00           O  
ATOM   1147  CB  TYR A  75      -3.849 -14.402  23.420  1.00  0.00           C  
ATOM   1148  CG  TYR A  75      -4.213 -14.931  24.793  1.00  0.00           C  
ATOM   1149  CD1 TYR A  75      -3.977 -14.179  25.936  1.00  0.00           C  
ATOM   1150  CD2 TYR A  75      -4.796 -16.182  24.942  1.00  0.00           C  
ATOM   1151  CE1 TYR A  75      -4.311 -14.659  27.190  1.00  0.00           C  
ATOM   1152  CE2 TYR A  75      -5.134 -16.669  26.189  1.00  0.00           C  
ATOM   1153  CZ  TYR A  75      -4.890 -15.906  27.311  1.00  0.00           C  
ATOM   1154  OH  TYR A  75      -5.228 -16.391  28.556  1.00  0.00           O  
ATOM   1155  H   TYR A  75      -2.459 -13.970  21.070  1.00  0.00           H  
ATOM   1156  HA  TYR A  75      -1.886 -13.719  23.952  1.00  0.00           H  
ATOM   1157  HB2 TYR A  75      -4.292 -13.424  23.317  1.00  0.00           H  
ATOM   1158  HB3 TYR A  75      -4.283 -15.064  22.683  1.00  0.00           H  
ATOM   1159  HD1 TYR A  75      -3.525 -13.202  25.837  1.00  0.00           H  
ATOM   1160  HD2 TYR A  75      -4.985 -16.779  24.063  1.00  0.00           H  
ATOM   1161  HE1 TYR A  75      -4.120 -14.060  28.066  1.00  0.00           H  
ATOM   1162  HE2 TYR A  75      -5.585 -17.645  26.283  1.00  0.00           H  
ATOM   1163  HH  TYR A  75      -4.919 -17.300  28.640  1.00  0.00           H  
ATOM   1164  N   VAL A  76      -1.031 -15.974  22.005  1.00  0.00           N  
ATOM   1165  CA  VAL A  76      -0.408 -17.275  21.804  1.00  0.00           C  
ATOM   1166  C   VAL A  76       1.055 -17.252  22.247  1.00  0.00           C  
ATOM   1167  O   VAL A  76       1.733 -16.228  22.134  1.00  0.00           O  
ATOM   1168  CB  VAL A  76      -0.502 -17.718  20.321  1.00  0.00           C  
ATOM   1169  CG1 VAL A  76       0.291 -16.787  19.415  1.00  0.00           C  
ATOM   1170  CG2 VAL A  76      -0.038 -19.158  20.142  1.00  0.00           C  
ATOM   1171  H   VAL A  76      -0.951 -15.295  21.305  1.00  0.00           H  
ATOM   1172  HA  VAL A  76      -0.941 -17.996  22.407  1.00  0.00           H  
ATOM   1173  HB  VAL A  76      -1.539 -17.664  20.022  1.00  0.00           H  
ATOM   1174 HG11 VAL A  76      -0.091 -15.782  19.509  1.00  0.00           H  
ATOM   1175 HG12 VAL A  76       0.194 -17.115  18.391  1.00  0.00           H  
ATOM   1176 HG13 VAL A  76       1.331 -16.807  19.702  1.00  0.00           H  
ATOM   1177 HG21 VAL A  76      -0.655 -19.812  20.740  1.00  0.00           H  
ATOM   1178 HG22 VAL A  76       0.992 -19.245  20.457  1.00  0.00           H  
ATOM   1179 HG23 VAL A  76      -0.121 -19.435  19.102  1.00  0.00           H  
ATOM   1180  N   LEU A  77       1.527 -18.373  22.776  1.00  0.00           N  
ATOM   1181  CA  LEU A  77       2.924 -18.511  23.153  1.00  0.00           C  
ATOM   1182  C   LEU A  77       3.595 -19.491  22.207  1.00  0.00           C  
ATOM   1183  O   LEU A  77       3.512 -20.704  22.397  1.00  0.00           O  
ATOM   1184  CB  LEU A  77       3.075 -19.000  24.602  1.00  0.00           C  
ATOM   1185  CG  LEU A  77       2.662 -18.006  25.700  1.00  0.00           C  
ATOM   1186  CD1 LEU A  77       1.149 -17.849  25.769  1.00  0.00           C  
ATOM   1187  CD2 LEU A  77       3.215 -18.449  27.045  1.00  0.00           C  
ATOM   1188  H   LEU A  77       0.920 -19.139  22.904  1.00  0.00           H  
ATOM   1189  HA  LEU A  77       3.396 -17.545  23.049  1.00  0.00           H  
ATOM   1190  HB2 LEU A  77       2.479 -19.892  24.718  1.00  0.00           H  
ATOM   1191  HB3 LEU A  77       4.111 -19.261  24.759  1.00  0.00           H  
ATOM   1192  HG  LEU A  77       3.085 -17.039  25.472  1.00  0.00           H  
ATOM   1193 HD11 LEU A  77       0.694 -18.808  25.974  1.00  0.00           H  
ATOM   1194 HD12 LEU A  77       0.784 -17.473  24.826  1.00  0.00           H  
ATOM   1195 HD13 LEU A  77       0.895 -17.154  26.557  1.00  0.00           H  
ATOM   1196 HD21 LEU A  77       2.810 -19.418  27.300  1.00  0.00           H  
ATOM   1197 HD22 LEU A  77       2.938 -17.732  27.804  1.00  0.00           H  
ATOM   1198 HD23 LEU A  77       4.291 -18.514  26.987  1.00  0.00           H  
ATOM   1199  N   GLU A  78       4.235 -18.969  21.174  1.00  0.00           N  
ATOM   1200  CA  GLU A  78       4.815 -19.813  20.141  1.00  0.00           C  
ATOM   1201  C   GLU A  78       6.337 -19.729  20.170  1.00  0.00           C  
ATOM   1202  O   GLU A  78       6.926 -18.775  19.660  1.00  0.00           O  
ATOM   1203  CB  GLU A  78       4.258 -19.403  18.770  1.00  0.00           C  
ATOM   1204  CG  GLU A  78       4.544 -20.392  17.646  1.00  0.00           C  
ATOM   1205  CD  GLU A  78       5.896 -20.189  16.995  1.00  0.00           C  
ATOM   1206  OE1 GLU A  78       6.016 -19.288  16.136  1.00  0.00           O  
ATOM   1207  OE2 GLU A  78       6.839 -20.937  17.325  1.00  0.00           O  
ATOM   1208  H   GLU A  78       4.323 -17.997  21.107  1.00  0.00           H  
ATOM   1209  HA  GLU A  78       4.522 -20.833  20.346  1.00  0.00           H  
ATOM   1210  HB2 GLU A  78       3.186 -19.294  18.852  1.00  0.00           H  
ATOM   1211  HB3 GLU A  78       4.684 -18.449  18.496  1.00  0.00           H  
ATOM   1212  HG2 GLU A  78       4.507 -21.393  18.048  1.00  0.00           H  
ATOM   1213  HG3 GLU A  78       3.779 -20.284  16.889  1.00  0.00           H  
ATOM   1214  N   HIS A  79       6.961 -20.709  20.814  1.00  0.00           N  
ATOM   1215  CA  HIS A  79       8.416 -20.827  20.833  1.00  0.00           C  
ATOM   1216  C   HIS A  79       8.844 -22.288  20.925  1.00  0.00           C  
ATOM   1217  O   HIS A  79       9.782 -22.712  20.249  1.00  0.00           O  
ATOM   1218  CB  HIS A  79       9.029 -20.037  21.998  1.00  0.00           C  
ATOM   1219  CG  HIS A  79       9.143 -18.565  21.743  1.00  0.00           C  
ATOM   1220  ND1 HIS A  79       8.428 -17.618  22.445  1.00  0.00           N  
ATOM   1221  CD2 HIS A  79       9.907 -17.877  20.862  1.00  0.00           C  
ATOM   1222  CE1 HIS A  79       8.745 -16.416  22.007  1.00  0.00           C  
ATOM   1223  NE2 HIS A  79       9.639 -16.544  21.047  1.00  0.00           N  
ATOM   1224  H   HIS A  79       6.424 -21.376  21.300  1.00  0.00           H  
ATOM   1225  HA  HIS A  79       8.788 -20.420  19.904  1.00  0.00           H  
ATOM   1226  HB2 HIS A  79       8.415 -20.173  22.874  1.00  0.00           H  
ATOM   1227  HB3 HIS A  79      10.020 -20.419  22.197  1.00  0.00           H  
ATOM   1228  HD1 HIS A  79       7.778 -17.800  23.168  1.00  0.00           H  
ATOM   1229  HD2 HIS A  79      10.599 -18.301  20.145  1.00  0.00           H  
ATOM   1230  HE1 HIS A  79       8.339 -15.484  22.371  1.00  0.00           H  
ATOM   1231  HE2 HIS A  79      10.129 -15.795  20.625  1.00  0.00           H  
ATOM   1232  N   HIS A  80       8.146 -23.064  21.750  1.00  0.00           N  
ATOM   1233  CA  HIS A  80       8.513 -24.456  21.973  1.00  0.00           C  
ATOM   1234  C   HIS A  80       7.303 -25.378  21.834  1.00  0.00           C  
ATOM   1235  O   HIS A  80       6.623 -25.687  22.810  1.00  0.00           O  
ATOM   1236  CB  HIS A  80       9.161 -24.611  23.357  1.00  0.00           C  
ATOM   1237  CG  HIS A  80       9.647 -25.995  23.663  1.00  0.00           C  
ATOM   1238  ND1 HIS A  80      10.575 -26.655  22.889  1.00  0.00           N  
ATOM   1239  CD2 HIS A  80       9.336 -26.840  24.675  1.00  0.00           C  
ATOM   1240  CE1 HIS A  80      10.814 -27.843  23.410  1.00  0.00           C  
ATOM   1241  NE2 HIS A  80      10.078 -27.982  24.495  1.00  0.00           N  
ATOM   1242  H   HIS A  80       7.364 -22.693  22.222  1.00  0.00           H  
ATOM   1243  HA  HIS A  80       9.238 -24.726  21.220  1.00  0.00           H  
ATOM   1244  HB2 HIS A  80      10.008 -23.946  23.423  1.00  0.00           H  
ATOM   1245  HB3 HIS A  80       8.439 -24.338  24.113  1.00  0.00           H  
ATOM   1246  HD1 HIS A  80      10.999 -26.301  22.071  1.00  0.00           H  
ATOM   1247  HD2 HIS A  80       8.636 -26.650  25.476  1.00  0.00           H  
ATOM   1248  HE1 HIS A  80      11.499 -28.577  23.014  1.00  0.00           H  
ATOM   1249  HE2 HIS A  80      10.203 -28.688  25.169  1.00  0.00           H  
ATOM   1250  N   HIS A  81       7.027 -25.783  20.602  1.00  0.00           N  
ATOM   1251  CA  HIS A  81       5.963 -26.737  20.308  1.00  0.00           C  
ATOM   1252  C   HIS A  81       6.502 -27.821  19.380  1.00  0.00           C  
ATOM   1253  O   HIS A  81       7.085 -27.513  18.337  1.00  0.00           O  
ATOM   1254  CB  HIS A  81       4.760 -26.052  19.635  1.00  0.00           C  
ATOM   1255  CG  HIS A  81       3.999 -25.101  20.512  1.00  0.00           C  
ATOM   1256  ND1 HIS A  81       3.317 -24.005  20.024  1.00  0.00           N  
ATOM   1257  CD2 HIS A  81       3.794 -25.096  21.850  1.00  0.00           C  
ATOM   1258  CE1 HIS A  81       2.734 -23.372  21.022  1.00  0.00           C  
ATOM   1259  NE2 HIS A  81       3.005 -24.013  22.140  1.00  0.00           N  
ATOM   1260  H   HIS A  81       7.570 -25.435  19.853  1.00  0.00           H  
ATOM   1261  HA  HIS A  81       5.647 -27.190  21.236  1.00  0.00           H  
ATOM   1262  HB2 HIS A  81       5.109 -25.495  18.779  1.00  0.00           H  
ATOM   1263  HB3 HIS A  81       4.071 -26.814  19.300  1.00  0.00           H  
ATOM   1264  HD1 HIS A  81       3.257 -23.734  19.073  1.00  0.00           H  
ATOM   1265  HD2 HIS A  81       4.184 -25.813  22.560  1.00  0.00           H  
ATOM   1266  HE1 HIS A  81       2.133 -22.479  20.937  1.00  0.00           H  
ATOM   1267  HE2 HIS A  81       2.875 -23.637  23.046  1.00  0.00           H  
ATOM   1268  N   HIS A  82       6.326 -29.081  19.748  1.00  0.00           N  
ATOM   1269  CA  HIS A  82       6.784 -30.172  18.898  1.00  0.00           C  
ATOM   1270  C   HIS A  82       5.601 -30.995  18.394  1.00  0.00           C  
ATOM   1271  O   HIS A  82       5.215 -31.997  18.991  1.00  0.00           O  
ATOM   1272  CB  HIS A  82       7.839 -31.060  19.600  1.00  0.00           C  
ATOM   1273  CG  HIS A  82       7.357 -31.834  20.797  1.00  0.00           C  
ATOM   1274  ND1 HIS A  82       7.045 -33.177  20.746  1.00  0.00           N  
ATOM   1275  CD2 HIS A  82       7.160 -31.458  22.079  1.00  0.00           C  
ATOM   1276  CE1 HIS A  82       6.678 -33.587  21.943  1.00  0.00           C  
ATOM   1277  NE2 HIS A  82       6.738 -32.566  22.773  1.00  0.00           N  
ATOM   1278  H   HIS A  82       5.863 -29.280  20.597  1.00  0.00           H  
ATOM   1279  HA  HIS A  82       7.250 -29.714  18.037  1.00  0.00           H  
ATOM   1280  HB2 HIS A  82       8.217 -31.776  18.886  1.00  0.00           H  
ATOM   1281  HB3 HIS A  82       8.656 -30.430  19.924  1.00  0.00           H  
ATOM   1282  HD1 HIS A  82       7.067 -33.744  19.940  1.00  0.00           H  
ATOM   1283  HD2 HIS A  82       7.308 -30.467  22.484  1.00  0.00           H  
ATOM   1284  HE1 HIS A  82       6.379 -34.593  22.201  1.00  0.00           H  
ATOM   1285  HE2 HIS A  82       6.324 -32.548  23.665  1.00  0.00           H  
ATOM   1286  N   HIS A  83       5.007 -30.531  17.300  1.00  0.00           N  
ATOM   1287  CA  HIS A  83       3.883 -31.219  16.665  1.00  0.00           C  
ATOM   1288  C   HIS A  83       2.690 -31.319  17.615  1.00  0.00           C  
ATOM   1289  O   HIS A  83       2.612 -30.602  18.616  1.00  0.00           O  
ATOM   1290  CB  HIS A  83       4.303 -32.614  16.181  1.00  0.00           C  
ATOM   1291  CG  HIS A  83       5.405 -32.583  15.168  1.00  0.00           C  
ATOM   1292  ND1 HIS A  83       6.265 -33.636  14.949  1.00  0.00           N  
ATOM   1293  CD2 HIS A  83       5.784 -31.609  14.306  1.00  0.00           C  
ATOM   1294  CE1 HIS A  83       7.124 -33.309  14.001  1.00  0.00           C  
ATOM   1295  NE2 HIS A  83       6.853 -32.085  13.594  1.00  0.00           N  
ATOM   1296  H   HIS A  83       5.331 -29.689  16.906  1.00  0.00           H  
ATOM   1297  HA  HIS A  83       3.586 -30.631  15.810  1.00  0.00           H  
ATOM   1298  HB2 HIS A  83       4.642 -33.196  17.025  1.00  0.00           H  
ATOM   1299  HB3 HIS A  83       3.451 -33.102  15.732  1.00  0.00           H  
ATOM   1300  HD1 HIS A  83       6.235 -34.510  15.407  1.00  0.00           H  
ATOM   1301  HD2 HIS A  83       5.320 -30.639  14.192  1.00  0.00           H  
ATOM   1302  HE1 HIS A  83       7.913 -33.941  13.619  1.00  0.00           H  
ATOM   1303  HE2 HIS A  83       7.231 -31.659  12.795  1.00  0.00           H  
ATOM   1304  N   HIS A  84       1.754 -32.194  17.288  1.00  0.00           N  
ATOM   1305  CA  HIS A  84       0.566 -32.374  18.102  1.00  0.00           C  
ATOM   1306  C   HIS A  84       0.586 -33.757  18.736  1.00  0.00           C  
ATOM   1307  O   HIS A  84       0.119 -34.719  18.091  1.00  0.00           O  
ATOM   1308  CB  HIS A  84      -0.694 -32.178  17.254  1.00  0.00           C  
ATOM   1309  CG  HIS A  84      -1.976 -32.265  18.025  1.00  0.00           C  
ATOM   1310  ND1 HIS A  84      -2.967 -33.175  17.732  1.00  0.00           N  
ATOM   1311  CD2 HIS A  84      -2.439 -31.531  19.063  1.00  0.00           C  
ATOM   1312  CE1 HIS A  84      -3.984 -32.997  18.552  1.00  0.00           C  
ATOM   1313  NE2 HIS A  84      -3.691 -32.005  19.373  1.00  0.00           N  
ATOM   1314  OXT HIS A  84       1.098 -33.882  19.865  1.00  0.00           O  
ATOM   1315  H   HIS A  84       1.872 -32.746  16.484  1.00  0.00           H  
ATOM   1316  HA  HIS A  84       0.586 -31.630  18.886  1.00  0.00           H  
ATOM   1317  HB2 HIS A  84      -0.657 -31.204  16.788  1.00  0.00           H  
ATOM   1318  HB3 HIS A  84      -0.718 -32.936  16.484  1.00  0.00           H  
ATOM   1319  HD1 HIS A  84      -2.929 -33.853  17.017  1.00  0.00           H  
ATOM   1320  HD2 HIS A  84      -1.920 -30.721  19.558  1.00  0.00           H  
ATOM   1321  HE1 HIS A  84      -4.902 -33.566  18.552  1.00  0.00           H  
ATOM   1322  HE2 HIS A  84      -4.348 -31.539  19.946  1.00  0.00           H  
TER    1323      HIS A  84                                                      
END
MOLECULE T0462_77_143.pdb
ATOM   1204  N   GLU    77      -2.454  -0.642   9.985  1.00 11.51           N 
ATOM   1205  CA  GLU    77      -3.612  -0.786   9.094  1.00 13.44           C 
ATOM   1206  C   GLU    77      -3.312  -0.215   7.697  1.00  2.42           C 
ATOM   1207  O   GLU    77      -2.423   0.626   7.539  1.00 25.04           O 
ATOM   1208  CB  GLU    77      -4.862  -0.141   9.730  1.00 44.40           C 
ATOM   1209  CG  GLU    77      -4.619   1.193  10.448  1.00 34.41           C 
ATOM   1210  CD  GLU    77      -4.730   2.413   9.544  1.00 50.11           C 
ATOM   1211  OE1 GLU    77      -3.899   3.342   9.674  1.00 42.31           O 
ATOM   1212  OE2 GLU    77      -5.670   2.469   8.730  1.00 32.01           O 
ATOM   1213  H   GLU    77      -1.869   0.136   9.876  1.00 36.29           H 
ATOM   1214  HA  GLU    77      -3.795  -1.847   8.981  1.00 15.42           H 
ATOM   1215 3HB  GLU    77      -5.272  -0.837  10.449  1.00 36.29           H 
ATOM   1216 2HB  GLU    77      -5.600   0.023   8.957  1.00 36.29           H 
ATOM   1217 3HG  GLU    77      -3.628   1.173  10.883  1.00 36.29           H 
ATOM   1218 2HG  GLU    77      -5.349   1.296  11.240  1.00 36.29           H 
ATOM   1219  N   LEU    78      -4.045  -0.688   6.685  1.00 42.42           N 
ATOM   1220  CA  LEU    78      -3.726  -0.377   5.282  1.00 60.21           C 
ATOM   1221  C   LEU    78      -4.996  -0.222   4.419  1.00 62.54           C 
ATOM   1222  O   LEU    78      -6.044  -0.782   4.736  1.00  4.41           O 
ATOM   1223  CB  LEU    78      -2.814  -1.473   4.686  1.00 61.43           C 
ATOM   1224  CG  LEU    78      -3.447  -2.870   4.491  1.00 11.44           C 
ATOM   1225  CD1 LEU    78      -2.505  -3.774   3.701  1.00 12.40           C 
ATOM   1226  CD2 LEU    78      -3.799  -3.519   5.833  1.00 74.53           C 
ATOM   1227  H   LEU    78      -4.830  -1.244   6.884  1.00 36.29           H 
ATOM   1228  HA  LEU    78      -3.189   0.561   5.269  1.00 44.34           H 
ATOM   1229 3HB  LEU    78      -1.956  -1.581   5.336  1.00 36.29           H 
ATOM   1230 2HB  LEU    78      -2.465  -1.127   3.723  1.00 36.29           H 
ATOM   1231  HG  LEU    78      -4.358  -2.767   3.919  1.00 65.12           H 
ATOM   1232 1HD1 LEU    78      -2.985  -4.725   3.521  1.00 36.29           H 
ATOM   1233 2HD1 LEU    78      -1.595  -3.932   4.264  1.00 36.29           H 
ATOM   1234 3HD1 LEU    78      -2.265  -3.308   2.756  1.00 36.29           H 
ATOM   1235 1HD2 LEU    78      -4.537  -2.918   6.341  1.00 36.29           H 
ATOM   1236 2HD2 LEU    78      -2.912  -3.593   6.445  1.00 36.29           H 
ATOM   1237 3HD2 LEU    78      -4.200  -4.508   5.661  1.00 36.29           H 
ATOM   1238  N   PRO    79      -4.915   0.544   3.306  1.00 33.21           N 
ATOM   1239  CA  PRO    79      -6.069   0.774   2.413  1.00  3.41           C 
ATOM   1240  C   PRO    79      -6.473  -0.476   1.601  1.00 53.44           C 
ATOM   1241  O   PRO    79      -5.633  -1.315   1.265  1.00 30.11           O 
ATOM   1242  CB  PRO    79      -5.572   1.889   1.482  1.00 60.14           C 
ATOM   1243  CG  PRO    79      -4.091   1.726   1.458  1.00  3.44           C 
ATOM   1244  CD  PRO    79      -3.705   1.251   2.834  1.00 21.25           C 
ATOM   1245  HA  PRO    79      -6.926   1.127   2.970  1.00 32.11           H 
ATOM   1246 3HB  PRO    79      -5.852   2.854   1.884  1.00 36.29           H 
ATOM   1247 2HB  PRO    79      -6.001   1.766   0.497  1.00 36.29           H 
ATOM   1248 3HG  PRO    79      -3.618   2.673   1.241  1.00 36.29           H 
ATOM   1249 2HG  PRO    79      -3.814   0.990   0.716  1.00 36.29           H 
ATOM   1250 3HD  PRO    79      -3.475   2.091   3.474  1.00 36.29           H 
ATOM   1251 2HD  PRO    79      -2.861   0.577   2.779  1.00 36.29           H 
ATOM   1252  N   LEU    80      -7.765  -0.571   1.270  1.00 10.14           N 
ATOM   1253  CA  LEU    80      -8.322  -1.726   0.538  1.00 12.24           C 
ATOM   1254  C   LEU    80      -7.531  -2.084  -0.732  1.00 71.04           C 
ATOM   1255  O   LEU    80      -7.179  -3.245  -0.943  1.00 34.43           O 
ATOM   1256  CB  LEU    80      -9.787  -1.452   0.162  1.00 13.14           C 
ATOM   1257  CG  LEU    80     -10.808  -1.614   1.299  1.00 54.21           C 
ATOM   1258  CD1 LEU    80     -12.201  -1.194   0.838  1.00 12.24           C 
ATOM   1259  CD2 LEU    80     -10.824  -3.057   1.801  1.00 34.31           C 
ATOM   1260  H   LEU    80      -8.371   0.157   1.533  1.00 36.29           H 
ATOM   1261  HA  LEU    80      -8.296  -2.574   1.206  1.00 73.22           H 
ATOM   1262 3HB  LEU    80     -10.066  -2.124  -0.639  1.00 36.29           H 
ATOM   1263 2HB  LEU    80      -9.855  -0.438  -0.210  1.00 36.29           H 
ATOM   1264  HG  LEU    80     -10.523  -0.976   2.125  1.00 14.14           H 
ATOM   1265 1HD1 LEU    80     -12.900  -1.307   1.654  1.00 36.29           H 
ATOM   1266 2HD1 LEU    80     -12.514  -1.813   0.008  1.00 36.29           H 
ATOM   1267 3HD1 LEU    80     -12.181  -0.159   0.526  1.00 36.29           H 
ATOM   1268 1HD2 LEU    80     -11.535  -3.148   2.610  1.00 36.29           H 
ATOM   1269 2HD2 LEU    80      -9.841  -3.325   2.157  1.00 36.29           H 
ATOM   1270 3HD2 LEU    80     -11.109  -3.720   0.996  1.00 36.29           H 
ATOM   1271  N   ILE    81      -7.255  -1.088  -1.570  1.00 44.14           N 
ATOM   1272  CA  ILE    81      -6.604  -1.322  -2.871  1.00 50.44           C 
ATOM   1273  C   ILE    81      -5.189  -1.920  -2.721  1.00 33.22           C 
ATOM   1274  O   ILE    81      -4.653  -2.514  -3.657  1.00 43.13           O 
ATOM   1275  CB  ILE    81      -6.528  -0.010  -3.698  1.00 35.34           C 
ATOM   1276  CG1 ILE    81      -6.096  -0.294  -5.148  1.00 45.22           C 
ATOM   1277  CG2 ILE    81      -5.576   0.987  -3.044  1.00 11.34           C 
ATOM   1278  CD1 ILE    81      -7.036  -1.214  -5.900  1.00  2.11           C 
ATOM   1279  H   ILE    81      -7.502  -0.174  -1.317  1.00 36.29           H 
ATOM   1280  HA  ILE    81      -7.218  -2.025  -3.417  1.00  3.54           H 
ATOM   1281  HB  ILE    81      -7.513   0.435  -3.708  1.00 64.25           H 
ATOM   1282 3HG1 ILE    81      -5.116  -0.753  -5.144  1.00 36.29           H 
ATOM   1283 2HG1 ILE    81      -6.047   0.637  -5.692  1.00 36.29           H 
ATOM   1284 1HG2 ILE    81      -5.915   1.203  -2.040  1.00 36.29           H 
ATOM   1285 2HG2 ILE    81      -5.556   1.901  -3.620  1.00 36.29           H 
ATOM   1286 3HG2 ILE    81      -4.583   0.565  -3.003  1.00 36.29           H 
ATOM   1287 1HD1 ILE    81      -7.069  -2.176  -5.410  1.00 36.29           H 
ATOM   1288 2HD1 ILE    81      -6.681  -1.338  -6.912  1.00 36.29           H 
ATOM   1289 3HD1 ILE    81      -8.027  -0.784  -5.915  1.00 36.29           H 
ATOM   1290  N   LEU    82      -4.590  -1.765  -1.542  1.00 13.21           N 
ATOM   1291  CA  LEU    82      -3.229  -2.263  -1.295  1.00 75.44           C 
ATOM   1292  C   LEU    82      -3.235  -3.478  -0.352  1.00 14.20           C 
ATOM   1293  O   LEU    82      -2.176  -3.964   0.063  1.00 74.13           O 
ATOM   1294  CB  LEU    82      -2.366  -1.146  -0.695  1.00 53.44           C 
ATOM   1295  CG  LEU    82      -2.352   0.178  -1.474  1.00 23.25           C 
ATOM   1296  CD1 LEU    82      -1.386   1.167  -0.831  1.00 12.00           C 
ATOM   1297  CD2 LEU    82      -2.003  -0.053  -2.944  1.00 23.35           C 
ATOM   1298  H   LEU    82      -5.070  -1.312  -0.819  1.00 36.29           H 
ATOM   1299  HA  LEU    82      -2.804  -2.562  -2.243  1.00 41.41           H 
ATOM   1300 3HB  LEU    82      -1.349  -1.508  -0.628  1.00 36.29           H 
ATOM   1301 2HB  LEU    82      -2.723  -0.944   0.306  1.00 36.29           H 
ATOM   1302  HG  LEU    82      -3.341   0.615  -1.434  1.00 42.03           H 
ATOM   1303 1HD1 LEU    82      -1.403   2.098  -1.381  1.00 36.29           H 
ATOM   1304 2HD1 LEU    82      -0.385   0.760  -0.844  1.00 36.29           H 
ATOM   1305 3HD1 LEU    82      -1.686   1.348   0.191  1.00 36.29           H 
ATOM   1306 1HD2 LEU    82      -1.038  -0.530  -3.018  1.00 36.29           H 
ATOM   1307 2HD2 LEU    82      -1.974   0.897  -3.460  1.00 36.29           H 
ATOM   1308 3HD2 LEU    82      -2.754  -0.683  -3.398  1.00 36.29           H 
ATOM   1309  N   ALA    83      -4.428  -3.973  -0.032  1.00 32.45           N 
ATOM   1310  CA  ALA    83      -4.592  -5.071   0.925  1.00 15.43           C 
ATOM   1311  C   ALA    83      -4.014  -6.403   0.410  1.00 54.30           C 
ATOM   1312  O   ALA    83      -3.799  -6.591  -0.789  1.00 23.30           O 
ATOM   1313  CB  ALA    83      -6.067  -5.236   1.279  1.00 62.03           C 
ATOM   1314  H   ALA    83      -5.227  -3.589  -0.453  1.00 36.29           H 
ATOM   1315  HA  ALA    83      -4.066  -4.796   1.829  1.00  1.41           H 
ATOM   1316 1HB  ALA    83      -6.462  -4.293   1.627  1.00 36.29           H 
ATOM   1317 2HB  ALA    83      -6.170  -5.977   2.061  1.00 36.29           H 
ATOM   1318 3HB  ALA    83      -6.616  -5.558   0.406  1.00 36.29           H 
ATOM   1319  N   ASP    84      -3.760  -7.320   1.339  1.00 24.33           N 
ATOM   1320  CA  ASP    84      -3.272  -8.663   1.014  1.00 10.43           C 
ATOM   1321  C   ASP    84      -4.400  -9.512   0.385  1.00 31.22           C 
ATOM   1322  O   ASP    84      -4.529  -9.582  -0.842  1.00  1.44           O 
ATOM   1323  CB  ASP    84      -2.725  -9.313   2.296  1.00 12.14           C 
ATOM   1324  CG  ASP    84      -2.271 -10.747   2.104  1.00 72.45           C 
ATOM   1325  OD1 ASP    84      -3.012 -11.668   2.515  1.00 44.41           O 
ATOM   1326  OD2 ASP    84      -1.169 -10.955   1.558  1.00 25.23           O 
ATOM   1327  H   ASP    84      -3.901  -7.087   2.281  1.00 36.29           H 
ATOM   1328  HA  ASP    84      -2.469  -8.563   0.297  1.00 73.24           H 
ATOM   1329 3HB  ASP    84      -3.498  -9.296   3.051  1.00 36.29           H 
ATOM   1330 2HB  ASP    84      -1.883  -8.736   2.646  1.00 36.29           H 
ATOM   1331  N   ASP    85      -5.236 -10.120   1.232  1.00 43.24           N 
ATOM   1332  CA  ASP    85      -6.389 -10.904   0.774  1.00 10.24           C 
ATOM   1333  C   ASP    85      -7.229 -11.390   1.973  1.00  1.54           C 
ATOM   1334  O   ASP    85      -6.831 -11.223   3.127  1.00  0.32           O 
ATOM   1335  CB  ASP    85      -5.918 -12.100  -0.067  1.00 10.35           C 
ATOM   1336  CG  ASP    85      -7.046 -12.723  -0.867  1.00 21.21           C 
ATOM   1337  OD1 ASP    85      -7.689 -13.662  -0.366  1.00 45.32           O 
ATOM   1338  OD2 ASP    85      -7.309 -12.253  -1.993  1.00 50.25           O 
ATOM   1339  H   ASP    85      -5.066 -10.052   2.195  1.00 36.29           H 
ATOM   1340  HA  ASP    85      -7.004 -10.260   0.160  1.00  3.02           H 
ATOM   1341 3HB  ASP    85      -5.500 -12.853   0.587  1.00 36.29           H 
ATOM   1342 2HB  ASP    85      -5.153 -11.769  -0.756  1.00 36.29           H 
ATOM   1343  N   GLY    86      -8.394 -11.971   1.690  1.00 44.14           N 
ATOM   1344  CA  GLY    86      -9.235 -12.538   2.741  1.00 21.12           C 
ATOM   1345  C   GLY    86     -10.194 -11.536   3.378  1.00 41.53           C 
ATOM   1346  O   GLY    86     -10.603 -10.553   2.752  1.00 64.33           O 
ATOM   1347  H   GLY    86      -8.685 -12.028   0.756  1.00 36.29           H 
ATOM   1348 3HA  GLY    86      -8.598 -12.948   3.513  1.00 36.29           H 
ATOM   1349 2HA  GLY    86      -9.816 -13.343   2.314  1.00 36.29           H 
ATOM   1350  N   THR    87     -10.558 -11.795   4.635  1.00 35.13           N 
ATOM   1351  CA  THR    87     -11.509 -10.952   5.372  1.00 72.12           C 
ATOM   1352  C   THR    87     -10.799  -9.812   6.129  1.00 24.21           C 
ATOM   1353  O   THR    87      -9.826 -10.043   6.858  1.00 41.52           O 
ATOM   1354  CB  THR    87     -12.318 -11.785   6.400  1.00  0.32           C 
ATOM   1355  OG1 THR    87     -12.695 -13.054   5.838  1.00 42.15           O 
ATOM   1356  CG2 THR    87     -13.571 -11.036   6.845  1.00 42.41           C 
ATOM   1357  H   THR    87     -10.189 -12.586   5.077  1.00 36.29           H 
ATOM   1358  HA  THR    87     -12.203 -10.525   4.660  1.00 32.51           H 
ATOM   1359  HB  THR    87     -11.696 -11.961   7.268  1.00  2.24           H 
ATOM   1360  HG1 THR    87     -13.011 -12.935   4.931  1.00 64.23           H 
ATOM   1361 1HG2 THR    87     -14.114 -11.637   7.560  1.00 36.29           H 
ATOM   1362 2HG2 THR    87     -14.199 -10.838   5.989  1.00 36.29           H 
ATOM   1363 3HG2 THR    87     -13.288 -10.100   7.309  1.00 36.29           H 
ATOM   1364  N   TYR    88     -11.299  -8.585   5.964  1.00  4.25           N 
ATOM   1365  CA  TYR    88     -10.751  -7.403   6.652  1.00 21.51           C 
ATOM   1366  C   TYR    88     -11.807  -6.696   7.502  1.00 53.21           C 
ATOM   1367  O   TYR    88     -12.994  -6.942   7.359  1.00 53.41           O 
ATOM   1368  CB  TYR    88     -10.188  -6.406   5.634  1.00 52.03           C 
ATOM   1369  CG  TYR    88      -8.939  -6.890   4.940  1.00 31.22           C 
ATOM   1370  CD1 TYR    88      -9.013  -7.749   3.853  1.00 74.10           C 
ATOM   1371  CD2 TYR    88      -7.682  -6.496   5.382  1.00 54.22           C 
ATOM   1372  CE1 TYR    88      -7.874  -8.199   3.229  1.00 43.52           C 
ATOM   1373  CE2 TYR    88      -6.538  -6.941   4.759  1.00 42.24           C 
ATOM   1374  CZ  TYR    88      -6.642  -7.794   3.687  1.00 14.22           C 
ATOM   1375  OH  TYR    88      -5.509  -8.243   3.067  1.00 72.21           O 
ATOM   1376  H   TYR    88     -12.058  -8.465   5.355  1.00 36.29           H 
ATOM   1377  HA  TYR    88      -9.949  -7.733   7.299  1.00 13.41           H 
ATOM   1378 3HB  TYR    88      -9.950  -5.480   6.142  1.00 36.29           H 
ATOM   1379 2HB  TYR    88     -10.936  -6.210   4.877  1.00 36.29           H 
ATOM   1380  HD1 TYR    88      -9.983  -8.066   3.498  1.00 20.13           H 
ATOM   1381  HD2 TYR    88      -7.608  -5.825   6.225  1.00 62.02           H 
ATOM   1382  HE1 TYR    88      -7.950  -8.866   2.384  1.00 32.42           H 
ATOM   1383  HE2 TYR    88      -5.568  -6.625   5.117  1.00  4.31           H 
ATOM   1384  HH  TYR    88      -5.635  -8.200   2.112  1.00 71.22           H 
ATOM   1385  N   GLU    89     -11.354  -5.812   8.384  1.00 22.34           N 
ATOM   1386  CA  GLU    89     -12.251  -4.984   9.201  1.00 23.21           C 
ATOM   1387  C   GLU    89     -11.974  -3.490   8.965  1.00 54.21           C 
ATOM   1388  O   GLU    89     -10.836  -3.037   9.092  1.00 64.32           O 
ATOM   1389  CB  GLU    89     -12.069  -5.321  10.687  1.00 22.21           C 
ATOM   1390  CG  GLU    89     -12.930  -4.480  11.626  1.00 63.13           C 
ATOM   1391  CD  GLU    89     -12.663  -4.780  13.092  1.00 60.50           C 
ATOM   1392  OE1 GLU    89     -13.470  -5.499  13.719  1.00 25.53           O 
ATOM   1393  OE2 GLU    89     -11.647  -4.290  13.623  1.00 33.14           O 
ATOM   1394  H   GLU    89     -10.386  -5.716   8.500  1.00 36.29           H 
ATOM   1395  HA  GLU    89     -13.270  -5.201   8.910  1.00 11.21           H 
ATOM   1396 3HB  GLU    89     -11.032  -5.172  10.954  1.00 36.29           H 
ATOM   1397 2HB  GLU    89     -12.321  -6.362  10.840  1.00 36.29           H 
ATOM   1398 3HG  GLU    89     -13.972  -4.676  11.413  1.00 36.29           H 
ATOM   1399 2HG  GLU    89     -12.720  -3.435  11.445  1.00 36.29           H 
ATOM   1400  N   ILE    90     -13.009  -2.728   8.613  1.00 11.51           N 
ATOM   1401  CA  ILE    90     -12.846  -1.290   8.346  1.00 53.30           C 
ATOM   1402  C   ILE    90     -12.498  -0.498   9.622  1.00 34.11           C 
ATOM   1403  O   ILE    90     -13.180  -0.604  10.649  1.00 11.23           O 
ATOM   1404  CB  ILE    90     -14.111  -0.683   7.683  1.00 24.24           C 
ATOM   1405  CG1 ILE    90     -13.926   0.830   7.453  1.00 14.23           C 
ATOM   1406  CG2 ILE    90     -15.355  -0.960   8.528  1.00 25.01           C 
ATOM   1407  CD1 ILE    90     -15.115   1.501   6.804  1.00 35.11           C 
ATOM   1408  H   ILE    90     -13.898  -3.139   8.523  1.00 36.29           H 
ATOM   1409  HA  ILE    90     -12.026  -1.185   7.649  1.00 63.25           H 
ATOM   1410  HB  ILE    90     -14.249  -1.167   6.726  1.00 75.34           H 
ATOM   1411 3HG1 ILE    90     -13.066   0.990   6.816  1.00 36.29           H 
ATOM   1412 2HG1 ILE    90     -13.757   1.313   8.403  1.00 36.29           H 
ATOM   1413 1HG2 ILE    90     -15.247  -0.488   9.495  1.00 36.29           H 
ATOM   1414 2HG2 ILE    90     -15.472  -2.026   8.660  1.00 36.29           H 
ATOM   1415 3HG2 ILE    90     -16.228  -0.562   8.031  1.00 36.29           H 
ATOM   1416 1HD1 ILE    90     -15.985   1.378   7.431  1.00 36.29           H 
ATOM   1417 2HD1 ILE    90     -15.298   1.054   5.839  1.00 36.29           H 
ATOM   1418 3HD1 ILE    90     -14.910   2.554   6.679  1.00 36.29           H 
ATOM   1419  N   THR    91     -11.430   0.300   9.546  1.00 65.23           N 
ATOM   1420  CA  THR    91     -10.965   1.088  10.698  1.00 35.41           C 
ATOM   1421  C   THR    91     -11.241   2.593  10.535  1.00 43.23           C 
ATOM   1422  O   THR    91     -11.580   3.267  11.506  1.00 23.55           O 
ATOM   1423  CB  THR    91      -9.454   0.868  10.974  1.00 14.21           C 
ATOM   1424  OG1 THR    91      -9.022   1.680  12.077  1.00 73.21           O 
ATOM   1425  CG2 THR    91      -8.603   1.180   9.745  1.00 34.25           C 
ATOM   1426  H   THR    91     -10.940   0.357   8.697  1.00 36.29           H 
ATOM   1427  HA  THR    91     -11.507   0.740  11.569  1.00 61.54           H 
ATOM   1428  HB  THR    91      -9.305  -0.173  11.233  1.00 33.24           H 
ATOM   1429  HG1 THR    91      -9.720   1.708  12.747  1.00 14.23           H 
ATOM   1430 1HG2 THR    91      -8.722   2.219   9.474  1.00 36.29           H 
ATOM   1431 2HG2 THR    91      -8.916   0.555   8.920  1.00 36.29           H 
ATOM   1432 3HG2 THR    91      -7.564   0.984   9.968  1.00 36.29           H 
ATOM   1433  N   LYS    92     -11.100   3.122   9.313  1.00 42.31           N 
ATOM   1434  CA  LYS    92     -11.345   4.557   9.064  1.00 54.15           C 
ATOM   1435  C   LYS    92     -11.465   4.899   7.568  1.00 44.42           C 
ATOM   1436  O   LYS    92     -10.929   4.201   6.701  1.00 33.13           O 
ATOM   1437  CB  LYS    92     -10.233   5.419   9.682  1.00 65.22           C 
ATOM   1438  CG  LYS    92      -8.822   5.024   9.253  1.00 10.13           C 
ATOM   1439  CD  LYS    92      -7.794   6.078   9.659  1.00 64.52           C 
ATOM   1440  CE  LYS    92      -6.370   5.532   9.646  1.00  4.34           C 
ATOM   1441  NZ  LYS    92      -5.966   4.989   8.322  1.00 72.11           N 
ATOM   1442  H   LYS    92     -10.830   2.546   8.566  1.00 36.29           H 
ATOM   1443  HA  LYS    92     -12.281   4.811   9.543  1.00 11.11           H 
ATOM   1444 3HB  LYS    92     -10.293   5.338  10.759  1.00 36.29           H 
ATOM   1445 2HB  LYS    92     -10.396   6.451   9.402  1.00 36.29           H 
ATOM   1446 3HG  LYS    92      -8.801   4.907   8.176  1.00 36.29           H 
ATOM   1447 2HG  LYS    92      -8.565   4.084   9.720  1.00 36.29           H 
ATOM   1448 3HD  LYS    92      -8.024   6.427  10.656  1.00 36.29           H 
ATOM   1449 2HD  LYS    92      -7.852   6.907   8.967  1.00 36.29           H 
ATOM   1450 3HE  LYS    92      -6.301   4.743  10.378  1.00 36.29           H 
ATOM   1451 2HE  LYS    92      -5.692   6.326   9.915  1.00 36.29           H 
ATOM   1452 1HZ  LYS    92      -5.967   5.739   7.606  1.00 36.29           H 
ATOM   1453 2HZ  LYS    92      -6.620   4.235   8.030  1.00 36.29           H 
ATOM   1454 3HZ  LYS    92      -5.008   4.579   8.385  1.00 36.29           H 
ATOM   1455  N   LEU    93     -12.170   5.999   7.283  1.00 72.14           N 
ATOM   1456  CA  LEU    93     -12.288   6.540   5.919  1.00 12.31           C 
ATOM   1457  C   LEU    93     -11.469   7.838   5.779  1.00 10.13           C 
ATOM   1458  O   LEU    93     -11.050   8.430   6.777  1.00 42.13           O 
ATOM   1459  CB  LEU    93     -13.758   6.838   5.567  1.00  2.12           C 
ATOM   1460  CG  LEU    93     -14.729   5.640   5.568  1.00 63.13           C 
ATOM   1461  CD1 LEU    93     -14.168   4.482   4.754  1.00 23.14           C 
ATOM   1462  CD2 LEU    93     -15.068   5.202   6.993  1.00 50.42           C 
ATOM   1463  H   LEU    93     -12.626   6.467   8.016  1.00 36.29           H 
ATOM   1464  HA  LEU    93     -11.897   5.805   5.228  1.00 20.21           H 
ATOM   1465 3HB  LEU    93     -13.781   7.284   4.582  1.00 36.29           H 
ATOM   1466 2HB  LEU    93     -14.129   7.569   6.272  1.00 36.29           H 
ATOM   1467  HG  LEU    93     -15.652   5.949   5.093  1.00 22.03           H 
ATOM   1468 1HD1 LEU    93     -13.251   4.130   5.204  1.00 36.29           H 
ATOM   1469 2HD1 LEU    93     -13.968   4.815   3.745  1.00 36.29           H 
ATOM   1470 3HD1 LEU    93     -14.888   3.677   4.728  1.00 36.29           H 
ATOM   1471 1HD2 LEU    93     -15.746   4.363   6.959  1.00 36.29           H 
ATOM   1472 2HD2 LEU    93     -15.539   6.021   7.519  1.00 36.29           H 
ATOM   1473 3HD2 LEU    93     -14.165   4.913   7.510  1.00 36.29           H 
ATOM   1474  N   ASN    94     -11.246   8.277   4.540  1.00 74.35           N 
ATOM   1475  CA  ASN    94     -10.546   9.545   4.271  1.00 71.52           C 
ATOM   1476  C   ASN    94     -11.230  10.336   3.139  1.00 71.43           C 
ATOM   1477  O   ASN    94     -11.226   9.910   1.981  1.00 31.43           O 
ATOM   1478  CB  ASN    94      -9.078   9.279   3.908  1.00 32.31           C 
ATOM   1479  CG  ASN    94      -8.243   8.874   5.111  1.00 15.34           C 
ATOM   1480  OD1 ASN    94      -7.668   9.714   5.790  1.00  0.13           O 
ATOM   1481  ND2 ASN    94      -8.166   7.589   5.389  1.00 63.03           N 
ATOM   1482  H   ASN    94     -11.553   7.736   3.782  1.00 36.29           H 
ATOM   1483  HA  ASN    94     -10.579  10.141   5.175  1.00 70.10           H 
ATOM   1484 3HB  ASN    94      -8.649  10.176   3.483  1.00 36.29           H 
ATOM   1485 2HB  ASN    94      -9.031   8.485   3.177  1.00 36.29           H 
ATOM   1486 1HD2 ASN    94      -8.646   6.957   4.816  1.00 36.29           H 
ATOM   1487 2HD2 ASN    94      -7.625   7.321   6.157  1.00 36.29           H 
ATOM   1488  N   GLY    95     -11.820  11.485   3.478  1.00 54.24           N 
ATOM   1489  CA  GLY    95     -12.478  12.324   2.472  1.00 52.34           C 
ATOM   1490  C   GLY    95     -13.424  13.363   3.078  1.00 12.22           C 
ATOM   1491  O   GLY    95     -13.213  13.825   4.199  1.00 53.41           O 
ATOM   1492  H   GLY    95     -11.815  11.767   4.419  1.00 36.29           H 
ATOM   1493 3HA  GLY    95     -13.044  11.689   1.803  1.00 36.29           H 
ATOM   1494 2HA  GLY    95     -11.721  12.841   1.901  1.00 36.29           H 
ATOM   1495  N   GLY    96     -14.465  13.735   2.330  1.00 32.53           N 
ATOM   1496  CA  GLY    96     -15.456  14.691   2.826  1.00 24.42           C 
ATOM   1497  C   GLY    96     -16.753  14.021   3.281  1.00 74.23           C 
ATOM   1498  O   GLY    96     -16.880  12.797   3.213  1.00 22.41           O 
ATOM   1499  H   GLY    96     -14.565  13.355   1.434  1.00 36.29           H 
ATOM   1500 3HA  GLY    96     -15.685  15.392   2.035  1.00 36.29           H 
ATOM   1501 2HA  GLY    96     -15.036  15.236   3.660  1.00 36.29           H 
ATOM   1502  N   ARG    97     -17.730  14.818   3.722  1.00 73.32           N 
ATOM   1503  CA  ARG    97     -18.994  14.277   4.247  1.00  2.04           C 
ATOM   1504  C   ARG    97     -19.796  13.532   3.167  1.00  2.23           C 
ATOM   1505  O   ARG    97     -20.404  12.500   3.447  1.00 53.11           O 
ATOM   1506  CB  ARG    97     -19.858  15.386   4.873  1.00 45.22           C 
ATOM   1507  CG  ARG    97     -21.094  14.854   5.602  1.00  2.20           C 
ATOM   1508  CD  ARG    97     -21.859  15.957   6.332  1.00 61.12           C 
ATOM   1509  NE  ARG    97     -22.452  16.926   5.413  1.00 32.33           N 
ATOM   1510  CZ  ARG    97     -23.273  17.873   5.779  1.00 32.33           C 
ATOM   1511  NH1 ARG    97     -23.609  18.015   7.020  1.00  3.21           N 
ATOM   1512  NH2 ARG    97     -23.765  18.679   4.900  1.00 11.43           N 
ATOM   1513  H   ARG    97     -17.601  15.792   3.692  1.00 36.29           H 
ATOM   1514  HA  ARG    97     -18.737  13.568   5.022  1.00 11.03           H 
ATOM   1515 3HB  ARG    97     -20.185  16.059   4.092  1.00 36.29           H 
ATOM   1516 2HB  ARG    97     -19.256  15.939   5.582  1.00 36.29           H 
ATOM   1517 3HG  ARG    97     -20.782  14.109   6.321  1.00 36.29           H 
ATOM   1518 2HG  ARG    97     -21.754  14.397   4.878  1.00 36.29           H 
ATOM   1519 3HD  ARG    97     -21.177  16.472   6.995  1.00 36.29           H 
ATOM   1520 2HD  ARG    97     -22.648  15.503   6.916  1.00 36.29           H 
ATOM   1521  HE  ARG    97     -22.222  16.856   4.465  1.00 42.04           H 
ATOM   1522 1HH1 ARG    97     -23.243  17.397   7.712  1.00 36.29           H 
ATOM   1523 2HH1 ARG    97     -24.232  18.749   7.284  1.00 36.29           H 
ATOM   1524 1HH2 ARG    97     -23.519  18.578   3.938  1.00 36.29           H 
ATOM   1525 2HH2 ARG    97     -24.400  19.396   5.185  1.00 36.29           H 
ATOM   1526  N   ARG    98     -19.806  14.050   1.935  1.00 62.12           N 
ATOM   1527  CA  ARG    98     -20.482  13.349   0.830  1.00 55.01           C 
ATOM   1528  C   ARG    98     -19.751  12.044   0.482  1.00  3.21           C 
ATOM   1529  O   ARG    98     -20.380  11.035   0.162  1.00 61.24           O 
ATOM   1530  CB  ARG    98     -20.625  14.236  -0.421  1.00 33.50           C 
ATOM   1531  CG  ARG    98     -21.639  15.373  -0.262  1.00 43.41           C 
ATOM   1532  CD  ARG    98     -21.034  16.611   0.389  1.00 13.11           C 
ATOM   1533  NE  ARG    98     -20.195  17.358  -0.542  1.00 50.33           N 
ATOM   1534  CZ  ARG    98     -19.689  18.532  -0.290  1.00 64.24           C 
ATOM   1535  NH1 ARG    98     -19.838  19.083   0.871  1.00  3.54           N 
ATOM   1536  NH2 ARG    98     -19.019  19.154  -1.203  1.00 71.21           N 
ATOM   1537  H   ARG    98     -19.350  14.902   1.768  1.00 36.29           H 
ATOM   1538  HA  ARG    98     -21.473  13.091   1.181  1.00 32.24           H 
ATOM   1539 3HB  ARG    98     -20.939  13.618  -1.252  1.00 36.29           H 
ATOM   1540 2HB  ARG    98     -19.662  14.668  -0.655  1.00 36.29           H 
ATOM   1541 3HG  ARG    98     -22.461  15.023   0.349  1.00 36.29           H 
ATOM   1542 2HG  ARG    98     -22.012  15.645  -1.238  1.00 36.29           H 
ATOM   1543 3HD  ARG    98     -20.434  16.305   1.235  1.00 36.29           H 
ATOM   1544 2HD  ARG    98     -21.834  17.252   0.731  1.00 36.29           H 
ATOM   1545  HE  ARG    98     -20.026  16.961  -1.422  1.00 13.21           H 
ATOM   1546 1HH1 ARG    98     -20.345  18.610   1.587  1.00 36.29           H 
ATOM   1547 2HH1 ARG    98     -19.436  19.980   1.050  1.00 36.29           H 
ATOM   1548 1HH2 ARG    98     -18.895  18.737  -2.100  1.00 36.29           H 
ATOM   1549 2HH2 ARG    98     -18.633  20.053  -1.007  1.00 36.29           H 
ATOM   1550  N   PHE    99     -18.419  12.069   0.562  1.00  1.52           N 
ATOM   1551  CA  PHE    99     -17.618  10.848   0.421  1.00 14.23           C 
ATOM   1552  C   PHE    99     -18.048   9.806   1.468  1.00  3.12           C 
ATOM   1553  O   PHE    99     -18.276   8.636   1.148  1.00 43.23           O 
ATOM   1554  CB  PHE    99     -16.122  11.175   0.572  1.00 22.30           C 
ATOM   1555  CG  PHE    99     -15.220   9.964   0.535  1.00 62.53           C 
ATOM   1556  CD1 PHE    99     -14.787   9.438  -0.674  1.00 42.43           C 
ATOM   1557  CD2 PHE    99     -14.806   9.350   1.711  1.00 75.53           C 
ATOM   1558  CE1 PHE    99     -13.964   8.330  -0.711  1.00 72.43           C 
ATOM   1559  CE2 PHE    99     -13.982   8.242   1.679  1.00 20.21           C 
ATOM   1560  CZ  PHE    99     -13.562   7.731   0.467  1.00 72.42           C 
ATOM   1561  H   PHE    99     -17.965  12.923   0.714  1.00 36.29           H 
ATOM   1562  HA  PHE    99     -17.796  10.446  -0.568  1.00 12.34           H 
ATOM   1563 3HB  PHE    99     -15.966  11.678   1.516  1.00 36.29           H 
ATOM   1564 2HB  PHE    99     -15.823  11.835  -0.231  1.00 36.29           H 
ATOM   1565  HD1 PHE    99     -15.099   9.905  -1.597  1.00 15.13           H 
ATOM   1566  HD2 PHE    99     -15.135   9.749   2.661  1.00 32.43           H 
ATOM   1567  HE1 PHE    99     -13.636   7.931  -1.661  1.00  0.33           H 
ATOM   1568  HE2 PHE    99     -13.669   7.775   2.601  1.00 65.04           H 
ATOM   1569  HZ  PHE    99     -12.918   6.864   0.441  1.00 12.14           H 
ATOM   1570  N   LEU   100     -18.162  10.248   2.723  1.00 42.30           N 
ATOM   1571  CA  LEU   100     -18.650   9.387   3.806  1.00  4.13           C 
ATOM   1572  C   LEU   100     -20.083   8.916   3.529  1.00 51.22           C 
ATOM   1573  O   LEU   100     -20.413   7.754   3.746  1.00  4.33           O 
ATOM   1574  CB  LEU   100     -18.603  10.130   5.151  1.00 24.23           C 
ATOM   1575  CG  LEU   100     -17.214  10.620   5.591  1.00 21.10           C 
ATOM   1576  CD1 LEU   100     -17.297  11.336   6.937  1.00 11.20           C 
ATOM   1577  CD2 LEU   100     -16.222   9.459   5.656  1.00 32.53           C 
ATOM   1578  H   LEU   100     -17.907  11.174   2.928  1.00 36.29           H 
ATOM   1579  HA  LEU   100     -18.001   8.523   3.859  1.00  2.21           H 
ATOM   1580 3HB  LEU   100     -18.987   9.470   5.917  1.00 36.29           H 
ATOM   1581 2HB  LEU   100     -19.259  10.989   5.082  1.00 36.29           H 
ATOM   1582  HG  LEU   100     -16.846  11.330   4.864  1.00 45.44           H 
ATOM   1583 1HD1 LEU   100     -17.651  10.649   7.693  1.00 36.29           H 
ATOM   1584 2HD1 LEU   100     -17.979  12.171   6.861  1.00 36.29           H 
ATOM   1585 3HD1 LEU   100     -16.316  11.698   7.212  1.00 36.29           H 
ATOM   1586 1HD2 LEU   100     -15.255   9.828   5.969  1.00 36.29           H 
ATOM   1587 2HD2 LEU   100     -16.132   9.004   4.680  1.00 36.29           H 
ATOM   1588 3HD2 LEU   100     -16.572   8.721   6.364  1.00 36.29           H 
ATOM   1589  N   PHE   101     -20.920   9.825   3.030  1.00 25.05           N 
ATOM   1590  CA  PHE   101     -22.321   9.517   2.717  1.00 22.40           C 
ATOM   1591  C   PHE   101     -22.424   8.284   1.810  1.00 32.10           C 
ATOM   1592  O   PHE   101     -23.216   7.374   2.069  1.00 63.25           O 
ATOM   1593  CB  PHE   101     -22.979  10.728   2.043  1.00 62.32           C 
ATOM   1594  CG  PHE   101     -24.419  10.516   1.638  1.00 44.44           C 
ATOM   1595  CD1 PHE   101     -24.744  10.119   0.345  1.00 11.13           C 
ATOM   1596  CD2 PHE   101     -25.447  10.716   2.547  1.00  3.51           C 
ATOM   1597  CE1 PHE   101     -26.062   9.928  -0.027  1.00 71.41           C 
ATOM   1598  CE2 PHE   101     -26.766  10.527   2.179  1.00 53.41           C 
ATOM   1599  CZ  PHE   101     -27.075  10.131   0.891  1.00 10.35           C 
ATOM   1600  H   PHE   101     -20.586  10.731   2.866  1.00 36.29           H 
ATOM   1601  HA  PHE   101     -22.830   9.310   3.648  1.00 74.20           H 
ATOM   1602 3HB  PHE   101     -22.417  10.980   1.154  1.00 36.29           H 
ATOM   1603 2HB  PHE   101     -22.947  11.566   2.724  1.00 36.29           H 
ATOM   1604  HD1 PHE   101     -23.954   9.957  -0.374  1.00  1.30           H 
ATOM   1605  HD2 PHE   101     -25.212  11.026   3.556  1.00 41.52           H 
ATOM   1606  HE1 PHE   101     -26.301   9.619  -1.036  1.00 14.35           H 
ATOM   1607  HE2 PHE   101     -27.556  10.687   2.900  1.00 15.01           H 
ATOM   1608  HZ  PHE   101     -28.106   9.983   0.604  1.00 60.20           H 
ATOM   1609  N   ARG   102     -21.614   8.258   0.753  1.00 23.35           N 
ATOM   1610  CA  ARG   102     -21.536   7.094  -0.134  1.00 23.31           C 
ATOM   1611  C   ARG   102     -21.221   5.817   0.657  1.00 61.20           C 
ATOM   1612  O   ARG   102     -21.913   4.811   0.529  1.00  4.51           O 
ATOM   1613  CB  ARG   102     -20.459   7.310  -1.207  1.00 65.14           C 
ATOM   1614  CG  ARG   102     -20.798   8.403  -2.213  1.00 73.23           C 
ATOM   1615  CD  ARG   102     -22.003   8.029  -3.071  1.00  0.12           C 
ATOM   1616  NE  ARG   102     -22.336   9.077  -4.032  1.00 33.22           N 
ATOM   1617  CZ  ARG   102     -22.683   8.860  -5.272  1.00 43.40           C 
ATOM   1618  NH1 ARG   102     -22.703   7.655  -5.753  1.00  1.11           N 
ATOM   1619  NH2 ARG   102     -22.993   9.855  -6.034  1.00 44.44           N 
ATOM   1620  H   ARG   102     -21.055   9.043   0.563  1.00 36.29           H 
ATOM   1621  HA  ARG   102     -22.497   6.979  -0.618  1.00 14.34           H 
ATOM   1622 3HB  ARG   102     -20.315   6.384  -1.750  1.00 36.29           H 
ATOM   1623 2HB  ARG   102     -19.533   7.576  -0.719  1.00 36.29           H 
ATOM   1624 3HG  ARG   102     -19.945   8.563  -2.859  1.00 36.29           H 
ATOM   1625 2HG  ARG   102     -21.019   9.316  -1.679  1.00 36.29           H 
ATOM   1626 3HD  ARG   102     -22.854   7.865  -2.423  1.00 36.29           H 
ATOM   1627 2HD  ARG   102     -21.780   7.116  -3.605  1.00 36.29           H 
ATOM   1628  HE  ARG   102     -22.307  10.004  -3.716  1.00 40.12           H 
ATOM   1629 1HH1 ARG   102     -22.449   6.881  -5.177  1.00 36.29           H 
ATOM   1630 2HH1 ARG   102     -22.973   7.501  -6.702  1.00 36.29           H 
ATOM   1631 1HH2 ARG   102     -22.969  10.786  -5.671  1.00 36.29           H 
ATOM   1632 2HH2 ARG   102     -23.254   9.695  -6.984  1.00 36.29           H 
ATOM   1633  N   MET   103     -20.186   5.883   1.488  1.00 12.52           N 
ATOM   1634  CA  MET   103     -19.735   4.728   2.273  1.00 72.25           C 
ATOM   1635  C   MET   103     -20.818   4.229   3.246  1.00  2.14           C 
ATOM   1636  O   MET   103     -21.065   3.023   3.350  1.00 24.21           O 
ATOM   1637  CB  MET   103     -18.454   5.093   3.030  1.00 24.22           C 
ATOM   1638  CG  MET   103     -17.340   5.557   2.103  1.00 44.15           C 
ATOM   1639  SD  MET   103     -17.028   4.377   0.772  1.00 62.20           S 
ATOM   1640  CE  MET   103     -16.022   5.358  -0.338  1.00 74.41           C 
ATOM   1641  H   MET   103     -19.708   6.735   1.580  1.00 36.29           H 
ATOM   1642  HA  MET   103     -19.509   3.931   1.578  1.00  4.15           H 
ATOM   1643 3HB  MET   103     -18.106   4.228   3.575  1.00 36.29           H 
ATOM   1644 2HB  MET   103     -18.673   5.889   3.730  1.00 36.29           H 
ATOM   1645 3HG  MET   103     -16.432   5.681   2.679  1.00 36.29           H 
ATOM   1646 2HG  MET   103     -17.621   6.505   1.667  1.00 36.29           H 
ATOM   1647 1HE  MET   103     -15.753   4.765  -1.199  1.00 36.29           H 
ATOM   1648 2HE  MET   103     -15.127   5.675   0.174  1.00 36.29           H 
ATOM   1649 3HE  MET   103     -16.579   6.226  -0.659  1.00 36.29           H 
ATOM   1650  N   LYS   104     -21.477   5.159   3.936  1.00 52.44           N 
ATOM   1651  CA  LYS   104     -22.549   4.815   4.877  1.00 31.44           C 
ATOM   1652  C   LYS   104     -23.705   4.105   4.153  1.00 43.24           C 
ATOM   1653  O   LYS   104     -24.244   3.104   4.634  1.00 41.13           O 
ATOM   1654  CB  LYS   104     -23.070   6.081   5.579  1.00 61.35           C 
ATOM   1655  CG  LYS   104     -21.973   6.933   6.218  1.00 50.22           C 
ATOM   1656  CD  LYS   104     -22.539   8.142   6.969  1.00 61.35           C 
ATOM   1657  CE  LYS   104     -22.892   7.817   8.420  1.00 53.34           C 
ATOM   1658  NZ  LYS   104     -23.861   6.695   8.543  1.00 30.53           N 
ATOM   1659  H   LYS   104     -21.233   6.099   3.812  1.00 36.29           H 
ATOM   1660  HA  LYS   104     -22.137   4.144   5.619  1.00 41.12           H 
ATOM   1661 3HB  LYS   104     -23.764   5.787   6.354  1.00 36.29           H 
ATOM   1662 2HB  LYS   104     -23.593   6.691   4.855  1.00 36.29           H 
ATOM   1663 3HG  LYS   104     -21.309   7.283   5.442  1.00 36.29           H 
ATOM   1664 2HG  LYS   104     -21.415   6.319   6.912  1.00 36.29           H 
ATOM   1665 3HD  LYS   104     -23.431   8.483   6.461  1.00 36.29           H 
ATOM   1666 2HD  LYS   104     -21.802   8.934   6.964  1.00 36.29           H 
ATOM   1667 3HE  LYS   104     -23.319   8.698   8.877  1.00 36.29           H 
ATOM   1668 2HE  LYS   104     -21.987   7.549   8.944  1.00 36.29           H 
ATOM   1669 1HZ  LYS   104     -23.460   5.824   8.137  1.00 36.29           H 
ATOM   1670 2HZ  LYS   104     -24.742   6.924   8.043  1.00 36.29           H 
ATOM   1671 3HZ  LYS   104     -24.080   6.523   9.545  1.00 36.29           H 
ATOM   1672  N   ASN   105     -24.075   4.625   2.986  1.00 31.44           N 
ATOM   1673  CA  ASN   105     -25.150   4.039   2.179  1.00 20.54           C 
ATOM   1674  C   ASN   105     -24.684   2.767   1.446  1.00 62.14           C 
ATOM   1675  O   ASN   105     -25.498   1.920   1.088  1.00 23.42           O 
ATOM   1676  CB  ASN   105     -25.686   5.077   1.183  1.00 52.13           C 
ATOM   1677  CG  ASN   105     -26.582   6.111   1.848  1.00 71.04           C 
ATOM   1678  OD1 ASN   105     -27.800   5.955   1.901  1.00  2.24           O 
ATOM   1679  ND2 ASN   105     -25.995   7.167   2.371  1.00 13.41           N 
ATOM   1680  H   ASN   105     -23.611   5.424   2.654  1.00 36.29           H 
ATOM   1681  HA  ASN   105     -25.950   3.764   2.854  1.00 51.30           H 
ATOM   1682 3HB  ASN   105     -26.259   4.573   0.415  1.00 36.29           H 
ATOM   1683 2HB  ASN   105     -24.854   5.590   0.725  1.00 36.29           H 
ATOM   1684 1HD2 ASN   105     -25.024   7.236   2.304  1.00 36.29           H 
ATOM   1685 2HD2 ASN   105     -26.558   7.835   2.813  1.00 36.29           H 
ATOM   1686  N   LEU   106     -23.375   2.636   1.222  1.00 21.42           N 
ATOM   1687  CA  LEU   106     -22.816   1.444   0.563  1.00 42.00           C 
ATOM   1688  C   LEU   106     -22.699   0.252   1.528  1.00 44.44           C 
ATOM   1689  O   LEU   106     -22.835  -0.898   1.110  1.00 43.31           O 
ATOM   1690  CB  LEU   106     -21.445   1.755  -0.071  1.00 52.23           C 
ATOM   1691  CG  LEU   106     -21.443   1.918  -1.603  1.00 73.13           C 
ATOM   1692  CD1 LEU   106     -21.900   0.628  -2.282  1.00 25.24           C 
ATOM   1693  CD2 LEU   106     -22.324   3.088  -2.033  1.00  3.23           C 
ATOM   1694  H   LEU   106     -22.770   3.358   1.496  1.00 36.29           H 
ATOM   1695  HA  LEU   106     -23.502   1.167  -0.226  1.00 11.44           H 
ATOM   1696 3HB  LEU   106     -20.760   0.956   0.180  1.00 36.29           H 
ATOM   1697 2HB  LEU   106     -21.070   2.671   0.366  1.00 36.29           H 
ATOM   1698  HG  LEU   106     -20.432   2.124  -1.933  1.00 24.21           H 
ATOM   1699 1HD1 LEU   106     -21.863   0.753  -3.355  1.00 36.29           H 
ATOM   1700 2HD1 LEU   106     -22.914   0.401  -1.983  1.00 36.29           H 
ATOM   1701 3HD1 LEU   106     -21.250  -0.184  -1.992  1.00 36.29           H 
ATOM   1702 1HD2 LEU   106     -22.302   3.179  -3.108  1.00 36.29           H 
ATOM   1703 2HD2 LEU   106     -21.955   4.002  -1.588  1.00 36.29           H 
ATOM   1704 3HD2 LEU   106     -23.341   2.915  -1.706  1.00 36.29           H 
ATOM   1705  N   GLY   107     -22.443   0.524   2.808  1.00  4.41           N 
ATOM   1706  CA  GLY   107     -22.387  -0.549   3.803  1.00 75.00           C 
ATOM   1707  C   GLY   107     -21.149  -0.519   4.700  1.00 52.23           C 
ATOM   1708  O   GLY   107     -21.050  -1.299   5.650  1.00 74.33           O 
ATOM   1709  H   GLY   107     -22.303   1.456   3.083  1.00 36.29           H 
ATOM   1710 3HA  GLY   107     -22.415  -1.503   3.292  1.00 36.29           H 
ATOM   1711 2HA  GLY   107     -23.262  -0.474   4.431  1.00 36.29           H 
ATOM   1712  N   ILE   108     -20.204   0.376   4.419  1.00 20.43           N 
ATOM   1713  CA  ILE   108     -18.974   0.469   5.217  1.00 25.42           C 
ATOM   1714  C   ILE   108     -19.059   1.595   6.264  1.00 11.24           C 
ATOM   1715  O   ILE   108     -18.589   2.710   6.045  1.00  1.10           O 
ATOM   1716  CB  ILE   108     -17.688   0.643   4.345  1.00 45.21           C 
ATOM   1717  CG1 ILE   108     -17.897   1.640   3.187  1.00 21.42           C 
ATOM   1718  CG2 ILE   108     -17.203  -0.706   3.815  1.00 34.33           C 
ATOM   1719  CD1 ILE   108     -18.544   1.050   1.944  1.00  2.54           C 
ATOM   1720  H   ILE   108     -20.345   1.003   3.682  1.00 36.29           H 
ATOM   1721  HA  ILE   108     -18.876  -0.468   5.753  1.00 13.33           H 
ATOM   1722  HB  ILE   108     -16.911   1.029   4.991  1.00 72.34           H 
ATOM   1723 3HG1 ILE   108     -16.937   2.045   2.896  1.00 36.29           H 
ATOM   1724 2HG1 ILE   108     -18.527   2.450   3.527  1.00 36.29           H 
ATOM   1725 1HG2 ILE   108     -16.975  -1.359   4.646  1.00 36.29           H 
ATOM   1726 2HG2 ILE   108     -16.312  -0.561   3.220  1.00 36.29           H 
ATOM   1727 3HG2 ILE   108     -17.973  -1.156   3.206  1.00 36.29           H 
ATOM   1728 1HD1 ILE   108     -19.481   0.582   2.206  1.00 36.29           H 
ATOM   1729 2HD1 ILE   108     -17.883   0.316   1.509  1.00 36.29           H 
ATOM   1730 3HD1 ILE   108     -18.726   1.838   1.228  1.00 36.29           H 
ATOM   1731  N   GLU   109     -19.687   1.289   7.400  1.00 14.42           N 
ATOM   1732  CA  GLU   109     -19.801   2.238   8.518  1.00 50.05           C 
ATOM   1733  C   GLU   109     -18.596   2.127   9.468  1.00  1.42           C 
ATOM   1734  O   GLU   109     -17.716   2.992   9.483  1.00  4.22           O 
ATOM   1735  CB  GLU   109     -21.106   1.977   9.291  1.00  3.31           C 
ATOM   1736  CG  GLU   109     -22.377   2.245   8.484  1.00 43.33           C 
ATOM   1737  CD  GLU   109     -22.791   3.711   8.481  1.00  3.32           C 
ATOM   1738  OE1 GLU   109     -21.915   4.593   8.387  1.00 72.11           O 
ATOM   1739  OE2 GLU   109     -24.007   3.992   8.566  1.00  1.44           O 
ATOM   1740  H   GLU   109     -20.100   0.406   7.486  1.00 36.29           H 
ATOM   1741  HA  GLU   109     -19.831   3.239   8.107  1.00 55.04           H 
ATOM   1742 3HB  GLU   109     -21.124   2.609  10.170  1.00 36.29           H 
ATOM   1743 2HB  GLU   109     -21.119   0.946   9.605  1.00 36.29           H 
ATOM   1744 3HG  GLU   109     -23.181   1.659   8.909  1.00 36.29           H 
ATOM   1745 2HG  GLU   109     -22.213   1.933   7.463  1.00 36.29           H 
ATOM   1746  N   SER   110     -18.565   1.053  10.262  1.00 74.22           N 
ATOM   1747  CA  SER   110     -17.453   0.801  11.195  1.00  3.13           C 
ATOM   1748  C   SER   110     -17.450  -0.658  11.674  1.00  5.11           C 
ATOM   1749  O   SER   110     -18.506  -1.248  11.904  1.00 60.41           O 
ATOM   1750  CB  SER   110     -17.540   1.734  12.410  1.00 63.23           C 
ATOM   1751  OG  SER   110     -18.701   1.469  13.185  1.00 53.02           O 
ATOM   1752  H   SER   110     -19.312   0.418  10.232  1.00 36.29           H 
ATOM   1753  HA  SER   110     -16.529   0.997  10.666  1.00 72.12           H 
ATOM   1754 3HB  SER   110     -17.577   2.760  12.072  1.00 36.29           H 
ATOM   1755 2HB  SER   110     -16.669   1.595  13.035  1.00 36.29           H 
ATOM   1756  HG  SER   110     -18.448   1.331  14.105  1.00  0.43           H 
ATOM   1757  N   GLY   111     -16.258  -1.245  11.800  1.00  4.32           N 
ATOM   1758  CA  GLY   111     -16.133  -2.618  12.298  1.00 61.43           C 
ATOM   1759  C   GLY   111     -16.562  -3.693  11.296  1.00 32.32           C 
ATOM   1760  O   GLY   111     -16.359  -4.884  11.537  1.00 51.22           O 
ATOM   1761  H   GLY   111     -15.451  -0.741  11.562  1.00 36.29           H 
ATOM   1762 3HA  GLY   111     -16.736  -2.717  13.191  1.00 36.29           H 
ATOM   1763 2HA  GLY   111     -15.101  -2.790  12.563  1.00 36.29           H 
ATOM   1764  N   LYS   112     -17.154  -3.275  10.176  1.00  3.11           N 
ATOM   1765  CA  LYS   112     -17.630  -4.205   9.140  1.00 34.24           C 
ATOM   1766  C   LYS   112     -16.499  -5.083   8.579  1.00 41.42           C 
ATOM   1767  O   LYS   112     -15.406  -4.595   8.279  1.00  3.25           O 
ATOM   1768  CB  LYS   112     -18.284  -3.424   7.988  1.00 61.22           C 
ATOM   1769  CG  LYS   112     -19.630  -2.792   8.335  1.00 31.01           C 
ATOM   1770  CD  LYS   112     -20.692  -3.852   8.620  1.00 72.52           C 
ATOM   1771  CE  LYS   112     -22.077  -3.237   8.779  1.00 40.15           C 
ATOM   1772  NZ  LYS   112     -23.106  -4.266   9.079  1.00 34.21           N 
ATOM   1773  H   LYS   112     -17.277  -2.317  10.042  1.00 36.29           H 
ATOM   1774  HA  LYS   112     -18.374  -4.844   9.592  1.00 34.15           H 
ATOM   1775 3HB  LYS   112     -18.433  -4.096   7.154  1.00 36.29           H 
ATOM   1776 2HB  LYS   112     -17.612  -2.634   7.680  1.00 36.29           H 
ATOM   1777 3HG  LYS   112     -19.955  -2.184   7.501  1.00 36.29           H 
ATOM   1778 2HG  LYS   112     -19.509  -2.169   9.210  1.00 36.29           H 
ATOM   1779 3HD  LYS   112     -20.434  -4.374   9.532  1.00 36.29           H 
ATOM   1780 2HD  LYS   112     -20.717  -4.554   7.800  1.00 36.29           H 
ATOM   1781 3HE  LYS   112     -22.342  -2.732   7.860  1.00 36.29           H 
ATOM   1782 2HE  LYS   112     -22.051  -2.523   9.587  1.00 36.29           H 
ATOM   1783 1HZ  LYS   112     -22.943  -4.671  10.025  1.00 36.29           H 
ATOM   1784 2HZ  LYS   112     -23.065  -5.032   8.376  1.00 36.29           H 
ATOM   1785 3HZ  LYS   112     -24.052  -3.841   9.057  1.00 36.29           H 
ATOM   1786  N   LYS   113     -16.779  -6.379   8.432  1.00 22.32           N 
ATOM   1787  CA  LYS   113     -15.829  -7.313   7.820  1.00 63.22           C 
ATOM   1788  C   LYS   113     -15.988  -7.337   6.293  1.00 23.13           C 
ATOM   1789  O   LYS   113     -16.949  -7.896   5.759  1.00 61.52           O 
ATOM   1790  CB  LYS   113     -15.994  -8.726   8.407  1.00  2.21           C 
ATOM   1791  CG  LYS   113     -15.299  -8.923   9.757  1.00 33.44           C 
ATOM   1792  CD  LYS   113     -15.792  -7.940  10.821  1.00 54.34           C 
ATOM   1793  CE  LYS   113     -15.025  -8.083  12.130  1.00  4.32           C 
ATOM   1794  NZ  LYS   113     -15.512  -7.131  13.161  1.00 54.11           N 
ATOM   1795  H   LYS   113     -17.644  -6.720   8.747  1.00 36.29           H 
ATOM   1796  HA  LYS   113     -14.834  -6.959   8.052  1.00 65.00           H 
ATOM   1797 3HB  LYS   113     -15.582  -9.444   7.711  1.00 36.29           H 
ATOM   1798 2HB  LYS   113     -17.047  -8.932   8.535  1.00 36.29           H 
ATOM   1799 3HG  LYS   113     -14.234  -8.788   9.621  1.00 36.29           H 
ATOM   1800 2HG  LYS   113     -15.489  -9.930  10.101  1.00 36.29           H 
ATOM   1801 3HD  LYS   113     -16.841  -8.123  11.006  1.00 36.29           H 
ATOM   1802 2HD  LYS   113     -15.663  -6.932  10.453  1.00 36.29           H 
ATOM   1803 3HE  LYS   113     -13.977  -7.892  11.945  1.00 36.29           H 
ATOM   1804 2HE  LYS   113     -15.146  -9.090  12.499  1.00 36.29           H 
ATOM   1805 1HZ  LYS   113     -15.522  -6.165  12.778  1.00 36.29           H 
ATOM   1806 2HZ  LYS   113     -14.886  -7.154  13.991  1.00 36.29           H 
ATOM   1807 3HZ  LYS   113     -16.475  -7.385  13.461  1.00 36.29           H 
ATOM   1808  N   ILE   114     -15.030  -6.725   5.601  1.00 74.14           N 
ATOM   1809  CA  ILE   114     -15.084  -6.570   4.145  1.00  2.33           C 
ATOM   1810  C   ILE   114     -14.092  -7.515   3.433  1.00 44.51           C 
ATOM   1811  O   ILE   114     -12.929  -7.631   3.823  1.00 10.11           O 
ATOM   1812  CB  ILE   114     -14.806  -5.094   3.754  1.00 75.45           C 
ATOM   1813  CG1 ILE   114     -15.044  -4.862   2.251  1.00 52.12           C 
ATOM   1814  CG2 ILE   114     -13.387  -4.676   4.149  1.00 50.24           C 
ATOM   1815  CD1 ILE   114     -15.046  -3.397   1.856  1.00 54.51           C 
ATOM   1816  H   ILE   114     -14.261  -6.363   6.088  1.00 36.29           H 
ATOM   1817  HA  ILE   114     -16.087  -6.818   3.823  1.00 40.45           H 
ATOM   1818  HB  ILE   114     -15.493  -4.473   4.313  1.00  4.51           H 
ATOM   1819 3HG1 ILE   114     -16.002  -5.278   1.977  1.00 36.29           H 
ATOM   1820 2HG1 ILE   114     -14.268  -5.357   1.685  1.00 36.29           H 
ATOM   1821 1HG2 ILE   114     -13.260  -4.793   5.216  1.00 36.29           H 
ATOM   1822 2HG2 ILE   114     -13.224  -3.642   3.880  1.00 36.29           H 
ATOM   1823 3HG2 ILE   114     -12.670  -5.299   3.633  1.00 36.29           H 
ATOM   1824 1HD1 ILE   114     -14.090  -2.956   2.098  1.00 36.29           H 
ATOM   1825 2HD1 ILE   114     -15.828  -2.878   2.392  1.00 36.29           H 
ATOM   1826 3HD1 ILE   114     -15.222  -3.312   0.794  1.00 36.29           H 
ATOM   1827  N   GLN   115     -14.574  -8.211   2.405  1.00  1.25           N 
ATOM   1828  CA  GLN   115     -13.751  -9.165   1.648  1.00 51.53           C 
ATOM   1829  C   GLN   115     -13.154  -8.520   0.389  1.00 75.21           C 
ATOM   1830  O   GLN   115     -13.791  -7.684  -0.255  1.00 13.35           O 
ATOM   1831  CB  GLN   115     -14.577 -10.397   1.244  1.00 52.33           C 
ATOM   1832  CG  GLN   115     -15.051 -11.264   2.410  1.00 22.45           C 
ATOM   1833  CD  GLN   115     -16.130 -10.612   3.259  1.00 10.23           C 
ATOM   1834  OE1 GLN   115     -17.318 -10.739   2.985  1.00 63.13           O 
ATOM   1835  NE2 GLN   115     -15.733  -9.933   4.312  1.00 14.31           N 
ATOM   1836  H   GLN   115     -15.512  -8.084   2.150  1.00 36.29           H 
ATOM   1837  HA  GLN   115     -12.940  -9.484   2.291  1.00 73.32           H 
ATOM   1838 3HB  GLN   115     -13.976 -11.016   0.591  1.00 36.29           H 
ATOM   1839 2HB  GLN   115     -15.449 -10.065   0.699  1.00 36.29           H 
ATOM   1840 3HG  GLN   115     -14.202 -11.486   3.042  1.00 36.29           H 
ATOM   1841 2HG  GLN   115     -15.444 -12.189   2.013  1.00 36.29           H 
ATOM   1842 1HE2 GLN   115     -14.776  -9.884   4.493  1.00 36.29           H 
ATOM   1843 2HE2 GLN   115     -16.416  -9.501   4.866  1.00 36.29           H 
ATOM   1844  N   VAL   116     -11.934  -8.924   0.035  1.00  5.30           N 
ATOM   1845  CA  VAL   116     -11.244  -8.398  -1.153  1.00 24.20           C 
ATOM   1846  C   VAL   116     -11.268  -9.405  -2.321  1.00 21.53           C 
ATOM   1847  O   VAL   116     -10.779 -10.529  -2.193  1.00 13.22           O 
ATOM   1848  CB  VAL   116      -9.771  -8.041  -0.822  1.00 43.21           C 
ATOM   1849  CG1 VAL   116      -9.035  -7.525  -2.059  1.00 45.14           C 
ATOM   1850  CG2 VAL   116      -9.703  -7.018   0.312  1.00 43.24           C 
ATOM   1851  H   VAL   116     -11.477  -9.594   0.590  1.00 36.29           H 
ATOM   1852  HA  VAL   116     -11.751  -7.491  -1.463  1.00 33.34           H 
ATOM   1853  HB  VAL   116      -9.273  -8.943  -0.491  1.00 74.23           H 
ATOM   1854 1HG1 VAL   116      -9.523  -6.632  -2.425  1.00 36.29           H 
ATOM   1855 2HG1 VAL   116      -9.048  -8.282  -2.830  1.00 36.29           H 
ATOM   1856 3HG1 VAL   116      -8.013  -7.293  -1.801  1.00 36.29           H 
ATOM   1857 1HG2 VAL   116     -10.200  -7.414   1.186  1.00 36.29           H 
ATOM   1858 2HG2 VAL   116     -10.191  -6.104   0.005  1.00 36.29           H 
ATOM   1859 3HG2 VAL   116      -8.669  -6.809   0.551  1.00 36.29           H 
ATOM   1860  N   SER   117     -11.834  -8.991  -3.459  1.00 32.24           N 
ATOM   1861  CA  SER   117     -11.877  -9.838  -4.666  1.00 71.32           C 
ATOM   1862  C   SER   117     -11.781  -8.999  -5.949  1.00 31.01           C 
ATOM   1863  O   SER   117     -12.653  -8.179  -6.231  1.00 51.43           O 
ATOM   1864  CB  SER   117     -13.166 -10.671  -4.702  1.00 71.42           C 
ATOM   1865  OG  SER   117     -13.264 -11.424  -5.904  1.00 75.11           O 
ATOM   1866  H   SER   117     -12.243  -8.099  -3.491  1.00 36.29           H 
ATOM   1867  HA  SER   117     -11.028 -10.510  -4.630  1.00 41.04           H 
ATOM   1868 3HB  SER   117     -14.019 -10.012  -4.635  1.00 36.29           H 
ATOM   1869 2HB  SER   117     -13.173 -11.353  -3.867  1.00 36.29           H 
ATOM   1870  HG  SER   117     -14.120 -11.872  -5.932  1.00 73.31           H 
ATOM   1871  N   GLY   118     -10.717  -9.213  -6.719  1.00 33.21           N 
ATOM   1872  CA  GLY   118     -10.530  -8.493  -7.977  1.00 12.42           C 
ATOM   1873  C   GLY   118     -10.578  -6.971  -7.828  1.00 74.20           C 
ATOM   1874  O   GLY   118      -9.735  -6.377  -7.158  1.00 20.33           O 
ATOM   1875  H   GLY   118     -10.053  -9.876  -6.438  1.00 36.29           H 
ATOM   1876 3HA  GLY   118     -11.303  -8.800  -8.669  1.00 36.29           H 
ATOM   1877 2HA  GLY   118      -9.571  -8.769  -8.390  1.00 36.29           H 
ATOM   1878  N   ARG   119     -11.570  -6.342  -8.460  1.00 25.32           N 
ATOM   1879  CA  ARG   119     -11.739  -4.883  -8.395  1.00 34.22           C 
ATOM   1880  C   ARG   119     -13.046  -4.488  -7.683  1.00  2.21           C 
ATOM   1881  O   ARG   119     -13.582  -3.404  -7.913  1.00 13.21           O 
ATOM   1882  CB  ARG   119     -11.711  -4.285  -9.810  1.00 42.40           C 
ATOM   1883  CG  ARG   119     -10.351  -4.386 -10.497  1.00 71.15           C 
ATOM   1884  CD  ARG   119      -9.283  -3.580  -9.762  1.00 32.30           C 
ATOM   1885  NE  ARG   119      -7.979  -3.672 -10.415  1.00 24.14           N 
ATOM   1886  CZ  ARG   119      -6.876  -3.167  -9.934  1.00 45.15           C 
ATOM   1887  NH1 ARG   119      -6.883  -2.491  -8.831  1.00 23.21           N 
ATOM   1888  NH2 ARG   119      -5.766  -3.322 -10.573  1.00 61.32           N 
ATOM   1889  H   ARG   119     -12.206  -6.872  -8.987  1.00 36.29           H 
ATOM   1890  HA  ARG   119     -10.909  -4.478  -7.832  1.00 21.42           H 
ATOM   1891 3HB  ARG   119     -11.984  -3.241  -9.755  1.00 36.29           H 
ATOM   1892 2HB  ARG   119     -12.437  -4.803 -10.422  1.00 36.29           H 
ATOM   1893 3HG  ARG   119     -10.439  -4.013 -11.507  1.00 36.29           H 
ATOM   1894 2HG  ARG   119     -10.047  -5.424 -10.522  1.00 36.29           H 
ATOM   1895 3HD  ARG   119      -9.198  -3.958  -8.751  1.00 36.29           H 
ATOM   1896 2HD  ARG   119      -9.590  -2.545  -9.734  1.00 36.29           H 
ATOM   1897  HE  ARG   119      -7.934  -4.155 -11.265  1.00 73.21           H 
ATOM   1898 1HH1 ARG   119      -7.737  -2.351  -8.338  1.00 36.29           H 
ATOM   1899 2HH1 ARG   119      -6.030  -2.114  -8.478  1.00 36.29           H 
ATOM   1900 1HH2 ARG   119      -5.751  -3.827 -11.434  1.00 36.29           H 
ATOM   1901 2HH2 ARG   119      -4.922  -2.939 -10.202  1.00 36.29           H 
ATOM   1902  N   ARG   120     -13.549  -5.366  -6.814  1.00 13.33           N 
ATOM   1903  CA  ARG   120     -14.733  -5.051  -6.004  1.00 42.34           C 
ATOM   1904  C   ARG   120     -14.646  -5.711  -4.618  1.00  2.33           C 
ATOM   1905  O   ARG   120     -14.144  -6.826  -4.471  1.00 12.04           O 
ATOM   1906  CB  ARG   120     -16.037  -5.467  -6.719  1.00  1.04           C 
ATOM   1907  CG  ARG   120     -16.304  -6.973  -6.772  1.00 73.22           C 
ATOM   1908  CD  ARG   120     -15.361  -7.713  -7.714  1.00 13.13           C 
ATOM   1909  NE  ARG   120     -15.606  -9.153  -7.688  1.00 42.00           N 
ATOM   1910  CZ  ARG   120     -15.171  -9.996  -8.582  1.00  4.14           C 
ATOM   1911  NH1 ARG   120     -14.451  -9.599  -9.583  1.00 52.34           N 
ATOM   1912  NH2 ARG   120     -15.455 -11.249  -8.463  1.00 14.03           N 
ATOM   1913  H   ARG   120     -13.113  -6.240  -6.707  1.00 36.29           H 
ATOM   1914  HA  ARG   120     -14.746  -3.977  -5.863  1.00 23.42           H 
ATOM   1915 3HB  ARG   120     -16.001  -5.097  -7.736  1.00 36.29           H 
ATOM   1916 2HB  ARG   120     -16.870  -5.000  -6.213  1.00 36.29           H 
ATOM   1917 3HG  ARG   120     -17.322  -7.130  -7.106  1.00 36.29           H 
ATOM   1918 2HG  ARG   120     -16.190  -7.382  -5.779  1.00 36.29           H 
ATOM   1919 3HD  ARG   120     -14.340  -7.525  -7.412  1.00 36.29           H 
ATOM   1920 2HD  ARG   120     -15.514  -7.346  -8.720  1.00 36.29           H 
ATOM   1921  HE  ARG   120     -16.141  -9.504  -6.947  1.00 73.14           H 
ATOM   1922 1HH1 ARG   120     -14.218  -8.637  -9.681  1.00 36.29           H 
ATOM   1923 2HH1 ARG   120     -14.127 -10.264 -10.254  1.00 36.29           H 
ATOM   1924 1HH2 ARG   120     -15.997 -11.567  -7.686  1.00 36.29           H 
ATOM   1925 2HH2 ARG   120     -15.140 -11.897  -9.151  1.00 36.29           H 
ATOM   1926  N   TYR   121     -15.137  -5.016  -3.602  1.00 61.44           N 
ATOM   1927  CA  TYR   121     -15.057  -5.499  -2.222  1.00 32.34           C 
ATOM   1928  C   TYR   121     -16.448  -5.885  -1.695  1.00  1.31           C 
ATOM   1929  O   TYR   121     -17.450  -5.283  -2.075  1.00 44.54           O 
ATOM   1930  CB  TYR   121     -14.417  -4.424  -1.344  1.00 31.21           C 
ATOM   1931  CG  TYR   121     -13.079  -3.945  -1.877  1.00 42.15           C 
ATOM   1932  CD1 TYR   121     -12.994  -2.810  -2.676  1.00 22.22           C 
ATOM   1933  CD2 TYR   121     -11.906  -4.634  -1.594  1.00 22.31           C 
ATOM   1934  CE1 TYR   121     -11.781  -2.375  -3.174  1.00 31.53           C 
ATOM   1935  CE2 TYR   121     -10.689  -4.204  -2.089  1.00 43.00           C 
ATOM   1936  CZ  TYR   121     -10.632  -3.074  -2.881  1.00  2.42           C 
ATOM   1937  OH  TYR   121      -9.422  -2.638  -3.372  1.00 23.02           O 
ATOM   1938  H   TYR   121     -15.566  -4.155  -3.780  1.00 36.29           H 
ATOM   1939  HA  TYR   121     -14.427  -6.380  -2.211  1.00 55.21           H 
ATOM   1940 3HB  TYR   121     -14.258  -4.820  -0.351  1.00 36.29           H 
ATOM   1941 2HB  TYR   121     -15.080  -3.571  -1.285  1.00 36.29           H 
ATOM   1942  HD1 TYR   121     -13.895  -2.262  -2.907  1.00 60.30           H 
ATOM   1943  HD2 TYR   121     -11.951  -5.517  -0.975  1.00 15.43           H 
ATOM   1944  HE1 TYR   121     -11.738  -1.491  -3.792  1.00 70.53           H 
ATOM   1945  HE2 TYR   121      -9.787  -4.756  -1.858  1.00  2.23           H 
ATOM   1946  HH  TYR   121      -8.912  -3.391  -3.682  1.00 11.12           H 
ATOM   1947  N   TYR   122     -16.508  -6.891  -0.824  1.00 71.12           N 
ATOM   1948  CA  TYR   122     -17.792  -7.460  -0.385  1.00  4.51           C 
ATOM   1949  C   TYR   122     -18.089  -7.192   1.101  1.00 13.21           C 
ATOM   1950  O   TYR   122     -17.336  -7.607   1.982  1.00  0.03           O 
ATOM   1951  CB  TYR   122     -17.802  -8.974  -0.641  1.00 41.43           C 
ATOM   1952  CG  TYR   122     -17.747  -9.356  -2.112  1.00 23.53           C 
ATOM   1953  CD1 TYR   122     -16.604  -9.120  -2.870  1.00 42.45           C 
ATOM   1954  CD2 TYR   122     -18.835  -9.954  -2.740  1.00 52.10           C 
ATOM   1955  CE1 TYR   122     -16.549  -9.467  -4.203  1.00 23.30           C 
ATOM   1956  CE2 TYR   122     -18.784 -10.306  -4.077  1.00  0.13           C 
ATOM   1957  CZ  TYR   122     -17.638 -10.058  -4.803  1.00 42.13           C 
ATOM   1958  OH  TYR   122     -17.582 -10.400  -6.136  1.00 14.43           O 
ATOM   1959  H   TYR   122     -15.673  -7.263  -0.471  1.00 36.29           H 
ATOM   1960  HA  TYR   122     -18.576  -7.007  -0.979  1.00 54.24           H 
ATOM   1961 3HB  TYR   122     -18.702  -9.398  -0.219  1.00 36.29           H 
ATOM   1962 2HB  TYR   122     -16.943  -9.417  -0.153  1.00 36.29           H 
ATOM   1963  HD1 TYR   122     -15.750  -8.654  -2.400  1.00 52.42           H 
ATOM   1964  HD2 TYR   122     -19.731 -10.145  -2.169  1.00 51.21           H 
ATOM   1965  HE1 TYR   122     -15.651  -9.273  -4.773  1.00 34.31           H 
ATOM   1966  HE2 TYR   122     -19.640 -10.769  -4.546  1.00  1.05           H 
ATOM   1967  HH  TYR   122     -18.382 -10.089  -6.579  1.00 70.22           H 
ATOM   1968  N   ILE   123     -19.191  -6.496   1.363  1.00 61.04           N 
ATOM   1969  CA  ILE   123     -19.716  -6.327   2.724  1.00 61.25           C 
ATOM   1970  C   ILE   123     -20.884  -7.296   2.976  1.00 63.30           C 
ATOM   1971  O   ILE   123     -22.014  -7.048   2.550  1.00 15.23           O 
ATOM   1972  CB  ILE   123     -20.194  -4.867   2.978  1.00 74.12           C 
ATOM   1973  CG1 ILE   123     -18.997  -3.905   3.017  1.00 54.22           C 
ATOM   1974  CG2 ILE   123     -21.003  -4.765   4.277  1.00  1.41           C 
ATOM   1975  CD1 ILE   123     -18.094  -4.109   4.215  1.00 71.10           C 
ATOM   1976  H   ILE   123     -19.665  -6.070   0.620  1.00 36.29           H 
ATOM   1977  HA  ILE   123     -18.918  -6.552   3.422  1.00 35.31           H 
ATOM   1978  HB  ILE   123     -20.843  -4.582   2.160  1.00 71.41           H 
ATOM   1979 3HG1 ILE   123     -19.358  -2.886   3.042  1.00 36.29           H 
ATOM   1980 2HG1 ILE   123     -18.398  -4.045   2.128  1.00 36.29           H 
ATOM   1981 1HG2 ILE   123     -21.283  -3.735   4.449  1.00 36.29           H 
ATOM   1982 2HG2 ILE   123     -20.406  -5.118   5.105  1.00 36.29           H 
ATOM   1983 3HG2 ILE   123     -21.897  -5.370   4.197  1.00 36.29           H 
ATOM   1984 1HD1 ILE   123     -17.717  -5.122   4.218  1.00 36.29           H 
ATOM   1985 2HD1 ILE   123     -18.652  -3.930   5.122  1.00 36.29           H 
ATOM   1986 3HD1 ILE   123     -17.265  -3.418   4.162  1.00 36.29           H 
ATOM   1987  N   GLU   124     -20.594  -8.415   3.642  1.00 50.43           N 
ATOM   1988  CA  GLU   124     -21.624  -9.406   4.008  1.00 72.50           C 
ATOM   1989  C   GLU   124     -22.407  -9.922   2.781  1.00  0.51           C 
ATOM   1990  O   GLU   124     -23.582 -10.275   2.885  1.00  2.31           O 
ATOM   1991  CB  GLU   124     -22.587  -8.789   5.036  1.00  5.20           C 
ATOM   1992  CG  GLU   124     -21.883  -8.290   6.295  1.00 51.14           C 
ATOM   1993  CD  GLU   124     -22.824  -7.630   7.286  1.00 72.34           C 
ATOM   1994  OE1 GLU   124     -23.029  -6.398   7.200  1.00 62.23           O 
ATOM   1995  OE2 GLU   124     -23.355  -8.339   8.163  1.00  1.41           O 
ATOM   1996  H   GLU   124     -19.663  -8.580   3.904  1.00 36.29           H 
ATOM   1997  HA  GLU   124     -21.120 -10.243   4.466  1.00 14.23           H 
ATOM   1998 3HB  GLU   124     -23.315  -9.534   5.324  1.00 36.29           H 
ATOM   1999 2HB  GLU   124     -23.100  -7.953   4.578  1.00 36.29           H 
ATOM   2000 3HG  GLU   124     -21.125  -7.576   6.007  1.00 36.29           H 
ATOM   2001 2HG  GLU   124     -21.410  -9.132   6.782  1.00 36.29           H 
ATOM   2002  N   GLY   125     -21.740  -9.994   1.628  1.00 34.43           N 
ATOM   2003  CA  GLY   125     -22.396 -10.443   0.395  1.00 11.53           C 
ATOM   2004  C   GLY   125     -22.812  -9.294  -0.524  1.00 42.35           C 
ATOM   2005  O   GLY   125     -23.328  -9.521  -1.623  1.00 42.41           O 
ATOM   2006  H   GLY   125     -20.786  -9.770   1.615  1.00 36.29           H 
ATOM   2007 3HA  GLY   125     -23.275 -11.017   0.655  1.00 36.29           H 
ATOM   2008 2HA  GLY   125     -21.713 -11.083  -0.142  1.00 36.29           H 
ATOM   2009  N   ARG   126     -22.592  -8.063  -0.075  1.00 45.25           N 
ATOM   2010  CA  ARG   126     -22.955  -6.864  -0.843  1.00 31.22           C 
ATOM   2011  C   ARG   126     -21.713  -6.201  -1.471  1.00 73.32           C 
ATOM   2012  O   ARG   126     -20.830  -5.721  -0.762  1.00 30.15           O 
ATOM   2013  CB  ARG   126     -23.690  -5.882   0.082  1.00 13.45           C 
ATOM   2014  CG  ARG   126     -23.968  -4.510  -0.524  1.00  1.50           C 
ATOM   2015  CD  ARG   126     -24.833  -3.664   0.403  1.00 43.53           C 
ATOM   2016  NE  ARG   126     -24.871  -2.260   0.000  1.00 73.00           N 
ATOM   2017  CZ  ARG   126     -25.952  -1.533  -0.026  1.00 54.42           C 
ATOM   2018  NH1 ARG   126     -27.111  -2.060   0.202  1.00 32.24           N 
ATOM   2019  NH2 ARG   126     -25.872  -0.275  -0.293  1.00 23.22           N 
ATOM   2020  H   ARG   126     -22.182  -7.951   0.808  1.00 36.29           H 
ATOM   2021  HA  ARG   126     -23.626  -7.166  -1.634  1.00  5.14           H 
ATOM   2022 3HB  ARG   126     -23.094  -5.741   0.974  1.00 36.29           H 
ATOM   2023 2HB  ARG   126     -24.636  -6.320   0.364  1.00 36.29           H 
ATOM   2024 3HG  ARG   126     -24.482  -4.637  -1.467  1.00 36.29           H 
ATOM   2025 2HG  ARG   126     -23.029  -4.001  -0.689  1.00 36.29           H 
ATOM   2026 3HD  ARG   126     -24.433  -3.726   1.407  1.00 36.29           H 
ATOM   2027 2HD  ARG   126     -25.839  -4.059   0.396  1.00 36.29           H 
ATOM   2028  HE  ARG   126     -24.020  -1.834  -0.220  1.00 22.03           H 
ATOM   2029 1HH1 ARG   126     -27.187  -3.034   0.399  1.00 36.29           H 
ATOM   2030 2HH1 ARG   126     -27.931  -1.491   0.180  1.00 36.29           H 
ATOM   2031 1HH2 ARG   126     -24.990   0.139  -0.486  1.00 36.29           H 
ATOM   2032 2HH2 ARG   126     -26.697   0.289  -0.284  1.00 36.29           H 
ATOM   2033  N   GLU   127     -21.651  -6.181  -2.805  1.00  3.43           N 
ATOM   2034  CA  GLU   127     -20.499  -5.610  -3.526  1.00 23.43           C 
ATOM   2035  C   GLU   127     -20.452  -4.075  -3.422  1.00 73.44           C 
ATOM   2036  O   GLU   127     -21.470  -3.395  -3.578  1.00 75.52           O 
ATOM   2037  CB  GLU   127     -20.531  -6.031  -5.005  1.00 34.52           C 
ATOM   2038  CG  GLU   127     -20.492  -7.542  -5.217  1.00 23.15           C 
ATOM   2039  CD  GLU   127     -20.491  -7.936  -6.690  1.00 21.12           C 
ATOM   2040  OE1 GLU   127     -21.513  -7.698  -7.369  1.00 32.20           O 
ATOM   2041  OE2 GLU   127     -19.483  -8.500  -7.169  1.00 20.22           O 
ATOM   2042  H   GLU   127     -22.393  -6.564  -3.321  1.00 36.29           H 
ATOM   2043  HA  GLU   127     -19.601  -6.012  -3.075  1.00 63.25           H 
ATOM   2044 3HB  GLU   127     -19.680  -5.597  -5.510  1.00 36.29           H 
ATOM   2045 2HB  GLU   127     -21.437  -5.648  -5.457  1.00 36.29           H 
ATOM   2046 3HG  GLU   127     -21.360  -7.980  -4.743  1.00 36.29           H 
ATOM   2047 2HG  GLU   127     -19.598  -7.934  -4.749  1.00 36.29           H 
ATOM   2048  N   ILE   128     -19.256  -3.544  -3.166  1.00  2.14           N 
ATOM   2049  CA  ILE   128     -19.042  -2.099  -3.017  1.00 13.41           C 
ATOM   2050  C   ILE   128     -18.389  -1.498  -4.276  1.00 60.24           C 
ATOM   2051  O   ILE   128     -17.491  -2.103  -4.868  1.00 23.33           O 
ATOM   2052  CB  ILE   128     -18.137  -1.794  -1.793  1.00 44.41           C 
ATOM   2053  CG1 ILE   128     -18.641  -2.537  -0.542  1.00 63.42           C 
ATOM   2054  CG2 ILE   128     -18.069  -0.288  -1.534  1.00 71.34           C 
ATOM   2055  CD1 ILE   128     -20.042  -2.154  -0.116  1.00 51.12           C 
ATOM   2056  H   ILE   128     -18.488  -4.144  -3.072  1.00 36.29           H 
ATOM   2057  HA  ILE   128     -20.004  -1.626  -2.858  1.00  4.01           H 
ATOM   2058  HB  ILE   128     -17.136  -2.137  -2.021  1.00 64.42           H 
ATOM   2059 3HG1 ILE   128     -17.976  -2.331   0.284  1.00 36.29           H 
ATOM   2060 2HG1 ILE   128     -18.639  -3.601  -0.738  1.00 36.29           H 
ATOM   2061 1HG2 ILE   128     -17.653   0.207  -2.400  1.00 36.29           H 
ATOM   2062 2HG2 ILE   128     -17.442  -0.095  -0.675  1.00 36.29           H 
ATOM   2063 3HG2 ILE   128     -19.063   0.093  -1.346  1.00 36.29           H 
ATOM   2064 1HD1 ILE   128     -20.324  -2.735   0.748  1.00 36.29           H 
ATOM   2065 2HD1 ILE   128     -20.732  -2.351  -0.923  1.00 36.29           H 
ATOM   2066 3HD1 ILE   128     -20.069  -1.103   0.134  1.00 36.29           H 
ATOM   2067  N   ASP   129     -18.830  -0.303  -4.667  1.00 10.23           N 
ATOM   2068  CA  ASP   129     -18.320   0.368  -5.871  1.00 53.10           C 
ATOM   2069  C   ASP   129     -16.919   0.983  -5.656  1.00 64.35           C 
ATOM   2070  O   ASP   129     -16.748   2.206  -5.689  1.00  1.51           O 
ATOM   2071  CB  ASP   129     -19.308   1.456  -6.304  1.00  2.33           C 
ATOM   2072  CG  ASP   129     -20.702   0.910  -6.541  1.00 40.11           C 
ATOM   2073  OD1 ASP   129     -21.429   0.674  -5.552  1.00 24.23           O 
ATOM   2074  OD2 ASP   129     -21.082   0.722  -7.714  1.00 21.40           O 
ATOM   2075  H   ASP   129     -19.529   0.139  -4.141  1.00 36.29           H 
ATOM   2076  HA  ASP   129     -18.255  -0.371  -6.657  1.00 22.45           H 
ATOM   2077 3HB  ASP   129     -18.956   1.911  -7.219  1.00 36.29           H 
ATOM   2078 2HB  ASP   129     -19.364   2.210  -5.531  1.00 36.29           H 
ATOM   2079  N   LEU   130     -15.920   0.130  -5.439  1.00  3.51           N 
ATOM   2080  CA  LEU   130     -14.531   0.578  -5.238  1.00 61.03           C 
ATOM   2081  C   LEU   130     -13.562  -0.220  -6.127  1.00 74.21           C 
ATOM   2082  O   LEU   130     -13.376  -1.421  -5.928  1.00 53.25           O 
ATOM   2083  CB  LEU   130     -14.124   0.427  -3.761  1.00 74.02           C 
ATOM   2084  CG  LEU   130     -14.939   1.257  -2.750  1.00 72.05           C 
ATOM   2085  CD1 LEU   130     -14.503   0.942  -1.319  1.00 35.30           C 
ATOM   2086  CD2 LEU   130     -14.803   2.753  -3.038  1.00 43.21           C 
ATOM   2087  H   LEU   130     -16.116  -0.831  -5.421  1.00 36.29           H 
ATOM   2088  HA  LEU   130     -14.471   1.622  -5.514  1.00 44.34           H 
ATOM   2089 3HB  LEU   130     -13.083   0.710  -3.666  1.00 36.29           H 
ATOM   2090 2HB  LEU   130     -14.217  -0.616  -3.494  1.00 36.29           H 
ATOM   2091  HG  LEU   130     -15.985   0.994  -2.841  1.00 12.31           H 
ATOM   2092 1HD1 LEU   130     -15.095   1.524  -0.625  1.00 36.29           H 
ATOM   2093 2HD1 LEU   130     -13.459   1.188  -1.195  1.00 36.29           H 
ATOM   2094 3HD1 LEU   130     -14.649  -0.110  -1.119  1.00 36.29           H 
ATOM   2095 1HD2 LEU   130     -15.174   2.967  -4.030  1.00 36.29           H 
ATOM   2096 2HD2 LEU   130     -13.763   3.042  -2.973  1.00 36.29           H 
ATOM   2097 3HD2 LEU   130     -15.376   3.313  -2.312  1.00 36.29           H 
ATOM   2098  N   GLY   131     -12.948   0.452  -7.101  1.00 45.24           N 
ATOM   2099  CA  GLY   131     -12.041  -0.222  -8.029  1.00 14.03           C 
ATOM   2100  C   GLY   131     -10.564   0.103  -7.802  1.00 62.02           C 
ATOM   2101  O   GLY   131      -9.718  -0.795  -7.819  1.00  1.13           O 
ATOM   2102  H   GLY   131     -13.122   1.412  -7.203  1.00 36.29           H 
ATOM   2103 3HA  GLY   131     -12.304   0.069  -9.036  1.00 36.29           H 
ATOM   2104 2HA  GLY   131     -12.175  -1.291  -7.937  1.00 36.29           H 
ATOM   2105  N   TYR   132     -10.244   1.385  -7.598  1.00 45.14           N 
ATOM   2106  CA  TYR   132      -8.845   1.811  -7.437  1.00  1.23           C 
ATOM   2107  C   TYR   132      -8.724   3.175  -6.724  1.00 64.11           C 
ATOM   2108  O   TYR   132      -8.341   3.239  -5.553  1.00 23.12           O 
ATOM   2109  CB  TYR   132      -8.156   1.872  -8.812  1.00 71.04           C 
ATOM   2110  CG  TYR   132      -6.671   2.197  -8.754  1.00  1.22           C 
ATOM   2111  CD1 TYR   132      -6.208   3.502  -8.918  1.00 24.34           C 
ATOM   2112  CD2 TYR   132      -5.730   1.194  -8.540  1.00 40.31           C 
ATOM   2113  CE1 TYR   132      -4.858   3.792  -8.869  1.00  2.13           C 
ATOM   2114  CE2 TYR   132      -4.380   1.479  -8.489  1.00 42.44           C 
ATOM   2115  CZ  TYR   132      -3.948   2.778  -8.655  1.00  3.14           C 
ATOM   2116  OH  TYR   132      -2.601   3.065  -8.606  1.00 52.01           O 
ATOM   2117  H   TYR   132     -10.961   2.053  -7.549  1.00 36.29           H 
ATOM   2118  HA  TYR   132      -8.344   1.065  -6.834  1.00 63.41           H 
ATOM   2119 3HB  TYR   132      -8.641   2.630  -9.412  1.00 36.29           H 
ATOM   2120 2HB  TYR   132      -8.266   0.914  -9.303  1.00 36.29           H 
ATOM   2121  HD1 TYR   132      -6.922   4.295  -9.085  1.00 64.32           H 
ATOM   2122  HD2 TYR   132      -6.069   0.176  -8.409  1.00 13.42           H 
ATOM   2123  HE1 TYR   132      -4.519   4.810  -8.997  1.00 20.44           H 
ATOM   2124  HE2 TYR   132      -3.666   0.684  -8.323  1.00 11.35           H 
ATOM   2125  HH  TYR   132      -2.450   3.807  -8.015  1.00  3.43           H 
ATOM   2126  N   GLY   133      -9.071   4.255  -7.436  1.00 51.33           N 
ATOM   2127  CA  GLY   133      -8.870   5.614  -6.924  1.00 13.10           C 
ATOM   2128  C   GLY   133      -9.509   5.864  -5.560  1.00 40.20           C 
ATOM   2129  O   GLY   133      -8.873   6.404  -4.657  1.00 13.21           O 
ATOM   2130  H   GLY   133      -9.477   4.130  -8.322  1.00 36.29           H 
ATOM   2131 3HA  GLY   133      -9.290   6.313  -7.635  1.00 36.29           H 
ATOM   2132 2HA  GLY   133      -7.808   5.801  -6.848  1.00 36.29           H 
ATOM   2133  N   GLU   134     -10.769   5.477  -5.411  1.00 14.42           N 
ATOM   2134  CA  GLU   134     -11.477   5.632  -4.139  1.00 14.32           C 
ATOM   2135  C   GLU   134     -11.047   4.559  -3.127  1.00 52.13           C 
ATOM   2136  O   GLU   134     -11.004   4.806  -1.924  1.00 35.42           O 
ATOM   2137  CB  GLU   134     -12.994   5.561  -4.367  1.00 42.30           C 
ATOM   2138  CG  GLU   134     -13.506   6.514  -5.445  1.00 54.42           C 
ATOM   2139  CD  GLU   134     -13.287   7.985  -5.110  1.00 32.14           C 
ATOM   2140  OE1 GLU   134     -12.181   8.506  -5.365  1.00 10.42           O 
ATOM   2141  OE2 GLU   134     -14.229   8.633  -4.613  1.00  3.31           O 
ATOM   2142  H   GLU   134     -11.236   5.078  -6.174  1.00 36.29           H 
ATOM   2143  HA  GLU   134     -11.229   6.606  -3.738  1.00 11.20           H 
ATOM   2144 3HB  GLU   134     -13.499   5.797  -3.440  1.00 36.29           H 
ATOM   2145 2HB  GLU   134     -13.256   4.553  -4.656  1.00 36.29           H 
ATOM   2146 3HG  GLU   134     -14.565   6.343  -5.580  1.00 36.29           H 
ATOM   2147 2HG  GLU   134     -12.991   6.294  -6.371  1.00 36.29           H 
ATOM   2148  N   ALA   135     -10.703   3.373  -3.630  1.00 32.24           N 
ATOM   2149  CA  ALA   135     -10.360   2.223  -2.778  1.00 13.22           C 
ATOM   2150  C   ALA   135      -9.159   2.502  -1.854  1.00 64.43           C 
ATOM   2151  O   ALA   135      -9.058   1.931  -0.768  1.00 72.22           O 
ATOM   2152  CB  ALA   135     -10.092   0.994  -3.640  1.00  0.25           C 
ATOM   2153  H   ALA   135     -10.672   3.267  -4.603  1.00 36.29           H 
ATOM   2154  HA  ALA   135     -11.223   2.006  -2.160  1.00 21.24           H 
ATOM   2155 1HB  ALA   135      -9.200   1.152  -4.231  1.00 36.29           H 
ATOM   2156 2HB  ALA   135     -10.932   0.825  -4.300  1.00 36.29           H 
ATOM   2157 3HB  ALA   135      -9.956   0.128  -3.007  1.00 36.29           H 
ATOM   2158  N   THR   136      -8.253   3.382  -2.283  1.00  1.31           N 
ATOM   2159  CA  THR   136      -7.082   3.750  -1.460  1.00 43.53           C 
ATOM   2160  C   THR   136      -7.462   4.690  -0.303  1.00 35.52           C 
ATOM   2161  O   THR   136      -6.651   4.957   0.586  1.00  1.42           O 
ATOM   2162  CB  THR   136      -5.969   4.427  -2.303  1.00  2.12           C 
ATOM   2163  OG1 THR   136      -4.807   4.668  -1.493  1.00 12.44           O 
ATOM   2164  CG2 THR   136      -6.450   5.744  -2.903  1.00 50.10           C 
ATOM   2165  H   THR   136      -8.361   3.783  -3.175  1.00 36.29           H 
ATOM   2166  HA  THR   136      -6.676   2.838  -1.042  1.00 73.22           H 
ATOM   2167  HB  THR   136      -5.698   3.759  -3.110  1.00 11.11           H 
ATOM   2168  HG1 THR   136      -5.076   5.022  -0.638  1.00 72.40           H 
ATOM   2169 1HG2 THR   136      -7.315   5.565  -3.525  1.00 36.29           H 
ATOM   2170 2HG2 THR   136      -5.662   6.178  -3.501  1.00 36.29           H 
ATOM   2171 3HG2 THR   136      -6.715   6.429  -2.109  1.00 36.29           H 
ATOM   2172  N   LYS   137      -8.693   5.194  -0.325  1.00  0.45           N 
ATOM   2173  CA  LYS   137      -9.171   6.133   0.698  1.00 32.52           C 
ATOM   2174  C   LYS   137      -9.853   5.400   1.868  1.00  3.21           C 
ATOM   2175  O   LYS   137     -10.067   5.980   2.938  1.00  4.43           O 
ATOM   2176  CB  LYS   137     -10.137   7.139   0.054  1.00 72.22           C 
ATOM   2177  CG  LYS   137      -9.533   7.870  -1.145  1.00 73.34           C 
ATOM   2178  CD  LYS   137     -10.552   8.761  -1.852  1.00 23.35           C 
ATOM   2179  CE  LYS   137      -9.944   9.465  -3.064  1.00 30.11           C 
ATOM   2180  NZ  LYS   137     -10.926  10.344  -3.752  1.00 45.11           N 
ATOM   2181  H   LYS   137      -9.299   4.933  -1.050  1.00 36.29           H 
ATOM   2182  HA  LYS   137      -8.316   6.671   1.084  1.00 52.10           H 
ATOM   2183 3HB  LYS   137     -10.423   7.874   0.792  1.00 36.29           H 
ATOM   2184 2HB  LYS   137     -11.022   6.611  -0.278  1.00 36.29           H 
ATOM   2185 3HG  LYS   137      -9.162   7.136  -1.848  1.00 36.29           H 
ATOM   2186 2HG  LYS   137      -8.712   8.485  -0.804  1.00 36.29           H 
ATOM   2187 3HD  LYS   137     -10.909   9.506  -1.155  1.00 36.29           H 
ATOM   2188 2HD  LYS   137     -11.381   8.150  -2.182  1.00 36.29           H 
ATOM   2189 3HE  LYS   137      -9.595   8.717  -3.761  1.00 36.29           H 
ATOM   2190 2HE  LYS   137      -9.108  10.067  -2.736  1.00 36.29           H 
ATOM   2191 1HZ  LYS   137     -10.459  10.867  -4.522  1.00 36.29           H 
ATOM   2192 2HZ  LYS   137     -11.333  11.027  -3.081  1.00 36.29           H 
ATOM   2193 3HZ  LYS   137     -11.695   9.771  -4.159  1.00 36.29           H 
ATOM   2194  N   ILE   138     -10.192   4.126   1.658  1.00 60.30           N 
ATOM   2195  CA  ILE   138     -10.785   3.292   2.714  1.00 62.30           C 
ATOM   2196  C   ILE   138      -9.712   2.400   3.357  1.00 50.30           C 
ATOM   2197  O   ILE   138      -9.086   1.582   2.678  1.00 52.20           O 
ATOM   2198  CB  ILE   138     -11.935   2.386   2.180  1.00 71.20           C 
ATOM   2199  CG1 ILE   138     -13.093   3.223   1.601  1.00  0.22           C 
ATOM   2200  CG2 ILE   138     -12.456   1.467   3.290  1.00 55.43           C 
ATOM   2201  CD1 ILE   138     -12.779   3.906   0.287  1.00 51.44           C 
ATOM   2202  H   ILE   138     -10.031   3.732   0.775  1.00 36.29           H 
ATOM   2203  HA  ILE   138     -11.193   3.950   3.471  1.00 42.11           H 
ATOM   2204  HB  ILE   138     -11.530   1.759   1.397  1.00 72.45           H 
ATOM   2205 3HG1 ILE   138     -13.364   3.990   2.315  1.00 36.29           H 
ATOM   2206 2HG1 ILE   138     -13.947   2.581   1.438  1.00 36.29           H 
ATOM   2207 1HG2 ILE   138     -13.269   0.864   2.909  1.00 36.29           H 
ATOM   2208 2HG2 ILE   138     -12.808   2.063   4.118  1.00 36.29           H 
ATOM   2209 3HG2 ILE   138     -11.659   0.819   3.628  1.00 36.29           H 
ATOM   2210 1HD1 ILE   138     -12.508   3.166  -0.450  1.00 36.29           H 
ATOM   2211 2HD1 ILE   138     -11.957   4.594   0.425  1.00 36.29           H 
ATOM   2212 3HD1 ILE   138     -13.648   4.450  -0.053  1.00 36.29           H 
ATOM   2213  N   TRP   139      -9.507   2.557   4.663  1.00 34.04           N 
ATOM   2214  CA  TRP   139      -8.464   1.812   5.381  1.00 62.21           C 
ATOM   2215  C   TRP   139      -9.060   0.686   6.244  1.00 73.43           C 
ATOM   2216  O   TRP   139     -10.042   0.886   6.972  1.00 54.32           O 
ATOM   2217  CB  TRP   139      -7.639   2.774   6.242  1.00 72.31           C 
ATOM   2218  CG  TRP   139      -6.849   3.766   5.435  1.00 12.05           C 
ATOM   2219  CD1 TRP   139      -7.347   4.748   4.628  1.00 14.33           C 
ATOM   2220  CD2 TRP   139      -5.420   3.875   5.361  1.00 24.53           C 
ATOM   2221  NE1 TRP   139      -6.319   5.453   4.052  1.00 52.22           N 
ATOM   2222  CE2 TRP   139      -5.129   4.938   4.487  1.00 34.30           C 
ATOM   2223  CE3 TRP   139      -4.360   3.175   5.944  1.00 50.24           C 
ATOM   2224  CZ2 TRP   139      -3.822   5.321   4.189  1.00 25.22           C 
ATOM   2225  CZ3 TRP   139      -3.064   3.555   5.648  1.00 32.41           C 
ATOM   2226  CH2 TRP   139      -2.805   4.618   4.775  1.00 30.23           C 
ATOM   2227  H   TRP   139     -10.074   3.183   5.164  1.00 36.29           H 
ATOM   2228  HA  TRP   139      -7.812   1.366   4.641  1.00 33.35           H 
ATOM   2229 3HB  TRP   139      -6.944   2.207   6.846  1.00 36.29           H 
ATOM   2230 2HB  TRP   139      -8.303   3.327   6.891  1.00 36.29           H 
ATOM   2231  HD1 TRP   139      -8.399   4.928   4.470  1.00 44.54           H 
ATOM   2232  HE1 TRP   139      -6.424   6.204   3.431  1.00 35.00           H 
ATOM   2233  HE3 TRP   139      -4.540   2.349   6.620  1.00 21.20           H 
ATOM   2234  HZ2 TRP   139      -3.605   6.140   3.518  1.00 53.50           H 
ATOM   2235  HZ3 TRP   139      -2.234   3.026   6.092  1.00 34.22           H 
ATOM   2236  HH2 TRP   139      -1.777   4.881   4.571  1.00 14.23           H 
ATOM   2237  N   VAL   140      -8.449  -0.496   6.161  1.00  0.54           N 
ATOM   2238  CA  VAL   140      -8.938  -1.696   6.851  1.00 32.24           C 
ATOM   2239  C   VAL   140      -7.802  -2.448   7.571  1.00 64.04           C 
ATOM   2240  O   VAL   140      -6.622  -2.139   7.395  1.00 32.00           O 
ATOM   2241  CB  VAL   140      -9.619  -2.665   5.851  1.00 10.53           C 
ATOM   2242  CG1 VAL   140     -10.863  -2.025   5.239  1.00 65.31           C 
ATOM   2243  CG2 VAL   140      -8.634  -3.094   4.760  1.00 12.24           C 
ATOM   2244  H   VAL   140      -7.634  -0.566   5.620  1.00 36.29           H 
ATOM   2245  HA  VAL   140      -9.673  -1.391   7.585  1.00 32.01           H 
ATOM   2246  HB  VAL   140      -9.930  -3.549   6.392  1.00  4.45           H 
ATOM   2247 1HG1 VAL   140     -10.581  -1.133   4.698  1.00 36.29           H 
ATOM   2248 2HG1 VAL   140     -11.558  -1.767   6.022  1.00 36.29           H 
ATOM   2249 3HG1 VAL   140     -11.332  -2.722   4.560  1.00 36.29           H 
ATOM   2250 1HG2 VAL   140      -9.113  -3.802   4.097  1.00 36.29           H 
ATOM   2251 2HG2 VAL   140      -7.769  -3.557   5.215  1.00 36.29           H 
ATOM   2252 3HG2 VAL   140      -8.322  -2.229   4.194  1.00 36.29           H 
ATOM   2253  N   ARG   141      -8.170  -3.442   8.383  1.00 63.11           N 
ATOM   2254  CA  ARG   141      -7.185  -4.279   9.087  1.00 51.13           C 
ATOM   2255  C   ARG   141      -7.414  -5.772   8.793  1.00 12.45           C 
ATOM   2256  O   ARG   141      -8.551  -6.218   8.640  1.00 24.20           O 
ATOM   2257  CB  ARG   141      -7.246  -4.032  10.602  1.00  0.25           C 
ATOM   2258  CG  ARG   141      -7.161  -2.558  10.991  1.00  0.14           C 
ATOM   2259  CD  ARG   141      -6.786  -2.374  12.455  1.00 54.21           C 
ATOM   2260  NE  ARG   141      -5.429  -2.848  12.727  1.00 53.01           N 
ATOM   2261  CZ  ARG   141      -4.869  -2.849  13.904  1.00 10.01           C 
ATOM   2262  NH1 ARG   141      -5.511  -2.417  14.941  1.00 24.05           N 
ATOM   2263  NH2 ARG   141      -3.659  -3.286  14.042  1.00 32.42           N 
ATOM   2264  H   ARG   141      -9.125  -3.617   8.517  1.00 36.29           H 
ATOM   2265  HA  ARG   141      -6.202  -4.006   8.728  1.00 31.52           H 
ATOM   2266 3HB  ARG   141      -6.424  -4.555  11.071  1.00 36.29           H 
ATOM   2267 2HB  ARG   141      -8.176  -4.430  10.984  1.00 36.29           H 
ATOM   2268 3HG  ARG   141      -8.121  -2.093  10.813  1.00 36.29           H 
ATOM   2269 2HG  ARG   141      -6.411  -2.078  10.380  1.00 36.29           H 
ATOM   2270 3HD  ARG   141      -7.483  -2.930  13.066  1.00 36.29           H 
ATOM   2271 2HD  ARG   141      -6.849  -1.324  12.703  1.00 36.29           H 
ATOM   2272  HE  ARG   141      -4.909  -3.187  11.973  1.00 25.03           H 
ATOM   2273 1HH1 ARG   141      -6.443  -2.080  14.848  1.00 36.29           H 
ATOM   2274 2HH1 ARG   141      -5.073  -2.433  15.838  1.00 36.29           H 
ATOM   2275 1HH2 ARG   141      -3.157  -3.623  13.247  1.00 36.29           H 
ATOM   2276 2HH2 ARG   141      -3.229  -3.293  14.942  1.00 36.29           H 
ATOM   2277  N   ARG   142      -6.328  -6.540   8.717  1.00 31.12           N 
ATOM   2278  CA  ARG   142      -6.410  -7.976   8.407  1.00 50.41           C 
ATOM   2279  C   ARG   142      -6.858  -8.784   9.639  1.00 14.23           C 
ATOM   2280  O   ARG   142      -6.099  -8.953  10.593  1.00 51.22           O 
ATOM   2281  CB  ARG   142      -5.036  -8.463   7.909  1.00  3.44           C 
ATOM   2282  CG  ARG   142      -4.971  -9.932   7.482  1.00 71.22           C 
ATOM   2283  CD  ARG   142      -5.908 -10.249   6.313  1.00 43.30           C 
ATOM   2284  NE  ARG   142      -5.277 -11.114   5.314  1.00  4.21           N 
ATOM   2285  CZ  ARG   142      -5.064 -12.395   5.460  1.00 43.14           C 
ATOM   2286  NH1 ARG   142      -5.406 -12.998   6.554  1.00 73.50           N 
ATOM   2287  NH2 ARG   142      -4.502 -13.067   4.507  1.00 15.44           N 
ATOM   2288  H   ARG   142      -5.449  -6.137   8.876  1.00 36.29           H 
ATOM   2289  HA  ARG   142      -7.136  -8.106   7.617  1.00 11.02           H 
ATOM   2290 3HB  ARG   142      -4.314  -8.313   8.699  1.00 36.29           H 
ATOM   2291 2HB  ARG   142      -4.746  -7.861   7.062  1.00 36.29           H 
ATOM   2292 3HG  ARG   142      -5.242 -10.551   8.327  1.00 36.29           H 
ATOM   2293 2HG  ARG   142      -3.957 -10.159   7.187  1.00 36.29           H 
ATOM   2294 3HD  ARG   142      -6.198  -9.323   5.835  1.00 36.29           H 
ATOM   2295 2HD  ARG   142      -6.790 -10.742   6.697  1.00 36.29           H 
ATOM   2296  HE  ARG   142      -5.003 -10.702   4.473  1.00 13.45           H 
ATOM   2297 1HH1 ARG   142      -5.836 -12.489   7.285  1.00 36.29           H 
ATOM   2298 2HH1 ARG   142      -5.224 -13.976   6.661  1.00 36.29           H 
ATOM   2299 1HH2 ARG   142      -4.233 -12.602   3.661  1.00 36.29           H 
ATOM   2300 2HH2 ARG   142      -4.336 -14.043   4.613  1.00 36.29           H 
ATOM   2301  N   VAL   143      -8.093  -9.288   9.607  1.00 22.51           N 
ATOM   2302  CA  VAL   143      -8.649 -10.049  10.739  1.00 13.35           C 
ATOM   2303  C   VAL   143      -8.612 -11.568  10.496  1.00 21.13           C 
ATOM   2304  O   VAL   143      -8.180 -12.329  11.365  1.00 62.05           O 
ATOM   2305  CB  VAL   143     -10.104  -9.615  11.064  1.00 33.44           C 
ATOM   2306  CG1 VAL   143     -10.136  -8.189  11.600  1.00  3.53           C 
ATOM   2307  CG2 VAL   143     -11.010  -9.743   9.841  1.00 65.43           C 
ATOM   2308  H   VAL   143      -8.652  -9.131   8.816  1.00 36.29           H 
ATOM   2309  HA  VAL   143      -8.039  -9.831  11.608  1.00 35.11           H 
ATOM   2310  HB  VAL   143     -10.487 -10.271  11.836  1.00 21.23           H 
ATOM   2311 1HG1 VAL   143      -9.552  -8.129  12.505  1.00 36.29           H 
ATOM   2312 2HG1 VAL   143     -11.158  -7.908  11.812  1.00 36.29           H 
ATOM   2313 3HG1 VAL   143      -9.726  -7.516  10.859  1.00 36.29           H 
ATOM   2314 1HG2 VAL   143     -10.646  -9.098   9.053  1.00 36.29           H 
ATOM   2315 2HG2 VAL   143     -12.017  -9.455  10.104  1.00 36.29           H 
ATOM   2316 3HG2 VAL   143     -11.011 -10.768   9.497  1.00 36.29           H 
END
