
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   75 ( 1111),  selected   75 , name 2gcx_A
# Molecule2: number of CA atoms   67 ( 1113),  selected   67 , name T0462_77_143.pdb
# PARAMETERS: 2gcx_A.T0462_77_143.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      E      77           -
LGA    -       -      L      78           -
LGA    M     1_A      P      79           #
LGA    -       -      L      80           -
LGA    -       -      I      81           -
LGA    Q     2_A      L      82          4.105
LGA    F     3_A      A      83          2.579
LGA    T     4_A      D      84          4.399
LGA    P     5_A      -       -           -
LGA    D     6_A      D      85          4.074
LGA    S     7_A      G      86          1.948
LGA    A     8_A      T      87          1.907
LGA    W     9_A      Y      88          1.308
LGA    K    10_A      E      89          1.674
LGA    I    11_A      I      90          2.122
LGA    T    12_A      T      91          2.882
LGA    G    13_A      K      92          3.552
LGA    F    14_A      L      93          2.458
LGA    S    15_A      N      94          2.407
LGA    R    16_A      -       -           -
LGA    D    17_A      -       -           -
LGA    I    18_A      G      95          1.199
LGA    S    19_A      G      96          1.431
LGA    P    20_A      R      97          2.158
LGA    A    21_A      R      98          2.547
LGA    Y    22_A      F      99          2.069
LGA    R    23_A      L     100          0.443
LGA    Q    24_A      F     101          0.745
LGA    K    25_A      R     102          1.369
LGA    L    26_A      M     103          1.902
LGA    L    27_A      K     104          1.770
LGA    S    28_A      N     105          1.679
LGA    L    29_A      L     106          3.545
LGA    G    30_A      G     107          4.123
LGA    M    31_A      I     108          2.831
LGA    L    32_A      E     109          0.897
LGA    P    33_A      S     110          2.313
LGA    G    34_A      G     111          1.780
LGA    S    35_A      K     112          1.002
LGA    S    36_A      K     113          0.630
LGA    F    37_A      I     114          0.924
LGA    H    38_A      Q     115          0.689
LGA    V    39_A      V     116          0.823
LGA    V    40_A      S     117          0.853
LGA    R    41_A      G     118          1.068
LGA    V    42_A      -       -           -
LGA    A    43_A      -       -           -
LGA    P    44_A      -       -           -
LGA    L    45_A      -       -           -
LGA    G    46_A      -       -           -
LGA    D    47_A      -       -           -
LGA    P    48_A      -       -           -
LGA    V    49_A      R     119          1.710
LGA    H    50_A      R     120          0.559
LGA    I    51_A      Y     121          0.628
LGA    E    52_A      Y     122          1.062
LGA    T    53_A      I     123          1.135
LGA    R    54_A      E     124          1.550
LGA    R    55_A      G     125          2.689
LGA    V    56_A      R     126          0.657
LGA    S    57_A      E     127          0.872
LGA    L    58_A      I     128          0.983
LGA    V    59_A      D     129          2.604
LGA    L    60_A      L     130          1.098
LGA    R    61_A      G     131          2.977
LGA    K    62_A      Y     132          2.653
LGA    K    63_A      G     133          2.429
LGA    D    64_A      E     134          1.519
LGA    L    65_A      A     135          2.764
LGA    A    66_A      T     136          2.637
LGA    L    67_A      K     137          2.060
LGA    I    68_A      I     138          2.015
LGA    E    69_A      W     139          1.473
LGA    L    70_A      V     140          1.275
LGA    E    71_A      R     141          1.128
LGA    A    72_A      R     142          1.150
LGA    V    73_A      V     143          0.771
LGA    A    74_A      -       -           -
LGA    Q    75_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   75   67    5.0     62    2.09    16.13     78.621     2.826

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.112593 * X  +   0.934905 * Y  +  -0.336565 * Z  + -12.473256
  Y_new =   0.902799 * X  +  -0.237741 * Y  +  -0.358375 * Z  +  -3.574177
  Z_new =  -0.415062 * X  +  -0.263500 * Y  +  -0.870799 * Z  +   2.411844 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.847756    0.293836  [ DEG:  -163.1644     16.8356 ]
  Theta =   0.428011    2.713582  [ DEG:    24.5232    155.4768 ]
  Phi   =   1.446722   -1.694871  [ DEG:    82.8911    -97.1089 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2gcx_A                                        
REMARK     2: T0462_77_143.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2gcx_A.T0462_77_143.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   75   67   5.0   62   2.09   16.13  78.621
REMARK  ---------------------------------------------------------- 
MOLECULE 2gcx_A
HEADER    TRANSPORT PROTEIN                       14-MAR-06   2GCX              
TITLE     SOLUTION STRUCTURE OF FERROUS IRON TRANSPORT PROTEIN A                
TITLE    2 (FEOA) OF KLEBSIELLA PNEUMONIAE                                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: FERROUS IRON TRANSPORT PROTEIN A;                          
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: FEOA;                                                       
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: KLEBSIELLA PNEUMONIAE;                          
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET-22B(+)                                
KEYWDS    KLEBSIELLA PNEUMONIAE, FEOA, FERROUS IRON TRANSPORT PROTEIN           
KEYWDS   2 A, NMR                                                               
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    K.-W.HUNG,C.-C.CHENG,T.-H.YU,S.-H.WANG,C.-F.CHANG,S.-F.TSAI,          
AUTHOR   2 T.-H.HUANG                                                           
REVDAT   1   20-MAR-07 2GCX    0                                                
JRNL        AUTH   K.-W.HUNG,C.-C.CHENG,T.-H.YU,S.-H.WANG,C.-F.CHANG,           
JRNL        AUTH 2 S.-F.TSAI,T.-H.HUANG                                         
JRNL        TITL   SOLUTION STRUCTURE OF FERROUS IRON TRANSPORT                 
JRNL        TITL 2 PROTEIN A (FEOA) OF KLEBSIELLA PNEUMONIAE                    
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
SEQRES   1 A   75  MET GLN PHE THR PRO ASP SER ALA TRP LYS ILE THR GLY          
SEQRES   2 A   75  PHE SER ARG ASP ILE SER PRO ALA TYR ARG GLN LYS LEU          
SEQRES   3 A   75  LEU SER LEU GLY MET LEU PRO GLY SER SER PHE HIS VAL          
SEQRES   4 A   75  VAL ARG VAL ALA PRO LEU GLY ASP PRO VAL HIS ILE GLU          
SEQRES   5 A   75  THR ARG ARG VAL SER LEU VAL LEU ARG LYS LYS ASP LEU          
SEQRES   6 A   75  ALA LEU ILE GLU LEU GLU ALA VAL ALA GLN                      
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1       1.340  -6.048   2.871  1.00  3.33           N  
ATOM      2  CA  MET A   1       1.261  -4.632   2.429  1.00  2.78           C  
ATOM      3  C   MET A   1       0.270  -4.473   1.280  1.00  2.08           C  
ATOM      4  O   MET A   1      -0.546  -3.552   1.276  1.00  2.36           O  
ATOM      5  CB  MET A   1       2.642  -4.140   1.992  1.00  2.93           C  
ATOM      6  CG  MET A   1       2.656  -2.690   1.537  1.00  3.53           C  
ATOM      7  SD  MET A   1       2.225  -1.543   2.860  1.00  4.37           S  
ATOM      8  CE  MET A   1       2.285   0.021   1.986  1.00  5.17           C  
ATOM      9  H2  MET A   1       0.395  -6.392   3.140  1.00  3.82           H  
ATOM     10  HA  MET A   1       0.921  -4.035   3.264  1.00  3.41           H  
ATOM     11  HB2 MET A   1       3.327  -4.241   2.822  1.00  2.98           H  
ATOM     12  HG2 MET A   1       3.646  -2.448   1.178  1.00  3.81           H  
ATOM     13  HE1 MET A   1       3.278   0.175   1.591  1.00  5.58           H  
ATOM     14  HE2 MET A   1       1.572   0.008   1.177  1.00  5.32           H  
ATOM     15  HE3 MET A   1       2.040   0.823   2.669  1.00  5.50           H  
ATOM     16  H1  MET A   1       1.707  -6.643   2.102  1.00  3.63           H  
ATOM     17  H3  MET A   1       1.972  -6.132   3.692  1.00  3.53           H  
ATOM     18  N   GLN A   2       0.348  -5.376   0.308  1.00  1.56           N  
ATOM     19  CA  GLN A   2      -0.539  -5.331  -0.847  1.00  0.99           C  
ATOM     20  C   GLN A   2      -1.852  -6.052  -0.556  1.00  0.83           C  
ATOM     21  O   GLN A   2      -1.954  -6.817   0.403  1.00  1.25           O  
ATOM     22  CB  GLN A   2       0.143  -5.963  -2.062  1.00  1.05           C  
ATOM     23  CG  GLN A   2       1.498  -5.357  -2.375  1.00  1.64           C  
ATOM     24  CD  GLN A   2       2.245  -6.122  -3.451  1.00  2.33           C  
ATOM     25  OE1 GLN A   2       1.637  -6.718  -4.341  1.00  2.91           O  
ATOM     26  NE2 GLN A   2       3.571  -6.105  -3.377  1.00  2.94           N  
ATOM     27  H   GLN A   2       1.018  -6.087   0.369  1.00  1.91           H  
ATOM     28  HA  GLN A   2      -0.751  -4.295  -1.063  1.00  1.23           H  
ATOM     29  HB2 GLN A   2       0.275  -7.018  -1.881  1.00  1.72           H  
ATOM     30  HG2 GLN A   2       1.350  -4.346  -2.713  1.00  2.05           H  
ATOM     31 HE21 GLN A   2       3.987  -5.608  -2.641  1.00  3.09           H  
ATOM     32 HE22 GLN A   2       4.080  -6.590  -4.061  1.00  3.52           H  
ATOM     33  N   PHE A   3      -2.855  -5.800  -1.392  1.00  0.64           N  
ATOM     34  CA  PHE A   3      -4.163  -6.423  -1.229  1.00  0.59           C  
ATOM     35  C   PHE A   3      -4.437  -7.414  -2.357  1.00  0.50           C  
ATOM     36  O   PHE A   3      -4.624  -7.020  -3.508  1.00  0.55           O  
ATOM     37  CB  PHE A   3      -5.258  -5.355  -1.193  1.00  0.80           C  
ATOM     38  CG  PHE A   3      -5.113  -4.382  -0.058  1.00  0.75           C  
ATOM     39  CD1 PHE A   3      -4.374  -3.220  -0.212  1.00  0.80           C  
ATOM     40  CD2 PHE A   3      -5.718  -4.628   1.165  1.00  1.47           C  
ATOM     41  CE1 PHE A   3      -4.241  -2.323   0.830  1.00  1.39           C  
ATOM     42  CE2 PHE A   3      -5.588  -3.735   2.211  1.00  2.25           C  
ATOM     43  CZ  PHE A   3      -4.847  -2.581   2.044  1.00  2.18           C  
ATOM     44  H   PHE A   3      -2.711  -5.179  -2.138  1.00  0.92           H  
ATOM     45  HA  PHE A   3      -4.161  -6.956  -0.290  1.00  0.71           H  
ATOM     46  HB2 PHE A   3      -5.234  -4.795  -2.116  1.00  1.45           H  
ATOM     47  HD1 PHE A   3      -3.898  -3.018  -1.161  1.00  0.91           H  
ATOM     48  HD2 PHE A   3      -6.295  -5.531   1.297  1.00  1.57           H  
ATOM     49  HE1 PHE A   3      -3.663  -1.421   0.696  1.00  1.42           H  
ATOM     50  HE2 PHE A   3      -6.063  -3.939   3.160  1.00  2.96           H  
ATOM     51  HZ  PHE A   3      -4.744  -1.881   2.861  1.00  2.81           H  
ATOM     52  N   THR A   4      -4.455  -8.699  -2.018  1.00  0.53           N  
ATOM     53  CA  THR A   4      -4.704  -9.744  -3.002  1.00  0.49           C  
ATOM     54  C   THR A   4      -6.077 -10.381  -2.806  1.00  0.45           C  
ATOM     55  O   THR A   4      -6.584 -10.445  -1.685  1.00  0.45           O  
ATOM     56  CB  THR A   4      -3.629 -10.843  -2.941  1.00  0.57           C  
ATOM     57  OG1 THR A   4      -3.471 -11.299  -1.591  1.00  0.61           O  
ATOM     58  CG2 THR A   4      -2.301 -10.328  -3.471  1.00  0.66           C  
ATOM     59  H   THR A   4      -4.294  -8.949  -1.085  1.00  0.66           H  
ATOM     60  HA  THR A   4      -4.668  -9.294  -3.985  1.00  0.50           H  
ATOM     61  HB  THR A   4      -3.947 -11.673  -3.557  1.00  0.57           H  
ATOM     62  HG1 THR A   4      -2.665 -11.816  -1.518  1.00  1.09           H  
ATOM     63 HG21 THR A   4      -1.558 -11.110  -3.404  1.00  1.23           H  
ATOM     64 HG22 THR A   4      -1.984  -9.480  -2.883  1.00  1.30           H  
ATOM     65 HG23 THR A   4      -2.416 -10.030  -4.502  1.00  1.11           H  
ATOM     66  N   PRO A   5      -6.695 -10.862  -3.898  1.00  0.47           N  
ATOM     67  CA  PRO A   5      -8.013 -11.497  -3.842  1.00  0.51           C  
ATOM     68  C   PRO A   5      -7.967 -12.871  -3.183  1.00  0.51           C  
ATOM     69  O   PRO A   5      -7.851 -13.893  -3.858  1.00  0.65           O  
ATOM     70  CB  PRO A   5      -8.408 -11.622  -5.316  1.00  0.62           C  
ATOM     71  CG  PRO A   5      -7.114 -11.683  -6.049  1.00  0.58           C  
ATOM     72  CD  PRO A   5      -6.157 -10.821  -5.273  1.00  0.53           C  
ATOM     73  HA  PRO A   5      -8.730 -10.875  -3.327  1.00  0.60           H  
ATOM     74  HB2 PRO A   5      -8.991 -12.520  -5.462  1.00  0.77           H  
ATOM     75  HG2 PRO A   5      -6.758 -12.702  -6.083  1.00  0.73           H  
ATOM     76  HD2 PRO A   5      -5.160 -11.238  -5.308  1.00  0.56           H  
ATOM     77  N   ASP A   6      -8.056 -12.885  -1.856  1.00  0.74           N  
ATOM     78  CA  ASP A   6      -8.027 -14.131  -1.097  1.00  0.84           C  
ATOM     79  C   ASP A   6      -8.086 -13.856   0.402  1.00  0.71           C  
ATOM     80  O   ASP A   6      -8.756 -14.571   1.148  1.00  0.67           O  
ATOM     81  CB  ASP A   6      -6.761 -14.927  -1.427  1.00  1.07           C  
ATOM     82  CG  ASP A   6      -5.494 -14.144  -1.142  1.00  2.06           C  
ATOM     83  OD1 ASP A   6      -5.027 -13.421  -2.045  1.00  2.69           O  
ATOM     84  OD2 ASP A   6      -4.972 -14.253  -0.013  1.00  2.51           O  
ATOM     85  H   ASP A   6      -8.141 -12.036  -1.374  1.00  0.97           H  
ATOM     86  HA  ASP A   6      -8.892 -14.711  -1.379  1.00  0.95           H  
ATOM     87  HB2 ASP A   6      -6.747 -15.827  -0.834  1.00  1.14           H  
ATOM     88  N   SER A   7      -7.380 -12.820   0.837  1.00  0.77           N  
ATOM     89  CA  SER A   7      -7.352 -12.453   2.248  1.00  0.72           C  
ATOM     90  C   SER A   7      -8.541 -11.565   2.605  1.00  0.54           C  
ATOM     91  O   SER A   7      -9.201 -11.012   1.726  1.00  0.67           O  
ATOM     92  CB  SER A   7      -6.043 -11.737   2.583  1.00  0.96           C  
ATOM     93  OG  SER A   7      -6.005 -11.357   3.947  1.00  1.89           O  
ATOM     94  H   SER A   7      -6.864 -12.289   0.195  1.00  0.90           H  
ATOM     95  HA  SER A   7      -7.412 -13.362   2.828  1.00  0.72           H  
ATOM     96  HB2 SER A   7      -5.213 -12.395   2.381  1.00  1.05           H  
ATOM     97  HG  SER A   7      -5.974 -10.399   4.013  1.00  2.32           H  
ATOM     98  N   ALA A   8      -8.807 -11.433   3.901  1.00  0.47           N  
ATOM     99  CA  ALA A   8      -9.920 -10.615   4.374  1.00  0.35           C  
ATOM    100  C   ALA A   8      -9.428  -9.282   4.930  1.00  0.31           C  
ATOM    101  O   ALA A   8      -8.237  -9.106   5.189  1.00  0.38           O  
ATOM    102  CB  ALA A   8     -10.713 -11.370   5.431  1.00  0.44           C  
ATOM    103  H   ALA A   8      -8.241 -11.895   4.554  1.00  0.66           H  
ATOM    104  HA  ALA A   8     -10.572 -10.425   3.535  1.00  0.35           H  
ATOM    105  HB1 ALA A   8     -10.105 -11.499   6.314  1.00  1.16           H  
ATOM    106  HB2 ALA A   8     -11.599 -10.805   5.685  1.00  1.04           H  
ATOM    107  HB3 ALA A   8     -10.999 -12.335   5.046  1.00  1.13           H  
ATOM    108  N   TRP A   9     -10.354  -8.344   5.110  1.00  0.30           N  
ATOM    109  CA  TRP A   9     -10.020  -7.023   5.636  1.00  0.30           C  
ATOM    110  C   TRP A   9     -11.232  -6.384   6.307  1.00  0.32           C  
ATOM    111  O   TRP A   9     -12.335  -6.930   6.267  1.00  0.39           O  
ATOM    112  CB  TRP A   9      -9.509  -6.119   4.514  1.00  0.34           C  
ATOM    113  CG  TRP A   9      -8.365  -6.711   3.748  1.00  0.35           C  
ATOM    114  CD1 TRP A   9      -8.447  -7.552   2.675  1.00  0.40           C  
ATOM    115  CD2 TRP A   9      -6.969  -6.507   3.994  1.00  0.42           C  
ATOM    116  NE1 TRP A   9      -7.187  -7.882   2.241  1.00  0.41           N  
ATOM    117  CE2 TRP A   9      -6.263  -7.255   3.032  1.00  0.42           C  
ATOM    118  CE3 TRP A   9      -6.246  -5.766   4.933  1.00  0.56           C  
ATOM    119  CZ2 TRP A   9      -4.871  -7.283   2.984  1.00  0.52           C  
ATOM    120  CZ3 TRP A   9      -4.865  -5.793   4.884  1.00  0.69           C  
ATOM    121  CH2 TRP A   9      -4.190  -6.546   3.916  1.00  0.66           C  
ATOM    122  H   TRP A   9     -11.286  -8.544   4.883  1.00  0.34           H  
ATOM    123  HA  TRP A   9      -9.238  -7.147   6.371  1.00  0.31           H  
ATOM    124  HB2 TRP A   9     -10.313  -5.930   3.819  1.00  0.36           H  
ATOM    125  HD1 TRP A   9      -9.374  -7.897   2.244  1.00  0.49           H  
ATOM    126  HE1 TRP A   9      -6.984  -8.473   1.484  1.00  0.47           H  
ATOM    127  HE3 TRP A   9      -6.749  -5.179   5.688  1.00  0.60           H  
ATOM    128  HZ2 TRP A   9      -4.336  -7.857   2.244  1.00  0.54           H  
ATOM    129  HZ3 TRP A   9      -4.290  -5.227   5.603  1.00  0.84           H  
ATOM    130  HH2 TRP A   9      -3.111  -6.540   3.915  1.00  0.77           H  
ATOM    131  N   LYS A  10     -11.022  -5.225   6.925  1.00  0.34           N  
ATOM    132  CA  LYS A  10     -12.100  -4.514   7.601  1.00  0.37           C  
ATOM    133  C   LYS A  10     -12.185  -3.066   7.125  1.00  0.34           C  
ATOM    134  O   LYS A  10     -11.169  -2.377   7.020  1.00  0.34           O  
ATOM    135  CB  LYS A  10     -11.897  -4.556   9.117  1.00  0.43           C  
ATOM    136  CG  LYS A  10     -11.922  -5.964   9.692  1.00  1.01           C  
ATOM    137  CD  LYS A  10     -11.610  -5.964  11.180  1.00  1.03           C  
ATOM    138  CE  LYS A  10     -11.690  -7.367  11.762  1.00  1.28           C  
ATOM    139  NZ  LYS A  10     -11.330  -7.390  13.206  1.00  2.04           N  
ATOM    140  H   LYS A  10     -10.121  -4.839   6.926  1.00  0.40           H  
ATOM    141  HA  LYS A  10     -13.027  -5.012   7.359  1.00  0.42           H  
ATOM    142  HB2 LYS A  10     -10.943  -4.109   9.353  1.00  0.74           H  
ATOM    143  HG2 LYS A  10     -12.903  -6.386   9.539  1.00  1.60           H  
ATOM    144  HD2 LYS A  10     -10.613  -5.580  11.330  1.00  1.63           H  
ATOM    145  HE2 LYS A  10     -12.698  -7.735  11.646  1.00  1.73           H  
ATOM    146  HZ1 LYS A  10     -10.347  -7.074  13.336  1.00  2.50           H  
ATOM    147  HZ2 LYS A  10     -11.423  -8.356  13.582  1.00  2.52           H  
ATOM    148  HZ3 LYS A  10     -11.960  -6.760  13.742  1.00  2.42           H  
ATOM    149  N   ILE A  11     -13.402  -2.610   6.840  1.00  0.36           N  
ATOM    150  CA  ILE A  11     -13.620  -1.249   6.371  1.00  0.36           C  
ATOM    151  C   ILE A  11     -13.476  -0.241   7.506  1.00  0.32           C  
ATOM    152  O   ILE A  11     -14.126  -0.362   8.545  1.00  0.38           O  
ATOM    153  CB  ILE A  11     -15.013  -1.091   5.733  1.00  0.41           C  
ATOM    154  CG1 ILE A  11     -15.187  -2.092   4.587  1.00  0.48           C  
ATOM    155  CG2 ILE A  11     -15.216   0.333   5.234  1.00  0.43           C  
ATOM    156  CD1 ILE A  11     -16.528  -1.991   3.894  1.00  0.56           C  
ATOM    157  H   ILE A  11     -14.171  -3.204   6.950  1.00  0.39           H  
ATOM    158  HA  ILE A  11     -12.877  -1.034   5.616  1.00  0.38           H  
ATOM    159  HB  ILE A  11     -15.757  -1.291   6.490  1.00  0.41           H  
ATOM    160 HG12 ILE A  11     -14.420  -1.920   3.849  1.00  0.50           H  
ATOM    161 HG21 ILE A  11     -16.197   0.422   4.788  1.00  1.11           H  
ATOM    162 HG22 ILE A  11     -15.134   1.019   6.064  1.00  0.98           H  
ATOM    163 HG23 ILE A  11     -14.462   0.566   4.498  1.00  1.04           H  
ATOM    164 HD11 ILE A  11     -16.654  -0.997   3.492  1.00  1.01           H  
ATOM    165 HD12 ILE A  11     -16.572  -2.713   3.092  1.00  1.20           H  
ATOM    166 HD13 ILE A  11     -17.318  -2.195   4.604  1.00  1.21           H  
ATOM    167  N   THR A  12     -12.617   0.752   7.294  1.00  0.28           N  
ATOM    168  CA  THR A  12     -12.379   1.790   8.287  1.00  0.27           C  
ATOM    169  C   THR A  12     -12.250   3.154   7.616  1.00  0.27           C  
ATOM    170  O   THR A  12     -11.321   3.912   7.887  1.00  0.30           O  
ATOM    171  CB  THR A  12     -11.103   1.499   9.102  1.00  0.30           C  
ATOM    172  OG1 THR A  12     -11.108   0.138   9.548  1.00  0.91           O  
ATOM    173  CG2 THR A  12     -11.002   2.426  10.306  1.00  0.97           C  
ATOM    174  H   THR A  12     -12.131   0.786   6.443  1.00  0.31           H  
ATOM    175  HA  THR A  12     -13.221   1.807   8.962  1.00  0.27           H  
ATOM    176  HB  THR A  12     -10.244   1.660   8.468  1.00  0.71           H  
ATOM    177  HG1 THR A  12     -10.816  -0.434   8.833  1.00  1.25           H  
ATOM    178 HG21 THR A  12     -11.891   2.329  10.908  1.00  1.46           H  
ATOM    179 HG22 THR A  12     -10.904   3.447   9.968  1.00  1.48           H  
ATOM    180 HG23 THR A  12     -10.138   2.157  10.894  1.00  1.64           H  
ATOM    181  N   GLY A  13     -13.193   3.455   6.729  1.00  0.29           N  
ATOM    182  CA  GLY A  13     -13.176   4.725   6.025  1.00  0.33           C  
ATOM    183  C   GLY A  13     -13.028   5.913   6.954  1.00  0.37           C  
ATOM    184  O   GLY A  13     -14.018   6.447   7.456  1.00  0.45           O  
ATOM    185  H   GLY A  13     -13.902   2.806   6.549  1.00  0.31           H  
ATOM    186  HA2 GLY A  13     -12.354   4.725   5.326  1.00  0.31           H  
ATOM    187  HA3 GLY A  13     -14.100   4.828   5.474  1.00  0.39           H  
ATOM    188  N   PHE A  14     -11.788   6.327   7.188  1.00  0.34           N  
ATOM    189  CA  PHE A  14     -11.508   7.463   8.059  1.00  0.41           C  
ATOM    190  C   PHE A  14     -10.275   8.222   7.580  1.00  0.39           C  
ATOM    191  O   PHE A  14      -9.144   7.836   7.880  1.00  0.43           O  
ATOM    192  CB  PHE A  14     -11.308   6.993   9.501  1.00  0.50           C  
ATOM    193  CG  PHE A  14     -10.965   8.104  10.451  1.00  0.60           C  
ATOM    194  CD1 PHE A  14      -9.647   8.463  10.673  1.00  0.69           C  
ATOM    195  CD2 PHE A  14     -11.965   8.788  11.126  1.00  0.70           C  
ATOM    196  CE1 PHE A  14      -9.329   9.488  11.546  1.00  0.79           C  
ATOM    197  CE2 PHE A  14     -11.654   9.811  12.000  1.00  0.81           C  
ATOM    198  CZ  PHE A  14     -10.335  10.161  12.212  1.00  0.81           C  
ATOM    199  H   PHE A  14     -11.040   5.859   6.763  1.00  0.30           H  
ATOM    200  HA  PHE A  14     -12.360   8.127   8.021  1.00  0.45           H  
ATOM    201  HB2 PHE A  14     -12.217   6.525   9.849  1.00  0.53           H  
ATOM    202  HD1 PHE A  14      -8.859   7.939  10.153  1.00  0.75           H  
ATOM    203  HD2 PHE A  14     -12.997   8.515  10.961  1.00  0.77           H  
ATOM    204  HE1 PHE A  14      -8.297   9.759  11.709  1.00  0.91           H  
ATOM    205  HE2 PHE A  14     -12.442  10.337  12.520  1.00  0.93           H  
ATOM    206  HZ  PHE A  14     -10.090  10.961  12.896  1.00  0.90           H  
ATOM    207  N   SER A  15     -10.497   9.296   6.829  1.00  0.40           N  
ATOM    208  CA  SER A  15      -9.398  10.102   6.311  1.00  0.41           C  
ATOM    209  C   SER A  15      -9.286  11.418   7.074  1.00  0.43           C  
ATOM    210  O   SER A  15     -10.009  11.650   8.043  1.00  0.48           O  
ATOM    211  CB  SER A  15      -9.602  10.384   4.822  1.00  0.39           C  
ATOM    212  OG  SER A  15      -9.857   9.188   4.107  1.00  0.76           O  
ATOM    213  H   SER A  15     -11.418   9.552   6.618  1.00  0.43           H  
ATOM    214  HA  SER A  15      -8.484   9.544   6.443  1.00  0.45           H  
ATOM    215  HB2 SER A  15     -10.440  11.049   4.696  1.00  0.73           H  
ATOM    216  HG  SER A  15     -10.686   8.806   4.405  1.00  1.26           H  
ATOM    217  N   ARG A  16      -8.372  12.275   6.631  1.00  0.57           N  
ATOM    218  CA  ARG A  16      -8.164  13.569   7.269  1.00  0.61           C  
ATOM    219  C   ARG A  16      -9.117  14.618   6.702  1.00  0.59           C  
ATOM    220  O   ARG A  16      -9.386  15.634   7.343  1.00  0.63           O  
ATOM    221  CB  ARG A  16      -6.718  14.031   7.082  1.00  0.69           C  
ATOM    222  CG  ARG A  16      -5.686  13.095   7.692  1.00  1.14           C  
ATOM    223  CD  ARG A  16      -5.570  11.798   6.906  1.00  1.37           C  
ATOM    224  NE  ARG A  16      -4.367  11.051   7.265  1.00  2.19           N  
ATOM    225  CZ  ARG A  16      -4.068   9.856   6.768  1.00  2.67           C  
ATOM    226  NH1 ARG A  16      -4.887   9.271   5.905  1.00  2.41           N  
ATOM    227  NH2 ARG A  16      -2.951   9.243   7.136  1.00  3.58           N  
ATOM    228  H   ARG A  16      -7.824  12.032   5.855  1.00  0.72           H  
ATOM    229  HA  ARG A  16      -8.362  13.454   8.323  1.00  0.65           H  
ATOM    230  HB2 ARG A  16      -6.513  14.113   6.024  1.00  1.39           H  
ATOM    231  HG2 ARG A  16      -4.725  13.588   7.696  1.00  1.69           H  
ATOM    232  HD2 ARG A  16      -6.434  11.185   7.114  1.00  1.50           H  
ATOM    233  HE  ARG A  16      -3.750  11.463   7.905  1.00  2.55           H  
ATOM    234 HH11 ARG A  16      -5.730   9.731   5.625  1.00  1.97           H  
ATOM    235 HH12 ARG A  16      -4.662   8.372   5.531  1.00  2.83           H  
ATOM    236 HH21 ARG A  16      -2.333   9.681   7.790  1.00  3.94           H  
ATOM    237 HH22 ARG A  16      -2.727   8.343   6.762  1.00  3.96           H  
ATOM    238  N   ASP A  17      -9.625  14.369   5.498  1.00  0.58           N  
ATOM    239  CA  ASP A  17     -10.543  15.301   4.850  1.00  0.63           C  
ATOM    240  C   ASP A  17     -11.557  14.561   3.982  1.00  0.57           C  
ATOM    241  O   ASP A  17     -12.059  15.106   3.001  1.00  0.62           O  
ATOM    242  CB  ASP A  17      -9.759  16.299   3.996  1.00  0.77           C  
ATOM    243  CG  ASP A  17      -8.916  15.619   2.935  1.00  1.61           C  
ATOM    244  OD1 ASP A  17      -7.747  15.289   3.228  1.00  2.48           O  
ATOM    245  OD2 ASP A  17      -9.424  15.414   1.812  1.00  1.86           O  
ATOM    246  H   ASP A  17      -9.376  13.544   5.033  1.00  0.56           H  
ATOM    247  HA  ASP A  17     -11.070  15.839   5.623  1.00  0.66           H  
ATOM    248  HB2 ASP A  17     -10.453  16.964   3.505  1.00  1.47           H  
ATOM    249  N   ILE A  18     -11.862  13.320   4.356  1.00  0.51           N  
ATOM    250  CA  ILE A  18     -12.818  12.507   3.607  1.00  0.50           C  
ATOM    251  C   ILE A  18     -14.077  13.300   3.268  1.00  0.50           C  
ATOM    252  O   ILE A  18     -14.754  13.819   4.156  1.00  0.57           O  
ATOM    253  CB  ILE A  18     -13.222  11.245   4.394  1.00  0.48           C  
ATOM    254  CG1 ILE A  18     -14.185  10.391   3.570  1.00  0.52           C  
ATOM    255  CG2 ILE A  18     -13.849  11.628   5.725  1.00  0.47           C  
ATOM    256  CD1 ILE A  18     -14.546   9.080   4.234  1.00  0.56           C  
ATOM    257  H   ILE A  18     -11.431  12.940   5.149  1.00  0.50           H  
ATOM    258  HA  ILE A  18     -12.344  12.195   2.690  1.00  0.56           H  
ATOM    259  HB  ILE A  18     -12.330  10.674   4.598  1.00  0.53           H  
ATOM    260 HG12 ILE A  18     -15.099  10.944   3.408  1.00  0.51           H  
ATOM    261 HG21 ILE A  18     -14.020  10.740   6.314  1.00  1.10           H  
ATOM    262 HG22 ILE A  18     -13.184  12.291   6.259  1.00  1.06           H  
ATOM    263 HG23 ILE A  18     -14.789  12.130   5.549  1.00  1.17           H  
ATOM    264 HD11 ILE A  18     -13.653   8.490   4.375  1.00  1.15           H  
ATOM    265 HD12 ILE A  18     -15.003   9.276   5.192  1.00  1.11           H  
ATOM    266 HD13 ILE A  18     -15.240   8.537   3.608  1.00  1.13           H  
ATOM    267  N   SER A  19     -14.384  13.388   1.978  1.00  0.57           N  
ATOM    268  CA  SER A  19     -15.561  14.119   1.519  1.00  0.59           C  
ATOM    269  C   SER A  19     -16.839  13.354   1.846  1.00  0.52           C  
ATOM    270  O   SER A  19     -16.821  12.132   1.996  1.00  0.50           O  
ATOM    271  CB  SER A  19     -15.473  14.370   0.014  1.00  0.70           C  
ATOM    272  OG  SER A  19     -15.401  13.149  -0.705  1.00  1.50           O  
ATOM    273  H   SER A  19     -13.806  12.950   1.318  1.00  0.68           H  
ATOM    274  HA  SER A  19     -15.583  15.068   2.033  1.00  0.59           H  
ATOM    275  HB2 SER A  19     -16.350  14.912  -0.311  1.00  1.12           H  
ATOM    276  HG  SER A  19     -15.823  13.256  -1.561  1.00  2.01           H  
ATOM    277  N   PRO A  20     -17.974  14.069   1.961  1.00  0.54           N  
ATOM    278  CA  PRO A  20     -19.266  13.451   2.271  1.00  0.51           C  
ATOM    279  C   PRO A  20     -19.755  12.544   1.151  1.00  0.53           C  
ATOM    280  O   PRO A  20     -20.493  11.589   1.390  1.00  0.51           O  
ATOM    281  CB  PRO A  20     -20.207  14.648   2.441  1.00  0.55           C  
ATOM    282  CG  PRO A  20     -19.564  15.751   1.677  1.00  0.61           C  
ATOM    283  CD  PRO A  20     -18.083  15.530   1.794  1.00  0.61           C  
ATOM    284  HA  PRO A  20     -19.223  12.890   3.194  1.00  0.49           H  
ATOM    285  HB2 PRO A  20     -21.180  14.402   2.041  1.00  0.56           H  
ATOM    286  HG2 PRO A  20     -19.869  15.708   0.641  1.00  0.64           H  
ATOM    287  HD2 PRO A  20     -17.580  15.853   0.894  1.00  0.68           H  
ATOM    288  N   ALA A  21     -19.341  12.844  -0.075  1.00  0.58           N  
ATOM    289  CA  ALA A  21     -19.738  12.044  -1.228  1.00  0.64           C  
ATOM    290  C   ALA A  21     -19.482  10.562  -0.974  1.00  0.62           C  
ATOM    291  O   ALA A  21     -20.327   9.717  -1.260  1.00  0.65           O  
ATOM    292  CB  ALA A  21     -18.995  12.506  -2.472  1.00  0.71           C  
ATOM    293  H   ALA A  21     -18.759  13.621  -0.206  1.00  0.61           H  
ATOM    294  HA  ALA A  21     -20.795  12.195  -1.390  1.00  0.66           H  
ATOM    295  HB1 ALA A  21     -19.227  13.542  -2.666  1.00  1.32           H  
ATOM    296  HB2 ALA A  21     -17.931  12.399  -2.315  1.00  1.13           H  
ATOM    297  HB3 ALA A  21     -19.298  11.904  -3.316  1.00  1.30           H  
ATOM    298  N   TYR A  22     -18.306  10.258  -0.434  1.00  0.60           N  
ATOM    299  CA  TYR A  22     -17.934   8.880  -0.135  1.00  0.61           C  
ATOM    300  C   TYR A  22     -18.448   8.457   1.238  1.00  0.54           C  
ATOM    301  O   TYR A  22     -18.863   7.313   1.431  1.00  0.57           O  
ATOM    302  CB  TYR A  22     -16.414   8.715  -0.192  1.00  0.66           C  
ATOM    303  CG  TYR A  22     -15.825   8.976  -1.560  1.00  0.90           C  
ATOM    304  CD1 TYR A  22     -15.874   8.005  -2.553  1.00  0.99           C  
ATOM    305  CD2 TYR A  22     -15.224  10.193  -1.858  1.00  1.28           C  
ATOM    306  CE1 TYR A  22     -15.336   8.239  -3.803  1.00  1.34           C  
ATOM    307  CE2 TYR A  22     -14.685  10.432  -3.108  1.00  1.72           C  
ATOM    308  CZ  TYR A  22     -14.743   9.453  -4.076  1.00  1.72           C  
ATOM    309  OH  TYR A  22     -14.207   9.689  -5.321  1.00  2.17           O  
ATOM    310  H   TYR A  22     -17.673  10.978  -0.233  1.00  0.60           H  
ATOM    311  HA  TYR A  22     -18.382   8.247  -0.885  1.00  0.66           H  
ATOM    312  HB2 TYR A  22     -15.959   9.407   0.501  1.00  0.78           H  
ATOM    313  HD1 TYR A  22     -16.340   7.056  -2.336  1.00  0.96           H  
ATOM    314  HD2 TYR A  22     -15.181  10.957  -1.098  1.00  1.30           H  
ATOM    315  HE1 TYR A  22     -15.382   7.471  -4.563  1.00  1.41           H  
ATOM    316  HE2 TYR A  22     -14.220  11.385  -3.322  1.00  2.11           H  
ATOM    317  HH  TYR A  22     -14.803   9.357  -5.995  1.00  2.53           H  
ATOM    318  N   ARG A  23     -18.416   9.384   2.190  1.00  0.48           N  
ATOM    319  CA  ARG A  23     -18.870   9.102   3.548  1.00  0.44           C  
ATOM    320  C   ARG A  23     -20.387   8.937   3.604  1.00  0.45           C  
ATOM    321  O   ARG A  23     -20.893   7.873   3.964  1.00  0.45           O  
ATOM    322  CB  ARG A  23     -18.440  10.226   4.492  1.00  0.45           C  
ATOM    323  CG  ARG A  23     -18.858  10.002   5.936  1.00  0.54           C  
ATOM    324  CD  ARG A  23     -18.170   8.784   6.529  1.00  0.53           C  
ATOM    325  NE  ARG A  23     -18.561   8.555   7.917  1.00  0.70           N  
ATOM    326  CZ  ARG A  23     -17.846   7.837   8.775  1.00  1.08           C  
ATOM    327  NH1 ARG A  23     -16.709   7.273   8.385  1.00  1.57           N  
ATOM    328  NH2 ARG A  23     -18.264   7.679  10.022  1.00  1.47           N  
ATOM    329  H   ARG A  23     -18.079  10.279   1.974  1.00  0.51           H  
ATOM    330  HA  ARG A  23     -18.408   8.180   3.869  1.00  0.44           H  
ATOM    331  HB2 ARG A  23     -17.364  10.314   4.461  1.00  0.49           H  
ATOM    332  HG2 ARG A  23     -18.590  10.873   6.517  1.00  0.91           H  
ATOM    333  HD2 ARG A  23     -18.434   7.917   5.943  1.00  0.89           H  
ATOM    334  HE  ARG A  23     -19.398   8.961   8.225  1.00  1.08           H  
ATOM    335 HH11 ARG A  23     -16.391   7.388   7.443  1.00  1.70           H  
ATOM    336 HH12 ARG A  23     -16.171   6.734   9.032  1.00  2.02           H  
ATOM    337 HH21 ARG A  23     -19.120   8.103  10.320  1.00  1.70           H  
ATOM    338 HH22 ARG A  23     -17.724   7.138  10.667  1.00  1.78           H  
ATOM    339  N   GLN A  24     -21.105   9.994   3.241  1.00  0.49           N  
ATOM    340  CA  GLN A  24     -22.562   9.975   3.253  1.00  0.55           C  
ATOM    341  C   GLN A  24     -23.117   8.859   2.367  1.00  0.58           C  
ATOM    342  O   GLN A  24     -24.275   8.466   2.507  1.00  0.66           O  
ATOM    343  CB  GLN A  24     -23.109  11.326   2.787  1.00  0.69           C  
ATOM    344  CG  GLN A  24     -24.627  11.421   2.838  1.00  1.52           C  
ATOM    345  CD  GLN A  24     -25.146  12.746   2.317  1.00  2.03           C  
ATOM    346  OE1 GLN A  24     -24.475  13.772   2.424  1.00  2.61           O  
ATOM    347  NE2 GLN A  24     -26.346  12.731   1.751  1.00  2.69           N  
ATOM    348  H   GLN A  24     -20.641  10.810   2.956  1.00  0.51           H  
ATOM    349  HA  GLN A  24     -22.881   9.802   4.269  1.00  0.55           H  
ATOM    350  HB2 GLN A  24     -22.702  12.104   3.417  1.00  1.07           H  
ATOM    351  HG2 GLN A  24     -25.044  10.626   2.236  1.00  2.31           H  
ATOM    352 HE21 GLN A  24     -26.824  11.875   1.701  1.00  2.90           H  
ATOM    353 HE22 GLN A  24     -26.707  13.574   1.406  1.00  3.29           H  
ATOM    354  N   LYS A  25     -22.290   8.354   1.459  1.00  0.59           N  
ATOM    355  CA  LYS A  25     -22.702   7.292   0.555  1.00  0.68           C  
ATOM    356  C   LYS A  25     -22.760   5.947   1.276  1.00  0.61           C  
ATOM    357  O   LYS A  25     -23.800   5.290   1.303  1.00  0.71           O  
ATOM    358  CB  LYS A  25     -21.740   7.217  -0.629  1.00  0.79           C  
ATOM    359  CG  LYS A  25     -21.969   6.014  -1.524  1.00  0.99           C  
ATOM    360  CD  LYS A  25     -20.899   5.909  -2.598  1.00  1.43           C  
ATOM    361  CE  LYS A  25     -20.869   7.148  -3.478  1.00  2.05           C  
ATOM    362  NZ  LYS A  25     -22.159   7.357  -4.191  1.00  2.59           N  
ATOM    363  H   LYS A  25     -21.377   8.700   1.392  1.00  0.60           H  
ATOM    364  HA  LYS A  25     -23.690   7.533   0.190  1.00  0.77           H  
ATOM    365  HB2 LYS A  25     -21.851   8.109  -1.227  1.00  1.21           H  
ATOM    366  HG2 LYS A  25     -21.944   5.124  -0.915  1.00  1.59           H  
ATOM    367  HD2 LYS A  25     -19.937   5.792  -2.125  1.00  1.99           H  
ATOM    368  HE2 LYS A  25     -20.668   8.008  -2.856  1.00  2.54           H  
ATOM    369  HZ1 LYS A  25     -22.371   6.536  -4.794  1.00  3.07           H  
ATOM    370  HZ2 LYS A  25     -22.104   8.207  -4.788  1.00  2.83           H  
ATOM    371  HZ3 LYS A  25     -22.931   7.478  -3.505  1.00  2.95           H  
ATOM    372  N   LEU A  26     -21.635   5.543   1.856  1.00  0.55           N  
ATOM    373  CA  LEU A  26     -21.558   4.272   2.570  1.00  0.57           C  
ATOM    374  C   LEU A  26     -22.705   4.133   3.566  1.00  0.60           C  
ATOM    375  O   LEU A  26     -23.171   3.027   3.841  1.00  0.68           O  
ATOM    376  CB  LEU A  26     -20.215   4.149   3.295  1.00  0.55           C  
ATOM    377  CG  LEU A  26     -18.985   4.182   2.385  1.00  0.69           C  
ATOM    378  CD1 LEU A  26     -17.712   4.011   3.200  1.00  1.30           C  
ATOM    379  CD2 LEU A  26     -19.086   3.101   1.319  1.00  1.29           C  
ATOM    380  H   LEU A  26     -20.837   6.111   1.805  1.00  0.57           H  
ATOM    381  HA  LEU A  26     -21.634   3.481   1.840  1.00  0.69           H  
ATOM    382  HB2 LEU A  26     -20.136   4.962   4.001  1.00  0.66           H  
ATOM    383  HG  LEU A  26     -18.938   5.140   1.887  1.00  1.38           H  
ATOM    384 HD11 LEU A  26     -16.860   4.002   2.537  1.00  1.69           H  
ATOM    385 HD12 LEU A  26     -17.618   4.830   3.897  1.00  1.94           H  
ATOM    386 HD13 LEU A  26     -17.755   3.079   3.743  1.00  1.82           H  
ATOM    387 HD21 LEU A  26     -19.958   3.278   0.706  1.00  1.87           H  
ATOM    388 HD22 LEU A  26     -18.200   3.122   0.699  1.00  1.79           H  
ATOM    389 HD23 LEU A  26     -19.170   2.134   1.793  1.00  1.79           H  
ATOM    390  N   LEU A  27     -23.157   5.261   4.104  1.00  0.59           N  
ATOM    391  CA  LEU A  27     -24.251   5.263   5.065  1.00  0.71           C  
ATOM    392  C   LEU A  27     -25.450   4.486   4.532  1.00  0.82           C  
ATOM    393  O   LEU A  27     -26.174   3.842   5.291  1.00  0.95           O  
ATOM    394  CB  LEU A  27     -24.665   6.698   5.397  1.00  0.75           C  
ATOM    395  CG  LEU A  27     -23.562   7.572   5.993  1.00  0.71           C  
ATOM    396  CD1 LEU A  27     -24.095   8.959   6.318  1.00  0.82           C  
ATOM    397  CD2 LEU A  27     -22.977   6.916   7.236  1.00  0.77           C  
ATOM    398  H   LEU A  27     -22.744   6.111   3.852  1.00  0.56           H  
ATOM    399  HA  LEU A  27     -23.896   4.784   5.965  1.00  0.73           H  
ATOM    400  HB2 LEU A  27     -25.015   7.168   4.488  1.00  0.74           H  
ATOM    401  HG  LEU A  27     -22.767   7.683   5.268  1.00  0.62           H  
ATOM    402 HD11 LEU A  27     -24.902   8.877   7.029  1.00  1.38           H  
ATOM    403 HD12 LEU A  27     -23.303   9.560   6.740  1.00  1.21           H  
ATOM    404 HD13 LEU A  27     -24.459   9.427   5.413  1.00  1.25           H  
ATOM    405 HD21 LEU A  27     -22.202   7.547   7.645  1.00  1.22           H  
ATOM    406 HD22 LEU A  27     -23.758   6.781   7.971  1.00  1.16           H  
ATOM    407 HD23 LEU A  27     -22.561   5.956   6.974  1.00  1.45           H  
ATOM    408  N   SER A  28     -25.655   4.552   3.219  1.00  0.84           N  
ATOM    409  CA  SER A  28     -26.770   3.858   2.583  1.00  0.98           C  
ATOM    410  C   SER A  28     -26.647   2.347   2.757  1.00  0.89           C  
ATOM    411  O   SER A  28     -27.651   1.634   2.801  1.00  0.99           O  
ATOM    412  CB  SER A  28     -26.833   4.207   1.095  1.00  1.15           C  
ATOM    413  OG  SER A  28     -25.641   3.825   0.430  1.00  1.64           O  
ATOM    414  H   SER A  28     -25.042   5.080   2.667  1.00  0.80           H  
ATOM    415  HA  SER A  28     -27.679   4.189   3.059  1.00  1.11           H  
ATOM    416  HB2 SER A  28     -27.664   3.688   0.641  1.00  1.60           H  
ATOM    417  HG  SER A  28     -25.793   3.013  -0.058  1.00  2.09           H  
ATOM    418  N   LEU A  29     -25.414   1.864   2.854  1.00  0.78           N  
ATOM    419  CA  LEU A  29     -25.165   0.437   3.019  1.00  0.78           C  
ATOM    420  C   LEU A  29     -25.188   0.044   4.493  1.00  0.74           C  
ATOM    421  O   LEU A  29     -25.443  -1.110   4.834  1.00  0.82           O  
ATOM    422  CB  LEU A  29     -23.818   0.060   2.400  1.00  0.86           C  
ATOM    423  CG  LEU A  29     -23.686   0.367   0.907  1.00  1.06           C  
ATOM    424  CD1 LEU A  29     -22.315  -0.053   0.399  1.00  1.64           C  
ATOM    425  CD2 LEU A  29     -24.784  -0.332   0.121  1.00  1.42           C  
ATOM    426  H   LEU A  29     -24.654   2.481   2.815  1.00  0.77           H  
ATOM    427  HA  LEU A  29     -25.948  -0.098   2.506  1.00  0.85           H  
ATOM    428  HB2 LEU A  29     -23.040   0.594   2.927  1.00  0.86           H  
ATOM    429  HG  LEU A  29     -23.786   1.431   0.755  1.00  1.79           H  
ATOM    430 HD11 LEU A  29     -22.174  -1.109   0.576  1.00  2.13           H  
ATOM    431 HD12 LEU A  29     -22.246   0.148  -0.660  1.00  2.08           H  
ATOM    432 HD13 LEU A  29     -21.551   0.503   0.923  1.00  2.13           H  
ATOM    433 HD21 LEU A  29     -25.749  -0.005   0.484  1.00  1.99           H  
ATOM    434 HD22 LEU A  29     -24.691  -0.085  -0.926  1.00  1.91           H  
ATOM    435 HD23 LEU A  29     -24.695  -1.400   0.248  1.00  1.87           H  
ATOM    436  N   GLY A  30     -24.918   1.014   5.363  1.00  0.68           N  
ATOM    437  CA  GLY A  30     -24.916   0.750   6.789  1.00  0.73           C  
ATOM    438  C   GLY A  30     -23.596   0.180   7.271  1.00  0.71           C  
ATOM    439  O   GLY A  30     -23.532  -0.444   8.331  1.00  0.82           O  
ATOM    440  H   GLY A  30     -24.714   1.912   5.033  1.00  0.67           H  
ATOM    441  HA2 GLY A  30     -25.109   1.672   7.315  1.00  0.76           H  
ATOM    442  HA3 GLY A  30     -25.702   0.046   7.015  1.00  0.82           H  
ATOM    443  N   MET A  31     -22.541   0.393   6.492  1.00  0.63           N  
ATOM    444  CA  MET A  31     -21.219  -0.104   6.844  1.00  0.66           C  
ATOM    445  C   MET A  31     -20.348   1.017   7.403  1.00  0.56           C  
ATOM    446  O   MET A  31     -19.674   1.725   6.656  1.00  0.54           O  
ATOM    447  CB  MET A  31     -20.548  -0.733   5.622  1.00  0.74           C  
ATOM    448  CG  MET A  31     -21.292  -1.942   5.077  1.00  0.94           C  
ATOM    449  SD  MET A  31     -21.316  -3.323   6.237  1.00  1.95           S  
ATOM    450  CE  MET A  31     -22.344  -4.492   5.351  1.00  2.55           C  
ATOM    451  H   MET A  31     -22.656   0.896   5.658  1.00  0.62           H  
ATOM    452  HA  MET A  31     -21.341  -0.861   7.605  1.00  0.75           H  
ATOM    453  HB2 MET A  31     -20.485   0.008   4.839  1.00  0.83           H  
ATOM    454  HG2 MET A  31     -22.309  -1.653   4.861  1.00  1.20           H  
ATOM    455  HE1 MET A  31     -23.373  -4.162   5.378  1.00  2.97           H  
ATOM    456  HE2 MET A  31     -22.012  -4.558   4.325  1.00  2.93           H  
ATOM    457  HE3 MET A  31     -22.265  -5.465   5.816  1.00  2.92           H  
ATOM    458  N   LEU A  32     -20.378   1.177   8.722  1.00  0.56           N  
ATOM    459  CA  LEU A  32     -19.593   2.210   9.390  1.00  0.49           C  
ATOM    460  C   LEU A  32     -18.198   1.694   9.734  1.00  0.44           C  
ATOM    461  O   LEU A  32     -17.971   0.486   9.785  1.00  0.45           O  
ATOM    462  CB  LEU A  32     -20.306   2.676  10.661  1.00  0.52           C  
ATOM    463  CG  LEU A  32     -21.579   3.493  10.430  1.00  0.59           C  
ATOM    464  CD1 LEU A  32     -22.612   2.672   9.674  1.00  0.69           C  
ATOM    465  CD2 LEU A  32     -22.146   3.980  11.755  1.00  0.66           C  
ATOM    466  H   LEU A  32     -20.942   0.584   9.261  1.00  0.64           H  
ATOM    467  HA  LEU A  32     -19.498   3.046   8.711  1.00  0.50           H  
ATOM    468  HB2 LEU A  32     -20.565   1.804  11.243  1.00  0.56           H  
ATOM    469  HG  LEU A  32     -21.339   4.360   9.830  1.00  0.56           H  
ATOM    470 HD11 LEU A  32     -22.768   1.733  10.184  1.00  1.11           H  
ATOM    471 HD12 LEU A  32     -23.542   3.216   9.630  1.00  1.34           H  
ATOM    472 HD13 LEU A  32     -22.259   2.482   8.672  1.00  1.07           H  
ATOM    473 HD21 LEU A  32     -21.409   4.589  12.259  1.00  1.09           H  
ATOM    474 HD22 LEU A  32     -23.033   4.567  11.572  1.00  1.20           H  
ATOM    475 HD23 LEU A  32     -22.395   3.131  12.373  1.00  1.23           H  
ATOM    476  N   PRO A  33     -17.242   2.609   9.977  1.00  0.41           N  
ATOM    477  CA  PRO A  33     -15.869   2.240  10.318  1.00  0.40           C  
ATOM    478  C   PRO A  33     -15.807   1.081  11.306  1.00  0.38           C  
ATOM    479  O   PRO A  33     -16.205   1.214  12.463  1.00  0.51           O  
ATOM    480  CB  PRO A  33     -15.323   3.519  10.947  1.00  0.43           C  
ATOM    481  CG  PRO A  33     -16.052   4.613  10.248  1.00  0.45           C  
ATOM    482  CD  PRO A  33     -17.425   4.074   9.936  1.00  0.43           C  
ATOM    483  HA  PRO A  33     -15.293   1.994   9.437  1.00  0.41           H  
ATOM    484  HB2 PRO A  33     -15.526   3.519  12.007  1.00  0.44           H  
ATOM    485  HG2 PRO A  33     -16.126   5.475  10.893  1.00  0.48           H  
ATOM    486  HD2 PRO A  33     -18.133   4.394  10.685  1.00  0.44           H  
ATOM    487  N   GLY A  34     -15.304  -0.057  10.838  1.00  0.34           N  
ATOM    488  CA  GLY A  34     -15.201  -1.229  11.687  1.00  0.33           C  
ATOM    489  C   GLY A  34     -15.994  -2.404  11.150  1.00  0.31           C  
ATOM    490  O   GLY A  34     -16.479  -3.236  11.917  1.00  0.40           O  
ATOM    491  H   GLY A  34     -14.999  -0.100   9.910  1.00  0.40           H  
ATOM    492  HA2 GLY A  34     -14.162  -1.515  11.765  1.00  0.35           H  
ATOM    493  HA3 GLY A  34     -15.568  -0.980  12.672  1.00  0.35           H  
ATOM    494  N   SER A  35     -16.122  -2.477   9.829  1.00  0.28           N  
ATOM    495  CA  SER A  35     -16.864  -3.560   9.192  1.00  0.28           C  
ATOM    496  C   SER A  35     -15.914  -4.604   8.614  1.00  0.28           C  
ATOM    497  O   SER A  35     -14.698  -4.420   8.623  1.00  0.37           O  
ATOM    498  CB  SER A  35     -17.770  -3.009   8.090  1.00  0.31           C  
ATOM    499  OG  SER A  35     -18.504  -4.049   7.466  1.00  0.62           O  
ATOM    500  H   SER A  35     -15.704  -1.788   9.268  1.00  0.33           H  
ATOM    501  HA  SER A  35     -17.476  -4.030   9.948  1.00  0.31           H  
ATOM    502  HB2 SER A  35     -18.465  -2.302   8.517  1.00  0.56           H  
ATOM    503  HG  SER A  35     -18.613  -3.848   6.533  1.00  1.01           H  
ATOM    504  N   SER A  36     -16.479  -5.700   8.115  1.00  0.25           N  
ATOM    505  CA  SER A  36     -15.682  -6.774   7.530  1.00  0.25           C  
ATOM    506  C   SER A  36     -16.042  -6.982   6.062  1.00  0.23           C  
ATOM    507  O   SER A  36     -17.214  -6.941   5.687  1.00  0.28           O  
ATOM    508  CB  SER A  36     -15.896  -8.074   8.307  1.00  0.30           C  
ATOM    509  OG  SER A  36     -15.135  -9.133   7.750  1.00  1.30           O  
ATOM    510  H   SER A  36     -17.454  -5.788   8.141  1.00  0.30           H  
ATOM    511  HA  SER A  36     -14.644  -6.490   7.596  1.00  0.27           H  
ATOM    512  HB2 SER A  36     -15.590  -7.932   9.333  1.00  1.06           H  
ATOM    513  HG  SER A  36     -15.565  -9.450   6.952  1.00  1.75           H  
ATOM    514  N   PHE A  37     -15.025  -7.204   5.232  1.00  0.22           N  
ATOM    515  CA  PHE A  37     -15.239  -7.414   3.804  1.00  0.23           C  
ATOM    516  C   PHE A  37     -14.120  -8.259   3.201  1.00  0.23           C  
ATOM    517  O   PHE A  37     -13.034  -8.363   3.769  1.00  0.33           O  
ATOM    518  CB  PHE A  37     -15.324  -6.067   3.077  1.00  0.25           C  
ATOM    519  CG  PHE A  37     -14.001  -5.363   2.954  1.00  0.26           C  
ATOM    520  CD1 PHE A  37     -13.452  -4.697   4.036  1.00  0.32           C  
ATOM    521  CD2 PHE A  37     -13.306  -5.376   1.756  1.00  0.27           C  
ATOM    522  CE1 PHE A  37     -12.233  -4.053   3.925  1.00  0.36           C  
ATOM    523  CE2 PHE A  37     -12.087  -4.734   1.639  1.00  0.30           C  
ATOM    524  CZ  PHE A  37     -11.550  -4.072   2.725  1.00  0.33           C  
ATOM    525  H   PHE A  37     -14.114  -7.226   5.589  1.00  0.25           H  
ATOM    526  HA  PHE A  37     -16.177  -7.938   3.684  1.00  0.25           H  
ATOM    527  HB2 PHE A  37     -15.709  -6.228   2.081  1.00  0.28           H  
ATOM    528  HD1 PHE A  37     -13.983  -4.681   4.976  1.00  0.37           H  
ATOM    529  HD2 PHE A  37     -13.724  -5.893   0.905  1.00  0.32           H  
ATOM    530  HE1 PHE A  37     -11.815  -3.534   4.775  1.00  0.44           H  
ATOM    531  HE2 PHE A  37     -11.554  -4.753   0.700  1.00  0.34           H  
ATOM    532  HZ  PHE A  37     -10.598  -3.571   2.637  1.00  0.37           H  
ATOM    533  N   HIS A  38     -14.393  -8.860   2.046  1.00  0.21           N  
ATOM    534  CA  HIS A  38     -13.404  -9.688   1.363  1.00  0.24           C  
ATOM    535  C   HIS A  38     -12.995  -9.060   0.035  1.00  0.24           C  
ATOM    536  O   HIS A  38     -13.701  -8.211  -0.506  1.00  0.40           O  
ATOM    537  CB  HIS A  38     -13.958 -11.094   1.128  1.00  0.28           C  
ATOM    538  CG  HIS A  38     -14.311 -11.815   2.390  1.00  1.17           C  
ATOM    539  ND1 HIS A  38     -15.577 -11.805   2.935  1.00  2.13           N  
ATOM    540  CD2 HIS A  38     -13.554 -12.575   3.217  1.00  1.98           C  
ATOM    541  CE1 HIS A  38     -15.584 -12.525   4.042  1.00  2.94           C  
ATOM    542  NE2 HIS A  38     -14.370 -13.003   4.235  1.00  2.82           N  
ATOM    543  H   HIS A  38     -15.281  -8.743   1.645  1.00  0.24           H  
ATOM    544  HA  HIS A  38     -12.535  -9.755   2.000  1.00  0.27           H  
ATOM    545  HB2 HIS A  38     -14.848 -11.028   0.524  1.00  0.92           H  
ATOM    546  HD1 HIS A  38     -16.355 -11.337   2.565  1.00  2.50           H  
ATOM    547  HD2 HIS A  38     -12.505 -12.803   3.097  1.00  2.38           H  
ATOM    548  HE1 HIS A  38     -16.439 -12.696   4.681  1.00  3.83           H  
ATOM    549  HE2 HIS A  38     -14.082 -13.512   5.022  1.00  3.50           H  
ATOM    550  N   VAL A  39     -11.846  -9.484  -0.483  1.00  0.27           N  
ATOM    551  CA  VAL A  39     -11.338  -8.961  -1.746  1.00  0.27           C  
ATOM    552  C   VAL A  39     -11.667  -9.898  -2.903  1.00  0.28           C  
ATOM    553  O   VAL A  39     -11.486 -11.111  -2.802  1.00  0.40           O  
ATOM    554  CB  VAL A  39      -9.811  -8.755  -1.689  1.00  0.39           C  
ATOM    555  CG1 VAL A  39      -9.295  -8.191  -3.004  1.00  1.28           C  
ATOM    556  CG2 VAL A  39      -9.440  -7.848  -0.527  1.00  0.88           C  
ATOM    557  H   VAL A  39     -11.328 -10.163  -0.005  1.00  0.41           H  
ATOM    558  HA  VAL A  39     -11.803  -8.003  -1.926  1.00  0.27           H  
ATOM    559  HB  VAL A  39      -9.345  -9.716  -1.529  1.00  1.11           H  
ATOM    560 HG11 VAL A  39      -9.522  -8.878  -3.806  1.00  1.84           H  
ATOM    561 HG12 VAL A  39      -9.769  -7.239  -3.200  1.00  1.81           H  
ATOM    562 HG13 VAL A  39      -8.225  -8.052  -2.941  1.00  1.88           H  
ATOM    563 HG21 VAL A  39      -8.366  -7.744  -0.480  1.00  1.59           H  
ATOM    564 HG22 VAL A  39      -9.891  -6.876  -0.672  1.00  1.56           H  
ATOM    565 HG23 VAL A  39      -9.802  -8.279   0.393  1.00  1.36           H  
ATOM    566  N   VAL A  40     -12.150  -9.327  -4.001  1.00  0.24           N  
ATOM    567  CA  VAL A  40     -12.501 -10.113  -5.178  1.00  0.34           C  
ATOM    568  C   VAL A  40     -11.348 -10.149  -6.179  1.00  0.37           C  
ATOM    569  O   VAL A  40     -10.959 -11.213  -6.655  1.00  0.54           O  
ATOM    570  CB  VAL A  40     -13.756  -9.554  -5.872  1.00  0.41           C  
ATOM    571  CG1 VAL A  40     -14.114 -10.390  -7.091  1.00  0.54           C  
ATOM    572  CG2 VAL A  40     -14.922  -9.494  -4.897  1.00  0.43           C  
ATOM    573  H   VAL A  40     -12.278  -8.356  -4.020  1.00  0.23           H  
ATOM    574  HA  VAL A  40     -12.712 -11.122  -4.852  1.00  0.41           H  
ATOM    575  HB  VAL A  40     -13.542  -8.549  -6.204  1.00  0.40           H  
ATOM    576 HG11 VAL A  40     -15.026 -10.014  -7.530  1.00  1.22           H  
ATOM    577 HG12 VAL A  40     -13.316 -10.333  -7.815  1.00  1.16           H  
ATOM    578 HG13 VAL A  40     -14.258 -11.419  -6.793  1.00  1.13           H  
ATOM    579 HG21 VAL A  40     -15.187 -10.495  -4.590  1.00  1.07           H  
ATOM    580 HG22 VAL A  40     -14.637  -8.917  -4.030  1.00  1.12           H  
ATOM    581 HG23 VAL A  40     -15.770  -9.028  -5.377  1.00  1.01           H  
ATOM    582  N   ARG A  41     -10.805  -8.975  -6.490  1.00  0.27           N  
ATOM    583  CA  ARG A  41      -9.695  -8.873  -7.431  1.00  0.31           C  
ATOM    584  C   ARG A  41      -8.962  -7.545  -7.264  1.00  0.31           C  
ATOM    585  O   ARG A  41      -9.586  -6.499  -7.089  1.00  0.40           O  
ATOM    586  CB  ARG A  41     -10.205  -9.006  -8.868  1.00  0.40           C  
ATOM    587  CG  ARG A  41     -11.139  -7.885  -9.288  1.00  0.47           C  
ATOM    588  CD  ARG A  41     -11.499  -7.982 -10.761  1.00  0.57           C  
ATOM    589  NE  ARG A  41     -12.134  -9.254 -11.087  1.00  1.37           N  
ATOM    590  CZ  ARG A  41     -12.351  -9.675 -12.328  1.00  1.62           C  
ATOM    591  NH1 ARG A  41     -11.979  -8.925 -13.357  1.00  0.94           N  
ATOM    592  NH2 ARG A  41     -12.939 -10.843 -12.542  1.00  2.80           N  
ATOM    593  H   ARG A  41     -11.161  -8.160  -6.078  1.00  0.26           H  
ATOM    594  HA  ARG A  41      -9.010  -9.679  -7.225  1.00  0.34           H  
ATOM    595  HB2 ARG A  41      -9.358  -9.010  -9.538  1.00  0.44           H  
ATOM    596  HG2 ARG A  41     -12.045  -7.945  -8.703  1.00  0.47           H  
ATOM    597  HD2 ARG A  41     -12.177  -7.179 -11.007  1.00  1.21           H  
ATOM    598  HE  ARG A  41     -12.416  -9.825 -10.340  1.00  2.08           H  
ATOM    599 HH11 ARG A  41     -11.534  -8.045 -13.200  1.00  0.93           H  
ATOM    600 HH12 ARG A  41     -12.142  -9.244 -14.293  1.00  1.14           H  
ATOM    601 HH21 ARG A  41     -13.220 -11.410 -11.767  1.00  3.53           H  
ATOM    602 HH22 ARG A  41     -13.104 -11.156 -13.478  1.00  3.00           H  
ATOM    603  N   VAL A  42      -7.636  -7.593  -7.319  1.00  0.33           N  
ATOM    604  CA  VAL A  42      -6.825  -6.390  -7.167  1.00  0.39           C  
ATOM    605  C   VAL A  42      -5.564  -6.456  -8.024  1.00  0.43           C  
ATOM    606  O   VAL A  42      -5.115  -7.537  -8.407  1.00  0.49           O  
ATOM    607  CB  VAL A  42      -6.423  -6.172  -5.697  1.00  0.52           C  
ATOM    608  CG1 VAL A  42      -5.770  -4.810  -5.516  1.00  0.97           C  
ATOM    609  CG2 VAL A  42      -7.632  -6.317  -4.788  1.00  1.20           C  
ATOM    610  H   VAL A  42      -7.191  -8.454  -7.464  1.00  0.38           H  
ATOM    611  HA  VAL A  42      -7.419  -5.543  -7.485  1.00  0.41           H  
ATOM    612  HB  VAL A  42      -5.703  -6.929  -5.425  1.00  1.31           H  
ATOM    613 HG11 VAL A  42      -4.865  -4.763  -6.103  1.00  1.59           H  
ATOM    614 HG12 VAL A  42      -6.452  -4.039  -5.839  1.00  1.47           H  
ATOM    615 HG13 VAL A  42      -5.529  -4.663  -4.472  1.00  1.66           H  
ATOM    616 HG21 VAL A  42      -7.317  -6.274  -3.756  1.00  1.73           H  
ATOM    617 HG22 VAL A  42      -8.330  -5.515  -4.985  1.00  1.79           H  
ATOM    618 HG23 VAL A  42      -8.115  -7.265  -4.977  1.00  1.76           H  
ATOM    619  N   ALA A  43      -4.996  -5.291  -8.326  1.00  0.47           N  
ATOM    620  CA  ALA A  43      -3.785  -5.210  -9.133  1.00  0.55           C  
ATOM    621  C   ALA A  43      -2.680  -4.461  -8.391  1.00  0.69           C  
ATOM    622  O   ALA A  43      -2.955  -3.545  -7.617  1.00  0.81           O  
ATOM    623  CB  ALA A  43      -4.079  -4.536 -10.464  1.00  0.55           C  
ATOM    624  H   ALA A  43      -5.404  -4.464  -7.994  1.00  0.49           H  
ATOM    625  HA  ALA A  43      -3.450  -6.218  -9.332  1.00  0.64           H  
ATOM    626  HB1 ALA A  43      -4.880  -5.059 -10.964  1.00  1.05           H  
ATOM    627  HB2 ALA A  43      -4.375  -3.511 -10.290  1.00  1.25           H  
ATOM    628  HB3 ALA A  43      -3.194  -4.555 -11.082  1.00  1.18           H  
ATOM    629  N   PRO A  44      -1.411  -4.842  -8.621  1.00  0.83           N  
ATOM    630  CA  PRO A  44      -0.261  -4.205  -7.968  1.00  1.00           C  
ATOM    631  C   PRO A  44       0.044  -2.821  -8.535  1.00  0.98           C  
ATOM    632  O   PRO A  44       0.701  -2.008  -7.887  1.00  1.15           O  
ATOM    633  CB  PRO A  44       0.887  -5.168  -8.271  1.00  1.14           C  
ATOM    634  CG  PRO A  44       0.502  -5.818  -9.555  1.00  1.34           C  
ATOM    635  CD  PRO A  44      -0.998  -5.931  -9.530  1.00  1.00           C  
ATOM    636  HA  PRO A  44      -0.403  -4.132  -6.901  1.00  1.10           H  
ATOM    637  HB2 PRO A  44       1.809  -4.616  -8.365  1.00  1.18           H  
ATOM    638  HG2 PRO A  44       0.817  -5.204 -10.386  1.00  1.63           H  
ATOM    639  HD2 PRO A  44      -1.405  -5.783 -10.519  1.00  1.00           H  
ATOM    640  N   LEU A  45      -0.436  -2.560  -9.746  1.00  0.85           N  
ATOM    641  CA  LEU A  45      -0.207  -1.274 -10.397  1.00  0.90           C  
ATOM    642  C   LEU A  45      -1.352  -0.305 -10.114  1.00  0.91           C  
ATOM    643  O   LEU A  45      -1.124   0.857  -9.778  1.00  1.23           O  
ATOM    644  CB  LEU A  45      -0.046  -1.466 -11.905  1.00  0.90           C  
ATOM    645  CG  LEU A  45       0.211  -0.183 -12.700  1.00  1.76           C  
ATOM    646  CD1 LEU A  45       1.534   0.444 -12.290  1.00  2.51           C  
ATOM    647  CD2 LEU A  45       0.196  -0.475 -14.193  1.00  2.25           C  
ATOM    648  H   LEU A  45      -0.958  -3.246 -10.214  1.00  0.79           H  
ATOM    649  HA  LEU A  45       0.705  -0.860  -9.996  1.00  1.00           H  
ATOM    650  HB2 LEU A  45       0.781  -2.141 -12.075  1.00  1.22           H  
ATOM    651  HG  LEU A  45      -0.575   0.527 -12.487  1.00  2.42           H  
ATOM    652 HD11 LEU A  45       1.689   1.355 -12.850  1.00  2.79           H  
ATOM    653 HD12 LEU A  45       1.515   0.670 -11.234  1.00  3.06           H  
ATOM    654 HD13 LEU A  45       2.340  -0.245 -12.495  1.00  2.90           H  
ATOM    655 HD21 LEU A  45       0.964  -1.195 -14.428  1.00  2.49           H  
ATOM    656 HD22 LEU A  45      -0.769  -0.871 -14.473  1.00  2.73           H  
ATOM    657 HD23 LEU A  45       0.382   0.440 -14.739  1.00  2.66           H  
ATOM    658  N   GLY A  46      -2.581  -0.789 -10.258  1.00  0.72           N  
ATOM    659  CA  GLY A  46      -3.741   0.049 -10.015  1.00  0.72           C  
ATOM    660  C   GLY A  46      -4.939  -0.375 -10.842  1.00  0.66           C  
ATOM    661  O   GLY A  46      -5.032  -0.050 -12.023  1.00  0.77           O  
ATOM    662  H   GLY A  46      -2.700  -1.723 -10.531  1.00  0.74           H  
ATOM    663  HA2 GLY A  46      -3.999  -0.007  -8.969  1.00  0.73           H  
ATOM    664  HA3 GLY A  46      -3.490   1.070 -10.260  1.00  0.79           H  
ATOM    665  N   ASP A  47      -5.859  -1.101 -10.215  1.00  0.53           N  
ATOM    666  CA  ASP A  47      -7.055  -1.576 -10.900  1.00  0.49           C  
ATOM    667  C   ASP A  47      -8.283  -1.457 -10.002  1.00  0.46           C  
ATOM    668  O   ASP A  47      -8.165  -1.163  -8.813  1.00  0.46           O  
ATOM    669  CB  ASP A  47      -6.863  -3.028 -11.344  1.00  0.45           C  
ATOM    670  CG  ASP A  47      -5.927  -3.149 -12.531  1.00  0.78           C  
ATOM    671  OD1 ASP A  47      -4.737  -2.798 -12.387  1.00  0.94           O  
ATOM    672  OD2 ASP A  47      -6.385  -3.589 -13.607  1.00  1.07           O  
ATOM    673  H   ASP A  47      -5.731  -1.323  -9.269  1.00  0.49           H  
ATOM    674  HA  ASP A  47      -7.204  -0.959 -11.770  1.00  0.56           H  
ATOM    675  HB2 ASP A  47      -6.446  -3.596 -10.526  1.00  0.57           H  
ATOM    676  N   PRO A  48      -9.483  -1.683 -10.564  1.00  0.47           N  
ATOM    677  CA  PRO A  48     -10.734  -1.604  -9.820  1.00  0.47           C  
ATOM    678  C   PRO A  48     -11.045  -2.911  -9.103  1.00  0.37           C  
ATOM    679  O   PRO A  48     -11.239  -3.949  -9.735  1.00  0.38           O  
ATOM    680  CB  PRO A  48     -11.788  -1.327 -10.905  1.00  0.56           C  
ATOM    681  CG  PRO A  48     -11.065  -1.367 -12.219  1.00  0.61           C  
ATOM    682  CD  PRO A  48      -9.729  -2.006 -11.968  1.00  0.53           C  
ATOM    683  HA  PRO A  48     -10.720  -0.793  -9.107  1.00  0.50           H  
ATOM    684  HB2 PRO A  48     -12.556  -2.085 -10.858  1.00  0.55           H  
ATOM    685  HG2 PRO A  48     -11.631  -1.954 -12.927  1.00  0.65           H  
ATOM    686  HD2 PRO A  48      -9.786  -3.076 -12.116  1.00  0.51           H  
ATOM    687  N   VAL A  49     -11.093  -2.847  -7.779  1.00  0.32           N  
ATOM    688  CA  VAL A  49     -11.368  -4.020  -6.966  1.00  0.26           C  
ATOM    689  C   VAL A  49     -12.779  -3.962  -6.387  1.00  0.28           C  
ATOM    690  O   VAL A  49     -13.366  -2.888  -6.257  1.00  0.39           O  
ATOM    691  CB  VAL A  49     -10.331  -4.154  -5.826  1.00  0.27           C  
ATOM    692  CG1 VAL A  49     -10.125  -2.814  -5.137  1.00  0.35           C  
ATOM    693  CG2 VAL A  49     -10.741  -5.223  -4.816  1.00  0.31           C  
ATOM    694  H   VAL A  49     -10.941  -1.985  -7.338  1.00  0.37           H  
ATOM    695  HA  VAL A  49     -11.287  -4.892  -7.599  1.00  0.27           H  
ATOM    696  HB  VAL A  49      -9.389  -4.450  -6.263  1.00  0.28           H  
ATOM    697 HG11 VAL A  49      -9.712  -2.106  -5.844  1.00  1.15           H  
ATOM    698 HG12 VAL A  49     -11.071  -2.446  -4.770  1.00  1.00           H  
ATOM    699 HG13 VAL A  49      -9.442  -2.934  -4.310  1.00  1.09           H  
ATOM    700 HG21 VAL A  49     -11.701  -4.967  -4.393  1.00  1.10           H  
ATOM    701 HG22 VAL A  49     -10.810  -6.179  -5.311  1.00  1.01           H  
ATOM    702 HG23 VAL A  49     -10.004  -5.277  -4.028  1.00  1.09           H  
ATOM    703  N   HIS A  50     -13.312  -5.127  -6.042  1.00  0.29           N  
ATOM    704  CA  HIS A  50     -14.650  -5.220  -5.478  1.00  0.31           C  
ATOM    705  C   HIS A  50     -14.611  -5.863  -4.098  1.00  0.29           C  
ATOM    706  O   HIS A  50     -13.914  -6.856  -3.884  1.00  0.31           O  
ATOM    707  CB  HIS A  50     -15.560  -6.025  -6.406  1.00  0.34           C  
ATOM    708  CG  HIS A  50     -15.592  -5.508  -7.811  1.00  0.37           C  
ATOM    709  ND1 HIS A  50     -16.669  -4.832  -8.343  1.00  1.13           N  
ATOM    710  CD2 HIS A  50     -14.667  -5.574  -8.801  1.00  1.08           C  
ATOM    711  CE1 HIS A  50     -16.409  -4.504  -9.596  1.00  0.85           C  
ATOM    712  NE2 HIS A  50     -15.201  -4.943  -9.897  1.00  0.68           N  
ATOM    713  H   HIS A  50     -12.789  -5.947  -6.170  1.00  0.37           H  
ATOM    714  HA  HIS A  50     -15.041  -4.218  -5.386  1.00  0.34           H  
ATOM    715  HB2 HIS A  50     -15.218  -7.049  -6.438  1.00  0.34           H  
ATOM    716  HD1 HIS A  50     -17.503  -4.621  -7.870  1.00  1.97           H  
ATOM    717  HD2 HIS A  50     -13.693  -6.037  -8.737  1.00  2.03           H  
ATOM    718  HE1 HIS A  50     -17.071  -3.971 -10.262  1.00  1.44           H  
ATOM    719  HE2 HIS A  50     -14.793  -4.910 -10.788  1.00  1.13           H  
ATOM    720  N   ILE A  51     -15.361  -5.290  -3.163  1.00  0.32           N  
ATOM    721  CA  ILE A  51     -15.410  -5.804  -1.802  1.00  0.32           C  
ATOM    722  C   ILE A  51     -16.683  -6.606  -1.563  1.00  0.32           C  
ATOM    723  O   ILE A  51     -17.748  -6.272  -2.084  1.00  0.31           O  
ATOM    724  CB  ILE A  51     -15.332  -4.668  -0.763  1.00  0.34           C  
ATOM    725  CG1 ILE A  51     -16.514  -3.711  -0.923  1.00  0.34           C  
ATOM    726  CG2 ILE A  51     -14.018  -3.917  -0.899  1.00  0.36           C  
ATOM    727  CD1 ILE A  51     -16.511  -2.582   0.083  1.00  0.36           C  
ATOM    728  H   ILE A  51     -15.894  -4.498  -3.395  1.00  0.36           H  
ATOM    729  HA  ILE A  51     -14.558  -6.453  -1.659  1.00  0.34           H  
ATOM    730  HB  ILE A  51     -15.367  -5.109   0.222  1.00  0.35           H  
ATOM    731 HG12 ILE A  51     -16.485  -3.276  -1.911  1.00  0.36           H  
ATOM    732 HG21 ILE A  51     -13.940  -3.504  -1.895  1.00  1.07           H  
ATOM    733 HG22 ILE A  51     -13.984  -3.117  -0.175  1.00  1.00           H  
ATOM    734 HG23 ILE A  51     -13.195  -4.594  -0.727  1.00  1.12           H  
ATOM    735 HD11 ILE A  51     -17.374  -1.953  -0.077  1.00  1.09           H  
ATOM    736 HD12 ILE A  51     -16.543  -2.989   1.083  1.00  1.00           H  
ATOM    737 HD13 ILE A  51     -15.611  -1.994  -0.038  1.00  1.07           H  
ATOM    738  N   GLU A  52     -16.568  -7.669  -0.774  1.00  0.36           N  
ATOM    739  CA  GLU A  52     -17.710  -8.517  -0.462  1.00  0.39           C  
ATOM    740  C   GLU A  52     -18.171  -8.294   0.973  1.00  0.42           C  
ATOM    741  O   GLU A  52     -17.476  -8.658   1.923  1.00  0.43           O  
ATOM    742  CB  GLU A  52     -17.356  -9.990  -0.676  1.00  0.45           C  
ATOM    743  CG  GLU A  52     -16.945 -10.313  -2.103  1.00  1.01           C  
ATOM    744  CD  GLU A  52     -18.078 -10.123  -3.093  1.00  1.46           C  
ATOM    745  OE1 GLU A  52     -18.334  -8.966  -3.487  1.00  2.13           O  
ATOM    746  OE2 GLU A  52     -18.705 -11.131  -3.480  1.00  1.91           O  
ATOM    747  H   GLU A  52     -15.691  -7.887  -0.393  1.00  0.40           H  
ATOM    748  HA  GLU A  52     -18.514  -8.248  -1.131  1.00  0.36           H  
ATOM    749  HB2 GLU A  52     -16.538 -10.249  -0.020  1.00  0.94           H  
ATOM    750  HG2 GLU A  52     -16.127  -9.668  -2.387  1.00  1.62           H  
ATOM    751  N   THR A  53     -19.343  -7.688   1.122  1.00  0.52           N  
ATOM    752  CA  THR A  53     -19.902  -7.409   2.437  1.00  0.58           C  
ATOM    753  C   THR A  53     -21.148  -8.252   2.693  1.00  0.61           C  
ATOM    754  O   THR A  53     -21.501  -9.114   1.887  1.00  0.60           O  
ATOM    755  CB  THR A  53     -20.256  -5.918   2.587  1.00  0.59           C  
ATOM    756  OG1 THR A  53     -21.236  -5.547   1.610  1.00  0.55           O  
ATOM    757  CG2 THR A  53     -19.016  -5.052   2.419  1.00  0.64           C  
ATOM    758  H   THR A  53     -19.847  -7.420   0.324  1.00  0.58           H  
ATOM    759  HA  THR A  53     -19.153  -7.656   3.177  1.00  0.65           H  
ATOM    760  HB  THR A  53     -20.660  -5.755   3.575  1.00  0.66           H  
ATOM    761  HG1 THR A  53     -21.359  -4.595   1.626  1.00  1.07           H  
ATOM    762 HG21 THR A  53     -19.283  -4.013   2.537  1.00  1.28           H  
ATOM    763 HG22 THR A  53     -18.600  -5.207   1.435  1.00  1.25           H  
ATOM    764 HG23 THR A  53     -18.284  -5.322   3.165  1.00  1.07           H  
ATOM    765  N   ARG A  54     -21.813  -8.001   3.815  1.00  0.68           N  
ATOM    766  CA  ARG A  54     -23.015  -8.743   4.176  1.00  0.73           C  
ATOM    767  C   ARG A  54     -24.038  -8.736   3.045  1.00  0.67           C  
ATOM    768  O   ARG A  54     -24.833  -7.806   2.918  1.00  0.69           O  
ATOM    769  CB  ARG A  54     -23.641  -8.157   5.443  1.00  0.84           C  
ATOM    770  CG  ARG A  54     -22.735  -8.235   6.661  1.00  1.47           C  
ATOM    771  CD  ARG A  54     -22.358  -9.672   6.980  1.00  1.53           C  
ATOM    772  NE  ARG A  54     -21.573  -9.774   8.207  1.00  2.10           N  
ATOM    773  CZ  ARG A  54     -21.140 -10.925   8.710  1.00  2.32           C  
ATOM    774  NH1 ARG A  54     -21.413 -12.065   8.090  1.00  1.97           N  
ATOM    775  NH2 ARG A  54     -20.434 -10.938   9.833  1.00  3.04           N  
ATOM    776  H   ARG A  54     -21.486  -7.299   4.417  1.00  0.72           H  
ATOM    777  HA  ARG A  54     -22.725  -9.765   4.371  1.00  0.79           H  
ATOM    778  HB2 ARG A  54     -23.880  -7.120   5.264  1.00  1.09           H  
ATOM    779  HG2 ARG A  54     -21.835  -7.672   6.465  1.00  1.91           H  
ATOM    780  HD2 ARG A  54     -23.262 -10.251   7.094  1.00  1.59           H  
ATOM    781  HE  ARG A  54     -21.361  -8.942   8.680  1.00  2.46           H  
ATOM    782 HH11 ARG A  54     -21.945 -12.059   7.244  1.00  1.66           H  
ATOM    783 HH12 ARG A  54     -21.083 -12.930   8.467  1.00  2.17           H  
ATOM    784 HH21 ARG A  54     -20.225 -10.080  10.303  1.00  3.43           H  
ATOM    785 HH22 ARG A  54     -20.110 -11.806  10.209  1.00  3.23           H  
ATOM    786  N   ARG A  55     -24.007  -9.780   2.221  1.00  0.66           N  
ATOM    787  CA  ARG A  55     -24.934  -9.910   1.104  1.00  0.66           C  
ATOM    788  C   ARG A  55     -24.922  -8.669   0.214  1.00  0.62           C  
ATOM    789  O   ARG A  55     -25.964  -8.246  -0.286  1.00  0.70           O  
ATOM    790  CB  ARG A  55     -26.352 -10.157   1.621  1.00  0.73           C  
ATOM    791  CG  ARG A  55     -26.493 -11.429   2.439  1.00  1.06           C  
ATOM    792  CD  ARG A  55     -27.918 -11.614   2.937  1.00  1.67           C  
ATOM    793  NE  ARG A  55     -28.873 -11.713   1.837  1.00  2.43           N  
ATOM    794  CZ  ARG A  55     -30.190 -11.614   1.995  1.00  3.17           C  
ATOM    795  NH1 ARG A  55     -30.703 -11.424   3.202  1.00  3.34           N  
ATOM    796  NH2 ARG A  55     -30.993 -11.706   0.945  1.00  4.11           N  
ATOM    797  H   ARG A  55     -23.339 -10.482   2.365  1.00  0.70           H  
ATOM    798  HA  ARG A  55     -24.622 -10.760   0.520  1.00  0.69           H  
ATOM    799  HB2 ARG A  55     -26.645  -9.322   2.242  1.00  0.99           H  
ATOM    800  HG2 ARG A  55     -26.225 -12.274   1.822  1.00  1.30           H  
ATOM    801  HD2 ARG A  55     -27.966 -12.516   3.528  1.00  2.09           H  
ATOM    802  HE  ARG A  55     -28.516 -11.859   0.936  1.00  2.75           H  
ATOM    803 HH11 ARG A  55     -30.101 -11.355   3.997  1.00  3.11           H  
ATOM    804 HH12 ARG A  55     -31.693 -11.350   3.318  1.00  3.99           H  
ATOM    805 HH21 ARG A  55     -30.611 -11.851   0.032  1.00  4.44           H  
ATOM    806 HH22 ARG A  55     -31.984 -11.631   1.064  1.00  4.67           H  
ATOM    807  N   VAL A  56     -23.743  -8.094   0.012  1.00  0.58           N  
ATOM    808  CA  VAL A  56     -23.610  -6.904  -0.822  1.00  0.57           C  
ATOM    809  C   VAL A  56     -22.199  -6.786  -1.389  1.00  0.49           C  
ATOM    810  O   VAL A  56     -21.215  -6.920  -0.660  1.00  0.50           O  
ATOM    811  CB  VAL A  56     -23.949  -5.621  -0.040  1.00  0.66           C  
ATOM    812  CG1 VAL A  56     -23.811  -4.397  -0.930  1.00  1.02           C  
ATOM    813  CG2 VAL A  56     -25.352  -5.706   0.542  1.00  1.23           C  
ATOM    814  H   VAL A  56     -22.942  -8.476   0.430  1.00  0.60           H  
ATOM    815  HA  VAL A  56     -24.308  -6.996  -1.643  1.00  0.64           H  
ATOM    816  HB  VAL A  56     -23.250  -5.526   0.776  1.00  1.22           H  
ATOM    817 HG11 VAL A  56     -24.470  -4.493  -1.782  1.00  1.71           H  
ATOM    818 HG12 VAL A  56     -24.075  -3.511  -0.371  1.00  1.42           H  
ATOM    819 HG13 VAL A  56     -22.790  -4.314  -1.274  1.00  1.57           H  
ATOM    820 HG21 VAL A  56     -25.590  -4.781   1.045  1.00  1.63           H  
ATOM    821 HG22 VAL A  56     -26.062  -5.877  -0.253  1.00  1.71           H  
ATOM    822 HG23 VAL A  56     -25.399  -6.520   1.250  1.00  1.87           H  
ATOM    823  N   SER A  57     -22.108  -6.535  -2.692  1.00  0.48           N  
ATOM    824  CA  SER A  57     -20.816  -6.405  -3.355  1.00  0.43           C  
ATOM    825  C   SER A  57     -20.581  -4.972  -3.825  1.00  0.42           C  
ATOM    826  O   SER A  57     -21.202  -4.515  -4.784  1.00  0.46           O  
ATOM    827  CB  SER A  57     -20.735  -7.361  -4.545  1.00  0.51           C  
ATOM    828  OG  SER A  57     -19.483  -7.260  -5.201  1.00  0.64           O  
ATOM    829  H   SER A  57     -22.928  -6.436  -3.219  1.00  0.55           H  
ATOM    830  HA  SER A  57     -20.049  -6.667  -2.643  1.00  0.42           H  
ATOM    831  HB2 SER A  57     -20.864  -8.376  -4.201  1.00  0.73           H  
ATOM    832  HG  SER A  57     -19.622  -7.047  -6.128  1.00  1.07           H  
ATOM    833  N   LEU A  58     -19.680  -4.273  -3.145  1.00  0.38           N  
ATOM    834  CA  LEU A  58     -19.353  -2.897  -3.500  1.00  0.40           C  
ATOM    835  C   LEU A  58     -18.041  -2.841  -4.274  1.00  0.37           C  
ATOM    836  O   LEU A  58     -17.190  -3.718  -4.132  1.00  0.38           O  
ATOM    837  CB  LEU A  58     -19.254  -2.028  -2.244  1.00  0.43           C  
ATOM    838  CG  LEU A  58     -18.995  -0.542  -2.504  1.00  0.96           C  
ATOM    839  CD1 LEU A  58     -20.115   0.054  -3.341  1.00  1.50           C  
ATOM    840  CD2 LEU A  58     -18.851   0.212  -1.190  1.00  1.54           C  
ATOM    841  H   LEU A  58     -19.223  -4.692  -2.385  1.00  0.38           H  
ATOM    842  HA  LEU A  58     -20.147  -2.519  -4.128  1.00  0.42           H  
ATOM    843  HB2 LEU A  58     -20.179  -2.122  -1.691  1.00  1.02           H  
ATOM    844  HG  LEU A  58     -18.073  -0.436  -3.055  1.00  1.80           H  
ATOM    845 HD11 LEU A  58     -19.905   1.096  -3.534  1.00  1.96           H  
ATOM    846 HD12 LEU A  58     -20.188  -0.479  -4.276  1.00  2.01           H  
ATOM    847 HD13 LEU A  58     -21.049  -0.032  -2.806  1.00  2.03           H  
ATOM    848 HD21 LEU A  58     -18.029  -0.201  -0.625  1.00  2.10           H  
ATOM    849 HD22 LEU A  58     -18.663   1.255  -1.393  1.00  2.10           H  
ATOM    850 HD23 LEU A  58     -19.764   0.117  -0.618  1.00  1.89           H  
ATOM    851  N   VAL A  59     -17.884  -1.809  -5.095  1.00  0.41           N  
ATOM    852  CA  VAL A  59     -16.672  -1.648  -5.888  1.00  0.40           C  
ATOM    853  C   VAL A  59     -15.807  -0.511  -5.349  1.00  0.40           C  
ATOM    854  O   VAL A  59     -16.316   0.542  -4.965  1.00  0.47           O  
ATOM    855  CB  VAL A  59     -17.000  -1.374  -7.366  1.00  0.45           C  
ATOM    856  CG1 VAL A  59     -17.748  -0.057  -7.513  1.00  0.50           C  
ATOM    857  CG2 VAL A  59     -15.730  -1.372  -8.203  1.00  0.45           C  
ATOM    858  H   VAL A  59     -18.598  -1.143  -5.171  1.00  0.48           H  
ATOM    859  HA  VAL A  59     -16.113  -2.571  -5.831  1.00  0.40           H  
ATOM    860  HB  VAL A  59     -17.641  -2.166  -7.725  1.00  0.47           H  
ATOM    861 HG11 VAL A  59     -17.139   0.747  -7.127  1.00  1.11           H  
ATOM    862 HG12 VAL A  59     -17.961   0.121  -8.557  1.00  1.07           H  
ATOM    863 HG13 VAL A  59     -18.673  -0.105  -6.958  1.00  1.10           H  
ATOM    864 HG21 VAL A  59     -15.058  -0.613  -7.833  1.00  1.09           H  
ATOM    865 HG22 VAL A  59     -15.254  -2.339  -8.133  1.00  1.09           H  
ATOM    866 HG23 VAL A  59     -15.977  -1.164  -9.233  1.00  1.06           H  
ATOM    867  N   LEU A  60     -14.497  -0.734  -5.327  1.00  0.39           N  
ATOM    868  CA  LEU A  60     -13.556   0.269  -4.838  1.00  0.40           C  
ATOM    869  C   LEU A  60     -12.431   0.492  -5.844  1.00  0.38           C  
ATOM    870  O   LEU A  60     -12.245  -0.298  -6.771  1.00  0.48           O  
ATOM    871  CB  LEU A  60     -12.977  -0.156  -3.488  1.00  0.45           C  
ATOM    872  CG  LEU A  60     -14.003  -0.306  -2.362  1.00  0.61           C  
ATOM    873  CD1 LEU A  60     -13.317  -0.693  -1.061  1.00  0.77           C  
ATOM    874  CD2 LEU A  60     -14.791   0.984  -2.187  1.00  0.97           C  
ATOM    875  H   LEU A  60     -14.152  -1.594  -5.643  1.00  0.41           H  
ATOM    876  HA  LEU A  60     -14.096   1.195  -4.713  1.00  0.47           H  
ATOM    877  HB2 LEU A  60     -12.472  -1.102  -3.616  1.00  0.60           H  
ATOM    878  HG  LEU A  60     -14.697  -1.091  -2.620  1.00  0.89           H  
ATOM    879 HD11 LEU A  60     -12.598   0.067  -0.793  1.00  1.22           H  
ATOM    880 HD12 LEU A  60     -14.056  -0.783  -0.278  1.00  1.35           H  
ATOM    881 HD13 LEU A  60     -12.810  -1.639  -1.190  1.00  1.37           H  
ATOM    882 HD21 LEU A  60     -15.318   1.211  -3.102  1.00  1.42           H  
ATOM    883 HD22 LEU A  60     -15.502   0.865  -1.384  1.00  1.56           H  
ATOM    884 HD23 LEU A  60     -14.114   1.790  -1.953  1.00  1.46           H  
ATOM    885  N   ARG A  61     -11.677   1.570  -5.652  1.00  0.51           N  
ATOM    886  CA  ARG A  61     -10.574   1.903  -6.548  1.00  0.58           C  
ATOM    887  C   ARG A  61      -9.270   2.054  -5.769  1.00  0.54           C  
ATOM    888  O   ARG A  61      -9.240   2.673  -4.706  1.00  0.59           O  
ATOM    889  CB  ARG A  61     -10.886   3.193  -7.305  1.00  0.69           C  
ATOM    890  CG  ARG A  61     -12.130   3.102  -8.173  1.00  1.34           C  
ATOM    891  CD  ARG A  61     -12.437   4.425  -8.852  1.00  1.51           C  
ATOM    892  NE  ARG A  61     -13.583   4.328  -9.752  1.00  2.06           N  
ATOM    893  CZ  ARG A  61     -13.879   5.243 -10.668  1.00  2.47           C  
ATOM    894  NH1 ARG A  61     -13.113   6.318 -10.807  1.00  2.45           N  
ATOM    895  NH2 ARG A  61     -14.938   5.087 -11.450  1.00  3.32           N  
ATOM    896  H   ARG A  61     -11.862   2.152  -4.889  1.00  0.67           H  
ATOM    897  HA  ARG A  61     -10.467   1.095  -7.255  1.00  0.67           H  
ATOM    898  HB2 ARG A  61     -11.029   3.992  -6.591  1.00  0.91           H  
ATOM    899  HG2 ARG A  61     -11.974   2.348  -8.932  1.00  1.91           H  
ATOM    900  HD2 ARG A  61     -12.651   5.164  -8.093  1.00  1.87           H  
ATOM    901  HE  ARG A  61     -14.162   3.541  -9.666  1.00  2.52           H  
ATOM    902 HH11 ARG A  61     -12.312   6.439 -10.222  1.00  2.39           H  
ATOM    903 HH12 ARG A  61     -13.337   7.005 -11.497  1.00  2.86           H  
ATOM    904 HH21 ARG A  61     -15.519   4.278 -11.349  1.00  3.81           H  
ATOM    905 HH22 ARG A  61     -15.159   5.776 -12.140  1.00  3.64           H  
ATOM    906  N   LYS A  62      -8.194   1.489  -6.311  1.00  0.69           N  
ATOM    907  CA  LYS A  62      -6.885   1.555  -5.667  1.00  0.74           C  
ATOM    908  C   LYS A  62      -6.578   2.969  -5.182  1.00  0.68           C  
ATOM    909  O   LYS A  62      -5.856   3.157  -4.202  1.00  0.76           O  
ATOM    910  CB  LYS A  62      -5.794   1.088  -6.634  1.00  0.92           C  
ATOM    911  CG  LYS A  62      -4.398   1.091  -6.031  1.00  1.88           C  
ATOM    912  CD  LYS A  62      -4.069  -0.236  -5.363  1.00  2.95           C  
ATOM    913  CE  LYS A  62      -5.059  -0.574  -4.259  1.00  3.60           C  
ATOM    914  NZ  LYS A  62      -4.604  -1.729  -3.439  1.00  4.70           N  
ATOM    915  H   LYS A  62      -8.284   1.013  -7.162  1.00  0.86           H  
ATOM    916  HA  LYS A  62      -6.905   0.895  -4.816  1.00  0.78           H  
ATOM    917  HB2 LYS A  62      -6.021   0.082  -6.956  1.00  1.41           H  
ATOM    918  HG2 LYS A  62      -3.679   1.275  -6.814  1.00  2.24           H  
ATOM    919  HD2 LYS A  62      -4.095  -1.018  -6.106  1.00  3.28           H  
ATOM    920  HE2 LYS A  62      -5.175   0.288  -3.619  1.00  3.61           H  
ATOM    921  HZ1 LYS A  62      -5.294  -1.928  -2.686  1.00  5.05           H  
ATOM    922  HZ2 LYS A  62      -3.683  -1.517  -3.001  1.00  5.09           H  
ATOM    923  HZ3 LYS A  62      -4.503  -2.575  -4.036  1.00  5.08           H  
ATOM    924  N   LYS A  63      -7.130   3.964  -5.872  1.00  0.64           N  
ATOM    925  CA  LYS A  63      -6.918   5.357  -5.502  1.00  0.71           C  
ATOM    926  C   LYS A  63      -7.903   5.774  -4.418  1.00  0.63           C  
ATOM    927  O   LYS A  63      -7.595   6.615  -3.572  1.00  0.73           O  
ATOM    928  CB  LYS A  63      -7.060   6.267  -6.723  1.00  0.88           C  
ATOM    929  CG  LYS A  63      -8.364   6.077  -7.479  1.00  0.88           C  
ATOM    930  CD  LYS A  63      -8.501   7.084  -8.611  1.00  1.10           C  
ATOM    931  CE  LYS A  63      -9.703   6.776  -9.488  1.00  1.67           C  
ATOM    932  NZ  LYS A  63      -9.554   5.474 -10.193  1.00  2.28           N  
ATOM    933  H   LYS A  63      -7.692   3.754  -6.645  1.00  0.65           H  
ATOM    934  HA  LYS A  63      -5.914   5.446  -5.111  1.00  0.78           H  
ATOM    935  HB2 LYS A  63      -7.005   7.296  -6.399  1.00  0.98           H  
ATOM    936  HG2 LYS A  63      -8.389   5.081  -7.892  1.00  0.84           H  
ATOM    937  HD2 LYS A  63      -8.619   8.070  -8.189  1.00  1.57           H  
ATOM    938  HE2 LYS A  63     -10.586   6.741  -8.867  1.00  2.11           H  
ATOM    939  HZ1 LYS A  63      -8.686   5.473 -10.763  1.00  2.66           H  
ATOM    940  HZ2 LYS A  63     -10.368   5.312 -10.820  1.00  2.72           H  
ATOM    941  HZ3 LYS A  63      -9.505   4.697  -9.502  1.00  2.64           H  
ATOM    942  N   ASP A  64      -9.091   5.179  -4.449  1.00  0.54           N  
ATOM    943  CA  ASP A  64     -10.124   5.478  -3.466  1.00  0.54           C  
ATOM    944  C   ASP A  64      -9.731   4.941  -2.093  1.00  0.46           C  
ATOM    945  O   ASP A  64     -10.017   5.561  -1.068  1.00  0.56           O  
ATOM    946  CB  ASP A  64     -11.461   4.873  -3.901  1.00  0.56           C  
ATOM    947  CG  ASP A  64     -12.578   5.165  -2.918  1.00  1.38           C  
ATOM    948  OD1 ASP A  64     -13.235   6.217  -3.062  1.00  1.49           O  
ATOM    949  OD2 ASP A  64     -12.797   4.340  -2.006  1.00  2.30           O  
ATOM    950  H   ASP A  64      -9.277   4.523  -5.152  1.00  0.56           H  
ATOM    951  HA  ASP A  64     -10.227   6.551  -3.406  1.00  0.64           H  
ATOM    952  HB2 ASP A  64     -11.737   5.280  -4.862  1.00  1.10           H  
ATOM    953  N   LEU A  65      -9.071   3.787  -2.082  1.00  0.39           N  
ATOM    954  CA  LEU A  65      -8.635   3.166  -0.835  1.00  0.41           C  
ATOM    955  C   LEU A  65      -7.629   4.054  -0.104  1.00  0.45           C  
ATOM    956  O   LEU A  65      -7.467   3.950   1.112  1.00  0.52           O  
ATOM    957  CB  LEU A  65      -8.016   1.793  -1.105  1.00  0.51           C  
ATOM    958  CG  LEU A  65      -9.014   0.674  -1.406  1.00  0.49           C  
ATOM    959  CD1 LEU A  65      -9.668   0.886  -2.762  1.00  0.67           C  
ATOM    960  CD2 LEU A  65      -8.327  -0.683  -1.350  1.00  0.70           C  
ATOM    961  H   LEU A  65      -8.872   3.340  -2.933  1.00  0.40           H  
ATOM    962  HA  LEU A  65      -9.505   3.040  -0.207  1.00  0.41           H  
ATOM    963  HB2 LEU A  65      -7.344   1.884  -1.948  1.00  0.54           H  
ATOM    964  HG  LEU A  65      -9.793   0.685  -0.656  1.00  0.71           H  
ATOM    965 HD11 LEU A  65      -8.911   0.869  -3.530  1.00  1.13           H  
ATOM    966 HD12 LEU A  65     -10.382   0.096  -2.944  1.00  1.41           H  
ATOM    967 HD13 LEU A  65     -10.175   1.839  -2.773  1.00  1.19           H  
ATOM    968 HD21 LEU A  65      -9.047  -1.460  -1.560  1.00  1.32           H  
ATOM    969 HD22 LEU A  65      -7.538  -0.718  -2.085  1.00  1.30           H  
ATOM    970 HD23 LEU A  65      -7.911  -0.836  -0.366  1.00  1.04           H  
ATOM    971  N   ALA A  66      -6.957   4.922  -0.851  1.00  0.46           N  
ATOM    972  CA  ALA A  66      -5.965   5.824  -0.275  1.00  0.52           C  
ATOM    973  C   ALA A  66      -6.565   6.658   0.853  1.00  0.50           C  
ATOM    974  O   ALA A  66      -5.882   6.990   1.822  1.00  0.66           O  
ATOM    975  CB  ALA A  66      -5.387   6.729  -1.352  1.00  0.60           C  
ATOM    976  H   ALA A  66      -7.128   4.956  -1.817  1.00  0.46           H  
ATOM    977  HA  ALA A  66      -5.162   5.223   0.125  1.00  0.56           H  
ATOM    978  HB1 ALA A  66      -6.165   7.370  -1.740  1.00  1.20           H  
ATOM    979  HB2 ALA A  66      -4.599   7.336  -0.928  1.00  1.18           H  
ATOM    980  HB3 ALA A  66      -4.983   6.125  -2.152  1.00  1.16           H  
ATOM    981  N   LEU A  67      -7.846   6.994   0.725  1.00  0.37           N  
ATOM    982  CA  LEU A  67      -8.531   7.794   1.735  1.00  0.35           C  
ATOM    983  C   LEU A  67      -9.032   6.923   2.882  1.00  0.31           C  
ATOM    984  O   LEU A  67      -8.627   7.101   4.031  1.00  0.30           O  
ATOM    985  CB  LEU A  67      -9.704   8.552   1.110  1.00  0.38           C  
ATOM    986  CG  LEU A  67      -9.333   9.507  -0.027  1.00  0.43           C  
ATOM    987  CD1 LEU A  67     -10.577  10.176  -0.589  1.00  0.48           C  
ATOM    988  CD2 LEU A  67      -8.336  10.549   0.461  1.00  0.47           C  
ATOM    989  H   LEU A  67      -8.341   6.694  -0.067  1.00  0.37           H  
ATOM    990  HA  LEU A  67      -7.823   8.508   2.124  1.00  0.37           H  
ATOM    991  HB2 LEU A  67     -10.412   7.830   0.729  1.00  0.37           H  
ATOM    992  HG  LEU A  67      -8.867   8.945  -0.823  1.00  0.45           H  
ATOM    993 HD11 LEU A  67     -11.063  10.745   0.191  1.00  1.15           H  
ATOM    994 HD12 LEU A  67     -10.296  10.839  -1.395  1.00  1.08           H  
ATOM    995 HD13 LEU A  67     -11.256   9.423  -0.961  1.00  1.15           H  
ATOM    996 HD21 LEU A  67      -7.456  10.053   0.844  1.00  1.09           H  
ATOM    997 HD22 LEU A  67      -8.060  11.193  -0.360  1.00  1.10           H  
ATOM    998 HD23 LEU A  67      -8.788  11.138   1.245  1.00  1.16           H  
ATOM    999  N   ILE A  68      -9.910   5.978   2.565  1.00  0.31           N  
ATOM   1000  CA  ILE A  68     -10.468   5.087   3.573  1.00  0.30           C  
ATOM   1001  C   ILE A  68      -9.390   4.190   4.172  1.00  0.30           C  
ATOM   1002  O   ILE A  68      -8.462   3.771   3.478  1.00  0.37           O  
ATOM   1003  CB  ILE A  68     -11.587   4.206   2.983  1.00  0.34           C  
ATOM   1004  CG1 ILE A  68     -11.039   3.338   1.850  1.00  0.38           C  
ATOM   1005  CG2 ILE A  68     -12.735   5.072   2.487  1.00  0.38           C  
ATOM   1006  CD1 ILE A  68     -12.094   2.484   1.182  1.00  0.43           C  
ATOM   1007  H   ILE A  68     -10.190   5.881   1.631  1.00  0.34           H  
ATOM   1008  HA  ILE A  68     -10.894   5.696   4.358  1.00  0.30           H  
ATOM   1009  HB  ILE A  68     -11.963   3.568   3.769  1.00  0.34           H  
ATOM   1010 HG12 ILE A  68     -10.603   3.976   1.097  1.00  0.40           H  
ATOM   1011 HG21 ILE A  68     -12.379   5.736   1.714  1.00  1.00           H  
ATOM   1012 HG22 ILE A  68     -13.515   4.439   2.087  1.00  1.00           H  
ATOM   1013 HG23 ILE A  68     -13.130   5.652   3.307  1.00  1.07           H  
ATOM   1014 HD11 ILE A  68     -11.631   1.862   0.430  1.00  1.08           H  
ATOM   1015 HD12 ILE A  68     -12.572   1.857   1.921  1.00  1.12           H  
ATOM   1016 HD13 ILE A  68     -12.833   3.120   0.719  1.00  1.12           H  
ATOM   1017  N   GLU A  69      -9.516   3.904   5.463  1.00  0.29           N  
ATOM   1018  CA  GLU A  69      -8.549   3.062   6.157  1.00  0.32           C  
ATOM   1019  C   GLU A  69      -8.999   1.604   6.154  1.00  0.31           C  
ATOM   1020  O   GLU A  69     -10.191   1.313   6.061  1.00  0.37           O  
ATOM   1021  CB  GLU A  69      -8.362   3.548   7.595  1.00  0.34           C  
ATOM   1022  CG  GLU A  69      -7.159   2.935   8.293  1.00  0.44           C  
ATOM   1023  CD  GLU A  69      -6.932   3.513   9.676  1.00  1.30           C  
ATOM   1024  OE1 GLU A  69      -7.525   2.990  10.644  1.00  2.29           O  
ATOM   1025  OE2 GLU A  69      -6.162   4.489   9.792  1.00  1.26           O  
ATOM   1026  H   GLU A  69     -10.280   4.265   5.961  1.00  0.30           H  
ATOM   1027  HA  GLU A  69      -7.608   3.137   5.635  1.00  0.35           H  
ATOM   1028  HB2 GLU A  69      -8.242   4.620   7.587  1.00  0.35           H  
ATOM   1029  HG2 GLU A  69      -7.314   1.872   8.385  1.00  1.00           H  
ATOM   1030  N   LEU A  70      -8.038   0.692   6.259  1.00  0.32           N  
ATOM   1031  CA  LEU A  70      -8.338  -0.735   6.266  1.00  0.33           C  
ATOM   1032  C   LEU A  70      -7.625  -1.440   7.416  1.00  0.33           C  
ATOM   1033  O   LEU A  70      -6.538  -1.036   7.827  1.00  0.45           O  
ATOM   1034  CB  LEU A  70      -7.927  -1.371   4.935  1.00  0.38           C  
ATOM   1035  CG  LEU A  70      -8.616  -0.791   3.697  1.00  0.95           C  
ATOM   1036  CD1 LEU A  70      -8.092  -1.459   2.435  1.00  1.25           C  
ATOM   1037  CD2 LEU A  70     -10.125  -0.953   3.801  1.00  1.85           C  
ATOM   1038  H   LEU A  70      -7.105   0.985   6.336  1.00  0.37           H  
ATOM   1039  HA  LEU A  70      -9.404  -0.849   6.394  1.00  0.35           H  
ATOM   1040  HB2 LEU A  70      -6.860  -1.248   4.816  1.00  0.72           H  
ATOM   1041  HG  LEU A  70      -8.395   0.264   3.630  1.00  1.72           H  
ATOM   1042 HD11 LEU A  70      -7.028  -1.290   2.353  1.00  1.77           H  
ATOM   1043 HD12 LEU A  70      -8.284  -2.521   2.484  1.00  1.79           H  
ATOM   1044 HD13 LEU A  70      -8.591  -1.042   1.573  1.00  1.66           H  
ATOM   1045 HD21 LEU A  70     -10.480  -0.457   4.693  1.00  2.39           H  
ATOM   1046 HD22 LEU A  70     -10.594  -0.515   2.933  1.00  2.36           H  
ATOM   1047 HD23 LEU A  70     -10.372  -2.004   3.851  1.00  2.28           H  
ATOM   1048  N   GLU A  71      -8.246  -2.497   7.928  1.00  0.35           N  
ATOM   1049  CA  GLU A  71      -7.672  -3.263   9.026  1.00  0.38           C  
ATOM   1050  C   GLU A  71      -7.774  -4.759   8.752  1.00  0.37           C  
ATOM   1051  O   GLU A  71      -8.871  -5.311   8.672  1.00  0.52           O  
ATOM   1052  CB  GLU A  71      -8.377  -2.924  10.342  1.00  0.47           C  
ATOM   1053  CG  GLU A  71      -7.856  -3.715  11.529  1.00  0.54           C  
ATOM   1054  CD  GLU A  71      -8.559  -3.359  12.826  1.00  1.31           C  
ATOM   1055  OE1 GLU A  71      -9.592  -3.989  13.133  1.00  2.24           O  
ATOM   1056  OE2 GLU A  71      -8.075  -2.449  13.532  1.00  1.26           O  
ATOM   1057  H   GLU A  71      -9.113  -2.766   7.557  1.00  0.43           H  
ATOM   1058  HA  GLU A  71      -6.630  -2.995   9.107  1.00  0.42           H  
ATOM   1059  HB2 GLU A  71      -8.241  -1.873  10.549  1.00  0.53           H  
ATOM   1060  HG2 GLU A  71      -8.003  -4.769  11.338  1.00  1.00           H  
ATOM   1061  N   ALA A  72      -6.624  -5.409   8.606  1.00  0.45           N  
ATOM   1062  CA  ALA A  72      -6.587  -6.841   8.339  1.00  0.52           C  
ATOM   1063  C   ALA A  72      -7.211  -7.629   9.486  1.00  0.44           C  
ATOM   1064  O   ALA A  72      -7.097  -7.249  10.652  1.00  0.53           O  
ATOM   1065  CB  ALA A  72      -5.155  -7.298   8.101  1.00  0.76           C  
ATOM   1066  H   ALA A  72      -5.782  -4.914   8.680  1.00  0.58           H  
ATOM   1067  HA  ALA A  72      -7.153  -7.028   7.440  1.00  0.58           H  
ATOM   1068  HB1 ALA A  72      -4.569  -7.124   8.992  1.00  1.26           H  
ATOM   1069  HB2 ALA A  72      -5.148  -8.351   7.865  1.00  1.30           H  
ATOM   1070  HB3 ALA A  72      -4.732  -6.741   7.278  1.00  1.34           H  
ATOM   1071  N   VAL A  73      -7.874  -8.729   9.145  1.00  0.58           N  
ATOM   1072  CA  VAL A  73      -8.515  -9.575  10.145  1.00  0.64           C  
ATOM   1073  C   VAL A  73      -7.497 -10.123  11.137  1.00  0.83           C  
ATOM   1074  O   VAL A  73      -6.306  -9.828  11.049  1.00  0.99           O  
ATOM   1075  CB  VAL A  73      -9.262 -10.750   9.491  1.00  0.78           C  
ATOM   1076  CG1 VAL A  73     -10.406 -10.240   8.628  1.00  1.01           C  
ATOM   1077  CG2 VAL A  73      -8.307 -11.601   8.668  1.00  1.16           C  
ATOM   1078  H   VAL A  73      -7.934  -8.978   8.200  1.00  0.78           H  
ATOM   1079  HA  VAL A  73      -9.235  -8.971  10.680  1.00  0.66           H  
ATOM   1080  HB  VAL A  73      -9.679 -11.368  10.273  1.00  0.90           H  
ATOM   1081 HG11 VAL A  73     -10.015  -9.598   7.853  1.00  1.40           H  
ATOM   1082 HG12 VAL A  73     -10.919 -11.077   8.179  1.00  1.45           H  
ATOM   1083 HG13 VAL A  73     -11.098  -9.681   9.241  1.00  1.65           H  
ATOM   1084 HG21 VAL A  73      -7.508 -11.961   9.302  1.00  1.42           H  
ATOM   1085 HG22 VAL A  73      -8.841 -12.441   8.249  1.00  1.62           H  
ATOM   1086 HG23 VAL A  73      -7.889 -11.005   7.870  1.00  1.76           H  
ATOM   1087  N   ALA A  74      -7.974 -10.928  12.082  1.00  0.99           N  
ATOM   1088  CA  ALA A  74      -7.106 -11.517  13.094  1.00  1.25           C  
ATOM   1089  C   ALA A  74      -6.556 -12.861  12.633  1.00  1.66           C  
ATOM   1090  O   ALA A  74      -7.250 -13.875  12.676  1.00  2.28           O  
ATOM   1091  CB  ALA A  74      -7.860 -11.675  14.406  1.00  1.57           C  
ATOM   1092  H   ALA A  74      -8.934 -11.128  12.099  1.00  1.02           H  
ATOM   1093  HA  ALA A  74      -6.283 -10.838  13.260  1.00  1.32           H  
ATOM   1094  HB1 ALA A  74      -8.246 -10.716  14.717  1.00  2.22           H  
ATOM   1095  HB2 ALA A  74      -8.678 -12.367  14.271  1.00  1.69           H  
ATOM   1096  HB3 ALA A  74      -7.189 -12.055  15.162  1.00  1.93           H  
ATOM   1097  N   GLN A  75      -5.301 -12.859  12.191  1.00  1.95           N  
ATOM   1098  CA  GLN A  75      -4.655 -14.081  11.726  1.00  2.53           C  
ATOM   1099  C   GLN A  75      -4.639 -15.138  12.825  1.00  2.88           C  
ATOM   1100  O   GLN A  75      -4.396 -14.831  13.993  1.00  3.14           O  
ATOM   1101  CB  GLN A  75      -3.226 -13.782  11.269  1.00  3.27           C  
ATOM   1102  CG  GLN A  75      -3.152 -12.804  10.107  1.00  3.83           C  
ATOM   1103  CD  GLN A  75      -3.865 -13.315   8.871  1.00  4.50           C  
ATOM   1104  OE1 GLN A  75      -3.267 -13.980   8.025  1.00  4.86           O  
ATOM   1105  NE2 GLN A  75      -5.152 -13.007   8.761  1.00  5.13           N  
ATOM   1106  H   GLN A  75      -4.800 -12.018  12.176  1.00  2.15           H  
ATOM   1107  HA  GLN A  75      -5.221 -14.458  10.888  1.00  2.76           H  
ATOM   1108  HB2 GLN A  75      -2.675 -13.365  12.098  1.00  3.74           H  
ATOM   1109  HG2 GLN A  75      -3.608 -11.873  10.407  1.00  4.02           H  
ATOM   1110 HE21 GLN A  75      -5.564 -12.475   9.472  1.00  5.14           H  
ATOM   1111 HE22 GLN A  75      -5.638 -13.325   7.971  1.00  5.77           H  
TER    1112      GLN A  75                                                      
END
MOLECULE T0462_77_143.pdb
ATOM   1204  N   GLU    77      -2.454  -0.642   9.985  1.00 11.51           N 
ATOM   1205  CA  GLU    77      -3.612  -0.786   9.094  1.00 13.44           C 
ATOM   1206  C   GLU    77      -3.312  -0.215   7.697  1.00  2.42           C 
ATOM   1207  O   GLU    77      -2.423   0.626   7.539  1.00 25.04           O 
ATOM   1208  CB  GLU    77      -4.862  -0.141   9.730  1.00 44.40           C 
ATOM   1209  CG  GLU    77      -4.619   1.193  10.448  1.00 34.41           C 
ATOM   1210  CD  GLU    77      -4.730   2.413   9.544  1.00 50.11           C 
ATOM   1211  OE1 GLU    77      -3.899   3.342   9.674  1.00 42.31           O 
ATOM   1212  OE2 GLU    77      -5.670   2.469   8.730  1.00 32.01           O 
ATOM   1213  H   GLU    77      -1.869   0.136   9.876  1.00 36.29           H 
ATOM   1214  HA  GLU    77      -3.795  -1.847   8.981  1.00 15.42           H 
ATOM   1215 3HB  GLU    77      -5.272  -0.837  10.449  1.00 36.29           H 
ATOM   1216 2HB  GLU    77      -5.600   0.023   8.957  1.00 36.29           H 
ATOM   1217 3HG  GLU    77      -3.628   1.173  10.883  1.00 36.29           H 
ATOM   1218 2HG  GLU    77      -5.349   1.296  11.240  1.00 36.29           H 
ATOM   1219  N   LEU    78      -4.045  -0.688   6.685  1.00 42.42           N 
ATOM   1220  CA  LEU    78      -3.726  -0.377   5.282  1.00 60.21           C 
ATOM   1221  C   LEU    78      -4.996  -0.222   4.419  1.00 62.54           C 
ATOM   1222  O   LEU    78      -6.044  -0.782   4.736  1.00  4.41           O 
ATOM   1223  CB  LEU    78      -2.814  -1.473   4.686  1.00 61.43           C 
ATOM   1224  CG  LEU    78      -3.447  -2.870   4.491  1.00 11.44           C 
ATOM   1225  CD1 LEU    78      -2.505  -3.774   3.701  1.00 12.40           C 
ATOM   1226  CD2 LEU    78      -3.799  -3.519   5.833  1.00 74.53           C 
ATOM   1227  H   LEU    78      -4.830  -1.244   6.884  1.00 36.29           H 
ATOM   1228  HA  LEU    78      -3.189   0.561   5.269  1.00 44.34           H 
ATOM   1229 3HB  LEU    78      -1.956  -1.581   5.336  1.00 36.29           H 
ATOM   1230 2HB  LEU    78      -2.465  -1.127   3.723  1.00 36.29           H 
ATOM   1231  HG  LEU    78      -4.358  -2.767   3.919  1.00 65.12           H 
ATOM   1232 1HD1 LEU    78      -2.985  -4.725   3.521  1.00 36.29           H 
ATOM   1233 2HD1 LEU    78      -1.595  -3.932   4.264  1.00 36.29           H 
ATOM   1234 3HD1 LEU    78      -2.265  -3.308   2.756  1.00 36.29           H 
ATOM   1235 1HD2 LEU    78      -4.537  -2.918   6.341  1.00 36.29           H 
ATOM   1236 2HD2 LEU    78      -2.912  -3.593   6.445  1.00 36.29           H 
ATOM   1237 3HD2 LEU    78      -4.200  -4.508   5.661  1.00 36.29           H 
ATOM   1238  N   PRO    79      -4.915   0.544   3.306  1.00 33.21           N 
ATOM   1239  CA  PRO    79      -6.069   0.774   2.413  1.00  3.41           C 
ATOM   1240  C   PRO    79      -6.473  -0.476   1.601  1.00 53.44           C 
ATOM   1241  O   PRO    79      -5.633  -1.315   1.265  1.00 30.11           O 
ATOM   1242  CB  PRO    79      -5.572   1.889   1.482  1.00 60.14           C 
ATOM   1243  CG  PRO    79      -4.091   1.726   1.458  1.00  3.44           C 
ATOM   1244  CD  PRO    79      -3.705   1.251   2.834  1.00 21.25           C 
ATOM   1245  HA  PRO    79      -6.926   1.127   2.970  1.00 32.11           H 
ATOM   1246 3HB  PRO    79      -5.852   2.854   1.884  1.00 36.29           H 
ATOM   1247 2HB  PRO    79      -6.001   1.766   0.497  1.00 36.29           H 
ATOM   1248 3HG  PRO    79      -3.618   2.673   1.241  1.00 36.29           H 
ATOM   1249 2HG  PRO    79      -3.814   0.990   0.716  1.00 36.29           H 
ATOM   1250 3HD  PRO    79      -3.475   2.091   3.474  1.00 36.29           H 
ATOM   1251 2HD  PRO    79      -2.861   0.577   2.779  1.00 36.29           H 
ATOM   1252  N   LEU    80      -7.765  -0.571   1.270  1.00 10.14           N 
ATOM   1253  CA  LEU    80      -8.322  -1.726   0.538  1.00 12.24           C 
ATOM   1254  C   LEU    80      -7.531  -2.084  -0.732  1.00 71.04           C 
ATOM   1255  O   LEU    80      -7.179  -3.245  -0.943  1.00 34.43           O 
ATOM   1256  CB  LEU    80      -9.787  -1.452   0.162  1.00 13.14           C 
ATOM   1257  CG  LEU    80     -10.808  -1.614   1.299  1.00 54.21           C 
ATOM   1258  CD1 LEU    80     -12.201  -1.194   0.838  1.00 12.24           C 
ATOM   1259  CD2 LEU    80     -10.824  -3.057   1.801  1.00 34.31           C 
ATOM   1260  H   LEU    80      -8.371   0.157   1.533  1.00 36.29           H 
ATOM   1261  HA  LEU    80      -8.296  -2.574   1.206  1.00 73.22           H 
ATOM   1262 3HB  LEU    80     -10.066  -2.124  -0.639  1.00 36.29           H 
ATOM   1263 2HB  LEU    80      -9.855  -0.438  -0.210  1.00 36.29           H 
ATOM   1264  HG  LEU    80     -10.523  -0.976   2.125  1.00 14.14           H 
ATOM   1265 1HD1 LEU    80     -12.900  -1.307   1.654  1.00 36.29           H 
ATOM   1266 2HD1 LEU    80     -12.514  -1.813   0.008  1.00 36.29           H 
ATOM   1267 3HD1 LEU    80     -12.181  -0.159   0.526  1.00 36.29           H 
ATOM   1268 1HD2 LEU    80     -11.535  -3.148   2.610  1.00 36.29           H 
ATOM   1269 2HD2 LEU    80      -9.841  -3.325   2.157  1.00 36.29           H 
ATOM   1270 3HD2 LEU    80     -11.109  -3.720   0.996  1.00 36.29           H 
ATOM   1271  N   ILE    81      -7.255  -1.088  -1.570  1.00 44.14           N 
ATOM   1272  CA  ILE    81      -6.604  -1.322  -2.871  1.00 50.44           C 
ATOM   1273  C   ILE    81      -5.189  -1.920  -2.721  1.00 33.22           C 
ATOM   1274  O   ILE    81      -4.653  -2.514  -3.657  1.00 43.13           O 
ATOM   1275  CB  ILE    81      -6.528  -0.010  -3.698  1.00 35.34           C 
ATOM   1276  CG1 ILE    81      -6.096  -0.294  -5.148  1.00 45.22           C 
ATOM   1277  CG2 ILE    81      -5.576   0.987  -3.044  1.00 11.34           C 
ATOM   1278  CD1 ILE    81      -7.036  -1.214  -5.900  1.00  2.11           C 
ATOM   1279  H   ILE    81      -7.502  -0.174  -1.317  1.00 36.29           H 
ATOM   1280  HA  ILE    81      -7.218  -2.025  -3.417  1.00  3.54           H 
ATOM   1281  HB  ILE    81      -7.513   0.435  -3.708  1.00 64.25           H 
ATOM   1282 3HG1 ILE    81      -5.116  -0.753  -5.144  1.00 36.29           H 
ATOM   1283 2HG1 ILE    81      -6.047   0.637  -5.692  1.00 36.29           H 
ATOM   1284 1HG2 ILE    81      -5.915   1.203  -2.040  1.00 36.29           H 
ATOM   1285 2HG2 ILE    81      -5.556   1.901  -3.620  1.00 36.29           H 
ATOM   1286 3HG2 ILE    81      -4.583   0.565  -3.003  1.00 36.29           H 
ATOM   1287 1HD1 ILE    81      -7.069  -2.176  -5.410  1.00 36.29           H 
ATOM   1288 2HD1 ILE    81      -6.681  -1.338  -6.912  1.00 36.29           H 
ATOM   1289 3HD1 ILE    81      -8.027  -0.784  -5.915  1.00 36.29           H 
ATOM   1290  N   LEU    82      -4.590  -1.765  -1.542  1.00 13.21           N 
ATOM   1291  CA  LEU    82      -3.229  -2.263  -1.295  1.00 75.44           C 
ATOM   1292  C   LEU    82      -3.235  -3.478  -0.352  1.00 14.20           C 
ATOM   1293  O   LEU    82      -2.176  -3.964   0.063  1.00 74.13           O 
ATOM   1294  CB  LEU    82      -2.366  -1.146  -0.695  1.00 53.44           C 
ATOM   1295  CG  LEU    82      -2.352   0.178  -1.474  1.00 23.25           C 
ATOM   1296  CD1 LEU    82      -1.386   1.167  -0.831  1.00 12.00           C 
ATOM   1297  CD2 LEU    82      -2.003  -0.053  -2.944  1.00 23.35           C 
ATOM   1298  H   LEU    82      -5.070  -1.312  -0.819  1.00 36.29           H 
ATOM   1299  HA  LEU    82      -2.804  -2.562  -2.243  1.00 41.41           H 
ATOM   1300 3HB  LEU    82      -1.349  -1.508  -0.628  1.00 36.29           H 
ATOM   1301 2HB  LEU    82      -2.723  -0.944   0.306  1.00 36.29           H 
ATOM   1302  HG  LEU    82      -3.341   0.615  -1.434  1.00 42.03           H 
ATOM   1303 1HD1 LEU    82      -1.403   2.098  -1.381  1.00 36.29           H 
ATOM   1304 2HD1 LEU    82      -0.385   0.760  -0.844  1.00 36.29           H 
ATOM   1305 3HD1 LEU    82      -1.686   1.348   0.191  1.00 36.29           H 
ATOM   1306 1HD2 LEU    82      -1.038  -0.530  -3.018  1.00 36.29           H 
ATOM   1307 2HD2 LEU    82      -1.974   0.897  -3.460  1.00 36.29           H 
ATOM   1308 3HD2 LEU    82      -2.754  -0.683  -3.398  1.00 36.29           H 
ATOM   1309  N   ALA    83      -4.428  -3.973  -0.032  1.00 32.45           N 
ATOM   1310  CA  ALA    83      -4.592  -5.071   0.925  1.00 15.43           C 
ATOM   1311  C   ALA    83      -4.014  -6.403   0.410  1.00 54.30           C 
ATOM   1312  O   ALA    83      -3.799  -6.591  -0.789  1.00 23.30           O 
ATOM   1313  CB  ALA    83      -6.067  -5.236   1.279  1.00 62.03           C 
ATOM   1314  H   ALA    83      -5.227  -3.589  -0.453  1.00 36.29           H 
ATOM   1315  HA  ALA    83      -4.066  -4.796   1.829  1.00  1.41           H 
ATOM   1316 1HB  ALA    83      -6.462  -4.293   1.627  1.00 36.29           H 
ATOM   1317 2HB  ALA    83      -6.170  -5.977   2.061  1.00 36.29           H 
ATOM   1318 3HB  ALA    83      -6.616  -5.558   0.406  1.00 36.29           H 
ATOM   1319  N   ASP    84      -3.760  -7.320   1.339  1.00 24.33           N 
ATOM   1320  CA  ASP    84      -3.272  -8.663   1.014  1.00 10.43           C 
ATOM   1321  C   ASP    84      -4.400  -9.512   0.385  1.00 31.22           C 
ATOM   1322  O   ASP    84      -4.529  -9.582  -0.842  1.00  1.44           O 
ATOM   1323  CB  ASP    84      -2.725  -9.313   2.296  1.00 12.14           C 
ATOM   1324  CG  ASP    84      -2.271 -10.747   2.104  1.00 72.45           C 
ATOM   1325  OD1 ASP    84      -3.012 -11.668   2.515  1.00 44.41           O 
ATOM   1326  OD2 ASP    84      -1.169 -10.955   1.558  1.00 25.23           O 
ATOM   1327  H   ASP    84      -3.901  -7.087   2.281  1.00 36.29           H 
ATOM   1328  HA  ASP    84      -2.469  -8.563   0.297  1.00 73.24           H 
ATOM   1329 3HB  ASP    84      -3.498  -9.296   3.051  1.00 36.29           H 
ATOM   1330 2HB  ASP    84      -1.883  -8.736   2.646  1.00 36.29           H 
ATOM   1331  N   ASP    85      -5.236 -10.120   1.232  1.00 43.24           N 
ATOM   1332  CA  ASP    85      -6.389 -10.904   0.774  1.00 10.24           C 
ATOM   1333  C   ASP    85      -7.229 -11.390   1.973  1.00  1.54           C 
ATOM   1334  O   ASP    85      -6.831 -11.223   3.127  1.00  0.32           O 
ATOM   1335  CB  ASP    85      -5.918 -12.100  -0.067  1.00 10.35           C 
ATOM   1336  CG  ASP    85      -7.046 -12.723  -0.867  1.00 21.21           C 
ATOM   1337  OD1 ASP    85      -7.689 -13.662  -0.366  1.00 45.32           O 
ATOM   1338  OD2 ASP    85      -7.309 -12.253  -1.993  1.00 50.25           O 
ATOM   1339  H   ASP    85      -5.066 -10.052   2.195  1.00 36.29           H 
ATOM   1340  HA  ASP    85      -7.004 -10.260   0.160  1.00  3.02           H 
ATOM   1341 3HB  ASP    85      -5.500 -12.853   0.587  1.00 36.29           H 
ATOM   1342 2HB  ASP    85      -5.153 -11.769  -0.756  1.00 36.29           H 
ATOM   1343  N   GLY    86      -8.394 -11.971   1.690  1.00 44.14           N 
ATOM   1344  CA  GLY    86      -9.235 -12.538   2.741  1.00 21.12           C 
ATOM   1345  C   GLY    86     -10.194 -11.536   3.378  1.00 41.53           C 
ATOM   1346  O   GLY    86     -10.603 -10.553   2.752  1.00 64.33           O 
ATOM   1347  H   GLY    86      -8.685 -12.028   0.756  1.00 36.29           H 
ATOM   1348 3HA  GLY    86      -8.598 -12.948   3.513  1.00 36.29           H 
ATOM   1349 2HA  GLY    86      -9.816 -13.343   2.314  1.00 36.29           H 
ATOM   1350  N   THR    87     -10.558 -11.795   4.635  1.00 35.13           N 
ATOM   1351  CA  THR    87     -11.509 -10.952   5.372  1.00 72.12           C 
ATOM   1352  C   THR    87     -10.799  -9.812   6.129  1.00 24.21           C 
ATOM   1353  O   THR    87      -9.826 -10.043   6.858  1.00 41.52           O 
ATOM   1354  CB  THR    87     -12.318 -11.785   6.400  1.00  0.32           C 
ATOM   1355  OG1 THR    87     -12.695 -13.054   5.838  1.00 42.15           O 
ATOM   1356  CG2 THR    87     -13.571 -11.036   6.845  1.00 42.41           C 
ATOM   1357  H   THR    87     -10.189 -12.586   5.077  1.00 36.29           H 
ATOM   1358  HA  THR    87     -12.203 -10.525   4.660  1.00 32.51           H 
ATOM   1359  HB  THR    87     -11.696 -11.961   7.268  1.00  2.24           H 
ATOM   1360  HG1 THR    87     -13.011 -12.935   4.931  1.00 64.23           H 
ATOM   1361 1HG2 THR    87     -14.114 -11.637   7.560  1.00 36.29           H 
ATOM   1362 2HG2 THR    87     -14.199 -10.838   5.989  1.00 36.29           H 
ATOM   1363 3HG2 THR    87     -13.288 -10.100   7.309  1.00 36.29           H 
ATOM   1364  N   TYR    88     -11.299  -8.585   5.964  1.00  4.25           N 
ATOM   1365  CA  TYR    88     -10.751  -7.403   6.652  1.00 21.51           C 
ATOM   1366  C   TYR    88     -11.807  -6.696   7.502  1.00 53.21           C 
ATOM   1367  O   TYR    88     -12.994  -6.942   7.359  1.00 53.41           O 
ATOM   1368  CB  TYR    88     -10.188  -6.406   5.634  1.00 52.03           C 
ATOM   1369  CG  TYR    88      -8.939  -6.890   4.940  1.00 31.22           C 
ATOM   1370  CD1 TYR    88      -9.013  -7.749   3.853  1.00 74.10           C 
ATOM   1371  CD2 TYR    88      -7.682  -6.496   5.382  1.00 54.22           C 
ATOM   1372  CE1 TYR    88      -7.874  -8.199   3.229  1.00 43.52           C 
ATOM   1373  CE2 TYR    88      -6.538  -6.941   4.759  1.00 42.24           C 
ATOM   1374  CZ  TYR    88      -6.642  -7.794   3.687  1.00 14.22           C 
ATOM   1375  OH  TYR    88      -5.509  -8.243   3.067  1.00 72.21           O 
ATOM   1376  H   TYR    88     -12.058  -8.465   5.355  1.00 36.29           H 
ATOM   1377  HA  TYR    88      -9.949  -7.733   7.299  1.00 13.41           H 
ATOM   1378 3HB  TYR    88      -9.950  -5.480   6.142  1.00 36.29           H 
ATOM   1379 2HB  TYR    88     -10.936  -6.210   4.877  1.00 36.29           H 
ATOM   1380  HD1 TYR    88      -9.983  -8.066   3.498  1.00 20.13           H 
ATOM   1381  HD2 TYR    88      -7.608  -5.825   6.225  1.00 62.02           H 
ATOM   1382  HE1 TYR    88      -7.950  -8.866   2.384  1.00 32.42           H 
ATOM   1383  HE2 TYR    88      -5.568  -6.625   5.117  1.00  4.31           H 
ATOM   1384  HH  TYR    88      -5.635  -8.200   2.112  1.00 71.22           H 
ATOM   1385  N   GLU    89     -11.354  -5.812   8.384  1.00 22.34           N 
ATOM   1386  CA  GLU    89     -12.251  -4.984   9.201  1.00 23.21           C 
ATOM   1387  C   GLU    89     -11.974  -3.490   8.965  1.00 54.21           C 
ATOM   1388  O   GLU    89     -10.836  -3.037   9.092  1.00 64.32           O 
ATOM   1389  CB  GLU    89     -12.069  -5.321  10.687  1.00 22.21           C 
ATOM   1390  CG  GLU    89     -12.930  -4.480  11.626  1.00 63.13           C 
ATOM   1391  CD  GLU    89     -12.663  -4.780  13.092  1.00 60.50           C 
ATOM   1392  OE1 GLU    89     -13.470  -5.499  13.719  1.00 25.53           O 
ATOM   1393  OE2 GLU    89     -11.647  -4.290  13.623  1.00 33.14           O 
ATOM   1394  H   GLU    89     -10.386  -5.716   8.500  1.00 36.29           H 
ATOM   1395  HA  GLU    89     -13.270  -5.201   8.910  1.00 11.21           H 
ATOM   1396 3HB  GLU    89     -11.032  -5.172  10.954  1.00 36.29           H 
ATOM   1397 2HB  GLU    89     -12.321  -6.362  10.840  1.00 36.29           H 
ATOM   1398 3HG  GLU    89     -13.972  -4.676  11.413  1.00 36.29           H 
ATOM   1399 2HG  GLU    89     -12.720  -3.435  11.445  1.00 36.29           H 
ATOM   1400  N   ILE    90     -13.009  -2.728   8.613  1.00 11.51           N 
ATOM   1401  CA  ILE    90     -12.846  -1.290   8.346  1.00 53.30           C 
ATOM   1402  C   ILE    90     -12.498  -0.498   9.622  1.00 34.11           C 
ATOM   1403  O   ILE    90     -13.180  -0.604  10.649  1.00 11.23           O 
ATOM   1404  CB  ILE    90     -14.111  -0.683   7.683  1.00 24.24           C 
ATOM   1405  CG1 ILE    90     -13.926   0.830   7.453  1.00 14.23           C 
ATOM   1406  CG2 ILE    90     -15.355  -0.960   8.528  1.00 25.01           C 
ATOM   1407  CD1 ILE    90     -15.115   1.501   6.804  1.00 35.11           C 
ATOM   1408  H   ILE    90     -13.898  -3.139   8.523  1.00 36.29           H 
ATOM   1409  HA  ILE    90     -12.026  -1.185   7.649  1.00 63.25           H 
ATOM   1410  HB  ILE    90     -14.249  -1.167   6.726  1.00 75.34           H 
ATOM   1411 3HG1 ILE    90     -13.066   0.990   6.816  1.00 36.29           H 
ATOM   1412 2HG1 ILE    90     -13.757   1.313   8.403  1.00 36.29           H 
ATOM   1413 1HG2 ILE    90     -15.247  -0.488   9.495  1.00 36.29           H 
ATOM   1414 2HG2 ILE    90     -15.472  -2.026   8.660  1.00 36.29           H 
ATOM   1415 3HG2 ILE    90     -16.228  -0.562   8.031  1.00 36.29           H 
ATOM   1416 1HD1 ILE    90     -15.985   1.378   7.431  1.00 36.29           H 
ATOM   1417 2HD1 ILE    90     -15.298   1.054   5.839  1.00 36.29           H 
ATOM   1418 3HD1 ILE    90     -14.910   2.554   6.679  1.00 36.29           H 
ATOM   1419  N   THR    91     -11.430   0.300   9.546  1.00 65.23           N 
ATOM   1420  CA  THR    91     -10.965   1.088  10.698  1.00 35.41           C 
ATOM   1421  C   THR    91     -11.241   2.593  10.535  1.00 43.23           C 
ATOM   1422  O   THR    91     -11.580   3.267  11.506  1.00 23.55           O 
ATOM   1423  CB  THR    91      -9.454   0.868  10.974  1.00 14.21           C 
ATOM   1424  OG1 THR    91      -9.022   1.680  12.077  1.00 73.21           O 
ATOM   1425  CG2 THR    91      -8.603   1.180   9.745  1.00 34.25           C 
ATOM   1426  H   THR    91     -10.940   0.357   8.697  1.00 36.29           H 
ATOM   1427  HA  THR    91     -11.507   0.740  11.569  1.00 61.54           H 
ATOM   1428  HB  THR    91      -9.305  -0.173  11.233  1.00 33.24           H 
ATOM   1429  HG1 THR    91      -9.720   1.708  12.747  1.00 14.23           H 
ATOM   1430 1HG2 THR    91      -8.722   2.219   9.474  1.00 36.29           H 
ATOM   1431 2HG2 THR    91      -8.916   0.555   8.920  1.00 36.29           H 
ATOM   1432 3HG2 THR    91      -7.564   0.984   9.968  1.00 36.29           H 
ATOM   1433  N   LYS    92     -11.100   3.122   9.313  1.00 42.31           N 
ATOM   1434  CA  LYS    92     -11.345   4.557   9.064  1.00 54.15           C 
ATOM   1435  C   LYS    92     -11.465   4.899   7.568  1.00 44.42           C 
ATOM   1436  O   LYS    92     -10.929   4.201   6.701  1.00 33.13           O 
ATOM   1437  CB  LYS    92     -10.233   5.419   9.682  1.00 65.22           C 
ATOM   1438  CG  LYS    92      -8.822   5.024   9.253  1.00 10.13           C 
ATOM   1439  CD  LYS    92      -7.794   6.078   9.659  1.00 64.52           C 
ATOM   1440  CE  LYS    92      -6.370   5.532   9.646  1.00  4.34           C 
ATOM   1441  NZ  LYS    92      -5.966   4.989   8.322  1.00 72.11           N 
ATOM   1442  H   LYS    92     -10.830   2.546   8.566  1.00 36.29           H 
ATOM   1443  HA  LYS    92     -12.281   4.811   9.543  1.00 11.11           H 
ATOM   1444 3HB  LYS    92     -10.293   5.338  10.759  1.00 36.29           H 
ATOM   1445 2HB  LYS    92     -10.396   6.451   9.402  1.00 36.29           H 
ATOM   1446 3HG  LYS    92      -8.801   4.907   8.176  1.00 36.29           H 
ATOM   1447 2HG  LYS    92      -8.565   4.084   9.720  1.00 36.29           H 
ATOM   1448 3HD  LYS    92      -8.024   6.427  10.656  1.00 36.29           H 
ATOM   1449 2HD  LYS    92      -7.852   6.907   8.967  1.00 36.29           H 
ATOM   1450 3HE  LYS    92      -6.301   4.743  10.378  1.00 36.29           H 
ATOM   1451 2HE  LYS    92      -5.692   6.326   9.915  1.00 36.29           H 
ATOM   1452 1HZ  LYS    92      -5.967   5.739   7.606  1.00 36.29           H 
ATOM   1453 2HZ  LYS    92      -6.620   4.235   8.030  1.00 36.29           H 
ATOM   1454 3HZ  LYS    92      -5.008   4.579   8.385  1.00 36.29           H 
ATOM   1455  N   LEU    93     -12.170   5.999   7.283  1.00 72.14           N 
ATOM   1456  CA  LEU    93     -12.288   6.540   5.919  1.00 12.31           C 
ATOM   1457  C   LEU    93     -11.469   7.838   5.779  1.00 10.13           C 
ATOM   1458  O   LEU    93     -11.050   8.430   6.777  1.00 42.13           O 
ATOM   1459  CB  LEU    93     -13.758   6.838   5.567  1.00  2.12           C 
ATOM   1460  CG  LEU    93     -14.729   5.640   5.568  1.00 63.13           C 
ATOM   1461  CD1 LEU    93     -14.168   4.482   4.754  1.00 23.14           C 
ATOM   1462  CD2 LEU    93     -15.068   5.202   6.993  1.00 50.42           C 
ATOM   1463  H   LEU    93     -12.626   6.467   8.016  1.00 36.29           H 
ATOM   1464  HA  LEU    93     -11.897   5.805   5.228  1.00 20.21           H 
ATOM   1465 3HB  LEU    93     -13.781   7.284   4.582  1.00 36.29           H 
ATOM   1466 2HB  LEU    93     -14.129   7.569   6.272  1.00 36.29           H 
ATOM   1467  HG  LEU    93     -15.652   5.949   5.093  1.00 22.03           H 
ATOM   1468 1HD1 LEU    93     -13.251   4.130   5.204  1.00 36.29           H 
ATOM   1469 2HD1 LEU    93     -13.968   4.815   3.745  1.00 36.29           H 
ATOM   1470 3HD1 LEU    93     -14.888   3.677   4.728  1.00 36.29           H 
ATOM   1471 1HD2 LEU    93     -15.746   4.363   6.959  1.00 36.29           H 
ATOM   1472 2HD2 LEU    93     -15.539   6.021   7.519  1.00 36.29           H 
ATOM   1473 3HD2 LEU    93     -14.165   4.913   7.510  1.00 36.29           H 
ATOM   1474  N   ASN    94     -11.246   8.277   4.540  1.00 74.35           N 
ATOM   1475  CA  ASN    94     -10.546   9.545   4.271  1.00 71.52           C 
ATOM   1476  C   ASN    94     -11.230  10.336   3.139  1.00 71.43           C 
ATOM   1477  O   ASN    94     -11.226   9.910   1.981  1.00 31.43           O 
ATOM   1478  CB  ASN    94      -9.078   9.279   3.908  1.00 32.31           C 
ATOM   1479  CG  ASN    94      -8.243   8.874   5.111  1.00 15.34           C 
ATOM   1480  OD1 ASN    94      -7.668   9.714   5.790  1.00  0.13           O 
ATOM   1481  ND2 ASN    94      -8.166   7.589   5.389  1.00 63.03           N 
ATOM   1482  H   ASN    94     -11.553   7.736   3.782  1.00 36.29           H 
ATOM   1483  HA  ASN    94     -10.579  10.141   5.175  1.00 70.10           H 
ATOM   1484 3HB  ASN    94      -8.649  10.176   3.483  1.00 36.29           H 
ATOM   1485 2HB  ASN    94      -9.031   8.485   3.177  1.00 36.29           H 
ATOM   1486 1HD2 ASN    94      -8.646   6.957   4.816  1.00 36.29           H 
ATOM   1487 2HD2 ASN    94      -7.625   7.321   6.157  1.00 36.29           H 
ATOM   1488  N   GLY    95     -11.820  11.485   3.478  1.00 54.24           N 
ATOM   1489  CA  GLY    95     -12.478  12.324   2.472  1.00 52.34           C 
ATOM   1490  C   GLY    95     -13.424  13.363   3.078  1.00 12.22           C 
ATOM   1491  O   GLY    95     -13.213  13.825   4.199  1.00 53.41           O 
ATOM   1492  H   GLY    95     -11.815  11.767   4.419  1.00 36.29           H 
ATOM   1493 3HA  GLY    95     -13.044  11.689   1.803  1.00 36.29           H 
ATOM   1494 2HA  GLY    95     -11.721  12.841   1.901  1.00 36.29           H 
ATOM   1495  N   GLY    96     -14.465  13.735   2.330  1.00 32.53           N 
ATOM   1496  CA  GLY    96     -15.456  14.691   2.826  1.00 24.42           C 
ATOM   1497  C   GLY    96     -16.753  14.021   3.281  1.00 74.23           C 
ATOM   1498  O   GLY    96     -16.880  12.797   3.213  1.00 22.41           O 
ATOM   1499  H   GLY    96     -14.565  13.355   1.434  1.00 36.29           H 
ATOM   1500 3HA  GLY    96     -15.685  15.392   2.035  1.00 36.29           H 
ATOM   1501 2HA  GLY    96     -15.036  15.236   3.660  1.00 36.29           H 
ATOM   1502  N   ARG    97     -17.730  14.818   3.722  1.00 73.32           N 
ATOM   1503  CA  ARG    97     -18.994  14.277   4.247  1.00  2.04           C 
ATOM   1504  C   ARG    97     -19.796  13.532   3.167  1.00  2.23           C 
ATOM   1505  O   ARG    97     -20.404  12.500   3.447  1.00 53.11           O 
ATOM   1506  CB  ARG    97     -19.858  15.386   4.873  1.00 45.22           C 
ATOM   1507  CG  ARG    97     -21.094  14.854   5.602  1.00  2.20           C 
ATOM   1508  CD  ARG    97     -21.859  15.957   6.332  1.00 61.12           C 
ATOM   1509  NE  ARG    97     -22.452  16.926   5.413  1.00 32.33           N 
ATOM   1510  CZ  ARG    97     -23.273  17.873   5.779  1.00 32.33           C 
ATOM   1511  NH1 ARG    97     -23.609  18.015   7.020  1.00  3.21           N 
ATOM   1512  NH2 ARG    97     -23.765  18.679   4.900  1.00 11.43           N 
ATOM   1513  H   ARG    97     -17.601  15.792   3.692  1.00 36.29           H 
ATOM   1514  HA  ARG    97     -18.737  13.568   5.022  1.00 11.03           H 
ATOM   1515 3HB  ARG    97     -20.185  16.059   4.092  1.00 36.29           H 
ATOM   1516 2HB  ARG    97     -19.256  15.939   5.582  1.00 36.29           H 
ATOM   1517 3HG  ARG    97     -20.782  14.109   6.321  1.00 36.29           H 
ATOM   1518 2HG  ARG    97     -21.754  14.397   4.878  1.00 36.29           H 
ATOM   1519 3HD  ARG    97     -21.177  16.472   6.995  1.00 36.29           H 
ATOM   1520 2HD  ARG    97     -22.648  15.503   6.916  1.00 36.29           H 
ATOM   1521  HE  ARG    97     -22.222  16.856   4.465  1.00 42.04           H 
ATOM   1522 1HH1 ARG    97     -23.243  17.397   7.712  1.00 36.29           H 
ATOM   1523 2HH1 ARG    97     -24.232  18.749   7.284  1.00 36.29           H 
ATOM   1524 1HH2 ARG    97     -23.519  18.578   3.938  1.00 36.29           H 
ATOM   1525 2HH2 ARG    97     -24.400  19.396   5.185  1.00 36.29           H 
ATOM   1526  N   ARG    98     -19.806  14.050   1.935  1.00 62.12           N 
ATOM   1527  CA  ARG    98     -20.482  13.349   0.830  1.00 55.01           C 
ATOM   1528  C   ARG    98     -19.751  12.044   0.482  1.00  3.21           C 
ATOM   1529  O   ARG    98     -20.380  11.035   0.162  1.00 61.24           O 
ATOM   1530  CB  ARG    98     -20.625  14.236  -0.421  1.00 33.50           C 
ATOM   1531  CG  ARG    98     -21.639  15.373  -0.262  1.00 43.41           C 
ATOM   1532  CD  ARG    98     -21.034  16.611   0.389  1.00 13.11           C 
ATOM   1533  NE  ARG    98     -20.195  17.358  -0.542  1.00 50.33           N 
ATOM   1534  CZ  ARG    98     -19.689  18.532  -0.290  1.00 64.24           C 
ATOM   1535  NH1 ARG    98     -19.838  19.083   0.871  1.00  3.54           N 
ATOM   1536  NH2 ARG    98     -19.019  19.154  -1.203  1.00 71.21           N 
ATOM   1537  H   ARG    98     -19.350  14.902   1.768  1.00 36.29           H 
ATOM   1538  HA  ARG    98     -21.473  13.091   1.181  1.00 32.24           H 
ATOM   1539 3HB  ARG    98     -20.939  13.618  -1.252  1.00 36.29           H 
ATOM   1540 2HB  ARG    98     -19.662  14.668  -0.655  1.00 36.29           H 
ATOM   1541 3HG  ARG    98     -22.461  15.023   0.349  1.00 36.29           H 
ATOM   1542 2HG  ARG    98     -22.012  15.645  -1.238  1.00 36.29           H 
ATOM   1543 3HD  ARG    98     -20.434  16.305   1.235  1.00 36.29           H 
ATOM   1544 2HD  ARG    98     -21.834  17.252   0.731  1.00 36.29           H 
ATOM   1545  HE  ARG    98     -20.026  16.961  -1.422  1.00 13.21           H 
ATOM   1546 1HH1 ARG    98     -20.345  18.610   1.587  1.00 36.29           H 
ATOM   1547 2HH1 ARG    98     -19.436  19.980   1.050  1.00 36.29           H 
ATOM   1548 1HH2 ARG    98     -18.895  18.737  -2.100  1.00 36.29           H 
ATOM   1549 2HH2 ARG    98     -18.633  20.053  -1.007  1.00 36.29           H 
ATOM   1550  N   PHE    99     -18.419  12.069   0.562  1.00  1.52           N 
ATOM   1551  CA  PHE    99     -17.618  10.848   0.421  1.00 14.23           C 
ATOM   1552  C   PHE    99     -18.048   9.806   1.468  1.00  3.12           C 
ATOM   1553  O   PHE    99     -18.276   8.636   1.148  1.00 43.23           O 
ATOM   1554  CB  PHE    99     -16.122  11.175   0.572  1.00 22.30           C 
ATOM   1555  CG  PHE    99     -15.220   9.964   0.535  1.00 62.53           C 
ATOM   1556  CD1 PHE    99     -14.787   9.438  -0.674  1.00 42.43           C 
ATOM   1557  CD2 PHE    99     -14.806   9.350   1.711  1.00 75.53           C 
ATOM   1558  CE1 PHE    99     -13.964   8.330  -0.711  1.00 72.43           C 
ATOM   1559  CE2 PHE    99     -13.982   8.242   1.679  1.00 20.21           C 
ATOM   1560  CZ  PHE    99     -13.562   7.731   0.467  1.00 72.42           C 
ATOM   1561  H   PHE    99     -17.965  12.923   0.714  1.00 36.29           H 
ATOM   1562  HA  PHE    99     -17.796  10.446  -0.568  1.00 12.34           H 
ATOM   1563 3HB  PHE    99     -15.966  11.678   1.516  1.00 36.29           H 
ATOM   1564 2HB  PHE    99     -15.823  11.835  -0.231  1.00 36.29           H 
ATOM   1565  HD1 PHE    99     -15.099   9.905  -1.597  1.00 15.13           H 
ATOM   1566  HD2 PHE    99     -15.135   9.749   2.661  1.00 32.43           H 
ATOM   1567  HE1 PHE    99     -13.636   7.931  -1.661  1.00  0.33           H 
ATOM   1568  HE2 PHE    99     -13.669   7.775   2.601  1.00 65.04           H 
ATOM   1569  HZ  PHE    99     -12.918   6.864   0.441  1.00 12.14           H 
ATOM   1570  N   LEU   100     -18.162  10.248   2.723  1.00 42.30           N 
ATOM   1571  CA  LEU   100     -18.650   9.387   3.806  1.00  4.13           C 
ATOM   1572  C   LEU   100     -20.083   8.916   3.529  1.00 51.22           C 
ATOM   1573  O   LEU   100     -20.413   7.754   3.746  1.00  4.33           O 
ATOM   1574  CB  LEU   100     -18.603  10.130   5.151  1.00 24.23           C 
ATOM   1575  CG  LEU   100     -17.214  10.620   5.591  1.00 21.10           C 
ATOM   1576  CD1 LEU   100     -17.297  11.336   6.937  1.00 11.20           C 
ATOM   1577  CD2 LEU   100     -16.222   9.459   5.656  1.00 32.53           C 
ATOM   1578  H   LEU   100     -17.907  11.174   2.928  1.00 36.29           H 
ATOM   1579  HA  LEU   100     -18.001   8.523   3.859  1.00  2.21           H 
ATOM   1580 3HB  LEU   100     -18.987   9.470   5.917  1.00 36.29           H 
ATOM   1581 2HB  LEU   100     -19.259  10.989   5.082  1.00 36.29           H 
ATOM   1582  HG  LEU   100     -16.846  11.330   4.864  1.00 45.44           H 
ATOM   1583 1HD1 LEU   100     -17.651  10.649   7.693  1.00 36.29           H 
ATOM   1584 2HD1 LEU   100     -17.979  12.171   6.861  1.00 36.29           H 
ATOM   1585 3HD1 LEU   100     -16.316  11.698   7.212  1.00 36.29           H 
ATOM   1586 1HD2 LEU   100     -15.255   9.828   5.969  1.00 36.29           H 
ATOM   1587 2HD2 LEU   100     -16.132   9.004   4.680  1.00 36.29           H 
ATOM   1588 3HD2 LEU   100     -16.572   8.721   6.364  1.00 36.29           H 
ATOM   1589  N   PHE   101     -20.920   9.825   3.030  1.00 25.05           N 
ATOM   1590  CA  PHE   101     -22.321   9.517   2.717  1.00 22.40           C 
ATOM   1591  C   PHE   101     -22.424   8.284   1.810  1.00 32.10           C 
ATOM   1592  O   PHE   101     -23.216   7.374   2.069  1.00 63.25           O 
ATOM   1593  CB  PHE   101     -22.979  10.728   2.043  1.00 62.32           C 
ATOM   1594  CG  PHE   101     -24.419  10.516   1.638  1.00 44.44           C 
ATOM   1595  CD1 PHE   101     -24.744  10.119   0.345  1.00 11.13           C 
ATOM   1596  CD2 PHE   101     -25.447  10.716   2.547  1.00  3.51           C 
ATOM   1597  CE1 PHE   101     -26.062   9.928  -0.027  1.00 71.41           C 
ATOM   1598  CE2 PHE   101     -26.766  10.527   2.179  1.00 53.41           C 
ATOM   1599  CZ  PHE   101     -27.075  10.131   0.891  1.00 10.35           C 
ATOM   1600  H   PHE   101     -20.586  10.731   2.866  1.00 36.29           H 
ATOM   1601  HA  PHE   101     -22.830   9.310   3.648  1.00 74.20           H 
ATOM   1602 3HB  PHE   101     -22.417  10.980   1.154  1.00 36.29           H 
ATOM   1603 2HB  PHE   101     -22.947  11.566   2.724  1.00 36.29           H 
ATOM   1604  HD1 PHE   101     -23.954   9.957  -0.374  1.00  1.30           H 
ATOM   1605  HD2 PHE   101     -25.212  11.026   3.556  1.00 41.52           H 
ATOM   1606  HE1 PHE   101     -26.301   9.619  -1.036  1.00 14.35           H 
ATOM   1607  HE2 PHE   101     -27.556  10.687   2.900  1.00 15.01           H 
ATOM   1608  HZ  PHE   101     -28.106   9.983   0.604  1.00 60.20           H 
ATOM   1609  N   ARG   102     -21.614   8.258   0.753  1.00 23.35           N 
ATOM   1610  CA  ARG   102     -21.536   7.094  -0.134  1.00 23.31           C 
ATOM   1611  C   ARG   102     -21.221   5.817   0.657  1.00 61.20           C 
ATOM   1612  O   ARG   102     -21.913   4.811   0.529  1.00  4.51           O 
ATOM   1613  CB  ARG   102     -20.459   7.310  -1.207  1.00 65.14           C 
ATOM   1614  CG  ARG   102     -20.798   8.403  -2.213  1.00 73.23           C 
ATOM   1615  CD  ARG   102     -22.003   8.029  -3.071  1.00  0.12           C 
ATOM   1616  NE  ARG   102     -22.336   9.077  -4.032  1.00 33.22           N 
ATOM   1617  CZ  ARG   102     -22.683   8.860  -5.272  1.00 43.40           C 
ATOM   1618  NH1 ARG   102     -22.703   7.655  -5.753  1.00  1.11           N 
ATOM   1619  NH2 ARG   102     -22.993   9.855  -6.034  1.00 44.44           N 
ATOM   1620  H   ARG   102     -21.055   9.043   0.563  1.00 36.29           H 
ATOM   1621  HA  ARG   102     -22.497   6.979  -0.618  1.00 14.34           H 
ATOM   1622 3HB  ARG   102     -20.315   6.384  -1.750  1.00 36.29           H 
ATOM   1623 2HB  ARG   102     -19.533   7.576  -0.719  1.00 36.29           H 
ATOM   1624 3HG  ARG   102     -19.945   8.563  -2.859  1.00 36.29           H 
ATOM   1625 2HG  ARG   102     -21.019   9.316  -1.679  1.00 36.29           H 
ATOM   1626 3HD  ARG   102     -22.854   7.865  -2.423  1.00 36.29           H 
ATOM   1627 2HD  ARG   102     -21.780   7.116  -3.605  1.00 36.29           H 
ATOM   1628  HE  ARG   102     -22.307  10.004  -3.716  1.00 40.12           H 
ATOM   1629 1HH1 ARG   102     -22.449   6.881  -5.177  1.00 36.29           H 
ATOM   1630 2HH1 ARG   102     -22.973   7.501  -6.702  1.00 36.29           H 
ATOM   1631 1HH2 ARG   102     -22.969  10.786  -5.671  1.00 36.29           H 
ATOM   1632 2HH2 ARG   102     -23.254   9.695  -6.984  1.00 36.29           H 
ATOM   1633  N   MET   103     -20.186   5.883   1.488  1.00 12.52           N 
ATOM   1634  CA  MET   103     -19.735   4.728   2.273  1.00 72.25           C 
ATOM   1635  C   MET   103     -20.818   4.229   3.246  1.00  2.14           C 
ATOM   1636  O   MET   103     -21.065   3.023   3.350  1.00 24.21           O 
ATOM   1637  CB  MET   103     -18.454   5.093   3.030  1.00 24.22           C 
ATOM   1638  CG  MET   103     -17.340   5.557   2.103  1.00 44.15           C 
ATOM   1639  SD  MET   103     -17.028   4.377   0.772  1.00 62.20           S 
ATOM   1640  CE  MET   103     -16.022   5.358  -0.338  1.00 74.41           C 
ATOM   1641  H   MET   103     -19.708   6.735   1.580  1.00 36.29           H 
ATOM   1642  HA  MET   103     -19.509   3.931   1.578  1.00  4.15           H 
ATOM   1643 3HB  MET   103     -18.106   4.228   3.575  1.00 36.29           H 
ATOM   1644 2HB  MET   103     -18.673   5.889   3.730  1.00 36.29           H 
ATOM   1645 3HG  MET   103     -16.432   5.681   2.679  1.00 36.29           H 
ATOM   1646 2HG  MET   103     -17.621   6.505   1.667  1.00 36.29           H 
ATOM   1647 1HE  MET   103     -15.753   4.765  -1.199  1.00 36.29           H 
ATOM   1648 2HE  MET   103     -15.127   5.675   0.174  1.00 36.29           H 
ATOM   1649 3HE  MET   103     -16.579   6.226  -0.659  1.00 36.29           H 
ATOM   1650  N   LYS   104     -21.477   5.159   3.936  1.00 52.44           N 
ATOM   1651  CA  LYS   104     -22.549   4.815   4.877  1.00 31.44           C 
ATOM   1652  C   LYS   104     -23.705   4.105   4.153  1.00 43.24           C 
ATOM   1653  O   LYS   104     -24.244   3.104   4.634  1.00 41.13           O 
ATOM   1654  CB  LYS   104     -23.070   6.081   5.579  1.00 61.35           C 
ATOM   1655  CG  LYS   104     -21.973   6.933   6.218  1.00 50.22           C 
ATOM   1656  CD  LYS   104     -22.539   8.142   6.969  1.00 61.35           C 
ATOM   1657  CE  LYS   104     -22.892   7.817   8.420  1.00 53.34           C 
ATOM   1658  NZ  LYS   104     -23.861   6.695   8.543  1.00 30.53           N 
ATOM   1659  H   LYS   104     -21.233   6.099   3.812  1.00 36.29           H 
ATOM   1660  HA  LYS   104     -22.137   4.144   5.619  1.00 41.12           H 
ATOM   1661 3HB  LYS   104     -23.764   5.787   6.354  1.00 36.29           H 
ATOM   1662 2HB  LYS   104     -23.593   6.691   4.855  1.00 36.29           H 
ATOM   1663 3HG  LYS   104     -21.309   7.283   5.442  1.00 36.29           H 
ATOM   1664 2HG  LYS   104     -21.415   6.319   6.912  1.00 36.29           H 
ATOM   1665 3HD  LYS   104     -23.431   8.483   6.461  1.00 36.29           H 
ATOM   1666 2HD  LYS   104     -21.802   8.934   6.964  1.00 36.29           H 
ATOM   1667 3HE  LYS   104     -23.319   8.698   8.877  1.00 36.29           H 
ATOM   1668 2HE  LYS   104     -21.987   7.549   8.944  1.00 36.29           H 
ATOM   1669 1HZ  LYS   104     -23.460   5.824   8.137  1.00 36.29           H 
ATOM   1670 2HZ  LYS   104     -24.742   6.924   8.043  1.00 36.29           H 
ATOM   1671 3HZ  LYS   104     -24.080   6.523   9.545  1.00 36.29           H 
ATOM   1672  N   ASN   105     -24.075   4.625   2.986  1.00 31.44           N 
ATOM   1673  CA  ASN   105     -25.150   4.039   2.179  1.00 20.54           C 
ATOM   1674  C   ASN   105     -24.684   2.767   1.446  1.00 62.14           C 
ATOM   1675  O   ASN   105     -25.498   1.920   1.088  1.00 23.42           O 
ATOM   1676  CB  ASN   105     -25.686   5.077   1.183  1.00 52.13           C 
ATOM   1677  CG  ASN   105     -26.582   6.111   1.848  1.00 71.04           C 
ATOM   1678  OD1 ASN   105     -27.800   5.955   1.901  1.00  2.24           O 
ATOM   1679  ND2 ASN   105     -25.995   7.167   2.371  1.00 13.41           N 
ATOM   1680  H   ASN   105     -23.611   5.424   2.654  1.00 36.29           H 
ATOM   1681  HA  ASN   105     -25.950   3.764   2.854  1.00 51.30           H 
ATOM   1682 3HB  ASN   105     -26.259   4.573   0.415  1.00 36.29           H 
ATOM   1683 2HB  ASN   105     -24.854   5.590   0.725  1.00 36.29           H 
ATOM   1684 1HD2 ASN   105     -25.024   7.236   2.304  1.00 36.29           H 
ATOM   1685 2HD2 ASN   105     -26.558   7.835   2.813  1.00 36.29           H 
ATOM   1686  N   LEU   106     -23.375   2.636   1.222  1.00 21.42           N 
ATOM   1687  CA  LEU   106     -22.816   1.444   0.563  1.00 42.00           C 
ATOM   1688  C   LEU   106     -22.699   0.252   1.528  1.00 44.44           C 
ATOM   1689  O   LEU   106     -22.835  -0.898   1.110  1.00 43.31           O 
ATOM   1690  CB  LEU   106     -21.445   1.755  -0.071  1.00 52.23           C 
ATOM   1691  CG  LEU   106     -21.443   1.918  -1.603  1.00 73.13           C 
ATOM   1692  CD1 LEU   106     -21.900   0.628  -2.282  1.00 25.24           C 
ATOM   1693  CD2 LEU   106     -22.324   3.088  -2.033  1.00  3.23           C 
ATOM   1694  H   LEU   106     -22.770   3.358   1.496  1.00 36.29           H 
ATOM   1695  HA  LEU   106     -23.502   1.167  -0.226  1.00 11.44           H 
ATOM   1696 3HB  LEU   106     -20.760   0.956   0.180  1.00 36.29           H 
ATOM   1697 2HB  LEU   106     -21.070   2.671   0.366  1.00 36.29           H 
ATOM   1698  HG  LEU   106     -20.432   2.124  -1.933  1.00 24.21           H 
ATOM   1699 1HD1 LEU   106     -21.863   0.753  -3.355  1.00 36.29           H 
ATOM   1700 2HD1 LEU   106     -22.914   0.401  -1.983  1.00 36.29           H 
ATOM   1701 3HD1 LEU   106     -21.250  -0.184  -1.992  1.00 36.29           H 
ATOM   1702 1HD2 LEU   106     -22.302   3.179  -3.108  1.00 36.29           H 
ATOM   1703 2HD2 LEU   106     -21.955   4.002  -1.588  1.00 36.29           H 
ATOM   1704 3HD2 LEU   106     -23.341   2.915  -1.706  1.00 36.29           H 
ATOM   1705  N   GLY   107     -22.443   0.524   2.808  1.00  4.41           N 
ATOM   1706  CA  GLY   107     -22.387  -0.549   3.803  1.00 75.00           C 
ATOM   1707  C   GLY   107     -21.149  -0.519   4.700  1.00 52.23           C 
ATOM   1708  O   GLY   107     -21.050  -1.299   5.650  1.00 74.33           O 
ATOM   1709  H   GLY   107     -22.303   1.456   3.083  1.00 36.29           H 
ATOM   1710 3HA  GLY   107     -22.415  -1.503   3.292  1.00 36.29           H 
ATOM   1711 2HA  GLY   107     -23.262  -0.474   4.431  1.00 36.29           H 
ATOM   1712  N   ILE   108     -20.204   0.376   4.419  1.00 20.43           N 
ATOM   1713  CA  ILE   108     -18.974   0.469   5.217  1.00 25.42           C 
ATOM   1714  C   ILE   108     -19.059   1.595   6.264  1.00 11.24           C 
ATOM   1715  O   ILE   108     -18.589   2.710   6.045  1.00  1.10           O 
ATOM   1716  CB  ILE   108     -17.688   0.643   4.345  1.00 45.21           C 
ATOM   1717  CG1 ILE   108     -17.897   1.640   3.187  1.00 21.42           C 
ATOM   1718  CG2 ILE   108     -17.203  -0.706   3.815  1.00 34.33           C 
ATOM   1719  CD1 ILE   108     -18.544   1.050   1.944  1.00  2.54           C 
ATOM   1720  H   ILE   108     -20.345   1.003   3.682  1.00 36.29           H 
ATOM   1721  HA  ILE   108     -18.876  -0.468   5.753  1.00 13.33           H 
ATOM   1722  HB  ILE   108     -16.911   1.029   4.991  1.00 72.34           H 
ATOM   1723 3HG1 ILE   108     -16.937   2.045   2.896  1.00 36.29           H 
ATOM   1724 2HG1 ILE   108     -18.527   2.450   3.527  1.00 36.29           H 
ATOM   1725 1HG2 ILE   108     -16.975  -1.359   4.646  1.00 36.29           H 
ATOM   1726 2HG2 ILE   108     -16.312  -0.561   3.220  1.00 36.29           H 
ATOM   1727 3HG2 ILE   108     -17.973  -1.156   3.206  1.00 36.29           H 
ATOM   1728 1HD1 ILE   108     -19.481   0.582   2.206  1.00 36.29           H 
ATOM   1729 2HD1 ILE   108     -17.883   0.316   1.509  1.00 36.29           H 
ATOM   1730 3HD1 ILE   108     -18.726   1.838   1.228  1.00 36.29           H 
ATOM   1731  N   GLU   109     -19.687   1.289   7.400  1.00 14.42           N 
ATOM   1732  CA  GLU   109     -19.801   2.238   8.518  1.00 50.05           C 
ATOM   1733  C   GLU   109     -18.596   2.127   9.468  1.00  1.42           C 
ATOM   1734  O   GLU   109     -17.716   2.992   9.483  1.00  4.22           O 
ATOM   1735  CB  GLU   109     -21.106   1.977   9.291  1.00  3.31           C 
ATOM   1736  CG  GLU   109     -22.377   2.245   8.484  1.00 43.33           C 
ATOM   1737  CD  GLU   109     -22.791   3.711   8.481  1.00  3.32           C 
ATOM   1738  OE1 GLU   109     -21.915   4.593   8.387  1.00 72.11           O 
ATOM   1739  OE2 GLU   109     -24.007   3.992   8.566  1.00  1.44           O 
ATOM   1740  H   GLU   109     -20.100   0.406   7.486  1.00 36.29           H 
ATOM   1741  HA  GLU   109     -19.831   3.239   8.107  1.00 55.04           H 
ATOM   1742 3HB  GLU   109     -21.124   2.609  10.170  1.00 36.29           H 
ATOM   1743 2HB  GLU   109     -21.119   0.946   9.605  1.00 36.29           H 
ATOM   1744 3HG  GLU   109     -23.181   1.659   8.909  1.00 36.29           H 
ATOM   1745 2HG  GLU   109     -22.213   1.933   7.463  1.00 36.29           H 
ATOM   1746  N   SER   110     -18.565   1.053  10.262  1.00 74.22           N 
ATOM   1747  CA  SER   110     -17.453   0.801  11.195  1.00  3.13           C 
ATOM   1748  C   SER   110     -17.450  -0.658  11.674  1.00  5.11           C 
ATOM   1749  O   SER   110     -18.506  -1.248  11.904  1.00 60.41           O 
ATOM   1750  CB  SER   110     -17.540   1.734  12.410  1.00 63.23           C 
ATOM   1751  OG  SER   110     -18.701   1.469  13.185  1.00 53.02           O 
ATOM   1752  H   SER   110     -19.312   0.418  10.232  1.00 36.29           H 
ATOM   1753  HA  SER   110     -16.529   0.997  10.666  1.00 72.12           H 
ATOM   1754 3HB  SER   110     -17.577   2.760  12.072  1.00 36.29           H 
ATOM   1755 2HB  SER   110     -16.669   1.595  13.035  1.00 36.29           H 
ATOM   1756  HG  SER   110     -18.448   1.331  14.105  1.00  0.43           H 
ATOM   1757  N   GLY   111     -16.258  -1.245  11.800  1.00  4.32           N 
ATOM   1758  CA  GLY   111     -16.133  -2.618  12.298  1.00 61.43           C 
ATOM   1759  C   GLY   111     -16.562  -3.693  11.296  1.00 32.32           C 
ATOM   1760  O   GLY   111     -16.359  -4.884  11.537  1.00 51.22           O 
ATOM   1761  H   GLY   111     -15.451  -0.741  11.562  1.00 36.29           H 
ATOM   1762 3HA  GLY   111     -16.736  -2.717  13.191  1.00 36.29           H 
ATOM   1763 2HA  GLY   111     -15.101  -2.790  12.563  1.00 36.29           H 
ATOM   1764  N   LYS   112     -17.154  -3.275  10.176  1.00  3.11           N 
ATOM   1765  CA  LYS   112     -17.630  -4.205   9.140  1.00 34.24           C 
ATOM   1766  C   LYS   112     -16.499  -5.083   8.579  1.00 41.42           C 
ATOM   1767  O   LYS   112     -15.406  -4.595   8.279  1.00  3.25           O 
ATOM   1768  CB  LYS   112     -18.284  -3.424   7.988  1.00 61.22           C 
ATOM   1769  CG  LYS   112     -19.630  -2.792   8.335  1.00 31.01           C 
ATOM   1770  CD  LYS   112     -20.692  -3.852   8.620  1.00 72.52           C 
ATOM   1771  CE  LYS   112     -22.077  -3.237   8.779  1.00 40.15           C 
ATOM   1772  NZ  LYS   112     -23.106  -4.266   9.079  1.00 34.21           N 
ATOM   1773  H   LYS   112     -17.277  -2.317  10.042  1.00 36.29           H 
ATOM   1774  HA  LYS   112     -18.374  -4.844   9.592  1.00 34.15           H 
ATOM   1775 3HB  LYS   112     -18.433  -4.096   7.154  1.00 36.29           H 
ATOM   1776 2HB  LYS   112     -17.612  -2.634   7.680  1.00 36.29           H 
ATOM   1777 3HG  LYS   112     -19.955  -2.184   7.501  1.00 36.29           H 
ATOM   1778 2HG  LYS   112     -19.509  -2.169   9.210  1.00 36.29           H 
ATOM   1779 3HD  LYS   112     -20.434  -4.374   9.532  1.00 36.29           H 
ATOM   1780 2HD  LYS   112     -20.717  -4.554   7.800  1.00 36.29           H 
ATOM   1781 3HE  LYS   112     -22.342  -2.732   7.860  1.00 36.29           H 
ATOM   1782 2HE  LYS   112     -22.051  -2.523   9.587  1.00 36.29           H 
ATOM   1783 1HZ  LYS   112     -22.943  -4.671  10.025  1.00 36.29           H 
ATOM   1784 2HZ  LYS   112     -23.065  -5.032   8.376  1.00 36.29           H 
ATOM   1785 3HZ  LYS   112     -24.052  -3.841   9.057  1.00 36.29           H 
ATOM   1786  N   LYS   113     -16.779  -6.379   8.432  1.00 22.32           N 
ATOM   1787  CA  LYS   113     -15.829  -7.313   7.820  1.00 63.22           C 
ATOM   1788  C   LYS   113     -15.988  -7.337   6.293  1.00 23.13           C 
ATOM   1789  O   LYS   113     -16.949  -7.896   5.759  1.00 61.52           O 
ATOM   1790  CB  LYS   113     -15.994  -8.726   8.407  1.00  2.21           C 
ATOM   1791  CG  LYS   113     -15.299  -8.923   9.757  1.00 33.44           C 
ATOM   1792  CD  LYS   113     -15.792  -7.940  10.821  1.00 54.34           C 
ATOM   1793  CE  LYS   113     -15.025  -8.083  12.130  1.00  4.32           C 
ATOM   1794  NZ  LYS   113     -15.512  -7.131  13.161  1.00 54.11           N 
ATOM   1795  H   LYS   113     -17.644  -6.720   8.747  1.00 36.29           H 
ATOM   1796  HA  LYS   113     -14.834  -6.959   8.052  1.00 65.00           H 
ATOM   1797 3HB  LYS   113     -15.582  -9.444   7.711  1.00 36.29           H 
ATOM   1798 2HB  LYS   113     -17.047  -8.932   8.535  1.00 36.29           H 
ATOM   1799 3HG  LYS   113     -14.234  -8.788   9.621  1.00 36.29           H 
ATOM   1800 2HG  LYS   113     -15.489  -9.930  10.101  1.00 36.29           H 
ATOM   1801 3HD  LYS   113     -16.841  -8.123  11.006  1.00 36.29           H 
ATOM   1802 2HD  LYS   113     -15.663  -6.932  10.453  1.00 36.29           H 
ATOM   1803 3HE  LYS   113     -13.977  -7.892  11.945  1.00 36.29           H 
ATOM   1804 2HE  LYS   113     -15.146  -9.090  12.499  1.00 36.29           H 
ATOM   1805 1HZ  LYS   113     -15.522  -6.165  12.778  1.00 36.29           H 
ATOM   1806 2HZ  LYS   113     -14.886  -7.154  13.991  1.00 36.29           H 
ATOM   1807 3HZ  LYS   113     -16.475  -7.385  13.461  1.00 36.29           H 
ATOM   1808  N   ILE   114     -15.030  -6.725   5.601  1.00 74.14           N 
ATOM   1809  CA  ILE   114     -15.084  -6.570   4.145  1.00  2.33           C 
ATOM   1810  C   ILE   114     -14.092  -7.515   3.433  1.00 44.51           C 
ATOM   1811  O   ILE   114     -12.929  -7.631   3.823  1.00 10.11           O 
ATOM   1812  CB  ILE   114     -14.806  -5.094   3.754  1.00 75.45           C 
ATOM   1813  CG1 ILE   114     -15.044  -4.862   2.251  1.00 52.12           C 
ATOM   1814  CG2 ILE   114     -13.387  -4.676   4.149  1.00 50.24           C 
ATOM   1815  CD1 ILE   114     -15.046  -3.397   1.856  1.00 54.51           C 
ATOM   1816  H   ILE   114     -14.261  -6.363   6.088  1.00 36.29           H 
ATOM   1817  HA  ILE   114     -16.087  -6.818   3.823  1.00 40.45           H 
ATOM   1818  HB  ILE   114     -15.493  -4.473   4.313  1.00  4.51           H 
ATOM   1819 3HG1 ILE   114     -16.002  -5.278   1.977  1.00 36.29           H 
ATOM   1820 2HG1 ILE   114     -14.268  -5.357   1.685  1.00 36.29           H 
ATOM   1821 1HG2 ILE   114     -13.260  -4.793   5.216  1.00 36.29           H 
ATOM   1822 2HG2 ILE   114     -13.224  -3.642   3.880  1.00 36.29           H 
ATOM   1823 3HG2 ILE   114     -12.670  -5.299   3.633  1.00 36.29           H 
ATOM   1824 1HD1 ILE   114     -14.090  -2.956   2.098  1.00 36.29           H 
ATOM   1825 2HD1 ILE   114     -15.828  -2.878   2.392  1.00 36.29           H 
ATOM   1826 3HD1 ILE   114     -15.222  -3.312   0.794  1.00 36.29           H 
ATOM   1827  N   GLN   115     -14.574  -8.211   2.405  1.00  1.25           N 
ATOM   1828  CA  GLN   115     -13.751  -9.165   1.648  1.00 51.53           C 
ATOM   1829  C   GLN   115     -13.154  -8.520   0.389  1.00 75.21           C 
ATOM   1830  O   GLN   115     -13.791  -7.684  -0.255  1.00 13.35           O 
ATOM   1831  CB  GLN   115     -14.577 -10.397   1.244  1.00 52.33           C 
ATOM   1832  CG  GLN   115     -15.051 -11.264   2.410  1.00 22.45           C 
ATOM   1833  CD  GLN   115     -16.130 -10.612   3.259  1.00 10.23           C 
ATOM   1834  OE1 GLN   115     -17.318 -10.739   2.985  1.00 63.13           O 
ATOM   1835  NE2 GLN   115     -15.733  -9.933   4.312  1.00 14.31           N 
ATOM   1836  H   GLN   115     -15.512  -8.084   2.150  1.00 36.29           H 
ATOM   1837  HA  GLN   115     -12.940  -9.484   2.291  1.00 73.32           H 
ATOM   1838 3HB  GLN   115     -13.976 -11.016   0.591  1.00 36.29           H 
ATOM   1839 2HB  GLN   115     -15.449 -10.065   0.699  1.00 36.29           H 
ATOM   1840 3HG  GLN   115     -14.202 -11.486   3.042  1.00 36.29           H 
ATOM   1841 2HG  GLN   115     -15.444 -12.189   2.013  1.00 36.29           H 
ATOM   1842 1HE2 GLN   115     -14.776  -9.884   4.493  1.00 36.29           H 
ATOM   1843 2HE2 GLN   115     -16.416  -9.501   4.866  1.00 36.29           H 
ATOM   1844  N   VAL   116     -11.934  -8.924   0.035  1.00  5.30           N 
ATOM   1845  CA  VAL   116     -11.244  -8.398  -1.153  1.00 24.20           C 
ATOM   1846  C   VAL   116     -11.268  -9.405  -2.321  1.00 21.53           C 
ATOM   1847  O   VAL   116     -10.779 -10.529  -2.193  1.00 13.22           O 
ATOM   1848  CB  VAL   116      -9.771  -8.041  -0.822  1.00 43.21           C 
ATOM   1849  CG1 VAL   116      -9.035  -7.525  -2.059  1.00 45.14           C 
ATOM   1850  CG2 VAL   116      -9.703  -7.018   0.312  1.00 43.24           C 
ATOM   1851  H   VAL   116     -11.477  -9.594   0.590  1.00 36.29           H 
ATOM   1852  HA  VAL   116     -11.751  -7.491  -1.463  1.00 33.34           H 
ATOM   1853  HB  VAL   116      -9.273  -8.943  -0.491  1.00 74.23           H 
ATOM   1854 1HG1 VAL   116      -9.523  -6.632  -2.425  1.00 36.29           H 
ATOM   1855 2HG1 VAL   116      -9.048  -8.282  -2.830  1.00 36.29           H 
ATOM   1856 3HG1 VAL   116      -8.013  -7.293  -1.801  1.00 36.29           H 
ATOM   1857 1HG2 VAL   116     -10.200  -7.414   1.186  1.00 36.29           H 
ATOM   1858 2HG2 VAL   116     -10.191  -6.104   0.005  1.00 36.29           H 
ATOM   1859 3HG2 VAL   116      -8.669  -6.809   0.551  1.00 36.29           H 
ATOM   1860  N   SER   117     -11.834  -8.991  -3.459  1.00 32.24           N 
ATOM   1861  CA  SER   117     -11.877  -9.838  -4.666  1.00 71.32           C 
ATOM   1862  C   SER   117     -11.781  -8.999  -5.949  1.00 31.01           C 
ATOM   1863  O   SER   117     -12.653  -8.179  -6.231  1.00 51.43           O 
ATOM   1864  CB  SER   117     -13.166 -10.671  -4.702  1.00 71.42           C 
ATOM   1865  OG  SER   117     -13.264 -11.424  -5.904  1.00 75.11           O 
ATOM   1866  H   SER   117     -12.243  -8.099  -3.491  1.00 36.29           H 
ATOM   1867  HA  SER   117     -11.028 -10.510  -4.630  1.00 41.04           H 
ATOM   1868 3HB  SER   117     -14.019 -10.012  -4.635  1.00 36.29           H 
ATOM   1869 2HB  SER   117     -13.173 -11.353  -3.867  1.00 36.29           H 
ATOM   1870  HG  SER   117     -14.120 -11.872  -5.932  1.00 73.31           H 
ATOM   1871  N   GLY   118     -10.717  -9.213  -6.719  1.00 33.21           N 
ATOM   1872  CA  GLY   118     -10.530  -8.493  -7.977  1.00 12.42           C 
ATOM   1873  C   GLY   118     -10.578  -6.971  -7.828  1.00 74.20           C 
ATOM   1874  O   GLY   118      -9.735  -6.377  -7.158  1.00 20.33           O 
ATOM   1875  H   GLY   118     -10.053  -9.876  -6.438  1.00 36.29           H 
ATOM   1876 3HA  GLY   118     -11.303  -8.800  -8.669  1.00 36.29           H 
ATOM   1877 2HA  GLY   118      -9.571  -8.769  -8.390  1.00 36.29           H 
ATOM   1878  N   ARG   119     -11.570  -6.342  -8.460  1.00 25.32           N 
ATOM   1879  CA  ARG   119     -11.739  -4.883  -8.395  1.00 34.22           C 
ATOM   1880  C   ARG   119     -13.046  -4.488  -7.683  1.00  2.21           C 
ATOM   1881  O   ARG   119     -13.582  -3.404  -7.913  1.00 13.21           O 
ATOM   1882  CB  ARG   119     -11.711  -4.285  -9.810  1.00 42.40           C 
ATOM   1883  CG  ARG   119     -10.351  -4.386 -10.497  1.00 71.15           C 
ATOM   1884  CD  ARG   119      -9.283  -3.580  -9.762  1.00 32.30           C 
ATOM   1885  NE  ARG   119      -7.979  -3.672 -10.415  1.00 24.14           N 
ATOM   1886  CZ  ARG   119      -6.876  -3.167  -9.934  1.00 45.15           C 
ATOM   1887  NH1 ARG   119      -6.883  -2.491  -8.831  1.00 23.21           N 
ATOM   1888  NH2 ARG   119      -5.766  -3.322 -10.573  1.00 61.32           N 
ATOM   1889  H   ARG   119     -12.206  -6.872  -8.987  1.00 36.29           H 
ATOM   1890  HA  ARG   119     -10.909  -4.478  -7.832  1.00 21.42           H 
ATOM   1891 3HB  ARG   119     -11.984  -3.241  -9.755  1.00 36.29           H 
ATOM   1892 2HB  ARG   119     -12.437  -4.803 -10.422  1.00 36.29           H 
ATOM   1893 3HG  ARG   119     -10.439  -4.013 -11.507  1.00 36.29           H 
ATOM   1894 2HG  ARG   119     -10.047  -5.424 -10.522  1.00 36.29           H 
ATOM   1895 3HD  ARG   119      -9.198  -3.958  -8.751  1.00 36.29           H 
ATOM   1896 2HD  ARG   119      -9.590  -2.545  -9.734  1.00 36.29           H 
ATOM   1897  HE  ARG   119      -7.934  -4.155 -11.265  1.00 73.21           H 
ATOM   1898 1HH1 ARG   119      -7.737  -2.351  -8.338  1.00 36.29           H 
ATOM   1899 2HH1 ARG   119      -6.030  -2.114  -8.478  1.00 36.29           H 
ATOM   1900 1HH2 ARG   119      -5.751  -3.827 -11.434  1.00 36.29           H 
ATOM   1901 2HH2 ARG   119      -4.922  -2.939 -10.202  1.00 36.29           H 
ATOM   1902  N   ARG   120     -13.549  -5.366  -6.814  1.00 13.33           N 
ATOM   1903  CA  ARG   120     -14.733  -5.051  -6.004  1.00 42.34           C 
ATOM   1904  C   ARG   120     -14.646  -5.711  -4.618  1.00  2.33           C 
ATOM   1905  O   ARG   120     -14.144  -6.826  -4.471  1.00 12.04           O 
ATOM   1906  CB  ARG   120     -16.037  -5.467  -6.719  1.00  1.04           C 
ATOM   1907  CG  ARG   120     -16.304  -6.973  -6.772  1.00 73.22           C 
ATOM   1908  CD  ARG   120     -15.361  -7.713  -7.714  1.00 13.13           C 
ATOM   1909  NE  ARG   120     -15.606  -9.153  -7.688  1.00 42.00           N 
ATOM   1910  CZ  ARG   120     -15.171  -9.996  -8.582  1.00  4.14           C 
ATOM   1911  NH1 ARG   120     -14.451  -9.599  -9.583  1.00 52.34           N 
ATOM   1912  NH2 ARG   120     -15.455 -11.249  -8.463  1.00 14.03           N 
ATOM   1913  H   ARG   120     -13.113  -6.240  -6.707  1.00 36.29           H 
ATOM   1914  HA  ARG   120     -14.746  -3.977  -5.863  1.00 23.42           H 
ATOM   1915 3HB  ARG   120     -16.001  -5.097  -7.736  1.00 36.29           H 
ATOM   1916 2HB  ARG   120     -16.870  -5.000  -6.213  1.00 36.29           H 
ATOM   1917 3HG  ARG   120     -17.322  -7.130  -7.106  1.00 36.29           H 
ATOM   1918 2HG  ARG   120     -16.190  -7.382  -5.779  1.00 36.29           H 
ATOM   1919 3HD  ARG   120     -14.340  -7.525  -7.412  1.00 36.29           H 
ATOM   1920 2HD  ARG   120     -15.514  -7.346  -8.720  1.00 36.29           H 
ATOM   1921  HE  ARG   120     -16.141  -9.504  -6.947  1.00 73.14           H 
ATOM   1922 1HH1 ARG   120     -14.218  -8.637  -9.681  1.00 36.29           H 
ATOM   1923 2HH1 ARG   120     -14.127 -10.264 -10.254  1.00 36.29           H 
ATOM   1924 1HH2 ARG   120     -15.997 -11.567  -7.686  1.00 36.29           H 
ATOM   1925 2HH2 ARG   120     -15.140 -11.897  -9.151  1.00 36.29           H 
ATOM   1926  N   TYR   121     -15.137  -5.016  -3.602  1.00 61.44           N 
ATOM   1927  CA  TYR   121     -15.057  -5.499  -2.222  1.00 32.34           C 
ATOM   1928  C   TYR   121     -16.448  -5.885  -1.695  1.00  1.31           C 
ATOM   1929  O   TYR   121     -17.450  -5.283  -2.075  1.00 44.54           O 
ATOM   1930  CB  TYR   121     -14.417  -4.424  -1.344  1.00 31.21           C 
ATOM   1931  CG  TYR   121     -13.079  -3.945  -1.877  1.00 42.15           C 
ATOM   1932  CD1 TYR   121     -12.994  -2.810  -2.676  1.00 22.22           C 
ATOM   1933  CD2 TYR   121     -11.906  -4.634  -1.594  1.00 22.31           C 
ATOM   1934  CE1 TYR   121     -11.781  -2.375  -3.174  1.00 31.53           C 
ATOM   1935  CE2 TYR   121     -10.689  -4.204  -2.089  1.00 43.00           C 
ATOM   1936  CZ  TYR   121     -10.632  -3.074  -2.881  1.00  2.42           C 
ATOM   1937  OH  TYR   121      -9.422  -2.638  -3.372  1.00 23.02           O 
ATOM   1938  H   TYR   121     -15.566  -4.155  -3.780  1.00 36.29           H 
ATOM   1939  HA  TYR   121     -14.427  -6.380  -2.211  1.00 55.21           H 
ATOM   1940 3HB  TYR   121     -14.258  -4.820  -0.351  1.00 36.29           H 
ATOM   1941 2HB  TYR   121     -15.080  -3.571  -1.285  1.00 36.29           H 
ATOM   1942  HD1 TYR   121     -13.895  -2.262  -2.907  1.00 60.30           H 
ATOM   1943  HD2 TYR   121     -11.951  -5.517  -0.975  1.00 15.43           H 
ATOM   1944  HE1 TYR   121     -11.738  -1.491  -3.792  1.00 70.53           H 
ATOM   1945  HE2 TYR   121      -9.787  -4.756  -1.858  1.00  2.23           H 
ATOM   1946  HH  TYR   121      -8.912  -3.391  -3.682  1.00 11.12           H 
ATOM   1947  N   TYR   122     -16.508  -6.891  -0.824  1.00 71.12           N 
ATOM   1948  CA  TYR   122     -17.792  -7.460  -0.385  1.00  4.51           C 
ATOM   1949  C   TYR   122     -18.089  -7.192   1.101  1.00 13.21           C 
ATOM   1950  O   TYR   122     -17.336  -7.607   1.982  1.00  0.03           O 
ATOM   1951  CB  TYR   122     -17.802  -8.974  -0.641  1.00 41.43           C 
ATOM   1952  CG  TYR   122     -17.747  -9.356  -2.112  1.00 23.53           C 
ATOM   1953  CD1 TYR   122     -16.604  -9.120  -2.870  1.00 42.45           C 
ATOM   1954  CD2 TYR   122     -18.835  -9.954  -2.740  1.00 52.10           C 
ATOM   1955  CE1 TYR   122     -16.549  -9.467  -4.203  1.00 23.30           C 
ATOM   1956  CE2 TYR   122     -18.784 -10.306  -4.077  1.00  0.13           C 
ATOM   1957  CZ  TYR   122     -17.638 -10.058  -4.803  1.00 42.13           C 
ATOM   1958  OH  TYR   122     -17.582 -10.400  -6.136  1.00 14.43           O 
ATOM   1959  H   TYR   122     -15.673  -7.263  -0.471  1.00 36.29           H 
ATOM   1960  HA  TYR   122     -18.576  -7.007  -0.979  1.00 54.24           H 
ATOM   1961 3HB  TYR   122     -18.702  -9.398  -0.219  1.00 36.29           H 
ATOM   1962 2HB  TYR   122     -16.943  -9.417  -0.153  1.00 36.29           H 
ATOM   1963  HD1 TYR   122     -15.750  -8.654  -2.400  1.00 52.42           H 
ATOM   1964  HD2 TYR   122     -19.731 -10.145  -2.169  1.00 51.21           H 
ATOM   1965  HE1 TYR   122     -15.651  -9.273  -4.773  1.00 34.31           H 
ATOM   1966  HE2 TYR   122     -19.640 -10.769  -4.546  1.00  1.05           H 
ATOM   1967  HH  TYR   122     -18.382 -10.089  -6.579  1.00 70.22           H 
ATOM   1968  N   ILE   123     -19.191  -6.496   1.363  1.00 61.04           N 
ATOM   1969  CA  ILE   123     -19.716  -6.327   2.724  1.00 61.25           C 
ATOM   1970  C   ILE   123     -20.884  -7.296   2.976  1.00 63.30           C 
ATOM   1971  O   ILE   123     -22.014  -7.048   2.550  1.00 15.23           O 
ATOM   1972  CB  ILE   123     -20.194  -4.867   2.978  1.00 74.12           C 
ATOM   1973  CG1 ILE   123     -18.997  -3.905   3.017  1.00 54.22           C 
ATOM   1974  CG2 ILE   123     -21.003  -4.765   4.277  1.00  1.41           C 
ATOM   1975  CD1 ILE   123     -18.094  -4.109   4.215  1.00 71.10           C 
ATOM   1976  H   ILE   123     -19.665  -6.070   0.620  1.00 36.29           H 
ATOM   1977  HA  ILE   123     -18.918  -6.552   3.422  1.00 35.31           H 
ATOM   1978  HB  ILE   123     -20.843  -4.582   2.160  1.00 71.41           H 
ATOM   1979 3HG1 ILE   123     -19.358  -2.886   3.042  1.00 36.29           H 
ATOM   1980 2HG1 ILE   123     -18.398  -4.045   2.128  1.00 36.29           H 
ATOM   1981 1HG2 ILE   123     -21.283  -3.735   4.449  1.00 36.29           H 
ATOM   1982 2HG2 ILE   123     -20.406  -5.118   5.105  1.00 36.29           H 
ATOM   1983 3HG2 ILE   123     -21.897  -5.370   4.197  1.00 36.29           H 
ATOM   1984 1HD1 ILE   123     -17.717  -5.122   4.218  1.00 36.29           H 
ATOM   1985 2HD1 ILE   123     -18.652  -3.930   5.122  1.00 36.29           H 
ATOM   1986 3HD1 ILE   123     -17.265  -3.418   4.162  1.00 36.29           H 
ATOM   1987  N   GLU   124     -20.594  -8.415   3.642  1.00 50.43           N 
ATOM   1988  CA  GLU   124     -21.624  -9.406   4.008  1.00 72.50           C 
ATOM   1989  C   GLU   124     -22.407  -9.922   2.781  1.00  0.51           C 
ATOM   1990  O   GLU   124     -23.582 -10.275   2.885  1.00  2.31           O 
ATOM   1991  CB  GLU   124     -22.587  -8.789   5.036  1.00  5.20           C 
ATOM   1992  CG  GLU   124     -21.883  -8.290   6.295  1.00 51.14           C 
ATOM   1993  CD  GLU   124     -22.824  -7.630   7.286  1.00 72.34           C 
ATOM   1994  OE1 GLU   124     -23.029  -6.398   7.200  1.00 62.23           O 
ATOM   1995  OE2 GLU   124     -23.355  -8.339   8.163  1.00  1.41           O 
ATOM   1996  H   GLU   124     -19.663  -8.580   3.904  1.00 36.29           H 
ATOM   1997  HA  GLU   124     -21.120 -10.243   4.466  1.00 14.23           H 
ATOM   1998 3HB  GLU   124     -23.315  -9.534   5.324  1.00 36.29           H 
ATOM   1999 2HB  GLU   124     -23.100  -7.953   4.578  1.00 36.29           H 
ATOM   2000 3HG  GLU   124     -21.125  -7.576   6.007  1.00 36.29           H 
ATOM   2001 2HG  GLU   124     -21.410  -9.132   6.782  1.00 36.29           H 
ATOM   2002  N   GLY   125     -21.740  -9.994   1.628  1.00 34.43           N 
ATOM   2003  CA  GLY   125     -22.396 -10.443   0.395  1.00 11.53           C 
ATOM   2004  C   GLY   125     -22.812  -9.294  -0.524  1.00 42.35           C 
ATOM   2005  O   GLY   125     -23.328  -9.521  -1.623  1.00 42.41           O 
ATOM   2006  H   GLY   125     -20.786  -9.770   1.615  1.00 36.29           H 
ATOM   2007 3HA  GLY   125     -23.275 -11.017   0.655  1.00 36.29           H 
ATOM   2008 2HA  GLY   125     -21.713 -11.083  -0.142  1.00 36.29           H 
ATOM   2009  N   ARG   126     -22.592  -8.063  -0.075  1.00 45.25           N 
ATOM   2010  CA  ARG   126     -22.955  -6.864  -0.843  1.00 31.22           C 
ATOM   2011  C   ARG   126     -21.713  -6.201  -1.471  1.00 73.32           C 
ATOM   2012  O   ARG   126     -20.830  -5.721  -0.762  1.00 30.15           O 
ATOM   2013  CB  ARG   126     -23.690  -5.882   0.082  1.00 13.45           C 
ATOM   2014  CG  ARG   126     -23.968  -4.510  -0.524  1.00  1.50           C 
ATOM   2015  CD  ARG   126     -24.833  -3.664   0.403  1.00 43.53           C 
ATOM   2016  NE  ARG   126     -24.871  -2.260   0.000  1.00 73.00           N 
ATOM   2017  CZ  ARG   126     -25.952  -1.533  -0.026  1.00 54.42           C 
ATOM   2018  NH1 ARG   126     -27.111  -2.060   0.202  1.00 32.24           N 
ATOM   2019  NH2 ARG   126     -25.872  -0.275  -0.293  1.00 23.22           N 
ATOM   2020  H   ARG   126     -22.182  -7.951   0.808  1.00 36.29           H 
ATOM   2021  HA  ARG   126     -23.626  -7.166  -1.634  1.00  5.14           H 
ATOM   2022 3HB  ARG   126     -23.094  -5.741   0.974  1.00 36.29           H 
ATOM   2023 2HB  ARG   126     -24.636  -6.320   0.364  1.00 36.29           H 
ATOM   2024 3HG  ARG   126     -24.482  -4.637  -1.467  1.00 36.29           H 
ATOM   2025 2HG  ARG   126     -23.029  -4.001  -0.689  1.00 36.29           H 
ATOM   2026 3HD  ARG   126     -24.433  -3.726   1.407  1.00 36.29           H 
ATOM   2027 2HD  ARG   126     -25.839  -4.059   0.396  1.00 36.29           H 
ATOM   2028  HE  ARG   126     -24.020  -1.834  -0.220  1.00 22.03           H 
ATOM   2029 1HH1 ARG   126     -27.187  -3.034   0.399  1.00 36.29           H 
ATOM   2030 2HH1 ARG   126     -27.931  -1.491   0.180  1.00 36.29           H 
ATOM   2031 1HH2 ARG   126     -24.990   0.139  -0.486  1.00 36.29           H 
ATOM   2032 2HH2 ARG   126     -26.697   0.289  -0.284  1.00 36.29           H 
ATOM   2033  N   GLU   127     -21.651  -6.181  -2.805  1.00  3.43           N 
ATOM   2034  CA  GLU   127     -20.499  -5.610  -3.526  1.00 23.43           C 
ATOM   2035  C   GLU   127     -20.452  -4.075  -3.422  1.00 73.44           C 
ATOM   2036  O   GLU   127     -21.470  -3.395  -3.578  1.00 75.52           O 
ATOM   2037  CB  GLU   127     -20.531  -6.031  -5.005  1.00 34.52           C 
ATOM   2038  CG  GLU   127     -20.492  -7.542  -5.217  1.00 23.15           C 
ATOM   2039  CD  GLU   127     -20.491  -7.936  -6.690  1.00 21.12           C 
ATOM   2040  OE1 GLU   127     -21.513  -7.698  -7.369  1.00 32.20           O 
ATOM   2041  OE2 GLU   127     -19.483  -8.500  -7.169  1.00 20.22           O 
ATOM   2042  H   GLU   127     -22.393  -6.564  -3.321  1.00 36.29           H 
ATOM   2043  HA  GLU   127     -19.601  -6.012  -3.075  1.00 63.25           H 
ATOM   2044 3HB  GLU   127     -19.680  -5.597  -5.510  1.00 36.29           H 
ATOM   2045 2HB  GLU   127     -21.437  -5.648  -5.457  1.00 36.29           H 
ATOM   2046 3HG  GLU   127     -21.360  -7.980  -4.743  1.00 36.29           H 
ATOM   2047 2HG  GLU   127     -19.598  -7.934  -4.749  1.00 36.29           H 
ATOM   2048  N   ILE   128     -19.256  -3.544  -3.166  1.00  2.14           N 
ATOM   2049  CA  ILE   128     -19.042  -2.099  -3.017  1.00 13.41           C 
ATOM   2050  C   ILE   128     -18.389  -1.498  -4.276  1.00 60.24           C 
ATOM   2051  O   ILE   128     -17.491  -2.103  -4.868  1.00 23.33           O 
ATOM   2052  CB  ILE   128     -18.137  -1.794  -1.793  1.00 44.41           C 
ATOM   2053  CG1 ILE   128     -18.641  -2.537  -0.542  1.00 63.42           C 
ATOM   2054  CG2 ILE   128     -18.069  -0.288  -1.534  1.00 71.34           C 
ATOM   2055  CD1 ILE   128     -20.042  -2.154  -0.116  1.00 51.12           C 
ATOM   2056  H   ILE   128     -18.488  -4.144  -3.072  1.00 36.29           H 
ATOM   2057  HA  ILE   128     -20.004  -1.626  -2.858  1.00  4.01           H 
ATOM   2058  HB  ILE   128     -17.136  -2.137  -2.021  1.00 64.42           H 
ATOM   2059 3HG1 ILE   128     -17.976  -2.331   0.284  1.00 36.29           H 
ATOM   2060 2HG1 ILE   128     -18.639  -3.601  -0.738  1.00 36.29           H 
ATOM   2061 1HG2 ILE   128     -17.653   0.207  -2.400  1.00 36.29           H 
ATOM   2062 2HG2 ILE   128     -17.442  -0.095  -0.675  1.00 36.29           H 
ATOM   2063 3HG2 ILE   128     -19.063   0.093  -1.346  1.00 36.29           H 
ATOM   2064 1HD1 ILE   128     -20.324  -2.735   0.748  1.00 36.29           H 
ATOM   2065 2HD1 ILE   128     -20.732  -2.351  -0.923  1.00 36.29           H 
ATOM   2066 3HD1 ILE   128     -20.069  -1.103   0.134  1.00 36.29           H 
ATOM   2067  N   ASP   129     -18.830  -0.303  -4.667  1.00 10.23           N 
ATOM   2068  CA  ASP   129     -18.320   0.368  -5.871  1.00 53.10           C 
ATOM   2069  C   ASP   129     -16.919   0.983  -5.656  1.00 64.35           C 
ATOM   2070  O   ASP   129     -16.748   2.206  -5.689  1.00  1.51           O 
ATOM   2071  CB  ASP   129     -19.308   1.456  -6.304  1.00  2.33           C 
ATOM   2072  CG  ASP   129     -20.702   0.910  -6.541  1.00 40.11           C 
ATOM   2073  OD1 ASP   129     -21.429   0.674  -5.552  1.00 24.23           O 
ATOM   2074  OD2 ASP   129     -21.082   0.722  -7.714  1.00 21.40           O 
ATOM   2075  H   ASP   129     -19.529   0.139  -4.141  1.00 36.29           H 
ATOM   2076  HA  ASP   129     -18.255  -0.371  -6.657  1.00 22.45           H 
ATOM   2077 3HB  ASP   129     -18.956   1.911  -7.219  1.00 36.29           H 
ATOM   2078 2HB  ASP   129     -19.364   2.210  -5.531  1.00 36.29           H 
ATOM   2079  N   LEU   130     -15.920   0.130  -5.439  1.00  3.51           N 
ATOM   2080  CA  LEU   130     -14.531   0.578  -5.238  1.00 61.03           C 
ATOM   2081  C   LEU   130     -13.562  -0.220  -6.127  1.00 74.21           C 
ATOM   2082  O   LEU   130     -13.376  -1.421  -5.928  1.00 53.25           O 
ATOM   2083  CB  LEU   130     -14.124   0.427  -3.761  1.00 74.02           C 
ATOM   2084  CG  LEU   130     -14.939   1.257  -2.750  1.00 72.05           C 
ATOM   2085  CD1 LEU   130     -14.503   0.942  -1.319  1.00 35.30           C 
ATOM   2086  CD2 LEU   130     -14.803   2.753  -3.038  1.00 43.21           C 
ATOM   2087  H   LEU   130     -16.116  -0.831  -5.421  1.00 36.29           H 
ATOM   2088  HA  LEU   130     -14.471   1.622  -5.514  1.00 44.34           H 
ATOM   2089 3HB  LEU   130     -13.083   0.710  -3.666  1.00 36.29           H 
ATOM   2090 2HB  LEU   130     -14.217  -0.616  -3.494  1.00 36.29           H 
ATOM   2091  HG  LEU   130     -15.985   0.994  -2.841  1.00 12.31           H 
ATOM   2092 1HD1 LEU   130     -15.095   1.524  -0.625  1.00 36.29           H 
ATOM   2093 2HD1 LEU   130     -13.459   1.188  -1.195  1.00 36.29           H 
ATOM   2094 3HD1 LEU   130     -14.649  -0.110  -1.119  1.00 36.29           H 
ATOM   2095 1HD2 LEU   130     -15.174   2.967  -4.030  1.00 36.29           H 
ATOM   2096 2HD2 LEU   130     -13.763   3.042  -2.973  1.00 36.29           H 
ATOM   2097 3HD2 LEU   130     -15.376   3.313  -2.312  1.00 36.29           H 
ATOM   2098  N   GLY   131     -12.948   0.452  -7.101  1.00 45.24           N 
ATOM   2099  CA  GLY   131     -12.041  -0.222  -8.029  1.00 14.03           C 
ATOM   2100  C   GLY   131     -10.564   0.103  -7.802  1.00 62.02           C 
ATOM   2101  O   GLY   131      -9.718  -0.795  -7.819  1.00  1.13           O 
ATOM   2102  H   GLY   131     -13.122   1.412  -7.203  1.00 36.29           H 
ATOM   2103 3HA  GLY   131     -12.304   0.069  -9.036  1.00 36.29           H 
ATOM   2104 2HA  GLY   131     -12.175  -1.291  -7.937  1.00 36.29           H 
ATOM   2105  N   TYR   132     -10.244   1.385  -7.598  1.00 45.14           N 
ATOM   2106  CA  TYR   132      -8.845   1.811  -7.437  1.00  1.23           C 
ATOM   2107  C   TYR   132      -8.724   3.175  -6.724  1.00 64.11           C 
ATOM   2108  O   TYR   132      -8.341   3.239  -5.553  1.00 23.12           O 
ATOM   2109  CB  TYR   132      -8.156   1.872  -8.812  1.00 71.04           C 
ATOM   2110  CG  TYR   132      -6.671   2.197  -8.754  1.00  1.22           C 
ATOM   2111  CD1 TYR   132      -6.208   3.502  -8.918  1.00 24.34           C 
ATOM   2112  CD2 TYR   132      -5.730   1.194  -8.540  1.00 40.31           C 
ATOM   2113  CE1 TYR   132      -4.858   3.792  -8.869  1.00  2.13           C 
ATOM   2114  CE2 TYR   132      -4.380   1.479  -8.489  1.00 42.44           C 
ATOM   2115  CZ  TYR   132      -3.948   2.778  -8.655  1.00  3.14           C 
ATOM   2116  OH  TYR   132      -2.601   3.065  -8.606  1.00 52.01           O 
ATOM   2117  H   TYR   132     -10.961   2.053  -7.549  1.00 36.29           H 
ATOM   2118  HA  TYR   132      -8.344   1.065  -6.834  1.00 63.41           H 
ATOM   2119 3HB  TYR   132      -8.641   2.630  -9.412  1.00 36.29           H 
ATOM   2120 2HB  TYR   132      -8.266   0.914  -9.303  1.00 36.29           H 
ATOM   2121  HD1 TYR   132      -6.922   4.295  -9.085  1.00 64.32           H 
ATOM   2122  HD2 TYR   132      -6.069   0.176  -8.409  1.00 13.42           H 
ATOM   2123  HE1 TYR   132      -4.519   4.810  -8.997  1.00 20.44           H 
ATOM   2124  HE2 TYR   132      -3.666   0.684  -8.323  1.00 11.35           H 
ATOM   2125  HH  TYR   132      -2.450   3.807  -8.015  1.00  3.43           H 
ATOM   2126  N   GLY   133      -9.071   4.255  -7.436  1.00 51.33           N 
ATOM   2127  CA  GLY   133      -8.870   5.614  -6.924  1.00 13.10           C 
ATOM   2128  C   GLY   133      -9.509   5.864  -5.560  1.00 40.20           C 
ATOM   2129  O   GLY   133      -8.873   6.404  -4.657  1.00 13.21           O 
ATOM   2130  H   GLY   133      -9.477   4.130  -8.322  1.00 36.29           H 
ATOM   2131 3HA  GLY   133      -9.290   6.313  -7.635  1.00 36.29           H 
ATOM   2132 2HA  GLY   133      -7.808   5.801  -6.848  1.00 36.29           H 
ATOM   2133  N   GLU   134     -10.769   5.477  -5.411  1.00 14.42           N 
ATOM   2134  CA  GLU   134     -11.477   5.632  -4.139  1.00 14.32           C 
ATOM   2135  C   GLU   134     -11.047   4.559  -3.127  1.00 52.13           C 
ATOM   2136  O   GLU   134     -11.004   4.806  -1.924  1.00 35.42           O 
ATOM   2137  CB  GLU   134     -12.994   5.561  -4.367  1.00 42.30           C 
ATOM   2138  CG  GLU   134     -13.506   6.514  -5.445  1.00 54.42           C 
ATOM   2139  CD  GLU   134     -13.287   7.985  -5.110  1.00 32.14           C 
ATOM   2140  OE1 GLU   134     -12.181   8.506  -5.365  1.00 10.42           O 
ATOM   2141  OE2 GLU   134     -14.229   8.633  -4.613  1.00  3.31           O 
ATOM   2142  H   GLU   134     -11.236   5.078  -6.174  1.00 36.29           H 
ATOM   2143  HA  GLU   134     -11.229   6.606  -3.738  1.00 11.20           H 
ATOM   2144 3HB  GLU   134     -13.499   5.797  -3.440  1.00 36.29           H 
ATOM   2145 2HB  GLU   134     -13.256   4.553  -4.656  1.00 36.29           H 
ATOM   2146 3HG  GLU   134     -14.565   6.343  -5.580  1.00 36.29           H 
ATOM   2147 2HG  GLU   134     -12.991   6.294  -6.371  1.00 36.29           H 
ATOM   2148  N   ALA   135     -10.703   3.373  -3.630  1.00 32.24           N 
ATOM   2149  CA  ALA   135     -10.360   2.223  -2.778  1.00 13.22           C 
ATOM   2150  C   ALA   135      -9.159   2.502  -1.854  1.00 64.43           C 
ATOM   2151  O   ALA   135      -9.058   1.931  -0.768  1.00 72.22           O 
ATOM   2152  CB  ALA   135     -10.092   0.994  -3.640  1.00  0.25           C 
ATOM   2153  H   ALA   135     -10.672   3.267  -4.603  1.00 36.29           H 
ATOM   2154  HA  ALA   135     -11.223   2.006  -2.160  1.00 21.24           H 
ATOM   2155 1HB  ALA   135      -9.200   1.152  -4.231  1.00 36.29           H 
ATOM   2156 2HB  ALA   135     -10.932   0.825  -4.300  1.00 36.29           H 
ATOM   2157 3HB  ALA   135      -9.956   0.128  -3.007  1.00 36.29           H 
ATOM   2158  N   THR   136      -8.253   3.382  -2.283  1.00  1.31           N 
ATOM   2159  CA  THR   136      -7.082   3.750  -1.460  1.00 43.53           C 
ATOM   2160  C   THR   136      -7.462   4.690  -0.303  1.00 35.52           C 
ATOM   2161  O   THR   136      -6.651   4.957   0.586  1.00  1.42           O 
ATOM   2162  CB  THR   136      -5.969   4.427  -2.303  1.00  2.12           C 
ATOM   2163  OG1 THR   136      -4.807   4.668  -1.493  1.00 12.44           O 
ATOM   2164  CG2 THR   136      -6.450   5.744  -2.903  1.00 50.10           C 
ATOM   2165  H   THR   136      -8.361   3.783  -3.175  1.00 36.29           H 
ATOM   2166  HA  THR   136      -6.676   2.838  -1.042  1.00 73.22           H 
ATOM   2167  HB  THR   136      -5.698   3.759  -3.110  1.00 11.11           H 
ATOM   2168  HG1 THR   136      -5.076   5.022  -0.638  1.00 72.40           H 
ATOM   2169 1HG2 THR   136      -7.315   5.565  -3.525  1.00 36.29           H 
ATOM   2170 2HG2 THR   136      -5.662   6.178  -3.501  1.00 36.29           H 
ATOM   2171 3HG2 THR   136      -6.715   6.429  -2.109  1.00 36.29           H 
ATOM   2172  N   LYS   137      -8.693   5.194  -0.325  1.00  0.45           N 
ATOM   2173  CA  LYS   137      -9.171   6.133   0.698  1.00 32.52           C 
ATOM   2174  C   LYS   137      -9.853   5.400   1.868  1.00  3.21           C 
ATOM   2175  O   LYS   137     -10.067   5.980   2.938  1.00  4.43           O 
ATOM   2176  CB  LYS   137     -10.137   7.139   0.054  1.00 72.22           C 
ATOM   2177  CG  LYS   137      -9.533   7.870  -1.145  1.00 73.34           C 
ATOM   2178  CD  LYS   137     -10.552   8.761  -1.852  1.00 23.35           C 
ATOM   2179  CE  LYS   137      -9.944   9.465  -3.064  1.00 30.11           C 
ATOM   2180  NZ  LYS   137     -10.926  10.344  -3.752  1.00 45.11           N 
ATOM   2181  H   LYS   137      -9.299   4.933  -1.050  1.00 36.29           H 
ATOM   2182  HA  LYS   137      -8.316   6.671   1.084  1.00 52.10           H 
ATOM   2183 3HB  LYS   137     -10.423   7.874   0.792  1.00 36.29           H 
ATOM   2184 2HB  LYS   137     -11.022   6.611  -0.278  1.00 36.29           H 
ATOM   2185 3HG  LYS   137      -9.162   7.136  -1.848  1.00 36.29           H 
ATOM   2186 2HG  LYS   137      -8.712   8.485  -0.804  1.00 36.29           H 
ATOM   2187 3HD  LYS   137     -10.909   9.506  -1.155  1.00 36.29           H 
ATOM   2188 2HD  LYS   137     -11.381   8.150  -2.182  1.00 36.29           H 
ATOM   2189 3HE  LYS   137      -9.595   8.717  -3.761  1.00 36.29           H 
ATOM   2190 2HE  LYS   137      -9.108  10.067  -2.736  1.00 36.29           H 
ATOM   2191 1HZ  LYS   137     -10.459  10.867  -4.522  1.00 36.29           H 
ATOM   2192 2HZ  LYS   137     -11.333  11.027  -3.081  1.00 36.29           H 
ATOM   2193 3HZ  LYS   137     -11.695   9.771  -4.159  1.00 36.29           H 
ATOM   2194  N   ILE   138     -10.192   4.126   1.658  1.00 60.30           N 
ATOM   2195  CA  ILE   138     -10.785   3.292   2.714  1.00 62.30           C 
ATOM   2196  C   ILE   138      -9.712   2.400   3.357  1.00 50.30           C 
ATOM   2197  O   ILE   138      -9.086   1.582   2.678  1.00 52.20           O 
ATOM   2198  CB  ILE   138     -11.935   2.386   2.180  1.00 71.20           C 
ATOM   2199  CG1 ILE   138     -13.093   3.223   1.601  1.00  0.22           C 
ATOM   2200  CG2 ILE   138     -12.456   1.467   3.290  1.00 55.43           C 
ATOM   2201  CD1 ILE   138     -12.779   3.906   0.287  1.00 51.44           C 
ATOM   2202  H   ILE   138     -10.031   3.732   0.775  1.00 36.29           H 
ATOM   2203  HA  ILE   138     -11.193   3.950   3.471  1.00 42.11           H 
ATOM   2204  HB  ILE   138     -11.530   1.759   1.397  1.00 72.45           H 
ATOM   2205 3HG1 ILE   138     -13.364   3.990   2.315  1.00 36.29           H 
ATOM   2206 2HG1 ILE   138     -13.947   2.581   1.438  1.00 36.29           H 
ATOM   2207 1HG2 ILE   138     -13.269   0.864   2.909  1.00 36.29           H 
ATOM   2208 2HG2 ILE   138     -12.808   2.063   4.118  1.00 36.29           H 
ATOM   2209 3HG2 ILE   138     -11.659   0.819   3.628  1.00 36.29           H 
ATOM   2210 1HD1 ILE   138     -12.508   3.166  -0.450  1.00 36.29           H 
ATOM   2211 2HD1 ILE   138     -11.957   4.594   0.425  1.00 36.29           H 
ATOM   2212 3HD1 ILE   138     -13.648   4.450  -0.053  1.00 36.29           H 
ATOM   2213  N   TRP   139      -9.507   2.557   4.663  1.00 34.04           N 
ATOM   2214  CA  TRP   139      -8.464   1.812   5.381  1.00 62.21           C 
ATOM   2215  C   TRP   139      -9.060   0.686   6.244  1.00 73.43           C 
ATOM   2216  O   TRP   139     -10.042   0.886   6.972  1.00 54.32           O 
ATOM   2217  CB  TRP   139      -7.639   2.774   6.242  1.00 72.31           C 
ATOM   2218  CG  TRP   139      -6.849   3.766   5.435  1.00 12.05           C 
ATOM   2219  CD1 TRP   139      -7.347   4.748   4.628  1.00 14.33           C 
ATOM   2220  CD2 TRP   139      -5.420   3.875   5.361  1.00 24.53           C 
ATOM   2221  NE1 TRP   139      -6.319   5.453   4.052  1.00 52.22           N 
ATOM   2222  CE2 TRP   139      -5.129   4.938   4.487  1.00 34.30           C 
ATOM   2223  CE3 TRP   139      -4.360   3.175   5.944  1.00 50.24           C 
ATOM   2224  CZ2 TRP   139      -3.822   5.321   4.189  1.00 25.22           C 
ATOM   2225  CZ3 TRP   139      -3.064   3.555   5.648  1.00 32.41           C 
ATOM   2226  CH2 TRP   139      -2.805   4.618   4.775  1.00 30.23           C 
ATOM   2227  H   TRP   139     -10.074   3.183   5.164  1.00 36.29           H 
ATOM   2228  HA  TRP   139      -7.812   1.366   4.641  1.00 33.35           H 
ATOM   2229 3HB  TRP   139      -6.944   2.207   6.846  1.00 36.29           H 
ATOM   2230 2HB  TRP   139      -8.303   3.327   6.891  1.00 36.29           H 
ATOM   2231  HD1 TRP   139      -8.399   4.928   4.470  1.00 44.54           H 
ATOM   2232  HE1 TRP   139      -6.424   6.204   3.431  1.00 35.00           H 
ATOM   2233  HE3 TRP   139      -4.540   2.349   6.620  1.00 21.20           H 
ATOM   2234  HZ2 TRP   139      -3.605   6.140   3.518  1.00 53.50           H 
ATOM   2235  HZ3 TRP   139      -2.234   3.026   6.092  1.00 34.22           H 
ATOM   2236  HH2 TRP   139      -1.777   4.881   4.571  1.00 14.23           H 
ATOM   2237  N   VAL   140      -8.449  -0.496   6.161  1.00  0.54           N 
ATOM   2238  CA  VAL   140      -8.938  -1.696   6.851  1.00 32.24           C 
ATOM   2239  C   VAL   140      -7.802  -2.448   7.571  1.00 64.04           C 
ATOM   2240  O   VAL   140      -6.622  -2.139   7.395  1.00 32.00           O 
ATOM   2241  CB  VAL   140      -9.619  -2.665   5.851  1.00 10.53           C 
ATOM   2242  CG1 VAL   140     -10.863  -2.025   5.239  1.00 65.31           C 
ATOM   2243  CG2 VAL   140      -8.634  -3.094   4.760  1.00 12.24           C 
ATOM   2244  H   VAL   140      -7.634  -0.566   5.620  1.00 36.29           H 
ATOM   2245  HA  VAL   140      -9.673  -1.391   7.585  1.00 32.01           H 
ATOM   2246  HB  VAL   140      -9.930  -3.549   6.392  1.00  4.45           H 
ATOM   2247 1HG1 VAL   140     -10.581  -1.133   4.698  1.00 36.29           H 
ATOM   2248 2HG1 VAL   140     -11.558  -1.767   6.022  1.00 36.29           H 
ATOM   2249 3HG1 VAL   140     -11.332  -2.722   4.560  1.00 36.29           H 
ATOM   2250 1HG2 VAL   140      -9.113  -3.802   4.097  1.00 36.29           H 
ATOM   2251 2HG2 VAL   140      -7.769  -3.557   5.215  1.00 36.29           H 
ATOM   2252 3HG2 VAL   140      -8.322  -2.229   4.194  1.00 36.29           H 
ATOM   2253  N   ARG   141      -8.170  -3.442   8.383  1.00 63.11           N 
ATOM   2254  CA  ARG   141      -7.185  -4.279   9.087  1.00 51.13           C 
ATOM   2255  C   ARG   141      -7.414  -5.772   8.793  1.00 12.45           C 
ATOM   2256  O   ARG   141      -8.551  -6.218   8.640  1.00 24.20           O 
ATOM   2257  CB  ARG   141      -7.246  -4.032  10.602  1.00  0.25           C 
ATOM   2258  CG  ARG   141      -7.161  -2.558  10.991  1.00  0.14           C 
ATOM   2259  CD  ARG   141      -6.786  -2.374  12.455  1.00 54.21           C 
ATOM   2260  NE  ARG   141      -5.429  -2.848  12.727  1.00 53.01           N 
ATOM   2261  CZ  ARG   141      -4.869  -2.849  13.904  1.00 10.01           C 
ATOM   2262  NH1 ARG   141      -5.511  -2.417  14.941  1.00 24.05           N 
ATOM   2263  NH2 ARG   141      -3.659  -3.286  14.042  1.00 32.42           N 
ATOM   2264  H   ARG   141      -9.125  -3.617   8.517  1.00 36.29           H 
ATOM   2265  HA  ARG   141      -6.202  -4.006   8.728  1.00 31.52           H 
ATOM   2266 3HB  ARG   141      -6.424  -4.555  11.071  1.00 36.29           H 
ATOM   2267 2HB  ARG   141      -8.176  -4.430  10.984  1.00 36.29           H 
ATOM   2268 3HG  ARG   141      -8.121  -2.093  10.813  1.00 36.29           H 
ATOM   2269 2HG  ARG   141      -6.411  -2.078  10.380  1.00 36.29           H 
ATOM   2270 3HD  ARG   141      -7.483  -2.930  13.066  1.00 36.29           H 
ATOM   2271 2HD  ARG   141      -6.849  -1.324  12.703  1.00 36.29           H 
ATOM   2272  HE  ARG   141      -4.909  -3.187  11.973  1.00 25.03           H 
ATOM   2273 1HH1 ARG   141      -6.443  -2.080  14.848  1.00 36.29           H 
ATOM   2274 2HH1 ARG   141      -5.073  -2.433  15.838  1.00 36.29           H 
ATOM   2275 1HH2 ARG   141      -3.157  -3.623  13.247  1.00 36.29           H 
ATOM   2276 2HH2 ARG   141      -3.229  -3.293  14.942  1.00 36.29           H 
ATOM   2277  N   ARG   142      -6.328  -6.540   8.717  1.00 31.12           N 
ATOM   2278  CA  ARG   142      -6.410  -7.976   8.407  1.00 50.41           C 
ATOM   2279  C   ARG   142      -6.858  -8.784   9.639  1.00 14.23           C 
ATOM   2280  O   ARG   142      -6.099  -8.953  10.593  1.00 51.22           O 
ATOM   2281  CB  ARG   142      -5.036  -8.463   7.909  1.00  3.44           C 
ATOM   2282  CG  ARG   142      -4.971  -9.932   7.482  1.00 71.22           C 
ATOM   2283  CD  ARG   142      -5.908 -10.249   6.313  1.00 43.30           C 
ATOM   2284  NE  ARG   142      -5.277 -11.114   5.314  1.00  4.21           N 
ATOM   2285  CZ  ARG   142      -5.064 -12.395   5.460  1.00 43.14           C 
ATOM   2286  NH1 ARG   142      -5.406 -12.998   6.554  1.00 73.50           N 
ATOM   2287  NH2 ARG   142      -4.502 -13.067   4.507  1.00 15.44           N 
ATOM   2288  H   ARG   142      -5.449  -6.137   8.876  1.00 36.29           H 
ATOM   2289  HA  ARG   142      -7.136  -8.106   7.617  1.00 11.02           H 
ATOM   2290 3HB  ARG   142      -4.314  -8.313   8.699  1.00 36.29           H 
ATOM   2291 2HB  ARG   142      -4.746  -7.861   7.062  1.00 36.29           H 
ATOM   2292 3HG  ARG   142      -5.242 -10.551   8.327  1.00 36.29           H 
ATOM   2293 2HG  ARG   142      -3.957 -10.159   7.187  1.00 36.29           H 
ATOM   2294 3HD  ARG   142      -6.198  -9.323   5.835  1.00 36.29           H 
ATOM   2295 2HD  ARG   142      -6.790 -10.742   6.697  1.00 36.29           H 
ATOM   2296  HE  ARG   142      -5.003 -10.702   4.473  1.00 13.45           H 
ATOM   2297 1HH1 ARG   142      -5.836 -12.489   7.285  1.00 36.29           H 
ATOM   2298 2HH1 ARG   142      -5.224 -13.976   6.661  1.00 36.29           H 
ATOM   2299 1HH2 ARG   142      -4.233 -12.602   3.661  1.00 36.29           H 
ATOM   2300 2HH2 ARG   142      -4.336 -14.043   4.613  1.00 36.29           H 
ATOM   2301  N   VAL   143      -8.093  -9.288   9.607  1.00 22.51           N 
ATOM   2302  CA  VAL   143      -8.649 -10.049  10.739  1.00 13.35           C 
ATOM   2303  C   VAL   143      -8.612 -11.568  10.496  1.00 21.13           C 
ATOM   2304  O   VAL   143      -8.180 -12.329  11.365  1.00 62.05           O 
ATOM   2305  CB  VAL   143     -10.104  -9.615  11.064  1.00 33.44           C 
ATOM   2306  CG1 VAL   143     -10.136  -8.189  11.600  1.00  3.53           C 
ATOM   2307  CG2 VAL   143     -11.010  -9.743   9.841  1.00 65.43           C 
ATOM   2308  H   VAL   143      -8.652  -9.131   8.816  1.00 36.29           H 
ATOM   2309  HA  VAL   143      -8.039  -9.831  11.608  1.00 35.11           H 
ATOM   2310  HB  VAL   143     -10.487 -10.271  11.836  1.00 21.23           H 
ATOM   2311 1HG1 VAL   143      -9.552  -8.129  12.505  1.00 36.29           H 
ATOM   2312 2HG1 VAL   143     -11.158  -7.908  11.812  1.00 36.29           H 
ATOM   2313 3HG1 VAL   143      -9.726  -7.516  10.859  1.00 36.29           H 
ATOM   2314 1HG2 VAL   143     -10.646  -9.098   9.053  1.00 36.29           H 
ATOM   2315 2HG2 VAL   143     -12.017  -9.455  10.104  1.00 36.29           H 
ATOM   2316 3HG2 VAL   143     -11.011 -10.768   9.497  1.00 36.29           H 
END
