
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   75 ( 1111),  selected   75 , name 2gcx_A
# Molecule2: number of CA atoms   74 ( 1189),  selected   74 , name T0462_1_74.pdb
# PARAMETERS: 2gcx_A.T0462_1_74.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      M       1           #
LGA    -       -      K       2           -
LGA    -       -      L       3           -
LGA    -       -      S       4           -
LGA    Q     2_A      R       5          3.951
LGA    F     3_A      L       6          2.179
LGA    T     4_A      V       7          2.449
LGA    P     5_A      P       8          1.583
LGA    D     6_A      G       9          1.667
LGA    S     7_A      V      10          1.250
LGA    A     8_A      P      11          1.302
LGA    W     9_A      A      12          1.423
LGA    K    10_A      R      13          1.901
LGA    I    11_A      I      14          2.516
LGA    T    12_A      K      15          3.432
LGA    G    13_A      R      16          4.243
LGA    F    14_A      L      17          1.878
LGA    S    15_A      E      18          1.177
LGA    R    16_A      -       -           -
LGA    D    17_A      -       -           -
LGA    I    18_A      V      19          1.334
LGA    S    19_A      S      20          3.549
LGA    P    20_A      G      21          1.660
LGA    A    21_A      E      22          1.829
LGA    Y    22_A      L      23          2.006
LGA    R    23_A      H      24          1.132
LGA    Q    24_A      E      25          1.500
LGA    K    25_A      K      26          2.120
LGA    L    26_A      L      27          2.870
LGA    L    27_A      V      28          2.895
LGA    S    28_A      G      29          2.757
LGA    L    29_A      M      30          4.369
LGA    G    30_A      G      31          4.905
LGA    M    31_A      F      32          3.991
LGA    L    32_A      V      33          1.566
LGA    P    33_A      P      34          1.200
LGA    G    34_A      G      35          1.910
LGA    S    35_A      E      36          0.883
LGA    S    36_A      E      37          0.315
LGA    F    37_A      I      38          1.426
LGA    H    38_A      E      39          1.222
LGA    V    39_A      I      40          0.661
LGA    V    40_A      V      41          1.306
LGA    R    41_A      Q      42          1.312
LGA    V    42_A      V      43          2.433
LGA    -       -      A      44           -
LGA    A    43_A      P      45          5.028
LGA    P    44_A      -       -           -
LGA    L    45_A      L      46          6.157
LGA    G    46_A      G      47          2.198
LGA    D    47_A      D      48          1.562
LGA    P    48_A      P      49          1.026
LGA    V    49_A      I      50          0.619
LGA    H    50_A      V      51          1.132
LGA    I    51_A      C      52          1.243
LGA    E    52_A      K      53          0.692
LGA    T    53_A      I      54          1.716
LGA    R    54_A      G      55          1.684
LGA    R    55_A      N      56          2.789
LGA    V    56_A      R      57          1.721
LGA    S    57_A      N      58          1.478
LGA    L    58_A      I      59          1.032
LGA    V    59_A      T      60          1.108
LGA    L    60_A      L      61          0.971
LGA    R    61_A      R      62          1.516
LGA    K    62_A      K      63          2.166
LGA    K    63_A      R      64          2.568
LGA    D    64_A      E      65          1.955
LGA    L    65_A      A      66          1.287
LGA    A    66_A      D      67          1.309
LGA    L    67_A      L      68          1.518
LGA    I    68_A      I      69          1.612
LGA    E    69_A      E      70          1.112
LGA    L    70_A      V      71          1.478
LGA    E    71_A      E      72          1.212
LGA    A    72_A      V      73          1.032
LGA    V    73_A      V      74          0.709
LGA    A    74_A      -       -           -
LGA    Q    75_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   75   74    5.0     69    2.25    31.88     70.037     2.940

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.148213 * X  +  -0.944808 * Y  +   0.292184 * Z  +  10.227261
  Y_new =  -0.447100 * X  +   0.199516 * Y  +   0.871949 * Z  +   0.184540
  Z_new =  -0.882119 * X  +  -0.259870 * Y  +  -0.392853 * Z  +   0.537718 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.557180    0.584412  [ DEG:  -146.5156     33.4844 ]
  Theta =   1.080343    2.061250  [ DEG:    61.8991    118.1009 ]
  Phi   =  -1.250699    1.890894  [ DEG:   -71.6598    108.3402 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2gcx_A                                        
REMARK     2: T0462_1_74.pdb                                
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2gcx_A.T0462_1_74.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   75   74   5.0   69   2.25   31.88  70.037
REMARK  ---------------------------------------------------------- 
MOLECULE 2gcx_A
HEADER    TRANSPORT PROTEIN                       14-MAR-06   2GCX              
TITLE     SOLUTION STRUCTURE OF FERROUS IRON TRANSPORT PROTEIN A                
TITLE    2 (FEOA) OF KLEBSIELLA PNEUMONIAE                                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: FERROUS IRON TRANSPORT PROTEIN A;                          
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: FEOA;                                                       
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: KLEBSIELLA PNEUMONIAE;                          
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET-22B(+)                                
KEYWDS    KLEBSIELLA PNEUMONIAE, FEOA, FERROUS IRON TRANSPORT PROTEIN           
KEYWDS   2 A, NMR                                                               
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    K.-W.HUNG,C.-C.CHENG,T.-H.YU,S.-H.WANG,C.-F.CHANG,S.-F.TSAI,          
AUTHOR   2 T.-H.HUANG                                                           
REVDAT   1   20-MAR-07 2GCX    0                                                
JRNL        AUTH   K.-W.HUNG,C.-C.CHENG,T.-H.YU,S.-H.WANG,C.-F.CHANG,           
JRNL        AUTH 2 S.-F.TSAI,T.-H.HUANG                                         
JRNL        TITL   SOLUTION STRUCTURE OF FERROUS IRON TRANSPORT                 
JRNL        TITL 2 PROTEIN A (FEOA) OF KLEBSIELLA PNEUMONIAE                    
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
SEQRES   1 A   75  MET GLN PHE THR PRO ASP SER ALA TRP LYS ILE THR GLY          
SEQRES   2 A   75  PHE SER ARG ASP ILE SER PRO ALA TYR ARG GLN LYS LEU          
SEQRES   3 A   75  LEU SER LEU GLY MET LEU PRO GLY SER SER PHE HIS VAL          
SEQRES   4 A   75  VAL ARG VAL ALA PRO LEU GLY ASP PRO VAL HIS ILE GLU          
SEQRES   5 A   75  THR ARG ARG VAL SER LEU VAL LEU ARG LYS LYS ASP LEU          
SEQRES   6 A   75  ALA LEU ILE GLU LEU GLU ALA VAL ALA GLN                      
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1      -3.760  -0.386  -0.538  1.00  3.33           N  
ATOM      2  CA  MET A   1      -3.295  -1.178  -1.706  1.00  2.78           C  
ATOM      3  C   MET A   1      -2.222  -0.424  -2.484  1.00  2.08           C  
ATOM      4  O   MET A   1      -1.200  -0.997  -2.864  1.00  2.36           O  
ATOM      5  CB  MET A   1      -4.474  -1.498  -2.627  1.00  2.93           C  
ATOM      6  CG  MET A   1      -4.089  -2.322  -3.845  1.00  3.53           C  
ATOM      7  SD  MET A   1      -3.471  -3.959  -3.408  1.00  4.37           S  
ATOM      8  CE  MET A   1      -3.073  -4.615  -5.028  1.00  5.17           C  
ATOM      9  H2  MET A   1      -2.954  -0.144   0.073  1.00  3.82           H  
ATOM     10  HA  MET A   1      -2.871  -2.104  -1.340  1.00  3.41           H  
ATOM     11  HB2 MET A   1      -5.216  -2.048  -2.067  1.00  2.98           H  
ATOM     12  HG2 MET A   1      -4.958  -2.438  -4.476  1.00  3.81           H  
ATOM     13  HE1 MET A   1      -3.966  -4.641  -5.635  1.00  5.58           H  
ATOM     14  HE2 MET A   1      -2.335  -3.987  -5.499  1.00  5.32           H  
ATOM     15  HE3 MET A   1      -2.679  -5.616  -4.922  1.00  5.50           H  
ATOM     16  H1  MET A   1      -4.213   0.491  -0.859  1.00  3.63           H  
ATOM     17  H3  MET A   1      -4.447  -0.936   0.016  1.00  3.53           H  
ATOM     18  N   GLN A   2      -2.461   0.862  -2.720  1.00  1.56           N  
ATOM     19  CA  GLN A   2      -1.516   1.690  -3.457  1.00  0.99           C  
ATOM     20  C   GLN A   2      -0.452   2.265  -2.527  1.00  0.83           C  
ATOM     21  O   GLN A   2      -0.612   2.264  -1.307  1.00  1.25           O  
ATOM     22  CB  GLN A   2      -2.253   2.826  -4.169  1.00  1.05           C  
ATOM     23  CG  GLN A   2      -3.386   2.347  -5.056  1.00  1.64           C  
ATOM     24  CD  GLN A   2      -4.229   3.487  -5.595  1.00  2.33           C  
ATOM     25  OE1 GLN A   2      -3.734   4.595  -5.804  1.00  2.91           O  
ATOM     26  NE2 GLN A   2      -5.509   3.219  -5.826  1.00  2.94           N  
ATOM     27  H   GLN A   2      -3.292   1.261  -2.391  1.00  1.91           H  
ATOM     28  HA  GLN A   2      -1.034   1.068  -4.195  1.00  1.23           H  
ATOM     29  HB2 GLN A   2      -2.660   3.498  -3.429  1.00  1.72           H  
ATOM     30  HG2 GLN A   2      -2.964   1.809  -5.888  1.00  2.05           H  
ATOM     31 HE21 GLN A   2      -5.834   2.313  -5.636  1.00  3.09           H  
ATOM     32 HE22 GLN A   2      -6.077   3.937  -6.176  1.00  3.52           H  
ATOM     33  N   PHE A   3       0.636   2.754  -3.115  1.00  0.64           N  
ATOM     34  CA  PHE A   3       1.729   3.333  -2.344  1.00  0.59           C  
ATOM     35  C   PHE A   3       1.818   4.839  -2.575  1.00  0.50           C  
ATOM     36  O   PHE A   3       2.176   5.288  -3.663  1.00  0.55           O  
ATOM     37  CB  PHE A   3       3.054   2.667  -2.720  1.00  0.80           C  
ATOM     38  CG  PHE A   3       3.085   1.190  -2.447  1.00  0.75           C  
ATOM     39  CD1 PHE A   3       2.678   0.283  -3.412  1.00  0.80           C  
ATOM     40  CD2 PHE A   3       3.525   0.708  -1.224  1.00  1.47           C  
ATOM     41  CE1 PHE A   3       2.707  -1.075  -3.163  1.00  1.39           C  
ATOM     42  CE2 PHE A   3       3.556  -0.650  -0.969  1.00  2.25           C  
ATOM     43  CZ  PHE A   3       3.145  -1.543  -1.940  1.00  2.18           C  
ATOM     44  H   PHE A   3       0.705   2.723  -4.094  1.00  0.92           H  
ATOM     45  HA  PHE A   3       1.529   3.152  -1.298  1.00  0.71           H  
ATOM     46  HB2 PHE A   3       3.236   2.814  -3.775  1.00  1.45           H  
ATOM     47  HD1 PHE A   3       2.333   0.649  -4.369  1.00  0.91           H  
ATOM     48  HD2 PHE A   3       3.844   1.405  -0.464  1.00  1.57           H  
ATOM     49  HE1 PHE A   3       2.387  -1.771  -3.924  1.00  1.42           H  
ATOM     50  HE2 PHE A   3       3.899  -1.013  -0.011  1.00  2.96           H  
ATOM     51  HZ  PHE A   3       3.169  -2.605  -1.743  1.00  2.81           H  
ATOM     52  N   THR A   4       1.486   5.610  -1.544  1.00  0.53           N  
ATOM     53  CA  THR A   4       1.528   7.064  -1.636  1.00  0.49           C  
ATOM     54  C   THR A   4       2.678   7.643  -0.817  1.00  0.45           C  
ATOM     55  O   THR A   4       3.076   7.070   0.198  1.00  0.45           O  
ATOM     56  CB  THR A   4       0.208   7.697  -1.161  1.00  0.57           C  
ATOM     57  OG1 THR A   4      -0.151   7.174   0.125  1.00  0.61           O  
ATOM     58  CG2 THR A   4      -0.908   7.425  -2.158  1.00  0.66           C  
ATOM     59  H   THR A   4       1.205   5.192  -0.705  1.00  0.66           H  
ATOM     60  HA  THR A   4       1.673   7.330  -2.674  1.00  0.50           H  
ATOM     61  HB  THR A   4       0.345   8.765  -1.080  1.00  0.57           H  
ATOM     62  HG1 THR A   4      -1.065   7.396   0.319  1.00  1.09           H  
ATOM     63 HG21 THR A   4      -1.828   7.864  -1.798  1.00  1.23           H  
ATOM     64 HG22 THR A   4      -1.038   6.360  -2.271  1.00  1.30           H  
ATOM     65 HG23 THR A   4      -0.652   7.862  -3.111  1.00  1.11           H  
ATOM     66  N   PRO A   5       3.226   8.793  -1.249  1.00  0.47           N  
ATOM     67  CA  PRO A   5       4.332   9.449  -0.552  1.00  0.51           C  
ATOM     68  C   PRO A   5       3.895  10.079   0.767  1.00  0.51           C  
ATOM     69  O   PRO A   5       3.569  11.263   0.824  1.00  0.65           O  
ATOM     70  CB  PRO A   5       4.780  10.530  -1.540  1.00  0.62           C  
ATOM     71  CG  PRO A   5       3.565  10.832  -2.345  1.00  0.58           C  
ATOM     72  CD  PRO A   5       2.808   9.537  -2.454  1.00  0.53           C  
ATOM     73  HA  PRO A   5       5.148   8.765  -0.370  1.00  0.60           H  
ATOM     74  HB2 PRO A   5       5.125  11.398  -0.997  1.00  0.77           H  
ATOM     75  HG2 PRO A   5       2.965  11.576  -1.841  1.00  0.73           H  
ATOM     76  HD2 PRO A   5       1.744   9.721  -2.444  1.00  0.56           H  
ATOM     77  N   ASP A   6       3.888   9.272   1.824  1.00  0.74           N  
ATOM     78  CA  ASP A   6       3.494   9.743   3.148  1.00  0.84           C  
ATOM     79  C   ASP A   6       3.519   8.604   4.160  1.00  0.71           C  
ATOM     80  O   ASP A   6       3.935   8.789   5.305  1.00  0.67           O  
ATOM     81  CB  ASP A   6       2.092  10.359   3.098  1.00  1.07           C  
ATOM     82  CG  ASP A   6       1.049   9.384   2.588  1.00  2.06           C  
ATOM     83  OD1 ASP A   6       0.842   9.323   1.359  1.00  2.69           O  
ATOM     84  OD2 ASP A   6       0.442   8.678   3.420  1.00  2.51           O  
ATOM     85  H   ASP A   6       4.153   8.335   1.712  1.00  0.97           H  
ATOM     86  HA  ASP A   6       4.200  10.499   3.454  1.00  0.95           H  
ATOM     87  HB2 ASP A   6       1.810  10.672   4.090  1.00  1.14           H  
ATOM     88  N   SER A   7       3.072   7.429   3.735  1.00  0.77           N  
ATOM     89  CA  SER A   7       3.044   6.261   4.607  1.00  0.72           C  
ATOM     90  C   SER A   7       4.393   5.547   4.607  1.00  0.54           C  
ATOM     91  O   SER A   7       5.229   5.779   3.734  1.00  0.67           O  
ATOM     92  CB  SER A   7       1.940   5.298   4.167  1.00  0.96           C  
ATOM     93  OG  SER A   7       1.908   4.148   4.993  1.00  1.89           O  
ATOM     94  H   SER A   7       2.752   7.345   2.812  1.00  0.90           H  
ATOM     95  HA  SER A   7       2.832   6.601   5.610  1.00  0.72           H  
ATOM     96  HB2 SER A   7       0.985   5.797   4.227  1.00  1.05           H  
ATOM     97  HG  SER A   7       2.117   3.371   4.469  1.00  2.32           H  
ATOM     98  N   ALA A   8       4.596   4.676   5.590  1.00  0.47           N  
ATOM     99  CA  ALA A   8       5.846   3.930   5.706  1.00  0.35           C  
ATOM    100  C   ALA A   8       5.672   2.487   5.243  1.00  0.31           C  
ATOM    101  O   ALA A   8       4.550   2.003   5.090  1.00  0.38           O  
ATOM    102  CB  ALA A   8       6.349   3.969   7.142  1.00  0.44           C  
ATOM    103  H   ALA A   8       3.889   4.531   6.254  1.00  0.66           H  
ATOM    104  HA  ALA A   8       6.579   4.413   5.079  1.00  0.35           H  
ATOM    105  HB1 ALA A   8       5.670   3.419   7.777  1.00  1.16           H  
ATOM    106  HB2 ALA A   8       7.330   3.518   7.190  1.00  1.04           H  
ATOM    107  HB3 ALA A   8       6.405   4.993   7.476  1.00  1.13           H  
ATOM    108  N   TRP A   9       6.792   1.804   5.020  1.00  0.30           N  
ATOM    109  CA  TRP A   9       6.769   0.413   4.575  1.00  0.30           C  
ATOM    110  C   TRP A   9       8.056  -0.305   4.971  1.00  0.32           C  
ATOM    111  O   TRP A   9       8.984   0.311   5.496  1.00  0.39           O  
ATOM    112  CB  TRP A   9       6.581   0.345   3.059  1.00  0.34           C  
ATOM    113  CG  TRP A   9       5.378   1.097   2.575  1.00  0.35           C  
ATOM    114  CD1 TRP A   9       5.316   2.423   2.259  1.00  0.40           C  
ATOM    115  CD2 TRP A   9       4.066   0.568   2.352  1.00  0.42           C  
ATOM    116  NE1 TRP A   9       4.045   2.750   1.852  1.00  0.41           N  
ATOM    117  CE2 TRP A   9       3.259   1.630   1.900  1.00  0.42           C  
ATOM    118  CE3 TRP A   9       3.493  -0.700   2.489  1.00  0.56           C  
ATOM    119  CZ2 TRP A   9       1.912   1.462   1.588  1.00  0.52           C  
ATOM    120  CZ3 TRP A   9       2.157  -0.866   2.178  1.00  0.69           C  
ATOM    121  CH2 TRP A   9       1.380   0.210   1.731  1.00  0.66           C  
ATOM    122  H   TRP A   9       7.656   2.245   5.159  1.00  0.34           H  
ATOM    123  HA  TRP A   9       5.933  -0.076   5.055  1.00  0.31           H  
ATOM    124  HB2 TRP A   9       7.451   0.763   2.576  1.00  0.36           H  
ATOM    125  HD1 TRP A   9       6.151   3.103   2.323  1.00  0.49           H  
ATOM    126  HE1 TRP A   9       3.750   3.643   1.573  1.00  0.47           H  
ATOM    127  HE3 TRP A   9       4.077  -1.542   2.833  1.00  0.60           H  
ATOM    128  HZ2 TRP A   9       1.300   2.280   1.242  1.00  0.54           H  
ATOM    129  HZ3 TRP A   9       1.697  -1.839   2.279  1.00  0.84           H  
ATOM    130  HH2 TRP A   9       0.340   0.035   1.499  1.00  0.77           H  
ATOM    131  N   LYS A  10       8.106  -1.610   4.718  1.00  0.34           N  
ATOM    132  CA  LYS A  10       9.281  -2.407   5.048  1.00  0.37           C  
ATOM    133  C   LYS A  10       9.762  -3.201   3.836  1.00  0.34           C  
ATOM    134  O   LYS A  10       8.964  -3.821   3.132  1.00  0.34           O  
ATOM    135  CB  LYS A  10       8.973  -3.356   6.208  1.00  0.43           C  
ATOM    136  CG  LYS A  10       8.601  -2.637   7.496  1.00  1.01           C  
ATOM    137  CD  LYS A  10       8.200  -3.617   8.586  1.00  1.03           C  
ATOM    138  CE  LYS A  10       7.883  -2.898   9.888  1.00  1.28           C  
ATOM    139  NZ  LYS A  10       7.432  -3.842  10.948  1.00  2.04           N  
ATOM    140  H   LYS A  10       7.334  -2.046   4.301  1.00  0.40           H  
ATOM    141  HA  LYS A  10      10.065  -1.728   5.350  1.00  0.42           H  
ATOM    142  HB2 LYS A  10       8.150  -3.995   5.926  1.00  0.74           H  
ATOM    143  HG2 LYS A  10       9.451  -2.065   7.833  1.00  1.60           H  
ATOM    144  HD2 LYS A  10       7.326  -4.162   8.265  1.00  1.63           H  
ATOM    145  HE2 LYS A  10       8.770  -2.386  10.227  1.00  1.73           H  
ATOM    146  HZ1 LYS A  10       6.556  -4.319  10.654  1.00  2.50           H  
ATOM    147  HZ2 LYS A  10       7.253  -3.326  11.833  1.00  2.52           H  
ATOM    148  HZ3 LYS A  10       8.164  -4.560  11.122  1.00  2.42           H  
ATOM    149  N   ILE A  11      11.071  -3.179   3.599  1.00  0.36           N  
ATOM    150  CA  ILE A  11      11.658  -3.890   2.473  1.00  0.36           C  
ATOM    151  C   ILE A  11      11.699  -5.393   2.726  1.00  0.32           C  
ATOM    152  O   ILE A  11      12.226  -5.850   3.741  1.00  0.38           O  
ATOM    153  CB  ILE A  11      13.086  -3.392   2.177  1.00  0.41           C  
ATOM    154  CG1 ILE A  11      13.077  -1.883   1.917  1.00  0.48           C  
ATOM    155  CG2 ILE A  11      13.677  -4.134   0.986  1.00  0.43           C  
ATOM    156  CD1 ILE A  11      14.443  -1.315   1.600  1.00  0.56           C  
ATOM    157  H   ILE A  11      11.655  -2.673   4.200  1.00  0.39           H  
ATOM    158  HA  ILE A  11      11.047  -3.699   1.603  1.00  0.38           H  
ATOM    159  HB  ILE A  11      13.702  -3.596   3.039  1.00  0.41           H  
ATOM    160 HG12 ILE A  11      12.429  -1.672   1.080  1.00  0.50           H  
ATOM    161 HG21 ILE A  11      14.675  -3.769   0.793  1.00  1.11           H  
ATOM    162 HG22 ILE A  11      13.715  -5.191   1.206  1.00  0.98           H  
ATOM    163 HG23 ILE A  11      13.057  -3.970   0.117  1.00  1.04           H  
ATOM    164 HD11 ILE A  11      14.843  -1.802   0.724  1.00  1.01           H  
ATOM    165 HD12 ILE A  11      14.356  -0.254   1.415  1.00  1.20           H  
ATOM    166 HD13 ILE A  11      15.105  -1.480   2.439  1.00  1.21           H  
ATOM    167  N   THR A  12      11.136  -6.153   1.791  1.00  0.28           N  
ATOM    168  CA  THR A  12      11.103  -7.606   1.896  1.00  0.27           C  
ATOM    169  C   THR A  12      11.370  -8.247   0.538  1.00  0.27           C  
ATOM    170  O   THR A  12      10.648  -9.142   0.103  1.00  0.30           O  
ATOM    171  CB  THR A  12       9.744  -8.094   2.434  1.00  0.30           C  
ATOM    172  OG1 THR A  12       9.373  -7.334   3.589  1.00  0.91           O  
ATOM    173  CG2 THR A  12       9.801  -9.573   2.797  1.00  0.97           C  
ATOM    174  H   THR A  12      10.733  -5.723   1.008  1.00  0.31           H  
ATOM    175  HA  THR A  12      11.875  -7.909   2.587  1.00  0.27           H  
ATOM    176  HB  THR A  12       8.998  -7.956   1.665  1.00  0.71           H  
ATOM    177  HG1 THR A  12       8.994  -6.495   3.313  1.00  1.25           H  
ATOM    178 HG21 THR A  12      10.594  -9.736   3.509  1.00  1.46           H  
ATOM    179 HG22 THR A  12       9.988 -10.155   1.908  1.00  1.48           H  
ATOM    180 HG23 THR A  12       8.859  -9.871   3.231  1.00  1.64           H  
ATOM    181  N   GLY A  13      12.416  -7.773  -0.132  1.00  0.29           N  
ATOM    182  CA  GLY A  13      12.769  -8.305  -1.437  1.00  0.33           C  
ATOM    183  C   GLY A  13      12.865  -9.817  -1.451  1.00  0.37           C  
ATOM    184  O   GLY A  13      13.923 -10.383  -1.170  1.00  0.45           O  
ATOM    185  H   GLY A  13      12.948  -7.053   0.263  1.00  0.31           H  
ATOM    186  HA2 GLY A  13      12.022  -7.996  -2.153  1.00  0.31           H  
ATOM    187  HA3 GLY A  13      13.723  -7.893  -1.731  1.00  0.39           H  
ATOM    188  N   PHE A  14      11.758 -10.475  -1.776  1.00  0.34           N  
ATOM    189  CA  PHE A  14      11.718 -11.932  -1.833  1.00  0.41           C  
ATOM    190  C   PHE A  14      10.753 -12.405  -2.914  1.00  0.39           C  
ATOM    191  O   PHE A  14       9.543 -12.476  -2.690  1.00  0.43           O  
ATOM    192  CB  PHE A  14      11.309 -12.508  -0.476  1.00  0.50           C  
ATOM    193  CG  PHE A  14      11.197 -14.004  -0.470  1.00  0.60           C  
ATOM    194  CD1 PHE A  14      10.000 -14.625  -0.788  1.00  0.69           C  
ATOM    195  CD2 PHE A  14      12.289 -14.793  -0.141  1.00  0.70           C  
ATOM    196  CE1 PHE A  14       9.896 -16.004  -0.784  1.00  0.79           C  
ATOM    197  CE2 PHE A  14      12.191 -16.170  -0.136  1.00  0.81           C  
ATOM    198  CZ  PHE A  14      10.992 -16.777  -0.455  1.00  0.81           C  
ATOM    199  H   PHE A  14      10.946  -9.969  -1.986  1.00  0.30           H  
ATOM    200  HA  PHE A  14      12.711 -12.281  -2.077  1.00  0.45           H  
ATOM    201  HB2 PHE A  14      12.044 -12.225   0.263  1.00  0.53           H  
ATOM    202  HD1 PHE A  14       9.142 -14.023  -1.046  1.00  0.75           H  
ATOM    203  HD2 PHE A  14      13.228 -14.319   0.109  1.00  0.77           H  
ATOM    204  HE1 PHE A  14       8.957 -16.476  -1.035  1.00  0.91           H  
ATOM    205  HE2 PHE A  14      13.050 -16.773   0.122  1.00  0.93           H  
ATOM    206  HZ  PHE A  14      10.913 -17.855  -0.451  1.00  0.90           H  
ATOM    207  N   SER A  15      11.290 -12.720  -4.089  1.00  0.40           N  
ATOM    208  CA  SER A  15      10.469 -13.184  -5.201  1.00  0.41           C  
ATOM    209  C   SER A  15      10.643 -14.684  -5.413  1.00  0.43           C  
ATOM    210  O   SER A  15      11.334 -15.355  -4.647  1.00  0.48           O  
ATOM    211  CB  SER A  15      10.836 -12.434  -6.482  1.00  0.39           C  
ATOM    212  OG  SER A  15      10.827 -11.033  -6.274  1.00  0.76           O  
ATOM    213  H   SER A  15      12.257 -12.638  -4.211  1.00  0.43           H  
ATOM    214  HA  SER A  15       9.436 -12.984  -4.959  1.00  0.45           H  
ATOM    215  HB2 SER A  15      11.823 -12.732  -6.799  1.00  0.73           H  
ATOM    216  HG  SER A  15      11.511 -10.798  -5.641  1.00  1.26           H  
ATOM    217  N   ARG A  16      10.008 -15.204  -6.458  1.00  0.57           N  
ATOM    218  CA  ARG A  16      10.093 -16.625  -6.775  1.00  0.61           C  
ATOM    219  C   ARG A  16      11.317 -16.921  -7.638  1.00  0.59           C  
ATOM    220  O   ARG A  16      11.792 -18.056  -7.686  1.00  0.63           O  
ATOM    221  CB  ARG A  16       8.827 -17.088  -7.498  1.00  0.69           C  
ATOM    222  CG  ARG A  16       7.553 -16.917  -6.685  1.00  1.14           C  
ATOM    223  CD  ARG A  16       7.165 -15.454  -6.550  1.00  1.37           C  
ATOM    224  NE  ARG A  16       5.790 -15.297  -6.080  1.00  2.19           N  
ATOM    225  CZ  ARG A  16       5.233 -14.120  -5.819  1.00  2.67           C  
ATOM    226  NH1 ARG A  16       5.932 -13.004  -5.970  1.00  2.41           N  
ATOM    227  NH2 ARG A  16       3.974 -14.058  -5.403  1.00  3.58           N  
ATOM    228  H   ARG A  16       9.470 -14.619  -7.031  1.00  0.72           H  
ATOM    229  HA  ARG A  16      10.184 -17.166  -5.846  1.00  0.65           H  
ATOM    230  HB2 ARG A  16       8.721 -16.520  -8.412  1.00  1.39           H  
ATOM    231  HG2 ARG A  16       6.751 -17.448  -7.176  1.00  1.69           H  
ATOM    232  HD2 ARG A  16       7.829 -14.980  -5.843  1.00  1.50           H  
ATOM    233  HE  ARG A  16       5.257 -16.109  -5.958  1.00  2.55           H  
ATOM    234 HH11 ARG A  16       6.881 -13.048  -6.283  1.00  1.97           H  
ATOM    235 HH12 ARG A  16       5.511 -12.120  -5.774  1.00  2.83           H  
ATOM    236 HH21 ARG A  16       3.445 -14.899  -5.286  1.00  3.94           H  
ATOM    237 HH22 ARG A  16       3.555 -13.172  -5.208  1.00  3.96           H  
ATOM    238  N   ASP A  17      11.824 -15.897  -8.318  1.00  0.58           N  
ATOM    239  CA  ASP A  17      12.990 -16.058  -9.182  1.00  0.63           C  
ATOM    240  C   ASP A  17      13.839 -14.790  -9.204  1.00  0.57           C  
ATOM    241  O   ASP A  17      14.528 -14.513 -10.184  1.00  0.62           O  
ATOM    242  CB  ASP A  17      12.545 -16.409 -10.603  1.00  0.77           C  
ATOM    243  CG  ASP A  17      11.629 -15.358 -11.200  1.00  1.61           C  
ATOM    244  OD1 ASP A  17      10.398 -15.474 -11.022  1.00  2.48           O  
ATOM    245  OD2 ASP A  17      12.143 -14.418 -11.844  1.00  1.86           O  
ATOM    246  H   ASP A  17      11.406 -15.015  -8.242  1.00  0.56           H  
ATOM    247  HA  ASP A  17      13.584 -16.871  -8.790  1.00  0.66           H  
ATOM    248  HB2 ASP A  17      13.415 -16.500 -11.234  1.00  1.47           H  
ATOM    249  N   ILE A  18      13.793 -14.029  -8.113  1.00  0.51           N  
ATOM    250  CA  ILE A  18      14.559 -12.789  -8.011  1.00  0.50           C  
ATOM    251  C   ILE A  18      15.999 -12.984  -8.480  1.00  0.50           C  
ATOM    252  O   ILE A  18      16.724 -13.830  -7.957  1.00  0.57           O  
ATOM    253  CB  ILE A  18      14.576 -12.255  -6.565  1.00  0.48           C  
ATOM    254  CG1 ILE A  18      15.345 -10.935  -6.495  1.00  0.52           C  
ATOM    255  CG2 ILE A  18      15.190 -13.282  -5.628  1.00  0.47           C  
ATOM    256  CD1 ILE A  18      15.316 -10.293  -5.126  1.00  0.56           C  
ATOM    257  H   ILE A  18      13.228 -14.303  -7.361  1.00  0.50           H  
ATOM    258  HA  ILE A  18      14.084 -12.051  -8.638  1.00  0.56           H  
ATOM    259  HB  ILE A  18      13.557 -12.086  -6.255  1.00  0.53           H  
ATOM    260 HG12 ILE A  18      16.378 -11.112  -6.758  1.00  0.51           H  
ATOM    261 HG21 ILE A  18      15.090 -12.945  -4.607  1.00  1.10           H  
ATOM    262 HG22 ILE A  18      14.680 -14.227  -5.745  1.00  1.06           H  
ATOM    263 HG23 ILE A  18      16.236 -13.407  -5.865  1.00  1.17           H  
ATOM    264 HD11 ILE A  18      14.295 -10.071  -4.854  1.00  1.15           H  
ATOM    265 HD12 ILE A  18      15.743 -10.971  -4.402  1.00  1.11           H  
ATOM    266 HD13 ILE A  18      15.889  -9.377  -5.144  1.00  1.13           H  
ATOM    267  N   SER A  19      16.404 -12.195  -9.470  1.00  0.57           N  
ATOM    268  CA  SER A  19      17.756 -12.280 -10.013  1.00  0.59           C  
ATOM    269  C   SER A  19      18.773 -11.700  -9.037  1.00  0.52           C  
ATOM    270  O   SER A  19      18.435 -10.864  -8.199  1.00  0.50           O  
ATOM    271  CB  SER A  19      17.836 -11.544 -11.350  1.00  0.70           C  
ATOM    272  OG  SER A  19      17.504 -10.173 -11.199  1.00  1.50           O  
ATOM    273  H   SER A  19      15.779 -11.538  -9.844  1.00  0.68           H  
ATOM    274  HA  SER A  19      17.983 -13.323 -10.173  1.00  0.59           H  
ATOM    275  HB2 SER A  19      18.841 -11.616 -11.740  1.00  1.12           H  
ATOM    276  HG  SER A  19      17.996  -9.651 -11.838  1.00  2.01           H  
ATOM    277  N   PRO A  20      20.041 -12.140  -9.134  1.00  0.54           N  
ATOM    278  CA  PRO A  20      21.111 -11.659  -8.254  1.00  0.51           C  
ATOM    279  C   PRO A  20      21.428 -10.188  -8.483  1.00  0.53           C  
ATOM    280  O   PRO A  20      21.881  -9.492  -7.576  1.00  0.51           O  
ATOM    281  CB  PRO A  20      22.311 -12.531  -8.635  1.00  0.55           C  
ATOM    282  CG  PRO A  20      22.022 -12.996 -10.020  1.00  0.61           C  
ATOM    283  CD  PRO A  20      20.528 -13.133 -10.108  1.00  0.61           C  
ATOM    284  HA  PRO A  20      20.865 -11.815  -7.213  1.00  0.49           H  
ATOM    285  HB2 PRO A  20      23.215 -11.940  -8.595  1.00  0.56           H  
ATOM    286  HG2 PRO A  20      22.375 -12.266 -10.734  1.00  0.64           H  
ATOM    287  HD2 PRO A  20      20.186 -12.896 -11.105  1.00  0.68           H  
ATOM    288  N   ALA A  21      21.187  -9.714  -9.700  1.00  0.58           N  
ATOM    289  CA  ALA A  21      21.444  -8.319 -10.037  1.00  0.64           C  
ATOM    290  C   ALA A  21      20.804  -7.386  -9.014  1.00  0.62           C  
ATOM    291  O   ALA A  21      21.424  -6.429  -8.557  1.00  0.65           O  
ATOM    292  CB  ALA A  21      20.927  -8.009 -11.434  1.00  0.71           C  
ATOM    293  H   ALA A  21      20.831 -10.317 -10.386  1.00  0.61           H  
ATOM    294  HA  ALA A  21      22.513  -8.166 -10.031  1.00  0.66           H  
ATOM    295  HB1 ALA A  21      21.427  -8.642 -12.152  1.00  1.32           H  
ATOM    296  HB2 ALA A  21      19.863  -8.193 -11.472  1.00  1.13           H  
ATOM    297  HB3 ALA A  21      21.124  -6.973 -11.669  1.00  1.30           H  
ATOM    298  N   TYR A  22      19.556  -7.678  -8.661  1.00  0.60           N  
ATOM    299  CA  TYR A  22      18.827  -6.871  -7.689  1.00  0.61           C  
ATOM    300  C   TYR A  22      19.124  -7.327  -6.263  1.00  0.54           C  
ATOM    301  O   TYR A  22      19.221  -6.509  -5.347  1.00  0.57           O  
ATOM    302  CB  TYR A  22      17.323  -6.948  -7.955  1.00  0.66           C  
ATOM    303  CG  TYR A  22      16.912  -6.384  -9.295  1.00  0.90           C  
ATOM    304  CD1 TYR A  22      16.779  -5.013  -9.479  1.00  0.99           C  
ATOM    305  CD2 TYR A  22      16.661  -7.221 -10.375  1.00  1.28           C  
ATOM    306  CE1 TYR A  22      16.403  -4.493 -10.703  1.00  1.34           C  
ATOM    307  CE2 TYR A  22      16.285  -6.706 -11.602  1.00  1.72           C  
ATOM    308  CZ  TYR A  22      16.158  -5.342 -11.760  1.00  1.72           C  
ATOM    309  OH  TYR A  22      15.783  -4.827 -12.980  1.00  2.17           O  
ATOM    310  H   TYR A  22      19.114  -8.453  -9.065  1.00  0.60           H  
ATOM    311  HA  TYR A  22      19.149  -5.848  -7.801  1.00  0.66           H  
ATOM    312  HB2 TYR A  22      17.012  -7.982  -7.923  1.00  0.78           H  
ATOM    313  HD1 TYR A  22      16.973  -4.351  -8.650  1.00  0.96           H  
ATOM    314  HD2 TYR A  22      16.762  -8.287 -10.249  1.00  1.30           H  
ATOM    315  HE1 TYR A  22      16.304  -3.424 -10.827  1.00  1.41           H  
ATOM    316  HE2 TYR A  22      16.093  -7.372 -12.431  1.00  2.11           H  
ATOM    317  HH  TYR A  22      16.319  -4.057 -13.181  1.00  2.53           H  
ATOM    318  N   ARG A  23      19.264  -8.637  -6.081  1.00  0.48           N  
ATOM    319  CA  ARG A  23      19.540  -9.200  -4.763  1.00  0.44           C  
ATOM    320  C   ARG A  23      20.958  -8.870  -4.303  1.00  0.45           C  
ATOM    321  O   ARG A  23      21.152  -8.204  -3.285  1.00  0.45           O  
ATOM    322  CB  ARG A  23      19.347 -10.717  -4.788  1.00  0.45           C  
ATOM    323  CG  ARG A  23      19.596 -11.384  -3.446  1.00  0.54           C  
ATOM    324  CD  ARG A  23      18.584 -10.935  -2.406  1.00  0.53           C  
ATOM    325  NE  ARG A  23      18.810 -11.568  -1.110  1.00  0.70           N  
ATOM    326  CZ  ARG A  23      17.880 -11.668  -0.168  1.00  1.08           C  
ATOM    327  NH1 ARG A  23      16.667 -11.173  -0.375  1.00  1.57           N  
ATOM    328  NH2 ARG A  23      18.161 -12.264   0.983  1.00  1.47           N  
ATOM    329  H   ARG A  23      19.181  -9.238  -6.851  1.00  0.51           H  
ATOM    330  HA  ARG A  23      18.839  -8.770  -4.064  1.00  0.44           H  
ATOM    331  HB2 ARG A  23      18.333 -10.934  -5.090  1.00  0.49           H  
ATOM    332  HG2 ARG A  23      19.520 -12.456  -3.567  1.00  0.91           H  
ATOM    333  HD2 ARG A  23      18.658  -9.864  -2.291  1.00  0.89           H  
ATOM    334  HE  ARG A  23      19.700 -11.939  -0.936  1.00  1.08           H  
ATOM    335 HH11 ARG A  23      16.451 -10.720  -1.241  1.00  1.70           H  
ATOM    336 HH12 ARG A  23      15.967 -11.251   0.336  1.00  2.02           H  
ATOM    337 HH21 ARG A  23      19.074 -12.639   1.142  1.00  1.70           H  
ATOM    338 HH22 ARG A  23      17.459 -12.339   1.692  1.00  1.78           H  
ATOM    339  N   GLN A  24      21.943  -9.337  -5.062  1.00  0.49           N  
ATOM    340  CA  GLN A  24      23.344  -9.101  -4.735  1.00  0.55           C  
ATOM    341  C   GLN A  24      23.655  -7.607  -4.644  1.00  0.58           C  
ATOM    342  O   GLN A  24      24.664  -7.213  -4.059  1.00  0.66           O  
ATOM    343  CB  GLN A  24      24.246  -9.755  -5.785  1.00  0.69           C  
ATOM    344  CG  GLN A  24      25.731  -9.620  -5.482  1.00  1.52           C  
ATOM    345  CD  GLN A  24      26.603 -10.224  -6.565  1.00  2.03           C  
ATOM    346  OE1 GLN A  24      26.209 -11.181  -7.232  1.00  2.61           O  
ATOM    347  NE2 GLN A  24      27.795  -9.670  -6.743  1.00  2.69           N  
ATOM    348  H   GLN A  24      21.722  -9.855  -5.866  1.00  0.51           H  
ATOM    349  HA  GLN A  24      23.540  -9.555  -3.776  1.00  0.55           H  
ATOM    350  HB2 GLN A  24      24.008 -10.807  -5.843  1.00  1.07           H  
ATOM    351  HG2 GLN A  24      25.972  -8.571  -5.390  1.00  2.31           H  
ATOM    352 HE21 GLN A  24      28.042  -8.910  -6.174  1.00  2.90           H  
ATOM    353 HE22 GLN A  24      28.380 -10.040  -7.436  1.00  3.29           H  
ATOM    354  N   LYS A  25      22.790  -6.782  -5.224  1.00  0.59           N  
ATOM    355  CA  LYS A  25      22.979  -5.341  -5.208  1.00  0.68           C  
ATOM    356  C   LYS A  25      22.645  -4.756  -3.838  1.00  0.61           C  
ATOM    357  O   LYS A  25      23.481  -4.108  -3.207  1.00  0.71           O  
ATOM    358  CB  LYS A  25      22.111  -4.693  -6.286  1.00  0.79           C  
ATOM    359  CG  LYS A  25      22.087  -3.178  -6.218  1.00  0.99           C  
ATOM    360  CD  LYS A  25      21.100  -2.593  -7.215  1.00  1.43           C  
ATOM    361  CE  LYS A  25      21.443  -2.993  -8.640  1.00  2.05           C  
ATOM    362  NZ  LYS A  25      22.789  -2.504  -9.047  1.00  2.59           N  
ATOM    363  H   LYS A  25      22.001  -7.148  -5.673  1.00  0.60           H  
ATOM    364  HA  LYS A  25      24.018  -5.141  -5.427  1.00  0.77           H  
ATOM    365  HB2 LYS A  25      22.484  -4.982  -7.256  1.00  1.21           H  
ATOM    366  HG2 LYS A  25      21.796  -2.884  -5.221  1.00  1.59           H  
ATOM    367  HD2 LYS A  25      20.109  -2.952  -6.980  1.00  1.99           H  
ATOM    368  HE2 LYS A  25      21.427  -4.071  -8.710  1.00  2.54           H  
ATOM    369  HZ1 LYS A  25      22.826  -1.465  -8.984  1.00  3.07           H  
ATOM    370  HZ2 LYS A  25      22.991  -2.787 -10.027  1.00  2.83           H  
ATOM    371  HZ3 LYS A  25      23.519  -2.904  -8.424  1.00  2.95           H  
ATOM    372  N   LEU A  26      21.418  -4.988  -3.383  1.00  0.55           N  
ATOM    373  CA  LEU A  26      20.973  -4.477  -2.090  1.00  0.57           C  
ATOM    374  C   LEU A  26      21.978  -4.814  -0.993  1.00  0.60           C  
ATOM    375  O   LEU A  26      22.129  -4.069  -0.025  1.00  0.68           O  
ATOM    376  CB  LEU A  26      19.598  -5.048  -1.736  1.00  0.55           C  
ATOM    377  CG  LEU A  26      18.481  -4.696  -2.721  1.00  0.69           C  
ATOM    378  CD1 LEU A  26      17.155  -5.277  -2.254  1.00  1.30           C  
ATOM    379  CD2 LEU A  26      18.375  -3.188  -2.886  1.00  1.29           C  
ATOM    380  H   LEU A  26      20.796  -5.515  -3.928  1.00  0.57           H  
ATOM    381  HA  LEU A  26      20.895  -3.403  -2.171  1.00  0.69           H  
ATOM    382  HB2 LEU A  26      19.681  -6.123  -1.687  1.00  0.66           H  
ATOM    383  HG  LEU A  26      18.711  -5.124  -3.687  1.00  1.38           H  
ATOM    384 HD11 LEU A  26      16.374  -4.989  -2.942  1.00  1.69           H  
ATOM    385 HD12 LEU A  26      17.224  -6.354  -2.219  1.00  1.94           H  
ATOM    386 HD13 LEU A  26      16.922  -4.898  -1.269  1.00  1.82           H  
ATOM    387 HD21 LEU A  26      19.303  -2.802  -3.284  1.00  1.87           H  
ATOM    388 HD22 LEU A  26      17.567  -2.955  -3.565  1.00  1.79           H  
ATOM    389 HD23 LEU A  26      18.179  -2.733  -1.926  1.00  1.79           H  
ATOM    390  N   LEU A  27      22.665  -5.941  -1.150  1.00  0.59           N  
ATOM    391  CA  LEU A  27      23.656  -6.373  -0.175  1.00  0.71           C  
ATOM    392  C   LEU A  27      24.652  -5.257   0.124  1.00  0.82           C  
ATOM    393  O   LEU A  27      25.137  -5.127   1.248  1.00  0.95           O  
ATOM    394  CB  LEU A  27      24.398  -7.611  -0.683  1.00  0.75           C  
ATOM    395  CG  LEU A  27      23.515  -8.825  -0.970  1.00  0.71           C  
ATOM    396  CD1 LEU A  27      24.360 -10.003  -1.430  1.00  0.82           C  
ATOM    397  CD2 LEU A  27      22.701  -9.195   0.261  1.00  0.77           C  
ATOM    398  H   LEU A  27      22.499  -6.497  -1.938  1.00  0.56           H  
ATOM    399  HA  LEU A  27      23.133  -6.626   0.734  1.00  0.73           H  
ATOM    400  HB2 LEU A  27      24.916  -7.345  -1.594  1.00  0.74           H  
ATOM    401  HG  LEU A  27      22.825  -8.581  -1.766  1.00  0.62           H  
ATOM    402 HD11 LEU A  27      25.071 -10.260  -0.659  1.00  1.38           H  
ATOM    403 HD12 LEU A  27      23.720 -10.852  -1.625  1.00  1.21           H  
ATOM    404 HD13 LEU A  27      24.890  -9.737  -2.334  1.00  1.25           H  
ATOM    405 HD21 LEU A  27      22.086 -10.054   0.042  1.00  1.22           H  
ATOM    406 HD22 LEU A  27      23.372  -9.429   1.077  1.00  1.16           H  
ATOM    407 HD23 LEU A  27      22.074  -8.363   0.542  1.00  1.45           H  
ATOM    408  N   SER A  28      24.954  -4.453  -0.892  1.00  0.84           N  
ATOM    409  CA  SER A  28      25.897  -3.349  -0.739  1.00  0.98           C  
ATOM    410  C   SER A  28      25.384  -2.324   0.267  1.00  0.89           C  
ATOM    411  O   SER A  28      26.168  -1.649   0.935  1.00  0.99           O  
ATOM    412  CB  SER A  28      26.146  -2.673  -2.089  1.00  1.15           C  
ATOM    413  OG  SER A  28      24.943  -2.153  -2.630  1.00  1.64           O  
ATOM    414  H   SER A  28      24.534  -4.606  -1.763  1.00  0.80           H  
ATOM    415  HA  SER A  28      26.826  -3.757  -0.376  1.00  1.11           H  
ATOM    416  HB2 SER A  28      26.847  -1.863  -1.959  1.00  1.60           H  
ATOM    417  HG  SER A  28      24.917  -1.203  -2.494  1.00  2.09           H  
ATOM    418  N   LEU A  29      24.065  -2.210   0.370  1.00  0.78           N  
ATOM    419  CA  LEU A  29      23.451  -1.263   1.294  1.00  0.78           C  
ATOM    420  C   LEU A  29      23.275  -1.882   2.677  1.00  0.74           C  
ATOM    421  O   LEU A  29      23.205  -1.174   3.680  1.00  0.82           O  
ATOM    422  CB  LEU A  29      22.097  -0.799   0.753  1.00  0.86           C  
ATOM    423  CG  LEU A  29      22.148  -0.118  -0.616  1.00  1.06           C  
ATOM    424  CD1 LEU A  29      20.752   0.304  -1.049  1.00  1.64           C  
ATOM    425  CD2 LEU A  29      23.083   1.079  -0.581  1.00  1.42           C  
ATOM    426  H   LEU A  29      23.491  -2.775  -0.186  1.00  0.77           H  
ATOM    427  HA  LEU A  29      24.106  -0.409   1.377  1.00  0.85           H  
ATOM    428  HB2 LEU A  29      21.447  -1.659   0.683  1.00  0.86           H  
ATOM    429  HG  LEU A  29      22.525  -0.820  -1.345  1.00  1.79           H  
ATOM    430 HD11 LEU A  29      20.337   0.978  -0.314  1.00  2.13           H  
ATOM    431 HD12 LEU A  29      20.808   0.803  -2.006  1.00  2.08           H  
ATOM    432 HD13 LEU A  29      20.121  -0.568  -1.133  1.00  2.13           H  
ATOM    433 HD21 LEU A  29      24.072   0.755  -0.291  1.00  1.99           H  
ATOM    434 HD22 LEU A  29      23.126   1.532  -1.560  1.00  1.91           H  
ATOM    435 HD23 LEU A  29      22.718   1.802   0.133  1.00  1.87           H  
ATOM    436  N   GLY A  30      23.202  -3.210   2.720  1.00  0.68           N  
ATOM    437  CA  GLY A  30      23.038  -3.901   3.983  1.00  0.73           C  
ATOM    438  C   GLY A  30      21.587  -3.976   4.419  1.00  0.71           C  
ATOM    439  O   GLY A  30      21.296  -4.173   5.599  1.00  0.82           O  
ATOM    440  H   GLY A  30      23.255  -3.721   1.887  1.00  0.67           H  
ATOM    441  HA2 GLY A  30      23.422  -4.905   3.884  1.00  0.76           H  
ATOM    442  HA3 GLY A  30      23.602  -3.382   4.742  1.00  0.82           H  
ATOM    443  N   MET A  31      20.676  -3.816   3.466  1.00  0.63           N  
ATOM    444  CA  MET A  31      19.250  -3.865   3.757  1.00  0.66           C  
ATOM    445  C   MET A  31      18.657  -5.208   3.342  1.00  0.56           C  
ATOM    446  O   MET A  31      18.236  -5.387   2.200  1.00  0.54           O  
ATOM    447  CB  MET A  31      18.524  -2.725   3.040  1.00  0.74           C  
ATOM    448  CG  MET A  31      18.972  -1.344   3.491  1.00  0.94           C  
ATOM    449  SD  MET A  31      18.568  -1.012   5.218  1.00  1.95           S  
ATOM    450  CE  MET A  31      19.322   0.597   5.439  1.00  2.55           C  
ATOM    451  H   MET A  31      20.970  -3.661   2.544  1.00  0.62           H  
ATOM    452  HA  MET A  31      19.125  -3.745   4.823  1.00  0.75           H  
ATOM    453  HB2 MET A  31      18.704  -2.811   1.979  1.00  0.83           H  
ATOM    454  HG2 MET A  31      20.042  -1.269   3.366  1.00  1.20           H  
ATOM    455  HE1 MET A  31      20.397   0.490   5.480  1.00  2.97           H  
ATOM    456  HE2 MET A  31      19.054   1.238   4.611  1.00  2.93           H  
ATOM    457  HE3 MET A  31      18.968   1.036   6.361  1.00  2.92           H  
ATOM    458  N   LEU A  32      18.637  -6.152   4.278  1.00  0.56           N  
ATOM    459  CA  LEU A  32      18.097  -7.482   4.018  1.00  0.49           C  
ATOM    460  C   LEU A  32      16.598  -7.523   4.299  1.00  0.44           C  
ATOM    461  O   LEU A  32      16.069  -6.668   5.008  1.00  0.45           O  
ATOM    462  CB  LEU A  32      18.818  -8.522   4.879  1.00  0.52           C  
ATOM    463  CG  LEU A  32      20.270  -8.801   4.482  1.00  0.59           C  
ATOM    464  CD1 LEU A  32      21.109  -7.538   4.599  1.00  0.69           C  
ATOM    465  CD2 LEU A  32      20.852  -9.914   5.341  1.00  0.66           C  
ATOM    466  H   LEU A  32      18.996  -5.948   5.167  1.00  0.64           H  
ATOM    467  HA  LEU A  32      18.263  -7.711   2.975  1.00  0.50           H  
ATOM    468  HB2 LEU A  32      18.809  -8.180   5.903  1.00  0.56           H  
ATOM    469  HG  LEU A  32      20.298  -9.125   3.450  1.00  0.56           H  
ATOM    470 HD11 LEU A  32      20.987  -7.116   5.586  1.00  1.11           H  
ATOM    471 HD12 LEU A  32      22.148  -7.780   4.437  1.00  1.34           H  
ATOM    472 HD13 LEU A  32      20.787  -6.821   3.859  1.00  1.07           H  
ATOM    473 HD21 LEU A  32      20.262 -10.810   5.216  1.00  1.09           H  
ATOM    474 HD22 LEU A  32      21.869 -10.108   5.036  1.00  1.20           H  
ATOM    475 HD23 LEU A  32      20.835  -9.614   6.377  1.00  1.23           H  
ATOM    476  N   PRO A  33      15.891  -8.524   3.744  1.00  0.41           N  
ATOM    477  CA  PRO A  33      14.449  -8.672   3.939  1.00  0.40           C  
ATOM    478  C   PRO A  33      14.029  -8.417   5.382  1.00  0.38           C  
ATOM    479  O   PRO A  33      14.370  -9.179   6.285  1.00  0.51           O  
ATOM    480  CB  PRO A  33      14.204 -10.128   3.554  1.00  0.43           C  
ATOM    481  CG  PRO A  33      15.233 -10.411   2.514  1.00  0.45           C  
ATOM    482  CD  PRO A  33      16.442  -9.588   2.880  1.00  0.43           C  
ATOM    483  HA  PRO A  33      13.890  -8.024   3.280  1.00  0.41           H  
ATOM    484  HB2 PRO A  33      14.330 -10.761   4.420  1.00  0.44           H  
ATOM    485  HG2 PRO A  33      15.480 -11.462   2.519  1.00  0.48           H  
ATOM    486  HD2 PRO A  33      17.156 -10.191   3.421  1.00  0.44           H  
ATOM    487  N   GLY A  34      13.287  -7.333   5.589  1.00  0.34           N  
ATOM    488  CA  GLY A  34      12.833  -6.986   6.922  1.00  0.33           C  
ATOM    489  C   GLY A  34      13.336  -5.628   7.370  1.00  0.31           C  
ATOM    490  O   GLY A  34      13.542  -5.397   8.561  1.00  0.40           O  
ATOM    491  H   GLY A  34      13.044  -6.767   4.829  1.00  0.40           H  
ATOM    492  HA2 GLY A  34      11.753  -6.980   6.934  1.00  0.35           H  
ATOM    493  HA3 GLY A  34      13.185  -7.736   7.617  1.00  0.35           H  
ATOM    494  N   SER A  35      13.530  -4.725   6.414  1.00  0.28           N  
ATOM    495  CA  SER A  35      14.014  -3.382   6.718  1.00  0.28           C  
ATOM    496  C   SER A  35      12.870  -2.373   6.689  1.00  0.28           C  
ATOM    497  O   SER A  35      11.744  -2.710   6.332  1.00  0.37           O  
ATOM    498  CB  SER A  35      15.101  -2.970   5.725  1.00  0.31           C  
ATOM    499  OG  SER A  35      15.588  -1.670   6.012  1.00  0.62           O  
ATOM    500  H   SER A  35      13.339  -4.965   5.481  1.00  0.33           H  
ATOM    501  HA  SER A  35      14.434  -3.400   7.713  1.00  0.31           H  
ATOM    502  HB2 SER A  35      15.923  -3.668   5.783  1.00  0.56           H  
ATOM    503  HG  SER A  35      15.806  -1.222   5.191  1.00  1.01           H  
ATOM    504  N   SER A  36      13.171  -1.134   7.071  1.00  0.25           N  
ATOM    505  CA  SER A  36      12.169  -0.073   7.087  1.00  0.25           C  
ATOM    506  C   SER A  36      12.562   1.062   6.146  1.00  0.23           C  
ATOM    507  O   SER A  36      13.728   1.450   6.077  1.00  0.28           O  
ATOM    508  CB  SER A  36      11.993   0.467   8.508  1.00  0.30           C  
ATOM    509  OG  SER A  36      11.027   1.505   8.544  1.00  1.30           O  
ATOM    510  H   SER A  36      14.088  -0.930   7.348  1.00  0.30           H  
ATOM    511  HA  SER A  36      11.234  -0.494   6.752  1.00  0.27           H  
ATOM    512  HB2 SER A  36      11.665  -0.332   9.156  1.00  1.06           H  
ATOM    513  HG  SER A  36      11.416   2.314   8.202  1.00  1.75           H  
ATOM    514  N   PHE A  37      11.580   1.591   5.420  1.00  0.22           N  
ATOM    515  CA  PHE A  37      11.829   2.680   4.480  1.00  0.23           C  
ATOM    516  C   PHE A  37      10.575   3.526   4.278  1.00  0.23           C  
ATOM    517  O   PHE A  37       9.462   3.079   4.553  1.00  0.33           O  
ATOM    518  CB  PHE A  37      12.301   2.120   3.134  1.00  0.25           C  
ATOM    519  CG  PHE A  37      11.211   1.451   2.342  1.00  0.26           C  
ATOM    520  CD1 PHE A  37      10.778   0.178   2.672  1.00  0.32           C  
ATOM    521  CD2 PHE A  37      10.617   2.102   1.273  1.00  0.27           C  
ATOM    522  CE1 PHE A  37       9.772  -0.435   1.947  1.00  0.36           C  
ATOM    523  CE2 PHE A  37       9.612   1.494   0.545  1.00  0.30           C  
ATOM    524  CZ  PHE A  37       9.189   0.223   0.882  1.00  0.33           C  
ATOM    525  H   PHE A  37      10.671   1.241   5.518  1.00  0.25           H  
ATOM    526  HA  PHE A  37      12.609   3.303   4.895  1.00  0.25           H  
ATOM    527  HB2 PHE A  37      12.698   2.927   2.536  1.00  0.28           H  
ATOM    528  HD1 PHE A  37      11.231  -0.339   3.504  1.00  0.37           H  
ATOM    529  HD2 PHE A  37      10.947   3.096   1.007  1.00  0.32           H  
ATOM    530  HE1 PHE A  37       9.444  -1.430   2.212  1.00  0.44           H  
ATOM    531  HE2 PHE A  37       9.156   2.012  -0.285  1.00  0.34           H  
ATOM    532  HZ  PHE A  37       8.404  -0.254   0.316  1.00  0.37           H  
ATOM    533  N   HIS A  38      10.763   4.751   3.795  1.00  0.21           N  
ATOM    534  CA  HIS A  38       9.644   5.656   3.549  1.00  0.24           C  
ATOM    535  C   HIS A  38       9.498   5.944   2.059  1.00  0.24           C  
ATOM    536  O   HIS A  38      10.432   5.746   1.282  1.00  0.40           O  
ATOM    537  CB  HIS A  38       9.838   6.963   4.318  1.00  0.28           C  
ATOM    538  CG  HIS A  38       9.911   6.780   5.800  1.00  1.17           C  
ATOM    539  ND1 HIS A  38      11.099   6.630   6.483  1.00  2.13           N  
ATOM    540  CD2 HIS A  38       8.933   6.723   6.735  1.00  1.98           C  
ATOM    541  CE1 HIS A  38      10.849   6.487   7.773  1.00  2.94           C  
ATOM    542  NE2 HIS A  38       9.543   6.541   7.951  1.00  2.82           N  
ATOM    543  H   HIS A  38      11.677   5.053   3.601  1.00  0.24           H  
ATOM    544  HA  HIS A  38       8.746   5.171   3.901  1.00  0.27           H  
ATOM    545  HB2 HIS A  38      10.754   7.431   3.997  1.00  0.92           H  
ATOM    546  HD1 HIS A  38      11.993   6.626   6.082  1.00  2.50           H  
ATOM    547  HD2 HIS A  38       7.870   6.807   6.557  1.00  2.38           H  
ATOM    548  HE1 HIS A  38      11.588   6.352   8.549  1.00  3.83           H  
ATOM    549  HE2 HIS A  38       9.083   6.391   8.804  1.00  3.50           H  
ATOM    550  N   VAL A  39       8.317   6.412   1.667  1.00  0.27           N  
ATOM    551  CA  VAL A  39       8.043   6.723   0.269  1.00  0.27           C  
ATOM    552  C   VAL A  39       8.201   8.215  -0.005  1.00  0.28           C  
ATOM    553  O   VAL A  39       7.711   9.050   0.756  1.00  0.40           O  
ATOM    554  CB  VAL A  39       6.619   6.290  -0.131  1.00  0.39           C  
ATOM    555  CG1 VAL A  39       6.352   6.602  -1.595  1.00  1.28           C  
ATOM    556  CG2 VAL A  39       6.413   4.811   0.156  1.00  0.88           C  
ATOM    557  H   VAL A  39       7.612   6.549   2.332  1.00  0.41           H  
ATOM    558  HA  VAL A  39       8.747   6.177  -0.343  1.00  0.27           H  
ATOM    559  HB  VAL A  39       5.915   6.850   0.467  1.00  1.11           H  
ATOM    560 HG11 VAL A  39       6.451   7.664  -1.762  1.00  1.84           H  
ATOM    561 HG12 VAL A  39       7.064   6.072  -2.213  1.00  1.81           H  
ATOM    562 HG13 VAL A  39       5.350   6.288  -1.853  1.00  1.88           H  
ATOM    563 HG21 VAL A  39       5.400   4.533  -0.095  1.00  1.59           H  
ATOM    564 HG22 VAL A  39       7.104   4.230  -0.439  1.00  1.56           H  
ATOM    565 HG23 VAL A  39       6.591   4.621   1.202  1.00  1.36           H  
ATOM    566  N   VAL A  40       8.885   8.542  -1.095  1.00  0.24           N  
ATOM    567  CA  VAL A  40       9.103   9.935  -1.469  1.00  0.34           C  
ATOM    568  C   VAL A  40       8.049  10.408  -2.467  1.00  0.37           C  
ATOM    569  O   VAL A  40       7.435  11.458  -2.286  1.00  0.54           O  
ATOM    570  CB  VAL A  40      10.503  10.140  -2.076  1.00  0.41           C  
ATOM    571  CG1 VAL A  40      10.718  11.599  -2.451  1.00  0.54           C  
ATOM    572  CG2 VAL A  40      11.578   9.667  -1.109  1.00  0.43           C  
ATOM    573  H   VAL A  40       9.257   7.833  -1.660  1.00  0.23           H  
ATOM    574  HA  VAL A  40       9.030  10.535  -0.572  1.00  0.41           H  
ATOM    575  HB  VAL A  40      10.573   9.547  -2.976  1.00  0.40           H  
ATOM    576 HG11 VAL A  40      11.723  11.729  -2.824  1.00  1.22           H  
ATOM    577 HG12 VAL A  40      10.010  11.883  -3.215  1.00  1.16           H  
ATOM    578 HG13 VAL A  40      10.576  12.221  -1.578  1.00  1.13           H  
ATOM    579 HG21 VAL A  40      11.559  10.281  -0.221  1.00  1.07           H  
ATOM    580 HG22 VAL A  40      11.391   8.638  -0.839  1.00  1.12           H  
ATOM    581 HG23 VAL A  40      12.546   9.745  -1.581  1.00  1.01           H  
ATOM    582  N   ARG A  41       7.844   9.621  -3.520  1.00  0.27           N  
ATOM    583  CA  ARG A  41       6.861   9.958  -4.545  1.00  0.31           C  
ATOM    584  C   ARG A  41       6.480   8.724  -5.357  1.00  0.31           C  
ATOM    585  O   ARG A  41       7.336   7.914  -5.711  1.00  0.40           O  
ATOM    586  CB  ARG A  41       7.416  11.040  -5.474  1.00  0.40           C  
ATOM    587  CG  ARG A  41       8.630  10.594  -6.270  1.00  0.47           C  
ATOM    588  CD  ARG A  41       9.051  11.646  -7.281  1.00  0.57           C  
ATOM    589  NE  ARG A  41       9.364  12.922  -6.645  1.00  1.37           N  
ATOM    590  CZ  ARG A  41       9.549  14.055  -7.314  1.00  1.62           C  
ATOM    591  NH1 ARG A  41       9.450  14.069  -8.637  1.00  0.94           N  
ATOM    592  NH2 ARG A  41       9.834  15.173  -6.663  1.00  2.80           N  
ATOM    593  H   ARG A  41       8.367   8.797  -3.609  1.00  0.26           H  
ATOM    594  HA  ARG A  41       5.982  10.337  -4.049  1.00  0.34           H  
ATOM    595  HB2 ARG A  41       6.642  11.330  -6.170  1.00  0.44           H  
ATOM    596  HG2 ARG A  41       9.450  10.415  -5.590  1.00  0.47           H  
ATOM    597  HD2 ARG A  41       9.926  11.294  -7.807  1.00  1.21           H  
ATOM    598  HE  ARG A  41       9.440  12.935  -5.667  1.00  2.08           H  
ATOM    599 HH11 ARG A  41       9.232  13.228  -9.131  1.00  0.93           H  
ATOM    600 HH12 ARG A  41       9.589  14.924  -9.140  1.00  1.14           H  
ATOM    601 HH21 ARG A  41       9.909  15.165  -5.665  1.00  3.53           H  
ATOM    602 HH22 ARG A  41       9.976  16.025  -7.169  1.00  3.00           H  
ATOM    603  N   VAL A  42       5.192   8.587  -5.651  1.00  0.33           N  
ATOM    604  CA  VAL A  42       4.704   7.445  -6.417  1.00  0.39           C  
ATOM    605  C   VAL A  42       3.528   7.834  -7.308  1.00  0.43           C  
ATOM    606  O   VAL A  42       2.846   8.829  -7.058  1.00  0.49           O  
ATOM    607  CB  VAL A  42       4.273   6.295  -5.489  1.00  0.52           C  
ATOM    608  CG1 VAL A  42       3.976   5.039  -6.294  1.00  0.97           C  
ATOM    609  CG2 VAL A  42       5.342   6.026  -4.442  1.00  1.20           C  
ATOM    610  H   VAL A  42       4.553   9.265  -5.345  1.00  0.38           H  
ATOM    611  HA  VAL A  42       5.514   7.092  -7.042  1.00  0.41           H  
ATOM    612  HB  VAL A  42       3.368   6.590  -4.979  1.00  1.31           H  
ATOM    613 HG11 VAL A  42       3.155   5.229  -6.967  1.00  1.59           H  
ATOM    614 HG12 VAL A  42       4.852   4.760  -6.860  1.00  1.47           H  
ATOM    615 HG13 VAL A  42       3.711   4.236  -5.621  1.00  1.66           H  
ATOM    616 HG21 VAL A  42       4.980   5.298  -3.733  1.00  1.73           H  
ATOM    617 HG22 VAL A  42       6.232   5.647  -4.925  1.00  1.79           H  
ATOM    618 HG23 VAL A  42       5.580   6.945  -3.925  1.00  1.76           H  
ATOM    619  N   ALA A  43       3.296   7.044  -8.354  1.00  0.47           N  
ATOM    620  CA  ALA A  43       2.201   7.297  -9.283  1.00  0.55           C  
ATOM    621  C   ALA A  43       1.276   6.087  -9.384  1.00  0.69           C  
ATOM    622  O   ALA A  43       1.722   4.946  -9.268  1.00  0.81           O  
ATOM    623  CB  ALA A  43       2.746   7.663 -10.655  1.00  0.55           C  
ATOM    624  H   ALA A  43       3.878   6.269  -8.501  1.00  0.49           H  
ATOM    625  HA  ALA A  43       1.636   8.139  -8.909  1.00  0.64           H  
ATOM    626  HB1 ALA A  43       3.419   8.501 -10.565  1.00  1.05           H  
ATOM    627  HB2 ALA A  43       3.280   6.817 -11.066  1.00  1.25           H  
ATOM    628  HB3 ALA A  43       1.928   7.925 -11.310  1.00  1.18           H  
ATOM    629  N   PRO A  44      -0.030   6.323  -9.602  1.00  0.83           N  
ATOM    630  CA  PRO A  44      -1.021   5.246  -9.715  1.00  1.00           C  
ATOM    631  C   PRO A  44      -0.927   4.497 -11.041  1.00  0.98           C  
ATOM    632  O   PRO A  44      -1.398   3.367 -11.159  1.00  1.15           O  
ATOM    633  CB  PRO A  44      -2.353   5.991  -9.619  1.00  1.14           C  
ATOM    634  CG  PRO A  44      -2.061   7.352 -10.150  1.00  1.34           C  
ATOM    635  CD  PRO A  44      -0.644   7.658  -9.748  1.00  1.00           C  
ATOM    636  HA  PRO A  44      -0.938   4.544  -8.900  1.00  1.10           H  
ATOM    637  HB2 PRO A  44      -3.097   5.483 -10.215  1.00  1.18           H  
ATOM    638  HG2 PRO A  44      -2.154   7.354 -11.226  1.00  1.63           H  
ATOM    639  HD2 PRO A  44      -0.147   8.229 -10.519  1.00  1.00           H  
ATOM    640  N   LEU A  45      -0.316   5.131 -12.036  1.00  0.85           N  
ATOM    641  CA  LEU A  45      -0.167   4.521 -13.353  1.00  0.90           C  
ATOM    642  C   LEU A  45       1.164   3.784 -13.469  1.00  0.91           C  
ATOM    643  O   LEU A  45       1.217   2.650 -13.945  1.00  1.23           O  
ATOM    644  CB  LEU A  45      -0.271   5.587 -14.445  1.00  0.90           C  
ATOM    645  CG  LEU A  45      -0.139   5.065 -15.878  1.00  1.76           C  
ATOM    646  CD1 LEU A  45      -1.285   4.121 -16.210  1.00  2.51           C  
ATOM    647  CD2 LEU A  45      -0.099   6.225 -16.861  1.00  2.25           C  
ATOM    648  H   LEU A  45       0.044   6.030 -11.882  1.00  0.79           H  
ATOM    649  HA  LEU A  45      -0.970   3.811 -13.479  1.00  1.00           H  
ATOM    650  HB2 LEU A  45      -1.228   6.079 -14.349  1.00  1.22           H  
ATOM    651  HG  LEU A  45       0.784   4.513 -15.969  1.00  2.42           H  
ATOM    652 HD11 LEU A  45      -1.166   3.752 -17.218  1.00  2.79           H  
ATOM    653 HD12 LEU A  45      -1.279   3.290 -15.519  1.00  3.06           H  
ATOM    654 HD13 LEU A  45      -2.223   4.648 -16.129  1.00  2.90           H  
ATOM    655 HD21 LEU A  45      -1.007   6.801 -16.777  1.00  2.49           H  
ATOM    656 HD22 LEU A  45       0.750   6.854 -16.640  1.00  2.73           H  
ATOM    657 HD23 LEU A  45      -0.010   5.839 -17.867  1.00  2.66           H  
ATOM    658  N   GLY A  46       2.237   4.437 -13.035  1.00  0.72           N  
ATOM    659  CA  GLY A  46       3.553   3.828 -13.100  1.00  0.72           C  
ATOM    660  C   GLY A  46       4.657   4.857 -13.239  1.00  0.66           C  
ATOM    661  O   GLY A  46       4.908   5.363 -14.329  1.00  0.77           O  
ATOM    662  H   GLY A  46       2.134   5.340 -12.667  1.00  0.74           H  
ATOM    663  HA2 GLY A  46       3.717   3.256 -12.200  1.00  0.73           H  
ATOM    664  HA3 GLY A  46       3.587   3.162 -13.949  1.00  0.79           H  
ATOM    665  N   ASP A  47       5.318   5.164 -12.127  1.00  0.53           N  
ATOM    666  CA  ASP A  47       6.398   6.144 -12.126  1.00  0.49           C  
ATOM    667  C   ASP A  47       7.553   5.683 -11.242  1.00  0.46           C  
ATOM    668  O   ASP A  47       7.434   4.696 -10.518  1.00  0.46           O  
ATOM    669  CB  ASP A  47       5.874   7.501 -11.649  1.00  0.45           C  
ATOM    670  CG  ASP A  47       5.019   8.189 -12.696  1.00  0.78           C  
ATOM    671  OD1 ASP A  47       3.950   7.644 -13.042  1.00  0.94           O  
ATOM    672  OD2 ASP A  47       5.422   9.270 -13.174  1.00  1.07           O  
ATOM    673  H   ASP A  47       5.075   4.721 -11.288  1.00  0.49           H  
ATOM    674  HA  ASP A  47       6.757   6.241 -13.137  1.00  0.56           H  
ATOM    675  HB2 ASP A  47       5.273   7.356 -10.764  1.00  0.57           H  
ATOM    676  N   PRO A  48       8.691   6.397 -11.292  1.00  0.47           N  
ATOM    677  CA  PRO A  48       9.868   6.067 -10.499  1.00  0.47           C  
ATOM    678  C   PRO A  48       9.789   6.665  -9.100  1.00  0.37           C  
ATOM    679  O   PRO A  48       9.755   7.884  -8.933  1.00  0.38           O  
ATOM    680  CB  PRO A  48      11.029   6.701 -11.283  1.00  0.56           C  
ATOM    681  CG  PRO A  48      10.409   7.441 -12.433  1.00  0.61           C  
ATOM    682  CD  PRO A  48       8.940   7.562 -12.139  1.00  0.53           C  
ATOM    683  HA  PRO A  48      10.013   5.000 -10.429  1.00  0.50           H  
ATOM    684  HB2 PRO A  48      11.574   7.371 -10.636  1.00  0.55           H  
ATOM    685  HG2 PRO A  48      10.853   8.422 -12.515  1.00  0.65           H  
ATOM    686  HD2 PRO A  48       8.734   8.480 -11.606  1.00  0.51           H  
ATOM    687  N   VAL A  49       9.762   5.795  -8.100  1.00  0.32           N  
ATOM    688  CA  VAL A  49       9.676   6.224  -6.713  1.00  0.26           C  
ATOM    689  C   VAL A  49      11.013   6.039  -6.002  1.00  0.28           C  
ATOM    690  O   VAL A  49      11.844   5.230  -6.415  1.00  0.39           O  
ATOM    691  CB  VAL A  49       8.565   5.449  -5.966  1.00  0.27           C  
ATOM    692  CG1 VAL A  49       8.660   3.963  -6.270  1.00  0.35           C  
ATOM    693  CG2 VAL A  49       8.622   5.698  -4.461  1.00  0.31           C  
ATOM    694  H   VAL A  49       9.805   4.836  -8.301  1.00  0.37           H  
ATOM    695  HA  VAL A  49       9.419   7.274  -6.705  1.00  0.27           H  
ATOM    696  HB  VAL A  49       7.610   5.801  -6.328  1.00  0.28           H  
ATOM    697 HG11 VAL A  49       8.488   3.800  -7.327  1.00  1.15           H  
ATOM    698 HG12 VAL A  49       9.642   3.601  -6.005  1.00  1.00           H  
ATOM    699 HG13 VAL A  49       7.915   3.429  -5.700  1.00  1.09           H  
ATOM    700 HG21 VAL A  49       9.585   5.388  -4.083  1.00  1.10           H  
ATOM    701 HG22 VAL A  49       8.479   6.749  -4.263  1.00  1.01           H  
ATOM    702 HG23 VAL A  49       7.844   5.129  -3.972  1.00  1.09           H  
ATOM    703  N   HIS A  50      11.208   6.797  -4.930  1.00  0.29           N  
ATOM    704  CA  HIS A  50      12.439   6.725  -4.156  1.00  0.31           C  
ATOM    705  C   HIS A  50      12.145   6.345  -2.710  1.00  0.29           C  
ATOM    706  O   HIS A  50      11.207   6.860  -2.101  1.00  0.31           O  
ATOM    707  CB  HIS A  50      13.175   8.064  -4.208  1.00  0.34           C  
ATOM    708  CG  HIS A  50      13.431   8.554  -5.599  1.00  0.37           C  
ATOM    709  ND1 HIS A  50      14.678   8.540  -6.187  1.00  1.13           N  
ATOM    710  CD2 HIS A  50      12.588   9.079  -6.522  1.00  1.08           C  
ATOM    711  CE1 HIS A  50      14.593   9.034  -7.410  1.00  0.85           C  
ATOM    712  NE2 HIS A  50      13.336   9.368  -7.637  1.00  0.68           N  
ATOM    713  H   HIS A  50      10.505   7.421  -4.652  1.00  0.37           H  
ATOM    714  HA  HIS A  50      13.064   5.964  -4.597  1.00  0.34           H  
ATOM    715  HB2 HIS A  50      12.587   8.812  -3.696  1.00  0.34           H  
ATOM    716  HD1 HIS A  50      15.504   8.215  -5.770  1.00  1.97           H  
ATOM    717  HD2 HIS A  50      11.526   9.239  -6.403  1.00  2.03           H  
ATOM    718  HE1 HIS A  50      15.413   9.148  -8.104  1.00  1.44           H  
ATOM    719  HE2 HIS A  50      13.011   9.836  -8.435  1.00  1.13           H  
ATOM    720  N   ILE A  51      12.952   5.440  -2.167  1.00  0.32           N  
ATOM    721  CA  ILE A  51      12.778   4.988  -0.794  1.00  0.32           C  
ATOM    722  C   ILE A  51      13.787   5.651   0.135  1.00  0.32           C  
ATOM    723  O   ILE A  51      14.934   5.890  -0.245  1.00  0.31           O  
ATOM    724  CB  ILE A  51      12.921   3.458  -0.678  1.00  0.34           C  
ATOM    725  CG1 ILE A  51      14.315   3.013  -1.123  1.00  0.34           C  
ATOM    726  CG2 ILE A  51      11.853   2.763  -1.506  1.00  0.36           C  
ATOM    727  CD1 ILE A  51      14.531   1.520  -1.012  1.00  0.36           C  
ATOM    728  H   ILE A  51      13.682   5.065  -2.705  1.00  0.36           H  
ATOM    729  HA  ILE A  51      11.781   5.260  -0.477  1.00  0.34           H  
ATOM    730  HB  ILE A  51      12.777   3.183   0.355  1.00  0.35           H  
ATOM    731 HG12 ILE A  51      14.463   3.295  -2.155  1.00  0.36           H  
ATOM    732 HG21 ILE A  51      11.949   3.059  -2.541  1.00  1.07           H  
ATOM    733 HG22 ILE A  51      11.975   1.693  -1.425  1.00  1.00           H  
ATOM    734 HG23 ILE A  51      10.875   3.043  -1.143  1.00  1.12           H  
ATOM    735 HD11 ILE A  51      15.534   1.276  -1.329  1.00  1.09           H  
ATOM    736 HD12 ILE A  51      14.392   1.210   0.013  1.00  1.00           H  
ATOM    737 HD13 ILE A  51      13.820   1.006  -1.644  1.00  1.07           H  
ATOM    738  N   GLU A  52      13.353   5.950   1.354  1.00  0.36           N  
ATOM    739  CA  GLU A  52      14.219   6.582   2.341  1.00  0.39           C  
ATOM    740  C   GLU A  52      14.625   5.585   3.419  1.00  0.42           C  
ATOM    741  O   GLU A  52      13.798   5.159   4.228  1.00  0.43           O  
ATOM    742  CB  GLU A  52      13.518   7.785   2.975  1.00  0.45           C  
ATOM    743  CG  GLU A  52      13.135   8.861   1.971  1.00  1.01           C  
ATOM    744  CD  GLU A  52      14.343   9.514   1.328  1.00  1.46           C  
ATOM    745  OE1 GLU A  52      14.910   8.917   0.389  1.00  2.13           O  
ATOM    746  OE2 GLU A  52      14.718  10.624   1.757  1.00  1.91           O  
ATOM    747  H   GLU A  52      12.426   5.740   1.596  1.00  0.40           H  
ATOM    748  HA  GLU A  52      15.108   6.922   1.830  1.00  0.36           H  
ATOM    749  HB2 GLU A  52      12.619   7.444   3.466  1.00  0.94           H  
ATOM    750  HG2 GLU A  52      12.529   8.417   1.197  1.00  1.62           H  
ATOM    751  N   THR A  53      15.899   5.214   3.422  1.00  0.52           N  
ATOM    752  CA  THR A  53      16.421   4.266   4.395  1.00  0.58           C  
ATOM    753  C   THR A  53      17.392   4.945   5.356  1.00  0.61           C  
ATOM    754  O   THR A  53      17.569   6.163   5.316  1.00  0.60           O  
ATOM    755  CB  THR A  53      17.131   3.089   3.700  1.00  0.59           C  
ATOM    756  OG1 THR A  53      18.236   3.571   2.927  1.00  0.55           O  
ATOM    757  CG2 THR A  53      16.165   2.337   2.795  1.00  0.64           C  
ATOM    758  H   THR A  53      16.506   5.589   2.749  1.00  0.58           H  
ATOM    759  HA  THR A  53      15.586   3.873   4.959  1.00  0.65           H  
ATOM    760  HB  THR A  53      17.496   2.409   4.455  1.00  0.66           H  
ATOM    761  HG1 THR A  53      18.596   2.854   2.400  1.00  1.07           H  
ATOM    762 HG21 THR A  53      16.678   1.512   2.326  1.00  1.28           H  
ATOM    763 HG22 THR A  53      15.790   3.007   2.035  1.00  1.25           H  
ATOM    764 HG23 THR A  53      15.340   1.961   3.381  1.00  1.07           H  
ATOM    765  N   ARG A  54      18.023   4.155   6.218  1.00  0.68           N  
ATOM    766  CA  ARG A  54      18.970   4.684   7.192  1.00  0.73           C  
ATOM    767  C   ARG A  54      20.034   5.549   6.524  1.00  0.67           C  
ATOM    768  O   ARG A  54      21.046   5.043   6.040  1.00  0.69           O  
ATOM    769  CB  ARG A  54      19.638   3.541   7.959  1.00  0.84           C  
ATOM    770  CG  ARG A  54      18.662   2.696   8.761  1.00  1.47           C  
ATOM    771  CD  ARG A  54      17.912   3.534   9.783  1.00  1.53           C  
ATOM    772  NE  ARG A  54      17.047   2.720  10.632  1.00  2.10           N  
ATOM    773  CZ  ARG A  54      16.304   3.216  11.615  1.00  2.32           C  
ATOM    774  NH1 ARG A  54      16.319   4.518  11.868  1.00  1.97           N  
ATOM    775  NH2 ARG A  54      15.543   2.411  12.346  1.00  3.04           N  
ATOM    776  H   ARG A  54      17.845   3.190   6.200  1.00  0.72           H  
ATOM    777  HA  ARG A  54      18.418   5.297   7.889  1.00  0.79           H  
ATOM    778  HB2 ARG A  54      20.144   2.899   7.254  1.00  1.09           H  
ATOM    779  HG2 ARG A  54      17.950   2.248   8.086  1.00  1.91           H  
ATOM    780  HD2 ARG A  54      18.630   4.047  10.405  1.00  1.59           H  
ATOM    781  HE  ARG A  54      17.022   1.755  10.460  1.00  2.46           H  
ATOM    782 HH11 ARG A  54      16.890   5.127  11.318  1.00  1.66           H  
ATOM    783 HH12 ARG A  54      15.756   4.890  12.605  1.00  2.17           H  
ATOM    784 HH21 ARG A  54      15.528   1.429  12.159  1.00  3.43           H  
ATOM    785 HH22 ARG A  54      14.985   2.788  13.086  1.00  3.23           H  
ATOM    786  N   ARG A  55      19.795   6.857   6.497  1.00  0.66           N  
ATOM    787  CA  ARG A  55      20.732   7.801   5.902  1.00  0.66           C  
ATOM    788  C   ARG A  55      21.094   7.410   4.471  1.00  0.62           C  
ATOM    789  O   ARG A  55      22.241   7.563   4.050  1.00  0.70           O  
ATOM    790  CB  ARG A  55      22.003   7.889   6.747  1.00  0.73           C  
ATOM    791  CG  ARG A  55      21.761   8.370   8.168  1.00  1.06           C  
ATOM    792  CD  ARG A  55      23.055   8.423   8.964  1.00  1.67           C  
ATOM    793  NE  ARG A  55      24.026   9.339   8.369  1.00  2.43           N  
ATOM    794  CZ  ARG A  55      25.311   9.371   8.709  1.00  3.17           C  
ATOM    795  NH1 ARG A  55      25.773   8.550   9.642  1.00  3.34           N  
ATOM    796  NH2 ARG A  55      26.133  10.226   8.117  1.00  4.11           N  
ATOM    797  H   ARG A  55      18.963   7.197   6.886  1.00  0.70           H  
ATOM    798  HA  ARG A  55      20.254   8.767   5.887  1.00  0.69           H  
ATOM    799  HB2 ARG A  55      22.455   6.908   6.796  1.00  0.99           H  
ATOM    800  HG2 ARG A  55      21.330   9.360   8.134  1.00  1.30           H  
ATOM    801  HD2 ARG A  55      22.833   8.750   9.968  1.00  2.09           H  
ATOM    802  HE  ARG A  55      23.705   9.957   7.681  1.00  2.75           H  
ATOM    803 HH11 ARG A  55      25.157   7.905  10.092  1.00  3.11           H  
ATOM    804 HH12 ARG A  55      26.740   8.577   9.896  1.00  3.99           H  
ATOM    805 HH21 ARG A  55      25.789  10.848   7.414  1.00  4.44           H  
ATOM    806 HH22 ARG A  55      27.100  10.249   8.373  1.00  4.67           H  
ATOM    807  N   VAL A  56      20.116   6.911   3.725  1.00  0.58           N  
ATOM    808  CA  VAL A  56      20.346   6.504   2.343  1.00  0.57           C  
ATOM    809  C   VAL A  56      19.052   6.547   1.536  1.00  0.49           C  
ATOM    810  O   VAL A  56      18.020   6.038   1.975  1.00  0.50           O  
ATOM    811  CB  VAL A  56      20.946   5.088   2.259  1.00  0.66           C  
ATOM    812  CG1 VAL A  56      21.182   4.689   0.812  1.00  1.02           C  
ATOM    813  CG2 VAL A  56      22.239   5.009   3.057  1.00  1.23           C  
ATOM    814  H   VAL A  56      19.218   6.815   4.109  1.00  0.60           H  
ATOM    815  HA  VAL A  56      21.050   7.198   1.906  1.00  0.64           H  
ATOM    816  HB  VAL A  56      20.241   4.394   2.689  1.00  1.22           H  
ATOM    817 HG11 VAL A  56      21.851   5.400   0.346  1.00  1.71           H  
ATOM    818 HG12 VAL A  56      21.625   3.704   0.776  1.00  1.42           H  
ATOM    819 HG13 VAL A  56      20.242   4.681   0.282  1.00  1.57           H  
ATOM    820 HG21 VAL A  56      22.670   4.025   2.948  1.00  1.63           H  
ATOM    821 HG22 VAL A  56      22.934   5.749   2.690  1.00  1.71           H  
ATOM    822 HG23 VAL A  56      22.031   5.194   4.099  1.00  1.87           H  
ATOM    823  N   SER A  57      19.115   7.157   0.356  1.00  0.48           N  
ATOM    824  CA  SER A  57      17.946   7.270  -0.508  1.00  0.43           C  
ATOM    825  C   SER A  57      18.114   6.433  -1.774  1.00  0.42           C  
ATOM    826  O   SER A  57      18.894   6.782  -2.659  1.00  0.46           O  
ATOM    827  CB  SER A  57      17.705   8.732  -0.882  1.00  0.51           C  
ATOM    828  OG  SER A  57      16.566   8.869  -1.714  1.00  0.64           O  
ATOM    829  H   SER A  57      19.967   7.541   0.060  1.00  0.55           H  
ATOM    830  HA  SER A  57      17.091   6.904   0.039  1.00  0.42           H  
ATOM    831  HB2 SER A  57      17.549   9.312   0.016  1.00  0.73           H  
ATOM    832  HG  SER A  57      16.816   9.309  -2.531  1.00  1.07           H  
ATOM    833  N   LEU A  58      17.376   5.332  -1.850  1.00  0.38           N  
ATOM    834  CA  LEU A  58      17.434   4.452  -3.012  1.00  0.40           C  
ATOM    835  C   LEU A  58      16.234   4.688  -3.921  1.00  0.37           C  
ATOM    836  O   LEU A  58      15.180   5.134  -3.468  1.00  0.38           O  
ATOM    837  CB  LEU A  58      17.474   2.986  -2.572  1.00  0.43           C  
ATOM    838  CG  LEU A  58      17.619   1.974  -3.711  1.00  0.96           C  
ATOM    839  CD1 LEU A  58      18.907   2.219  -4.480  1.00  1.50           C  
ATOM    840  CD2 LEU A  58      17.584   0.552  -3.168  1.00  1.54           C  
ATOM    841  H   LEU A  58      16.778   5.103  -1.106  1.00  0.38           H  
ATOM    842  HA  LEU A  58      18.338   4.682  -3.557  1.00  0.42           H  
ATOM    843  HB2 LEU A  58      18.306   2.858  -1.893  1.00  1.02           H  
ATOM    844  HG  LEU A  58      16.793   2.092  -4.396  1.00  1.80           H  
ATOM    845 HD11 LEU A  58      18.982   1.511  -5.292  1.00  1.96           H  
ATOM    846 HD12 LEU A  58      18.905   3.223  -4.875  1.00  2.01           H  
ATOM    847 HD13 LEU A  58      19.751   2.097  -3.817  1.00  2.03           H  
ATOM    848 HD21 LEU A  58      16.648   0.385  -2.657  1.00  2.10           H  
ATOM    849 HD22 LEU A  58      17.680  -0.146  -3.985  1.00  2.10           H  
ATOM    850 HD23 LEU A  58      18.402   0.410  -2.476  1.00  1.89           H  
ATOM    851  N   VAL A  59      16.399   4.389  -5.204  1.00  0.41           N  
ATOM    852  CA  VAL A  59      15.323   4.572  -6.170  1.00  0.40           C  
ATOM    853  C   VAL A  59      14.741   3.231  -6.609  1.00  0.40           C  
ATOM    854  O   VAL A  59      15.473   2.266  -6.829  1.00  0.47           O  
ATOM    855  CB  VAL A  59      15.809   5.341  -7.412  1.00  0.45           C  
ATOM    856  CG1 VAL A  59      16.875   4.544  -8.151  1.00  0.50           C  
ATOM    857  CG2 VAL A  59      14.639   5.663  -8.330  1.00  0.45           C  
ATOM    858  H   VAL A  59      17.262   4.040  -5.509  1.00  0.48           H  
ATOM    859  HA  VAL A  59      14.546   5.153  -5.696  1.00  0.40           H  
ATOM    860  HB  VAL A  59      16.250   6.271  -7.087  1.00  0.47           H  
ATOM    861 HG11 VAL A  59      16.465   3.593  -8.457  1.00  1.11           H  
ATOM    862 HG12 VAL A  59      17.195   5.095  -9.023  1.00  1.07           H  
ATOM    863 HG13 VAL A  59      17.718   4.379  -7.498  1.00  1.10           H  
ATOM    864 HG21 VAL A  59      14.159   4.746  -8.635  1.00  1.09           H  
ATOM    865 HG22 VAL A  59      13.931   6.283  -7.802  1.00  1.09           H  
ATOM    866 HG23 VAL A  59      15.000   6.188  -9.202  1.00  1.06           H  
ATOM    867  N   LEU A  60      13.419   3.181  -6.734  1.00  0.39           N  
ATOM    868  CA  LEU A  60      12.733   1.960  -7.148  1.00  0.40           C  
ATOM    869  C   LEU A  60      11.771   2.244  -8.298  1.00  0.38           C  
ATOM    870  O   LEU A  60      11.453   3.398  -8.588  1.00  0.48           O  
ATOM    871  CB  LEU A  60      11.976   1.349  -5.969  1.00  0.45           C  
ATOM    872  CG  LEU A  60      12.852   0.920  -4.790  1.00  0.61           C  
ATOM    873  CD1 LEU A  60      12.006   0.292  -3.694  1.00  0.77           C  
ATOM    874  CD2 LEU A  60      13.929  -0.051  -5.254  1.00  0.97           C  
ATOM    875  H   LEU A  60      12.890   3.982  -6.542  1.00  0.41           H  
ATOM    876  HA  LEU A  60      13.481   1.260  -7.487  1.00  0.47           H  
ATOM    877  HB2 LEU A  60      11.257   2.072  -5.613  1.00  0.60           H  
ATOM    878  HG  LEU A  60      13.341   1.789  -4.378  1.00  0.89           H  
ATOM    879 HD11 LEU A  60      11.486  -0.569  -4.087  1.00  1.22           H  
ATOM    880 HD12 LEU A  60      12.642  -0.013  -2.877  1.00  1.35           H  
ATOM    881 HD13 LEU A  60      11.285   1.015  -3.338  1.00  1.37           H  
ATOM    882 HD21 LEU A  60      14.555   0.432  -5.989  1.00  1.42           H  
ATOM    883 HD22 LEU A  60      14.531  -0.351  -4.410  1.00  1.56           H  
ATOM    884 HD23 LEU A  60      13.464  -0.920  -5.693  1.00  1.46           H  
ATOM    885  N   ARG A  61      11.304   1.181  -8.947  1.00  0.51           N  
ATOM    886  CA  ARG A  61      10.385   1.315 -10.072  1.00  0.58           C  
ATOM    887  C   ARG A  61       9.113   0.507  -9.831  1.00  0.54           C  
ATOM    888  O   ARG A  61       9.169  -0.636  -9.379  1.00  0.59           O  
ATOM    889  CB  ARG A  61      11.063   0.854 -11.361  1.00  0.69           C  
ATOM    890  CG  ARG A  61      12.299   1.662 -11.720  1.00  1.34           C  
ATOM    891  CD  ARG A  61      12.977   1.126 -12.969  1.00  1.51           C  
ATOM    892  NE  ARG A  61      14.118   1.943 -13.369  1.00  2.06           N  
ATOM    893  CZ  ARG A  61      14.697   1.865 -14.562  1.00  2.47           C  
ATOM    894  NH1 ARG A  61      14.240   1.011 -15.469  1.00  2.45           N  
ATOM    895  NH2 ARG A  61      15.732   2.641 -14.854  1.00  3.32           N  
ATOM    896  H   ARG A  61      11.579   0.288  -8.662  1.00  0.67           H  
ATOM    897  HA  ARG A  61      10.123   2.358 -10.164  1.00  0.67           H  
ATOM    898  HB2 ARG A  61      11.356  -0.181 -11.251  1.00  0.91           H  
ATOM    899  HG2 ARG A  61      12.008   2.689 -11.895  1.00  1.91           H  
ATOM    900  HD2 ARG A  61      13.319   0.120 -12.773  1.00  1.87           H  
ATOM    901  HE  ARG A  61      14.471   2.581 -12.714  1.00  2.52           H  
ATOM    902 HH11 ARG A  61      13.459   0.426 -15.255  1.00  2.39           H  
ATOM    903 HH12 ARG A  61      14.677   0.953 -16.366  1.00  2.86           H  
ATOM    904 HH21 ARG A  61      16.080   3.286 -14.174  1.00  3.81           H  
ATOM    905 HH22 ARG A  61      16.166   2.581 -15.753  1.00  3.64           H  
ATOM    906  N   LYS A  62       7.967   1.109 -10.142  1.00  0.69           N  
ATOM    907  CA  LYS A  62       6.677   0.449  -9.957  1.00  0.74           C  
ATOM    908  C   LYS A  62       6.707  -0.983 -10.484  1.00  0.68           C  
ATOM    909  O   LYS A  62       5.993  -1.854  -9.986  1.00  0.76           O  
ATOM    910  CB  LYS A  62       5.571   1.239 -10.660  1.00  0.92           C  
ATOM    911  CG  LYS A  62       4.184   0.640 -10.486  1.00  1.88           C  
ATOM    912  CD  LYS A  62       3.485   1.183  -9.248  1.00  2.95           C  
ATOM    913  CE  LYS A  62       4.281   0.906  -7.983  1.00  3.60           C  
ATOM    914  NZ  LYS A  62       3.494   1.202  -6.755  1.00  4.70           N  
ATOM    915  H   LYS A  62       7.990   2.019 -10.503  1.00  0.86           H  
ATOM    916  HA  LYS A  62       6.472   0.423  -8.900  1.00  0.78           H  
ATOM    917  HB2 LYS A  62       5.557   2.245 -10.265  1.00  1.41           H  
ATOM    918  HG2 LYS A  62       3.589   0.877 -11.354  1.00  2.24           H  
ATOM    919  HD2 LYS A  62       3.361   2.250  -9.355  1.00  3.28           H  
ATOM    920  HE2 LYS A  62       4.569  -0.136  -7.973  1.00  3.61           H  
ATOM    921  HZ1 LYS A  62       4.059   0.991  -5.907  1.00  5.05           H  
ATOM    922  HZ2 LYS A  62       2.630   0.621  -6.735  1.00  5.09           H  
ATOM    923  HZ3 LYS A  62       3.222   2.206  -6.738  1.00  5.08           H  
ATOM    924  N   LYS A  63       7.539  -1.223 -11.495  1.00  0.64           N  
ATOM    925  CA  LYS A  63       7.662  -2.552 -12.079  1.00  0.71           C  
ATOM    926  C   LYS A  63       8.646  -3.395 -11.278  1.00  0.63           C  
ATOM    927  O   LYS A  63       8.506  -4.616 -11.185  1.00  0.73           O  
ATOM    928  CB  LYS A  63       8.113  -2.460 -13.539  1.00  0.88           C  
ATOM    929  CG  LYS A  63       9.374  -1.637 -13.738  1.00  0.88           C  
ATOM    930  CD  LYS A  63       9.837  -1.675 -15.187  1.00  1.10           C  
ATOM    931  CE  LYS A  63      10.977  -0.701 -15.433  1.00  1.67           C  
ATOM    932  NZ  LYS A  63      10.551   0.711 -15.238  1.00  2.28           N  
ATOM    933  H   LYS A  63       8.080  -0.491 -11.852  1.00  0.65           H  
ATOM    934  HA  LYS A  63       6.691  -3.023 -12.039  1.00  0.78           H  
ATOM    935  HB2 LYS A  63       8.298  -3.458 -13.909  1.00  0.98           H  
ATOM    936  HG2 LYS A  63       9.172  -0.613 -13.462  1.00  0.84           H  
ATOM    937  HD2 LYS A  63      10.173  -2.673 -15.420  1.00  1.57           H  
ATOM    938  HE2 LYS A  63      11.779  -0.925 -14.745  1.00  2.11           H  
ATOM    939  HZ1 LYS A  63       9.751   0.932 -15.863  1.00  2.66           H  
ATOM    940  HZ2 LYS A  63      11.337   1.355 -15.458  1.00  2.72           H  
ATOM    941  HZ3 LYS A  63      10.259   0.864 -14.250  1.00  2.64           H  
ATOM    942  N   ASP A  64       9.644  -2.734 -10.699  1.00  0.54           N  
ATOM    943  CA  ASP A  64      10.651  -3.416  -9.897  1.00  0.54           C  
ATOM    944  C   ASP A  64      10.044  -3.928  -8.593  1.00  0.46           C  
ATOM    945  O   ASP A  64      10.408  -4.997  -8.106  1.00  0.56           O  
ATOM    946  CB  ASP A  64      11.816  -2.471  -9.594  1.00  0.56           C  
ATOM    947  CG  ASP A  64      12.903  -3.133  -8.769  1.00  1.38           C  
ATOM    948  OD1 ASP A  64      13.814  -3.744  -9.368  1.00  1.49           O  
ATOM    949  OD2 ASP A  64      12.844  -3.040  -7.525  1.00  2.30           O  
ATOM    950  H   ASP A  64       9.704  -1.764 -10.816  1.00  0.56           H  
ATOM    951  HA  ASP A  64      11.018  -4.257 -10.465  1.00  0.64           H  
ATOM    952  HB2 ASP A  64      12.251  -2.137 -10.525  1.00  1.10           H  
ATOM    953  N   LEU A  65       9.113  -3.157  -8.038  1.00  0.39           N  
ATOM    954  CA  LEU A  65       8.452  -3.532  -6.793  1.00  0.41           C  
ATOM    955  C   LEU A  65       7.657  -4.826  -6.963  1.00  0.45           C  
ATOM    956  O   LEU A  65       7.392  -5.534  -5.991  1.00  0.52           O  
ATOM    957  CB  LEU A  65       7.523  -2.412  -6.317  1.00  0.51           C  
ATOM    958  CG  LEU A  65       8.223  -1.212  -5.677  1.00  0.49           C  
ATOM    959  CD1 LEU A  65       8.998  -0.422  -6.719  1.00  0.67           C  
ATOM    960  CD2 LEU A  65       7.212  -0.319  -4.971  1.00  0.70           C  
ATOM    961  H   LEU A  65       8.865  -2.314  -8.476  1.00  0.40           H  
ATOM    962  HA  LEU A  65       9.216  -3.693  -6.048  1.00  0.41           H  
ATOM    963  HB2 LEU A  65       6.955  -2.060  -7.167  1.00  0.54           H  
ATOM    964  HG  LEU A  65       8.927  -1.568  -4.937  1.00  0.71           H  
ATOM    965 HD11 LEU A  65       8.315  -0.047  -7.464  1.00  1.13           H  
ATOM    966 HD12 LEU A  65       9.499   0.408  -6.241  1.00  1.41           H  
ATOM    967 HD13 LEU A  65       9.730  -1.063  -7.187  1.00  1.19           H  
ATOM    968 HD21 LEU A  65       7.724   0.519  -4.522  1.00  1.32           H  
ATOM    969 HD22 LEU A  65       6.491   0.043  -5.688  1.00  1.30           H  
ATOM    970 HD23 LEU A  65       6.706  -0.884  -4.204  1.00  1.04           H  
ATOM    971  N   ALA A  66       7.279  -5.127  -8.201  1.00  0.46           N  
ATOM    972  CA  ALA A  66       6.512  -6.332  -8.496  1.00  0.52           C  
ATOM    973  C   ALA A  66       7.226  -7.581  -7.990  1.00  0.50           C  
ATOM    974  O   ALA A  66       6.587  -8.549  -7.578  1.00  0.66           O  
ATOM    975  CB  ALA A  66       6.256  -6.440  -9.992  1.00  0.60           C  
ATOM    976  H   ALA A  66       7.516  -4.521  -8.935  1.00  0.46           H  
ATOM    977  HA  ALA A  66       5.558  -6.250  -7.998  1.00  0.56           H  
ATOM    978  HB1 ALA A  66       7.195  -6.564 -10.511  1.00  1.20           H  
ATOM    979  HB2 ALA A  66       5.621  -7.293 -10.188  1.00  1.18           H  
ATOM    980  HB3 ALA A  66       5.766  -5.541 -10.340  1.00  1.16           H  
ATOM    981  N   LEU A  67       8.556  -7.556  -8.020  1.00  0.37           N  
ATOM    982  CA  LEU A  67       9.353  -8.692  -7.567  1.00  0.35           C  
ATOM    983  C   LEU A  67       9.538  -8.667  -6.053  1.00  0.31           C  
ATOM    984  O   LEU A  67       9.116  -9.586  -5.352  1.00  0.30           O  
ATOM    985  CB  LEU A  67      10.719  -8.695  -8.256  1.00  0.38           C  
ATOM    986  CG  LEU A  67      10.679  -8.770  -9.784  1.00  0.43           C  
ATOM    987  CD1 LEU A  67      12.088  -8.734 -10.356  1.00  0.48           C  
ATOM    988  CD2 LEU A  67       9.949 -10.028 -10.233  1.00  0.47           C  
ATOM    989  H   LEU A  67       9.011  -6.753  -8.353  1.00  0.37           H  
ATOM    990  HA  LEU A  67       8.824  -9.593  -7.837  1.00  0.37           H  
ATOM    991  HB2 LEU A  67      11.245  -7.793  -7.974  1.00  0.37           H  
ATOM    992  HG  LEU A  67      10.140  -7.915 -10.167  1.00  0.45           H  
ATOM    993 HD11 LEU A  67      12.649  -9.580  -9.986  1.00  1.15           H  
ATOM    994 HD12 LEU A  67      12.038  -8.779 -11.435  1.00  1.08           H  
ATOM    995 HD13 LEU A  67      12.576  -7.819 -10.055  1.00  1.15           H  
ATOM    996 HD21 LEU A  67       8.948 -10.028  -9.826  1.00  1.09           H  
ATOM    997 HD22 LEU A  67       9.901 -10.049 -11.311  1.00  1.10           H  
ATOM    998 HD23 LEU A  67      10.482 -10.898  -9.878  1.00  1.16           H  
ATOM    999  N   ILE A  68      10.167  -7.608  -5.554  1.00  0.31           N  
ATOM   1000  CA  ILE A  68      10.412  -7.471  -4.125  1.00  0.30           C  
ATOM   1001  C   ILE A  68       9.104  -7.331  -3.353  1.00  0.30           C  
ATOM   1002  O   ILE A  68       8.149  -6.723  -3.838  1.00  0.37           O  
ATOM   1003  CB  ILE A  68      11.308  -6.254  -3.825  1.00  0.34           C  
ATOM   1004  CG1 ILE A  68      10.635  -4.967  -4.304  1.00  0.38           C  
ATOM   1005  CG2 ILE A  68      12.668  -6.423  -4.483  1.00  0.38           C  
ATOM   1006  CD1 ILE A  68      11.481  -3.731  -4.094  1.00  0.43           C  
ATOM   1007  H   ILE A  68      10.475  -6.905  -6.163  1.00  0.34           H  
ATOM   1008  HA  ILE A  68      10.925  -8.361  -3.787  1.00  0.30           H  
ATOM   1009  HB  ILE A  68      11.456  -6.199  -2.757  1.00  0.34           H  
ATOM   1010 HG12 ILE A  68      10.426  -5.051  -5.360  1.00  0.40           H  
ATOM   1011 HG21 ILE A  68      12.545  -6.502  -5.552  1.00  1.00           H  
ATOM   1012 HG22 ILE A  68      13.287  -5.566  -4.254  1.00  1.00           H  
ATOM   1013 HG23 ILE A  68      13.142  -7.318  -4.108  1.00  1.07           H  
ATOM   1014 HD11 ILE A  68      10.927  -2.858  -4.406  1.00  1.08           H  
ATOM   1015 HD12 ILE A  68      11.733  -3.640  -3.048  1.00  1.12           H  
ATOM   1016 HD13 ILE A  68      12.386  -3.810  -4.677  1.00  1.12           H  
ATOM   1017  N   GLU A  69       9.067  -7.901  -2.154  1.00  0.29           N  
ATOM   1018  CA  GLU A  69       7.874  -7.845  -1.318  1.00  0.32           C  
ATOM   1019  C   GLU A  69       7.938  -6.660  -0.360  1.00  0.31           C  
ATOM   1020  O   GLU A  69       9.021  -6.191  -0.009  1.00  0.37           O  
ATOM   1021  CB  GLU A  69       7.719  -9.147  -0.529  1.00  0.34           C  
ATOM   1022  CG  GLU A  69       6.357  -9.305   0.124  1.00  0.44           C  
ATOM   1023  CD  GLU A  69       6.191 -10.647   0.807  1.00  1.30           C  
ATOM   1024  OE1 GLU A  69       6.567 -10.762   1.994  1.00  2.29           O  
ATOM   1025  OE2 GLU A  69       5.688 -11.587   0.156  1.00  1.26           O  
ATOM   1026  H   GLU A  69       9.862  -8.369  -1.821  1.00  0.30           H  
ATOM   1027  HA  GLU A  69       7.019  -7.723  -1.966  1.00  0.35           H  
ATOM   1028  HB2 GLU A  69       7.877  -9.979  -1.197  1.00  0.35           H  
ATOM   1029  HG2 GLU A  69       6.230  -8.526   0.860  1.00  1.00           H  
ATOM   1030  N   LEU A  70       6.773  -6.180   0.061  1.00  0.32           N  
ATOM   1031  CA  LEU A  70       6.699  -5.047   0.976  1.00  0.33           C  
ATOM   1032  C   LEU A  70       5.755  -5.342   2.138  1.00  0.33           C  
ATOM   1033  O   LEU A  70       4.781  -6.079   1.990  1.00  0.45           O  
ATOM   1034  CB  LEU A  70       6.230  -3.793   0.234  1.00  0.38           C  
ATOM   1035  CG  LEU A  70       7.125  -3.353  -0.927  1.00  0.95           C  
ATOM   1036  CD1 LEU A  70       6.535  -2.134  -1.620  1.00  1.25           C  
ATOM   1037  CD2 LEU A  70       8.534  -3.056  -0.433  1.00  1.85           C  
ATOM   1038  H   LEU A  70       5.941  -6.599  -0.249  1.00  0.37           H  
ATOM   1039  HA  LEU A  70       7.691  -4.873   1.368  1.00  0.35           H  
ATOM   1040  HB2 LEU A  70       5.240  -3.980  -0.155  1.00  0.72           H  
ATOM   1041  HG  LEU A  70       7.184  -4.151  -1.652  1.00  1.72           H  
ATOM   1042 HD11 LEU A  70       5.557  -2.379  -2.008  1.00  1.77           H  
ATOM   1043 HD12 LEU A  70       6.447  -1.324  -0.912  1.00  1.79           H  
ATOM   1044 HD13 LEU A  70       7.179  -1.834  -2.433  1.00  1.66           H  
ATOM   1045 HD21 LEU A  70       8.942  -3.938   0.040  1.00  2.39           H  
ATOM   1046 HD22 LEU A  70       9.155  -2.774  -1.268  1.00  2.36           H  
ATOM   1047 HD23 LEU A  70       8.502  -2.246   0.282  1.00  2.28           H  
ATOM   1048  N   GLU A  71       6.051  -4.757   3.294  1.00  0.35           N  
ATOM   1049  CA  GLU A  71       5.230  -4.950   4.482  1.00  0.38           C  
ATOM   1050  C   GLU A  71       4.968  -3.621   5.179  1.00  0.37           C  
ATOM   1051  O   GLU A  71       5.891  -2.976   5.675  1.00  0.52           O  
ATOM   1052  CB  GLU A  71       5.908  -5.923   5.450  1.00  0.47           C  
ATOM   1053  CG  GLU A  71       5.125  -6.144   6.733  1.00  0.54           C  
ATOM   1054  CD  GLU A  71       5.807  -7.118   7.676  1.00  1.31           C  
ATOM   1055  OE1 GLU A  71       6.624  -6.666   8.506  1.00  2.24           O  
ATOM   1056  OE2 GLU A  71       5.524  -8.331   7.583  1.00  1.26           O  
ATOM   1057  H   GLU A  71       6.845  -4.183   3.349  1.00  0.43           H  
ATOM   1058  HA  GLU A  71       4.287  -5.370   4.166  1.00  0.42           H  
ATOM   1059  HB2 GLU A  71       6.030  -6.876   4.959  1.00  0.53           H  
ATOM   1060  HG2 GLU A  71       5.013  -5.197   7.241  1.00  1.00           H  
ATOM   1061  N   ALA A  72       3.702  -3.214   5.210  1.00  0.45           N  
ATOM   1062  CA  ALA A  72       3.321  -1.959   5.845  1.00  0.52           C  
ATOM   1063  C   ALA A  72       3.646  -1.978   7.334  1.00  0.44           C  
ATOM   1064  O   ALA A  72       3.555  -3.016   7.990  1.00  0.53           O  
ATOM   1065  CB  ALA A  72       1.840  -1.687   5.630  1.00  0.76           C  
ATOM   1066  H   ALA A  72       3.010  -3.770   4.796  1.00  0.58           H  
ATOM   1067  HA  ALA A  72       3.881  -1.164   5.376  1.00  0.58           H  
ATOM   1068  HB1 ALA A  72       1.258  -2.469   6.096  1.00  1.26           H  
ATOM   1069  HB2 ALA A  72       1.582  -0.735   6.071  1.00  1.30           H  
ATOM   1070  HB3 ALA A  72       1.628  -1.663   4.572  1.00  1.34           H  
ATOM   1071  N   VAL A  73       4.030  -0.820   7.863  1.00  0.58           N  
ATOM   1072  CA  VAL A  73       4.367  -0.699   9.276  1.00  0.64           C  
ATOM   1073  C   VAL A  73       3.179  -1.062  10.159  1.00  0.83           C  
ATOM   1074  O   VAL A  73       2.110  -1.420   9.665  1.00  0.99           O  
ATOM   1075  CB  VAL A  73       4.833   0.725   9.623  1.00  0.78           C  
ATOM   1076  CG1 VAL A  73       6.125   1.056   8.890  1.00  1.01           C  
ATOM   1077  CG2 VAL A  73       3.751   1.740   9.288  1.00  1.16           C  
ATOM   1078  H   VAL A  73       4.089  -0.028   7.289  1.00  0.78           H  
ATOM   1079  HA  VAL A  73       5.179  -1.382   9.485  1.00  0.66           H  
ATOM   1080  HB  VAL A  73       5.027   0.772  10.684  1.00  0.90           H  
ATOM   1081 HG11 VAL A  73       5.962   0.990   7.825  1.00  1.40           H  
ATOM   1082 HG12 VAL A  73       6.438   2.057   9.146  1.00  1.45           H  
ATOM   1083 HG13 VAL A  73       6.893   0.354   9.179  1.00  1.65           H  
ATOM   1084 HG21 VAL A  73       2.847   1.492   9.826  1.00  1.42           H  
ATOM   1085 HG22 VAL A  73       4.081   2.728   9.574  1.00  1.62           H  
ATOM   1086 HG23 VAL A  73       3.553   1.719   8.227  1.00  1.76           H  
ATOM   1087  N   ALA A  74       3.373  -0.965  11.470  1.00  0.99           N  
ATOM   1088  CA  ALA A  74       2.318  -1.285  12.424  1.00  1.25           C  
ATOM   1089  C   ALA A  74       1.476  -0.057  12.748  1.00  1.66           C  
ATOM   1090  O   ALA A  74       1.886   0.801  13.529  1.00  2.28           O  
ATOM   1091  CB  ALA A  74       2.917  -1.868  13.695  1.00  1.57           C  
ATOM   1092  H   ALA A  74       4.247  -0.672  11.804  1.00  1.02           H  
ATOM   1093  HA  ALA A  74       1.684  -2.037  11.976  1.00  1.32           H  
ATOM   1094  HB1 ALA A  74       3.512  -2.734  13.448  1.00  2.22           H  
ATOM   1095  HB2 ALA A  74       3.539  -1.126  14.173  1.00  1.69           H  
ATOM   1096  HB3 ALA A  74       2.122  -2.156  14.367  1.00  1.93           H  
ATOM   1097  N   GLN A  75       0.295   0.022  12.140  1.00  1.95           N  
ATOM   1098  CA  GLN A  75      -0.607   1.144  12.369  1.00  2.53           C  
ATOM   1099  C   GLN A  75      -0.964   1.261  13.847  1.00  2.88           C  
ATOM   1100  O   GLN A  75      -1.199   0.256  14.520  1.00  3.14           O  
ATOM   1101  CB  GLN A  75      -1.879   0.977  11.537  1.00  3.27           C  
ATOM   1102  CG  GLN A  75      -1.625   0.946  10.038  1.00  3.83           C  
ATOM   1103  CD  GLN A  75      -0.984   2.223   9.531  1.00  4.50           C  
ATOM   1104  OE1 GLN A  75      -1.673   3.167   9.143  1.00  4.86           O  
ATOM   1105  NE2 GLN A  75       0.344   2.260   9.533  1.00  5.13           N  
ATOM   1106  H   GLN A  75       0.027  -0.690  11.524  1.00  2.15           H  
ATOM   1107  HA  GLN A  75      -0.100   2.046  12.060  1.00  2.76           H  
ATOM   1108  HB2 GLN A  75      -2.361   0.053  11.817  1.00  3.74           H  
ATOM   1109  HG2 GLN A  75      -0.968   0.120   9.814  1.00  4.02           H  
ATOM   1110 HE21 GLN A  75       0.829   1.472   9.856  1.00  5.14           H  
ATOM   1111 HE22 GLN A  75       0.785   3.073   9.210  1.00  5.77           H  
TER    1112      GLN A  75                                                      
END
MOLECULE T0462_1_74.pdb
ATOM      1  C   MET     1       3.518  -5.525  -1.015  1.00 72.54           C 
ATOM      2  O   MET     1       4.514  -5.922  -0.421  1.00 61.43           O 
ATOM      3  N   MET     1       1.797  -7.249  -0.416  1.00 62.03           N 
ATOM      4  CA  MET     1       2.106  -5.791  -0.468  1.00  1.42           C 
ATOM      5  CB  MET     1       1.945  -5.166   0.931  1.00  3.15           C 
ATOM      6  CG  MET     1       2.652  -3.826   1.103  1.00 20.23           C 
ATOM      7  SD  MET     1       2.005  -2.537   0.021  1.00  4.24           S 
ATOM      8  CE  MET     1       0.587  -1.980   0.962  1.00 12.22           C 
ATOM      9 1H   MET     1       2.447  -7.731   0.242  1.00 36.29           H 
ATOM     10 2H   MET     1       1.909  -7.674  -1.357  1.00 36.29           H 
ATOM     11 3H   MET     1       0.818  -7.396  -0.095  1.00 36.29           H 
ATOM     12  HA  MET     1       1.390  -5.330  -1.136  1.00  4.22           H 
ATOM     13 3HB  MET     1       2.337  -5.854   1.668  1.00 36.29           H 
ATOM     14 2HB  MET     1       0.892  -5.015   1.123  1.00 36.29           H 
ATOM     15 3HG  MET     1       3.702  -3.962   0.888  1.00 36.29           H 
ATOM     16 2HG  MET     1       2.538  -3.502   2.127  1.00 36.29           H 
ATOM     17 1HE  MET     1      -0.112  -2.794   1.079  1.00 36.29           H 
ATOM     18 2HE  MET     1       0.108  -1.165   0.439  1.00 36.29           H 
ATOM     19 3HE  MET     1       0.911  -1.640   1.935  1.00 36.29           H 
ATOM     20  N   LYS     2       3.591  -4.846  -2.158  1.00  4.01           N 
ATOM     21  CA  LYS     2       4.874  -4.436  -2.746  1.00 14.04           C 
ATOM     22  C   LYS     2       5.042  -2.911  -2.669  1.00 71.54           C 
ATOM     23  O   LYS     2       4.069  -2.166  -2.787  1.00  5.03           O 
ATOM     24  CB  LYS     2       4.982  -4.912  -4.207  1.00 41.30           C 
ATOM     25  CG  LYS     2       5.651  -6.277  -4.378  1.00 35.55           C 
ATOM     26  CD  LYS     2       4.888  -7.412  -3.703  1.00 24.21           C 
ATOM     27  CE  LYS     2       5.601  -8.746  -3.913  1.00 54.20           C 
ATOM     28  NZ  LYS     2       4.888  -9.880  -3.264  1.00 23.11           N 
ATOM     29  H   LYS     2       2.763  -4.602  -2.617  1.00 36.29           H 
ATOM     30  HA  LYS     2       5.666  -4.897  -2.168  1.00 52.45           H 
ATOM     31 3HB  LYS     2       5.556  -4.188  -4.770  1.00 36.29           H 
ATOM     32 2HB  LYS     2       3.989  -4.969  -4.631  1.00 36.29           H 
ATOM     33 3HG  LYS     2       6.647  -6.227  -3.957  1.00 36.29           H 
ATOM     34 2HG  LYS     2       5.724  -6.494  -5.433  1.00 36.29           H 
ATOM     35 3HD  LYS     2       3.895  -7.473  -4.126  1.00 36.29           H 
ATOM     36 2HD  LYS     2       4.822  -7.212  -2.644  1.00 36.29           H 
ATOM     37 3HE  LYS     2       6.597  -8.675  -3.499  1.00 36.29           H 
ATOM     38 2HE  LYS     2       5.669  -8.940  -4.973  1.00 36.29           H 
ATOM     39 1HZ  LYS     2       4.773  -9.696  -2.246  1.00 36.29           H 
ATOM     40 2HZ  LYS     2       5.434 -10.759  -3.385  1.00 36.29           H 
ATOM     41 3HZ  LYS     2       3.951 -10.007  -3.690  1.00 36.29           H 
ATOM     42  N   LEU     3       6.279  -2.445  -2.492  1.00 54.05           N 
ATOM     43  CA  LEU     3       6.551  -1.006  -2.322  1.00 12.34           C 
ATOM     44  C   LEU     3       6.221  -0.190  -3.591  1.00 75.43           C 
ATOM     45  O   LEU     3       6.193   1.039  -3.556  1.00 30.52           O 
ATOM     46  CB  LEU     3       8.016  -0.794  -1.890  1.00 44.12           C 
ATOM     47  CG  LEU     3       9.093  -1.161  -2.934  1.00 51.02           C 
ATOM     48  CD1 LEU     3       9.466   0.048  -3.795  1.00 31.15           C 
ATOM     49  CD2 LEU     3      10.332  -1.742  -2.258  1.00 12.10           C 
ATOM     50  H   LEU     3       7.028  -3.081  -2.468  1.00 36.29           H 
ATOM     51  HA  LEU     3       5.909  -0.654  -1.524  1.00 75.20           H 
ATOM     52 3HB  LEU     3       8.188  -1.389  -1.004  1.00 36.29           H 
ATOM     53 2HB  LEU     3       8.140   0.246  -1.624  1.00 36.29           H 
ATOM     54  HG  LEU     3       8.695  -1.919  -3.597  1.00 53.15           H 
ATOM     55 1HD1 LEU     3       9.859   0.832  -3.164  1.00 36.29           H 
ATOM     56 2HD1 LEU     3       8.590   0.408  -4.313  1.00 36.29           H 
ATOM     57 3HD1 LEU     3      10.216  -0.241  -4.517  1.00 36.29           H 
ATOM     58 1HD2 LEU     3      11.058  -2.020  -3.009  1.00 36.29           H 
ATOM     59 2HD2 LEU     3      10.056  -2.616  -1.686  1.00 36.29           H 
ATOM     60 3HD2 LEU     3      10.765  -1.004  -1.598  1.00 36.29           H 
ATOM     61  N   SER     4       5.945  -0.883  -4.701  1.00  4.23           N 
ATOM     62  CA  SER     4       5.589  -0.227  -5.974  1.00 32.21           C 
ATOM     63  C   SER     4       4.229   0.480  -5.900  1.00 20.35           C 
ATOM     64  O   SER     4       3.854   1.213  -6.814  1.00 13.44           O 
ATOM     65  CB  SER     4       5.543  -1.258  -7.115  1.00 23.31           C 
ATOM     66  OG  SER     4       4.601  -2.291  -6.849  1.00 33.45           O 
ATOM     67  H   SER     4       5.981  -1.860  -4.667  1.00 36.29           H 
ATOM     68  HA  SER     4       6.351   0.505  -6.197  1.00  2.13           H 
ATOM     69 3HB  SER     4       6.518  -1.702  -7.235  1.00 36.29           H 
ATOM     70 2HB  SER     4       5.263  -0.764  -8.033  1.00 36.29           H 
ATOM     71  HG  SER     4       4.753  -3.024  -7.464  1.00 23.50           H 
ATOM     72  N   ARG     5       3.493   0.245  -4.816  1.00 74.24           N 
ATOM     73  CA  ARG     5       2.136   0.783  -4.660  1.00 65.23           C 
ATOM     74  C   ARG     5       1.911   1.351  -3.250  1.00 50.53           C 
ATOM     75  O   ARG     5       0.779   1.617  -2.853  1.00  3.14           O 
ATOM     76  CB  ARG     5       1.136  -0.345  -4.937  1.00 32.44           C 
ATOM     77  CG  ARG     5       1.216  -1.485  -3.918  1.00 60.24           C 
ATOM     78  CD  ARG     5       0.735  -2.805  -4.499  1.00 44.11           C 
ATOM     79  NE  ARG     5       1.633  -3.289  -5.550  1.00 13.55           N 
ATOM     80  CZ  ARG     5       1.739  -4.539  -5.905  1.00 12.44           C 
ATOM     81  NH1 ARG     5       0.990  -5.444  -5.364  1.00 63.34           N 
ATOM     82  NH2 ARG     5       2.586  -4.888  -6.812  1.00 21.53           N 
ATOM     83  H   ARG     5       3.864  -0.317  -4.107  1.00 36.29           H 
ATOM     84  HA  ARG     5       1.992   1.572  -5.386  1.00 64.21           H 
ATOM     85 3HB  ARG     5       1.332  -0.751  -5.919  1.00 36.29           H 
ATOM     86 2HB  ARG     5       0.133   0.062  -4.919  1.00 36.29           H 
ATOM     87 3HG  ARG     5       0.606  -1.234  -3.062  1.00 36.29           H 
ATOM     88 2HG  ARG     5       2.244  -1.601  -3.602  1.00 36.29           H 
ATOM     89 3HD  ARG     5      -0.252  -2.667  -4.916  1.00 36.29           H 
ATOM     90 2HD  ARG     5       0.692  -3.538  -3.704  1.00 36.29           H 
ATOM     91  HE  ARG     5       2.201  -2.632  -5.999  1.00 75.30           H 
ATOM     92 1HH1 ARG     5       0.323  -5.193  -4.674  1.00 36.29           H 
ATOM     93 2HH1 ARG     5       1.098  -6.403  -5.639  1.00 36.29           H 
ATOM     94 1HH2 ARG     5       3.168  -4.207  -7.248  1.00 36.29           H 
ATOM     95 2HH2 ARG     5       2.657  -5.850  -7.075  1.00 36.29           H 
ATOM     96  N   LEU     6       2.994   1.542  -2.504  1.00 24.41           N 
ATOM     97  CA  LEU     6       2.903   1.977  -1.106  1.00 73.40           C 
ATOM     98  C   LEU     6       2.620   3.487  -1.005  1.00 51.45           C 
ATOM     99  O   LEU     6       3.285   4.299  -1.650  1.00 72.11           O 
ATOM    100  CB  LEU     6       4.204   1.628  -0.365  1.00 50.13           C 
ATOM    101  CG  LEU     6       4.178   1.842   1.158  1.00 51.54           C 
ATOM    102  CD1 LEU     6       3.193   0.885   1.826  1.00 34.05           C 
ATOM    103  CD2 LEU     6       5.578   1.679   1.747  1.00 44.04           C 
ATOM    104  H   LEU     6       3.878   1.408  -2.906  1.00 36.29           H 
ATOM    105  HA  LEU     6       2.084   1.437  -0.646  1.00 14.43           H 
ATOM    106 3HB  LEU     6       5.001   2.232  -0.778  1.00 36.29           H 
ATOM    107 2HB  LEU     6       4.434   0.589  -0.557  1.00 36.29           H 
ATOM    108  HG  LEU     6       3.846   2.847   1.364  1.00 12.14           H 
ATOM    109 1HD1 LEU     6       3.477  -0.136   1.615  1.00 36.29           H 
ATOM    110 2HD1 LEU     6       2.198   1.068   1.446  1.00 36.29           H 
ATOM    111 3HD1 LEU     6       3.202   1.047   2.895  1.00 36.29           H 
ATOM    112 1HD2 LEU     6       6.248   2.391   1.286  1.00 36.29           H 
ATOM    113 2HD2 LEU     6       5.935   0.676   1.561  1.00 36.29           H 
ATOM    114 3HD2 LEU     6       5.545   1.855   2.812  1.00 36.29           H 
ATOM    115  N   VAL     7       1.629   3.852  -0.188  1.00 44.11           N 
ATOM    116  CA  VAL     7       1.229   5.255  -0.013  1.00 52.30           C 
ATOM    117  C   VAL     7       2.399   6.130   0.495  1.00 41.41           C 
ATOM    118  O   VAL     7       2.938   5.888   1.576  1.00 15.11           O 
ATOM    119  CB  VAL     7       0.034   5.378   0.975  1.00 14.11           C 
ATOM    120  CG1 VAL     7      -0.397   6.838   1.141  1.00 51.14           C 
ATOM    121  CG2 VAL     7      -1.143   4.512   0.514  1.00 52.40           C 
ATOM    122  H   VAL     7       1.148   3.158   0.308  1.00 36.29           H 
ATOM    123  HA  VAL     7       0.906   5.628  -0.977  1.00 34.04           H 
ATOM    124  HB  VAL     7       0.357   5.016   1.940  1.00 41.14           H 
ATOM    125 1HG1 VAL     7       0.428   7.416   1.532  1.00 36.29           H 
ATOM    126 2HG1 VAL     7      -1.230   6.895   1.828  1.00 36.29           H 
ATOM    127 3HG1 VAL     7      -0.695   7.239   0.183  1.00 36.29           H 
ATOM    128 1HG2 VAL     7      -1.458   4.821  -0.472  1.00 36.29           H 
ATOM    129 2HG2 VAL     7      -1.969   4.620   1.205  1.00 36.29           H 
ATOM    130 3HG2 VAL     7      -0.837   3.475   0.483  1.00 36.29           H 
ATOM    131  N   PRO     8       2.802   7.162  -0.282  1.00 23.31           N 
ATOM    132  CA  PRO     8       3.902   8.073   0.102  1.00 61.14           C 
ATOM    133  C   PRO     8       3.752   8.648   1.526  1.00 24.12           C 
ATOM    134  O   PRO     8       2.852   9.448   1.798  1.00 15.04           O 
ATOM    135  CB  PRO     8       3.814   9.190  -0.945  1.00 34.35           C 
ATOM    136  CG  PRO     8       3.204   8.534  -2.139  1.00 22.30           C 
ATOM    137  CD  PRO     8       2.231   7.517  -1.600  1.00  0.40           C 
ATOM    138  HA  PRO     8       4.861   7.578   0.020  1.00 12.00           H 
ATOM    139 3HB  PRO     8       4.805   9.565  -1.163  1.00 36.29           H 
ATOM    140 2HB  PRO     8       3.192   9.995  -0.574  1.00 36.29           H 
ATOM    141 3HG  PRO     8       3.972   8.047  -2.723  1.00 36.29           H 
ATOM    142 2HG  PRO     8       2.688   9.271  -2.741  1.00 36.29           H 
ATOM    143 3HD  PRO     8       2.188   6.653  -2.248  1.00 36.29           H 
ATOM    144 2HD  PRO     8       1.247   7.955  -1.487  1.00 36.29           H 
ATOM    145  N   GLY     9       4.646   8.240   2.428  1.00 12.24           N 
ATOM    146  CA  GLY     9       4.576   8.671   3.823  1.00 71.12           C 
ATOM    147  C   GLY     9       4.364   7.512   4.795  1.00 14.14           C 
ATOM    148  O   GLY     9       4.726   7.604   5.970  1.00 53.41           O 
ATOM    149  H   GLY     9       5.370   7.646   2.142  1.00 36.29           H 
ATOM    150 3HA  GLY     9       3.761   9.374   3.939  1.00 36.29           H 
ATOM    151 2HA  GLY     9       5.501   9.170   4.077  1.00 36.29           H 
ATOM    152  N   VAL    10       3.778   6.423   4.305  1.00 64.52           N 
ATOM    153  CA  VAL    10       3.529   5.234   5.129  1.00 45.04           C 
ATOM    154  C   VAL    10       4.758   4.303   5.157  1.00 22.22           C 
ATOM    155  O   VAL    10       5.238   3.867   4.110  1.00 13.40           O 
ATOM    156  CB  VAL    10       2.297   4.444   4.613  1.00 32.21           C 
ATOM    157  CG1 VAL    10       2.049   3.193   5.455  1.00 62.22           C 
ATOM    158  CG2 VAL    10       1.055   5.336   4.592  1.00 12.32           C 
ATOM    159  H   VAL    10       3.505   6.412   3.362  1.00 36.29           H 
ATOM    160  HA  VAL    10       3.317   5.568   6.137  1.00 21.15           H 
ATOM    161  HB  VAL    10       2.500   4.129   3.598  1.00 63.25           H 
ATOM    162 1HG1 VAL    10       2.906   2.536   5.390  1.00 36.29           H 
ATOM    163 2HG1 VAL    10       1.175   2.678   5.086  1.00 36.29           H 
ATOM    164 3HG1 VAL    10       1.891   3.477   6.486  1.00 36.29           H 
ATOM    165 1HG2 VAL    10       1.226   6.180   3.939  1.00 36.29           H 
ATOM    166 2HG2 VAL    10       0.848   5.693   5.591  1.00 36.29           H 
ATOM    167 3HG2 VAL    10       0.208   4.769   4.231  1.00 36.29           H 
ATOM    168  N   PRO    11       5.292   3.994   6.358  1.00 14.03           N 
ATOM    169  CA  PRO    11       6.452   3.097   6.503  1.00  4.53           C 
ATOM    170  C   PRO    11       6.083   1.603   6.412  1.00 14.25           C 
ATOM    171  O   PRO    11       5.083   1.156   6.985  1.00  4.44           O 
ATOM    172  CB  PRO    11       6.970   3.443   7.903  1.00  4.12           C 
ATOM    173  CG  PRO    11       5.750   3.846   8.664  1.00 24.22           C 
ATOM    174  CD  PRO    11       4.824   4.503   7.666  1.00 63.44           C 
ATOM    175  HA  PRO    11       7.216   3.321   5.770  1.00 72.10           H 
ATOM    176 3HB  PRO    11       7.681   4.255   7.839  1.00 36.29           H 
ATOM    177 2HB  PRO    11       7.448   2.577   8.344  1.00 36.29           H 
ATOM    178 3HG  PRO    11       6.016   4.544   9.446  1.00 36.29           H 
ATOM    179 2HG  PRO    11       5.278   2.971   9.091  1.00 36.29           H 
ATOM    180 3HD  PRO    11       4.918   5.580   7.713  1.00 36.29           H 
ATOM    181 2HD  PRO    11       3.801   4.208   7.848  1.00 36.29           H 
ATOM    182  N   ALA    12       6.901   0.833   5.695  1.00 41.23           N 
ATOM    183  CA  ALA    12       6.690  -0.613   5.558  1.00 13.34           C 
ATOM    184  C   ALA    12       7.997  -1.397   5.764  1.00  4.20           C 
ATOM    185  O   ALA    12       9.063  -0.956   5.350  1.00 53.40           O 
ATOM    186  CB  ALA    12       6.088  -0.931   4.194  1.00 41.20           C 
ATOM    187  H   ALA    12       7.663   1.249   5.235  1.00 36.29           H 
ATOM    188  HA  ALA    12       5.982  -0.919   6.316  1.00 70.54           H 
ATOM    189 1HB  ALA    12       5.158  -0.392   4.074  1.00 36.29           H 
ATOM    190 2HB  ALA    12       5.896  -1.992   4.123  1.00 36.29           H 
ATOM    191 3HB  ALA    12       6.777  -0.637   3.414  1.00 36.29           H 
ATOM    192  N   ARG    13       7.913  -2.563   6.401  1.00 12.42           N 
ATOM    193  CA  ARG    13       9.106  -3.379   6.672  1.00 30.40           C 
ATOM    194  C   ARG    13       9.311  -4.451   5.585  1.00 42.44           C 
ATOM    195  O   ARG    13       8.356  -5.085   5.137  1.00 71.15           O 
ATOM    196  CB  ARG    13       8.995  -4.049   8.052  1.00 72.24           C 
ATOM    197  CG  ARG    13      10.269  -4.777   8.486  1.00 32.23           C 
ATOM    198  CD  ARG    13      10.105  -5.477   9.834  1.00 34.44           C 
ATOM    199  NE  ARG    13       9.133  -6.570   9.779  1.00  2.45           N 
ATOM    200  CZ  ARG    13       9.006  -7.486  10.701  1.00 54.22           C 
ATOM    201  NH1 ARG    13       9.728  -7.455  11.775  1.00 63.05           N 
ATOM    202  NH2 ARG    13       8.138  -8.429  10.548  1.00 72.55           N 
ATOM    203  H   ARG    13       7.037  -2.881   6.699  1.00 36.29           H 
ATOM    204  HA  ARG    13       9.964  -2.722   6.673  1.00 11.40           H 
ATOM    205 3HB  ARG    13       8.186  -4.765   8.031  1.00 36.29           H 
ATOM    206 2HB  ARG    13       8.770  -3.290   8.790  1.00 36.29           H 
ATOM    207 3HG  ARG    13      11.071  -4.056   8.562  1.00 36.29           H 
ATOM    208 2HG  ARG    13      10.522  -5.516   7.739  1.00 36.29           H 
ATOM    209 3HD  ARG    13       9.774  -4.752  10.565  1.00 36.29           H 
ATOM    210 2HD  ARG    13      11.064  -5.876  10.137  1.00 36.29           H 
ATOM    211  HE  ARG    13       8.548  -6.622   8.997  1.00 22.44           H 
ATOM    212 1HH1 ARG    13      10.393  -6.725  11.911  1.00 36.29           H 
ATOM    213 2HH1 ARG    13       9.621  -8.166  12.464  1.00 36.29           H 
ATOM    214 1HH2 ARG    13       7.567  -8.450   9.727  1.00 36.29           H 
ATOM    215 2HH2 ARG    13       8.039  -9.133  11.247  1.00 36.29           H 
ATOM    216  N   ILE    14      10.561  -4.637   5.169  1.00  2.55           N 
ATOM    217  CA  ILE    14      10.908  -5.622   4.137  1.00 71.42           C 
ATOM    218  C   ILE    14      10.714  -7.064   4.644  1.00 32.34           C 
ATOM    219  O   ILE    14      11.498  -7.544   5.470  1.00 73.21           O 
ATOM    220  CB  ILE    14      12.389  -5.463   3.688  1.00  2.42           C 
ATOM    221  CG1 ILE    14      12.711  -4.005   3.309  1.00  2.21           C 
ATOM    222  CG2 ILE    14      12.702  -6.398   2.519  1.00 12.31           C 
ATOM    223  CD1 ILE    14      11.972  -3.496   2.095  1.00 64.15           C 
ATOM    224  H   ILE    14      11.275  -4.094   5.564  1.00 36.29           H 
ATOM    225  HA  ILE    14      10.269  -5.456   3.280  1.00 32.01           H 
ATOM    226  HB  ILE    14      13.020  -5.753   4.517  1.00 63.30           H 
ATOM    227 3HG1 ILE    14      13.770  -3.920   3.110  1.00 36.29           H 
ATOM    228 2HG1 ILE    14      12.456  -3.363   4.137  1.00 36.29           H 
ATOM    229 1HG2 ILE    14      13.728  -6.259   2.211  1.00 36.29           H 
ATOM    230 2HG2 ILE    14      12.045  -6.174   1.692  1.00 36.29           H 
ATOM    231 3HG2 ILE    14      12.555  -7.422   2.829  1.00 36.29           H 
ATOM    232 1HD1 ILE    14      12.188  -4.129   1.247  1.00 36.29           H 
ATOM    233 2HD1 ILE    14      12.290  -2.487   1.880  1.00 36.29           H 
ATOM    234 3HD1 ILE    14      10.910  -3.504   2.288  1.00 36.29           H 
ATOM    235  N   LYS    15       9.680  -7.754   4.151  1.00 65.45           N 
ATOM    236  CA  LYS    15       9.479  -9.174   4.480  1.00  5.15           C 
ATOM    237  C   LYS    15      10.547 -10.041   3.798  1.00  4.03           C 
ATOM    238  O   LYS    15      11.325 -10.733   4.452  1.00 71.41           O 
ATOM    239  CB  LYS    15       8.097  -9.690   4.028  1.00  1.11           C 
ATOM    240  CG  LYS    15       6.882  -9.032   4.682  1.00 65.44           C 
ATOM    241  CD  LYS    15       5.621  -9.866   4.421  1.00 23.12           C 
ATOM    242  CE  LYS    15       4.339  -9.190   4.899  1.00 73.24           C 
ATOM    243  NZ  LYS    15       3.909  -8.093   3.990  1.00 33.12           N 
ATOM    244  H   LYS    15       9.045  -7.304   3.555  1.00 36.29           H 
ATOM    245  HA  LYS    15       9.566  -9.286   5.552  1.00 63.34           H 
ATOM    246 3HB  LYS    15       8.050 -10.753   4.233  1.00 36.29           H 
ATOM    247 2HB  LYS    15       8.012  -9.547   2.960  1.00 36.29           H 
ATOM    248 3HG  LYS    15       6.747  -8.043   4.265  1.00 36.29           H 
ATOM    249 2HG  LYS    15       7.047  -8.962   5.748  1.00 36.29           H 
ATOM    250 3HD  LYS    15       5.723 -10.815   4.931  1.00 36.29           H 
ATOM    251 2HD  LYS    15       5.537 -10.042   3.359  1.00 36.29           H 
ATOM    252 3HE  LYS    15       4.506  -8.783   5.886  1.00 36.29           H 
ATOM    253 2HE  LYS    15       3.552  -9.928   4.946  1.00 36.29           H 
ATOM    254 1HZ  LYS    15       3.748  -8.461   3.031  1.00 36.29           H 
ATOM    255 2HZ  LYS    15       4.635  -7.356   3.943  1.00 36.29           H 
ATOM    256 3HZ  LYS    15       3.022  -7.670   4.334  1.00 36.29           H 
ATOM    257  N   ARG    16      10.573  -9.985   2.465  1.00 53.12           N 
ATOM    258  CA  ARG    16      11.427 -10.869   1.666  1.00 72.13           C 
ATOM    259  C   ARG    16      11.640 -10.326   0.242  1.00 25.20           C 
ATOM    260  O   ARG    16      10.906  -9.449  -0.219  1.00 32.24           O 
ATOM    261  CB  ARG    16      10.792 -12.264   1.587  1.00 52.01           C 
ATOM    262  CG  ARG    16       9.361 -12.243   1.052  1.00 71.01           C 
ATOM    263  CD  ARG    16       8.743 -13.634   1.005  1.00 61.23           C 
ATOM    264  NE  ARG    16       9.381 -14.498   0.011  1.00 72.42           N 
ATOM    265  CZ  ARG    16       8.831 -15.579  -0.473  1.00 20.34           C 
ATOM    266  NH1 ARG    16       7.664 -15.966  -0.065  1.00 12.04           N 
ATOM    267  NH2 ARG    16       9.452 -16.283  -1.360  1.00 11.42           N 
ATOM    268  H   ARG    16      10.005  -9.329   2.006  1.00 36.29           H 
ATOM    269  HA  ARG    16      12.385 -10.946   2.160  1.00 73.44           H 
ATOM    270 3HB  ARG    16      10.778 -12.699   2.577  1.00 36.29           H 
ATOM    271 2HB  ARG    16      11.392 -12.887   0.939  1.00 36.29           H 
ATOM    272 3HG  ARG    16       9.370 -11.828   0.052  1.00 36.29           H 
ATOM    273 2HG  ARG    16       8.758 -11.615   1.693  1.00 36.29           H 
ATOM    274 3HD  ARG    16       7.693 -13.536   0.763  1.00 36.29           H 
ATOM    275 2HD  ARG    16       8.843 -14.092   1.980  1.00 36.29           H 
ATOM    276  HE  ARG    16      10.269 -14.246  -0.311  1.00 74.05           H 
ATOM    277 1HH1 ARG    16       7.174 -15.436   0.626  1.00 36.29           H 
ATOM    278 2HH1 ARG    16       7.254 -16.795  -0.444  1.00 36.29           H 
ATOM    279 1HH2 ARG    16      10.355 -16.000  -1.677  1.00 36.29           H 
ATOM    280 2HH2 ARG    16       9.024 -17.104  -1.728  1.00 36.29           H 
ATOM    281  N   LEU    17      12.645 -10.863  -0.450  1.00  0.31           N 
ATOM    282  CA  LEU    17      12.922 -10.490  -1.843  1.00 62.33           C 
ATOM    283  C   LEU    17      12.686 -11.688  -2.778  1.00  3.55           C 
ATOM    284  O   LEU    17      13.438 -12.664  -2.747  1.00  4.43           O 
ATOM    285  CB  LEU    17      14.372  -9.988  -2.007  1.00 34.31           C 
ATOM    286  CG  LEU    17      14.729  -8.668  -1.289  1.00 73.12           C 
ATOM    287  CD1 LEU    17      14.759  -8.844   0.228  1.00 51.21           C 
ATOM    288  CD2 LEU    17      16.067  -8.128  -1.792  1.00 23.23           C 
ATOM    289  H   LEU    17      13.215 -11.534  -0.014  1.00 36.29           H 
ATOM    290  HA  LEU    17      12.243  -9.694  -2.117  1.00  3.45           H 
ATOM    291 3HB  LEU    17      14.560  -9.853  -3.064  1.00 36.29           H 
ATOM    292 2HB  LEU    17      15.036 -10.759  -1.642  1.00 36.29           H 
ATOM    293  HG  LEU    17      13.972  -7.931  -1.516  1.00 55.30           H 
ATOM    294 1HD1 LEU    17      13.784  -9.152   0.573  1.00 36.29           H 
ATOM    295 2HD1 LEU    17      15.023  -7.906   0.694  1.00 36.29           H 
ATOM    296 3HD1 LEU    17      15.490  -9.595   0.493  1.00 36.29           H 
ATOM    297 1HD2 LEU    17      15.995  -7.910  -2.847  1.00 36.29           H 
ATOM    298 2HD2 LEU    17      16.842  -8.865  -1.630  1.00 36.29           H 
ATOM    299 3HD2 LEU    17      16.315  -7.223  -1.255  1.00 36.29           H 
ATOM    300  N   GLU    18      11.650 -11.616  -3.609  1.00 65.14           N 
ATOM    301  CA  GLU    18      11.313 -12.710  -4.532  1.00 61.25           C 
ATOM    302  C   GLU    18      12.190 -12.680  -5.802  1.00 13.35           C 
ATOM    303  O   GLU    18      11.698 -12.836  -6.922  1.00 54.12           O 
ATOM    304  CB  GLU    18       9.818 -12.641  -4.893  1.00 64.31           C 
ATOM    305  CG  GLU    18       8.890 -12.730  -3.680  1.00 30.41           C 
ATOM    306  CD  GLU    18       7.420 -12.882  -4.059  1.00 44.25           C 
ATOM    307  OE1 GLU    18       7.032 -13.991  -4.487  1.00 73.44           O 
ATOM    308  OE2 GLU    18       6.650 -11.903  -3.923  1.00 72.23           O 
ATOM    309  H   GLU    18      11.091 -10.812  -3.602  1.00 36.29           H 
ATOM    310  HA  GLU    18      11.498 -13.643  -4.015  1.00  3.23           H 
ATOM    311 3HB  GLU    18       9.582 -13.460  -5.560  1.00 36.29           H 
ATOM    312 2HB  GLU    18       9.624 -11.706  -5.400  1.00 36.29           H 
ATOM    313 3HG  GLU    18       9.008 -11.830  -3.089  1.00 36.29           H 
ATOM    314 2HG  GLU    18       9.181 -13.584  -3.085  1.00 36.29           H 
ATOM    315  N   VAL    19      13.500 -12.511  -5.610  1.00 61.33           N 
ATOM    316  CA  VAL    19      14.461 -12.464  -6.720  1.00 64.02           C 
ATOM    317  C   VAL    19      15.892 -12.796  -6.248  1.00 51.43           C 
ATOM    318  O   VAL    19      16.281 -12.473  -5.124  1.00 60.45           O 
ATOM    319  CB  VAL    19      14.460 -11.070  -7.404  1.00 21.12           C 
ATOM    320  CG1 VAL    19      14.876  -9.976  -6.420  1.00 20.32           C 
ATOM    321  CG2 VAL    19      15.362 -11.064  -8.642  1.00 35.12           C 
ATOM    322  H   VAL    19      13.833 -12.421  -4.695  1.00 36.29           H 
ATOM    323  HA  VAL    19      14.157 -13.200  -7.452  1.00 71.45           H 
ATOM    324  HB  VAL    19      13.449 -10.857  -7.727  1.00 20.42           H 
ATOM    325 1HG1 VAL    19      14.197  -9.969  -5.579  1.00 36.29           H 
ATOM    326 2HG1 VAL    19      14.844  -9.014  -6.915  1.00 36.29           H 
ATOM    327 3HG1 VAL    19      15.879 -10.166  -6.070  1.00 36.29           H 
ATOM    328 1HG2 VAL    19      15.338 -10.086  -9.102  1.00 36.29           H 
ATOM    329 2HG2 VAL    19      15.010 -11.800  -9.350  1.00 36.29           H 
ATOM    330 3HG2 VAL    19      16.376 -11.300  -8.352  1.00 36.29           H 
ATOM    331  N   SER    20      16.668 -13.440  -7.120  1.00 30.03           N 
ATOM    332  CA  SER    20      18.064 -13.797  -6.819  1.00 25.34           C 
ATOM    333  C   SER    20      18.943 -13.724  -8.080  1.00 44.25           C 
ATOM    334  O   SER    20      18.525 -14.140  -9.162  1.00  1.44           O 
ATOM    335  CB  SER    20      18.143 -15.212  -6.222  1.00 54.34           C 
ATOM    336  OG  SER    20      17.658 -16.194  -7.132  1.00 62.52           O 
ATOM    337  H   SER    20      16.293 -13.691  -7.990  1.00 36.29           H 
ATOM    338  HA  SER    20      18.439 -13.088  -6.092  1.00 21.44           H 
ATOM    339 3HB  SER    20      17.550 -15.253  -5.320  1.00 36.29           H 
ATOM    340 2HB  SER    20      19.173 -15.443  -5.983  1.00 36.29           H 
ATOM    341  HG  SER    20      17.701 -15.848  -8.034  1.00 34.34           H 
ATOM    342  N   GLY    21      20.162 -13.203  -7.936  1.00 43.32           N 
ATOM    343  CA  GLY    21      21.082 -13.104  -9.070  1.00 23.41           C 
ATOM    344  C   GLY    21      20.997 -11.768  -9.811  1.00  2.22           C 
ATOM    345  O   GLY    21      19.912 -11.349 -10.222  1.00 65.42           O 
ATOM    346  H   GLY    21      20.447 -12.890  -7.050  1.00 36.29           H 
ATOM    347 3HA  GLY    21      20.866 -13.902  -9.767  1.00 36.29           H 
ATOM    348 2HA  GLY    21      22.090 -13.233  -8.705  1.00 36.29           H 
ATOM    349  N   GLU    22      22.147 -11.100  -9.970  1.00 25.21           N 
ATOM    350  CA  GLU    22      22.243  -9.823 -10.704  1.00 35.14           C 
ATOM    351  C   GLU    22      21.469  -8.681 -10.015  1.00 50.11           C 
ATOM    352  O   GLU    22      22.065  -7.758  -9.459  1.00 14.41           O 
ATOM    353  CB  GLU    22      21.769  -9.991 -12.160  1.00 34.40           C 
ATOM    354  CG  GLU    22      22.683 -10.870 -13.010  1.00 62.03           C 
ATOM    355  CD  GLU    22      22.176 -11.049 -14.434  1.00 22.45           C 
ATOM    356  OE1 GLU    22      21.874 -12.194 -14.830  1.00 61.44           O 
ATOM    357  OE2 GLU    22      22.061 -10.042 -15.164  1.00 72.20           O 
ATOM    358  H   GLU    22      22.963 -11.474  -9.575  1.00 36.29           H 
ATOM    359  HA  GLU    22      23.290  -9.551 -10.720  1.00 42.54           H 
ATOM    360 3HB  GLU    22      21.711  -9.016 -12.624  1.00 36.29           H 
ATOM    361 2HB  GLU    22      20.782 -10.433 -12.156  1.00 36.29           H 
ATOM    362 3HG  GLU    22      22.762 -11.841 -12.543  1.00 36.29           H 
ATOM    363 2HG  GLU    22      23.663 -10.413 -13.050  1.00 36.29           H 
ATOM    364  N   LEU    23      20.141  -8.738 -10.056  1.00 52.11           N 
ATOM    365  CA  LEU    23      19.307  -7.690  -9.456  1.00 42.43           C 
ATOM    366  C   LEU    23      19.362  -7.725  -7.917  1.00 54.40           C 
ATOM    367  O   LEU    23      19.346  -6.683  -7.260  1.00 31.34           O 
ATOM    368  CB  LEU    23      17.853  -7.829  -9.935  1.00 25.13           C 
ATOM    369  CG  LEU    23      16.890  -6.751  -9.414  1.00 34.53           C 
ATOM    370  CD1 LEU    23      17.379  -5.358  -9.802  1.00 51.22           C 
ATOM    371  CD2 LEU    23      15.476  -6.993  -9.938  1.00  1.54           C 
ATOM    372  H   LEU    23      19.710  -9.498 -10.502  1.00 36.29           H 
ATOM    373  HA  LEU    23      19.692  -6.735  -9.792  1.00 63.41           H 
ATOM    374 3HB  LEU    23      17.483  -8.794  -9.618  1.00 36.29           H 
ATOM    375 2HB  LEU    23      17.848  -7.799 -11.016  1.00 36.29           H 
ATOM    376  HG  LEU    23      16.857  -6.800  -8.334  1.00 11.35           H 
ATOM    377 1HD1 LEU    23      18.367  -5.196  -9.393  1.00 36.29           H 
ATOM    378 2HD1 LEU    23      16.703  -4.616  -9.406  1.00 36.29           H 
ATOM    379 3HD1 LEU    23      17.416  -5.274 -10.879  1.00 36.29           H 
ATOM    380 1HD2 LEU    23      15.480  -6.962 -11.019  1.00 36.29           H 
ATOM    381 2HD2 LEU    23      14.813  -6.227  -9.559  1.00 36.29           H 
ATOM    382 3HD2 LEU    23      15.128  -7.961  -9.606  1.00 36.29           H 
ATOM    383  N   HIS    24      19.440  -8.927  -7.347  1.00  5.44           N 
ATOM    384  CA  HIS    24      19.451  -9.098  -5.887  1.00 21.23           C 
ATOM    385  C   HIS    24      20.626  -8.346  -5.232  1.00 15.23           C 
ATOM    386  O   HIS    24      20.454  -7.677  -4.212  1.00 20.14           O 
ATOM    387  CB  HIS    24      19.509 -10.589  -5.534  1.00 22.14           C 
ATOM    388  CG  HIS    24      19.431 -10.874  -4.061  1.00 74.40           C 
ATOM    389  ND1 HIS    24      20.541 -11.011  -3.257  1.00 22.52           N 
ATOM    390  CD2 HIS    24      18.364 -11.068  -3.253  1.00 72.20           C 
ATOM    391  CE1 HIS    24      20.161 -11.276  -2.025  1.00 11.43           C 
ATOM    392  NE2 HIS    24      18.844 -11.316  -1.993  1.00 72.11           N 
ATOM    393  H   HIS    24      19.496  -9.719  -7.922  1.00 36.29           H 
ATOM    394  HA  HIS    24      18.527  -8.689  -5.504  1.00 73.12           H 
ATOM    395 3HB  HIS    24      20.435 -11.007  -5.904  1.00 36.29           H 
ATOM    396 2HB  HIS    24      18.680 -11.095  -6.008  1.00 36.29           H 
ATOM    397  HD1 HIS    24      21.476 -10.931  -3.549  1.00 43.04           H 
ATOM    398  HD2 HIS    24      17.323 -11.033  -3.547  1.00 22.55           H 
ATOM    399  HE1 HIS    24      20.817 -11.438  -1.182  1.00 34.02           H 
ATOM    400  HE2 HIS    24      18.323 -11.726  -1.267  1.00 36.29           H 
ATOM    401  N   GLU    25      21.814  -8.462  -5.821  1.00  1.01           N 
ATOM    402  CA  GLU    25      23.002  -7.760  -5.313  1.00 20.24           C 
ATOM    403  C   GLU    25      22.894  -6.237  -5.504  1.00 14.42           C 
ATOM    404  O   GLU    25      23.382  -5.464  -4.678  1.00 51.00           O 
ATOM    405  CB  GLU    25      24.270  -8.315  -5.975  1.00 74.25           C 
ATOM    406  CG  GLU    25      24.226  -8.330  -7.499  1.00 60.44           C 
ATOM    407  CD  GLU    25      25.174  -9.357  -8.097  1.00 13.20           C 
ATOM    408  OE1 GLU    25      26.222  -8.969  -8.652  1.00 23.14           O 
ATOM    409  OE2 GLU    25      24.871 -10.565  -8.005  1.00 30.12           O 
ATOM    410  H   GLU    25      21.902  -9.043  -6.607  1.00 36.29           H 
ATOM    411  HA  GLU    25      23.058  -7.960  -4.251  1.00 31.22           H 
ATOM    412 3HB  GLU    25      24.419  -9.330  -5.631  1.00 36.29           H 
ATOM    413 2HB  GLU    25      25.115  -7.716  -5.666  1.00 36.29           H 
ATOM    414 3HG  GLU    25      24.497  -7.348  -7.866  1.00 36.29           H 
ATOM    415 2HG  GLU    25      23.220  -8.565  -7.816  1.00 36.29           H 
ATOM    416  N   LYS    26      22.248  -5.809  -6.587  1.00 33.11           N 
ATOM    417  CA  LYS    26      21.936  -4.388  -6.789  1.00  2.13           C 
ATOM    418  C   LYS    26      21.045  -3.868  -5.647  1.00  1.22           C 
ATOM    419  O   LYS    26      21.283  -2.795  -5.085  1.00 54.51           O 
ATOM    420  CB  LYS    26      21.227  -4.181  -8.138  1.00 23.05           C 
ATOM    421  CG  LYS    26      20.755  -2.747  -8.376  1.00 73.40           C 
ATOM    422  CD  LYS    26      19.990  -2.602  -9.691  1.00 51.53           C 
ATOM    423  CE  LYS    26      19.479  -1.178  -9.894  1.00 32.13           C 
ATOM    424  NZ  LYS    26      20.585  -0.182  -9.921  1.00 65.41           N 
ATOM    425  H   LYS    26      21.984  -6.460  -7.272  1.00 36.29           H 
ATOM    426  HA  LYS    26      22.867  -3.837  -6.788  1.00 21.01           H 
ATOM    427 3HB  LYS    26      20.365  -4.833  -8.184  1.00 36.29           H 
ATOM    428 2HB  LYS    26      21.909  -4.448  -8.933  1.00 36.29           H 
ATOM    429 3HG  LYS    26      21.617  -2.094  -8.398  1.00 36.29           H 
ATOM    430 2HG  LYS    26      20.104  -2.454  -7.564  1.00 36.29           H 
ATOM    431 3HD  LYS    26      19.147  -3.278  -9.682  1.00 36.29           H 
ATOM    432 2HD  LYS    26      20.647  -2.857 -10.511  1.00 36.29           H 
ATOM    433 3HE  LYS    26      18.805  -0.931  -9.085  1.00 36.29           H 
ATOM    434 2HE  LYS    26      18.945  -1.132 -10.832  1.00 36.29           H 
ATOM    435 1HZ  LYS    26      21.194  -0.296  -9.087  1.00 36.29           H 
ATOM    436 2HZ  LYS    26      20.197   0.783  -9.915  1.00 36.29           H 
ATOM    437 3HZ  LYS    26      21.162  -0.304 -10.778  1.00 36.29           H 
ATOM    438  N   LEU    27      20.024  -4.650  -5.307  1.00  4.41           N 
ATOM    439  CA  LEU    27      19.083  -4.291  -4.242  1.00 50.20           C 
ATOM    440  C   LEU    27      19.781  -4.169  -2.873  1.00 51.10           C 
ATOM    441  O   LEU    27      19.699  -3.127  -2.217  1.00  3.54           O 
ATOM    442  CB  LEU    27      17.956  -5.332  -4.174  1.00 34.50           C 
ATOM    443  CG  LEU    27      17.071  -5.423  -5.432  1.00 22.13           C 
ATOM    444  CD1 LEU    27      16.069  -6.569  -5.311  1.00 62.11           C 
ATOM    445  CD2 LEU    27      16.352  -4.096  -5.685  1.00 60.43           C 
ATOM    446  H   LEU    27      19.895  -5.494  -5.790  1.00 36.29           H 
ATOM    447  HA  LEU    27      18.653  -3.331  -4.494  1.00 23.24           H 
ATOM    448 3HB  LEU    27      17.321  -5.093  -3.332  1.00 36.29           H 
ATOM    449 2HB  LEU    27      18.402  -6.302  -4.001  1.00 36.29           H 
ATOM    450  HG  LEU    27      17.700  -5.626  -6.287  1.00 31.34           H 
ATOM    451 1HD1 LEU    27      16.601  -7.500  -5.172  1.00 36.29           H 
ATOM    452 2HD1 LEU    27      15.478  -6.626  -6.213  1.00 36.29           H 
ATOM    453 3HD1 LEU    27      15.419  -6.396  -4.465  1.00 36.29           H 
ATOM    454 1HD2 LEU    27      15.744  -4.180  -6.575  1.00 36.29           H 
ATOM    455 2HD2 LEU    27      17.080  -3.310  -5.821  1.00 36.29           H 
ATOM    456 3HD2 LEU    27      15.720  -3.858  -4.841  1.00 36.29           H 
ATOM    457  N   VAL    28      20.473  -5.227  -2.449  1.00 41.14           N 
ATOM    458  CA  VAL    28      21.202  -5.206  -1.172  1.00 31.54           C 
ATOM    459  C   VAL    28      22.322  -4.151  -1.187  1.00  2.43           C 
ATOM    460  O   VAL    28      22.674  -3.585  -0.151  1.00 42.45           O 
ATOM    461  CB  VAL    28      21.796  -6.596  -0.812  1.00 35.24           C 
ATOM    462  CG1 VAL    28      20.698  -7.656  -0.773  1.00 43.52           C 
ATOM    463  CG2 VAL    28      22.904  -6.994  -1.786  1.00 23.41           C 
ATOM    464  H   VAL    28      20.488  -6.041  -2.998  1.00 36.29           H 
ATOM    465  HA  VAL    28      20.492  -4.937  -0.399  1.00 15.12           H 
ATOM    466  HB  VAL    28      22.227  -6.529   0.179  1.00 34.11           H 
ATOM    467 1HG1 VAL    28      20.237  -7.735  -1.748  1.00 36.29           H 
ATOM    468 2HG1 VAL    28      19.951  -7.378  -0.044  1.00 36.29           H 
ATOM    469 3HG1 VAL    28      21.127  -8.611  -0.500  1.00 36.29           H 
ATOM    470 1HG2 VAL    28      23.708  -6.275  -1.733  1.00 36.29           H 
ATOM    471 2HG2 VAL    28      22.510  -7.017  -2.791  1.00 36.29           H 
ATOM    472 3HG2 VAL    28      23.281  -7.974  -1.525  1.00 36.29           H 
ATOM    473  N   GLY    29      22.883  -3.897  -2.371  1.00 31.42           N 
ATOM    474  CA  GLY    29      23.868  -2.831  -2.532  1.00 51.22           C 
ATOM    475  C   GLY    29      23.289  -1.447  -2.241  1.00 63.34           C 
ATOM    476  O   GLY    29      23.980  -0.569  -1.718  1.00 30.35           O 
ATOM    477  H   GLY    29      22.633  -4.446  -3.146  1.00 36.29           H 
ATOM    478 3HA  GLY    29      24.236  -2.848  -3.549  1.00 36.29           H 
ATOM    479 2HA  GLY    29      24.695  -3.013  -1.860  1.00 36.29           H 
ATOM    480  N   MET    30      22.015  -1.257  -2.582  1.00  3.32           N 
ATOM    481  CA  MET    30      21.309  -0.001  -2.299  1.00  5.23           C 
ATOM    482  C   MET    30      20.713   0.005  -0.878  1.00 22.33           C 
ATOM    483  O   MET    30      20.421   1.066  -0.324  1.00 35.41           O 
ATOM    484  CB  MET    30      20.211   0.242  -3.345  1.00 11.22           C 
ATOM    485  CG  MET    30      20.754   0.455  -4.752  1.00  1.14           C 
ATOM    486  SD  MET    30      19.457   0.812  -5.956  1.00 22.01           S 
ATOM    487  CE  MET    30      18.502  -0.703  -5.889  1.00 63.52           C 
ATOM    488  H   MET    30      21.537  -1.980  -3.043  1.00 36.29           H 
ATOM    489  HA  MET    30      22.032   0.801  -2.367  1.00 44.01           H 
ATOM    490 3HB  MET    30      19.647   1.118  -3.063  1.00 36.29           H 
ATOM    491 2HB  MET    30      19.548  -0.612  -3.363  1.00 36.29           H 
ATOM    492 3HG  MET    30      21.277  -0.440  -5.061  1.00 36.29           H 
ATOM    493 2HG  MET    30      21.444   1.285  -4.736  1.00 36.29           H 
ATOM    494 1HE  MET    30      19.128  -1.537  -6.171  1.00 36.29           H 
ATOM    495 2HE  MET    30      17.667  -0.634  -6.571  1.00 36.29           H 
ATOM    496 3HE  MET    30      18.134  -0.854  -4.885  1.00 36.29           H 
ATOM    497  N   GLY    31      20.529  -1.182  -0.288  1.00 64.43           N 
ATOM    498  CA  GLY    31      20.067  -1.268   1.102  1.00 12.31           C 
ATOM    499  C   GLY    31      18.915  -2.247   1.329  1.00 42.44           C 
ATOM    500  O   GLY    31      18.568  -2.545   2.477  1.00 43.15           O 
ATOM    501  H   GLY    31      20.716  -2.001  -0.793  1.00 36.29           H 
ATOM    502 3HA  GLY    31      19.749  -0.286   1.424  1.00 36.29           H 
ATOM    503 2HA  GLY    31      20.899  -1.575   1.719  1.00 36.29           H 
ATOM    504  N   PHE    32      18.317  -2.750   0.250  1.00 21.02           N 
ATOM    505  CA  PHE    32      17.173  -3.669   0.355  1.00 73.14           C 
ATOM    506  C   PHE    32      17.560  -5.002   1.023  1.00 52.01           C 
ATOM    507  O   PHE    32      18.043  -5.923   0.362  1.00 42.21           O 
ATOM    508  CB  PHE    32      16.568  -3.944  -1.032  1.00 25.00           C 
ATOM    509  CG  PHE    32      15.960  -2.734  -1.696  1.00 31.13           C 
ATOM    510  CD1 PHE    32      16.760  -1.803  -2.344  1.00 24.34           C 
ATOM    511  CD2 PHE    32      14.586  -2.530  -1.675  1.00  5.14           C 
ATOM    512  CE1 PHE    32      16.205  -0.696  -2.953  1.00 73.05           C 
ATOM    513  CE2 PHE    32      14.028  -1.423  -2.283  1.00 61.32           C 
ATOM    514  CZ  PHE    32      14.837  -0.505  -2.923  1.00 40.43           C 
ATOM    515  H   PHE    32      18.647  -2.498  -0.637  1.00 36.29           H 
ATOM    516  HA  PHE    32      16.424  -3.186   0.966  1.00 23.32           H 
ATOM    517 3HB  PHE    32      15.794  -4.695  -0.935  1.00 36.29           H 
ATOM    518 2HB  PHE    32      17.342  -4.323  -1.683  1.00 36.29           H 
ATOM    519  HD1 PHE    32      17.830  -1.950  -2.368  1.00 53.21           H 
ATOM    520  HD2 PHE    32      13.951  -3.248  -1.177  1.00 60.02           H 
ATOM    521  HE1 PHE    32      16.840   0.020  -3.453  1.00 65.40           H 
ATOM    522  HE2 PHE    32      12.957  -1.275  -2.260  1.00 30.52           H 
ATOM    523  HZ  PHE    32      14.403   0.361  -3.398  1.00 72.35           H 
ATOM    524  N   VAL    33      17.362  -5.087   2.339  1.00 62.13           N 
ATOM    525  CA  VAL    33      17.590  -6.332   3.085  1.00 63.03           C 
ATOM    526  C   VAL    33      16.395  -6.650   4.007  1.00 51.44           C 
ATOM    527  O   VAL    33      15.780  -5.740   4.579  1.00 32.15           O 
ATOM    528  CB  VAL    33      18.901  -6.275   3.926  1.00 62.10           C 
ATOM    529  CG1 VAL    33      20.117  -6.065   3.025  1.00 55.24           C 
ATOM    530  CG2 VAL    33      18.826  -5.183   4.994  1.00 52.51           C 
ATOM    531  H   VAL    33      17.064  -4.289   2.823  1.00 36.29           H 
ATOM    532  HA  VAL    33      17.690  -7.135   2.365  1.00 61.15           H 
ATOM    533  HB  VAL    33      19.021  -7.227   4.427  1.00 30.32           H 
ATOM    534 1HG1 VAL    33      21.018  -6.064   3.624  1.00 36.29           H 
ATOM    535 2HG1 VAL    33      20.028  -5.119   2.511  1.00 36.29           H 
ATOM    536 3HG1 VAL    33      20.170  -6.863   2.298  1.00 36.29           H 
ATOM    537 1HG2 VAL    33      18.020  -5.403   5.680  1.00 36.29           H 
ATOM    538 2HG2 VAL    33      18.646  -4.229   4.522  1.00 36.29           H 
ATOM    539 3HG2 VAL    33      19.760  -5.145   5.538  1.00 36.29           H 
ATOM    540  N   PRO    34      16.038  -7.946   4.155  1.00  1.04           N 
ATOM    541  CA  PRO    34      14.906  -8.368   5.006  1.00  2.21           C 
ATOM    542  C   PRO    34      15.015  -7.834   6.446  1.00 34.35           C 
ATOM    543  O   PRO    34      15.907  -8.230   7.205  1.00 23.53           O 
ATOM    544  CB  PRO    34      14.993  -9.901   4.981  1.00 13.00           C 
ATOM    545  CG  PRO    34      15.710 -10.218   3.713  1.00 72.54           C 
ATOM    546  CD  PRO    34      16.696  -9.098   3.506  1.00 32.51           C 
ATOM    547  HA  PRO    34      13.959  -8.052   4.580  1.00 72.01           H 
ATOM    548 3HB  PRO    34      13.997 -10.323   4.988  1.00 36.29           H 
ATOM    549 2HB  PRO    34      15.543 -10.251   5.845  1.00 36.29           H 
ATOM    550 3HG  PRO    34      15.008 -10.258   2.891  1.00 36.29           H 
ATOM    551 2HG  PRO    34      16.228 -11.163   3.808  1.00 36.29           H 
ATOM    552 3HD  PRO    34      16.845  -8.915   2.451  1.00 36.29           H 
ATOM    553 2HD  PRO    34      17.638  -9.326   3.987  1.00 36.29           H 
ATOM    554  N   GLY    35      14.099  -6.939   6.813  1.00 51.52           N 
ATOM    555  CA  GLY    35      14.148  -6.295   8.124  1.00 62.41           C 
ATOM    556  C   GLY    35      14.120  -4.769   8.046  1.00 64.23           C 
ATOM    557  O   GLY    35      13.655  -4.106   8.975  1.00 51.22           O 
ATOM    558  H   GLY    35      13.365  -6.727   6.195  1.00 36.29           H 
ATOM    559 3HA  GLY    35      15.054  -6.599   8.634  1.00 36.29           H 
ATOM    560 2HA  GLY    35      13.300  -6.629   8.702  1.00 36.29           H 
ATOM    561  N   GLU    36      14.620  -4.214   6.940  1.00 53.21           N 
ATOM    562  CA  GLU    36      14.636  -2.756   6.736  1.00 11.03           C 
ATOM    563  C   GLU    36      13.231  -2.144   6.757  1.00 23.31           C 
ATOM    564  O   GLU    36      12.258  -2.761   6.326  1.00 61.20           O 
ATOM    565  CB  GLU    36      15.317  -2.400   5.402  1.00 32.34           C 
ATOM    566  CG  GLU    36      16.838  -2.339   5.469  1.00 13.14           C 
ATOM    567  CD  GLU    36      17.339  -1.243   6.399  1.00 44.42           C 
ATOM    568  OE1 GLU    36      16.727  -0.158   6.436  1.00 42.33           O 
ATOM    569  OE2 GLU    36      18.361  -1.458   7.084  1.00 62.32           O 
ATOM    570  H   GLU    36      14.995  -4.795   6.244  1.00 36.29           H 
ATOM    571  HA  GLU    36      15.209  -2.321   7.542  1.00 60.34           H 
ATOM    572 3HB  GLU    36      14.957  -1.433   5.074  1.00 36.29           H 
ATOM    573 2HB  GLU    36      15.042  -3.139   4.664  1.00 36.29           H 
ATOM    574 3HG  GLU    36      17.220  -2.148   4.475  1.00 36.29           H 
ATOM    575 2HG  GLU    36      17.210  -3.291   5.818  1.00 36.29           H 
ATOM    576  N   GLU    37      13.139  -0.920   7.263  1.00 62.22           N 
ATOM    577  CA  GLU    37      11.895  -0.154   7.219  1.00 65.14           C 
ATOM    578  C   GLU    37      11.964   0.899   6.111  1.00 35.44           C 
ATOM    579  O   GLU    37      12.697   1.881   6.211  1.00 53.53           O 
ATOM    580  CB  GLU    37      11.621   0.500   8.577  1.00 71.21           C 
ATOM    581  CG  GLU    37      11.387  -0.513   9.690  1.00 23.14           C 
ATOM    582  CD  GLU    37      11.247   0.135  11.057  1.00 20.24           C 
ATOM    583  OE1 GLU    37      12.279   0.377  11.714  1.00 53.54           O 
ATOM    584  OE2 GLU    37      10.105   0.406  11.479  1.00 64.04           O 
ATOM    585  H   GLU    37      13.931  -0.519   7.679  1.00 36.29           H 
ATOM    586  HA  GLU    37      11.089  -0.842   6.992  1.00 21.02           H 
ATOM    587 3HB  GLU    37      10.743   1.124   8.497  1.00 36.29           H 
ATOM    588 2HB  GLU    37      12.467   1.118   8.848  1.00 36.29           H 
ATOM    589 3HG  GLU    37      12.221  -1.200   9.713  1.00 36.29           H 
ATOM    590 2HG  GLU    37      10.481  -1.063   9.476  1.00 36.29           H 
ATOM    591  N   ILE    38      11.210   0.671   5.048  1.00 11.41           N 
ATOM    592  CA  ILE    38      11.230   1.539   3.870  1.00 13.12           C 
ATOM    593  C   ILE    38       9.952   2.391   3.775  1.00  2.14           C 
ATOM    594  O   ILE    38       8.836   1.879   3.862  1.00 52.15           O 
ATOM    595  CB  ILE    38      11.396   0.704   2.571  1.00 71.30           C 
ATOM    596  CG1 ILE    38      11.418   1.618   1.333  1.00 34.11           C 
ATOM    597  CG2 ILE    38      10.289  -0.346   2.454  1.00 72.01           C 
ATOM    598  CD1 ILE    38      11.584   0.869   0.025  1.00 73.03           C 
ATOM    599  H   ILE    38      10.618  -0.107   5.055  1.00 36.29           H 
ATOM    600  HA  ILE    38      12.085   2.199   3.957  1.00 43.24           H 
ATOM    601  HB  ILE    38      12.341   0.178   2.634  1.00 61.23           H 
ATOM    602 3HG1 ILE    38      12.240   2.315   1.421  1.00 36.29           H 
ATOM    603 2HG1 ILE    38      10.490   2.169   1.281  1.00 36.29           H 
ATOM    604 1HG2 ILE    38       9.328   0.146   2.379  1.00 36.29           H 
ATOM    605 2HG2 ILE    38      10.298  -0.979   3.330  1.00 36.29           H 
ATOM    606 3HG2 ILE    38      10.452  -0.952   1.575  1.00 36.29           H 
ATOM    607 1HD1 ILE    38      12.510   0.313   0.042  1.00 36.29           H 
ATOM    608 2HD1 ILE    38      11.603   1.573  -0.792  1.00 36.29           H 
ATOM    609 3HD1 ILE    38      10.757   0.186  -0.108  1.00 36.29           H 
ATOM    610  N   GLU    39      10.127   3.698   3.613  1.00 24.21           N 
ATOM    611  CA  GLU    39       8.998   4.623   3.451  1.00  0.11           C 
ATOM    612  C   GLU    39       9.097   5.378   2.114  1.00 74.24           C 
ATOM    613  O   GLU    39      10.150   5.922   1.766  1.00 61.24           O 
ATOM    614  CB  GLU    39       8.943   5.611   4.633  1.00 73.20           C 
ATOM    615  CG  GLU    39      10.230   6.403   4.838  1.00 54.35           C 
ATOM    616  CD  GLU    39      10.175   7.341   6.036  1.00  1.04           C 
ATOM    617  OE1 GLU    39      10.249   6.858   7.187  1.00 44.23           O 
ATOM    618  OE2 GLU    39      10.080   8.569   5.834  1.00 60.15           O 
ATOM    619  H   GLU    39      11.041   4.056   3.605  1.00 36.29           H 
ATOM    620  HA  GLU    39       8.089   4.037   3.445  1.00 25.43           H 
ATOM    621 3HB  GLU    39       8.739   5.056   5.539  1.00 36.29           H 
ATOM    622 2HB  GLU    39       8.135   6.312   4.466  1.00 36.29           H 
ATOM    623 3HG  GLU    39      10.420   6.988   3.948  1.00 36.29           H 
ATOM    624 2HG  GLU    39      11.043   5.708   4.984  1.00 36.29           H 
ATOM    625  N   ILE    40       8.003   5.384   1.354  1.00  4.05           N 
ATOM    626  CA  ILE    40       7.955   6.098   0.075  1.00 72.44           C 
ATOM    627  C   ILE    40       7.859   7.614   0.300  1.00 72.04           C 
ATOM    628  O   ILE    40       7.019   8.085   1.068  1.00 42.01           O 
ATOM    629  CB  ILE    40       6.757   5.631  -0.793  1.00 63.41           C 
ATOM    630  CG1 ILE    40       6.827   4.114  -1.055  1.00 70.43           C 
ATOM    631  CG2 ILE    40       6.713   6.402  -2.114  1.00 72.33           C 
ATOM    632  CD1 ILE    40       8.056   3.674  -1.828  1.00 40.12           C 
ATOM    633  H   ILE    40       7.211   4.896   1.659  1.00 36.29           H 
ATOM    634  HA  ILE    40       8.869   5.881  -0.463  1.00 32.24           H 
ATOM    635  HB  ILE    40       5.847   5.851  -0.252  1.00 54.33           H 
ATOM    636 3HG1 ILE    40       5.954   3.815  -1.622  1.00 36.29           H 
ATOM    637 2HG1 ILE    40       6.829   3.590  -0.111  1.00 36.29           H 
ATOM    638 1HG2 ILE    40       7.632   6.238  -2.658  1.00 36.29           H 
ATOM    639 2HG2 ILE    40       6.600   7.458  -1.914  1.00 36.29           H 
ATOM    640 3HG2 ILE    40       5.877   6.058  -2.706  1.00 36.29           H 
ATOM    641 1HD1 ILE    40       8.946   3.954  -1.282  1.00 36.29           H 
ATOM    642 2HD1 ILE    40       8.064   4.151  -2.796  1.00 36.29           H 
ATOM    643 3HD1 ILE    40       8.036   2.601  -1.956  1.00 36.29           H 
ATOM    644  N   VAL    41       8.728   8.373  -0.362  1.00 65.02           N 
ATOM    645  CA  VAL    41       8.744   9.831  -0.218  1.00 74.12           C 
ATOM    646  C   VAL    41       7.885  10.512  -1.294  1.00 43.23           C 
ATOM    647  O   VAL    41       6.977  11.286  -0.986  1.00 22.33           O 
ATOM    648  CB  VAL    41      10.189  10.386  -0.289  1.00 75.20           C 
ATOM    649  CG1 VAL    41      10.220  11.878   0.039  1.00 21.45           C 
ATOM    650  CG2 VAL    41      11.103   9.604   0.644  1.00 53.13           C 
ATOM    651  H   VAL    41       9.377   7.943  -0.958  1.00 36.29           H 
ATOM    652  HA  VAL    41       8.339  10.071   0.758  1.00 23.52           H 
ATOM    653  HB  VAL    41      10.554  10.257  -1.299  1.00 32.15           H 
ATOM    654 1HG1 VAL    41       9.805  12.038   1.024  1.00 36.29           H 
ATOM    655 2HG1 VAL    41       9.636  12.422  -0.690  1.00 36.29           H 
ATOM    656 3HG1 VAL    41      11.240  12.232   0.018  1.00 36.29           H 
ATOM    657 1HG2 VAL    41      11.114   8.563   0.353  1.00 36.29           H 
ATOM    658 2HG2 VAL    41      10.742   9.689   1.660  1.00 36.29           H 
ATOM    659 3HG2 VAL    41      12.105  10.003   0.587  1.00 36.29           H 
ATOM    660  N   GLN    42       8.182  10.219  -2.561  1.00  3.43           N 
ATOM    661  CA  GLN    42       7.421  10.776  -3.685  1.00 74.24           C 
ATOM    662  C   GLN    42       7.518   9.872  -4.929  1.00 64.11           C 
ATOM    663  O   GLN    42       8.488   9.130  -5.103  1.00 31.14           O 
ATOM    664  CB  GLN    42       7.899  12.213  -3.993  1.00  3.35           C 
ATOM    665  CG  GLN    42       9.315  12.327  -4.573  1.00 33.42           C 
ATOM    666  CD  GLN    42       9.342  12.283  -6.095  1.00 64.51           C 
ATOM    667  OE1 GLN    42       8.383  12.672  -6.753  1.00 10.20           O 
ATOM    668  NE2 GLN    42      10.442  11.846  -6.667  1.00 24.44           N 
ATOM    669  H   GLN    42       8.928   9.611  -2.747  1.00 36.29           H 
ATOM    670  HA  GLN    42       6.383  10.818  -3.383  1.00 54.33           H 
ATOM    671 3HB  GLN    42       7.866  12.785  -3.076  1.00 36.29           H 
ATOM    672 2HB  GLN    42       7.214  12.658  -4.699  1.00 36.29           H 
ATOM    673 3HG  GLN    42       9.912  11.509  -4.194  1.00 36.29           H 
ATOM    674 2HG  GLN    42       9.749  13.263  -4.251  1.00 36.29           H 
ATOM    675 1HE2 GLN    42      11.184  11.571  -6.094  1.00 36.29           H 
ATOM    676 2HE2 GLN    42      10.472  11.823  -7.648  1.00 36.29           H 
ATOM    677  N   VAL    43       6.501   9.937  -5.786  1.00 12.10           N 
ATOM    678  CA  VAL    43       6.417   9.079  -6.978  1.00 22.13           C 
ATOM    679  C   VAL    43       6.363   9.914  -8.265  1.00 21.24           C 
ATOM    680  O   VAL    43       5.746  10.981  -8.297  1.00 40.02           O 
ATOM    681  CB  VAL    43       5.156   8.173  -6.916  1.00 73.42           C 
ATOM    682  CG1 VAL    43       5.002   7.343  -8.195  1.00  5.04           C 
ATOM    683  CG2 VAL    43       5.200   7.273  -5.679  1.00 51.45           C 
ATOM    684  H   VAL    43       5.785  10.585  -5.620  1.00 36.29           H 
ATOM    685  HA  VAL    43       7.292   8.444  -7.006  1.00 12.31           H 
ATOM    686  HB  VAL    43       4.287   8.812  -6.832  1.00 13.50           H 
ATOM    687 1HG1 VAL    43       5.882   6.735  -8.342  1.00 36.29           H 
ATOM    688 2HG1 VAL    43       4.876   8.003  -9.042  1.00 36.29           H 
ATOM    689 3HG1 VAL    43       4.135   6.703  -8.110  1.00 36.29           H 
ATOM    690 1HG2 VAL    43       4.327   6.636  -5.661  1.00 36.29           H 
ATOM    691 2HG2 VAL    43       5.213   7.886  -4.789  1.00 36.29           H 
ATOM    692 3HG2 VAL    43       6.091   6.662  -5.706  1.00 36.29           H 
ATOM    693  N   ALA    44       7.014   9.428  -9.322  1.00 45.22           N 
ATOM    694  CA  ALA    44       6.922  10.066 -10.637  1.00 21.02           C 
ATOM    695  C   ALA    44       5.464  10.070 -11.132  1.00 53.33           C 
ATOM    696  O   ALA    44       4.819   9.021 -11.170  1.00 63.02           O 
ATOM    697  CB  ALA    44       7.823   9.351 -11.638  1.00 30.32           C 
ATOM    698  H   ALA    44       7.566   8.623  -9.217  1.00 36.29           H 
ATOM    699  HA  ALA    44       7.267  11.087 -10.537  1.00 12.11           H 
ATOM    700 1HB  ALA    44       8.840   9.355 -11.271  1.00 36.29           H 
ATOM    701 2HB  ALA    44       7.783   9.861 -12.590  1.00 36.29           H 
ATOM    702 3HB  ALA    44       7.489   8.331 -11.762  1.00 36.29           H 
ATOM    703  N   PRO    45       4.928  11.242 -11.526  1.00 61.12           N 
ATOM    704  CA  PRO    45       3.504  11.387 -11.901  1.00 65.23           C 
ATOM    705  C   PRO    45       3.058  10.429 -13.025  1.00 34.04           C 
ATOM    706  O   PRO    45       1.872  10.125 -13.156  1.00  5.14           O 
ATOM    707  CB  PRO    45       3.394  12.856 -12.354  1.00 52.21           C 
ATOM    708  CG  PRO    45       4.799  13.303 -12.595  1.00 51.52           C 
ATOM    709  CD  PRO    45       5.653  12.521 -11.640  1.00 21.40           C 
ATOM    710  HA  PRO    45       2.865  11.231 -11.043  1.00 60.22           H 
ATOM    711 3HB  PRO    45       2.925  13.438 -11.574  1.00 36.29           H 
ATOM    712 2HB  PRO    45       2.801  12.918 -13.256  1.00 36.29           H 
ATOM    713 3HG  PRO    45       4.886  14.363 -12.396  1.00 36.29           H 
ATOM    714 2HG  PRO    45       5.084  13.091 -13.616  1.00 36.29           H 
ATOM    715 3HD  PRO    45       5.710  13.018 -10.681  1.00 36.29           H 
ATOM    716 2HD  PRO    45       6.643  12.372 -12.050  1.00 36.29           H 
ATOM    717  N   LEU    46       4.012   9.949 -13.821  1.00 24.01           N 
ATOM    718  CA  LEU    46       3.708   9.037 -14.931  1.00 20.22           C 
ATOM    719  C   LEU    46       3.609   7.571 -14.463  1.00 62.34           C 
ATOM    720  O   LEU    46       3.128   6.709 -15.200  1.00  5.34           O 
ATOM    721  CB  LEU    46       4.764   9.166 -16.043  1.00 72.21           C 
ATOM    722  CG  LEU    46       4.808  10.523 -16.775  1.00 55.13           C 
ATOM    723  CD1 LEU    46       5.375  11.624 -15.881  1.00 50.34           C 
ATOM    724  CD2 LEU    46       5.611  10.409 -18.069  1.00 71.50           C 
ATOM    725  H   LEU    46       4.941  10.214 -13.661  1.00 36.29           H 
ATOM    726  HA  LEU    46       2.747   9.325 -15.336  1.00 23.32           H 
ATOM    727 3HB  LEU    46       4.573   8.395 -16.777  1.00 36.29           H 
ATOM    728 2HB  LEU    46       5.737   8.984 -15.607  1.00 36.29           H 
ATOM    729  HG  LEU    46       3.799  10.809 -17.038  1.00 33.23           H 
ATOM    730 1HD1 LEU    46       5.394  12.559 -16.424  1.00 36.29           H 
ATOM    731 2HD1 LEU    46       6.380  11.364 -15.578  1.00 36.29           H 
ATOM    732 3HD1 LEU    46       4.752  11.732 -15.005  1.00 36.29           H 
ATOM    733 1HD2 LEU    46       6.630  10.127 -17.842  1.00 36.29           H 
ATOM    734 2HD2 LEU    46       5.608  11.361 -18.583  1.00 36.29           H 
ATOM    735 3HD2 LEU    46       5.164   9.659 -18.704  1.00 36.29           H 
ATOM    736  N   GLY    47       4.064   7.296 -13.240  1.00 13.15           N 
ATOM    737  CA  GLY    47       3.998   5.941 -12.693  1.00 32.42           C 
ATOM    738  C   GLY    47       5.232   5.558 -11.879  1.00  3.32           C 
ATOM    739  O   GLY    47       5.126   5.220 -10.702  1.00 22.12           O 
ATOM    740  H   GLY    47       4.436   8.020 -12.697  1.00 36.29           H 
ATOM    741 3HA  GLY    47       3.890   5.239 -13.507  1.00 36.29           H 
ATOM    742 2HA  GLY    47       3.128   5.869 -12.057  1.00 36.29           H 
ATOM    743  N   ASP    48       6.401   5.592 -12.514  1.00 13.23           N 
ATOM    744  CA  ASP    48       7.667   5.279 -11.842  1.00 64.04           C 
ATOM    745  C   ASP    48       8.847   5.914 -12.615  1.00 61.24           C 
ATOM    746  O   ASP    48       8.654   6.395 -13.737  1.00 51.03           O 
ATOM    747  CB  ASP    48       7.820   3.754 -11.703  1.00 13.35           C 
ATOM    748  CG  ASP    48       8.158   3.054 -13.008  1.00  0.30           C 
ATOM    749  OD1 ASP    48       7.298   3.021 -13.911  1.00 41.50           O 
ATOM    750  OD2 ASP    48       9.275   2.505 -13.126  1.00 33.25           O 
ATOM    751  H   ASP    48       6.416   5.834 -13.464  1.00 36.29           H 
ATOM    752  HA  ASP    48       7.631   5.721 -10.852  1.00 40.21           H 
ATOM    753 3HB  ASP    48       6.890   3.349 -11.333  1.00 36.29           H 
ATOM    754 2HB  ASP    48       8.599   3.540 -10.988  1.00 36.29           H 
ATOM    755  N   PRO    49      10.088   5.935 -12.063  1.00 61.44           N 
ATOM    756  CA  PRO    49      10.463   5.282 -10.785  1.00 44.01           C 
ATOM    757  C   PRO    49       9.884   5.955  -9.525  1.00 75.40           C 
ATOM    758  O   PRO    49       9.372   7.076  -9.571  1.00 60.01           O 
ATOM    759  CB  PRO    49      11.994   5.387 -10.788  1.00  3.11           C 
ATOM    760  CG  PRO    49      12.279   6.611 -11.586  1.00 14.11           C 
ATOM    761  CD  PRO    49      11.239   6.634 -12.672  1.00 25.10           C 
ATOM    762  HA  PRO    49      10.185   4.239 -10.784  1.00 21.21           H 
ATOM    763 3HB  PRO    49      12.418   4.507 -11.251  1.00 36.29           H 
ATOM    764 2HB  PRO    49      12.361   5.478  -9.774  1.00 36.29           H 
ATOM    765 3HG  PRO    49      13.269   6.553 -12.014  1.00 36.29           H 
ATOM    766 2HG  PRO    49      12.191   7.489 -10.960  1.00 36.29           H 
ATOM    767 3HD  PRO    49      11.592   6.103 -13.547  1.00 36.29           H 
ATOM    768 2HD  PRO    49      10.981   7.652 -12.929  1.00 36.29           H 
ATOM    769  N   ILE    50       9.973   5.244  -8.399  1.00 53.23           N 
ATOM    770  CA  ILE    50       9.529   5.766  -7.102  1.00 62.13           C 
ATOM    771  C   ILE    50      10.734   6.058  -6.192  1.00  4.11           C 
ATOM    772  O   ILE    50      11.699   5.290  -6.156  1.00  2.10           O 
ATOM    773  CB  ILE    50       8.555   4.794  -6.364  1.00 22.25           C 
ATOM    774  CG1 ILE    50       9.205   3.418  -6.074  1.00 73.23           C 
ATOM    775  CG2 ILE    50       7.265   4.617  -7.163  1.00 33.53           C 
ATOM    776  CD1 ILE    50       9.099   2.411  -7.206  1.00 22.32           C 
ATOM    777  H   ILE    50      10.362   4.346  -8.438  1.00 36.29           H 
ATOM    778  HA  ILE    50       9.002   6.697  -7.282  1.00 12.14           H 
ATOM    779  HB  ILE    50       8.289   5.255  -5.421  1.00 55.52           H 
ATOM    780 3HG1 ILE    50       8.731   2.983  -5.204  1.00 36.29           H 
ATOM    781 2HG1 ILE    50      10.255   3.559  -5.864  1.00 36.29           H 
ATOM    782 1HG2 ILE    50       6.756   5.566  -7.239  1.00 36.29           H 
ATOM    783 2HG2 ILE    50       6.625   3.906  -6.663  1.00 36.29           H 
ATOM    784 3HG2 ILE    50       7.499   4.255  -8.155  1.00 36.29           H 
ATOM    785 1HD1 ILE    50       9.542   2.820  -8.101  1.00 36.29           H 
ATOM    786 2HD1 ILE    50       8.059   2.183  -7.391  1.00 36.29           H 
ATOM    787 3HD1 ILE    50       9.619   1.506  -6.930  1.00 36.29           H 
ATOM    788  N   VAL    51      10.682   7.174  -5.466  1.00 71.23           N 
ATOM    789  CA  VAL    51      11.762   7.545  -4.543  1.00 73.25           C 
ATOM    790  C   VAL    51      11.393   7.193  -3.096  1.00  4.52           C 
ATOM    791  O   VAL    51      10.426   7.720  -2.537  1.00 42.01           O 
ATOM    792  CB  VAL    51      12.102   9.054  -4.642  1.00  0.44           C 
ATOM    793  CG1 VAL    51      13.223   9.428  -3.670  1.00 61.10           C 
ATOM    794  CG2 VAL    51      12.486   9.422  -6.075  1.00 12.43           C 
ATOM    795  H   VAL    51       9.901   7.762  -5.548  1.00 36.29           H 
ATOM    796  HA  VAL    51      12.645   6.982  -4.822  1.00 23.14           H 
ATOM    797  HB  VAL    51      11.219   9.620  -4.372  1.00  3.15           H 
ATOM    798 1HG1 VAL    51      12.908   9.223  -2.658  1.00 36.29           H 
ATOM    799 2HG1 VAL    51      13.450  10.480  -3.768  1.00 36.29           H 
ATOM    800 3HG1 VAL    51      14.107   8.847  -3.896  1.00 36.29           H 
ATOM    801 1HG2 VAL    51      12.706  10.477  -6.130  1.00 36.29           H 
ATOM    802 2HG2 VAL    51      11.665   9.191  -6.739  1.00 36.29           H 
ATOM    803 3HG2 VAL    51      13.358   8.855  -6.374  1.00 36.29           H 
ATOM    804  N   CYS    52      12.177   6.304  -2.496  1.00 70.13           N 
ATOM    805  CA  CYS    52      11.915   5.816  -1.136  1.00  4.10           C 
ATOM    806  C   CYS    52      13.096   6.095  -0.198  1.00 50.25           C 
ATOM    807  O   CYS    52      14.147   6.562  -0.630  1.00 43.52           O 
ATOM    808  CB  CYS    52      11.640   4.312  -1.175  1.00 50.52           C 
ATOM    809  SG  CYS    52      12.998   3.330  -1.850  1.00 41.54           S 
ATOM    810  H   CYS    52      12.962   5.964  -2.978  1.00 36.29           H 
ATOM    811  HA  CYS    52      11.039   6.324  -0.755  1.00 31.21           H 
ATOM    812 3HB  CYS    52      10.768   4.126  -1.784  1.00 36.29           H 
ATOM    813 2HB  CYS    52      11.452   3.961  -0.169  1.00 36.29           H 
ATOM    814  HG  CYS    52      13.315   3.821  -3.042  1.00 52.01           H 
ATOM    815  N   LYS    53      12.911   5.811   1.090  1.00 72.54           N 
ATOM    816  CA  LYS    53      13.973   5.985   2.092  1.00 44.35           C 
ATOM    817  C   LYS    53      14.402   4.645   2.705  1.00 65.12           C 
ATOM    818  O   LYS    53      13.600   3.947   3.329  1.00 32.25           O 
ATOM    819  CB  LYS    53      13.507   6.929   3.210  1.00 52.32           C 
ATOM    820  CG  LYS    53      13.434   8.396   2.797  1.00 14.52           C 
ATOM    821  CD  LYS    53      12.721   9.250   3.847  1.00 75.52           C 
ATOM    822  CE  LYS    53      13.407   9.167   5.208  1.00 21.32           C 
ATOM    823  NZ  LYS    53      12.598   9.794   6.286  1.00 20.35           N 
ATOM    824  H   LYS    53      12.035   5.480   1.379  1.00 36.29           H 
ATOM    825  HA  LYS    53      14.828   6.428   1.599  1.00 12.25           H 
ATOM    826 3HB  LYS    53      14.192   6.849   4.043  1.00 36.29           H 
ATOM    827 2HB  LYS    53      12.524   6.620   3.537  1.00 36.29           H 
ATOM    828 3HG  LYS    53      12.898   8.470   1.863  1.00 36.29           H 
ATOM    829 2HG  LYS    53      14.439   8.773   2.665  1.00 36.29           H 
ATOM    830 3HD  LYS    53      11.700   8.903   3.945  1.00 36.29           H 
ATOM    831 2HD  LYS    53      12.719  10.279   3.516  1.00 36.29           H 
ATOM    832 3HE  LYS    53      14.361   9.671   5.148  1.00 36.29           H 
ATOM    833 2HE  LYS    53      13.569   8.127   5.454  1.00 36.29           H 
ATOM    834 1HZ  LYS    53      12.489  10.812   6.116  1.00 36.29           H 
ATOM    835 2HZ  LYS    53      13.065   9.656   7.207  1.00 36.29           H 
ATOM    836 3HZ  LYS    53      11.653   9.357   6.325  1.00 36.29           H 
ATOM    837  N   ILE    54      15.672   4.297   2.514  1.00 51.25           N 
ATOM    838  CA  ILE    54      16.270   3.111   3.134  1.00 23.41           C 
ATOM    839  C   ILE    54      17.572   3.492   3.847  1.00 53.31           C 
ATOM    840  O   ILE    54      18.478   4.059   3.236  1.00 31.01           O 
ATOM    841  CB  ILE    54      16.563   2.000   2.093  1.00 43.32           C 
ATOM    842  CG1 ILE    54      15.263   1.574   1.392  1.00  2.52           C 
ATOM    843  CG2 ILE    54      17.241   0.798   2.756  1.00 24.40           C 
ATOM    844  CD1 ILE    54      15.453   0.476   0.368  1.00 41.13           C 
ATOM    845  H   ILE    54      16.232   4.858   1.933  1.00 36.29           H 
ATOM    846  HA  ILE    54      15.572   2.721   3.864  1.00 73.43           H 
ATOM    847  HB  ILE    54      17.245   2.400   1.355  1.00 72.43           H 
ATOM    848 3HG1 ILE    54      14.840   2.430   0.885  1.00 36.29           H 
ATOM    849 2HG1 ILE    54      14.560   1.218   2.132  1.00 36.29           H 
ATOM    850 1HG2 ILE    54      18.154   1.118   3.239  1.00 36.29           H 
ATOM    851 2HG2 ILE    54      17.476   0.055   2.007  1.00 36.29           H 
ATOM    852 3HG2 ILE    54      16.578   0.367   3.493  1.00 36.29           H 
ATOM    853 1HD1 ILE    54      16.145   0.806  -0.391  1.00 36.29           H 
ATOM    854 2HD1 ILE    54      14.502   0.247  -0.089  1.00 36.29           H 
ATOM    855 3HD1 ILE    54      15.843  -0.408   0.852  1.00 36.29           H 
ATOM    856  N   GLY    55      17.662   3.191   5.137  1.00 43.33           N 
ATOM    857  CA  GLY    55      18.825   3.595   5.916  1.00  4.11           C 
ATOM    858  C   GLY    55      19.059   5.101   5.884  1.00 44.34           C 
ATOM    859  O   GLY    55      20.193   5.558   5.713  1.00 62.45           O 
ATOM    860  H   GLY    55      16.943   2.680   5.562  1.00 36.29           H 
ATOM    861 3HA  GLY    55      19.698   3.098   5.523  1.00 36.29           H 
ATOM    862 2HA  GLY    55      18.681   3.289   6.941  1.00 36.29           H 
ATOM    863  N   ASN    56      17.966   5.859   6.020  1.00 23.43           N 
ATOM    864  CA  ASN    56      17.985   7.332   6.019  1.00 24.01           C 
ATOM    865  C   ASN    56      18.160   7.926   4.601  1.00 44.12           C 
ATOM    866  O   ASN    56      17.672   9.022   4.322  1.00 43.12           O 
ATOM    867  CB  ASN    56      19.075   7.872   6.964  1.00  5.22           C 
ATOM    868  CG  ASN    56      18.955   9.369   7.204  1.00 31.32           C 
ATOM    869  OD1 ASN    56      19.509  10.179   6.468  1.00 62.00           O 
ATOM    870  ND2 ASN    56      18.236   9.752   8.240  1.00  4.13           N 
ATOM    871  H   ASN    56      17.103   5.407   6.132  1.00 36.29           H 
ATOM    872  HA  ASN    56      17.023   7.654   6.395  1.00 23.35           H 
ATOM    873 3HB  ASN    56      20.046   7.671   6.533  1.00 36.29           H 
ATOM    874 2HB  ASN    56      19.000   7.366   7.916  1.00 36.29           H 
ATOM    875 1HD2 ASN    56      17.820   9.061   8.797  1.00 36.29           H 
ATOM    876 2HD2 ASN    56      18.152  10.712   8.415  1.00 36.29           H 
ATOM    877  N   ARG    57      18.831   7.200   3.704  1.00  2.33           N 
ATOM    878  CA  ARG    57      19.129   7.721   2.360  1.00 43.52           C 
ATOM    879  C   ARG    57      17.997   7.417   1.360  1.00 52.21           C 
ATOM    880  O   ARG    57      17.310   6.399   1.466  1.00 63.30           O 
ATOM    881  CB  ARG    57      20.461   7.143   1.852  1.00 74.32           C 
ATOM    882  CG  ARG    57      20.467   5.624   1.703  1.00 64.12           C 
ATOM    883  CD  ARG    57      21.866   5.082   1.432  1.00 25.23           C 
ATOM    884  NE  ARG    57      21.877   3.625   1.305  1.00 41.34           N 
ATOM    885  CZ  ARG    57      21.857   2.794   2.312  1.00  0.11           C 
ATOM    886  NH1 ARG    57      21.805   3.224   3.536  1.00 43.11           N 
ATOM    887  NH2 ARG    57      21.892   1.524   2.089  1.00  4.44           N 
ATOM    888  H   ARG    57      19.122   6.295   3.940  1.00 36.29           H 
ATOM    889  HA  ARG    57      19.231   8.794   2.441  1.00 55.54           H 
ATOM    890 3HB  ARG    57      21.242   7.417   2.547  1.00 36.29           H 
ATOM    891 2HB  ARG    57      20.686   7.579   0.888  1.00 36.29           H 
ATOM    892 3HG  ARG    57      19.818   5.348   0.883  1.00 36.29           H 
ATOM    893 2HG  ARG    57      20.095   5.182   2.617  1.00 36.29           H 
ATOM    894 3HD  ARG    57      22.517   5.369   2.245  1.00 36.29           H 
ATOM    895 2HD  ARG    57      22.232   5.513   0.511  1.00 36.29           H 
ATOM    896  HE  ARG    57      21.916   3.251   0.399  1.00 43.20           H 
ATOM    897 1HH1 ARG    57      21.780   4.201   3.720  1.00 36.29           H 
ATOM    898 2HH1 ARG    57      21.789   2.571   4.291  1.00 36.29           H 
ATOM    899 1HH2 ARG    57      21.937   1.188   1.149  1.00 36.29           H 
ATOM    900 2HH2 ARG    57      21.876   0.883   2.852  1.00 36.29           H 
ATOM    901  N   ASN    58      17.806   8.314   0.392  1.00  2.41           N 
ATOM    902  CA  ASN    58      16.763   8.148  -0.629  1.00  2.41           C 
ATOM    903  C   ASN    58      17.240   7.279  -1.803  1.00  2.33           C 
ATOM    904  O   ASN    58      18.232   7.601  -2.464  1.00 63.11           O 
ATOM    905  CB  ASN    58      16.314   9.515  -1.150  1.00 41.10           C 
ATOM    906  CG  ASN    58      15.650  10.352  -0.075  1.00 13.22           C 
ATOM    907  OD1 ASN    58      16.304  11.093   0.645  1.00 44.15           O 
ATOM    908  ND2 ASN    58      14.343  10.240   0.041  1.00 24.54           N 
ATOM    909  H   ASN    58      18.373   9.114   0.368  1.00 36.29           H 
ATOM    910  HA  ASN    58      15.918   7.660  -0.161  1.00 24.10           H 
ATOM    911 3HB  ASN    58      15.611   9.375  -1.960  1.00 36.29           H 
ATOM    912 2HB  ASN    58      17.174  10.055  -1.521  1.00 36.29           H 
ATOM    913 1HD2 ASN    58      13.876   9.632  -0.565  1.00 36.29           H 
ATOM    914 2HD2 ASN    58      13.897  10.779   0.725  1.00 36.29           H 
ATOM    915  N   ILE    59      16.520   6.190  -2.068  1.00 34.32           N 
ATOM    916  CA  ILE    59      16.845   5.283  -3.179  1.00 73.51           C 
ATOM    917  C   ILE    59      15.782   5.354  -4.293  1.00 70.25           C 
ATOM    918  O   ILE    59      14.581   5.247  -4.028  1.00 22.13           O 
ATOM    919  CB  ILE    59      16.965   3.815  -2.690  1.00 23.45           C 
ATOM    920  CG1 ILE    59      18.032   3.695  -1.584  1.00 74.33           C 
ATOM    921  CG2 ILE    59      17.285   2.875  -3.856  1.00 15.02           C 
ATOM    922  CD1 ILE    59      19.432   4.079  -2.022  1.00 13.53           C 
ATOM    923  H   ILE    59      15.749   5.984  -1.499  1.00 36.29           H 
ATOM    924  HA  ILE    59      17.801   5.584  -3.588  1.00  1.30           H 
ATOM    925  HB  ILE    59      16.007   3.519  -2.283  1.00 64.41           H 
ATOM    926 3HG1 ILE    59      18.065   2.674  -1.232  1.00 36.29           H 
ATOM    927 2HG1 ILE    59      17.758   4.341  -0.763  1.00 36.29           H 
ATOM    928 1HG2 ILE    59      18.205   3.188  -4.332  1.00 36.29           H 
ATOM    929 2HG2 ILE    59      16.479   2.907  -4.577  1.00 36.29           H 
ATOM    930 3HG2 ILE    59      17.397   1.866  -3.488  1.00 36.29           H 
ATOM    931 1HD1 ILE    59      19.444   5.115  -2.326  1.00 36.29           H 
ATOM    932 2HD1 ILE    59      19.737   3.456  -2.851  1.00 36.29           H 
ATOM    933 3HD1 ILE    59      20.116   3.939  -1.198  1.00 36.29           H 
ATOM    934  N   THR    60      16.233   5.539  -5.535  1.00 43.10           N 
ATOM    935  CA  THR    60      15.336   5.545  -6.700  1.00 34.12           C 
ATOM    936  C   THR    60      15.132   4.123  -7.238  1.00 54.15           C 
ATOM    937  O   THR    60      16.057   3.511  -7.776  1.00 51.13           O 
ATOM    938  CB  THR    60      15.885   6.435  -7.843  1.00 74.34           C 
ATOM    939  OG1 THR    60      16.092   7.782  -7.384  1.00 72.30           O 
ATOM    940  CG2 THR    60      14.931   6.456  -9.033  1.00 65.10           C 
ATOM    941  H   THR    60      17.195   5.672  -5.675  1.00 36.29           H 
ATOM    942  HA  THR    60      14.381   5.945  -6.386  1.00 51.21           H 
ATOM    943  HB  THR    60      16.833   6.027  -8.171  1.00 73.51           H 
ATOM    944  HG1 THR    60      16.320   7.772  -6.444  1.00 72.44           H 
ATOM    945 1HG2 THR    60      14.822   5.455  -9.430  1.00 36.29           H 
ATOM    946 2HG2 THR    60      15.328   7.103  -9.801  1.00 36.29           H 
ATOM    947 3HG2 THR    60      13.967   6.826  -8.716  1.00 36.29           H 
ATOM    948  N   LEU    61      13.915   3.606  -7.108  1.00 63.14           N 
ATOM    949  CA  LEU    61      13.625   2.206  -7.443  1.00 44.53           C 
ATOM    950  C   LEU    61      12.578   2.113  -8.578  1.00 20.35           C 
ATOM    951  O   LEU    61      11.699   2.967  -8.695  1.00 64.34           O 
ATOM    952  CB  LEU    61      13.140   1.497  -6.161  1.00 44.33           C 
ATOM    953  CG  LEU    61      13.415  -0.016  -6.057  1.00 34.51           C 
ATOM    954  CD1 LEU    61      12.478  -0.813  -6.944  1.00 22.52           C 
ATOM    955  CD2 LEU    61      14.871  -0.328  -6.396  1.00 62.10           C 
ATOM    956  H   LEU    61      13.189   4.176  -6.775  1.00 36.29           H 
ATOM    957  HA  LEU    61      14.543   1.742  -7.778  1.00 54.23           H 
ATOM    958 3HB  LEU    61      12.072   1.651  -6.075  1.00 36.29           H 
ATOM    959 2HB  LEU    61      13.614   1.977  -5.314  1.00 36.29           H 
ATOM    960  HG  LEU    61      13.241  -0.331  -5.035  1.00 61.22           H 
ATOM    961 1HD1 LEU    61      12.664  -0.570  -7.980  1.00 36.29           H 
ATOM    962 2HD1 LEU    61      11.454  -0.571  -6.697  1.00 36.29           H 
ATOM    963 3HD1 LEU    61      12.644  -1.869  -6.787  1.00 36.29           H 
ATOM    964 1HD2 LEU    61      15.048  -1.387  -6.287  1.00 36.29           H 
ATOM    965 2HD2 LEU    61      15.523   0.215  -5.725  1.00 36.29           H 
ATOM    966 3HD2 LEU    61      15.078  -0.032  -7.415  1.00 36.29           H 
ATOM    967  N   ARG    62      12.687   1.084  -9.426  1.00  5.25           N 
ATOM    968  CA  ARG    62      11.758   0.904 -10.564  1.00  0.12           C 
ATOM    969  C   ARG    62      10.657  -0.116 -10.205  1.00 14.25           C 
ATOM    970  O   ARG    62      10.910  -1.052  -9.452  1.00 12.44           O 
ATOM    971  CB  ARG    62      12.532   0.418 -11.809  1.00 14.05           C 
ATOM    972  CG  ARG    62      13.974   0.922 -11.884  1.00  0.13           C 
ATOM    973  CD  ARG    62      14.068   2.445 -11.941  1.00 64.11           C 
ATOM    974  NE  ARG    62      15.370   2.916 -11.472  1.00 64.20           N 
ATOM    975  CZ  ARG    62      15.885   4.079 -11.755  1.00 11.14           C 
ATOM    976  NH1 ARG    62      15.305   4.866 -12.604  1.00 64.40           N 
ATOM    977  NH2 ARG    62      17.003   4.441 -11.208  1.00  5.21           N 
ATOM    978  H   ARG    62      13.403   0.422  -9.283  1.00 36.29           H 
ATOM    979  HA  ARG    62      11.298   1.859 -10.781  1.00 55.31           H 
ATOM    980 3HB  ARG    62      12.012   0.753 -12.697  1.00 36.29           H 
ATOM    981 2HB  ARG    62      12.555  -0.664 -11.808  1.00 36.29           H 
ATOM    982 3HG  ARG    62      14.442   0.507 -12.768  1.00 36.29           H 
ATOM    983 2HG  ARG    62      14.505   0.577 -11.007  1.00 36.29           H 
ATOM    984 3HD  ARG    62      13.295   2.869 -11.315  1.00 36.29           H 
ATOM    985 2HD  ARG    62      13.922   2.767 -12.962  1.00 36.29           H 
ATOM    986  HE  ARG    62      15.872   2.323 -10.873  1.00 11.33           H 
ATOM    987 1HH1 ARG    62      14.461   4.583 -13.052  1.00 36.29           H 
ATOM    988 2HH1 ARG    62      15.709   5.756 -12.810  1.00 36.29           H 
ATOM    989 1HH2 ARG    62      17.467   3.827 -10.572  1.00 36.29           H 
ATOM    990 2HH2 ARG    62      17.398   5.335 -11.418  1.00 36.29           H 
ATOM    991  N   LYS    63       9.444   0.040 -10.757  1.00 50.11           N 
ATOM    992  CA  LYS    63       8.329  -0.874 -10.418  1.00 15.24           C 
ATOM    993  C   LYS    63       8.701  -2.345 -10.655  1.00  2.52           C 
ATOM    994  O   LYS    63       8.415  -3.199  -9.816  1.00  5.44           O 
ATOM    995  CB  LYS    63       7.044  -0.544 -11.199  1.00 12.43           C 
ATOM    996  CG  LYS    63       6.342   0.734 -10.740  1.00 21.11           C 
ATOM    997  CD  LYS    63       4.849   0.729 -11.083  1.00 33.00           C 
ATOM    998  CE  LYS    63       4.593   0.579 -12.581  1.00 42.00           C 
ATOM    999  NZ  LYS    63       4.997   1.787 -13.349  1.00 30.20           N 
ATOM   1000  H   LYS    63       9.297   0.764 -11.402  1.00 36.29           H 
ATOM   1001  HA  LYS    63       8.127  -0.747  -9.363  1.00 14.34           H 
ATOM   1002 3HB  LYS    63       6.350  -1.367 -11.091  1.00 36.29           H 
ATOM   1003 2HB  LYS    63       7.292  -0.435 -12.246  1.00 36.29           H 
ATOM   1004 3HG  LYS    63       6.808   1.576 -11.224  1.00 36.29           H 
ATOM   1005 2HG  LYS    63       6.450   0.831  -9.669  1.00 36.29           H 
ATOM   1006 3HD  LYS    63       4.413   1.658 -10.746  1.00 36.29           H 
ATOM   1007 2HD  LYS    63       4.377  -0.094 -10.567  1.00 36.29           H 
ATOM   1008 3HE  LYS    63       3.537   0.405 -12.736  1.00 36.29           H 
ATOM   1009 2HE  LYS    63       5.150  -0.269 -12.949  1.00 36.29           H 
ATOM   1010 1HZ  LYS    63       5.989   2.028 -13.153  1.00 36.29           H 
ATOM   1011 2HZ  LYS    63       4.396   2.594 -13.092  1.00 36.29           H 
ATOM   1012 3HZ  LYS    63       4.895   1.610 -14.369  1.00 36.29           H 
ATOM   1013  N   ARG    64       9.357  -2.628 -11.783  1.00  1.34           N 
ATOM   1014  CA  ARG    64       9.785  -3.998 -12.110  1.00 73.25           C 
ATOM   1015  C   ARG    64      10.526  -4.656 -10.924  1.00 60.40           C 
ATOM   1016  O   ARG    64      10.294  -5.819 -10.597  1.00 45.22           O 
ATOM   1017  CB  ARG    64      10.710  -3.987 -13.337  1.00  4.23           C 
ATOM   1018  CG  ARG    64      12.009  -3.221 -13.102  1.00 64.14           C 
ATOM   1019  CD  ARG    64      13.114  -3.634 -14.063  1.00 24.41           C 
ATOM   1020  NE  ARG    64      14.441  -3.279 -13.558  1.00 43.52           N 
ATOM   1021  CZ  ARG    64      15.548  -3.868 -13.929  1.00 14.12           C 
ATOM   1022  NH1 ARG    64      15.524  -4.827 -14.799  1.00 23.40           N 
ATOM   1023  NH2 ARG    64      16.678  -3.515 -13.404  1.00 63.42           N 
ATOM   1024  H   ARG    64       9.545  -1.903 -12.419  1.00 36.29           H 
ATOM   1025  HA  ARG    64       8.901  -4.578 -12.339  1.00  4.42           H 
ATOM   1026 3HB  ARG    64      10.189  -3.529 -14.167  1.00 36.29           H 
ATOM   1027 2HB  ARG    64      10.956  -5.008 -13.598  1.00 36.29           H 
ATOM   1028 3HG  ARG    64      12.337  -3.408 -12.093  1.00 36.29           H 
ATOM   1029 2HG  ARG    64      11.819  -2.164 -13.222  1.00 36.29           H 
ATOM   1030 3HD  ARG    64      12.954  -3.136 -15.010  1.00 36.29           H 
ATOM   1031 2HD  ARG    64      13.069  -4.704 -14.209  1.00 36.29           H 
ATOM   1032  HE  ARG    64      14.499  -2.571 -12.887  1.00 41.34           H 
ATOM   1033 1HH1 ARG    64      14.658  -5.123 -15.190  1.00 36.29           H 
ATOM   1034 2HH1 ARG    64      16.374  -5.269 -15.073  1.00 36.29           H 
ATOM   1035 1HH2 ARG    64      16.702  -2.795 -12.705  1.00 36.29           H 
ATOM   1036 2HH2 ARG    64      17.520  -3.961 -13.693  1.00 36.29           H 
ATOM   1037  N   GLU    65      11.404  -3.880 -10.285  1.00 61.05           N 
ATOM   1038  CA  GLU    65      12.196  -4.349  -9.145  1.00 55.32           C 
ATOM   1039  C   GLU    65      11.343  -4.329  -7.870  1.00  3.51           C 
ATOM   1040  O   GLU    65      11.424  -5.222  -7.029  1.00 44.33           O 
ATOM   1041  CB  GLU    65      13.432  -3.442  -8.974  1.00  1.13           C 
ATOM   1042  CG  GLU    65      14.341  -3.388 -10.209  1.00 41.14           C 
ATOM   1043  CD  GLU    65      15.236  -2.153 -10.271  1.00 41.31           C 
ATOM   1044  OE1 GLU    65      16.203  -2.161 -11.068  1.00  4.52           O 
ATOM   1045  OE2 GLU    65      14.960  -1.162  -9.560  1.00 15.04           O 
ATOM   1046  H   GLU    65      11.512  -2.954 -10.578  1.00 36.29           H 
ATOM   1047  HA  GLU    65      12.518  -5.362  -9.343  1.00  5.33           H 
ATOM   1048 3HB  GLU    65      14.017  -3.802  -8.139  1.00 36.29           H 
ATOM   1049 2HB  GLU    65      13.096  -2.438  -8.757  1.00 36.29           H 
ATOM   1050 3HG  GLU    65      13.725  -3.403 -11.093  1.00 36.29           H 
ATOM   1051 2HG  GLU    65      14.972  -4.264 -10.208  1.00 36.29           H 
ATOM   1052  N   ALA    66      10.501  -3.306  -7.759  1.00 74.01           N 
ATOM   1053  CA  ALA    66       9.648  -3.105  -6.586  1.00 54.13           C 
ATOM   1054  C   ALA    66       8.618  -4.233  -6.402  1.00 62.01           C 
ATOM   1055  O   ALA    66       8.259  -4.570  -5.274  1.00 65.11           O 
ATOM   1056  CB  ALA    66       8.948  -1.759  -6.691  1.00 33.23           C 
ATOM   1057  H   ALA    66      10.452  -2.660  -8.493  1.00 36.29           H 
ATOM   1058  HA  ALA    66      10.289  -3.077  -5.714  1.00  4.22           H 
ATOM   1059 1HB  ALA    66       8.336  -1.741  -7.582  1.00 36.29           H 
ATOM   1060 2HB  ALA    66       9.685  -0.971  -6.747  1.00 36.29           H 
ATOM   1061 3HB  ALA    66       8.324  -1.606  -5.823  1.00 36.29           H 
ATOM   1062  N   ASP    67       8.148  -4.812  -7.509  1.00 12.11           N 
ATOM   1063  CA  ASP    67       7.185  -5.920  -7.452  1.00  0.15           C 
ATOM   1064  C   ASP    67       7.825  -7.206  -6.901  1.00  3.24           C 
ATOM   1065  O   ASP    67       7.137  -8.193  -6.647  1.00 33.51           O 
ATOM   1066  CB  ASP    67       6.581  -6.186  -8.836  1.00  4.12           C 
ATOM   1067  CG  ASP    67       5.732  -5.032  -9.343  1.00 11.24           C 
ATOM   1068  OD1 ASP    67       5.988  -4.550 -10.467  1.00 73.02           O 
ATOM   1069  OD2 ASP    67       4.789  -4.615  -8.630  1.00 34.24           O 
ATOM   1070  H   ASP    67       8.452  -4.485  -8.384  1.00 36.29           H 
ATOM   1071  HA  ASP    67       6.391  -5.623  -6.780  1.00 33.35           H 
ATOM   1072 3HB  ASP    67       5.960  -7.071  -8.786  1.00 36.29           H 
ATOM   1073 2HB  ASP    67       7.382  -6.358  -9.541  1.00 36.29           H 
ATOM   1074  N   LEU    68       9.144  -7.192  -6.731  1.00 24.35           N 
ATOM   1075  CA  LEU    68       9.874  -8.339  -6.185  1.00 61.32           C 
ATOM   1076  C   LEU    68      10.061  -8.228  -4.664  1.00  1.11           C 
ATOM   1077  O   LEU    68      10.298  -9.226  -3.985  1.00 74.44           O 
ATOM   1078  CB  LEU    68      11.237  -8.455  -6.881  1.00 72.30           C 
ATOM   1079  CG  LEU    68      11.162  -8.742  -8.387  1.00 74.11           C 
ATOM   1080  CD1 LEU    68      12.512  -8.513  -9.052  1.00 61.03           C 
ATOM   1081  CD2 LEU    68      10.673 -10.168  -8.626  1.00 22.12           C 
ATOM   1082  H   LEU    68       9.645  -6.389  -6.989  1.00 36.29           H 
ATOM   1083  HA  LEU    68       9.299  -9.232  -6.397  1.00 54.21           H 
ATOM   1084 3HB  LEU    68      11.796  -9.254  -6.412  1.00 36.29           H 
ATOM   1085 2HB  LEU    68      11.774  -7.529  -6.733  1.00 36.29           H 
ATOM   1086  HG  LEU    68      10.451  -8.066  -8.840  1.00 51.12           H 
ATOM   1087 1HD1 LEU    68      12.827  -7.491  -8.889  1.00 36.29           H 
ATOM   1088 2HD1 LEU    68      12.427  -8.695 -10.113  1.00 36.29           H 
ATOM   1089 3HD1 LEU    68      13.245  -9.185  -8.630  1.00 36.29           H 
ATOM   1090 1HD2 LEU    68       9.688 -10.288  -8.197  1.00 36.29           H 
ATOM   1091 2HD2 LEU    68      11.353 -10.868  -8.161  1.00 36.29           H 
ATOM   1092 3HD2 LEU    68      10.627 -10.361  -9.687  1.00 36.29           H 
ATOM   1093  N   ILE    69       9.953  -7.016  -4.126  1.00 32.41           N 
ATOM   1094  CA  ILE    69      10.132  -6.802  -2.685  1.00 63.31           C 
ATOM   1095  C   ILE    69       8.779  -6.750  -1.955  1.00 63.13           C 
ATOM   1096  O   ILE    69       8.015  -5.790  -2.086  1.00 64.30           O 
ATOM   1097  CB  ILE    69      10.945  -5.510  -2.371  1.00 24.51           C 
ATOM   1098  CG1 ILE    69      12.412  -5.639  -2.835  1.00 14.50           C 
ATOM   1099  CG2 ILE    69      10.899  -5.195  -0.876  1.00 21.25           C 
ATOM   1100  CD1 ILE    69      12.599  -5.655  -4.336  1.00  2.34           C 
ATOM   1101  H   ILE    69       9.739  -6.251  -4.703  1.00 36.29           H 
ATOM   1102  HA  ILE    69      10.693  -7.646  -2.300  1.00 72.51           H 
ATOM   1103  HB  ILE    69      10.482  -4.687  -2.898  1.00 43.31           H 
ATOM   1104 3HG1 ILE    69      12.827  -6.556  -2.440  1.00 36.29           H 
ATOM   1105 2HG1 ILE    69      12.979  -4.804  -2.449  1.00 36.29           H 
ATOM   1106 1HG2 ILE    69      11.498  -4.318  -0.674  1.00 36.29           H 
ATOM   1107 2HG2 ILE    69      11.290  -6.033  -0.317  1.00 36.29           H 
ATOM   1108 3HG2 ILE    69       9.878  -5.008  -0.578  1.00 36.29           H 
ATOM   1109 1HD1 ILE    69      12.101  -6.517  -4.753  1.00 36.29           H 
ATOM   1110 2HD1 ILE    69      13.653  -5.703  -4.566  1.00 36.29           H 
ATOM   1111 3HD1 ILE    69      12.179  -4.756  -4.762  1.00 36.29           H 
ATOM   1112  N   GLU    70       8.493  -7.803  -1.192  1.00 51.00           N 
ATOM   1113  CA  GLU    70       7.270  -7.889  -0.385  1.00 21.43           C 
ATOM   1114  C   GLU    70       7.465  -7.194   0.973  1.00  1.31           C 
ATOM   1115  O   GLU    70       8.252  -7.642   1.806  1.00  1.33           O 
ATOM   1116  CB  GLU    70       6.887  -9.371  -0.196  1.00 12.20           C 
ATOM   1117  CG  GLU    70       5.743  -9.638   0.787  1.00 34.43           C 
ATOM   1118  CD  GLU    70       4.419  -8.995   0.395  1.00 23.32           C 
ATOM   1119  OE1 GLU    70       3.749  -8.420   1.280  1.00 75.23           O 
ATOM   1120  OE2 GLU    70       4.032  -9.066  -0.790  1.00 11.32           O 
ATOM   1121  H   GLU    70       9.129  -8.550  -1.169  1.00 36.29           H 
ATOM   1122  HA  GLU    70       6.479  -7.388  -0.924  1.00 40.21           H 
ATOM   1123 3HB  GLU    70       7.760  -9.908   0.153  1.00 36.29           H 
ATOM   1124 2HB  GLU    70       6.597  -9.775  -1.156  1.00 36.29           H 
ATOM   1125 3HG  GLU    70       6.035  -9.264   1.760  1.00 36.29           H 
ATOM   1126 2HG  GLU    70       5.591 -10.705   0.853  1.00 36.29           H 
ATOM   1127  N   VAL    71       6.751  -6.087   1.181  1.00 21.13           N 
ATOM   1128  CA  VAL    71       6.847  -5.305   2.424  1.00  4.42           C 
ATOM   1129  C   VAL    71       5.549  -5.384   3.248  1.00 51.21           C 
ATOM   1130  O   VAL    71       4.533  -5.888   2.774  1.00 71.21           O 
ATOM   1131  CB  VAL    71       7.179  -3.817   2.132  1.00 72.43           C 
ATOM   1132  CG1 VAL    71       8.526  -3.696   1.429  1.00 43.24           C 
ATOM   1133  CG2 VAL    71       6.079  -3.153   1.303  1.00 63.42           C 
ATOM   1134  H   VAL    71       6.138  -5.787   0.480  1.00 36.29           H 
ATOM   1135  HA  VAL    71       7.655  -5.719   3.016  1.00 44.22           H 
ATOM   1136  HB  VAL    71       7.249  -3.296   3.078  1.00 15.34           H 
ATOM   1137 1HG1 VAL    71       8.475  -4.172   0.461  1.00 36.29           H 
ATOM   1138 2HG1 VAL    71       9.287  -4.178   2.027  1.00 36.29           H 
ATOM   1139 3HG1 VAL    71       8.776  -2.652   1.304  1.00 36.29           H 
ATOM   1140 1HG2 VAL    71       5.952  -3.688   0.372  1.00 36.29           H 
ATOM   1141 2HG2 VAL    71       6.351  -2.128   1.094  1.00 36.29           H 
ATOM   1142 3HG2 VAL    71       5.151  -3.169   1.855  1.00 36.29           H 
ATOM   1143  N   GLU    72       5.591  -4.909   4.494  1.00 13.21           N 
ATOM   1144  CA  GLU    72       4.400  -4.901   5.363  1.00 65.30           C 
ATOM   1145  C   GLU    72       4.184  -3.529   6.021  1.00 61.31           C 
ATOM   1146  O   GLU    72       5.122  -2.926   6.542  1.00 33.12           O 
ATOM   1147  CB  GLU    72       4.518  -5.986   6.443  1.00 42.04           C 
ATOM   1148  CG  GLU    72       5.703  -5.806   7.386  1.00 60.42           C 
ATOM   1149  CD  GLU    72       5.798  -6.915   8.420  1.00 64.32           C 
ATOM   1150  OE1 GLU    72       4.933  -6.973   9.319  1.00 14.44           O 
ATOM   1151  OE2 GLU    72       6.733  -7.738   8.334  1.00 13.42           O 
ATOM   1152  H   GLU    72       6.440  -4.563   4.844  1.00 36.29           H 
ATOM   1153  HA  GLU    72       3.541  -5.122   4.744  1.00 12.44           H 
ATOM   1154 3HB  GLU    72       4.616  -6.946   5.957  1.00 36.29           H 
ATOM   1155 2HB  GLU    72       3.613  -5.988   7.036  1.00 36.29           H 
ATOM   1156 3HG  GLU    72       5.599  -4.860   7.901  1.00 36.29           H 
ATOM   1157 2HG  GLU    72       6.613  -5.795   6.800  1.00 36.29           H 
ATOM   1158  N   VAL    73       2.943  -3.048   6.001  1.00 73.32           N 
ATOM   1159  CA  VAL    73       2.608  -1.733   6.556  1.00 54.30           C 
ATOM   1160  C   VAL    73       2.806  -1.678   8.083  1.00  2.11           C 
ATOM   1161  O   VAL    73       2.025  -2.247   8.849  1.00 23.41           O 
ATOM   1162  CB  VAL    73       1.148  -1.340   6.212  1.00 71.11           C 
ATOM   1163  CG1 VAL    73       0.792   0.029   6.795  1.00 61.40           C 
ATOM   1164  CG2 VAL    73       0.931  -1.360   4.699  1.00  2.40           C 
ATOM   1165  H   VAL    73       2.230  -3.593   5.602  1.00 36.29           H 
ATOM   1166  HA  VAL    73       3.266  -1.006   6.097  1.00 74.10           H 
ATOM   1167  HB  VAL    73       0.488  -2.074   6.654  1.00 30.21           H 
ATOM   1168 1HG1 VAL    73       1.472   0.775   6.409  1.00 36.29           H 
ATOM   1169 2HG1 VAL    73       0.870  -0.005   7.873  1.00 36.29           H 
ATOM   1170 3HG1 VAL    73      -0.221   0.288   6.517  1.00 36.29           H 
ATOM   1171 1HG2 VAL    73      -0.095  -1.102   4.478  1.00 36.29           H 
ATOM   1172 2HG2 VAL    73       1.143  -2.348   4.317  1.00 36.29           H 
ATOM   1173 3HG2 VAL    73       1.590  -0.644   4.228  1.00 36.29           H 
ATOM   1174  N   VAL    74       3.851  -0.968   8.515  1.00 21.41           N 
ATOM   1175  CA  VAL    74       4.168  -0.824   9.945  1.00 24.21           C 
ATOM   1176  C   VAL    74       3.105   0.028  10.673  1.00 65.34           C 
ATOM   1177  O   VAL    74       3.011   0.016  11.901  1.00 40.43           O 
ATOM   1178  CB  VAL    74       5.574  -0.184  10.142  1.00 31.32           C 
ATOM   1179  CG1 VAL    74       5.956  -0.116  11.621  1.00  5.25           C 
ATOM   1180  CG2 VAL    74       6.631  -0.953   9.348  1.00 53.13           C 
ATOM   1181  H   VAL    74       4.428  -0.528   7.853  1.00 36.29           H 
ATOM   1182  HA  VAL    74       4.180  -1.813  10.383  1.00 43.12           H 
ATOM   1183  HB  VAL    74       5.538   0.828   9.759  1.00 60.52           H 
ATOM   1184 1HG1 VAL    74       6.930   0.343  11.724  1.00 36.29           H 
ATOM   1185 2HG1 VAL    74       5.985  -1.114  12.034  1.00 36.29           H 
ATOM   1186 3HG1 VAL    74       5.225   0.471  12.157  1.00 36.29           H 
ATOM   1187 1HG2 VAL    74       6.384  -0.926   8.296  1.00 36.29           H 
ATOM   1188 2HG2 VAL    74       6.661  -1.979   9.684  1.00 36.29           H 
ATOM   1189 3HG2 VAL    74       7.601  -0.498   9.500  1.00 36.29           H 
END
