
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  156 ( 1228),  selected  156 , name 1z3a_A
# Molecule2: number of CA atoms  162 ( 1272),  selected  162 , name T0461.pdb
# PARAMETERS: 1z3a_A.T0461.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S    13_A      E      16           -
LGA    E    14_A      N      17           -
LGA    -       -      L      18           -
LGA    -       -      Y      19           -
LGA    -       -      F      20           -
LGA    -       -      Q      21           -
LGA    -       -      S      22           -
LGA    V    15_A      M      23          6.357
LGA    E    16_A      E      24          3.808
LGA    F    17_A      E      25          0.556
LGA    S    18_A      T      26          2.597
LGA    H    19_A      E      27          3.806
LGA    E    20_A      -       -           -
LGA    Y    21_A      K      28          1.808
LGA    W    22_A      W      29          1.295
LGA    M    23_A      M      30          1.149
LGA    R    24_A      E      31          0.959
LGA    H    25_A      E      32          0.728
LGA    A    26_A      A      33          0.586
LGA    L    27_A      M      34          0.911
LGA    T    28_A      H      35          1.220
LGA    L    29_A      M      36          1.135
LGA    A    30_A      A      37          0.959
LGA    K    31_A      K      38          1.620
LGA    R    32_A      E      39          1.945
LGA    A    33_A      A      40          1.143
LGA    W    34_A      L      41          1.195
LGA    D    35_A      E      42          1.967
LGA    E    36_A      N      43          1.370
LGA    R    37_A      T      44          0.509
LGA    E    38_A      E      45          0.945
LGA    V    39_A      V      46          1.112
LGA    P    40_A      P      47          0.726
LGA    V    41_A      V      48          0.686
LGA    G    42_A      G      49          0.667
LGA    A    43_A      C      50          0.717
LGA    V    44_A      L      51          0.697
LGA    L    45_A      M      52          0.652
LGA    V    46_A      V      53          0.943
LGA    H    47_A      Y      54          1.264
LGA    N    48_A      N      55          2.361
LGA    N    49_A      N      56          2.740
LGA    R    50_A      E      57          1.799
LGA    V    51_A      V      58          0.852
LGA    I    52_A      V      59          0.500
LGA    G    53_A      G      60          0.292
LGA    E    54_A      K      61          0.290
LGA    G    55_A      G      62          0.295
LGA    W    56_A      R      63          0.406
LGA    N    57_A      N      64          0.716
LGA    R    58_A      E      65          1.329
LGA    P    59_A      V      66          0.749
LGA    I    60_A      N      67          1.352
LGA    G    61_A      Q      68          1.089
LGA    R    62_A      T      69          0.345
LGA    H    63_A      K      70          1.479
LGA    D    64_A      N      71          1.080
LGA    P    65_A      A      72          1.425
LGA    T    66_A      T      73          1.145
LGA    A    67_A      R      74          0.472
LGA    H    68_A      H      75          0.213
LGA    A    69_A      A      76          0.386
LGA    E    70_A      E      77          0.430
LGA    I    71_A      M      78          0.537
LGA    M    72_A      V      79          0.591
LGA    A    73_A      A      80          0.777
LGA    L    74_A      I      81          1.155
LGA    R    75_A      D      82          1.171
LGA    Q    76_A      Q      83          0.438
LGA    G    77_A      V      84          0.857
LGA    G    78_A      L      85          1.488
LGA    L    79_A      D      86          1.377
LGA    V    80_A      W      87          0.692
LGA    M    81_A      C      88          2.365
LGA    Q    82_A      R      89          3.147
LGA    -       -      Q      90           -
LGA    -       -      S      91           -
LGA    -       -      G      92           -
LGA    -       -      K      93           -
LGA    N    83_A      S      94          3.310
LGA    Y    84_A      P      95          3.252
LGA    R    85_A      S      96          2.519
LGA    -       -      E      97           -
LGA    -       -      V      98           -
LGA    L    86_A      F      99          0.885
LGA    I    87_A      E     100          1.447
LGA    D    88_A      H     101          1.173
LGA    A    89_A      T     102          0.540
LGA    T    90_A      V     103          0.534
LGA    L    91_A      L     104          0.577
LGA    Y    92_A      Y     105          0.928
LGA    V    93_A      V     106          0.914
LGA    T    94_A      T     107          0.480
LGA    L    95_A      V     108          0.485
LGA    E    96_A      E     109          0.558
LGA    P    97_A      P     110          0.581
LGA    C    98_A      C     111          0.686
LGA    V    99_A      I     112          1.109
LGA    M   100_A      M     113          1.022
LGA    C   101_A      C     114          0.554
LGA    A   102_A      A     115          0.628
LGA    G   103_A      A     116          1.361
LGA    A   104_A      A     117          1.254
LGA    M   105_A      L     118          0.616
LGA    I   106_A      R     119          1.230
LGA    H   107_A      L     120          1.741
LGA    S   108_A      M     121          1.367
LGA    R   109_A      K     122          1.290
LGA    I   110_A      I     123          1.071
LGA    G   111_A      P     124          1.525
LGA    R   112_A      L     125          0.669
LGA    V   113_A      V     126          0.859
LGA    V   114_A      V     127          1.045
LGA    F   115_A      Y     128          1.144
LGA    G   116_A      G     129          0.600
LGA    A   117_A      C     130          0.653
LGA    R   118_A      Q     131          0.292
LGA    D   119_A      N     132          0.858
LGA    A   120_A      E     133          1.401
LGA    K   121_A      R     134          2.107
LGA    T   122_A      F     135          1.085
LGA    G   123_A      G     136          0.098
LGA    A   124_A      G     137          0.407
LGA    A   125_A      C     138          0.453
LGA    G   126_A      G     139          0.369
LGA    S   127_A      S     140          0.479
LGA    L   128_A      V     141          0.394
LGA    M   129_A      L     142          0.381
LGA    D   130_A      N     143          0.849
LGA    V   131_A      I     144          0.818
LGA    L   132_A      A     145          1.414
LGA    H   133_A      S     146          1.164
LGA    H   134_A      A     147          0.991
LGA    P   135_A      D     148          0.582
LGA    G   136_A      L     149          0.910
LGA    -       -      P     150           -
LGA    -       -      N     151           -
LGA    M   137_A      T     152          3.565
LGA    N   138_A      G     153          3.379
LGA    H   139_A      R     154          0.883
LGA    R   140_A      P     155          1.849
LGA    V   141_A      F     156          1.528
LGA    E   142_A      Q     157          1.271
LGA    I   143_A      C     158          1.159
LGA    T   144_A      I     159          1.081
LGA    E   145_A      P     160          0.879
LGA    G   146_A      G     161          0.960
LGA    I   147_A      Y     162          1.060
LGA    L   148_A      R     163          1.049
LGA    A   149_A      A     164          0.650
LGA    D   150_A      E     165          1.002
LGA    E   151_A      E     166          1.327
LGA    C   152_A      A     167          0.915
LGA    A   153_A      V     168          1.010
LGA    A   154_A      E     169          1.385
LGA    L   155_A      M     170          1.530
LGA    L   156_A      L     171          1.434
LGA    S   157_A      K     172          2.101
LGA    D   158_A      T     173          2.554
LGA    F   159_A      F     174          2.201
LGA    F   160_A      Y     175          2.554
LGA    R   161_A      K     176          3.561
LGA    M   162_A      -       -           -
LGA    R   163_A      -       -           -
LGA    R   164_A      Q     177          3.868
LGA    Q   165_A      -       -           -
LGA    E   166_A      -       -           -
LGA    I   167_A      -       -           -
LGA    K   168_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  156  162    5.0    147    1.53    32.65     85.126     9.032

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.559302 * X  +  -0.723410 * Y  +   0.404796 * Z  +  16.920401
  Y_new =  -0.316971 * X  +  -0.264579 * Y  +  -0.910784 * Z  +  42.047531
  Z_new =   0.765971 * X  +  -0.637711 * Y  +  -0.081321 * Z  +  24.607185 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.697631    1.443961  [ DEG:   -97.2671     82.7329 ]
  Theta =  -0.872550   -2.269043  [ DEG:   -49.9934   -130.0066 ]
  Phi   =  -2.625998    0.515594  [ DEG:  -150.4586     29.5414 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1z3a_A                                        
REMARK     2: T0461.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1z3a_A.T0461.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  156  162   5.0  147   1.53   32.65  85.126
REMARK  ---------------------------------------------------------- 
MOLECULE 1z3a_A
HEADER    HYDROLASE                               10-MAR-05   1Z3A              
TITLE     CRYSTAL STRUCTURE OF TRNA ADENOSINE DEAMINASE TADA FROM               
TITLE    2 ESCHERICHIA COLI                                                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TRNA-SPECIFIC ADENOSINE DEAMINASE;                         
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 EC: 3.5.4.-;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: TADA;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21                                       
KEYWDS    TRNA ADENOSINE DEAMINASE, DIMER, ZINC, METALLOENZYME,                 
KEYWDS   2 STRUCTURAL GENOMICS, PSI, PROTEIN STRUCTURE INITIATIVE, NEW          
KEYWDS   3 YORK STRUCTURAL GENOMIX RESEARCH CONSORTIUM, NYSGXRC                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    V.N.MALASHKEVICH,J.KIM,M.LISBIN,S.C.ALMO,S.K.BURLEY,NEW               
AUTHOR   2 YORK STRUCTURAL GENOMIX RESEARCH CONSORTIUM (NYSGXRC)                
REVDAT   1   21-FEB-06 1Z3A    0                                                
JRNL        AUTH   V.N.MALASHKEVICH,J.KIM,M.LISBIN,S.C.ALMO                     
JRNL        TITL   CRYSTAL STRUCTURE OF TRNA DEAMINASE TADA FROM                
JRNL        TITL 2 ESCHERICHIA COLI                                             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.03 ANGSTROMS.                                          
DBREF  1Z3A A   12   178  UNP    P68398   TADA_ECOLI      12    178             
DBREF  1Z3A B   12   178  UNP    P68398   TADA_ECOLI      12    178             
SEQRES   1 A  168  MET LEU SER GLU VAL GLU PHE SER HIS GLU TYR TRP MET          
SEQRES   2 A  168  ARG HIS ALA LEU THR LEU ALA LYS ARG ALA TRP ASP GLU          
SEQRES   3 A  168  ARG GLU VAL PRO VAL GLY ALA VAL LEU VAL HIS ASN ASN          
SEQRES   4 A  168  ARG VAL ILE GLY GLU GLY TRP ASN ARG PRO ILE GLY ARG          
SEQRES   5 A  168  HIS ASP PRO THR ALA HIS ALA GLU ILE MET ALA LEU ARG          
SEQRES   6 A  168  GLN GLY GLY LEU VAL MET GLN ASN TYR ARG LEU ILE ASP          
SEQRES   7 A  168  ALA THR LEU TYR VAL THR LEU GLU PRO CYS VAL MET CYS          
SEQRES   8 A  168  ALA GLY ALA MET ILE HIS SER ARG ILE GLY ARG VAL VAL          
SEQRES   9 A  168  PHE GLY ALA ARG ASP ALA LYS THR GLY ALA ALA GLY SER          
SEQRES  10 A  168  LEU MET ASP VAL LEU HIS HIS PRO GLY MET ASN HIS ARG          
SEQRES  11 A  168  VAL GLU ILE THR GLU GLY ILE LEU ALA ASP GLU CYS ALA          
SEQRES  12 A  168  ALA LEU LEU SER ASP PHE PHE ARG MET ARG ARG GLN GLU          
SEQRES  13 A  168  ILE LYS ALA GLN LYS LYS ALA GLN SER SER THR ASP              
SEQRES   1 B  168  MET LEU SER GLU VAL GLU PHE SER HIS GLU TYR TRP MET          
SEQRES   2 B  168  ARG HIS ALA LEU THR LEU ALA LYS ARG ALA TRP ASP GLU          
SEQRES   3 B  168  ARG GLU VAL PRO VAL GLY ALA VAL LEU VAL HIS ASN ASN          
SEQRES   4 B  168  ARG VAL ILE GLY GLU GLY TRP ASN ARG PRO ILE GLY ARG          
SEQRES   5 B  168  HIS ASP PRO THR ALA HIS ALA GLU ILE MET ALA LEU ARG          
SEQRES   6 B  168  GLN GLY GLY LEU VAL MET GLN ASN TYR ARG LEU ILE ASP          
SEQRES   7 B  168  ALA THR LEU TYR VAL THR LEU GLU PRO CYS VAL MET CYS          
SEQRES   8 B  168  ALA GLY ALA MET ILE HIS SER ARG ILE GLY ARG VAL VAL          
SEQRES   9 B  168  PHE GLY ALA ARG ASP ALA LYS THR GLY ALA ALA GLY SER          
SEQRES  10 B  168  LEU MET ASP VAL LEU HIS HIS PRO GLY MET ASN HIS ARG          
SEQRES  11 B  168  VAL GLU ILE THR GLU GLY ILE LEU ALA ASP GLU CYS ALA          
SEQRES  12 B  168  ALA LEU LEU SER ASP PHE PHE ARG MET ARG ARG GLN GLU          
SEQRES  13 B  168  ILE LYS ALA GLN LYS LYS ALA GLN SER SER THR ASP              
HET     ZN  A 301       1                                                       
HET     ZN  B 302       1                                                       
HETNAM      ZN ZINC ION                                                         
FORMUL   3   ZN    2(ZN 2+)                                                     
FORMUL   5  HOH   *226(H2 O)                                                    
CRYST1  100.232  100.232  159.576  90.00  90.00  90.00 I 41 2 2     32          
ATOM      1  N   SER A  13       0.704  35.545  45.898  1.00 56.37           N  
ATOM      2  CA  SER A  13       0.707  34.943  44.521  1.00 56.07           C  
ATOM      3  C   SER A  13       1.581  33.676  44.400  1.00 53.87           C  
ATOM      4  O   SER A  13       1.029  32.602  44.162  1.00 53.31           O  
ATOM      5  CB  SER A  13       1.136  35.998  43.489  1.00 56.00           C  
ATOM      6  OG  SER A  13       1.056  35.484  42.169  1.00 58.86           O  
ATOM      7  N   GLU A  14       2.912  33.791  44.576  1.00 51.18           N  
ATOM      8  CA  GLU A  14       3.845  32.625  44.488  1.00 49.33           C  
ATOM      9  C   GLU A  14       4.805  32.395  45.664  1.00 45.85           C  
ATOM     10  O   GLU A  14       5.936  32.872  45.676  1.00 47.44           O  
ATOM     11  CB  GLU A  14       4.679  32.683  43.196  1.00 48.34           C  
ATOM     12  CG  GLU A  14       3.844  32.425  41.964  1.00 44.72           C  
ATOM     13  CD  GLU A  14       4.649  32.454  40.692  1.00 46.27           C  
ATOM     14  OE1 GLU A  14       4.062  32.215  39.623  1.00 42.07           O  
ATOM     15  OE2 GLU A  14       5.867  32.718  40.756  1.00 47.80           O  
ATOM     16  N   VAL A  15       4.355  31.615  46.630  1.00 42.91           N  
ATOM     17  CA  VAL A  15       5.130  31.322  47.808  1.00 41.64           C  
ATOM     18  C   VAL A  15       6.413  30.539  47.573  1.00 40.29           C  
ATOM     19  O   VAL A  15       6.489  29.596  46.778  1.00 33.64           O  
ATOM     20  CB  VAL A  15       4.240  30.604  48.849  1.00 42.60           C  
ATOM     21  CG1 VAL A  15       3.211  29.805  48.144  1.00 47.10           C  
ATOM     22  CG2 VAL A  15       5.062  29.722  49.762  1.00 45.17           C  
ATOM     23  N   GLU A  16       7.425  30.948  48.312  1.00 39.71           N  
ATOM     24  CA  GLU A  16       8.734  30.341  48.228  1.00 39.59           C  
ATOM     25  C   GLU A  16       8.666  28.826  48.344  1.00 36.69           C  
ATOM     26  O   GLU A  16       8.065  28.279  49.271  1.00 33.34           O  
ATOM     27  CB  GLU A  16       9.600  30.933  49.322  1.00 43.45           C  
ATOM     28  CG  GLU A  16      11.068  30.579  49.267  1.00 49.40           C  
ATOM     29  CD  GLU A  16      11.811  31.288  50.386  1.00 52.60           C  
ATOM     30  OE1 GLU A  16      11.376  31.161  51.554  1.00 56.84           O  
ATOM     31  OE2 GLU A  16      12.805  31.975  50.108  1.00 55.57           O  
ATOM     32  N   PHE A  17       9.268  28.154  47.371  1.00 32.42           N  
ATOM     33  CA  PHE A  17       9.309  26.700  47.325  1.00 30.25           C  
ATOM     34  C   PHE A  17       8.026  25.967  46.964  1.00 29.47           C  
ATOM     35  O   PHE A  17       7.956  24.727  47.057  1.00 30.71           O  
ATOM     36  CB  PHE A  17       9.851  26.142  48.627  1.00 32.42           C  
ATOM     37  CG  PHE A  17      11.142  26.754  49.037  1.00 37.37           C  
ATOM     38  CD1 PHE A  17      12.152  26.972  48.098  1.00 38.60           C  
ATOM     39  CD2 PHE A  17      11.370  27.092  50.363  1.00 39.28           C  
ATOM     40  CE1 PHE A  17      13.375  27.521  48.479  1.00 41.57           C  
ATOM     41  CE2 PHE A  17      12.586  27.638  50.754  1.00 43.80           C  
ATOM     42  CZ  PHE A  17      13.593  27.855  49.811  1.00 43.22           C  
ATOM     43  N   SER A  18       7.007  26.715  46.563  1.00 25.41           N  
ATOM     44  CA  SER A  18       5.766  26.089  46.126  1.00 24.99           C  
ATOM     45  C   SER A  18       6.070  25.552  44.704  1.00 26.76           C  
ATOM     46  O   SER A  18       7.152  25.838  44.115  1.00 24.46           O  
ATOM     47  CB  SER A  18       4.653  27.127  46.064  1.00 26.31           C  
ATOM     48  OG  SER A  18       5.024  28.212  45.245  1.00 26.43           O  
ATOM     49  N   HIS A  19       5.132  24.794  44.151  1.00 25.08           N  
ATOM     50  CA  HIS A  19       5.331  24.254  42.803  1.00 24.48           C  
ATOM     51  C   HIS A  19       5.474  25.381  41.786  1.00 25.30           C  
ATOM     52  O   HIS A  19       6.308  25.289  40.880  1.00 24.12           O  
ATOM     53  CB  HIS A  19       4.173  23.339  42.406  1.00 23.24           C  
ATOM     54  CG  HIS A  19       4.131  22.056  43.179  1.00 22.64           C  
ATOM     55  ND1 HIS A  19       5.272  21.416  43.607  1.00 23.20           N  
ATOM     56  CD2 HIS A  19       3.100  21.239  43.502  1.00 23.45           C  
ATOM     57  CE1 HIS A  19       4.948  20.254  44.147  1.00 25.01           C  
ATOM     58  NE2 HIS A  19       3.637  20.121  44.097  1.00 22.77           N  
ATOM     59  N   GLU A  20       4.663  26.440  41.922  1.00 24.10           N  
ATOM     60  CA  GLU A  20       4.720  27.567  40.987  1.00 21.92           C  
ATOM     61  C   GLU A  20       6.074  28.284  41.083  1.00 25.34           C  
ATOM     62  O   GLU A  20       6.624  28.727  40.081  1.00 26.74           O  
ATOM     63  CB  GLU A  20       3.580  28.557  41.250  1.00 24.43           C  
ATOM     64  CG  GLU A  20       2.224  28.116  40.715  1.00 25.03           C  
ATOM     65  CD  GLU A  20       1.545  27.063  41.604  1.00 27.78           C  
ATOM     66  OE1 GLU A  20       1.891  26.969  42.811  1.00 24.82           O  
ATOM     67  OE2 GLU A  20       0.660  26.358  41.096  1.00 24.71           O  
ATOM     68  N   TYR A  21       6.607  28.405  42.288  1.00 24.93           N  
ATOM     69  CA  TYR A  21       7.920  29.030  42.477  1.00 26.59           C  
ATOM     70  C   TYR A  21       9.001  28.238  41.705  1.00 25.64           C  
ATOM     71  O   TYR A  21       9.834  28.820  41.002  1.00 26.44           O  
ATOM     72  CB  TYR A  21       8.252  29.029  43.964  1.00 26.52           C  
ATOM     73  CG  TYR A  21       9.678  29.419  44.293  1.00 30.62           C  
ATOM     74  CD1 TYR A  21      10.036  30.757  44.509  1.00 30.48           C  
ATOM     75  CD2 TYR A  21      10.660  28.428  44.439  1.00 27.69           C  
ATOM     76  CE1 TYR A  21      11.356  31.089  44.895  1.00 34.23           C  
ATOM     77  CE2 TYR A  21      11.955  28.734  44.799  1.00 32.61           C  
ATOM     78  CZ  TYR A  21      12.309  30.061  45.040  1.00 33.90           C  
ATOM     79  OH  TYR A  21      13.592  30.305  45.472  1.00 36.35           O  
ATOM     80  N   TRP A  22       9.014  26.915  41.845  1.00 25.51           N  
ATOM     81  CA  TRP A  22      10.017  26.116  41.108  1.00 23.58           C  
ATOM     82  C   TRP A  22       9.709  26.092  39.605  1.00 22.69           C  
ATOM     83  O   TRP A  22      10.625  26.162  38.771  1.00 24.50           O  
ATOM     84  CB  TRP A  22      10.106  24.696  41.679  1.00 20.46           C  
ATOM     85  CG  TRP A  22      10.760  24.665  43.036  1.00 19.22           C  
ATOM     86  CD1 TRP A  22      10.215  24.207  44.195  1.00 22.77           C  
ATOM     87  CD2 TRP A  22      12.094  25.072  43.354  1.00 22.99           C  
ATOM     88  NE1 TRP A  22      11.117  24.293  45.223  1.00 23.22           N  
ATOM     89  CE2 TRP A  22      12.286  24.824  44.736  1.00 23.45           C  
ATOM     90  CE3 TRP A  22      13.153  25.622  42.607  1.00 23.36           C  
ATOM     91  CZ2 TRP A  22      13.486  25.103  45.382  1.00 25.12           C  
ATOM     92  CZ3 TRP A  22      14.368  25.906  43.271  1.00 25.14           C  
ATOM     93  CH2 TRP A  22      14.514  25.645  44.634  1.00 25.56           C  
ATOM     94  N   MET A  23       8.438  26.002  39.229  1.00 20.62           N  
ATOM     95  CA  MET A  23       8.147  26.020  37.807  1.00 22.58           C  
ATOM     96  C   MET A  23       8.605  27.362  37.179  1.00 25.23           C  
ATOM     97  O   MET A  23       9.019  27.417  36.012  1.00 24.32           O  
ATOM     98  CB  MET A  23       6.657  25.830  37.558  1.00 22.82           C  
ATOM     99  CG  MET A  23       6.308  25.612  36.070  1.00 23.33           C  
ATOM    100  SD  MET A  23       7.085  24.051  35.449  1.00 25.11           S  
ATOM    101  CE  MET A  23       6.008  22.836  36.215  1.00 20.41           C  
ATOM    102  N   ARG A  24       8.528  28.450  37.943  1.00 24.84           N  
ATOM    103  CA  ARG A  24       8.925  29.744  37.381  1.00 25.69           C  
ATOM    104  C   ARG A  24      10.444  29.687  37.110  1.00 27.47           C  
ATOM    105  O   ARG A  24      10.937  30.228  36.115  1.00 28.86           O  
ATOM    106  CB  ARG A  24       8.534  30.915  38.304  1.00 28.11           C  
ATOM    107  CG  ARG A  24       8.713  32.281  37.602  1.00 33.05           C  
ATOM    108  CD  ARG A  24       7.775  33.400  38.118  1.00 39.24           C  
ATOM    109  NE  ARG A  24       6.326  33.118  37.986  1.00 39.17           N  
ATOM    110  CZ  ARG A  24       5.623  33.106  36.855  1.00 35.06           C  
ATOM    111  NH1 ARG A  24       6.196  33.358  35.686  1.00 41.24           N  
ATOM    112  NH2 ARG A  24       4.326  32.852  36.894  1.00 30.51           N  
ATOM    113  N   HIS A  25      11.186  29.028  37.982  1.00 25.77           N  
ATOM    114  CA  HIS A  25      12.607  28.871  37.722  1.00 29.85           C  
ATOM    115  C   HIS A  25      12.788  28.007  36.441  1.00 29.32           C  
ATOM    116  O   HIS A  25      13.651  28.297  35.607  1.00 29.56           O  
ATOM    117  CB  HIS A  25      13.290  28.198  38.886  1.00 33.74           C  
ATOM    118  CG  HIS A  25      14.778  28.239  38.788  1.00 41.89           C  
ATOM    119  ND1 HIS A  25      15.567  27.118  38.917  1.00 43.22           N  
ATOM    120  CD2 HIS A  25      15.627  29.270  38.559  1.00 45.76           C  
ATOM    121  CE1 HIS A  25      16.836  27.451  38.775  1.00 42.60           C  
ATOM    122  NE2 HIS A  25      16.902  28.750  38.555  1.00 49.00           N  
ATOM    123  N   ALA A  26      11.966  26.968  36.264  1.00 25.00           N  
ATOM    124  CA  ALA A  26      12.067  26.134  35.051  1.00 24.30           C  
ATOM    125  C   ALA A  26      11.796  26.977  33.798  1.00 25.84           C  
ATOM    126  O   ALA A  26      12.419  26.767  32.734  1.00 25.55           O  
ATOM    127  CB  ALA A  26      11.093  24.925  35.120  1.00 21.35           C  
ATOM    128  N   LEU A  27      10.877  27.932  33.921  1.00 25.14           N  
ATOM    129  CA  LEU A  27      10.582  28.840  32.806  1.00 26.51           C  
ATOM    130  C   LEU A  27      11.779  29.757  32.491  1.00 24.56           C  
ATOM    131  O   LEU A  27      11.978  30.132  31.358  1.00 28.75           O  
ATOM    132  CB  LEU A  27       9.345  29.684  33.100  1.00 29.35           C  
ATOM    133  CG  LEU A  27       8.004  29.006  32.827  1.00 30.39           C  
ATOM    134  CD1 LEU A  27       6.904  29.852  33.486  1.00 32.93           C  
ATOM    135  CD2 LEU A  27       7.749  28.877  31.324  1.00 30.65           C  
ATOM    136  N   THR A  28      12.584  30.103  33.474  1.00 27.23           N  
ATOM    137  CA  THR A  28      13.774  30.912  33.206  1.00 27.20           C  
ATOM    138  C   THR A  28      14.709  30.039  32.342  1.00 32.74           C  
ATOM    139  O   THR A  28      15.390  30.533  31.446  1.00 33.48           O  
ATOM    140  CB  THR A  28      14.491  31.298  34.536  1.00 32.39           C  
ATOM    141  OG1 THR A  28      13.642  32.171  35.310  1.00 35.91           O  
ATOM    142  CG2 THR A  28      15.797  32.028  34.264  1.00 33.61           C  
ATOM    143  N   LEU A  29      14.746  28.736  32.613  1.00 29.42           N  
ATOM    144  CA  LEU A  29      15.582  27.825  31.831  1.00 28.78           C  
ATOM    145  C   LEU A  29      14.991  27.584  30.435  1.00 27.30           C  
ATOM    146  O   LEU A  29      15.731  27.479  29.454  1.00 28.78           O  
ATOM    147  CB  LEU A  29      15.745  26.503  32.585  1.00 27.87           C  
ATOM    148  CG  LEU A  29      16.415  26.722  33.946  1.00 31.11           C  
ATOM    149  CD1 LEU A  29      16.472  25.457  34.759  1.00 26.45           C  
ATOM    150  CD2 LEU A  29      17.827  27.247  33.690  1.00 33.58           C  
ATOM    151  N   ALA A  30      13.667  27.517  30.334  1.00 23.97           N  
ATOM    152  CA  ALA A  30      13.023  27.317  29.053  1.00 23.69           C  
ATOM    153  C   ALA A  30      13.348  28.498  28.123  1.00 30.02           C  
ATOM    154  O   ALA A  30      13.371  28.350  26.887  1.00 30.17           O  
ATOM    155  CB  ALA A  30      11.545  27.222  29.213  1.00 21.91           C  
ATOM    156  N   LYS A  31      13.584  29.668  28.708  1.00 31.50           N  
ATOM    157  CA  LYS A  31      13.914  30.835  27.891  1.00 36.02           C  
ATOM    158  C   LYS A  31      15.341  30.713  27.360  1.00 34.83           C  
ATOM    159  O   LYS A  31      15.630  31.263  26.303  1.00 35.33           O  
ATOM    160  CB  LYS A  31      13.716  32.148  28.669  1.00 40.03           C  
ATOM    161  CG  LYS A  31      12.225  32.536  28.796  1.00 49.66           C  
ATOM    162  CD  LYS A  31      11.972  33.633  29.844  1.00 57.34           C  
ATOM    163  CE  LYS A  31      10.463  33.788  30.175  1.00 61.90           C  
ATOM    164  NZ  LYS A  31       9.642  34.489  29.131  1.00 64.56           N  
ATOM    165  N   ARG A  32      16.230  30.034  28.089  1.00 31.31           N  
ATOM    166  CA  ARG A  32      17.582  29.820  27.561  1.00 34.81           C  
ATOM    167  C   ARG A  32      17.426  28.972  26.291  1.00 32.65           C  
ATOM    168  O   ARG A  32      18.070  29.245  25.281  1.00 30.53           O  
ATOM    169  CB  ARG A  32      18.509  29.116  28.567  1.00 36.14           C  
ATOM    170  CG  ARG A  32      18.781  29.988  29.771  1.00 45.41           C  
ATOM    171  CD  ARG A  32      20.065  29.669  30.475  1.00 49.99           C  
ATOM    172  NE  ARG A  32      21.213  29.705  29.565  1.00 55.20           N  
ATOM    173  CZ  ARG A  32      22.475  29.532  29.954  1.00 55.33           C  
ATOM    174  NH1 ARG A  32      22.754  29.327  31.241  1.00 57.13           N  
ATOM    175  NH2 ARG A  32      23.451  29.508  29.052  1.00 54.77           N  
ATOM    176  N   ALA A  33      16.559  27.956  26.330  1.00 29.99           N  
ATOM    177  CA  ALA A  33      16.343  27.159  25.126  1.00 30.07           C  
ATOM    178  C   ALA A  33      15.829  28.100  24.025  1.00 29.89           C  
ATOM    179  O   ALA A  33      16.274  28.041  22.885  1.00 29.90           O  
ATOM    180  CB  ALA A  33      15.340  26.029  25.380  1.00 23.50           C  
ATOM    181  N   TRP A  34      14.899  28.972  24.381  1.00 31.88           N  
ATOM    182  CA  TRP A  34      14.329  29.935  23.439  1.00 32.41           C  
ATOM    183  C   TRP A  34      15.451  30.695  22.731  1.00 32.51           C  
ATOM    184  O   TRP A  34      15.476  30.772  21.504  1.00 35.39           O  
ATOM    185  CB  TRP A  34      13.439  30.928  24.202  1.00 36.73           C  
ATOM    186  CG  TRP A  34      13.005  32.115  23.352  1.00 43.86           C  
ATOM    187  CD1 TRP A  34      13.761  33.210  23.009  1.00 41.61           C  
ATOM    188  CD2 TRP A  34      11.770  32.244  22.641  1.00 44.16           C  
ATOM    189  NE1 TRP A  34      13.072  33.993  22.125  1.00 43.51           N  
ATOM    190  CE2 TRP A  34      11.849  33.428  21.879  1.00 45.07           C  
ATOM    191  CE3 TRP A  34      10.608  31.467  22.569  1.00 45.22           C  
ATOM    192  CZ2 TRP A  34      10.807  33.857  21.049  1.00 47.25           C  
ATOM    193  CZ3 TRP A  34       9.568  31.885  21.746  1.00 50.27           C  
ATOM    194  CH2 TRP A  34       9.675  33.075  20.992  1.00 51.33           C  
ATOM    195  N   ASP A  35      16.364  31.272  23.507  1.00 31.76           N  
ATOM    196  CA  ASP A  35      17.486  32.034  22.949  1.00 35.02           C  
ATOM    197  C   ASP A  35      18.357  31.177  22.007  1.00 35.96           C  
ATOM    198  O   ASP A  35      18.814  31.648  20.958  1.00 36.97           O  
ATOM    199  CB  ASP A  35      18.351  32.615  24.070  1.00 36.05           C  
ATOM    200  CG  ASP A  35      17.613  33.667  24.919  1.00 38.23           C  
ATOM    201  OD1 ASP A  35      16.568  34.193  24.491  1.00 41.24           O  
ATOM    202  OD2 ASP A  35      18.094  33.978  26.027  1.00 41.54           O  
ATOM    203  N   GLU A  36      18.587  29.919  22.362  1.00 31.53           N  
ATOM    204  CA  GLU A  36      19.384  29.042  21.504  1.00 30.81           C  
ATOM    205  C   GLU A  36      18.595  28.534  20.298  1.00 29.51           C  
ATOM    206  O   GLU A  36      19.078  27.683  19.533  1.00 29.52           O  
ATOM    207  CB  GLU A  36      19.911  27.861  22.324  1.00 32.44           C  
ATOM    208  CG  GLU A  36      20.904  28.305  23.383  1.00 33.73           C  
ATOM    209  CD  GLU A  36      21.355  27.164  24.279  1.00 36.78           C  
ATOM    210  OE1 GLU A  36      21.082  25.986  23.942  1.00 37.63           O  
ATOM    211  OE2 GLU A  36      22.003  27.440  25.305  1.00 35.04           O  
ATOM    212  N   ARG A  37      17.363  29.030  20.156  1.00 28.93           N  
ATOM    213  CA  ARG A  37      16.468  28.643  19.063  1.00 30.58           C  
ATOM    214  C   ARG A  37      16.009  27.182  19.074  1.00 32.31           C  
ATOM    215  O   ARG A  37      15.831  26.558  18.028  1.00 32.13           O  
ATOM    216  CB  ARG A  37      17.120  28.993  17.705  1.00 37.81           C  
ATOM    217  CG  ARG A  37      17.439  30.494  17.574  1.00 45.13           C  
ATOM    218  CD  ARG A  37      18.006  30.829  16.202  1.00 55.35           C  
ATOM    219  NE  ARG A  37      17.115  30.333  15.148  1.00 65.37           N  
ATOM    220  CZ  ARG A  37      15.850  30.737  14.961  1.00 69.19           C  
ATOM    221  NH1 ARG A  37      15.311  31.663  15.755  1.00 70.96           N  
ATOM    222  NH2 ARG A  37      15.107  30.185  14.000  1.00 69.38           N  
ATOM    223  N   GLU A  38      15.804  26.635  20.265  1.00 30.48           N  
ATOM    224  CA  GLU A  38      15.304  25.266  20.410  1.00 27.14           C  
ATOM    225  C   GLU A  38      13.875  25.379  20.982  1.00 27.03           C  
ATOM    226  O   GLU A  38      13.499  26.421  21.506  1.00 27.16           O  
ATOM    227  CB  GLU A  38      16.156  24.502  21.443  1.00 26.09           C  
ATOM    228  CG  GLU A  38      17.648  24.613  21.258  1.00 25.69           C  
ATOM    229  CD  GLU A  38      18.265  23.439  20.512  1.00 28.16           C  
ATOM    230  OE1 GLU A  38      17.523  22.523  20.041  1.00 25.42           O  
ATOM    231  OE2 GLU A  38      19.513  23.436  20.416  1.00 28.18           O  
ATOM    232  N   VAL A  39      13.084  24.318  20.870  1.00 28.35           N  
ATOM    233  CA  VAL A  39      11.746  24.306  21.472  1.00 29.30           C  
ATOM    234  C   VAL A  39      12.001  24.714  22.938  1.00 28.75           C  
ATOM    235  O   VAL A  39      12.825  24.109  23.631  1.00 26.48           O  
ATOM    236  CB  VAL A  39      11.150  22.925  21.352  1.00 28.23           C  
ATOM    237  CG1 VAL A  39       9.742  22.883  21.975  1.00 29.55           C  
ATOM    238  CG2 VAL A  39      11.053  22.618  19.885  1.00 30.40           C  
ATOM    239  N   PRO A  40      11.323  25.776  23.411  1.00 27.83           N  
ATOM    240  CA  PRO A  40      11.570  26.207  24.774  1.00 27.47           C  
ATOM    241  C   PRO A  40      10.953  25.399  25.909  1.00 27.43           C  
ATOM    242  O   PRO A  40       9.820  25.671  26.296  1.00 28.31           O  
ATOM    243  CB  PRO A  40      11.094  27.654  24.753  1.00 28.99           C  
ATOM    244  CG  PRO A  40       9.882  27.567  23.831  1.00 25.93           C  
ATOM    245  CD  PRO A  40      10.402  26.710  22.714  1.00 28.38           C  
ATOM    246  N   VAL A  41      11.731  24.439  26.435  1.00 26.35           N  
ATOM    247  CA  VAL A  41      11.329  23.593  27.563  1.00 22.91           C  
ATOM    248  C   VAL A  41      12.462  23.686  28.561  1.00 24.44           C  
ATOM    249  O   VAL A  41      13.657  23.601  28.200  1.00 21.54           O  
ATOM    250  CB  VAL A  41      11.104  22.100  27.150  1.00 26.87           C  
ATOM    251  CG1 VAL A  41      10.637  21.258  28.401  1.00 25.56           C  
ATOM    252  CG2 VAL A  41      10.016  22.013  26.074  1.00 23.20           C  
ATOM    253  N   GLY A  42      12.107  23.909  29.823  1.00 22.48           N  
ATOM    254  CA  GLY A  42      13.122  24.014  30.853  1.00 20.59           C  
ATOM    255  C   GLY A  42      12.820  23.068  31.992  1.00 20.59           C  
ATOM    256  O   GLY A  42      11.671  22.673  32.149  1.00 22.18           O  
ATOM    257  N   ALA A  43      13.829  22.688  32.774  1.00 20.67           N  
ATOM    258  CA  ALA A  43      13.568  21.809  33.905  1.00 19.34           C  
ATOM    259  C   ALA A  43      14.533  22.055  35.037  1.00 22.97           C  
ATOM    260  O   ALA A  43      15.706  22.387  34.813  1.00 20.57           O  
ATOM    261  CB  ALA A  43      13.645  20.352  33.494  1.00 17.31           C  
ATOM    262  N   VAL A  44      14.031  21.900  36.265  1.00 21.03           N  
ATOM    263  CA  VAL A  44      14.885  22.029  37.432  1.00 20.32           C  
ATOM    264  C   VAL A  44      14.609  20.854  38.363  1.00 20.93           C  
ATOM    265  O   VAL A  44      13.439  20.466  38.572  1.00 23.55           O  
ATOM    266  CB  VAL A  44      14.703  23.375  38.193  1.00 23.63           C  
ATOM    267  CG1 VAL A  44      13.270  23.617  38.571  1.00 22.73           C  
ATOM    268  CG2 VAL A  44      15.559  23.336  39.475  1.00 23.29           C  
ATOM    269  N   LEU A  45      15.690  20.247  38.869  1.00 21.10           N  
ATOM    270  CA  LEU A  45      15.595  19.096  39.771  1.00 20.74           C  
ATOM    271  C   LEU A  45      15.898  19.616  41.167  1.00 22.02           C  
ATOM    272  O   LEU A  45      16.935  20.225  41.401  1.00 22.20           O  
ATOM    273  CB  LEU A  45      16.602  18.021  39.393  1.00 19.59           C  
ATOM    274  CG  LEU A  45      16.584  16.707  40.178  1.00 21.06           C  
ATOM    275  CD1 LEU A  45      15.254  15.933  39.993  1.00 19.50           C  
ATOM    276  CD2 LEU A  45      17.800  15.861  39.712  1.00 24.12           C  
ATOM    277  N   VAL A  46      14.980  19.349  42.082  1.00 22.44           N  
ATOM    278  CA  VAL A  46      15.062  19.866  43.445  1.00 25.54           C  
ATOM    279  C   VAL A  46      15.067  18.752  44.480  1.00 27.49           C  
ATOM    280  O   VAL A  46      14.347  17.754  44.359  1.00 24.61           O  
ATOM    281  CB  VAL A  46      13.833  20.782  43.757  1.00 26.59           C  
ATOM    282  CG1 VAL A  46      13.942  21.366  45.185  1.00 27.78           C  
ATOM    283  CG2 VAL A  46      13.732  21.895  42.743  1.00 22.48           C  
ATOM    284  N   HIS A  47      15.894  18.933  45.498  1.00 28.92           N  
ATOM    285  CA  HIS A  47      15.983  17.970  46.588  1.00 29.62           C  
ATOM    286  C   HIS A  47      16.048  18.792  47.877  1.00 31.03           C  
ATOM    287  O   HIS A  47      16.947  19.634  48.036  1.00 27.80           O  
ATOM    288  CB  HIS A  47      17.239  17.120  46.446  1.00 32.52           C  
ATOM    289  CG  HIS A  47      17.312  16.011  47.444  1.00 40.09           C  
ATOM    290  ND1 HIS A  47      16.433  14.950  47.437  1.00 44.29           N  
ATOM    291  CD2 HIS A  47      18.124  15.822  48.510  1.00 41.82           C  
ATOM    292  CE1 HIS A  47      16.701  14.153  48.456  1.00 44.96           C  
ATOM    293  NE2 HIS A  47      17.724  14.660  49.121  1.00 44.96           N  
ATOM    294  N   ASN A  48      15.098  18.558  48.787  1.00 32.05           N  
ATOM    295  CA  ASN A  48      15.038  19.327  50.021  1.00 32.47           C  
ATOM    296  C   ASN A  48      15.142  20.810  49.721  1.00 33.27           C  
ATOM    297  O   ASN A  48      15.929  21.529  50.340  1.00 33.26           O  
ATOM    298  CB  ASN A  48      16.169  18.911  50.950  1.00 37.25           C  
ATOM    299  CG  ASN A  48      16.004  17.490  51.434  1.00 43.37           C  
ATOM    300  OD1 ASN A  48      14.869  17.014  51.597  1.00 46.47           O  
ATOM    301  ND2 ASN A  48      17.122  16.799  51.677  1.00 45.11           N  
ATOM    302  N   ASN A  49      14.366  21.250  48.740  1.00 32.62           N  
ATOM    303  CA  ASN A  49      14.309  22.651  48.326  1.00 33.26           C  
ATOM    304  C   ASN A  49      15.593  23.338  47.911  1.00 31.43           C  
ATOM    305  O   ASN A  49      15.731  24.551  48.037  1.00 33.43           O  
ATOM    306  CB  ASN A  49      13.585  23.475  49.394  1.00 38.20           C  
ATOM    307  CG  ASN A  49      12.087  23.253  49.360  1.00 41.19           C  
ATOM    308  OD1 ASN A  49      11.457  22.994  50.392  1.00 43.16           O  
ATOM    309  ND2 ASN A  49      11.501  23.339  48.155  1.00 39.47           N  
ATOM    310  N   ARG A  50      16.530  22.547  47.407  1.00 31.17           N  
ATOM    311  CA  ARG A  50      17.817  23.025  46.886  1.00 30.87           C  
ATOM    312  C   ARG A  50      17.874  22.516  45.425  1.00 28.58           C  
ATOM    313  O   ARG A  50      17.454  21.386  45.128  1.00 27.54           O  
ATOM    314  CB  ARG A  50      18.989  22.386  47.653  1.00 35.26           C  
ATOM    315  CG  ARG A  50      19.399  23.087  48.945  1.00 48.64           C  
ATOM    316  CD  ARG A  50      20.688  23.860  48.694  1.00 58.74           C  
ATOM    317  NE  ARG A  50      21.653  23.038  47.943  1.00 67.31           N  
ATOM    318  CZ  ARG A  50      22.121  23.324  46.724  1.00 70.06           C  
ATOM    319  NH1 ARG A  50      21.721  24.430  46.096  1.00 72.67           N  
ATOM    320  NH2 ARG A  50      22.984  22.498  46.126  1.00 68.36           N  
ATOM    321  N   VAL A  51      18.405  23.321  44.531  1.00 28.64           N  
ATOM    322  CA  VAL A  51      18.517  22.897  43.144  1.00 28.29           C  
ATOM    323  C   VAL A  51      19.681  21.916  43.047  1.00 28.42           C  
ATOM    324  O   VAL A  51      20.770  22.230  43.499  1.00 28.18           O  
ATOM    325  CB  VAL A  51      18.778  24.095  42.217  1.00 29.27           C  
ATOM    326  CG1 VAL A  51      19.017  23.607  40.775  1.00 28.31           C  
ATOM    327  CG2 VAL A  51      17.557  25.048  42.249  1.00 29.33           C  
ATOM    328  N   ILE A  52      19.456  20.710  42.529  1.00 24.73           N  
ATOM    329  CA  ILE A  52      20.592  19.825  42.366  1.00 26.41           C  
ATOM    330  C   ILE A  52      20.817  19.507  40.876  1.00 26.13           C  
ATOM    331  O   ILE A  52      21.756  18.803  40.522  1.00 26.78           O  
ATOM    332  CB  ILE A  52      20.498  18.493  43.203  1.00 28.16           C  
ATOM    333  CG1 ILE A  52      19.402  17.564  42.682  1.00 29.99           C  
ATOM    334  CG2 ILE A  52      20.327  18.822  44.709  1.00 25.96           C  
ATOM    335  CD1 ILE A  52      18.087  18.101  42.845  1.00 41.03           C  
ATOM    336  N   GLY A  53      19.950  20.040  40.017  1.00 26.10           N  
ATOM    337  CA  GLY A  53      20.119  19.847  38.587  1.00 23.73           C  
ATOM    338  C   GLY A  53      19.295  20.847  37.813  1.00 24.68           C  
ATOM    339  O   GLY A  53      18.197  21.182  38.239  1.00 23.92           O  
ATOM    340  N   GLU A  54      19.798  21.347  36.683  1.00 22.58           N  
ATOM    341  CA  GLU A  54      18.991  22.276  35.868  1.00 25.20           C  
ATOM    342  C   GLU A  54      19.176  21.852  34.416  1.00 26.14           C  
ATOM    343  O   GLU A  54      20.239  21.335  34.087  1.00 22.52           O  
ATOM    344  CB  GLU A  54      19.481  23.715  35.971  1.00 28.07           C  
ATOM    345  CG  GLU A  54      19.315  24.349  37.334  1.00 37.19           C  
ATOM    346  CD  GLU A  54      19.827  25.763  37.338  1.00 38.91           C  
ATOM    347  OE1 GLU A  54      20.894  26.005  36.743  1.00 44.41           O  
ATOM    348  OE2 GLU A  54      19.180  26.634  37.934  1.00 45.40           O  
ATOM    349  N   GLY A  55      18.175  22.076  33.562  1.00 23.17           N  
ATOM    350  CA  GLY A  55      18.339  21.712  32.171  1.00 19.20           C  
ATOM    351  C   GLY A  55      17.394  22.449  31.254  1.00 21.22           C  
ATOM    352  O   GLY A  55      16.412  23.029  31.702  1.00 21.57           O  
ATOM    353  N   TRP A  56      17.726  22.489  29.964  1.00 21.30           N  
ATOM    354  CA  TRP A  56      16.825  23.049  28.962  1.00 20.00           C  
ATOM    355  C   TRP A  56      16.982  22.171  27.739  1.00 21.76           C  
ATOM    356  O   TRP A  56      17.958  21.421  27.601  1.00 20.61           O  
ATOM    357  CB  TRP A  56      17.089  24.554  28.660  1.00 24.17           C  
ATOM    358  CG  TRP A  56      18.500  24.966  28.254  1.00 25.23           C  
ATOM    359  CD1 TRP A  56      18.992  25.094  26.987  1.00 22.45           C  
ATOM    360  CD2 TRP A  56      19.577  25.286  29.141  1.00 24.51           C  
ATOM    361  NE1 TRP A  56      20.317  25.467  27.036  1.00 27.63           N  
ATOM    362  CE2 TRP A  56      20.701  25.589  28.343  1.00 26.08           C  
ATOM    363  CE3 TRP A  56      19.695  25.344  30.538  1.00 24.37           C  
ATOM    364  CZ2 TRP A  56      21.945  25.948  28.894  1.00 27.40           C  
ATOM    365  CZ3 TRP A  56      20.921  25.704  31.092  1.00 29.04           C  
ATOM    366  CH2 TRP A  56      22.036  26.001  30.261  1.00 28.94           C  
ATOM    367  N   ASN A  57      15.986  22.211  26.888  1.00 19.48           N  
ATOM    368  CA  ASN A  57      15.979  21.446  25.667  1.00 23.60           C  
ATOM    369  C   ASN A  57      17.065  21.963  24.696  1.00 24.30           C  
ATOM    370  O   ASN A  57      17.128  23.161  24.440  1.00 21.40           O  
ATOM    371  CB  ASN A  57      14.602  21.642  25.071  1.00 23.90           C  
ATOM    372  CG  ASN A  57      14.364  20.848  23.823  1.00 28.27           C  
ATOM    373  OD1 ASN A  57      14.002  21.416  22.780  1.00 33.49           O  
ATOM    374  ND2 ASN A  57      14.518  19.545  23.909  1.00 26.72           N  
ATOM    375  N   ARG A  58      17.921  21.090  24.163  1.00 23.40           N  
ATOM    376  CA  ARG A  58      18.923  21.555  23.196  1.00 24.03           C  
ATOM    377  C   ARG A  58      19.448  20.445  22.256  1.00 22.91           C  
ATOM    378  O   ARG A  58      20.645  20.316  22.006  1.00 24.41           O  
ATOM    379  CB  ARG A  58      20.067  22.244  23.954  1.00 25.65           C  
ATOM    380  CG  ARG A  58      20.666  21.474  25.102  1.00 27.57           C  
ATOM    381  CD  ARG A  58      21.687  22.369  25.869  1.00 30.26           C  
ATOM    382  NE  ARG A  58      22.546  21.541  26.713  1.00 33.64           N  
ATOM    383  CZ  ARG A  58      23.638  21.964  27.364  1.00 35.40           C  
ATOM    384  NH1 ARG A  58      24.047  23.242  27.280  1.00 27.86           N  
ATOM    385  NH2 ARG A  58      24.319  21.092  28.100  1.00 28.15           N  
ATOM    386  N   PRO A  59      18.544  19.640  21.710  1.00 20.03           N  
ATOM    387  CA  PRO A  59      19.008  18.579  20.832  1.00 20.74           C  
ATOM    388  C   PRO A  59      19.709  19.085  19.556  1.00 23.40           C  
ATOM    389  O   PRO A  59      20.672  18.480  19.095  1.00 21.08           O  
ATOM    390  CB  PRO A  59      17.724  17.784  20.540  1.00 19.07           C  
ATOM    391  CG  PRO A  59      16.665  18.863  20.579  1.00 19.86           C  
ATOM    392  CD  PRO A  59      17.072  19.661  21.799  1.00 22.46           C  
ATOM    393  N   ILE A  60      19.249  20.197  18.991  1.00 23.00           N  
ATOM    394  CA  ILE A  60      19.868  20.690  17.779  1.00 26.96           C  
ATOM    395  C   ILE A  60      21.302  21.169  17.989  1.00 27.27           C  
ATOM    396  O   ILE A  60      22.223  20.738  17.281  1.00 31.46           O  
ATOM    397  CB  ILE A  60      19.006  21.804  17.163  1.00 30.21           C  
ATOM    398  CG1 ILE A  60      17.620  21.231  16.842  1.00 32.29           C  
ATOM    399  CG2 ILE A  60      19.636  22.303  15.847  1.00 28.17           C  
ATOM    400  CD1 ILE A  60      16.632  22.337  16.413  1.00 35.86           C  
ATOM    401  N   GLY A  61      21.493  22.021  18.980  1.00 23.86           N  
ATOM    402  CA  GLY A  61      22.807  22.540  19.266  1.00 25.24           C  
ATOM    403  C   GLY A  61      23.775  21.506  19.814  1.00 25.59           C  
ATOM    404  O   GLY A  61      24.978  21.671  19.657  1.00 25.49           O  
ATOM    405  N   ARG A  62      23.274  20.437  20.454  1.00 22.34           N  
ATOM    406  CA  ARG A  62      24.184  19.420  21.001  1.00 21.77           C  
ATOM    407  C   ARG A  62      24.380  18.271  20.031  1.00 21.10           C  
ATOM    408  O   ARG A  62      25.202  17.386  20.276  1.00 19.92           O  
ATOM    409  CB  ARG A  62      23.616  18.862  22.326  1.00 21.03           C  
ATOM    410  CG  ARG A  62      23.625  19.887  23.488  1.00 26.32           C  
ATOM    411  CD  ARG A  62      25.032  20.050  24.052  1.00 29.31           C  
ATOM    412  NE  ARG A  62      25.537  18.734  24.433  1.00 33.95           N  
ATOM    413  CZ  ARG A  62      26.233  18.456  25.531  1.00 36.08           C  
ATOM    414  NH1 ARG A  62      26.538  19.418  26.400  1.00 33.24           N  
ATOM    415  NH2 ARG A  62      26.617  17.196  25.760  1.00 32.73           N  
ATOM    416  N   HIS A  63      23.583  18.250  18.965  1.00 20.75           N  
ATOM    417  CA  HIS A  63      23.652  17.141  17.984  1.00 21.52           C  
ATOM    418  C   HIS A  63      23.388  15.900  18.797  1.00 22.65           C  
ATOM    419  O   HIS A  63      24.116  14.901  18.672  1.00 22.32           O  
ATOM    420  CB  HIS A  63      25.060  17.028  17.368  1.00 24.20           C  
ATOM    421  CG  HIS A  63      25.410  18.170  16.468  1.00 28.04           C  
ATOM    422  ND1 HIS A  63      26.710  18.582  16.250  1.00 29.19           N  
ATOM    423  CD2 HIS A  63      24.620  19.028  15.778  1.00 30.26           C  
ATOM    424  CE1 HIS A  63      26.703  19.653  15.476  1.00 27.36           C  
ATOM    425  NE2 HIS A  63      25.449  19.945  15.176  1.00 30.54           N  
ATOM    426  N   ASP A  64      22.318  15.940  19.591  1.00 20.18           N  
ATOM    427  CA  ASP A  64      22.053  14.837  20.521  1.00 19.30           C  
ATOM    428  C   ASP A  64      20.556  14.677  20.655  1.00 19.98           C  
ATOM    429  O   ASP A  64      19.896  15.515  21.230  1.00 19.12           O  
ATOM    430  CB  ASP A  64      22.710  15.217  21.869  1.00 18.79           C  
ATOM    431  CG  ASP A  64      22.485  14.187  22.964  1.00 22.04           C  
ATOM    432  OD1 ASP A  64      21.740  13.205  22.759  1.00 19.92           O  
ATOM    433  OD2 ASP A  64      23.067  14.391  24.042  1.00 21.01           O  
ATOM    434  N   PRO A  65      20.012  13.578  20.132  1.00 18.69           N  
ATOM    435  CA  PRO A  65      18.560  13.359  20.207  1.00 21.42           C  
ATOM    436  C   PRO A  65      18.051  13.183  21.633  1.00 24.27           C  
ATOM    437  O   PRO A  65      16.828  13.232  21.866  1.00 22.00           O  
ATOM    438  CB  PRO A  65      18.351  12.110  19.350  1.00 19.99           C  
ATOM    439  CG  PRO A  65      19.685  11.323  19.584  1.00 22.85           C  
ATOM    440  CD  PRO A  65      20.732  12.414  19.565  1.00 18.75           C  
ATOM    441  N   THR A  66      18.969  12.989  22.583  1.00 19.95           N  
ATOM    442  CA  THR A  66      18.543  12.795  23.952  1.00 22.44           C  
ATOM    443  C   THR A  66      18.692  14.044  24.796  1.00 21.66           C  
ATOM    444  O   THR A  66      18.429  14.012  26.006  1.00 22.29           O  
ATOM    445  CB  THR A  66      19.360  11.654  24.676  1.00 25.40           C  
ATOM    446  OG1 THR A  66      20.692  12.109  24.932  1.00 21.67           O  
ATOM    447  CG2 THR A  66      19.416  10.391  23.831  1.00 21.47           C  
ATOM    448  N   ALA A  67      19.125  15.145  24.188  1.00 20.37           N  
ATOM    449  CA  ALA A  67      19.317  16.357  24.969  1.00 20.28           C  
ATOM    450  C   ALA A  67      18.023  17.125  25.342  1.00 21.43           C  
ATOM    451  O   ALA A  67      17.867  18.268  24.970  1.00 20.67           O  
ATOM    452  CB  ALA A  67      20.331  17.300  24.253  1.00 16.79           C  
ATOM    453  N   HIS A  68      17.100  16.489  26.072  1.00 21.79           N  
ATOM    454  CA  HIS A  68      15.893  17.184  26.543  1.00 19.30           C  
ATOM    455  C   HIS A  68      16.214  17.794  27.877  1.00 18.79           C  
ATOM    456  O   HIS A  68      17.205  17.421  28.503  1.00 17.72           O  
ATOM    457  CB  HIS A  68      14.730  16.210  26.699  1.00 19.29           C  
ATOM    458  CG  HIS A  68      14.156  15.816  25.387  1.00 20.70           C  
ATOM    459  ND1 HIS A  68      12.987  15.106  25.262  1.00 21.22           N  
ATOM    460  CD2 HIS A  68      14.564  16.099  24.126  1.00 22.82           C  
ATOM    461  CE1 HIS A  68      12.686  14.966  23.987  1.00 22.11           C  
ATOM    462  NE2 HIS A  68      13.624  15.560  23.272  1.00 24.31           N  
ATOM    463  N   ALA A  69      15.375  18.733  28.291  1.00 18.22           N  
ATOM    464  CA  ALA A  69      15.547  19.458  29.548  1.00 19.51           C  
ATOM    465  C   ALA A  69      15.691  18.501  30.708  1.00 18.10           C  
ATOM    466  O   ALA A  69      16.594  18.660  31.521  1.00 20.72           O  
ATOM    467  CB  ALA A  69      14.348  20.374  29.803  1.00 16.09           C  
ATOM    468  N   GLU A  70      14.792  17.522  30.765  1.00 18.34           N  
ATOM    469  CA  GLU A  70      14.763  16.526  31.834  1.00 20.13           C  
ATOM    470  C   GLU A  70      16.029  15.693  31.916  1.00 20.39           C  
ATOM    471  O   GLU A  70      16.567  15.491  32.978  1.00 20.08           O  
ATOM    472  CB  GLU A  70      13.561  15.589  31.650  1.00 19.46           C  
ATOM    473  CG  GLU A  70      12.188  16.318  31.571  1.00 19.00           C  
ATOM    474  CD  GLU A  70      11.777  16.575  30.100  1.00 25.60           C  
ATOM    475  OE1 GLU A  70      12.578  17.154  29.334  1.00 21.93           O  
ATOM    476  OE2 GLU A  70      10.663  16.196  29.720  1.00 21.97           O  
ATOM    477  N   ILE A  71      16.499  15.203  30.786  1.00 18.83           N  
ATOM    478  CA  ILE A  71      17.733  14.408  30.778  1.00 17.62           C  
ATOM    479  C   ILE A  71      18.896  15.252  31.333  1.00 20.17           C  
ATOM    480  O   ILE A  71      19.677  14.777  32.148  1.00 24.89           O  
ATOM    481  CB  ILE A  71      18.077  13.984  29.330  1.00 19.30           C  
ATOM    482  CG1 ILE A  71      16.918  13.176  28.764  1.00 18.62           C  
ATOM    483  CG2 ILE A  71      19.416  13.199  29.283  1.00 19.71           C  
ATOM    484  CD1 ILE A  71      16.593  11.932  29.611  1.00 22.38           C  
ATOM    485  N   MET A  72      19.024  16.492  30.869  1.00 18.75           N  
ATOM    486  CA  MET A  72      20.101  17.373  31.324  1.00 19.95           C  
ATOM    487  C   MET A  72      20.018  17.590  32.853  1.00 20.16           C  
ATOM    488  O   MET A  72      21.012  17.504  33.551  1.00 18.37           O  
ATOM    489  CB  MET A  72      19.986  18.728  30.571  1.00 22.89           C  
ATOM    490  CG  MET A  72      21.099  19.741  30.870  1.00 27.39           C  
ATOM    491  SD  MET A  72      21.025  21.203  29.770  1.00 28.42           S  
ATOM    492  CE  MET A  72      22.008  22.426  30.690  1.00 32.14           C  
ATOM    493  N   ALA A  73      18.825  17.875  33.371  1.00 18.54           N  
ATOM    494  CA  ALA A  73      18.669  18.084  34.811  1.00 18.41           C  
ATOM    495  C   ALA A  73      18.976  16.811  35.574  1.00 21.25           C  
ATOM    496  O   ALA A  73      19.641  16.874  36.613  1.00 23.79           O  
ATOM    497  CB  ALA A  73      17.232  18.567  35.133  1.00 21.70           C  
ATOM    498  N   LEU A  74      18.526  15.650  35.064  1.00 18.73           N  
ATOM    499  CA  LEU A  74      18.788  14.391  35.749  1.00 19.15           C  
ATOM    500  C   LEU A  74      20.276  14.014  35.765  1.00 21.80           C  
ATOM    501  O   LEU A  74      20.802  13.526  36.774  1.00 19.32           O  
ATOM    502  CB  LEU A  74      17.955  13.236  35.133  1.00 20.40           C  
ATOM    503  CG  LEU A  74      16.433  13.312  35.360  1.00 23.23           C  
ATOM    504  CD1 LEU A  74      15.726  12.277  34.508  1.00 17.75           C  
ATOM    505  CD2 LEU A  74      16.116  13.072  36.873  1.00 24.74           C  
ATOM    506  N   ARG A  75      20.965  14.222  34.652  1.00 20.17           N  
ATOM    507  CA  ARG A  75      22.393  13.894  34.624  1.00 21.54           C  
ATOM    508  C   ARG A  75      23.184  14.811  35.549  1.00 23.00           C  
ATOM    509  O   ARG A  75      24.161  14.389  36.175  1.00 25.11           O  
ATOM    510  CB  ARG A  75      22.963  14.035  33.207  1.00 21.12           C  
ATOM    511  CG  ARG A  75      22.345  13.064  32.233  1.00 23.53           C  
ATOM    512  CD  ARG A  75      23.102  13.148  30.879  1.00 28.01           C  
ATOM    513  NE  ARG A  75      24.458  12.615  30.943  1.00 31.05           N  
ATOM    514  CZ  ARG A  75      25.478  13.131  30.245  1.00 38.29           C  
ATOM    515  NH1 ARG A  75      25.258  14.192  29.465  1.00 37.14           N  
ATOM    516  NH2 ARG A  75      26.693  12.583  30.278  1.00 29.74           N  
ATOM    517  N   GLN A  76      22.790  16.072  35.639  1.00 22.06           N  
ATOM    518  CA  GLN A  76      23.517  16.954  36.552  1.00 23.47           C  
ATOM    519  C   GLN A  76      23.253  16.527  38.008  1.00 23.55           C  
ATOM    520  O   GLN A  76      24.168  16.520  38.851  1.00 25.53           O  
ATOM    521  CB  GLN A  76      23.128  18.435  36.359  1.00 21.53           C  
ATOM    522  CG  GLN A  76      23.844  19.340  37.406  1.00 27.55           C  
ATOM    523  CD  GLN A  76      23.775  20.845  37.119  1.00 32.38           C  
ATOM    524  OE1 GLN A  76      22.742  21.364  36.703  1.00 27.49           O  
ATOM    525  NE2 GLN A  76      24.902  21.557  37.365  1.00 31.98           N  
ATOM    526  N   GLY A  77      22.006  16.155  38.295  1.00 24.63           N  
ATOM    527  CA  GLY A  77      21.646  15.731  39.642  1.00 21.81           C  
ATOM    528  C   GLY A  77      22.457  14.517  40.082  1.00 24.71           C  
ATOM    529  O   GLY A  77      22.936  14.430  41.243  1.00 24.52           O  
ATOM    530  N   GLY A  78      22.636  13.582  39.154  1.00 21.65           N  
ATOM    531  CA  GLY A  78      23.385  12.368  39.475  1.00 20.80           C  
ATOM    532  C   GLY A  78      24.794  12.708  39.885  1.00 25.72           C  
ATOM    533  O   GLY A  78      25.378  12.099  40.799  1.00 25.63           O  
ATOM    534  N   LEU A  79      25.357  13.679  39.180  1.00 28.09           N  
ATOM    535  CA  LEU A  79      26.712  14.129  39.436  1.00 30.84           C  
ATOM    536  C   LEU A  79      26.764  14.877  40.779  1.00 33.15           C  
ATOM    537  O   LEU A  79      27.637  14.628  41.628  1.00 32.14           O  
ATOM    538  CB  LEU A  79      27.129  15.051  38.289  1.00 32.50           C  
ATOM    539  CG  LEU A  79      28.494  14.837  37.663  1.00 39.76           C  
ATOM    540  CD1 LEU A  79      28.768  13.322  37.428  1.00 37.15           C  
ATOM    541  CD2 LEU A  79      28.529  15.644  36.351  1.00 39.47           C  
ATOM    542  N   VAL A  80      25.816  15.787  40.978  1.00 29.98           N  
ATOM    543  CA  VAL A  80      25.766  16.538  42.206  1.00 29.94           C  
ATOM    544  C   VAL A  80      25.561  15.614  43.409  1.00 33.38           C  
ATOM    545  O   VAL A  80      26.181  15.811  44.461  1.00 33.20           O  
ATOM    546  CB  VAL A  80      24.638  17.584  42.144  1.00 30.35           C  
ATOM    547  CG1 VAL A  80      24.234  18.050  43.556  1.00 27.90           C  
ATOM    548  CG2 VAL A  80      25.111  18.781  41.302  1.00 29.27           C  
ATOM    549  N   MET A  81      24.702  14.605  43.270  1.00 31.67           N  
ATOM    550  CA  MET A  81      24.422  13.690  44.385  1.00 29.94           C  
ATOM    551  C   MET A  81      25.382  12.507  44.465  1.00 30.86           C  
ATOM    552  O   MET A  81      25.319  11.720  45.422  1.00 32.51           O  
ATOM    553  CB  MET A  81      22.992  13.139  44.276  1.00 31.37           C  
ATOM    554  CG  MET A  81      21.895  14.199  44.336  1.00 34.24           C  
ATOM    555  SD  MET A  81      21.941  15.253  45.864  1.00 35.40           S  
ATOM    556  CE  MET A  81      21.084  14.194  47.036  1.00 33.86           C  
ATOM    557  N   GLN A  82      26.239  12.380  43.456  1.00 28.74           N  
ATOM    558  CA  GLN A  82      27.195  11.272  43.340  1.00 29.68           C  
ATOM    559  C   GLN A  82      26.426   9.971  43.501  1.00 30.45           C  
ATOM    560  O   GLN A  82      26.828   9.066  44.231  1.00 30.27           O  
ATOM    561  CB  GLN A  82      28.298  11.386  44.392  1.00 31.78           C  
ATOM    562  CG  GLN A  82      29.269  12.511  44.107  1.00 36.23           C  
ATOM    563  CD  GLN A  82      30.094  12.270  42.829  1.00 44.63           C  
ATOM    564  OE1 GLN A  82      29.698  12.660  41.721  1.00 48.10           O  
ATOM    565  NE2 GLN A  82      31.231  11.606  42.979  1.00 45.04           N  
ATOM    566  N   ASN A  83      25.301   9.874  42.798  1.00 30.10           N  
ATOM    567  CA  ASN A  83      24.457   8.681  42.886  1.00 28.42           C  
ATOM    568  C   ASN A  83      23.526   8.690  41.669  1.00 28.07           C  
ATOM    569  O   ASN A  83      22.888   9.710  41.405  1.00 27.29           O  
ATOM    570  CB  ASN A  83      23.608   8.771  44.149  1.00 29.82           C  
ATOM    571  CG  ASN A  83      23.056   7.423  44.588  1.00 35.58           C  
ATOM    572  OD1 ASN A  83      22.860   6.511  43.781  1.00 31.19           O  
ATOM    573  ND2 ASN A  83      22.791   7.298  45.892  1.00 35.21           N  
ATOM    574  N   TYR A  84      23.420   7.576  40.949  1.00 26.47           N  
ATOM    575  CA  TYR A  84      22.529   7.567  39.805  1.00 29.76           C  
ATOM    576  C   TYR A  84      21.077   7.517  40.303  1.00 30.17           C  
ATOM    577  O   TYR A  84      20.137   7.822  39.556  1.00 30.85           O  
ATOM    578  CB  TYR A  84      22.868   6.401  38.850  1.00 29.46           C  
ATOM    579  CG  TYR A  84      22.418   5.050  39.328  1.00 35.88           C  
ATOM    580  CD1 TYR A  84      21.298   4.431  38.763  1.00 39.52           C  
ATOM    581  CD2 TYR A  84      23.046   4.427  40.400  1.00 38.14           C  
ATOM    582  CE1 TYR A  84      20.809   3.218  39.265  1.00 42.24           C  
ATOM    583  CE2 TYR A  84      22.564   3.223  40.911  1.00 40.38           C  
ATOM    584  CZ  TYR A  84      21.447   2.627  40.338  1.00 41.00           C  
ATOM    585  OH  TYR A  84      20.967   1.442  40.848  1.00 45.37           O  
ATOM    586  N   ARG A  85      20.885   7.156  41.569  1.00 28.46           N  
ATOM    587  CA  ARG A  85      19.531   7.127  42.127  1.00 31.61           C  
ATOM    588  C   ARG A  85      19.272   8.469  42.786  1.00 31.12           C  
ATOM    589  O   ARG A  85      20.034   8.882  43.664  1.00 33.37           O  
ATOM    590  CB  ARG A  85      19.402   6.020  43.166  1.00 34.59           C  
ATOM    591  CG  ARG A  85      19.205   4.647  42.566  1.00 42.26           C  
ATOM    592  CD  ARG A  85      19.437   3.597  43.634  1.00 50.52           C  
ATOM    593  NE  ARG A  85      18.715   2.359  43.359  1.00 60.94           N  
ATOM    594  CZ  ARG A  85      17.602   1.982  43.988  1.00 63.18           C  
ATOM    595  NH1 ARG A  85      17.075   2.748  44.941  1.00 62.28           N  
ATOM    596  NH2 ARG A  85      17.017   0.836  43.651  1.00 65.14           N  
ATOM    597  N   LEU A  86      18.203   9.148  42.386  1.00 28.40           N  
ATOM    598  CA  LEU A  86      17.906  10.467  42.939  1.00 26.32           C  
ATOM    599  C   LEU A  86      16.637  10.441  43.827  1.00 27.08           C  
ATOM    600  O   LEU A  86      15.674  11.179  43.616  1.00 23.31           O  
ATOM    601  CB  LEU A  86      17.754  11.442  41.779  1.00 24.68           C  
ATOM    602  CG  LEU A  86      19.033  11.525  40.924  1.00 25.60           C  
ATOM    603  CD1 LEU A  86      18.712  12.180  39.578  1.00 28.67           C  
ATOM    604  CD2 LEU A  86      20.117  12.295  41.694  1.00 25.93           C  
ATOM    605  N   ILE A  87      16.679   9.567  44.828  1.00 26.83           N  
ATOM    606  CA  ILE A  87      15.608   9.372  45.776  1.00 28.21           C  
ATOM    607  C   ILE A  87      14.991  10.650  46.326  1.00 27.25           C  
ATOM    608  O   ILE A  87      15.719  11.540  46.753  1.00 27.26           O  
ATOM    609  CB  ILE A  87      16.121   8.521  46.989  1.00 32.87           C  
ATOM    610  CG1 ILE A  87      16.656   7.187  46.483  1.00 36.11           C  
ATOM    611  CG2 ILE A  87      14.978   8.239  47.961  1.00 36.29           C  
ATOM    612  CD1 ILE A  87      15.664   6.458  45.654  1.00 34.89           C  
ATOM    613  N   ASP A  88      13.646  10.700  46.331  1.00 27.80           N  
ATOM    614  CA  ASP A  88      12.843  11.811  46.861  1.00 29.84           C  
ATOM    615  C   ASP A  88      12.950  13.136  46.135  1.00 30.91           C  
ATOM    616  O   ASP A  88      12.403  14.132  46.613  1.00 32.28           O  
ATOM    617  CB  ASP A  88      13.194  12.128  48.312  1.00 35.16           C  
ATOM    618  CG  ASP A  88      13.010  10.951  49.233  1.00 42.71           C  
ATOM    619  OD1 ASP A  88      11.974  10.247  49.122  1.00 42.99           O  
ATOM    620  OD2 ASP A  88      13.919  10.743  50.073  1.00 44.74           O  
ATOM    621  N   ALA A  89      13.674  13.195  45.023  1.00 27.12           N  
ATOM    622  CA  ALA A  89      13.809  14.497  44.359  1.00 24.84           C  
ATOM    623  C   ALA A  89      12.549  14.789  43.566  1.00 22.24           C  
ATOM    624  O   ALA A  89      11.830  13.879  43.196  1.00 21.73           O  
ATOM    625  CB  ALA A  89      15.025  14.503  43.411  1.00 24.51           C  
ATOM    626  N   THR A  90      12.307  16.068  43.304  1.00 20.53           N  
ATOM    627  CA  THR A  90      11.176  16.439  42.512  1.00 20.41           C  
ATOM    628  C   THR A  90      11.731  17.114  41.259  1.00 20.60           C  
ATOM    629  O   THR A  90      12.553  18.034  41.350  1.00 20.63           O  
ATOM    630  CB  THR A  90      10.260  17.421  43.280  1.00 22.63           C  
ATOM    631  OG1 THR A  90       9.723  16.772  44.446  1.00 25.65           O  
ATOM    632  CG2 THR A  90       9.090  17.868  42.380  1.00 18.14           C  
ATOM    633  N   LEU A  91      11.279  16.652  40.097  1.00 19.71           N  
ATOM    634  CA  LEU A  91      11.708  17.233  38.817  1.00 20.34           C  
ATOM    635  C   LEU A  91      10.591  18.138  38.246  1.00 17.77           C  
ATOM    636  O   LEU A  91       9.486  17.676  38.006  1.00 21.14           O  
ATOM    637  CB  LEU A  91      11.999  16.114  37.822  1.00 21.58           C  
ATOM    638  CG  LEU A  91      12.358  16.646  36.425  1.00 23.78           C  
ATOM    639  CD1 LEU A  91      13.717  17.353  36.502  1.00 20.59           C  
ATOM    640  CD2 LEU A  91      12.474  15.490  35.490  1.00 25.01           C  
ATOM    641  N   TYR A  92      10.870  19.420  38.064  1.00 17.62           N  
ATOM    642  CA  TYR A  92       9.876  20.353  37.508  1.00 20.94           C  
ATOM    643  C   TYR A  92      10.274  20.558  36.035  1.00 22.72           C  
ATOM    644  O   TYR A  92      11.437  20.825  35.771  1.00 19.31           O  
ATOM    645  CB  TYR A  92       9.974  21.732  38.178  1.00 21.10           C  
ATOM    646  CG  TYR A  92       9.476  21.756  39.597  1.00 22.30           C  
ATOM    647  CD1 TYR A  92       8.154  22.081  39.875  1.00 24.44           C  
ATOM    648  CD2 TYR A  92      10.291  21.351  40.658  1.00 24.00           C  
ATOM    649  CE1 TYR A  92       7.649  22.002  41.171  1.00 22.68           C  
ATOM    650  CE2 TYR A  92       9.782  21.263  41.983  1.00 22.29           C  
ATOM    651  CZ  TYR A  92       8.455  21.593  42.212  1.00 25.43           C  
ATOM    652  OH  TYR A  92       7.912  21.494  43.485  1.00 23.84           O  
ATOM    653  N   VAL A  93       9.322  20.438  35.116  1.00 21.76           N  
ATOM    654  CA  VAL A  93       9.589  20.677  33.694  1.00 22.80           C  
ATOM    655  C   VAL A  93       8.365  21.398  33.096  1.00 21.70           C  
ATOM    656  O   VAL A  93       7.225  21.080  33.408  1.00 20.56           O  
ATOM    657  CB  VAL A  93       9.947  19.327  32.942  1.00 23.43           C  
ATOM    658  CG1 VAL A  93       8.851  18.272  33.162  1.00 23.24           C  
ATOM    659  CG2 VAL A  93      10.257  19.600  31.448  1.00 20.44           C  
ATOM    660  N   THR A  94       8.627  22.388  32.253  1.00 20.42           N  
ATOM    661  CA  THR A  94       7.588  23.228  31.661  1.00 22.23           C  
ATOM    662  C   THR A  94       6.640  22.567  30.689  1.00 24.16           C  
ATOM    663  O   THR A  94       5.623  23.145  30.360  1.00 27.31           O  
ATOM    664  CB  THR A  94       8.211  24.504  31.010  1.00 24.87           C  
ATOM    665  OG1 THR A  94       9.182  24.151  29.993  1.00 25.23           O  
ATOM    666  CG2 THR A  94       8.929  25.312  32.098  1.00 21.87           C  
ATOM    667  N   LEU A  95       6.955  21.352  30.252  1.00 23.07           N  
ATOM    668  CA  LEU A  95       6.095  20.621  29.311  1.00 22.26           C  
ATOM    669  C   LEU A  95       6.039  19.157  29.728  1.00 21.05           C  
ATOM    670  O   LEU A  95       7.060  18.601  30.145  1.00 21.12           O  
ATOM    671  CB  LEU A  95       6.693  20.705  27.883  1.00 20.48           C  
ATOM    672  CG  LEU A  95       5.979  19.938  26.751  1.00 21.40           C  
ATOM    673  CD1 LEU A  95       4.540  20.537  26.528  1.00 22.23           C  
ATOM    674  CD2 LEU A  95       6.766  20.065  25.439  1.00 22.72           C  
ATOM    675  N   GLU A  96       4.874  18.523  29.616  1.00 18.61           N  
ATOM    676  CA  GLU A  96       4.719  17.111  29.954  1.00 17.39           C  
ATOM    677  C   GLU A  96       5.892  16.299  29.323  1.00 24.58           C  
ATOM    678  O   GLU A  96       6.179  16.453  28.128  1.00 23.35           O  
ATOM    679  CB  GLU A  96       3.386  16.617  29.382  1.00 18.37           C  
ATOM    680  CG  GLU A  96       3.088  15.173  29.681  1.00 18.11           C  
ATOM    681  CD  GLU A  96       1.763  14.717  29.074  1.00 25.02           C  
ATOM    682  OE1 GLU A  96       1.025  15.559  28.522  1.00 26.12           O  
ATOM    683  OE2 GLU A  96       1.462  13.512  29.143  1.00 22.81           O  
ATOM    684  N   PRO A  97       6.557  15.397  30.101  1.00 23.80           N  
ATOM    685  CA  PRO A  97       7.684  14.641  29.507  1.00 22.38           C  
ATOM    686  C   PRO A  97       7.333  13.642  28.439  1.00 23.01           C  
ATOM    687  O   PRO A  97       6.260  13.063  28.462  1.00 20.21           O  
ATOM    688  CB  PRO A  97       8.328  13.934  30.715  1.00 21.04           C  
ATOM    689  CG  PRO A  97       7.106  13.773  31.709  1.00 19.32           C  
ATOM    690  CD  PRO A  97       6.466  15.162  31.564  1.00 20.86           C  
ATOM    691  N   CYS A  98       8.272  13.410  27.521  1.00 19.83           N  
ATOM    692  CA  CYS A  98       8.068  12.430  26.466  1.00 19.30           C  
ATOM    693  C   CYS A  98       8.359  11.034  27.042  1.00 19.46           C  
ATOM    694  O   CYS A  98       8.725  10.889  28.190  1.00 18.54           O  
ATOM    695  CB  CYS A  98       9.027  12.710  25.266  1.00 20.18           C  
ATOM    696  SG  CYS A  98      10.792  12.448  25.701  1.00 19.55           S  
ATOM    697  N   VAL A  99       8.224  10.013  26.219  1.00 17.53           N  
ATOM    698  CA  VAL A  99       8.450   8.654  26.644  1.00 18.65           C  
ATOM    699  C   VAL A  99       9.882   8.458  27.127  1.00 18.91           C  
ATOM    700  O   VAL A  99      10.104   7.782  28.130  1.00 18.59           O  
ATOM    701  CB  VAL A  99       8.192   7.671  25.492  1.00 24.05           C  
ATOM    702  CG1 VAL A  99       8.620   6.259  25.932  1.00 28.55           C  
ATOM    703  CG2 VAL A  99       6.686   7.624  25.160  1.00 29.32           C  
ATOM    704  N   MET A 100      10.854   8.999  26.385  1.00 16.95           N  
ATOM    705  CA  MET A 100      12.253   8.887  26.808  1.00 19.47           C  
ATOM    706  C   MET A 100      12.476   9.461  28.198  1.00 19.47           C  
ATOM    707  O   MET A 100      13.078   8.823  29.074  1.00 20.77           O  
ATOM    708  CB  MET A 100      13.173   9.645  25.831  1.00 18.52           C  
ATOM    709  CG  MET A 100      14.658   9.622  26.272  1.00 17.94           C  
ATOM    710  SD  MET A 100      15.674  10.580  25.040  1.00 21.48           S  
ATOM    711  CE  MET A 100      15.078  12.275  25.271  1.00 17.18           C  
ATOM    712  N   CYS A 101      12.029  10.696  28.406  1.00 19.08           N  
ATOM    713  CA  CYS A 101      12.227  11.336  29.712  1.00 18.81           C  
ATOM    714  C   CYS A 101      11.468  10.628  30.831  1.00 19.78           C  
ATOM    715  O   CYS A 101      11.981  10.500  31.946  1.00 19.65           O  
ATOM    716  CB  CYS A 101      11.885  12.848  29.635  1.00 17.11           C  
ATOM    717  SG  CYS A 101      13.111  13.649  28.504  1.00 22.34           S  
ATOM    718  N   ALA A 102      10.254  10.170  30.558  1.00 19.08           N  
ATOM    719  CA  ALA A 102       9.502   9.447  31.603  1.00 21.74           C  
ATOM    720  C   ALA A 102      10.305   8.187  32.010  1.00 22.39           C  
ATOM    721  O   ALA A 102      10.391   7.832  33.195  1.00 22.48           O  
ATOM    722  CB  ALA A 102       8.080   9.026  31.053  1.00 19.57           C  
ATOM    723  N   GLY A 103      10.888   7.508  31.017  1.00 22.56           N  
ATOM    724  CA  GLY A 103      11.679   6.316  31.312  1.00 17.78           C  
ATOM    725  C   GLY A 103      12.878   6.671  32.158  1.00 19.71           C  
ATOM    726  O   GLY A 103      13.254   5.957  33.098  1.00 21.99           O  
ATOM    727  N   ALA A 104      13.500   7.793  31.840  1.00 17.92           N  
ATOM    728  CA  ALA A 104      14.664   8.201  32.605  1.00 17.57           C  
ATOM    729  C   ALA A 104      14.265   8.499  34.062  1.00 17.94           C  
ATOM    730  O   ALA A 104      15.031   8.263  35.001  1.00 21.42           O  
ATOM    731  CB  ALA A 104      15.311   9.471  31.939  1.00 17.68           C  
ATOM    732  N   MET A 105      13.084   9.066  34.246  1.00 19.89           N  
ATOM    733  CA  MET A 105      12.605   9.377  35.584  1.00 20.22           C  
ATOM    734  C   MET A 105      12.423   8.117  36.399  1.00 19.95           C  
ATOM    735  O   MET A 105      12.733   8.088  37.588  1.00 22.58           O  
ATOM    736  CB  MET A 105      11.293  10.154  35.505  1.00 23.17           C  
ATOM    737  CG  MET A 105      11.493  11.546  34.993  1.00 22.31           C  
ATOM    738  SD  MET A 105       9.892  12.358  34.799  1.00 25.94           S  
ATOM    739  CE  MET A 105      10.323  13.553  33.405  1.00 21.67           C  
ATOM    740  N   ILE A 106      11.927   7.075  35.765  1.00 20.08           N  
ATOM    741  CA  ILE A 106      11.766   5.812  36.461  1.00 23.78           C  
ATOM    742  C   ILE A 106      13.119   5.257  36.894  1.00 25.00           C  
ATOM    743  O   ILE A 106      13.282   4.863  38.055  1.00 25.18           O  
ATOM    744  CB  ILE A 106      11.051   4.799  35.590  1.00 23.43           C  
ATOM    745  CG1 ILE A 106       9.610   5.277  35.390  1.00 25.37           C  
ATOM    746  CG2 ILE A 106      11.076   3.415  36.278  1.00 24.19           C  
ATOM    747  CD1 ILE A 106       8.848   4.493  34.347  1.00 25.29           C  
ATOM    748  N   HIS A 107      14.105   5.253  35.994  1.00 23.95           N  
ATOM    749  CA  HIS A 107      15.436   4.739  36.358  1.00 24.49           C  
ATOM    750  C   HIS A 107      16.115   5.571  37.431  1.00 24.55           C  
ATOM    751  O   HIS A 107      16.937   5.068  38.206  1.00 25.62           O  
ATOM    752  CB  HIS A 107      16.371   4.725  35.153  1.00 27.23           C  
ATOM    753  CG  HIS A 107      15.979   3.753  34.099  1.00 28.64           C  
ATOM    754  ND1 HIS A 107      15.664   2.445  34.377  1.00 31.95           N  
ATOM    755  CD2 HIS A 107      15.866   3.896  32.758  1.00 28.89           C  
ATOM    756  CE1 HIS A 107      15.370   1.823  33.247  1.00 32.72           C  
ATOM    757  NE2 HIS A 107      15.486   2.686  32.253  1.00 29.64           N  
ATOM    758  N   SER A 108      15.806   6.858  37.457  1.00 22.49           N  
ATOM    759  CA  SER A 108      16.398   7.757  38.457  1.00 22.16           C  
ATOM    760  C   SER A 108      15.720   7.596  39.824  1.00 21.96           C  
ATOM    761  O   SER A 108      16.219   8.085  40.828  1.00 22.59           O  
ATOM    762  CB  SER A 108      16.214   9.214  38.073  1.00 22.09           C  
ATOM    763  OG  SER A 108      16.783   9.469  36.819  1.00 32.70           O  
ATOM    764  N   ARG A 109      14.559   6.978  39.843  1.00 21.32           N  
ATOM    765  CA  ARG A 109      13.860   6.800  41.092  1.00 25.55           C  
ATOM    766  C   ARG A 109      13.463   8.086  41.736  1.00 26.90           C  
ATOM    767  O   ARG A 109      13.392   8.146  42.957  1.00 29.19           O  
ATOM    768  CB  ARG A 109      14.721   6.033  42.095  1.00 29.46           C  
ATOM    769  CG  ARG A 109      15.160   4.668  41.638  1.00 34.23           C  
ATOM    770  CD  ARG A 109      14.020   3.743  41.524  1.00 41.53           C  
ATOM    771  NE  ARG A 109      14.411   2.422  42.003  1.00 52.91           N  
ATOM    772  CZ  ARG A 109      14.151   1.950  43.228  1.00 57.30           C  
ATOM    773  NH1 ARG A 109      13.483   2.696  44.115  1.00 60.37           N  
ATOM    774  NH2 ARG A 109      14.562   0.729  43.573  1.00 55.53           N  
ATOM    775  N   ILE A 110      13.194   9.135  40.976  1.00 27.68           N  
ATOM    776  CA  ILE A 110      12.815  10.354  41.670  1.00 25.95           C  
ATOM    777  C   ILE A 110      11.418  10.196  42.307  1.00 24.14           C  
ATOM    778  O   ILE A 110      10.646   9.313  41.942  1.00 23.16           O  
ATOM    779  CB  ILE A 110      12.847  11.610  40.756  1.00 27.18           C  
ATOM    780  CG1 ILE A 110      11.759  11.524  39.680  1.00 27.32           C  
ATOM    781  CG2 ILE A 110      14.245  11.765  40.110  1.00 20.60           C  
ATOM    782  CD1 ILE A 110      12.085  10.502  38.691  1.00 42.54           C  
ATOM    783  N   GLY A 111      11.098  11.059  43.258  1.00 26.37           N  
ATOM    784  CA  GLY A 111       9.798  10.937  43.923  1.00 25.52           C  
ATOM    785  C   GLY A 111       8.600  11.462  43.133  1.00 24.53           C  
ATOM    786  O   GLY A 111       7.523  10.880  43.149  1.00 26.08           O  
ATOM    787  N   ARG A 112       8.807  12.543  42.395  1.00 22.74           N  
ATOM    788  CA  ARG A 112       7.716  13.166  41.674  1.00 22.00           C  
ATOM    789  C   ARG A 112       8.173  14.004  40.476  1.00 21.11           C  
ATOM    790  O   ARG A 112       9.277  14.540  40.465  1.00 22.60           O  
ATOM    791  CB  ARG A 112       7.009  14.122  42.646  1.00 19.34           C  
ATOM    792  CG  ARG A 112       5.911  14.988  42.088  1.00 19.79           C  
ATOM    793  CD  ARG A 112       5.345  15.922  43.237  1.00 22.58           C  
ATOM    794  NE  ARG A 112       4.763  15.090  44.303  1.00 24.03           N  
ATOM    795  CZ  ARG A 112       3.525  14.597  44.268  1.00 26.52           C  
ATOM    796  NH1 ARG A 112       2.718  14.866  43.242  1.00 25.59           N  
ATOM    797  NH2 ARG A 112       3.105  13.785  45.233  1.00 27.50           N  
ATOM    798  N   VAL A 113       7.303  14.102  39.484  1.00 19.86           N  
ATOM    799  CA  VAL A 113       7.547  15.019  38.395  1.00 20.16           C  
ATOM    800  C   VAL A 113       6.339  15.974  38.427  1.00 21.38           C  
ATOM    801  O   VAL A 113       5.183  15.546  38.564  1.00 22.67           O  
ATOM    802  CB  VAL A 113       7.623  14.337  36.988  1.00 20.82           C  
ATOM    803  CG1 VAL A 113       6.402  13.496  36.745  1.00 22.62           C  
ATOM    804  CG2 VAL A 113       7.748  15.433  35.877  1.00 16.65           C  
ATOM    805  N   VAL A 114       6.638  17.256  38.332  1.00 19.35           N  
ATOM    806  CA  VAL A 114       5.648  18.301  38.269  1.00 19.14           C  
ATOM    807  C   VAL A 114       5.812  18.946  36.873  1.00 21.29           C  
ATOM    808  O   VAL A 114       6.852  19.489  36.570  1.00 20.65           O  
ATOM    809  CB  VAL A 114       5.934  19.379  39.321  1.00 18.89           C  
ATOM    810  CG1 VAL A 114       4.878  20.505  39.210  1.00 18.31           C  
ATOM    811  CG2 VAL A 114       5.952  18.738  40.747  1.00 22.94           C  
ATOM    812  N   PHE A 115       4.798  18.893  36.029  1.00 19.89           N  
ATOM    813  CA  PHE A 115       4.963  19.505  34.725  1.00 24.61           C  
ATOM    814  C   PHE A 115       3.947  20.602  34.457  1.00 26.40           C  
ATOM    815  O   PHE A 115       2.924  20.719  35.165  1.00 26.99           O  
ATOM    816  CB  PHE A 115       4.972  18.435  33.613  1.00 19.86           C  
ATOM    817  CG  PHE A 115       3.663  17.732  33.397  1.00 21.55           C  
ATOM    818  CD1 PHE A 115       2.664  18.319  32.608  1.00 21.78           C  
ATOM    819  CD2 PHE A 115       3.443  16.464  33.946  1.00 19.99           C  
ATOM    820  CE1 PHE A 115       1.438  17.648  32.367  1.00 22.23           C  
ATOM    821  CE2 PHE A 115       2.229  15.773  33.711  1.00 22.23           C  
ATOM    822  CZ  PHE A 115       1.222  16.360  32.924  1.00 20.56           C  
ATOM    823  N   GLY A 116       4.255  21.430  33.460  1.00 25.92           N  
ATOM    824  CA  GLY A 116       3.385  22.552  33.128  1.00 24.01           C  
ATOM    825  C   GLY A 116       2.350  22.210  32.090  1.00 25.50           C  
ATOM    826  O   GLY A 116       1.337  21.574  32.403  1.00 23.38           O  
ATOM    827  N   ALA A 117       2.613  22.616  30.846  1.00 24.33           N  
ATOM    828  CA  ALA A 117       1.676  22.352  29.769  1.00 26.91           C  
ATOM    829  C   ALA A 117       1.640  20.883  29.404  1.00 25.50           C  
ATOM    830  O   ALA A 117       2.619  20.183  29.554  1.00 25.99           O  
ATOM    831  CB  ALA A 117       2.054  23.221  28.536  1.00 28.00           C  
ATOM    832  N   ARG A 118       0.496  20.404  28.950  1.00 26.96           N  
ATOM    833  CA  ARG A 118       0.356  19.030  28.526  1.00 28.16           C  
ATOM    834  C   ARG A 118       0.905  18.967  27.106  1.00 27.69           C  
ATOM    835  O   ARG A 118       0.890  19.970  26.393  1.00 25.18           O  
ATOM    836  CB  ARG A 118      -1.108  18.621  28.460  1.00 34.58           C  
ATOM    837  CG  ARG A 118      -1.784  18.410  29.794  1.00 45.69           C  
ATOM    838  CD  ARG A 118      -1.519  17.012  30.377  1.00 53.81           C  
ATOM    839  NE  ARG A 118      -2.653  16.099  30.214  1.00 59.66           N  
ATOM    840  CZ  ARG A 118      -2.741  14.901  30.790  1.00 61.38           C  
ATOM    841  NH1 ARG A 118      -1.765  14.469  31.573  1.00 61.28           N  
ATOM    842  NH2 ARG A 118      -3.801  14.130  30.571  1.00 64.16           N  
ATOM    843  N   ASP A 119       1.405  17.808  26.700  1.00 25.98           N  
ATOM    844  CA  ASP A 119       1.903  17.648  25.332  1.00 29.71           C  
ATOM    845  C   ASP A 119       0.895  16.683  24.738  1.00 30.14           C  
ATOM    846  O   ASP A 119       1.006  15.467  24.897  1.00 28.55           O  
ATOM    847  CB  ASP A 119       3.289  17.032  25.288  1.00 31.11           C  
ATOM    848  CG  ASP A 119       3.772  16.793  23.834  1.00 42.97           C  
ATOM    849  OD1 ASP A 119       2.910  16.622  22.930  1.00 40.56           O  
ATOM    850  OD2 ASP A 119       5.007  16.760  23.611  1.00 45.19           O  
ATOM    851  N   ALA A 120      -0.102  17.239  24.069  1.00 27.52           N  
ATOM    852  CA  ALA A 120      -1.173  16.444  23.543  1.00 30.05           C  
ATOM    853  C   ALA A 120      -0.751  15.332  22.617  1.00 30.38           C  
ATOM    854  O   ALA A 120      -1.325  14.263  22.652  1.00 36.27           O  
ATOM    855  CB  ALA A 120      -2.197  17.349  22.843  1.00 30.63           C  
ATOM    856  N   LYS A 121       0.253  15.565  21.797  1.00 31.04           N  
ATOM    857  CA  LYS A 121       0.647  14.542  20.833  1.00 34.00           C  
ATOM    858  C   LYS A 121       1.657  13.514  21.308  1.00 38.18           C  
ATOM    859  O   LYS A 121       1.635  12.385  20.835  1.00 41.42           O  
ATOM    860  CB  LYS A 121       1.192  15.206  19.564  1.00 29.95           C  
ATOM    861  CG  LYS A 121       0.184  16.164  18.877  1.00 28.02           C  
ATOM    862  CD  LYS A 121       0.899  16.977  17.798  1.00 31.10           C  
ATOM    863  CE  LYS A 121      -0.096  17.794  16.988  1.00 35.29           C  
ATOM    864  NZ  LYS A 121       0.631  18.686  16.042  1.00 36.97           N  
ATOM    865  N   THR A 122       2.536  13.881  22.236  1.00 36.26           N  
ATOM    866  CA  THR A 122       3.530  12.924  22.649  1.00 37.25           C  
ATOM    867  C   THR A 122       3.841  12.795  24.114  1.00 33.98           C  
ATOM    868  O   THR A 122       4.804  12.108  24.452  1.00 33.92           O  
ATOM    869  CB  THR A 122       4.846  13.190  21.914  1.00 41.56           C  
ATOM    870  OG1 THR A 122       5.241  14.557  22.105  1.00 45.30           O  
ATOM    871  CG2 THR A 122       4.670  12.913  20.417  1.00 47.82           C  
ATOM    872  N   GLY A 123       3.041  13.426  24.978  1.00 29.81           N  
ATOM    873  CA  GLY A 123       3.287  13.369  26.412  1.00 26.44           C  
ATOM    874  C   GLY A 123       3.164  11.956  26.923  1.00 25.90           C  
ATOM    875  O   GLY A 123       2.227  11.256  26.535  1.00 22.53           O  
ATOM    876  N   ALA A 124       4.079  11.542  27.804  1.00 26.68           N  
ATOM    877  CA  ALA A 124       4.060  10.178  28.347  1.00 27.26           C  
ATOM    878  C   ALA A 124       3.567  10.101  29.789  1.00 30.11           C  
ATOM    879  O   ALA A 124       3.784   9.103  30.492  1.00 30.58           O  
ATOM    880  CB  ALA A 124       5.440   9.531  28.230  1.00 25.37           C  
ATOM    881  N   ALA A 125       2.902  11.158  30.235  1.00 31.47           N  
ATOM    882  CA  ALA A 125       2.362  11.191  31.573  1.00 33.21           C  
ATOM    883  C   ALA A 125       0.849  11.385  31.482  1.00 36.71           C  
ATOM    884  O   ALA A 125       0.290  12.190  32.216  1.00 41.20           O  
ATOM    885  CB  ALA A 125       3.004  12.336  32.373  1.00 33.53           C  
ATOM    886  N   GLY A 126       0.196  10.670  30.570  1.00 37.52           N  
ATOM    887  CA  GLY A 126      -1.241  10.801  30.431  1.00 41.68           C  
ATOM    888  C   GLY A 126      -1.743  11.166  29.037  1.00 44.14           C  
ATOM    889  O   GLY A 126      -2.787  10.669  28.616  1.00 45.04           O  
ATOM    890  N   SER A 127      -1.015  12.015  28.307  1.00 40.72           N  
ATOM    891  CA  SER A 127      -1.454  12.423  26.978  1.00 38.03           C  
ATOM    892  C   SER A 127      -1.430  11.340  25.891  1.00 42.00           C  
ATOM    893  O   SER A 127      -2.481  10.803  25.559  1.00 45.55           O  
ATOM    894  CB  SER A 127      -0.651  13.622  26.532  1.00 34.37           C  
ATOM    895  OG  SER A 127      -0.906  14.714  27.387  1.00 31.43           O  
ATOM    896  N   LEU A 128      -0.264  11.041  25.306  1.00 40.97           N  
ATOM    897  CA  LEU A 128      -0.160   9.996  24.277  1.00 40.13           C  
ATOM    898  C   LEU A 128      -0.196   8.601  24.903  1.00 41.71           C  
ATOM    899  O   LEU A 128      -0.738   7.659  24.321  1.00 39.98           O  
ATOM    900  CB  LEU A 128       1.132  10.148  23.472  1.00 43.46           C  
ATOM    901  CG  LEU A 128       1.616   9.002  22.557  1.00 44.95           C  
ATOM    902  CD1 LEU A 128       0.639   8.732  21.452  1.00 46.97           C  
ATOM    903  CD2 LEU A 128       2.963   9.375  21.965  1.00 47.60           C  
ATOM    904  N   MET A 129       0.417   8.476  26.075  1.00 40.69           N  
ATOM    905  CA  MET A 129       0.437   7.226  26.811  1.00 42.45           C  
ATOM    906  C   MET A 129       0.862   7.514  28.249  1.00 43.73           C  
ATOM    907  O   MET A 129       1.271   8.642  28.570  1.00 44.38           O  
ATOM    908  CB  MET A 129       1.393   6.224  26.163  1.00 42.97           C  
ATOM    909  CG  MET A 129       2.876   6.537  26.297  1.00 42.50           C  
ATOM    910  SD  MET A 129       3.852   5.226  25.440  1.00 48.18           S  
ATOM    911  CE  MET A 129       3.503   5.628  23.744  1.00 47.17           C  
ATOM    912  N   ASP A 130       0.722   6.528  29.130  1.00 42.79           N  
ATOM    913  CA  ASP A 130       1.138   6.730  30.510  1.00 44.53           C  
ATOM    914  C   ASP A 130       2.191   5.694  30.855  1.00 42.90           C  
ATOM    915  O   ASP A 130       1.918   4.512  31.043  1.00 42.07           O  
ATOM    916  CB  ASP A 130      -0.022   6.637  31.503  1.00 48.64           C  
ATOM    917  CG  ASP A 130       0.413   7.016  32.917  1.00 54.56           C  
ATOM    918  OD1 ASP A 130       1.457   6.492  33.348  1.00 56.79           O  
ATOM    919  OD2 ASP A 130      -0.263   7.831  33.594  1.00 58.54           O  
ATOM    920  N   VAL A 131       3.415   6.160  30.918  1.00 39.92           N  
ATOM    921  CA  VAL A 131       4.535   5.299  31.214  1.00 35.54           C  
ATOM    922  C   VAL A 131       4.750   5.250  32.716  1.00 31.86           C  
ATOM    923  O   VAL A 131       5.002   4.209  33.289  1.00 33.97           O  
ATOM    924  CB  VAL A 131       5.781   5.876  30.536  1.00 35.13           C  
ATOM    925  CG1 VAL A 131       7.038   5.258  31.103  1.00 34.64           C  
ATOM    926  CG2 VAL A 131       5.688   5.633  29.062  1.00 34.20           C  
ATOM    927  N   LEU A 132       4.630   6.404  33.345  1.00 31.30           N  
ATOM    928  CA  LEU A 132       4.876   6.522  34.755  1.00 30.27           C  
ATOM    929  C   LEU A 132       4.042   5.680  35.697  1.00 34.96           C  
ATOM    930  O   LEU A 132       4.548   5.283  36.752  1.00 36.59           O  
ATOM    931  CB  LEU A 132       4.785   7.991  35.170  1.00 28.37           C  
ATOM    932  CG  LEU A 132       5.847   8.873  34.503  1.00 26.68           C  
ATOM    933  CD1 LEU A 132       5.704  10.302  34.994  1.00 24.67           C  
ATOM    934  CD2 LEU A 132       7.239   8.320  34.829  1.00 24.80           C  
ATOM    935  N   HIS A 133       2.789   5.404  35.347  1.00 33.58           N  
ATOM    936  CA  HIS A 133       1.959   4.642  36.252  1.00 36.65           C  
ATOM    937  C   HIS A 133       1.597   3.300  35.656  1.00 40.51           C  
ATOM    938  O   HIS A 133       0.688   2.606  36.115  1.00 40.87           O  
ATOM    939  CB  HIS A 133       0.743   5.486  36.684  1.00 35.87           C  
ATOM    940  CG  HIS A 133       1.125   6.656  37.549  1.00 34.31           C  
ATOM    941  ND1 HIS A 133       0.240   7.633  37.951  1.00 34.63           N  
ATOM    942  CD2 HIS A 133       2.313   6.975  38.119  1.00 33.48           C  
ATOM    943  CE1 HIS A 133       0.862   8.497  38.735  1.00 32.17           C  
ATOM    944  NE2 HIS A 133       2.122   8.118  38.854  1.00 32.80           N  
ATOM    945  N   HIS A 134       2.366   2.921  34.643  1.00 39.76           N  
ATOM    946  CA  HIS A 134       2.184   1.628  34.034  1.00 41.22           C  
ATOM    947  C   HIS A 134       2.501   0.618  35.140  1.00 43.78           C  
ATOM    948  O   HIS A 134       3.516   0.708  35.816  1.00 42.60           O  
ATOM    949  CB  HIS A 134       3.131   1.454  32.871  1.00 39.89           C  
ATOM    950  CG  HIS A 134       2.888   0.202  32.112  1.00 38.89           C  
ATOM    951  ND1 HIS A 134       3.126  -1.043  32.655  1.00 41.40           N  
ATOM    952  CD2 HIS A 134       2.412  -0.008  30.863  1.00 38.53           C  
ATOM    953  CE1 HIS A 134       2.815  -1.968  31.764  1.00 39.61           C  
ATOM    954  NE2 HIS A 134       2.381  -1.368  30.671  1.00 37.88           N  
ATOM    955  N   PRO A 135       1.628  -0.381  35.319  1.00 48.32           N  
ATOM    956  CA  PRO A 135       1.763  -1.416  36.350  1.00 49.34           C  
ATOM    957  C   PRO A 135       3.055  -2.211  36.477  1.00 50.92           C  
ATOM    958  O   PRO A 135       3.403  -2.642  37.587  1.00 54.22           O  
ATOM    959  CB  PRO A 135       0.551  -2.312  36.085  1.00 51.15           C  
ATOM    960  CG  PRO A 135       0.415  -2.228  34.599  1.00 49.47           C  
ATOM    961  CD  PRO A 135       0.580  -0.749  34.351  1.00 44.57           C  
ATOM    962  N   GLY A 136       3.778  -2.408  35.386  1.00 48.70           N  
ATOM    963  CA  GLY A 136       5.002  -3.190  35.501  1.00 49.49           C  
ATOM    964  C   GLY A 136       6.316  -2.502  35.860  1.00 50.78           C  
ATOM    965  O   GLY A 136       7.363  -3.174  35.894  1.00 50.81           O  
ATOM    966  N   MET A 137       6.297  -1.196  36.138  1.00 49.30           N  
ATOM    967  CA  MET A 137       7.547  -0.485  36.467  1.00 50.26           C  
ATOM    968  C   MET A 137       7.993  -0.833  37.868  1.00 49.26           C  
ATOM    969  O   MET A 137       7.166  -1.144  38.711  1.00 51.38           O  
ATOM    970  CB  MET A 137       7.377   1.040  36.378  1.00 49.42           C  
ATOM    971  CG  MET A 137       6.884   1.573  35.045  1.00 48.65           C  
ATOM    972  SD  MET A 137       7.868   1.127  33.613  1.00 52.63           S  
ATOM    973  CE  MET A 137       6.941  -0.125  33.033  1.00 58.47           C  
ATOM    974  N   ASN A 138       9.293  -0.784  38.143  1.00 49.18           N  
ATOM    975  CA  ASN A 138       9.726  -1.111  39.506  1.00 49.36           C  
ATOM    976  C   ASN A 138       9.755   0.093  40.454  1.00 45.70           C  
ATOM    977  O   ASN A 138      10.206  -0.006  41.599  1.00 45.37           O  
ATOM    978  CB  ASN A 138      11.092  -1.808  39.492  1.00 55.14           C  
ATOM    979  CG  ASN A 138      11.976  -1.316  38.386  1.00 59.13           C  
ATOM    980  OD1 ASN A 138      12.262  -0.121  38.286  1.00 61.13           O  
ATOM    981  ND2 ASN A 138      12.416  -2.238  37.535  1.00 62.69           N  
ATOM    982  N   HIS A 139       9.259   1.231  39.982  1.00 39.91           N  
ATOM    983  CA  HIS A 139       9.216   2.420  40.808  1.00 34.42           C  
ATOM    984  C   HIS A 139       8.119   3.358  40.317  1.00 30.48           C  
ATOM    985  O   HIS A 139       7.991   3.590  39.134  1.00 31.95           O  
ATOM    986  CB  HIS A 139      10.569   3.131  40.778  1.00 31.66           C  
ATOM    987  CG  HIS A 139      10.578   4.422  41.541  1.00 32.66           C  
ATOM    988  ND1 HIS A 139      10.514   5.657  40.924  1.00 33.55           N  
ATOM    989  CD2 HIS A 139      10.628   4.670  42.870  1.00 28.51           C  
ATOM    990  CE1 HIS A 139      10.526   6.608  41.844  1.00 29.67           C  
ATOM    991  NE2 HIS A 139      10.593   6.033  43.033  1.00 31.94           N  
ATOM    992  N   ARG A 140       7.332   3.885  41.237  1.00 29.70           N  
ATOM    993  CA  ARG A 140       6.251   4.796  40.897  1.00 29.04           C  
ATOM    994  C   ARG A 140       6.696   6.222  41.113  1.00 26.36           C  
ATOM    995  O   ARG A 140       7.088   6.596  42.216  1.00 26.93           O  
ATOM    996  CB  ARG A 140       5.037   4.537  41.805  1.00 33.99           C  
ATOM    997  CG  ARG A 140       3.817   5.414  41.478  1.00 35.69           C  
ATOM    998  CD  ARG A 140       2.753   5.313  42.591  1.00 40.91           C  
ATOM    999  NE  ARG A 140       1.573   6.137  42.337  1.00 42.36           N  
ATOM   1000  CZ  ARG A 140       0.647   5.860  41.423  1.00 45.27           C  
ATOM   1001  NH1 ARG A 140       0.756   4.769  40.672  1.00 48.07           N  
ATOM   1002  NH2 ARG A 140      -0.382   6.683  41.245  1.00 45.54           N  
ATOM   1003  N   VAL A 141       6.647   7.032  40.065  1.00 25.32           N  
ATOM   1004  CA  VAL A 141       7.003   8.441  40.199  1.00 22.10           C  
ATOM   1005  C   VAL A 141       5.636   9.144  40.334  1.00 24.42           C  
ATOM   1006  O   VAL A 141       4.754   8.893  39.508  1.00 23.77           O  
ATOM   1007  CB  VAL A 141       7.681   8.974  38.894  1.00 21.86           C  
ATOM   1008  CG1 VAL A 141       7.869  10.477  38.956  1.00 18.20           C  
ATOM   1009  CG2 VAL A 141       9.015   8.283  38.690  1.00 23.75           C  
ATOM   1010  N   GLU A 142       5.451   9.992  41.344  1.00 22.36           N  
ATOM   1011  CA  GLU A 142       4.157  10.697  41.478  1.00 25.76           C  
ATOM   1012  C   GLU A 142       4.112  11.821  40.425  1.00 26.25           C  
ATOM   1013  O   GLU A 142       5.154  12.332  40.010  1.00 25.10           O  
ATOM   1014  CB  GLU A 142       4.003  11.313  42.874  1.00 26.92           C  
ATOM   1015  CG  GLU A 142       3.852  10.291  44.022  1.00 30.41           C  
ATOM   1016  CD  GLU A 142       2.775   9.258  43.741  1.00 36.22           C  
ATOM   1017  OE1 GLU A 142       1.667   9.614  43.264  1.00 40.50           O  
ATOM   1018  OE2 GLU A 142       3.026   8.071  44.006  1.00 42.53           O  
ATOM   1019  N   ILE A 143       2.911  12.196  40.007  1.00 23.67           N  
ATOM   1020  CA  ILE A 143       2.729  13.215  38.999  1.00 25.13           C  
ATOM   1021  C   ILE A 143       1.839  14.378  39.453  1.00 27.48           C  
ATOM   1022  O   ILE A 143       0.712  14.139  39.931  1.00 27.25           O  
ATOM   1023  CB  ILE A 143       2.023  12.630  37.722  1.00 23.72           C  
ATOM   1024  CG1 ILE A 143       2.838  11.467  37.123  1.00 24.67           C  
ATOM   1025  CG2 ILE A 143       1.833  13.724  36.665  1.00 26.28           C  
ATOM   1026  CD1 ILE A 143       2.004  10.679  36.031  1.00 24.08           C  
ATOM   1027  N   THR A 144       2.345  15.606  39.300  1.00 23.51           N  
ATOM   1028  CA  THR A 144       1.550  16.809  39.549  1.00 23.97           C  
ATOM   1029  C   THR A 144       1.462  17.472  38.159  1.00 25.37           C  
ATOM   1030  O   THR A 144       2.497  17.690  37.505  1.00 25.27           O  
ATOM   1031  CB  THR A 144       2.222  17.796  40.529  1.00 24.62           C  
ATOM   1032  OG1 THR A 144       2.296  17.199  41.829  1.00 24.35           O  
ATOM   1033  CG2 THR A 144       1.388  19.109  40.638  1.00 23.68           C  
ATOM   1034  N   GLU A 145       0.255  17.754  37.671  1.00 22.47           N  
ATOM   1035  CA  GLU A 145       0.160  18.365  36.352  1.00 29.67           C  
ATOM   1036  C   GLU A 145      -0.393  19.781  36.261  1.00 30.70           C  
ATOM   1037  O   GLU A 145      -1.115  20.227  37.143  1.00 29.84           O  
ATOM   1038  CB  GLU A 145      -0.656  17.487  35.415  1.00 34.29           C  
ATOM   1039  CG  GLU A 145      -2.111  17.409  35.705  1.00 47.20           C  
ATOM   1040  CD  GLU A 145      -2.849  16.588  34.647  1.00 54.77           C  
ATOM   1041  OE1 GLU A 145      -3.205  17.148  33.576  1.00 59.37           O  
ATOM   1042  OE2 GLU A 145      -3.052  15.368  34.877  1.00 59.26           O  
ATOM   1043  N   GLY A 146      -0.013  20.493  35.195  1.00 29.79           N  
ATOM   1044  CA  GLY A 146      -0.564  21.818  34.950  1.00 26.11           C  
ATOM   1045  C   GLY A 146      -0.102  23.041  35.713  1.00 26.11           C  
ATOM   1046  O   GLY A 146      -0.782  24.053  35.676  1.00 28.26           O  
ATOM   1047  N   ILE A 147       1.031  22.962  36.395  1.00 22.01           N  
ATOM   1048  CA  ILE A 147       1.553  24.100  37.134  1.00 24.12           C  
ATOM   1049  C   ILE A 147       2.056  25.161  36.147  1.00 25.92           C  
ATOM   1050  O   ILE A 147       2.956  24.886  35.351  1.00 25.19           O  
ATOM   1051  CB  ILE A 147       2.671  23.651  38.053  1.00 21.25           C  
ATOM   1052  CG1 ILE A 147       2.078  22.661  39.066  1.00 27.77           C  
ATOM   1053  CG2 ILE A 147       3.259  24.834  38.798  1.00 20.58           C  
ATOM   1054  CD1 ILE A 147       1.708  21.427  38.466  1.00 37.38           C  
ATOM   1055  N   LEU A 148       1.471  26.363  36.230  1.00 25.89           N  
ATOM   1056  CA  LEU A 148       1.750  27.509  35.344  1.00 24.15           C  
ATOM   1057  C   LEU A 148       1.574  27.039  33.886  1.00 26.15           C  
ATOM   1058  O   LEU A 148       2.294  27.474  33.003  1.00 28.34           O  
ATOM   1059  CB  LEU A 148       3.171  28.058  35.592  1.00 23.10           C  
ATOM   1060  CG  LEU A 148       3.565  28.583  36.991  1.00 26.04           C  
ATOM   1061  CD1 LEU A 148       4.928  29.285  36.947  1.00 27.80           C  
ATOM   1062  CD2 LEU A 148       2.512  29.611  37.480  1.00 25.30           C  
ATOM   1063  N   ALA A 149       0.613  26.136  33.654  1.00 27.12           N  
ATOM   1064  CA  ALA A 149       0.359  25.571  32.327  1.00 28.99           C  
ATOM   1065  C   ALA A 149       0.190  26.619  31.234  1.00 32.70           C  
ATOM   1066  O   ALA A 149       0.614  26.410  30.065  1.00 32.56           O  
ATOM   1067  CB  ALA A 149      -0.891  24.653  32.343  1.00 25.57           C  
ATOM   1068  N   ASP A 150      -0.446  27.726  31.609  1.00 33.53           N  
ATOM   1069  CA  ASP A 150      -0.709  28.818  30.684  1.00 34.95           C  
ATOM   1070  C   ASP A 150       0.538  29.563  30.235  1.00 31.37           C  
ATOM   1071  O   ASP A 150       0.681  29.827  29.052  1.00 32.05           O  
ATOM   1072  CB  ASP A 150      -1.733  29.799  31.291  1.00 40.93           C  
ATOM   1073  CG  ASP A 150      -3.167  29.327  31.092  1.00 50.05           C  
ATOM   1074  OD1 ASP A 150      -3.355  28.284  30.418  1.00 54.97           O  
ATOM   1075  OD2 ASP A 150      -4.108  29.991  31.596  1.00 58.15           O  
ATOM   1076  N   GLU A 151       1.434  29.904  31.162  1.00 27.64           N  
ATOM   1077  CA  GLU A 151       2.642  30.584  30.764  1.00 27.52           C  
ATOM   1078  C   GLU A 151       3.521  29.615  29.988  1.00 28.72           C  
ATOM   1079  O   GLU A 151       4.143  30.005  29.019  1.00 29.16           O  
ATOM   1080  CB  GLU A 151       3.381  31.137  31.972  1.00 30.02           C  
ATOM   1081  CG  GLU A 151       2.612  32.232  32.670  1.00 36.60           C  
ATOM   1082  CD  GLU A 151       3.325  32.774  33.880  1.00 42.53           C  
ATOM   1083  OE1 GLU A 151       4.416  33.394  33.762  1.00 43.40           O  
ATOM   1084  OE2 GLU A 151       2.782  32.581  34.977  1.00 45.88           O  
ATOM   1085  N   CYS A 152       3.543  28.349  30.407  1.00 27.18           N  
ATOM   1086  CA  CYS A 152       4.352  27.337  29.746  1.00 27.94           C  
ATOM   1087  C   CYS A 152       3.862  27.187  28.310  1.00 30.06           C  
ATOM   1088  O   CYS A 152       4.668  27.232  27.372  1.00 30.59           O  
ATOM   1089  CB  CYS A 152       4.265  25.987  30.502  1.00 25.88           C  
ATOM   1090  SG  CYS A 152       5.081  26.061  32.116  1.00 31.38           S  
ATOM   1091  N   ALA A 153       2.555  27.028  28.130  1.00 28.76           N  
ATOM   1092  CA  ALA A 153       2.018  26.876  26.802  1.00 31.24           C  
ATOM   1093  C   ALA A 153       2.162  28.180  25.987  1.00 36.12           C  
ATOM   1094  O   ALA A 153       2.331  28.131  24.773  1.00 35.74           O  
ATOM   1095  CB  ALA A 153       0.554  26.441  26.852  1.00 31.96           C  
ATOM   1096  N   ALA A 154       2.123  29.344  26.631  1.00 36.17           N  
ATOM   1097  CA  ALA A 154       2.274  30.568  25.853  1.00 37.24           C  
ATOM   1098  C   ALA A 154       3.720  30.708  25.324  1.00 38.81           C  
ATOM   1099  O   ALA A 154       3.933  31.192  24.220  1.00 38.04           O  
ATOM   1100  CB  ALA A 154       1.890  31.787  26.687  1.00 35.32           C  
ATOM   1101  N   LEU A 155       4.704  30.265  26.107  1.00 39.37           N  
ATOM   1102  CA  LEU A 155       6.101  30.355  25.707  1.00 40.20           C  
ATOM   1103  C   LEU A 155       6.270  29.525  24.454  1.00 41.69           C  
ATOM   1104  O   LEU A 155       6.922  29.950  23.494  1.00 43.67           O  
ATOM   1105  CB  LEU A 155       7.018  29.786  26.782  1.00 41.09           C  
ATOM   1106  CG  LEU A 155       8.371  30.445  26.987  1.00 42.94           C  
ATOM   1107  CD1 LEU A 155       9.284  29.476  27.662  1.00 40.40           C  
ATOM   1108  CD2 LEU A 155       8.960  30.878  25.692  1.00 43.58           C  
ATOM   1109  N   LEU A 156       5.694  28.331  24.473  1.00 39.31           N  
ATOM   1110  CA  LEU A 156       5.792  27.437  23.342  1.00 38.18           C  
ATOM   1111  C   LEU A 156       5.060  28.019  22.153  1.00 41.63           C  
ATOM   1112  O   LEU A 156       5.511  27.903  21.004  1.00 40.75           O  
ATOM   1113  CB  LEU A 156       5.203  26.064  23.691  1.00 35.28           C  
ATOM   1114  CG  LEU A 156       6.057  25.194  24.656  1.00 35.37           C  
ATOM   1115  CD1 LEU A 156       5.226  24.023  25.225  1.00 34.13           C  
ATOM   1116  CD2 LEU A 156       7.301  24.644  23.892  1.00 30.22           C  
ATOM   1117  N   SER A 157       3.931  28.655  22.432  1.00 41.85           N  
ATOM   1118  CA  SER A 157       3.101  29.243  21.386  1.00 45.18           C  
ATOM   1119  C   SER A 157       3.845  30.383  20.712  1.00 45.42           C  
ATOM   1120  O   SER A 157       3.841  30.489  19.503  1.00 45.69           O  
ATOM   1121  CB  SER A 157       1.794  29.735  22.008  1.00 45.03           C  
ATOM   1122  OG  SER A 157       0.859  30.036  21.003  1.00 53.09           O  
ATOM   1123  N   ASP A 158       4.491  31.221  21.519  1.00 46.58           N  
ATOM   1124  CA  ASP A 158       5.262  32.351  21.039  1.00 49.79           C  
ATOM   1125  C   ASP A 158       6.415  31.856  20.200  1.00 52.09           C  
ATOM   1126  O   ASP A 158       6.897  32.556  19.296  1.00 52.73           O  
ATOM   1127  CB  ASP A 158       5.842  33.172  22.201  1.00 52.04           C  
ATOM   1128  CG  ASP A 158       4.784  33.938  22.959  1.00 55.45           C  
ATOM   1129  OD1 ASP A 158       3.652  34.067  22.432  1.00 56.56           O  
ATOM   1130  OD2 ASP A 158       5.087  34.414  24.079  1.00 56.77           O  
ATOM   1131  N   PHE A 159       6.880  30.657  20.506  1.00 51.55           N  
ATOM   1132  CA  PHE A 159       7.981  30.096  19.745  1.00 50.72           C  
ATOM   1133  C   PHE A 159       7.528  29.546  18.401  1.00 51.82           C  
ATOM   1134  O   PHE A 159       8.148  29.812  17.394  1.00 51.31           O  
ATOM   1135  CB  PHE A 159       8.669  28.989  20.536  1.00 49.88           C  
ATOM   1136  CG  PHE A 159       9.720  28.259  19.761  1.00 46.32           C  
ATOM   1137  CD1 PHE A 159      11.023  28.725  19.727  1.00 46.29           C  
ATOM   1138  CD2 PHE A 159       9.403  27.100  19.072  1.00 46.09           C  
ATOM   1139  CE1 PHE A 159      12.001  28.046  19.020  1.00 44.31           C  
ATOM   1140  CE2 PHE A 159      10.378  26.408  18.357  1.00 48.32           C  
ATOM   1141  CZ  PHE A 159      11.674  26.886  18.336  1.00 43.25           C  
ATOM   1142  N   PHE A 160       6.459  28.775  18.369  1.00 54.93           N  
ATOM   1143  CA  PHE A 160       6.017  28.223  17.098  1.00 61.89           C  
ATOM   1144  C   PHE A 160       5.441  29.270  16.136  1.00 65.92           C  
ATOM   1145  O   PHE A 160       5.101  28.954  14.992  1.00 66.21           O  
ATOM   1146  CB  PHE A 160       5.009  27.107  17.339  1.00 64.12           C  
ATOM   1147  CG  PHE A 160       5.622  25.850  17.895  1.00 69.77           C  
ATOM   1148  CD1 PHE A 160       6.063  24.833  17.041  1.00 70.95           C  
ATOM   1149  CD2 PHE A 160       5.778  25.681  19.278  1.00 71.00           C  
ATOM   1150  CE1 PHE A 160       6.650  23.665  17.557  1.00 71.98           C  
ATOM   1151  CE2 PHE A 160       6.364  24.516  19.804  1.00 70.64           C  
ATOM   1152  CZ  PHE A 160       6.799  23.509  18.945  1.00 71.14           C  
ATOM   1153  N   ARG A 161       5.309  30.508  16.599  1.00 68.84           N  
ATOM   1154  CA  ARG A 161       4.834  31.558  15.719  1.00 72.93           C  
ATOM   1155  C   ARG A 161       6.083  32.297  15.266  1.00 75.72           C  
ATOM   1156  O   ARG A 161       6.389  32.314  14.083  1.00 77.09           O  
ATOM   1157  CB  ARG A 161       3.884  32.527  16.423  1.00 72.15           C  
ATOM   1158  CG  ARG A 161       3.367  33.596  15.462  1.00 73.18           C  
ATOM   1159  CD  ARG A 161       2.409  34.562  16.112  1.00 72.80           C  
ATOM   1160  NE  ARG A 161       3.014  35.180  17.276  1.00 73.07           N  
ATOM   1161  CZ  ARG A 161       2.622  34.956  18.523  1.00 73.37           C  
ATOM   1162  NH1 ARG A 161       1.610  34.130  18.764  1.00 72.11           N  
ATOM   1163  NH2 ARG A 161       3.262  35.541  19.530  1.00 73.17           N  
ATOM   1164  N   MET A 162       6.811  32.885  16.214  1.00 78.94           N  
ATOM   1165  CA  MET A 162       8.047  33.610  15.912  1.00 82.38           C  
ATOM   1166  C   MET A 162       8.948  32.757  15.033  1.00 84.28           C  
ATOM   1167  O   MET A 162       9.860  33.264  14.372  1.00 85.09           O  
ATOM   1168  CB  MET A 162       8.788  33.969  17.205  1.00 83.90           C  
ATOM   1169  CG  MET A 162      10.128  34.675  17.005  1.00 87.31           C  
ATOM   1170  SD  MET A 162      11.609  33.660  17.404  1.00 93.10           S  
ATOM   1171  CE  MET A 162      12.254  33.241  15.712  1.00 92.25           C  
ATOM   1172  N   ARG A 163       8.681  31.455  15.029  1.00 86.18           N  
ATOM   1173  CA  ARG A 163       9.457  30.518  14.234  1.00 88.24           C  
ATOM   1174  C   ARG A 163       8.934  30.524  12.797  1.00 88.48           C  
ATOM   1175  O   ARG A 163       9.710  30.666  11.853  1.00 88.55           O  
ATOM   1176  CB  ARG A 163       9.383  29.118  14.855  1.00 88.96           C  
ATOM   1177  CG  ARG A 163      10.183  28.079  14.117  1.00 89.54           C  
ATOM   1178  CD  ARG A 163       9.331  27.434  13.051  1.00 91.05           C  
ATOM   1179  NE  ARG A 163       8.797  26.159  13.509  1.00 92.26           N  
ATOM   1180  CZ  ARG A 163       9.559  25.132  13.870  1.00 93.15           C  
ATOM   1181  NH1 ARG A 163      10.884  25.241  13.828  1.00 92.81           N  
ATOM   1182  NH2 ARG A 163       9.001  23.992  14.259  1.00 93.24           N  
ATOM   1183  N   ARG A 164       7.625  30.374  12.622  1.00 88.96           N  
ATOM   1184  CA  ARG A 164       7.063  30.420  11.279  1.00 90.00           C  
ATOM   1185  C   ARG A 164       7.263  31.836  10.714  1.00 90.95           C  
ATOM   1186  O   ARG A 164       7.108  32.071   9.516  1.00 89.83           O  
ATOM   1187  CB  ARG A 164       5.580  30.041  11.306  1.00 89.55           C  
ATOM   1188  CG  ARG A 164       5.338  28.542  11.427  1.00 89.94           C  
ATOM   1189  CD  ARG A 164       3.852  28.203  11.399  1.00 91.07           C  
ATOM   1190  NE  ARG A 164       3.225  28.280  12.721  1.00 92.98           N  
ATOM   1191  CZ  ARG A 164       1.919  28.127  12.955  1.00 92.62           C  
ATOM   1192  NH1 ARG A 164       1.070  27.891  11.956  1.00 91.30           N  
ATOM   1193  NH2 ARG A 164       1.463  28.195  14.198  1.00 92.26           N  
ATOM   1194  N   GLN A 165       7.619  32.776  11.592  1.00 93.22           N  
ATOM   1195  CA  GLN A 165       7.885  34.164  11.198  1.00 94.91           C  
ATOM   1196  C   GLN A 165       9.320  34.161  10.675  1.00 95.74           C  
ATOM   1197  O   GLN A 165       9.998  35.191  10.632  1.00 95.15           O  
ATOM   1198  CB  GLN A 165       7.807  35.123  12.401  1.00 94.87           C  
ATOM   1199  CG  GLN A 165       6.534  35.045  13.239  1.00 95.40           C  
ATOM   1200  CD  GLN A 165       5.586  36.210  13.016  1.00 95.61           C  
ATOM   1201  OE1 GLN A 165       5.045  36.381  11.923  1.00 96.41           O  
ATOM   1202  NE2 GLN A 165       5.377  37.018  14.057  1.00 94.19           N  
ATOM   1203  N   GLU A 166       9.783  32.978  10.298  1.00 97.24           N  
ATOM   1204  CA  GLU A 166      11.128  32.825   9.783  1.00 98.65           C  
ATOM   1205  C   GLU A 166      11.101  32.103   8.455  1.00 98.77           C  
ATOM   1206  O   GLU A 166      11.938  32.361   7.589  1.00 98.75           O  
ATOM   1207  CB  GLU A 166      11.981  32.051  10.768  1.00100.29           C  
ATOM   1208  CG  GLU A 166      13.271  31.573  10.173  1.00103.19           C  
ATOM   1209  CD  GLU A 166      14.187  31.001  11.216  1.00105.31           C  
ATOM   1210  OE1 GLU A 166      13.747  30.071  11.936  1.00106.16           O  
ATOM   1211  OE2 GLU A 166      15.340  31.489  11.309  1.00106.07           O  
ATOM   1212  N   ILE A 167      10.145  31.190   8.301  1.00 99.18           N  
ATOM   1213  CA  ILE A 167      10.012  30.452   7.050  1.00 99.69           C  
ATOM   1214  C   ILE A 167       9.564  31.410   5.928  1.00100.50           C  
ATOM   1215  O   ILE A 167       8.370  31.521   5.601  1.00100.81           O  
ATOM   1216  CB  ILE A 167       9.012  29.257   7.188  1.00 99.06           C  
ATOM   1217  CG1 ILE A 167       8.823  28.581   5.825  1.00 98.38           C  
ATOM   1218  CG2 ILE A 167       7.682  29.727   7.763  1.00 98.45           C  
ATOM   1219  CD1 ILE A 167       7.948  27.348   5.873  1.00 98.28           C  
ATOM   1220  N   LYS A 168      10.550  32.114   5.366  1.00100.44           N  
ATOM   1221  CA  LYS A 168      10.345  33.073   4.283  1.00 99.72           C  
ATOM   1222  C   LYS A 168       9.905  32.314   3.027  1.00100.04           C  
ATOM   1223  O   LYS A 168      10.710  32.234   2.068  1.00100.01           O  
ATOM   1224  CB  LYS A 168      11.654  33.827   4.005  1.00 98.81           C  
ATOM   1225  CG  LYS A 168      11.522  35.095   3.153  1.00 97.69           C  
ATOM   1226  CD  LYS A 168      10.968  36.268   3.964  1.00 96.50           C  
ATOM   1227  CE  LYS A 168      11.220  37.606   3.270  1.00 94.88           C  
ATOM   1228  NZ  LYS A 168      10.623  37.679   1.911  1.00 94.23           N  
TER    1229      LYS A 168                                                      
END
MOLECULE T0461.pdb
ATOM      1  N   GLU    16      19.319  11.894  58.181  1.00 47.03           N  
ATOM      2  CA  GLU    16      18.212  11.089  57.593  1.00 47.23           C  
ATOM      4  CB  GLU    16      18.010   9.793  58.377  1.00 47.32           C  
ATOM      7  CG  GLU    16      17.576   8.619  57.509  1.00 48.39           C  
ATOM     10  CD  GLU    16      17.064   7.416  58.327  1.00 50.46           C  
ATOM     11  OE1 GLU    16      16.178   6.689  57.811  1.00 51.91           O  
ATOM     12  OE2 GLU    16      17.526   7.196  59.479  1.00 50.93           O  
ATOM     13  C   GLU    16      16.896  11.864  57.561  1.00 47.09           C  
ATOM     14  O   GLU    16      15.891  11.376  57.001  1.00 48.08           O  
ATOM     18  N   ASN    17      16.888  13.066  58.143  1.00 46.06           N  
ATOM     19  CA  ASN    17      15.679  13.870  58.188  1.00 45.28           C  
ATOM     21  CB  ASN    17      15.631  14.676  59.487  1.00 45.17           C  
ATOM     24  CG  ASN    17      14.246  15.250  59.773  1.00 44.92           C  
ATOM     25  OD1 ASN    17      13.421  15.378  58.885  1.00 45.51           O  
ATOM     26  ND2 ASN    17      13.989  15.591  61.023  1.00 45.12           N  
ATOM     29  C   ASN    17      15.619  14.792  56.990  1.00 44.97           C  
ATOM     30  O   ASN    17      16.071  15.922  57.046  1.00 44.78           O  
ATOM     32  N   LEU    18      15.026  14.320  55.910  1.00 45.02           N  
ATOM     33  CA  LEU    18      14.988  15.101  54.659  1.00 45.41           C  
ATOM     35  CB  LEU    18      14.792  14.167  53.453  1.00 45.35           C  
ATOM     38  CG  LEU    18      15.875  13.083  53.322  1.00 45.26           C  
ATOM     40  CD1 LEU    18      15.492  12.097  52.210  1.00 45.69           C  
ATOM     44  CD2 LEU    18      17.267  13.703  53.084  1.00 42.76           C  
ATOM     48  C   LEU    18      13.920  16.202  54.656  1.00 45.40           C  
ATOM     49  O   LEU    18      12.854  16.047  55.244  1.00 46.03           O  
ATOM     51  N   TYR    19      14.208  17.291  53.954  1.00 45.10           N  
ATOM     52  CA  TYR    19      13.361  18.473  53.903  1.00 44.79           C  
ATOM     54  CB  TYR    19      14.284  19.669  53.829  1.00 45.04           C  
ATOM     57  CG  TYR    19      13.663  21.040  53.814  1.00 45.91           C  
ATOM     58  CD1 TYR    19      13.769  21.878  54.930  1.00 46.50           C  
ATOM     60  CE1 TYR    19      13.223  23.142  54.930  1.00 46.23           C  
ATOM     62  CZ  TYR    19      12.595  23.603  53.806  1.00 45.82           C  
ATOM     63  OH  TYR    19      12.078  24.858  53.838  1.00 47.34           O  
ATOM     65  CE2 TYR    19      12.478  22.813  52.668  1.00 46.79           C  
ATOM     67  CD2 TYR    19      13.017  21.538  52.672  1.00 46.25           C  
ATOM     69  C   TYR    19      12.486  18.434  52.655  1.00 45.02           C  
ATOM     70  O   TYR    19      12.973  18.134  51.545  1.00 44.56           O  
ATOM     72  N   PHE    20      11.200  18.768  52.836  1.00 45.35           N  
ATOM     73  CA  PHE    20      10.180  18.735  51.761  1.00 44.99           C  
ATOM     75  CB  PHE    20       8.875  18.070  52.229  1.00 44.60           C  
ATOM     78  CG  PHE    20       8.967  16.583  52.430  1.00 44.31           C  
ATOM     79  CD1 PHE    20       8.814  16.023  53.683  1.00 45.43           C  
ATOM     81  CE1 PHE    20       8.871  14.634  53.877  1.00 44.99           C  
ATOM     83  CZ  PHE    20       9.077  13.820  52.843  1.00 43.54           C  
ATOM     85  CE2 PHE    20       9.199  14.351  51.588  1.00 44.96           C  
ATOM     87  CD2 PHE    20       9.152  15.735  51.379  1.00 44.56           C  
ATOM     89  C   PHE    20       9.859  20.151  51.339  1.00 44.84           C  
ATOM     90  O   PHE    20       9.575  20.984  52.162  1.00 45.26           O  
ATOM     92  N   GLN    21       9.875  20.414  50.048  1.00 45.39           N  
ATOM     93  CA  GLN    21       9.553  21.743  49.542  1.00 45.85           C  
ATOM     95  CB  GLN    21       9.966  21.882  48.065  1.00 46.10           C  
ATOM     98  CG  GLN    21      11.462  21.638  47.776  1.00 45.85           C  
ATOM    101  CD  GLN    21      12.355  22.618  48.495  1.00 46.50           C  
ATOM    102  OE1 GLN    21      12.212  23.845  48.353  1.00 47.26           O  
ATOM    103  NE2 GLN    21      13.273  22.092  49.288  1.00 45.90           N  
ATOM    106  C   GLN    21       8.049  22.035  49.714  1.00 46.07           C  
ATOM    107  O   GLN    21       7.198  21.166  49.469  1.00 45.86           O  
ATOM    109  N   SER    22       7.741  23.259  50.150  1.00 45.86           N  
ATOM    110  CA  SER    22       6.375  23.680  50.384  1.00 45.60           C  
ATOM    112  CB  SER    22       6.366  24.830  51.367  1.00 45.59           C  
ATOM    115  OG  SER    22       6.782  26.037  50.750  1.00 46.30           O  
ATOM    117  C   SER    22       5.742  24.134  49.088  1.00 45.80           C  
ATOM    118  O   SER    22       6.407  24.114  48.046  1.00 45.84           O  
ATOM    120  N   MET    23       4.473  24.560  49.153  1.00 46.02           N  
ATOM    121  CA  MET    23       3.772  25.115  47.983  1.00 46.05           C  
ATOM    123  CB  MET    23       2.313  25.460  48.298  1.00 46.56           C  
ATOM    126  CG  MET    23       1.275  24.330  48.059  1.00 48.82           C  
ATOM    129  SD  MET    23       1.254  23.496  46.412  1.00 52.49           S  
ATOM    130  CE  MET    23      -0.396  22.776  46.537  1.00 50.38           C  
ATOM    134  C   MET    23       4.432  26.367  47.439  1.00 45.55           C  
ATOM    135  O   MET    23       4.601  26.477  46.236  1.00 45.57           O  
ATOM    137  N   GLU    24       4.773  27.312  48.309  1.00 45.12           N  
ATOM    138  CA  GLU    24       5.405  28.529  47.862  1.00 45.24           C  
ATOM    140  CB  GLU    24       5.574  29.505  49.001  1.00 45.00           C  
ATOM    143  CG  GLU    24       4.249  30.004  49.540  1.00 45.52           C  
ATOM    146  CD  GLU    24       4.420  31.305  50.323  1.00 47.26           C  
ATOM    147  OE1 GLU    24       5.446  31.973  50.070  1.00 48.66           O  
ATOM    148  OE2 GLU    24       3.543  31.676  51.171  1.00 46.60           O  
ATOM    149  C   GLU    24       6.756  28.195  47.248  1.00 45.58           C  
ATOM    150  O   GLU    24       7.118  28.700  46.165  1.00 45.97           O  
ATOM    152  N   GLU    25       7.499  27.321  47.916  1.00 45.42           N  
ATOM    153  CA  GLU    25       8.791  26.893  47.383  1.00 45.38           C  
ATOM    155  CB  GLU    25       9.527  26.016  48.395  1.00 45.48           C  
ATOM    158  CG  GLU    25       9.801  26.759  49.699  1.00 46.23           C  
ATOM    161  CD  GLU    25      10.373  25.873  50.810  1.00 47.64           C  
ATOM    162  OE1 GLU    25       9.890  24.719  51.016  1.00 46.52           O  
ATOM    163  OE2 GLU    25      11.298  26.364  51.498  1.00 48.29           O  
ATOM    164  C   GLU    25       8.695  26.205  46.022  1.00 44.72           C  
ATOM    165  O   GLU    25       9.574  26.385  45.200  1.00 44.67           O  
ATOM    167  N   THR    26       7.633  25.425  45.805  1.00 44.33           N  
ATOM    168  CA  THR    26       7.333  24.809  44.497  1.00 43.62           C  
ATOM    170  CB  THR    26       6.097  23.810  44.583  1.00 43.61           C  
ATOM    172  OG1 THR    26       6.387  22.773  45.511  1.00 42.09           O  
ATOM    174  CG2 THR    26       5.748  23.157  43.247  1.00 42.42           C  
ATOM    178  C   THR    26       7.092  25.942  43.492  1.00 43.04           C  
ATOM    179  O   THR    26       7.712  25.993  42.437  1.00 42.50           O  
ATOM    181  N   GLU    27       6.220  26.875  43.843  1.00 42.37           N  
ATOM    182  CA  GLU    27       5.971  28.002  42.978  1.00 42.31           C  
ATOM    184  CB  GLU    27       5.035  29.005  43.622  1.00 42.84           C  
ATOM    187  CG  GLU    27       3.580  28.566  43.707  1.00 44.60           C  
ATOM    190  CD  GLU    27       2.700  29.690  44.267  1.00 47.31           C  
ATOM    191  OE1 GLU    27       3.193  30.857  44.272  1.00 48.72           O  
ATOM    192  OE2 GLU    27       1.529  29.432  44.703  1.00 48.41           O  
ATOM    193  C   GLU    27       7.270  28.692  42.631  1.00 40.95           C  
ATOM    194  O   GLU    27       7.497  29.041  41.480  1.00 41.59           O  
ATOM    196  N   LYS    28       8.126  28.886  43.622  1.00 39.03           N  
ATOM    197  CA  LYS    28       9.440  29.455  43.359  1.00 37.62           C  
ATOM    199  CB  LYS    28      10.250  29.534  44.641  1.00 37.50           C  
ATOM    202  CG  LYS    28      11.590  30.230  44.447  1.00 38.41           C  
ATOM    205  CD  LYS    28      12.753  29.466  45.069  1.00 39.23           C  
ATOM    208  CE  LYS    28      12.679  29.456  46.565  1.00 38.91           C  
ATOM    211  NZ  LYS    28      13.578  28.418  47.073  1.00 40.24           N  
ATOM    215  C   LYS    28      10.246  28.672  42.302  1.00 35.90           C  
ATOM    216  O   LYS    28      10.746  29.267  41.371  1.00 36.93           O  
ATOM    218  N   TRP    29      10.371  27.357  42.443  1.00 33.27           N  
ATOM    219  CA  TRP    29      11.165  26.570  41.498  1.00 31.54           C  
ATOM    221  CB  TRP    29      11.338  25.115  41.957  1.00 30.99           C  
ATOM    224  CG  TRP    29      11.998  24.926  43.278  1.00 30.44           C  
ATOM    225  CD1 TRP    29      11.570  24.110  44.281  1.00 30.13           C  
ATOM    227  NE1 TRP    29      12.435  24.175  45.351  1.00 30.02           N  
ATOM    229  CE2 TRP    29      13.444  25.050  45.056  1.00 29.08           C  
ATOM    230  CD2 TRP    29      13.206  25.551  43.764  1.00 29.84           C  
ATOM    231  CE3 TRP    29      14.106  26.479  43.230  1.00 30.17           C  
ATOM    233  CZ3 TRP    29      15.182  26.878  43.993  1.00 29.10           C  
ATOM    235  CH2 TRP    29      15.381  26.365  45.270  1.00 28.82           C  
ATOM    237  CZ2 TRP    29      14.522  25.453  45.820  1.00 28.69           C  
ATOM    239  C   TRP    29      10.577  26.553  40.093  1.00 30.66           C  
ATOM    240  O   TRP    29      11.321  26.503  39.114  1.00 30.04           O  
ATOM    242  N   MET    30       9.250  26.560  39.994  1.00 29.83           N  
ATOM    243  CA  MET    30       8.583  26.606  38.693  1.00 29.32           C  
ATOM    245  CB  MET    30       7.080  26.363  38.827  1.00 29.13           C  
ATOM    248  CG  MET    30       6.695  24.908  39.105  1.00 28.73           C  
ATOM    251  SD  MET    30       7.113  23.702  37.840  1.00 25.62           S  
ATOM    252  CE  MET    30       6.050  24.188  36.496  1.00 25.40           C  
ATOM    256  C   MET    30       8.816  27.922  37.964  1.00 28.82           C  
ATOM    257  O   MET    30       8.940  27.927  36.765  1.00 28.66           O  
ATOM    259  N   GLU    31       8.873  29.027  38.689  1.00 28.72           N  
ATOM    260  CA  GLU    31       9.214  30.321  38.090  1.00 29.06           C  
ATOM    262  CB  GLU    31       9.174  31.465  39.137  1.00 29.45           C  
ATOM    265  CG  GLU    31       7.991  32.434  39.044  1.00 29.57           C  
ATOM    268  CD  GLU    31       7.831  33.294  40.339  1.00 33.21           C  
ATOM    269  OE1 GLU    31       7.467  34.564  40.270  1.00 32.31           O  
ATOM    270  OE2 GLU    31       8.075  32.684  41.452  1.00 35.33           O  
ATOM    271  C   GLU    31      10.604  30.262  37.479  1.00 28.87           C  
ATOM    272  O   GLU    31      10.827  30.752  36.382  1.00 28.74           O  
ATOM    274  N   GLU    32      11.544  29.670  38.205  1.00 28.87           N  
ATOM    275  CA  GLU    32      12.909  29.533  37.701  1.00 29.07           C  
ATOM    277  CB  GLU    32      13.876  29.003  38.777  1.00 29.29           C  
ATOM    280  CG  GLU    32      15.319  29.531  38.660  1.00 30.35           C  
ATOM    283  CD  GLU    32      16.038  29.670  40.034  1.00 32.92           C  
ATOM    284  OE1 GLU    32      16.446  28.584  40.580  1.00 33.02           O  
ATOM    285  OE2 GLU    32      16.223  30.868  40.532  1.00 32.31           O  
ATOM    286  C   GLU    32      12.932  28.636  36.474  1.00 29.00           C  
ATOM    287  O   GLU    32      13.630  28.954  35.536  1.00 29.87           O  
ATOM    289  N   ALA    33      12.176  27.534  36.469  1.00 28.65           N  
ATOM    290  CA  ALA    33      12.074  26.677  35.272  1.00 28.41           C  
ATOM    292  CB  ALA    33      11.272  25.376  35.580  1.00 28.13           C  
ATOM    296  C   ALA    33      11.467  27.433  34.073  1.00 27.98           C  
ATOM    297  O   ALA    33      11.779  27.140  32.919  1.00 27.17           O  
ATOM    299  N   MET    34      10.613  28.412  34.367  1.00 27.93           N  
ATOM    300  CA  MET    34       9.948  29.219  33.339  1.00 28.14           C  
ATOM    302  CB  MET    34       8.803  30.030  33.949  1.00 28.21           C  
ATOM    305  CG  MET    34       7.517  29.250  34.113  1.00 28.80           C  
ATOM    308  SD  MET    34       6.705  28.872  32.536  1.00 30.50           S  
ATOM    309  CE  MET    34       6.132  30.522  32.012  1.00 29.12           C  
ATOM    313  C   MET    34      10.916  30.175  32.664  1.00 28.10           C  
ATOM    314  O   MET    34      10.875  30.374  31.449  1.00 27.67           O  
ATOM    316  N   HIS    35      11.789  30.765  33.467  1.00 28.28           N  
ATOM    317  CA  HIS    35      12.821  31.630  32.951  1.00 28.33           C  
ATOM    319  CB  HIS    35      13.581  32.265  34.112  1.00 28.41           C  
ATOM    322  CG  HIS    35      12.858  33.425  34.730  1.00 29.93           C  
ATOM    323  ND1 HIS    35      11.876  34.132  34.062  1.00 31.57           N  
ATOM    325  CE1 HIS    35      11.437  35.118  34.832  1.00 31.30           C  
ATOM    327  NE2 HIS    35      12.092  35.071  35.978  1.00 31.32           N  
ATOM    329  CD2 HIS    35      12.985  34.021  35.943  1.00 31.00           C  
ATOM    331  C   HIS    35      13.742  30.839  32.027  1.00 28.17           C  
ATOM    332  O   HIS    35      14.065  31.289  30.934  1.00 27.82           O  
ATOM    334  N   MET    36      14.123  29.641  32.458  1.00 28.15           N  
ATOM    335  CA  MET    36      14.961  28.760  31.661  1.00 28.40           C  
ATOM    337  CB  MET    36      15.322  27.506  32.450  1.00 28.40           C  
ATOM    340  CG  MET    36      16.315  27.796  33.560  1.00 29.25           C  
ATOM    343  SD  MET    36      16.813  26.309  34.428  1.00 31.57           S  
ATOM    344  CE  MET    36      18.067  25.576  33.340  1.00 32.53           C  
ATOM    348  C   MET    36      14.308  28.388  30.336  1.00 28.59           C  
ATOM    349  O   MET    36      14.979  28.316  29.303  1.00 28.44           O  
ATOM    351  N   ALA    37      12.999  28.161  30.359  1.00 28.78           N  
ATOM    352  CA  ALA    37      12.272  27.908  29.139  1.00 28.45           C  
ATOM    354  CB  ALA    37      10.865  27.523  29.464  1.00 28.21           C  
ATOM    358  C   ALA    37      12.350  29.138  28.203  1.00 28.53           C  
ATOM    359  O   ALA    37      12.535  28.976  26.991  1.00 28.74           O  
ATOM    361  N   LYS    38      12.254  30.353  28.753  1.00 28.46           N  
ATOM    362  CA  LYS    38      12.479  31.585  27.952  1.00 28.77           C  
ATOM    364  CB  LYS    38      12.362  32.855  28.810  1.00 28.84           C  
ATOM    367  CG  LYS    38      11.173  33.763  28.490  1.00 29.78           C  
ATOM    370  CD  LYS    38      10.670  34.538  29.775  1.00 31.42           C  
ATOM    373  CE  LYS    38       9.790  33.635  30.740  1.00 31.00           C  
ATOM    376  NZ  LYS    38       9.628  34.146  32.144  1.00 30.04           N  
ATOM    380  C   LYS    38      13.844  31.602  27.254  1.00 28.67           C  
ATOM    381  O   LYS    38      13.935  31.826  26.059  1.00 28.60           O  
ATOM    383  N   GLU    39      14.903  31.388  28.029  1.00 28.92           N  
ATOM    384  CA  GLU    39      16.255  31.241  27.491  1.00 29.07           C  
ATOM    386  CB  GLU    39      17.256  30.896  28.615  1.00 29.32           C  
ATOM    389  CG  GLU    39      17.683  32.092  29.525  1.00 29.97           C  
ATOM    392  CD  GLU    39      18.618  31.675  30.698  1.00 30.95           C  
ATOM    393  OE1 GLU    39      18.395  30.602  31.336  1.00 31.36           O  
ATOM    394  OE2 GLU    39      19.579  32.435  30.976  1.00 30.64           O  
ATOM    395  C   GLU    39      16.323  30.161  26.391  1.00 29.31           C  
ATOM    396  O   GLU    39      16.994  30.352  25.385  1.00 29.93           O  
ATOM    398  N   ALA    40      15.655  29.025  26.568  1.00 29.26           N  
ATOM    399  CA  ALA    40      15.675  27.990  25.538  1.00 29.14           C  
ATOM    401  CB  ALA    40      14.954  26.733  26.023  1.00 29.09           C  
ATOM    405  C   ALA    40      15.052  28.523  24.233  1.00 29.31           C  
ATOM    406  O   ALA    40      15.647  28.416  23.135  1.00 29.24           O  
ATOM    408  N   LEU    41      13.866  29.115  24.357  1.00 29.40           N  
ATOM    409  CA  LEU    41      13.176  29.725  23.208  1.00 29.34           C  
ATOM    411  CB  LEU    41      12.006  30.573  23.716  1.00 29.30           C  
ATOM    414  CG  LEU    41      11.070  31.167  22.677  1.00 28.71           C  
ATOM    416  CD1 LEU    41      10.148  30.062  22.197  1.00 28.68           C  
ATOM    420  CD2 LEU    41      10.302  32.340  23.267  1.00 27.42           C  
ATOM    424  C   LEU    41      14.117  30.616  22.372  1.00 29.48           C  
ATOM    425  O   LEU    41      14.211  30.475  21.134  1.00 29.85           O  
ATOM    427  N   GLU    42      14.821  31.511  23.067  1.00 29.00           N  
ATOM    428  CA  GLU    42      15.649  32.517  22.438  1.00 28.74           C  
ATOM    430  CB  GLU    42      15.908  33.598  23.449  1.00 28.67           C  
ATOM    433  CG  GLU    42      14.645  34.363  23.746  1.00 29.55           C  
ATOM    436  CD  GLU    42      14.781  35.250  24.971  1.00 31.30           C  
ATOM    437  OE1 GLU    42      15.008  34.664  26.080  1.00 30.85           O  
ATOM    438  OE2 GLU    42      14.659  36.515  24.804  1.00 30.70           O  
ATOM    439  C   GLU    42      16.957  31.966  21.908  1.00 28.87           C  
ATOM    440  O   GLU    42      17.677  32.661  21.201  1.00 28.72           O  
ATOM    442  N   ASN    43      17.266  30.718  22.268  1.00 29.31           N  
ATOM    443  CA  ASN    43      18.369  29.949  21.660  1.00 29.26           C  
ATOM    445  CB  ASN    43      19.164  29.173  22.728  1.00 29.03           C  
ATOM    448  CG  ASN    43      19.818  30.083  23.766  1.00 29.03           C  
ATOM    449  OD1 ASN    43      20.204  31.217  23.469  1.00 28.55           O  
ATOM    450  ND2 ASN    43      19.954  29.576  24.993  1.00 28.89           N  
ATOM    453  C   ASN    43      17.872  28.958  20.602  1.00 29.20           C  
ATOM    454  O   ASN    43      18.569  27.989  20.314  1.00 29.62           O  
ATOM    456  N   THR    44      16.686  29.195  20.033  1.00 28.87           N  
ATOM    457  CA  THR    44      16.102  28.289  19.041  1.00 28.84           C  
ATOM    459  CB  THR    44      16.897  28.318  17.748  1.00 28.74           C  
ATOM    461  OG1 THR    44      17.471  29.619  17.586  1.00 29.50           O  
ATOM    463  CG2 THR    44      15.986  27.971  16.552  1.00 28.77           C  
ATOM    467  C   THR    44      16.009  26.828  19.506  1.00 28.90           C  
ATOM    468  O   THR    44      16.232  25.893  18.716  1.00 28.57           O  
ATOM    470  N   GLU    45      15.692  26.641  20.789  1.00 28.78           N  
ATOM    471  CA  GLU    45      15.473  25.302  21.339  1.00 28.92           C  
ATOM    473  CB  GLU    45      16.415  25.012  22.521  1.00 28.92           C  
ATOM    476  CG  GLU    45      17.931  25.000  22.196  1.00 29.45           C  
ATOM    479  CD  GLU    45      18.448  23.676  21.635  1.00 29.36           C  
ATOM    480  OE1 GLU    45      19.688  23.562  21.442  1.00 27.01           O  
ATOM    481  OE2 GLU    45      17.612  22.771  21.370  1.00 30.17           O  
ATOM    482  C   GLU    45      14.006  25.190  21.777  1.00 28.65           C  
ATOM    483  O   GLU    45      13.339  26.213  22.050  1.00 29.00           O  
ATOM    485  N   VAL    46      13.501  23.955  21.814  1.00 27.84           N  
ATOM    486  CA  VAL    46      12.162  23.715  22.317  1.00 27.20           C  
ATOM    488  CB  VAL    46      11.844  22.202  22.430  1.00 27.04           C  
ATOM    490  CG1 VAL    46      10.470  22.021  22.949  1.00 26.48           C  
ATOM    494  CG2 VAL    46      11.994  21.495  21.085  1.00 25.84           C  
ATOM    498  C   VAL    46      12.218  24.332  23.700  1.00 26.94           C  
ATOM    499  O   VAL    46      13.138  24.032  24.430  1.00 27.21           O  
ATOM    501  N   PRO    47      11.286  25.236  24.048  1.00 26.78           N  
ATOM    502  CA  PRO    47      11.296  25.903  25.373  1.00 26.70           C  
ATOM    504  CB  PRO    47      10.367  27.113  25.179  1.00 26.66           C  
ATOM    507  CG  PRO    47       9.422  26.670  24.121  1.00 27.05           C  
ATOM    510  CD  PRO    47      10.184  25.723  23.207  1.00 26.93           C  
ATOM    513  C   PRO    47      10.822  25.037  26.522  1.00 26.24           C  
ATOM    514  O   PRO    47       9.673  25.088  26.918  1.00 26.00           O  
ATOM    515  N   VAL    48      11.735  24.233  27.027  1.00 26.62           N  
ATOM    516  CA  VAL    48      11.513  23.417  28.200  1.00 27.16           C  
ATOM    518  CB  VAL    48      11.457  21.880  27.852  1.00 27.41           C  
ATOM    520  CG1 VAL    48      11.253  21.035  29.132  1.00 26.53           C  
ATOM    524  CG2 VAL    48      10.393  21.571  26.783  1.00 25.65           C  
ATOM    528  C   VAL    48      12.716  23.717  29.106  1.00 27.85           C  
ATOM    529  O   VAL    48      13.887  23.614  28.672  1.00 28.19           O  
ATOM    531  N   GLY    49      12.435  24.143  30.334  1.00 27.89           N  
ATOM    532  CA  GLY    49      13.460  24.283  31.361  1.00 27.79           C  
ATOM    535  C   GLY    49      13.077  23.403  32.544  1.00 27.95           C  
ATOM    536  O   GLY    49      11.895  23.182  32.778  1.00 28.14           O  
ATOM    538  N   CYS    50      14.052  22.876  33.284  1.00 27.93           N  
ATOM    539  CA  CYS    50      13.715  22.173  34.504  1.00 28.84           C  
ATOM    541  CB  CYS    50      13.297  20.749  34.174  1.00 28.84           C  
ATOM    544  SG  CYS    50      14.643  19.606  34.018  1.00 33.39           S  
ATOM    546  C   CYS    50      14.794  22.187  35.602  1.00 28.72           C  
ATOM    547  O   CYS    50      15.972  22.404  35.318  1.00 28.99           O  
ATOM    549  N   LEU    51      14.348  21.985  36.849  1.00 28.66           N  
ATOM    550  CA  LEU    51      15.194  21.936  38.050  1.00 28.44           C  
ATOM    552  CB  LEU    51      14.880  23.128  38.954  1.00 28.29           C  
ATOM    555  CG  LEU    51      15.232  24.521  38.431  1.00 28.29           C  
ATOM    557  CD1 LEU    51      14.136  25.489  38.675  1.00 29.32           C  
ATOM    561  CD2 LEU    51      16.480  25.050  39.095  1.00 30.45           C  
ATOM    565  C   LEU    51      14.956  20.617  38.827  1.00 28.35           C  
ATOM    566  O   LEU    51      13.876  20.048  38.798  1.00 28.95           O  
ATOM    568  N   MET    52      15.958  20.126  39.526  1.00 27.97           N  
ATOM    569  CA  MET    52      15.745  19.011  40.400  1.00 28.22           C  
ATOM    571  CB  MET    52      16.413  17.765  39.825  1.00 28.57           C  
ATOM    574  CG  MET    52      15.607  17.113  38.742  1.00 29.75           C  
ATOM    577  SD  MET    52      16.528  15.808  37.882  1.00 30.98           S  
ATOM    578  CE  MET    52      16.168  14.414  38.917  1.00 33.55           C  
ATOM    582  C   MET    52      16.255  19.354  41.807  1.00 28.12           C  
ATOM    583  O   MET    52      17.427  19.709  42.002  1.00 27.75           O  
ATOM    585  N   VAL    53      15.354  19.242  42.781  1.00 27.75           N  
ATOM    586  CA  VAL    53      15.642  19.628  44.149  1.00 27.86           C  
ATOM    588  CB  VAL    53      14.603  20.664  44.634  1.00 27.43           C  
ATOM    590  CG1 VAL    53      14.756  20.937  46.109  1.00 27.32           C  
ATOM    594  CG2 VAL    53      14.729  21.953  43.833  1.00 27.25           C  
ATOM    598  C   VAL    53      15.710  18.395  45.089  1.00 28.27           C  
ATOM    599  O   VAL    53      14.819  17.559  45.116  1.00 28.02           O  
ATOM    601  N   TYR    54      16.790  18.308  45.863  1.00 28.71           N  
ATOM    602  CA  TYR    54      16.978  17.239  46.855  1.00 28.55           C  
ATOM    604  CB  TYR    54      18.085  16.279  46.430  1.00 28.75           C  
ATOM    607  CG  TYR    54      18.551  15.359  47.499  1.00 27.40           C  
ATOM    608  CD1 TYR    54      17.820  14.230  47.830  1.00 28.08           C  
ATOM    610  CE1 TYR    54      18.244  13.355  48.820  1.00 28.43           C  
ATOM    612  CZ  TYR    54      19.430  13.620  49.480  1.00 29.94           C  
ATOM    613  OH  TYR    54      19.905  12.759  50.454  1.00 32.14           O  
ATOM    615  CE2 TYR    54      20.192  14.739  49.135  1.00 29.42           C  
ATOM    617  CD2 TYR    54      19.745  15.591  48.148  1.00 27.87           C  
ATOM    619  C   TYR    54      17.366  17.869  48.152  1.00 28.27           C  
ATOM    620  O   TYR    54      18.279  18.662  48.173  1.00 28.82           O  
ATOM    622  N   ASN    55      16.677  17.488  49.221  1.00 28.12           N  
ATOM    623  CA  ASN    55      16.918  18.006  50.563  1.00 28.03           C  
ATOM    625  CB  ASN    55      18.059  17.234  51.242  1.00 28.30           C  
ATOM    628  CG  ASN    55      18.050  17.374  52.753  1.00 28.25           C  
ATOM    629  OD1 ASN    55      17.015  17.664  53.345  1.00 27.11           O  
ATOM    630  ND2 ASN    55      19.190  17.134  53.381  1.00 25.68           N  
ATOM    633  C   ASN    55      17.189  19.501  50.573  1.00 27.90           C  
ATOM    634  O   ASN    55      18.159  19.980  51.170  1.00 27.64           O  
ATOM    636  N   ASN    56      16.320  20.224  49.887  1.00 27.79           N  
ATOM    637  CA  ASN    56      16.363  21.691  49.865  1.00 28.13           C  
ATOM    639  CB  ASN    56      16.324  22.254  51.279  1.00 28.01           C  
ATOM    642  CG  ASN    56      15.882  23.683  51.311  1.00 27.94           C  
ATOM    643  OD1 ASN    56      15.237  24.172  50.381  1.00 31.08           O  
ATOM    644  ND2 ASN    56      16.215  24.367  52.378  1.00 27.46           N  
ATOM    647  C   ASN    56      17.533  22.307  49.134  1.00 27.87           C  
ATOM    648  O   ASN    56      17.908  23.425  49.409  1.00 28.32           O  
ATOM    650  N   GLU    57      18.082  21.574  48.183  1.00 27.86           N  
ATOM    651  CA  GLU    57      19.217  22.024  47.409  1.00 27.68           C  
ATOM    653  CB  GLU    57      20.472  21.281  47.847  1.00 27.08           C  
ATOM    656  CG  GLU    57      21.672  21.541  46.962  1.00 28.55           C  
ATOM    659  CD  GLU    57      23.044  21.418  47.718  1.00 30.79           C  
ATOM    660  OE1 GLU    57      24.101  21.861  47.139  1.00 30.38           O  
ATOM    661  OE2 GLU    57      23.061  20.888  48.874  1.00 30.25           O  
ATOM    662  C   GLU    57      18.879  21.798  45.937  1.00 27.63           C  
ATOM    663  O   GLU    57      18.169  20.830  45.585  1.00 27.10           O  
ATOM    665  N   VAL    58      19.321  22.734  45.093  1.00 27.91           N  
ATOM    666  CA  VAL    58      19.139  22.617  43.654  1.00 27.84           C  
ATOM    668  CB  VAL    58      19.194  23.956  42.914  1.00 27.95           C  
ATOM    670  CG1 VAL    58      19.081  23.684  41.414  1.00 27.53           C  
ATOM    674  CG2 VAL    58      18.097  24.893  43.401  1.00 27.26           C  
ATOM    678  C   VAL    58      20.250  21.735  43.142  1.00 27.85           C  
ATOM    679  O   VAL    58      21.372  22.153  42.975  1.00 27.19           O  
ATOM    681  N   VAL    59      19.894  20.494  42.876  1.00 28.57           N  
ATOM    682  CA  VAL    59      20.856  19.448  42.563  1.00 28.61           C  
ATOM    684  CB  VAL    59      20.415  18.170  43.356  1.00 28.52           C  
ATOM    686  CG1 VAL    59      19.333  17.410  42.623  1.00 27.61           C  
ATOM    690  CG2 VAL    59      21.584  17.307  43.628  1.00 30.18           C  
ATOM    694  C   VAL    59      21.022  19.190  41.019  1.00 28.74           C  
ATOM    695  O   VAL    59      21.896  18.437  40.605  1.00 28.89           O  
ATOM    697  N   GLY    60      20.192  19.812  40.180  1.00 28.38           N  
ATOM    698  CA  GLY    60      20.330  19.712  38.737  1.00 28.23           C  
ATOM    701  C   GLY    60      19.404  20.682  38.007  1.00 28.41           C  
ATOM    702  O   GLY    60      18.276  20.866  38.404  1.00 28.63           O  
ATOM    704  N   LYS    61      19.916  21.324  36.960  1.00 28.65           N  
ATOM    705  CA  LYS    61      19.168  22.227  36.093  1.00 28.54           C  
ATOM    707  CB  LYS    61      19.780  23.640  36.140  1.00 28.95           C  
ATOM    710  CG  LYS    61      19.463  24.488  37.367  1.00 28.34           C  
ATOM    713  CD  LYS    61      20.179  25.840  37.225  1.00 29.50           C  
ATOM    716  CE  LYS    61      20.207  26.654  38.541  1.00 30.91           C  
ATOM    719  NZ  LYS    61      18.964  27.499  38.849  1.00 30.87           N  
ATOM    723  C   LYS    61      19.282  21.710  34.650  1.00 28.73           C  
ATOM    724  O   LYS    61      20.198  20.928  34.303  1.00 28.29           O  
ATOM    726  N   GLY    62      18.379  22.158  33.784  1.00 28.67           N  
ATOM    727  CA  GLY    62      18.523  21.784  32.389  1.00 28.85           C  
ATOM    730  C   GLY    62      17.522  22.399  31.467  1.00 28.68           C  
ATOM    731  O   GLY    62      16.377  22.533  31.822  1.00 29.05           O  
ATOM    733  N   ARG    63      17.983  22.761  30.279  1.00 28.89           N  
ATOM    734  CA  ARG    63      17.144  23.177  29.179  1.00 28.89           C  
ATOM    736  CB  ARG    63      17.613  24.542  28.668  1.00 29.02           C  
ATOM    739  CG  ARG    63      17.129  25.716  29.490  1.00 29.86           C  
ATOM    742  CD  ARG    63      18.067  26.929  29.395  1.00 30.14           C  
ATOM    745  NE  ARG    63      19.316  26.658  30.105  1.00 31.33           N  
ATOM    747  CZ  ARG    63      20.264  27.559  30.367  1.00 31.77           C  
ATOM    748  NH1 ARG    63      20.100  28.830  29.992  1.00 31.57           N  
ATOM    751  NH2 ARG    63      21.380  27.181  31.007  1.00 30.99           N  
ATOM    754  C   ARG    63      17.358  22.195  28.056  1.00 29.11           C  
ATOM    755  O   ARG    63      18.388  21.496  28.019  1.00 29.15           O  
ATOM    757  N   ASN    64      16.420  22.169  27.108  1.00 29.06           N  
ATOM    758  CA  ASN    64      16.671  21.481  25.849  1.00 28.97           C  
ATOM    760  CB  ASN    64      15.497  21.629  24.909  1.00 29.21           C  
ATOM    763  CG  ASN    64      14.555  20.442  24.966  1.00 30.76           C  
ATOM    764  OD1 ASN    64      14.095  20.021  26.061  1.00 31.58           O  
ATOM    765  ND2 ASN    64      14.238  19.899  23.783  1.00 30.37           N  
ATOM    768  C   ASN    64      17.914  22.003  25.151  1.00 28.78           C  
ATOM    769  O   ASN    64      18.100  23.209  25.044  1.00 28.39           O  
ATOM    771  N   GLU    65      18.741  21.063  24.683  1.00 28.83           N  
ATOM    772  CA  GLU    65      19.991  21.336  23.956  1.00 28.70           C  
ATOM    774  CB  GLU    65      21.208  20.948  24.811  1.00 28.43           C  
ATOM    777  CG  GLU    65      21.363  21.803  26.060  1.00 29.26           C  
ATOM    780  CD  GLU    65      22.567  21.420  26.935  1.00 31.11           C  
ATOM    781  OE1 GLU    65      23.208  20.350  26.722  1.00 32.83           O  
ATOM    782  OE2 GLU    65      22.862  22.193  27.874  1.00 32.15           O  
ATOM    783  C   GLU    65      20.053  20.599  22.593  1.00 28.61           C  
ATOM    784  O   GLU    65      21.143  20.477  22.010  1.00 28.58           O  
ATOM    786  N   VAL    66      18.896  20.169  22.062  1.00 27.88           N  
ATOM    787  CA  VAL    66      18.886  19.316  20.880  1.00 27.67           C  
ATOM    789  CB  VAL    66      17.459  18.841  20.468  1.00 27.53           C  
ATOM    791  CG1 VAL    66      17.529  18.039  19.197  1.00 26.83           C  
ATOM    795  CG2 VAL    66      16.898  17.936  21.521  1.00 26.62           C  
ATOM    799  C   VAL    66      19.638  19.911  19.702  1.00 27.74           C  
ATOM    800  O   VAL    66      20.368  19.174  19.054  1.00 27.05           O  
ATOM    802  N   ASN    67      19.485  21.227  19.463  1.00 28.26           N  
ATOM    803  CA  ASN    67      20.095  21.919  18.295  1.00 28.74           C  
ATOM    805  CB  ASN    67      19.369  23.234  17.954  1.00 29.15           C  
ATOM    808  CG  ASN    67      17.862  23.046  17.756  1.00 30.45           C  
ATOM    809  OD1 ASN    67      17.316  21.924  17.886  1.00 31.70           O  
ATOM    810  ND2 ASN    67      17.175  24.152  17.467  1.00 29.61           N  
ATOM    813  C   ASN    67      21.546  22.272  18.503  1.00 28.57           C  
ATOM    814  O   ASN    67      22.382  22.068  17.625  1.00 28.06           O  
ATOM    816  N   GLN    68      21.820  22.854  19.661  1.00 28.68           N  
ATOM    817  CA  GLN    68      23.187  23.164  20.074  1.00 29.07           C  
ATOM    819  CB  GLN    68      23.182  23.668  21.536  1.00 29.90           C  
ATOM    822  CG  GLN    68      22.524  25.095  21.719  1.00 32.43           C  
ATOM    825  CD  GLN    68      22.188  25.490  23.188  1.00 32.48           C  
ATOM    826  OE1 GLN    68      21.718  24.669  23.999  1.00 31.76           O  
ATOM    827  NE2 GLN    68      22.424  26.777  23.507  1.00 31.80           N  
ATOM    830  C   GLN    68      24.041  21.912  20.001  1.00 28.56           C  
ATOM    831  O   GLN    68      25.150  21.918  19.494  1.00 27.79           O  
ATOM    833  N   THR    69      23.495  20.836  20.554  1.00 28.62           N  
ATOM    834  CA  THR    69      24.199  19.575  20.692  1.00 28.33           C  
ATOM    836  CB  THR    69      23.715  18.855  21.942  1.00 27.93           C  
ATOM    838  OG1 THR    69      24.674  17.873  22.314  1.00 30.06           O  
ATOM    840  CG2 THR    69      22.403  18.168  21.682  1.00 28.03           C  
ATOM    844  C   THR    69      24.028  18.652  19.476  1.00 28.16           C  
ATOM    845  O   THR    69      24.864  17.762  19.267  1.00 28.11           O  
ATOM    847  N   LYS    70      22.972  18.895  18.683  1.00 27.74           N  
ATOM    848  CA  LYS    70      22.589  18.065  17.531  1.00 27.50           C  
ATOM    850  CB  LYS    70      23.563  18.266  16.384  1.00 27.34           C  
ATOM    853  CG  LYS    70      23.246  19.525  15.632  1.00 28.15           C  
ATOM    856  CD  LYS    70      24.390  19.949  14.775  1.00 29.05           C  
ATOM    859  CE  LYS    70      24.183  21.367  14.275  1.00 29.94           C  
ATOM    862  NZ  LYS    70      25.274  21.771  13.281  1.00 31.00           N  
ATOM    866  C   LYS    70      22.383  16.586  17.886  1.00 27.49           C  
ATOM    867  O   LYS    70      22.638  15.688  17.088  1.00 27.02           O  
ATOM    869  N   ASN    71      21.857  16.364  19.083  1.00 27.55           N  
ATOM    870  CA  ASN    71      21.554  15.046  19.586  1.00 27.78           C  
ATOM    872  CB  ASN    71      22.528  14.710  20.740  1.00 28.42           C  
ATOM    875  CG  ASN    71      22.027  13.539  21.665  1.00 28.76           C  
ATOM    876  OD1 ASN    71      20.966  12.957  21.460  1.00 27.98           O  
ATOM    877  ND2 ASN    71      22.818  13.221  22.698  1.00 28.49           N  
ATOM    880  C   ASN    71      20.093  15.093  20.051  1.00 27.58           C  
ATOM    881  O   ASN    71      19.764  15.768  21.038  1.00 27.17           O  
ATOM    883  N   ALA    72      19.246  14.340  19.348  1.00 27.15           N  
ATOM    884  CA  ALA    72      17.800  14.367  19.546  1.00 27.07           C  
ATOM    886  CB  ALA    72      17.127  13.525  18.488  1.00 26.68           C  
ATOM    890  C   ALA    72      17.315  13.950  20.941  1.00 27.13           C  
ATOM    891  O   ALA    72      16.182  14.226  21.301  1.00 26.86           O  
ATOM    893  N   THR    73      18.163  13.293  21.726  1.00 27.64           N  
ATOM    894  CA  THR    73      17.794  12.844  23.087  1.00 27.77           C  
ATOM    896  CB  THR    73      18.487  11.475  23.481  1.00 27.68           C  
ATOM    898  OG1 THR    73      19.896  11.661  23.586  1.00 28.68           O  
ATOM    900  CG2 THR    73      18.245  10.386  22.484  1.00 27.37           C  
ATOM    904  C   THR    73      18.077  13.870  24.222  1.00 27.70           C  
ATOM    905  O   THR    73      17.605  13.670  25.328  1.00 28.04           O  
ATOM    907  N   ARG    74      18.804  14.962  23.970  1.00 28.06           N  
ATOM    908  CA  ARG    74      19.126  15.931  25.042  1.00 28.19           C  
ATOM    910  CB  ARG    74      20.501  16.601  24.849  1.00 28.37           C  
ATOM    913  CG  ARG    74      21.630  15.661  25.334  1.00 29.65           C  
ATOM    916  CD  ARG    74      23.077  16.273  25.365  1.00 31.98           C  
ATOM    919  NE  ARG    74      23.948  15.483  24.442  1.00 33.67           N  
ATOM    921  CZ  ARG    74      25.287  15.545  24.348  1.00 32.37           C  
ATOM    922  NH1 ARG    74      26.000  16.370  25.135  1.00 33.11           N  
ATOM    925  NH2 ARG    74      25.913  14.770  23.451  1.00 30.11           N  
ATOM    928  C   ARG    74      18.008  16.914  25.334  1.00 27.96           C  
ATOM    929  O   ARG    74      18.098  18.113  25.095  1.00 27.54           O  
ATOM    931  N   HIS    75      16.947  16.332  25.881  1.00 28.13           N  
ATOM    932  CA  HIS    75      15.808  17.019  26.439  1.00 27.64           C  
ATOM    934  CB  HIS    75      14.667  16.007  26.623  1.00 27.64           C  
ATOM    937  CG  HIS    75      13.933  15.675  25.364  1.00 26.85           C  
ATOM    938  ND1 HIS    75      12.684  15.091  25.365  1.00 27.16           N  
ATOM    940  CE1 HIS    75      12.273  14.929  24.123  1.00 25.35           C  
ATOM    942  NE2 HIS    75      13.203  15.398  23.314  1.00 25.61           N  
ATOM    944  CD2 HIS    75      14.241  15.891  24.066  1.00 26.69           C  
ATOM    946  C   HIS    75      16.212  17.565  27.809  1.00 27.62           C  
ATOM    947  O   HIS    75      17.040  16.976  28.486  1.00 27.41           O  
ATOM    949  N   ALA    76      15.605  18.680  28.215  1.00 27.85           N  
ATOM    950  CA  ALA    76      15.914  19.361  29.477  1.00 27.68           C  
ATOM    952  CB  ALA    76      14.837  20.315  29.795  1.00 27.83           C  
ATOM    956  C   ALA    76      16.071  18.407  30.627  1.00 27.54           C  
ATOM    957  O   ALA    76      16.949  18.557  31.454  1.00 27.23           O  
ATOM    959  N   GLU    77      15.202  17.415  30.660  1.00 27.94           N  
ATOM    960  CA  GLU    77      15.174  16.423  31.759  1.00 28.19           C  
ATOM    962  CB  GLU    77      13.931  15.503  31.638  1.00 28.04           C  
ATOM    965  CG  GLU    77      12.535  16.240  31.554  1.00 28.70           C  
ATOM    968  CD  GLU    77      12.024  16.560  30.121  1.00 29.00           C  
ATOM    969  OE1 GLU    77      12.744  17.225  29.338  1.00 26.96           O  
ATOM    970  OE2 GLU    77      10.890  16.137  29.788  1.00 30.20           O  
ATOM    971  C   GLU    77      16.453  15.576  31.775  1.00 28.12           C  
ATOM    972  O   GLU    77      16.977  15.267  32.831  1.00 27.91           O  
ATOM    974  N   MET    78      16.945  15.218  30.590  1.00 28.34           N  
ATOM    975  CA  MET    78      18.162  14.405  30.454  1.00 28.57           C  
ATOM    977  CB  MET    78      18.256  13.796  29.033  1.00 28.60           C  
ATOM    980  CG  MET    78      17.083  12.903  28.658  1.00 29.43           C  
ATOM    983  SD  MET    78      17.088  11.230  29.438  1.00 32.79           S  
ATOM    984  CE  MET    78      18.680  10.560  28.910  1.00 33.89           C  
ATOM    988  C   MET    78      19.438  15.196  30.807  1.00 27.97           C  
ATOM    989  O   MET    78      20.374  14.636  31.382  1.00 27.32           O  
ATOM    991  N   VAL    79      19.449  16.485  30.467  1.00 27.87           N  
ATOM    992  CA  VAL    79      20.504  17.412  30.894  1.00 27.89           C  
ATOM    994  CB  VAL    79      20.252  18.842  30.335  1.00 27.64           C  
ATOM    996  CG1 VAL    79      21.200  19.821  30.957  1.00 26.57           C  
ATOM   1000  CG2 VAL    79      20.390  18.846  28.827  1.00 27.02           C  
ATOM   1004  C   VAL    79      20.582  17.472  32.428  1.00 28.20           C  
ATOM   1005  O   VAL    79      21.663  17.343  33.013  1.00 28.42           O  
ATOM   1007  N   ALA    80      19.422  17.663  33.060  1.00 28.46           N  
ATOM   1008  CA  ALA    80      19.292  17.726  34.514  1.00 28.47           C  
ATOM   1010  CB  ALA    80      17.846  18.000  34.891  1.00 28.80           C  
ATOM   1014  C   ALA    80      19.776  16.452  35.211  1.00 28.83           C  
ATOM   1015  O   ALA    80      20.513  16.536  36.211  1.00 28.83           O  
ATOM   1017  N   ILE    81      19.346  15.286  34.702  1.00 28.53           N  
ATOM   1018  CA  ILE    81      19.759  14.004  35.257  1.00 28.44           C  
ATOM   1020  CB  ILE    81      19.134  12.836  34.510  1.00 28.66           C  
ATOM   1022  CG1 ILE    81      17.624  12.783  34.805  1.00 28.89           C  
ATOM   1025  CD1 ILE    81      16.882  11.805  33.992  1.00 26.60           C  
ATOM   1029  CG2 ILE    81      19.789  11.514  34.943  1.00 28.72           C  
ATOM   1033  C   ILE    81      21.275  13.851  35.248  1.00 28.72           C  
ATOM   1034  O   ILE    81      21.854  13.413  36.239  1.00 29.25           O  
ATOM   1036  N   ASP    82      21.922  14.237  34.152  1.00 28.61           N  
ATOM   1037  CA  ASP    82      23.382  14.204  34.080  1.00 28.47           C  
ATOM   1039  CB  ASP    82      23.900  14.655  32.700  1.00 28.86           C  
ATOM   1042  CG  ASP    82      24.020  13.506  31.685  1.00 30.66           C  
ATOM   1043  OD1 ASP    82      23.613  12.367  32.024  1.00 33.60           O  
ATOM   1044  OD2 ASP    82      24.542  13.743  30.544  1.00 32.55           O  
ATOM   1045  C   ASP    82      23.987  15.088  35.148  1.00 28.01           C  
ATOM   1046  O   ASP    82      24.999  14.728  35.734  1.00 27.82           O  
ATOM   1048  N   GLN    83      23.379  16.253  35.385  1.00 27.76           N  
ATOM   1049  CA  GLN    83      23.868  17.178  36.416  1.00 27.64           C  
ATOM   1051  CB  GLN    83      23.170  18.538  36.279  1.00 27.69           C  
ATOM   1054  CG  GLN    83      23.871  19.468  35.291  1.00 28.50           C  
ATOM   1057  CD  GLN    83      23.481  20.925  35.456  1.00 27.64           C  
ATOM   1058  OE1 GLN    83      22.782  21.301  36.390  1.00 27.94           O  
ATOM   1059  NE2 GLN    83      23.942  21.750  34.551  1.00 27.26           N  
ATOM   1062  C   GLN    83      23.721  16.646  37.849  1.00 27.11           C  
ATOM   1063  O   GLN    83      24.612  16.790  38.666  1.00 26.25           O  
ATOM   1065  N   VAL    84      22.573  16.039  38.131  1.00 27.29           N  
ATOM   1066  CA  VAL    84      22.373  15.354  39.390  1.00 27.38           C  
ATOM   1068  CB  VAL    84      20.931  14.822  39.562  1.00 27.63           C  
ATOM   1070  CG1 VAL    84      20.775  14.175  40.919  1.00 25.95           C  
ATOM   1074  CG2 VAL    84      19.923  15.945  39.394  1.00 26.82           C  
ATOM   1078  C   VAL    84      23.395  14.241  39.566  1.00 27.17           C  
ATOM   1079  O   VAL    84      24.087  14.205  40.570  1.00 27.42           O  
ATOM   1081  N   LEU    85      23.541  13.356  38.595  1.00 27.06           N  
ATOM   1082  CA  LEU    85      24.643  12.379  38.680  1.00 27.18           C  
ATOM   1084  CB  LEU    85      24.735  11.528  37.415  1.00 26.93           C  
ATOM   1087  CG  LEU    85      23.618  10.515  37.247  1.00 26.49           C  
ATOM   1089  CD1 LEU    85      23.286  10.344  35.774  1.00 27.04           C  
ATOM   1093  CD2 LEU    85      24.014   9.242  37.875  1.00 26.00           C  
ATOM   1097  C   LEU    85      25.997  13.029  38.955  1.00 27.04           C  
ATOM   1098  O   LEU    85      26.807  12.451  39.661  1.00 27.51           O  
ATOM   1100  N   ASP    86      26.240  14.216  38.404  1.00 27.40           N  
ATOM   1101  CA  ASP    86      27.493  14.935  38.638  1.00 27.79           C  
ATOM   1103  CB  ASP    86      27.674  16.086  37.657  1.00 27.90           C  
ATOM   1106  CG  ASP    86      29.145  16.270  37.271  1.00 30.86           C  
ATOM   1107  OD1 ASP    86      29.648  15.494  36.390  1.00 32.41           O  
ATOM   1108  OD2 ASP    86      29.826  17.137  37.906  1.00 33.31           O  
ATOM   1109  C   ASP    86      27.612  15.473  40.060  1.00 27.69           C  
ATOM   1110  O   ASP    86      28.704  15.515  40.648  1.00 27.89           O  
ATOM   1112  N   TRP    87      26.479  15.887  40.606  1.00 27.68           N  
ATOM   1113  CA  TRP    87      26.393  16.362  41.971  1.00 27.52           C  
ATOM   1115  CB  TRP    87      24.996  16.944  42.217  1.00 28.11           C  
ATOM   1118  CG  TRP    87      24.854  17.634  43.516  1.00 27.84           C  
ATOM   1119  CD1 TRP    87      25.097  18.936  43.765  1.00 26.94           C  
ATOM   1121  NE1 TRP    87      24.843  19.218  45.082  1.00 27.80           N  
ATOM   1123  CE2 TRP    87      24.445  18.076  45.722  1.00 27.98           C  
ATOM   1124  CD2 TRP    87      24.432  17.048  44.756  1.00 28.61           C  
ATOM   1125  CE3 TRP    87      24.048  15.750  45.143  1.00 27.55           C  
ATOM   1127  CZ3 TRP    87      23.721  15.525  46.469  1.00 27.38           C  
ATOM   1129  CH2 TRP    87      23.747  16.579  47.415  1.00 27.96           C  
ATOM   1131  CZ2 TRP    87      24.101  17.857  47.060  1.00 27.24           C  
ATOM   1133  C   TRP    87      26.661  15.254  42.957  1.00 27.22           C  
ATOM   1134  O   TRP    87      27.279  15.469  43.985  1.00 26.82           O  
ATOM   1136  N   CYS    88      26.147  14.072  42.648  1.00 27.62           N  
ATOM   1137  CA  CYS    88      26.427  12.872  43.433  1.00 27.93           C  
ATOM   1139  CB  CYS    88      25.738  11.657  42.842  1.00 27.87           C  
ATOM   1142  SG  CYS    88      24.004  11.558  43.304  1.00 29.69           S  
ATOM   1144  C   CYS    88      27.893  12.579  43.502  1.00 27.85           C  
ATOM   1145  O   CYS    88      28.411  12.357  44.584  1.00 28.58           O  
ATOM   1147  N   ARG    89      28.569  12.568  42.360  1.00 27.85           N  
ATOM   1148  CA  ARG    89      30.000  12.313  42.366  1.00 28.33           C  
ATOM   1150  CB  ARG    89      30.613  12.676  41.043  1.00 28.62           C  
ATOM   1153  CG  ARG    89      30.413  11.652  39.984  1.00 29.96           C  
ATOM   1156  CD  ARG    89      30.720  12.311  38.629  1.00 31.97           C  
ATOM   1159  NE  ARG    89      30.164  11.544  37.504  1.00 33.93           N  
ATOM   1161  CZ  ARG    89      30.404  11.831  36.215  1.00 36.20           C  
ATOM   1162  NH1 ARG    89      31.159  12.902  35.886  1.00 37.64           N  
ATOM   1165  NH2 ARG    89      29.920  11.053  35.234  1.00 36.24           N  
ATOM   1168  C   ARG    89      30.730  13.111  43.408  1.00 28.11           C  
ATOM   1169  O   ARG    89      31.577  12.583  44.101  1.00 28.00           O  
ATOM   1171  N   GLN    90      30.383  14.386  43.506  1.00 28.42           N  
ATOM   1172  CA  GLN    90      31.132  15.339  44.301  1.00 28.75           C  
ATOM   1174  CB  GLN    90      30.990  16.703  43.661  1.00 29.03           C  
ATOM   1177  CG  GLN    90      31.457  16.706  42.217  1.00 31.17           C  
ATOM   1180  CD  GLN    90      31.094  17.981  41.521  1.00 33.04           C  
ATOM   1181  OE1 GLN    90      30.440  18.845  42.108  1.00 35.04           O  
ATOM   1182  NE2 GLN    90      31.498  18.113  40.261  1.00 34.45           N  
ATOM   1185  C   GLN    90      30.670  15.469  45.728  1.00 28.39           C  
ATOM   1186  O   GLN    90      31.383  16.039  46.538  1.00 28.51           O  
ATOM   1188  N   SER    91      29.453  15.014  46.010  1.00 28.22           N  
ATOM   1189  CA  SER    91      28.885  15.090  47.346  1.00 28.33           C  
ATOM   1191  CB  SER    91      27.379  15.315  47.267  1.00 28.48           C  
ATOM   1194  OG  SER    91      26.708  14.066  47.137  1.00 28.44           O  
ATOM   1196  C   SER    91      29.135  13.806  48.131  1.00 28.41           C  
ATOM   1197  O   SER    91      28.941  13.790  49.351  1.00 28.52           O  
ATOM   1199  N   GLY    92      29.541  12.740  47.419  1.00 28.34           N  
ATOM   1200  CA  GLY    92      29.820  11.437  48.010  1.00 28.07           C  
ATOM   1203  C   GLY    92      28.567  10.609  48.180  1.00 27.97           C  
ATOM   1204  O   GLY    92      28.632   9.480  48.609  1.00 28.33           O  
ATOM   1206  N   LYS    93      27.418  11.175  47.850  1.00 28.04           N  
ATOM   1207  CA  LYS    93      26.144  10.499  48.043  1.00 28.52           C  
ATOM   1209  CB  LYS    93      25.010  11.516  48.151  1.00 28.44           C  
ATOM   1212  CG  LYS    93      25.124  12.507  49.287  1.00 28.85           C  
ATOM   1215  CD  LYS    93      24.408  12.008  50.555  1.00 30.68           C  
ATOM   1218  CE  LYS    93      23.929  13.147  51.497  1.00 31.10           C  
ATOM   1221  NZ  LYS    93      22.573  12.817  52.143  1.00 31.15           N  
ATOM   1225  C   LYS    93      25.886   9.579  46.841  1.00 28.54           C  
ATOM   1226  O   LYS    93      26.366   9.859  45.736  1.00 28.29           O  
ATOM   1228  N   SER    94      25.122   8.501  47.058  1.00 28.28           N  
ATOM   1229  CA  SER    94      24.802   7.568  45.984  1.00 27.99           C  
ATOM   1231  CB  SER    94      24.546   6.167  46.522  1.00 27.89           C  
ATOM   1234  OG  SER    94      23.271   6.106  47.132  1.00 27.86           O  
ATOM   1236  C   SER    94      23.571   8.064  45.224  1.00 28.07           C  
ATOM   1237  O   SER    94      22.649   8.643  45.843  1.00 27.86           O  
ATOM   1239  N   PRO    95      23.548   7.840  43.893  1.00 27.49           N  
ATOM   1240  CA  PRO    95      22.436   8.176  42.998  1.00 27.79           C  
ATOM   1242  CB  PRO    95      22.818   7.481  41.703  1.00 27.72           C  
ATOM   1245  CG  PRO    95      24.264   7.455  41.751  1.00 28.05           C  
ATOM   1248  CD  PRO    95      24.646   7.219  43.154  1.00 27.05           C  
ATOM   1251  C   PRO    95      21.045   7.709  43.436  1.00 27.91           C  
ATOM   1252  O   PRO    95      20.106   8.499  43.371  1.00 28.45           O  
ATOM   1253  N   SER    96      20.917   6.457  43.869  1.00 27.75           N  
ATOM   1254  CA  SER    96      19.643   5.929  44.340  1.00 28.16           C  
ATOM   1256  CB  SER    96      19.727   4.416  44.567  1.00 28.01           C  
ATOM   1259  OG  SER    96      20.401   4.120  45.777  1.00 28.00           O  
ATOM   1261  C   SER    96      19.140   6.659  45.599  1.00 28.30           C  
ATOM   1262  O   SER    96      17.977   6.987  45.701  1.00 28.80           O  
ATOM   1264  N   GLU    97      20.029   6.959  46.524  1.00 28.77           N  
ATOM   1265  CA  GLU    97      19.701   7.734  47.728  1.00 29.19           C  
ATOM   1267  CB  GLU    97      20.960   7.760  48.608  1.00 29.43           C  
ATOM   1270  CG  GLU    97      20.840   8.453  49.966  1.00 31.88           C  
ATOM   1273  CD  GLU    97      22.211   8.495  50.747  1.00 34.19           C  
ATOM   1274  OE1 GLU    97      23.234   7.944  50.211  1.00 34.81           O  
ATOM   1275  OE2 GLU    97      22.250   9.095  51.874  1.00 32.68           O  
ATOM   1276  C   GLU    97      19.225   9.185  47.447  1.00 29.09           C  
ATOM   1277  O   GLU    97      18.528   9.788  48.293  1.00 29.59           O  
ATOM   1279  N   VAL    98      19.614   9.742  46.295  1.00 28.27           N  
ATOM   1280  CA  VAL    98      19.289  11.121  45.961  1.00 28.28           C  
ATOM   1282  CB  VAL    98      20.460  11.853  45.218  1.00 28.27           C  
ATOM   1284  CG1 VAL    98      20.109  13.282  44.899  1.00 25.94           C  
ATOM   1288  CG2 VAL    98      21.732  11.836  46.046  1.00 28.61           C  
ATOM   1292  C   VAL    98      18.069  11.175  45.066  1.00 28.91           C  
ATOM   1293  O   VAL    98      17.096  11.881  45.374  1.00 28.91           O  
ATOM   1295  N   PHE    99      18.133  10.470  43.930  1.00 29.30           N  
ATOM   1296  CA  PHE    99      17.022  10.466  42.968  1.00 29.02           C  
ATOM   1298  CB  PHE    99      17.314   9.595  41.740  1.00 29.08           C  
ATOM   1301  CG  PHE    99      18.191  10.271  40.744  1.00 30.28           C  
ATOM   1302  CD1 PHE    99      19.564  10.018  40.707  1.00 30.48           C  
ATOM   1304  CE1 PHE    99      20.391  10.672  39.812  1.00 29.96           C  
ATOM   1306  CZ  PHE    99      19.873  11.616  38.953  1.00 30.17           C  
ATOM   1308  CE2 PHE    99      18.508  11.904  38.982  1.00 31.27           C  
ATOM   1310  CD2 PHE    99      17.666  11.222  39.877  1.00 31.63           C  
ATOM   1312  C   PHE    99      15.737  10.011  43.618  1.00 28.89           C  
ATOM   1313  O   PHE    99      14.682  10.551  43.305  1.00 29.69           O  
ATOM   1315  N   GLU   100      15.802   9.025  44.514  1.00 28.16           N  
ATOM   1316  CA  GLU   100      14.578   8.558  45.168  1.00 27.97           C  
ATOM   1318  CB  GLU   100      14.825   7.247  45.899  1.00 27.44           C  
ATOM   1321  CG  GLU   100      15.086   6.145  44.939  1.00 28.81           C  
ATOM   1324  CD  GLU   100      15.433   4.827  45.602  1.00 31.25           C  
ATOM   1325  OE1 GLU   100      14.999   4.604  46.757  1.00 33.41           O  
ATOM   1326  OE2 GLU   100      16.147   4.005  44.961  1.00 32.63           O  
ATOM   1327  C   GLU   100      13.901   9.589  46.090  1.00 27.67           C  
ATOM   1328  O   GLU   100      12.803   9.337  46.580  1.00 27.67           O  
ATOM   1330  N   HIS   101      14.549  10.734  46.319  1.00 27.43           N  
ATOM   1331  CA  HIS   101      13.984  11.809  47.136  1.00 27.25           C  
ATOM   1333  CB  HIS   101      14.693  11.846  48.490  1.00 27.64           C  
ATOM   1336  CG  HIS   101      14.600  10.559  49.241  1.00 28.63           C  
ATOM   1337  ND1 HIS   101      15.589   9.592  49.190  1.00 29.98           N  
ATOM   1339  CE1 HIS   101      15.213   8.550  49.910  1.00 29.66           C  
ATOM   1341  NE2 HIS   101      14.023   8.807  50.425  1.00 29.55           N  
ATOM   1343  CD2 HIS   101      13.611  10.050  50.010  1.00 28.37           C  
ATOM   1345  C   HIS   101      14.093  13.162  46.463  1.00 26.91           C  
ATOM   1346  O   HIS   101      14.090  14.165  47.121  1.00 26.37           O  
ATOM   1348  N   THR   102      14.172  13.155  45.136  1.00 27.88           N  
ATOM   1349  CA  THR   102      14.323  14.343  44.296  1.00 28.28           C  
ATOM   1351  CB  THR   102      15.376  14.090  43.179  1.00 28.77           C  
ATOM   1353  OG1 THR   102      16.620  13.677  43.769  1.00 29.37           O  
ATOM   1355  CG2 THR   102      15.602  15.338  42.319  1.00 28.67           C  
ATOM   1359  C   THR   102      12.981  14.701  43.643  1.00 28.52           C  
ATOM   1360  O   THR   102      12.303  13.824  43.089  1.00 29.15           O  
ATOM   1362  N   VAL   103      12.571  15.975  43.723  1.00 28.29           N  
ATOM   1363  CA  VAL   103      11.375  16.424  43.007  1.00 27.89           C  
ATOM   1365  CB  VAL   103      10.499  17.411  43.792  1.00 27.37           C  
ATOM   1367  CG1 VAL   103       9.458  17.967  42.885  1.00 27.07           C  
ATOM   1371  CG2 VAL   103       9.842  16.749  44.935  1.00 26.32           C  
ATOM   1375  C   VAL   103      11.855  17.124  41.762  1.00 28.32           C  
ATOM   1376  O   VAL   103      12.766  17.953  41.840  1.00 27.99           O  
ATOM   1378  N   LEU   104      11.241  16.769  40.627  1.00 28.66           N  
ATOM   1379  CA  LEU   104      11.499  17.407  39.326  1.00 28.73           C  
ATOM   1381  CB  LEU   104      11.432  16.357  38.204  1.00 28.51           C  
ATOM   1384  CG  LEU   104      11.478  16.890  36.764  1.00 29.73           C  
ATOM   1386  CD1 LEU   104      12.826  17.591  36.418  1.00 30.68           C  
ATOM   1390  CD2 LEU   104      11.197  15.768  35.748  1.00 29.46           C  
ATOM   1394  C   LEU   104      10.469  18.508  39.084  1.00 28.35           C  
ATOM   1395  O   LEU   104       9.279  18.299  39.308  1.00 28.58           O  
ATOM   1397  N   TYR   105      10.935  19.672  38.635  1.00 28.26           N  
ATOM   1398  CA  TYR   105      10.055  20.816  38.292  1.00 28.44           C  
ATOM   1400  CB  TYR   105      10.335  22.040  39.206  1.00 28.13           C  
ATOM   1403  CG  TYR   105      10.205  21.756  40.702  1.00 27.64           C  
ATOM   1404  CD1 TYR   105      11.284  21.202  41.410  1.00 28.21           C  
ATOM   1406  CE1 TYR   105      11.188  20.907  42.749  1.00 27.85           C  
ATOM   1408  CZ  TYR   105      10.000  21.179  43.415  1.00 28.16           C  
ATOM   1409  OH  TYR   105       9.935  20.866  44.768  1.00 26.64           O  
ATOM   1411  CE2 TYR   105       8.925  21.757  42.726  1.00 25.52           C  
ATOM   1413  CD2 TYR   105       9.032  22.035  41.395  1.00 24.48           C  
ATOM   1415  C   TYR   105      10.264  21.171  36.797  1.00 28.60           C  
ATOM   1416  O   TYR   105      11.342  21.633  36.439  1.00 28.75           O  
ATOM   1418  N   VAL   106       9.255  20.945  35.942  1.00 28.20           N  
ATOM   1419  CA  VAL   106       9.399  21.109  34.476  1.00 28.13           C  
ATOM   1421  CB  VAL   106       9.437  19.736  33.731  1.00 27.97           C  
ATOM   1423  CG1 VAL   106      10.590  18.978  34.171  1.00 29.41           C  
ATOM   1427  CG2 VAL   106       8.201  18.935  34.004  1.00 26.97           C  
ATOM   1431  C   VAL   106       8.304  21.933  33.793  1.00 27.78           C  
ATOM   1432  O   VAL   106       7.135  21.879  34.152  1.00 27.98           O  
ATOM   1434  N   THR   107       8.698  22.640  32.750  1.00 27.47           N  
ATOM   1435  CA  THR   107       7.797  23.502  31.995  1.00 27.60           C  
ATOM   1437  CB  THR   107       8.624  24.430  31.114  1.00 27.08           C  
ATOM   1439  OG1 THR   107       9.242  25.406  31.949  1.00 26.99           O  
ATOM   1441  CG2 THR   107       7.752  25.104  30.113  1.00 28.88           C  
ATOM   1445  C   THR   107       6.738  22.762  31.142  1.00 27.29           C  
ATOM   1446  O   THR   107       5.602  23.217  31.046  1.00 27.48           O  
ATOM   1448  N   VAL   108       7.124  21.648  30.524  1.00 26.89           N  
ATOM   1449  CA  VAL   108       6.228  20.847  29.718  1.00 26.46           C  
ATOM   1451  CB  VAL   108       6.701  20.787  28.284  1.00 26.45           C  
ATOM   1453  CG1 VAL   108       5.756  19.953  27.480  1.00 25.92           C  
ATOM   1457  CG2 VAL   108       6.837  22.205  27.700  1.00 26.36           C  
ATOM   1461  C   VAL   108       6.186  19.431  30.231  1.00 26.51           C  
ATOM   1462  O   VAL   108       7.157  18.899  30.725  1.00 26.61           O  
ATOM   1464  N   GLU   109       5.033  18.814  30.117  1.00 27.18           N  
ATOM   1465  CA  GLU   109       4.876  17.390  30.411  1.00 27.29           C  
ATOM   1467  CB  GLU   109       3.488  16.904  29.932  1.00 27.24           C  
ATOM   1470  CG  GLU   109       3.138  15.447  30.308  1.00 28.49           C  
ATOM   1473  CD  GLU   109       1.889  14.937  29.589  1.00 29.27           C  
ATOM   1474  OE1 GLU   109       1.109  15.760  29.061  1.00 29.40           O  
ATOM   1475  OE2 GLU   109       1.691  13.706  29.528  1.00 30.07           O  
ATOM   1476  C   GLU   109       6.009  16.560  29.782  1.00 26.50           C  
ATOM   1477  O   GLU   109       6.244  16.634  28.607  1.00 25.85           O  
ATOM   1479  N   PRO   110       6.734  15.790  30.590  1.00 27.08           N  
ATOM   1480  CA  PRO   110       7.729  14.855  30.045  1.00 27.45           C  
ATOM   1482  CB  PRO   110       8.119  14.018  31.256  1.00 27.41           C  
ATOM   1485  CG  PRO   110       7.870  14.919  32.414  1.00 27.40           C  
ATOM   1488  CD  PRO   110       6.709  15.769  32.066  1.00 27.08           C  
ATOM   1491  C   PRO   110       7.213  13.943  28.942  1.00 27.32           C  
ATOM   1492  O   PRO   110       6.112  13.439  29.046  1.00 26.89           O  
ATOM   1493  N   CYS   111       8.019  13.764  27.895  1.00 27.48           N  
ATOM   1494  CA  CYS   111       7.673  12.895  26.779  1.00 27.20           C  
ATOM   1496  CB  CYS   111       8.596  13.159  25.591  1.00 27.18           C  
ATOM   1499  SG  CYS   111      10.319  12.549  25.762  1.00 26.81           S  
ATOM   1501  C   CYS   111       7.773  11.433  27.179  1.00 27.55           C  
ATOM   1502  O   CYS   111       8.200  11.098  28.282  1.00 27.24           O  
ATOM   1504  N   ILE   112       7.393  10.555  26.260  1.00 27.67           N  
ATOM   1505  CA  ILE   112       7.456   9.134  26.532  1.00 27.66           C  
ATOM   1507  CB  ILE   112       6.865   8.310  25.370  1.00 27.71           C  
ATOM   1509  CG1 ILE   112       5.338   8.440  25.369  1.00 28.05           C  
ATOM   1512  CD1 ILE   112       4.648   7.765  24.177  1.00 28.17           C  
ATOM   1516  CG2 ILE   112       7.261   6.828  25.471  1.00 27.28           C  
ATOM   1520  C   ILE   112       8.872   8.692  26.886  1.00 27.75           C  
ATOM   1521  O   ILE   112       9.050   7.898  27.810  1.00 27.52           O  
ATOM   1523  N   MET   113       9.878   9.206  26.168  1.00 28.00           N  
ATOM   1524  CA  MET   113      11.286   8.865  26.477  1.00 27.71           C  
ATOM   1526  CB  MET   113      12.224   9.558  25.518  1.00 27.36           C  
ATOM   1529  CG  MET   113      13.630   9.038  25.611  1.00 27.66           C  
ATOM   1532  SD  MET   113      14.781  10.217  24.914  1.00 29.59           S  
ATOM   1533  CE  MET   113      15.865  10.464  26.347  1.00 31.93           C  
ATOM   1537  C   MET   113      11.695   9.263  27.906  1.00 27.74           C  
ATOM   1538  O   MET   113      12.210   8.430  28.653  1.00 27.33           O  
ATOM   1540  N   CYS   114      11.461  10.527  28.255  1.00 27.33           N  
ATOM   1541  CA  CYS   114      11.773  11.050  29.574  1.00 27.96           C  
ATOM   1543  CB  CYS   114      11.535  12.562  29.593  1.00 28.16           C  
ATOM   1546  SG  CYS   114      12.745  13.454  28.634  1.00 29.88           S  
ATOM   1548  C   CYS   114      10.984  10.409  30.733  1.00 27.83           C  
ATOM   1549  O   CYS   114      11.560  10.008  31.741  1.00 27.85           O  
ATOM   1551  N   ALA   115       9.675  10.312  30.597  1.00 27.62           N  
ATOM   1552  CA  ALA   115       8.891   9.588  31.569  1.00 27.76           C  
ATOM   1554  CB  ALA   115       7.432   9.558  31.146  1.00 27.42           C  
ATOM   1558  C   ALA   115       9.442   8.163  31.819  1.00 28.27           C  
ATOM   1559  O   ALA   115       9.599   7.752  32.985  1.00 29.59           O  
ATOM   1561  N   ALA   116       9.771   7.412  30.769  1.00 28.12           N  
ATOM   1562  CA  ALA   116      10.385   6.078  30.963  1.00 28.33           C  
ATOM   1564  CB  ALA   116      10.653   5.371  29.619  1.00 27.77           C  
ATOM   1568  C   ALA   116      11.675   6.194  31.785  1.00 28.62           C  
ATOM   1569  O   ALA   116      11.941   5.377  32.671  1.00 29.32           O  
ATOM   1571  N   ALA   117      12.463   7.229  31.508  1.00 28.78           N  
ATOM   1572  CA  ALA   117      13.700   7.484  32.246  1.00 28.73           C  
ATOM   1574  CB  ALA   117      14.421   8.676  31.653  1.00 28.83           C  
ATOM   1578  C   ALA   117      13.441   7.743  33.724  1.00 28.85           C  
ATOM   1579  O   ALA   117      14.094   7.176  34.577  1.00 28.67           O  
ATOM   1581  N   LEU   118      12.477   8.620  34.005  1.00 29.20           N  
ATOM   1582  CA  LEU   118      12.155   9.023  35.360  1.00 28.43           C  
ATOM   1584  CB  LEU   118      11.127  10.154  35.347  1.00 27.97           C  
ATOM   1587  CG  LEU   118      11.692  11.452  34.772  1.00 27.63           C  
ATOM   1589  CD1 LEU   118      10.735  12.603  34.919  1.00 28.37           C  
ATOM   1593  CD2 LEU   118      12.963  11.797  35.439  1.00 28.09           C  
ATOM   1597  C   LEU   118      11.669   7.840  36.159  1.00 28.28           C  
ATOM   1598  O   LEU   118      12.014   7.730  37.331  1.00 28.30           O  
ATOM   1600  N   ARG   119      10.895   6.949  35.534  1.00 28.26           N  
ATOM   1601  CA  ARG   119      10.579   5.659  36.179  1.00 28.76           C  
ATOM   1603  CB  ARG   119       9.775   4.752  35.252  1.00 29.30           C  
ATOM   1606  CG  ARG   119       8.261   4.867  35.387  1.00 29.05           C  
ATOM   1609  CD  ARG   119       7.630   3.767  34.611  1.00 29.20           C  
ATOM   1612  NE  ARG   119       7.435   2.550  35.388  1.00 29.29           N  
ATOM   1614  CZ  ARG   119       6.316   2.241  36.052  1.00 30.71           C  
ATOM   1615  NH1 ARG   119       5.280   3.079  36.090  1.00 31.34           N  
ATOM   1618  NH2 ARG   119       6.229   1.086  36.713  1.00 31.28           N  
ATOM   1621  C   ARG   119      11.826   4.865  36.565  1.00 28.71           C  
ATOM   1622  O   ARG   119      11.942   4.355  37.683  1.00 28.42           O  
ATOM   1624  N   LEU   120      12.738   4.738  35.608  1.00 28.29           N  
ATOM   1625  CA  LEU   120      13.955   3.987  35.836  1.00 28.40           C  
ATOM   1627  CB  LEU   120      14.671   3.762  34.510  1.00 27.90           C  
ATOM   1630  CG  LEU   120      13.979   2.793  33.547  1.00 26.59           C  
ATOM   1632  CD1 LEU   120      14.630   2.885  32.201  1.00 25.10           C  
ATOM   1636  CD2 LEU   120      13.984   1.375  34.042  1.00 24.24           C  
ATOM   1640  C   LEU   120      14.896   4.605  36.898  1.00 28.81           C  
ATOM   1641  O   LEU   120      15.541   3.860  37.658  1.00 29.54           O  
ATOM   1643  N   MET   121      14.978   5.941  36.943  1.00 28.87           N  
ATOM   1644  CA  MET   121      15.712   6.673  37.985  1.00 28.40           C  
ATOM   1646  CB  MET   121      15.922   8.132  37.588  1.00 28.32           C  
ATOM   1649  CG  MET   121      16.793   8.350  36.362  1.00 29.39           C  
ATOM   1652  SD  MET   121      18.368   7.437  36.341  1.00 31.52           S  
ATOM   1653  CE  MET   121      19.455   8.674  37.112  1.00 32.17           C  
ATOM   1657  C   MET   121      14.968   6.697  39.316  1.00 28.60           C  
ATOM   1658  O   MET   121      15.578   6.990  40.327  1.00 28.98           O  
ATOM   1660  N   LYS   122      13.654   6.446  39.301  1.00 28.57           N  
ATOM   1661  CA  LYS   122      12.791   6.393  40.496  1.00 27.97           C  
ATOM   1663  CB  LYS   122      13.311   5.396  41.523  1.00 27.70           C  
ATOM   1666  CG  LYS   122      13.463   4.024  41.001  1.00 27.70           C  
ATOM   1669  CD  LYS   122      13.797   3.117  42.133  1.00 28.38           C  
ATOM   1672  CE  LYS   122      13.990   1.713  41.622  1.00 28.97           C  
ATOM   1675  NZ  LYS   122      14.226   0.736  42.706  1.00 29.76           N  
ATOM   1679  C   LYS   122      12.590   7.725  41.178  1.00 28.20           C  
ATOM   1680  O   LYS   122      12.469   7.773  42.412  1.00 28.06           O  
ATOM   1682  N   ILE   123      12.586   8.805  40.394  1.00 27.95           N  
ATOM   1683  CA  ILE   123      12.130  10.084  40.892  1.00 27.99           C  
ATOM   1685  CB  ILE   123      12.231  11.205  39.833  1.00 28.47           C  
ATOM   1687  CG1 ILE   123      13.668  11.737  39.725  1.00 30.17           C  
ATOM   1690  CD1 ILE   123      14.537  11.101  38.597  1.00 31.52           C  
ATOM   1694  CG2 ILE   123      11.368  12.380  40.218  1.00 27.61           C  
ATOM   1698  C   ILE   123      10.659   9.867  41.267  1.00 27.89           C  
ATOM   1699  O   ILE   123       9.901   9.331  40.452  1.00 27.80           O  
ATOM   1701  N   PRO   124      10.268  10.206  42.521  1.00 27.53           N  
ATOM   1702  CA  PRO   124       8.908  10.069  43.039  1.00 27.20           C  
ATOM   1704  CB  PRO   124       9.133  10.061  44.535  1.00 27.06           C  
ATOM   1707  CG  PRO   124      10.268  10.856  44.751  1.00 27.33           C  
ATOM   1710  CD  PRO   124      11.177  10.670  43.583  1.00 27.38           C  
ATOM   1713  C   PRO   124       7.871  11.158  42.702  1.00 27.45           C  
ATOM   1714  O   PRO   124       6.685  10.838  42.712  1.00 27.46           O  
ATOM   1715  N   LEU   125       8.290  12.403  42.420  1.00 27.23           N  
ATOM   1716  CA  LEU   125       7.342  13.475  42.135  1.00 27.35           C  
ATOM   1718  CB  LEU   125       7.072  14.273  43.410  1.00 27.50           C  
ATOM   1721  CG  LEU   125       6.170  15.505  43.456  1.00 26.55           C  
ATOM   1723  CD1 LEU   125       4.804  15.257  42.848  1.00 27.47           C  
ATOM   1727  CD2 LEU   125       6.038  15.903  44.891  1.00 25.10           C  
ATOM   1731  C   LEU   125       7.805  14.419  41.029  1.00 28.05           C  
ATOM   1732  O   LEU   125       8.891  14.992  41.124  1.00 28.35           O  
ATOM   1734  N   VAL   126       6.962  14.578  39.993  1.00 28.17           N  
ATOM   1735  CA  VAL   126       7.152  15.557  38.936  1.00 27.98           C  
ATOM   1737  CB  VAL   126       7.033  14.889  37.547  1.00 28.31           C  
ATOM   1739  CG1 VAL   126       7.189  15.937  36.449  1.00 28.62           C  
ATOM   1743  CG2 VAL   126       8.075  13.764  37.376  1.00 28.63           C  
ATOM   1747  C   VAL   126       6.066  16.632  39.064  1.00 27.89           C  
ATOM   1748  O   VAL   126       4.885  16.314  39.154  1.00 27.83           O  
ATOM   1750  N   VAL   127       6.461  17.897  39.084  1.00 27.59           N  
ATOM   1751  CA  VAL   127       5.498  18.987  39.043  1.00 27.75           C  
ATOM   1753  CB  VAL   127       5.719  20.057  40.161  1.00 28.05           C  
ATOM   1755  CG1 VAL   127       5.015  21.381  39.854  1.00 27.26           C  
ATOM   1759  CG2 VAL   127       5.246  19.535  41.514  1.00 28.36           C  
ATOM   1763  C   VAL   127       5.737  19.598  37.704  1.00 27.95           C  
ATOM   1764  O   VAL   127       6.864  19.972  37.389  1.00 27.12           O  
ATOM   1766  N   TYR   128       4.680  19.692  36.900  1.00 28.52           N  
ATOM   1767  CA  TYR   128       4.822  20.268  35.566  1.00 28.45           C  
ATOM   1769  CB  TYR   128       5.025  19.162  34.533  1.00 28.06           C  
ATOM   1772  CG  TYR   128       3.818  18.402  34.078  1.00 28.34           C  
ATOM   1773  CD1 TYR   128       3.626  17.059  34.437  1.00 29.46           C  
ATOM   1775  CE1 TYR   128       2.514  16.329  33.958  1.00 28.31           C  
ATOM   1777  CZ  TYR   128       1.612  16.958  33.113  1.00 29.12           C  
ATOM   1778  OH  TYR   128       0.500  16.310  32.604  1.00 28.84           O  
ATOM   1780  CE2 TYR   128       1.816  18.275  32.740  1.00 29.55           C  
ATOM   1782  CD2 TYR   128       2.914  18.975  33.204  1.00 28.51           C  
ATOM   1784  C   TYR   128       3.757  21.297  35.151  1.00 28.39           C  
ATOM   1785  O   TYR   128       2.754  21.529  35.860  1.00 28.91           O  
ATOM   1787  N   GLY   129       4.029  21.932  34.015  1.00 27.67           N  
ATOM   1788  CA  GLY   129       3.199  22.991  33.493  1.00 27.87           C  
ATOM   1791  C   GLY   129       2.120  22.551  32.535  1.00 27.68           C  
ATOM   1792  O   GLY   129       1.142  21.973  32.960  1.00 28.21           O  
ATOM   1794  N   CYS   130       2.275  22.855  31.252  1.00 27.34           N  
ATOM   1795  CA  CYS   130       1.279  22.499  30.266  1.00 27.89           C  
ATOM   1797  CB  CYS   130       1.342  23.480  29.107  1.00 27.89           C  
ATOM   1800  SG  CYS   130       2.914  23.319  28.162  1.00 30.29           S  
ATOM   1802  C   CYS   130       1.470  21.072  29.724  1.00 27.56           C  
ATOM   1803  O   CYS   130       2.489  20.438  29.937  1.00 26.76           O  
ATOM   1805  N   GLN   131       0.471  20.610  28.984  1.00 27.70           N  
ATOM   1806  CA  GLN   131       0.459  19.278  28.412  1.00 27.98           C  
ATOM   1808  CB  GLN   131      -0.950  18.922  27.932  1.00 28.47           C  
ATOM   1811  CG  GLN   131      -2.080  18.913  29.037  1.00 29.70           C  
ATOM   1814  CD  GLN   131      -1.959  17.735  30.027  1.00 31.77           C  
ATOM   1815  OE1 GLN   131      -1.739  16.574  29.619  1.00 33.82           O  
ATOM   1816  NE2 GLN   131      -2.093  18.027  31.327  1.00 31.60           N  
ATOM   1819  C   GLN   131       1.429  19.146  27.243  1.00 27.96           C  
ATOM   1820  O   GLN   131       1.803  20.137  26.635  1.00 27.61           O  
ATOM   1822  N   ASN   132       1.838  17.908  26.957  1.00 27.61           N  
ATOM   1823  CA  ASN   132       2.626  17.589  25.790  1.00 27.44           C  
ATOM   1825  CB  ASN   132       3.852  16.823  26.237  1.00 27.50           C  
ATOM   1828  CG  ASN   132       4.790  16.477  25.105  1.00 27.17           C  
ATOM   1829  OD1 ASN   132       4.451  16.645  23.947  1.00 28.04           O  
ATOM   1830  ND2 ASN   132       5.969  15.974  25.440  1.00 26.21           N  
ATOM   1833  C   ASN   132       1.780  16.782  24.793  1.00 27.56           C  
ATOM   1834  O   ASN   132       1.796  15.567  24.792  1.00 27.93           O  
ATOM   1836  N   GLU   133       1.042  17.475  23.940  1.00 27.82           N  
ATOM   1837  CA  GLU   133       0.081  16.823  23.046  1.00 28.46           C  
ATOM   1839  CB  GLU   133      -0.771  17.863  22.301  1.00 28.66           C  
ATOM   1842  CG  GLU   133      -2.060  18.259  23.041  1.00 30.06           C  
ATOM   1845  CD  GLU   133      -2.933  19.217  22.235  1.00 31.68           C  
ATOM   1846  OE1 GLU   133      -3.256  18.917  21.055  1.00 31.78           O  
ATOM   1847  OE2 GLU   133      -3.298  20.278  22.791  1.00 33.58           O  
ATOM   1848  C   GLU   133       0.692  15.860  22.029  1.00 28.35           C  
ATOM   1849  O   GLU   133       0.094  14.830  21.710  1.00 28.39           O  
ATOM   1851  N   ARG   134       1.869  16.202  21.523  1.00 28.25           N  
ATOM   1852  CA  ARG   134       2.561  15.377  20.550  1.00 28.21           C  
ATOM   1854  CB  ARG   134       3.683  16.166  19.899  1.00 28.39           C  
ATOM   1857  CG  ARG   134       3.264  17.431  19.221  1.00 28.78           C  
ATOM   1860  CD  ARG   134       4.465  18.125  18.644  1.00 29.15           C  
ATOM   1863  NE  ARG   134       4.091  19.255  17.801  1.00 29.84           N  
ATOM   1865  CZ  ARG   134       4.910  19.864  16.935  1.00 31.27           C  
ATOM   1866  NH1 ARG   134       6.177  19.461  16.778  1.00 31.15           N  
ATOM   1869  NH2 ARG   134       4.464  20.902  16.221  1.00 32.11           N  
ATOM   1872  C   ARG   134       3.178  14.108  21.162  1.00 28.31           C  
ATOM   1873  O   ARG   134       3.053  13.042  20.586  1.00 28.43           O  
ATOM   1875  N   PHE   135       3.865  14.216  22.302  1.00 28.31           N  
ATOM   1876  CA  PHE   135       4.589  13.063  22.841  1.00 28.53           C  
ATOM   1878  CB  PHE   135       6.034  13.163  22.343  1.00 28.53           C  
ATOM   1881  CG  PHE   135       6.732  11.841  22.165  1.00 28.29           C  
ATOM   1882  CD1 PHE   135       6.029  10.670  21.855  1.00 28.13           C  
ATOM   1884  CE1 PHE   135       6.692   9.435  21.694  1.00 28.35           C  
ATOM   1886  CZ  PHE   135       8.063   9.366  21.827  1.00 28.92           C  
ATOM   1888  CE2 PHE   135       8.788  10.545  22.126  1.00 30.44           C  
ATOM   1890  CD2 PHE   135       8.112  11.776  22.288  1.00 28.94           C  
ATOM   1892  C   PHE   135       4.521  12.863  24.376  1.00 28.82           C  
ATOM   1893  O   PHE   135       5.346  12.140  24.953  1.00 29.17           O  
ATOM   1895  N   GLY   136       3.510  13.446  25.019  1.00 28.58           N  
ATOM   1896  CA  GLY   136       3.332  13.292  26.455  1.00 29.12           C  
ATOM   1899  C   GLY   136       3.279  11.832  26.957  1.00 29.71           C  
ATOM   1900  O   GLY   136       2.548  10.985  26.410  1.00 29.56           O  
ATOM   1902  N   GLY   137       4.055  11.555  28.013  1.00 29.77           N  
ATOM   1903  CA  GLY   137       4.027  10.275  28.740  1.00 29.90           C  
ATOM   1906  C   GLY   137       3.441  10.285  30.168  1.00 29.93           C  
ATOM   1907  O   GLY   137       3.670   9.350  30.965  1.00 30.73           O  
ATOM   1909  N   CYS   138       2.667  11.308  30.498  1.00 29.42           N  
ATOM   1910  CA  CYS   138       2.001  11.353  31.793  1.00 29.62           C  
ATOM   1912  CB  CYS   138       2.460  12.576  32.587  1.00 29.79           C  
ATOM   1915  SG  CYS   138       4.218  12.576  32.898  1.00 30.23           S  
ATOM   1917  C   CYS   138       0.490  11.355  31.686  1.00 29.17           C  
ATOM   1918  O   CYS   138      -0.197  11.656  32.652  1.00 28.48           O  
ATOM   1920  N   GLY   139      -0.019  11.016  30.511  1.00 29.34           N  
ATOM   1921  CA  GLY   139      -1.452  11.056  30.270  1.00 29.45           C  
ATOM   1924  C   GLY   139      -1.880  11.464  28.872  1.00 29.50           C  
ATOM   1925  O   GLY   139      -2.898  10.977  28.401  1.00 30.03           O  
ATOM   1927  N   SER   140      -1.121  12.330  28.190  1.00 29.38           N  
ATOM   1928  CA  SER   140      -1.573  12.879  26.892  1.00 28.69           C  
ATOM   1930  CB  SER   140      -0.698  14.057  26.466  1.00 28.93           C  
ATOM   1933  OG  SER   140      -0.859  15.151  27.372  1.00 29.34           O  
ATOM   1935  C   SER   140      -1.596  11.834  25.803  1.00 28.12           C  
ATOM   1936  O   SER   140      -2.623  11.555  25.238  1.00 27.68           O  
ATOM   1938  N   VAL   141      -0.454  11.256  25.506  1.00 28.02           N  
ATOM   1939  CA  VAL   141      -0.395  10.196  24.522  1.00 27.98           C  
ATOM   1941  CB  VAL   141       0.827  10.374  23.645  1.00 27.84           C  
ATOM   1943  CG1 VAL   141       0.846   9.345  22.553  1.00 27.05           C  
ATOM   1947  CG2 VAL   141       0.852  11.775  23.089  1.00 27.21           C  
ATOM   1951  C   VAL   141      -0.345   8.820  25.204  1.00 28.40           C  
ATOM   1952  O   VAL   141      -0.958   7.871  24.753  1.00 28.56           O  
ATOM   1954  N   LEU   142       0.434   8.716  26.266  1.00 28.60           N  
ATOM   1955  CA  LEU   142       0.486   7.511  27.059  1.00 28.88           C  
ATOM   1957  CB  LEU   142       1.655   6.641  26.609  1.00 29.36           C  
ATOM   1960  CG  LEU   142       1.363   5.515  25.614  1.00 29.50           C  
ATOM   1962  CD1 LEU   142       2.672   5.036  24.980  1.00 29.36           C  
ATOM   1966  CD2 LEU   142       0.667   4.390  26.351  1.00 28.79           C  
ATOM   1970  C   LEU   142       0.688   7.927  28.500  1.00 29.16           C  
ATOM   1971  O   LEU   142       1.134   9.040  28.782  1.00 29.17           O  
ATOM   1973  N   ASN   143       0.385   7.034  29.430  1.00 29.52           N  
ATOM   1974  CA  ASN   143       0.660   7.355  30.830  1.00 29.66           C  
ATOM   1976  CB  ASN   143      -0.628   7.395  31.629  1.00 29.61           C  
ATOM   1979  CG  ASN   143      -0.449   8.019  33.008  1.00 30.12           C  
ATOM   1980  OD1 ASN   143       0.647   8.046  33.602  1.00 27.75           O  
ATOM   1981  ND2 ASN   143      -1.567   8.488  33.549  1.00 31.84           N  
ATOM   1984  C   ASN   143       1.656   6.390  31.451  1.00 29.47           C  
ATOM   1985  O   ASN   143       1.281   5.505  32.230  1.00 28.77           O  
ATOM   1987  N   ILE   144       2.927   6.598  31.096  1.00 29.28           N  
ATOM   1988  CA  ILE   144       4.015   5.785  31.617  1.00 29.57           C  
ATOM   1990  CB  ILE   144       5.319   6.097  30.858  1.00 30.11           C  
ATOM   1992  CG1 ILE   144       5.167   5.738  29.372  1.00 31.30           C  
ATOM   1995  CD1 ILE   144       4.789   4.257  29.149  1.00 30.50           C  
ATOM   1999  CG2 ILE   144       6.510   5.303  31.422  1.00 30.18           C  
ATOM   2003  C   ILE   144       4.215   6.059  33.113  1.00 29.39           C  
ATOM   2004  O   ILE   144       4.545   5.141  33.866  1.00 28.54           O  
ATOM   2006  N   ALA   145       4.002   7.321  33.525  1.00 29.02           N  
ATOM   2007  CA  ALA   145       4.144   7.720  34.926  1.00 28.89           C  
ATOM   2009  CB  ALA   145       3.712   9.214  35.134  1.00 28.28           C  
ATOM   2013  C   ALA   145       3.364   6.780  35.871  1.00 29.09           C  
ATOM   2014  O   ALA   145       3.871   6.429  36.949  1.00 30.20           O  
ATOM   2016  N   SER   146       2.152   6.351  35.482  1.00 28.63           N  
ATOM   2017  CA  SER   146       1.299   5.589  36.399  1.00 28.27           C  
ATOM   2019  CB  SER   146      -0.022   6.323  36.579  1.00 28.33           C  
ATOM   2022  OG  SER   146      -0.803   6.270  35.407  1.00 28.49           O  
ATOM   2024  C   SER   146       1.055   4.147  35.959  1.00 27.91           C  
ATOM   2025  O   SER   146       0.192   3.468  36.474  1.00 27.20           O  
ATOM   2027  N   ALA   147       1.844   3.685  35.009  1.00 28.29           N  
ATOM   2028  CA  ALA   147       1.650   2.368  34.418  1.00 28.30           C  
ATOM   2030  CB  ALA   147       2.500   2.220  33.141  1.00 28.16           C  
ATOM   2034  C   ALA   147       2.008   1.281  35.414  1.00 28.18           C  
ATOM   2035  O   ALA   147       3.001   1.382  36.137  1.00 27.83           O  
ATOM   2037  N   ASP   148       1.178   0.248  35.441  1.00 28.60           N  
ATOM   2038  CA  ASP   148       1.422  -0.958  36.235  1.00 29.01           C  
ATOM   2040  CB  ASP   148       0.116  -1.758  36.344  1.00 29.22           C  
ATOM   2043  CG  ASP   148       0.271  -3.024  37.194  1.00 30.33           C  
ATOM   2044  OD1 ASP   148       1.223  -3.009  38.017  1.00 32.80           O  
ATOM   2045  OD2 ASP   148      -0.548  -4.005  37.063  1.00 28.99           O  
ATOM   2046  C   ASP   148       2.529  -1.831  35.603  1.00 28.97           C  
ATOM   2047  O   ASP   148       2.258  -2.648  34.732  1.00 29.13           O  
ATOM   2049  N   LEU   149       3.769  -1.644  36.037  1.00 28.92           N  
ATOM   2050  CA  LEU   149       4.910  -2.289  35.410  1.00 28.99           C  
ATOM   2052  CB  LEU   149       5.672  -1.312  34.501  1.00 28.85           C  
ATOM   2055  CG  LEU   149       4.909  -0.925  33.221  1.00 29.26           C  
ATOM   2057  CD1 LEU   149       5.552   0.303  32.539  1.00 28.15           C  
ATOM   2061  CD2 LEU   149       4.777  -2.100  32.253  1.00 27.32           C  
ATOM   2065  C   LEU   149       5.774  -2.797  36.547  1.00 29.23           C  
ATOM   2066  O   LEU   149       6.621  -2.072  37.076  1.00 29.09           O  
ATOM   2068  N   PRO   150       5.560  -4.060  36.923  1.00 29.54           N  
ATOM   2069  CA  PRO   150       6.060  -4.553  38.210  1.00 29.67           C  
ATOM   2071  CB  PRO   150       5.659  -6.054  38.214  1.00 29.48           C  
ATOM   2074  CG  PRO   150       4.613  -6.214  37.167  1.00 29.39           C  
ATOM   2077  CD  PRO   150       4.844  -5.103  36.153  1.00 29.63           C  
ATOM   2080  C   PRO   150       7.581  -4.399  38.417  1.00 29.61           C  
ATOM   2081  O   PRO   150       8.018  -3.945  39.489  1.00 29.54           O  
ATOM   2082  N   ASN   151       8.376  -4.783  37.422  1.00 29.36           N  
ATOM   2083  CA  ASN   151       9.822  -4.955  37.659  1.00 29.29           C  
ATOM   2085  CB  ASN   151      10.222  -6.417  37.379  1.00 29.22           C  
ATOM   2088  CG  ASN   151       9.393  -7.403  38.184  1.00 29.70           C  
ATOM   2089  OD1 ASN   151       9.515  -7.467  39.415  1.00 31.50           O  
ATOM   2090  ND2 ASN   151       8.529  -8.160  37.506  1.00 29.02           N  
ATOM   2093  C   ASN   151      10.696  -3.953  36.893  1.00 29.09           C  
ATOM   2094  O   ASN   151      11.868  -4.212  36.608  1.00 28.75           O  
ATOM   2096  N   THR   152      10.114  -2.797  36.586  1.00 29.07           N  
ATOM   2097  CA  THR   152      10.816  -1.768  35.853  1.00 29.13           C  
ATOM   2099  CB  THR   152      10.365  -1.749  34.358  1.00 29.31           C  
ATOM   2101  OG1 THR   152       8.964  -1.486  34.277  1.00 28.92           O  
ATOM   2103  CG2 THR   152      10.672  -3.123  33.693  1.00 29.99           C  
ATOM   2107  C   THR   152      10.600  -0.410  36.487  1.00 28.94           C  
ATOM   2108  O   THR   152       9.581   0.221  36.237  1.00 29.39           O  
ATOM   2110  N   GLY   153      11.562   0.038  37.301  1.00 28.73           N  
ATOM   2111  CA  GLY   153      11.483   1.345  37.989  1.00 28.04           C  
ATOM   2114  C   GLY   153      10.359   1.408  39.007  1.00 27.67           C  
ATOM   2115  O   GLY   153       9.875   0.385  39.480  1.00 27.40           O  
ATOM   2117  N   ARG   154       9.926   2.618  39.332  1.00 27.56           N  
ATOM   2118  CA  ARG   154       8.747   2.822  40.177  1.00 27.59           C  
ATOM   2120  CB  ARG   154       9.132   3.433  41.525  1.00 27.45           C  
ATOM   2123  CG  ARG   154       9.477   2.437  42.549  1.00 27.94           C  
ATOM   2126  CD  ARG   154      10.289   3.050  43.692  1.00 29.70           C  
ATOM   2129  NE  ARG   154      11.140   2.009  44.299  1.00 31.13           N  
ATOM   2131  CZ  ARG   154      11.949   2.180  45.345  1.00 30.89           C  
ATOM   2132  NH1 ARG   154      12.044   3.355  45.964  1.00 31.54           N  
ATOM   2135  NH2 ARG   154      12.672   1.155  45.773  1.00 31.08           N  
ATOM   2138  C   ARG   154       7.802   3.767  39.492  1.00 27.48           C  
ATOM   2139  O   ARG   154       8.250   4.674  38.804  1.00 28.31           O  
ATOM   2141  N   PRO   155       6.494   3.619  39.730  1.00 27.20           N  
ATOM   2142  CA  PRO   155       5.580   4.628  39.183  1.00 27.00           C  
ATOM   2144  CB  PRO   155       4.213   4.019  39.450  1.00 27.10           C  
ATOM   2147  CG  PRO   155       4.437   3.158  40.638  1.00 26.63           C  
ATOM   2150  CD  PRO   155       5.785   2.594  40.507  1.00 26.55           C  
ATOM   2153  C   PRO   155       5.717   5.931  39.935  1.00 26.56           C  
ATOM   2154  O   PRO   155       6.093   5.929  41.091  1.00 26.56           O  
ATOM   2155  N   PHE   156       5.403   7.035  39.293  1.00 26.62           N  
ATOM   2156  CA  PHE   156       5.498   8.302  39.973  1.00 27.22           C  
ATOM   2158  CB  PHE   156       6.778   9.058  39.597  1.00 27.60           C  
ATOM   2161  CG  PHE   156       6.860   9.460  38.156  1.00 28.10           C  
ATOM   2162  CD1 PHE   156       6.445  10.730  37.746  1.00 28.61           C  
ATOM   2164  CE1 PHE   156       6.503  11.085  36.419  1.00 27.46           C  
ATOM   2166  CZ  PHE   156       7.012  10.192  35.490  1.00 27.56           C  
ATOM   2168  CE2 PHE   156       7.440   8.944  35.877  1.00 27.45           C  
ATOM   2170  CD2 PHE   156       7.367   8.578  37.206  1.00 27.25           C  
ATOM   2172  C   PHE   156       4.281   9.183  39.828  1.00 27.25           C  
ATOM   2173  O   PHE   156       3.396   8.940  39.036  1.00 27.35           O  
ATOM   2175  N   GLN   157       4.266  10.209  40.661  1.00 28.12           N  
ATOM   2176  CA  GLN   157       3.162  11.132  40.818  1.00 28.30           C  
ATOM   2178  CB  GLN   157       3.023  11.430  42.312  1.00 28.26           C  
ATOM   2181  CG  GLN   157       1.573  11.587  42.818  1.00 29.14           C  
ATOM   2184  CD  GLN   157       0.726  10.354  42.579  1.00 28.88           C  
ATOM   2185  OE1 GLN   157       1.229   9.216  42.576  1.00 28.76           O  
ATOM   2186  NE2 GLN   157      -0.573  10.565  42.387  1.00 28.49           N  
ATOM   2189  C   GLN   157       3.458  12.421  40.041  1.00 28.32           C  
ATOM   2190  O   GLN   157       4.630  12.798  39.874  1.00 28.21           O  
ATOM   2192  N   CYS   158       2.393  13.052  39.540  1.00 28.34           N  
ATOM   2193  CA  CYS   158       2.457  14.325  38.805  1.00 28.55           C  
ATOM   2195  CB  CYS   158       2.053  14.113  37.368  1.00 28.36           C  
ATOM   2198  SG  CYS   158       3.234  13.191  36.449  1.00 32.99           S  
ATOM   2200  C   CYS   158       1.518  15.370  39.380  1.00 28.03           C  
ATOM   2201  O   CYS   158       0.415  15.028  39.825  1.00 28.21           O  
ATOM   2203  N   ILE   159       1.945  16.633  39.348  1.00 27.55           N  
ATOM   2204  CA  ILE   159       1.083  17.776  39.671  1.00 27.15           C  
ATOM   2206  CB  ILE   159       1.560  18.532  40.932  1.00 27.19           C  
ATOM   2208  CG1 ILE   159       1.641  17.546  42.109  1.00 27.25           C  
ATOM   2211  CD1 ILE   159       1.732  18.195  43.500  1.00 27.36           C  
ATOM   2215  CG2 ILE   159       0.655  19.748  41.227  1.00 26.47           C  
ATOM   2219  C   ILE   159       1.151  18.672  38.468  1.00 27.06           C  
ATOM   2220  O   ILE   159       2.008  19.550  38.397  1.00 27.30           O  
ATOM   2222  N   PRO   160       0.298  18.414  37.472  1.00 27.10           N  
ATOM   2223  CA  PRO   160       0.305  19.229  36.281  1.00 27.19           C  
ATOM   2225  CB  PRO   160      -0.544  18.406  35.303  1.00 26.90           C  
ATOM   2228  CG  PRO   160      -1.433  17.695  36.094  1.00 26.70           C  
ATOM   2231  CD  PRO   160      -0.693  17.339  37.350  1.00 27.27           C  
ATOM   2234  C   PRO   160      -0.314  20.600  36.470  1.00 27.02           C  
ATOM   2235  O   PRO   160      -0.932  20.865  37.479  1.00 27.06           O  
ATOM   2236  N   GLY   161      -0.094  21.468  35.491  1.00 27.50           N  
ATOM   2237  CA  GLY   161      -0.924  22.640  35.290  1.00 27.79           C  
ATOM   2240  C   GLY   161      -0.387  23.921  35.877  1.00 27.97           C  
ATOM   2241  O   GLY   161      -0.988  24.972  35.702  1.00 28.30           O  
ATOM   2243  N   TYR   162       0.734  23.872  36.581  1.00 28.36           N  
ATOM   2244  CA  TYR   162       1.233  25.110  37.155  1.00 28.73           C  
ATOM   2246  CB  TYR   162       2.370  24.897  38.182  1.00 29.03           C  
ATOM   2249  CG  TYR   162       2.842  26.246  38.703  1.00 30.02           C  
ATOM   2250  CD1 TYR   162       2.168  26.905  39.728  1.00 30.55           C  
ATOM   2252  CE1 TYR   162       2.574  28.183  40.156  1.00 31.77           C  
ATOM   2254  CZ  TYR   162       3.668  28.808  39.529  1.00 32.70           C  
ATOM   2255  OH  TYR   162       4.146  30.073  39.894  1.00 31.50           O  
ATOM   2257  CE2 TYR   162       4.321  28.152  38.497  1.00 32.51           C  
ATOM   2259  CD2 TYR   162       3.893  26.901  38.083  1.00 31.20           C  
ATOM   2261  C   TYR   162       1.658  26.061  36.018  1.00 28.23           C  
ATOM   2262  O   TYR   162       2.606  25.766  35.303  1.00 27.90           O  
ATOM   2264  N   ARG   163       0.938  27.177  35.868  1.00 27.90           N  
ATOM   2265  CA  ARG   163       1.139  28.134  34.763  1.00 27.84           C  
ATOM   2267  CB  ARG   163       2.396  28.962  35.001  1.00 27.51           C  
ATOM   2270  CG  ARG   163       2.350  29.744  36.287  1.00 28.30           C  
ATOM   2273  CD  ARG   163       3.691  30.412  36.611  1.00 28.58           C  
ATOM   2276  NE  ARG   163       3.973  31.592  35.798  1.00 29.09           N  
ATOM   2278  CZ  ARG   163       5.109  32.290  35.861  1.00 29.67           C  
ATOM   2279  NH1 ARG   163       6.078  31.937  36.710  1.00 30.17           N  
ATOM   2282  NH2 ARG   163       5.285  33.355  35.082  1.00 29.92           N  
ATOM   2285  C   ARG   163       1.174  27.499  33.350  1.00 27.71           C  
ATOM   2286  O   ARG   163       1.954  27.913  32.497  1.00 27.28           O  
ATOM   2288  N   ALA   164       0.302  26.517  33.113  1.00 27.57           N  
ATOM   2289  CA  ALA   164       0.159  25.891  31.798  1.00 27.60           C  
ATOM   2291  CB  ALA   164      -1.012  24.920  31.791  1.00 27.29           C  
ATOM   2295  C   ALA   164      -0.012  26.895  30.656  1.00 27.60           C  
ATOM   2296  O   ALA   164       0.579  26.704  29.599  1.00 27.70           O  
ATOM   2298  N   GLU   165      -0.800  27.951  30.862  1.00 27.39           N  
ATOM   2299  CA  GLU   165      -1.129  28.868  29.776  1.00 27.48           C  
ATOM   2301  CB  GLU   165      -2.048  29.961  30.262  1.00 27.81           C  
ATOM   2304  CG  GLU   165      -3.485  29.532  30.421  1.00 28.47           C  
ATOM   2307  CD  GLU   165      -4.392  30.708  30.786  1.00 30.58           C  
ATOM   2308  OE1 GLU   165      -4.442  31.711  30.023  1.00 30.66           O  
ATOM   2309  OE2 GLU   165      -5.060  30.633  31.849  1.00 32.43           O  
ATOM   2310  C   GLU   165       0.095  29.506  29.147  1.00 27.46           C  
ATOM   2311  O   GLU   165       0.268  29.497  27.928  1.00 27.18           O  
ATOM   2313  N   GLU   166       0.952  30.060  29.986  1.00 27.59           N  
ATOM   2314  CA  GLU   166       2.217  30.598  29.507  1.00 27.66           C  
ATOM   2316  CB  GLU   166       2.961  31.263  30.642  1.00 27.89           C  
ATOM   2319  CG  GLU   166       2.239  32.502  31.138  1.00 28.65           C  
ATOM   2322  CD  GLU   166       2.848  33.086  32.398  1.00 29.34           C  
ATOM   2323  OE1 GLU   166       3.360  32.322  33.252  1.00 28.90           O  
ATOM   2324  OE2 GLU   166       2.794  34.329  32.526  1.00 30.57           O  
ATOM   2325  C   GLU   166       3.097  29.544  28.876  1.00 27.37           C  
ATOM   2326  O   GLU   166       3.672  29.780  27.827  1.00 27.66           O  
ATOM   2328  N   ALA   167       3.185  28.376  29.498  1.00 27.20           N  
ATOM   2329  CA  ALA   167       3.951  27.277  28.926  1.00 26.97           C  
ATOM   2331  CB  ALA   167       3.988  26.105  29.869  1.00 26.83           C  
ATOM   2335  C   ALA   167       3.441  26.861  27.541  1.00 26.95           C  
ATOM   2336  O   ALA   167       4.225  26.686  26.627  1.00 27.07           O  
ATOM   2338  N   VAL   168       2.146  26.697  27.351  1.00 27.13           N  
ATOM   2339  CA  VAL   168       1.671  26.376  25.996  1.00 27.57           C  
ATOM   2341  CB  VAL   168       0.208  25.937  25.964  1.00 27.39           C  
ATOM   2343  CG1 VAL   168       0.085  24.566  26.594  1.00 27.92           C  
ATOM   2347  CG2 VAL   168      -0.663  26.963  26.637  1.00 26.18           C  
ATOM   2351  C   VAL   168       1.852  27.548  25.023  1.00 28.01           C  
ATOM   2352  O   VAL   168       2.143  27.336  23.839  1.00 27.90           O  
ATOM   2354  N   GLU   169       1.711  28.781  25.515  1.00 28.22           N  
ATOM   2355  CA  GLU   169       1.960  29.937  24.661  1.00 28.31           C  
ATOM   2357  CB  GLU   169       1.661  31.238  25.379  1.00 28.19           C  
ATOM   2360  CG  GLU   169       0.934  32.227  24.473  1.00 29.54           C  
ATOM   2363  CD  GLU   169       0.943  33.661  25.021  1.00 31.96           C  
ATOM   2364  OE1 GLU   169       1.714  33.912  26.000  1.00 34.14           O  
ATOM   2365  OE2 GLU   169       0.198  34.544  24.472  1.00 32.15           O  
ATOM   2366  C   GLU   169       3.388  29.963  24.101  1.00 28.30           C  
ATOM   2367  O   GLU   169       3.597  30.326  22.943  1.00 28.98           O  
ATOM   2369  N   MET   170       4.367  29.589  24.914  1.00 28.08           N  
ATOM   2370  CA  MET   170       5.754  29.551  24.453  1.00 28.04           C  
ATOM   2372  CB  MET   170       6.726  29.335  25.622  1.00 27.87           C  
ATOM   2375  CG  MET   170       7.074  30.615  26.367  1.00 28.33           C  
ATOM   2378  SD  MET   170       8.249  30.471  27.752  1.00 28.55           S  
ATOM   2379  CE  MET   170       7.214  29.683  28.987  1.00 27.96           C  
ATOM   2383  C   MET   170       5.940  28.468  23.400  1.00 28.13           C  
ATOM   2384  O   MET   170       6.505  28.715  22.348  1.00 28.20           O  
ATOM   2386  N   LEU   171       5.473  27.261  23.700  1.00 28.42           N  
ATOM   2387  CA  LEU   171       5.558  26.143  22.769  1.00 28.42           C  
ATOM   2389  CB  LEU   171       4.834  24.913  23.331  1.00 28.74           C  
ATOM   2392  CG  LEU   171       5.614  23.807  24.025  1.00 28.64           C  
ATOM   2394  CD1 LEU   171       4.612  22.730  24.485  1.00 27.77           C  
ATOM   2398  CD2 LEU   171       6.693  23.239  23.103  1.00 28.05           C  
ATOM   2402  C   LEU   171       4.911  26.485  21.439  1.00 28.37           C  
ATOM   2403  O   LEU   171       5.433  26.122  20.377  1.00 28.57           O  
ATOM   2405  N   LYS   172       3.753  27.142  21.499  1.00 28.00           N  
ATOM   2406  CA  LYS   172       3.012  27.463  20.274  1.00 27.85           C  
ATOM   2408  CB  LYS   172       1.593  28.000  20.576  1.00 27.67           C  
ATOM   2411  CG  LYS   172       0.523  26.888  20.684  1.00 27.83           C  
ATOM   2414  CD  LYS   172      -0.851  27.407  21.176  1.00 28.79           C  
ATOM   2417  CE  LYS   172      -1.973  26.373  20.896  1.00 29.34           C  
ATOM   2420  NZ  LYS   172      -2.428  26.347  19.368  1.00 29.31           N  
ATOM   2424  C   LYS   172       3.815  28.432  19.425  1.00 27.32           C  
ATOM   2425  O   LYS   172       3.942  28.266  18.218  1.00 27.26           O  
ATOM   2427  N   THR   173       4.380  29.432  20.074  1.00 27.30           N  
ATOM   2428  CA  THR   173       5.135  30.429  19.362  1.00 27.36           C  
ATOM   2430  CB  THR   173       5.501  31.639  20.254  1.00 26.82           C  
ATOM   2432  OG1 THR   173       6.315  32.503  19.498  1.00 28.03           O  
ATOM   2434  CG2 THR   173       6.295  31.285  21.426  1.00 26.84           C  
ATOM   2438  C   THR   173       6.353  29.769  18.728  1.00 27.39           C  
ATOM   2439  O   THR   173       6.729  30.102  17.611  1.00 27.65           O  
ATOM   2441  N   PHE   174       6.925  28.799  19.429  1.00 27.67           N  
ATOM   2442  CA  PHE   174       8.075  28.052  18.934  1.00 27.96           C  
ATOM   2444  CB  PHE   174       8.691  27.157  20.029  1.00 28.11           C  
ATOM   2447  CG  PHE   174       9.701  26.141  19.491  1.00 27.94           C  
ATOM   2448  CD1 PHE   174      11.002  26.527  19.174  1.00 26.47           C  
ATOM   2450  CE1 PHE   174      11.911  25.605  18.678  1.00 26.06           C  
ATOM   2452  CZ  PHE   174      11.523  24.288  18.477  1.00 25.76           C  
ATOM   2454  CE2 PHE   174      10.242  23.892  18.780  1.00 26.66           C  
ATOM   2456  CD2 PHE   174       9.334  24.807  19.287  1.00 27.84           C  
ATOM   2458  C   PHE   174       7.766  27.179  17.721  1.00 28.18           C  
ATOM   2459  O   PHE   174       8.631  27.024  16.863  1.00 28.86           O  
ATOM   2461  N   TYR   175       6.575  26.582  17.646  1.00 28.31           N  
ATOM   2462  CA  TYR   175       6.244  25.756  16.479  1.00 28.37           C  
ATOM   2464  CB  TYR   175       5.120  24.775  16.797  1.00 28.20           C  
ATOM   2467  CG  TYR   175       5.549  23.642  17.687  1.00 29.03           C  
ATOM   2468  CD1 TYR   175       4.708  23.182  18.704  1.00 29.68           C  
ATOM   2470  CE1 TYR   175       5.092  22.132  19.551  1.00 30.13           C  
ATOM   2472  CZ  TYR   175       6.344  21.524  19.369  1.00 30.83           C  
ATOM   2473  OH  TYR   175       6.716  20.480  20.195  1.00 33.11           O  
ATOM   2475  CE2 TYR   175       7.205  21.961  18.362  1.00 29.36           C  
ATOM   2477  CD2 TYR   175       6.801  23.013  17.521  1.00 29.43           C  
ATOM   2479  C   TYR   175       5.922  26.556  15.211  1.00 28.44           C  
ATOM   2480  O   TYR   175       5.590  25.962  14.192  1.00 28.62           O  
ATOM   2482  N   LYS   176       6.052  27.880  15.254  1.00 28.50           N  
ATOM   2483  CA  LYS   176       6.067  28.676  14.029  1.00 29.01           C  
ATOM   2485  CB  LYS   176       5.261  29.955  14.213  1.00 28.81           C  
ATOM   2488  CG  LYS   176       3.855  29.628  14.728  1.00 29.06           C  
ATOM   2491  CD  LYS   176       3.017  30.883  15.126  1.00 28.97           C  
ATOM   2494  CE  LYS   176       1.805  30.431  16.053  1.00 28.62           C  
ATOM   2497  NZ  LYS   176       0.966  31.639  16.480  1.00 28.07           N  
ATOM   2501  C   LYS   176       7.516  28.924  13.596  1.00 29.73           C  
ATOM   2502  O   LYS   176       8.033  30.071  13.612  1.00 29.38           O  
ATOM   2504  N   GLN   177       8.151  27.782  13.243  1.00 30.84           N  
ATOM   2505  CA  GLN   177       9.491  27.720  12.613  1.00 31.22           C  
ATOM   2507  CB  GLN   177      10.615  28.236  13.553  1.00 31.62           C  
ATOM   2510  CG  GLN   177      12.100  28.010  13.035  1.00 32.08           C  
ATOM   2513  CD  GLN   177      12.575  29.029  11.958  1.00 32.52           C  
ATOM   2514  OE1 GLN   177      12.497  30.261  12.160  1.00 31.81           O  
ATOM   2515  NE2 GLN   177      13.111  28.498  10.831  1.00 31.77           N  
ATOM   2518  C   GLN   177       9.731  26.249  12.215  1.00 30.80           C  
ATOM   2519  O   GLN   177       9.033  25.353  12.722  1.00 29.50           O  
END
