
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  137 ( 1030),  selected  137 , name 3cm1_A
# Molecule2: number of CA atoms   80 ( 1370),  selected   80 , name T0460.pdb
# PARAMETERS: 3cm1_A.T0460.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_A      M       1           -
LGA    S     2_A      N       2           -
LGA    S     3_A      S       3           -
LGA    S     4_A      E       4           -
LGA    G     5_A      V       5           -
LGA    T     6_A      I       6           -
LGA    S     7_A      K       7           -
LGA    I     8_A      E       8           -
LGA    T     9_A      F       9           -
LGA    C    10_A      L      10           -
LGA    E    11_A      E      11           -
LGA    V    12_A      D      12           -
LGA    G    13_A      I      13           -
LGA    -       -      G      14           -
LGA    -       -      E      15           -
LGA    -       -      D      16           -
LGA    L    14_A      Y      17           #
LGA    Q    15_A      I      18          4.928
LGA    L    16_A      E      19          4.344
LGA    I    17_A      L      20           #
LGA    V    18_A      E      21          3.439
LGA    P    19_A      N      22          4.527
LGA    D    20_A      -       -           -
LGA    R    21_A      -       -           -
LGA    A    22_A      -       -           -
LGA    P    23_A      E      23          4.724
LGA    V    24_A      I      24          4.997
LGA    P    25_A      H      25          4.423
LGA    L    26_A      L      26          3.754
LGA    V    27_A      K      27          3.443
LGA    -       -      P      28           -
LGA    -       -      E      29           -
LGA    A    28_A      V      30          1.898
LGA    R    29_A      F      31           #
LGA    L    30_A      Y      32          3.158
LGA    D    31_A      E      33          4.860
LGA    Y    32_A      -       -           -
LGA    S    33_A      -       -           -
LGA    V    34_A      -       -           -
LGA    D    35_A      -       -           -
LGA    D    36_A      -       -           -
LGA    P    37_A      -       -           -
LGA    Y    38_A      -       -           -
LGA    A    39_A      -       -           -
LGA    I    40_A      -       -           -
LGA    R    41_A      -       -           -
LGA    A    42_A      V      34          2.150
LGA    A    43_A      W      35           #
LGA    F    44_A      K      36           -
LGA    H    45_A      -       -           -
LGA    V    46_A      -       -           -
LGA    G    47_A      -       -           -
LGA    D    48_A      -       -           -
LGA    D    49_A      -       -           -
LGA    E    50_A      -       -           -
LGA    P    51_A      -       -           -
LGA    V    52_A      -       -           -
LGA    E    53_A      Y      37          3.858
LGA    W    54_A      V      38          2.604
LGA    I    55_A      G      39          3.688
LGA    F    56_A      E      40          1.884
LGA    A    57_A      -       -           -
LGA    R    58_A      -       -           -
LGA    E    59_A      -       -           -
LGA    L    60_A      -       -           -
LGA    L    61_A      -       -           -
LGA    T    62_A      -       -           -
LGA    V    63_A      -       -           -
LGA    G    64_A      -       -           -
LGA    I    65_A      -       -           -
LGA    I    66_A      -       -           -
LGA    R    67_A      -       -           -
LGA    E    68_A      -       -           -
LGA    T    69_A      -       -           -
LGA    G    70_A      -       -           -
LGA    E    71_A      -       -           -
LGA    G    72_A      -       -           -
LGA    D    73_A      -       -           -
LGA    V    74_A      P      41          3.558
LGA    R    75_A      E      42          4.087
LGA    I    76_A      L      43          1.577
LGA    W    77_A      K      44          1.357
LGA    P    78_A      T      45          1.262
LGA    S    79_A      Y      46          0.531
LGA    Q    80_A      V      47          1.436
LGA    D    81_A      I      48          1.820
LGA    G    82_A      E      49          0.894
LGA    K    83_A      K      72          1.066
LGA    E    84_A      I      73          1.397
LGA    R    85_A      K      74          0.990
LGA    X    86_A      K      75          0.794
LGA    V    87_A      V      76          0.872
LGA    N    88_A      Y      77          1.550
LGA    I    89_A      F      78          1.240
LGA    A    90_A      E      79          1.792
LGA    L    91_A      T      80          2.527
LGA    S    92_A      L      81          3.289
LGA    S    93_A      -       -           -
LGA    P    94_A      -       -           -
LGA    F    95_A      -       -           -
LGA    G    96_A      D      82          2.606
LGA    Q    97_A      N      83          2.181
LGA    A    98_A      V      84          1.818
LGA    R    99_A      R      85          1.209
LGA    F   100_A      V      86          0.887
LGA    H   101_A      V      87          1.097
LGA    A   102_A      T      88          1.387
LGA    Q   103_A      D      89          1.469
LGA    V   104_A      Y      90          1.120
LGA    A   105_A      S      91          1.328
LGA    P   106_A      E      92          1.138
LGA    L   107_A      F      93          0.691
LGA    S   108_A      Q      94          0.182
LGA    E   109_A      K      95          1.152
LGA    F   110_A      I      96          1.234
LGA    L   111_A      L      97          1.075
LGA    H   112_A      K      98          1.077
LGA    R   113_A      K      99          2.277
LGA    T   114_A      R     100          2.858
LGA    Y   115_A      G     101          2.251
LGA    E   116_A      T     102           #
LGA    L   117_A      -       -           -
LGA    V   118_A      -       -           -
LGA    P   119_A      -       -           -
LGA    A   120_A      -       -           -
LGA    G   121_A      -       -           -
LGA    Q   122_A      -       -           -
LGA    E   123_A      -       -           -
LGA    S   124_A      -       -           -
LGA    D   125_A      -       -           -
LGA    Y   126_A      -       -           -
LGA    I   127_A      -       -           -
LGA    D   128_A      -       -           -
LGA    I   129_A      -       -           -
LGA    D   130_A      -       -           -
LGA    A   131_A      -       -           -
LGA    E   132_A      -       -           -
LGA    I   133_A      -       -           -
LGA    A   134_A      -       -           -
LGA    E   135_A      -       -           -
LGA    H   136_A      -       -           -
LGA    L   137_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  137   80    5.0     56    2.57     8.93     52.146     2.094

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.019558 * X  +   0.946658 * Y  +  -0.321647 * Z  +  63.876350
  Y_new =   0.903985 * X  +   0.120690 * Y  +   0.410178 * Z  + -22.934780
  Z_new =   0.427117 * X  +  -0.298787 * Y  +  -0.853403 * Z  +  -1.879682 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.804818    0.336774  [ DEG:  -160.7043     19.2958 ]
  Theta =  -0.441302   -2.700290  [ DEG:   -25.2848   -154.7152 ]
  Phi   =   1.549164   -1.592429  [ DEG:    88.7606    -91.2394 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3cm1_A                                        
REMARK     2: T0460.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3cm1_A.T0460.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  137   80   5.0   56   2.57    8.93  52.146
REMARK  ---------------------------------------------------------- 
MOLECULE 3cm1_A
HEADER    CELL CYCLE                              20-MAR-08   3CM1              
TITLE     CRYSTAL STRUCTURE OF SSGA-LIKE SPORULATION-SPECIFIC CELL              
TITLE    2 DIVISION PROTEIN (YP_290167.1) FROM THERMOBIFIDA FUSCA YX-           
TITLE    3 ER1 AT 2.60 A RESOLUTION                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SSGA-LIKE SPORULATION-SPECIFIC CELL DIVISION               
COMPND   3 PROTEIN;                                                             
COMPND   4 CHAIN: A, B, C;                                                      
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: THERMOBIFIDA FUSCA YX;                          
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: YX;                                                          
SOURCE   5 GENE: YP_290167.1, TFU_2111;                                         
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    YP_290167.1, SSGA-LIKE SPORULATION-SPECIFIC CELL DIVISION             
KEYWDS   2 PROTEIN, STREPTOMYCES SPORULATION AND CELL DIVISION PROTEIN,         
KEYWDS   3 SSGA, STRUCTURAL GENOMICS, JOINT CENTER FOR STRUCTURAL               
KEYWDS   4 GENOMICS, JCSG, PROTEIN STRUCTURE INITIATIVE, PSI-2, CELL            
KEYWDS   5 CYCLE                                                                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG),M.CHRUSZCZ,               
AUTHOR   2 W.MINOR,S.WANG                                                       
REVDAT   2   08-APR-08 3CM1    1       AUTHOR                                   
REVDAT   1   01-APR-08 3CM1    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG),                 
JRNL        AUTH 2 M.CHRUSZCZ,W.MINOR,S.WANG                                    
JRNL        TITL   CRYSTAL STRUCTURE OF SSGA-LIKE                               
JRNL        TITL 2 SPORULATION-SPECIFIC CELL DIVISION PROTEIN                   
JRNL        TITL 3 (YP_290167.1) FROM THERMOBIFIDA FUSCA YX-ER1 AT              
JRNL        TITL 4 2.60 A RESOLUTION                                            
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.60 ANGSTROMS.                                          
DBREF  3CM1 A    1   138  UNP    Q47N25   Q47N25_THEFY     1    138             
DBREF  3CM1 B    1   138  UNP    Q47N25   Q47N25_THEFY     1    138             
DBREF  3CM1 C    1   138  UNP    Q47N25   Q47N25_THEFY     1    138             
SEQRES   1 A  139  GLY MSE SER SER SER GLY THR SER ILE THR CYS GLU VAL          
SEQRES   2 A  139  GLY LEU GLN LEU ILE VAL PRO ASP ARG ALA PRO VAL PRO          
SEQRES   3 A  139  LEU VAL ALA ARG LEU ASP TYR SER VAL ASP ASP PRO TYR          
SEQRES   4 A  139  ALA ILE ARG ALA ALA PHE HIS VAL GLY ASP ASP GLU PRO          
SEQRES   5 A  139  VAL GLU TRP ILE PHE ALA ARG GLU LEU LEU THR VAL GLY          
SEQRES   6 A  139  ILE ILE ARG GLU THR GLY GLU GLY ASP VAL ARG ILE TRP          
SEQRES   7 A  139  PRO SER GLN ASP GLY LYS GLU ARG MSE VAL ASN ILE ALA          
SEQRES   8 A  139  LEU SER SER PRO PHE GLY GLN ALA ARG PHE HIS ALA GLN          
SEQRES   9 A  139  VAL ALA PRO LEU SER GLU PHE LEU HIS ARG THR TYR GLU          
SEQRES  10 A  139  LEU VAL PRO ALA GLY GLN GLU SER ASP TYR ILE ASP ILE          
SEQRES  11 A  139  ASP ALA GLU ILE ALA GLU HIS LEU SER                          
SEQRES   1 B  139  GLY MSE SER SER SER GLY THR SER ILE THR CYS GLU VAL          
SEQRES   2 B  139  GLY LEU GLN LEU ILE VAL PRO ASP ARG ALA PRO VAL PRO          
SEQRES   3 B  139  LEU VAL ALA ARG LEU ASP TYR SER VAL ASP ASP PRO TYR          
SEQRES   4 B  139  ALA ILE ARG ALA ALA PHE HIS VAL GLY ASP ASP GLU PRO          
SEQRES   5 B  139  VAL GLU TRP ILE PHE ALA ARG GLU LEU LEU THR VAL GLY          
SEQRES   6 B  139  ILE ILE ARG GLU THR GLY GLU GLY ASP VAL ARG ILE TRP          
SEQRES   7 B  139  PRO SER GLN ASP GLY LYS GLU ARG MSE VAL ASN ILE ALA          
SEQRES   8 B  139  LEU SER SER PRO PHE GLY GLN ALA ARG PHE HIS ALA GLN          
SEQRES   9 B  139  VAL ALA PRO LEU SER GLU PHE LEU HIS ARG THR TYR GLU          
SEQRES  10 B  139  LEU VAL PRO ALA GLY GLN GLU SER ASP TYR ILE ASP ILE          
SEQRES  11 B  139  ASP ALA GLU ILE ALA GLU HIS LEU SER                          
SEQRES   1 C  139  GLY MSE SER SER SER GLY THR SER ILE THR CYS GLU VAL          
SEQRES   2 C  139  GLY LEU GLN LEU ILE VAL PRO ASP ARG ALA PRO VAL PRO          
SEQRES   3 C  139  LEU VAL ALA ARG LEU ASP TYR SER VAL ASP ASP PRO TYR          
SEQRES   4 C  139  ALA ILE ARG ALA ALA PHE HIS VAL GLY ASP ASP GLU PRO          
SEQRES   5 C  139  VAL GLU TRP ILE PHE ALA ARG GLU LEU LEU THR VAL GLY          
SEQRES   6 C  139  ILE ILE ARG GLU THR GLY GLU GLY ASP VAL ARG ILE TRP          
SEQRES   7 C  139  PRO SER GLN ASP GLY LYS GLU ARG MSE VAL ASN ILE ALA          
SEQRES   8 C  139  LEU SER SER PRO PHE GLY GLN ALA ARG PHE HIS ALA GLN          
SEQRES   9 C  139  VAL ALA PRO LEU SER GLU PHE LEU HIS ARG THR TYR GLU          
SEQRES  10 C  139  LEU VAL PRO ALA GLY GLN GLU SER ASP TYR ILE ASP ILE          
SEQRES  11 C  139  ASP ALA GLU ILE ALA GLU HIS LEU SER                          
HET    MSE  A   1       8                                                       
HET    MSE  A  86       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  86       8                                                       
HET    MSE  C   1       8                                                       
HET    MSE  C  86       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    6(C5 H11 N O2 SE)                                            
CRYST1   64.840   64.840  130.600  90.00  90.00  90.00 P 41         12          
HETATM    1  N   MSE A   1      77.485  12.943  23.443  1.00 94.11           N  
HETATM    2  CA  MSE A   1      76.294  12.169  22.992  1.00 93.46           C  
HETATM    3  C   MSE A   1      75.710  12.820  21.732  1.00 92.38           C  
HETATM    4  O   MSE A   1      74.812  13.652  21.809  1.00 89.95           O  
HETATM    5  CB  MSE A   1      75.260  12.083  24.122  1.00 94.22           C  
HETATM    6  CG  MSE A   1      73.997  11.236  23.830  1.00 96.14           C  
HETATM    7 SE   MSE A   1      74.236   9.257  23.709  0.75102.45          SE  
HETATM    8  CE  MSE A   1      72.411   8.687  24.264  1.00 94.16           C  
ATOM      9  N   SER A   2      76.240  12.412  20.575  1.00 93.01           N  
ATOM     10  CA  SER A   2      75.824  12.919  19.248  1.00 92.27           C  
ATOM     11  C   SER A   2      74.354  12.683  18.927  1.00 92.41           C  
ATOM     12  O   SER A   2      73.754  11.711  19.378  1.00 94.06           O  
ATOM     13  CB  SER A   2      76.632  12.258  18.127  1.00 90.81           C  
ATOM     14  OG  SER A   2      78.021  12.349  18.361  1.00 90.63           O  
ATOM     15  N   SER A   3      73.804  13.571  18.101  1.00 91.58           N  
ATOM     16  CA  SER A   3      72.409  13.512  17.658  1.00 90.16           C  
ATOM     17  C   SER A   3      72.133  12.221  16.918  1.00 89.14           C  
ATOM     18  O   SER A   3      73.025  11.664  16.281  1.00 87.93           O  
ATOM     19  CB  SER A   3      72.093  14.682  16.715  1.00 89.63           C  
ATOM     20  N   SER A   4      70.884  11.767  16.986  1.00 88.96           N  
ATOM     21  CA  SER A   4      70.470  10.528  16.326  1.00 88.39           C  
ATOM     22  C   SER A   4      70.736  10.567  14.815  1.00 88.30           C  
ATOM     23  O   SER A   4      70.886   9.528  14.188  1.00 89.27           O  
ATOM     24  CB  SER A   4      68.988  10.223  16.588  1.00 86.25           C  
ATOM     25  N   GLY A   5      70.815  11.751  14.217  1.00 86.55           N  
ATOM     26  CA  GLY A   5      70.997  11.811  12.768  1.00 84.99           C  
ATOM     27  C   GLY A   5      72.418  11.840  12.233  1.00 82.39           C  
ATOM     28  O   GLY A   5      72.614  11.698  11.022  1.00 83.97           O  
ATOM     29  N   THR A   6      73.402  12.006  13.115  1.00 77.90           N  
ATOM     30  CA  THR A   6      74.754  12.309  12.685  1.00 74.70           C  
ATOM     31  C   THR A   6      75.378  11.223  11.821  1.00 72.95           C  
ATOM     32  O   THR A   6      75.152  10.038  12.027  1.00 72.10           O  
ATOM     33  CB  THR A   6      75.652  12.639  13.854  1.00 73.87           C  
ATOM     34  OG1 THR A   6      74.918  13.443  14.778  1.00 78.44           O  
ATOM     35  CG2 THR A   6      76.860  13.414  13.374  1.00 76.03           C  
ATOM     36  N   SER A   7      76.149  11.669  10.834  1.00 72.79           N  
ATOM     37  CA  SER A   7      76.723  10.802   9.810  1.00 71.50           C  
ATOM     38  C   SER A   7      77.964  11.461   9.182  1.00 70.15           C  
ATOM     39  O   SER A   7      78.059  12.690   9.138  1.00 69.01           O  
ATOM     40  CB  SER A   7      75.630  10.565   8.767  1.00 72.16           C  
ATOM     41  OG  SER A   7      76.067   9.747   7.712  1.00 81.08           O  
ATOM     42  N   ILE A   8      78.934  10.662   8.756  1.00 69.88           N  
ATOM     43  CA  ILE A   8      80.095  11.209   8.016  1.00 70.66           C  
ATOM     44  C   ILE A   8      80.377  10.377   6.800  1.00 69.84           C  
ATOM     45  O   ILE A   8      80.075   9.190   6.771  1.00 69.71           O  
ATOM     46  CB  ILE A   8      81.382  11.379   8.838  1.00 70.86           C  
ATOM     47  CG1 ILE A   8      81.668  10.151   9.691  1.00 74.63           C  
ATOM     48  CG2 ILE A   8      81.245  12.573   9.726  1.00 72.29           C  
ATOM     49  CD1 ILE A   8      82.987  10.222  10.373  1.00 73.56           C  
ATOM     50  N   THR A   9      80.958  11.018   5.801  1.00 69.22           N  
ATOM     51  CA  THR A   9      81.276  10.367   4.550  1.00 70.26           C  
ATOM     52  C   THR A   9      82.602  10.874   4.056  1.00 70.20           C  
ATOM     53  O   THR A   9      82.964  12.009   4.304  1.00 70.02           O  
ATOM     54  CB  THR A   9      80.198  10.667   3.475  1.00 71.29           C  
ATOM     55  OG1 THR A   9      79.027   9.886   3.731  1.00 73.20           O  
ATOM     56  CG2 THR A   9      80.677  10.336   2.085  1.00 71.94           C  
ATOM     57  N   CYS A  10      83.338  10.025   3.370  1.00 71.64           N  
ATOM     58  CA  CYS A  10      84.506  10.484   2.627  1.00 74.10           C  
ATOM     59  C   CYS A  10      84.747   9.613   1.397  1.00 73.74           C  
ATOM     60  O   CYS A  10      84.103   8.578   1.205  1.00 73.59           O  
ATOM     61  CB  CYS A  10      85.745  10.506   3.503  1.00 73.71           C  
ATOM     62  SG  CYS A  10      86.288   8.889   3.874  1.00 86.05           S  
ATOM     63  N   GLU A  11      85.676  10.064   0.564  1.00 74.19           N  
ATOM     64  CA  GLU A  11      86.081   9.341  -0.620  1.00 74.56           C  
ATOM     65  C   GLU A  11      87.539   8.972  -0.503  1.00 75.01           C  
ATOM     66  O   GLU A  11      88.349   9.761  -0.023  1.00 75.78           O  
ATOM     67  CB  GLU A  11      85.828  10.175  -1.854  1.00 74.54           C  
ATOM     68  CG  GLU A  11      84.344  10.297  -2.136  1.00 76.11           C  
ATOM     69  CD  GLU A  11      84.027  10.958  -3.463  1.00 82.63           C  
ATOM     70  OE1 GLU A  11      84.960  11.328  -4.234  1.00 88.32           O  
ATOM     71  OE2 GLU A  11      82.811  11.095  -3.735  1.00 90.04           O  
ATOM     72  N   VAL A  12      87.862   7.761  -0.932  1.00 75.90           N  
ATOM     73  CA  VAL A  12      89.209   7.211  -0.819  1.00 76.27           C  
ATOM     74  C   VAL A  12      89.663   6.568  -2.128  1.00 77.80           C  
ATOM     75  O   VAL A  12      88.899   5.829  -2.761  1.00 78.11           O  
ATOM     76  CB  VAL A  12      89.263   6.167   0.295  1.00 75.49           C  
ATOM     77  CG1 VAL A  12      90.267   5.095  -0.013  1.00 78.92           C  
ATOM     78  CG2 VAL A  12      89.582   6.828   1.600  1.00 75.80           C  
ATOM     79  N   GLY A  13      90.912   6.850  -2.514  1.00 78.83           N  
ATOM     80  CA  GLY A  13      91.521   6.270  -3.697  1.00 79.06           C  
ATOM     81  C   GLY A  13      91.883   4.820  -3.434  1.00 80.46           C  
ATOM     82  O   GLY A  13      92.462   4.497  -2.397  1.00 81.23           O  
ATOM     83  N   LEU A  14      91.518   3.945  -4.367  1.00 81.17           N  
ATOM     84  CA  LEU A  14      91.759   2.501  -4.250  1.00 81.16           C  
ATOM     85  C   LEU A  14      92.261   1.932  -5.545  1.00 80.73           C  
ATOM     86  O   LEU A  14      92.183   2.577  -6.576  1.00 80.76           O  
ATOM     87  CB  LEU A  14      90.460   1.778  -3.930  1.00 80.19           C  
ATOM     88  CG  LEU A  14      90.181   1.667  -2.467  1.00 85.56           C  
ATOM     89  CD1 LEU A  14      88.790   1.153  -2.326  1.00 95.04           C  
ATOM     90  CD2 LEU A  14      91.183   0.731  -1.843  1.00 90.37           C  
ATOM     91  N   GLN A  15      92.739   0.697  -5.472  1.00 81.15           N  
ATOM     92  CA  GLN A  15      93.143  -0.067  -6.638  1.00 81.47           C  
ATOM     93  C   GLN A  15      92.518  -1.450  -6.541  1.00 80.90           C  
ATOM     94  O   GLN A  15      92.493  -2.033  -5.465  1.00 80.82           O  
ATOM     95  CB  GLN A  15      94.670  -0.223  -6.708  1.00 81.70           C  
ATOM     96  CG  GLN A  15      95.488   1.059  -6.641  1.00 82.10           C  
ATOM     97  CD  GLN A  15      96.953   0.825  -7.017  1.00 82.34           C  
ATOM     98  OE1 GLN A  15      97.286   0.676  -8.192  1.00 89.79           O  
ATOM     99  NE2 GLN A  15      97.829   0.801  -6.024  1.00 81.99           N  
ATOM    100  N   LEU A  16      92.000  -1.950  -7.658  1.00 80.74           N  
ATOM    101  CA  LEU A  16      91.504  -3.311  -7.760  1.00 80.54           C  
ATOM    102  C   LEU A  16      92.648  -4.144  -8.308  1.00 80.33           C  
ATOM    103  O   LEU A  16      93.016  -3.970  -9.458  1.00 81.01           O  
ATOM    104  CB  LEU A  16      90.318  -3.340  -8.727  1.00 80.62           C  
ATOM    105  CG  LEU A  16      89.757  -4.710  -9.080  1.00 81.07           C  
ATOM    106  CD1 LEU A  16      89.387  -5.471  -7.802  1.00 80.25           C  
ATOM    107  CD2 LEU A  16      88.566  -4.547 -10.018  1.00 80.36           C  
ATOM    108  N   ILE A  17      93.220  -5.020  -7.487  1.00 80.83           N  
ATOM    109  CA  ILE A  17      94.345  -5.860  -7.899  1.00 81.21           C  
ATOM    110  C   ILE A  17      93.842  -7.215  -8.404  1.00 81.85           C  
ATOM    111  O   ILE A  17      93.195  -7.957  -7.668  1.00 82.52           O  
ATOM    112  CB  ILE A  17      95.371  -6.007  -6.756  1.00 80.89           C  
ATOM    113  CG1 ILE A  17      96.120  -4.684  -6.595  1.00 83.65           C  
ATOM    114  CG2 ILE A  17      96.362  -7.135  -7.023  1.00 77.49           C  
ATOM    115  CD1 ILE A  17      97.101  -4.675  -5.446  1.00 93.31           C  
ATOM    116  N   VAL A  18      94.118  -7.508  -9.674  1.00 83.50           N  
ATOM    117  CA  VAL A  18      93.686  -8.746 -10.309  1.00 85.23           C  
ATOM    118  C   VAL A  18      94.915  -9.545 -10.749  1.00 87.22           C  
ATOM    119  O   VAL A  18      95.694  -9.053 -11.562  1.00 87.05           O  
ATOM    120  CB  VAL A  18      92.805  -8.466 -11.531  1.00 84.39           C  
ATOM    121  N   PRO A  19      95.084 -10.779 -10.224  1.00 89.80           N  
ATOM    122  CA  PRO A  19      96.232 -11.660 -10.480  1.00 91.47           C  
ATOM    123  C   PRO A  19      97.060 -11.440 -11.762  1.00 92.89           C  
ATOM    124  O   PRO A  19      98.177 -10.927 -11.667  1.00 93.52           O  
ATOM    125  CB  PRO A  19      95.592 -13.053 -10.442  1.00 91.54           C  
ATOM    126  CG  PRO A  19      94.548 -12.918  -9.347  1.00 91.63           C  
ATOM    127  CD  PRO A  19      94.133 -11.447  -9.306  1.00 89.86           C  
ATOM    128  N   ASP A  20      96.531 -11.793 -12.934  1.00 94.03           N  
ATOM    129  CA  ASP A  20      97.299 -11.703 -14.184  1.00 94.71           C  
ATOM    130  C   ASP A  20      96.985 -10.427 -14.982  1.00 96.01           C  
ATOM    131  O   ASP A  20      97.068 -10.436 -16.213  1.00 96.86           O  
ATOM    132  CB  ASP A  20      97.065 -12.958 -15.045  1.00 93.61           C  
ATOM    133  N   ARG A  21      96.650  -9.335 -14.286  1.00 97.07           N  
ATOM    134  CA  ARG A  21      96.317  -8.049 -14.925  1.00 97.49           C  
ATOM    135  C   ARG A  21      96.895  -6.866 -14.137  1.00 98.36           C  
ATOM    136  O   ARG A  21      97.177  -6.987 -12.949  1.00 97.86           O  
ATOM    137  CB  ARG A  21      94.797  -7.903 -15.055  1.00 96.60           C  
ATOM    138  N   ALA A  22      97.086  -5.732 -14.811  1.00100.32           N  
ATOM    139  CA  ALA A  22      97.581  -4.517 -14.157  1.00101.58           C  
ATOM    140  C   ALA A  22      96.486  -3.937 -13.242  1.00103.38           C  
ATOM    141  O   ALA A  22      95.303  -4.195 -13.445  1.00102.91           O  
ATOM    142  CB  ALA A  22      98.027  -3.476 -15.192  1.00100.15           C  
ATOM    143  N   PRO A  23      96.878  -3.174 -12.214  1.00106.86           N  
ATOM    144  CA  PRO A  23      95.952  -2.525 -11.286  1.00107.14           C  
ATOM    145  C   PRO A  23      94.997  -1.555 -11.968  1.00106.67           C  
ATOM    146  O   PRO A  23      95.382  -0.899 -12.925  1.00107.13           O  
ATOM    147  CB  PRO A  23      96.876  -1.727 -10.351  1.00106.83           C  
ATOM    148  CG  PRO A  23      98.216  -2.249 -10.546  1.00107.09           C  
ATOM    149  CD  PRO A  23      98.284  -2.896 -11.874  1.00107.13           C  
ATOM    150  N   VAL A  24      93.773  -1.466 -11.454  1.00105.68           N  
ATOM    151  CA  VAL A  24      92.753  -0.555 -11.962  1.00104.32           C  
ATOM    152  C   VAL A  24      92.387   0.444 -10.858  1.00102.99           C  
ATOM    153  O   VAL A  24      91.901   0.037  -9.812  1.00103.38           O  
ATOM    154  CB  VAL A  24      91.494  -1.337 -12.357  1.00103.86           C  
ATOM    155  CG1 VAL A  24      90.441  -0.401 -12.918  1.00103.02           C  
ATOM    156  CG2 VAL A  24      91.840  -2.435 -13.344  1.00103.84           C  
ATOM    157  N   PRO A  25      92.621   1.749 -11.076  1.00100.96           N  
ATOM    158  CA  PRO A  25      92.271   2.699 -10.027  1.00 98.93           C  
ATOM    159  C   PRO A  25      90.767   2.913  -9.950  1.00 96.83           C  
ATOM    160  O   PRO A  25      90.081   2.848 -10.967  1.00 97.47           O  
ATOM    161  CB  PRO A  25      92.991   3.974 -10.454  1.00 98.88           C  
ATOM    162  CG  PRO A  25      93.060   3.881 -11.920  1.00 99.70           C  
ATOM    163  CD  PRO A  25      93.191   2.425 -12.254  1.00100.77           C  
ATOM    164  N   LEU A  26      90.273   3.144  -8.738  1.00 94.36           N  
ATOM    165  CA  LEU A  26      88.849   3.365  -8.475  1.00 91.70           C  
ATOM    166  C   LEU A  26      88.662   4.156  -7.184  1.00 88.79           C  
ATOM    167  O   LEU A  26      89.516   4.121  -6.312  1.00 87.95           O  
ATOM    168  CB  LEU A  26      88.120   2.017  -8.383  1.00 91.87           C  
ATOM    169  CG  LEU A  26      88.613   0.934  -7.405  1.00 89.09           C  
ATOM    170  CD1 LEU A  26      87.987   1.066  -6.059  1.00 90.79           C  
ATOM    171  CD2 LEU A  26      88.283  -0.439  -7.931  1.00 88.27           C  
ATOM    172  N   VAL A  27      87.567   4.897  -7.081  1.00 85.96           N  
ATOM    173  CA  VAL A  27      87.294   5.663  -5.879  1.00 83.99           C  
ATOM    174  C   VAL A  27      86.167   4.993  -5.098  1.00 81.23           C  
ATOM    175  O   VAL A  27      85.176   4.565  -5.667  1.00 81.18           O  
ATOM    176  CB  VAL A  27      86.990   7.135  -6.180  1.00 83.61           C  
ATOM    177  CG1 VAL A  27      85.774   7.262  -7.053  1.00 86.53           C  
ATOM    178  CG2 VAL A  27      86.810   7.907  -4.881  1.00 84.79           C  
ATOM    179  N   ALA A  28      86.352   4.886  -3.787  1.00 78.72           N  
ATOM    180  CA  ALA A  28      85.366   4.275  -2.893  1.00 76.40           C  
ATOM    181  C   ALA A  28      84.809   5.307  -1.958  1.00 74.68           C  
ATOM    182  O   ALA A  28      85.559   6.107  -1.431  1.00 74.63           O  
ATOM    183  CB  ALA A  28      85.995   3.179  -2.079  1.00 75.07           C  
ATOM    184  N   ARG A  29      83.494   5.280  -1.755  1.00 73.77           N  
ATOM    185  CA  ARG A  29      82.831   6.175  -0.825  1.00 72.40           C  
ATOM    186  C   ARG A  29      82.582   5.425   0.480  1.00 69.96           C  
ATOM    187  O   ARG A  29      81.824   4.451   0.526  1.00 69.39           O  
ATOM    188  CB  ARG A  29      81.511   6.657  -1.397  1.00 71.76           C  
ATOM    189  CG  ARG A  29      80.928   7.777  -0.600  1.00 77.35           C  
ATOM    190  CD  ARG A  29      79.601   8.234  -1.098  1.00 85.70           C  
ATOM    191  NE  ARG A  29      78.573   7.226  -0.869  1.00 93.33           N  
ATOM    192  CZ  ARG A  29      77.306   7.490  -0.536  1.00104.38           C  
ATOM    193  NH1 ARG A  29      76.865   8.741  -0.361  1.00106.52           N  
ATOM    194  NH2 ARG A  29      76.464   6.475  -0.352  1.00107.38           N  
ATOM    195  N   LEU A  30      83.231   5.877   1.543  1.00 68.57           N  
ATOM    196  CA  LEU A  30      83.011   5.295   2.875  1.00 68.19           C  
ATOM    197  C   LEU A  30      82.027   6.154   3.637  1.00 67.71           C  
ATOM    198  O   LEU A  30      82.093   7.378   3.547  1.00 68.60           O  
ATOM    199  CB  LEU A  30      84.315   5.247   3.676  1.00 67.22           C  
ATOM    200  CG  LEU A  30      85.505   4.520   3.060  1.00 66.29           C  
ATOM    201  CD1 LEU A  30      86.626   4.563   4.056  1.00 70.51           C  
ATOM    202  CD2 LEU A  30      85.181   3.089   2.701  1.00 66.11           C  
ATOM    203  N   ASP A  31      81.085   5.543   4.339  1.00 67.04           N  
ATOM    204  CA  ASP A  31      80.302   6.322   5.275  1.00 68.99           C  
ATOM    205  C   ASP A  31      79.871   5.596   6.530  1.00 67.70           C  
ATOM    206  O   ASP A  31      79.747   4.367   6.572  1.00 67.84           O  
ATOM    207  CB  ASP A  31      79.153   7.096   4.616  1.00 72.41           C  
ATOM    208  CG  ASP A  31      78.066   6.241   4.078  1.00 78.44           C  
ATOM    209  OD1 ASP A  31      77.507   5.455   4.867  1.00 89.10           O  
ATOM    210  OD2 ASP A  31      77.719   6.443   2.877  1.00 85.60           O  
ATOM    211  N   TYR A  32      79.679   6.407   7.565  1.00 65.34           N  
ATOM    212  CA  TYR A  32      79.374   5.941   8.895  1.00 62.95           C  
ATOM    213  C   TYR A  32      78.241   6.760   9.469  1.00 62.86           C  
ATOM    214  O   TYR A  32      78.277   7.986   9.418  1.00 65.52           O  
ATOM    215  CB  TYR A  32      80.606   6.113   9.773  1.00 61.71           C  
ATOM    216  CG  TYR A  32      80.384   5.659  11.193  1.00 60.62           C  
ATOM    217  CD1 TYR A  32      80.436   4.316  11.519  1.00 61.34           C  
ATOM    218  CD2 TYR A  32      80.108   6.560  12.208  1.00 59.05           C  
ATOM    219  CE1 TYR A  32      80.219   3.867  12.844  1.00 64.78           C  
ATOM    220  CE2 TYR A  32      79.904   6.130  13.524  1.00 61.53           C  
ATOM    221  CZ  TYR A  32      79.953   4.785  13.839  1.00 64.88           C  
ATOM    222  OH  TYR A  32      79.755   4.345  15.139  1.00 64.34           O  
ATOM    223  N   SER A  33      77.264   6.087  10.053  1.00 63.54           N  
ATOM    224  CA  SER A  33      76.108   6.732  10.661  1.00 63.54           C  
ATOM    225  C   SER A  33      75.952   6.286  12.110  1.00 62.13           C  
ATOM    226  O   SER A  33      75.947   5.090  12.374  1.00 60.91           O  
ATOM    227  CB  SER A  33      74.845   6.331   9.899  1.00 63.67           C  
ATOM    228  OG  SER A  33      73.690   6.485  10.719  1.00 73.68           O  
ATOM    229  N   VAL A  34      75.777   7.225  13.043  1.00 61.72           N  
ATOM    230  CA  VAL A  34      75.620   6.835  14.461  1.00 61.56           C  
ATOM    231  C   VAL A  34      74.434   5.905  14.683  1.00 61.88           C  
ATOM    232  O   VAL A  34      74.450   5.156  15.625  1.00 62.08           O  
ATOM    233  CB  VAL A  34      75.547   8.033  15.443  1.00 61.79           C  
ATOM    234  CG1 VAL A  34      76.735   8.952  15.202  1.00 58.22           C  
ATOM    235  CG2 VAL A  34      74.215   8.762  15.324  1.00 57.10           C  
ATOM    236  N   ASP A  35      73.429   5.938  13.807  1.00 64.08           N  
ATOM    237  CA  ASP A  35      72.288   4.974  13.848  1.00 66.13           C  
ATOM    238  C   ASP A  35      72.666   3.527  13.542  1.00 65.47           C  
ATOM    239  O   ASP A  35      71.847   2.639  13.725  1.00 65.50           O  
ATOM    240  CB  ASP A  35      71.221   5.308  12.788  1.00 67.60           C  
ATOM    241  CG  ASP A  35      70.619   6.647  12.969  1.00 73.04           C  
ATOM    242  OD1 ASP A  35      70.933   7.255  14.009  1.00 73.70           O  
ATOM    243  OD2 ASP A  35      69.832   7.075  12.083  1.00 81.41           O  
ATOM    244  N   ASP A  36      73.847   3.306  12.974  1.00 64.07           N  
ATOM    245  CA  ASP A  36      74.330   1.953  12.696  1.00 63.47           C  
ATOM    246  C   ASP A  36      75.767   1.939  13.172  1.00 62.83           C  
ATOM    247  O   ASP A  36      76.699   1.763  12.379  1.00 63.66           O  
ATOM    248  CB  ASP A  36      74.200   1.583  11.215  1.00 63.33           C  
ATOM    249  CG  ASP A  36      74.380   0.083  10.955  1.00 69.70           C  
ATOM    250  OD1 ASP A  36      74.817  -0.651  11.865  1.00 80.55           O  
ATOM    251  OD2 ASP A  36      74.072  -0.379   9.837  1.00 72.14           O  
ATOM    252  N   PRO A  37      75.946   2.082  14.496  1.00 62.10           N  
ATOM    253  CA  PRO A  37      77.221   2.403  15.124  1.00 62.01           C  
ATOM    254  C   PRO A  37      78.342   1.362  15.023  1.00 62.17           C  
ATOM    255  O   PRO A  37      79.484   1.714  15.258  1.00 63.34           O  
ATOM    256  CB  PRO A  37      76.825   2.602  16.578  1.00 60.64           C  
ATOM    257  CG  PRO A  37      75.707   1.728  16.749  1.00 59.78           C  
ATOM    258  CD  PRO A  37      74.916   1.861  15.521  1.00 61.76           C  
ATOM    259  N   TYR A  38      78.020   0.108  14.705  1.00 61.95           N  
ATOM    260  CA  TYR A  38      79.048  -0.911  14.524  1.00 60.99           C  
ATOM    261  C   TYR A  38      79.455  -1.096  13.064  1.00 62.95           C  
ATOM    262  O   TYR A  38      80.393  -1.841  12.799  1.00 65.33           O  
ATOM    263  CB  TYR A  38      78.584  -2.269  15.036  1.00 61.13           C  
ATOM    264  CG  TYR A  38      78.333  -2.376  16.516  1.00 58.68           C  
ATOM    265  CD1 TYR A  38      79.388  -2.467  17.413  1.00 59.52           C  
ATOM    266  CD2 TYR A  38      77.024  -2.432  17.026  1.00 62.28           C  
ATOM    267  CE1 TYR A  38      79.159  -2.572  18.780  1.00 64.65           C  
ATOM    268  CE2 TYR A  38      76.782  -2.541  18.390  1.00 58.02           C  
ATOM    269  CZ  TYR A  38      77.857  -2.621  19.262  1.00 60.44           C  
ATOM    270  OH  TYR A  38      77.652  -2.713  20.613  1.00 63.46           O  
ATOM    271  N   ALA A  39      78.798  -0.398  12.136  1.00 63.94           N  
ATOM    272  CA  ALA A  39      78.985  -0.611  10.696  1.00 63.55           C  
ATOM    273  C   ALA A  39      79.725   0.517   9.957  1.00 64.22           C  
ATOM    274  O   ALA A  39      79.747   1.651  10.405  1.00 65.61           O  
ATOM    275  CB  ALA A  39      77.624  -0.823  10.070  1.00 60.60           C  
ATOM    276  N   ILE A  40      80.333   0.160   8.831  1.00 66.06           N  
ATOM    277  CA  ILE A  40      80.906   1.076   7.871  1.00 67.58           C  
ATOM    278  C   ILE A  40      80.339   0.584   6.551  1.00 68.88           C  
ATOM    279  O   ILE A  40      80.437  -0.616   6.244  1.00 69.21           O  
ATOM    280  CB  ILE A  40      82.407   0.923   7.793  1.00 68.02           C  
ATOM    281  CG1 ILE A  40      83.069   1.457   9.048  1.00 72.21           C  
ATOM    282  CG2 ILE A  40      82.949   1.724   6.613  1.00 69.38           C  
ATOM    283  CD1 ILE A  40      83.615   2.876   8.900  1.00 74.56           C  
ATOM    284  N   ARG A  41      79.707   1.482   5.802  1.00 69.85           N  
ATOM    285  CA  ARG A  41      79.286   1.193   4.425  1.00 68.99           C  
ATOM    286  C   ARG A  41      80.432   1.604   3.490  1.00 67.29           C  
ATOM    287  O   ARG A  41      81.149   2.559   3.767  1.00 69.88           O  
ATOM    288  CB  ARG A  41      78.013   1.965   4.077  1.00 68.94           C  
ATOM    289  CG  ARG A  41      76.749   1.404   4.700  1.00 69.09           C  
ATOM    290  CD  ARG A  41      75.562   2.327   4.444  1.00 69.47           C  
ATOM    291  NE  ARG A  41      74.305   1.741   4.904  1.00 76.00           N  
ATOM    292  N   ALA A  42      80.637   0.873   2.412  1.00 67.01           N  
ATOM    293  CA  ALA A  42      81.658   1.238   1.413  1.00 69.26           C  
ATOM    294  C   ALA A  42      81.084   1.007   0.024  1.00 70.12           C  
ATOM    295  O   ALA A  42      80.707  -0.114  -0.299  1.00 69.46           O  
ATOM    296  CB  ALA A  42      82.939   0.436   1.601  1.00 67.35           C  
ATOM    297  N   ALA A  43      80.984   2.077  -0.768  1.00 71.52           N  
ATOM    298  CA  ALA A  43      80.463   1.996  -2.128  1.00 73.25           C  
ATOM    299  C   ALA A  43      81.623   2.107  -3.125  1.00 75.78           C  
ATOM    300  O   ALA A  43      82.206   3.175  -3.292  1.00 77.78           O  
ATOM    301  CB  ALA A  43      79.436   3.080  -2.367  1.00 71.93           C  
ATOM    302  N   PHE A  44      81.958   0.991  -3.766  1.00 77.55           N  
ATOM    303  CA  PHE A  44      83.045   0.935  -4.736  1.00 79.21           C  
ATOM    304  C   PHE A  44      82.471   1.104  -6.126  1.00 79.76           C  
ATOM    305  O   PHE A  44      81.367   0.642  -6.397  1.00 79.06           O  
ATOM    306  CB  PHE A  44      83.743  -0.420  -4.678  1.00 79.56           C  
ATOM    307  CG  PHE A  44      84.329  -0.751  -3.336  1.00 80.85           C  
ATOM    308  CD1 PHE A  44      83.551  -1.353  -2.353  1.00 88.99           C  
ATOM    309  CD2 PHE A  44      85.666  -0.501  -3.059  1.00 80.57           C  
ATOM    310  CE1 PHE A  44      84.096  -1.684  -1.100  1.00 85.51           C  
ATOM    311  CE2 PHE A  44      86.213  -0.835  -1.817  1.00 81.03           C  
ATOM    312  CZ  PHE A  44      85.428  -1.422  -0.843  1.00 82.97           C  
ATOM    313  N   HIS A  45      83.213   1.776  -6.996  1.00 81.88           N  
ATOM    314  CA  HIS A  45      82.828   1.890  -8.401  1.00 85.47           C  
ATOM    315  C   HIS A  45      84.035   2.215  -9.271  1.00 86.15           C  
ATOM    316  O   HIS A  45      84.929   2.964  -8.854  1.00 85.14           O  
ATOM    317  CB  HIS A  45      81.737   2.937  -8.599  1.00 86.90           C  
ATOM    318  CG  HIS A  45      82.191   4.339  -8.344  1.00 93.89           C  
ATOM    319  ND1 HIS A  45      82.372   5.263  -9.356  1.00100.82           N  
ATOM    320  CD2 HIS A  45      82.513   4.973  -7.191  1.00 96.12           C  
ATOM    321  CE1 HIS A  45      82.778   6.407  -8.833  1.00 98.60           C  
ATOM    322  NE2 HIS A  45      82.872   6.256  -7.522  1.00 99.15           N  
ATOM    323  N   VAL A  46      84.038   1.653 -10.480  1.00 87.04           N  
ATOM    324  CA  VAL A  46      85.140   1.815 -11.422  1.00 88.09           C  
ATOM    325  C   VAL A  46      84.833   2.863 -12.494  1.00 88.59           C  
ATOM    326  O   VAL A  46      83.999   2.624 -13.355  1.00 90.19           O  
ATOM    327  CB  VAL A  46      85.440   0.481 -12.125  1.00 88.22           C  
ATOM    328  CG1 VAL A  46      86.638   0.630 -13.052  1.00 85.10           C  
ATOM    329  CG2 VAL A  46      85.679  -0.612 -11.085  1.00 91.05           C  
ATOM    330  N   GLY A  47      85.516   4.009 -12.445  1.00 88.54           N  
ATOM    331  CA  GLY A  47      85.349   5.071 -13.448  1.00 88.72           C  
ATOM    332  C   GLY A  47      83.977   5.732 -13.414  1.00 89.24           C  
ATOM    333  O   GLY A  47      83.548   6.226 -12.371  1.00 90.72           O  
ATOM    334  N   ASP A  48      83.278   5.714 -14.550  1.00 89.30           N  
ATOM    335  CA  ASP A  48      81.926   6.292 -14.669  1.00 88.83           C  
ATOM    336  C   ASP A  48      80.828   5.296 -14.237  1.00 88.12           C  
ATOM    337  O   ASP A  48      79.763   5.246 -14.852  1.00 87.91           O  
ATOM    338  CB  ASP A  48      81.649   6.711 -16.128  1.00 88.78           C  
ATOM    339  CG  ASP A  48      82.695   7.662 -16.695  1.00 89.45           C  
ATOM    340  OD1 ASP A  48      83.756   7.837 -16.062  1.00 91.49           O  
ATOM    341  OD2 ASP A  48      82.452   8.225 -17.788  1.00 89.72           O  
ATOM    342  N   ASP A  49      81.071   4.519 -13.182  1.00 87.20           N  
ATOM    343  CA  ASP A  49      80.154   3.443 -12.797  1.00 86.59           C  
ATOM    344  C   ASP A  49      79.307   3.756 -11.574  1.00 85.67           C  
ATOM    345  O   ASP A  49      79.788   4.359 -10.610  1.00 83.78           O  
ATOM    346  CB  ASP A  49      80.926   2.131 -12.534  1.00 87.27           C  
ATOM    347  CG  ASP A  49      81.295   1.374 -13.819  1.00 87.91           C  
ATOM    348  OD1 ASP A  49      81.060   1.893 -14.943  1.00 85.24           O  
ATOM    349  OD2 ASP A  49      81.830   0.249 -13.687  1.00 84.22           O  
ATOM    350  N   GLU A  50      78.042   3.326 -11.631  1.00 85.00           N  
ATOM    351  CA  GLU A  50      77.152   3.379 -10.480  1.00 84.27           C  
ATOM    352  C   GLU A  50      77.734   2.393  -9.454  1.00 84.24           C  
ATOM    353  O   GLU A  50      78.302   1.367  -9.824  1.00 83.89           O  
ATOM    354  CB  GLU A  50      75.711   3.018 -10.867  1.00 82.92           C  
ATOM    355  N   PRO A  51      77.672   2.728  -8.162  1.00 85.57           N  
ATOM    356  CA  PRO A  51      78.291   1.823  -7.188  1.00 84.80           C  
ATOM    357  C   PRO A  51      77.531   0.541  -6.816  1.00 84.96           C  
ATOM    358  O   PRO A  51      76.337   0.391  -7.122  1.00 84.94           O  
ATOM    359  CB  PRO A  51      78.467   2.716  -5.944  1.00 84.71           C  
ATOM    360  CG  PRO A  51      78.129   4.120  -6.390  1.00 86.05           C  
ATOM    361  CD  PRO A  51      77.156   3.940  -7.506  1.00 86.70           C  
ATOM    362  N   VAL A  52      78.307  -0.382  -6.240  1.00 84.70           N  
ATOM    363  CA  VAL A  52      77.887  -1.590  -5.515  1.00 84.37           C  
ATOM    364  C   VAL A  52      78.309  -1.285  -4.087  1.00 83.98           C  
ATOM    365  O   VAL A  52      79.414  -0.789  -3.865  1.00 83.47           O  
ATOM    366  CB  VAL A  52      78.601  -2.888  -6.005  1.00 84.42           C  
ATOM    367  CG1 VAL A  52      80.113  -2.712  -6.054  1.00 84.47           C  
ATOM    368  CG2 VAL A  52      78.236  -4.080  -5.101  1.00 84.37           C  
ATOM    369  N   GLU A  53      77.438  -1.583  -3.124  1.00 84.47           N  
ATOM    370  CA  GLU A  53      77.688  -1.242  -1.721  1.00 85.63           C  
ATOM    371  C   GLU A  53      77.981  -2.450  -0.830  1.00 83.19           C  
ATOM    372  O   GLU A  53      77.216  -3.412  -0.798  1.00 82.15           O  
ATOM    373  CB  GLU A  53      76.502  -0.480  -1.135  1.00 85.63           C  
ATOM    374  CG  GLU A  53      76.883   0.309   0.134  1.00 92.71           C  
ATOM    375  CD  GLU A  53      75.680   0.876   0.895  1.00 92.99           C  
ATOM    376  OE1 GLU A  53      74.740   0.100   1.240  1.00101.25           O  
ATOM    377  OE2 GLU A  53      75.703   2.100   1.171  1.00 99.36           O  
ATOM    378  N   TRP A  54      79.093  -2.370  -0.100  1.00 82.52           N  
ATOM    379  CA  TRP A  54      79.476  -3.373   0.885  1.00 82.20           C  
ATOM    380  C   TRP A  54      79.265  -2.750   2.223  1.00 79.37           C  
ATOM    381  O   TRP A  54      79.472  -1.557   2.386  1.00 79.78           O  
ATOM    382  CB  TRP A  54      80.947  -3.703   0.789  1.00 86.63           C  
ATOM    383  CG  TRP A  54      81.350  -4.502  -0.370  1.00 93.88           C  
ATOM    384  CD1 TRP A  54      80.682  -4.670  -1.545  1.00 99.73           C  
ATOM    385  CD2 TRP A  54      82.583  -5.188  -0.507  1.00101.09           C  
ATOM    386  NE1 TRP A  54      81.407  -5.463  -2.387  1.00101.34           N  
ATOM    387  CE2 TRP A  54      82.586  -5.792  -1.774  1.00103.09           C  
ATOM    388  CE3 TRP A  54      83.689  -5.371   0.335  1.00103.08           C  
ATOM    389  CZ2 TRP A  54      83.658  -6.570  -2.229  1.00102.38           C  
ATOM    390  CZ3 TRP A  54      84.754  -6.148  -0.116  1.00100.49           C  
ATOM    391  CH2 TRP A  54      84.728  -6.738  -1.382  1.00 99.93           C  
ATOM    392  N   ILE A  55      78.882  -3.564   3.194  1.00 75.70           N  
ATOM    393  CA  ILE A  55      78.701  -3.104   4.550  1.00 73.37           C  
ATOM    394  C   ILE A  55      79.425  -4.059   5.487  1.00 72.58           C  
ATOM    395  O   ILE A  55      79.205  -5.238   5.433  1.00 73.79           O  
ATOM    396  CB  ILE A  55      77.190  -2.991   4.892  1.00 72.58           C  
ATOM    397  CG1 ILE A  55      77.016  -2.412   6.292  1.00 74.55           C  
ATOM    398  CG2 ILE A  55      76.499  -4.321   4.804  1.00 70.19           C  
ATOM    399  CD1 ILE A  55      75.579  -2.196   6.686  1.00 83.19           C  
ATOM    400  N   PHE A  56      80.304  -3.563   6.337  1.00 72.05           N  
ATOM    401  CA  PHE A  56      80.966  -4.444   7.289  1.00 71.58           C  
ATOM    402  C   PHE A  56      81.218  -3.788   8.618  1.00 68.53           C  
ATOM    403  O   PHE A  56      81.059  -2.589   8.772  1.00 69.55           O  
ATOM    404  CB  PHE A  56      82.256  -5.020   6.701  1.00 76.04           C  
ATOM    405  CG  PHE A  56      83.093  -4.029   5.987  1.00 76.93           C  
ATOM    406  CD1 PHE A  56      83.813  -3.096   6.692  1.00 79.29           C  
ATOM    407  CD2 PHE A  56      83.177  -4.049   4.597  1.00 84.41           C  
ATOM    408  CE1 PHE A  56      84.585  -2.164   6.021  1.00 88.11           C  
ATOM    409  CE2 PHE A  56      83.953  -3.139   3.927  1.00 86.54           C  
ATOM    410  CZ  PHE A  56      84.655  -2.187   4.639  1.00 85.29           C  
ATOM    411  N   ALA A  57      81.622  -4.595   9.580  1.00 65.10           N  
ATOM    412  CA  ALA A  57      81.911  -4.126  10.918  1.00 61.98           C  
ATOM    413  C   ALA A  57      83.073  -3.137  10.914  1.00 62.11           C  
ATOM    414  O   ALA A  57      84.139  -3.388  10.341  1.00 62.73           O  
ATOM    415  CB  ALA A  57      82.205  -5.316  11.832  1.00 57.63           C  
ATOM    416  N   ARG A  58      82.855  -2.000  11.552  1.00 62.41           N  
ATOM    417  CA  ARG A  58      83.917  -1.016  11.742  1.00 62.28           C  
ATOM    418  C   ARG A  58      85.164  -1.618  12.379  1.00 64.62           C  
ATOM    419  O   ARG A  58      86.283  -1.355  11.918  1.00 66.92           O  
ATOM    420  CB  ARG A  58      83.405   0.097  12.614  1.00 61.85           C  
ATOM    421  CG  ARG A  58      84.491   1.033  13.083  1.00 63.12           C  
ATOM    422  CD  ARG A  58      83.915   2.344  13.614  1.00 64.25           C  
ATOM    423  NE  ARG A  58      83.217   2.198  14.884  1.00 62.29           N  
ATOM    424  CZ  ARG A  58      82.889   3.205  15.680  1.00 64.47           C  
ATOM    425  NH1 ARG A  58      83.177   4.451  15.345  1.00 71.53           N  
ATOM    426  NH2 ARG A  58      82.259   2.967  16.826  1.00 64.24           N  
ATOM    427  N   GLU A  59      84.983  -2.443  13.415  1.00 64.65           N  
ATOM    428  CA  GLU A  59      86.126  -3.048  14.115  1.00 65.09           C  
ATOM    429  C   GLU A  59      87.001  -3.910  13.196  1.00 65.99           C  
ATOM    430  O   GLU A  59      88.193  -4.053  13.407  1.00 66.22           O  
ATOM    431  CB  GLU A  59      85.651  -3.871  15.321  1.00 63.05           C  
ATOM    432  CG  GLU A  59      85.041  -5.230  14.970  1.00 69.40           C  
ATOM    433  CD  GLU A  59      86.057  -6.364  14.929  1.00 71.98           C  
ATOM    434  OE1 GLU A  59      87.092  -6.229  15.603  1.00 81.60           O  
ATOM    435  OE2 GLU A  59      85.832  -7.384  14.254  1.00 70.42           O  
ATOM    436  N   LEU A  60      86.402  -4.483  12.165  1.00 67.60           N  
ATOM    437  CA  LEU A  60      87.146  -5.370  11.289  1.00 68.87           C  
ATOM    438  C   LEU A  60      88.197  -4.550  10.532  1.00 69.88           C  
ATOM    439  O   LEU A  60      89.325  -5.005  10.328  1.00 70.44           O  
ATOM    440  CB  LEU A  60      86.203  -6.057  10.333  1.00 68.15           C  
ATOM    441  CG  LEU A  60      86.762  -7.187   9.500  1.00 74.27           C  
ATOM    442  CD1 LEU A  60      86.798  -8.508  10.288  1.00 76.81           C  
ATOM    443  CD2 LEU A  60      85.883  -7.350   8.261  1.00 77.35           C  
ATOM    444  N   LEU A  61      87.841  -3.324  10.153  1.00 69.65           N  
ATOM    445  CA  LEU A  61      88.769  -2.452   9.441  1.00 69.66           C  
ATOM    446  C   LEU A  61      89.835  -1.886  10.375  1.00 67.64           C  
ATOM    447  O   LEU A  61      90.977  -1.741   9.985  1.00 69.05           O  
ATOM    448  CB  LEU A  61      88.013  -1.321   8.737  1.00 70.54           C  
ATOM    449  CG  LEU A  61      88.835  -0.387   7.833  1.00 75.84           C  
ATOM    450  CD1 LEU A  61      89.424  -1.170   6.669  1.00 74.91           C  
ATOM    451  CD2 LEU A  61      88.024   0.832   7.295  1.00 75.34           C  
ATOM    452  N   THR A  62      89.470  -1.568  11.609  1.00 66.83           N  
ATOM    453  CA  THR A  62      90.437  -1.098  12.607  1.00 65.41           C  
ATOM    454  C   THR A  62      91.494  -2.159  12.891  1.00 65.49           C  
ATOM    455  O   THR A  62      92.685  -1.844  12.981  1.00 66.94           O  
ATOM    456  CB  THR A  62      89.720  -0.661  13.913  1.00 65.48           C  
ATOM    457  OG1 THR A  62      89.024   0.566  13.664  1.00 70.38           O  
ATOM    458  CG2 THR A  62      90.696  -0.379  15.023  1.00 62.81           C  
ATOM    459  N   VAL A  63      91.054  -3.408  13.017  1.00 65.38           N  
ATOM    460  CA  VAL A  63      91.934  -4.541  13.318  1.00 64.73           C  
ATOM    461  C   VAL A  63      92.790  -4.905  12.093  1.00 66.35           C  
ATOM    462  O   VAL A  63      93.984  -5.175  12.226  1.00 66.92           O  
ATOM    463  CB  VAL A  63      91.075  -5.763  13.793  1.00 65.28           C  
ATOM    464  CG1 VAL A  63      91.879  -7.087  13.827  1.00 58.82           C  
ATOM    465  CG2 VAL A  63      90.410  -5.438  15.150  1.00 62.21           C  
ATOM    466  N   GLY A  64      92.154  -4.916  10.913  1.00 67.09           N  
ATOM    467  CA  GLY A  64      92.782  -5.268   9.626  1.00 65.99           C  
ATOM    468  C   GLY A  64      93.922  -4.370   9.177  1.00 67.14           C  
ATOM    469  O   GLY A  64      94.775  -4.785   8.384  1.00 68.17           O  
ATOM    470  N   ILE A  65      93.932  -3.125   9.648  1.00 67.26           N  
ATOM    471  CA  ILE A  65      95.054  -2.216   9.413  1.00 66.81           C  
ATOM    472  C   ILE A  65      96.277  -2.705  10.211  1.00 68.48           C  
ATOM    473  O   ILE A  65      97.400  -2.490   9.797  1.00 70.25           O  
ATOM    474  CB  ILE A  65      94.698  -0.743   9.845  1.00 67.01           C  
ATOM    475  CG1 ILE A  65      93.677  -0.114   8.896  1.00 65.48           C  
ATOM    476  CG2 ILE A  65      95.918   0.129   9.862  1.00 67.80           C  
ATOM    477  CD1 ILE A  65      92.991   1.126   9.443  1.00 62.87           C  
ATOM    478  N   ILE A  66      96.047  -3.365  11.344  1.00 68.76           N  
ATOM    479  CA  ILE A  66      97.116  -3.852  12.212  1.00 68.64           C  
ATOM    480  C   ILE A  66      97.517  -5.307  11.938  1.00 70.58           C  
ATOM    481  O   ILE A  66      98.704  -5.651  12.022  1.00 72.37           O  
ATOM    482  CB  ILE A  66      96.691  -3.773  13.680  1.00 66.88           C  
ATOM    483  CG1 ILE A  66      96.268  -2.357  14.028  1.00 66.70           C  
ATOM    484  CG2 ILE A  66      97.812  -4.222  14.571  1.00 63.91           C  
ATOM    485  CD1 ILE A  66      97.300  -1.281  13.634  1.00 64.99           C  
ATOM    486  N   ARG A  67      96.542  -6.169  11.662  1.00 70.53           N  
ATOM    487  CA  ARG A  67      96.839  -7.586  11.426  1.00 71.17           C  
ATOM    488  C   ARG A  67      95.760  -8.313  10.636  1.00 72.19           C  
ATOM    489  O   ARG A  67      94.586  -7.946  10.676  1.00 73.05           O  
ATOM    490  CB  ARG A  67      97.070  -8.351  12.747  1.00 70.02           C  
ATOM    491  CG  ARG A  67      95.838  -8.831  13.512  1.00 67.69           C  
ATOM    492  CD  ARG A  67      96.238  -9.718  14.725  1.00 73.22           C  
ATOM    493  NE  ARG A  67      96.724 -11.060  14.361  1.00 73.99           N  
ATOM    494  CZ  ARG A  67      97.397 -11.864  15.178  1.00 74.33           C  
ATOM    495  N   GLU A  68      96.158  -9.395   9.976  1.00 72.99           N  
ATOM    496  CA  GLU A  68      95.233 -10.165   9.145  1.00 73.72           C  
ATOM    497  C   GLU A  68      94.051 -10.643   9.968  1.00 73.05           C  
ATOM    498  O   GLU A  68      94.211 -11.220  11.052  1.00 73.90           O  
ATOM    499  CB  GLU A  68      95.940 -11.332   8.497  1.00 76.00           C  
ATOM    500  CG  GLU A  68      95.172 -11.999   7.362  1.00 84.19           C  
ATOM    501  CD  GLU A  68      94.652 -13.383   7.685  1.00 94.31           C  
ATOM    502  OE1 GLU A  68      94.459 -13.725   8.887  1.00 94.88           O  
ATOM    503  OE2 GLU A  68      94.440 -14.126   6.697  1.00 98.39           O  
ATOM    504  N   THR A  69      92.861 -10.348   9.472  1.00 72.10           N  
ATOM    505  CA  THR A  69      91.627 -10.694  10.161  1.00 71.14           C  
ATOM    506  C   THR A  69      90.543 -10.902   9.122  1.00 72.48           C  
ATOM    507  O   THR A  69      90.788 -10.742   7.938  1.00 72.80           O  
ATOM    508  CB  THR A  69      91.183  -9.598  11.173  1.00 70.81           C  
ATOM    509  OG1 THR A  69      90.232 -10.142  12.087  1.00 68.97           O  
ATOM    510  CG2 THR A  69      90.563  -8.373  10.484  1.00 68.15           C  
ATOM    511  N   GLY A  70      89.349 -11.278   9.560  1.00 73.71           N  
ATOM    512  CA  GLY A  70      88.252 -11.481   8.629  1.00 75.46           C  
ATOM    513  C   GLY A  70      86.952 -11.846   9.306  1.00 77.36           C  
ATOM    514  O   GLY A  70      86.919 -12.125  10.500  1.00 77.49           O  
ATOM    515  N   GLU A  71      85.877 -11.834   8.527  1.00 79.91           N  
ATOM    516  CA  GLU A  71      84.553 -12.181   9.004  1.00 83.00           C  
ATOM    517  C   GLU A  71      83.788 -12.707   7.816  1.00 83.69           C  
ATOM    518  O   GLU A  71      83.538 -11.955   6.880  1.00 84.82           O  
ATOM    519  CB  GLU A  71      83.864 -10.933   9.552  1.00 82.23           C  
ATOM    520  CG  GLU A  71      82.441 -11.127  10.103  1.00 85.82           C  
ATOM    521  CD  GLU A  71      81.827  -9.816  10.659  1.00 89.52           C  
ATOM    522  OE1 GLU A  71      81.801  -8.770   9.950  1.00 99.80           O  
ATOM    523  OE2 GLU A  71      81.355  -9.836  11.817  1.00103.86           O  
ATOM    524  N   GLY A  72      83.439 -13.994   7.840  1.00 84.25           N  
ATOM    525  CA  GLY A  72      82.711 -14.617   6.743  1.00 83.85           C  
ATOM    526  C   GLY A  72      83.518 -14.526   5.464  1.00 83.91           C  
ATOM    527  O   GLY A  72      84.618 -15.074   5.374  1.00 84.52           O  
ATOM    528  N   ASP A  73      83.003 -13.789   4.489  1.00 83.11           N  
ATOM    529  CA  ASP A  73      83.664 -13.679   3.179  1.00 84.40           C  
ATOM    530  C   ASP A  73      84.627 -12.500   3.043  1.00 84.38           C  
ATOM    531  O   ASP A  73      85.464 -12.487   2.130  1.00 85.34           O  
ATOM    532  CB  ASP A  73      82.626 -13.678   2.065  1.00 84.92           C  
ATOM    533  CG  ASP A  73      81.888 -15.005   1.983  1.00 95.43           C  
ATOM    534  OD1 ASP A  73      82.526 -16.067   2.212  1.00105.36           O  
ATOM    535  OD2 ASP A  73      80.668 -14.994   1.701  1.00110.87           O  
ATOM    536  N   VAL A  74      84.521 -11.529   3.950  1.00 84.71           N  
ATOM    537  CA  VAL A  74      85.440 -10.393   3.977  1.00 84.56           C  
ATOM    538  C   VAL A  74      86.741 -10.806   4.661  1.00 83.89           C  
ATOM    539  O   VAL A  74      86.737 -11.544   5.656  1.00 84.51           O  
ATOM    540  CB  VAL A  74      84.858  -9.174   4.716  1.00 84.90           C  
ATOM    541  CG1 VAL A  74      85.803  -7.978   4.576  1.00 85.49           C  
ATOM    542  CG2 VAL A  74      83.466  -8.816   4.180  1.00 84.94           C  
ATOM    543  N   ARG A  75      87.848 -10.328   4.110  1.00 82.13           N  
ATOM    544  CA  ARG A  75      89.152 -10.636   4.630  1.00 81.28           C  
ATOM    545  C   ARG A  75      90.015  -9.363   4.505  1.00 80.34           C  
ATOM    546  O   ARG A  75      90.140  -8.811   3.421  1.00 81.17           O  
ATOM    547  CB  ARG A  75      89.671 -11.777   3.798  1.00 80.17           C  
ATOM    548  CG  ARG A  75      90.198 -12.931   4.557  1.00 87.27           C  
ATOM    549  CD  ARG A  75      91.695 -12.838   4.723  1.00 96.80           C  
ATOM    550  NE  ARG A  75      92.320 -14.140   4.441  1.00100.73           N  
ATOM    551  CZ  ARG A  75      93.396 -14.346   3.663  1.00107.90           C  
ATOM    552  NH1 ARG A  75      94.017 -13.349   3.014  1.00106.36           N  
ATOM    553  NH2 ARG A  75      93.847 -15.593   3.504  1.00110.84           N  
ATOM    554  N   ILE A  76      90.564  -8.873   5.620  1.00 78.53           N  
ATOM    555  CA  ILE A  76      91.371  -7.648   5.622  1.00 75.33           C  
ATOM    556  C   ILE A  76      92.735  -7.891   6.238  1.00 74.72           C  
ATOM    557  O   ILE A  76      92.829  -8.479   7.302  1.00 75.96           O  
ATOM    558  CB  ILE A  76      90.690  -6.512   6.405  1.00 74.27           C  
ATOM    559  CG1 ILE A  76      89.200  -6.414   6.034  1.00 75.22           C  
ATOM    560  CG2 ILE A  76      91.413  -5.207   6.146  1.00 70.60           C  
ATOM    561  CD1 ILE A  76      88.469  -5.155   6.500  1.00 73.76           C  
ATOM    562  N   TRP A  77      93.785  -7.416   5.583  1.00 74.42           N  
ATOM    563  CA  TRP A  77      95.147  -7.565   6.103  1.00 74.89           C  
ATOM    564  C   TRP A  77      96.063  -6.423   5.660  1.00 74.59           C  
ATOM    565  O   TRP A  77      95.858  -5.831   4.599  1.00 75.20           O  
ATOM    566  CB  TRP A  77      95.748  -8.905   5.675  1.00 74.98           C  
ATOM    567  CG  TRP A  77      96.028  -9.012   4.221  1.00 75.45           C  
ATOM    568  CD1 TRP A  77      97.240  -8.879   3.602  1.00 77.04           C  
ATOM    569  CD2 TRP A  77      95.080  -9.276   3.193  1.00 75.92           C  
ATOM    570  NE1 TRP A  77      97.104  -9.047   2.248  1.00 74.65           N  
ATOM    571  CE2 TRP A  77      95.786  -9.292   1.969  1.00 75.48           C  
ATOM    572  CE3 TRP A  77      93.699  -9.489   3.182  1.00 78.22           C  
ATOM    573  CZ2 TRP A  77      95.156  -9.507   0.749  1.00 75.32           C  
ATOM    574  CZ3 TRP A  77      93.072  -9.702   1.967  1.00 78.81           C  
ATOM    575  CH2 TRP A  77      93.801  -9.715   0.767  1.00 78.12           C  
ATOM    576  N   PRO A  78      97.085  -6.126   6.464  1.00 74.58           N  
ATOM    577  CA  PRO A  78      98.010  -5.067   6.115  1.00 76.23           C  
ATOM    578  C   PRO A  78      99.112  -5.531   5.175  1.00 78.00           C  
ATOM    579  O   PRO A  78      99.299  -6.733   4.983  1.00 78.30           O  
ATOM    580  CB  PRO A  78      98.598  -4.679   7.467  1.00 76.05           C  
ATOM    581  CG  PRO A  78      98.601  -5.957   8.244  1.00 75.32           C  
ATOM    582  CD  PRO A  78      97.437  -6.762   7.745  1.00 75.09           C  
ATOM    583  N   SER A  79      99.837  -4.561   4.618  1.00 79.77           N  
ATOM    584  CA  SER A  79     100.923  -4.797   3.660  1.00 80.95           C  
ATOM    585  C   SER A  79     101.849  -3.584   3.606  1.00 81.94           C  
ATOM    586  O   SER A  79     101.478  -2.511   4.069  1.00 82.88           O  
ATOM    587  CB  SER A  79     100.294  -5.060   2.279  1.00 80.50           C  
ATOM    588  OG  SER A  79     101.023  -4.489   1.201  1.00 88.39           O  
ATOM    589  N   GLN A  80     103.041  -3.757   3.040  1.00 83.12           N  
ATOM    590  CA  GLN A  80     103.996  -2.653   2.856  1.00 83.52           C  
ATOM    591  C   GLN A  80     104.236  -2.392   1.366  1.00 83.39           C  
ATOM    592  O   GLN A  80     104.107  -3.298   0.539  1.00 83.13           O  
ATOM    593  CB  GLN A  80     105.326  -2.947   3.571  1.00 84.22           C  
ATOM    594  CG  GLN A  80     105.279  -2.860   5.119  1.00 88.15           C  
ATOM    595  CD  GLN A  80     105.425  -1.436   5.684  1.00 93.97           C  
ATOM    596  OE1 GLN A  80     105.900  -0.512   5.007  1.00 93.62           O  
ATOM    597  NE2 GLN A  80     105.030  -1.266   6.944  1.00 93.71           N  
ATOM    598  N   ASP A  81     104.554  -1.140   1.038  1.00 83.94           N  
ATOM    599  CA  ASP A  81     104.974  -0.726  -0.328  1.00 83.98           C  
ATOM    600  C   ASP A  81     106.267   0.078  -0.161  1.00 83.84           C  
ATOM    601  O   ASP A  81     106.389   1.239  -0.510  1.00 83.03           O  
ATOM    602  CB  ASP A  81     103.874   0.042  -1.092  1.00 84.01           C  
ATOM    603  CG  ASP A  81     102.783  -0.882  -1.692  1.00 87.01           C  
ATOM    604  OD1 ASP A  81     102.667  -2.057  -1.288  1.00 86.34           O  
ATOM    605  OD2 ASP A  81     102.020  -0.415  -2.576  1.00 89.51           O  
ATOM    606  N   GLY A  82     107.271  -0.632   0.352  1.00 85.52           N  
ATOM    607  CA  GLY A  82     108.538  -0.037   0.754  1.00 86.04           C  
ATOM    608  C   GLY A  82     108.283   0.600   2.106  1.00 86.61           C  
ATOM    609  O   GLY A  82     108.134  -0.099   3.118  1.00 86.60           O  
ATOM    610  N   LYS A  83     108.198   1.927   2.116  1.00 87.06           N  
ATOM    611  CA  LYS A  83     107.869   2.667   3.329  1.00 87.76           C  
ATOM    612  C   LYS A  83     106.341   2.863   3.501  1.00 88.25           C  
ATOM    613  O   LYS A  83     105.864   2.984   4.632  1.00 90.07           O  
ATOM    614  CB  LYS A  83     108.591   4.019   3.336  1.00 86.89           C  
ATOM    615  N   GLU A  84     105.578   2.821   2.404  1.00 86.79           N  
ATOM    616  CA  GLU A  84     104.144   3.155   2.411  1.00 87.10           C  
ATOM    617  C   GLU A  84     103.304   2.029   3.024  1.00 86.22           C  
ATOM    618  O   GLU A  84     103.378   0.894   2.550  1.00 86.82           O  
ATOM    619  CB  GLU A  84     103.669   3.374   0.958  1.00 88.02           C  
ATOM    620  CG  GLU A  84     103.619   4.812   0.466  1.00 92.62           C  
ATOM    621  CD  GLU A  84     102.238   5.434   0.658  1.00101.01           C  
ATOM    622  OE1 GLU A  84     101.584   5.167   1.702  1.00102.38           O  
ATOM    623  OE2 GLU A  84     101.807   6.181  -0.251  1.00106.64           O  
ATOM    624  N   ARG A  85     102.490   2.334   4.040  1.00 84.77           N  
ATOM    625  CA  ARG A  85     101.636   1.303   4.680  1.00 83.67           C  
ATOM    626  C   ARG A  85     100.298   1.133   3.987  1.00 82.19           C  
ATOM    627  O   ARG A  85      99.565   2.095   3.827  1.00 81.30           O  
ATOM    628  CB  ARG A  85     101.399   1.566   6.169  1.00 83.60           C  
ATOM    629  CG  ARG A  85     102.310   0.762   7.058  1.00 86.08           C  
ATOM    630  CD  ARG A  85     101.857  -0.703   7.113  1.00 87.99           C  
ATOM    631  NE  ARG A  85     100.857  -0.915   8.167  1.00 91.14           N  
ATOM    632  CZ  ARG A  85     101.077  -1.550   9.319  1.00 86.83           C  
ATOM    633  NH1 ARG A  85     102.250  -2.064   9.613  1.00 87.41           N  
ATOM    634  NH2 ARG A  85     100.104  -1.677  10.196  1.00 85.48           N  
HETATM  635  N   MSE A  86      99.984  -0.108   3.612  1.00 81.54           N  
HETATM  636  CA  MSE A  86      98.777  -0.417   2.848  1.00 80.75           C  
HETATM  637  C   MSE A  86      97.822  -1.306   3.627  1.00 80.05           C  
HETATM  638  O   MSE A  86      98.222  -1.974   4.562  1.00 80.56           O  
HETATM  639  CB  MSE A  86      99.137  -1.129   1.536  1.00 80.64           C  
HETATM  640  CG  MSE A  86     100.182  -0.425   0.679  1.00 79.40           C  
HETATM  641 SE   MSE A  86      99.720   1.373   0.212  0.75 72.98          SE  
HETATM  642  CE  MSE A  86      98.448   1.114  -1.285  1.00 75.88           C  
ATOM    643  N   VAL A  87      96.560  -1.302   3.215  1.00 79.22           N  
ATOM    644  CA  VAL A  87      95.553  -2.189   3.772  1.00 79.31           C  
ATOM    645  C   VAL A  87      94.875  -2.884   2.602  1.00 79.36           C  
ATOM    646  O   VAL A  87      94.600  -2.254   1.592  1.00 78.59           O  
ATOM    647  CB  VAL A  87      94.539  -1.443   4.655  1.00 79.45           C  
ATOM    648  CG1 VAL A  87      93.737  -0.447   3.851  1.00 78.43           C  
ATOM    649  CG2 VAL A  87      93.630  -2.420   5.322  1.00 80.44           C  
ATOM    650  N   ASN A  88      94.635  -4.183   2.738  1.00 80.66           N  
ATOM    651  CA  ASN A  88      94.064  -4.992   1.663  1.00 81.97           C  
ATOM    652  C   ASN A  88      92.721  -5.548   2.099  1.00 83.25           C  
ATOM    653  O   ASN A  88      92.619  -6.074   3.199  1.00 85.50           O  
ATOM    654  CB  ASN A  88      94.995  -6.148   1.337  1.00 82.21           C  
ATOM    655  CG  ASN A  88      96.405  -5.698   1.047  1.00 82.35           C  
ATOM    656  OD1 ASN A  88      96.697  -5.168  -0.018  1.00 87.07           O  
ATOM    657  ND2 ASN A  88      97.294  -5.928   1.989  1.00 81.97           N  
ATOM    658  N   ILE A  89      91.701  -5.414   1.260  1.00 83.12           N  
ATOM    659  CA  ILE A  89      90.374  -5.933   1.563  1.00 83.23           C  
ATOM    660  C   ILE A  89      90.009  -6.864   0.447  1.00 84.56           C  
ATOM    661  O   ILE A  89      90.212  -6.528  -0.706  1.00 86.31           O  
ATOM    662  CB  ILE A  89      89.318  -4.843   1.604  1.00 82.83           C  
ATOM    663  CG1 ILE A  89      89.694  -3.750   2.599  1.00 81.91           C  
ATOM    664  CG2 ILE A  89      87.997  -5.431   2.000  1.00 83.60           C  
ATOM    665  CD1 ILE A  89      88.705  -2.603   2.605  1.00 81.11           C  
ATOM    666  N   ALA A  90      89.460  -8.028   0.775  1.00 82.79           N  
ATOM    667  CA  ALA A  90      89.114  -9.016  -0.232  1.00 80.30           C  
ATOM    668  C   ALA A  90      87.738  -9.604   0.029  1.00 80.21           C  
ATOM    669  O   ALA A  90      87.408  -9.889   1.182  1.00 79.73           O  
ATOM    670  CB  ALA A  90      90.158 -10.105  -0.241  1.00 77.94           C  
ATOM    671  N   LEU A  91      86.935  -9.757  -1.035  1.00 79.87           N  
ATOM    672  CA  LEU A  91      85.671 -10.508  -0.974  1.00 79.76           C  
ATOM    673  C   LEU A  91      85.935 -11.924  -1.461  1.00 80.35           C  
ATOM    674  O   LEU A  91      86.463 -12.113  -2.539  1.00 82.76           O  
ATOM    675  CB  LEU A  91      84.594  -9.871  -1.834  1.00 78.60           C  
ATOM    676  N   SER A  92      85.605 -12.919  -0.653  1.00 82.60           N  
ATOM    677  CA  SER A  92      85.832 -14.318  -1.019  1.00 83.84           C  
ATOM    678  C   SER A  92      84.627 -14.835  -1.748  1.00 83.77           C  
ATOM    679  O   SER A  92      83.490 -14.583  -1.359  1.00 84.00           O  
ATOM    680  CB  SER A  92      86.069 -15.211   0.207  1.00 85.45           C  
ATOM    681  OG  SER A  92      87.430 -15.211   0.609  1.00 90.89           O  
ATOM    682  N   SER A  93      84.902 -15.593  -2.796  1.00 84.64           N  
ATOM    683  CA  SER A  93      83.895 -16.183  -3.644  1.00 83.55           C  
ATOM    684  C   SER A  93      84.530 -17.432  -4.228  1.00 84.05           C  
ATOM    685  O   SER A  93      85.762 -17.479  -4.378  1.00 82.70           O  
ATOM    686  CB  SER A  93      83.556 -15.206  -4.757  1.00 83.13           C  
ATOM    687  OG  SER A  93      82.599 -15.742  -5.636  1.00 86.26           O  
ATOM    688  N   PRO A  94      83.711 -18.457  -4.555  1.00 85.70           N  
ATOM    689  CA  PRO A  94      84.272 -19.631  -5.256  1.00 85.33           C  
ATOM    690  C   PRO A  94      84.843 -19.248  -6.618  1.00 85.02           C  
ATOM    691  O   PRO A  94      85.772 -19.895  -7.117  1.00 84.51           O  
ATOM    692  CB  PRO A  94      83.064 -20.565  -5.443  1.00 84.40           C  
ATOM    693  CG  PRO A  94      81.996 -20.053  -4.552  1.00 85.53           C  
ATOM    694  CD  PRO A  94      82.259 -18.592  -4.316  1.00 86.44           C  
ATOM    695  N   PHE A  95      84.299 -18.169  -7.182  1.00 84.99           N  
ATOM    696  CA  PHE A  95      84.673 -17.685  -8.504  1.00 85.71           C  
ATOM    697  C   PHE A  95      85.949 -16.841  -8.541  1.00 87.19           C  
ATOM    698  O   PHE A  95      86.248 -16.205  -9.559  1.00 85.84           O  
ATOM    699  CB  PHE A  95      83.488 -16.921  -9.089  1.00 84.45           C  
ATOM    700  CG  PHE A  95      82.231 -17.745  -9.155  1.00 83.64           C  
ATOM    701  CD1 PHE A  95      82.098 -18.751 -10.113  1.00 80.41           C  
ATOM    702  CD2 PHE A  95      81.198 -17.543  -8.250  1.00 82.61           C  
ATOM    703  CE1 PHE A  95      80.951 -19.530 -10.181  1.00 78.27           C  
ATOM    704  CE2 PHE A  95      80.038 -18.322  -8.316  1.00 82.08           C  
ATOM    705  CZ  PHE A  95      79.921 -19.316  -9.280  1.00 79.42           C  
ATOM    706  N   GLY A  96      86.701 -16.853  -7.438  1.00 90.04           N  
ATOM    707  CA  GLY A  96      87.984 -16.156  -7.337  1.00 91.29           C  
ATOM    708  C   GLY A  96      87.865 -14.888  -6.531  1.00 91.93           C  
ATOM    709  O   GLY A  96      86.998 -14.049  -6.810  1.00 91.13           O  
ATOM    710  N   GLN A  97      88.727 -14.751  -5.523  1.00 93.66           N  
ATOM    711  CA  GLN A  97      88.752 -13.534  -4.712  1.00 95.01           C  
ATOM    712  C   GLN A  97      89.244 -12.352  -5.565  1.00 96.01           C  
ATOM    713  O   GLN A  97      90.194 -12.478  -6.369  1.00 96.07           O  
ATOM    714  CB  GLN A  97      89.625 -13.691  -3.449  1.00 93.81           C  
ATOM    715  N   ALA A  98      88.523 -11.238  -5.430  1.00 95.34           N  
ATOM    716  CA  ALA A  98      88.948  -9.943  -5.933  1.00 94.52           C  
ATOM    717  C   ALA A  98      89.335  -9.160  -4.674  1.00 92.00           C  
ATOM    718  O   ALA A  98      88.741  -9.316  -3.611  1.00 92.90           O  
ATOM    719  CB  ALA A  98      87.843  -9.257  -6.709  1.00 95.65           C  
ATOM    720  N   ARG A  99      90.229  -8.218  -4.873  1.00 88.60           N  
ATOM    721  CA  ARG A  99      91.128  -7.670  -3.857  1.00 87.97           C  
ATOM    722  C   ARG A  99      91.267  -6.190  -4.049  1.00 87.35           C  
ATOM    723  O   ARG A  99      91.651  -5.745  -5.130  1.00 87.73           O  
ATOM    724  CB  ARG A  99      92.566  -8.155  -4.078  1.00 87.76           C  
ATOM    725  CG  ARG A  99      93.003  -9.417  -3.414  1.00 89.71           C  
ATOM    726  CD  ARG A  99      94.525  -9.479  -3.453  1.00 91.92           C  
ATOM    727  NE  ARG A  99      95.018 -10.742  -2.908  1.00 96.38           N  
ATOM    728  N   PHE A 100      91.015  -5.433  -2.999  1.00 85.92           N  
ATOM    729  CA  PHE A 100      91.262  -4.011  -3.042  1.00 85.56           C  
ATOM    730  C   PHE A 100      92.532  -3.680  -2.289  1.00 84.09           C  
ATOM    731  O   PHE A 100      92.925  -4.356  -1.349  1.00 84.24           O  
ATOM    732  CB  PHE A 100      90.105  -3.227  -2.455  1.00 86.90           C  
ATOM    733  CG  PHE A 100      88.800  -3.514  -3.105  1.00 89.96           C  
ATOM    734  CD1 PHE A 100      88.646  -3.347  -4.476  1.00 94.84           C  
ATOM    735  CD2 PHE A 100      87.710  -3.918  -2.353  1.00 93.50           C  
ATOM    736  CE1 PHE A 100      87.433  -3.601  -5.095  1.00 92.34           C  
ATOM    737  CE2 PHE A 100      86.490  -4.171  -2.959  1.00 96.65           C  
ATOM    738  CZ  PHE A 100      86.351  -4.015  -4.338  1.00 95.01           C  
ATOM    739  N   HIS A 101      93.159  -2.606  -2.711  1.00 83.03           N  
ATOM    740  CA  HIS A 101      94.451  -2.191  -2.203  1.00 82.51           C  
ATOM    741  C   HIS A 101      94.389  -0.678  -1.977  1.00 80.71           C  
ATOM    742  O   HIS A 101      94.130   0.095  -2.910  1.00 81.03           O  
ATOM    743  CB  HIS A 101      95.495  -2.568  -3.273  1.00 84.08           C  
ATOM    744  CG  HIS A 101      96.919  -2.364  -2.863  1.00 86.35           C  
ATOM    745  ND1 HIS A 101      97.519  -3.105  -1.871  1.00 88.95           N  
ATOM    746  CD2 HIS A 101      97.876  -1.540  -3.353  1.00 87.87           C  
ATOM    747  CE1 HIS A 101      98.780  -2.726  -1.747  1.00 91.34           C  
ATOM    748  NE2 HIS A 101      99.021  -1.779  -2.636  1.00 89.95           N  
ATOM    749  N   ALA A 102      94.590  -0.255  -0.737  1.00 78.61           N  
ATOM    750  CA  ALA A 102      94.521   1.166  -0.403  1.00 77.56           C  
ATOM    751  C   ALA A 102      95.566   1.565   0.608  1.00 77.06           C  
ATOM    752  O   ALA A 102      96.047   0.743   1.377  1.00 77.78           O  
ATOM    753  CB  ALA A 102      93.166   1.507   0.142  1.00 76.51           C  
ATOM    754  N   GLN A 103      95.903   2.846   0.613  1.00 76.52           N  
ATOM    755  CA  GLN A 103      96.807   3.387   1.622  1.00 76.01           C  
ATOM    756  C   GLN A 103      96.067   3.584   2.945  1.00 74.34           C  
ATOM    757  O   GLN A 103      94.881   3.855   2.976  1.00 73.91           O  
ATOM    758  CB  GLN A 103      97.536   4.634   1.149  1.00 76.39           C  
ATOM    759  CG  GLN A 103      96.684   5.687   0.480  1.00 84.84           C  
ATOM    760  CD  GLN A 103      97.509   6.802  -0.110  1.00 88.86           C  
ATOM    761  OE1 GLN A 103      97.070   7.953  -0.138  1.00 92.54           O  
ATOM    762  NE2 GLN A 103      98.718   6.473  -0.581  1.00 86.94           N  
ATOM    763  N   VAL A 104      96.797   3.407   4.032  1.00 73.63           N  
ATOM    764  CA  VAL A 104      96.242   3.422   5.376  1.00 73.17           C  
ATOM    765  C   VAL A 104      95.798   4.808   5.856  1.00 72.89           C  
ATOM    766  O   VAL A 104      94.716   4.937   6.451  1.00 72.45           O  
ATOM    767  CB  VAL A 104      97.270   2.814   6.377  1.00 72.86           C  
ATOM    768  CG1 VAL A 104      97.004   3.254   7.789  1.00 73.46           C  
ATOM    769  CG2 VAL A 104      97.254   1.291   6.267  1.00 73.64           C  
ATOM    770  N   ALA A 105      96.619   5.830   5.592  1.00 71.70           N  
ATOM    771  CA  ALA A 105      96.367   7.169   6.130  1.00 70.96           C  
ATOM    772  C   ALA A 105      94.901   7.606   6.025  1.00 71.68           C  
ATOM    773  O   ALA A 105      94.280   7.934   7.043  1.00 71.79           O  
ATOM    774  CB  ALA A 105      97.277   8.199   5.491  1.00 70.28           C  
ATOM    775  N   PRO A 106      94.331   7.599   4.805  1.00 71.65           N  
ATOM    776  CA  PRO A 106      92.953   8.080   4.647  1.00 71.00           C  
ATOM    777  C   PRO A 106      91.919   7.240   5.364  1.00 71.57           C  
ATOM    778  O   PRO A 106      90.974   7.807   5.898  1.00 72.21           O  
ATOM    779  CB  PRO A 106      92.714   8.009   3.138  1.00 70.38           C  
ATOM    780  CG  PRO A 106      94.059   7.926   2.539  1.00 70.49           C  
ATOM    781  CD  PRO A 106      94.896   7.180   3.514  1.00 71.52           C  
ATOM    782  N   LEU A 107      92.065   5.911   5.351  1.00 71.51           N  
ATOM    783  CA  LEU A 107      91.150   5.043   6.090  1.00 70.78           C  
ATOM    784  C   LEU A 107      91.301   5.286   7.578  1.00 70.80           C  
ATOM    785  O   LEU A 107      90.312   5.393   8.303  1.00 72.88           O  
ATOM    786  CB  LEU A 107      91.398   3.574   5.806  1.00 71.51           C  
ATOM    787  CG  LEU A 107      91.172   3.113   4.374  1.00 73.94           C  
ATOM    788  CD1 LEU A 107      91.282   1.604   4.365  1.00 81.04           C  
ATOM    789  CD2 LEU A 107      89.812   3.553   3.863  1.00 76.05           C  
ATOM    790  N   SER A 108      92.534   5.404   8.046  1.00 69.66           N  
ATOM    791  CA  SER A 108      92.747   5.674   9.459  1.00 69.38           C  
ATOM    792  C   SER A 108      92.098   6.982   9.870  1.00 69.17           C  
ATOM    793  O   SER A 108      91.421   7.050  10.891  1.00 70.26           O  
ATOM    794  CB  SER A 108      94.221   5.713   9.808  1.00 69.53           C  
ATOM    795  OG  SER A 108      94.379   5.846  11.203  1.00 72.18           O  
ATOM    796  N   GLU A 109      92.290   8.021   9.074  1.00 69.16           N  
ATOM    797  CA  GLU A 109      91.714   9.314   9.420  1.00 69.02           C  
ATOM    798  C   GLU A 109      90.205   9.233   9.505  1.00 67.88           C  
ATOM    799  O   GLU A 109      89.584   9.765  10.426  1.00 66.94           O  
ATOM    800  CB  GLU A 109      92.122  10.392   8.413  1.00 69.92           C  
ATOM    801  CG  GLU A 109      91.610  11.793   8.762  1.00 74.83           C  
ATOM    802  CD  GLU A 109      91.839  12.168  10.244  1.00 86.82           C  
ATOM    803  OE1 GLU A 109      93.022  12.170  10.690  1.00 91.04           O  
ATOM    804  OE2 GLU A 109      90.836  12.462  10.957  1.00 85.07           O  
ATOM    805  N   PHE A 110      89.614   8.550   8.540  1.00 67.85           N  
ATOM    806  CA  PHE A 110      88.172   8.387   8.534  1.00 67.28           C  
ATOM    807  C   PHE A 110      87.707   7.624   9.774  1.00 67.88           C  
ATOM    808  O   PHE A 110      86.757   8.028  10.432  1.00 68.41           O  
ATOM    809  CB  PHE A 110      87.717   7.689   7.271  1.00 66.60           C  
ATOM    810  CG  PHE A 110      86.247   7.413   7.248  1.00 69.26           C  
ATOM    811  CD1 PHE A 110      85.342   8.447   7.065  1.00 67.51           C  
ATOM    812  CD2 PHE A 110      85.764   6.126   7.439  1.00 68.77           C  
ATOM    813  CE1 PHE A 110      83.979   8.196   7.066  1.00 69.44           C  
ATOM    814  CE2 PHE A 110      84.407   5.868   7.437  1.00 69.36           C  
ATOM    815  CZ  PHE A 110      83.507   6.896   7.250  1.00 67.85           C  
ATOM    816  N   LEU A 111      88.381   6.530  10.099  1.00 67.60           N  
ATOM    817  CA  LEU A 111      88.007   5.775  11.275  1.00 66.97           C  
ATOM    818  C   LEU A 111      88.162   6.656  12.503  1.00 67.61           C  
ATOM    819  O   LEU A 111      87.314   6.645  13.393  1.00 70.56           O  
ATOM    820  CB  LEU A 111      88.803   4.475  11.387  1.00 66.36           C  
ATOM    821  CG  LEU A 111      88.355   3.406  10.391  1.00 67.03           C  
ATOM    822  CD1 LEU A 111      89.396   2.292  10.242  1.00 69.23           C  
ATOM    823  CD2 LEU A 111      87.029   2.810  10.793  1.00 69.98           C  
ATOM    824  N   HIS A 112      89.215   7.457  12.558  1.00 67.27           N  
ATOM    825  CA  HIS A 112      89.400   8.330  13.727  1.00 67.56           C  
ATOM    826  C   HIS A 112      88.203   9.257  13.906  1.00 66.57           C  
ATOM    827  O   HIS A 112      87.711   9.430  15.019  1.00 67.94           O  
ATOM    828  CB  HIS A 112      90.692   9.121  13.632  1.00 68.07           C  
ATOM    829  CG  HIS A 112      90.921  10.011  14.797  1.00 70.23           C  
ATOM    830  ND1 HIS A 112      91.070  11.371  14.682  1.00 74.04           N  
ATOM    831  CD2 HIS A 112      90.964   9.735  16.116  1.00 75.03           C  
ATOM    832  CE1 HIS A 112      91.225  11.892  15.886  1.00 76.45           C  
ATOM    833  NE2 HIS A 112      91.167  10.918  16.772  1.00 75.62           N  
ATOM    834  N   ARG A 113      87.717   9.830  12.812  1.00 65.57           N  
ATOM    835  CA  ARG A 113      86.506  10.650  12.868  1.00 64.53           C  
ATOM    836  C   ARG A 113      85.271   9.874  13.362  1.00 64.28           C  
ATOM    837  O   ARG A 113      84.464  10.439  14.128  1.00 63.92           O  
ATOM    838  CB  ARG A 113      86.167  11.232  11.513  1.00 65.27           C  
ATOM    839  CG  ARG A 113      87.179  12.214  10.944  1.00 70.50           C  
ATOM    840  CD  ARG A 113      86.527  13.068   9.865  1.00 78.27           C  
ATOM    841  NE  ARG A 113      87.493  13.627   8.919  1.00 89.13           N  
ATOM    842  CZ  ARG A 113      88.266  14.702   9.135  1.00 92.23           C  
ATOM    843  NH1 ARG A 113      88.236  15.382  10.288  1.00 91.36           N  
ATOM    844  NH2 ARG A 113      89.090  15.099   8.174  1.00 90.35           N  
ATOM    845  N   THR A 114      85.116   8.600  12.932  1.00 62.45           N  
ATOM    846  CA  THR A 114      83.987   7.790  13.393  1.00 62.30           C  
ATOM    847  C   THR A 114      84.100   7.555  14.901  1.00 62.57           C  
ATOM    848  O   THR A 114      83.100   7.636  15.627  1.00 63.20           O  
ATOM    849  CB  THR A 114      83.845   6.405  12.684  1.00 62.44           C  
ATOM    850  OG1 THR A 114      84.889   5.531  13.130  1.00 63.08           O  
ATOM    851  CG2 THR A 114      83.885   6.525  11.157  1.00 61.78           C  
ATOM    852  N   TYR A 115      85.309   7.284  15.387  1.00 62.74           N  
ATOM    853  CA  TYR A 115      85.486   7.118  16.839  1.00 63.10           C  
ATOM    854  C   TYR A 115      85.241   8.412  17.640  1.00 65.60           C  
ATOM    855  O   TYR A 115      84.843   8.351  18.822  1.00 67.19           O  
ATOM    856  CB  TYR A 115      86.835   6.519  17.161  1.00 61.34           C  
ATOM    857  CG  TYR A 115      86.935   5.087  16.721  1.00 59.53           C  
ATOM    858  CD1 TYR A 115      86.096   4.126  17.243  1.00 59.74           C  
ATOM    859  CD2 TYR A 115      87.879   4.691  15.789  1.00 60.50           C  
ATOM    860  CE1 TYR A 115      86.183   2.820  16.836  1.00 59.62           C  
ATOM    861  CE2 TYR A 115      87.984   3.376  15.392  1.00 60.88           C  
ATOM    862  CZ  TYR A 115      87.140   2.454  15.913  1.00 61.26           C  
ATOM    863  OH  TYR A 115      87.253   1.165  15.495  1.00 63.25           O  
ATOM    864  N   GLU A 116      85.448   9.574  17.020  1.00 66.66           N  
ATOM    865  CA  GLU A 116      85.130  10.831  17.718  1.00 70.21           C  
ATOM    866  C   GLU A 116      83.625  10.931  17.920  1.00 68.47           C  
ATOM    867  O   GLU A 116      83.176  11.371  18.950  1.00 69.68           O  
ATOM    868  CB  GLU A 116      85.628  12.072  16.977  1.00 70.02           C  
ATOM    869  CG  GLU A 116      87.144  12.219  16.958  1.00 77.94           C  
ATOM    870  CD  GLU A 116      87.622  13.483  16.238  1.00 79.26           C  
ATOM    871  OE1 GLU A 116      86.998  13.866  15.216  1.00 91.88           O  
ATOM    872  OE2 GLU A 116      88.637  14.084  16.693  1.00 93.25           O  
ATOM    873  N   LEU A 117      82.841  10.506  16.936  1.00 67.62           N  
ATOM    874  CA  LEU A 117      81.389  10.528  17.067  1.00 66.01           C  
ATOM    875  C   LEU A 117      80.894   9.455  18.029  1.00 66.31           C  
ATOM    876  O   LEU A 117      80.028   9.714  18.860  1.00 67.86           O  
ATOM    877  CB  LEU A 117      80.723  10.293  15.721  1.00 65.54           C  
ATOM    878  CG  LEU A 117      80.781  11.363  14.651  1.00 63.36           C  
ATOM    879  CD1 LEU A 117      80.231  10.795  13.324  1.00 60.63           C  
ATOM    880  CD2 LEU A 117      79.973  12.536  15.106  1.00 53.41           C  
ATOM    881  N   VAL A 118      81.406   8.237  17.868  1.00 64.86           N  
ATOM    882  CA  VAL A 118      81.036   7.099  18.738  1.00 63.42           C  
ATOM    883  C   VAL A 118      82.298   6.302  19.114  1.00 63.91           C  
ATOM    884  O   VAL A 118      82.809   5.524  18.297  1.00 64.05           O  
ATOM    885  CB  VAL A 118      80.048   6.174  18.053  1.00 62.41           C  
ATOM    886  CG1 VAL A 118      79.769   4.997  18.927  1.00 59.48           C  
ATOM    887  CG2 VAL A 118      78.793   6.924  17.712  1.00 61.48           C  
ATOM    888  N   PRO A 119      82.857   6.560  20.321  1.00 62.95           N  
ATOM    889  CA  PRO A 119      84.016   5.807  20.795  1.00 63.25           C  
ATOM    890  C   PRO A 119      83.762   4.330  20.895  1.00 64.24           C  
ATOM    891  O   PRO A 119      82.628   3.910  21.164  1.00 65.67           O  
ATOM    892  CB  PRO A 119      84.243   6.374  22.189  1.00 63.20           C  
ATOM    893  CG  PRO A 119      83.733   7.730  22.103  1.00 59.61           C  
ATOM    894  CD  PRO A 119      82.516   7.630  21.264  1.00 62.27           C  
ATOM    895  N   ALA A 120      84.812   3.549  20.657  1.00 65.82           N  
ATOM    896  CA  ALA A 120      84.727   2.098  20.769  1.00 65.71           C  
ATOM    897  C   ALA A 120      84.178   1.769  22.136  1.00 65.87           C  
ATOM    898  O   ALA A 120      84.670   2.269  23.129  1.00 67.90           O  
ATOM    899  CB  ALA A 120      86.107   1.478  20.613  1.00 64.76           C  
ATOM    900  N   GLY A 121      83.128   0.975  22.184  1.00 66.72           N  
ATOM    901  CA  GLY A 121      82.551   0.563  23.441  1.00 66.37           C  
ATOM    902  C   GLY A 121      81.327   1.329  23.855  1.00 66.92           C  
ATOM    903  O   GLY A 121      80.688   0.943  24.807  1.00 67.71           O  
ATOM    904  N   GLN A 122      80.978   2.395  23.147  1.00 67.55           N  
ATOM    905  CA  GLN A 122      79.793   3.187  23.490  1.00 67.55           C  
ATOM    906  C   GLN A 122      78.701   3.086  22.431  1.00 67.38           C  
ATOM    907  O   GLN A 122      77.738   3.854  22.435  1.00 68.87           O  
ATOM    908  CB  GLN A 122      80.203   4.628  23.738  1.00 67.72           C  
ATOM    909  CG  GLN A 122      80.981   4.773  25.024  1.00 73.71           C  
ATOM    910  CD  GLN A 122      81.603   6.136  25.176  1.00 79.67           C  
ATOM    911  OE1 GLN A 122      81.063   7.141  24.703  1.00 82.66           O  
ATOM    912  NE2 GLN A 122      82.749   6.182  25.843  1.00 83.18           N  
ATOM    913  N   GLU A 123      78.832   2.100  21.552  1.00 66.14           N  
ATOM    914  CA  GLU A 123      77.841   1.857  20.514  1.00 66.18           C  
ATOM    915  C   GLU A 123      76.447   1.567  21.087  1.00 66.44           C  
ATOM    916  O   GLU A 123      75.432   1.899  20.465  1.00 67.68           O  
ATOM    917  CB  GLU A 123      78.292   0.685  19.632  1.00 66.46           C  
ATOM    918  CG  GLU A 123      79.537   0.972  18.758  1.00 68.48           C  
ATOM    919  CD  GLU A 123      80.879   0.524  19.358  1.00 72.61           C  
ATOM    920  OE1 GLU A 123      81.026   0.477  20.601  1.00 72.49           O  
ATOM    921  OE2 GLU A 123      81.797   0.230  18.557  1.00 72.27           O  
ATOM    922  N   SER A 124      76.416   0.955  22.267  1.00 66.17           N  
ATOM    923  CA  SER A 124      75.176   0.610  22.969  1.00 66.27           C  
ATOM    924  C   SER A 124      74.185   1.760  23.092  1.00 66.87           C  
ATOM    925  O   SER A 124      72.977   1.570  22.949  1.00 68.49           O  
ATOM    926  CB  SER A 124      75.516   0.133  24.373  1.00 65.48           C  
ATOM    927  OG  SER A 124      76.401  -0.952  24.301  1.00 68.85           O  
ATOM    928  N   ASP A 125      74.706   2.948  23.355  1.00 66.10           N  
ATOM    929  CA  ASP A 125      73.871   4.116  23.557  1.00 67.10           C  
ATOM    930  C   ASP A 125      73.019   4.383  22.334  1.00 65.56           C  
ATOM    931  O   ASP A 125      71.826   4.723  22.426  1.00 66.54           O  
ATOM    932  CB  ASP A 125      74.745   5.348  23.846  1.00 68.83           C  
ATOM    933  CG  ASP A 125      75.728   5.131  25.007  1.00 75.63           C  
ATOM    934  OD1 ASP A 125      75.428   4.333  25.916  1.00 83.26           O  
ATOM    935  OD2 ASP A 125      76.808   5.758  25.006  1.00 82.43           O  
ATOM    936  N   TYR A 126      73.636   4.186  21.185  1.00 63.49           N  
ATOM    937  CA  TYR A 126      72.987   4.455  19.918  1.00 62.17           C  
ATOM    938  C   TYR A 126      72.022   3.331  19.570  1.00 61.45           C  
ATOM    939  O   TYR A 126      70.965   3.586  18.974  1.00 62.71           O  
ATOM    940  CB  TYR A 126      74.041   4.762  18.827  1.00 62.31           C  
ATOM    941  CG  TYR A 126      74.787   6.036  19.199  1.00 62.44           C  
ATOM    942  CD1 TYR A 126      74.225   7.285  18.964  1.00 64.27           C  
ATOM    943  CD2 TYR A 126      76.001   5.987  19.883  1.00 61.45           C  
ATOM    944  CE1 TYR A 126      74.872   8.462  19.365  1.00 64.85           C  
ATOM    945  CE2 TYR A 126      76.652   7.143  20.297  1.00 62.30           C  
ATOM    946  CZ  TYR A 126      76.092   8.385  20.033  1.00 64.51           C  
ATOM    947  OH  TYR A 126      76.739   9.553  20.432  1.00 63.87           O  
ATOM    948  N   ILE A 127      72.338   2.106  19.983  1.00 59.10           N  
ATOM    949  CA  ILE A 127      71.399   1.002  19.794  1.00 57.42           C  
ATOM    950  C   ILE A 127      70.153   1.300  20.630  1.00 58.16           C  
ATOM    951  O   ILE A 127      69.022   1.161  20.155  1.00 57.85           O  
ATOM    952  CB  ILE A 127      71.984  -0.376  20.222  1.00 56.68           C  
ATOM    953  CG1 ILE A 127      73.214  -0.728  19.391  1.00 58.46           C  
ATOM    954  CG2 ILE A 127      70.929  -1.473  20.097  1.00 53.67           C  
ATOM    955  CD1 ILE A 127      73.034  -0.585  17.892  1.00 56.40           C  
ATOM    956  N   ASP A 128      70.356   1.731  21.864  1.00 58.98           N  
ATOM    957  CA  ASP A 128      69.223   2.066  22.737  1.00 61.26           C  
ATOM    958  C   ASP A 128      68.286   3.101  22.116  1.00 60.63           C  
ATOM    959  O   ASP A 128      67.068   2.966  22.176  1.00 60.92           O  
ATOM    960  CB  ASP A 128      69.711   2.559  24.109  1.00 62.22           C  
ATOM    961  CG  ASP A 128      70.342   1.451  24.956  1.00 67.29           C  
ATOM    962  OD1 ASP A 128      70.143   0.261  24.638  1.00 75.36           O  
ATOM    963  OD2 ASP A 128      71.029   1.767  25.956  1.00 74.17           O  
ATOM    964  N   ILE A 129      68.863   4.122  21.503  1.00 60.87           N  
ATOM    965  CA  ILE A 129      68.071   5.171  20.869  1.00 60.84           C  
ATOM    966  C   ILE A 129      67.291   4.599  19.689  1.00 60.98           C  
ATOM    967  O   ILE A 129      66.099   4.877  19.551  1.00 61.87           O  
ATOM    968  CB  ILE A 129      68.951   6.361  20.448  1.00 60.90           C  
ATOM    969  CG1 ILE A 129      69.471   7.082  21.694  1.00 61.77           C  
ATOM    970  CG2 ILE A 129      68.161   7.335  19.595  1.00 57.13           C  
ATOM    971  CD1 ILE A 129      70.655   8.009  21.423  1.00 68.48           C  
ATOM    972  N   ASP A 130      67.945   3.782  18.868  1.00 60.03           N  
ATOM    973  CA  ASP A 130      67.265   3.119  17.759  1.00 60.14           C  
ATOM    974  C   ASP A 130      66.065   2.293  18.245  1.00 60.09           C  
ATOM    975  O   ASP A 130      65.004   2.295  17.627  1.00 61.24           O  
ATOM    976  CB  ASP A 130      68.229   2.205  16.998  1.00 60.55           C  
ATOM    977  CG  ASP A 130      69.292   2.965  16.231  1.00 62.89           C  
ATOM    978  OD1 ASP A 130      69.297   4.214  16.230  1.00 66.92           O  
ATOM    979  OD2 ASP A 130      70.144   2.296  15.616  1.00 63.73           O  
ATOM    980  N   ALA A 131      66.249   1.580  19.345  1.00 59.51           N  
ATOM    981  CA  ALA A 131      65.187   0.780  19.920  1.00 59.73           C  
ATOM    982  C   ALA A 131      64.063   1.683  20.415  1.00 61.72           C  
ATOM    983  O   ALA A 131      62.878   1.379  20.235  1.00 61.68           O  
ATOM    984  CB  ALA A 131      65.736  -0.057  21.069  1.00 57.43           C  
ATOM    985  N   GLU A 132      64.444   2.804  21.020  1.00 63.38           N  
ATOM    986  CA  GLU A 132      63.472   3.735  21.576  1.00 65.46           C  
ATOM    987  C   GLU A 132      62.590   4.389  20.518  1.00 64.78           C  
ATOM    988  O   GLU A 132      61.386   4.543  20.725  1.00 64.78           O  
ATOM    989  CB  GLU A 132      64.181   4.784  22.432  1.00 65.95           C  
ATOM    990  CG  GLU A 132      64.567   4.220  23.791  1.00 71.39           C  
ATOM    991  CD  GLU A 132      65.370   5.171  24.657  1.00 74.16           C  
ATOM    992  OE1 GLU A 132      66.141   5.987  24.113  1.00 81.82           O  
ATOM    993  OE2 GLU A 132      65.233   5.083  25.899  1.00 82.29           O  
ATOM    994  N   ILE A 133      63.181   4.746  19.383  1.00 63.48           N  
ATOM    995  CA  ILE A 133      62.411   5.342  18.305  1.00 63.23           C  
ATOM    996  C   ILE A 133      61.393   4.326  17.788  1.00 64.56           C  
ATOM    997  O   ILE A 133      60.217   4.654  17.626  1.00 65.12           O  
ATOM    998  CB  ILE A 133      63.288   5.826  17.165  1.00 63.59           C  
ATOM    999  CG1 ILE A 133      64.255   6.913  17.642  1.00 63.54           C  
ATOM   1000  CG2 ILE A 133      62.419   6.393  16.057  1.00 60.37           C  
ATOM   1001  CD1 ILE A 133      65.478   7.044  16.734  1.00 63.15           C  
ATOM   1002  N   ALA A 134      61.849   3.094  17.562  1.00 65.23           N  
ATOM   1003  CA  ALA A 134      60.987   2.007  17.104  1.00 65.89           C  
ATOM   1004  C   ALA A 134      59.787   1.798  18.034  1.00 67.49           C  
ATOM   1005  O   ALA A 134      58.664   1.547  17.560  1.00 68.13           O  
ATOM   1006  CB  ALA A 134      61.788   0.728  17.012  1.00 64.17           C  
ATOM   1007  N   GLU A 135      60.039   1.927  19.349  1.00 68.86           N  
ATOM   1008  CA  GLU A 135      59.025   1.746  20.424  1.00 69.69           C  
ATOM   1009  C   GLU A 135      57.979   2.869  20.521  1.00 69.13           C  
ATOM   1010  O   GLU A 135      57.099   2.826  21.376  1.00 68.92           O  
ATOM   1011  CB  GLU A 135      59.713   1.579  21.796  1.00 69.19           C  
ATOM   1012  CG  GLU A 135      60.510   0.278  21.979  1.00 70.54           C  
ATOM   1013  CD  GLU A 135      61.550   0.368  23.103  1.00 72.61           C  
ATOM   1014  OE1 GLU A 135      61.270   1.049  24.108  1.00 82.28           O  
ATOM   1015  OE2 GLU A 135      62.645  -0.236  22.994  1.00 75.86           O  
ATOM   1016  N   HIS A 136      58.121   3.896  19.692  1.00 70.33           N  
ATOM   1017  CA  HIS A 136      57.123   4.959  19.551  1.00 70.50           C  
ATOM   1018  C   HIS A 136      56.546   4.979  18.123  1.00 69.36           C  
ATOM   1019  O   HIS A 136      55.411   5.392  17.930  1.00 69.17           O  
ATOM   1020  CB  HIS A 136      57.737   6.304  19.962  1.00 71.18           C  
ATOM   1021  CG  HIS A 136      58.178   6.335  21.396  1.00 74.54           C  
ATOM   1022  ND1 HIS A 136      59.412   5.873  21.807  1.00 74.44           N  
ATOM   1023  CD2 HIS A 136      57.533   6.729  22.521  1.00 77.75           C  
ATOM   1024  CE1 HIS A 136      59.515   5.996  23.119  1.00 73.36           C  
ATOM   1025  NE2 HIS A 136      58.390   6.515  23.576  1.00 78.13           N  
ATOM   1026  N   LEU A 137      57.321   4.513  17.140  1.00 69.07           N  
ATOM   1027  CA  LEU A 137      56.867   4.388  15.751  1.00 68.55           C  
ATOM   1028  C   LEU A 137      55.937   3.187  15.620  1.00 68.47           C  
ATOM   1029  O   LEU A 137      54.764   3.259  15.982  1.00 69.02           O  
ATOM   1030  CB  LEU A 137      58.057   4.218  14.794  1.00 67.95           C  
TER    1031      LEU A 137                                                      
END
MOLECULE T0460.pdb
ATOM      1  N   MET     1      79.050 -11.695  -3.149  1.00  0.00           N
ATOM      2  CA  MET     1      79.035 -10.947  -4.424  1.00  0.00           C
ATOM      3  C   MET     1      80.358 -11.127  -5.155  1.00  0.00           C
ATOM      4  O   MET     1      81.385 -11.403  -4.535  1.00  0.00           O
ATOM      5  CB  MET     1      78.786  -9.452  -4.173  1.00  0.00           C
ATOM      6  CG  MET     1      80.015  -8.686  -3.690  1.00  0.00           C
ATOM      7  SD  MET     1      80.670  -9.303  -2.126  1.00  0.00           S
ATOM      8  CE  MET     1      82.239  -8.439  -2.056  1.00  0.00           C
ATOM      9  HA  MET     1      78.240 -11.341  -5.040  1.00  0.00           H
ATOM     10  HB1 MET     1      78.012  -9.350  -3.427  1.00  0.00           H
ATOM     11  HB2 MET     1      78.447  -8.997  -5.092  1.00  0.00           H
ATOM     12  HG1 MET     1      79.746  -7.646  -3.565  1.00  0.00           H
ATOM     13  HG2 MET     1      80.787  -8.766  -4.440  1.00  0.00           H
ATOM     14  HE1 MET     1      82.759  -8.708  -1.149  1.00  0.00           H
ATOM     15  HE2 MET     1      82.063  -7.374  -2.069  1.00  0.00           H
ATOM     16  HE3 MET     1      82.839  -8.715  -2.910  1.00  0.00           H
ATOM     17  HT1 MET     1      79.122 -12.720  -3.335  1.00  0.00           H
ATOM     18  HT2 MET     1      78.173 -11.510  -2.615  1.00  0.00           H
ATOM     19  HT3 MET     1      79.863 -11.402  -2.571  1.00  0.00           H
ATOM     20  N   ASN     2      80.328 -10.981  -6.468  1.00  0.00           N
ATOM     21  CA  ASN     2      81.547 -11.002  -7.265  1.00  0.00           C
ATOM     22  C   ASN     2      82.085  -9.588  -7.431  1.00  0.00           C
ATOM     23  O   ASN     2      81.383  -8.614  -7.154  1.00  0.00           O
ATOM     24  CB  ASN     2      81.291 -11.625  -8.642  1.00  0.00           C
ATOM     25  CG  ASN     2      81.062 -13.122  -8.572  1.00  0.00           C
ATOM     26  ND2 ASN     2      82.123 -13.896  -8.751  1.00  0.00           N
ATOM     27  OD1 ASN     2      79.938 -13.582  -8.369  1.00  0.00           O
ATOM     28  HN  ASN     2      79.462 -10.866  -6.918  1.00  0.00           H
ATOM     29  HA  ASN     2      82.279 -11.595  -6.738  1.00  0.00           H
ATOM     30  HB1 ASN     2      82.146 -11.440  -9.276  1.00  0.00           H
ATOM     31  HB2 ASN     2      80.418 -11.167  -9.081  1.00  0.00           H
ATOM     32 HD21 ASN     2      82.998 -13.465  -8.919  1.00  0.00           H
ATOM     33 HD22 ASN     2      81.999 -14.867  -8.716  1.00  0.00           H
ATOM     34  N   SER     3      83.324  -9.479  -7.883  1.00  0.00           N
ATOM     35  CA  SER     3      83.958  -8.185  -8.112  1.00  0.00           C
ATOM     36  C   SER     3      83.225  -7.422  -9.210  1.00  0.00           C
ATOM     37  O   SER     3      83.208  -6.191  -9.230  1.00  0.00           O
ATOM     38  CB  SER     3      85.418  -8.390  -8.506  1.00  0.00           C
ATOM     39  OG  SER     3      86.042  -9.316  -7.636  1.00  0.00           O
ATOM     40  HN  SER     3      83.845 -10.304  -8.058  1.00  0.00           H
ATOM     41  HA  SER     3      83.911  -7.619  -7.193  1.00  0.00           H
ATOM     42  HB1 SER     3      85.943  -7.447  -8.447  1.00  0.00           H
ATOM     43  HB2 SER     3      85.469  -8.770  -9.515  1.00  0.00           H
ATOM     44  HG  SER     3      85.679 -10.203  -7.801  1.00  0.00           H
ATOM     45  N   GLU     4      82.609  -8.178 -10.111  1.00  0.00           N
ATOM     46  CA  GLU     4      81.831  -7.614 -11.202  1.00  0.00           C
ATOM     47  C   GLU     4      80.642  -6.825 -10.650  1.00  0.00           C
ATOM     48  O   GLU     4      80.244  -5.805 -11.209  1.00  0.00           O
ATOM     49  CB  GLU     4      81.365  -8.747 -12.119  1.00  0.00           C
ATOM     50  CG  GLU     4      80.777  -8.287 -13.440  1.00  0.00           C
ATOM     51  CD  GLU     4      80.576  -9.439 -14.402  1.00  0.00           C
ATOM     52  OE1 GLU     4      81.532  -9.780 -15.131  1.00  0.00           O
ATOM     53  OE2 GLU     4      79.470 -10.016 -14.432  1.00  0.00           O
ATOM     54  HN  GLU     4      82.686  -9.152 -10.040  1.00  0.00           H
ATOM     55  HA  GLU     4      82.470  -6.945 -11.758  1.00  0.00           H
ATOM     56  HB1 GLU     4      80.615  -9.326 -11.600  1.00  0.00           H
ATOM     57  HB2 GLU     4      82.209  -9.385 -12.335  1.00  0.00           H
ATOM     58  HG1 GLU     4      81.447  -7.571 -13.891  1.00  0.00           H
ATOM     59  HG2 GLU     4      79.821  -7.819 -13.254  1.00  0.00           H
ATOM     60  N   VAL     5      80.108  -7.289  -9.524  1.00  0.00           N
ATOM     61  CA  VAL     5      79.007  -6.610  -8.848  1.00  0.00           C
ATOM     62  C   VAL     5      79.475  -5.264  -8.302  1.00  0.00           C
ATOM     63  O   VAL     5      78.759  -4.265  -8.377  1.00  0.00           O
ATOM     64  CB  VAL     5      78.447  -7.466  -7.689  1.00  0.00           C
ATOM     65  CG1 VAL     5      77.344  -6.727  -6.941  1.00  0.00           C
ATOM     66  CG2 VAL     5      77.942  -8.805  -8.212  1.00  0.00           C
ATOM     67  HN  VAL     5      80.471  -8.109  -9.133  1.00  0.00           H
ATOM     68  HA  VAL     5      78.219  -6.446  -9.569  1.00  0.00           H
ATOM     69  HB  VAL     5      79.251  -7.659  -6.994  1.00  0.00           H
ATOM     70 HG11 VAL     5      77.750  -5.829  -6.493  1.00  0.00           H
ATOM     71 HG12 VAL     5      76.946  -7.365  -6.165  1.00  0.00           H
ATOM     72 HG13 VAL     5      76.555  -6.462  -7.628  1.00  0.00           H
ATOM     73 HG21 VAL     5      77.543  -9.385  -7.393  1.00  0.00           H
ATOM     74 HG22 VAL     5      78.761  -9.343  -8.667  1.00  0.00           H
ATOM     75 HG23 VAL     5      77.169  -8.639  -8.948  1.00  0.00           H
ATOM     76  N   ILE     6      80.694  -5.245  -7.776  1.00  0.00           N
ATOM     77  CA  ILE     6      81.274  -4.028  -7.224  1.00  0.00           C
ATOM     78  C   ILE     6      81.443  -2.976  -8.316  1.00  0.00           C
ATOM     79  O   ILE     6      81.180  -1.795  -8.100  1.00  0.00           O
ATOM     80  CB  ILE     6      82.640  -4.309  -6.559  1.00  0.00           C
ATOM     81  CG1 ILE     6      82.489  -5.388  -5.484  1.00  0.00           C
ATOM     82  CG2 ILE     6      83.216  -3.033  -5.956  1.00  0.00           C
ATOM     83  CD1 ILE     6      83.796  -5.789  -4.833  1.00  0.00           C
ATOM     84  HN  ILE     6      81.218  -6.074  -7.760  1.00  0.00           H
ATOM     85  HA  ILE     6      80.598  -3.649  -6.472  1.00  0.00           H
ATOM     86  HB  ILE     6      83.321  -4.659  -7.320  1.00  0.00           H
ATOM     87 HG11 ILE     6      82.056  -6.272  -5.931  1.00  0.00           H
ATOM     88 HG12 ILE     6      81.832  -5.025  -4.709  1.00  0.00           H
ATOM     89 HG21 ILE     6      84.169  -3.252  -5.495  1.00  0.00           H
ATOM     90 HG22 ILE     6      82.536  -2.647  -5.211  1.00  0.00           H
ATOM     91 HG23 ILE     6      83.354  -2.296  -6.734  1.00  0.00           H
ATOM     92 HD11 ILE     6      84.243  -4.927  -4.361  1.00  0.00           H
ATOM     93 HD12 ILE     6      84.469  -6.177  -5.584  1.00  0.00           H
ATOM     94 HD13 ILE     6      83.609  -6.549  -4.090  1.00  0.00           H
ATOM     95  N   LYS     7      81.858  -3.421  -9.496  1.00  0.00           N
ATOM     96  CA  LYS     7      82.045  -2.525 -10.632  1.00  0.00           C
ATOM     97  C   LYS     7      80.717  -1.908 -11.058  1.00  0.00           C
ATOM     98  O   LYS     7      80.646  -0.718 -11.373  1.00  0.00           O
ATOM     99  CB  LYS     7      82.684  -3.278 -11.799  1.00  0.00           C
ATOM    100  CG  LYS     7      84.053  -3.847 -11.466  1.00  0.00           C
ATOM    101  CD  LYS     7      84.677  -4.564 -12.652  1.00  0.00           C
ATOM    102  CE  LYS     7      86.074  -5.055 -12.312  1.00  0.00           C
ATOM    103  NZ  LYS     7      86.763  -5.669 -13.478  1.00  0.00           N
ATOM    104  HN  LYS     7      82.047  -4.378  -9.606  1.00  0.00           H
ATOM    105  HA  LYS     7      82.710  -1.733 -10.320  1.00  0.00           H
ATOM    106  HB1 LYS     7      82.790  -2.603 -12.636  1.00  0.00           H
ATOM    107  HB2 LYS     7      82.038  -4.095 -12.084  1.00  0.00           H
ATOM    108  HG1 LYS     7      83.950  -4.546 -10.649  1.00  0.00           H
ATOM    109  HG2 LYS     7      84.703  -3.039 -11.168  1.00  0.00           H
ATOM    110  HD1 LYS     7      84.736  -3.880 -13.485  1.00  0.00           H
ATOM    111  HD2 LYS     7      84.062  -5.410 -12.917  1.00  0.00           H
ATOM    112  HE1 LYS     7      86.000  -5.788 -11.523  1.00  0.00           H
ATOM    113  HE2 LYS     7      86.659  -4.216 -11.965  1.00  0.00           H
ATOM    114  HZ1 LYS     7      86.652  -5.068 -14.322  1.00  0.00           H
ATOM    115  HZ2 LYS     7      86.372  -6.612 -13.682  1.00  0.00           H
ATOM    116  HZ3 LYS     7      87.785  -5.766 -13.275  1.00  0.00           H
ATOM    117  N   GLU     8      79.664  -2.718 -11.043  1.00  0.00           N
ATOM    118  CA  GLU     8      78.325  -2.243 -11.373  1.00  0.00           C
ATOM    119  C   GLU     8      77.814  -1.282 -10.302  1.00  0.00           C
ATOM    120  O   GLU     8      77.136  -0.301 -10.605  1.00  0.00           O
ATOM    121  CB  GLU     8      77.368  -3.423 -11.525  1.00  0.00           C
ATOM    122  CG  GLU     8      77.750  -4.366 -12.653  1.00  0.00           C
ATOM    123  CD  GLU     8      77.825  -3.668 -13.993  1.00  0.00           C
ATOM    124  OE1 GLU     8      76.763  -3.424 -14.599  1.00  0.00           O
ATOM    125  OE2 GLU     8      78.946  -3.366 -14.455  1.00  0.00           O
ATOM    126  HN  GLU     8      79.792  -3.664 -10.813  1.00  0.00           H
ATOM    127  HA  GLU     8      78.385  -1.715 -12.313  1.00  0.00           H
ATOM    128  HB1 GLU     8      76.375  -3.046 -11.720  1.00  0.00           H
ATOM    129  HB2 GLU     8      77.357  -3.984 -10.602  1.00  0.00           H
ATOM    130  HG1 GLU     8      77.011  -5.153 -12.713  1.00  0.00           H
ATOM    131  HG2 GLU     8      78.716  -4.797 -12.434  1.00  0.00           H
ATOM    132  N   PHE     9      78.149  -1.567  -9.050  1.00  0.00           N
ATOM    133  CA  PHE     9      77.794  -0.688  -7.944  1.00  0.00           C
ATOM    134  C   PHE     9      78.456   0.677  -8.120  1.00  0.00           C
ATOM    135  O   PHE     9      77.824   1.717  -7.926  1.00  0.00           O
ATOM    136  CB  PHE     9      78.210  -1.318  -6.610  1.00  0.00           C
ATOM    137  CG  PHE     9      77.882  -0.479  -5.405  1.00  0.00           C
ATOM    138  CD1 PHE     9      76.570  -0.341  -4.977  1.00  0.00           C
ATOM    139  CD2 PHE     9      78.885   0.166  -4.699  1.00  0.00           C
ATOM    140  CE1 PHE     9      76.267   0.423  -3.866  1.00  0.00           C
ATOM    141  CE2 PHE     9      78.587   0.931  -3.588  1.00  0.00           C
ATOM    142  CZ  PHE     9      77.276   1.061  -3.172  1.00  0.00           C
ATOM    143  HN  PHE     9      78.638  -2.400  -8.864  1.00  0.00           H
ATOM    144  HA  PHE     9      76.721  -0.559  -7.954  1.00  0.00           H
ATOM    145  HB1 PHE     9      79.279  -1.481  -6.619  1.00  0.00           H
ATOM    146  HB2 PHE     9      77.710  -2.268  -6.497  1.00  0.00           H
ATOM    147  HD1 PHE     9      75.781  -0.839  -5.519  1.00  0.00           H
ATOM    148  HD2 PHE     9      79.910   0.065  -5.024  1.00  0.00           H
ATOM    149  HE1 PHE     9      75.242   0.523  -3.542  1.00  0.00           H
ATOM    150  HE2 PHE     9      79.378   1.428  -3.048  1.00  0.00           H
ATOM    151  HZ  PHE     9      77.042   1.659  -2.304  1.00  0.00           H
ATOM    152  N   LEU    10      79.729   0.661  -8.505  1.00  0.00           N
ATOM    153  CA  LEU    10      80.478   1.889  -8.756  1.00  0.00           C
ATOM    154  C   LEU    10      79.896   2.640  -9.949  1.00  0.00           C
ATOM    155  O   LEU    10      79.919   3.871  -9.992  1.00  0.00           O
ATOM    156  CB  LEU    10      81.954   1.571  -9.004  1.00  0.00           C
ATOM    157  CG  LEU    10      82.680   0.902  -7.834  1.00  0.00           C
ATOM    158  CD1 LEU    10      84.099   0.532  -8.231  1.00  0.00           C
ATOM    159  CD2 LEU    10      82.688   1.812  -6.615  1.00  0.00           C
ATOM    160  HN  LEU    10      80.183  -0.205  -8.617  1.00  0.00           H
ATOM    161  HA  LEU    10      80.394   2.513  -7.878  1.00  0.00           H
ATOM    162  HB1 LEU    10      82.465   2.494  -9.236  1.00  0.00           H
ATOM    163  HB2 LEU    10      82.019   0.917  -9.862  1.00  0.00           H
ATOM    164  HG  LEU    10      82.160  -0.007  -7.569  1.00  0.00           H
ATOM    165 HD11 LEU    10      84.591   0.050  -7.399  1.00  0.00           H
ATOM    166 HD12 LEU    10      84.642   1.425  -8.502  1.00  0.00           H
ATOM    167 HD13 LEU    10      84.074  -0.144  -9.073  1.00  0.00           H
ATOM    168 HD21 LEU    10      81.672   2.025  -6.320  1.00  0.00           H
ATOM    169 HD22 LEU    10      83.194   2.735  -6.857  1.00  0.00           H
ATOM    170 HD23 LEU    10      83.204   1.322  -5.803  1.00  0.00           H
ATOM    171  N   GLU    11      79.369   1.888 -10.907  1.00  0.00           N
ATOM    172  CA  GLU    11      78.721   2.469 -12.075  1.00  0.00           C
ATOM    173  C   GLU    11      77.494   3.274 -11.656  1.00  0.00           C
ATOM    174  O   GLU    11      77.310   4.415 -12.085  1.00  0.00           O
ATOM    175  CB  GLU    11      78.310   1.365 -13.051  1.00  0.00           C
ATOM    176  CG  GLU    11      77.572   1.874 -14.276  1.00  0.00           C
ATOM    177  CD  GLU    11      76.949   0.756 -15.083  1.00  0.00           C
ATOM    178  OE1 GLU    11      77.548   0.346 -16.099  1.00  0.00           O
ATOM    179  OE2 GLU    11      75.857   0.283 -14.707  1.00  0.00           O
ATOM    180  HN  GLU    11      79.422   0.912 -10.828  1.00  0.00           H
ATOM    181  HA  GLU    11      79.427   3.127 -12.560  1.00  0.00           H
ATOM    182  HB1 GLU    11      77.668   0.667 -12.535  1.00  0.00           H
ATOM    183  HB2 GLU    11      79.197   0.845 -13.383  1.00  0.00           H
ATOM    184  HG1 GLU    11      78.269   2.407 -14.905  1.00  0.00           H
ATOM    185  HG2 GLU    11      76.788   2.546 -13.957  1.00  0.00           H
ATOM    186  N   ASP    12      76.669   2.677 -10.802  1.00  0.00           N
ATOM    187  CA  ASP    12      75.439   3.316 -10.347  1.00  0.00           C
ATOM    188  C   ASP    12      75.738   4.578  -9.548  1.00  0.00           C
ATOM    189  O   ASP    12      75.213   5.649  -9.849  1.00  0.00           O
ATOM    190  CB  ASP    12      74.609   2.353  -9.498  1.00  0.00           C
ATOM    191  CG  ASP    12      73.317   2.984  -9.007  1.00  0.00           C
ATOM    192  OD1 ASP    12      73.279   3.459  -7.850  1.00  0.00           O
ATOM    193  OD2 ASP    12      72.333   3.007  -9.776  1.00  0.00           O
ATOM    194  HN  ASP    12      76.891   1.778 -10.474  1.00  0.00           H
ATOM    195  HA  ASP    12      74.870   3.589 -11.223  1.00  0.00           H
ATOM    196  HB1 ASP    12      75.188   2.048  -8.639  1.00  0.00           H
ATOM    197  HB2 ASP    12      74.362   1.483 -10.088  1.00  0.00           H
ATOM    198  N   ILE    13      76.595   4.453  -8.540  1.00  0.00           N
ATOM    199  CA  ILE    13      76.907   5.584  -7.671  1.00  0.00           C
ATOM    200  C   ILE    13      77.674   6.668  -8.427  1.00  0.00           C
ATOM    201  O   ILE    13      77.589   7.849  -8.088  1.00  0.00           O
ATOM    202  CB  ILE    13      77.706   5.161  -6.418  1.00  0.00           C
ATOM    203  CG1 ILE    13      79.052   4.538  -6.806  1.00  0.00           C
ATOM    204  CG2 ILE    13      76.889   4.187  -5.579  1.00  0.00           C
ATOM    205  CD1 ILE    13      79.922   4.187  -5.619  1.00  0.00           C
ATOM    206  HN  ILE    13      77.023   3.583  -8.375  1.00  0.00           H
ATOM    207  HA  ILE    13      75.967   6.004  -7.339  1.00  0.00           H
ATOM    208  HB  ILE    13      77.886   6.043  -5.823  1.00  0.00           H
ATOM    209 HG11 ILE    13      79.598   5.237  -7.424  1.00  0.00           H
ATOM    210 HG12 ILE    13      78.874   3.633  -7.366  1.00  0.00           H
ATOM    211 HG21 ILE    13      75.974   4.665  -5.265  1.00  0.00           H
ATOM    212 HG22 ILE    13      77.459   3.894  -4.709  1.00  0.00           H
ATOM    213 HG23 ILE    13      76.654   3.312  -6.167  1.00  0.00           H
ATOM    214 HD11 ILE    13      79.407   3.471  -4.995  1.00  0.00           H
ATOM    215 HD12 ILE    13      80.129   5.081  -5.048  1.00  0.00           H
ATOM    216 HD13 ILE    13      80.850   3.760  -5.968  1.00  0.00           H
ATOM    217  N   GLY    14      78.408   6.263  -9.456  1.00  0.00           N
ATOM    218  CA  GLY    14      79.141   7.215 -10.265  1.00  0.00           C
ATOM    219  C   GLY    14      80.552   7.430  -9.769  1.00  0.00           C
ATOM    220  O   GLY    14      80.941   8.554  -9.443  1.00  0.00           O
ATOM    221  HN  GLY    14      78.456   5.306  -9.666  1.00  0.00           H
ATOM    222  HA1 GLY    14      78.618   8.159 -10.252  1.00  0.00           H
ATOM    223  HA2 GLY    14      79.178   6.852 -11.282  1.00  0.00           H
ATOM    224  N   GLU    15      81.322   6.354  -9.705  1.00  0.00           N
ATOM    225  CA  GLU    15      82.699   6.435  -9.253  1.00  0.00           C
ATOM    226  C   GLU    15      83.602   5.599 -10.157  1.00  0.00           C
ATOM    227  O   GLU    15      83.174   4.583 -10.703  1.00  0.00           O
ATOM    228  CB  GLU    15      82.806   5.961  -7.801  1.00  0.00           C
ATOM    229  CG  GLU    15      84.159   6.241  -7.173  1.00  0.00           C
ATOM    230  CD  GLU    15      84.554   7.698  -7.295  1.00  0.00           C
ATOM    231  OE1 GLU    15      84.244   8.485  -6.382  1.00  0.00           O
ATOM    232  OE2 GLU    15      85.172   8.066  -8.313  1.00  0.00           O
ATOM    233  HN  GLU    15      80.955   5.482  -9.973  1.00  0.00           H
ATOM    234  HA  GLU    15      83.007   7.467  -9.310  1.00  0.00           H
ATOM    235  HB1 GLU    15      82.629   4.896  -7.767  1.00  0.00           H
ATOM    236  HB2 GLU    15      82.050   6.462  -7.214  1.00  0.00           H
ATOM    237  HG1 GLU    15      84.905   5.637  -7.668  1.00  0.00           H
ATOM    238  HG2 GLU    15      84.119   5.980  -6.125  1.00  0.00           H
ATOM    239  N   ASP    16      84.843   6.040 -10.317  1.00  0.00           N
ATOM    240  CA  ASP    16      85.801   5.346 -11.170  1.00  0.00           C
ATOM    241  C   ASP    16      86.675   4.412 -10.347  1.00  0.00           C
ATOM    242  O   ASP    16      87.091   4.753  -9.239  1.00  0.00           O
ATOM    243  CB  ASP    16      86.693   6.344 -11.919  1.00  0.00           C
ATOM    244  CG  ASP    16      85.940   7.165 -12.945  1.00  0.00           C
ATOM    245  OD1 ASP    16      85.679   6.650 -14.054  1.00  0.00           O
ATOM    246  OD2 ASP    16      85.624   8.342 -12.659  1.00  0.00           O
ATOM    247  HN  ASP    16      85.132   6.847  -9.829  1.00  0.00           H
ATOM    248  HA  ASP    16      85.245   4.763 -11.888  1.00  0.00           H
ATOM    249  HB1 ASP    16      87.477   5.800 -12.427  1.00  0.00           H
ATOM    250  HB2 ASP    16      87.139   7.020 -11.206  1.00  0.00           H
ATOM    251  N   TYR    17      86.952   3.234 -10.885  1.00  0.00           N
ATOM    252  CA  TYR    17      87.833   2.289 -10.217  1.00  0.00           C
ATOM    253  C   TYR    17      89.127   2.120 -11.002  1.00  0.00           C
ATOM    254  O   TYR    17      89.125   2.132 -12.236  1.00  0.00           O
ATOM    255  CB  TYR    17      87.143   0.928 -10.018  1.00  0.00           C
ATOM    256  CG  TYR    17      86.803   0.188 -11.297  1.00  0.00           C
ATOM    257  CD1 TYR    17      87.708  -0.694 -11.876  1.00  0.00           C
ATOM    258  CD2 TYR    17      85.574   0.364 -11.919  1.00  0.00           C
ATOM    259  CE1 TYR    17      87.400  -1.374 -13.038  1.00  0.00           C
ATOM    260  CE2 TYR    17      85.259  -0.312 -13.081  1.00  0.00           C
ATOM    261  CZ  TYR    17      86.175  -1.178 -13.636  1.00  0.00           C
ATOM    262  OH  TYR    17      85.867  -1.853 -14.793  1.00  0.00           O
ATOM    263  HN  TYR    17      86.553   2.995 -11.754  1.00  0.00           H
ATOM    264  HA  TYR    17      88.073   2.701  -9.247  1.00  0.00           H
ATOM    265  HB1 TYR    17      86.223   1.082  -9.472  1.00  0.00           H
ATOM    266  HB2 TYR    17      87.793   0.291  -9.438  1.00  0.00           H
ATOM    267  HD1 TYR    17      88.669  -0.843 -11.406  1.00  0.00           H
ATOM    268  HD2 TYR    17      84.858   1.045 -11.484  1.00  0.00           H
ATOM    269  HE1 TYR    17      88.118  -2.055 -13.472  1.00  0.00           H
ATOM    270  HE2 TYR    17      84.299  -0.158 -13.552  1.00  0.00           H
ATOM    271  HH  TYR    17      85.586  -1.222 -15.473  1.00  0.00           H
ATOM    272  N   ILE    18      90.233   1.985 -10.289  1.00  0.00           N
ATOM    273  CA  ILE    18      91.519   1.746 -10.923  1.00  0.00           C
ATOM    274  C   ILE    18      91.884   0.273 -10.811  1.00  0.00           C
ATOM    275  O   ILE    18      92.389  -0.177  -9.779  1.00  0.00           O
ATOM    276  CB  ILE    18      92.639   2.607 -10.294  1.00  0.00           C
ATOM    277  CG1 ILE    18      92.263   4.091 -10.350  1.00  0.00           C
ATOM    278  CG2 ILE    18      93.965   2.361 -11.008  1.00  0.00           C
ATOM    279  CD1 ILE    18      93.276   5.001  -9.687  1.00  0.00           C
ATOM    280  HN  ILE    18      90.185   2.044  -9.310  1.00  0.00           H
ATOM    281  HA  ILE    18      91.430   2.008 -11.968  1.00  0.00           H
ATOM    282  HB  ILE    18      92.752   2.310  -9.263  1.00  0.00           H
ATOM    283 HG11 ILE    18      91.313   4.236  -9.854  1.00  0.00           H
ATOM    284 HG12 ILE    18      92.173   4.394 -11.382  1.00  0.00           H
ATOM    285 HG21 ILE    18      94.230   1.317 -10.926  1.00  0.00           H
ATOM    286 HG22 ILE    18      94.736   2.964 -10.552  1.00  0.00           H
ATOM    287 HG23 ILE    18      93.868   2.628 -12.050  1.00  0.00           H
ATOM    288 HD11 ILE    18      94.235   4.884 -10.171  1.00  0.00           H
ATOM    289 HD12 ILE    18      93.365   4.739  -8.643  1.00  0.00           H
ATOM    290 HD13 ILE    18      92.951   6.026  -9.775  1.00  0.00           H
ATOM    291  N   GLU    19      91.597  -0.484 -11.858  1.00  0.00           N
ATOM    292  CA  GLU    19      91.879  -1.909 -11.854  1.00  0.00           C
ATOM    293  C   GLU    19      93.199  -2.201 -12.553  1.00  0.00           C
ATOM    294  O   GLU    19      93.394  -1.864 -13.719  1.00  0.00           O
ATOM    295  CB  GLU    19      90.742  -2.691 -12.512  1.00  0.00           C
ATOM    296  CG  GLU    19      90.972  -4.194 -12.522  1.00  0.00           C
ATOM    297  CD  GLU    19      89.744  -4.969 -12.942  1.00  0.00           C
ATOM    298  OE1 GLU    19      89.106  -5.595 -12.074  1.00  0.00           O
ATOM    299  OE2 GLU    19      89.400  -4.949 -14.138  1.00  0.00           O
ATOM    300  HN  GLU    19      91.189  -0.076 -12.650  1.00  0.00           H
ATOM    301  HA  GLU    19      91.963  -2.219 -10.824  1.00  0.00           H
ATOM    302  HB1 GLU    19      90.634  -2.358 -13.534  1.00  0.00           H
ATOM    303  HB2 GLU    19      89.824  -2.492 -11.978  1.00  0.00           H
ATOM    304  HG1 GLU    19      91.255  -4.509 -11.528  1.00  0.00           H
ATOM    305  HG2 GLU    19      91.771  -4.418 -13.211  1.00  0.00           H
ATOM    306  N   LEU    20      94.101  -2.825 -11.820  1.00  0.00           N
ATOM    307  CA  LEU    20      95.411  -3.188 -12.336  1.00  0.00           C
ATOM    308  C   LEU    20      95.509  -4.694 -12.516  1.00  0.00           C
ATOM    309  O   LEU    20      96.579  -5.280 -12.343  1.00  0.00           O
ATOM    310  CB  LEU    20      96.492  -2.712 -11.372  1.00  0.00           C
ATOM    311  CG  LEU    20      96.595  -1.197 -11.206  1.00  0.00           C
ATOM    312  CD1 LEU    20      97.650  -0.856 -10.175  1.00  0.00           C
ATOM    313  CD2 LEU    20      96.918  -0.531 -12.536  1.00  0.00           C
ATOM    314  HN  LEU    20      93.879  -3.048 -10.886  1.00  0.00           H
ATOM    315  HA  LEU    20      95.546  -2.704 -13.292  1.00  0.00           H
ATOM    316  HB1 LEU    20      97.443  -3.081 -11.722  1.00  0.00           H
ATOM    317  HB2 LEU    20      96.292  -3.146 -10.403  1.00  0.00           H
ATOM    318  HG  LEU    20      95.647  -0.813 -10.858  1.00  0.00           H
ATOM    319 HD11 LEU    20      97.386  -1.306  -9.231  1.00  0.00           H
ATOM    320 HD12 LEU    20      97.707   0.216 -10.061  1.00  0.00           H
ATOM    321 HD13 LEU    20      98.606  -1.236 -10.501  1.00  0.00           H
ATOM    322 HD21 LEU    20      96.134  -0.744 -13.246  1.00  0.00           H
ATOM    323 HD22 LEU    20      97.856  -0.914 -12.910  1.00  0.00           H
ATOM    324 HD23 LEU    20      96.996   0.537 -12.393  1.00  0.00           H
ATOM    325  N   GLU    21      94.380  -5.299 -12.879  1.00  0.00           N
ATOM    326  CA  GLU    21      94.267  -6.748 -13.046  1.00  0.00           C
ATOM    327  C   GLU    21      94.352  -7.446 -11.688  1.00  0.00           C
ATOM    328  O   GLU    21      95.436  -7.595 -11.119  1.00  0.00           O
ATOM    329  CB  GLU    21      95.344  -7.280 -14.001  1.00  0.00           C
ATOM    330  CG  GLU    21      95.273  -8.777 -14.241  1.00  0.00           C
ATOM    331  CD  GLU    21      96.444  -9.284 -15.052  1.00  0.00           C
ATOM    332  OE1 GLU    21      96.316  -9.392 -16.290  1.00  0.00           O
ATOM    333  OE2 GLU    21      97.504  -9.567 -14.457  1.00  0.00           O
ATOM    334  HN  GLU    21      93.589  -4.745 -13.040  1.00  0.00           H
ATOM    335  HA  GLU    21      93.294  -6.950 -13.470  1.00  0.00           H
ATOM    336  HB1 GLU    21      96.316  -7.049 -13.592  1.00  0.00           H
ATOM    337  HB2 GLU    21      95.239  -6.783 -14.953  1.00  0.00           H
ATOM    338  HG1 GLU    21      94.360  -9.002 -14.773  1.00  0.00           H
ATOM    339  HG2 GLU    21      95.269  -9.283 -13.287  1.00  0.00           H
ATOM    340  N   ASN    22      93.189  -7.837 -11.166  1.00  0.00           N
ATOM    341  CA  ASN    22      93.078  -8.474  -9.846  1.00  0.00           C
ATOM    342  C   ASN    22      93.396  -7.502  -8.713  1.00  0.00           C
ATOM    343  O   ASN    22      93.421  -7.889  -7.547  1.00  0.00           O
ATOM    344  CB  ASN    22      93.960  -9.722  -9.738  1.00  0.00           C
ATOM    345  CG  ASN    22      93.296 -10.956 -10.318  1.00  0.00           C
ATOM    346  ND2 ASN    22      92.574 -11.688  -9.483  1.00  0.00           N
ATOM    347  OD1 ASN    22      93.433 -11.252 -11.506  1.00  0.00           O
ATOM    348  HN  ASN    22      92.369  -7.700 -11.690  1.00  0.00           H
ATOM    349  HA  ASN    22      92.047  -8.781  -9.735  1.00  0.00           H
ATOM    350  HB1 ASN    22      94.182  -9.910  -8.696  1.00  0.00           H
ATOM    351  HB2 ASN    22      94.883  -9.549 -10.272  1.00  0.00           H
ATOM    352 HD21 ASN    22      92.510 -11.398  -8.547  1.00  0.00           H
ATOM    353 HD22 ASN    22      92.135 -12.494  -9.830  1.00  0.00           H
ATOM    354  N   GLU    23      93.644  -6.246  -9.052  1.00  0.00           N
ATOM    355  CA  GLU    23      93.790  -5.203  -8.050  1.00  0.00           C
ATOM    356  C   GLU    23      92.906  -4.019  -8.387  1.00  0.00           C
ATOM    357  O   GLU    23      93.123  -3.343  -9.389  1.00  0.00           O
ATOM    358  CB  GLU    23      95.235  -4.721  -7.932  1.00  0.00           C
ATOM    359  CG  GLU    23      96.160  -5.681  -7.209  1.00  0.00           C
ATOM    360  CD  GLU    23      97.204  -4.948  -6.391  1.00  0.00           C
ATOM    361  OE1 GLU    23      97.607  -3.832  -6.789  1.00  0.00           O
ATOM    362  OE2 GLU    23      97.613  -5.477  -5.338  1.00  0.00           O
ATOM    363  HN  GLU    23      93.742  -6.016 -10.001  1.00  0.00           H
ATOM    364  HA  GLU    23      93.477  -5.610  -7.100  1.00  0.00           H
ATOM    365  HB1 GLU    23      95.244  -3.781  -7.400  1.00  0.00           H
ATOM    366  HB2 GLU    23      95.628  -4.562  -8.924  1.00  0.00           H
ATOM    367  HG1 GLU    23      96.663  -6.298  -7.939  1.00  0.00           H
ATOM    368  HG2 GLU    23      95.575  -6.303  -6.549  1.00  0.00           H
ATOM    369  N   ILE    24      91.914  -3.768  -7.556  1.00  0.00           N
ATOM    370  CA  ILE    24      91.066  -2.605  -7.729  1.00  0.00           C
ATOM    371  C   ILE    24      91.413  -1.561  -6.677  1.00  0.00           C
ATOM    372  O   ILE    24      91.059  -1.697  -5.510  1.00  0.00           O
ATOM    373  CB  ILE    24      89.562  -2.955  -7.645  1.00  0.00           C
ATOM    374  CG1 ILE    24      89.185  -3.949  -8.747  1.00  0.00           C
ATOM    375  CG2 ILE    24      88.717  -1.693  -7.763  1.00  0.00           C
ATOM    376  CD1 ILE    24      87.729  -4.367  -8.726  1.00  0.00           C
ATOM    377  HN  ILE    24      91.755  -4.374  -6.799  1.00  0.00           H
ATOM    378  HA  ILE    24      91.266  -2.193  -8.708  1.00  0.00           H
ATOM    379  HB  ILE    24      89.369  -3.403  -6.681  1.00  0.00           H
ATOM    380 HG11 ILE    24      89.789  -4.839  -8.643  1.00  0.00           H
ATOM    381 HG12 ILE    24      89.384  -3.498  -9.708  1.00  0.00           H
ATOM    382 HG21 ILE    24      88.924  -1.211  -8.707  1.00  0.00           H
ATOM    383 HG22 ILE    24      88.959  -1.019  -6.954  1.00  0.00           H
ATOM    384 HG23 ILE    24      87.670  -1.954  -7.714  1.00  0.00           H
ATOM    385 HD11 ILE    24      87.103  -3.497  -8.852  1.00  0.00           H
ATOM    386 HD12 ILE    24      87.504  -4.838  -7.780  1.00  0.00           H
ATOM    387 HD13 ILE    24      87.543  -5.064  -9.529  1.00  0.00           H
ATOM    388  N   HIS    25      92.144  -0.542  -7.088  1.00  0.00           N
ATOM    389  CA  HIS    25      92.526   0.527  -6.182  1.00  0.00           C
ATOM    390  C   HIS    25      91.439   1.587  -6.172  1.00  0.00           C
ATOM    391  O   HIS    25      91.096   2.144  -7.216  1.00  0.00           O
ATOM    392  CB  HIS    25      93.873   1.134  -6.589  1.00  0.00           C
ATOM    393  CG  HIS    25      95.041   0.205  -6.402  1.00  0.00           C
ATOM    394  CD2 HIS    25      95.404  -0.919  -7.071  1.00  0.00           C
ATOM    395  ND1 HIS    25      96.004   0.396  -5.436  1.00  0.00           N
ATOM    396  CE1 HIS    25      96.909  -0.563  -5.520  1.00  0.00           C
ATOM    397  NE2 HIS    25      96.569  -1.376  -6.501  1.00  0.00           N
ATOM    398  HN  HIS    25      92.410  -0.490  -8.034  1.00  0.00           H
ATOM    399  HA  HIS    25      92.612   0.106  -5.190  1.00  0.00           H
ATOM    400  HB1 HIS    25      94.054   2.017  -5.993  1.00  0.00           H
ATOM    401  HB2 HIS    25      93.835   1.412  -7.631  1.00  0.00           H
ATOM    402  HD1 HIS    25      96.018   1.130  -4.771  1.00  0.00           H
ATOM    403  HD2 HIS    25      94.874  -1.374  -7.896  1.00  0.00           H
ATOM    404  HE1 HIS    25      97.782  -0.661  -4.892  1.00  0.00           H
ATOM    405  HE2 HIS    25      96.985  -2.261  -6.674  1.00  0.00           H
ATOM    406  N   LEU    26      90.879   1.840  -5.001  1.00  0.00           N
ATOM    407  CA  LEU    26      89.762   2.762  -4.884  1.00  0.00           C
ATOM    408  C   LEU    26      90.109   3.953  -4.011  1.00  0.00           C
ATOM    409  O   LEU    26      91.168   4.005  -3.386  1.00  0.00           O
ATOM    410  CB  LEU    26      88.533   2.051  -4.314  1.00  0.00           C
ATOM    411  CG  LEU    26      87.850   1.068  -5.264  1.00  0.00           C
ATOM    412  CD1 LEU    26      86.659   0.416  -4.586  1.00  0.00           C
ATOM    413  CD2 LEU    26      87.409   1.775  -6.535  1.00  0.00           C
ATOM    414  HN  LEU    26      91.231   1.403  -4.192  1.00  0.00           H
ATOM    415  HA  LEU    26      89.526   3.118  -5.874  1.00  0.00           H
ATOM    416  HB1 LEU    26      87.810   2.801  -4.028  1.00  0.00           H
ATOM    417  HB2 LEU    26      88.835   1.511  -3.427  1.00  0.00           H
ATOM    418  HG  LEU    26      88.551   0.292  -5.537  1.00  0.00           H
ATOM    419 HD11 LEU    26      86.993  -0.119  -3.710  1.00  0.00           H
ATOM    420 HD12 LEU    26      86.189  -0.274  -5.271  1.00  0.00           H
ATOM    421 HD13 LEU    26      85.949   1.177  -4.295  1.00  0.00           H
ATOM    422 HD21 LEU    26      86.713   2.563  -6.285  1.00  0.00           H
ATOM    423 HD22 LEU    26      86.927   1.066  -7.192  1.00  0.00           H
ATOM    424 HD23 LEU    26      88.269   2.199  -7.031  1.00  0.00           H
ATOM    425  N   LYS    27      89.202   4.913  -3.989  1.00  0.00           N
ATOM    426  CA  LYS    27      89.343   6.080  -3.143  1.00  0.00           C
ATOM    427  C   LYS    27      88.919   5.729  -1.721  1.00  0.00           C
ATOM    428  O   LYS    27      87.907   5.059  -1.526  1.00  0.00           O
ATOM    429  CB  LYS    27      88.492   7.224  -3.694  1.00  0.00           C
ATOM    430  CG  LYS    27      88.868   7.625  -5.111  1.00  0.00           C
ATOM    431  CD  LYS    27      87.841   8.566  -5.712  1.00  0.00           C
ATOM    432  CE  LYS    27      88.221   8.967  -7.127  1.00  0.00           C
ATOM    433  NZ  LYS    27      87.143   9.743  -7.789  1.00  0.00           N
ATOM    434  HN  LYS    27      88.410   4.828  -4.555  1.00  0.00           H
ATOM    435  HA  LYS    27      90.381   6.373  -3.143  1.00  0.00           H
ATOM    436  HB1 LYS    27      88.610   8.086  -3.054  1.00  0.00           H
ATOM    437  HB2 LYS    27      87.454   6.922  -3.691  1.00  0.00           H
ATOM    438  HG1 LYS    27      88.930   6.736  -5.722  1.00  0.00           H
ATOM    439  HG2 LYS    27      89.828   8.120  -5.093  1.00  0.00           H
ATOM    440  HD1 LYS    27      87.776   9.454  -5.100  1.00  0.00           H
ATOM    441  HD2 LYS    27      86.882   8.070  -5.735  1.00  0.00           H
ATOM    442  HE1 LYS    27      88.415   8.073  -7.699  1.00  0.00           H
ATOM    443  HE2 LYS    27      89.115   9.571  -7.087  1.00  0.00           H
ATOM    444  HZ1 LYS    27      86.938  10.612  -7.254  1.00  0.00           H
ATOM    445  HZ2 LYS    27      86.273   9.167  -7.846  1.00  0.00           H
ATOM    446  HZ3 LYS    27      87.428  10.000  -8.759  1.00  0.00           H
ATOM    447  N   PRO    28      89.696   6.170  -0.720  1.00  0.00           N
ATOM    448  CA  PRO    28      89.474   5.825   0.696  1.00  0.00           C
ATOM    449  C   PRO    28      88.033   6.021   1.167  1.00  0.00           C
ATOM    450  O   PRO    28      87.481   5.163   1.856  1.00  0.00           O
ATOM    451  CB  PRO    28      90.422   6.770   1.431  1.00  0.00           C
ATOM    452  CG  PRO    28      91.524   7.005   0.463  1.00  0.00           C
ATOM    453  CD  PRO    28      90.878   7.033  -0.892  1.00  0.00           C
ATOM    454  HA  PRO    28      89.766   4.807   0.895  1.00  0.00           H
ATOM    455  HB1 PRO    28      90.783   6.297   2.333  1.00  0.00           H
ATOM    456  HB2 PRO    28      89.905   7.687   1.679  1.00  0.00           H
ATOM    457  HG1 PRO    28      92.242   6.200   0.519  1.00  0.00           H
ATOM    458  HG2 PRO    28      92.001   7.952   0.671  1.00  0.00           H
ATOM    459  HD1 PRO    28      91.545   6.627  -1.636  1.00  0.00           H
ATOM    460  HD2 PRO    28      90.586   8.041  -1.151  1.00  0.00           H
ATOM    461  N   GLU    29      87.422   7.135   0.788  1.00  0.00           N
ATOM    462  CA  GLU    29      86.054   7.419   1.200  1.00  0.00           C
ATOM    463  C   GLU    29      85.073   6.444   0.550  1.00  0.00           C
ATOM    464  O   GLU    29      84.103   6.016   1.175  1.00  0.00           O
ATOM    465  CB  GLU    29      85.685   8.865   0.873  1.00  0.00           C
ATOM    466  CG  GLU    29      86.489   9.876   1.673  1.00  0.00           C
ATOM    467  CD  GLU    29      86.039  11.300   1.443  1.00  0.00           C
ATOM    468  OE1 GLU    29      84.991  11.692   1.999  1.00  0.00           O
ATOM    469  OE2 GLU    29      86.732  12.035   0.709  1.00  0.00           O
ATOM    470  HN  GLU    29      87.900   7.780   0.227  1.00  0.00           H
ATOM    471  HA  GLU    29      86.004   7.282   2.271  1.00  0.00           H
ATOM    472  HB1 GLU    29      84.638   9.017   1.089  1.00  0.00           H
ATOM    473  HB2 GLU    29      85.860   9.043  -0.176  1.00  0.00           H
ATOM    474  HG1 GLU    29      87.529   9.793   1.391  1.00  0.00           H
ATOM    475  HG2 GLU    29      86.386   9.649   2.724  1.00  0.00           H
ATOM    476  N   VAL    30      85.347   6.078  -0.697  1.00  0.00           N
ATOM    477  CA  VAL    30      84.527   5.102  -1.405  1.00  0.00           C
ATOM    478  C   VAL    30      84.710   3.721  -0.782  1.00  0.00           C
ATOM    479  O   VAL    30      83.743   2.995  -0.550  1.00  0.00           O
ATOM    480  CB  VAL    30      84.898   5.033  -2.904  1.00  0.00           C
ATOM    481  CG1 VAL    30      83.962   4.095  -3.653  1.00  0.00           C
ATOM    482  CG2 VAL    30      84.883   6.420  -3.526  1.00  0.00           C
ATOM    483  HN  VAL    30      86.121   6.468  -1.148  1.00  0.00           H
ATOM    484  HA  VAL    30      83.493   5.400  -1.317  1.00  0.00           H
ATOM    485  HB  VAL    30      85.901   4.638  -2.985  1.00  0.00           H
ATOM    486 HG11 VAL    30      82.948   4.455  -3.568  1.00  0.00           H
ATOM    487 HG12 VAL    30      84.031   3.103  -3.229  1.00  0.00           H
ATOM    488 HG13 VAL    30      84.246   4.061  -4.695  1.00  0.00           H
ATOM    489 HG21 VAL    30      85.145   6.349  -4.571  1.00  0.00           H
ATOM    490 HG22 VAL    30      85.597   7.050  -3.017  1.00  0.00           H
ATOM    491 HG23 VAL    30      83.895   6.848  -3.432  1.00  0.00           H
ATOM    492  N   PHE    31      85.966   3.390  -0.497  1.00  0.00           N
ATOM    493  CA  PHE    31      86.329   2.113   0.106  1.00  0.00           C
ATOM    494  C   PHE    31      85.578   1.891   1.414  1.00  0.00           C
ATOM    495  O   PHE    31      85.038   0.815   1.649  1.00  0.00           O
ATOM    496  CB  PHE    31      87.841   2.073   0.352  1.00  0.00           C
ATOM    497  CG  PHE    31      88.334   0.813   1.008  1.00  0.00           C
ATOM    498  CD1 PHE    31      88.583   0.776   2.372  1.00  0.00           C
ATOM    499  CD2 PHE    31      88.557  -0.332   0.261  1.00  0.00           C
ATOM    500  CE1 PHE    31      89.046  -0.377   2.976  1.00  0.00           C
ATOM    501  CE2 PHE    31      89.020  -1.487   0.860  1.00  0.00           C
ATOM    502  CZ  PHE    31      89.262  -1.511   2.219  1.00  0.00           C
ATOM    503  HN  PHE    31      86.681   4.033  -0.706  1.00  0.00           H
ATOM    504  HA  PHE    31      86.064   1.328  -0.587  1.00  0.00           H
ATOM    505  HB1 PHE    31      88.113   2.905   0.984  1.00  0.00           H
ATOM    506  HB2 PHE    31      88.352   2.170  -0.594  1.00  0.00           H
ATOM    507  HD1 PHE    31      88.413   1.662   2.966  1.00  0.00           H
ATOM    508  HD2 PHE    31      88.368  -0.316  -0.802  1.00  0.00           H
ATOM    509  HE1 PHE    31      89.237  -0.392   4.039  1.00  0.00           H
ATOM    510  HE2 PHE    31      89.188  -2.372   0.267  1.00  0.00           H
ATOM    511  HZ  PHE    31      89.623  -2.414   2.688  1.00  0.00           H
ATOM    512  N   TYR    32      85.540   2.923   2.250  1.00  0.00           N
ATOM    513  CA  TYR    32      84.882   2.843   3.552  1.00  0.00           C
ATOM    514  C   TYR    32      83.410   2.455   3.407  1.00  0.00           C
ATOM    515  O   TYR    32      82.882   1.665   4.196  1.00  0.00           O
ATOM    516  CB  TYR    32      85.004   4.184   4.283  1.00  0.00           C
ATOM    517  CG  TYR    32      84.435   4.177   5.685  1.00  0.00           C
ATOM    518  CD1 TYR    32      85.166   3.661   6.748  1.00  0.00           C
ATOM    519  CD2 TYR    32      83.168   4.688   5.948  1.00  0.00           C
ATOM    520  CE1 TYR    32      84.654   3.655   8.030  1.00  0.00           C
ATOM    521  CE2 TYR    32      82.650   4.685   7.228  1.00  0.00           C
ATOM    522  CZ  TYR    32      83.397   4.168   8.265  1.00  0.00           C
ATOM    523  OH  TYR    32      82.884   4.162   9.543  1.00  0.00           O
ATOM    524  HN  TYR    32      85.973   3.765   1.986  1.00  0.00           H
ATOM    525  HA  TYR    32      85.387   2.083   4.130  1.00  0.00           H
ATOM    526  HB1 TYR    32      84.483   4.942   3.716  1.00  0.00           H
ATOM    527  HB2 TYR    32      86.048   4.451   4.354  1.00  0.00           H
ATOM    528  HD1 TYR    32      86.151   3.260   6.561  1.00  0.00           H
ATOM    529  HD2 TYR    32      82.586   5.092   5.134  1.00  0.00           H
ATOM    530  HE1 TYR    32      85.238   3.249   8.843  1.00  0.00           H
ATOM    531  HE2 TYR    32      81.666   5.087   7.414  1.00  0.00           H
ATOM    532  HH  TYR    32      83.527   4.544  10.152  1.00  0.00           H
ATOM    533  N   GLU    33      82.758   3.000   2.389  1.00  0.00           N
ATOM    534  CA  GLU    33      81.341   2.740   2.160  1.00  0.00           C
ATOM    535  C   GLU    33      81.130   1.360   1.543  1.00  0.00           C
ATOM    536  O   GLU    33      80.223   0.628   1.941  1.00  0.00           O
ATOM    537  CB  GLU    33      80.739   3.825   1.265  1.00  0.00           C
ATOM    538  CG  GLU    33      80.828   5.220   1.868  1.00  0.00           C
ATOM    539  CD  GLU    33      80.167   6.277   1.009  1.00  0.00           C
ATOM    540  OE1 GLU    33      78.946   6.495   1.163  1.00  0.00           O
ATOM    541  OE2 GLU    33      80.862   6.898   0.182  1.00  0.00           O
ATOM    542  HN  GLU    33      83.240   3.591   1.773  1.00  0.00           H
ATOM    543  HA  GLU    33      80.846   2.767   3.118  1.00  0.00           H
ATOM    544  HB1 GLU    33      79.698   3.597   1.091  1.00  0.00           H
ATOM    545  HB2 GLU    33      81.261   3.830   0.319  1.00  0.00           H
ATOM    546  HG1 GLU    33      81.870   5.478   1.992  1.00  0.00           H
ATOM    547  HG2 GLU    33      80.345   5.211   2.834  1.00  0.00           H
ATOM    548  N   VAL    34      81.976   1.002   0.582  1.00  0.00           N
ATOM    549  CA  VAL    34      81.895  -0.306  -0.064  1.00  0.00           C
ATOM    550  C   VAL    34      82.212  -1.418   0.936  1.00  0.00           C
ATOM    551  O   VAL    34      81.594  -2.484   0.911  1.00  0.00           O
ATOM    552  CB  VAL    34      82.852  -0.402  -1.274  1.00  0.00           C
ATOM    553  CG1 VAL    34      82.813  -1.789  -1.898  1.00  0.00           C
ATOM    554  CG2 VAL    34      82.507   0.654  -2.313  1.00  0.00           C
ATOM    555  HN  VAL    34      82.671   1.636   0.295  1.00  0.00           H
ATOM    556  HA  VAL    34      80.883  -0.437  -0.421  1.00  0.00           H
ATOM    557  HB  VAL    34      83.859  -0.216  -0.927  1.00  0.00           H
ATOM    558 HG11 VAL    34      81.808  -2.005  -2.230  1.00  0.00           H
ATOM    559 HG12 VAL    34      83.114  -2.522  -1.164  1.00  0.00           H
ATOM    560 HG13 VAL    34      83.487  -1.824  -2.741  1.00  0.00           H
ATOM    561 HG21 VAL    34      81.497   0.499  -2.662  1.00  0.00           H
ATOM    562 HG22 VAL    34      83.191   0.577  -3.145  1.00  0.00           H
ATOM    563 HG23 VAL    34      82.588   1.636  -1.870  1.00  0.00           H
ATOM    564  N   TRP    35      83.161  -1.146   1.823  1.00  0.00           N
ATOM    565  CA  TRP    35      83.542  -2.082   2.873  1.00  0.00           C
ATOM    566  C   TRP    35      82.322  -2.505   3.686  1.00  0.00           C
ATOM    567  O   TRP    35      82.034  -3.693   3.808  1.00  0.00           O
ATOM    568  CB  TRP    35      84.602  -1.436   3.775  1.00  0.00           C
ATOM    569  CG  TRP    35      85.005  -2.264   4.959  1.00  0.00           C
ATOM    570  CD1 TRP    35      85.361  -3.583   4.965  1.00  0.00           C
ATOM    571  CD2 TRP    35      85.114  -1.813   6.313  1.00  0.00           C
ATOM    572  CE2 TRP    35      85.530  -2.911   7.088  1.00  0.00           C
ATOM    573  CE3 TRP    35      84.896  -0.586   6.945  1.00  0.00           C
ATOM    574  NE1 TRP    35      85.671  -3.981   6.245  1.00  0.00           N
ATOM    575  CZ2 TRP    35      85.732  -2.818   8.463  1.00  0.00           C
ATOM    576  CZ3 TRP    35      85.098  -0.493   8.309  1.00  0.00           C
ATOM    577  CH2 TRP    35      85.513  -1.602   9.056  1.00  0.00           C
ATOM    578  HN  TRP    35      83.633  -0.284   1.763  1.00  0.00           H
ATOM    579  HA  TRP    35      83.965  -2.955   2.401  1.00  0.00           H
ATOM    580  HB1 TRP    35      84.220  -0.494   4.141  1.00  0.00           H
ATOM    581  HB2 TRP    35      85.488  -1.250   3.190  1.00  0.00           H
ATOM    582  HD1 TRP    35      85.382  -4.212   4.088  1.00  0.00           H
ATOM    583  HE1 TRP    35      85.953  -4.887   6.512  1.00  0.00           H
ATOM    584  HE3 TRP    35      84.576   0.281   6.386  1.00  0.00           H
ATOM    585  HZ2 TRP    35      86.054  -3.664   9.053  1.00  0.00           H
ATOM    586  HZ3 TRP    35      84.937   0.448   8.812  1.00  0.00           H
ATOM    587  HH2 TRP    35      85.662  -1.482  10.119  1.00  0.00           H
ATOM    588  N   LYS    36      81.586  -1.533   4.206  1.00  0.00           N
ATOM    589  CA  LYS    36      80.399  -1.828   5.002  1.00  0.00           C
ATOM    590  C   LYS    36      79.260  -2.348   4.126  1.00  0.00           C
ATOM    591  O   LYS    36      78.403  -3.098   4.594  1.00  0.00           O
ATOM    592  CB  LYS    36      79.953  -0.591   5.784  1.00  0.00           C
ATOM    593  CG  LYS    36      80.897  -0.222   6.917  1.00  0.00           C
ATOM    594  CD  LYS    36      80.401   0.988   7.689  1.00  0.00           C
ATOM    595  CE  LYS    36      81.248   1.248   8.925  1.00  0.00           C
ATOM    596  NZ  LYS    36      81.114   0.164   9.937  1.00  0.00           N
ATOM    597  HN  LYS    36      81.846  -0.599   4.055  1.00  0.00           H
ATOM    598  HA  LYS    36      80.668  -2.602   5.707  1.00  0.00           H
ATOM    599  HB1 LYS    36      78.976  -0.778   6.205  1.00  0.00           H
ATOM    600  HB2 LYS    36      79.891   0.248   5.106  1.00  0.00           H
ATOM    601  HG1 LYS    36      81.870   0.001   6.501  1.00  0.00           H
ATOM    602  HG2 LYS    36      80.977  -1.061   7.593  1.00  0.00           H
ATOM    603  HD1 LYS    36      79.379   0.814   7.994  1.00  0.00           H
ATOM    604  HD2 LYS    36      80.443   1.856   7.047  1.00  0.00           H
ATOM    605  HE1 LYS    36      80.936   2.183   9.368  1.00  0.00           H
ATOM    606  HE2 LYS    36      82.283   1.321   8.627  1.00  0.00           H
ATOM    607  HZ1 LYS    36      80.115   0.047  10.208  1.00  0.00           H
ATOM    608  HZ2 LYS    36      81.663   0.395  10.792  1.00  0.00           H
ATOM    609  HZ3 LYS    36      81.462  -0.745   9.550  1.00  0.00           H
ATOM    610  N   TYR    37      79.266  -1.964   2.853  1.00  0.00           N
ATOM    611  CA  TYR    37      78.242  -2.413   1.913  1.00  0.00           C
ATOM    612  C   TYR    37      78.298  -3.927   1.726  1.00  0.00           C
ATOM    613  O   TYR    37      77.264  -4.588   1.634  1.00  0.00           O
ATOM    614  CB  TYR    37      78.406  -1.716   0.556  1.00  0.00           C
ATOM    615  CG  TYR    37      77.396  -2.161  -0.482  1.00  0.00           C
ATOM    616  CD1 TYR    37      76.055  -1.823  -0.358  1.00  0.00           C
ATOM    617  CD2 TYR    37      77.780  -2.927  -1.581  1.00  0.00           C
ATOM    618  CE1 TYR    37      75.127  -2.229  -1.295  1.00  0.00           C
ATOM    619  CE2 TYR    37      76.856  -3.335  -2.522  1.00  0.00           C
ATOM    620  CZ  TYR    37      75.532  -2.986  -2.372  1.00  0.00           C
ATOM    621  OH  TYR    37      74.607  -3.393  -3.306  1.00  0.00           O
ATOM    622  HN  TYR    37      79.970  -1.356   2.540  1.00  0.00           H
ATOM    623  HA  TYR    37      77.280  -2.152   2.326  1.00  0.00           H
ATOM    624  HB1 TYR    37      79.393  -1.922   0.170  1.00  0.00           H
ATOM    625  HB2 TYR    37      78.294  -0.650   0.691  1.00  0.00           H
ATOM    626  HD1 TYR    37      75.739  -1.229   0.487  1.00  0.00           H
ATOM    627  HD2 TYR    37      78.817  -3.203  -1.696  1.00  0.00           H
ATOM    628  HE1 TYR    37      74.089  -1.955  -1.181  1.00  0.00           H
ATOM    629  HE2 TYR    37      77.171  -3.927  -3.367  1.00  0.00           H
ATOM    630  HH  TYR    37      73.956  -2.689  -3.441  1.00  0.00           H
ATOM    631  N   VAL    38      79.506  -4.475   1.689  1.00  0.00           N
ATOM    632  CA  VAL    38      79.686  -5.905   1.458  1.00  0.00           C
ATOM    633  C   VAL    38      79.653  -6.699   2.765  1.00  0.00           C
ATOM    634  O   VAL    38      79.971  -7.888   2.789  1.00  0.00           O
ATOM    635  CB  VAL    38      81.001  -6.196   0.702  1.00  0.00           C
ATOM    636  CG1 VAL    38      81.012  -5.474  -0.636  1.00  0.00           C
ATOM    637  CG2 VAL    38      82.215  -5.804   1.531  1.00  0.00           C
ATOM    638  HN  VAL    38      80.297  -3.903   1.812  1.00  0.00           H
ATOM    639  HA  VAL    38      78.866  -6.237   0.836  1.00  0.00           H
ATOM    640  HB  VAL    38      81.052  -7.258   0.510  1.00  0.00           H
ATOM    641 HG11 VAL    38      80.930  -4.409  -0.471  1.00  0.00           H
ATOM    642 HG12 VAL    38      80.177  -5.810  -1.232  1.00  0.00           H
ATOM    643 HG13 VAL    38      81.935  -5.689  -1.153  1.00  0.00           H
ATOM    644 HG21 VAL    38      82.172  -4.749   1.757  1.00  0.00           H
ATOM    645 HG22 VAL    38      83.115  -6.015   0.973  1.00  0.00           H
ATOM    646 HG23 VAL    38      82.220  -6.369   2.451  1.00  0.00           H
ATOM    647  N   GLY    39      79.262  -6.038   3.848  1.00  0.00           N
ATOM    648  CA  GLY    39      79.115  -6.724   5.120  1.00  0.00           C
ATOM    649  C   GLY    39      80.299  -6.518   6.042  1.00  0.00           C
ATOM    650  O   GLY    39      80.380  -7.155   7.092  1.00  0.00           O
ATOM    651  HN  GLY    39      79.063  -5.079   3.783  1.00  0.00           H
ATOM    652  HA1 GLY    39      78.998  -7.781   4.933  1.00  0.00           H
ATOM    653  HA2 GLY    39      78.226  -6.357   5.610  1.00  0.00           H
ATOM    654  N   GLU    40      81.202  -5.620   5.634  1.00  0.00           N
ATOM    655  CA  GLU    40      82.411  -5.254   6.392  1.00  0.00           C
ATOM    656  C   GLU    40      83.104  -6.457   7.049  1.00  0.00           C
ATOM    657  O   GLU    40      82.915  -6.742   8.234  1.00  0.00           O
ATOM    658  CB  GLU    40      82.119  -4.141   7.416  1.00  0.00           C
ATOM    659  CG  GLU    40      80.963  -4.427   8.361  1.00  0.00           C
ATOM    660  CD  GLU    40      80.687  -3.288   9.318  1.00  0.00           C
ATOM    661  OE1 GLU    40      79.668  -3.354  10.040  1.00  0.00           O
ATOM    662  OE2 GLU    40      81.475  -2.326   9.355  1.00  0.00           O
ATOM    663  HN  GLU    40      81.055  -5.176   4.772  1.00  0.00           H
ATOM    664  HA  GLU    40      83.104  -4.851   5.668  1.00  0.00           H
ATOM    665  HB1 GLU    40      81.894  -3.231   6.877  1.00  0.00           H
ATOM    666  HB2 GLU    40      83.004  -3.979   8.012  1.00  0.00           H
ATOM    667  HG1 GLU    40      81.198  -5.311   8.936  1.00  0.00           H
ATOM    668  HG2 GLU    40      80.074  -4.606   7.776  1.00  0.00           H
ATOM    669  N   PRO    41      83.907  -7.191   6.263  1.00  0.00           N
ATOM    670  CA  PRO    41      84.705  -8.305   6.762  1.00  0.00           C
ATOM    671  C   PRO    41      86.072  -7.844   7.267  1.00  0.00           C
ATOM    672  O   PRO    41      86.316  -6.643   7.414  1.00  0.00           O
ATOM    673  CB  PRO    41      84.855  -9.179   5.521  1.00  0.00           C
ATOM    674  CG  PRO    41      84.890  -8.212   4.382  1.00  0.00           C
ATOM    675  CD  PRO    41      84.092  -7.002   4.811  1.00  0.00           C
ATOM    676  HA  PRO    41      84.192  -8.852   7.539  1.00  0.00           H
ATOM    677  HB1 PRO    41      84.011  -9.848   5.444  1.00  0.00           H
ATOM    678  HB2 PRO    41      85.771  -9.748   5.587  1.00  0.00           H
ATOM    679  HG1 PRO    41      84.442  -8.662   3.508  1.00  0.00           H
ATOM    680  HG2 PRO    41      85.910  -7.928   4.175  1.00  0.00           H
ATOM    681  HD1 PRO    41      83.138  -6.981   4.303  1.00  0.00           H
ATOM    682  HD2 PRO    41      84.645  -6.097   4.610  1.00  0.00           H
ATOM    683  N   GLU    42      86.961  -8.795   7.525  1.00  0.00           N
ATOM    684  CA  GLU    42      88.301  -8.472   7.992  1.00  0.00           C
ATOM    685  C   GLU    42      89.161  -7.955   6.846  1.00  0.00           C
ATOM    686  O   GLU    42      89.141  -8.501   5.740  1.00  0.00           O
ATOM    687  CB  GLU    42      88.960  -9.693   8.633  1.00  0.00           C
ATOM    688  CG  GLU    42      88.249 -10.184   9.883  1.00  0.00           C
ATOM    689  CD  GLU    42      88.097  -9.101  10.931  1.00  0.00           C
ATOM    690  OE1 GLU    42      89.039  -8.304  11.117  1.00  0.00           O
ATOM    691  OE2 GLU    42      87.036  -9.051  11.588  1.00  0.00           O
ATOM    692  HN  GLU    42      86.714  -9.732   7.394  1.00  0.00           H
ATOM    693  HA  GLU    42      88.211  -7.693   8.735  1.00  0.00           H
ATOM    694  HB1 GLU    42      89.976  -9.439   8.899  1.00  0.00           H
ATOM    695  HB2 GLU    42      88.975 -10.499   7.914  1.00  0.00           H
ATOM    696  HG1 GLU    42      88.819 -10.999  10.307  1.00  0.00           H
ATOM    697  HG2 GLU    42      87.266 -10.539   9.608  1.00  0.00           H
ATOM    698  N   LEU    43      89.907  -6.899   7.121  1.00  0.00           N
ATOM    699  CA  LEU    43      90.763  -6.281   6.122  1.00  0.00           C
ATOM    700  C   LEU    43      92.193  -6.783   6.254  1.00  0.00           C
ATOM    701  O   LEU    43      92.667  -7.072   7.356  1.00  0.00           O
ATOM    702  CB  LEU    43      90.723  -4.759   6.265  1.00  0.00           C
ATOM    703  CG  LEU    43      89.357  -4.117   6.007  1.00  0.00           C
ATOM    704  CD1 LEU    43      89.415  -2.618   6.255  1.00  0.00           C
ATOM    705  CD2 LEU    43      88.897  -4.400   4.585  1.00  0.00           C
ATOM    706  HN  LEU    43      89.886  -6.522   8.031  1.00  0.00           H
ATOM    707  HA  LEU    43      90.385  -6.553   5.149  1.00  0.00           H
ATOM    708  HB1 LEU    43      91.431  -4.336   5.569  1.00  0.00           H
ATOM    709  HB2 LEU    43      91.033  -4.505   7.268  1.00  0.00           H
ATOM    710  HG  LEU    43      88.632  -4.542   6.685  1.00  0.00           H
ATOM    711 HD11 LEU    43      90.136  -2.169   5.588  1.00  0.00           H
ATOM    712 HD12 LEU    43      89.707  -2.433   7.278  1.00  0.00           H
ATOM    713 HD13 LEU    43      88.441  -2.185   6.076  1.00  0.00           H
ATOM    714 HD21 LEU    43      87.932  -3.945   4.422  1.00  0.00           H
ATOM    715 HD22 LEU    43      88.820  -5.468   4.438  1.00  0.00           H
ATOM    716 HD23 LEU    43      89.612  -3.991   3.888  1.00  0.00           H
ATOM    717  N   LYS    44      92.878  -6.886   5.127  1.00  0.00           N
ATOM    718  CA  LYS    44      94.247  -7.368   5.107  1.00  0.00           C
ATOM    719  C   LYS    44      95.186  -6.227   4.732  1.00  0.00           C
ATOM    720  O   LYS    44      95.083  -5.653   3.648  1.00  0.00           O
ATOM    721  CB  LYS    44      94.367  -8.531   4.116  1.00  0.00           C
ATOM    722  CG  LYS    44      95.676  -9.296   4.206  1.00  0.00           C
ATOM    723  CD  LYS    44      95.623 -10.570   3.377  1.00  0.00           C
ATOM    724  CE  LYS    44      96.905 -11.378   3.492  1.00  0.00           C
ATOM    725  NZ  LYS    44      98.065 -10.681   2.881  1.00  0.00           N
ATOM    726  HN  LYS    44      92.452  -6.619   4.281  1.00  0.00           H
ATOM    727  HA  LYS    44      94.494  -7.716   6.098  1.00  0.00           H
ATOM    728  HB1 LYS    44      94.272  -8.143   3.112  1.00  0.00           H
ATOM    729  HB2 LYS    44      93.561  -9.227   4.299  1.00  0.00           H
ATOM    730  HG1 LYS    44      95.865  -9.553   5.238  1.00  0.00           H
ATOM    731  HG2 LYS    44      96.476  -8.669   3.837  1.00  0.00           H
ATOM    732  HD1 LYS    44      95.467 -10.305   2.341  1.00  0.00           H
ATOM    733  HD2 LYS    44      94.797 -11.176   3.721  1.00  0.00           H
ATOM    734  HE1 LYS    44      96.761 -12.326   2.992  1.00  0.00           H
ATOM    735  HE2 LYS    44      97.112 -11.554   4.537  1.00  0.00           H
ATOM    736  HZ1 LYS    44      98.904 -11.298   2.896  1.00  0.00           H
ATOM    737  HZ2 LYS    44      98.283  -9.808   3.410  1.00  0.00           H
ATOM    738  HZ3 LYS    44      97.853 -10.425   1.895  1.00  0.00           H
ATOM    739  N   THR    45      96.089  -5.891   5.638  1.00  0.00           N
ATOM    740  CA  THR    45      96.990  -4.766   5.437  1.00  0.00           C
ATOM    741  C   THR    45      98.395  -5.241   5.096  1.00  0.00           C
ATOM    742  O   THR    45      98.870  -6.233   5.647  1.00  0.00           O
ATOM    743  CB  THR    45      97.051  -3.874   6.693  1.00  0.00           C
ATOM    744  CG2 THR    45      95.732  -3.153   6.912  1.00  0.00           C
ATOM    745  OG1 THR    45      97.360  -4.667   7.848  1.00  0.00           O
ATOM    746  HN  THR    45      96.154  -6.414   6.468  1.00  0.00           H
ATOM    747  HA  THR    45      96.610  -4.174   4.618  1.00  0.00           H
ATOM    748  HB  THR    45      97.829  -3.137   6.555  1.00  0.00           H
ATOM    749  HG1 THR    45      97.613  -5.555   7.572  1.00  0.00           H
ATOM    750 HG21 THR    45      94.940  -3.878   7.032  1.00  0.00           H
ATOM    751 HG22 THR    45      95.519  -2.526   6.057  1.00  0.00           H
ATOM    752 HG23 THR    45      95.798  -2.542   7.799  1.00  0.00           H
ATOM    753  N   TYR    46      99.059  -4.533   4.197  1.00  0.00           N
ATOM    754  CA  TYR    46     100.424  -4.869   3.829  1.00  0.00           C
ATOM    755  C   TYR    46     101.310  -3.630   3.898  1.00  0.00           C
ATOM    756  O   TYR    46     100.836  -2.504   3.721  1.00  0.00           O
ATOM    757  CB  TYR    46     100.479  -5.488   2.425  1.00  0.00           C
ATOM    758  CG  TYR    46     100.176  -4.520   1.297  1.00  0.00           C
ATOM    759  CD1 TYR    46      98.878  -4.100   1.043  1.00  0.00           C
ATOM    760  CD2 TYR    46     101.193  -4.038   0.481  1.00  0.00           C
ATOM    761  CE1 TYR    46      98.600  -3.224   0.010  1.00  0.00           C
ATOM    762  CE2 TYR    46     100.923  -3.161  -0.552  1.00  0.00           C
ATOM    763  CZ  TYR    46      99.626  -2.758  -0.784  1.00  0.00           C
ATOM    764  OH  TYR    46      99.350  -1.888  -1.814  1.00  0.00           O
ATOM    765  HN  TYR    46      98.625  -3.754   3.777  1.00  0.00           H
ATOM    766  HA  TYR    46     100.788  -5.592   4.544  1.00  0.00           H
ATOM    767  HB1 TYR    46      99.761  -6.294   2.372  1.00  0.00           H
ATOM    768  HB2 TYR    46     101.468  -5.887   2.258  1.00  0.00           H
ATOM    769  HD1 TYR    46      98.075  -4.465   1.668  1.00  0.00           H
ATOM    770  HD2 TYR    46     102.209  -4.356   0.665  1.00  0.00           H
ATOM    771  HE1 TYR    46      97.584  -2.910  -0.171  1.00  0.00           H
ATOM    772  HE2 TYR    46     101.728  -2.796  -1.173  1.00  0.00           H
ATOM    773  HH  TYR    46      99.726  -2.232  -2.634  1.00  0.00           H
ATOM    774  N   VAL    47     102.585  -3.845   4.170  1.00  0.00           N
ATOM    775  CA  VAL    47     103.551  -2.760   4.218  1.00  0.00           C
ATOM    776  C   VAL    47     104.454  -2.825   2.995  1.00  0.00           C
ATOM    777  O   VAL    47     104.992  -3.884   2.669  1.00  0.00           O
ATOM    778  CB  VAL    47     104.427  -2.826   5.492  1.00  0.00           C
ATOM    779  CG1 VAL    47     105.356  -1.624   5.571  1.00  0.00           C
ATOM    780  CG2 VAL    47     103.566  -2.913   6.743  1.00  0.00           C
ATOM    781  HN  VAL    47     102.892  -4.766   4.333  1.00  0.00           H
ATOM    782  HA  VAL    47     103.013  -1.825   4.216  1.00  0.00           H
ATOM    783  HB  VAL    47     105.035  -3.718   5.439  1.00  0.00           H
ATOM    784 HG11 VAL    47     104.771  -0.716   5.598  1.00  0.00           H
ATOM    785 HG12 VAL    47     106.002  -1.611   4.706  1.00  0.00           H
ATOM    786 HG13 VAL    47     105.956  -1.692   6.466  1.00  0.00           H
ATOM    787 HG21 VAL    47     102.913  -3.771   6.673  1.00  0.00           H
ATOM    788 HG22 VAL    47     102.975  -2.016   6.835  1.00  0.00           H
ATOM    789 HG23 VAL    47     104.202  -3.016   7.609  1.00  0.00           H
ATOM    790  N   ILE    48     104.602  -1.707   2.311  1.00  0.00           N
ATOM    791  CA  ILE    48     105.483  -1.641   1.160  1.00  0.00           C
ATOM    792  C   ILE    48     106.487  -0.504   1.319  1.00  0.00           C
ATOM    793  O   ILE    48     106.122   0.673   1.338  1.00  0.00           O
ATOM    794  CB  ILE    48     104.689  -1.492  -0.164  1.00  0.00           C
ATOM    795  CG1 ILE    48     105.642  -1.237  -1.340  1.00  0.00           C
ATOM    796  CG2 ILE    48     103.643  -0.387  -0.059  1.00  0.00           C
ATOM    797  CD1 ILE    48     104.946  -1.134  -2.680  1.00  0.00           C
ATOM    798  HN  ILE    48     104.108  -0.900   2.589  1.00  0.00           H
ATOM    799  HA  ILE    48     106.028  -2.573   1.119  1.00  0.00           H
ATOM    800  HB  ILE    48     104.165  -2.419  -0.339  1.00  0.00           H
ATOM    801 HG11 ILE    48     106.355  -2.047  -1.397  1.00  0.00           H
ATOM    802 HG12 ILE    48     106.172  -0.311  -1.172  1.00  0.00           H
ATOM    803 HG21 ILE    48     104.132   0.552   0.161  1.00  0.00           H
ATOM    804 HG22 ILE    48     102.948  -0.624   0.732  1.00  0.00           H
ATOM    805 HG23 ILE    48     103.111  -0.305  -0.994  1.00  0.00           H
ATOM    806 HD11 ILE    48     104.430  -2.061  -2.890  1.00  0.00           H
ATOM    807 HD12 ILE    48     105.676  -0.946  -3.453  1.00  0.00           H
ATOM    808 HD13 ILE    48     104.232  -0.325  -2.654  1.00  0.00           H
ATOM    809  N   GLU    49     107.750  -0.866   1.485  1.00  0.00           N
ATOM    810  CA  GLU    49     108.813   0.119   1.591  1.00  0.00           C
ATOM    811  C   GLU    49     109.224   0.593   0.205  1.00  0.00           C
ATOM    812  O   GLU    49     109.999  -0.069  -0.490  1.00  0.00           O
ATOM    813  CB  GLU    49     110.033  -0.444   2.324  1.00  0.00           C
ATOM    814  CG  GLU    49     109.705  -1.228   3.584  1.00  0.00           C
ATOM    815  CD  GLU    49     109.490  -2.703   3.310  1.00  0.00           C
ATOM    816  OE1 GLU    49     110.481  -3.465   3.335  1.00  0.00           O
ATOM    817  OE2 GLU    49     108.340  -3.113   3.072  1.00  0.00           O
ATOM    818  HN  GLU    49     107.971  -1.822   1.559  1.00  0.00           H
ATOM    819  HA  GLU    49     108.425   0.963   2.145  1.00  0.00           H
ATOM    820  HB1 GLU    49     110.679   0.377   2.598  1.00  0.00           H
ATOM    821  HB2 GLU    49     110.568  -1.099   1.651  1.00  0.00           H
ATOM    822  HG1 GLU    49     108.803  -0.824   4.022  1.00  0.00           H
ATOM    823  HG2 GLU    49     110.522  -1.122   4.282  1.00  0.00           H
ATOM   1177  N   LYS    72     108.198   3.606   3.944  1.00  0.00           N
ATOM   1178  CA  LYS    72     107.483   2.387   4.282  1.00  0.00           C
ATOM   1179  C   LYS    72     106.028   2.721   4.578  1.00  0.00           C
ATOM   1180  O   LYS    72     105.689   3.202   5.660  1.00  0.00           O
ATOM   1181  CB  LYS    72     108.150   1.679   5.471  1.00  0.00           C
ATOM   1182  CG  LYS    72     108.404   2.580   6.671  1.00  0.00           C
ATOM   1183  CD  LYS    72     109.133   1.836   7.776  1.00  0.00           C
ATOM   1184  CE  LYS    72     109.358   2.717   8.994  1.00  0.00           C
ATOM   1185  NZ  LYS    72     108.081   3.173   9.602  1.00  0.00           N
ATOM   1186  HN  LYS    72     108.643   4.115   4.658  1.00  0.00           H
ATOM   1187  HA  LYS    72     107.518   1.737   3.419  1.00  0.00           H
ATOM   1188  HB1 LYS    72     109.095   1.274   5.144  1.00  0.00           H
ATOM   1189  HB2 LYS    72     107.513   0.865   5.788  1.00  0.00           H
ATOM   1190  HG1 LYS    72     107.456   2.936   7.051  1.00  0.00           H
ATOM   1191  HG2 LYS    72     109.007   3.418   6.358  1.00  0.00           H
ATOM   1192  HD1 LYS    72     110.090   1.503   7.402  1.00  0.00           H
ATOM   1193  HD2 LYS    72     108.543   0.979   8.071  1.00  0.00           H
ATOM   1194  HE1 LYS    72     109.933   3.582   8.693  1.00  0.00           H
ATOM   1195  HE2 LYS    72     109.916   2.157   9.731  1.00  0.00           H
ATOM   1196  HZ1 LYS    72     107.613   3.873   8.985  1.00  0.00           H
ATOM   1197  HZ2 LYS    72     108.258   3.612  10.528  1.00  0.00           H
ATOM   1198  HZ3 LYS    72     107.436   2.363   9.734  1.00  0.00           H
ATOM   1199  N   ILE    73     105.169   2.512   3.595  1.00  0.00           N
ATOM   1200  CA  ILE    73     103.770   2.879   3.729  1.00  0.00           C
ATOM   1201  C   ILE    73     102.898   1.642   3.928  1.00  0.00           C
ATOM   1202  O   ILE    73     103.098   0.607   3.286  1.00  0.00           O
ATOM   1203  CB  ILE    73     103.279   3.705   2.513  1.00  0.00           C
ATOM   1204  CG1 ILE    73     101.801   4.078   2.668  1.00  0.00           C
ATOM   1205  CG2 ILE    73     103.511   2.946   1.214  1.00  0.00           C
ATOM   1206  CD1 ILE    73     101.283   4.994   1.581  1.00  0.00           C
ATOM   1207  HN  ILE    73     105.480   2.094   2.759  1.00  0.00           H
ATOM   1208  HA  ILE    73     103.684   3.501   4.608  1.00  0.00           H
ATOM   1209  HB  ILE    73     103.864   4.612   2.472  1.00  0.00           H
ATOM   1210 HG11 ILE    73     101.661   4.574   3.617  1.00  0.00           H
ATOM   1211 HG12 ILE    73     101.206   3.176   2.650  1.00  0.00           H
ATOM   1212 HG21 ILE    73     103.165   3.542   0.382  1.00  0.00           H
ATOM   1213 HG22 ILE    73     102.965   2.014   1.241  1.00  0.00           H
ATOM   1214 HG23 ILE    73     104.565   2.742   1.096  1.00  0.00           H
ATOM   1215 HD11 ILE    73     101.844   5.917   1.590  1.00  0.00           H
ATOM   1216 HD12 ILE    73     100.237   5.206   1.756  1.00  0.00           H
ATOM   1217 HD13 ILE    73     101.395   4.513   0.622  1.00  0.00           H
ATOM   1218  N   LYS    74     101.955   1.752   4.850  1.00  0.00           N
ATOM   1219  CA  LYS    74     101.029   0.674   5.144  1.00  0.00           C
ATOM   1220  C   LYS    74      99.743   0.892   4.353  1.00  0.00           C
ATOM   1221  O   LYS    74      99.151   1.972   4.414  1.00  0.00           O
ATOM   1222  CB  LYS    74     100.729   0.655   6.648  1.00  0.00           C
ATOM   1223  CG  LYS    74     100.451  -0.725   7.232  1.00  0.00           C
ATOM   1224  CD  LYS    74     100.260  -0.637   8.742  1.00  0.00           C
ATOM   1225  CE  LYS    74     100.507  -1.967   9.443  1.00  0.00           C
ATOM   1226  NZ  LYS    74      99.486  -2.996   9.113  1.00  0.00           N
ATOM   1227  HN  LYS    74     101.876   2.595   5.349  1.00  0.00           H
ATOM   1228  HA  LYS    74     101.481  -0.262   4.850  1.00  0.00           H
ATOM   1229  HB1 LYS    74      99.865   1.277   6.834  1.00  0.00           H
ATOM   1230  HB2 LYS    74     101.574   1.073   7.174  1.00  0.00           H
ATOM   1231  HG1 LYS    74     101.285  -1.374   7.019  1.00  0.00           H
ATOM   1232  HG2 LYS    74      99.551  -1.123   6.786  1.00  0.00           H
ATOM   1233  HD1 LYS    74      99.246  -0.321   8.945  1.00  0.00           H
ATOM   1234  HD2 LYS    74     100.948   0.094   9.137  1.00  0.00           H
ATOM   1235  HE1 LYS    74     100.502  -1.800  10.511  1.00  0.00           H
ATOM   1236  HE2 LYS    74     101.478  -2.336   9.147  1.00  0.00           H
ATOM   1237  HZ1 LYS    74      99.636  -3.847   9.700  1.00  0.00           H
ATOM   1238  HZ2 LYS    74      99.560  -3.272   8.112  1.00  0.00           H
ATOM   1239  HZ3 LYS    74      98.527  -2.629   9.296  1.00  0.00           H
ATOM   1240  N   LYS    75      99.331  -0.105   3.587  1.00  0.00           N
ATOM   1241  CA  LYS    75      98.098  -0.006   2.816  1.00  0.00           C
ATOM   1242  C   LYS    75      97.176  -1.169   3.145  1.00  0.00           C
ATOM   1243  O   LYS    75      97.622  -2.204   3.640  1.00  0.00           O
ATOM   1244  CB  LYS    75      98.387   0.049   1.311  1.00  0.00           C
ATOM   1245  CG  LYS    75      99.133   1.305   0.885  1.00  0.00           C
ATOM   1246  CD  LYS    75      99.220   1.427  -0.630  1.00  0.00           C
ATOM   1247  CE  LYS    75      99.949   2.698  -1.034  1.00  0.00           C
ATOM   1248  NZ  LYS    75      99.950   2.909  -2.507  1.00  0.00           N
ATOM   1249  HN  LYS    75      99.859  -0.934   3.545  1.00  0.00           H
ATOM   1250  HA  LYS    75      97.607   0.910   3.109  1.00  0.00           H
ATOM   1251  HB1 LYS    75      97.450   0.013   0.775  1.00  0.00           H
ATOM   1252  HB2 LYS    75      98.982  -0.809   1.039  1.00  0.00           H
ATOM   1253  HG1 LYS    75     100.132   1.271   1.293  1.00  0.00           H
ATOM   1254  HG2 LYS    75      98.612   2.167   1.274  1.00  0.00           H
ATOM   1255  HD1 LYS    75      98.220   1.448  -1.039  1.00  0.00           H
ATOM   1256  HD2 LYS    75      99.754   0.575  -1.021  1.00  0.00           H
ATOM   1257  HE1 LYS    75     100.970   2.633  -0.689  1.00  0.00           H
ATOM   1258  HE2 LYS    75      99.466   3.540  -0.563  1.00  0.00           H
ATOM   1259  HZ1 LYS    75     100.428   2.114  -2.986  1.00  0.00           H
ATOM   1260  HZ2 LYS    75     100.449   3.789  -2.739  1.00  0.00           H
ATOM   1261  HZ3 LYS    75      98.972   2.978  -2.863  1.00  0.00           H
ATOM   1262  N   VAL    76      95.892  -0.993   2.877  1.00  0.00           N
ATOM   1263  CA  VAL    76      94.894  -1.985   3.238  1.00  0.00           C
ATOM   1264  C   VAL    76      94.135  -2.456   2.004  1.00  0.00           C
ATOM   1265  O   VAL    76      93.942  -1.692   1.059  1.00  0.00           O
ATOM   1266  CB  VAL    76      93.900  -1.416   4.283  1.00  0.00           C
ATOM   1267  CG1 VAL    76      93.142  -0.217   3.731  1.00  0.00           C
ATOM   1268  CG2 VAL    76      92.929  -2.485   4.754  1.00  0.00           C
ATOM   1269  HN  VAL    76      95.604  -0.178   2.405  1.00  0.00           H
ATOM   1270  HA  VAL    76      95.407  -2.828   3.679  1.00  0.00           H
ATOM   1271  HB  VAL    76      94.470  -1.083   5.138  1.00  0.00           H
ATOM   1272 HG11 VAL    76      93.842   0.562   3.468  1.00  0.00           H
ATOM   1273 HG12 VAL    76      92.458   0.152   4.481  1.00  0.00           H
ATOM   1274 HG13 VAL    76      92.588  -0.515   2.853  1.00  0.00           H
ATOM   1275 HG21 VAL    76      92.248  -2.060   5.476  1.00  0.00           H
ATOM   1276 HG22 VAL    76      93.479  -3.295   5.209  1.00  0.00           H
ATOM   1277 HG23 VAL    76      92.370  -2.859   3.909  1.00  0.00           H
ATOM   1278  N   TYR    77      93.735  -3.720   2.000  1.00  0.00           N
ATOM   1279  CA  TYR    77      92.918  -4.252   0.926  1.00  0.00           C
ATOM   1280  C   TYR    77      92.067  -5.408   1.430  1.00  0.00           C
ATOM   1281  O   TYR    77      92.310  -5.946   2.512  1.00  0.00           O
ATOM   1282  CB  TYR    77      93.794  -4.714  -0.250  1.00  0.00           C
ATOM   1283  CG  TYR    77      94.675  -5.913   0.042  1.00  0.00           C
ATOM   1284  CD1 TYR    77      94.202  -7.206  -0.145  1.00  0.00           C
ATOM   1285  CD2 TYR    77      95.978  -5.752   0.489  1.00  0.00           C
ATOM   1286  CE1 TYR    77      95.003  -8.300   0.106  1.00  0.00           C
ATOM   1287  CE2 TYR    77      96.786  -6.844   0.744  1.00  0.00           C
ATOM   1288  CZ  TYR    77      96.291  -8.115   0.552  1.00  0.00           C
ATOM   1289  OH  TYR    77      97.092  -9.206   0.798  1.00  0.00           O
ATOM   1290  HN  TYR    77      94.002  -4.315   2.738  1.00  0.00           H
ATOM   1291  HA  TYR    77      92.263  -3.463   0.586  1.00  0.00           H
ATOM   1292  HB1 TYR    77      94.438  -3.897  -0.545  1.00  0.00           H
ATOM   1293  HB2 TYR    77      93.155  -4.974  -1.080  1.00  0.00           H
ATOM   1294  HD1 TYR    77      93.189  -7.349  -0.492  1.00  0.00           H
ATOM   1295  HD2 TYR    77      96.361  -4.754   0.641  1.00  0.00           H
ATOM   1296  HE1 TYR    77      94.616  -9.298  -0.046  1.00  0.00           H
ATOM   1297  HE2 TYR    77      97.797  -6.699   1.094  1.00  0.00           H
ATOM   1298  HH  TYR    77      96.971  -9.859   0.089  1.00  0.00           H
ATOM   1299  N   PHE    78      91.060  -5.775   0.657  1.00  0.00           N
ATOM   1300  CA  PHE    78      90.312  -6.992   0.920  1.00  0.00           C
ATOM   1301  C   PHE    78      90.162  -7.775  -0.373  1.00  0.00           C
ATOM   1302  O   PHE    78      90.098  -7.190  -1.457  1.00  0.00           O
ATOM   1303  CB  PHE    78      88.943  -6.702   1.557  1.00  0.00           C
ATOM   1304  CG  PHE    78      87.943  -6.026   0.657  1.00  0.00           C
ATOM   1305  CD1 PHE    78      87.044  -6.775  -0.087  1.00  0.00           C
ATOM   1306  CD2 PHE    78      87.889  -4.646   0.570  1.00  0.00           C
ATOM   1307  CE1 PHE    78      86.111  -6.159  -0.900  1.00  0.00           C
ATOM   1308  CE2 PHE    78      86.960  -4.024  -0.243  1.00  0.00           C
ATOM   1309  CZ  PHE    78      86.070  -4.783  -0.979  1.00  0.00           C
ATOM   1310  HN  PHE    78      90.817  -5.215  -0.115  1.00  0.00           H
ATOM   1311  HA  PHE    78      90.896  -7.586   1.609  1.00  0.00           H
ATOM   1312  HB1 PHE    78      89.091  -6.069   2.420  1.00  0.00           H
ATOM   1313  HB2 PHE    78      88.507  -7.635   1.880  1.00  0.00           H
ATOM   1314  HD1 PHE    78      87.077  -7.853  -0.027  1.00  0.00           H
ATOM   1315  HD2 PHE    78      88.584  -4.050   1.144  1.00  0.00           H
ATOM   1316  HE1 PHE    78      85.418  -6.755  -1.474  1.00  0.00           H
ATOM   1317  HE2 PHE    78      86.930  -2.946  -0.303  1.00  0.00           H
ATOM   1318  HZ  PHE    78      85.342  -4.298  -1.614  1.00  0.00           H
ATOM   1319  N   GLU    79      90.129  -9.090  -0.261  1.00  0.00           N
ATOM   1320  CA  GLU    79      90.069  -9.947  -1.429  1.00  0.00           C
ATOM   1321  C   GLU    79      88.672 -10.511  -1.616  1.00  0.00           C
ATOM   1322  O   GLU    79      88.055 -11.003  -0.669  1.00  0.00           O
ATOM   1323  CB  GLU    79      91.090 -11.074  -1.312  1.00  0.00           C
ATOM   1324  CG  GLU    79      92.519 -10.571  -1.236  1.00  0.00           C
ATOM   1325  CD  GLU    79      93.532 -11.688  -1.232  1.00  0.00           C
ATOM   1326  OE1 GLU    79      93.669 -12.372  -2.265  1.00  0.00           O
ATOM   1327  OE2 GLU    79      94.205 -11.880  -0.199  1.00  0.00           O
ATOM   1328  HN  GLU    79      90.137  -9.497   0.630  1.00  0.00           H
ATOM   1329  HA  GLU    79      90.315  -9.343  -2.291  1.00  0.00           H
ATOM   1330  HB1 GLU    79      91.002 -11.720  -2.174  1.00  0.00           H
ATOM   1331  HB2 GLU    79      90.880 -11.645  -0.419  1.00  0.00           H
ATOM   1332  HG1 GLU    79      92.635  -9.996  -0.328  1.00  0.00           H
ATOM   1333  HG2 GLU    79      92.709  -9.937  -2.086  1.00  0.00           H
ATOM   1334  N   THR    80      88.179 -10.419  -2.837  1.00  0.00           N
ATOM   1335  CA  THR    80      86.853 -10.902  -3.172  1.00  0.00           C
ATOM   1336  C   THR    80      86.876 -12.392  -3.500  1.00  0.00           C
ATOM   1337  O   THR    80      87.915 -13.045  -3.404  1.00  0.00           O
ATOM   1338  CB  THR    80      86.301 -10.133  -4.382  1.00  0.00           C
ATOM   1339  CG2 THR    80      86.082  -8.667  -4.039  1.00  0.00           C
ATOM   1340  OG1 THR    80      87.221 -10.242  -5.474  1.00  0.00           O
ATOM   1341  HN  THR    80      88.725 -10.007  -3.543  1.00  0.00           H
ATOM   1342  HA  THR    80      86.203 -10.729  -2.328  1.00  0.00           H
ATOM   1343  HB  THR    80      85.355 -10.569  -4.668  1.00  0.00           H
ATOM   1344  HG1 THR    80      86.923  -9.675  -6.205  1.00  0.00           H
ATOM   1345 HG21 THR    80      85.365  -8.588  -3.234  1.00  0.00           H
ATOM   1346 HG22 THR    80      85.706  -8.146  -4.907  1.00  0.00           H
ATOM   1347 HG23 THR    80      87.018  -8.225  -3.731  1.00  0.00           H
ATOM   1348  N   LEU    81      85.726 -12.916  -3.908  1.00  0.00           N
ATOM   1349  CA  LEU    81      85.607 -14.318  -4.300  1.00  0.00           C
ATOM   1350  C   LEU    81      86.403 -14.583  -5.574  1.00  0.00           C
ATOM   1351  O   LEU    81      86.773 -15.719  -5.868  1.00  0.00           O
ATOM   1352  CB  LEU    81      84.136 -14.697  -4.525  1.00  0.00           C
ATOM   1353  CG  LEU    81      83.269 -14.836  -3.265  1.00  0.00           C
ATOM   1354  CD1 LEU    81      83.090 -13.499  -2.561  1.00  0.00           C
ATOM   1355  CD2 LEU    81      81.917 -15.426  -3.629  1.00  0.00           C
ATOM   1356  HN  LEU    81      84.931 -12.346  -3.945  1.00  0.00           H
ATOM   1357  HA  LEU    81      86.011 -14.923  -3.503  1.00  0.00           H
ATOM   1358  HB1 LEU    81      84.111 -15.639  -5.052  1.00  0.00           H
ATOM   1359  HB2 LEU    81      83.689 -13.944  -5.156  1.00  0.00           H
ATOM   1360  HG  LEU    81      83.754 -15.514  -2.577  1.00  0.00           H
ATOM   1361 HD11 LEU    81      82.614 -12.800  -3.232  1.00  0.00           H
ATOM   1362 HD12 LEU    81      84.056 -13.116  -2.268  1.00  0.00           H
ATOM   1363 HD13 LEU    81      82.474 -13.632  -1.683  1.00  0.00           H
ATOM   1364 HD21 LEU    81      81.312 -15.516  -2.739  1.00  0.00           H
ATOM   1365 HD22 LEU    81      82.058 -16.403  -4.069  1.00  0.00           H
ATOM   1366 HD23 LEU    81      81.422 -14.781  -4.338  1.00  0.00           H
ATOM   1367  N   ASP    82      86.678 -13.521  -6.318  1.00  0.00           N
ATOM   1368  CA  ASP    82      87.400 -13.628  -7.580  1.00  0.00           C
ATOM   1369  C   ASP    82      88.894 -13.450  -7.350  1.00  0.00           C
ATOM   1370  O   ASP    82      89.673 -13.378  -8.301  1.00  0.00           O
ATOM   1371  CB  ASP    82      86.904 -12.569  -8.568  1.00  0.00           C
ATOM   1372  CG  ASP    82      85.394 -12.528  -8.679  1.00  0.00           C
ATOM   1373  OD1 ASP    82      84.817 -13.366  -9.401  1.00  0.00           O
ATOM   1374  OD2 ASP    82      84.779 -11.646  -8.044  1.00  0.00           O
ATOM   1375  HN  ASP    82      86.388 -12.637  -6.010  1.00  0.00           H
ATOM   1376  HA  ASP    82      87.220 -14.610  -7.989  1.00  0.00           H
ATOM   1377  HB1 ASP    82      87.313 -12.782  -9.546  1.00  0.00           H
ATOM   1378  HB2 ASP    82      87.247 -11.597  -8.245  1.00  0.00           H
ATOM   1379  N   ASN    83      89.279 -13.373  -6.074  1.00  0.00           N
ATOM   1380  CA  ASN    83      90.672 -13.152  -5.674  1.00  0.00           C
ATOM   1381  C   ASN    83      91.156 -11.780  -6.122  1.00  0.00           C
ATOM   1382  O   ASN    83      92.358 -11.544  -6.265  1.00  0.00           O
ATOM   1383  CB  ASN    83      91.595 -14.247  -6.223  1.00  0.00           C
ATOM   1384  CG  ASN    83      91.480 -15.546  -5.450  1.00  0.00           C
ATOM   1385  ND2 ASN    83      90.590 -16.418  -5.886  1.00  0.00           N
ATOM   1386  OD1 ASN    83      92.196 -15.765  -4.473  1.00  0.00           O
ATOM   1387  HN  ASN    83      88.600 -13.472  -5.371  1.00  0.00           H
ATOM   1388  HA  ASN    83      90.705 -13.184  -4.594  1.00  0.00           H
ATOM   1389  HB1 ASN    83      92.619 -13.905  -6.170  1.00  0.00           H
ATOM   1390  HB2 ASN    83      91.337 -14.441  -7.253  1.00  0.00           H
ATOM   1391 HD21 ASN    83      90.058 -16.183  -6.680  1.00  0.00           H
ATOM   1392 HD22 ASN    83      90.494 -17.268  -5.402  1.00  0.00           H
ATOM   1393  N   VAL    84      90.214 -10.875  -6.330  1.00  0.00           N
ATOM   1394  CA  VAL    84      90.541  -9.508  -6.692  1.00  0.00           C
ATOM   1395  C   VAL    84      90.744  -8.689  -5.426  1.00  0.00           C
ATOM   1396  O   VAL    84      89.891  -8.680  -4.539  1.00  0.00           O
ATOM   1397  CB  VAL    84      89.438  -8.869  -7.564  1.00  0.00           C
ATOM   1398  CG1 VAL    84      89.790  -7.430  -7.915  1.00  0.00           C
ATOM   1399  CG2 VAL    84      89.219  -9.692  -8.825  1.00  0.00           C
ATOM   1400  HN  VAL    84      89.274 -11.130  -6.226  1.00  0.00           H
ATOM   1401  HA  VAL    84      91.463  -9.522  -7.256  1.00  0.00           H
ATOM   1402  HB  VAL    84      88.518  -8.864  -7.000  1.00  0.00           H
ATOM   1403 HG11 VAL    84      89.004  -7.006  -8.522  1.00  0.00           H
ATOM   1404 HG12 VAL    84      90.720  -7.410  -8.464  1.00  0.00           H
ATOM   1405 HG13 VAL    84      89.894  -6.854  -7.007  1.00  0.00           H
ATOM   1406 HG21 VAL    84      90.137  -9.735  -9.394  1.00  0.00           H
ATOM   1407 HG22 VAL    84      88.445  -9.235  -9.425  1.00  0.00           H
ATOM   1408 HG23 VAL    84      88.917 -10.693  -8.553  1.00  0.00           H
ATOM   1409  N   ARG    85      91.884  -8.027  -5.337  1.00  0.00           N
ATOM   1410  CA  ARG    85      92.241  -7.291  -4.140  1.00  0.00           C
ATOM   1411  C   ARG    85      91.886  -5.820  -4.295  1.00  0.00           C
ATOM   1412  O   ARG    85      92.486  -5.108  -5.100  1.00  0.00           O
ATOM   1413  CB  ARG    85      93.737  -7.439  -3.848  1.00  0.00           C
ATOM   1414  CG  ARG    85      94.254  -8.857  -4.035  1.00  0.00           C
ATOM   1415  CD  ARG    85      95.589  -9.073  -3.340  1.00  0.00           C
ATOM   1416  NE  ARG    85      96.619  -8.139  -3.790  1.00  0.00           N
ATOM   1417  CZ  ARG    85      97.868  -8.140  -3.327  1.00  0.00           C
ATOM   1418  NH1 ARG    85      98.238  -9.034  -2.416  1.00  0.00           N
ATOM   1419  NH2 ARG    85      98.743  -7.253  -3.780  1.00  0.00           N
ATOM   1420  HN  ARG    85      92.501  -8.024  -6.105  1.00  0.00           H
ATOM   1421  HA  ARG    85      91.678  -7.702  -3.315  1.00  0.00           H
ATOM   1422  HB1 ARG    85      93.923  -7.143  -2.826  1.00  0.00           H
ATOM   1423  HB2 ARG    85      94.288  -6.787  -4.509  1.00  0.00           H
ATOM   1424  HG1 ARG    85      94.375  -9.045  -5.093  1.00  0.00           H
ATOM   1425  HG2 ARG    85      93.532  -9.548  -3.631  1.00  0.00           H
ATOM   1426  HD1 ARG    85      95.921 -10.082  -3.540  1.00  0.00           H
ATOM   1427  HD2 ARG    85      95.447  -8.950  -2.277  1.00  0.00           H
ATOM   1428  HE  ARG    85      96.364  -7.472  -4.469  1.00  0.00           H
ATOM   1429 HH11 ARG    85      97.578  -9.711  -2.073  1.00  0.00           H
ATOM   1430 HH12 ARG    85      99.184  -9.036  -2.059  1.00  0.00           H
ATOM   1431 HH21 ARG    85      98.457  -6.570  -4.473  1.00  0.00           H
ATOM   1432 HH22 ARG    85      99.692  -7.251  -3.443  1.00  0.00           H
ATOM   1433  N   VAL    86      90.895  -5.376  -3.541  1.00  0.00           N
ATOM   1434  CA  VAL    86      90.522  -3.971  -3.530  1.00  0.00           C
ATOM   1435  C   VAL    86      91.427  -3.214  -2.569  1.00  0.00           C
ATOM   1436  O   VAL    86      91.266  -3.306  -1.354  1.00  0.00           O
ATOM   1437  CB  VAL    86      89.047  -3.774  -3.124  1.00  0.00           C
ATOM   1438  CG1 VAL    86      88.678  -2.298  -3.126  1.00  0.00           C
ATOM   1439  CG2 VAL    86      88.128  -4.552  -4.053  1.00  0.00           C
ATOM   1440  HN  VAL    86      90.405  -6.009  -2.968  1.00  0.00           H
ATOM   1441  HA  VAL    86      90.660  -3.579  -4.529  1.00  0.00           H
ATOM   1442  HB  VAL    86      88.915  -4.153  -2.121  1.00  0.00           H
ATOM   1443 HG11 VAL    86      88.835  -1.890  -4.114  1.00  0.00           H
ATOM   1444 HG12 VAL    86      89.299  -1.771  -2.415  1.00  0.00           H
ATOM   1445 HG13 VAL    86      87.640  -2.186  -2.850  1.00  0.00           H
ATOM   1446 HG21 VAL    86      88.369  -5.603  -4.000  1.00  0.00           H
ATOM   1447 HG22 VAL    86      88.262  -4.202  -5.066  1.00  0.00           H
ATOM   1448 HG23 VAL    86      87.102  -4.402  -3.753  1.00  0.00           H
ATOM   1449  N   VAL    87      92.387  -2.486  -3.126  1.00  0.00           N
ATOM   1450  CA  VAL    87      93.422  -1.835  -2.334  1.00  0.00           C
ATOM   1451  C   VAL    87      93.098  -0.361  -2.117  1.00  0.00           C
ATOM   1452  O   VAL    87      92.534   0.299  -2.994  1.00  0.00           O
ATOM   1453  CB  VAL    87      94.805  -1.956  -3.013  1.00  0.00           C
ATOM   1454  CG1 VAL    87      95.912  -1.457  -2.095  1.00  0.00           C
ATOM   1455  CG2 VAL    87      95.072  -3.391  -3.440  1.00  0.00           C
ATOM   1456  HN  VAL    87      92.386  -2.366  -4.099  1.00  0.00           H
ATOM   1457  HA  VAL    87      93.471  -2.329  -1.374  1.00  0.00           H
ATOM   1458  HB  VAL    87      94.802  -1.337  -3.899  1.00  0.00           H
ATOM   1459 HG11 VAL    87      96.865  -1.565  -2.590  1.00  0.00           H
ATOM   1460 HG12 VAL    87      95.911  -2.036  -1.184  1.00  0.00           H
ATOM   1461 HG13 VAL    87      95.742  -0.417  -1.861  1.00  0.00           H
ATOM   1462 HG21 VAL    87      94.315  -3.705  -4.144  1.00  0.00           H
ATOM   1463 HG22 VAL    87      95.046  -4.034  -2.573  1.00  0.00           H
ATOM   1464 HG23 VAL    87      96.045  -3.454  -3.905  1.00  0.00           H
ATOM   1465  N   THR    88      93.441   0.143  -0.941  1.00  0.00           N
ATOM   1466  CA  THR    88      93.196   1.529  -0.591  1.00  0.00           C
ATOM   1467  C   THR    88      94.239   2.027   0.417  1.00  0.00           C
ATOM   1468  O   THR    88      94.774   1.245   1.211  1.00  0.00           O
ATOM   1469  CB  THR    88      91.769   1.686  -0.023  1.00  0.00           C
ATOM   1470  CG2 THR    88      91.513   3.090   0.496  1.00  0.00           C
ATOM   1471  OG1 THR    88      90.815   1.373  -1.044  1.00  0.00           O
ATOM   1472  HN  THR    88      93.865  -0.446  -0.275  1.00  0.00           H
ATOM   1473  HA  THR    88      93.270   2.119  -1.492  1.00  0.00           H
ATOM   1474  HB  THR    88      91.647   0.987   0.792  1.00  0.00           H
ATOM   1475  HG1 THR    88      91.262   0.915  -1.764  1.00  0.00           H
ATOM   1476 HG21 THR    88      90.532   3.133   0.944  1.00  0.00           H
ATOM   1477 HG22 THR    88      91.568   3.794  -0.322  1.00  0.00           H
ATOM   1478 HG23 THR    88      92.258   3.342   1.238  1.00  0.00           H
ATOM   1479  N   ASP    89      94.552   3.320   0.347  1.00  0.00           N
ATOM   1480  CA  ASP    89      95.499   3.952   1.265  1.00  0.00           C
ATOM   1481  C   ASP    89      95.056   3.779   2.714  1.00  0.00           C
ATOM   1482  O   ASP    89      94.050   4.347   3.136  1.00  0.00           O
ATOM   1483  CB  ASP    89      95.633   5.450   0.965  1.00  0.00           C
ATOM   1484  CG  ASP    89      96.084   5.740  -0.451  1.00  0.00           C
ATOM   1485  OD1 ASP    89      97.309   5.817  -0.689  1.00  0.00           O
ATOM   1486  OD2 ASP    89      95.215   5.907  -1.334  1.00  0.00           O
ATOM   1487  HN  ASP    89      94.138   3.867  -0.357  1.00  0.00           H
ATOM   1488  HA  ASP    89      96.460   3.479   1.132  1.00  0.00           H
ATOM   1489  HB1 ASP    89      96.353   5.879   1.647  1.00  0.00           H
ATOM   1490  HB2 ASP    89      94.676   5.926   1.118  1.00  0.00           H
ATOM   1491  N   TYR    90      95.818   3.003   3.474  1.00  0.00           N
ATOM   1492  CA  TYR    90      95.504   2.743   4.876  1.00  0.00           C
ATOM   1493  C   TYR    90      95.768   3.987   5.715  1.00  0.00           C
ATOM   1494  O   TYR    90      95.101   4.228   6.724  1.00  0.00           O
ATOM   1495  CB  TYR    90      96.338   1.562   5.376  1.00  0.00           C
ATOM   1496  CG  TYR    90      96.053   1.126   6.794  1.00  0.00           C
ATOM   1497  CD1 TYR    90      94.847   0.526   7.132  1.00  0.00           C
ATOM   1498  CD2 TYR    90      97.006   1.288   7.791  1.00  0.00           C
ATOM   1499  CE1 TYR    90      94.599   0.100   8.421  1.00  0.00           C
ATOM   1500  CE2 TYR    90      96.764   0.869   9.083  1.00  0.00           C
ATOM   1501  CZ  TYR    90      95.561   0.274   9.392  1.00  0.00           C
ATOM   1502  OH  TYR    90      95.323  -0.157  10.677  1.00  0.00           O
ATOM   1503  HN  TYR    90      96.617   2.594   3.083  1.00  0.00           H
ATOM   1504  HA  TYR    90      94.456   2.492   4.947  1.00  0.00           H
ATOM   1505  HB1 TYR    90      97.384   1.829   5.317  1.00  0.00           H
ATOM   1506  HB2 TYR    90      96.159   0.713   4.734  1.00  0.00           H
ATOM   1507  HD1 TYR    90      94.094   0.392   6.368  1.00  0.00           H
ATOM   1508  HD2 TYR    90      97.949   1.756   7.545  1.00  0.00           H
ATOM   1509  HE1 TYR    90      93.656  -0.365   8.665  1.00  0.00           H
ATOM   1510  HE2 TYR    90      97.517   1.007   9.845  1.00  0.00           H
ATOM   1511  HH  TYR    90      95.584   0.535  11.298  1.00  0.00           H
ATOM   1512  N   SER    91      96.734   4.780   5.275  1.00  0.00           N
ATOM   1513  CA  SER    91      97.047   6.050   5.909  1.00  0.00           C
ATOM   1514  C   SER    91      95.842   6.988   5.856  1.00  0.00           C
ATOM   1515  O   SER    91      95.460   7.595   6.859  1.00  0.00           O
ATOM   1516  CB  SER    91      98.246   6.677   5.197  1.00  0.00           C
ATOM   1517  OG  SER    91      98.144   6.486   3.792  1.00  0.00           O
ATOM   1518  HN  SER    91      97.258   4.504   4.493  1.00  0.00           H
ATOM   1519  HA  SER    91      97.304   5.860   6.940  1.00  0.00           H
ATOM   1520  HB1 SER    91      99.155   6.213   5.549  1.00  0.00           H
ATOM   1521  HB2 SER    91      98.274   7.735   5.405  1.00  0.00           H
ATOM   1522  HG  SER    91      98.260   7.334   3.341  1.00  0.00           H
ATOM   1523  N   GLU    92      95.244   7.085   4.678  1.00  0.00           N
ATOM   1524  CA  GLU    92      94.066   7.914   4.474  1.00  0.00           C
ATOM   1525  C   GLU    92      92.850   7.274   5.142  1.00  0.00           C
ATOM   1526  O   GLU    92      91.991   7.964   5.685  1.00  0.00           O
ATOM   1527  CB  GLU    92      93.808   8.085   2.977  1.00  0.00           C
ATOM   1528  CG  GLU    92      92.825   9.193   2.636  1.00  0.00           C
ATOM   1529  CD  GLU    92      93.443  10.572   2.699  1.00  0.00           C
ATOM   1530  OE1 GLU    92      92.799  11.493   3.238  1.00  0.00           O
ATOM   1531  OE2 GLU    92      94.565  10.750   2.180  1.00  0.00           O
ATOM   1532  HN  GLU    92      95.614   6.592   3.916  1.00  0.00           H
ATOM   1533  HA  GLU    92      94.249   8.881   4.920  1.00  0.00           H
ATOM   1534  HB1 GLU    92      93.418   7.157   2.586  1.00  0.00           H
ATOM   1535  HB2 GLU    92      94.745   8.304   2.487  1.00  0.00           H
ATOM   1536  HG1 GLU    92      92.001   9.152   3.335  1.00  0.00           H
ATOM   1537  HG2 GLU    92      92.453   9.029   1.636  1.00  0.00           H
ATOM   1538  N   PHE    93      92.796   5.945   5.102  1.00  0.00           N
ATOM   1539  CA  PHE    93      91.686   5.197   5.682  1.00  0.00           C
ATOM   1540  C   PHE    93      91.571   5.460   7.181  1.00  0.00           C
ATOM   1541  O   PHE    93      90.502   5.828   7.670  1.00  0.00           O
ATOM   1542  CB  PHE    93      91.856   3.699   5.414  1.00  0.00           C
ATOM   1543  CG  PHE    93      90.693   2.862   5.867  1.00  0.00           C
ATOM   1544  CD1 PHE    93      89.452   2.999   5.266  1.00  0.00           C
ATOM   1545  CD2 PHE    93      90.842   1.938   6.888  1.00  0.00           C
ATOM   1546  CE1 PHE    93      88.381   2.228   5.674  1.00  0.00           C
ATOM   1547  CE2 PHE    93      89.774   1.164   7.301  1.00  0.00           C
ATOM   1548  CZ  PHE    93      88.541   1.310   6.695  1.00  0.00           C
ATOM   1549  HN  PHE    93      93.520   5.453   4.657  1.00  0.00           H
ATOM   1550  HA  PHE    93      90.778   5.536   5.203  1.00  0.00           H
ATOM   1551  HB1 PHE    93      92.739   3.347   5.929  1.00  0.00           H
ATOM   1552  HB2 PHE    93      91.981   3.542   4.352  1.00  0.00           H
ATOM   1553  HD1 PHE    93      89.325   3.718   4.469  1.00  0.00           H
ATOM   1554  HD2 PHE    93      91.804   1.822   7.362  1.00  0.00           H
ATOM   1555  HE1 PHE    93      87.417   2.344   5.198  1.00  0.00           H
ATOM   1556  HE2 PHE    93      89.901   0.449   8.098  1.00  0.00           H
ATOM   1557  HZ  PHE    93      87.704   0.707   7.016  1.00  0.00           H
ATOM   1558  N   GLN    94      92.671   5.283   7.910  1.00  0.00           N
ATOM   1559  CA  GLN    94      92.678   5.551   9.345  1.00  0.00           C
ATOM   1560  C   GLN    94      92.446   7.031   9.622  1.00  0.00           C
ATOM   1561  O   GLN    94      91.860   7.396  10.638  1.00  0.00           O
ATOM   1562  CB  GLN    94      93.988   5.099   9.988  1.00  0.00           C
ATOM   1563  CG  GLN    94      94.015   3.625  10.344  1.00  0.00           C
ATOM   1564  CD  GLN    94      95.192   3.263  11.230  1.00  0.00           C
ATOM   1565  NE2 GLN    94      95.002   2.278  12.095  1.00  0.00           N
ATOM   1566  OE1 GLN    94      96.258   3.872  11.150  1.00  0.00           O
ATOM   1567  HN  GLN    94      93.495   4.967   7.473  1.00  0.00           H
ATOM   1568  HA  GLN    94      91.865   4.991   9.785  1.00  0.00           H
ATOM   1569  HB1 GLN    94      94.149   5.671  10.890  1.00  0.00           H
ATOM   1570  HB2 GLN    94      94.796   5.293   9.297  1.00  0.00           H
ATOM   1571  HG1 GLN    94      94.078   3.049   9.432  1.00  0.00           H
ATOM   1572  HG2 GLN    94      93.101   3.374  10.863  1.00  0.00           H
ATOM   1573 HE21 GLN    94      94.123   1.842  12.117  1.00  0.00           H
ATOM   1574 HE22 GLN    94      95.749   2.028  12.688  1.00  0.00           H
ATOM   1575  N   LYS    95      92.910   7.870   8.712  1.00  0.00           N
ATOM   1576  CA  LYS    95      92.677   9.307   8.787  1.00  0.00           C
ATOM   1577  C   LYS    95      91.176   9.608   8.779  1.00  0.00           C
ATOM   1578  O   LYS    95      90.695  10.455   9.534  1.00  0.00           O
ATOM   1579  CB  LYS    95      93.376   9.983   7.610  1.00  0.00           C
ATOM   1580  CG  LYS    95      93.049  11.452   7.422  1.00  0.00           C
ATOM   1581  CD  LYS    95      93.696  11.965   6.151  1.00  0.00           C
ATOM   1582  CE  LYS    95      93.212  13.351   5.777  1.00  0.00           C
ATOM   1583  NZ  LYS    95      93.707  13.749   4.433  1.00  0.00           N
ATOM   1584  HN  LYS    95      93.432   7.514   7.960  1.00  0.00           H
ATOM   1585  HA  LYS    95      93.103   9.670   9.710  1.00  0.00           H
ATOM   1586  HB1 LYS    95      93.105   9.462   6.704  1.00  0.00           H
ATOM   1587  HB2 LYS    95      94.443   9.899   7.751  1.00  0.00           H
ATOM   1588  HG1 LYS    95      93.429  12.010   8.264  1.00  0.00           H
ATOM   1589  HG2 LYS    95      91.978  11.571   7.352  1.00  0.00           H
ATOM   1590  HD1 LYS    95      93.464  11.285   5.345  1.00  0.00           H
ATOM   1591  HD2 LYS    95      94.765  11.999   6.295  1.00  0.00           H
ATOM   1592  HE1 LYS    95      93.574  14.058   6.510  1.00  0.00           H
ATOM   1593  HE2 LYS    95      92.132  13.357   5.772  1.00  0.00           H
ATOM   1594  HZ1 LYS    95      93.410  13.041   3.724  1.00  0.00           H
ATOM   1595  HZ2 LYS    95      94.748  13.805   4.435  1.00  0.00           H
ATOM   1596  HZ3 LYS    95      93.321  14.679   4.163  1.00  0.00           H
ATOM   1597  N   ILE    96      90.440   8.896   7.934  1.00  0.00           N
ATOM   1598  CA  ILE    96      88.992   9.035   7.878  1.00  0.00           C
ATOM   1599  C   ILE    96      88.346   8.408   9.113  1.00  0.00           C
ATOM   1600  O   ILE    96      87.362   8.932   9.646  1.00  0.00           O
ATOM   1601  CB  ILE    96      88.414   8.385   6.602  1.00  0.00           C
ATOM   1602  CG1 ILE    96      89.044   9.017   5.358  1.00  0.00           C
ATOM   1603  CG2 ILE    96      86.897   8.524   6.562  1.00  0.00           C
ATOM   1604  CD1 ILE    96      88.621   8.360   4.064  1.00  0.00           C
ATOM   1605  HN  ILE    96      90.886   8.265   7.325  1.00  0.00           H
ATOM   1606  HA  ILE    96      88.758  10.091   7.859  1.00  0.00           H
ATOM   1607  HB  ILE    96      88.654   7.334   6.622  1.00  0.00           H
ATOM   1608 HG11 ILE    96      90.120   8.943   5.432  1.00  0.00           H
ATOM   1609 HG12 ILE    96      88.764  10.059   5.308  1.00  0.00           H
ATOM   1610 HG21 ILE    96      86.467   8.028   7.421  1.00  0.00           H
ATOM   1611 HG22 ILE    96      86.518   8.071   5.658  1.00  0.00           H
ATOM   1612 HG23 ILE    96      86.629   9.570   6.580  1.00  0.00           H
ATOM   1613 HD11 ILE    96      87.548   8.417   3.965  1.00  0.00           H
ATOM   1614 HD12 ILE    96      88.928   7.326   4.068  1.00  0.00           H
ATOM   1615 HD13 ILE    96      89.086   8.870   3.233  1.00  0.00           H
ATOM   1616  N   LEU    97      88.909   7.293   9.572  1.00  0.00           N
ATOM   1617  CA  LEU    97      88.426   6.633  10.782  1.00  0.00           C
ATOM   1618  C   LEU    97      88.510   7.574  11.976  1.00  0.00           C
ATOM   1619  O   LEU    97      87.543   7.740  12.713  1.00  0.00           O
ATOM   1620  CB  LEU    97      89.229   5.359  11.069  1.00  0.00           C
ATOM   1621  CG  LEU    97      89.109   4.256  10.018  1.00  0.00           C
ATOM   1622  CD1 LEU    97      89.942   3.051  10.417  1.00  0.00           C
ATOM   1623  CD2 LEU    97      87.655   3.856   9.826  1.00  0.00           C
ATOM   1624  HN  LEU    97      89.662   6.898   9.075  1.00  0.00           H
ATOM   1625  HA  LEU    97      87.393   6.366  10.622  1.00  0.00           H
ATOM   1626  HB1 LEU    97      88.900   4.959  12.017  1.00  0.00           H
ATOM   1627  HB2 LEU    97      90.272   5.630  11.157  1.00  0.00           H
ATOM   1628  HG  LEU    97      89.484   4.624   9.074  1.00  0.00           H
ATOM   1629 HD11 LEU    97      89.602   2.679  11.372  1.00  0.00           H
ATOM   1630 HD12 LEU    97      90.981   3.339  10.491  1.00  0.00           H
ATOM   1631 HD13 LEU    97      89.836   2.276   9.671  1.00  0.00           H
ATOM   1632 HD21 LEU    97      87.087   4.714   9.494  1.00  0.00           H
ATOM   1633 HD22 LEU    97      87.252   3.499  10.761  1.00  0.00           H
ATOM   1634 HD23 LEU    97      87.592   3.075   9.083  1.00  0.00           H
ATOM   1635  N   LYS    98      89.669   8.203  12.145  1.00  0.00           N
ATOM   1636  CA  LYS    98      89.886   9.154  13.232  1.00  0.00           C
ATOM   1637  C   LYS    98      88.996  10.382  13.063  1.00  0.00           C
ATOM   1638  O   LYS    98      88.609  11.024  14.039  1.00  0.00           O
ATOM   1639  CB  LYS    98      91.351   9.591  13.269  1.00  0.00           C
ATOM   1640  CG  LYS    98      92.330   8.463  13.541  1.00  0.00           C
ATOM   1641  CD  LYS    98      93.766   8.956  13.469  1.00  0.00           C
ATOM   1642  CE  LYS    98      94.762   7.857  13.798  1.00  0.00           C
ATOM   1643  NZ  LYS    98      94.557   7.315  15.167  1.00  0.00           N
ATOM   1644  HN  LYS    98      90.407   8.014  11.521  1.00  0.00           H
ATOM   1645  HA  LYS    98      89.638   8.665  14.161  1.00  0.00           H
ATOM   1646  HB1 LYS    98      91.471  10.335  14.043  1.00  0.00           H
ATOM   1647  HB2 LYS    98      91.605  10.034  12.318  1.00  0.00           H
ATOM   1648  HG1 LYS    98      92.186   7.687  12.804  1.00  0.00           H
ATOM   1649  HG2 LYS    98      92.144   8.065  14.528  1.00  0.00           H
ATOM   1650  HD1 LYS    98      93.893   9.766  14.173  1.00  0.00           H
ATOM   1651  HD2 LYS    98      93.961   9.314  12.469  1.00  0.00           H
ATOM   1652  HE1 LYS    98      95.761   8.260  13.725  1.00  0.00           H
ATOM   1653  HE2 LYS    98      94.645   7.056  13.084  1.00  0.00           H
ATOM   1654  HZ1 LYS    98      95.383   6.748  15.456  1.00  0.00           H
ATOM   1655  HZ2 LYS    98      93.709   6.708  15.189  1.00  0.00           H
ATOM   1656  HZ3 LYS    98      94.427   8.096  15.848  1.00  0.00           H
ATOM   1657  N   LYS    99      88.685  10.701  11.817  1.00  0.00           N
ATOM   1658  CA  LYS    99      87.863  11.857  11.496  1.00  0.00           C
ATOM   1659  C   LYS    99      86.425  11.646  11.963  1.00  0.00           C
ATOM   1660  O   LYS    99      85.867  12.476  12.680  1.00  0.00           O
ATOM   1661  CB  LYS    99      87.905  12.113   9.990  1.00  0.00           C
ATOM   1662  CG  LYS    99      87.112  13.323   9.540  1.00  0.00           C
ATOM   1663  CD  LYS    99      87.308  13.578   8.058  1.00  0.00           C
ATOM   1664  CE  LYS    99      86.539  14.801   7.591  1.00  0.00           C
ATOM   1665  NZ  LYS    99      85.071  14.605   7.680  1.00  0.00           N
ATOM   1666  HN  LYS    99      89.024  10.141  11.084  1.00  0.00           H
ATOM   1667  HA  LYS    99      88.274  12.712  12.009  1.00  0.00           H
ATOM   1668  HB1 LYS    99      87.512  11.244   9.480  1.00  0.00           H
ATOM   1669  HB2 LYS    99      88.933  12.256   9.691  1.00  0.00           H
ATOM   1670  HG1 LYS    99      87.444  14.188  10.095  1.00  0.00           H
ATOM   1671  HG2 LYS    99      86.063  13.148   9.731  1.00  0.00           H
ATOM   1672  HD1 LYS    99      86.964  12.716   7.506  1.00  0.00           H
ATOM   1673  HD2 LYS    99      88.359  13.734   7.867  1.00  0.00           H
ATOM   1674  HE1 LYS    99      86.806  15.006   6.564  1.00  0.00           H
ATOM   1675  HE2 LYS    99      86.819  15.642   8.207  1.00  0.00           H
ATOM   1676  HZ1 LYS    99      84.578  15.417   7.249  1.00  0.00           H
ATOM   1677  HZ2 LYS    99      84.773  14.522   8.678  1.00  0.00           H
ATOM   1678  HZ3 LYS    99      84.793  13.738   7.172  1.00  0.00           H
ATOM   1679  N   ARG   100      85.838  10.522  11.571  1.00  0.00           N
ATOM   1680  CA  ARG   100      84.461  10.209  11.947  1.00  0.00           C
ATOM   1681  C   ARG   100      84.395   9.600  13.342  1.00  0.00           C
ATOM   1682  O   ARG   100      83.314   9.437  13.908  1.00  0.00           O
ATOM   1683  CB  ARG   100      83.830   9.253  10.935  1.00  0.00           C
ATOM   1684  CG  ARG   100      83.481   9.913   9.615  1.00  0.00           C
ATOM   1685  CD  ARG   100      82.824   8.935   8.657  1.00  0.00           C
ATOM   1686  NE  ARG   100      82.267   9.615   7.492  1.00  0.00           N
ATOM   1687  CZ  ARG   100      82.494   9.249   6.231  1.00  0.00           C
ATOM   1688  NH1 ARG   100      83.267   8.203   5.969  1.00  0.00           N
ATOM   1689  NH2 ARG   100      81.947   9.929   5.235  1.00  0.00           N
ATOM   1690  HN  ARG   100      86.341   9.885  11.016  1.00  0.00           H
ATOM   1691  HA  ARG   100      83.904  11.133  11.947  1.00  0.00           H
ATOM   1692  HB1 ARG   100      82.926   8.842  11.358  1.00  0.00           H
ATOM   1693  HB2 ARG   100      84.523   8.447  10.736  1.00  0.00           H
ATOM   1694  HG1 ARG   100      84.386  10.293   9.162  1.00  0.00           H
ATOM   1695  HG2 ARG   100      82.800  10.731   9.800  1.00  0.00           H
ATOM   1696  HD1 ARG   100      82.029   8.420   9.177  1.00  0.00           H
ATOM   1697  HD2 ARG   100      83.562   8.219   8.327  1.00  0.00           H
ATOM   1698  HE  ARG   100      81.681  10.392   7.664  1.00  0.00           H
ATOM   1699 HH11 ARG   100      83.681   7.684   6.712  1.00  0.00           H
ATOM   1700 HH12 ARG   100      83.431   7.922   5.011  1.00  0.00           H
ATOM   1701 HH21 ARG   100      81.352  10.720   5.427  1.00  0.00           H
ATOM   1702 HH22 ARG   100      82.134   9.669   4.280  1.00  0.00           H
ATOM   1703  N   GLY   101      85.551   9.258  13.887  1.00  0.00           N
ATOM   1704  CA  GLY   101      85.601   8.662  15.205  1.00  0.00           C
ATOM   1705  C   GLY   101      85.139   7.221  15.194  1.00  0.00           C
ATOM   1706  O   GLY   101      84.522   6.749  16.150  1.00  0.00           O
ATOM   1707  HN  GLY   101      86.381   9.406  13.386  1.00  0.00           H
ATOM   1708  HA1 GLY   101      84.966   9.228  15.870  1.00  0.00           H
ATOM   1709  HA2 GLY   101      86.618   8.702  15.572  1.00  0.00           H
ATOM   1710  N   THR   102      85.421   6.528  14.101  1.00  0.00           N
ATOM   1711  CA  THR   102      85.081   5.124  13.978  1.00  0.00           C
ATOM   1712  C   THR   102      86.089   4.278  14.747  1.00  0.00           C
ATOM   1713  O   THR   102      87.214   4.062  14.292  1.00  0.00           O
ATOM   1714  CB  THR   102      85.048   4.682  12.499  1.00  0.00           C
ATOM   1715  CG2 THR   102      84.578   3.240  12.370  1.00  0.00           C
ATOM   1716  OG1 THR   102      84.169   5.539  11.753  1.00  0.00           O
ATOM   1717  HN  THR   102      85.889   6.974  13.359  1.00  0.00           H
ATOM   1718  HA  THR   102      84.098   4.977  14.404  1.00  0.00           H
ATOM   1719  HB  THR   102      86.045   4.760  12.093  1.00  0.00           H
ATOM   1720  HG1 THR   102      83.379   5.718  12.274  1.00  0.00           H
ATOM   1721 HG21 THR   102      83.578   3.150  12.766  1.00  0.00           H
ATOM   1722 HG22 THR   102      85.243   2.593  12.922  1.00  0.00           H
ATOM   1723 HG23 THR   102      84.579   2.953  11.327  1.00  0.00           H
END
