
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  189 ( 1575),  selected  189 , name 2be3_B
# Molecule2: number of CA atoms   80 ( 1370),  selected   80 , name T0460.pdb
# PARAMETERS: 2be3_B.T0460.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T     2_B      M       1           -
LGA    L     3_B      N       2           -
LGA    E     4_B      S       3           -
LGA    W     5_B      -       -           -
LGA    E     6_B      -       -           -
LGA    E     7_B      -       -           -
LGA    F     8_B      -       -           -
LGA    L     9_B      -       -           -
LGA    D    10_B      -       -           -
LGA    P    11_B      -       -           -
LGA    Y    12_B      -       -           -
LGA    I    13_B      -       -           -
LGA    Q    14_B      -       -           -
LGA    A    15_B      -       -           -
LGA    V    16_B      -       -           -
LGA    G    17_B      E       4           #
LGA    E    18_B      V       5           #
LGA    L    19_B      I       6          4.625
LGA    K    20_B      K       7          3.223
LGA    I    21_B      E       8          3.964
LGA    K    22_B      F       9          3.197
LGA    L    23_B      L      10          2.690
LGA    R    24_B      E      11          3.782
LGA    G    25_B      D      12          2.414
LGA    I    26_B      I      13          4.209
LGA    R    27_B      -       -           -
LGA    K    28_B      G      14          4.190
LGA    Q    29_B      -       -           -
LGA    Y    30_B      -       -           -
LGA    R    31_B      -       -           -
LGA    K    32_B      -       -           -
LGA    Q    33_B      -       -           -
LGA    N    34_B      -       -           -
LGA    K    35_B      -       -           -
LGA    H    36_B      -       -           -
LGA    S    37_B      -       -           -
LGA    P    38_B      -       -           -
LGA    I    39_B      -       -           -
LGA    E    40_B      E      15           #
LGA    F    41_B      D      16          4.472
LGA    V    42_B      Y      17          2.150
LGA    T    43_B      I      18          1.435
LGA    G    44_B      E      19          0.723
LGA    R    45_B      L      20          2.630
LGA    V    46_B      E      21          2.231
LGA    K    47_B      -       -           -
LGA    P    48_B      -       -           -
LGA    I    49_B      -       -           -
LGA    E    50_B      -       -           -
LGA    S    51_B      -       -           -
LGA    I    52_B      -       -           -
LGA    K    53_B      -       -           -
LGA    E    54_B      -       -           -
LGA    K    55_B      -       -           -
LGA    X    56_B      -       -           -
LGA    A    57_B      -       -           -
LGA    H    68_B      -       -           -
LGA    D    69_B      -       -           -
LGA    L    70_B      -       -           -
LGA    Q    71_B      -       -           -
LGA    D    72_B      -       -           -
LGA    I    73_B      -       -           -
LGA    A    74_B      N      22          2.362
LGA    G    75_B      E      23          2.056
LGA    L    76_B      I      24          1.251
LGA    R    77_B      H      25          1.708
LGA    V    78_B      L      26          2.106
LGA    X    79_B      K      27          1.330
LGA    V    80_B      P      28          1.995
LGA    Q    81_B      E      29          3.046
LGA    F    82_B      V      30           -
LGA    V    83_B      F      31           -
LGA    D    84_B      -       -           -
LGA    D    85_B      -       -           -
LGA    V    86_B      -       -           -
LGA    K    87_B      Y      32           #
LGA    E    88_B      E      33          4.037
LGA    V    89_B      V      34          2.258
LGA    V    90_B      W      35          2.208
LGA    D    91_B      K      36          2.888
LGA    I    92_B      Y      37          1.363
LGA    L    93_B      V      38          2.125
LGA    H    94_B      G      39          3.745
LGA    K    95_B      E      40           -
LGA    R    96_B      -       -           -
LGA    Q    97_B      -       -           -
LGA    D    98_B      -       -           -
LGA    X    99_B      -       -           -
LGA    R   100_B      -       -           -
LGA    I   101_B      -       -           -
LGA    I   102_B      P      41           #
LGA    Q   103_B      -       -           -
LGA    E   104_B      -       -           -
LGA    R   105_B      E      42           #
LGA    D   106_B      L      43          2.963
LGA    Y   107_B      K      44          4.106
LGA    I   108_B      T      45          4.357
LGA    T   109_B      -       -           -
LGA    H   110_B      -       -           -
LGA    R   111_B      Y      46          4.287
LGA    K   112_B      V      47          1.418
LGA    A   113_B      I      48          5.039
LGA    S   114_B      E      49          2.171
LGA    -       -      K      72           -
LGA    G   115_B      I      73          1.882
LGA    Y   116_B      K      74          3.306
LGA    R   117_B      K      75          0.901
LGA    S   118_B      V      76          1.273
LGA    Y   119_B      Y      77          2.206
LGA    H   120_B      F      78          1.973
LGA    V   121_B      -       -           -
LGA    V   122_B      E      79          2.064
LGA    V   123_B      T      80          2.182
LGA    E   124_B      L      81          2.619
LGA    Y   125_B      D      82          4.585
LGA    T   126_B      -       -           -
LGA    V   127_B      -       -           -
LGA    D   128_B      -       -           -
LGA    T   129_B      -       -           -
LGA    I   130_B      -       -           -
LGA    N   131_B      -       -           -
LGA    G   132_B      -       -           -
LGA    A   133_B      -       -           -
LGA    K   134_B      -       -           -
LGA    T   135_B      -       -           -
LGA    I   136_B      -       -           -
LGA    L   137_B      N      83          3.644
LGA    A   138_B      V      84          2.407
LGA    E   139_B      R      85          2.388
LGA    I   140_B      V      86          2.251
LGA    Q   141_B      V      87          2.269
LGA    I   142_B      -       -           -
LGA    R   143_B      T      88          1.631
LGA    T   144_B      -       -           -
LGA    L   145_B      -       -           -
LGA    A   146_B      -       -           -
LGA    X   147_B      -       -           -
LGA    N   148_B      D      89          4.505
LGA    F   149_B      Y      90           -
LGA    W   150_B      -       -           -
LGA    A   151_B      -       -           -
LGA    T   152_B      -       -           -
LGA    I   153_B      -       -           -
LGA    E   154_B      -       -           -
LGA    H   155_B      -       -           -
LGA    S   156_B      -       -           -
LGA    L   157_B      -       -           -
LGA    N   158_B      -       -           -
LGA    Y   159_B      -       -           -
LGA    K   160_B      -       -           -
LGA    Y   161_B      -       -           -
LGA    Q   162_B      -       -           -
LGA    D   164_B      -       -           -
LGA    F   165_B      -       -           -
LGA    P   166_B      -       -           -
LGA    D   167_B      -       -           -
LGA    E   168_B      -       -           -
LGA    I   169_B      -       -           -
LGA    K   170_B      -       -           -
LGA    K   171_B      -       -           -
LGA    R   172_B      -       -           -
LGA    L   173_B      -       -           -
LGA    E   174_B      -       -           -
LGA    I   175_B      -       -           -
LGA    T   176_B      -       -           -
LGA    A   177_B      -       -           -
LGA    R   178_B      -       -           -
LGA    I   179_B      -       -           -
LGA    A   180_B      -       -           -
LGA    H   181_B      S      91          3.047
LGA    Q   182_B      -       -           -
LGA    L   183_B      -       -           -
LGA    D   184_B      -       -           -
LGA    E   185_B      E      92           #
LGA    E   186_B      F      93           -
LGA    X   187_B      Q      94           -
LGA    G   188_B      K      95          4.034
LGA    -       -      I      96           -
LGA    -       -      L      97           -
LGA    E   189_B      K      98          3.997
LGA    I   190_B      K      99          4.735
LGA    R   191_B      R     100          4.713
LGA    D   192_B      G     101          4.536
LGA    D   193_B      T     102           -
LGA    I   194_B      -       -           -
LGA    Q   195_B      -       -           -
LGA    E   196_B      -       -           -
LGA    A   197_B      -       -           -
LGA    Q   198_B      -       -           -
LGA    A   199_B      -       -           -
LGA    L   200_B      -       -           -
LGA    F   201_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  189   80    5.0     60    3.08    11.67     45.879     1.885

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.175650 * X  +  -0.878597 * Y  +   0.444088 * Z  + 126.331985
  Y_new =  -0.566847 * X  +   0.459081 * Y  +   0.684054 * Z  + -33.422249
  Z_new =  -0.804880 * X  +  -0.131575 * Y  +  -0.578668 * Z  +  -7.205715 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.918017    0.223575  [ DEG:  -167.1901     12.8099 ]
  Theta =   0.935473    2.206120  [ DEG:    53.5987    126.4013 ]
  Phi   =  -1.871286    1.270307  [ DEG:  -107.2168     72.7832 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2be3_B                                        
REMARK     2: T0460.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2be3_B.T0460.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  189   80   5.0   60   3.08   11.67  45.879
REMARK  ---------------------------------------------------------- 
MOLECULE 2be3_B
HEADER    TRANSFERASE                             21-OCT-05   2BE3              
TITLE     STRUCTURE OF A GTP PYROPHOSPHOKINASE FAMILY PROTEIN FROM              
TITLE    2 STREPTOCOCCUS PNEUMONIAE                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: GTP PYROPHOSPHOKINASE;                                     
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 EC: 2.7.6.5;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOCOCCUS PNEUMONIAE;                       
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: TIGR4;                                                       
SOURCE   5 GENE: SP1097;                                                        
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    GTP, STREPTOCOCCUS PNEUMONIAE, PYROPHOSPHOKINASE,                     
KEYWDS   2 STRUCTURAL GENOMICS, PSI, PROTEIN STRUCTURE INITIATIVE,              
KEYWDS   3 MIDWEST CENTER FOR STRUCTURAL GENOMICS, MCSG                         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.E.CUFF,C.HATZOS,A.JOACHIMIAK,MIDWEST CENTER FOR                     
AUTHOR   2 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   1   06-DEC-05 2BE3    0                                                
JRNL        AUTH   M.E.CUFF,C.HATZOS,A.JOACHIMIAK                               
JRNL        TITL   STRUCTURE OF A GTP PYROPHOSPHOKINASE FAMILY                  
JRNL        TITL 2 PROTEIN FROM STREPTOCOCCUS PNEUMONIAE                        
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.40 ANGSTROMS.                                          
DBREF  2BE3 A    1   223  UNP    Q97QV1   Q97QV1_STRPN     1    223             
DBREF  2BE3 B    1   223  UNP    Q97QV1   Q97QV1_STRPN     1    223             
SEQRES   1 A  226  SER ASN ALA MSE THR LEU GLU TRP GLU GLU PHE LEU ASP          
SEQRES   2 A  226  PRO TYR ILE GLN ALA VAL GLY GLU LEU LYS ILE LYS LEU          
SEQRES   3 A  226  ARG GLY ILE ARG LYS GLN TYR ARG LYS GLN ASN LYS HIS          
SEQRES   4 A  226  SER PRO ILE GLU PHE VAL THR GLY ARG VAL LYS PRO ILE          
SEQRES   5 A  226  GLU SER ILE LYS GLU LYS MSE ALA ARG ARG GLY ILE THR          
SEQRES   6 A  226  TYR ALA THR LEU GLU HIS ASP LEU GLN ASP ILE ALA GLY          
SEQRES   7 A  226  LEU ARG VAL MSE VAL GLN PHE VAL ASP ASP VAL LYS GLU          
SEQRES   8 A  226  VAL VAL ASP ILE LEU HIS LYS ARG GLN ASP MSE ARG ILE          
SEQRES   9 A  226  ILE GLN GLU ARG ASP TYR ILE THR HIS ARG LYS ALA SER          
SEQRES  10 A  226  GLY TYR ARG SER TYR HIS VAL VAL VAL GLU TYR THR VAL          
SEQRES  11 A  226  ASP THR ILE ASN GLY ALA LYS THR ILE LEU ALA GLU ILE          
SEQRES  12 A  226  GLN ILE ARG THR LEU ALA MSE ASN PHE TRP ALA THR ILE          
SEQRES  13 A  226  GLU HIS SER LEU ASN TYR LYS TYR GLN GLY ASP PHE PRO          
SEQRES  14 A  226  ASP GLU ILE LYS LYS ARG LEU GLU ILE THR ALA ARG ILE          
SEQRES  15 A  226  ALA HIS GLN LEU ASP GLU GLU MSE GLY GLU ILE ARG ASP          
SEQRES  16 A  226  ASP ILE GLN GLU ALA GLN ALA LEU PHE ASP PRO LEU SER          
SEQRES  17 A  226  ARG LYS LEU ASN ASP GLY VAL GLY ASN SER ASP ASP THR          
SEQRES  18 A  226  ASP GLU GLU TYR ARG                                          
SEQRES   1 B  226  SER ASN ALA MSE THR LEU GLU TRP GLU GLU PHE LEU ASP          
SEQRES   2 B  226  PRO TYR ILE GLN ALA VAL GLY GLU LEU LYS ILE LYS LEU          
SEQRES   3 B  226  ARG GLY ILE ARG LYS GLN TYR ARG LYS GLN ASN LYS HIS          
SEQRES   4 B  226  SER PRO ILE GLU PHE VAL THR GLY ARG VAL LYS PRO ILE          
SEQRES   5 B  226  GLU SER ILE LYS GLU LYS MSE ALA ARG ARG GLY ILE THR          
SEQRES   6 B  226  TYR ALA THR LEU GLU HIS ASP LEU GLN ASP ILE ALA GLY          
SEQRES   7 B  226  LEU ARG VAL MSE VAL GLN PHE VAL ASP ASP VAL LYS GLU          
SEQRES   8 B  226  VAL VAL ASP ILE LEU HIS LYS ARG GLN ASP MSE ARG ILE          
SEQRES   9 B  226  ILE GLN GLU ARG ASP TYR ILE THR HIS ARG LYS ALA SER          
SEQRES  10 B  226  GLY TYR ARG SER TYR HIS VAL VAL VAL GLU TYR THR VAL          
SEQRES  11 B  226  ASP THR ILE ASN GLY ALA LYS THR ILE LEU ALA GLU ILE          
SEQRES  12 B  226  GLN ILE ARG THR LEU ALA MSE ASN PHE TRP ALA THR ILE          
SEQRES  13 B  226  GLU HIS SER LEU ASN TYR LYS TYR GLN GLY ASP PHE PRO          
SEQRES  14 B  226  ASP GLU ILE LYS LYS ARG LEU GLU ILE THR ALA ARG ILE          
SEQRES  15 B  226  ALA HIS GLN LEU ASP GLU GLU MSE GLY GLU ILE ARG ASP          
SEQRES  16 B  226  ASP ILE GLN GLU ALA GLN ALA LEU PHE ASP PRO LEU SER          
SEQRES  17 B  226  ARG LYS LEU ASN ASP GLY VAL GLY ASN SER ASP ASP THR          
SEQRES  18 B  226  ASP GLU GLU TYR ARG                                          
HET    MSE  A   1       8                                                       
HET    MSE  A  56       8                                                       
HET    MSE  A  79       8                                                       
HET    MSE  A  99       8                                                       
HET    MSE  A 147       8                                                       
HET    MSE  A 187       8                                                       
HET    MSE  B  56       8                                                       
HET    MSE  B  79       8                                                       
HET    MSE  B  99       8                                                       
HET    MSE  B 147       8                                                       
HET    MSE  B 187       8                                                       
HET     CL    301       1                                                       
HET    PG4    303      13                                                       
HET    GOL    302       6                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      CL CHLORIDE ION                                                     
HETNAM     PG4 TETRAETHYLENE GLYCOL                                             
HETNAM     GOL GLYCEROL                                                         
FORMUL   1  MSE    11(C5 H11 N O2 SE)                                           
FORMUL   3   CL    CL 1-                                                        
FORMUL   4  PG4    C8 H18 O5                                                    
FORMUL   5  GOL    C3 H8 O3                                                     
FORMUL   6  HOH   *251(H2 O)                                                    
CRYST1  104.843  104.843  170.562  90.00  90.00 120.00 P 61 2 2     24          
ATOM   1704  N   THR B   2     100.754 -12.617 -26.426  1.00 80.12           N  
ATOM   1705  CA  THR B   2     100.252 -13.473 -27.552  1.00 80.19           C  
ATOM   1706  C   THR B   2      98.719 -13.614 -27.562  1.00 79.86           C  
ATOM   1707  O   THR B   2      98.016 -13.037 -26.727  1.00 79.67           O  
ATOM   1708  CB  THR B   2     100.895 -14.901 -27.544  1.00 80.36           C  
ATOM   1709  OG1 THR B   2     100.696 -15.520 -26.259  1.00 80.70           O  
ATOM   1710  CG2 THR B   2     102.389 -14.847 -27.887  1.00 80.03           C  
ATOM   1711  N   LEU B   3      98.224 -14.388 -28.522  1.00 79.52           N  
ATOM   1712  CA  LEU B   3      96.810 -14.683 -28.653  1.00 79.09           C  
ATOM   1713  C   LEU B   3      96.358 -15.645 -27.544  1.00 78.81           C  
ATOM   1714  O   LEU B   3      95.216 -15.561 -27.083  1.00 78.78           O  
ATOM   1715  CB  LEU B   3      96.534 -15.239 -30.061  1.00 79.30           C  
ATOM   1716  CG  LEU B   3      95.202 -15.757 -30.652  1.00 79.87           C  
ATOM   1717  CD1 LEU B   3      95.087 -17.289 -30.555  1.00 80.68           C  
ATOM   1718  CD2 LEU B   3      93.927 -15.061 -30.118  1.00 80.91           C  
ATOM   1719  N   GLU B   4      97.262 -16.528 -27.106  1.00 78.22           N  
ATOM   1720  CA  GLU B   4      96.972 -17.536 -26.066  1.00 77.64           C  
ATOM   1721  C   GLU B   4      96.739 -16.892 -24.699  1.00 77.00           C  
ATOM   1722  O   GLU B   4      95.854 -17.310 -23.932  1.00 76.43           O  
ATOM   1723  CB  GLU B   4      98.112 -18.553 -25.971  1.00 77.73           C  
ATOM   1724  CG  GLU B   4      98.278 -19.420 -27.223  1.00 79.37           C  
ATOM   1725  CD  GLU B   4      99.732 -19.763 -27.523  1.00 80.90           C  
ATOM   1726  OE1 GLU B   4     100.001 -20.924 -27.900  1.00 81.62           O  
ATOM   1727  OE2 GLU B   4     100.608 -18.874 -27.385  1.00 81.65           O  
ATOM   1728  N   TRP B   5      97.549 -15.873 -24.417  1.00 76.12           N  
ATOM   1729  CA  TRP B   5      97.422 -15.062 -23.219  1.00 75.26           C  
ATOM   1730  C   TRP B   5      96.219 -14.137 -23.268  1.00 74.83           C  
ATOM   1731  O   TRP B   5      95.608 -13.875 -22.243  1.00 74.96           O  
ATOM   1732  CB  TRP B   5      98.695 -14.259 -23.008  1.00 75.22           C  
ATOM   1733  CG  TRP B   5      99.734 -15.056 -22.337  1.00 75.02           C  
ATOM   1734  CD1 TRP B   5     100.761 -15.735 -22.928  1.00 74.94           C  
ATOM   1735  CD2 TRP B   5      99.838 -15.301 -20.932  1.00 74.83           C  
ATOM   1736  NE1 TRP B   5     101.512 -16.378 -21.971  1.00 74.90           N  
ATOM   1737  CE2 TRP B   5     100.969 -16.124 -20.735  1.00 74.93           C  
ATOM   1738  CE3 TRP B   5      99.090 -14.894 -19.817  1.00 74.65           C  
ATOM   1739  CZ2 TRP B   5     101.376 -16.551 -19.462  1.00 74.82           C  
ATOM   1740  CZ3 TRP B   5      99.492 -15.321 -18.554  1.00 75.20           C  
ATOM   1741  CH2 TRP B   5     100.625 -16.146 -18.388  1.00 75.16           C  
ATOM   1742  N   GLU B   6      95.901 -13.636 -24.461  1.00 74.46           N  
ATOM   1743  CA  GLU B   6      94.699 -12.830 -24.711  1.00 74.40           C  
ATOM   1744  C   GLU B   6      93.446 -13.630 -24.315  1.00 72.90           C  
ATOM   1745  O   GLU B   6      92.576 -13.116 -23.607  1.00 72.85           O  
ATOM   1746  CB  GLU B   6      94.636 -12.407 -26.196  1.00 74.37           C  
ATOM   1747  CG  GLU B   6      93.472 -11.453 -26.590  1.00 76.22           C  
ATOM   1748  CD  GLU B   6      92.893 -11.712 -28.012  1.00 76.70           C  
ATOM   1749  OE1 GLU B   6      93.678 -11.880 -28.985  1.00 78.01           O  
ATOM   1750  OE2 GLU B   6      91.637 -11.745 -28.154  1.00 79.79           O  
ATOM   1751  N   GLU B   7      93.388 -14.886 -24.763  1.00 71.33           N  
ATOM   1752  CA  GLU B   7      92.295 -15.810 -24.463  1.00 69.98           C  
ATOM   1753  C   GLU B   7      92.130 -16.135 -22.978  1.00 68.60           C  
ATOM   1754  O   GLU B   7      91.012 -16.128 -22.465  1.00 68.39           O  
ATOM   1755  CB  GLU B   7      92.477 -17.105 -25.238  1.00 70.27           C  
ATOM   1756  CG  GLU B   7      92.371 -16.919 -26.726  1.00 72.41           C  
ATOM   1757  CD  GLU B   7      92.129 -18.216 -27.470  1.00 74.93           C  
ATOM   1758  OE1 GLU B   7      91.345 -19.061 -26.971  1.00 76.26           O  
ATOM   1759  OE2 GLU B   7      92.716 -18.378 -28.566  1.00 75.80           O  
ATOM   1760  N   PHE B   8      93.244 -16.418 -22.303  1.00 66.90           N  
ATOM   1761  CA  PHE B   8      93.241 -16.729 -20.874  1.00 65.38           C  
ATOM   1762  C   PHE B   8      92.805 -15.533 -20.018  1.00 64.97           C  
ATOM   1763  O   PHE B   8      92.154 -15.692 -18.971  1.00 64.68           O  
ATOM   1764  CB  PHE B   8      94.627 -17.226 -20.435  1.00 64.69           C  
ATOM   1765  CG  PHE B   8      94.805 -17.294 -18.938  1.00 63.90           C  
ATOM   1766  CD1 PHE B   8      94.340 -18.400 -18.211  1.00 63.26           C  
ATOM   1767  CD2 PHE B   8      95.423 -16.251 -18.252  1.00 60.93           C  
ATOM   1768  CE1 PHE B   8      94.495 -18.458 -16.824  1.00 62.80           C  
ATOM   1769  CE2 PHE B   8      95.580 -16.304 -16.872  1.00 60.72           C  
ATOM   1770  CZ  PHE B   8      95.120 -17.401 -16.153  1.00 61.62           C  
ATOM   1771  N   LEU B   9      93.163 -14.337 -20.469  1.00 64.33           N  
ATOM   1772  CA  LEU B   9      92.870 -13.129 -19.718  1.00 64.00           C  
ATOM   1773  C   LEU B   9      91.524 -12.494 -20.031  1.00 64.01           C  
ATOM   1774  O   LEU B   9      91.086 -11.639 -19.263  1.00 64.17           O  
ATOM   1775  CB  LEU B   9      93.987 -12.093 -19.875  1.00 63.89           C  
ATOM   1776  CG  LEU B   9      95.347 -12.360 -19.220  1.00 64.13           C  
ATOM   1777  CD1 LEU B   9      96.351 -11.307 -19.687  1.00 64.52           C  
ATOM   1778  CD2 LEU B   9      95.304 -12.429 -17.684  1.00 61.30           C  
ATOM   1779  N   ASP B  10      90.878 -12.886 -21.141  1.00 64.17           N  
ATOM   1780  CA  ASP B  10      89.543 -12.359 -21.496  1.00 64.64           C  
ATOM   1781  C   ASP B  10      88.595 -12.273 -20.278  1.00 63.75           C  
ATOM   1782  O   ASP B  10      88.060 -11.190 -19.971  1.00 63.55           O  
ATOM   1783  CB  ASP B  10      88.872 -13.201 -22.590  1.00 65.36           C  
ATOM   1784  CG  ASP B  10      89.003 -12.591 -23.984  1.00 70.72           C  
ATOM   1785  OD1 ASP B  10      88.655 -13.316 -24.966  1.00 75.61           O  
ATOM   1786  OD2 ASP B  10      89.463 -11.413 -24.123  1.00 74.63           O  
ATOM   1787  N   PRO B  11      88.365 -13.416 -19.592  1.00 62.71           N  
ATOM   1788  CA  PRO B  11      87.428 -13.338 -18.473  1.00 61.75           C  
ATOM   1789  C   PRO B  11      87.852 -12.350 -17.367  1.00 60.81           C  
ATOM   1790  O   PRO B  11      86.993 -11.681 -16.819  1.00 60.42           O  
ATOM   1791  CB  PRO B  11      87.350 -14.786 -17.972  1.00 61.20           C  
ATOM   1792  CG  PRO B  11      88.589 -15.423 -18.471  1.00 62.60           C  
ATOM   1793  CD  PRO B  11      88.864 -14.792 -19.789  1.00 62.04           C  
ATOM   1794  N   TYR B  12      89.145 -12.251 -17.054  1.00 60.25           N  
ATOM   1795  CA  TYR B  12      89.630 -11.246 -16.085  1.00 59.82           C  
ATOM   1796  C   TYR B  12      89.445  -9.809 -16.587  1.00 59.69           C  
ATOM   1797  O   TYR B  12      89.086  -8.935 -15.806  1.00 59.79           O  
ATOM   1798  CB  TYR B  12      91.094 -11.488 -15.682  1.00 59.48           C  
ATOM   1799  CG  TYR B  12      91.327 -12.863 -15.127  1.00 58.69           C  
ATOM   1800  CD1 TYR B  12      91.231 -13.100 -13.749  1.00 58.14           C  
ATOM   1801  CD2 TYR B  12      91.610 -13.938 -15.973  1.00 57.63           C  
ATOM   1802  CE1 TYR B  12      91.425 -14.365 -13.215  1.00 57.02           C  
ATOM   1803  CE2 TYR B  12      91.804 -15.234 -15.450  1.00 57.84           C  
ATOM   1804  CZ  TYR B  12      91.719 -15.433 -14.069  1.00 58.59           C  
ATOM   1805  OH  TYR B  12      91.897 -16.697 -13.532  1.00 59.87           O  
ATOM   1806  N   ILE B  13      89.673  -9.579 -17.880  1.00 59.54           N  
ATOM   1807  CA  ILE B  13      89.402  -8.275 -18.504  1.00 60.12           C  
ATOM   1808  C   ILE B  13      87.906  -7.927 -18.456  1.00 60.51           C  
ATOM   1809  O   ILE B  13      87.524  -6.823 -18.094  1.00 60.60           O  
ATOM   1810  CB  ILE B  13      89.925  -8.212 -19.964  1.00 60.21           C  
ATOM   1811  CG1 ILE B  13      91.458  -8.236 -19.977  1.00 59.57           C  
ATOM   1812  CG2 ILE B  13      89.371  -6.985 -20.706  1.00 58.91           C  
ATOM   1813  CD1 ILE B  13      92.063  -8.882 -21.233  1.00 60.15           C  
ATOM   1814  N   GLN B  14      87.050  -8.870 -18.788  1.00 61.09           N  
ATOM   1815  CA  GLN B  14      85.622  -8.627 -18.629  1.00 62.28           C  
ATOM   1816  C   GLN B  14      85.214  -8.313 -17.161  1.00 62.89           C  
ATOM   1817  O   GLN B  14      84.402  -7.414 -16.908  1.00 63.55           O  
ATOM   1818  CB  GLN B  14      84.840  -9.802 -19.209  1.00 62.16           C  
ATOM   1819  CG  GLN B  14      83.344  -9.687 -19.136  1.00 61.76           C  
ATOM   1820  CD  GLN B  14      82.681 -10.917 -19.719  1.00 61.15           C  
ATOM   1821  OE1 GLN B  14      83.326 -11.714 -20.408  1.00 61.67           O  
ATOM   1822  NE2 GLN B  14      81.393 -11.082 -19.447  1.00 59.57           N  
ATOM   1823  N   ALA B  15      85.809  -9.014 -16.207  1.00 63.06           N  
ATOM   1824  CA  ALA B  15      85.414  -8.872 -14.805  1.00 64.09           C  
ATOM   1825  C   ALA B  15      85.802  -7.500 -14.247  1.00 65.19           C  
ATOM   1826  O   ALA B  15      85.011  -6.852 -13.579  1.00 66.10           O  
ATOM   1827  CB  ALA B  15      86.020  -9.984 -13.970  1.00 63.18           C  
ATOM   1828  N   VAL B  16      87.026  -7.066 -14.519  1.00 65.46           N  
ATOM   1829  CA  VAL B  16      87.444  -5.736 -14.136  1.00 66.09           C  
ATOM   1830  C   VAL B  16      86.488  -4.682 -14.702  1.00 67.13           C  
ATOM   1831  O   VAL B  16      86.037  -3.803 -13.960  1.00 68.10           O  
ATOM   1832  CB  VAL B  16      88.890  -5.442 -14.589  1.00 65.65           C  
ATOM   1833  CG1 VAL B  16      89.222  -3.995 -14.339  1.00 62.16           C  
ATOM   1834  CG2 VAL B  16      89.843  -6.382 -13.836  1.00 64.87           C  
ATOM   1835  N   GLY B  17      86.184  -4.773 -15.999  1.00 66.74           N  
ATOM   1836  CA  GLY B  17      85.196  -3.890 -16.617  1.00 66.21           C  
ATOM   1837  C   GLY B  17      83.870  -3.839 -15.870  1.00 66.11           C  
ATOM   1838  O   GLY B  17      83.384  -2.766 -15.554  1.00 65.93           O  
ATOM   1839  N   GLU B  18      83.291  -4.997 -15.569  1.00 65.98           N  
ATOM   1840  CA  GLU B  18      81.988  -5.054 -14.923  1.00 66.79           C  
ATOM   1841  C   GLU B  18      82.042  -4.549 -13.492  1.00 66.76           C  
ATOM   1842  O   GLU B  18      81.148  -3.839 -13.053  1.00 67.17           O  
ATOM   1843  CB  GLU B  18      81.454  -6.481 -14.913  1.00 66.77           C  
ATOM   1844  CG  GLU B  18      81.075  -7.033 -16.281  1.00 67.18           C  
ATOM   1845  CD  GLU B  18      80.479  -8.450 -16.187  1.00 68.65           C  
ATOM   1846  OE1 GLU B  18      80.198  -8.924 -15.047  1.00 70.60           O  
ATOM   1847  OE2 GLU B  18      80.285  -9.084 -17.250  1.00 70.14           O  
ATOM   1848  N   LEU B  19      83.088  -4.932 -12.765  1.00 66.60           N  
ATOM   1849  CA  LEU B  19      83.252  -4.559 -11.371  1.00 66.32           C  
ATOM   1850  C   LEU B  19      83.503  -3.057 -11.201  1.00 67.58           C  
ATOM   1851  O   LEU B  19      82.957  -2.455 -10.281  1.00 67.79           O  
ATOM   1852  CB  LEU B  19      84.340  -5.406 -10.725  1.00 65.19           C  
ATOM   1853  CG  LEU B  19      83.798  -6.764 -10.266  1.00 65.96           C  
ATOM   1854  CD1 LEU B  19      84.912  -7.725  -9.870  1.00 65.21           C  
ATOM   1855  CD2 LEU B  19      82.837  -6.575  -9.096  1.00 62.27           C  
ATOM   1856  N   LYS B  20      84.308  -2.450 -12.086  1.00 68.56           N  
ATOM   1857  CA  LYS B  20      84.446  -0.989 -12.136  1.00 69.28           C  
ATOM   1858  C   LYS B  20      83.098  -0.310 -12.248  1.00 69.81           C  
ATOM   1859  O   LYS B  20      82.785   0.560 -11.452  1.00 70.70           O  
ATOM   1860  CB  LYS B  20      85.337  -0.539 -13.282  1.00 69.12           C  
ATOM   1861  CG  LYS B  20      86.793  -0.408 -12.886  1.00 71.25           C  
ATOM   1862  CD  LYS B  20      87.744  -0.640 -14.042  1.00 71.59           C  
ATOM   1863  CE  LYS B  20      88.223   0.643 -14.614  1.00 74.66           C  
ATOM   1864  NZ  LYS B  20      89.238   0.444 -15.696  1.00 77.01           N  
ATOM   1865  N   ILE B  21      82.290  -0.697 -13.223  1.00 70.38           N  
ATOM   1866  CA  ILE B  21      80.985  -0.085 -13.367  1.00 70.97           C  
ATOM   1867  C   ILE B  21      80.188  -0.345 -12.085  1.00 70.79           C  
ATOM   1868  O   ILE B  21      79.614   0.553 -11.507  1.00 71.47           O  
ATOM   1869  CB  ILE B  21      80.181  -0.636 -14.603  1.00 71.56           C  
ATOM   1870  CG1 ILE B  21      80.912  -0.411 -15.953  1.00 72.63           C  
ATOM   1871  CG2 ILE B  21      78.764  -0.058 -14.649  1.00 70.94           C  
ATOM   1872  CD1 ILE B  21      81.688   0.876 -16.103  1.00 76.18           C  
ATOM   1873  N   LYS B  22      80.141  -1.586 -11.639  1.00 70.35           N  
ATOM   1874  CA  LYS B  22      79.347  -1.901 -10.462  1.00 69.73           C  
ATOM   1875  C   LYS B  22      79.777  -1.099  -9.208  1.00 69.73           C  
ATOM   1876  O   LYS B  22      78.930  -0.555  -8.524  1.00 70.58           O  
ATOM   1877  CB  LYS B  22      79.309  -3.413 -10.218  1.00 69.19           C  
ATOM   1878  CG  LYS B  22      78.445  -4.167 -11.203  1.00 66.95           C  
ATOM   1879  CD  LYS B  22      78.839  -5.606 -11.238  1.00 64.27           C  
ATOM   1880  CE  LYS B  22      77.738  -6.459 -11.821  1.00 63.69           C  
ATOM   1881  NZ  LYS B  22      77.854  -7.852 -11.321  1.00 64.74           N  
ATOM   1882  N   LEU B  23      81.076  -1.004  -8.938  1.00 69.01           N  
ATOM   1883  CA  LEU B  23      81.557  -0.348  -7.723  1.00 69.10           C  
ATOM   1884  C   LEU B  23      81.359   1.166  -7.788  1.00 69.29           C  
ATOM   1885  O   LEU B  23      81.032   1.787  -6.785  1.00 69.60           O  
ATOM   1886  CB  LEU B  23      83.013  -0.729  -7.403  1.00 68.89           C  
ATOM   1887  CG  LEU B  23      83.217  -2.225  -7.087  1.00 69.42           C  
ATOM   1888  CD1 LEU B  23      84.674  -2.640  -7.242  1.00 69.35           C  
ATOM   1889  CD2 LEU B  23      82.678  -2.619  -5.728  1.00 70.44           C  
ATOM   1890  N   ARG B  24      81.537   1.742  -8.976  1.00 69.15           N  
ATOM   1891  CA  ARG B  24      81.157   3.122  -9.257  1.00 69.03           C  
ATOM   1892  C   ARG B  24      79.675   3.435  -9.037  1.00 69.46           C  
ATOM   1893  O   ARG B  24      79.343   4.561  -8.674  1.00 70.47           O  
ATOM   1894  CB  ARG B  24      81.571   3.504 -10.667  1.00 68.51           C  
ATOM   1895  CG  ARG B  24      83.056   3.848 -10.752  1.00 68.45           C  
ATOM   1896  CD  ARG B  24      83.531   3.860 -12.190  1.00 67.82           C  
ATOM   1897  NE  ARG B  24      84.988   3.923 -12.261  1.00 69.48           N  
ATOM   1898  CZ  ARG B  24      85.717   3.680 -13.347  1.00 67.78           C  
ATOM   1899  NH1 ARG B  24      85.141   3.335 -14.489  1.00 68.80           N  
ATOM   1900  NH2 ARG B  24      87.032   3.774 -13.285  1.00 67.81           N  
ATOM   1901  N   GLY B  25      78.795   2.458  -9.238  1.00 69.93           N  
ATOM   1902  CA  GLY B  25      77.368   2.652  -9.057  1.00 70.60           C  
ATOM   1903  C   GLY B  25      76.945   2.639  -7.595  1.00 71.78           C  
ATOM   1904  O   GLY B  25      75.878   3.141  -7.251  1.00 72.30           O  
ATOM   1905  N   ILE B  26      77.756   2.037  -6.731  1.00 72.46           N  
ATOM   1906  CA  ILE B  26      77.556   2.171  -5.295  1.00 73.41           C  
ATOM   1907  C   ILE B  26      77.601   3.653  -4.946  1.00 74.12           C  
ATOM   1908  O   ILE B  26      76.711   4.143  -4.269  1.00 74.35           O  
ATOM   1909  CB  ILE B  26      78.641   1.434  -4.484  1.00 73.29           C  
ATOM   1910  CG1 ILE B  26      78.430  -0.067  -4.568  1.00 71.94           C  
ATOM   1911  CG2 ILE B  26      78.646   1.892  -3.023  1.00 73.09           C  
ATOM   1912  CD1 ILE B  26      79.638  -0.842  -4.124  1.00 70.11           C  
ATOM   1913  N   ARG B  27      78.640   4.352  -5.407  1.00 75.27           N  
ATOM   1914  CA  ARG B  27      78.791   5.775  -5.146  1.00 76.42           C  
ATOM   1915  C   ARG B  27      77.580   6.560  -5.631  1.00 77.70           C  
ATOM   1916  O   ARG B  27      77.019   7.359  -4.874  1.00 77.78           O  
ATOM   1917  CB  ARG B  27      80.053   6.328  -5.800  1.00 76.52           C  
ATOM   1918  CG  ARG B  27      80.110   7.828  -5.713  1.00 76.74           C  
ATOM   1919  CD  ARG B  27      81.456   8.418  -6.118  1.00 79.52           C  
ATOM   1920  NE  ARG B  27      81.345   9.878  -6.277  1.00 79.85           N  
ATOM   1921  CZ  ARG B  27      81.446  10.783  -5.298  1.00 79.33           C  
ATOM   1922  NH1 ARG B  27      81.693  10.426  -4.033  1.00 78.80           N  
ATOM   1923  NH2 ARG B  27      81.306  12.061  -5.596  1.00 77.94           N  
ATOM   1924  N   LYS B  28      77.170   6.329  -6.883  1.00 78.91           N  
ATOM   1925  CA  LYS B  28      76.033   7.051  -7.460  1.00 80.46           C  
ATOM   1926  C   LYS B  28      74.762   6.808  -6.647  1.00 81.07           C  
ATOM   1927  O   LYS B  28      73.906   7.683  -6.555  1.00 81.57           O  
ATOM   1928  CB  LYS B  28      75.805   6.687  -8.937  1.00 80.73           C  
ATOM   1929  CG  LYS B  28      77.082   6.647  -9.766  1.00 82.28           C  
ATOM   1930  CD  LYS B  28      76.863   7.011 -11.230  1.00 85.66           C  
ATOM   1931  CE  LYS B  28      76.263   5.869 -12.046  1.00 88.22           C  
ATOM   1932  NZ  LYS B  28      77.197   4.718 -12.213  1.00 89.21           N  
ATOM   1933  N   GLN B  29      74.653   5.628  -6.048  1.00 81.42           N  
ATOM   1934  CA  GLN B  29      73.498   5.286  -5.235  1.00 81.95           C  
ATOM   1935  C   GLN B  29      73.466   6.036  -3.913  1.00 82.77           C  
ATOM   1936  O   GLN B  29      72.399   6.317  -3.391  1.00 82.87           O  
ATOM   1937  CB  GLN B  29      73.437   3.776  -4.988  1.00 81.68           C  
ATOM   1938  CG  GLN B  29      72.821   2.989  -6.128  1.00 81.52           C  
ATOM   1939  CD  GLN B  29      72.790   1.496  -5.866  1.00 81.38           C  
ATOM   1940  OE1 GLN B  29      72.889   1.046  -4.737  1.00 80.65           O  
ATOM   1941  NE2 GLN B  29      72.646   0.724  -6.921  1.00 82.24           N  
ATOM   1942  N   TYR B  30      74.635   6.334  -3.361  1.00 84.13           N  
ATOM   1943  CA  TYR B  30      74.711   7.088  -2.114  1.00 85.61           C  
ATOM   1944  C   TYR B  30      74.392   8.555  -2.356  1.00 87.17           C  
ATOM   1945  O   TYR B  30      73.647   9.163  -1.588  1.00 87.73           O  
ATOM   1946  CB  TYR B  30      76.086   6.950  -1.475  1.00 84.89           C  
ATOM   1947  CG  TYR B  30      76.223   5.764  -0.540  1.00 84.46           C  
ATOM   1948  CD1 TYR B  30      76.735   4.551  -0.990  1.00 83.19           C  
ATOM   1949  CD2 TYR B  30      75.859   5.864   0.797  1.00 83.23           C  
ATOM   1950  CE1 TYR B  30      76.868   3.472  -0.140  1.00 83.41           C  
ATOM   1951  CE2 TYR B  30      75.989   4.791   1.656  1.00 83.32           C  
ATOM   1952  CZ  TYR B  30      76.490   3.597   1.181  1.00 83.78           C  
ATOM   1953  OH  TYR B  30      76.622   2.529   2.034  1.00 83.92           O  
ATOM   1954  N   ARG B  31      74.950   9.113  -3.429  1.00 88.81           N  
ATOM   1955  CA  ARG B  31      74.738  10.516  -3.779  1.00 90.27           C  
ATOM   1956  C   ARG B  31      73.283  10.798  -4.161  1.00 91.04           C  
ATOM   1957  O   ARG B  31      72.712  11.802  -3.733  1.00 91.34           O  
ATOM   1958  CB  ARG B  31      75.668  10.949  -4.913  1.00 90.39           C  
ATOM   1959  CG  ARG B  31      77.148  10.847  -4.601  1.00 91.47           C  
ATOM   1960  CD  ARG B  31      77.941  11.730  -5.520  1.00 94.46           C  
ATOM   1961  NE  ARG B  31      77.953  13.096  -5.000  1.00 99.06           N  
ATOM   1962  CZ  ARG B  31      77.190  14.099  -5.443  1.00100.78           C  
ATOM   1963  NH1 ARG B  31      77.287  15.299  -4.876  1.00101.47           N  
ATOM   1964  NH2 ARG B  31      76.336  13.919  -6.452  1.00101.76           N  
ATOM   1965  N   LYS B  32      72.687   9.909  -4.954  1.00 92.07           N  
ATOM   1966  CA  LYS B  32      71.298  10.066  -5.387  1.00 93.10           C  
ATOM   1967  C   LYS B  32      70.333  10.068  -4.194  1.00 93.93           C  
ATOM   1968  O   LYS B  32      69.307  10.755  -4.224  1.00 94.15           O  
ATOM   1969  CB  LYS B  32      70.909   8.970  -6.385  1.00 93.05           C  
ATOM   1970  CG  LYS B  32      69.815   9.381  -7.368  1.00 93.51           C  
ATOM   1971  CD  LYS B  32      69.240   8.193  -8.124  1.00 93.16           C  
ATOM   1972  CE  LYS B  32      68.118   8.643  -9.061  1.00 93.03           C  
ATOM   1973  NZ  LYS B  32      67.467   7.478  -9.738  1.00 92.30           N  
ATOM   1974  N   GLN B  33      70.674   9.306  -3.151  1.00 94.71           N  
ATOM   1975  CA  GLN B  33      69.884   9.225  -1.914  1.00 95.27           C  
ATOM   1976  C   GLN B  33      70.429  10.181  -0.838  1.00 95.22           C  
ATOM   1977  O   GLN B  33      70.203   9.986   0.361  1.00 95.45           O  
ATOM   1978  CB  GLN B  33      69.827   7.772  -1.410  1.00 95.24           C  
ATOM   1979  CG  GLN B  33      68.957   6.845  -2.283  1.00 96.05           C  
ATOM   1980  CD  GLN B  33      69.384   5.369  -2.228  1.00 96.19           C  
ATOM   1981  OE1 GLN B  33      69.453   4.766  -1.153  1.00 97.45           O  
ATOM   1982  NE2 GLN B  33      69.661   4.784  -3.401  1.00 95.56           N  
ATOM   1983  N   ASN B  34      71.138  11.214  -1.296  1.00 95.09           N  
ATOM   1984  CA  ASN B  34      71.718  12.259  -0.449  1.00 94.93           C  
ATOM   1985  C   ASN B  34      72.363  11.758   0.832  1.00 94.59           C  
ATOM   1986  O   ASN B  34      71.880  12.062   1.927  1.00 95.20           O  
ATOM   1987  CB  ASN B  34      70.669  13.322  -0.109  1.00 95.33           C  
ATOM   1988  CG  ASN B  34      70.135  14.027  -1.337  1.00 96.37           C  
ATOM   1989  OD1 ASN B  34      70.804  14.892  -1.908  1.00 96.96           O  
ATOM   1990  ND2 ASN B  34      68.918  13.663  -1.749  1.00 96.54           N  
ATOM   1991  N   LYS B  35      73.447  10.993   0.693  1.00 93.63           N  
ATOM   1992  CA  LYS B  35      74.231  10.509   1.838  1.00 92.21           C  
ATOM   1993  C   LYS B  35      75.711  10.541   1.466  1.00 91.15           C  
ATOM   1994  O   LYS B  35      76.047  10.517   0.275  1.00 91.38           O  
ATOM   1995  CB  LYS B  35      73.822   9.079   2.224  1.00 92.27           C  
ATOM   1996  CG  LYS B  35      72.331   8.854   2.478  1.00 92.23           C  
ATOM   1997  CD  LYS B  35      72.062   7.484   3.077  1.00 92.71           C  
ATOM   1998  CE  LYS B  35      70.580   7.112   2.956  1.00 94.06           C  
ATOM   1999  NZ  LYS B  35      70.254   6.504   1.623  1.00 93.94           N  
ATOM   2000  N   HIS B  36      76.593  10.605   2.471  1.00 89.61           N  
ATOM   2001  CA  HIS B  36      78.044  10.482   2.245  1.00 87.51           C  
ATOM   2002  C   HIS B  36      78.275   9.141   1.580  1.00 86.30           C  
ATOM   2003  O   HIS B  36      77.837   8.098   2.094  1.00 86.65           O  
ATOM   2004  CB  HIS B  36      78.830  10.557   3.560  1.00 87.37           C  
ATOM   2005  CG  HIS B  36      80.318  10.355   3.416  1.00 87.29           C  
ATOM   2006  ND1 HIS B  36      81.136  11.254   2.762  1.00 86.45           N  
ATOM   2007  CD2 HIS B  36      81.141   9.387   3.902  1.00 87.15           C  
ATOM   2008  CE1 HIS B  36      82.390  10.833   2.824  1.00 86.89           C  
ATOM   2009  NE2 HIS B  36      82.424   9.708   3.518  1.00 85.65           N  
ATOM   2010  N   SER B  37      78.907   9.186   0.414  1.00 84.13           N  
ATOM   2011  CA  SER B  37      79.380   7.991  -0.236  1.00 82.24           C  
ATOM   2012  C   SER B  37      80.667   7.588   0.440  1.00 81.21           C  
ATOM   2013  O   SER B  37      81.601   8.387   0.483  1.00 81.77           O  
ATOM   2014  CB  SER B  37      79.650   8.244  -1.711  1.00 81.74           C  
ATOM   2015  OG  SER B  37      80.078   7.053  -2.334  1.00 81.22           O  
ATOM   2016  N   PRO B  38      80.726   6.353   0.969  1.00 79.56           N  
ATOM   2017  CA  PRO B  38      81.978   5.788   1.464  1.00 78.56           C  
ATOM   2018  C   PRO B  38      83.026   5.705   0.340  1.00 77.98           C  
ATOM   2019  O   PRO B  38      84.226   5.893   0.603  1.00 79.30           O  
ATOM   2020  CB  PRO B  38      81.574   4.380   1.940  1.00 78.37           C  
ATOM   2021  CG  PRO B  38      80.299   4.085   1.228  1.00 78.60           C  
ATOM   2022  CD  PRO B  38      79.605   5.409   1.111  1.00 79.33           C  
ATOM   2023  N   ILE B  39      82.568   5.471  -0.895  1.00 76.02           N  
ATOM   2024  CA  ILE B  39      83.421   5.369  -2.087  1.00 73.11           C  
ATOM   2025  C   ILE B  39      83.596   6.705  -2.787  1.00 72.92           C  
ATOM   2026  O   ILE B  39      82.621   7.393  -3.052  1.00 72.72           O  
ATOM   2027  CB  ILE B  39      82.858   4.329  -3.106  1.00 72.52           C  
ATOM   2028  CG1 ILE B  39      82.830   2.959  -2.446  1.00 70.98           C  
ATOM   2029  CG2 ILE B  39      83.657   4.350  -4.451  1.00 68.48           C  
ATOM   2030  CD1 ILE B  39      82.325   1.831  -3.319  1.00 71.23           C  
ATOM   2031  N   GLU B  40      84.846   7.048  -3.097  1.00 72.70           N  
ATOM   2032  CA  GLU B  40      85.167   8.267  -3.799  1.00 72.27           C  
ATOM   2033  C   GLU B  40      85.364   7.949  -5.262  1.00 71.98           C  
ATOM   2034  O   GLU B  40      84.719   8.540  -6.132  1.00 71.86           O  
ATOM   2035  CB  GLU B  40      86.454   8.889  -3.260  1.00 73.06           C  
ATOM   2036  CG  GLU B  40      86.313   9.766  -2.018  1.00 75.02           C  
ATOM   2037  CD  GLU B  40      85.335  10.932  -2.190  1.00 76.68           C  
ATOM   2038  OE1 GLU B  40      84.449  11.069  -1.308  1.00 76.83           O  
ATOM   2039  OE2 GLU B  40      85.441  11.679  -3.194  1.00 74.54           O  
ATOM   2040  N   PHE B  41      86.277   7.032  -5.550  1.00 71.01           N  
ATOM   2041  CA  PHE B  41      86.433   6.582  -6.918  1.00 71.05           C  
ATOM   2042  C   PHE B  41      87.052   5.191  -6.961  1.00 70.03           C  
ATOM   2043  O   PHE B  41      87.536   4.675  -5.962  1.00 70.58           O  
ATOM   2044  CB  PHE B  41      87.175   7.624  -7.799  1.00 71.17           C  
ATOM   2045  CG  PHE B  41      88.576   7.884  -7.372  1.00 72.92           C  
ATOM   2046  CD1 PHE B  41      88.846   8.748  -6.291  1.00 75.40           C  
ATOM   2047  CD2 PHE B  41      89.638   7.264  -8.019  1.00 73.64           C  
ATOM   2048  CE1 PHE B  41      90.157   8.990  -5.876  1.00 74.85           C  
ATOM   2049  CE2 PHE B  41      90.967   7.494  -7.602  1.00 75.68           C  
ATOM   2050  CZ  PHE B  41      91.223   8.348  -6.522  1.00 73.74           C  
ATOM   2051  N   VAL B  42      87.007   4.591  -8.137  1.00 69.42           N  
ATOM   2052  CA  VAL B  42      87.371   3.204  -8.327  1.00 68.29           C  
ATOM   2053  C   VAL B  42      88.269   3.110  -9.539  1.00 68.79           C  
ATOM   2054  O   VAL B  42      88.044   3.798 -10.534  1.00 68.97           O  
ATOM   2055  CB  VAL B  42      86.106   2.361  -8.622  1.00 67.89           C  
ATOM   2056  CG1 VAL B  42      86.458   0.884  -8.743  1.00 65.78           C  
ATOM   2057  CG2 VAL B  42      85.035   2.613  -7.566  1.00 66.04           C  
ATOM   2058  N   THR B  43      89.274   2.247  -9.459  1.00 69.08           N  
ATOM   2059  CA  THR B  43      90.139   1.954 -10.587  1.00 69.40           C  
ATOM   2060  C   THR B  43      90.416   0.465 -10.576  1.00 69.47           C  
ATOM   2061  O   THR B  43      90.152  -0.196  -9.597  1.00 70.42           O  
ATOM   2062  CB  THR B  43      91.498   2.720 -10.495  1.00 69.63           C  
ATOM   2063  OG1 THR B  43      92.278   2.158  -9.436  1.00 70.28           O  
ATOM   2064  CG2 THR B  43      91.291   4.211 -10.237  1.00 67.34           C  
ATOM   2065  N   GLY B  44      90.980  -0.055 -11.651  1.00 70.33           N  
ATOM   2066  CA  GLY B  44      91.325  -1.457 -11.751  1.00 71.27           C  
ATOM   2067  C   GLY B  44      92.118  -1.738 -13.003  1.00 72.60           C  
ATOM   2068  O   GLY B  44      92.146  -0.914 -13.908  1.00 72.66           O  
ATOM   2069  N   ARG B  45      92.774  -2.894 -13.043  1.00 73.73           N  
ATOM   2070  CA  ARG B  45      93.554  -3.327 -14.193  1.00 74.99           C  
ATOM   2071  C   ARG B  45      93.709  -4.843 -14.118  1.00 75.39           C  
ATOM   2072  O   ARG B  45      93.538  -5.426 -13.049  1.00 74.93           O  
ATOM   2073  CB  ARG B  45      94.948  -2.642 -14.216  1.00 75.20           C  
ATOM   2074  CG  ARG B  45      96.106  -3.406 -13.495  1.00 77.67           C  
ATOM   2075  CD  ARG B  45      95.983  -3.359 -11.963  1.00 82.57           C  
ATOM   2076  NE  ARG B  45      96.675  -4.429 -11.224  1.00 85.86           N  
ATOM   2077  CZ  ARG B  45      96.155  -5.631 -10.965  1.00 88.40           C  
ATOM   2078  NH1 ARG B  45      94.957  -5.943 -11.427  1.00 90.36           N  
ATOM   2079  NH2 ARG B  45      96.831  -6.544 -10.266  1.00 89.02           N  
ATOM   2080  N   VAL B  46      94.057  -5.467 -15.243  1.00 76.49           N  
ATOM   2081  CA  VAL B  46      94.529  -6.851 -15.260  1.00 77.77           C  
ATOM   2082  C   VAL B  46      96.044  -6.874 -15.045  1.00 78.67           C  
ATOM   2083  O   VAL B  46      96.744  -6.089 -15.681  1.00 78.87           O  
ATOM   2084  CB  VAL B  46      94.214  -7.514 -16.606  1.00 77.44           C  
ATOM   2085  CG1 VAL B  46      94.279  -9.015 -16.481  1.00 77.45           C  
ATOM   2086  CG2 VAL B  46      92.847  -7.098 -17.070  1.00 78.33           C  
ATOM   2087  N   LYS B  47      96.563  -7.743 -14.167  1.00 79.96           N  
ATOM   2088  CA  LYS B  47      98.027  -7.863 -14.026  1.00 81.60           C  
ATOM   2089  C   LYS B  47      98.663  -8.042 -15.402  1.00 82.64           C  
ATOM   2090  O   LYS B  47      98.256  -8.937 -16.149  1.00 82.70           O  
ATOM   2091  CB  LYS B  47      98.446  -9.043 -13.152  1.00 81.70           C  
ATOM   2092  CG  LYS B  47      98.454  -8.774 -11.677  1.00 83.49           C  
ATOM   2093  CD  LYS B  47      99.504  -9.600 -10.933  1.00 85.24           C  
ATOM   2094  CE  LYS B  47     100.749  -8.756 -10.620  1.00 88.65           C  
ATOM   2095  NZ  LYS B  47     100.487  -7.317 -10.213  1.00 87.93           N  
ATOM   2096  N   PRO B  48      99.648  -7.185 -15.754  1.00 83.93           N  
ATOM   2097  CA  PRO B  48     100.391  -7.357 -17.020  1.00 84.64           C  
ATOM   2098  C   PRO B  48     101.082  -8.721 -17.101  1.00 85.44           C  
ATOM   2099  O   PRO B  48     101.614  -9.208 -16.099  1.00 85.32           O  
ATOM   2100  CB  PRO B  48     101.418  -6.225 -16.981  1.00 84.51           C  
ATOM   2101  CG  PRO B  48     100.816  -5.199 -16.075  1.00 84.12           C  
ATOM   2102  CD  PRO B  48     100.112  -5.997 -15.010  1.00 83.95           C  
ATOM   2103  N   ILE B  49     101.043  -9.328 -18.285  1.00 86.77           N  
ATOM   2104  CA  ILE B  49     101.577 -10.678 -18.531  1.00 88.22           C  
ATOM   2105  C   ILE B  49     102.891 -10.957 -17.780  1.00 89.43           C  
ATOM   2106  O   ILE B  49     103.023 -11.971 -17.086  1.00 89.19           O  
ATOM   2107  CB  ILE B  49     101.825 -10.914 -20.043  1.00 88.11           C  
ATOM   2108  CG1 ILE B  49     100.984  -9.962 -20.921  1.00 88.46           C  
ATOM   2109  CG2 ILE B  49     101.673 -12.387 -20.387  1.00 87.72           C  
ATOM   2110  CD1 ILE B  49      99.534 -10.347 -21.128  1.00 88.10           C  
ATOM   2111  N   GLU B  50     103.845 -10.034 -17.938  1.00 91.12           N  
ATOM   2112  CA  GLU B  50     105.162 -10.074 -17.289  1.00 92.72           C  
ATOM   2113  C   GLU B  50     105.136 -10.315 -15.760  1.00 93.52           C  
ATOM   2114  O   GLU B  50     105.842 -11.195 -15.252  1.00 93.40           O  
ATOM   2115  CB  GLU B  50     105.953  -8.800 -17.640  1.00 92.87           C  
ATOM   2116  CG  GLU B  50     105.113  -7.505 -17.688  1.00 94.09           C  
ATOM   2117  CD  GLU B  50     105.816  -6.304 -17.033  1.00 96.16           C  
ATOM   2118  OE1 GLU B  50     105.130  -5.437 -16.427  1.00 95.85           O  
ATOM   2119  OE2 GLU B  50     107.063  -6.229 -17.117  1.00 97.39           O  
ATOM   2120  N   SER B  51     104.307  -9.547 -15.048  1.00 94.94           N  
ATOM   2121  CA  SER B  51     104.157  -9.659 -13.581  1.00 96.31           C  
ATOM   2122  C   SER B  51     103.577 -11.001 -13.123  1.00 97.20           C  
ATOM   2123  O   SER B  51     103.941 -11.516 -12.061  1.00 97.20           O  
ATOM   2124  CB  SER B  51     103.294  -8.519 -13.025  1.00 96.26           C  
ATOM   2125  OG  SER B  51     103.527  -7.300 -13.706  1.00 96.15           O  
ATOM   2126  N   ILE B  52     102.665 -11.549 -13.919  1.00 98.51           N  
ATOM   2127  CA  ILE B  52     102.083 -12.852 -13.634  1.00 99.98           C  
ATOM   2128  C   ILE B  52     103.159 -13.939 -13.695  1.00101.30           C  
ATOM   2129  O   ILE B  52     103.290 -14.737 -12.766  1.00101.45           O  
ATOM   2130  CB  ILE B  52     100.912 -13.202 -14.610  1.00 99.93           C  
ATOM   2131  CG1 ILE B  52      99.775 -12.181 -14.497  1.00 99.78           C  
ATOM   2132  CG2 ILE B  52     100.389 -14.623 -14.367  1.00 99.55           C  
ATOM   2133  CD1 ILE B  52      98.771 -12.232 -15.644  1.00 99.71           C  
ATOM   2134  N   LYS B  53     103.935 -13.947 -14.777  1.00103.02           N  
ATOM   2135  CA  LYS B  53     104.807 -15.084 -15.101  1.00104.69           C  
ATOM   2136  C   LYS B  53     105.749 -15.495 -13.965  1.00106.15           C  
ATOM   2137  O   LYS B  53     105.814 -16.677 -13.607  1.00106.18           O  
ATOM   2138  CB  LYS B  53     105.582 -14.846 -16.405  1.00104.45           C  
ATOM   2139  CG  LYS B  53     104.703 -14.820 -17.648  1.00103.84           C  
ATOM   2140  CD  LYS B  53     105.493 -15.045 -18.923  1.00103.38           C  
ATOM   2141  CE  LYS B  53     105.657 -16.531 -19.214  1.00103.55           C  
ATOM   2142  NZ  LYS B  53     106.026 -16.790 -20.632  1.00103.08           N  
ATOM   2143  N   GLU B  54     106.455 -14.521 -13.393  1.00107.93           N  
ATOM   2144  CA  GLU B  54     107.408 -14.799 -12.319  1.00109.80           C  
ATOM   2145  C   GLU B  54     106.699 -15.462 -11.142  1.00111.01           C  
ATOM   2146  O   GLU B  54     107.148 -16.488 -10.626  1.00111.09           O  
ATOM   2147  CB  GLU B  54     108.084 -13.515 -11.822  1.00109.83           C  
ATOM   2148  CG  GLU B  54     107.935 -12.300 -12.724  1.00110.08           C  
ATOM   2149  CD  GLU B  54     107.707 -11.023 -11.930  1.00110.25           C  
ATOM   2150  OE1 GLU B  54     108.008  -9.933 -12.460  1.00109.90           O  
ATOM   2151  OE2 GLU B  54     107.224 -11.107 -10.775  1.00110.15           O  
ATOM   2152  N   LYS B  55     105.569 -14.876 -10.755  1.00112.60           N  
ATOM   2153  CA  LYS B  55     104.927 -15.168  -9.484  1.00114.32           C  
ATOM   2154  C   LYS B  55     104.040 -16.419  -9.475  1.00115.62           C  
ATOM   2155  O   LYS B  55     102.921 -16.375  -8.955  1.00115.88           O  
ATOM   2156  CB  LYS B  55     104.122 -13.946  -9.016  1.00114.29           C  
ATOM   2157  CG  LYS B  55     104.920 -12.650  -8.930  1.00114.73           C  
ATOM   2158  CD  LYS B  55     104.402 -11.750  -7.810  1.00115.60           C  
ATOM   2159  CE  LYS B  55     104.922 -12.206  -6.434  1.00115.47           C  
ATOM   2160  NZ  LYS B  55     104.288 -11.469  -5.299  1.00114.45           N  
HETATM 2161  N   MSE B  56     104.525 -17.529 -10.033  1.00117.04           N  
HETATM 2162  CA  MSE B  56     103.765 -18.793  -9.975  1.00119.00           C  
HETATM 2163  C   MSE B  56     104.598 -20.067  -9.774  1.00118.41           C  
HETATM 2164  O   MSE B  56     105.614 -20.272 -10.443  1.00118.52           O  
HETATM 2165  CB  MSE B  56     102.782 -18.947 -11.159  1.00118.79           C  
HETATM 2166  CG  MSE B  56     103.136 -18.215 -12.467  1.00120.52           C  
HETATM 2167 SE   MSE B  56     101.955 -18.673 -14.027  1.00123.49          SE  
HETATM 2168  CE  MSE B  56     100.117 -18.259 -13.258  1.00123.19           C  
ATOM   2169  N   ALA B  57     104.145 -20.909  -8.842  1.00118.35           N  
ATOM   2170  CA  ALA B  57     104.810 -22.174  -8.520  1.00118.17           C  
ATOM   2171  C   ALA B  57     104.119 -23.364  -9.181  1.00118.09           C  
ATOM   2172  O   ALA B  57     103.118 -23.209  -9.885  1.00117.98           O  
ATOM   2173  CB  ALA B  57     104.874 -22.371  -7.011  1.00118.08           C  
ATOM   2174  N   HIS B  68      92.426 -20.836  -8.576  1.00101.73           N  
ATOM   2175  CA  HIS B  68      93.808 -20.631  -9.028  1.00101.78           C  
ATOM   2176  C   HIS B  68      94.816 -20.378  -7.890  1.00101.12           C  
ATOM   2177  O   HIS B  68      95.976 -20.816  -7.968  1.00101.21           O  
ATOM   2178  CB  HIS B  68      93.887 -19.483 -10.063  1.00102.07           C  
ATOM   2179  CG  HIS B  68      95.133 -19.510 -10.898  1.00103.30           C  
ATOM   2180  ND1 HIS B  68      95.193 -20.131 -12.129  1.00104.70           N  
ATOM   2181  CD2 HIS B  68      96.375 -19.022 -10.665  1.00104.51           C  
ATOM   2182  CE1 HIS B  68      96.415 -20.014 -12.622  1.00105.38           C  
ATOM   2183  NE2 HIS B  68      97.151 -19.343 -11.753  1.00105.22           N  
ATOM   2184  N   ASP B  69      94.366 -19.684  -6.843  1.00100.04           N  
ATOM   2185  CA  ASP B  69      95.257 -19.075  -5.836  1.00 99.25           C  
ATOM   2186  C   ASP B  69      96.463 -18.274  -6.423  1.00 97.90           C  
ATOM   2187  O   ASP B  69      97.585 -18.305  -5.896  1.00 97.75           O  
ATOM   2188  CB  ASP B  69      95.671 -20.065  -4.723  1.00 99.69           C  
ATOM   2189  CG  ASP B  69      96.348 -19.365  -3.512  1.00101.12           C  
ATOM   2190  OD1 ASP B  69      96.294 -18.109  -3.396  1.00100.96           O  
ATOM   2191  OD2 ASP B  69      96.946 -20.081  -2.668  1.00102.45           O  
ATOM   2192  N   LEU B  70      96.209 -17.588  -7.539  1.00 96.21           N  
ATOM   2193  CA  LEU B  70      96.880 -16.314  -7.831  1.00 94.18           C  
ATOM   2194  C   LEU B  70      95.757 -15.272  -7.894  1.00 92.37           C  
ATOM   2195  O   LEU B  70      94.978 -15.174  -8.860  1.00 92.16           O  
ATOM   2196  CB  LEU B  70      97.770 -16.342  -9.083  1.00 94.47           C  
ATOM   2197  CG  LEU B  70      98.934 -15.330  -9.098  1.00 94.98           C  
ATOM   2198  CD1 LEU B  70      98.661 -14.169 -10.039  1.00 96.03           C  
ATOM   2199  CD2 LEU B  70      99.348 -14.804  -7.695  1.00 95.33           C  
ATOM   2200  N   GLN B  71      95.696 -14.517  -6.810  1.00 89.72           N  
ATOM   2201  CA  GLN B  71      94.478 -13.928  -6.335  1.00 87.08           C  
ATOM   2202  C   GLN B  71      94.121 -12.622  -7.047  1.00 85.12           C  
ATOM   2203  O   GLN B  71      92.963 -12.220  -7.054  1.00 84.34           O  
ATOM   2204  CB  GLN B  71      94.630 -13.720  -4.832  1.00 87.13           C  
ATOM   2205  CG  GLN B  71      93.503 -14.328  -4.019  1.00 89.12           C  
ATOM   2206  CD  GLN B  71      93.850 -15.614  -3.216  1.00 90.91           C  
ATOM   2207  OE1 GLN B  71      93.665 -15.656  -1.991  1.00 91.00           O  
ATOM   2208  NE2 GLN B  71      94.293 -16.668  -3.911  1.00 91.11           N  
ATOM   2209  N   ASP B  72      95.107 -11.991  -7.682  1.00 83.00           N  
ATOM   2210  CA  ASP B  72      94.990 -10.584  -8.091  1.00 80.88           C  
ATOM   2211  C   ASP B  72      95.174 -10.308  -9.581  1.00 78.78           C  
ATOM   2212  O   ASP B  72      95.451  -9.170  -9.967  1.00 79.14           O  
ATOM   2213  CB  ASP B  72      95.946  -9.702  -7.262  1.00 81.29           C  
ATOM   2214  CG  ASP B  72      97.427  -9.985  -7.556  1.00 83.41           C  
ATOM   2215  OD1 ASP B  72      97.855 -11.164  -7.472  1.00 85.09           O  
ATOM   2216  OD2 ASP B  72      98.170  -9.020  -7.878  1.00 86.78           O  
ATOM   2217  N   ILE B  73      95.012 -11.331 -10.419  1.00 76.35           N  
ATOM   2218  CA  ILE B  73      95.033 -11.141 -11.877  1.00 73.79           C  
ATOM   2219  C   ILE B  73      94.035 -10.044 -12.272  1.00 72.50           C  
ATOM   2220  O   ILE B  73      94.380  -9.125 -13.015  1.00 72.68           O  
ATOM   2221  CB  ILE B  73      94.740 -12.435 -12.647  1.00 73.49           C  
ATOM   2222  CG1 ILE B  73      95.773 -13.508 -12.322  1.00 72.77           C  
ATOM   2223  CG2 ILE B  73      94.777 -12.168 -14.119  1.00 73.85           C  
ATOM   2224  CD1 ILE B  73      95.434 -14.894 -12.883  1.00 73.68           C  
ATOM   2225  N   ALA B  74      92.810 -10.139 -11.756  1.00 70.75           N  
ATOM   2226  CA  ALA B  74      91.865  -9.035 -11.793  1.00 69.16           C  
ATOM   2227  C   ALA B  74      92.001  -8.256 -10.482  1.00 68.19           C  
ATOM   2228  O   ALA B  74      91.811  -8.819  -9.417  1.00 68.03           O  
ATOM   2229  CB  ALA B  74      90.436  -9.547 -11.986  1.00 68.48           C  
ATOM   2230  N   GLY B  75      92.345  -6.969 -10.570  1.00 66.99           N  
ATOM   2231  CA  GLY B  75      92.531  -6.132  -9.384  1.00 66.23           C  
ATOM   2232  C   GLY B  75      91.681  -4.877  -9.451  1.00 66.00           C  
ATOM   2233  O   GLY B  75      91.614  -4.237 -10.478  1.00 66.15           O  
ATOM   2234  N   LEU B  76      91.021  -4.535  -8.360  1.00 65.58           N  
ATOM   2235  CA  LEU B  76      90.211  -3.328  -8.288  1.00 66.49           C  
ATOM   2236  C   LEU B  76      90.653  -2.539  -7.078  1.00 66.86           C  
ATOM   2237  O   LEU B  76      91.058  -3.110  -6.060  1.00 67.42           O  
ATOM   2238  CB  LEU B  76      88.705  -3.656  -8.211  1.00 66.59           C  
ATOM   2239  CG  LEU B  76      88.326  -4.040  -9.649  1.00 68.12           C  
ATOM   2240  CD1 LEU B  76      87.839  -5.465  -9.751  1.00 65.25           C  
ATOM   2241  CD2 LEU B  76      87.408  -3.018 -10.343  1.00 67.29           C  
ATOM   2242  N   ARG B  77      90.583  -1.225  -7.198  1.00 66.84           N  
ATOM   2243  CA  ARG B  77      91.056  -0.343  -6.177  1.00 66.90           C  
ATOM   2244  C   ARG B  77      89.909   0.568  -5.849  1.00 66.29           C  
ATOM   2245  O   ARG B  77      89.427   1.272  -6.725  1.00 66.49           O  
ATOM   2246  CB  ARG B  77      92.183   0.464  -6.791  1.00 67.44           C  
ATOM   2247  CG  ARG B  77      93.461   0.386  -6.055  1.00 70.49           C  
ATOM   2248  CD  ARG B  77      94.116  -0.930  -6.290  1.00 74.93           C  
ATOM   2249  NE  ARG B  77      94.411  -1.126  -7.697  1.00 80.52           N  
ATOM   2250  CZ  ARG B  77      94.837  -2.272  -8.234  1.00 83.42           C  
ATOM   2251  NH1 ARG B  77      95.078  -2.306  -9.544  1.00 84.07           N  
ATOM   2252  NH2 ARG B  77      95.020  -3.376  -7.485  1.00 81.75           N  
ATOM   2253  N   VAL B  78      89.445   0.550  -4.610  1.00 66.16           N  
ATOM   2254  CA  VAL B  78      88.313   1.394  -4.204  1.00 66.72           C  
ATOM   2255  C   VAL B  78      88.855   2.451  -3.255  1.00 67.28           C  
ATOM   2256  O   VAL B  78      89.371   2.092  -2.195  1.00 67.92           O  
ATOM   2257  CB  VAL B  78      87.179   0.540  -3.490  1.00 66.47           C  
ATOM   2258  CG1 VAL B  78      86.047   1.400  -2.982  1.00 65.55           C  
ATOM   2259  CG2 VAL B  78      86.628  -0.514  -4.411  1.00 66.44           C  
HETATM 2260  N   MSE B  79      88.783   3.732  -3.631  1.00 67.80           N  
HETATM 2261  CA  MSE B  79      89.274   4.808  -2.760  1.00 68.06           C  
HETATM 2262  C   MSE B  79      88.178   5.440  -1.926  1.00 67.17           C  
HETATM 2263  O   MSE B  79      87.119   5.811  -2.453  1.00 67.18           O  
HETATM 2264  CB  MSE B  79      89.995   5.910  -3.560  1.00 69.85           C  
HETATM 2265  CG  MSE B  79      91.464   5.672  -3.736  1.00 73.26           C  
HETATM 2266 SE   MSE B  79      91.881   3.878  -4.581  1.00 92.92          SE  
HETATM 2267  CE  MSE B  79      91.258   4.235  -6.527  1.00 80.33           C  
ATOM   2268  N   VAL B  80      88.467   5.608  -0.638  1.00 65.37           N  
ATOM   2269  CA  VAL B  80      87.547   6.187   0.330  1.00 63.92           C  
ATOM   2270  C   VAL B  80      88.237   7.370   1.021  1.00 64.23           C  
ATOM   2271  O   VAL B  80      89.465   7.408   1.098  1.00 65.07           O  
ATOM   2272  CB  VAL B  80      87.175   5.107   1.407  1.00 64.10           C  
ATOM   2273  CG1 VAL B  80      86.507   3.885   0.763  1.00 62.52           C  
ATOM   2274  CG2 VAL B  80      88.419   4.660   2.212  1.00 61.12           C  
ATOM   2275  N   GLN B  81      87.474   8.308   1.563  1.00 64.34           N  
ATOM   2276  CA  GLN B  81      88.038   9.486   2.236  1.00 64.94           C  
ATOM   2277  C   GLN B  81      88.709   9.199   3.581  1.00 65.69           C  
ATOM   2278  O   GLN B  81      89.781   9.781   3.878  1.00 66.94           O  
ATOM   2279  CB  GLN B  81      86.966  10.535   2.477  1.00 64.41           C  
ATOM   2280  CG  GLN B  81      86.434  11.214   1.240  1.00 65.49           C  
ATOM   2281  CD  GLN B  81      85.458  12.343   1.573  1.00 66.22           C  
ATOM   2282  OE1 GLN B  81      85.624  13.086   2.545  1.00 70.42           O  
ATOM   2283  NE2 GLN B  81      84.435  12.470   0.765  1.00 69.25           N  
ATOM   2284  N   PHE B  82      88.076   8.351   4.393  1.00 65.28           N  
ATOM   2285  CA  PHE B  82      88.492   8.099   5.753  1.00 65.49           C  
ATOM   2286  C   PHE B  82      88.688   6.610   5.997  1.00 67.05           C  
ATOM   2287  O   PHE B  82      88.069   5.768   5.336  1.00 66.99           O  
ATOM   2288  CB  PHE B  82      87.440   8.608   6.732  1.00 64.95           C  
ATOM   2289  CG  PHE B  82      87.097  10.063   6.564  1.00 64.37           C  
ATOM   2290  CD1 PHE B  82      87.906  11.046   7.112  1.00 62.43           C  
ATOM   2291  CD2 PHE B  82      85.950  10.445   5.868  1.00 62.31           C  
ATOM   2292  CE1 PHE B  82      87.590  12.409   6.943  1.00 61.41           C  
ATOM   2293  CE2 PHE B  82      85.628  11.792   5.707  1.00 62.52           C  
ATOM   2294  CZ  PHE B  82      86.458  12.774   6.250  1.00 61.24           C  
ATOM   2295  N   VAL B  83      89.526   6.281   6.973  1.00 68.22           N  
ATOM   2296  CA  VAL B  83      89.737   4.893   7.379  1.00 68.83           C  
ATOM   2297  C   VAL B  83      88.451   4.216   7.779  1.00 69.98           C  
ATOM   2298  O   VAL B  83      88.244   3.074   7.407  1.00 71.00           O  
ATOM   2299  CB  VAL B  83      90.777   4.780   8.521  1.00 68.76           C  
ATOM   2300  CG1 VAL B  83      90.891   3.336   9.014  1.00 67.97           C  
ATOM   2301  CG2 VAL B  83      92.129   5.292   8.045  1.00 68.09           C  
ATOM   2302  N   ASP B  84      87.589   4.911   8.531  1.00 71.08           N  
ATOM   2303  CA  ASP B  84      86.291   4.374   8.965  1.00 71.71           C  
ATOM   2304  C   ASP B  84      85.374   3.965   7.817  1.00 71.97           C  
ATOM   2305  O   ASP B  84      84.486   3.141   8.000  1.00 72.14           O  
ATOM   2306  CB  ASP B  84      85.554   5.394   9.827  1.00 72.14           C  
ATOM   2307  CG  ASP B  84      86.112   5.483  11.246  1.00 76.09           C  
ATOM   2308  OD1 ASP B  84      87.013   4.683  11.604  1.00 79.45           O  
ATOM   2309  OD2 ASP B  84      85.630   6.347  12.024  1.00 79.13           O  
ATOM   2310  N   ASP B  85      85.552   4.567   6.643  1.00 72.11           N  
ATOM   2311  CA  ASP B  85      84.768   4.150   5.476  1.00 72.56           C  
ATOM   2312  C   ASP B  85      85.146   2.758   4.992  1.00 72.50           C  
ATOM   2313  O   ASP B  85      84.400   2.162   4.213  1.00 72.61           O  
ATOM   2314  CB  ASP B  85      84.926   5.099   4.288  1.00 71.96           C  
ATOM   2315  CG  ASP B  85      84.456   6.505   4.571  1.00 73.80           C  
ATOM   2316  OD1 ASP B  85      83.511   6.706   5.383  1.00 73.20           O  
ATOM   2317  OD2 ASP B  85      85.059   7.426   3.938  1.00 77.06           O  
ATOM   2318  N   VAL B  86      86.308   2.251   5.401  1.00 72.24           N  
ATOM   2319  CA  VAL B  86      86.773   0.991   4.819  1.00 72.14           C  
ATOM   2320  C   VAL B  86      85.822  -0.135   5.210  1.00 73.02           C  
ATOM   2321  O   VAL B  86      85.453  -0.948   4.356  1.00 74.18           O  
ATOM   2322  CB  VAL B  86      88.250   0.655   5.152  1.00 71.47           C  
ATOM   2323  CG1 VAL B  86      88.575  -0.770   4.736  1.00 69.89           C  
ATOM   2324  CG2 VAL B  86      89.220   1.670   4.481  1.00 70.96           C  
ATOM   2325  N   LYS B  87      85.388  -0.154   6.473  1.00 73.04           N  
ATOM   2326  CA  LYS B  87      84.517  -1.202   6.943  1.00 73.76           C  
ATOM   2327  C   LYS B  87      83.112  -1.068   6.373  1.00 72.52           C  
ATOM   2328  O   LYS B  87      82.408  -2.054   6.228  1.00 72.04           O  
ATOM   2329  CB  LYS B  87      84.512  -1.293   8.490  1.00 75.58           C  
ATOM   2330  CG  LYS B  87      83.518  -0.359   9.244  1.00 79.27           C  
ATOM   2331  CD  LYS B  87      84.253   0.797  10.031  1.00 84.21           C  
ATOM   2332  CE  LYS B  87      83.302   1.652  10.937  1.00 82.22           C  
ATOM   2333  NZ  LYS B  87      82.733   2.799  10.141  1.00 85.10           N  
ATOM   2334  N   GLU B  88      82.707   0.162   6.067  1.00 71.55           N  
ATOM   2335  CA  GLU B  88      81.407   0.422   5.464  1.00 71.62           C  
ATOM   2336  C   GLU B  88      81.345  -0.252   4.075  1.00 69.35           C  
ATOM   2337  O   GLU B  88      80.350  -0.910   3.739  1.00 69.17           O  
ATOM   2338  CB  GLU B  88      81.167   1.929   5.412  1.00 71.49           C  
ATOM   2339  CG  GLU B  88      79.700   2.409   5.423  1.00 75.22           C  
ATOM   2340  CD  GLU B  88      79.575   3.982   5.395  1.00 76.53           C  
ATOM   2341  OE1 GLU B  88      78.538   4.485   4.871  1.00 82.15           O  
ATOM   2342  OE2 GLU B  88      80.510   4.707   5.881  1.00 79.78           O  
ATOM   2343  N   VAL B  89      82.450  -0.161   3.329  1.00 66.77           N  
ATOM   2344  CA  VAL B  89      82.597  -0.789   2.027  1.00 64.84           C  
ATOM   2345  C   VAL B  89      82.712  -2.317   2.103  1.00 65.31           C  
ATOM   2346  O   VAL B  89      82.174  -3.036   1.245  1.00 65.45           O  
ATOM   2347  CB  VAL B  89      83.823  -0.201   1.248  1.00 64.71           C  
ATOM   2348  CG1 VAL B  89      83.990  -0.884  -0.105  1.00 64.00           C  
ATOM   2349  CG2 VAL B  89      83.652   1.284   1.053  1.00 60.74           C  
ATOM   2350  N   VAL B  90      83.429  -2.826   3.106  1.00 64.29           N  
ATOM   2351  CA  VAL B  90      83.561  -4.255   3.262  1.00 63.11           C  
ATOM   2352  C   VAL B  90      82.168  -4.871   3.522  1.00 63.98           C  
ATOM   2353  O   VAL B  90      81.817  -5.916   2.961  1.00 63.27           O  
ATOM   2354  CB  VAL B  90      84.598  -4.585   4.370  1.00 63.64           C  
ATOM   2355  CG1 VAL B  90      84.615  -6.074   4.719  1.00 59.65           C  
ATOM   2356  CG2 VAL B  90      86.014  -4.079   3.938  1.00 59.75           C  
ATOM   2357  N   ASP B  91      81.354  -4.188   4.317  1.00 64.51           N  
ATOM   2358  CA  ASP B  91      79.982  -4.657   4.601  1.00 65.59           C  
ATOM   2359  C   ASP B  91      79.076  -4.694   3.407  1.00 64.90           C  
ATOM   2360  O   ASP B  91      78.285  -5.617   3.258  1.00 66.30           O  
ATOM   2361  CB  ASP B  91      79.325  -3.802   5.661  1.00 65.91           C  
ATOM   2362  CG  ASP B  91      79.978  -3.969   6.998  1.00 71.01           C  
ATOM   2363  OD1 ASP B  91      80.606  -5.037   7.266  1.00 73.60           O  
ATOM   2364  OD2 ASP B  91      79.869  -3.003   7.788  1.00 78.65           O  
ATOM   2365  N   ILE B  92      79.174  -3.675   2.570  1.00 64.48           N  
ATOM   2366  CA  ILE B  92      78.448  -3.621   1.317  1.00 63.47           C  
ATOM   2367  C   ILE B  92      78.830  -4.826   0.440  1.00 62.67           C  
ATOM   2368  O   ILE B  92      77.951  -5.467  -0.144  1.00 62.76           O  
ATOM   2369  CB  ILE B  92      78.718  -2.248   0.595  1.00 64.01           C  
ATOM   2370  CG1 ILE B  92      77.947  -1.111   1.280  1.00 62.91           C  
ATOM   2371  CG2 ILE B  92      78.331  -2.295  -0.889  1.00 64.21           C  
ATOM   2372  CD1 ILE B  92      78.595   0.260   1.039  1.00 66.42           C  
ATOM   2373  N   LEU B  93      80.127  -5.136   0.368  1.00 61.95           N  
ATOM   2374  CA  LEU B  93      80.620  -6.264  -0.417  1.00 61.85           C  
ATOM   2375  C   LEU B  93      80.037  -7.586   0.105  1.00 62.80           C  
ATOM   2376  O   LEU B  93      79.662  -8.451  -0.697  1.00 63.88           O  
ATOM   2377  CB  LEU B  93      82.148  -6.310  -0.424  1.00 61.36           C  
ATOM   2378  CG  LEU B  93      82.904  -5.145  -1.100  1.00 62.03           C  
ATOM   2379  CD1 LEU B  93      84.431  -5.307  -0.947  1.00 61.62           C  
ATOM   2380  CD2 LEU B  93      82.536  -4.969  -2.585  1.00 61.56           C  
ATOM   2381  N   HIS B  94      79.921  -7.717   1.433  1.00 62.02           N  
ATOM   2382  CA  HIS B  94      79.280  -8.870   2.055  1.00 62.05           C  
ATOM   2383  C   HIS B  94      77.827  -9.019   1.642  1.00 61.79           C  
ATOM   2384  O   HIS B  94      77.376 -10.129   1.428  1.00 62.21           O  
ATOM   2385  CB  HIS B  94      79.390  -8.827   3.592  1.00 61.53           C  
ATOM   2386  CG  HIS B  94      80.721  -9.258   4.123  1.00 61.70           C  
ATOM   2387  ND1 HIS B  94      80.900 -10.421   4.840  1.00 65.37           N  
ATOM   2388  CD2 HIS B  94      81.946  -8.688   4.034  1.00 62.46           C  
ATOM   2389  CE1 HIS B  94      82.170 -10.539   5.186  1.00 64.13           C  
ATOM   2390  NE2 HIS B  94      82.827  -9.504   4.695  1.00 63.98           N  
ATOM   2391  N   LYS B  95      77.097  -7.918   1.514  1.00 61.90           N  
ATOM   2392  CA  LYS B  95      75.669  -7.967   1.120  1.00 62.53           C  
ATOM   2393  C   LYS B  95      75.418  -8.247  -0.374  1.00 62.93           C  
ATOM   2394  O   LYS B  95      74.273  -8.371  -0.788  1.00 62.55           O  
ATOM   2395  CB  LYS B  95      74.959  -6.663   1.504  1.00 61.79           C  
ATOM   2396  CG  LYS B  95      74.949  -6.347   2.997  1.00 63.93           C  
ATOM   2397  CD  LYS B  95      74.545  -4.885   3.244  1.00 63.95           C  
ATOM   2398  CE  LYS B  95      74.308  -4.637   4.712  1.00 67.49           C  
ATOM   2399  NZ  LYS B  95      75.103  -3.474   5.215  1.00 71.46           N  
ATOM   2400  N   ARG B  96      76.483  -8.287  -1.183  1.00 63.92           N  
ATOM   2401  CA  ARG B  96      76.372  -8.440  -2.634  1.00 64.24           C  
ATOM   2402  C   ARG B  96      76.138  -9.884  -3.045  1.00 64.60           C  
ATOM   2403  O   ARG B  96      76.738 -10.791  -2.497  1.00 64.73           O  
ATOM   2404  CB  ARG B  96      77.622  -7.904  -3.319  1.00 63.76           C  
ATOM   2405  CG  ARG B  96      77.641  -6.389  -3.443  1.00 65.32           C  
ATOM   2406  CD  ARG B  96      78.695  -5.907  -4.405  1.00 63.70           C  
ATOM   2407  NE  ARG B  96      78.340  -6.168  -5.802  1.00 66.54           N  
ATOM   2408  CZ  ARG B  96      77.803  -5.248  -6.607  1.00 69.41           C  
ATOM   2409  NH1 ARG B  96      77.542  -4.038  -6.154  1.00 69.15           N  
ATOM   2410  NH2 ARG B  96      77.522  -5.529  -7.865  1.00 71.63           N  
ATOM   2411  N   GLN B  97      75.292 -10.051  -4.051  0.50 64.88           N  
ATOM   2413  CA  GLN B  97      74.839 -11.347  -4.524  0.50 65.40           C  
ATOM   2415  C   GLN B  97      75.640 -11.853  -5.755  0.50 65.87           C  
ATOM   2417  O   GLN B  97      75.534 -13.018  -6.141  0.50 66.06           O  
ATOM   2419  CB  GLN B  97      73.314 -11.246  -4.760  0.50 65.11           C  
ATOM   2421  CG  GLN B  97      72.662 -12.304  -5.599  0.50 64.50           C  
ATOM   2423  CD  GLN B  97      72.610 -11.958  -7.074  0.50 63.88           C  
ATOM   2425  OE1 GLN B  97      72.095 -12.750  -7.866  0.50 63.81           O  
ATOM   2427  NE2 GLN B  97      73.150 -10.778  -7.461  0.50 61.06           N  
ATOM   2429  N   ASP B  98      76.464 -10.985  -6.334  1.00 66.74           N  
ATOM   2430  CA  ASP B  98      77.235 -11.287  -7.543  1.00 68.31           C  
ATOM   2431  C   ASP B  98      78.678 -11.736  -7.257  1.00 69.16           C  
ATOM   2432  O   ASP B  98      79.514 -11.799  -8.165  1.00 69.89           O  
ATOM   2433  CB  ASP B  98      77.229 -10.056  -8.478  1.00 68.40           C  
ATOM   2434  CG  ASP B  98      77.927  -8.835  -7.866  1.00 71.80           C  
ATOM   2435  OD1 ASP B  98      78.154  -8.814  -6.619  1.00 73.67           O  
ATOM   2436  OD2 ASP B  98      78.277  -7.896  -8.645  1.00 73.15           O  
HETATM 2437  N   MSE B  99      78.984 -12.015  -5.998  1.00 69.88           N  
HETATM 2438  CA  MSE B  99      80.344 -12.339  -5.593  1.00 72.05           C  
HETATM 2439  C   MSE B  99      80.312 -13.010  -4.252  1.00 69.83           C  
HETATM 2440  O   MSE B  99      79.410 -12.796  -3.455  1.00 69.24           O  
HETATM 2441  CB  MSE B  99      81.235 -11.080  -5.515  1.00 71.35           C  
HETATM 2442  CG  MSE B  99      80.886 -10.143  -4.381  1.00 72.52           C  
HETATM 2443 SE   MSE B  99      81.851  -8.419  -4.361  1.00 82.65          SE  
HETATM 2444  CE  MSE B  99      81.479  -7.739  -6.203  1.00 75.01           C  
ATOM   2445  N   ARG B 100      81.333 -13.811  -4.014  1.00 69.31           N  
ATOM   2446  CA  ARG B 100      81.509 -14.493  -2.760  1.00 68.64           C  
ATOM   2447  C   ARG B 100      82.882 -14.152  -2.216  1.00 66.62           C  
ATOM   2448  O   ARG B 100      83.887 -14.364  -2.876  1.00 64.95           O  
ATOM   2449  CB  ARG B 100      81.383 -16.001  -2.968  1.00 68.68           C  
ATOM   2450  CG  ARG B 100      81.025 -16.725  -1.684  1.00 71.39           C  
ATOM   2451  CD  ARG B 100      80.706 -18.217  -1.866  1.00 71.36           C  
ATOM   2452  NE  ARG B 100      81.717 -19.009  -1.168  1.00 78.46           N  
ATOM   2453  CZ  ARG B 100      82.725 -19.644  -1.767  1.00 80.35           C  
ATOM   2454  NH1 ARG B 100      82.842 -19.605  -3.082  1.00 80.24           N  
ATOM   2455  NH2 ARG B 100      83.614 -20.332  -1.050  1.00 81.55           N  
ATOM   2456  N   ILE B 101      82.921 -13.630  -1.004  1.00 66.14           N  
ATOM   2457  CA  ILE B 101      84.194 -13.251  -0.397  1.00 66.02           C  
ATOM   2458  C   ILE B 101      84.930 -14.500   0.094  1.00 67.10           C  
ATOM   2459  O   ILE B 101      84.390 -15.311   0.854  1.00 66.04           O  
ATOM   2460  CB  ILE B 101      83.993 -12.221   0.732  1.00 65.83           C  
ATOM   2461  CG1 ILE B 101      83.406 -10.940   0.135  1.00 64.66           C  
ATOM   2462  CG2 ILE B 101      85.300 -12.017   1.539  1.00 65.52           C  
ATOM   2463  CD1 ILE B 101      83.041  -9.934   1.121  1.00 66.63           C  
ATOM   2464  N   ILE B 102      86.154 -14.653  -0.392  1.00 68.08           N  
ATOM   2465  CA  ILE B 102      86.968 -15.837  -0.144  1.00 69.81           C  
ATOM   2466  C   ILE B 102      88.035 -15.543   0.932  1.00 70.12           C  
ATOM   2467  O   ILE B 102      88.404 -16.415   1.710  1.00 70.80           O  
ATOM   2468  CB  ILE B 102      87.527 -16.375  -1.520  1.00 70.43           C  
ATOM   2469  CG1 ILE B 102      86.803 -17.642  -1.900  1.00 70.24           C  
ATOM   2470  CG2 ILE B 102      89.022 -16.654  -1.521  1.00 72.30           C  
ATOM   2471  CD1 ILE B 102      85.360 -17.395  -2.140  1.00 72.76           C  
ATOM   2472  N   GLN B 103      88.443 -14.285   1.027  1.00 70.17           N  
ATOM   2473  CA  GLN B 103      89.587 -13.905   1.820  1.00 70.66           C  
ATOM   2474  C   GLN B 103      89.647 -12.415   2.058  1.00 69.99           C  
ATOM   2475  O   GLN B 103      89.506 -11.632   1.129  1.00 70.00           O  
ATOM   2476  CB  GLN B 103      90.834 -14.300   1.057  1.00 71.12           C  
ATOM   2477  CG  GLN B 103      91.595 -15.354   1.703  1.00 74.98           C  
ATOM   2478  CD  GLN B 103      92.568 -14.768   2.659  1.00 78.73           C  
ATOM   2479  OE1 GLN B 103      93.244 -13.785   2.332  1.00 82.37           O  
ATOM   2480  NE2 GLN B 103      92.653 -15.344   3.849  1.00 78.92           N  
ATOM   2481  N   GLU B 104      89.887 -12.033   3.302  1.00 69.92           N  
ATOM   2482  CA  GLU B 104      90.128 -10.642   3.662  1.00 70.16           C  
ATOM   2483  C   GLU B 104      91.460 -10.481   4.369  1.00 70.40           C  
ATOM   2484  O   GLU B 104      91.815 -11.296   5.223  1.00 70.68           O  
ATOM   2485  CB  GLU B 104      89.024 -10.115   4.553  1.00 69.58           C  
ATOM   2486  CG  GLU B 104      87.703 -10.173   3.901  1.00 72.35           C  
ATOM   2487  CD  GLU B 104      86.617  -9.555   4.719  1.00 77.61           C  
ATOM   2488  OE1 GLU B 104      86.897  -8.993   5.797  1.00 80.95           O  
ATOM   2489  OE2 GLU B 104      85.460  -9.627   4.275  1.00 80.86           O  
ATOM   2490  N   ARG B 105      92.186  -9.423   4.027  1.00 70.78           N  
ATOM   2491  CA  ARG B 105      93.459  -9.115   4.679  1.00 70.88           C  
ATOM   2492  C   ARG B 105      93.484  -7.638   5.030  1.00 70.60           C  
ATOM   2493  O   ARG B 105      93.393  -6.751   4.159  1.00 70.08           O  
ATOM   2494  CB  ARG B 105      94.661  -9.495   3.801  1.00 71.38           C  
ATOM   2495  CG  ARG B 105      94.678 -10.967   3.316  1.00 74.25           C  
ATOM   2496  CD  ARG B 105      95.295 -11.995   4.320  1.00 79.97           C  
ATOM   2497  NE  ARG B 105      94.483 -12.198   5.520  1.00 82.56           N  
ATOM   2498  CZ  ARG B 105      94.329 -13.360   6.149  1.00 85.51           C  
ATOM   2499  NH1 ARG B 105      94.933 -14.458   5.695  1.00 87.01           N  
ATOM   2500  NH2 ARG B 105      93.560 -13.425   7.240  1.00 86.28           N  
ATOM   2501  N   ASP B 106      93.574  -7.384   6.328  1.00 70.26           N  
ATOM   2502  CA  ASP B 106      93.626  -6.025   6.841  1.00 70.01           C  
ATOM   2503  C   ASP B 106      95.082  -5.499   6.879  1.00 70.03           C  
ATOM   2504  O   ASP B 106      95.768  -5.631   7.886  1.00 70.90           O  
ATOM   2505  CB  ASP B 106      92.949  -5.976   8.223  1.00 68.87           C  
ATOM   2506  CG  ASP B 106      92.748  -4.558   8.714  1.00 70.19           C  
ATOM   2507  OD1 ASP B 106      93.119  -3.585   7.988  1.00 66.23           O  
ATOM   2508  OD2 ASP B 106      92.210  -4.411   9.827  1.00 69.67           O  
ATOM   2509  N   TYR B 107      95.573  -4.955   5.771  1.00 69.80           N  
ATOM   2510  CA  TYR B 107      96.899  -4.301   5.759  1.00 69.93           C  
ATOM   2511  C   TYR B 107      96.822  -2.815   6.096  1.00 68.83           C  
ATOM   2512  O   TYR B 107      97.790  -2.104   5.947  1.00 69.61           O  
ATOM   2513  CB  TYR B 107      97.664  -4.523   4.436  1.00 70.76           C  
ATOM   2514  CG  TYR B 107      97.888  -5.978   4.158  1.00 73.71           C  
ATOM   2515  CD1 TYR B 107      98.439  -6.798   5.129  1.00 74.90           C  
ATOM   2516  CD2 TYR B 107      97.514  -6.556   2.940  1.00 75.86           C  
ATOM   2517  CE1 TYR B 107      98.630  -8.147   4.905  1.00 76.68           C  
ATOM   2518  CE2 TYR B 107      97.703  -7.934   2.704  1.00 74.45           C  
ATOM   2519  CZ  TYR B 107      98.266  -8.712   3.687  1.00 75.81           C  
ATOM   2520  OH  TYR B 107      98.456 -10.081   3.519  1.00 77.02           O  
ATOM   2521  N   ILE B 108      95.657  -2.362   6.540  1.00 68.24           N  
ATOM   2522  CA  ILE B 108      95.480  -1.030   7.093  1.00 67.30           C  
ATOM   2523  C   ILE B 108      95.830  -0.997   8.592  1.00 66.99           C  
ATOM   2524  O   ILE B 108      96.636  -0.172   9.005  1.00 67.12           O  
ATOM   2525  CB  ILE B 108      94.053  -0.495   6.877  1.00 67.20           C  
ATOM   2526  CG1 ILE B 108      93.792  -0.274   5.372  1.00 67.00           C  
ATOM   2527  CG2 ILE B 108      93.885   0.814   7.691  1.00 68.22           C  
ATOM   2528  CD1 ILE B 108      92.463   0.397   5.017  1.00 66.99           C  
ATOM   2529  N   THR B 109      95.233  -1.884   9.396  1.00 65.76           N  
ATOM   2530  CA  THR B 109      95.576  -1.994  10.809  1.00 65.11           C  
ATOM   2531  C   THR B 109      96.997  -2.554  10.948  1.00 64.69           C  
ATOM   2532  O   THR B 109      97.724  -2.227  11.886  1.00 64.68           O  
ATOM   2533  CB  THR B 109      94.597  -2.935  11.504  1.00 66.51           C  
ATOM   2534  OG1 THR B 109      93.269  -2.424  11.333  1.00 67.63           O  
ATOM   2535  CG2 THR B 109      94.925  -3.174  13.020  1.00 64.36           C  
ATOM   2536  N   HIS B 110      97.369  -3.438  10.025  1.00 63.39           N  
ATOM   2537  CA  HIS B 110      98.706  -4.004   9.998  1.00 62.18           C  
ATOM   2538  C   HIS B 110      99.368  -3.791   8.636  1.00 61.14           C  
ATOM   2539  O   HIS B 110      99.225  -4.607   7.712  1.00 60.79           O  
ATOM   2540  CB  HIS B 110      98.647  -5.468  10.335  1.00 60.29           C  
ATOM   2541  CG  HIS B 110      97.962  -5.737  11.627  1.00 62.68           C  
ATOM   2542  ND1 HIS B 110      98.556  -5.487  12.847  1.00 63.89           N  
ATOM   2543  CD2 HIS B 110      96.733  -6.240  11.899  1.00 59.54           C  
ATOM   2544  CE1 HIS B 110      97.729  -5.833  13.814  1.00 61.12           C  
ATOM   2545  NE2 HIS B 110      96.617  -6.287  13.266  1.00 61.78           N  
ATOM   2546  N   ARG B 111     100.122  -2.715   8.544  1.00 60.31           N  
ATOM   2547  CA  ARG B 111     100.767  -2.338   7.271  1.00 59.62           C  
ATOM   2548  C   ARG B 111     101.847  -3.319   6.788  1.00 59.15           C  
ATOM   2549  O   ARG B 111     102.366  -4.120   7.540  1.00 58.11           O  
ATOM   2550  CB  ARG B 111     101.391  -0.943   7.401  1.00 58.74           C  
ATOM   2551  CG  ARG B 111     102.644  -0.909   8.270  1.00 57.45           C  
ATOM   2552  CD  ARG B 111     103.300   0.406   7.999  1.00 54.30           C  
ATOM   2553  NE  ARG B 111     104.521   0.718   8.755  1.00 56.38           N  
ATOM   2554  CZ  ARG B 111     105.780   0.501   8.344  1.00 56.57           C  
ATOM   2555  NH1 ARG B 111     106.778   0.902   9.107  1.00 56.54           N  
ATOM   2556  NH2 ARG B 111     106.054  -0.116   7.192  1.00 54.95           N  
ATOM   2557  N   LYS B 112     102.213  -3.200   5.521  1.00 59.50           N  
ATOM   2558  CA  LYS B 112     103.347  -3.936   4.984  1.00 59.41           C  
ATOM   2559  C   LYS B 112     104.627  -3.221   5.351  1.00 58.44           C  
ATOM   2560  O   LYS B 112     104.596  -2.039   5.730  1.00 58.14           O  
ATOM   2561  CB  LYS B 112     103.202  -4.087   3.469  1.00 59.95           C  
ATOM   2562  CG  LYS B 112     101.935  -4.815   3.108  1.00 62.84           C  
ATOM   2563  CD  LYS B 112     102.154  -5.792   2.014  1.00 70.83           C  
ATOM   2564  CE  LYS B 112     100.902  -5.882   1.108  1.00 74.84           C  
ATOM   2565  NZ  LYS B 112     100.719  -7.288   0.603  1.00 80.19           N  
ATOM   2566  N   ALA B 113     105.747  -3.934   5.246  1.00 57.90           N  
ATOM   2567  CA  ALA B 113     107.059  -3.396   5.613  1.00 57.66           C  
ATOM   2568  C   ALA B 113     107.431  -2.165   4.802  1.00 57.97           C  
ATOM   2569  O   ALA B 113     108.166  -1.301   5.297  1.00 58.53           O  
ATOM   2570  CB  ALA B 113     108.116  -4.445   5.473  1.00 56.63           C  
ATOM   2571  N   SER B 114     106.943  -2.090   3.564  1.00 58.14           N  
ATOM   2572  CA  SER B 114     107.257  -0.958   2.656  1.00 58.73           C  
ATOM   2573  C   SER B 114     106.569   0.326   3.106  1.00 59.33           C  
ATOM   2574  O   SER B 114     106.983   1.430   2.767  1.00 59.53           O  
ATOM   2575  CB  SER B 114     106.814  -1.284   1.223  1.00 57.63           C  
ATOM   2576  OG  SER B 114     105.393  -1.472   1.151  1.00 58.23           O  
ATOM   2577  N   GLY B 115     105.490   0.169   3.854  1.00 60.19           N  
ATOM   2578  CA  GLY B 115     104.669   1.298   4.211  1.00 60.87           C  
ATOM   2579  C   GLY B 115     103.277   1.167   3.643  1.00 61.31           C  
ATOM   2580  O   GLY B 115     102.367   1.877   4.070  1.00 61.38           O  
ATOM   2581  N   TYR B 116     103.116   0.248   2.691  1.00 61.98           N  
ATOM   2582  CA  TYR B 116     101.854   0.034   2.007  1.00 62.50           C  
ATOM   2583  C   TYR B 116     100.726  -0.340   2.980  1.00 62.57           C  
ATOM   2584  O   TYR B 116     100.883  -1.222   3.818  1.00 61.04           O  
ATOM   2585  CB  TYR B 116     102.042  -1.030   0.949  1.00 63.92           C  
ATOM   2586  CG  TYR B 116     100.773  -1.474   0.246  1.00 66.71           C  
ATOM   2587  CD1 TYR B 116     100.306  -0.828  -0.907  1.00 70.26           C  
ATOM   2588  CD2 TYR B 116     100.064  -2.565   0.712  1.00 69.12           C  
ATOM   2589  CE1 TYR B 116      99.130  -1.275  -1.561  1.00 69.98           C  
ATOM   2590  CE2 TYR B 116      98.914  -3.007   0.088  1.00 71.02           C  
ATOM   2591  CZ  TYR B 116      98.456  -2.377  -1.058  1.00 70.05           C  
ATOM   2592  OH  TYR B 116      97.287  -2.876  -1.640  1.00 72.41           O  
ATOM   2593  N   ARG B 117      99.600   0.363   2.847  1.00 63.05           N  
ATOM   2594  CA  ARG B 117      98.408   0.139   3.649  1.00 64.01           C  
ATOM   2595  C   ARG B 117      97.212  -0.044   2.741  1.00 64.42           C  
ATOM   2596  O   ARG B 117      97.050   0.691   1.795  1.00 64.49           O  
ATOM   2597  CB  ARG B 117      98.161   1.306   4.590  1.00 63.49           C  
ATOM   2598  CG  ARG B 117      98.897   1.150   5.894  1.00 63.11           C  
ATOM   2599  CD  ARG B 117      98.658   2.343   6.785  1.00 64.49           C  
ATOM   2600  NE  ARG B 117      99.780   2.534   7.694  1.00 64.34           N  
ATOM   2601  CZ  ARG B 117      99.785   2.144   8.965  1.00 65.02           C  
ATOM   2602  NH1 ARG B 117      98.727   1.575   9.492  1.00 61.89           N  
ATOM   2603  NH2 ARG B 117     100.857   2.337   9.711  1.00 65.90           N  
ATOM   2604  N   SER B 118      96.389  -1.044   3.027  1.00 65.08           N  
ATOM   2605  CA  SER B 118      95.246  -1.362   2.185  1.00 66.01           C  
ATOM   2606  C   SER B 118      94.410  -2.439   2.816  1.00 65.33           C  
ATOM   2607  O   SER B 118      94.925  -3.281   3.527  1.00 64.42           O  
ATOM   2608  CB  SER B 118      95.744  -1.925   0.861  1.00 66.44           C  
ATOM   2609  OG  SER B 118      94.796  -1.702  -0.145  1.00 68.98           O  
ATOM   2610  N   TYR B 119      93.122  -2.456   2.516  1.00 65.38           N  
ATOM   2611  CA  TYR B 119      92.301  -3.594   2.939  1.00 64.97           C  
ATOM   2612  C   TYR B 119      91.964  -4.465   1.723  1.00 65.29           C  
ATOM   2613  O   TYR B 119      91.405  -3.979   0.746  1.00 66.55           O  
ATOM   2614  CB  TYR B 119      91.040  -3.095   3.606  1.00 64.44           C  
ATOM   2615  CG  TYR B 119      90.343  -4.142   4.423  1.00 64.85           C  
ATOM   2616  CD1 TYR B 119      90.459  -4.157   5.826  1.00 63.11           C  
ATOM   2617  CD2 TYR B 119      89.577  -5.135   3.814  1.00 62.34           C  
ATOM   2618  CE1 TYR B 119      89.818  -5.111   6.572  1.00 60.45           C  
ATOM   2619  CE2 TYR B 119      88.954  -6.104   4.573  1.00 61.16           C  
ATOM   2620  CZ  TYR B 119      89.067  -6.076   5.944  1.00 62.21           C  
ATOM   2621  OH  TYR B 119      88.432  -7.045   6.700  1.00 64.33           O  
ATOM   2622  N   HIS B 120      92.349  -5.731   1.755  1.00 64.71           N  
ATOM   2623  CA  HIS B 120      92.215  -6.593   0.586  1.00 64.16           C  
ATOM   2624  C   HIS B 120      91.038  -7.540   0.749  1.00 64.30           C  
ATOM   2625  O   HIS B 120      90.927  -8.262   1.787  1.00 63.73           O  
ATOM   2626  CB  HIS B 120      93.482  -7.425   0.385  1.00 64.56           C  
ATOM   2627  CG  HIS B 120      94.666  -6.642  -0.093  1.00 65.69           C  
ATOM   2628  ND1 HIS B 120      95.908  -7.214  -0.276  1.00 65.84           N  
ATOM   2629  CD2 HIS B 120      94.804  -5.335  -0.421  1.00 67.98           C  
ATOM   2630  CE1 HIS B 120      96.754  -6.301  -0.718  1.00 67.19           C  
ATOM   2631  NE2 HIS B 120      96.109  -5.151  -0.825  1.00 69.50           N  
ATOM   2632  N   VAL B 121      90.147  -7.521  -0.244  1.00 63.31           N  
ATOM   2633  CA  VAL B 121      89.081  -8.504  -0.313  1.00 62.89           C  
ATOM   2634  C   VAL B 121      89.107  -9.339  -1.595  1.00 62.57           C  
ATOM   2635  O   VAL B 121      88.958  -8.813  -2.697  1.00 62.54           O  
ATOM   2636  CB  VAL B 121      87.663  -8.014   0.219  1.00 63.46           C  
ATOM   2637  CG1 VAL B 121      87.525  -6.561   0.261  1.00 62.49           C  
ATOM   2638  CG2 VAL B 121      86.507  -8.736  -0.438  1.00 62.96           C  
ATOM   2639  N   VAL B 122      89.330 -10.637  -1.423  1.00 61.45           N  
ATOM   2640  CA  VAL B 122      89.427 -11.563  -2.541  1.00 61.69           C  
ATOM   2641  C   VAL B 122      88.060 -12.241  -2.696  1.00 61.34           C  
ATOM   2642  O   VAL B 122      87.502 -12.732  -1.718  1.00 61.24           O  
ATOM   2643  CB  VAL B 122      90.544 -12.632  -2.319  1.00 62.04           C  
ATOM   2644  CG1 VAL B 122      90.497 -13.685  -3.402  1.00 61.95           C  
ATOM   2645  CG2 VAL B 122      91.906 -11.974  -2.325  1.00 61.95           C  
ATOM   2646  N   VAL B 123      87.531 -12.239  -3.918  1.00 60.68           N  
ATOM   2647  CA  VAL B 123      86.187 -12.708  -4.199  1.00 59.99           C  
ATOM   2648  C   VAL B 123      86.221 -13.664  -5.377  1.00 60.27           C  
ATOM   2649  O   VAL B 123      87.080 -13.532  -6.245  1.00 60.16           O  
ATOM   2650  CB  VAL B 123      85.223 -11.518  -4.517  1.00 60.35           C  
ATOM   2651  CG1 VAL B 123      85.231 -10.506  -3.379  1.00 60.71           C  
ATOM   2652  CG2 VAL B 123      85.595 -10.798  -5.838  1.00 59.42           C  
ATOM   2653  N   GLU B 124      85.313 -14.642  -5.399  1.00 60.08           N  
ATOM   2654  CA  GLU B 124      84.965 -15.295  -6.643  1.00 60.13           C  
ATOM   2655  C   GLU B 124      83.919 -14.440  -7.303  1.00 59.96           C  
ATOM   2656  O   GLU B 124      82.988 -13.937  -6.634  1.00 59.38           O  
ATOM   2657  CB  GLU B 124      84.366 -16.665  -6.440  1.00 61.12           C  
ATOM   2658  CG  GLU B 124      85.278 -17.651  -5.796  1.00 65.28           C  
ATOM   2659  CD  GLU B 124      84.635 -19.016  -5.643  1.00 70.40           C  
ATOM   2660  OE1 GLU B 124      83.463 -19.221  -6.105  1.00 71.86           O  
ATOM   2661  OE2 GLU B 124      85.323 -19.888  -5.066  1.00 71.61           O  
ATOM   2662  N   TYR B 125      84.084 -14.290  -8.619  1.00 59.76           N  
ATOM   2663  CA  TYR B 125      83.214 -13.509  -9.448  1.00 59.35           C  
ATOM   2664  C   TYR B 125      82.982 -14.297 -10.720  1.00 59.12           C  
ATOM   2665  O   TYR B 125      83.905 -14.903 -11.247  1.00 59.77           O  
ATOM   2666  CB  TYR B 125      83.865 -12.165  -9.749  1.00 60.84           C  
ATOM   2667  CG  TYR B 125      82.940 -11.211 -10.459  1.00 60.99           C  
ATOM   2668  CD1 TYR B 125      81.884 -10.605  -9.780  1.00 61.64           C  
ATOM   2669  CD2 TYR B 125      83.098 -10.944 -11.814  1.00 61.88           C  
ATOM   2670  CE1 TYR B 125      81.025  -9.744 -10.423  1.00 64.62           C  
ATOM   2671  CE2 TYR B 125      82.237 -10.072 -12.487  1.00 62.45           C  
ATOM   2672  CZ  TYR B 125      81.206  -9.476 -11.777  1.00 63.66           C  
ATOM   2673  OH  TYR B 125      80.337  -8.622 -12.413  1.00 65.62           O  
ATOM   2674  N   THR B 126      81.736 -14.340 -11.177  1.00 58.50           N  
ATOM   2675  CA  THR B 126      81.361 -15.114 -12.343  1.00 58.38           C  
ATOM   2676  C   THR B 126      80.981 -14.153 -13.430  1.00 58.40           C  
ATOM   2677  O   THR B 126      80.327 -13.155 -13.191  1.00 58.34           O  
ATOM   2678  CB  THR B 126      80.185 -16.100 -12.083  1.00 58.82           C  
ATOM   2679  OG1 THR B 126      80.548 -17.005 -11.042  1.00 58.35           O  
ATOM   2680  CG2 THR B 126      79.886 -16.914 -13.335  1.00 58.11           C  
ATOM   2681  N   VAL B 127      81.422 -14.479 -14.627  1.00 58.42           N  
ATOM   2682  CA  VAL B 127      81.324 -13.622 -15.791  1.00 58.33           C  
ATOM   2683  C   VAL B 127      80.520 -14.451 -16.811  1.00 58.44           C  
ATOM   2684  O   VAL B 127      80.743 -15.651 -16.947  1.00 58.19           O  
ATOM   2685  CB  VAL B 127      82.775 -13.281 -16.205  1.00 58.02           C  
ATOM   2686  CG1 VAL B 127      83.141 -13.783 -17.557  1.00 58.64           C  
ATOM   2687  CG2 VAL B 127      83.143 -11.801 -15.937  1.00 59.46           C  
ATOM   2688  N   ASP B 128      79.553 -13.850 -17.493  1.00 59.06           N  
ATOM   2689  CA  ASP B 128      78.849 -14.590 -18.536  1.00 59.60           C  
ATOM   2690  C   ASP B 128      79.505 -14.337 -19.869  1.00 59.35           C  
ATOM   2691  O   ASP B 128      79.773 -13.192 -20.237  1.00 59.66           O  
ATOM   2692  CB  ASP B 128      77.346 -14.271 -18.554  1.00 59.86           C  
ATOM   2693  CG  ASP B 128      76.585 -15.006 -17.447  1.00 61.76           C  
ATOM   2694  OD1 ASP B 128      76.329 -16.231 -17.562  1.00 63.73           O  
ATOM   2695  OD2 ASP B 128      76.255 -14.362 -16.429  1.00 65.66           O  
ATOM   2696  N   THR B 129      79.832 -15.409 -20.573  1.00 59.14           N  
ATOM   2697  CA  THR B 129      80.393 -15.263 -21.910  1.00 59.05           C  
ATOM   2698  C   THR B 129      79.535 -16.045 -22.884  1.00 59.61           C  
ATOM   2699  O   THR B 129      78.664 -16.845 -22.481  1.00 59.80           O  
ATOM   2700  CB  THR B 129      81.866 -15.741 -22.008  1.00 58.56           C  
ATOM   2701  OG1 THR B 129      81.897 -17.170 -22.112  1.00 60.84           O  
ATOM   2702  CG2 THR B 129      82.704 -15.274 -20.815  1.00 57.31           C  
ATOM   2703  N   ILE B 130      79.767 -15.809 -24.168  1.00 60.08           N  
ATOM   2704  CA  ILE B 130      79.038 -16.515 -25.220  1.00 60.84           C  
ATOM   2705  C   ILE B 130      79.440 -17.993 -25.210  1.00 61.39           C  
ATOM   2706  O   ILE B 130      78.787 -18.830 -25.825  1.00 61.28           O  
ATOM   2707  CB  ILE B 130      79.285 -15.883 -26.626  1.00 61.14           C  
ATOM   2708  CG1 ILE B 130      80.791 -15.705 -26.913  1.00 60.10           C  
ATOM   2709  CG2 ILE B 130      78.538 -14.537 -26.748  1.00 61.68           C  
ATOM   2710  CD1 ILE B 130      81.108 -15.338 -28.367  1.00 60.29           C  
ATOM   2711  N   ASN B 131      80.527 -18.294 -24.504  1.00 62.19           N  
ATOM   2712  CA  ASN B 131      80.997 -19.676 -24.330  1.00 63.20           C  
ATOM   2713  C   ASN B 131      80.668 -20.231 -22.955  1.00 62.78           C  
ATOM   2714  O   ASN B 131      81.292 -21.180 -22.507  1.00 63.76           O  
ATOM   2715  CB  ASN B 131      82.513 -19.763 -24.566  1.00 63.41           C  
ATOM   2716  CG  ASN B 131      82.895 -19.451 -26.005  1.00 64.64           C  
ATOM   2717  OD1 ASN B 131      83.921 -18.807 -26.259  1.00 67.97           O  
ATOM   2718  ND2 ASN B 131      82.071 -19.895 -26.953  1.00 61.86           N  
ATOM   2719  N   GLY B 132      79.694 -19.626 -22.288  1.00 62.02           N  
ATOM   2720  CA  GLY B 132      79.347 -20.011 -20.932  1.00 60.48           C  
ATOM   2721  C   GLY B 132      79.998 -19.185 -19.830  1.00 59.44           C  
ATOM   2722  O   GLY B 132      80.928 -18.399 -20.051  1.00 59.35           O  
ATOM   2723  N   ALA B 133      79.464 -19.391 -18.636  1.00 58.52           N  
ATOM   2724  CA  ALA B 133      79.890 -18.778 -17.413  1.00 58.04           C  
ATOM   2725  C   ALA B 133      81.296 -19.218 -17.046  1.00 57.73           C  
ATOM   2726  O   ALA B 133      81.687 -20.364 -17.236  1.00 57.26           O  
ATOM   2727  CB  ALA B 133      78.911 -19.154 -16.304  1.00 57.80           C  
ATOM   2728  N   LYS B 134      82.039 -18.282 -16.497  1.00 57.70           N  
ATOM   2729  CA  LYS B 134      83.418 -18.477 -16.106  1.00 58.31           C  
ATOM   2730  C   LYS B 134      83.548 -17.775 -14.753  1.00 57.66           C  
ATOM   2731  O   LYS B 134      83.220 -16.597 -14.614  1.00 57.86           O  
ATOM   2732  CB  LYS B 134      84.338 -17.840 -17.163  1.00 59.23           C  
ATOM   2733  CG  LYS B 134      85.277 -18.804 -17.924  1.00 63.30           C  
ATOM   2734  CD  LYS B 134      84.671 -19.527 -19.160  1.00 69.17           C  
ATOM   2735  CE  LYS B 134      84.723 -18.694 -20.467  1.00 73.18           C  
ATOM   2736  NZ  LYS B 134      86.072 -18.105 -20.873  1.00 75.37           N  
ATOM   2737  N   THR B 135      83.981 -18.518 -13.752  1.00 57.27           N  
ATOM   2738  CA  THR B 135      84.229 -18.001 -12.422  1.00 57.63           C  
ATOM   2739  C   THR B 135      85.735 -17.825 -12.240  1.00 58.12           C  
ATOM   2740  O   THR B 135      86.496 -18.775 -12.456  1.00 58.63           O  
ATOM   2741  CB  THR B 135      83.678 -18.977 -11.346  1.00 57.73           C  
ATOM   2742  OG1 THR B 135      82.251 -19.021 -11.455  1.00 57.54           O  
ATOM   2743  CG2 THR B 135      84.075 -18.547  -9.965  1.00 55.62           C  
ATOM   2744  N   ILE B 136      86.137 -16.621 -11.838  1.00 57.88           N  
ATOM   2745  CA  ILE B 136      87.528 -16.241 -11.651  1.00 58.56           C  
ATOM   2746  C   ILE B 136      87.643 -15.681 -10.242  1.00 60.09           C  
ATOM   2747  O   ILE B 136      86.623 -15.438  -9.574  1.00 60.76           O  
ATOM   2748  CB  ILE B 136      88.029 -15.168 -12.734  1.00 58.62           C  
ATOM   2749  CG1 ILE B 136      87.113 -13.947 -12.831  1.00 58.84           C  
ATOM   2750  CG2 ILE B 136      88.143 -15.778 -14.129  1.00 55.55           C  
ATOM   2751  CD1 ILE B 136      87.534 -12.711 -11.996  1.00 59.38           C  
ATOM   2752  N   LEU B 137      88.870 -15.514  -9.759  1.00 60.73           N  
ATOM   2753  CA  LEU B 137      89.087 -14.781  -8.522  1.00 60.80           C  
ATOM   2754  C   LEU B 137      89.390 -13.334  -8.903  1.00 61.25           C  
ATOM   2755  O   LEU B 137      89.946 -13.086  -9.972  1.00 61.36           O  
ATOM   2756  CB  LEU B 137      90.250 -15.399  -7.749  1.00 60.48           C  
ATOM   2757  CG  LEU B 137      90.078 -16.393  -6.592  1.00 60.80           C  
ATOM   2758  CD1 LEU B 137      88.685 -16.999  -6.427  1.00 57.80           C  
ATOM   2759  CD2 LEU B 137      91.128 -17.500  -6.696  1.00 58.08           C  
ATOM   2760  N   ALA B 138      89.009 -12.379  -8.055  1.00 61.56           N  
ATOM   2761  CA  ALA B 138      89.409 -10.970  -8.233  1.00 62.70           C  
ATOM   2762  C   ALA B 138      89.745 -10.377  -6.859  1.00 63.61           C  
ATOM   2763  O   ALA B 138      89.124 -10.743  -5.848  1.00 64.45           O  
ATOM   2764  CB  ALA B 138      88.310 -10.161  -8.918  1.00 61.70           C  
ATOM   2765  N   GLU B 139      90.736  -9.500  -6.813  1.00 64.18           N  
ATOM   2766  CA  GLU B 139      91.136  -8.856  -5.566  1.00 66.37           C  
ATOM   2767  C   GLU B 139      90.660  -7.422  -5.570  1.00 65.68           C  
ATOM   2768  O   GLU B 139      90.962  -6.681  -6.492  1.00 65.53           O  
ATOM   2769  CB  GLU B 139      92.656  -8.902  -5.398  1.00 65.97           C  
ATOM   2770  CG  GLU B 139      93.170  -8.346  -4.075  1.00 68.68           C  
ATOM   2771  CD  GLU B 139      94.677  -8.588  -3.876  1.00 70.56           C  
ATOM   2772  OE1 GLU B 139      95.499  -7.864  -4.478  1.00 73.41           O  
ATOM   2773  OE2 GLU B 139      95.040  -9.519  -3.105  1.00 78.71           O  
ATOM   2774  N   ILE B 140      89.882  -7.052  -4.566  1.00 65.81           N  
ATOM   2775  CA  ILE B 140      89.387  -5.688  -4.441  1.00 66.10           C  
ATOM   2776  C   ILE B 140      90.187  -5.064  -3.309  1.00 66.81           C  
ATOM   2777  O   ILE B 140      90.150  -5.543  -2.160  1.00 65.48           O  
ATOM   2778  CB  ILE B 140      87.865  -5.641  -4.128  1.00 66.22           C  
ATOM   2779  CG1 ILE B 140      87.065  -6.302  -5.273  1.00 66.79           C  
ATOM   2780  CG2 ILE B 140      87.404  -4.219  -3.891  1.00 65.11           C  
ATOM   2781  CD1 ILE B 140      85.571  -6.490  -5.015  1.00 66.05           C  
ATOM   2782  N   GLN B 141      90.946  -4.018  -3.633  1.00 67.01           N  
ATOM   2783  CA  GLN B 141      91.759  -3.354  -2.614  1.00 67.21           C  
ATOM   2784  C   GLN B 141      91.071  -2.111  -2.221  1.00 66.75           C  
ATOM   2785  O   GLN B 141      90.844  -1.250  -3.040  1.00 67.94           O  
ATOM   2786  CB  GLN B 141      93.149  -3.032  -3.142  1.00 67.52           C  
ATOM   2787  CG  GLN B 141      94.057  -4.218  -3.139  1.00 69.87           C  
ATOM   2788  CD  GLN B 141      95.110  -4.185  -4.244  1.00 75.10           C  
ATOM   2789  OE1 GLN B 141      95.481  -3.111  -4.754  1.00 77.70           O  
ATOM   2790  NE2 GLN B 141      95.604  -5.369  -4.620  1.00 74.53           N  
ATOM   2791  N   ILE B 142      90.706  -2.012  -0.961  1.00 67.34           N  
ATOM   2792  CA  ILE B 142      90.137  -0.760  -0.447  1.00 67.57           C  
ATOM   2793  C   ILE B 142      91.233   0.060   0.268  1.00 68.07           C  
ATOM   2794  O   ILE B 142      92.018  -0.465   1.097  1.00 68.54           O  
ATOM   2795  CB  ILE B 142      88.910  -1.021   0.467  1.00 66.97           C  
ATOM   2796  CG1 ILE B 142      87.969  -2.042  -0.211  1.00 66.75           C  
ATOM   2797  CG2 ILE B 142      88.174   0.285   0.828  1.00 64.63           C  
ATOM   2798  CD1 ILE B 142      87.053  -2.751   0.735  1.00 64.01           C  
ATOM   2799  N   ARG B 143      91.290   1.341  -0.053  1.00 68.21           N  
ATOM   2800  CA  ARG B 143      92.291   2.221   0.577  1.00 68.87           C  
ATOM   2801  C   ARG B 143      91.835   3.662   0.585  1.00 68.48           C  
ATOM   2802  O   ARG B 143      90.992   4.068  -0.204  1.00 68.04           O  
ATOM   2803  CB  ARG B 143      93.644   2.125  -0.138  1.00 68.97           C  
ATOM   2804  CG  ARG B 143      93.507   2.329  -1.591  1.00 70.07           C  
ATOM   2805  CD  ARG B 143      94.818   2.444  -2.289  1.00 74.87           C  
ATOM   2806  NE  ARG B 143      95.409   1.160  -2.674  1.00 77.34           N  
ATOM   2807  CZ  ARG B 143      96.181   0.987  -3.756  1.00 77.85           C  
ATOM   2808  NH1 ARG B 143      96.412   1.991  -4.616  1.00 74.49           N  
ATOM   2809  NH2 ARG B 143      96.700  -0.214  -3.991  1.00 78.97           N  
ATOM   2810  N   THR B 144      92.415   4.435   1.489  1.00 68.83           N  
ATOM   2811  CA  THR B 144      92.180   5.874   1.526  1.00 68.64           C  
ATOM   2812  C   THR B 144      92.872   6.617   0.386  1.00 68.90           C  
ATOM   2813  O   THR B 144      93.748   6.098  -0.318  1.00 68.05           O  
ATOM   2814  CB  THR B 144      92.641   6.460   2.859  1.00 68.81           C  
ATOM   2815  OG1 THR B 144      94.061   6.374   2.920  1.00 70.10           O  
ATOM   2816  CG2 THR B 144      92.030   5.716   4.040  1.00 66.46           C  
ATOM   2817  N   LEU B 145      92.453   7.864   0.210  1.00 70.26           N  
ATOM   2818  CA  LEU B 145      93.080   8.793  -0.719  1.00 69.88           C  
ATOM   2819  C   LEU B 145      94.576   8.972  -0.403  1.00 69.95           C  
ATOM   2820  O   LEU B 145      95.410   8.993  -1.307  1.00 70.30           O  
ATOM   2821  CB  LEU B 145      92.357  10.129  -0.642  1.00 70.05           C  
ATOM   2822  CG  LEU B 145      90.862  10.186  -0.944  1.00 71.22           C  
ATOM   2823  CD1 LEU B 145      90.352  11.606  -0.664  1.00 69.36           C  
ATOM   2824  CD2 LEU B 145      90.550   9.775  -2.391  1.00 70.79           C  
ATOM   2825  N   ALA B 146      94.906   9.091   0.874  1.00 70.05           N  
ATOM   2826  CA  ALA B 146      96.288   9.240   1.306  1.00 69.96           C  
ATOM   2827  C   ALA B 146      97.133   7.998   0.996  1.00 70.19           C  
ATOM   2828  O   ALA B 146      98.220   8.141   0.465  1.00 68.90           O  
ATOM   2829  CB  ALA B 146      96.335   9.587   2.768  1.00 70.32           C  
HETATM 2830  N   MSE B 147      96.627   6.794   1.300  1.00 71.25           N  
HETATM 2831  CA  MSE B 147      97.297   5.518   0.910  1.00 74.36           C  
HETATM 2832  C   MSE B 147      97.374   5.347  -0.618  1.00 70.77           C  
HETATM 2833  O   MSE B 147      98.328   4.791  -1.147  1.00 70.30           O  
HETATM 2834  CB  MSE B 147      96.597   4.268   1.485  1.00 73.95           C  
HETATM 2835  CG  MSE B 147      96.167   4.330   2.964  1.00 77.73           C  
HETATM 2836 SE   MSE B 147      94.760   2.909   3.414  1.00 87.60          SE  
HETATM 2837  CE  MSE B 147      94.454   3.387   5.394  1.00 81.48           C  
ATOM   2838  N   ASN B 148      96.354   5.795  -1.325  1.00 68.99           N  
ATOM   2839  CA  ASN B 148      96.416   5.734  -2.770  1.00 69.14           C  
ATOM   2840  C   ASN B 148      97.428   6.725  -3.361  1.00 68.68           C  
ATOM   2841  O   ASN B 148      98.063   6.451  -4.393  1.00 69.75           O  
ATOM   2842  CB  ASN B 148      95.035   5.964  -3.390  1.00 69.39           C  
ATOM   2843  CG  ASN B 148      95.086   5.952  -4.890  1.00 69.24           C  
ATOM   2844  OD1 ASN B 148      94.944   6.976  -5.524  1.00 73.62           O  
ATOM   2845  ND2 ASN B 148      95.359   4.805  -5.459  1.00 70.28           N  
ATOM   2846  N   PHE B 149      97.562   7.884  -2.726  1.00 66.84           N  
ATOM   2847  CA  PHE B 149      98.589   8.805  -3.113  1.00 66.15           C  
ATOM   2848  C   PHE B 149      99.960   8.122  -3.008  1.00 65.49           C  
ATOM   2849  O   PHE B 149     100.774   8.201  -3.939  1.00 65.23           O  
ATOM   2850  CB  PHE B 149      98.503  10.095  -2.272  1.00 66.50           C  
ATOM   2851  CG  PHE B 149      99.848  10.647  -1.848  1.00 67.03           C  
ATOM   2852  CD1 PHE B 149     100.634  11.372  -2.743  1.00 66.96           C  
ATOM   2853  CD2 PHE B 149     100.315  10.446  -0.543  1.00 65.09           C  
ATOM   2854  CE1 PHE B 149     101.888  11.887  -2.335  1.00 68.84           C  
ATOM   2855  CE2 PHE B 149     101.542  10.957  -0.143  1.00 66.52           C  
ATOM   2856  CZ  PHE B 149     102.332  11.666  -1.032  1.00 66.11           C  
ATOM   2857  N   TRP B 150     100.205   7.450  -1.877  1.00 64.35           N  
ATOM   2858  CA  TRP B 150     101.514   6.866  -1.614  1.00 62.95           C  
ATOM   2859  C   TRP B 150     101.770   5.661  -2.514  1.00 63.03           C  
ATOM   2860  O   TRP B 150     102.850   5.540  -3.082  1.00 61.20           O  
ATOM   2861  CB  TRP B 150     101.625   6.414  -0.151  1.00 62.14           C  
ATOM   2862  CG  TRP B 150     103.001   5.836   0.153  1.00 61.56           C  
ATOM   2863  CD1 TRP B 150     104.110   6.545   0.538  1.00 60.81           C  
ATOM   2864  CD2 TRP B 150     103.425   4.453   0.040  1.00 59.82           C  
ATOM   2865  NE1 TRP B 150     105.193   5.690   0.691  1.00 62.64           N  
ATOM   2866  CE2 TRP B 150     104.803   4.406   0.390  1.00 61.75           C  
ATOM   2867  CE3 TRP B 150     102.787   3.258  -0.333  1.00 58.29           C  
ATOM   2868  CZ2 TRP B 150     105.543   3.203   0.394  1.00 60.05           C  
ATOM   2869  CZ3 TRP B 150     103.529   2.064  -0.339  1.00 58.01           C  
ATOM   2870  CH2 TRP B 150     104.880   2.045   0.043  1.00 58.43           C  
ATOM   2871  N   ALA B 151     100.791   4.733  -2.560  1.00 63.29           N  
ATOM   2872  CA  ALA B 151     100.916   3.490  -3.342  1.00 63.66           C  
ATOM   2873  C   ALA B 151     101.076   3.762  -4.842  1.00 63.51           C  
ATOM   2874  O   ALA B 151     101.869   3.097  -5.516  1.00 64.52           O  
ATOM   2875  CB  ALA B 151      99.736   2.557  -3.076  1.00 63.66           C  
ATOM   2876  N   THR B 152     100.374   4.765  -5.367  1.00 63.08           N  
ATOM   2877  CA  THR B 152     100.480   5.096  -6.806  1.00 61.64           C  
ATOM   2878  C   THR B 152     101.892   5.509  -7.140  1.00 61.95           C  
ATOM   2879  O   THR B 152     102.492   5.020  -8.104  1.00 62.42           O  
ATOM   2880  CB  THR B 152      99.459   6.175  -7.190  1.00 62.07           C  
ATOM   2881  OG1 THR B 152      98.136   5.672  -6.945  1.00 60.64           O  
ATOM   2882  CG2 THR B 152      99.579   6.600  -8.675  1.00 59.70           C  
ATOM   2883  N   ILE B 153     102.452   6.388  -6.320  1.00 62.08           N  
ATOM   2884  CA  ILE B 153     103.808   6.870  -6.564  1.00 62.67           C  
ATOM   2885  C   ILE B 153     104.871   5.801  -6.324  1.00 62.52           C  
ATOM   2886  O   ILE B 153     105.777   5.629  -7.145  1.00 62.29           O  
ATOM   2887  CB  ILE B 153     104.132   8.172  -5.771  1.00 63.16           C  
ATOM   2888  CG1 ILE B 153     103.225   9.304  -6.265  1.00 64.17           C  
ATOM   2889  CG2 ILE B 153     105.634   8.564  -5.928  1.00 61.20           C  
ATOM   2890  CD1 ILE B 153     103.024  10.409  -5.252  1.00 66.60           C  
ATOM   2891  N   GLU B 154     104.763   5.097  -5.203  1.00 62.66           N  
ATOM   2892  CA  GLU B 154     105.651   3.979  -4.926  1.00 63.43           C  
ATOM   2893  C   GLU B 154     105.629   2.952  -6.064  1.00 64.03           C  
ATOM   2894  O   GLU B 154     106.686   2.525  -6.557  1.00 63.28           O  
ATOM   2895  CB  GLU B 154     105.296   3.328  -3.592  1.00 63.07           C  
ATOM   2896  CG  GLU B 154     106.466   2.589  -3.011  1.00 64.71           C  
ATOM   2897  CD  GLU B 154     106.513   1.123  -3.390  1.00 69.81           C  
ATOM   2898  OE1 GLU B 154     105.563   0.600  -4.040  1.00 69.88           O  
ATOM   2899  OE2 GLU B 154     107.510   0.480  -2.989  1.00 72.98           O  
ATOM   2900  N   HIS B 155     104.429   2.582  -6.499  1.00 65.17           N  
ATOM   2901  CA  HIS B 155     104.323   1.676  -7.614  1.00 67.93           C  
ATOM   2902  C   HIS B 155     105.022   2.146  -8.906  1.00 68.44           C  
ATOM   2903  O   HIS B 155     105.692   1.334  -9.542  1.00 69.06           O  
ATOM   2904  CB  HIS B 155     102.878   1.269  -7.894  1.00 68.52           C  
ATOM   2905  CG  HIS B 155     102.752   0.312  -9.046  1.00 72.92           C  
ATOM   2906  ND1 HIS B 155     103.112  -1.018  -8.955  1.00 75.38           N  
ATOM   2907  CD2 HIS B 155     102.361   0.505 -10.329  1.00 75.75           C  
ATOM   2908  CE1 HIS B 155     102.906  -1.612 -10.115  1.00 74.59           C  
ATOM   2909  NE2 HIS B 155     102.453  -0.710 -10.967  1.00 77.24           N  
ATOM   2910  N   SER B 156     104.871   3.418  -9.297  1.00 69.22           N  
ATOM   2911  CA  SER B 156     105.565   3.935 -10.510  1.00 70.30           C  
ATOM   2912  C   SER B 156     107.074   4.000 -10.388  1.00 70.21           C  
ATOM   2913  O   SER B 156     107.772   3.636 -11.326  1.00 70.06           O  
ATOM   2914  CB  SER B 156     105.049   5.315 -10.937  1.00 70.29           C  
ATOM   2915  OG  SER B 156     103.635   5.336 -10.883  1.00 74.25           O  
ATOM   2916  N   LEU B 157     107.576   4.475  -9.250  1.00 71.19           N  
ATOM   2917  CA  LEU B 157     109.022   4.529  -9.019  1.00 72.74           C  
ATOM   2918  C   LEU B 157     109.655   3.144  -9.094  1.00 74.42           C  
ATOM   2919  O   LEU B 157     110.700   2.972  -9.724  1.00 74.36           O  
ATOM   2920  CB  LEU B 157     109.354   5.196  -7.691  1.00 71.91           C  
ATOM   2921  CG  LEU B 157     108.780   6.583  -7.443  1.00 71.41           C  
ATOM   2922  CD1 LEU B 157     109.094   7.021  -6.029  1.00 69.69           C  
ATOM   2923  CD2 LEU B 157     109.283   7.605  -8.475  1.00 69.72           C  
ATOM   2924  N   ASN B 158     109.005   2.172  -8.454  1.00 76.86           N  
ATOM   2925  CA  ASN B 158     109.375   0.757  -8.534  1.00 79.70           C  
ATOM   2926  C   ASN B 158     109.452   0.236  -9.964  1.00 81.35           C  
ATOM   2927  O   ASN B 158     110.516  -0.186 -10.408  1.00 81.64           O  
ATOM   2928  CB  ASN B 158     108.404  -0.112  -7.715  1.00 79.67           C  
ATOM   2929  CG  ASN B 158     109.056  -0.745  -6.494  1.00 81.30           C  
ATOM   2930  OD1 ASN B 158     110.283  -0.803  -6.393  1.00 81.80           O  
ATOM   2931  ND2 ASN B 158     108.227  -1.255  -5.563  1.00 82.87           N  
ATOM   2932  N   TYR B 159     108.320   0.271 -10.669  1.00 84.03           N  
ATOM   2933  CA  TYR B 159     108.232  -0.159 -12.068  1.00 86.46           C  
ATOM   2934  C   TYR B 159     109.302   0.494 -12.952  1.00 87.58           C  
ATOM   2935  O   TYR B 159     109.836  -0.138 -13.860  1.00 87.85           O  
ATOM   2936  CB  TYR B 159     106.822   0.083 -12.638  1.00 87.16           C  
ATOM   2937  CG  TYR B 159     106.726  -0.210 -14.126  1.00 88.55           C  
ATOM   2938  CD1 TYR B 159     107.171   0.728 -15.072  1.00 88.98           C  
ATOM   2939  CD2 TYR B 159     106.216  -1.433 -14.593  1.00 88.99           C  
ATOM   2940  CE1 TYR B 159     107.108   0.463 -16.441  1.00 89.50           C  
ATOM   2941  CE2 TYR B 159     106.150  -1.710 -15.967  1.00 89.11           C  
ATOM   2942  CZ  TYR B 159     106.595  -0.754 -16.881  1.00 89.28           C  
ATOM   2943  OH  TYR B 159     106.541  -0.995 -18.238  1.00 89.67           O  
ATOM   2944  N   LYS B 160     109.621   1.749 -12.674  1.00 89.13           N  
ATOM   2945  CA  LYS B 160     110.678   2.444 -13.403  1.00 90.89           C  
ATOM   2946  C   LYS B 160     112.116   2.096 -12.936  1.00 91.86           C  
ATOM   2947  O   LYS B 160     113.078   2.370 -13.655  1.00 92.29           O  
ATOM   2948  CB  LYS B 160     110.377   3.961 -13.428  1.00 90.88           C  
ATOM   2949  CG  LYS B 160     111.549   4.913 -13.210  1.00 92.28           C  
ATOM   2950  CD  LYS B 160     111.435   6.132 -14.134  1.00 94.09           C  
ATOM   2951  CE  LYS B 160     112.698   6.978 -14.115  1.00 94.81           C  
ATOM   2952  NZ  LYS B 160     112.930   7.619 -15.435  1.00 94.66           N  
ATOM   2953  N   TYR B 161     112.268   1.465 -11.766  1.00 92.97           N  
ATOM   2954  CA  TYR B 161     113.610   1.151 -11.224  1.00 93.64           C  
ATOM   2955  C   TYR B 161     114.137  -0.255 -11.553  1.00 94.01           C  
ATOM   2956  O   TYR B 161     114.459  -0.535 -12.704  1.00 94.15           O  
ATOM   2957  CB  TYR B 161     113.699   1.424  -9.710  1.00 93.91           C  
ATOM   2958  CG  TYR B 161     115.129   1.506  -9.206  1.00 94.27           C  
ATOM   2959  CD1 TYR B 161     115.944   2.585  -9.545  1.00 94.87           C  
ATOM   2960  CD2 TYR B 161     115.673   0.501  -8.409  1.00 94.48           C  
ATOM   2961  CE1 TYR B 161     117.265   2.666  -9.098  1.00 95.01           C  
ATOM   2962  CE2 TYR B 161     117.000   0.573  -7.959  1.00 94.41           C  
ATOM   2963  CZ  TYR B 161     117.786   1.660  -8.305  1.00 94.46           C  
ATOM   2964  OH  TYR B 161     119.091   1.748  -7.867  1.00 94.20           O  
ATOM   2965  N   GLN B 162     114.219  -1.126 -10.543  1.00 94.47           N  
ATOM   2966  CA  GLN B 162     114.948  -2.412 -10.627  1.00 94.84           C  
ATOM   2967  C   GLN B 162     116.075  -2.432 -11.661  1.00 94.61           C  
ATOM   2968  O   GLN B 162     117.012  -1.635 -11.584  1.00 94.58           O  
ATOM   2969  CB  GLN B 162     113.993  -3.592 -10.858  1.00 94.99           C  
ATOM   2970  CG  GLN B 162     113.125  -3.950  -9.639  1.00 96.11           C  
ATOM   2971  CD  GLN B 162     111.933  -3.005  -9.458  1.00 96.21           C  
ATOM   2972  OE1 GLN B 162     111.806  -2.343  -8.422  1.00 95.97           O  
ATOM   2973  NE2 GLN B 162     111.059  -2.942 -10.471  1.00 95.50           N  
ATOM   2974  N   ASP B 164     115.545  -3.473  -7.500  1.00 78.07           N  
ATOM   2975  CA  ASP B 164     115.193  -3.171  -6.117  1.00 78.38           C  
ATOM   2976  C   ASP B 164     115.847  -1.873  -5.656  1.00 77.71           C  
ATOM   2977  O   ASP B 164     117.054  -1.689  -5.861  1.00 78.06           O  
ATOM   2978  CB  ASP B 164     115.602  -4.323  -5.176  1.00 78.81           C  
ATOM   2979  CG  ASP B 164     114.394  -5.006  -4.510  1.00 80.78           C  
ATOM   2980  OD1 ASP B 164     113.368  -4.320  -4.266  1.00 82.02           O  
ATOM   2981  OD2 ASP B 164     114.478  -6.229  -4.215  1.00 82.54           O  
ATOM   2982  N   PHE B 165     115.051  -0.994  -5.028  1.00 76.67           N  
ATOM   2983  CA  PHE B 165     115.513   0.315  -4.526  1.00 75.65           C  
ATOM   2984  C   PHE B 165     116.703   0.156  -3.603  1.00 75.03           C  
ATOM   2985  O   PHE B 165     116.728  -0.805  -2.829  1.00 75.42           O  
ATOM   2986  CB  PHE B 165     114.430   1.007  -3.688  1.00 75.58           C  
ATOM   2987  CG  PHE B 165     113.239   1.477  -4.461  1.00 75.08           C  
ATOM   2988  CD1 PHE B 165     113.385   2.140  -5.671  1.00 73.67           C  
ATOM   2989  CD2 PHE B 165     111.955   1.291  -3.939  1.00 74.86           C  
ATOM   2990  CE1 PHE B 165     112.267   2.573  -6.374  1.00 73.40           C  
ATOM   2991  CE2 PHE B 165     110.828   1.734  -4.633  1.00 74.25           C  
ATOM   2992  CZ  PHE B 165     110.991   2.382  -5.852  1.00 73.75           C  
ATOM   2993  N   PRO B 166     117.655   1.115  -3.630  1.00 74.13           N  
ATOM   2994  CA  PRO B 166     118.655   1.168  -2.567  1.00 73.84           C  
ATOM   2995  C   PRO B 166     117.957   1.248  -1.209  1.00 73.76           C  
ATOM   2996  O   PRO B 166     116.796   1.651  -1.134  1.00 73.45           O  
ATOM   2997  CB  PRO B 166     119.397   2.481  -2.837  1.00 73.58           C  
ATOM   2998  CG  PRO B 166     119.181   2.755  -4.245  1.00 73.73           C  
ATOM   2999  CD  PRO B 166     117.844   2.193  -4.611  1.00 73.94           C  
ATOM   3000  N   ASP B 167     118.656   0.872  -0.145  1.00 73.91           N  
ATOM   3001  CA  ASP B 167     118.053   0.859   1.183  1.00 73.83           C  
ATOM   3002  C   ASP B 167     117.581   2.243   1.631  1.00 73.07           C  
ATOM   3003  O   ASP B 167     116.476   2.375   2.163  1.00 73.30           O  
ATOM   3004  CB  ASP B 167     118.989   0.204   2.208  1.00 74.48           C  
ATOM   3005  CG  ASP B 167     118.852  -1.323   2.231  1.00 76.06           C  
ATOM   3006  OD1 ASP B 167     119.802  -2.013   2.681  1.00 78.14           O  
ATOM   3007  OD2 ASP B 167     117.797  -1.839   1.786  1.00 77.37           O  
ATOM   3008  N   GLU B 168     118.395   3.259   1.370  1.00 71.74           N  
ATOM   3009  CA  GLU B 168     118.067   4.648   1.699  1.00 71.41           C  
ATOM   3010  C   GLU B 168     116.774   5.159   1.020  1.00 69.71           C  
ATOM   3011  O   GLU B 168     116.053   5.993   1.579  1.00 69.88           O  
ATOM   3012  CB  GLU B 168     119.259   5.550   1.359  1.00 71.84           C  
ATOM   3013  CG  GLU B 168     119.299   6.908   2.096  1.00 76.90           C  
ATOM   3014  CD  GLU B 168     118.893   8.127   1.221  1.00 83.12           C  
ATOM   3015  OE1 GLU B 168     117.924   8.036   0.416  1.00 86.02           O  
ATOM   3016  OE2 GLU B 168     119.553   9.187   1.343  1.00 82.84           O  
ATOM   3017  N   ILE B 169     116.474   4.649  -0.172  1.00 67.36           N  
ATOM   3018  CA  ILE B 169     115.307   5.105  -0.902  1.00 65.00           C  
ATOM   3019  C   ILE B 169     114.123   4.405  -0.290  1.00 63.96           C  
ATOM   3020  O   ILE B 169     113.067   5.006  -0.084  1.00 63.10           O  
ATOM   3021  CB  ILE B 169     115.409   4.824  -2.442  1.00 64.60           C  
ATOM   3022  CG1 ILE B 169     116.507   5.663  -3.083  1.00 64.85           C  
ATOM   3023  CG2 ILE B 169     114.086   5.082  -3.145  1.00 63.64           C  
ATOM   3024  CD1 ILE B 169     116.407   7.176  -2.836  1.00 64.86           C  
ATOM   3025  N   LYS B 170     114.320   3.120  -0.007  1.00 63.17           N  
ATOM   3026  CA  LYS B 170     113.301   2.292   0.617  1.00 62.40           C  
ATOM   3027  C   LYS B 170     112.885   2.867   1.976  1.00 60.97           C  
ATOM   3028  O   LYS B 170     111.701   2.918   2.289  1.00 59.88           O  
ATOM   3029  CB  LYS B 170     113.774   0.843   0.723  1.00 62.77           C  
ATOM   3030  CG  LYS B 170     112.629  -0.183   0.638  1.00 65.93           C  
ATOM   3031  CD  LYS B 170     113.033  -1.437  -0.158  1.00 70.74           C  
ATOM   3032  CE  LYS B 170     114.544  -1.743  -0.028  1.00 72.51           C  
ATOM   3033  NZ  LYS B 170     114.954  -2.990  -0.740  1.00 72.76           N  
ATOM   3034  N   LYS B 171     113.863   3.337   2.748  1.00 60.20           N  
ATOM   3035  CA  LYS B 171     113.587   3.996   4.024  1.00 60.12           C  
ATOM   3036  C   LYS B 171     112.795   5.289   3.876  1.00 59.47           C  
ATOM   3037  O   LYS B 171     111.893   5.535   4.657  1.00 59.30           O  
ATOM   3038  CB  LYS B 171     114.867   4.272   4.812  1.00 60.83           C  
ATOM   3039  CG  LYS B 171     115.828   3.084   4.935  1.00 62.59           C  
ATOM   3040  CD  LYS B 171     115.287   1.931   5.812  1.00 66.23           C  
ATOM   3041  CE  LYS B 171     116.413   0.916   6.122  1.00 65.27           C  
ATOM   3042  NZ  LYS B 171     117.789   1.571   6.166  1.00 65.54           N  
ATOM   3043  N   ARG B 172     113.143   6.116   2.882  1.00 59.33           N  
ATOM   3044  CA  ARG B 172     112.455   7.387   2.654  1.00 57.87           C  
ATOM   3045  C   ARG B 172     111.019   7.191   2.207  1.00 57.67           C  
ATOM   3046  O   ARG B 172     110.141   7.933   2.622  1.00 57.89           O  
ATOM   3047  CB  ARG B 172     113.227   8.256   1.697  1.00 57.13           C  
ATOM   3048  CG  ARG B 172     114.500   8.805   2.326  1.00 55.94           C  
ATOM   3049  CD  ARG B 172     115.421   9.367   1.284  1.00 53.69           C  
ATOM   3050  NE  ARG B 172     114.840  10.556   0.665  1.00 55.70           N  
ATOM   3051  CZ  ARG B 172     115.397  11.270  -0.314  1.00 56.32           C  
ATOM   3052  NH1 ARG B 172     116.571  10.921  -0.854  1.00 53.77           N  
ATOM   3053  NH2 ARG B 172     114.753  12.332  -0.767  1.00 56.39           N  
ATOM   3054  N   LEU B 173     110.783   6.162   1.401  1.00 57.32           N  
ATOM   3055  CA  LEU B 173     109.440   5.762   1.041  1.00 57.41           C  
ATOM   3056  C   LEU B 173     108.654   5.257   2.235  1.00 57.52           C  
ATOM   3057  O   LEU B 173     107.458   5.507   2.319  1.00 57.34           O  
ATOM   3058  CB  LEU B 173     109.449   4.734  -0.097  1.00 57.52           C  
ATOM   3059  CG  LEU B 173     109.772   5.367  -1.470  1.00 59.09           C  
ATOM   3060  CD1 LEU B 173     110.119   4.327  -2.501  1.00 58.65           C  
ATOM   3061  CD2 LEU B 173     108.593   6.237  -1.952  1.00 59.15           C  
ATOM   3062  N   GLU B 174     109.321   4.559   3.154  1.00 58.12           N  
ATOM   3063  CA  GLU B 174     108.681   4.116   4.375  1.00 59.54           C  
ATOM   3064  C   GLU B 174     108.252   5.305   5.222  1.00 59.78           C  
ATOM   3065  O   GLU B 174     107.145   5.328   5.725  1.00 60.39           O  
ATOM   3066  CB  GLU B 174     109.581   3.198   5.210  1.00 59.45           C  
ATOM   3067  CG  GLU B 174     108.816   2.510   6.345  1.00 58.56           C  
ATOM   3068  CD  GLU B 174     109.675   1.569   7.206  1.00 60.84           C  
ATOM   3069  OE1 GLU B 174     110.934   1.719   7.256  1.00 61.38           O  
ATOM   3070  OE2 GLU B 174     109.076   0.663   7.852  1.00 64.62           O  
ATOM   3071  N   ILE B 175     109.145   6.277   5.372  1.00 59.77           N  
ATOM   3072  CA  ILE B 175     108.854   7.496   6.108  1.00 59.69           C  
ATOM   3073  C   ILE B 175     107.672   8.292   5.545  1.00 60.35           C  
ATOM   3074  O   ILE B 175     106.783   8.674   6.302  1.00 60.74           O  
ATOM   3075  CB  ILE B 175     110.101   8.382   6.221  1.00 59.77           C  
ATOM   3076  CG1 ILE B 175     111.102   7.693   7.154  1.00 57.48           C  
ATOM   3077  CG2 ILE B 175     109.716   9.778   6.682  1.00 57.44           C  
ATOM   3078  CD1 ILE B 175     112.545   8.169   6.948  1.00 54.62           C  
ATOM   3079  N   THR B 176     107.638   8.521   4.237  1.00 60.61           N  
ATOM   3080  CA  THR B 176     106.464   9.183   3.642  1.00 61.32           C  
ATOM   3081  C   THR B 176     105.142   8.405   3.823  1.00 61.98           C  
ATOM   3082  O   THR B 176     104.077   9.009   3.965  1.00 62.30           O  
ATOM   3083  CB  THR B 176     106.683   9.635   2.170  1.00 61.25           C  
ATOM   3084  OG1 THR B 176     106.762   8.505   1.283  1.00 61.96           O  
ATOM   3085  CG2 THR B 176     107.935  10.424   2.073  1.00 59.49           C  
ATOM   3086  N   ALA B 177     105.205   7.075   3.861  1.00 62.90           N  
ATOM   3087  CA  ALA B 177     104.002   6.277   4.114  1.00 63.19           C  
ATOM   3088  C   ALA B 177     103.570   6.464   5.553  1.00 63.64           C  
ATOM   3089  O   ALA B 177     102.384   6.550   5.852  1.00 64.60           O  
ATOM   3090  CB  ALA B 177     104.255   4.798   3.823  1.00 63.21           C  
ATOM   3091  N   ARG B 178     104.539   6.534   6.452  1.00 64.20           N  
ATOM   3092  CA  ARG B 178     104.258   6.709   7.882  1.00 64.57           C  
ATOM   3093  C   ARG B 178     103.527   8.056   8.097  1.00 64.70           C  
ATOM   3094  O   ARG B 178     102.519   8.116   8.814  1.00 64.04           O  
ATOM   3095  CB  ARG B 178     105.571   6.651   8.674  1.00 64.03           C  
ATOM   3096  CG  ARG B 178     105.414   6.693  10.159  1.00 64.42           C  
ATOM   3097  CD  ARG B 178     106.455   5.762  10.833  1.00 65.00           C  
ATOM   3098  NE  ARG B 178     107.768   6.240  10.483  1.00 65.61           N  
ATOM   3099  CZ  ARG B 178     108.887   5.525  10.436  1.00 63.78           C  
ATOM   3100  NH1 ARG B 178     108.908   4.242  10.713  1.00 56.18           N  
ATOM   3101  NH2 ARG B 178     110.009   6.157  10.090  1.00 64.52           N  
ATOM   3102  N   ILE B 179     104.028   9.107   7.446  1.00 63.42           N  
ATOM   3103  CA  ILE B 179     103.408  10.412   7.538  1.00 64.34           C  
ATOM   3104  C   ILE B 179     102.033  10.519   6.818  1.00 64.60           C  
ATOM   3105  O   ILE B 179     101.106  11.173   7.327  1.00 64.76           O  
ATOM   3106  CB  ILE B 179     104.360  11.503   7.008  1.00 64.28           C  
ATOM   3107  CG1 ILE B 179     105.665  11.520   7.815  1.00 64.51           C  
ATOM   3108  CG2 ILE B 179     103.693  12.859   6.999  1.00 63.07           C  
ATOM   3109  CD1 ILE B 179     106.782  12.350   7.058  1.00 64.77           C  
ATOM   3110  N   ALA B 180     101.907   9.901   5.643  1.00 64.20           N  
ATOM   3111  CA  ALA B 180     100.610   9.846   4.961  1.00 64.62           C  
ATOM   3112  C   ALA B 180      99.521   9.246   5.893  1.00 65.07           C  
ATOM   3113  O   ALA B 180      98.364   9.659   5.865  1.00 64.87           O  
ATOM   3114  CB  ALA B 180     100.714   9.043   3.635  1.00 63.71           C  
ATOM   3115  N   HIS B 181      99.916   8.277   6.712  1.00 64.99           N  
ATOM   3116  CA  HIS B 181      99.022   7.610   7.627  1.00 66.10           C  
ATOM   3117  C   HIS B 181      98.613   8.465   8.834  1.00 66.01           C  
ATOM   3118  O   HIS B 181      97.448   8.516   9.196  1.00 65.79           O  
ATOM   3119  CB  HIS B 181      99.658   6.326   8.112  1.00 66.04           C  
ATOM   3120  CG  HIS B 181      98.832   5.619   9.125  1.00 69.26           C  
ATOM   3121  ND1 HIS B 181      97.669   4.952   8.797  1.00 69.29           N  
ATOM   3122  CD2 HIS B 181      98.977   5.496  10.468  1.00 72.87           C  
ATOM   3123  CE1 HIS B 181      97.144   4.433   9.889  1.00 70.51           C  
ATOM   3124  NE2 HIS B 181      97.920   4.746  10.916  1.00 73.87           N  
ATOM   3125  N   GLN B 182      99.586   9.112   9.461  1.00 66.77           N  
ATOM   3126  CA  GLN B 182      99.328  10.170  10.434  1.00 67.49           C  
ATOM   3127  C   GLN B 182      98.356  11.196   9.872  1.00 66.60           C  
ATOM   3128  O   GLN B 182      97.522  11.688  10.608  1.00 67.85           O  
ATOM   3129  CB  GLN B 182     100.637  10.850  10.886  1.00 66.95           C  
ATOM   3130  CG  GLN B 182     101.631   9.876  11.565  1.00 68.37           C  
ATOM   3131  CD  GLN B 182     103.027  10.476  11.824  1.00 69.45           C  
ATOM   3132  OE1 GLN B 182     103.965   9.764  12.171  1.00 74.52           O  
ATOM   3133  NE2 GLN B 182     103.159  11.770  11.663  1.00 73.90           N  
ATOM   3134  N   LEU B 183      98.426  11.492   8.582  1.00 65.95           N  
ATOM   3135  CA  LEU B 183      97.475  12.413   7.971  1.00 66.35           C  
ATOM   3136  C   LEU B 183      96.040  11.878   7.908  1.00 66.32           C  
ATOM   3137  O   LEU B 183      95.097  12.603   8.214  1.00 66.29           O  
ATOM   3138  CB  LEU B 183      97.928  12.857   6.578  1.00 66.42           C  
ATOM   3139  CG  LEU B 183      99.027  13.884   6.536  1.00 68.19           C  
ATOM   3140  CD1 LEU B 183      99.157  14.327   5.103  1.00 72.14           C  
ATOM   3141  CD2 LEU B 183      98.737  15.078   7.446  1.00 70.25           C  
ATOM   3142  N   ASP B 184      95.877  10.630   7.488  1.00 66.06           N  
ATOM   3143  CA  ASP B 184      94.597   9.961   7.582  1.00 67.14           C  
ATOM   3144  C   ASP B 184      94.051   9.953   8.999  1.00 66.87           C  
ATOM   3145  O   ASP B 184      92.873  10.238   9.224  1.00 66.09           O  
ATOM   3146  CB  ASP B 184      94.739   8.507   7.151  1.00 68.23           C  
ATOM   3147  CG  ASP B 184      94.490   8.320   5.699  1.00 69.95           C  
ATOM   3148  OD1 ASP B 184      93.715   9.103   5.091  1.00 71.41           O  
ATOM   3149  OD2 ASP B 184      95.044   7.342   5.187  1.00 76.52           O  
ATOM   3150  N   GLU B 185      94.902   9.611   9.953  1.00 66.75           N  
ATOM   3151  CA  GLU B 185      94.459   9.614  11.331  1.00 68.39           C  
ATOM   3152  C   GLU B 185      93.969  11.013  11.691  1.00 67.47           C  
ATOM   3153  O   GLU B 185      92.873  11.156  12.221  1.00 67.50           O  
ATOM   3154  CB  GLU B 185      95.584   9.243  12.272  1.00 69.13           C  
ATOM   3155  CG  GLU B 185      96.012   7.814  12.215  1.00 73.67           C  
ATOM   3156  CD  GLU B 185      96.748   7.421  13.501  1.00 79.25           C  
ATOM   3157  OE1 GLU B 185      97.708   8.137  13.897  1.00 82.41           O  
ATOM   3158  OE2 GLU B 185      96.353   6.410  14.113  1.00 78.59           O  
ATOM   3159  N   GLU B 186      94.771  12.037  11.397  1.00 66.19           N  
ATOM   3160  CA  GLU B 186      94.384  13.386  11.788  1.00 65.59           C  
ATOM   3161  C   GLU B 186      93.090  13.878  11.127  1.00 64.64           C  
ATOM   3162  O   GLU B 186      92.272  14.523  11.778  1.00 63.79           O  
ATOM   3163  CB  GLU B 186      95.522  14.396  11.626  1.00 65.31           C  
ATOM   3164  CG  GLU B 186      95.090  15.865  11.893  1.00 66.09           C  
ATOM   3165  CD  GLU B 186      94.658  16.162  13.351  1.00 69.81           C  
ATOM   3166  OE1 GLU B 186      94.473  17.365  13.658  1.00 67.87           O  
ATOM   3167  OE2 GLU B 186      94.491  15.213  14.198  1.00 73.71           O  
HETATM 3168  N   MSE B 187      92.906  13.545   9.856  1.00 64.51           N  
HETATM 3169  CA  MSE B 187      91.686  13.883   9.136  1.00 65.16           C  
HETATM 3170  C   MSE B 187      90.493  13.123   9.733  1.00 64.95           C  
HETATM 3171  O   MSE B 187      89.375  13.655   9.796  1.00 65.15           O  
HETATM 3172  CB  MSE B 187      91.812  13.549   7.640  1.00 66.31           C  
HETATM 3173  CG  MSE B 187      92.810  14.361   6.868  1.00 68.87           C  
HETATM 3174 SE   MSE B 187      92.319  16.293   6.834  1.00 82.49          SE  
HETATM 3175  CE  MSE B 187      92.451  16.629   4.804  1.00 73.03           C  
ATOM   3176  N   GLY B 188      90.729  11.873  10.142  1.00 63.72           N  
ATOM   3177  CA  GLY B 188      89.734  11.105  10.879  1.00 63.31           C  
ATOM   3178  C   GLY B 188      89.325  11.818  12.140  1.00 63.36           C  
ATOM   3179  O   GLY B 188      88.137  11.962  12.419  1.00 62.68           O  
ATOM   3180  N   GLU B 189      90.323  12.296  12.881  1.00 64.20           N  
ATOM   3181  CA  GLU B 189      90.098  13.050  14.101  1.00 65.59           C  
ATOM   3182  C   GLU B 189      89.388  14.375  13.874  1.00 65.52           C  
ATOM   3183  O   GLU B 189      88.574  14.759  14.704  1.00 66.06           O  
ATOM   3184  CB  GLU B 189      91.398  13.293  14.864  1.00 65.94           C  
ATOM   3185  CG  GLU B 189      92.157  12.029  15.245  1.00 70.46           C  
ATOM   3186  CD  GLU B 189      91.455  11.212  16.320  1.00 75.91           C  
ATOM   3187  OE1 GLU B 189      90.976  10.097  16.003  1.00 78.46           O  
ATOM   3188  OE2 GLU B 189      91.373  11.690  17.474  1.00 78.09           O  
ATOM   3189  N   ILE B 190      89.696  15.083  12.783  1.00 65.48           N  
ATOM   3190  CA  ILE B 190      89.004  16.342  12.497  1.00 64.90           C  
ATOM   3191  C   ILE B 190      87.505  16.073  12.239  1.00 65.86           C  
ATOM   3192  O   ILE B 190      86.657  16.783  12.768  1.00 65.45           O  
ATOM   3193  CB  ILE B 190      89.678  17.177  11.355  1.00 64.37           C  
ATOM   3194  CG1 ILE B 190      91.030  17.712  11.834  1.00 65.39           C  
ATOM   3195  CG2 ILE B 190      88.801  18.362  10.948  1.00 62.18           C  
ATOM   3196  CD1 ILE B 190      91.968  18.227  10.757  1.00 63.33           C  
ATOM   3197  N   ARG B 191      87.212  15.058  11.432  1.00 66.83           N  
ATOM   3198  CA  ARG B 191      85.851  14.637  11.128  1.00 69.62           C  
ATOM   3199  C   ARG B 191      85.068  14.297  12.409  1.00 71.03           C  
ATOM   3200  O   ARG B 191      83.951  14.779  12.588  1.00 70.89           O  
ATOM   3201  CB  ARG B 191      85.863  13.435  10.153  1.00 69.65           C  
ATOM   3202  CG  ARG B 191      84.509  13.072   9.532  1.00 70.27           C  
ATOM   3203  CD  ARG B 191      83.913  11.773  10.099  1.00 75.03           C  
ATOM   3204  NE  ARG B 191      84.659  10.553   9.745  1.00 78.04           N  
ATOM   3205  CZ  ARG B 191      85.490   9.896  10.580  1.00 80.99           C  
ATOM   3206  NH1 ARG B 191      86.141   8.799  10.186  1.00 81.22           N  
ATOM   3207  NH2 ARG B 191      85.688  10.329  11.817  1.00 79.10           N  
ATOM   3208  N   ASP B 192      85.675  13.485  13.289  1.00 72.92           N  
ATOM   3209  CA  ASP B 192      85.099  13.129  14.599  1.00 74.48           C  
ATOM   3210  C   ASP B 192      84.852  14.357  15.441  1.00 75.93           C  
ATOM   3211  O   ASP B 192      83.742  14.541  15.946  1.00 77.01           O  
ATOM   3212  CB  ASP B 192      86.022  12.211  15.388  1.00 74.26           C  
ATOM   3213  CG  ASP B 192      86.067  10.814  14.829  1.00 75.70           C  
ATOM   3214  OD1 ASP B 192      85.193  10.468  14.010  1.00 74.38           O  
ATOM   3215  OD2 ASP B 192      86.981  10.055  15.207  1.00 78.22           O  
ATOM   3216  N   ASP B 193      85.879  15.190  15.599  1.00 76.64           N  
ATOM   3217  CA  ASP B 193      85.793  16.365  16.449  1.00 77.88           C  
ATOM   3218  C   ASP B 193      84.770  17.376  15.956  1.00 79.17           C  
ATOM   3219  O   ASP B 193      84.295  18.198  16.731  1.00 79.54           O  
ATOM   3220  CB  ASP B 193      87.168  17.019  16.611  1.00 77.24           C  
ATOM   3221  CG  ASP B 193      88.144  16.151  17.421  1.00 77.84           C  
ATOM   3222  OD1 ASP B 193      87.717  15.075  17.936  1.00 78.12           O  
ATOM   3223  OD2 ASP B 193      89.339  16.538  17.535  1.00 74.71           O  
ATOM   3224  N   ILE B 194      84.430  17.321  14.672  1.00 80.83           N  
ATOM   3225  CA  ILE B 194      83.389  18.188  14.144  1.00 82.46           C  
ATOM   3226  C   ILE B 194      82.040  17.653  14.631  1.00 84.13           C  
ATOM   3227  O   ILE B 194      81.308  18.379  15.306  1.00 84.32           O  
ATOM   3228  CB  ILE B 194      83.467  18.360  12.589  1.00 82.07           C  
ATOM   3229  CG1 ILE B 194      84.628  19.284  12.214  1.00 81.81           C  
ATOM   3230  CG2 ILE B 194      82.173  18.942  12.025  1.00 81.78           C  
ATOM   3231  CD1 ILE B 194      85.068  19.159  10.783  1.00 80.67           C  
ATOM   3232  N   GLN B 195      81.748  16.383  14.335  1.00 86.16           N  
ATOM   3233  CA  GLN B 195      80.450  15.786  14.666  1.00 88.63           C  
ATOM   3234  C   GLN B 195      80.190  15.651  16.175  1.00 90.20           C  
ATOM   3235  O   GLN B 195      79.057  15.830  16.623  1.00 90.55           O  
ATOM   3236  CB  GLN B 195      80.188  14.475  13.897  1.00 88.35           C  
ATOM   3237  CG  GLN B 195      81.309  13.439  13.900  1.00 88.46           C  
ATOM   3238  CD  GLN B 195      81.201  12.420  12.738  1.00 89.34           C  
ATOM   3239  OE1 GLN B 195      81.722  11.299  12.824  1.00 89.93           O  
ATOM   3240  NE2 GLN B 195      80.530  12.816  11.650  1.00 89.48           N  
ATOM   3241  N   GLU B 196      81.251  15.355  16.933  1.00 92.14           N  
ATOM   3242  CA  GLU B 196      81.254  15.364  18.409  1.00 93.61           C  
ATOM   3243  C   GLU B 196      80.964  16.758  18.948  1.00 94.65           C  
ATOM   3244  O   GLU B 196      80.205  16.901  19.906  1.00 94.79           O  
ATOM   3245  CB  GLU B 196      82.602  14.847  18.961  1.00 93.53           C  
ATOM   3246  CG  GLU B 196      82.910  15.192  20.441  1.00 93.79           C  
ATOM   3247  CD  GLU B 196      84.412  15.187  20.785  1.00 93.98           C  
ATOM   3248  OE1 GLU B 196      85.015  16.291  20.930  1.00 93.92           O  
ATOM   3249  OE2 GLU B 196      84.987  14.079  20.908  1.00 93.90           O  
ATOM   3250  N   ALA B 197      81.567  17.780  18.336  1.00 96.11           N  
ATOM   3251  CA  ALA B 197      81.354  19.175  18.744  1.00 97.62           C  
ATOM   3252  C   ALA B 197      79.945  19.666  18.395  1.00 98.82           C  
ATOM   3253  O   ALA B 197      79.664  20.868  18.428  1.00 99.10           O  
ATOM   3254  CB  ALA B 197      82.414  20.096  18.134  1.00 97.50           C  
ATOM   3255  N   GLN B 198      79.068  18.725  18.054  1.00100.08           N  
ATOM   3256  CA  GLN B 198      77.663  19.015  17.808  1.00101.40           C  
ATOM   3257  C   GLN B 198      76.768  18.001  18.538  1.00101.87           C  
ATOM   3258  O   GLN B 198      75.756  18.381  19.145  1.00101.89           O  
ATOM   3259  CB  GLN B 198      77.377  19.041  16.299  1.00101.50           C  
ATOM   3260  CG  GLN B 198      78.024  20.234  15.565  1.00102.11           C  
ATOM   3261  CD  GLN B 198      77.846  20.187  14.049  1.00102.20           C  
ATOM   3262  OE1 GLN B 198      77.929  19.122  13.421  1.00102.79           O  
ATOM   3263  NE2 GLN B 198      77.613  21.352  13.453  1.00103.19           N  
ATOM   3264  N   ALA B 199      77.176  16.726  18.501  1.00102.51           N  
ATOM   3265  CA  ALA B 199      76.417  15.595  19.065  1.00103.03           C  
ATOM   3266  C   ALA B 199      76.293  15.564  20.601  1.00103.48           C  
ATOM   3267  O   ALA B 199      75.229  15.213  21.127  1.00103.56           O  
ATOM   3268  CB  ALA B 199      76.976  14.266  18.549  1.00102.85           C  
ATOM   3269  N   LEU B 200      77.369  15.916  21.312  1.00103.90           N  
ATOM   3270  CA  LEU B 200      77.387  15.778  22.775  1.00104.18           C  
ATOM   3271  C   LEU B 200      77.337  17.116  23.537  1.00104.46           C  
ATOM   3272  O   LEU B 200      76.957  17.146  24.713  1.00104.48           O  
ATOM   3273  CB  LEU B 200      78.526  14.840  23.244  1.00104.06           C  
ATOM   3274  CG  LEU B 200      79.863  15.263  23.861  1.00103.70           C  
ATOM   3275  CD1 LEU B 200      80.649  14.038  24.277  1.00103.59           C  
ATOM   3276  CD2 LEU B 200      80.685  16.066  22.912  1.00104.58           C  
ATOM   3277  N   PHE B 201      77.713  18.206  22.864  1.00104.82           N  
ATOM   3278  CA  PHE B 201      77.532  19.570  23.397  1.00105.21           C  
ATOM   3279  C   PHE B 201      77.301  20.604  22.288  1.00105.24           C  
ATOM   3280  O   PHE B 201      76.265  20.603  21.618  1.00105.23           O  
ATOM   3281  CB  PHE B 201      78.703  19.999  24.297  1.00105.30           C  
ATOM   3282  CG  PHE B 201      80.037  19.998  23.604  1.00106.03           C  
ATOM   3283  CD1 PHE B 201      80.354  20.976  22.664  1.00106.55           C  
ATOM   3284  CD2 PHE B 201      80.987  19.026  23.906  1.00106.70           C  
ATOM   3285  CE1 PHE B 201      81.591  20.973  22.020  1.00106.83           C  
ATOM   3286  CE2 PHE B 201      82.228  19.011  23.270  1.00106.77           C  
ATOM   3287  CZ  PHE B 201      82.531  19.986  22.326  1.00106.79           C  
TER    3288      PHE B 201                                                      
END
MOLECULE T0460.pdb
ATOM      1  N   MET     1      79.050 -11.695  -3.149  1.00  0.00           N
ATOM      2  CA  MET     1      79.035 -10.947  -4.424  1.00  0.00           C
ATOM      3  C   MET     1      80.358 -11.127  -5.155  1.00  0.00           C
ATOM      4  O   MET     1      81.385 -11.403  -4.535  1.00  0.00           O
ATOM      5  CB  MET     1      78.786  -9.452  -4.173  1.00  0.00           C
ATOM      6  CG  MET     1      80.015  -8.686  -3.690  1.00  0.00           C
ATOM      7  SD  MET     1      80.670  -9.303  -2.126  1.00  0.00           S
ATOM      8  CE  MET     1      82.239  -8.439  -2.056  1.00  0.00           C
ATOM      9  HA  MET     1      78.240 -11.341  -5.040  1.00  0.00           H
ATOM     10  HB1 MET     1      78.012  -9.350  -3.427  1.00  0.00           H
ATOM     11  HB2 MET     1      78.447  -8.997  -5.092  1.00  0.00           H
ATOM     12  HG1 MET     1      79.746  -7.646  -3.565  1.00  0.00           H
ATOM     13  HG2 MET     1      80.787  -8.766  -4.440  1.00  0.00           H
ATOM     14  HE1 MET     1      82.759  -8.708  -1.149  1.00  0.00           H
ATOM     15  HE2 MET     1      82.063  -7.374  -2.069  1.00  0.00           H
ATOM     16  HE3 MET     1      82.839  -8.715  -2.910  1.00  0.00           H
ATOM     17  HT1 MET     1      79.122 -12.720  -3.335  1.00  0.00           H
ATOM     18  HT2 MET     1      78.173 -11.510  -2.615  1.00  0.00           H
ATOM     19  HT3 MET     1      79.863 -11.402  -2.571  1.00  0.00           H
ATOM     20  N   ASN     2      80.328 -10.981  -6.468  1.00  0.00           N
ATOM     21  CA  ASN     2      81.547 -11.002  -7.265  1.00  0.00           C
ATOM     22  C   ASN     2      82.085  -9.588  -7.431  1.00  0.00           C
ATOM     23  O   ASN     2      81.383  -8.614  -7.154  1.00  0.00           O
ATOM     24  CB  ASN     2      81.291 -11.625  -8.642  1.00  0.00           C
ATOM     25  CG  ASN     2      81.062 -13.122  -8.572  1.00  0.00           C
ATOM     26  ND2 ASN     2      82.123 -13.896  -8.751  1.00  0.00           N
ATOM     27  OD1 ASN     2      79.938 -13.582  -8.369  1.00  0.00           O
ATOM     28  HN  ASN     2      79.462 -10.866  -6.918  1.00  0.00           H
ATOM     29  HA  ASN     2      82.279 -11.595  -6.738  1.00  0.00           H
ATOM     30  HB1 ASN     2      82.146 -11.440  -9.276  1.00  0.00           H
ATOM     31  HB2 ASN     2      80.418 -11.167  -9.081  1.00  0.00           H
ATOM     32 HD21 ASN     2      82.998 -13.465  -8.919  1.00  0.00           H
ATOM     33 HD22 ASN     2      81.999 -14.867  -8.716  1.00  0.00           H
ATOM     34  N   SER     3      83.324  -9.479  -7.883  1.00  0.00           N
ATOM     35  CA  SER     3      83.958  -8.185  -8.112  1.00  0.00           C
ATOM     36  C   SER     3      83.225  -7.422  -9.210  1.00  0.00           C
ATOM     37  O   SER     3      83.208  -6.191  -9.230  1.00  0.00           O
ATOM     38  CB  SER     3      85.418  -8.390  -8.506  1.00  0.00           C
ATOM     39  OG  SER     3      86.042  -9.316  -7.636  1.00  0.00           O
ATOM     40  HN  SER     3      83.845 -10.304  -8.058  1.00  0.00           H
ATOM     41  HA  SER     3      83.911  -7.619  -7.193  1.00  0.00           H
ATOM     42  HB1 SER     3      85.943  -7.447  -8.447  1.00  0.00           H
ATOM     43  HB2 SER     3      85.469  -8.770  -9.515  1.00  0.00           H
ATOM     44  HG  SER     3      85.679 -10.203  -7.801  1.00  0.00           H
ATOM     45  N   GLU     4      82.609  -8.178 -10.111  1.00  0.00           N
ATOM     46  CA  GLU     4      81.831  -7.614 -11.202  1.00  0.00           C
ATOM     47  C   GLU     4      80.642  -6.825 -10.650  1.00  0.00           C
ATOM     48  O   GLU     4      80.244  -5.805 -11.209  1.00  0.00           O
ATOM     49  CB  GLU     4      81.365  -8.747 -12.119  1.00  0.00           C
ATOM     50  CG  GLU     4      80.777  -8.287 -13.440  1.00  0.00           C
ATOM     51  CD  GLU     4      80.576  -9.439 -14.402  1.00  0.00           C
ATOM     52  OE1 GLU     4      81.532  -9.780 -15.131  1.00  0.00           O
ATOM     53  OE2 GLU     4      79.470 -10.016 -14.432  1.00  0.00           O
ATOM     54  HN  GLU     4      82.686  -9.152 -10.040  1.00  0.00           H
ATOM     55  HA  GLU     4      82.470  -6.945 -11.758  1.00  0.00           H
ATOM     56  HB1 GLU     4      80.615  -9.326 -11.600  1.00  0.00           H
ATOM     57  HB2 GLU     4      82.209  -9.385 -12.335  1.00  0.00           H
ATOM     58  HG1 GLU     4      81.447  -7.571 -13.891  1.00  0.00           H
ATOM     59  HG2 GLU     4      79.821  -7.819 -13.254  1.00  0.00           H
ATOM     60  N   VAL     5      80.108  -7.289  -9.524  1.00  0.00           N
ATOM     61  CA  VAL     5      79.007  -6.610  -8.848  1.00  0.00           C
ATOM     62  C   VAL     5      79.475  -5.264  -8.302  1.00  0.00           C
ATOM     63  O   VAL     5      78.759  -4.265  -8.377  1.00  0.00           O
ATOM     64  CB  VAL     5      78.447  -7.466  -7.689  1.00  0.00           C
ATOM     65  CG1 VAL     5      77.344  -6.727  -6.941  1.00  0.00           C
ATOM     66  CG2 VAL     5      77.942  -8.805  -8.212  1.00  0.00           C
ATOM     67  HN  VAL     5      80.471  -8.109  -9.133  1.00  0.00           H
ATOM     68  HA  VAL     5      78.219  -6.446  -9.569  1.00  0.00           H
ATOM     69  HB  VAL     5      79.251  -7.659  -6.994  1.00  0.00           H
ATOM     70 HG11 VAL     5      77.750  -5.829  -6.493  1.00  0.00           H
ATOM     71 HG12 VAL     5      76.946  -7.365  -6.165  1.00  0.00           H
ATOM     72 HG13 VAL     5      76.555  -6.462  -7.628  1.00  0.00           H
ATOM     73 HG21 VAL     5      77.543  -9.385  -7.393  1.00  0.00           H
ATOM     74 HG22 VAL     5      78.761  -9.343  -8.667  1.00  0.00           H
ATOM     75 HG23 VAL     5      77.169  -8.639  -8.948  1.00  0.00           H
ATOM     76  N   ILE     6      80.694  -5.245  -7.776  1.00  0.00           N
ATOM     77  CA  ILE     6      81.274  -4.028  -7.224  1.00  0.00           C
ATOM     78  C   ILE     6      81.443  -2.976  -8.316  1.00  0.00           C
ATOM     79  O   ILE     6      81.180  -1.795  -8.100  1.00  0.00           O
ATOM     80  CB  ILE     6      82.640  -4.309  -6.559  1.00  0.00           C
ATOM     81  CG1 ILE     6      82.489  -5.388  -5.484  1.00  0.00           C
ATOM     82  CG2 ILE     6      83.216  -3.033  -5.956  1.00  0.00           C
ATOM     83  CD1 ILE     6      83.796  -5.789  -4.833  1.00  0.00           C
ATOM     84  HN  ILE     6      81.218  -6.074  -7.760  1.00  0.00           H
ATOM     85  HA  ILE     6      80.598  -3.649  -6.472  1.00  0.00           H
ATOM     86  HB  ILE     6      83.321  -4.659  -7.320  1.00  0.00           H
ATOM     87 HG11 ILE     6      82.056  -6.272  -5.931  1.00  0.00           H
ATOM     88 HG12 ILE     6      81.832  -5.025  -4.709  1.00  0.00           H
ATOM     89 HG21 ILE     6      84.169  -3.252  -5.495  1.00  0.00           H
ATOM     90 HG22 ILE     6      82.536  -2.647  -5.211  1.00  0.00           H
ATOM     91 HG23 ILE     6      83.354  -2.296  -6.734  1.00  0.00           H
ATOM     92 HD11 ILE     6      84.243  -4.927  -4.361  1.00  0.00           H
ATOM     93 HD12 ILE     6      84.469  -6.177  -5.584  1.00  0.00           H
ATOM     94 HD13 ILE     6      83.609  -6.549  -4.090  1.00  0.00           H
ATOM     95  N   LYS     7      81.858  -3.421  -9.496  1.00  0.00           N
ATOM     96  CA  LYS     7      82.045  -2.525 -10.632  1.00  0.00           C
ATOM     97  C   LYS     7      80.717  -1.908 -11.058  1.00  0.00           C
ATOM     98  O   LYS     7      80.646  -0.718 -11.373  1.00  0.00           O
ATOM     99  CB  LYS     7      82.684  -3.278 -11.799  1.00  0.00           C
ATOM    100  CG  LYS     7      84.053  -3.847 -11.466  1.00  0.00           C
ATOM    101  CD  LYS     7      84.677  -4.564 -12.652  1.00  0.00           C
ATOM    102  CE  LYS     7      86.074  -5.055 -12.312  1.00  0.00           C
ATOM    103  NZ  LYS     7      86.763  -5.669 -13.478  1.00  0.00           N
ATOM    104  HN  LYS     7      82.047  -4.378  -9.606  1.00  0.00           H
ATOM    105  HA  LYS     7      82.710  -1.733 -10.320  1.00  0.00           H
ATOM    106  HB1 LYS     7      82.790  -2.603 -12.636  1.00  0.00           H
ATOM    107  HB2 LYS     7      82.038  -4.095 -12.084  1.00  0.00           H
ATOM    108  HG1 LYS     7      83.950  -4.546 -10.649  1.00  0.00           H
ATOM    109  HG2 LYS     7      84.703  -3.039 -11.168  1.00  0.00           H
ATOM    110  HD1 LYS     7      84.736  -3.880 -13.485  1.00  0.00           H
ATOM    111  HD2 LYS     7      84.062  -5.410 -12.917  1.00  0.00           H
ATOM    112  HE1 LYS     7      86.000  -5.788 -11.523  1.00  0.00           H
ATOM    113  HE2 LYS     7      86.659  -4.216 -11.965  1.00  0.00           H
ATOM    114  HZ1 LYS     7      86.652  -5.068 -14.322  1.00  0.00           H
ATOM    115  HZ2 LYS     7      86.372  -6.612 -13.682  1.00  0.00           H
ATOM    116  HZ3 LYS     7      87.785  -5.766 -13.275  1.00  0.00           H
ATOM    117  N   GLU     8      79.664  -2.718 -11.043  1.00  0.00           N
ATOM    118  CA  GLU     8      78.325  -2.243 -11.373  1.00  0.00           C
ATOM    119  C   GLU     8      77.814  -1.282 -10.302  1.00  0.00           C
ATOM    120  O   GLU     8      77.136  -0.301 -10.605  1.00  0.00           O
ATOM    121  CB  GLU     8      77.368  -3.423 -11.525  1.00  0.00           C
ATOM    122  CG  GLU     8      77.750  -4.366 -12.653  1.00  0.00           C
ATOM    123  CD  GLU     8      77.825  -3.668 -13.993  1.00  0.00           C
ATOM    124  OE1 GLU     8      76.763  -3.424 -14.599  1.00  0.00           O
ATOM    125  OE2 GLU     8      78.946  -3.366 -14.455  1.00  0.00           O
ATOM    126  HN  GLU     8      79.792  -3.664 -10.813  1.00  0.00           H
ATOM    127  HA  GLU     8      78.385  -1.715 -12.313  1.00  0.00           H
ATOM    128  HB1 GLU     8      76.375  -3.046 -11.720  1.00  0.00           H
ATOM    129  HB2 GLU     8      77.357  -3.984 -10.602  1.00  0.00           H
ATOM    130  HG1 GLU     8      77.011  -5.153 -12.713  1.00  0.00           H
ATOM    131  HG2 GLU     8      78.716  -4.797 -12.434  1.00  0.00           H
ATOM    132  N   PHE     9      78.149  -1.567  -9.050  1.00  0.00           N
ATOM    133  CA  PHE     9      77.794  -0.688  -7.944  1.00  0.00           C
ATOM    134  C   PHE     9      78.456   0.677  -8.120  1.00  0.00           C
ATOM    135  O   PHE     9      77.824   1.717  -7.926  1.00  0.00           O
ATOM    136  CB  PHE     9      78.210  -1.318  -6.610  1.00  0.00           C
ATOM    137  CG  PHE     9      77.882  -0.479  -5.405  1.00  0.00           C
ATOM    138  CD1 PHE     9      76.570  -0.341  -4.977  1.00  0.00           C
ATOM    139  CD2 PHE     9      78.885   0.166  -4.699  1.00  0.00           C
ATOM    140  CE1 PHE     9      76.267   0.423  -3.866  1.00  0.00           C
ATOM    141  CE2 PHE     9      78.587   0.931  -3.588  1.00  0.00           C
ATOM    142  CZ  PHE     9      77.276   1.061  -3.172  1.00  0.00           C
ATOM    143  HN  PHE     9      78.638  -2.400  -8.864  1.00  0.00           H
ATOM    144  HA  PHE     9      76.721  -0.559  -7.954  1.00  0.00           H
ATOM    145  HB1 PHE     9      79.279  -1.481  -6.619  1.00  0.00           H
ATOM    146  HB2 PHE     9      77.710  -2.268  -6.497  1.00  0.00           H
ATOM    147  HD1 PHE     9      75.781  -0.839  -5.519  1.00  0.00           H
ATOM    148  HD2 PHE     9      79.910   0.065  -5.024  1.00  0.00           H
ATOM    149  HE1 PHE     9      75.242   0.523  -3.542  1.00  0.00           H
ATOM    150  HE2 PHE     9      79.378   1.428  -3.048  1.00  0.00           H
ATOM    151  HZ  PHE     9      77.042   1.659  -2.304  1.00  0.00           H
ATOM    152  N   LEU    10      79.729   0.661  -8.505  1.00  0.00           N
ATOM    153  CA  LEU    10      80.478   1.889  -8.756  1.00  0.00           C
ATOM    154  C   LEU    10      79.896   2.640  -9.949  1.00  0.00           C
ATOM    155  O   LEU    10      79.919   3.871  -9.992  1.00  0.00           O
ATOM    156  CB  LEU    10      81.954   1.571  -9.004  1.00  0.00           C
ATOM    157  CG  LEU    10      82.680   0.902  -7.834  1.00  0.00           C
ATOM    158  CD1 LEU    10      84.099   0.532  -8.231  1.00  0.00           C
ATOM    159  CD2 LEU    10      82.688   1.812  -6.615  1.00  0.00           C
ATOM    160  HN  LEU    10      80.183  -0.205  -8.617  1.00  0.00           H
ATOM    161  HA  LEU    10      80.394   2.513  -7.878  1.00  0.00           H
ATOM    162  HB1 LEU    10      82.465   2.494  -9.236  1.00  0.00           H
ATOM    163  HB2 LEU    10      82.019   0.917  -9.862  1.00  0.00           H
ATOM    164  HG  LEU    10      82.160  -0.007  -7.569  1.00  0.00           H
ATOM    165 HD11 LEU    10      84.591   0.050  -7.399  1.00  0.00           H
ATOM    166 HD12 LEU    10      84.642   1.425  -8.502  1.00  0.00           H
ATOM    167 HD13 LEU    10      84.074  -0.144  -9.073  1.00  0.00           H
ATOM    168 HD21 LEU    10      81.672   2.025  -6.320  1.00  0.00           H
ATOM    169 HD22 LEU    10      83.194   2.735  -6.857  1.00  0.00           H
ATOM    170 HD23 LEU    10      83.204   1.322  -5.803  1.00  0.00           H
ATOM    171  N   GLU    11      79.369   1.888 -10.907  1.00  0.00           N
ATOM    172  CA  GLU    11      78.721   2.469 -12.075  1.00  0.00           C
ATOM    173  C   GLU    11      77.494   3.274 -11.656  1.00  0.00           C
ATOM    174  O   GLU    11      77.310   4.415 -12.085  1.00  0.00           O
ATOM    175  CB  GLU    11      78.310   1.365 -13.051  1.00  0.00           C
ATOM    176  CG  GLU    11      77.572   1.874 -14.276  1.00  0.00           C
ATOM    177  CD  GLU    11      76.949   0.756 -15.083  1.00  0.00           C
ATOM    178  OE1 GLU    11      77.548   0.346 -16.099  1.00  0.00           O
ATOM    179  OE2 GLU    11      75.857   0.283 -14.707  1.00  0.00           O
ATOM    180  HN  GLU    11      79.422   0.912 -10.828  1.00  0.00           H
ATOM    181  HA  GLU    11      79.427   3.127 -12.560  1.00  0.00           H
ATOM    182  HB1 GLU    11      77.668   0.667 -12.535  1.00  0.00           H
ATOM    183  HB2 GLU    11      79.197   0.845 -13.383  1.00  0.00           H
ATOM    184  HG1 GLU    11      78.269   2.407 -14.905  1.00  0.00           H
ATOM    185  HG2 GLU    11      76.788   2.546 -13.957  1.00  0.00           H
ATOM    186  N   ASP    12      76.669   2.677 -10.802  1.00  0.00           N
ATOM    187  CA  ASP    12      75.439   3.316 -10.347  1.00  0.00           C
ATOM    188  C   ASP    12      75.738   4.578  -9.548  1.00  0.00           C
ATOM    189  O   ASP    12      75.213   5.649  -9.849  1.00  0.00           O
ATOM    190  CB  ASP    12      74.609   2.353  -9.498  1.00  0.00           C
ATOM    191  CG  ASP    12      73.317   2.984  -9.007  1.00  0.00           C
ATOM    192  OD1 ASP    12      73.279   3.459  -7.850  1.00  0.00           O
ATOM    193  OD2 ASP    12      72.333   3.007  -9.776  1.00  0.00           O
ATOM    194  HN  ASP    12      76.891   1.778 -10.474  1.00  0.00           H
ATOM    195  HA  ASP    12      74.870   3.589 -11.223  1.00  0.00           H
ATOM    196  HB1 ASP    12      75.188   2.048  -8.639  1.00  0.00           H
ATOM    197  HB2 ASP    12      74.362   1.483 -10.088  1.00  0.00           H
ATOM    198  N   ILE    13      76.595   4.453  -8.540  1.00  0.00           N
ATOM    199  CA  ILE    13      76.907   5.584  -7.671  1.00  0.00           C
ATOM    200  C   ILE    13      77.674   6.668  -8.427  1.00  0.00           C
ATOM    201  O   ILE    13      77.589   7.849  -8.088  1.00  0.00           O
ATOM    202  CB  ILE    13      77.706   5.161  -6.418  1.00  0.00           C
ATOM    203  CG1 ILE    13      79.052   4.538  -6.806  1.00  0.00           C
ATOM    204  CG2 ILE    13      76.889   4.187  -5.579  1.00  0.00           C
ATOM    205  CD1 ILE    13      79.922   4.187  -5.619  1.00  0.00           C
ATOM    206  HN  ILE    13      77.023   3.583  -8.375  1.00  0.00           H
ATOM    207  HA  ILE    13      75.967   6.004  -7.339  1.00  0.00           H
ATOM    208  HB  ILE    13      77.886   6.043  -5.823  1.00  0.00           H
ATOM    209 HG11 ILE    13      79.598   5.237  -7.424  1.00  0.00           H
ATOM    210 HG12 ILE    13      78.874   3.633  -7.366  1.00  0.00           H
ATOM    211 HG21 ILE    13      75.974   4.665  -5.265  1.00  0.00           H
ATOM    212 HG22 ILE    13      77.459   3.894  -4.709  1.00  0.00           H
ATOM    213 HG23 ILE    13      76.654   3.312  -6.167  1.00  0.00           H
ATOM    214 HD11 ILE    13      79.407   3.471  -4.995  1.00  0.00           H
ATOM    215 HD12 ILE    13      80.129   5.081  -5.048  1.00  0.00           H
ATOM    216 HD13 ILE    13      80.850   3.760  -5.968  1.00  0.00           H
ATOM    217  N   GLY    14      78.408   6.263  -9.456  1.00  0.00           N
ATOM    218  CA  GLY    14      79.141   7.215 -10.265  1.00  0.00           C
ATOM    219  C   GLY    14      80.552   7.430  -9.769  1.00  0.00           C
ATOM    220  O   GLY    14      80.941   8.554  -9.443  1.00  0.00           O
ATOM    221  HN  GLY    14      78.456   5.306  -9.666  1.00  0.00           H
ATOM    222  HA1 GLY    14      78.618   8.159 -10.252  1.00  0.00           H
ATOM    223  HA2 GLY    14      79.178   6.852 -11.282  1.00  0.00           H
ATOM    224  N   GLU    15      81.322   6.354  -9.705  1.00  0.00           N
ATOM    225  CA  GLU    15      82.699   6.435  -9.253  1.00  0.00           C
ATOM    226  C   GLU    15      83.602   5.599 -10.157  1.00  0.00           C
ATOM    227  O   GLU    15      83.174   4.583 -10.703  1.00  0.00           O
ATOM    228  CB  GLU    15      82.806   5.961  -7.801  1.00  0.00           C
ATOM    229  CG  GLU    15      84.159   6.241  -7.173  1.00  0.00           C
ATOM    230  CD  GLU    15      84.554   7.698  -7.295  1.00  0.00           C
ATOM    231  OE1 GLU    15      84.244   8.485  -6.382  1.00  0.00           O
ATOM    232  OE2 GLU    15      85.172   8.066  -8.313  1.00  0.00           O
ATOM    233  HN  GLU    15      80.955   5.482  -9.973  1.00  0.00           H
ATOM    234  HA  GLU    15      83.007   7.467  -9.310  1.00  0.00           H
ATOM    235  HB1 GLU    15      82.629   4.896  -7.767  1.00  0.00           H
ATOM    236  HB2 GLU    15      82.050   6.462  -7.214  1.00  0.00           H
ATOM    237  HG1 GLU    15      84.905   5.637  -7.668  1.00  0.00           H
ATOM    238  HG2 GLU    15      84.119   5.980  -6.125  1.00  0.00           H
ATOM    239  N   ASP    16      84.843   6.040 -10.317  1.00  0.00           N
ATOM    240  CA  ASP    16      85.801   5.346 -11.170  1.00  0.00           C
ATOM    241  C   ASP    16      86.675   4.412 -10.347  1.00  0.00           C
ATOM    242  O   ASP    16      87.091   4.753  -9.239  1.00  0.00           O
ATOM    243  CB  ASP    16      86.693   6.344 -11.919  1.00  0.00           C
ATOM    244  CG  ASP    16      85.940   7.165 -12.945  1.00  0.00           C
ATOM    245  OD1 ASP    16      85.679   6.650 -14.054  1.00  0.00           O
ATOM    246  OD2 ASP    16      85.624   8.342 -12.659  1.00  0.00           O
ATOM    247  HN  ASP    16      85.132   6.847  -9.829  1.00  0.00           H
ATOM    248  HA  ASP    16      85.245   4.763 -11.888  1.00  0.00           H
ATOM    249  HB1 ASP    16      87.477   5.800 -12.427  1.00  0.00           H
ATOM    250  HB2 ASP    16      87.139   7.020 -11.206  1.00  0.00           H
ATOM    251  N   TYR    17      86.952   3.234 -10.885  1.00  0.00           N
ATOM    252  CA  TYR    17      87.833   2.289 -10.217  1.00  0.00           C
ATOM    253  C   TYR    17      89.127   2.120 -11.002  1.00  0.00           C
ATOM    254  O   TYR    17      89.125   2.132 -12.236  1.00  0.00           O
ATOM    255  CB  TYR    17      87.143   0.928 -10.018  1.00  0.00           C
ATOM    256  CG  TYR    17      86.803   0.188 -11.297  1.00  0.00           C
ATOM    257  CD1 TYR    17      87.708  -0.694 -11.876  1.00  0.00           C
ATOM    258  CD2 TYR    17      85.574   0.364 -11.919  1.00  0.00           C
ATOM    259  CE1 TYR    17      87.400  -1.374 -13.038  1.00  0.00           C
ATOM    260  CE2 TYR    17      85.259  -0.312 -13.081  1.00  0.00           C
ATOM    261  CZ  TYR    17      86.175  -1.178 -13.636  1.00  0.00           C
ATOM    262  OH  TYR    17      85.867  -1.853 -14.793  1.00  0.00           O
ATOM    263  HN  TYR    17      86.553   2.995 -11.754  1.00  0.00           H
ATOM    264  HA  TYR    17      88.073   2.701  -9.247  1.00  0.00           H
ATOM    265  HB1 TYR    17      86.223   1.082  -9.472  1.00  0.00           H
ATOM    266  HB2 TYR    17      87.793   0.291  -9.438  1.00  0.00           H
ATOM    267  HD1 TYR    17      88.669  -0.843 -11.406  1.00  0.00           H
ATOM    268  HD2 TYR    17      84.858   1.045 -11.484  1.00  0.00           H
ATOM    269  HE1 TYR    17      88.118  -2.055 -13.472  1.00  0.00           H
ATOM    270  HE2 TYR    17      84.299  -0.158 -13.552  1.00  0.00           H
ATOM    271  HH  TYR    17      85.586  -1.222 -15.473  1.00  0.00           H
ATOM    272  N   ILE    18      90.233   1.985 -10.289  1.00  0.00           N
ATOM    273  CA  ILE    18      91.519   1.746 -10.923  1.00  0.00           C
ATOM    274  C   ILE    18      91.884   0.273 -10.811  1.00  0.00           C
ATOM    275  O   ILE    18      92.389  -0.177  -9.779  1.00  0.00           O
ATOM    276  CB  ILE    18      92.639   2.607 -10.294  1.00  0.00           C
ATOM    277  CG1 ILE    18      92.263   4.091 -10.350  1.00  0.00           C
ATOM    278  CG2 ILE    18      93.965   2.361 -11.008  1.00  0.00           C
ATOM    279  CD1 ILE    18      93.276   5.001  -9.687  1.00  0.00           C
ATOM    280  HN  ILE    18      90.185   2.044  -9.310  1.00  0.00           H
ATOM    281  HA  ILE    18      91.430   2.008 -11.968  1.00  0.00           H
ATOM    282  HB  ILE    18      92.752   2.310  -9.263  1.00  0.00           H
ATOM    283 HG11 ILE    18      91.313   4.236  -9.854  1.00  0.00           H
ATOM    284 HG12 ILE    18      92.173   4.394 -11.382  1.00  0.00           H
ATOM    285 HG21 ILE    18      94.230   1.317 -10.926  1.00  0.00           H
ATOM    286 HG22 ILE    18      94.736   2.964 -10.552  1.00  0.00           H
ATOM    287 HG23 ILE    18      93.868   2.628 -12.050  1.00  0.00           H
ATOM    288 HD11 ILE    18      94.235   4.884 -10.171  1.00  0.00           H
ATOM    289 HD12 ILE    18      93.365   4.739  -8.643  1.00  0.00           H
ATOM    290 HD13 ILE    18      92.951   6.026  -9.775  1.00  0.00           H
ATOM    291  N   GLU    19      91.597  -0.484 -11.858  1.00  0.00           N
ATOM    292  CA  GLU    19      91.879  -1.909 -11.854  1.00  0.00           C
ATOM    293  C   GLU    19      93.199  -2.201 -12.553  1.00  0.00           C
ATOM    294  O   GLU    19      93.394  -1.864 -13.719  1.00  0.00           O
ATOM    295  CB  GLU    19      90.742  -2.691 -12.512  1.00  0.00           C
ATOM    296  CG  GLU    19      90.972  -4.194 -12.522  1.00  0.00           C
ATOM    297  CD  GLU    19      89.744  -4.969 -12.942  1.00  0.00           C
ATOM    298  OE1 GLU    19      89.106  -5.595 -12.074  1.00  0.00           O
ATOM    299  OE2 GLU    19      89.400  -4.949 -14.138  1.00  0.00           O
ATOM    300  HN  GLU    19      91.189  -0.076 -12.650  1.00  0.00           H
ATOM    301  HA  GLU    19      91.963  -2.219 -10.824  1.00  0.00           H
ATOM    302  HB1 GLU    19      90.634  -2.358 -13.534  1.00  0.00           H
ATOM    303  HB2 GLU    19      89.824  -2.492 -11.978  1.00  0.00           H
ATOM    304  HG1 GLU    19      91.255  -4.509 -11.528  1.00  0.00           H
ATOM    305  HG2 GLU    19      91.771  -4.418 -13.211  1.00  0.00           H
ATOM    306  N   LEU    20      94.101  -2.825 -11.820  1.00  0.00           N
ATOM    307  CA  LEU    20      95.411  -3.188 -12.336  1.00  0.00           C
ATOM    308  C   LEU    20      95.509  -4.694 -12.516  1.00  0.00           C
ATOM    309  O   LEU    20      96.579  -5.280 -12.343  1.00  0.00           O
ATOM    310  CB  LEU    20      96.492  -2.712 -11.372  1.00  0.00           C
ATOM    311  CG  LEU    20      96.595  -1.197 -11.206  1.00  0.00           C
ATOM    312  CD1 LEU    20      97.650  -0.856 -10.175  1.00  0.00           C
ATOM    313  CD2 LEU    20      96.918  -0.531 -12.536  1.00  0.00           C
ATOM    314  HN  LEU    20      93.879  -3.048 -10.886  1.00  0.00           H
ATOM    315  HA  LEU    20      95.546  -2.704 -13.292  1.00  0.00           H
ATOM    316  HB1 LEU    20      97.443  -3.081 -11.722  1.00  0.00           H
ATOM    317  HB2 LEU    20      96.292  -3.146 -10.403  1.00  0.00           H
ATOM    318  HG  LEU    20      95.647  -0.813 -10.858  1.00  0.00           H
ATOM    319 HD11 LEU    20      97.386  -1.306  -9.231  1.00  0.00           H
ATOM    320 HD12 LEU    20      97.707   0.216 -10.061  1.00  0.00           H
ATOM    321 HD13 LEU    20      98.606  -1.236 -10.501  1.00  0.00           H
ATOM    322 HD21 LEU    20      96.134  -0.744 -13.246  1.00  0.00           H
ATOM    323 HD22 LEU    20      97.856  -0.914 -12.910  1.00  0.00           H
ATOM    324 HD23 LEU    20      96.996   0.537 -12.393  1.00  0.00           H
ATOM    325  N   GLU    21      94.380  -5.299 -12.879  1.00  0.00           N
ATOM    326  CA  GLU    21      94.267  -6.748 -13.046  1.00  0.00           C
ATOM    327  C   GLU    21      94.352  -7.446 -11.688  1.00  0.00           C
ATOM    328  O   GLU    21      95.436  -7.595 -11.119  1.00  0.00           O
ATOM    329  CB  GLU    21      95.344  -7.280 -14.001  1.00  0.00           C
ATOM    330  CG  GLU    21      95.273  -8.777 -14.241  1.00  0.00           C
ATOM    331  CD  GLU    21      96.444  -9.284 -15.052  1.00  0.00           C
ATOM    332  OE1 GLU    21      96.316  -9.392 -16.290  1.00  0.00           O
ATOM    333  OE2 GLU    21      97.504  -9.567 -14.457  1.00  0.00           O
ATOM    334  HN  GLU    21      93.589  -4.745 -13.040  1.00  0.00           H
ATOM    335  HA  GLU    21      93.294  -6.950 -13.470  1.00  0.00           H
ATOM    336  HB1 GLU    21      96.316  -7.049 -13.592  1.00  0.00           H
ATOM    337  HB2 GLU    21      95.239  -6.783 -14.953  1.00  0.00           H
ATOM    338  HG1 GLU    21      94.360  -9.002 -14.773  1.00  0.00           H
ATOM    339  HG2 GLU    21      95.269  -9.283 -13.287  1.00  0.00           H
ATOM    340  N   ASN    22      93.189  -7.837 -11.166  1.00  0.00           N
ATOM    341  CA  ASN    22      93.078  -8.474  -9.846  1.00  0.00           C
ATOM    342  C   ASN    22      93.396  -7.502  -8.713  1.00  0.00           C
ATOM    343  O   ASN    22      93.421  -7.889  -7.547  1.00  0.00           O
ATOM    344  CB  ASN    22      93.960  -9.722  -9.738  1.00  0.00           C
ATOM    345  CG  ASN    22      93.296 -10.956 -10.318  1.00  0.00           C
ATOM    346  ND2 ASN    22      92.574 -11.688  -9.483  1.00  0.00           N
ATOM    347  OD1 ASN    22      93.433 -11.252 -11.506  1.00  0.00           O
ATOM    348  HN  ASN    22      92.369  -7.700 -11.690  1.00  0.00           H
ATOM    349  HA  ASN    22      92.047  -8.781  -9.735  1.00  0.00           H
ATOM    350  HB1 ASN    22      94.182  -9.910  -8.696  1.00  0.00           H
ATOM    351  HB2 ASN    22      94.883  -9.549 -10.272  1.00  0.00           H
ATOM    352 HD21 ASN    22      92.510 -11.398  -8.547  1.00  0.00           H
ATOM    353 HD22 ASN    22      92.135 -12.494  -9.830  1.00  0.00           H
ATOM    354  N   GLU    23      93.644  -6.246  -9.052  1.00  0.00           N
ATOM    355  CA  GLU    23      93.790  -5.203  -8.050  1.00  0.00           C
ATOM    356  C   GLU    23      92.906  -4.019  -8.387  1.00  0.00           C
ATOM    357  O   GLU    23      93.123  -3.343  -9.389  1.00  0.00           O
ATOM    358  CB  GLU    23      95.235  -4.721  -7.932  1.00  0.00           C
ATOM    359  CG  GLU    23      96.160  -5.681  -7.209  1.00  0.00           C
ATOM    360  CD  GLU    23      97.204  -4.948  -6.391  1.00  0.00           C
ATOM    361  OE1 GLU    23      97.607  -3.832  -6.789  1.00  0.00           O
ATOM    362  OE2 GLU    23      97.613  -5.477  -5.338  1.00  0.00           O
ATOM    363  HN  GLU    23      93.742  -6.016 -10.001  1.00  0.00           H
ATOM    364  HA  GLU    23      93.477  -5.610  -7.100  1.00  0.00           H
ATOM    365  HB1 GLU    23      95.244  -3.781  -7.400  1.00  0.00           H
ATOM    366  HB2 GLU    23      95.628  -4.562  -8.924  1.00  0.00           H
ATOM    367  HG1 GLU    23      96.663  -6.298  -7.939  1.00  0.00           H
ATOM    368  HG2 GLU    23      95.575  -6.303  -6.549  1.00  0.00           H
ATOM    369  N   ILE    24      91.914  -3.768  -7.556  1.00  0.00           N
ATOM    370  CA  ILE    24      91.066  -2.605  -7.729  1.00  0.00           C
ATOM    371  C   ILE    24      91.413  -1.561  -6.677  1.00  0.00           C
ATOM    372  O   ILE    24      91.059  -1.697  -5.510  1.00  0.00           O
ATOM    373  CB  ILE    24      89.562  -2.955  -7.645  1.00  0.00           C
ATOM    374  CG1 ILE    24      89.185  -3.949  -8.747  1.00  0.00           C
ATOM    375  CG2 ILE    24      88.717  -1.693  -7.763  1.00  0.00           C
ATOM    376  CD1 ILE    24      87.729  -4.367  -8.726  1.00  0.00           C
ATOM    377  HN  ILE    24      91.755  -4.374  -6.799  1.00  0.00           H
ATOM    378  HA  ILE    24      91.266  -2.193  -8.708  1.00  0.00           H
ATOM    379  HB  ILE    24      89.369  -3.403  -6.681  1.00  0.00           H
ATOM    380 HG11 ILE    24      89.789  -4.839  -8.643  1.00  0.00           H
ATOM    381 HG12 ILE    24      89.384  -3.498  -9.708  1.00  0.00           H
ATOM    382 HG21 ILE    24      88.924  -1.211  -8.707  1.00  0.00           H
ATOM    383 HG22 ILE    24      88.959  -1.019  -6.954  1.00  0.00           H
ATOM    384 HG23 ILE    24      87.670  -1.954  -7.714  1.00  0.00           H
ATOM    385 HD11 ILE    24      87.103  -3.497  -8.852  1.00  0.00           H
ATOM    386 HD12 ILE    24      87.504  -4.838  -7.780  1.00  0.00           H
ATOM    387 HD13 ILE    24      87.543  -5.064  -9.529  1.00  0.00           H
ATOM    388  N   HIS    25      92.144  -0.542  -7.088  1.00  0.00           N
ATOM    389  CA  HIS    25      92.526   0.527  -6.182  1.00  0.00           C
ATOM    390  C   HIS    25      91.439   1.587  -6.172  1.00  0.00           C
ATOM    391  O   HIS    25      91.096   2.144  -7.216  1.00  0.00           O
ATOM    392  CB  HIS    25      93.873   1.134  -6.589  1.00  0.00           C
ATOM    393  CG  HIS    25      95.041   0.205  -6.402  1.00  0.00           C
ATOM    394  CD2 HIS    25      95.404  -0.919  -7.071  1.00  0.00           C
ATOM    395  ND1 HIS    25      96.004   0.396  -5.436  1.00  0.00           N
ATOM    396  CE1 HIS    25      96.909  -0.563  -5.520  1.00  0.00           C
ATOM    397  NE2 HIS    25      96.569  -1.376  -6.501  1.00  0.00           N
ATOM    398  HN  HIS    25      92.410  -0.490  -8.034  1.00  0.00           H
ATOM    399  HA  HIS    25      92.612   0.106  -5.190  1.00  0.00           H
ATOM    400  HB1 HIS    25      94.054   2.017  -5.993  1.00  0.00           H
ATOM    401  HB2 HIS    25      93.835   1.412  -7.631  1.00  0.00           H
ATOM    402  HD1 HIS    25      96.018   1.130  -4.771  1.00  0.00           H
ATOM    403  HD2 HIS    25      94.874  -1.374  -7.896  1.00  0.00           H
ATOM    404  HE1 HIS    25      97.782  -0.661  -4.892  1.00  0.00           H
ATOM    405  HE2 HIS    25      96.985  -2.261  -6.674  1.00  0.00           H
ATOM    406  N   LEU    26      90.879   1.840  -5.001  1.00  0.00           N
ATOM    407  CA  LEU    26      89.762   2.762  -4.884  1.00  0.00           C
ATOM    408  C   LEU    26      90.109   3.953  -4.011  1.00  0.00           C
ATOM    409  O   LEU    26      91.168   4.005  -3.386  1.00  0.00           O
ATOM    410  CB  LEU    26      88.533   2.051  -4.314  1.00  0.00           C
ATOM    411  CG  LEU    26      87.850   1.068  -5.264  1.00  0.00           C
ATOM    412  CD1 LEU    26      86.659   0.416  -4.586  1.00  0.00           C
ATOM    413  CD2 LEU    26      87.409   1.775  -6.535  1.00  0.00           C
ATOM    414  HN  LEU    26      91.231   1.403  -4.192  1.00  0.00           H
ATOM    415  HA  LEU    26      89.526   3.118  -5.874  1.00  0.00           H
ATOM    416  HB1 LEU    26      87.810   2.801  -4.028  1.00  0.00           H
ATOM    417  HB2 LEU    26      88.835   1.511  -3.427  1.00  0.00           H
ATOM    418  HG  LEU    26      88.551   0.292  -5.537  1.00  0.00           H
ATOM    419 HD11 LEU    26      86.993  -0.119  -3.710  1.00  0.00           H
ATOM    420 HD12 LEU    26      86.189  -0.274  -5.271  1.00  0.00           H
ATOM    421 HD13 LEU    26      85.949   1.177  -4.295  1.00  0.00           H
ATOM    422 HD21 LEU    26      86.713   2.563  -6.285  1.00  0.00           H
ATOM    423 HD22 LEU    26      86.927   1.066  -7.192  1.00  0.00           H
ATOM    424 HD23 LEU    26      88.269   2.199  -7.031  1.00  0.00           H
ATOM    425  N   LYS    27      89.202   4.913  -3.989  1.00  0.00           N
ATOM    426  CA  LYS    27      89.343   6.080  -3.143  1.00  0.00           C
ATOM    427  C   LYS    27      88.919   5.729  -1.721  1.00  0.00           C
ATOM    428  O   LYS    27      87.907   5.059  -1.526  1.00  0.00           O
ATOM    429  CB  LYS    27      88.492   7.224  -3.694  1.00  0.00           C
ATOM    430  CG  LYS    27      88.868   7.625  -5.111  1.00  0.00           C
ATOM    431  CD  LYS    27      87.841   8.566  -5.712  1.00  0.00           C
ATOM    432  CE  LYS    27      88.221   8.967  -7.127  1.00  0.00           C
ATOM    433  NZ  LYS    27      87.143   9.743  -7.789  1.00  0.00           N
ATOM    434  HN  LYS    27      88.410   4.828  -4.555  1.00  0.00           H
ATOM    435  HA  LYS    27      90.381   6.373  -3.143  1.00  0.00           H
ATOM    436  HB1 LYS    27      88.610   8.086  -3.054  1.00  0.00           H
ATOM    437  HB2 LYS    27      87.454   6.922  -3.691  1.00  0.00           H
ATOM    438  HG1 LYS    27      88.930   6.736  -5.722  1.00  0.00           H
ATOM    439  HG2 LYS    27      89.828   8.120  -5.093  1.00  0.00           H
ATOM    440  HD1 LYS    27      87.776   9.454  -5.100  1.00  0.00           H
ATOM    441  HD2 LYS    27      86.882   8.070  -5.735  1.00  0.00           H
ATOM    442  HE1 LYS    27      88.415   8.073  -7.699  1.00  0.00           H
ATOM    443  HE2 LYS    27      89.115   9.571  -7.087  1.00  0.00           H
ATOM    444  HZ1 LYS    27      86.938  10.612  -7.254  1.00  0.00           H
ATOM    445  HZ2 LYS    27      86.273   9.167  -7.846  1.00  0.00           H
ATOM    446  HZ3 LYS    27      87.428  10.000  -8.759  1.00  0.00           H
ATOM    447  N   PRO    28      89.696   6.170  -0.720  1.00  0.00           N
ATOM    448  CA  PRO    28      89.474   5.825   0.696  1.00  0.00           C
ATOM    449  C   PRO    28      88.033   6.021   1.167  1.00  0.00           C
ATOM    450  O   PRO    28      87.481   5.163   1.856  1.00  0.00           O
ATOM    451  CB  PRO    28      90.422   6.770   1.431  1.00  0.00           C
ATOM    452  CG  PRO    28      91.524   7.005   0.463  1.00  0.00           C
ATOM    453  CD  PRO    28      90.878   7.033  -0.892  1.00  0.00           C
ATOM    454  HA  PRO    28      89.766   4.807   0.895  1.00  0.00           H
ATOM    455  HB1 PRO    28      90.783   6.297   2.333  1.00  0.00           H
ATOM    456  HB2 PRO    28      89.905   7.687   1.679  1.00  0.00           H
ATOM    457  HG1 PRO    28      92.242   6.200   0.519  1.00  0.00           H
ATOM    458  HG2 PRO    28      92.001   7.952   0.671  1.00  0.00           H
ATOM    459  HD1 PRO    28      91.545   6.627  -1.636  1.00  0.00           H
ATOM    460  HD2 PRO    28      90.586   8.041  -1.151  1.00  0.00           H
ATOM    461  N   GLU    29      87.422   7.135   0.788  1.00  0.00           N
ATOM    462  CA  GLU    29      86.054   7.419   1.200  1.00  0.00           C
ATOM    463  C   GLU    29      85.073   6.444   0.550  1.00  0.00           C
ATOM    464  O   GLU    29      84.103   6.016   1.175  1.00  0.00           O
ATOM    465  CB  GLU    29      85.685   8.865   0.873  1.00  0.00           C
ATOM    466  CG  GLU    29      86.489   9.876   1.673  1.00  0.00           C
ATOM    467  CD  GLU    29      86.039  11.300   1.443  1.00  0.00           C
ATOM    468  OE1 GLU    29      84.991  11.692   1.999  1.00  0.00           O
ATOM    469  OE2 GLU    29      86.732  12.035   0.709  1.00  0.00           O
ATOM    470  HN  GLU    29      87.900   7.780   0.227  1.00  0.00           H
ATOM    471  HA  GLU    29      86.004   7.282   2.271  1.00  0.00           H
ATOM    472  HB1 GLU    29      84.638   9.017   1.089  1.00  0.00           H
ATOM    473  HB2 GLU    29      85.860   9.043  -0.176  1.00  0.00           H
ATOM    474  HG1 GLU    29      87.529   9.793   1.391  1.00  0.00           H
ATOM    475  HG2 GLU    29      86.386   9.649   2.724  1.00  0.00           H
ATOM    476  N   VAL    30      85.347   6.078  -0.697  1.00  0.00           N
ATOM    477  CA  VAL    30      84.527   5.102  -1.405  1.00  0.00           C
ATOM    478  C   VAL    30      84.710   3.721  -0.782  1.00  0.00           C
ATOM    479  O   VAL    30      83.743   2.995  -0.550  1.00  0.00           O
ATOM    480  CB  VAL    30      84.898   5.033  -2.904  1.00  0.00           C
ATOM    481  CG1 VAL    30      83.962   4.095  -3.653  1.00  0.00           C
ATOM    482  CG2 VAL    30      84.883   6.420  -3.526  1.00  0.00           C
ATOM    483  HN  VAL    30      86.121   6.468  -1.148  1.00  0.00           H
ATOM    484  HA  VAL    30      83.493   5.400  -1.317  1.00  0.00           H
ATOM    485  HB  VAL    30      85.901   4.638  -2.985  1.00  0.00           H
ATOM    486 HG11 VAL    30      82.948   4.455  -3.568  1.00  0.00           H
ATOM    487 HG12 VAL    30      84.031   3.103  -3.229  1.00  0.00           H
ATOM    488 HG13 VAL    30      84.246   4.061  -4.695  1.00  0.00           H
ATOM    489 HG21 VAL    30      85.145   6.349  -4.571  1.00  0.00           H
ATOM    490 HG22 VAL    30      85.597   7.050  -3.017  1.00  0.00           H
ATOM    491 HG23 VAL    30      83.895   6.848  -3.432  1.00  0.00           H
ATOM    492  N   PHE    31      85.966   3.390  -0.497  1.00  0.00           N
ATOM    493  CA  PHE    31      86.329   2.113   0.106  1.00  0.00           C
ATOM    494  C   PHE    31      85.578   1.891   1.414  1.00  0.00           C
ATOM    495  O   PHE    31      85.038   0.815   1.649  1.00  0.00           O
ATOM    496  CB  PHE    31      87.841   2.073   0.352  1.00  0.00           C
ATOM    497  CG  PHE    31      88.334   0.813   1.008  1.00  0.00           C
ATOM    498  CD1 PHE    31      88.583   0.776   2.372  1.00  0.00           C
ATOM    499  CD2 PHE    31      88.557  -0.332   0.261  1.00  0.00           C
ATOM    500  CE1 PHE    31      89.046  -0.377   2.976  1.00  0.00           C
ATOM    501  CE2 PHE    31      89.020  -1.487   0.860  1.00  0.00           C
ATOM    502  CZ  PHE    31      89.262  -1.511   2.219  1.00  0.00           C
ATOM    503  HN  PHE    31      86.681   4.033  -0.706  1.00  0.00           H
ATOM    504  HA  PHE    31      86.064   1.328  -0.587  1.00  0.00           H
ATOM    505  HB1 PHE    31      88.113   2.905   0.984  1.00  0.00           H
ATOM    506  HB2 PHE    31      88.352   2.170  -0.594  1.00  0.00           H
ATOM    507  HD1 PHE    31      88.413   1.662   2.966  1.00  0.00           H
ATOM    508  HD2 PHE    31      88.368  -0.316  -0.802  1.00  0.00           H
ATOM    509  HE1 PHE    31      89.237  -0.392   4.039  1.00  0.00           H
ATOM    510  HE2 PHE    31      89.188  -2.372   0.267  1.00  0.00           H
ATOM    511  HZ  PHE    31      89.623  -2.414   2.688  1.00  0.00           H
ATOM    512  N   TYR    32      85.540   2.923   2.250  1.00  0.00           N
ATOM    513  CA  TYR    32      84.882   2.843   3.552  1.00  0.00           C
ATOM    514  C   TYR    32      83.410   2.455   3.407  1.00  0.00           C
ATOM    515  O   TYR    32      82.882   1.665   4.196  1.00  0.00           O
ATOM    516  CB  TYR    32      85.004   4.184   4.283  1.00  0.00           C
ATOM    517  CG  TYR    32      84.435   4.177   5.685  1.00  0.00           C
ATOM    518  CD1 TYR    32      85.166   3.661   6.748  1.00  0.00           C
ATOM    519  CD2 TYR    32      83.168   4.688   5.948  1.00  0.00           C
ATOM    520  CE1 TYR    32      84.654   3.655   8.030  1.00  0.00           C
ATOM    521  CE2 TYR    32      82.650   4.685   7.228  1.00  0.00           C
ATOM    522  CZ  TYR    32      83.397   4.168   8.265  1.00  0.00           C
ATOM    523  OH  TYR    32      82.884   4.162   9.543  1.00  0.00           O
ATOM    524  HN  TYR    32      85.973   3.765   1.986  1.00  0.00           H
ATOM    525  HA  TYR    32      85.387   2.083   4.130  1.00  0.00           H
ATOM    526  HB1 TYR    32      84.483   4.942   3.716  1.00  0.00           H
ATOM    527  HB2 TYR    32      86.048   4.451   4.354  1.00  0.00           H
ATOM    528  HD1 TYR    32      86.151   3.260   6.561  1.00  0.00           H
ATOM    529  HD2 TYR    32      82.586   5.092   5.134  1.00  0.00           H
ATOM    530  HE1 TYR    32      85.238   3.249   8.843  1.00  0.00           H
ATOM    531  HE2 TYR    32      81.666   5.087   7.414  1.00  0.00           H
ATOM    532  HH  TYR    32      83.527   4.544  10.152  1.00  0.00           H
ATOM    533  N   GLU    33      82.758   3.000   2.389  1.00  0.00           N
ATOM    534  CA  GLU    33      81.341   2.740   2.160  1.00  0.00           C
ATOM    535  C   GLU    33      81.130   1.360   1.543  1.00  0.00           C
ATOM    536  O   GLU    33      80.223   0.628   1.941  1.00  0.00           O
ATOM    537  CB  GLU    33      80.739   3.825   1.265  1.00  0.00           C
ATOM    538  CG  GLU    33      80.828   5.220   1.868  1.00  0.00           C
ATOM    539  CD  GLU    33      80.167   6.277   1.009  1.00  0.00           C
ATOM    540  OE1 GLU    33      78.946   6.495   1.163  1.00  0.00           O
ATOM    541  OE2 GLU    33      80.862   6.898   0.182  1.00  0.00           O
ATOM    542  HN  GLU    33      83.240   3.591   1.773  1.00  0.00           H
ATOM    543  HA  GLU    33      80.846   2.767   3.118  1.00  0.00           H
ATOM    544  HB1 GLU    33      79.698   3.597   1.091  1.00  0.00           H
ATOM    545  HB2 GLU    33      81.261   3.830   0.319  1.00  0.00           H
ATOM    546  HG1 GLU    33      81.870   5.478   1.992  1.00  0.00           H
ATOM    547  HG2 GLU    33      80.345   5.211   2.834  1.00  0.00           H
ATOM    548  N   VAL    34      81.976   1.002   0.582  1.00  0.00           N
ATOM    549  CA  VAL    34      81.895  -0.306  -0.064  1.00  0.00           C
ATOM    550  C   VAL    34      82.212  -1.418   0.936  1.00  0.00           C
ATOM    551  O   VAL    34      81.594  -2.484   0.911  1.00  0.00           O
ATOM    552  CB  VAL    34      82.852  -0.402  -1.274  1.00  0.00           C
ATOM    553  CG1 VAL    34      82.813  -1.789  -1.898  1.00  0.00           C
ATOM    554  CG2 VAL    34      82.507   0.654  -2.313  1.00  0.00           C
ATOM    555  HN  VAL    34      82.671   1.636   0.295  1.00  0.00           H
ATOM    556  HA  VAL    34      80.883  -0.437  -0.421  1.00  0.00           H
ATOM    557  HB  VAL    34      83.859  -0.216  -0.927  1.00  0.00           H
ATOM    558 HG11 VAL    34      81.808  -2.005  -2.230  1.00  0.00           H
ATOM    559 HG12 VAL    34      83.114  -2.522  -1.164  1.00  0.00           H
ATOM    560 HG13 VAL    34      83.487  -1.824  -2.741  1.00  0.00           H
ATOM    561 HG21 VAL    34      81.497   0.499  -2.662  1.00  0.00           H
ATOM    562 HG22 VAL    34      83.191   0.577  -3.145  1.00  0.00           H
ATOM    563 HG23 VAL    34      82.588   1.636  -1.870  1.00  0.00           H
ATOM    564  N   TRP    35      83.161  -1.146   1.823  1.00  0.00           N
ATOM    565  CA  TRP    35      83.542  -2.082   2.873  1.00  0.00           C
ATOM    566  C   TRP    35      82.322  -2.505   3.686  1.00  0.00           C
ATOM    567  O   TRP    35      82.034  -3.693   3.808  1.00  0.00           O
ATOM    568  CB  TRP    35      84.602  -1.436   3.775  1.00  0.00           C
ATOM    569  CG  TRP    35      85.005  -2.264   4.959  1.00  0.00           C
ATOM    570  CD1 TRP    35      85.361  -3.583   4.965  1.00  0.00           C
ATOM    571  CD2 TRP    35      85.114  -1.813   6.313  1.00  0.00           C
ATOM    572  CE2 TRP    35      85.530  -2.911   7.088  1.00  0.00           C
ATOM    573  CE3 TRP    35      84.896  -0.586   6.945  1.00  0.00           C
ATOM    574  NE1 TRP    35      85.671  -3.981   6.245  1.00  0.00           N
ATOM    575  CZ2 TRP    35      85.732  -2.818   8.463  1.00  0.00           C
ATOM    576  CZ3 TRP    35      85.098  -0.493   8.309  1.00  0.00           C
ATOM    577  CH2 TRP    35      85.513  -1.602   9.056  1.00  0.00           C
ATOM    578  HN  TRP    35      83.633  -0.284   1.763  1.00  0.00           H
ATOM    579  HA  TRP    35      83.965  -2.955   2.401  1.00  0.00           H
ATOM    580  HB1 TRP    35      84.220  -0.494   4.141  1.00  0.00           H
ATOM    581  HB2 TRP    35      85.488  -1.250   3.190  1.00  0.00           H
ATOM    582  HD1 TRP    35      85.382  -4.212   4.088  1.00  0.00           H
ATOM    583  HE1 TRP    35      85.953  -4.887   6.512  1.00  0.00           H
ATOM    584  HE3 TRP    35      84.576   0.281   6.386  1.00  0.00           H
ATOM    585  HZ2 TRP    35      86.054  -3.664   9.053  1.00  0.00           H
ATOM    586  HZ3 TRP    35      84.937   0.448   8.812  1.00  0.00           H
ATOM    587  HH2 TRP    35      85.662  -1.482  10.119  1.00  0.00           H
ATOM    588  N   LYS    36      81.586  -1.533   4.206  1.00  0.00           N
ATOM    589  CA  LYS    36      80.399  -1.828   5.002  1.00  0.00           C
ATOM    590  C   LYS    36      79.260  -2.348   4.126  1.00  0.00           C
ATOM    591  O   LYS    36      78.403  -3.098   4.594  1.00  0.00           O
ATOM    592  CB  LYS    36      79.953  -0.591   5.784  1.00  0.00           C
ATOM    593  CG  LYS    36      80.897  -0.222   6.917  1.00  0.00           C
ATOM    594  CD  LYS    36      80.401   0.988   7.689  1.00  0.00           C
ATOM    595  CE  LYS    36      81.248   1.248   8.925  1.00  0.00           C
ATOM    596  NZ  LYS    36      81.114   0.164   9.937  1.00  0.00           N
ATOM    597  HN  LYS    36      81.846  -0.599   4.055  1.00  0.00           H
ATOM    598  HA  LYS    36      80.668  -2.602   5.707  1.00  0.00           H
ATOM    599  HB1 LYS    36      78.976  -0.778   6.205  1.00  0.00           H
ATOM    600  HB2 LYS    36      79.891   0.248   5.106  1.00  0.00           H
ATOM    601  HG1 LYS    36      81.870   0.001   6.501  1.00  0.00           H
ATOM    602  HG2 LYS    36      80.977  -1.061   7.593  1.00  0.00           H
ATOM    603  HD1 LYS    36      79.379   0.814   7.994  1.00  0.00           H
ATOM    604  HD2 LYS    36      80.443   1.856   7.047  1.00  0.00           H
ATOM    605  HE1 LYS    36      80.936   2.183   9.368  1.00  0.00           H
ATOM    606  HE2 LYS    36      82.283   1.321   8.627  1.00  0.00           H
ATOM    607  HZ1 LYS    36      80.115   0.047  10.208  1.00  0.00           H
ATOM    608  HZ2 LYS    36      81.663   0.395  10.792  1.00  0.00           H
ATOM    609  HZ3 LYS    36      81.462  -0.745   9.550  1.00  0.00           H
ATOM    610  N   TYR    37      79.266  -1.964   2.853  1.00  0.00           N
ATOM    611  CA  TYR    37      78.242  -2.413   1.913  1.00  0.00           C
ATOM    612  C   TYR    37      78.298  -3.927   1.726  1.00  0.00           C
ATOM    613  O   TYR    37      77.264  -4.588   1.634  1.00  0.00           O
ATOM    614  CB  TYR    37      78.406  -1.716   0.556  1.00  0.00           C
ATOM    615  CG  TYR    37      77.396  -2.161  -0.482  1.00  0.00           C
ATOM    616  CD1 TYR    37      76.055  -1.823  -0.358  1.00  0.00           C
ATOM    617  CD2 TYR    37      77.780  -2.927  -1.581  1.00  0.00           C
ATOM    618  CE1 TYR    37      75.127  -2.229  -1.295  1.00  0.00           C
ATOM    619  CE2 TYR    37      76.856  -3.335  -2.522  1.00  0.00           C
ATOM    620  CZ  TYR    37      75.532  -2.986  -2.372  1.00  0.00           C
ATOM    621  OH  TYR    37      74.607  -3.393  -3.306  1.00  0.00           O
ATOM    622  HN  TYR    37      79.970  -1.356   2.540  1.00  0.00           H
ATOM    623  HA  TYR    37      77.280  -2.152   2.326  1.00  0.00           H
ATOM    624  HB1 TYR    37      79.393  -1.922   0.170  1.00  0.00           H
ATOM    625  HB2 TYR    37      78.294  -0.650   0.691  1.00  0.00           H
ATOM    626  HD1 TYR    37      75.739  -1.229   0.487  1.00  0.00           H
ATOM    627  HD2 TYR    37      78.817  -3.203  -1.696  1.00  0.00           H
ATOM    628  HE1 TYR    37      74.089  -1.955  -1.181  1.00  0.00           H
ATOM    629  HE2 TYR    37      77.171  -3.927  -3.367  1.00  0.00           H
ATOM    630  HH  TYR    37      73.956  -2.689  -3.441  1.00  0.00           H
ATOM    631  N   VAL    38      79.506  -4.475   1.689  1.00  0.00           N
ATOM    632  CA  VAL    38      79.686  -5.905   1.458  1.00  0.00           C
ATOM    633  C   VAL    38      79.653  -6.699   2.765  1.00  0.00           C
ATOM    634  O   VAL    38      79.971  -7.888   2.789  1.00  0.00           O
ATOM    635  CB  VAL    38      81.001  -6.196   0.702  1.00  0.00           C
ATOM    636  CG1 VAL    38      81.012  -5.474  -0.636  1.00  0.00           C
ATOM    637  CG2 VAL    38      82.215  -5.804   1.531  1.00  0.00           C
ATOM    638  HN  VAL    38      80.297  -3.903   1.812  1.00  0.00           H
ATOM    639  HA  VAL    38      78.866  -6.237   0.836  1.00  0.00           H
ATOM    640  HB  VAL    38      81.052  -7.258   0.510  1.00  0.00           H
ATOM    641 HG11 VAL    38      80.930  -4.409  -0.471  1.00  0.00           H
ATOM    642 HG12 VAL    38      80.177  -5.810  -1.232  1.00  0.00           H
ATOM    643 HG13 VAL    38      81.935  -5.689  -1.153  1.00  0.00           H
ATOM    644 HG21 VAL    38      82.172  -4.749   1.757  1.00  0.00           H
ATOM    645 HG22 VAL    38      83.115  -6.015   0.973  1.00  0.00           H
ATOM    646 HG23 VAL    38      82.220  -6.369   2.451  1.00  0.00           H
ATOM    647  N   GLY    39      79.262  -6.038   3.848  1.00  0.00           N
ATOM    648  CA  GLY    39      79.115  -6.724   5.120  1.00  0.00           C
ATOM    649  C   GLY    39      80.299  -6.518   6.042  1.00  0.00           C
ATOM    650  O   GLY    39      80.380  -7.155   7.092  1.00  0.00           O
ATOM    651  HN  GLY    39      79.063  -5.079   3.783  1.00  0.00           H
ATOM    652  HA1 GLY    39      78.998  -7.781   4.933  1.00  0.00           H
ATOM    653  HA2 GLY    39      78.226  -6.357   5.610  1.00  0.00           H
ATOM    654  N   GLU    40      81.202  -5.620   5.634  1.00  0.00           N
ATOM    655  CA  GLU    40      82.411  -5.254   6.392  1.00  0.00           C
ATOM    656  C   GLU    40      83.104  -6.457   7.049  1.00  0.00           C
ATOM    657  O   GLU    40      82.915  -6.742   8.234  1.00  0.00           O
ATOM    658  CB  GLU    40      82.119  -4.141   7.416  1.00  0.00           C
ATOM    659  CG  GLU    40      80.963  -4.427   8.361  1.00  0.00           C
ATOM    660  CD  GLU    40      80.687  -3.288   9.318  1.00  0.00           C
ATOM    661  OE1 GLU    40      79.668  -3.354  10.040  1.00  0.00           O
ATOM    662  OE2 GLU    40      81.475  -2.326   9.355  1.00  0.00           O
ATOM    663  HN  GLU    40      81.055  -5.176   4.772  1.00  0.00           H
ATOM    664  HA  GLU    40      83.104  -4.851   5.668  1.00  0.00           H
ATOM    665  HB1 GLU    40      81.894  -3.231   6.877  1.00  0.00           H
ATOM    666  HB2 GLU    40      83.004  -3.979   8.012  1.00  0.00           H
ATOM    667  HG1 GLU    40      81.198  -5.311   8.936  1.00  0.00           H
ATOM    668  HG2 GLU    40      80.074  -4.606   7.776  1.00  0.00           H
ATOM    669  N   PRO    41      83.907  -7.191   6.263  1.00  0.00           N
ATOM    670  CA  PRO    41      84.705  -8.305   6.762  1.00  0.00           C
ATOM    671  C   PRO    41      86.072  -7.844   7.267  1.00  0.00           C
ATOM    672  O   PRO    41      86.316  -6.643   7.414  1.00  0.00           O
ATOM    673  CB  PRO    41      84.855  -9.179   5.521  1.00  0.00           C
ATOM    674  CG  PRO    41      84.890  -8.212   4.382  1.00  0.00           C
ATOM    675  CD  PRO    41      84.092  -7.002   4.811  1.00  0.00           C
ATOM    676  HA  PRO    41      84.192  -8.852   7.539  1.00  0.00           H
ATOM    677  HB1 PRO    41      84.011  -9.848   5.444  1.00  0.00           H
ATOM    678  HB2 PRO    41      85.771  -9.748   5.587  1.00  0.00           H
ATOM    679  HG1 PRO    41      84.442  -8.662   3.508  1.00  0.00           H
ATOM    680  HG2 PRO    41      85.910  -7.928   4.175  1.00  0.00           H
ATOM    681  HD1 PRO    41      83.138  -6.981   4.303  1.00  0.00           H
ATOM    682  HD2 PRO    41      84.645  -6.097   4.610  1.00  0.00           H
ATOM    683  N   GLU    42      86.961  -8.795   7.525  1.00  0.00           N
ATOM    684  CA  GLU    42      88.301  -8.472   7.992  1.00  0.00           C
ATOM    685  C   GLU    42      89.161  -7.955   6.846  1.00  0.00           C
ATOM    686  O   GLU    42      89.141  -8.501   5.740  1.00  0.00           O
ATOM    687  CB  GLU    42      88.960  -9.693   8.633  1.00  0.00           C
ATOM    688  CG  GLU    42      88.249 -10.184   9.883  1.00  0.00           C
ATOM    689  CD  GLU    42      88.097  -9.101  10.931  1.00  0.00           C
ATOM    690  OE1 GLU    42      89.039  -8.304  11.117  1.00  0.00           O
ATOM    691  OE2 GLU    42      87.036  -9.051  11.588  1.00  0.00           O
ATOM    692  HN  GLU    42      86.714  -9.732   7.394  1.00  0.00           H
ATOM    693  HA  GLU    42      88.211  -7.693   8.735  1.00  0.00           H
ATOM    694  HB1 GLU    42      89.976  -9.439   8.899  1.00  0.00           H
ATOM    695  HB2 GLU    42      88.975 -10.499   7.914  1.00  0.00           H
ATOM    696  HG1 GLU    42      88.819 -10.999  10.307  1.00  0.00           H
ATOM    697  HG2 GLU    42      87.266 -10.539   9.608  1.00  0.00           H
ATOM    698  N   LEU    43      89.907  -6.899   7.121  1.00  0.00           N
ATOM    699  CA  LEU    43      90.763  -6.281   6.122  1.00  0.00           C
ATOM    700  C   LEU    43      92.193  -6.783   6.254  1.00  0.00           C
ATOM    701  O   LEU    43      92.667  -7.072   7.356  1.00  0.00           O
ATOM    702  CB  LEU    43      90.723  -4.759   6.265  1.00  0.00           C
ATOM    703  CG  LEU    43      89.357  -4.117   6.007  1.00  0.00           C
ATOM    704  CD1 LEU    43      89.415  -2.618   6.255  1.00  0.00           C
ATOM    705  CD2 LEU    43      88.897  -4.400   4.585  1.00  0.00           C
ATOM    706  HN  LEU    43      89.886  -6.522   8.031  1.00  0.00           H
ATOM    707  HA  LEU    43      90.385  -6.553   5.149  1.00  0.00           H
ATOM    708  HB1 LEU    43      91.431  -4.336   5.569  1.00  0.00           H
ATOM    709  HB2 LEU    43      91.033  -4.505   7.268  1.00  0.00           H
ATOM    710  HG  LEU    43      88.632  -4.542   6.685  1.00  0.00           H
ATOM    711 HD11 LEU    43      90.136  -2.169   5.588  1.00  0.00           H
ATOM    712 HD12 LEU    43      89.707  -2.433   7.278  1.00  0.00           H
ATOM    713 HD13 LEU    43      88.441  -2.185   6.076  1.00  0.00           H
ATOM    714 HD21 LEU    43      87.932  -3.945   4.422  1.00  0.00           H
ATOM    715 HD22 LEU    43      88.820  -5.468   4.438  1.00  0.00           H
ATOM    716 HD23 LEU    43      89.612  -3.991   3.888  1.00  0.00           H
ATOM    717  N   LYS    44      92.878  -6.886   5.127  1.00  0.00           N
ATOM    718  CA  LYS    44      94.247  -7.368   5.107  1.00  0.00           C
ATOM    719  C   LYS    44      95.186  -6.227   4.732  1.00  0.00           C
ATOM    720  O   LYS    44      95.083  -5.653   3.648  1.00  0.00           O
ATOM    721  CB  LYS    44      94.367  -8.531   4.116  1.00  0.00           C
ATOM    722  CG  LYS    44      95.676  -9.296   4.206  1.00  0.00           C
ATOM    723  CD  LYS    44      95.623 -10.570   3.377  1.00  0.00           C
ATOM    724  CE  LYS    44      96.905 -11.378   3.492  1.00  0.00           C
ATOM    725  NZ  LYS    44      98.065 -10.681   2.881  1.00  0.00           N
ATOM    726  HN  LYS    44      92.452  -6.619   4.281  1.00  0.00           H
ATOM    727  HA  LYS    44      94.494  -7.716   6.098  1.00  0.00           H
ATOM    728  HB1 LYS    44      94.272  -8.143   3.112  1.00  0.00           H
ATOM    729  HB2 LYS    44      93.561  -9.227   4.299  1.00  0.00           H
ATOM    730  HG1 LYS    44      95.865  -9.553   5.238  1.00  0.00           H
ATOM    731  HG2 LYS    44      96.476  -8.669   3.837  1.00  0.00           H
ATOM    732  HD1 LYS    44      95.467 -10.305   2.341  1.00  0.00           H
ATOM    733  HD2 LYS    44      94.797 -11.176   3.721  1.00  0.00           H
ATOM    734  HE1 LYS    44      96.761 -12.326   2.992  1.00  0.00           H
ATOM    735  HE2 LYS    44      97.112 -11.554   4.537  1.00  0.00           H
ATOM    736  HZ1 LYS    44      98.904 -11.298   2.896  1.00  0.00           H
ATOM    737  HZ2 LYS    44      98.283  -9.808   3.410  1.00  0.00           H
ATOM    738  HZ3 LYS    44      97.853 -10.425   1.895  1.00  0.00           H
ATOM    739  N   THR    45      96.089  -5.891   5.638  1.00  0.00           N
ATOM    740  CA  THR    45      96.990  -4.766   5.437  1.00  0.00           C
ATOM    741  C   THR    45      98.395  -5.241   5.096  1.00  0.00           C
ATOM    742  O   THR    45      98.870  -6.233   5.647  1.00  0.00           O
ATOM    743  CB  THR    45      97.051  -3.874   6.693  1.00  0.00           C
ATOM    744  CG2 THR    45      95.732  -3.153   6.912  1.00  0.00           C
ATOM    745  OG1 THR    45      97.360  -4.667   7.848  1.00  0.00           O
ATOM    746  HN  THR    45      96.154  -6.414   6.468  1.00  0.00           H
ATOM    747  HA  THR    45      96.610  -4.174   4.618  1.00  0.00           H
ATOM    748  HB  THR    45      97.829  -3.137   6.555  1.00  0.00           H
ATOM    749  HG1 THR    45      97.613  -5.555   7.572  1.00  0.00           H
ATOM    750 HG21 THR    45      94.940  -3.878   7.032  1.00  0.00           H
ATOM    751 HG22 THR    45      95.519  -2.526   6.057  1.00  0.00           H
ATOM    752 HG23 THR    45      95.798  -2.542   7.799  1.00  0.00           H
ATOM    753  N   TYR    46      99.059  -4.533   4.197  1.00  0.00           N
ATOM    754  CA  TYR    46     100.424  -4.869   3.829  1.00  0.00           C
ATOM    755  C   TYR    46     101.310  -3.630   3.898  1.00  0.00           C
ATOM    756  O   TYR    46     100.836  -2.504   3.721  1.00  0.00           O
ATOM    757  CB  TYR    46     100.479  -5.488   2.425  1.00  0.00           C
ATOM    758  CG  TYR    46     100.176  -4.520   1.297  1.00  0.00           C
ATOM    759  CD1 TYR    46      98.878  -4.100   1.043  1.00  0.00           C
ATOM    760  CD2 TYR    46     101.193  -4.038   0.481  1.00  0.00           C
ATOM    761  CE1 TYR    46      98.600  -3.224   0.010  1.00  0.00           C
ATOM    762  CE2 TYR    46     100.923  -3.161  -0.552  1.00  0.00           C
ATOM    763  CZ  TYR    46      99.626  -2.758  -0.784  1.00  0.00           C
ATOM    764  OH  TYR    46      99.350  -1.888  -1.814  1.00  0.00           O
ATOM    765  HN  TYR    46      98.625  -3.754   3.777  1.00  0.00           H
ATOM    766  HA  TYR    46     100.788  -5.592   4.544  1.00  0.00           H
ATOM    767  HB1 TYR    46      99.761  -6.294   2.372  1.00  0.00           H
ATOM    768  HB2 TYR    46     101.468  -5.887   2.258  1.00  0.00           H
ATOM    769  HD1 TYR    46      98.075  -4.465   1.668  1.00  0.00           H
ATOM    770  HD2 TYR    46     102.209  -4.356   0.665  1.00  0.00           H
ATOM    771  HE1 TYR    46      97.584  -2.910  -0.171  1.00  0.00           H
ATOM    772  HE2 TYR    46     101.728  -2.796  -1.173  1.00  0.00           H
ATOM    773  HH  TYR    46      99.726  -2.232  -2.634  1.00  0.00           H
ATOM    774  N   VAL    47     102.585  -3.845   4.170  1.00  0.00           N
ATOM    775  CA  VAL    47     103.551  -2.760   4.218  1.00  0.00           C
ATOM    776  C   VAL    47     104.454  -2.825   2.995  1.00  0.00           C
ATOM    777  O   VAL    47     104.992  -3.884   2.669  1.00  0.00           O
ATOM    778  CB  VAL    47     104.427  -2.826   5.492  1.00  0.00           C
ATOM    779  CG1 VAL    47     105.356  -1.624   5.571  1.00  0.00           C
ATOM    780  CG2 VAL    47     103.566  -2.913   6.743  1.00  0.00           C
ATOM    781  HN  VAL    47     102.892  -4.766   4.333  1.00  0.00           H
ATOM    782  HA  VAL    47     103.013  -1.825   4.216  1.00  0.00           H
ATOM    783  HB  VAL    47     105.035  -3.718   5.439  1.00  0.00           H
ATOM    784 HG11 VAL    47     104.771  -0.716   5.598  1.00  0.00           H
ATOM    785 HG12 VAL    47     106.002  -1.611   4.706  1.00  0.00           H
ATOM    786 HG13 VAL    47     105.956  -1.692   6.466  1.00  0.00           H
ATOM    787 HG21 VAL    47     102.913  -3.771   6.673  1.00  0.00           H
ATOM    788 HG22 VAL    47     102.975  -2.016   6.835  1.00  0.00           H
ATOM    789 HG23 VAL    47     104.202  -3.016   7.609  1.00  0.00           H
ATOM    790  N   ILE    48     104.602  -1.707   2.311  1.00  0.00           N
ATOM    791  CA  ILE    48     105.483  -1.641   1.160  1.00  0.00           C
ATOM    792  C   ILE    48     106.487  -0.504   1.319  1.00  0.00           C
ATOM    793  O   ILE    48     106.122   0.673   1.338  1.00  0.00           O
ATOM    794  CB  ILE    48     104.689  -1.492  -0.164  1.00  0.00           C
ATOM    795  CG1 ILE    48     105.642  -1.237  -1.340  1.00  0.00           C
ATOM    796  CG2 ILE    48     103.643  -0.387  -0.059  1.00  0.00           C
ATOM    797  CD1 ILE    48     104.946  -1.134  -2.680  1.00  0.00           C
ATOM    798  HN  ILE    48     104.108  -0.900   2.589  1.00  0.00           H
ATOM    799  HA  ILE    48     106.028  -2.573   1.119  1.00  0.00           H
ATOM    800  HB  ILE    48     104.165  -2.419  -0.339  1.00  0.00           H
ATOM    801 HG11 ILE    48     106.355  -2.047  -1.397  1.00  0.00           H
ATOM    802 HG12 ILE    48     106.172  -0.311  -1.172  1.00  0.00           H
ATOM    803 HG21 ILE    48     104.132   0.552   0.161  1.00  0.00           H
ATOM    804 HG22 ILE    48     102.948  -0.624   0.732  1.00  0.00           H
ATOM    805 HG23 ILE    48     103.111  -0.305  -0.994  1.00  0.00           H
ATOM    806 HD11 ILE    48     104.430  -2.061  -2.890  1.00  0.00           H
ATOM    807 HD12 ILE    48     105.676  -0.946  -3.453  1.00  0.00           H
ATOM    808 HD13 ILE    48     104.232  -0.325  -2.654  1.00  0.00           H
ATOM    809  N   GLU    49     107.750  -0.866   1.485  1.00  0.00           N
ATOM    810  CA  GLU    49     108.813   0.119   1.591  1.00  0.00           C
ATOM    811  C   GLU    49     109.224   0.593   0.205  1.00  0.00           C
ATOM    812  O   GLU    49     109.999  -0.069  -0.490  1.00  0.00           O
ATOM    813  CB  GLU    49     110.033  -0.444   2.324  1.00  0.00           C
ATOM    814  CG  GLU    49     109.705  -1.228   3.584  1.00  0.00           C
ATOM    815  CD  GLU    49     109.490  -2.703   3.310  1.00  0.00           C
ATOM    816  OE1 GLU    49     110.481  -3.465   3.335  1.00  0.00           O
ATOM    817  OE2 GLU    49     108.340  -3.113   3.072  1.00  0.00           O
ATOM    818  HN  GLU    49     107.971  -1.822   1.559  1.00  0.00           H
ATOM    819  HA  GLU    49     108.425   0.963   2.145  1.00  0.00           H
ATOM    820  HB1 GLU    49     110.679   0.377   2.598  1.00  0.00           H
ATOM    821  HB2 GLU    49     110.568  -1.099   1.651  1.00  0.00           H
ATOM    822  HG1 GLU    49     108.803  -0.824   4.022  1.00  0.00           H
ATOM    823  HG2 GLU    49     110.522  -1.122   4.282  1.00  0.00           H
ATOM   1177  N   LYS    72     108.198   3.606   3.944  1.00  0.00           N
ATOM   1178  CA  LYS    72     107.483   2.387   4.282  1.00  0.00           C
ATOM   1179  C   LYS    72     106.028   2.721   4.578  1.00  0.00           C
ATOM   1180  O   LYS    72     105.689   3.202   5.660  1.00  0.00           O
ATOM   1181  CB  LYS    72     108.150   1.679   5.471  1.00  0.00           C
ATOM   1182  CG  LYS    72     108.404   2.580   6.671  1.00  0.00           C
ATOM   1183  CD  LYS    72     109.133   1.836   7.776  1.00  0.00           C
ATOM   1184  CE  LYS    72     109.358   2.717   8.994  1.00  0.00           C
ATOM   1185  NZ  LYS    72     108.081   3.173   9.602  1.00  0.00           N
ATOM   1186  HN  LYS    72     108.643   4.115   4.658  1.00  0.00           H
ATOM   1187  HA  LYS    72     107.518   1.737   3.419  1.00  0.00           H
ATOM   1188  HB1 LYS    72     109.095   1.274   5.144  1.00  0.00           H
ATOM   1189  HB2 LYS    72     107.513   0.865   5.788  1.00  0.00           H
ATOM   1190  HG1 LYS    72     107.456   2.936   7.051  1.00  0.00           H
ATOM   1191  HG2 LYS    72     109.007   3.418   6.358  1.00  0.00           H
ATOM   1192  HD1 LYS    72     110.090   1.503   7.402  1.00  0.00           H
ATOM   1193  HD2 LYS    72     108.543   0.979   8.071  1.00  0.00           H
ATOM   1194  HE1 LYS    72     109.933   3.582   8.693  1.00  0.00           H
ATOM   1195  HE2 LYS    72     109.916   2.157   9.731  1.00  0.00           H
ATOM   1196  HZ1 LYS    72     107.613   3.873   8.985  1.00  0.00           H
ATOM   1197  HZ2 LYS    72     108.258   3.612  10.528  1.00  0.00           H
ATOM   1198  HZ3 LYS    72     107.436   2.363   9.734  1.00  0.00           H
ATOM   1199  N   ILE    73     105.169   2.512   3.595  1.00  0.00           N
ATOM   1200  CA  ILE    73     103.770   2.879   3.729  1.00  0.00           C
ATOM   1201  C   ILE    73     102.898   1.642   3.928  1.00  0.00           C
ATOM   1202  O   ILE    73     103.098   0.607   3.286  1.00  0.00           O
ATOM   1203  CB  ILE    73     103.279   3.705   2.513  1.00  0.00           C
ATOM   1204  CG1 ILE    73     101.801   4.078   2.668  1.00  0.00           C
ATOM   1205  CG2 ILE    73     103.511   2.946   1.214  1.00  0.00           C
ATOM   1206  CD1 ILE    73     101.283   4.994   1.581  1.00  0.00           C
ATOM   1207  HN  ILE    73     105.480   2.094   2.759  1.00  0.00           H
ATOM   1208  HA  ILE    73     103.684   3.501   4.608  1.00  0.00           H
ATOM   1209  HB  ILE    73     103.864   4.612   2.472  1.00  0.00           H
ATOM   1210 HG11 ILE    73     101.661   4.574   3.617  1.00  0.00           H
ATOM   1211 HG12 ILE    73     101.206   3.176   2.650  1.00  0.00           H
ATOM   1212 HG21 ILE    73     103.165   3.542   0.382  1.00  0.00           H
ATOM   1213 HG22 ILE    73     102.965   2.014   1.241  1.00  0.00           H
ATOM   1214 HG23 ILE    73     104.565   2.742   1.096  1.00  0.00           H
ATOM   1215 HD11 ILE    73     101.844   5.917   1.590  1.00  0.00           H
ATOM   1216 HD12 ILE    73     100.237   5.206   1.756  1.00  0.00           H
ATOM   1217 HD13 ILE    73     101.395   4.513   0.622  1.00  0.00           H
ATOM   1218  N   LYS    74     101.955   1.752   4.850  1.00  0.00           N
ATOM   1219  CA  LYS    74     101.029   0.674   5.144  1.00  0.00           C
ATOM   1220  C   LYS    74      99.743   0.892   4.353  1.00  0.00           C
ATOM   1221  O   LYS    74      99.151   1.972   4.414  1.00  0.00           O
ATOM   1222  CB  LYS    74     100.729   0.655   6.648  1.00  0.00           C
ATOM   1223  CG  LYS    74     100.451  -0.725   7.232  1.00  0.00           C
ATOM   1224  CD  LYS    74     100.260  -0.637   8.742  1.00  0.00           C
ATOM   1225  CE  LYS    74     100.507  -1.967   9.443  1.00  0.00           C
ATOM   1226  NZ  LYS    74      99.486  -2.996   9.113  1.00  0.00           N
ATOM   1227  HN  LYS    74     101.876   2.595   5.349  1.00  0.00           H
ATOM   1228  HA  LYS    74     101.481  -0.262   4.850  1.00  0.00           H
ATOM   1229  HB1 LYS    74      99.865   1.277   6.834  1.00  0.00           H
ATOM   1230  HB2 LYS    74     101.574   1.073   7.174  1.00  0.00           H
ATOM   1231  HG1 LYS    74     101.285  -1.374   7.019  1.00  0.00           H
ATOM   1232  HG2 LYS    74      99.551  -1.123   6.786  1.00  0.00           H
ATOM   1233  HD1 LYS    74      99.246  -0.321   8.945  1.00  0.00           H
ATOM   1234  HD2 LYS    74     100.948   0.094   9.137  1.00  0.00           H
ATOM   1235  HE1 LYS    74     100.502  -1.800  10.511  1.00  0.00           H
ATOM   1236  HE2 LYS    74     101.478  -2.336   9.147  1.00  0.00           H
ATOM   1237  HZ1 LYS    74      99.636  -3.847   9.700  1.00  0.00           H
ATOM   1238  HZ2 LYS    74      99.560  -3.272   8.112  1.00  0.00           H
ATOM   1239  HZ3 LYS    74      98.527  -2.629   9.296  1.00  0.00           H
ATOM   1240  N   LYS    75      99.331  -0.105   3.587  1.00  0.00           N
ATOM   1241  CA  LYS    75      98.098  -0.006   2.816  1.00  0.00           C
ATOM   1242  C   LYS    75      97.176  -1.169   3.145  1.00  0.00           C
ATOM   1243  O   LYS    75      97.622  -2.204   3.640  1.00  0.00           O
ATOM   1244  CB  LYS    75      98.387   0.049   1.311  1.00  0.00           C
ATOM   1245  CG  LYS    75      99.133   1.305   0.885  1.00  0.00           C
ATOM   1246  CD  LYS    75      99.220   1.427  -0.630  1.00  0.00           C
ATOM   1247  CE  LYS    75      99.949   2.698  -1.034  1.00  0.00           C
ATOM   1248  NZ  LYS    75      99.950   2.909  -2.507  1.00  0.00           N
ATOM   1249  HN  LYS    75      99.859  -0.934   3.545  1.00  0.00           H
ATOM   1250  HA  LYS    75      97.607   0.910   3.109  1.00  0.00           H
ATOM   1251  HB1 LYS    75      97.450   0.013   0.775  1.00  0.00           H
ATOM   1252  HB2 LYS    75      98.982  -0.809   1.039  1.00  0.00           H
ATOM   1253  HG1 LYS    75     100.132   1.271   1.293  1.00  0.00           H
ATOM   1254  HG2 LYS    75      98.612   2.167   1.274  1.00  0.00           H
ATOM   1255  HD1 LYS    75      98.220   1.448  -1.039  1.00  0.00           H
ATOM   1256  HD2 LYS    75      99.754   0.575  -1.021  1.00  0.00           H
ATOM   1257  HE1 LYS    75     100.970   2.633  -0.689  1.00  0.00           H
ATOM   1258  HE2 LYS    75      99.466   3.540  -0.563  1.00  0.00           H
ATOM   1259  HZ1 LYS    75     100.428   2.114  -2.986  1.00  0.00           H
ATOM   1260  HZ2 LYS    75     100.449   3.789  -2.739  1.00  0.00           H
ATOM   1261  HZ3 LYS    75      98.972   2.978  -2.863  1.00  0.00           H
ATOM   1262  N   VAL    76      95.892  -0.993   2.877  1.00  0.00           N
ATOM   1263  CA  VAL    76      94.894  -1.985   3.238  1.00  0.00           C
ATOM   1264  C   VAL    76      94.135  -2.456   2.004  1.00  0.00           C
ATOM   1265  O   VAL    76      93.942  -1.692   1.059  1.00  0.00           O
ATOM   1266  CB  VAL    76      93.900  -1.416   4.283  1.00  0.00           C
ATOM   1267  CG1 VAL    76      93.142  -0.217   3.731  1.00  0.00           C
ATOM   1268  CG2 VAL    76      92.929  -2.485   4.754  1.00  0.00           C
ATOM   1269  HN  VAL    76      95.604  -0.178   2.405  1.00  0.00           H
ATOM   1270  HA  VAL    76      95.407  -2.828   3.679  1.00  0.00           H
ATOM   1271  HB  VAL    76      94.470  -1.083   5.138  1.00  0.00           H
ATOM   1272 HG11 VAL    76      93.842   0.562   3.468  1.00  0.00           H
ATOM   1273 HG12 VAL    76      92.458   0.152   4.481  1.00  0.00           H
ATOM   1274 HG13 VAL    76      92.588  -0.515   2.853  1.00  0.00           H
ATOM   1275 HG21 VAL    76      92.248  -2.060   5.476  1.00  0.00           H
ATOM   1276 HG22 VAL    76      93.479  -3.295   5.209  1.00  0.00           H
ATOM   1277 HG23 VAL    76      92.370  -2.859   3.909  1.00  0.00           H
ATOM   1278  N   TYR    77      93.735  -3.720   2.000  1.00  0.00           N
ATOM   1279  CA  TYR    77      92.918  -4.252   0.926  1.00  0.00           C
ATOM   1280  C   TYR    77      92.067  -5.408   1.430  1.00  0.00           C
ATOM   1281  O   TYR    77      92.310  -5.946   2.512  1.00  0.00           O
ATOM   1282  CB  TYR    77      93.794  -4.714  -0.250  1.00  0.00           C
ATOM   1283  CG  TYR    77      94.675  -5.913   0.042  1.00  0.00           C
ATOM   1284  CD1 TYR    77      94.202  -7.206  -0.145  1.00  0.00           C
ATOM   1285  CD2 TYR    77      95.978  -5.752   0.489  1.00  0.00           C
ATOM   1286  CE1 TYR    77      95.003  -8.300   0.106  1.00  0.00           C
ATOM   1287  CE2 TYR    77      96.786  -6.844   0.744  1.00  0.00           C
ATOM   1288  CZ  TYR    77      96.291  -8.115   0.552  1.00  0.00           C
ATOM   1289  OH  TYR    77      97.092  -9.206   0.798  1.00  0.00           O
ATOM   1290  HN  TYR    77      94.002  -4.315   2.738  1.00  0.00           H
ATOM   1291  HA  TYR    77      92.263  -3.463   0.586  1.00  0.00           H
ATOM   1292  HB1 TYR    77      94.438  -3.897  -0.545  1.00  0.00           H
ATOM   1293  HB2 TYR    77      93.155  -4.974  -1.080  1.00  0.00           H
ATOM   1294  HD1 TYR    77      93.189  -7.349  -0.492  1.00  0.00           H
ATOM   1295  HD2 TYR    77      96.361  -4.754   0.641  1.00  0.00           H
ATOM   1296  HE1 TYR    77      94.616  -9.298  -0.046  1.00  0.00           H
ATOM   1297  HE2 TYR    77      97.797  -6.699   1.094  1.00  0.00           H
ATOM   1298  HH  TYR    77      96.971  -9.859   0.089  1.00  0.00           H
ATOM   1299  N   PHE    78      91.060  -5.775   0.657  1.00  0.00           N
ATOM   1300  CA  PHE    78      90.312  -6.992   0.920  1.00  0.00           C
ATOM   1301  C   PHE    78      90.162  -7.775  -0.373  1.00  0.00           C
ATOM   1302  O   PHE    78      90.098  -7.190  -1.457  1.00  0.00           O
ATOM   1303  CB  PHE    78      88.943  -6.702   1.557  1.00  0.00           C
ATOM   1304  CG  PHE    78      87.943  -6.026   0.657  1.00  0.00           C
ATOM   1305  CD1 PHE    78      87.044  -6.775  -0.087  1.00  0.00           C
ATOM   1306  CD2 PHE    78      87.889  -4.646   0.570  1.00  0.00           C
ATOM   1307  CE1 PHE    78      86.111  -6.159  -0.900  1.00  0.00           C
ATOM   1308  CE2 PHE    78      86.960  -4.024  -0.243  1.00  0.00           C
ATOM   1309  CZ  PHE    78      86.070  -4.783  -0.979  1.00  0.00           C
ATOM   1310  HN  PHE    78      90.817  -5.215  -0.115  1.00  0.00           H
ATOM   1311  HA  PHE    78      90.896  -7.586   1.609  1.00  0.00           H
ATOM   1312  HB1 PHE    78      89.091  -6.069   2.420  1.00  0.00           H
ATOM   1313  HB2 PHE    78      88.507  -7.635   1.880  1.00  0.00           H
ATOM   1314  HD1 PHE    78      87.077  -7.853  -0.027  1.00  0.00           H
ATOM   1315  HD2 PHE    78      88.584  -4.050   1.144  1.00  0.00           H
ATOM   1316  HE1 PHE    78      85.418  -6.755  -1.474  1.00  0.00           H
ATOM   1317  HE2 PHE    78      86.930  -2.946  -0.303  1.00  0.00           H
ATOM   1318  HZ  PHE    78      85.342  -4.298  -1.614  1.00  0.00           H
ATOM   1319  N   GLU    79      90.129  -9.090  -0.261  1.00  0.00           N
ATOM   1320  CA  GLU    79      90.069  -9.947  -1.429  1.00  0.00           C
ATOM   1321  C   GLU    79      88.672 -10.511  -1.616  1.00  0.00           C
ATOM   1322  O   GLU    79      88.055 -11.003  -0.669  1.00  0.00           O
ATOM   1323  CB  GLU    79      91.090 -11.074  -1.312  1.00  0.00           C
ATOM   1324  CG  GLU    79      92.519 -10.571  -1.236  1.00  0.00           C
ATOM   1325  CD  GLU    79      93.532 -11.688  -1.232  1.00  0.00           C
ATOM   1326  OE1 GLU    79      93.669 -12.372  -2.265  1.00  0.00           O
ATOM   1327  OE2 GLU    79      94.205 -11.880  -0.199  1.00  0.00           O
ATOM   1328  HN  GLU    79      90.137  -9.497   0.630  1.00  0.00           H
ATOM   1329  HA  GLU    79      90.315  -9.343  -2.291  1.00  0.00           H
ATOM   1330  HB1 GLU    79      91.002 -11.720  -2.174  1.00  0.00           H
ATOM   1331  HB2 GLU    79      90.880 -11.645  -0.419  1.00  0.00           H
ATOM   1332  HG1 GLU    79      92.635  -9.996  -0.328  1.00  0.00           H
ATOM   1333  HG2 GLU    79      92.709  -9.937  -2.086  1.00  0.00           H
ATOM   1334  N   THR    80      88.179 -10.419  -2.837  1.00  0.00           N
ATOM   1335  CA  THR    80      86.853 -10.902  -3.172  1.00  0.00           C
ATOM   1336  C   THR    80      86.876 -12.392  -3.500  1.00  0.00           C
ATOM   1337  O   THR    80      87.915 -13.045  -3.404  1.00  0.00           O
ATOM   1338  CB  THR    80      86.301 -10.133  -4.382  1.00  0.00           C
ATOM   1339  CG2 THR    80      86.082  -8.667  -4.039  1.00  0.00           C
ATOM   1340  OG1 THR    80      87.221 -10.242  -5.474  1.00  0.00           O
ATOM   1341  HN  THR    80      88.725 -10.007  -3.543  1.00  0.00           H
ATOM   1342  HA  THR    80      86.203 -10.729  -2.328  1.00  0.00           H
ATOM   1343  HB  THR    80      85.355 -10.569  -4.668  1.00  0.00           H
ATOM   1344  HG1 THR    80      86.923  -9.675  -6.205  1.00  0.00           H
ATOM   1345 HG21 THR    80      85.365  -8.588  -3.234  1.00  0.00           H
ATOM   1346 HG22 THR    80      85.706  -8.146  -4.907  1.00  0.00           H
ATOM   1347 HG23 THR    80      87.018  -8.225  -3.731  1.00  0.00           H
ATOM   1348  N   LEU    81      85.726 -12.916  -3.908  1.00  0.00           N
ATOM   1349  CA  LEU    81      85.607 -14.318  -4.300  1.00  0.00           C
ATOM   1350  C   LEU    81      86.403 -14.583  -5.574  1.00  0.00           C
ATOM   1351  O   LEU    81      86.773 -15.719  -5.868  1.00  0.00           O
ATOM   1352  CB  LEU    81      84.136 -14.697  -4.525  1.00  0.00           C
ATOM   1353  CG  LEU    81      83.269 -14.836  -3.265  1.00  0.00           C
ATOM   1354  CD1 LEU    81      83.090 -13.499  -2.561  1.00  0.00           C
ATOM   1355  CD2 LEU    81      81.917 -15.426  -3.629  1.00  0.00           C
ATOM   1356  HN  LEU    81      84.931 -12.346  -3.945  1.00  0.00           H
ATOM   1357  HA  LEU    81      86.011 -14.923  -3.503  1.00  0.00           H
ATOM   1358  HB1 LEU    81      84.111 -15.639  -5.052  1.00  0.00           H
ATOM   1359  HB2 LEU    81      83.689 -13.944  -5.156  1.00  0.00           H
ATOM   1360  HG  LEU    81      83.754 -15.514  -2.577  1.00  0.00           H
ATOM   1361 HD11 LEU    81      82.614 -12.800  -3.232  1.00  0.00           H
ATOM   1362 HD12 LEU    81      84.056 -13.116  -2.268  1.00  0.00           H
ATOM   1363 HD13 LEU    81      82.474 -13.632  -1.683  1.00  0.00           H
ATOM   1364 HD21 LEU    81      81.312 -15.516  -2.739  1.00  0.00           H
ATOM   1365 HD22 LEU    81      82.058 -16.403  -4.069  1.00  0.00           H
ATOM   1366 HD23 LEU    81      81.422 -14.781  -4.338  1.00  0.00           H
ATOM   1367  N   ASP    82      86.678 -13.521  -6.318  1.00  0.00           N
ATOM   1368  CA  ASP    82      87.400 -13.628  -7.580  1.00  0.00           C
ATOM   1369  C   ASP    82      88.894 -13.450  -7.350  1.00  0.00           C
ATOM   1370  O   ASP    82      89.673 -13.378  -8.301  1.00  0.00           O
ATOM   1371  CB  ASP    82      86.904 -12.569  -8.568  1.00  0.00           C
ATOM   1372  CG  ASP    82      85.394 -12.528  -8.679  1.00  0.00           C
ATOM   1373  OD1 ASP    82      84.817 -13.366  -9.401  1.00  0.00           O
ATOM   1374  OD2 ASP    82      84.779 -11.646  -8.044  1.00  0.00           O
ATOM   1375  HN  ASP    82      86.388 -12.637  -6.010  1.00  0.00           H
ATOM   1376  HA  ASP    82      87.220 -14.610  -7.989  1.00  0.00           H
ATOM   1377  HB1 ASP    82      87.313 -12.782  -9.546  1.00  0.00           H
ATOM   1378  HB2 ASP    82      87.247 -11.597  -8.245  1.00  0.00           H
ATOM   1379  N   ASN    83      89.279 -13.373  -6.074  1.00  0.00           N
ATOM   1380  CA  ASN    83      90.672 -13.152  -5.674  1.00  0.00           C
ATOM   1381  C   ASN    83      91.156 -11.780  -6.122  1.00  0.00           C
ATOM   1382  O   ASN    83      92.358 -11.544  -6.265  1.00  0.00           O
ATOM   1383  CB  ASN    83      91.595 -14.247  -6.223  1.00  0.00           C
ATOM   1384  CG  ASN    83      91.480 -15.546  -5.450  1.00  0.00           C
ATOM   1385  ND2 ASN    83      90.590 -16.418  -5.886  1.00  0.00           N
ATOM   1386  OD1 ASN    83      92.196 -15.765  -4.473  1.00  0.00           O
ATOM   1387  HN  ASN    83      88.600 -13.472  -5.371  1.00  0.00           H
ATOM   1388  HA  ASN    83      90.705 -13.184  -4.594  1.00  0.00           H
ATOM   1389  HB1 ASN    83      92.619 -13.905  -6.170  1.00  0.00           H
ATOM   1390  HB2 ASN    83      91.337 -14.441  -7.253  1.00  0.00           H
ATOM   1391 HD21 ASN    83      90.058 -16.183  -6.680  1.00  0.00           H
ATOM   1392 HD22 ASN    83      90.494 -17.268  -5.402  1.00  0.00           H
ATOM   1393  N   VAL    84      90.214 -10.875  -6.330  1.00  0.00           N
ATOM   1394  CA  VAL    84      90.541  -9.508  -6.692  1.00  0.00           C
ATOM   1395  C   VAL    84      90.744  -8.689  -5.426  1.00  0.00           C
ATOM   1396  O   VAL    84      89.891  -8.680  -4.539  1.00  0.00           O
ATOM   1397  CB  VAL    84      89.438  -8.869  -7.564  1.00  0.00           C
ATOM   1398  CG1 VAL    84      89.790  -7.430  -7.915  1.00  0.00           C
ATOM   1399  CG2 VAL    84      89.219  -9.692  -8.825  1.00  0.00           C
ATOM   1400  HN  VAL    84      89.274 -11.130  -6.226  1.00  0.00           H
ATOM   1401  HA  VAL    84      91.463  -9.522  -7.256  1.00  0.00           H
ATOM   1402  HB  VAL    84      88.518  -8.864  -7.000  1.00  0.00           H
ATOM   1403 HG11 VAL    84      89.004  -7.006  -8.522  1.00  0.00           H
ATOM   1404 HG12 VAL    84      90.720  -7.410  -8.464  1.00  0.00           H
ATOM   1405 HG13 VAL    84      89.894  -6.854  -7.007  1.00  0.00           H
ATOM   1406 HG21 VAL    84      90.137  -9.735  -9.394  1.00  0.00           H
ATOM   1407 HG22 VAL    84      88.445  -9.235  -9.425  1.00  0.00           H
ATOM   1408 HG23 VAL    84      88.917 -10.693  -8.553  1.00  0.00           H
ATOM   1409  N   ARG    85      91.884  -8.027  -5.337  1.00  0.00           N
ATOM   1410  CA  ARG    85      92.241  -7.291  -4.140  1.00  0.00           C
ATOM   1411  C   ARG    85      91.886  -5.820  -4.295  1.00  0.00           C
ATOM   1412  O   ARG    85      92.486  -5.108  -5.100  1.00  0.00           O
ATOM   1413  CB  ARG    85      93.737  -7.439  -3.848  1.00  0.00           C
ATOM   1414  CG  ARG    85      94.254  -8.857  -4.035  1.00  0.00           C
ATOM   1415  CD  ARG    85      95.589  -9.073  -3.340  1.00  0.00           C
ATOM   1416  NE  ARG    85      96.619  -8.139  -3.790  1.00  0.00           N
ATOM   1417  CZ  ARG    85      97.868  -8.140  -3.327  1.00  0.00           C
ATOM   1418  NH1 ARG    85      98.238  -9.034  -2.416  1.00  0.00           N
ATOM   1419  NH2 ARG    85      98.743  -7.253  -3.780  1.00  0.00           N
ATOM   1420  HN  ARG    85      92.501  -8.024  -6.105  1.00  0.00           H
ATOM   1421  HA  ARG    85      91.678  -7.702  -3.315  1.00  0.00           H
ATOM   1422  HB1 ARG    85      93.923  -7.143  -2.826  1.00  0.00           H
ATOM   1423  HB2 ARG    85      94.288  -6.787  -4.509  1.00  0.00           H
ATOM   1424  HG1 ARG    85      94.375  -9.045  -5.093  1.00  0.00           H
ATOM   1425  HG2 ARG    85      93.532  -9.548  -3.631  1.00  0.00           H
ATOM   1426  HD1 ARG    85      95.921 -10.082  -3.540  1.00  0.00           H
ATOM   1427  HD2 ARG    85      95.447  -8.950  -2.277  1.00  0.00           H
ATOM   1428  HE  ARG    85      96.364  -7.472  -4.469  1.00  0.00           H
ATOM   1429 HH11 ARG    85      97.578  -9.711  -2.073  1.00  0.00           H
ATOM   1430 HH12 ARG    85      99.184  -9.036  -2.059  1.00  0.00           H
ATOM   1431 HH21 ARG    85      98.457  -6.570  -4.473  1.00  0.00           H
ATOM   1432 HH22 ARG    85      99.692  -7.251  -3.443  1.00  0.00           H
ATOM   1433  N   VAL    86      90.895  -5.376  -3.541  1.00  0.00           N
ATOM   1434  CA  VAL    86      90.522  -3.971  -3.530  1.00  0.00           C
ATOM   1435  C   VAL    86      91.427  -3.214  -2.569  1.00  0.00           C
ATOM   1436  O   VAL    86      91.266  -3.306  -1.354  1.00  0.00           O
ATOM   1437  CB  VAL    86      89.047  -3.774  -3.124  1.00  0.00           C
ATOM   1438  CG1 VAL    86      88.678  -2.298  -3.126  1.00  0.00           C
ATOM   1439  CG2 VAL    86      88.128  -4.552  -4.053  1.00  0.00           C
ATOM   1440  HN  VAL    86      90.405  -6.009  -2.968  1.00  0.00           H
ATOM   1441  HA  VAL    86      90.660  -3.579  -4.529  1.00  0.00           H
ATOM   1442  HB  VAL    86      88.915  -4.153  -2.121  1.00  0.00           H
ATOM   1443 HG11 VAL    86      88.835  -1.890  -4.114  1.00  0.00           H
ATOM   1444 HG12 VAL    86      89.299  -1.771  -2.415  1.00  0.00           H
ATOM   1445 HG13 VAL    86      87.640  -2.186  -2.850  1.00  0.00           H
ATOM   1446 HG21 VAL    86      88.369  -5.603  -4.000  1.00  0.00           H
ATOM   1447 HG22 VAL    86      88.262  -4.202  -5.066  1.00  0.00           H
ATOM   1448 HG23 VAL    86      87.102  -4.402  -3.753  1.00  0.00           H
ATOM   1449  N   VAL    87      92.387  -2.486  -3.126  1.00  0.00           N
ATOM   1450  CA  VAL    87      93.422  -1.835  -2.334  1.00  0.00           C
ATOM   1451  C   VAL    87      93.098  -0.361  -2.117  1.00  0.00           C
ATOM   1452  O   VAL    87      92.534   0.299  -2.994  1.00  0.00           O
ATOM   1453  CB  VAL    87      94.805  -1.956  -3.013  1.00  0.00           C
ATOM   1454  CG1 VAL    87      95.912  -1.457  -2.095  1.00  0.00           C
ATOM   1455  CG2 VAL    87      95.072  -3.391  -3.440  1.00  0.00           C
ATOM   1456  HN  VAL    87      92.386  -2.366  -4.099  1.00  0.00           H
ATOM   1457  HA  VAL    87      93.471  -2.329  -1.374  1.00  0.00           H
ATOM   1458  HB  VAL    87      94.802  -1.337  -3.899  1.00  0.00           H
ATOM   1459 HG11 VAL    87      96.865  -1.565  -2.590  1.00  0.00           H
ATOM   1460 HG12 VAL    87      95.911  -2.036  -1.184  1.00  0.00           H
ATOM   1461 HG13 VAL    87      95.742  -0.417  -1.861  1.00  0.00           H
ATOM   1462 HG21 VAL    87      94.315  -3.705  -4.144  1.00  0.00           H
ATOM   1463 HG22 VAL    87      95.046  -4.034  -2.573  1.00  0.00           H
ATOM   1464 HG23 VAL    87      96.045  -3.454  -3.905  1.00  0.00           H
ATOM   1465  N   THR    88      93.441   0.143  -0.941  1.00  0.00           N
ATOM   1466  CA  THR    88      93.196   1.529  -0.591  1.00  0.00           C
ATOM   1467  C   THR    88      94.239   2.027   0.417  1.00  0.00           C
ATOM   1468  O   THR    88      94.774   1.245   1.211  1.00  0.00           O
ATOM   1469  CB  THR    88      91.769   1.686  -0.023  1.00  0.00           C
ATOM   1470  CG2 THR    88      91.513   3.090   0.496  1.00  0.00           C
ATOM   1471  OG1 THR    88      90.815   1.373  -1.044  1.00  0.00           O
ATOM   1472  HN  THR    88      93.865  -0.446  -0.275  1.00  0.00           H
ATOM   1473  HA  THR    88      93.270   2.119  -1.492  1.00  0.00           H
ATOM   1474  HB  THR    88      91.647   0.987   0.792  1.00  0.00           H
ATOM   1475  HG1 THR    88      91.262   0.915  -1.764  1.00  0.00           H
ATOM   1476 HG21 THR    88      90.532   3.133   0.944  1.00  0.00           H
ATOM   1477 HG22 THR    88      91.568   3.794  -0.322  1.00  0.00           H
ATOM   1478 HG23 THR    88      92.258   3.342   1.238  1.00  0.00           H
ATOM   1479  N   ASP    89      94.552   3.320   0.347  1.00  0.00           N
ATOM   1480  CA  ASP    89      95.499   3.952   1.265  1.00  0.00           C
ATOM   1481  C   ASP    89      95.056   3.779   2.714  1.00  0.00           C
ATOM   1482  O   ASP    89      94.050   4.347   3.136  1.00  0.00           O
ATOM   1483  CB  ASP    89      95.633   5.450   0.965  1.00  0.00           C
ATOM   1484  CG  ASP    89      96.084   5.740  -0.451  1.00  0.00           C
ATOM   1485  OD1 ASP    89      97.309   5.817  -0.689  1.00  0.00           O
ATOM   1486  OD2 ASP    89      95.215   5.907  -1.334  1.00  0.00           O
ATOM   1487  HN  ASP    89      94.138   3.867  -0.357  1.00  0.00           H
ATOM   1488  HA  ASP    89      96.460   3.479   1.132  1.00  0.00           H
ATOM   1489  HB1 ASP    89      96.353   5.879   1.647  1.00  0.00           H
ATOM   1490  HB2 ASP    89      94.676   5.926   1.118  1.00  0.00           H
ATOM   1491  N   TYR    90      95.818   3.003   3.474  1.00  0.00           N
ATOM   1492  CA  TYR    90      95.504   2.743   4.876  1.00  0.00           C
ATOM   1493  C   TYR    90      95.768   3.987   5.715  1.00  0.00           C
ATOM   1494  O   TYR    90      95.101   4.228   6.724  1.00  0.00           O
ATOM   1495  CB  TYR    90      96.338   1.562   5.376  1.00  0.00           C
ATOM   1496  CG  TYR    90      96.053   1.126   6.794  1.00  0.00           C
ATOM   1497  CD1 TYR    90      94.847   0.526   7.132  1.00  0.00           C
ATOM   1498  CD2 TYR    90      97.006   1.288   7.791  1.00  0.00           C
ATOM   1499  CE1 TYR    90      94.599   0.100   8.421  1.00  0.00           C
ATOM   1500  CE2 TYR    90      96.764   0.869   9.083  1.00  0.00           C
ATOM   1501  CZ  TYR    90      95.561   0.274   9.392  1.00  0.00           C
ATOM   1502  OH  TYR    90      95.323  -0.157  10.677  1.00  0.00           O
ATOM   1503  HN  TYR    90      96.617   2.594   3.083  1.00  0.00           H
ATOM   1504  HA  TYR    90      94.456   2.492   4.947  1.00  0.00           H
ATOM   1505  HB1 TYR    90      97.384   1.829   5.317  1.00  0.00           H
ATOM   1506  HB2 TYR    90      96.159   0.713   4.734  1.00  0.00           H
ATOM   1507  HD1 TYR    90      94.094   0.392   6.368  1.00  0.00           H
ATOM   1508  HD2 TYR    90      97.949   1.756   7.545  1.00  0.00           H
ATOM   1509  HE1 TYR    90      93.656  -0.365   8.665  1.00  0.00           H
ATOM   1510  HE2 TYR    90      97.517   1.007   9.845  1.00  0.00           H
ATOM   1511  HH  TYR    90      95.584   0.535  11.298  1.00  0.00           H
ATOM   1512  N   SER    91      96.734   4.780   5.275  1.00  0.00           N
ATOM   1513  CA  SER    91      97.047   6.050   5.909  1.00  0.00           C
ATOM   1514  C   SER    91      95.842   6.988   5.856  1.00  0.00           C
ATOM   1515  O   SER    91      95.460   7.595   6.859  1.00  0.00           O
ATOM   1516  CB  SER    91      98.246   6.677   5.197  1.00  0.00           C
ATOM   1517  OG  SER    91      98.144   6.486   3.792  1.00  0.00           O
ATOM   1518  HN  SER    91      97.258   4.504   4.493  1.00  0.00           H
ATOM   1519  HA  SER    91      97.304   5.860   6.940  1.00  0.00           H
ATOM   1520  HB1 SER    91      99.155   6.213   5.549  1.00  0.00           H
ATOM   1521  HB2 SER    91      98.274   7.735   5.405  1.00  0.00           H
ATOM   1522  HG  SER    91      98.260   7.334   3.341  1.00  0.00           H
ATOM   1523  N   GLU    92      95.244   7.085   4.678  1.00  0.00           N
ATOM   1524  CA  GLU    92      94.066   7.914   4.474  1.00  0.00           C
ATOM   1525  C   GLU    92      92.850   7.274   5.142  1.00  0.00           C
ATOM   1526  O   GLU    92      91.991   7.964   5.685  1.00  0.00           O
ATOM   1527  CB  GLU    92      93.808   8.085   2.977  1.00  0.00           C
ATOM   1528  CG  GLU    92      92.825   9.193   2.636  1.00  0.00           C
ATOM   1529  CD  GLU    92      93.443  10.572   2.699  1.00  0.00           C
ATOM   1530  OE1 GLU    92      92.799  11.493   3.238  1.00  0.00           O
ATOM   1531  OE2 GLU    92      94.565  10.750   2.180  1.00  0.00           O
ATOM   1532  HN  GLU    92      95.614   6.592   3.916  1.00  0.00           H
ATOM   1533  HA  GLU    92      94.249   8.881   4.920  1.00  0.00           H
ATOM   1534  HB1 GLU    92      93.418   7.157   2.586  1.00  0.00           H
ATOM   1535  HB2 GLU    92      94.745   8.304   2.487  1.00  0.00           H
ATOM   1536  HG1 GLU    92      92.001   9.152   3.335  1.00  0.00           H
ATOM   1537  HG2 GLU    92      92.453   9.029   1.636  1.00  0.00           H
ATOM   1538  N   PHE    93      92.796   5.945   5.102  1.00  0.00           N
ATOM   1539  CA  PHE    93      91.686   5.197   5.682  1.00  0.00           C
ATOM   1540  C   PHE    93      91.571   5.460   7.181  1.00  0.00           C
ATOM   1541  O   PHE    93      90.502   5.828   7.670  1.00  0.00           O
ATOM   1542  CB  PHE    93      91.856   3.699   5.414  1.00  0.00           C
ATOM   1543  CG  PHE    93      90.693   2.862   5.867  1.00  0.00           C
ATOM   1544  CD1 PHE    93      89.452   2.999   5.266  1.00  0.00           C
ATOM   1545  CD2 PHE    93      90.842   1.938   6.888  1.00  0.00           C
ATOM   1546  CE1 PHE    93      88.381   2.228   5.674  1.00  0.00           C
ATOM   1547  CE2 PHE    93      89.774   1.164   7.301  1.00  0.00           C
ATOM   1548  CZ  PHE    93      88.541   1.310   6.695  1.00  0.00           C
ATOM   1549  HN  PHE    93      93.520   5.453   4.657  1.00  0.00           H
ATOM   1550  HA  PHE    93      90.778   5.536   5.203  1.00  0.00           H
ATOM   1551  HB1 PHE    93      92.739   3.347   5.929  1.00  0.00           H
ATOM   1552  HB2 PHE    93      91.981   3.542   4.352  1.00  0.00           H
ATOM   1553  HD1 PHE    93      89.325   3.718   4.469  1.00  0.00           H
ATOM   1554  HD2 PHE    93      91.804   1.822   7.362  1.00  0.00           H
ATOM   1555  HE1 PHE    93      87.417   2.344   5.198  1.00  0.00           H
ATOM   1556  HE2 PHE    93      89.901   0.449   8.098  1.00  0.00           H
ATOM   1557  HZ  PHE    93      87.704   0.707   7.016  1.00  0.00           H
ATOM   1558  N   GLN    94      92.671   5.283   7.910  1.00  0.00           N
ATOM   1559  CA  GLN    94      92.678   5.551   9.345  1.00  0.00           C
ATOM   1560  C   GLN    94      92.446   7.031   9.622  1.00  0.00           C
ATOM   1561  O   GLN    94      91.860   7.396  10.638  1.00  0.00           O
ATOM   1562  CB  GLN    94      93.988   5.099   9.988  1.00  0.00           C
ATOM   1563  CG  GLN    94      94.015   3.625  10.344  1.00  0.00           C
ATOM   1564  CD  GLN    94      95.192   3.263  11.230  1.00  0.00           C
ATOM   1565  NE2 GLN    94      95.002   2.278  12.095  1.00  0.00           N
ATOM   1566  OE1 GLN    94      96.258   3.872  11.150  1.00  0.00           O
ATOM   1567  HN  GLN    94      93.495   4.967   7.473  1.00  0.00           H
ATOM   1568  HA  GLN    94      91.865   4.991   9.785  1.00  0.00           H
ATOM   1569  HB1 GLN    94      94.149   5.671  10.890  1.00  0.00           H
ATOM   1570  HB2 GLN    94      94.796   5.293   9.297  1.00  0.00           H
ATOM   1571  HG1 GLN    94      94.078   3.049   9.432  1.00  0.00           H
ATOM   1572  HG2 GLN    94      93.101   3.374  10.863  1.00  0.00           H
ATOM   1573 HE21 GLN    94      94.123   1.842  12.117  1.00  0.00           H
ATOM   1574 HE22 GLN    94      95.749   2.028  12.688  1.00  0.00           H
ATOM   1575  N   LYS    95      92.910   7.870   8.712  1.00  0.00           N
ATOM   1576  CA  LYS    95      92.677   9.307   8.787  1.00  0.00           C
ATOM   1577  C   LYS    95      91.176   9.608   8.779  1.00  0.00           C
ATOM   1578  O   LYS    95      90.695  10.455   9.534  1.00  0.00           O
ATOM   1579  CB  LYS    95      93.376   9.983   7.610  1.00  0.00           C
ATOM   1580  CG  LYS    95      93.049  11.452   7.422  1.00  0.00           C
ATOM   1581  CD  LYS    95      93.696  11.965   6.151  1.00  0.00           C
ATOM   1582  CE  LYS    95      93.212  13.351   5.777  1.00  0.00           C
ATOM   1583  NZ  LYS    95      93.707  13.749   4.433  1.00  0.00           N
ATOM   1584  HN  LYS    95      93.432   7.514   7.960  1.00  0.00           H
ATOM   1585  HA  LYS    95      93.103   9.670   9.710  1.00  0.00           H
ATOM   1586  HB1 LYS    95      93.105   9.462   6.704  1.00  0.00           H
ATOM   1587  HB2 LYS    95      94.443   9.899   7.751  1.00  0.00           H
ATOM   1588  HG1 LYS    95      93.429  12.010   8.264  1.00  0.00           H
ATOM   1589  HG2 LYS    95      91.978  11.571   7.352  1.00  0.00           H
ATOM   1590  HD1 LYS    95      93.464  11.285   5.345  1.00  0.00           H
ATOM   1591  HD2 LYS    95      94.765  11.999   6.295  1.00  0.00           H
ATOM   1592  HE1 LYS    95      93.574  14.058   6.510  1.00  0.00           H
ATOM   1593  HE2 LYS    95      92.132  13.357   5.772  1.00  0.00           H
ATOM   1594  HZ1 LYS    95      93.410  13.041   3.724  1.00  0.00           H
ATOM   1595  HZ2 LYS    95      94.748  13.805   4.435  1.00  0.00           H
ATOM   1596  HZ3 LYS    95      93.321  14.679   4.163  1.00  0.00           H
ATOM   1597  N   ILE    96      90.440   8.896   7.934  1.00  0.00           N
ATOM   1598  CA  ILE    96      88.992   9.035   7.878  1.00  0.00           C
ATOM   1599  C   ILE    96      88.346   8.408   9.113  1.00  0.00           C
ATOM   1600  O   ILE    96      87.362   8.932   9.646  1.00  0.00           O
ATOM   1601  CB  ILE    96      88.414   8.385   6.602  1.00  0.00           C
ATOM   1602  CG1 ILE    96      89.044   9.017   5.358  1.00  0.00           C
ATOM   1603  CG2 ILE    96      86.897   8.524   6.562  1.00  0.00           C
ATOM   1604  CD1 ILE    96      88.621   8.360   4.064  1.00  0.00           C
ATOM   1605  HN  ILE    96      90.886   8.265   7.325  1.00  0.00           H
ATOM   1606  HA  ILE    96      88.758  10.091   7.859  1.00  0.00           H
ATOM   1607  HB  ILE    96      88.654   7.334   6.622  1.00  0.00           H
ATOM   1608 HG11 ILE    96      90.120   8.943   5.432  1.00  0.00           H
ATOM   1609 HG12 ILE    96      88.764  10.059   5.308  1.00  0.00           H
ATOM   1610 HG21 ILE    96      86.467   8.028   7.421  1.00  0.00           H
ATOM   1611 HG22 ILE    96      86.518   8.071   5.658  1.00  0.00           H
ATOM   1612 HG23 ILE    96      86.629   9.570   6.580  1.00  0.00           H
ATOM   1613 HD11 ILE    96      87.548   8.417   3.965  1.00  0.00           H
ATOM   1614 HD12 ILE    96      88.928   7.326   4.068  1.00  0.00           H
ATOM   1615 HD13 ILE    96      89.086   8.870   3.233  1.00  0.00           H
ATOM   1616  N   LEU    97      88.909   7.293   9.572  1.00  0.00           N
ATOM   1617  CA  LEU    97      88.426   6.633  10.782  1.00  0.00           C
ATOM   1618  C   LEU    97      88.510   7.574  11.976  1.00  0.00           C
ATOM   1619  O   LEU    97      87.543   7.740  12.713  1.00  0.00           O
ATOM   1620  CB  LEU    97      89.229   5.359  11.069  1.00  0.00           C
ATOM   1621  CG  LEU    97      89.109   4.256  10.018  1.00  0.00           C
ATOM   1622  CD1 LEU    97      89.942   3.051  10.417  1.00  0.00           C
ATOM   1623  CD2 LEU    97      87.655   3.856   9.826  1.00  0.00           C
ATOM   1624  HN  LEU    97      89.662   6.898   9.075  1.00  0.00           H
ATOM   1625  HA  LEU    97      87.393   6.366  10.622  1.00  0.00           H
ATOM   1626  HB1 LEU    97      88.900   4.959  12.017  1.00  0.00           H
ATOM   1627  HB2 LEU    97      90.272   5.630  11.157  1.00  0.00           H
ATOM   1628  HG  LEU    97      89.484   4.624   9.074  1.00  0.00           H
ATOM   1629 HD11 LEU    97      89.602   2.679  11.372  1.00  0.00           H
ATOM   1630 HD12 LEU    97      90.981   3.339  10.491  1.00  0.00           H
ATOM   1631 HD13 LEU    97      89.836   2.276   9.671  1.00  0.00           H
ATOM   1632 HD21 LEU    97      87.087   4.714   9.494  1.00  0.00           H
ATOM   1633 HD22 LEU    97      87.252   3.499  10.761  1.00  0.00           H
ATOM   1634 HD23 LEU    97      87.592   3.075   9.083  1.00  0.00           H
ATOM   1635  N   LYS    98      89.669   8.203  12.145  1.00  0.00           N
ATOM   1636  CA  LYS    98      89.886   9.154  13.232  1.00  0.00           C
ATOM   1637  C   LYS    98      88.996  10.382  13.063  1.00  0.00           C
ATOM   1638  O   LYS    98      88.609  11.024  14.039  1.00  0.00           O
ATOM   1639  CB  LYS    98      91.351   9.591  13.269  1.00  0.00           C
ATOM   1640  CG  LYS    98      92.330   8.463  13.541  1.00  0.00           C
ATOM   1641  CD  LYS    98      93.766   8.956  13.469  1.00  0.00           C
ATOM   1642  CE  LYS    98      94.762   7.857  13.798  1.00  0.00           C
ATOM   1643  NZ  LYS    98      94.557   7.315  15.167  1.00  0.00           N
ATOM   1644  HN  LYS    98      90.407   8.014  11.521  1.00  0.00           H
ATOM   1645  HA  LYS    98      89.638   8.665  14.161  1.00  0.00           H
ATOM   1646  HB1 LYS    98      91.471  10.335  14.043  1.00  0.00           H
ATOM   1647  HB2 LYS    98      91.605  10.034  12.318  1.00  0.00           H
ATOM   1648  HG1 LYS    98      92.186   7.687  12.804  1.00  0.00           H
ATOM   1649  HG2 LYS    98      92.144   8.065  14.528  1.00  0.00           H
ATOM   1650  HD1 LYS    98      93.893   9.766  14.173  1.00  0.00           H
ATOM   1651  HD2 LYS    98      93.961   9.314  12.469  1.00  0.00           H
ATOM   1652  HE1 LYS    98      95.761   8.260  13.725  1.00  0.00           H
ATOM   1653  HE2 LYS    98      94.645   7.056  13.084  1.00  0.00           H
ATOM   1654  HZ1 LYS    98      95.383   6.748  15.456  1.00  0.00           H
ATOM   1655  HZ2 LYS    98      93.709   6.708  15.189  1.00  0.00           H
ATOM   1656  HZ3 LYS    98      94.427   8.096  15.848  1.00  0.00           H
ATOM   1657  N   LYS    99      88.685  10.701  11.817  1.00  0.00           N
ATOM   1658  CA  LYS    99      87.863  11.857  11.496  1.00  0.00           C
ATOM   1659  C   LYS    99      86.425  11.646  11.963  1.00  0.00           C
ATOM   1660  O   LYS    99      85.867  12.476  12.680  1.00  0.00           O
ATOM   1661  CB  LYS    99      87.905  12.113   9.990  1.00  0.00           C
ATOM   1662  CG  LYS    99      87.112  13.323   9.540  1.00  0.00           C
ATOM   1663  CD  LYS    99      87.308  13.578   8.058  1.00  0.00           C
ATOM   1664  CE  LYS    99      86.539  14.801   7.591  1.00  0.00           C
ATOM   1665  NZ  LYS    99      85.071  14.605   7.680  1.00  0.00           N
ATOM   1666  HN  LYS    99      89.024  10.141  11.084  1.00  0.00           H
ATOM   1667  HA  LYS    99      88.274  12.712  12.009  1.00  0.00           H
ATOM   1668  HB1 LYS    99      87.512  11.244   9.480  1.00  0.00           H
ATOM   1669  HB2 LYS    99      88.933  12.256   9.691  1.00  0.00           H
ATOM   1670  HG1 LYS    99      87.444  14.188  10.095  1.00  0.00           H
ATOM   1671  HG2 LYS    99      86.063  13.148   9.731  1.00  0.00           H
ATOM   1672  HD1 LYS    99      86.964  12.716   7.506  1.00  0.00           H
ATOM   1673  HD2 LYS    99      88.359  13.734   7.867  1.00  0.00           H
ATOM   1674  HE1 LYS    99      86.806  15.006   6.564  1.00  0.00           H
ATOM   1675  HE2 LYS    99      86.819  15.642   8.207  1.00  0.00           H
ATOM   1676  HZ1 LYS    99      84.578  15.417   7.249  1.00  0.00           H
ATOM   1677  HZ2 LYS    99      84.773  14.522   8.678  1.00  0.00           H
ATOM   1678  HZ3 LYS    99      84.793  13.738   7.172  1.00  0.00           H
ATOM   1679  N   ARG   100      85.838  10.522  11.571  1.00  0.00           N
ATOM   1680  CA  ARG   100      84.461  10.209  11.947  1.00  0.00           C
ATOM   1681  C   ARG   100      84.395   9.600  13.342  1.00  0.00           C
ATOM   1682  O   ARG   100      83.314   9.437  13.908  1.00  0.00           O
ATOM   1683  CB  ARG   100      83.830   9.253  10.935  1.00  0.00           C
ATOM   1684  CG  ARG   100      83.481   9.913   9.615  1.00  0.00           C
ATOM   1685  CD  ARG   100      82.824   8.935   8.657  1.00  0.00           C
ATOM   1686  NE  ARG   100      82.267   9.615   7.492  1.00  0.00           N
ATOM   1687  CZ  ARG   100      82.494   9.249   6.231  1.00  0.00           C
ATOM   1688  NH1 ARG   100      83.267   8.203   5.969  1.00  0.00           N
ATOM   1689  NH2 ARG   100      81.947   9.929   5.235  1.00  0.00           N
ATOM   1690  HN  ARG   100      86.341   9.885  11.016  1.00  0.00           H
ATOM   1691  HA  ARG   100      83.904  11.133  11.947  1.00  0.00           H
ATOM   1692  HB1 ARG   100      82.926   8.842  11.358  1.00  0.00           H
ATOM   1693  HB2 ARG   100      84.523   8.447  10.736  1.00  0.00           H
ATOM   1694  HG1 ARG   100      84.386  10.293   9.162  1.00  0.00           H
ATOM   1695  HG2 ARG   100      82.800  10.731   9.800  1.00  0.00           H
ATOM   1696  HD1 ARG   100      82.029   8.420   9.177  1.00  0.00           H
ATOM   1697  HD2 ARG   100      83.562   8.219   8.327  1.00  0.00           H
ATOM   1698  HE  ARG   100      81.681  10.392   7.664  1.00  0.00           H
ATOM   1699 HH11 ARG   100      83.681   7.684   6.712  1.00  0.00           H
ATOM   1700 HH12 ARG   100      83.431   7.922   5.011  1.00  0.00           H
ATOM   1701 HH21 ARG   100      81.352  10.720   5.427  1.00  0.00           H
ATOM   1702 HH22 ARG   100      82.134   9.669   4.280  1.00  0.00           H
ATOM   1703  N   GLY   101      85.551   9.258  13.887  1.00  0.00           N
ATOM   1704  CA  GLY   101      85.601   8.662  15.205  1.00  0.00           C
ATOM   1705  C   GLY   101      85.139   7.221  15.194  1.00  0.00           C
ATOM   1706  O   GLY   101      84.522   6.749  16.150  1.00  0.00           O
ATOM   1707  HN  GLY   101      86.381   9.406  13.386  1.00  0.00           H
ATOM   1708  HA1 GLY   101      84.966   9.228  15.870  1.00  0.00           H
ATOM   1709  HA2 GLY   101      86.618   8.702  15.572  1.00  0.00           H
ATOM   1710  N   THR   102      85.421   6.528  14.101  1.00  0.00           N
ATOM   1711  CA  THR   102      85.081   5.124  13.978  1.00  0.00           C
ATOM   1712  C   THR   102      86.089   4.278  14.747  1.00  0.00           C
ATOM   1713  O   THR   102      87.214   4.062  14.292  1.00  0.00           O
ATOM   1714  CB  THR   102      85.048   4.682  12.499  1.00  0.00           C
ATOM   1715  CG2 THR   102      84.578   3.240  12.370  1.00  0.00           C
ATOM   1716  OG1 THR   102      84.169   5.539  11.753  1.00  0.00           O
ATOM   1717  HN  THR   102      85.889   6.974  13.359  1.00  0.00           H
ATOM   1718  HA  THR   102      84.098   4.977  14.404  1.00  0.00           H
ATOM   1719  HB  THR   102      86.045   4.760  12.093  1.00  0.00           H
ATOM   1720  HG1 THR   102      83.379   5.718  12.274  1.00  0.00           H
ATOM   1721 HG21 THR   102      83.578   3.150  12.766  1.00  0.00           H
ATOM   1722 HG22 THR   102      85.243   2.593  12.922  1.00  0.00           H
ATOM   1723 HG23 THR   102      84.579   2.953  11.327  1.00  0.00           H
END
