
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  136 ( 1053),  selected  136 , name 3cdh_B
# Molecule2: number of CA atoms  109 (  848),  selected  109 , name T0459.pdb
# PARAMETERS: 3cdh_B.T0459.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    D     7_B      S       1           -
LGA    T     8_B      N       2           -
LGA    F     9_B      A       3           -
LGA    V    10_B      M       4           -
LGA    S    11_B      L       5           -
LGA    G    12_B      R       6           -
LGA    Y    13_B      Y       7           -
LGA    L    14_B      G       8           -
LGA    L    15_B      D       9           -
LGA    Y    16_B      T      10           -
LGA    L    17_B      E      11           -
LGA    L    18_B      I      12           -
LGA    A    19_B      C      13           -
LGA    A    20_B      I      14           -
LGA    S    21_B      D      15           -
LGA    S    22_B      -       -           -
LGA    E    23_B      -       -           -
LGA    E    24_B      -       -           -
LGA    A    25_B      -       -           -
LGA    S    26_B      -       -           -
LGA    A    27_B      -       -           -
LGA    Q    28_B      -       -           -
LGA    F    29_B      -       -           -
LGA    H    30_B      -       -           -
LGA    D    31_B      -       -           -
LGA    H    32_B      -       -           -
LGA    I    33_B      -       -           -
LGA    R    34_B      -       -           -
LGA    A    35_B      P      16           #
LGA    -       -      S      17           -
LGA    -       -      E      18           -
LGA    -       -      S      19           -
LGA    -       -      V      20           -
LGA    Q    36_B      L      21          3.687
LGA    G    37_B      H      22          2.608
LGA    L    38_B      L      23          3.472
LGA    -       -      L      24           -
LGA    -       -      G      25           -
LGA    R    39_B      K      26          1.119
LGA    V    40_B      K      27          2.037
LGA    P    41_B      Y      28          1.754
LGA    E    42_B      T      29          1.211
LGA    W    43_B      M      30          1.128
LGA    R    44_B      L      31          1.445
LGA    V    45_B      I      32          0.633
LGA    L    46_B      I      33          0.714
LGA    A    47_B      S      34          1.508
LGA    C    48_B      V      35          0.642
LGA    L    49_B      L      36          1.164
LGA    V    50_B      G      37          1.971
LGA    D    51_B      N      38          2.188
LGA    N    52_B      G      39          3.054
LGA    -       -      S      40           -
LGA    D    53_B      T      41          4.091
LGA    A    54_B      R      42          1.695
LGA    X    55_B      Q      43          1.074
LGA    X    56_B      N      44          0.797
LGA    I    57_B      F      45          1.055
LGA    T    58_B      N      46          1.660
LGA    R    59_B      D      47          2.029
LGA    L    60_B      I      48          1.365
LGA    A    61_B      R      49          1.769
LGA    K    62_B      S      50          2.444
LGA    L    63_B      S      51          2.226
LGA    S    64_B      I      52          2.415
LGA    L    65_B      P      53          3.692
LGA    -       -      G      54           -
LGA    X    66_B      I      55          2.118
LGA    E    67_B      S      56          2.231
LGA    Q    68_B      S      57          1.861
LGA    S    69_B      T      58          3.113
LGA    R    70_B      I      59          2.890
LGA    X    71_B      L      60          1.416
LGA    T    72_B      S      61          1.220
LGA    R    73_B      R      62          1.966
LGA    I    74_B      R      63          1.656
LGA    V    75_B      I      64          0.652
LGA    D    76_B      K      65          1.230
LGA    Q    77_B      D      66          1.367
LGA    X    78_B      L      67          0.676
LGA    D    79_B      I      68          0.573
LGA    A    80_B      D      69          0.965
LGA    R    81_B      S      70          0.916
LGA    G    82_B      G      71          0.477
LGA    L    83_B      L      72          0.723
LGA    V    84_B      V      73          0.290
LGA    T    85_B      E      74          0.478
LGA    R    86_B      R      75          1.257
LGA    V    87_B      R      76          2.603
LGA    A    88_B      S      77          4.543
LGA    D    89_B      G      78          1.799
LGA    A    90_B      Q      79          3.646
LGA    R    95_B      I      80          3.764
LGA    V    96_B      T      81          1.137
LGA    R    97_B      T      82          0.730
LGA    V    98_B      Y      83          0.256
LGA    R    99_B      A      84          0.291
LGA    L   100_B      L      85          0.267
LGA    T   101_B      T      86          0.344
LGA    D   102_B      E      87          0.659
LGA    D   103_B      K      88          0.533
LGA    G   104_B      G      89          0.347
LGA    R   105_B      M      90          0.611
LGA    A   106_B      N      91          0.800
LGA    L   107_B      V      92          0.488
LGA    A   108_B      R      93          1.291
LGA    E   109_B      N      94          1.721
LGA    S   110_B      S      95          1.096
LGA    L   111_B      L      96          1.065
LGA    V   112_B      M      97          1.663
LGA    A   113_B      P      98          1.481
LGA    S   114_B      L      99          0.542
LGA    A   115_B      L     100          0.631
LGA    R   116_B      Q     101          0.213
LGA    A   117_B      Y     102          1.847
LGA    H   118_B      I     103          2.456
LGA    E   119_B      S     104          1.840
LGA    T   120_B      V     105          2.551
LGA    R   121_B      L     106          4.154
LGA    L   122_B      D     107          4.431
LGA    L   123_B      R     108          3.692
LGA    S   124_B      N     109           #
LGA    A   125_B      -       -           -
LGA    L   126_B      -       -           -
LGA    A   127_B      -       -           -
LGA    D   128_B      -       -           -
LGA    T   129_B      -       -           -
LGA    D   130_B      -       -           -
LGA    A   131_B      -       -           -
LGA    A   132_B      -       -           -
LGA    R   133_B      -       -           -
LGA    I   134_B      -       -           -
LGA    K   135_B      -       -           -
LGA    G   136_B      -       -           -
LGA    V   137_B      -       -           -
LGA    L   138_B      -       -           -
LGA    R   139_B      -       -           -
LGA    T   140_B      -       -           -
LGA    L   141_B      -       -           -
LGA    L   142_B      -       -           -
LGA    D   143_B      -       -           -
LGA    V   144_B      -       -           -
LGA    L   145_B      -       -           -
LGA    D   146_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  136  109    5.0     84    1.98    14.29     69.359     4.044

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.584786 * X  +   0.161717 * Y  +   0.794904 * Z  + -25.870312
  Y_new =  -0.778659 * X  +   0.162806 * Y  +  -0.605957 * Z  +  94.807358
  Z_new =  -0.227408 * X  +  -0.973315 * Y  +   0.030716 * Z  +  11.370639 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.539249    1.602344  [ DEG:   -88.1925     91.8075 ]
  Theta =   0.229415    2.912177  [ DEG:    13.1445    166.8555 ]
  Phi   =  -2.214948    0.926645  [ DEG:  -126.9072     53.0928 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3cdh_B                                        
REMARK     2: T0459.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3cdh_B.T0459.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  136  109   5.0   84   1.98   14.29  69.359
REMARK  ---------------------------------------------------------- 
MOLECULE 3cdh_B
HEADER    TRANSCRIPTION REGULATOR                 26-FEB-08   3CDH              
TITLE     CRYSTAL STRUCTURE OF THE MARR FAMILY TRANSCRIPTIONAL                  
TITLE    2 REGULATOR SPO1453 FROM SILICIBACTER POMEROYI DSS-3                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TRANSCRIPTIONAL REGULATOR, MARR FAMILY;                    
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SILICIBACTER POMEROYI DSS-3;                    
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: DSS-3 / DSM 15171;                                           
SOURCE   5 ATCC: 700808;                                                        
SOURCE   6 GENE: SPO1453;                                                       
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    MARR, HELIX-TURN-HLEIX, TRANSCRIPTIONAL REGULATOR,                    
KEYWDS   2 STRUCTURAL GENOMICS, PSI-2, PROTEIN STRUCTURE INITIATIVE,            
KEYWDS   3 MIDWEST CENTER FOR STRUCTURAL GENOMICS, MCSG, DNA-BINDING,           
KEYWDS   4 TRANSCRIPTION REGULATION, TRANSCRIPTION REGULATOR                    
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.KIM,L.VOLKART,L.KEIGHER,A.JOACHIMIAK,MIDWEST CENTER FOR             
AUTHOR   2 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   1   18-MAR-08 3CDH    0                                                
JRNL        AUTH   Y.KIM,L.VOLKART,L.KEIGHER,A.JOACHIMIAK                       
JRNL        TITL   CRYSTAL STRUCTURE OF THE MARR FAMILY                         
JRNL        TITL 2 TRANSCRIPTIONAL REGULATOR SPO1453 FROM                       
JRNL        TITL 3 SILICIBACTER POMEROYI.                                       
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.69 ANGSTROMS.                                          
DBREF  3CDH A    1   152  UNP    Q5LTG1   Q5LTG1_SILPO     1    152             
DBREF  3CDH B    1   152  UNP    Q5LTG1   Q5LTG1_SILPO     1    152             
SEQRES   1 A  155  SER ASN ALA MSE ASN ASP THR PRO ASP ASP THR PHE VAL          
SEQRES   2 A  155  SER GLY TYR LEU LEU TYR LEU LEU ALA ALA SER SER GLU          
SEQRES   3 A  155  GLU ALA SER ALA GLN PHE HIS ASP HIS ILE ARG ALA GLN          
SEQRES   4 A  155  GLY LEU ARG VAL PRO GLU TRP ARG VAL LEU ALA CYS LEU          
SEQRES   5 A  155  VAL ASP ASN ASP ALA MSE MSE ILE THR ARG LEU ALA LYS          
SEQRES   6 A  155  LEU SER LEU MSE GLU GLN SER ARG MSE THR ARG ILE VAL          
SEQRES   7 A  155  ASP GLN MSE ASP ALA ARG GLY LEU VAL THR ARG VAL ALA          
SEQRES   8 A  155  ASP ALA LYS ASP LYS ARG ARG VAL ARG VAL ARG LEU THR          
SEQRES   9 A  155  ASP ASP GLY ARG ALA LEU ALA GLU SER LEU VAL ALA SER          
SEQRES  10 A  155  ALA ARG ALA HIS GLU THR ARG LEU LEU SER ALA LEU ALA          
SEQRES  11 A  155  ASP THR ASP ALA ALA ARG ILE LYS GLY VAL LEU ARG THR          
SEQRES  12 A  155  LEU LEU ASP VAL LEU ASP ARG PRO ARG GLU SER ARG              
SEQRES   1 B  155  SER ASN ALA MSE ASN ASP THR PRO ASP ASP THR PHE VAL          
SEQRES   2 B  155  SER GLY TYR LEU LEU TYR LEU LEU ALA ALA SER SER GLU          
SEQRES   3 B  155  GLU ALA SER ALA GLN PHE HIS ASP HIS ILE ARG ALA GLN          
SEQRES   4 B  155  GLY LEU ARG VAL PRO GLU TRP ARG VAL LEU ALA CYS LEU          
SEQRES   5 B  155  VAL ASP ASN ASP ALA MSE MSE ILE THR ARG LEU ALA LYS          
SEQRES   6 B  155  LEU SER LEU MSE GLU GLN SER ARG MSE THR ARG ILE VAL          
SEQRES   7 B  155  ASP GLN MSE ASP ALA ARG GLY LEU VAL THR ARG VAL ALA          
SEQRES   8 B  155  ASP ALA LYS ASP LYS ARG ARG VAL ARG VAL ARG LEU THR          
SEQRES   9 B  155  ASP ASP GLY ARG ALA LEU ALA GLU SER LEU VAL ALA SER          
SEQRES  10 B  155  ALA ARG ALA HIS GLU THR ARG LEU LEU SER ALA LEU ALA          
SEQRES  11 B  155  ASP THR ASP ALA ALA ARG ILE LYS GLY VAL LEU ARG THR          
SEQRES  12 B  155  LEU LEU ASP VAL LEU ASP ARG PRO ARG GLU SER ARG              
HET    MSE  A  55       8                                                       
HET    MSE  A  56       8                                                       
HET    MSE  A  66       8                                                       
HET    MSE  A  71       8                                                       
HET    MSE  A  78       8                                                       
HET    MSE  B  55       8                                                       
HET    MSE  B  56       8                                                       
HET    MSE  B  66       8                                                       
HET    MSE  B  71       8                                                       
HET    MSE  B  78       8                                                       
HET    SO4  A 201       5                                                       
HET    SO4  A 202       5                                                       
HET    SO4  A 203       5                                                       
HET    SO4  A 204       5                                                       
HET    SO4  B 205       5                                                       
HET    SO4  A 206       5                                                       
HET    GOL  A 207       6                                                       
HET    GOL  B 208       6                                                       
HET    GOL  B 209       6                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     SO4 SULFATE ION                                                      
HETNAM     GOL GLYCEROL                                                         
FORMUL   1  MSE    10(C5 H11 N O2 SE)                                           
FORMUL   3  SO4    6(O4 S 2-)                                                   
FORMUL   9  GOL    3(C3 H8 O3)                                                  
FORMUL  12  HOH   *113(H2 O)                                                    
CRYST1  124.140  124.140  140.186  90.00  90.00 120.00 P 62 2 2     24          
ATOM   1204  N   ASP B   7      32.696  10.444 -10.852  1.00 72.69           N  
ATOM   1205  CA  ASP B   7      31.688  10.073  -9.793  1.00 71.73           C  
ATOM   1206  C   ASP B   7      30.689   9.040 -10.356  1.00 70.07           C  
ATOM   1207  O   ASP B   7      31.063   8.286 -11.264  1.00 71.72           O  
ATOM   1208  CB  ASP B   7      31.016  11.301  -9.126  1.00 70.42           C  
ATOM   1209  CG  ASP B   7      30.582  10.993  -7.659  1.00 75.22           C  
ATOM   1210  OD1 ASP B   7      31.254  10.152  -6.978  1.00 78.13           O  
ATOM   1211  OD2 ASP B   7      29.558  11.545  -7.182  1.00 75.42           O  
ATOM   1212  N   THR B   8      29.454   8.989  -9.828  1.00 66.49           N  
ATOM   1213  CA  THR B   8      28.478   7.921 -10.150  1.00 62.97           C  
ATOM   1214  C   THR B   8      27.488   8.398 -11.209  1.00 58.93           C  
ATOM   1215  O   THR B   8      27.335   9.603 -11.395  1.00 57.38           O  
ATOM   1216  CB  THR B   8      27.632   7.531  -8.919  1.00 63.57           C  
ATOM   1217  OG1 THR B   8      26.729   8.599  -8.596  1.00 62.07           O  
ATOM   1218  CG2 THR B   8      28.483   7.235  -7.714  1.00 65.27           C  
ATOM   1219  N   PHE B   9      26.783   7.471 -11.857  1.00 56.05           N  
ATOM   1220  CA  PHE B   9      25.826   7.800 -12.893  1.00 52.70           C  
ATOM   1221  C   PHE B   9      24.701   8.740 -12.429  1.00 51.47           C  
ATOM   1222  O   PHE B   9      24.512   9.806 -13.002  1.00 49.68           O  
ATOM   1223  CB  PHE B   9      25.262   6.541 -13.546  1.00 52.77           C  
ATOM   1224  CG  PHE B   9      24.049   6.788 -14.389  1.00 50.61           C  
ATOM   1225  CD1 PHE B   9      24.139   7.531 -15.577  1.00 48.51           C  
ATOM   1226  CD2 PHE B   9      22.808   6.315 -13.994  1.00 47.61           C  
ATOM   1227  CE1 PHE B   9      22.995   7.798 -16.365  1.00 45.84           C  
ATOM   1228  CE2 PHE B   9      21.664   6.572 -14.766  1.00 47.42           C  
ATOM   1229  CZ  PHE B   9      21.763   7.324 -15.967  1.00 47.93           C  
ATOM   1230  N   VAL B  10      23.950   8.362 -11.396  1.00 51.84           N  
ATOM   1231  CA  VAL B  10      22.837   9.179 -10.965  1.00 50.12           C  
ATOM   1232  C   VAL B  10      23.291  10.626 -10.668  1.00 50.41           C  
ATOM   1233  O   VAL B  10      22.706  11.601 -11.164  1.00 49.18           O  
ATOM   1234  CB  VAL B  10      22.094   8.530  -9.800  1.00 50.23           C  
ATOM   1235  CG1 VAL B  10      20.986   9.415  -9.299  1.00 48.04           C  
ATOM   1236  CG2 VAL B  10      21.489   7.219 -10.250  1.00 51.99           C  
ATOM   1237  N   SER B  11      24.348  10.774  -9.885  1.00 52.23           N  
ATOM   1238  CA  SER B  11      24.769  12.106  -9.450  1.00 52.78           C  
ATOM   1239  C   SER B  11      25.042  13.108 -10.592  1.00 51.57           C  
ATOM   1240  O   SER B  11      24.847  14.318 -10.396  1.00 51.71           O  
ATOM   1241  CB  SER B  11      26.000  12.001  -8.541  1.00 55.06           C  
ATOM   1242  OG  SER B  11      27.186  11.866  -9.321  1.00 57.61           O  
ATOM   1243  N   GLY B  12      25.505  12.620 -11.755  1.00 51.14           N  
ATOM   1244  CA  GLY B  12      25.647  13.458 -12.968  1.00 48.87           C  
ATOM   1245  C   GLY B  12      24.596  13.326 -14.085  1.00 47.27           C  
ATOM   1246  O   GLY B  12      24.737  13.900 -15.144  1.00 47.69           O  
ATOM   1247  N   TYR B  13      23.522  12.592 -13.864  1.00 46.07           N  
ATOM   1248  CA  TYR B  13      22.564  12.324 -14.918  1.00 44.99           C  
ATOM   1249  C   TYR B  13      21.596  13.493 -15.083  1.00 43.88           C  
ATOM   1250  O   TYR B  13      21.031  13.970 -14.097  1.00 42.87           O  
ATOM   1251  CB  TYR B  13      21.822  11.077 -14.522  1.00 45.33           C  
ATOM   1252  CG  TYR B  13      20.737  10.604 -15.422  1.00 45.03           C  
ATOM   1253  CD1 TYR B  13      20.862  10.649 -16.807  1.00 44.89           C  
ATOM   1254  CD2 TYR B  13      19.582  10.047 -14.876  1.00 43.85           C  
ATOM   1255  CE1 TYR B  13      19.839  10.174 -17.633  1.00 45.78           C  
ATOM   1256  CE2 TYR B  13      18.570   9.569 -15.685  1.00 44.07           C  
ATOM   1257  CZ  TYR B  13      18.706   9.632 -17.054  1.00 45.67           C  
ATOM   1258  OH  TYR B  13      17.703   9.136 -17.826  1.00 47.55           O  
ATOM   1259  N   LEU B  14      21.399  13.953 -16.325  1.00 43.56           N  
ATOM   1260  CA  LEU B  14      20.580  15.139 -16.569  1.00 42.03           C  
ATOM   1261  C   LEU B  14      19.184  15.033 -15.958  1.00 41.14           C  
ATOM   1262  O   LEU B  14      18.713  15.984 -15.329  1.00 40.67           O  
ATOM   1263  CB  LEU B  14      20.471  15.469 -18.047  1.00 41.97           C  
ATOM   1264  CG  LEU B  14      19.569  16.708 -18.281  1.00 41.86           C  
ATOM   1265  CD1 LEU B  14      20.160  17.999 -17.735  1.00 37.89           C  
ATOM   1266  CD2 LEU B  14      19.180  16.897 -19.752  1.00 40.57           C  
ATOM   1267  N   LEU B  15      18.539  13.879 -16.141  1.00 41.31           N  
ATOM   1268  CA  LEU B  15      17.164  13.674 -15.686  1.00 41.11           C  
ATOM   1269  C   LEU B  15      17.068  13.682 -14.162  1.00 40.96           C  
ATOM   1270  O   LEU B  15      16.113  14.221 -13.587  1.00 40.10           O  
ATOM   1271  CB  LEU B  15      16.561  12.410 -16.297  1.00 41.84           C  
ATOM   1272  CG  LEU B  15      15.765  12.627 -17.603  1.00 42.29           C  
ATOM   1273  CD1 LEU B  15      16.397  13.642 -18.530  1.00 42.71           C  
ATOM   1274  CD2 LEU B  15      15.559  11.333 -18.351  1.00 43.12           C  
ATOM   1275  N   TYR B  16      18.090  13.134 -13.507  1.00 42.04           N  
ATOM   1276  CA  TYR B  16      18.161  13.212 -12.064  1.00 42.04           C  
ATOM   1277  C   TYR B  16      18.306  14.667 -11.633  1.00 41.70           C  
ATOM   1278  O   TYR B  16      17.561  15.146 -10.777  1.00 41.62           O  
ATOM   1279  CB  TYR B  16      19.294  12.361 -11.503  1.00 42.99           C  
ATOM   1280  CG  TYR B  16      19.547  12.693 -10.061  1.00 43.65           C  
ATOM   1281  CD1 TYR B  16      20.561  13.580  -9.705  1.00 46.34           C  
ATOM   1282  CD2 TYR B  16      18.736  12.184  -9.047  1.00 43.93           C  
ATOM   1283  CE1 TYR B  16      20.792  13.921  -8.381  1.00 44.78           C  
ATOM   1284  CE2 TYR B  16      18.965  12.507  -7.721  1.00 43.13           C  
ATOM   1285  CZ  TYR B  16      19.986  13.380  -7.408  1.00 44.70           C  
ATOM   1286  OH  TYR B  16      20.231  13.715  -6.125  1.00 45.81           O  
ATOM   1287  N   LEU B  17      19.257  15.378 -12.235  1.00 42.02           N  
ATOM   1288  CA  LEU B  17      19.499  16.756 -11.865  1.00 41.26           C  
ATOM   1289  C   LEU B  17      18.251  17.591 -12.091  1.00 41.13           C  
ATOM   1290  O   LEU B  17      17.922  18.433 -11.253  1.00 41.40           O  
ATOM   1291  CB  LEU B  17      20.658  17.321 -12.638  1.00 41.33           C  
ATOM   1292  CG  LEU B  17      22.010  16.725 -12.259  1.00 42.40           C  
ATOM   1293  CD1 LEU B  17      23.015  17.149 -13.300  1.00 40.82           C  
ATOM   1294  CD2 LEU B  17      22.460  17.116 -10.875  1.00 41.16           C  
ATOM   1295  N   LEU B  18      17.528  17.362 -13.191  1.00 40.67           N  
ATOM   1296  CA  LEU B  18      16.291  18.117 -13.390  1.00 39.50           C  
ATOM   1297  C   LEU B  18      15.270  17.798 -12.285  1.00 39.31           C  
ATOM   1298  O   LEU B  18      14.724  18.709 -11.643  1.00 38.89           O  
ATOM   1299  CB  LEU B  18      15.702  17.854 -14.769  1.00 39.44           C  
ATOM   1300  CG  LEU B  18      16.328  18.584 -15.970  1.00 39.58           C  
ATOM   1301  CD1 LEU B  18      15.763  18.063 -17.279  1.00 37.33           C  
ATOM   1302  CD2 LEU B  18      16.146  20.089 -15.894  1.00 37.25           C  
ATOM   1303  N   ALA B  19      15.049  16.507 -12.035  1.00 38.90           N  
ATOM   1304  CA  ALA B  19      13.982  16.101 -11.139  1.00 38.44           C  
ATOM   1305  C   ALA B  19      14.263  16.510  -9.687  1.00 38.74           C  
ATOM   1306  O   ALA B  19      13.373  17.004  -8.992  1.00 38.47           O  
ATOM   1307  CB  ALA B  19      13.732  14.633 -11.259  1.00 38.08           C  
ATOM   1308  N   ALA B  20      15.500  16.335  -9.246  1.00 39.79           N  
ATOM   1309  CA  ALA B  20      15.901  16.752  -7.909  1.00 40.77           C  
ATOM   1310  C   ALA B  20      15.749  18.268  -7.735  1.00 41.18           C  
ATOM   1311  O   ALA B  20      15.180  18.736  -6.732  1.00 41.86           O  
ATOM   1312  CB  ALA B  20      17.323  16.322  -7.623  1.00 41.23           C  
ATOM   1313  N   SER B  21      16.234  19.030  -8.705  1.00 41.51           N  
ATOM   1314  CA  SER B  21      16.097  20.479  -8.678  1.00 42.86           C  
ATOM   1315  C   SER B  21      14.661  20.909  -8.502  1.00 43.03           C  
ATOM   1316  O   SER B  21      14.344  21.753  -7.660  1.00 43.55           O  
ATOM   1317  CB  SER B  21      16.577  21.067  -9.980  1.00 42.58           C  
ATOM   1318  OG  SER B  21      17.956  20.865 -10.074  1.00 46.11           O  
ATOM   1319  N   SER B  22      13.786  20.338  -9.316  1.00 42.99           N  
ATOM   1320  CA  SER B  22      12.423  20.781  -9.321  1.00 43.29           C  
ATOM   1321  C   SER B  22      11.832  20.463  -7.929  1.00 44.31           C  
ATOM   1322  O   SER B  22      11.146  21.289  -7.334  1.00 43.89           O  
ATOM   1323  CB  SER B  22      11.678  20.089 -10.454  1.00 42.55           C  
ATOM   1324  OG  SER B  22      10.302  20.384 -10.409  1.00 42.59           O  
ATOM   1325  N   GLU B  23      12.145  19.281  -7.405  1.00 44.99           N  
ATOM   1326  CA  GLU B  23      11.704  18.898  -6.101  1.00 46.70           C  
ATOM   1327  C   GLU B  23      12.216  19.856  -5.014  1.00 48.17           C  
ATOM   1328  O   GLU B  23      11.428  20.407  -4.230  1.00 48.19           O  
ATOM   1329  CB  GLU B  23      12.242  17.529  -5.832  1.00 48.06           C  
ATOM   1330  CG  GLU B  23      12.155  17.084  -4.400  1.00 53.08           C  
ATOM   1331  CD  GLU B  23      11.255  15.893  -4.283  1.00 59.92           C  
ATOM   1332  OE1 GLU B  23      10.151  15.950  -4.890  1.00 59.86           O  
ATOM   1333  OE2 GLU B  23      11.671  14.896  -3.619  1.00 64.98           O  
ATOM   1334  N   GLU B  24      13.530  20.053  -4.954  1.00 49.44           N  
ATOM   1335  CA  GLU B  24      14.098  20.874  -3.887  1.00 51.22           C  
ATOM   1336  C   GLU B  24      13.717  22.330  -4.014  1.00 51.57           C  
ATOM   1337  O   GLU B  24      13.550  23.019  -3.015  1.00 53.16           O  
ATOM   1338  CB  GLU B  24      15.602  20.720  -3.809  1.00 51.99           C  
ATOM   1339  CG  GLU B  24      15.947  19.401  -3.206  1.00 54.75           C  
ATOM   1340  CD  GLU B  24      17.427  19.163  -3.052  1.00 59.39           C  
ATOM   1341  OE1 GLU B  24      18.205  20.131  -2.866  1.00 62.61           O  
ATOM   1342  OE2 GLU B  24      17.814  17.974  -3.094  1.00 60.47           O  
ATOM   1343  N   ALA B  25      13.567  22.810  -5.240  1.00 50.81           N  
ATOM   1344  CA  ALA B  25      13.226  24.207  -5.418  1.00 50.58           C  
ATOM   1345  C   ALA B  25      11.787  24.456  -4.974  1.00 49.78           C  
ATOM   1346  O   ALA B  25      11.512  25.499  -4.363  1.00 50.60           O  
ATOM   1347  CB  ALA B  25      13.449  24.649  -6.856  1.00 49.90           C  
ATOM   1348  N   SER B  26      10.901  23.501  -5.282  0.60 48.18           N  
ATOM   1350  CA  SER B  26       9.468  23.573  -4.984  0.60 47.44           C  
ATOM   1352  C   SER B  26       9.139  23.313  -3.517  0.60 48.46           C  
ATOM   1354  O   SER B  26       8.090  23.730  -3.013  0.60 48.20           O  
ATOM   1356  CB  SER B  26       8.712  22.542  -5.815  0.60 45.95           C  
ATOM   1358  OG  SER B  26       8.391  23.051  -7.088  0.60 45.38           O  
ATOM   1360  N   ALA B  27      10.028  22.599  -2.839  1.00 49.62           N  
ATOM   1361  CA  ALA B  27       9.740  22.099  -1.489  1.00 51.31           C  
ATOM   1362  C   ALA B  27       9.179  23.179  -0.555  1.00 52.79           C  
ATOM   1363  O   ALA B  27       8.117  22.984   0.062  1.00 52.17           O  
ATOM   1364  CB  ALA B  27      10.961  21.388  -0.871  1.00 52.09           C  
ATOM   1365  N   GLN B  28       9.849  24.323  -0.492  1.00 54.17           N  
ATOM   1366  CA  GLN B  28       9.429  25.329   0.471  1.00 57.51           C  
ATOM   1367  C   GLN B  28       8.049  25.885   0.141  1.00 54.81           C  
ATOM   1368  O   GLN B  28       7.189  25.994   1.003  1.00 56.10           O  
ATOM   1369  CB  GLN B  28      10.461  26.438   0.601  1.00 59.22           C  
ATOM   1370  CG  GLN B  28      10.495  27.139   1.967  1.00 65.76           C  
ATOM   1371  CD  GLN B  28      11.291  28.470   1.902  1.00 69.00           C  
ATOM   1372  OE1 GLN B  28      12.527  28.484   2.098  1.00 76.48           O  
ATOM   1373  NE2 GLN B  28      10.586  29.588   1.576  1.00 75.57           N  
ATOM   1374  N   PHE B  29       7.811  26.201  -1.114  1.00 52.60           N  
ATOM   1375  CA  PHE B  29       6.506  26.686  -1.478  1.00 50.68           C  
ATOM   1376  C   PHE B  29       5.416  25.641  -1.293  1.00 49.39           C  
ATOM   1377  O   PHE B  29       4.294  25.975  -0.877  1.00 49.08           O  
ATOM   1378  CB  PHE B  29       6.474  27.223  -2.901  1.00 49.82           C  
ATOM   1379  CG  PHE B  29       5.276  28.058  -3.167  1.00 48.94           C  
ATOM   1380  CD1 PHE B  29       5.077  29.241  -2.447  1.00 48.43           C  
ATOM   1381  CD2 PHE B  29       4.306  27.638  -4.063  1.00 47.21           C  
ATOM   1382  CE1 PHE B  29       3.946  30.005  -2.639  1.00 48.84           C  
ATOM   1383  CE2 PHE B  29       3.155  28.416  -4.279  1.00 46.57           C  
ATOM   1384  CZ  PHE B  29       2.978  29.596  -3.562  1.00 47.84           C  
ATOM   1385  N   HIS B  30       5.732  24.386  -1.611  1.00 47.84           N  
ATOM   1386  CA  HIS B  30       4.766  23.337  -1.389  1.00 46.82           C  
ATOM   1387  C   HIS B  30       4.430  23.219   0.105  1.00 47.22           C  
ATOM   1388  O   HIS B  30       3.268  23.042   0.452  1.00 46.96           O  
ATOM   1389  CB  HIS B  30       5.180  22.014  -2.035  1.00 46.55           C  
ATOM   1390  CG  HIS B  30       5.171  22.035  -3.539  1.00 48.18           C  
ATOM   1391  ND1 HIS B  30       5.643  20.982  -4.298  1.00 50.60           N  
ATOM   1392  CD2 HIS B  30       4.764  22.983  -4.427  1.00 49.09           C  
ATOM   1393  CE1 HIS B  30       5.521  21.281  -5.587  1.00 50.24           C  
ATOM   1394  NE2 HIS B  30       4.997  22.490  -5.694  1.00 47.45           N  
ATOM   1395  N   ASP B  31       5.420  23.378   0.980  1.00 48.14           N  
ATOM   1396  CA  ASP B  31       5.174  23.471   2.433  1.00 49.37           C  
ATOM   1397  C   ASP B  31       4.070  24.495   2.773  1.00 49.43           C  
ATOM   1398  O   ASP B  31       3.192  24.252   3.627  1.00 49.04           O  
ATOM   1399  CB  ASP B  31       6.452  23.842   3.213  1.00 50.91           C  
ATOM   1400  CG  ASP B  31       7.544  22.770   3.144  1.00 51.94           C  
ATOM   1401  OD1 ASP B  31       7.224  21.570   2.960  1.00 52.07           O  
ATOM   1402  OD2 ASP B  31       8.742  23.139   3.287  0.50 52.92           O  
ATOM   1403  N   HIS B  32       4.142  25.628   2.089  1.00 49.42           N  
ATOM   1404  CA  HIS B  32       3.230  26.727   2.284  1.00 50.59           C  
ATOM   1405  C   HIS B  32       1.818  26.388   1.822  1.00 49.38           C  
ATOM   1406  O   HIS B  32       0.848  26.633   2.543  1.00 50.29           O  
ATOM   1407  CB  HIS B  32       3.771  27.963   1.566  1.00 51.74           C  
ATOM   1408  CG  HIS B  32       2.903  29.168   1.701  1.00 54.28           C  
ATOM   1409  ND1 HIS B  32       2.626  29.749   2.919  1.00 58.37           N  
ATOM   1410  CD2 HIS B  32       2.242  29.899   0.777  1.00 55.02           C  
ATOM   1411  CE1 HIS B  32       1.819  30.778   2.742  1.00 59.22           C  
ATOM   1412  NE2 HIS B  32       1.583  30.900   1.449  1.00 58.63           N  
ATOM   1413  N   ILE B  33       1.702  25.825   0.626  1.00 47.94           N  
ATOM   1414  CA  ILE B  33       0.418  25.358   0.107  1.00 47.28           C  
ATOM   1415  C   ILE B  33      -0.228  24.362   1.085  1.00 47.46           C  
ATOM   1416  O   ILE B  33      -1.411  24.482   1.401  1.00 47.06           O  
ATOM   1417  CB  ILE B  33       0.620  24.756  -1.332  1.00 46.31           C  
ATOM   1418  CG1 ILE B  33       0.378  25.831  -2.350  1.00 48.84           C  
ATOM   1419  CG2 ILE B  33      -0.361  23.670  -1.724  1.00 44.34           C  
ATOM   1420  CD1 ILE B  33       1.433  26.820  -2.374  1.00 54.54           C  
ATOM   1421  N   ARG B  34       0.565  23.392   1.543  0.50 47.65           N  
ATOM   1423  CA  ARG B  34       0.119  22.342   2.448  0.50 48.30           C  
ATOM   1425  C   ARG B  34      -0.489  22.986   3.697  0.50 49.34           C  
ATOM   1427  O   ARG B  34      -1.606  22.647   4.096  0.50 49.27           O  
ATOM   1429  CB  ARG B  34       1.297  21.421   2.795  0.50 48.97           C  
ATOM   1431  CG  ARG B  34       0.941  19.972   3.180  0.50 50.24           C  
ATOM   1433  CD  ARG B  34       2.095  18.956   2.907  0.50 49.83           C  
ATOM   1435  NE  ARG B  34       2.448  18.924   1.485  0.50 48.16           N  
ATOM   1437  CZ  ARG B  34       3.628  19.301   0.993  0.50 48.44           C  
ATOM   1439  NH1 ARG B  34       4.590  19.711   1.821  0.50 48.56           N  
ATOM   1441  NH2 ARG B  34       3.849  19.262  -0.326  0.50 45.34           N  
ATOM   1443  N   ALA B  35       0.229  23.950   4.273  1.00 50.45           N  
ATOM   1444  CA  ALA B  35      -0.227  24.684   5.456  1.00 51.40           C  
ATOM   1445  C   ALA B  35      -1.550  25.411   5.241  1.00 50.84           C  
ATOM   1446  O   ALA B  35      -2.358  25.528   6.176  1.00 52.96           O  
ATOM   1447  CB  ALA B  35       0.825  25.651   5.922  1.00 52.55           C  
ATOM   1448  N   GLN B  36      -1.756  25.884   4.010  0.60 49.05           N  
ATOM   1450  CA  GLN B  36      -2.980  26.550   3.566  0.60 48.31           C  
ATOM   1452  C   GLN B  36      -4.135  25.567   3.358  0.60 46.82           C  
ATOM   1454  O   GLN B  36      -5.206  25.971   2.918  0.60 46.39           O  
ATOM   1456  CB  GLN B  36      -2.729  27.265   2.229  0.60 47.78           C  
ATOM   1458  CG  GLN B  36      -1.981  28.582   2.280  0.60 50.42           C  
ATOM   1460  CD  GLN B  36      -2.932  29.773   2.408  0.60 55.06           C  
ATOM   1462  OE1 GLN B  36      -3.803  29.995   1.544  0.60 52.93           O  
ATOM   1464  NE2 GLN B  36      -2.777  30.546   3.502  0.60 56.85           N  
ATOM   1466  N   GLY B  37      -3.918  24.286   3.656  1.00 46.16           N  
ATOM   1467  CA  GLY B  37      -4.902  23.228   3.393  1.00 44.98           C  
ATOM   1468  C   GLY B  37      -5.153  22.846   1.929  1.00 43.98           C  
ATOM   1469  O   GLY B  37      -6.193  22.240   1.605  1.00 43.04           O  
ATOM   1470  N   LEU B  38      -4.208  23.204   1.057  1.00 43.21           N  
ATOM   1471  CA  LEU B  38      -4.327  23.000  -0.374  1.00 42.90           C  
ATOM   1472  C   LEU B  38      -3.399  21.911  -0.913  1.00 42.36           C  
ATOM   1473  O   LEU B  38      -2.290  21.715  -0.393  1.00 43.02           O  
ATOM   1474  CB  LEU B  38      -3.999  24.297  -1.106  1.00 43.05           C  
ATOM   1475  CG  LEU B  38      -5.148  25.271  -1.243  1.00 45.00           C  
ATOM   1476  CD1 LEU B  38      -4.652  26.496  -1.962  1.00 45.96           C  
ATOM   1477  CD2 LEU B  38      -6.257  24.615  -2.025  1.00 44.37           C  
ATOM   1478  N   ARG B  39      -3.837  21.234  -1.976  1.00 41.05           N  
ATOM   1479  CA  ARG B  39      -2.992  20.252  -2.650  1.00 40.26           C  
ATOM   1480  C   ARG B  39      -2.238  20.902  -3.813  1.00 39.93           C  
ATOM   1481  O   ARG B  39      -2.708  21.893  -4.414  1.00 39.61           O  
ATOM   1482  CB  ARG B  39      -3.832  19.087  -3.147  1.00 39.55           C  
ATOM   1483  CG  ARG B  39      -4.195  18.096  -2.110  1.00 39.80           C  
ATOM   1484  CD  ARG B  39      -5.311  17.188  -2.599  1.00 42.93           C  
ATOM   1485  NE  ARG B  39      -6.393  17.984  -3.205  1.00 46.72           N  
ATOM   1486  CZ  ARG B  39      -7.422  17.483  -3.905  1.00 47.73           C  
ATOM   1487  NH1 ARG B  39      -8.350  18.313  -4.407  1.00 45.76           N  
ATOM   1488  NH2 ARG B  39      -7.528  16.160  -4.105  1.00 45.95           N  
ATOM   1489  N   VAL B  40      -1.075  20.346  -4.146  1.00 39.67           N  
ATOM   1490  CA  VAL B  40      -0.264  20.920  -5.231  1.00 39.31           C  
ATOM   1491  C   VAL B  40      -1.039  21.073  -6.544  1.00 38.61           C  
ATOM   1492  O   VAL B  40      -1.005  22.125  -7.170  1.00 39.19           O  
ATOM   1493  CB  VAL B  40       1.062  20.159  -5.443  1.00 39.47           C  
ATOM   1494  CG1 VAL B  40       1.716  20.573  -6.759  1.00 39.57           C  
ATOM   1495  CG2 VAL B  40       1.988  20.420  -4.290  1.00 38.66           C  
ATOM   1496  N   PRO B  41      -1.772  20.045  -6.955  1.00 38.20           N  
ATOM   1497  CA  PRO B  41      -2.515  20.264  -8.195  1.00 37.98           C  
ATOM   1498  C   PRO B  41      -3.516  21.413  -8.082  1.00 38.35           C  
ATOM   1499  O   PRO B  41      -3.728  22.130  -9.070  1.00 38.08           O  
ATOM   1500  CB  PRO B  41      -3.259  18.948  -8.408  1.00 37.30           C  
ATOM   1501  CG  PRO B  41      -2.606  17.985  -7.540  1.00 37.97           C  
ATOM   1502  CD  PRO B  41      -1.976  18.696  -6.409  1.00 38.05           C  
ATOM   1503  N   GLU B  42      -4.146  21.583  -6.908  1.00 38.91           N  
ATOM   1504  CA  GLU B  42      -5.121  22.671  -6.749  1.00 39.68           C  
ATOM   1505  C   GLU B  42      -4.428  24.012  -6.944  1.00 40.05           C  
ATOM   1506  O   GLU B  42      -4.909  24.864  -7.678  1.00 41.60           O  
ATOM   1507  CB  GLU B  42      -5.830  22.602  -5.418  1.00 39.69           C  
ATOM   1508  CG  GLU B  42      -7.236  22.059  -5.491  1.00 43.27           C  
ATOM   1509  CD  GLU B  42      -7.712  21.478  -4.174  1.00 50.12           C  
ATOM   1510  OE1 GLU B  42      -8.926  21.193  -4.006  1.00 49.82           O  
ATOM   1511  OE2 GLU B  42      -6.858  21.275  -3.279  1.00 55.56           O  
ATOM   1512  N   TRP B  43      -3.252  24.183  -6.361  1.00 39.74           N  
ATOM   1513  CA  TRP B  43      -2.551  25.443  -6.534  1.00 39.95           C  
ATOM   1514  C   TRP B  43      -2.193  25.692  -8.001  1.00 39.88           C  
ATOM   1515  O   TRP B  43      -2.275  26.833  -8.489  1.00 40.88           O  
ATOM   1516  CB  TRP B  43      -1.345  25.507  -5.600  1.00 39.88           C  
ATOM   1517  CG  TRP B  43      -0.116  26.005  -6.211  1.00 41.16           C  
ATOM   1518  CD1 TRP B  43       0.963  25.256  -6.566  1.00 41.63           C  
ATOM   1519  CD2 TRP B  43       0.206  27.357  -6.547  1.00 42.07           C  
ATOM   1520  NE1 TRP B  43       1.945  26.051  -7.092  1.00 42.98           N  
ATOM   1521  CE2 TRP B  43       1.514  27.348  -7.095  1.00 42.68           C  
ATOM   1522  CE3 TRP B  43      -0.469  28.573  -6.434  1.00 42.52           C  
ATOM   1523  CZ2 TRP B  43       2.154  28.503  -7.548  1.00 43.04           C  
ATOM   1524  CZ3 TRP B  43       0.168  29.736  -6.889  1.00 44.51           C  
ATOM   1525  CH2 TRP B  43       1.464  29.688  -7.445  1.00 44.26           C  
ATOM   1526  N   ARG B  44      -1.815  24.635  -8.708  1.00 38.19           N  
ATOM   1527  CA  ARG B  44      -1.422  24.800 -10.091  1.00 38.20           C  
ATOM   1528  C   ARG B  44      -2.607  25.264 -10.911  1.00 39.36           C  
ATOM   1529  O   ARG B  44      -2.463  26.157 -11.761  1.00 40.60           O  
ATOM   1530  CB  ARG B  44      -0.835  23.523 -10.655  1.00 36.92           C  
ATOM   1531  CG  ARG B  44       0.488  23.209 -10.032  1.00 36.92           C  
ATOM   1532  CD  ARG B  44       1.061  21.922 -10.534  1.00 38.70           C  
ATOM   1533  NE  ARG B  44       2.433  21.740 -10.063  1.00 42.02           N  
ATOM   1534  CZ  ARG B  44       3.171  20.652 -10.308  1.00 42.42           C  
ATOM   1535  NH1 ARG B  44       2.665  19.634 -11.027  1.00 41.58           N  
ATOM   1536  NH2 ARG B  44       4.411  20.580  -9.833  1.00 40.74           N  
ATOM   1537  N   VAL B  45      -3.783  24.690 -10.653  1.00 39.30           N  
ATOM   1538  CA  VAL B  45      -4.968  25.149 -11.353  1.00 40.28           C  
ATOM   1539  C   VAL B  45      -5.159  26.641 -11.092  1.00 42.08           C  
ATOM   1540  O   VAL B  45      -5.383  27.413 -12.046  1.00 43.63           O  
ATOM   1541  CB  VAL B  45      -6.215  24.400 -10.958  1.00 39.90           C  
ATOM   1542  CG1 VAL B  45      -7.463  25.241 -11.289  1.00 40.08           C  
ATOM   1543  CG2 VAL B  45      -6.242  23.077 -11.667  1.00 38.07           C  
ATOM   1544  N   LEU B  46      -5.047  27.046  -9.821  1.00 41.73           N  
ATOM   1545  CA  LEU B  46      -5.139  28.463  -9.474  1.00 43.49           C  
ATOM   1546  C   LEU B  46      -4.063  29.289 -10.152  1.00 45.12           C  
ATOM   1547  O   LEU B  46      -4.345  30.365 -10.707  1.00 47.06           O  
ATOM   1548  CB  LEU B  46      -5.088  28.676  -7.969  1.00 43.15           C  
ATOM   1549  CG  LEU B  46      -6.241  28.074  -7.171  1.00 42.17           C  
ATOM   1550  CD1 LEU B  46      -5.906  28.241  -5.723  1.00 43.54           C  
ATOM   1551  CD2 LEU B  46      -7.586  28.727  -7.485  1.00 40.95           C  
ATOM   1552  N   ALA B  47      -2.831  28.794 -10.130  1.00 44.94           N  
ATOM   1553  CA  ALA B  47      -1.758  29.501 -10.814  1.00 46.11           C  
ATOM   1554  C   ALA B  47      -2.078  29.687 -12.317  1.00 47.76           C  
ATOM   1555  O   ALA B  47      -1.887  30.789 -12.871  1.00 49.36           O  
ATOM   1556  CB  ALA B  47      -0.444  28.813 -10.589  1.00 44.71           C  
ATOM   1557  N   CYS B  48      -2.610  28.650 -12.966  1.00 47.37           N  
ATOM   1558  CA  CYS B  48      -2.952  28.781 -14.395  1.00 49.64           C  
ATOM   1559  C   CYS B  48      -4.090  29.712 -14.679  1.00 51.54           C  
ATOM   1560  O   CYS B  48      -4.164  30.244 -15.772  1.00 53.58           O  
ATOM   1561  CB  CYS B  48      -3.348  27.458 -15.016  1.00 48.62           C  
ATOM   1562  SG  CYS B  48      -2.068  26.297 -14.989  1.00 48.58           S  
ATOM   1563  N   LEU B  49      -5.011  29.867 -13.734  1.00 51.97           N  
ATOM   1564  CA  LEU B  49      -6.218  30.634 -14.029  1.00 54.33           C  
ATOM   1565  C   LEU B  49      -6.144  32.084 -13.595  1.00 56.49           C  
ATOM   1566  O   LEU B  49      -7.026  32.854 -13.925  1.00 58.55           O  
ATOM   1567  CB  LEU B  49      -7.472  29.959 -13.474  1.00 52.98           C  
ATOM   1568  CG  LEU B  49      -7.873  28.617 -14.077  1.00 51.27           C  
ATOM   1569  CD1 LEU B  49      -9.061  28.128 -13.340  1.00 49.54           C  
ATOM   1570  CD2 LEU B  49      -8.207  28.727 -15.536  1.00 51.36           C  
ATOM   1571  N   VAL B  50      -5.101  32.452 -12.860  1.00 57.14           N  
ATOM   1572  CA  VAL B  50      -4.976  33.816 -12.376  1.00 59.80           C  
ATOM   1573  C   VAL B  50      -4.941  34.855 -13.511  1.00 63.98           C  
ATOM   1574  O   VAL B  50      -5.699  35.811 -13.444  1.00 65.56           O  
ATOM   1575  CB  VAL B  50      -3.814  33.964 -11.377  1.00 58.99           C  
ATOM   1576  CG1 VAL B  50      -2.493  34.145 -12.088  1.00 58.60           C  
ATOM   1577  CG2 VAL B  50      -4.080  35.107 -10.425  1.00 60.19           C  
ATOM   1578  N   ASP B  51      -4.117  34.666 -14.553  1.00 66.50           N  
ATOM   1579  CA  ASP B  51      -4.124  35.610 -15.692  1.00 71.70           C  
ATOM   1580  C   ASP B  51      -5.256  35.349 -16.641  1.00 74.12           C  
ATOM   1581  O   ASP B  51      -5.948  36.276 -17.013  1.00 78.48           O  
ATOM   1582  CB  ASP B  51      -2.879  35.575 -16.565  1.00 72.37           C  
ATOM   1583  CG  ASP B  51      -1.641  35.359 -15.798  1.00 72.03           C  
ATOM   1584  OD1 ASP B  51      -0.955  36.357 -15.444  1.00 73.87           O  
ATOM   1585  OD2 ASP B  51      -1.362  34.171 -15.560  1.00 70.62           O  
ATOM   1586  N   ASN B  52      -5.426  34.107 -17.062  1.00 73.65           N  
ATOM   1587  CA  ASN B  52      -6.392  33.760 -18.073  1.00 75.91           C  
ATOM   1588  C   ASN B  52      -7.834  33.862 -17.572  1.00 76.70           C  
ATOM   1589  O   ASN B  52      -8.106  33.720 -16.394  1.00 75.51           O  
ATOM   1590  CB  ASN B  52      -6.079  32.363 -18.577  1.00 74.72           C  
ATOM   1591  CG  ASN B  52      -4.570  32.145 -18.811  1.00 77.71           C  
ATOM   1592  OD1 ASN B  52      -3.768  32.070 -17.863  1.00 78.31           O  
ATOM   1593  ND2 ASN B  52      -4.181  32.043 -20.083  1.00 82.54           N  
ATOM   1594  N   ASP B  53      -8.767  34.141 -18.467  1.00 79.91           N  
ATOM   1595  CA  ASP B  53     -10.164  34.234 -18.060  1.00 81.25           C  
ATOM   1596  C   ASP B  53     -10.832  32.884 -17.991  1.00 78.93           C  
ATOM   1597  O   ASP B  53     -11.728  32.691 -17.188  1.00 79.21           O  
ATOM   1598  CB  ASP B  53     -10.957  35.104 -19.031  1.00 85.57           C  
ATOM   1599  CG  ASP B  53     -10.866  36.578 -18.696  1.00 90.96           C  
ATOM   1600  OD1 ASP B  53     -10.844  36.918 -17.479  1.00 92.65           O  
ATOM   1601  OD2 ASP B  53     -10.831  37.392 -19.656  1.00 96.09           O  
ATOM   1602  N   ALA B  54     -10.416  31.967 -18.853  1.00 77.14           N  
ATOM   1603  CA  ALA B  54     -11.082  30.693 -19.010  1.00 75.18           C  
ATOM   1604  C   ALA B  54     -10.131  29.741 -19.711  1.00 74.35           C  
ATOM   1605  O   ALA B  54      -9.405  30.147 -20.598  1.00 75.87           O  
ATOM   1606  CB  ALA B  54     -12.351  30.859 -19.807  1.00 77.04           C  
HETATM 1607  N   MSE B  55     -10.105  28.483 -19.289  1.00 71.86           N  
HETATM 1608  CA  MSE B  55      -9.258  27.487 -19.908  1.00 71.30           C  
HETATM 1609  C   MSE B  55      -9.981  26.184 -20.073  1.00 69.03           C  
HETATM 1610  O   MSE B  55     -10.877  25.858 -19.291  1.00 67.94           O  
HETATM 1611  CB  MSE B  55      -8.048  27.227 -19.062  1.00 68.60           C  
HETATM 1612  CG  MSE B  55      -6.847  27.919 -19.510  1.00 70.51           C  
HETATM 1613 SE   MSE B  55      -5.242  27.010 -18.834  0.90 73.78          SE  
HETATM 1614  CE  MSE B  55      -4.122  28.630 -18.851  1.00 71.25           C  
HETATM 1615  N   MSE B  56      -9.565  25.436 -21.086  1.00 68.35           N  
HETATM 1616  CA  MSE B  56     -10.081  24.116 -21.350  1.00 67.37           C  
HETATM 1617  C   MSE B  56      -9.413  23.217 -20.367  1.00 63.69           C  
HETATM 1618  O   MSE B  56      -8.249  23.420 -20.038  1.00 62.59           O  
HETATM 1619  CB  MSE B  56      -9.697  23.681 -22.747  1.00 69.20           C  
HETATM 1620  CG  MSE B  56     -10.209  24.568 -23.848  1.00 72.08           C  
HETATM 1621 SE   MSE B  56      -9.677  23.797 -25.562  0.60 76.78          SE  
HETATM 1622  CE  MSE B  56      -8.092  24.825 -26.068  1.00 76.18           C  
ATOM   1623  N   ILE B  57     -10.127  22.216 -19.882  1.00 62.39           N  
ATOM   1624  CA  ILE B  57      -9.533  21.360 -18.858  1.00 59.22           C  
ATOM   1625  C   ILE B  57      -8.304  20.680 -19.438  1.00 58.75           C  
ATOM   1626  O   ILE B  57      -7.326  20.430 -18.725  1.00 57.43           O  
ATOM   1627  CB  ILE B  57     -10.504  20.311 -18.301  1.00 58.89           C  
ATOM   1628  CG1 ILE B  57     -11.697  20.985 -17.661  1.00 57.96           C  
ATOM   1629  CG2 ILE B  57      -9.824  19.433 -17.233  1.00 57.37           C  
ATOM   1630  CD1 ILE B  57     -12.425  20.082 -16.681  1.00 58.11           C  
ATOM   1631  N   THR B  58      -8.336  20.417 -20.740  1.00 59.78           N  
ATOM   1632  CA  THR B  58      -7.233  19.720 -21.383  1.00 59.16           C  
ATOM   1633  C   THR B  58      -5.936  20.542 -21.336  1.00 57.61           C  
ATOM   1634  O   THR B  58      -4.850  19.977 -21.138  1.00 56.62           O  
ATOM   1635  CB  THR B  58      -7.594  19.262 -22.808  1.00 62.22           C  
ATOM   1636  OG1 THR B  58      -7.904  20.405 -23.599  1.00 64.79           O  
ATOM   1637  CG2 THR B  58      -8.843  18.349 -22.797  1.00 62.91           C  
ATOM   1638  N   ARG B  59      -6.039  21.861 -21.496  0.60 57.64           N  
ATOM   1640  CA  ARG B  59      -4.852  22.722 -21.380  0.60 56.87           C  
ATOM   1642  C   ARG B  59      -4.411  22.827 -19.916  0.60 54.13           C  
ATOM   1644  O   ARG B  59      -3.211  22.811 -19.608  0.60 53.16           O  
ATOM   1646  CB  ARG B  59      -5.081  24.111 -22.006  0.60 58.78           C  
ATOM   1648  CG  ARG B  59      -3.958  25.156 -21.786  0.60 58.39           C  
ATOM   1650  CD  ARG B  59      -2.775  25.060 -22.791  0.60 62.87           C  
ATOM   1652  NE  ARG B  59      -1.778  26.132 -22.589  0.60 63.67           N  
ATOM   1654  CZ  ARG B  59      -0.493  26.075 -22.955  0.60 64.20           C  
ATOM   1656  NH1 ARG B  59      -0.002  25.000 -23.565  0.60 63.86           N  
ATOM   1658  NH2 ARG B  59       0.312  27.099 -22.693  0.60 64.22           N  
ATOM   1660  N   LEU B  60      -5.378  22.928 -19.014  1.00 52.64           N  
ATOM   1661  CA  LEU B  60      -5.066  22.954 -17.603  1.00 50.25           C  
ATOM   1662  C   LEU B  60      -4.275  21.702 -17.250  1.00 48.61           C  
ATOM   1663  O   LEU B  60      -3.276  21.785 -16.533  1.00 47.33           O  
ATOM   1664  CB  LEU B  60      -6.354  22.993 -16.797  1.00 49.99           C  
ATOM   1665  CG  LEU B  60      -6.633  23.918 -15.634  1.00 48.23           C  
ATOM   1666  CD1 LEU B  60      -5.845  25.214 -15.629  1.00 47.88           C  
ATOM   1667  CD2 LEU B  60      -8.104  24.204 -15.798  1.00 51.34           C  
ATOM   1668  N   ALA B  61      -4.703  20.551 -17.769  1.00 48.78           N  
ATOM   1669  CA  ALA B  61      -3.978  19.314 -17.528  1.00 48.49           C  
ATOM   1670  C   ALA B  61      -2.518  19.385 -18.020  1.00 48.87           C  
ATOM   1671  O   ALA B  61      -1.582  19.127 -17.265  1.00 48.09           O  
ATOM   1672  CB  ALA B  61      -4.708  18.138 -18.104  1.00 49.17           C  
ATOM   1673  N   LYS B  62      -2.316  19.779 -19.265  1.00 50.50           N  
ATOM   1674  CA  LYS B  62      -0.973  19.903 -19.766  1.00 51.26           C  
ATOM   1675  C   LYS B  62      -0.120  20.893 -18.972  1.00 49.49           C  
ATOM   1676  O   LYS B  62       1.038  20.598 -18.680  1.00 49.05           O  
ATOM   1677  CB  LYS B  62      -0.980  20.217 -21.263  1.00 54.01           C  
ATOM   1678  CG  LYS B  62      -1.562  19.061 -22.075  1.00 59.12           C  
ATOM   1679  CD  LYS B  62      -1.655  19.397 -23.568  1.00 68.83           C  
ATOM   1680  CE  LYS B  62      -2.801  18.604 -24.262  1.00 73.62           C  
ATOM   1681  NZ  LYS B  62      -2.555  18.344 -25.736  1.00 77.28           N  
ATOM   1682  N   LEU B  63      -0.670  22.043 -18.598  1.00 49.08           N  
ATOM   1683  CA  LEU B  63       0.113  22.995 -17.802  1.00 48.12           C  
ATOM   1684  C   LEU B  63       0.409  22.464 -16.439  1.00 46.91           C  
ATOM   1685  O   LEU B  63       1.466  22.737 -15.894  1.00 47.13           O  
ATOM   1686  CB  LEU B  63      -0.553  24.357 -17.699  1.00 48.23           C  
ATOM   1687  CG  LEU B  63      -0.583  25.098 -19.042  1.00 50.19           C  
ATOM   1688  CD1 LEU B  63      -1.380  26.376 -18.926  1.00 48.88           C  
ATOM   1689  CD2 LEU B  63       0.824  25.386 -19.581  1.00 48.96           C  
ATOM   1690  N   SER B  64      -0.497  21.672 -15.881  1.00 47.17           N  
ATOM   1691  CA  SER B  64      -0.287  21.171 -14.521  1.00 46.29           C  
ATOM   1692  C   SER B  64       0.470  19.874 -14.442  1.00 46.29           C  
ATOM   1693  O   SER B  64       0.737  19.390 -13.347  1.00 45.93           O  
ATOM   1694  CB  SER B  64      -1.606  21.019 -13.810  1.00 45.47           C  
ATOM   1695  OG  SER B  64      -2.211  22.276 -13.721  1.00 45.27           O  
ATOM   1696  N   LEU B  65       0.806  19.335 -15.606  1.00 47.87           N  
ATOM   1697  CA  LEU B  65       1.487  18.060 -15.734  1.00 49.11           C  
ATOM   1698  C   LEU B  65       0.671  16.942 -15.138  1.00 50.23           C  
ATOM   1699  O   LEU B  65       1.156  16.228 -14.271  1.00 49.82           O  
ATOM   1700  CB  LEU B  65       2.878  18.111 -15.085  1.00 48.05           C  
ATOM   1701  CG  LEU B  65       3.683  19.404 -15.259  1.00 48.75           C  
ATOM   1702  CD1 LEU B  65       4.988  19.311 -14.517  1.00 47.88           C  
ATOM   1703  CD2 LEU B  65       3.908  19.752 -16.729  1.00 47.87           C  
HETATM 1704  N   MSE B  66      -0.579  16.799 -15.573  1.00 52.85           N  
HETATM 1705  CA  MSE B  66      -1.432  15.715 -15.080  1.00 55.36           C  
HETATM 1706  C   MSE B  66      -2.127  15.031 -16.193  1.00 57.31           C  
HETATM 1707  O   MSE B  66      -2.378  15.616 -17.235  1.00 57.96           O  
HETATM 1708  CB  MSE B  66      -2.587  16.203 -14.230  1.00 55.64           C  
HETATM 1709  CG  MSE B  66      -2.367  17.403 -13.423  1.00 60.06           C  
HETATM 1710 SE   MSE B  66      -2.806  16.824 -11.663  0.70 73.98          SE  
HETATM 1711  CE  MSE B  66      -0.931  16.429 -11.087  1.00 61.97           C  
ATOM   1712  N   GLU B  67      -2.536  13.807 -15.919  1.00 58.98           N  
ATOM   1713  CA  GLU B  67      -3.445  13.116 -16.800  1.00 62.11           C  
ATOM   1714  C   GLU B  67      -4.793  13.831 -16.798  1.00 61.33           C  
ATOM   1715  O   GLU B  67      -5.202  14.448 -15.809  1.00 59.28           O  
ATOM   1716  CB  GLU B  67      -3.622  11.686 -16.341  1.00 64.04           C  
ATOM   1717  CG  GLU B  67      -2.471  11.156 -15.532  1.00 68.16           C  
ATOM   1718  CD  GLU B  67      -2.163   9.736 -15.931  1.00 79.11           C  
ATOM   1719  OE1 GLU B  67      -3.141   8.927 -15.969  1.00 83.68           O  
ATOM   1720  OE2 GLU B  67      -0.969   9.434 -16.241  1.00 81.30           O  
ATOM   1721  N   GLN B  68      -5.474  13.724 -17.922  1.00 62.70           N  
ATOM   1722  CA  GLN B  68      -6.737  14.390 -18.136  1.00 63.15           C  
ATOM   1723  C   GLN B  68      -7.746  14.066 -17.035  1.00 61.07           C  
ATOM   1724  O   GLN B  68      -8.315  14.956 -16.444  1.00 59.78           O  
ATOM   1725  CB  GLN B  68      -7.278  13.933 -19.487  1.00 67.19           C  
ATOM   1726  CG  GLN B  68      -8.614  14.509 -19.877  1.00 72.58           C  
ATOM   1727  CD  GLN B  68      -8.447  15.920 -20.311  1.00 77.70           C  
ATOM   1728  OE1 GLN B  68      -7.559  16.225 -21.123  1.00 82.06           O  
ATOM   1729  NE2 GLN B  68      -9.264  16.809 -19.763  1.00 77.76           N  
ATOM   1730  N   SER B  69      -7.962  12.793 -16.755  1.00 60.67           N  
ATOM   1731  CA  SER B  69      -9.023  12.412 -15.851  1.00 60.22           C  
ATOM   1732  C   SER B  69      -8.708  12.804 -14.410  1.00 57.80           C  
ATOM   1733  O   SER B  69      -9.609  13.184 -13.677  1.00 57.38           O  
ATOM   1734  CB  SER B  69      -9.303  10.924 -15.945  1.00 61.60           C  
ATOM   1735  OG  SER B  69      -8.096  10.270 -15.682  1.00 62.31           O  
ATOM   1736  N   ARG B  70      -7.442  12.725 -14.013  1.00 56.56           N  
ATOM   1737  CA  ARG B  70      -7.056  13.103 -12.668  1.00 54.77           C  
ATOM   1738  C   ARG B  70      -7.327  14.591 -12.529  1.00 52.49           C  
ATOM   1739  O   ARG B  70      -7.923  15.028 -11.531  1.00 51.75           O  
ATOM   1740  CB  ARG B  70      -5.603  12.683 -12.358  1.00 56.08           C  
ATOM   1741  CG  ARG B  70      -4.922  13.331 -11.131  1.00 57.64           C  
ATOM   1742  CD  ARG B  70      -5.372  12.816  -9.673  1.00 66.24           C  
ATOM   1743  NE  ARG B  70      -4.519  13.423  -8.606  1.00 68.02           N  
ATOM   1744  CZ  ARG B  70      -4.771  13.490  -7.279  1.00 73.80           C  
ATOM   1745  NH1 ARG B  70      -5.878  12.956  -6.720  1.00 74.75           N  
ATOM   1746  NH2 ARG B  70      -3.883  14.109  -6.487  1.00 73.46           N  
HETATM 1747  N   MSE B  71      -6.960  15.349 -13.561  1.00 51.19           N  
HETATM 1748  CA  MSE B  71      -7.164  16.793 -13.587  1.00 49.66           C  
HETATM 1749  C   MSE B  71      -8.627  17.135 -13.463  1.00 48.97           C  
HETATM 1750  O   MSE B  71      -9.001  18.142 -12.874  1.00 48.57           O  
HETATM 1751  CB  MSE B  71      -6.609  17.407 -14.883  1.00 51.20           C  
HETATM 1752  CG  MSE B  71      -6.771  18.934 -15.016  1.00 53.62           C  
HETATM 1753 SE   MSE B  71      -5.801  19.908 -13.622  0.75 62.65          SE  
HETATM 1754  CE  MSE B  71      -4.155  20.283 -14.472  1.00 59.32           C  
ATOM   1755  N   THR B  72      -9.483  16.311 -14.022  1.00 49.00           N  
ATOM   1756  CA  THR B  72     -10.870  16.672 -13.948  1.00 48.57           C  
ATOM   1757  C   THR B  72     -11.501  16.325 -12.597  1.00 47.43           C  
ATOM   1758  O   THR B  72     -12.358  17.066 -12.120  1.00 46.58           O  
ATOM   1759  CB  THR B  72     -11.653  16.267 -15.234  1.00 50.63           C  
ATOM   1760  OG1 THR B  72     -12.795  15.485 -14.905  1.00 51.62           O  
ATOM   1761  CG2 THR B  72     -10.801  15.478 -16.106  1.00 51.74           C  
ATOM   1762  N   ARG B  73     -11.026  15.254 -11.954  1.00 46.68           N  
ATOM   1763  CA  ARG B  73     -11.446  14.952 -10.596  1.00 46.89           C  
ATOM   1764  C   ARG B  73     -11.102  16.129  -9.713  1.00 43.96           C  
ATOM   1765  O   ARG B  73     -11.949  16.605  -8.931  1.00 43.17           O  
ATOM   1766  CB  ARG B  73     -10.848  13.655 -10.078  1.00 46.49           C  
ATOM   1767  CG  ARG B  73     -11.733  12.443 -10.440  1.00 52.97           C  
ATOM   1768  CD  ARG B  73     -11.195  11.064  -9.973  1.00 54.80           C  
ATOM   1769  NE  ARG B  73      -9.762  10.841 -10.280  1.00 65.92           N  
ATOM   1770  CZ  ARG B  73      -9.278  10.096 -11.289  1.00 70.01           C  
ATOM   1771  NH1 ARG B  73     -10.100   9.487 -12.148  1.00 74.36           N  
ATOM   1772  NH2 ARG B  73      -7.953   9.967 -11.449  1.00 69.91           N  
ATOM   1773  N   ILE B  74      -9.894  16.655  -9.911  1.00 42.17           N  
ATOM   1774  CA  ILE B  74      -9.473  17.808  -9.146  1.00 40.36           C  
ATOM   1775  C   ILE B  74     -10.292  19.036  -9.429  1.00 40.78           C  
ATOM   1776  O   ILE B  74     -10.770  19.683  -8.484  1.00 41.62           O  
ATOM   1777  CB  ILE B  74      -7.989  18.083  -9.251  1.00 39.38           C  
ATOM   1778  CG1 ILE B  74      -7.310  17.199  -8.227  1.00 39.37           C  
ATOM   1779  CG2 ILE B  74      -7.681  19.520  -8.856  1.00 37.10           C  
ATOM   1780  CD1 ILE B  74      -6.030  16.734  -8.667  1.00 42.01           C  
ATOM   1781  N   VAL B  75     -10.487  19.355 -10.703  1.00 40.78           N  
ATOM   1782  CA  VAL B  75     -11.257  20.522 -11.018  1.00 40.90           C  
ATOM   1783  C   VAL B  75     -12.655  20.353 -10.456  1.00 41.86           C  
ATOM   1784  O   VAL B  75     -13.173  21.290  -9.874  1.00 41.88           O  
ATOM   1785  CB  VAL B  75     -11.289  20.813 -12.509  1.00 42.48           C  
ATOM   1786  CG1 VAL B  75     -12.380  21.814 -12.840  1.00 41.51           C  
ATOM   1787  CG2 VAL B  75      -9.897  21.326 -12.972  1.00 42.36           C  
ATOM   1788  N   ASP B  76     -13.262  19.172 -10.580  1.00 42.22           N  
ATOM   1789  CA  ASP B  76     -14.595  18.991  -9.998  1.00 42.65           C  
ATOM   1790  C   ASP B  76     -14.647  19.316  -8.515  1.00 41.54           C  
ATOM   1791  O   ASP B  76     -15.647  19.864  -8.019  1.00 41.80           O  
ATOM   1792  CB  ASP B  76     -15.087  17.571 -10.143  1.00 43.89           C  
ATOM   1793  CG  ASP B  76     -15.386  17.202 -11.568  1.00 46.07           C  
ATOM   1794  OD1 ASP B  76     -15.613  18.092 -12.423  1.00 45.27           O  
ATOM   1795  OD2 ASP B  76     -15.375  15.982 -11.824  1.00 49.47           O  
ATOM   1796  N   GLN B  77     -13.590  18.956  -7.802  1.00 40.18           N  
ATOM   1797  CA  GLN B  77     -13.573  19.171  -6.355  1.00 39.39           C  
ATOM   1798  C   GLN B  77     -13.523  20.658  -6.047  1.00 39.42           C  
ATOM   1799  O   GLN B  77     -14.215  21.123  -5.146  1.00 39.82           O  
ATOM   1800  CB  GLN B  77     -12.394  18.462  -5.706  1.00 37.88           C  
ATOM   1801  CG  GLN B  77     -12.520  16.992  -5.751  1.00 37.89           C  
ATOM   1802  CD  GLN B  77     -11.287  16.307  -5.211  1.00 39.96           C  
ATOM   1803  OE1 GLN B  77     -10.145  16.711  -5.500  1.00 39.78           O  
ATOM   1804  NE2 GLN B  77     -11.504  15.271  -4.393  1.00 39.87           N  
HETATM 1805  N   MSE B  78     -12.710  21.384  -6.809  1.00 38.89           N  
HETATM 1806  CA  MSE B  78     -12.618  22.807  -6.673  1.00 40.37           C  
HETATM 1807  C   MSE B  78     -13.936  23.486  -7.036  1.00 41.30           C  
HETATM 1808  O   MSE B  78     -14.347  24.468  -6.423  1.00 42.59           O  
HETATM 1809  CB  MSE B  78     -11.477  23.323  -7.532  1.00 39.48           C  
HETATM 1810  CG  MSE B  78     -10.151  22.831  -7.064  1.00 38.36           C  
HETATM 1811 SE   MSE B  78      -8.699  23.382  -8.263  0.70 44.33          SE  
HETATM 1812  CE  MSE B  78      -8.479  25.220  -7.716  1.00 41.47           C  
ATOM   1813  N   ASP B  79     -14.598  22.965  -8.055  1.00 42.60           N  
ATOM   1814  CA  ASP B  79     -15.924  23.405  -8.434  1.00 42.96           C  
ATOM   1815  C   ASP B  79     -16.842  23.240  -7.233  1.00 42.43           C  
ATOM   1816  O   ASP B  79     -17.458  24.208  -6.834  1.00 44.21           O  
ATOM   1817  CB  ASP B  79     -16.405  22.582  -9.625  1.00 44.38           C  
ATOM   1818  CG  ASP B  79     -17.623  23.182 -10.327  1.00 47.42           C  
ATOM   1819  OD1 ASP B  79     -18.493  23.758  -9.652  1.00 46.52           O  
ATOM   1820  OD2 ASP B  79     -17.723  23.040 -11.584  1.00 52.76           O  
ATOM   1821  N   ALA B  80     -16.911  22.057  -6.627  1.00 40.57           N  
ATOM   1822  CA  ALA B  80     -17.832  21.828  -5.502  1.00 40.33           C  
ATOM   1823  C   ALA B  80     -17.583  22.766  -4.318  1.00 40.50           C  
ATOM   1824  O   ALA B  80     -18.474  23.035  -3.480  1.00 40.03           O  
ATOM   1825  CB  ALA B  80     -17.724  20.419  -5.023  1.00 39.75           C  
ATOM   1826  N   ARG B  81     -16.350  23.238  -4.240  1.00 40.40           N  
ATOM   1827  CA  ARG B  81     -15.923  24.007  -3.108  1.00 41.10           C  
ATOM   1828  C   ARG B  81     -16.201  25.466  -3.407  1.00 42.53           C  
ATOM   1829  O   ARG B  81     -16.136  26.293  -2.500  1.00 44.01           O  
ATOM   1830  CB  ARG B  81     -14.433  23.798  -2.882  1.00 40.69           C  
ATOM   1831  CG  ARG B  81     -13.905  24.340  -1.595  1.00 39.93           C  
ATOM   1832  CD  ARG B  81     -12.925  23.355  -1.073  1.00 40.97           C  
ATOM   1833  NE  ARG B  81     -11.610  23.577  -1.624  1.00 41.35           N  
ATOM   1834  CZ  ARG B  81     -10.912  22.701  -2.325  1.00 41.51           C  
ATOM   1835  NH1 ARG B  81     -11.363  21.474  -2.608  1.00 38.68           N  
ATOM   1836  NH2 ARG B  81      -9.727  23.090  -2.761  1.00 45.23           N  
ATOM   1837  N   GLY B  82     -16.523  25.786  -4.655  1.00 42.16           N  
ATOM   1838  CA  GLY B  82     -16.754  27.164  -5.020  1.00 43.39           C  
ATOM   1839  C   GLY B  82     -15.526  27.949  -5.488  1.00 44.23           C  
ATOM   1840  O   GLY B  82     -15.583  29.174  -5.603  1.00 45.45           O  
ATOM   1841  N   LEU B  83     -14.422  27.281  -5.806  1.00 43.75           N  
ATOM   1842  CA  LEU B  83     -13.248  28.015  -6.300  1.00 44.23           C  
ATOM   1843  C   LEU B  83     -13.267  28.249  -7.794  1.00 45.28           C  
ATOM   1844  O   LEU B  83     -12.654  29.197  -8.298  1.00 46.24           O  
ATOM   1845  CB  LEU B  83     -11.958  27.300  -5.903  1.00 43.03           C  
ATOM   1846  CG  LEU B  83     -11.832  27.147  -4.388  1.00 44.13           C  
ATOM   1847  CD1 LEU B  83     -10.511  26.470  -4.058  1.00 44.23           C  
ATOM   1848  CD2 LEU B  83     -11.995  28.507  -3.641  1.00 42.56           C  
ATOM   1849  N   VAL B  84     -13.990  27.393  -8.507  1.00 46.07           N  
ATOM   1850  CA  VAL B  84     -13.853  27.303  -9.961  1.00 47.92           C  
ATOM   1851  C   VAL B  84     -15.198  27.013 -10.596  1.00 49.94           C  
ATOM   1852  O   VAL B  84     -15.984  26.279 -10.038  1.00 50.44           O  
ATOM   1853  CB  VAL B  84     -12.830  26.194 -10.294  1.00 46.40           C  
ATOM   1854  CG1 VAL B  84     -13.069  25.622 -11.630  1.00 47.04           C  
ATOM   1855  CG2 VAL B  84     -11.441  26.761 -10.231  1.00 45.61           C  
ATOM   1856  N   THR B  85     -15.484  27.577 -11.760  1.00 53.27           N  
ATOM   1857  CA  THR B  85     -16.783  27.299 -12.401  1.00 55.78           C  
ATOM   1858  C   THR B  85     -16.674  26.995 -13.908  1.00 57.48           C  
ATOM   1859  O   THR B  85     -15.683  27.359 -14.530  1.00 57.86           O  
ATOM   1860  CB  THR B  85     -17.786  28.422 -12.038  1.00 56.93           C  
ATOM   1861  OG1 THR B  85     -19.117  27.982 -12.286  1.00 57.80           O  
ATOM   1862  CG2 THR B  85     -17.491  29.707 -12.786  1.00 59.74           C  
ATOM   1863  N   ARG B  86     -17.663  26.298 -14.471  0.50 59.47           N  
ATOM   1865  CA  ARG B  86     -17.674  26.019 -15.918  0.50 62.21           C  
ATOM   1867  C   ARG B  86     -18.243  27.216 -16.657  0.50 65.45           C  
ATOM   1869  O   ARG B  86     -19.240  27.803 -16.241  0.50 66.24           O  
ATOM   1871  CB  ARG B  86     -18.491  24.767 -16.293  0.50 62.63           C  
ATOM   1873  CG  ARG B  86     -18.421  23.587 -15.331  0.50 60.56           C  
ATOM   1875  CD  ARG B  86     -17.324  22.588 -15.649  0.50 59.16           C  
ATOM   1877  NE  ARG B  86     -16.746  22.036 -14.422  0.50 56.53           N  
ATOM   1879  CZ  ARG B  86     -16.287  20.798 -14.294  0.50 55.64           C  
ATOM   1881  NH1 ARG B  86     -16.336  19.937 -15.300  0.50 55.80           N  
ATOM   1883  NH2 ARG B  86     -15.785  20.421 -13.140  0.50 55.30           N  
ATOM   1885  N   VAL B  87     -17.595  27.577 -17.752  1.00 67.84           N  
ATOM   1886  CA  VAL B  87     -18.055  28.644 -18.614  1.00 72.99           C  
ATOM   1887  C   VAL B  87     -19.152  28.070 -19.514  1.00 77.69           C  
ATOM   1888  O   VAL B  87     -18.961  27.026 -20.153  1.00 77.76           O  
ATOM   1889  CB  VAL B  87     -16.878  29.169 -19.437  1.00 73.86           C  
ATOM   1890  CG1 VAL B  87     -17.274  30.384 -20.277  1.00 77.29           C  
ATOM   1891  CG2 VAL B  87     -15.734  29.525 -18.505  1.00 71.14           C  
ATOM   1892  N   ALA B  88     -20.308  28.740 -19.529  1.00 82.99           N  
ATOM   1893  CA  ALA B  88     -21.484  28.315 -20.330  1.00 88.64           C  
ATOM   1894  C   ALA B  88     -21.216  28.362 -21.849  1.00 93.57           C  
ATOM   1895  O   ALA B  88     -20.422  29.195 -22.308  1.00 94.69           O  
ATOM   1896  CB  ALA B  88     -22.720  29.149 -19.969  1.00 89.62           C  
ATOM   1897  N   ASP B  89     -21.862  27.461 -22.608  1.00 97.98           N  
ATOM   1898  CA  ASP B  89     -21.692  27.359 -24.091  1.00103.88           C  
ATOM   1899  C   ASP B  89     -22.915  26.777 -24.863  1.00107.70           C  
ATOM   1900  O   ASP B  89     -23.966  26.541 -24.242  1.00108.31           O  
ATOM   1901  CB  ASP B  89     -20.397  26.600 -24.443  1.00102.79           C  
ATOM   1902  CG  ASP B  89     -19.251  27.545 -24.795  1.00104.86           C  
ATOM   1903  OD1 ASP B  89     -19.341  28.221 -25.858  1.00110.13           O  
ATOM   1904  OD2 ASP B  89     -18.273  27.623 -24.006  1.00103.15           O  
ATOM   1905  N   ALA B  90     -22.782  26.564 -26.190  1.00111.28           N  
ATOM   1906  CA  ALA B  90     -23.870  25.988 -27.042  1.00114.66           C  
ATOM   1907  C   ALA B  90     -23.596  24.535 -27.473  1.00115.03           C  
ATOM   1908  O   ALA B  90     -22.493  24.190 -27.903  1.00114.53           O  
ATOM   1909  CB  ALA B  90     -24.175  26.891 -28.285  1.00118.92           C  
ATOM   1910  N   ARG B  95     -14.925  20.595 -25.662  1.00 43.60           N  
ATOM   1911  CA  ARG B  95     -14.159  21.816 -25.487  1.00 42.41           C  
ATOM   1912  C   ARG B  95     -14.698  22.727 -24.400  1.00 40.65           C  
ATOM   1913  O   ARG B  95     -14.775  23.917 -24.607  1.00 41.51           O  
ATOM   1914  CB  ARG B  95     -14.036  22.600 -26.812  1.00 45.53           C  
ATOM   1915  CG  ARG B  95     -15.314  22.701 -27.677  1.00 49.12           C  
ATOM   1916  CD  ARG B  95     -14.971  22.921 -29.172  1.00 52.71           C  
ATOM   1917  NE  ARG B  95     -13.575  22.611 -29.410  1.00 51.72           N  
ATOM   1918  CZ  ARG B  95     -12.587  23.458 -29.192  1.00 50.28           C  
ATOM   1919  NH1 ARG B  95     -12.845  24.673 -28.765  1.00 49.89           N  
ATOM   1920  NH2 ARG B  95     -11.342  23.090 -29.407  1.00 49.45           N  
ATOM   1921  N   VAL B  96     -15.058  22.169 -23.251  1.00 71.80           N  
ATOM   1922  CA  VAL B  96     -15.480  22.957 -22.088  1.00 70.54           C  
ATOM   1923  C   VAL B  96     -14.328  23.750 -21.475  1.00 67.86           C  
ATOM   1924  O   VAL B  96     -13.172  23.302 -21.466  1.00 66.48           O  
ATOM   1925  CB  VAL B  96     -16.178  22.115 -20.953  1.00 69.33           C  
ATOM   1926  CG1 VAL B  96     -15.161  21.397 -20.070  1.00 67.55           C  
ATOM   1927  CG2 VAL B  96     -17.039  23.008 -20.056  1.00 68.51           C  
ATOM   1928  N   ARG B  97     -14.684  24.883 -20.900  1.00 66.59           N  
ATOM   1929  CA  ARG B  97     -13.745  25.825 -20.371  1.00 64.80           C  
ATOM   1930  C   ARG B  97     -14.105  26.115 -18.932  1.00 61.89           C  
ATOM   1931  O   ARG B  97     -15.221  25.925 -18.526  1.00 62.03           O  
ATOM   1932  CB  ARG B  97     -13.824  27.105 -21.169  1.00 67.77           C  
ATOM   1933  CG  ARG B  97     -12.764  27.283 -22.193  1.00 72.28           C  
ATOM   1934  CD  ARG B  97     -13.374  27.436 -23.527  1.00 82.48           C  
ATOM   1935  NE  ARG B  97     -12.399  27.829 -24.526  1.00 91.98           N  
ATOM   1936  CZ  ARG B  97     -12.199  27.180 -25.664  1.00 96.59           C  
ATOM   1937  NH1 ARG B  97     -11.289  27.613 -26.513  1.00 99.64           N  
ATOM   1938  NH2 ARG B  97     -12.905  26.098 -25.946  1.00 96.45           N  
ATOM   1939  N   VAL B  98     -13.148  26.589 -18.161  1.00 59.01           N  
ATOM   1940  CA  VAL B  98     -13.311  26.670 -16.732  1.00 56.48           C  
ATOM   1941  C   VAL B  98     -12.688  27.959 -16.252  1.00 55.39           C  
ATOM   1942  O   VAL B  98     -11.692  28.390 -16.803  1.00 55.27           O  
ATOM   1943  CB  VAL B  98     -12.653  25.421 -16.118  1.00 54.77           C  
ATOM   1944  CG1 VAL B  98     -11.802  25.743 -14.964  1.00 52.89           C  
ATOM   1945  CG2 VAL B  98     -13.715  24.429 -15.754  1.00 55.79           C  
ATOM   1946  N   ARG B  99     -13.281  28.602 -15.259  1.00 54.72           N  
ATOM   1947  CA  ARG B  99     -12.721  29.865 -14.775  1.00 55.33           C  
ATOM   1948  C   ARG B  99     -12.796  29.992 -13.251  1.00 53.73           C  
ATOM   1949  O   ARG B  99     -13.555  29.260 -12.599  1.00 53.07           O  
ATOM   1950  CB  ARG B  99     -13.397  31.056 -15.445  1.00 57.69           C  
ATOM   1951  CG  ARG B  99     -14.849  31.193 -15.122  1.00 60.86           C  
ATOM   1952  CD  ARG B  99     -15.368  32.604 -15.425  1.00 68.95           C  
ATOM   1953  NE  ARG B  99     -16.826  32.664 -15.277  1.00 75.24           N  
ATOM   1954  CZ  ARG B  99     -17.474  33.032 -14.160  1.00 78.10           C  
ATOM   1955  NH1 ARG B  99     -18.806  33.035 -14.126  1.00 80.81           N  
ATOM   1956  NH2 ARG B  99     -16.812  33.412 -13.070  1.00 78.14           N  
ATOM   1957  N   LEU B 100     -12.003  30.903 -12.687  1.00 53.35           N  
ATOM   1958  CA  LEU B 100     -12.087  31.193 -11.255  1.00 52.68           C  
ATOM   1959  C   LEU B 100     -13.399  31.868 -10.908  1.00 53.93           C  
ATOM   1960  O   LEU B 100     -13.945  32.628 -11.727  1.00 56.10           O  
ATOM   1961  CB  LEU B 100     -10.947  32.097 -10.824  1.00 52.97           C  
ATOM   1962  CG  LEU B 100      -9.597  31.410 -10.995  1.00 52.24           C  
ATOM   1963  CD1 LEU B 100      -8.444  32.346 -10.628  1.00 52.33           C  
ATOM   1964  CD2 LEU B 100      -9.555  30.112 -10.172  1.00 50.31           C  
ATOM   1965  N   THR B 101     -13.915  31.566  -9.720  1.00 52.14           N  
ATOM   1966  CA  THR B 101     -14.997  32.341  -9.153  1.00 53.04           C  
ATOM   1967  C   THR B 101     -14.328  33.534  -8.505  1.00 54.92           C  
ATOM   1968  O   THR B 101     -13.101  33.628  -8.537  1.00 55.15           O  
ATOM   1969  CB  THR B 101     -15.726  31.553  -8.063  1.00 51.58           C  
ATOM   1970  OG1 THR B 101     -14.802  31.211  -7.029  1.00 49.80           O  
ATOM   1971  CG2 THR B 101     -16.369  30.291  -8.612  1.00 47.90           C  
ATOM   1972  N   ASP B 102     -15.092  34.443  -7.907  1.00 57.09           N  
ATOM   1973  CA  ASP B 102     -14.470  35.553  -7.177  1.00 59.42           C  
ATOM   1974  C   ASP B 102     -13.588  35.083  -6.041  1.00 58.07           C  
ATOM   1975  O   ASP B 102     -12.462  35.570  -5.867  1.00 58.71           O  
ATOM   1976  CB  ASP B 102     -15.508  36.526  -6.628  1.00 61.79           C  
ATOM   1977  CG  ASP B 102     -16.034  37.443  -7.691  1.00 67.66           C  
ATOM   1978  OD1 ASP B 102     -15.601  37.295  -8.876  1.00 71.60           O  
ATOM   1979  OD2 ASP B 102     -16.886  38.303  -7.355  1.00 72.60           O  
ATOM   1980  N   ASP B 103     -14.106  34.146  -5.253  1.00 56.66           N  
ATOM   1981  CA  ASP B 103     -13.328  33.569  -4.168  1.00 55.41           C  
ATOM   1982  C   ASP B 103     -12.080  32.919  -4.742  1.00 53.60           C  
ATOM   1983  O   ASP B 103     -10.971  33.142  -4.239  1.00 53.46           O  
ATOM   1984  CB  ASP B 103     -14.169  32.569  -3.356  1.00 54.70           C  
ATOM   1985  CG  ASP B 103     -15.384  33.230  -2.688  1.00 56.13           C  
ATOM   1986  OD1 ASP B 103     -15.249  34.326  -2.085  1.00 56.99           O  
ATOM   1987  OD2 ASP B 103     -16.478  32.644  -2.769  1.00 57.09           O  
ATOM   1988  N   GLY B 104     -12.262  32.177  -5.831  1.00 51.99           N  
ATOM   1989  CA  GLY B 104     -11.159  31.521  -6.501  1.00 50.92           C  
ATOM   1990  C   GLY B 104     -10.101  32.531  -6.858  1.00 52.39           C  
ATOM   1991  O   GLY B 104      -8.908  32.311  -6.618  1.00 51.40           O  
ATOM   1992  N   ARG B 105     -10.547  33.661  -7.398  1.00 54.47           N  
ATOM   1993  CA  ARG B 105      -9.638  34.673  -7.895  1.00 56.64           C  
ATOM   1994  C   ARG B 105      -8.905  35.357  -6.745  1.00 56.26           C  
ATOM   1995  O   ARG B 105      -7.720  35.694  -6.860  1.00 57.20           O  
ATOM   1996  CB  ARG B 105     -10.401  35.659  -8.778  1.00 58.92           C  
ATOM   1997  CG  ARG B 105      -9.558  36.639  -9.579  1.00 62.62           C  
ATOM   1998  CD  ARG B 105     -10.376  37.281 -10.729  1.00 66.13           C  
ATOM   1999  NE  ARG B 105     -10.451  36.474 -11.968  1.00 73.57           N  
ATOM   2000  CZ  ARG B 105      -9.391  36.046 -12.682  1.00 76.52           C  
ATOM   2001  NH1 ARG B 105      -8.139  36.302 -12.278  1.00 76.86           N  
ATOM   2002  NH2 ARG B 105      -9.568  35.328 -13.801  1.00 76.97           N  
ATOM   2003  N   ALA B 106      -9.579  35.526  -5.621  1.00 55.59           N  
ATOM   2004  CA  ALA B 106      -8.928  36.160  -4.468  1.00 56.54           C  
ATOM   2005  C   ALA B 106      -7.791  35.272  -3.962  1.00 54.99           C  
ATOM   2006  O   ALA B 106      -6.691  35.754  -3.655  1.00 56.02           O  
ATOM   2007  CB  ALA B 106      -9.926  36.435  -3.352  1.00 55.90           C  
ATOM   2008  N   LEU B 107      -8.078  33.971  -3.891  1.00 52.68           N  
ATOM   2009  CA  LEU B 107      -7.169  33.022  -3.315  1.00 50.93           C  
ATOM   2010  C   LEU B 107      -5.962  32.884  -4.233  1.00 50.88           C  
ATOM   2011  O   LEU B 107      -4.814  32.988  -3.779  1.00 51.49           O  
ATOM   2012  CB  LEU B 107      -7.869  31.698  -3.133  1.00 48.70           C  
ATOM   2013  CG  LEU B 107      -7.017  30.542  -2.605  1.00 48.33           C  
ATOM   2014  CD1 LEU B 107      -6.236  30.932  -1.338  1.00 48.25           C  
ATOM   2015  CD2 LEU B 107      -7.869  29.280  -2.372  1.00 46.49           C  
ATOM   2016  N   ALA B 108      -6.226  32.688  -5.522  1.00 50.28           N  
ATOM   2017  CA  ALA B 108      -5.173  32.624  -6.518  1.00 50.01           C  
ATOM   2018  C   ALA B 108      -4.297  33.842  -6.428  1.00 52.08           C  
ATOM   2019  O   ALA B 108      -3.070  33.742  -6.513  1.00 51.82           O  
ATOM   2020  CB  ALA B 108      -5.754  32.511  -7.904  1.00 50.05           C  
ATOM   2021  N   GLU B 109      -4.912  35.002  -6.227  1.00 54.38           N  
ATOM   2022  CA  GLU B 109      -4.099  36.193  -6.209  1.00 57.21           C  
ATOM   2023  C   GLU B 109      -3.150  36.209  -5.042  1.00 57.03           C  
ATOM   2024  O   GLU B 109      -1.974  36.513  -5.211  1.00 57.60           O  
ATOM   2025  CB  GLU B 109      -4.932  37.440  -6.278  1.00 59.92           C  
ATOM   2026  CG  GLU B 109      -4.937  38.019  -7.670  1.00 65.05           C  
ATOM   2027  CD  GLU B 109      -6.251  38.723  -8.013  1.00 73.65           C  
ATOM   2028  OE1 GLU B 109      -6.878  39.381  -7.128  1.00 75.21           O  
ATOM   2029  OE2 GLU B 109      -6.656  38.615  -9.192  1.00 77.52           O  
ATOM   2030  N   SER B 110      -3.621  35.830  -3.866  1.00 56.34           N  
ATOM   2031  CA  SER B 110      -2.724  35.898  -2.746  1.00 57.55           C  
ATOM   2032  C   SER B 110      -1.664  34.798  -2.805  1.00 56.10           C  
ATOM   2033  O   SER B 110      -0.510  35.028  -2.434  1.00 57.75           O  
ATOM   2034  CB  SER B 110      -3.473  35.963  -1.424  1.00 58.10           C  
ATOM   2035  OG  SER B 110      -3.726  34.682  -0.945  1.00 57.99           O  
ATOM   2036  N   LEU B 111      -2.017  33.634  -3.338  1.00 53.73           N  
ATOM   2037  CA  LEU B 111      -1.014  32.601  -3.569  1.00 52.00           C  
ATOM   2038  C   LEU B 111       0.028  32.987  -4.606  1.00 52.52           C  
ATOM   2039  O   LEU B 111       1.219  32.765  -4.405  1.00 52.91           O  
ATOM   2040  CB  LEU B 111      -1.670  31.308  -3.990  1.00 50.04           C  
ATOM   2041  CG  LEU B 111      -2.447  30.689  -2.852  1.00 50.08           C  
ATOM   2042  CD1 LEU B 111      -3.128  29.441  -3.350  1.00 48.64           C  
ATOM   2043  CD2 LEU B 111      -1.516  30.395  -1.696  1.00 50.32           C  
ATOM   2044  N   VAL B 112      -0.401  33.542  -5.731  1.00 52.70           N  
ATOM   2045  CA  VAL B 112       0.572  33.928  -6.744  1.00 53.47           C  
ATOM   2046  C   VAL B 112       1.537  34.988  -6.178  1.00 55.92           C  
ATOM   2047  O   VAL B 112       2.755  34.934  -6.406  1.00 56.16           O  
ATOM   2048  CB  VAL B 112      -0.105  34.349  -8.064  1.00 54.17           C  
ATOM   2049  CG1 VAL B 112       0.883  34.996  -9.011  1.00 54.91           C  
ATOM   2050  CG2 VAL B 112      -0.739  33.120  -8.730  1.00 51.98           C  
ATOM   2051  N   ALA B 113       1.001  35.914  -5.390  1.00 57.78           N  
ATOM   2052  CA  ALA B 113       1.856  36.849  -4.667  1.00 60.26           C  
ATOM   2053  C   ALA B 113       2.964  36.120  -3.879  1.00 59.53           C  
ATOM   2054  O   ALA B 113       4.151  36.372  -4.115  1.00 60.29           O  
ATOM   2055  CB  ALA B 113       1.027  37.774  -3.767  1.00 61.84           C  
ATOM   2056  N   SER B 114       2.586  35.199  -2.985  1.00 58.31           N  
ATOM   2057  CA  SER B 114       3.577  34.391  -2.258  1.00 58.25           C  
ATOM   2058  C   SER B 114       4.540  33.675  -3.172  1.00 56.96           C  
ATOM   2059  O   SER B 114       5.754  33.717  -2.951  1.00 57.49           O  
ATOM   2060  CB  SER B 114       2.912  33.337  -1.409  1.00 56.80           C  
ATOM   2061  OG  SER B 114       2.427  33.924  -0.234  1.00 60.95           O  
ATOM   2062  N   ALA B 115       4.002  33.011  -4.194  1.00 55.23           N  
ATOM   2063  CA  ALA B 115       4.864  32.287  -5.122  1.00 54.99           C  
ATOM   2064  C   ALA B 115       5.934  33.228  -5.661  1.00 57.04           C  
ATOM   2065  O   ALA B 115       7.115  32.877  -5.639  1.00 56.81           O  
ATOM   2066  CB  ALA B 115       4.068  31.619  -6.252  1.00 52.91           C  
ATOM   2067  N   ARG B 116       5.524  34.428  -6.086  1.00 59.19           N  
ATOM   2068  CA  ARG B 116       6.461  35.376  -6.685  1.00 62.13           C  
ATOM   2069  C   ARG B 116       7.555  35.781  -5.707  1.00 64.20           C  
ATOM   2070  O   ARG B 116       8.724  35.840  -6.072  1.00 64.91           O  
ATOM   2071  CB  ARG B 116       5.750  36.626  -7.182  1.00 63.95           C  
ATOM   2072  CG  ARG B 116       4.983  36.487  -8.474  1.00 63.66           C  
ATOM   2073  CD  ARG B 116       4.431  37.861  -8.868  1.00 67.16           C  
ATOM   2074  NE  ARG B 116       3.315  37.821  -9.820  1.00 67.03           N  
ATOM   2075  CZ  ARG B 116       3.451  37.717 -11.148  1.00 67.71           C  
ATOM   2076  NH1 ARG B 116       4.673  37.618 -11.704  1.00 64.73           N  
ATOM   2077  NH2 ARG B 116       2.356  37.704 -11.926  1.00 66.05           N  
ATOM   2078  N   ALA B 117       7.168  36.067  -4.466  1.00 66.17           N  
ATOM   2079  CA  ALA B 117       8.122  36.514  -3.443  1.00 68.87           C  
ATOM   2080  C   ALA B 117       9.138  35.417  -3.121  1.00 67.99           C  
ATOM   2081  O   ALA B 117      10.330  35.699  -3.001  1.00 69.68           O  
ATOM   2082  CB  ALA B 117       7.396  36.986  -2.195  1.00 69.45           C  
ATOM   2083  N   HIS B 118       8.648  34.184  -2.996  0.50 65.87           N  
ATOM   2085  CA  HIS B 118       9.479  33.007  -2.774  0.50 64.94           C  
ATOM   2087  C   HIS B 118      10.460  32.792  -3.952  0.50 64.68           C  
ATOM   2089  O   HIS B 118      11.623  32.415  -3.743  0.50 65.21           O  
ATOM   2091  CB  HIS B 118       8.587  31.768  -2.575  0.50 62.67           C  
ATOM   2093  CG  HIS B 118       7.958  31.649  -1.209  0.50 63.59           C  
ATOM   2095  ND1 HIS B 118       7.175  32.639  -0.647  0.50 65.08           N  
ATOM   2097  CD2 HIS B 118       7.955  30.622  -0.319  0.50 62.28           C  
ATOM   2099  CE1 HIS B 118       6.737  32.238   0.533  0.50 65.04           C  
ATOM   2101  NE2 HIS B 118       7.193  31.017   0.755  0.50 63.66           N  
ATOM   2103  N   GLU B 119       9.987  33.038  -5.179  1.00 64.18           N  
ATOM   2104  CA  GLU B 119      10.788  32.941  -6.385  1.00 64.08           C  
ATOM   2105  C   GLU B 119      11.870  34.011  -6.382  1.00 67.56           C  
ATOM   2106  O   GLU B 119      13.009  33.748  -6.771  1.00 68.26           O  
ATOM   2107  CB  GLU B 119       9.921  33.084  -7.634  1.00 63.13           C  
ATOM   2108  CG  GLU B 119      10.729  33.132  -8.938  1.00 63.56           C  
ATOM   2109  CD  GLU B 119       9.892  33.343 -10.171  1.00 63.52           C  
ATOM   2110  OE1 GLU B 119       9.008  34.219 -10.183  1.00 66.42           O  
ATOM   2111  OE2 GLU B 119      10.121  32.635 -11.157  1.00 64.55           O  
ATOM   2112  N   THR B 120      11.523  35.211  -5.937  1.00 70.49           N  
ATOM   2113  CA  THR B 120      12.485  36.302  -5.925  1.00 73.98           C  
ATOM   2114  C   THR B 120      13.542  36.028  -4.881  1.00 75.32           C  
ATOM   2115  O   THR B 120      14.724  36.297  -5.114  1.00 77.23           O  
ATOM   2116  CB  THR B 120      11.839  37.688  -5.694  1.00 76.54           C  
ATOM   2117  OG1 THR B 120      10.654  37.795  -6.484  1.00 75.15           O  
ATOM   2118  CG2 THR B 120      12.805  38.798  -6.104  1.00 79.26           C  
ATOM   2119  N   ARG B 121      13.128  35.482  -3.745  1.00 75.02           N  
ATOM   2120  CA  ARG B 121      14.072  35.100  -2.716  1.00 76.94           C  
ATOM   2121  C   ARG B 121      15.134  34.213  -3.371  1.00 75.11           C  
ATOM   2122  O   ARG B 121      16.343  34.480  -3.293  1.00 77.10           O  
ATOM   2123  CB  ARG B 121      13.362  34.332  -1.603  1.00 76.90           C  
ATOM   2124  CG  ARG B 121      13.933  34.525  -0.189  1.00 83.22           C  
ATOM   2125  CD  ARG B 121      12.955  35.274   0.792  1.00 91.02           C  
ATOM   2126  NE  ARG B 121      11.540  34.835   0.739  1.00 94.13           N  
ATOM   2127  CZ  ARG B 121      11.070  33.593   0.977  1.00 94.72           C  
ATOM   2128  NH1 ARG B 121       9.757  33.353   0.893  1.00 92.79           N  
ATOM   2129  NH2 ARG B 121      11.895  32.578   1.276  1.00 94.52           N  
ATOM   2130  N   LEU B 122      14.676  33.177  -4.053  1.00 71.36           N  
ATOM   2131  CA  LEU B 122      15.589  32.214  -4.640  1.00 69.46           C  
ATOM   2132  C   LEU B 122      16.473  32.800  -5.769  1.00 70.26           C  
ATOM   2133  O   LEU B 122      17.685  32.564  -5.819  1.00 70.46           O  
ATOM   2134  CB  LEU B 122      14.801  30.991  -5.095  1.00 66.14           C  
ATOM   2135  CG  LEU B 122      15.519  29.874  -5.830  1.00 64.04           C  
ATOM   2136  CD1 LEU B 122      16.713  29.362  -5.048  1.00 64.15           C  
ATOM   2137  CD2 LEU B 122      14.538  28.767  -6.059  1.00 62.33           C  
ATOM   2138  N   LEU B 123      15.868  33.572  -6.667  1.00 70.46           N  
ATOM   2139  CA  LEU B 123      16.625  34.161  -7.763  1.00 71.48           C  
ATOM   2140  C   LEU B 123      17.730  35.050  -7.249  1.00 74.70           C  
ATOM   2141  O   LEU B 123      18.809  35.097  -7.840  1.00 75.59           O  
ATOM   2142  CB  LEU B 123      15.729  34.946  -8.710  1.00 71.44           C  
ATOM   2143  CG  LEU B 123      14.845  34.100  -9.611  1.00 68.07           C  
ATOM   2144  CD1 LEU B 123      13.869  34.983 -10.349  1.00 67.95           C  
ATOM   2145  CD2 LEU B 123      15.678  33.275 -10.583  1.00 65.37           C  
ATOM   2146  N   SER B 124      17.448  35.767  -6.160  0.60 76.76           N  
ATOM   2148  CA  SER B 124      18.452  36.585  -5.492  0.60 79.97           C  
ATOM   2150  C   SER B 124      19.631  35.695  -5.115  0.60 79.73           C  
ATOM   2152  O   SER B 124      20.762  35.933  -5.532  0.60 81.19           O  
ATOM   2154  CB  SER B 124      17.873  37.260  -4.246  0.60 81.70           C  
ATOM   2156  OG  SER B 124      18.879  37.962  -3.531  0.60 84.30           O  
ATOM   2158  N   ALA B 125      19.345  34.644  -4.356  1.00 78.11           N  
ATOM   2159  CA  ALA B 125      20.367  33.731  -3.881  1.00 78.20           C  
ATOM   2160  C   ALA B 125      21.212  33.193  -5.032  1.00 77.50           C  
ATOM   2161  O   ALA B 125      22.394  32.905  -4.853  1.00 78.95           O  
ATOM   2162  CB  ALA B 125      19.734  32.591  -3.089  1.00 76.46           C  
ATOM   2163  N   LEU B 126      20.614  33.094  -6.216  1.00 75.94           N  
ATOM   2164  CA  LEU B 126      21.301  32.569  -7.389  1.00 75.15           C  
ATOM   2165  C   LEU B 126      22.106  33.600  -8.172  1.00 77.82           C  
ATOM   2166  O   LEU B 126      23.033  33.246  -8.899  1.00 77.54           O  
ATOM   2167  CB  LEU B 126      20.281  31.949  -8.334  1.00 72.49           C  
ATOM   2168  CG  LEU B 126      19.601  30.661  -7.918  1.00 69.54           C  
ATOM   2169  CD1 LEU B 126      18.857  30.191  -9.116  1.00 66.70           C  
ATOM   2170  CD2 LEU B 126      20.616  29.617  -7.462  1.00 68.13           C  
ATOM   2171  N   ALA B 127      21.716  34.865  -8.033  1.00 80.81           N  
ATOM   2172  CA  ALA B 127      22.250  35.994  -8.810  1.00 84.13           C  
ATOM   2173  C   ALA B 127      23.783  36.054  -8.958  1.00 86.46           C  
ATOM   2174  O   ALA B 127      24.299  36.359 -10.047  1.00 87.59           O  
ATOM   2175  CB  ALA B 127      21.725  37.301  -8.243  1.00 86.53           C  
ATOM   2176  N   ASP B 128      24.543  35.804  -7.896  0.50 87.41           N  
ATOM   2178  CA  ASP B 128      26.006  35.845  -8.046  0.50 89.09           C  
ATOM   2180  C   ASP B 128      26.531  34.674  -8.882  0.50 86.84           C  
ATOM   2182  O   ASP B 128      27.544  34.806  -9.575  0.50 88.15           O  
ATOM   2184  CB  ASP B 128      26.729  35.916  -6.690  0.50 91.01           C  
ATOM   2186  CG  ASP B 128      27.157  37.335  -6.323  0.50 94.63           C  
ATOM   2188  OD1 ASP B 128      28.362  37.539  -6.050  0.50 96.76           O  
ATOM   2190  OD2 ASP B 128      26.299  38.247  -6.315  0.50 94.49           O  
ATOM   2192  N   THR B 129      25.803  33.561  -8.850  1.00 83.84           N  
ATOM   2193  CA  THR B 129      26.319  32.261  -9.301  1.00 81.41           C  
ATOM   2194  C   THR B 129      26.207  31.904 -10.784  1.00 79.77           C  
ATOM   2195  O   THR B 129      25.722  32.685 -11.604  1.00 80.04           O  
ATOM   2196  CB  THR B 129      25.603  31.134  -8.536  1.00 79.32           C  
ATOM   2197  OG1 THR B 129      24.350  30.848  -9.182  1.00 77.30           O  
ATOM   2198  CG2 THR B 129      25.359  31.526  -7.074  1.00 80.28           C  
ATOM   2199  N   ASP B 130      26.668  30.693 -11.094  1.00 78.07           N  
ATOM   2200  CA  ASP B 130      26.442  30.034 -12.378  1.00 76.98           C  
ATOM   2201  C   ASP B 130      24.978  29.983 -12.764  1.00 75.35           C  
ATOM   2202  O   ASP B 130      24.630  30.157 -13.931  1.00 75.59           O  
ATOM   2203  CB  ASP B 130      26.899  28.586 -12.292  1.00 75.60           C  
ATOM   2204  CG  ASP B 130      28.374  28.425 -12.504  1.00 78.19           C  
ATOM   2205  OD1 ASP B 130      28.834  27.258 -12.469  1.00 78.17           O  
ATOM   2206  OD2 ASP B 130      29.075  29.448 -12.701  1.00 81.53           O  
ATOM   2207  N   ALA B 131      24.129  29.707 -11.778  1.00 73.70           N  
ATOM   2208  CA  ALA B 131      22.708  29.530 -12.002  1.00 71.59           C  
ATOM   2209  C   ALA B 131      21.936  30.845 -12.200  1.00 72.23           C  
ATOM   2210  O   ALA B 131      20.723  30.837 -12.331  1.00 71.08           O  
ATOM   2211  CB  ALA B 131      22.114  28.711 -10.858  1.00 70.24           C  
ATOM   2212  N   ALA B 132      22.635  31.971 -12.243  1.00 74.16           N  
ATOM   2213  CA  ALA B 132      21.956  33.264 -12.310  1.00 75.51           C  
ATOM   2214  C   ALA B 132      20.910  33.329 -13.417  1.00 74.67           C  
ATOM   2215  O   ALA B 132      19.863  33.923 -13.214  1.00 75.08           O  
ATOM   2216  CB  ALA B 132      22.937  34.385 -12.445  1.00 78.03           C  
ATOM   2217  N   ARG B 133      21.186  32.713 -14.571  1.00 73.50           N  
ATOM   2218  CA  ARG B 133      20.235  32.722 -15.704  1.00 72.71           C  
ATOM   2219  C   ARG B 133      19.466  31.394 -15.886  1.00 68.35           C  
ATOM   2220  O   ARG B 133      19.087  31.032 -17.014  1.00 67.88           O  
ATOM   2221  CB  ARG B 133      20.929  33.122 -17.010  1.00 74.20           C  
ATOM   2222  CG  ARG B 133      21.475  34.538 -17.043  1.00 79.49           C  
ATOM   2223  CD  ARG B 133      21.956  34.891 -18.463  1.00 82.18           C  
ATOM   2224  NE  ARG B 133      22.963  35.966 -18.450  1.00 93.43           N  
ATOM   2225  CZ  ARG B 133      22.685  37.284 -18.484  1.00 99.55           C  
ATOM   2226  NH1 ARG B 133      21.417  37.731 -18.544  1.00101.49           N  
ATOM   2227  NH2 ARG B 133      23.686  38.171 -18.452  1.00103.72           N  
ATOM   2228  N   ILE B 134      19.229  30.690 -14.773  1.00 64.72           N  
ATOM   2229  CA  ILE B 134      18.440  29.452 -14.749  1.00 60.41           C  
ATOM   2230  C   ILE B 134      17.155  29.550 -15.589  1.00 59.19           C  
ATOM   2231  O   ILE B 134      16.792  28.625 -16.299  1.00 58.15           O  
ATOM   2232  CB  ILE B 134      18.126  28.995 -13.282  1.00 59.34           C  
ATOM   2233  CG1 ILE B 134      17.202  27.779 -13.235  1.00 57.84           C  
ATOM   2234  CG2 ILE B 134      17.428  30.072 -12.489  1.00 58.92           C  
ATOM   2235  CD1 ILE B 134      17.869  26.454 -13.465  1.00 56.35           C  
ATOM   2236  N   LYS B 135      16.483  30.684 -15.535  1.00 59.16           N  
ATOM   2237  CA  LYS B 135      15.228  30.824 -16.223  1.00 58.07           C  
ATOM   2238  C   LYS B 135      15.342  30.785 -17.744  1.00 58.75           C  
ATOM   2239  O   LYS B 135      14.527  30.127 -18.401  1.00 58.59           O  
ATOM   2240  CB  LYS B 135      14.566  32.099 -15.805  1.00 59.54           C  
ATOM   2241  CG  LYS B 135      13.792  31.999 -14.536  1.00 59.38           C  
ATOM   2242  CD  LYS B 135      12.739  33.078 -14.631  1.00 61.62           C  
ATOM   2243  CE  LYS B 135      12.067  33.282 -13.341  1.00 61.81           C  
ATOM   2244  NZ  LYS B 135      11.023  34.283 -13.566  1.00 63.76           N  
ATOM   2245  N   GLY B 136      16.328  31.484 -18.317  1.00 59.40           N  
ATOM   2246  CA  GLY B 136      16.501  31.454 -19.760  1.00 59.04           C  
ATOM   2247  C   GLY B 136      16.960  30.074 -20.147  1.00 57.47           C  
ATOM   2248  O   GLY B 136      16.541  29.503 -21.159  1.00 57.99           O  
ATOM   2249  N   VAL B 137      17.807  29.509 -19.306  1.00 55.51           N  
ATOM   2250  CA  VAL B 137      18.341  28.209 -19.578  1.00 53.94           C  
ATOM   2251  C   VAL B 137      17.193  27.232 -19.774  1.00 52.64           C  
ATOM   2252  O   VAL B 137      17.160  26.505 -20.782  1.00 53.20           O  
ATOM   2253  CB  VAL B 137      19.278  27.766 -18.440  1.00 53.40           C  
ATOM   2254  CG1 VAL B 137      19.611  26.274 -18.530  1.00 50.98           C  
ATOM   2255  CG2 VAL B 137      20.554  28.603 -18.464  1.00 54.76           C  
ATOM   2256  N   LEU B 138      16.240  27.246 -18.835  1.00 50.82           N  
ATOM   2257  CA  LEU B 138      15.132  26.288 -18.841  1.00 48.53           C  
ATOM   2258  C   LEU B 138      14.190  26.577 -20.002  1.00 49.31           C  
ATOM   2259  O   LEU B 138      13.726  25.652 -20.684  1.00 48.85           O  
ATOM   2260  CB  LEU B 138      14.405  26.263 -17.489  1.00 47.08           C  
ATOM   2261  CG  LEU B 138      15.211  25.887 -16.243  1.00 44.80           C  
ATOM   2262  CD1 LEU B 138      14.391  26.146 -14.999  1.00 45.55           C  
ATOM   2263  CD2 LEU B 138      15.669  24.445 -16.291  1.00 42.01           C  
ATOM   2264  N   ARG B 139      13.932  27.865 -20.214  0.50 50.58           N  
ATOM   2266  CA  ARG B 139      13.215  28.361 -21.388  0.50 52.60           C  
ATOM   2268  C   ARG B 139      13.811  27.771 -22.679  0.50 53.61           C  
ATOM   2270  O   ARG B 139      13.089  27.216 -23.513  0.50 54.12           O  
ATOM   2272  CB  ARG B 139      13.257  29.899 -21.405  0.50 54.29           C  
ATOM   2274  CG  ARG B 139      11.891  30.565 -21.563  0.50 55.66           C  
ATOM   2276  CD  ARG B 139      11.651  31.701 -20.547  0.50 55.49           C  
ATOM   2278  NE  ARG B 139      12.745  32.670 -20.536  0.50 56.36           N  
ATOM   2280  CZ  ARG B 139      12.959  33.536 -19.549  0.50 55.62           C  
ATOM   2282  NH1 ARG B 139      13.992  34.374 -19.615  0.50 55.18           N  
ATOM   2284  NH2 ARG B 139      12.142  33.554 -18.500  0.50 52.44           N  
ATOM   2286  N   THR B 140      15.135  27.866 -22.810  1.00 54.05           N  
ATOM   2287  CA  THR B 140      15.882  27.285 -23.934  1.00 55.24           C  
ATOM   2288  C   THR B 140      15.634  25.772 -24.010  1.00 53.50           C  
ATOM   2289  O   THR B 140      15.324  25.230 -25.078  1.00 54.54           O  
ATOM   2290  CB  THR B 140      17.406  27.586 -23.872  1.00 56.24           C  
ATOM   2291  OG1 THR B 140      17.650  29.005 -23.916  1.00 59.17           O  
ATOM   2292  CG2 THR B 140      18.111  26.954 -25.048  1.00 56.69           C  
ATOM   2293  N   LEU B 141      15.719  25.108 -22.862  1.00 51.10           N  
ATOM   2294  CA  LEU B 141      15.535  23.669 -22.805  1.00 49.85           C  
ATOM   2295  C   LEU B 141      14.161  23.246 -23.346  1.00 51.37           C  
ATOM   2296  O   LEU B 141      14.080  22.378 -24.246  1.00 52.98           O  
ATOM   2297  CB  LEU B 141      15.782  23.134 -21.394  1.00 47.52           C  
ATOM   2298  CG  LEU B 141      15.397  21.680 -21.107  1.00 45.50           C  
ATOM   2299  CD1 LEU B 141      16.085  20.693 -22.048  1.00 45.12           C  
ATOM   2300  CD2 LEU B 141      15.695  21.345 -19.657  1.00 43.77           C  
ATOM   2301  N   LEU B 142      13.101  23.842 -22.811  1.00 51.02           N  
ATOM   2302  CA  LEU B 142      11.744  23.518 -23.235  1.00 50.63           C  
ATOM   2303  C   LEU B 142      11.557  23.772 -24.727  1.00 53.53           C  
ATOM   2304  O   LEU B 142      10.958  22.960 -25.434  1.00 53.79           O  
ATOM   2305  CB  LEU B 142      10.724  24.329 -22.433  1.00 49.24           C  
ATOM   2306  CG  LEU B 142      10.630  24.012 -20.939  1.00 45.85           C  
ATOM   2307  CD1 LEU B 142      10.066  25.197 -20.171  1.00 43.75           C  
ATOM   2308  CD2 LEU B 142       9.788  22.767 -20.704  1.00 42.55           C  
ATOM   2309  N   ASP B 143      12.073  24.902 -25.200  1.00 56.11           N  
ATOM   2310  CA  ASP B 143      12.040  25.223 -26.621  1.00 60.55           C  
ATOM   2311  C   ASP B 143      12.630  24.092 -27.457  1.00 61.58           C  
ATOM   2312  O   ASP B 143      12.033  23.659 -28.443  1.00 63.05           O  
ATOM   2313  CB  ASP B 143      12.794  26.526 -26.893  1.00 62.72           C  
ATOM   2314  CG  ASP B 143      12.039  27.748 -26.406  1.00 67.80           C  
ATOM   2315  OD1 ASP B 143      11.046  27.580 -25.669  1.00 71.07           O  
ATOM   2316  OD2 ASP B 143      12.439  28.877 -26.762  1.00 72.90           O  
ATOM   2317  N   VAL B 144      13.805  23.618 -27.056  1.00 61.19           N  
ATOM   2318  CA  VAL B 144      14.454  22.504 -27.737  1.00 62.41           C  
ATOM   2319  C   VAL B 144      13.619  21.233 -27.634  1.00 63.36           C  
ATOM   2320  O   VAL B 144      13.515  20.467 -28.593  1.00 64.65           O  
ATOM   2321  CB  VAL B 144      15.857  22.233 -27.163  1.00 61.28           C  
ATOM   2322  CG1 VAL B 144      16.376  20.887 -27.645  1.00 59.91           C  
ATOM   2323  CG2 VAL B 144      16.814  23.351 -27.550  1.00 61.44           C  
ATOM   2324  N   LEU B 145      13.025  21.013 -26.465  1.00 63.25           N  
ATOM   2325  CA  LEU B 145      12.310  19.774 -26.189  1.00 65.27           C  
ATOM   2326  C   LEU B 145      11.016  19.693 -26.992  1.00 70.00           C  
ATOM   2327  O   LEU B 145      10.258  18.731 -26.872  1.00 70.66           O  
ATOM   2328  CB  LEU B 145      12.009  19.649 -24.694  1.00 61.90           C  
ATOM   2329  CG  LEU B 145      13.141  19.107 -23.818  1.00 58.97           C  
ATOM   2330  CD1 LEU B 145      12.899  19.447 -22.356  1.00 54.75           C  
ATOM   2331  CD2 LEU B 145      13.292  17.604 -24.005  1.00 55.43           C  
ATOM   2332  N   ASP B 146      10.770  20.711 -27.811  1.00 75.75           N  
ATOM   2333  CA  ASP B 146       9.513  20.820 -28.542  1.00 81.85           C  
ATOM   2334  C   ASP B 146       9.628  20.202 -29.931  1.00 85.88           C  
ATOM   2335  O   ASP B 146       8.917  20.593 -30.856  1.00 89.09           O  
ATOM   2336  CB  ASP B 146       9.081  22.283 -28.652  1.00 82.58           C  
ATOM   2337  CG  ASP B 146       7.707  22.531 -28.063  1.00 86.32           C  
ATOM   2338  OD1 ASP B 146       7.088  21.566 -27.566  1.00 88.81           O  
ATOM   2339  OD2 ASP B 146       7.244  23.691 -28.097  1.00 91.63           O  
TER    2340      ASP B 146                                                      
END
MOLECULE T0459.pdb
ATOM      1  N   SER     1     -10.415  21.770  17.737  1.00 36.73           N  
ATOM      2  CA  SER     1      -9.300  22.637  18.208  1.00 36.27           C  
ATOM      3  C   SER     1      -8.557  23.266  17.037  1.00 35.28           C  
ATOM      4  O   SER     1      -8.379  22.640  15.973  1.00 35.90           O  
ATOM      5  CB  SER     1      -8.351  21.893  19.152  1.00 36.84           C  
ATOM      6  OG  SER     1      -7.375  22.791  19.686  1.00 38.33           O  
ATOM      7  N   ASN     2      -8.124  24.504  17.269  1.00 33.96           N  
ATOM      8  CA  ASN     2      -7.662  25.408  16.215  0.50 33.06           C  
ATOM     10  C   ASN     2      -6.217  25.852  16.369  1.00 32.42           C  
ATOM     11  O   ASN     2      -5.703  25.916  17.477  1.00 32.77           O  
ATOM     12  CB  ASN     2      -8.522  26.677  16.208  0.50 33.17           C  
ATOM     14  CG  ASN     2      -9.904  26.457  15.620  0.50 33.12           C  
ATOM     16  OD1 ASN     2     -10.596  27.422  15.296  0.50 35.02           O  
ATOM     18  ND2 ASN     2     -10.312  25.197  15.473  0.50 31.87           N  
ATOM     20  N   ALA     3      -5.592  26.188  15.250  1.00 31.43           N  
ATOM     21  CA  ALA     3      -4.314  26.862  15.272  1.00 31.00           C  
ATOM     22  C   ALA     3      -4.652  28.337  15.273  1.00 30.63           C  
ATOM     23  O   ALA     3      -5.545  28.766  14.533  1.00 31.26           O  
ATOM     24  CB  ALA     3      -3.484  26.499  14.033  1.00 30.25           C  
ATOM     25  N   MET     4      -3.954  29.122  16.099  1.00 30.89           N  
ATOM     26  CA  MET     4      -4.173  30.557  16.181  1.00 30.57           C  
ATOM     27  C   MET     4      -2.912  31.223  15.687  1.00 29.89           C  
ATOM     28  O   MET     4      -1.831  31.018  16.275  1.00 29.61           O  
ATOM     29  CB  MET     4      -4.453  30.972  17.642  1.00 31.45           C  
ATOM     30  CG  MET     4      -5.831  30.585  18.117  1.00 34.71           C  
ATOM     31  SD  MET     4      -7.230  31.555  17.154  0.55 40.32          SE  
ATOM     32  CE  MET     4      -7.248  33.228  18.136  1.00 40.24           C  
ATOM     33  N   LEU     5      -3.022  31.969  14.595  1.00 29.52           N  
ATOM     34  CA  LEU     5      -1.845  32.551  13.938  1.00 30.45           C  
ATOM     35  C   LEU     5      -1.815  34.086  14.040  1.00 31.10           C  
ATOM     36  O   LEU     5      -2.754  34.760  13.649  1.00 32.83           O  
ATOM     37  CB  LEU     5      -1.743  32.099  12.465  1.00 29.59           C  
ATOM     38  CG  LEU     5      -2.214  30.669  12.242  1.00 30.64           C  
ATOM     39  CD1 LEU     5      -2.429  30.421  10.765  1.00 30.79           C  
ATOM     40  CD2 LEU     5      -1.193  29.717  12.859  1.00 27.96           C  
ATOM     41  N   ARG     6      -0.726  34.617  14.576  1.00 31.38           N  
ATOM     42  CA  ARG     6      -0.573  36.055  14.754  1.00 31.04           C  
ATOM     43  C   ARG     6      -0.465  36.732  13.387  1.00 30.97           C  
ATOM     44  O   ARG     6       0.359  36.338  12.565  1.00 32.05           O  
ATOM     45  CB  ARG     6       0.690  36.338  15.573  1.00 29.54           C  
ATOM     46  CG  ARG     6       1.027  37.817  15.740  1.00 33.13           C  
ATOM     47  CD  ARG     6      -0.136  38.565  16.275  1.00 33.20           C  
ATOM     48  NE  ARG     6      -0.526  38.164  17.630  1.00 33.00           N  
ATOM     49  CZ  ARG     6      -1.502  38.758  18.316  1.00 32.70           C  
ATOM     50  NH1 ARG     6      -1.812  38.328  19.523  1.00 30.79           N  
ATOM     51  NH2 ARG     6      -2.166  39.785  17.789  1.00 30.14           N  
ATOM     52  N   TYR     7      -1.294  37.754  13.164  1.00 30.67           N  
ATOM     53  CA  TYR     7      -1.218  38.537  11.932  1.00 30.64           C  
ATOM     54  C   TYR     7      -1.426  40.007  12.314  1.00 29.31           C  
ATOM     55  O   TYR     7      -2.557  40.492  12.356  1.00 29.58           O  
ATOM     56  CB  TYR     7      -2.276  38.071  10.921  1.00 30.37           C  
ATOM     57  CG  TYR     7      -2.256  38.775   9.583  1.00 31.58           C  
ATOM     58  CD1 TYR     7      -1.073  39.265   9.039  1.00 33.67           C  
ATOM     59  CD2 TYR     7      -3.426  38.915   8.837  1.00 31.83           C  
ATOM     60  CE1 TYR     7      -1.063  39.895   7.783  1.00 33.79           C  
ATOM     61  CE2 TYR     7      -3.420  39.529   7.601  1.00 33.39           C  
ATOM     62  CZ  TYR     7      -2.248  40.022   7.077  1.00 33.60           C  
ATOM     63  OH  TYR     7      -2.258  40.659   5.856  1.00 32.89           O  
ATOM     64  N   GLY     8      -0.335  40.706  12.641  1.00 29.52           N  
ATOM     65  CA  GLY     8      -0.478  42.089  13.106  1.00 29.08           C  
ATOM     66  C   GLY     8      -1.219  42.101  14.434  1.00 29.21           C  
ATOM     67  O   GLY     8      -0.928  41.314  15.325  1.00 29.78           O  
ATOM     68  N   ASP     9      -2.211  42.967  14.560  1.00 27.53           N  
ATOM     69  CA  ASP     9      -2.978  43.109  15.794  1.00 29.01           C  
ATOM     70  C   ASP     9      -4.059  42.029  15.926  1.00 28.64           C  
ATOM     71  O   ASP     9      -4.835  42.060  16.876  1.00 30.34           O  
ATOM     72  CB  ASP     9      -3.594  44.499  15.809  1.00 27.53           C  
ATOM     73  CG  ASP     9      -4.168  44.903  17.184  1.00 28.31           C  
ATOM     74  OD1 ASP     9      -3.576  44.591  18.255  1.00 27.20           O  
ATOM     75  OD2 ASP     9      -5.212  45.572  17.173  1.00 31.32           O  
ATOM     76  N   THR    10      -4.131  41.110  14.963  1.00 28.31           N  
ATOM     77  CA  THR    10      -5.215  40.131  14.895  1.00 29.02           C  
ATOM     78  C   THR    10      -4.652  38.709  15.031  1.00 27.83           C  
ATOM     79  O   THR    10      -3.436  38.485  14.855  1.00 27.98           O  
ATOM     80  CB  THR    10      -6.007  40.207  13.547  1.00 28.56           C  
ATOM     81  OG1 THR    10      -5.235  39.584  12.498  1.00 32.75           O  
ATOM     82  CG2 THR    10      -6.377  41.661  13.190  1.00 31.29           C  
ATOM     83  N   GLU    11      -5.522  37.757  15.346  1.00 26.75           N  
ATOM     84  CA  GLU    11      -5.136  36.351  15.200  1.00 28.15           C  
ATOM     85  C   GLU    11      -6.073  35.652  14.215  1.00 27.58           C  
ATOM     86  O   GLU    11      -7.293  35.848  14.254  1.00 27.69           O  
ATOM     87  CB  GLU    11      -5.099  35.638  16.554  1.00 27.56           C  
ATOM     88  CG  GLU    11      -4.013  36.141  17.491  1.00 30.04           C  
ATOM     89  CD  GLU    11      -4.107  35.489  18.861  1.00 34.00           C  
ATOM     90  OE1 GLU    11      -5.031  35.867  19.629  1.00 35.94           O  
ATOM     91  OE2 GLU    11      -3.266  34.612  19.176  1.00 33.57           O  
ATOM     92  N   ILE    12      -5.483  34.849  13.343  1.00 28.49           N  
ATOM     93  CA  ILE    12      -6.224  34.097  12.330  1.00 28.91           C  
ATOM     94  C   ILE    12      -6.443  32.708  12.938  1.00 28.83           C  
ATOM     95  O   ILE    12      -5.486  32.098  13.439  1.00 29.05           O  
ATOM     96  CB  ILE    12      -5.396  33.983  11.020  1.00 29.30           C  
ATOM     97  CG1 ILE    12      -5.011  35.389  10.494  1.00 31.03           C  
ATOM     98  CG2 ILE    12      -6.140  33.091   9.963  1.00 29.96           C  
ATOM     99  CD1 ILE    12      -3.927  35.376   9.367  1.00 31.07           C  
ATOM    100  N   CYS    13      -7.692  32.251  12.882  1.00 27.28           N  
ATOM    101  CA  CYS    13      -8.078  30.950  13.372  0.50 27.26           C  
ATOM    103  C   CYS    13      -8.209  29.961  12.206  1.00 28.00           C  
ATOM    104  O   CYS    13      -8.972  30.213  11.261  1.00 27.25           O  
ATOM    105  CB  CYS    13      -9.414  31.073  14.111  0.50 27.24           C  
ATOM    107  SG  CYS    13      -9.844  29.604  15.022  0.50 25.64           S  
ATOM    109  N   ILE    14      -7.452  28.860  12.267  1.00 27.87           N  
ATOM    110  CA  ILE    14      -7.549  27.773  11.287  1.00 28.04           C  
ATOM    111  C   ILE    14      -7.750  26.429  11.994  1.00 28.25           C  
ATOM    112  O   ILE    14      -6.969  26.035  12.867  1.00 28.02           O  
ATOM    113  CB  ILE    14      -6.265  27.649  10.389  1.00 27.07           C  
ATOM    114  CG1 ILE    14      -5.966  28.980   9.657  1.00 28.97           C  
ATOM    115  CG2 ILE    14      -6.350  26.422   9.419  1.00 27.42           C  
ATOM    116  CD1 ILE    14      -6.819  29.234   8.425  1.00 28.09           C  
ATOM    117  N   ASP    15      -8.777  25.714  11.588  1.00 28.87           N  
ATOM    118  CA  ASP    15      -8.945  24.371  12.055  1.00 30.05           C  
ATOM    119  C   ASP    15      -8.263  23.415  11.067  1.00 31.28           C  
ATOM    120  O   ASP    15      -8.756  23.220   9.966  1.00 31.16           O  
ATOM    121  CB  ASP    15     -10.434  24.082  12.189  1.00 30.09           C  
ATOM    122  CG  ASP    15     -10.708  22.784  12.894  1.00 30.26           C  
ATOM    123  OD1 ASP    15      -9.748  22.031  13.153  1.00 32.36           O  
ATOM    124  OD2 ASP    15     -11.892  22.515  13.186  1.00 30.84           O  
ATOM    125  N   PRO    16      -7.133  22.799  11.470  1.00 32.52           N  
ATOM    126  CA  PRO    16      -6.366  22.006  10.524  1.00 33.72           C  
ATOM    127  C   PRO    16      -7.133  20.771  10.042  1.00 34.14           C  
ATOM    128  O   PRO    16      -6.857  20.285   8.952  1.00 35.37           O  
ATOM    129  CB  PRO    16      -5.117  21.598  11.324  1.00 33.18           C  
ATOM    130  CG  PRO    16      -5.070  22.521  12.481  1.00 34.54           C  
ATOM    131  CD  PRO    16      -6.514  22.776  12.806  1.00 33.05           C  
ATOM    132  N   SER    17      -8.095  20.287  10.833  1.00 35.19           N  
ATOM    133  CA  SER    17      -8.889  19.114  10.454  1.00 35.46           C  
ATOM    134  C   SER    17     -10.103  19.438   9.566  1.00 35.43           C  
ATOM    135  O   SER    17     -10.689  18.533   8.970  1.00 35.51           O  
ATOM    136  CB  SER    17      -9.323  18.324  11.694  1.00 35.69           C  
ATOM    137  OG  SER    17     -10.303  19.026  12.444  1.00 35.63           O  
ATOM    138  N   GLU    18     -10.492  20.715   9.519  1.00 35.21           N  
ATOM    139  CA  GLU    18     -11.559  21.189   8.631  0.50 35.18           C  
ATOM    141  C   GLU    18     -11.283  22.617   8.158  1.00 35.05           C  
ATOM    142  O   GLU    18     -11.663  23.598   8.809  1.00 35.41           O  
ATOM    143  CB  GLU    18     -12.934  21.076   9.299  0.50 35.13           C  
ATOM    145  CG  GLU    18     -13.636  19.744   9.037  0.50 35.62           C  
ATOM    147  CD  GLU    18     -15.015  19.656   9.662  0.50 35.62           C  
ATOM    149  OE1 GLU    18     -15.498  18.516   9.856  0.50 37.29           O  
ATOM    151  OE2 GLU    18     -15.618  20.715   9.959  0.50 36.60           O  
ATOM    153  N   SER    19     -10.578  22.722   7.042  1.00 34.61           N  
ATOM    154  CA  SER    19     -10.251  23.990   6.427  1.00 33.27           C  
ATOM    155  C   SER    19      -9.994  23.714   4.972  1.00 33.78           C  
ATOM    156  O   SER    19      -9.529  22.624   4.618  1.00 34.23           O  
ATOM    157  CB  SER    19      -8.959  24.579   7.013  1.00 33.81           C  
ATOM    158  OG  SER    19      -8.575  25.719   6.249  1.00 31.21           O  
ATOM    159  N   VAL    20     -10.272  24.705   4.130  1.00 32.42           N  
ATOM    160  CA  VAL    20      -9.977  24.617   2.696  1.00 32.16           C  
ATOM    161  C   VAL    20      -8.453  24.665   2.466  1.00 30.52           C  
ATOM    162  O   VAL    20      -7.976  24.456   1.359  1.00 29.18           O  
ATOM    163  CB  VAL    20     -10.799  25.651   1.899  1.00 32.40           C  
ATOM    164  CG1 VAL    20     -10.376  27.082   2.223  1.00 33.30           C  
ATOM    165  CG2 VAL    20     -10.736  25.355   0.412  1.00 34.67           C  
ATOM    166  N   LEU    21      -7.706  24.923   3.541  1.00 29.65           N  
ATOM    167  CA  LEU    21      -6.253  24.853   3.500  1.00 28.31           C  
ATOM    168  C   LEU    21      -5.823  23.451   3.035  1.00 28.00           C  
ATOM    169  O   LEU    21      -4.853  23.340   2.297  1.00 27.24           O  
ATOM    170  CB  LEU    21      -5.656  25.160   4.885  1.00 29.04           C  
ATOM    171  CG  LEU    21      -4.133  25.098   5.000  1.00 29.06           C  
ATOM    172  CD1 LEU    21      -3.468  26.066   4.034  1.00 30.76           C  
ATOM    173  CD2 LEU    21      -3.743  25.385   6.456  1.00 28.18           C  
ATOM    174  N   HIS    22      -6.556  22.406   3.447  1.00 28.90           N  
ATOM    175  CA  HIS    22      -6.261  21.027   3.059  1.00 30.07           C  
ATOM    176  C   HIS    22      -6.226  20.912   1.547  1.00 29.78           C  
ATOM    177  O   HIS    22      -5.251  20.412   0.960  1.00 29.81           O  
ATOM    178  CB  HIS    22      -7.317  20.060   3.652  1.00 29.57           C  
ATOM    179  CG  HIS    22      -7.121  18.620   3.283  1.00 32.86           C  
ATOM    180  ND1 HIS    22      -6.237  17.801   3.948  1.00 36.16           N  
ATOM    181  CD2 HIS    22      -7.733  17.840   2.360  1.00 34.12           C  
ATOM    182  CE1 HIS    22      -6.294  16.579   3.437  1.00 36.42           C  
ATOM    183  NE2 HIS    22      -7.190  16.577   2.466  1.00 36.45           N  
ATOM    184  N   LEU    23      -7.285  21.393   0.913  1.00 30.25           N  
ATOM    185  CA  LEU    23      -7.368  21.335  -0.557  1.00 30.37           C  
ATOM    186  C   LEU    23      -6.252  22.166  -1.182  1.00 32.08           C  
ATOM    187  O   LEU    23      -5.524  21.680  -2.070  1.00 32.10           O  
ATOM    188  CB  LEU    23      -8.720  21.857  -1.021  1.00 30.65           C  
ATOM    189  CG  LEU    23      -8.897  22.039  -2.536  1.00 30.24           C  
ATOM    190  CD1 LEU    23      -8.535  20.766  -3.354  1.00 33.22           C  
ATOM    191  CD2 LEU    23     -10.331  22.521  -2.824  1.00 30.94           C  
ATOM    192  N   LEU    24      -6.104  23.391  -0.684  1.00 31.13           N  
ATOM    193  CA  LEU    24      -5.102  24.306  -1.222  0.50 32.96           C  
ATOM    195  C   LEU    24      -3.688  23.739  -1.206  1.00 32.52           C  
ATOM    196  O   LEU    24      -2.888  24.059  -2.084  1.00 33.32           O  
ATOM    197  CB  LEU    24      -5.166  25.659  -0.514  0.50 32.98           C  
ATOM    199  CG  LEU    24      -5.817  26.795  -1.310  0.50 35.89           C  
ATOM    201  CD1 LEU    24      -4.761  27.454  -2.172  0.50 35.58           C  
ATOM    203  CD2 LEU    24      -7.035  26.378  -2.160  0.50 34.56           C  
ATOM    205  N   GLY    25      -3.403  22.889  -0.235  1.00 32.78           N  
ATOM    206  CA  GLY    25      -2.078  22.271  -0.122  1.00 32.77           C  
ATOM    207  C   GLY    25      -1.807  21.076  -1.029  1.00 32.09           C  
ATOM    208  O   GLY    25      -0.650  20.775  -1.316  1.00 32.25           O  
ATOM    209  N   LYS    26      -2.856  20.387  -1.470  1.00 31.77           N  
ATOM    210  CA  LYS    26      -2.693  19.222  -2.330  1.00 31.54           C  
ATOM    211  C   LYS    26      -1.923  19.602  -3.599  1.00 30.09           C  
ATOM    212  O   LYS    26      -2.096  20.721  -4.130  1.00 30.18           O  
ATOM    213  CB  LYS    26      -4.059  18.649  -2.710  1.00 32.58           C  
ATOM    214  CG  LYS    26      -4.788  18.002  -1.562  1.00 32.14           C  
ATOM    215  CD  LYS    26      -6.073  17.350  -2.043  1.00 34.07           C  
ATOM    216  CE  LYS    26      -7.020  17.150  -0.861  1.00 33.53           C  
ATOM    217  NZ  LYS    26      -7.663  15.793  -0.867  1.00 32.24           N  
ATOM    218  N   LYS    27      -1.108  18.658  -4.079  1.00 29.46           N  
ATOM    219  CA  LYS    27      -0.247  18.883  -5.225  1.00 28.20           C  
ATOM    220  C   LYS    27      -1.054  19.512  -6.367  1.00 28.47           C  
ATOM    221  O   LYS    27      -2.137  19.019  -6.699  1.00 27.82           O  
ATOM    222  CB  LYS    27       0.416  17.575  -5.684  1.00 28.29           C  
ATOM    223  CG  LYS    27       1.558  17.841  -6.624  1.00 27.35           C  
ATOM    224  CD  LYS    27       2.366  16.571  -6.953  1.00 28.02           C  
ATOM    225  CE  LYS    27       3.506  16.937  -7.892  1.00 32.06           C  
ATOM    226  NZ  LYS    27       4.144  18.235  -7.451  1.00 36.20           N  
ATOM    227  N   TYR    28      -0.517  20.598  -6.946  1.00 28.32           N  
ATOM    228  CA  TYR    28      -1.099  21.296  -8.107  1.00 28.81           C  
ATOM    229  C   TYR    28      -2.205  22.310  -7.836  1.00 28.80           C  
ATOM    230  O   TYR    28      -2.531  23.094  -8.711  1.00 29.16           O  
ATOM    231  CB  TYR    28      -1.559  20.314  -9.194  1.00 29.50           C  
ATOM    232  CG  TYR    28      -0.450  19.424  -9.733  1.00 28.58           C  
ATOM    233  CD1 TYR    28      -0.473  18.049  -9.500  1.00 28.14           C  
ATOM    234  CD2 TYR    28       0.598  19.954 -10.506  1.00 29.00           C  
ATOM    235  CE1 TYR    28       0.524  17.238  -9.999  1.00 26.00           C  
ATOM    236  CE2 TYR    28       1.591  19.138 -11.004  1.00 29.83           C  
ATOM    237  CZ  TYR    28       1.546  17.785 -10.750  1.00 28.24           C  
ATOM    238  OH  TYR    28       2.518  16.953 -11.254  1.00 32.25           O  
ATOM    239  N   THR    29      -2.806  22.288  -6.652  1.00 29.70           N  
ATOM    240  CA  THR    29      -4.030  23.111  -6.461  1.00 28.91           C  
ATOM    241  C   THR    29      -3.724  24.580  -6.628  1.00 28.79           C  
ATOM    242  O   THR    29      -4.461  25.297  -7.314  1.00 29.77           O  
ATOM    243  CB  THR    29      -4.723  22.829  -5.115  1.00 28.38           C  
ATOM    244  OG1 THR    29      -5.036  21.427  -5.024  1.00 29.94           O  
ATOM    245  CG2 THR    29      -6.051  23.661  -4.985  1.00 29.10           C  
ATOM    246  N   MET    30      -2.620  25.026  -6.029  1.00 28.10           N  
ATOM    247  CA  MET    30      -2.255  26.452  -6.125  1.00 29.83           C  
ATOM    248  C   MET    30      -1.906  26.795  -7.568  1.00 30.09           C  
ATOM    249  O   MET    30      -2.248  27.882  -8.076  1.00 30.64           O  
ATOM    250  CB  MET    30      -1.124  26.810  -5.159  1.00 28.47           C  
ATOM    251  CG  MET    30      -1.574  26.776  -3.713  1.00 31.09           C  
ATOM    252  SD  MET    30      -0.134  27.257  -2.471  0.70 33.89          SE  
ATOM    253  CE  MET    30       0.430  25.413  -2.065  1.00 34.51           C  
ATOM    254  N   LEU    31      -1.256  25.865  -8.251  1.00 29.49           N  
ATOM    255  CA  LEU    31      -0.925  26.090  -9.670  1.00 29.99           C  
ATOM    256  C   LEU    31      -2.194  26.139 -10.532  1.00 30.67           C  
ATOM    257  O   LEU    31      -2.239  26.936 -11.482  1.00 29.61           O  
ATOM    258  CB  LEU    31       0.010  25.028 -10.176  1.00 28.61           C  
ATOM    259  CG  LEU    31       1.444  25.100  -9.620  1.00 27.57           C  
ATOM    260  CD1 LEU    31       2.213  23.844 -10.095  1.00 29.53           C  
ATOM    261  CD2 LEU    31       2.111  26.434  -9.955  1.00 32.58           C  
ATOM    262  N   ILE    32      -3.185  25.287 -10.245  1.00 29.61           N  
ATOM    263  CA  ILE    32      -4.465  25.322 -11.009  1.00 29.63           C  
ATOM    264  C   ILE    32      -5.139  26.703 -10.810  1.00 29.77           C  
ATOM    265  O   ILE    32      -5.554  27.360 -11.786  1.00 31.22           O  
ATOM    266  CB  ILE    32      -5.391  24.184 -10.600  1.00 30.11           C  
ATOM    267  CG1 ILE    32      -4.787  22.835 -11.077  1.00 28.44           C  
ATOM    268  CG2 ILE    32      -6.790  24.419 -11.191  1.00 28.91           C  
ATOM    269  CD1 ILE    32      -5.362  21.530 -10.391  1.00 31.16           C  
ATOM    270  N   ILE    33      -5.281  27.127  -9.558  1.00 29.65           N  
ATOM    271  CA  ILE    33      -5.825  28.471  -9.275  1.00 29.78           C  
ATOM    272  C   ILE    33      -5.058  29.559 -10.007  1.00 30.83           C  
ATOM    273  O   ILE    33      -5.651  30.456 -10.577  1.00 31.62           O  
ATOM    274  CB  ILE    33      -5.892  28.755  -7.747  1.00 29.54           C  
ATOM    275  CG1 ILE    33      -6.877  27.749  -7.103  1.00 30.49           C  
ATOM    276  CG2 ILE    33      -6.181  30.256  -7.430  1.00 28.42           C  
ATOM    277  CD1 ILE    33      -6.852  27.715  -5.549  1.00 31.56           C  
ATOM    278  N   SER    34      -3.729  29.467  -9.981  1.00 30.02           N  
ATOM    279  CA  SER    34      -2.897  30.477 -10.652  1.00 29.45           C  
ATOM    280  C   SER    34      -3.117  30.504 -12.175  1.00 28.34           C  
ATOM    281  O   SER    34      -3.298  31.591 -12.793  1.00 29.92           O  
ATOM    282  CB  SER    34      -1.442  30.180 -10.331  1.00 29.54           C  
ATOM    283  OG  SER    34      -1.235  30.181  -8.916  1.00 33.14           O  
ATOM    284  N   VAL    35      -3.111  29.343 -12.809  1.00 29.48           N  
ATOM    285  CA  VAL    35      -3.217  29.353 -14.278  0.50 29.47           C  
ATOM    287  C   VAL    35      -4.628  29.763 -14.714  1.00 29.83           C  
ATOM    288  O   VAL    35      -4.791  30.347 -15.768  1.00 29.45           O  
ATOM    289  CB  VAL    35      -2.722  28.043 -14.974  0.50 29.52           C  
ATOM    291  CG1 VAL    35      -1.229  27.826 -14.719  0.50 29.61           C  
ATOM    293  CG2 VAL    35      -3.564  26.808 -14.566  0.50 29.25           C  
ATOM    295  N   LEU    36      -5.645  29.463 -13.891  1.00 29.61           N  
ATOM    296  CA  LEU    36      -7.026  29.830 -14.265  1.00 31.83           C  
ATOM    297  C   LEU    36      -7.212  31.343 -14.373  1.00 32.62           C  
ATOM    298  O   LEU    36      -8.154  31.860 -15.026  1.00 33.33           O  
ATOM    299  CB  LEU    36      -8.044  29.180 -13.312  1.00 31.76           C  
ATOM    300  CG  LEU    36      -8.439  27.744 -13.631  1.00 34.33           C  
ATOM    301  CD1 LEU    36      -9.255  27.121 -12.524  1.00 33.48           C  
ATOM    302  CD2 LEU    36      -9.178  27.642 -14.990  1.00 33.15           C  
ATOM    303  N   GLY    37      -6.299  32.068 -13.741  1.00 32.67           N  
ATOM    304  CA  GLY    37      -6.279  33.536 -13.828  1.00 34.43           C  
ATOM    305  C   GLY    37      -5.287  34.122 -14.824  1.00 34.47           C  
ATOM    306  O   GLY    37      -5.086  35.329 -14.829  1.00 34.99           O  
ATOM    307  N   ASN    38      -4.641  33.283 -15.638  1.00 35.53           N  
ATOM    308  CA  ASN    38      -3.778  33.728 -16.753  1.00 35.74           C  
ATOM    309  C   ASN    38      -4.611  34.108 -17.985  1.00 37.71           C  
ATOM    310  O   ASN    38      -5.821  33.904 -17.997  1.00 38.33           O  
ATOM    311  CB  ASN    38      -2.888  32.596 -17.240  1.00 35.54           C  
ATOM    312  CG  ASN    38      -1.743  32.260 -16.305  1.00 32.45           C  
ATOM    313  OD1 ASN    38      -1.418  32.983 -15.360  1.00 31.30           O  
ATOM    314  ND2 ASN    38      -1.086  31.167 -16.616  1.00 29.32           N  
ATOM    315  N   GLY    39      -3.966  34.615 -19.038  1.00 39.07           N  
ATOM    316  CA  GLY    39      -4.673  34.919 -20.316  1.00 40.35           C  
ATOM    317  C   GLY    39      -5.968  35.731 -20.235  1.00 40.83           C  
ATOM    318  O   GLY    39      -6.278  36.332 -19.194  1.00 40.09           O  
ATOM    319  N   SER    40      -6.740  35.732 -21.329  1.00 41.52           N  
ATOM    320  CA  SER    40      -7.865  36.680 -21.492  1.00 42.35           C  
ATOM    321  C   SER    40      -9.234  36.028 -21.721  1.00 42.42           C  
ATOM    322  O   SER    40     -10.228  36.715 -22.004  1.00 43.03           O  
ATOM    323  CB  SER    40      -7.598  37.601 -22.677  1.00 42.11           C  
ATOM    324  OG  SER    40      -6.233  37.572 -23.040  1.00 45.27           O  
ATOM    325  N   THR    41      -9.281  34.709 -21.618  1.00 41.48           N  
ATOM    326  CA  THR    41     -10.417  33.957 -22.134  1.00 41.13           C  
ATOM    327  C   THR    41     -10.581  32.795 -21.206  1.00 39.96           C  
ATOM    328  O   THR    41      -9.594  32.339 -20.624  1.00 40.02           O  
ATOM    329  CB  THR    41     -10.133  33.399 -23.575  1.00 41.46           C  
ATOM    330  OG1 THR    41      -8.956  32.575 -23.555  1.00 43.48           O  
ATOM    331  CG2 THR    41      -9.929  34.522 -24.578  1.00 41.84           C  
ATOM    332  N   ARG    42     -11.815  32.308 -21.068  1.00 38.48           N  
ATOM    333  CA  ARG    42     -12.038  31.048 -20.363  1.00 36.84           C  
ATOM    334  C   ARG    42     -11.213  29.948 -21.033  1.00 35.70           C  
ATOM    335  O   ARG    42     -11.159  29.866 -22.259  1.00 35.70           O  
ATOM    336  CB  ARG    42     -13.520  30.666 -20.399  1.00 37.38           C  
ATOM    337  CG  ARG    42     -14.437  31.647 -19.684  1.00 37.62           C  
ATOM    338  CD  ARG    42     -15.883  31.164 -19.697  1.00 36.40           C  
ATOM    339  NE  ARG    42     -16.009  29.965 -18.858  1.00 36.40           N  
ATOM    340  CZ  ARG    42     -16.427  29.976 -17.597  1.00 35.20           C  
ATOM    341  NH1 ARG    42     -16.782  31.144 -17.033  1.00 34.57           N  
ATOM    342  NH2 ARG    42     -16.491  28.833 -16.902  1.00 36.13           N  
ATOM    343  N   GLN    43     -10.641  29.067 -20.218  1.00 34.69           N  
ATOM    344  CA  GLN    43      -9.776  27.977 -20.710  1.00 33.10           C  
ATOM    345  C   GLN    43     -10.503  26.657 -20.692  1.00 32.14           C  
ATOM    346  O   GLN    43     -11.269  26.403 -19.771  1.00 31.59           O  
ATOM    347  CB  GLN    43      -8.558  27.878 -19.802  1.00 33.74           C  
ATOM    348  CG  GLN    43      -7.930  29.264 -19.605  1.00 37.32           C  
ATOM    349  CD  GLN    43      -6.791  29.275 -18.585  1.00 43.97           C  
ATOM    350  OE1 GLN    43      -6.081  28.282 -18.413  1.00 50.03           O  
ATOM    351  NE2 GLN    43      -6.602  30.405 -17.932  1.00 44.66           N  
ATOM    352  N   ASN    44     -10.218  25.808 -21.680  1.00 28.58           N  
ATOM    353  CA  ASN    44     -10.733  24.442 -21.672  1.00 30.12           C  
ATOM    354  C   ASN    44      -9.770  23.560 -20.902  1.00 29.00           C  
ATOM    355  O   ASN    44      -8.722  24.046 -20.428  1.00 29.15           O  
ATOM    356  CB  ASN    44     -11.008  23.943 -23.097  1.00 28.73           C  
ATOM    357  CG  ASN    44      -9.755  23.877 -23.979  1.00 31.42           C  
ATOM    358  OD1 ASN    44      -8.635  23.648 -23.517  1.00 29.93           O  
ATOM    359  ND2 ASN    44      -9.952  24.097 -25.267  1.00 32.12           N  
ATOM    360  N   PHE    45     -10.112  22.277 -20.766  1.00 29.73           N  
ATOM    361  CA  PHE    45      -9.364  21.377 -19.899  1.00 30.13           C  
ATOM    362  C   PHE    45      -7.960  21.157 -20.412  1.00 30.35           C  
ATOM    363  O   PHE    45      -6.999  21.168 -19.616  1.00 29.85           O  
ATOM    364  CB  PHE    45     -10.114  20.083 -19.809  1.00 29.47           C  
ATOM    365  CG  PHE    45      -9.574  19.123 -18.815  1.00 29.78           C  
ATOM    366  CD1 PHE    45     -10.087  19.075 -17.518  1.00 30.76           C  
ATOM    367  CD2 PHE    45      -8.607  18.178 -19.209  1.00 30.09           C  
ATOM    368  CE1 PHE    45      -9.611  18.123 -16.595  1.00 30.36           C  
ATOM    369  CE2 PHE    45      -8.137  17.209 -18.309  1.00 30.04           C  
ATOM    370  CZ  PHE    45      -8.638  17.197 -16.999  1.00 30.03           C  
ATOM    371  N   ASN    46      -7.834  21.028 -21.730  1.00 30.11           N  
ATOM    372  CA  ASN    46      -6.501  20.863 -22.338  0.50 30.41           C  
ATOM    374  C   ASN    46      -5.610  22.071 -22.137  1.00 30.53           C  
ATOM    375  O   ASN    46      -4.413  21.919 -21.905  1.00 31.41           O  
ATOM    376  CB  ASN    46      -6.559  20.545 -23.836  0.50 30.92           C  
ATOM    378  CG  ASN    46      -5.186  20.274 -24.410  0.50 31.12           C  
ATOM    380  OD1 ASN    46      -4.574  19.255 -24.104  0.50 32.62           O  
ATOM    382  ND2 ASN    46      -4.692  21.178 -25.256  0.50 32.99           N  
ATOM    384  N   ASP    47      -6.194  23.271 -22.225  1.00 30.93           N  
ATOM    385  CA  ASP    47      -5.454  24.548 -22.028  1.00 32.46           C  
ATOM    386  C   ASP    47      -4.799  24.554 -20.632  1.00 31.87           C  
ATOM    387  O   ASP    47      -3.628  24.926 -20.456  1.00 30.64           O  
ATOM    388  CB  ASP    47      -6.390  25.776 -22.042  1.00 33.84           C  
ATOM    389  CG  ASP    47      -6.939  26.136 -23.421  1.00 36.73           C  
ATOM    390  OD1 ASP    47      -6.247  25.869 -24.457  1.00 37.68           O  
ATOM    391  OD2 ASP    47      -8.069  26.741 -23.444  1.00 37.94           O  
ATOM    392  N   ILE    48      -5.610  24.187 -19.646  1.00 30.43           N  
ATOM    393  CA  ILE    48      -5.194  24.155 -18.240  1.00 30.48           C  
ATOM    394  C   ILE    48      -4.104  23.108 -18.043  1.00 30.36           C  
ATOM    395  O   ILE    48      -3.036  23.404 -17.506  1.00 29.97           O  
ATOM    396  CB  ILE    48      -6.371  23.864 -17.297  1.00 30.17           C  
ATOM    397  CG1 ILE    48      -7.419  24.969 -17.401  1.00 30.92           C  
ATOM    398  CG2 ILE    48      -5.905  23.796 -15.860  1.00 28.80           C  
ATOM    399  CD1 ILE    48      -8.842  24.500 -16.885  1.00 31.00           C  
ATOM    400  N   ARG    49      -4.369  21.883 -18.500  1.00 29.39           N  
ATOM    401  CA  ARG    49      -3.420  20.778 -18.350  1.00 30.94           C  
ATOM    402  C   ARG    49      -2.065  21.091 -19.006  1.00 30.35           C  
ATOM    403  O   ARG    49      -1.009  20.856 -18.406  1.00 30.44           O  
ATOM    404  CB  ARG    49      -4.045  19.488 -18.920  1.00 30.61           C  
ATOM    405  CG  ARG    49      -3.149  18.233 -18.873  1.00 31.60           C  
ATOM    406  CD  ARG    49      -3.826  17.004 -19.546  1.00 34.32           C  
ATOM    407  NE  ARG    49      -4.109  17.268 -20.958  1.00 39.66           N  
ATOM    408  CZ  ARG    49      -5.158  16.807 -21.645  1.00 43.59           C  
ATOM    409  NH1 ARG    49      -5.287  17.135 -22.920  1.00 45.11           N  
ATOM    410  NH2 ARG    49      -6.084  16.029 -21.078  1.00 45.51           N  
ATOM    411  N   SER    50      -2.101  21.680 -20.210  1.00 30.07           N  
ATOM    412  CA  SER    50      -0.892  22.038 -20.951  1.00 31.54           C  
ATOM    413  C   SER    50      -0.062  23.098 -20.259  1.00 31.04           C  
ATOM    414  O   SER    50       1.149  23.188 -20.479  1.00 30.98           O  
ATOM    415  CB  SER    50      -1.277  22.565 -22.323  1.00 31.85           C  
ATOM    416  OG  SER    50      -1.782  21.515 -23.117  1.00 35.55           O  
ATOM    417  N   SER    51      -0.726  23.903 -19.430  1.00 30.50           N  
ATOM    418  CA  SER    51      -0.096  25.011 -18.723  0.50 30.66           C  
ATOM    420  C   SER    51       0.581  24.579 -17.419  1.00 30.93           C  
ATOM    421  O   SER    51       1.285  25.365 -16.798  1.00 31.22           O  
ATOM    422  CB  SER    51      -1.136  26.084 -18.412  0.50 30.43           C  
ATOM    424  OG  SER    51      -1.691  26.608 -19.599  0.50 30.15           O  
ATOM    426  N   ILE    52       0.358  23.332 -16.992  1.00 30.63           N  
ATOM    427  CA  ILE    52       0.962  22.825 -15.761  1.00 30.93           C  
ATOM    428  C   ILE    52       1.750  21.562 -16.111  1.00 31.45           C  
ATOM    429  O   ILE    52       1.195  20.460 -16.071  1.00 30.76           O  
ATOM    430  CB  ILE    52      -0.103  22.540 -14.635  1.00 30.84           C  
ATOM    431  CG1 ILE    52      -0.951  23.787 -14.375  1.00 31.83           C  
ATOM    432  CG2 ILE    52       0.588  22.082 -13.347  1.00 33.13           C  
ATOM    433  CD1 ILE    52      -2.186  23.546 -13.496  1.00 30.67           C  
ATOM    434  N   PRO    53       3.082  21.708 -16.248  0.50 32.17           N  
ATOM    436  CA  PRO    53       3.995  20.623 -16.611  0.50 32.18           C  
ATOM    438  C   PRO    53       3.709  19.347 -15.822  0.50 32.28           C  
ATOM    440  O   PRO    53       3.717  19.382 -14.589  0.50 32.32           O  
ATOM    442  CB  PRO    53       5.360  21.173 -16.185  0.50 32.32           C  
ATOM    444  CG  PRO    53       5.235  22.622 -16.320  0.50 32.43           C  
ATOM    446  CD  PRO    53       3.811  22.965 -15.984  0.50 31.62           C  
ATOM    448  N   GLY    54       3.447  18.225 -16.496  1.00 32.85           N  
ATOM    449  CA  GLY    54       3.374  17.000 -15.702  1.00 32.55           C  
ATOM    450  C   GLY    54       2.099  16.623 -14.957  1.00 31.92           C  
ATOM    451  O   GLY    54       2.011  15.492 -14.456  1.00 32.11           O  
ATOM    452  N   ILE    55       1.118  17.529 -14.849  1.00 30.84           N  
ATOM    453  CA  ILE    55      -0.154  17.165 -14.215  1.00 30.41           C  
ATOM    454  C   ILE    55      -0.915  16.120 -15.068  1.00 29.49           C  
ATOM    455  O   ILE    55      -0.989  16.260 -16.283  1.00 30.15           O  
ATOM    456  CB  ILE    55      -1.063  18.423 -13.944  1.00 29.10           C  
ATOM    457  CG1 ILE    55      -2.135  18.085 -12.899  1.00 29.13           C  
ATOM    458  CG2 ILE    55      -1.667  18.984 -15.247  1.00 29.74           C  
ATOM    459  CD1 ILE    55      -2.960  19.283 -12.328  1.00 31.94           C  
ATOM    460  N   SER    56      -1.463  15.079 -14.438  1.00 29.28           N  
ATOM    461  CA  SER    56      -2.278  14.092 -15.168  1.00 29.08           C  
ATOM    462  C   SER    56      -3.714  14.586 -15.333  1.00 28.45           C  
ATOM    463  O   SER    56      -4.179  15.450 -14.576  1.00 29.02           O  
ATOM    464  CB  SER    56      -2.299  12.746 -14.442  1.00 28.31           C  
ATOM    465  OG  SER    56      -2.957  12.908 -13.195  1.00 29.25           O  
ATOM    466  N   SER    57      -4.406  14.056 -16.344  1.00 28.29           N  
ATOM    467  CA  SER    57      -5.828  14.379 -16.512  1.00 29.38           C  
ATOM    468  C   SER    57      -6.598  13.995 -15.255  1.00 29.47           C  
ATOM    469  O   SER    57      -7.478  14.724 -14.829  1.00 30.03           O  
ATOM    470  CB  SER    57      -6.435  13.657 -17.706  1.00 30.29           C  
ATOM    471  OG  SER    57      -5.870  14.138 -18.902  1.00 32.01           O  
ATOM    472  N   THR    58      -6.284  12.829 -14.689  1.00 29.45           N  
ATOM    473  CA  THR    58      -6.990  12.360 -13.493  1.00 29.58           C  
ATOM    474  C   THR    58      -6.852  13.352 -12.330  1.00 29.16           C  
ATOM    475  O   THR    58      -7.844  13.700 -11.705  1.00 28.38           O  
ATOM    476  CB  THR    58      -6.582  10.923 -13.070  1.00 30.87           C  
ATOM    477  OG1 THR    58      -7.006   9.978 -14.073  1.00 30.95           O  
ATOM    478  CG2 THR    58      -7.222  10.541 -11.705  1.00 31.28           C  
ATOM    479  N   ILE    59      -5.627  13.765 -12.025  1.00 27.97           N  
ATOM    480  CA  ILE    59      -5.407  14.700 -10.912  1.00 29.61           C  
ATOM    481  C   ILE    59      -6.061  16.042 -11.228  1.00 29.82           C  
ATOM    482  O   ILE    59      -6.692  16.670 -10.357  1.00 29.80           O  
ATOM    483  CB  ILE    59      -3.881  14.856 -10.573  1.00 29.39           C  
ATOM    484  CG1 ILE    59      -3.316  13.496 -10.114  1.00 32.81           C  
ATOM    485  CG2 ILE    59      -3.632  16.061  -9.578  1.00 30.71           C  
ATOM    486  CD1 ILE    59      -3.982  12.929  -8.899  1.00 36.38           C  
ATOM    487  N   LEU    60      -5.922  16.507 -12.470  1.00 29.61           N  
ATOM    488  CA  LEU    60      -6.524  17.797 -12.820  1.00 28.72           C  
ATOM    489  C   LEU    60      -8.036  17.760 -12.640  1.00 29.13           C  
ATOM    490  O   LEU    60      -8.622  18.704 -12.099  1.00 29.42           O  
ATOM    491  CB  LEU    60      -6.157  18.260 -14.223  1.00 29.24           C  
ATOM    492  CG  LEU    60      -6.748  19.605 -14.712  1.00 28.18           C  
ATOM    493  CD1 LEU    60      -6.409  20.769 -13.803  1.00 29.10           C  
ATOM    494  CD2 LEU    60      -6.285  19.900 -16.141  1.00 29.94           C  
ATOM    495  N   SER    61      -8.653  16.682 -13.083  1.00 28.67           N  
ATOM    496  CA  SER    61     -10.114  16.544 -12.999  1.00 27.98           C  
ATOM    497  C   SER    61     -10.550  16.492 -11.516  1.00 28.84           C  
ATOM    498  O   SER    61     -11.545  17.126 -11.124  1.00 30.15           O  
ATOM    499  CB  SER    61     -10.545  15.269 -13.742  1.00 28.77           C  
ATOM    500  OG  SER    61     -11.943  15.111 -13.618  1.00 30.82           O  
ATOM    501  N   ARG    62      -9.804  15.751 -10.700  1.00 28.63           N  
ATOM    502  CA  ARG    62     -10.132  15.579  -9.274  0.50 29.99           C  
ATOM    504  C   ARG    62     -10.003  16.912  -8.545  1.00 29.34           C  
ATOM    505  O   ARG    62     -10.857  17.266  -7.723  1.00 29.15           O  
ATOM    506  CB  ARG    62      -9.247  14.513  -8.608  0.50 29.81           C  
ATOM    508  CG  ARG    62      -9.668  14.178  -7.172  0.50 31.40           C  
ATOM    510  CD  ARG    62      -8.791  13.120  -6.495  0.50 31.62           C  
ATOM    512  NE  ARG    62      -8.467  13.515  -5.124  0.50 36.53           N  
ATOM    514  CZ  ARG    62      -7.951  12.730  -4.183  0.50 36.11           C  
ATOM    516  NH1 ARG    62      -7.698  11.442  -4.416  0.50 37.63           N  
ATOM    518  NH2 ARG    62      -7.692  13.248  -2.987  0.50 37.15           N  
ATOM    520  N   ARG    63      -8.941  17.663  -8.858  1.00 28.62           N  
ATOM    521  CA  ARG    63      -8.761  18.974  -8.210  1.00 29.17           C  
ATOM    522  C   ARG    63      -9.802  20.015  -8.647  1.00 28.84           C  
ATOM    523  O   ARG    63     -10.327  20.781  -7.819  1.00 28.65           O  
ATOM    524  CB  ARG    63      -7.359  19.560  -8.460  1.00 29.44           C  
ATOM    525  CG  ARG    63      -6.226  18.768  -7.890  1.00 30.90           C  
ATOM    526  CD  ARG    63      -6.146  18.743  -6.379  1.00 33.16           C  
ATOM    527  NE  ARG    63      -4.832  18.204  -6.097  1.00 37.27           N  
ATOM    528  CZ  ARG    63      -4.595  16.895  -5.971  1.00 37.04           C  
ATOM    529  NH1 ARG    63      -5.614  16.023  -5.998  1.00 37.29           N  
ATOM    530  NH2 ARG    63      -3.363  16.461  -5.783  1.00 36.96           N  
ATOM    531  N   ILE    64     -10.151  19.980  -9.933  1.00 29.26           N  
ATOM    532  CA  ILE    64     -11.184  20.856 -10.463  1.00 30.51           C  
ATOM    533  C   ILE    64     -12.504  20.549  -9.741  1.00 30.34           C  
ATOM    534  O   ILE    64     -13.196  21.480  -9.345  1.00 30.98           O  
ATOM    535  CB  ILE    64     -11.290  20.731 -12.003  1.00 30.62           C  
ATOM    536  CG1 ILE    64     -10.127  21.548 -12.614  1.00 30.31           C  
ATOM    537  CG2 ILE    64     -12.675  21.243 -12.495  1.00 31.48           C  
ATOM    538  CD1 ILE    64     -10.156  21.630 -14.161  1.00 32.83           C  
ATOM    539  N   LYS    65     -12.838  19.279  -9.553  1.00 30.75           N  
ATOM    540  CA  LYS    65     -14.099  18.954  -8.873  1.00 30.94           C  
ATOM    541  C   LYS    65     -14.073  19.525  -7.445  1.00 30.64           C  
ATOM    542  O   LYS    65     -15.081  20.079  -6.977  1.00 30.81           O  
ATOM    543  CB  LYS    65     -14.299  17.457  -8.818  1.00 31.13           C  
ATOM    544  CG  LYS    65     -15.503  17.061  -8.007  1.00 33.76           C  
ATOM    545  CD  LYS    65     -15.587  15.568  -7.851  1.00 38.55           C  
ATOM    546  CE  LYS    65     -16.586  15.242  -6.746  1.00 40.18           C  
ATOM    547  NZ  LYS    65     -17.892  15.885  -7.064  1.00 43.76           N  
ATOM    548  N   ASP    66     -12.931  19.398  -6.765  1.00 29.42           N  
ATOM    549  CA  ASP    66     -12.878  19.802  -5.360  1.00 29.50           C  
ATOM    550  C   ASP    66     -12.978  21.320  -5.356  1.00 28.62           C  
ATOM    551  O   ASP    66     -13.574  21.903  -4.442  1.00 28.98           O  
ATOM    552  CB  ASP    66     -11.568  19.384  -4.683  1.00 30.07           C  
ATOM    553  CG  ASP    66     -11.473  17.900  -4.419  1.00 34.15           C  
ATOM    554  OD1 ASP    66     -12.523  17.216  -4.358  1.00 36.32           O  
ATOM    555  OD2 ASP    66     -10.306  17.461  -4.241  1.00 37.95           O  
ATOM    556  N   LEU    67     -12.352  21.941  -6.358  1.00 28.40           N  
ATOM    557  CA  LEU    67     -12.398  23.406  -6.450  1.00 26.03           C  
ATOM    558  C   LEU    67     -13.796  23.953  -6.748  1.00 27.98           C  
ATOM    559  O   LEU    67     -14.183  25.012  -6.231  1.00 28.27           O  
ATOM    560  CB  LEU    67     -11.369  23.956  -7.460  1.00 27.42           C  
ATOM    561  CG  LEU    67      -9.912  23.918  -7.004  1.00 26.45           C  
ATOM    562  CD1 LEU    67      -8.964  24.037  -8.262  1.00 26.39           C  
ATOM    563  CD2 LEU    67      -9.529  24.911  -5.930  1.00 28.59           C  
ATOM    564  N   ILE    68     -14.528  23.250  -7.605  1.00 27.87           N  
ATOM    565  CA  ILE    68     -15.940  23.586  -7.890  1.00 28.22           C  
ATOM    566  C   ILE    68     -16.769  23.403  -6.601  1.00 28.92           C  
ATOM    567  O   ILE    68     -17.548  24.276  -6.211  1.00 28.86           O  
ATOM    568  CB  ILE    68     -16.476  22.704  -9.021  1.00 27.86           C  
ATOM    569  CG1 ILE    68     -15.802  23.072 -10.349  1.00 28.61           C  
ATOM    570  CG2 ILE    68     -18.028  22.831  -9.113  1.00 27.84           C  
ATOM    571  CD1 ILE    68     -16.125  22.075 -11.499  1.00 28.47           C  
ATOM    572  N   ASP    69     -16.594  22.272  -5.938  1.00 28.29           N  
ATOM    573  CA  ASP    69     -17.330  21.994  -4.694  1.00 30.66           C  
ATOM    574  C   ASP    69     -17.075  23.052  -3.605  1.00 30.59           C  
ATOM    575  O   ASP    69     -17.985  23.383  -2.830  1.00 30.51           O  
ATOM    576  CB  ASP    69     -17.027  20.579  -4.213  1.00 31.59           C  
ATOM    577  CG  ASP    69     -17.624  19.495  -5.126  1.00 36.35           C  
ATOM    578  OD1 ASP    69     -18.394  19.819  -6.069  1.00 40.91           O  
ATOM    579  OD2 ASP    69     -17.328  18.310  -4.891  1.00 39.91           O  
ATOM    580  N   SER    70     -15.853  23.586  -3.572  1.00 29.87           N  
ATOM    581  CA  SER    70     -15.437  24.584  -2.588  0.50 30.17           C  
ATOM    583  C   SER    70     -15.789  26.016  -2.991  1.00 30.20           C  
ATOM    584  O   SER    70     -15.532  26.952  -2.232  1.00 30.92           O  
ATOM    585  CB  SER    70     -13.943  24.429  -2.284  0.50 30.09           C  
ATOM    587  OG  SER    70     -13.709  23.157  -1.691  0.50 30.21           O  
ATOM    589  N   GLY    71     -16.394  26.165  -4.179  1.00 29.53           N  
ATOM    590  CA  GLY    71     -16.882  27.465  -4.672  1.00 29.80           C  
ATOM    591  C   GLY    71     -15.812  28.391  -5.225  1.00 29.21           C  
ATOM    592  O   GLY    71     -16.036  29.606  -5.344  1.00 30.11           O  
ATOM    593  N   LEU    72     -14.640  27.843  -5.539  1.00 29.88           N  
ATOM    594  CA  LEU    72     -13.531  28.642  -6.076  1.00 27.91           C  
ATOM    595  C   LEU    72     -13.447  28.627  -7.607  1.00 29.19           C  
ATOM    596  O   LEU    72     -12.812  29.516  -8.183  1.00 29.94           O  
ATOM    597  CB  LEU    72     -12.163  28.156  -5.486  1.00 28.59           C  
ATOM    598  CG  LEU    72     -12.171  28.194  -3.931  1.00 26.72           C  
ATOM    599  CD1 LEU    72     -10.820  27.769  -3.470  1.00 30.74           C  
ATOM    600  CD2 LEU    72     -12.484  29.610  -3.415  1.00 28.81           C  
ATOM    601  N   VAL    73     -14.018  27.598  -8.242  1.00 29.25           N  
ATOM    602  CA  VAL    73     -13.976  27.432  -9.732  1.00 28.03           C  
ATOM    603  C   VAL    73     -15.383  27.076 -10.215  1.00 28.87           C  
ATOM    604  O   VAL    73     -16.167  26.488  -9.479  1.00 28.62           O  
ATOM    605  CB  VAL    73     -12.975  26.327 -10.078  1.00 28.54           C  
ATOM    606  CG1 VAL    73     -13.062  25.848 -11.565  1.00 29.42           C  
ATOM    607  CG2 VAL    73     -11.558  26.814  -9.766  1.00 28.41           C  
ATOM    608  N   GLU    74     -15.715  27.487 -11.438  1.00 28.71           N  
ATOM    609  CA  GLU    74     -16.949  27.008 -12.060  1.00 29.45           C  
ATOM    610  C   GLU    74     -16.650  26.532 -13.474  1.00 31.15           C  
ATOM    611  O   GLU    74     -15.697  27.033 -14.142  1.00 29.70           O  
ATOM    612  CB  GLU    74     -18.030  28.096 -12.043  1.00 30.64           C  
ATOM    613  CG  GLU    74     -17.544  29.452 -12.480  1.00 35.69           C  
ATOM    614  CD  GLU    74     -17.767  29.745 -13.959  1.00 43.35           C  
ATOM    615  OE1 GLU    74     -17.538  30.908 -14.348  1.00 42.21           O  
ATOM    616  OE2 GLU    74     -18.184  28.825 -14.717  1.00 46.17           O  
ATOM    617  N   ARG    75     -17.435  25.533 -13.904  1.00 29.67           N  
ATOM    618  CA  ARG    75     -17.367  24.986 -15.271  1.00 30.13           C  
ATOM    619  C   ARG    75     -18.541  25.565 -16.078  1.00 30.14           C  
ATOM    620  O   ARG    75     -19.672  25.598 -15.587  1.00 30.30           O  
ATOM    621  CB  ARG    75     -17.453  23.453 -15.230  1.00 31.80           C  
ATOM    622  CG  ARG    75     -17.545  22.772 -16.614  1.00 31.36           C  
ATOM    623  CD  ARG    75     -17.947  21.238 -16.501  1.00 32.95           C  
ATOM    624  NE  ARG    75     -16.903  20.561 -15.799  1.00 37.99           N  
ATOM    625  CZ  ARG    75     -17.011  20.103 -14.558  1.00 41.51           C  
ATOM    626  NH1 ARG    75     -15.955  19.524 -13.989  1.00 38.82           N  
ATOM    627  NH2 ARG    75     -18.156  20.254 -13.891  1.00 42.15           N  
ATOM    628  N   ARG    76     -18.256  26.059 -17.286  1.00 28.92           N  
ATOM    629  CA  ARG    76     -19.335  26.418 -18.189  1.00 29.77           C  
ATOM    630  C   ARG    76     -19.443  25.379 -19.284  1.00 28.36           C  
ATOM    631  O   ARG    76     -18.472  25.191 -19.986  1.00 28.53           O  
ATOM    632  CB  ARG    76     -19.014  27.759 -18.849  1.00 30.56           C  
ATOM    633  CG  ARG    76     -20.132  28.268 -19.753  1.00 32.27           C  
ATOM    634  CD  ARG    76     -19.709  29.566 -20.461  1.00 31.81           C  
ATOM    635  NE  ARG    76     -20.762  30.087 -21.329  1.00 35.20           N  
ATOM    636  CZ  ARG    76     -20.930  29.732 -22.607  1.00 36.59           C  
ATOM    637  NH1 ARG    76     -20.085  28.872 -23.182  1.00 38.21           N  
ATOM    638  NH2 ARG    76     -21.934  30.246 -23.323  1.00 33.02           N  
ATOM    639  N   SER    77     -20.602  24.744 -19.459  1.00 28.58           N  
ATOM    640  CA  SER    77     -20.793  23.830 -20.561  1.00 28.95           C  
ATOM    641  C   SER    77     -21.573  24.569 -21.627  1.00 28.76           C  
ATOM    642  O   SER    77     -22.773  24.848 -21.455  1.00 28.16           O  
ATOM    643  CB  SER    77     -21.593  22.567 -20.165  1.00 30.53           C  
ATOM    644  OG  SER    77     -21.065  21.915 -19.027  1.00 35.64           O  
ATOM    645  N   GLY    78     -20.872  24.945 -22.693  1.00 29.21           N  
ATOM    646  CA  GLY    78     -21.482  25.588 -23.853  1.00 28.28           C  
ATOM    647  C   GLY    78     -21.171  24.726 -25.077  1.00 29.02           C  
ATOM    648  O   GLY    78     -21.147  23.505 -25.000  1.00 28.84           O  
ATOM    649  N   GLN    79     -20.948  25.342 -26.225  1.00 27.77           N  
ATOM    650  CA  GLN    79     -20.537  24.548 -27.377  1.00 27.63           C  
ATOM    651  C   GLN    79     -19.154  23.969 -27.103  1.00 28.99           C  
ATOM    652  O   GLN    79     -18.795  22.934 -27.680  1.00 29.21           O  
ATOM    653  CB  GLN    79     -20.566  25.381 -28.641  1.00 27.27           C  
ATOM    654  CG  GLN    79     -21.998  25.699 -29.015  1.00 26.64           C  
ATOM    655  CD  GLN    79     -22.134  26.542 -30.255  1.00 28.25           C  
ATOM    656  OE1 GLN    79     -21.501  27.589 -30.389  1.00 32.85           O  
ATOM    657  NE2 GLN    79     -22.982  26.116 -31.146  1.00 29.95           N  
ATOM    658  N   ILE    80     -18.384  24.656 -26.263  1.00 27.96           N  
ATOM    659  CA  ILE    80     -17.164  24.076 -25.650  1.00 29.86           C  
ATOM    660  C   ILE    80     -17.307  24.171 -24.130  1.00 29.27           C  
ATOM    661  O   ILE    80     -18.156  24.927 -23.647  1.00 30.11           O  
ATOM    662  CB  ILE    80     -15.864  24.780 -26.129  1.00 28.85           C  
ATOM    663  CG1 ILE    80     -15.856  26.261 -25.702  1.00 32.17           C  
ATOM    664  CG2 ILE    80     -15.718  24.643 -27.669  1.00 31.06           C  
ATOM    665  CD1 ILE    80     -14.545  27.043 -26.035  1.00 33.47           C  
ATOM    666  N   THR    81     -16.510  23.384 -23.403  1.00 28.43           N  
ATOM    667  CA  THR    81     -16.523  23.384 -21.939  1.00 28.22           C  
ATOM    668  C   THR    81     -15.289  24.116 -21.452  1.00 28.52           C  
ATOM    669  O   THR    81     -14.147  23.787 -21.846  1.00 28.61           O  
ATOM    670  CB  THR    81     -16.507  21.956 -21.396  1.00 28.75           C  
ATOM    671  OG1 THR    81     -17.690  21.294 -21.859  1.00 31.34           O  
ATOM    672  CG2 THR    81     -16.522  21.955 -19.869  1.00 31.08           C  
ATOM    673  N   THR    82     -15.511  25.118 -20.609  1.00 28.37           N  
ATOM    674  CA  THR    82     -14.420  25.966 -20.131  1.00 28.26           C  
ATOM    675  C   THR    82     -14.554  26.187 -18.621  1.00 28.32           C  
ATOM    676  O   THR    82     -15.614  25.907 -18.059  1.00 28.07           O  
ATOM    677  CB  THR    82     -14.405  27.336 -20.844  1.00 29.29           C  
ATOM    678  OG1 THR    82     -15.659  27.982 -20.635  1.00 29.38           O  
ATOM    679  CG2 THR    82     -14.132  27.169 -22.361  1.00 28.94           C  
ATOM    680  N   TYR    83     -13.491  26.716 -18.007  1.00 29.04           N  
ATOM    681  CA  TYR    83     -13.385  26.842 -16.558  1.00 29.15           C  
ATOM    682  C   TYR    83     -12.886  28.258 -16.250  1.00 29.55           C  
ATOM    683  O   TYR    83     -12.141  28.869 -17.020  1.00 29.25           O  
ATOM    684  CB  TYR    83     -12.394  25.778 -16.021  1.00 29.63           C  
ATOM    685  CG  TYR    83     -12.761  24.318 -16.395  1.00 30.27           C  
ATOM    686  CD1 TYR    83     -13.449  23.507 -15.494  1.00 31.09           C  
ATOM    687  CD2 TYR    83     -12.454  23.785 -17.656  1.00 30.34           C  
ATOM    688  CE1 TYR    83     -13.815  22.160 -15.849  1.00 31.37           C  
ATOM    689  CE2 TYR    83     -12.820  22.456 -18.012  1.00 31.96           C  
ATOM    690  CZ  TYR    83     -13.499  21.681 -17.099  1.00 31.74           C  
ATOM    691  OH  TYR    83     -13.848  20.397 -17.475  1.00 34.84           O  
ATOM    692  N   ALA    84     -13.306  28.758 -15.102  1.00 30.07           N  
ATOM    693  CA  ALA    84     -12.898  30.065 -14.658  1.00 29.00           C  
ATOM    694  C   ALA    84     -12.974  30.097 -13.138  1.00 29.39           C  
ATOM    695  O   ALA    84     -13.731  29.355 -12.503  1.00 28.04           O  
ATOM    696  CB  ALA    84     -13.828  31.155 -15.236  1.00 30.87           C  
ATOM    697  N   LEU    85     -12.208  31.004 -12.562  1.00 27.83           N  
ATOM    698  CA  LEU    85     -12.313  31.261 -11.129  1.00 28.72           C  
ATOM    699  C   LEU    85     -13.618  32.020 -10.833  1.00 28.37           C  
ATOM    700  O   LEU    85     -14.051  32.924 -11.592  1.00 29.93           O  
ATOM    701  CB  LEU    85     -11.128  32.118 -10.707  1.00 29.13           C  
ATOM    702  CG  LEU    85      -9.774  31.409 -10.790  1.00 29.42           C  
ATOM    703  CD1 LEU    85      -8.737  32.458 -10.474  1.00 30.83           C  
ATOM    704  CD2 LEU    85      -9.702  30.240  -9.791  1.00 32.79           C  
ATOM    705  N   THR    86     -14.234  31.677  -9.709  1.00 28.05           N  
ATOM    706  CA  THR    86     -15.306  32.493  -9.150  1.00 29.08           C  
ATOM    707  C   THR    86     -14.710  33.730  -8.469  1.00 28.70           C  
ATOM    708  O   THR    86     -13.473  33.872  -8.366  1.00 28.56           O  
ATOM    709  CB  THR    86     -16.066  31.686  -8.083  1.00 28.31           C  
ATOM    710  OG1 THR    86     -15.160  31.412  -7.011  1.00 28.09           O  
ATOM    711  CG2 THR    86     -16.670  30.391  -8.671  1.00 29.71           C  
ATOM    712  N   GLU    87     -15.565  34.643  -7.995  1.00 28.48           N  
ATOM    713  CA  GLU    87     -15.087  35.783  -7.197  1.00 28.21           C  
ATOM    714  C   GLU    87     -14.224  35.303  -6.039  1.00 27.98           C  
ATOM    715  O   GLU    87     -13.143  35.843  -5.801  1.00 28.08           O  
ATOM    716  CB  GLU    87     -16.260  36.608  -6.654  1.00 28.97           C  
ATOM    717  CG  GLU    87     -15.795  37.776  -5.817  1.00 32.03           C  
ATOM    718  CD  GLU    87     -16.834  38.866  -5.668  1.00 37.40           C  
ATOM    719  OE1 GLU    87     -17.999  38.681  -6.105  1.00 39.68           O  
ATOM    720  OE2 GLU    87     -16.472  39.919  -5.102  1.00 40.80           O  
ATOM    721  N   LYS    88     -14.678  34.267  -5.336  1.00 26.90           N  
ATOM    722  CA  LYS    88     -13.841  33.696  -4.236  1.00 27.64           C  
ATOM    723  C   LYS    88     -12.505  33.134  -4.735  1.00 27.48           C  
ATOM    724  O   LYS    88     -11.465  33.369  -4.095  1.00 28.05           O  
ATOM    725  CB  LYS    88     -14.587  32.639  -3.428  1.00 26.47           C  
ATOM    726  CG  LYS    88     -15.766  33.197  -2.592  1.00 29.97           C  
ATOM    727  CD  LYS    88     -16.520  32.055  -1.986  1.00 31.77           C  
ATOM    728  CE  LYS    88     -17.639  32.571  -1.077  1.00 34.52           C  
ATOM    729  NZ  LYS    88     -18.530  31.437  -0.636  1.00 37.09           N  
ATOM    730  N   GLY    89     -12.521  32.417  -5.859  1.00 27.29           N  
ATOM    731  CA  GLY    89     -11.278  31.833  -6.408  1.00 27.82           C  
ATOM    732  C   GLY    89     -10.300  32.939  -6.789  1.00 27.71           C  
ATOM    733  O   GLY    89      -9.070  32.813  -6.559  1.00 26.30           O  
ATOM    734  N   MET    90     -10.832  34.020  -7.352  1.00 28.52           N  
ATOM    735  CA  MET    90      -9.968  35.159  -7.726  1.00 29.23           C  
ATOM    736  C   MET    90      -9.369  35.854  -6.476  1.00 29.18           C  
ATOM    737  O   MET    90      -8.189  36.250  -6.463  1.00 28.95           O  
ATOM    738  CB  MET    90     -10.714  36.183  -8.595  1.00 30.36           C  
ATOM    739  CG  MET    90      -9.775  37.308  -9.095  1.00 32.97           C  
ATOM    740  SD  MET    90      -8.279  36.659 -10.240  0.55 36.03          SE  
ATOM    741  CE  MET    90      -9.351  35.987 -11.693  1.00 35.53           C  
ATOM    742  N   ASN    91     -10.150  35.940  -5.409  1.00 28.62           N  
ATOM    743  CA  ASN    91      -9.609  36.407  -4.128  1.00 28.64           C  
ATOM    744  C   ASN    91      -8.476  35.527  -3.605  1.00 27.84           C  
ATOM    745  O   ASN    91      -7.444  36.019  -3.139  1.00 27.84           O  
ATOM    746  CB  ASN    91     -10.720  36.491  -3.084  1.00 29.00           C  
ATOM    747  CG  ASN    91     -11.716  37.587  -3.386  1.00 29.45           C  
ATOM    748  OD1 ASN    91     -11.392  38.575  -4.056  1.00 27.66           O  
ATOM    749  ND2 ASN    91     -12.930  37.423  -2.905  1.00 28.75           N  
ATOM    750  N   VAL    92      -8.668  34.219  -3.635  1.00 27.04           N  
ATOM    751  CA  VAL    92      -7.552  33.325  -3.311  1.00 28.12           C  
ATOM    752  C   VAL    92      -6.323  33.601  -4.207  1.00 27.67           C  
ATOM    753  O   VAL    92      -5.209  33.665  -3.716  1.00 26.90           O  
ATOM    754  CB  VAL    92      -7.997  31.843  -3.442  1.00 28.20           C  
ATOM    755  CG1 VAL    92      -6.780  30.843  -3.275  1.00 27.42           C  
ATOM    756  CG2 VAL    92      -9.135  31.524  -2.399  1.00 30.21           C  
ATOM    757  N   ARG    93      -6.548  33.772  -5.506  1.00 28.09           N  
ATOM    758  CA  ARG    93      -5.422  33.888  -6.432  1.00 28.32           C  
ATOM    759  C   ARG    93      -4.688  35.143  -6.068  1.00 27.74           C  
ATOM    760  O   ARG    93      -3.454  35.180  -6.049  1.00 27.95           O  
ATOM    761  CB  ARG    93      -5.888  33.967  -7.868  1.00 28.07           C  
ATOM    762  CG  ARG    93      -4.693  33.906  -8.838  1.00 25.86           C  
ATOM    763  CD  ARG    93      -5.157  34.048 -10.247  1.00 26.49           C  
ATOM    764  NE  ARG    93      -4.120  33.795 -11.241  1.00 28.18           N  
ATOM    765  CZ  ARG    93      -3.202  34.673 -11.649  1.00 29.31           C  
ATOM    766  NH1 ARG    93      -2.287  34.306 -12.557  1.00 25.94           N  
ATOM    767  NH2 ARG    93      -3.198  35.916 -11.166  1.00 26.86           N  
ATOM    768  N   ASN    94      -5.459  36.176  -5.767  1.00 28.92           N  
ATOM    769  CA  ASN    94      -4.886  37.494  -5.404  1.00 29.99           C  
ATOM    770  C   ASN    94      -3.915  37.371  -4.211  1.00 32.12           C  
ATOM    771  O   ASN    94      -2.841  37.961  -4.232  1.00 31.33           O  
ATOM    772  CB  ASN    94      -5.971  38.543  -5.091  1.00 30.37           C  
ATOM    773  CG  ASN    94      -6.675  39.043  -6.340  1.00 32.67           C  
ATOM    774  OD1 ASN    94      -6.194  38.840  -7.464  1.00 32.25           O  
ATOM    775  ND2 ASN    94      -7.838  39.681  -6.155  1.00 32.87           N  
ATOM    776  N   SER    95      -4.292  36.604  -3.190  1.00 32.21           N  
ATOM    777  CA  SER    95      -3.400  36.395  -2.041  0.50 33.67           C  
ATOM    779  C   SER    95      -2.286  35.405  -2.316  1.00 33.56           C  
ATOM    780  O   SER    95      -1.258  35.427  -1.651  1.00 35.19           O  
ATOM    781  CB  SER    95      -4.179  35.979  -0.796  0.50 33.85           C  
ATOM    783  OG  SER    95      -5.282  36.826  -0.602  0.50 34.68           O  
ATOM    785  N   LEU    96      -2.471  34.542  -3.311  1.00 32.37           N  
ATOM    786  CA  LEU    96      -1.491  33.550  -3.647  1.00 32.67           C  
ATOM    787  C   LEU    96      -0.295  34.105  -4.388  1.00 30.83           C  
ATOM    788  O   LEU    96       0.820  33.633  -4.159  1.00 30.82           O  
ATOM    789  CB  LEU    96      -2.157  32.477  -4.517  1.00 33.56           C  
ATOM    790  CG  LEU    96      -1.710  31.050  -4.639  1.00 38.72           C  
ATOM    791  CD1 LEU    96      -1.362  30.451  -3.239  1.00 35.81           C  
ATOM    792  CD2 LEU    96      -2.842  30.238  -5.358  1.00 34.93           C  
ATOM    793  N   MET    97      -0.504  35.093  -5.271  1.00 30.72           N  
ATOM    794  CA  MET    97       0.573  35.499  -6.198  1.00 30.72           C  
ATOM    795  C   MET    97       1.842  36.013  -5.490  1.00 29.84           C  
ATOM    796  O   MET    97       2.933  35.641  -5.896  1.00 30.74           O  
ATOM    797  CB  MET    97       0.075  36.444  -7.294  1.00 31.52           C  
ATOM    798  CG  MET    97      -1.008  35.843  -8.209  1.00 34.65           C  
ATOM    799  SD  MET    97      -0.818  33.923  -8.692  0.70 44.93          SE  
ATOM    800  CE  MET    97       0.709  34.110  -9.778  1.00 41.24           C  
ATOM    801  N   PRO    98       1.715  36.844  -4.434  1.00 29.05           N  
ATOM    802  CA  PRO    98       2.974  37.244  -3.779  1.00 29.62           C  
ATOM    803  C   PRO    98       3.757  36.083  -3.167  1.00 29.38           C  
ATOM    804  O   PRO    98       5.012  36.095  -3.173  1.00 28.71           O  
ATOM    805  CB  PRO    98       2.511  38.270  -2.724  1.00 27.95           C  
ATOM    806  CG  PRO    98       1.158  38.780  -3.240  1.00 29.52           C  
ATOM    807  CD  PRO    98       0.549  37.499  -3.812  1.00 28.86           C  
ATOM    808  N   LEU    99       3.042  35.062  -2.695  1.00 29.20           N  
ATOM    809  CA  LEU    99       3.663  33.870  -2.139  1.00 29.63           C  
ATOM    810  C   LEU    99       4.396  33.115  -3.247  1.00 28.97           C  
ATOM    811  O   LEU    99       5.587  32.776  -3.087  1.00 29.73           O  
ATOM    812  CB  LEU    99       2.619  32.977  -1.497  1.00 29.90           C  
ATOM    813  CG  LEU    99       3.168  31.683  -0.942  1.00 31.39           C  
ATOM    814  CD1 LEU    99       4.202  31.905   0.205  1.00 30.66           C  
ATOM    815  CD2 LEU    99       1.990  30.860  -0.502  1.00 31.76           C  
ATOM    816  N   LEU   100       3.718  32.889  -4.374  1.00 28.17           N  
ATOM    817  CA  LEU   100       4.364  32.230  -5.503  1.00 28.95           C  
ATOM    818  C   LEU   100       5.550  33.020  -6.085  1.00 27.53           C  
ATOM    819  O   LEU   100       6.573  32.418  -6.447  1.00 27.72           O  
ATOM    820  CB  LEU   100       3.347  31.799  -6.572  1.00 29.88           C  
ATOM    821  CG  LEU   100       2.325  30.758  -6.059  1.00 31.71           C  
ATOM    822  CD1 LEU   100       1.399  30.347  -7.205  1.00 34.06           C  
ATOM    823  CD2 LEU   100       2.939  29.510  -5.392  1.00 35.43           C  
ATOM    824  N   GLN   101       5.420  34.352  -6.171  1.00 28.07           N  
ATOM    825  CA  GLN   101       6.504  35.194  -6.585  1.00 28.02           C  
ATOM    826  C   GLN   101       7.722  34.903  -5.698  1.00 28.41           C  
ATOM    827  O   GLN   101       8.818  34.657  -6.213  1.00 27.55           O  
ATOM    828  CB  GLN   101       6.085  36.661  -6.502  1.00 27.70           C  
ATOM    829  CG  GLN   101       7.155  37.657  -6.935  1.00 29.75           C  
ATOM    830  CD  GLN   101       6.627  39.072  -6.900  1.00 36.26           C  
ATOM    831  OE1 GLN   101       6.218  39.568  -5.838  1.00 39.47           O  
ATOM    832  NE2 GLN   101       6.614  39.734  -8.055  1.00 36.49           N  
ATOM    833  N   TYR   102       7.514  34.893  -4.378  1.00 27.05           N  
ATOM    834  CA  TYR   102       8.673  34.752  -3.497  1.00 27.21           C  
ATOM    835  C   TYR   102       9.243  33.344  -3.614  1.00 26.42           C  
ATOM    836  O   TYR   102      10.452  33.175  -3.617  1.00 27.13           O  
ATOM    837  CB  TYR   102       8.385  35.071  -2.044  1.00 27.35           C  
ATOM    838  CG  TYR   102       9.672  35.078  -1.243  1.00 26.25           C  
ATOM    839  CD1 TYR   102      10.720  35.926  -1.593  1.00 27.25           C  
ATOM    840  CD2 TYR   102       9.847  34.246  -0.138  1.00 25.54           C  
ATOM    841  CE1 TYR   102      11.924  35.953  -0.874  1.00 26.32           C  
ATOM    842  CE2 TYR   102      11.059  34.260   0.587  1.00 24.84           C  
ATOM    843  CZ  TYR   102      12.074  35.112   0.230  1.00 26.75           C  
ATOM    844  OH  TYR   102      13.270  35.165   0.933  1.00 25.91           O  
ATOM    845  N   ILE   103       8.378  32.346  -3.722  1.00 27.50           N  
ATOM    846  CA  ILE   103       8.813  30.981  -3.992  1.00 27.88           C  
ATOM    847  C   ILE   103       9.731  30.908  -5.220  1.00 27.65           C  
ATOM    848  O   ILE   103      10.751  30.201  -5.192  1.00 27.73           O  
ATOM    849  CB  ILE   103       7.617  30.032  -4.134  1.00 29.23           C  
ATOM    850  CG1 ILE   103       7.016  29.788  -2.747  1.00 30.88           C  
ATOM    851  CG2 ILE   103       8.035  28.692  -4.718  1.00 28.51           C  
ATOM    852  CD1 ILE   103       5.732  28.980  -2.795  1.00 33.46           C  
ATOM    853  N   SER   104       9.378  31.624  -6.282  1.00 27.79           N  
ATOM    854  CA  SER   104      10.196  31.587  -7.481  0.50 27.34           C  
ATOM    856  C   SER   104      11.574  32.157  -7.178  1.00 27.49           C  
ATOM    857  O   SER   104      12.578  31.651  -7.696  1.00 28.21           O  
ATOM    858  CB  SER   104       9.517  32.288  -8.666  0.50 27.70           C  
ATOM    860  OG  SER   104       9.297  33.653  -8.404  0.50 26.64           O  
ATOM    862  N   VAL   105      11.633  33.198  -6.338  1.00 27.35           N  
ATOM    863  CA  VAL   105      12.917  33.788  -5.913  1.00 28.27           C  
ATOM    864  C   VAL   105      13.727  32.746  -5.132  1.00 27.87           C  
ATOM    865  O   VAL   105      14.911  32.534  -5.409  1.00 28.29           O  
ATOM    866  CB  VAL   105      12.712  35.069  -5.063  1.00 28.99           C  
ATOM    867  CG1 VAL   105      14.037  35.535  -4.379  1.00 28.92           C  
ATOM    868  CG2 VAL   105      12.092  36.197  -5.908  1.00 29.40           C  
ATOM    869  N   LEU   106      13.102  32.109  -4.153  1.00 27.98           N  
ATOM    870  CA  LEU   106      13.769  31.016  -3.414  1.00 29.11           C  
ATOM    871  C   LEU   106      14.298  29.896  -4.309  1.00 29.49           C  
ATOM    872  O   LEU   106      15.409  29.399  -4.086  1.00 28.40           O  
ATOM    873  CB  LEU   106      12.844  30.436  -2.360  1.00 29.16           C  
ATOM    874  CG  LEU   106      12.443  31.332  -1.195  1.00 28.98           C  
ATOM    875  CD1 LEU   106      11.364  30.598  -0.405  1.00 27.21           C  
ATOM    876  CD2 LEU   106      13.592  31.655  -0.283  1.00 28.46           C  
ATOM    877  N   ASP   107      13.530  29.522  -5.329  1.00 30.00           N  
ATOM    878  CA  ASP   107      13.912  28.437  -6.238  1.00 31.31           C  
ATOM    879  C   ASP   107      15.183  28.744  -7.021  1.00 32.94           C  
ATOM    880  O   ASP   107      15.879  27.832  -7.457  1.00 32.77           O  
ATOM    881  CB  ASP   107      12.767  28.129  -7.204  1.00 30.81           C  
ATOM    882  CG  ASP   107      11.600  27.426  -6.519  1.00 31.73           C  
ATOM    883  OD1 ASP   107      11.808  26.861  -5.409  1.00 32.85           O  
ATOM    884  OD2 ASP   107      10.497  27.412  -7.108  1.00 30.11           O  
ATOM    885  N   ARG   108      15.483  30.027  -7.165  1.00 35.82           N  
ATOM    886  CA  ARG   108      16.714  30.471  -7.828  1.00 38.32           C  
ATOM    887  C   ARG   108      17.910  30.455  -6.873  1.00 40.36           C  
ATOM    888  O   ARG   108      19.070  30.499  -7.313  1.00 41.27           O  
ATOM    889  CB  ARG   108      16.532  31.880  -8.395  1.00 38.71           C  
ATOM    890  CG  ARG   108      15.484  32.018  -9.490  1.00 39.12           C  
ATOM    891  CD  ARG   108      15.947  31.500 -10.868  1.00 41.50           C  
ATOM    892  NE  ARG   108      17.379  31.658 -11.134  1.00 39.33           N  
ATOM    893  CZ  ARG   108      17.954  32.744 -11.656  1.00 40.78           C  
ATOM    894  NH1 ARG   108      17.234  33.825 -11.957  1.00 39.73           N  
ATOM    895  NH2 ARG   108      19.265  32.753 -11.862  1.00 39.54           N  
ATOM    896  N   ASN   109      17.609  30.383  -5.574  1.00 42.89           N  
ATOM    897  CA  ASN   109      18.561  30.416  -4.447  1.00 44.82           C  
ATOM    898  C   ASN   109      18.725  31.803  -3.828  1.00 45.47           C  
ATOM    899  O   ASN   109      19.574  32.596  -4.253  1.00 46.71           O  
ATOM    900  CB  ASN   109      19.923  29.793  -4.797  1.00 45.67           C  
ATOM    901  CG  ASN   109      20.027  28.329  -4.385  1.00 47.92           C  
ATOM    902  OD1 ASN   109      21.107  27.860  -4.009  1.00 50.81           O  
ATOM    903  ND2 ASN   109      18.912  27.600  -4.455  1.00 49.19           N  
END
