
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  140 ( 1132),  selected  140 , name 3bro_B
# Molecule2: number of CA atoms  109 (  848),  selected  109 , name T0459.pdb
# PARAMETERS: 3bro_B.T0459.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    N    -1_B      S       1           -
LGA    A     0_B      N       2           -
LGA    X     1_B      A       3           -
LGA    S     2_B      M       4           -
LGA    R     3_B      L       5           -
LGA    D     4_B      R       6           -
LGA    L     5_B      Y       7           -
LGA    G     6_B      G       8           -
LGA    R     7_B      D       9           -
LGA    L     8_B      T      10           -
LGA    L     9_B      E      11           -
LGA    K    10_B      I      12           -
LGA    I    11_B      C      13           -
LGA    A    12_B      I      14           -
LGA    S    13_B      D      15           -
LGA    N    14_B      -       -           -
LGA    Q    15_B      -       -           -
LGA    X    16_B      -       -           -
LGA    S    17_B      -       -           -
LGA    T    18_B      -       -           -
LGA    R    19_B      -       -           -
LGA    F    20_B      -       -           -
LGA    D    21_B      -       -           -
LGA    I    22_B      -       -           -
LGA    F    23_B      -       -           -
LGA    A    24_B      -       -           -
LGA    K    25_B      P      16           #
LGA    K    26_B      S      17           -
LGA    Y    27_B      E      18           -
LGA    D    28_B      S      19          4.566
LGA    -       -      V      20           -
LGA    L    29_B      L      21          3.499
LGA    -       -      H      22           -
LGA    -       -      L      23           -
LGA    T    30_B      L      24          2.502
LGA    G    31_B      G      25          3.275
LGA    -       -      K      26           -
LGA    -       -      K      27           -
LGA    T    32_B      Y      28          2.235
LGA    Q    33_B      T      29          1.419
LGA    X    34_B      M      30          1.535
LGA    T    35_B      L      31          1.485
LGA    I    36_B      I      32          1.075
LGA    I    37_B      I      33          0.960
LGA    D    38_B      S      34          1.068
LGA    Y    39_B      V      35          1.091
LGA    L    40_B      L      36          1.157
LGA    S    41_B      G      37          1.401
LGA    R    42_B      N      38          2.139
LGA    N    43_B      G      39          2.737
LGA    K    44_B      -       -           -
LGA    N    45_B      S      40          0.669
LGA    K    46_B      T      41          1.820
LGA    E    47_B      R      42          2.545
LGA    V    48_B      Q      43          0.990
LGA    L    49_B      N      44          0.689
LGA    Q    50_B      F      45          1.066
LGA    R    51_B      N      46          1.298
LGA    D    52_B      D      47          1.254
LGA    L    53_B      I      48          1.519
LGA    E    54_B      R      49          1.729
LGA    S    55_B      S      50          1.868
LGA    E    56_B      S      51          2.116
LGA    F    57_B      I      52          2.117
LGA    -       -      P      53           -
LGA    S    58_B      G      54          2.935
LGA    I    59_B      I      55          2.605
LGA    K    60_B      S      56          2.734
LGA    S    61_B      S      57          2.281
LGA    S    62_B      T      58          2.209
LGA    T    63_B      I      59          2.212
LGA    A    64_B      L      60          1.631
LGA    T    65_B      S      61          1.491
LGA    V    66_B      R      62          1.342
LGA    L    67_B      R      63          1.416
LGA    L    68_B      I      64          0.714
LGA    Q    69_B      K      65          0.686
LGA    R    70_B      D      66          0.774
LGA    X    71_B      L      67          0.687
LGA    E    72_B      I      68          0.515
LGA    I    73_B      D      69          0.634
LGA    K    74_B      S      70          0.846
LGA    K    75_B      G      71          0.784
LGA    L    76_B      L      72          0.778
LGA    L    77_B      V      73          0.189
LGA    Y    78_B      E      74          0.443
LGA    R    79_B      R      75          0.440
LGA    K    80_B      R      76          1.553
LGA    V    81_B      S      77          3.871
LGA    S    82_B      G      78          5.313
LGA    G    83_B      -       -           -
LGA    K    84_B      -       -           -
LGA    D    85_B      -       -           -
LGA    S    86_B      -       -           -
LGA    R    87_B      Q      79          3.112
LGA    Q    88_B      I      80          2.622
LGA    K    89_B      T      81          1.154
LGA    C    90_B      T      82          0.694
LGA    L    91_B      Y      83          0.688
LGA    K    92_B      A      84          0.806
LGA    L    93_B      L      85          0.589
LGA    T    94_B      T      86          1.019
LGA    K    95_B      E      87          1.182
LGA    K    96_B      K      88          1.136
LGA    A    97_B      G      89          1.356
LGA    N    98_B      M      90          1.677
LGA    K    99_B      N      91          1.491
LGA    L   100_B      V      92          1.809
LGA    E   101_B      R      93          2.116
LGA    T   102_B      N      94          2.110
LGA    I   103_B      S      95          1.436
LGA    I   104_B      L      96          0.541
LGA    L   105_B      M      97          0.959
LGA    S   106_B      P      98          1.079
LGA    Y   107_B      L      99          1.054
LGA    X   108_B      L     100          1.133
LGA    D   109_B      Q     101          0.718
LGA    S   110_B      Y     102          1.075
LGA    D   111_B      I     103          0.766
LGA    Q   112_B      S     104          0.925
LGA    S   113_B      V     105          1.349
LGA    Q   114_B      L     106          1.903
LGA    X   115_B      D     107          1.903
LGA    T   116_B      R     108          1.032
LGA    S   117_B      N     109          3.644
LGA    G   118_B      -       -           -
LGA    L   119_B      -       -           -
LGA    N   120_B      -       -           -
LGA    K   121_B      -       -           -
LGA    E   122_B      -       -           -
LGA    E   123_B      -       -           -
LGA    V   124_B      -       -           -
LGA    V   125_B      -       -           -
LGA    F   126_B      -       -           -
LGA    L   127_B      -       -           -
LGA    E   128_B      -       -           -
LGA    K   129_B      -       -           -
LGA    I   130_B      -       -           -
LGA    L   131_B      -       -           -
LGA    K   132_B      -       -           -
LGA    R   133_B      -       -           -
LGA    X   134_B      -       -           -
LGA    I   135_B      -       -           -
LGA    E   136_B      -       -           -
LGA    S   137_B      -       -           -
LGA    D   138_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  140  109    5.0     85    1.84    16.47     70.043     4.376

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.536537 * X  +  -0.606907 * Y  +  -0.586337 * Z  +  59.086578
  Y_new =  -0.156823 * X  +  -0.754420 * Y  +   0.637383 * Z  +   9.502133
  Z_new =  -0.829177 * X  +  -0.250028 * Y  +  -0.499952 * Z  + 100.024704 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.677861    0.463732  [ DEG:  -153.4301     26.5699 ]
  Theta =   0.977633    2.163959  [ DEG:    56.0143    123.9857 ]
  Phi   =  -0.284366    2.857227  [ DEG:   -16.2930    163.7070 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3bro_B                                        
REMARK     2: T0459.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3bro_B.T0459.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  140  109   5.0   85   1.84   16.47  70.043
REMARK  ---------------------------------------------------------- 
MOLECULE 3bro_B
HEADER    TRANSCRIPTION REGULATOR                 21-DEC-07   3BRO              
TITLE     CRYSTAL STRUCTURE OF THE TRANSCRIPTION REGULATOR MARR FROM            
TITLE    2 OENOCOCCUS OENI PSU-1                                                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TRANSCRIPTIONAL REGULATOR;                                 
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: OENOCOCCUS OENI PSU-1;                          
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: PSU-1;                                                       
SOURCE   5 ATCC: BAA-331;                                                       
SOURCE   6 GENE: OEOE_1854;                                                     
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    HELIX_TURN_HELIX, MULTIPLE ANTIBIOTIC RESISTANCE PROTEIN              
KEYWDS   2 (MARR), STRUCTURAL GENOMICS, PSI-2, PROTEIN STRUCTURE                
KEYWDS   3 INITIATIVE, MIDWEST CENTER FOR STRUCTURAL GENOMICS, MCSG,            
KEYWDS   4 DNA-BINDING, TRANSCRIPTION, TRANSCRIPTION REGULATION,                
KEYWDS   5 TRANSCRIPTION REGULATOR                                              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.KIM,L.VOLKART,M.GU,A.JOACHIMIAK,MIDWEST CENTER FOR                  
AUTHOR   2 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   1   15-JAN-08 3BRO    0                                                
JRNL        AUTH   Y.KIM,L.VOLKART,M.GU,A.JOACHIMIAK                            
JRNL        TITL   CRYSTAL STRUCTURE OF THE TRANSCRIPTION REGULATOR             
JRNL        TITL 2 MARR FROM OENOCOCCUS OENI PSU-1.                             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.04 ANGSTROMS.                                          
DBREF  3BRO A    1   138  UNP    Q04CY6   Q04CY6_OENOB     1    138             
DBREF  3BRO B    1   138  UNP    Q04CY6   Q04CY6_OENOB     1    138             
DBREF  3BRO C    1   138  UNP    Q04CY6   Q04CY6_OENOB     1    138             
DBREF  3BRO D    1   138  UNP    Q04CY6   Q04CY6_OENOB     1    138             
SEQRES   1 A  141  SER ASN ALA MSE SER ARG ASP LEU GLY ARG LEU LEU LYS          
SEQRES   2 A  141  ILE ALA SER ASN GLN MSE SER THR ARG PHE ASP ILE PHE          
SEQRES   3 A  141  ALA LYS LYS TYR ASP LEU THR GLY THR GLN MSE THR ILE          
SEQRES   4 A  141  ILE ASP TYR LEU SER ARG ASN LYS ASN LYS GLU VAL LEU          
SEQRES   5 A  141  GLN ARG ASP LEU GLU SER GLU PHE SER ILE LYS SER SER          
SEQRES   6 A  141  THR ALA THR VAL LEU LEU GLN ARG MSE GLU ILE LYS LYS          
SEQRES   7 A  141  LEU LEU TYR ARG LYS VAL SER GLY LYS ASP SER ARG GLN          
SEQRES   8 A  141  LYS CYS LEU LYS LEU THR LYS LYS ALA ASN LYS LEU GLU          
SEQRES   9 A  141  THR ILE ILE LEU SER TYR MSE ASP SER ASP GLN SER GLN          
SEQRES  10 A  141  MSE THR SER GLY LEU ASN LYS GLU GLU VAL VAL PHE LEU          
SEQRES  11 A  141  GLU LYS ILE LEU LYS ARG MSE ILE GLU SER ASP                  
SEQRES   1 B  141  SER ASN ALA MSE SER ARG ASP LEU GLY ARG LEU LEU LYS          
SEQRES   2 B  141  ILE ALA SER ASN GLN MSE SER THR ARG PHE ASP ILE PHE          
SEQRES   3 B  141  ALA LYS LYS TYR ASP LEU THR GLY THR GLN MSE THR ILE          
SEQRES   4 B  141  ILE ASP TYR LEU SER ARG ASN LYS ASN LYS GLU VAL LEU          
SEQRES   5 B  141  GLN ARG ASP LEU GLU SER GLU PHE SER ILE LYS SER SER          
SEQRES   6 B  141  THR ALA THR VAL LEU LEU GLN ARG MSE GLU ILE LYS LYS          
SEQRES   7 B  141  LEU LEU TYR ARG LYS VAL SER GLY LYS ASP SER ARG GLN          
SEQRES   8 B  141  LYS CYS LEU LYS LEU THR LYS LYS ALA ASN LYS LEU GLU          
SEQRES   9 B  141  THR ILE ILE LEU SER TYR MSE ASP SER ASP GLN SER GLN          
SEQRES  10 B  141  MSE THR SER GLY LEU ASN LYS GLU GLU VAL VAL PHE LEU          
SEQRES  11 B  141  GLU LYS ILE LEU LYS ARG MSE ILE GLU SER ASP                  
SEQRES   1 C  141  SER ASN ALA MSE SER ARG ASP LEU GLY ARG LEU LEU LYS          
SEQRES   2 C  141  ILE ALA SER ASN GLN MSE SER THR ARG PHE ASP ILE PHE          
SEQRES   3 C  141  ALA LYS LYS TYR ASP LEU THR GLY THR GLN MSE THR ILE          
SEQRES   4 C  141  ILE ASP TYR LEU SER ARG ASN LYS ASN LYS GLU VAL LEU          
SEQRES   5 C  141  GLN ARG ASP LEU GLU SER GLU PHE SER ILE LYS SER SER          
SEQRES   6 C  141  THR ALA THR VAL LEU LEU GLN ARG MSE GLU ILE LYS LYS          
SEQRES   7 C  141  LEU LEU TYR ARG LYS VAL SER GLY LYS ASP SER ARG GLN          
SEQRES   8 C  141  LYS CYS LEU LYS LEU THR LYS LYS ALA ASN LYS LEU GLU          
SEQRES   9 C  141  THR ILE ILE LEU SER TYR MSE ASP SER ASP GLN SER GLN          
SEQRES  10 C  141  MSE THR SER GLY LEU ASN LYS GLU GLU VAL VAL PHE LEU          
SEQRES  11 C  141  GLU LYS ILE LEU LYS ARG MSE ILE GLU SER ASP                  
SEQRES   1 D  141  SER ASN ALA MSE SER ARG ASP LEU GLY ARG LEU LEU LYS          
SEQRES   2 D  141  ILE ALA SER ASN GLN MSE SER THR ARG PHE ASP ILE PHE          
SEQRES   3 D  141  ALA LYS LYS TYR ASP LEU THR GLY THR GLN MSE THR ILE          
SEQRES   4 D  141  ILE ASP TYR LEU SER ARG ASN LYS ASN LYS GLU VAL LEU          
SEQRES   5 D  141  GLN ARG ASP LEU GLU SER GLU PHE SER ILE LYS SER SER          
SEQRES   6 D  141  THR ALA THR VAL LEU LEU GLN ARG MSE GLU ILE LYS LYS          
SEQRES   7 D  141  LEU LEU TYR ARG LYS VAL SER GLY LYS ASP SER ARG GLN          
SEQRES   8 D  141  LYS CYS LEU LYS LEU THR LYS LYS ALA ASN LYS LEU GLU          
SEQRES   9 D  141  THR ILE ILE LEU SER TYR MSE ASP SER ASP GLN SER GLN          
SEQRES  10 D  141  MSE THR SER GLY LEU ASN LYS GLU GLU VAL VAL PHE LEU          
SEQRES  11 D  141  GLU LYS ILE LEU LYS ARG MSE ILE GLU SER ASP                  
HET    MSE  A  16       8                                                       
HET    MSE  A  34       8                                                       
HET    MSE  A  71       8                                                       
HET    MSE  A 108       8                                                       
HET    MSE  A 115       8                                                       
HET    MSE  A 134       8                                                       
HET    MSE  B   1      16                                                       
HET    MSE  B  16       8                                                       
HET    MSE  B  34       8                                                       
HET    MSE  B  71       8                                                       
HET    MSE  B 108       8                                                       
HET    MSE  B 115      24                                                       
HET    MSE  B 134       8                                                       
HET    MSE  C  16       8                                                       
HET    MSE  C  34       8                                                       
HET    MSE  C  71       8                                                       
HET    MSE  C 108       8                                                       
HET    MSE  C 115      16                                                       
HET    MSE  C 134       8                                                       
HET    MSE  D  16       8                                                       
HET    MSE  D  34       8                                                       
HET    MSE  D  71       8                                                       
HET    MSE  D 108       8                                                       
HET    MSE  D 115       8                                                       
HET    MSE  D 134       8                                                       
HET     CL  A 201       1                                                       
HET     CL  A 202       1                                                       
HET    GOL  D 203       6                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      CL CHLORIDE ION                                                     
HETNAM     GOL GLYCEROL                                                         
FORMUL   1  MSE    25(C5 H11 N O2 SE)                                           
FORMUL   5   CL    2(CL 1-)                                                     
FORMUL   7  GOL    C3 H8 O3                                                     
FORMUL   8  HOH   *451(H2 O)                                                    
CRYST1   61.489   80.426  143.257  90.00  90.00  90.00 P 21 21 21   16          
ATOM   1200  N   ASN B  -1      32.112   6.188  -7.292  1.00 65.63           N  
ATOM   1201  CA  ASN B  -1      31.265   5.585  -8.376  1.00 65.11           C  
ATOM   1202  C   ASN B  -1      31.351   6.375  -9.690  1.00 65.27           C  
ATOM   1203  O   ASN B  -1      31.397   7.634  -9.661  1.00 65.92           O  
ATOM   1204  CB  ASN B  -1      29.783   5.525  -7.947  1.00 65.71           C  
ATOM   1205  CG  ASN B  -1      29.524   4.548  -6.802  1.00 64.84           C  
ATOM   1206  OD1 ASN B  -1      29.436   4.960  -5.639  1.00 64.24           O  
ATOM   1207  ND2 ASN B  -1      29.382   3.253  -7.133  1.00 62.26           N  
ATOM   1208  N   ALA B   0      31.307   5.646 -10.825  1.00 64.06           N  
ATOM   1209  CA  ALA B   0      31.478   6.247 -12.178  1.00 63.11           C  
ATOM   1210  C   ALA B   0      30.397   7.284 -12.453  1.00 61.58           C  
ATOM   1211  O   ALA B   0      30.676   8.403 -12.916  1.00 61.88           O  
ATOM   1212  CB  ALA B   0      31.430   5.164 -13.288  1.00 63.08           C  
HETATM 1213  N   MSE B   1      29.164   6.840 -12.199  0.50 61.64           N  
HETATM 1215  CA  MSE B   1      27.933   7.615 -12.322  0.50 62.28           C  
HETATM 1217  C   MSE B   1      27.695   8.395 -11.037  0.50 58.00           C  
HETATM 1219  O   MSE B   1      27.959   7.871  -9.958  0.50 57.50           O  
HETATM 1221  CB  MSE B   1      26.767   6.640 -12.505  0.50 62.39           C  
HETATM 1223  CG  MSE B   1      26.588   6.095 -13.911  0.50 65.11           C  
HETATM 1225 SE   MSE B   1      25.011   6.932 -14.687  0.70 73.59          SE  
HETATM 1227  CE  MSE B   1      24.978   6.155 -16.478  0.50 64.37           C  
ATOM   1229  N   SER B   2      27.250   9.644 -11.133  1.00 54.14           N  
ATOM   1230  CA  SER B   2      26.639  10.299  -9.969  1.00 51.07           C  
ATOM   1231  C   SER B   2      25.132  10.146 -10.031  1.00 46.51           C  
ATOM   1232  O   SER B   2      24.550  10.343 -11.060  1.00 44.67           O  
ATOM   1233  CB  SER B   2      26.955  11.793  -9.936  1.00 50.44           C  
ATOM   1234  OG  SER B   2      26.226  12.450  -8.913  1.00 46.29           O  
ATOM   1235  N   ARG B   3      24.492   9.864  -8.902  1.00 42.97           N  
ATOM   1236  CA  ARG B   3      23.045   9.905  -8.831  1.00 39.72           C  
ATOM   1237  C   ARG B   3      22.481  11.304  -8.577  1.00 38.79           C  
ATOM   1238  O   ARG B   3      21.274  11.421  -8.436  1.00 37.61           O  
ATOM   1239  CB  ARG B   3      22.544   8.958  -7.716  1.00 39.96           C  
ATOM   1240  CG  ARG B   3      22.932   7.529  -7.950  1.00 37.86           C  
ATOM   1241  CD  ARG B   3      22.113   6.926  -9.096  1.00 34.27           C  
ATOM   1242  NE  ARG B   3      22.359   5.493  -9.144  1.00 30.39           N  
ATOM   1243  CZ  ARG B   3      22.866   4.844 -10.176  1.00 30.99           C  
ATOM   1244  NH1 ARG B   3      23.257   5.497 -11.277  1.00 35.76           N  
ATOM   1245  NH2 ARG B   3      23.085   3.577 -10.069  1.00 29.34           N  
ATOM   1246  N   ASP B   4      23.329  12.350  -8.530  1.00 36.42           N  
ATOM   1247  CA  ASP B   4      22.879  13.637  -8.001  1.00 37.93           C  
ATOM   1248  C   ASP B   4      21.732  14.252  -8.802  1.00 36.85           C  
ATOM   1249  O   ASP B   4      20.821  14.789  -8.226  1.00 37.03           O  
ATOM   1250  CB  ASP B   4      24.027  14.637  -7.879  1.00 37.81           C  
ATOM   1251  CG  ASP B   4      24.896  14.393  -6.651  1.00 43.52           C  
ATOM   1252  OD1 ASP B   4      24.496  13.569  -5.797  1.00 48.90           O  
ATOM   1253  OD2 ASP B   4      25.941  15.061  -6.506  1.00 47.33           O  
ATOM   1254  N   LEU B   5      21.751  14.159 -10.121  1.00 36.44           N  
ATOM   1255  CA  LEU B   5      20.717  14.827 -10.875  1.00 36.78           C  
ATOM   1256  C   LEU B   5      19.326  14.311 -10.450  1.00 35.86           C  
ATOM   1257  O   LEU B   5      18.499  15.097 -10.107  1.00 36.71           O  
ATOM   1258  CB  LEU B   5      20.900  14.664 -12.372  1.00 37.85           C  
ATOM   1259  CG  LEU B   5      19.771  15.171 -13.257  1.00 39.56           C  
ATOM   1260  CD1 LEU B   5      19.717  16.653 -13.081  1.00 42.09           C  
ATOM   1261  CD2 LEU B   5      20.087  14.760 -14.709  1.00 40.60           C  
ATOM   1262  N   GLY B   6      19.086  13.016 -10.501  1.00 36.08           N  
ATOM   1263  CA  GLY B   6      17.766  12.480 -10.072  1.00 35.89           C  
ATOM   1264  C   GLY B   6      17.441  12.667  -8.584  1.00 34.04           C  
ATOM   1265  O   GLY B   6      16.302  12.887  -8.229  1.00 34.53           O  
ATOM   1266  N   ARG B   7      18.428  12.422  -7.731  1.00 32.93           N  
ATOM   1267  CA  ARG B   7      18.281  12.476  -6.276  1.00 33.67           C  
ATOM   1268  C   ARG B   7      17.949  13.905  -5.899  1.00 32.75           C  
ATOM   1269  O   ARG B   7      16.952  14.170  -5.182  1.00 31.00           O  
ATOM   1270  CB  ARG B   7      19.549  11.934  -5.584  1.00 33.38           C  
ATOM   1271  CG  ARG B   7      19.399  11.705  -4.080  1.00 32.82           C  
ATOM   1272  CD  ARG B   7      20.575  11.018  -3.575  1.00 32.96           C  
ATOM   1273  NE  ARG B   7      20.708   9.664  -4.137  1.00 33.82           N  
ATOM   1274  CZ  ARG B   7      21.780   8.912  -4.047  1.00 32.49           C  
ATOM   1275  NH1 ARG B   7      22.853   9.359  -3.398  1.00 33.42           N  
ATOM   1276  NH2 ARG B   7      21.788   7.688  -4.571  1.00 31.43           N  
ATOM   1277  N   LEU B   8      18.702  14.846  -6.455  1.00 31.51           N  
ATOM   1278  CA  LEU B   8      18.455  16.274  -6.160  1.00 33.77           C  
ATOM   1279  C   LEU B   8      17.217  16.873  -6.832  1.00 34.25           C  
ATOM   1280  O   LEU B   8      16.574  17.740  -6.265  1.00 34.36           O  
ATOM   1281  CB  LEU B   8      19.706  17.154  -6.500  1.00 33.80           C  
ATOM   1282  CG  LEU B   8      21.039  16.877  -5.834  1.00 36.49           C  
ATOM   1283  CD1 LEU B   8      22.176  17.688  -6.437  1.00 38.73           C  
ATOM   1284  CD2 LEU B   8      20.939  17.167  -4.352  1.00 35.38           C  
ATOM   1285  N   LEU B   9      16.840  16.393  -8.008  1.00 35.17           N  
ATOM   1286  CA  LEU B   9      15.582  16.813  -8.597  1.00 36.40           C  
ATOM   1287  C   LEU B   9      14.370  16.442  -7.702  1.00 35.76           C  
ATOM   1288  O   LEU B   9      13.479  17.255  -7.523  1.00 36.26           O  
ATOM   1289  CB  LEU B   9      15.425  16.165  -9.978  1.00 37.34           C  
ATOM   1290  CG  LEU B   9      14.111  16.325 -10.780  1.00 39.58           C  
ATOM   1291  CD1 LEU B   9      13.736  17.759 -11.023  1.00 43.39           C  
ATOM   1292  CD2 LEU B   9      14.283  15.562 -12.100  1.00 40.39           C  
ATOM   1293  N   LYS B  10      14.369  15.222  -7.145  1.00 34.60           N  
ATOM   1294  CA  LYS B  10      13.322  14.770  -6.263  1.00 34.02           C  
ATOM   1295  C   LYS B  10      13.351  15.620  -4.965  1.00 34.72           C  
ATOM   1296  O   LYS B  10      12.314  16.073  -4.536  1.00 34.55           O  
ATOM   1297  CB  LYS B  10      13.455  13.277  -5.934  1.00 34.47           C  
ATOM   1298  CG  LYS B  10      12.379  12.704  -4.958  1.00 33.80           C  
ATOM   1299  CD  LYS B  10      12.555  11.222  -4.706  1.00 32.95           C  
ATOM   1300  CE  LYS B  10      11.449  10.543  -3.793  1.00 34.34           C  
ATOM   1301  NZ  LYS B  10      11.731   9.056  -3.719  1.00 36.34           N  
ATOM   1302  N   ILE B  11      14.532  15.850  -4.394  1.00 33.62           N  
ATOM   1303  CA  ILE B  11      14.591  16.665  -3.148  1.00 34.52           C  
ATOM   1304  C   ILE B  11      14.054  18.065  -3.458  1.00 35.55           C  
ATOM   1305  O   ILE B  11      13.189  18.556  -2.748  1.00 35.28           O  
ATOM   1306  CB  ILE B  11      16.005  16.732  -2.579  1.00 34.04           C  
ATOM   1307  CG1 ILE B  11      16.416  15.365  -2.064  1.00 31.11           C  
ATOM   1308  CG2 ILE B  11      16.075  17.847  -1.423  1.00 32.04           C  
ATOM   1309  CD1 ILE B  11      17.931  15.103  -1.841  1.00 31.41           C  
ATOM   1310  N   ALA B  12      14.497  18.694  -4.570  1.00 36.90           N  
ATOM   1311  CA  ALA B  12      14.119  20.082  -4.872  1.00 36.75           C  
ATOM   1312  C   ALA B  12      12.624  20.197  -5.047  1.00 38.23           C  
ATOM   1313  O   ALA B  12      11.969  21.120  -4.536  1.00 36.95           O  
ATOM   1314  CB  ALA B  12      14.862  20.628  -6.136  1.00 37.25           C  
ATOM   1315  N   SER B  13      12.069  19.239  -5.774  1.00 39.47           N  
ATOM   1316  CA  SER B  13      10.642  19.254  -6.101  1.00 40.82           C  
ATOM   1317  C   SER B  13       9.784  19.007  -4.882  1.00 41.31           C  
ATOM   1318  O   SER B  13       8.780  19.700  -4.696  1.00 40.75           O  
ATOM   1319  CB  SER B  13      10.346  18.198  -7.142  1.00 41.87           C  
ATOM   1320  OG  SER B  13       9.025  18.332  -7.585  1.00 43.70           O  
ATOM   1321  N   ASN B  14      10.181  18.044  -4.064  1.00 40.30           N  
ATOM   1322  CA  ASN B  14       9.494  17.769  -2.806  1.00 41.42           C  
ATOM   1323  C   ASN B  14       9.606  18.947  -1.808  1.00 41.12           C  
ATOM   1324  O   ASN B  14       8.636  19.209  -1.131  1.00 39.99           O  
ATOM   1325  CB  ASN B  14       9.935  16.465  -2.150  1.00 41.11           C  
ATOM   1326  CG  ASN B  14       9.516  15.212  -2.962  1.00 45.30           C  
ATOM   1327  OD1 ASN B  14       8.715  15.296  -3.882  1.00 51.05           O  
ATOM   1328  ND2 ASN B  14      10.056  14.073  -2.609  1.00 45.05           N  
ATOM   1329  N   GLN B  15      10.732  19.652  -1.774  0.50 40.76           N  
ATOM   1331  CA  GLN B  15      10.878  20.850  -0.926  0.50 41.58           C  
ATOM   1333  C   GLN B  15       9.902  21.949  -1.362  0.50 43.13           C  
ATOM   1335  O   GLN B  15       9.223  22.582  -0.541  0.50 42.86           O  
ATOM   1337  CB  GLN B  15      12.327  21.361  -0.979  0.50 41.47           C  
ATOM   1339  CG  GLN B  15      12.608  22.687  -0.218  0.50 41.65           C  
ATOM   1341  CD  GLN B  15      14.095  23.030  -0.198  0.50 40.81           C  
ATOM   1343  OE1 GLN B  15      14.489  24.137  -0.550  0.50 43.82           O  
ATOM   1345  NE2 GLN B  15      14.908  22.097   0.232  0.50 30.53           N  
HETATM 1347  N   MSE B  16       9.833  22.168  -2.665  1.00 44.44           N  
HETATM 1348  CA  MSE B  16       8.933  23.156  -3.229  1.00 47.13           C  
HETATM 1349  C   MSE B  16       7.459  22.817  -2.947  1.00 47.72           C  
HETATM 1350  O   MSE B  16       6.693  23.684  -2.530  1.00 46.70           O  
HETATM 1351  CB  MSE B  16       9.150  23.298  -4.717  1.00 46.81           C  
HETATM 1352  CG  MSE B  16       8.120  24.242  -5.345  1.00 49.70           C  
HETATM 1353 SE   MSE B  16       8.484  24.560  -7.198  0.70 55.32          SE  
HETATM 1354  CE  MSE B  16       8.340  22.693  -7.837  1.00 60.00           C  
ATOM   1355  N   SER B  17       7.074  21.563  -3.179  0.50 48.32           N  
ATOM   1357  CA  SER B  17       5.698  21.147  -2.926  0.50 48.95           C  
ATOM   1359  C   SER B  17       5.344  21.176  -1.426  0.50 49.31           C  
ATOM   1361  O   SER B  17       4.201  21.438  -1.084  0.50 49.15           O  
ATOM   1363  CB  SER B  17       5.393  19.783  -3.550  0.50 48.39           C  
ATOM   1365  OG  SER B  17       6.055  18.739  -2.889  0.50 50.72           O  
ATOM   1367  N   THR B  18       6.315  20.923  -0.546  1.00 49.41           N  
ATOM   1368  CA  THR B  18       6.129  21.092   0.898  1.00 50.56           C  
ATOM   1369  C   THR B  18       5.850  22.558   1.276  1.00 51.44           C  
ATOM   1370  O   THR B  18       4.889  22.847   1.975  1.00 51.37           O  
ATOM   1371  CB  THR B  18       7.354  20.538   1.685  1.00 50.79           C  
ATOM   1372  OG1 THR B  18       7.480  19.122   1.431  1.00 48.30           O  
ATOM   1373  CG2 THR B  18       7.221  20.810   3.182  1.00 50.08           C  
ATOM   1374  N   ARG B  19       6.712  23.462   0.820  0.50 52.16           N  
ATOM   1376  CA  ARG B  19       6.531  24.906   1.017  0.50 52.91           C  
ATOM   1378  C   ARG B  19       5.159  25.364   0.542  0.50 53.59           C  
ATOM   1380  O   ARG B  19       4.496  26.174   1.217  0.50 53.38           O  
ATOM   1382  CB  ARG B  19       7.626  25.703   0.290  0.50 52.77           C  
ATOM   1384  CG  ARG B  19       8.969  25.581   0.970  0.50 53.60           C  
ATOM   1386  CD  ARG B  19      10.086  26.352   0.296  0.50 54.11           C  
ATOM   1388  NE  ARG B  19      11.361  26.099   0.991  0.50 54.80           N  
ATOM   1390  CZ  ARG B  19      12.508  26.726   0.745  0.50 54.43           C  
ATOM   1392  NH1 ARG B  19      12.587  27.662  -0.193  0.50 54.36           N  
ATOM   1394  NH2 ARG B  19      13.577  26.414   1.464  0.50 54.99           N  
ATOM   1396  N   PHE B  20       4.733  24.828  -0.602  1.00 53.78           N  
ATOM   1397  CA  PHE B  20       3.467  25.224  -1.220  1.00 54.81           C  
ATOM   1398  C   PHE B  20       2.314  24.813  -0.345  1.00 57.28           C  
ATOM   1399  O   PHE B  20       1.330  25.569  -0.236  1.00 56.74           O  
ATOM   1400  CB  PHE B  20       3.259  24.579  -2.589  1.00 54.19           C  
ATOM   1401  CG  PHE B  20       3.931  25.293  -3.732  1.00 54.08           C  
ATOM   1402  CD1 PHE B  20       4.911  26.241  -3.539  1.00 53.78           C  
ATOM   1403  CD2 PHE B  20       3.587  24.966  -5.024  1.00 53.07           C  
ATOM   1404  CE1 PHE B  20       5.513  26.848  -4.611  1.00 53.89           C  
ATOM   1405  CE2 PHE B  20       4.189  25.569  -6.076  1.00 54.20           C  
ATOM   1406  CZ  PHE B  20       5.149  26.516  -5.872  1.00 54.60           C  
ATOM   1407  N   ASP B  21       2.398  23.614   0.226  1.00 59.35           N  
ATOM   1408  CA  ASP B  21       1.302  23.119   1.064  1.00 62.75           C  
ATOM   1409  C   ASP B  21       1.201  23.950   2.344  1.00 64.31           C  
ATOM   1410  O   ASP B  21       0.114  24.354   2.741  1.00 64.13           O  
ATOM   1411  CB  ASP B  21       1.496  21.646   1.415  1.00 62.02           C  
ATOM   1412  CG  ASP B  21       1.190  20.725   0.276  1.00 61.72           C  
ATOM   1413  OD1 ASP B  21       0.508  21.143  -0.682  1.00 63.24           O  
ATOM   1414  OD2 ASP B  21       1.635  19.564   0.333  1.00 62.44           O  
ATOM   1415  N   ILE B  22       2.352  24.202   2.967  1.00 66.92           N  
ATOM   1416  CA  ILE B  22       2.457  25.087   4.134  1.00 69.00           C  
ATOM   1417  C   ILE B  22       1.749  26.440   3.875  1.00 71.09           C  
ATOM   1418  O   ILE B  22       0.875  26.841   4.635  1.00 71.25           O  
ATOM   1419  CB  ILE B  22       3.963  25.292   4.549  1.00 68.62           C  
ATOM   1420  CG1 ILE B  22       4.416  24.223   5.558  1.00 68.08           C  
ATOM   1421  CG2 ILE B  22       4.201  26.667   5.162  1.00 68.13           C  
ATOM   1422  CD1 ILE B  22       4.348  22.812   5.084  1.00 65.69           C  
ATOM   1423  N   PHE B  23       2.127  27.123   2.794  1.00 73.95           N  
ATOM   1424  CA  PHE B  23       1.515  28.410   2.431  1.00 75.27           C  
ATOM   1425  C   PHE B  23       0.030  28.302   2.052  1.00 76.76           C  
ATOM   1426  O   PHE B  23      -0.750  29.206   2.364  1.00 76.75           O  
ATOM   1427  CB  PHE B  23       2.277  29.098   1.290  1.00 76.14           C  
ATOM   1428  CG  PHE B  23       1.490  30.211   0.618  1.00 76.11           C  
ATOM   1429  CD1 PHE B  23       0.799  29.979  -0.576  1.00 77.29           C  
ATOM   1430  CD2 PHE B  23       1.412  31.482   1.201  1.00 77.95           C  
ATOM   1431  CE1 PHE B  23       0.066  30.997  -1.188  1.00 77.67           C  
ATOM   1432  CE2 PHE B  23       0.678  32.509   0.594  1.00 77.39           C  
ATOM   1433  CZ  PHE B  23       0.003  32.266  -0.598  1.00 77.66           C  
ATOM   1434  N   ALA B  24      -0.347  27.215   1.382  1.00 77.86           N  
ATOM   1435  CA  ALA B  24      -1.719  27.034   0.925  1.00 78.99           C  
ATOM   1436  C   ALA B  24      -2.707  26.631   2.036  1.00 79.92           C  
ATOM   1437  O   ALA B  24      -3.855  27.084   2.016  1.00 79.93           O  
ATOM   1438  CB  ALA B  24      -1.778  26.047  -0.214  1.00 78.75           C  
ATOM   1439  N   LYS B  25      -2.273  25.799   2.983  0.50 80.35           N  
ATOM   1441  CA  LYS B  25      -3.151  25.341   4.074  0.50 80.61           C  
ATOM   1443  C   LYS B  25      -3.634  26.497   4.963  0.50 80.66           C  
ATOM   1445  O   LYS B  25      -4.622  26.361   5.681  0.50 80.64           O  
ATOM   1447  CB  LYS B  25      -2.467  24.253   4.923  0.50 81.04           C  
ATOM   1449  CG  LYS B  25      -1.306  24.730   5.801  0.50 81.63           C  
ATOM   1451  CD  LYS B  25      -1.732  25.010   7.242  0.50 82.27           C  
ATOM   1453  CE  LYS B  25      -0.586  25.582   8.058  0.50 82.06           C  
ATOM   1455  NZ  LYS B  25      -1.018  25.891   9.449  0.50 81.99           N  
ATOM   1457  N   LYS B  26      -2.927  27.623   4.899  1.00 80.46           N  
ATOM   1458  CA  LYS B  26      -3.313  28.860   5.579  1.00 80.20           C  
ATOM   1459  C   LYS B  26      -4.548  29.540   4.956  1.00 79.45           C  
ATOM   1460  O   LYS B  26      -5.141  30.450   5.565  1.00 79.32           O  
ATOM   1461  CB  LYS B  26      -2.139  29.845   5.517  1.00 80.55           C  
ATOM   1462  CG  LYS B  26      -2.071  30.851   6.667  1.00 81.94           C  
ATOM   1463  CD  LYS B  26      -0.662  31.450   6.786  1.00 81.99           C  
ATOM   1464  CE  LYS B  26       0.366  30.438   7.322  1.00 83.08           C  
ATOM   1465  NZ  LYS B  26       1.718  30.656   6.729  1.00 82.92           N  
ATOM   1466  N   TYR B  27      -4.899  29.135   3.731  1.00 77.84           N  
ATOM   1467  CA  TYR B  27      -6.111  29.591   3.058  1.00 76.35           C  
ATOM   1468  C   TYR B  27      -6.953  28.397   2.622  1.00 74.55           C  
ATOM   1469  O   TYR B  27      -7.530  28.411   1.537  1.00 73.84           O  
ATOM   1470  CB  TYR B  27      -5.757  30.434   1.834  1.00 76.93           C  
ATOM   1471  CG  TYR B  27      -4.790  31.565   2.102  1.00 77.32           C  
ATOM   1472  CD1 TYR B  27      -5.237  32.879   2.224  1.00 77.60           C  
ATOM   1473  CD2 TYR B  27      -3.423  31.323   2.225  1.00 78.08           C  
ATOM   1474  CE1 TYR B  27      -4.345  33.924   2.460  1.00 77.74           C  
ATOM   1475  CE2 TYR B  27      -2.523  32.359   2.462  1.00 78.08           C  
ATOM   1476  CZ  TYR B  27      -2.989  33.654   2.577  1.00 77.96           C  
ATOM   1477  OH  TYR B  27      -2.095  34.671   2.812  1.00 77.72           O  
ATOM   1478  N   ASP B  28      -6.998  27.367   3.465  1.00 72.52           N  
ATOM   1479  CA  ASP B  28      -7.815  26.173   3.241  1.00 71.62           C  
ATOM   1480  C   ASP B  28      -7.712  25.661   1.803  1.00 70.22           C  
ATOM   1481  O   ASP B  28      -8.715  25.534   1.107  1.00 69.80           O  
ATOM   1482  CB  ASP B  28      -9.280  26.458   3.632  1.00 72.01           C  
ATOM   1483  CG  ASP B  28     -10.137  25.191   3.736  1.00 72.52           C  
ATOM   1484  OD1 ASP B  28      -9.677  24.158   4.273  1.00 72.14           O  
ATOM   1485  OD2 ASP B  28     -11.300  25.244   3.287  1.00 74.59           O  
ATOM   1486  N   LEU B  29      -6.479  25.360   1.378  1.00 68.38           N  
ATOM   1487  CA  LEU B  29      -6.174  24.934   0.003  1.00 66.68           C  
ATOM   1488  C   LEU B  29      -4.951  24.009  -0.001  1.00 65.13           C  
ATOM   1489  O   LEU B  29      -3.994  24.259   0.744  1.00 64.50           O  
ATOM   1490  CB  LEU B  29      -5.841  26.159  -0.872  1.00 66.59           C  
ATOM   1491  CG  LEU B  29      -6.915  27.025  -1.541  1.00 66.14           C  
ATOM   1492  CD1 LEU B  29      -6.257  28.278  -2.147  1.00 64.56           C  
ATOM   1493  CD2 LEU B  29      -7.689  26.234  -2.597  1.00 64.74           C  
ATOM   1494  N   THR B  30      -4.959  22.959  -0.834  1.00 63.08           N  
ATOM   1495  CA  THR B  30      -3.699  22.237  -1.114  1.00 61.47           C  
ATOM   1496  C   THR B  30      -2.774  23.114  -1.959  1.00 59.26           C  
ATOM   1497  O   THR B  30      -3.188  24.126  -2.578  1.00 58.23           O  
ATOM   1498  CB  THR B  30      -3.870  20.864  -1.826  1.00 60.70           C  
ATOM   1499  OG1 THR B  30      -4.470  21.045  -3.107  1.00 58.38           O  
ATOM   1500  CG2 THR B  30      -4.673  19.876  -0.989  1.00 59.78           C  
ATOM   1501  N   GLY B  31      -1.501  22.719  -1.968  1.00 57.34           N  
ATOM   1502  CA  GLY B  31      -0.507  23.375  -2.776  1.00 55.20           C  
ATOM   1503  C   GLY B  31      -0.912  23.320  -4.235  1.00 54.08           C  
ATOM   1504  O   GLY B  31      -0.789  24.320  -4.941  1.00 53.56           O  
ATOM   1505  N   THR B  32      -1.413  22.168  -4.679  1.00 53.16           N  
ATOM   1506  CA  THR B  32      -1.773  21.980  -6.090  1.00 52.96           C  
ATOM   1507  C   THR B  32      -2.928  22.902  -6.436  1.00 52.67           C  
ATOM   1508  O   THR B  32      -2.845  23.669  -7.412  1.00 52.41           O  
ATOM   1509  CB  THR B  32      -2.150  20.498  -6.436  1.00 52.98           C  
ATOM   1510  OG1 THR B  32      -0.991  19.655  -6.353  1.00 53.01           O  
ATOM   1511  CG2 THR B  32      -2.697  20.402  -7.848  1.00 53.23           C  
ATOM   1512  N   GLN B  33      -3.997  22.869  -5.629  1.00 51.78           N  
ATOM   1513  CA  GLN B  33      -5.138  23.772  -5.870  1.00 51.88           C  
ATOM   1514  C   GLN B  33      -4.648  25.223  -5.964  1.00 51.83           C  
ATOM   1515  O   GLN B  33      -4.968  25.954  -6.910  1.00 52.06           O  
ATOM   1516  CB  GLN B  33      -6.176  23.632  -4.765  1.00 51.34           C  
ATOM   1517  CG  GLN B  33      -6.828  22.263  -4.700  1.00 51.39           C  
ATOM   1518  CD  GLN B  33      -7.547  22.001  -3.372  1.00 52.37           C  
ATOM   1519  OE1 GLN B  33      -7.401  22.760  -2.394  1.00 54.11           O  
ATOM   1520  NE2 GLN B  33      -8.342  20.939  -3.341  1.00 50.20           N  
HETATM 1521  N   MSE B  34      -3.826  25.624  -5.014  1.00 51.71           N  
HETATM 1522  CA  MSE B  34      -3.229  26.947  -5.046  1.00 51.89           C  
HETATM 1523  C   MSE B  34      -2.519  27.251  -6.376  1.00 51.57           C  
HETATM 1524  O   MSE B  34      -2.664  28.358  -6.929  1.00 52.12           O  
HETATM 1525  CB  MSE B  34      -2.264  27.100  -3.848  1.00 53.02           C  
HETATM 1526  CG  MSE B  34      -1.600  28.473  -3.691  1.00 54.16           C  
HETATM 1527 SE   MSE B  34       0.075  28.714  -4.681  0.60 64.25          SE  
HETATM 1528  CE  MSE B  34       1.161  27.347  -3.720  1.00 55.93           C  
ATOM   1529  N   THR B  35      -1.750  26.290  -6.903  1.00 51.17           N  
ATOM   1530  CA  THR B  35      -1.134  26.453  -8.245  1.00 50.69           C  
ATOM   1531  C   THR B  35      -2.160  26.578  -9.388  1.00 50.75           C  
ATOM   1532  O   THR B  35      -1.892  27.236 -10.401  1.00 49.36           O  
ATOM   1533  CB  THR B  35      -0.093  25.316  -8.619  1.00 50.31           C  
ATOM   1534  OG1 THR B  35      -0.761  24.082  -8.896  1.00 47.25           O  
ATOM   1535  CG2 THR B  35       0.975  25.137  -7.522  1.00 48.45           C  
ATOM   1536  N   ILE B  36      -3.318  25.951  -9.231  1.00 51.18           N  
ATOM   1537  CA  ILE B  36      -4.385  26.061 -10.232  1.00 52.62           C  
ATOM   1538  C   ILE B  36      -5.008  27.482 -10.259  1.00 53.51           C  
ATOM   1539  O   ILE B  36      -5.214  28.081 -11.326  1.00 53.00           O  
ATOM   1540  CB  ILE B  36      -5.509  25.021  -9.984  1.00 52.84           C  
ATOM   1541  CG1 ILE B  36      -4.952  23.583 -10.041  1.00 51.93           C  
ATOM   1542  CG2 ILE B  36      -6.659  25.242 -10.971  1.00 51.18           C  
ATOM   1543  CD1 ILE B  36      -4.153  23.272 -11.271  1.00 52.18           C  
ATOM   1544  N   ILE B  37      -5.312  27.996  -9.071  1.00 54.87           N  
ATOM   1545  CA  ILE B  37      -5.788  29.359  -8.912  1.00 55.74           C  
ATOM   1546  C   ILE B  37      -4.787  30.353  -9.553  1.00 56.81           C  
ATOM   1547  O   ILE B  37      -5.182  31.269 -10.311  1.00 55.67           O  
ATOM   1548  CB  ILE B  37      -6.038  29.685  -7.415  1.00 55.90           C  
ATOM   1549  CG1 ILE B  37      -7.242  28.895  -6.884  1.00 55.99           C  
ATOM   1550  CG2 ILE B  37      -6.274  31.189  -7.216  1.00 55.55           C  
ATOM   1551  CD1 ILE B  37      -7.240  28.722  -5.358  1.00 56.50           C  
ATOM   1552  N   ASP B  38      -3.494  30.164  -9.259  1.00 57.80           N  
ATOM   1553  CA  ASP B  38      -2.453  31.010  -9.841  1.00 58.25           C  
ATOM   1554  C   ASP B  38      -2.517  30.992 -11.370  1.00 58.76           C  
ATOM   1555  O   ASP B  38      -2.475  32.048 -12.020  1.00 58.55           O  
ATOM   1556  CB  ASP B  38      -1.066  30.568  -9.365  1.00 58.64           C  
ATOM   1557  CG  ASP B  38       0.060  31.458  -9.899  1.00 59.66           C  
ATOM   1558  OD1 ASP B  38       0.188  32.618  -9.426  1.00 60.66           O  
ATOM   1559  OD2 ASP B  38       0.836  30.982 -10.765  1.00 62.57           O  
ATOM   1560  N   TYR B  39      -2.628  29.791 -11.929  1.00 58.84           N  
ATOM   1561  CA  TYR B  39      -2.675  29.602 -13.365  1.00 59.17           C  
ATOM   1562  C   TYR B  39      -3.853  30.343 -13.989  1.00 59.38           C  
ATOM   1563  O   TYR B  39      -3.676  31.100 -14.944  1.00 58.65           O  
ATOM   1564  CB  TYR B  39      -2.768  28.120 -13.671  1.00 59.06           C  
ATOM   1565  CG  TYR B  39      -2.951  27.785 -15.111  1.00 58.84           C  
ATOM   1566  CD1 TYR B  39      -2.050  28.223 -16.068  1.00 60.33           C  
ATOM   1567  CD2 TYR B  39      -4.015  26.998 -15.520  1.00 60.14           C  
ATOM   1568  CE1 TYR B  39      -2.210  27.892 -17.416  1.00 60.84           C  
ATOM   1569  CE2 TYR B  39      -4.198  26.665 -16.855  1.00 60.43           C  
ATOM   1570  CZ  TYR B  39      -3.297  27.114 -17.802  1.00 60.91           C  
ATOM   1571  OH  TYR B  39      -3.493  26.775 -19.129  1.00 60.92           O  
ATOM   1572  N   LEU B  40      -5.047  30.135 -13.441  1.00 60.26           N  
ATOM   1573  CA  LEU B  40      -6.284  30.692 -14.051  1.00 61.36           C  
ATOM   1574  C   LEU B  40      -6.341  32.230 -14.001  1.00 62.19           C  
ATOM   1575  O   LEU B  40      -6.834  32.861 -14.926  1.00 62.55           O  
ATOM   1576  CB  LEU B  40      -7.529  30.052 -13.423  1.00 60.38           C  
ATOM   1577  CG  LEU B  40      -7.674  28.542 -13.678  1.00 59.16           C  
ATOM   1578  CD1 LEU B  40      -8.777  27.929 -12.827  1.00 56.73           C  
ATOM   1579  CD2 LEU B  40      -7.917  28.232 -15.148  1.00 56.74           C  
ATOM   1580  N   SER B  41      -5.790  32.816 -12.941  1.00 63.89           N  
ATOM   1581  CA  SER B  41      -5.718  34.271 -12.775  1.00 65.26           C  
ATOM   1582  C   SER B  41      -4.856  34.990 -13.820  1.00 66.47           C  
ATOM   1583  O   SER B  41      -5.215  36.085 -14.284  1.00 66.53           O  
ATOM   1584  CB  SER B  41      -5.180  34.602 -11.395  1.00 65.33           C  
ATOM   1585  OG  SER B  41      -5.787  33.764 -10.429  1.00 66.83           O  
ATOM   1586  N   ARG B  42      -3.727  34.373 -14.179  1.00 67.65           N  
ATOM   1587  CA  ARG B  42      -2.831  34.887 -15.225  1.00 68.50           C  
ATOM   1588  C   ARG B  42      -3.403  34.675 -16.625  1.00 68.90           C  
ATOM   1589  O   ARG B  42      -2.925  35.275 -17.575  1.00 69.09           O  
ATOM   1590  CB  ARG B  42      -1.459  34.195 -15.149  1.00 68.89           C  
ATOM   1591  CG  ARG B  42      -0.696  34.389 -13.830  1.00 69.52           C  
ATOM   1592  CD  ARG B  42       0.652  33.644 -13.838  1.00 69.72           C  
ATOM   1593  NE  ARG B  42       1.262  33.608 -12.514  1.00 70.26           N  
ATOM   1594  CZ  ARG B  42       1.978  34.591 -11.962  1.00 71.61           C  
ATOM   1595  NH1 ARG B  42       2.482  34.431 -10.740  1.00 72.77           N  
ATOM   1596  NH2 ARG B  42       2.208  35.729 -12.603  1.00 72.09           N  
ATOM   1597  N   ASN B  43      -4.405  33.806 -16.746  1.00 69.56           N  
ATOM   1598  CA  ASN B  43      -5.005  33.450 -18.031  1.00 70.40           C  
ATOM   1599  C   ASN B  43      -6.517  33.814 -18.153  1.00 71.00           C  
ATOM   1600  O   ASN B  43      -7.261  33.166 -18.896  1.00 70.60           O  
ATOM   1601  CB  ASN B  43      -4.773  31.954 -18.284  1.00 70.07           C  
ATOM   1602  CG  ASN B  43      -3.286  31.601 -18.447  1.00 69.80           C  
ATOM   1603  OD1 ASN B  43      -2.500  31.650 -17.496  1.00 68.12           O  
ATOM   1604  ND2 ASN B  43      -2.911  31.218 -19.654  1.00 69.91           N  
ATOM   1605  N   LYS B  44      -6.947  34.858 -17.438  1.00 71.98           N  
ATOM   1606  CA  LYS B  44      -8.351  35.358 -17.486  1.00 72.87           C  
ATOM   1607  C   LYS B  44      -8.763  35.930 -18.848  1.00 73.38           C  
ATOM   1608  O   LYS B  44      -9.945  35.940 -19.188  1.00 73.43           O  
ATOM   1609  CB  LYS B  44      -8.581  36.442 -16.424  1.00 72.83           C  
ATOM   1610  CG  LYS B  44      -8.642  35.923 -15.006  1.00 72.98           C  
ATOM   1611  CD  LYS B  44      -8.819  37.056 -14.013  1.00 72.99           C  
ATOM   1612  CE  LYS B  44      -9.136  36.523 -12.620  1.00 73.10           C  
ATOM   1613  NZ  LYS B  44      -9.639  37.608 -11.729  1.00 73.17           N  
ATOM   1614  N   ASN B  45      -7.778  36.409 -19.607  1.00 74.22           N  
ATOM   1615  CA  ASN B  45      -8.000  37.019 -20.931  1.00 74.51           C  
ATOM   1616  C   ASN B  45      -8.608  36.043 -21.921  1.00 74.56           C  
ATOM   1617  O   ASN B  45      -9.369  36.446 -22.797  1.00 74.75           O  
ATOM   1618  CB  ASN B  45      -6.682  37.530 -21.531  1.00 74.96           C  
ATOM   1619  CG  ASN B  45      -5.862  38.341 -20.546  1.00 76.37           C  
ATOM   1620  OD1 ASN B  45      -6.180  39.507 -20.283  1.00 76.44           O  
ATOM   1621  ND2 ASN B  45      -4.799  37.722 -19.983  1.00 77.46           N  
ATOM   1622  N   LYS B  46      -8.255  34.765 -21.792  1.00 74.30           N  
ATOM   1623  CA  LYS B  46      -8.713  33.756 -22.740  1.00 73.97           C  
ATOM   1624  C   LYS B  46      -9.368  32.556 -22.049  1.00 73.17           C  
ATOM   1625  O   LYS B  46      -9.420  32.476 -20.823  1.00 72.87           O  
ATOM   1626  CB  LYS B  46      -7.547  33.315 -23.639  1.00 74.18           C  
ATOM   1627  CG  LYS B  46      -7.897  33.231 -25.143  1.00 74.94           C  
ATOM   1628  CD  LYS B  46      -6.656  33.400 -26.028  1.00 75.01           C  
ATOM   1629  CE  LYS B  46      -5.553  32.382 -25.680  1.00 75.20           C  
ATOM   1630  NZ  LYS B  46      -4.322  32.587 -26.499  1.00 75.56           N  
ATOM   1631  N   GLU B  47      -9.885  31.644 -22.866  1.00 72.23           N  
ATOM   1632  CA  GLU B  47     -10.600  30.473 -22.383  1.00 71.69           C  
ATOM   1633  C   GLU B  47      -9.659  29.323 -22.088  1.00 69.90           C  
ATOM   1634  O   GLU B  47      -9.000  28.787 -22.990  1.00 69.92           O  
ATOM   1635  CB  GLU B  47     -11.638  30.028 -23.401  1.00 71.55           C  
ATOM   1636  CG  GLU B  47     -12.852  30.924 -23.402  1.00 72.14           C  
ATOM   1637  CD  GLU B  47     -13.702  30.752 -24.623  1.00 72.32           C  
ATOM   1638  OE1 GLU B  47     -13.160  30.339 -25.667  1.00 73.40           O  
ATOM   1639  OE2 GLU B  47     -14.915  31.036 -24.539  1.00 72.37           O  
ATOM   1640  N   VAL B  48      -9.614  28.958 -20.809  1.00 67.65           N  
ATOM   1641  CA  VAL B  48      -8.875  27.807 -20.338  1.00 65.58           C  
ATOM   1642  C   VAL B  48      -9.830  26.624 -20.276  1.00 64.64           C  
ATOM   1643  O   VAL B  48     -10.685  26.571 -19.392  1.00 64.18           O  
ATOM   1644  CB  VAL B  48      -8.304  28.063 -18.909  1.00 65.77           C  
ATOM   1645  CG1 VAL B  48      -7.633  26.811 -18.358  1.00 64.68           C  
ATOM   1646  CG2 VAL B  48      -7.358  29.252 -18.906  1.00 65.39           C  
ATOM   1647  N   LEU B  49      -9.711  25.687 -21.210  1.00 63.23           N  
ATOM   1648  CA  LEU B  49     -10.402  24.402 -21.070  1.00 62.75           C  
ATOM   1649  C   LEU B  49      -9.601  23.493 -20.123  1.00 62.20           C  
ATOM   1650  O   LEU B  49      -8.424  23.759 -19.836  1.00 61.42           O  
ATOM   1651  CB  LEU B  49     -10.554  23.717 -22.417  1.00 62.17           C  
ATOM   1652  CG  LEU B  49     -11.268  24.520 -23.500  1.00 62.54           C  
ATOM   1653  CD1 LEU B  49     -11.357  23.681 -24.750  1.00 61.80           C  
ATOM   1654  CD2 LEU B  49     -12.656  24.965 -23.065  1.00 61.18           C  
ATOM   1655  N   GLN B  50     -10.230  22.418 -19.650  1.00 61.56           N  
ATOM   1656  CA  GLN B  50      -9.525  21.421 -18.846  1.00 61.08           C  
ATOM   1657  C   GLN B  50      -8.326  20.856 -19.604  1.00 60.33           C  
ATOM   1658  O   GLN B  50      -7.280  20.622 -19.014  1.00 59.99           O  
ATOM   1659  CB  GLN B  50     -10.449  20.280 -18.423  1.00 61.14           C  
ATOM   1660  CG  GLN B  50      -9.752  19.262 -17.504  1.00 61.50           C  
ATOM   1661  CD  GLN B  50     -10.653  18.126 -17.063  1.00 61.76           C  
ATOM   1662  OE1 GLN B  50     -11.552  18.320 -16.242  1.00 63.19           O  
ATOM   1663  NE2 GLN B  50     -10.404  16.927 -17.592  1.00 62.92           N  
ATOM   1664  N   ARG B  51      -8.486  20.628 -20.903  1.00 59.46           N  
ATOM   1665  CA  ARG B  51      -7.390  20.131 -21.740  1.00 59.32           C  
ATOM   1666  C   ARG B  51      -6.163  21.071 -21.783  1.00 58.15           C  
ATOM   1667  O   ARG B  51      -5.030  20.609 -21.919  1.00 57.65           O  
ATOM   1668  CB  ARG B  51      -7.880  19.836 -23.167  1.00 59.23           C  
ATOM   1669  CG  ARG B  51      -8.822  20.881 -23.737  1.00 60.91           C  
ATOM   1670  CD  ARG B  51      -8.635  21.129 -25.224  1.00 61.64           C  
ATOM   1671  NE  ARG B  51      -7.530  22.067 -25.454  1.00 64.02           N  
ATOM   1672  CZ  ARG B  51      -7.489  23.003 -26.408  1.00 65.11           C  
ATOM   1673  NH1 ARG B  51      -8.496  23.175 -27.273  1.00 66.68           N  
ATOM   1674  NH2 ARG B  51      -6.419  23.786 -26.500  1.00 65.87           N  
ATOM   1675  N   ASP B  52      -6.404  22.379 -21.677  1.00 56.89           N  
ATOM   1676  CA  ASP B  52      -5.335  23.377 -21.596  1.00 55.93           C  
ATOM   1677  C   ASP B  52      -4.588  23.272 -20.274  1.00 55.30           C  
ATOM   1678  O   ASP B  52      -3.383  23.494 -20.222  1.00 54.52           O  
ATOM   1679  CB  ASP B  52      -5.900  24.796 -21.711  1.00 55.54           C  
ATOM   1680  CG  ASP B  52      -6.554  25.077 -23.070  1.00 54.04           C  
ATOM   1681  OD1 ASP B  52      -5.859  24.999 -24.106  1.00 51.04           O  
ATOM   1682  OD2 ASP B  52      -7.759  25.396 -23.079  1.00 50.38           O  
ATOM   1683  N   LEU B  53      -5.324  22.975 -19.207  1.00 54.71           N  
ATOM   1684  CA  LEU B  53      -4.739  22.751 -17.879  1.00 54.60           C  
ATOM   1685  C   LEU B  53      -3.917  21.458 -17.895  1.00 54.05           C  
ATOM   1686  O   LEU B  53      -2.803  21.423 -17.360  1.00 53.46           O  
ATOM   1687  CB  LEU B  53      -5.857  22.674 -16.817  1.00 54.96           C  
ATOM   1688  CG  LEU B  53      -5.519  22.836 -15.334  1.00 54.92           C  
ATOM   1689  CD1 LEU B  53      -6.713  23.411 -14.549  1.00 56.22           C  
ATOM   1690  CD2 LEU B  53      -5.095  21.512 -14.737  1.00 57.04           C  
ATOM   1691  N   GLU B  54      -4.465  20.413 -18.529  1.00 53.17           N  
ATOM   1692  CA  GLU B  54      -3.800  19.113 -18.626  1.00 53.17           C  
ATOM   1693  C   GLU B  54      -2.443  19.214 -19.296  1.00 52.47           C  
ATOM   1694  O   GLU B  54      -1.470  18.623 -18.841  1.00 51.62           O  
ATOM   1695  CB  GLU B  54      -4.673  18.123 -19.384  1.00 53.07           C  
ATOM   1696  CG  GLU B  54      -5.790  17.519 -18.531  1.00 53.42           C  
ATOM   1697  CD  GLU B  54      -6.879  16.818 -19.354  1.00 54.33           C  
ATOM   1698  OE1 GLU B  54      -7.993  16.652 -18.810  1.00 54.77           O  
ATOM   1699  OE2 GLU B  54      -6.639  16.441 -20.533  1.00 56.35           O  
ATOM   1700  N   SER B  55      -2.407  19.965 -20.389  1.00 52.63           N  
ATOM   1701  CA  SER B  55      -1.201  20.210 -21.179  1.00 52.54           C  
ATOM   1702  C   SER B  55      -0.180  20.979 -20.340  1.00 52.08           C  
ATOM   1703  O   SER B  55       0.979  20.563 -20.233  1.00 52.95           O  
ATOM   1704  CB  SER B  55      -1.576  20.993 -22.458  1.00 52.89           C  
ATOM   1705  OG  SER B  55      -0.885  20.506 -23.601  1.00 54.89           O  
ATOM   1706  N   GLU B  56      -0.625  22.059 -19.706  1.00 51.33           N  
ATOM   1707  CA  GLU B  56       0.232  22.928 -18.893  1.00 51.43           C  
ATOM   1708  C   GLU B  56       0.860  22.281 -17.613  1.00 51.30           C  
ATOM   1709  O   GLU B  56       1.976  22.633 -17.208  1.00 50.57           O  
ATOM   1710  CB  GLU B  56      -0.581  24.143 -18.482  1.00 51.87           C  
ATOM   1711  CG  GLU B  56       0.158  25.200 -17.696  1.00 52.90           C  
ATOM   1712  CD  GLU B  56       1.055  26.054 -18.553  1.00 57.55           C  
ATOM   1713  OE1 GLU B  56       0.938  26.015 -19.800  1.00 57.60           O  
ATOM   1714  OE2 GLU B  56       1.901  26.774 -17.962  1.00 61.74           O  
ATOM   1715  N   PHE B  57       0.131  21.377 -16.966  1.00 50.25           N  
ATOM   1716  CA  PHE B  57       0.621  20.736 -15.753  1.00 50.05           C  
ATOM   1717  C   PHE B  57       1.069  19.304 -15.988  1.00 49.92           C  
ATOM   1718  O   PHE B  57       1.497  18.612 -15.047  1.00 48.36           O  
ATOM   1719  CB  PHE B  57      -0.451  20.824 -14.679  1.00 48.92           C  
ATOM   1720  CG  PHE B  57      -0.649  22.201 -14.198  1.00 47.97           C  
ATOM   1721  CD1 PHE B  57      -1.554  23.056 -14.823  1.00 48.14           C  
ATOM   1722  CD2 PHE B  57       0.120  22.684 -13.176  1.00 47.40           C  
ATOM   1723  CE1 PHE B  57      -1.714  24.345 -14.380  1.00 48.44           C  
ATOM   1724  CE2 PHE B  57      -0.040  23.973 -12.715  1.00 49.68           C  
ATOM   1725  CZ  PHE B  57      -0.953  24.813 -13.328  1.00 48.81           C  
ATOM   1726  N   SER B  58       0.967  18.900 -17.251  1.00 50.98           N  
ATOM   1727  CA  SER B  58       1.324  17.566 -17.724  1.00 53.01           C  
ATOM   1728  C   SER B  58       0.694  16.500 -16.836  1.00 53.69           C  
ATOM   1729  O   SER B  58       1.365  15.630 -16.336  1.00 53.14           O  
ATOM   1730  CB  SER B  58       2.857  17.412 -17.861  1.00 52.69           C  
ATOM   1731  OG  SER B  58       3.214  16.216 -18.532  1.00 51.76           O  
ATOM   1732  N   ILE B  59      -0.629  16.585 -16.684  1.00 55.45           N  
ATOM   1733  CA  ILE B  59      -1.397  15.619 -15.903  1.00 56.70           C  
ATOM   1734  C   ILE B  59      -2.445  14.967 -16.779  1.00 57.78           C  
ATOM   1735  O   ILE B  59      -2.888  15.545 -17.778  1.00 57.90           O  
ATOM   1736  CB  ILE B  59      -2.079  16.247 -14.640  1.00 56.64           C  
ATOM   1737  CG1 ILE B  59      -2.895  17.493 -14.988  1.00 56.78           C  
ATOM   1738  CG2 ILE B  59      -1.034  16.595 -13.567  1.00 56.66           C  
ATOM   1739  CD1 ILE B  59      -3.656  18.056 -13.805  1.00 57.11           C  
ATOM   1740  N   LYS B  60      -2.838  13.762 -16.383  1.00 59.42           N  
ATOM   1741  CA  LYS B  60      -3.844  12.967 -17.107  1.00 60.44           C  
ATOM   1742  C   LYS B  60      -5.249  13.523 -16.914  1.00 60.44           C  
ATOM   1743  O   LYS B  60      -5.534  14.227 -15.956  1.00 59.92           O  
ATOM   1744  CB  LYS B  60      -3.838  11.508 -16.626  1.00 60.98           C  
ATOM   1745  CG  LYS B  60      -2.467  10.811 -16.599  1.00 62.13           C  
ATOM   1746  CD  LYS B  60      -2.564   9.530 -15.746  1.00 62.46           C  
ATOM   1747  CE  LYS B  60      -1.426   8.520 -16.019  1.00 63.96           C  
ATOM   1748  NZ  LYS B  60      -1.862   7.081 -15.774  1.00 64.59           N  
ATOM   1749  N   SER B  61      -6.135  13.168 -17.830  1.00 61.51           N  
ATOM   1750  CA  SER B  61      -7.559  13.525 -17.729  1.00 61.69           C  
ATOM   1751  C   SER B  61      -8.188  13.109 -16.398  1.00 61.98           C  
ATOM   1752  O   SER B  61      -8.831  13.922 -15.722  1.00 61.49           O  
ATOM   1753  CB  SER B  61      -8.318  12.901 -18.889  1.00 61.78           C  
ATOM   1754  OG  SER B  61      -7.684  13.257 -20.100  1.00 62.09           O  
ATOM   1755  N   SER B  62      -7.977  11.845 -16.030  1.00 62.37           N  
ATOM   1756  CA  SER B  62      -8.455  11.293 -14.755  1.00 62.54           C  
ATOM   1757  C   SER B  62      -8.023  12.133 -13.545  1.00 62.71           C  
ATOM   1758  O   SER B  62      -8.824  12.407 -12.646  1.00 62.88           O  
ATOM   1759  CB  SER B  62      -7.971   9.841 -14.598  1.00 62.63           C  
ATOM   1760  OG  SER B  62      -6.665   9.662 -15.131  1.00 62.60           O  
ATOM   1761  N   THR B  63      -6.759  12.545 -13.550  1.00 62.77           N  
ATOM   1762  CA  THR B  63      -6.168  13.316 -12.461  1.00 62.75           C  
ATOM   1763  C   THR B  63      -6.745  14.742 -12.424  1.00 62.69           C  
ATOM   1764  O   THR B  63      -7.143  15.240 -11.364  1.00 62.68           O  
ATOM   1765  CB  THR B  63      -4.618  13.356 -12.616  1.00 62.92           C  
ATOM   1766  OG1 THR B  63      -4.129  12.037 -12.914  1.00 63.63           O  
ATOM   1767  CG2 THR B  63      -3.935  13.892 -11.350  1.00 62.93           C  
ATOM   1768  N   ALA B  64      -6.804  15.386 -13.589  1.00 62.47           N  
ATOM   1769  CA  ALA B  64      -7.374  16.733 -13.718  1.00 62.72           C  
ATOM   1770  C   ALA B  64      -8.874  16.733 -13.376  1.00 62.87           C  
ATOM   1771  O   ALA B  64      -9.366  17.612 -12.650  1.00 62.32           O  
ATOM   1772  CB  ALA B  64      -7.162  17.261 -15.129  1.00 62.39           C  
ATOM   1773  N   THR B  65      -9.581  15.742 -13.916  1.00 63.05           N  
ATOM   1774  CA  THR B  65     -11.005  15.520 -13.616  1.00 63.31           C  
ATOM   1775  C   THR B  65     -11.254  15.629 -12.115  1.00 63.39           C  
ATOM   1776  O   THR B  65     -11.976  16.521 -11.661  1.00 63.19           O  
ATOM   1777  CB  THR B  65     -11.460  14.128 -14.108  1.00 62.99           C  
ATOM   1778  OG1 THR B  65     -11.528  14.126 -15.538  1.00 61.89           O  
ATOM   1779  CG2 THR B  65     -12.812  13.771 -13.531  1.00 63.46           C  
ATOM   1780  N   VAL B  66     -10.605  14.740 -11.366  1.00 63.60           N  
ATOM   1781  CA  VAL B  66     -10.790  14.607  -9.924  1.00 63.72           C  
ATOM   1782  C   VAL B  66     -10.336  15.858  -9.134  1.00 64.04           C  
ATOM   1783  O   VAL B  66     -10.955  16.222  -8.129  1.00 63.94           O  
ATOM   1784  CB  VAL B  66     -10.066  13.332  -9.410  1.00 64.01           C  
ATOM   1785  CG1 VAL B  66     -10.164  13.205  -7.885  1.00 64.07           C  
ATOM   1786  CG2 VAL B  66     -10.628  12.087 -10.107  1.00 63.96           C  
ATOM   1787  N   LEU B  67      -9.266  16.515  -9.581  1.00 63.96           N  
ATOM   1788  CA  LEU B  67      -8.798  17.774  -8.960  1.00 63.96           C  
ATOM   1789  C   LEU B  67      -9.798  18.930  -9.136  1.00 63.41           C  
ATOM   1790  O   LEU B  67     -10.064  19.692  -8.202  1.00 62.73           O  
ATOM   1791  CB  LEU B  67      -7.444  18.218  -9.549  1.00 64.10           C  
ATOM   1792  CG  LEU B  67      -6.200  18.194  -8.638  1.00 66.67           C  
ATOM   1793  CD1 LEU B  67      -4.931  17.874  -9.450  1.00 68.16           C  
ATOM   1794  CD2 LEU B  67      -6.025  19.519  -7.859  1.00 67.74           C  
ATOM   1795  N   LEU B  68     -10.300  19.092 -10.354  1.00 63.06           N  
ATOM   1796  CA  LEU B  68     -11.249  20.170 -10.651  1.00 63.49           C  
ATOM   1797  C   LEU B  68     -12.592  19.956  -9.933  1.00 63.39           C  
ATOM   1798  O   LEU B  68     -13.196  20.916  -9.467  1.00 62.90           O  
ATOM   1799  CB  LEU B  68     -11.434  20.324 -12.166  1.00 62.99           C  
ATOM   1800  CG  LEU B  68     -10.164  20.794 -12.896  1.00 62.27           C  
ATOM   1801  CD1 LEU B  68     -10.287  20.616 -14.395  1.00 59.10           C  
ATOM   1802  CD2 LEU B  68      -9.868  22.235 -12.547  1.00 61.31           C  
ATOM   1803  N   GLN B  69     -13.023  18.695  -9.834  1.00 63.77           N  
ATOM   1804  CA  GLN B  69     -14.243  18.324  -9.102  1.00 64.11           C  
ATOM   1805  C   GLN B  69     -14.206  18.910  -7.698  1.00 63.49           C  
ATOM   1806  O   GLN B  69     -15.137  19.577  -7.266  1.00 63.72           O  
ATOM   1807  CB  GLN B  69     -14.380  16.796  -9.002  1.00 64.48           C  
ATOM   1808  CG  GLN B  69     -14.578  16.065 -10.337  1.00 66.07           C  
ATOM   1809  CD  GLN B  69     -16.023  15.745 -10.677  1.00 69.39           C  
ATOM   1810  OE1 GLN B  69     -16.963  16.090  -9.943  1.00 71.61           O  
ATOM   1811  NE2 GLN B  69     -16.212  15.070 -11.810  1.00 70.88           N  
ATOM   1812  N   ARG B  70     -13.104  18.675  -7.004  1.00 62.79           N  
ATOM   1813  CA  ARG B  70     -12.973  19.075  -5.609  1.00 61.93           C  
ATOM   1814  C   ARG B  70     -13.023  20.587  -5.406  1.00 61.18           C  
ATOM   1815  O   ARG B  70     -13.652  21.072  -4.456  1.00 60.32           O  
ATOM   1816  CB  ARG B  70     -11.659  18.538  -5.026  1.00 62.89           C  
ATOM   1817  CG  ARG B  70     -11.345  19.034  -3.613  1.00 63.70           C  
ATOM   1818  CD  ARG B  70     -12.230  18.343  -2.598  1.00 66.79           C  
ATOM   1819  NE  ARG B  70     -12.384  19.056  -1.332  1.00 67.64           N  
ATOM   1820  CZ  ARG B  70     -11.418  19.282  -0.434  1.00 70.46           C  
ATOM   1821  NH1 ARG B  70     -11.740  19.912   0.702  1.00 70.79           N  
ATOM   1822  NH2 ARG B  70     -10.137  18.907  -0.647  1.00 70.84           N  
HETATM 1823  N   MSE B  71     -12.318  21.312  -6.274  1.00 60.13           N  
HETATM 1824  CA  MSE B  71     -12.260  22.777  -6.209  1.00 59.20           C  
HETATM 1825  C   MSE B  71     -13.634  23.389  -6.495  1.00 59.03           C  
HETATM 1826  O   MSE B  71     -13.949  24.464  -5.974  1.00 58.04           O  
HETATM 1827  CB  MSE B  71     -11.209  23.337  -7.188  1.00 58.63           C  
HETATM 1828  CG  MSE B  71      -9.773  22.914  -6.881  1.00 57.84           C  
HETATM 1829 SE   MSE B  71      -8.387  23.520  -8.194  0.70 54.64          SE  
HETATM 1830  CE  MSE B  71      -8.569  25.506  -8.030  1.00 52.40           C  
ATOM   1831  N   GLU B  72     -14.443  22.714  -7.316  1.00 59.26           N  
ATOM   1832  CA  GLU B  72     -15.807  23.186  -7.594  1.00 59.60           C  
ATOM   1833  C   GLU B  72     -16.653  22.983  -6.330  1.00 59.27           C  
ATOM   1834  O   GLU B  72     -17.261  23.923  -5.839  1.00 58.13           O  
ATOM   1835  CB  GLU B  72     -16.423  22.473  -8.813  1.00 59.76           C  
ATOM   1836  CG  GLU B  72     -17.482  23.330  -9.542  1.00 59.94           C  
ATOM   1837  CD  GLU B  72     -17.936  22.767 -10.896  1.00 60.45           C  
ATOM   1838  OE1 GLU B  72     -17.102  22.111 -11.578  1.00 59.62           O  
ATOM   1839  OE2 GLU B  72     -19.130  23.010 -11.271  1.00 59.52           O  
ATOM   1840  N   ILE B  73     -16.612  21.761  -5.794  1.00 59.53           N  
ATOM   1841  CA  ILE B  73     -17.176  21.419  -4.475  1.00 59.46           C  
ATOM   1842  C   ILE B  73     -16.763  22.417  -3.365  1.00 59.22           C  
ATOM   1843  O   ILE B  73     -17.589  22.817  -2.528  1.00 59.32           O  
ATOM   1844  CB  ILE B  73     -16.814  19.951  -4.075  1.00 59.57           C  
ATOM   1845  CG1 ILE B  73     -17.617  18.954  -4.928  1.00 59.90           C  
ATOM   1846  CG2 ILE B  73     -17.082  19.707  -2.591  1.00 59.56           C  
ATOM   1847  CD1 ILE B  73     -17.230  17.486  -4.721  1.00 59.42           C  
ATOM   1848  N   LYS B  74     -15.506  22.840  -3.395  1.00 58.26           N  
ATOM   1849  CA  LYS B  74     -14.977  23.879  -2.499  1.00 57.99           C  
ATOM   1850  C   LYS B  74     -15.355  25.306  -2.929  1.00 57.01           C  
ATOM   1851  O   LYS B  74     -14.925  26.268  -2.299  1.00 55.54           O  
ATOM   1852  CB  LYS B  74     -13.424  23.790  -2.435  1.00 58.31           C  
ATOM   1853  CG  LYS B  74     -12.839  22.792  -1.454  1.00 58.27           C  
ATOM   1854  CD  LYS B  74     -11.302  22.933  -1.379  1.00 58.38           C  
ATOM   1855  CE  LYS B  74     -10.791  22.981   0.055  1.00 58.29           C  
ATOM   1856  NZ  LYS B  74      -9.431  23.547   0.151  1.00 58.99           N  
ATOM   1857  N   LYS B  75     -16.114  25.449  -4.018  1.00 56.89           N  
ATOM   1858  CA  LYS B  75     -16.609  26.756  -4.481  1.00 57.53           C  
ATOM   1859  C   LYS B  75     -15.503  27.726  -4.917  1.00 57.26           C  
ATOM   1860  O   LYS B  75     -15.641  28.947  -4.788  1.00 56.47           O  
ATOM   1861  CB  LYS B  75     -17.536  27.390  -3.420  1.00 57.49           C  
ATOM   1862  CG  LYS B  75     -18.955  26.818  -3.439  1.00 58.26           C  
ATOM   1863  CD  LYS B  75     -19.579  26.749  -2.052  1.00 58.30           C  
ATOM   1864  CE  LYS B  75     -21.113  26.836  -2.089  1.00 59.16           C  
ATOM   1865  NZ  LYS B  75     -21.622  28.251  -1.886  1.00 59.20           N  
ATOM   1866  N   LEU B  76     -14.414  27.165  -5.458  1.00 57.57           N  
ATOM   1867  CA  LEU B  76     -13.240  27.941  -5.907  1.00 57.44           C  
ATOM   1868  C   LEU B  76     -13.266  28.215  -7.408  1.00 57.61           C  
ATOM   1869  O   LEU B  76     -12.707  29.215  -7.868  1.00 56.63           O  
ATOM   1870  CB  LEU B  76     -11.943  27.196  -5.558  1.00 57.17           C  
ATOM   1871  CG  LEU B  76     -11.625  27.026  -4.075  1.00 56.38           C  
ATOM   1872  CD1 LEU B  76     -10.525  25.966  -3.896  1.00 56.66           C  
ATOM   1873  CD2 LEU B  76     -11.215  28.371  -3.501  1.00 55.62           C  
ATOM   1874  N   LEU B  77     -13.884  27.302  -8.155  1.00 58.33           N  
ATOM   1875  CA  LEU B  77     -14.084  27.459  -9.579  1.00 59.29           C  
ATOM   1876  C   LEU B  77     -15.465  26.977  -9.999  1.00 60.55           C  
ATOM   1877  O   LEU B  77     -16.239  26.465  -9.197  1.00 60.62           O  
ATOM   1878  CB  LEU B  77     -13.003  26.712 -10.364  1.00 59.59           C  
ATOM   1879  CG  LEU B  77     -12.729  25.219 -10.120  1.00 59.48           C  
ATOM   1880  CD1 LEU B  77     -13.712  24.352 -10.912  1.00 59.86           C  
ATOM   1881  CD2 LEU B  77     -11.281  24.887 -10.501  1.00 58.92           C  
ATOM   1882  N   TYR B  78     -15.786  27.216 -11.260  1.00 61.54           N  
ATOM   1883  CA  TYR B  78     -16.934  26.598 -11.894  1.00 62.55           C  
ATOM   1884  C   TYR B  78     -16.606  26.386 -13.376  1.00 63.31           C  
ATOM   1885  O   TYR B  78     -15.595  26.896 -13.890  1.00 62.81           O  
ATOM   1886  CB  TYR B  78     -18.224  27.440 -11.695  1.00 61.41           C  
ATOM   1887  CG  TYR B  78     -18.168  28.838 -12.283  1.00 60.38           C  
ATOM   1888  CD1 TYR B  78     -18.705  29.120 -13.544  1.00 59.07           C  
ATOM   1889  CD2 TYR B  78     -17.564  29.878 -11.582  1.00 59.93           C  
ATOM   1890  CE1 TYR B  78     -18.637  30.414 -14.086  1.00 59.38           C  
ATOM   1891  CE2 TYR B  78     -17.491  31.170 -12.115  1.00 59.96           C  
ATOM   1892  CZ  TYR B  78     -18.024  31.428 -13.359  1.00 59.56           C  
ATOM   1893  OH  TYR B  78     -17.925  32.701 -13.853  1.00 59.74           O  
ATOM   1894  N   ARG B  79     -17.468  25.623 -14.039  1.00 64.67           N  
ATOM   1895  CA  ARG B  79     -17.380  25.379 -15.467  1.00 65.46           C  
ATOM   1896  C   ARG B  79     -18.396  26.294 -16.169  1.00 66.06           C  
ATOM   1897  O   ARG B  79     -19.546  26.429 -15.727  1.00 65.36           O  
ATOM   1898  CB  ARG B  79     -17.680  23.909 -15.768  1.00 66.38           C  
ATOM   1899  CG  ARG B  79     -17.045  22.898 -14.788  1.00 67.77           C  
ATOM   1900  CD  ARG B  79     -15.871  22.159 -15.387  1.00 70.25           C  
ATOM   1901  NE  ARG B  79     -15.570  20.923 -14.654  1.00 71.15           N  
ATOM   1902  CZ  ARG B  79     -14.697  19.990 -15.055  1.00 72.78           C  
ATOM   1903  NH1 ARG B  79     -14.029  20.131 -16.204  1.00 73.21           N  
ATOM   1904  NH2 ARG B  79     -14.497  18.899 -14.309  1.00 72.63           N  
ATOM   1905  N   LYS B  80     -17.953  26.923 -17.254  1.00 66.48           N  
ATOM   1906  CA  LYS B  80     -18.774  27.858 -18.029  1.00 66.82           C  
ATOM   1907  C   LYS B  80     -18.666  27.530 -19.527  1.00 67.00           C  
ATOM   1908  O   LYS B  80     -17.605  27.165 -20.016  1.00 66.81           O  
ATOM   1909  CB  LYS B  80     -18.320  29.297 -17.742  1.00 66.85           C  
ATOM   1910  CG  LYS B  80     -18.628  30.314 -18.837  1.00 67.40           C  
ATOM   1911  CD  LYS B  80     -17.944  31.657 -18.592  1.00 67.32           C  
ATOM   1912  CE  LYS B  80     -18.634  32.770 -19.387  1.00 67.32           C  
ATOM   1913  NZ  LYS B  80     -17.772  33.961 -19.570  1.00 68.08           N  
ATOM   1914  N   VAL B  81     -19.769  27.679 -20.252  1.00 67.36           N  
ATOM   1915  CA  VAL B  81     -19.806  27.397 -21.694  1.00 67.60           C  
ATOM   1916  C   VAL B  81     -18.798  28.277 -22.459  1.00 67.66           C  
ATOM   1917  O   VAL B  81     -18.720  29.485 -22.222  1.00 67.52           O  
ATOM   1918  CB  VAL B  81     -21.241  27.626 -22.261  1.00 67.52           C  
ATOM   1919  CG1 VAL B  81     -21.317  27.199 -23.716  1.00 67.59           C  
ATOM   1920  CG2 VAL B  81     -22.280  26.880 -21.418  1.00 67.36           C  
ATOM   1921  N   SER B  82     -18.036  27.676 -23.371  1.00 67.98           N  
ATOM   1922  CA  SER B  82     -16.987  28.410 -24.097  1.00 68.42           C  
ATOM   1923  C   SER B  82     -17.414  28.746 -25.538  1.00 68.74           C  
ATOM   1924  O   SER B  82     -18.261  28.064 -26.123  1.00 68.53           O  
ATOM   1925  CB  SER B  82     -15.641  27.642 -24.043  1.00 68.63           C  
ATOM   1926  OG  SER B  82     -15.480  26.730 -25.119  1.00 68.73           O  
ATOM   1927  N   GLY B  83     -16.843  29.826 -26.077  1.00 69.25           N  
ATOM   1928  CA  GLY B  83     -17.065  30.261 -27.465  1.00 69.50           C  
ATOM   1929  C   GLY B  83     -16.023  29.747 -28.459  1.00 69.90           C  
ATOM   1930  O   GLY B  83     -16.315  29.629 -29.651  1.00 69.67           O  
ATOM   1931  N   LYS B  84     -14.807  29.457 -27.973  1.00 70.50           N  
ATOM   1932  CA  LYS B  84     -13.753  28.786 -28.772  1.00 70.84           C  
ATOM   1933  C   LYS B  84     -14.265  27.398 -29.202  1.00 71.28           C  
ATOM   1934  O   LYS B  84     -14.700  27.204 -30.355  1.00 71.30           O  
ATOM   1935  CB  LYS B  84     -12.430  28.696 -27.961  1.00 70.87           C  
ATOM   1936  CG  LYS B  84     -11.398  27.642 -28.406  1.00 70.79           C  
ATOM   1937  CD  LYS B  84     -10.164  27.599 -27.472  1.00 71.24           C  
ATOM   1938  CE  LYS B  84     -10.457  26.990 -26.083  1.00 71.10           C  
ATOM   1939  NZ  LYS B  84      -9.192  26.736 -25.277  1.00 70.65           N  
ATOM   1940  N   ASP B  85     -14.252  26.457 -28.252  1.00 71.68           N  
ATOM   1941  CA  ASP B  85     -14.819  25.122 -28.447  1.00 71.74           C  
ATOM   1942  C   ASP B  85     -16.309  25.176 -28.125  1.00 71.61           C  
ATOM   1943  O   ASP B  85     -16.700  25.175 -26.958  1.00 71.91           O  
ATOM   1944  CB  ASP B  85     -14.109  24.088 -27.553  1.00 72.05           C  
ATOM   1945  CG  ASP B  85     -12.725  23.711 -28.074  1.00 73.27           C  
ATOM   1946  OD1 ASP B  85     -12.391  24.048 -29.235  1.00 75.05           O  
ATOM   1947  OD2 ASP B  85     -11.964  23.058 -27.324  1.00 76.04           O  
ATOM   1948  N   SER B  86     -17.133  25.228 -29.162  1.00 71.31           N  
ATOM   1949  CA  SER B  86     -18.594  25.296 -29.008  1.00 71.09           C  
ATOM   1950  C   SER B  86     -19.212  24.158 -28.167  1.00 70.88           C  
ATOM   1951  O   SER B  86     -20.421  24.178 -27.885  1.00 71.04           O  
ATOM   1952  CB  SER B  86     -19.251  25.320 -30.396  1.00 71.28           C  
ATOM   1953  OG  SER B  86     -18.416  24.685 -31.356  1.00 71.51           O  
ATOM   1954  N   ARG B  87     -18.386  23.179 -27.790  1.00 70.23           N  
ATOM   1955  CA  ARG B  87     -18.834  21.956 -27.125  1.00 69.89           C  
ATOM   1956  C   ARG B  87     -18.287  21.806 -25.700  1.00 69.38           C  
ATOM   1957  O   ARG B  87     -18.981  21.287 -24.818  1.00 69.49           O  
ATOM   1958  CB  ARG B  87     -18.399  20.746 -27.961  1.00 69.93           C  
ATOM   1959  CG  ARG B  87     -19.415  20.309 -29.020  1.00 70.62           C  
ATOM   1960  CD  ARG B  87     -18.755  19.631 -30.223  1.00 70.78           C  
ATOM   1961  NE  ARG B  87     -17.578  18.825 -29.873  1.00 71.55           N  
ATOM   1962  CZ  ARG B  87     -16.921  18.038 -30.726  1.00 72.00           C  
ATOM   1963  NH1 ARG B  87     -15.868  17.354 -30.307  1.00 72.04           N  
ATOM   1964  NH2 ARG B  87     -17.314  17.918 -31.991  1.00 73.15           N  
ATOM   1965  N   GLN B  88     -17.054  22.269 -25.483  1.00 68.51           N  
ATOM   1966  CA  GLN B  88     -16.343  22.027 -24.235  1.00 67.86           C  
ATOM   1967  C   GLN B  88     -16.500  23.175 -23.237  1.00 67.16           C  
ATOM   1968  O   GLN B  88     -16.644  24.333 -23.615  1.00 66.93           O  
ATOM   1969  CB  GLN B  88     -14.860  21.792 -24.531  1.00 67.98           C  
ATOM   1970  CG  GLN B  88     -14.115  20.970 -23.471  1.00 67.84           C  
ATOM   1971  CD  GLN B  88     -14.403  19.472 -23.553  1.00 67.99           C  
ATOM   1972  OE1 GLN B  88     -13.652  18.659 -23.000  1.00 67.83           O  
ATOM   1973  NE2 GLN B  88     -15.491  19.100 -24.238  1.00 66.12           N  
ATOM   1974  N   LYS B  89     -16.438  22.828 -21.954  1.00 66.50           N  
ATOM   1975  CA  LYS B  89     -16.587  23.790 -20.861  1.00 65.62           C  
ATOM   1976  C   LYS B  89     -15.233  24.367 -20.418  1.00 64.58           C  
ATOM   1977  O   LYS B  89     -14.231  23.641 -20.300  1.00 64.23           O  
ATOM   1978  CB  LYS B  89     -17.333  23.145 -19.681  1.00 65.72           C  
ATOM   1979  CG  LYS B  89     -18.818  23.448 -19.659  1.00 65.83           C  
ATOM   1980  CD  LYS B  89     -19.555  22.572 -18.655  1.00 66.23           C  
ATOM   1981  CE  LYS B  89     -20.829  23.249 -18.162  1.00 67.02           C  
ATOM   1982  NZ  LYS B  89     -21.933  22.288 -17.847  1.00 68.22           N  
ATOM   1983  N   CYS B  90     -15.221  25.682 -20.195  1.00 63.30           N  
ATOM   1984  CA  CYS B  90     -14.028  26.392 -19.749  1.00 62.86           C  
ATOM   1985  C   CYS B  90     -14.118  26.770 -18.270  1.00 61.46           C  
ATOM   1986  O   CYS B  90     -15.203  26.984 -17.714  1.00 60.60           O  
ATOM   1987  CB  CYS B  90     -13.748  27.627 -20.621  1.00 62.70           C  
ATOM   1988  SG  CYS B  90     -14.734  29.129 -20.292  1.00 62.35           S  
ATOM   1989  N   LEU B  91     -12.943  26.873 -17.659  1.00 59.99           N  
ATOM   1990  CA  LEU B  91     -12.805  26.988 -16.219  1.00 58.98           C  
ATOM   1991  C   LEU B  91     -12.752  28.454 -15.793  1.00 58.36           C  
ATOM   1992  O   LEU B  91     -12.016  29.252 -16.383  1.00 57.56           O  
ATOM   1993  CB  LEU B  91     -11.533  26.248 -15.754  1.00 58.83           C  
ATOM   1994  CG  LEU B  91     -11.234  24.865 -16.354  1.00 58.23           C  
ATOM   1995  CD1 LEU B  91      -9.822  24.380 -15.934  1.00 58.98           C  
ATOM   1996  CD2 LEU B  91     -12.289  23.845 -15.983  1.00 57.28           C  
ATOM   1997  N   LYS B  92     -13.522  28.793 -14.761  1.00 57.79           N  
ATOM   1998  CA  LYS B  92     -13.584  30.162 -14.246  1.00 58.34           C  
ATOM   1999  C   LYS B  92     -13.402  30.177 -12.727  1.00 57.80           C  
ATOM   2000  O   LYS B  92     -13.776  29.228 -12.061  1.00 57.08           O  
ATOM   2001  CB  LYS B  92     -14.934  30.829 -14.628  1.00 58.34           C  
ATOM   2002  CG  LYS B  92     -15.122  31.132 -16.131  1.00 58.91           C  
ATOM   2003  CD  LYS B  92     -14.181  32.260 -16.605  1.00 60.65           C  
ATOM   2004  CE  LYS B  92     -14.276  32.545 -18.114  1.00 60.30           C  
ATOM   2005  NZ  LYS B  92     -12.995  33.111 -18.696  1.00 59.80           N  
ATOM   2006  N   LEU B  93     -12.837  31.265 -12.201  1.00 57.97           N  
ATOM   2007  CA  LEU B  93     -12.707  31.482 -10.752  1.00 58.83           C  
ATOM   2008  C   LEU B  93     -13.987  32.087 -10.137  1.00 59.60           C  
ATOM   2009  O   LEU B  93     -14.567  33.023 -10.703  1.00 59.28           O  
ATOM   2010  CB  LEU B  93     -11.531  32.425 -10.457  1.00 58.06           C  
ATOM   2011  CG  LEU B  93     -10.113  31.920 -10.803  1.00 56.98           C  
ATOM   2012  CD1 LEU B  93      -9.067  32.943 -10.386  1.00 54.37           C  
ATOM   2013  CD2 LEU B  93      -9.846  30.546 -10.180  1.00 52.43           C  
ATOM   2014  N   THR B  94     -14.406  31.557  -8.985  1.00 60.43           N  
ATOM   2015  CA  THR B  94     -15.481  32.165  -8.201  1.00 61.74           C  
ATOM   2016  C   THR B  94     -14.941  33.421  -7.495  1.00 62.77           C  
ATOM   2017  O   THR B  94     -13.728  33.669  -7.492  1.00 62.42           O  
ATOM   2018  CB  THR B  94     -16.061  31.175  -7.154  1.00 61.57           C  
ATOM   2019  OG1 THR B  94     -15.046  30.833  -6.206  1.00 61.31           O  
ATOM   2020  CG2 THR B  94     -16.570  29.898  -7.821  1.00 60.76           C  
ATOM   2021  N   LYS B  95     -15.839  34.204  -6.901  1.00 64.07           N  
ATOM   2022  CA  LYS B  95     -15.466  35.408  -6.142  1.00 64.92           C  
ATOM   2023  C   LYS B  95     -14.663  35.082  -4.868  1.00 65.54           C  
ATOM   2024  O   LYS B  95     -13.858  35.900  -4.420  1.00 65.19           O  
ATOM   2025  CB  LYS B  95     -16.719  36.205  -5.760  1.00 65.08           C  
ATOM   2026  CG  LYS B  95     -16.472  37.640  -5.255  1.00 65.16           C  
ATOM   2027  CD  LYS B  95     -17.793  38.249  -4.697  1.00 65.44           C  
ATOM   2028  CE  LYS B  95     -17.616  39.608  -4.005  1.00 65.60           C  
ATOM   2029  NZ  LYS B  95     -18.903  40.094  -3.387  1.00 64.83           N  
ATOM   2030  N   LYS B  96     -14.916  33.914  -4.279  1.00 66.32           N  
ATOM   2031  CA  LYS B  96     -14.108  33.385  -3.177  1.00 67.31           C  
ATOM   2032  C   LYS B  96     -12.614  33.250  -3.573  1.00 68.04           C  
ATOM   2033  O   LYS B  96     -11.725  33.723  -2.849  1.00 67.73           O  
ATOM   2034  CB  LYS B  96     -14.675  32.018  -2.747  1.00 67.32           C  
ATOM   2035  CG  LYS B  96     -13.924  31.299  -1.638  1.00 66.95           C  
ATOM   2036  CD  LYS B  96     -14.519  29.917  -1.398  1.00 67.09           C  
ATOM   2037  CE  LYS B  96     -13.823  29.189  -0.264  1.00 66.92           C  
ATOM   2038  NZ  LYS B  96     -14.470  27.880   0.050  1.00 66.79           N  
ATOM   2039  N   ALA B  97     -12.357  32.621  -4.724  1.00 68.79           N  
ATOM   2040  CA  ALA B  97     -10.987  32.461  -5.242  1.00 69.61           C  
ATOM   2041  C   ALA B  97     -10.386  33.791  -5.682  1.00 70.29           C  
ATOM   2042  O   ALA B  97      -9.164  33.968  -5.614  1.00 70.01           O  
ATOM   2043  CB  ALA B  97     -10.954  31.467  -6.397  1.00 69.14           C  
ATOM   2044  N   ASN B  98     -11.243  34.712  -6.143  1.00 71.17           N  
ATOM   2045  CA  ASN B  98     -10.815  36.050  -6.584  1.00 72.01           C  
ATOM   2046  C   ASN B  98     -10.135  36.852  -5.479  1.00 72.44           C  
ATOM   2047  O   ASN B  98      -9.239  37.655  -5.746  1.00 71.75           O  
ATOM   2048  CB  ASN B  98     -12.010  36.874  -7.114  1.00 72.35           C  
ATOM   2049  CG  ASN B  98     -12.208  36.756  -8.622  1.00 72.83           C  
ATOM   2050  OD1 ASN B  98     -11.724  35.825  -9.270  1.00 74.25           O  
ATOM   2051  ND2 ASN B  98     -12.940  37.711  -9.184  1.00 74.38           N  
ATOM   2052  N   LYS B  99     -10.578  36.644  -4.242  1.00 73.46           N  
ATOM   2053  CA  LYS B  99     -10.052  37.386  -3.093  1.00 74.43           C  
ATOM   2054  C   LYS B  99      -8.656  36.889  -2.694  1.00 74.84           C  
ATOM   2055  O   LYS B  99      -7.844  37.652  -2.161  1.00 74.77           O  
ATOM   2056  CB  LYS B  99     -11.037  37.319  -1.912  1.00 74.65           C  
ATOM   2057  CG  LYS B  99     -12.238  38.274  -2.065  1.00 75.02           C  
ATOM   2058  CD  LYS B  99     -13.445  37.808  -1.271  1.00 74.93           C  
ATOM   2059  CE  LYS B  99     -14.575  38.817  -1.376  1.00 75.39           C  
ATOM   2060  NZ  LYS B  99     -15.818  38.352  -0.707  1.00 75.35           N  
ATOM   2061  N   LEU B 100      -8.386  35.617  -2.993  1.00 75.51           N  
ATOM   2062  CA  LEU B 100      -7.092  34.970  -2.717  1.00 75.61           C  
ATOM   2063  C   LEU B 100      -6.020  35.277  -3.781  1.00 76.05           C  
ATOM   2064  O   LEU B 100      -4.830  35.114  -3.521  1.00 75.63           O  
ATOM   2065  CB  LEU B 100      -7.296  33.457  -2.593  1.00 75.15           C  
ATOM   2066  CG  LEU B 100      -8.298  32.977  -1.532  1.00 74.30           C  
ATOM   2067  CD1 LEU B 100      -8.589  31.481  -1.626  1.00 73.49           C  
ATOM   2068  CD2 LEU B 100      -7.811  33.315  -0.138  1.00 73.95           C  
ATOM   2069  N   GLU B 101      -6.442  35.741  -4.957  1.00 76.68           N  
ATOM   2070  CA  GLU B 101      -5.537  35.973  -6.094  1.00 77.43           C  
ATOM   2071  C   GLU B 101      -4.299  36.806  -5.786  1.00 77.97           C  
ATOM   2072  O   GLU B 101      -3.182  36.403  -6.109  1.00 77.66           O  
ATOM   2073  CB  GLU B 101      -6.272  36.674  -7.236  1.00 77.34           C  
ATOM   2074  CG  GLU B 101      -7.143  35.765  -8.075  1.00 77.56           C  
ATOM   2075  CD  GLU B 101      -7.743  36.480  -9.283  1.00 77.87           C  
ATOM   2076  OE1 GLU B 101      -7.026  37.255  -9.963  1.00 76.54           O  
ATOM   2077  OE2 GLU B 101      -8.944  36.259  -9.550  1.00 79.71           O  
ATOM   2078  N   THR B 102      -4.517  37.987  -5.209  1.00 78.68           N  
ATOM   2079  CA  THR B 102      -3.429  38.940  -4.916  1.00 78.93           C  
ATOM   2080  C   THR B 102      -2.393  38.337  -3.957  1.00 79.32           C  
ATOM   2081  O   THR B 102      -1.191  38.533  -4.143  1.00 79.10           O  
ATOM   2082  CB  THR B 102      -3.978  40.264  -4.330  1.00 78.89           C  
ATOM   2083  OG1 THR B 102      -4.829  39.985  -3.206  1.00 78.14           O  
ATOM   2084  CG2 THR B 102      -4.768  41.017  -5.390  1.00 78.84           C  
ATOM   2085  N   ILE B 103      -2.885  37.600  -2.958  1.00 79.60           N  
ATOM   2086  CA  ILE B 103      -2.058  36.903  -1.975  1.00 79.82           C  
ATOM   2087  C   ILE B 103      -1.262  35.778  -2.653  1.00 80.01           C  
ATOM   2088  O   ILE B 103      -0.041  35.684  -2.501  1.00 79.96           O  
ATOM   2089  CB  ILE B 103      -2.929  36.261  -0.843  1.00 79.96           C  
ATOM   2090  CG1 ILE B 103      -3.842  37.298  -0.153  1.00 80.87           C  
ATOM   2091  CG2 ILE B 103      -2.048  35.550   0.168  1.00 79.83           C  
ATOM   2092  CD1 ILE B 103      -3.124  38.523   0.421  1.00 81.48           C  
ATOM   2093  N   ILE B 104      -1.977  34.939  -3.400  1.00 80.05           N  
ATOM   2094  CA  ILE B 104      -1.398  33.809  -4.113  1.00 79.90           C  
ATOM   2095  C   ILE B 104      -0.343  34.239  -5.134  1.00 80.40           C  
ATOM   2096  O   ILE B 104       0.774  33.734  -5.115  1.00 79.61           O  
ATOM   2097  CB  ILE B 104      -2.498  32.980  -4.806  1.00 79.49           C  
ATOM   2098  CG1 ILE B 104      -3.298  32.212  -3.752  1.00 78.54           C  
ATOM   2099  CG2 ILE B 104      -1.888  32.032  -5.834  1.00 79.38           C  
ATOM   2100  CD1 ILE B 104      -4.316  31.279  -4.320  1.00 78.82           C  
ATOM   2101  N   LEU B 105      -0.708  35.167  -6.019  1.00 81.00           N  
ATOM   2102  CA  LEU B 105       0.203  35.665  -7.067  1.00 81.55           C  
ATOM   2103  C   LEU B 105       1.429  36.368  -6.477  1.00 81.93           C  
ATOM   2104  O   LEU B 105       2.512  36.355  -7.071  1.00 81.94           O  
ATOM   2105  CB  LEU B 105      -0.528  36.628  -8.019  1.00 81.59           C  
ATOM   2106  CG  LEU B 105      -1.435  36.057  -9.123  1.00 81.64           C  
ATOM   2107  CD1 LEU B 105      -0.743  36.092 -10.483  1.00 81.27           C  
ATOM   2108  CD2 LEU B 105      -1.927  34.649  -8.784  1.00 81.27           C  
ATOM   2109  N   SER B 106       1.234  37.004  -5.325  1.00 82.43           N  
ATOM   2110  CA  SER B 106       2.329  37.595  -4.569  1.00 82.83           C  
ATOM   2111  C   SER B 106       3.253  36.468  -4.110  1.00 83.09           C  
ATOM   2112  O   SER B 106       4.470  36.542  -4.306  1.00 83.12           O  
ATOM   2113  CB  SER B 106       1.796  38.385  -3.363  1.00 82.85           C  
ATOM   2114  OG  SER B 106       2.813  39.143  -2.730  1.00 83.27           O  
ATOM   2115  N   TYR B 107       2.663  35.422  -3.529  1.00 83.27           N  
ATOM   2116  CA  TYR B 107       3.424  34.264  -3.087  1.00 83.42           C  
ATOM   2117  C   TYR B 107       4.137  33.580  -4.248  1.00 83.65           C  
ATOM   2118  O   TYR B 107       5.338  33.331  -4.168  1.00 84.09           O  
ATOM   2119  CB  TYR B 107       2.549  33.247  -2.360  1.00 83.50           C  
ATOM   2120  CG  TYR B 107       3.341  32.017  -1.988  1.00 83.41           C  
ATOM   2121  CD1 TYR B 107       4.260  32.066  -0.946  1.00 83.71           C  
ATOM   2122  CD2 TYR B 107       3.211  30.825  -2.702  1.00 82.92           C  
ATOM   2123  CE1 TYR B 107       5.010  30.956  -0.594  1.00 84.20           C  
ATOM   2124  CE2 TYR B 107       3.959  29.699  -2.358  1.00 83.15           C  
ATOM   2125  CZ  TYR B 107       4.860  29.774  -1.304  1.00 83.84           C  
ATOM   2126  OH  TYR B 107       5.621  28.692  -0.938  1.00 83.28           O  
HETATM 2127  N   MSE B 108       3.407  33.300  -5.327  1.00 83.51           N  
HETATM 2128  CA  MSE B 108       3.972  32.615  -6.494  1.00 83.40           C  
HETATM 2129  C   MSE B 108       4.957  33.486  -7.278  1.00 83.72           C  
HETATM 2130  O   MSE B 108       5.527  33.053  -8.285  1.00 83.75           O  
HETATM 2131  CB  MSE B 108       2.861  32.114  -7.409  1.00 83.12           C  
HETATM 2132  CG  MSE B 108       2.014  31.051  -6.767  1.00 82.67           C  
HETATM 2133 SE   MSE B 108       3.030  29.411  -6.513  0.70 82.46          SE  
HETATM 2134  CE  MSE B 108       2.732  28.628  -8.290  1.00 80.58           C  
ATOM   2135  N   ASP B 109       5.138  34.722  -6.828  1.00 83.89           N  
ATOM   2136  CA  ASP B 109       6.308  35.501  -7.203  1.00 83.89           C  
ATOM   2137  C   ASP B 109       7.296  35.673  -6.027  1.00 83.70           C  
ATOM   2138  O   ASP B 109       8.417  36.133  -6.228  1.00 83.74           O  
ATOM   2139  CB  ASP B 109       5.875  36.850  -7.784  1.00 84.15           C  
ATOM   2140  CG  ASP B 109       5.561  36.765  -9.273  1.00 85.07           C  
ATOM   2141  OD1 ASP B 109       6.467  36.349 -10.034  1.00 86.39           O  
ATOM   2142  OD2 ASP B 109       4.425  37.123  -9.681  1.00 85.40           O  
ATOM   2143  N   SER B 110       6.874  35.321  -4.811  1.00 83.25           N  
ATOM   2144  CA  SER B 110       7.759  35.296  -3.649  1.00 82.67           C  
ATOM   2145  C   SER B 110       8.514  33.980  -3.633  1.00 82.26           C  
ATOM   2146  O   SER B 110       9.728  33.973  -3.452  1.00 82.48           O  
ATOM   2147  CB  SER B 110       6.955  35.447  -2.350  1.00 82.91           C  
ATOM   2148  OG  SER B 110       7.795  35.740  -1.237  1.00 83.53           O  
ATOM   2149  N   ASP B 111       7.790  32.877  -3.851  1.00 81.51           N  
ATOM   2150  CA  ASP B 111       8.331  31.515  -3.728  1.00 80.55           C  
ATOM   2151  C   ASP B 111       9.364  31.104  -4.767  1.00 79.59           C  
ATOM   2152  O   ASP B 111      10.436  30.639  -4.417  1.00 80.09           O  
ATOM   2153  CB  ASP B 111       7.222  30.482  -3.813  1.00 80.87           C  
ATOM   2154  CG  ASP B 111       7.769  29.053  -3.791  1.00 82.36           C  
ATOM   2155  OD1 ASP B 111       7.469  28.337  -2.801  1.00 84.62           O  
ATOM   2156  OD2 ASP B 111       8.518  28.651  -4.741  1.00 83.01           O  
ATOM   2157  N   GLN B 112       8.998  31.191  -6.039  1.00 78.17           N  
ATOM   2158  CA  GLN B 112       9.902  30.789  -7.117  1.00 76.48           C  
ATOM   2159  C   GLN B 112      11.047  31.802  -7.090  1.00 75.04           C  
ATOM   2160  O   GLN B 112      12.209  31.425  -7.261  1.00 75.54           O  
ATOM   2161  CB  GLN B 112       9.207  30.739  -8.509  1.00 76.67           C  
ATOM   2162  CG  GLN B 112       7.736  30.164  -8.566  1.00 77.57           C  
ATOM   2163  CD  GLN B 112       7.623  28.632  -8.468  1.00 77.83           C  
ATOM   2164  OE1 GLN B 112       8.414  27.986  -7.786  1.00 80.84           O  
ATOM   2165  NE2 GLN B 112       6.607  28.057  -9.119  1.00 78.18           N  
ATOM   2166  N   SER B 113      10.729  33.084  -6.850  1.00 72.69           N  
ATOM   2167  CA  SER B 113      11.769  34.096  -6.552  1.00 70.46           C  
ATOM   2168  C   SER B 113      12.674  33.662  -5.410  1.00 68.23           C  
ATOM   2169  O   SER B 113      13.891  33.804  -5.496  1.00 68.45           O  
ATOM   2170  CB  SER B 113      11.146  35.428  -6.156  1.00 70.30           C  
ATOM   2171  OG  SER B 113      11.013  36.253  -7.279  1.00 71.05           O  
ATOM   2172  N   GLN B 114      12.050  33.191  -4.334  1.00 65.72           N  
ATOM   2173  CA  GLN B 114      12.751  32.607  -3.179  1.00 63.95           C  
ATOM   2174  C   GLN B 114      13.653  31.431  -3.569  1.00 62.04           C  
ATOM   2175  O   GLN B 114      14.860  31.442  -3.273  1.00 61.74           O  
ATOM   2176  CB  GLN B 114      11.753  32.070  -2.132  1.00 64.67           C  
ATOM   2177  CG  GLN B 114      11.396  32.998  -0.965  1.00 66.39           C  
ATOM   2178  CD  GLN B 114      10.126  32.535  -0.220  1.00 66.69           C  
ATOM   2179  OE1 GLN B 114       9.911  31.327  -0.024  1.00 69.87           O  
ATOM   2180  NE2 GLN B 114       9.269  33.497   0.174  1.00 67.00           N  
HETATM 2181  N   MSE B 115      13.075  30.399  -4.198  0.35 60.35           N  
HETATM 2184  CA  MSE B 115      13.822  29.153  -4.477  0.35 58.93           C  
HETATM 2187  C   MSE B 115      14.805  29.288  -5.673  0.35 58.21           C  
HETATM 2190  O   MSE B 115      15.639  28.407  -5.858  0.35 57.63           O  
HETATM 2193  CB  MSE B 115      12.883  27.905  -4.576  0.35 58.64           C  
HETATM 2196  CG  MSE B 115      13.523  26.552  -4.062  0.35 58.60           C  
HETATM 2199 SE   MSE B 115      12.456  24.922  -3.460  0.30 54.31          SE  
HETATM 2202  CE  MSE B 115      13.791  23.615  -3.927  0.35 54.24           C  
ATOM   2205  N   THR B 116      14.728  30.375  -6.457  1.00 57.78           N  
ATOM   2206  CA  THR B 116      15.765  30.683  -7.481  1.00 56.96           C  
ATOM   2207  C   THR B 116      16.610  31.868  -7.106  1.00 53.97           C  
ATOM   2208  O   THR B 116      17.374  32.350  -7.926  1.00 53.18           O  
ATOM   2209  CB  THR B 116      15.201  30.991  -8.888  1.00 55.45           C  
ATOM   2210  OG1 THR B 116      14.312  32.119  -8.830  1.00 55.09           O  
ATOM   2211  CG2 THR B 116      14.514  29.799  -9.457  1.00 54.59           C  
ATOM   2212  N   SER B 117      16.476  32.341  -5.874  1.00 52.31           N  
ATOM   2213  CA  SER B 117      17.092  33.593  -5.462  1.00 50.90           C  
ATOM   2214  C   SER B 117      18.616  33.550  -5.501  1.00 49.83           C  
ATOM   2215  O   SER B 117      19.248  34.564  -5.819  1.00 49.63           O  
ATOM   2216  CB  SER B 117      16.623  34.019  -4.050  1.00 51.44           C  
ATOM   2217  OG  SER B 117      17.186  33.198  -3.047  1.00 52.07           O  
ATOM   2218  N   GLY B 118      19.201  32.388  -5.196  1.00 48.28           N  
ATOM   2219  CA  GLY B 118      20.665  32.240  -5.236  1.00 47.02           C  
ATOM   2220  C   GLY B 118      21.231  32.041  -6.640  1.00 44.59           C  
ATOM   2221  O   GLY B 118      22.455  32.046  -6.842  1.00 43.82           O  
ATOM   2222  N   LEU B 119      20.344  31.860  -7.611  1.00 41.52           N  
ATOM   2223  CA  LEU B 119      20.762  31.488  -8.951  1.00 40.19           C  
ATOM   2224  C   LEU B 119      20.941  32.730  -9.798  1.00 39.45           C  
ATOM   2225  O   LEU B 119      20.224  33.702  -9.626  1.00 38.69           O  
ATOM   2226  CB  LEU B 119      19.718  30.581  -9.599  1.00 39.17           C  
ATOM   2227  CG  LEU B 119      19.598  29.150  -9.046  1.00 40.77           C  
ATOM   2228  CD1 LEU B 119      18.513  28.441  -9.877  1.00 42.83           C  
ATOM   2229  CD2 LEU B 119      20.955  28.429  -9.119  1.00 35.54           C  
ATOM   2230  N   ASN B 120      21.893  32.697 -10.724  1.00 38.39           N  
ATOM   2231  CA  ASN B 120      21.886  33.696 -11.776  1.00 38.40           C  
ATOM   2232  C   ASN B 120      20.859  33.390 -12.877  1.00 37.99           C  
ATOM   2233  O   ASN B 120      20.491  32.250 -13.134  1.00 35.81           O  
ATOM   2234  CB  ASN B 120      23.283  33.922 -12.336  1.00 38.56           C  
ATOM   2235  CG  ASN B 120      24.148  34.750 -11.397  1.00 40.82           C  
ATOM   2236  OD1 ASN B 120      23.732  35.844 -10.977  1.00 39.90           O  
ATOM   2237  ND2 ASN B 120      25.346  34.254 -11.077  1.00 35.99           N  
ATOM   2238  N   LYS B 121      20.441  34.465 -13.526  0.50 38.09           N  
ATOM   2240  CA  LYS B 121      19.434  34.434 -14.562  0.50 38.88           C  
ATOM   2242  C   LYS B 121      19.717  33.358 -15.602  0.50 37.84           C  
ATOM   2244  O   LYS B 121      18.861  32.507 -15.865  0.50 37.45           O  
ATOM   2246  CB  LYS B 121      19.353  35.822 -15.221  0.50 39.12           C  
ATOM   2248  CG  LYS B 121      18.245  35.964 -16.235  0.50 40.69           C  
ATOM   2250  CD  LYS B 121      18.191  37.367 -16.813  0.50 40.83           C  
ATOM   2252  CE  LYS B 121      19.539  37.822 -17.387  0.50 41.68           C  
ATOM   2254  NZ  LYS B 121      19.414  39.155 -18.025  0.50 42.21           N  
ATOM   2256  N   GLU B 122      20.926  33.359 -16.157  0.50 37.57           N  
ATOM   2258  CA  GLU B 122      21.245  32.382 -17.189  0.50 37.52           C  
ATOM   2260  C   GLU B 122      21.331  30.941 -16.668  0.50 37.29           C  
ATOM   2262  O   GLU B 122      21.283  30.003 -17.469  0.50 36.63           O  
ATOM   2264  CB  GLU B 122      22.502  32.774 -17.986  0.50 37.99           C  
ATOM   2266  CG  GLU B 122      22.344  34.036 -18.888  0.50 38.99           C  
ATOM   2268  CD  GLU B 122      21.069  34.052 -19.766  0.50 40.18           C  
ATOM   2270  OE1 GLU B 122      20.967  33.240 -20.721  0.50 39.18           O  
ATOM   2272  OE2 GLU B 122      20.176  34.886 -19.490  0.50 40.07           O  
ATOM   2274  N   GLU B 123      21.421  30.754 -15.346  1.00 36.90           N  
ATOM   2275  CA  GLU B 123      21.326  29.418 -14.775  1.00 37.03           C  
ATOM   2276  C   GLU B 123      19.901  28.954 -14.811  1.00 36.97           C  
ATOM   2277  O   GLU B 123      19.621  27.800 -15.153  1.00 36.61           O  
ATOM   2278  CB  GLU B 123      21.827  29.367 -13.317  1.00 35.96           C  
ATOM   2279  CG  GLU B 123      23.305  29.558 -13.188  1.00 35.53           C  
ATOM   2280  CD  GLU B 123      23.812  29.426 -11.763  1.00 35.54           C  
ATOM   2281  OE1 GLU B 123      23.621  30.394 -10.970  1.00 32.13           O  
ATOM   2282  OE2 GLU B 123      24.452  28.386 -11.474  1.00 32.01           O  
ATOM   2283  N   VAL B 124      19.014  29.839 -14.417  1.00 38.41           N  
ATOM   2284  CA  VAL B 124      17.562  29.553 -14.439  1.00 40.77           C  
ATOM   2285  C   VAL B 124      17.137  29.222 -15.877  1.00 40.78           C  
ATOM   2286  O   VAL B 124      16.482  28.211 -16.082  1.00 42.29           O  
ATOM   2287  CB  VAL B 124      16.740  30.705 -13.836  1.00 41.25           C  
ATOM   2288  CG1 VAL B 124      15.212  30.526 -14.042  1.00 43.69           C  
ATOM   2289  CG2 VAL B 124      17.063  30.836 -12.366  1.00 42.06           C  
ATOM   2290  N   VAL B 125      17.596  30.024 -16.833  1.00 40.35           N  
ATOM   2291  CA  VAL B 125      17.319  29.819 -18.254  1.00 40.65           C  
ATOM   2292  C   VAL B 125      17.831  28.459 -18.738  1.00 40.27           C  
ATOM   2293  O   VAL B 125      17.099  27.712 -19.390  1.00 40.23           O  
ATOM   2294  CB  VAL B 125      17.917  30.984 -19.114  1.00 41.00           C  
ATOM   2295  CG1 VAL B 125      18.058  30.615 -20.627  1.00 41.18           C  
ATOM   2296  CG2 VAL B 125      17.098  32.286 -18.934  1.00 41.01           C  
ATOM   2297  N   PHE B 126      19.077  28.134 -18.402  1.00 38.43           N  
ATOM   2298  CA  PHE B 126      19.652  26.850 -18.751  1.00 38.42           C  
ATOM   2299  C   PHE B 126      18.802  25.670 -18.219  1.00 37.73           C  
ATOM   2300  O   PHE B 126      18.501  24.763 -18.949  1.00 37.41           O  
ATOM   2301  CB  PHE B 126      21.121  26.732 -18.278  1.00 36.74           C  
ATOM   2302  CG  PHE B 126      21.829  25.531 -18.844  1.00 36.43           C  
ATOM   2303  CD1 PHE B 126      22.419  25.586 -20.071  1.00 36.06           C  
ATOM   2304  CD2 PHE B 126      21.888  24.352 -18.146  1.00 35.90           C  
ATOM   2305  CE1 PHE B 126      23.048  24.494 -20.625  1.00 37.18           C  
ATOM   2306  CE2 PHE B 126      22.530  23.254 -18.695  1.00 35.83           C  
ATOM   2307  CZ  PHE B 126      23.089  23.327 -19.911  1.00 37.27           C  
ATOM   2308  N   LEU B 127      18.481  25.692 -16.942  1.00 38.69           N  
ATOM   2309  CA  LEU B 127      17.720  24.633 -16.295  1.00 39.97           C  
ATOM   2310  C   LEU B 127      16.301  24.462 -16.901  1.00 40.21           C  
ATOM   2311  O   LEU B 127      15.840  23.335 -17.121  1.00 40.46           O  
ATOM   2312  CB  LEU B 127      17.626  24.897 -14.786  1.00 39.08           C  
ATOM   2313  CG  LEU B 127      16.817  23.852 -14.005  1.00 40.36           C  
ATOM   2314  CD1 LEU B 127      17.299  22.475 -14.289  1.00 39.01           C  
ATOM   2315  CD2 LEU B 127      16.780  24.171 -12.527  1.00 41.08           C  
ATOM   2316  N   GLU B 128      15.632  25.585 -17.124  1.00 40.93           N  
ATOM   2317  CA  GLU B 128      14.286  25.609 -17.743  1.00 42.47           C  
ATOM   2318  C   GLU B 128      14.338  24.923 -19.110  1.00 40.73           C  
ATOM   2319  O   GLU B 128      13.505  24.064 -19.371  1.00 40.94           O  
ATOM   2320  CB  GLU B 128      13.686  27.048 -17.817  1.00 42.95           C  
ATOM   2321  CG  GLU B 128      13.093  27.580 -16.473  1.00 47.13           C  
ATOM   2322  CD  GLU B 128      12.465  29.034 -16.554  1.00 47.55           C  
ATOM   2323  OE1 GLU B 128      12.757  29.782 -17.530  1.00 58.67           O  
ATOM   2324  OE2 GLU B 128      11.666  29.457 -15.648  1.00 55.98           O  
ATOM   2325  N   LYS B 129      15.348  25.226 -19.922  1.00 39.75           N  
ATOM   2326  CA  LYS B 129      15.504  24.609 -21.242  1.00 40.87           C  
ATOM   2327  C   LYS B 129      15.706  23.108 -21.164  1.00 39.82           C  
ATOM   2328  O   LYS B 129      15.134  22.369 -21.971  1.00 38.52           O  
ATOM   2329  CB  LYS B 129      16.623  25.251 -22.124  1.00 40.61           C  
ATOM   2330  CG  LYS B 129      16.416  26.745 -22.385  1.00 43.17           C  
ATOM   2331  CD  LYS B 129      17.293  27.346 -23.517  1.00 44.17           C  
ATOM   2332  CE  LYS B 129      18.732  27.704 -23.101  1.00 47.47           C  
ATOM   2333  NZ  LYS B 129      19.314  28.701 -24.095  1.00 46.43           N  
ATOM   2334  N   ILE B 130      16.551  22.646 -20.250  1.00 39.39           N  
ATOM   2335  CA  ILE B 130      16.802  21.208 -20.147  1.00 39.04           C  
ATOM   2336  C   ILE B 130      15.614  20.463 -19.543  1.00 38.78           C  
ATOM   2337  O   ILE B 130      15.307  19.327 -19.943  1.00 38.26           O  
ATOM   2338  CB  ILE B 130      18.057  20.896 -19.296  1.00 39.62           C  
ATOM   2339  CG1 ILE B 130      19.355  21.477 -19.905  1.00 37.63           C  
ATOM   2340  CG2 ILE B 130      18.153  19.327 -18.968  1.00 40.35           C  
ATOM   2341  CD1 ILE B 130      19.394  21.774 -21.380  1.00 36.99           C  
ATOM   2342  N   LEU B 131      14.926  21.072 -18.584  1.00 38.87           N  
ATOM   2343  CA  LEU B 131      13.775  20.385 -18.007  1.00 41.06           C  
ATOM   2344  C   LEU B 131      12.661  20.200 -19.071  1.00 41.84           C  
ATOM   2345  O   LEU B 131      11.994  19.184 -19.088  1.00 42.28           O  
ATOM   2346  CB  LEU B 131      13.236  21.116 -16.773  1.00 39.78           C  
ATOM   2347  CG  LEU B 131      13.975  21.110 -15.425  1.00 40.12           C  
ATOM   2348  CD1 LEU B 131      13.417  22.120 -14.436  1.00 36.57           C  
ATOM   2349  CD2 LEU B 131      13.917  19.719 -14.857  1.00 39.97           C  
ATOM   2350  N   LYS B 132      12.461  21.207 -19.922  0.50 42.67           N  
ATOM   2352  CA  LYS B 132      11.443  21.168 -20.968  0.50 43.06           C  
ATOM   2354  C   LYS B 132      11.682  19.961 -21.854  0.50 44.00           C  
ATOM   2356  O   LYS B 132      10.764  19.194 -22.122  0.50 43.73           O  
ATOM   2358  CB  LYS B 132      11.440  22.467 -21.790  0.50 43.38           C  
ATOM   2360  CG  LYS B 132      10.709  22.366 -23.134  0.50 43.92           C  
ATOM   2362  CD  LYS B 132      10.280  23.731 -23.688  0.50 44.32           C  
ATOM   2364  CE  LYS B 132       9.643  23.600 -25.069  0.50 45.70           C  
ATOM   2366  NZ  LYS B 132      10.584  23.164 -26.145  0.50 46.71           N  
ATOM   2368  N   ARG B 133      12.931  19.773 -22.257  1.00 44.73           N  
ATOM   2369  CA  ARG B 133      13.307  18.654 -23.111  1.00 47.40           C  
ATOM   2370  C   ARG B 133      13.125  17.324 -22.423  1.00 47.65           C  
ATOM   2371  O   ARG B 133      12.622  16.387 -23.032  1.00 47.33           O  
ATOM   2372  CB  ARG B 133      14.779  18.749 -23.558  1.00 47.33           C  
ATOM   2373  CG  ARG B 133      14.961  18.990 -25.032  1.00 52.17           C  
ATOM   2374  CD  ARG B 133      16.293  18.380 -25.537  1.00 53.04           C  
ATOM   2375  NE  ARG B 133      17.401  19.250 -25.149  1.00 58.24           N  
ATOM   2376  CZ  ARG B 133      18.696  18.923 -25.209  1.00 61.88           C  
ATOM   2377  NH1 ARG B 133      19.108  17.707 -25.620  1.00 62.80           N  
ATOM   2378  NH2 ARG B 133      19.595  19.838 -24.853  1.00 61.88           N  
HETATM 2379  N   MSE B 134      13.568  17.247 -21.163  1.00 48.80           N  
HETATM 2380  CA  MSE B 134      13.447  16.033 -20.359  1.00 50.22           C  
HETATM 2381  C   MSE B 134      11.983  15.584 -20.246  1.00 49.09           C  
HETATM 2382  O   MSE B 134      11.679  14.417 -20.373  1.00 49.53           O  
HETATM 2383  CB  MSE B 134      14.017  16.267 -18.965  1.00 50.64           C  
HETATM 2384  CG  MSE B 134      15.544  16.367 -18.835  1.00 53.07           C  
HETATM 2385 SE   MSE B 134      16.072  16.600 -16.943  0.70 60.52          SE  
HETATM 2386  CE  MSE B 134      14.643  15.442 -16.186  1.00 40.05           C  
ATOM   2387  N   ILE B 135      11.087  16.541 -20.031  1.00 48.48           N  
ATOM   2388  CA  ILE B 135       9.672  16.297 -19.906  1.00 49.21           C  
ATOM   2389  C   ILE B 135       9.008  15.815 -21.227  1.00 50.15           C  
ATOM   2390  O   ILE B 135       8.154  14.938 -21.195  1.00 48.51           O  
ATOM   2391  CB  ILE B 135       9.002  17.579 -19.357  1.00 49.42           C  
ATOM   2392  CG1 ILE B 135       9.414  17.802 -17.894  1.00 46.88           C  
ATOM   2393  CG2 ILE B 135       7.508  17.551 -19.477  1.00 49.61           C  
ATOM   2394  CD1 ILE B 135       8.899  19.097 -17.377  1.00 48.94           C  
ATOM   2395  N   GLU B 136       9.419  16.385 -22.369  1.00 51.79           N  
ATOM   2396  CA  GLU B 136       8.876  16.027 -23.701  1.00 53.71           C  
ATOM   2397  C   GLU B 136       9.145  14.585 -24.066  1.00 55.53           C  
ATOM   2398  O   GLU B 136       8.267  13.880 -24.540  1.00 56.32           O  
ATOM   2399  CB  GLU B 136       9.519  16.893 -24.812  1.00 53.81           C  
ATOM   2400  CG  GLU B 136       8.943  18.290 -24.909  1.00 55.71           C  
ATOM   2401  CD  GLU B 136       9.868  19.343 -25.591  1.00 56.16           C  
ATOM   2402  OE1 GLU B 136      11.077  19.081 -25.878  1.00 56.51           O  
ATOM   2403  OE2 GLU B 136       9.332  20.466 -25.827  1.00 60.22           O  
ATOM   2404  N   SER B 137      10.389  14.174 -23.872  1.00 57.87           N  
ATOM   2405  CA  SER B 137      10.899  12.923 -24.419  1.00 60.28           C  
ATOM   2406  C   SER B 137      10.781  11.729 -23.430  1.00 61.35           C  
ATOM   2407  O   SER B 137      11.383  10.660 -23.660  1.00 61.89           O  
ATOM   2408  CB  SER B 137      12.355  13.132 -24.889  1.00 60.50           C  
ATOM   2409  OG  SER B 137      12.612  14.500 -25.213  1.00 60.78           O  
ATOM   2410  N   ASP B 138       9.988  11.908 -22.361  1.00 62.11           N  
ATOM   2411  CA  ASP B 138       9.669  10.831 -21.396  1.00 62.27           C  
ATOM   2412  C   ASP B 138       8.820   9.727 -22.047  1.00 62.54           C  
ATOM   2413  O   ASP B 138       8.587   9.731 -23.270  1.00 63.45           O  
ATOM   2414  CB  ASP B 138       8.915  11.413 -20.181  1.00 62.23           C  
ATOM   2415  CG  ASP B 138       8.552  10.351 -19.126  1.00 62.21           C  
ATOM   2416  OD1 ASP B 138       9.473   9.700 -18.600  1.00 59.94           O  
ATOM   2417  OD2 ASP B 138       7.351  10.197 -18.804  1.00 61.37           O  
TER    2418      ASP B 138                                                      
END
MOLECULE T0459.pdb
ATOM      1  N   SER     1     -10.415  21.770  17.737  1.00 36.73           N  
ATOM      2  CA  SER     1      -9.300  22.637  18.208  1.00 36.27           C  
ATOM      3  C   SER     1      -8.557  23.266  17.037  1.00 35.28           C  
ATOM      4  O   SER     1      -8.379  22.640  15.973  1.00 35.90           O  
ATOM      5  CB  SER     1      -8.351  21.893  19.152  1.00 36.84           C  
ATOM      6  OG  SER     1      -7.375  22.791  19.686  1.00 38.33           O  
ATOM      7  N   ASN     2      -8.124  24.504  17.269  1.00 33.96           N  
ATOM      8  CA  ASN     2      -7.662  25.408  16.215  0.50 33.06           C  
ATOM     10  C   ASN     2      -6.217  25.852  16.369  1.00 32.42           C  
ATOM     11  O   ASN     2      -5.703  25.916  17.477  1.00 32.77           O  
ATOM     12  CB  ASN     2      -8.522  26.677  16.208  0.50 33.17           C  
ATOM     14  CG  ASN     2      -9.904  26.457  15.620  0.50 33.12           C  
ATOM     16  OD1 ASN     2     -10.596  27.422  15.296  0.50 35.02           O  
ATOM     18  ND2 ASN     2     -10.312  25.197  15.473  0.50 31.87           N  
ATOM     20  N   ALA     3      -5.592  26.188  15.250  1.00 31.43           N  
ATOM     21  CA  ALA     3      -4.314  26.862  15.272  1.00 31.00           C  
ATOM     22  C   ALA     3      -4.652  28.337  15.273  1.00 30.63           C  
ATOM     23  O   ALA     3      -5.545  28.766  14.533  1.00 31.26           O  
ATOM     24  CB  ALA     3      -3.484  26.499  14.033  1.00 30.25           C  
ATOM     25  N   MET     4      -3.954  29.122  16.099  1.00 30.89           N  
ATOM     26  CA  MET     4      -4.173  30.557  16.181  1.00 30.57           C  
ATOM     27  C   MET     4      -2.912  31.223  15.687  1.00 29.89           C  
ATOM     28  O   MET     4      -1.831  31.018  16.275  1.00 29.61           O  
ATOM     29  CB  MET     4      -4.453  30.972  17.642  1.00 31.45           C  
ATOM     30  CG  MET     4      -5.831  30.585  18.117  1.00 34.71           C  
ATOM     31  SD  MET     4      -7.230  31.555  17.154  0.55 40.32          SE  
ATOM     32  CE  MET     4      -7.248  33.228  18.136  1.00 40.24           C  
ATOM     33  N   LEU     5      -3.022  31.969  14.595  1.00 29.52           N  
ATOM     34  CA  LEU     5      -1.845  32.551  13.938  1.00 30.45           C  
ATOM     35  C   LEU     5      -1.815  34.086  14.040  1.00 31.10           C  
ATOM     36  O   LEU     5      -2.754  34.760  13.649  1.00 32.83           O  
ATOM     37  CB  LEU     5      -1.743  32.099  12.465  1.00 29.59           C  
ATOM     38  CG  LEU     5      -2.214  30.669  12.242  1.00 30.64           C  
ATOM     39  CD1 LEU     5      -2.429  30.421  10.765  1.00 30.79           C  
ATOM     40  CD2 LEU     5      -1.193  29.717  12.859  1.00 27.96           C  
ATOM     41  N   ARG     6      -0.726  34.617  14.576  1.00 31.38           N  
ATOM     42  CA  ARG     6      -0.573  36.055  14.754  1.00 31.04           C  
ATOM     43  C   ARG     6      -0.465  36.732  13.387  1.00 30.97           C  
ATOM     44  O   ARG     6       0.359  36.338  12.565  1.00 32.05           O  
ATOM     45  CB  ARG     6       0.690  36.338  15.573  1.00 29.54           C  
ATOM     46  CG  ARG     6       1.027  37.817  15.740  1.00 33.13           C  
ATOM     47  CD  ARG     6      -0.136  38.565  16.275  1.00 33.20           C  
ATOM     48  NE  ARG     6      -0.526  38.164  17.630  1.00 33.00           N  
ATOM     49  CZ  ARG     6      -1.502  38.758  18.316  1.00 32.70           C  
ATOM     50  NH1 ARG     6      -1.812  38.328  19.523  1.00 30.79           N  
ATOM     51  NH2 ARG     6      -2.166  39.785  17.789  1.00 30.14           N  
ATOM     52  N   TYR     7      -1.294  37.754  13.164  1.00 30.67           N  
ATOM     53  CA  TYR     7      -1.218  38.537  11.932  1.00 30.64           C  
ATOM     54  C   TYR     7      -1.426  40.007  12.314  1.00 29.31           C  
ATOM     55  O   TYR     7      -2.557  40.492  12.356  1.00 29.58           O  
ATOM     56  CB  TYR     7      -2.276  38.071  10.921  1.00 30.37           C  
ATOM     57  CG  TYR     7      -2.256  38.775   9.583  1.00 31.58           C  
ATOM     58  CD1 TYR     7      -1.073  39.265   9.039  1.00 33.67           C  
ATOM     59  CD2 TYR     7      -3.426  38.915   8.837  1.00 31.83           C  
ATOM     60  CE1 TYR     7      -1.063  39.895   7.783  1.00 33.79           C  
ATOM     61  CE2 TYR     7      -3.420  39.529   7.601  1.00 33.39           C  
ATOM     62  CZ  TYR     7      -2.248  40.022   7.077  1.00 33.60           C  
ATOM     63  OH  TYR     7      -2.258  40.659   5.856  1.00 32.89           O  
ATOM     64  N   GLY     8      -0.335  40.706  12.641  1.00 29.52           N  
ATOM     65  CA  GLY     8      -0.478  42.089  13.106  1.00 29.08           C  
ATOM     66  C   GLY     8      -1.219  42.101  14.434  1.00 29.21           C  
ATOM     67  O   GLY     8      -0.928  41.314  15.325  1.00 29.78           O  
ATOM     68  N   ASP     9      -2.211  42.967  14.560  1.00 27.53           N  
ATOM     69  CA  ASP     9      -2.978  43.109  15.794  1.00 29.01           C  
ATOM     70  C   ASP     9      -4.059  42.029  15.926  1.00 28.64           C  
ATOM     71  O   ASP     9      -4.835  42.060  16.876  1.00 30.34           O  
ATOM     72  CB  ASP     9      -3.594  44.499  15.809  1.00 27.53           C  
ATOM     73  CG  ASP     9      -4.168  44.903  17.184  1.00 28.31           C  
ATOM     74  OD1 ASP     9      -3.576  44.591  18.255  1.00 27.20           O  
ATOM     75  OD2 ASP     9      -5.212  45.572  17.173  1.00 31.32           O  
ATOM     76  N   THR    10      -4.131  41.110  14.963  1.00 28.31           N  
ATOM     77  CA  THR    10      -5.215  40.131  14.895  1.00 29.02           C  
ATOM     78  C   THR    10      -4.652  38.709  15.031  1.00 27.83           C  
ATOM     79  O   THR    10      -3.436  38.485  14.855  1.00 27.98           O  
ATOM     80  CB  THR    10      -6.007  40.207  13.547  1.00 28.56           C  
ATOM     81  OG1 THR    10      -5.235  39.584  12.498  1.00 32.75           O  
ATOM     82  CG2 THR    10      -6.377  41.661  13.190  1.00 31.29           C  
ATOM     83  N   GLU    11      -5.522  37.757  15.346  1.00 26.75           N  
ATOM     84  CA  GLU    11      -5.136  36.351  15.200  1.00 28.15           C  
ATOM     85  C   GLU    11      -6.073  35.652  14.215  1.00 27.58           C  
ATOM     86  O   GLU    11      -7.293  35.848  14.254  1.00 27.69           O  
ATOM     87  CB  GLU    11      -5.099  35.638  16.554  1.00 27.56           C  
ATOM     88  CG  GLU    11      -4.013  36.141  17.491  1.00 30.04           C  
ATOM     89  CD  GLU    11      -4.107  35.489  18.861  1.00 34.00           C  
ATOM     90  OE1 GLU    11      -5.031  35.867  19.629  1.00 35.94           O  
ATOM     91  OE2 GLU    11      -3.266  34.612  19.176  1.00 33.57           O  
ATOM     92  N   ILE    12      -5.483  34.849  13.343  1.00 28.49           N  
ATOM     93  CA  ILE    12      -6.224  34.097  12.330  1.00 28.91           C  
ATOM     94  C   ILE    12      -6.443  32.708  12.938  1.00 28.83           C  
ATOM     95  O   ILE    12      -5.486  32.098  13.439  1.00 29.05           O  
ATOM     96  CB  ILE    12      -5.396  33.983  11.020  1.00 29.30           C  
ATOM     97  CG1 ILE    12      -5.011  35.389  10.494  1.00 31.03           C  
ATOM     98  CG2 ILE    12      -6.140  33.091   9.963  1.00 29.96           C  
ATOM     99  CD1 ILE    12      -3.927  35.376   9.367  1.00 31.07           C  
ATOM    100  N   CYS    13      -7.692  32.251  12.882  1.00 27.28           N  
ATOM    101  CA  CYS    13      -8.078  30.950  13.372  0.50 27.26           C  
ATOM    103  C   CYS    13      -8.209  29.961  12.206  1.00 28.00           C  
ATOM    104  O   CYS    13      -8.972  30.213  11.261  1.00 27.25           O  
ATOM    105  CB  CYS    13      -9.414  31.073  14.111  0.50 27.24           C  
ATOM    107  SG  CYS    13      -9.844  29.604  15.022  0.50 25.64           S  
ATOM    109  N   ILE    14      -7.452  28.860  12.267  1.00 27.87           N  
ATOM    110  CA  ILE    14      -7.549  27.773  11.287  1.00 28.04           C  
ATOM    111  C   ILE    14      -7.750  26.429  11.994  1.00 28.25           C  
ATOM    112  O   ILE    14      -6.969  26.035  12.867  1.00 28.02           O  
ATOM    113  CB  ILE    14      -6.265  27.649  10.389  1.00 27.07           C  
ATOM    114  CG1 ILE    14      -5.966  28.980   9.657  1.00 28.97           C  
ATOM    115  CG2 ILE    14      -6.350  26.422   9.419  1.00 27.42           C  
ATOM    116  CD1 ILE    14      -6.819  29.234   8.425  1.00 28.09           C  
ATOM    117  N   ASP    15      -8.777  25.714  11.588  1.00 28.87           N  
ATOM    118  CA  ASP    15      -8.945  24.371  12.055  1.00 30.05           C  
ATOM    119  C   ASP    15      -8.263  23.415  11.067  1.00 31.28           C  
ATOM    120  O   ASP    15      -8.756  23.220   9.966  1.00 31.16           O  
ATOM    121  CB  ASP    15     -10.434  24.082  12.189  1.00 30.09           C  
ATOM    122  CG  ASP    15     -10.708  22.784  12.894  1.00 30.26           C  
ATOM    123  OD1 ASP    15      -9.748  22.031  13.153  1.00 32.36           O  
ATOM    124  OD2 ASP    15     -11.892  22.515  13.186  1.00 30.84           O  
ATOM    125  N   PRO    16      -7.133  22.799  11.470  1.00 32.52           N  
ATOM    126  CA  PRO    16      -6.366  22.006  10.524  1.00 33.72           C  
ATOM    127  C   PRO    16      -7.133  20.771  10.042  1.00 34.14           C  
ATOM    128  O   PRO    16      -6.857  20.285   8.952  1.00 35.37           O  
ATOM    129  CB  PRO    16      -5.117  21.598  11.324  1.00 33.18           C  
ATOM    130  CG  PRO    16      -5.070  22.521  12.481  1.00 34.54           C  
ATOM    131  CD  PRO    16      -6.514  22.776  12.806  1.00 33.05           C  
ATOM    132  N   SER    17      -8.095  20.287  10.833  1.00 35.19           N  
ATOM    133  CA  SER    17      -8.889  19.114  10.454  1.00 35.46           C  
ATOM    134  C   SER    17     -10.103  19.438   9.566  1.00 35.43           C  
ATOM    135  O   SER    17     -10.689  18.533   8.970  1.00 35.51           O  
ATOM    136  CB  SER    17      -9.323  18.324  11.694  1.00 35.69           C  
ATOM    137  OG  SER    17     -10.303  19.026  12.444  1.00 35.63           O  
ATOM    138  N   GLU    18     -10.492  20.715   9.519  1.00 35.21           N  
ATOM    139  CA  GLU    18     -11.559  21.189   8.631  0.50 35.18           C  
ATOM    141  C   GLU    18     -11.283  22.617   8.158  1.00 35.05           C  
ATOM    142  O   GLU    18     -11.663  23.598   8.809  1.00 35.41           O  
ATOM    143  CB  GLU    18     -12.934  21.076   9.299  0.50 35.13           C  
ATOM    145  CG  GLU    18     -13.636  19.744   9.037  0.50 35.62           C  
ATOM    147  CD  GLU    18     -15.015  19.656   9.662  0.50 35.62           C  
ATOM    149  OE1 GLU    18     -15.498  18.516   9.856  0.50 37.29           O  
ATOM    151  OE2 GLU    18     -15.618  20.715   9.959  0.50 36.60           O  
ATOM    153  N   SER    19     -10.578  22.722   7.042  1.00 34.61           N  
ATOM    154  CA  SER    19     -10.251  23.990   6.427  1.00 33.27           C  
ATOM    155  C   SER    19      -9.994  23.714   4.972  1.00 33.78           C  
ATOM    156  O   SER    19      -9.529  22.624   4.618  1.00 34.23           O  
ATOM    157  CB  SER    19      -8.959  24.579   7.013  1.00 33.81           C  
ATOM    158  OG  SER    19      -8.575  25.719   6.249  1.00 31.21           O  
ATOM    159  N   VAL    20     -10.272  24.705   4.130  1.00 32.42           N  
ATOM    160  CA  VAL    20      -9.977  24.617   2.696  1.00 32.16           C  
ATOM    161  C   VAL    20      -8.453  24.665   2.466  1.00 30.52           C  
ATOM    162  O   VAL    20      -7.976  24.456   1.359  1.00 29.18           O  
ATOM    163  CB  VAL    20     -10.799  25.651   1.899  1.00 32.40           C  
ATOM    164  CG1 VAL    20     -10.376  27.082   2.223  1.00 33.30           C  
ATOM    165  CG2 VAL    20     -10.736  25.355   0.412  1.00 34.67           C  
ATOM    166  N   LEU    21      -7.706  24.923   3.541  1.00 29.65           N  
ATOM    167  CA  LEU    21      -6.253  24.853   3.500  1.00 28.31           C  
ATOM    168  C   LEU    21      -5.823  23.451   3.035  1.00 28.00           C  
ATOM    169  O   LEU    21      -4.853  23.340   2.297  1.00 27.24           O  
ATOM    170  CB  LEU    21      -5.656  25.160   4.885  1.00 29.04           C  
ATOM    171  CG  LEU    21      -4.133  25.098   5.000  1.00 29.06           C  
ATOM    172  CD1 LEU    21      -3.468  26.066   4.034  1.00 30.76           C  
ATOM    173  CD2 LEU    21      -3.743  25.385   6.456  1.00 28.18           C  
ATOM    174  N   HIS    22      -6.556  22.406   3.447  1.00 28.90           N  
ATOM    175  CA  HIS    22      -6.261  21.027   3.059  1.00 30.07           C  
ATOM    176  C   HIS    22      -6.226  20.912   1.547  1.00 29.78           C  
ATOM    177  O   HIS    22      -5.251  20.412   0.960  1.00 29.81           O  
ATOM    178  CB  HIS    22      -7.317  20.060   3.652  1.00 29.57           C  
ATOM    179  CG  HIS    22      -7.121  18.620   3.283  1.00 32.86           C  
ATOM    180  ND1 HIS    22      -6.237  17.801   3.948  1.00 36.16           N  
ATOM    181  CD2 HIS    22      -7.733  17.840   2.360  1.00 34.12           C  
ATOM    182  CE1 HIS    22      -6.294  16.579   3.437  1.00 36.42           C  
ATOM    183  NE2 HIS    22      -7.190  16.577   2.466  1.00 36.45           N  
ATOM    184  N   LEU    23      -7.285  21.393   0.913  1.00 30.25           N  
ATOM    185  CA  LEU    23      -7.368  21.335  -0.557  1.00 30.37           C  
ATOM    186  C   LEU    23      -6.252  22.166  -1.182  1.00 32.08           C  
ATOM    187  O   LEU    23      -5.524  21.680  -2.070  1.00 32.10           O  
ATOM    188  CB  LEU    23      -8.720  21.857  -1.021  1.00 30.65           C  
ATOM    189  CG  LEU    23      -8.897  22.039  -2.536  1.00 30.24           C  
ATOM    190  CD1 LEU    23      -8.535  20.766  -3.354  1.00 33.22           C  
ATOM    191  CD2 LEU    23     -10.331  22.521  -2.824  1.00 30.94           C  
ATOM    192  N   LEU    24      -6.104  23.391  -0.684  1.00 31.13           N  
ATOM    193  CA  LEU    24      -5.102  24.306  -1.222  0.50 32.96           C  
ATOM    195  C   LEU    24      -3.688  23.739  -1.206  1.00 32.52           C  
ATOM    196  O   LEU    24      -2.888  24.059  -2.084  1.00 33.32           O  
ATOM    197  CB  LEU    24      -5.166  25.659  -0.514  0.50 32.98           C  
ATOM    199  CG  LEU    24      -5.817  26.795  -1.310  0.50 35.89           C  
ATOM    201  CD1 LEU    24      -4.761  27.454  -2.172  0.50 35.58           C  
ATOM    203  CD2 LEU    24      -7.035  26.378  -2.160  0.50 34.56           C  
ATOM    205  N   GLY    25      -3.403  22.889  -0.235  1.00 32.78           N  
ATOM    206  CA  GLY    25      -2.078  22.271  -0.122  1.00 32.77           C  
ATOM    207  C   GLY    25      -1.807  21.076  -1.029  1.00 32.09           C  
ATOM    208  O   GLY    25      -0.650  20.775  -1.316  1.00 32.25           O  
ATOM    209  N   LYS    26      -2.856  20.387  -1.470  1.00 31.77           N  
ATOM    210  CA  LYS    26      -2.693  19.222  -2.330  1.00 31.54           C  
ATOM    211  C   LYS    26      -1.923  19.602  -3.599  1.00 30.09           C  
ATOM    212  O   LYS    26      -2.096  20.721  -4.130  1.00 30.18           O  
ATOM    213  CB  LYS    26      -4.059  18.649  -2.710  1.00 32.58           C  
ATOM    214  CG  LYS    26      -4.788  18.002  -1.562  1.00 32.14           C  
ATOM    215  CD  LYS    26      -6.073  17.350  -2.043  1.00 34.07           C  
ATOM    216  CE  LYS    26      -7.020  17.150  -0.861  1.00 33.53           C  
ATOM    217  NZ  LYS    26      -7.663  15.793  -0.867  1.00 32.24           N  
ATOM    218  N   LYS    27      -1.108  18.658  -4.079  1.00 29.46           N  
ATOM    219  CA  LYS    27      -0.247  18.883  -5.225  1.00 28.20           C  
ATOM    220  C   LYS    27      -1.054  19.512  -6.367  1.00 28.47           C  
ATOM    221  O   LYS    27      -2.137  19.019  -6.699  1.00 27.82           O  
ATOM    222  CB  LYS    27       0.416  17.575  -5.684  1.00 28.29           C  
ATOM    223  CG  LYS    27       1.558  17.841  -6.624  1.00 27.35           C  
ATOM    224  CD  LYS    27       2.366  16.571  -6.953  1.00 28.02           C  
ATOM    225  CE  LYS    27       3.506  16.937  -7.892  1.00 32.06           C  
ATOM    226  NZ  LYS    27       4.144  18.235  -7.451  1.00 36.20           N  
ATOM    227  N   TYR    28      -0.517  20.598  -6.946  1.00 28.32           N  
ATOM    228  CA  TYR    28      -1.099  21.296  -8.107  1.00 28.81           C  
ATOM    229  C   TYR    28      -2.205  22.310  -7.836  1.00 28.80           C  
ATOM    230  O   TYR    28      -2.531  23.094  -8.711  1.00 29.16           O  
ATOM    231  CB  TYR    28      -1.559  20.314  -9.194  1.00 29.50           C  
ATOM    232  CG  TYR    28      -0.450  19.424  -9.733  1.00 28.58           C  
ATOM    233  CD1 TYR    28      -0.473  18.049  -9.500  1.00 28.14           C  
ATOM    234  CD2 TYR    28       0.598  19.954 -10.506  1.00 29.00           C  
ATOM    235  CE1 TYR    28       0.524  17.238  -9.999  1.00 26.00           C  
ATOM    236  CE2 TYR    28       1.591  19.138 -11.004  1.00 29.83           C  
ATOM    237  CZ  TYR    28       1.546  17.785 -10.750  1.00 28.24           C  
ATOM    238  OH  TYR    28       2.518  16.953 -11.254  1.00 32.25           O  
ATOM    239  N   THR    29      -2.806  22.288  -6.652  1.00 29.70           N  
ATOM    240  CA  THR    29      -4.030  23.111  -6.461  1.00 28.91           C  
ATOM    241  C   THR    29      -3.724  24.580  -6.628  1.00 28.79           C  
ATOM    242  O   THR    29      -4.461  25.297  -7.314  1.00 29.77           O  
ATOM    243  CB  THR    29      -4.723  22.829  -5.115  1.00 28.38           C  
ATOM    244  OG1 THR    29      -5.036  21.427  -5.024  1.00 29.94           O  
ATOM    245  CG2 THR    29      -6.051  23.661  -4.985  1.00 29.10           C  
ATOM    246  N   MET    30      -2.620  25.026  -6.029  1.00 28.10           N  
ATOM    247  CA  MET    30      -2.255  26.452  -6.125  1.00 29.83           C  
ATOM    248  C   MET    30      -1.906  26.795  -7.568  1.00 30.09           C  
ATOM    249  O   MET    30      -2.248  27.882  -8.076  1.00 30.64           O  
ATOM    250  CB  MET    30      -1.124  26.810  -5.159  1.00 28.47           C  
ATOM    251  CG  MET    30      -1.574  26.776  -3.713  1.00 31.09           C  
ATOM    252  SD  MET    30      -0.134  27.257  -2.471  0.70 33.89          SE  
ATOM    253  CE  MET    30       0.430  25.413  -2.065  1.00 34.51           C  
ATOM    254  N   LEU    31      -1.256  25.865  -8.251  1.00 29.49           N  
ATOM    255  CA  LEU    31      -0.925  26.090  -9.670  1.00 29.99           C  
ATOM    256  C   LEU    31      -2.194  26.139 -10.532  1.00 30.67           C  
ATOM    257  O   LEU    31      -2.239  26.936 -11.482  1.00 29.61           O  
ATOM    258  CB  LEU    31       0.010  25.028 -10.176  1.00 28.61           C  
ATOM    259  CG  LEU    31       1.444  25.100  -9.620  1.00 27.57           C  
ATOM    260  CD1 LEU    31       2.213  23.844 -10.095  1.00 29.53           C  
ATOM    261  CD2 LEU    31       2.111  26.434  -9.955  1.00 32.58           C  
ATOM    262  N   ILE    32      -3.185  25.287 -10.245  1.00 29.61           N  
ATOM    263  CA  ILE    32      -4.465  25.322 -11.009  1.00 29.63           C  
ATOM    264  C   ILE    32      -5.139  26.703 -10.810  1.00 29.77           C  
ATOM    265  O   ILE    32      -5.554  27.360 -11.786  1.00 31.22           O  
ATOM    266  CB  ILE    32      -5.391  24.184 -10.600  1.00 30.11           C  
ATOM    267  CG1 ILE    32      -4.787  22.835 -11.077  1.00 28.44           C  
ATOM    268  CG2 ILE    32      -6.790  24.419 -11.191  1.00 28.91           C  
ATOM    269  CD1 ILE    32      -5.362  21.530 -10.391  1.00 31.16           C  
ATOM    270  N   ILE    33      -5.281  27.127  -9.558  1.00 29.65           N  
ATOM    271  CA  ILE    33      -5.825  28.471  -9.275  1.00 29.78           C  
ATOM    272  C   ILE    33      -5.058  29.559 -10.007  1.00 30.83           C  
ATOM    273  O   ILE    33      -5.651  30.456 -10.577  1.00 31.62           O  
ATOM    274  CB  ILE    33      -5.892  28.755  -7.747  1.00 29.54           C  
ATOM    275  CG1 ILE    33      -6.877  27.749  -7.103  1.00 30.49           C  
ATOM    276  CG2 ILE    33      -6.181  30.256  -7.430  1.00 28.42           C  
ATOM    277  CD1 ILE    33      -6.852  27.715  -5.549  1.00 31.56           C  
ATOM    278  N   SER    34      -3.729  29.467  -9.981  1.00 30.02           N  
ATOM    279  CA  SER    34      -2.897  30.477 -10.652  1.00 29.45           C  
ATOM    280  C   SER    34      -3.117  30.504 -12.175  1.00 28.34           C  
ATOM    281  O   SER    34      -3.298  31.591 -12.793  1.00 29.92           O  
ATOM    282  CB  SER    34      -1.442  30.180 -10.331  1.00 29.54           C  
ATOM    283  OG  SER    34      -1.235  30.181  -8.916  1.00 33.14           O  
ATOM    284  N   VAL    35      -3.111  29.343 -12.809  1.00 29.48           N  
ATOM    285  CA  VAL    35      -3.217  29.353 -14.278  0.50 29.47           C  
ATOM    287  C   VAL    35      -4.628  29.763 -14.714  1.00 29.83           C  
ATOM    288  O   VAL    35      -4.791  30.347 -15.768  1.00 29.45           O  
ATOM    289  CB  VAL    35      -2.722  28.043 -14.974  0.50 29.52           C  
ATOM    291  CG1 VAL    35      -1.229  27.826 -14.719  0.50 29.61           C  
ATOM    293  CG2 VAL    35      -3.564  26.808 -14.566  0.50 29.25           C  
ATOM    295  N   LEU    36      -5.645  29.463 -13.891  1.00 29.61           N  
ATOM    296  CA  LEU    36      -7.026  29.830 -14.265  1.00 31.83           C  
ATOM    297  C   LEU    36      -7.212  31.343 -14.373  1.00 32.62           C  
ATOM    298  O   LEU    36      -8.154  31.860 -15.026  1.00 33.33           O  
ATOM    299  CB  LEU    36      -8.044  29.180 -13.312  1.00 31.76           C  
ATOM    300  CG  LEU    36      -8.439  27.744 -13.631  1.00 34.33           C  
ATOM    301  CD1 LEU    36      -9.255  27.121 -12.524  1.00 33.48           C  
ATOM    302  CD2 LEU    36      -9.178  27.642 -14.990  1.00 33.15           C  
ATOM    303  N   GLY    37      -6.299  32.068 -13.741  1.00 32.67           N  
ATOM    304  CA  GLY    37      -6.279  33.536 -13.828  1.00 34.43           C  
ATOM    305  C   GLY    37      -5.287  34.122 -14.824  1.00 34.47           C  
ATOM    306  O   GLY    37      -5.086  35.329 -14.829  1.00 34.99           O  
ATOM    307  N   ASN    38      -4.641  33.283 -15.638  1.00 35.53           N  
ATOM    308  CA  ASN    38      -3.778  33.728 -16.753  1.00 35.74           C  
ATOM    309  C   ASN    38      -4.611  34.108 -17.985  1.00 37.71           C  
ATOM    310  O   ASN    38      -5.821  33.904 -17.997  1.00 38.33           O  
ATOM    311  CB  ASN    38      -2.888  32.596 -17.240  1.00 35.54           C  
ATOM    312  CG  ASN    38      -1.743  32.260 -16.305  1.00 32.45           C  
ATOM    313  OD1 ASN    38      -1.418  32.983 -15.360  1.00 31.30           O  
ATOM    314  ND2 ASN    38      -1.086  31.167 -16.616  1.00 29.32           N  
ATOM    315  N   GLY    39      -3.966  34.615 -19.038  1.00 39.07           N  
ATOM    316  CA  GLY    39      -4.673  34.919 -20.316  1.00 40.35           C  
ATOM    317  C   GLY    39      -5.968  35.731 -20.235  1.00 40.83           C  
ATOM    318  O   GLY    39      -6.278  36.332 -19.194  1.00 40.09           O  
ATOM    319  N   SER    40      -6.740  35.732 -21.329  1.00 41.52           N  
ATOM    320  CA  SER    40      -7.865  36.680 -21.492  1.00 42.35           C  
ATOM    321  C   SER    40      -9.234  36.028 -21.721  1.00 42.42           C  
ATOM    322  O   SER    40     -10.228  36.715 -22.004  1.00 43.03           O  
ATOM    323  CB  SER    40      -7.598  37.601 -22.677  1.00 42.11           C  
ATOM    324  OG  SER    40      -6.233  37.572 -23.040  1.00 45.27           O  
ATOM    325  N   THR    41      -9.281  34.709 -21.618  1.00 41.48           N  
ATOM    326  CA  THR    41     -10.417  33.957 -22.134  1.00 41.13           C  
ATOM    327  C   THR    41     -10.581  32.795 -21.206  1.00 39.96           C  
ATOM    328  O   THR    41      -9.594  32.339 -20.624  1.00 40.02           O  
ATOM    329  CB  THR    41     -10.133  33.399 -23.575  1.00 41.46           C  
ATOM    330  OG1 THR    41      -8.956  32.575 -23.555  1.00 43.48           O  
ATOM    331  CG2 THR    41      -9.929  34.522 -24.578  1.00 41.84           C  
ATOM    332  N   ARG    42     -11.815  32.308 -21.068  1.00 38.48           N  
ATOM    333  CA  ARG    42     -12.038  31.048 -20.363  1.00 36.84           C  
ATOM    334  C   ARG    42     -11.213  29.948 -21.033  1.00 35.70           C  
ATOM    335  O   ARG    42     -11.159  29.866 -22.259  1.00 35.70           O  
ATOM    336  CB  ARG    42     -13.520  30.666 -20.399  1.00 37.38           C  
ATOM    337  CG  ARG    42     -14.437  31.647 -19.684  1.00 37.62           C  
ATOM    338  CD  ARG    42     -15.883  31.164 -19.697  1.00 36.40           C  
ATOM    339  NE  ARG    42     -16.009  29.965 -18.858  1.00 36.40           N  
ATOM    340  CZ  ARG    42     -16.427  29.976 -17.597  1.00 35.20           C  
ATOM    341  NH1 ARG    42     -16.782  31.144 -17.033  1.00 34.57           N  
ATOM    342  NH2 ARG    42     -16.491  28.833 -16.902  1.00 36.13           N  
ATOM    343  N   GLN    43     -10.641  29.067 -20.218  1.00 34.69           N  
ATOM    344  CA  GLN    43      -9.776  27.977 -20.710  1.00 33.10           C  
ATOM    345  C   GLN    43     -10.503  26.657 -20.692  1.00 32.14           C  
ATOM    346  O   GLN    43     -11.269  26.403 -19.771  1.00 31.59           O  
ATOM    347  CB  GLN    43      -8.558  27.878 -19.802  1.00 33.74           C  
ATOM    348  CG  GLN    43      -7.930  29.264 -19.605  1.00 37.32           C  
ATOM    349  CD  GLN    43      -6.791  29.275 -18.585  1.00 43.97           C  
ATOM    350  OE1 GLN    43      -6.081  28.282 -18.413  1.00 50.03           O  
ATOM    351  NE2 GLN    43      -6.602  30.405 -17.932  1.00 44.66           N  
ATOM    352  N   ASN    44     -10.218  25.808 -21.680  1.00 28.58           N  
ATOM    353  CA  ASN    44     -10.733  24.442 -21.672  1.00 30.12           C  
ATOM    354  C   ASN    44      -9.770  23.560 -20.902  1.00 29.00           C  
ATOM    355  O   ASN    44      -8.722  24.046 -20.428  1.00 29.15           O  
ATOM    356  CB  ASN    44     -11.008  23.943 -23.097  1.00 28.73           C  
ATOM    357  CG  ASN    44      -9.755  23.877 -23.979  1.00 31.42           C  
ATOM    358  OD1 ASN    44      -8.635  23.648 -23.517  1.00 29.93           O  
ATOM    359  ND2 ASN    44      -9.952  24.097 -25.267  1.00 32.12           N  
ATOM    360  N   PHE    45     -10.112  22.277 -20.766  1.00 29.73           N  
ATOM    361  CA  PHE    45      -9.364  21.377 -19.899  1.00 30.13           C  
ATOM    362  C   PHE    45      -7.960  21.157 -20.412  1.00 30.35           C  
ATOM    363  O   PHE    45      -6.999  21.168 -19.616  1.00 29.85           O  
ATOM    364  CB  PHE    45     -10.114  20.083 -19.809  1.00 29.47           C  
ATOM    365  CG  PHE    45      -9.574  19.123 -18.815  1.00 29.78           C  
ATOM    366  CD1 PHE    45     -10.087  19.075 -17.518  1.00 30.76           C  
ATOM    367  CD2 PHE    45      -8.607  18.178 -19.209  1.00 30.09           C  
ATOM    368  CE1 PHE    45      -9.611  18.123 -16.595  1.00 30.36           C  
ATOM    369  CE2 PHE    45      -8.137  17.209 -18.309  1.00 30.04           C  
ATOM    370  CZ  PHE    45      -8.638  17.197 -16.999  1.00 30.03           C  
ATOM    371  N   ASN    46      -7.834  21.028 -21.730  1.00 30.11           N  
ATOM    372  CA  ASN    46      -6.501  20.863 -22.338  0.50 30.41           C  
ATOM    374  C   ASN    46      -5.610  22.071 -22.137  1.00 30.53           C  
ATOM    375  O   ASN    46      -4.413  21.919 -21.905  1.00 31.41           O  
ATOM    376  CB  ASN    46      -6.559  20.545 -23.836  0.50 30.92           C  
ATOM    378  CG  ASN    46      -5.186  20.274 -24.410  0.50 31.12           C  
ATOM    380  OD1 ASN    46      -4.574  19.255 -24.104  0.50 32.62           O  
ATOM    382  ND2 ASN    46      -4.692  21.178 -25.256  0.50 32.99           N  
ATOM    384  N   ASP    47      -6.194  23.271 -22.225  1.00 30.93           N  
ATOM    385  CA  ASP    47      -5.454  24.548 -22.028  1.00 32.46           C  
ATOM    386  C   ASP    47      -4.799  24.554 -20.632  1.00 31.87           C  
ATOM    387  O   ASP    47      -3.628  24.926 -20.456  1.00 30.64           O  
ATOM    388  CB  ASP    47      -6.390  25.776 -22.042  1.00 33.84           C  
ATOM    389  CG  ASP    47      -6.939  26.136 -23.421  1.00 36.73           C  
ATOM    390  OD1 ASP    47      -6.247  25.869 -24.457  1.00 37.68           O  
ATOM    391  OD2 ASP    47      -8.069  26.741 -23.444  1.00 37.94           O  
ATOM    392  N   ILE    48      -5.610  24.187 -19.646  1.00 30.43           N  
ATOM    393  CA  ILE    48      -5.194  24.155 -18.240  1.00 30.48           C  
ATOM    394  C   ILE    48      -4.104  23.108 -18.043  1.00 30.36           C  
ATOM    395  O   ILE    48      -3.036  23.404 -17.506  1.00 29.97           O  
ATOM    396  CB  ILE    48      -6.371  23.864 -17.297  1.00 30.17           C  
ATOM    397  CG1 ILE    48      -7.419  24.969 -17.401  1.00 30.92           C  
ATOM    398  CG2 ILE    48      -5.905  23.796 -15.860  1.00 28.80           C  
ATOM    399  CD1 ILE    48      -8.842  24.500 -16.885  1.00 31.00           C  
ATOM    400  N   ARG    49      -4.369  21.883 -18.500  1.00 29.39           N  
ATOM    401  CA  ARG    49      -3.420  20.778 -18.350  1.00 30.94           C  
ATOM    402  C   ARG    49      -2.065  21.091 -19.006  1.00 30.35           C  
ATOM    403  O   ARG    49      -1.009  20.856 -18.406  1.00 30.44           O  
ATOM    404  CB  ARG    49      -4.045  19.488 -18.920  1.00 30.61           C  
ATOM    405  CG  ARG    49      -3.149  18.233 -18.873  1.00 31.60           C  
ATOM    406  CD  ARG    49      -3.826  17.004 -19.546  1.00 34.32           C  
ATOM    407  NE  ARG    49      -4.109  17.268 -20.958  1.00 39.66           N  
ATOM    408  CZ  ARG    49      -5.158  16.807 -21.645  1.00 43.59           C  
ATOM    409  NH1 ARG    49      -5.287  17.135 -22.920  1.00 45.11           N  
ATOM    410  NH2 ARG    49      -6.084  16.029 -21.078  1.00 45.51           N  
ATOM    411  N   SER    50      -2.101  21.680 -20.210  1.00 30.07           N  
ATOM    412  CA  SER    50      -0.892  22.038 -20.951  1.00 31.54           C  
ATOM    413  C   SER    50      -0.062  23.098 -20.259  1.00 31.04           C  
ATOM    414  O   SER    50       1.149  23.188 -20.479  1.00 30.98           O  
ATOM    415  CB  SER    50      -1.277  22.565 -22.323  1.00 31.85           C  
ATOM    416  OG  SER    50      -1.782  21.515 -23.117  1.00 35.55           O  
ATOM    417  N   SER    51      -0.726  23.903 -19.430  1.00 30.50           N  
ATOM    418  CA  SER    51      -0.096  25.011 -18.723  0.50 30.66           C  
ATOM    420  C   SER    51       0.581  24.579 -17.419  1.00 30.93           C  
ATOM    421  O   SER    51       1.285  25.365 -16.798  1.00 31.22           O  
ATOM    422  CB  SER    51      -1.136  26.084 -18.412  0.50 30.43           C  
ATOM    424  OG  SER    51      -1.691  26.608 -19.599  0.50 30.15           O  
ATOM    426  N   ILE    52       0.358  23.332 -16.992  1.00 30.63           N  
ATOM    427  CA  ILE    52       0.962  22.825 -15.761  1.00 30.93           C  
ATOM    428  C   ILE    52       1.750  21.562 -16.111  1.00 31.45           C  
ATOM    429  O   ILE    52       1.195  20.460 -16.071  1.00 30.76           O  
ATOM    430  CB  ILE    52      -0.103  22.540 -14.635  1.00 30.84           C  
ATOM    431  CG1 ILE    52      -0.951  23.787 -14.375  1.00 31.83           C  
ATOM    432  CG2 ILE    52       0.588  22.082 -13.347  1.00 33.13           C  
ATOM    433  CD1 ILE    52      -2.186  23.546 -13.496  1.00 30.67           C  
ATOM    434  N   PRO    53       3.082  21.708 -16.248  0.50 32.17           N  
ATOM    436  CA  PRO    53       3.995  20.623 -16.611  0.50 32.18           C  
ATOM    438  C   PRO    53       3.709  19.347 -15.822  0.50 32.28           C  
ATOM    440  O   PRO    53       3.717  19.382 -14.589  0.50 32.32           O  
ATOM    442  CB  PRO    53       5.360  21.173 -16.185  0.50 32.32           C  
ATOM    444  CG  PRO    53       5.235  22.622 -16.320  0.50 32.43           C  
ATOM    446  CD  PRO    53       3.811  22.965 -15.984  0.50 31.62           C  
ATOM    448  N   GLY    54       3.447  18.225 -16.496  1.00 32.85           N  
ATOM    449  CA  GLY    54       3.374  17.000 -15.702  1.00 32.55           C  
ATOM    450  C   GLY    54       2.099  16.623 -14.957  1.00 31.92           C  
ATOM    451  O   GLY    54       2.011  15.492 -14.456  1.00 32.11           O  
ATOM    452  N   ILE    55       1.118  17.529 -14.849  1.00 30.84           N  
ATOM    453  CA  ILE    55      -0.154  17.165 -14.215  1.00 30.41           C  
ATOM    454  C   ILE    55      -0.915  16.120 -15.068  1.00 29.49           C  
ATOM    455  O   ILE    55      -0.989  16.260 -16.283  1.00 30.15           O  
ATOM    456  CB  ILE    55      -1.063  18.423 -13.944  1.00 29.10           C  
ATOM    457  CG1 ILE    55      -2.135  18.085 -12.899  1.00 29.13           C  
ATOM    458  CG2 ILE    55      -1.667  18.984 -15.247  1.00 29.74           C  
ATOM    459  CD1 ILE    55      -2.960  19.283 -12.328  1.00 31.94           C  
ATOM    460  N   SER    56      -1.463  15.079 -14.438  1.00 29.28           N  
ATOM    461  CA  SER    56      -2.278  14.092 -15.168  1.00 29.08           C  
ATOM    462  C   SER    56      -3.714  14.586 -15.333  1.00 28.45           C  
ATOM    463  O   SER    56      -4.179  15.450 -14.576  1.00 29.02           O  
ATOM    464  CB  SER    56      -2.299  12.746 -14.442  1.00 28.31           C  
ATOM    465  OG  SER    56      -2.957  12.908 -13.195  1.00 29.25           O  
ATOM    466  N   SER    57      -4.406  14.056 -16.344  1.00 28.29           N  
ATOM    467  CA  SER    57      -5.828  14.379 -16.512  1.00 29.38           C  
ATOM    468  C   SER    57      -6.598  13.995 -15.255  1.00 29.47           C  
ATOM    469  O   SER    57      -7.478  14.724 -14.829  1.00 30.03           O  
ATOM    470  CB  SER    57      -6.435  13.657 -17.706  1.00 30.29           C  
ATOM    471  OG  SER    57      -5.870  14.138 -18.902  1.00 32.01           O  
ATOM    472  N   THR    58      -6.284  12.829 -14.689  1.00 29.45           N  
ATOM    473  CA  THR    58      -6.990  12.360 -13.493  1.00 29.58           C  
ATOM    474  C   THR    58      -6.852  13.352 -12.330  1.00 29.16           C  
ATOM    475  O   THR    58      -7.844  13.700 -11.705  1.00 28.38           O  
ATOM    476  CB  THR    58      -6.582  10.923 -13.070  1.00 30.87           C  
ATOM    477  OG1 THR    58      -7.006   9.978 -14.073  1.00 30.95           O  
ATOM    478  CG2 THR    58      -7.222  10.541 -11.705  1.00 31.28           C  
ATOM    479  N   ILE    59      -5.627  13.765 -12.025  1.00 27.97           N  
ATOM    480  CA  ILE    59      -5.407  14.700 -10.912  1.00 29.61           C  
ATOM    481  C   ILE    59      -6.061  16.042 -11.228  1.00 29.82           C  
ATOM    482  O   ILE    59      -6.692  16.670 -10.357  1.00 29.80           O  
ATOM    483  CB  ILE    59      -3.881  14.856 -10.573  1.00 29.39           C  
ATOM    484  CG1 ILE    59      -3.316  13.496 -10.114  1.00 32.81           C  
ATOM    485  CG2 ILE    59      -3.632  16.061  -9.578  1.00 30.71           C  
ATOM    486  CD1 ILE    59      -3.982  12.929  -8.899  1.00 36.38           C  
ATOM    487  N   LEU    60      -5.922  16.507 -12.470  1.00 29.61           N  
ATOM    488  CA  LEU    60      -6.524  17.797 -12.820  1.00 28.72           C  
ATOM    489  C   LEU    60      -8.036  17.760 -12.640  1.00 29.13           C  
ATOM    490  O   LEU    60      -8.622  18.704 -12.099  1.00 29.42           O  
ATOM    491  CB  LEU    60      -6.157  18.260 -14.223  1.00 29.24           C  
ATOM    492  CG  LEU    60      -6.748  19.605 -14.712  1.00 28.18           C  
ATOM    493  CD1 LEU    60      -6.409  20.769 -13.803  1.00 29.10           C  
ATOM    494  CD2 LEU    60      -6.285  19.900 -16.141  1.00 29.94           C  
ATOM    495  N   SER    61      -8.653  16.682 -13.083  1.00 28.67           N  
ATOM    496  CA  SER    61     -10.114  16.544 -12.999  1.00 27.98           C  
ATOM    497  C   SER    61     -10.550  16.492 -11.516  1.00 28.84           C  
ATOM    498  O   SER    61     -11.545  17.126 -11.124  1.00 30.15           O  
ATOM    499  CB  SER    61     -10.545  15.269 -13.742  1.00 28.77           C  
ATOM    500  OG  SER    61     -11.943  15.111 -13.618  1.00 30.82           O  
ATOM    501  N   ARG    62      -9.804  15.751 -10.700  1.00 28.63           N  
ATOM    502  CA  ARG    62     -10.132  15.579  -9.274  0.50 29.99           C  
ATOM    504  C   ARG    62     -10.003  16.912  -8.545  1.00 29.34           C  
ATOM    505  O   ARG    62     -10.857  17.266  -7.723  1.00 29.15           O  
ATOM    506  CB  ARG    62      -9.247  14.513  -8.608  0.50 29.81           C  
ATOM    508  CG  ARG    62      -9.668  14.178  -7.172  0.50 31.40           C  
ATOM    510  CD  ARG    62      -8.791  13.120  -6.495  0.50 31.62           C  
ATOM    512  NE  ARG    62      -8.467  13.515  -5.124  0.50 36.53           N  
ATOM    514  CZ  ARG    62      -7.951  12.730  -4.183  0.50 36.11           C  
ATOM    516  NH1 ARG    62      -7.698  11.442  -4.416  0.50 37.63           N  
ATOM    518  NH2 ARG    62      -7.692  13.248  -2.987  0.50 37.15           N  
ATOM    520  N   ARG    63      -8.941  17.663  -8.858  1.00 28.62           N  
ATOM    521  CA  ARG    63      -8.761  18.974  -8.210  1.00 29.17           C  
ATOM    522  C   ARG    63      -9.802  20.015  -8.647  1.00 28.84           C  
ATOM    523  O   ARG    63     -10.327  20.781  -7.819  1.00 28.65           O  
ATOM    524  CB  ARG    63      -7.359  19.560  -8.460  1.00 29.44           C  
ATOM    525  CG  ARG    63      -6.226  18.768  -7.890  1.00 30.90           C  
ATOM    526  CD  ARG    63      -6.146  18.743  -6.379  1.00 33.16           C  
ATOM    527  NE  ARG    63      -4.832  18.204  -6.097  1.00 37.27           N  
ATOM    528  CZ  ARG    63      -4.595  16.895  -5.971  1.00 37.04           C  
ATOM    529  NH1 ARG    63      -5.614  16.023  -5.998  1.00 37.29           N  
ATOM    530  NH2 ARG    63      -3.363  16.461  -5.783  1.00 36.96           N  
ATOM    531  N   ILE    64     -10.151  19.980  -9.933  1.00 29.26           N  
ATOM    532  CA  ILE    64     -11.184  20.856 -10.463  1.00 30.51           C  
ATOM    533  C   ILE    64     -12.504  20.549  -9.741  1.00 30.34           C  
ATOM    534  O   ILE    64     -13.196  21.480  -9.345  1.00 30.98           O  
ATOM    535  CB  ILE    64     -11.290  20.731 -12.003  1.00 30.62           C  
ATOM    536  CG1 ILE    64     -10.127  21.548 -12.614  1.00 30.31           C  
ATOM    537  CG2 ILE    64     -12.675  21.243 -12.495  1.00 31.48           C  
ATOM    538  CD1 ILE    64     -10.156  21.630 -14.161  1.00 32.83           C  
ATOM    539  N   LYS    65     -12.838  19.279  -9.553  1.00 30.75           N  
ATOM    540  CA  LYS    65     -14.099  18.954  -8.873  1.00 30.94           C  
ATOM    541  C   LYS    65     -14.073  19.525  -7.445  1.00 30.64           C  
ATOM    542  O   LYS    65     -15.081  20.079  -6.977  1.00 30.81           O  
ATOM    543  CB  LYS    65     -14.299  17.457  -8.818  1.00 31.13           C  
ATOM    544  CG  LYS    65     -15.503  17.061  -8.007  1.00 33.76           C  
ATOM    545  CD  LYS    65     -15.587  15.568  -7.851  1.00 38.55           C  
ATOM    546  CE  LYS    65     -16.586  15.242  -6.746  1.00 40.18           C  
ATOM    547  NZ  LYS    65     -17.892  15.885  -7.064  1.00 43.76           N  
ATOM    548  N   ASP    66     -12.931  19.398  -6.765  1.00 29.42           N  
ATOM    549  CA  ASP    66     -12.878  19.802  -5.360  1.00 29.50           C  
ATOM    550  C   ASP    66     -12.978  21.320  -5.356  1.00 28.62           C  
ATOM    551  O   ASP    66     -13.574  21.903  -4.442  1.00 28.98           O  
ATOM    552  CB  ASP    66     -11.568  19.384  -4.683  1.00 30.07           C  
ATOM    553  CG  ASP    66     -11.473  17.900  -4.419  1.00 34.15           C  
ATOM    554  OD1 ASP    66     -12.523  17.216  -4.358  1.00 36.32           O  
ATOM    555  OD2 ASP    66     -10.306  17.461  -4.241  1.00 37.95           O  
ATOM    556  N   LEU    67     -12.352  21.941  -6.358  1.00 28.40           N  
ATOM    557  CA  LEU    67     -12.398  23.406  -6.450  1.00 26.03           C  
ATOM    558  C   LEU    67     -13.796  23.953  -6.748  1.00 27.98           C  
ATOM    559  O   LEU    67     -14.183  25.012  -6.231  1.00 28.27           O  
ATOM    560  CB  LEU    67     -11.369  23.956  -7.460  1.00 27.42           C  
ATOM    561  CG  LEU    67      -9.912  23.918  -7.004  1.00 26.45           C  
ATOM    562  CD1 LEU    67      -8.964  24.037  -8.262  1.00 26.39           C  
ATOM    563  CD2 LEU    67      -9.529  24.911  -5.930  1.00 28.59           C  
ATOM    564  N   ILE    68     -14.528  23.250  -7.605  1.00 27.87           N  
ATOM    565  CA  ILE    68     -15.940  23.586  -7.890  1.00 28.22           C  
ATOM    566  C   ILE    68     -16.769  23.403  -6.601  1.00 28.92           C  
ATOM    567  O   ILE    68     -17.548  24.276  -6.211  1.00 28.86           O  
ATOM    568  CB  ILE    68     -16.476  22.704  -9.021  1.00 27.86           C  
ATOM    569  CG1 ILE    68     -15.802  23.072 -10.349  1.00 28.61           C  
ATOM    570  CG2 ILE    68     -18.028  22.831  -9.113  1.00 27.84           C  
ATOM    571  CD1 ILE    68     -16.125  22.075 -11.499  1.00 28.47           C  
ATOM    572  N   ASP    69     -16.594  22.272  -5.938  1.00 28.29           N  
ATOM    573  CA  ASP    69     -17.330  21.994  -4.694  1.00 30.66           C  
ATOM    574  C   ASP    69     -17.075  23.052  -3.605  1.00 30.59           C  
ATOM    575  O   ASP    69     -17.985  23.383  -2.830  1.00 30.51           O  
ATOM    576  CB  ASP    69     -17.027  20.579  -4.213  1.00 31.59           C  
ATOM    577  CG  ASP    69     -17.624  19.495  -5.126  1.00 36.35           C  
ATOM    578  OD1 ASP    69     -18.394  19.819  -6.069  1.00 40.91           O  
ATOM    579  OD2 ASP    69     -17.328  18.310  -4.891  1.00 39.91           O  
ATOM    580  N   SER    70     -15.853  23.586  -3.572  1.00 29.87           N  
ATOM    581  CA  SER    70     -15.437  24.584  -2.588  0.50 30.17           C  
ATOM    583  C   SER    70     -15.789  26.016  -2.991  1.00 30.20           C  
ATOM    584  O   SER    70     -15.532  26.952  -2.232  1.00 30.92           O  
ATOM    585  CB  SER    70     -13.943  24.429  -2.284  0.50 30.09           C  
ATOM    587  OG  SER    70     -13.709  23.157  -1.691  0.50 30.21           O  
ATOM    589  N   GLY    71     -16.394  26.165  -4.179  1.00 29.53           N  
ATOM    590  CA  GLY    71     -16.882  27.465  -4.672  1.00 29.80           C  
ATOM    591  C   GLY    71     -15.812  28.391  -5.225  1.00 29.21           C  
ATOM    592  O   GLY    71     -16.036  29.606  -5.344  1.00 30.11           O  
ATOM    593  N   LEU    72     -14.640  27.843  -5.539  1.00 29.88           N  
ATOM    594  CA  LEU    72     -13.531  28.642  -6.076  1.00 27.91           C  
ATOM    595  C   LEU    72     -13.447  28.627  -7.607  1.00 29.19           C  
ATOM    596  O   LEU    72     -12.812  29.516  -8.183  1.00 29.94           O  
ATOM    597  CB  LEU    72     -12.163  28.156  -5.486  1.00 28.59           C  
ATOM    598  CG  LEU    72     -12.171  28.194  -3.931  1.00 26.72           C  
ATOM    599  CD1 LEU    72     -10.820  27.769  -3.470  1.00 30.74           C  
ATOM    600  CD2 LEU    72     -12.484  29.610  -3.415  1.00 28.81           C  
ATOM    601  N   VAL    73     -14.018  27.598  -8.242  1.00 29.25           N  
ATOM    602  CA  VAL    73     -13.976  27.432  -9.732  1.00 28.03           C  
ATOM    603  C   VAL    73     -15.383  27.076 -10.215  1.00 28.87           C  
ATOM    604  O   VAL    73     -16.167  26.488  -9.479  1.00 28.62           O  
ATOM    605  CB  VAL    73     -12.975  26.327 -10.078  1.00 28.54           C  
ATOM    606  CG1 VAL    73     -13.062  25.848 -11.565  1.00 29.42           C  
ATOM    607  CG2 VAL    73     -11.558  26.814  -9.766  1.00 28.41           C  
ATOM    608  N   GLU    74     -15.715  27.487 -11.438  1.00 28.71           N  
ATOM    609  CA  GLU    74     -16.949  27.008 -12.060  1.00 29.45           C  
ATOM    610  C   GLU    74     -16.650  26.532 -13.474  1.00 31.15           C  
ATOM    611  O   GLU    74     -15.697  27.033 -14.142  1.00 29.70           O  
ATOM    612  CB  GLU    74     -18.030  28.096 -12.043  1.00 30.64           C  
ATOM    613  CG  GLU    74     -17.544  29.452 -12.480  1.00 35.69           C  
ATOM    614  CD  GLU    74     -17.767  29.745 -13.959  1.00 43.35           C  
ATOM    615  OE1 GLU    74     -17.538  30.908 -14.348  1.00 42.21           O  
ATOM    616  OE2 GLU    74     -18.184  28.825 -14.717  1.00 46.17           O  
ATOM    617  N   ARG    75     -17.435  25.533 -13.904  1.00 29.67           N  
ATOM    618  CA  ARG    75     -17.367  24.986 -15.271  1.00 30.13           C  
ATOM    619  C   ARG    75     -18.541  25.565 -16.078  1.00 30.14           C  
ATOM    620  O   ARG    75     -19.672  25.598 -15.587  1.00 30.30           O  
ATOM    621  CB  ARG    75     -17.453  23.453 -15.230  1.00 31.80           C  
ATOM    622  CG  ARG    75     -17.545  22.772 -16.614  1.00 31.36           C  
ATOM    623  CD  ARG    75     -17.947  21.238 -16.501  1.00 32.95           C  
ATOM    624  NE  ARG    75     -16.903  20.561 -15.799  1.00 37.99           N  
ATOM    625  CZ  ARG    75     -17.011  20.103 -14.558  1.00 41.51           C  
ATOM    626  NH1 ARG    75     -15.955  19.524 -13.989  1.00 38.82           N  
ATOM    627  NH2 ARG    75     -18.156  20.254 -13.891  1.00 42.15           N  
ATOM    628  N   ARG    76     -18.256  26.059 -17.286  1.00 28.92           N  
ATOM    629  CA  ARG    76     -19.335  26.418 -18.189  1.00 29.77           C  
ATOM    630  C   ARG    76     -19.443  25.379 -19.284  1.00 28.36           C  
ATOM    631  O   ARG    76     -18.472  25.191 -19.986  1.00 28.53           O  
ATOM    632  CB  ARG    76     -19.014  27.759 -18.849  1.00 30.56           C  
ATOM    633  CG  ARG    76     -20.132  28.268 -19.753  1.00 32.27           C  
ATOM    634  CD  ARG    76     -19.709  29.566 -20.461  1.00 31.81           C  
ATOM    635  NE  ARG    76     -20.762  30.087 -21.329  1.00 35.20           N  
ATOM    636  CZ  ARG    76     -20.930  29.732 -22.607  1.00 36.59           C  
ATOM    637  NH1 ARG    76     -20.085  28.872 -23.182  1.00 38.21           N  
ATOM    638  NH2 ARG    76     -21.934  30.246 -23.323  1.00 33.02           N  
ATOM    639  N   SER    77     -20.602  24.744 -19.459  1.00 28.58           N  
ATOM    640  CA  SER    77     -20.793  23.830 -20.561  1.00 28.95           C  
ATOM    641  C   SER    77     -21.573  24.569 -21.627  1.00 28.76           C  
ATOM    642  O   SER    77     -22.773  24.848 -21.455  1.00 28.16           O  
ATOM    643  CB  SER    77     -21.593  22.567 -20.165  1.00 30.53           C  
ATOM    644  OG  SER    77     -21.065  21.915 -19.027  1.00 35.64           O  
ATOM    645  N   GLY    78     -20.872  24.945 -22.693  1.00 29.21           N  
ATOM    646  CA  GLY    78     -21.482  25.588 -23.853  1.00 28.28           C  
ATOM    647  C   GLY    78     -21.171  24.726 -25.077  1.00 29.02           C  
ATOM    648  O   GLY    78     -21.147  23.505 -25.000  1.00 28.84           O  
ATOM    649  N   GLN    79     -20.948  25.342 -26.225  1.00 27.77           N  
ATOM    650  CA  GLN    79     -20.537  24.548 -27.377  1.00 27.63           C  
ATOM    651  C   GLN    79     -19.154  23.969 -27.103  1.00 28.99           C  
ATOM    652  O   GLN    79     -18.795  22.934 -27.680  1.00 29.21           O  
ATOM    653  CB  GLN    79     -20.566  25.381 -28.641  1.00 27.27           C  
ATOM    654  CG  GLN    79     -21.998  25.699 -29.015  1.00 26.64           C  
ATOM    655  CD  GLN    79     -22.134  26.542 -30.255  1.00 28.25           C  
ATOM    656  OE1 GLN    79     -21.501  27.589 -30.389  1.00 32.85           O  
ATOM    657  NE2 GLN    79     -22.982  26.116 -31.146  1.00 29.95           N  
ATOM    658  N   ILE    80     -18.384  24.656 -26.263  1.00 27.96           N  
ATOM    659  CA  ILE    80     -17.164  24.076 -25.650  1.00 29.86           C  
ATOM    660  C   ILE    80     -17.307  24.171 -24.130  1.00 29.27           C  
ATOM    661  O   ILE    80     -18.156  24.927 -23.647  1.00 30.11           O  
ATOM    662  CB  ILE    80     -15.864  24.780 -26.129  1.00 28.85           C  
ATOM    663  CG1 ILE    80     -15.856  26.261 -25.702  1.00 32.17           C  
ATOM    664  CG2 ILE    80     -15.718  24.643 -27.669  1.00 31.06           C  
ATOM    665  CD1 ILE    80     -14.545  27.043 -26.035  1.00 33.47           C  
ATOM    666  N   THR    81     -16.510  23.384 -23.403  1.00 28.43           N  
ATOM    667  CA  THR    81     -16.523  23.384 -21.939  1.00 28.22           C  
ATOM    668  C   THR    81     -15.289  24.116 -21.452  1.00 28.52           C  
ATOM    669  O   THR    81     -14.147  23.787 -21.846  1.00 28.61           O  
ATOM    670  CB  THR    81     -16.507  21.956 -21.396  1.00 28.75           C  
ATOM    671  OG1 THR    81     -17.690  21.294 -21.859  1.00 31.34           O  
ATOM    672  CG2 THR    81     -16.522  21.955 -19.869  1.00 31.08           C  
ATOM    673  N   THR    82     -15.511  25.118 -20.609  1.00 28.37           N  
ATOM    674  CA  THR    82     -14.420  25.966 -20.131  1.00 28.26           C  
ATOM    675  C   THR    82     -14.554  26.187 -18.621  1.00 28.32           C  
ATOM    676  O   THR    82     -15.614  25.907 -18.059  1.00 28.07           O  
ATOM    677  CB  THR    82     -14.405  27.336 -20.844  1.00 29.29           C  
ATOM    678  OG1 THR    82     -15.659  27.982 -20.635  1.00 29.38           O  
ATOM    679  CG2 THR    82     -14.132  27.169 -22.361  1.00 28.94           C  
ATOM    680  N   TYR    83     -13.491  26.716 -18.007  1.00 29.04           N  
ATOM    681  CA  TYR    83     -13.385  26.842 -16.558  1.00 29.15           C  
ATOM    682  C   TYR    83     -12.886  28.258 -16.250  1.00 29.55           C  
ATOM    683  O   TYR    83     -12.141  28.869 -17.020  1.00 29.25           O  
ATOM    684  CB  TYR    83     -12.394  25.778 -16.021  1.00 29.63           C  
ATOM    685  CG  TYR    83     -12.761  24.318 -16.395  1.00 30.27           C  
ATOM    686  CD1 TYR    83     -13.449  23.507 -15.494  1.00 31.09           C  
ATOM    687  CD2 TYR    83     -12.454  23.785 -17.656  1.00 30.34           C  
ATOM    688  CE1 TYR    83     -13.815  22.160 -15.849  1.00 31.37           C  
ATOM    689  CE2 TYR    83     -12.820  22.456 -18.012  1.00 31.96           C  
ATOM    690  CZ  TYR    83     -13.499  21.681 -17.099  1.00 31.74           C  
ATOM    691  OH  TYR    83     -13.848  20.397 -17.475  1.00 34.84           O  
ATOM    692  N   ALA    84     -13.306  28.758 -15.102  1.00 30.07           N  
ATOM    693  CA  ALA    84     -12.898  30.065 -14.658  1.00 29.00           C  
ATOM    694  C   ALA    84     -12.974  30.097 -13.138  1.00 29.39           C  
ATOM    695  O   ALA    84     -13.731  29.355 -12.503  1.00 28.04           O  
ATOM    696  CB  ALA    84     -13.828  31.155 -15.236  1.00 30.87           C  
ATOM    697  N   LEU    85     -12.208  31.004 -12.562  1.00 27.83           N  
ATOM    698  CA  LEU    85     -12.313  31.261 -11.129  1.00 28.72           C  
ATOM    699  C   LEU    85     -13.618  32.020 -10.833  1.00 28.37           C  
ATOM    700  O   LEU    85     -14.051  32.924 -11.592  1.00 29.93           O  
ATOM    701  CB  LEU    85     -11.128  32.118 -10.707  1.00 29.13           C  
ATOM    702  CG  LEU    85      -9.774  31.409 -10.790  1.00 29.42           C  
ATOM    703  CD1 LEU    85      -8.737  32.458 -10.474  1.00 30.83           C  
ATOM    704  CD2 LEU    85      -9.702  30.240  -9.791  1.00 32.79           C  
ATOM    705  N   THR    86     -14.234  31.677  -9.709  1.00 28.05           N  
ATOM    706  CA  THR    86     -15.306  32.493  -9.150  1.00 29.08           C  
ATOM    707  C   THR    86     -14.710  33.730  -8.469  1.00 28.70           C  
ATOM    708  O   THR    86     -13.473  33.872  -8.366  1.00 28.56           O  
ATOM    709  CB  THR    86     -16.066  31.686  -8.083  1.00 28.31           C  
ATOM    710  OG1 THR    86     -15.160  31.412  -7.011  1.00 28.09           O  
ATOM    711  CG2 THR    86     -16.670  30.391  -8.671  1.00 29.71           C  
ATOM    712  N   GLU    87     -15.565  34.643  -7.995  1.00 28.48           N  
ATOM    713  CA  GLU    87     -15.087  35.783  -7.197  1.00 28.21           C  
ATOM    714  C   GLU    87     -14.224  35.303  -6.039  1.00 27.98           C  
ATOM    715  O   GLU    87     -13.143  35.843  -5.801  1.00 28.08           O  
ATOM    716  CB  GLU    87     -16.260  36.608  -6.654  1.00 28.97           C  
ATOM    717  CG  GLU    87     -15.795  37.776  -5.817  1.00 32.03           C  
ATOM    718  CD  GLU    87     -16.834  38.866  -5.668  1.00 37.40           C  
ATOM    719  OE1 GLU    87     -17.999  38.681  -6.105  1.00 39.68           O  
ATOM    720  OE2 GLU    87     -16.472  39.919  -5.102  1.00 40.80           O  
ATOM    721  N   LYS    88     -14.678  34.267  -5.336  1.00 26.90           N  
ATOM    722  CA  LYS    88     -13.841  33.696  -4.236  1.00 27.64           C  
ATOM    723  C   LYS    88     -12.505  33.134  -4.735  1.00 27.48           C  
ATOM    724  O   LYS    88     -11.465  33.369  -4.095  1.00 28.05           O  
ATOM    725  CB  LYS    88     -14.587  32.639  -3.428  1.00 26.47           C  
ATOM    726  CG  LYS    88     -15.766  33.197  -2.592  1.00 29.97           C  
ATOM    727  CD  LYS    88     -16.520  32.055  -1.986  1.00 31.77           C  
ATOM    728  CE  LYS    88     -17.639  32.571  -1.077  1.00 34.52           C  
ATOM    729  NZ  LYS    88     -18.530  31.437  -0.636  1.00 37.09           N  
ATOM    730  N   GLY    89     -12.521  32.417  -5.859  1.00 27.29           N  
ATOM    731  CA  GLY    89     -11.278  31.833  -6.408  1.00 27.82           C  
ATOM    732  C   GLY    89     -10.300  32.939  -6.789  1.00 27.71           C  
ATOM    733  O   GLY    89      -9.070  32.813  -6.559  1.00 26.30           O  
ATOM    734  N   MET    90     -10.832  34.020  -7.352  1.00 28.52           N  
ATOM    735  CA  MET    90      -9.968  35.159  -7.726  1.00 29.23           C  
ATOM    736  C   MET    90      -9.369  35.854  -6.476  1.00 29.18           C  
ATOM    737  O   MET    90      -8.189  36.250  -6.463  1.00 28.95           O  
ATOM    738  CB  MET    90     -10.714  36.183  -8.595  1.00 30.36           C  
ATOM    739  CG  MET    90      -9.775  37.308  -9.095  1.00 32.97           C  
ATOM    740  SD  MET    90      -8.279  36.659 -10.240  0.55 36.03          SE  
ATOM    741  CE  MET    90      -9.351  35.987 -11.693  1.00 35.53           C  
ATOM    742  N   ASN    91     -10.150  35.940  -5.409  1.00 28.62           N  
ATOM    743  CA  ASN    91      -9.609  36.407  -4.128  1.00 28.64           C  
ATOM    744  C   ASN    91      -8.476  35.527  -3.605  1.00 27.84           C  
ATOM    745  O   ASN    91      -7.444  36.019  -3.139  1.00 27.84           O  
ATOM    746  CB  ASN    91     -10.720  36.491  -3.084  1.00 29.00           C  
ATOM    747  CG  ASN    91     -11.716  37.587  -3.386  1.00 29.45           C  
ATOM    748  OD1 ASN    91     -11.392  38.575  -4.056  1.00 27.66           O  
ATOM    749  ND2 ASN    91     -12.930  37.423  -2.905  1.00 28.75           N  
ATOM    750  N   VAL    92      -8.668  34.219  -3.635  1.00 27.04           N  
ATOM    751  CA  VAL    92      -7.552  33.325  -3.311  1.00 28.12           C  
ATOM    752  C   VAL    92      -6.323  33.601  -4.207  1.00 27.67           C  
ATOM    753  O   VAL    92      -5.209  33.665  -3.716  1.00 26.90           O  
ATOM    754  CB  VAL    92      -7.997  31.843  -3.442  1.00 28.20           C  
ATOM    755  CG1 VAL    92      -6.780  30.843  -3.275  1.00 27.42           C  
ATOM    756  CG2 VAL    92      -9.135  31.524  -2.399  1.00 30.21           C  
ATOM    757  N   ARG    93      -6.548  33.772  -5.506  1.00 28.09           N  
ATOM    758  CA  ARG    93      -5.422  33.888  -6.432  1.00 28.32           C  
ATOM    759  C   ARG    93      -4.688  35.143  -6.068  1.00 27.74           C  
ATOM    760  O   ARG    93      -3.454  35.180  -6.049  1.00 27.95           O  
ATOM    761  CB  ARG    93      -5.888  33.967  -7.868  1.00 28.07           C  
ATOM    762  CG  ARG    93      -4.693  33.906  -8.838  1.00 25.86           C  
ATOM    763  CD  ARG    93      -5.157  34.048 -10.247  1.00 26.49           C  
ATOM    764  NE  ARG    93      -4.120  33.795 -11.241  1.00 28.18           N  
ATOM    765  CZ  ARG    93      -3.202  34.673 -11.649  1.00 29.31           C  
ATOM    766  NH1 ARG    93      -2.287  34.306 -12.557  1.00 25.94           N  
ATOM    767  NH2 ARG    93      -3.198  35.916 -11.166  1.00 26.86           N  
ATOM    768  N   ASN    94      -5.459  36.176  -5.767  1.00 28.92           N  
ATOM    769  CA  ASN    94      -4.886  37.494  -5.404  1.00 29.99           C  
ATOM    770  C   ASN    94      -3.915  37.371  -4.211  1.00 32.12           C  
ATOM    771  O   ASN    94      -2.841  37.961  -4.232  1.00 31.33           O  
ATOM    772  CB  ASN    94      -5.971  38.543  -5.091  1.00 30.37           C  
ATOM    773  CG  ASN    94      -6.675  39.043  -6.340  1.00 32.67           C  
ATOM    774  OD1 ASN    94      -6.194  38.840  -7.464  1.00 32.25           O  
ATOM    775  ND2 ASN    94      -7.838  39.681  -6.155  1.00 32.87           N  
ATOM    776  N   SER    95      -4.292  36.604  -3.190  1.00 32.21           N  
ATOM    777  CA  SER    95      -3.400  36.395  -2.041  0.50 33.67           C  
ATOM    779  C   SER    95      -2.286  35.405  -2.316  1.00 33.56           C  
ATOM    780  O   SER    95      -1.258  35.427  -1.651  1.00 35.19           O  
ATOM    781  CB  SER    95      -4.179  35.979  -0.796  0.50 33.85           C  
ATOM    783  OG  SER    95      -5.282  36.826  -0.602  0.50 34.68           O  
ATOM    785  N   LEU    96      -2.471  34.542  -3.311  1.00 32.37           N  
ATOM    786  CA  LEU    96      -1.491  33.550  -3.647  1.00 32.67           C  
ATOM    787  C   LEU    96      -0.295  34.105  -4.388  1.00 30.83           C  
ATOM    788  O   LEU    96       0.820  33.633  -4.159  1.00 30.82           O  
ATOM    789  CB  LEU    96      -2.157  32.477  -4.517  1.00 33.56           C  
ATOM    790  CG  LEU    96      -1.710  31.050  -4.639  1.00 38.72           C  
ATOM    791  CD1 LEU    96      -1.362  30.451  -3.239  1.00 35.81           C  
ATOM    792  CD2 LEU    96      -2.842  30.238  -5.358  1.00 34.93           C  
ATOM    793  N   MET    97      -0.504  35.093  -5.271  1.00 30.72           N  
ATOM    794  CA  MET    97       0.573  35.499  -6.198  1.00 30.72           C  
ATOM    795  C   MET    97       1.842  36.013  -5.490  1.00 29.84           C  
ATOM    796  O   MET    97       2.933  35.641  -5.896  1.00 30.74           O  
ATOM    797  CB  MET    97       0.075  36.444  -7.294  1.00 31.52           C  
ATOM    798  CG  MET    97      -1.008  35.843  -8.209  1.00 34.65           C  
ATOM    799  SD  MET    97      -0.818  33.923  -8.692  0.70 44.93          SE  
ATOM    800  CE  MET    97       0.709  34.110  -9.778  1.00 41.24           C  
ATOM    801  N   PRO    98       1.715  36.844  -4.434  1.00 29.05           N  
ATOM    802  CA  PRO    98       2.974  37.244  -3.779  1.00 29.62           C  
ATOM    803  C   PRO    98       3.757  36.083  -3.167  1.00 29.38           C  
ATOM    804  O   PRO    98       5.012  36.095  -3.173  1.00 28.71           O  
ATOM    805  CB  PRO    98       2.511  38.270  -2.724  1.00 27.95           C  
ATOM    806  CG  PRO    98       1.158  38.780  -3.240  1.00 29.52           C  
ATOM    807  CD  PRO    98       0.549  37.499  -3.812  1.00 28.86           C  
ATOM    808  N   LEU    99       3.042  35.062  -2.695  1.00 29.20           N  
ATOM    809  CA  LEU    99       3.663  33.870  -2.139  1.00 29.63           C  
ATOM    810  C   LEU    99       4.396  33.115  -3.247  1.00 28.97           C  
ATOM    811  O   LEU    99       5.587  32.776  -3.087  1.00 29.73           O  
ATOM    812  CB  LEU    99       2.619  32.977  -1.497  1.00 29.90           C  
ATOM    813  CG  LEU    99       3.168  31.683  -0.942  1.00 31.39           C  
ATOM    814  CD1 LEU    99       4.202  31.905   0.205  1.00 30.66           C  
ATOM    815  CD2 LEU    99       1.990  30.860  -0.502  1.00 31.76           C  
ATOM    816  N   LEU   100       3.718  32.889  -4.374  1.00 28.17           N  
ATOM    817  CA  LEU   100       4.364  32.230  -5.503  1.00 28.95           C  
ATOM    818  C   LEU   100       5.550  33.020  -6.085  1.00 27.53           C  
ATOM    819  O   LEU   100       6.573  32.418  -6.447  1.00 27.72           O  
ATOM    820  CB  LEU   100       3.347  31.799  -6.572  1.00 29.88           C  
ATOM    821  CG  LEU   100       2.325  30.758  -6.059  1.00 31.71           C  
ATOM    822  CD1 LEU   100       1.399  30.347  -7.205  1.00 34.06           C  
ATOM    823  CD2 LEU   100       2.939  29.510  -5.392  1.00 35.43           C  
ATOM    824  N   GLN   101       5.420  34.352  -6.171  1.00 28.07           N  
ATOM    825  CA  GLN   101       6.504  35.194  -6.585  1.00 28.02           C  
ATOM    826  C   GLN   101       7.722  34.903  -5.698  1.00 28.41           C  
ATOM    827  O   GLN   101       8.818  34.657  -6.213  1.00 27.55           O  
ATOM    828  CB  GLN   101       6.085  36.661  -6.502  1.00 27.70           C  
ATOM    829  CG  GLN   101       7.155  37.657  -6.935  1.00 29.75           C  
ATOM    830  CD  GLN   101       6.627  39.072  -6.900  1.00 36.26           C  
ATOM    831  OE1 GLN   101       6.218  39.568  -5.838  1.00 39.47           O  
ATOM    832  NE2 GLN   101       6.614  39.734  -8.055  1.00 36.49           N  
ATOM    833  N   TYR   102       7.514  34.893  -4.378  1.00 27.05           N  
ATOM    834  CA  TYR   102       8.673  34.752  -3.497  1.00 27.21           C  
ATOM    835  C   TYR   102       9.243  33.344  -3.614  1.00 26.42           C  
ATOM    836  O   TYR   102      10.452  33.175  -3.617  1.00 27.13           O  
ATOM    837  CB  TYR   102       8.385  35.071  -2.044  1.00 27.35           C  
ATOM    838  CG  TYR   102       9.672  35.078  -1.243  1.00 26.25           C  
ATOM    839  CD1 TYR   102      10.720  35.926  -1.593  1.00 27.25           C  
ATOM    840  CD2 TYR   102       9.847  34.246  -0.138  1.00 25.54           C  
ATOM    841  CE1 TYR   102      11.924  35.953  -0.874  1.00 26.32           C  
ATOM    842  CE2 TYR   102      11.059  34.260   0.587  1.00 24.84           C  
ATOM    843  CZ  TYR   102      12.074  35.112   0.230  1.00 26.75           C  
ATOM    844  OH  TYR   102      13.270  35.165   0.933  1.00 25.91           O  
ATOM    845  N   ILE   103       8.378  32.346  -3.722  1.00 27.50           N  
ATOM    846  CA  ILE   103       8.813  30.981  -3.992  1.00 27.88           C  
ATOM    847  C   ILE   103       9.731  30.908  -5.220  1.00 27.65           C  
ATOM    848  O   ILE   103      10.751  30.201  -5.192  1.00 27.73           O  
ATOM    849  CB  ILE   103       7.617  30.032  -4.134  1.00 29.23           C  
ATOM    850  CG1 ILE   103       7.016  29.788  -2.747  1.00 30.88           C  
ATOM    851  CG2 ILE   103       8.035  28.692  -4.718  1.00 28.51           C  
ATOM    852  CD1 ILE   103       5.732  28.980  -2.795  1.00 33.46           C  
ATOM    853  N   SER   104       9.378  31.624  -6.282  1.00 27.79           N  
ATOM    854  CA  SER   104      10.196  31.587  -7.481  0.50 27.34           C  
ATOM    856  C   SER   104      11.574  32.157  -7.178  1.00 27.49           C  
ATOM    857  O   SER   104      12.578  31.651  -7.696  1.00 28.21           O  
ATOM    858  CB  SER   104       9.517  32.288  -8.666  0.50 27.70           C  
ATOM    860  OG  SER   104       9.297  33.653  -8.404  0.50 26.64           O  
ATOM    862  N   VAL   105      11.633  33.198  -6.338  1.00 27.35           N  
ATOM    863  CA  VAL   105      12.917  33.788  -5.913  1.00 28.27           C  
ATOM    864  C   VAL   105      13.727  32.746  -5.132  1.00 27.87           C  
ATOM    865  O   VAL   105      14.911  32.534  -5.409  1.00 28.29           O  
ATOM    866  CB  VAL   105      12.712  35.069  -5.063  1.00 28.99           C  
ATOM    867  CG1 VAL   105      14.037  35.535  -4.379  1.00 28.92           C  
ATOM    868  CG2 VAL   105      12.092  36.197  -5.908  1.00 29.40           C  
ATOM    869  N   LEU   106      13.102  32.109  -4.153  1.00 27.98           N  
ATOM    870  CA  LEU   106      13.769  31.016  -3.414  1.00 29.11           C  
ATOM    871  C   LEU   106      14.298  29.896  -4.309  1.00 29.49           C  
ATOM    872  O   LEU   106      15.409  29.399  -4.086  1.00 28.40           O  
ATOM    873  CB  LEU   106      12.844  30.436  -2.360  1.00 29.16           C  
ATOM    874  CG  LEU   106      12.443  31.332  -1.195  1.00 28.98           C  
ATOM    875  CD1 LEU   106      11.364  30.598  -0.405  1.00 27.21           C  
ATOM    876  CD2 LEU   106      13.592  31.655  -0.283  1.00 28.46           C  
ATOM    877  N   ASP   107      13.530  29.522  -5.329  1.00 30.00           N  
ATOM    878  CA  ASP   107      13.912  28.437  -6.238  1.00 31.31           C  
ATOM    879  C   ASP   107      15.183  28.744  -7.021  1.00 32.94           C  
ATOM    880  O   ASP   107      15.879  27.832  -7.457  1.00 32.77           O  
ATOM    881  CB  ASP   107      12.767  28.129  -7.204  1.00 30.81           C  
ATOM    882  CG  ASP   107      11.600  27.426  -6.519  1.00 31.73           C  
ATOM    883  OD1 ASP   107      11.808  26.861  -5.409  1.00 32.85           O  
ATOM    884  OD2 ASP   107      10.497  27.412  -7.108  1.00 30.11           O  
ATOM    885  N   ARG   108      15.483  30.027  -7.165  1.00 35.82           N  
ATOM    886  CA  ARG   108      16.714  30.471  -7.828  1.00 38.32           C  
ATOM    887  C   ARG   108      17.910  30.455  -6.873  1.00 40.36           C  
ATOM    888  O   ARG   108      19.070  30.499  -7.313  1.00 41.27           O  
ATOM    889  CB  ARG   108      16.532  31.880  -8.395  1.00 38.71           C  
ATOM    890  CG  ARG   108      15.484  32.018  -9.490  1.00 39.12           C  
ATOM    891  CD  ARG   108      15.947  31.500 -10.868  1.00 41.50           C  
ATOM    892  NE  ARG   108      17.379  31.658 -11.134  1.00 39.33           N  
ATOM    893  CZ  ARG   108      17.954  32.744 -11.656  1.00 40.78           C  
ATOM    894  NH1 ARG   108      17.234  33.825 -11.957  1.00 39.73           N  
ATOM    895  NH2 ARG   108      19.265  32.753 -11.862  1.00 39.54           N  
ATOM    896  N   ASN   109      17.609  30.383  -5.574  1.00 42.89           N  
ATOM    897  CA  ASN   109      18.561  30.416  -4.447  1.00 44.82           C  
ATOM    898  C   ASN   109      18.725  31.803  -3.828  1.00 45.47           C  
ATOM    899  O   ASN   109      19.574  32.596  -4.253  1.00 46.71           O  
ATOM    900  CB  ASN   109      19.923  29.793  -4.797  1.00 45.67           C  
ATOM    901  CG  ASN   109      20.027  28.329  -4.385  1.00 47.92           C  
ATOM    902  OD1 ASN   109      21.107  27.860  -4.009  1.00 50.81           O  
ATOM    903  ND2 ASN   109      18.912  27.600  -4.455  1.00 49.19           N  
END
