
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  134 ( 1009),  selected  134 , name 2nnn_A
# Molecule2: number of CA atoms  109 (  848),  selected  109 , name T0459.pdb
# PARAMETERS: 2nnn_A.T0459.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    Y     7_A      S       1           -
LGA    R     8_A      N       2           -
LGA    L     9_A      A       3           -
LGA    D    10_A      M       4           -
LGA    D    11_A      L       5           -
LGA    Q    12_A      R       6           -
LGA    I    13_A      Y       7           -
LGA    G    14_A      G       8           -
LGA    F    15_A      D       9           -
LGA    I    16_A      T      10           -
LGA    L    17_A      E      11           -
LGA    R    18_A      I      12           -
LGA    Q    19_A      C      13           -
LGA    A    20_A      I      14           -
LGA    N    21_A      D      15           -
LGA    Q    22_A      P      16           -
LGA    R    23_A      S      17           -
LGA    Y    24_A      E      18           -
LGA    A    25_A      S      19           -
LGA    A    26_A      V      20           -
LGA    L    27_A      -       -           -
LGA    F    28_A      -       -           -
LGA    A    29_A      -       -           -
LGA    N    30_A      -       -           -
LGA    G    31_A      -       -           -
LGA    I    32_A      -       -           -
LGA    G    33_A      -       -           -
LGA    N    34_A      L      21          4.990
LGA    G    35_A      H      22          4.926
LGA    -       -      L      23           -
LGA    L    36_A      L      24          1.598
LGA    T    37_A      G      25          3.226
LGA    P    38_A      K      26          6.763
LGA    -       -      K      27           -
LGA    T    39_A      Y      28          0.913
LGA    Q    40_A      T      29          0.827
LGA    W    41_A      M      30          1.207
LGA    A    42_A      L      31          1.181
LGA    A    43_A      I      32          1.249
LGA    L    44_A      I      33          1.092
LGA    V    45_A      S      34          1.062
LGA    R    46_A      V      35          0.980
LGA    L    47_A      L      36          0.960
LGA    G    48_A      G      37          0.472
LGA    E    49_A      N      38          0.751
LGA    T    50_A      G      39          3.448
LGA    -       -      S      40           -
LGA    G    51_A      T      41          3.591
LGA    P    52_A      R      42          1.307
LGA    C    53_A      Q      43          1.370
LGA    P    54_A      N      44          1.353
LGA    Q    55_A      F      45          1.776
LGA    N    56_A      N      46          3.095
LGA    Q    57_A      D      47          2.858
LGA    L    58_A      I      48          1.278
LGA    G    59_A      R      49          1.139
LGA    R    60_A      S      50          2.040
LGA    L    61_A      S      51          2.014
LGA    T    62_A      I      52          1.323
LGA    A    63_A      P      53          2.784
LGA    -       -      G      54           -
LGA    X    64_A      I      55          2.310
LGA    D    65_A      S      56          2.225
LGA    A    66_A      S      57          1.743
LGA    A    67_A      T      58          1.249
LGA    T    68_A      I      59          1.913
LGA    I    69_A      L      60          1.060
LGA    K    70_A      S      61          0.443
LGA    G    71_A      R      62          0.985
LGA    V    72_A      R      63          1.657
LGA    V    73_A      I      64          0.885
LGA    E    74_A      K      65          1.327
LGA    R    75_A      D      66          1.993
LGA    L    76_A      L      67          1.702
LGA    D    77_A      I      68          1.757
LGA    K    78_A      D      69          2.462
LGA    R    79_A      S      70          1.988
LGA    G    80_A      G      71          1.158
LGA    L    81_A      L      72          0.803
LGA    I    82_A      V      73          0.299
LGA    Q    83_A      E      74          1.010
LGA    R    84_A      R      75          1.126
LGA    S    85_A      R      76          0.916
LGA    A    86_A      S      77          2.023
LGA    D    87_A      G      78          3.053
LGA    P    88_A      Q      79          3.945
LGA    D    89_A      -       -           -
LGA    D    90_A      -       -           -
LGA    G    91_A      -       -           -
LGA    R    92_A      -       -           -
LGA    R    93_A      I      80          3.799
LGA    L    94_A      T      81          1.874
LGA    L    95_A      T      82          1.068
LGA    V    96_A      Y      83          0.883
LGA    S    97_A      A      84          0.821
LGA    L    98_A      L      85          0.890
LGA    S    99_A      T      86          0.675
LGA    P   100_A      E      87          0.737
LGA    A   101_A      K      88          0.520
LGA    G   102_A      G      89          0.461
LGA    R   103_A      M      90          0.541
LGA    A   104_A      N      91          0.689
LGA    E   105_A      V      92          0.452
LGA    L   106_A      R      93          0.237
LGA    E   107_A      N      94          0.369
LGA    A   108_A      S      95          1.126
LGA    G   109_A      L      96          1.191
LGA    L   110_A      M      97          1.406
LGA    A   111_A      P      98          1.604
LGA    A   112_A      L      99          1.570
LGA    A   113_A      L     100          1.615
LGA    R   114_A      Q     101          1.789
LGA    E   115_A      Y     102          2.195
LGA    I   116_A      I     103          2.405
LGA    N   117_A      S     104          2.447
LGA    R   118_A      V     105          2.237
LGA    Q   119_A      L     106          2.549
LGA    A   120_A      D     107          2.990
LGA    L   121_A      R     108          2.738
LGA    A   122_A      N     109          2.595
LGA    P   123_A      -       -           -
LGA    L   124_A      -       -           -
LGA    S   125_A      -       -           -
LGA    L   126_A      -       -           -
LGA    Q   127_A      -       -           -
LGA    E   128_A      -       -           -
LGA    Q   129_A      -       -           -
LGA    E   130_A      -       -           -
LGA    T   131_A      -       -           -
LGA    L   132_A      -       -           -
LGA    R   133_A      -       -           -
LGA    G   134_A      -       -           -
LGA    L   135_A      -       -           -
LGA    L   136_A      -       -           -
LGA    A   137_A      -       -           -
LGA    R   138_A      -       -           -
LGA    L   139_A      -       -           -
LGA    I   140_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  134  109    5.0     85    2.06    12.94     69.729     3.931

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.095815 * X  +   0.941890 * Y  +  -0.321966 * Z  +  45.099606
  Y_new =  -0.569364 * X  +   0.317176 * Y  +   0.758435 * Z  + -34.396202
  Z_new =   0.816483 * X  +   0.110646 * Y  +   0.566669 * Z  + -23.001740 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.192831   -2.948761  [ DEG:    11.0484   -168.9516 ]
  Theta =  -0.955292   -2.186300  [ DEG:   -54.7342   -125.2658 ]
  Phi   =  -1.404073    1.737519  [ DEG:   -80.4475     99.5525 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2nnn_A                                        
REMARK     2: T0459.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2nnn_A.T0459.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  134  109   5.0   85   2.06   12.94  69.729
REMARK  ---------------------------------------------------------- 
MOLECULE 2nnn_A
HEADER    TRANSCRIPTION                           24-OCT-06   2NNN              
TITLE     CRYSTAL STRUCTURE OF PROBABLE TRANSCRIPTIONAL REGULATOR               
TITLE    2 FROM PSEUDOMONAS AERUGINOSA                                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROBABLE TRANSCRIPTIONAL REGULATOR;                        
COMPND   3 CHAIN: A, B, C, D, E, F, G, H, I, J;                                 
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS AERUGINOSA;                         
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: PA1603;                                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3) DERIVATIVES                      
KEYWDS    PSEUDOMONAS AERUGINOSA, PROBABLE TRANSCRIPTIONAL REGULATOR,           
KEYWDS   2 STRUCTURAL GENOMICS, PSI-2, PROTEIN STRUCTURE INITIATIVE,            
KEYWDS   3 MIDWEST CENTER FOR STRUCTURAL GENOMICS, MCSG                         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    C.CHANG,E.EVDOKIMOVA,S.ALTAMENTOVA,A.SAVCHENKO,A.M.EDWARDS,           
AUTHOR   2 A.JOACHIMIAK,MIDWEST CENTER FOR STRUCTURAL GENOMICS (MCSG)           
REVDAT   2   14-AUG-07 2NNN    1       AUTHOR JRNL                              
REVDAT   1   21-NOV-06 2NNN    0                                                
JRNL        AUTH   C.CHANG,E.EVDOKIMOVA,S.ALTAMENTOVA,A.SAVCHENKO,              
JRNL        AUTH 2 A.M.EDWARDS,A.JOACHIMIAK                                     
JRNL        TITL   CRYSTAL STRUCTURE OF PROBABLE TRANSCRIPTIONAL                
JRNL        TITL 2 REGULATOR FROM PSEUDOMONAS AERUGINOSA                        
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.40 ANGSTROMS.                                          
DBREF  2NNN A    1   140  UNP    Q9I3B8   Q9I3B8_PSEAE     1    140             
DBREF  2NNN B    1   140  UNP    Q9I3B8   Q9I3B8_PSEAE     1    140             
DBREF  2NNN C    1   140  UNP    Q9I3B8   Q9I3B8_PSEAE     1    140             
DBREF  2NNN D    1   140  UNP    Q9I3B8   Q9I3B8_PSEAE     1    140             
DBREF  2NNN E    1   140  UNP    Q9I3B8   Q9I3B8_PSEAE     1    140             
DBREF  2NNN F    1   140  UNP    Q9I3B8   Q9I3B8_PSEAE     1    140             
DBREF  2NNN G    1   140  UNP    Q9I3B8   Q9I3B8_PSEAE     1    140             
DBREF  2NNN H    1   140  UNP    Q9I3B8   Q9I3B8_PSEAE     1    140             
DBREF  2NNN I    1   140  UNP    Q9I3B8   Q9I3B8_PSEAE     1    140             
DBREF  2NNN J    1   140  UNP    Q9I3B8   Q9I3B8_PSEAE     1    140             
SEQRES   1 A  140  MSE SER ARG THR THR PRO TYR ARG LEU ASP ASP GLN ILE          
SEQRES   2 A  140  GLY PHE ILE LEU ARG GLN ALA ASN GLN ARG TYR ALA ALA          
SEQRES   3 A  140  LEU PHE ALA ASN GLY ILE GLY ASN GLY LEU THR PRO THR          
SEQRES   4 A  140  GLN TRP ALA ALA LEU VAL ARG LEU GLY GLU THR GLY PRO          
SEQRES   5 A  140  CYS PRO GLN ASN GLN LEU GLY ARG LEU THR ALA MSE ASP          
SEQRES   6 A  140  ALA ALA THR ILE LYS GLY VAL VAL GLU ARG LEU ASP LYS          
SEQRES   7 A  140  ARG GLY LEU ILE GLN ARG SER ALA ASP PRO ASP ASP GLY          
SEQRES   8 A  140  ARG ARG LEU LEU VAL SER LEU SER PRO ALA GLY ARG ALA          
SEQRES   9 A  140  GLU LEU GLU ALA GLY LEU ALA ALA ALA ARG GLU ILE ASN          
SEQRES  10 A  140  ARG GLN ALA LEU ALA PRO LEU SER LEU GLN GLU GLN GLU          
SEQRES  11 A  140  THR LEU ARG GLY LEU LEU ALA ARG LEU ILE                      
SEQRES   1 B  140  MSE SER ARG THR THR PRO TYR ARG LEU ASP ASP GLN ILE          
SEQRES   2 B  140  GLY PHE ILE LEU ARG GLN ALA ASN GLN ARG TYR ALA ALA          
SEQRES   3 B  140  LEU PHE ALA ASN GLY ILE GLY ASN GLY LEU THR PRO THR          
SEQRES   4 B  140  GLN TRP ALA ALA LEU VAL ARG LEU GLY GLU THR GLY PRO          
SEQRES   5 B  140  CYS PRO GLN ASN GLN LEU GLY ARG LEU THR ALA MSE ASP          
SEQRES   6 B  140  ALA ALA THR ILE LYS GLY VAL VAL GLU ARG LEU ASP LYS          
SEQRES   7 B  140  ARG GLY LEU ILE GLN ARG SER ALA ASP PRO ASP ASP GLY          
SEQRES   8 B  140  ARG ARG LEU LEU VAL SER LEU SER PRO ALA GLY ARG ALA          
SEQRES   9 B  140  GLU LEU GLU ALA GLY LEU ALA ALA ALA ARG GLU ILE ASN          
SEQRES  10 B  140  ARG GLN ALA LEU ALA PRO LEU SER LEU GLN GLU GLN GLU          
SEQRES  11 B  140  THR LEU ARG GLY LEU LEU ALA ARG LEU ILE                      
SEQRES   1 C  140  MSE SER ARG THR THR PRO TYR ARG LEU ASP ASP GLN ILE          
SEQRES   2 C  140  GLY PHE ILE LEU ARG GLN ALA ASN GLN ARG TYR ALA ALA          
SEQRES   3 C  140  LEU PHE ALA ASN GLY ILE GLY ASN GLY LEU THR PRO THR          
SEQRES   4 C  140  GLN TRP ALA ALA LEU VAL ARG LEU GLY GLU THR GLY PRO          
SEQRES   5 C  140  CYS PRO GLN ASN GLN LEU GLY ARG LEU THR ALA MSE ASP          
SEQRES   6 C  140  ALA ALA THR ILE LYS GLY VAL VAL GLU ARG LEU ASP LYS          
SEQRES   7 C  140  ARG GLY LEU ILE GLN ARG SER ALA ASP PRO ASP ASP GLY          
SEQRES   8 C  140  ARG ARG LEU LEU VAL SER LEU SER PRO ALA GLY ARG ALA          
SEQRES   9 C  140  GLU LEU GLU ALA GLY LEU ALA ALA ALA ARG GLU ILE ASN          
SEQRES  10 C  140  ARG GLN ALA LEU ALA PRO LEU SER LEU GLN GLU GLN GLU          
SEQRES  11 C  140  THR LEU ARG GLY LEU LEU ALA ARG LEU ILE                      
SEQRES   1 D  140  MSE SER ARG THR THR PRO TYR ARG LEU ASP ASP GLN ILE          
SEQRES   2 D  140  GLY PHE ILE LEU ARG GLN ALA ASN GLN ARG TYR ALA ALA          
SEQRES   3 D  140  LEU PHE ALA ASN GLY ILE GLY ASN GLY LEU THR PRO THR          
SEQRES   4 D  140  GLN TRP ALA ALA LEU VAL ARG LEU GLY GLU THR GLY PRO          
SEQRES   5 D  140  CYS PRO GLN ASN GLN LEU GLY ARG LEU THR ALA MSE ASP          
SEQRES   6 D  140  ALA ALA THR ILE LYS GLY VAL VAL GLU ARG LEU ASP LYS          
SEQRES   7 D  140  ARG GLY LEU ILE GLN ARG SER ALA ASP PRO ASP ASP GLY          
SEQRES   8 D  140  ARG ARG LEU LEU VAL SER LEU SER PRO ALA GLY ARG ALA          
SEQRES   9 D  140  GLU LEU GLU ALA GLY LEU ALA ALA ALA ARG GLU ILE ASN          
SEQRES  10 D  140  ARG GLN ALA LEU ALA PRO LEU SER LEU GLN GLU GLN GLU          
SEQRES  11 D  140  THR LEU ARG GLY LEU LEU ALA ARG LEU ILE                      
SEQRES   1 E  140  MSE SER ARG THR THR PRO TYR ARG LEU ASP ASP GLN ILE          
SEQRES   2 E  140  GLY PHE ILE LEU ARG GLN ALA ASN GLN ARG TYR ALA ALA          
SEQRES   3 E  140  LEU PHE ALA ASN GLY ILE GLY ASN GLY LEU THR PRO THR          
SEQRES   4 E  140  GLN TRP ALA ALA LEU VAL ARG LEU GLY GLU THR GLY PRO          
SEQRES   5 E  140  CYS PRO GLN ASN GLN LEU GLY ARG LEU THR ALA MSE ASP          
SEQRES   6 E  140  ALA ALA THR ILE LYS GLY VAL VAL GLU ARG LEU ASP LYS          
SEQRES   7 E  140  ARG GLY LEU ILE GLN ARG SER ALA ASP PRO ASP ASP GLY          
SEQRES   8 E  140  ARG ARG LEU LEU VAL SER LEU SER PRO ALA GLY ARG ALA          
SEQRES   9 E  140  GLU LEU GLU ALA GLY LEU ALA ALA ALA ARG GLU ILE ASN          
SEQRES  10 E  140  ARG GLN ALA LEU ALA PRO LEU SER LEU GLN GLU GLN GLU          
SEQRES  11 E  140  THR LEU ARG GLY LEU LEU ALA ARG LEU ILE                      
SEQRES   1 F  140  MSE SER ARG THR THR PRO TYR ARG LEU ASP ASP GLN ILE          
SEQRES   2 F  140  GLY PHE ILE LEU ARG GLN ALA ASN GLN ARG TYR ALA ALA          
SEQRES   3 F  140  LEU PHE ALA ASN GLY ILE GLY ASN GLY LEU THR PRO THR          
SEQRES   4 F  140  GLN TRP ALA ALA LEU VAL ARG LEU GLY GLU THR GLY PRO          
SEQRES   5 F  140  CYS PRO GLN ASN GLN LEU GLY ARG LEU THR ALA MSE ASP          
SEQRES   6 F  140  ALA ALA THR ILE LYS GLY VAL VAL GLU ARG LEU ASP LYS          
SEQRES   7 F  140  ARG GLY LEU ILE GLN ARG SER ALA ASP PRO ASP ASP GLY          
SEQRES   8 F  140  ARG ARG LEU LEU VAL SER LEU SER PRO ALA GLY ARG ALA          
SEQRES   9 F  140  GLU LEU GLU ALA GLY LEU ALA ALA ALA ARG GLU ILE ASN          
SEQRES  10 F  140  ARG GLN ALA LEU ALA PRO LEU SER LEU GLN GLU GLN GLU          
SEQRES  11 F  140  THR LEU ARG GLY LEU LEU ALA ARG LEU ILE                      
SEQRES   1 G  140  MSE SER ARG THR THR PRO TYR ARG LEU ASP ASP GLN ILE          
SEQRES   2 G  140  GLY PHE ILE LEU ARG GLN ALA ASN GLN ARG TYR ALA ALA          
SEQRES   3 G  140  LEU PHE ALA ASN GLY ILE GLY ASN GLY LEU THR PRO THR          
SEQRES   4 G  140  GLN TRP ALA ALA LEU VAL ARG LEU GLY GLU THR GLY PRO          
SEQRES   5 G  140  CYS PRO GLN ASN GLN LEU GLY ARG LEU THR ALA MSE ASP          
SEQRES   6 G  140  ALA ALA THR ILE LYS GLY VAL VAL GLU ARG LEU ASP LYS          
SEQRES   7 G  140  ARG GLY LEU ILE GLN ARG SER ALA ASP PRO ASP ASP GLY          
SEQRES   8 G  140  ARG ARG LEU LEU VAL SER LEU SER PRO ALA GLY ARG ALA          
SEQRES   9 G  140  GLU LEU GLU ALA GLY LEU ALA ALA ALA ARG GLU ILE ASN          
SEQRES  10 G  140  ARG GLN ALA LEU ALA PRO LEU SER LEU GLN GLU GLN GLU          
SEQRES  11 G  140  THR LEU ARG GLY LEU LEU ALA ARG LEU ILE                      
SEQRES   1 H  140  MSE SER ARG THR THR PRO TYR ARG LEU ASP ASP GLN ILE          
SEQRES   2 H  140  GLY PHE ILE LEU ARG GLN ALA ASN GLN ARG TYR ALA ALA          
SEQRES   3 H  140  LEU PHE ALA ASN GLY ILE GLY ASN GLY LEU THR PRO THR          
SEQRES   4 H  140  GLN TRP ALA ALA LEU VAL ARG LEU GLY GLU THR GLY PRO          
SEQRES   5 H  140  CYS PRO GLN ASN GLN LEU GLY ARG LEU THR ALA MSE ASP          
SEQRES   6 H  140  ALA ALA THR ILE LYS GLY VAL VAL GLU ARG LEU ASP LYS          
SEQRES   7 H  140  ARG GLY LEU ILE GLN ARG SER ALA ASP PRO ASP ASP GLY          
SEQRES   8 H  140  ARG ARG LEU LEU VAL SER LEU SER PRO ALA GLY ARG ALA          
SEQRES   9 H  140  GLU LEU GLU ALA GLY LEU ALA ALA ALA ARG GLU ILE ASN          
SEQRES  10 H  140  ARG GLN ALA LEU ALA PRO LEU SER LEU GLN GLU GLN GLU          
SEQRES  11 H  140  THR LEU ARG GLY LEU LEU ALA ARG LEU ILE                      
SEQRES   1 I  140  MSE SER ARG THR THR PRO TYR ARG LEU ASP ASP GLN ILE          
SEQRES   2 I  140  GLY PHE ILE LEU ARG GLN ALA ASN GLN ARG TYR ALA ALA          
SEQRES   3 I  140  LEU PHE ALA ASN GLY ILE GLY ASN GLY LEU THR PRO THR          
SEQRES   4 I  140  GLN TRP ALA ALA LEU VAL ARG LEU GLY GLU THR GLY PRO          
SEQRES   5 I  140  CYS PRO GLN ASN GLN LEU GLY ARG LEU THR ALA MSE ASP          
SEQRES   6 I  140  ALA ALA THR ILE LYS GLY VAL VAL GLU ARG LEU ASP LYS          
SEQRES   7 I  140  ARG GLY LEU ILE GLN ARG SER ALA ASP PRO ASP ASP GLY          
SEQRES   8 I  140  ARG ARG LEU LEU VAL SER LEU SER PRO ALA GLY ARG ALA          
SEQRES   9 I  140  GLU LEU GLU ALA GLY LEU ALA ALA ALA ARG GLU ILE ASN          
SEQRES  10 I  140  ARG GLN ALA LEU ALA PRO LEU SER LEU GLN GLU GLN GLU          
SEQRES  11 I  140  THR LEU ARG GLY LEU LEU ALA ARG LEU ILE                      
SEQRES   1 J  140  MSE SER ARG THR THR PRO TYR ARG LEU ASP ASP GLN ILE          
SEQRES   2 J  140  GLY PHE ILE LEU ARG GLN ALA ASN GLN ARG TYR ALA ALA          
SEQRES   3 J  140  LEU PHE ALA ASN GLY ILE GLY ASN GLY LEU THR PRO THR          
SEQRES   4 J  140  GLN TRP ALA ALA LEU VAL ARG LEU GLY GLU THR GLY PRO          
SEQRES   5 J  140  CYS PRO GLN ASN GLN LEU GLY ARG LEU THR ALA MSE ASP          
SEQRES   6 J  140  ALA ALA THR ILE LYS GLY VAL VAL GLU ARG LEU ASP LYS          
SEQRES   7 J  140  ARG GLY LEU ILE GLN ARG SER ALA ASP PRO ASP ASP GLY          
SEQRES   8 J  140  ARG ARG LEU LEU VAL SER LEU SER PRO ALA GLY ARG ALA          
SEQRES   9 J  140  GLU LEU GLU ALA GLY LEU ALA ALA ALA ARG GLU ILE ASN          
SEQRES  10 J  140  ARG GLN ALA LEU ALA PRO LEU SER LEU GLN GLU GLN GLU          
SEQRES  11 J  140  THR LEU ARG GLY LEU LEU ALA ARG LEU ILE                      
HET    MSE  A  64       8                                                       
HET    MSE  B  64       8                                                       
HET    MSE  C  64       8                                                       
HET    MSE  D  64       8                                                       
HET    MSE  E  64       8                                                       
HET    MSE  F  64       8                                                       
HET    MSE  G  64       8                                                       
HET    MSE  H  64       8                                                       
HET    MSE  I  64       8                                                       
HET    MSE  J  64       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    10(C5 H11 N O2 SE)                                           
FORMUL  11  HOH   *482(H2 O)                                                    
CRYST1   89.373   89.373  217.238  90.00  90.00 120.00 P 31         30          
ATOM      1  N   TYR A   7      28.971   4.317 -10.821  1.00 50.61           N  
ATOM      2  CA  TYR A   7      27.499   4.539 -10.626  1.00 50.79           C  
ATOM      3  C   TYR A   7      27.135   4.756  -9.151  1.00 50.60           C  
ATOM      4  O   TYR A   7      26.863   3.799  -8.410  1.00 50.53           O  
ATOM      5  CB  TYR A   7      26.666   3.385 -11.234  1.00 50.62           C  
ATOM      6  N   ARG A   8      27.144   6.024  -8.747  1.00 50.24           N  
ATOM      7  CA  ARG A   8      26.694   6.439  -7.421  1.00 49.93           C  
ATOM      8  C   ARG A   8      25.343   7.139  -7.567  1.00 49.60           C  
ATOM      9  O   ARG A   8      25.111   7.881  -8.539  1.00 49.53           O  
ATOM     10  CB  ARG A   8      27.723   7.366  -6.765  1.00 49.96           C  
ATOM     11  N   LEU A   9      24.460   6.901  -6.600  1.00 48.70           N  
ATOM     12  CA  LEU A   9      23.091   7.405  -6.667  1.00 47.96           C  
ATOM     13  C   LEU A   9      23.005   8.935  -6.690  1.00 47.39           C  
ATOM     14  O   LEU A   9      22.197   9.496  -7.445  1.00 47.11           O  
ATOM     15  CB  LEU A   9      22.235   6.808  -5.534  1.00 47.82           C  
ATOM     16  CG  LEU A   9      20.731   7.114  -5.447  1.00 48.02           C  
ATOM     17  CD1 LEU A   9      20.017   6.904  -6.773  1.00 46.05           C  
ATOM     18  CD2 LEU A   9      20.099   6.264  -4.348  1.00 47.60           C  
ATOM     19  N   ASP A  10      23.862   9.591  -5.899  1.00 46.58           N  
ATOM     20  CA  ASP A  10      23.807  11.053  -5.689  1.00 46.00           C  
ATOM     21  C   ASP A  10      24.260  11.892  -6.885  1.00 45.43           C  
ATOM     22  O   ASP A  10      24.116  13.112  -6.883  1.00 45.29           O  
ATOM     23  CB  ASP A  10      24.612  11.454  -4.449  1.00 46.20           C  
ATOM     24  CG  ASP A  10      24.261  10.622  -3.233  1.00 46.58           C  
ATOM     25  OD1 ASP A  10      23.401  11.066  -2.432  1.00 46.95           O  
ATOM     26  OD2 ASP A  10      24.832   9.516  -3.099  1.00 46.11           O  
ATOM     27  N   ASP A  11      24.824  11.231  -7.889  1.00 45.12           N  
ATOM     28  CA  ASP A  11      25.140  11.859  -9.172  1.00 44.72           C  
ATOM     29  C   ASP A  11      23.997  11.722 -10.175  1.00 43.86           C  
ATOM     30  O   ASP A  11      23.964  12.422 -11.189  1.00 44.40           O  
ATOM     31  CB  ASP A  11      26.405  11.239  -9.763  1.00 44.89           C  
ATOM     32  CG  ASP A  11      27.612  11.441  -8.872  1.00 46.19           C  
ATOM     33  OD1 ASP A  11      27.738  12.533  -8.265  1.00 46.69           O  
ATOM     34  OD2 ASP A  11      28.430  10.502  -8.777  1.00 48.32           O  
ATOM     35  N   GLN A  12      23.065  10.817  -9.903  1.00 42.46           N  
ATOM     36  CA  GLN A  12      21.973  10.578 -10.837  1.00 40.76           C  
ATOM     37  C   GLN A  12      21.041  11.763 -10.800  1.00 39.39           C  
ATOM     38  O   GLN A  12      20.547  12.134  -9.741  1.00 39.54           O  
ATOM     39  CB  GLN A  12      21.233   9.278 -10.496  1.00 40.87           C  
ATOM     40  CG  GLN A  12      22.128   8.049 -10.487  1.00 41.38           C  
ATOM     41  CD  GLN A  12      23.111   8.034 -11.650  1.00 43.18           C  
ATOM     42  OE1 GLN A  12      22.711   8.013 -12.825  1.00 44.82           O  
ATOM     43  NE2 GLN A  12      24.404   8.061 -11.331  1.00 42.23           N  
ATOM     44  N   ILE A  13      20.818  12.365 -11.961  1.00 38.07           N  
ATOM     45  CA  ILE A  13      19.985  13.552 -12.073  1.00 36.67           C  
ATOM     46  C   ILE A  13      18.526  13.322 -11.674  1.00 36.03           C  
ATOM     47  O   ILE A  13      17.858  14.242 -11.224  1.00 36.79           O  
ATOM     48  CB  ILE A  13      20.118  14.216 -13.464  1.00 36.75           C  
ATOM     49  CG1 ILE A  13      19.585  15.658 -13.440  1.00 35.64           C  
ATOM     50  CG2 ILE A  13      19.442  13.372 -14.542  1.00 37.42           C  
ATOM     51  CD1 ILE A  13      20.494  16.633 -12.719  1.00 33.67           C  
ATOM     52  N   GLY A  14      18.038  12.099 -11.793  1.00 35.07           N  
ATOM     53  CA  GLY A  14      16.688  11.775 -11.317  1.00 34.82           C  
ATOM     54  C   GLY A  14      16.512  11.904  -9.811  1.00 34.33           C  
ATOM     55  O   GLY A  14      15.537  12.473  -9.345  1.00 34.57           O  
ATOM     56  N   PHE A  15      17.467  11.371  -9.057  1.00 34.26           N  
ATOM     57  CA  PHE A  15      17.496  11.474  -7.592  1.00 33.82           C  
ATOM     58  C   PHE A  15      17.556  12.946  -7.163  1.00 33.43           C  
ATOM     59  O   PHE A  15      16.814  13.379  -6.278  1.00 33.32           O  
ATOM     60  CB  PHE A  15      18.710  10.689  -7.069  1.00 33.65           C  
ATOM     61  CG  PHE A  15      18.822  10.631  -5.568  1.00 35.01           C  
ATOM     62  CD1 PHE A  15      17.696  10.409  -4.760  1.00 34.77           C  
ATOM     63  CD2 PHE A  15      20.067  10.755  -4.954  1.00 35.97           C  
ATOM     64  CE1 PHE A  15      17.803  10.358  -3.387  1.00 33.62           C  
ATOM     65  CE2 PHE A  15      20.183  10.697  -3.563  1.00 36.15           C  
ATOM     66  CZ  PHE A  15      19.052  10.491  -2.781  1.00 34.76           C  
ATOM     67  N   ILE A  16      18.430  13.708  -7.821  1.00 32.74           N  
ATOM     68  CA  ILE A  16      18.600  15.137  -7.577  1.00 32.11           C  
ATOM     69  C   ILE A  16      17.305  15.901  -7.869  1.00 31.67           C  
ATOM     70  O   ILE A  16      16.852  16.676  -7.049  1.00 31.21           O  
ATOM     71  CB  ILE A  16      19.779  15.695  -8.427  1.00 32.48           C  
ATOM     72  CG1 ILE A  16      21.093  14.959  -8.071  1.00 32.83           C  
ATOM     73  CG2 ILE A  16      19.914  17.217  -8.262  1.00 31.30           C  
ATOM     74  CD1 ILE A  16      22.315  15.432  -8.859  1.00 32.48           C  
ATOM     75  N   LEU A  17      16.700  15.653  -9.034  1.00 31.59           N  
ATOM     76  CA  LEU A  17      15.413  16.276  -9.385  1.00 30.90           C  
ATOM     77  C   LEU A  17      14.331  16.001  -8.365  1.00 30.40           C  
ATOM     78  O   LEU A  17      13.607  16.906  -7.996  1.00 30.72           O  
ATOM     79  CB  LEU A  17      14.934  15.842 -10.771  1.00 30.67           C  
ATOM     80  CG  LEU A  17      15.670  16.443 -11.955  1.00 29.72           C  
ATOM     81  CD1 LEU A  17      15.165  15.783 -13.249  1.00 28.82           C  
ATOM     82  CD2 LEU A  17      15.494  17.949 -11.960  1.00 28.02           C  
ATOM     83  N   ARG A  18      14.241  14.761  -7.899  1.00 30.65           N  
ATOM     84  CA  ARG A  18      13.250  14.380  -6.887  1.00 30.78           C  
ATOM     85  C   ARG A  18      13.451  15.147  -5.584  1.00 30.85           C  
ATOM     86  O   ARG A  18      12.495  15.648  -4.993  1.00 31.29           O  
ATOM     87  CB  ARG A  18      13.279  12.867  -6.628  1.00 30.67           C  
ATOM     88  CG  ARG A  18      12.350  12.461  -5.491  1.00 31.22           C  
ATOM     89  CD  ARG A  18      11.974  10.985  -5.497  1.00 32.40           C  
ATOM     90  NE  ARG A  18      13.060  10.039  -5.183  1.00 34.24           N  
ATOM     91  CZ  ARG A  18      13.625   9.858  -3.984  1.00 33.96           C  
ATOM     92  NH1 ARG A  18      13.269  10.598  -2.944  1.00 33.04           N  
ATOM     93  NH2 ARG A  18      14.573   8.933  -3.834  1.00 32.47           N  
ATOM     94  N   GLN A  19      14.699  15.242  -5.142  1.00 30.55           N  
ATOM     95  CA  GLN A  19      15.022  15.951  -3.897  1.00 30.46           C  
ATOM     96  C   GLN A  19      14.713  17.438  -3.944  1.00 29.87           C  
ATOM     97  O   GLN A  19      14.160  17.975  -2.993  1.00 29.29           O  
ATOM     98  CB  GLN A  19      16.489  15.760  -3.557  1.00 30.53           C  
ATOM     99  CG  GLN A  19      16.817  14.365  -3.103  1.00 32.26           C  
ATOM    100  CD  GLN A  19      18.280  14.196  -2.951  1.00 34.62           C  
ATOM    101  OE1 GLN A  19      19.004  13.965  -3.918  1.00 39.45           O  
ATOM    102  NE2 GLN A  19      18.742  14.335  -1.749  1.00 33.32           N  
ATOM    103  N   ALA A  20      15.101  18.096  -5.043  1.00 30.08           N  
ATOM    104  CA  ALA A  20      14.749  19.500  -5.308  1.00 29.67           C  
ATOM    105  C   ALA A  20      13.223  19.675  -5.315  1.00 30.16           C  
ATOM    106  O   ALA A  20      12.687  20.643  -4.761  1.00 30.48           O  
ATOM    107  CB  ALA A  20      15.345  19.945  -6.626  1.00 29.63           C  
ATOM    108  N   ASN A  21      12.536  18.720  -5.934  1.00 29.99           N  
ATOM    109  CA  ASN A  21      11.083  18.682  -5.940  1.00 30.24           C  
ATOM    110  C   ASN A  21      10.504  18.556  -4.530  1.00 29.62           C  
ATOM    111  O   ASN A  21       9.605  19.312  -4.171  1.00 30.38           O  
ATOM    112  CB  ASN A  21      10.593  17.551  -6.845  1.00 29.60           C  
ATOM    113  CG  ASN A  21       9.407  17.948  -7.707  1.00 32.89           C  
ATOM    114  OD1 ASN A  21       8.363  17.299  -7.659  1.00 41.02           O  
ATOM    115  ND2 ASN A  21       9.554  18.981  -8.510  1.00 28.68           N  
ATOM    116  N   GLN A  22      11.020  17.613  -3.738  1.00 29.50           N  
ATOM    117  CA  GLN A  22      10.620  17.435  -2.327  1.00 29.46           C  
ATOM    118  C   GLN A  22      10.858  18.668  -1.457  1.00 29.34           C  
ATOM    119  O   GLN A  22      10.011  19.005  -0.625  1.00 30.35           O  
ATOM    120  CB  GLN A  22      11.323  16.229  -1.686  1.00 29.35           C  
ATOM    121  CG  GLN A  22      10.664  14.883  -1.976  1.00 29.46           C  
ATOM    122  CD  GLN A  22      11.441  13.709  -1.409  1.00 29.70           C  
ATOM    123  OE1 GLN A  22      12.095  13.802  -0.346  1.00 33.19           O  
ATOM    124  NE2 GLN A  22      11.386  12.600  -2.110  1.00 28.63           N  
ATOM    125  N   ARG A  23      11.997  19.334  -1.636  1.00 28.96           N  
ATOM    126  CA  ARG A  23      12.286  20.578  -0.896  1.00 28.91           C  
ATOM    127  C   ARG A  23      11.279  21.662  -1.268  1.00 28.84           C  
ATOM    128  O   ARG A  23      10.750  22.361  -0.399  1.00 28.81           O  
ATOM    129  CB  ARG A  23      13.713  21.080  -1.161  1.00 28.36           C  
ATOM    130  CG  ARG A  23      13.958  22.508  -0.655  1.00 27.84           C  
ATOM    131  CD  ARG A  23      15.430  22.834  -0.606  1.00 26.40           C  
ATOM    132  NE  ARG A  23      15.702  24.240  -0.319  1.00 26.49           N  
ATOM    133  CZ  ARG A  23      15.731  25.228  -1.212  1.00 27.72           C  
ATOM    134  NH1 ARG A  23      15.454  25.013  -2.497  1.00 26.36           N  
ATOM    135  NH2 ARG A  23      16.007  26.464  -0.799  1.00 29.07           N  
ATOM    136  N   TYR A  24      11.005  21.786  -2.564  1.00 29.01           N  
ATOM    137  CA  TYR A  24      10.050  22.779  -3.031  1.00 29.00           C  
ATOM    138  C   TYR A  24       8.687  22.520  -2.404  1.00 28.92           C  
ATOM    139  O   TYR A  24       8.047  23.442  -1.887  1.00 29.52           O  
ATOM    140  CB  TYR A  24       9.966  22.840  -4.573  1.00 29.05           C  
ATOM    141  CG  TYR A  24       9.042  23.948  -4.991  1.00 30.16           C  
ATOM    142  CD1 TYR A  24       9.517  25.258  -5.122  1.00 30.06           C  
ATOM    143  CD2 TYR A  24       7.670  23.711  -5.185  1.00 29.14           C  
ATOM    144  CE1 TYR A  24       8.668  26.290  -5.464  1.00 28.60           C  
ATOM    145  CE2 TYR A  24       6.818  24.741  -5.526  1.00 29.86           C  
ATOM    146  CZ  TYR A  24       7.331  26.028  -5.659  1.00 29.38           C  
ATOM    147  OH  TYR A  24       6.494  27.063  -5.989  1.00 31.41           O  
ATOM    148  N   ALA A  25       8.256  21.261  -2.435  1.00 28.90           N  
ATOM    149  CA  ALA A  25       6.978  20.852  -1.831  1.00 29.07           C  
ATOM    150  C   ALA A  25       6.863  21.246  -0.343  1.00 29.15           C  
ATOM    151  O   ALA A  25       5.798  21.644   0.116  1.00 29.00           O  
ATOM    152  CB  ALA A  25       6.765  19.351  -2.021  1.00 27.99           C  
ATOM    153  N   ALA A  26       7.977  21.136   0.388  1.00 30.19           N  
ATOM    154  CA  ALA A  26       8.063  21.505   1.801  1.00 30.53           C  
ATOM    155  C   ALA A  26       7.953  23.027   2.030  1.00 30.79           C  
ATOM    156  O   ALA A  26       7.256  23.468   2.933  1.00 31.11           O  
ATOM    157  CB  ALA A  26       9.347  20.995   2.368  1.00 30.98           C  
ATOM    158  N   LEU A  27       8.643  23.817   1.210  1.00 31.11           N  
ATOM    159  CA  LEU A  27       8.571  25.295   1.266  1.00 30.58           C  
ATOM    160  C   LEU A  27       7.185  25.804   0.877  1.00 30.41           C  
ATOM    161  O   LEU A  27       6.662  26.757   1.456  1.00 30.52           O  
ATOM    162  CB  LEU A  27       9.625  25.918   0.335  1.00 30.54           C  
ATOM    163  CG  LEU A  27      11.120  25.609   0.569  1.00 29.96           C  
ATOM    164  CD1 LEU A  27      11.950  26.098  -0.622  1.00 28.44           C  
ATOM    165  CD2 LEU A  27      11.617  26.238   1.839  1.00 28.67           C  
ATOM    166  N   PHE A  28       6.600  25.172  -0.130  1.00 30.19           N  
ATOM    167  CA  PHE A  28       5.289  25.550  -0.591  1.00 29.41           C  
ATOM    168  C   PHE A  28       4.205  25.301   0.472  1.00 29.75           C  
ATOM    169  O   PHE A  28       3.395  26.198   0.776  1.00 30.03           O  
ATOM    170  CB  PHE A  28       4.961  24.843  -1.907  1.00 28.84           C  
ATOM    171  CG  PHE A  28       3.728  25.388  -2.586  1.00 27.83           C  
ATOM    172  CD1 PHE A  28       2.451  25.003  -2.161  1.00 26.96           C  
ATOM    173  CD2 PHE A  28       3.844  26.312  -3.630  1.00 26.02           C  
ATOM    174  CE1 PHE A  28       1.298  25.514  -2.788  1.00 26.74           C  
ATOM    175  CE2 PHE A  28       2.708  26.834  -4.248  1.00 25.15           C  
ATOM    176  CZ  PHE A  28       1.436  26.431  -3.829  1.00 26.07           C  
ATOM    177  N   ALA A  29       4.192  24.094   1.028  1.00 29.73           N  
ATOM    178  CA  ALA A  29       3.262  23.752   2.100  1.00 29.98           C  
ATOM    179  C   ALA A  29       3.425  24.656   3.334  1.00 30.73           C  
ATOM    180  O   ALA A  29       2.424  24.997   3.985  1.00 30.90           O  
ATOM    181  CB  ALA A  29       3.401  22.269   2.480  1.00 29.52           C  
ATOM    182  N   ASN A  30       4.672  25.040   3.649  1.00 30.89           N  
ATOM    183  CA  ASN A  30       4.947  25.943   4.769  1.00 31.20           C  
ATOM    184  C   ASN A  30       4.551  27.368   4.457  1.00 31.22           C  
ATOM    185  O   ASN A  30       4.167  28.113   5.343  1.00 31.37           O  
ATOM    186  CB  ASN A  30       6.432  25.944   5.165  1.00 31.18           C  
ATOM    187  CG  ASN A  30       6.906  24.602   5.702  1.00 32.05           C  
ATOM    188  OD1 ASN A  30       6.108  23.733   6.033  1.00 35.29           O  
ATOM    189  ND2 ASN A  30       8.216  24.426   5.770  1.00 30.90           N  
ATOM    190  N   GLY A  31       4.643  27.749   3.194  1.00 31.86           N  
ATOM    191  CA  GLY A  31       4.631  29.163   2.842  1.00 31.87           C  
ATOM    192  C   GLY A  31       3.383  29.734   2.195  1.00 31.93           C  
ATOM    193  O   GLY A  31       3.183  30.954   2.225  1.00 31.68           O  
ATOM    194  N   ILE A  32       2.558  28.879   1.590  1.00 32.15           N  
ATOM    195  CA  ILE A  32       1.464  29.388   0.732  1.00 32.22           C  
ATOM    196  C   ILE A  32       0.292  30.028   1.463  1.00 32.50           C  
ATOM    197  O   ILE A  32      -0.272  31.020   0.989  1.00 32.75           O  
ATOM    198  CB  ILE A  32       0.982  28.377  -0.356  1.00 32.36           C  
ATOM    199  CG1 ILE A  32       0.385  29.166  -1.544  1.00 31.62           C  
ATOM    200  CG2 ILE A  32       0.172  27.211   0.258  1.00 31.47           C  
ATOM    201  CD1 ILE A  32      -0.721  28.462  -2.256  1.00 36.68           C  
ATOM    202  N   GLY A  33      -0.080  29.462   2.601  1.00 32.20           N  
ATOM    203  CA  GLY A  33      -0.991  30.146   3.487  1.00 32.32           C  
ATOM    204  C   GLY A  33      -2.451  29.875   3.219  1.00 32.60           C  
ATOM    205  O   GLY A  33      -3.288  30.236   4.043  1.00 32.53           O  
ATOM    206  N   ASN A  34      -2.768  29.252   2.082  1.00 32.75           N  
ATOM    207  CA  ASN A  34      -4.177  29.024   1.714  1.00 33.28           C  
ATOM    208  C   ASN A  34      -4.558  27.550   1.683  1.00 33.17           C  
ATOM    209  O   ASN A  34      -5.653  27.195   1.259  1.00 32.85           O  
ATOM    210  CB  ASN A  34      -4.523  29.703   0.382  1.00 32.96           C  
ATOM    211  CG  ASN A  34      -3.622  29.257  -0.754  1.00 34.41           C  
ATOM    212  OD1 ASN A  34      -3.166  28.109  -0.787  1.00 35.14           O  
ATOM    213  ND2 ASN A  34      -3.349  30.167  -1.695  1.00 34.97           N  
ATOM    214  N   GLY A  35      -3.646  26.693   2.128  1.00 33.55           N  
ATOM    215  CA  GLY A  35      -3.905  25.259   2.161  1.00 34.24           C  
ATOM    216  C   GLY A  35      -3.982  24.549   0.809  1.00 34.52           C  
ATOM    217  O   GLY A  35      -4.384  23.397   0.762  1.00 35.09           O  
ATOM    218  N   LEU A  36      -3.611  25.219  -0.285  1.00 34.44           N  
ATOM    219  CA  LEU A  36      -3.578  24.583  -1.616  1.00 34.48           C  
ATOM    220  C   LEU A  36      -2.248  23.857  -1.910  1.00 34.33           C  
ATOM    221  O   LEU A  36      -1.179  24.281  -1.442  1.00 34.47           O  
ATOM    222  CB  LEU A  36      -3.876  25.612  -2.733  1.00 34.49           C  
ATOM    223  CG  LEU A  36      -5.266  26.275  -2.824  1.00 34.87           C  
ATOM    224  CD1 LEU A  36      -5.312  27.329  -3.911  1.00 33.62           C  
ATOM    225  CD2 LEU A  36      -6.383  25.267  -3.045  1.00 36.15           C  
ATOM    226  N   THR A  37      -2.318  22.771  -2.689  1.00 33.73           N  
ATOM    227  CA  THR A  37      -1.118  22.096  -3.197  1.00 33.47           C  
ATOM    228  C   THR A  37      -0.460  22.888  -4.352  1.00 33.37           C  
ATOM    229  O   THR A  37      -1.105  23.756  -4.959  1.00 33.44           O  
ATOM    230  CB  THR A  37      -1.425  20.663  -3.662  1.00 33.49           C  
ATOM    231  OG1 THR A  37      -2.319  20.701  -4.783  1.00 33.10           O  
ATOM    232  CG2 THR A  37      -2.062  19.860  -2.545  1.00 34.05           C  
ATOM    233  N   PRO A  38       0.841  22.627  -4.638  1.00 33.43           N  
ATOM    234  CA  PRO A  38       1.468  23.252  -5.820  1.00 33.18           C  
ATOM    235  C   PRO A  38       0.633  23.200  -7.097  1.00 33.49           C  
ATOM    236  O   PRO A  38       0.534  24.220  -7.790  1.00 33.63           O  
ATOM    237  CB  PRO A  38       2.770  22.453  -5.988  1.00 32.83           C  
ATOM    238  CG  PRO A  38       3.155  22.104  -4.586  1.00 32.73           C  
ATOM    239  CD  PRO A  38       1.824  21.824  -3.872  1.00 33.01           C  
ATOM    240  N   THR A  39       0.055  22.034  -7.415  1.00 33.69           N  
ATOM    241  CA  THR A  39      -0.651  21.834  -8.692  1.00 33.67           C  
ATOM    242  C   THR A  39      -2.010  22.499  -8.650  1.00 34.30           C  
ATOM    243  O   THR A  39      -2.442  23.101  -9.639  1.00 34.90           O  
ATOM    244  CB  THR A  39      -0.783  20.342  -9.086  1.00 33.58           C  
ATOM    245  OG1 THR A  39      -1.282  19.586  -7.982  1.00 33.84           O  
ATOM    246  CG2 THR A  39       0.575  19.771  -9.461  1.00 33.46           C  
ATOM    247  N   GLN A  40      -2.672  22.421  -7.495  1.00 34.29           N  
ATOM    248  CA  GLN A  40      -3.894  23.183  -7.274  1.00 34.56           C  
ATOM    249  C   GLN A  40      -3.698  24.671  -7.552  1.00 34.07           C  
ATOM    250  O   GLN A  40      -4.554  25.296  -8.168  1.00 34.86           O  
ATOM    251  CB  GLN A  40      -4.453  22.946  -5.866  1.00 34.42           C  
ATOM    252  CG  GLN A  40      -5.249  21.650  -5.767  1.00 34.36           C  
ATOM    253  CD  GLN A  40      -5.511  21.209  -4.339  1.00 35.78           C  
ATOM    254  OE1 GLN A  40      -5.439  22.002  -3.399  1.00 35.04           O  
ATOM    255  NE2 GLN A  40      -5.824  19.929  -4.174  1.00 35.92           N  
ATOM    256  N   TRP A  41      -2.552  25.202  -7.139  1.00 33.28           N  
ATOM    257  CA  TRP A  41      -2.186  26.619  -7.318  1.00 32.77           C  
ATOM    258  C   TRP A  41      -1.878  26.920  -8.778  1.00 32.63           C  
ATOM    259  O   TRP A  41      -2.304  27.953  -9.303  1.00 33.54           O  
ATOM    260  CB  TRP A  41      -0.976  26.978  -6.430  1.00 31.56           C  
ATOM    261  CG  TRP A  41      -0.446  28.395  -6.633  1.00 32.02           C  
ATOM    262  CD1 TRP A  41       0.735  28.757  -7.238  1.00 31.33           C  
ATOM    263  CD2 TRP A  41      -1.068  29.635  -6.206  1.00 31.66           C  
ATOM    264  NE1 TRP A  41       0.880  30.129  -7.218  1.00 32.01           N  
ATOM    265  CE2 TRP A  41      -0.211  30.690  -6.598  1.00 30.96           C  
ATOM    266  CE3 TRP A  41      -2.263  29.950  -5.539  1.00 31.38           C  
ATOM    267  CZ2 TRP A  41      -0.525  32.037  -6.361  1.00 31.32           C  
ATOM    268  CZ3 TRP A  41      -2.566  31.294  -5.296  1.00 30.66           C  
ATOM    269  CH2 TRP A  41      -1.700  32.315  -5.706  1.00 30.06           C  
ATOM    270  N   ALA A  42      -1.135  26.019  -9.422  1.00 32.49           N  
ATOM    271  CA  ALA A  42      -0.768  26.130 -10.839  1.00 32.53           C  
ATOM    272  C   ALA A  42      -2.003  26.230 -11.735  1.00 32.70           C  
ATOM    273  O   ALA A  42      -2.060  27.090 -12.618  1.00 32.84           O  
ATOM    274  CB  ALA A  42       0.093  24.938 -11.270  1.00 32.04           C  
ATOM    275  N   ALA A  43      -2.969  25.338 -11.515  1.00 32.87           N  
ATOM    276  CA  ALA A  43      -4.246  25.374 -12.237  1.00 33.66           C  
ATOM    277  C   ALA A  43      -5.002  26.656 -11.957  1.00 34.22           C  
ATOM    278  O   ALA A  43      -5.580  27.219 -12.859  1.00 34.91           O  
ATOM    279  CB  ALA A  43      -5.105  24.186 -11.884  1.00 33.42           C  
ATOM    280  N   LEU A  44      -4.986  27.122 -10.711  1.00 34.94           N  
ATOM    281  CA  LEU A  44      -5.653  28.388 -10.350  1.00 35.36           C  
ATOM    282  C   LEU A  44      -5.000  29.566 -11.086  1.00 35.36           C  
ATOM    283  O   LEU A  44      -5.686  30.376 -11.716  1.00 35.64           O  
ATOM    284  CB  LEU A  44      -5.567  28.630  -8.837  1.00 34.72           C  
ATOM    285  CG  LEU A  44      -6.483  29.696  -8.259  1.00 35.41           C  
ATOM    286  CD1 LEU A  44      -7.863  29.093  -7.941  1.00 37.67           C  
ATOM    287  CD2 LEU A  44      -5.864  30.319  -7.010  1.00 35.64           C  
ATOM    288  N   VAL A  45      -3.673  29.651 -10.984  1.00 35.14           N  
ATOM    289  CA  VAL A  45      -2.903  30.660 -11.699  1.00 34.93           C  
ATOM    290  C   VAL A  45      -3.217  30.620 -13.198  1.00 35.78           C  
ATOM    291  O   VAL A  45      -3.573  31.644 -13.768  1.00 35.83           O  
ATOM    292  CB  VAL A  45      -1.379  30.531 -11.409  1.00 34.66           C  
ATOM    293  CG1 VAL A  45      -0.563  31.497 -12.255  1.00 32.16           C  
ATOM    294  CG2 VAL A  45      -1.110  30.772  -9.921  1.00 33.49           C  
ATOM    295  N   ARG A  46      -3.130  29.439 -13.811  1.00 36.59           N  
ATOM    296  CA  ARG A  46      -3.358  29.299 -15.247  1.00 37.79           C  
ATOM    297  C   ARG A  46      -4.763  29.724 -15.699  1.00 38.81           C  
ATOM    298  O   ARG A  46      -4.893  30.432 -16.697  1.00 39.03           O  
ATOM    299  CB  ARG A  46      -3.036  27.881 -15.731  1.00 37.76           C  
ATOM    300  CG  ARG A  46      -2.996  27.730 -17.252  1.00 37.07           C  
ATOM    301  CD  ARG A  46      -1.822  28.480 -17.852  1.00 38.19           C  
ATOM    302  NE  ARG A  46      -0.595  27.686 -17.814  1.00 40.76           N  
ATOM    303  CZ  ARG A  46       0.629  28.167 -18.029  1.00 41.07           C  
ATOM    304  NH1 ARG A  46       0.824  29.455 -18.274  1.00 40.89           N  
ATOM    305  NH2 ARG A  46       1.669  27.355 -17.982  1.00 41.63           N  
ATOM    306  N   LEU A  47      -5.800  29.304 -14.969  1.00 39.81           N  
ATOM    307  CA  LEU A  47      -7.168  29.776 -15.213  1.00 41.01           C  
ATOM    308  C   LEU A  47      -7.329  31.294 -15.102  1.00 42.23           C  
ATOM    309  O   LEU A  47      -8.262  31.864 -15.678  1.00 42.95           O  
ATOM    310  CB  LEU A  47      -8.149  29.113 -14.254  1.00 40.65           C  
ATOM    311  CG  LEU A  47      -8.614  27.683 -14.509  1.00 41.66           C  
ATOM    312  CD1 LEU A  47      -9.465  27.231 -13.344  1.00 42.79           C  
ATOM    313  CD2 LEU A  47      -9.373  27.532 -15.830  1.00 40.11           C  
ATOM    314  N   GLY A  48      -6.446  31.943 -14.339  1.00 43.09           N  
ATOM    315  CA  GLY A  48      -6.423  33.393 -14.254  1.00 44.14           C  
ATOM    316  C   GLY A  48      -5.833  34.023 -15.492  1.00 45.24           C  
ATOM    317  O   GLY A  48      -6.276  35.078 -15.913  1.00 45.37           O  
ATOM    318  N   GLU A  49      -4.824  33.376 -16.075  1.00 46.40           N  
ATOM    319  CA  GLU A  49      -4.232  33.822 -17.343  1.00 47.78           C  
ATOM    320  C   GLU A  49      -5.198  33.671 -18.519  1.00 47.74           C  
ATOM    321  O   GLU A  49      -5.351  34.578 -19.333  1.00 48.18           O  
ATOM    322  CB  GLU A  49      -2.960  33.033 -17.664  1.00 47.39           C  
ATOM    323  CG  GLU A  49      -1.815  33.267 -16.699  1.00 49.29           C  
ATOM    324  CD  GLU A  49      -0.568  32.455 -17.053  1.00 49.32           C  
ATOM    325  OE1 GLU A  49      -0.299  32.320 -18.266  1.00 51.19           O  
ATOM    326  OE2 GLU A  49       0.144  31.977 -16.121  1.00 50.19           O  
ATOM    327  N   THR A  50      -5.852  32.519 -18.585  1.00 48.05           N  
ATOM    328  CA  THR A  50      -6.564  32.085 -19.783  1.00 48.37           C  
ATOM    329  C   THR A  50      -7.997  32.581 -19.875  1.00 48.52           C  
ATOM    330  O   THR A  50      -8.496  32.852 -20.966  1.00 49.36           O  
ATOM    331  CB  THR A  50      -6.614  30.547 -19.855  1.00 48.29           C  
ATOM    332  OG1 THR A  50      -7.152  30.044 -18.630  1.00 47.97           O  
ATOM    333  CG2 THR A  50      -5.226  29.965 -20.076  1.00 48.04           C  
ATOM    334  N   GLY A  51      -8.664  32.693 -18.734  1.00 48.43           N  
ATOM    335  CA  GLY A  51     -10.107  32.856 -18.731  1.00 47.77           C  
ATOM    336  C   GLY A  51     -10.680  31.474 -18.997  1.00 47.34           C  
ATOM    337  O   GLY A  51      -9.960  30.473 -18.860  1.00 47.44           O  
ATOM    338  N   PRO A  52     -11.972  31.406 -19.377  1.00 46.74           N  
ATOM    339  CA  PRO A  52     -12.634  30.124 -19.655  1.00 46.22           C  
ATOM    340  C   PRO A  52     -11.875  29.245 -20.672  1.00 45.64           C  
ATOM    341  O   PRO A  52     -11.451  29.713 -21.730  1.00 45.35           O  
ATOM    342  CB  PRO A  52     -14.029  30.534 -20.161  1.00 46.19           C  
ATOM    343  CG  PRO A  52     -13.957  32.005 -20.405  1.00 46.16           C  
ATOM    344  CD  PRO A  52     -12.889  32.549 -19.541  1.00 46.58           C  
ATOM    345  N   CYS A  53     -11.724  27.973 -20.316  1.00 45.41           N  
ATOM    346  CA  CYS A  53     -10.773  27.065 -20.936  1.00 44.79           C  
ATOM    347  C   CYS A  53     -11.314  25.669 -20.722  1.00 44.18           C  
ATOM    348  O   CYS A  53     -11.859  25.384 -19.659  1.00 44.24           O  
ATOM    349  CB  CYS A  53      -9.410  27.187 -20.228  1.00 45.38           C  
ATOM    350  SG  CYS A  53      -7.962  26.746 -21.229  1.00 45.98           S  
ATOM    351  N   PRO A  54     -11.198  24.792 -21.734  1.00 43.58           N  
ATOM    352  CA  PRO A  54     -11.564  23.385 -21.526  1.00 43.17           C  
ATOM    353  C   PRO A  54     -10.671  22.727 -20.457  1.00 42.84           C  
ATOM    354  O   PRO A  54      -9.480  23.046 -20.384  1.00 43.03           O  
ATOM    355  CB  PRO A  54     -11.313  22.747 -22.897  1.00 43.16           C  
ATOM    356  CG  PRO A  54     -11.205  23.885 -23.869  1.00 43.02           C  
ATOM    357  CD  PRO A  54     -10.740  25.067 -23.110  1.00 43.46           C  
ATOM    358  N   GLN A  55     -11.230  21.824 -19.651  1.00 42.34           N  
ATOM    359  CA  GLN A  55     -10.491  21.184 -18.540  1.00 42.44           C  
ATOM    360  C   GLN A  55      -9.216  20.452 -18.981  1.00 41.98           C  
ATOM    361  O   GLN A  55      -8.174  20.575 -18.347  1.00 41.92           O  
ATOM    362  CB  GLN A  55     -11.395  20.220 -17.769  1.00 42.50           C  
ATOM    363  CG  GLN A  55     -10.830  19.737 -16.434  1.00 42.96           C  
ATOM    364  CD  GLN A  55     -11.830  18.889 -15.662  1.00 43.36           C  
ATOM    365  OE1 GLN A  55     -11.991  17.700 -15.924  1.00 45.30           O  
ATOM    366  NE2 GLN A  55     -12.514  19.506 -14.712  1.00 44.94           N  
ATOM    367  N   ASN A  56      -9.312  19.706 -20.073  1.00 41.35           N  
ATOM    368  CA  ASN A  56      -8.188  18.933 -20.603  1.00 41.03           C  
ATOM    369  C   ASN A  56      -7.112  19.824 -21.225  1.00 40.63           C  
ATOM    370  O   ASN A  56      -5.909  19.502 -21.178  1.00 40.02           O  
ATOM    371  CB  ASN A  56      -8.692  17.903 -21.618  1.00 40.62           C  
ATOM    372  CG  ASN A  56      -9.404  16.720 -20.955  1.00 41.39           C  
ATOM    373  OD1 ASN A  56      -9.608  16.681 -19.720  1.00 40.14           O  
ATOM    374  ND2 ASN A  56      -9.771  15.738 -21.773  1.00 40.57           N  
ATOM    375  N   GLN A  57      -7.558  20.941 -21.802  1.00 39.82           N  
ATOM    376  CA  GLN A  57      -6.645  21.963 -22.288  1.00 39.66           C  
ATOM    377  C   GLN A  57      -5.937  22.650 -21.131  1.00 38.82           C  
ATOM    378  O   GLN A  57      -4.747  22.939 -21.223  1.00 39.53           O  
ATOM    379  CB  GLN A  57      -7.393  22.993 -23.130  1.00 39.88           C  
ATOM    380  CG  GLN A  57      -6.489  24.060 -23.728  1.00 41.20           C  
ATOM    381  CD  GLN A  57      -7.112  24.714 -24.936  1.00 44.42           C  
ATOM    382  OE1 GLN A  57      -7.182  24.112 -26.011  1.00 46.10           O  
ATOM    383  NE2 GLN A  57      -7.565  25.949 -24.774  1.00 43.56           N  
ATOM    384  N   LEU A  58      -6.673  22.925 -20.057  1.00 38.06           N  
ATOM    385  CA  LEU A  58      -6.083  23.464 -18.845  1.00 37.80           C  
ATOM    386  C   LEU A  58      -4.983  22.496 -18.364  1.00 37.86           C  
ATOM    387  O   LEU A  58      -3.914  22.914 -17.937  1.00 37.21           O  
ATOM    388  CB  LEU A  58      -7.154  23.687 -17.764  1.00 37.41           C  
ATOM    389  CG  LEU A  58      -6.658  24.119 -16.367  1.00 37.86           C  
ATOM    390  CD1 LEU A  58      -5.816  25.401 -16.394  1.00 36.05           C  
ATOM    391  CD2 LEU A  58      -7.778  24.233 -15.322  1.00 37.28           C  
ATOM    392  N   GLY A  59      -5.269  21.203 -18.493  1.00 37.96           N  
ATOM    393  CA  GLY A  59      -4.348  20.152 -18.141  1.00 38.37           C  
ATOM    394  C   GLY A  59      -3.087  20.232 -18.956  1.00 38.46           C  
ATOM    395  O   GLY A  59      -1.994  20.171 -18.403  1.00 38.55           O  
ATOM    396  N   ARG A  60      -3.247  20.398 -20.265  1.00 38.51           N  
ATOM    397  CA  ARG A  60      -2.127  20.434 -21.205  1.00 39.39           C  
ATOM    398  C   ARG A  60      -1.277  21.714 -21.139  1.00 39.14           C  
ATOM    399  O   ARG A  60      -0.230  21.793 -21.786  1.00 39.74           O  
ATOM    400  CB  ARG A  60      -2.624  20.189 -22.638  1.00 39.45           C  
ATOM    401  CG  ARG A  60      -3.256  18.806 -22.850  1.00 41.05           C  
ATOM    402  CD  ARG A  60      -4.024  18.713 -24.168  1.00 41.32           C  
ATOM    403  NE  ARG A  60      -3.140  18.259 -25.239  1.00 48.21           N  
ATOM    404  CZ  ARG A  60      -2.598  19.062 -26.149  1.00 50.97           C  
ATOM    405  NH1 ARG A  60      -2.877  20.361 -26.117  1.00 54.03           N  
ATOM    406  NH2 ARG A  60      -1.795  18.574 -27.096  1.00 49.80           N  
ATOM    407  N   LEU A  61      -1.730  22.712 -20.377  1.00 38.86           N  
ATOM    408  CA  LEU A  61      -0.979  23.953 -20.192  1.00 38.02           C  
ATOM    409  C   LEU A  61      -0.297  23.975 -18.835  1.00 37.87           C  
ATOM    410  O   LEU A  61       0.496  24.883 -18.552  1.00 38.09           O  
ATOM    411  CB  LEU A  61      -1.884  25.175 -20.323  1.00 37.75           C  
ATOM    412  CG  LEU A  61      -2.444  25.540 -21.708  1.00 38.09           C  
ATOM    413  CD1 LEU A  61      -3.787  26.286 -21.583  1.00 34.77           C  
ATOM    414  CD2 LEU A  61      -1.433  26.365 -22.492  1.00 36.24           C  
ATOM    415  N   THR A  62      -0.609  22.981 -18.000  1.00 36.99           N  
ATOM    416  CA  THR A  62      -0.011  22.870 -16.656  1.00 36.52           C  
ATOM    417  C   THR A  62       0.643  21.502 -16.416  1.00 36.27           C  
ATOM    418  O   THR A  62       0.792  21.093 -15.268  1.00 35.76           O  
ATOM    419  CB  THR A  62      -1.039  23.108 -15.550  1.00 36.07           C  
ATOM    420  OG1 THR A  62      -2.114  22.177 -15.704  1.00 36.31           O  
ATOM    421  CG2 THR A  62      -1.588  24.510 -15.611  1.00 36.04           C  
ATOM    422  N   ALA A  63       1.030  20.832 -17.510  1.00 36.06           N  
ATOM    423  CA  ALA A  63       1.623  19.488 -17.525  1.00 35.94           C  
ATOM    424  C   ALA A  63       0.829  18.465 -16.705  1.00 36.36           C  
ATOM    425  O   ALA A  63       1.386  17.697 -15.928  1.00 36.01           O  
ATOM    426  CB  ALA A  63       3.084  19.539 -17.099  1.00 35.79           C  
HETATM  427  N   MSE A  64      -0.478  18.454 -16.900  1.00 37.06           N  
HETATM  428  CA  MSE A  64      -1.344  17.573 -16.152  1.00 39.24           C  
HETATM  429  C   MSE A  64      -2.264  16.730 -17.018  1.00 39.32           C  
HETATM  430  O   MSE A  64      -2.889  17.205 -17.973  1.00 39.86           O  
HETATM  431  CB  MSE A  64      -2.165  18.343 -15.109  1.00 38.58           C  
HETATM  432  CG  MSE A  64      -1.420  18.537 -13.798  1.00 39.53           C  
HETATM  433 SE   MSE A  64      -2.453  19.423 -12.416  1.00 43.37          SE  
HETATM  434  CE  MSE A  64      -2.001  21.297 -12.676  1.00 36.13           C  
ATOM    435  N   ASP A  65      -2.315  15.462 -16.637  1.00 39.76           N  
ATOM    436  CA  ASP A  65      -3.221  14.452 -17.151  1.00 40.09           C  
ATOM    437  C   ASP A  65      -4.660  14.864 -17.061  1.00 39.68           C  
ATOM    438  O   ASP A  65      -5.015  15.648 -16.186  1.00 39.69           O  
ATOM    439  CB  ASP A  65      -3.100  13.234 -16.243  1.00 40.60           C  
ATOM    440  CG  ASP A  65      -2.688  12.059 -16.971  1.00 42.23           C  
ATOM    441  OD1 ASP A  65      -2.667  12.174 -18.205  1.00 46.31           O  
ATOM    442  OD2 ASP A  65      -2.364  11.040 -16.336  1.00 46.57           O  
ATOM    443  N   ALA A  66      -5.486  14.278 -17.926  1.00 39.15           N  
ATOM    444  CA  ALA A  66      -6.939  14.400 -17.855  1.00 38.88           C  
ATOM    445  C   ALA A  66      -7.469  13.974 -16.490  1.00 38.68           C  
ATOM    446  O   ALA A  66      -8.256  14.691 -15.871  1.00 38.47           O  
ATOM    447  CB  ALA A  66      -7.597  13.571 -18.972  1.00 39.09           C  
ATOM    448  N   ALA A  67      -7.033  12.804 -16.030  1.00 38.76           N  
ATOM    449  CA  ALA A  67      -7.353  12.309 -14.687  1.00 39.06           C  
ATOM    450  C   ALA A  67      -6.789  13.208 -13.568  1.00 39.40           C  
ATOM    451  O   ALA A  67      -7.469  13.455 -12.573  1.00 40.13           O  
ATOM    452  CB  ALA A  67      -6.865  10.873 -14.517  1.00 38.63           C  
ATOM    453  N   THR A  68      -5.559  13.694 -13.737  1.00 39.34           N  
ATOM    454  CA  THR A  68      -4.938  14.589 -12.763  1.00 39.07           C  
ATOM    455  C   THR A  68      -5.628  15.946 -12.704  1.00 39.26           C  
ATOM    456  O   THR A  68      -5.982  16.396 -11.625  1.00 39.42           O  
ATOM    457  CB  THR A  68      -3.426  14.778 -13.033  1.00 39.04           C  
ATOM    458  OG1 THR A  68      -2.815  13.498 -13.192  1.00 38.86           O  
ATOM    459  CG2 THR A  68      -2.738  15.502 -11.873  1.00 39.19           C  
ATOM    460  N   ILE A  69      -5.822  16.595 -13.854  1.00 39.64           N  
ATOM    461  CA  ILE A  69      -6.493  17.887 -13.875  1.00 39.78           C  
ATOM    462  C   ILE A  69      -7.941  17.769 -13.447  1.00 40.71           C  
ATOM    463  O   ILE A  69      -8.467  18.677 -12.810  1.00 41.37           O  
ATOM    464  CB  ILE A  69      -6.363  18.641 -15.225  1.00 39.49           C  
ATOM    465  CG1 ILE A  69      -6.764  20.112 -15.054  1.00 38.61           C  
ATOM    466  CG2 ILE A  69      -7.183  17.975 -16.328  1.00 39.04           C  
ATOM    467  CD1 ILE A  69      -5.791  20.935 -14.224  1.00 39.24           C  
ATOM    468  N   LYS A  70      -8.578  16.648 -13.787  1.00 41.66           N  
ATOM    469  CA  LYS A  70      -9.951  16.374 -13.374  1.00 42.49           C  
ATOM    470  C   LYS A  70     -10.115  16.586 -11.868  1.00 42.78           C  
ATOM    471  O   LYS A  70     -11.040  17.261 -11.427  1.00 42.77           O  
ATOM    472  CB  LYS A  70     -10.333  14.942 -13.733  1.00 42.57           C  
ATOM    473  CG  LYS A  70     -11.820  14.649 -13.596  1.00 45.06           C  
ATOM    474  CD  LYS A  70     -12.140  13.196 -13.938  1.00 47.22           C  
ATOM    475  CE  LYS A  70     -13.532  12.809 -13.455  1.00 49.63           C  
ATOM    476  NZ  LYS A  70     -14.597  13.238 -14.413  1.00 51.44           N  
ATOM    477  N   GLY A  71      -9.193  16.023 -11.091  1.00 43.09           N  
ATOM    478  CA  GLY A  71      -9.318  15.991  -9.646  1.00 43.25           C  
ATOM    479  C   GLY A  71      -8.805  17.255  -8.978  1.00 43.53           C  
ATOM    480  O   GLY A  71      -9.283  17.629  -7.901  1.00 43.99           O  
ATOM    481  N   VAL A  72      -7.825  17.907  -9.594  1.00 43.21           N  
ATOM    482  CA  VAL A  72      -7.406  19.216  -9.132  1.00 43.05           C  
ATOM    483  C   VAL A  72      -8.580  20.195  -9.260  1.00 43.67           C  
ATOM    484  O   VAL A  72      -8.893  20.919  -8.306  1.00 43.75           O  
ATOM    485  CB  VAL A  72      -6.156  19.730  -9.896  1.00 42.94           C  
ATOM    486  CG1 VAL A  72      -6.069  21.255  -9.849  1.00 41.47           C  
ATOM    487  CG2 VAL A  72      -4.904  19.088  -9.348  1.00 41.45           C  
ATOM    488  N   VAL A  73      -9.233  20.205 -10.427  1.00 44.10           N  
ATOM    489  CA  VAL A  73     -10.362  21.112 -10.668  1.00 44.55           C  
ATOM    490  C   VAL A  73     -11.540  20.798  -9.735  1.00 45.21           C  
ATOM    491  O   VAL A  73     -12.204  21.708  -9.245  1.00 44.85           O  
ATOM    492  CB  VAL A  73     -10.804  21.125 -12.154  1.00 44.42           C  
ATOM    493  CG1 VAL A  73     -12.144  21.843 -12.326  1.00 43.95           C  
ATOM    494  CG2 VAL A  73      -9.756  21.797 -13.017  1.00 43.80           C  
ATOM    495  N   GLU A  74     -11.773  19.516  -9.474  1.00 46.22           N  
ATOM    496  CA  GLU A  74     -12.825  19.116  -8.539  1.00 47.92           C  
ATOM    497  C   GLU A  74     -12.544  19.553  -7.098  1.00 48.04           C  
ATOM    498  O   GLU A  74     -13.443  20.044  -6.421  1.00 48.34           O  
ATOM    499  CB  GLU A  74     -13.117  17.615  -8.635  1.00 47.59           C  
ATOM    500  CG  GLU A  74     -13.952  17.257  -9.864  1.00 49.23           C  
ATOM    501  CD  GLU A  74     -13.967  15.763 -10.192  1.00 50.22           C  
ATOM    502  OE1 GLU A  74     -13.441  14.957  -9.386  1.00 52.97           O  
ATOM    503  OE2 GLU A  74     -14.516  15.392 -11.265  1.00 53.89           O  
ATOM    504  N   ARG A  75     -11.298  19.403  -6.647  1.00 48.70           N  
ATOM    505  CA  ARG A  75     -10.888  19.894  -5.329  1.00 49.61           C  
ATOM    506  C   ARG A  75     -10.908  21.420  -5.240  1.00 49.12           C  
ATOM    507  O   ARG A  75     -11.240  21.979  -4.204  1.00 49.53           O  
ATOM    508  CB  ARG A  75      -9.520  19.340  -4.937  1.00 49.42           C  
ATOM    509  CG  ARG A  75      -9.546  17.840  -4.630  1.00 51.45           C  
ATOM    510  CD  ARG A  75      -8.151  17.268  -4.414  1.00 52.18           C  
ATOM    511  NE  ARG A  75      -7.298  17.421  -5.599  1.00 58.23           N  
ATOM    512  CZ  ARG A  75      -5.984  17.200  -5.617  1.00 59.87           C  
ATOM    513  NH1 ARG A  75      -5.346  16.819  -4.511  1.00 61.97           N  
ATOM    514  NH2 ARG A  75      -5.302  17.372  -6.738  1.00 60.55           N  
ATOM    515  N   LEU A  76     -10.562  22.086  -6.336  1.00 49.11           N  
ATOM    516  CA  LEU A  76     -10.701  23.533  -6.461  1.00 48.73           C  
ATOM    517  C   LEU A  76     -12.189  23.941  -6.444  1.00 49.27           C  
ATOM    518  O   LEU A  76     -12.535  25.052  -6.030  1.00 49.06           O  
ATOM    519  CB  LEU A  76     -10.033  23.986  -7.759  1.00 48.74           C  
ATOM    520  CG  LEU A  76      -8.897  25.019  -7.805  1.00 48.20           C  
ATOM    521  CD1 LEU A  76      -7.887  24.847  -6.688  1.00 46.94           C  
ATOM    522  CD2 LEU A  76      -8.195  24.981  -9.161  1.00 47.70           C  
ATOM    523  N   ASP A  77     -13.062  23.030  -6.883  1.00 50.03           N  
ATOM    524  CA  ASP A  77     -14.507  23.275  -6.923  1.00 50.35           C  
ATOM    525  C   ASP A  77     -15.121  23.183  -5.535  1.00 50.49           C  
ATOM    526  O   ASP A  77     -15.829  24.087  -5.103  1.00 50.19           O  
ATOM    527  CB  ASP A  77     -15.201  22.295  -7.872  1.00 50.49           C  
ATOM    528  CG  ASP A  77     -16.639  22.700  -8.187  1.00 51.67           C  
ATOM    529  OD1 ASP A  77     -17.018  23.859  -7.893  1.00 52.05           O  
ATOM    530  OD2 ASP A  77     -17.394  21.858  -8.726  1.00 52.03           O  
ATOM    531  N   LYS A  78     -14.841  22.076  -4.851  1.00 50.94           N  
ATOM    532  CA  LYS A  78     -15.209  21.865  -3.451  1.00 51.31           C  
ATOM    533  C   LYS A  78     -14.949  23.116  -2.589  1.00 50.93           C  
ATOM    534  O   LYS A  78     -15.702  23.399  -1.655  1.00 51.22           O  
ATOM    535  CB  LYS A  78     -14.426  20.661  -2.908  1.00 51.35           C  
ATOM    536  CG  LYS A  78     -14.847  20.137  -1.525  1.00 52.29           C  
ATOM    537  CD  LYS A  78     -13.771  19.200  -0.942  1.00 52.78           C  
ATOM    538  CE  LYS A  78     -13.480  17.984  -1.857  1.00 55.24           C  
ATOM    539  NZ  LYS A  78     -12.142  17.343  -1.598  1.00 56.04           N  
ATOM    540  N   ARG A  79     -13.896  23.863  -2.913  1.00 50.26           N  
ATOM    541  CA  ARG A  79     -13.556  25.086  -2.184  1.00 49.61           C  
ATOM    542  C   ARG A  79     -14.267  26.336  -2.706  1.00 48.46           C  
ATOM    543  O   ARG A  79     -14.112  27.414  -2.138  1.00 48.35           O  
ATOM    544  CB  ARG A  79     -12.039  25.305  -2.188  1.00 49.95           C  
ATOM    545  CG  ARG A  79     -11.269  24.146  -1.608  1.00 52.05           C  
ATOM    546  CD  ARG A  79      -9.800  24.280  -1.887  1.00 56.36           C  
ATOM    547  NE  ARG A  79      -9.208  25.346  -1.079  1.00 59.97           N  
ATOM    548  CZ  ARG A  79      -8.447  25.152  -0.004  1.00 60.16           C  
ATOM    549  NH1 ARG A  79      -8.160  23.919   0.408  1.00 59.49           N  
ATOM    550  NH2 ARG A  79      -7.962  26.201   0.649  1.00 60.43           N  
ATOM    551  N   GLY A  80     -15.046  26.190  -3.773  1.00 47.54           N  
ATOM    552  CA  GLY A  80     -15.773  27.317  -4.374  1.00 46.49           C  
ATOM    553  C   GLY A  80     -14.929  28.203  -5.279  1.00 45.93           C  
ATOM    554  O   GLY A  80     -15.294  29.348  -5.548  1.00 45.72           O  
ATOM    555  N   LEU A  81     -13.809  27.678  -5.773  1.00 45.26           N  
ATOM    556  CA  LEU A  81     -12.838  28.522  -6.463  1.00 44.57           C  
ATOM    557  C   LEU A  81     -12.960  28.530  -7.982  1.00 44.84           C  
ATOM    558  O   LEU A  81     -12.305  29.335  -8.652  1.00 44.64           O  
ATOM    559  CB  LEU A  81     -11.410  28.180  -6.033  1.00 43.98           C  
ATOM    560  CG  LEU A  81     -11.086  28.226  -4.533  1.00 42.77           C  
ATOM    561  CD1 LEU A  81      -9.627  27.864  -4.346  1.00 41.73           C  
ATOM    562  CD2 LEU A  81     -11.413  29.579  -3.893  1.00 38.83           C  
ATOM    563  N   ILE A  82     -13.794  27.647  -8.528  1.00 45.06           N  
ATOM    564  CA  ILE A  82     -14.006  27.601  -9.978  1.00 45.53           C  
ATOM    565  C   ILE A  82     -15.483  27.666 -10.347  1.00 46.08           C  
ATOM    566  O   ILE A  82     -16.362  27.360  -9.521  1.00 45.94           O  
ATOM    567  CB  ILE A  82     -13.325  26.357 -10.669  1.00 45.74           C  
ATOM    568  CG1 ILE A  82     -13.817  25.028 -10.089  1.00 45.79           C  
ATOM    569  CG2 ILE A  82     -11.804  26.432 -10.592  1.00 44.95           C  
ATOM    570  CD1 ILE A  82     -14.789  24.301 -10.982  1.00 46.60           C  
ATOM    571  N   GLN A  83     -15.739  28.091 -11.584  1.00 46.41           N  
ATOM    572  CA  GLN A  83     -17.064  28.004 -12.189  1.00 46.58           C  
ATOM    573  C   GLN A  83     -16.985  27.297 -13.552  1.00 46.79           C  
ATOM    574  O   GLN A  83     -16.021  27.459 -14.320  1.00 46.18           O  
ATOM    575  CB  GLN A  83     -17.750  29.384 -12.275  1.00 46.77           C  
ATOM    576  CG  GLN A  83     -17.106  30.400 -13.228  1.00 47.39           C  
ATOM    577  CD  GLN A  83     -17.457  31.877 -12.945  1.00 47.50           C  
ATOM    578  OE1 GLN A  83     -16.986  32.767 -13.663  1.00 48.69           O  
ATOM    579  NE2 GLN A  83     -18.267  32.141 -11.901  1.00 47.47           N  
ATOM    580  N   ARG A  84     -17.999  26.483 -13.819  1.00 46.94           N  
ATOM    581  CA  ARG A  84     -18.121  25.803 -15.095  1.00 46.97           C  
ATOM    582  C   ARG A  84     -19.258  26.420 -15.908  1.00 46.92           C  
ATOM    583  O   ARG A  84     -20.218  26.977 -15.358  1.00 46.71           O  
ATOM    584  CB  ARG A  84     -18.335  24.304 -14.890  1.00 47.17           C  
ATOM    585  CG  ARG A  84     -17.180  23.570 -14.198  1.00 47.71           C  
ATOM    586  CD  ARG A  84     -17.540  22.112 -14.036  1.00 48.61           C  
ATOM    587  NE  ARG A  84     -16.476  21.269 -13.489  1.00 49.30           N  
ATOM    588  CZ  ARG A  84     -16.319  21.006 -12.194  1.00 50.70           C  
ATOM    589  NH1 ARG A  84     -17.133  21.551 -11.298  1.00 51.31           N  
ATOM    590  NH2 ARG A  84     -15.338  20.208 -11.790  1.00 52.13           N  
ATOM    591  N   SER A  85     -19.128  26.337 -17.227  1.00 46.72           N  
ATOM    592  CA  SER A  85     -20.117  26.891 -18.135  1.00 46.38           C  
ATOM    593  C   SER A  85     -19.889  26.323 -19.527  1.00 46.01           C  
ATOM    594  O   SER A  85     -18.750  26.078 -19.910  1.00 45.88           O  
ATOM    595  CB  SER A  85     -20.041  28.427 -18.163  1.00 46.41           C  
ATOM    596  OG  SER A  85     -18.840  28.868 -18.773  1.00 46.69           O  
ATOM    597  N   ALA A  86     -20.982  26.126 -20.262  1.00 45.52           N  
ATOM    598  CA  ALA A  86     -20.986  25.551 -21.607  1.00 45.36           C  
ATOM    599  C   ALA A  86     -20.036  26.241 -22.580  1.00 45.29           C  
ATOM    600  O   ALA A  86     -19.967  27.468 -22.637  1.00 45.03           O  
ATOM    601  CB  ALA A  86     -22.420  25.563 -22.178  1.00 45.37           C  
ATOM    602  N   ASP A  87     -19.303  25.437 -23.340  1.00 45.36           N  
ATOM    603  CA  ASP A  87     -18.508  25.947 -24.446  1.00 45.64           C  
ATOM    604  C   ASP A  87     -19.491  26.490 -25.483  1.00 46.03           C  
ATOM    605  O   ASP A  87     -20.367  25.753 -25.934  1.00 45.88           O  
ATOM    606  CB  ASP A  87     -17.631  24.829 -25.021  1.00 45.46           C  
ATOM    607  CG  ASP A  87     -16.678  25.308 -26.109  1.00 46.09           C  
ATOM    608  OD1 ASP A  87     -16.827  26.428 -26.633  1.00 47.02           O  
ATOM    609  OD2 ASP A  87     -15.764  24.538 -26.462  1.00 47.86           O  
ATOM    610  N   PRO A  88     -19.381  27.792 -25.820  1.00 46.58           N  
ATOM    611  CA  PRO A  88     -20.258  28.442 -26.809  1.00 47.04           C  
ATOM    612  C   PRO A  88     -20.115  27.931 -28.253  1.00 47.72           C  
ATOM    613  O   PRO A  88     -20.979  28.206 -29.089  1.00 47.85           O  
ATOM    614  CB  PRO A  88     -19.832  29.911 -26.732  1.00 47.12           C  
ATOM    615  CG  PRO A  88     -18.437  29.883 -26.171  1.00 46.84           C  
ATOM    616  CD  PRO A  88     -18.433  28.752 -25.217  1.00 46.27           C  
ATOM    617  N   ASP A  89     -19.038  27.207 -28.541  1.00 48.19           N  
ATOM    618  CA  ASP A  89     -18.787  26.695 -29.882  1.00 48.57           C  
ATOM    619  C   ASP A  89     -19.001  25.197 -29.929  1.00 49.02           C  
ATOM    620  O   ASP A  89     -18.854  24.565 -30.981  1.00 49.30           O  
ATOM    621  CB  ASP A  89     -17.363  27.033 -30.317  1.00 48.53           C  
ATOM    622  CG  ASP A  89     -17.075  28.518 -30.252  1.00 49.41           C  
ATOM    623  OD1 ASP A  89     -17.816  29.298 -30.884  1.00 48.59           O  
ATOM    624  OD2 ASP A  89     -16.109  28.904 -29.558  1.00 50.75           O  
ATOM    625  N   ASP A  90     -19.352  24.617 -28.790  1.00 49.42           N  
ATOM    626  CA  ASP A  90     -19.547  23.184 -28.728  1.00 49.65           C  
ATOM    627  C   ASP A  90     -20.299  22.810 -27.462  1.00 49.65           C  
ATOM    628  O   ASP A  90     -19.689  22.542 -26.418  1.00 49.73           O  
ATOM    629  CB  ASP A  90     -18.195  22.477 -28.798  1.00 49.98           C  
ATOM    630  CG  ASP A  90     -18.311  21.057 -29.277  1.00 51.18           C  
ATOM    631  OD1 ASP A  90     -19.347  20.420 -28.989  1.00 52.80           O  
ATOM    632  OD2 ASP A  90     -17.359  20.568 -29.926  1.00 52.81           O  
ATOM    633  N   GLY A  91     -21.626  22.788 -27.572  1.00 49.22           N  
ATOM    634  CA  GLY A  91     -22.523  22.556 -26.452  1.00 49.35           C  
ATOM    635  C   GLY A  91     -22.376  21.241 -25.712  1.00 49.74           C  
ATOM    636  O   GLY A  91     -22.902  21.088 -24.617  1.00 49.87           O  
ATOM    637  N   ARG A  92     -21.672  20.282 -26.297  1.00 50.43           N  
ATOM    638  CA  ARG A  92     -21.312  19.072 -25.565  1.00 51.37           C  
ATOM    639  C   ARG A  92     -20.187  19.376 -24.576  1.00 51.24           C  
ATOM    640  O   ARG A  92     -19.893  18.568 -23.694  1.00 51.40           O  
ATOM    641  CB  ARG A  92     -20.868  17.977 -26.529  1.00 51.48           C  
ATOM    642  CG  ARG A  92     -20.952  16.568 -25.956  1.00 53.14           C  
ATOM    643  CD  ARG A  92     -20.549  15.496 -26.975  1.00 52.59           C  
ATOM    644  NE  ARG A  92     -19.108  15.278 -26.945  1.00 56.36           N  
ATOM    645  CZ  ARG A  92     -18.270  15.518 -27.951  1.00 57.36           C  
ATOM    646  NH1 ARG A  92     -18.717  15.976 -29.118  1.00 57.77           N  
ATOM    647  NH2 ARG A  92     -16.972  15.294 -27.783  1.00 57.21           N  
ATOM    648  N   ARG A  93     -19.580  20.554 -24.710  1.00 51.16           N  
ATOM    649  CA  ARG A  93     -18.356  20.875 -23.986  1.00 51.39           C  
ATOM    650  C   ARG A  93     -18.532  21.882 -22.847  1.00 50.67           C  
ATOM    651  O   ARG A  93     -19.367  22.781 -22.909  1.00 50.56           O  
ATOM    652  CB  ARG A  93     -17.300  21.366 -24.976  1.00 51.97           C  
ATOM    653  CG  ARG A  93     -15.856  21.185 -24.545  1.00 54.45           C  
ATOM    654  CD  ARG A  93     -14.921  21.391 -25.736  1.00 58.82           C  
ATOM    655  NE  ARG A  93     -13.514  21.310 -25.344  1.00 62.43           N  
ATOM    656  CZ  ARG A  93     -12.510  21.052 -26.180  1.00 63.28           C  
ATOM    657  NH1 ARG A  93     -12.746  20.840 -27.471  1.00 64.02           N  
ATOM    658  NH2 ARG A  93     -11.268  20.998 -25.719  1.00 64.50           N  
ATOM    659  N   LEU A  94     -17.723  21.697 -21.804  1.00 50.26           N  
ATOM    660  CA  LEU A  94     -17.646  22.601 -20.659  1.00 49.25           C  
ATOM    661  C   LEU A  94     -16.380  23.440 -20.682  1.00 48.49           C  
ATOM    662  O   LEU A  94     -15.333  23.004 -21.161  1.00 48.33           O  
ATOM    663  CB  LEU A  94     -17.703  21.812 -19.347  1.00 49.33           C  
ATOM    664  CG  LEU A  94     -19.022  21.694 -18.583  1.00 49.29           C  
ATOM    665  CD1 LEU A  94     -20.204  21.805 -19.517  1.00 50.25           C  
ATOM    666  CD2 LEU A  94     -19.051  20.377 -17.828  1.00 48.97           C  
ATOM    667  N   LEU A  95     -16.501  24.647 -20.145  1.00 47.59           N  
ATOM    668  CA  LEU A  95     -15.388  25.554 -19.947  1.00 46.61           C  
ATOM    669  C   LEU A  95     -15.231  25.761 -18.459  1.00 46.05           C  
ATOM    670  O   LEU A  95     -16.216  25.910 -17.750  1.00 45.81           O  
ATOM    671  CB  LEU A  95     -15.666  26.899 -20.628  1.00 46.67           C  
ATOM    672  CG  LEU A  95     -15.142  27.184 -22.044  1.00 46.93           C  
ATOM    673  CD1 LEU A  95     -15.109  25.955 -22.940  1.00 45.36           C  
ATOM    674  CD2 LEU A  95     -15.934  28.318 -22.693  1.00 45.93           C  
ATOM    675  N   VAL A  96     -13.988  25.754 -17.990  1.00 45.59           N  
ATOM    676  CA  VAL A  96     -13.685  26.012 -16.584  1.00 44.93           C  
ATOM    677  C   VAL A  96     -13.142  27.438 -16.456  1.00 44.63           C  
ATOM    678  O   VAL A  96     -12.412  27.926 -17.324  1.00 44.24           O  
ATOM    679  CB  VAL A  96     -12.692  24.968 -15.994  1.00 45.07           C  
ATOM    680  CG1 VAL A  96     -12.538  25.150 -14.497  1.00 45.12           C  
ATOM    681  CG2 VAL A  96     -13.172  23.565 -16.263  1.00 44.98           C  
ATOM    682  N   SER A  97     -13.522  28.105 -15.375  1.00 44.36           N  
ATOM    683  CA  SER A  97     -13.196  29.506 -15.180  1.00 44.47           C  
ATOM    684  C   SER A  97     -12.971  29.754 -13.710  1.00 43.99           C  
ATOM    685  O   SER A  97     -13.438  28.990 -12.872  1.00 43.74           O  
ATOM    686  CB  SER A  97     -14.366  30.366 -15.653  1.00 44.59           C  
ATOM    687  OG  SER A  97     -13.914  31.635 -16.063  1.00 46.29           O  
ATOM    688  N   LEU A  98     -12.265  30.828 -13.393  1.00 43.91           N  
ATOM    689  CA  LEU A  98     -12.140  31.264 -12.002  1.00 44.27           C  
ATOM    690  C   LEU A  98     -13.441  31.876 -11.495  1.00 44.45           C  
ATOM    691  O   LEU A  98     -14.035  32.735 -12.158  1.00 44.80           O  
ATOM    692  CB  LEU A  98     -10.997  32.276 -11.858  1.00 44.17           C  
ATOM    693  CG  LEU A  98      -9.705  31.914 -11.108  1.00 44.32           C  
ATOM    694  CD1 LEU A  98      -9.184  30.529 -11.413  1.00 43.40           C  
ATOM    695  CD2 LEU A  98      -8.643  32.959 -11.363  1.00 44.15           C  
ATOM    696  N   SER A  99     -13.891  31.409 -10.335  1.00 44.70           N  
ATOM    697  CA  SER A  99     -14.871  32.120  -9.506  1.00 44.81           C  
ATOM    698  C   SER A  99     -14.375  33.494  -9.087  1.00 44.90           C  
ATOM    699  O   SER A  99     -13.170  33.753  -9.141  1.00 44.98           O  
ATOM    700  CB  SER A  99     -15.093  31.342  -8.222  1.00 44.64           C  
ATOM    701  OG  SER A  99     -16.139  30.427  -8.413  1.00 47.29           O  
ATOM    702  N   PRO A 100     -15.301  34.378  -8.647  1.00 45.15           N  
ATOM    703  CA  PRO A 100     -14.906  35.567  -7.878  1.00 44.92           C  
ATOM    704  C   PRO A 100     -14.050  35.240  -6.642  1.00 44.72           C  
ATOM    705  O   PRO A 100     -13.051  35.924  -6.389  1.00 44.71           O  
ATOM    706  CB  PRO A 100     -16.253  36.178  -7.454  1.00 45.28           C  
ATOM    707  CG  PRO A 100     -17.227  35.706  -8.501  1.00 44.91           C  
ATOM    708  CD  PRO A 100     -16.761  34.331  -8.886  1.00 44.82           C  
ATOM    709  N   ALA A 101     -14.439  34.212  -5.887  1.00 44.45           N  
ATOM    710  CA  ALA A 101     -13.667  33.768  -4.721  1.00 44.46           C  
ATOM    711  C   ALA A 101     -12.327  33.135  -5.131  1.00 44.44           C  
ATOM    712  O   ALA A 101     -11.321  33.328  -4.464  1.00 45.08           O  
ATOM    713  CB  ALA A 101     -14.481  32.801  -3.875  1.00 44.28           C  
ATOM    714  N   GLY A 102     -12.331  32.399  -6.235  1.00 44.30           N  
ATOM    715  CA  GLY A 102     -11.120  31.866  -6.840  1.00 44.38           C  
ATOM    716  C   GLY A 102     -10.198  32.927  -7.395  1.00 44.32           C  
ATOM    717  O   GLY A 102      -8.986  32.746  -7.389  1.00 44.63           O  
ATOM    718  N   ARG A 103     -10.763  34.038  -7.868  1.00 44.08           N  
ATOM    719  CA  ARG A 103      -9.956  35.195  -8.265  1.00 44.10           C  
ATOM    720  C   ARG A 103      -9.347  35.918  -7.042  1.00 43.36           C  
ATOM    721  O   ARG A 103      -8.199  36.370  -7.072  1.00 42.90           O  
ATOM    722  CB  ARG A 103     -10.782  36.168  -9.114  1.00 44.47           C  
ATOM    723  CG  ARG A 103     -10.114  37.530  -9.355  1.00 47.39           C  
ATOM    724  CD  ARG A 103      -8.836  37.401 -10.199  1.00 52.20           C  
ATOM    725  NE  ARG A 103      -9.155  36.836 -11.514  1.00 56.09           N  
ATOM    726  CZ  ARG A 103      -8.284  36.625 -12.501  1.00 56.74           C  
ATOM    727  NH1 ARG A 103      -6.991  36.930 -12.357  1.00 55.03           N  
ATOM    728  NH2 ARG A 103      -8.727  36.106 -13.645  1.00 57.06           N  
ATOM    729  N   ALA A 104     -10.133  36.029  -5.974  1.00 42.38           N  
ATOM    730  CA  ALA A 104      -9.681  36.683  -4.756  1.00 41.26           C  
ATOM    731  C   ALA A 104      -8.575  35.848  -4.081  1.00 40.55           C  
ATOM    732  O   ALA A 104      -7.615  36.399  -3.537  1.00 39.24           O  
ATOM    733  CB  ALA A 104     -10.861  36.921  -3.814  1.00 41.11           C  
ATOM    734  N   GLU A 105      -8.725  34.521  -4.163  1.00 39.99           N  
ATOM    735  CA  GLU A 105      -7.750  33.539  -3.656  1.00 39.26           C  
ATOM    736  C   GLU A 105      -6.397  33.692  -4.343  1.00 38.70           C  
ATOM    737  O   GLU A 105      -5.356  33.693  -3.691  1.00 38.45           O  
ATOM    738  CB  GLU A 105      -8.271  32.141  -3.935  1.00 39.39           C  
ATOM    739  CG  GLU A 105      -7.393  31.018  -3.454  1.00 40.60           C  
ATOM    740  CD  GLU A 105      -7.776  30.535  -2.073  1.00 42.68           C  
ATOM    741  OE1 GLU A 105      -8.601  31.188  -1.402  1.00 42.91           O  
ATOM    742  OE2 GLU A 105      -7.247  29.492  -1.656  1.00 44.65           O  
ATOM    743  N   LEU A 106      -6.436  33.800  -5.669  1.00 38.07           N  
ATOM    744  CA  LEU A 106      -5.254  34.046  -6.487  1.00 37.32           C  
ATOM    745  C   LEU A 106      -4.512  35.297  -6.024  1.00 37.18           C  
ATOM    746  O   LEU A 106      -3.335  35.222  -5.687  1.00 36.75           O  
ATOM    747  CB  LEU A 106      -5.646  34.145  -7.974  1.00 37.03           C  
ATOM    748  CG  LEU A 106      -4.565  34.319  -9.050  1.00 37.39           C  
ATOM    749  CD1 LEU A 106      -3.460  33.249  -8.897  1.00 35.97           C  
ATOM    750  CD2 LEU A 106      -5.177  34.282 -10.480  1.00 36.93           C  
ATOM    751  N   GLU A 107      -5.208  36.438  -5.983  1.00 37.11           N  
ATOM    752  CA  GLU A 107      -4.611  37.708  -5.523  1.00 37.33           C  
ATOM    753  C   GLU A 107      -4.069  37.648  -4.091  1.00 35.84           C  
ATOM    754  O   GLU A 107      -3.025  38.225  -3.794  1.00 36.03           O  
ATOM    755  CB  GLU A 107      -5.600  38.875  -5.660  1.00 37.72           C  
ATOM    756  CG  GLU A 107      -6.310  38.953  -7.026  1.00 42.33           C  
ATOM    757  CD  GLU A 107      -5.361  38.887  -8.225  1.00 48.65           C  
ATOM    758  OE1 GLU A 107      -4.323  39.603  -8.238  1.00 51.64           O  
ATOM    759  OE2 GLU A 107      -5.667  38.122  -9.169  1.00 51.08           O  
ATOM    760  N   ALA A 108      -4.792  36.958  -3.212  1.00 34.40           N  
ATOM    761  CA  ALA A 108      -4.414  36.824  -1.801  1.00 33.19           C  
ATOM    762  C   ALA A 108      -3.209  35.895  -1.649  1.00 32.97           C  
ATOM    763  O   ALA A 108      -2.504  35.961  -0.649  1.00 32.43           O  
ATOM    764  CB  ALA A 108      -5.588  36.321  -0.971  1.00 32.31           C  
ATOM    765  N   GLY A 109      -2.972  35.050  -2.665  1.00 32.53           N  
ATOM    766  CA  GLY A 109      -1.876  34.094  -2.660  1.00 31.92           C  
ATOM    767  C   GLY A 109      -0.595  34.541  -3.341  1.00 32.09           C  
ATOM    768  O   GLY A 109       0.433  33.910  -3.160  1.00 32.33           O  
ATOM    769  N   LEU A 110      -0.644  35.624  -4.115  1.00 32.09           N  
ATOM    770  CA  LEU A 110       0.516  36.058  -4.909  1.00 32.47           C  
ATOM    771  C   LEU A 110       1.782  36.302  -4.075  1.00 32.09           C  
ATOM    772  O   LEU A 110       2.833  35.758  -4.393  1.00 32.46           O  
ATOM    773  CB  LEU A 110       0.207  37.300  -5.785  1.00 32.28           C  
ATOM    774  CG  LEU A 110      -0.775  37.264  -6.976  1.00 34.38           C  
ATOM    775  CD1 LEU A 110      -0.699  38.574  -7.731  1.00 33.12           C  
ATOM    776  CD2 LEU A 110      -0.535  36.108  -7.954  1.00 35.22           C  
ATOM    777  N   ALA A 111       1.691  37.127  -3.038  1.00 31.69           N  
ATOM    778  CA  ALA A 111       2.862  37.437  -2.191  1.00 31.83           C  
ATOM    779  C   ALA A 111       3.583  36.179  -1.681  1.00 31.31           C  
ATOM    780  O   ALA A 111       4.792  36.059  -1.795  1.00 31.58           O  
ATOM    781  CB  ALA A 111       2.450  38.325  -1.008  1.00 31.06           C  
ATOM    782  N   ALA A 112       2.822  35.261  -1.102  1.00 31.34           N  
ATOM    783  CA  ALA A 112       3.344  33.986  -0.607  1.00 31.33           C  
ATOM    784  C   ALA A 112       3.953  33.105  -1.730  1.00 31.11           C  
ATOM    785  O   ALA A 112       5.051  32.569  -1.571  1.00 31.35           O  
ATOM    786  CB  ALA A 112       2.246  33.233   0.155  1.00 31.15           C  
ATOM    787  N   ALA A 113       3.264  32.966  -2.858  1.00 30.56           N  
ATOM    788  CA  ALA A 113       3.816  32.201  -3.984  1.00 30.97           C  
ATOM    789  C   ALA A 113       5.132  32.805  -4.492  1.00 31.35           C  
ATOM    790  O   ALA A 113       6.065  32.073  -4.840  1.00 31.09           O  
ATOM    791  CB  ALA A 113       2.830  32.082  -5.097  1.00 30.07           C  
ATOM    792  N   ARG A 114       5.217  34.136  -4.497  1.00 32.02           N  
ATOM    793  CA  ARG A 114       6.463  34.819  -4.836  1.00 33.54           C  
ATOM    794  C   ARG A 114       7.548  34.511  -3.820  1.00 33.24           C  
ATOM    795  O   ARG A 114       8.702  34.318  -4.187  1.00 33.95           O  
ATOM    796  CB  ARG A 114       6.260  36.335  -4.928  1.00 34.20           C  
ATOM    797  CG  ARG A 114       5.485  36.744  -6.152  1.00 38.04           C  
ATOM    798  CD  ARG A 114       5.599  38.233  -6.412  1.00 45.36           C  
ATOM    799  NE  ARG A 114       4.794  38.591  -7.577  1.00 50.01           N  
ATOM    800  CZ  ARG A 114       3.626  39.220  -7.508  1.00 52.84           C  
ATOM    801  NH1 ARG A 114       3.126  39.588  -6.321  1.00 53.01           N  
ATOM    802  NH2 ARG A 114       2.965  39.489  -8.627  1.00 53.42           N  
ATOM    803  N   GLU A 115       7.167  34.468  -2.546  1.00 33.13           N  
ATOM    804  CA  GLU A 115       8.097  34.201  -1.452  1.00 32.90           C  
ATOM    805  C   GLU A 115       8.579  32.751  -1.441  1.00 32.58           C  
ATOM    806  O   GLU A 115       9.768  32.497  -1.240  1.00 32.94           O  
ATOM    807  CB  GLU A 115       7.463  34.592  -0.096  1.00 33.01           C  
ATOM    808  CG  GLU A 115       8.253  34.158   1.135  1.00 33.30           C  
ATOM    809  CD  GLU A 115       9.685  34.726   1.199  1.00 35.49           C  
ATOM    810  OE1 GLU A 115      10.064  35.627   0.418  1.00 35.08           O  
ATOM    811  OE2 GLU A 115      10.453  34.263   2.054  1.00 36.65           O  
ATOM    812  N   ILE A 116       7.667  31.805  -1.638  1.00 32.16           N  
ATOM    813  CA  ILE A 116       8.050  30.395  -1.788  1.00 32.50           C  
ATOM    814  C   ILE A 116       9.093  30.224  -2.897  1.00 33.65           C  
ATOM    815  O   ILE A 116      10.094  29.540  -2.707  1.00 34.21           O  
ATOM    816  CB  ILE A 116       6.815  29.489  -2.070  1.00 32.13           C  
ATOM    817  CG1 ILE A 116       5.866  29.505  -0.875  1.00 29.28           C  
ATOM    818  CG2 ILE A 116       7.239  28.062  -2.447  1.00 30.04           C  
ATOM    819  CD1 ILE A 116       4.471  29.048  -1.202  1.00 23.16           C  
ATOM    820  N   ASN A 117       8.858  30.876  -4.037  1.00 34.91           N  
ATOM    821  CA  ASN A 117       9.749  30.837  -5.196  1.00 35.68           C  
ATOM    822  C   ASN A 117      11.097  31.471  -4.913  1.00 35.94           C  
ATOM    823  O   ASN A 117      12.120  30.959  -5.378  1.00 35.48           O  
ATOM    824  CB  ASN A 117       9.095  31.543  -6.385  1.00 36.05           C  
ATOM    825  CG  ASN A 117       9.916  31.424  -7.669  1.00 39.31           C  
ATOM    826  OD1 ASN A 117      10.668  32.339  -8.043  1.00 42.95           O  
ATOM    827  ND2 ASN A 117       9.784  30.289  -8.348  1.00 41.03           N  
ATOM    828  N   ARG A 118      11.108  32.594  -4.172  1.00 36.37           N  
ATOM    829  CA  ARG A 118      12.391  33.221  -3.814  1.00 36.97           C  
ATOM    830  C   ARG A 118      13.232  32.385  -2.839  1.00 36.06           C  
ATOM    831  O   ARG A 118      14.446  32.342  -2.971  1.00 35.75           O  
ATOM    832  CB  ARG A 118      12.282  34.710  -3.401  1.00 36.27           C  
ATOM    833  CG  ARG A 118      11.694  35.001  -2.065  1.00 39.65           C  
ATOM    834  CD  ARG A 118      12.234  36.323  -1.420  1.00 38.94           C  
ATOM    835  NE  ARG A 118      13.550  36.100  -0.824  1.00 42.26           N  
ATOM    836  CZ  ARG A 118      13.777  35.596   0.393  1.00 42.03           C  
ATOM    837  NH1 ARG A 118      12.782  35.276   1.216  1.00 42.00           N  
ATOM    838  NH2 ARG A 118      15.025  35.416   0.788  1.00 40.80           N  
ATOM    839  N   GLN A 119      12.573  31.717  -1.891  1.00 36.09           N  
ATOM    840  CA  GLN A 119      13.224  30.812  -0.932  1.00 36.04           C  
ATOM    841  C   GLN A 119      13.788  29.562  -1.614  1.00 35.86           C  
ATOM    842  O   GLN A 119      14.903  29.118  -1.289  1.00 36.09           O  
ATOM    843  CB  GLN A 119      12.229  30.368   0.137  1.00 35.69           C  
ATOM    844  CG  GLN A 119      11.863  31.424   1.149  1.00 36.80           C  
ATOM    845  CD  GLN A 119      10.839  30.939   2.182  1.00 37.69           C  
ATOM    846  OE1 GLN A 119      10.216  31.751   2.885  1.00 38.54           O  
ATOM    847  NE2 GLN A 119      10.657  29.614   2.277  1.00 38.33           N  
ATOM    848  N   ALA A 120      13.013  28.982  -2.537  1.00 35.05           N  
ATOM    849  CA  ALA A 120      13.473  27.855  -3.338  1.00 35.03           C  
ATOM    850  C   ALA A 120      14.821  28.161  -3.993  1.00 35.31           C  
ATOM    851  O   ALA A 120      15.719  27.308  -4.021  1.00 34.67           O  
ATOM    852  CB  ALA A 120      12.429  27.459  -4.399  1.00 34.11           C  
ATOM    853  N   LEU A 121      14.958  29.386  -4.499  1.00 35.70           N  
ATOM    854  CA  LEU A 121      16.147  29.772  -5.242  1.00 36.72           C  
ATOM    855  C   LEU A 121      17.208  30.442  -4.379  1.00 37.80           C  
ATOM    856  O   LEU A 121      18.322  30.668  -4.845  1.00 38.15           O  
ATOM    857  CB  LEU A 121      15.776  30.667  -6.431  1.00 36.55           C  
ATOM    858  CG  LEU A 121      14.894  30.044  -7.525  1.00 35.43           C  
ATOM    859  CD1 LEU A 121      14.472  31.103  -8.499  1.00 35.26           C  
ATOM    860  CD2 LEU A 121      15.608  28.941  -8.239  1.00 35.58           C  
ATOM    861  N   ALA A 122      16.877  30.721  -3.120  1.00 38.62           N  
ATOM    862  CA  ALA A 122      17.750  31.488  -2.227  1.00 40.18           C  
ATOM    863  C   ALA A 122      19.233  31.057  -2.154  1.00 40.87           C  
ATOM    864  O   ALA A 122      20.093  31.934  -2.067  1.00 41.50           O  
ATOM    865  CB  ALA A 122      17.143  31.582  -0.818  1.00 39.85           C  
ATOM    866  N   PRO A 123      19.537  29.729  -2.155  1.00 41.24           N  
ATOM    867  CA  PRO A 123      20.925  29.214  -2.149  1.00 41.42           C  
ATOM    868  C   PRO A 123      21.819  29.670  -3.321  1.00 42.09           C  
ATOM    869  O   PRO A 123      22.992  29.269  -3.401  1.00 42.07           O  
ATOM    870  CB  PRO A 123      20.725  27.694  -2.269  1.00 41.36           C  
ATOM    871  CG  PRO A 123      19.398  27.442  -1.703  1.00 41.18           C  
ATOM    872  CD  PRO A 123      18.567  28.616  -2.118  1.00 41.24           C  
ATOM    873  N   LEU A 124      21.261  30.488  -4.211  1.00 42.33           N  
ATOM    874  CA  LEU A 124      21.880  30.841  -5.488  1.00 42.27           C  
ATOM    875  C   LEU A 124      21.829  32.341  -5.690  1.00 42.77           C  
ATOM    876  O   LEU A 124      20.850  32.982  -5.327  1.00 42.23           O  
ATOM    877  CB  LEU A 124      21.103  30.182  -6.637  1.00 41.88           C  
ATOM    878  CG  LEU A 124      21.516  28.882  -7.326  1.00 41.76           C  
ATOM    879  CD1 LEU A 124      22.143  27.837  -6.415  1.00 40.30           C  
ATOM    880  CD2 LEU A 124      20.321  28.327  -8.044  1.00 41.24           C  
ATOM    881  N   SER A 125      22.869  32.895  -6.304  1.00 43.61           N  
ATOM    882  CA  SER A 125      22.891  34.323  -6.613  1.00 44.73           C  
ATOM    883  C   SER A 125      21.940  34.606  -7.773  1.00 45.38           C  
ATOM    884  O   SER A 125      21.643  33.706  -8.565  1.00 45.37           O  
ATOM    885  CB  SER A 125      24.313  34.778  -6.949  1.00 44.57           C  
ATOM    886  OG  SER A 125      24.847  34.012  -8.014  1.00 45.66           O  
ATOM    887  N   LEU A 126      21.467  35.846  -7.882  1.00 46.21           N  
ATOM    888  CA  LEU A 126      20.516  36.212  -8.940  1.00 47.45           C  
ATOM    889  C   LEU A 126      21.017  35.845 -10.340  1.00 48.18           C  
ATOM    890  O   LEU A 126      20.219  35.517 -11.225  1.00 48.45           O  
ATOM    891  CB  LEU A 126      20.152  37.701  -8.873  1.00 47.47           C  
ATOM    892  CG  LEU A 126      19.551  38.199  -7.548  1.00 48.21           C  
ATOM    893  CD1 LEU A 126      19.502  39.733  -7.513  1.00 47.36           C  
ATOM    894  CD2 LEU A 126      18.168  37.564  -7.247  1.00 47.24           C  
ATOM    895  N   GLN A 127      22.337  35.910 -10.528  1.00 48.89           N  
ATOM    896  CA  GLN A 127      22.988  35.474 -11.757  1.00 49.13           C  
ATOM    897  C   GLN A 127      22.816  33.961 -11.934  1.00 48.90           C  
ATOM    898  O   GLN A 127      22.377  33.503 -12.986  1.00 48.89           O  
ATOM    899  CB  GLN A 127      24.475  35.837 -11.731  1.00 49.62           C  
ATOM    900  CG  GLN A 127      24.792  37.349 -11.606  1.00 52.46           C  
ATOM    901  CD  GLN A 127      24.896  37.864 -10.160  1.00 55.29           C  
ATOM    902  OE1 GLN A 127      24.792  37.098  -9.193  1.00 57.27           O  
ATOM    903  NE2 GLN A 127      25.107  39.174 -10.014  1.00 54.93           N  
ATOM    904  N   GLU A 128      23.156  33.199 -10.892  1.00 48.52           N  
ATOM    905  CA  GLU A 128      23.070  31.741 -10.904  1.00 48.43           C  
ATOM    906  C   GLU A 128      21.645  31.227 -11.111  1.00 48.52           C  
ATOM    907  O   GLU A 128      21.442  30.208 -11.773  1.00 48.55           O  
ATOM    908  CB  GLU A 128      23.623  31.168  -9.603  1.00 48.51           C  
ATOM    909  CG  GLU A 128      25.131  31.272  -9.447  1.00 48.74           C  
ATOM    910  CD  GLU A 128      25.612  30.667  -8.151  1.00 48.35           C  
ATOM    911  OE1 GLU A 128      25.089  31.041  -7.081  1.00 49.20           O  
ATOM    912  OE2 GLU A 128      26.510  29.812  -8.197  1.00 47.69           O  
ATOM    913  N   GLN A 129      20.677  31.936 -10.531  1.00 48.53           N  
ATOM    914  CA  GLN A 129      19.256  31.643 -10.687  1.00 48.60           C  
ATOM    915  C   GLN A 129      18.852  31.673 -12.150  1.00 49.17           C  
ATOM    916  O   GLN A 129      18.156  30.771 -12.620  1.00 49.36           O  
ATOM    917  CB  GLN A 129      18.414  32.631  -9.865  1.00 48.60           C  
ATOM    918  CG  GLN A 129      18.663  32.508  -8.367  1.00 48.09           C  
ATOM    919  CD  GLN A 129      17.719  33.323  -7.510  1.00 47.60           C  
ATOM    920  OE1 GLN A 129      16.719  33.852  -7.986  1.00 46.58           O  
ATOM    921  NE2 GLN A 129      18.028  33.414  -6.226  1.00 45.72           N  
ATOM    922  N   GLU A 130      19.318  32.697 -12.860  1.00 49.84           N  
ATOM    923  CA  GLU A 130      19.077  32.871 -14.296  1.00 50.91           C  
ATOM    924  C   GLU A 130      19.696  31.740 -15.143  1.00 50.75           C  
ATOM    925  O   GLU A 130      19.052  31.206 -16.055  1.00 50.78           O  
ATOM    926  CB  GLU A 130      19.593  34.248 -14.742  1.00 51.20           C  
ATOM    927  CG  GLU A 130      18.990  34.782 -16.050  1.00 54.71           C  
ATOM    928  CD  GLU A 130      19.794  34.411 -17.305  1.00 59.24           C  
ATOM    929  OE1 GLU A 130      21.017  34.134 -17.195  1.00 60.79           O  
ATOM    930  OE2 GLU A 130      19.202  34.412 -18.416  1.00 61.35           O  
ATOM    931  N   THR A 131      20.942  31.382 -14.836  1.00 50.67           N  
ATOM    932  CA  THR A 131      21.614  30.258 -15.475  1.00 50.68           C  
ATOM    933  C   THR A 131      20.835  28.967 -15.235  1.00 50.90           C  
ATOM    934  O   THR A 131      20.593  28.203 -16.162  1.00 51.27           O  
ATOM    935  CB  THR A 131      23.044  30.074 -14.929  1.00 50.67           C  
ATOM    936  OG1 THR A 131      23.776  31.291 -15.087  1.00 50.37           O  
ATOM    937  CG2 THR A 131      23.768  28.939 -15.651  1.00 49.80           C  
ATOM    938  N   LEU A 132      20.445  28.730 -13.987  1.00 51.17           N  
ATOM    939  CA  LEU A 132      19.733  27.507 -13.627  1.00 51.48           C  
ATOM    940  C   LEU A 132      18.378  27.416 -14.322  1.00 51.62           C  
ATOM    941  O   LEU A 132      18.061  26.394 -14.904  1.00 51.67           O  
ATOM    942  CB  LEU A 132      19.568  27.376 -12.106  1.00 51.15           C  
ATOM    943  CG  LEU A 132      18.681  26.206 -11.677  1.00 50.88           C  
ATOM    944  CD1 LEU A 132      19.444  24.873 -11.653  1.00 49.98           C  
ATOM    945  CD2 LEU A 132      18.053  26.497 -10.345  1.00 50.40           C  
ATOM    946  N   ARG A 133      17.596  28.488 -14.266  1.00 52.01           N  
ATOM    947  CA  ARG A 133      16.288  28.524 -14.917  1.00 52.63           C  
ATOM    948  C   ARG A 133      16.398  28.203 -16.419  1.00 52.10           C  
ATOM    949  O   ARG A 133      15.572  27.450 -16.949  1.00 52.48           O  
ATOM    950  CB  ARG A 133      15.616  29.888 -14.694  1.00 52.77           C  
ATOM    951  CG  ARG A 133      14.088  29.837 -14.518  1.00 54.09           C  
ATOM    952  CD  ARG A 133      13.464  31.222 -14.220  1.00 54.17           C  
ATOM    953  NE  ARG A 133      14.291  32.036 -13.320  1.00 57.22           N  
ATOM    954  CZ  ARG A 133      13.953  32.390 -12.080  1.00 58.33           C  
ATOM    955  NH1 ARG A 133      12.784  32.021 -11.552  1.00 58.21           N  
ATOM    956  NH2 ARG A 133      14.791  33.128 -11.364  1.00 58.63           N  
ATOM    957  N   GLY A 134      17.422  28.761 -17.078  1.00 51.18           N  
ATOM    958  CA  GLY A 134      17.690  28.527 -18.500  1.00 50.01           C  
ATOM    959  C   GLY A 134      18.082  27.094 -18.829  1.00 49.56           C  
ATOM    960  O   GLY A 134      17.525  26.478 -19.743  1.00 49.39           O  
ATOM    961  N   LEU A 135      19.052  26.571 -18.084  1.00 48.82           N  
ATOM    962  CA  LEU A 135      19.472  25.173 -18.183  1.00 47.77           C  
ATOM    963  C   LEU A 135      18.324  24.197 -17.879  1.00 47.31           C  
ATOM    964  O   LEU A 135      18.101  23.243 -18.619  1.00 47.41           O  
ATOM    965  CB  LEU A 135      20.664  24.926 -17.248  1.00 47.70           C  
ATOM    966  CG  LEU A 135      22.113  25.048 -17.750  1.00 47.83           C  
ATOM    967  CD1 LEU A 135      22.323  26.117 -18.830  1.00 48.57           C  
ATOM    968  CD2 LEU A 135      23.073  25.254 -16.583  1.00 47.27           C  
ATOM    969  N   LEU A 136      17.586  24.455 -16.805  1.00 46.71           N  
ATOM    970  CA  LEU A 136      16.473  23.602 -16.389  1.00 46.44           C  
ATOM    971  C   LEU A 136      15.255  23.699 -17.336  1.00 46.51           C  
ATOM    972  O   LEU A 136      14.517  22.727 -17.505  1.00 46.81           O  
ATOM    973  CB  LEU A 136      16.090  23.923 -14.936  1.00 46.20           C  
ATOM    974  CG  LEU A 136      15.493  22.860 -14.001  1.00 47.30           C  
ATOM    975  CD1 LEU A 136      16.365  21.600 -13.871  1.00 46.87           C  
ATOM    976  CD2 LEU A 136      15.202  23.446 -12.627  1.00 46.24           C  
ATOM    977  N   ALA A 137      15.056  24.853 -17.973  1.00 46.29           N  
ATOM    978  CA  ALA A 137      13.976  25.018 -18.965  1.00 45.86           C  
ATOM    979  C   ALA A 137      14.138  24.067 -20.145  1.00 45.81           C  
ATOM    980  O   ALA A 137      13.151  23.621 -20.753  1.00 45.98           O  
ATOM    981  CB  ALA A 137      13.922  26.451 -19.463  1.00 46.07           C  
ATOM    982  N   ARG A 138      15.398  23.775 -20.464  1.00 45.16           N  
ATOM    983  CA  ARG A 138      15.770  22.885 -21.543  1.00 44.35           C  
ATOM    984  C   ARG A 138      15.600  21.407 -21.168  1.00 43.81           C  
ATOM    985  O   ARG A 138      15.774  20.531 -22.021  1.00 43.73           O  
ATOM    986  CB  ARG A 138      17.221  23.173 -21.960  1.00 44.64           C  
ATOM    987  CG  ARG A 138      17.417  24.546 -22.657  1.00 45.16           C  
ATOM    988  CD  ARG A 138      18.879  25.022 -22.637  1.00 44.50           C  
ATOM    989  NE  ARG A 138      19.758  24.123 -23.379  1.00 46.29           N  
ATOM    990  CZ  ARG A 138      21.082  24.240 -23.443  1.00 46.37           C  
ATOM    991  NH1 ARG A 138      21.694  25.238 -22.814  1.00 45.35           N  
ATOM    992  NH2 ARG A 138      21.793  23.361 -24.147  1.00 45.79           N  
ATOM    993  N   LEU A 139      15.270  21.135 -19.899  1.00 42.90           N  
ATOM    994  CA  LEU A 139      15.073  19.762 -19.411  1.00 42.27           C  
ATOM    995  C   LEU A 139      13.613  19.456 -19.078  1.00 42.33           C  
ATOM    996  O   LEU A 139      13.287  18.385 -18.561  1.00 41.98           O  
ATOM    997  CB  LEU A 139      15.950  19.484 -18.183  1.00 42.10           C  
ATOM    998  CG  LEU A 139      17.477  19.490 -18.334  1.00 41.31           C  
ATOM    999  CD1 LEU A 139      18.077  18.710 -17.176  1.00 39.22           C  
ATOM   1000  CD2 LEU A 139      17.931  18.910 -19.677  1.00 38.44           C  
ATOM   1001  N   ILE A 140      12.748  20.417 -19.377  1.00 42.40           N  
ATOM   1002  CA  ILE A 140      11.312  20.322 -19.151  1.00 42.28           C  
ATOM   1003  C   ILE A 140      10.678  19.302 -20.088  1.00 42.17           C  
ATOM   1004  O   ILE A 140       9.680  18.659 -19.776  1.00 42.14           O  
ATOM   1005  CB  ILE A 140      10.684  21.753 -19.227  1.00 42.59           C  
ATOM   1006  CG1 ILE A 140      10.294  22.218 -17.834  1.00 43.11           C  
ATOM   1007  CG2 ILE A 140       9.512  21.873 -20.213  1.00 42.85           C  
ATOM   1008  CD1 ILE A 140      11.420  22.131 -16.857  1.00 44.77           C  
ATOM   1009  OXT ILE A 140      11.177  19.076 -21.179  1.00 41.97           O  
TER    1010      ILE A 140                                                      
END
MOLECULE T0459.pdb
ATOM      1  N   SER     1     -10.415  21.770  17.737  1.00 36.73           N  
ATOM      2  CA  SER     1      -9.300  22.637  18.208  1.00 36.27           C  
ATOM      3  C   SER     1      -8.557  23.266  17.037  1.00 35.28           C  
ATOM      4  O   SER     1      -8.379  22.640  15.973  1.00 35.90           O  
ATOM      5  CB  SER     1      -8.351  21.893  19.152  1.00 36.84           C  
ATOM      6  OG  SER     1      -7.375  22.791  19.686  1.00 38.33           O  
ATOM      7  N   ASN     2      -8.124  24.504  17.269  1.00 33.96           N  
ATOM      8  CA  ASN     2      -7.662  25.408  16.215  0.50 33.06           C  
ATOM     10  C   ASN     2      -6.217  25.852  16.369  1.00 32.42           C  
ATOM     11  O   ASN     2      -5.703  25.916  17.477  1.00 32.77           O  
ATOM     12  CB  ASN     2      -8.522  26.677  16.208  0.50 33.17           C  
ATOM     14  CG  ASN     2      -9.904  26.457  15.620  0.50 33.12           C  
ATOM     16  OD1 ASN     2     -10.596  27.422  15.296  0.50 35.02           O  
ATOM     18  ND2 ASN     2     -10.312  25.197  15.473  0.50 31.87           N  
ATOM     20  N   ALA     3      -5.592  26.188  15.250  1.00 31.43           N  
ATOM     21  CA  ALA     3      -4.314  26.862  15.272  1.00 31.00           C  
ATOM     22  C   ALA     3      -4.652  28.337  15.273  1.00 30.63           C  
ATOM     23  O   ALA     3      -5.545  28.766  14.533  1.00 31.26           O  
ATOM     24  CB  ALA     3      -3.484  26.499  14.033  1.00 30.25           C  
ATOM     25  N   MET     4      -3.954  29.122  16.099  1.00 30.89           N  
ATOM     26  CA  MET     4      -4.173  30.557  16.181  1.00 30.57           C  
ATOM     27  C   MET     4      -2.912  31.223  15.687  1.00 29.89           C  
ATOM     28  O   MET     4      -1.831  31.018  16.275  1.00 29.61           O  
ATOM     29  CB  MET     4      -4.453  30.972  17.642  1.00 31.45           C  
ATOM     30  CG  MET     4      -5.831  30.585  18.117  1.00 34.71           C  
ATOM     31  SD  MET     4      -7.230  31.555  17.154  0.55 40.32          SE  
ATOM     32  CE  MET     4      -7.248  33.228  18.136  1.00 40.24           C  
ATOM     33  N   LEU     5      -3.022  31.969  14.595  1.00 29.52           N  
ATOM     34  CA  LEU     5      -1.845  32.551  13.938  1.00 30.45           C  
ATOM     35  C   LEU     5      -1.815  34.086  14.040  1.00 31.10           C  
ATOM     36  O   LEU     5      -2.754  34.760  13.649  1.00 32.83           O  
ATOM     37  CB  LEU     5      -1.743  32.099  12.465  1.00 29.59           C  
ATOM     38  CG  LEU     5      -2.214  30.669  12.242  1.00 30.64           C  
ATOM     39  CD1 LEU     5      -2.429  30.421  10.765  1.00 30.79           C  
ATOM     40  CD2 LEU     5      -1.193  29.717  12.859  1.00 27.96           C  
ATOM     41  N   ARG     6      -0.726  34.617  14.576  1.00 31.38           N  
ATOM     42  CA  ARG     6      -0.573  36.055  14.754  1.00 31.04           C  
ATOM     43  C   ARG     6      -0.465  36.732  13.387  1.00 30.97           C  
ATOM     44  O   ARG     6       0.359  36.338  12.565  1.00 32.05           O  
ATOM     45  CB  ARG     6       0.690  36.338  15.573  1.00 29.54           C  
ATOM     46  CG  ARG     6       1.027  37.817  15.740  1.00 33.13           C  
ATOM     47  CD  ARG     6      -0.136  38.565  16.275  1.00 33.20           C  
ATOM     48  NE  ARG     6      -0.526  38.164  17.630  1.00 33.00           N  
ATOM     49  CZ  ARG     6      -1.502  38.758  18.316  1.00 32.70           C  
ATOM     50  NH1 ARG     6      -1.812  38.328  19.523  1.00 30.79           N  
ATOM     51  NH2 ARG     6      -2.166  39.785  17.789  1.00 30.14           N  
ATOM     52  N   TYR     7      -1.294  37.754  13.164  1.00 30.67           N  
ATOM     53  CA  TYR     7      -1.218  38.537  11.932  1.00 30.64           C  
ATOM     54  C   TYR     7      -1.426  40.007  12.314  1.00 29.31           C  
ATOM     55  O   TYR     7      -2.557  40.492  12.356  1.00 29.58           O  
ATOM     56  CB  TYR     7      -2.276  38.071  10.921  1.00 30.37           C  
ATOM     57  CG  TYR     7      -2.256  38.775   9.583  1.00 31.58           C  
ATOM     58  CD1 TYR     7      -1.073  39.265   9.039  1.00 33.67           C  
ATOM     59  CD2 TYR     7      -3.426  38.915   8.837  1.00 31.83           C  
ATOM     60  CE1 TYR     7      -1.063  39.895   7.783  1.00 33.79           C  
ATOM     61  CE2 TYR     7      -3.420  39.529   7.601  1.00 33.39           C  
ATOM     62  CZ  TYR     7      -2.248  40.022   7.077  1.00 33.60           C  
ATOM     63  OH  TYR     7      -2.258  40.659   5.856  1.00 32.89           O  
ATOM     64  N   GLY     8      -0.335  40.706  12.641  1.00 29.52           N  
ATOM     65  CA  GLY     8      -0.478  42.089  13.106  1.00 29.08           C  
ATOM     66  C   GLY     8      -1.219  42.101  14.434  1.00 29.21           C  
ATOM     67  O   GLY     8      -0.928  41.314  15.325  1.00 29.78           O  
ATOM     68  N   ASP     9      -2.211  42.967  14.560  1.00 27.53           N  
ATOM     69  CA  ASP     9      -2.978  43.109  15.794  1.00 29.01           C  
ATOM     70  C   ASP     9      -4.059  42.029  15.926  1.00 28.64           C  
ATOM     71  O   ASP     9      -4.835  42.060  16.876  1.00 30.34           O  
ATOM     72  CB  ASP     9      -3.594  44.499  15.809  1.00 27.53           C  
ATOM     73  CG  ASP     9      -4.168  44.903  17.184  1.00 28.31           C  
ATOM     74  OD1 ASP     9      -3.576  44.591  18.255  1.00 27.20           O  
ATOM     75  OD2 ASP     9      -5.212  45.572  17.173  1.00 31.32           O  
ATOM     76  N   THR    10      -4.131  41.110  14.963  1.00 28.31           N  
ATOM     77  CA  THR    10      -5.215  40.131  14.895  1.00 29.02           C  
ATOM     78  C   THR    10      -4.652  38.709  15.031  1.00 27.83           C  
ATOM     79  O   THR    10      -3.436  38.485  14.855  1.00 27.98           O  
ATOM     80  CB  THR    10      -6.007  40.207  13.547  1.00 28.56           C  
ATOM     81  OG1 THR    10      -5.235  39.584  12.498  1.00 32.75           O  
ATOM     82  CG2 THR    10      -6.377  41.661  13.190  1.00 31.29           C  
ATOM     83  N   GLU    11      -5.522  37.757  15.346  1.00 26.75           N  
ATOM     84  CA  GLU    11      -5.136  36.351  15.200  1.00 28.15           C  
ATOM     85  C   GLU    11      -6.073  35.652  14.215  1.00 27.58           C  
ATOM     86  O   GLU    11      -7.293  35.848  14.254  1.00 27.69           O  
ATOM     87  CB  GLU    11      -5.099  35.638  16.554  1.00 27.56           C  
ATOM     88  CG  GLU    11      -4.013  36.141  17.491  1.00 30.04           C  
ATOM     89  CD  GLU    11      -4.107  35.489  18.861  1.00 34.00           C  
ATOM     90  OE1 GLU    11      -5.031  35.867  19.629  1.00 35.94           O  
ATOM     91  OE2 GLU    11      -3.266  34.612  19.176  1.00 33.57           O  
ATOM     92  N   ILE    12      -5.483  34.849  13.343  1.00 28.49           N  
ATOM     93  CA  ILE    12      -6.224  34.097  12.330  1.00 28.91           C  
ATOM     94  C   ILE    12      -6.443  32.708  12.938  1.00 28.83           C  
ATOM     95  O   ILE    12      -5.486  32.098  13.439  1.00 29.05           O  
ATOM     96  CB  ILE    12      -5.396  33.983  11.020  1.00 29.30           C  
ATOM     97  CG1 ILE    12      -5.011  35.389  10.494  1.00 31.03           C  
ATOM     98  CG2 ILE    12      -6.140  33.091   9.963  1.00 29.96           C  
ATOM     99  CD1 ILE    12      -3.927  35.376   9.367  1.00 31.07           C  
ATOM    100  N   CYS    13      -7.692  32.251  12.882  1.00 27.28           N  
ATOM    101  CA  CYS    13      -8.078  30.950  13.372  0.50 27.26           C  
ATOM    103  C   CYS    13      -8.209  29.961  12.206  1.00 28.00           C  
ATOM    104  O   CYS    13      -8.972  30.213  11.261  1.00 27.25           O  
ATOM    105  CB  CYS    13      -9.414  31.073  14.111  0.50 27.24           C  
ATOM    107  SG  CYS    13      -9.844  29.604  15.022  0.50 25.64           S  
ATOM    109  N   ILE    14      -7.452  28.860  12.267  1.00 27.87           N  
ATOM    110  CA  ILE    14      -7.549  27.773  11.287  1.00 28.04           C  
ATOM    111  C   ILE    14      -7.750  26.429  11.994  1.00 28.25           C  
ATOM    112  O   ILE    14      -6.969  26.035  12.867  1.00 28.02           O  
ATOM    113  CB  ILE    14      -6.265  27.649  10.389  1.00 27.07           C  
ATOM    114  CG1 ILE    14      -5.966  28.980   9.657  1.00 28.97           C  
ATOM    115  CG2 ILE    14      -6.350  26.422   9.419  1.00 27.42           C  
ATOM    116  CD1 ILE    14      -6.819  29.234   8.425  1.00 28.09           C  
ATOM    117  N   ASP    15      -8.777  25.714  11.588  1.00 28.87           N  
ATOM    118  CA  ASP    15      -8.945  24.371  12.055  1.00 30.05           C  
ATOM    119  C   ASP    15      -8.263  23.415  11.067  1.00 31.28           C  
ATOM    120  O   ASP    15      -8.756  23.220   9.966  1.00 31.16           O  
ATOM    121  CB  ASP    15     -10.434  24.082  12.189  1.00 30.09           C  
ATOM    122  CG  ASP    15     -10.708  22.784  12.894  1.00 30.26           C  
ATOM    123  OD1 ASP    15      -9.748  22.031  13.153  1.00 32.36           O  
ATOM    124  OD2 ASP    15     -11.892  22.515  13.186  1.00 30.84           O  
ATOM    125  N   PRO    16      -7.133  22.799  11.470  1.00 32.52           N  
ATOM    126  CA  PRO    16      -6.366  22.006  10.524  1.00 33.72           C  
ATOM    127  C   PRO    16      -7.133  20.771  10.042  1.00 34.14           C  
ATOM    128  O   PRO    16      -6.857  20.285   8.952  1.00 35.37           O  
ATOM    129  CB  PRO    16      -5.117  21.598  11.324  1.00 33.18           C  
ATOM    130  CG  PRO    16      -5.070  22.521  12.481  1.00 34.54           C  
ATOM    131  CD  PRO    16      -6.514  22.776  12.806  1.00 33.05           C  
ATOM    132  N   SER    17      -8.095  20.287  10.833  1.00 35.19           N  
ATOM    133  CA  SER    17      -8.889  19.114  10.454  1.00 35.46           C  
ATOM    134  C   SER    17     -10.103  19.438   9.566  1.00 35.43           C  
ATOM    135  O   SER    17     -10.689  18.533   8.970  1.00 35.51           O  
ATOM    136  CB  SER    17      -9.323  18.324  11.694  1.00 35.69           C  
ATOM    137  OG  SER    17     -10.303  19.026  12.444  1.00 35.63           O  
ATOM    138  N   GLU    18     -10.492  20.715   9.519  1.00 35.21           N  
ATOM    139  CA  GLU    18     -11.559  21.189   8.631  0.50 35.18           C  
ATOM    141  C   GLU    18     -11.283  22.617   8.158  1.00 35.05           C  
ATOM    142  O   GLU    18     -11.663  23.598   8.809  1.00 35.41           O  
ATOM    143  CB  GLU    18     -12.934  21.076   9.299  0.50 35.13           C  
ATOM    145  CG  GLU    18     -13.636  19.744   9.037  0.50 35.62           C  
ATOM    147  CD  GLU    18     -15.015  19.656   9.662  0.50 35.62           C  
ATOM    149  OE1 GLU    18     -15.498  18.516   9.856  0.50 37.29           O  
ATOM    151  OE2 GLU    18     -15.618  20.715   9.959  0.50 36.60           O  
ATOM    153  N   SER    19     -10.578  22.722   7.042  1.00 34.61           N  
ATOM    154  CA  SER    19     -10.251  23.990   6.427  1.00 33.27           C  
ATOM    155  C   SER    19      -9.994  23.714   4.972  1.00 33.78           C  
ATOM    156  O   SER    19      -9.529  22.624   4.618  1.00 34.23           O  
ATOM    157  CB  SER    19      -8.959  24.579   7.013  1.00 33.81           C  
ATOM    158  OG  SER    19      -8.575  25.719   6.249  1.00 31.21           O  
ATOM    159  N   VAL    20     -10.272  24.705   4.130  1.00 32.42           N  
ATOM    160  CA  VAL    20      -9.977  24.617   2.696  1.00 32.16           C  
ATOM    161  C   VAL    20      -8.453  24.665   2.466  1.00 30.52           C  
ATOM    162  O   VAL    20      -7.976  24.456   1.359  1.00 29.18           O  
ATOM    163  CB  VAL    20     -10.799  25.651   1.899  1.00 32.40           C  
ATOM    164  CG1 VAL    20     -10.376  27.082   2.223  1.00 33.30           C  
ATOM    165  CG2 VAL    20     -10.736  25.355   0.412  1.00 34.67           C  
ATOM    166  N   LEU    21      -7.706  24.923   3.541  1.00 29.65           N  
ATOM    167  CA  LEU    21      -6.253  24.853   3.500  1.00 28.31           C  
ATOM    168  C   LEU    21      -5.823  23.451   3.035  1.00 28.00           C  
ATOM    169  O   LEU    21      -4.853  23.340   2.297  1.00 27.24           O  
ATOM    170  CB  LEU    21      -5.656  25.160   4.885  1.00 29.04           C  
ATOM    171  CG  LEU    21      -4.133  25.098   5.000  1.00 29.06           C  
ATOM    172  CD1 LEU    21      -3.468  26.066   4.034  1.00 30.76           C  
ATOM    173  CD2 LEU    21      -3.743  25.385   6.456  1.00 28.18           C  
ATOM    174  N   HIS    22      -6.556  22.406   3.447  1.00 28.90           N  
ATOM    175  CA  HIS    22      -6.261  21.027   3.059  1.00 30.07           C  
ATOM    176  C   HIS    22      -6.226  20.912   1.547  1.00 29.78           C  
ATOM    177  O   HIS    22      -5.251  20.412   0.960  1.00 29.81           O  
ATOM    178  CB  HIS    22      -7.317  20.060   3.652  1.00 29.57           C  
ATOM    179  CG  HIS    22      -7.121  18.620   3.283  1.00 32.86           C  
ATOM    180  ND1 HIS    22      -6.237  17.801   3.948  1.00 36.16           N  
ATOM    181  CD2 HIS    22      -7.733  17.840   2.360  1.00 34.12           C  
ATOM    182  CE1 HIS    22      -6.294  16.579   3.437  1.00 36.42           C  
ATOM    183  NE2 HIS    22      -7.190  16.577   2.466  1.00 36.45           N  
ATOM    184  N   LEU    23      -7.285  21.393   0.913  1.00 30.25           N  
ATOM    185  CA  LEU    23      -7.368  21.335  -0.557  1.00 30.37           C  
ATOM    186  C   LEU    23      -6.252  22.166  -1.182  1.00 32.08           C  
ATOM    187  O   LEU    23      -5.524  21.680  -2.070  1.00 32.10           O  
ATOM    188  CB  LEU    23      -8.720  21.857  -1.021  1.00 30.65           C  
ATOM    189  CG  LEU    23      -8.897  22.039  -2.536  1.00 30.24           C  
ATOM    190  CD1 LEU    23      -8.535  20.766  -3.354  1.00 33.22           C  
ATOM    191  CD2 LEU    23     -10.331  22.521  -2.824  1.00 30.94           C  
ATOM    192  N   LEU    24      -6.104  23.391  -0.684  1.00 31.13           N  
ATOM    193  CA  LEU    24      -5.102  24.306  -1.222  0.50 32.96           C  
ATOM    195  C   LEU    24      -3.688  23.739  -1.206  1.00 32.52           C  
ATOM    196  O   LEU    24      -2.888  24.059  -2.084  1.00 33.32           O  
ATOM    197  CB  LEU    24      -5.166  25.659  -0.514  0.50 32.98           C  
ATOM    199  CG  LEU    24      -5.817  26.795  -1.310  0.50 35.89           C  
ATOM    201  CD1 LEU    24      -4.761  27.454  -2.172  0.50 35.58           C  
ATOM    203  CD2 LEU    24      -7.035  26.378  -2.160  0.50 34.56           C  
ATOM    205  N   GLY    25      -3.403  22.889  -0.235  1.00 32.78           N  
ATOM    206  CA  GLY    25      -2.078  22.271  -0.122  1.00 32.77           C  
ATOM    207  C   GLY    25      -1.807  21.076  -1.029  1.00 32.09           C  
ATOM    208  O   GLY    25      -0.650  20.775  -1.316  1.00 32.25           O  
ATOM    209  N   LYS    26      -2.856  20.387  -1.470  1.00 31.77           N  
ATOM    210  CA  LYS    26      -2.693  19.222  -2.330  1.00 31.54           C  
ATOM    211  C   LYS    26      -1.923  19.602  -3.599  1.00 30.09           C  
ATOM    212  O   LYS    26      -2.096  20.721  -4.130  1.00 30.18           O  
ATOM    213  CB  LYS    26      -4.059  18.649  -2.710  1.00 32.58           C  
ATOM    214  CG  LYS    26      -4.788  18.002  -1.562  1.00 32.14           C  
ATOM    215  CD  LYS    26      -6.073  17.350  -2.043  1.00 34.07           C  
ATOM    216  CE  LYS    26      -7.020  17.150  -0.861  1.00 33.53           C  
ATOM    217  NZ  LYS    26      -7.663  15.793  -0.867  1.00 32.24           N  
ATOM    218  N   LYS    27      -1.108  18.658  -4.079  1.00 29.46           N  
ATOM    219  CA  LYS    27      -0.247  18.883  -5.225  1.00 28.20           C  
ATOM    220  C   LYS    27      -1.054  19.512  -6.367  1.00 28.47           C  
ATOM    221  O   LYS    27      -2.137  19.019  -6.699  1.00 27.82           O  
ATOM    222  CB  LYS    27       0.416  17.575  -5.684  1.00 28.29           C  
ATOM    223  CG  LYS    27       1.558  17.841  -6.624  1.00 27.35           C  
ATOM    224  CD  LYS    27       2.366  16.571  -6.953  1.00 28.02           C  
ATOM    225  CE  LYS    27       3.506  16.937  -7.892  1.00 32.06           C  
ATOM    226  NZ  LYS    27       4.144  18.235  -7.451  1.00 36.20           N  
ATOM    227  N   TYR    28      -0.517  20.598  -6.946  1.00 28.32           N  
ATOM    228  CA  TYR    28      -1.099  21.296  -8.107  1.00 28.81           C  
ATOM    229  C   TYR    28      -2.205  22.310  -7.836  1.00 28.80           C  
ATOM    230  O   TYR    28      -2.531  23.094  -8.711  1.00 29.16           O  
ATOM    231  CB  TYR    28      -1.559  20.314  -9.194  1.00 29.50           C  
ATOM    232  CG  TYR    28      -0.450  19.424  -9.733  1.00 28.58           C  
ATOM    233  CD1 TYR    28      -0.473  18.049  -9.500  1.00 28.14           C  
ATOM    234  CD2 TYR    28       0.598  19.954 -10.506  1.00 29.00           C  
ATOM    235  CE1 TYR    28       0.524  17.238  -9.999  1.00 26.00           C  
ATOM    236  CE2 TYR    28       1.591  19.138 -11.004  1.00 29.83           C  
ATOM    237  CZ  TYR    28       1.546  17.785 -10.750  1.00 28.24           C  
ATOM    238  OH  TYR    28       2.518  16.953 -11.254  1.00 32.25           O  
ATOM    239  N   THR    29      -2.806  22.288  -6.652  1.00 29.70           N  
ATOM    240  CA  THR    29      -4.030  23.111  -6.461  1.00 28.91           C  
ATOM    241  C   THR    29      -3.724  24.580  -6.628  1.00 28.79           C  
ATOM    242  O   THR    29      -4.461  25.297  -7.314  1.00 29.77           O  
ATOM    243  CB  THR    29      -4.723  22.829  -5.115  1.00 28.38           C  
ATOM    244  OG1 THR    29      -5.036  21.427  -5.024  1.00 29.94           O  
ATOM    245  CG2 THR    29      -6.051  23.661  -4.985  1.00 29.10           C  
ATOM    246  N   MET    30      -2.620  25.026  -6.029  1.00 28.10           N  
ATOM    247  CA  MET    30      -2.255  26.452  -6.125  1.00 29.83           C  
ATOM    248  C   MET    30      -1.906  26.795  -7.568  1.00 30.09           C  
ATOM    249  O   MET    30      -2.248  27.882  -8.076  1.00 30.64           O  
ATOM    250  CB  MET    30      -1.124  26.810  -5.159  1.00 28.47           C  
ATOM    251  CG  MET    30      -1.574  26.776  -3.713  1.00 31.09           C  
ATOM    252  SD  MET    30      -0.134  27.257  -2.471  0.70 33.89          SE  
ATOM    253  CE  MET    30       0.430  25.413  -2.065  1.00 34.51           C  
ATOM    254  N   LEU    31      -1.256  25.865  -8.251  1.00 29.49           N  
ATOM    255  CA  LEU    31      -0.925  26.090  -9.670  1.00 29.99           C  
ATOM    256  C   LEU    31      -2.194  26.139 -10.532  1.00 30.67           C  
ATOM    257  O   LEU    31      -2.239  26.936 -11.482  1.00 29.61           O  
ATOM    258  CB  LEU    31       0.010  25.028 -10.176  1.00 28.61           C  
ATOM    259  CG  LEU    31       1.444  25.100  -9.620  1.00 27.57           C  
ATOM    260  CD1 LEU    31       2.213  23.844 -10.095  1.00 29.53           C  
ATOM    261  CD2 LEU    31       2.111  26.434  -9.955  1.00 32.58           C  
ATOM    262  N   ILE    32      -3.185  25.287 -10.245  1.00 29.61           N  
ATOM    263  CA  ILE    32      -4.465  25.322 -11.009  1.00 29.63           C  
ATOM    264  C   ILE    32      -5.139  26.703 -10.810  1.00 29.77           C  
ATOM    265  O   ILE    32      -5.554  27.360 -11.786  1.00 31.22           O  
ATOM    266  CB  ILE    32      -5.391  24.184 -10.600  1.00 30.11           C  
ATOM    267  CG1 ILE    32      -4.787  22.835 -11.077  1.00 28.44           C  
ATOM    268  CG2 ILE    32      -6.790  24.419 -11.191  1.00 28.91           C  
ATOM    269  CD1 ILE    32      -5.362  21.530 -10.391  1.00 31.16           C  
ATOM    270  N   ILE    33      -5.281  27.127  -9.558  1.00 29.65           N  
ATOM    271  CA  ILE    33      -5.825  28.471  -9.275  1.00 29.78           C  
ATOM    272  C   ILE    33      -5.058  29.559 -10.007  1.00 30.83           C  
ATOM    273  O   ILE    33      -5.651  30.456 -10.577  1.00 31.62           O  
ATOM    274  CB  ILE    33      -5.892  28.755  -7.747  1.00 29.54           C  
ATOM    275  CG1 ILE    33      -6.877  27.749  -7.103  1.00 30.49           C  
ATOM    276  CG2 ILE    33      -6.181  30.256  -7.430  1.00 28.42           C  
ATOM    277  CD1 ILE    33      -6.852  27.715  -5.549  1.00 31.56           C  
ATOM    278  N   SER    34      -3.729  29.467  -9.981  1.00 30.02           N  
ATOM    279  CA  SER    34      -2.897  30.477 -10.652  1.00 29.45           C  
ATOM    280  C   SER    34      -3.117  30.504 -12.175  1.00 28.34           C  
ATOM    281  O   SER    34      -3.298  31.591 -12.793  1.00 29.92           O  
ATOM    282  CB  SER    34      -1.442  30.180 -10.331  1.00 29.54           C  
ATOM    283  OG  SER    34      -1.235  30.181  -8.916  1.00 33.14           O  
ATOM    284  N   VAL    35      -3.111  29.343 -12.809  1.00 29.48           N  
ATOM    285  CA  VAL    35      -3.217  29.353 -14.278  0.50 29.47           C  
ATOM    287  C   VAL    35      -4.628  29.763 -14.714  1.00 29.83           C  
ATOM    288  O   VAL    35      -4.791  30.347 -15.768  1.00 29.45           O  
ATOM    289  CB  VAL    35      -2.722  28.043 -14.974  0.50 29.52           C  
ATOM    291  CG1 VAL    35      -1.229  27.826 -14.719  0.50 29.61           C  
ATOM    293  CG2 VAL    35      -3.564  26.808 -14.566  0.50 29.25           C  
ATOM    295  N   LEU    36      -5.645  29.463 -13.891  1.00 29.61           N  
ATOM    296  CA  LEU    36      -7.026  29.830 -14.265  1.00 31.83           C  
ATOM    297  C   LEU    36      -7.212  31.343 -14.373  1.00 32.62           C  
ATOM    298  O   LEU    36      -8.154  31.860 -15.026  1.00 33.33           O  
ATOM    299  CB  LEU    36      -8.044  29.180 -13.312  1.00 31.76           C  
ATOM    300  CG  LEU    36      -8.439  27.744 -13.631  1.00 34.33           C  
ATOM    301  CD1 LEU    36      -9.255  27.121 -12.524  1.00 33.48           C  
ATOM    302  CD2 LEU    36      -9.178  27.642 -14.990  1.00 33.15           C  
ATOM    303  N   GLY    37      -6.299  32.068 -13.741  1.00 32.67           N  
ATOM    304  CA  GLY    37      -6.279  33.536 -13.828  1.00 34.43           C  
ATOM    305  C   GLY    37      -5.287  34.122 -14.824  1.00 34.47           C  
ATOM    306  O   GLY    37      -5.086  35.329 -14.829  1.00 34.99           O  
ATOM    307  N   ASN    38      -4.641  33.283 -15.638  1.00 35.53           N  
ATOM    308  CA  ASN    38      -3.778  33.728 -16.753  1.00 35.74           C  
ATOM    309  C   ASN    38      -4.611  34.108 -17.985  1.00 37.71           C  
ATOM    310  O   ASN    38      -5.821  33.904 -17.997  1.00 38.33           O  
ATOM    311  CB  ASN    38      -2.888  32.596 -17.240  1.00 35.54           C  
ATOM    312  CG  ASN    38      -1.743  32.260 -16.305  1.00 32.45           C  
ATOM    313  OD1 ASN    38      -1.418  32.983 -15.360  1.00 31.30           O  
ATOM    314  ND2 ASN    38      -1.086  31.167 -16.616  1.00 29.32           N  
ATOM    315  N   GLY    39      -3.966  34.615 -19.038  1.00 39.07           N  
ATOM    316  CA  GLY    39      -4.673  34.919 -20.316  1.00 40.35           C  
ATOM    317  C   GLY    39      -5.968  35.731 -20.235  1.00 40.83           C  
ATOM    318  O   GLY    39      -6.278  36.332 -19.194  1.00 40.09           O  
ATOM    319  N   SER    40      -6.740  35.732 -21.329  1.00 41.52           N  
ATOM    320  CA  SER    40      -7.865  36.680 -21.492  1.00 42.35           C  
ATOM    321  C   SER    40      -9.234  36.028 -21.721  1.00 42.42           C  
ATOM    322  O   SER    40     -10.228  36.715 -22.004  1.00 43.03           O  
ATOM    323  CB  SER    40      -7.598  37.601 -22.677  1.00 42.11           C  
ATOM    324  OG  SER    40      -6.233  37.572 -23.040  1.00 45.27           O  
ATOM    325  N   THR    41      -9.281  34.709 -21.618  1.00 41.48           N  
ATOM    326  CA  THR    41     -10.417  33.957 -22.134  1.00 41.13           C  
ATOM    327  C   THR    41     -10.581  32.795 -21.206  1.00 39.96           C  
ATOM    328  O   THR    41      -9.594  32.339 -20.624  1.00 40.02           O  
ATOM    329  CB  THR    41     -10.133  33.399 -23.575  1.00 41.46           C  
ATOM    330  OG1 THR    41      -8.956  32.575 -23.555  1.00 43.48           O  
ATOM    331  CG2 THR    41      -9.929  34.522 -24.578  1.00 41.84           C  
ATOM    332  N   ARG    42     -11.815  32.308 -21.068  1.00 38.48           N  
ATOM    333  CA  ARG    42     -12.038  31.048 -20.363  1.00 36.84           C  
ATOM    334  C   ARG    42     -11.213  29.948 -21.033  1.00 35.70           C  
ATOM    335  O   ARG    42     -11.159  29.866 -22.259  1.00 35.70           O  
ATOM    336  CB  ARG    42     -13.520  30.666 -20.399  1.00 37.38           C  
ATOM    337  CG  ARG    42     -14.437  31.647 -19.684  1.00 37.62           C  
ATOM    338  CD  ARG    42     -15.883  31.164 -19.697  1.00 36.40           C  
ATOM    339  NE  ARG    42     -16.009  29.965 -18.858  1.00 36.40           N  
ATOM    340  CZ  ARG    42     -16.427  29.976 -17.597  1.00 35.20           C  
ATOM    341  NH1 ARG    42     -16.782  31.144 -17.033  1.00 34.57           N  
ATOM    342  NH2 ARG    42     -16.491  28.833 -16.902  1.00 36.13           N  
ATOM    343  N   GLN    43     -10.641  29.067 -20.218  1.00 34.69           N  
ATOM    344  CA  GLN    43      -9.776  27.977 -20.710  1.00 33.10           C  
ATOM    345  C   GLN    43     -10.503  26.657 -20.692  1.00 32.14           C  
ATOM    346  O   GLN    43     -11.269  26.403 -19.771  1.00 31.59           O  
ATOM    347  CB  GLN    43      -8.558  27.878 -19.802  1.00 33.74           C  
ATOM    348  CG  GLN    43      -7.930  29.264 -19.605  1.00 37.32           C  
ATOM    349  CD  GLN    43      -6.791  29.275 -18.585  1.00 43.97           C  
ATOM    350  OE1 GLN    43      -6.081  28.282 -18.413  1.00 50.03           O  
ATOM    351  NE2 GLN    43      -6.602  30.405 -17.932  1.00 44.66           N  
ATOM    352  N   ASN    44     -10.218  25.808 -21.680  1.00 28.58           N  
ATOM    353  CA  ASN    44     -10.733  24.442 -21.672  1.00 30.12           C  
ATOM    354  C   ASN    44      -9.770  23.560 -20.902  1.00 29.00           C  
ATOM    355  O   ASN    44      -8.722  24.046 -20.428  1.00 29.15           O  
ATOM    356  CB  ASN    44     -11.008  23.943 -23.097  1.00 28.73           C  
ATOM    357  CG  ASN    44      -9.755  23.877 -23.979  1.00 31.42           C  
ATOM    358  OD1 ASN    44      -8.635  23.648 -23.517  1.00 29.93           O  
ATOM    359  ND2 ASN    44      -9.952  24.097 -25.267  1.00 32.12           N  
ATOM    360  N   PHE    45     -10.112  22.277 -20.766  1.00 29.73           N  
ATOM    361  CA  PHE    45      -9.364  21.377 -19.899  1.00 30.13           C  
ATOM    362  C   PHE    45      -7.960  21.157 -20.412  1.00 30.35           C  
ATOM    363  O   PHE    45      -6.999  21.168 -19.616  1.00 29.85           O  
ATOM    364  CB  PHE    45     -10.114  20.083 -19.809  1.00 29.47           C  
ATOM    365  CG  PHE    45      -9.574  19.123 -18.815  1.00 29.78           C  
ATOM    366  CD1 PHE    45     -10.087  19.075 -17.518  1.00 30.76           C  
ATOM    367  CD2 PHE    45      -8.607  18.178 -19.209  1.00 30.09           C  
ATOM    368  CE1 PHE    45      -9.611  18.123 -16.595  1.00 30.36           C  
ATOM    369  CE2 PHE    45      -8.137  17.209 -18.309  1.00 30.04           C  
ATOM    370  CZ  PHE    45      -8.638  17.197 -16.999  1.00 30.03           C  
ATOM    371  N   ASN    46      -7.834  21.028 -21.730  1.00 30.11           N  
ATOM    372  CA  ASN    46      -6.501  20.863 -22.338  0.50 30.41           C  
ATOM    374  C   ASN    46      -5.610  22.071 -22.137  1.00 30.53           C  
ATOM    375  O   ASN    46      -4.413  21.919 -21.905  1.00 31.41           O  
ATOM    376  CB  ASN    46      -6.559  20.545 -23.836  0.50 30.92           C  
ATOM    378  CG  ASN    46      -5.186  20.274 -24.410  0.50 31.12           C  
ATOM    380  OD1 ASN    46      -4.574  19.255 -24.104  0.50 32.62           O  
ATOM    382  ND2 ASN    46      -4.692  21.178 -25.256  0.50 32.99           N  
ATOM    384  N   ASP    47      -6.194  23.271 -22.225  1.00 30.93           N  
ATOM    385  CA  ASP    47      -5.454  24.548 -22.028  1.00 32.46           C  
ATOM    386  C   ASP    47      -4.799  24.554 -20.632  1.00 31.87           C  
ATOM    387  O   ASP    47      -3.628  24.926 -20.456  1.00 30.64           O  
ATOM    388  CB  ASP    47      -6.390  25.776 -22.042  1.00 33.84           C  
ATOM    389  CG  ASP    47      -6.939  26.136 -23.421  1.00 36.73           C  
ATOM    390  OD1 ASP    47      -6.247  25.869 -24.457  1.00 37.68           O  
ATOM    391  OD2 ASP    47      -8.069  26.741 -23.444  1.00 37.94           O  
ATOM    392  N   ILE    48      -5.610  24.187 -19.646  1.00 30.43           N  
ATOM    393  CA  ILE    48      -5.194  24.155 -18.240  1.00 30.48           C  
ATOM    394  C   ILE    48      -4.104  23.108 -18.043  1.00 30.36           C  
ATOM    395  O   ILE    48      -3.036  23.404 -17.506  1.00 29.97           O  
ATOM    396  CB  ILE    48      -6.371  23.864 -17.297  1.00 30.17           C  
ATOM    397  CG1 ILE    48      -7.419  24.969 -17.401  1.00 30.92           C  
ATOM    398  CG2 ILE    48      -5.905  23.796 -15.860  1.00 28.80           C  
ATOM    399  CD1 ILE    48      -8.842  24.500 -16.885  1.00 31.00           C  
ATOM    400  N   ARG    49      -4.369  21.883 -18.500  1.00 29.39           N  
ATOM    401  CA  ARG    49      -3.420  20.778 -18.350  1.00 30.94           C  
ATOM    402  C   ARG    49      -2.065  21.091 -19.006  1.00 30.35           C  
ATOM    403  O   ARG    49      -1.009  20.856 -18.406  1.00 30.44           O  
ATOM    404  CB  ARG    49      -4.045  19.488 -18.920  1.00 30.61           C  
ATOM    405  CG  ARG    49      -3.149  18.233 -18.873  1.00 31.60           C  
ATOM    406  CD  ARG    49      -3.826  17.004 -19.546  1.00 34.32           C  
ATOM    407  NE  ARG    49      -4.109  17.268 -20.958  1.00 39.66           N  
ATOM    408  CZ  ARG    49      -5.158  16.807 -21.645  1.00 43.59           C  
ATOM    409  NH1 ARG    49      -5.287  17.135 -22.920  1.00 45.11           N  
ATOM    410  NH2 ARG    49      -6.084  16.029 -21.078  1.00 45.51           N  
ATOM    411  N   SER    50      -2.101  21.680 -20.210  1.00 30.07           N  
ATOM    412  CA  SER    50      -0.892  22.038 -20.951  1.00 31.54           C  
ATOM    413  C   SER    50      -0.062  23.098 -20.259  1.00 31.04           C  
ATOM    414  O   SER    50       1.149  23.188 -20.479  1.00 30.98           O  
ATOM    415  CB  SER    50      -1.277  22.565 -22.323  1.00 31.85           C  
ATOM    416  OG  SER    50      -1.782  21.515 -23.117  1.00 35.55           O  
ATOM    417  N   SER    51      -0.726  23.903 -19.430  1.00 30.50           N  
ATOM    418  CA  SER    51      -0.096  25.011 -18.723  0.50 30.66           C  
ATOM    420  C   SER    51       0.581  24.579 -17.419  1.00 30.93           C  
ATOM    421  O   SER    51       1.285  25.365 -16.798  1.00 31.22           O  
ATOM    422  CB  SER    51      -1.136  26.084 -18.412  0.50 30.43           C  
ATOM    424  OG  SER    51      -1.691  26.608 -19.599  0.50 30.15           O  
ATOM    426  N   ILE    52       0.358  23.332 -16.992  1.00 30.63           N  
ATOM    427  CA  ILE    52       0.962  22.825 -15.761  1.00 30.93           C  
ATOM    428  C   ILE    52       1.750  21.562 -16.111  1.00 31.45           C  
ATOM    429  O   ILE    52       1.195  20.460 -16.071  1.00 30.76           O  
ATOM    430  CB  ILE    52      -0.103  22.540 -14.635  1.00 30.84           C  
ATOM    431  CG1 ILE    52      -0.951  23.787 -14.375  1.00 31.83           C  
ATOM    432  CG2 ILE    52       0.588  22.082 -13.347  1.00 33.13           C  
ATOM    433  CD1 ILE    52      -2.186  23.546 -13.496  1.00 30.67           C  
ATOM    434  N   PRO    53       3.082  21.708 -16.248  0.50 32.17           N  
ATOM    436  CA  PRO    53       3.995  20.623 -16.611  0.50 32.18           C  
ATOM    438  C   PRO    53       3.709  19.347 -15.822  0.50 32.28           C  
ATOM    440  O   PRO    53       3.717  19.382 -14.589  0.50 32.32           O  
ATOM    442  CB  PRO    53       5.360  21.173 -16.185  0.50 32.32           C  
ATOM    444  CG  PRO    53       5.235  22.622 -16.320  0.50 32.43           C  
ATOM    446  CD  PRO    53       3.811  22.965 -15.984  0.50 31.62           C  
ATOM    448  N   GLY    54       3.447  18.225 -16.496  1.00 32.85           N  
ATOM    449  CA  GLY    54       3.374  17.000 -15.702  1.00 32.55           C  
ATOM    450  C   GLY    54       2.099  16.623 -14.957  1.00 31.92           C  
ATOM    451  O   GLY    54       2.011  15.492 -14.456  1.00 32.11           O  
ATOM    452  N   ILE    55       1.118  17.529 -14.849  1.00 30.84           N  
ATOM    453  CA  ILE    55      -0.154  17.165 -14.215  1.00 30.41           C  
ATOM    454  C   ILE    55      -0.915  16.120 -15.068  1.00 29.49           C  
ATOM    455  O   ILE    55      -0.989  16.260 -16.283  1.00 30.15           O  
ATOM    456  CB  ILE    55      -1.063  18.423 -13.944  1.00 29.10           C  
ATOM    457  CG1 ILE    55      -2.135  18.085 -12.899  1.00 29.13           C  
ATOM    458  CG2 ILE    55      -1.667  18.984 -15.247  1.00 29.74           C  
ATOM    459  CD1 ILE    55      -2.960  19.283 -12.328  1.00 31.94           C  
ATOM    460  N   SER    56      -1.463  15.079 -14.438  1.00 29.28           N  
ATOM    461  CA  SER    56      -2.278  14.092 -15.168  1.00 29.08           C  
ATOM    462  C   SER    56      -3.714  14.586 -15.333  1.00 28.45           C  
ATOM    463  O   SER    56      -4.179  15.450 -14.576  1.00 29.02           O  
ATOM    464  CB  SER    56      -2.299  12.746 -14.442  1.00 28.31           C  
ATOM    465  OG  SER    56      -2.957  12.908 -13.195  1.00 29.25           O  
ATOM    466  N   SER    57      -4.406  14.056 -16.344  1.00 28.29           N  
ATOM    467  CA  SER    57      -5.828  14.379 -16.512  1.00 29.38           C  
ATOM    468  C   SER    57      -6.598  13.995 -15.255  1.00 29.47           C  
ATOM    469  O   SER    57      -7.478  14.724 -14.829  1.00 30.03           O  
ATOM    470  CB  SER    57      -6.435  13.657 -17.706  1.00 30.29           C  
ATOM    471  OG  SER    57      -5.870  14.138 -18.902  1.00 32.01           O  
ATOM    472  N   THR    58      -6.284  12.829 -14.689  1.00 29.45           N  
ATOM    473  CA  THR    58      -6.990  12.360 -13.493  1.00 29.58           C  
ATOM    474  C   THR    58      -6.852  13.352 -12.330  1.00 29.16           C  
ATOM    475  O   THR    58      -7.844  13.700 -11.705  1.00 28.38           O  
ATOM    476  CB  THR    58      -6.582  10.923 -13.070  1.00 30.87           C  
ATOM    477  OG1 THR    58      -7.006   9.978 -14.073  1.00 30.95           O  
ATOM    478  CG2 THR    58      -7.222  10.541 -11.705  1.00 31.28           C  
ATOM    479  N   ILE    59      -5.627  13.765 -12.025  1.00 27.97           N  
ATOM    480  CA  ILE    59      -5.407  14.700 -10.912  1.00 29.61           C  
ATOM    481  C   ILE    59      -6.061  16.042 -11.228  1.00 29.82           C  
ATOM    482  O   ILE    59      -6.692  16.670 -10.357  1.00 29.80           O  
ATOM    483  CB  ILE    59      -3.881  14.856 -10.573  1.00 29.39           C  
ATOM    484  CG1 ILE    59      -3.316  13.496 -10.114  1.00 32.81           C  
ATOM    485  CG2 ILE    59      -3.632  16.061  -9.578  1.00 30.71           C  
ATOM    486  CD1 ILE    59      -3.982  12.929  -8.899  1.00 36.38           C  
ATOM    487  N   LEU    60      -5.922  16.507 -12.470  1.00 29.61           N  
ATOM    488  CA  LEU    60      -6.524  17.797 -12.820  1.00 28.72           C  
ATOM    489  C   LEU    60      -8.036  17.760 -12.640  1.00 29.13           C  
ATOM    490  O   LEU    60      -8.622  18.704 -12.099  1.00 29.42           O  
ATOM    491  CB  LEU    60      -6.157  18.260 -14.223  1.00 29.24           C  
ATOM    492  CG  LEU    60      -6.748  19.605 -14.712  1.00 28.18           C  
ATOM    493  CD1 LEU    60      -6.409  20.769 -13.803  1.00 29.10           C  
ATOM    494  CD2 LEU    60      -6.285  19.900 -16.141  1.00 29.94           C  
ATOM    495  N   SER    61      -8.653  16.682 -13.083  1.00 28.67           N  
ATOM    496  CA  SER    61     -10.114  16.544 -12.999  1.00 27.98           C  
ATOM    497  C   SER    61     -10.550  16.492 -11.516  1.00 28.84           C  
ATOM    498  O   SER    61     -11.545  17.126 -11.124  1.00 30.15           O  
ATOM    499  CB  SER    61     -10.545  15.269 -13.742  1.00 28.77           C  
ATOM    500  OG  SER    61     -11.943  15.111 -13.618  1.00 30.82           O  
ATOM    501  N   ARG    62      -9.804  15.751 -10.700  1.00 28.63           N  
ATOM    502  CA  ARG    62     -10.132  15.579  -9.274  0.50 29.99           C  
ATOM    504  C   ARG    62     -10.003  16.912  -8.545  1.00 29.34           C  
ATOM    505  O   ARG    62     -10.857  17.266  -7.723  1.00 29.15           O  
ATOM    506  CB  ARG    62      -9.247  14.513  -8.608  0.50 29.81           C  
ATOM    508  CG  ARG    62      -9.668  14.178  -7.172  0.50 31.40           C  
ATOM    510  CD  ARG    62      -8.791  13.120  -6.495  0.50 31.62           C  
ATOM    512  NE  ARG    62      -8.467  13.515  -5.124  0.50 36.53           N  
ATOM    514  CZ  ARG    62      -7.951  12.730  -4.183  0.50 36.11           C  
ATOM    516  NH1 ARG    62      -7.698  11.442  -4.416  0.50 37.63           N  
ATOM    518  NH2 ARG    62      -7.692  13.248  -2.987  0.50 37.15           N  
ATOM    520  N   ARG    63      -8.941  17.663  -8.858  1.00 28.62           N  
ATOM    521  CA  ARG    63      -8.761  18.974  -8.210  1.00 29.17           C  
ATOM    522  C   ARG    63      -9.802  20.015  -8.647  1.00 28.84           C  
ATOM    523  O   ARG    63     -10.327  20.781  -7.819  1.00 28.65           O  
ATOM    524  CB  ARG    63      -7.359  19.560  -8.460  1.00 29.44           C  
ATOM    525  CG  ARG    63      -6.226  18.768  -7.890  1.00 30.90           C  
ATOM    526  CD  ARG    63      -6.146  18.743  -6.379  1.00 33.16           C  
ATOM    527  NE  ARG    63      -4.832  18.204  -6.097  1.00 37.27           N  
ATOM    528  CZ  ARG    63      -4.595  16.895  -5.971  1.00 37.04           C  
ATOM    529  NH1 ARG    63      -5.614  16.023  -5.998  1.00 37.29           N  
ATOM    530  NH2 ARG    63      -3.363  16.461  -5.783  1.00 36.96           N  
ATOM    531  N   ILE    64     -10.151  19.980  -9.933  1.00 29.26           N  
ATOM    532  CA  ILE    64     -11.184  20.856 -10.463  1.00 30.51           C  
ATOM    533  C   ILE    64     -12.504  20.549  -9.741  1.00 30.34           C  
ATOM    534  O   ILE    64     -13.196  21.480  -9.345  1.00 30.98           O  
ATOM    535  CB  ILE    64     -11.290  20.731 -12.003  1.00 30.62           C  
ATOM    536  CG1 ILE    64     -10.127  21.548 -12.614  1.00 30.31           C  
ATOM    537  CG2 ILE    64     -12.675  21.243 -12.495  1.00 31.48           C  
ATOM    538  CD1 ILE    64     -10.156  21.630 -14.161  1.00 32.83           C  
ATOM    539  N   LYS    65     -12.838  19.279  -9.553  1.00 30.75           N  
ATOM    540  CA  LYS    65     -14.099  18.954  -8.873  1.00 30.94           C  
ATOM    541  C   LYS    65     -14.073  19.525  -7.445  1.00 30.64           C  
ATOM    542  O   LYS    65     -15.081  20.079  -6.977  1.00 30.81           O  
ATOM    543  CB  LYS    65     -14.299  17.457  -8.818  1.00 31.13           C  
ATOM    544  CG  LYS    65     -15.503  17.061  -8.007  1.00 33.76           C  
ATOM    545  CD  LYS    65     -15.587  15.568  -7.851  1.00 38.55           C  
ATOM    546  CE  LYS    65     -16.586  15.242  -6.746  1.00 40.18           C  
ATOM    547  NZ  LYS    65     -17.892  15.885  -7.064  1.00 43.76           N  
ATOM    548  N   ASP    66     -12.931  19.398  -6.765  1.00 29.42           N  
ATOM    549  CA  ASP    66     -12.878  19.802  -5.360  1.00 29.50           C  
ATOM    550  C   ASP    66     -12.978  21.320  -5.356  1.00 28.62           C  
ATOM    551  O   ASP    66     -13.574  21.903  -4.442  1.00 28.98           O  
ATOM    552  CB  ASP    66     -11.568  19.384  -4.683  1.00 30.07           C  
ATOM    553  CG  ASP    66     -11.473  17.900  -4.419  1.00 34.15           C  
ATOM    554  OD1 ASP    66     -12.523  17.216  -4.358  1.00 36.32           O  
ATOM    555  OD2 ASP    66     -10.306  17.461  -4.241  1.00 37.95           O  
ATOM    556  N   LEU    67     -12.352  21.941  -6.358  1.00 28.40           N  
ATOM    557  CA  LEU    67     -12.398  23.406  -6.450  1.00 26.03           C  
ATOM    558  C   LEU    67     -13.796  23.953  -6.748  1.00 27.98           C  
ATOM    559  O   LEU    67     -14.183  25.012  -6.231  1.00 28.27           O  
ATOM    560  CB  LEU    67     -11.369  23.956  -7.460  1.00 27.42           C  
ATOM    561  CG  LEU    67      -9.912  23.918  -7.004  1.00 26.45           C  
ATOM    562  CD1 LEU    67      -8.964  24.037  -8.262  1.00 26.39           C  
ATOM    563  CD2 LEU    67      -9.529  24.911  -5.930  1.00 28.59           C  
ATOM    564  N   ILE    68     -14.528  23.250  -7.605  1.00 27.87           N  
ATOM    565  CA  ILE    68     -15.940  23.586  -7.890  1.00 28.22           C  
ATOM    566  C   ILE    68     -16.769  23.403  -6.601  1.00 28.92           C  
ATOM    567  O   ILE    68     -17.548  24.276  -6.211  1.00 28.86           O  
ATOM    568  CB  ILE    68     -16.476  22.704  -9.021  1.00 27.86           C  
ATOM    569  CG1 ILE    68     -15.802  23.072 -10.349  1.00 28.61           C  
ATOM    570  CG2 ILE    68     -18.028  22.831  -9.113  1.00 27.84           C  
ATOM    571  CD1 ILE    68     -16.125  22.075 -11.499  1.00 28.47           C  
ATOM    572  N   ASP    69     -16.594  22.272  -5.938  1.00 28.29           N  
ATOM    573  CA  ASP    69     -17.330  21.994  -4.694  1.00 30.66           C  
ATOM    574  C   ASP    69     -17.075  23.052  -3.605  1.00 30.59           C  
ATOM    575  O   ASP    69     -17.985  23.383  -2.830  1.00 30.51           O  
ATOM    576  CB  ASP    69     -17.027  20.579  -4.213  1.00 31.59           C  
ATOM    577  CG  ASP    69     -17.624  19.495  -5.126  1.00 36.35           C  
ATOM    578  OD1 ASP    69     -18.394  19.819  -6.069  1.00 40.91           O  
ATOM    579  OD2 ASP    69     -17.328  18.310  -4.891  1.00 39.91           O  
ATOM    580  N   SER    70     -15.853  23.586  -3.572  1.00 29.87           N  
ATOM    581  CA  SER    70     -15.437  24.584  -2.588  0.50 30.17           C  
ATOM    583  C   SER    70     -15.789  26.016  -2.991  1.00 30.20           C  
ATOM    584  O   SER    70     -15.532  26.952  -2.232  1.00 30.92           O  
ATOM    585  CB  SER    70     -13.943  24.429  -2.284  0.50 30.09           C  
ATOM    587  OG  SER    70     -13.709  23.157  -1.691  0.50 30.21           O  
ATOM    589  N   GLY    71     -16.394  26.165  -4.179  1.00 29.53           N  
ATOM    590  CA  GLY    71     -16.882  27.465  -4.672  1.00 29.80           C  
ATOM    591  C   GLY    71     -15.812  28.391  -5.225  1.00 29.21           C  
ATOM    592  O   GLY    71     -16.036  29.606  -5.344  1.00 30.11           O  
ATOM    593  N   LEU    72     -14.640  27.843  -5.539  1.00 29.88           N  
ATOM    594  CA  LEU    72     -13.531  28.642  -6.076  1.00 27.91           C  
ATOM    595  C   LEU    72     -13.447  28.627  -7.607  1.00 29.19           C  
ATOM    596  O   LEU    72     -12.812  29.516  -8.183  1.00 29.94           O  
ATOM    597  CB  LEU    72     -12.163  28.156  -5.486  1.00 28.59           C  
ATOM    598  CG  LEU    72     -12.171  28.194  -3.931  1.00 26.72           C  
ATOM    599  CD1 LEU    72     -10.820  27.769  -3.470  1.00 30.74           C  
ATOM    600  CD2 LEU    72     -12.484  29.610  -3.415  1.00 28.81           C  
ATOM    601  N   VAL    73     -14.018  27.598  -8.242  1.00 29.25           N  
ATOM    602  CA  VAL    73     -13.976  27.432  -9.732  1.00 28.03           C  
ATOM    603  C   VAL    73     -15.383  27.076 -10.215  1.00 28.87           C  
ATOM    604  O   VAL    73     -16.167  26.488  -9.479  1.00 28.62           O  
ATOM    605  CB  VAL    73     -12.975  26.327 -10.078  1.00 28.54           C  
ATOM    606  CG1 VAL    73     -13.062  25.848 -11.565  1.00 29.42           C  
ATOM    607  CG2 VAL    73     -11.558  26.814  -9.766  1.00 28.41           C  
ATOM    608  N   GLU    74     -15.715  27.487 -11.438  1.00 28.71           N  
ATOM    609  CA  GLU    74     -16.949  27.008 -12.060  1.00 29.45           C  
ATOM    610  C   GLU    74     -16.650  26.532 -13.474  1.00 31.15           C  
ATOM    611  O   GLU    74     -15.697  27.033 -14.142  1.00 29.70           O  
ATOM    612  CB  GLU    74     -18.030  28.096 -12.043  1.00 30.64           C  
ATOM    613  CG  GLU    74     -17.544  29.452 -12.480  1.00 35.69           C  
ATOM    614  CD  GLU    74     -17.767  29.745 -13.959  1.00 43.35           C  
ATOM    615  OE1 GLU    74     -17.538  30.908 -14.348  1.00 42.21           O  
ATOM    616  OE2 GLU    74     -18.184  28.825 -14.717  1.00 46.17           O  
ATOM    617  N   ARG    75     -17.435  25.533 -13.904  1.00 29.67           N  
ATOM    618  CA  ARG    75     -17.367  24.986 -15.271  1.00 30.13           C  
ATOM    619  C   ARG    75     -18.541  25.565 -16.078  1.00 30.14           C  
ATOM    620  O   ARG    75     -19.672  25.598 -15.587  1.00 30.30           O  
ATOM    621  CB  ARG    75     -17.453  23.453 -15.230  1.00 31.80           C  
ATOM    622  CG  ARG    75     -17.545  22.772 -16.614  1.00 31.36           C  
ATOM    623  CD  ARG    75     -17.947  21.238 -16.501  1.00 32.95           C  
ATOM    624  NE  ARG    75     -16.903  20.561 -15.799  1.00 37.99           N  
ATOM    625  CZ  ARG    75     -17.011  20.103 -14.558  1.00 41.51           C  
ATOM    626  NH1 ARG    75     -15.955  19.524 -13.989  1.00 38.82           N  
ATOM    627  NH2 ARG    75     -18.156  20.254 -13.891  1.00 42.15           N  
ATOM    628  N   ARG    76     -18.256  26.059 -17.286  1.00 28.92           N  
ATOM    629  CA  ARG    76     -19.335  26.418 -18.189  1.00 29.77           C  
ATOM    630  C   ARG    76     -19.443  25.379 -19.284  1.00 28.36           C  
ATOM    631  O   ARG    76     -18.472  25.191 -19.986  1.00 28.53           O  
ATOM    632  CB  ARG    76     -19.014  27.759 -18.849  1.00 30.56           C  
ATOM    633  CG  ARG    76     -20.132  28.268 -19.753  1.00 32.27           C  
ATOM    634  CD  ARG    76     -19.709  29.566 -20.461  1.00 31.81           C  
ATOM    635  NE  ARG    76     -20.762  30.087 -21.329  1.00 35.20           N  
ATOM    636  CZ  ARG    76     -20.930  29.732 -22.607  1.00 36.59           C  
ATOM    637  NH1 ARG    76     -20.085  28.872 -23.182  1.00 38.21           N  
ATOM    638  NH2 ARG    76     -21.934  30.246 -23.323  1.00 33.02           N  
ATOM    639  N   SER    77     -20.602  24.744 -19.459  1.00 28.58           N  
ATOM    640  CA  SER    77     -20.793  23.830 -20.561  1.00 28.95           C  
ATOM    641  C   SER    77     -21.573  24.569 -21.627  1.00 28.76           C  
ATOM    642  O   SER    77     -22.773  24.848 -21.455  1.00 28.16           O  
ATOM    643  CB  SER    77     -21.593  22.567 -20.165  1.00 30.53           C  
ATOM    644  OG  SER    77     -21.065  21.915 -19.027  1.00 35.64           O  
ATOM    645  N   GLY    78     -20.872  24.945 -22.693  1.00 29.21           N  
ATOM    646  CA  GLY    78     -21.482  25.588 -23.853  1.00 28.28           C  
ATOM    647  C   GLY    78     -21.171  24.726 -25.077  1.00 29.02           C  
ATOM    648  O   GLY    78     -21.147  23.505 -25.000  1.00 28.84           O  
ATOM    649  N   GLN    79     -20.948  25.342 -26.225  1.00 27.77           N  
ATOM    650  CA  GLN    79     -20.537  24.548 -27.377  1.00 27.63           C  
ATOM    651  C   GLN    79     -19.154  23.969 -27.103  1.00 28.99           C  
ATOM    652  O   GLN    79     -18.795  22.934 -27.680  1.00 29.21           O  
ATOM    653  CB  GLN    79     -20.566  25.381 -28.641  1.00 27.27           C  
ATOM    654  CG  GLN    79     -21.998  25.699 -29.015  1.00 26.64           C  
ATOM    655  CD  GLN    79     -22.134  26.542 -30.255  1.00 28.25           C  
ATOM    656  OE1 GLN    79     -21.501  27.589 -30.389  1.00 32.85           O  
ATOM    657  NE2 GLN    79     -22.982  26.116 -31.146  1.00 29.95           N  
ATOM    658  N   ILE    80     -18.384  24.656 -26.263  1.00 27.96           N  
ATOM    659  CA  ILE    80     -17.164  24.076 -25.650  1.00 29.86           C  
ATOM    660  C   ILE    80     -17.307  24.171 -24.130  1.00 29.27           C  
ATOM    661  O   ILE    80     -18.156  24.927 -23.647  1.00 30.11           O  
ATOM    662  CB  ILE    80     -15.864  24.780 -26.129  1.00 28.85           C  
ATOM    663  CG1 ILE    80     -15.856  26.261 -25.702  1.00 32.17           C  
ATOM    664  CG2 ILE    80     -15.718  24.643 -27.669  1.00 31.06           C  
ATOM    665  CD1 ILE    80     -14.545  27.043 -26.035  1.00 33.47           C  
ATOM    666  N   THR    81     -16.510  23.384 -23.403  1.00 28.43           N  
ATOM    667  CA  THR    81     -16.523  23.384 -21.939  1.00 28.22           C  
ATOM    668  C   THR    81     -15.289  24.116 -21.452  1.00 28.52           C  
ATOM    669  O   THR    81     -14.147  23.787 -21.846  1.00 28.61           O  
ATOM    670  CB  THR    81     -16.507  21.956 -21.396  1.00 28.75           C  
ATOM    671  OG1 THR    81     -17.690  21.294 -21.859  1.00 31.34           O  
ATOM    672  CG2 THR    81     -16.522  21.955 -19.869  1.00 31.08           C  
ATOM    673  N   THR    82     -15.511  25.118 -20.609  1.00 28.37           N  
ATOM    674  CA  THR    82     -14.420  25.966 -20.131  1.00 28.26           C  
ATOM    675  C   THR    82     -14.554  26.187 -18.621  1.00 28.32           C  
ATOM    676  O   THR    82     -15.614  25.907 -18.059  1.00 28.07           O  
ATOM    677  CB  THR    82     -14.405  27.336 -20.844  1.00 29.29           C  
ATOM    678  OG1 THR    82     -15.659  27.982 -20.635  1.00 29.38           O  
ATOM    679  CG2 THR    82     -14.132  27.169 -22.361  1.00 28.94           C  
ATOM    680  N   TYR    83     -13.491  26.716 -18.007  1.00 29.04           N  
ATOM    681  CA  TYR    83     -13.385  26.842 -16.558  1.00 29.15           C  
ATOM    682  C   TYR    83     -12.886  28.258 -16.250  1.00 29.55           C  
ATOM    683  O   TYR    83     -12.141  28.869 -17.020  1.00 29.25           O  
ATOM    684  CB  TYR    83     -12.394  25.778 -16.021  1.00 29.63           C  
ATOM    685  CG  TYR    83     -12.761  24.318 -16.395  1.00 30.27           C  
ATOM    686  CD1 TYR    83     -13.449  23.507 -15.494  1.00 31.09           C  
ATOM    687  CD2 TYR    83     -12.454  23.785 -17.656  1.00 30.34           C  
ATOM    688  CE1 TYR    83     -13.815  22.160 -15.849  1.00 31.37           C  
ATOM    689  CE2 TYR    83     -12.820  22.456 -18.012  1.00 31.96           C  
ATOM    690  CZ  TYR    83     -13.499  21.681 -17.099  1.00 31.74           C  
ATOM    691  OH  TYR    83     -13.848  20.397 -17.475  1.00 34.84           O  
ATOM    692  N   ALA    84     -13.306  28.758 -15.102  1.00 30.07           N  
ATOM    693  CA  ALA    84     -12.898  30.065 -14.658  1.00 29.00           C  
ATOM    694  C   ALA    84     -12.974  30.097 -13.138  1.00 29.39           C  
ATOM    695  O   ALA    84     -13.731  29.355 -12.503  1.00 28.04           O  
ATOM    696  CB  ALA    84     -13.828  31.155 -15.236  1.00 30.87           C  
ATOM    697  N   LEU    85     -12.208  31.004 -12.562  1.00 27.83           N  
ATOM    698  CA  LEU    85     -12.313  31.261 -11.129  1.00 28.72           C  
ATOM    699  C   LEU    85     -13.618  32.020 -10.833  1.00 28.37           C  
ATOM    700  O   LEU    85     -14.051  32.924 -11.592  1.00 29.93           O  
ATOM    701  CB  LEU    85     -11.128  32.118 -10.707  1.00 29.13           C  
ATOM    702  CG  LEU    85      -9.774  31.409 -10.790  1.00 29.42           C  
ATOM    703  CD1 LEU    85      -8.737  32.458 -10.474  1.00 30.83           C  
ATOM    704  CD2 LEU    85      -9.702  30.240  -9.791  1.00 32.79           C  
ATOM    705  N   THR    86     -14.234  31.677  -9.709  1.00 28.05           N  
ATOM    706  CA  THR    86     -15.306  32.493  -9.150  1.00 29.08           C  
ATOM    707  C   THR    86     -14.710  33.730  -8.469  1.00 28.70           C  
ATOM    708  O   THR    86     -13.473  33.872  -8.366  1.00 28.56           O  
ATOM    709  CB  THR    86     -16.066  31.686  -8.083  1.00 28.31           C  
ATOM    710  OG1 THR    86     -15.160  31.412  -7.011  1.00 28.09           O  
ATOM    711  CG2 THR    86     -16.670  30.391  -8.671  1.00 29.71           C  
ATOM    712  N   GLU    87     -15.565  34.643  -7.995  1.00 28.48           N  
ATOM    713  CA  GLU    87     -15.087  35.783  -7.197  1.00 28.21           C  
ATOM    714  C   GLU    87     -14.224  35.303  -6.039  1.00 27.98           C  
ATOM    715  O   GLU    87     -13.143  35.843  -5.801  1.00 28.08           O  
ATOM    716  CB  GLU    87     -16.260  36.608  -6.654  1.00 28.97           C  
ATOM    717  CG  GLU    87     -15.795  37.776  -5.817  1.00 32.03           C  
ATOM    718  CD  GLU    87     -16.834  38.866  -5.668  1.00 37.40           C  
ATOM    719  OE1 GLU    87     -17.999  38.681  -6.105  1.00 39.68           O  
ATOM    720  OE2 GLU    87     -16.472  39.919  -5.102  1.00 40.80           O  
ATOM    721  N   LYS    88     -14.678  34.267  -5.336  1.00 26.90           N  
ATOM    722  CA  LYS    88     -13.841  33.696  -4.236  1.00 27.64           C  
ATOM    723  C   LYS    88     -12.505  33.134  -4.735  1.00 27.48           C  
ATOM    724  O   LYS    88     -11.465  33.369  -4.095  1.00 28.05           O  
ATOM    725  CB  LYS    88     -14.587  32.639  -3.428  1.00 26.47           C  
ATOM    726  CG  LYS    88     -15.766  33.197  -2.592  1.00 29.97           C  
ATOM    727  CD  LYS    88     -16.520  32.055  -1.986  1.00 31.77           C  
ATOM    728  CE  LYS    88     -17.639  32.571  -1.077  1.00 34.52           C  
ATOM    729  NZ  LYS    88     -18.530  31.437  -0.636  1.00 37.09           N  
ATOM    730  N   GLY    89     -12.521  32.417  -5.859  1.00 27.29           N  
ATOM    731  CA  GLY    89     -11.278  31.833  -6.408  1.00 27.82           C  
ATOM    732  C   GLY    89     -10.300  32.939  -6.789  1.00 27.71           C  
ATOM    733  O   GLY    89      -9.070  32.813  -6.559  1.00 26.30           O  
ATOM    734  N   MET    90     -10.832  34.020  -7.352  1.00 28.52           N  
ATOM    735  CA  MET    90      -9.968  35.159  -7.726  1.00 29.23           C  
ATOM    736  C   MET    90      -9.369  35.854  -6.476  1.00 29.18           C  
ATOM    737  O   MET    90      -8.189  36.250  -6.463  1.00 28.95           O  
ATOM    738  CB  MET    90     -10.714  36.183  -8.595  1.00 30.36           C  
ATOM    739  CG  MET    90      -9.775  37.308  -9.095  1.00 32.97           C  
ATOM    740  SD  MET    90      -8.279  36.659 -10.240  0.55 36.03          SE  
ATOM    741  CE  MET    90      -9.351  35.987 -11.693  1.00 35.53           C  
ATOM    742  N   ASN    91     -10.150  35.940  -5.409  1.00 28.62           N  
ATOM    743  CA  ASN    91      -9.609  36.407  -4.128  1.00 28.64           C  
ATOM    744  C   ASN    91      -8.476  35.527  -3.605  1.00 27.84           C  
ATOM    745  O   ASN    91      -7.444  36.019  -3.139  1.00 27.84           O  
ATOM    746  CB  ASN    91     -10.720  36.491  -3.084  1.00 29.00           C  
ATOM    747  CG  ASN    91     -11.716  37.587  -3.386  1.00 29.45           C  
ATOM    748  OD1 ASN    91     -11.392  38.575  -4.056  1.00 27.66           O  
ATOM    749  ND2 ASN    91     -12.930  37.423  -2.905  1.00 28.75           N  
ATOM    750  N   VAL    92      -8.668  34.219  -3.635  1.00 27.04           N  
ATOM    751  CA  VAL    92      -7.552  33.325  -3.311  1.00 28.12           C  
ATOM    752  C   VAL    92      -6.323  33.601  -4.207  1.00 27.67           C  
ATOM    753  O   VAL    92      -5.209  33.665  -3.716  1.00 26.90           O  
ATOM    754  CB  VAL    92      -7.997  31.843  -3.442  1.00 28.20           C  
ATOM    755  CG1 VAL    92      -6.780  30.843  -3.275  1.00 27.42           C  
ATOM    756  CG2 VAL    92      -9.135  31.524  -2.399  1.00 30.21           C  
ATOM    757  N   ARG    93      -6.548  33.772  -5.506  1.00 28.09           N  
ATOM    758  CA  ARG    93      -5.422  33.888  -6.432  1.00 28.32           C  
ATOM    759  C   ARG    93      -4.688  35.143  -6.068  1.00 27.74           C  
ATOM    760  O   ARG    93      -3.454  35.180  -6.049  1.00 27.95           O  
ATOM    761  CB  ARG    93      -5.888  33.967  -7.868  1.00 28.07           C  
ATOM    762  CG  ARG    93      -4.693  33.906  -8.838  1.00 25.86           C  
ATOM    763  CD  ARG    93      -5.157  34.048 -10.247  1.00 26.49           C  
ATOM    764  NE  ARG    93      -4.120  33.795 -11.241  1.00 28.18           N  
ATOM    765  CZ  ARG    93      -3.202  34.673 -11.649  1.00 29.31           C  
ATOM    766  NH1 ARG    93      -2.287  34.306 -12.557  1.00 25.94           N  
ATOM    767  NH2 ARG    93      -3.198  35.916 -11.166  1.00 26.86           N  
ATOM    768  N   ASN    94      -5.459  36.176  -5.767  1.00 28.92           N  
ATOM    769  CA  ASN    94      -4.886  37.494  -5.404  1.00 29.99           C  
ATOM    770  C   ASN    94      -3.915  37.371  -4.211  1.00 32.12           C  
ATOM    771  O   ASN    94      -2.841  37.961  -4.232  1.00 31.33           O  
ATOM    772  CB  ASN    94      -5.971  38.543  -5.091  1.00 30.37           C  
ATOM    773  CG  ASN    94      -6.675  39.043  -6.340  1.00 32.67           C  
ATOM    774  OD1 ASN    94      -6.194  38.840  -7.464  1.00 32.25           O  
ATOM    775  ND2 ASN    94      -7.838  39.681  -6.155  1.00 32.87           N  
ATOM    776  N   SER    95      -4.292  36.604  -3.190  1.00 32.21           N  
ATOM    777  CA  SER    95      -3.400  36.395  -2.041  0.50 33.67           C  
ATOM    779  C   SER    95      -2.286  35.405  -2.316  1.00 33.56           C  
ATOM    780  O   SER    95      -1.258  35.427  -1.651  1.00 35.19           O  
ATOM    781  CB  SER    95      -4.179  35.979  -0.796  0.50 33.85           C  
ATOM    783  OG  SER    95      -5.282  36.826  -0.602  0.50 34.68           O  
ATOM    785  N   LEU    96      -2.471  34.542  -3.311  1.00 32.37           N  
ATOM    786  CA  LEU    96      -1.491  33.550  -3.647  1.00 32.67           C  
ATOM    787  C   LEU    96      -0.295  34.105  -4.388  1.00 30.83           C  
ATOM    788  O   LEU    96       0.820  33.633  -4.159  1.00 30.82           O  
ATOM    789  CB  LEU    96      -2.157  32.477  -4.517  1.00 33.56           C  
ATOM    790  CG  LEU    96      -1.710  31.050  -4.639  1.00 38.72           C  
ATOM    791  CD1 LEU    96      -1.362  30.451  -3.239  1.00 35.81           C  
ATOM    792  CD2 LEU    96      -2.842  30.238  -5.358  1.00 34.93           C  
ATOM    793  N   MET    97      -0.504  35.093  -5.271  1.00 30.72           N  
ATOM    794  CA  MET    97       0.573  35.499  -6.198  1.00 30.72           C  
ATOM    795  C   MET    97       1.842  36.013  -5.490  1.00 29.84           C  
ATOM    796  O   MET    97       2.933  35.641  -5.896  1.00 30.74           O  
ATOM    797  CB  MET    97       0.075  36.444  -7.294  1.00 31.52           C  
ATOM    798  CG  MET    97      -1.008  35.843  -8.209  1.00 34.65           C  
ATOM    799  SD  MET    97      -0.818  33.923  -8.692  0.70 44.93          SE  
ATOM    800  CE  MET    97       0.709  34.110  -9.778  1.00 41.24           C  
ATOM    801  N   PRO    98       1.715  36.844  -4.434  1.00 29.05           N  
ATOM    802  CA  PRO    98       2.974  37.244  -3.779  1.00 29.62           C  
ATOM    803  C   PRO    98       3.757  36.083  -3.167  1.00 29.38           C  
ATOM    804  O   PRO    98       5.012  36.095  -3.173  1.00 28.71           O  
ATOM    805  CB  PRO    98       2.511  38.270  -2.724  1.00 27.95           C  
ATOM    806  CG  PRO    98       1.158  38.780  -3.240  1.00 29.52           C  
ATOM    807  CD  PRO    98       0.549  37.499  -3.812  1.00 28.86           C  
ATOM    808  N   LEU    99       3.042  35.062  -2.695  1.00 29.20           N  
ATOM    809  CA  LEU    99       3.663  33.870  -2.139  1.00 29.63           C  
ATOM    810  C   LEU    99       4.396  33.115  -3.247  1.00 28.97           C  
ATOM    811  O   LEU    99       5.587  32.776  -3.087  1.00 29.73           O  
ATOM    812  CB  LEU    99       2.619  32.977  -1.497  1.00 29.90           C  
ATOM    813  CG  LEU    99       3.168  31.683  -0.942  1.00 31.39           C  
ATOM    814  CD1 LEU    99       4.202  31.905   0.205  1.00 30.66           C  
ATOM    815  CD2 LEU    99       1.990  30.860  -0.502  1.00 31.76           C  
ATOM    816  N   LEU   100       3.718  32.889  -4.374  1.00 28.17           N  
ATOM    817  CA  LEU   100       4.364  32.230  -5.503  1.00 28.95           C  
ATOM    818  C   LEU   100       5.550  33.020  -6.085  1.00 27.53           C  
ATOM    819  O   LEU   100       6.573  32.418  -6.447  1.00 27.72           O  
ATOM    820  CB  LEU   100       3.347  31.799  -6.572  1.00 29.88           C  
ATOM    821  CG  LEU   100       2.325  30.758  -6.059  1.00 31.71           C  
ATOM    822  CD1 LEU   100       1.399  30.347  -7.205  1.00 34.06           C  
ATOM    823  CD2 LEU   100       2.939  29.510  -5.392  1.00 35.43           C  
ATOM    824  N   GLN   101       5.420  34.352  -6.171  1.00 28.07           N  
ATOM    825  CA  GLN   101       6.504  35.194  -6.585  1.00 28.02           C  
ATOM    826  C   GLN   101       7.722  34.903  -5.698  1.00 28.41           C  
ATOM    827  O   GLN   101       8.818  34.657  -6.213  1.00 27.55           O  
ATOM    828  CB  GLN   101       6.085  36.661  -6.502  1.00 27.70           C  
ATOM    829  CG  GLN   101       7.155  37.657  -6.935  1.00 29.75           C  
ATOM    830  CD  GLN   101       6.627  39.072  -6.900  1.00 36.26           C  
ATOM    831  OE1 GLN   101       6.218  39.568  -5.838  1.00 39.47           O  
ATOM    832  NE2 GLN   101       6.614  39.734  -8.055  1.00 36.49           N  
ATOM    833  N   TYR   102       7.514  34.893  -4.378  1.00 27.05           N  
ATOM    834  CA  TYR   102       8.673  34.752  -3.497  1.00 27.21           C  
ATOM    835  C   TYR   102       9.243  33.344  -3.614  1.00 26.42           C  
ATOM    836  O   TYR   102      10.452  33.175  -3.617  1.00 27.13           O  
ATOM    837  CB  TYR   102       8.385  35.071  -2.044  1.00 27.35           C  
ATOM    838  CG  TYR   102       9.672  35.078  -1.243  1.00 26.25           C  
ATOM    839  CD1 TYR   102      10.720  35.926  -1.593  1.00 27.25           C  
ATOM    840  CD2 TYR   102       9.847  34.246  -0.138  1.00 25.54           C  
ATOM    841  CE1 TYR   102      11.924  35.953  -0.874  1.00 26.32           C  
ATOM    842  CE2 TYR   102      11.059  34.260   0.587  1.00 24.84           C  
ATOM    843  CZ  TYR   102      12.074  35.112   0.230  1.00 26.75           C  
ATOM    844  OH  TYR   102      13.270  35.165   0.933  1.00 25.91           O  
ATOM    845  N   ILE   103       8.378  32.346  -3.722  1.00 27.50           N  
ATOM    846  CA  ILE   103       8.813  30.981  -3.992  1.00 27.88           C  
ATOM    847  C   ILE   103       9.731  30.908  -5.220  1.00 27.65           C  
ATOM    848  O   ILE   103      10.751  30.201  -5.192  1.00 27.73           O  
ATOM    849  CB  ILE   103       7.617  30.032  -4.134  1.00 29.23           C  
ATOM    850  CG1 ILE   103       7.016  29.788  -2.747  1.00 30.88           C  
ATOM    851  CG2 ILE   103       8.035  28.692  -4.718  1.00 28.51           C  
ATOM    852  CD1 ILE   103       5.732  28.980  -2.795  1.00 33.46           C  
ATOM    853  N   SER   104       9.378  31.624  -6.282  1.00 27.79           N  
ATOM    854  CA  SER   104      10.196  31.587  -7.481  0.50 27.34           C  
ATOM    856  C   SER   104      11.574  32.157  -7.178  1.00 27.49           C  
ATOM    857  O   SER   104      12.578  31.651  -7.696  1.00 28.21           O  
ATOM    858  CB  SER   104       9.517  32.288  -8.666  0.50 27.70           C  
ATOM    860  OG  SER   104       9.297  33.653  -8.404  0.50 26.64           O  
ATOM    862  N   VAL   105      11.633  33.198  -6.338  1.00 27.35           N  
ATOM    863  CA  VAL   105      12.917  33.788  -5.913  1.00 28.27           C  
ATOM    864  C   VAL   105      13.727  32.746  -5.132  1.00 27.87           C  
ATOM    865  O   VAL   105      14.911  32.534  -5.409  1.00 28.29           O  
ATOM    866  CB  VAL   105      12.712  35.069  -5.063  1.00 28.99           C  
ATOM    867  CG1 VAL   105      14.037  35.535  -4.379  1.00 28.92           C  
ATOM    868  CG2 VAL   105      12.092  36.197  -5.908  1.00 29.40           C  
ATOM    869  N   LEU   106      13.102  32.109  -4.153  1.00 27.98           N  
ATOM    870  CA  LEU   106      13.769  31.016  -3.414  1.00 29.11           C  
ATOM    871  C   LEU   106      14.298  29.896  -4.309  1.00 29.49           C  
ATOM    872  O   LEU   106      15.409  29.399  -4.086  1.00 28.40           O  
ATOM    873  CB  LEU   106      12.844  30.436  -2.360  1.00 29.16           C  
ATOM    874  CG  LEU   106      12.443  31.332  -1.195  1.00 28.98           C  
ATOM    875  CD1 LEU   106      11.364  30.598  -0.405  1.00 27.21           C  
ATOM    876  CD2 LEU   106      13.592  31.655  -0.283  1.00 28.46           C  
ATOM    877  N   ASP   107      13.530  29.522  -5.329  1.00 30.00           N  
ATOM    878  CA  ASP   107      13.912  28.437  -6.238  1.00 31.31           C  
ATOM    879  C   ASP   107      15.183  28.744  -7.021  1.00 32.94           C  
ATOM    880  O   ASP   107      15.879  27.832  -7.457  1.00 32.77           O  
ATOM    881  CB  ASP   107      12.767  28.129  -7.204  1.00 30.81           C  
ATOM    882  CG  ASP   107      11.600  27.426  -6.519  1.00 31.73           C  
ATOM    883  OD1 ASP   107      11.808  26.861  -5.409  1.00 32.85           O  
ATOM    884  OD2 ASP   107      10.497  27.412  -7.108  1.00 30.11           O  
ATOM    885  N   ARG   108      15.483  30.027  -7.165  1.00 35.82           N  
ATOM    886  CA  ARG   108      16.714  30.471  -7.828  1.00 38.32           C  
ATOM    887  C   ARG   108      17.910  30.455  -6.873  1.00 40.36           C  
ATOM    888  O   ARG   108      19.070  30.499  -7.313  1.00 41.27           O  
ATOM    889  CB  ARG   108      16.532  31.880  -8.395  1.00 38.71           C  
ATOM    890  CG  ARG   108      15.484  32.018  -9.490  1.00 39.12           C  
ATOM    891  CD  ARG   108      15.947  31.500 -10.868  1.00 41.50           C  
ATOM    892  NE  ARG   108      17.379  31.658 -11.134  1.00 39.33           N  
ATOM    893  CZ  ARG   108      17.954  32.744 -11.656  1.00 40.78           C  
ATOM    894  NH1 ARG   108      17.234  33.825 -11.957  1.00 39.73           N  
ATOM    895  NH2 ARG   108      19.265  32.753 -11.862  1.00 39.54           N  
ATOM    896  N   ASN   109      17.609  30.383  -5.574  1.00 42.89           N  
ATOM    897  CA  ASN   109      18.561  30.416  -4.447  1.00 44.82           C  
ATOM    898  C   ASN   109      18.725  31.803  -3.828  1.00 45.47           C  
ATOM    899  O   ASN   109      19.574  32.596  -4.253  1.00 46.71           O  
ATOM    900  CB  ASN   109      19.923  29.793  -4.797  1.00 45.67           C  
ATOM    901  CG  ASN   109      20.027  28.329  -4.385  1.00 47.92           C  
ATOM    902  OD1 ASN   109      21.107  27.860  -4.009  1.00 50.81           O  
ATOM    903  ND2 ASN   109      18.912  27.600  -4.455  1.00 49.19           N  
END
