
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  142 ( 1106),  selected  142 , name 2f2e_A
# Molecule2: number of CA atoms  109 (  848),  selected  109 , name T0459.pdb
# PARAMETERS: 2f2e_A.T0459.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    H     7_A      -       -           -
LGA    K     8_A      -       -           -
LGA    Q     9_A      -       -           -
LGA    A    10_A      S       1          5.768
LGA    S    11_A      N       2          4.140
LGA    -       -      A       3           -
LGA    -       -      M       4           -
LGA    -       -      L       5           -
LGA    -       -      R       6           -
LGA    -       -      Y       7           -
LGA    -       -      G       8           -
LGA    -       -      D       9           -
LGA    -       -      T      10           -
LGA    -       -      E      11           -
LGA    C    12_A      I      12           #
LGA    P    13_A      C      13          3.711
LGA    V    14_A      I      14          3.694
LGA    A    15_A      D      15          4.354
LGA    -       -      P      16           -
LGA    -       -      S      17           -
LGA    -       -      E      18           -
LGA    R    16_A      S      19          1.553
LGA    P    17_A      V      20          2.723
LGA    L    18_A      L      21          1.163
LGA    D    19_A      H      22          2.032
LGA    V    20_A      L      23          2.287
LGA    I    21_A      L      24          0.328
LGA    G    22_A      G      25          1.033
LGA    D    23_A      K      26          1.525
LGA    G    24_A      K      27          1.836
LGA    W    25_A      Y      28          0.481
LGA    S    26_A      T      29          0.690
LGA    X    27_A      M      30          0.766
LGA    L    28_A      L      31          0.506
LGA    I    29_A      I      32          0.635
LGA    V    30_A      I      33          0.803
LGA    R    31_A      S      34          0.881
LGA    D    32_A      V      35          0.559
LGA    A    33_A      L      36          0.868
LGA    F    34_A      G      37          0.989
LGA    E    35_A      N      38          0.152
LGA    G    36_A      G      39          3.238
LGA    -       -      S      40           -
LGA    -       -      T      41           -
LGA    L    37_A      R      42          5.422
LGA    T    38_A      Q      43          2.057
LGA    R    39_A      N      44          1.007
LGA    F    40_A      F      45          0.535
LGA    G    41_A      N      46          0.889
LGA    E    42_A      D      47          0.476
LGA    F    43_A      I      48          0.960
LGA    Q    44_A      R      49          1.375
LGA    K    45_A      S      50          1.201
LGA    S    46_A      S      51          1.300
LGA    L    47_A      I      52          1.545
LGA    G    48_A      P      53          3.684
LGA    -       -      G      54           -
LGA    L    49_A      I      55          1.073
LGA    A    50_A      S      56          1.066
LGA    K    51_A      S      57          0.937
LGA    N    52_A      T      58          1.800
LGA    I    53_A      I      59          1.804
LGA    L    54_A      L      60          0.985
LGA    A    55_A      S      61          0.829
LGA    A    56_A      R      62          0.859
LGA    R    57_A      R      63          0.828
LGA    L    58_A      I      64          0.769
LGA    R    59_A      K      65          0.967
LGA    N    60_A      D      66          1.018
LGA    L    61_A      L      67          0.554
LGA    V    62_A      I      68          0.501
LGA    E    63_A      D      69          0.723
LGA    H    64_A      S      70          0.830
LGA    G    65_A      G      71          0.745
LGA    V    66_A      L      72          0.599
LGA    X    67_A      V      73          0.557
LGA    V    68_A      E      74          0.867
LGA    A    69_A      R      75          0.968
LGA    V    70_A      R      76          1.688
LGA    P    71_A      S      77          1.441
LGA    A    72_A      G      78          2.972
LGA    E    73_A      -       -           -
LGA    S    74_A      -       -           -
LGA    G    75_A      -       -           -
LGA    S    76_A      Q      79          2.434
LGA    H    77_A      I      80          2.194
LGA    Q    78_A      T      81          1.548
LGA    E    79_A      T      82          1.363
LGA    Y    80_A      Y      83          0.983
LGA    R    81_A      A      84          1.419
LGA    L    82_A      L      85          0.784
LGA    T    83_A      T      86          0.779
LGA    D    84_A      E      87          1.059
LGA    K    85_A      K      88          0.819
LGA    G    86_A      G      89          0.337
LGA    R    87_A      M      90          0.766
LGA    A    88_A      N      91          0.540
LGA    L    89_A      V      92          1.087
LGA    F    90_A      R      93          2.880
LGA    P    91_A      N      94          3.270
LGA    L    92_A      S      95          2.218
LGA    L    93_A      L      96          1.441
LGA    V    94_A      M      97          1.822
LGA    A    95_A      P      98          2.584
LGA    I    96_A      L      99          1.696
LGA    R    97_A      L     100          1.706
LGA    Q    98_A      Q     101          2.708
LGA    W    99_A      Y     102          2.258
LGA    G   100_A      I     103          0.799
LGA    E   101_A      S     104          3.171
LGA    D   102_A      V     105          3.324
LGA    Y   103_A      L     106          1.802
LGA    F   104_A      D     107          1.809
LGA    F   105_A      R     108          0.792
LGA    A   106_A      N     109          3.742
LGA    P   107_A      -       -           -
LGA    D   108_A      -       -           -
LGA    E   109_A      -       -           -
LGA    S   110_A      -       -           -
LGA    H   111_A      -       -           -
LGA    V   112_A      -       -           -
LGA    R   113_A      -       -           -
LGA    L   114_A      -       -           -
LGA    V   115_A      -       -           -
LGA    E   116_A      -       -           -
LGA    R   117_A      -       -           -
LGA    D   118_A      -       -           -
LGA    S   119_A      -       -           -
LGA    G   120_A      -       -           -
LGA    Q   121_A      -       -           -
LGA    P   122_A      -       -           -
LGA    V   123_A      -       -           -
LGA    P   124_A      -       -           -
LGA    R   125_A      -       -           -
LGA    L   126_A      -       -           -
LGA    Q   127_A      -       -           -
LGA    V   128_A      -       -           -
LGA    R   129_A      -       -           -
LGA    A   130_A      -       -           -
LGA    G   131_A      -       -           -
LGA    D   132_A      -       -           -
LGA    G   133_A      -       -           -
LGA    S   134_A      -       -           -
LGA    P   135_A      -       -           -
LGA    L   136_A      -       -           -
LGA    A   137_A      -       -           -
LGA    A   138_A      -       -           -
LGA    E   139_A      -       -           -
LGA    D   140_A      -       -           -
LGA    T   141_A      -       -           -
LGA    R   142_A      -       -           -
LGA    V   143_A      -       -           -
LGA    S   144_A      -       -           -
LGA    R   145_A      -       -           -
LGA    D   146_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  142  109    5.0     93    1.95    20.43     76.879     4.547

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.385640 * X  +  -0.328742 * Y  +   0.862096 * Z  +   0.585962
  Y_new =   0.739174 * X  +  -0.449114 * Y  +  -0.501914 * Z  +  58.177433
  Z_new =   0.552180 * X  +   0.830798 * Y  +   0.069801 * Z  + -65.398994 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.486976   -1.654616  [ DEG:    85.1975    -94.8025 ]
  Theta =  -0.584977   -2.556616  [ DEG:   -33.5167   -146.4833 ]
  Phi   =   1.089926   -2.051667  [ DEG:    62.4482   -117.5518 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2f2e_A                                        
REMARK     2: T0459.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2f2e_A.T0459.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  142  109   5.0   93   1.95   20.43  76.879
REMARK  ---------------------------------------------------------- 
MOLECULE 2f2e_A
HEADER    DNA BINDING PROTEIN/STRUCTURAL GENOMICS 16-NOV-05   2F2E              
TITLE     CRYSTAL STRUCTURE OF PA1607, A PUTATIVE TRANSCRIPTION FACTOR          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PA1607;                                                    
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS AERUGINOSA;                         
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: PA1607;                                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET15-MODIFIED                            
KEYWDS    TRANSCRIPTION FACTOR, HELIX-TRUN-HELIX, APC5613, STRUCTURAL           
KEYWDS   2 GENOMICS, PSI, PROTEIN STRUCTURE INITIATIVE, MIDWEST CENTER          
KEYWDS   3 FOR STRUCTURAL GENOMICS, MCSG                                        
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    E.A.SIEMINSKA,X.XU,H.ZHENG,V.LUNIN,M.CUFF,A.JOACHIMIAK,               
AUTHOR   2 A.EDWARDS,A.SAVCHENKO,D.A.R.SANDERS,MIDWEST CENTER FOR               
AUTHOR   3 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   2   28-NOV-06 2F2E    1       REMARK MASTER                            
REVDAT   1   14-MAR-06 2F2E    0                                                
JRNL        AUTH   E.A.SIEMINSKA,X.XU,H.ZHENG,V.LUNIN,M.CUFF,                   
JRNL        AUTH 2 A.JOACHIMIAK,A.EDWARDS,A.SAVCHENKO,D.A.R.SANDERS             
JRNL        TITL   CRYSTAL STRUCTURE OF PA1607, A PUTATIVE                      
JRNL        TITL 2 TRANSCRIPTION FACTOR                                         
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.85 ANGSTROMS.                                          
DBREF  2F2E A    1   146  UNP    Q9I3B4   Q9I3B4_PSEAE     1    146             
DBREF  2F2E B    1   146  UNP    Q9I3B4   Q9I3B4_PSEAE     1    146             
SEQRES   1 A  146  MSE VAL LYS ARG THR SER HIS LYS GLN ALA SER CYS PRO          
SEQRES   2 A  146  VAL ALA ARG PRO LEU ASP VAL ILE GLY ASP GLY TRP SER          
SEQRES   3 A  146  MSE LEU ILE VAL ARG ASP ALA PHE GLU GLY LEU THR ARG          
SEQRES   4 A  146  PHE GLY GLU PHE GLN LYS SER LEU GLY LEU ALA LYS ASN          
SEQRES   5 A  146  ILE LEU ALA ALA ARG LEU ARG ASN LEU VAL GLU HIS GLY          
SEQRES   6 A  146  VAL MSE VAL ALA VAL PRO ALA GLU SER GLY SER HIS GLN          
SEQRES   7 A  146  GLU TYR ARG LEU THR ASP LYS GLY ARG ALA LEU PHE PRO          
SEQRES   8 A  146  LEU LEU VAL ALA ILE ARG GLN TRP GLY GLU ASP TYR PHE          
SEQRES   9 A  146  PHE ALA PRO ASP GLU SER HIS VAL ARG LEU VAL GLU ARG          
SEQRES  10 A  146  ASP SER GLY GLN PRO VAL PRO ARG LEU GLN VAL ARG ALA          
SEQRES  11 A  146  GLY ASP GLY SER PRO LEU ALA ALA GLU ASP THR ARG VAL          
SEQRES  12 A  146  SER ARG ASP                                                  
SEQRES   1 B  146  MSE VAL LYS ARG THR SER HIS LYS GLN ALA SER CYS PRO          
SEQRES   2 B  146  VAL ALA ARG PRO LEU ASP VAL ILE GLY ASP GLY TRP SER          
SEQRES   3 B  146  MSE LEU ILE VAL ARG ASP ALA PHE GLU GLY LEU THR ARG          
SEQRES   4 B  146  PHE GLY GLU PHE GLN LYS SER LEU GLY LEU ALA LYS ASN          
SEQRES   5 B  146  ILE LEU ALA ALA ARG LEU ARG ASN LEU VAL GLU HIS GLY          
SEQRES   6 B  146  VAL MSE VAL ALA VAL PRO ALA GLU SER GLY SER HIS GLN          
SEQRES   7 B  146  GLU TYR ARG LEU THR ASP LYS GLY ARG ALA LEU PHE PRO          
SEQRES   8 B  146  LEU LEU VAL ALA ILE ARG GLN TRP GLY GLU ASP TYR PHE          
SEQRES   9 B  146  PHE ALA PRO ASP GLU SER HIS VAL ARG LEU VAL GLU ARG          
SEQRES  10 B  146  ASP SER GLY GLN PRO VAL PRO ARG LEU GLN VAL ARG ALA          
SEQRES  11 B  146  GLY ASP GLY SER PRO LEU ALA ALA GLU ASP THR ARG VAL          
SEQRES  12 B  146  SER ARG ASP                                                  
HET    MSE  A  27       8                                                       
HET    MSE  A  67       8                                                       
HET    MSE  B  27       8                                                       
HET    MSE  B  67       8                                                       
HET    GLC    401      12                                                       
HET    SO4    501       5                                                       
HET    SO4    502       5                                                       
HET    SO4    503       5                                                       
HET    SO4    504       5                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     GLC GLUCOSE                                                          
HETNAM     SO4 SULFATE ION                                                      
FORMUL   1  MSE    4(C5 H11 N O2 SE)                                            
FORMUL   3  GLC    C6 H12 O6                                                    
FORMUL   4  SO4    4(O4 S 2-)                                                   
FORMUL   8  HOH   *329(H2 O)                                                    
CRYST1   46.884   78.865   78.941  90.00  91.64  90.00 C 1 2 1       8          
ATOM      1  N   THR A   5     -10.431  16.613   3.106  1.00 47.00           N  
ATOM      2  CA  THR A   5     -11.147  17.650   3.909  1.00 46.87           C  
ATOM      3  C   THR A   5     -11.052  17.357   5.421  1.00 46.30           C  
ATOM      4  O   THR A   5     -12.062  17.144   6.102  1.00 46.71           O  
ATOM      5  CB  THR A   5     -12.074  18.231   2.886  0.00 45.03           C  
ATOM      6  OG1 THR A   5     -11.784  18.599   1.531  0.00 46.95           O  
ATOM      7  CG2 THR A   5     -12.661  19.515   3.460  0.00 43.97           C  
ATOM      8  N   SER A   6      -9.836  17.368   5.963  1.00 43.90           N  
ATOM      9  CA  SER A   6      -9.714  17.019   7.353  1.00 42.60           C  
ATOM     10  C   SER A   6      -9.638  18.233   8.301  1.00 40.37           C  
ATOM     11  O   SER A   6      -9.664  18.068   9.521  1.00 39.82           O  
ATOM     12  CB  SER A   6      -8.560  16.046   7.559  1.00 42.98           C  
ATOM     13  OG  SER A   6      -7.528  16.228   6.592  1.00 46.27           O  
ATOM     14  N   HIS A   7      -9.519  19.441   7.751  1.00 38.27           N  
ATOM     15  CA  HIS A   7      -9.605  20.636   8.596  1.00 36.60           C  
ATOM     16  C   HIS A   7     -10.988  21.273   8.544  1.00 36.82           C  
ATOM     17  O   HIS A   7     -11.165  22.425   8.984  1.00 35.75           O  
ATOM     18  CB  HIS A   7      -8.567  21.665   8.177  1.00 35.96           C  
ATOM     19  CG  HIS A   7      -7.158  21.172   8.274  1.00 34.92           C  
ATOM     20  ND1 HIS A   7      -6.600  20.726   9.458  1.00 32.60           N  
ATOM     21  CD2 HIS A   7      -6.191  21.060   7.334  1.00 32.61           C  
ATOM     22  CE1 HIS A   7      -5.353  20.335   9.230  1.00 32.48           C  
ATOM     23  NE2 HIS A   7      -5.072  20.555   7.958  1.00 32.09           N  
ATOM     24  N   LYS A   8     -11.986  20.517   8.072  1.00 35.42           N  
ATOM     25  CA  LYS A   8     -13.293  21.150   7.780  1.00 35.79           C  
ATOM     26  C   LYS A   8     -13.907  21.783   9.027  1.00 35.57           C  
ATOM     27  O   LYS A   8     -14.561  22.823   8.953  1.00 35.92           O  
ATOM     28  CB  LYS A   8     -14.120  20.233   7.124  0.00 33.01           C  
ATOM     29  CG  LYS A   8     -15.454  20.813   6.658  0.00 34.13           C  
ATOM     30  CD  LYS A   8     -16.327  19.804   5.935  0.00 37.92           C  
ATOM     31  CE  LYS A   8     -17.645  20.425   5.502  0.00 38.77           C  
ATOM     32  NZ  LYS A   8     -18.542  19.484   4.786  0.00 37.58           N  
ATOM     33  N   GLN A   9     -13.709  21.150  10.175  1.00 35.41           N  
ATOM     34  CA  GLN A   9     -14.245  21.674  11.418  1.00 37.29           C  
ATOM     35  C   GLN A   9     -13.184  22.226  12.359  1.00 36.61           C  
ATOM     36  O   GLN A   9     -13.485  22.442  13.518  1.00 37.28           O  
ATOM     37  CB  GLN A   9     -15.054  20.604  12.171  1.00 38.84           C  
ATOM     38  CG  GLN A   9     -16.546  20.575  11.831  1.00 41.80           C  
ATOM     39  CD  GLN A   9     -16.841  19.854  10.556  1.00 46.33           C  
ATOM     40  OE1 GLN A   9     -16.257  18.810  10.281  1.00 50.14           O  
ATOM     41  NE2 GLN A   9     -17.753  20.402   9.759  1.00 47.86           N  
ATOM     42  N   ALA A  10     -11.963  22.460  11.878  1.00 35.57           N  
ATOM     43  CA  ALA A  10     -10.946  23.112  12.700  1.00 35.48           C  
ATOM     44  C   ALA A  10     -11.464  24.459  13.152  1.00 34.70           C  
ATOM     45  O   ALA A  10     -12.107  25.148  12.393  1.00 34.69           O  
ATOM     46  CB  ALA A  10      -9.688  23.331  11.894  1.00 35.83           C  
ATOM     47  N   SER A  11     -11.109  24.884  14.355  1.00 34.65           N  
ATOM     48  CA  SER A  11     -11.443  26.248  14.755  1.00 35.16           C  
ATOM     49  C   SER A  11     -10.585  27.308  14.047  1.00 34.11           C  
ATOM     50  O   SER A  11     -11.015  28.440  13.935  1.00 32.82           O  
ATOM     51  CB  SER A  11     -11.332  26.398  16.269  1.00 36.80           C  
ATOM     52  OG  SER A  11      -9.976  26.184  16.617  1.00 39.52           O  
ATOM     53  N   CYS A  12      -9.429  26.931  13.492  1.00 32.71           N  
ATOM     54  CA  CYS A  12      -8.447  27.898  12.960  1.00 32.14           C  
ATOM     55  C   CYS A  12      -8.700  28.318  11.503  1.00 31.52           C  
ATOM     56  O   CYS A  12      -8.845  27.471  10.642  1.00 31.27           O  
ATOM     57  CB  CYS A  12      -7.030  27.311  13.102  1.00 32.70           C  
ATOM     58  SG  CYS A  12      -5.745  28.267  12.393  1.00 33.27           S  
ATOM     59  N   PRO A  13      -8.745  29.642  11.217  1.00 31.72           N  
ATOM     60  CA  PRO A  13      -8.882  30.156   9.838  1.00 30.90           C  
ATOM     61  C   PRO A  13      -7.736  29.831   8.901  1.00 31.40           C  
ATOM     62  O   PRO A  13      -7.910  29.879   7.684  1.00 31.53           O  
ATOM     63  CB  PRO A  13      -9.000  31.697  10.032  1.00 31.79           C  
ATOM     64  CG  PRO A  13      -9.509  31.841  11.447  1.00 32.02           C  
ATOM     65  CD  PRO A  13      -8.683  30.754  12.189  1.00 31.75           C  
ATOM     66  N   VAL A  14      -6.544  29.548   9.426  1.00 31.02           N  
ATOM     67  CA  VAL A  14      -5.467  29.109   8.544  1.00 29.27           C  
ATOM     68  C   VAL A  14      -5.726  27.665   8.072  1.00 29.05           C  
ATOM     69  O   VAL A  14      -5.371  27.305   6.944  1.00 27.25           O  
ATOM     70  CB  VAL A  14      -4.090  29.173   9.247  1.00 29.71           C  
ATOM     71  CG1 VAL A  14      -2.950  28.773   8.283  1.00 29.85           C  
ATOM     72  CG2 VAL A  14      -3.853  30.585   9.769  1.00 28.83           C  
ATOM     73  N   ALA A  15      -6.271  26.845   8.955  1.00 28.77           N  
ATOM     74  CA  ALA A  15      -6.351  25.396   8.712  1.00 29.67           C  
ATOM     75  C   ALA A  15      -7.431  25.084   7.723  1.00 30.62           C  
ATOM     76  O   ALA A  15      -7.254  24.215   6.848  1.00 29.86           O  
ATOM     77  CB  ALA A  15      -6.614  24.629  10.024  1.00 30.92           C  
ATOM     78  N   ARG A  16      -8.596  25.730   7.871  1.00 30.00           N  
ATOM     79  CA  ARG A  16      -9.728  25.334   7.004  1.00 29.61           C  
ATOM     80  C   ARG A  16      -9.406  25.401   5.501  1.00 30.60           C  
ATOM     81  O   ARG A  16      -9.692  24.449   4.774  1.00 30.66           O  
ATOM     82  CB  ARG A  16     -11.008  26.157   7.334  1.00 28.18           C  
ATOM     83  CG  ARG A  16     -11.579  25.784   8.695  1.00 26.35           C  
ATOM     84  CD  ARG A  16     -12.992  26.371   8.834  1.00 26.61           C  
ATOM     85  NE  ARG A  16     -13.475  26.103  10.206  1.00 27.94           N  
ATOM     86  CZ  ARG A  16     -14.738  26.256  10.602  1.00 30.77           C  
ATOM     87  NH1 ARG A  16     -15.668  26.737   9.785  1.00 32.19           N  
ATOM     88  NH2 ARG A  16     -15.065  25.999  11.860  1.00 30.96           N  
ATOM     89  N   PRO A  17      -8.780  26.504   5.021  1.00 30.51           N  
ATOM     90  CA  PRO A  17      -8.327  26.573   3.627  1.00 30.69           C  
ATOM     91  C   PRO A  17      -7.323  25.554   3.109  1.00 31.33           C  
ATOM     92  O   PRO A  17      -7.243  25.400   1.879  1.00 32.88           O  
ATOM     93  CB  PRO A  17      -7.613  27.934   3.515  1.00 29.62           C  
ATOM     94  CG  PRO A  17      -8.009  28.724   4.710  1.00 32.16           C  
ATOM     95  CD  PRO A  17      -8.560  27.784   5.748  1.00 31.50           C  
ATOM     96  N   LEU A  18      -6.558  24.897   3.980  1.00 31.08           N  
ATOM     97  CA  LEU A  18      -5.542  23.933   3.511  1.00 29.76           C  
ATOM     98  C   LEU A  18      -6.214  22.681   2.889  1.00 31.11           C  
ATOM     99  O   LEU A  18      -5.600  21.941   2.120  1.00 29.82           O  
ATOM    100  CB  LEU A  18      -4.651  23.522   4.674  1.00 29.83           C  
ATOM    101  CG  LEU A  18      -3.851  24.749   5.245  1.00 27.56           C  
ATOM    102  CD1 LEU A  18      -2.787  24.282   6.225  1.00 31.87           C  
ATOM    103  CD2 LEU A  18      -3.178  25.413   4.104  1.00 26.75           C  
ATOM    104  N   ASP A  19      -7.463  22.432   3.251  1.00 33.34           N  
ATOM    105  CA  ASP A  19      -8.223  21.324   2.621  1.00 35.25           C  
ATOM    106  C   ASP A  19      -8.354  21.547   1.125  1.00 36.03           C  
ATOM    107  O   ASP A  19      -8.568  20.583   0.354  1.00 37.35           O  
ATOM    108  CB  ASP A  19      -9.638  21.259   3.148  1.00 35.41           C  
ATOM    109  CG  ASP A  19      -9.747  20.633   4.486  1.00 36.51           C  
ATOM    110  OD1 ASP A  19      -8.783  20.098   5.032  1.00 35.46           O  
ATOM    111  OD2 ASP A  19     -10.878  20.696   5.010  1.00 42.51           O  
ATOM    112  N   VAL A  20      -8.308  22.807   0.738  1.00 36.58           N  
ATOM    113  CA  VAL A  20      -8.583  23.272  -0.605  1.00 37.54           C  
ATOM    114  C   VAL A  20      -7.315  23.546  -1.384  1.00 37.88           C  
ATOM    115  O   VAL A  20      -7.221  23.160  -2.556  1.00 39.92           O  
ATOM    116  CB  VAL A  20      -9.478  24.536  -0.567  1.00 37.14           C  
ATOM    117  CG1 VAL A  20      -9.891  24.944  -1.955  1.00 37.33           C  
ATOM    118  CG2 VAL A  20     -10.695  24.279   0.290  1.00 37.64           C  
ATOM    119  N   ILE A  21      -6.327  24.161  -0.733  1.00 37.00           N  
ATOM    120  CA  ILE A  21      -5.128  24.576  -1.407  1.00 36.89           C  
ATOM    121  C   ILE A  21      -3.837  23.906  -0.944  1.00 35.16           C  
ATOM    122  O   ILE A  21      -2.795  24.133  -1.537  1.00 34.70           O  
ATOM    123  CB  ILE A  21      -4.947  26.107  -1.312  1.00 37.10           C  
ATOM    124  CG1 ILE A  21      -4.656  26.505   0.129  1.00 37.28           C  
ATOM    125  CG2 ILE A  21      -6.204  26.842  -1.893  1.00 39.18           C  
ATOM    126  CD1 ILE A  21      -4.684  27.952   0.290  1.00 41.70           C  
ATOM    127  N   GLY A  22      -3.920  23.089   0.100  1.00 33.20           N  
ATOM    128  CA  GLY A  22      -2.752  22.410   0.647  1.00 32.51           C  
ATOM    129  C   GLY A  22      -2.416  21.145  -0.117  1.00 32.07           C  
ATOM    130  O   GLY A  22      -2.541  20.038   0.407  1.00 31.25           O  
ATOM    131  N   ASP A  23      -1.942  21.308  -1.349  1.00 31.92           N  
ATOM    132  CA  ASP A  23      -1.520  20.184  -2.177  1.00 32.34           C  
ATOM    133  C   ASP A  23      -0.568  20.765  -3.250  1.00 32.07           C  
ATOM    134  O   ASP A  23      -0.360  21.984  -3.289  1.00 31.33           O  
ATOM    135  CB  ASP A  23      -2.755  19.465  -2.799  1.00 31.77           C  
ATOM    136  CG  ASP A  23      -3.541  20.372  -3.732  1.00 32.14           C  
ATOM    137  OD1 ASP A  23      -3.096  20.559  -4.874  1.00 33.22           O  
ATOM    138  OD2 ASP A  23      -4.602  20.922  -3.336  1.00 35.29           O  
ATOM    139  N   GLY A  24       0.001  19.885  -4.081  1.00 31.80           N  
ATOM    140  CA  GLY A  24       0.952  20.269  -5.115  1.00 31.91           C  
ATOM    141  C   GLY A  24       0.464  20.962  -6.387  1.00 32.58           C  
ATOM    142  O   GLY A  24       1.282  21.313  -7.243  1.00 31.98           O  
ATOM    143  N   TRP A  25      -0.847  21.165  -6.530  1.00 31.97           N  
ATOM    144  CA  TRP A  25      -1.398  21.540  -7.819  1.00 31.86           C  
ATOM    145  C   TRP A  25      -2.500  22.572  -7.811  1.00 30.61           C  
ATOM    146  O   TRP A  25      -2.612  23.327  -8.795  1.00 31.78           O  
ATOM    147  CB  TRP A  25      -1.902  20.317  -8.582  1.00 31.40           C  
ATOM    148  CG  TRP A  25      -0.813  19.358  -8.899  1.00 32.11           C  
ATOM    149  CD1 TRP A  25      -0.497  18.230  -8.220  1.00 32.05           C  
ATOM    150  CD2 TRP A  25       0.099  19.459  -9.987  1.00 30.03           C  
ATOM    151  NE1 TRP A  25       0.585  17.600  -8.822  1.00 31.21           N  
ATOM    152  CE2 TRP A  25       0.968  18.331  -9.915  1.00 32.90           C  
ATOM    153  CE3 TRP A  25       0.294  20.409 -11.009  1.00 32.58           C  
ATOM    154  CZ2 TRP A  25       1.994  18.112 -10.847  1.00 33.58           C  
ATOM    155  CZ3 TRP A  25       1.343  20.187 -11.942  1.00 32.07           C  
ATOM    156  CH2 TRP A  25       2.165  19.041 -11.849  1.00 33.85           C  
ATOM    157  N   SER A  26      -3.324  22.612  -6.758  1.00 31.19           N  
ATOM    158  CA  SER A  26      -4.491  23.548  -6.731  1.00 29.77           C  
ATOM    159  C   SER A  26      -4.117  24.983  -7.047  1.00 30.78           C  
ATOM    160  O   SER A  26      -4.773  25.648  -7.837  1.00 28.95           O  
ATOM    161  CB  SER A  26      -5.297  23.470  -5.428  1.00 31.95           C  
ATOM    162  OG  SER A  26      -5.864  22.155  -5.272  1.00 32.10           O  
HETATM  163  N   MSE A  27      -3.060  25.477  -6.405  1.00 29.59           N  
HETATM  164  CA  MSE A  27      -2.667  26.851  -6.633  1.00 30.45           C  
HETATM  165  C   MSE A  27      -2.040  27.046  -8.013  1.00 29.55           C  
HETATM  166  O   MSE A  27      -1.947  28.193  -8.461  1.00 31.81           O  
HETATM  167  CB  MSE A  27      -1.750  27.371  -5.521  1.00 30.18           C  
HETATM  168  CG  MSE A  27      -2.448  27.496  -4.161  1.00 29.90           C  
HETATM  169 SE   MSE A  27      -3.993  28.627  -4.090  1.00 39.66          SE  
HETATM  170  CE  MSE A  27      -3.172  30.396  -4.830  1.00 35.69           C  
ATOM    171  N   LEU A  28      -1.642  25.964  -8.699  1.00 28.91           N  
ATOM    172  CA  LEU A  28      -1.221  26.110 -10.080  1.00 28.45           C  
ATOM    173  C   LEU A  28      -2.370  26.160 -11.101  1.00 29.78           C  
ATOM    174  O   LEU A  28      -2.269  26.833 -12.133  1.00 27.97           O  
ATOM    175  CB  LEU A  28      -0.201  25.017 -10.468  1.00 29.16           C  
ATOM    176  CG  LEU A  28       1.034  24.856  -9.566  1.00 30.16           C  
ATOM    177  CD1 LEU A  28       1.982  23.842 -10.157  1.00 29.70           C  
ATOM    178  CD2 LEU A  28       1.749  26.171  -9.285  1.00 32.81           C  
ATOM    179  N   ILE A  29      -3.420  25.393 -10.832  1.00 29.05           N  
ATOM    180  CA  ILE A  29      -4.654  25.544 -11.573  1.00 28.32           C  
ATOM    181  C   ILE A  29      -5.137  27.000 -11.403  1.00 28.84           C  
ATOM    182  O   ILE A  29      -5.494  27.672 -12.374  1.00 27.24           O  
ATOM    183  CB  ILE A  29      -5.672  24.511 -11.127  1.00 29.58           C  
ATOM    184  CG1 ILE A  29      -5.174  23.100 -11.503  1.00 28.44           C  
ATOM    185  CG2 ILE A  29      -7.034  24.810 -11.765  1.00 26.92           C  
ATOM    186  CD1 ILE A  29      -5.993  21.965 -10.812  1.00 34.19           C  
ATOM    187  N   VAL A  30      -5.108  27.503 -10.166  1.00 28.18           N  
ATOM    188  CA  VAL A  30      -5.541  28.878  -9.907  1.00 28.93           C  
ATOM    189  C   VAL A  30      -4.594  29.872 -10.609  1.00 28.71           C  
ATOM    190  O   VAL A  30      -5.042  30.865 -11.148  1.00 29.80           O  
ATOM    191  CB  VAL A  30      -5.609  29.177  -8.357  1.00 29.43           C  
ATOM    192  CG1 VAL A  30      -5.938  30.668  -8.098  1.00 29.52           C  
ATOM    193  CG2 VAL A  30      -6.733  28.328  -7.735  1.00 31.39           C  
ATOM    194  N   ARG A  31      -3.289  29.623 -10.540  1.00 30.29           N  
ATOM    195  CA  ARG A  31      -2.310  30.412 -11.305  1.00 30.55           C  
ATOM    196  C   ARG A  31      -2.731  30.576 -12.771  1.00 31.22           C  
ATOM    197  O   ARG A  31      -2.736  31.691 -13.338  1.00 30.27           O  
ATOM    198  CB  ARG A  31      -0.953  29.740 -11.229  1.00 31.29           C  
ATOM    199  CG  ARG A  31       0.179  30.419 -12.054  1.00 30.63           C  
ATOM    200  CD  ARG A  31       1.335  29.418 -12.261  1.00 33.11           C  
ATOM    201  NE  ARG A  31       0.926  28.341 -13.219  1.00 29.48           N  
ATOM    202  CZ  ARG A  31       1.633  27.264 -13.487  1.00 30.91           C  
ATOM    203  NH1 ARG A  31       2.819  27.062 -12.892  1.00 32.61           N  
ATOM    204  NH2 ARG A  31       1.164  26.376 -14.381  1.00 33.95           N  
ATOM    205  N   ASP A  32      -3.053  29.438 -13.380  1.00 29.84           N  
ATOM    206  CA  ASP A  32      -3.441  29.388 -14.789  1.00 29.84           C  
ATOM    207  C   ASP A  32      -4.751  30.106 -15.081  1.00 29.39           C  
ATOM    208  O   ASP A  32      -4.872  30.740 -16.103  1.00 29.63           O  
ATOM    209  CB  ASP A  32      -3.510  27.940 -15.243  1.00 29.60           C  
ATOM    210  CG  ASP A  32      -2.139  27.335 -15.498  1.00 31.02           C  
ATOM    211  OD1 ASP A  32      -1.098  28.039 -15.447  1.00 31.66           O  
ATOM    212  OD2 ASP A  32      -2.103  26.126 -15.760  1.00 33.30           O  
ATOM    213  N   ALA A  33      -5.695  30.026 -14.153  1.00 29.54           N  
ATOM    214  CA  ALA A  33      -7.000  30.697 -14.255  1.00 29.17           C  
ATOM    215  C   ALA A  33      -6.778  32.188 -14.329  1.00 30.13           C  
ATOM    216  O   ALA A  33      -7.383  32.879 -15.127  1.00 28.70           O  
ATOM    217  CB  ALA A  33      -7.855  30.355 -13.054  1.00 28.98           C  
ATOM    218  N   PHE A  34      -5.864  32.674 -13.492  1.00 30.08           N  
ATOM    219  CA  PHE A  34      -5.551  34.117 -13.495  1.00 32.04           C  
ATOM    220  C   PHE A  34      -4.862  34.530 -14.781  1.00 33.21           C  
ATOM    221  O   PHE A  34      -4.907  35.698 -15.159  1.00 35.06           O  
ATOM    222  CB  PHE A  34      -4.714  34.474 -12.316  1.00 29.43           C  
ATOM    223  CG  PHE A  34      -5.524  34.725 -11.065  1.00 30.15           C  
ATOM    224  CD1 PHE A  34      -6.368  35.862 -10.959  1.00 29.32           C  
ATOM    225  CD2 PHE A  34      -5.455  33.845 -10.008  1.00 27.36           C  
ATOM    226  CE1 PHE A  34      -7.104  36.078  -9.794  1.00 32.30           C  
ATOM    227  CE2 PHE A  34      -6.217  34.018  -8.866  1.00 27.56           C  
ATOM    228  CZ  PHE A  34      -7.043  35.159  -8.753  1.00 30.72           C  
ATOM    229  N   GLU A  35      -4.273  33.558 -15.474  1.00 33.78           N  
ATOM    230  CA  GLU A  35      -3.654  33.814 -16.765  1.00 34.98           C  
ATOM    231  C   GLU A  35      -4.613  33.575 -17.939  1.00 34.88           C  
ATOM    232  O   GLU A  35      -4.230  33.706 -19.108  1.00 36.76           O  
ATOM    233  CB  GLU A  35      -2.317  33.070 -16.883  1.00 34.55           C  
ATOM    234  CG  GLU A  35      -1.198  33.810 -16.001  1.00 37.64           C  
ATOM    235  CD  GLU A  35       0.084  32.979 -15.808  1.00 37.28           C  
ATOM    236  OE1 GLU A  35       0.674  32.524 -16.809  1.00 41.56           O  
ATOM    237  OE2 GLU A  35       0.503  32.753 -14.651  1.00 38.77           O  
ATOM    238  N   GLY A  36      -5.864  33.258 -17.629  1.00 31.95           N  
ATOM    239  CA  GLY A  36      -6.893  33.254 -18.648  1.00 32.42           C  
ATOM    240  C   GLY A  36      -7.219  31.893 -19.212  1.00 31.14           C  
ATOM    241  O   GLY A  36      -7.989  31.810 -20.155  1.00 32.28           O  
ATOM    242  N   LEU A  37      -6.607  30.832 -18.680  1.00 30.20           N  
ATOM    243  CA  LEU A  37      -7.010  29.487 -19.066  1.00 29.32           C  
ATOM    244  C   LEU A  37      -8.372  29.130 -18.481  1.00 29.70           C  
ATOM    245  O   LEU A  37      -8.637  29.417 -17.299  1.00 31.56           O  
ATOM    246  CB  LEU A  37      -5.961  28.425 -18.724  1.00 28.49           C  
ATOM    247  CG  LEU A  37      -4.508  28.549 -19.202  1.00 31.36           C  
ATOM    248  CD1 LEU A  37      -3.757  27.238 -18.974  1.00 27.78           C  
ATOM    249  CD2 LEU A  37      -4.423  28.922 -20.686  1.00 33.69           C  
ATOM    250  N   THR A  38      -9.243  28.541 -19.305  1.00 29.33           N  
ATOM    251  CA  THR A  38     -10.567  28.128 -18.817  1.00 30.85           C  
ATOM    252  C   THR A  38     -10.945  26.706 -19.234  1.00 31.63           C  
ATOM    253  O   THR A  38     -11.872  26.104 -18.664  1.00 33.23           O  
ATOM    254  CB  THR A  38     -11.681  29.077 -19.309  1.00 30.66           C  
ATOM    255  OG1 THR A  38     -11.824  28.963 -20.741  1.00 32.66           O  
ATOM    256  CG2 THR A  38     -11.389  30.514 -18.921  1.00 34.35           C  
ATOM    257  N   ARG A  39     -10.252  26.162 -20.219  1.00 31.62           N  
ATOM    258  CA  ARG A  39     -10.673  24.869 -20.762  1.00 31.37           C  
ATOM    259  C   ARG A  39      -9.820  23.743 -20.245  1.00 30.82           C  
ATOM    260  O   ARG A  39      -8.618  23.923 -20.039  1.00 29.68           O  
ATOM    261  CB  ARG A  39     -10.652  24.877 -22.295  1.00 32.83           C  
ATOM    262  CG  ARG A  39     -11.866  25.541 -22.923  1.00 33.91           C  
ATOM    263  CD  ARG A  39     -11.717  25.560 -24.419  1.00 36.94           C  
ATOM    264  NE  ARG A  39     -12.086  24.275 -25.029  1.00 37.45           N  
ATOM    265  CZ  ARG A  39     -12.436  24.124 -26.300  1.00 40.29           C  
ATOM    266  NH1 ARG A  39     -12.464  25.173 -27.119  1.00 40.77           N  
ATOM    267  NH2 ARG A  39     -12.745  22.913 -26.759  1.00 37.24           N  
ATOM    268  N   PHE A  40     -10.448  22.579 -20.063  1.00 30.13           N  
ATOM    269  CA  PHE A  40      -9.776  21.416 -19.559  1.00 30.37           C  
ATOM    270  C   PHE A  40      -8.458  21.208 -20.355  1.00 29.62           C  
ATOM    271  O   PHE A  40      -7.389  21.053 -19.743  1.00 30.46           O  
ATOM    272  CB  PHE A  40     -10.673  20.154 -19.695  1.00 30.82           C  
ATOM    273  CG  PHE A  40     -10.090  18.951 -19.007  1.00 31.75           C  
ATOM    274  CD1 PHE A  40     -10.321  18.744 -17.640  1.00 30.13           C  
ATOM    275  CD2 PHE A  40      -9.241  18.091 -19.692  1.00 31.39           C  
ATOM    276  CE1 PHE A  40      -9.728  17.696 -16.982  1.00 31.41           C  
ATOM    277  CE2 PHE A  40      -8.635  17.045 -19.046  1.00 33.96           C  
ATOM    278  CZ  PHE A  40      -8.886  16.847 -17.673  1.00 30.01           C  
ATOM    279  N   GLY A  41      -8.547  21.191 -21.695  1.00 29.69           N  
ATOM    280  CA  GLY A  41      -7.359  20.955 -22.552  1.00 30.06           C  
ATOM    281  C   GLY A  41      -6.230  21.968 -22.320  1.00 30.01           C  
ATOM    282  O   GLY A  41      -5.041  21.647 -22.467  1.00 29.32           O  
ATOM    283  N   GLU A  42      -6.612  23.199 -21.980  1.00 29.76           N  
ATOM    284  CA  GLU A  42      -5.617  24.237 -21.707  1.00 29.64           C  
ATOM    285  C   GLU A  42      -4.880  23.921 -20.405  1.00 29.81           C  
ATOM    286  O   GLU A  42      -3.614  23.918 -20.352  1.00 28.86           O  
ATOM    287  CB  GLU A  42      -6.293  25.622 -21.627  1.00 30.61           C  
ATOM    288  CG  GLU A  42      -6.802  26.082 -22.978  1.00 29.34           C  
ATOM    289  CD  GLU A  42      -7.797  27.232 -22.897  1.00 33.93           C  
ATOM    290  OE1 GLU A  42      -8.240  27.560 -21.808  1.00 30.43           O  
ATOM    291  OE2 GLU A  42      -8.179  27.779 -23.949  1.00 38.50           O  
ATOM    292  N   PHE A  43      -5.631  23.594 -19.354  1.00 28.44           N  
ATOM    293  CA  PHE A  43      -4.947  23.239 -18.091  1.00 28.27           C  
ATOM    294  C   PHE A  43      -4.027  22.015 -18.263  1.00 29.04           C  
ATOM    295  O   PHE A  43      -2.935  21.989 -17.684  1.00 28.83           O  
ATOM    296  CB  PHE A  43      -5.922  22.985 -16.930  1.00 27.43           C  
ATOM    297  CG  PHE A  43      -6.723  24.192 -16.527  1.00 27.90           C  
ATOM    298  CD1 PHE A  43      -6.136  25.227 -15.750  1.00 30.45           C  
ATOM    299  CD2 PHE A  43      -8.069  24.312 -16.913  1.00 27.76           C  
ATOM    300  CE1 PHE A  43      -6.909  26.320 -15.360  1.00 29.25           C  
ATOM    301  CE2 PHE A  43      -8.833  25.410 -16.537  1.00 32.79           C  
ATOM    302  CZ  PHE A  43      -8.236  26.429 -15.758  1.00 27.62           C  
ATOM    303  N   GLN A  44      -4.481  21.029 -19.041  1.00 30.34           N  
ATOM    304  CA  GLN A  44      -3.737  19.798 -19.261  1.00 32.71           C  
ATOM    305  C   GLN A  44      -2.406  20.034 -19.961  1.00 33.49           C  
ATOM    306  O   GLN A  44      -1.385  19.495 -19.527  1.00 35.09           O  
ATOM    307  CB  GLN A  44      -4.585  18.765 -20.011  1.00 33.87           C  
ATOM    308  CG  GLN A  44      -4.321  17.369 -19.523  1.00 38.03           C  
ATOM    309  CD  GLN A  44      -2.926  16.950 -19.848  1.00 42.41           C  
ATOM    310  OE1 GLN A  44      -2.510  17.012 -21.008  1.00 45.75           O  
ATOM    311  NE2 GLN A  44      -2.171  16.545 -18.833  1.00 41.94           N  
ATOM    312  N   LYS A  45      -2.399  20.817 -21.036  1.00 33.59           N  
ATOM    313  CA  LYS A  45      -1.148  21.152 -21.720  1.00 33.55           C  
ATOM    314  C   LYS A  45      -0.221  22.020 -20.860  1.00 33.14           C  
ATOM    315  O   LYS A  45       0.974  21.824 -20.876  1.00 31.32           O  
ATOM    316  CB  LYS A  45      -1.416  21.852 -23.039  1.00 34.76           C  
ATOM    317  CG  LYS A  45      -1.716  20.881 -24.170  1.00 38.15           C  
ATOM    318  CD  LYS A  45      -1.511  21.500 -25.541  1.00 45.26           C  
ATOM    319  CE  LYS A  45      -2.404  22.727 -25.759  1.00 47.06           C  
ATOM    320  NZ  LYS A  45      -2.407  22.997 -27.229  1.00 49.41           N  
ATOM    321  N   SER A  46      -0.787  22.985 -20.121  1.00 32.71           N  
ATOM    322  CA  SER A  46      -0.031  23.790 -19.166  1.00 33.99           C  
ATOM    323  C   SER A  46       0.603  22.982 -18.023  1.00 34.58           C  
ATOM    324  O   SER A  46       1.807  23.169 -17.706  1.00 35.74           O  
ATOM    325  CB  SER A  46      -0.902  24.932 -18.585  1.00 32.32           C  
ATOM    326  OG  SER A  46      -0.288  25.486 -17.402  1.00 35.45           O  
ATOM    327  N   LEU A  47      -0.178  22.120 -17.376  1.00 34.42           N  
ATOM    328  CA  LEU A  47       0.282  21.490 -16.139  1.00 35.68           C  
ATOM    329  C   LEU A  47       0.978  20.143 -16.314  1.00 37.23           C  
ATOM    330  O   LEU A  47       1.660  19.687 -15.397  1.00 37.22           O  
ATOM    331  CB  LEU A  47      -0.858  21.378 -15.112  1.00 36.00           C  
ATOM    332  CG  LEU A  47      -1.525  22.730 -14.802  1.00 34.78           C  
ATOM    333  CD1 LEU A  47      -2.969  22.620 -14.259  1.00 36.70           C  
ATOM    334  CD2 LEU A  47      -0.652  23.506 -13.825  1.00 31.79           C  
ATOM    335  N   GLY A  48       0.808  19.499 -17.464  1.00 37.81           N  
ATOM    336  CA  GLY A  48       1.437  18.203 -17.692  1.00 40.48           C  
ATOM    337  C   GLY A  48       1.013  17.212 -16.617  1.00 41.64           C  
ATOM    338  O   GLY A  48       1.695  16.233 -16.332  1.00 42.54           O  
ATOM    339  N   LEU A  49      -0.133  17.483 -16.008  1.00 41.41           N  
ATOM    340  CA  LEU A  49      -0.676  16.616 -14.975  1.00 40.86           C  
ATOM    341  C   LEU A  49      -1.531  15.565 -15.667  1.00 41.15           C  
ATOM    342  O   LEU A  49      -2.275  15.901 -16.578  1.00 41.08           O  
ATOM    343  CB  LEU A  49      -1.496  17.501 -13.987  1.00 40.50           C  
ATOM    344  CG  LEU A  49      -2.200  16.859 -12.801  1.00 39.90           C  
ATOM    345  CD1 LEU A  49      -1.245  16.221 -11.806  1.00 40.25           C  
ATOM    346  CD2 LEU A  49      -3.053  17.890 -12.130  1.00 38.21           C  
ATOM    347  N   ALA A  50      -1.409  14.292 -15.273  1.00 41.26           N  
ATOM    348  CA  ALA A  50      -2.251  13.246 -15.816  1.00 41.28           C  
ATOM    349  C   ALA A  50      -3.718  13.672 -15.832  1.00 41.52           C  
ATOM    350  O   ALA A  50      -4.238  14.244 -14.875  1.00 41.49           O  
ATOM    351  CB  ALA A  50      -2.065  11.917 -15.077  1.00 41.16           C  
ATOM    352  N   LYS A  51      -4.360  13.372 -16.950  1.00 41.56           N  
ATOM    353  CA  LYS A  51      -5.667  13.886 -17.293  1.00 41.24           C  
ATOM    354  C   LYS A  51      -6.739  13.536 -16.261  1.00 40.78           C  
ATOM    355  O   LYS A  51      -7.416  14.405 -15.727  1.00 39.07           O  
ATOM    356  CB  LYS A  51      -6.025  13.326 -18.659  1.00 41.88           C  
ATOM    357  CG  LYS A  51      -7.305  13.833 -19.223  1.00 42.48           C  
ATOM    358  CD  LYS A  51      -7.822  12.908 -20.254  1.00 42.32           C  
ATOM    359  CE  LYS A  51      -8.281  11.645 -19.613  1.00 43.63           C  
ATOM    360  NZ  LYS A  51      -8.003  10.540 -20.534  1.00 43.77           N  
ATOM    361  N   ASN A  52      -6.917  12.251 -16.002  1.00 39.93           N  
ATOM    362  CA  ASN A  52      -7.857  11.820 -14.975  1.00 40.04           C  
ATOM    363  C   ASN A  52      -7.667  12.547 -13.640  1.00 39.44           C  
ATOM    364  O   ASN A  52      -8.646  12.977 -13.003  1.00 38.39           O  
ATOM    365  CB  ASN A  52      -7.757  10.325 -14.813  1.00 39.41           C  
ATOM    366  CG  ASN A  52      -8.437   9.600 -15.946  1.00 41.34           C  
ATOM    367  OD1 ASN A  52      -9.287  10.187 -16.642  1.00 40.22           O  
ATOM    368  ND2 ASN A  52      -8.073   8.328 -16.157  1.00 42.03           N  
ATOM    369  N   ILE A  53      -6.408  12.716 -13.249  1.00 40.32           N  
ATOM    370  CA  ILE A  53      -6.042  13.409 -12.000  1.00 39.56           C  
ATOM    371  C   ILE A  53      -6.253  14.949 -12.011  1.00 39.64           C  
ATOM    372  O   ILE A  53      -6.626  15.584 -10.973  1.00 39.14           O  
ATOM    373  CB  ILE A  53      -4.566  13.110 -11.668  1.00 41.19           C  
ATOM    374  CG1 ILE A  53      -4.276  11.598 -11.693  1.00 41.58           C  
ATOM    375  CG2 ILE A  53      -4.132  13.812 -10.374  1.00 39.95           C  
ATOM    376  CD1 ILE A  53      -5.051  10.747 -10.704  1.00 44.31           C  
ATOM    377  N   LEU A  54      -5.972  15.571 -13.155  1.00 37.92           N  
ATOM    378  CA  LEU A  54      -6.275  16.988 -13.324  1.00 36.16           C  
ATOM    379  C   LEU A  54      -7.772  17.168 -13.174  1.00 34.75           C  
ATOM    380  O   LEU A  54      -8.232  18.085 -12.539  1.00 33.24           O  
ATOM    381  CB  LEU A  54      -5.848  17.459 -14.712  1.00 36.32           C  
ATOM    382  CG  LEU A  54      -6.397  18.818 -15.177  1.00 36.29           C  
ATOM    383  CD1 LEU A  54      -6.017  19.999 -14.268  1.00 36.21           C  
ATOM    384  CD2 LEU A  54      -5.902  19.023 -16.594  1.00 35.17           C  
ATOM    385  N   ALA A  55      -8.525  16.249 -13.796  1.00 34.06           N  
ATOM    386  CA  ALA A  55      -9.979  16.232 -13.755  1.00 34.47           C  
ATOM    387  C   ALA A  55     -10.458  16.200 -12.315  1.00 35.40           C  
ATOM    388  O   ALA A  55     -11.364  16.935 -11.953  1.00 36.18           O  
ATOM    389  CB  ALA A  55     -10.515  14.959 -14.555  1.00 33.80           C  
ATOM    390  N   ALA A  56      -9.877  15.323 -11.497  1.00 37.59           N  
ATOM    391  CA  ALA A  56     -10.227  15.268 -10.069  1.00 38.20           C  
ATOM    392  C   ALA A  56      -9.973  16.589  -9.303  1.00 38.33           C  
ATOM    393  O   ALA A  56     -10.821  17.024  -8.540  1.00 38.12           O  
ATOM    394  CB  ALA A  56      -9.542  14.121  -9.380  1.00 38.92           C  
ATOM    395  N   ARG A  57      -8.814  17.214  -9.497  1.00 38.74           N  
ATOM    396  CA  ARG A  57      -8.481  18.431  -8.768  1.00 38.39           C  
ATOM    397  C   ARG A  57      -9.401  19.555  -9.188  1.00 36.30           C  
ATOM    398  O   ARG A  57      -9.733  20.417  -8.379  1.00 35.85           O  
ATOM    399  CB  ARG A  57      -7.048  18.848  -9.049  1.00 38.98           C  
ATOM    400  CG  ARG A  57      -6.103  17.761  -8.678  1.00 43.14           C  
ATOM    401  CD  ARG A  57      -4.930  18.279  -7.943  1.00 47.81           C  
ATOM    402  NE  ARG A  57      -4.213  17.170  -7.306  1.00 55.13           N  
ATOM    403  CZ  ARG A  57      -4.082  17.028  -5.989  1.00 56.60           C  
ATOM    404  NH1 ARG A  57      -4.606  17.934  -5.183  1.00 60.01           N  
ATOM    405  NH2 ARG A  57      -3.417  15.994  -5.477  1.00 57.67           N  
ATOM    406  N   LEU A  58      -9.778  19.551 -10.463  1.00 34.74           N  
ATOM    407  CA  LEU A  58     -10.660  20.611 -10.970  1.00 33.87           C  
ATOM    408  C   LEU A  58     -12.015  20.427 -10.302  1.00 33.75           C  
ATOM    409  O   LEU A  58     -12.552  21.347  -9.717  1.00 32.13           O  
ATOM    410  CB  LEU A  58     -10.810  20.561 -12.490  1.00 33.79           C  
ATOM    411  CG  LEU A  58      -9.653  21.214 -13.243  1.00 32.60           C  
ATOM    412  CD1 LEU A  58      -9.678  20.688 -14.700  1.00 33.66           C  
ATOM    413  CD2 LEU A  58      -9.787  22.725 -13.189  1.00 33.63           C  
ATOM    414  N   ARG A  59     -12.563  19.209 -10.424  1.00 34.55           N  
ATOM    415  CA  ARG A  59     -13.860  18.894  -9.808  1.00 34.58           C  
ATOM    416  C   ARG A  59     -13.808  19.258  -8.318  1.00 34.41           C  
ATOM    417  O   ARG A  59     -14.743  19.791  -7.751  1.00 33.67           O  
ATOM    418  CB  ARG A  59     -14.268  17.414 -10.049  1.00 34.15           C  
ATOM    419  CG  ARG A  59     -14.767  17.134 -11.478  1.00 33.48           C  
ATOM    420  CD  ARG A  59     -15.431  15.720 -11.618  1.00 33.78           C  
ATOM    421  NE  ARG A  59     -14.479  14.671 -11.244  1.00 33.92           N  
ATOM    422  CZ  ARG A  59     -13.734  13.959 -12.095  1.00 32.60           C  
ATOM    423  NH1 ARG A  59     -13.834  14.161 -13.402  1.00 31.58           N  
ATOM    424  NH2 ARG A  59     -12.911  13.009 -11.633  1.00 32.66           N  
ATOM    425  N   ASN A  60     -12.693  19.004  -7.670  1.00 35.77           N  
ATOM    426  CA  ASN A  60     -12.571  19.441  -6.261  1.00 36.70           C  
ATOM    427  C   ASN A  60     -12.505  20.959  -5.940  1.00 36.23           C  
ATOM    428  O   ASN A  60     -13.090  21.427  -4.953  1.00 35.77           O  
ATOM    429  CB  ASN A  60     -11.406  18.761  -5.601  1.00 38.90           C  
ATOM    430  CG  ASN A  60     -11.455  18.897  -4.106  1.00 44.08           C  
ATOM    431  OD1 ASN A  60     -10.526  19.420  -3.502  1.00 46.03           O  
ATOM    432  ND2 ASN A  60     -12.585  18.459  -3.495  1.00 49.04           N  
ATOM    433  N   LEU A  61     -11.813  21.733  -6.765  1.00 35.10           N  
ATOM    434  CA  LEU A  61     -11.965  23.199  -6.726  1.00 33.15           C  
ATOM    435  C   LEU A  61     -13.386  23.701  -6.938  1.00 32.19           C  
ATOM    436  O   LEU A  61     -13.804  24.694  -6.345  1.00 33.26           O  
ATOM    437  CB  LEU A  61     -10.980  23.892  -7.682  1.00 34.02           C  
ATOM    438  CG  LEU A  61      -9.509  23.726  -7.236  1.00 31.60           C  
ATOM    439  CD1 LEU A  61      -8.550  24.031  -8.391  1.00 30.99           C  
ATOM    440  CD2 LEU A  61      -9.133  24.565  -5.997  1.00 36.36           C  
ATOM    441  N   VAL A  62     -14.133  23.011  -7.796  1.00 33.15           N  
ATOM    442  CA  VAL A  62     -15.526  23.325  -8.000  1.00 33.30           C  
ATOM    443  C   VAL A  62     -16.325  23.050  -6.731  1.00 33.31           C  
ATOM    444  O   VAL A  62     -17.077  23.891  -6.287  1.00 33.54           O  
ATOM    445  CB  VAL A  62     -16.074  22.546  -9.246  1.00 33.02           C  
ATOM    446  CG1 VAL A  62     -17.547  22.803  -9.389  1.00 35.98           C  
ATOM    447  CG2 VAL A  62     -15.340  23.005 -10.495  1.00 30.07           C  
ATOM    448  N   GLU A  63     -16.119  21.883  -6.126  1.00 35.33           N  
ATOM    449  CA  GLU A  63     -16.834  21.514  -4.906  1.00 37.49           C  
ATOM    450  C   GLU A  63     -16.569  22.486  -3.747  1.00 37.68           C  
ATOM    451  O   GLU A  63     -17.478  22.816  -2.986  1.00 38.33           O  
ATOM    452  CB  GLU A  63     -16.587  20.025  -4.537  1.00 38.10           C  
ATOM    453  CG  GLU A  63     -17.525  19.470  -3.454  1.00 40.53           C  
ATOM    454  CD  GLU A  63     -18.939  19.152  -3.968  1.00 45.61           C  
ATOM    455  OE1 GLU A  63     -19.153  18.983  -4.692  0.00 49.55           O  
ATOM    456  OE2 GLU A  63     -19.430  19.497  -2.558  0.00 50.10           O  
ATOM    457  N   HIS A  64     -15.335  22.978  -3.647  1.00 37.39           N  
ATOM    458  CA  HIS A  64     -14.942  23.918  -2.605  1.00 38.02           C  
ATOM    459  C   HIS A  64     -15.310  25.350  -2.961  1.00 37.13           C  
ATOM    460  O   HIS A  64     -14.993  26.285  -2.214  1.00 38.42           O  
ATOM    461  CB  HIS A  64     -13.448  23.808  -2.308  1.00 39.53           C  
ATOM    462  CG  HIS A  64     -13.053  22.524  -1.639  1.00 43.68           C  
ATOM    463  ND1 HIS A  64     -13.436  22.206  -0.354  1.00 47.84           N  
ATOM    464  CD2 HIS A  64     -12.292  21.488  -2.071  1.00 46.58           C  
ATOM    465  CE1 HIS A  64     -12.951  21.018  -0.032  1.00 48.60           C  
ATOM    466  NE2 HIS A  64     -12.237  20.572  -1.048  1.00 49.16           N  
ATOM    467  N   GLY A  65     -15.961  25.559  -4.102  1.00 34.99           N  
ATOM    468  CA  GLY A  65     -16.434  26.918  -4.437  1.00 33.80           C  
ATOM    469  C   GLY A  65     -15.405  27.899  -4.983  1.00 30.48           C  
ATOM    470  O   GLY A  65     -15.657  29.111  -5.076  1.00 32.30           O  
ATOM    471  N   VAL A  66     -14.242  27.394  -5.366  1.00 30.92           N  
ATOM    472  CA  VAL A  66     -13.139  28.234  -5.879  1.00 30.27           C  
ATOM    473  C   VAL A  66     -13.366  28.487  -7.389  1.00 31.60           C  
ATOM    474  O   VAL A  66     -12.988  29.526  -7.939  1.00 30.28           O  
ATOM    475  CB  VAL A  66     -11.824  27.507  -5.644  1.00 30.49           C  
ATOM    476  CG1 VAL A  66     -10.657  28.235  -6.308  1.00 30.98           C  
ATOM    477  CG2 VAL A  66     -11.604  27.356  -4.149  1.00 30.34           C  
HETATM  478  N   MSE A  67     -13.962  27.502  -8.058  1.00 30.65           N  
HETATM  479  CA  MSE A  67     -14.377  27.687  -9.442  1.00 34.28           C  
HETATM  480  C   MSE A  67     -15.764  27.164  -9.679  1.00 30.88           C  
HETATM  481  O   MSE A  67     -16.334  26.441  -8.830  1.00 29.89           O  
HETATM  482  CB  MSE A  67     -13.455  26.882 -10.380  1.00 33.25           C  
HETATM  483  CG  MSE A  67     -12.015  27.227 -10.184  1.00 35.69           C  
HETATM  484 SE   MSE A  67     -10.976  26.074 -11.250  1.00 47.90          SE  
HETATM  485  CE  MSE A  67     -10.426  27.625 -12.313  1.00 40.56           C  
ATOM    486  N   VAL A  68     -16.306  27.527 -10.852  1.00 30.19           N  
ATOM    487  CA  VAL A  68     -17.491  26.797 -11.417  1.00 30.40           C  
ATOM    488  C   VAL A  68     -17.172  26.222 -12.778  1.00 30.07           C  
ATOM    489  O   VAL A  68     -16.263  26.683 -13.442  1.00 31.05           O  
ATOM    490  CB  VAL A  68     -18.749  27.700 -11.525  1.00 30.47           C  
ATOM    491  CG1 VAL A  68     -19.235  28.134 -10.138  1.00 32.11           C  
ATOM    492  CG2 VAL A  68     -18.449  28.961 -12.368  1.00 32.42           C  
ATOM    493  N   ALA A  69     -17.881  25.159 -13.175  1.00 28.78           N  
ATOM    494  CA  ALA A  69     -17.701  24.537 -14.480  1.00 29.10           C  
ATOM    495  C   ALA A  69     -19.003  24.777 -15.198  1.00 28.79           C  
ATOM    496  O   ALA A  69     -20.012  24.284 -14.759  1.00 29.67           O  
ATOM    497  CB  ALA A  69     -17.448  23.002 -14.327  1.00 28.93           C  
ATOM    498  N   VAL A  70     -19.029  25.627 -16.208  1.00 28.77           N  
ATOM    499  CA  VAL A  70     -20.305  25.950 -16.890  1.00 29.19           C  
ATOM    500  C   VAL A  70     -20.165  25.709 -18.393  1.00 29.48           C  
ATOM    501  O   VAL A  70     -19.055  25.784 -18.932  1.00 27.96           O  
ATOM    502  CB  VAL A  70     -20.794  27.419 -16.606  1.00 30.53           C  
ATOM    503  CG1 VAL A  70     -21.160  27.636 -15.101  1.00 30.77           C  
ATOM    504  CG2 VAL A  70     -19.707  28.408 -16.955  1.00 32.96           C  
ATOM    505  N   PRO A  71     -21.271  25.363 -19.064  1.00 30.30           N  
ATOM    506  CA  PRO A  71     -21.203  25.211 -20.519  1.00 30.95           C  
ATOM    507  C   PRO A  71     -20.711  26.504 -21.189  1.00 33.66           C  
ATOM    508  O   PRO A  71     -21.153  27.592 -20.840  1.00 33.86           O  
ATOM    509  CB  PRO A  71     -22.639  24.871 -20.918  1.00 31.65           C  
ATOM    510  CG  PRO A  71     -23.482  25.151 -19.737  1.00 30.35           C  
ATOM    511  CD  PRO A  71     -22.627  25.127 -18.523  1.00 29.83           C  
ATOM    512  N   ALA A  72     -19.778  26.394 -22.122  1.00 36.03           N  
ATOM    513  CA  ALA A  72     -19.436  27.544 -22.946  1.00 38.94           C  
ATOM    514  C   ALA A  72     -20.696  28.092 -23.638  1.00 40.38           C  
ATOM    515  O   ALA A  72     -21.528  27.328 -24.117  1.00 40.81           O  
ATOM    516  CB  ALA A  72     -18.376  27.176 -23.948  1.00 39.22           C  
ATOM    517  N   GLU A  73     -20.835  29.421 -23.628  1.00 42.72           N  
ATOM    518  CA  GLU A  73     -22.007  30.149 -24.150  1.00 44.33           C  
ATOM    519  C   GLU A  73     -22.215  30.047 -25.654  1.00 45.54           C  
ATOM    520  O   GLU A  73     -23.288  30.385 -26.168  1.00 45.70           O  
ATOM    521  CB  GLU A  73     -21.552  31.695 -23.967  0.00 42.75           C  
ATOM    522  CG  GLU A  73     -21.066  32.026 -22.561  0.00 45.91           C  
ATOM    523  CD  GLU A  73     -20.812  33.508 -22.355  0.00 47.03           C  
ATOM    524  OE1 GLU A  73     -20.041  34.097 -23.138  0.00 49.99           O  
ATOM    525  OE2 GLU A  73     -21.393  34.077 -21.413  0.00 48.97           O  
ATOM    526  N   SER A  74     -21.183  29.609 -26.361  1.00 46.77           N  
ATOM    527  CA  SER A  74     -21.310  29.269 -27.773  1.00 47.60           C  
ATOM    528  C   SER A  74     -20.449  28.045 -27.958  1.00 48.49           C  
ATOM    529  O   SER A  74     -19.215  28.117 -27.899  1.00 49.07           O  
ATOM    530  CB  SER A  74     -21.001  30.219 -28.686  0.00 46.81           C  
ATOM    531  OG  SER A  74     -21.528  29.882 -29.956  0.00 49.15           O  
ATOM    532  N   GLY A  75     -21.096  26.903 -28.129  1.00 48.81           N  
ATOM    533  CA  GLY A  75     -20.350  25.691 -28.430  1.00 49.06           C  
ATOM    534  C   GLY A  75     -20.531  24.544 -27.468  1.00 48.50           C  
ATOM    535  O   GLY A  75     -21.270  24.630 -26.472  1.00 49.43           O  
ATOM    536  N   SER A  76     -19.822  23.470 -27.787  1.00 47.17           N  
ATOM    537  CA  SER A  76     -19.990  22.187 -27.149  1.00 45.55           C  
ATOM    538  C   SER A  76     -18.766  21.868 -26.312  1.00 43.85           C  
ATOM    539  O   SER A  76     -18.039  20.925 -26.628  1.00 44.17           O  
ATOM    540  CB  SER A  76     -20.179  21.127 -28.238  1.00 46.19           C  
ATOM    541  OG  SER A  76     -20.419  19.846 -27.683  1.00 49.46           O  
ATOM    542  N   HIS A  77     -18.503  22.677 -25.270  1.00 40.80           N  
ATOM    543  CA  HIS A  77     -17.458  22.358 -24.318  1.00 37.70           C  
ATOM    544  C   HIS A  77     -17.761  23.074 -22.968  1.00 35.30           C  
ATOM    545  O   HIS A  77     -18.658  23.911 -22.918  1.00 32.56           O  
ATOM    546  CB  HIS A  77     -16.059  22.706 -24.864  1.00 38.58           C  
ATOM    547  CG  HIS A  77     -15.843  24.167 -25.102  1.00 39.47           C  
ATOM    548  ND1 HIS A  77     -15.332  25.013 -24.138  1.00 41.47           N  
ATOM    549  CD2 HIS A  77     -16.109  24.943 -26.182  1.00 39.72           C  
ATOM    550  CE1 HIS A  77     -15.284  26.242 -24.620  1.00 39.49           C  
ATOM    551  NE2 HIS A  77     -15.742  26.226 -25.857  1.00 44.26           N  
ATOM    552  N   GLN A  78     -17.076  22.666 -21.903  1.00 32.58           N  
ATOM    553  CA  GLN A  78     -17.254  23.265 -20.580  1.00 33.68           C  
ATOM    554  C   GLN A  78     -16.135  24.234 -20.357  1.00 33.17           C  
ATOM    555  O   GLN A  78     -15.029  24.009 -20.841  1.00 32.63           O  
ATOM    556  CB  GLN A  78     -17.204  22.214 -19.471  1.00 34.09           C  
ATOM    557  CG  GLN A  78     -18.397  21.276 -19.421  1.00 37.52           C  
ATOM    558  CD  GLN A  78     -19.640  21.955 -18.929  1.00 33.46           C  
ATOM    559  OE1 GLN A  78     -20.489  22.250 -19.723  1.00 34.44           O  
ATOM    560  NE2 GLN A  78     -19.719  22.266 -17.618  1.00 33.91           N  
ATOM    561  N   GLU A  79     -16.411  25.294 -19.602  1.00 32.93           N  
ATOM    562  CA  GLU A  79     -15.388  26.254 -19.216  1.00 34.33           C  
ATOM    563  C   GLU A  79     -15.292  26.255 -17.685  1.00 33.18           C  
ATOM    564  O   GLU A  79     -16.302  26.050 -17.028  1.00 33.08           O  
ATOM    565  CB  GLU A  79     -15.778  27.642 -19.702  1.00 34.00           C  
ATOM    566  CG  GLU A  79     -15.821  27.788 -21.220  1.00 39.75           C  
ATOM    567  CD  GLU A  79     -16.342  29.173 -21.650  1.00 39.95           C  
ATOM    568  OE1 GLU A  79     -16.747  29.940 -20.753  1.00 45.90           O  
ATOM    569  OE2 GLU A  79     -16.364  29.470 -22.883  1.00 47.42           O  
ATOM    570  N   TYR A  80     -14.081  26.449 -17.159  1.00 31.71           N  
ATOM    571  CA  TYR A  80     -13.828  26.587 -15.718  1.00 31.72           C  
ATOM    572  C   TYR A  80     -13.583  28.037 -15.427  1.00 30.70           C  
ATOM    573  O   TYR A  80     -12.732  28.631 -16.061  1.00 29.39           O  
ATOM    574  CB  TYR A  80     -12.627  25.757 -15.277  1.00 32.34           C  
ATOM    575  CG  TYR A  80     -12.928  24.302 -15.306  1.00 34.04           C  
ATOM    576  CD1 TYR A  80     -13.486  23.666 -14.202  1.00 34.67           C  
ATOM    577  CD2 TYR A  80     -12.684  23.558 -16.446  1.00 33.01           C  
ATOM    578  CE1 TYR A  80     -13.786  22.316 -14.252  1.00 34.97           C  
ATOM    579  CE2 TYR A  80     -12.993  22.194 -16.501  1.00 36.20           C  
ATOM    580  CZ  TYR A  80     -13.516  21.598 -15.390  1.00 35.17           C  
ATOM    581  OH  TYR A  80     -13.814  20.272 -15.460  1.00 37.93           O  
ATOM    582  N   ARG A  81     -14.344  28.599 -14.494  1.00 30.41           N  
ATOM    583  CA  ARG A  81     -14.228  30.046 -14.164  1.00 29.41           C  
ATOM    584  C   ARG A  81     -14.076  30.238 -12.671  1.00 29.64           C  
ATOM    585  O   ARG A  81     -14.786  29.626 -11.904  1.00 30.09           O  
ATOM    586  CB  ARG A  81     -15.485  30.781 -14.618  1.00 30.23           C  
ATOM    587  CG  ARG A  81     -15.675  30.883 -16.188  1.00 30.18           C  
ATOM    588  CD  ARG A  81     -14.764  32.095 -16.667  1.00 38.19           C  
ATOM    589  NE  ARG A  81     -15.322  33.357 -16.156  1.00 38.96           N  
ATOM    590  CZ  ARG A  81     -16.206  34.106 -16.829  1.00 40.18           C  
ATOM    591  NH1 ARG A  81     -16.587  33.747 -18.052  1.00 38.70           N  
ATOM    592  NH2 ARG A  81     -16.698  35.222 -16.304  1.00 43.71           N  
ATOM    593  N   LEU A  82     -13.180  31.162 -12.277  1.00 29.15           N  
ATOM    594  CA  LEU A  82     -13.014  31.505 -10.874  1.00 28.36           C  
ATOM    595  C   LEU A  82     -14.308  32.089 -10.405  1.00 27.34           C  
ATOM    596  O   LEU A  82     -14.981  32.819 -11.125  1.00 28.34           O  
ATOM    597  CB  LEU A  82     -11.866  32.517 -10.697  1.00 27.56           C  
ATOM    598  CG  LEU A  82     -10.441  31.924 -10.860  1.00 29.39           C  
ATOM    599  CD1 LEU A  82      -9.356  33.046 -11.021  1.00 30.25           C  
ATOM    600  CD2 LEU A  82     -10.065  30.912  -9.798  1.00 25.63           C  
ATOM    601  N   THR A  83     -14.669  31.791  -9.167  1.00 29.76           N  
ATOM    602  CA  THR A  83     -15.774  32.514  -8.527  1.00 27.98           C  
ATOM    603  C   THR A  83     -15.201  33.737  -7.809  1.00 30.18           C  
ATOM    604  O   THR A  83     -13.999  33.934  -7.854  1.00 28.81           O  
ATOM    605  CB  THR A  83     -16.344  31.627  -7.437  1.00 30.07           C  
ATOM    606  OG1 THR A  83     -15.263  31.239  -6.554  1.00 29.89           O  
ATOM    607  CG2 THR A  83     -16.941  30.382  -8.043  1.00 27.20           C  
ATOM    608  N   ASP A  84     -16.056  34.553  -7.200  1.00 30.02           N  
ATOM    609  CA  ASP A  84     -15.541  35.588  -6.260  1.00 32.00           C  
ATOM    610  C   ASP A  84     -14.563  34.984  -5.220  1.00 31.03           C  
ATOM    611  O   ASP A  84     -13.487  35.532  -4.993  1.00 31.63           O  
ATOM    612  CB  ASP A  84     -16.679  36.303  -5.544  1.00 32.90           C  
ATOM    613  CG  ASP A  84     -17.661  37.013  -6.483  1.00 37.30           C  
ATOM    614  OD1 ASP A  84     -17.243  37.657  -7.460  1.00 41.27           O  
ATOM    615  OD2 ASP A  84     -18.878  36.909  -6.215  1.00 44.99           O  
ATOM    616  N   LYS A  85     -14.943  33.883  -4.565  1.00 30.10           N  
ATOM    617  CA  LYS A  85     -14.052  33.203  -3.617  1.00 31.73           C  
ATOM    618  C   LYS A  85     -12.705  32.831  -4.266  1.00 31.21           C  
ATOM    619  O   LYS A  85     -11.648  32.978  -3.682  1.00 30.70           O  
ATOM    620  CB  LYS A  85     -14.751  31.960  -3.036  1.00 30.56           C  
ATOM    621  CG  LYS A  85     -13.862  30.933  -2.286  1.00 32.76           C  
ATOM    622  CD  LYS A  85     -14.717  29.950  -1.494  1.00 32.46           C  
ATOM    623  CE  LYS A  85     -13.881  28.962  -0.762  1.00 33.91           C  
ATOM    624  NZ  LYS A  85     -14.785  28.178   0.095  1.00 35.49           N  
ATOM    625  N   GLY A  86     -12.754  32.355  -5.513  1.00 30.96           N  
ATOM    626  CA  GLY A  86     -11.535  31.942  -6.220  1.00 30.58           C  
ATOM    627  C   GLY A  86     -10.733  33.145  -6.620  1.00 29.76           C  
ATOM    628  O   GLY A  86      -9.533  33.119  -6.532  1.00 30.06           O  
ATOM    629  N   ARG A  87     -11.384  34.230  -7.041  1.00 29.55           N  
ATOM    630  CA  ARG A  87     -10.635  35.412  -7.447  1.00 32.07           C  
ATOM    631  C   ARG A  87      -9.926  36.043  -6.255  1.00 30.56           C  
ATOM    632  O   ARG A  87      -8.911  36.758  -6.414  1.00 31.28           O  
ATOM    633  CB  ARG A  87     -11.619  36.429  -7.973  1.00 33.46           C  
ATOM    634  CG  ARG A  87     -10.970  37.463  -8.778  1.00 39.25           C  
ATOM    635  CD  ARG A  87     -11.431  37.392 -10.256  1.00 43.14           C  
ATOM    636  NE  ARG A  87     -10.555  38.283 -11.010  1.00 48.66           N  
ATOM    637  CZ  ARG A  87      -9.836  37.951 -12.079  1.00 51.04           C  
ATOM    638  NH1 ARG A  87      -9.933  36.739 -12.632  1.00 51.23           N  
ATOM    639  NH2 ARG A  87      -9.054  38.874 -12.636  1.00 51.99           N  
ATOM    640  N   ALA A  88     -10.533  35.847  -5.092  1.00 31.36           N  
ATOM    641  CA  ALA A  88     -10.044  36.391  -3.809  1.00 31.14           C  
ATOM    642  C   ALA A  88      -8.710  35.735  -3.372  1.00 30.98           C  
ATOM    643  O   ALA A  88      -8.042  36.202  -2.452  1.00 29.39           O  
ATOM    644  CB  ALA A  88     -11.122  36.217  -2.743  1.00 31.60           C  
ATOM    645  N   LEU A  89      -8.326  34.645  -4.046  1.00 28.58           N  
ATOM    646  CA  LEU A  89      -6.994  34.084  -3.854  1.00 28.85           C  
ATOM    647  C   LEU A  89      -5.827  34.884  -4.404  1.00 27.69           C  
ATOM    648  O   LEU A  89      -4.672  34.450  -4.242  1.00 29.36           O  
ATOM    649  CB  LEU A  89      -6.908  32.670  -4.496  1.00 28.61           C  
ATOM    650  CG  LEU A  89      -7.675  31.594  -3.733  1.00 30.13           C  
ATOM    651  CD1 LEU A  89      -7.883  30.294  -4.620  1.00 29.60           C  
ATOM    652  CD2 LEU A  89      -6.963  31.214  -2.431  1.00 28.24           C  
ATOM    653  N   PHE A  90      -6.069  35.982  -5.109  1.00 29.57           N  
ATOM    654  CA  PHE A  90      -4.966  36.653  -5.766  1.00 30.04           C  
ATOM    655  C   PHE A  90      -3.875  37.084  -4.781  1.00 29.18           C  
ATOM    656  O   PHE A  90      -2.700  36.838  -5.033  1.00 29.59           O  
ATOM    657  CB  PHE A  90      -5.420  37.814  -6.635  1.00 31.88           C  
ATOM    658  CG  PHE A  90      -4.337  38.386  -7.491  1.00 34.19           C  
ATOM    659  CD1 PHE A  90      -3.754  37.612  -8.503  1.00 39.94           C  
ATOM    660  CD2 PHE A  90      -3.921  39.721  -7.301  1.00 36.18           C  
ATOM    661  CE1 PHE A  90      -2.745  38.163  -9.332  1.00 42.25           C  
ATOM    662  CE2 PHE A  90      -2.932  40.283  -8.139  1.00 38.28           C  
ATOM    663  CZ  PHE A  90      -2.343  39.490  -9.138  1.00 36.47           C  
ATOM    664  N   PRO A  91      -4.253  37.730  -3.663  1.00 29.85           N  
ATOM    665  CA  PRO A  91      -3.153  38.060  -2.689  1.00 29.35           C  
ATOM    666  C   PRO A  91      -2.320  36.864  -2.244  1.00 28.61           C  
ATOM    667  O   PRO A  91      -1.093  36.941  -2.218  1.00 29.23           O  
ATOM    668  CB  PRO A  91      -3.931  38.693  -1.494  1.00 29.50           C  
ATOM    669  CG  PRO A  91      -5.086  39.362  -2.164  1.00 29.39           C  
ATOM    670  CD  PRO A  91      -5.543  38.294  -3.238  1.00 28.53           C  
ATOM    671  N   LEU A  92      -2.988  35.757  -1.887  1.00 29.63           N  
ATOM    672  CA  LEU A  92      -2.331  34.533  -1.485  1.00 29.21           C  
ATOM    673  C   LEU A  92      -1.367  34.059  -2.602  1.00 30.92           C  
ATOM    674  O   LEU A  92      -0.218  33.655  -2.337  1.00 30.08           O  
ATOM    675  CB  LEU A  92      -3.420  33.472  -1.165  1.00 29.84           C  
ATOM    676  CG  LEU A  92      -3.111  32.250  -0.291  1.00 34.38           C  
ATOM    677  CD1 LEU A  92      -4.438  31.507   0.078  1.00 35.11           C  
ATOM    678  CD2 LEU A  92      -2.192  31.336  -1.030  1.00 37.33           C  
ATOM    679  N   LEU A  93      -1.858  34.081  -3.844  1.00 31.29           N  
ATOM    680  CA  LEU A  93      -1.048  33.704  -5.009  1.00 32.31           C  
ATOM    681  C   LEU A  93       0.218  34.566  -5.135  1.00 32.19           C  
ATOM    682  O   LEU A  93       1.320  34.051  -5.331  1.00 32.20           O  
ATOM    683  CB  LEU A  93      -1.882  33.797  -6.288  1.00 32.40           C  
ATOM    684  CG  LEU A  93      -1.220  33.317  -7.606  1.00 32.68           C  
ATOM    685  CD1 LEU A  93      -0.665  31.925  -7.540  1.00 28.49           C  
ATOM    686  CD2 LEU A  93      -2.194  33.437  -8.741  1.00 31.65           C  
ATOM    687  N   VAL A  94       0.046  35.893  -5.060  1.00 30.90           N  
ATOM    688  CA  VAL A  94       1.190  36.798  -5.080  1.00 32.71           C  
ATOM    689  C   VAL A  94       2.198  36.484  -3.967  1.00 33.04           C  
ATOM    690  O   VAL A  94       3.438  36.480  -4.206  1.00 34.33           O  
ATOM    691  CB  VAL A  94       0.720  38.262  -5.029  1.00 30.40           C  
ATOM    692  CG1 VAL A  94       1.934  39.236  -4.870  1.00 34.41           C  
ATOM    693  CG2 VAL A  94      -0.077  38.594  -6.310  1.00 31.59           C  
ATOM    694  N   ALA A  95       1.685  36.229  -2.759  1.00 32.04           N  
ATOM    695  CA  ALA A  95       2.545  35.881  -1.626  1.00 32.17           C  
ATOM    696  C   ALA A  95       3.373  34.612  -1.919  1.00 32.09           C  
ATOM    697  O   ALA A  95       4.583  34.636  -1.697  1.00 29.83           O  
ATOM    698  CB  ALA A  95       1.706  35.722  -0.319  1.00 32.39           C  
ATOM    699  N   ILE A  96       2.728  33.547  -2.447  1.00 31.91           N  
ATOM    700  CA  ILE A  96       3.446  32.341  -2.841  1.00 31.66           C  
ATOM    701  C   ILE A  96       4.482  32.666  -3.894  1.00 30.67           C  
ATOM    702  O   ILE A  96       5.607  32.267  -3.743  1.00 30.60           O  
ATOM    703  CB  ILE A  96       2.544  31.164  -3.370  1.00 33.15           C  
ATOM    704  CG1 ILE A  96       1.612  30.669  -2.265  1.00 33.06           C  
ATOM    705  CG2 ILE A  96       3.414  30.017  -3.845  1.00 32.22           C  
ATOM    706  CD1 ILE A  96       0.476  29.616  -2.753  1.00 30.82           C  
ATOM    707  N   ARG A  97       4.084  33.306  -5.001  1.00 30.20           N  
ATOM    708  CA  ARG A  97       5.037  33.687  -6.080  1.00 30.27           C  
ATOM    709  C   ARG A  97       6.286  34.402  -5.498  1.00 30.15           C  
ATOM    710  O   ARG A  97       7.419  34.082  -5.843  1.00 27.08           O  
ATOM    711  CB  ARG A  97       4.334  34.597  -7.085  1.00 29.56           C  
ATOM    712  CG  ARG A  97       5.207  35.101  -8.244  1.00 30.68           C  
ATOM    713  CD  ARG A  97       4.392  36.097  -9.121  1.00 31.13           C  
ATOM    714  NE  ARG A  97       3.212  35.455  -9.763  1.00 31.91           N  
ATOM    715  CZ  ARG A  97       3.287  34.573 -10.770  1.00 34.42           C  
ATOM    716  NH1 ARG A  97       4.459  34.185 -11.245  1.00 32.86           N  
ATOM    717  NH2 ARG A  97       2.177  34.052 -11.280  1.00 34.00           N  
ATOM    718  N   GLN A  98       6.067  35.394  -4.632  1.00 29.48           N  
ATOM    719  CA  GLN A  98       7.186  36.190  -4.161  1.00 30.40           C  
ATOM    720  C   GLN A  98       8.105  35.379  -3.242  1.00 30.77           C  
ATOM    721  O   GLN A  98       9.325  35.485  -3.348  1.00 32.71           O  
ATOM    722  CB  GLN A  98       6.666  37.468  -3.507  1.00 31.19           C  
ATOM    723  CG  GLN A  98       6.009  38.381  -4.618  1.00 29.60           C  
ATOM    724  CD  GLN A  98       5.467  39.689  -4.087  1.00 32.41           C  
ATOM    725  OE1 GLN A  98       5.313  39.864  -2.894  1.00 30.90           O  
ATOM    726  NE2 GLN A  98       5.176  40.600  -4.985  1.00 28.15           N  
ATOM    727  N   TRP A  99       7.541  34.553  -2.363  1.00 30.61           N  
ATOM    728  CA  TRP A  99       8.390  33.672  -1.534  1.00 31.12           C  
ATOM    729  C   TRP A  99       9.178  32.723  -2.438  1.00 31.92           C  
ATOM    730  O   TRP A  99      10.362  32.418  -2.207  1.00 32.19           O  
ATOM    731  CB  TRP A  99       7.534  32.947  -0.503  1.00 31.45           C  
ATOM    732  CG  TRP A  99       8.301  32.199   0.546  1.00 32.49           C  
ATOM    733  CD1 TRP A  99       9.134  32.743   1.533  1.00 30.72           C  
ATOM    734  CD2 TRP A  99       8.331  30.794   0.734  1.00 30.02           C  
ATOM    735  NE1 TRP A  99       9.651  31.729   2.322  1.00 32.08           N  
ATOM    736  CE2 TRP A  99       9.186  30.527   1.846  1.00 34.15           C  
ATOM    737  CE3 TRP A  99       7.709  29.710   0.089  1.00 33.31           C  
ATOM    738  CZ2 TRP A  99       9.429  29.227   2.301  1.00 32.25           C  
ATOM    739  CZ3 TRP A  99       7.950  28.434   0.553  1.00 31.80           C  
ATOM    740  CH2 TRP A  99       8.801  28.195   1.623  1.00 33.51           C  
ATOM    741  N   GLY A 100       8.533  32.253  -3.504  1.00 31.32           N  
ATOM    742  CA  GLY A 100       9.236  31.435  -4.494  1.00 32.43           C  
ATOM    743  C   GLY A 100      10.387  32.174  -5.159  1.00 32.88           C  
ATOM    744  O   GLY A 100      11.492  31.622  -5.315  1.00 33.05           O  
ATOM    745  N   GLU A 101      10.126  33.412  -5.570  1.00 33.04           N  
ATOM    746  CA  GLU A 101      11.155  34.298  -6.145  1.00 34.18           C  
ATOM    747  C   GLU A 101      12.329  34.600  -5.191  1.00 34.38           C  
ATOM    748  O   GLU A 101      13.495  34.604  -5.604  1.00 35.83           O  
ATOM    749  CB  GLU A 101      10.540  35.636  -6.592  1.00 34.50           C  
ATOM    750  CG  GLU A 101       9.564  35.489  -7.744  1.00 34.94           C  
ATOM    751  CD  GLU A 101       8.917  36.820  -8.078  1.00 38.17           C  
ATOM    752  OE1 GLU A 101       9.226  37.824  -7.394  1.00 36.79           O  
ATOM    753  OE2 GLU A 101       8.107  36.857  -9.026  1.00 35.02           O  
ATOM    754  N   ASP A 102      11.998  34.888  -3.944  1.00 35.10           N  
ATOM    755  CA  ASP A 102      12.985  35.227  -2.917  1.00 34.12           C  
ATOM    756  C   ASP A 102      13.930  34.088  -2.514  1.00 35.03           C  
ATOM    757  O   ASP A 102      15.104  34.331  -2.197  1.00 33.86           O  
ATOM    758  CB  ASP A 102      12.272  35.726  -1.665  1.00 33.95           C  
ATOM    759  CG  ASP A 102      11.567  37.048  -1.863  1.00 33.79           C  
ATOM    760  OD1 ASP A 102      11.782  37.715  -2.897  1.00 33.41           O  
ATOM    761  OD2 ASP A 102      10.813  37.433  -0.941  1.00 38.55           O  
ATOM    762  N   TYR A 103      13.435  32.859  -2.486  1.00 36.00           N  
ATOM    763  CA  TYR A 103      14.171  31.774  -1.830  1.00 36.55           C  
ATOM    764  C   TYR A 103      14.364  30.489  -2.625  1.00 37.25           C  
ATOM    765  O   TYR A 103      14.987  29.564  -2.100  1.00 37.55           O  
ATOM    766  CB  TYR A 103      13.518  31.421  -0.485  1.00 37.39           C  
ATOM    767  CG  TYR A 103      13.561  32.564   0.471  1.00 36.62           C  
ATOM    768  CD1 TYR A 103      14.742  32.882   1.159  1.00 36.20           C  
ATOM    769  CD2 TYR A 103      12.453  33.359   0.670  1.00 36.66           C  
ATOM    770  CE1 TYR A 103      14.786  33.970   2.012  1.00 34.57           C  
ATOM    771  CE2 TYR A 103      12.502  34.431   1.515  1.00 37.26           C  
ATOM    772  CZ  TYR A 103      13.674  34.723   2.184  1.00 34.02           C  
ATOM    773  OH  TYR A 103      13.705  35.795   3.032  1.00 41.18           O  
ATOM    774  N   PHE A 104      13.850  30.408  -3.855  1.00 35.88           N  
ATOM    775  CA  PHE A 104      13.816  29.113  -4.563  1.00 36.01           C  
ATOM    776  C   PHE A 104      14.637  29.071  -5.849  1.00 36.17           C  
ATOM    777  O   PHE A 104      14.644  28.063  -6.567  1.00 36.95           O  
ATOM    778  CB  PHE A 104      12.336  28.622  -4.777  1.00 34.92           C  
ATOM    779  CG  PHE A 104      11.736  28.019  -3.554  1.00 34.09           C  
ATOM    780  CD1 PHE A 104      11.821  26.641  -3.316  1.00 34.63           C  
ATOM    781  CD2 PHE A 104      11.126  28.837  -2.598  1.00 33.54           C  
ATOM    782  CE1 PHE A 104      11.311  26.092  -2.132  1.00 30.50           C  
ATOM    783  CE2 PHE A 104      10.616  28.314  -1.447  1.00 34.19           C  
ATOM    784  CZ  PHE A 104      10.699  26.924  -1.212  1.00 34.01           C  
ATOM    785  N   PHE A 105      15.325  30.164  -6.165  1.00 36.72           N  
ATOM    786  CA  PHE A 105      16.078  30.238  -7.418  1.00 39.02           C  
ATOM    787  C   PHE A 105      17.554  30.579  -7.151  1.00 40.43           C  
ATOM    788  O   PHE A 105      17.869  31.406  -6.300  1.00 41.01           O  
ATOM    789  CB  PHE A 105      15.460  31.264  -8.396  1.00 38.65           C  
ATOM    790  CG  PHE A 105      14.085  30.884  -8.881  1.00 38.16           C  
ATOM    791  CD1 PHE A 105      13.926  30.197 -10.091  1.00 38.48           C  
ATOM    792  CD2 PHE A 105      12.957  31.179  -8.123  1.00 37.64           C  
ATOM    793  CE1 PHE A 105      12.669  29.808 -10.543  1.00 39.53           C  
ATOM    794  CE2 PHE A 105      11.692  30.799  -8.569  1.00 36.94           C  
ATOM    795  CZ  PHE A 105      11.547  30.107  -9.777  1.00 38.13           C  
ATOM    796  N   ALA A 106      18.433  29.897  -7.866  1.00 42.63           N  
ATOM    797  CA  ALA A 106      19.839  30.273  -7.961  1.00 45.09           C  
ATOM    798  C   ALA A 106      19.933  31.727  -8.454  1.00 46.77           C  
ATOM    799  O   ALA A 106      19.072  32.165  -9.229  1.00 46.73           O  
ATOM    800  CB  ALA A 106      20.546  29.340  -8.927  1.00 44.49           C  
ATOM    801  N   PRO A 107      20.982  32.477  -8.040  1.00 48.13           N  
ATOM    802  CA  PRO A 107      21.067  33.858  -8.532  1.00 49.28           C  
ATOM    803  C   PRO A 107      21.227  33.856 -10.055  1.00 50.29           C  
ATOM    804  O   PRO A 107      20.895  34.846 -10.726  1.00 50.97           O  
ATOM    805  CB  PRO A 107      22.338  34.400  -7.874  1.00 49.65           C  
ATOM    806  CG  PRO A 107      22.638  33.456  -6.744  1.00 49.90           C  
ATOM    807  CD  PRO A 107      22.133  32.120  -7.194  1.00 48.48           C  
ATOM    808  N   ASP A 108      21.712  32.723 -10.566  1.00 50.53           N  
ATOM    809  CA  ASP A 108      21.911  32.453 -11.983  1.00 50.73           C  
ATOM    810  C   ASP A 108      20.615  32.161 -12.774  1.00 50.63           C  
ATOM    811  O   ASP A 108      20.619  32.090 -14.016  1.00 50.65           O  
ATOM    812  CB  ASP A 108      22.913  31.293 -12.092  1.00 51.61           C  
ATOM    813  CG  ASP A 108      22.420  30.145 -12.971  1.00 52.40           C  
ATOM    814  OD1 ASP A 108      21.441  29.462 -12.588  1.00 55.54           O  
ATOM    815  OD2 ASP A 108      23.031  29.915 -14.031  1.00 53.50           O  
ATOM    816  N   GLU A 109      19.507  31.996 -12.059  1.00 49.78           N  
ATOM    817  CA  GLU A 109      18.278  31.529 -12.683  1.00 48.99           C  
ATOM    818  C   GLU A 109      17.323  32.655 -13.005  1.00 48.48           C  
ATOM    819  O   GLU A 109      17.142  33.572 -12.202  1.00 49.06           O  
ATOM    820  CB  GLU A 109      17.573  30.533 -11.772  1.00 48.55           C  
ATOM    821  CG  GLU A 109      18.147  29.147 -11.845  1.00 48.65           C  
ATOM    822  CD  GLU A 109      17.284  28.148 -11.136  1.00 47.14           C  
ATOM    823  OE1 GLU A 109      17.231  28.189  -9.885  1.00 46.38           O  
ATOM    824  OE2 GLU A 109      16.664  27.321 -11.838  1.00 47.46           O  
ATOM    825  N   SER A 110      16.701  32.562 -14.179  1.00 47.10           N  
ATOM    826  CA  SER A 110      15.652  33.477 -14.575  1.00 45.47           C  
ATOM    827  C   SER A 110      14.292  32.817 -14.358  1.00 43.73           C  
ATOM    828  O   SER A 110      14.187  31.585 -14.285  1.00 43.75           O  
ATOM    829  CB  SER A 110      15.816  33.832 -16.050  1.00 46.02           C  
ATOM    830  OG  SER A 110      17.174  34.109 -16.334  1.00 48.63           O  
ATOM    831  N   HIS A 111      13.251  33.640 -14.263  1.00 40.99           N  
ATOM    832  CA  HIS A 111      11.877  33.153 -14.190  1.00 38.48           C  
ATOM    833  C   HIS A 111      10.943  34.270 -14.640  1.00 37.46           C  
ATOM    834  O   HIS A 111      11.363  35.439 -14.748  1.00 37.30           O  
ATOM    835  CB  HIS A 111      11.517  32.749 -12.760  1.00 38.47           C  
ATOM    836  CG  HIS A 111      11.814  33.831 -11.751  1.00 35.42           C  
ATOM    837  ND1 HIS A 111      11.030  34.953 -11.616  1.00 34.07           N  
ATOM    838  CD2 HIS A 111      12.844  33.990 -10.890  1.00 37.51           C  
ATOM    839  CE1 HIS A 111      11.544  35.748 -10.689  1.00 36.02           C  
ATOM    840  NE2 HIS A 111      12.641  35.176 -10.222  1.00 37.70           N  
ATOM    841  N   VAL A 112       9.682  33.909 -14.876  1.00 36.10           N  
ATOM    842  CA  VAL A 112       8.664  34.879 -15.232  1.00 35.08           C  
ATOM    843  C   VAL A 112       8.480  35.907 -14.109  1.00 34.84           C  
ATOM    844  O   VAL A 112       8.829  35.660 -12.954  1.00 34.19           O  
ATOM    845  CB  VAL A 112       7.299  34.201 -15.579  1.00 35.04           C  
ATOM    846  CG1 VAL A 112       7.460  33.260 -16.799  1.00 34.21           C  
ATOM    847  CG2 VAL A 112       6.703  33.469 -14.393  1.00 35.29           C  
ATOM    848  N   ARG A 113       7.913  37.055 -14.454  1.00 34.40           N  
ATOM    849  CA  ARG A 113       7.640  38.088 -13.457  1.00 34.29           C  
ATOM    850  C   ARG A 113       6.180  38.551 -13.512  1.00 33.73           C  
ATOM    851  O   ARG A 113       5.536  38.523 -14.582  1.00 33.62           O  
ATOM    852  CB  ARG A 113       8.622  39.232 -13.664  1.00 34.96           C  
ATOM    853  CG  ARG A 113      10.070  38.850 -13.231  1.00 37.04           C  
ATOM    854  CD  ARG A 113      10.902  40.191 -13.726  0.00 42.75           C  
ATOM    855  NE  ARG A 113      12.318  39.956 -13.468  0.00 49.30           N  
ATOM    856  CZ  ARG A 113      13.289  40.838 -13.714  0.00 50.32           C  
ATOM    857  NH1 ARG A 113      13.000  42.024 -14.264  0.00 50.53           N  
ATOM    858  NH2 ARG A 113      14.554  40.521 -13.438  0.00 49.29           N  
ATOM    859  N   LEU A 114       5.606  38.835 -12.351  1.00 33.18           N  
ATOM    860  CA  LEU A 114       4.297  39.461 -12.303  1.00 33.18           C  
ATOM    861  C   LEU A 114       4.493  40.977 -12.429  1.00 33.77           C  
ATOM    862  O   LEU A 114       5.227  41.589 -11.636  1.00 33.75           O  
ATOM    863  CB  LEU A 114       3.547  39.112 -11.009  1.00 33.58           C  
ATOM    864  CG  LEU A 114       2.165  39.743 -10.872  1.00 32.15           C  
ATOM    865  CD1 LEU A 114       1.197  39.058 -11.826  1.00 31.03           C  
ATOM    866  CD2 LEU A 114       1.696  39.553  -9.421  1.00 31.90           C  
ATOM    867  N   VAL A 115       3.877  41.568 -13.457  1.00 32.96           N  
ATOM    868  CA  VAL A 115       4.024  42.996 -13.740  1.00 32.37           C  
ATOM    869  C   VAL A 115       2.671  43.716 -13.877  1.00 33.15           C  
ATOM    870  O   VAL A 115       1.660  43.079 -14.198  1.00 33.22           O  
ATOM    871  CB  VAL A 115       4.884  43.263 -15.028  1.00 33.08           C  
ATOM    872  CG1 VAL A 115       6.280  42.692 -14.905  1.00 32.00           C  
ATOM    873  CG2 VAL A 115       4.176  42.734 -16.303  1.00 31.30           C  
ATOM    874  N   GLU A 116       2.663  45.042 -13.647  1.00 33.10           N  
ATOM    875  CA  GLU A 116       1.510  45.925 -13.906  1.00 34.47           C  
ATOM    876  C   GLU A 116       1.230  45.997 -15.422  1.00 36.32           C  
ATOM    877  O   GLU A 116       2.153  46.203 -16.201  1.00 36.30           O  
ATOM    878  CB  GLU A 116       1.777  47.322 -13.319  1.00 34.58           C  
ATOM    879  CG  GLU A 116       1.983  47.254 -11.817  1.00 34.32           C  
ATOM    880  CD  GLU A 116       2.249  48.582 -11.146  1.00 37.32           C  
ATOM    881  OE1 GLU A 116       1.925  49.626 -11.727  1.00 39.74           O  
ATOM    882  OE2 GLU A 116       2.784  48.559 -10.015  1.00 38.34           O  
ATOM    883  N   ARG A 117      -0.025  45.820 -15.841  1.00 37.64           N  
ATOM    884  CA  ARG A 117      -0.354  45.871 -17.281  1.00 40.27           C  
ATOM    885  C   ARG A 117      -0.032  47.231 -17.873  1.00 41.43           C  
ATOM    886  O   ARG A 117       0.487  47.312 -18.968  1.00 42.46           O  
ATOM    887  CB  ARG A 117      -1.826  45.518 -17.561  1.00 40.07           C  
ATOM    888  CG  ARG A 117      -2.110  44.060 -17.496  1.00 41.24           C  
ATOM    889  CD  ARG A 117      -3.522  43.725 -17.957  1.00 43.51           C  
ATOM    890  NE  ARG A 117      -3.676  42.275 -17.882  1.00 46.29           N  
ATOM    891  CZ  ARG A 117      -3.321  41.416 -18.852  1.00 47.24           C  
ATOM    892  NH1 ARG A 117      -2.849  41.841 -20.021  1.00 46.64           N  
ATOM    893  NH2 ARG A 117      -3.452  40.115 -18.660  1.00 47.16           N  
ATOM    894  N   ASP A 118      -0.306  48.292 -17.116  1.00 43.30           N  
ATOM    895  CA  ASP A 118      -0.157  49.682 -17.589  1.00 43.95           C  
ATOM    896  C   ASP A 118       1.316  49.970 -17.863  1.00 44.14           C  
ATOM    897  O   ASP A 118       1.711  50.226 -19.002  1.00 44.40           O  
ATOM    898  CB  ASP A 118      -0.748  50.659 -16.535  1.00 44.17           C  
ATOM    899  CG  ASP A 118      -0.283  52.121 -16.703  1.00 46.84           C  
ATOM    900  OD1 ASP A 118       0.008  52.573 -17.836  1.00 48.84           O  
ATOM    901  OD2 ASP A 118      -0.205  52.838 -15.664  1.00 50.82           O  
ATOM    902  N   SER A 119       2.114  49.893 -16.811  1.00 44.02           N  
ATOM    903  CA  SER A 119       3.484  50.368 -16.812  1.00 44.42           C  
ATOM    904  C   SER A 119       4.470  49.240 -17.049  1.00 44.75           C  
ATOM    905  O   SER A 119       5.568  49.447 -17.575  1.00 44.84           O  
ATOM    906  CB  SER A 119       3.771  50.881 -15.415  1.00 44.24           C  
ATOM    907  OG  SER A 119       3.972  49.776 -14.537  1.00 44.36           O  
ATOM    908  N   GLY A 120       4.020  48.048 -16.686  1.00 44.20           N  
ATOM    909  CA  GLY A 120       4.765  47.177 -15.780  1.00 44.72           C  
ATOM    910  C   GLY A 120       6.024  46.608 -16.307  1.00 43.18           C  
ATOM    911  O   GLY A 120       6.040  46.210 -17.440  1.00 45.07           O  
ATOM    912  N   GLN A 121       7.085  46.541 -15.518  1.00 42.26           N  
ATOM    913  CA  GLN A 121       7.209  46.913 -14.071  1.00 41.00           C  
ATOM    914  C   GLN A 121       6.601  45.941 -13.077  1.00 39.33           C  
ATOM    915  O   GLN A 121       5.371  45.864 -12.908  1.00 36.97           O  
ATOM    916  CB  GLN A 121       6.926  48.390 -13.679  1.00 41.62           C  
ATOM    917  CG  GLN A 121       7.710  49.463 -14.466  1.00 42.74           C  
ATOM    918  CD  GLN A 121       9.210  49.169 -14.674  1.00 44.97           C  
ATOM    919  OE1 GLN A 121       9.684  49.139 -15.812  1.00 45.34           O  
ATOM    920  NE2 GLN A 121       9.953  48.990 -13.589  1.00 43.72           N  
ATOM    921  N   PRO A 122       7.498  45.221 -12.393  1.00 38.29           N  
ATOM    922  CA  PRO A 122       7.139  44.173 -11.469  1.00 36.29           C  
ATOM    923  C   PRO A 122       6.213  44.730 -10.402  1.00 34.86           C  
ATOM    924  O   PRO A 122       6.349  45.889  -9.985  1.00 33.29           O  
ATOM    925  CB  PRO A 122       8.496  43.764 -10.883  1.00 36.91           C  
ATOM    926  CG  PRO A 122       9.458  44.061 -12.006  1.00 37.90           C  
ATOM    927  CD  PRO A 122       8.965  45.391 -12.474  1.00 37.84           C  
ATOM    928  N   VAL A 123       5.252  43.916 -10.002  1.00 33.02           N  
ATOM    929  CA  VAL A 123       4.393  44.269  -8.899  1.00 32.37           C  
ATOM    930  C   VAL A 123       5.218  44.291  -7.612  1.00 32.60           C  
ATOM    931  O   VAL A 123       6.020  43.392  -7.362  1.00 31.52           O  
ATOM    932  CB  VAL A 123       3.181  43.294  -8.809  1.00 32.52           C  
ATOM    933  CG1 VAL A 123       2.441  43.457  -7.471  1.00 30.43           C  
ATOM    934  CG2 VAL A 123       2.230  43.539 -10.024  1.00 33.03           C  
ATOM    935  N   PRO A 124       5.071  45.368  -6.815  1.00 33.08           N  
ATOM    936  CA  PRO A 124       5.790  45.511  -5.549  1.00 33.38           C  
ATOM    937  C   PRO A 124       5.613  44.330  -4.615  1.00 33.61           C  
ATOM    938  O   PRO A 124       4.579  43.664  -4.618  1.00 33.64           O  
ATOM    939  CB  PRO A 124       5.147  46.761  -4.950  1.00 32.23           C  
ATOM    940  CG  PRO A 124       4.878  47.579  -6.136  1.00 33.05           C  
ATOM    941  CD  PRO A 124       4.304  46.597  -7.116  1.00 33.22           C  
ATOM    942  N   ARG A 125       6.641  44.060  -3.827  1.00 33.45           N  
ATOM    943  CA  ARG A 125       6.565  43.030  -2.796  1.00 34.33           C  
ATOM    944  C   ARG A 125       5.362  43.337  -1.885  1.00 34.48           C  
ATOM    945  O   ARG A 125       5.105  44.533  -1.523  1.00 33.78           O  
ATOM    946  CB  ARG A 125       7.864  43.107  -1.956  1.00 35.54           C  
ATOM    947  CG  ARG A 125       7.848  42.325  -0.648  1.00 36.63           C  
ATOM    948  CD  ARG A 125       9.154  42.518   0.173  1.00 36.21           C  
ATOM    949  NE  ARG A 125      10.277  42.166  -0.679  1.00 39.71           N  
ATOM    950  CZ  ARG A 125      10.574  40.912  -1.016  1.00 41.77           C  
ATOM    951  NH1 ARG A 125       9.849  39.911  -0.514  1.00 40.68           N  
ATOM    952  NH2 ARG A 125      11.594  40.665  -1.844  1.00 38.27           N  
ATOM    953  N   LEU A 126       4.620  42.300  -1.527  1.00 32.56           N  
ATOM    954  CA  LEU A 126       3.559  42.417  -0.532  0.50 33.55           C  
ATOM    956  C   LEU A 126       4.127  42.857   0.800  1.00 34.37           C  
ATOM    957  O   LEU A 126       5.359  42.698   1.076  1.00 35.82           O  
ATOM    958  CB  LEU A 126       2.921  41.065  -0.296  0.50 33.20           C  
ATOM    960  CG  LEU A 126       2.304  40.446  -1.525  0.50 31.05           C  
ATOM    962  CD1 LEU A 126       1.697  39.136  -1.071  0.50 28.77           C  
ATOM    964  CD2 LEU A 126       1.283  41.408  -2.071  0.50 28.42           C  
ATOM    966  N   GLN A 127       3.295  43.419   1.649  1.00 34.01           N  
ATOM    967  CA  GLN A 127       3.768  43.843   2.938  1.00 34.77           C  
ATOM    968  C   GLN A 127       2.600  43.770   3.892  1.00 33.92           C  
ATOM    969  O   GLN A 127       1.576  44.438   3.661  1.00 36.07           O  
ATOM    970  CB  GLN A 127       4.281  45.288   2.800  1.00 34.94           C  
ATOM    971  CG  GLN A 127       4.592  46.046   4.130  1.00 39.43           C  
ATOM    972  CD  GLN A 127       5.909  45.614   4.688  1.00 41.13           C  
ATOM    973  OE1 GLN A 127       6.950  45.946   4.112  1.00 35.30           O  
ATOM    974  NE2 GLN A 127       5.884  44.817   5.789  1.00 38.35           N  
ATOM    975  N   VAL A 128       2.761  42.999   4.956  1.00 32.29           N  
ATOM    976  CA  VAL A 128       1.812  43.050   6.067  1.00 32.40           C  
ATOM    977  C   VAL A 128       2.001  44.403   6.713  1.00 31.58           C  
ATOM    978  O   VAL A 128       3.148  44.790   6.958  1.00 29.27           O  
ATOM    979  CB  VAL A 128       2.036  41.935   7.099  1.00 32.80           C  
ATOM    980  CG1 VAL A 128       0.955  41.985   8.163  1.00 33.33           C  
ATOM    981  CG2 VAL A 128       2.012  40.521   6.417  1.00 32.92           C  
ATOM    982  N   ARG A 129       0.896  45.118   6.950  1.00 31.31           N  
ATOM    983  CA  ARG A 129       0.956  46.482   7.500  1.00 31.33           C  
ATOM    984  C   ARG A 129      -0.005  46.609   8.689  1.00 30.07           C  
ATOM    985  O   ARG A 129      -1.018  45.858   8.826  1.00 27.97           O  
ATOM    986  CB  ARG A 129       0.591  47.530   6.426  1.00 31.95           C  
ATOM    987  CG  ARG A 129       1.509  47.543   5.181  1.00 31.57           C  
ATOM    988  CD  ARG A 129       1.059  48.489   4.109  1.00 34.52           C  
ATOM    989  NE  ARG A 129       1.957  48.414   2.934  1.00 36.76           N  
ATOM    990  CZ  ARG A 129       3.075  49.126   2.795  1.00 41.26           C  
ATOM    991  NH1 ARG A 129       3.465  49.978   3.763  1.00 40.25           N  
ATOM    992  NH2 ARG A 129       3.820  48.981   1.687  1.00 40.43           N  
ATOM    993  N   ALA A 130       0.364  47.517   9.574  1.00 28.80           N  
ATOM    994  CA  ALA A 130      -0.500  47.945  10.649  1.00 27.14           C  
ATOM    995  C   ALA A 130      -1.627  48.881  10.174  1.00 26.89           C  
ATOM    996  O   ALA A 130      -1.629  49.358   9.056  1.00 27.00           O  
ATOM    997  CB  ALA A 130       0.350  48.653  11.745  1.00 26.39           C  
ATOM    998  N   GLY A 131      -2.560  49.155  11.074  1.00 28.37           N  
ATOM    999  CA  GLY A 131      -3.654  50.078  10.841  1.00 29.57           C  
ATOM   1000  C   GLY A 131      -3.176  51.410  10.337  1.00 30.94           C  
ATOM   1001  O   GLY A 131      -3.841  52.029   9.495  1.00 31.76           O  
ATOM   1002  N   ASP A 132      -2.013  51.853  10.837  1.00 31.12           N  
ATOM   1003  CA  ASP A 132      -1.445  53.159  10.414  1.00 33.15           C  
ATOM   1004  C   ASP A 132      -0.704  53.150   9.043  1.00 33.42           C  
ATOM   1005  O   ASP A 132      -0.149  54.194   8.624  1.00 35.64           O  
ATOM   1006  CB  ASP A 132      -0.588  53.754  11.518  1.00 33.24           C  
ATOM   1007  CG  ASP A 132       0.823  53.146  11.612  1.00 34.94           C  
ATOM   1008  OD1 ASP A 132       1.135  52.063  11.091  1.00 30.59           O  
ATOM   1009  OD2 ASP A 132       1.662  53.807  12.219  1.00 34.00           O  
ATOM   1010  N   GLY A 133      -0.684  51.985   8.392  1.00 32.26           N  
ATOM   1011  CA  GLY A 133      -0.002  51.793   7.109  1.00 30.68           C  
ATOM   1012  C   GLY A 133       1.444  51.329   7.185  1.00 30.66           C  
ATOM   1013  O   GLY A 133       2.028  50.980   6.156  1.00 31.47           O  
ATOM   1014  N   SER A 134       2.020  51.271   8.387  1.00 29.87           N  
ATOM   1015  CA  SER A 134       3.450  50.950   8.549  1.00 29.92           C  
ATOM   1016  C   SER A 134       3.704  49.444   8.473  1.00 29.45           C  
ATOM   1017  O   SER A 134       2.840  48.673   8.876  1.00 28.04           O  
ATOM   1018  CB  SER A 134       4.032  51.561   9.847  1.00 29.96           C  
ATOM   1019  OG  SER A 134       3.429  51.059  11.040  1.00 28.81           O  
ATOM   1020  N   PRO A 135       4.877  49.035   7.936  1.00 30.00           N  
ATOM   1021  CA  PRO A 135       5.235  47.588   7.894  1.00 30.85           C  
ATOM   1022  C   PRO A 135       5.173  46.995   9.268  1.00 30.15           C  
ATOM   1023  O   PRO A 135       5.643  47.613  10.241  1.00 30.15           O  
ATOM   1024  CB  PRO A 135       6.698  47.586   7.448  1.00 31.47           C  
ATOM   1025  CG  PRO A 135       6.877  48.869   6.698  1.00 32.50           C  
ATOM   1026  CD  PRO A 135       5.961  49.880   7.390  1.00 30.58           C  
ATOM   1027  N   LEU A 136       4.628  45.785   9.342  1.00 30.44           N  
ATOM   1028  CA  LEU A 136       4.396  45.114  10.590  1.00 29.92           C  
ATOM   1029  C   LEU A 136       5.048  43.738  10.533  1.00 31.30           C  
ATOM   1030  O   LEU A 136       4.767  42.926   9.622  1.00 29.56           O  
ATOM   1031  CB  LEU A 136       2.885  44.999  10.811  1.00 30.81           C  
ATOM   1032  CG  LEU A 136       2.283  44.465  12.098  1.00 29.00           C  
ATOM   1033  CD1 LEU A 136       2.651  45.386  13.314  1.00 26.03           C  
ATOM   1034  CD2 LEU A 136       0.752  44.341  11.856  1.00 29.15           C  
ATOM   1035  N   ALA A 137       5.961  43.525  11.482  1.00 32.62           N  
ATOM   1036  CA  ALA A 137       6.674  42.266  11.640  1.00 32.94           C  
ATOM   1037  C   ALA A 137       5.811  41.269  12.384  1.00 33.04           C  
ATOM   1038  O   ALA A 137       4.981  41.662  13.204  1.00 32.39           O  
ATOM   1039  CB  ALA A 137       7.949  42.512  12.433  1.00 33.45           C  
ATOM   1040  N   ALA A 138       6.001  39.977  12.095  1.00 32.40           N  
ATOM   1041  CA  ALA A 138       5.283  38.923  12.825  1.00 31.84           C  
ATOM   1042  C   ALA A 138       5.336  39.105  14.357  1.00 32.25           C  
ATOM   1043  O   ALA A 138       4.358  38.857  15.063  1.00 31.94           O  
ATOM   1044  CB  ALA A 138       5.893  37.614  12.487  1.00 33.23           C  
ATOM   1045  N   GLU A 139       6.504  39.495  14.854  1.00 30.61           N  
ATOM   1046  CA  GLU A 139       6.744  39.578  16.296  1.00 30.10           C  
ATOM   1047  C   GLU A 139       5.956  40.733  16.920  1.00 29.03           C  
ATOM   1048  O   GLU A 139       5.715  40.777  18.117  1.00 29.20           O  
ATOM   1049  CB  GLU A 139       8.245  39.700  16.526  1.00 31.19           C  
ATOM   1050  CG  GLU A 139       8.875  40.774  15.676  1.00 34.03           C  
ATOM   1051  CD  GLU A 139       9.538  40.261  14.415  1.00 39.01           C  
ATOM   1052  OE1 GLU A 139       9.163  39.189  13.885  1.00 40.96           O  
ATOM   1053  OE2 GLU A 139      10.455  40.973  13.938  1.00 44.48           O  
ATOM   1054  N   ASP A 140       5.501  41.645  16.068  1.00 28.05           N  
ATOM   1055  CA  ASP A 140       4.653  42.737  16.482  1.00 26.88           C  
ATOM   1056  C   ASP A 140       3.139  42.431  16.373  1.00 26.54           C  
ATOM   1057  O   ASP A 140       2.282  43.321  16.502  1.00 25.60           O  
ATOM   1058  CB  ASP A 140       5.076  43.973  15.711  1.00 28.15           C  
ATOM   1059  CG  ASP A 140       6.433  44.510  16.197  1.00 29.42           C  
ATOM   1060  OD1 ASP A 140       6.790  44.310  17.383  1.00 35.96           O  
ATOM   1061  OD2 ASP A 140       7.136  45.127  15.415  1.00 34.82           O  
ATOM   1062  N   THR A 141       2.816  41.152  16.191  1.00 25.47           N  
ATOM   1063  CA  THR A 141       1.434  40.742  16.186  1.00 25.05           C  
ATOM   1064  C   THR A 141       1.231  39.643  17.182  1.00 25.25           C  
ATOM   1065  O   THR A 141       2.198  39.040  17.684  1.00 26.75           O  
ATOM   1066  CB  THR A 141       0.963  40.188  14.754  1.00 25.96           C  
ATOM   1067  OG1 THR A 141       1.631  38.944  14.497  1.00 25.15           O  
ATOM   1068  CG2 THR A 141       1.291  41.188  13.632  1.00 21.58           C  
ATOM   1069  N   ARG A 142      -0.025  39.325  17.447  1.00 24.94           N  
ATOM   1070  CA  ARG A 142      -0.321  38.148  18.231  1.00 25.56           C  
ATOM   1071  C   ARG A 142      -1.690  37.630  17.850  1.00 25.45           C  
ATOM   1072  O   ARG A 142      -2.459  38.320  17.187  1.00 25.44           O  
ATOM   1073  CB  ARG A 142      -0.272  38.456  19.733  1.00 26.10           C  
ATOM   1074  CG  ARG A 142      -1.392  39.303  20.210  1.00 25.36           C  
ATOM   1075  CD  ARG A 142      -1.375  39.444  21.751  1.00 31.16           C  
ATOM   1076  NE  ARG A 142      -2.660  40.022  22.147  1.00 37.45           N  
ATOM   1077  CZ  ARG A 142      -2.846  41.322  22.247  1.00 38.60           C  
ATOM   1078  NH1 ARG A 142      -1.821  42.111  22.026  1.00 43.20           N  
ATOM   1079  NH2 ARG A 142      -4.027  41.824  22.588  1.00 40.89           N  
ATOM   1080  N   VAL A 143      -1.976  36.405  18.267  1.00 27.63           N  
ATOM   1081  CA  VAL A 143      -3.259  35.777  17.979  1.00 28.62           C  
ATOM   1082  C   VAL A 143      -4.138  35.872  19.199  1.00 30.40           C  
ATOM   1083  O   VAL A 143      -3.750  35.457  20.286  1.00 31.13           O  
ATOM   1084  CB  VAL A 143      -3.084  34.319  17.467  1.00 29.11           C  
ATOM   1085  CG1 VAL A 143      -4.475  33.617  17.302  1.00 28.07           C  
ATOM   1086  CG2 VAL A 143      -2.333  34.369  16.148  1.00 28.83           C  
ATOM   1087  N   SER A 144      -5.326  36.427  19.013  1.00 31.59           N  
ATOM   1088  CA  SER A 144      -6.190  36.786  20.114  1.00 35.33           C  
ATOM   1089  C   SER A 144      -7.530  36.066  20.041  1.00 37.87           C  
ATOM   1090  O   SER A 144      -8.169  36.032  18.991  1.00 36.57           O  
ATOM   1091  CB  SER A 144      -6.425  38.313  20.100  1.00 35.02           C  
ATOM   1092  OG  SER A 144      -7.317  38.703  21.137  1.00 34.71           O  
ATOM   1093  N   ARG A 145      -7.971  35.515  21.166  1.00 42.17           N  
ATOM   1094  CA  ARG A 145      -9.376  35.124  21.307  1.00 47.56           C  
ATOM   1095  C   ARG A 145     -10.309  36.350  21.546  1.00 49.32           C  
ATOM   1096  O   ARG A 145     -11.417  36.205  22.093  1.00 50.44           O  
ATOM   1097  CB  ARG A 145      -9.513  34.085  22.406  1.00 47.53           C  
ATOM   1098  CG  ARG A 145      -8.697  32.852  22.115  1.00 49.69           C  
ATOM   1099  CD  ARG A 145      -8.441  32.031  23.364  1.00 54.70           C  
ATOM   1100  NE  ARG A 145      -7.120  31.392  23.352  1.00 56.83           N  
ATOM   1101  CZ  ARG A 145      -6.833  30.242  22.736  1.00 59.41           C  
ATOM   1102  NH1 ARG A 145      -7.771  29.571  22.067  1.00 60.52           N  
ATOM   1103  NH2 ARG A 145      -5.606  29.743  22.808  1.00 59.52           N  
ATOM   1104  N   ASP A 146      -9.850  37.536  21.099  1.00 51.17           N  
ATOM   1105  CA  ASP A 146     -10.485  38.867  21.338  1.00 51.29           C  
ATOM   1106  C   ASP A 146     -11.122  39.038  22.720  1.00 52.45           C  
ATOM   1107  O   ASP A 146     -10.576  38.571  23.727  1.00 53.34           O  
ATOM   1108  CB  ASP A 146     -11.490  39.226  20.226  1.00 52.40           C  
ATOM   1109  CG  ASP A 146     -10.913  40.197  19.167  1.00 53.56           C  
ATOM   1110  OD1 ASP A 146     -11.731  40.936  18.551  1.00 57.40           O  
ATOM   1111  OD2 ASP A 146      -9.675  40.236  18.938  1.00 52.10           O  
TER    1112      ASP A 146                                                      
END
MOLECULE T0459.pdb
ATOM      1  N   SER     1     -10.415  21.770  17.737  1.00 36.73           N  
ATOM      2  CA  SER     1      -9.300  22.637  18.208  1.00 36.27           C  
ATOM      3  C   SER     1      -8.557  23.266  17.037  1.00 35.28           C  
ATOM      4  O   SER     1      -8.379  22.640  15.973  1.00 35.90           O  
ATOM      5  CB  SER     1      -8.351  21.893  19.152  1.00 36.84           C  
ATOM      6  OG  SER     1      -7.375  22.791  19.686  1.00 38.33           O  
ATOM      7  N   ASN     2      -8.124  24.504  17.269  1.00 33.96           N  
ATOM      8  CA  ASN     2      -7.662  25.408  16.215  0.50 33.06           C  
ATOM     10  C   ASN     2      -6.217  25.852  16.369  1.00 32.42           C  
ATOM     11  O   ASN     2      -5.703  25.916  17.477  1.00 32.77           O  
ATOM     12  CB  ASN     2      -8.522  26.677  16.208  0.50 33.17           C  
ATOM     14  CG  ASN     2      -9.904  26.457  15.620  0.50 33.12           C  
ATOM     16  OD1 ASN     2     -10.596  27.422  15.296  0.50 35.02           O  
ATOM     18  ND2 ASN     2     -10.312  25.197  15.473  0.50 31.87           N  
ATOM     20  N   ALA     3      -5.592  26.188  15.250  1.00 31.43           N  
ATOM     21  CA  ALA     3      -4.314  26.862  15.272  1.00 31.00           C  
ATOM     22  C   ALA     3      -4.652  28.337  15.273  1.00 30.63           C  
ATOM     23  O   ALA     3      -5.545  28.766  14.533  1.00 31.26           O  
ATOM     24  CB  ALA     3      -3.484  26.499  14.033  1.00 30.25           C  
ATOM     25  N   MET     4      -3.954  29.122  16.099  1.00 30.89           N  
ATOM     26  CA  MET     4      -4.173  30.557  16.181  1.00 30.57           C  
ATOM     27  C   MET     4      -2.912  31.223  15.687  1.00 29.89           C  
ATOM     28  O   MET     4      -1.831  31.018  16.275  1.00 29.61           O  
ATOM     29  CB  MET     4      -4.453  30.972  17.642  1.00 31.45           C  
ATOM     30  CG  MET     4      -5.831  30.585  18.117  1.00 34.71           C  
ATOM     31  SD  MET     4      -7.230  31.555  17.154  0.55 40.32          SE  
ATOM     32  CE  MET     4      -7.248  33.228  18.136  1.00 40.24           C  
ATOM     33  N   LEU     5      -3.022  31.969  14.595  1.00 29.52           N  
ATOM     34  CA  LEU     5      -1.845  32.551  13.938  1.00 30.45           C  
ATOM     35  C   LEU     5      -1.815  34.086  14.040  1.00 31.10           C  
ATOM     36  O   LEU     5      -2.754  34.760  13.649  1.00 32.83           O  
ATOM     37  CB  LEU     5      -1.743  32.099  12.465  1.00 29.59           C  
ATOM     38  CG  LEU     5      -2.214  30.669  12.242  1.00 30.64           C  
ATOM     39  CD1 LEU     5      -2.429  30.421  10.765  1.00 30.79           C  
ATOM     40  CD2 LEU     5      -1.193  29.717  12.859  1.00 27.96           C  
ATOM     41  N   ARG     6      -0.726  34.617  14.576  1.00 31.38           N  
ATOM     42  CA  ARG     6      -0.573  36.055  14.754  1.00 31.04           C  
ATOM     43  C   ARG     6      -0.465  36.732  13.387  1.00 30.97           C  
ATOM     44  O   ARG     6       0.359  36.338  12.565  1.00 32.05           O  
ATOM     45  CB  ARG     6       0.690  36.338  15.573  1.00 29.54           C  
ATOM     46  CG  ARG     6       1.027  37.817  15.740  1.00 33.13           C  
ATOM     47  CD  ARG     6      -0.136  38.565  16.275  1.00 33.20           C  
ATOM     48  NE  ARG     6      -0.526  38.164  17.630  1.00 33.00           N  
ATOM     49  CZ  ARG     6      -1.502  38.758  18.316  1.00 32.70           C  
ATOM     50  NH1 ARG     6      -1.812  38.328  19.523  1.00 30.79           N  
ATOM     51  NH2 ARG     6      -2.166  39.785  17.789  1.00 30.14           N  
ATOM     52  N   TYR     7      -1.294  37.754  13.164  1.00 30.67           N  
ATOM     53  CA  TYR     7      -1.218  38.537  11.932  1.00 30.64           C  
ATOM     54  C   TYR     7      -1.426  40.007  12.314  1.00 29.31           C  
ATOM     55  O   TYR     7      -2.557  40.492  12.356  1.00 29.58           O  
ATOM     56  CB  TYR     7      -2.276  38.071  10.921  1.00 30.37           C  
ATOM     57  CG  TYR     7      -2.256  38.775   9.583  1.00 31.58           C  
ATOM     58  CD1 TYR     7      -1.073  39.265   9.039  1.00 33.67           C  
ATOM     59  CD2 TYR     7      -3.426  38.915   8.837  1.00 31.83           C  
ATOM     60  CE1 TYR     7      -1.063  39.895   7.783  1.00 33.79           C  
ATOM     61  CE2 TYR     7      -3.420  39.529   7.601  1.00 33.39           C  
ATOM     62  CZ  TYR     7      -2.248  40.022   7.077  1.00 33.60           C  
ATOM     63  OH  TYR     7      -2.258  40.659   5.856  1.00 32.89           O  
ATOM     64  N   GLY     8      -0.335  40.706  12.641  1.00 29.52           N  
ATOM     65  CA  GLY     8      -0.478  42.089  13.106  1.00 29.08           C  
ATOM     66  C   GLY     8      -1.219  42.101  14.434  1.00 29.21           C  
ATOM     67  O   GLY     8      -0.928  41.314  15.325  1.00 29.78           O  
ATOM     68  N   ASP     9      -2.211  42.967  14.560  1.00 27.53           N  
ATOM     69  CA  ASP     9      -2.978  43.109  15.794  1.00 29.01           C  
ATOM     70  C   ASP     9      -4.059  42.029  15.926  1.00 28.64           C  
ATOM     71  O   ASP     9      -4.835  42.060  16.876  1.00 30.34           O  
ATOM     72  CB  ASP     9      -3.594  44.499  15.809  1.00 27.53           C  
ATOM     73  CG  ASP     9      -4.168  44.903  17.184  1.00 28.31           C  
ATOM     74  OD1 ASP     9      -3.576  44.591  18.255  1.00 27.20           O  
ATOM     75  OD2 ASP     9      -5.212  45.572  17.173  1.00 31.32           O  
ATOM     76  N   THR    10      -4.131  41.110  14.963  1.00 28.31           N  
ATOM     77  CA  THR    10      -5.215  40.131  14.895  1.00 29.02           C  
ATOM     78  C   THR    10      -4.652  38.709  15.031  1.00 27.83           C  
ATOM     79  O   THR    10      -3.436  38.485  14.855  1.00 27.98           O  
ATOM     80  CB  THR    10      -6.007  40.207  13.547  1.00 28.56           C  
ATOM     81  OG1 THR    10      -5.235  39.584  12.498  1.00 32.75           O  
ATOM     82  CG2 THR    10      -6.377  41.661  13.190  1.00 31.29           C  
ATOM     83  N   GLU    11      -5.522  37.757  15.346  1.00 26.75           N  
ATOM     84  CA  GLU    11      -5.136  36.351  15.200  1.00 28.15           C  
ATOM     85  C   GLU    11      -6.073  35.652  14.215  1.00 27.58           C  
ATOM     86  O   GLU    11      -7.293  35.848  14.254  1.00 27.69           O  
ATOM     87  CB  GLU    11      -5.099  35.638  16.554  1.00 27.56           C  
ATOM     88  CG  GLU    11      -4.013  36.141  17.491  1.00 30.04           C  
ATOM     89  CD  GLU    11      -4.107  35.489  18.861  1.00 34.00           C  
ATOM     90  OE1 GLU    11      -5.031  35.867  19.629  1.00 35.94           O  
ATOM     91  OE2 GLU    11      -3.266  34.612  19.176  1.00 33.57           O  
ATOM     92  N   ILE    12      -5.483  34.849  13.343  1.00 28.49           N  
ATOM     93  CA  ILE    12      -6.224  34.097  12.330  1.00 28.91           C  
ATOM     94  C   ILE    12      -6.443  32.708  12.938  1.00 28.83           C  
ATOM     95  O   ILE    12      -5.486  32.098  13.439  1.00 29.05           O  
ATOM     96  CB  ILE    12      -5.396  33.983  11.020  1.00 29.30           C  
ATOM     97  CG1 ILE    12      -5.011  35.389  10.494  1.00 31.03           C  
ATOM     98  CG2 ILE    12      -6.140  33.091   9.963  1.00 29.96           C  
ATOM     99  CD1 ILE    12      -3.927  35.376   9.367  1.00 31.07           C  
ATOM    100  N   CYS    13      -7.692  32.251  12.882  1.00 27.28           N  
ATOM    101  CA  CYS    13      -8.078  30.950  13.372  0.50 27.26           C  
ATOM    103  C   CYS    13      -8.209  29.961  12.206  1.00 28.00           C  
ATOM    104  O   CYS    13      -8.972  30.213  11.261  1.00 27.25           O  
ATOM    105  CB  CYS    13      -9.414  31.073  14.111  0.50 27.24           C  
ATOM    107  SG  CYS    13      -9.844  29.604  15.022  0.50 25.64           S  
ATOM    109  N   ILE    14      -7.452  28.860  12.267  1.00 27.87           N  
ATOM    110  CA  ILE    14      -7.549  27.773  11.287  1.00 28.04           C  
ATOM    111  C   ILE    14      -7.750  26.429  11.994  1.00 28.25           C  
ATOM    112  O   ILE    14      -6.969  26.035  12.867  1.00 28.02           O  
ATOM    113  CB  ILE    14      -6.265  27.649  10.389  1.00 27.07           C  
ATOM    114  CG1 ILE    14      -5.966  28.980   9.657  1.00 28.97           C  
ATOM    115  CG2 ILE    14      -6.350  26.422   9.419  1.00 27.42           C  
ATOM    116  CD1 ILE    14      -6.819  29.234   8.425  1.00 28.09           C  
ATOM    117  N   ASP    15      -8.777  25.714  11.588  1.00 28.87           N  
ATOM    118  CA  ASP    15      -8.945  24.371  12.055  1.00 30.05           C  
ATOM    119  C   ASP    15      -8.263  23.415  11.067  1.00 31.28           C  
ATOM    120  O   ASP    15      -8.756  23.220   9.966  1.00 31.16           O  
ATOM    121  CB  ASP    15     -10.434  24.082  12.189  1.00 30.09           C  
ATOM    122  CG  ASP    15     -10.708  22.784  12.894  1.00 30.26           C  
ATOM    123  OD1 ASP    15      -9.748  22.031  13.153  1.00 32.36           O  
ATOM    124  OD2 ASP    15     -11.892  22.515  13.186  1.00 30.84           O  
ATOM    125  N   PRO    16      -7.133  22.799  11.470  1.00 32.52           N  
ATOM    126  CA  PRO    16      -6.366  22.006  10.524  1.00 33.72           C  
ATOM    127  C   PRO    16      -7.133  20.771  10.042  1.00 34.14           C  
ATOM    128  O   PRO    16      -6.857  20.285   8.952  1.00 35.37           O  
ATOM    129  CB  PRO    16      -5.117  21.598  11.324  1.00 33.18           C  
ATOM    130  CG  PRO    16      -5.070  22.521  12.481  1.00 34.54           C  
ATOM    131  CD  PRO    16      -6.514  22.776  12.806  1.00 33.05           C  
ATOM    132  N   SER    17      -8.095  20.287  10.833  1.00 35.19           N  
ATOM    133  CA  SER    17      -8.889  19.114  10.454  1.00 35.46           C  
ATOM    134  C   SER    17     -10.103  19.438   9.566  1.00 35.43           C  
ATOM    135  O   SER    17     -10.689  18.533   8.970  1.00 35.51           O  
ATOM    136  CB  SER    17      -9.323  18.324  11.694  1.00 35.69           C  
ATOM    137  OG  SER    17     -10.303  19.026  12.444  1.00 35.63           O  
ATOM    138  N   GLU    18     -10.492  20.715   9.519  1.00 35.21           N  
ATOM    139  CA  GLU    18     -11.559  21.189   8.631  0.50 35.18           C  
ATOM    141  C   GLU    18     -11.283  22.617   8.158  1.00 35.05           C  
ATOM    142  O   GLU    18     -11.663  23.598   8.809  1.00 35.41           O  
ATOM    143  CB  GLU    18     -12.934  21.076   9.299  0.50 35.13           C  
ATOM    145  CG  GLU    18     -13.636  19.744   9.037  0.50 35.62           C  
ATOM    147  CD  GLU    18     -15.015  19.656   9.662  0.50 35.62           C  
ATOM    149  OE1 GLU    18     -15.498  18.516   9.856  0.50 37.29           O  
ATOM    151  OE2 GLU    18     -15.618  20.715   9.959  0.50 36.60           O  
ATOM    153  N   SER    19     -10.578  22.722   7.042  1.00 34.61           N  
ATOM    154  CA  SER    19     -10.251  23.990   6.427  1.00 33.27           C  
ATOM    155  C   SER    19      -9.994  23.714   4.972  1.00 33.78           C  
ATOM    156  O   SER    19      -9.529  22.624   4.618  1.00 34.23           O  
ATOM    157  CB  SER    19      -8.959  24.579   7.013  1.00 33.81           C  
ATOM    158  OG  SER    19      -8.575  25.719   6.249  1.00 31.21           O  
ATOM    159  N   VAL    20     -10.272  24.705   4.130  1.00 32.42           N  
ATOM    160  CA  VAL    20      -9.977  24.617   2.696  1.00 32.16           C  
ATOM    161  C   VAL    20      -8.453  24.665   2.466  1.00 30.52           C  
ATOM    162  O   VAL    20      -7.976  24.456   1.359  1.00 29.18           O  
ATOM    163  CB  VAL    20     -10.799  25.651   1.899  1.00 32.40           C  
ATOM    164  CG1 VAL    20     -10.376  27.082   2.223  1.00 33.30           C  
ATOM    165  CG2 VAL    20     -10.736  25.355   0.412  1.00 34.67           C  
ATOM    166  N   LEU    21      -7.706  24.923   3.541  1.00 29.65           N  
ATOM    167  CA  LEU    21      -6.253  24.853   3.500  1.00 28.31           C  
ATOM    168  C   LEU    21      -5.823  23.451   3.035  1.00 28.00           C  
ATOM    169  O   LEU    21      -4.853  23.340   2.297  1.00 27.24           O  
ATOM    170  CB  LEU    21      -5.656  25.160   4.885  1.00 29.04           C  
ATOM    171  CG  LEU    21      -4.133  25.098   5.000  1.00 29.06           C  
ATOM    172  CD1 LEU    21      -3.468  26.066   4.034  1.00 30.76           C  
ATOM    173  CD2 LEU    21      -3.743  25.385   6.456  1.00 28.18           C  
ATOM    174  N   HIS    22      -6.556  22.406   3.447  1.00 28.90           N  
ATOM    175  CA  HIS    22      -6.261  21.027   3.059  1.00 30.07           C  
ATOM    176  C   HIS    22      -6.226  20.912   1.547  1.00 29.78           C  
ATOM    177  O   HIS    22      -5.251  20.412   0.960  1.00 29.81           O  
ATOM    178  CB  HIS    22      -7.317  20.060   3.652  1.00 29.57           C  
ATOM    179  CG  HIS    22      -7.121  18.620   3.283  1.00 32.86           C  
ATOM    180  ND1 HIS    22      -6.237  17.801   3.948  1.00 36.16           N  
ATOM    181  CD2 HIS    22      -7.733  17.840   2.360  1.00 34.12           C  
ATOM    182  CE1 HIS    22      -6.294  16.579   3.437  1.00 36.42           C  
ATOM    183  NE2 HIS    22      -7.190  16.577   2.466  1.00 36.45           N  
ATOM    184  N   LEU    23      -7.285  21.393   0.913  1.00 30.25           N  
ATOM    185  CA  LEU    23      -7.368  21.335  -0.557  1.00 30.37           C  
ATOM    186  C   LEU    23      -6.252  22.166  -1.182  1.00 32.08           C  
ATOM    187  O   LEU    23      -5.524  21.680  -2.070  1.00 32.10           O  
ATOM    188  CB  LEU    23      -8.720  21.857  -1.021  1.00 30.65           C  
ATOM    189  CG  LEU    23      -8.897  22.039  -2.536  1.00 30.24           C  
ATOM    190  CD1 LEU    23      -8.535  20.766  -3.354  1.00 33.22           C  
ATOM    191  CD2 LEU    23     -10.331  22.521  -2.824  1.00 30.94           C  
ATOM    192  N   LEU    24      -6.104  23.391  -0.684  1.00 31.13           N  
ATOM    193  CA  LEU    24      -5.102  24.306  -1.222  0.50 32.96           C  
ATOM    195  C   LEU    24      -3.688  23.739  -1.206  1.00 32.52           C  
ATOM    196  O   LEU    24      -2.888  24.059  -2.084  1.00 33.32           O  
ATOM    197  CB  LEU    24      -5.166  25.659  -0.514  0.50 32.98           C  
ATOM    199  CG  LEU    24      -5.817  26.795  -1.310  0.50 35.89           C  
ATOM    201  CD1 LEU    24      -4.761  27.454  -2.172  0.50 35.58           C  
ATOM    203  CD2 LEU    24      -7.035  26.378  -2.160  0.50 34.56           C  
ATOM    205  N   GLY    25      -3.403  22.889  -0.235  1.00 32.78           N  
ATOM    206  CA  GLY    25      -2.078  22.271  -0.122  1.00 32.77           C  
ATOM    207  C   GLY    25      -1.807  21.076  -1.029  1.00 32.09           C  
ATOM    208  O   GLY    25      -0.650  20.775  -1.316  1.00 32.25           O  
ATOM    209  N   LYS    26      -2.856  20.387  -1.470  1.00 31.77           N  
ATOM    210  CA  LYS    26      -2.693  19.222  -2.330  1.00 31.54           C  
ATOM    211  C   LYS    26      -1.923  19.602  -3.599  1.00 30.09           C  
ATOM    212  O   LYS    26      -2.096  20.721  -4.130  1.00 30.18           O  
ATOM    213  CB  LYS    26      -4.059  18.649  -2.710  1.00 32.58           C  
ATOM    214  CG  LYS    26      -4.788  18.002  -1.562  1.00 32.14           C  
ATOM    215  CD  LYS    26      -6.073  17.350  -2.043  1.00 34.07           C  
ATOM    216  CE  LYS    26      -7.020  17.150  -0.861  1.00 33.53           C  
ATOM    217  NZ  LYS    26      -7.663  15.793  -0.867  1.00 32.24           N  
ATOM    218  N   LYS    27      -1.108  18.658  -4.079  1.00 29.46           N  
ATOM    219  CA  LYS    27      -0.247  18.883  -5.225  1.00 28.20           C  
ATOM    220  C   LYS    27      -1.054  19.512  -6.367  1.00 28.47           C  
ATOM    221  O   LYS    27      -2.137  19.019  -6.699  1.00 27.82           O  
ATOM    222  CB  LYS    27       0.416  17.575  -5.684  1.00 28.29           C  
ATOM    223  CG  LYS    27       1.558  17.841  -6.624  1.00 27.35           C  
ATOM    224  CD  LYS    27       2.366  16.571  -6.953  1.00 28.02           C  
ATOM    225  CE  LYS    27       3.506  16.937  -7.892  1.00 32.06           C  
ATOM    226  NZ  LYS    27       4.144  18.235  -7.451  1.00 36.20           N  
ATOM    227  N   TYR    28      -0.517  20.598  -6.946  1.00 28.32           N  
ATOM    228  CA  TYR    28      -1.099  21.296  -8.107  1.00 28.81           C  
ATOM    229  C   TYR    28      -2.205  22.310  -7.836  1.00 28.80           C  
ATOM    230  O   TYR    28      -2.531  23.094  -8.711  1.00 29.16           O  
ATOM    231  CB  TYR    28      -1.559  20.314  -9.194  1.00 29.50           C  
ATOM    232  CG  TYR    28      -0.450  19.424  -9.733  1.00 28.58           C  
ATOM    233  CD1 TYR    28      -0.473  18.049  -9.500  1.00 28.14           C  
ATOM    234  CD2 TYR    28       0.598  19.954 -10.506  1.00 29.00           C  
ATOM    235  CE1 TYR    28       0.524  17.238  -9.999  1.00 26.00           C  
ATOM    236  CE2 TYR    28       1.591  19.138 -11.004  1.00 29.83           C  
ATOM    237  CZ  TYR    28       1.546  17.785 -10.750  1.00 28.24           C  
ATOM    238  OH  TYR    28       2.518  16.953 -11.254  1.00 32.25           O  
ATOM    239  N   THR    29      -2.806  22.288  -6.652  1.00 29.70           N  
ATOM    240  CA  THR    29      -4.030  23.111  -6.461  1.00 28.91           C  
ATOM    241  C   THR    29      -3.724  24.580  -6.628  1.00 28.79           C  
ATOM    242  O   THR    29      -4.461  25.297  -7.314  1.00 29.77           O  
ATOM    243  CB  THR    29      -4.723  22.829  -5.115  1.00 28.38           C  
ATOM    244  OG1 THR    29      -5.036  21.427  -5.024  1.00 29.94           O  
ATOM    245  CG2 THR    29      -6.051  23.661  -4.985  1.00 29.10           C  
ATOM    246  N   MET    30      -2.620  25.026  -6.029  1.00 28.10           N  
ATOM    247  CA  MET    30      -2.255  26.452  -6.125  1.00 29.83           C  
ATOM    248  C   MET    30      -1.906  26.795  -7.568  1.00 30.09           C  
ATOM    249  O   MET    30      -2.248  27.882  -8.076  1.00 30.64           O  
ATOM    250  CB  MET    30      -1.124  26.810  -5.159  1.00 28.47           C  
ATOM    251  CG  MET    30      -1.574  26.776  -3.713  1.00 31.09           C  
ATOM    252  SD  MET    30      -0.134  27.257  -2.471  0.70 33.89          SE  
ATOM    253  CE  MET    30       0.430  25.413  -2.065  1.00 34.51           C  
ATOM    254  N   LEU    31      -1.256  25.865  -8.251  1.00 29.49           N  
ATOM    255  CA  LEU    31      -0.925  26.090  -9.670  1.00 29.99           C  
ATOM    256  C   LEU    31      -2.194  26.139 -10.532  1.00 30.67           C  
ATOM    257  O   LEU    31      -2.239  26.936 -11.482  1.00 29.61           O  
ATOM    258  CB  LEU    31       0.010  25.028 -10.176  1.00 28.61           C  
ATOM    259  CG  LEU    31       1.444  25.100  -9.620  1.00 27.57           C  
ATOM    260  CD1 LEU    31       2.213  23.844 -10.095  1.00 29.53           C  
ATOM    261  CD2 LEU    31       2.111  26.434  -9.955  1.00 32.58           C  
ATOM    262  N   ILE    32      -3.185  25.287 -10.245  1.00 29.61           N  
ATOM    263  CA  ILE    32      -4.465  25.322 -11.009  1.00 29.63           C  
ATOM    264  C   ILE    32      -5.139  26.703 -10.810  1.00 29.77           C  
ATOM    265  O   ILE    32      -5.554  27.360 -11.786  1.00 31.22           O  
ATOM    266  CB  ILE    32      -5.391  24.184 -10.600  1.00 30.11           C  
ATOM    267  CG1 ILE    32      -4.787  22.835 -11.077  1.00 28.44           C  
ATOM    268  CG2 ILE    32      -6.790  24.419 -11.191  1.00 28.91           C  
ATOM    269  CD1 ILE    32      -5.362  21.530 -10.391  1.00 31.16           C  
ATOM    270  N   ILE    33      -5.281  27.127  -9.558  1.00 29.65           N  
ATOM    271  CA  ILE    33      -5.825  28.471  -9.275  1.00 29.78           C  
ATOM    272  C   ILE    33      -5.058  29.559 -10.007  1.00 30.83           C  
ATOM    273  O   ILE    33      -5.651  30.456 -10.577  1.00 31.62           O  
ATOM    274  CB  ILE    33      -5.892  28.755  -7.747  1.00 29.54           C  
ATOM    275  CG1 ILE    33      -6.877  27.749  -7.103  1.00 30.49           C  
ATOM    276  CG2 ILE    33      -6.181  30.256  -7.430  1.00 28.42           C  
ATOM    277  CD1 ILE    33      -6.852  27.715  -5.549  1.00 31.56           C  
ATOM    278  N   SER    34      -3.729  29.467  -9.981  1.00 30.02           N  
ATOM    279  CA  SER    34      -2.897  30.477 -10.652  1.00 29.45           C  
ATOM    280  C   SER    34      -3.117  30.504 -12.175  1.00 28.34           C  
ATOM    281  O   SER    34      -3.298  31.591 -12.793  1.00 29.92           O  
ATOM    282  CB  SER    34      -1.442  30.180 -10.331  1.00 29.54           C  
ATOM    283  OG  SER    34      -1.235  30.181  -8.916  1.00 33.14           O  
ATOM    284  N   VAL    35      -3.111  29.343 -12.809  1.00 29.48           N  
ATOM    285  CA  VAL    35      -3.217  29.353 -14.278  0.50 29.47           C  
ATOM    287  C   VAL    35      -4.628  29.763 -14.714  1.00 29.83           C  
ATOM    288  O   VAL    35      -4.791  30.347 -15.768  1.00 29.45           O  
ATOM    289  CB  VAL    35      -2.722  28.043 -14.974  0.50 29.52           C  
ATOM    291  CG1 VAL    35      -1.229  27.826 -14.719  0.50 29.61           C  
ATOM    293  CG2 VAL    35      -3.564  26.808 -14.566  0.50 29.25           C  
ATOM    295  N   LEU    36      -5.645  29.463 -13.891  1.00 29.61           N  
ATOM    296  CA  LEU    36      -7.026  29.830 -14.265  1.00 31.83           C  
ATOM    297  C   LEU    36      -7.212  31.343 -14.373  1.00 32.62           C  
ATOM    298  O   LEU    36      -8.154  31.860 -15.026  1.00 33.33           O  
ATOM    299  CB  LEU    36      -8.044  29.180 -13.312  1.00 31.76           C  
ATOM    300  CG  LEU    36      -8.439  27.744 -13.631  1.00 34.33           C  
ATOM    301  CD1 LEU    36      -9.255  27.121 -12.524  1.00 33.48           C  
ATOM    302  CD2 LEU    36      -9.178  27.642 -14.990  1.00 33.15           C  
ATOM    303  N   GLY    37      -6.299  32.068 -13.741  1.00 32.67           N  
ATOM    304  CA  GLY    37      -6.279  33.536 -13.828  1.00 34.43           C  
ATOM    305  C   GLY    37      -5.287  34.122 -14.824  1.00 34.47           C  
ATOM    306  O   GLY    37      -5.086  35.329 -14.829  1.00 34.99           O  
ATOM    307  N   ASN    38      -4.641  33.283 -15.638  1.00 35.53           N  
ATOM    308  CA  ASN    38      -3.778  33.728 -16.753  1.00 35.74           C  
ATOM    309  C   ASN    38      -4.611  34.108 -17.985  1.00 37.71           C  
ATOM    310  O   ASN    38      -5.821  33.904 -17.997  1.00 38.33           O  
ATOM    311  CB  ASN    38      -2.888  32.596 -17.240  1.00 35.54           C  
ATOM    312  CG  ASN    38      -1.743  32.260 -16.305  1.00 32.45           C  
ATOM    313  OD1 ASN    38      -1.418  32.983 -15.360  1.00 31.30           O  
ATOM    314  ND2 ASN    38      -1.086  31.167 -16.616  1.00 29.32           N  
ATOM    315  N   GLY    39      -3.966  34.615 -19.038  1.00 39.07           N  
ATOM    316  CA  GLY    39      -4.673  34.919 -20.316  1.00 40.35           C  
ATOM    317  C   GLY    39      -5.968  35.731 -20.235  1.00 40.83           C  
ATOM    318  O   GLY    39      -6.278  36.332 -19.194  1.00 40.09           O  
ATOM    319  N   SER    40      -6.740  35.732 -21.329  1.00 41.52           N  
ATOM    320  CA  SER    40      -7.865  36.680 -21.492  1.00 42.35           C  
ATOM    321  C   SER    40      -9.234  36.028 -21.721  1.00 42.42           C  
ATOM    322  O   SER    40     -10.228  36.715 -22.004  1.00 43.03           O  
ATOM    323  CB  SER    40      -7.598  37.601 -22.677  1.00 42.11           C  
ATOM    324  OG  SER    40      -6.233  37.572 -23.040  1.00 45.27           O  
ATOM    325  N   THR    41      -9.281  34.709 -21.618  1.00 41.48           N  
ATOM    326  CA  THR    41     -10.417  33.957 -22.134  1.00 41.13           C  
ATOM    327  C   THR    41     -10.581  32.795 -21.206  1.00 39.96           C  
ATOM    328  O   THR    41      -9.594  32.339 -20.624  1.00 40.02           O  
ATOM    329  CB  THR    41     -10.133  33.399 -23.575  1.00 41.46           C  
ATOM    330  OG1 THR    41      -8.956  32.575 -23.555  1.00 43.48           O  
ATOM    331  CG2 THR    41      -9.929  34.522 -24.578  1.00 41.84           C  
ATOM    332  N   ARG    42     -11.815  32.308 -21.068  1.00 38.48           N  
ATOM    333  CA  ARG    42     -12.038  31.048 -20.363  1.00 36.84           C  
ATOM    334  C   ARG    42     -11.213  29.948 -21.033  1.00 35.70           C  
ATOM    335  O   ARG    42     -11.159  29.866 -22.259  1.00 35.70           O  
ATOM    336  CB  ARG    42     -13.520  30.666 -20.399  1.00 37.38           C  
ATOM    337  CG  ARG    42     -14.437  31.647 -19.684  1.00 37.62           C  
ATOM    338  CD  ARG    42     -15.883  31.164 -19.697  1.00 36.40           C  
ATOM    339  NE  ARG    42     -16.009  29.965 -18.858  1.00 36.40           N  
ATOM    340  CZ  ARG    42     -16.427  29.976 -17.597  1.00 35.20           C  
ATOM    341  NH1 ARG    42     -16.782  31.144 -17.033  1.00 34.57           N  
ATOM    342  NH2 ARG    42     -16.491  28.833 -16.902  1.00 36.13           N  
ATOM    343  N   GLN    43     -10.641  29.067 -20.218  1.00 34.69           N  
ATOM    344  CA  GLN    43      -9.776  27.977 -20.710  1.00 33.10           C  
ATOM    345  C   GLN    43     -10.503  26.657 -20.692  1.00 32.14           C  
ATOM    346  O   GLN    43     -11.269  26.403 -19.771  1.00 31.59           O  
ATOM    347  CB  GLN    43      -8.558  27.878 -19.802  1.00 33.74           C  
ATOM    348  CG  GLN    43      -7.930  29.264 -19.605  1.00 37.32           C  
ATOM    349  CD  GLN    43      -6.791  29.275 -18.585  1.00 43.97           C  
ATOM    350  OE1 GLN    43      -6.081  28.282 -18.413  1.00 50.03           O  
ATOM    351  NE2 GLN    43      -6.602  30.405 -17.932  1.00 44.66           N  
ATOM    352  N   ASN    44     -10.218  25.808 -21.680  1.00 28.58           N  
ATOM    353  CA  ASN    44     -10.733  24.442 -21.672  1.00 30.12           C  
ATOM    354  C   ASN    44      -9.770  23.560 -20.902  1.00 29.00           C  
ATOM    355  O   ASN    44      -8.722  24.046 -20.428  1.00 29.15           O  
ATOM    356  CB  ASN    44     -11.008  23.943 -23.097  1.00 28.73           C  
ATOM    357  CG  ASN    44      -9.755  23.877 -23.979  1.00 31.42           C  
ATOM    358  OD1 ASN    44      -8.635  23.648 -23.517  1.00 29.93           O  
ATOM    359  ND2 ASN    44      -9.952  24.097 -25.267  1.00 32.12           N  
ATOM    360  N   PHE    45     -10.112  22.277 -20.766  1.00 29.73           N  
ATOM    361  CA  PHE    45      -9.364  21.377 -19.899  1.00 30.13           C  
ATOM    362  C   PHE    45      -7.960  21.157 -20.412  1.00 30.35           C  
ATOM    363  O   PHE    45      -6.999  21.168 -19.616  1.00 29.85           O  
ATOM    364  CB  PHE    45     -10.114  20.083 -19.809  1.00 29.47           C  
ATOM    365  CG  PHE    45      -9.574  19.123 -18.815  1.00 29.78           C  
ATOM    366  CD1 PHE    45     -10.087  19.075 -17.518  1.00 30.76           C  
ATOM    367  CD2 PHE    45      -8.607  18.178 -19.209  1.00 30.09           C  
ATOM    368  CE1 PHE    45      -9.611  18.123 -16.595  1.00 30.36           C  
ATOM    369  CE2 PHE    45      -8.137  17.209 -18.309  1.00 30.04           C  
ATOM    370  CZ  PHE    45      -8.638  17.197 -16.999  1.00 30.03           C  
ATOM    371  N   ASN    46      -7.834  21.028 -21.730  1.00 30.11           N  
ATOM    372  CA  ASN    46      -6.501  20.863 -22.338  0.50 30.41           C  
ATOM    374  C   ASN    46      -5.610  22.071 -22.137  1.00 30.53           C  
ATOM    375  O   ASN    46      -4.413  21.919 -21.905  1.00 31.41           O  
ATOM    376  CB  ASN    46      -6.559  20.545 -23.836  0.50 30.92           C  
ATOM    378  CG  ASN    46      -5.186  20.274 -24.410  0.50 31.12           C  
ATOM    380  OD1 ASN    46      -4.574  19.255 -24.104  0.50 32.62           O  
ATOM    382  ND2 ASN    46      -4.692  21.178 -25.256  0.50 32.99           N  
ATOM    384  N   ASP    47      -6.194  23.271 -22.225  1.00 30.93           N  
ATOM    385  CA  ASP    47      -5.454  24.548 -22.028  1.00 32.46           C  
ATOM    386  C   ASP    47      -4.799  24.554 -20.632  1.00 31.87           C  
ATOM    387  O   ASP    47      -3.628  24.926 -20.456  1.00 30.64           O  
ATOM    388  CB  ASP    47      -6.390  25.776 -22.042  1.00 33.84           C  
ATOM    389  CG  ASP    47      -6.939  26.136 -23.421  1.00 36.73           C  
ATOM    390  OD1 ASP    47      -6.247  25.869 -24.457  1.00 37.68           O  
ATOM    391  OD2 ASP    47      -8.069  26.741 -23.444  1.00 37.94           O  
ATOM    392  N   ILE    48      -5.610  24.187 -19.646  1.00 30.43           N  
ATOM    393  CA  ILE    48      -5.194  24.155 -18.240  1.00 30.48           C  
ATOM    394  C   ILE    48      -4.104  23.108 -18.043  1.00 30.36           C  
ATOM    395  O   ILE    48      -3.036  23.404 -17.506  1.00 29.97           O  
ATOM    396  CB  ILE    48      -6.371  23.864 -17.297  1.00 30.17           C  
ATOM    397  CG1 ILE    48      -7.419  24.969 -17.401  1.00 30.92           C  
ATOM    398  CG2 ILE    48      -5.905  23.796 -15.860  1.00 28.80           C  
ATOM    399  CD1 ILE    48      -8.842  24.500 -16.885  1.00 31.00           C  
ATOM    400  N   ARG    49      -4.369  21.883 -18.500  1.00 29.39           N  
ATOM    401  CA  ARG    49      -3.420  20.778 -18.350  1.00 30.94           C  
ATOM    402  C   ARG    49      -2.065  21.091 -19.006  1.00 30.35           C  
ATOM    403  O   ARG    49      -1.009  20.856 -18.406  1.00 30.44           O  
ATOM    404  CB  ARG    49      -4.045  19.488 -18.920  1.00 30.61           C  
ATOM    405  CG  ARG    49      -3.149  18.233 -18.873  1.00 31.60           C  
ATOM    406  CD  ARG    49      -3.826  17.004 -19.546  1.00 34.32           C  
ATOM    407  NE  ARG    49      -4.109  17.268 -20.958  1.00 39.66           N  
ATOM    408  CZ  ARG    49      -5.158  16.807 -21.645  1.00 43.59           C  
ATOM    409  NH1 ARG    49      -5.287  17.135 -22.920  1.00 45.11           N  
ATOM    410  NH2 ARG    49      -6.084  16.029 -21.078  1.00 45.51           N  
ATOM    411  N   SER    50      -2.101  21.680 -20.210  1.00 30.07           N  
ATOM    412  CA  SER    50      -0.892  22.038 -20.951  1.00 31.54           C  
ATOM    413  C   SER    50      -0.062  23.098 -20.259  1.00 31.04           C  
ATOM    414  O   SER    50       1.149  23.188 -20.479  1.00 30.98           O  
ATOM    415  CB  SER    50      -1.277  22.565 -22.323  1.00 31.85           C  
ATOM    416  OG  SER    50      -1.782  21.515 -23.117  1.00 35.55           O  
ATOM    417  N   SER    51      -0.726  23.903 -19.430  1.00 30.50           N  
ATOM    418  CA  SER    51      -0.096  25.011 -18.723  0.50 30.66           C  
ATOM    420  C   SER    51       0.581  24.579 -17.419  1.00 30.93           C  
ATOM    421  O   SER    51       1.285  25.365 -16.798  1.00 31.22           O  
ATOM    422  CB  SER    51      -1.136  26.084 -18.412  0.50 30.43           C  
ATOM    424  OG  SER    51      -1.691  26.608 -19.599  0.50 30.15           O  
ATOM    426  N   ILE    52       0.358  23.332 -16.992  1.00 30.63           N  
ATOM    427  CA  ILE    52       0.962  22.825 -15.761  1.00 30.93           C  
ATOM    428  C   ILE    52       1.750  21.562 -16.111  1.00 31.45           C  
ATOM    429  O   ILE    52       1.195  20.460 -16.071  1.00 30.76           O  
ATOM    430  CB  ILE    52      -0.103  22.540 -14.635  1.00 30.84           C  
ATOM    431  CG1 ILE    52      -0.951  23.787 -14.375  1.00 31.83           C  
ATOM    432  CG2 ILE    52       0.588  22.082 -13.347  1.00 33.13           C  
ATOM    433  CD1 ILE    52      -2.186  23.546 -13.496  1.00 30.67           C  
ATOM    434  N   PRO    53       3.082  21.708 -16.248  0.50 32.17           N  
ATOM    436  CA  PRO    53       3.995  20.623 -16.611  0.50 32.18           C  
ATOM    438  C   PRO    53       3.709  19.347 -15.822  0.50 32.28           C  
ATOM    440  O   PRO    53       3.717  19.382 -14.589  0.50 32.32           O  
ATOM    442  CB  PRO    53       5.360  21.173 -16.185  0.50 32.32           C  
ATOM    444  CG  PRO    53       5.235  22.622 -16.320  0.50 32.43           C  
ATOM    446  CD  PRO    53       3.811  22.965 -15.984  0.50 31.62           C  
ATOM    448  N   GLY    54       3.447  18.225 -16.496  1.00 32.85           N  
ATOM    449  CA  GLY    54       3.374  17.000 -15.702  1.00 32.55           C  
ATOM    450  C   GLY    54       2.099  16.623 -14.957  1.00 31.92           C  
ATOM    451  O   GLY    54       2.011  15.492 -14.456  1.00 32.11           O  
ATOM    452  N   ILE    55       1.118  17.529 -14.849  1.00 30.84           N  
ATOM    453  CA  ILE    55      -0.154  17.165 -14.215  1.00 30.41           C  
ATOM    454  C   ILE    55      -0.915  16.120 -15.068  1.00 29.49           C  
ATOM    455  O   ILE    55      -0.989  16.260 -16.283  1.00 30.15           O  
ATOM    456  CB  ILE    55      -1.063  18.423 -13.944  1.00 29.10           C  
ATOM    457  CG1 ILE    55      -2.135  18.085 -12.899  1.00 29.13           C  
ATOM    458  CG2 ILE    55      -1.667  18.984 -15.247  1.00 29.74           C  
ATOM    459  CD1 ILE    55      -2.960  19.283 -12.328  1.00 31.94           C  
ATOM    460  N   SER    56      -1.463  15.079 -14.438  1.00 29.28           N  
ATOM    461  CA  SER    56      -2.278  14.092 -15.168  1.00 29.08           C  
ATOM    462  C   SER    56      -3.714  14.586 -15.333  1.00 28.45           C  
ATOM    463  O   SER    56      -4.179  15.450 -14.576  1.00 29.02           O  
ATOM    464  CB  SER    56      -2.299  12.746 -14.442  1.00 28.31           C  
ATOM    465  OG  SER    56      -2.957  12.908 -13.195  1.00 29.25           O  
ATOM    466  N   SER    57      -4.406  14.056 -16.344  1.00 28.29           N  
ATOM    467  CA  SER    57      -5.828  14.379 -16.512  1.00 29.38           C  
ATOM    468  C   SER    57      -6.598  13.995 -15.255  1.00 29.47           C  
ATOM    469  O   SER    57      -7.478  14.724 -14.829  1.00 30.03           O  
ATOM    470  CB  SER    57      -6.435  13.657 -17.706  1.00 30.29           C  
ATOM    471  OG  SER    57      -5.870  14.138 -18.902  1.00 32.01           O  
ATOM    472  N   THR    58      -6.284  12.829 -14.689  1.00 29.45           N  
ATOM    473  CA  THR    58      -6.990  12.360 -13.493  1.00 29.58           C  
ATOM    474  C   THR    58      -6.852  13.352 -12.330  1.00 29.16           C  
ATOM    475  O   THR    58      -7.844  13.700 -11.705  1.00 28.38           O  
ATOM    476  CB  THR    58      -6.582  10.923 -13.070  1.00 30.87           C  
ATOM    477  OG1 THR    58      -7.006   9.978 -14.073  1.00 30.95           O  
ATOM    478  CG2 THR    58      -7.222  10.541 -11.705  1.00 31.28           C  
ATOM    479  N   ILE    59      -5.627  13.765 -12.025  1.00 27.97           N  
ATOM    480  CA  ILE    59      -5.407  14.700 -10.912  1.00 29.61           C  
ATOM    481  C   ILE    59      -6.061  16.042 -11.228  1.00 29.82           C  
ATOM    482  O   ILE    59      -6.692  16.670 -10.357  1.00 29.80           O  
ATOM    483  CB  ILE    59      -3.881  14.856 -10.573  1.00 29.39           C  
ATOM    484  CG1 ILE    59      -3.316  13.496 -10.114  1.00 32.81           C  
ATOM    485  CG2 ILE    59      -3.632  16.061  -9.578  1.00 30.71           C  
ATOM    486  CD1 ILE    59      -3.982  12.929  -8.899  1.00 36.38           C  
ATOM    487  N   LEU    60      -5.922  16.507 -12.470  1.00 29.61           N  
ATOM    488  CA  LEU    60      -6.524  17.797 -12.820  1.00 28.72           C  
ATOM    489  C   LEU    60      -8.036  17.760 -12.640  1.00 29.13           C  
ATOM    490  O   LEU    60      -8.622  18.704 -12.099  1.00 29.42           O  
ATOM    491  CB  LEU    60      -6.157  18.260 -14.223  1.00 29.24           C  
ATOM    492  CG  LEU    60      -6.748  19.605 -14.712  1.00 28.18           C  
ATOM    493  CD1 LEU    60      -6.409  20.769 -13.803  1.00 29.10           C  
ATOM    494  CD2 LEU    60      -6.285  19.900 -16.141  1.00 29.94           C  
ATOM    495  N   SER    61      -8.653  16.682 -13.083  1.00 28.67           N  
ATOM    496  CA  SER    61     -10.114  16.544 -12.999  1.00 27.98           C  
ATOM    497  C   SER    61     -10.550  16.492 -11.516  1.00 28.84           C  
ATOM    498  O   SER    61     -11.545  17.126 -11.124  1.00 30.15           O  
ATOM    499  CB  SER    61     -10.545  15.269 -13.742  1.00 28.77           C  
ATOM    500  OG  SER    61     -11.943  15.111 -13.618  1.00 30.82           O  
ATOM    501  N   ARG    62      -9.804  15.751 -10.700  1.00 28.63           N  
ATOM    502  CA  ARG    62     -10.132  15.579  -9.274  0.50 29.99           C  
ATOM    504  C   ARG    62     -10.003  16.912  -8.545  1.00 29.34           C  
ATOM    505  O   ARG    62     -10.857  17.266  -7.723  1.00 29.15           O  
ATOM    506  CB  ARG    62      -9.247  14.513  -8.608  0.50 29.81           C  
ATOM    508  CG  ARG    62      -9.668  14.178  -7.172  0.50 31.40           C  
ATOM    510  CD  ARG    62      -8.791  13.120  -6.495  0.50 31.62           C  
ATOM    512  NE  ARG    62      -8.467  13.515  -5.124  0.50 36.53           N  
ATOM    514  CZ  ARG    62      -7.951  12.730  -4.183  0.50 36.11           C  
ATOM    516  NH1 ARG    62      -7.698  11.442  -4.416  0.50 37.63           N  
ATOM    518  NH2 ARG    62      -7.692  13.248  -2.987  0.50 37.15           N  
ATOM    520  N   ARG    63      -8.941  17.663  -8.858  1.00 28.62           N  
ATOM    521  CA  ARG    63      -8.761  18.974  -8.210  1.00 29.17           C  
ATOM    522  C   ARG    63      -9.802  20.015  -8.647  1.00 28.84           C  
ATOM    523  O   ARG    63     -10.327  20.781  -7.819  1.00 28.65           O  
ATOM    524  CB  ARG    63      -7.359  19.560  -8.460  1.00 29.44           C  
ATOM    525  CG  ARG    63      -6.226  18.768  -7.890  1.00 30.90           C  
ATOM    526  CD  ARG    63      -6.146  18.743  -6.379  1.00 33.16           C  
ATOM    527  NE  ARG    63      -4.832  18.204  -6.097  1.00 37.27           N  
ATOM    528  CZ  ARG    63      -4.595  16.895  -5.971  1.00 37.04           C  
ATOM    529  NH1 ARG    63      -5.614  16.023  -5.998  1.00 37.29           N  
ATOM    530  NH2 ARG    63      -3.363  16.461  -5.783  1.00 36.96           N  
ATOM    531  N   ILE    64     -10.151  19.980  -9.933  1.00 29.26           N  
ATOM    532  CA  ILE    64     -11.184  20.856 -10.463  1.00 30.51           C  
ATOM    533  C   ILE    64     -12.504  20.549  -9.741  1.00 30.34           C  
ATOM    534  O   ILE    64     -13.196  21.480  -9.345  1.00 30.98           O  
ATOM    535  CB  ILE    64     -11.290  20.731 -12.003  1.00 30.62           C  
ATOM    536  CG1 ILE    64     -10.127  21.548 -12.614  1.00 30.31           C  
ATOM    537  CG2 ILE    64     -12.675  21.243 -12.495  1.00 31.48           C  
ATOM    538  CD1 ILE    64     -10.156  21.630 -14.161  1.00 32.83           C  
ATOM    539  N   LYS    65     -12.838  19.279  -9.553  1.00 30.75           N  
ATOM    540  CA  LYS    65     -14.099  18.954  -8.873  1.00 30.94           C  
ATOM    541  C   LYS    65     -14.073  19.525  -7.445  1.00 30.64           C  
ATOM    542  O   LYS    65     -15.081  20.079  -6.977  1.00 30.81           O  
ATOM    543  CB  LYS    65     -14.299  17.457  -8.818  1.00 31.13           C  
ATOM    544  CG  LYS    65     -15.503  17.061  -8.007  1.00 33.76           C  
ATOM    545  CD  LYS    65     -15.587  15.568  -7.851  1.00 38.55           C  
ATOM    546  CE  LYS    65     -16.586  15.242  -6.746  1.00 40.18           C  
ATOM    547  NZ  LYS    65     -17.892  15.885  -7.064  1.00 43.76           N  
ATOM    548  N   ASP    66     -12.931  19.398  -6.765  1.00 29.42           N  
ATOM    549  CA  ASP    66     -12.878  19.802  -5.360  1.00 29.50           C  
ATOM    550  C   ASP    66     -12.978  21.320  -5.356  1.00 28.62           C  
ATOM    551  O   ASP    66     -13.574  21.903  -4.442  1.00 28.98           O  
ATOM    552  CB  ASP    66     -11.568  19.384  -4.683  1.00 30.07           C  
ATOM    553  CG  ASP    66     -11.473  17.900  -4.419  1.00 34.15           C  
ATOM    554  OD1 ASP    66     -12.523  17.216  -4.358  1.00 36.32           O  
ATOM    555  OD2 ASP    66     -10.306  17.461  -4.241  1.00 37.95           O  
ATOM    556  N   LEU    67     -12.352  21.941  -6.358  1.00 28.40           N  
ATOM    557  CA  LEU    67     -12.398  23.406  -6.450  1.00 26.03           C  
ATOM    558  C   LEU    67     -13.796  23.953  -6.748  1.00 27.98           C  
ATOM    559  O   LEU    67     -14.183  25.012  -6.231  1.00 28.27           O  
ATOM    560  CB  LEU    67     -11.369  23.956  -7.460  1.00 27.42           C  
ATOM    561  CG  LEU    67      -9.912  23.918  -7.004  1.00 26.45           C  
ATOM    562  CD1 LEU    67      -8.964  24.037  -8.262  1.00 26.39           C  
ATOM    563  CD2 LEU    67      -9.529  24.911  -5.930  1.00 28.59           C  
ATOM    564  N   ILE    68     -14.528  23.250  -7.605  1.00 27.87           N  
ATOM    565  CA  ILE    68     -15.940  23.586  -7.890  1.00 28.22           C  
ATOM    566  C   ILE    68     -16.769  23.403  -6.601  1.00 28.92           C  
ATOM    567  O   ILE    68     -17.548  24.276  -6.211  1.00 28.86           O  
ATOM    568  CB  ILE    68     -16.476  22.704  -9.021  1.00 27.86           C  
ATOM    569  CG1 ILE    68     -15.802  23.072 -10.349  1.00 28.61           C  
ATOM    570  CG2 ILE    68     -18.028  22.831  -9.113  1.00 27.84           C  
ATOM    571  CD1 ILE    68     -16.125  22.075 -11.499  1.00 28.47           C  
ATOM    572  N   ASP    69     -16.594  22.272  -5.938  1.00 28.29           N  
ATOM    573  CA  ASP    69     -17.330  21.994  -4.694  1.00 30.66           C  
ATOM    574  C   ASP    69     -17.075  23.052  -3.605  1.00 30.59           C  
ATOM    575  O   ASP    69     -17.985  23.383  -2.830  1.00 30.51           O  
ATOM    576  CB  ASP    69     -17.027  20.579  -4.213  1.00 31.59           C  
ATOM    577  CG  ASP    69     -17.624  19.495  -5.126  1.00 36.35           C  
ATOM    578  OD1 ASP    69     -18.394  19.819  -6.069  1.00 40.91           O  
ATOM    579  OD2 ASP    69     -17.328  18.310  -4.891  1.00 39.91           O  
ATOM    580  N   SER    70     -15.853  23.586  -3.572  1.00 29.87           N  
ATOM    581  CA  SER    70     -15.437  24.584  -2.588  0.50 30.17           C  
ATOM    583  C   SER    70     -15.789  26.016  -2.991  1.00 30.20           C  
ATOM    584  O   SER    70     -15.532  26.952  -2.232  1.00 30.92           O  
ATOM    585  CB  SER    70     -13.943  24.429  -2.284  0.50 30.09           C  
ATOM    587  OG  SER    70     -13.709  23.157  -1.691  0.50 30.21           O  
ATOM    589  N   GLY    71     -16.394  26.165  -4.179  1.00 29.53           N  
ATOM    590  CA  GLY    71     -16.882  27.465  -4.672  1.00 29.80           C  
ATOM    591  C   GLY    71     -15.812  28.391  -5.225  1.00 29.21           C  
ATOM    592  O   GLY    71     -16.036  29.606  -5.344  1.00 30.11           O  
ATOM    593  N   LEU    72     -14.640  27.843  -5.539  1.00 29.88           N  
ATOM    594  CA  LEU    72     -13.531  28.642  -6.076  1.00 27.91           C  
ATOM    595  C   LEU    72     -13.447  28.627  -7.607  1.00 29.19           C  
ATOM    596  O   LEU    72     -12.812  29.516  -8.183  1.00 29.94           O  
ATOM    597  CB  LEU    72     -12.163  28.156  -5.486  1.00 28.59           C  
ATOM    598  CG  LEU    72     -12.171  28.194  -3.931  1.00 26.72           C  
ATOM    599  CD1 LEU    72     -10.820  27.769  -3.470  1.00 30.74           C  
ATOM    600  CD2 LEU    72     -12.484  29.610  -3.415  1.00 28.81           C  
ATOM    601  N   VAL    73     -14.018  27.598  -8.242  1.00 29.25           N  
ATOM    602  CA  VAL    73     -13.976  27.432  -9.732  1.00 28.03           C  
ATOM    603  C   VAL    73     -15.383  27.076 -10.215  1.00 28.87           C  
ATOM    604  O   VAL    73     -16.167  26.488  -9.479  1.00 28.62           O  
ATOM    605  CB  VAL    73     -12.975  26.327 -10.078  1.00 28.54           C  
ATOM    606  CG1 VAL    73     -13.062  25.848 -11.565  1.00 29.42           C  
ATOM    607  CG2 VAL    73     -11.558  26.814  -9.766  1.00 28.41           C  
ATOM    608  N   GLU    74     -15.715  27.487 -11.438  1.00 28.71           N  
ATOM    609  CA  GLU    74     -16.949  27.008 -12.060  1.00 29.45           C  
ATOM    610  C   GLU    74     -16.650  26.532 -13.474  1.00 31.15           C  
ATOM    611  O   GLU    74     -15.697  27.033 -14.142  1.00 29.70           O  
ATOM    612  CB  GLU    74     -18.030  28.096 -12.043  1.00 30.64           C  
ATOM    613  CG  GLU    74     -17.544  29.452 -12.480  1.00 35.69           C  
ATOM    614  CD  GLU    74     -17.767  29.745 -13.959  1.00 43.35           C  
ATOM    615  OE1 GLU    74     -17.538  30.908 -14.348  1.00 42.21           O  
ATOM    616  OE2 GLU    74     -18.184  28.825 -14.717  1.00 46.17           O  
ATOM    617  N   ARG    75     -17.435  25.533 -13.904  1.00 29.67           N  
ATOM    618  CA  ARG    75     -17.367  24.986 -15.271  1.00 30.13           C  
ATOM    619  C   ARG    75     -18.541  25.565 -16.078  1.00 30.14           C  
ATOM    620  O   ARG    75     -19.672  25.598 -15.587  1.00 30.30           O  
ATOM    621  CB  ARG    75     -17.453  23.453 -15.230  1.00 31.80           C  
ATOM    622  CG  ARG    75     -17.545  22.772 -16.614  1.00 31.36           C  
ATOM    623  CD  ARG    75     -17.947  21.238 -16.501  1.00 32.95           C  
ATOM    624  NE  ARG    75     -16.903  20.561 -15.799  1.00 37.99           N  
ATOM    625  CZ  ARG    75     -17.011  20.103 -14.558  1.00 41.51           C  
ATOM    626  NH1 ARG    75     -15.955  19.524 -13.989  1.00 38.82           N  
ATOM    627  NH2 ARG    75     -18.156  20.254 -13.891  1.00 42.15           N  
ATOM    628  N   ARG    76     -18.256  26.059 -17.286  1.00 28.92           N  
ATOM    629  CA  ARG    76     -19.335  26.418 -18.189  1.00 29.77           C  
ATOM    630  C   ARG    76     -19.443  25.379 -19.284  1.00 28.36           C  
ATOM    631  O   ARG    76     -18.472  25.191 -19.986  1.00 28.53           O  
ATOM    632  CB  ARG    76     -19.014  27.759 -18.849  1.00 30.56           C  
ATOM    633  CG  ARG    76     -20.132  28.268 -19.753  1.00 32.27           C  
ATOM    634  CD  ARG    76     -19.709  29.566 -20.461  1.00 31.81           C  
ATOM    635  NE  ARG    76     -20.762  30.087 -21.329  1.00 35.20           N  
ATOM    636  CZ  ARG    76     -20.930  29.732 -22.607  1.00 36.59           C  
ATOM    637  NH1 ARG    76     -20.085  28.872 -23.182  1.00 38.21           N  
ATOM    638  NH2 ARG    76     -21.934  30.246 -23.323  1.00 33.02           N  
ATOM    639  N   SER    77     -20.602  24.744 -19.459  1.00 28.58           N  
ATOM    640  CA  SER    77     -20.793  23.830 -20.561  1.00 28.95           C  
ATOM    641  C   SER    77     -21.573  24.569 -21.627  1.00 28.76           C  
ATOM    642  O   SER    77     -22.773  24.848 -21.455  1.00 28.16           O  
ATOM    643  CB  SER    77     -21.593  22.567 -20.165  1.00 30.53           C  
ATOM    644  OG  SER    77     -21.065  21.915 -19.027  1.00 35.64           O  
ATOM    645  N   GLY    78     -20.872  24.945 -22.693  1.00 29.21           N  
ATOM    646  CA  GLY    78     -21.482  25.588 -23.853  1.00 28.28           C  
ATOM    647  C   GLY    78     -21.171  24.726 -25.077  1.00 29.02           C  
ATOM    648  O   GLY    78     -21.147  23.505 -25.000  1.00 28.84           O  
ATOM    649  N   GLN    79     -20.948  25.342 -26.225  1.00 27.77           N  
ATOM    650  CA  GLN    79     -20.537  24.548 -27.377  1.00 27.63           C  
ATOM    651  C   GLN    79     -19.154  23.969 -27.103  1.00 28.99           C  
ATOM    652  O   GLN    79     -18.795  22.934 -27.680  1.00 29.21           O  
ATOM    653  CB  GLN    79     -20.566  25.381 -28.641  1.00 27.27           C  
ATOM    654  CG  GLN    79     -21.998  25.699 -29.015  1.00 26.64           C  
ATOM    655  CD  GLN    79     -22.134  26.542 -30.255  1.00 28.25           C  
ATOM    656  OE1 GLN    79     -21.501  27.589 -30.389  1.00 32.85           O  
ATOM    657  NE2 GLN    79     -22.982  26.116 -31.146  1.00 29.95           N  
ATOM    658  N   ILE    80     -18.384  24.656 -26.263  1.00 27.96           N  
ATOM    659  CA  ILE    80     -17.164  24.076 -25.650  1.00 29.86           C  
ATOM    660  C   ILE    80     -17.307  24.171 -24.130  1.00 29.27           C  
ATOM    661  O   ILE    80     -18.156  24.927 -23.647  1.00 30.11           O  
ATOM    662  CB  ILE    80     -15.864  24.780 -26.129  1.00 28.85           C  
ATOM    663  CG1 ILE    80     -15.856  26.261 -25.702  1.00 32.17           C  
ATOM    664  CG2 ILE    80     -15.718  24.643 -27.669  1.00 31.06           C  
ATOM    665  CD1 ILE    80     -14.545  27.043 -26.035  1.00 33.47           C  
ATOM    666  N   THR    81     -16.510  23.384 -23.403  1.00 28.43           N  
ATOM    667  CA  THR    81     -16.523  23.384 -21.939  1.00 28.22           C  
ATOM    668  C   THR    81     -15.289  24.116 -21.452  1.00 28.52           C  
ATOM    669  O   THR    81     -14.147  23.787 -21.846  1.00 28.61           O  
ATOM    670  CB  THR    81     -16.507  21.956 -21.396  1.00 28.75           C  
ATOM    671  OG1 THR    81     -17.690  21.294 -21.859  1.00 31.34           O  
ATOM    672  CG2 THR    81     -16.522  21.955 -19.869  1.00 31.08           C  
ATOM    673  N   THR    82     -15.511  25.118 -20.609  1.00 28.37           N  
ATOM    674  CA  THR    82     -14.420  25.966 -20.131  1.00 28.26           C  
ATOM    675  C   THR    82     -14.554  26.187 -18.621  1.00 28.32           C  
ATOM    676  O   THR    82     -15.614  25.907 -18.059  1.00 28.07           O  
ATOM    677  CB  THR    82     -14.405  27.336 -20.844  1.00 29.29           C  
ATOM    678  OG1 THR    82     -15.659  27.982 -20.635  1.00 29.38           O  
ATOM    679  CG2 THR    82     -14.132  27.169 -22.361  1.00 28.94           C  
ATOM    680  N   TYR    83     -13.491  26.716 -18.007  1.00 29.04           N  
ATOM    681  CA  TYR    83     -13.385  26.842 -16.558  1.00 29.15           C  
ATOM    682  C   TYR    83     -12.886  28.258 -16.250  1.00 29.55           C  
ATOM    683  O   TYR    83     -12.141  28.869 -17.020  1.00 29.25           O  
ATOM    684  CB  TYR    83     -12.394  25.778 -16.021  1.00 29.63           C  
ATOM    685  CG  TYR    83     -12.761  24.318 -16.395  1.00 30.27           C  
ATOM    686  CD1 TYR    83     -13.449  23.507 -15.494  1.00 31.09           C  
ATOM    687  CD2 TYR    83     -12.454  23.785 -17.656  1.00 30.34           C  
ATOM    688  CE1 TYR    83     -13.815  22.160 -15.849  1.00 31.37           C  
ATOM    689  CE2 TYR    83     -12.820  22.456 -18.012  1.00 31.96           C  
ATOM    690  CZ  TYR    83     -13.499  21.681 -17.099  1.00 31.74           C  
ATOM    691  OH  TYR    83     -13.848  20.397 -17.475  1.00 34.84           O  
ATOM    692  N   ALA    84     -13.306  28.758 -15.102  1.00 30.07           N  
ATOM    693  CA  ALA    84     -12.898  30.065 -14.658  1.00 29.00           C  
ATOM    694  C   ALA    84     -12.974  30.097 -13.138  1.00 29.39           C  
ATOM    695  O   ALA    84     -13.731  29.355 -12.503  1.00 28.04           O  
ATOM    696  CB  ALA    84     -13.828  31.155 -15.236  1.00 30.87           C  
ATOM    697  N   LEU    85     -12.208  31.004 -12.562  1.00 27.83           N  
ATOM    698  CA  LEU    85     -12.313  31.261 -11.129  1.00 28.72           C  
ATOM    699  C   LEU    85     -13.618  32.020 -10.833  1.00 28.37           C  
ATOM    700  O   LEU    85     -14.051  32.924 -11.592  1.00 29.93           O  
ATOM    701  CB  LEU    85     -11.128  32.118 -10.707  1.00 29.13           C  
ATOM    702  CG  LEU    85      -9.774  31.409 -10.790  1.00 29.42           C  
ATOM    703  CD1 LEU    85      -8.737  32.458 -10.474  1.00 30.83           C  
ATOM    704  CD2 LEU    85      -9.702  30.240  -9.791  1.00 32.79           C  
ATOM    705  N   THR    86     -14.234  31.677  -9.709  1.00 28.05           N  
ATOM    706  CA  THR    86     -15.306  32.493  -9.150  1.00 29.08           C  
ATOM    707  C   THR    86     -14.710  33.730  -8.469  1.00 28.70           C  
ATOM    708  O   THR    86     -13.473  33.872  -8.366  1.00 28.56           O  
ATOM    709  CB  THR    86     -16.066  31.686  -8.083  1.00 28.31           C  
ATOM    710  OG1 THR    86     -15.160  31.412  -7.011  1.00 28.09           O  
ATOM    711  CG2 THR    86     -16.670  30.391  -8.671  1.00 29.71           C  
ATOM    712  N   GLU    87     -15.565  34.643  -7.995  1.00 28.48           N  
ATOM    713  CA  GLU    87     -15.087  35.783  -7.197  1.00 28.21           C  
ATOM    714  C   GLU    87     -14.224  35.303  -6.039  1.00 27.98           C  
ATOM    715  O   GLU    87     -13.143  35.843  -5.801  1.00 28.08           O  
ATOM    716  CB  GLU    87     -16.260  36.608  -6.654  1.00 28.97           C  
ATOM    717  CG  GLU    87     -15.795  37.776  -5.817  1.00 32.03           C  
ATOM    718  CD  GLU    87     -16.834  38.866  -5.668  1.00 37.40           C  
ATOM    719  OE1 GLU    87     -17.999  38.681  -6.105  1.00 39.68           O  
ATOM    720  OE2 GLU    87     -16.472  39.919  -5.102  1.00 40.80           O  
ATOM    721  N   LYS    88     -14.678  34.267  -5.336  1.00 26.90           N  
ATOM    722  CA  LYS    88     -13.841  33.696  -4.236  1.00 27.64           C  
ATOM    723  C   LYS    88     -12.505  33.134  -4.735  1.00 27.48           C  
ATOM    724  O   LYS    88     -11.465  33.369  -4.095  1.00 28.05           O  
ATOM    725  CB  LYS    88     -14.587  32.639  -3.428  1.00 26.47           C  
ATOM    726  CG  LYS    88     -15.766  33.197  -2.592  1.00 29.97           C  
ATOM    727  CD  LYS    88     -16.520  32.055  -1.986  1.00 31.77           C  
ATOM    728  CE  LYS    88     -17.639  32.571  -1.077  1.00 34.52           C  
ATOM    729  NZ  LYS    88     -18.530  31.437  -0.636  1.00 37.09           N  
ATOM    730  N   GLY    89     -12.521  32.417  -5.859  1.00 27.29           N  
ATOM    731  CA  GLY    89     -11.278  31.833  -6.408  1.00 27.82           C  
ATOM    732  C   GLY    89     -10.300  32.939  -6.789  1.00 27.71           C  
ATOM    733  O   GLY    89      -9.070  32.813  -6.559  1.00 26.30           O  
ATOM    734  N   MET    90     -10.832  34.020  -7.352  1.00 28.52           N  
ATOM    735  CA  MET    90      -9.968  35.159  -7.726  1.00 29.23           C  
ATOM    736  C   MET    90      -9.369  35.854  -6.476  1.00 29.18           C  
ATOM    737  O   MET    90      -8.189  36.250  -6.463  1.00 28.95           O  
ATOM    738  CB  MET    90     -10.714  36.183  -8.595  1.00 30.36           C  
ATOM    739  CG  MET    90      -9.775  37.308  -9.095  1.00 32.97           C  
ATOM    740  SD  MET    90      -8.279  36.659 -10.240  0.55 36.03          SE  
ATOM    741  CE  MET    90      -9.351  35.987 -11.693  1.00 35.53           C  
ATOM    742  N   ASN    91     -10.150  35.940  -5.409  1.00 28.62           N  
ATOM    743  CA  ASN    91      -9.609  36.407  -4.128  1.00 28.64           C  
ATOM    744  C   ASN    91      -8.476  35.527  -3.605  1.00 27.84           C  
ATOM    745  O   ASN    91      -7.444  36.019  -3.139  1.00 27.84           O  
ATOM    746  CB  ASN    91     -10.720  36.491  -3.084  1.00 29.00           C  
ATOM    747  CG  ASN    91     -11.716  37.587  -3.386  1.00 29.45           C  
ATOM    748  OD1 ASN    91     -11.392  38.575  -4.056  1.00 27.66           O  
ATOM    749  ND2 ASN    91     -12.930  37.423  -2.905  1.00 28.75           N  
ATOM    750  N   VAL    92      -8.668  34.219  -3.635  1.00 27.04           N  
ATOM    751  CA  VAL    92      -7.552  33.325  -3.311  1.00 28.12           C  
ATOM    752  C   VAL    92      -6.323  33.601  -4.207  1.00 27.67           C  
ATOM    753  O   VAL    92      -5.209  33.665  -3.716  1.00 26.90           O  
ATOM    754  CB  VAL    92      -7.997  31.843  -3.442  1.00 28.20           C  
ATOM    755  CG1 VAL    92      -6.780  30.843  -3.275  1.00 27.42           C  
ATOM    756  CG2 VAL    92      -9.135  31.524  -2.399  1.00 30.21           C  
ATOM    757  N   ARG    93      -6.548  33.772  -5.506  1.00 28.09           N  
ATOM    758  CA  ARG    93      -5.422  33.888  -6.432  1.00 28.32           C  
ATOM    759  C   ARG    93      -4.688  35.143  -6.068  1.00 27.74           C  
ATOM    760  O   ARG    93      -3.454  35.180  -6.049  1.00 27.95           O  
ATOM    761  CB  ARG    93      -5.888  33.967  -7.868  1.00 28.07           C  
ATOM    762  CG  ARG    93      -4.693  33.906  -8.838  1.00 25.86           C  
ATOM    763  CD  ARG    93      -5.157  34.048 -10.247  1.00 26.49           C  
ATOM    764  NE  ARG    93      -4.120  33.795 -11.241  1.00 28.18           N  
ATOM    765  CZ  ARG    93      -3.202  34.673 -11.649  1.00 29.31           C  
ATOM    766  NH1 ARG    93      -2.287  34.306 -12.557  1.00 25.94           N  
ATOM    767  NH2 ARG    93      -3.198  35.916 -11.166  1.00 26.86           N  
ATOM    768  N   ASN    94      -5.459  36.176  -5.767  1.00 28.92           N  
ATOM    769  CA  ASN    94      -4.886  37.494  -5.404  1.00 29.99           C  
ATOM    770  C   ASN    94      -3.915  37.371  -4.211  1.00 32.12           C  
ATOM    771  O   ASN    94      -2.841  37.961  -4.232  1.00 31.33           O  
ATOM    772  CB  ASN    94      -5.971  38.543  -5.091  1.00 30.37           C  
ATOM    773  CG  ASN    94      -6.675  39.043  -6.340  1.00 32.67           C  
ATOM    774  OD1 ASN    94      -6.194  38.840  -7.464  1.00 32.25           O  
ATOM    775  ND2 ASN    94      -7.838  39.681  -6.155  1.00 32.87           N  
ATOM    776  N   SER    95      -4.292  36.604  -3.190  1.00 32.21           N  
ATOM    777  CA  SER    95      -3.400  36.395  -2.041  0.50 33.67           C  
ATOM    779  C   SER    95      -2.286  35.405  -2.316  1.00 33.56           C  
ATOM    780  O   SER    95      -1.258  35.427  -1.651  1.00 35.19           O  
ATOM    781  CB  SER    95      -4.179  35.979  -0.796  0.50 33.85           C  
ATOM    783  OG  SER    95      -5.282  36.826  -0.602  0.50 34.68           O  
ATOM    785  N   LEU    96      -2.471  34.542  -3.311  1.00 32.37           N  
ATOM    786  CA  LEU    96      -1.491  33.550  -3.647  1.00 32.67           C  
ATOM    787  C   LEU    96      -0.295  34.105  -4.388  1.00 30.83           C  
ATOM    788  O   LEU    96       0.820  33.633  -4.159  1.00 30.82           O  
ATOM    789  CB  LEU    96      -2.157  32.477  -4.517  1.00 33.56           C  
ATOM    790  CG  LEU    96      -1.710  31.050  -4.639  1.00 38.72           C  
ATOM    791  CD1 LEU    96      -1.362  30.451  -3.239  1.00 35.81           C  
ATOM    792  CD2 LEU    96      -2.842  30.238  -5.358  1.00 34.93           C  
ATOM    793  N   MET    97      -0.504  35.093  -5.271  1.00 30.72           N  
ATOM    794  CA  MET    97       0.573  35.499  -6.198  1.00 30.72           C  
ATOM    795  C   MET    97       1.842  36.013  -5.490  1.00 29.84           C  
ATOM    796  O   MET    97       2.933  35.641  -5.896  1.00 30.74           O  
ATOM    797  CB  MET    97       0.075  36.444  -7.294  1.00 31.52           C  
ATOM    798  CG  MET    97      -1.008  35.843  -8.209  1.00 34.65           C  
ATOM    799  SD  MET    97      -0.818  33.923  -8.692  0.70 44.93          SE  
ATOM    800  CE  MET    97       0.709  34.110  -9.778  1.00 41.24           C  
ATOM    801  N   PRO    98       1.715  36.844  -4.434  1.00 29.05           N  
ATOM    802  CA  PRO    98       2.974  37.244  -3.779  1.00 29.62           C  
ATOM    803  C   PRO    98       3.757  36.083  -3.167  1.00 29.38           C  
ATOM    804  O   PRO    98       5.012  36.095  -3.173  1.00 28.71           O  
ATOM    805  CB  PRO    98       2.511  38.270  -2.724  1.00 27.95           C  
ATOM    806  CG  PRO    98       1.158  38.780  -3.240  1.00 29.52           C  
ATOM    807  CD  PRO    98       0.549  37.499  -3.812  1.00 28.86           C  
ATOM    808  N   LEU    99       3.042  35.062  -2.695  1.00 29.20           N  
ATOM    809  CA  LEU    99       3.663  33.870  -2.139  1.00 29.63           C  
ATOM    810  C   LEU    99       4.396  33.115  -3.247  1.00 28.97           C  
ATOM    811  O   LEU    99       5.587  32.776  -3.087  1.00 29.73           O  
ATOM    812  CB  LEU    99       2.619  32.977  -1.497  1.00 29.90           C  
ATOM    813  CG  LEU    99       3.168  31.683  -0.942  1.00 31.39           C  
ATOM    814  CD1 LEU    99       4.202  31.905   0.205  1.00 30.66           C  
ATOM    815  CD2 LEU    99       1.990  30.860  -0.502  1.00 31.76           C  
ATOM    816  N   LEU   100       3.718  32.889  -4.374  1.00 28.17           N  
ATOM    817  CA  LEU   100       4.364  32.230  -5.503  1.00 28.95           C  
ATOM    818  C   LEU   100       5.550  33.020  -6.085  1.00 27.53           C  
ATOM    819  O   LEU   100       6.573  32.418  -6.447  1.00 27.72           O  
ATOM    820  CB  LEU   100       3.347  31.799  -6.572  1.00 29.88           C  
ATOM    821  CG  LEU   100       2.325  30.758  -6.059  1.00 31.71           C  
ATOM    822  CD1 LEU   100       1.399  30.347  -7.205  1.00 34.06           C  
ATOM    823  CD2 LEU   100       2.939  29.510  -5.392  1.00 35.43           C  
ATOM    824  N   GLN   101       5.420  34.352  -6.171  1.00 28.07           N  
ATOM    825  CA  GLN   101       6.504  35.194  -6.585  1.00 28.02           C  
ATOM    826  C   GLN   101       7.722  34.903  -5.698  1.00 28.41           C  
ATOM    827  O   GLN   101       8.818  34.657  -6.213  1.00 27.55           O  
ATOM    828  CB  GLN   101       6.085  36.661  -6.502  1.00 27.70           C  
ATOM    829  CG  GLN   101       7.155  37.657  -6.935  1.00 29.75           C  
ATOM    830  CD  GLN   101       6.627  39.072  -6.900  1.00 36.26           C  
ATOM    831  OE1 GLN   101       6.218  39.568  -5.838  1.00 39.47           O  
ATOM    832  NE2 GLN   101       6.614  39.734  -8.055  1.00 36.49           N  
ATOM    833  N   TYR   102       7.514  34.893  -4.378  1.00 27.05           N  
ATOM    834  CA  TYR   102       8.673  34.752  -3.497  1.00 27.21           C  
ATOM    835  C   TYR   102       9.243  33.344  -3.614  1.00 26.42           C  
ATOM    836  O   TYR   102      10.452  33.175  -3.617  1.00 27.13           O  
ATOM    837  CB  TYR   102       8.385  35.071  -2.044  1.00 27.35           C  
ATOM    838  CG  TYR   102       9.672  35.078  -1.243  1.00 26.25           C  
ATOM    839  CD1 TYR   102      10.720  35.926  -1.593  1.00 27.25           C  
ATOM    840  CD2 TYR   102       9.847  34.246  -0.138  1.00 25.54           C  
ATOM    841  CE1 TYR   102      11.924  35.953  -0.874  1.00 26.32           C  
ATOM    842  CE2 TYR   102      11.059  34.260   0.587  1.00 24.84           C  
ATOM    843  CZ  TYR   102      12.074  35.112   0.230  1.00 26.75           C  
ATOM    844  OH  TYR   102      13.270  35.165   0.933  1.00 25.91           O  
ATOM    845  N   ILE   103       8.378  32.346  -3.722  1.00 27.50           N  
ATOM    846  CA  ILE   103       8.813  30.981  -3.992  1.00 27.88           C  
ATOM    847  C   ILE   103       9.731  30.908  -5.220  1.00 27.65           C  
ATOM    848  O   ILE   103      10.751  30.201  -5.192  1.00 27.73           O  
ATOM    849  CB  ILE   103       7.617  30.032  -4.134  1.00 29.23           C  
ATOM    850  CG1 ILE   103       7.016  29.788  -2.747  1.00 30.88           C  
ATOM    851  CG2 ILE   103       8.035  28.692  -4.718  1.00 28.51           C  
ATOM    852  CD1 ILE   103       5.732  28.980  -2.795  1.00 33.46           C  
ATOM    853  N   SER   104       9.378  31.624  -6.282  1.00 27.79           N  
ATOM    854  CA  SER   104      10.196  31.587  -7.481  0.50 27.34           C  
ATOM    856  C   SER   104      11.574  32.157  -7.178  1.00 27.49           C  
ATOM    857  O   SER   104      12.578  31.651  -7.696  1.00 28.21           O  
ATOM    858  CB  SER   104       9.517  32.288  -8.666  0.50 27.70           C  
ATOM    860  OG  SER   104       9.297  33.653  -8.404  0.50 26.64           O  
ATOM    862  N   VAL   105      11.633  33.198  -6.338  1.00 27.35           N  
ATOM    863  CA  VAL   105      12.917  33.788  -5.913  1.00 28.27           C  
ATOM    864  C   VAL   105      13.727  32.746  -5.132  1.00 27.87           C  
ATOM    865  O   VAL   105      14.911  32.534  -5.409  1.00 28.29           O  
ATOM    866  CB  VAL   105      12.712  35.069  -5.063  1.00 28.99           C  
ATOM    867  CG1 VAL   105      14.037  35.535  -4.379  1.00 28.92           C  
ATOM    868  CG2 VAL   105      12.092  36.197  -5.908  1.00 29.40           C  
ATOM    869  N   LEU   106      13.102  32.109  -4.153  1.00 27.98           N  
ATOM    870  CA  LEU   106      13.769  31.016  -3.414  1.00 29.11           C  
ATOM    871  C   LEU   106      14.298  29.896  -4.309  1.00 29.49           C  
ATOM    872  O   LEU   106      15.409  29.399  -4.086  1.00 28.40           O  
ATOM    873  CB  LEU   106      12.844  30.436  -2.360  1.00 29.16           C  
ATOM    874  CG  LEU   106      12.443  31.332  -1.195  1.00 28.98           C  
ATOM    875  CD1 LEU   106      11.364  30.598  -0.405  1.00 27.21           C  
ATOM    876  CD2 LEU   106      13.592  31.655  -0.283  1.00 28.46           C  
ATOM    877  N   ASP   107      13.530  29.522  -5.329  1.00 30.00           N  
ATOM    878  CA  ASP   107      13.912  28.437  -6.238  1.00 31.31           C  
ATOM    879  C   ASP   107      15.183  28.744  -7.021  1.00 32.94           C  
ATOM    880  O   ASP   107      15.879  27.832  -7.457  1.00 32.77           O  
ATOM    881  CB  ASP   107      12.767  28.129  -7.204  1.00 30.81           C  
ATOM    882  CG  ASP   107      11.600  27.426  -6.519  1.00 31.73           C  
ATOM    883  OD1 ASP   107      11.808  26.861  -5.409  1.00 32.85           O  
ATOM    884  OD2 ASP   107      10.497  27.412  -7.108  1.00 30.11           O  
ATOM    885  N   ARG   108      15.483  30.027  -7.165  1.00 35.82           N  
ATOM    886  CA  ARG   108      16.714  30.471  -7.828  1.00 38.32           C  
ATOM    887  C   ARG   108      17.910  30.455  -6.873  1.00 40.36           C  
ATOM    888  O   ARG   108      19.070  30.499  -7.313  1.00 41.27           O  
ATOM    889  CB  ARG   108      16.532  31.880  -8.395  1.00 38.71           C  
ATOM    890  CG  ARG   108      15.484  32.018  -9.490  1.00 39.12           C  
ATOM    891  CD  ARG   108      15.947  31.500 -10.868  1.00 41.50           C  
ATOM    892  NE  ARG   108      17.379  31.658 -11.134  1.00 39.33           N  
ATOM    893  CZ  ARG   108      17.954  32.744 -11.656  1.00 40.78           C  
ATOM    894  NH1 ARG   108      17.234  33.825 -11.957  1.00 39.73           N  
ATOM    895  NH2 ARG   108      19.265  32.753 -11.862  1.00 39.54           N  
ATOM    896  N   ASN   109      17.609  30.383  -5.574  1.00 42.89           N  
ATOM    897  CA  ASN   109      18.561  30.416  -4.447  1.00 44.82           C  
ATOM    898  C   ASN   109      18.725  31.803  -3.828  1.00 45.47           C  
ATOM    899  O   ASN   109      19.574  32.596  -4.253  1.00 46.71           O  
ATOM    900  CB  ASN   109      19.923  29.793  -4.797  1.00 45.67           C  
ATOM    901  CG  ASN   109      20.027  28.329  -4.385  1.00 47.92           C  
ATOM    902  OD1 ASN   109      21.107  27.860  -4.009  1.00 50.81           O  
ATOM    903  ND2 ASN   109      18.912  27.600  -4.455  1.00 49.19           N  
END
