
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   80 (  670),  selected   80 , name 2p0g_D
# Molecule2: number of CA atoms   77 (  633),  selected   77 , name T0458.pdb
# PARAMETERS: 2p0g_D.T0458.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K     3_D      T      12          1.687
LGA    A     4_D      H      13          1.305
LGA    Q     5_D      R      14          0.490
LGA    I     6_D      V      15          0.469
LGA    E     7_D      Q      16          0.722
LGA    I     8_D      I      17          0.444
LGA    Y     9_D      E      18          0.458
LGA    Y    10_D      Y      19          0.603
LGA    C    11_D      C      20          0.533
LGA    R    12_D      T      21          0.574
LGA    Q    13_D      Q      22          1.071
LGA    C    14_D      C      23          0.293
LGA    N    15_D      R      24          0.943
LGA    W    16_D      W      25          0.483
LGA    X    17_D      L      26          0.501
LGA    L    18_D      P      27          0.473
LGA    R    19_D      R      28          0.517
LGA    S    20_D      A      29          0.364
LGA    A    21_D      A      30          0.322
LGA    W    22_D      W      31          0.421
LGA    L    23_D      L      32          0.346
LGA    S    24_D      A      33          0.262
LGA    Q    25_D      Q      34          0.514
LGA    E    26_D      E      35          0.514
LGA    L    27_D      L      36          0.734
LGA    L    28_D      L      37          0.630
LGA    H    29_D      T      38          0.442
LGA    T    30_D      T      39          0.635
LGA    F    31_D      F      40          0.881
LGA    S    32_D      E      41          0.929
LGA    E    33_D      T      42          0.636
LGA    E    34_D      E      43          0.355
LGA    I    35_D      L      44          0.330
LGA    E    36_D      T      45          0.603
LGA    Y    37_D      E      46          0.582
LGA    V    38_D      L      47          0.537
LGA    A    39_D      A      48          0.253
LGA    L    40_D      L      49          0.228
LGA    H    41_D      K      50          0.484
LGA    P    42_D      P      51          0.773
LGA    D    43_D      G      52          0.906
LGA    T    44_D      T      53          0.666
LGA    G    45_D      G      54          0.910
LGA    G    46_D      G      55          0.788
LGA    R    47_D      V      56          0.676
LGA    F    48_D      F      57          0.656
LGA    E    49_D      V      58          0.851
LGA    I    50_D      V      59          0.843
LGA    F    51_D      R      60          0.294
LGA    C    52_D      V      61          0.284
LGA    N    53_D      D      62          0.882
LGA    G    54_D      D      63          1.557
LGA    V    55_D      E      64          1.396
LGA    Q    56_D      V      65          0.697
LGA    I    57_D      V      66          0.659
LGA    W    58_D      W      67          0.659
LGA    E    59_D      D      68          0.700
LGA    R    60_D      R      69          0.857
LGA    K    61_D      R      70          0.774
LGA    Q    62_D      E      71          1.018
LGA    E    63_D      Q      72          1.127
LGA    G    64_D      G      73          3.271
LGA    G    65_D      -       -           -
LGA    F    66_D      F      74          1.090
LGA    P    67_D      P      75          1.254
LGA    E    68_D      E      76          0.963
LGA    A    69_D      P      77          0.751
LGA    K    70_D      T      78          0.734
LGA    V    71_D      A      79          0.940
LGA    L    72_D      V      80          1.123
LGA    K    73_D      K      81          0.960
LGA    Q    74_D      R      82          0.636
LGA    R    75_D      L      83          0.600
LGA    V    76_D      V      84          0.710
LGA    R    77_D      R      85          0.472
LGA    D    78_D      D      86          0.314
LGA    L    79_D      R      87          0.506
LGA    I    80_D      V      88          0.465
LGA    D    81_D      -       -           -
LGA    P    82_D      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   80   77    5.0     77    0.83    44.16     98.992     8.259

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.798306 * X  +   0.473398 * Y  +  -0.372294 * Z  +  38.655121
  Y_new =   0.427494 * X  +  -0.880843 * Y  +  -0.203384 * Z  + 167.392944
  Z_new =  -0.424214 * X  +   0.003209 * Y  +  -0.905556 * Z  +  30.872269 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   3.138049   -0.003544  [ DEG:   179.7970     -0.2030 ]
  Theta =   0.438093    2.703499  [ DEG:    25.1009    154.8991 ]
  Phi   =   0.491644   -2.649949  [ DEG:    28.1691   -151.8309 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2p0g_D                                        
REMARK     2: T0458.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2p0g_D.T0458.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   80   77   5.0   77   0.83   44.16  98.992
REMARK  ---------------------------------------------------------- 
MOLECULE 2p0g_D
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   28-FEB-07   2P0G              
TITLE     CRYSTAL STRUCTURE OF SELENOPROTEIN W-RELATED PROTEIN FROM             
TITLE    2 VIBRIO CHOLERAE. NORTHEAST STRUCTURAL GENOMICS TARGET VCR75          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SELENOPROTEIN W-RELATED PROTEIN;                           
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: VIBRIO CHOLERAE;                                
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: EL TOR INABA N16961;                                         
SOURCE   5 ATCC: 39315;                                                         
SOURCE   6 GENE: VC0982;                                                        
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   9 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)+MAGIC;                           
SOURCE  10 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: PET21                                     
KEYWDS    VCR75, STRUCTURAL GENOMICS, PSI-2, PROTEIN STRUCTURE                  
KEYWDS   2 INITIATIVE, NORTHEAST STRUCTURAL GENOMICS CONSORTIUM, NESG           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.BENACH,H.NEELY,J.SEETHARAMAN,C.K.HO,H.JANJUA,K.CUNNINGHAM,          
AUTHOR   2 L.MA,R.XIAO,J.LIU,M.C.BARAN,T.B.ACTON,B.ROST,G.T.MONTELIONE,         
AUTHOR   3 J.F.HUNT,L.TONG,NORTHEAST STRUCTURAL GENOMICS CONSORTIUM             
AUTHOR   4 (NESG)                                                               
REVDAT   1   20-MAR-07 2P0G    0                                                
JRNL        AUTH   J.BENACH,H.NEELY,J.SEETHARAMAN,C.K.HO,H.JANJUA,              
JRNL        AUTH 2 K.CUNNINGHAM,L.MA,R.XIAO,J.LIU,M.C.BARAN,T.B.ACTON,          
JRNL        AUTH 3 B.ROST,G.T.MONTELIONE,J.F.HUNT,L.TONG,                       
JRNL        AUTH 4 NORTHEAST STRUCTURAL GENOMICS CONSORTIUM (NESG)              
JRNL        TITL   CRYSTAL STRUCTURE OF SELENOPROTEIN W-RELATED                 
JRNL        TITL 2 PROTEIN FROM VIBRIO CHOLERAE.                                
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.30 ANGSTROMS.                                          
DBREF  2P0G A    1    97  UNP    Q9KTC1   Q9KTC1_VIBCH     1     97             
DBREF  2P0G B    1    97  UNP    Q9KTC1   Q9KTC1_VIBCH     1     97             
DBREF  2P0G C    1    97  UNP    Q9KTC1   Q9KTC1_VIBCH     1     97             
DBREF  2P0G D    1    97  UNP    Q9KTC1   Q9KTC1_VIBCH     1     97             
SEQRES   1 A  105  MSE ASN LYS ALA GLN ILE GLU ILE TYR TYR CYS ARG GLN          
SEQRES   2 A  105  CYS ASN TRP MSE LEU ARG SER ALA TRP LEU SER GLN GLU          
SEQRES   3 A  105  LEU LEU HIS THR PHE SER GLU GLU ILE GLU TYR VAL ALA          
SEQRES   4 A  105  LEU HIS PRO ASP THR GLY GLY ARG PHE GLU ILE PHE CYS          
SEQRES   5 A  105  ASN GLY VAL GLN ILE TRP GLU ARG LYS GLN GLU GLY GLY          
SEQRES   6 A  105  PHE PRO GLU ALA LYS VAL LEU LYS GLN ARG VAL ARG ASP          
SEQRES   7 A  105  LEU ILE ASP PRO GLU ARG ASP LEU GLY HIS VAL ASP ARG          
SEQRES   8 A  105  PRO SER SER THR GLN SER LEU GLU HIS HIS HIS HIS HIS          
SEQRES   9 A  105  HIS                                                          
SEQRES   1 B  105  MSE ASN LYS ALA GLN ILE GLU ILE TYR TYR CYS ARG GLN          
SEQRES   2 B  105  CYS ASN TRP MSE LEU ARG SER ALA TRP LEU SER GLN GLU          
SEQRES   3 B  105  LEU LEU HIS THR PHE SER GLU GLU ILE GLU TYR VAL ALA          
SEQRES   4 B  105  LEU HIS PRO ASP THR GLY GLY ARG PHE GLU ILE PHE CYS          
SEQRES   5 B  105  ASN GLY VAL GLN ILE TRP GLU ARG LYS GLN GLU GLY GLY          
SEQRES   6 B  105  PHE PRO GLU ALA LYS VAL LEU LYS GLN ARG VAL ARG ASP          
SEQRES   7 B  105  LEU ILE ASP PRO GLU ARG ASP LEU GLY HIS VAL ASP ARG          
SEQRES   8 B  105  PRO SER SER THR GLN SER LEU GLU HIS HIS HIS HIS HIS          
SEQRES   9 B  105  HIS                                                          
SEQRES   1 C  105  MSE ASN LYS ALA GLN ILE GLU ILE TYR TYR CYS ARG GLN          
SEQRES   2 C  105  CYS ASN TRP MSE LEU ARG SER ALA TRP LEU SER GLN GLU          
SEQRES   3 C  105  LEU LEU HIS THR PHE SER GLU GLU ILE GLU TYR VAL ALA          
SEQRES   4 C  105  LEU HIS PRO ASP THR GLY GLY ARG PHE GLU ILE PHE CYS          
SEQRES   5 C  105  ASN GLY VAL GLN ILE TRP GLU ARG LYS GLN GLU GLY GLY          
SEQRES   6 C  105  PHE PRO GLU ALA LYS VAL LEU LYS GLN ARG VAL ARG ASP          
SEQRES   7 C  105  LEU ILE ASP PRO GLU ARG ASP LEU GLY HIS VAL ASP ARG          
SEQRES   8 C  105  PRO SER SER THR GLN SER LEU GLU HIS HIS HIS HIS HIS          
SEQRES   9 C  105  HIS                                                          
SEQRES   1 D  105  MSE ASN LYS ALA GLN ILE GLU ILE TYR TYR CYS ARG GLN          
SEQRES   2 D  105  CYS ASN TRP MSE LEU ARG SER ALA TRP LEU SER GLN GLU          
SEQRES   3 D  105  LEU LEU HIS THR PHE SER GLU GLU ILE GLU TYR VAL ALA          
SEQRES   4 D  105  LEU HIS PRO ASP THR GLY GLY ARG PHE GLU ILE PHE CYS          
SEQRES   5 D  105  ASN GLY VAL GLN ILE TRP GLU ARG LYS GLN GLU GLY GLY          
SEQRES   6 D  105  PHE PRO GLU ALA LYS VAL LEU LYS GLN ARG VAL ARG ASP          
SEQRES   7 D  105  LEU ILE ASP PRO GLU ARG ASP LEU GLY HIS VAL ASP ARG          
SEQRES   8 D  105  PRO SER SER THR GLN SER LEU GLU HIS HIS HIS HIS HIS          
SEQRES   9 D  105  HIS                                                          
HET    MSE  A  17       8                                                       
HET    MSE  B  17       8                                                       
HET    MSE  C  17       8                                                       
HET    MSE  D  17       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    4(C5 H11 N O2 SE)                                            
FORMUL   5  HOH   *106(H2 O)                                                    
CRYST1   81.602   81.602  105.848  90.00  90.00 120.00 P 31 2 1     24          
ATOM   2001  N   LYS D   3      35.939 110.312 -20.021  1.00 28.31           N  
ATOM   2002  CA  LYS D   3      35.183 110.743 -18.808  1.00 29.40           C  
ATOM   2003  C   LYS D   3      33.934 109.887 -18.612  1.00 28.10           C  
ATOM   2004  O   LYS D   3      33.382 109.347 -19.575  1.00 29.62           O  
ATOM   2005  CB  LYS D   3      34.774 112.216 -18.938  1.00 31.85           C  
ATOM   2006  CG  LYS D   3      35.923 113.215 -19.055  1.00 33.64           C  
ATOM   2007  CD  LYS D   3      36.711 113.333 -17.758  1.00 35.90           C  
ATOM   2008  CE  LYS D   3      37.667 114.520 -17.793  1.00 36.81           C  
ATOM   2009  NZ  LYS D   3      36.951 115.831 -17.816  1.00 38.27           N  
ATOM   2010  N   ALA D   4      33.496 109.762 -17.364  1.00 27.56           N  
ATOM   2011  CA  ALA D   4      32.302 108.985 -17.042  1.00 25.72           C  
ATOM   2012  C   ALA D   4      31.021 109.820 -17.145  1.00 24.50           C  
ATOM   2013  O   ALA D   4      31.012 111.015 -16.850  1.00 22.67           O  
ATOM   2014  CB  ALA D   4      32.435 108.401 -15.644  1.00 24.05           C  
ATOM   2015  N   GLN D   5      29.949 109.172 -17.585  1.00 24.17           N  
ATOM   2016  CA  GLN D   5      28.641 109.804 -17.709  1.00 24.19           C  
ATOM   2017  C   GLN D   5      27.721 109.030 -16.779  1.00 22.83           C  
ATOM   2018  O   GLN D   5      27.439 107.858 -17.015  1.00 23.71           O  
ATOM   2019  CB  GLN D   5      28.134 109.719 -19.151  1.00 29.55           C  
ATOM   2020  CG  GLN D   5      29.104 110.266 -20.183  1.00 36.97           C  
ATOM   2021  CD  GLN D   5      28.474 110.397 -21.552  1.00 40.90           C  
ATOM   2022  OE1 GLN D   5      27.718 109.525 -21.982  1.00 43.00           O  
ATOM   2023  NE2 GLN D   5      28.784 111.494 -22.253  1.00 42.73           N  
ATOM   2024  N   ILE D   6      27.266 109.692 -15.724  1.00 20.08           N  
ATOM   2025  CA  ILE D   6      26.412 109.060 -14.735  1.00 17.33           C  
ATOM   2026  C   ILE D   6      24.987 109.610 -14.736  1.00 17.47           C  
ATOM   2027  O   ILE D   6      24.773 110.824 -14.757  1.00 12.59           O  
ATOM   2028  CB  ILE D   6      27.038 109.214 -13.340  1.00 20.01           C  
ATOM   2029  CG1 ILE D   6      28.421 108.555 -13.344  1.00 22.37           C  
ATOM   2030  CG2 ILE D   6      26.143 108.596 -12.284  1.00 18.67           C  
ATOM   2031  CD1 ILE D   6      29.314 108.964 -12.201  1.00 21.14           C  
ATOM   2032  N   GLU D   7      24.013 108.703 -14.730  1.00 19.55           N  
ATOM   2033  CA  GLU D   7      22.600 109.070 -14.740  1.00 18.46           C  
ATOM   2034  C   GLU D   7      21.908 108.494 -13.507  1.00 17.34           C  
ATOM   2035  O   GLU D   7      22.063 107.313 -13.195  1.00 16.28           O  
ATOM   2036  CB  GLU D   7      21.923 108.506 -15.995  1.00 21.43           C  
ATOM   2037  CG  GLU D   7      22.778 108.484 -17.258  1.00 22.24           C  
ATOM   2038  CD  GLU D   7      22.921 109.843 -17.909  1.00 25.05           C  
ATOM   2039  OE1 GLU D   7      22.135 110.749 -17.577  1.00 23.51           O  
ATOM   2040  OE2 GLU D   7      23.816 109.999 -18.767  1.00 27.92           O  
ATOM   2041  N   ILE D   8      21.140 109.326 -12.811  1.00 18.25           N  
ATOM   2042  CA  ILE D   8      20.413 108.883 -11.625  1.00 16.54           C  
ATOM   2043  C   ILE D   8      18.916 109.132 -11.803  1.00 17.14           C  
ATOM   2044  O   ILE D   8      18.473 110.279 -11.853  1.00 17.67           O  
ATOM   2045  CB  ILE D   8      20.881 109.633 -10.357  1.00 17.26           C  
ATOM   2046  CG1 ILE D   8      22.362 109.349 -10.095  1.00 18.20           C  
ATOM   2047  CG2 ILE D   8      20.038 109.201  -9.169  1.00 18.01           C  
ATOM   2048  CD1 ILE D   8      22.947 110.159  -8.951  1.00 16.47           C  
ATOM   2049  N   TYR D   9      18.141 108.057 -11.912  1.00 17.24           N  
ATOM   2050  CA  TYR D   9      16.697 108.172 -12.073  1.00 15.34           C  
ATOM   2051  C   TYR D   9      16.014 107.906 -10.737  1.00 14.77           C  
ATOM   2052  O   TYR D   9      16.231 106.863 -10.120  1.00 15.23           O  
ATOM   2053  CB  TYR D   9      16.190 107.173 -13.122  1.00 16.97           C  
ATOM   2054  CG  TYR D   9      16.737 107.400 -14.513  1.00 17.29           C  
ATOM   2055  CD1 TYR D   9      18.006 106.942 -14.871  1.00 16.74           C  
ATOM   2056  CD2 TYR D   9      15.988 108.085 -15.468  1.00 17.83           C  
ATOM   2057  CE1 TYR D   9      18.514 107.161 -16.151  1.00 18.15           C  
ATOM   2058  CE2 TYR D   9      16.488 108.309 -16.746  1.00 18.63           C  
ATOM   2059  CZ  TYR D   9      17.750 107.847 -17.081  1.00 18.51           C  
ATOM   2060  OH  TYR D   9      18.246 108.081 -18.342  1.00 20.91           O  
ATOM   2061  N   TYR D  10      15.194 108.849 -10.288  1.00 15.93           N  
ATOM   2062  CA  TYR D  10      14.500 108.696  -9.014  1.00 16.82           C  
ATOM   2063  C   TYR D  10      13.028 109.054  -9.126  1.00 17.18           C  
ATOM   2064  O   TYR D  10      12.656 109.963  -9.870  1.00 16.63           O  
ATOM   2065  CB  TYR D  10      15.148 109.583  -7.949  1.00 16.33           C  
ATOM   2066  CG  TYR D  10      15.033 111.059  -8.239  1.00 15.60           C  
ATOM   2067  CD1 TYR D  10      15.924 111.695  -9.100  1.00 14.55           C  
ATOM   2068  CD2 TYR D  10      14.013 111.818  -7.667  1.00 14.73           C  
ATOM   2069  CE1 TYR D  10      15.803 113.053  -9.385  1.00 14.19           C  
ATOM   2070  CE2 TYR D  10      13.882 113.175  -7.946  1.00 14.26           C  
ATOM   2071  CZ  TYR D  10      14.779 113.788  -8.806  1.00 13.91           C  
ATOM   2072  OH  TYR D  10      14.653 115.129  -9.089  1.00 15.25           O  
ATOM   2073  N   CYS D  11      12.191 108.340  -8.381  1.00 21.23           N  
ATOM   2074  CA  CYS D  11      10.757 108.599  -8.393  1.00 23.92           C  
ATOM   2075  C   CYS D  11      10.484 110.020  -7.903  1.00 24.73           C  
ATOM   2076  O   CYS D  11      10.752 110.360  -6.752  1.00 24.45           O  
ATOM   2077  CB  CYS D  11      10.033 107.573  -7.520  1.00 24.13           C  
ATOM   2078  SG  CYS D  11       8.449 108.142  -6.847  1.00 26.51           S  
ATOM   2079  N   ARG D  12       9.951 110.832  -8.808  1.00 27.94           N  
ATOM   2080  CA  ARG D  12       9.628 112.237  -8.574  1.00 31.96           C  
ATOM   2081  C   ARG D  12       8.801 112.571  -7.327  1.00 33.48           C  
ATOM   2082  O   ARG D  12       9.057 113.574  -6.662  1.00 34.14           O  
ATOM   2083  CB  ARG D  12       8.912 112.780  -9.817  1.00 36.32           C  
ATOM   2084  CG  ARG D  12       8.388 114.191  -9.707  1.00 42.86           C  
ATOM   2085  CD  ARG D  12       7.483 114.527 -10.891  1.00 46.87           C  
ATOM   2086  NE  ARG D  12       8.107 114.240 -12.183  1.00 50.81           N  
ATOM   2087  CZ  ARG D  12       8.086 113.052 -12.786  1.00 53.53           C  
ATOM   2088  NH1 ARG D  12       7.465 112.027 -12.218  1.00 55.69           N  
ATOM   2089  NH2 ARG D  12       8.692 112.890 -13.955  1.00 54.10           N  
ATOM   2090  N   GLN D  13       7.816 111.736  -7.014  1.00 34.91           N  
ATOM   2091  CA  GLN D  13       6.932 111.985  -5.878  1.00 36.65           C  
ATOM   2092  C   GLN D  13       7.217 111.162  -4.626  1.00 34.07           C  
ATOM   2093  O   GLN D  13       6.489 111.266  -3.640  1.00 31.20           O  
ATOM   2094  CB  GLN D  13       5.493 111.747  -6.312  1.00 43.94           C  
ATOM   2095  CG  GLN D  13       5.336 110.443  -7.068  1.00 53.19           C  
ATOM   2096  CD  GLN D  13       4.082 110.401  -7.913  1.00 58.72           C  
ATOM   2097  OE1 GLN D  13       3.855 111.278  -8.749  1.00 62.72           O  
ATOM   2098  NE2 GLN D  13       3.271 109.365  -7.718  1.00 61.84           N  
ATOM   2099  N   CYS D  14       8.263 110.344  -4.655  1.00 32.94           N  
ATOM   2100  CA  CYS D  14       8.607 109.527  -3.489  1.00 31.37           C  
ATOM   2101  C   CYS D  14       9.538 110.262  -2.541  1.00 31.71           C  
ATOM   2102  O   CYS D  14      10.043 109.674  -1.585  1.00 32.10           O  
ATOM   2103  CB  CYS D  14       9.282 108.230  -3.920  1.00 30.83           C  
ATOM   2104  SG  CYS D  14       8.314 107.186  -5.058  1.00 29.35           S  
ATOM   2105  N   ASN D  15       9.771 111.545  -2.811  1.00 31.68           N  
ATOM   2106  CA  ASN D  15      10.663 112.351  -1.982  1.00 32.54           C  
ATOM   2107  C   ASN D  15      12.042 111.680  -1.958  1.00 29.86           C  
ATOM   2108  O   ASN D  15      12.595 111.410  -0.891  1.00 28.36           O  
ATOM   2109  CB  ASN D  15      10.112 112.456  -0.554  1.00 44.27           C  
ATOM   2110  CG  ASN D  15      10.987 113.301   0.346  1.00 50.83           C  
ATOM   2111  OD1 ASN D  15      10.858 113.251   1.597  1.00 55.22           O  
ATOM   2112  ND2 ASN D  15      11.884 114.089  -0.262  1.00 55.23           N  
ATOM   2113  N   TRP D  16      12.585 111.405  -3.140  1.00 25.57           N  
ATOM   2114  CA  TRP D  16      13.891 110.768  -3.245  1.00 21.48           C  
ATOM   2115  C   TRP D  16      14.939 111.671  -3.877  1.00 20.45           C  
ATOM   2116  O   TRP D  16      16.077 111.254  -4.086  1.00 18.51           O  
ATOM   2117  CB  TRP D  16      13.793 109.467  -4.047  1.00 22.27           C  
ATOM   2118  CG  TRP D  16      13.080 108.366  -3.328  1.00 23.63           C  
ATOM   2119  CD1 TRP D  16      12.752 108.324  -2.000  1.00 23.90           C  
ATOM   2120  CD2 TRP D  16      12.649 107.118  -3.886  1.00 24.77           C  
ATOM   2121  NE1 TRP D  16      12.145 107.130  -1.700  1.00 24.02           N  
ATOM   2122  CE2 TRP D  16      12.065 106.371  -2.838  1.00 25.31           C  
ATOM   2123  CE3 TRP D  16      12.693 106.561  -5.170  1.00 25.83           C  
ATOM   2124  CZ2 TRP D  16      11.538 105.088  -3.035  1.00 25.49           C  
ATOM   2125  CZ3 TRP D  16      12.166 105.283  -5.365  1.00 27.35           C  
ATOM   2126  CH2 TRP D  16      11.593 104.565  -4.302  1.00 26.52           C  
HETATM 2127  N   MSE D  17      14.559 112.905  -4.193  1.00 17.92           N  
HETATM 2128  CA  MSE D  17      15.498 113.846  -4.798  1.00 17.87           C  
HETATM 2129  C   MSE D  17      16.657 114.114  -3.845  1.00 16.96           C  
HETATM 2130  O   MSE D  17      17.818 114.158  -4.254  1.00 16.25           O  
HETATM 2131  CB  MSE D  17      14.809 115.177  -5.117  1.00 20.31           C  
HETATM 2132  CG  MSE D  17      15.751 116.213  -5.722  1.00 25.83           C  
HETATM 2133 SE   MSE D  17      15.138 118.029  -5.526  1.00 38.06          SE  
HETATM 2134  CE  MSE D  17      15.682 118.317  -3.702  1.00 33.40           C  
ATOM   2135  N   LEU D  18      16.325 114.304  -2.574  1.00 15.59           N  
ATOM   2136  CA  LEU D  18      17.317 114.573  -1.540  1.00 14.00           C  
ATOM   2137  C   LEU D  18      18.467 113.567  -1.568  1.00 14.44           C  
ATOM   2138  O   LEU D  18      19.624 113.946  -1.748  1.00 14.40           O  
ATOM   2139  CB  LEU D  18      16.635 114.567  -0.168  1.00 15.74           C  
ATOM   2140  CG  LEU D  18      16.541 115.878   0.618  1.00 17.12           C  
ATOM   2141  CD1 LEU D  18      16.304 117.058  -0.312  1.00 16.29           C  
ATOM   2142  CD2 LEU D  18      15.418 115.754   1.645  1.00 14.24           C  
ATOM   2143  N   ARG D  19      18.144 112.288  -1.407  1.00 15.72           N  
ATOM   2144  CA  ARG D  19      19.163 111.247  -1.408  1.00 15.51           C  
ATOM   2145  C   ARG D  19      19.866 111.125  -2.759  1.00 13.63           C  
ATOM   2146  O   ARG D  19      21.016 110.692  -2.831  1.00 15.35           O  
ATOM   2147  CB  ARG D  19      18.545 109.903  -1.008  1.00 15.63           C  
ATOM   2148  CG  ARG D  19      17.614 109.292  -2.042  1.00 16.98           C  
ATOM   2149  CD  ARG D  19      16.875 108.110  -1.447  1.00 21.48           C  
ATOM   2150  NE  ARG D  19      15.954 108.539  -0.401  1.00 22.41           N  
ATOM   2151  CZ  ARG D  19      15.401 107.726   0.491  1.00 23.23           C  
ATOM   2152  NH1 ARG D  19      15.675 106.431   0.472  1.00 24.98           N  
ATOM   2153  NH2 ARG D  19      14.563 108.207   1.397  1.00 20.50           N  
ATOM   2154  N   SER D  20      19.175 111.510  -3.827  1.00 14.24           N  
ATOM   2155  CA  SER D  20      19.754 111.450  -5.162  1.00 15.17           C  
ATOM   2156  C   SER D  20      20.798 112.551  -5.314  1.00 14.12           C  
ATOM   2157  O   SER D  20      21.890 112.318  -5.833  1.00 16.27           O  
ATOM   2158  CB  SER D  20      18.671 111.618  -6.231  1.00 13.84           C  
ATOM   2159  OG  SER D  20      17.727 110.562  -6.184  1.00 15.48           O  
ATOM   2160  N   ALA D  21      20.455 113.750  -4.856  1.00 12.88           N  
ATOM   2161  CA  ALA D  21      21.360 114.887  -4.939  1.00 13.08           C  
ATOM   2162  C   ALA D  21      22.592 114.623  -4.089  1.00 13.09           C  
ATOM   2163  O   ALA D  21      23.703 115.018  -4.448  1.00 12.78           O  
ATOM   2164  CB  ALA D  21      20.662 116.152  -4.470  1.00 11.26           C  
ATOM   2165  N   TRP D  22      22.394 113.955  -2.957  1.00 11.10           N  
ATOM   2166  CA  TRP D  22      23.501 113.624  -2.068  1.00 11.18           C  
ATOM   2167  C   TRP D  22      24.460 112.668  -2.771  1.00 11.76           C  
ATOM   2168  O   TRP D  22      25.656 112.938  -2.874  1.00 13.88           O  
ATOM   2169  CB  TRP D  22      22.972 112.982  -0.789  1.00  9.47           C  
ATOM   2170  CG  TRP D  22      24.011 112.201  -0.060  1.00 10.17           C  
ATOM   2171  CD1 TRP D  22      25.202 112.665   0.416  1.00 10.52           C  
ATOM   2172  CD2 TRP D  22      23.961 110.808   0.263  1.00 11.80           C  
ATOM   2173  NE1 TRP D  22      25.898 111.648   1.018  1.00 12.28           N  
ATOM   2174  CE2 TRP D  22      25.161 110.495   0.938  1.00 12.61           C  
ATOM   2175  CE3 TRP D  22      23.021 109.793   0.050  1.00 13.88           C  
ATOM   2176  CZ2 TRP D  22      25.444 109.205   1.404  1.00 13.41           C  
ATOM   2177  CZ3 TRP D  22      23.301 108.515   0.512  1.00 12.71           C  
ATOM   2178  CH2 TRP D  22      24.505 108.231   1.181  1.00 13.18           C  
ATOM   2179  N   LEU D  23      23.927 111.550  -3.251  1.00 11.85           N  
ATOM   2180  CA  LEU D  23      24.738 110.564  -3.955  1.00 13.52           C  
ATOM   2181  C   LEU D  23      25.456 111.213  -5.132  1.00 13.57           C  
ATOM   2182  O   LEU D  23      26.600 110.875  -5.435  1.00 15.87           O  
ATOM   2183  CB  LEU D  23      23.854 109.419  -4.447  1.00 11.38           C  
ATOM   2184  CG  LEU D  23      23.333 108.525  -3.322  1.00 11.98           C  
ATOM   2185  CD1 LEU D  23      22.314 107.541  -3.860  1.00 11.09           C  
ATOM   2186  CD2 LEU D  23      24.511 107.806  -2.683  1.00 10.27           C  
ATOM   2187  N   SER D  24      24.778 112.148  -5.790  1.00 12.93           N  
ATOM   2188  CA  SER D  24      25.357 112.854  -6.925  1.00 13.28           C  
ATOM   2189  C   SER D  24      26.612 113.601  -6.496  1.00 14.17           C  
ATOM   2190  O   SER D  24      27.640 113.542  -7.171  1.00 15.85           O  
ATOM   2191  CB  SER D  24      24.350 113.853  -7.507  1.00 10.29           C  
ATOM   2192  OG  SER D  24      25.006 114.851  -8.273  1.00 11.19           O  
ATOM   2193  N   GLN D  25      26.520 114.301  -5.369  1.00 14.06           N  
ATOM   2194  CA  GLN D  25      27.647 115.065  -4.854  1.00 13.56           C  
ATOM   2195  C   GLN D  25      28.763 114.164  -4.341  1.00 13.72           C  
ATOM   2196  O   GLN D  25      29.934 114.521  -4.431  1.00 12.02           O  
ATOM   2197  CB  GLN D  25      27.186 116.033  -3.757  1.00 13.24           C  
ATOM   2198  CG  GLN D  25      26.280 117.152  -4.260  1.00 14.06           C  
ATOM   2199  CD  GLN D  25      25.803 118.069  -3.144  1.00 12.00           C  
ATOM   2200  OE1 GLN D  25      26.519 118.973  -2.708  1.00 12.33           O  
ATOM   2201  NE2 GLN D  25      24.588 117.829  -2.671  1.00 14.82           N  
ATOM   2202  N   GLU D  26      28.406 112.999  -3.808  1.00 12.57           N  
ATOM   2203  CA  GLU D  26      29.414 112.065  -3.319  1.00 13.42           C  
ATOM   2204  C   GLU D  26      30.307 111.654  -4.488  1.00 14.80           C  
ATOM   2205  O   GLU D  26      31.527 111.577  -4.356  1.00 16.39           O  
ATOM   2206  CB  GLU D  26      28.750 110.825  -2.726  1.00 14.15           C  
ATOM   2207  CG  GLU D  26      28.070 111.044  -1.378  1.00 14.76           C  
ATOM   2208  CD  GLU D  26      29.055 111.380  -0.266  1.00 16.29           C  
ATOM   2209  OE1 GLU D  26      30.272 111.222  -0.480  1.00 14.61           O  
ATOM   2210  OE2 GLU D  26      28.610 111.791   0.828  1.00 18.01           O  
ATOM   2211  N   LEU D  27      29.680 111.402  -5.635  1.00 17.36           N  
ATOM   2212  CA  LEU D  27      30.396 111.004  -6.840  1.00 18.05           C  
ATOM   2213  C   LEU D  27      31.187 112.159  -7.449  1.00 17.66           C  
ATOM   2214  O   LEU D  27      32.344 111.992  -7.839  1.00 18.79           O  
ATOM   2215  CB  LEU D  27      29.422 110.448  -7.880  1.00 16.70           C  
ATOM   2216  CG  LEU D  27      28.600 109.229  -7.453  1.00 17.98           C  
ATOM   2217  CD1 LEU D  27      27.665 108.828  -8.582  1.00 16.61           C  
ATOM   2218  CD2 LEU D  27      29.535 108.086  -7.088  1.00 15.11           C  
ATOM   2219  N   LEU D  28      30.559 113.327  -7.538  1.00 19.09           N  
ATOM   2220  CA  LEU D  28      31.208 114.507  -8.097  1.00 20.39           C  
ATOM   2221  C   LEU D  28      32.420 114.913  -7.260  1.00 22.78           C  
ATOM   2222  O   LEU D  28      33.412 115.418  -7.789  1.00 23.75           O  
ATOM   2223  CB  LEU D  28      30.219 115.676  -8.168  1.00 17.92           C  
ATOM   2224  CG  LEU D  28      29.063 115.584  -9.172  1.00 15.41           C  
ATOM   2225  CD1 LEU D  28      28.062 116.689  -8.884  1.00 12.60           C  
ATOM   2226  CD2 LEU D  28      29.588 115.717 -10.591  1.00 15.33           C  
ATOM   2227  N   HIS D  29      32.336 114.677  -5.956  1.00 22.33           N  
ATOM   2228  CA  HIS D  29      33.414 115.025  -5.038  1.00 24.28           C  
ATOM   2229  C   HIS D  29      34.576 114.035  -5.123  1.00 24.73           C  
ATOM   2230  O   HIS D  29      35.740 114.435  -5.145  1.00 22.58           O  
ATOM   2231  CB  HIS D  29      32.880 115.064  -3.604  1.00 29.49           C  
ATOM   2232  CG  HIS D  29      33.843 115.642  -2.617  1.00 34.81           C  
ATOM   2233  ND1 HIS D  29      34.149 116.986  -2.572  1.00 36.36           N  
ATOM   2234  CD2 HIS D  29      34.579 115.058  -1.641  1.00 35.19           C  
ATOM   2235  CE1 HIS D  29      35.028 117.204  -1.612  1.00 37.35           C  
ATOM   2236  NE2 HIS D  29      35.307 116.051  -1.031  1.00 37.26           N  
ATOM   2237  N   THR D  30      34.252 112.747  -5.180  1.00 24.68           N  
ATOM   2238  CA  THR D  30      35.266 111.702  -5.244  1.00 25.17           C  
ATOM   2239  C   THR D  30      35.937 111.548  -6.612  1.00 25.69           C  
ATOM   2240  O   THR D  30      37.136 111.281  -6.693  1.00 24.11           O  
ATOM   2241  CB  THR D  30      34.668 110.341  -4.837  1.00 27.07           C  
ATOM   2242  OG1 THR D  30      34.263 110.395  -3.464  1.00 27.73           O  
ATOM   2243  CG2 THR D  30      35.692 109.224  -5.023  1.00 23.79           C  
ATOM   2244  N   PHE D  31      35.167 111.720  -7.681  1.00 25.53           N  
ATOM   2245  CA  PHE D  31      35.697 111.586  -9.038  1.00 25.78           C  
ATOM   2246  C   PHE D  31      35.579 112.892  -9.813  1.00 26.42           C  
ATOM   2247  O   PHE D  31      35.215 112.898 -10.990  1.00 24.72           O  
ATOM   2248  CB  PHE D  31      34.941 110.493  -9.790  1.00 25.01           C  
ATOM   2249  CG  PHE D  31      34.907 109.177  -9.072  1.00 23.26           C  
ATOM   2250  CD1 PHE D  31      36.037 108.365  -9.019  1.00 25.06           C  
ATOM   2251  CD2 PHE D  31      33.755 108.766  -8.409  1.00 24.30           C  
ATOM   2252  CE1 PHE D  31      36.020 107.162  -8.315  1.00 23.40           C  
ATOM   2253  CE2 PHE D  31      33.726 107.565  -7.701  1.00 23.38           C  
ATOM   2254  CZ  PHE D  31      34.863 106.761  -7.653  1.00 24.19           C  
ATOM   2255  N   SER D  32      35.895 113.997  -9.147  1.00 30.38           N  
ATOM   2256  CA  SER D  32      35.806 115.318  -9.756  1.00 33.56           C  
ATOM   2257  C   SER D  32      36.577 115.457 -11.064  1.00 35.42           C  
ATOM   2258  O   SER D  32      36.268 116.332 -11.870  1.00 36.50           O  
ATOM   2259  CB  SER D  32      36.296 116.381  -8.773  1.00 36.68           C  
ATOM   2260  OG  SER D  32      37.681 116.240  -8.504  1.00 38.59           O  
ATOM   2261  N   GLU D  33      37.572 114.602 -11.277  1.00 36.80           N  
ATOM   2262  CA  GLU D  33      38.371 114.681 -12.495  1.00 39.84           C  
ATOM   2263  C   GLU D  33      38.116 113.587 -13.528  1.00 37.62           C  
ATOM   2264  O   GLU D  33      38.570 113.693 -14.669  1.00 37.80           O  
ATOM   2265  CB  GLU D  33      39.861 114.724 -12.137  1.00 47.04           C  
ATOM   2266  CG  GLU D  33      40.286 116.040 -11.501  1.00 54.76           C  
ATOM   2267  CD  GLU D  33      41.685 116.000 -10.921  1.00 60.04           C  
ATOM   2268  OE1 GLU D  33      42.622 115.571 -11.628  1.00 64.03           O  
ATOM   2269  OE2 GLU D  33      41.845 116.406  -9.750  1.00 64.41           O  
ATOM   2270  N   GLU D  34      37.387 112.543 -13.146  1.00 36.50           N  
ATOM   2271  CA  GLU D  34      37.103 111.460 -14.083  1.00 36.29           C  
ATOM   2272  C   GLU D  34      35.650 111.480 -14.556  1.00 32.65           C  
ATOM   2273  O   GLU D  34      35.245 110.642 -15.362  1.00 33.20           O  
ATOM   2274  CB  GLU D  34      37.401 110.101 -13.445  1.00 41.27           C  
ATOM   2275  CG  GLU D  34      38.759 110.006 -12.768  1.00 47.75           C  
ATOM   2276  CD  GLU D  34      38.792 110.736 -11.438  1.00 52.32           C  
ATOM   2277  OE1 GLU D  34      38.092 110.288 -10.504  1.00 55.57           O  
ATOM   2278  OE2 GLU D  34      39.513 111.752 -11.328  1.00 56.18           O  
ATOM   2279  N   ILE D  35      34.875 112.442 -14.065  1.00 27.85           N  
ATOM   2280  CA  ILE D  35      33.471 112.539 -14.435  1.00 25.05           C  
ATOM   2281  C   ILE D  35      33.161 113.666 -15.411  1.00 23.16           C  
ATOM   2282  O   ILE D  35      33.588 114.806 -15.220  1.00 21.47           O  
ATOM   2283  CB  ILE D  35      32.580 112.718 -13.190  1.00 22.76           C  
ATOM   2284  CG1 ILE D  35      32.415 111.377 -12.479  1.00 21.10           C  
ATOM   2285  CG2 ILE D  35      31.232 113.307 -13.587  1.00 21.49           C  
ATOM   2286  CD1 ILE D  35      31.705 111.479 -11.148  1.00 21.24           C  
ATOM   2287  N   GLU D  36      32.408 113.333 -16.455  1.00 21.71           N  
ATOM   2288  CA  GLU D  36      32.001 114.315 -17.450  1.00 22.76           C  
ATOM   2289  C   GLU D  36      30.824 115.055 -16.832  1.00 20.54           C  
ATOM   2290  O   GLU D  36      30.754 116.282 -16.869  1.00 19.10           O  
ATOM   2291  CB  GLU D  36      31.544 113.623 -18.741  1.00 25.62           C  
ATOM   2292  CG  GLU D  36      31.363 114.572 -19.921  1.00 30.41           C  
ATOM   2293  CD  GLU D  36      30.699 113.903 -21.117  1.00 34.11           C  
ATOM   2294  OE1 GLU D  36      31.053 112.745 -21.435  1.00 39.23           O  
ATOM   2295  OE2 GLU D  36      29.821 114.539 -21.738  1.00 34.89           O  
ATOM   2296  N   TYR D  37      29.901 114.282 -16.266  1.00 19.07           N  
ATOM   2297  CA  TYR D  37      28.719 114.841 -15.639  1.00 16.62           C  
ATOM   2298  C   TYR D  37      27.904 113.788 -14.894  1.00 17.04           C  
ATOM   2299  O   TYR D  37      27.996 112.591 -15.177  1.00 15.77           O  
ATOM   2300  CB  TYR D  37      27.825 115.500 -16.699  1.00 18.96           C  
ATOM   2301  CG  TYR D  37      27.091 114.529 -17.615  1.00 17.65           C  
ATOM   2302  CD1 TYR D  37      26.003 113.785 -17.153  1.00 16.54           C  
ATOM   2303  CD2 TYR D  37      27.487 114.345 -18.942  1.00 18.09           C  
ATOM   2304  CE1 TYR D  37      25.330 112.885 -17.983  1.00 15.63           C  
ATOM   2305  CE2 TYR D  37      26.819 113.447 -19.778  1.00 15.49           C  
ATOM   2306  CZ  TYR D  37      25.744 112.723 -19.292  1.00 16.40           C  
ATOM   2307  OH  TYR D  37      25.083 111.843 -20.116  1.00 14.13           O  
ATOM   2308  N   VAL D  38      27.118 114.258 -13.930  1.00 13.25           N  
ATOM   2309  CA  VAL D  38      26.216 113.416 -13.165  1.00 12.21           C  
ATOM   2310  C   VAL D  38      24.871 114.071 -13.437  1.00 14.22           C  
ATOM   2311  O   VAL D  38      24.702 115.267 -13.200  1.00 13.98           O  
ATOM   2312  CB  VAL D  38      26.510 113.463 -11.656  1.00 13.48           C  
ATOM   2313  CG1 VAL D  38      25.396 112.749 -10.896  1.00 11.16           C  
ATOM   2314  CG2 VAL D  38      27.850 112.808 -11.365  1.00 11.16           C  
ATOM   2315  N   ALA D  39      23.923 113.300 -13.953  1.00 14.22           N  
ATOM   2316  CA  ALA D  39      22.613 113.849 -14.268  1.00 14.88           C  
ATOM   2317  C   ALA D  39      21.509 113.249 -13.416  1.00 15.39           C  
ATOM   2318  O   ALA D  39      21.441 112.035 -13.230  1.00 14.43           O  
ATOM   2319  CB  ALA D  39      22.310 113.641 -15.751  1.00 12.98           C  
ATOM   2320  N   LEU D  40      20.654 114.118 -12.892  1.00 15.78           N  
ATOM   2321  CA  LEU D  40      19.532 113.693 -12.067  1.00 14.80           C  
ATOM   2322  C   LEU D  40      18.259 113.734 -12.902  1.00 14.72           C  
ATOM   2323  O   LEU D  40      17.896 114.779 -13.446  1.00 13.71           O  
ATOM   2324  CB  LEU D  40      19.396 114.614 -10.857  1.00 16.78           C  
ATOM   2325  CG  LEU D  40      20.493 114.450  -9.806  1.00 18.36           C  
ATOM   2326  CD1 LEU D  40      20.476 115.626  -8.853  1.00 20.24           C  
ATOM   2327  CD2 LEU D  40      20.277 113.145  -9.060  1.00 19.37           C  
ATOM   2328  N   HIS D  41      17.593 112.591 -13.011  1.00 14.37           N  
ATOM   2329  CA  HIS D  41      16.366 112.487 -13.791  1.00 16.69           C  
ATOM   2330  C   HIS D  41      15.123 112.258 -12.940  1.00 18.43           C  
ATOM   2331  O   HIS D  41      14.918 111.162 -12.422  1.00 17.02           O  
ATOM   2332  CB  HIS D  41      16.448 111.323 -14.788  1.00 18.48           C  
ATOM   2333  CG  HIS D  41      17.459 111.506 -15.876  1.00 19.49           C  
ATOM   2334  ND1 HIS D  41      18.817 111.443 -15.654  1.00 20.43           N  
ATOM   2335  CD2 HIS D  41      17.304 111.710 -17.205  1.00 19.56           C  
ATOM   2336  CE1 HIS D  41      19.454 111.596 -16.799  1.00 20.58           C  
ATOM   2337  NE2 HIS D  41      18.562 111.758 -17.757  1.00 20.82           N  
ATOM   2338  N   PRO D  42      14.281 113.290 -12.770  1.00 19.42           N  
ATOM   2339  CA  PRO D  42      13.082 113.045 -11.963  1.00 22.30           C  
ATOM   2340  C   PRO D  42      12.257 112.009 -12.729  1.00 24.97           C  
ATOM   2341  O   PRO D  42      12.020 112.173 -13.924  1.00 24.34           O  
ATOM   2342  CB  PRO D  42      12.415 114.420 -11.916  1.00 20.96           C  
ATOM   2343  CG  PRO D  42      12.903 115.090 -13.172  1.00 20.93           C  
ATOM   2344  CD  PRO D  42      14.349 114.689 -13.214  1.00 20.52           C  
ATOM   2345  N   ASP D  43      11.831 110.942 -12.057  1.00 28.99           N  
ATOM   2346  CA  ASP D  43      11.079 109.888 -12.738  1.00 34.33           C  
ATOM   2347  C   ASP D  43       9.729 109.533 -12.117  1.00 35.82           C  
ATOM   2348  O   ASP D  43       9.216 110.247 -11.258  1.00 34.76           O  
ATOM   2349  CB  ASP D  43      11.930 108.619 -12.820  1.00 41.86           C  
ATOM   2350  CG  ASP D  43      11.758 107.885 -14.134  1.00 45.45           C  
ATOM   2351  OD1 ASP D  43      10.605 107.714 -14.582  1.00 49.07           O  
ATOM   2352  OD2 ASP D  43      12.782 107.473 -14.715  1.00 48.94           O  
ATOM   2353  N   THR D  44       9.169 108.409 -12.563  1.00 40.02           N  
ATOM   2354  CA  THR D  44       7.875 107.931 -12.086  1.00 41.65           C  
ATOM   2355  C   THR D  44       7.949 106.938 -10.924  1.00 41.49           C  
ATOM   2356  O   THR D  44       9.016 106.431 -10.576  1.00 41.27           O  
ATOM   2357  CB  THR D  44       7.072 107.270 -13.228  1.00 46.44           C  
ATOM   2358  OG1 THR D  44       7.811 106.163 -13.759  1.00 48.05           O  
ATOM   2359  CG2 THR D  44       6.800 108.278 -14.336  1.00 48.12           C  
ATOM   2360  N   GLY D  45       6.780 106.666 -10.353  1.00 40.88           N  
ATOM   2361  CA  GLY D  45       6.636 105.770  -9.218  1.00 38.98           C  
ATOM   2362  C   GLY D  45       7.632 104.658  -8.940  1.00 37.31           C  
ATOM   2363  O   GLY D  45       7.971 103.859  -9.815  1.00 37.42           O  
ATOM   2364  N   GLY D  46       8.089 104.620  -7.691  1.00 34.77           N  
ATOM   2365  CA  GLY D  46       9.014 103.603  -7.227  1.00 32.78           C  
ATOM   2366  C   GLY D  46      10.346 103.415  -7.923  1.00 31.53           C  
ATOM   2367  O   GLY D  46      11.129 102.559  -7.514  1.00 31.94           O  
ATOM   2368  N   ARG D  47      10.626 104.198  -8.957  1.00 30.57           N  
ATOM   2369  CA  ARG D  47      11.892 104.034  -9.659  1.00 30.11           C  
ATOM   2370  C   ARG D  47      13.080 104.750  -9.030  1.00 28.86           C  
ATOM   2371  O   ARG D  47      12.988 105.906  -8.620  1.00 27.81           O  
ATOM   2372  CB  ARG D  47      11.775 104.479 -11.118  1.00 34.62           C  
ATOM   2373  CG  ARG D  47      13.021 104.139 -11.932  1.00 37.97           C  
ATOM   2374  CD  ARG D  47      13.008 104.729 -13.337  1.00 41.53           C  
ATOM   2375  NE  ARG D  47      14.148 104.242 -14.113  1.00 44.15           N  
ATOM   2376  CZ  ARG D  47      14.459 104.650 -15.340  1.00 44.46           C  
ATOM   2377  NH1 ARG D  47      13.717 105.561 -15.952  1.00 43.53           N  
ATOM   2378  NH2 ARG D  47      15.516 104.140 -15.958  1.00 45.48           N  
ATOM   2379  N   PHE D  48      14.193 104.029  -8.957  1.00 26.93           N  
ATOM   2380  CA  PHE D  48      15.460 104.547  -8.450  1.00 26.87           C  
ATOM   2381  C   PHE D  48      16.498 103.655  -9.106  1.00 26.09           C  
ATOM   2382  O   PHE D  48      16.718 102.521  -8.679  1.00 24.99           O  
ATOM   2383  CB  PHE D  48      15.587 104.430  -6.931  1.00 27.21           C  
ATOM   2384  CG  PHE D  48      16.872 105.010  -6.398  1.00 28.33           C  
ATOM   2385  CD1 PHE D  48      17.025 106.388  -6.268  1.00 28.10           C  
ATOM   2386  CD2 PHE D  48      17.953 104.188  -6.088  1.00 28.83           C  
ATOM   2387  CE1 PHE D  48      18.237 106.942  -5.845  1.00 26.81           C  
ATOM   2388  CE2 PHE D  48      19.170 104.730  -5.666  1.00 29.21           C  
ATOM   2389  CZ  PHE D  48      19.311 106.110  -5.543  1.00 28.48           C  
ATOM   2390  N   GLU D  49      17.132 104.170 -10.149  1.00 26.37           N  
ATOM   2391  CA  GLU D  49      18.117 103.399 -10.889  1.00 26.34           C  
ATOM   2392  C   GLU D  49      19.284 104.294 -11.282  1.00 22.78           C  
ATOM   2393  O   GLU D  49      19.088 105.445 -11.666  1.00 22.69           O  
ATOM   2394  CB  GLU D  49      17.433 102.825 -12.123  1.00 30.70           C  
ATOM   2395  CG  GLU D  49      18.199 101.775 -12.879  1.00 38.29           C  
ATOM   2396  CD  GLU D  49      17.347 101.160 -13.967  1.00 41.52           C  
ATOM   2397  OE1 GLU D  49      16.558 101.905 -14.587  1.00 42.58           O  
ATOM   2398  OE2 GLU D  49      17.463  99.942 -14.203  1.00 43.78           O  
ATOM   2399  N   ILE D  50      20.497 103.762 -11.184  1.00 21.97           N  
ATOM   2400  CA  ILE D  50      21.692 104.524 -11.522  1.00 21.69           C  
ATOM   2401  C   ILE D  50      22.491 103.861 -12.638  1.00 20.65           C  
ATOM   2402  O   ILE D  50      22.679 102.645 -12.647  1.00 19.94           O  
ATOM   2403  CB  ILE D  50      22.602 104.700 -10.286  1.00 19.72           C  
ATOM   2404  CG1 ILE D  50      21.826 105.410  -9.173  1.00 17.60           C  
ATOM   2405  CG2 ILE D  50      23.843 105.498 -10.657  1.00 17.80           C  
ATOM   2406  CD1 ILE D  50      22.602 105.566  -7.885  1.00 18.38           C  
ATOM   2407  N   PHE D  51      22.962 104.677 -13.575  1.00 21.68           N  
ATOM   2408  CA  PHE D  51      23.739 104.196 -14.709  1.00 22.72           C  
ATOM   2409  C   PHE D  51      25.083 104.907 -14.800  1.00 22.31           C  
ATOM   2410  O   PHE D  51      25.195 106.089 -14.481  1.00 20.98           O  
ATOM   2411  CB  PHE D  51      22.971 104.436 -16.010  1.00 27.58           C  
ATOM   2412  CG  PHE D  51      21.705 103.639 -16.121  1.00 33.16           C  
ATOM   2413  CD1 PHE D  51      21.730 102.333 -16.597  1.00 34.62           C  
ATOM   2414  CD2 PHE D  51      20.482 104.198 -15.760  1.00 35.35           C  
ATOM   2415  CE1 PHE D  51      20.559 101.588 -16.702  1.00 36.34           C  
ATOM   2416  CE2 PHE D  51      19.303 103.462 -15.861  1.00 37.21           C  
ATOM   2417  CZ  PHE D  51      19.342 102.155 -16.338  1.00 36.42           C  
ATOM   2418  N   CYS D  52      26.099 104.174 -15.243  1.00 21.03           N  
ATOM   2419  CA  CYS D  52      27.439 104.718 -15.409  1.00 22.82           C  
ATOM   2420  C   CYS D  52      27.931 104.275 -16.782  1.00 23.84           C  
ATOM   2421  O   CYS D  52      28.078 103.080 -17.045  1.00 22.93           O  
ATOM   2422  CB  CYS D  52      28.379 104.194 -14.318  1.00 22.04           C  
ATOM   2423  SG  CYS D  52      30.014 104.964 -14.332  1.00 21.72           S  
ATOM   2424  N   ASN D  53      28.174 105.244 -17.655  1.00 23.76           N  
ATOM   2425  CA  ASN D  53      28.619 104.956 -19.011  1.00 24.90           C  
ATOM   2426  C   ASN D  53      27.713 103.912 -19.663  1.00 25.88           C  
ATOM   2427  O   ASN D  53      28.190 102.998 -20.327  1.00 26.34           O  
ATOM   2428  CB  ASN D  53      30.068 104.454 -19.019  1.00 25.25           C  
ATOM   2429  CG  ASN D  53      31.053 105.515 -18.569  1.00 26.22           C  
ATOM   2430  OD1 ASN D  53      30.836 106.707 -18.791  1.00 26.59           O  
ATOM   2431  ND2 ASN D  53      32.151 105.089 -17.956  1.00 25.58           N  
ATOM   2432  N   GLY D  54      26.407 104.047 -19.459  1.00 23.95           N  
ATOM   2433  CA  GLY D  54      25.467 103.115 -20.052  1.00 25.28           C  
ATOM   2434  C   GLY D  54      25.248 101.821 -19.287  1.00 26.50           C  
ATOM   2435  O   GLY D  54      24.321 101.069 -19.594  1.00 26.66           O  
ATOM   2436  N   VAL D  55      26.092 101.554 -18.296  1.00 26.85           N  
ATOM   2437  CA  VAL D  55      25.973 100.335 -17.500  1.00 25.61           C  
ATOM   2438  C   VAL D  55      25.197 100.568 -16.209  1.00 27.09           C  
ATOM   2439  O   VAL D  55      25.558 101.433 -15.412  1.00 27.81           O  
ATOM   2440  CB  VAL D  55      27.359  99.771 -17.123  1.00 25.36           C  
ATOM   2441  CG1 VAL D  55      27.194  98.479 -16.329  1.00 22.50           C  
ATOM   2442  CG2 VAL D  55      28.184  99.535 -18.375  1.00 25.00           C  
ATOM   2443  N   GLN D  56      24.133  99.796 -16.009  1.00 28.25           N  
ATOM   2444  CA  GLN D  56      23.333  99.915 -14.794  1.00 29.61           C  
ATOM   2445  C   GLN D  56      24.156  99.430 -13.610  1.00 29.22           C  
ATOM   2446  O   GLN D  56      24.570  98.270 -13.572  1.00 28.64           O  
ATOM   2447  CB  GLN D  56      22.067  99.069 -14.884  1.00 34.66           C  
ATOM   2448  CG  GLN D  56      21.196  99.176 -13.645  1.00 38.71           C  
ATOM   2449  CD  GLN D  56      20.247  97.992 -13.489  1.00 41.71           C  
ATOM   2450  OE1 GLN D  56      20.553  97.035 -12.888  1.00 44.09           O  
ATOM   2451  NE2 GLN D  56      19.105  98.084 -14.030  1.00 42.28           N  
ATOM   2452  N   ILE D  57      24.391 100.314 -12.646  1.00 29.48           N  
ATOM   2453  CA  ILE D  57      25.167  99.938 -11.472  1.00 27.53           C  
ATOM   2454  C   ILE D  57      24.286  99.886 -10.224  1.00 28.69           C  
ATOM   2455  O   ILE D  57      24.776  99.629  -9.121  1.00 28.58           O  
ATOM   2456  CB  ILE D  57      26.352 100.905 -11.224  1.00 27.91           C  
ATOM   2457  CG1 ILE D  57      25.850 102.335 -11.051  1.00 26.81           C  
ATOM   2458  CG2 ILE D  57      27.327 100.814 -12.391  1.00 25.34           C  
ATOM   2459  CD1 ILE D  57      26.953 103.340 -10.770  1.00 24.85           C  
ATOM   2460  N   TRP D  58      22.989 100.129 -10.395  1.00 29.67           N  
ATOM   2461  CA  TRP D  58      22.062 100.078  -9.278  1.00 29.97           C  
ATOM   2462  C   TRP D  58      20.603 100.110  -9.684  1.00 31.66           C  
ATOM   2463  O   TRP D  58      20.181 100.902 -10.535  1.00 32.92           O  
ATOM   2464  CB  TRP D  58      22.344 101.199  -8.273  1.00 31.74           C  
ATOM   2465  CG  TRP D  58      21.691 100.981  -6.941  1.00 31.28           C  
ATOM   2466  CD1 TRP D  58      20.418 101.319  -6.590  1.00 31.02           C  
ATOM   2467  CD2 TRP D  58      22.254 100.310  -5.809  1.00 30.57           C  
ATOM   2468  NE1 TRP D  58      20.149 100.894  -5.311  1.00 31.42           N  
ATOM   2469  CE2 TRP D  58      21.263 100.272  -4.806  1.00 30.73           C  
ATOM   2470  CE3 TRP D  58      23.504  99.729  -5.542  1.00 30.82           C  
ATOM   2471  CZ2 TRP D  58      21.477  99.682  -3.555  1.00 32.67           C  
ATOM   2472  CZ3 TRP D  58      23.718  99.137  -4.296  1.00 31.58           C  
ATOM   2473  CH2 TRP D  58      22.707  99.118  -3.321  1.00 31.04           C  
ATOM   2474  N   GLU D  59      19.831  99.234  -9.048  1.00 35.27           N  
ATOM   2475  CA  GLU D  59      18.399  99.120  -9.303  1.00 39.14           C  
ATOM   2476  C   GLU D  59      17.753  98.812  -7.946  1.00 38.73           C  
ATOM   2477  O   GLU D  59      17.970  97.753  -7.363  1.00 38.44           O  
ATOM   2478  CB  GLU D  59      18.133  97.990 -10.298  1.00 49.68           C  
ATOM   2479  CG  GLU D  59      16.672  97.775 -10.603  1.00 59.06           C  
ATOM   2480  CD  GLU D  59      15.777  98.814  -9.996  1.00 65.69           C  
ATOM   2481  OE1 GLU D  59      15.936  99.984 -10.374  1.00 72.04           O  
ATOM   2482  OE2 GLU D  59      14.915  98.473  -9.154  1.00 70.15           O  
ATOM   2483  N   ARG D  60      16.923  99.734  -7.469  1.00 40.74           N  
ATOM   2484  CA  ARG D  60      16.276  99.594  -6.168  1.00 41.59           C  
ATOM   2485  C   ARG D  60      15.649  98.217  -5.874  1.00 42.60           C  
ATOM   2486  O   ARG D  60      15.976  97.608  -4.841  1.00 42.92           O  
ATOM   2487  CB  ARG D  60      15.224 100.672  -6.000  1.00 40.66           C  
ATOM   2488  CG  ARG D  60      14.603 100.748  -4.611  1.00 41.81           C  
ATOM   2489  CD  ARG D  60      13.512 101.810  -4.539  1.00 42.98           C  
ATOM   2490  NE  ARG D  60      12.365 101.447  -5.364  1.00 43.61           N  
ATOM   2491  CZ  ARG D  60      11.471 100.523  -5.034  1.00 44.22           C  
ATOM   2492  NH1 ARG D  60      11.586  99.865  -3.889  1.00 44.08           N  
ATOM   2493  NH2 ARG D  60      10.470 100.235  -5.857  1.00 45.01           N  
ATOM   2494  N   LYS D  61      14.746  97.754  -6.744  1.00 45.27           N  
ATOM   2495  CA  LYS D  61      14.139  96.451  -6.504  1.00 50.67           C  
ATOM   2496  C   LYS D  61      15.164  95.331  -6.460  1.00 50.26           C  
ATOM   2497  O   LYS D  61      15.176  94.507  -5.557  1.00 51.61           O  
ATOM   2498  CB  LYS D  61      13.098  96.157  -7.563  1.00 53.34           C  
ATOM   2499  CG  LYS D  61      12.139  97.279  -7.723  1.00 59.14           C  
ATOM   2500  CD  LYS D  61      11.243  97.012  -8.877  1.00 63.98           C  
ATOM   2501  CE  LYS D  61      10.320  98.159  -9.073  1.00 66.91           C  
ATOM   2502  NZ  LYS D  61       9.295  97.825 -10.104  1.00 69.21           N  
ATOM   2503  N   GLN D  62      16.004  95.328  -7.478  1.00 48.03           N  
ATOM   2504  CA  GLN D  62      17.054  94.343  -7.628  1.00 49.41           C  
ATOM   2505  C   GLN D  62      17.896  94.233  -6.372  1.00 47.69           C  
ATOM   2506  O   GLN D  62      18.138  93.159  -5.833  1.00 42.94           O  
ATOM   2507  CB  GLN D  62      17.927  94.739  -8.800  1.00 59.12           C  
ATOM   2508  CG  GLN D  62      19.061  93.809  -9.103  1.00 71.22           C  
ATOM   2509  CD  GLN D  62      19.825  94.261 -10.313  1.00 78.00           C  
ATOM   2510  OE1 GLN D  62      20.414  95.348 -10.308  1.00 81.44           O  
ATOM   2511  NE2 GLN D  62      19.836  93.419 -11.374  1.00 81.94           N  
ATOM   2512  N   GLU D  63      18.329  95.383  -5.880  1.00 48.90           N  
ATOM   2513  CA  GLU D  63      19.166  95.504  -4.684  1.00 41.37           C  
ATOM   2514  C   GLU D  63      18.323  95.502  -3.413  1.00 40.74           C  
ATOM   2515  O   GLU D  63      18.829  95.321  -2.300  1.00 30.25           O  
ATOM   2516  CB  GLU D  63      19.935  96.826  -4.748  1.00 35.36           C  
ATOM   2517  CG  GLU D  63      21.139  97.058  -5.727  1.00 26.94           C  
ATOM   2518  CD  GLU D  63      22.131  95.906  -5.919  1.00 24.76           C  
ATOM   2519  OE1 GLU D  63      22.366  95.127  -4.958  1.00 27.31           O  
ATOM   2520  OE2 GLU D  63      22.678  95.802  -7.050  1.00 26.78           O  
ATOM   2521  N   GLY D  64      17.008  95.730  -3.565  1.00 36.65           N  
ATOM   2522  CA  GLY D  64      16.117  95.763  -2.393  1.00 38.55           C  
ATOM   2523  C   GLY D  64      16.450  96.929  -1.454  1.00 39.03           C  
ATOM   2524  O   GLY D  64      16.482  96.768  -0.219  1.00 43.20           O  
ATOM   2525  N   GLY D  65      16.752  98.102  -2.045  1.00 38.88           N  
ATOM   2526  CA  GLY D  65      17.023  99.266  -1.229  1.00 37.28           C  
ATOM   2527  C   GLY D  65      17.886 100.303  -1.907  1.00 35.61           C  
ATOM   2528  O   GLY D  65      17.942 100.343  -3.131  1.00 35.89           O  
ATOM   2529  N   PHE D  66      18.559 101.139  -1.110  1.00 33.34           N  
ATOM   2530  CA  PHE D  66      19.398 102.194  -1.645  1.00 32.46           C  
ATOM   2531  C   PHE D  66      20.857 101.956  -1.299  1.00 33.13           C  
ATOM   2532  O   PHE D  66      21.169 101.418  -0.251  1.00 30.96           O  
ATOM   2533  CB  PHE D  66      18.934 103.561  -1.120  1.00 33.62           C  
ATOM   2534  CG  PHE D  66      17.500 103.870  -1.434  1.00 34.03           C  
ATOM   2535  CD1 PHE D  66      16.478 103.336  -0.657  1.00 33.86           C  
ATOM   2536  CD2 PHE D  66      17.167 104.642  -2.545  1.00 34.39           C  
ATOM   2537  CE1 PHE D  66      15.140 103.555  -0.989  1.00 34.64           C  
ATOM   2538  CE2 PHE D  66      15.838 104.863  -2.882  1.00 35.37           C  
ATOM   2539  CZ  PHE D  66      14.825 104.322  -2.105  1.00 34.70           C  
ATOM   2540  N   PRO D  67      21.770 102.366  -2.198  1.00 31.92           N  
ATOM   2541  CA  PRO D  67      23.217 102.207  -2.040  1.00 31.77           C  
ATOM   2542  C   PRO D  67      23.921 103.062  -1.017  1.00 34.98           C  
ATOM   2543  O   PRO D  67      23.521 104.202  -0.760  1.00 35.08           O  
ATOM   2544  CB  PRO D  67      23.736 102.499  -3.441  1.00 33.07           C  
ATOM   2545  CG  PRO D  67      22.853 103.634  -3.838  1.00 31.36           C  
ATOM   2546  CD  PRO D  67      21.482 103.150  -3.408  1.00 31.84           C  
ATOM   2547  N   GLU D  68      24.967 102.489  -0.446  1.00 36.44           N  
ATOM   2548  CA  GLU D  68      25.780 103.187   0.524  1.00 39.99           C  
ATOM   2549  C   GLU D  68      26.736 103.978  -0.336  1.00 37.55           C  
ATOM   2550  O   GLU D  68      27.021 103.587  -1.465  1.00 36.74           O  
ATOM   2551  CB  GLU D  68      26.580 102.215   1.362  1.00 55.81           C  
ATOM   2552  CG  GLU D  68      25.819 101.028   1.792  1.00 71.45           C  
ATOM   2553  CD  GLU D  68      26.239 100.562   3.154  1.00 80.55           C  
ATOM   2554  OE1 GLU D  68      27.252  99.820   3.271  1.00 87.10           O  
ATOM   2555  OE2 GLU D  68      25.529 100.945   4.103  1.00 88.38           O  
ATOM   2556  N   ALA D  69      27.220 105.089   0.188  1.00 34.69           N  
ATOM   2557  CA  ALA D  69      28.146 105.904  -0.571  1.00 33.73           C  
ATOM   2558  C   ALA D  69      29.346 105.077  -1.027  1.00 33.95           C  
ATOM   2559  O   ALA D  69      29.768 105.167  -2.180  1.00 32.48           O  
ATOM   2560  CB  ALA D  69      28.596 107.096   0.276  1.00 33.43           C  
ATOM   2561  N   LYS D  70      29.882 104.258  -0.127  1.00 34.01           N  
ATOM   2562  CA  LYS D  70      31.043 103.437  -0.433  1.00 35.93           C  
ATOM   2563  C   LYS D  70      30.808 102.444  -1.574  1.00 32.85           C  
ATOM   2564  O   LYS D  70      31.618 102.341  -2.498  1.00 31.71           O  
ATOM   2565  CB  LYS D  70      31.494 102.693   0.828  1.00 45.29           C  
ATOM   2566  CG  LYS D  70      32.785 101.900   0.667  1.00 55.13           C  
ATOM   2567  CD  LYS D  70      33.249 101.338   2.004  1.00 63.74           C  
ATOM   2568  CE  LYS D  70      32.204 100.411   2.607  1.00 69.97           C  
ATOM   2569  NZ  LYS D  70      32.627  99.885   3.931  1.00 74.60           N  
ATOM   2570  N   VAL D  71      29.699 101.714  -1.508  1.00 30.58           N  
ATOM   2571  CA  VAL D  71      29.369 100.732  -2.532  1.00 28.16           C  
ATOM   2572  C   VAL D  71      29.215 101.375  -3.907  1.00 27.94           C  
ATOM   2573  O   VAL D  71      29.743 100.872  -4.901  1.00 27.29           O  
ATOM   2574  CB  VAL D  71      28.069  99.989  -2.181  1.00 29.43           C  
ATOM   2575  CG1 VAL D  71      27.675  99.059  -3.315  1.00 27.49           C  
ATOM   2576  CG2 VAL D  71      28.262  99.198  -0.900  1.00 29.65           C  
ATOM   2577  N   LEU D  72      28.491 102.489  -3.962  1.00 27.23           N  
ATOM   2578  CA  LEU D  72      28.279 103.189  -5.226  1.00 26.32           C  
ATOM   2579  C   LEU D  72      29.584 103.729  -5.797  1.00 26.06           C  
ATOM   2580  O   LEU D  72      29.792 103.684  -7.008  1.00 24.54           O  
ATOM   2581  CB  LEU D  72      27.290 104.345  -5.046  1.00 27.96           C  
ATOM   2582  CG  LEU D  72      26.818 105.014  -6.343  1.00 28.91           C  
ATOM   2583  CD1 LEU D  72      26.032 104.007  -7.173  1.00 29.11           C  
ATOM   2584  CD2 LEU D  72      25.965 106.232  -6.019  1.00 28.71           C  
ATOM   2585  N   LYS D  73      30.450 104.250  -4.932  1.00 25.60           N  
ATOM   2586  CA  LYS D  73      31.740 104.795  -5.364  1.00 26.06           C  
ATOM   2587  C   LYS D  73      32.528 103.686  -6.030  1.00 28.27           C  
ATOM   2588  O   LYS D  73      33.126 103.847  -7.087  1.00 26.46           O  
ATOM   2589  CB  LYS D  73      32.543 105.306  -4.159  1.00 27.32           C  
ATOM   2590  CG  LYS D  73      32.101 106.653  -3.609  1.00 26.78           C  
ATOM   2591  CD  LYS D  73      32.951 107.060  -2.410  1.00 28.55           C  
ATOM   2592  CE  LYS D  73      32.442 108.338  -1.763  1.00 30.45           C  
ATOM   2593  NZ  LYS D  73      33.168 108.641  -0.500  1.00 32.99           N  
ATOM   2594  N   GLN D  74      32.499 102.548  -5.372  1.00 31.29           N  
ATOM   2595  CA  GLN D  74      33.213 101.386  -5.816  1.00 33.09           C  
ATOM   2596  C   GLN D  74      32.760 100.897  -7.197  1.00 32.37           C  
ATOM   2597  O   GLN D  74      33.585 100.680  -8.087  1.00 31.55           O  
ATOM   2598  CB  GLN D  74      33.019 100.316  -4.762  1.00 43.31           C  
ATOM   2599  CG  GLN D  74      33.522  99.024  -5.188  1.00 52.90           C  
ATOM   2600  CD  GLN D  74      32.818  97.903  -4.592  1.00 59.74           C  
ATOM   2601  OE1 GLN D  74      32.821  97.761  -3.383  1.00 64.00           O  
ATOM   2602  NE2 GLN D  74      32.185  97.084  -5.420  1.00 64.04           N  
ATOM   2603  N   ARG D  75      31.453 100.720  -7.368  1.00 30.20           N  
ATOM   2604  CA  ARG D  75      30.889 100.260  -8.628  1.00 29.43           C  
ATOM   2605  C   ARG D  75      31.199 101.220  -9.771  1.00 28.89           C  
ATOM   2606  O   ARG D  75      31.308 100.810 -10.926  1.00 30.09           O  
ATOM   2607  CB  ARG D  75      29.382 100.083  -8.485  1.00 29.08           C  
ATOM   2608  CG  ARG D  75      29.019  98.947  -7.556  1.00 28.05           C  
ATOM   2609  CD  ARG D  75      27.555  98.599  -7.659  1.00 27.60           C  
ATOM   2610  NE  ARG D  75      27.177  97.549  -6.714  1.00 29.33           N  
ATOM   2611  CZ  ARG D  75      26.014  96.916  -6.732  1.00 29.19           C  
ATOM   2612  NH1 ARG D  75      25.108  97.221  -7.652  1.00 29.83           N  
ATOM   2613  NH2 ARG D  75      25.754  95.982  -5.830  1.00 31.00           N  
ATOM   2614  N   VAL D  76      31.328 102.503  -9.446  1.00 28.28           N  
ATOM   2615  CA  VAL D  76      31.646 103.509 -10.453  1.00 29.02           C  
ATOM   2616  C   VAL D  76      33.130 103.405 -10.791  1.00 30.19           C  
ATOM   2617  O   VAL D  76      33.520 103.482 -11.954  1.00 30.44           O  
ATOM   2618  CB  VAL D  76      31.357 104.947  -9.944  1.00 25.06           C  
ATOM   2619  CG1 VAL D  76      32.034 105.974 -10.845  1.00 21.19           C  
ATOM   2620  CG2 VAL D  76      29.859 105.189  -9.917  1.00 23.17           C  
ATOM   2621  N   ARG D  77      33.943 103.217  -9.756  1.00 32.64           N  
ATOM   2622  CA  ARG D  77      35.386 103.111  -9.911  1.00 35.93           C  
ATOM   2623  C   ARG D  77      35.776 101.929 -10.808  1.00 37.99           C  
ATOM   2624  O   ARG D  77      36.679 102.045 -11.637  1.00 36.04           O  
ATOM   2625  CB  ARG D  77      36.051 102.985  -8.530  1.00 38.74           C  
ATOM   2626  CG  ARG D  77      37.575 103.007  -8.548  1.00 40.55           C  
ATOM   2627  CD  ARG D  77      38.190 102.992  -7.145  1.00 42.36           C  
ATOM   2628  NE  ARG D  77      38.033 104.261  -6.435  1.00 43.69           N  
ATOM   2629  CZ  ARG D  77      37.186 104.466  -5.430  1.00 44.74           C  
ATOM   2630  NH1 ARG D  77      36.407 103.482  -5.001  1.00 44.22           N  
ATOM   2631  NH2 ARG D  77      37.125 105.656  -4.847  1.00 44.73           N  
ATOM   2632  N   ASP D  78      35.084 100.800 -10.656  1.00 40.81           N  
ATOM   2633  CA  ASP D  78      35.376  99.622 -11.466  1.00 42.88           C  
ATOM   2634  C   ASP D  78      35.039  99.801 -12.947  1.00 42.36           C  
ATOM   2635  O   ASP D  78      35.490  99.014 -13.790  1.00 42.82           O  
ATOM   2636  CB  ASP D  78      34.645  98.391 -10.909  1.00 50.50           C  
ATOM   2637  CG  ASP D  78      35.096  98.020  -9.501  1.00 54.67           C  
ATOM   2638  OD1 ASP D  78      36.295  98.204  -9.184  1.00 57.78           O  
ATOM   2639  OD2 ASP D  78      34.266  97.526  -8.718  1.00 57.04           O  
ATOM   2640  N   LEU D  79      34.249 100.822 -13.264  1.00 39.98           N  
ATOM   2641  CA  LEU D  79      33.865 101.066 -14.651  1.00 38.34           C  
ATOM   2642  C   LEU D  79      34.599 102.253 -15.253  1.00 39.57           C  
ATOM   2643  O   LEU D  79      34.550 102.468 -16.462  1.00 43.57           O  
ATOM   2644  CB  LEU D  79      32.381 101.375 -14.778  1.00 36.86           C  
ATOM   2645  CG  LEU D  79      31.394 100.233 -14.567  1.00 34.91           C  
ATOM   2646  CD1 LEU D  79      30.011 100.821 -14.426  1.00 33.00           C  
ATOM   2647  CD2 LEU D  79      31.413  99.340 -15.792  1.00 31.86           C  
ATOM   2648  N   ILE D  80      35.254 103.031 -14.400  1.00 38.65           N  
ATOM   2649  CA  ILE D  80      35.966 104.235 -14.796  1.00 39.32           C  
ATOM   2650  C   ILE D  80      37.337 104.043 -15.439  1.00 36.98           C  
ATOM   2651  O   ILE D  80      38.013 103.045 -15.187  1.00 36.50           O  
ATOM   2652  CB  ILE D  80      36.122 105.178 -13.581  1.00 44.82           C  
ATOM   2653  CG1 ILE D  80      34.744 105.681 -13.179  1.00 47.61           C  
ATOM   2654  CG2 ILE D  80      37.069 106.313 -13.882  1.00 47.74           C  
ATOM   2655  CD1 ILE D  80      34.811 106.674 -12.007  1.00 51.64           C  
ATOM   2656  N   ASP D  81      37.732 105.004 -16.242  1.00 34.93           N  
ATOM   2657  CA  ASP D  81      39.043 105.008 -16.864  1.00 30.04           C  
ATOM   2658  C   ASP D  81      39.928 105.320 -15.658  1.00 28.75           C  
ATOM   2659  O   ASP D  81      39.989 106.461 -15.187  1.00 27.29           O  
ATOM   2660  CB  ASP D  81      39.178 106.141 -17.870  1.00 26.97           C  
ATOM   2661  CG  ASP D  81      40.537 106.179 -18.532  1.00 26.98           C  
ATOM   2662  OD1 ASP D  81      41.514 105.756 -17.884  1.00 27.47           O  
ATOM   2663  OD2 ASP D  81      40.649 106.628 -19.683  1.00 26.57           O  
ATOM   2664  N   PRO D  82      40.620 104.297 -15.131  1.00 25.30           N  
ATOM   2665  CA  PRO D  82      41.490 104.493 -13.967  1.00 24.82           C  
ATOM   2666  C   PRO D  82      42.679 105.398 -14.251  1.00 25.94           C  
ATOM   2667  O   PRO D  82      43.653 105.342 -13.481  1.00 27.68           O  
ATOM   2668  CB  PRO D  82      41.931 103.069 -13.654  1.00 23.33           C  
ATOM   2669  CG  PRO D  82      42.020 102.464 -14.996  1.00 23.55           C  
ATOM   2670  CD  PRO D  82      40.761 102.951 -15.678  1.00 22.68           C  
TER    2671      PRO D  82                                                      
END
MOLECULE T0458.pdb
ATOM   1307  N   THR    12      35.233 112.701 -19.135  1.00 39.16           N  
ATOM   1308  CA  THR    12      35.143 111.676 -20.213  1.00 38.90           C  
ATOM   1309  C   THR    12      34.112 110.567 -19.899  1.00 40.96           C  
ATOM   1310  O   THR    12      33.648 109.876 -20.805  1.00 39.76           O  
ATOM   1311  CB  THR    12      36.539 111.055 -20.467  1.00 36.99           C  
ATOM   1312  OG1 THR    12      36.541 110.386 -21.728  1.00 33.73           O  
ATOM   1313  CG2 THR    12      36.902 110.062 -19.365  1.00 36.11           C  
ATOM   1314  N   HIS    13      33.754 110.409 -18.620  1.00 42.95           N  
ATOM   1315  CA  HIS    13      32.768 109.405 -18.186  1.00 42.37           C  
ATOM   1316  C   HIS    13      31.481 110.051 -17.638  1.00 39.31           C  
ATOM   1317  O   HIS    13      31.550 110.916 -16.776  1.00 39.49           O  
ATOM   1318  CB  HIS    13      33.360 108.504 -17.091  1.00 45.88           C  
ATOM   1319  CG  HIS    13      34.163 107.348 -17.608  1.00 45.03           C  
ATOM   1320  ND1 HIS    13      35.476 107.468 -18.010  1.00 45.10           N  
ATOM   1321  CD2 HIS    13      33.840 106.042 -17.763  1.00 38.68           C  
ATOM   1322  CE1 HIS    13      35.928 106.286 -18.388  1.00 40.14           C  
ATOM   1323  NE2 HIS    13      34.955 105.405 -18.249  1.00 41.81           N  
ATOM   1324  N   ARG    14      30.321 109.602 -18.117  1.00 35.30           N  
ATOM   1325  CA  ARG    14      29.012 110.124 -17.694  1.00 33.07           C  
ATOM   1326  C   ARG    14      28.270 109.275 -16.638  1.00 32.17           C  
ATOM   1327  O   ARG    14      28.250 108.043 -16.729  1.00 34.66           O  
ATOM   1328  CB  ARG    14      28.077 110.231 -18.901  1.00 30.55           C  
ATOM   1329  CG  ARG    14      28.092 111.531 -19.645  1.00 41.12           C  
ATOM   1330  CD  ARG    14      26.788 111.725 -20.417  1.00 52.11           C  
ATOM   1331  NE  ARG    14      25.605 111.441 -19.583  1.00 63.25           N  
ATOM   1332  CZ  ARG    14      24.380 111.936 -19.790  1.00 63.42           C  
ATOM   1333  NH1 ARG    14      23.379 111.608 -18.979  1.00 59.81           N  
ATOM   1334  NH2 ARG    14      24.157 112.777 -20.794  1.00 64.54           N  
ATOM   1335  N   VAL    15      27.635 109.920 -15.659  1.00 26.43           N  
ATOM   1336  CA  VAL    15      26.857 109.184 -14.657  1.00 20.22           C  
ATOM   1337  C   VAL    15      25.458 109.762 -14.622  1.00 18.68           C  
ATOM   1338  O   VAL    15      25.276 110.951 -14.811  1.00 24.00           O  
ATOM   1339  CB  VAL    15      27.464 109.273 -13.230  1.00 22.11           C  
ATOM   1340  CG1 VAL    15      26.500 108.673 -12.212  1.00 18.60           C  
ATOM   1341  CG2 VAL    15      28.785 108.521 -13.180  1.00 21.25           C  
ATOM   1342  N   GLN    16      24.465 108.925 -14.388  1.00 18.92           N  
ATOM   1343  CA  GLN    16      23.099 109.404 -14.339  1.00 20.61           C  
ATOM   1344  C   GLN    16      22.377 108.740 -13.172  1.00 20.40           C  
ATOM   1345  O   GLN    16      22.593 107.562 -12.890  1.00 22.85           O  
ATOM   1346  CB  GLN    16      22.400 109.073 -15.655  1.00 23.81           C  
ATOM   1347  CG  GLN    16      20.923 109.356 -15.665  1.00 30.32           C  
ATOM   1348  CD  GLN    16      20.263 108.887 -16.947  1.00 37.44           C  
ATOM   1349  OE1 GLN    16      20.323 107.701 -17.302  1.00 39.95           O  
ATOM   1350  NE2 GLN    16      19.625 109.820 -17.654  1.00 42.41           N  
ATOM   1351  N   ILE    17      21.523 109.495 -12.492  1.00 20.42           N  
ATOM   1352  CA  ILE    17      20.762 108.969 -11.364  1.00 14.91           C  
ATOM   1353  C   ILE    17      19.307 109.239 -11.617  1.00 15.05           C  
ATOM   1354  O   ILE    17      18.911 110.388 -11.727  1.00 24.10           O  
ATOM   1355  CB  ILE    17      21.159 109.676 -10.065  1.00 14.15           C  
ATOM   1356  CG1 ILE    17      22.619 109.367  -9.757  1.00 17.41           C  
ATOM   1357  CG2 ILE    17      20.241 109.271  -8.928  1.00  6.52           C  
ATOM   1358  CD1 ILE    17      23.132 110.054  -8.534  1.00 18.66           C  
ATOM   1359  N   GLU    18      18.506 108.200 -11.739  1.00 12.00           N  
ATOM   1360  CA  GLU    18      17.079 108.398 -11.959  1.00 17.13           C  
ATOM   1361  C   GLU    18      16.341 108.070 -10.650  1.00 19.59           C  
ATOM   1362  O   GLU    18      16.342 106.921 -10.189  1.00 16.11           O  
ATOM   1363  CB  GLU    18      16.612 107.486 -13.089  1.00 22.94           C  
ATOM   1364  CG  GLU    18      15.173 107.698 -13.530  1.00 34.31           C  
ATOM   1365  CD  GLU    18      14.711 106.651 -14.538  1.00 42.81           C  
ATOM   1366  OE1 GLU    18      13.515 106.693 -14.946  1.00 55.33           O  
ATOM   1367  OE2 GLU    18      15.543 105.786 -14.918  1.00 42.86           O  
ATOM   1368  N   TYR    19      15.715 109.083 -10.060  1.00 20.98           N  
ATOM   1369  CA  TYR    19      14.996 108.948  -8.781  1.00 24.62           C  
ATOM   1370  C   TYR    19      13.485 109.146  -8.906  1.00 24.60           C  
ATOM   1371  O   TYR    19      13.041 109.996  -9.668  1.00 23.03           O  
ATOM   1372  CB  TYR    19      15.511 109.999  -7.799  1.00 23.04           C  
ATOM   1373  CG  TYR    19      15.279 111.412  -8.298  1.00 20.84           C  
ATOM   1374  CD1 TYR    19      16.006 111.919  -9.383  1.00 13.93           C  
ATOM   1375  CD2 TYR    19      14.280 112.206  -7.746  1.00 16.88           C  
ATOM   1376  CE1 TYR    19      15.732 113.175  -9.909  1.00 13.50           C  
ATOM   1377  CE2 TYR    19      13.997 113.466  -8.264  1.00 21.62           C  
ATOM   1378  CZ  TYR    19      14.722 113.946  -9.346  1.00 18.13           C  
ATOM   1379  OH  TYR    19      14.429 115.187  -9.864  1.00 14.85           O  
ATOM   1380  N   CYS    20      12.700 108.395  -8.137  1.00 27.92           N  
ATOM   1381  CA  CYS    20      11.250 108.540  -8.199  1.00 32.48           C  
ATOM   1382  C   CYS    20      10.873 109.894  -7.620  1.00 33.70           C  
ATOM   1383  O   CYS    20      11.123 110.189  -6.453  1.00 33.30           O  
ATOM   1384  CB  CYS    20      10.545 107.395  -7.441  1.00 39.40           C  
ATOM   1385  SG  CYS    20       8.812 107.705  -6.905  1.00 47.94           S  
ATOM   1386  N   THR    21      10.281 110.721  -8.466  1.00 36.58           N  
ATOM   1387  CA  THR    21       9.877 112.061  -8.087  1.00 39.46           C  
ATOM   1388  C   THR    21       8.732 112.041  -7.063  1.00 40.19           C  
ATOM   1389  O   THR    21       8.768 112.759  -6.064  1.00 39.98           O  
ATOM   1390  CB  THR    21       9.483 112.862  -9.360  1.00 39.20           C  
ATOM   1391  OG1 THR    21       9.033 114.168  -8.998  1.00 45.36           O  
ATOM   1392  CG2 THR    21       8.379 112.139 -10.119  1.00 44.44           C  
ATOM   1393  N   GLN    22       7.732 111.200  -7.296  1.00 41.06           N  
ATOM   1394  CA  GLN    22       6.587 111.110  -6.391  1.00 44.27           C  
ATOM   1395  C   GLN    22       6.982 110.661  -4.978  1.00 44.35           C  
ATOM   1396  O   GLN    22       6.388 111.081  -3.978  1.00 40.32           O  
ATOM   1397  CB  GLN    22       5.547 110.146  -6.968  1.00 49.73           C  
ATOM   1398  CG  GLN    22       5.202 110.406  -8.431  1.00 57.57           C  
ATOM   1399  CD  GLN    22       4.559 111.763  -8.654  1.00 63.63           C  
ATOM   1400  OE1 GLN    22       3.488 112.051  -8.111  1.00 68.32           O  
ATOM   1401  NE2 GLN    22       5.209 112.607  -9.460  1.00 65.91           N  
ATOM   1402  N   CYS    23       7.996 109.812  -4.901  1.00 43.84           N  
ATOM   1403  CA  CYS    23       8.474 109.301  -3.622  1.00 41.93           C  
ATOM   1404  C   CYS    23       9.292 110.351  -2.850  1.00 39.32           C  
ATOM   1405  O   CYS    23       9.830 110.054  -1.788  1.00 36.69           O  
ATOM   1406  CB  CYS    23       9.341 108.061  -3.859  1.00 41.55           C  
ATOM   1407  SG  CYS    23       8.704 106.833  -5.047  1.00 53.71           S  
ATOM   1408  N   ARG    24       9.384 111.568  -3.382  1.00 36.78           N  
ATOM   1409  CA  ARG    24      10.159 112.625  -2.730  1.00 37.41           C  
ATOM   1410  C   ARG    24      11.608 112.157  -2.517  1.00 36.10           C  
ATOM   1411  O   ARG    24      12.173 112.325  -1.433  1.00 35.46           O  
ATOM   1412  CB  ARG    24       9.543 112.996  -1.366  1.00 39.04           C  
ATOM   1413  CG  ARG    24       8.055 113.365  -1.394  1.00 48.84           C  
ATOM   1414  CD  ARG    24       7.771 114.873  -1.434  1.00 54.67           C  
ATOM   1415  NE  ARG    24       7.980 115.487  -2.751  1.00 62.77           N  
ATOM   1416  CZ  ARG    24       7.809 116.785  -3.010  1.00 66.70           C  
ATOM   1417  NH1 ARG    24       7.423 117.614  -2.042  1.00 68.58           N  
ATOM   1418  NH2 ARG    24       8.024 117.260  -4.235  1.00 63.77           N  
ATOM   1419  N   TRP    25      12.210 111.575  -3.550  1.00 30.49           N  
ATOM   1420  CA  TRP    25      13.576 111.081  -3.434  1.00 27.73           C  
ATOM   1421  C   TRP    25      14.638 111.992  -4.059  1.00 26.32           C  
ATOM   1422  O   TRP    25      15.796 111.592  -4.273  1.00 21.86           O  
ATOM   1423  CB  TRP    25      13.697 109.677  -4.032  1.00 24.28           C  
ATOM   1424  CG  TRP    25      13.115 108.585  -3.175  1.00 26.51           C  
ATOM   1425  CD1 TRP    25      12.754 108.672  -1.866  1.00 22.11           C  
ATOM   1426  CD2 TRP    25      12.862 107.226  -3.572  1.00 27.33           C  
ATOM   1427  NE1 TRP    25      12.293 107.453  -1.421  1.00 25.73           N  
ATOM   1428  CE2 TRP    25      12.346 106.551  -2.449  1.00 23.98           C  
ATOM   1429  CE3 TRP    25      13.026 106.518  -4.770  1.00 25.78           C  
ATOM   1430  CZ2 TRP    25      11.987 105.210  -2.485  1.00 25.25           C  
ATOM   1431  CZ3 TRP    25      12.672 105.179  -4.807  1.00 27.16           C  
ATOM   1432  CH2 TRP    25      12.156 104.539  -3.669  1.00 28.13           C  
ATOM   1433  N   LEU    26      14.242 113.223  -4.340  1.00 23.87           N  
ATOM   1434  CA  LEU    26      15.151 114.188  -4.917  1.00 24.08           C  
ATOM   1435  C   LEU    26      16.310 114.425  -3.957  1.00 24.23           C  
ATOM   1436  O   LEU    26      17.486 114.364  -4.336  1.00 24.06           O  
ATOM   1437  CB  LEU    26      14.431 115.512  -5.188  1.00 18.76           C  
ATOM   1438  CG  LEU    26      15.326 116.672  -5.637  1.00 15.92           C  
ATOM   1439  CD1 LEU    26      16.110 116.290  -6.882  1.00 15.11           C  
ATOM   1440  CD2 LEU    26      14.477 117.874  -5.902  1.00 18.44           C  
ATOM   1441  N   PRO    27      16.000 114.705  -2.691  1.00 25.42           N  
ATOM   1442  CA  PRO    27      17.095 114.936  -1.749  1.00 25.47           C  
ATOM   1443  C   PRO    27      18.144 113.820  -1.668  1.00 20.34           C  
ATOM   1444  O   PRO    27      19.333 114.107  -1.643  1.00 20.35           O  
ATOM   1445  CB  PRO    27      16.369 115.172  -0.420  1.00 22.29           C  
ATOM   1446  CG  PRO    27      15.083 114.437  -0.586  1.00 28.33           C  
ATOM   1447  CD  PRO    27      14.701 114.788  -2.008  1.00 27.68           C  
ATOM   1448  N   ARG    28      17.734 112.557  -1.640  1.00 20.83           N  
ATOM   1449  CA  ARG    28      18.731 111.490  -1.556  1.00 22.05           C  
ATOM   1450  C   ARG    28      19.484 111.317  -2.873  1.00 23.44           C  
ATOM   1451  O   ARG    28      20.633 110.855  -2.898  1.00 19.09           O  
ATOM   1452  CB  ARG    28      18.090 110.162  -1.140  1.00 22.56           C  
ATOM   1453  CG  ARG    28      17.134 109.566  -2.148  1.00 26.08           C  
ATOM   1454  CD  ARG    28      16.553 108.280  -1.589  1.00 27.46           C  
ATOM   1455  NE  ARG    28      15.820 108.536  -0.353  1.00 32.39           N  
ATOM   1456  CZ  ARG    28      15.228 107.600   0.383  1.00 31.09           C  
ATOM   1457  NH1 ARG    28      15.285 106.329   0.009  1.00 33.28           N  
ATOM   1458  NH2 ARG    28      14.570 107.936   1.488  1.00 26.89           N  
ATOM   1459  N   ALA    29      18.822 111.664  -3.974  1.00 23.48           N  
ATOM   1460  CA  ALA    29      19.446 111.595  -5.290  1.00 16.24           C  
ATOM   1461  C   ALA    29      20.522 112.673  -5.320  1.00 16.53           C  
ATOM   1462  O   ALA    29      21.648 112.430  -5.749  1.00 17.05           O  
ATOM   1463  CB  ALA    29      18.424 111.863  -6.352  1.00 11.90           C  
ATOM   1464  N   ALA    30      20.164 113.866  -4.840  1.00 15.58           N  
ATOM   1465  CA  ALA    30      21.089 114.990  -4.798  1.00 12.15           C  
ATOM   1466  C   ALA    30      22.292 114.672  -3.919  1.00 13.81           C  
ATOM   1467  O   ALA    30      23.417 115.024  -4.245  1.00 17.93           O  
ATOM   1468  CB  ALA    30      20.387 116.217  -4.291  1.00  7.14           C  
ATOM   1469  N   TRP    31      22.050 113.988  -2.810  1.00 14.83           N  
ATOM   1470  CA  TRP    31      23.113 113.629  -1.904  1.00 13.24           C  
ATOM   1471  C   TRP    31      24.094 112.688  -2.569  1.00 16.56           C  
ATOM   1472  O   TRP    31      25.307 112.883  -2.482  1.00 18.69           O  
ATOM   1473  CB  TRP    31      22.532 112.968  -0.671  1.00 14.12           C  
ATOM   1474  CG  TRP    31      23.522 112.170   0.067  1.00 15.03           C  
ATOM   1475  CD1 TRP    31      24.635 112.625   0.710  1.00 13.81           C  
ATOM   1476  CD2 TRP    31      23.549 110.754   0.169  1.00 15.91           C  
ATOM   1477  NE1 TRP    31      25.360 111.573   1.201  1.00 17.25           N  
ATOM   1478  CE2 TRP    31      24.716 110.411   0.883  1.00 17.90           C  
ATOM   1479  CE3 TRP    31      22.703 109.739  -0.279  1.00 18.37           C  
ATOM   1480  CZ2 TRP    31      25.064 109.090   1.157  1.00 24.19           C  
ATOM   1481  CZ3 TRP    31      23.043 108.431  -0.012  1.00 25.80           C  
ATOM   1482  CH2 TRP    31      24.219 108.112   0.701  1.00 26.58           C  
ATOM   1483  N   LEU    32      23.570 111.652  -3.218  1.00 21.85           N  
ATOM   1484  CA  LEU    32      24.410 110.665  -3.908  1.00 22.79           C  
ATOM   1485  C   LEU    32      25.228 111.350  -5.001  1.00 25.24           C  
ATOM   1486  O   LEU    32      26.412 111.029  -5.216  1.00 27.20           O  
ATOM   1487  CB  LEU    32      23.551 109.584  -4.553  1.00 22.61           C  
ATOM   1488  CG  LEU    32      24.006 108.123  -4.413  1.00 24.51           C  
ATOM   1489  CD1 LEU    32      23.323 107.306  -5.521  1.00 25.19           C  
ATOM   1490  CD2 LEU    32      25.502 108.009  -4.517  1.00 18.89           C  
ATOM   1491  N   ALA    33      24.593 112.295  -5.691  1.00 20.92           N  
ATOM   1492  CA  ALA    33      25.267 113.028  -6.752  1.00 18.99           C  
ATOM   1493  C   ALA    33      26.503 113.726  -6.198  1.00 19.03           C  
ATOM   1494  O   ALA    33      27.575 113.721  -6.808  1.00 19.88           O  
ATOM   1495  CB  ALA    33      24.319 114.046  -7.354  1.00 20.93           C  
ATOM   1496  N   GLN    34      26.339 114.333  -5.034  1.00 15.61           N  
ATOM   1497  CA  GLN    34      27.427 115.030  -4.391  1.00 20.42           C  
ATOM   1498  C   GLN    34      28.514 114.044  -3.967  1.00 25.20           C  
ATOM   1499  O   GLN    34      29.701 114.323  -4.130  1.00 28.30           O  
ATOM   1500  CB  GLN    34      26.902 115.770  -3.183  1.00 20.00           C  
ATOM   1501  CG  GLN    34      27.732 116.943  -2.810  1.00 23.76           C  
ATOM   1502  CD  GLN    34      27.113 117.695  -1.689  1.00 25.03           C  
ATOM   1503  OE1 GLN    34      25.914 117.965  -1.712  1.00 27.84           O  
ATOM   1504  NE2 GLN    34      27.915 118.043  -0.686  1.00 25.01           N  
ATOM   1505  N   GLU    35      28.110 112.897  -3.418  1.00 26.05           N  
ATOM   1506  CA  GLU    35      29.062 111.870  -3.000  1.00 26.79           C  
ATOM   1507  C   GLU    35      29.880 111.409  -4.199  1.00 25.76           C  
ATOM   1508  O   GLU    35      31.100 111.373  -4.133  1.00 29.58           O  
ATOM   1509  CB  GLU    35      28.334 110.656  -2.403  1.00 29.07           C  
ATOM   1510  CG  GLU    35      27.663 110.859  -1.026  1.00 36.40           C  
ATOM   1511  CD  GLU    35      28.639 110.840   0.162  1.00 37.35           C  
ATOM   1512  OE1 GLU    35      29.592 110.019   0.147  1.00 43.71           O  
ATOM   1513  OE2 GLU    35      28.432 111.628   1.113  1.00 32.55           O  
ATOM   1514  N   LEU    36      29.208 111.060  -5.295  1.00 26.54           N  
ATOM   1515  CA  LEU    36      29.903 110.588  -6.490  1.00 26.53           C  
ATOM   1516  C   LEU    36      30.739 111.666  -7.179  1.00 28.82           C  
ATOM   1517  O   LEU    36      31.847 111.390  -7.651  1.00 31.06           O  
ATOM   1518  CB  LEU    36      28.903 110.000  -7.492  1.00 23.33           C  
ATOM   1519  CG  LEU    36      28.105 108.784  -7.009  1.00 21.17           C  
ATOM   1520  CD1 LEU    36      27.061 108.392  -8.037  1.00 17.04           C  
ATOM   1521  CD2 LEU    36      29.055 107.639  -6.741  1.00 15.12           C  
ATOM   1522  N   LEU    37      30.226 112.892  -7.233  1.00 28.20           N  
ATOM   1523  CA  LEU    37      30.951 113.965  -7.903  1.00 26.01           C  
ATOM   1524  C   LEU    37      32.174 114.388  -7.145  1.00 27.22           C  
ATOM   1525  O   LEU    37      33.140 114.872  -7.723  1.00 35.05           O  
ATOM   1526  CB  LEU    37      30.037 115.164  -8.129  1.00 22.95           C  
ATOM   1527  CG  LEU    37      29.266 115.054  -9.444  1.00 25.96           C  
ATOM   1528  CD1 LEU    37      28.166 116.104  -9.505  1.00 26.27           C  
ATOM   1529  CD2 LEU    37      30.239 115.215 -10.598  1.00 23.53           C  
ATOM   1530  N   THR    38      32.145 114.208  -5.839  1.00 30.01           N  
ATOM   1531  CA  THR    38      33.278 114.604  -5.031  1.00 29.62           C  
ATOM   1532  C   THR    38      34.364 113.523  -5.108  1.00 31.54           C  
ATOM   1533  O   THR    38      35.555 113.819  -5.059  1.00 32.59           O  
ATOM   1534  CB  THR    38      32.815 114.860  -3.582  1.00 28.57           C  
ATOM   1535  OG1 THR    38      33.935 115.191  -2.766  1.00 35.34           O  
ATOM   1536  CG2 THR    38      32.128 113.640  -3.015  1.00 33.85           C  
ATOM   1537  N   THR    39      33.956 112.269  -5.273  1.00 32.57           N  
ATOM   1538  CA  THR    39      34.921 111.183  -5.366  1.00 34.34           C  
ATOM   1539  C   THR    39      35.467 110.987  -6.789  1.00 36.96           C  
ATOM   1540  O   THR    39      36.640 110.662  -6.964  1.00 37.38           O  
ATOM   1541  CB  THR    39      34.297 109.864  -4.860  1.00 32.96           C  
ATOM   1542  OG1 THR    39      34.062 109.962  -3.448  1.00 33.25           O  
ATOM   1543  CG2 THR    39      35.223 108.689  -5.130  1.00 31.22           C  
ATOM   1544  N   PHE    40      34.629 111.219  -7.798  1.00 38.57           N  
ATOM   1545  CA  PHE    40      35.027 111.035  -9.193  1.00 37.31           C  
ATOM   1546  C   PHE    40      34.988 112.301 -10.047  1.00 41.01           C  
ATOM   1547  O   PHE    40      34.757 112.234 -11.260  1.00 41.00           O  
ATOM   1548  CB  PHE    40      34.125 109.981  -9.832  1.00 31.99           C  
ATOM   1549  CG  PHE    40      34.123 108.678  -9.107  1.00 28.82           C  
ATOM   1550  CD1 PHE    40      33.048 108.312  -8.313  1.00 30.11           C  
ATOM   1551  CD2 PHE    40      35.207 107.812  -9.218  1.00 29.42           C  
ATOM   1552  CE1 PHE    40      33.043 107.088  -7.632  1.00 31.64           C  
ATOM   1553  CE2 PHE    40      35.224 106.590  -8.552  1.00 28.90           C  
ATOM   1554  CZ  PHE    40      34.136 106.225  -7.755  1.00 31.86           C  
ATOM   1555  N   GLU    41      35.225 113.450  -9.421  1.00 45.20           N  
ATOM   1556  CA  GLU    41      35.182 114.735 -10.121  1.00 48.64           C  
ATOM   1557  C   GLU    41      36.149 114.795 -11.292  1.00 49.01           C  
ATOM   1558  O   GLU    41      35.863 115.413 -12.316  1.00 50.22           O  
ATOM   1559  CB  GLU    41      35.511 115.869  -9.150  1.00 52.34           C  
ATOM   1560  CG  GLU    41      36.906 115.767  -8.535  1.00 59.42           C  
ATOM   1561  CD  GLU    41      37.721 117.041  -8.730  1.00 62.86           C  
ATOM   1562  OE1 GLU    41      37.987 117.406  -9.897  1.00 67.41           O  
ATOM   1563  OE2 GLU    41      38.091 117.680  -7.720  1.00 62.22           O  
ATOM   1564  N   THR    42      37.296 114.147 -11.132  1.00 49.32           N  
ATOM   1565  CA  THR    42      38.323 114.141 -12.162  1.00 47.61           C  
ATOM   1566  C   THR    42      38.082 113.124 -13.296  1.00 45.33           C  
ATOM   1567  O   THR    42      38.704 113.205 -14.353  1.00 42.19           O  
ATOM   1568  CB  THR    42      39.717 113.917 -11.511  1.00 48.23           C  
ATOM   1569  OG1 THR    42      40.556 113.159 -12.394  1.00 51.39           O  
ATOM   1570  CG2 THR    42      39.571 113.193 -10.172  1.00 45.58           C  
ATOM   1571  N   GLU    43      37.163 112.187 -13.092  1.00 44.51           N  
ATOM   1572  CA  GLU    43      36.878 111.187 -14.111  1.00 41.57           C  
ATOM   1573  C   GLU    43      35.505 111.365 -14.752  1.00 41.52           C  
ATOM   1574  O   GLU    43      35.196 110.736 -15.766  1.00 44.39           O  
ATOM   1575  CB  GLU    43      36.978 109.774 -13.522  1.00 43.81           C  
ATOM   1576  CG  GLU    43      38.375 109.344 -13.093  1.00 53.78           C  
ATOM   1577  CD  GLU    43      38.797 109.903 -11.741  1.00 59.81           C  
ATOM   1578  OE1 GLU    43      39.949 109.648 -11.322  1.00 66.31           O  
ATOM   1579  OE2 GLU    43      37.982 110.588 -11.090  1.00 67.02           O  
ATOM   1580  N   LEU    44      34.673 112.220 -14.170  1.00 40.18           N  
ATOM   1581  CA  LEU    44      33.338 112.435 -14.719  1.00 37.50           C  
ATOM   1582  C   LEU    44      33.211 113.728 -15.512  1.00 37.96           C  
ATOM   1583  O   LEU    44      33.648 114.791 -15.063  1.00 40.45           O  
ATOM   1584  CB  LEU    44      32.297 112.438 -13.597  1.00 32.21           C  
ATOM   1585  CG  LEU    44      32.195 111.167 -12.766  1.00 27.84           C  
ATOM   1586  CD1 LEU    44      31.086 111.322 -11.751  1.00 26.62           C  
ATOM   1587  CD2 LEU    44      31.923 109.984 -13.679  1.00 30.90           C  
ATOM   1588  N   THR    45      32.611 113.621 -16.693  1.00 34.19           N  
ATOM   1589  CA  THR    45      32.384 114.771 -17.547  1.00 35.13           C  
ATOM   1590  C   THR    45      31.163 115.510 -16.998  1.00 34.08           C  
ATOM   1591  O   THR    45      31.064 116.733 -17.089  1.00 34.71           O  
ATOM   1592  CB  THR    45      32.115 114.349 -19.022  1.00 39.29           C  
ATOM   1593  OG1 THR    45      31.728 115.504 -19.780  1.00 42.07           O  
ATOM   1594  CG2 THR    45      31.009 113.302 -19.103  1.00 38.35           C  
ATOM   1595  N   GLU    46      30.231 114.745 -16.441  1.00 31.19           N  
ATOM   1596  CA  GLU    46      29.034 115.294 -15.824  1.00 36.59           C  
ATOM   1597  C   GLU    46      28.180 114.201 -15.196  1.00 35.80           C  
ATOM   1598  O   GLU    46      28.302 113.023 -15.539  1.00 34.74           O  
ATOM   1599  CB  GLU    46      28.188 116.098 -16.812  1.00 38.03           C  
ATOM   1600  CG  GLU    46      27.534 115.289 -17.895  1.00 48.23           C  
ATOM   1601  CD  GLU    46      26.618 116.141 -18.781  1.00 55.98           C  
ATOM   1602  OE1 GLU    46      27.057 117.229 -19.251  1.00 56.19           O  
ATOM   1603  OE2 GLU    46      25.460 115.710 -19.017  1.00 58.15           O  
ATOM   1604  N   LEU    47      27.333 114.605 -14.255  1.00 32.79           N  
ATOM   1605  CA  LEU    47      26.453 113.685 -13.564  1.00 25.19           C  
ATOM   1606  C   LEU    47      25.065 114.278 -13.677  1.00 24.20           C  
ATOM   1607  O   LEU    47      24.845 115.431 -13.315  1.00 27.81           O  
ATOM   1608  CB  LEU    47      26.876 113.559 -12.108  1.00 23.89           C  
ATOM   1609  CG  LEU    47      26.095 112.525 -11.313  1.00 18.31           C  
ATOM   1610  CD1 LEU    47      26.939 112.062 -10.138  1.00 19.78           C  
ATOM   1611  CD2 LEU    47      24.775 113.124 -10.866  1.00 16.98           C  
ATOM   1612  N   ALA    48      24.126 113.504 -14.198  1.00 22.62           N  
ATOM   1613  CA  ALA    48      22.771 114.015 -14.376  1.00 21.56           C  
ATOM   1614  C   ALA    48      21.717 113.392 -13.464  1.00 20.92           C  
ATOM   1615  O   ALA    48      21.806 112.222 -13.091  1.00 20.60           O  
ATOM   1616  CB  ALA    48      22.353 113.848 -15.836  1.00 14.97           C  
ATOM   1617  N   LEU    49      20.717 114.189 -13.104  1.00 20.06           N  
ATOM   1618  CA  LEU    49      19.621 113.702 -12.277  1.00 21.13           C  
ATOM   1619  C   LEU    49      18.387 113.657 -13.176  1.00 21.86           C  
ATOM   1620  O   LEU    49      17.997 114.671 -13.733  1.00 22.90           O  
ATOM   1621  CB  LEU    49      19.382 114.643 -11.084  1.00 17.94           C  
ATOM   1622  CG  LEU    49      20.515 114.711 -10.047  1.00 17.37           C  
ATOM   1623  CD1 LEU    49      20.426 115.992  -9.265  1.00 17.78           C  
ATOM   1624  CD2 LEU    49      20.453 113.519  -9.121  1.00 14.96           C  
ATOM   1625  N   LYS    50      17.803 112.477 -13.357  1.00 23.96           N  
ATOM   1626  CA  LYS    50      16.609 112.342 -14.183  1.00 24.56           C  
ATOM   1627  C   LYS    50      15.385 111.979 -13.356  1.00 24.08           C  
ATOM   1628  O   LYS    50      15.334 110.907 -12.746  1.00 29.13           O  
ATOM   1629  CB  LYS    50      16.805 111.260 -15.258  1.00 29.60           C  
ATOM   1630  CG  LYS    50      15.518 110.961 -16.062  1.00 38.16           C  
ATOM   1631  CD  LYS    50      15.671 109.851 -17.108  1.00 40.68           C  
ATOM   1632  CE  LYS    50      16.610 110.257 -18.251  1.00 51.82           C  
ATOM   1633  NZ  LYS    50      16.093 111.355 -19.139  1.00 48.44           N  
ATOM   1634  N   PRO    51      14.382 112.859 -13.325  1.00 22.59           N  
ATOM   1635  CA  PRO    51      13.176 112.554 -12.552  1.00 25.38           C  
ATOM   1636  C   PRO    51      12.553 111.288 -13.105  1.00 27.86           C  
ATOM   1637  O   PRO    51      12.436 111.141 -14.319  1.00 27.06           O  
ATOM   1638  CB  PRO    51      12.292 113.773 -12.794  1.00 27.38           C  
ATOM   1639  CG  PRO    51      13.281 114.886 -12.956  1.00 26.85           C  
ATOM   1640  CD  PRO    51      14.356 114.244 -13.825  1.00 23.65           C  
ATOM   1641  N   GLY    52      12.153 110.383 -12.216  1.00 32.91           N  
ATOM   1642  CA  GLY    52      11.559 109.127 -12.640  1.00 36.98           C  
ATOM   1643  C   GLY    52      10.123 108.903 -12.202  1.00 40.80           C  
ATOM   1644  O   GLY    52       9.546 109.714 -11.481  1.00 37.38           O  
ATOM   1645  N   THR    53       9.563 107.772 -12.632  1.00 48.76           N  
ATOM   1646  CA  THR    53       8.180 107.396 -12.341  1.00 52.36           C  
ATOM   1647  C   THR    53       7.897 107.011 -10.892  1.00 54.71           C  
ATOM   1648  O   THR    53       7.858 107.868 -10.003  1.00 60.21           O  
ATOM   1649  CB  THR    53       7.735 106.216 -13.217  1.00 56.86           C  
ATOM   1650  OG1 THR    53       8.252 106.378 -14.543  1.00 60.67           O  
ATOM   1651  CG2 THR    53       6.212 106.147 -13.273  1.00 58.18           C  
ATOM   1652  N   GLY    54       7.693 105.715 -10.664  1.00 47.98           N  
ATOM   1653  CA  GLY    54       7.372 105.247  -9.331  1.00 46.90           C  
ATOM   1654  C   GLY    54       8.318 104.226  -8.740  1.00 45.07           C  
ATOM   1655  O   GLY    54       8.611 103.199  -9.351  1.00 43.29           O  
ATOM   1656  N   GLY    55       8.793 104.522  -7.533  1.00 41.52           N  
ATOM   1657  CA  GLY    55       9.700 103.632  -6.839  1.00 36.31           C  
ATOM   1658  C   GLY    55      11.041 103.449  -7.516  1.00 32.35           C  
ATOM   1659  O   GLY    55      11.884 102.685  -7.053  1.00 34.97           O  
ATOM   1660  N   VAL    56      11.249 104.154  -8.611  1.00 28.59           N  
ATOM   1661  CA  VAL    56      12.494 104.043  -9.350  1.00 29.28           C  
ATOM   1662  C   VAL    56      13.697 104.764  -8.741  1.00 30.33           C  
ATOM   1663  O   VAL    56      13.624 105.938  -8.368  1.00 32.26           O  
ATOM   1664  CB  VAL    56      12.321 104.578 -10.786  1.00 30.24           C  
ATOM   1665  CG1 VAL    56      13.637 104.494 -11.543  1.00 15.34           C  
ATOM   1666  CG2 VAL    56      11.242 103.762 -11.508  1.00 40.19           C  
ATOM   1667  N   PHE    57      14.812 104.057  -8.638  1.00 26.67           N  
ATOM   1668  CA  PHE    57      16.029 104.677  -8.151  1.00 23.98           C  
ATOM   1669  C   PHE    57      17.193 103.910  -8.712  1.00 19.33           C  
ATOM   1670  O   PHE    57      17.634 102.940  -8.120  1.00 22.04           O  
ATOM   1671  CB  PHE    57      16.124 104.686  -6.624  1.00 26.86           C  
ATOM   1672  CG  PHE    57      17.181 105.632  -6.109  1.00 25.63           C  
ATOM   1673  CD1 PHE    57      16.853 106.919  -5.727  1.00 21.45           C  
ATOM   1674  CD2 PHE    57      18.522 105.278  -6.132  1.00 26.35           C  
ATOM   1675  CE1 PHE    57      17.838 107.832  -5.389  1.00 22.63           C  
ATOM   1676  CE2 PHE    57      19.513 106.203  -5.790  1.00 25.01           C  
ATOM   1677  CZ  PHE    57      19.162 107.472  -5.424  1.00 21.00           C  
ATOM   1678  N   VAL    58      17.701 104.340  -9.854  1.00 16.87           N  
ATOM   1679  CA  VAL    58      18.811 103.619 -10.449  1.00 16.50           C  
ATOM   1680  C   VAL    58      19.990 104.509 -10.803  1.00 14.74           C  
ATOM   1681  O   VAL    58      19.833 105.682 -11.099  1.00 19.25           O  
ATOM   1682  CB  VAL    58      18.336 102.803 -11.703  1.00 17.29           C  
ATOM   1683  CG1 VAL    58      17.143 103.480 -12.358  1.00 13.35           C  
ATOM   1684  CG2 VAL    58      19.480 102.662 -12.707  1.00 10.59           C  
ATOM   1685  N   VAL    59      21.181 103.944 -10.737  1.00 17.11           N  
ATOM   1686  CA  VAL    59      22.387 104.675 -11.069  1.00 14.59           C  
ATOM   1687  C   VAL    59      22.962 104.053 -12.337  1.00 18.14           C  
ATOM   1688  O   VAL    59      23.117 102.827 -12.434  1.00 18.37           O  
ATOM   1689  CB  VAL    59      23.442 104.565  -9.941  1.00 14.04           C  
ATOM   1690  CG1 VAL    59      24.705 105.319 -10.332  1.00 14.47           C  
ATOM   1691  CG2 VAL    59      22.881 105.116  -8.644  1.00 10.10           C  
ATOM   1692  N   ARG    60      23.275 104.900 -13.310  1.00 19.90           N  
ATOM   1693  CA  ARG    60      23.835 104.443 -14.582  1.00 22.68           C  
ATOM   1694  C   ARG    60      25.212 105.039 -14.826  1.00 26.21           C  
ATOM   1695  O   ARG    60      25.455 106.193 -14.495  1.00 30.19           O  
ATOM   1696  CB  ARG    60      22.913 104.835 -15.737  1.00 17.23           C  
ATOM   1697  CG  ARG    60      22.086 103.684 -16.262  1.00 28.18           C  
ATOM   1698  CD  ARG    60      21.105 104.151 -17.308  1.00 28.75           C  
ATOM   1699  NE  ARG    60      19.884 104.634 -16.674  1.00 32.77           N  
ATOM   1700  CZ  ARG    60      18.712 104.017 -16.761  1.00 32.20           C  
ATOM   1701  NH1 ARG    60      18.598 102.897 -17.463  1.00 36.11           N  
ATOM   1702  NH2 ARG    60      17.660 104.509 -16.130  1.00 32.88           N  
ATOM   1703  N   VAL    61      26.131 104.249 -15.369  1.00 26.06           N  
ATOM   1704  CA  VAL    61      27.463 104.762 -15.688  1.00 27.01           C  
ATOM   1705  C   VAL    61      27.661 104.437 -17.173  1.00 29.36           C  
ATOM   1706  O   VAL    61      27.682 103.262 -17.563  1.00 24.96           O  
ATOM   1707  CB  VAL    61      28.585 104.089 -14.844  1.00 28.99           C  
ATOM   1708  CG1 VAL    61      29.954 104.665 -15.242  1.00 25.18           C  
ATOM   1709  CG2 VAL    61      28.341 104.307 -13.370  1.00 24.83           C  
ATOM   1710  N   ASP    62      27.775 105.482 -17.993  1.00 29.70           N  
ATOM   1711  CA  ASP    62      27.935 105.318 -19.434  1.00 37.02           C  
ATOM   1712  C   ASP    62      26.786 104.488 -20.032  1.00 41.12           C  
ATOM   1713  O   ASP    62      27.016 103.520 -20.764  1.00 43.88           O  
ATOM   1714  CB  ASP    62      29.282 104.654 -19.732  1.00 38.18           C  
ATOM   1715  CG  ASP    62      30.466 105.553 -19.381  1.00 43.43           C  
ATOM   1716  OD1 ASP    62      31.534 105.021 -19.002  1.00 47.13           O  
ATOM   1717  OD2 ASP    62      30.341 106.795 -19.495  1.00 40.93           O  
ATOM   1718  N   ASP    63      25.553 104.870 -19.698  1.00 43.52           N  
ATOM   1719  CA  ASP    63      24.352 104.194 -20.181  1.00 43.34           C  
ATOM   1720  C   ASP    63      24.123 102.807 -19.583  1.00 42.44           C  
ATOM   1721  O   ASP    63      23.064 102.212 -19.780  1.00 40.82           O  
ATOM   1722  CB  ASP    63      24.383 104.108 -21.708  1.00 49.03           C  
ATOM   1723  CG  ASP    63      24.078 105.449 -22.377  1.00 56.96           C  
ATOM   1724  OD1 ASP    63      22.893 105.855 -22.397  1.00 62.08           O  
ATOM   1725  OD2 ASP    63      25.022 106.101 -22.880  1.00 60.23           O  
ATOM   1726  N   GLU    64      25.103 102.294 -18.847  1.00 43.04           N  
ATOM   1727  CA  GLU    64      24.972 100.970 -18.237  1.00 43.09           C  
ATOM   1728  C   GLU    64      24.517 101.046 -16.793  1.00 35.79           C  
ATOM   1729  O   GLU    64      25.144 101.718 -15.986  1.00 42.15           O  
ATOM   1730  CB  GLU    64      26.305 100.217 -18.330  1.00 48.93           C  
ATOM   1731  CG  GLU    64      26.543  99.569 -19.696  1.00 61.84           C  
ATOM   1732  CD  GLU    64      27.974  99.069 -19.869  1.00 73.08           C  
ATOM   1733  OE1 GLU    64      28.485  98.402 -18.928  1.00 78.01           O  
ATOM   1734  OE2 GLU    64      28.582  99.339 -20.946  1.00 71.08           O  
ATOM   1735  N   VAL    65      23.421 100.369 -16.469  1.00 27.63           N  
ATOM   1736  CA  VAL    65      22.921 100.387 -15.100  1.00 25.77           C  
ATOM   1737  C   VAL    65      23.882  99.655 -14.142  1.00 28.28           C  
ATOM   1738  O   VAL    65      24.226  98.485 -14.338  1.00 20.36           O  
ATOM   1739  CB  VAL    65      21.505  99.762 -14.994  1.00 25.81           C  
ATOM   1740  CG1 VAL    65      21.468  98.433 -15.735  1.00 35.04           C  
ATOM   1741  CG2 VAL    65      21.140  99.546 -13.525  1.00 14.82           C  
ATOM   1742  N   VAL    66      24.313 100.375 -13.108  1.00 27.20           N  
ATOM   1743  CA  VAL    66      25.237  99.852 -12.122  1.00 23.67           C  
ATOM   1744  C   VAL    66      24.561  99.598 -10.779  1.00 24.73           C  
ATOM   1745  O   VAL    66      25.038  98.789  -9.979  1.00 25.71           O  
ATOM   1746  CB  VAL    66      26.408 100.821 -11.961  1.00 24.07           C  
ATOM   1747  CG1 VAL    66      27.305 100.416 -10.806  1.00 25.95           C  
ATOM   1748  CG2 VAL    66      27.204 100.836 -13.246  1.00 19.62           C  
ATOM   1749  N   TRP    67      23.444 100.270 -10.531  1.00 26.59           N  
ATOM   1750  CA  TRP    67      22.721 100.071  -9.283  1.00 24.40           C  
ATOM   1751  C   TRP    67      21.243 100.265  -9.473  1.00 20.86           C  
ATOM   1752  O   TRP    67      20.817 101.260 -10.040  1.00 23.33           O  
ATOM   1753  CB  TRP    67      23.213 101.041  -8.211  1.00 26.08           C  
ATOM   1754  CG  TRP    67      22.669 100.721  -6.859  1.00 24.39           C  
ATOM   1755  CD1 TRP    67      21.405 100.967  -6.396  1.00 24.24           C  
ATOM   1756  CD2 TRP    67      23.368 100.083  -5.793  1.00 22.69           C  
ATOM   1757  NE1 TRP    67      21.277 100.526  -5.103  1.00 19.54           N  
ATOM   1758  CE2 TRP    67      22.468  99.981  -4.706  1.00 21.17           C  
ATOM   1759  CE3 TRP    67      24.669  99.590  -5.646  1.00 19.66           C  
ATOM   1760  CZ2 TRP    67      22.830  99.411  -3.493  1.00 19.53           C  
ATOM   1761  CZ3 TRP    67      25.029  99.026  -4.447  1.00 17.34           C  
ATOM   1762  CH2 TRP    67      24.113  98.941  -3.380  1.00 22.91           C  
ATOM   1763  N   ASP    68      20.463  99.303  -9.005  1.00 20.11           N  
ATOM   1764  CA  ASP    68      19.012  99.388  -9.099  1.00 25.74           C  
ATOM   1765  C   ASP    68      18.429  99.124  -7.711  1.00 27.04           C  
ATOM   1766  O   ASP    68      18.701  98.089  -7.106  1.00 34.40           O  
ATOM   1767  CB  ASP    68      18.484  98.352 -10.089  1.00 29.43           C  
ATOM   1768  CG  ASP    68      16.993  98.503 -10.359  1.00 37.13           C  
ATOM   1769  OD1 ASP    68      16.222  98.766  -9.405  1.00 40.64           O  
ATOM   1770  OD2 ASP    68      16.588  98.348 -11.531  1.00 40.24           O  
ATOM   1771  N   ARG    69      17.623 100.053  -7.215  1.00 27.74           N  
ATOM   1772  CA  ARG    69      17.017  99.922  -5.890  1.00 30.14           C  
ATOM   1773  C   ARG    69      16.300  98.595  -5.624  1.00 31.56           C  
ATOM   1774  O   ARG    69      16.653  97.873  -4.692  1.00 26.37           O  
ATOM   1775  CB  ARG    69      16.025 101.054  -5.647  1.00 26.47           C  
ATOM   1776  CG  ARG    69      15.642 101.191  -4.201  1.00 31.13           C  
ATOM   1777  CD  ARG    69      14.402 102.044  -4.005  1.00 36.14           C  
ATOM   1778  NE  ARG    69      13.230 101.218  -3.775  1.00 38.88           N  
ATOM   1779  CZ  ARG    69      12.604 100.525  -4.719  1.00 43.61           C  
ATOM   1780  NH1 ARG    69      11.542  99.782  -4.414  1.00 47.81           N  
ATOM   1781  NH2 ARG    69      13.021 100.587  -5.974  1.00 44.92           N  
ATOM   1782  N   ARG    70      15.288  98.280  -6.430  1.00 33.52           N  
ATOM   1783  CA  ARG    70      14.543  97.048  -6.223  1.00 41.98           C  
ATOM   1784  C   ARG    70      15.303  95.813  -6.667  1.00 42.00           C  
ATOM   1785  O   ARG    70      14.736  94.867  -7.195  1.00 44.92           O  
ATOM   1786  CB  ARG    70      13.157  97.116  -6.893  1.00 44.21           C  
ATOM   1787  CG  ARG    70      13.138  97.606  -8.309  1.00 51.43           C  
ATOM   1788  CD  ARG    70      13.527  96.536  -9.295  1.00 57.29           C  
ATOM   1789  NE  ARG    70      13.537  97.075 -10.653  1.00 67.22           N  
ATOM   1790  CZ  ARG    70      13.974  96.418 -11.720  1.00 67.47           C  
ATOM   1791  NH1 ARG    70      14.442  95.180 -11.591  1.00 62.93           N  
ATOM   1792  NH2 ARG    70      13.949  97.009 -12.914  1.00 71.38           N  
ATOM   1793  N   GLU    71      16.600  95.821  -6.407  1.00 42.39           N  
ATOM   1794  CA  GLU    71      17.453  94.714  -6.768  1.00 40.69           C  
ATOM   1795  C   GLU    71      18.616  94.666  -5.787  1.00 38.69           C  
ATOM   1796  O   GLU    71      19.081  93.593  -5.414  1.00 35.90           O  
ATOM   1797  CB  GLU    71      17.964  94.923  -8.186  1.00 45.75           C  
ATOM   1798  CG  GLU    71      19.151  94.072  -8.557  1.00 58.77           C  
ATOM   1799  CD  GLU    71      18.834  93.060  -9.651  1.00 65.31           C  
ATOM   1800  OE1 GLU    71      19.789  92.437 -10.187  1.00 67.06           O  
ATOM   1801  OE2 GLU    71      17.632  92.893  -9.969  1.00 67.56           O  
ATOM   1802  N   GLN    72      19.063  95.834  -5.342  1.00 34.65           N  
ATOM   1803  CA  GLN    72      20.190  95.896  -4.425  1.00 32.47           C  
ATOM   1804  C   GLN    72      19.918  96.791  -3.242  1.00 32.08           C  
ATOM   1805  O   GLN    72      20.809  97.042  -2.437  1.00 34.82           O  
ATOM   1806  CB  GLN    72      21.424  96.388  -5.173  1.00 33.17           C  
ATOM   1807  CG  GLN    72      21.362  96.051  -6.643  1.00 34.18           C  
ATOM   1808  CD  GLN    72      22.530  96.578  -7.405  1.00 36.48           C  
ATOM   1809  OE1 GLN    72      22.390  96.999  -8.548  1.00 37.61           O  
ATOM   1810  NE2 GLN    72      23.704  96.553  -6.786  1.00 41.14           N  
ATOM   1811  N   GLY    73      18.685  97.272  -3.136  1.00 31.96           N  
ATOM   1812  CA  GLY    73      18.331  98.142  -2.026  1.00 26.30           C  
ATOM   1813  C   GLY    73      18.884  99.562  -2.071  1.00 24.64           C  
ATOM   1814  O   GLY    73      19.304 100.066  -3.116  1.00 26.56           O  
ATOM   1815  N   PHE    74      18.877 100.203  -0.908  1.00 22.82           N  
ATOM   1816  CA  PHE    74      19.343 101.569  -0.754  1.00 23.62           C  
ATOM   1817  C   PHE    74      20.782 101.741  -1.240  1.00 25.52           C  
ATOM   1818  O   PHE    74      21.653 100.929  -0.939  1.00 21.83           O  
ATOM   1819  CB  PHE    74      19.235 102.005   0.713  1.00 17.63           C  
ATOM   1820  CG  PHE    74      19.596 103.436   0.930  1.00 22.39           C  
ATOM   1821  CD1 PHE    74      18.677 104.447   0.655  1.00 24.11           C  
ATOM   1822  CD2 PHE    74      20.897 103.786   1.276  1.00 24.27           C  
ATOM   1823  CE1 PHE    74      19.056 105.790   0.710  1.00 27.45           C  
ATOM   1824  CE2 PHE    74      21.290 105.123   1.336  1.00 25.44           C  
ATOM   1825  CZ  PHE    74      20.372 106.129   1.050  1.00 26.59           C  
ATOM   1826  N   PRO    75      21.047 102.814  -2.001  1.00 26.42           N  
ATOM   1827  CA  PRO    75      22.402 103.037  -2.506  1.00 30.62           C  
ATOM   1828  C   PRO    75      23.438 103.468  -1.465  1.00 32.60           C  
ATOM   1829  O   PRO    75      23.824 104.634  -1.416  1.00 33.82           O  
ATOM   1830  CB  PRO    75      22.190 104.085  -3.601  1.00 26.01           C  
ATOM   1831  CG  PRO    75      21.066 104.898  -3.041  1.00 31.94           C  
ATOM   1832  CD  PRO    75      20.118 103.838  -2.512  1.00 25.71           C  
ATOM   1833  N   GLU    76      23.886 102.523  -0.640  1.00 32.70           N  
ATOM   1834  CA  GLU    76      24.907 102.809   0.372  1.00 34.65           C  
ATOM   1835  C   GLU    76      26.147 103.377  -0.351  1.00 36.38           C  
ATOM   1836  O   GLU    76      26.734 102.719  -1.222  1.00 32.20           O  
ATOM   1837  CB  GLU    76      25.261 101.525   1.134  1.00 37.11           C  
ATOM   1838  CG  GLU    76      26.053 101.738   2.419  1.00 46.96           C  
ATOM   1839  CD  GLU    76      27.573 101.674   2.227  1.00 54.03           C  
ATOM   1840  OE1 GLU    76      28.284 102.503   2.854  1.00 53.38           O  
ATOM   1841  OE2 GLU    76      28.053 100.790   1.469  1.00 54.08           O  
ATOM   1842  N   PRO    77      26.573 104.599   0.028  1.00 37.27           N  
ATOM   1843  CA  PRO    77      27.723 105.284  -0.573  1.00 36.67           C  
ATOM   1844  C   PRO    77      28.926 104.417  -0.966  1.00 38.30           C  
ATOM   1845  O   PRO    77      29.356 104.407  -2.125  1.00 39.25           O  
ATOM   1846  CB  PRO    77      28.064 106.354   0.465  1.00 30.87           C  
ATOM   1847  CG  PRO    77      27.585 105.757   1.733  1.00 35.87           C  
ATOM   1848  CD  PRO    77      26.259 105.198   1.335  1.00 36.78           C  
ATOM   1849  N   THR    78      29.472 103.688  -0.009  1.00 36.96           N  
ATOM   1850  CA  THR    78      30.627 102.849  -0.288  1.00 40.65           C  
ATOM   1851  C   THR    78      30.379 101.830  -1.396  1.00 40.53           C  
ATOM   1852  O   THR    78      31.098 101.800  -2.398  1.00 40.71           O  
ATOM   1853  CB  THR    78      31.053 102.111   0.984  1.00 43.25           C  
ATOM   1854  OG1 THR    78      31.328 103.076   2.011  1.00 49.41           O  
ATOM   1855  CG2 THR    78      32.296 101.276   0.729  1.00 40.87           C  
ATOM   1856  N   ALA    79      29.363 100.991  -1.197  1.00 39.05           N  
ATOM   1857  CA  ALA    79      28.989  99.958  -2.157  1.00 30.95           C  
ATOM   1858  C   ALA    79      28.860 100.524  -3.559  1.00 30.87           C  
ATOM   1859  O   ALA    79      29.476 100.021  -4.495  1.00 32.07           O  
ATOM   1860  CB  ALA    79      27.674  99.326  -1.744  1.00 30.22           C  
ATOM   1861  N   VAL    80      28.056 101.573  -3.701  1.00 29.83           N  
ATOM   1862  CA  VAL    80      27.845 102.176  -5.008  1.00 32.09           C  
ATOM   1863  C   VAL    80      29.089 102.872  -5.550  1.00 31.24           C  
ATOM   1864  O   VAL    80      29.303 102.901  -6.760  1.00 33.15           O  
ATOM   1865  CB  VAL    80      26.639 103.166  -5.004  1.00 30.11           C  
ATOM   1866  CG1 VAL    80      26.846 104.240  -3.969  1.00 33.03           C  
ATOM   1867  CG2 VAL    80      26.468 103.776  -6.381  1.00 27.36           C  
ATOM   1868  N   LYS    81      29.922 103.424  -4.675  1.00 31.39           N  
ATOM   1869  CA  LYS    81      31.128 104.082  -5.165  1.00 31.48           C  
ATOM   1870  C   LYS    81      32.096 103.060  -5.727  1.00 31.99           C  
ATOM   1871  O   LYS    81      32.828 103.339  -6.673  1.00 34.67           O  
ATOM   1872  CB  LYS    81      31.805 104.914  -4.064  1.00 26.53           C  
ATOM   1873  CG  LYS    81      31.266 106.332  -4.022  1.00 31.15           C  
ATOM   1874  CD  LYS    81      32.104 107.272  -3.195  1.00 34.88           C  
ATOM   1875  CE  LYS    81      31.706 107.256  -1.727  1.00 36.99           C  
ATOM   1876  NZ  LYS    81      32.451 108.286  -0.938  1.00 35.32           N  
ATOM   1877  N   ARG    82      32.084 101.862  -5.162  1.00 34.10           N  
ATOM   1878  CA  ARG    82      32.978 100.825  -5.632  1.00 36.80           C  
ATOM   1879  C   ARG    82      32.578 100.319  -6.998  1.00 34.53           C  
ATOM   1880  O   ARG    82      33.438 100.082  -7.844  1.00 35.29           O  
ATOM   1881  CB  ARG    82      33.023  99.677  -4.638  1.00 44.18           C  
ATOM   1882  CG  ARG    82      34.369  99.584  -3.988  1.00 51.62           C  
ATOM   1883  CD  ARG    82      34.177  99.776  -2.469  1.00 55.04           C  
ATOM   1884  NE  ARG    82      34.057  98.421  -2.176  1.00 59.29           N  
ATOM   1885  CZ  ARG    82      33.233  97.547  -1.649  1.00 61.20           C  
ATOM   1886  NH1 ARG    82      32.044  97.651  -1.063  1.00 59.66           N  
ATOM   1887  NH2 ARG    82      33.675  96.365  -2.009  1.00 60.79           N  
ATOM   1888  N   LEU    83      31.274 100.160  -7.208  1.00 30.67           N  
ATOM   1889  CA  LEU    83      30.756  99.692  -8.490  1.00 30.34           C  
ATOM   1890  C   LEU    83      30.966 100.737  -9.566  1.00 29.94           C  
ATOM   1891  O   LEU    83      31.124 100.399 -10.738  1.00 31.06           O  
ATOM   1892  CB  LEU    83      29.268  99.369  -8.390  1.00 29.27           C  
ATOM   1893  CG  LEU    83      28.906  97.975  -7.870  1.00 29.71           C  
ATOM   1894  CD1 LEU    83      29.519  97.735  -6.500  1.00 37.64           C  
ATOM   1895  CD2 LEU    83      27.400  97.861  -7.795  1.00 32.00           C  
ATOM   1896  N   VAL    84      30.954 102.007  -9.170  1.00 29.27           N  
ATOM   1897  CA  VAL    84      31.168 103.107 -10.114  1.00 28.41           C  
ATOM   1898  C   VAL    84      32.658 103.201 -10.473  1.00 30.57           C  
ATOM   1899  O   VAL    84      33.006 103.503 -11.611  1.00 26.17           O  
ATOM   1900  CB  VAL    84      30.692 104.474  -9.525  1.00 28.14           C  
ATOM   1901  CG1 VAL    84      31.179 105.626 -10.402  1.00 23.12           C  
ATOM   1902  CG2 VAL    84      29.166 104.505  -9.432  1.00 23.83           C  
ATOM   1903  N   ARG    85      33.531 102.939  -9.500  1.00 35.11           N  
ATOM   1904  CA  ARG    85      34.964 102.990  -9.738  1.00 37.04           C  
ATOM   1905  C   ARG    85      35.376 101.886 -10.717  1.00 36.72           C  
ATOM   1906  O   ARG    85      36.238 102.089 -11.569  1.00 31.75           O  
ATOM   1907  CB  ARG    85      35.739 102.839  -8.427  1.00 37.33           C  
ATOM   1908  CG  ARG    85      37.244 102.921  -8.635  1.00 45.43           C  
ATOM   1909  CD  ARG    85      38.040 102.134  -7.605  1.00 50.86           C  
ATOM   1910  NE  ARG    85      37.550 100.814  -7.382  1.00 53.15           N  
ATOM   1911  CZ  ARG    85      37.365 100.069  -6.298  1.00 51.12           C  
ATOM   1912  NH1 ARG    85      36.886  98.880  -6.578  1.00 52.18           N  
ATOM   1913  NH2 ARG    85      37.595 100.408  -5.032  1.00 45.28           N  
ATOM   1914  N   ASP    86      34.747 100.722 -10.610  1.00 40.19           N  
ATOM   1915  CA  ASP    86      35.064  99.612 -11.499  1.00 41.80           C  
ATOM   1916  C   ASP    86      34.682  99.903 -12.946  1.00 44.13           C  
ATOM   1917  O   ASP    86      35.159  99.222 -13.843  1.00 48.91           O  
ATOM   1918  CB  ASP    86      34.357  98.328 -11.045  1.00 44.39           C  
ATOM   1919  CG  ASP    86      34.920  97.758  -9.741  1.00 50.17           C  
ATOM   1920  OD1 ASP    86      34.380  96.720  -9.274  1.00 49.93           O  
ATOM   1921  OD2 ASP    86      35.893  98.333  -9.188  1.00 49.54           O  
ATOM   1922  N   ARG    87      33.824 100.897 -13.179  1.00 46.76           N  
ATOM   1923  CA  ARG    87      33.407 101.250 -14.540  1.00 45.11           C  
ATOM   1924  C   ARG    87      34.408 102.233 -15.120  1.00 45.90           C  
ATOM   1925  O   ARG    87      34.480 102.426 -16.326  1.00 46.61           O  
ATOM   1926  CB  ARG    87      32.032 101.918 -14.546  1.00 48.07           C  
ATOM   1927  CG  ARG    87      31.023 101.391 -13.534  1.00 56.36           C  
ATOM   1928  CD  ARG    87      30.757  99.933 -13.732  1.00 52.84           C  
ATOM   1929  NE  ARG    87      30.517  99.635 -15.134  1.00 58.50           N  
ATOM   1930  CZ  ARG    87      30.047  98.471 -15.562  1.00 63.85           C  
ATOM   1931  NH1 ARG    87      29.853  98.261 -16.861  1.00 61.62           N  
ATOM   1932  NH2 ARG    87      29.763  97.520 -14.675  1.00 63.63           N  
ATOM   1933  N   VAL    88      35.172 102.872 -14.247  1.00 48.48           N  
ATOM   1934  CA  VAL    88      36.171 103.831 -14.690  1.00 49.97           C  
ATOM   1935  C   VAL    88      37.566 103.462 -14.145  1.00 57.00           C  
ATOM   1936  O   VAL    88      38.133 104.262 -13.352  1.00 57.96           O  
ATOM   1937  CB  VAL    88      35.804 105.249 -14.225  1.00 46.27           C  
ATOM   1938  CG1 VAL    88      36.625 106.273 -15.003  1.00 39.40           C  
ATOM   1939  CG2 VAL    88      34.310 105.489 -14.396  1.00 38.65           C  
END
