
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  104 ( 1605),  selected  104 , name 2gzy_A
# Molecule2: number of CA atoms   77 (  633),  selected   77 , name T0458.pdb
# PARAMETERS: 2gzy_A.T0458.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      -       -           -
LGA    A     2_A      -       -           -
LGA    I     3_A      -       -           -
LGA    V     4_A      -       -           -
LGA    K     5_A      -       -           -
LGA    A     6_A      -       -           -
LGA    T     7_A      -       -           -
LGA    D     8_A      -       -           -
LGA    Q     9_A      -       -           -
LGA    S    10_A      -       -           -
LGA    F    11_A      -       -           -
LGA    S    12_A      -       -           -
LGA    A    13_A      -       -           -
LGA    E    14_A      -       -           -
LGA    T    15_A      -       -           -
LGA    S    16_A      -       -           -
LGA    E    17_A      -       -           -
LGA    G    18_A      T      12          2.681
LGA    V    19_A      H      13          1.540
LGA    V    20_A      R      14          0.993
LGA    L    21_A      V      15          1.076
LGA    A    22_A      Q      16          0.336
LGA    D    23_A      I      17          0.921
LGA    F    24_A      E      18          1.360
LGA    W    25_A      Y      19          2.236
LGA    A    26_A      C      20          3.948
LGA    P    27_A      T      21          3.442
LGA    W    28_A      Q      22          2.880
LGA    C    29_A      C      23          1.872
LGA    G    30_A      R      24          3.693
LGA    P    31_A      W      25          3.972
LGA    C    32_A      L      26          4.211
LGA    K    33_A      P      27          2.299
LGA    M    34_A      R      28          2.209
LGA    I    35_A      A      29          3.774
LGA    A    36_A      A      30          2.316
LGA    P    37_A      W      31          1.290
LGA    V    38_A      L      32          2.358
LGA    L    39_A      A      33          1.909
LGA    E    40_A      Q      34          0.391
LGA    E    41_A      E      35          1.383
LGA    L    42_A      L      36          1.095
LGA    D    43_A      L      37          0.824
LGA    Q    44_A      T      38          1.169
LGA    E    45_A      T      39          1.402
LGA    M    46_A      F      40          0.699
LGA    G    47_A      E      41          2.413
LGA    D    48_A      T      42          2.929
LGA    K    49_A      E      43          0.592
LGA    L    50_A      L      44          1.524
LGA    K    51_A      T      45          3.699
LGA    -       -      E      46           -
LGA    I    52_A      L      47          0.943
LGA    V    53_A      A      48          0.856
LGA    K    54_A      L      49          1.073
LGA    I    55_A      K      50          1.601
LGA    D    56_A      P      51          1.991
LGA    V    57_A      G      52          3.110
LGA    D    58_A      -       -           -
LGA    E    59_A      -       -           -
LGA    N    60_A      -       -           -
LGA    Q    61_A      -       -           -
LGA    E    62_A      -       -           -
LGA    T    63_A      -       -           -
LGA    A    64_A      -       -           -
LGA    G    65_A      -       -           -
LGA    K    66_A      -       -           -
LGA    Y    67_A      -       -           -
LGA    G    68_A      -       -           -
LGA    V    69_A      -       -           -
LGA    M    70_A      T      53          4.826
LGA    S    71_A      G      54          4.325
LGA    -       -      G      55           -
LGA    I    72_A      V      56          1.745
LGA    P    73_A      F      57          1.622
LGA    T    74_A      V      58          1.757
LGA    L    75_A      V      59          1.497
LGA    L    76_A      R      60          1.417
LGA    V    77_A      V      61          1.500
LGA    L    78_A      D      62          1.040
LGA    K    79_A      -       -           -
LGA    D    80_A      -       -           -
LGA    G    81_A      -       -           -
LGA    E    82_A      -       -           -
LGA    V    83_A      D      63          2.345
LGA    V    84_A      E      64          2.711
LGA    E    85_A      V      65          2.705
LGA    T    86_A      V      66          3.935
LGA    S    87_A      W      67          2.177
LGA    V    88_A      D      68          1.950
LGA    G    89_A      R      69          2.374
LGA    -       -      R      70           -
LGA    -       -      E      71           -
LGA    -       -      Q      72           -
LGA    -       -      G      73           -
LGA    F    90_A      F      74          2.977
LGA    K    91_A      P      75          0.671
LGA    P    92_A      E      76          1.381
LGA    K    93_A      P      77          1.125
LGA    E    94_A      T      78          0.514
LGA    A    95_A      A      79          0.877
LGA    L    96_A      V      80          1.478
LGA    Q    97_A      K      81          0.989
LGA    E    98_A      R      82          0.310
LGA    L    99_A      L      83          0.933
LGA    V   100_A      V      84          0.792
LGA    N   101_A      R      85          0.564
LGA    K   102_A      D      86          0.408
LGA    H   103_A      R      87          0.485
LGA    L   104_A      V      88          0.447

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  104   77    5.0     71    2.16    14.08     73.010     3.141

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.460516 * X  +   0.773906 * Y  +   0.434735 * Z  +  32.895912
  Y_new =   0.650647 * X  +  -0.627451 * Y  +   0.427743 * Z  + 117.761375
  Z_new =   0.603808 * X  +   0.085877 * Y  +  -0.792491 * Z  + -12.270514 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   3.033651   -0.107942  [ DEG:   173.8154     -6.1846 ]
  Theta =  -0.648269   -2.493323  [ DEG:   -37.1431   -142.8569 ]
  Phi   =   0.954866   -2.186726  [ DEG:    54.7098   -125.2902 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2gzy_A                                        
REMARK     2: T0458.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2gzy_A.T0458.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  104   77   5.0   71   2.16   14.08  73.010
REMARK  ---------------------------------------------------------- 
MOLECULE 2gzy_A
HEADER    ELECTRON TRANSPORT                      12-MAY-06   2GZY              
TITLE     SOLUTION STRUCTURES OF THE REDUCED FORM OF THIOREDOXIN FROM           
TITLE    2 BACILLUS SUBTILIS                                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: THIOREDOXIN;                                               
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: TRX;                                                        
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS SUBTILIS;                              
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET21A                                    
KEYWDS    ALPHA/BETA                                                            
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    H.XU,X.ZHANG,J.CHEN,C.JIN                                             
REVDAT   1   13-FEB-07 2GZY    0                                                
JRNL        AUTH   H.XU                                                         
JRNL        TITL   THE SOLUTION STRUCTURE OF BACILLUS SUBTILIS                  
JRNL        TITL 2 THIOREDOXIN IN THE REDUCED AND OXIDIZED FORMS                
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2GZY A    1   104  UNP    P14949   THIO_BACSU       0    103             
SEQRES   1 A  104  MET ALA ILE VAL LYS ALA THR ASP GLN SER PHE SER ALA          
SEQRES   2 A  104  GLU THR SER GLU GLY VAL VAL LEU ALA ASP PHE TRP ALA          
SEQRES   3 A  104  PRO TRP CYS GLY PRO CYS LYS MET ILE ALA PRO VAL LEU          
SEQRES   4 A  104  GLU GLU LEU ASP GLN GLU MET GLY ASP LYS LEU LYS ILE          
SEQRES   5 A  104  VAL LYS ILE ASP VAL ASP GLU ASN GLN GLU THR ALA GLY          
SEQRES   6 A  104  LYS TYR GLY VAL MET SER ILE PRO THR LEU LEU VAL LEU          
SEQRES   7 A  104  LYS ASP GLY GLU VAL VAL GLU THR SER VAL GLY PHE LYS          
SEQRES   8 A  104  PRO LYS GLU ALA LEU GLN GLU LEU VAL ASN LYS HIS LEU          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1      32.666 118.143  -9.384  0.00  0.00           N  
ATOM      2  CA  MET A   1      32.663 119.547  -9.851  0.00  0.00           C  
ATOM      3  C   MET A   1      31.267 120.140  -9.657  0.00  0.00           C  
ATOM      4  O   MET A   1      31.057 120.893  -8.701  0.00  0.00           O  
ATOM      5  CB  MET A   1      33.170 119.701 -11.300  0.00  0.00           C  
ATOM      6  CG  MET A   1      34.680 119.459 -11.431  0.00  0.00           C  
ATOM      7  SD  MET A   1      35.723 120.571 -10.445  0.00  0.00           S  
ATOM      8  CE  MET A   1      37.357 119.920 -10.893  0.00  0.00           C  
ATOM      9  H2  MET A   1      31.882 117.639  -9.785  0.00  0.00           H  
ATOM     10  HA  MET A   1      33.342 120.113  -9.212  0.00  0.00           H  
ATOM     11  HB2 MET A   1      32.640 119.011 -11.960  0.00  0.00           H  
ATOM     12  HB3 MET A   1      32.965 120.717 -11.640  0.00  0.00           H  
ATOM     13  HG2 MET A   1      34.909 118.434 -11.145  0.00  0.00           H  
ATOM     14  HG3 MET A   1      34.953 119.576 -12.481  0.00  0.00           H  
ATOM     15  HE1 MET A   1      38.130 120.492 -10.380  0.00  0.00           H  
ATOM     16  HE2 MET A   1      37.431 118.873 -10.597  0.00  0.00           H  
ATOM     17  HE3 MET A   1      37.504 120.003 -11.970  0.00  0.00           H  
ATOM     18  H1  MET A   1      32.556 118.109  -8.381  0.00  0.00           H  
ATOM     19  H3  MET A   1      33.519 117.672  -9.645  0.00  0.00           H  
ATOM     20  N   ALA A   2      30.315 119.826 -10.544  0.00  0.00           N  
ATOM     21  CA  ALA A   2      28.898 120.117 -10.390  0.00  0.00           C  
ATOM     22  C   ALA A   2      28.130 119.080 -11.206  0.00  0.00           C  
ATOM     23  O   ALA A   2      28.577 118.669 -12.282  0.00  0.00           O  
ATOM     24  CB  ALA A   2      28.571 121.528 -10.895  0.00  0.00           C  
ATOM     25  H   ALA A   2      30.528 119.205 -11.318  0.00  0.00           H  
ATOM     26  HA  ALA A   2      28.614 120.026  -9.337  0.00  0.00           H  
ATOM     27  HB1 ALA A   2      27.499 121.704 -10.799  0.00  0.00           H  
ATOM     28  HB2 ALA A   2      29.106 122.272 -10.304  0.00  0.00           H  
ATOM     29  HB3 ALA A   2      28.854 121.625 -11.944  0.00  0.00           H  
ATOM     30  N   ILE A   3      26.973 118.666 -10.693  0.00  0.00           N  
ATOM     31  CA  ILE A   3      26.108 117.686 -11.333  0.00  0.00           C  
ATOM     32  C   ILE A   3      25.356 118.394 -12.470  0.00  0.00           C  
ATOM     33  O   ILE A   3      25.022 119.579 -12.375  0.00  0.00           O  
ATOM     34  CB  ILE A   3      25.196 117.066 -10.247  0.00  0.00           C  
ATOM     35  CG1 ILE A   3      26.084 116.321  -9.218  0.00  0.00           C  
ATOM     36  CG2 ILE A   3      24.142 116.124 -10.850  0.00  0.00           C  
ATOM     37  CD1 ILE A   3      25.337 115.759  -8.010  0.00  0.00           C  
ATOM     38  H   ILE A   3      26.652 119.062  -9.820  0.00  0.00           H  
ATOM     39  HA  ILE A   3      26.729 116.894 -11.767  0.00  0.00           H  
ATOM     40  HB  ILE A   3      24.671 117.871  -9.731  0.00  0.00           H  
ATOM     41 HG12 ILE A   3      26.608 115.507  -9.715  0.00  0.00           H  
ATOM     42 HG13 ILE A   3      26.836 117.000  -8.819  0.00  0.00           H  
ATOM     43 HG21 ILE A   3      23.556 115.645 -10.067  0.00  0.00           H  
ATOM     44 HG22 ILE A   3      23.449 116.688 -11.472  0.00  0.00           H  
ATOM     45 HG23 ILE A   3      24.624 115.361 -11.457  0.00  0.00           H  
ATOM     46 HD11 ILE A   3      24.739 116.552  -7.560  0.00  0.00           H  
ATOM     47 HD12 ILE A   3      24.707 114.923  -8.309  0.00  0.00           H  
ATOM     48 HD13 ILE A   3      26.064 115.403  -7.284  0.00  0.00           H  
ATOM     49  N   VAL A   4      25.082 117.656 -13.542  0.00  0.00           N  
ATOM     50  CA  VAL A   4      24.486 118.144 -14.783  0.00  0.00           C  
ATOM     51  C   VAL A   4      22.994 117.776 -14.767  0.00  0.00           C  
ATOM     52  O   VAL A   4      22.551 116.975 -13.942  0.00  0.00           O  
ATOM     53  CB  VAL A   4      25.278 117.541 -15.974  0.00  0.00           C  
ATOM     54  CG1 VAL A   4      24.849 118.077 -17.350  0.00  0.00           C  
ATOM     55  CG2 VAL A   4      26.791 117.806 -15.834  0.00  0.00           C  
ATOM     56  H   VAL A   4      25.310 116.664 -13.520  0.00  0.00           H  
ATOM     57  HA  VAL A   4      24.580 119.231 -14.823  0.00  0.00           H  
ATOM     58  HB  VAL A   4      25.121 116.466 -15.974  0.00  0.00           H  
ATOM     59 HG11 VAL A   4      23.844 117.742 -17.598  0.00  0.00           H  
ATOM     60 HG12 VAL A   4      24.894 119.168 -17.363  0.00  0.00           H  
ATOM     61 HG13 VAL A   4      25.512 117.689 -18.124  0.00  0.00           H  
ATOM     62 HG21 VAL A   4      26.976 118.873 -15.715  0.00  0.00           H  
ATOM     63 HG22 VAL A   4      27.198 117.272 -14.975  0.00  0.00           H  
ATOM     64 HG23 VAL A   4      27.319 117.453 -16.719  0.00  0.00           H  
ATOM     65  N   LYS A   5      22.197 118.365 -15.659  0.00  0.00           N  
ATOM     66  CA  LYS A   5      20.770 118.088 -15.821  0.00  0.00           C  
ATOM     67  C   LYS A   5      20.539 117.844 -17.309  0.00  0.00           C  
ATOM     68  O   LYS A   5      21.149 118.537 -18.127  0.00  0.00           O  
ATOM     69  CB  LYS A   5      19.908 119.279 -15.347  0.00  0.00           C  
ATOM     70  CG  LYS A   5      19.663 119.358 -13.829  0.00  0.00           C  
ATOM     71  CD  LYS A   5      20.408 120.474 -13.077  0.00  0.00           C  
ATOM     72  CE  LYS A   5      21.918 120.217 -13.019  0.00  0.00           C  
ATOM     73  NZ  LYS A   5      22.644 121.171 -12.144  0.00  0.00           N  
ATOM     74  H   LYS A   5      22.615 118.945 -16.377  0.00  0.00           H  
ATOM     75  HA  LYS A   5      20.492 117.189 -15.268  0.00  0.00           H  
ATOM     76  HB2 LYS A   5      20.325 120.216 -15.718  0.00  0.00           H  
ATOM     77  HB3 LYS A   5      18.926 119.169 -15.814  0.00  0.00           H  
ATOM     78  HG2 LYS A   5      18.595 119.528 -13.680  0.00  0.00           H  
ATOM     79  HG3 LYS A   5      19.897 118.402 -13.371  0.00  0.00           H  
ATOM     80  HD2 LYS A   5      20.211 121.434 -13.559  0.00  0.00           H  
ATOM     81  HD3 LYS A   5      20.015 120.512 -12.060  0.00  0.00           H  
ATOM     82  HE2 LYS A   5      22.081 119.201 -12.649  0.00  0.00           H  
ATOM     83  HE3 LYS A   5      22.320 120.286 -14.030  0.00  0.00           H  
ATOM     84  HZ1 LYS A   5      23.629 120.912 -12.108  0.00  0.00           H  
ATOM     85  HZ2 LYS A   5      22.578 122.117 -12.490  0.00  0.00           H  
ATOM     86  HZ3 LYS A   5      22.288 121.152 -11.199  0.00  0.00           H  
ATOM     87  N   ALA A   6      19.675 116.892 -17.663  0.00  0.00           N  
ATOM     88  CA  ALA A   6      19.320 116.618 -19.053  0.00  0.00           C  
ATOM     89  C   ALA A   6      17.905 116.044 -19.170  0.00  0.00           C  
ATOM     90  O   ALA A   6      17.310 115.620 -18.178  0.00  0.00           O  
ATOM     91  CB  ALA A   6      20.332 115.637 -19.658  0.00  0.00           C  
ATOM     92  H   ALA A   6      19.212 116.339 -16.947  0.00  0.00           H  
ATOM     93  HA  ALA A   6      19.356 117.552 -19.614  0.00  0.00           H  
ATOM     94  HB1 ALA A   6      20.254 114.681 -19.143  0.00  0.00           H  
ATOM     95  HB2 ALA A   6      20.118 115.492 -20.717  0.00  0.00           H  
ATOM     96  HB3 ALA A   6      21.344 116.028 -19.558  0.00  0.00           H  
ATOM     97  N   THR A   7      17.406 115.995 -20.405  0.00  0.00           N  
ATOM     98  CA  THR A   7      16.137 115.402 -20.817  0.00  0.00           C  
ATOM     99  C   THR A   7      16.381 114.694 -22.163  0.00  0.00           C  
ATOM    100  O   THR A   7      17.512 114.705 -22.659  0.00  0.00           O  
ATOM    101  CB  THR A   7      15.057 116.504 -20.907  0.00  0.00           C  
ATOM    102  OG1 THR A   7      15.479 117.569 -21.736  0.00  0.00           O  
ATOM    103  CG2 THR A   7      14.698 117.106 -19.546  0.00  0.00           C  
ATOM    104  H   THR A   7      17.967 116.333 -21.174  0.00  0.00           H  
ATOM    105  HA  THR A   7      15.826 114.655 -20.086  0.00  0.00           H  
ATOM    106  HB  THR A   7      14.148 116.071 -21.325  0.00  0.00           H  
ATOM    107  HG1 THR A   7      14.906 117.533 -22.527  0.00  0.00           H  
ATOM    108 HG21 THR A   7      15.543 117.665 -19.144  0.00  0.00           H  
ATOM    109 HG22 THR A   7      13.852 117.782 -19.666  0.00  0.00           H  
ATOM    110 HG23 THR A   7      14.423 116.313 -18.851  0.00  0.00           H  
ATOM    111  N   ASP A   8      15.346 114.126 -22.794  0.00  0.00           N  
ATOM    112  CA  ASP A   8      15.432 113.432 -24.092  0.00  0.00           C  
ATOM    113  C   ASP A   8      16.178 114.238 -25.160  0.00  0.00           C  
ATOM    114  O   ASP A   8      16.862 113.681 -26.019  0.00  0.00           O  
ATOM    115  CB  ASP A   8      14.016 113.160 -24.623  0.00  0.00           C  
ATOM    116  CG  ASP A   8      14.064 112.198 -25.820  0.00  0.00           C  
ATOM    117  OD1 ASP A   8      14.335 110.996 -25.603  0.00  0.00           O  
ATOM    118  OD2 ASP A   8      13.803 112.636 -26.964  0.00  0.00           O  
ATOM    119  H   ASP A   8      14.433 114.152 -22.362  0.00  0.00           H  
ATOM    120  HA  ASP A   8      15.947 112.478 -23.958  0.00  0.00           H  
ATOM    121  HB2 ASP A   8      13.392 112.736 -23.835  0.00  0.00           H  
ATOM    122  HB3 ASP A   8      13.552 114.105 -24.915  0.00  0.00           H  
ATOM    123  N   GLN A   9      16.048 115.564 -25.079  0.00  0.00           N  
ATOM    124  CA  GLN A   9      16.614 116.539 -25.992  0.00  0.00           C  
ATOM    125  C   GLN A   9      18.148 116.486 -26.031  0.00  0.00           C  
ATOM    126  O   GLN A   9      18.722 116.730 -27.095  0.00  0.00           O  
ATOM    127  CB  GLN A   9      16.133 117.943 -25.575  0.00  0.00           C  
ATOM    128  CG  GLN A   9      14.643 118.210 -25.874  0.00  0.00           C  
ATOM    129  CD  GLN A   9      13.669 117.373 -25.036  0.00  0.00           C  
ATOM    130  OE1 GLN A   9      13.909 117.103 -23.863  0.00  0.00           O  
ATOM    131  NE2 GLN A   9      12.574 116.908 -25.614  0.00  0.00           N  
ATOM    132  H   GLN A   9      15.468 115.924 -24.329  0.00  0.00           H  
ATOM    133  HA  GLN A   9      16.253 116.320 -26.994  0.00  0.00           H  
ATOM    134  HB2 GLN A   9      16.331 118.096 -24.511  0.00  0.00           H  
ATOM    135  HB3 GLN A   9      16.715 118.682 -26.128  0.00  0.00           H  
ATOM    136  HG2 GLN A   9      14.432 119.264 -25.683  0.00  0.00           H  
ATOM    137  HG3 GLN A   9      14.464 118.029 -26.935  0.00  0.00           H  
ATOM    138 HE21 GLN A   9      12.377 117.117 -26.584  0.00  0.00           H  
ATOM    139 HE22 GLN A   9      11.932 116.333 -25.088  0.00  0.00           H  
ATOM    140  N   SER A  10      18.805 116.158 -24.910  0.00  0.00           N  
ATOM    141  CA  SER A  10      20.261 116.300 -24.790  0.00  0.00           C  
ATOM    142  C   SER A  10      20.955 115.210 -23.972  0.00  0.00           C  
ATOM    143  O   SER A  10      22.185 115.170 -23.972  0.00  0.00           O  
ATOM    144  CB  SER A  10      20.599 117.680 -24.197  0.00  0.00           C  
ATOM    145  OG  SER A  10      19.920 118.736 -24.864  0.00  0.00           O  
ATOM    146  H   SER A  10      18.262 115.952 -24.078  0.00  0.00           H  
ATOM    147  HA  SER A  10      20.701 116.220 -25.783  0.00  0.00           H  
ATOM    148  HB2 SER A  10      20.319 117.692 -23.142  0.00  0.00           H  
ATOM    149  HB3 SER A  10      21.677 117.843 -24.266  0.00  0.00           H  
ATOM    150  HG  SER A  10      20.191 119.576 -24.449  0.00  0.00           H  
ATOM    151  N   PHE A  11      20.225 114.301 -23.322  0.00  0.00           N  
ATOM    152  CA  PHE A  11      20.828 113.215 -22.552  0.00  0.00           C  
ATOM    153  C   PHE A  11      21.782 112.395 -23.419  0.00  0.00           C  
ATOM    154  O   PHE A  11      22.843 111.982 -22.946  0.00  0.00           O  
ATOM    155  CB  PHE A  11      19.723 112.331 -21.960  0.00  0.00           C  
ATOM    156  CG  PHE A  11      20.220 111.230 -21.037  0.00  0.00           C  
ATOM    157  CD1 PHE A  11      20.806 111.566 -19.801  0.00  0.00           C  
ATOM    158  CD2 PHE A  11      20.072 109.874 -21.387  0.00  0.00           C  
ATOM    159  CE1 PHE A  11      21.217 110.561 -18.912  0.00  0.00           C  
ATOM    160  CE2 PHE A  11      20.493 108.867 -20.501  0.00  0.00           C  
ATOM    161  CZ  PHE A  11      21.055 109.209 -19.259  0.00  0.00           C  
ATOM    162  H   PHE A  11      19.211 114.364 -23.333  0.00  0.00           H  
ATOM    163  HA  PHE A  11      21.404 113.653 -21.737  0.00  0.00           H  
ATOM    164  HB2 PHE A  11      19.045 112.962 -21.388  0.00  0.00           H  
ATOM    165  HB3 PHE A  11      19.148 111.886 -22.775  0.00  0.00           H  
ATOM    166  HD1 PHE A  11      20.928 112.600 -19.523  0.00  0.00           H  
ATOM    167  HD2 PHE A  11      19.632 109.597 -22.336  0.00  0.00           H  
ATOM    168  HE1 PHE A  11      21.655 110.832 -17.962  0.00  0.00           H  
ATOM    169  HE2 PHE A  11      20.381 107.827 -20.770  0.00  0.00           H  
ATOM    170  HZ  PHE A  11      21.370 108.431 -18.578  0.00  0.00           H  
ATOM    171  N   SER A  12      21.452 112.206 -24.698  0.00  0.00           N  
ATOM    172  CA  SER A  12      22.266 111.411 -25.602  0.00  0.00           C  
ATOM    173  C   SER A  12      23.595 112.101 -25.900  0.00  0.00           C  
ATOM    174  O   SER A  12      24.632 111.442 -25.948  0.00  0.00           O  
ATOM    175  CB  SER A  12      21.480 111.131 -26.891  0.00  0.00           C  
ATOM    176  OG  SER A  12      20.162 110.690 -26.593  0.00  0.00           O  
ATOM    177  H   SER A  12      20.587 112.583 -25.058  0.00  0.00           H  
ATOM    178  HA  SER A  12      22.489 110.474 -25.104  0.00  0.00           H  
ATOM    179  HB2 SER A  12      21.422 112.045 -27.485  0.00  0.00           H  
ATOM    180  HB3 SER A  12      22.003 110.369 -27.470  0.00  0.00           H  
ATOM    181  HG  SER A  12      19.709 110.516 -27.436  0.00  0.00           H  
ATOM    182  N   ALA A  13      23.587 113.427 -26.058  0.00  0.00           N  
ATOM    183  CA  ALA A  13      24.803 114.198 -26.251  0.00  0.00           C  
ATOM    184  C   ALA A  13      25.646 114.143 -24.977  0.00  0.00           C  
ATOM    185  O   ALA A  13      26.847 113.886 -25.039  0.00  0.00           O  
ATOM    186  CB  ALA A  13      24.459 115.645 -26.620  0.00  0.00           C  
ATOM    187  H   ALA A  13      22.722 113.927 -25.943  0.00  0.00           H  
ATOM    188  HA  ALA A  13      25.361 113.752 -27.070  0.00  0.00           H  
ATOM    189  HB1 ALA A  13      23.868 115.663 -27.538  0.00  0.00           H  
ATOM    190  HB2 ALA A  13      23.896 116.123 -25.817  0.00  0.00           H  
ATOM    191  HB3 ALA A  13      25.381 116.205 -26.784  0.00  0.00           H  
ATOM    192  N   GLU A  14      25.014 114.350 -23.818  0.00  0.00           N  
ATOM    193  CA  GLU A  14      25.707 114.430 -22.540  0.00  0.00           C  
ATOM    194  C   GLU A  14      26.381 113.106 -22.191  0.00  0.00           C  
ATOM    195  O   GLU A  14      27.502 113.114 -21.683  0.00  0.00           O  
ATOM    196  CB  GLU A  14      24.732 114.840 -21.424  0.00  0.00           C  
ATOM    197  CG  GLU A  14      24.336 116.320 -21.517  0.00  0.00           C  
ATOM    198  CD  GLU A  14      25.491 117.309 -21.259  0.00  0.00           C  
ATOM    199  OE1 GLU A  14      26.559 116.902 -20.748  0.00  0.00           O  
ATOM    200  OE2 GLU A  14      25.331 118.510 -21.577  0.00  0.00           O  
ATOM    201  H   GLU A  14      24.016 114.539 -23.829  0.00  0.00           H  
ATOM    202  HA  GLU A  14      26.489 115.181 -22.631  0.00  0.00           H  
ATOM    203  HB2 GLU A  14      23.833 114.225 -21.486  0.00  0.00           H  
ATOM    204  HB3 GLU A  14      25.189 114.658 -20.450  0.00  0.00           H  
ATOM    205  HG2 GLU A  14      23.928 116.499 -22.513  0.00  0.00           H  
ATOM    206  HG3 GLU A  14      23.546 116.503 -20.788  0.00  0.00           H  
ATOM    207  N   THR A  15      25.737 111.977 -22.488  0.00  0.00           N  
ATOM    208  CA  THR A  15      26.260 110.659 -22.159  0.00  0.00           C  
ATOM    209  C   THR A  15      27.342 110.186 -23.144  0.00  0.00           C  
ATOM    210  O   THR A  15      27.894 109.098 -22.959  0.00  0.00           O  
ATOM    211  CB  THR A  15      25.097 109.669 -21.991  0.00  0.00           C  
ATOM    212  OG1 THR A  15      24.204 109.693 -23.084  0.00  0.00           O  
ATOM    213  CG2 THR A  15      24.309 109.980 -20.710  0.00  0.00           C  
ATOM    214  H   THR A  15      24.815 112.016 -22.905  0.00  0.00           H  
ATOM    215  HA  THR A  15      26.740 110.742 -21.192  0.00  0.00           H  
ATOM    216  HB  THR A  15      25.506 108.661 -21.899  0.00  0.00           H  
ATOM    217  HG1 THR A  15      23.661 110.500 -23.002  0.00  0.00           H  
ATOM    218 HG21 THR A  15      23.980 111.021 -20.682  0.00  0.00           H  
ATOM    219 HG22 THR A  15      23.434 109.334 -20.655  0.00  0.00           H  
ATOM    220 HG23 THR A  15      24.934 109.794 -19.838  0.00  0.00           H  
ATOM    221  N   SER A  16      27.694 110.997 -24.151  0.00  0.00           N  
ATOM    222  CA  SER A  16      28.569 110.604 -25.254  0.00  0.00           C  
ATOM    223  C   SER A  16      29.912 111.340 -25.213  0.00  0.00           C  
ATOM    224  O   SER A  16      30.493 111.632 -26.260  0.00  0.00           O  
ATOM    225  CB  SER A  16      27.834 110.774 -26.593  0.00  0.00           C  
ATOM    226  OG  SER A  16      26.681 109.961 -26.650  0.00  0.00           O  
ATOM    227  H   SER A  16      27.262 111.915 -24.210  0.00  0.00           H  
ATOM    228  HA  SER A  16      28.812 109.553 -25.143  0.00  0.00           H  
ATOM    229  HB2 SER A  16      27.553 111.818 -26.731  0.00  0.00           H  
ATOM    230  HB3 SER A  16      28.501 110.479 -27.404  0.00  0.00           H  
ATOM    231  HG  SER A  16      25.929 110.503 -26.330  0.00  0.00           H  
ATOM    232  N   GLU A  17      30.413 111.644 -24.010  0.00  0.00           N  
ATOM    233  CA  GLU A  17      31.652 112.412 -23.842  0.00  0.00           C  
ATOM    234  C   GLU A  17      32.640 111.797 -22.844  0.00  0.00           C  
ATOM    235  O   GLU A  17      33.737 112.336 -22.671  0.00  0.00           O  
ATOM    236  CB  GLU A  17      31.324 113.857 -23.424  0.00  0.00           C  
ATOM    237  CG  GLU A  17      30.437 114.620 -24.418  0.00  0.00           C  
ATOM    238  CD  GLU A  17      30.303 116.104 -24.030  0.00  0.00           C  
ATOM    239  OE1 GLU A  17      30.027 116.401 -22.845  0.00  0.00           O  
ATOM    240  OE2 GLU A  17      30.471 116.981 -24.908  0.00  0.00           O  
ATOM    241  H   GLU A  17      29.858 111.434 -23.192  0.00  0.00           H  
ATOM    242  HA  GLU A  17      32.178 112.427 -24.795  0.00  0.00           H  
ATOM    243  HB2 GLU A  17      30.829 113.833 -22.452  0.00  0.00           H  
ATOM    244  HB3 GLU A  17      32.257 114.412 -23.320  0.00  0.00           H  
ATOM    245  HG2 GLU A  17      30.875 114.538 -25.416  0.00  0.00           H  
ATOM    246  HG3 GLU A  17      29.447 114.167 -24.437  0.00  0.00           H  
ATOM    247  N   GLY A  18      32.295 110.694 -22.178  0.00  0.00           N  
ATOM    248  CA  GLY A  18      33.121 110.160 -21.107  0.00  0.00           C  
ATOM    249  C   GLY A  18      32.374 109.104 -20.320  0.00  0.00           C  
ATOM    250  O   GLY A  18      31.380 108.560 -20.803  0.00  0.00           O  
ATOM    251  H   GLY A  18      31.414 110.230 -22.359  0.00  0.00           H  
ATOM    252  HA2 GLY A  18      34.024 109.715 -21.524  0.00  0.00           H  
ATOM    253  HA3 GLY A  18      33.383 110.977 -20.431  0.00  0.00           H  
ATOM    254  N   VAL A  19      32.863 108.803 -19.119  0.00  0.00           N  
ATOM    255  CA  VAL A  19      32.121 108.008 -18.152  0.00  0.00           C  
ATOM    256  C   VAL A  19      31.034 108.935 -17.607  0.00  0.00           C  
ATOM    257  O   VAL A  19      31.342 110.041 -17.150  0.00  0.00           O  
ATOM    258  CB  VAL A  19      33.059 107.519 -17.028  0.00  0.00           C  
ATOM    259  CG1 VAL A  19      32.301 106.584 -16.079  0.00  0.00           C  
ATOM    260  CG2 VAL A  19      34.276 106.749 -17.557  0.00  0.00           C  
ATOM    261  H   VAL A  19      33.673 109.300 -18.778  0.00  0.00           H  
ATOM    262  HA  VAL A  19      31.664 107.155 -18.655  0.00  0.00           H  
ATOM    263  HB  VAL A  19      33.426 108.377 -16.466  0.00  0.00           H  
ATOM    264 HG11 VAL A  19      32.965 106.280 -15.271  0.00  0.00           H  
ATOM    265 HG12 VAL A  19      31.442 107.095 -15.644  0.00  0.00           H  
ATOM    266 HG13 VAL A  19      31.948 105.704 -16.621  0.00  0.00           H  
ATOM    267 HG21 VAL A  19      33.937 105.860 -18.082  0.00  0.00           H  
ATOM    268 HG22 VAL A  19      34.868 107.369 -18.230  0.00  0.00           H  
ATOM    269 HG23 VAL A  19      34.915 106.450 -16.726  0.00  0.00           H  
ATOM    270  N   VAL A  20      29.776 108.504 -17.636  0.00  0.00           N  
ATOM    271  CA  VAL A  20      28.648 109.323 -17.233  0.00  0.00           C  
ATOM    272  C   VAL A  20      27.712 108.457 -16.399  0.00  0.00           C  
ATOM    273  O   VAL A  20      27.143 107.484 -16.893  0.00  0.00           O  
ATOM    274  CB  VAL A  20      27.952 109.946 -18.464  0.00  0.00           C  
ATOM    275  CG1 VAL A  20      26.879 110.935 -17.995  0.00  0.00           C  
ATOM    276  CG2 VAL A  20      28.945 110.671 -19.392  0.00  0.00           C  
ATOM    277  H   VAL A  20      29.558 107.587 -18.021  0.00  0.00           H  
ATOM    278  HA  VAL A  20      29.012 110.138 -16.608  0.00  0.00           H  
ATOM    279  HB  VAL A  20      27.466 109.162 -19.046  0.00  0.00           H  
ATOM    280 HG11 VAL A  20      26.435 111.450 -18.848  0.00  0.00           H  
ATOM    281 HG12 VAL A  20      26.087 110.406 -17.462  0.00  0.00           H  
ATOM    282 HG13 VAL A  20      27.314 111.666 -17.316  0.00  0.00           H  
ATOM    283 HG21 VAL A  20      28.432 111.342 -20.072  0.00  0.00           H  
ATOM    284 HG22 VAL A  20      29.665 111.249 -18.819  0.00  0.00           H  
ATOM    285 HG23 VAL A  20      29.477 109.932 -19.988  0.00  0.00           H  
ATOM    286  N   LEU A  21      27.565 108.802 -15.123  0.00  0.00           N  
ATOM    287  CA  LEU A  21      26.536 108.233 -14.269  0.00  0.00           C  
ATOM    288  C   LEU A  21      25.302 109.110 -14.456  0.00  0.00           C  
ATOM    289  O   LEU A  21      25.411 110.319 -14.666  0.00  0.00           O  
ATOM    290  CB  LEU A  21      27.045 108.177 -12.818  0.00  0.00           C  
ATOM    291  CG  LEU A  21      26.044 107.558 -11.819  0.00  0.00           C  
ATOM    292  CD1 LEU A  21      26.780 106.731 -10.760  0.00  0.00           C  
ATOM    293  CD2 LEU A  21      25.228 108.635 -11.094  0.00  0.00           C  
ATOM    294  H   LEU A  21      27.987 109.671 -14.810  0.00  0.00           H  
ATOM    295  HA  LEU A  21      26.311 107.218 -14.593  0.00  0.00           H  
ATOM    296  HB2 LEU A  21      27.937 107.550 -12.831  0.00  0.00           H  
ATOM    297  HB3 LEU A  21      27.339 109.173 -12.481  0.00  0.00           H  
ATOM    298  HG  LEU A  21      25.363 106.892 -12.344  0.00  0.00           H  
ATOM    299 HD11 LEU A  21      26.061 106.296 -10.067  0.00  0.00           H  
ATOM    300 HD12 LEU A  21      27.325 105.918 -11.240  0.00  0.00           H  
ATOM    301 HD13 LEU A  21      27.484 107.357 -10.208  0.00  0.00           H  
ATOM    302 HD21 LEU A  21      24.671 109.245 -11.802  0.00  0.00           H  
ATOM    303 HD22 LEU A  21      24.515 108.158 -10.422  0.00  0.00           H  
ATOM    304 HD23 LEU A  21      25.891 109.273 -10.510  0.00  0.00           H  
ATOM    305  N   ALA A  22      24.120 108.517 -14.374  0.00  0.00           N  
ATOM    306  CA  ALA A  22      22.858 109.221 -14.485  0.00  0.00           C  
ATOM    307  C   ALA A  22      21.962 108.764 -13.346  0.00  0.00           C  
ATOM    308  O   ALA A  22      22.095 107.638 -12.866  0.00  0.00           O  
ATOM    309  CB  ALA A  22      22.228 108.926 -15.847  0.00  0.00           C  
ATOM    310  H   ALA A  22      24.074 107.524 -14.165  0.00  0.00           H  
ATOM    311  HA  ALA A  22      23.026 110.295 -14.398  0.00  0.00           H  
ATOM    312  HB1 ALA A  22      22.059 107.854 -15.953  0.00  0.00           H  
ATOM    313  HB2 ALA A  22      21.274 109.449 -15.928  0.00  0.00           H  
ATOM    314  HB3 ALA A  22      22.896 109.263 -16.639  0.00  0.00           H  
ATOM    315  N   ASP A  23      21.037 109.626 -12.944  0.00  0.00           N  
ATOM    316  CA  ASP A  23      20.106 109.395 -11.850  0.00  0.00           C  
ATOM    317  C   ASP A  23      18.724 109.790 -12.352  0.00  0.00           C  
ATOM    318  O   ASP A  23      18.395 110.978 -12.468  0.00  0.00           O  
ATOM    319  CB  ASP A  23      20.516 110.185 -10.606  0.00  0.00           C  
ATOM    320  CG  ASP A  23      19.438 110.135  -9.510  0.00  0.00           C  
ATOM    321  OD1 ASP A  23      18.794 109.077  -9.330  0.00  0.00           O  
ATOM    322  OD2 ASP A  23      19.278 111.156  -8.804  0.00  0.00           O  
ATOM    323  H   ASP A  23      20.990 110.534 -13.399  0.00  0.00           H  
ATOM    324  HA  ASP A  23      20.096 108.337 -11.579  0.00  0.00           H  
ATOM    325  HB2 ASP A  23      21.449 109.775 -10.216  0.00  0.00           H  
ATOM    326  HB3 ASP A  23      20.704 111.218 -10.894  0.00  0.00           H  
ATOM    327  N   PHE A  24      17.973 108.765 -12.751  0.00  0.00           N  
ATOM    328  CA  PHE A  24      16.585 108.844 -13.145  0.00  0.00           C  
ATOM    329  C   PHE A  24      15.797 108.973 -11.845  0.00  0.00           C  
ATOM    330  O   PHE A  24      15.784 108.033 -11.040  0.00  0.00           O  
ATOM    331  CB  PHE A  24      16.185 107.602 -13.962  0.00  0.00           C  
ATOM    332  CG  PHE A  24      16.831 107.529 -15.339  0.00  0.00           C  
ATOM    333  CD1 PHE A  24      18.210 107.262 -15.476  0.00  0.00           C  
ATOM    334  CD2 PHE A  24      16.057 107.760 -16.493  0.00  0.00           C  
ATOM    335  CE1 PHE A  24      18.809 107.272 -16.747  0.00  0.00           C  
ATOM    336  CE2 PHE A  24      16.656 107.737 -17.764  0.00  0.00           C  
ATOM    337  CZ  PHE A  24      18.034 107.506 -17.892  0.00  0.00           C  
ATOM    338  H   PHE A  24      18.321 107.829 -12.574  0.00  0.00           H  
ATOM    339  HA  PHE A  24      16.439 109.718 -13.766  0.00  0.00           H  
ATOM    340  HB2 PHE A  24      16.434 106.702 -13.407  0.00  0.00           H  
ATOM    341  HB3 PHE A  24      15.102 107.610 -14.081  0.00  0.00           H  
ATOM    342  HD1 PHE A  24      18.819 107.064 -14.606  0.00  0.00           H  
ATOM    343  HD2 PHE A  24      15.000 107.961 -16.408  0.00  0.00           H  
ATOM    344  HE1 PHE A  24      19.868 107.108 -16.850  0.00  0.00           H  
ATOM    345  HE2 PHE A  24      16.065 107.920 -18.648  0.00  0.00           H  
ATOM    346  HZ  PHE A  24      18.496 107.514 -18.868  0.00  0.00           H  
ATOM    347  N   TRP A  25      15.176 110.134 -11.628  0.00  0.00           N  
ATOM    348  CA  TRP A  25      14.588 110.497 -10.342  0.00  0.00           C  
ATOM    349  C   TRP A  25      13.241 111.203 -10.508  0.00  0.00           C  
ATOM    350  O   TRP A  25      12.818 111.498 -11.629  0.00  0.00           O  
ATOM    351  CB  TRP A  25      15.583 111.367  -9.554  0.00  0.00           C  
ATOM    352  CG  TRP A  25      15.677 112.810  -9.958  0.00  0.00           C  
ATOM    353  CD1 TRP A  25      16.194 113.268 -11.117  0.00  0.00           C  
ATOM    354  CD2 TRP A  25      15.251 113.998  -9.221  0.00  0.00           C  
ATOM    355  NE1 TRP A  25      16.080 114.640 -11.176  0.00  0.00           N  
ATOM    356  CE2 TRP A  25      15.526 115.150 -10.021  0.00  0.00           C  
ATOM    357  CE3 TRP A  25      14.672 114.225  -7.953  0.00  0.00           C  
ATOM    358  CZ2 TRP A  25      15.242 116.453  -9.586  0.00  0.00           C  
ATOM    359  CZ3 TRP A  25      14.392 115.531  -7.503  0.00  0.00           C  
ATOM    360  CH2 TRP A  25      14.670 116.643  -8.318  0.00  0.00           C  
ATOM    361  H   TRP A  25      15.208 110.852 -12.349  0.00  0.00           H  
ATOM    362  HA  TRP A  25      14.425 109.592  -9.762  0.00  0.00           H  
ATOM    363  HB2 TRP A  25      15.287 111.344  -8.509  0.00  0.00           H  
ATOM    364  HB3 TRP A  25      16.574 110.919  -9.610  0.00  0.00           H  
ATOM    365  HD1 TRP A  25      16.615 112.640 -11.889  0.00  0.00           H  
ATOM    366  HE1 TRP A  25      16.368 115.185 -11.980  0.00  0.00           H  
ATOM    367  HE3 TRP A  25      14.451 113.387  -7.311  0.00  0.00           H  
ATOM    368  HZ2 TRP A  25      15.471 117.302 -10.216  0.00  0.00           H  
ATOM    369  HZ3 TRP A  25      13.970 115.684  -6.520  0.00  0.00           H  
ATOM    370  HH2 TRP A  25      14.445 117.643  -7.968  0.00  0.00           H  
ATOM    371  N   ALA A  26      12.576 111.476  -9.380  0.00  0.00           N  
ATOM    372  CA  ALA A  26      11.402 112.334  -9.282  0.00  0.00           C  
ATOM    373  C   ALA A  26      11.362 112.902  -7.853  0.00  0.00           C  
ATOM    374  O   ALA A  26      11.766 112.201  -6.921  0.00  0.00           O  
ATOM    375  CB  ALA A  26      10.132 111.530  -9.576  0.00  0.00           C  
ATOM    376  H   ALA A  26      12.970 111.188  -8.491  0.00  0.00           H  
ATOM    377  HA  ALA A  26      11.498 113.142 -10.009  0.00  0.00           H  
ATOM    378  HB1 ALA A  26       9.992 110.760  -8.817  0.00  0.00           H  
ATOM    379  HB2 ALA A  26       9.275 112.202  -9.571  0.00  0.00           H  
ATOM    380  HB3 ALA A  26      10.202 111.066 -10.559  0.00  0.00           H  
ATOM    381  N   PRO A  27      10.866 114.133  -7.639  0.00  0.00           N  
ATOM    382  CA  PRO A  27      10.983 114.822  -6.355  0.00  0.00           C  
ATOM    383  C   PRO A  27      10.014 114.293  -5.294  0.00  0.00           C  
ATOM    384  O   PRO A  27      10.249 114.486  -4.100  0.00  0.00           O  
ATOM    385  CB  PRO A  27      10.709 116.296  -6.670  0.00  0.00           C  
ATOM    386  CG  PRO A  27       9.766 116.234  -7.870  0.00  0.00           C  
ATOM    387  CD  PRO A  27      10.254 115.001  -8.631  0.00  0.00           C  
ATOM    388  HA  PRO A  27      11.996 114.715  -5.969  0.00  0.00           H  
ATOM    389  HB2 PRO A  27      10.260 116.826  -5.828  0.00  0.00           H  
ATOM    390  HB3 PRO A  27      11.640 116.783  -6.966  0.00  0.00           H  
ATOM    391  HG2 PRO A  27       8.743 116.074  -7.528  0.00  0.00           H  
ATOM    392  HG3 PRO A  27       9.832 117.135  -8.481  0.00  0.00           H  
ATOM    393  HD2 PRO A  27       9.416 114.501  -9.119  0.00  0.00           H  
ATOM    394  HD3 PRO A  27      11.006 115.298  -9.360  0.00  0.00           H  
ATOM    395  N   TRP A  28       8.931 113.619  -5.695  0.00  0.00           N  
ATOM    396  CA  TRP A  28       7.968 113.044  -4.765  0.00  0.00           C  
ATOM    397  C   TRP A  28       8.469 111.721  -4.164  0.00  0.00           C  
ATOM    398  O   TRP A  28       7.838 111.194  -3.247  0.00  0.00           O  
ATOM    399  CB  TRP A  28       6.608 112.902  -5.470  0.00  0.00           C  
ATOM    400  CG  TRP A  28       6.584 112.329  -6.862  0.00  0.00           C  
ATOM    401  CD1 TRP A  28       7.304 111.275  -7.311  0.00  0.00           C  
ATOM    402  CD2 TRP A  28       5.784 112.767  -8.006  0.00  0.00           C  
ATOM    403  NE1 TRP A  28       6.984 111.013  -8.626  0.00  0.00           N  
ATOM    404  CE2 TRP A  28       6.067 111.914  -9.116  0.00  0.00           C  
ATOM    405  CE3 TRP A  28       4.851 113.805  -8.223  0.00  0.00           C  
ATOM    406  CZ2 TRP A  28       5.459 112.084 -10.371  0.00  0.00           C  
ATOM    407  CZ3 TRP A  28       4.235 113.985  -9.477  0.00  0.00           C  
ATOM    408  CH2 TRP A  28       4.538 113.129 -10.550  0.00  0.00           C  
ATOM    409  H   TRP A  28       8.767 113.467  -6.680  0.00  0.00           H  
ATOM    410  HA  TRP A  28       7.833 113.741  -3.935  0.00  0.00           H  
ATOM    411  HB2 TRP A  28       5.943 112.308  -4.842  0.00  0.00           H  
ATOM    412  HB3 TRP A  28       6.171 113.900  -5.526  0.00  0.00           H  
ATOM    413  HD1 TRP A  28       8.016 110.712  -6.727  0.00  0.00           H  
ATOM    414  HE1 TRP A  28       7.390 110.244  -9.149  0.00  0.00           H  
ATOM    415  HE3 TRP A  28       4.608 114.474  -7.408  0.00  0.00           H  
ATOM    416  HZ2 TRP A  28       5.698 111.419 -11.189  0.00  0.00           H  
ATOM    417  HZ3 TRP A  28       3.524 114.790  -9.616  0.00  0.00           H  
ATOM    418  HH2 TRP A  28       4.061 113.273 -11.512  0.00  0.00           H  
ATOM    419  N   CYS A  29       9.589 111.176  -4.657  0.00  0.00           N  
ATOM    420  CA  CYS A  29      10.151 109.927  -4.169  0.00  0.00           C  
ATOM    421  C   CYS A  29      11.176 110.269  -3.086  0.00  0.00           C  
ATOM    422  O   CYS A  29      12.175 110.935  -3.367  0.00  0.00           O  
ATOM    423  CB  CYS A  29      10.771 109.165  -5.347  0.00  0.00           C  
ATOM    424  SG  CYS A  29      11.402 107.557  -4.789  0.00  0.00           S  
ATOM    425  H   CYS A  29      10.135 111.688  -5.338  0.00  0.00           H  
ATOM    426  HA  CYS A  29       9.351 109.313  -3.754  0.00  0.00           H  
ATOM    427  HB2 CYS A  29      10.009 108.997  -6.110  0.00  0.00           H  
ATOM    428  HB3 CYS A  29      11.578 109.758  -5.780  0.00  0.00           H  
ATOM    429  HG  CYS A  29      11.561 107.000  -5.998  0.00  0.00           H  
ATOM    430  N   GLY A  30      10.936 109.819  -1.852  0.00  0.00           N  
ATOM    431  CA  GLY A  30      11.838 110.021  -0.721  0.00  0.00           C  
ATOM    432  C   GLY A  30      13.259 109.537  -1.023  0.00  0.00           C  
ATOM    433  O   GLY A  30      14.181 110.351  -0.988  0.00  0.00           O  
ATOM    434  H   GLY A  30      10.093 109.286  -1.680  0.00  0.00           H  
ATOM    435  HA2 GLY A  30      11.871 111.080  -0.471  0.00  0.00           H  
ATOM    436  HA3 GLY A  30      11.456 109.477   0.143  0.00  0.00           H  
ATOM    437  N   PRO A  31      13.469 108.255  -1.374  0.00  0.00           N  
ATOM    438  CA  PRO A  31      14.785 107.717  -1.703  0.00  0.00           C  
ATOM    439  C   PRO A  31      15.585 108.510  -2.747  0.00  0.00           C  
ATOM    440  O   PRO A  31      16.806 108.594  -2.615  0.00  0.00           O  
ATOM    441  CB  PRO A  31      14.536 106.271  -2.134  0.00  0.00           C  
ATOM    442  CG  PRO A  31      13.319 105.875  -1.303  0.00  0.00           C  
ATOM    443  CD  PRO A  31      12.506 107.168  -1.244  0.00  0.00           C  
ATOM    444  HA  PRO A  31      15.358 107.701  -0.777  0.00  0.00           H  
ATOM    445  HB2 PRO A  31      14.269 106.236  -3.188  0.00  0.00           H  
ATOM    446  HB3 PRO A  31      15.395 105.631  -1.931  0.00  0.00           H  
ATOM    447  HG2 PRO A  31      12.756 105.064  -1.767  0.00  0.00           H  
ATOM    448  HG3 PRO A  31      13.637 105.596  -0.297  0.00  0.00           H  
ATOM    449  HD2 PRO A  31      11.802 107.195  -2.075  0.00  0.00           H  
ATOM    450  HD3 PRO A  31      11.966 107.223  -0.299  0.00  0.00           H  
ATOM    451  N   CYS A  32      14.941 109.141  -3.741  0.00  0.00           N  
ATOM    452  CA  CYS A  32      15.639 110.012  -4.695  0.00  0.00           C  
ATOM    453  C   CYS A  32      16.324 111.188  -3.990  0.00  0.00           C  
ATOM    454  O   CYS A  32      17.423 111.591  -4.372  0.00  0.00           O  
ATOM    455  CB  CYS A  32      14.667 110.576  -5.741  0.00  0.00           C  
ATOM    456  SG  CYS A  32      14.051 109.281  -6.848  0.00  0.00           S  
ATOM    457  H   CYS A  32      13.935 109.075  -3.793  0.00  0.00           H  
ATOM    458  HA  CYS A  32      16.412 109.431  -5.203  0.00  0.00           H  
ATOM    459  HB2 CYS A  32      13.830 111.081  -5.255  0.00  0.00           H  
ATOM    460  HB3 CYS A  32      15.204 111.318  -6.330  0.00  0.00           H  
ATOM    461  HG  CYS A  32      13.481 108.521  -5.904  0.00  0.00           H  
ATOM    462  N   LYS A  33      15.690 111.748  -2.959  0.00  0.00           N  
ATOM    463  CA  LYS A  33      16.268 112.833  -2.173  0.00  0.00           C  
ATOM    464  C   LYS A  33      17.289 112.275  -1.186  0.00  0.00           C  
ATOM    465  O   LYS A  33      18.304 112.925  -0.951  0.00  0.00           O  
ATOM    466  CB  LYS A  33      15.147 113.617  -1.472  0.00  0.00           C  
ATOM    467  CG  LYS A  33      14.275 114.350  -2.513  0.00  0.00           C  
ATOM    468  CD  LYS A  33      12.995 114.962  -1.935  0.00  0.00           C  
ATOM    469  CE  LYS A  33      12.030 113.871  -1.450  0.00  0.00           C  
ATOM    470  NZ  LYS A  33      10.648 114.389  -1.296  0.00  0.00           N  
ATOM    471  H   LYS A  33      14.803 111.357  -2.656  0.00  0.00           H  
ATOM    472  HA  LYS A  33      16.796 113.514  -2.843  0.00  0.00           H  
ATOM    473  HB2 LYS A  33      14.543 112.933  -0.877  0.00  0.00           H  
ATOM    474  HB3 LYS A  33      15.589 114.355  -0.801  0.00  0.00           H  
ATOM    475  HG2 LYS A  33      14.871 115.148  -2.961  0.00  0.00           H  
ATOM    476  HG3 LYS A  33      13.983 113.667  -3.311  0.00  0.00           H  
ATOM    477  HD2 LYS A  33      13.244 115.636  -1.113  0.00  0.00           H  
ATOM    478  HD3 LYS A  33      12.520 115.542  -2.728  0.00  0.00           H  
ATOM    479  HE2 LYS A  33      12.024 113.058  -2.183  0.00  0.00           H  
ATOM    480  HE3 LYS A  33      12.392 113.471  -0.499  0.00  0.00           H  
ATOM    481  HZ1 LYS A  33      10.620 115.193  -0.686  0.00  0.00           H  
ATOM    482  HZ2 LYS A  33      10.285 114.654  -2.209  0.00  0.00           H  
ATOM    483  HZ3 LYS A  33      10.034 113.686  -0.910  0.00  0.00           H  
ATOM    484  N   MET A  34      17.085 111.066  -0.653  0.00  0.00           N  
ATOM    485  CA  MET A  34      18.042 110.442   0.263  0.00  0.00           C  
ATOM    486  C   MET A  34      19.367 110.136  -0.436  0.00  0.00           C  
ATOM    487  O   MET A  34      20.421 110.314   0.171  0.00  0.00           O  
ATOM    488  CB  MET A  34      17.473 109.157   0.883  0.00  0.00           C  
ATOM    489  CG  MET A  34      16.205 109.408   1.702  0.00  0.00           C  
ATOM    490  SD  MET A  34      16.431 110.443   3.176  0.00  0.00           S  
ATOM    491  CE  MET A  34      14.714 110.520   3.749  0.00  0.00           C  
ATOM    492  H   MET A  34      16.216 110.586  -0.848  0.00  0.00           H  
ATOM    493  HA  MET A  34      18.245 111.151   1.065  0.00  0.00           H  
ATOM    494  HB2 MET A  34      17.258 108.440   0.094  0.00  0.00           H  
ATOM    495  HB3 MET A  34      18.226 108.717   1.538  0.00  0.00           H  
ATOM    496  HG2 MET A  34      15.466 109.882   1.062  0.00  0.00           H  
ATOM    497  HG3 MET A  34      15.808 108.443   2.018  0.00  0.00           H  
ATOM    498  HE1 MET A  34      14.656 111.123   4.656  0.00  0.00           H  
ATOM    499  HE2 MET A  34      14.088 110.974   2.979  0.00  0.00           H  
ATOM    500  HE3 MET A  34      14.350 109.515   3.963  0.00  0.00           H  
ATOM    501  N   ILE A  35      19.345 109.689  -1.700  0.00  0.00           N  
ATOM    502  CA  ILE A  35      20.573 109.394  -2.440  0.00  0.00           C  
ATOM    503  C   ILE A  35      21.241 110.682  -2.957  0.00  0.00           C  
ATOM    504  O   ILE A  35      22.414 110.648  -3.322  0.00  0.00           O  
ATOM    505  CB  ILE A  35      20.305 108.324  -3.529  0.00  0.00           C  
ATOM    506  CG1 ILE A  35      21.622 107.635  -3.955  0.00  0.00           C  
ATOM    507  CG2 ILE A  35      19.522 108.874  -4.731  0.00  0.00           C  
ATOM    508  CD1 ILE A  35      21.429 106.465  -4.928  0.00  0.00           C  
ATOM    509  H   ILE A  35      18.453 109.493  -2.146  0.00  0.00           H  
ATOM    510  HA  ILE A  35      21.268 108.947  -1.729  0.00  0.00           H  
ATOM    511  HB  ILE A  35      19.684 107.552  -3.075  0.00  0.00           H  
ATOM    512 HG12 ILE A  35      22.287 108.356  -4.426  0.00  0.00           H  
ATOM    513 HG13 ILE A  35      22.117 107.249  -3.062  0.00  0.00           H  
ATOM    514 HG21 ILE A  35      20.132 109.580  -5.297  0.00  0.00           H  
ATOM    515 HG22 ILE A  35      19.215 108.062  -5.389  0.00  0.00           H  
ATOM    516 HG23 ILE A  35      18.625 109.375  -4.383  0.00  0.00           H  
ATOM    517 HD11 ILE A  35      22.371 105.928  -5.031  0.00  0.00           H  
ATOM    518 HD12 ILE A  35      20.670 105.781  -4.551  0.00  0.00           H  
ATOM    519 HD13 ILE A  35      21.122 106.837  -5.906  0.00  0.00           H  
ATOM    520  N   ALA A  36      20.544 111.827  -2.969  0.00  0.00           N  
ATOM    521  CA  ALA A  36      21.092 113.081  -3.486  0.00  0.00           C  
ATOM    522  C   ALA A  36      22.423 113.490  -2.825  0.00  0.00           C  
ATOM    523  O   ALA A  36      23.377 113.724  -3.569  0.00  0.00           O  
ATOM    524  CB  ALA A  36      20.049 114.204  -3.431  0.00  0.00           C  
ATOM    525  H   ALA A  36      19.597 111.831  -2.610  0.00  0.00           H  
ATOM    526  HA  ALA A  36      21.315 112.905  -4.538  0.00  0.00           H  
ATOM    527  HB1 ALA A  36      19.136 113.893  -3.941  0.00  0.00           H  
ATOM    528  HB2 ALA A  36      19.814 114.464  -2.400  0.00  0.00           H  
ATOM    529  HB3 ALA A  36      20.446 115.091  -3.927  0.00  0.00           H  
ATOM    530  N   PRO A  37      22.575 113.521  -1.484  0.00  0.00           N  
ATOM    531  CA  PRO A  37      23.866 113.827  -0.876  0.00  0.00           C  
ATOM    532  C   PRO A  37      24.931 112.771  -1.201  0.00  0.00           C  
ATOM    533  O   PRO A  37      26.109 113.109  -1.273  0.00  0.00           O  
ATOM    534  CB  PRO A  37      23.615 113.952   0.630  0.00  0.00           C  
ATOM    535  CG  PRO A  37      22.320 113.175   0.851  0.00  0.00           C  
ATOM    536  CD  PRO A  37      21.558 113.413  -0.450  0.00  0.00           C  
ATOM    537  HA  PRO A  37      24.215 114.790  -1.252  0.00  0.00           H  
ATOM    538  HB2 PRO A  37      24.434 113.545   1.224  0.00  0.00           H  
ATOM    539  HB3 PRO A  37      23.453 115.001   0.882  0.00  0.00           H  
ATOM    540  HG2 PRO A  37      22.543 112.111   0.958  0.00  0.00           H  
ATOM    541  HG3 PRO A  37      21.767 113.540   1.717  0.00  0.00           H  
ATOM    542  HD2 PRO A  37      20.868 112.597  -0.626  0.00  0.00           H  
ATOM    543  HD3 PRO A  37      21.011 114.354  -0.383  0.00  0.00           H  
ATOM    544  N   VAL A  38      24.551 111.511  -1.435  0.00  0.00           N  
ATOM    545  CA  VAL A  38      25.490 110.465  -1.822  0.00  0.00           C  
ATOM    546  C   VAL A  38      26.023 110.752  -3.236  0.00  0.00           C  
ATOM    547  O   VAL A  38      27.214 110.593  -3.499  0.00  0.00           O  
ATOM    548  CB  VAL A  38      24.831 109.070  -1.716  0.00  0.00           C  
ATOM    549  CG1 VAL A  38      25.915 107.990  -1.697  0.00  0.00           C  
ATOM    550  CG2 VAL A  38      23.982 108.893  -0.442  0.00  0.00           C  
ATOM    551  H   VAL A  38      23.573 111.269  -1.419  0.00  0.00           H  
ATOM    552  HA  VAL A  38      26.322 110.510  -1.122  0.00  0.00           H  
ATOM    553  HB  VAL A  38      24.192 108.902  -2.580  0.00  0.00           H  
ATOM    554 HG11 VAL A  38      26.576 108.098  -2.554  0.00  0.00           H  
ATOM    555 HG12 VAL A  38      26.504 108.082  -0.786  0.00  0.00           H  
ATOM    556 HG13 VAL A  38      25.459 107.002  -1.736  0.00  0.00           H  
ATOM    557 HG21 VAL A  38      24.582 109.104   0.445  0.00  0.00           H  
ATOM    558 HG22 VAL A  38      23.121 109.558  -0.454  0.00  0.00           H  
ATOM    559 HG23 VAL A  38      23.614 107.869  -0.387  0.00  0.00           H  
ATOM    560  N   LEU A  39      25.165 111.225  -4.144  0.00  0.00           N  
ATOM    561  CA  LEU A  39      25.577 111.641  -5.478  0.00  0.00           C  
ATOM    562  C   LEU A  39      26.449 112.893  -5.406  0.00  0.00           C  
ATOM    563  O   LEU A  39      27.393 113.004  -6.181  0.00  0.00           O  
ATOM    564  CB  LEU A  39      24.350 111.862  -6.376  0.00  0.00           C  
ATOM    565  CG  LEU A  39      23.646 110.540  -6.746  0.00  0.00           C  
ATOM    566  CD1 LEU A  39      22.233 110.825  -7.254  0.00  0.00           C  
ATOM    567  CD2 LEU A  39      24.418 109.766  -7.823  0.00  0.00           C  
ATOM    568  H   LEU A  39      24.185 111.308  -3.905  0.00  0.00           H  
ATOM    569  HA  LEU A  39      26.182 110.842  -5.898  0.00  0.00           H  
ATOM    570  HB2 LEU A  39      23.653 112.522  -5.862  0.00  0.00           H  
ATOM    571  HB3 LEU A  39      24.666 112.365  -7.293  0.00  0.00           H  
ATOM    572  HG  LEU A  39      23.560 109.912  -5.862  0.00  0.00           H  
ATOM    573 HD11 LEU A  39      21.739 109.889  -7.515  0.00  0.00           H  
ATOM    574 HD12 LEU A  39      21.656 111.303  -6.462  0.00  0.00           H  
ATOM    575 HD13 LEU A  39      22.269 111.471  -8.132  0.00  0.00           H  
ATOM    576 HD21 LEU A  39      23.908 108.826  -8.034  0.00  0.00           H  
ATOM    577 HD22 LEU A  39      24.476 110.356  -8.737  0.00  0.00           H  
ATOM    578 HD23 LEU A  39      25.427 109.539  -7.482  0.00  0.00           H  
ATOM    579  N   GLU A  40      26.194 113.814  -4.472  0.00  0.00           N  
ATOM    580  CA  GLU A  40      27.065 114.967  -4.257  0.00  0.00           C  
ATOM    581  C   GLU A  40      28.422 114.544  -3.681  0.00  0.00           C  
ATOM    582  O   GLU A  40      29.446 115.148  -4.008  0.00  0.00           O  
ATOM    583  CB  GLU A  40      26.391 116.016  -3.360  0.00  0.00           C  
ATOM    584  CG  GLU A  40      25.243 116.736  -4.083  0.00  0.00           C  
ATOM    585  CD  GLU A  40      24.623 117.834  -3.200  0.00  0.00           C  
ATOM    586  OE1 GLU A  40      25.100 118.991  -3.236  0.00  0.00           O  
ATOM    587  OE2 GLU A  40      23.639 117.561  -2.475  0.00  0.00           O  
ATOM    588  H   GLU A  40      25.356 113.728  -3.906  0.00  0.00           H  
ATOM    589  HA  GLU A  40      27.258 115.425  -5.224  0.00  0.00           H  
ATOM    590  HB2 GLU A  40      26.018 115.545  -2.452  0.00  0.00           H  
ATOM    591  HB3 GLU A  40      27.136 116.761  -3.078  0.00  0.00           H  
ATOM    592  HG2 GLU A  40      25.631 117.184  -5.001  0.00  0.00           H  
ATOM    593  HG3 GLU A  40      24.476 116.016  -4.369  0.00  0.00           H  
ATOM    594  N   GLU A  41      28.476 113.506  -2.845  0.00  0.00           N  
ATOM    595  CA  GLU A  41      29.736 112.921  -2.406  0.00  0.00           C  
ATOM    596  C   GLU A  41      30.489 112.362  -3.611  0.00  0.00           C  
ATOM    597  O   GLU A  41      31.670 112.654  -3.769  0.00  0.00           O  
ATOM    598  CB  GLU A  41      29.521 111.855  -1.320  0.00  0.00           C  
ATOM    599  CG  GLU A  41      29.273 112.462   0.069  0.00  0.00           C  
ATOM    600  CD  GLU A  41      30.499 113.220   0.599  0.00  0.00           C  
ATOM    601  OE1 GLU A  41      31.540 112.572   0.858  0.00  0.00           O  
ATOM    602  OE2 GLU A  41      30.421 114.462   0.748  0.00  0.00           O  
ATOM    603  H   GLU A  41      27.613 113.083  -2.528  0.00  0.00           H  
ATOM    604  HA  GLU A  41      30.354 113.710  -1.992  0.00  0.00           H  
ATOM    605  HB2 GLU A  41      28.681 111.217  -1.580  0.00  0.00           H  
ATOM    606  HB3 GLU A  41      30.409 111.223  -1.266  0.00  0.00           H  
ATOM    607  HG2 GLU A  41      28.413 113.133   0.024  0.00  0.00           H  
ATOM    608  HG3 GLU A  41      29.025 111.657   0.763  0.00  0.00           H  
ATOM    609  N   LEU A  42      29.820 111.631  -4.504  0.00  0.00           N  
ATOM    610  CA  LEU A  42      30.456 111.136  -5.720  0.00  0.00           C  
ATOM    611  C   LEU A  42      30.896 112.281  -6.633  0.00  0.00           C  
ATOM    612  O   LEU A  42      31.941 112.175  -7.266  0.00  0.00           O  
ATOM    613  CB  LEU A  42      29.529 110.171  -6.474  0.00  0.00           C  
ATOM    614  CG  LEU A  42      29.848 108.680  -6.260  0.00  0.00           C  
ATOM    615  CD1 LEU A  42      31.196 108.291  -6.880  0.00  0.00           C  
ATOM    616  CD2 LEU A  42      29.811 108.270  -4.780  0.00  0.00           C  
ATOM    617  H   LEU A  42      28.849 111.397  -4.330  0.00  0.00           H  
ATOM    618  HA  LEU A  42      31.356 110.608  -5.419  0.00  0.00           H  
ATOM    619  HB2 LEU A  42      28.493 110.370  -6.199  0.00  0.00           H  
ATOM    620  HB3 LEU A  42      29.613 110.367  -7.542  0.00  0.00           H  
ATOM    621  HG  LEU A  42      29.084 108.113  -6.787  0.00  0.00           H  
ATOM    622 HD11 LEU A  42      31.235 108.617  -7.919  0.00  0.00           H  
ATOM    623 HD12 LEU A  42      32.026 108.737  -6.335  0.00  0.00           H  
ATOM    624 HD13 LEU A  42      31.306 107.209  -6.862  0.00  0.00           H  
ATOM    625 HD21 LEU A  42      30.635 108.724  -4.232  0.00  0.00           H  
ATOM    626 HD22 LEU A  42      28.872 108.595  -4.332  0.00  0.00           H  
ATOM    627 HD23 LEU A  42      29.883 107.187  -4.694  0.00  0.00           H  
ATOM    628  N   ASP A  43      30.146 113.379  -6.700  0.00  0.00           N  
ATOM    629  CA  ASP A  43      30.525 114.542  -7.498  0.00  0.00           C  
ATOM    630  C   ASP A  43      31.785 115.209  -6.935  0.00  0.00           C  
ATOM    631  O   ASP A  43      32.640 115.666  -7.694  0.00  0.00           O  
ATOM    632  CB  ASP A  43      29.392 115.569  -7.578  0.00  0.00           C  
ATOM    633  CG  ASP A  43      29.882 116.838  -8.285  0.00  0.00           C  
ATOM    634  OD1 ASP A  43      30.202 116.785  -9.493  0.00  0.00           O  
ATOM    635  OD2 ASP A  43      30.011 117.887  -7.619  0.00  0.00           O  
ATOM    636  H   ASP A  43      29.257 113.390  -6.214  0.00  0.00           H  
ATOM    637  HA  ASP A  43      30.725 114.197  -8.510  0.00  0.00           H  
ATOM    638  HB2 ASP A  43      28.554 115.141  -8.127  0.00  0.00           H  
ATOM    639  HB3 ASP A  43      29.054 115.818  -6.572  0.00  0.00           H  
ATOM    640  N   GLN A  44      31.934 115.244  -5.610  0.00  0.00           N  
ATOM    641  CA  GLN A  44      33.133 115.762  -4.969  0.00  0.00           C  
ATOM    642  C   GLN A  44      34.325 114.826  -5.201  0.00  0.00           C  
ATOM    643  O   GLN A  44      35.426 115.278  -5.512  0.00  0.00           O  
ATOM    644  CB  GLN A  44      32.870 115.917  -3.467  0.00  0.00           C  
ATOM    645  CG  GLN A  44      31.988 117.126  -3.119  0.00  0.00           C  
ATOM    646  CD  GLN A  44      31.501 116.996  -1.677  0.00  0.00           C  
ATOM    647  OE1 GLN A  44      32.092 117.531  -0.742  0.00  0.00           O  
ATOM    648  NE2 GLN A  44      30.444 116.231  -1.472  0.00  0.00           N  
ATOM    649  H   GLN A  44      31.189 114.894  -5.018  0.00  0.00           H  
ATOM    650  HA  GLN A  44      33.366 116.732  -5.395  0.00  0.00           H  
ATOM    651  HB2 GLN A  44      32.387 115.009  -3.108  0.00  0.00           H  
ATOM    652  HB3 GLN A  44      33.818 116.028  -2.941  0.00  0.00           H  
ATOM    653  HG2 GLN A  44      32.564 118.044  -3.240  0.00  0.00           H  
ATOM    654  HG3 GLN A  44      31.129 117.172  -3.791  0.00  0.00           H  
ATOM    655 HE21 GLN A  44      29.989 115.812  -2.281  0.00  0.00           H  
ATOM    656 HE22 GLN A  44      30.270 115.851  -0.539  0.00  0.00           H  
ATOM    657  N   GLU A  45      34.106 113.520  -5.035  0.00  0.00           N  
ATOM    658  CA  GLU A  45      35.163 112.514  -4.998  0.00  0.00           C  
ATOM    659  C   GLU A  45      35.627 112.112  -6.404  0.00  0.00           C  
ATOM    660  O   GLU A  45      36.806 111.811  -6.597  0.00  0.00           O  
ATOM    661  CB  GLU A  45      34.641 111.273  -4.253  0.00  0.00           C  
ATOM    662  CG  GLU A  45      34.399 111.498  -2.749  0.00  0.00           C  
ATOM    663  CD  GLU A  45      35.650 111.366  -1.865  0.00  0.00           C  
ATOM    664  OE1 GLU A  45      36.762 111.784  -2.259  0.00  0.00           O  
ATOM    665  OE2 GLU A  45      35.505 110.858  -0.728  0.00  0.00           O  
ATOM    666  H   GLU A  45      33.173 113.233  -4.750  0.00  0.00           H  
ATOM    667  HA  GLU A  45      36.023 112.918  -4.461  0.00  0.00           H  
ATOM    668  HB2 GLU A  45      33.696 110.976  -4.713  0.00  0.00           H  
ATOM    669  HB3 GLU A  45      35.338 110.443  -4.376  0.00  0.00           H  
ATOM    670  HG2 GLU A  45      33.956 112.480  -2.577  0.00  0.00           H  
ATOM    671  HG3 GLU A  45      33.669 110.753  -2.424  0.00  0.00           H  
ATOM    672  N   MET A  46      34.715 112.101  -7.384  0.00  0.00           N  
ATOM    673  CA  MET A  46      34.934 111.534  -8.713  0.00  0.00           C  
ATOM    674  C   MET A  46      34.310 112.377  -9.831  0.00  0.00           C  
ATOM    675  O   MET A  46      34.505 112.024 -10.993  0.00  0.00           O  
ATOM    676  CB  MET A  46      34.363 110.101  -8.787  0.00  0.00           C  
ATOM    677  CG  MET A  46      34.988 109.152  -7.763  0.00  0.00           C  
ATOM    678  SD  MET A  46      34.530 107.410  -7.945  0.00  0.00           S  
ATOM    679  CE  MET A  46      35.616 106.702  -6.681  0.00  0.00           C  
ATOM    680  H   MET A  46      33.755 112.331  -7.144  0.00  0.00           H  
ATOM    681  HA  MET A  46      36.005 111.478  -8.906  0.00  0.00           H  
ATOM    682  HB2 MET A  46      33.284 110.127  -8.636  0.00  0.00           H  
ATOM    683  HB3 MET A  46      34.566 109.696  -9.778  0.00  0.00           H  
ATOM    684  HG2 MET A  46      36.070 109.227  -7.855  0.00  0.00           H  
ATOM    685  HG3 MET A  46      34.682 109.471  -6.767  0.00  0.00           H  
ATOM    686  HE1 MET A  46      35.425 105.633  -6.592  0.00  0.00           H  
ATOM    687  HE2 MET A  46      36.657 106.863  -6.964  0.00  0.00           H  
ATOM    688  HE3 MET A  46      35.426 107.185  -5.722  0.00  0.00           H  
ATOM    689  N   GLY A  47      33.598 113.473  -9.534  0.00  0.00           N  
ATOM    690  CA  GLY A  47      32.840 114.287 -10.493  0.00  0.00           C  
ATOM    691  C   GLY A  47      33.722 115.176 -11.370  0.00  0.00           C  
ATOM    692  O   GLY A  47      33.486 116.376 -11.487  0.00  0.00           O  
ATOM    693  H   GLY A  47      33.509 113.742  -8.563  0.00  0.00           H  
ATOM    694  HA2 GLY A  47      32.263 113.624 -11.134  0.00  0.00           H  
ATOM    695  HA3 GLY A  47      32.127 114.919  -9.970  0.00  0.00           H  
ATOM    696  N   ASP A  48      34.772 114.587 -11.927  0.00  0.00           N  
ATOM    697  CA  ASP A  48      35.668 115.095 -12.950  0.00  0.00           C  
ATOM    698  C   ASP A  48      36.185 113.887 -13.739  0.00  0.00           C  
ATOM    699  O   ASP A  48      36.225 113.912 -14.969  0.00  0.00           O  
ATOM    700  CB  ASP A  48      36.845 115.839 -12.314  0.00  0.00           C  
ATOM    701  CG  ASP A  48      37.878 116.233 -13.383  0.00  0.00           C  
ATOM    702  OD1 ASP A  48      37.611 117.163 -14.174  0.00  0.00           O  
ATOM    703  OD2 ASP A  48      38.967 115.620 -13.429  0.00  0.00           O  
ATOM    704  H   ASP A  48      34.821 113.591 -11.778  0.00  0.00           H  
ATOM    705  HA  ASP A  48      35.124 115.764 -13.614  0.00  0.00           H  
ATOM    706  HB2 ASP A  48      36.478 116.731 -11.803  0.00  0.00           H  
ATOM    707  HB3 ASP A  48      37.310 115.188 -11.569  0.00  0.00           H  
ATOM    708  N   LYS A  49      36.498 112.791 -13.028  0.00  0.00           N  
ATOM    709  CA  LYS A  49      36.775 111.481 -13.608  0.00  0.00           C  
ATOM    710  C   LYS A  49      35.535 110.936 -14.321  0.00  0.00           C  
ATOM    711  O   LYS A  49      35.671 110.253 -15.337  0.00  0.00           O  
ATOM    712  CB  LYS A  49      37.228 110.491 -12.517  0.00  0.00           C  
ATOM    713  CG  LYS A  49      38.499 110.940 -11.775  0.00  0.00           C  
ATOM    714  CD  LYS A  49      38.926 109.887 -10.739  0.00  0.00           C  
ATOM    715  CE  LYS A  49      40.121 110.346  -9.887  0.00  0.00           C  
ATOM    716  NZ  LYS A  49      41.380 110.470 -10.664  0.00  0.00           N  
ATOM    717  H   LYS A  49      36.461 112.841 -12.021  0.00  0.00           H  
ATOM    718  HA  LYS A  49      37.568 111.597 -14.339  0.00  0.00           H  
ATOM    719  HB2 LYS A  49      36.421 110.358 -11.795  0.00  0.00           H  
ATOM    720  HB3 LYS A  49      37.423 109.528 -12.989  0.00  0.00           H  
ATOM    721  HG2 LYS A  49      39.299 111.086 -12.500  0.00  0.00           H  
ATOM    722  HG3 LYS A  49      38.308 111.881 -11.259  0.00  0.00           H  
ATOM    723  HD2 LYS A  49      38.088 109.695 -10.067  0.00  0.00           H  
ATOM    724  HD3 LYS A  49      39.176 108.953 -11.245  0.00  0.00           H  
ATOM    725  HE2 LYS A  49      39.877 111.305  -9.424  0.00  0.00           H  
ATOM    726  HE3 LYS A  49      40.269 109.620  -9.086  0.00  0.00           H  
ATOM    727  HZ1 LYS A  49      41.638 109.592 -11.089  0.00  0.00           H  
ATOM    728  HZ2 LYS A  49      41.303 111.166 -11.391  0.00  0.00           H  
ATOM    729  HZ3 LYS A  49      42.142 110.748 -10.062  0.00  0.00           H  
ATOM    730  N   LEU A  50      34.339 111.257 -13.818  0.00  0.00           N  
ATOM    731  CA  LEU A  50      33.057 110.966 -14.431  0.00  0.00           C  
ATOM    732  C   LEU A  50      32.143 112.190 -14.351  0.00  0.00           C  
ATOM    733  O   LEU A  50      32.357 113.081 -13.529  0.00  0.00           O  
ATOM    734  CB  LEU A  50      32.437 109.689 -13.819  0.00  0.00           C  
ATOM    735  CG  LEU A  50      31.300 109.831 -12.781  0.00  0.00           C  
ATOM    736  CD1 LEU A  50      30.624 108.470 -12.614  0.00  0.00           C  
ATOM    737  CD2 LEU A  50      31.789 110.316 -11.419  0.00  0.00           C  
ATOM    738  H   LEU A  50      34.300 111.783 -12.961  0.00  0.00           H  
ATOM    739  HA  LEU A  50      33.250 110.773 -15.482  0.00  0.00           H  
ATOM    740  HB2 LEU A  50      32.033 109.127 -14.655  0.00  0.00           H  
ATOM    741  HB3 LEU A  50      33.237 109.088 -13.374  0.00  0.00           H  
ATOM    742  HG  LEU A  50      30.545 110.522 -13.133  0.00  0.00           H  
ATOM    743 HD11 LEU A  50      31.368 107.722 -12.363  0.00  0.00           H  
ATOM    744 HD12 LEU A  50      29.877 108.518 -11.822  0.00  0.00           H  
ATOM    745 HD13 LEU A  50      30.135 108.187 -13.546  0.00  0.00           H  
ATOM    746 HD21 LEU A  50      32.163 111.332 -11.513  0.00  0.00           H  
ATOM    747 HD22 LEU A  50      30.966 110.325 -10.703  0.00  0.00           H  
ATOM    748 HD23 LEU A  50      32.579 109.664 -11.054  0.00  0.00           H  
ATOM    749  N   LYS A  51      31.110 112.216 -15.191  0.00  0.00           N  
ATOM    750  CA  LYS A  51      30.030 113.203 -15.163  0.00  0.00           C  
ATOM    751  C   LYS A  51      28.837 112.576 -14.432  0.00  0.00           C  
ATOM    752  O   LYS A  51      28.660 111.361 -14.516  0.00  0.00           O  
ATOM    753  CB  LYS A  51      29.702 113.545 -16.628  0.00  0.00           C  
ATOM    754  CG  LYS A  51      28.653 114.647 -16.826  0.00  0.00           C  
ATOM    755  CD  LYS A  51      28.211 114.770 -18.293  0.00  0.00           C  
ATOM    756  CE  LYS A  51      29.351 115.130 -19.262  0.00  0.00           C  
ATOM    757  NZ  LYS A  51      28.820 115.355 -20.623  0.00  0.00           N  
ATOM    758  H   LYS A  51      31.005 111.436 -15.836  0.00  0.00           H  
ATOM    759  HA  LYS A  51      30.362 114.101 -14.638  0.00  0.00           H  
ATOM    760  HB2 LYS A  51      30.625 113.855 -17.121  0.00  0.00           H  
ATOM    761  HB3 LYS A  51      29.352 112.638 -17.115  0.00  0.00           H  
ATOM    762  HG2 LYS A  51      27.766 114.423 -16.236  0.00  0.00           H  
ATOM    763  HG3 LYS A  51      29.063 115.599 -16.485  0.00  0.00           H  
ATOM    764  HD2 LYS A  51      27.756 113.830 -18.609  0.00  0.00           H  
ATOM    765  HD3 LYS A  51      27.443 115.545 -18.346  0.00  0.00           H  
ATOM    766  HE2 LYS A  51      29.837 116.044 -18.913  0.00  0.00           H  
ATOM    767  HE3 LYS A  51      30.094 114.326 -19.288  0.00  0.00           H  
ATOM    768  HZ1 LYS A  51      29.513 115.739 -21.267  0.00  0.00           H  
ATOM    769  HZ2 LYS A  51      28.467 114.492 -21.023  0.00  0.00           H  
ATOM    770  HZ3 LYS A  51      28.045 116.022 -20.603  0.00  0.00           H  
ATOM    771  N   ILE A  52      27.992 113.370 -13.770  0.00  0.00           N  
ATOM    772  CA  ILE A  52      26.755 112.897 -13.143  0.00  0.00           C  
ATOM    773  C   ILE A  52      25.631 113.713 -13.770  0.00  0.00           C  
ATOM    774  O   ILE A  52      25.769 114.933 -13.863  0.00  0.00           O  
ATOM    775  CB  ILE A  52      26.812 113.037 -11.600  0.00  0.00           C  
ATOM    776  CG1 ILE A  52      28.040 112.275 -11.046  0.00  0.00           C  
ATOM    777  CG2 ILE A  52      25.490 112.563 -10.948  0.00  0.00           C  
ATOM    778  CD1 ILE A  52      28.089 112.117  -9.525  0.00  0.00           C  
ATOM    779  H   ILE A  52      28.130 114.371 -13.780  0.00  0.00           H  
ATOM    780  HA  ILE A  52      26.609 111.845 -13.373  0.00  0.00           H  
ATOM    781  HB  ILE A  52      26.932 114.093 -11.356  0.00  0.00           H  
ATOM    782 HG12 ILE A  52      28.079 111.277 -11.487  0.00  0.00           H  
ATOM    783 HG13 ILE A  52      28.946 112.810 -11.338  0.00  0.00           H  
ATOM    784 HG21 ILE A  52      24.632 113.098 -11.356  0.00  0.00           H  
ATOM    785 HG22 ILE A  52      25.350 111.497 -11.116  0.00  0.00           H  
ATOM    786 HG23 ILE A  52      25.496 112.765  -9.876  0.00  0.00           H  
ATOM    787 HD11 ILE A  52      27.905 113.076  -9.041  0.00  0.00           H  
ATOM    788 HD12 ILE A  52      27.346 111.388  -9.200  0.00  0.00           H  
ATOM    789 HD13 ILE A  52      29.078 111.761  -9.243  0.00  0.00           H  
ATOM    790  N   VAL A  53      24.532 113.075 -14.185  0.00  0.00           N  
ATOM    791  CA  VAL A  53      23.421 113.743 -14.862  0.00  0.00           C  
ATOM    792  C   VAL A  53      22.106 113.391 -14.160  0.00  0.00           C  
ATOM    793  O   VAL A  53      21.692 112.230 -14.131  0.00  0.00           O  
ATOM    794  CB  VAL A  53      23.373 113.352 -16.360  0.00  0.00           C  
ATOM    795  CG1 VAL A  53      22.434 114.279 -17.142  0.00  0.00           C  
ATOM    796  CG2 VAL A  53      24.744 113.383 -17.052  0.00  0.00           C  
ATOM    797  H   VAL A  53      24.536 112.059 -14.190  0.00  0.00           H  
ATOM    798  HA  VAL A  53      23.574 114.822 -14.799  0.00  0.00           H  
ATOM    799  HB  VAL A  53      22.992 112.334 -16.446  0.00  0.00           H  
ATOM    800 HG11 VAL A  53      22.434 113.995 -18.193  0.00  0.00           H  
ATOM    801 HG12 VAL A  53      21.417 114.190 -16.760  0.00  0.00           H  
ATOM    802 HG13 VAL A  53      22.762 115.316 -17.055  0.00  0.00           H  
ATOM    803 HG21 VAL A  53      25.412 112.683 -16.556  0.00  0.00           H  
ATOM    804 HG22 VAL A  53      24.639 113.067 -18.092  0.00  0.00           H  
ATOM    805 HG23 VAL A  53      25.173 114.384 -17.013  0.00  0.00           H  
ATOM    806  N   LYS A  54      21.437 114.387 -13.581  0.00  0.00           N  
ATOM    807  CA  LYS A  54      20.071 114.238 -13.090  0.00  0.00           C  
ATOM    808  C   LYS A  54      19.135 114.230 -14.288  0.00  0.00           C  
ATOM    809  O   LYS A  54      19.323 115.030 -15.211  0.00  0.00           O  
ATOM    810  CB  LYS A  54      19.718 115.428 -12.186  0.00  0.00           C  
ATOM    811  CG  LYS A  54      20.448 115.426 -10.846  0.00  0.00           C  
ATOM    812  CD  LYS A  54      19.966 114.269  -9.972  0.00  0.00           C  
ATOM    813  CE  LYS A  54      20.586 114.387  -8.585  0.00  0.00           C  
ATOM    814  NZ  LYS A  54      19.853 113.548  -7.606  0.00  0.00           N  
ATOM    815  H   LYS A  54      21.809 115.329 -13.643  0.00  0.00           H  
ATOM    816  HA  LYS A  54      19.968 113.292 -12.556  0.00  0.00           H  
ATOM    817  HB2 LYS A  54      19.964 116.348 -12.708  0.00  0.00           H  
ATOM    818  HB3 LYS A  54      18.648 115.433 -11.985  0.00  0.00           H  
ATOM    819  HG2 LYS A  54      21.517 115.335 -11.014  0.00  0.00           H  
ATOM    820  HG3 LYS A  54      20.245 116.370 -10.340  0.00  0.00           H  
ATOM    821  HD2 LYS A  54      18.878 114.303  -9.900  0.00  0.00           H  
ATOM    822  HD3 LYS A  54      20.276 113.324 -10.416  0.00  0.00           H  
ATOM    823  HE2 LYS A  54      21.636 114.083  -8.657  0.00  0.00           H  
ATOM    824  HE3 LYS A  54      20.539 115.435  -8.283  0.00  0.00           H  
ATOM    825  HZ1 LYS A  54      20.331 113.513  -6.722  0.00  0.00           H  
ATOM    826  HZ2 LYS A  54      18.923 113.911  -7.448  0.00  0.00           H  
ATOM    827  HZ3 LYS A  54      19.736 112.596  -7.968  0.00  0.00           H  
ATOM    828  N   ILE A  55      18.110 113.382 -14.260  0.00  0.00           N  
ATOM    829  CA  ILE A  55      17.144 113.306 -15.344  0.00  0.00           C  
ATOM    830  C   ILE A  55      15.790 112.856 -14.760  0.00  0.00           C  
ATOM    831  O   ILE A  55      15.716 111.876 -14.018  0.00  0.00           O  
ATOM    832  CB  ILE A  55      17.772 112.449 -16.477  0.00  0.00           C  
ATOM    833  CG1 ILE A  55      16.798 112.294 -17.647  0.00  0.00           C  
ATOM    834  CG2 ILE A  55      18.297 111.069 -16.029  0.00  0.00           C  
ATOM    835  CD1 ILE A  55      17.481 112.006 -18.989  0.00  0.00           C  
ATOM    836  H   ILE A  55      18.048 112.668 -13.534  0.00  0.00           H  
ATOM    837  HA  ILE A  55      17.006 114.313 -15.746  0.00  0.00           H  
ATOM    838  HB  ILE A  55      18.632 113.006 -16.850  0.00  0.00           H  
ATOM    839 HG12 ILE A  55      16.149 111.468 -17.397  0.00  0.00           H  
ATOM    840 HG13 ILE A  55      16.200 113.200 -17.757  0.00  0.00           H  
ATOM    841 HG21 ILE A  55      18.740 110.544 -16.874  0.00  0.00           H  
ATOM    842 HG22 ILE A  55      19.062 111.173 -15.261  0.00  0.00           H  
ATOM    843 HG23 ILE A  55      17.476 110.467 -15.642  0.00  0.00           H  
ATOM    844 HD11 ILE A  55      18.201 112.795 -19.205  0.00  0.00           H  
ATOM    845 HD12 ILE A  55      17.982 111.041 -18.962  0.00  0.00           H  
ATOM    846 HD13 ILE A  55      16.739 111.985 -19.787  0.00  0.00           H  
ATOM    847  N   ASP A  56      14.718 113.618 -15.006  0.00  0.00           N  
ATOM    848  CA  ASP A  56      13.429 113.436 -14.319  0.00  0.00           C  
ATOM    849  C   ASP A  56      12.485 112.594 -15.173  0.00  0.00           C  
ATOM    850  O   ASP A  56      12.249 112.932 -16.338  0.00  0.00           O  
ATOM    851  CB  ASP A  56      12.793 114.795 -14.018  0.00  0.00           C  
ATOM    852  CG  ASP A  56      11.517 114.649 -13.169  0.00  0.00           C  
ATOM    853  OD1 ASP A  56      10.540 114.015 -13.627  0.00  0.00           O  
ATOM    854  OD2 ASP A  56      11.491 115.199 -12.046  0.00  0.00           O  
ATOM    855  H   ASP A  56      14.795 114.398 -15.643  0.00  0.00           H  
ATOM    856  HA  ASP A  56      13.601 112.943 -13.366  0.00  0.00           H  
ATOM    857  HB2 ASP A  56      13.522 115.409 -13.482  0.00  0.00           H  
ATOM    858  HB3 ASP A  56      12.554 115.299 -14.955  0.00  0.00           H  
ATOM    859  N   VAL A  57      11.973 111.482 -14.637  0.00  0.00           N  
ATOM    860  CA  VAL A  57      11.195 110.502 -15.406  0.00  0.00           C  
ATOM    861  C   VAL A  57       9.899 111.051 -16.012  0.00  0.00           C  
ATOM    862  O   VAL A  57       9.438 110.494 -17.007  0.00  0.00           O  
ATOM    863  CB  VAL A  57      10.954 109.211 -14.598  0.00  0.00           C  
ATOM    864  CG1 VAL A  57      12.286 108.481 -14.370  0.00  0.00           C  
ATOM    865  CG2 VAL A  57      10.237 109.448 -13.262  0.00  0.00           C  
ATOM    866  H   VAL A  57      12.154 111.282 -13.659  0.00  0.00           H  
ATOM    867  HA  VAL A  57      11.795 110.211 -16.260  0.00  0.00           H  
ATOM    868  HB  VAL A  57      10.328 108.550 -15.198  0.00  0.00           H  
ATOM    869 HG11 VAL A  57      12.785 108.312 -15.324  0.00  0.00           H  
ATOM    870 HG12 VAL A  57      12.940 109.061 -13.718  0.00  0.00           H  
ATOM    871 HG13 VAL A  57      12.096 107.506 -13.918  0.00  0.00           H  
ATOM    872 HG21 VAL A  57       9.291 109.965 -13.433  0.00  0.00           H  
ATOM    873 HG22 VAL A  57      10.021 108.492 -12.786  0.00  0.00           H  
ATOM    874 HG23 VAL A  57      10.853 110.047 -12.594  0.00  0.00           H  
ATOM    875  N   ASP A  58       9.319 112.134 -15.485  0.00  0.00           N  
ATOM    876  CA  ASP A  58       8.136 112.738 -16.102  0.00  0.00           C  
ATOM    877  C   ASP A  58       8.513 113.479 -17.388  0.00  0.00           C  
ATOM    878  O   ASP A  58       7.711 113.569 -18.317  0.00  0.00           O  
ATOM    879  CB  ASP A  58       7.455 113.709 -15.132  0.00  0.00           C  
ATOM    880  CG  ASP A  58       6.199 114.335 -15.764  0.00  0.00           C  
ATOM    881  OD1 ASP A  58       5.191 113.618 -15.953  0.00  0.00           O  
ATOM    882  OD2 ASP A  58       6.194 115.559 -16.029  0.00  0.00           O  
ATOM    883  H   ASP A  58       9.771 112.636 -14.719  0.00  0.00           H  
ATOM    884  HA  ASP A  58       7.422 111.953 -16.352  0.00  0.00           H  
ATOM    885  HB2 ASP A  58       7.174 113.172 -14.224  0.00  0.00           H  
ATOM    886  HB3 ASP A  58       8.156 114.498 -14.859  0.00  0.00           H  
ATOM    887  N   GLU A  59       9.748 113.984 -17.458  0.00  0.00           N  
ATOM    888  CA  GLU A  59      10.220 114.866 -18.521  0.00  0.00           C  
ATOM    889  C   GLU A  59      10.883 114.069 -19.646  0.00  0.00           C  
ATOM    890  O   GLU A  59      10.741 114.419 -20.817  0.00  0.00           O  
ATOM    891  CB  GLU A  59      11.229 115.877 -17.951  0.00  0.00           C  
ATOM    892  CG  GLU A  59      10.569 116.845 -16.954  0.00  0.00           C  
ATOM    893  CD  GLU A  59      11.477 118.045 -16.621  0.00  0.00           C  
ATOM    894  OE1 GLU A  59      11.548 118.999 -17.429  0.00  0.00           O  
ATOM    895  OE2 GLU A  59      12.092 118.073 -15.533  0.00  0.00           O  
ATOM    896  H   GLU A  59      10.390 113.769 -16.701  0.00  0.00           H  
ATOM    897  HA  GLU A  59       9.376 115.413 -18.941  0.00  0.00           H  
ATOM    898  HB2 GLU A  59      12.049 115.341 -17.467  0.00  0.00           H  
ATOM    899  HB3 GLU A  59      11.638 116.455 -18.780  0.00  0.00           H  
ATOM    900  HG2 GLU A  59       9.637 117.217 -17.385  0.00  0.00           H  
ATOM    901  HG3 GLU A  59      10.318 116.304 -16.038  0.00  0.00           H  
ATOM    902  N   ASN A  60      11.555 112.971 -19.296  0.00  0.00           N  
ATOM    903  CA  ASN A  60      12.303 112.112 -20.219  0.00  0.00           C  
ATOM    904  C   ASN A  60      11.620 110.745 -20.329  0.00  0.00           C  
ATOM    905  O   ASN A  60      12.264 109.714 -20.465  0.00  0.00           O  
ATOM    906  CB  ASN A  60      13.795 112.044 -19.826  0.00  0.00           C  
ATOM    907  CG  ASN A  60      14.141 110.910 -18.865  0.00  0.00           C  
ATOM    908  OD1 ASN A  60      14.840 109.968 -19.205  0.00  0.00           O  
ATOM    909  ND2 ASN A  60      13.695 110.989 -17.628  0.00  0.00           N  
ATOM    910  H   ASN A  60      11.569 112.734 -18.310  0.00  0.00           H  
ATOM    911  HA  ASN A  60      12.259 112.561 -21.212  0.00  0.00           H  
ATOM    912  HB2 ASN A  60      14.378 111.892 -20.731  0.00  0.00           H  
ATOM    913  HB3 ASN A  60      14.112 112.995 -19.394  0.00  0.00           H  
ATOM    914 HD21 ASN A  60      13.192 111.815 -17.312  0.00  0.00           H  
ATOM    915 HD22 ASN A  60      13.977 110.280 -16.971  0.00  0.00           H  
ATOM    916  N   GLN A  61      10.293 110.717 -20.240  0.00  0.00           N  
ATOM    917  CA  GLN A  61       9.490 109.498 -20.218  0.00  0.00           C  
ATOM    918  C   GLN A  61       9.850 108.553 -21.377  0.00  0.00           C  
ATOM    919  O   GLN A  61       9.981 107.345 -21.178  0.00  0.00           O  
ATOM    920  CB  GLN A  61       7.993 109.862 -20.132  0.00  0.00           C  
ATOM    921  CG  GLN A  61       7.371 110.557 -21.359  0.00  0.00           C  
ATOM    922  CD  GLN A  61       8.129 111.803 -21.826  0.00  0.00           C  
ATOM    923  OE1 GLN A  61       8.801 111.778 -22.851  0.00  0.00           O  
ATOM    924  NE2 GLN A  61       8.155 112.877 -21.054  0.00  0.00           N  
ATOM    925  H   GLN A  61       9.806 111.600 -20.241  0.00  0.00           H  
ATOM    926  HA  GLN A  61       9.732 108.977 -19.296  0.00  0.00           H  
ATOM    927  HB2 GLN A  61       7.432 108.944 -19.947  0.00  0.00           H  
ATOM    928  HB3 GLN A  61       7.845 110.507 -19.265  0.00  0.00           H  
ATOM    929  HG2 GLN A  61       7.337 109.834 -22.172  0.00  0.00           H  
ATOM    930  HG3 GLN A  61       6.346 110.834 -21.114  0.00  0.00           H  
ATOM    931 HE21 GLN A  61       7.655 112.922 -20.166  0.00  0.00           H  
ATOM    932 HE22 GLN A  61       8.725 113.668 -21.331  0.00  0.00           H  
ATOM    933  N   GLU A  62      10.094 109.116 -22.563  0.00  0.00           N  
ATOM    934  CA  GLU A  62      10.566 108.391 -23.733  0.00  0.00           C  
ATOM    935  C   GLU A  62      11.978 107.822 -23.515  0.00  0.00           C  
ATOM    936  O   GLU A  62      12.212 106.642 -23.772  0.00  0.00           O  
ATOM    937  CB  GLU A  62      10.543 109.343 -24.941  0.00  0.00           C  
ATOM    938  CG  GLU A  62       9.133 109.463 -25.539  0.00  0.00           C  
ATOM    939  CD  GLU A  62       9.121 110.354 -26.796  0.00  0.00           C  
ATOM    940  OE1 GLU A  62       9.361 109.839 -27.912  0.00  0.00           O  
ATOM    941  OE2 GLU A  62       8.844 111.570 -26.693  0.00  0.00           O  
ATOM    942  H   GLU A  62       9.939 110.113 -22.668  0.00  0.00           H  
ATOM    943  HA  GLU A  62       9.893 107.556 -23.920  0.00  0.00           H  
ATOM    944  HB2 GLU A  62      10.896 110.331 -24.631  0.00  0.00           H  
ATOM    945  HB3 GLU A  62      11.209 108.956 -25.712  0.00  0.00           H  
ATOM    946  HG2 GLU A  62       8.775 108.465 -25.801  0.00  0.00           H  
ATOM    947  HG3 GLU A  62       8.450 109.868 -24.789  0.00  0.00           H  
ATOM    948  N   THR A  63      12.919 108.635 -23.034  0.00  0.00           N  
ATOM    949  CA  THR A  63      14.316 108.250 -22.862  0.00  0.00           C  
ATOM    950  C   THR A  63      14.460 107.208 -21.754  0.00  0.00           C  
ATOM    951  O   THR A  63      15.188 106.241 -21.926  0.00  0.00           O  
ATOM    952  CB  THR A  63      15.186 109.479 -22.552  0.00  0.00           C  
ATOM    953  OG1 THR A  63      14.542 110.665 -22.960  0.00  0.00           O  
ATOM    954  CG2 THR A  63      16.568 109.421 -23.204  0.00  0.00           C  
ATOM    955  H   THR A  63      12.694 109.587 -22.782  0.00  0.00           H  
ATOM    956  HA  THR A  63      14.655 107.817 -23.797  0.00  0.00           H  
ATOM    957  HB  THR A  63      15.335 109.527 -21.480  0.00  0.00           H  
ATOM    958  HG1 THR A  63      14.478 110.654 -23.940  0.00  0.00           H  
ATOM    959 HG21 THR A  63      17.081 108.508 -22.901  0.00  0.00           H  
ATOM    960 HG22 THR A  63      16.476 109.447 -24.289  0.00  0.00           H  
ATOM    961 HG23 THR A  63      17.156 110.278 -22.874  0.00  0.00           H  
ATOM    962  N   ALA A  64      13.735 107.340 -20.646  0.00  0.00           N  
ATOM    963  CA  ALA A  64      13.725 106.340 -19.593  0.00  0.00           C  
ATOM    964  C   ALA A  64      13.179 105.020 -20.154  0.00  0.00           C  
ATOM    965  O   ALA A  64      13.786 103.963 -19.960  0.00  0.00           O  
ATOM    966  CB  ALA A  64      12.899 106.878 -18.421  0.00  0.00           C  
ATOM    967  H   ALA A  64      13.182 108.181 -20.521  0.00  0.00           H  
ATOM    968  HA  ALA A  64      14.757 106.180 -19.272  0.00  0.00           H  
ATOM    969  HB1 ALA A  64      11.848 106.939 -18.702  0.00  0.00           H  
ATOM    970  HB2 ALA A  64      13.007 106.217 -17.563  0.00  0.00           H  
ATOM    971  HB3 ALA A  64      13.250 107.870 -18.140  0.00  0.00           H  
ATOM    972  N   GLY A  65      12.108 105.088 -20.952  0.00  0.00           N  
ATOM    973  CA  GLY A  65      11.569 103.952 -21.690  0.00  0.00           C  
ATOM    974  C   GLY A  65      12.596 103.296 -22.622  0.00  0.00           C  
ATOM    975  O   GLY A  65      12.527 102.086 -22.841  0.00  0.00           O  
ATOM    976  H   GLY A  65      11.653 105.984 -21.087  0.00  0.00           H  
ATOM    977  HA2 GLY A  65      11.206 103.209 -20.977  0.00  0.00           H  
ATOM    978  HA3 GLY A  65      10.731 104.302 -22.291  0.00  0.00           H  
ATOM    979  N   LYS A  66      13.594 104.045 -23.111  0.00  0.00           N  
ATOM    980  CA  LYS A  66      14.681 103.536 -23.960  0.00  0.00           C  
ATOM    981  C   LYS A  66      15.502 102.460 -23.234  0.00  0.00           C  
ATOM    982  O   LYS A  66      16.131 101.634 -23.896  0.00  0.00           O  
ATOM    983  CB  LYS A  66      15.581 104.709 -24.403  0.00  0.00           C  
ATOM    984  CG  LYS A  66      16.275 104.509 -25.758  0.00  0.00           C  
ATOM    985  CD  LYS A  66      17.245 105.660 -26.091  0.00  0.00           C  
ATOM    986  CE  LYS A  66      16.626 107.073 -26.136  0.00  0.00           C  
ATOM    987  NZ  LYS A  66      15.647 107.248 -27.241  0.00  0.00           N  
ATOM    988  H   LYS A  66      13.629 105.021 -22.838  0.00  0.00           H  
ATOM    989  HA  LYS A  66      14.224 103.084 -24.842  0.00  0.00           H  
ATOM    990  HB2 LYS A  66      14.971 105.609 -24.474  0.00  0.00           H  
ATOM    991  HB3 LYS A  66      16.350 104.868 -23.645  0.00  0.00           H  
ATOM    992  HG2 LYS A  66      16.845 103.578 -25.733  0.00  0.00           H  
ATOM    993  HG3 LYS A  66      15.521 104.424 -26.541  0.00  0.00           H  
ATOM    994  HD2 LYS A  66      18.034 105.665 -25.335  0.00  0.00           H  
ATOM    995  HD3 LYS A  66      17.722 105.448 -27.048  0.00  0.00           H  
ATOM    996  HE2 LYS A  66      16.151 107.295 -25.178  0.00  0.00           H  
ATOM    997  HE3 LYS A  66      17.433 107.802 -26.261  0.00  0.00           H  
ATOM    998  HZ1 LYS A  66      16.081 107.087 -28.140  0.00  0.00           H  
ATOM    999  HZ2 LYS A  66      14.863 106.621 -27.155  0.00  0.00           H  
ATOM   1000  HZ3 LYS A  66      15.286 108.193 -27.252  0.00  0.00           H  
ATOM   1001  N   TYR A  67      15.463 102.439 -21.898  0.00  0.00           N  
ATOM   1002  CA  TYR A  67      16.174 101.485 -21.049  0.00  0.00           C  
ATOM   1003  C   TYR A  67      15.182 100.681 -20.186  0.00  0.00           C  
ATOM   1004  O   TYR A  67      15.598  99.970 -19.270  0.00  0.00           O  
ATOM   1005  CB  TYR A  67      17.209 102.232 -20.183  0.00  0.00           C  
ATOM   1006  CG  TYR A  67      17.927 103.375 -20.878  0.00  0.00           C  
ATOM   1007  CD1 TYR A  67      18.915 103.123 -21.848  0.00  0.00           C  
ATOM   1008  CD2 TYR A  67      17.549 104.700 -20.591  0.00  0.00           C  
ATOM   1009  CE1 TYR A  67      19.509 104.192 -22.546  0.00  0.00           C  
ATOM   1010  CE2 TYR A  67      18.128 105.771 -21.286  0.00  0.00           C  
ATOM   1011  CZ  TYR A  67      19.106 105.523 -22.277  0.00  0.00           C  
ATOM   1012  OH  TYR A  67      19.633 106.565 -22.980  0.00  0.00           O  
ATOM   1013  H   TYR A  67      14.953 103.172 -21.419  0.00  0.00           H  
ATOM   1014  HA  TYR A  67      16.712 100.779 -21.684  0.00  0.00           H  
ATOM   1015  HB2 TYR A  67      16.694 102.645 -19.317  0.00  0.00           H  
ATOM   1016  HB3 TYR A  67      17.946 101.517 -19.814  0.00  0.00           H  
ATOM   1017  HD1 TYR A  67      19.205 102.106 -22.078  0.00  0.00           H  
ATOM   1018  HD2 TYR A  67      16.776 104.901 -19.863  0.00  0.00           H  
ATOM   1019  HE1 TYR A  67      20.256 103.987 -23.300  0.00  0.00           H  
ATOM   1020  HE2 TYR A  67      17.778 106.773 -21.084  0.00  0.00           H  
ATOM   1021  HH  TYR A  67      20.295 106.295 -23.634  0.00  0.00           H  
ATOM   1022  N   GLY A  68      13.874 100.796 -20.454  0.00  0.00           N  
ATOM   1023  CA  GLY A  68      12.815 100.143 -19.690  0.00  0.00           C  
ATOM   1024  C   GLY A  68      12.654 100.704 -18.273  0.00  0.00           C  
ATOM   1025  O   GLY A  68      12.147 100.004 -17.395  0.00  0.00           O  
ATOM   1026  H   GLY A  68      13.585 101.351 -21.251  0.00  0.00           H  
ATOM   1027  HA2 GLY A  68      11.875 100.286 -20.222  0.00  0.00           H  
ATOM   1028  HA3 GLY A  68      13.024  99.073 -19.631  0.00  0.00           H  
ATOM   1029  N   VAL A  69      13.095 101.940 -18.029  0.00  0.00           N  
ATOM   1030  CA  VAL A  69      13.026 102.595 -16.729  0.00  0.00           C  
ATOM   1031  C   VAL A  69      11.709 103.373 -16.670  0.00  0.00           C  
ATOM   1032  O   VAL A  69      11.438 104.206 -17.533  0.00  0.00           O  
ATOM   1033  CB  VAL A  69      14.269 103.498 -16.546  0.00  0.00           C  
ATOM   1034  CG1 VAL A  69      14.220 104.318 -15.246  0.00  0.00           C  
ATOM   1035  CG2 VAL A  69      15.547 102.643 -16.514  0.00  0.00           C  
ATOM   1036  H   VAL A  69      13.441 102.499 -18.802  0.00  0.00           H  
ATOM   1037  HA  VAL A  69      13.033 101.840 -15.943  0.00  0.00           H  
ATOM   1038  HB  VAL A  69      14.342 104.189 -17.389  0.00  0.00           H  
ATOM   1039 HG11 VAL A  69      14.119 103.659 -14.383  0.00  0.00           H  
ATOM   1040 HG12 VAL A  69      15.136 104.902 -15.144  0.00  0.00           H  
ATOM   1041 HG13 VAL A  69      13.381 105.014 -15.267  0.00  0.00           H  
ATOM   1042 HG21 VAL A  69      15.503 101.932 -15.690  0.00  0.00           H  
ATOM   1043 HG22 VAL A  69      15.653 102.082 -17.439  0.00  0.00           H  
ATOM   1044 HG23 VAL A  69      16.422 103.284 -16.397  0.00  0.00           H  
ATOM   1045  N   MET A  70      10.905 103.111 -15.637  0.00  0.00           N  
ATOM   1046  CA  MET A  70       9.708 103.876 -15.267  0.00  0.00           C  
ATOM   1047  C   MET A  70       9.519 103.825 -13.736  0.00  0.00           C  
ATOM   1048  O   MET A  70       8.405 103.952 -13.223  0.00  0.00           O  
ATOM   1049  CB  MET A  70       8.480 103.374 -16.065  0.00  0.00           C  
ATOM   1050  CG  MET A  70       8.173 104.223 -17.309  0.00  0.00           C  
ATOM   1051  SD  MET A  70       7.662 105.941 -16.975  0.00  0.00           S  
ATOM   1052  CE  MET A  70       9.133 106.872 -17.494  0.00  0.00           C  
ATOM   1053  H   MET A  70      11.149 102.348 -15.020  0.00  0.00           H  
ATOM   1054  HA  MET A  70       9.888 104.921 -15.513  0.00  0.00           H  
ATOM   1055  HB2 MET A  70       8.637 102.337 -16.370  0.00  0.00           H  
ATOM   1056  HB3 MET A  70       7.584 103.391 -15.448  0.00  0.00           H  
ATOM   1057  HG2 MET A  70       9.029 104.222 -17.982  0.00  0.00           H  
ATOM   1058  HG3 MET A  70       7.352 103.738 -17.836  0.00  0.00           H  
ATOM   1059  HE1 MET A  70       8.958 107.941 -17.350  0.00  0.00           H  
ATOM   1060  HE2 MET A  70      10.000 106.576 -16.906  0.00  0.00           H  
ATOM   1061  HE3 MET A  70       9.332 106.682 -18.548  0.00  0.00           H  
ATOM   1062  N   SER A  71      10.620 103.648 -12.996  0.00  0.00           N  
ATOM   1063  CA  SER A  71      10.678 103.554 -11.547  0.00  0.00           C  
ATOM   1064  C   SER A  71      11.933 104.302 -11.096  0.00  0.00           C  
ATOM   1065  O   SER A  71      12.892 104.415 -11.867  0.00  0.00           O  
ATOM   1066  CB  SER A  71      10.731 102.080 -11.114  0.00  0.00           C  
ATOM   1067  OG  SER A  71       9.647 101.335 -11.654  0.00  0.00           O  
ATOM   1068  H   SER A  71      11.524 103.683 -13.438  0.00  0.00           H  
ATOM   1069  HA  SER A  71       9.803 104.035 -11.122  0.00  0.00           H  
ATOM   1070  HB2 SER A  71      11.670 101.641 -11.456  0.00  0.00           H  
ATOM   1071  HB3 SER A  71      10.702 102.027 -10.024  0.00  0.00           H  
ATOM   1072  HG  SER A  71       9.730 100.416 -11.342  0.00  0.00           H  
ATOM   1073  N   ILE A  72      11.931 104.828  -9.870  0.00  0.00           N  
ATOM   1074  CA  ILE A  72      12.969 105.722  -9.365  0.00  0.00           C  
ATOM   1075  C   ILE A  72      13.209 105.468  -7.865  0.00  0.00           C  
ATOM   1076  O   ILE A  72      12.285 104.999  -7.193  0.00  0.00           O  
ATOM   1077  CB  ILE A  72      12.601 107.205  -9.631  0.00  0.00           C  
ATOM   1078  CG1 ILE A  72      11.421 107.795  -8.824  0.00  0.00           C  
ATOM   1079  CG2 ILE A  72      12.441 107.503 -11.129  0.00  0.00           C  
ATOM   1080  CD1 ILE A  72      10.008 107.299  -9.155  0.00  0.00           C  
ATOM   1081  H   ILE A  72      11.156 104.650  -9.245  0.00  0.00           H  
ATOM   1082  HA  ILE A  72      13.884 105.506  -9.911  0.00  0.00           H  
ATOM   1083  HB  ILE A  72      13.467 107.774  -9.313  0.00  0.00           H  
ATOM   1084 HG12 ILE A  72      11.599 107.630  -7.766  0.00  0.00           H  
ATOM   1085 HG13 ILE A  72      11.430 108.875  -8.974  0.00  0.00           H  
ATOM   1086 HG21 ILE A  72      12.337 108.575 -11.282  0.00  0.00           H  
ATOM   1087 HG22 ILE A  72      13.323 107.156 -11.669  0.00  0.00           H  
ATOM   1088 HG23 ILE A  72      11.565 107.002 -11.537  0.00  0.00           H  
ATOM   1089 HD11 ILE A  72       9.774 107.479 -10.204  0.00  0.00           H  
ATOM   1090 HD12 ILE A  72       9.912 106.239  -8.929  0.00  0.00           H  
ATOM   1091 HD13 ILE A  72       9.292 107.848  -8.543  0.00  0.00           H  
ATOM   1092  N   PRO A  73      14.387 105.815  -7.307  0.00  0.00           N  
ATOM   1093  CA  PRO A  73      15.588 106.233  -8.021  0.00  0.00           C  
ATOM   1094  C   PRO A  73      16.154 105.053  -8.810  0.00  0.00           C  
ATOM   1095  O   PRO A  73      16.219 103.932  -8.297  0.00  0.00           O  
ATOM   1096  CB  PRO A  73      16.579 106.710  -6.956  0.00  0.00           C  
ATOM   1097  CG  PRO A  73      16.141 105.985  -5.687  0.00  0.00           C  
ATOM   1098  CD  PRO A  73      14.641 105.763  -5.878  0.00  0.00           C  
ATOM   1099  HA  PRO A  73      15.377 107.062  -8.693  0.00  0.00           H  
ATOM   1100  HB2 PRO A  73      17.610 106.471  -7.215  0.00  0.00           H  
ATOM   1101  HB3 PRO A  73      16.476 107.785  -6.819  0.00  0.00           H  
ATOM   1102  HG2 PRO A  73      16.645 105.023  -5.629  0.00  0.00           H  
ATOM   1103  HG3 PRO A  73      16.346 106.579  -4.794  0.00  0.00           H  
ATOM   1104  HD2 PRO A  73      14.344 104.799  -5.460  0.00  0.00           H  
ATOM   1105  HD3 PRO A  73      14.087 106.565  -5.395  0.00  0.00           H  
ATOM   1106  N   THR A  74      16.600 105.323 -10.032  0.00  0.00           N  
ATOM   1107  CA  THR A  74      17.269 104.349 -10.871  0.00  0.00           C  
ATOM   1108  C   THR A  74      18.540 105.024 -11.365  0.00  0.00           C  
ATOM   1109  O   THR A  74      18.496 106.067 -12.016  0.00  0.00           O  
ATOM   1110  CB  THR A  74      16.337 103.871 -11.995  0.00  0.00           C  
ATOM   1111  OG1 THR A  74      15.244 103.169 -11.438  0.00  0.00           O  
ATOM   1112  CG2 THR A  74      17.063 102.940 -12.969  0.00  0.00           C  
ATOM   1113  H   THR A  74      16.522 106.269 -10.399  0.00  0.00           H  
ATOM   1114  HA  THR A  74      17.546 103.480 -10.275  0.00  0.00           H  
ATOM   1115  HB  THR A  74      15.952 104.728 -12.547  0.00  0.00           H  
ATOM   1116  HG1 THR A  74      14.434 103.676 -11.638  0.00  0.00           H  
ATOM   1117 HG21 THR A  74      16.343 102.460 -13.630  0.00  0.00           H  
ATOM   1118 HG22 THR A  74      17.764 103.515 -13.574  0.00  0.00           H  
ATOM   1119 HG23 THR A  74      17.616 102.177 -12.424  0.00  0.00           H  
ATOM   1120  N   LEU A  75      19.683 104.451 -11.000  0.00  0.00           N  
ATOM   1121  CA  LEU A  75      20.967 104.915 -11.479  0.00  0.00           C  
ATOM   1122  C   LEU A  75      21.274 104.148 -12.753  0.00  0.00           C  
ATOM   1123  O   LEU A  75      20.998 102.952 -12.849  0.00  0.00           O  
ATOM   1124  CB  LEU A  75      22.080 104.693 -10.444  0.00  0.00           C  
ATOM   1125  CG  LEU A  75      21.892 105.448  -9.114  0.00  0.00           C  
ATOM   1126  CD1 LEU A  75      23.138 105.237  -8.249  0.00  0.00           C  
ATOM   1127  CD2 LEU A  75      21.649 106.949  -9.297  0.00  0.00           C  
ATOM   1128  H   LEU A  75      19.644 103.511 -10.620  0.00  0.00           H  
ATOM   1129  HA  LEU A  75      20.901 105.975 -11.704  0.00  0.00           H  
ATOM   1130  HB2 LEU A  75      22.162 103.626 -10.238  0.00  0.00           H  
ATOM   1131  HB3 LEU A  75      23.020 105.015 -10.897  0.00  0.00           H  
ATOM   1132  HG  LEU A  75      21.031 105.036  -8.590  0.00  0.00           H  
ATOM   1133 HD11 LEU A  75      24.013 105.650  -8.751  0.00  0.00           H  
ATOM   1134 HD12 LEU A  75      23.017 105.733  -7.288  0.00  0.00           H  
ATOM   1135 HD13 LEU A  75      23.295 104.173  -8.075  0.00  0.00           H  
ATOM   1136 HD21 LEU A  75      20.670 107.103  -9.745  0.00  0.00           H  
ATOM   1137 HD22 LEU A  75      21.657 107.452  -8.330  0.00  0.00           H  
ATOM   1138 HD23 LEU A  75      22.412 107.381  -9.942  0.00  0.00           H  
ATOM   1139  N   LEU A  76      21.907 104.823 -13.702  0.00  0.00           N  
ATOM   1140  CA  LEU A  76      22.472 104.220 -14.899  0.00  0.00           C  
ATOM   1141  C   LEU A  76      23.937 104.619 -14.931  0.00  0.00           C  
ATOM   1142  O   LEU A  76      24.313 105.668 -14.406  0.00  0.00           O  
ATOM   1143  CB  LEU A  76      21.767 104.729 -16.174  0.00  0.00           C  
ATOM   1144  CG  LEU A  76      20.877 103.681 -16.866  0.00  0.00           C  
ATOM   1145  CD1 LEU A  76      19.575 103.443 -16.095  0.00  0.00           C  
ATOM   1146  CD2 LEU A  76      20.542 104.122 -18.296  0.00  0.00           C  
ATOM   1147  H   LEU A  76      22.165 105.789 -13.515  0.00  0.00           H  
ATOM   1148  HA  LEU A  76      22.407 103.134 -14.850  0.00  0.00           H  
ATOM   1149  HB2 LEU A  76      21.183 105.617 -15.942  0.00  0.00           H  
ATOM   1150  HB3 LEU A  76      22.533 105.025 -16.889  0.00  0.00           H  
ATOM   1151  HG  LEU A  76      21.431 102.747 -16.930  0.00  0.00           H  
ATOM   1152 HD11 LEU A  76      18.984 104.357 -16.055  0.00  0.00           H  
ATOM   1153 HD12 LEU A  76      18.998 102.657 -16.584  0.00  0.00           H  
ATOM   1154 HD13 LEU A  76      19.803 103.123 -15.083  0.00  0.00           H  
ATOM   1155 HD21 LEU A  76      19.945 103.351 -18.784  0.00  0.00           H  
ATOM   1156 HD22 LEU A  76      19.980 105.054 -18.289  0.00  0.00           H  
ATOM   1157 HD23 LEU A  76      21.458 104.257 -18.871  0.00  0.00           H  
ATOM   1158  N   VAL A  77      24.746 103.822 -15.614  0.00  0.00           N  
ATOM   1159  CA  VAL A  77      26.109 104.173 -15.951  0.00  0.00           C  
ATOM   1160  C   VAL A  77      26.180 103.974 -17.453  0.00  0.00           C  
ATOM   1161  O   VAL A  77      25.781 102.923 -17.969  0.00  0.00           O  
ATOM   1162  CB  VAL A  77      27.128 103.306 -15.195  0.00  0.00           C  
ATOM   1163  CG1 VAL A  77      28.549 103.662 -15.644  0.00  0.00           C  
ATOM   1164  CG2 VAL A  77      27.032 103.459 -13.665  0.00  0.00           C  
ATOM   1165  H   VAL A  77      24.378 102.973 -16.034  0.00  0.00           H  
ATOM   1166  HA  VAL A  77      26.297 105.222 -15.718  0.00  0.00           H  
ATOM   1167  HB  VAL A  77      26.942 102.266 -15.450  0.00  0.00           H  
ATOM   1168 HG11 VAL A  77      28.650 103.657 -16.726  0.00  0.00           H  
ATOM   1169 HG12 VAL A  77      28.827 104.647 -15.269  0.00  0.00           H  
ATOM   1170 HG13 VAL A  77      29.233 102.910 -15.262  0.00  0.00           H  
ATOM   1171 HG21 VAL A  77      26.057 103.127 -13.310  0.00  0.00           H  
ATOM   1172 HG22 VAL A  77      27.803 102.861 -13.171  0.00  0.00           H  
ATOM   1173 HG23 VAL A  77      27.185 104.501 -13.382  0.00  0.00           H  
ATOM   1174  N   LEU A  78      26.697 104.986 -18.136  0.00  0.00           N  
ATOM   1175  CA  LEU A  78      26.947 105.018 -19.558  0.00  0.00           C  
ATOM   1176  C   LEU A  78      28.408 105.422 -19.739  0.00  0.00           C  
ATOM   1177  O   LEU A  78      29.005 106.044 -18.856  0.00  0.00           O  
ATOM   1178  CB  LEU A  78      26.002 106.002 -20.282  0.00  0.00           C  
ATOM   1179  CG  LEU A  78      24.493 105.757 -20.041  0.00  0.00           C  
ATOM   1180  CD1 LEU A  78      23.942 106.605 -18.885  0.00  0.00           C  
ATOM   1181  CD2 LEU A  78      23.673 106.050 -21.303  0.00  0.00           C  
ATOM   1182  H   LEU A  78      27.034 105.800 -17.625  0.00  0.00           H  
ATOM   1183  HA  LEU A  78      26.811 104.019 -19.959  0.00  0.00           H  
ATOM   1184  HB2 LEU A  78      26.256 107.023 -19.992  0.00  0.00           H  
ATOM   1185  HB3 LEU A  78      26.211 105.915 -21.350  0.00  0.00           H  
ATOM   1186  HG  LEU A  78      24.333 104.711 -19.789  0.00  0.00           H  
ATOM   1187 HD11 LEU A  78      24.437 106.348 -17.950  0.00  0.00           H  
ATOM   1188 HD12 LEU A  78      24.102 107.663 -19.078  0.00  0.00           H  
ATOM   1189 HD13 LEU A  78      22.874 106.426 -18.773  0.00  0.00           H  
ATOM   1190 HD21 LEU A  78      23.771 107.095 -21.590  0.00  0.00           H  
ATOM   1191 HD22 LEU A  78      24.019 105.422 -22.124  0.00  0.00           H  
ATOM   1192 HD23 LEU A  78      22.621 105.829 -21.123  0.00  0.00           H  
ATOM   1193  N   LYS A  79      29.005 105.064 -20.871  0.00  0.00           N  
ATOM   1194  CA  LYS A  79      30.407 105.333 -21.145  0.00  0.00           C  
ATOM   1195  C   LYS A  79      30.538 105.571 -22.641  0.00  0.00           C  
ATOM   1196  O   LYS A  79      30.181 104.691 -23.423  0.00  0.00           O  
ATOM   1197  CB  LYS A  79      31.249 104.151 -20.624  0.00  0.00           C  
ATOM   1198  CG  LYS A  79      32.758 104.446 -20.594  0.00  0.00           C  
ATOM   1199  CD  LYS A  79      33.505 103.408 -19.734  0.00  0.00           C  
ATOM   1200  CE  LYS A  79      34.997 103.766 -19.613  0.00  0.00           C  
ATOM   1201  NZ  LYS A  79      35.666 102.981 -18.551  0.00  0.00           N  
ATOM   1202  H   LYS A  79      28.477 104.533 -21.563  0.00  0.00           H  
ATOM   1203  HA  LYS A  79      30.700 106.234 -20.608  0.00  0.00           H  
ATOM   1204  HB2 LYS A  79      30.929 103.936 -19.603  0.00  0.00           H  
ATOM   1205  HB3 LYS A  79      31.062 103.264 -21.230  0.00  0.00           H  
ATOM   1206  HG2 LYS A  79      33.151 104.436 -21.612  0.00  0.00           H  
ATOM   1207  HG3 LYS A  79      32.915 105.438 -20.170  0.00  0.00           H  
ATOM   1208  HD2 LYS A  79      33.065 103.385 -18.732  0.00  0.00           H  
ATOM   1209  HD3 LYS A  79      33.402 102.416 -20.176  0.00  0.00           H  
ATOM   1210  HE2 LYS A  79      35.494 103.601 -20.573  0.00  0.00           H  
ATOM   1211  HE3 LYS A  79      35.086 104.826 -19.372  0.00  0.00           H  
ATOM   1212  HZ1 LYS A  79      36.511 103.444 -18.217  0.00  0.00           H  
ATOM   1213  HZ2 LYS A  79      35.079 102.916 -17.723  0.00  0.00           H  
ATOM   1214  HZ3 LYS A  79      35.896 102.048 -18.860  0.00  0.00           H  
ATOM   1215  N   ASP A  80      31.010 106.760 -23.032  0.00  0.00           N  
ATOM   1216  CA  ASP A  80      31.209 107.173 -24.423  0.00  0.00           C  
ATOM   1217  C   ASP A  80      30.001 106.871 -25.336  0.00  0.00           C  
ATOM   1218  O   ASP A  80      30.156 106.505 -26.503  0.00  0.00           O  
ATOM   1219  CB  ASP A  80      32.545 106.614 -24.943  0.00  0.00           C  
ATOM   1220  CG  ASP A  80      32.945 107.199 -26.310  0.00  0.00           C  
ATOM   1221  OD1 ASP A  80      32.872 108.434 -26.495  0.00  0.00           O  
ATOM   1222  OD2 ASP A  80      33.403 106.432 -27.189  0.00  0.00           O  
ATOM   1223  H   ASP A  80      31.235 107.462 -22.328  0.00  0.00           H  
ATOM   1224  HA  ASP A  80      31.309 108.259 -24.396  0.00  0.00           H  
ATOM   1225  HB2 ASP A  80      33.331 106.852 -24.222  0.00  0.00           H  
ATOM   1226  HB3 ASP A  80      32.475 105.526 -25.008  0.00  0.00           H  
ATOM   1227  N   GLY A  81      28.781 106.998 -24.798  0.00  0.00           N  
ATOM   1228  CA  GLY A  81      27.547 106.995 -25.577  0.00  0.00           C  
ATOM   1229  C   GLY A  81      26.668 105.756 -25.433  0.00  0.00           C  
ATOM   1230  O   GLY A  81      25.585 105.739 -26.019  0.00  0.00           O  
ATOM   1231  H   GLY A  81      28.702 107.326 -23.842  0.00  0.00           H  
ATOM   1232  HA2 GLY A  81      26.956 107.848 -25.247  0.00  0.00           H  
ATOM   1233  HA3 GLY A  81      27.774 107.140 -26.634  0.00  0.00           H  
ATOM   1234  N   GLU A  82      27.074 104.735 -24.668  0.00  0.00           N  
ATOM   1235  CA  GLU A  82      26.291 103.516 -24.489  0.00  0.00           C  
ATOM   1236  C   GLU A  82      26.160 103.187 -23.003  0.00  0.00           C  
ATOM   1237  O   GLU A  82      27.088 103.439 -22.233  0.00  0.00           O  
ATOM   1238  CB  GLU A  82      26.932 102.384 -25.308  0.00  0.00           C  
ATOM   1239  CG  GLU A  82      28.233 101.800 -24.733  0.00  0.00           C  
ATOM   1240  CD  GLU A  82      28.834 100.744 -25.677  0.00  0.00           C  
ATOM   1241  OE1 GLU A  82      28.473  99.549 -25.577  0.00  0.00           O  
ATOM   1242  OE2 GLU A  82      29.688 101.090 -26.526  0.00  0.00           O  
ATOM   1243  H   GLU A  82      27.993 104.740 -24.252  0.00  0.00           H  
ATOM   1244  HA  GLU A  82      25.288 103.672 -24.885  0.00  0.00           H  
ATOM   1245  HB2 GLU A  82      26.206 101.578 -25.413  0.00  0.00           H  
ATOM   1246  HB3 GLU A  82      27.150 102.787 -26.295  0.00  0.00           H  
ATOM   1247  HG2 GLU A  82      28.953 102.605 -24.582  0.00  0.00           H  
ATOM   1248  HG3 GLU A  82      28.031 101.341 -23.763  0.00  0.00           H  
ATOM   1249  N   VAL A  83      25.009 102.648 -22.594  0.00  0.00           N  
ATOM   1250  CA  VAL A  83      24.780 102.148 -21.245  0.00  0.00           C  
ATOM   1251  C   VAL A  83      25.665 100.922 -21.018  0.00  0.00           C  
ATOM   1252  O   VAL A  83      25.805 100.058 -21.887  0.00  0.00           O  
ATOM   1253  CB  VAL A  83      23.265 101.936 -21.007  0.00  0.00           C  
ATOM   1254  CG1 VAL A  83      22.599 100.945 -21.977  0.00  0.00           C  
ATOM   1255  CG2 VAL A  83      22.957 101.525 -19.561  0.00  0.00           C  
ATOM   1256  H   VAL A  83      24.296 102.441 -23.275  0.00  0.00           H  
ATOM   1257  HA  VAL A  83      25.110 102.895 -20.528  0.00  0.00           H  
ATOM   1258  HB  VAL A  83      22.783 102.902 -21.163  0.00  0.00           H  
ATOM   1259 HG11 VAL A  83      23.031  99.951 -21.862  0.00  0.00           H  
ATOM   1260 HG12 VAL A  83      21.530 100.893 -21.769  0.00  0.00           H  
ATOM   1261 HG13 VAL A  83      22.723 101.275 -23.008  0.00  0.00           H  
ATOM   1262 HG21 VAL A  83      23.379 100.544 -19.338  0.00  0.00           H  
ATOM   1263 HG22 VAL A  83      23.370 102.258 -18.869  0.00  0.00           H  
ATOM   1264 HG23 VAL A  83      21.878 101.484 -19.409  0.00  0.00           H  
ATOM   1265  N   VAL A  84      26.255 100.865 -19.826  0.00  0.00           N  
ATOM   1266  CA  VAL A  84      27.138  99.802 -19.374  0.00  0.00           C  
ATOM   1267  C   VAL A  84      26.696  99.271 -18.006  0.00  0.00           C  
ATOM   1268  O   VAL A  84      27.080  98.152 -17.666  0.00  0.00           O  
ATOM   1269  CB  VAL A  84      28.615 100.264 -19.385  0.00  0.00           C  
ATOM   1270  CG1 VAL A  84      29.093 100.617 -20.803  0.00  0.00           C  
ATOM   1271  CG2 VAL A  84      28.892 101.462 -18.463  0.00  0.00           C  
ATOM   1272  H   VAL A  84      26.104 101.635 -19.186  0.00  0.00           H  
ATOM   1273  HA  VAL A  84      27.051  98.966 -20.068  0.00  0.00           H  
ATOM   1274  HB  VAL A  84      29.227  99.430 -19.038  0.00  0.00           H  
ATOM   1275 HG11 VAL A  84      28.892  99.786 -21.479  0.00  0.00           H  
ATOM   1276 HG12 VAL A  84      28.584 101.508 -21.169  0.00  0.00           H  
ATOM   1277 HG13 VAL A  84      30.167 100.806 -20.793  0.00  0.00           H  
ATOM   1278 HG21 VAL A  84      28.591 101.227 -17.440  0.00  0.00           H  
ATOM   1279 HG22 VAL A  84      29.959 101.684 -18.456  0.00  0.00           H  
ATOM   1280 HG23 VAL A  84      28.352 102.342 -18.808  0.00  0.00           H  
ATOM   1281  N   GLU A  85      25.863 100.000 -17.242  0.00  0.00           N  
ATOM   1282  CA  GLU A  85      25.296  99.456 -15.999  0.00  0.00           C  
ATOM   1283  C   GLU A  85      23.966 100.132 -15.644  0.00  0.00           C  
ATOM   1284  O   GLU A  85      23.638 101.200 -16.167  0.00  0.00           O  
ATOM   1285  CB  GLU A  85      26.311  99.572 -14.834  0.00  0.00           C  
ATOM   1286  CG  GLU A  85      26.764  98.222 -14.248  0.00  0.00           C  
ATOM   1287  CD  GLU A  85      25.653  97.444 -13.518  0.00  0.00           C  
ATOM   1288  OE1 GLU A  85      24.631  97.099 -14.151  0.00  0.00           O  
ATOM   1289  OE2 GLU A  85      25.818  97.132 -12.317  0.00  0.00           O  
ATOM   1290  H   GLU A  85      25.554 100.925 -17.549  0.00  0.00           H  
ATOM   1291  HA  GLU A  85      25.081  98.402 -16.174  0.00  0.00           H  
ATOM   1292  HB2 GLU A  85      27.211 100.078 -15.185  0.00  0.00           H  
ATOM   1293  HB3 GLU A  85      25.893 100.178 -14.027  0.00  0.00           H  
ATOM   1294  HG2 GLU A  85      27.172  97.600 -15.045  0.00  0.00           H  
ATOM   1295  HG3 GLU A  85      27.580  98.421 -13.550  0.00  0.00           H  
ATOM   1296  N   THR A  86      23.185  99.511 -14.758  0.00  0.00           N  
ATOM   1297  CA  THR A  86      21.918 100.010 -14.229  0.00  0.00           C  
ATOM   1298  C   THR A  86      21.719  99.441 -12.812  0.00  0.00           C  
ATOM   1299  O   THR A  86      22.040  98.274 -12.564  0.00  0.00           O  
ATOM   1300  CB  THR A  86      20.789  99.580 -15.187  0.00  0.00           C  
ATOM   1301  OG1 THR A  86      20.985 100.167 -16.459  0.00  0.00           O  
ATOM   1302  CG2 THR A  86      19.382  99.947 -14.700  0.00  0.00           C  
ATOM   1303  H   THR A  86      23.493  98.611 -14.387  0.00  0.00           H  
ATOM   1304  HA  THR A  86      21.953 101.096 -14.174  0.00  0.00           H  
ATOM   1305  HB  THR A  86      20.836  98.496 -15.305  0.00  0.00           H  
ATOM   1306  HG1 THR A  86      21.905 100.481 -16.491  0.00  0.00           H  
ATOM   1307 HG21 THR A  86      18.656  99.766 -15.493  0.00  0.00           H  
ATOM   1308 HG22 THR A  86      19.114  99.329 -13.843  0.00  0.00           H  
ATOM   1309 HG23 THR A  86      19.342 100.994 -14.405  0.00  0.00           H  
ATOM   1310  N   SER A  87      21.169 100.241 -11.895  0.00  0.00           N  
ATOM   1311  CA  SER A  87      20.923  99.890 -10.497  0.00  0.00           C  
ATOM   1312  C   SER A  87      19.678 100.643 -10.008  0.00  0.00           C  
ATOM   1313  O   SER A  87      19.349 101.693 -10.557  0.00  0.00           O  
ATOM   1314  CB  SER A  87      22.143 100.281  -9.644  0.00  0.00           C  
ATOM   1315  OG  SER A  87      23.362  99.781 -10.172  0.00  0.00           O  
ATOM   1316  H   SER A  87      20.908 101.190 -12.160  0.00  0.00           H  
ATOM   1317  HA  SER A  87      20.746  98.817 -10.410  0.00  0.00           H  
ATOM   1318  HB2 SER A  87      22.207 101.368  -9.597  0.00  0.00           H  
ATOM   1319  HB3 SER A  87      22.007  99.900  -8.632  0.00  0.00           H  
ATOM   1320  HG  SER A  87      23.281  98.820 -10.264  0.00  0.00           H  
ATOM   1321  N   VAL A  88      18.985 100.149  -8.980  0.00  0.00           N  
ATOM   1322  CA  VAL A  88      17.719 100.725  -8.513  0.00  0.00           C  
ATOM   1323  C   VAL A  88      17.780 100.859  -6.988  0.00  0.00           C  
ATOM   1324  O   VAL A  88      18.420 100.046  -6.312  0.00  0.00           O  
ATOM   1325  CB  VAL A  88      16.531  99.851  -8.995  0.00  0.00           C  
ATOM   1326  CG1 VAL A  88      15.168 100.477  -8.655  0.00  0.00           C  
ATOM   1327  CG2 VAL A  88      16.554  99.612 -10.516  0.00  0.00           C  
ATOM   1328  H   VAL A  88      19.296  99.306  -8.515  0.00  0.00           H  
ATOM   1329  HA  VAL A  88      17.595 101.722  -8.933  0.00  0.00           H  
ATOM   1330  HB  VAL A  88      16.592  98.879  -8.505  0.00  0.00           H  
ATOM   1331 HG11 VAL A  88      14.363  99.854  -9.044  0.00  0.00           H  
ATOM   1332 HG12 VAL A  88      15.040 100.547  -7.575  0.00  0.00           H  
ATOM   1333 HG13 VAL A  88      15.092 101.474  -9.093  0.00  0.00           H  
ATOM   1334 HG21 VAL A  88      17.438  99.045 -10.804  0.00  0.00           H  
ATOM   1335 HG22 VAL A  88      15.678  99.036 -10.818  0.00  0.00           H  
ATOM   1336 HG23 VAL A  88      16.548 100.568 -11.042  0.00  0.00           H  
ATOM   1337  N   GLY A  89      17.113 101.881  -6.447  0.00  0.00           N  
ATOM   1338  CA  GLY A  89      17.006 102.130  -5.016  0.00  0.00           C  
ATOM   1339  C   GLY A  89      18.181 102.954  -4.489  0.00  0.00           C  
ATOM   1340  O   GLY A  89      19.123 103.266  -5.219  0.00  0.00           O  
ATOM   1341  H   GLY A  89      16.675 102.558  -7.068  0.00  0.00           H  
ATOM   1342  HA2 GLY A  89      16.078 102.669  -4.823  0.00  0.00           H  
ATOM   1343  HA3 GLY A  89      16.964 101.182  -4.479  0.00  0.00           H  
ATOM   1344  N   PHE A  90      18.113 103.308  -3.202  0.00  0.00           N  
ATOM   1345  CA  PHE A  90      19.184 103.991  -2.477  0.00  0.00           C  
ATOM   1346  C   PHE A  90      20.464 103.141  -2.479  0.00  0.00           C  
ATOM   1347  O   PHE A  90      20.394 101.911  -2.583  0.00  0.00           O  
ATOM   1348  CB  PHE A  90      18.701 104.272  -1.042  0.00  0.00           C  
ATOM   1349  CG  PHE A  90      19.744 104.882  -0.122  0.00  0.00           C  
ATOM   1350  CD1 PHE A  90      19.979 106.271  -0.141  0.00  0.00           C  
ATOM   1351  CD2 PHE A  90      20.499 104.058   0.737  0.00  0.00           C  
ATOM   1352  CE1 PHE A  90      20.971 106.826   0.687  0.00  0.00           C  
ATOM   1353  CE2 PHE A  90      21.491 104.617   1.562  0.00  0.00           C  
ATOM   1354  CZ  PHE A  90      21.729 106.002   1.535  0.00  0.00           C  
ATOM   1355  H   PHE A  90      17.319 103.000  -2.660  0.00  0.00           H  
ATOM   1356  HA  PHE A  90      19.392 104.940  -2.968  0.00  0.00           H  
ATOM   1357  HB2 PHE A  90      17.843 104.942  -1.088  0.00  0.00           H  
ATOM   1358  HB3 PHE A  90      18.358 103.335  -0.599  0.00  0.00           H  
ATOM   1359  HD1 PHE A  90      19.397 106.910  -0.787  0.00  0.00           H  
ATOM   1360  HD2 PHE A  90      20.325 102.991   0.759  0.00  0.00           H  
ATOM   1361  HE1 PHE A  90      21.155 107.892   0.673  0.00  0.00           H  
ATOM   1362  HE2 PHE A  90      22.072 103.980   2.216  0.00  0.00           H  
ATOM   1363  HZ  PHE A  90      22.493 106.433   2.169  0.00  0.00           H  
ATOM   1364  N   LYS A  91      21.633 103.779  -2.336  0.00  0.00           N  
ATOM   1365  CA  LYS A  91      22.904 103.108  -2.066  0.00  0.00           C  
ATOM   1366  C   LYS A  91      23.695 103.967  -1.085  0.00  0.00           C  
ATOM   1367  O   LYS A  91      23.629 105.194  -1.188  0.00  0.00           O  
ATOM   1368  CB  LYS A  91      23.775 102.898  -3.322  0.00  0.00           C  
ATOM   1369  CG  LYS A  91      23.389 101.643  -4.110  0.00  0.00           C  
ATOM   1370  CD  LYS A  91      22.387 101.970  -5.230  0.00  0.00           C  
ATOM   1371  CE  LYS A  91      21.622 100.755  -5.769  0.00  0.00           C  
ATOM   1372  NZ  LYS A  91      20.769 100.103  -4.744  0.00  0.00           N  
ATOM   1373  H   LYS A  91      21.637 104.783  -2.199  0.00  0.00           H  
ATOM   1374  HA  LYS A  91      22.682 102.148  -1.603  0.00  0.00           H  
ATOM   1375  HB2 LYS A  91      23.760 103.785  -3.958  0.00  0.00           H  
ATOM   1376  HB3 LYS A  91      24.807 102.754  -2.997  0.00  0.00           H  
ATOM   1377  HG2 LYS A  91      24.292 101.222  -4.556  0.00  0.00           H  
ATOM   1378  HG3 LYS A  91      22.993 100.906  -3.410  0.00  0.00           H  
ATOM   1379  HD2 LYS A  91      21.668 102.707  -4.882  0.00  0.00           H  
ATOM   1380  HD3 LYS A  91      22.935 102.428  -6.054  0.00  0.00           H  
ATOM   1381  HE2 LYS A  91      20.975 101.107  -6.579  0.00  0.00           H  
ATOM   1382  HE3 LYS A  91      22.324 100.029  -6.186  0.00  0.00           H  
ATOM   1383  HZ1 LYS A  91      21.260  99.354  -4.279  0.00  0.00           H  
ATOM   1384  HZ2 LYS A  91      20.473 100.771  -4.038  0.00  0.00           H  
ATOM   1385  HZ3 LYS A  91      19.934  99.725  -5.183  0.00  0.00           H  
ATOM   1386  N   PRO A  92      24.471 103.347  -0.183  0.00  0.00           N  
ATOM   1387  CA  PRO A  92      25.428 104.058   0.647  0.00  0.00           C  
ATOM   1388  C   PRO A  92      26.618 104.515  -0.208  0.00  0.00           C  
ATOM   1389  O   PRO A  92      26.882 103.953  -1.276  0.00  0.00           O  
ATOM   1390  CB  PRO A  92      25.832 103.041   1.714  0.00  0.00           C  
ATOM   1391  CG  PRO A  92      25.732 101.698   0.998  0.00  0.00           C  
ATOM   1392  CD  PRO A  92      24.551 101.909   0.053  0.00  0.00           C  
ATOM   1393  HA  PRO A  92      24.956 104.923   1.117  0.00  0.00           H  
ATOM   1394  HB2 PRO A  92      26.835 103.216   2.095  0.00  0.00           H  
ATOM   1395  HB3 PRO A  92      25.094 103.061   2.515  0.00  0.00           H  
ATOM   1396  HG2 PRO A  92      26.642 101.522   0.428  0.00  0.00           H  
ATOM   1397  HG3 PRO A  92      25.550 100.878   1.695  0.00  0.00           H  
ATOM   1398  HD2 PRO A  92      24.710 101.361  -0.876  0.00  0.00           H  
ATOM   1399  HD3 PRO A  92      23.631 101.573   0.535  0.00  0.00           H  
ATOM   1400  N   LYS A  93      27.372 105.505   0.289  0.00  0.00           N  
ATOM   1401  CA  LYS A  93      28.520 106.065  -0.429  0.00  0.00           C  
ATOM   1402  C   LYS A  93      29.514 104.980  -0.804  0.00  0.00           C  
ATOM   1403  O   LYS A  93      29.957 104.955  -1.947  0.00  0.00           O  
ATOM   1404  CB  LYS A  93      29.196 107.168   0.413  0.00  0.00           C  
ATOM   1405  CG  LYS A  93      30.413 107.780  -0.302  0.00  0.00           C  
ATOM   1406  CD  LYS A  93      31.121 108.811   0.583  0.00  0.00           C  
ATOM   1407  CE  LYS A  93      32.433 109.219  -0.098  0.00  0.00           C  
ATOM   1408  NZ  LYS A  93      33.142 110.289   0.642  0.00  0.00           N  
ATOM   1409  H   LYS A  93      27.121 105.913   1.179  0.00  0.00           H  
ATOM   1410  HA  LYS A  93      28.161 106.504  -1.361  0.00  0.00           H  
ATOM   1411  HB2 LYS A  93      28.479 107.962   0.618  0.00  0.00           H  
ATOM   1412  HB3 LYS A  93      29.528 106.746   1.363  0.00  0.00           H  
ATOM   1413  HG2 LYS A  93      31.131 106.995  -0.540  0.00  0.00           H  
ATOM   1414  HG3 LYS A  93      30.089 108.255  -1.230  0.00  0.00           H  
ATOM   1415  HD2 LYS A  93      30.475 109.680   0.719  0.00  0.00           H  
ATOM   1416  HD3 LYS A  93      31.343 108.372   1.557  0.00  0.00           H  
ATOM   1417  HE2 LYS A  93      33.067 108.330  -0.179  0.00  0.00           H  
ATOM   1418  HE3 LYS A  93      32.209 109.562  -1.111  0.00  0.00           H  
ATOM   1419  HZ1 LYS A  93      33.369 109.998   1.581  0.00  0.00           H  
ATOM   1420  HZ2 LYS A  93      34.018 110.525   0.173  0.00  0.00           H  
ATOM   1421  HZ3 LYS A  93      32.574 111.138   0.701  0.00  0.00           H  
ATOM   1422  N   GLU A  94      29.878 104.099   0.130  0.00  0.00           N  
ATOM   1423  CA  GLU A  94      30.972 103.167  -0.079  0.00  0.00           C  
ATOM   1424  C   GLU A  94      30.652 102.207  -1.223  0.00  0.00           C  
ATOM   1425  O   GLU A  94      31.494 101.993  -2.098  0.00  0.00           O  
ATOM   1426  CB  GLU A  94      31.257 102.441   1.244  0.00  0.00           C  
ATOM   1427  CG  GLU A  94      32.544 101.620   1.158  0.00  0.00           C  
ATOM   1428  CD  GLU A  94      32.877 100.938   2.497  0.00  0.00           C  
ATOM   1429  OE1 GLU A  94      32.418  99.798   2.737  0.00  0.00           O  
ATOM   1430  OE2 GLU A  94      33.616 101.526   3.320  0.00  0.00           O  
ATOM   1431  H   GLU A  94      29.491 104.154   1.057  0.00  0.00           H  
ATOM   1432  HA  GLU A  94      31.848 103.748  -0.367  0.00  0.00           H  
ATOM   1433  HB2 GLU A  94      31.370 103.181   2.038  0.00  0.00           H  
ATOM   1434  HB3 GLU A  94      30.419 101.788   1.493  0.00  0.00           H  
ATOM   1435  HG2 GLU A  94      32.434 100.865   0.378  0.00  0.00           H  
ATOM   1436  HG3 GLU A  94      33.355 102.291   0.870  0.00  0.00           H  
ATOM   1437  N   ALA A  95      29.422 101.691  -1.259  0.00  0.00           N  
ATOM   1438  CA  ALA A  95      28.965 100.818  -2.326  0.00  0.00           C  
ATOM   1439  C   ALA A  95      28.923 101.565  -3.654  0.00  0.00           C  
ATOM   1440  O   ALA A  95      29.344 101.027  -4.676  0.00  0.00           O  
ATOM   1441  CB  ALA A  95      27.567 100.298  -2.002  0.00  0.00           C  
ATOM   1442  H   ALA A  95      28.767 101.939  -0.535  0.00  0.00           H  
ATOM   1443  HA  ALA A  95      29.655  99.980  -2.408  0.00  0.00           H  
ATOM   1444  HB1 ALA A  95      27.242  99.626  -2.795  0.00  0.00           H  
ATOM   1445  HB2 ALA A  95      27.579  99.760  -1.056  0.00  0.00           H  
ATOM   1446  HB3 ALA A  95      26.876 101.141  -1.950  0.00  0.00           H  
ATOM   1447  N   LEU A  96      28.418 102.800  -3.652  0.00  0.00           N  
ATOM   1448  CA  LEU A  96      28.271 103.584  -4.865  0.00  0.00           C  
ATOM   1449  C   LEU A  96      29.640 103.933  -5.441  0.00  0.00           C  
ATOM   1450  O   LEU A  96      29.834 103.811  -6.647  0.00  0.00           O  
ATOM   1451  CB  LEU A  96      27.427 104.838  -4.586  0.00  0.00           C  
ATOM   1452  CG  LEU A  96      27.159 105.687  -5.846  0.00  0.00           C  
ATOM   1453  CD1 LEU A  96      26.465 104.897  -6.963  0.00  0.00           C  
ATOM   1454  CD2 LEU A  96      26.290 106.893  -5.474  0.00  0.00           C  
ATOM   1455  H   LEU A  96      28.085 103.196  -2.783  0.00  0.00           H  
ATOM   1456  HA  LEU A  96      27.743 102.958  -5.582  0.00  0.00           H  
ATOM   1457  HB2 LEU A  96      26.471 104.529  -4.158  0.00  0.00           H  
ATOM   1458  HB3 LEU A  96      27.942 105.457  -3.849  0.00  0.00           H  
ATOM   1459  HG  LEU A  96      28.106 106.060  -6.232  0.00  0.00           H  
ATOM   1460 HD11 LEU A  96      26.215 105.568  -7.782  0.00  0.00           H  
ATOM   1461 HD12 LEU A  96      27.132 104.133  -7.357  0.00  0.00           H  
ATOM   1462 HD13 LEU A  96      25.554 104.430  -6.587  0.00  0.00           H  
ATOM   1463 HD21 LEU A  96      25.330 106.563  -5.073  0.00  0.00           H  
ATOM   1464 HD22 LEU A  96      26.801 107.494  -4.725  0.00  0.00           H  
ATOM   1465 HD23 LEU A  96      26.119 107.512  -6.354  0.00  0.00           H  
ATOM   1466  N   GLN A  97      30.613 104.318  -4.607  0.00  0.00           N  
ATOM   1467  CA  GLN A  97      31.939 104.646  -5.117  0.00  0.00           C  
ATOM   1468  C   GLN A  97      32.675 103.379  -5.545  0.00  0.00           C  
ATOM   1469  O   GLN A  97      33.467 103.432  -6.483  0.00  0.00           O  
ATOM   1470  CB  GLN A  97      32.742 105.552  -4.166  0.00  0.00           C  
ATOM   1471  CG  GLN A  97      33.179 104.932  -2.832  0.00  0.00           C  
ATOM   1472  CD  GLN A  97      34.403 104.020  -2.920  0.00  0.00           C  
ATOM   1473  OE1 GLN A  97      35.493 104.439  -3.297  0.00  0.00           O  
ATOM   1474  NE2 GLN A  97      34.245 102.761  -2.554  0.00  0.00           N  
ATOM   1475  H   GLN A  97      30.435 104.367  -3.607  0.00  0.00           H  
ATOM   1476  HA  GLN A  97      31.778 105.231  -6.017  0.00  0.00           H  
ATOM   1477  HB2 GLN A  97      33.625 105.914  -4.690  0.00  0.00           H  
ATOM   1478  HB3 GLN A  97      32.127 106.423  -3.941  0.00  0.00           H  
ATOM   1479  HG2 GLN A  97      33.410 105.736  -2.136  0.00  0.00           H  
ATOM   1480  HG3 GLN A  97      32.345 104.373  -2.428  0.00  0.00           H  
ATOM   1481 HE21 GLN A  97      33.314 102.417  -2.317  0.00  0.00           H  
ATOM   1482 HE22 GLN A  97      35.026 102.125  -2.572  0.00  0.00           H  
ATOM   1483  N   GLU A  98      32.394 102.228  -4.922  0.00  0.00           N  
ATOM   1484  CA  GLU A  98      32.965 100.964  -5.355  0.00  0.00           C  
ATOM   1485  C   GLU A  98      32.409 100.647  -6.746  0.00  0.00           C  
ATOM   1486  O   GLU A  98      33.173 100.417  -7.680  0.00  0.00           O  
ATOM   1487  CB  GLU A  98      32.653  99.861  -4.330  0.00  0.00           C  
ATOM   1488  CG  GLU A  98      33.280  98.508  -4.688  0.00  0.00           C  
ATOM   1489  CD  GLU A  98      34.817  98.511  -4.573  0.00  0.00           C  
ATOM   1490  OE1 GLU A  98      35.343  98.447  -3.438  0.00  0.00           O  
ATOM   1491  OE2 GLU A  98      35.504  98.555  -5.616  0.00  0.00           O  
ATOM   1492  H   GLU A  98      31.744 102.211  -4.145  0.00  0.00           H  
ATOM   1493  HA  GLU A  98      34.044 101.093  -5.415  0.00  0.00           H  
ATOM   1494  HB2 GLU A  98      33.019 100.167  -3.350  0.00  0.00           H  
ATOM   1495  HB3 GLU A  98      31.574  99.730  -4.258  0.00  0.00           H  
ATOM   1496  HG2 GLU A  98      32.874  97.754  -4.010  0.00  0.00           H  
ATOM   1497  HG3 GLU A  98      32.971  98.231  -5.697  0.00  0.00           H  
ATOM   1498  N   LEU A  99      31.086 100.739  -6.906  0.00  0.00           N  
ATOM   1499  CA  LEU A  99      30.413 100.503  -8.180  0.00  0.00           C  
ATOM   1500  C   LEU A  99      30.994 101.408  -9.267  0.00  0.00           C  
ATOM   1501  O   LEU A  99      31.274 100.935 -10.369  0.00  0.00           O  
ATOM   1502  CB  LEU A  99      28.897 100.722  -8.018  0.00  0.00           C  
ATOM   1503  CG  LEU A  99      28.092 100.637  -9.332  0.00  0.00           C  
ATOM   1504  CD1 LEU A  99      28.202  99.259  -9.997  0.00  0.00           C  
ATOM   1505  CD2 LEU A  99      26.619 100.946  -9.043  0.00  0.00           C  
ATOM   1506  H   LEU A  99      30.528 100.995  -6.094  0.00  0.00           H  
ATOM   1507  HA  LEU A  99      30.593  99.468  -8.470  0.00  0.00           H  
ATOM   1508  HB2 LEU A  99      28.512  99.984  -7.313  0.00  0.00           H  
ATOM   1509  HB3 LEU A  99      28.733 101.708  -7.588  0.00  0.00           H  
ATOM   1510  HG  LEU A  99      28.453 101.392 -10.031  0.00  0.00           H  
ATOM   1511 HD11 LEU A  99      29.230  99.068 -10.304  0.00  0.00           H  
ATOM   1512 HD12 LEU A  99      27.881  98.480  -9.306  0.00  0.00           H  
ATOM   1513 HD13 LEU A  99      27.574  99.229 -10.887  0.00  0.00           H  
ATOM   1514 HD21 LEU A  99      26.046 100.922  -9.971  0.00  0.00           H  
ATOM   1515 HD22 LEU A  99      26.206 100.214  -8.350  0.00  0.00           H  
ATOM   1516 HD23 LEU A  99      26.527 101.942  -8.609  0.00  0.00           H  
ATOM   1517  N   VAL A 100      31.204 102.689  -8.955  0.00  0.00           N  
ATOM   1518  CA  VAL A 100      31.725 103.636  -9.925  0.00  0.00           C  
ATOM   1519  C   VAL A 100      33.182 103.310 -10.266  0.00  0.00           C  
ATOM   1520  O   VAL A 100      33.524 103.223 -11.445  0.00  0.00           O  
ATOM   1521  CB  VAL A 100      31.522 105.085  -9.433  0.00  0.00           C  
ATOM   1522  CG1 VAL A 100      32.306 106.092 -10.283  0.00  0.00           C  
ATOM   1523  CG2 VAL A 100      30.034 105.473  -9.498  0.00  0.00           C  
ATOM   1524  H   VAL A 100      30.927 103.031  -8.043  0.00  0.00           H  
ATOM   1525  HA  VAL A 100      31.140 103.495 -10.828  0.00  0.00           H  
ATOM   1526  HB  VAL A 100      31.866 105.166  -8.401  0.00  0.00           H  
ATOM   1527 HG11 VAL A 100      33.377 105.961 -10.134  0.00  0.00           H  
ATOM   1528 HG12 VAL A 100      32.084 105.929 -11.336  0.00  0.00           H  
ATOM   1529 HG13 VAL A 100      32.046 107.112  -9.999  0.00  0.00           H  
ATOM   1530 HG21 VAL A 100      29.891 106.464  -9.069  0.00  0.00           H  
ATOM   1531 HG22 VAL A 100      29.698 105.479 -10.535  0.00  0.00           H  
ATOM   1532 HG23 VAL A 100      29.425 104.764  -8.943  0.00  0.00           H  
ATOM   1533  N   ASN A 101      34.055 103.104  -9.271  0.00  0.00           N  
ATOM   1534  CA  ASN A 101      35.486 102.918  -9.536  0.00  0.00           C  
ATOM   1535  C   ASN A 101      35.755 101.674 -10.381  0.00  0.00           C  
ATOM   1536  O   ASN A 101      36.723 101.647 -11.140  0.00  0.00           O  
ATOM   1537  CB  ASN A 101      36.338 102.950  -8.255  0.00  0.00           C  
ATOM   1538  CG  ASN A 101      36.788 101.584  -7.744  0.00  0.00           C  
ATOM   1539  OD1 ASN A 101      37.956 101.219  -7.830  0.00  0.00           O  
ATOM   1540  ND2 ASN A 101      35.867 100.826  -7.187  0.00  0.00           N  
ATOM   1541  H   ASN A 101      33.735 103.164  -8.308  0.00  0.00           H  
ATOM   1542  HA  ASN A 101      35.794 103.770 -10.134  0.00  0.00           H  
ATOM   1543  HB2 ASN A 101      37.232 103.536  -8.468  0.00  0.00           H  
ATOM   1544  HB3 ASN A 101      35.792 103.459  -7.465  0.00  0.00           H  
ATOM   1545 HD21 ASN A 101      34.889 101.098  -7.217  0.00  0.00           H  
ATOM   1546 HD22 ASN A 101      36.079  99.926  -6.748  0.00  0.00           H  
ATOM   1547  N   LYS A 102      34.873 100.672 -10.301  0.00  0.00           N  
ATOM   1548  CA  LYS A 102      34.949  99.476 -11.132  0.00  0.00           C  
ATOM   1549  C   LYS A 102      34.740  99.763 -12.625  0.00  0.00           C  
ATOM   1550  O   LYS A 102      35.178  98.943 -13.432  0.00  0.00           O  
ATOM   1551  CB  LYS A 102      33.955  98.416 -10.627  0.00  0.00           C  
ATOM   1552  CG  LYS A 102      34.460  97.738  -9.344  0.00  0.00           C  
ATOM   1553  CD  LYS A 102      33.418  96.763  -8.781  0.00  0.00           C  
ATOM   1554  CE  LYS A 102      33.994  96.038  -7.558  0.00  0.00           C  
ATOM   1555  NZ  LYS A 102      33.034  95.065  -6.976  0.00  0.00           N  
ATOM   1556  H   LYS A 102      34.118 100.759  -9.629  0.00  0.00           H  
ATOM   1557  HA  LYS A 102      35.960  99.080 -11.032  0.00  0.00           H  
ATOM   1558  HB2 LYS A 102      32.982  98.877 -10.448  0.00  0.00           H  
ATOM   1559  HB3 LYS A 102      33.832  97.646 -11.390  0.00  0.00           H  
ATOM   1560  HG2 LYS A 102      35.376  97.191  -9.573  0.00  0.00           H  
ATOM   1561  HG3 LYS A 102      34.688  98.490  -8.589  0.00  0.00           H  
ATOM   1562  HD2 LYS A 102      32.525  97.322  -8.493  0.00  0.00           H  
ATOM   1563  HD3 LYS A 102      33.156  96.033  -9.550  0.00  0.00           H  
ATOM   1564  HE2 LYS A 102      34.904  95.513  -7.860  0.00  0.00           H  
ATOM   1565  HE3 LYS A 102      34.271  96.781  -6.807  0.00  0.00           H  
ATOM   1566  HZ1 LYS A 102      32.185  95.515  -6.674  0.00  0.00           H  
ATOM   1567  HZ2 LYS A 102      32.791  94.348  -7.645  0.00  0.00           H  
ATOM   1568  HZ3 LYS A 102      33.439  94.601  -6.175  0.00  0.00           H  
ATOM   1569  N   HIS A 103      34.123 100.887 -13.018  0.00  0.00           N  
ATOM   1570  CA  HIS A 103      33.877 101.215 -14.426  0.00  0.00           C  
ATOM   1571  C   HIS A 103      34.607 102.481 -14.895  0.00  0.00           C  
ATOM   1572  O   HIS A 103      34.411 102.888 -16.044  0.00  0.00           O  
ATOM   1573  CB  HIS A 103      32.366 101.298 -14.684  0.00  0.00           C  
ATOM   1574  CG  HIS A 103      31.698 102.507 -14.080  0.00  0.00           C  
ATOM   1575  ND1 HIS A 103      31.945 103.820 -14.403  0.00  0.00           N  
ATOM   1576  CD2 HIS A 103      30.676 102.504 -13.171  0.00  0.00           C  
ATOM   1577  CE1 HIS A 103      31.106 104.591 -13.695  0.00  0.00           C  
ATOM   1578  NE2 HIS A 103      30.291 103.835 -12.948  0.00  0.00           N  
ATOM   1579  H   HIS A 103      33.727 101.521 -12.325  0.00  0.00           H  
ATOM   1580  HA  HIS A 103      34.251 100.408 -15.057  0.00  0.00           H  
ATOM   1581  HB2 HIS A 103      32.200 101.325 -15.762  0.00  0.00           H  
ATOM   1582  HB3 HIS A 103      31.893 100.396 -14.296  0.00  0.00           H  
ATOM   1583  HD1 HIS A 103      32.638 104.146 -15.067  0.00  0.00           H  
ATOM   1584  HD2 HIS A 103      30.222 101.623 -12.739  0.00  0.00           H  
ATOM   1585  HE1 HIS A 103      31.065 105.671 -13.743  0.00  0.00           H  
ATOM   1586  N   LEU A 104      35.413 103.134 -14.052  0.00  0.00           N  
ATOM   1587  CA  LEU A 104      36.292 104.214 -14.493  0.00  0.00           C  
ATOM   1588  C   LEU A 104      37.282 103.638 -15.501  0.00  0.00           C  
ATOM   1589  O   LEU A 104      37.335 104.137 -16.644  0.00  0.00           O  
ATOM   1590  CB  LEU A 104      37.026 104.880 -13.316  0.00  0.00           C  
ATOM   1591  CG  LEU A 104      36.137 105.702 -12.362  0.00  0.00           C  
ATOM   1592  CD1 LEU A 104      36.990 106.262 -11.219  0.00  0.00           C  
ATOM   1593  CD2 LEU A 104      35.418 106.859 -13.064  0.00  0.00           C  
ATOM   1594  OXT LEU A 104      37.994 102.670 -15.155  0.00  0.00           O  
ATOM   1595  H   LEU A 104      35.532 102.783 -13.116  0.00  0.00           H  
ATOM   1596  HA  LEU A 104      35.683 104.953 -15.002  0.00  0.00           H  
ATOM   1597  HB2 LEU A 104      37.545 104.106 -12.748  0.00  0.00           H  
ATOM   1598  HB3 LEU A 104      37.789 105.542 -13.731  0.00  0.00           H  
ATOM   1599  HG  LEU A 104      35.383 105.048 -11.930  0.00  0.00           H  
ATOM   1600 HD11 LEU A 104      37.494 105.449 -10.696  0.00  0.00           H  
ATOM   1601 HD12 LEU A 104      37.740 106.948 -11.611  0.00  0.00           H  
ATOM   1602 HD13 LEU A 104      36.355 106.791 -10.506  0.00  0.00           H  
ATOM   1603 HD21 LEU A 104      36.132 107.482 -13.603  0.00  0.00           H  
ATOM   1604 HD22 LEU A 104      34.682 106.468 -13.762  0.00  0.00           H  
ATOM   1605 HD23 LEU A 104      34.891 107.469 -12.329  0.00  0.00           H  
TER    1606      LEU A 104                                                      
END
MOLECULE T0458.pdb
ATOM   1307  N   THR    12      35.233 112.701 -19.135  1.00 39.16           N  
ATOM   1308  CA  THR    12      35.143 111.676 -20.213  1.00 38.90           C  
ATOM   1309  C   THR    12      34.112 110.567 -19.899  1.00 40.96           C  
ATOM   1310  O   THR    12      33.648 109.876 -20.805  1.00 39.76           O  
ATOM   1311  CB  THR    12      36.539 111.055 -20.467  1.00 36.99           C  
ATOM   1312  OG1 THR    12      36.541 110.386 -21.728  1.00 33.73           O  
ATOM   1313  CG2 THR    12      36.902 110.062 -19.365  1.00 36.11           C  
ATOM   1314  N   HIS    13      33.754 110.409 -18.620  1.00 42.95           N  
ATOM   1315  CA  HIS    13      32.768 109.405 -18.186  1.00 42.37           C  
ATOM   1316  C   HIS    13      31.481 110.051 -17.638  1.00 39.31           C  
ATOM   1317  O   HIS    13      31.550 110.916 -16.776  1.00 39.49           O  
ATOM   1318  CB  HIS    13      33.360 108.504 -17.091  1.00 45.88           C  
ATOM   1319  CG  HIS    13      34.163 107.348 -17.608  1.00 45.03           C  
ATOM   1320  ND1 HIS    13      35.476 107.468 -18.010  1.00 45.10           N  
ATOM   1321  CD2 HIS    13      33.840 106.042 -17.763  1.00 38.68           C  
ATOM   1322  CE1 HIS    13      35.928 106.286 -18.388  1.00 40.14           C  
ATOM   1323  NE2 HIS    13      34.955 105.405 -18.249  1.00 41.81           N  
ATOM   1324  N   ARG    14      30.321 109.602 -18.117  1.00 35.30           N  
ATOM   1325  CA  ARG    14      29.012 110.124 -17.694  1.00 33.07           C  
ATOM   1326  C   ARG    14      28.270 109.275 -16.638  1.00 32.17           C  
ATOM   1327  O   ARG    14      28.250 108.043 -16.729  1.00 34.66           O  
ATOM   1328  CB  ARG    14      28.077 110.231 -18.901  1.00 30.55           C  
ATOM   1329  CG  ARG    14      28.092 111.531 -19.645  1.00 41.12           C  
ATOM   1330  CD  ARG    14      26.788 111.725 -20.417  1.00 52.11           C  
ATOM   1331  NE  ARG    14      25.605 111.441 -19.583  1.00 63.25           N  
ATOM   1332  CZ  ARG    14      24.380 111.936 -19.790  1.00 63.42           C  
ATOM   1333  NH1 ARG    14      23.379 111.608 -18.979  1.00 59.81           N  
ATOM   1334  NH2 ARG    14      24.157 112.777 -20.794  1.00 64.54           N  
ATOM   1335  N   VAL    15      27.635 109.920 -15.659  1.00 26.43           N  
ATOM   1336  CA  VAL    15      26.857 109.184 -14.657  1.00 20.22           C  
ATOM   1337  C   VAL    15      25.458 109.762 -14.622  1.00 18.68           C  
ATOM   1338  O   VAL    15      25.276 110.951 -14.811  1.00 24.00           O  
ATOM   1339  CB  VAL    15      27.464 109.273 -13.230  1.00 22.11           C  
ATOM   1340  CG1 VAL    15      26.500 108.673 -12.212  1.00 18.60           C  
ATOM   1341  CG2 VAL    15      28.785 108.521 -13.180  1.00 21.25           C  
ATOM   1342  N   GLN    16      24.465 108.925 -14.388  1.00 18.92           N  
ATOM   1343  CA  GLN    16      23.099 109.404 -14.339  1.00 20.61           C  
ATOM   1344  C   GLN    16      22.377 108.740 -13.172  1.00 20.40           C  
ATOM   1345  O   GLN    16      22.593 107.562 -12.890  1.00 22.85           O  
ATOM   1346  CB  GLN    16      22.400 109.073 -15.655  1.00 23.81           C  
ATOM   1347  CG  GLN    16      20.923 109.356 -15.665  1.00 30.32           C  
ATOM   1348  CD  GLN    16      20.263 108.887 -16.947  1.00 37.44           C  
ATOM   1349  OE1 GLN    16      20.323 107.701 -17.302  1.00 39.95           O  
ATOM   1350  NE2 GLN    16      19.625 109.820 -17.654  1.00 42.41           N  
ATOM   1351  N   ILE    17      21.523 109.495 -12.492  1.00 20.42           N  
ATOM   1352  CA  ILE    17      20.762 108.969 -11.364  1.00 14.91           C  
ATOM   1353  C   ILE    17      19.307 109.239 -11.617  1.00 15.05           C  
ATOM   1354  O   ILE    17      18.911 110.388 -11.727  1.00 24.10           O  
ATOM   1355  CB  ILE    17      21.159 109.676 -10.065  1.00 14.15           C  
ATOM   1356  CG1 ILE    17      22.619 109.367  -9.757  1.00 17.41           C  
ATOM   1357  CG2 ILE    17      20.241 109.271  -8.928  1.00  6.52           C  
ATOM   1358  CD1 ILE    17      23.132 110.054  -8.534  1.00 18.66           C  
ATOM   1359  N   GLU    18      18.506 108.200 -11.739  1.00 12.00           N  
ATOM   1360  CA  GLU    18      17.079 108.398 -11.959  1.00 17.13           C  
ATOM   1361  C   GLU    18      16.341 108.070 -10.650  1.00 19.59           C  
ATOM   1362  O   GLU    18      16.342 106.921 -10.189  1.00 16.11           O  
ATOM   1363  CB  GLU    18      16.612 107.486 -13.089  1.00 22.94           C  
ATOM   1364  CG  GLU    18      15.173 107.698 -13.530  1.00 34.31           C  
ATOM   1365  CD  GLU    18      14.711 106.651 -14.538  1.00 42.81           C  
ATOM   1366  OE1 GLU    18      13.515 106.693 -14.946  1.00 55.33           O  
ATOM   1367  OE2 GLU    18      15.543 105.786 -14.918  1.00 42.86           O  
ATOM   1368  N   TYR    19      15.715 109.083 -10.060  1.00 20.98           N  
ATOM   1369  CA  TYR    19      14.996 108.948  -8.781  1.00 24.62           C  
ATOM   1370  C   TYR    19      13.485 109.146  -8.906  1.00 24.60           C  
ATOM   1371  O   TYR    19      13.041 109.996  -9.668  1.00 23.03           O  
ATOM   1372  CB  TYR    19      15.511 109.999  -7.799  1.00 23.04           C  
ATOM   1373  CG  TYR    19      15.279 111.412  -8.298  1.00 20.84           C  
ATOM   1374  CD1 TYR    19      16.006 111.919  -9.383  1.00 13.93           C  
ATOM   1375  CD2 TYR    19      14.280 112.206  -7.746  1.00 16.88           C  
ATOM   1376  CE1 TYR    19      15.732 113.175  -9.909  1.00 13.50           C  
ATOM   1377  CE2 TYR    19      13.997 113.466  -8.264  1.00 21.62           C  
ATOM   1378  CZ  TYR    19      14.722 113.946  -9.346  1.00 18.13           C  
ATOM   1379  OH  TYR    19      14.429 115.187  -9.864  1.00 14.85           O  
ATOM   1380  N   CYS    20      12.700 108.395  -8.137  1.00 27.92           N  
ATOM   1381  CA  CYS    20      11.250 108.540  -8.199  1.00 32.48           C  
ATOM   1382  C   CYS    20      10.873 109.894  -7.620  1.00 33.70           C  
ATOM   1383  O   CYS    20      11.123 110.189  -6.453  1.00 33.30           O  
ATOM   1384  CB  CYS    20      10.545 107.395  -7.441  1.00 39.40           C  
ATOM   1385  SG  CYS    20       8.812 107.705  -6.905  1.00 47.94           S  
ATOM   1386  N   THR    21      10.281 110.721  -8.466  1.00 36.58           N  
ATOM   1387  CA  THR    21       9.877 112.061  -8.087  1.00 39.46           C  
ATOM   1388  C   THR    21       8.732 112.041  -7.063  1.00 40.19           C  
ATOM   1389  O   THR    21       8.768 112.759  -6.064  1.00 39.98           O  
ATOM   1390  CB  THR    21       9.483 112.862  -9.360  1.00 39.20           C  
ATOM   1391  OG1 THR    21       9.033 114.168  -8.998  1.00 45.36           O  
ATOM   1392  CG2 THR    21       8.379 112.139 -10.119  1.00 44.44           C  
ATOM   1393  N   GLN    22       7.732 111.200  -7.296  1.00 41.06           N  
ATOM   1394  CA  GLN    22       6.587 111.110  -6.391  1.00 44.27           C  
ATOM   1395  C   GLN    22       6.982 110.661  -4.978  1.00 44.35           C  
ATOM   1396  O   GLN    22       6.388 111.081  -3.978  1.00 40.32           O  
ATOM   1397  CB  GLN    22       5.547 110.146  -6.968  1.00 49.73           C  
ATOM   1398  CG  GLN    22       5.202 110.406  -8.431  1.00 57.57           C  
ATOM   1399  CD  GLN    22       4.559 111.763  -8.654  1.00 63.63           C  
ATOM   1400  OE1 GLN    22       3.488 112.051  -8.111  1.00 68.32           O  
ATOM   1401  NE2 GLN    22       5.209 112.607  -9.460  1.00 65.91           N  
ATOM   1402  N   CYS    23       7.996 109.812  -4.901  1.00 43.84           N  
ATOM   1403  CA  CYS    23       8.474 109.301  -3.622  1.00 41.93           C  
ATOM   1404  C   CYS    23       9.292 110.351  -2.850  1.00 39.32           C  
ATOM   1405  O   CYS    23       9.830 110.054  -1.788  1.00 36.69           O  
ATOM   1406  CB  CYS    23       9.341 108.061  -3.859  1.00 41.55           C  
ATOM   1407  SG  CYS    23       8.704 106.833  -5.047  1.00 53.71           S  
ATOM   1408  N   ARG    24       9.384 111.568  -3.382  1.00 36.78           N  
ATOM   1409  CA  ARG    24      10.159 112.625  -2.730  1.00 37.41           C  
ATOM   1410  C   ARG    24      11.608 112.157  -2.517  1.00 36.10           C  
ATOM   1411  O   ARG    24      12.173 112.325  -1.433  1.00 35.46           O  
ATOM   1412  CB  ARG    24       9.543 112.996  -1.366  1.00 39.04           C  
ATOM   1413  CG  ARG    24       8.055 113.365  -1.394  1.00 48.84           C  
ATOM   1414  CD  ARG    24       7.771 114.873  -1.434  1.00 54.67           C  
ATOM   1415  NE  ARG    24       7.980 115.487  -2.751  1.00 62.77           N  
ATOM   1416  CZ  ARG    24       7.809 116.785  -3.010  1.00 66.70           C  
ATOM   1417  NH1 ARG    24       7.423 117.614  -2.042  1.00 68.58           N  
ATOM   1418  NH2 ARG    24       8.024 117.260  -4.235  1.00 63.77           N  
ATOM   1419  N   TRP    25      12.210 111.575  -3.550  1.00 30.49           N  
ATOM   1420  CA  TRP    25      13.576 111.081  -3.434  1.00 27.73           C  
ATOM   1421  C   TRP    25      14.638 111.992  -4.059  1.00 26.32           C  
ATOM   1422  O   TRP    25      15.796 111.592  -4.273  1.00 21.86           O  
ATOM   1423  CB  TRP    25      13.697 109.677  -4.032  1.00 24.28           C  
ATOM   1424  CG  TRP    25      13.115 108.585  -3.175  1.00 26.51           C  
ATOM   1425  CD1 TRP    25      12.754 108.672  -1.866  1.00 22.11           C  
ATOM   1426  CD2 TRP    25      12.862 107.226  -3.572  1.00 27.33           C  
ATOM   1427  NE1 TRP    25      12.293 107.453  -1.421  1.00 25.73           N  
ATOM   1428  CE2 TRP    25      12.346 106.551  -2.449  1.00 23.98           C  
ATOM   1429  CE3 TRP    25      13.026 106.518  -4.770  1.00 25.78           C  
ATOM   1430  CZ2 TRP    25      11.987 105.210  -2.485  1.00 25.25           C  
ATOM   1431  CZ3 TRP    25      12.672 105.179  -4.807  1.00 27.16           C  
ATOM   1432  CH2 TRP    25      12.156 104.539  -3.669  1.00 28.13           C  
ATOM   1433  N   LEU    26      14.242 113.223  -4.340  1.00 23.87           N  
ATOM   1434  CA  LEU    26      15.151 114.188  -4.917  1.00 24.08           C  
ATOM   1435  C   LEU    26      16.310 114.425  -3.957  1.00 24.23           C  
ATOM   1436  O   LEU    26      17.486 114.364  -4.336  1.00 24.06           O  
ATOM   1437  CB  LEU    26      14.431 115.512  -5.188  1.00 18.76           C  
ATOM   1438  CG  LEU    26      15.326 116.672  -5.637  1.00 15.92           C  
ATOM   1439  CD1 LEU    26      16.110 116.290  -6.882  1.00 15.11           C  
ATOM   1440  CD2 LEU    26      14.477 117.874  -5.902  1.00 18.44           C  
ATOM   1441  N   PRO    27      16.000 114.705  -2.691  1.00 25.42           N  
ATOM   1442  CA  PRO    27      17.095 114.936  -1.749  1.00 25.47           C  
ATOM   1443  C   PRO    27      18.144 113.820  -1.668  1.00 20.34           C  
ATOM   1444  O   PRO    27      19.333 114.107  -1.643  1.00 20.35           O  
ATOM   1445  CB  PRO    27      16.369 115.172  -0.420  1.00 22.29           C  
ATOM   1446  CG  PRO    27      15.083 114.437  -0.586  1.00 28.33           C  
ATOM   1447  CD  PRO    27      14.701 114.788  -2.008  1.00 27.68           C  
ATOM   1448  N   ARG    28      17.734 112.557  -1.640  1.00 20.83           N  
ATOM   1449  CA  ARG    28      18.731 111.490  -1.556  1.00 22.05           C  
ATOM   1450  C   ARG    28      19.484 111.317  -2.873  1.00 23.44           C  
ATOM   1451  O   ARG    28      20.633 110.855  -2.898  1.00 19.09           O  
ATOM   1452  CB  ARG    28      18.090 110.162  -1.140  1.00 22.56           C  
ATOM   1453  CG  ARG    28      17.134 109.566  -2.148  1.00 26.08           C  
ATOM   1454  CD  ARG    28      16.553 108.280  -1.589  1.00 27.46           C  
ATOM   1455  NE  ARG    28      15.820 108.536  -0.353  1.00 32.39           N  
ATOM   1456  CZ  ARG    28      15.228 107.600   0.383  1.00 31.09           C  
ATOM   1457  NH1 ARG    28      15.285 106.329   0.009  1.00 33.28           N  
ATOM   1458  NH2 ARG    28      14.570 107.936   1.488  1.00 26.89           N  
ATOM   1459  N   ALA    29      18.822 111.664  -3.974  1.00 23.48           N  
ATOM   1460  CA  ALA    29      19.446 111.595  -5.290  1.00 16.24           C  
ATOM   1461  C   ALA    29      20.522 112.673  -5.320  1.00 16.53           C  
ATOM   1462  O   ALA    29      21.648 112.430  -5.749  1.00 17.05           O  
ATOM   1463  CB  ALA    29      18.424 111.863  -6.352  1.00 11.90           C  
ATOM   1464  N   ALA    30      20.164 113.866  -4.840  1.00 15.58           N  
ATOM   1465  CA  ALA    30      21.089 114.990  -4.798  1.00 12.15           C  
ATOM   1466  C   ALA    30      22.292 114.672  -3.919  1.00 13.81           C  
ATOM   1467  O   ALA    30      23.417 115.024  -4.245  1.00 17.93           O  
ATOM   1468  CB  ALA    30      20.387 116.217  -4.291  1.00  7.14           C  
ATOM   1469  N   TRP    31      22.050 113.988  -2.810  1.00 14.83           N  
ATOM   1470  CA  TRP    31      23.113 113.629  -1.904  1.00 13.24           C  
ATOM   1471  C   TRP    31      24.094 112.688  -2.569  1.00 16.56           C  
ATOM   1472  O   TRP    31      25.307 112.883  -2.482  1.00 18.69           O  
ATOM   1473  CB  TRP    31      22.532 112.968  -0.671  1.00 14.12           C  
ATOM   1474  CG  TRP    31      23.522 112.170   0.067  1.00 15.03           C  
ATOM   1475  CD1 TRP    31      24.635 112.625   0.710  1.00 13.81           C  
ATOM   1476  CD2 TRP    31      23.549 110.754   0.169  1.00 15.91           C  
ATOM   1477  NE1 TRP    31      25.360 111.573   1.201  1.00 17.25           N  
ATOM   1478  CE2 TRP    31      24.716 110.411   0.883  1.00 17.90           C  
ATOM   1479  CE3 TRP    31      22.703 109.739  -0.279  1.00 18.37           C  
ATOM   1480  CZ2 TRP    31      25.064 109.090   1.157  1.00 24.19           C  
ATOM   1481  CZ3 TRP    31      23.043 108.431  -0.012  1.00 25.80           C  
ATOM   1482  CH2 TRP    31      24.219 108.112   0.701  1.00 26.58           C  
ATOM   1483  N   LEU    32      23.570 111.652  -3.218  1.00 21.85           N  
ATOM   1484  CA  LEU    32      24.410 110.665  -3.908  1.00 22.79           C  
ATOM   1485  C   LEU    32      25.228 111.350  -5.001  1.00 25.24           C  
ATOM   1486  O   LEU    32      26.412 111.029  -5.216  1.00 27.20           O  
ATOM   1487  CB  LEU    32      23.551 109.584  -4.553  1.00 22.61           C  
ATOM   1488  CG  LEU    32      24.006 108.123  -4.413  1.00 24.51           C  
ATOM   1489  CD1 LEU    32      23.323 107.306  -5.521  1.00 25.19           C  
ATOM   1490  CD2 LEU    32      25.502 108.009  -4.517  1.00 18.89           C  
ATOM   1491  N   ALA    33      24.593 112.295  -5.691  1.00 20.92           N  
ATOM   1492  CA  ALA    33      25.267 113.028  -6.752  1.00 18.99           C  
ATOM   1493  C   ALA    33      26.503 113.726  -6.198  1.00 19.03           C  
ATOM   1494  O   ALA    33      27.575 113.721  -6.808  1.00 19.88           O  
ATOM   1495  CB  ALA    33      24.319 114.046  -7.354  1.00 20.93           C  
ATOM   1496  N   GLN    34      26.339 114.333  -5.034  1.00 15.61           N  
ATOM   1497  CA  GLN    34      27.427 115.030  -4.391  1.00 20.42           C  
ATOM   1498  C   GLN    34      28.514 114.044  -3.967  1.00 25.20           C  
ATOM   1499  O   GLN    34      29.701 114.323  -4.130  1.00 28.30           O  
ATOM   1500  CB  GLN    34      26.902 115.770  -3.183  1.00 20.00           C  
ATOM   1501  CG  GLN    34      27.732 116.943  -2.810  1.00 23.76           C  
ATOM   1502  CD  GLN    34      27.113 117.695  -1.689  1.00 25.03           C  
ATOM   1503  OE1 GLN    34      25.914 117.965  -1.712  1.00 27.84           O  
ATOM   1504  NE2 GLN    34      27.915 118.043  -0.686  1.00 25.01           N  
ATOM   1505  N   GLU    35      28.110 112.897  -3.418  1.00 26.05           N  
ATOM   1506  CA  GLU    35      29.062 111.870  -3.000  1.00 26.79           C  
ATOM   1507  C   GLU    35      29.880 111.409  -4.199  1.00 25.76           C  
ATOM   1508  O   GLU    35      31.100 111.373  -4.133  1.00 29.58           O  
ATOM   1509  CB  GLU    35      28.334 110.656  -2.403  1.00 29.07           C  
ATOM   1510  CG  GLU    35      27.663 110.859  -1.026  1.00 36.40           C  
ATOM   1511  CD  GLU    35      28.639 110.840   0.162  1.00 37.35           C  
ATOM   1512  OE1 GLU    35      29.592 110.019   0.147  1.00 43.71           O  
ATOM   1513  OE2 GLU    35      28.432 111.628   1.113  1.00 32.55           O  
ATOM   1514  N   LEU    36      29.208 111.060  -5.295  1.00 26.54           N  
ATOM   1515  CA  LEU    36      29.903 110.588  -6.490  1.00 26.53           C  
ATOM   1516  C   LEU    36      30.739 111.666  -7.179  1.00 28.82           C  
ATOM   1517  O   LEU    36      31.847 111.390  -7.651  1.00 31.06           O  
ATOM   1518  CB  LEU    36      28.903 110.000  -7.492  1.00 23.33           C  
ATOM   1519  CG  LEU    36      28.105 108.784  -7.009  1.00 21.17           C  
ATOM   1520  CD1 LEU    36      27.061 108.392  -8.037  1.00 17.04           C  
ATOM   1521  CD2 LEU    36      29.055 107.639  -6.741  1.00 15.12           C  
ATOM   1522  N   LEU    37      30.226 112.892  -7.233  1.00 28.20           N  
ATOM   1523  CA  LEU    37      30.951 113.965  -7.903  1.00 26.01           C  
ATOM   1524  C   LEU    37      32.174 114.388  -7.145  1.00 27.22           C  
ATOM   1525  O   LEU    37      33.140 114.872  -7.723  1.00 35.05           O  
ATOM   1526  CB  LEU    37      30.037 115.164  -8.129  1.00 22.95           C  
ATOM   1527  CG  LEU    37      29.266 115.054  -9.444  1.00 25.96           C  
ATOM   1528  CD1 LEU    37      28.166 116.104  -9.505  1.00 26.27           C  
ATOM   1529  CD2 LEU    37      30.239 115.215 -10.598  1.00 23.53           C  
ATOM   1530  N   THR    38      32.145 114.208  -5.839  1.00 30.01           N  
ATOM   1531  CA  THR    38      33.278 114.604  -5.031  1.00 29.62           C  
ATOM   1532  C   THR    38      34.364 113.523  -5.108  1.00 31.54           C  
ATOM   1533  O   THR    38      35.555 113.819  -5.059  1.00 32.59           O  
ATOM   1534  CB  THR    38      32.815 114.860  -3.582  1.00 28.57           C  
ATOM   1535  OG1 THR    38      33.935 115.191  -2.766  1.00 35.34           O  
ATOM   1536  CG2 THR    38      32.128 113.640  -3.015  1.00 33.85           C  
ATOM   1537  N   THR    39      33.956 112.269  -5.273  1.00 32.57           N  
ATOM   1538  CA  THR    39      34.921 111.183  -5.366  1.00 34.34           C  
ATOM   1539  C   THR    39      35.467 110.987  -6.789  1.00 36.96           C  
ATOM   1540  O   THR    39      36.640 110.662  -6.964  1.00 37.38           O  
ATOM   1541  CB  THR    39      34.297 109.864  -4.860  1.00 32.96           C  
ATOM   1542  OG1 THR    39      34.062 109.962  -3.448  1.00 33.25           O  
ATOM   1543  CG2 THR    39      35.223 108.689  -5.130  1.00 31.22           C  
ATOM   1544  N   PHE    40      34.629 111.219  -7.798  1.00 38.57           N  
ATOM   1545  CA  PHE    40      35.027 111.035  -9.193  1.00 37.31           C  
ATOM   1546  C   PHE    40      34.988 112.301 -10.047  1.00 41.01           C  
ATOM   1547  O   PHE    40      34.757 112.234 -11.260  1.00 41.00           O  
ATOM   1548  CB  PHE    40      34.125 109.981  -9.832  1.00 31.99           C  
ATOM   1549  CG  PHE    40      34.123 108.678  -9.107  1.00 28.82           C  
ATOM   1550  CD1 PHE    40      33.048 108.312  -8.313  1.00 30.11           C  
ATOM   1551  CD2 PHE    40      35.207 107.812  -9.218  1.00 29.42           C  
ATOM   1552  CE1 PHE    40      33.043 107.088  -7.632  1.00 31.64           C  
ATOM   1553  CE2 PHE    40      35.224 106.590  -8.552  1.00 28.90           C  
ATOM   1554  CZ  PHE    40      34.136 106.225  -7.755  1.00 31.86           C  
ATOM   1555  N   GLU    41      35.225 113.450  -9.421  1.00 45.20           N  
ATOM   1556  CA  GLU    41      35.182 114.735 -10.121  1.00 48.64           C  
ATOM   1557  C   GLU    41      36.149 114.795 -11.292  1.00 49.01           C  
ATOM   1558  O   GLU    41      35.863 115.413 -12.316  1.00 50.22           O  
ATOM   1559  CB  GLU    41      35.511 115.869  -9.150  1.00 52.34           C  
ATOM   1560  CG  GLU    41      36.906 115.767  -8.535  1.00 59.42           C  
ATOM   1561  CD  GLU    41      37.721 117.041  -8.730  1.00 62.86           C  
ATOM   1562  OE1 GLU    41      37.987 117.406  -9.897  1.00 67.41           O  
ATOM   1563  OE2 GLU    41      38.091 117.680  -7.720  1.00 62.22           O  
ATOM   1564  N   THR    42      37.296 114.147 -11.132  1.00 49.32           N  
ATOM   1565  CA  THR    42      38.323 114.141 -12.162  1.00 47.61           C  
ATOM   1566  C   THR    42      38.082 113.124 -13.296  1.00 45.33           C  
ATOM   1567  O   THR    42      38.704 113.205 -14.353  1.00 42.19           O  
ATOM   1568  CB  THR    42      39.717 113.917 -11.511  1.00 48.23           C  
ATOM   1569  OG1 THR    42      40.556 113.159 -12.394  1.00 51.39           O  
ATOM   1570  CG2 THR    42      39.571 113.193 -10.172  1.00 45.58           C  
ATOM   1571  N   GLU    43      37.163 112.187 -13.092  1.00 44.51           N  
ATOM   1572  CA  GLU    43      36.878 111.187 -14.111  1.00 41.57           C  
ATOM   1573  C   GLU    43      35.505 111.365 -14.752  1.00 41.52           C  
ATOM   1574  O   GLU    43      35.196 110.736 -15.766  1.00 44.39           O  
ATOM   1575  CB  GLU    43      36.978 109.774 -13.522  1.00 43.81           C  
ATOM   1576  CG  GLU    43      38.375 109.344 -13.093  1.00 53.78           C  
ATOM   1577  CD  GLU    43      38.797 109.903 -11.741  1.00 59.81           C  
ATOM   1578  OE1 GLU    43      39.949 109.648 -11.322  1.00 66.31           O  
ATOM   1579  OE2 GLU    43      37.982 110.588 -11.090  1.00 67.02           O  
ATOM   1580  N   LEU    44      34.673 112.220 -14.170  1.00 40.18           N  
ATOM   1581  CA  LEU    44      33.338 112.435 -14.719  1.00 37.50           C  
ATOM   1582  C   LEU    44      33.211 113.728 -15.512  1.00 37.96           C  
ATOM   1583  O   LEU    44      33.648 114.791 -15.063  1.00 40.45           O  
ATOM   1584  CB  LEU    44      32.297 112.438 -13.597  1.00 32.21           C  
ATOM   1585  CG  LEU    44      32.195 111.167 -12.766  1.00 27.84           C  
ATOM   1586  CD1 LEU    44      31.086 111.322 -11.751  1.00 26.62           C  
ATOM   1587  CD2 LEU    44      31.923 109.984 -13.679  1.00 30.90           C  
ATOM   1588  N   THR    45      32.611 113.621 -16.693  1.00 34.19           N  
ATOM   1589  CA  THR    45      32.384 114.771 -17.547  1.00 35.13           C  
ATOM   1590  C   THR    45      31.163 115.510 -16.998  1.00 34.08           C  
ATOM   1591  O   THR    45      31.064 116.733 -17.089  1.00 34.71           O  
ATOM   1592  CB  THR    45      32.115 114.349 -19.022  1.00 39.29           C  
ATOM   1593  OG1 THR    45      31.728 115.504 -19.780  1.00 42.07           O  
ATOM   1594  CG2 THR    45      31.009 113.302 -19.103  1.00 38.35           C  
ATOM   1595  N   GLU    46      30.231 114.745 -16.441  1.00 31.19           N  
ATOM   1596  CA  GLU    46      29.034 115.294 -15.824  1.00 36.59           C  
ATOM   1597  C   GLU    46      28.180 114.201 -15.196  1.00 35.80           C  
ATOM   1598  O   GLU    46      28.302 113.023 -15.539  1.00 34.74           O  
ATOM   1599  CB  GLU    46      28.188 116.098 -16.812  1.00 38.03           C  
ATOM   1600  CG  GLU    46      27.534 115.289 -17.895  1.00 48.23           C  
ATOM   1601  CD  GLU    46      26.618 116.141 -18.781  1.00 55.98           C  
ATOM   1602  OE1 GLU    46      27.057 117.229 -19.251  1.00 56.19           O  
ATOM   1603  OE2 GLU    46      25.460 115.710 -19.017  1.00 58.15           O  
ATOM   1604  N   LEU    47      27.333 114.605 -14.255  1.00 32.79           N  
ATOM   1605  CA  LEU    47      26.453 113.685 -13.564  1.00 25.19           C  
ATOM   1606  C   LEU    47      25.065 114.278 -13.677  1.00 24.20           C  
ATOM   1607  O   LEU    47      24.845 115.431 -13.315  1.00 27.81           O  
ATOM   1608  CB  LEU    47      26.876 113.559 -12.108  1.00 23.89           C  
ATOM   1609  CG  LEU    47      26.095 112.525 -11.313  1.00 18.31           C  
ATOM   1610  CD1 LEU    47      26.939 112.062 -10.138  1.00 19.78           C  
ATOM   1611  CD2 LEU    47      24.775 113.124 -10.866  1.00 16.98           C  
ATOM   1612  N   ALA    48      24.126 113.504 -14.198  1.00 22.62           N  
ATOM   1613  CA  ALA    48      22.771 114.015 -14.376  1.00 21.56           C  
ATOM   1614  C   ALA    48      21.717 113.392 -13.464  1.00 20.92           C  
ATOM   1615  O   ALA    48      21.806 112.222 -13.091  1.00 20.60           O  
ATOM   1616  CB  ALA    48      22.353 113.848 -15.836  1.00 14.97           C  
ATOM   1617  N   LEU    49      20.717 114.189 -13.104  1.00 20.06           N  
ATOM   1618  CA  LEU    49      19.621 113.702 -12.277  1.00 21.13           C  
ATOM   1619  C   LEU    49      18.387 113.657 -13.176  1.00 21.86           C  
ATOM   1620  O   LEU    49      17.997 114.671 -13.733  1.00 22.90           O  
ATOM   1621  CB  LEU    49      19.382 114.643 -11.084  1.00 17.94           C  
ATOM   1622  CG  LEU    49      20.515 114.711 -10.047  1.00 17.37           C  
ATOM   1623  CD1 LEU    49      20.426 115.992  -9.265  1.00 17.78           C  
ATOM   1624  CD2 LEU    49      20.453 113.519  -9.121  1.00 14.96           C  
ATOM   1625  N   LYS    50      17.803 112.477 -13.357  1.00 23.96           N  
ATOM   1626  CA  LYS    50      16.609 112.342 -14.183  1.00 24.56           C  
ATOM   1627  C   LYS    50      15.385 111.979 -13.356  1.00 24.08           C  
ATOM   1628  O   LYS    50      15.334 110.907 -12.746  1.00 29.13           O  
ATOM   1629  CB  LYS    50      16.805 111.260 -15.258  1.00 29.60           C  
ATOM   1630  CG  LYS    50      15.518 110.961 -16.062  1.00 38.16           C  
ATOM   1631  CD  LYS    50      15.671 109.851 -17.108  1.00 40.68           C  
ATOM   1632  CE  LYS    50      16.610 110.257 -18.251  1.00 51.82           C  
ATOM   1633  NZ  LYS    50      16.093 111.355 -19.139  1.00 48.44           N  
ATOM   1634  N   PRO    51      14.382 112.859 -13.325  1.00 22.59           N  
ATOM   1635  CA  PRO    51      13.176 112.554 -12.552  1.00 25.38           C  
ATOM   1636  C   PRO    51      12.553 111.288 -13.105  1.00 27.86           C  
ATOM   1637  O   PRO    51      12.436 111.141 -14.319  1.00 27.06           O  
ATOM   1638  CB  PRO    51      12.292 113.773 -12.794  1.00 27.38           C  
ATOM   1639  CG  PRO    51      13.281 114.886 -12.956  1.00 26.85           C  
ATOM   1640  CD  PRO    51      14.356 114.244 -13.825  1.00 23.65           C  
ATOM   1641  N   GLY    52      12.153 110.383 -12.216  1.00 32.91           N  
ATOM   1642  CA  GLY    52      11.559 109.127 -12.640  1.00 36.98           C  
ATOM   1643  C   GLY    52      10.123 108.903 -12.202  1.00 40.80           C  
ATOM   1644  O   GLY    52       9.546 109.714 -11.481  1.00 37.38           O  
ATOM   1645  N   THR    53       9.563 107.772 -12.632  1.00 48.76           N  
ATOM   1646  CA  THR    53       8.180 107.396 -12.341  1.00 52.36           C  
ATOM   1647  C   THR    53       7.897 107.011 -10.892  1.00 54.71           C  
ATOM   1648  O   THR    53       7.858 107.868 -10.003  1.00 60.21           O  
ATOM   1649  CB  THR    53       7.735 106.216 -13.217  1.00 56.86           C  
ATOM   1650  OG1 THR    53       8.252 106.378 -14.543  1.00 60.67           O  
ATOM   1651  CG2 THR    53       6.212 106.147 -13.273  1.00 58.18           C  
ATOM   1652  N   GLY    54       7.693 105.715 -10.664  1.00 47.98           N  
ATOM   1653  CA  GLY    54       7.372 105.247  -9.331  1.00 46.90           C  
ATOM   1654  C   GLY    54       8.318 104.226  -8.740  1.00 45.07           C  
ATOM   1655  O   GLY    54       8.611 103.199  -9.351  1.00 43.29           O  
ATOM   1656  N   GLY    55       8.793 104.522  -7.533  1.00 41.52           N  
ATOM   1657  CA  GLY    55       9.700 103.632  -6.839  1.00 36.31           C  
ATOM   1658  C   GLY    55      11.041 103.449  -7.516  1.00 32.35           C  
ATOM   1659  O   GLY    55      11.884 102.685  -7.053  1.00 34.97           O  
ATOM   1660  N   VAL    56      11.249 104.154  -8.611  1.00 28.59           N  
ATOM   1661  CA  VAL    56      12.494 104.043  -9.350  1.00 29.28           C  
ATOM   1662  C   VAL    56      13.697 104.764  -8.741  1.00 30.33           C  
ATOM   1663  O   VAL    56      13.624 105.938  -8.368  1.00 32.26           O  
ATOM   1664  CB  VAL    56      12.321 104.578 -10.786  1.00 30.24           C  
ATOM   1665  CG1 VAL    56      13.637 104.494 -11.543  1.00 15.34           C  
ATOM   1666  CG2 VAL    56      11.242 103.762 -11.508  1.00 40.19           C  
ATOM   1667  N   PHE    57      14.812 104.057  -8.638  1.00 26.67           N  
ATOM   1668  CA  PHE    57      16.029 104.677  -8.151  1.00 23.98           C  
ATOM   1669  C   PHE    57      17.193 103.910  -8.712  1.00 19.33           C  
ATOM   1670  O   PHE    57      17.634 102.940  -8.120  1.00 22.04           O  
ATOM   1671  CB  PHE    57      16.124 104.686  -6.624  1.00 26.86           C  
ATOM   1672  CG  PHE    57      17.181 105.632  -6.109  1.00 25.63           C  
ATOM   1673  CD1 PHE    57      16.853 106.919  -5.727  1.00 21.45           C  
ATOM   1674  CD2 PHE    57      18.522 105.278  -6.132  1.00 26.35           C  
ATOM   1675  CE1 PHE    57      17.838 107.832  -5.389  1.00 22.63           C  
ATOM   1676  CE2 PHE    57      19.513 106.203  -5.790  1.00 25.01           C  
ATOM   1677  CZ  PHE    57      19.162 107.472  -5.424  1.00 21.00           C  
ATOM   1678  N   VAL    58      17.701 104.340  -9.854  1.00 16.87           N  
ATOM   1679  CA  VAL    58      18.811 103.619 -10.449  1.00 16.50           C  
ATOM   1680  C   VAL    58      19.990 104.509 -10.803  1.00 14.74           C  
ATOM   1681  O   VAL    58      19.833 105.682 -11.099  1.00 19.25           O  
ATOM   1682  CB  VAL    58      18.336 102.803 -11.703  1.00 17.29           C  
ATOM   1683  CG1 VAL    58      17.143 103.480 -12.358  1.00 13.35           C  
ATOM   1684  CG2 VAL    58      19.480 102.662 -12.707  1.00 10.59           C  
ATOM   1685  N   VAL    59      21.181 103.944 -10.737  1.00 17.11           N  
ATOM   1686  CA  VAL    59      22.387 104.675 -11.069  1.00 14.59           C  
ATOM   1687  C   VAL    59      22.962 104.053 -12.337  1.00 18.14           C  
ATOM   1688  O   VAL    59      23.117 102.827 -12.434  1.00 18.37           O  
ATOM   1689  CB  VAL    59      23.442 104.565  -9.941  1.00 14.04           C  
ATOM   1690  CG1 VAL    59      24.705 105.319 -10.332  1.00 14.47           C  
ATOM   1691  CG2 VAL    59      22.881 105.116  -8.644  1.00 10.10           C  
ATOM   1692  N   ARG    60      23.275 104.900 -13.310  1.00 19.90           N  
ATOM   1693  CA  ARG    60      23.835 104.443 -14.582  1.00 22.68           C  
ATOM   1694  C   ARG    60      25.212 105.039 -14.826  1.00 26.21           C  
ATOM   1695  O   ARG    60      25.455 106.193 -14.495  1.00 30.19           O  
ATOM   1696  CB  ARG    60      22.913 104.835 -15.737  1.00 17.23           C  
ATOM   1697  CG  ARG    60      22.086 103.684 -16.262  1.00 28.18           C  
ATOM   1698  CD  ARG    60      21.105 104.151 -17.308  1.00 28.75           C  
ATOM   1699  NE  ARG    60      19.884 104.634 -16.674  1.00 32.77           N  
ATOM   1700  CZ  ARG    60      18.712 104.017 -16.761  1.00 32.20           C  
ATOM   1701  NH1 ARG    60      18.598 102.897 -17.463  1.00 36.11           N  
ATOM   1702  NH2 ARG    60      17.660 104.509 -16.130  1.00 32.88           N  
ATOM   1703  N   VAL    61      26.131 104.249 -15.369  1.00 26.06           N  
ATOM   1704  CA  VAL    61      27.463 104.762 -15.688  1.00 27.01           C  
ATOM   1705  C   VAL    61      27.661 104.437 -17.173  1.00 29.36           C  
ATOM   1706  O   VAL    61      27.682 103.262 -17.563  1.00 24.96           O  
ATOM   1707  CB  VAL    61      28.585 104.089 -14.844  1.00 28.99           C  
ATOM   1708  CG1 VAL    61      29.954 104.665 -15.242  1.00 25.18           C  
ATOM   1709  CG2 VAL    61      28.341 104.307 -13.370  1.00 24.83           C  
ATOM   1710  N   ASP    62      27.775 105.482 -17.993  1.00 29.70           N  
ATOM   1711  CA  ASP    62      27.935 105.318 -19.434  1.00 37.02           C  
ATOM   1712  C   ASP    62      26.786 104.488 -20.032  1.00 41.12           C  
ATOM   1713  O   ASP    62      27.016 103.520 -20.764  1.00 43.88           O  
ATOM   1714  CB  ASP    62      29.282 104.654 -19.732  1.00 38.18           C  
ATOM   1715  CG  ASP    62      30.466 105.553 -19.381  1.00 43.43           C  
ATOM   1716  OD1 ASP    62      31.534 105.021 -19.002  1.00 47.13           O  
ATOM   1717  OD2 ASP    62      30.341 106.795 -19.495  1.00 40.93           O  
ATOM   1718  N   ASP    63      25.553 104.870 -19.698  1.00 43.52           N  
ATOM   1719  CA  ASP    63      24.352 104.194 -20.181  1.00 43.34           C  
ATOM   1720  C   ASP    63      24.123 102.807 -19.583  1.00 42.44           C  
ATOM   1721  O   ASP    63      23.064 102.212 -19.780  1.00 40.82           O  
ATOM   1722  CB  ASP    63      24.383 104.108 -21.708  1.00 49.03           C  
ATOM   1723  CG  ASP    63      24.078 105.449 -22.377  1.00 56.96           C  
ATOM   1724  OD1 ASP    63      22.893 105.855 -22.397  1.00 62.08           O  
ATOM   1725  OD2 ASP    63      25.022 106.101 -22.880  1.00 60.23           O  
ATOM   1726  N   GLU    64      25.103 102.294 -18.847  1.00 43.04           N  
ATOM   1727  CA  GLU    64      24.972 100.970 -18.237  1.00 43.09           C  
ATOM   1728  C   GLU    64      24.517 101.046 -16.793  1.00 35.79           C  
ATOM   1729  O   GLU    64      25.144 101.718 -15.986  1.00 42.15           O  
ATOM   1730  CB  GLU    64      26.305 100.217 -18.330  1.00 48.93           C  
ATOM   1731  CG  GLU    64      26.543  99.569 -19.696  1.00 61.84           C  
ATOM   1732  CD  GLU    64      27.974  99.069 -19.869  1.00 73.08           C  
ATOM   1733  OE1 GLU    64      28.485  98.402 -18.928  1.00 78.01           O  
ATOM   1734  OE2 GLU    64      28.582  99.339 -20.946  1.00 71.08           O  
ATOM   1735  N   VAL    65      23.421 100.369 -16.469  1.00 27.63           N  
ATOM   1736  CA  VAL    65      22.921 100.387 -15.100  1.00 25.77           C  
ATOM   1737  C   VAL    65      23.882  99.655 -14.142  1.00 28.28           C  
ATOM   1738  O   VAL    65      24.226  98.485 -14.338  1.00 20.36           O  
ATOM   1739  CB  VAL    65      21.505  99.762 -14.994  1.00 25.81           C  
ATOM   1740  CG1 VAL    65      21.468  98.433 -15.735  1.00 35.04           C  
ATOM   1741  CG2 VAL    65      21.140  99.546 -13.525  1.00 14.82           C  
ATOM   1742  N   VAL    66      24.313 100.375 -13.108  1.00 27.20           N  
ATOM   1743  CA  VAL    66      25.237  99.852 -12.122  1.00 23.67           C  
ATOM   1744  C   VAL    66      24.561  99.598 -10.779  1.00 24.73           C  
ATOM   1745  O   VAL    66      25.038  98.789  -9.979  1.00 25.71           O  
ATOM   1746  CB  VAL    66      26.408 100.821 -11.961  1.00 24.07           C  
ATOM   1747  CG1 VAL    66      27.305 100.416 -10.806  1.00 25.95           C  
ATOM   1748  CG2 VAL    66      27.204 100.836 -13.246  1.00 19.62           C  
ATOM   1749  N   TRP    67      23.444 100.270 -10.531  1.00 26.59           N  
ATOM   1750  CA  TRP    67      22.721 100.071  -9.283  1.00 24.40           C  
ATOM   1751  C   TRP    67      21.243 100.265  -9.473  1.00 20.86           C  
ATOM   1752  O   TRP    67      20.817 101.260 -10.040  1.00 23.33           O  
ATOM   1753  CB  TRP    67      23.213 101.041  -8.211  1.00 26.08           C  
ATOM   1754  CG  TRP    67      22.669 100.721  -6.859  1.00 24.39           C  
ATOM   1755  CD1 TRP    67      21.405 100.967  -6.396  1.00 24.24           C  
ATOM   1756  CD2 TRP    67      23.368 100.083  -5.793  1.00 22.69           C  
ATOM   1757  NE1 TRP    67      21.277 100.526  -5.103  1.00 19.54           N  
ATOM   1758  CE2 TRP    67      22.468  99.981  -4.706  1.00 21.17           C  
ATOM   1759  CE3 TRP    67      24.669  99.590  -5.646  1.00 19.66           C  
ATOM   1760  CZ2 TRP    67      22.830  99.411  -3.493  1.00 19.53           C  
ATOM   1761  CZ3 TRP    67      25.029  99.026  -4.447  1.00 17.34           C  
ATOM   1762  CH2 TRP    67      24.113  98.941  -3.380  1.00 22.91           C  
ATOM   1763  N   ASP    68      20.463  99.303  -9.005  1.00 20.11           N  
ATOM   1764  CA  ASP    68      19.012  99.388  -9.099  1.00 25.74           C  
ATOM   1765  C   ASP    68      18.429  99.124  -7.711  1.00 27.04           C  
ATOM   1766  O   ASP    68      18.701  98.089  -7.106  1.00 34.40           O  
ATOM   1767  CB  ASP    68      18.484  98.352 -10.089  1.00 29.43           C  
ATOM   1768  CG  ASP    68      16.993  98.503 -10.359  1.00 37.13           C  
ATOM   1769  OD1 ASP    68      16.222  98.766  -9.405  1.00 40.64           O  
ATOM   1770  OD2 ASP    68      16.588  98.348 -11.531  1.00 40.24           O  
ATOM   1771  N   ARG    69      17.623 100.053  -7.215  1.00 27.74           N  
ATOM   1772  CA  ARG    69      17.017  99.922  -5.890  1.00 30.14           C  
ATOM   1773  C   ARG    69      16.300  98.595  -5.624  1.00 31.56           C  
ATOM   1774  O   ARG    69      16.653  97.873  -4.692  1.00 26.37           O  
ATOM   1775  CB  ARG    69      16.025 101.054  -5.647  1.00 26.47           C  
ATOM   1776  CG  ARG    69      15.642 101.191  -4.201  1.00 31.13           C  
ATOM   1777  CD  ARG    69      14.402 102.044  -4.005  1.00 36.14           C  
ATOM   1778  NE  ARG    69      13.230 101.218  -3.775  1.00 38.88           N  
ATOM   1779  CZ  ARG    69      12.604 100.525  -4.719  1.00 43.61           C  
ATOM   1780  NH1 ARG    69      11.542  99.782  -4.414  1.00 47.81           N  
ATOM   1781  NH2 ARG    69      13.021 100.587  -5.974  1.00 44.92           N  
ATOM   1782  N   ARG    70      15.288  98.280  -6.430  1.00 33.52           N  
ATOM   1783  CA  ARG    70      14.543  97.048  -6.223  1.00 41.98           C  
ATOM   1784  C   ARG    70      15.303  95.813  -6.667  1.00 42.00           C  
ATOM   1785  O   ARG    70      14.736  94.867  -7.195  1.00 44.92           O  
ATOM   1786  CB  ARG    70      13.157  97.116  -6.893  1.00 44.21           C  
ATOM   1787  CG  ARG    70      13.138  97.606  -8.309  1.00 51.43           C  
ATOM   1788  CD  ARG    70      13.527  96.536  -9.295  1.00 57.29           C  
ATOM   1789  NE  ARG    70      13.537  97.075 -10.653  1.00 67.22           N  
ATOM   1790  CZ  ARG    70      13.974  96.418 -11.720  1.00 67.47           C  
ATOM   1791  NH1 ARG    70      14.442  95.180 -11.591  1.00 62.93           N  
ATOM   1792  NH2 ARG    70      13.949  97.009 -12.914  1.00 71.38           N  
ATOM   1793  N   GLU    71      16.600  95.821  -6.407  1.00 42.39           N  
ATOM   1794  CA  GLU    71      17.453  94.714  -6.768  1.00 40.69           C  
ATOM   1795  C   GLU    71      18.616  94.666  -5.787  1.00 38.69           C  
ATOM   1796  O   GLU    71      19.081  93.593  -5.414  1.00 35.90           O  
ATOM   1797  CB  GLU    71      17.964  94.923  -8.186  1.00 45.75           C  
ATOM   1798  CG  GLU    71      19.151  94.072  -8.557  1.00 58.77           C  
ATOM   1799  CD  GLU    71      18.834  93.060  -9.651  1.00 65.31           C  
ATOM   1800  OE1 GLU    71      19.789  92.437 -10.187  1.00 67.06           O  
ATOM   1801  OE2 GLU    71      17.632  92.893  -9.969  1.00 67.56           O  
ATOM   1802  N   GLN    72      19.063  95.834  -5.342  1.00 34.65           N  
ATOM   1803  CA  GLN    72      20.190  95.896  -4.425  1.00 32.47           C  
ATOM   1804  C   GLN    72      19.918  96.791  -3.242  1.00 32.08           C  
ATOM   1805  O   GLN    72      20.809  97.042  -2.437  1.00 34.82           O  
ATOM   1806  CB  GLN    72      21.424  96.388  -5.173  1.00 33.17           C  
ATOM   1807  CG  GLN    72      21.362  96.051  -6.643  1.00 34.18           C  
ATOM   1808  CD  GLN    72      22.530  96.578  -7.405  1.00 36.48           C  
ATOM   1809  OE1 GLN    72      22.390  96.999  -8.548  1.00 37.61           O  
ATOM   1810  NE2 GLN    72      23.704  96.553  -6.786  1.00 41.14           N  
ATOM   1811  N   GLY    73      18.685  97.272  -3.136  1.00 31.96           N  
ATOM   1812  CA  GLY    73      18.331  98.142  -2.026  1.00 26.30           C  
ATOM   1813  C   GLY    73      18.884  99.562  -2.071  1.00 24.64           C  
ATOM   1814  O   GLY    73      19.304 100.066  -3.116  1.00 26.56           O  
ATOM   1815  N   PHE    74      18.877 100.203  -0.908  1.00 22.82           N  
ATOM   1816  CA  PHE    74      19.343 101.569  -0.754  1.00 23.62           C  
ATOM   1817  C   PHE    74      20.782 101.741  -1.240  1.00 25.52           C  
ATOM   1818  O   PHE    74      21.653 100.929  -0.939  1.00 21.83           O  
ATOM   1819  CB  PHE    74      19.235 102.005   0.713  1.00 17.63           C  
ATOM   1820  CG  PHE    74      19.596 103.436   0.930  1.00 22.39           C  
ATOM   1821  CD1 PHE    74      18.677 104.447   0.655  1.00 24.11           C  
ATOM   1822  CD2 PHE    74      20.897 103.786   1.276  1.00 24.27           C  
ATOM   1823  CE1 PHE    74      19.056 105.790   0.710  1.00 27.45           C  
ATOM   1824  CE2 PHE    74      21.290 105.123   1.336  1.00 25.44           C  
ATOM   1825  CZ  PHE    74      20.372 106.129   1.050  1.00 26.59           C  
ATOM   1826  N   PRO    75      21.047 102.814  -2.001  1.00 26.42           N  
ATOM   1827  CA  PRO    75      22.402 103.037  -2.506  1.00 30.62           C  
ATOM   1828  C   PRO    75      23.438 103.468  -1.465  1.00 32.60           C  
ATOM   1829  O   PRO    75      23.824 104.634  -1.416  1.00 33.82           O  
ATOM   1830  CB  PRO    75      22.190 104.085  -3.601  1.00 26.01           C  
ATOM   1831  CG  PRO    75      21.066 104.898  -3.041  1.00 31.94           C  
ATOM   1832  CD  PRO    75      20.118 103.838  -2.512  1.00 25.71           C  
ATOM   1833  N   GLU    76      23.886 102.523  -0.640  1.00 32.70           N  
ATOM   1834  CA  GLU    76      24.907 102.809   0.372  1.00 34.65           C  
ATOM   1835  C   GLU    76      26.147 103.377  -0.351  1.00 36.38           C  
ATOM   1836  O   GLU    76      26.734 102.719  -1.222  1.00 32.20           O  
ATOM   1837  CB  GLU    76      25.261 101.525   1.134  1.00 37.11           C  
ATOM   1838  CG  GLU    76      26.053 101.738   2.419  1.00 46.96           C  
ATOM   1839  CD  GLU    76      27.573 101.674   2.227  1.00 54.03           C  
ATOM   1840  OE1 GLU    76      28.284 102.503   2.854  1.00 53.38           O  
ATOM   1841  OE2 GLU    76      28.053 100.790   1.469  1.00 54.08           O  
ATOM   1842  N   PRO    77      26.573 104.599   0.028  1.00 37.27           N  
ATOM   1843  CA  PRO    77      27.723 105.284  -0.573  1.00 36.67           C  
ATOM   1844  C   PRO    77      28.926 104.417  -0.966  1.00 38.30           C  
ATOM   1845  O   PRO    77      29.356 104.407  -2.125  1.00 39.25           O  
ATOM   1846  CB  PRO    77      28.064 106.354   0.465  1.00 30.87           C  
ATOM   1847  CG  PRO    77      27.585 105.757   1.733  1.00 35.87           C  
ATOM   1848  CD  PRO    77      26.259 105.198   1.335  1.00 36.78           C  
ATOM   1849  N   THR    78      29.472 103.688  -0.009  1.00 36.96           N  
ATOM   1850  CA  THR    78      30.627 102.849  -0.288  1.00 40.65           C  
ATOM   1851  C   THR    78      30.379 101.830  -1.396  1.00 40.53           C  
ATOM   1852  O   THR    78      31.098 101.800  -2.398  1.00 40.71           O  
ATOM   1853  CB  THR    78      31.053 102.111   0.984  1.00 43.25           C  
ATOM   1854  OG1 THR    78      31.328 103.076   2.011  1.00 49.41           O  
ATOM   1855  CG2 THR    78      32.296 101.276   0.729  1.00 40.87           C  
ATOM   1856  N   ALA    79      29.363 100.991  -1.197  1.00 39.05           N  
ATOM   1857  CA  ALA    79      28.989  99.958  -2.157  1.00 30.95           C  
ATOM   1858  C   ALA    79      28.860 100.524  -3.559  1.00 30.87           C  
ATOM   1859  O   ALA    79      29.476 100.021  -4.495  1.00 32.07           O  
ATOM   1860  CB  ALA    79      27.674  99.326  -1.744  1.00 30.22           C  
ATOM   1861  N   VAL    80      28.056 101.573  -3.701  1.00 29.83           N  
ATOM   1862  CA  VAL    80      27.845 102.176  -5.008  1.00 32.09           C  
ATOM   1863  C   VAL    80      29.089 102.872  -5.550  1.00 31.24           C  
ATOM   1864  O   VAL    80      29.303 102.901  -6.760  1.00 33.15           O  
ATOM   1865  CB  VAL    80      26.639 103.166  -5.004  1.00 30.11           C  
ATOM   1866  CG1 VAL    80      26.846 104.240  -3.969  1.00 33.03           C  
ATOM   1867  CG2 VAL    80      26.468 103.776  -6.381  1.00 27.36           C  
ATOM   1868  N   LYS    81      29.922 103.424  -4.675  1.00 31.39           N  
ATOM   1869  CA  LYS    81      31.128 104.082  -5.165  1.00 31.48           C  
ATOM   1870  C   LYS    81      32.096 103.060  -5.727  1.00 31.99           C  
ATOM   1871  O   LYS    81      32.828 103.339  -6.673  1.00 34.67           O  
ATOM   1872  CB  LYS    81      31.805 104.914  -4.064  1.00 26.53           C  
ATOM   1873  CG  LYS    81      31.266 106.332  -4.022  1.00 31.15           C  
ATOM   1874  CD  LYS    81      32.104 107.272  -3.195  1.00 34.88           C  
ATOM   1875  CE  LYS    81      31.706 107.256  -1.727  1.00 36.99           C  
ATOM   1876  NZ  LYS    81      32.451 108.286  -0.938  1.00 35.32           N  
ATOM   1877  N   ARG    82      32.084 101.862  -5.162  1.00 34.10           N  
ATOM   1878  CA  ARG    82      32.978 100.825  -5.632  1.00 36.80           C  
ATOM   1879  C   ARG    82      32.578 100.319  -6.998  1.00 34.53           C  
ATOM   1880  O   ARG    82      33.438 100.082  -7.844  1.00 35.29           O  
ATOM   1881  CB  ARG    82      33.023  99.677  -4.638  1.00 44.18           C  
ATOM   1882  CG  ARG    82      34.369  99.584  -3.988  1.00 51.62           C  
ATOM   1883  CD  ARG    82      34.177  99.776  -2.469  1.00 55.04           C  
ATOM   1884  NE  ARG    82      34.057  98.421  -2.176  1.00 59.29           N  
ATOM   1885  CZ  ARG    82      33.233  97.547  -1.649  1.00 61.20           C  
ATOM   1886  NH1 ARG    82      32.044  97.651  -1.063  1.00 59.66           N  
ATOM   1887  NH2 ARG    82      33.675  96.365  -2.009  1.00 60.79           N  
ATOM   1888  N   LEU    83      31.274 100.160  -7.208  1.00 30.67           N  
ATOM   1889  CA  LEU    83      30.756  99.692  -8.490  1.00 30.34           C  
ATOM   1890  C   LEU    83      30.966 100.737  -9.566  1.00 29.94           C  
ATOM   1891  O   LEU    83      31.124 100.399 -10.738  1.00 31.06           O  
ATOM   1892  CB  LEU    83      29.268  99.369  -8.390  1.00 29.27           C  
ATOM   1893  CG  LEU    83      28.906  97.975  -7.870  1.00 29.71           C  
ATOM   1894  CD1 LEU    83      29.519  97.735  -6.500  1.00 37.64           C  
ATOM   1895  CD2 LEU    83      27.400  97.861  -7.795  1.00 32.00           C  
ATOM   1896  N   VAL    84      30.954 102.007  -9.170  1.00 29.27           N  
ATOM   1897  CA  VAL    84      31.168 103.107 -10.114  1.00 28.41           C  
ATOM   1898  C   VAL    84      32.658 103.201 -10.473  1.00 30.57           C  
ATOM   1899  O   VAL    84      33.006 103.503 -11.611  1.00 26.17           O  
ATOM   1900  CB  VAL    84      30.692 104.474  -9.525  1.00 28.14           C  
ATOM   1901  CG1 VAL    84      31.179 105.626 -10.402  1.00 23.12           C  
ATOM   1902  CG2 VAL    84      29.166 104.505  -9.432  1.00 23.83           C  
ATOM   1903  N   ARG    85      33.531 102.939  -9.500  1.00 35.11           N  
ATOM   1904  CA  ARG    85      34.964 102.990  -9.738  1.00 37.04           C  
ATOM   1905  C   ARG    85      35.376 101.886 -10.717  1.00 36.72           C  
ATOM   1906  O   ARG    85      36.238 102.089 -11.569  1.00 31.75           O  
ATOM   1907  CB  ARG    85      35.739 102.839  -8.427  1.00 37.33           C  
ATOM   1908  CG  ARG    85      37.244 102.921  -8.635  1.00 45.43           C  
ATOM   1909  CD  ARG    85      38.040 102.134  -7.605  1.00 50.86           C  
ATOM   1910  NE  ARG    85      37.550 100.814  -7.382  1.00 53.15           N  
ATOM   1911  CZ  ARG    85      37.365 100.069  -6.298  1.00 51.12           C  
ATOM   1912  NH1 ARG    85      36.886  98.880  -6.578  1.00 52.18           N  
ATOM   1913  NH2 ARG    85      37.595 100.408  -5.032  1.00 45.28           N  
ATOM   1914  N   ASP    86      34.747 100.722 -10.610  1.00 40.19           N  
ATOM   1915  CA  ASP    86      35.064  99.612 -11.499  1.00 41.80           C  
ATOM   1916  C   ASP    86      34.682  99.903 -12.946  1.00 44.13           C  
ATOM   1917  O   ASP    86      35.159  99.222 -13.843  1.00 48.91           O  
ATOM   1918  CB  ASP    86      34.357  98.328 -11.045  1.00 44.39           C  
ATOM   1919  CG  ASP    86      34.920  97.758  -9.741  1.00 50.17           C  
ATOM   1920  OD1 ASP    86      34.380  96.720  -9.274  1.00 49.93           O  
ATOM   1921  OD2 ASP    86      35.893  98.333  -9.188  1.00 49.54           O  
ATOM   1922  N   ARG    87      33.824 100.897 -13.179  1.00 46.76           N  
ATOM   1923  CA  ARG    87      33.407 101.250 -14.540  1.00 45.11           C  
ATOM   1924  C   ARG    87      34.408 102.233 -15.120  1.00 45.90           C  
ATOM   1925  O   ARG    87      34.480 102.426 -16.326  1.00 46.61           O  
ATOM   1926  CB  ARG    87      32.032 101.918 -14.546  1.00 48.07           C  
ATOM   1927  CG  ARG    87      31.023 101.391 -13.534  1.00 56.36           C  
ATOM   1928  CD  ARG    87      30.757  99.933 -13.732  1.00 52.84           C  
ATOM   1929  NE  ARG    87      30.517  99.635 -15.134  1.00 58.50           N  
ATOM   1930  CZ  ARG    87      30.047  98.471 -15.562  1.00 63.85           C  
ATOM   1931  NH1 ARG    87      29.853  98.261 -16.861  1.00 61.62           N  
ATOM   1932  NH2 ARG    87      29.763  97.520 -14.675  1.00 63.63           N  
ATOM   1933  N   VAL    88      35.172 102.872 -14.247  1.00 48.48           N  
ATOM   1934  CA  VAL    88      36.171 103.831 -14.690  1.00 49.97           C  
ATOM   1935  C   VAL    88      37.566 103.462 -14.145  1.00 57.00           C  
ATOM   1936  O   VAL    88      38.133 104.262 -13.352  1.00 57.96           O  
ATOM   1937  CB  VAL    88      35.804 105.249 -14.225  1.00 46.27           C  
ATOM   1938  CG1 VAL    88      36.625 106.273 -15.003  1.00 39.40           C  
ATOM   1939  CG2 VAL    88      34.310 105.489 -14.396  1.00 38.65           C  
END
