
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  105 (  844),  selected  105 , name 2cvk_A
# Molecule2: number of CA atoms   77 (  633),  selected   77 , name T0458.pdb
# PARAMETERS: 2cvk_A.T0458.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K     3_A      -       -           -
LGA    P     4_A      -       -           -
LGA    I     5_A      -       -           -
LGA    E     6_A      -       -           -
LGA    V     7_A      -       -           -
LGA    T     8_A      -       -           -
LGA    D     9_A      -       -           -
LGA    Q    10_A      -       -           -
LGA    N    11_A      -       -           -
LGA    F    12_A      -       -           -
LGA    D    13_A      -       -           -
LGA    E    14_A      -       -           -
LGA    T    15_A      -       -           -
LGA    L    16_A      -       -           -
LGA    G    17_A      -       -           -
LGA    Q    18_A      -       -           -
LGA    H    19_A      -       -           -
LGA    P    20_A      T      12          3.338
LGA    L    21_A      H      13          1.691
LGA    V    22_A      R      14          1.367
LGA    L    23_A      V      15          1.356
LGA    V    24_A      Q      16          0.720
LGA    D    25_A      I      17          0.720
LGA    F    26_A      E      18          0.911
LGA    W    27_A      Y      19          1.793
LGA    A    28_A      C      20          3.349
LGA    E    29_A      T      21          2.873
LGA    W    30_A      Q      22          1.949
LGA    C    31_A      C      23          1.610
LGA    A    32_A      R      24          3.775
LGA    P    33_A      W      25          4.329
LGA    C    34_A      L      26          4.547
LGA    R    35_A      P      27          2.777
LGA    X    36_A      R      28          2.396
LGA    I    37_A      A      29          3.695
LGA    A    38_A      A      30          2.193
LGA    P    39_A      W      31          1.033
LGA    I    40_A      L      32          2.355
LGA    L    41_A      A      33          1.872
LGA    E    42_A      Q      34          1.073
LGA    E    43_A      E      35          2.071
LGA    I    44_A      L      36          1.220
LGA    A    45_A      L      37          0.932
LGA    K    46_A      T      38          1.918
LGA    E    47_A      T      39          1.882
LGA    Y    48_A      F      40          1.026
LGA    E    49_A      E      41          0.875
LGA    G    50_A      T      42          2.587
LGA    K    51_A      E      43          0.613
LGA    L    52_A      L      44          1.491
LGA    -       -      T      45           -
LGA    L    53_A      E      46          2.292
LGA    V    54_A      L      47          1.270
LGA    A    55_A      A      48          0.842
LGA    K    56_A      L      49          0.947
LGA    L    57_A      K      50          1.087
LGA    D    58_A      P      51          1.534
LGA    V    59_A      G      52          2.689
LGA    D    60_A      T      53          5.698
LGA    E    61_A      -       -           -
LGA    N    62_A      -       -           -
LGA    P    63_A      -       -           -
LGA    K    64_A      -       -           -
LGA    T    65_A      -       -           -
LGA    A    66_A      -       -           -
LGA    X    67_A      -       -           -
LGA    R    68_A      -       -           -
LGA    Y    69_A      -       -           -
LGA    R    70_A      -       -           -
LGA    V    71_A      -       -           -
LGA    X    72_A      G      54           #
LGA    S    73_A      G      55          4.174
LGA    I    74_A      V      56          1.037
LGA    P    75_A      F      57          1.081
LGA    T    76_A      V      58          1.224
LGA    V    77_A      V      59          1.281
LGA    I    78_A      R      60          1.326
LGA    L    79_A      V      61          1.288
LGA    F    80_A      D      62          1.004
LGA    K    81_A      -       -           -
LGA    D    82_A      -       -           -
LGA    G    83_A      -       -           -
LGA    Q    84_A      D      63          4.396
LGA    P    85_A      E      64          1.842
LGA    V    86_A      -       -           -
LGA    E    87_A      V      65          3.712
LGA    V    88_A      V      66          2.390
LGA    L    89_A      W      67          0.730
LGA    V    90_A      D      68          1.378
LGA    G    91_A      R      69          2.043
LGA    -       -      R      70           -
LGA    -       -      E      71           -
LGA    -       -      Q      72           -
LGA    -       -      G      73           -
LGA    A    92_A      F      74          3.028
LGA    Q    93_A      P      75          1.391
LGA    P    94_A      E      76          1.068
LGA    K    95_A      P      77          0.723
LGA    R    96_A      T      78          0.805
LGA    N    97_A      A      79          1.795
LGA    Y    98_A      V      80          1.804
LGA    Q    99_A      K      81          0.852
LGA    A   100_A      R      82          0.696
LGA    K   101_A      L      83          1.117
LGA    I   102_A      V      84          1.331
LGA    E   103_A      R      85          0.989
LGA    K   104_A      D      86          0.354
LGA    H   105_A      R      87          1.923
LGA    L   106_A      V      88          1.979
LGA    P   107_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  105   77    5.0     71    2.16    11.27     70.916     3.142

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.135252 * X  +  -0.983384 * Y  +   0.121093 * Z  +  32.718109
  Y_new =   0.421746 * X  +   0.167731 * Y  +   0.891065 * Z  +  90.965714
  Z_new =  -0.896570 * X  +  -0.069448 * Y  +   0.437424 * Z  +  -5.772686 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.157451    2.984142  [ DEG:    -9.0213    170.9787 ]
  Theta =   1.111963    2.029630  [ DEG:    63.7108    116.2892 ]
  Phi   =   1.260463   -1.881130  [ DEG:    72.2192   -107.7808 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2cvk_A                                        
REMARK     2: T0458.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2cvk_A.T0458.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  105   77   5.0   71   2.16   11.27  70.916
REMARK  ---------------------------------------------------------- 
MOLECULE 2cvk_A
HEADER    ELECTRON TRANSPORT                      04-JUN-05   2CVK              
TITLE     CRYSTAL STRUCTURE OF THERMUS THERMOPHILUS THIOREDOXIN                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: THIOREDOXIN;                                               
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: B834(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET11A                                    
KEYWDS    TRX, STRUCTURAL GENOMICS, RIKEN STRUCTURAL                            
KEYWDS   2 GENOMICS/PROTEOMICS INITIATIVE, RSGI                                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    H.YANAI,S.YOKOYAMA,S.KURAMITSU,RIKEN STRUCTURAL                       
AUTHOR   2 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   04-DEC-05 2CVK    0                                                
JRNL        AUTH   H.YANAI,S.YOKOYAMA,S.KURAMITSU                               
JRNL        TITL   CRYSTAL STRUCTURE OF A REDUCED THIOREDOXIN FROM              
JRNL        TITL 2 THERMUS THERMOPHILUS HB8                                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
SEQRES   1 A  110  MSE ALA LYS PRO ILE GLU VAL THR ASP GLN ASN PHE ASP          
SEQRES   2 A  110  GLU THR LEU GLY GLN HIS PRO LEU VAL LEU VAL ASP PHE          
SEQRES   3 A  110  TRP ALA GLU TRP CYS ALA PRO CYS ARG MSE ILE ALA PRO          
SEQRES   4 A  110  ILE LEU GLU GLU ILE ALA LYS GLU TYR GLU GLY LYS LEU          
SEQRES   5 A  110  LEU VAL ALA LYS LEU ASP VAL ASP GLU ASN PRO LYS THR          
SEQRES   6 A  110  ALA MSE ARG TYR ARG VAL MSE SER ILE PRO THR VAL ILE          
SEQRES   7 A  110  LEU PHE LYS ASP GLY GLN PRO VAL GLU VAL LEU VAL GLY          
SEQRES   8 A  110  ALA GLN PRO LYS ARG ASN TYR GLN ALA LYS ILE GLU LYS          
SEQRES   9 A  110  HIS LEU PRO ALA THR ALA                                      
HET    MSE  A  36       8                                                       
HET    MSE  A  67       8                                                       
HET    MSE  A  72       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    3(C5 H11 N O2 SE)                                            
FORMUL   2  HOH   *43(H2 O)                                                     
CRYST1   58.850   58.850   59.610  90.00  90.00  90.00 P 43 21 2     8          
ATOM      1  N   LYS A   3      29.064 119.815  -9.913  1.00 47.84           N  
ATOM      2  CA  LYS A   3      27.835 119.252  -9.284  1.00 47.39           C  
ATOM      3  C   LYS A   3      26.924 118.599 -10.325  1.00 46.23           C  
ATOM      4  O   LYS A   3      27.054 118.856 -11.523  1.00 46.36           O  
ATOM      5  CB  LYS A   3      27.076 120.356  -8.538  1.00 49.26           C  
ATOM      6  CG  LYS A   3      27.917 121.101  -7.496  1.00 50.95           C  
ATOM      7  CD  LYS A   3      28.772 120.144  -6.666  1.00 51.98           C  
ATOM      8  CE  LYS A   3      27.932 119.065  -5.995  1.00 50.90           C  
ATOM      9  NZ  LYS A   3      28.786 117.987  -5.430  1.00 49.18           N  
ATOM     10  N   PRO A   4      25.986 117.742  -9.876  1.00 44.21           N  
ATOM     11  CA  PRO A   4      25.042 117.034 -10.750  1.00 42.06           C  
ATOM     12  C   PRO A   4      24.284 117.936 -11.721  1.00 40.93           C  
ATOM     13  O   PRO A   4      23.660 118.918 -11.314  1.00 40.99           O  
ATOM     14  CB  PRO A   4      24.104 116.348  -9.758  1.00 42.06           C  
ATOM     15  CG  PRO A   4      25.001 116.071  -8.595  1.00 43.54           C  
ATOM     16  CD  PRO A   4      25.757 117.374  -8.467  1.00 44.18           C  
ATOM     17  N   ILE A   5      24.332 117.594 -13.004  1.00 38.58           N  
ATOM     18  CA  ILE A   5      23.636 118.376 -14.016  1.00 37.05           C  
ATOM     19  C   ILE A   5      22.314 117.696 -14.341  1.00 37.16           C  
ATOM     20  O   ILE A   5      22.083 116.554 -13.943  1.00 34.99           O  
ATOM     21  CB  ILE A   5      24.460 118.486 -15.316  1.00 37.21           C  
ATOM     22  CG1 ILE A   5      24.522 117.128 -16.015  1.00 38.33           C  
ATOM     23  CG2 ILE A   5      25.866 118.962 -15.002  1.00 37.50           C  
ATOM     24  CD1 ILE A   5      25.215 117.166 -17.357  1.00 39.09           C  
ATOM     25  N   GLU A   6      21.439 118.392 -15.056  1.00 36.30           N  
ATOM     26  CA  GLU A   6      20.163 117.799 -15.417  1.00 35.75           C  
ATOM     27  C   GLU A   6      20.201 117.363 -16.872  1.00 34.27           C  
ATOM     28  O   GLU A   6      20.754 118.055 -17.723  1.00 31.83           O  
ATOM     29  CB  GLU A   6      19.016 118.789 -15.220  1.00 38.37           C  
ATOM     30  CG  GLU A   6      18.958 119.887 -16.259  1.00 42.84           C  
ATOM     31  CD  GLU A   6      17.542 120.392 -16.485  1.00 45.94           C  
ATOM     32  OE1 GLU A   6      16.877 120.770 -15.495  1.00 46.35           O  
ATOM     33  OE2 GLU A   6      17.098 120.408 -17.654  1.00 47.72           O  
ATOM     34  N   VAL A   7      19.631 116.199 -17.150  1.00 32.68           N  
ATOM     35  CA  VAL A   7      19.577 115.707 -18.517  1.00 30.70           C  
ATOM     36  C   VAL A   7      18.117 115.476 -18.845  1.00 29.77           C  
ATOM     37  O   VAL A   7      17.307 115.226 -17.956  1.00 29.12           O  
ATOM     38  CB  VAL A   7      20.364 114.385 -18.707  1.00 30.90           C  
ATOM     39  CG1 VAL A   7      21.847 114.648 -18.577  1.00 31.63           C  
ATOM     40  CG2 VAL A   7      19.911 113.348 -17.692  1.00 28.18           C  
ATOM     41  N   THR A   8      17.787 115.576 -20.124  1.00 29.20           N  
ATOM     42  CA  THR A   8      16.420 115.386 -20.577  1.00 27.87           C  
ATOM     43  C   THR A   8      16.439 114.488 -21.807  1.00 28.44           C  
ATOM     44  O   THR A   8      17.501 114.182 -22.351  1.00 27.85           O  
ATOM     45  CB  THR A   8      15.755 116.745 -20.952  1.00 29.06           C  
ATOM     46  OG1 THR A   8      16.522 117.386 -21.976  1.00 27.45           O  
ATOM     47  CG2 THR A   8      15.682 117.666 -19.740  1.00 30.48           C  
ATOM     48  N   ASP A   9      15.256 114.071 -22.240  1.00 31.20           N  
ATOM     49  CA  ASP A   9      15.124 113.206 -23.406  1.00 34.31           C  
ATOM     50  C   ASP A   9      15.772 113.835 -24.640  1.00 34.85           C  
ATOM     51  O   ASP A   9      16.155 113.139 -25.576  1.00 36.74           O  
ATOM     52  CB  ASP A   9      13.643 112.947 -23.678  1.00 35.94           C  
ATOM     53  CG  ASP A   9      13.418 111.981 -24.825  1.00 39.05           C  
ATOM     54  OD1 ASP A   9      13.803 110.797 -24.699  1.00 39.75           O  
ATOM     55  OD2 ASP A   9      12.852 112.408 -25.854  1.00 41.34           O  
ATOM     56  N   GLN A  10      15.904 115.154 -24.625  1.00 36.50           N  
ATOM     57  CA  GLN A  10      16.476 115.874 -25.755  1.00 38.16           C  
ATOM     58  C   GLN A  10      18.003 115.884 -25.801  1.00 36.64           C  
ATOM     59  O   GLN A  10      18.594 115.752 -26.875  1.00 37.64           O  
ATOM     60  CB  GLN A  10      15.939 117.308 -25.771  1.00 41.45           C  
ATOM     61  CG  GLN A  10      14.407 117.399 -25.843  1.00 46.02           C  
ATOM     62  CD  GLN A  10      13.710 116.791 -24.626  1.00 48.75           C  
ATOM     63  OE1 GLN A  10      13.933 117.212 -23.491  1.00 48.98           O  
ATOM     64  NE2 GLN A  10      12.861 115.794 -24.865  1.00 50.40           N  
ATOM     65  N   ASN A  11      18.648 116.030 -24.648  1.00 32.99           N  
ATOM     66  CA  ASN A  11      20.109 116.057 -24.624  1.00 31.09           C  
ATOM     67  C   ASN A  11      20.727 114.797 -24.029  1.00 28.05           C  
ATOM     68  O   ASN A  11      21.944 114.702 -23.910  1.00 27.66           O  
ATOM     69  CB  ASN A  11      20.612 117.272 -23.842  1.00 32.60           C  
ATOM     70  CG  ASN A  11      20.156 117.266 -22.402  1.00 34.67           C  
ATOM     71  OD1 ASN A  11      20.083 116.215 -21.770  1.00 29.27           O  
ATOM     72  ND2 ASN A  11      19.854 118.445 -21.869  1.00 38.34           N  
ATOM     73  N   PHE A  12      19.886 113.836 -23.661  1.00 28.23           N  
ATOM     74  CA  PHE A  12      20.354 112.588 -23.064  1.00 26.38           C  
ATOM     75  C   PHE A  12      21.475 111.962 -23.876  1.00 26.36           C  
ATOM     76  O   PHE A  12      22.581 111.759 -23.380  1.00 24.59           O  
ATOM     77  CB  PHE A  12      19.200 111.588 -22.953  1.00 27.61           C  
ATOM     78  CG  PHE A  12      19.513 110.398 -22.091  1.00 26.80           C  
ATOM     79  CD1 PHE A  12      19.567 110.522 -20.711  1.00 29.00           C  
ATOM     80  CD2 PHE A  12      19.781 109.158 -22.665  1.00 30.90           C  
ATOM     81  CE1 PHE A  12      19.884 109.428 -19.906  1.00 31.85           C  
ATOM     82  CE2 PHE A  12      20.100 108.056 -21.872  1.00 29.66           C  
ATOM     83  CZ  PHE A  12      20.152 108.191 -20.491  1.00 30.68           C  
ATOM     84  N   ASP A  13      21.184 111.657 -25.136  1.00 27.37           N  
ATOM     85  CA  ASP A  13      22.168 111.044 -26.017  1.00 27.51           C  
ATOM     86  C   ASP A  13      23.405 111.909 -26.229  1.00 28.14           C  
ATOM     87  O   ASP A  13      24.531 111.408 -26.223  1.00 28.44           O  
ATOM     88  CB  ASP A  13      21.515 110.713 -27.359  1.00 28.18           C  
ATOM     89  CG  ASP A  13      20.476 109.612 -27.238  1.00 29.08           C  
ATOM     90  OD1 ASP A  13      20.870 108.434 -27.127  1.00 29.07           O  
ATOM     91  OD2 ASP A  13      19.269 109.925 -27.231  1.00 28.88           O  
ATOM     92  N   GLU A  14      23.198 113.207 -26.417  1.00 30.17           N  
ATOM     93  CA  GLU A  14      24.311 114.124 -26.632  1.00 31.75           C  
ATOM     94  C   GLU A  14      25.260 114.139 -25.425  1.00 31.29           C  
ATOM     95  O   GLU A  14      26.484 114.154 -25.580  1.00 32.65           O  
ATOM     96  CB  GLU A  14      23.769 115.531 -26.926  1.00 36.05           C  
ATOM     97  CG  GLU A  14      22.754 115.546 -28.079  1.00 42.15           C  
ATOM     98  CD  GLU A  14      22.215 116.931 -28.410  1.00 45.59           C  
ATOM     99  OE1 GLU A  14      21.839 117.669 -27.472  1.00 48.87           O  
ATOM    100  OE2 GLU A  14      22.151 117.276 -29.616  1.00 47.56           O  
ATOM    101  N   THR A  15      24.698 114.109 -24.222  1.00 28.81           N  
ATOM    102  CA  THR A  15      25.518 114.112 -23.014  1.00 28.12           C  
ATOM    103  C   THR A  15      26.363 112.840 -22.911  1.00 29.09           C  
ATOM    104  O   THR A  15      27.561 112.901 -22.629  1.00 28.51           O  
ATOM    105  CB  THR A  15      24.645 114.227 -21.748  1.00 28.72           C  
ATOM    106  OG1 THR A  15      23.786 115.371 -21.859  1.00 25.92           O  
ATOM    107  CG2 THR A  15      25.519 114.382 -20.511  1.00 29.61           C  
ATOM    108  N   LEU A  16      25.737 111.689 -23.149  1.00 27.50           N  
ATOM    109  CA  LEU A  16      26.433 110.407 -23.073  1.00 29.05           C  
ATOM    110  C   LEU A  16      27.561 110.266 -24.082  1.00 29.80           C  
ATOM    111  O   LEU A  16      28.546 109.582 -23.822  1.00 31.39           O  
ATOM    112  CB  LEU A  16      25.448 109.246 -23.263  1.00 26.53           C  
ATOM    113  CG  LEU A  16      24.372 109.081 -22.194  1.00 28.01           C  
ATOM    114  CD1 LEU A  16      23.492 107.887 -22.544  1.00 30.52           C  
ATOM    115  CD2 LEU A  16      25.022 108.890 -20.834  1.00 29.80           C  
ATOM    116  N   GLY A  17      27.416 110.906 -25.236  1.00 31.29           N  
ATOM    117  CA  GLY A  17      28.444 110.804 -26.256  1.00 35.07           C  
ATOM    118  C   GLY A  17      29.634 111.729 -26.069  1.00 36.06           C  
ATOM    119  O   GLY A  17      30.663 111.550 -26.725  1.00 38.11           O  
ATOM    120  N   GLN A  18      29.504 112.704 -25.173  1.00 36.92           N  
ATOM    121  CA  GLN A  18      30.571 113.675 -24.915  1.00 39.00           C  
ATOM    122  C   GLN A  18      31.430 113.385 -23.679  1.00 39.96           C  
ATOM    123  O   GLN A  18      32.506 113.966 -23.517  1.00 40.03           O  
ATOM    124  CB  GLN A  18      29.973 115.075 -24.776  1.00 42.23           C  
ATOM    125  CG  GLN A  18      29.194 115.553 -25.987  1.00 44.44           C  
ATOM    126  CD  GLN A  18      28.604 116.937 -25.780  1.00 47.74           C  
ATOM    127  OE1 GLN A  18      27.824 117.158 -24.850  1.00 50.36           O  
ATOM    128  NE2 GLN A  18      28.977 117.877 -26.642  1.00 47.43           N  
ATOM    129  N   HIS A  19      30.955 112.506 -22.802  1.00 37.44           N  
ATOM    130  CA  HIS A  19      31.703 112.164 -21.598  1.00 35.98           C  
ATOM    131  C   HIS A  19      31.956 110.665 -21.536  1.00 33.71           C  
ATOM    132  O   HIS A  19      31.051 109.861 -21.764  1.00 32.82           O  
ATOM    133  CB  HIS A  19      30.944 112.618 -20.351  1.00 37.85           C  
ATOM    134  CG  HIS A  19      30.598 114.074 -20.352  1.00 39.77           C  
ATOM    135  ND1 HIS A  19      29.675 114.620 -21.219  1.00 40.97           N  
ATOM    136  CD2 HIS A  19      31.066 115.102 -19.606  1.00 41.17           C  
ATOM    137  CE1 HIS A  19      29.589 115.920 -21.007  1.00 39.61           C  
ATOM    138  NE2 HIS A  19      30.422 116.238 -20.032  1.00 42.40           N  
ATOM    139  N   PRO A  20      33.199 110.270 -21.223  1.00 31.97           N  
ATOM    140  CA  PRO A  20      33.598 108.862 -21.129  1.00 30.36           C  
ATOM    141  C   PRO A  20      32.907 108.055 -20.033  1.00 27.38           C  
ATOM    142  O   PRO A  20      32.770 106.838 -20.155  1.00 26.52           O  
ATOM    143  CB  PRO A  20      35.107 108.950 -20.917  1.00 32.20           C  
ATOM    144  CG  PRO A  20      35.254 110.230 -20.139  1.00 33.15           C  
ATOM    145  CD  PRO A  20      34.332 111.156 -20.893  1.00 33.86           C  
ATOM    146  N   LEU A  21      32.487 108.726 -18.964  1.00 25.19           N  
ATOM    147  CA  LEU A  21      31.819 108.045 -17.858  1.00 24.58           C  
ATOM    148  C   LEU A  21      30.728 108.922 -17.257  1.00 21.74           C  
ATOM    149  O   LEU A  21      31.005 109.978 -16.678  1.00 19.56           O  
ATOM    150  CB  LEU A  21      32.836 107.664 -16.777  1.00 26.74           C  
ATOM    151  CG  LEU A  21      32.401 106.587 -15.781  1.00 27.62           C  
ATOM    152  CD1 LEU A  21      32.315 105.230 -16.486  1.00 27.96           C  
ATOM    153  CD2 LEU A  21      33.402 106.517 -14.638  1.00 32.43           C  
ATOM    154  N   VAL A  22      29.482 108.483 -17.384  1.00 20.34           N  
ATOM    155  CA  VAL A  22      28.369 109.256 -16.856  1.00 21.01           C  
ATOM    156  C   VAL A  22      27.448 108.420 -15.972  1.00 21.38           C  
ATOM    157  O   VAL A  22      27.014 107.330 -16.359  1.00 22.49           O  
ATOM    158  CB  VAL A  22      27.538 109.867 -18.003  1.00 21.00           C  
ATOM    159  CG1 VAL A  22      26.481 110.803 -17.443  1.00 21.57           C  
ATOM    160  CG2 VAL A  22      28.448 110.599 -18.974  1.00 22.84           C  
ATOM    161  N   LEU A  23      27.165 108.938 -14.783  1.00 20.11           N  
ATOM    162  CA  LEU A  23      26.281 108.279 -13.828  1.00 20.98           C  
ATOM    163  C   LEU A  23      24.950 109.019 -13.915  1.00 21.13           C  
ATOM    164  O   LEU A  23      24.875 110.208 -13.602  1.00 20.70           O  
ATOM    165  CB  LEU A  23      26.851 108.397 -12.407  1.00 23.28           C  
ATOM    166  CG  LEU A  23      26.180 107.629 -11.268  1.00 25.64           C  
ATOM    167  CD1 LEU A  23      26.440 106.145 -11.456  1.00 26.62           C  
ATOM    168  CD2 LEU A  23      26.737 108.090  -9.914  1.00 23.46           C  
ATOM    169  N   VAL A  24      23.908 108.322 -14.354  1.00 20.41           N  
ATOM    170  CA  VAL A  24      22.585 108.928 -14.502  1.00 19.52           C  
ATOM    171  C   VAL A  24      21.602 108.450 -13.440  1.00 20.12           C  
ATOM    172  O   VAL A  24      21.324 107.256 -13.311  1.00 14.86           O  
ATOM    173  CB  VAL A  24      21.984 108.621 -15.896  1.00 21.94           C  
ATOM    174  CG1 VAL A  24      20.608 109.273 -16.038  1.00 22.03           C  
ATOM    175  CG2 VAL A  24      22.930 109.111 -16.987  1.00 21.43           C  
ATOM    176  N   ASP A  25      21.067 109.403 -12.686  1.00 18.96           N  
ATOM    177  CA  ASP A  25      20.108 109.098 -11.637  1.00 22.13           C  
ATOM    178  C   ASP A  25      18.680 109.328 -12.144  1.00 21.54           C  
ATOM    179  O   ASP A  25      18.309 110.447 -12.489  1.00 21.54           O  
ATOM    180  CB  ASP A  25      20.423 109.969 -10.414  1.00 24.69           C  
ATOM    181  CG  ASP A  25      19.314 109.974  -9.386  1.00 29.54           C  
ATOM    182  OD1 ASP A  25      18.699 108.913  -9.146  1.00 27.04           O  
ATOM    183  OD2 ASP A  25      19.071 111.051  -8.797  1.00 33.49           O  
ATOM    184  N   PHE A  26      17.901 108.252 -12.230  1.00 19.67           N  
ATOM    185  CA  PHE A  26      16.510 108.335 -12.667  1.00 20.46           C  
ATOM    186  C   PHE A  26      15.751 108.571 -11.380  1.00 21.25           C  
ATOM    187  O   PHE A  26      15.728 107.706 -10.497  1.00 20.03           O  
ATOM    188  CB  PHE A  26      16.074 107.021 -13.327  1.00 19.40           C  
ATOM    189  CG  PHE A  26      16.665 106.810 -14.690  1.00 21.93           C  
ATOM    190  CD1 PHE A  26      15.922 107.080 -15.837  1.00 23.87           C  
ATOM    191  CD2 PHE A  26      17.971 106.346 -14.832  1.00 19.95           C  
ATOM    192  CE1 PHE A  26      16.471 106.887 -17.109  1.00 22.03           C  
ATOM    193  CE2 PHE A  26      18.523 106.151 -16.094  1.00 22.23           C  
ATOM    194  CZ  PHE A  26      17.771 106.423 -17.232  1.00 23.61           C  
ATOM    195  N   TRP A  27      15.141 109.748 -11.265  1.00 22.22           N  
ATOM    196  CA  TRP A  27      14.448 110.107 -10.035  1.00 24.35           C  
ATOM    197  C   TRP A  27      13.136 110.854 -10.244  1.00 24.99           C  
ATOM    198  O   TRP A  27      12.794 111.253 -11.357  1.00 20.91           O  
ATOM    199  CB  TRP A  27      15.364 110.985  -9.180  1.00 25.83           C  
ATOM    200  CG  TRP A  27      15.542 112.355  -9.769  1.00 28.07           C  
ATOM    201  CD1 TRP A  27      16.229 112.678 -10.907  1.00 26.70           C  
ATOM    202  CD2 TRP A  27      14.946 113.575  -9.302  1.00 30.82           C  
ATOM    203  NE1 TRP A  27      16.092 114.017 -11.180  1.00 29.35           N  
ATOM    204  CE2 TRP A  27      15.309 114.592 -10.212  1.00 30.49           C  
ATOM    205  CE3 TRP A  27      14.137 113.903  -8.207  1.00 32.39           C  
ATOM    206  CZ2 TRP A  27      14.889 115.920 -10.060  1.00 34.43           C  
ATOM    207  CZ3 TRP A  27      13.718 115.225  -8.055  1.00 34.69           C  
ATOM    208  CH2 TRP A  27      14.097 116.216  -8.977  1.00 34.94           C  
ATOM    209  N   ALA A  28      12.431 111.056  -9.135  1.00 27.49           N  
ATOM    210  CA  ALA A  28      11.155 111.760  -9.113  1.00 31.26           C  
ATOM    211  C   ALA A  28      11.045 112.484  -7.773  1.00 33.98           C  
ATOM    212  O   ALA A  28      11.495 111.973  -6.748  1.00 31.59           O  
ATOM    213  CB  ALA A  28      10.010 110.771  -9.263  1.00 32.07           C  
ATOM    214  N   GLU A  29      10.452 113.673  -7.788  1.00 37.53           N  
ATOM    215  CA  GLU A  29      10.284 114.469  -6.574  1.00 42.78           C  
ATOM    216  C   GLU A  29       9.335 113.837  -5.555  1.00 43.08           C  
ATOM    217  O   GLU A  29       9.406 114.142  -4.363  1.00 44.81           O  
ATOM    218  CB  GLU A  29       9.785 115.872  -6.937  1.00 45.13           C  
ATOM    219  CG  GLU A  29       8.755 115.893  -8.056  1.00 49.21           C  
ATOM    220  CD  GLU A  29       9.386 115.728  -9.432  1.00 52.34           C  
ATOM    221  OE1 GLU A  29      10.138 116.636  -9.851  1.00 54.98           O  
ATOM    222  OE2 GLU A  29       9.135 114.697 -10.095  1.00 51.00           O  
ATOM    223  N   TRP A  30       8.446 112.964  -6.021  1.00 43.66           N  
ATOM    224  CA  TRP A  30       7.489 112.300  -5.138  1.00 44.39           C  
ATOM    225  C   TRP A  30       8.042 111.011  -4.544  1.00 44.29           C  
ATOM    226  O   TRP A  30       7.293 110.216  -3.977  1.00 45.72           O  
ATOM    227  CB  TRP A  30       6.204 111.971  -5.900  1.00 46.27           C  
ATOM    228  CG  TRP A  30       6.433 111.230  -7.188  1.00 46.87           C  
ATOM    229  CD1 TRP A  30       6.460 111.764  -8.445  1.00 47.40           C  
ATOM    230  CD2 TRP A  30       6.685 109.826  -7.343  1.00 46.95           C  
ATOM    231  NE1 TRP A  30       6.712 110.781  -9.374  1.00 47.82           N  
ATOM    232  CE2 TRP A  30       6.855 109.583  -8.724  1.00 47.30           C  
ATOM    233  CE3 TRP A  30       6.785 108.751  -6.449  1.00 46.98           C  
ATOM    234  CZ2 TRP A  30       7.119 108.306  -9.236  1.00 47.85           C  
ATOM    235  CZ3 TRP A  30       7.050 107.481  -6.957  1.00 47.72           C  
ATOM    236  CH2 TRP A  30       7.214 107.272  -8.339  1.00 48.32           C  
ATOM    237  N   CYS A  31       9.346 110.802  -4.670  1.00 43.05           N  
ATOM    238  CA  CYS A  31       9.966 109.590  -4.154  1.00 40.13           C  
ATOM    239  C   CYS A  31      10.939 109.874  -3.014  1.00 39.38           C  
ATOM    240  O   CYS A  31      12.029 110.394  -3.238  1.00 40.02           O  
ATOM    241  CB  CYS A  31      10.693 108.873  -5.291  1.00 40.88           C  
ATOM    242  SG  CYS A  31      11.376 107.274  -4.849  1.00 38.67           S  
ATOM    243  N   ALA A  32      10.546 109.523  -1.791  1.00 38.14           N  
ATOM    244  CA  ALA A  32      11.392 109.746  -0.623  1.00 37.60           C  
ATOM    245  C   ALA A  32      12.794 109.162  -0.804  1.00 36.42           C  
ATOM    246  O   ALA A  32      13.787 109.837  -0.543  1.00 36.26           O  
ATOM    247  CB  ALA A  32      10.733 109.159   0.624  1.00 38.98           C  
ATOM    248  N   PRO A  33      12.895 107.897  -1.247  1.00 35.86           N  
ATOM    249  CA  PRO A  33      14.217 107.291  -1.442  1.00 36.42           C  
ATOM    250  C   PRO A  33      15.124 108.145  -2.329  1.00 35.74           C  
ATOM    251  O   PRO A  33      16.342 108.163  -2.149  1.00 34.81           O  
ATOM    252  CB  PRO A  33      13.888 105.946  -2.084  1.00 37.52           C  
ATOM    253  CG  PRO A  33      12.580 105.598  -1.446  1.00 36.60           C  
ATOM    254  CD  PRO A  33      11.829 106.914  -1.513  1.00 36.43           C  
ATOM    255  N   CYS A  34      14.527 108.849  -3.288  1.00 34.62           N  
ATOM    256  CA  CYS A  34      15.300 109.703  -4.185  1.00 34.49           C  
ATOM    257  C   CYS A  34      15.920 110.867  -3.426  1.00 35.04           C  
ATOM    258  O   CYS A  34      17.070 111.231  -3.665  1.00 33.59           O  
ATOM    259  CB  CYS A  34      14.416 110.231  -5.316  1.00 34.63           C  
ATOM    260  SG  CYS A  34      13.986 108.983  -6.537  1.00 34.72           S  
ATOM    261  N   ARG A  35      15.157 111.448  -2.505  1.00 36.42           N  
ATOM    262  CA  ARG A  35      15.657 112.561  -1.707  1.00 39.29           C  
ATOM    263  C   ARG A  35      16.864 112.108  -0.892  1.00 38.20           C  
ATOM    264  O   ARG A  35      17.801 112.873  -0.679  1.00 37.91           O  
ATOM    265  CB  ARG A  35      14.570 113.076  -0.757  1.00 41.73           C  
ATOM    266  CG  ARG A  35      13.323 113.613  -1.451  1.00 46.93           C  
ATOM    267  CD  ARG A  35      12.223 113.925  -0.441  1.00 49.84           C  
ATOM    268  NE  ARG A  35      11.005 114.408  -1.086  1.00 53.92           N  
ATOM    269  CZ  ARG A  35       9.860 114.639  -0.448  1.00 55.72           C  
ATOM    270  NH1 ARG A  35       9.773 114.429   0.858  1.00 57.33           N  
ATOM    271  NH2 ARG A  35       8.804 115.088  -1.116  1.00 56.61           N  
HETATM  272  N   MSE A  36      16.834 110.857  -0.436  1.00 39.67           N  
HETATM  273  CA  MSE A  36      17.923 110.307   0.364  1.00 40.38           C  
HETATM  274  C   MSE A  36      19.258 110.241  -0.366  1.00 37.97           C  
HETATM  275  O   MSE A  36      20.289 110.617   0.186  1.00 37.19           O  
HETATM  276  CB  MSE A  36      17.583 108.896   0.863  1.00 45.38           C  
HETATM  277  CG  MSE A  36      16.692 108.825   2.093  1.00 53.45           C  
HETATM  278 SE   MSE A  36      16.938 107.127   3.032  1.00 64.19          SE  
HETATM  279  CE  MSE A  36      18.046 107.791   4.457  1.00 62.60           C  
ATOM    280  N   ILE A  37      19.250 109.754  -1.601  1.00 36.21           N  
ATOM    281  CA  ILE A  37      20.499 109.634  -2.340  1.00 34.35           C  
ATOM    282  C   ILE A  37      20.979 110.929  -2.979  1.00 32.37           C  
ATOM    283  O   ILE A  37      22.147 111.036  -3.349  1.00 30.94           O  
ATOM    284  CB  ILE A  37      20.411 108.554  -3.441  1.00 36.18           C  
ATOM    285  CG1 ILE A  37      19.482 109.012  -4.565  1.00 36.77           C  
ATOM    286  CG2 ILE A  37      19.916 107.250  -2.844  1.00 36.49           C  
ATOM    287  CD1 ILE A  37      19.474 108.075  -5.764  1.00 38.50           C  
ATOM    288  N   ALA A  38      20.093 111.914  -3.101  1.00 31.00           N  
ATOM    289  CA  ALA A  38      20.466 113.186  -3.718  1.00 30.47           C  
ATOM    290  C   ALA A  38      21.791 113.735  -3.189  1.00 29.47           C  
ATOM    291  O   ALA A  38      22.729 113.953  -3.957  1.00 29.67           O  
ATOM    292  CB  ALA A  38      19.346 114.218  -3.526  1.00 32.01           C  
ATOM    293  N   PRO A  39      21.895 113.963  -1.867  1.00 30.13           N  
ATOM    294  CA  PRO A  39      23.159 114.489  -1.334  1.00 29.08           C  
ATOM    295  C   PRO A  39      24.315 113.505  -1.501  1.00 28.30           C  
ATOM    296  O   PRO A  39      25.477 113.904  -1.617  1.00 28.84           O  
ATOM    297  CB  PRO A  39      22.821 114.771   0.130  1.00 30.45           C  
ATOM    298  CG  PRO A  39      21.791 113.730   0.438  1.00 30.99           C  
ATOM    299  CD  PRO A  39      20.913 113.761  -0.788  1.00 32.06           C  
ATOM    300  N   ILE A  40      23.999 112.214  -1.523  1.00 28.44           N  
ATOM    301  CA  ILE A  40      25.028 111.198  -1.699  1.00 27.37           C  
ATOM    302  C   ILE A  40      25.612 111.339  -3.103  1.00 27.32           C  
ATOM    303  O   ILE A  40      26.828 111.310  -3.284  1.00 27.24           O  
ATOM    304  CB  ILE A  40      24.454 109.762  -1.504  1.00 29.26           C  
ATOM    305  CG1 ILE A  40      24.319 109.441  -0.009  1.00 30.45           C  
ATOM    306  CG2 ILE A  40      25.371 108.733  -2.152  1.00 27.04           C  
ATOM    307  CD1 ILE A  40      23.455 110.408   0.771  1.00 34.74           C  
ATOM    308  N   LEU A  41      24.744 111.505  -4.097  1.00 28.27           N  
ATOM    309  CA  LEU A  41      25.197 111.661  -5.475  1.00 28.58           C  
ATOM    310  C   LEU A  41      26.022 112.933  -5.616  1.00 29.13           C  
ATOM    311  O   LEU A  41      26.912 113.020  -6.458  1.00 28.51           O  
ATOM    312  CB  LEU A  41      24.003 111.709  -6.430  1.00 29.84           C  
ATOM    313  CG  LEU A  41      23.173 110.426  -6.510  1.00 33.83           C  
ATOM    314  CD1 LEU A  41      21.989 110.641  -7.438  1.00 35.41           C  
ATOM    315  CD2 LEU A  41      24.041 109.281  -7.001  1.00 33.56           C  
ATOM    316  N   GLU A  42      25.715 113.926  -4.793  1.00 31.13           N  
ATOM    317  CA  GLU A  42      26.458 115.178  -4.826  1.00 33.49           C  
ATOM    318  C   GLU A  42      27.899 114.957  -4.377  1.00 32.20           C  
ATOM    319  O   GLU A  42      28.834 115.484  -4.984  1.00 32.11           O  
ATOM    320  CB  GLU A  42      25.788 116.214  -3.928  1.00 35.88           C  
ATOM    321  CG  GLU A  42      24.520 116.802  -4.501  1.00 42.13           C  
ATOM    322  CD  GLU A  42      23.920 117.852  -3.587  1.00 46.70           C  
ATOM    323  OE1 GLU A  42      24.685 118.699  -3.081  1.00 50.39           O  
ATOM    324  OE2 GLU A  42      22.687 117.837  -3.380  1.00 51.02           O  
ATOM    325  N   GLU A  43      28.080 114.179  -3.312  1.00 32.61           N  
ATOM    326  CA  GLU A  43      29.422 113.900  -2.804  1.00 32.64           C  
ATOM    327  C   GLU A  43      30.181 113.076  -3.837  1.00 31.51           C  
ATOM    328  O   GLU A  43      31.394 113.225  -4.000  1.00 29.59           O  
ATOM    329  CB  GLU A  43      29.352 113.139  -1.473  1.00 34.36           C  
ATOM    330  CG  GLU A  43      28.590 113.872  -0.383  1.00 37.97           C  
ATOM    331  CD  GLU A  43      28.601 113.131   0.946  1.00 42.10           C  
ATOM    332  OE1 GLU A  43      27.889 113.565   1.878  1.00 44.96           O  
ATOM    333  OE2 GLU A  43      29.324 112.120   1.064  1.00 43.46           O  
ATOM    334  N   ILE A  44      29.457 112.208  -4.538  1.00 29.39           N  
ATOM    335  CA  ILE A  44      30.060 111.380  -5.575  1.00 27.99           C  
ATOM    336  C   ILE A  44      30.553 112.299  -6.690  1.00 28.25           C  
ATOM    337  O   ILE A  44      31.651 112.125  -7.212  1.00 26.81           O  
ATOM    338  CB  ILE A  44      29.032 110.377  -6.184  1.00 27.36           C  
ATOM    339  CG1 ILE A  44      28.643 109.311  -5.155  1.00 26.71           C  
ATOM    340  CG2 ILE A  44      29.621 109.720  -7.424  1.00 26.19           C  
ATOM    341  CD1 ILE A  44      29.749 108.339  -4.814  1.00 28.62           C  
ATOM    342  N   ALA A  45      29.730 113.281  -7.050  1.00 28.97           N  
ATOM    343  CA  ALA A  45      30.080 114.224  -8.111  1.00 31.27           C  
ATOM    344  C   ALA A  45      31.411 114.908  -7.802  1.00 33.65           C  
ATOM    345  O   ALA A  45      32.304 114.962  -8.651  1.00 34.56           O  
ATOM    346  CB  ALA A  45      28.977 115.263  -8.271  1.00 29.41           C  
ATOM    347  N   LYS A  46      31.540 115.419  -6.579  1.00 34.68           N  
ATOM    348  CA  LYS A  46      32.767 116.082  -6.141  1.00 35.95           C  
ATOM    349  C   LYS A  46      33.966 115.135  -6.134  1.00 35.64           C  
ATOM    350  O   LYS A  46      34.972 115.391  -6.791  1.00 34.57           O  
ATOM    351  CB  LYS A  46      32.584 116.666  -4.740  1.00 38.82           C  
ATOM    352  CG  LYS A  46      31.865 118.001  -4.703  1.00 43.49           C  
ATOM    353  CD  LYS A  46      32.689 119.090  -5.382  1.00 45.23           C  
ATOM    354  CE  LYS A  46      32.036 120.454  -5.224  1.00 47.97           C  
ATOM    355  NZ  LYS A  46      31.892 120.823  -3.786  1.00 48.44           N  
ATOM    356  N   GLU A  47      33.853 114.041  -5.388  1.00 35.48           N  
ATOM    357  CA  GLU A  47      34.933 113.063  -5.289  1.00 36.41           C  
ATOM    358  C   GLU A  47      35.528 112.650  -6.636  1.00 37.81           C  
ATOM    359  O   GLU A  47      36.750 112.514  -6.768  1.00 35.23           O  
ATOM    360  CB  GLU A  47      34.447 111.814  -4.535  1.00 37.76           C  
ATOM    361  CG  GLU A  47      35.298 110.564  -4.782  1.00 39.50           C  
ATOM    362  CD  GLU A  47      34.935 109.394  -3.871  1.00 40.27           C  
ATOM    363  OE1 GLU A  47      33.794 109.356  -3.361  1.00 41.60           O  
ATOM    364  OE2 GLU A  47      35.790 108.501  -3.679  1.00 40.35           O  
ATOM    365  N   TYR A  48      34.670 112.453  -7.634  1.00 38.15           N  
ATOM    366  CA  TYR A  48      35.134 112.027  -8.951  1.00 39.25           C  
ATOM    367  C   TYR A  48      35.074 113.108 -10.031  1.00 40.74           C  
ATOM    368  O   TYR A  48      34.987 112.797 -11.216  1.00 40.88           O  
ATOM    369  CB  TYR A  48      34.326 110.811  -9.411  1.00 38.10           C  
ATOM    370  CG  TYR A  48      34.459 109.601  -8.513  1.00 37.30           C  
ATOM    371  CD1 TYR A  48      35.606 108.805  -8.541  1.00 37.52           C  
ATOM    372  CD2 TYR A  48      33.429 109.240  -7.647  1.00 37.91           C  
ATOM    373  CE1 TYR A  48      35.719 107.672  -7.727  1.00 36.21           C  
ATOM    374  CE2 TYR A  48      33.531 108.113  -6.829  1.00 36.75           C  
ATOM    375  CZ  TYR A  48      34.675 107.335  -6.877  1.00 36.97           C  
ATOM    376  OH  TYR A  48      34.761 106.215  -6.080  1.00 36.21           O  
ATOM    377  N   GLU A  49      35.124 114.374  -9.631  1.00 42.93           N  
ATOM    378  CA  GLU A  49      35.080 115.455 -10.608  1.00 44.87           C  
ATOM    379  C   GLU A  49      36.223 115.305 -11.615  1.00 44.06           C  
ATOM    380  O   GLU A  49      37.344 114.953 -11.250  1.00 43.14           O  
ATOM    381  CB  GLU A  49      35.172 116.815  -9.909  1.00 47.67           C  
ATOM    382  CG  GLU A  49      36.438 117.027  -9.097  1.00 51.95           C  
ATOM    383  CD  GLU A  49      36.545 118.441  -8.552  1.00 54.64           C  
ATOM    384  OE1 GLU A  49      35.647 118.858  -7.788  1.00 56.45           O  
ATOM    385  OE2 GLU A  49      37.527 119.136  -8.890  1.00 56.08           O  
ATOM    386  N   GLY A  50      35.927 115.559 -12.886  1.00 43.59           N  
ATOM    387  CA  GLY A  50      36.942 115.446 -13.918  1.00 42.70           C  
ATOM    388  C   GLY A  50      37.048 114.052 -14.511  1.00 42.62           C  
ATOM    389  O   GLY A  50      37.614 113.873 -15.593  1.00 42.66           O  
ATOM    390  N   LYS A  51      36.506 113.060 -13.807  1.00 40.12           N  
ATOM    391  CA  LYS A  51      36.548 111.678 -14.271  1.00 38.19           C  
ATOM    392  C   LYS A  51      35.136 111.135 -14.466  1.00 35.82           C  
ATOM    393  O   LYS A  51      34.930 110.159 -15.187  1.00 35.70           O  
ATOM    394  CB  LYS A  51      37.269 110.789 -13.251  1.00 40.99           C  
ATOM    395  CG  LYS A  51      38.637 111.288 -12.809  1.00 44.52           C  
ATOM    396  CD  LYS A  51      39.215 110.382 -11.732  1.00 47.71           C  
ATOM    397  CE  LYS A  51      40.572 110.872 -11.253  1.00 48.87           C  
ATOM    398  NZ  LYS A  51      41.165 109.946 -10.244  1.00 50.66           N  
ATOM    399  N   LEU A  52      34.171 111.774 -13.816  1.00 33.29           N  
ATOM    400  CA  LEU A  52      32.784 111.333 -13.882  1.00 31.79           C  
ATOM    401  C   LEU A  52      31.796 112.477 -13.952  1.00 29.88           C  
ATOM    402  O   LEU A  52      31.935 113.478 -13.252  1.00 31.41           O  
ATOM    403  CB  LEU A  52      32.445 110.495 -12.643  1.00 26.84           C  
ATOM    404  CG  LEU A  52      30.977 110.105 -12.430  1.00 24.58           C  
ATOM    405  CD1 LEU A  52      30.622 108.931 -13.325  1.00 23.24           C  
ATOM    406  CD2 LEU A  52      30.751 109.729 -10.961  1.00 21.44           C  
ATOM    407  N   LEU A  53      30.786 112.318 -14.798  1.00 30.37           N  
ATOM    408  CA  LEU A  53      29.743 113.318 -14.902  1.00 27.06           C  
ATOM    409  C   LEU A  53      28.515 112.703 -14.250  1.00 25.95           C  
ATOM    410  O   LEU A  53      28.111 111.602 -14.607  1.00 25.55           O  
ATOM    411  CB  LEU A  53      29.432 113.650 -16.363  1.00 27.24           C  
ATOM    412  CG  LEU A  53      28.301 114.673 -16.523  1.00 29.49           C  
ATOM    413  CD1 LEU A  53      28.788 116.045 -16.066  1.00 31.76           C  
ATOM    414  CD2 LEU A  53      27.848 114.736 -17.977  1.00 31.45           C  
ATOM    415  N   VAL A  54      27.945 113.394 -13.272  1.00 25.95           N  
ATOM    416  CA  VAL A  54      26.745 112.906 -12.604  1.00 26.67           C  
ATOM    417  C   VAL A  54      25.602 113.675 -13.228  1.00 26.20           C  
ATOM    418  O   VAL A  54      25.620 114.903 -13.252  1.00 26.28           O  
ATOM    419  CB  VAL A  54      26.778 113.178 -11.086  1.00 26.75           C  
ATOM    420  CG1 VAL A  54      25.457 112.757 -10.442  1.00 26.88           C  
ATOM    421  CG2 VAL A  54      27.933 112.424 -10.461  1.00 28.60           C  
ATOM    422  N   ALA A  55      24.625 112.947 -13.757  1.00 23.47           N  
ATOM    423  CA  ALA A  55      23.474 113.552 -14.408  1.00 26.03           C  
ATOM    424  C   ALA A  55      22.197 113.035 -13.758  1.00 25.65           C  
ATOM    425  O   ALA A  55      22.162 111.912 -13.255  1.00 23.80           O  
ATOM    426  CB  ALA A  55      23.484 113.219 -15.898  1.00 23.77           C  
ATOM    427  N   LYS A  56      21.156 113.861 -13.771  1.00 23.92           N  
ATOM    428  CA  LYS A  56      19.881 113.501 -13.165  1.00 24.75           C  
ATOM    429  C   LYS A  56      18.748 113.559 -14.185  1.00 24.89           C  
ATOM    430  O   LYS A  56      18.554 114.572 -14.856  1.00 25.02           O  
ATOM    431  CB  LYS A  56      19.580 114.447 -12.001  1.00 27.63           C  
ATOM    432  CG  LYS A  56      20.672 114.478 -10.935  1.00 31.53           C  
ATOM    433  CD  LYS A  56      20.353 115.478  -9.834  1.00 36.07           C  
ATOM    434  CE  LYS A  56      19.186 115.018  -8.981  1.00 36.85           C  
ATOM    435  NZ  LYS A  56      19.484 113.715  -8.323  1.00 41.54           N  
ATOM    436  N   LEU A  57      17.994 112.469 -14.286  1.00 22.73           N  
ATOM    437  CA  LEU A  57      16.886 112.385 -15.233  1.00 21.20           C  
ATOM    438  C   LEU A  57      15.576 112.284 -14.458  1.00 22.29           C  
ATOM    439  O   LEU A  57      15.307 111.269 -13.825  1.00 17.88           O  
ATOM    440  CB  LEU A  57      17.069 111.146 -16.125  1.00 22.11           C  
ATOM    441  CG  LEU A  57      16.230 110.869 -17.382  1.00 20.64           C  
ATOM    442  CD1 LEU A  57      14.773 110.654 -17.016  1.00 23.30           C  
ATOM    443  CD2 LEU A  57      16.388 112.008 -18.370  1.00 21.92           C  
ATOM    444  N   ASP A  58      14.780 113.350 -14.492  1.00 23.51           N  
ATOM    445  CA  ASP A  58      13.490 113.374 -13.810  1.00 25.06           C  
ATOM    446  C   ASP A  58      12.506 112.582 -14.662  1.00 24.13           C  
ATOM    447  O   ASP A  58      12.078 113.042 -15.722  1.00 25.97           O  
ATOM    448  CB  ASP A  58      12.996 114.813 -13.662  1.00 28.46           C  
ATOM    449  CG  ASP A  58      11.725 114.910 -12.853  1.00 31.23           C  
ATOM    450  OD1 ASP A  58      10.798 114.109 -13.088  1.00 32.88           O  
ATOM    451  OD2 ASP A  58      11.649 115.803 -11.982  1.00 38.93           O  
ATOM    452  N   VAL A  59      12.139 111.400 -14.187  1.00 25.24           N  
ATOM    453  CA  VAL A  59      11.233 110.519 -14.917  1.00 25.83           C  
ATOM    454  C   VAL A  59       9.846 111.102 -15.200  1.00 27.61           C  
ATOM    455  O   VAL A  59       9.202 110.708 -16.172  1.00 25.65           O  
ATOM    456  CB  VAL A  59      11.076 109.174 -14.183  1.00 25.69           C  
ATOM    457  CG1 VAL A  59      12.443 108.504 -14.037  1.00 24.86           C  
ATOM    458  CG2 VAL A  59      10.440 109.396 -12.815  1.00 27.57           C  
ATOM    459  N   ASP A  60       9.383 112.030 -14.367  1.00 28.77           N  
ATOM    460  CA  ASP A  60       8.072 112.630 -14.592  1.00 32.58           C  
ATOM    461  C   ASP A  60       8.106 113.584 -15.778  1.00 32.88           C  
ATOM    462  O   ASP A  60       7.117 113.718 -16.494  1.00 34.26           O  
ATOM    463  CB  ASP A  60       7.582 113.383 -13.348  1.00 35.46           C  
ATOM    464  CG  ASP A  60       7.289 112.459 -12.182  1.00 39.77           C  
ATOM    465  OD1 ASP A  60       6.748 111.357 -12.416  1.00 41.73           O  
ATOM    466  OD2 ASP A  60       7.589 112.839 -11.030  1.00 42.90           O  
ATOM    467  N   GLU A  61       9.244 114.240 -15.987  1.00 31.78           N  
ATOM    468  CA  GLU A  61       9.381 115.173 -17.095  1.00 32.23           C  
ATOM    469  C   GLU A  61       9.950 114.504 -18.348  1.00 31.01           C  
ATOM    470  O   GLU A  61       9.832 115.041 -19.446  1.00 29.88           O  
ATOM    471  CB  GLU A  61      10.270 116.365 -16.693  1.00 35.40           C  
ATOM    472  CG  GLU A  61      11.747 116.036 -16.479  1.00 39.12           C  
ATOM    473  CD  GLU A  61      12.604 117.269 -16.176  1.00 41.40           C  
ATOM    474  OE1 GLU A  61      12.298 117.982 -15.193  1.00 44.54           O  
ATOM    475  OE2 GLU A  61      13.587 117.525 -16.914  1.00 37.51           O  
ATOM    476  N   ASN A  62      10.551 113.326 -18.185  1.00 25.97           N  
ATOM    477  CA  ASN A  62      11.147 112.622 -19.319  1.00 24.65           C  
ATOM    478  C   ASN A  62      10.700 111.165 -19.376  1.00 23.09           C  
ATOM    479  O   ASN A  62      11.516 110.246 -19.267  1.00 22.36           O  
ATOM    480  CB  ASN A  62      12.673 112.696 -19.223  1.00 22.66           C  
ATOM    481  CG  ASN A  62      13.193 114.132 -19.236  1.00 22.42           C  
ATOM    482  OD1 ASN A  62      13.209 114.785 -20.271  1.00 23.75           O  
ATOM    483  ND2 ASN A  62      13.612 114.620 -18.079  1.00 24.84           N  
ATOM    484  N   PRO A  63       9.391 110.933 -19.564  1.00 22.21           N  
ATOM    485  CA  PRO A  63       8.845 109.575 -19.630  1.00 21.70           C  
ATOM    486  C   PRO A  63       9.391 108.682 -20.743  1.00 21.93           C  
ATOM    487  O   PRO A  63       9.468 107.466 -20.577  1.00 21.50           O  
ATOM    488  CB  PRO A  63       7.341 109.815 -19.769  1.00 21.64           C  
ATOM    489  CG  PRO A  63       7.274 111.105 -20.514  1.00 24.27           C  
ATOM    490  CD  PRO A  63       8.344 111.935 -19.837  1.00 23.13           C  
ATOM    491  N   LYS A  64       9.766 109.263 -21.879  1.00 20.76           N  
ATOM    492  CA  LYS A  64      10.278 108.438 -22.970  1.00 22.40           C  
ATOM    493  C   LYS A  64      11.681 107.900 -22.673  1.00 22.32           C  
ATOM    494  O   LYS A  64      12.045 106.807 -23.127  1.00 21.32           O  
ATOM    495  CB  LYS A  64      10.239 109.222 -24.292  1.00 23.61           C  
ATOM    496  CG  LYS A  64       8.799 109.570 -24.726  1.00 26.23           C  
ATOM    497  CD  LYS A  64       8.708 110.136 -26.148  1.00 30.24           C  
ATOM    498  CE  LYS A  64       9.364 111.502 -26.272  1.00 28.63           C  
ATOM    499  NZ  LYS A  64       8.657 112.514 -25.443  1.00 35.43           N  
ATOM    500  N   THR A  65      12.464 108.649 -21.900  1.00 21.36           N  
ATOM    501  CA  THR A  65      13.808 108.203 -21.536  1.00 21.19           C  
ATOM    502  C   THR A  65      13.706 107.058 -20.524  1.00 19.90           C  
ATOM    503  O   THR A  65      14.465 106.090 -20.589  1.00 21.77           O  
ATOM    504  CB  THR A  65      14.646 109.348 -20.927  1.00 22.02           C  
ATOM    505  OG1 THR A  65      14.724 110.427 -21.864  1.00 26.62           O  
ATOM    506  CG2 THR A  65      16.055 108.870 -20.616  1.00 20.55           C  
ATOM    507  N   ALA A  66      12.766 107.162 -19.593  1.00 18.75           N  
ATOM    508  CA  ALA A  66      12.579 106.105 -18.598  1.00 22.20           C  
ATOM    509  C   ALA A  66      12.074 104.838 -19.293  1.00 23.51           C  
ATOM    510  O   ALA A  66      12.533 103.731 -19.001  1.00 24.39           O  
ATOM    511  CB  ALA A  66      11.584 106.547 -17.536  1.00 22.57           C  
HETATM  512  N   MSE A  67      11.127 105.010 -20.210  1.00 24.49           N  
HETATM  513  CA  MSE A  67      10.554 103.891 -20.964  1.00 25.72           C  
HETATM  514  C   MSE A  67      11.646 103.237 -21.802  1.00 25.57           C  
HETATM  515  O   MSE A  67      11.726 102.007 -21.910  1.00 21.73           O  
HETATM  516  CB  MSE A  67       9.432 104.402 -21.877  1.00 29.52           C  
HETATM  517  CG  MSE A  67       8.826 103.352 -22.798  1.00 36.59           C  
HETATM  518 SE   MSE A  67       7.981 101.920 -21.826  1.00 43.71          SE  
HETATM  519  CE  MSE A  67       6.281 102.768 -21.500  1.00 40.23           C  
ATOM    520  N   ARG A  68      12.488 104.079 -22.396  1.00 23.75           N  
ATOM    521  CA  ARG A  68      13.584 103.625 -23.234  1.00 24.97           C  
ATOM    522  C   ARG A  68      14.440 102.583 -22.513  1.00 25.19           C  
ATOM    523  O   ARG A  68      14.806 101.564 -23.086  1.00 26.39           O  
ATOM    524  CB  ARG A  68      14.436 104.828 -23.631  1.00 25.23           C  
ATOM    525  CG  ARG A  68      15.640 104.509 -24.475  1.00 26.06           C  
ATOM    526  CD  ARG A  68      16.347 105.782 -24.894  1.00 26.02           C  
ATOM    527  NE  ARG A  68      17.577 105.491 -25.616  1.00 25.28           N  
ATOM    528  CZ  ARG A  68      18.362 106.416 -26.154  1.00 27.92           C  
ATOM    529  NH1 ARG A  68      18.046 107.700 -26.051  1.00 26.44           N  
ATOM    530  NH2 ARG A  68      19.461 106.053 -26.799  1.00 24.76           N  
ATOM    531  N   TYR A  69      14.749 102.843 -21.248  1.00 25.12           N  
ATOM    532  CA  TYR A  69      15.560 101.921 -20.470  1.00 28.56           C  
ATOM    533  C   TYR A  69      14.730 101.008 -19.581  1.00 29.59           C  
ATOM    534  O   TYR A  69      15.275 100.152 -18.879  1.00 33.33           O  
ATOM    535  CB  TYR A  69      16.573 102.705 -19.639  1.00 28.83           C  
ATOM    536  CG  TYR A  69      17.718 103.201 -20.477  1.00 28.48           C  
ATOM    537  CD1 TYR A  69      18.766 102.352 -20.819  1.00 29.92           C  
ATOM    538  CD2 TYR A  69      17.722 104.494 -20.995  1.00 31.78           C  
ATOM    539  CE1 TYR A  69      19.788 102.775 -21.657  1.00 30.19           C  
ATOM    540  CE2 TYR A  69      18.741 104.926 -21.838  1.00 29.95           C  
ATOM    541  CZ  TYR A  69      19.767 104.058 -22.164  1.00 30.42           C  
ATOM    542  OH  TYR A  69      20.763 104.465 -23.018  1.00 33.81           O  
ATOM    543  N   ARG A  70      13.414 101.184 -19.634  1.00 27.69           N  
ATOM    544  CA  ARG A  70      12.474 100.393 -18.848  1.00 30.09           C  
ATOM    545  C   ARG A  70      12.729 100.512 -17.352  1.00 31.85           C  
ATOM    546  O   ARG A  70      12.735  99.515 -16.614  1.00 29.80           O  
ATOM    547  CB  ARG A  70      12.514  98.926 -19.282  1.00 30.36           C  
ATOM    548  CG  ARG A  70      11.975  98.695 -20.688  1.00 32.46           C  
ATOM    549  CD  ARG A  70      11.972  97.220 -21.042  1.00 32.30           C  
ATOM    550  NE  ARG A  70      11.115  96.460 -20.140  1.00 34.56           N  
ATOM    551  CZ  ARG A  70       9.786  96.469 -20.185  1.00 34.71           C  
ATOM    552  NH1 ARG A  70       9.150  97.193 -21.097  1.00 33.61           N  
ATOM    553  NH2 ARG A  70       9.095  95.771 -19.302  1.00 34.35           N  
ATOM    554  N   VAL A  71      12.938 101.749 -16.917  1.00 31.07           N  
ATOM    555  CA  VAL A  71      13.173 102.053 -15.513  1.00 33.03           C  
ATOM    556  C   VAL A  71      11.806 102.200 -14.856  1.00 36.40           C  
ATOM    557  O   VAL A  71      11.165 103.244 -14.966  1.00 37.75           O  
ATOM    558  CB  VAL A  71      13.981 103.366 -15.367  1.00 30.24           C  
ATOM    559  CG1 VAL A  71      14.149 103.731 -13.897  1.00 28.89           C  
ATOM    560  CG2 VAL A  71      15.339 103.197 -16.023  1.00 28.14           C  
HETATM  561  N   MSE A  72      11.363 101.138 -14.187  1.00 40.14           N  
HETATM  562  CA  MSE A  72      10.062 101.116 -13.527  1.00 43.48           C  
HETATM  563  C   MSE A  72      10.092 101.364 -12.030  1.00 42.41           C  
HETATM  564  O   MSE A  72       9.061 101.661 -11.429  1.00 43.53           O  
HETATM  565  CB  MSE A  72       9.371  99.786 -13.788  1.00 49.76           C  
HETATM  566  CG  MSE A  72       8.248  99.873 -14.787  1.00 57.55           C  
HETATM  567 SE   MSE A  72       8.355  98.437 -16.038  1.00 68.19          SE  
HETATM  568  CE  MSE A  72       8.110  96.983 -14.785  1.00 64.79           C  
ATOM    569  N   SER A  73      11.260 101.220 -11.418  1.00 40.03           N  
ATOM    570  CA  SER A  73      11.372 101.464  -9.989  1.00 39.72           C  
ATOM    571  C   SER A  73      12.462 102.495  -9.765  1.00 37.42           C  
ATOM    572  O   SER A  73      13.561 102.380 -10.308  1.00 34.69           O  
ATOM    573  CB  SER A  73      11.711 100.174  -9.235  1.00 40.86           C  
ATOM    574  OG  SER A  73      12.986  99.682  -9.601  1.00 43.35           O  
ATOM    575  N   ILE A  74      12.138 103.522  -8.993  1.00 34.54           N  
ATOM    576  CA  ILE A  74      13.107 104.556  -8.689  1.00 33.39           C  
ATOM    577  C   ILE A  74      13.341 104.569  -7.182  1.00 32.33           C  
ATOM    578  O   ILE A  74      12.488 104.133  -6.411  1.00 32.51           O  
ATOM    579  CB  ILE A  74      12.633 105.947  -9.165  1.00 34.29           C  
ATOM    580  CG1 ILE A  74      11.195 106.194  -8.713  1.00 34.91           C  
ATOM    581  CG2 ILE A  74      12.751 106.044 -10.691  1.00 34.54           C  
ATOM    582  CD1 ILE A  74      10.661 107.541  -9.117  1.00 34.13           C  
ATOM    583  N   PRO A  75      14.518 105.037  -6.753  1.00 28.96           N  
ATOM    584  CA  PRO A  75      15.551 105.519  -7.670  1.00 27.66           C  
ATOM    585  C   PRO A  75      16.304 104.383  -8.360  1.00 26.40           C  
ATOM    586  O   PRO A  75      16.393 103.268  -7.842  1.00 26.44           O  
ATOM    587  CB  PRO A  75      16.456 106.339  -6.756  1.00 28.71           C  
ATOM    588  CG  PRO A  75      16.405 105.556  -5.486  1.00 28.88           C  
ATOM    589  CD  PRO A  75      14.935 105.223  -5.350  1.00 29.44           C  
ATOM    590  N   THR A  76      16.807 104.671  -9.553  1.00 23.53           N  
ATOM    591  CA  THR A  76      17.598 103.721 -10.320  1.00 21.60           C  
ATOM    592  C   THR A  76      18.727 104.551 -10.878  1.00 19.59           C  
ATOM    593  O   THR A  76      18.494 105.622 -11.442  1.00 21.17           O  
ATOM    594  CB  THR A  76      16.835 103.104 -11.522  1.00 21.43           C  
ATOM    595  OG1 THR A  76      15.860 102.168 -11.047  1.00 24.66           O  
ATOM    596  CG2 THR A  76      17.825 102.365 -12.456  1.00 19.04           C  
ATOM    597  N   VAL A  77      19.949 104.069 -10.708  1.00 18.18           N  
ATOM    598  CA  VAL A  77      21.117 104.777 -11.210  1.00 16.76           C  
ATOM    599  C   VAL A  77      21.809 103.885 -12.244  1.00 17.69           C  
ATOM    600  O   VAL A  77      22.053 102.704 -11.985  1.00 19.27           O  
ATOM    601  CB  VAL A  77      22.104 105.098 -10.057  1.00 18.18           C  
ATOM    602  CG1 VAL A  77      23.384 105.673 -10.611  1.00 23.19           C  
ATOM    603  CG2 VAL A  77      21.476 106.097  -9.089  1.00 20.76           C  
ATOM    604  N   ILE A  78      22.100 104.431 -13.422  1.00 15.42           N  
ATOM    605  CA  ILE A  78      22.781 103.648 -14.453  1.00 15.18           C  
ATOM    606  C   ILE A  78      24.088 104.334 -14.834  1.00 15.51           C  
ATOM    607  O   ILE A  78      24.122 105.536 -15.096  1.00 16.44           O  
ATOM    608  CB  ILE A  78      21.914 103.471 -15.734  1.00 16.62           C  
ATOM    609  CG1 ILE A  78      20.600 102.755 -15.386  1.00 15.24           C  
ATOM    610  CG2 ILE A  78      22.690 102.650 -16.787  1.00 12.90           C  
ATOM    611  CD1 ILE A  78      19.617 102.656 -16.564  1.00 18.93           C  
ATOM    612  N   LEU A  79      25.169 103.566 -14.832  1.00 14.77           N  
ATOM    613  CA  LEU A  79      26.477 104.095 -15.196  1.00 17.89           C  
ATOM    614  C   LEU A  79      26.734 103.774 -16.665  1.00 17.51           C  
ATOM    615  O   LEU A  79      26.537 102.645 -17.102  1.00 19.56           O  
ATOM    616  CB  LEU A  79      27.570 103.464 -14.320  1.00 19.21           C  
ATOM    617  CG  LEU A  79      29.014 103.890 -14.599  1.00 20.09           C  
ATOM    618  CD1 LEU A  79      29.210 105.380 -14.272  1.00 19.91           C  
ATOM    619  CD2 LEU A  79      29.946 103.034 -13.770  1.00 18.98           C  
ATOM    620  N   PHE A  80      27.163 104.785 -17.415  1.00 17.39           N  
ATOM    621  CA  PHE A  80      27.458 104.666 -18.837  1.00 17.39           C  
ATOM    622  C   PHE A  80      28.940 104.942 -19.062  1.00 19.87           C  
ATOM    623  O   PHE A  80      29.476 105.911 -18.529  1.00 20.48           O  
ATOM    624  CB  PHE A  80      26.650 105.695 -19.633  1.00 15.33           C  
ATOM    625  CG  PHE A  80      25.171 105.449 -19.628  1.00 18.41           C  
ATOM    626  CD1 PHE A  80      24.561 104.785 -20.685  1.00 17.80           C  
ATOM    627  CD2 PHE A  80      24.382 105.898 -18.577  1.00 17.45           C  
ATOM    628  CE1 PHE A  80      23.175 104.575 -20.694  1.00 17.72           C  
ATOM    629  CE2 PHE A  80      23.010 105.692 -18.578  1.00 19.48           C  
ATOM    630  CZ  PHE A  80      22.406 105.027 -19.644  1.00 18.88           C  
ATOM    631  N   LYS A  81      29.587 104.093 -19.854  1.00 21.91           N  
ATOM    632  CA  LYS A  81      31.003 104.246 -20.177  1.00 24.17           C  
ATOM    633  C   LYS A  81      31.074 104.342 -21.696  1.00 24.28           C  
ATOM    634  O   LYS A  81      30.584 103.462 -22.397  1.00 24.90           O  
ATOM    635  CB  LYS A  81      31.806 103.033 -19.693  1.00 25.76           C  
ATOM    636  CG  LYS A  81      33.315 103.194 -19.853  1.00 29.35           C  
ATOM    637  CD  LYS A  81      34.079 102.027 -19.236  1.00 35.29           C  
ATOM    638  CE  LYS A  81      35.587 102.253 -19.311  1.00 37.19           C  
ATOM    639  NZ  LYS A  81      36.355 101.173 -18.629  1.00 40.20           N  
ATOM    640  N   ASP A  82      31.667 105.416 -22.206  1.00 26.79           N  
ATOM    641  CA  ASP A  82      31.750 105.605 -23.653  1.00 29.63           C  
ATOM    642  C   ASP A  82      30.350 105.528 -24.272  1.00 29.53           C  
ATOM    643  O   ASP A  82      30.165 104.964 -25.352  1.00 30.33           O  
ATOM    644  CB  ASP A  82      32.647 104.541 -24.295  1.00 33.64           C  
ATOM    645  CG  ASP A  82      34.052 104.538 -23.728  1.00 38.68           C  
ATOM    646  OD1 ASP A  82      34.614 105.636 -23.513  1.00 41.92           O  
ATOM    647  OD2 ASP A  82      34.599 103.434 -23.509  1.00 42.43           O  
ATOM    648  N   GLY A  83      29.366 106.081 -23.565  1.00 27.89           N  
ATOM    649  CA  GLY A  83      28.000 106.103 -24.057  1.00 25.50           C  
ATOM    650  C   GLY A  83      27.161 104.849 -23.903  1.00 25.14           C  
ATOM    651  O   GLY A  83      25.974 104.869 -24.225  1.00 24.31           O  
ATOM    652  N   GLN A  84      27.751 103.762 -23.416  1.00 23.91           N  
ATOM    653  CA  GLN A  84      27.011 102.514 -23.252  1.00 23.79           C  
ATOM    654  C   GLN A  84      26.836 102.138 -21.776  1.00 21.59           C  
ATOM    655  O   GLN A  84      27.740 102.328 -20.968  1.00 23.39           O  
ATOM    656  CB  GLN A  84      27.725 101.385 -24.015  1.00 26.92           C  
ATOM    657  CG  GLN A  84      27.110 100.007 -23.797  1.00 33.08           C  
ATOM    658  CD  GLN A  84      27.634  98.947 -24.759  1.00 34.95           C  
ATOM    659  OE1 GLN A  84      27.514  97.749 -24.495  1.00 37.51           O  
ATOM    660  NE2 GLN A  84      28.199  99.383 -25.885  1.00 35.12           N  
ATOM    661  N   PRO A  85      25.656 101.610 -21.404  1.00 22.30           N  
ATOM    662  CA  PRO A  85      25.415 101.228 -20.007  1.00 21.23           C  
ATOM    663  C   PRO A  85      26.305 100.073 -19.555  1.00 22.07           C  
ATOM    664  O   PRO A  85      26.454  99.082 -20.273  1.00 21.58           O  
ATOM    665  CB  PRO A  85      23.930 100.863 -19.996  1.00 22.53           C  
ATOM    666  CG  PRO A  85      23.705 100.346 -21.408  1.00 24.39           C  
ATOM    667  CD  PRO A  85      24.471 101.342 -22.242  1.00 21.74           C  
ATOM    668  N   VAL A  86      26.898 100.207 -18.371  1.00 19.54           N  
ATOM    669  CA  VAL A  86      27.767  99.162 -17.852  1.00 22.03           C  
ATOM    670  C   VAL A  86      27.423  98.675 -16.439  1.00 22.20           C  
ATOM    671  O   VAL A  86      27.790  97.567 -16.064  1.00 22.19           O  
ATOM    672  CB  VAL A  86      29.246  99.604 -17.914  1.00 23.31           C  
ATOM    673  CG1 VAL A  86      29.701  99.630 -19.367  1.00 22.40           C  
ATOM    674  CG2 VAL A  86      29.422 100.989 -17.293  1.00 22.13           C  
ATOM    675  N   GLU A  87      26.707  99.492 -15.666  1.00 20.94           N  
ATOM    676  CA  GLU A  87      26.318  99.120 -14.305  1.00 20.94           C  
ATOM    677  C   GLU A  87      24.965  99.746 -13.949  1.00 20.67           C  
ATOM    678  O   GLU A  87      24.600 100.806 -14.469  1.00 19.43           O  
ATOM    679  CB  GLU A  87      27.366  99.596 -13.287  1.00 21.74           C  
ATOM    680  CG  GLU A  87      28.808  99.135 -13.522  1.00 25.90           C  
ATOM    681  CD  GLU A  87      29.021  97.635 -13.331  1.00 29.89           C  
ATOM    682  OE1 GLU A  87      28.203  96.981 -12.647  1.00 29.06           O  
ATOM    683  OE2 GLU A  87      30.029  97.115 -13.857  1.00 30.46           O  
ATOM    684  N   VAL A  88      24.220  99.082 -13.072  1.00 18.35           N  
ATOM    685  CA  VAL A  88      22.919  99.582 -12.640  1.00 19.18           C  
ATOM    686  C   VAL A  88      22.791  99.399 -11.132  1.00 18.68           C  
ATOM    687  O   VAL A  88      23.171  98.360 -10.589  1.00 19.45           O  
ATOM    688  CB  VAL A  88      21.744  98.817 -13.319  1.00 19.58           C  
ATOM    689  CG1 VAL A  88      20.405  99.354 -12.825  1.00 21.08           C  
ATOM    690  CG2 VAL A  88      21.827  98.966 -14.828  1.00 22.14           C  
ATOM    691  N   LEU A  89      22.288 100.416 -10.448  1.00 16.03           N  
ATOM    692  CA  LEU A  89      22.081 100.291  -9.009  1.00 17.01           C  
ATOM    693  C   LEU A  89      20.643 100.688  -8.749  1.00 17.53           C  
ATOM    694  O   LEU A  89      20.248 101.834  -9.001  1.00 16.86           O  
ATOM    695  CB  LEU A  89      23.032 101.193  -8.217  1.00 19.25           C  
ATOM    696  CG  LEU A  89      24.520 100.849  -8.325  1.00 22.10           C  
ATOM    697  CD1 LEU A  89      25.129 101.617  -9.498  1.00 23.86           C  
ATOM    698  CD2 LEU A  89      25.227 101.218  -7.024  1.00 24.87           C  
ATOM    699  N   VAL A  90      19.858  99.733  -8.262  1.00 13.95           N  
ATOM    700  CA  VAL A  90      18.451  99.967  -7.981  1.00 18.53           C  
ATOM    701  C   VAL A  90      18.213 100.238  -6.504  1.00 21.51           C  
ATOM    702  O   VAL A  90      18.668  99.485  -5.642  1.00 21.47           O  
ATOM    703  CB  VAL A  90      17.593  98.753  -8.420  1.00 19.80           C  
ATOM    704  CG1 VAL A  90      16.145  98.956  -8.014  1.00 23.95           C  
ATOM    705  CG2 VAL A  90      17.686  98.577  -9.931  1.00 21.74           C  
ATOM    706  N   GLY A  91      17.504 101.327  -6.220  1.00 22.53           N  
ATOM    707  CA  GLY A  91      17.188 101.668  -4.844  1.00 24.42           C  
ATOM    708  C   GLY A  91      18.191 102.566  -4.151  1.00 24.81           C  
ATOM    709  O   GLY A  91      19.334 102.693  -4.595  1.00 24.37           O  
ATOM    710  N   ALA A  92      17.757 103.197  -3.061  1.00 24.14           N  
ATOM    711  CA  ALA A  92      18.624 104.079  -2.287  1.00 24.29           C  
ATOM    712  C   ALA A  92      19.666 103.209  -1.603  1.00 27.16           C  
ATOM    713  O   ALA A  92      19.321 102.244  -0.919  1.00 27.70           O  
ATOM    714  CB  ALA A  92      17.810 104.839  -1.244  1.00 24.08           C  
ATOM    715  N   GLN A  93      20.935 103.554  -1.778  1.00 26.72           N  
ATOM    716  CA  GLN A  93      22.016 102.768  -1.197  1.00 29.07           C  
ATOM    717  C   GLN A  93      23.143 103.625  -0.650  1.00 26.48           C  
ATOM    718  O   GLN A  93      23.272 104.793  -1.004  1.00 26.02           O  
ATOM    719  CB  GLN A  93      22.615 101.848  -2.255  1.00 29.89           C  
ATOM    720  CG  GLN A  93      21.697 100.777  -2.775  1.00 36.27           C  
ATOM    721  CD  GLN A  93      22.337 100.020  -3.908  1.00 33.93           C  
ATOM    722  OE1 GLN A  93      23.503  99.643  -3.827  1.00 33.28           O  
ATOM    723  NE2 GLN A  93      21.579  99.788  -4.975  1.00 36.74           N  
ATOM    724  N   PRO A  94      23.978 103.042   0.225  1.00 26.54           N  
ATOM    725  CA  PRO A  94      25.114 103.759   0.815  1.00 24.58           C  
ATOM    726  C   PRO A  94      26.082 104.180  -0.288  1.00 24.30           C  
ATOM    727  O   PRO A  94      26.209 103.498  -1.313  1.00 18.97           O  
ATOM    728  CB  PRO A  94      25.725 102.719   1.751  1.00 25.77           C  
ATOM    729  CG  PRO A  94      24.522 101.972   2.223  1.00 28.40           C  
ATOM    730  CD  PRO A  94      23.738 101.775   0.937  1.00 25.76           C  
ATOM    731  N   LYS A  95      26.772 105.296  -0.070  1.00 22.58           N  
ATOM    732  CA  LYS A  95      27.707 105.818  -1.060  1.00 22.84           C  
ATOM    733  C   LYS A  95      28.766 104.816  -1.520  1.00 23.30           C  
ATOM    734  O   LYS A  95      29.188 104.844  -2.681  1.00 22.94           O  
ATOM    735  CB  LYS A  95      28.398 107.081  -0.527  1.00 24.62           C  
ATOM    736  CG  LYS A  95      29.319 107.738  -1.556  1.00 29.13           C  
ATOM    737  CD  LYS A  95      29.892 109.061  -1.070  1.00 33.98           C  
ATOM    738  CE  LYS A  95      30.858 108.885   0.086  1.00 33.74           C  
ATOM    739  NZ  LYS A  95      31.342 110.217   0.564  1.00 37.07           N  
ATOM    740  N   ARG A  96      29.195 103.931  -0.623  1.00 20.59           N  
ATOM    741  CA  ARG A  96      30.216 102.954  -0.973  1.00 22.85           C  
ATOM    742  C   ARG A  96      29.816 102.029  -2.118  1.00 21.65           C  
ATOM    743  O   ARG A  96      30.677 101.544  -2.848  1.00 19.03           O  
ATOM    744  CB  ARG A  96      30.609 102.114   0.252  1.00 24.75           C  
ATOM    745  CG  ARG A  96      29.468 101.331   0.892  1.00 27.31           C  
ATOM    746  CD  ARG A  96      30.028 100.216   1.764  1.00 31.15           C  
ATOM    747  NE  ARG A  96      28.985  99.411   2.395  1.00 35.05           N  
ATOM    748  CZ  ARG A  96      28.198  99.844   3.371  1.00 35.33           C  
ATOM    749  NH1 ARG A  96      28.334 101.082   3.832  1.00 38.81           N  
ATOM    750  NH2 ARG A  96      27.281  99.040   3.895  1.00 36.01           N  
ATOM    751  N   ASN A  97      28.517 101.775  -2.272  1.00 21.35           N  
ATOM    752  CA  ASN A  97      28.046 100.906  -3.354  1.00 22.09           C  
ATOM    753  C   ASN A  97      28.264 101.557  -4.718  1.00 21.72           C  
ATOM    754  O   ASN A  97      28.647 100.888  -5.689  1.00 19.44           O  
ATOM    755  CB  ASN A  97      26.563 100.571  -3.159  1.00 23.79           C  
ATOM    756  CG  ASN A  97      26.336  99.652  -1.974  1.00 26.96           C  
ATOM    757  OD1 ASN A  97      27.292  99.155  -1.375  1.00 29.99           O  
ATOM    758  ND2 ASN A  97      25.080  99.416  -1.634  1.00 29.03           N  
ATOM    759  N   TYR A  98      28.021 102.861  -4.784  1.00 20.35           N  
ATOM    760  CA  TYR A  98      28.212 103.628  -6.014  1.00 20.08           C  
ATOM    761  C   TYR A  98      29.708 103.727  -6.302  1.00 20.81           C  
ATOM    762  O   TYR A  98      30.152 103.529  -7.439  1.00 21.79           O  
ATOM    763  CB  TYR A  98      27.625 105.031  -5.851  1.00 18.37           C  
ATOM    764  CG  TYR A  98      26.133 105.042  -5.636  1.00 20.63           C  
ATOM    765  CD1 TYR A  98      25.255 104.826  -6.698  1.00 21.51           C  
ATOM    766  CD2 TYR A  98      25.593 105.239  -4.363  1.00 21.69           C  
ATOM    767  CE1 TYR A  98      23.876 104.803  -6.500  1.00 22.54           C  
ATOM    768  CE2 TYR A  98      24.214 105.216  -4.154  1.00 22.37           C  
ATOM    769  CZ  TYR A  98      23.363 104.996  -5.220  1.00 23.72           C  
ATOM    770  OH  TYR A  98      22.000 104.942  -5.010  1.00 24.19           O  
ATOM    771  N   GLN A  99      30.487 104.034  -5.270  1.00 21.87           N  
ATOM    772  CA  GLN A  99      31.938 104.139  -5.423  1.00 23.34           C  
ATOM    773  C   GLN A  99      32.524 102.881  -6.051  1.00 23.92           C  
ATOM    774  O   GLN A  99      33.348 102.960  -6.959  1.00 25.33           O  
ATOM    775  CB  GLN A  99      32.606 104.373  -4.067  1.00 26.00           C  
ATOM    776  CG  GLN A  99      32.211 105.667  -3.398  1.00 25.72           C  
ATOM    777  CD  GLN A  99      32.864 105.832  -2.048  1.00 30.91           C  
ATOM    778  OE1 GLN A  99      32.790 104.943  -1.197  1.00 34.22           O  
ATOM    779  NE2 GLN A  99      33.510 106.974  -1.839  1.00 31.12           N  
ATOM    780  N   ALA A 100      32.094 101.725  -5.556  1.00 25.75           N  
ATOM    781  CA  ALA A 100      32.573 100.439  -6.046  1.00 26.92           C  
ATOM    782  C   ALA A 100      32.291 100.216  -7.530  1.00 28.25           C  
ATOM    783  O   ALA A 100      33.150  99.727  -8.270  1.00 26.32           O  
ATOM    784  CB  ALA A 100      31.952  99.306  -5.225  1.00 27.17           C  
ATOM    785  N   LYS A 101      31.091 100.564  -7.976  1.00 27.47           N  
ATOM    786  CA  LYS A 101      30.762 100.365  -9.381  1.00 28.44           C  
ATOM    787  C   LYS A 101      31.391 101.421 -10.289  1.00 27.25           C  
ATOM    788  O   LYS A 101      31.645 101.164 -11.467  1.00 29.83           O  
ATOM    789  CB  LYS A 101      29.240 100.279  -9.558  1.00 28.88           C  
ATOM    790  CG  LYS A 101      28.703  98.964  -9.003  1.00 30.68           C  
ATOM    791  CD  LYS A 101      27.237  98.723  -9.295  1.00 33.64           C  
ATOM    792  CE  LYS A 101      26.828  97.334  -8.811  1.00 35.85           C  
ATOM    793  NZ  LYS A 101      25.377  97.050  -9.024  1.00 38.03           N  
ATOM    794  N   ILE A 102      31.678 102.592  -9.732  1.00 27.64           N  
ATOM    795  CA  ILE A 102      32.316 103.664 -10.490  1.00 30.37           C  
ATOM    796  C   ILE A 102      33.793 103.334 -10.702  1.00 33.84           C  
ATOM    797  O   ILE A 102      34.306 103.398 -11.822  1.00 35.18           O  
ATOM    798  CB  ILE A 102      32.237 105.015  -9.742  1.00 30.38           C  
ATOM    799  CG1 ILE A 102      30.792 105.508  -9.697  1.00 29.05           C  
ATOM    800  CG2 ILE A 102      33.134 106.042 -10.422  1.00 33.85           C  
ATOM    801  CD1 ILE A 102      30.605 106.771  -8.879  1.00 26.99           C  
ATOM    802  N   GLU A 103      34.469 102.979  -9.612  1.00 34.01           N  
ATOM    803  CA  GLU A 103      35.891 102.654  -9.651  1.00 36.29           C  
ATOM    804  C   GLU A 103      36.184 101.371 -10.423  1.00 36.94           C  
ATOM    805  O   GLU A 103      37.319 101.102 -10.810  1.00 37.24           O  
ATOM    806  CB  GLU A 103      36.427 102.560  -8.222  1.00 38.71           C  
ATOM    807  CG  GLU A 103      36.555 103.922  -7.546  1.00 42.61           C  
ATOM    808  CD  GLU A 103      36.971 103.827  -6.090  1.00 44.99           C  
ATOM    809  OE1 GLU A 103      37.804 102.955  -5.764  1.00 48.22           O  
ATOM    810  OE2 GLU A 103      36.476 104.633  -5.273  1.00 45.29           O  
ATOM    811  N   LYS A 104      35.143 100.588 -10.652  1.00 36.75           N  
ATOM    812  CA  LYS A 104      35.259  99.339 -11.386  1.00 38.01           C  
ATOM    813  C   LYS A 104      35.551  99.661 -12.854  1.00 37.34           C  
ATOM    814  O   LYS A 104      36.148  98.862 -13.576  1.00 38.34           O  
ATOM    815  CB  LYS A 104      33.937  98.584 -11.265  1.00 39.88           C  
ATOM    816  CG  LYS A 104      33.975  97.111 -11.577  1.00 42.38           C  
ATOM    817  CD  LYS A 104      32.655  96.490 -11.149  1.00 42.09           C  
ATOM    818  CE  LYS A 104      32.693  94.975 -11.197  1.00 43.91           C  
ATOM    819  NZ  LYS A 104      31.485  94.391 -10.543  1.00 42.30           N  
ATOM    820  N   HIS A 105      35.143 100.852 -13.278  1.00 35.08           N  
ATOM    821  CA  HIS A 105      35.326 101.282 -14.658  1.00 34.68           C  
ATOM    822  C   HIS A 105      36.308 102.426 -14.857  1.00 34.86           C  
ATOM    823  O   HIS A 105      36.457 102.934 -15.967  1.00 34.76           O  
ATOM    824  CB  HIS A 105      33.962 101.639 -15.249  1.00 30.07           C  
ATOM    825  CG  HIS A 105      33.028 100.473 -15.305  1.00 26.98           C  
ATOM    826  ND1 HIS A 105      33.099  99.514 -16.292  1.00 25.03           N  
ATOM    827  CD2 HIS A 105      32.064 100.062 -14.449  1.00 22.80           C  
ATOM    828  CE1 HIS A 105      32.221  98.559 -16.040  1.00 23.96           C  
ATOM    829  NE2 HIS A 105      31.579  98.868 -14.927  1.00 25.17           N  
ATOM    830  N   LEU A 106      36.977 102.830 -13.782  1.00 36.87           N  
ATOM    831  CA  LEU A 106      37.966 103.894 -13.860  1.00 40.15           C  
ATOM    832  C   LEU A 106      39.354 103.286 -14.058  1.00 44.35           C  
ATOM    833  O   LEU A 106      39.703 102.293 -13.416  1.00 43.90           O  
ATOM    834  CB  LEU A 106      37.954 104.742 -12.587  1.00 39.40           C  
ATOM    835  CG  LEU A 106      36.851 105.796 -12.474  1.00 37.89           C  
ATOM    836  CD1 LEU A 106      37.017 106.572 -11.185  1.00 37.45           C  
ATOM    837  CD2 LEU A 106      36.924 106.739 -13.664  1.00 37.10           C  
ATOM    838  N   PRO A 107      40.166 103.884 -14.948  1.00 47.51           N  
ATOM    839  CA  PRO A 107      41.527 103.430 -15.258  1.00 50.02           C  
ATOM    840  C   PRO A 107      42.296 102.941 -14.032  1.00 51.13           C  
ATOM    841  O   PRO A 107      42.809 101.801 -14.071  1.00 52.34           O  
ATOM    842  CB  PRO A 107      42.159 104.666 -15.887  1.00 50.81           C  
ATOM    843  CG  PRO A 107      41.008 105.257 -16.638  1.00 51.11           C  
ATOM    844  CD  PRO A 107      39.878 105.160 -15.630  1.00 49.24           C  
TER     845      PRO A 107                                                      
END
MOLECULE T0458.pdb
ATOM   1307  N   THR    12      35.233 112.701 -19.135  1.00 39.16           N  
ATOM   1308  CA  THR    12      35.143 111.676 -20.213  1.00 38.90           C  
ATOM   1309  C   THR    12      34.112 110.567 -19.899  1.00 40.96           C  
ATOM   1310  O   THR    12      33.648 109.876 -20.805  1.00 39.76           O  
ATOM   1311  CB  THR    12      36.539 111.055 -20.467  1.00 36.99           C  
ATOM   1312  OG1 THR    12      36.541 110.386 -21.728  1.00 33.73           O  
ATOM   1313  CG2 THR    12      36.902 110.062 -19.365  1.00 36.11           C  
ATOM   1314  N   HIS    13      33.754 110.409 -18.620  1.00 42.95           N  
ATOM   1315  CA  HIS    13      32.768 109.405 -18.186  1.00 42.37           C  
ATOM   1316  C   HIS    13      31.481 110.051 -17.638  1.00 39.31           C  
ATOM   1317  O   HIS    13      31.550 110.916 -16.776  1.00 39.49           O  
ATOM   1318  CB  HIS    13      33.360 108.504 -17.091  1.00 45.88           C  
ATOM   1319  CG  HIS    13      34.163 107.348 -17.608  1.00 45.03           C  
ATOM   1320  ND1 HIS    13      35.476 107.468 -18.010  1.00 45.10           N  
ATOM   1321  CD2 HIS    13      33.840 106.042 -17.763  1.00 38.68           C  
ATOM   1322  CE1 HIS    13      35.928 106.286 -18.388  1.00 40.14           C  
ATOM   1323  NE2 HIS    13      34.955 105.405 -18.249  1.00 41.81           N  
ATOM   1324  N   ARG    14      30.321 109.602 -18.117  1.00 35.30           N  
ATOM   1325  CA  ARG    14      29.012 110.124 -17.694  1.00 33.07           C  
ATOM   1326  C   ARG    14      28.270 109.275 -16.638  1.00 32.17           C  
ATOM   1327  O   ARG    14      28.250 108.043 -16.729  1.00 34.66           O  
ATOM   1328  CB  ARG    14      28.077 110.231 -18.901  1.00 30.55           C  
ATOM   1329  CG  ARG    14      28.092 111.531 -19.645  1.00 41.12           C  
ATOM   1330  CD  ARG    14      26.788 111.725 -20.417  1.00 52.11           C  
ATOM   1331  NE  ARG    14      25.605 111.441 -19.583  1.00 63.25           N  
ATOM   1332  CZ  ARG    14      24.380 111.936 -19.790  1.00 63.42           C  
ATOM   1333  NH1 ARG    14      23.379 111.608 -18.979  1.00 59.81           N  
ATOM   1334  NH2 ARG    14      24.157 112.777 -20.794  1.00 64.54           N  
ATOM   1335  N   VAL    15      27.635 109.920 -15.659  1.00 26.43           N  
ATOM   1336  CA  VAL    15      26.857 109.184 -14.657  1.00 20.22           C  
ATOM   1337  C   VAL    15      25.458 109.762 -14.622  1.00 18.68           C  
ATOM   1338  O   VAL    15      25.276 110.951 -14.811  1.00 24.00           O  
ATOM   1339  CB  VAL    15      27.464 109.273 -13.230  1.00 22.11           C  
ATOM   1340  CG1 VAL    15      26.500 108.673 -12.212  1.00 18.60           C  
ATOM   1341  CG2 VAL    15      28.785 108.521 -13.180  1.00 21.25           C  
ATOM   1342  N   GLN    16      24.465 108.925 -14.388  1.00 18.92           N  
ATOM   1343  CA  GLN    16      23.099 109.404 -14.339  1.00 20.61           C  
ATOM   1344  C   GLN    16      22.377 108.740 -13.172  1.00 20.40           C  
ATOM   1345  O   GLN    16      22.593 107.562 -12.890  1.00 22.85           O  
ATOM   1346  CB  GLN    16      22.400 109.073 -15.655  1.00 23.81           C  
ATOM   1347  CG  GLN    16      20.923 109.356 -15.665  1.00 30.32           C  
ATOM   1348  CD  GLN    16      20.263 108.887 -16.947  1.00 37.44           C  
ATOM   1349  OE1 GLN    16      20.323 107.701 -17.302  1.00 39.95           O  
ATOM   1350  NE2 GLN    16      19.625 109.820 -17.654  1.00 42.41           N  
ATOM   1351  N   ILE    17      21.523 109.495 -12.492  1.00 20.42           N  
ATOM   1352  CA  ILE    17      20.762 108.969 -11.364  1.00 14.91           C  
ATOM   1353  C   ILE    17      19.307 109.239 -11.617  1.00 15.05           C  
ATOM   1354  O   ILE    17      18.911 110.388 -11.727  1.00 24.10           O  
ATOM   1355  CB  ILE    17      21.159 109.676 -10.065  1.00 14.15           C  
ATOM   1356  CG1 ILE    17      22.619 109.367  -9.757  1.00 17.41           C  
ATOM   1357  CG2 ILE    17      20.241 109.271  -8.928  1.00  6.52           C  
ATOM   1358  CD1 ILE    17      23.132 110.054  -8.534  1.00 18.66           C  
ATOM   1359  N   GLU    18      18.506 108.200 -11.739  1.00 12.00           N  
ATOM   1360  CA  GLU    18      17.079 108.398 -11.959  1.00 17.13           C  
ATOM   1361  C   GLU    18      16.341 108.070 -10.650  1.00 19.59           C  
ATOM   1362  O   GLU    18      16.342 106.921 -10.189  1.00 16.11           O  
ATOM   1363  CB  GLU    18      16.612 107.486 -13.089  1.00 22.94           C  
ATOM   1364  CG  GLU    18      15.173 107.698 -13.530  1.00 34.31           C  
ATOM   1365  CD  GLU    18      14.711 106.651 -14.538  1.00 42.81           C  
ATOM   1366  OE1 GLU    18      13.515 106.693 -14.946  1.00 55.33           O  
ATOM   1367  OE2 GLU    18      15.543 105.786 -14.918  1.00 42.86           O  
ATOM   1368  N   TYR    19      15.715 109.083 -10.060  1.00 20.98           N  
ATOM   1369  CA  TYR    19      14.996 108.948  -8.781  1.00 24.62           C  
ATOM   1370  C   TYR    19      13.485 109.146  -8.906  1.00 24.60           C  
ATOM   1371  O   TYR    19      13.041 109.996  -9.668  1.00 23.03           O  
ATOM   1372  CB  TYR    19      15.511 109.999  -7.799  1.00 23.04           C  
ATOM   1373  CG  TYR    19      15.279 111.412  -8.298  1.00 20.84           C  
ATOM   1374  CD1 TYR    19      16.006 111.919  -9.383  1.00 13.93           C  
ATOM   1375  CD2 TYR    19      14.280 112.206  -7.746  1.00 16.88           C  
ATOM   1376  CE1 TYR    19      15.732 113.175  -9.909  1.00 13.50           C  
ATOM   1377  CE2 TYR    19      13.997 113.466  -8.264  1.00 21.62           C  
ATOM   1378  CZ  TYR    19      14.722 113.946  -9.346  1.00 18.13           C  
ATOM   1379  OH  TYR    19      14.429 115.187  -9.864  1.00 14.85           O  
ATOM   1380  N   CYS    20      12.700 108.395  -8.137  1.00 27.92           N  
ATOM   1381  CA  CYS    20      11.250 108.540  -8.199  1.00 32.48           C  
ATOM   1382  C   CYS    20      10.873 109.894  -7.620  1.00 33.70           C  
ATOM   1383  O   CYS    20      11.123 110.189  -6.453  1.00 33.30           O  
ATOM   1384  CB  CYS    20      10.545 107.395  -7.441  1.00 39.40           C  
ATOM   1385  SG  CYS    20       8.812 107.705  -6.905  1.00 47.94           S  
ATOM   1386  N   THR    21      10.281 110.721  -8.466  1.00 36.58           N  
ATOM   1387  CA  THR    21       9.877 112.061  -8.087  1.00 39.46           C  
ATOM   1388  C   THR    21       8.732 112.041  -7.063  1.00 40.19           C  
ATOM   1389  O   THR    21       8.768 112.759  -6.064  1.00 39.98           O  
ATOM   1390  CB  THR    21       9.483 112.862  -9.360  1.00 39.20           C  
ATOM   1391  OG1 THR    21       9.033 114.168  -8.998  1.00 45.36           O  
ATOM   1392  CG2 THR    21       8.379 112.139 -10.119  1.00 44.44           C  
ATOM   1393  N   GLN    22       7.732 111.200  -7.296  1.00 41.06           N  
ATOM   1394  CA  GLN    22       6.587 111.110  -6.391  1.00 44.27           C  
ATOM   1395  C   GLN    22       6.982 110.661  -4.978  1.00 44.35           C  
ATOM   1396  O   GLN    22       6.388 111.081  -3.978  1.00 40.32           O  
ATOM   1397  CB  GLN    22       5.547 110.146  -6.968  1.00 49.73           C  
ATOM   1398  CG  GLN    22       5.202 110.406  -8.431  1.00 57.57           C  
ATOM   1399  CD  GLN    22       4.559 111.763  -8.654  1.00 63.63           C  
ATOM   1400  OE1 GLN    22       3.488 112.051  -8.111  1.00 68.32           O  
ATOM   1401  NE2 GLN    22       5.209 112.607  -9.460  1.00 65.91           N  
ATOM   1402  N   CYS    23       7.996 109.812  -4.901  1.00 43.84           N  
ATOM   1403  CA  CYS    23       8.474 109.301  -3.622  1.00 41.93           C  
ATOM   1404  C   CYS    23       9.292 110.351  -2.850  1.00 39.32           C  
ATOM   1405  O   CYS    23       9.830 110.054  -1.788  1.00 36.69           O  
ATOM   1406  CB  CYS    23       9.341 108.061  -3.859  1.00 41.55           C  
ATOM   1407  SG  CYS    23       8.704 106.833  -5.047  1.00 53.71           S  
ATOM   1408  N   ARG    24       9.384 111.568  -3.382  1.00 36.78           N  
ATOM   1409  CA  ARG    24      10.159 112.625  -2.730  1.00 37.41           C  
ATOM   1410  C   ARG    24      11.608 112.157  -2.517  1.00 36.10           C  
ATOM   1411  O   ARG    24      12.173 112.325  -1.433  1.00 35.46           O  
ATOM   1412  CB  ARG    24       9.543 112.996  -1.366  1.00 39.04           C  
ATOM   1413  CG  ARG    24       8.055 113.365  -1.394  1.00 48.84           C  
ATOM   1414  CD  ARG    24       7.771 114.873  -1.434  1.00 54.67           C  
ATOM   1415  NE  ARG    24       7.980 115.487  -2.751  1.00 62.77           N  
ATOM   1416  CZ  ARG    24       7.809 116.785  -3.010  1.00 66.70           C  
ATOM   1417  NH1 ARG    24       7.423 117.614  -2.042  1.00 68.58           N  
ATOM   1418  NH2 ARG    24       8.024 117.260  -4.235  1.00 63.77           N  
ATOM   1419  N   TRP    25      12.210 111.575  -3.550  1.00 30.49           N  
ATOM   1420  CA  TRP    25      13.576 111.081  -3.434  1.00 27.73           C  
ATOM   1421  C   TRP    25      14.638 111.992  -4.059  1.00 26.32           C  
ATOM   1422  O   TRP    25      15.796 111.592  -4.273  1.00 21.86           O  
ATOM   1423  CB  TRP    25      13.697 109.677  -4.032  1.00 24.28           C  
ATOM   1424  CG  TRP    25      13.115 108.585  -3.175  1.00 26.51           C  
ATOM   1425  CD1 TRP    25      12.754 108.672  -1.866  1.00 22.11           C  
ATOM   1426  CD2 TRP    25      12.862 107.226  -3.572  1.00 27.33           C  
ATOM   1427  NE1 TRP    25      12.293 107.453  -1.421  1.00 25.73           N  
ATOM   1428  CE2 TRP    25      12.346 106.551  -2.449  1.00 23.98           C  
ATOM   1429  CE3 TRP    25      13.026 106.518  -4.770  1.00 25.78           C  
ATOM   1430  CZ2 TRP    25      11.987 105.210  -2.485  1.00 25.25           C  
ATOM   1431  CZ3 TRP    25      12.672 105.179  -4.807  1.00 27.16           C  
ATOM   1432  CH2 TRP    25      12.156 104.539  -3.669  1.00 28.13           C  
ATOM   1433  N   LEU    26      14.242 113.223  -4.340  1.00 23.87           N  
ATOM   1434  CA  LEU    26      15.151 114.188  -4.917  1.00 24.08           C  
ATOM   1435  C   LEU    26      16.310 114.425  -3.957  1.00 24.23           C  
ATOM   1436  O   LEU    26      17.486 114.364  -4.336  1.00 24.06           O  
ATOM   1437  CB  LEU    26      14.431 115.512  -5.188  1.00 18.76           C  
ATOM   1438  CG  LEU    26      15.326 116.672  -5.637  1.00 15.92           C  
ATOM   1439  CD1 LEU    26      16.110 116.290  -6.882  1.00 15.11           C  
ATOM   1440  CD2 LEU    26      14.477 117.874  -5.902  1.00 18.44           C  
ATOM   1441  N   PRO    27      16.000 114.705  -2.691  1.00 25.42           N  
ATOM   1442  CA  PRO    27      17.095 114.936  -1.749  1.00 25.47           C  
ATOM   1443  C   PRO    27      18.144 113.820  -1.668  1.00 20.34           C  
ATOM   1444  O   PRO    27      19.333 114.107  -1.643  1.00 20.35           O  
ATOM   1445  CB  PRO    27      16.369 115.172  -0.420  1.00 22.29           C  
ATOM   1446  CG  PRO    27      15.083 114.437  -0.586  1.00 28.33           C  
ATOM   1447  CD  PRO    27      14.701 114.788  -2.008  1.00 27.68           C  
ATOM   1448  N   ARG    28      17.734 112.557  -1.640  1.00 20.83           N  
ATOM   1449  CA  ARG    28      18.731 111.490  -1.556  1.00 22.05           C  
ATOM   1450  C   ARG    28      19.484 111.317  -2.873  1.00 23.44           C  
ATOM   1451  O   ARG    28      20.633 110.855  -2.898  1.00 19.09           O  
ATOM   1452  CB  ARG    28      18.090 110.162  -1.140  1.00 22.56           C  
ATOM   1453  CG  ARG    28      17.134 109.566  -2.148  1.00 26.08           C  
ATOM   1454  CD  ARG    28      16.553 108.280  -1.589  1.00 27.46           C  
ATOM   1455  NE  ARG    28      15.820 108.536  -0.353  1.00 32.39           N  
ATOM   1456  CZ  ARG    28      15.228 107.600   0.383  1.00 31.09           C  
ATOM   1457  NH1 ARG    28      15.285 106.329   0.009  1.00 33.28           N  
ATOM   1458  NH2 ARG    28      14.570 107.936   1.488  1.00 26.89           N  
ATOM   1459  N   ALA    29      18.822 111.664  -3.974  1.00 23.48           N  
ATOM   1460  CA  ALA    29      19.446 111.595  -5.290  1.00 16.24           C  
ATOM   1461  C   ALA    29      20.522 112.673  -5.320  1.00 16.53           C  
ATOM   1462  O   ALA    29      21.648 112.430  -5.749  1.00 17.05           O  
ATOM   1463  CB  ALA    29      18.424 111.863  -6.352  1.00 11.90           C  
ATOM   1464  N   ALA    30      20.164 113.866  -4.840  1.00 15.58           N  
ATOM   1465  CA  ALA    30      21.089 114.990  -4.798  1.00 12.15           C  
ATOM   1466  C   ALA    30      22.292 114.672  -3.919  1.00 13.81           C  
ATOM   1467  O   ALA    30      23.417 115.024  -4.245  1.00 17.93           O  
ATOM   1468  CB  ALA    30      20.387 116.217  -4.291  1.00  7.14           C  
ATOM   1469  N   TRP    31      22.050 113.988  -2.810  1.00 14.83           N  
ATOM   1470  CA  TRP    31      23.113 113.629  -1.904  1.00 13.24           C  
ATOM   1471  C   TRP    31      24.094 112.688  -2.569  1.00 16.56           C  
ATOM   1472  O   TRP    31      25.307 112.883  -2.482  1.00 18.69           O  
ATOM   1473  CB  TRP    31      22.532 112.968  -0.671  1.00 14.12           C  
ATOM   1474  CG  TRP    31      23.522 112.170   0.067  1.00 15.03           C  
ATOM   1475  CD1 TRP    31      24.635 112.625   0.710  1.00 13.81           C  
ATOM   1476  CD2 TRP    31      23.549 110.754   0.169  1.00 15.91           C  
ATOM   1477  NE1 TRP    31      25.360 111.573   1.201  1.00 17.25           N  
ATOM   1478  CE2 TRP    31      24.716 110.411   0.883  1.00 17.90           C  
ATOM   1479  CE3 TRP    31      22.703 109.739  -0.279  1.00 18.37           C  
ATOM   1480  CZ2 TRP    31      25.064 109.090   1.157  1.00 24.19           C  
ATOM   1481  CZ3 TRP    31      23.043 108.431  -0.012  1.00 25.80           C  
ATOM   1482  CH2 TRP    31      24.219 108.112   0.701  1.00 26.58           C  
ATOM   1483  N   LEU    32      23.570 111.652  -3.218  1.00 21.85           N  
ATOM   1484  CA  LEU    32      24.410 110.665  -3.908  1.00 22.79           C  
ATOM   1485  C   LEU    32      25.228 111.350  -5.001  1.00 25.24           C  
ATOM   1486  O   LEU    32      26.412 111.029  -5.216  1.00 27.20           O  
ATOM   1487  CB  LEU    32      23.551 109.584  -4.553  1.00 22.61           C  
ATOM   1488  CG  LEU    32      24.006 108.123  -4.413  1.00 24.51           C  
ATOM   1489  CD1 LEU    32      23.323 107.306  -5.521  1.00 25.19           C  
ATOM   1490  CD2 LEU    32      25.502 108.009  -4.517  1.00 18.89           C  
ATOM   1491  N   ALA    33      24.593 112.295  -5.691  1.00 20.92           N  
ATOM   1492  CA  ALA    33      25.267 113.028  -6.752  1.00 18.99           C  
ATOM   1493  C   ALA    33      26.503 113.726  -6.198  1.00 19.03           C  
ATOM   1494  O   ALA    33      27.575 113.721  -6.808  1.00 19.88           O  
ATOM   1495  CB  ALA    33      24.319 114.046  -7.354  1.00 20.93           C  
ATOM   1496  N   GLN    34      26.339 114.333  -5.034  1.00 15.61           N  
ATOM   1497  CA  GLN    34      27.427 115.030  -4.391  1.00 20.42           C  
ATOM   1498  C   GLN    34      28.514 114.044  -3.967  1.00 25.20           C  
ATOM   1499  O   GLN    34      29.701 114.323  -4.130  1.00 28.30           O  
ATOM   1500  CB  GLN    34      26.902 115.770  -3.183  1.00 20.00           C  
ATOM   1501  CG  GLN    34      27.732 116.943  -2.810  1.00 23.76           C  
ATOM   1502  CD  GLN    34      27.113 117.695  -1.689  1.00 25.03           C  
ATOM   1503  OE1 GLN    34      25.914 117.965  -1.712  1.00 27.84           O  
ATOM   1504  NE2 GLN    34      27.915 118.043  -0.686  1.00 25.01           N  
ATOM   1505  N   GLU    35      28.110 112.897  -3.418  1.00 26.05           N  
ATOM   1506  CA  GLU    35      29.062 111.870  -3.000  1.00 26.79           C  
ATOM   1507  C   GLU    35      29.880 111.409  -4.199  1.00 25.76           C  
ATOM   1508  O   GLU    35      31.100 111.373  -4.133  1.00 29.58           O  
ATOM   1509  CB  GLU    35      28.334 110.656  -2.403  1.00 29.07           C  
ATOM   1510  CG  GLU    35      27.663 110.859  -1.026  1.00 36.40           C  
ATOM   1511  CD  GLU    35      28.639 110.840   0.162  1.00 37.35           C  
ATOM   1512  OE1 GLU    35      29.592 110.019   0.147  1.00 43.71           O  
ATOM   1513  OE2 GLU    35      28.432 111.628   1.113  1.00 32.55           O  
ATOM   1514  N   LEU    36      29.208 111.060  -5.295  1.00 26.54           N  
ATOM   1515  CA  LEU    36      29.903 110.588  -6.490  1.00 26.53           C  
ATOM   1516  C   LEU    36      30.739 111.666  -7.179  1.00 28.82           C  
ATOM   1517  O   LEU    36      31.847 111.390  -7.651  1.00 31.06           O  
ATOM   1518  CB  LEU    36      28.903 110.000  -7.492  1.00 23.33           C  
ATOM   1519  CG  LEU    36      28.105 108.784  -7.009  1.00 21.17           C  
ATOM   1520  CD1 LEU    36      27.061 108.392  -8.037  1.00 17.04           C  
ATOM   1521  CD2 LEU    36      29.055 107.639  -6.741  1.00 15.12           C  
ATOM   1522  N   LEU    37      30.226 112.892  -7.233  1.00 28.20           N  
ATOM   1523  CA  LEU    37      30.951 113.965  -7.903  1.00 26.01           C  
ATOM   1524  C   LEU    37      32.174 114.388  -7.145  1.00 27.22           C  
ATOM   1525  O   LEU    37      33.140 114.872  -7.723  1.00 35.05           O  
ATOM   1526  CB  LEU    37      30.037 115.164  -8.129  1.00 22.95           C  
ATOM   1527  CG  LEU    37      29.266 115.054  -9.444  1.00 25.96           C  
ATOM   1528  CD1 LEU    37      28.166 116.104  -9.505  1.00 26.27           C  
ATOM   1529  CD2 LEU    37      30.239 115.215 -10.598  1.00 23.53           C  
ATOM   1530  N   THR    38      32.145 114.208  -5.839  1.00 30.01           N  
ATOM   1531  CA  THR    38      33.278 114.604  -5.031  1.00 29.62           C  
ATOM   1532  C   THR    38      34.364 113.523  -5.108  1.00 31.54           C  
ATOM   1533  O   THR    38      35.555 113.819  -5.059  1.00 32.59           O  
ATOM   1534  CB  THR    38      32.815 114.860  -3.582  1.00 28.57           C  
ATOM   1535  OG1 THR    38      33.935 115.191  -2.766  1.00 35.34           O  
ATOM   1536  CG2 THR    38      32.128 113.640  -3.015  1.00 33.85           C  
ATOM   1537  N   THR    39      33.956 112.269  -5.273  1.00 32.57           N  
ATOM   1538  CA  THR    39      34.921 111.183  -5.366  1.00 34.34           C  
ATOM   1539  C   THR    39      35.467 110.987  -6.789  1.00 36.96           C  
ATOM   1540  O   THR    39      36.640 110.662  -6.964  1.00 37.38           O  
ATOM   1541  CB  THR    39      34.297 109.864  -4.860  1.00 32.96           C  
ATOM   1542  OG1 THR    39      34.062 109.962  -3.448  1.00 33.25           O  
ATOM   1543  CG2 THR    39      35.223 108.689  -5.130  1.00 31.22           C  
ATOM   1544  N   PHE    40      34.629 111.219  -7.798  1.00 38.57           N  
ATOM   1545  CA  PHE    40      35.027 111.035  -9.193  1.00 37.31           C  
ATOM   1546  C   PHE    40      34.988 112.301 -10.047  1.00 41.01           C  
ATOM   1547  O   PHE    40      34.757 112.234 -11.260  1.00 41.00           O  
ATOM   1548  CB  PHE    40      34.125 109.981  -9.832  1.00 31.99           C  
ATOM   1549  CG  PHE    40      34.123 108.678  -9.107  1.00 28.82           C  
ATOM   1550  CD1 PHE    40      33.048 108.312  -8.313  1.00 30.11           C  
ATOM   1551  CD2 PHE    40      35.207 107.812  -9.218  1.00 29.42           C  
ATOM   1552  CE1 PHE    40      33.043 107.088  -7.632  1.00 31.64           C  
ATOM   1553  CE2 PHE    40      35.224 106.590  -8.552  1.00 28.90           C  
ATOM   1554  CZ  PHE    40      34.136 106.225  -7.755  1.00 31.86           C  
ATOM   1555  N   GLU    41      35.225 113.450  -9.421  1.00 45.20           N  
ATOM   1556  CA  GLU    41      35.182 114.735 -10.121  1.00 48.64           C  
ATOM   1557  C   GLU    41      36.149 114.795 -11.292  1.00 49.01           C  
ATOM   1558  O   GLU    41      35.863 115.413 -12.316  1.00 50.22           O  
ATOM   1559  CB  GLU    41      35.511 115.869  -9.150  1.00 52.34           C  
ATOM   1560  CG  GLU    41      36.906 115.767  -8.535  1.00 59.42           C  
ATOM   1561  CD  GLU    41      37.721 117.041  -8.730  1.00 62.86           C  
ATOM   1562  OE1 GLU    41      37.987 117.406  -9.897  1.00 67.41           O  
ATOM   1563  OE2 GLU    41      38.091 117.680  -7.720  1.00 62.22           O  
ATOM   1564  N   THR    42      37.296 114.147 -11.132  1.00 49.32           N  
ATOM   1565  CA  THR    42      38.323 114.141 -12.162  1.00 47.61           C  
ATOM   1566  C   THR    42      38.082 113.124 -13.296  1.00 45.33           C  
ATOM   1567  O   THR    42      38.704 113.205 -14.353  1.00 42.19           O  
ATOM   1568  CB  THR    42      39.717 113.917 -11.511  1.00 48.23           C  
ATOM   1569  OG1 THR    42      40.556 113.159 -12.394  1.00 51.39           O  
ATOM   1570  CG2 THR    42      39.571 113.193 -10.172  1.00 45.58           C  
ATOM   1571  N   GLU    43      37.163 112.187 -13.092  1.00 44.51           N  
ATOM   1572  CA  GLU    43      36.878 111.187 -14.111  1.00 41.57           C  
ATOM   1573  C   GLU    43      35.505 111.365 -14.752  1.00 41.52           C  
ATOM   1574  O   GLU    43      35.196 110.736 -15.766  1.00 44.39           O  
ATOM   1575  CB  GLU    43      36.978 109.774 -13.522  1.00 43.81           C  
ATOM   1576  CG  GLU    43      38.375 109.344 -13.093  1.00 53.78           C  
ATOM   1577  CD  GLU    43      38.797 109.903 -11.741  1.00 59.81           C  
ATOM   1578  OE1 GLU    43      39.949 109.648 -11.322  1.00 66.31           O  
ATOM   1579  OE2 GLU    43      37.982 110.588 -11.090  1.00 67.02           O  
ATOM   1580  N   LEU    44      34.673 112.220 -14.170  1.00 40.18           N  
ATOM   1581  CA  LEU    44      33.338 112.435 -14.719  1.00 37.50           C  
ATOM   1582  C   LEU    44      33.211 113.728 -15.512  1.00 37.96           C  
ATOM   1583  O   LEU    44      33.648 114.791 -15.063  1.00 40.45           O  
ATOM   1584  CB  LEU    44      32.297 112.438 -13.597  1.00 32.21           C  
ATOM   1585  CG  LEU    44      32.195 111.167 -12.766  1.00 27.84           C  
ATOM   1586  CD1 LEU    44      31.086 111.322 -11.751  1.00 26.62           C  
ATOM   1587  CD2 LEU    44      31.923 109.984 -13.679  1.00 30.90           C  
ATOM   1588  N   THR    45      32.611 113.621 -16.693  1.00 34.19           N  
ATOM   1589  CA  THR    45      32.384 114.771 -17.547  1.00 35.13           C  
ATOM   1590  C   THR    45      31.163 115.510 -16.998  1.00 34.08           C  
ATOM   1591  O   THR    45      31.064 116.733 -17.089  1.00 34.71           O  
ATOM   1592  CB  THR    45      32.115 114.349 -19.022  1.00 39.29           C  
ATOM   1593  OG1 THR    45      31.728 115.504 -19.780  1.00 42.07           O  
ATOM   1594  CG2 THR    45      31.009 113.302 -19.103  1.00 38.35           C  
ATOM   1595  N   GLU    46      30.231 114.745 -16.441  1.00 31.19           N  
ATOM   1596  CA  GLU    46      29.034 115.294 -15.824  1.00 36.59           C  
ATOM   1597  C   GLU    46      28.180 114.201 -15.196  1.00 35.80           C  
ATOM   1598  O   GLU    46      28.302 113.023 -15.539  1.00 34.74           O  
ATOM   1599  CB  GLU    46      28.188 116.098 -16.812  1.00 38.03           C  
ATOM   1600  CG  GLU    46      27.534 115.289 -17.895  1.00 48.23           C  
ATOM   1601  CD  GLU    46      26.618 116.141 -18.781  1.00 55.98           C  
ATOM   1602  OE1 GLU    46      27.057 117.229 -19.251  1.00 56.19           O  
ATOM   1603  OE2 GLU    46      25.460 115.710 -19.017  1.00 58.15           O  
ATOM   1604  N   LEU    47      27.333 114.605 -14.255  1.00 32.79           N  
ATOM   1605  CA  LEU    47      26.453 113.685 -13.564  1.00 25.19           C  
ATOM   1606  C   LEU    47      25.065 114.278 -13.677  1.00 24.20           C  
ATOM   1607  O   LEU    47      24.845 115.431 -13.315  1.00 27.81           O  
ATOM   1608  CB  LEU    47      26.876 113.559 -12.108  1.00 23.89           C  
ATOM   1609  CG  LEU    47      26.095 112.525 -11.313  1.00 18.31           C  
ATOM   1610  CD1 LEU    47      26.939 112.062 -10.138  1.00 19.78           C  
ATOM   1611  CD2 LEU    47      24.775 113.124 -10.866  1.00 16.98           C  
ATOM   1612  N   ALA    48      24.126 113.504 -14.198  1.00 22.62           N  
ATOM   1613  CA  ALA    48      22.771 114.015 -14.376  1.00 21.56           C  
ATOM   1614  C   ALA    48      21.717 113.392 -13.464  1.00 20.92           C  
ATOM   1615  O   ALA    48      21.806 112.222 -13.091  1.00 20.60           O  
ATOM   1616  CB  ALA    48      22.353 113.848 -15.836  1.00 14.97           C  
ATOM   1617  N   LEU    49      20.717 114.189 -13.104  1.00 20.06           N  
ATOM   1618  CA  LEU    49      19.621 113.702 -12.277  1.00 21.13           C  
ATOM   1619  C   LEU    49      18.387 113.657 -13.176  1.00 21.86           C  
ATOM   1620  O   LEU    49      17.997 114.671 -13.733  1.00 22.90           O  
ATOM   1621  CB  LEU    49      19.382 114.643 -11.084  1.00 17.94           C  
ATOM   1622  CG  LEU    49      20.515 114.711 -10.047  1.00 17.37           C  
ATOM   1623  CD1 LEU    49      20.426 115.992  -9.265  1.00 17.78           C  
ATOM   1624  CD2 LEU    49      20.453 113.519  -9.121  1.00 14.96           C  
ATOM   1625  N   LYS    50      17.803 112.477 -13.357  1.00 23.96           N  
ATOM   1626  CA  LYS    50      16.609 112.342 -14.183  1.00 24.56           C  
ATOM   1627  C   LYS    50      15.385 111.979 -13.356  1.00 24.08           C  
ATOM   1628  O   LYS    50      15.334 110.907 -12.746  1.00 29.13           O  
ATOM   1629  CB  LYS    50      16.805 111.260 -15.258  1.00 29.60           C  
ATOM   1630  CG  LYS    50      15.518 110.961 -16.062  1.00 38.16           C  
ATOM   1631  CD  LYS    50      15.671 109.851 -17.108  1.00 40.68           C  
ATOM   1632  CE  LYS    50      16.610 110.257 -18.251  1.00 51.82           C  
ATOM   1633  NZ  LYS    50      16.093 111.355 -19.139  1.00 48.44           N  
ATOM   1634  N   PRO    51      14.382 112.859 -13.325  1.00 22.59           N  
ATOM   1635  CA  PRO    51      13.176 112.554 -12.552  1.00 25.38           C  
ATOM   1636  C   PRO    51      12.553 111.288 -13.105  1.00 27.86           C  
ATOM   1637  O   PRO    51      12.436 111.141 -14.319  1.00 27.06           O  
ATOM   1638  CB  PRO    51      12.292 113.773 -12.794  1.00 27.38           C  
ATOM   1639  CG  PRO    51      13.281 114.886 -12.956  1.00 26.85           C  
ATOM   1640  CD  PRO    51      14.356 114.244 -13.825  1.00 23.65           C  
ATOM   1641  N   GLY    52      12.153 110.383 -12.216  1.00 32.91           N  
ATOM   1642  CA  GLY    52      11.559 109.127 -12.640  1.00 36.98           C  
ATOM   1643  C   GLY    52      10.123 108.903 -12.202  1.00 40.80           C  
ATOM   1644  O   GLY    52       9.546 109.714 -11.481  1.00 37.38           O  
ATOM   1645  N   THR    53       9.563 107.772 -12.632  1.00 48.76           N  
ATOM   1646  CA  THR    53       8.180 107.396 -12.341  1.00 52.36           C  
ATOM   1647  C   THR    53       7.897 107.011 -10.892  1.00 54.71           C  
ATOM   1648  O   THR    53       7.858 107.868 -10.003  1.00 60.21           O  
ATOM   1649  CB  THR    53       7.735 106.216 -13.217  1.00 56.86           C  
ATOM   1650  OG1 THR    53       8.252 106.378 -14.543  1.00 60.67           O  
ATOM   1651  CG2 THR    53       6.212 106.147 -13.273  1.00 58.18           C  
ATOM   1652  N   GLY    54       7.693 105.715 -10.664  1.00 47.98           N  
ATOM   1653  CA  GLY    54       7.372 105.247  -9.331  1.00 46.90           C  
ATOM   1654  C   GLY    54       8.318 104.226  -8.740  1.00 45.07           C  
ATOM   1655  O   GLY    54       8.611 103.199  -9.351  1.00 43.29           O  
ATOM   1656  N   GLY    55       8.793 104.522  -7.533  1.00 41.52           N  
ATOM   1657  CA  GLY    55       9.700 103.632  -6.839  1.00 36.31           C  
ATOM   1658  C   GLY    55      11.041 103.449  -7.516  1.00 32.35           C  
ATOM   1659  O   GLY    55      11.884 102.685  -7.053  1.00 34.97           O  
ATOM   1660  N   VAL    56      11.249 104.154  -8.611  1.00 28.59           N  
ATOM   1661  CA  VAL    56      12.494 104.043  -9.350  1.00 29.28           C  
ATOM   1662  C   VAL    56      13.697 104.764  -8.741  1.00 30.33           C  
ATOM   1663  O   VAL    56      13.624 105.938  -8.368  1.00 32.26           O  
ATOM   1664  CB  VAL    56      12.321 104.578 -10.786  1.00 30.24           C  
ATOM   1665  CG1 VAL    56      13.637 104.494 -11.543  1.00 15.34           C  
ATOM   1666  CG2 VAL    56      11.242 103.762 -11.508  1.00 40.19           C  
ATOM   1667  N   PHE    57      14.812 104.057  -8.638  1.00 26.67           N  
ATOM   1668  CA  PHE    57      16.029 104.677  -8.151  1.00 23.98           C  
ATOM   1669  C   PHE    57      17.193 103.910  -8.712  1.00 19.33           C  
ATOM   1670  O   PHE    57      17.634 102.940  -8.120  1.00 22.04           O  
ATOM   1671  CB  PHE    57      16.124 104.686  -6.624  1.00 26.86           C  
ATOM   1672  CG  PHE    57      17.181 105.632  -6.109  1.00 25.63           C  
ATOM   1673  CD1 PHE    57      16.853 106.919  -5.727  1.00 21.45           C  
ATOM   1674  CD2 PHE    57      18.522 105.278  -6.132  1.00 26.35           C  
ATOM   1675  CE1 PHE    57      17.838 107.832  -5.389  1.00 22.63           C  
ATOM   1676  CE2 PHE    57      19.513 106.203  -5.790  1.00 25.01           C  
ATOM   1677  CZ  PHE    57      19.162 107.472  -5.424  1.00 21.00           C  
ATOM   1678  N   VAL    58      17.701 104.340  -9.854  1.00 16.87           N  
ATOM   1679  CA  VAL    58      18.811 103.619 -10.449  1.00 16.50           C  
ATOM   1680  C   VAL    58      19.990 104.509 -10.803  1.00 14.74           C  
ATOM   1681  O   VAL    58      19.833 105.682 -11.099  1.00 19.25           O  
ATOM   1682  CB  VAL    58      18.336 102.803 -11.703  1.00 17.29           C  
ATOM   1683  CG1 VAL    58      17.143 103.480 -12.358  1.00 13.35           C  
ATOM   1684  CG2 VAL    58      19.480 102.662 -12.707  1.00 10.59           C  
ATOM   1685  N   VAL    59      21.181 103.944 -10.737  1.00 17.11           N  
ATOM   1686  CA  VAL    59      22.387 104.675 -11.069  1.00 14.59           C  
ATOM   1687  C   VAL    59      22.962 104.053 -12.337  1.00 18.14           C  
ATOM   1688  O   VAL    59      23.117 102.827 -12.434  1.00 18.37           O  
ATOM   1689  CB  VAL    59      23.442 104.565  -9.941  1.00 14.04           C  
ATOM   1690  CG1 VAL    59      24.705 105.319 -10.332  1.00 14.47           C  
ATOM   1691  CG2 VAL    59      22.881 105.116  -8.644  1.00 10.10           C  
ATOM   1692  N   ARG    60      23.275 104.900 -13.310  1.00 19.90           N  
ATOM   1693  CA  ARG    60      23.835 104.443 -14.582  1.00 22.68           C  
ATOM   1694  C   ARG    60      25.212 105.039 -14.826  1.00 26.21           C  
ATOM   1695  O   ARG    60      25.455 106.193 -14.495  1.00 30.19           O  
ATOM   1696  CB  ARG    60      22.913 104.835 -15.737  1.00 17.23           C  
ATOM   1697  CG  ARG    60      22.086 103.684 -16.262  1.00 28.18           C  
ATOM   1698  CD  ARG    60      21.105 104.151 -17.308  1.00 28.75           C  
ATOM   1699  NE  ARG    60      19.884 104.634 -16.674  1.00 32.77           N  
ATOM   1700  CZ  ARG    60      18.712 104.017 -16.761  1.00 32.20           C  
ATOM   1701  NH1 ARG    60      18.598 102.897 -17.463  1.00 36.11           N  
ATOM   1702  NH2 ARG    60      17.660 104.509 -16.130  1.00 32.88           N  
ATOM   1703  N   VAL    61      26.131 104.249 -15.369  1.00 26.06           N  
ATOM   1704  CA  VAL    61      27.463 104.762 -15.688  1.00 27.01           C  
ATOM   1705  C   VAL    61      27.661 104.437 -17.173  1.00 29.36           C  
ATOM   1706  O   VAL    61      27.682 103.262 -17.563  1.00 24.96           O  
ATOM   1707  CB  VAL    61      28.585 104.089 -14.844  1.00 28.99           C  
ATOM   1708  CG1 VAL    61      29.954 104.665 -15.242  1.00 25.18           C  
ATOM   1709  CG2 VAL    61      28.341 104.307 -13.370  1.00 24.83           C  
ATOM   1710  N   ASP    62      27.775 105.482 -17.993  1.00 29.70           N  
ATOM   1711  CA  ASP    62      27.935 105.318 -19.434  1.00 37.02           C  
ATOM   1712  C   ASP    62      26.786 104.488 -20.032  1.00 41.12           C  
ATOM   1713  O   ASP    62      27.016 103.520 -20.764  1.00 43.88           O  
ATOM   1714  CB  ASP    62      29.282 104.654 -19.732  1.00 38.18           C  
ATOM   1715  CG  ASP    62      30.466 105.553 -19.381  1.00 43.43           C  
ATOM   1716  OD1 ASP    62      31.534 105.021 -19.002  1.00 47.13           O  
ATOM   1717  OD2 ASP    62      30.341 106.795 -19.495  1.00 40.93           O  
ATOM   1718  N   ASP    63      25.553 104.870 -19.698  1.00 43.52           N  
ATOM   1719  CA  ASP    63      24.352 104.194 -20.181  1.00 43.34           C  
ATOM   1720  C   ASP    63      24.123 102.807 -19.583  1.00 42.44           C  
ATOM   1721  O   ASP    63      23.064 102.212 -19.780  1.00 40.82           O  
ATOM   1722  CB  ASP    63      24.383 104.108 -21.708  1.00 49.03           C  
ATOM   1723  CG  ASP    63      24.078 105.449 -22.377  1.00 56.96           C  
ATOM   1724  OD1 ASP    63      22.893 105.855 -22.397  1.00 62.08           O  
ATOM   1725  OD2 ASP    63      25.022 106.101 -22.880  1.00 60.23           O  
ATOM   1726  N   GLU    64      25.103 102.294 -18.847  1.00 43.04           N  
ATOM   1727  CA  GLU    64      24.972 100.970 -18.237  1.00 43.09           C  
ATOM   1728  C   GLU    64      24.517 101.046 -16.793  1.00 35.79           C  
ATOM   1729  O   GLU    64      25.144 101.718 -15.986  1.00 42.15           O  
ATOM   1730  CB  GLU    64      26.305 100.217 -18.330  1.00 48.93           C  
ATOM   1731  CG  GLU    64      26.543  99.569 -19.696  1.00 61.84           C  
ATOM   1732  CD  GLU    64      27.974  99.069 -19.869  1.00 73.08           C  
ATOM   1733  OE1 GLU    64      28.485  98.402 -18.928  1.00 78.01           O  
ATOM   1734  OE2 GLU    64      28.582  99.339 -20.946  1.00 71.08           O  
ATOM   1735  N   VAL    65      23.421 100.369 -16.469  1.00 27.63           N  
ATOM   1736  CA  VAL    65      22.921 100.387 -15.100  1.00 25.77           C  
ATOM   1737  C   VAL    65      23.882  99.655 -14.142  1.00 28.28           C  
ATOM   1738  O   VAL    65      24.226  98.485 -14.338  1.00 20.36           O  
ATOM   1739  CB  VAL    65      21.505  99.762 -14.994  1.00 25.81           C  
ATOM   1740  CG1 VAL    65      21.468  98.433 -15.735  1.00 35.04           C  
ATOM   1741  CG2 VAL    65      21.140  99.546 -13.525  1.00 14.82           C  
ATOM   1742  N   VAL    66      24.313 100.375 -13.108  1.00 27.20           N  
ATOM   1743  CA  VAL    66      25.237  99.852 -12.122  1.00 23.67           C  
ATOM   1744  C   VAL    66      24.561  99.598 -10.779  1.00 24.73           C  
ATOM   1745  O   VAL    66      25.038  98.789  -9.979  1.00 25.71           O  
ATOM   1746  CB  VAL    66      26.408 100.821 -11.961  1.00 24.07           C  
ATOM   1747  CG1 VAL    66      27.305 100.416 -10.806  1.00 25.95           C  
ATOM   1748  CG2 VAL    66      27.204 100.836 -13.246  1.00 19.62           C  
ATOM   1749  N   TRP    67      23.444 100.270 -10.531  1.00 26.59           N  
ATOM   1750  CA  TRP    67      22.721 100.071  -9.283  1.00 24.40           C  
ATOM   1751  C   TRP    67      21.243 100.265  -9.473  1.00 20.86           C  
ATOM   1752  O   TRP    67      20.817 101.260 -10.040  1.00 23.33           O  
ATOM   1753  CB  TRP    67      23.213 101.041  -8.211  1.00 26.08           C  
ATOM   1754  CG  TRP    67      22.669 100.721  -6.859  1.00 24.39           C  
ATOM   1755  CD1 TRP    67      21.405 100.967  -6.396  1.00 24.24           C  
ATOM   1756  CD2 TRP    67      23.368 100.083  -5.793  1.00 22.69           C  
ATOM   1757  NE1 TRP    67      21.277 100.526  -5.103  1.00 19.54           N  
ATOM   1758  CE2 TRP    67      22.468  99.981  -4.706  1.00 21.17           C  
ATOM   1759  CE3 TRP    67      24.669  99.590  -5.646  1.00 19.66           C  
ATOM   1760  CZ2 TRP    67      22.830  99.411  -3.493  1.00 19.53           C  
ATOM   1761  CZ3 TRP    67      25.029  99.026  -4.447  1.00 17.34           C  
ATOM   1762  CH2 TRP    67      24.113  98.941  -3.380  1.00 22.91           C  
ATOM   1763  N   ASP    68      20.463  99.303  -9.005  1.00 20.11           N  
ATOM   1764  CA  ASP    68      19.012  99.388  -9.099  1.00 25.74           C  
ATOM   1765  C   ASP    68      18.429  99.124  -7.711  1.00 27.04           C  
ATOM   1766  O   ASP    68      18.701  98.089  -7.106  1.00 34.40           O  
ATOM   1767  CB  ASP    68      18.484  98.352 -10.089  1.00 29.43           C  
ATOM   1768  CG  ASP    68      16.993  98.503 -10.359  1.00 37.13           C  
ATOM   1769  OD1 ASP    68      16.222  98.766  -9.405  1.00 40.64           O  
ATOM   1770  OD2 ASP    68      16.588  98.348 -11.531  1.00 40.24           O  
ATOM   1771  N   ARG    69      17.623 100.053  -7.215  1.00 27.74           N  
ATOM   1772  CA  ARG    69      17.017  99.922  -5.890  1.00 30.14           C  
ATOM   1773  C   ARG    69      16.300  98.595  -5.624  1.00 31.56           C  
ATOM   1774  O   ARG    69      16.653  97.873  -4.692  1.00 26.37           O  
ATOM   1775  CB  ARG    69      16.025 101.054  -5.647  1.00 26.47           C  
ATOM   1776  CG  ARG    69      15.642 101.191  -4.201  1.00 31.13           C  
ATOM   1777  CD  ARG    69      14.402 102.044  -4.005  1.00 36.14           C  
ATOM   1778  NE  ARG    69      13.230 101.218  -3.775  1.00 38.88           N  
ATOM   1779  CZ  ARG    69      12.604 100.525  -4.719  1.00 43.61           C  
ATOM   1780  NH1 ARG    69      11.542  99.782  -4.414  1.00 47.81           N  
ATOM   1781  NH2 ARG    69      13.021 100.587  -5.974  1.00 44.92           N  
ATOM   1782  N   ARG    70      15.288  98.280  -6.430  1.00 33.52           N  
ATOM   1783  CA  ARG    70      14.543  97.048  -6.223  1.00 41.98           C  
ATOM   1784  C   ARG    70      15.303  95.813  -6.667  1.00 42.00           C  
ATOM   1785  O   ARG    70      14.736  94.867  -7.195  1.00 44.92           O  
ATOM   1786  CB  ARG    70      13.157  97.116  -6.893  1.00 44.21           C  
ATOM   1787  CG  ARG    70      13.138  97.606  -8.309  1.00 51.43           C  
ATOM   1788  CD  ARG    70      13.527  96.536  -9.295  1.00 57.29           C  
ATOM   1789  NE  ARG    70      13.537  97.075 -10.653  1.00 67.22           N  
ATOM   1790  CZ  ARG    70      13.974  96.418 -11.720  1.00 67.47           C  
ATOM   1791  NH1 ARG    70      14.442  95.180 -11.591  1.00 62.93           N  
ATOM   1792  NH2 ARG    70      13.949  97.009 -12.914  1.00 71.38           N  
ATOM   1793  N   GLU    71      16.600  95.821  -6.407  1.00 42.39           N  
ATOM   1794  CA  GLU    71      17.453  94.714  -6.768  1.00 40.69           C  
ATOM   1795  C   GLU    71      18.616  94.666  -5.787  1.00 38.69           C  
ATOM   1796  O   GLU    71      19.081  93.593  -5.414  1.00 35.90           O  
ATOM   1797  CB  GLU    71      17.964  94.923  -8.186  1.00 45.75           C  
ATOM   1798  CG  GLU    71      19.151  94.072  -8.557  1.00 58.77           C  
ATOM   1799  CD  GLU    71      18.834  93.060  -9.651  1.00 65.31           C  
ATOM   1800  OE1 GLU    71      19.789  92.437 -10.187  1.00 67.06           O  
ATOM   1801  OE2 GLU    71      17.632  92.893  -9.969  1.00 67.56           O  
ATOM   1802  N   GLN    72      19.063  95.834  -5.342  1.00 34.65           N  
ATOM   1803  CA  GLN    72      20.190  95.896  -4.425  1.00 32.47           C  
ATOM   1804  C   GLN    72      19.918  96.791  -3.242  1.00 32.08           C  
ATOM   1805  O   GLN    72      20.809  97.042  -2.437  1.00 34.82           O  
ATOM   1806  CB  GLN    72      21.424  96.388  -5.173  1.00 33.17           C  
ATOM   1807  CG  GLN    72      21.362  96.051  -6.643  1.00 34.18           C  
ATOM   1808  CD  GLN    72      22.530  96.578  -7.405  1.00 36.48           C  
ATOM   1809  OE1 GLN    72      22.390  96.999  -8.548  1.00 37.61           O  
ATOM   1810  NE2 GLN    72      23.704  96.553  -6.786  1.00 41.14           N  
ATOM   1811  N   GLY    73      18.685  97.272  -3.136  1.00 31.96           N  
ATOM   1812  CA  GLY    73      18.331  98.142  -2.026  1.00 26.30           C  
ATOM   1813  C   GLY    73      18.884  99.562  -2.071  1.00 24.64           C  
ATOM   1814  O   GLY    73      19.304 100.066  -3.116  1.00 26.56           O  
ATOM   1815  N   PHE    74      18.877 100.203  -0.908  1.00 22.82           N  
ATOM   1816  CA  PHE    74      19.343 101.569  -0.754  1.00 23.62           C  
ATOM   1817  C   PHE    74      20.782 101.741  -1.240  1.00 25.52           C  
ATOM   1818  O   PHE    74      21.653 100.929  -0.939  1.00 21.83           O  
ATOM   1819  CB  PHE    74      19.235 102.005   0.713  1.00 17.63           C  
ATOM   1820  CG  PHE    74      19.596 103.436   0.930  1.00 22.39           C  
ATOM   1821  CD1 PHE    74      18.677 104.447   0.655  1.00 24.11           C  
ATOM   1822  CD2 PHE    74      20.897 103.786   1.276  1.00 24.27           C  
ATOM   1823  CE1 PHE    74      19.056 105.790   0.710  1.00 27.45           C  
ATOM   1824  CE2 PHE    74      21.290 105.123   1.336  1.00 25.44           C  
ATOM   1825  CZ  PHE    74      20.372 106.129   1.050  1.00 26.59           C  
ATOM   1826  N   PRO    75      21.047 102.814  -2.001  1.00 26.42           N  
ATOM   1827  CA  PRO    75      22.402 103.037  -2.506  1.00 30.62           C  
ATOM   1828  C   PRO    75      23.438 103.468  -1.465  1.00 32.60           C  
ATOM   1829  O   PRO    75      23.824 104.634  -1.416  1.00 33.82           O  
ATOM   1830  CB  PRO    75      22.190 104.085  -3.601  1.00 26.01           C  
ATOM   1831  CG  PRO    75      21.066 104.898  -3.041  1.00 31.94           C  
ATOM   1832  CD  PRO    75      20.118 103.838  -2.512  1.00 25.71           C  
ATOM   1833  N   GLU    76      23.886 102.523  -0.640  1.00 32.70           N  
ATOM   1834  CA  GLU    76      24.907 102.809   0.372  1.00 34.65           C  
ATOM   1835  C   GLU    76      26.147 103.377  -0.351  1.00 36.38           C  
ATOM   1836  O   GLU    76      26.734 102.719  -1.222  1.00 32.20           O  
ATOM   1837  CB  GLU    76      25.261 101.525   1.134  1.00 37.11           C  
ATOM   1838  CG  GLU    76      26.053 101.738   2.419  1.00 46.96           C  
ATOM   1839  CD  GLU    76      27.573 101.674   2.227  1.00 54.03           C  
ATOM   1840  OE1 GLU    76      28.284 102.503   2.854  1.00 53.38           O  
ATOM   1841  OE2 GLU    76      28.053 100.790   1.469  1.00 54.08           O  
ATOM   1842  N   PRO    77      26.573 104.599   0.028  1.00 37.27           N  
ATOM   1843  CA  PRO    77      27.723 105.284  -0.573  1.00 36.67           C  
ATOM   1844  C   PRO    77      28.926 104.417  -0.966  1.00 38.30           C  
ATOM   1845  O   PRO    77      29.356 104.407  -2.125  1.00 39.25           O  
ATOM   1846  CB  PRO    77      28.064 106.354   0.465  1.00 30.87           C  
ATOM   1847  CG  PRO    77      27.585 105.757   1.733  1.00 35.87           C  
ATOM   1848  CD  PRO    77      26.259 105.198   1.335  1.00 36.78           C  
ATOM   1849  N   THR    78      29.472 103.688  -0.009  1.00 36.96           N  
ATOM   1850  CA  THR    78      30.627 102.849  -0.288  1.00 40.65           C  
ATOM   1851  C   THR    78      30.379 101.830  -1.396  1.00 40.53           C  
ATOM   1852  O   THR    78      31.098 101.800  -2.398  1.00 40.71           O  
ATOM   1853  CB  THR    78      31.053 102.111   0.984  1.00 43.25           C  
ATOM   1854  OG1 THR    78      31.328 103.076   2.011  1.00 49.41           O  
ATOM   1855  CG2 THR    78      32.296 101.276   0.729  1.00 40.87           C  
ATOM   1856  N   ALA    79      29.363 100.991  -1.197  1.00 39.05           N  
ATOM   1857  CA  ALA    79      28.989  99.958  -2.157  1.00 30.95           C  
ATOM   1858  C   ALA    79      28.860 100.524  -3.559  1.00 30.87           C  
ATOM   1859  O   ALA    79      29.476 100.021  -4.495  1.00 32.07           O  
ATOM   1860  CB  ALA    79      27.674  99.326  -1.744  1.00 30.22           C  
ATOM   1861  N   VAL    80      28.056 101.573  -3.701  1.00 29.83           N  
ATOM   1862  CA  VAL    80      27.845 102.176  -5.008  1.00 32.09           C  
ATOM   1863  C   VAL    80      29.089 102.872  -5.550  1.00 31.24           C  
ATOM   1864  O   VAL    80      29.303 102.901  -6.760  1.00 33.15           O  
ATOM   1865  CB  VAL    80      26.639 103.166  -5.004  1.00 30.11           C  
ATOM   1866  CG1 VAL    80      26.846 104.240  -3.969  1.00 33.03           C  
ATOM   1867  CG2 VAL    80      26.468 103.776  -6.381  1.00 27.36           C  
ATOM   1868  N   LYS    81      29.922 103.424  -4.675  1.00 31.39           N  
ATOM   1869  CA  LYS    81      31.128 104.082  -5.165  1.00 31.48           C  
ATOM   1870  C   LYS    81      32.096 103.060  -5.727  1.00 31.99           C  
ATOM   1871  O   LYS    81      32.828 103.339  -6.673  1.00 34.67           O  
ATOM   1872  CB  LYS    81      31.805 104.914  -4.064  1.00 26.53           C  
ATOM   1873  CG  LYS    81      31.266 106.332  -4.022  1.00 31.15           C  
ATOM   1874  CD  LYS    81      32.104 107.272  -3.195  1.00 34.88           C  
ATOM   1875  CE  LYS    81      31.706 107.256  -1.727  1.00 36.99           C  
ATOM   1876  NZ  LYS    81      32.451 108.286  -0.938  1.00 35.32           N  
ATOM   1877  N   ARG    82      32.084 101.862  -5.162  1.00 34.10           N  
ATOM   1878  CA  ARG    82      32.978 100.825  -5.632  1.00 36.80           C  
ATOM   1879  C   ARG    82      32.578 100.319  -6.998  1.00 34.53           C  
ATOM   1880  O   ARG    82      33.438 100.082  -7.844  1.00 35.29           O  
ATOM   1881  CB  ARG    82      33.023  99.677  -4.638  1.00 44.18           C  
ATOM   1882  CG  ARG    82      34.369  99.584  -3.988  1.00 51.62           C  
ATOM   1883  CD  ARG    82      34.177  99.776  -2.469  1.00 55.04           C  
ATOM   1884  NE  ARG    82      34.057  98.421  -2.176  1.00 59.29           N  
ATOM   1885  CZ  ARG    82      33.233  97.547  -1.649  1.00 61.20           C  
ATOM   1886  NH1 ARG    82      32.044  97.651  -1.063  1.00 59.66           N  
ATOM   1887  NH2 ARG    82      33.675  96.365  -2.009  1.00 60.79           N  
ATOM   1888  N   LEU    83      31.274 100.160  -7.208  1.00 30.67           N  
ATOM   1889  CA  LEU    83      30.756  99.692  -8.490  1.00 30.34           C  
ATOM   1890  C   LEU    83      30.966 100.737  -9.566  1.00 29.94           C  
ATOM   1891  O   LEU    83      31.124 100.399 -10.738  1.00 31.06           O  
ATOM   1892  CB  LEU    83      29.268  99.369  -8.390  1.00 29.27           C  
ATOM   1893  CG  LEU    83      28.906  97.975  -7.870  1.00 29.71           C  
ATOM   1894  CD1 LEU    83      29.519  97.735  -6.500  1.00 37.64           C  
ATOM   1895  CD2 LEU    83      27.400  97.861  -7.795  1.00 32.00           C  
ATOM   1896  N   VAL    84      30.954 102.007  -9.170  1.00 29.27           N  
ATOM   1897  CA  VAL    84      31.168 103.107 -10.114  1.00 28.41           C  
ATOM   1898  C   VAL    84      32.658 103.201 -10.473  1.00 30.57           C  
ATOM   1899  O   VAL    84      33.006 103.503 -11.611  1.00 26.17           O  
ATOM   1900  CB  VAL    84      30.692 104.474  -9.525  1.00 28.14           C  
ATOM   1901  CG1 VAL    84      31.179 105.626 -10.402  1.00 23.12           C  
ATOM   1902  CG2 VAL    84      29.166 104.505  -9.432  1.00 23.83           C  
ATOM   1903  N   ARG    85      33.531 102.939  -9.500  1.00 35.11           N  
ATOM   1904  CA  ARG    85      34.964 102.990  -9.738  1.00 37.04           C  
ATOM   1905  C   ARG    85      35.376 101.886 -10.717  1.00 36.72           C  
ATOM   1906  O   ARG    85      36.238 102.089 -11.569  1.00 31.75           O  
ATOM   1907  CB  ARG    85      35.739 102.839  -8.427  1.00 37.33           C  
ATOM   1908  CG  ARG    85      37.244 102.921  -8.635  1.00 45.43           C  
ATOM   1909  CD  ARG    85      38.040 102.134  -7.605  1.00 50.86           C  
ATOM   1910  NE  ARG    85      37.550 100.814  -7.382  1.00 53.15           N  
ATOM   1911  CZ  ARG    85      37.365 100.069  -6.298  1.00 51.12           C  
ATOM   1912  NH1 ARG    85      36.886  98.880  -6.578  1.00 52.18           N  
ATOM   1913  NH2 ARG    85      37.595 100.408  -5.032  1.00 45.28           N  
ATOM   1914  N   ASP    86      34.747 100.722 -10.610  1.00 40.19           N  
ATOM   1915  CA  ASP    86      35.064  99.612 -11.499  1.00 41.80           C  
ATOM   1916  C   ASP    86      34.682  99.903 -12.946  1.00 44.13           C  
ATOM   1917  O   ASP    86      35.159  99.222 -13.843  1.00 48.91           O  
ATOM   1918  CB  ASP    86      34.357  98.328 -11.045  1.00 44.39           C  
ATOM   1919  CG  ASP    86      34.920  97.758  -9.741  1.00 50.17           C  
ATOM   1920  OD1 ASP    86      34.380  96.720  -9.274  1.00 49.93           O  
ATOM   1921  OD2 ASP    86      35.893  98.333  -9.188  1.00 49.54           O  
ATOM   1922  N   ARG    87      33.824 100.897 -13.179  1.00 46.76           N  
ATOM   1923  CA  ARG    87      33.407 101.250 -14.540  1.00 45.11           C  
ATOM   1924  C   ARG    87      34.408 102.233 -15.120  1.00 45.90           C  
ATOM   1925  O   ARG    87      34.480 102.426 -16.326  1.00 46.61           O  
ATOM   1926  CB  ARG    87      32.032 101.918 -14.546  1.00 48.07           C  
ATOM   1927  CG  ARG    87      31.023 101.391 -13.534  1.00 56.36           C  
ATOM   1928  CD  ARG    87      30.757  99.933 -13.732  1.00 52.84           C  
ATOM   1929  NE  ARG    87      30.517  99.635 -15.134  1.00 58.50           N  
ATOM   1930  CZ  ARG    87      30.047  98.471 -15.562  1.00 63.85           C  
ATOM   1931  NH1 ARG    87      29.853  98.261 -16.861  1.00 61.62           N  
ATOM   1932  NH2 ARG    87      29.763  97.520 -14.675  1.00 63.63           N  
ATOM   1933  N   VAL    88      35.172 102.872 -14.247  1.00 48.48           N  
ATOM   1934  CA  VAL    88      36.171 103.831 -14.690  1.00 49.97           C  
ATOM   1935  C   VAL    88      37.566 103.462 -14.145  1.00 57.00           C  
ATOM   1936  O   VAL    88      38.133 104.262 -13.352  1.00 57.96           O  
ATOM   1937  CB  VAL    88      35.804 105.249 -14.225  1.00 46.27           C  
ATOM   1938  CG1 VAL    88      36.625 106.273 -15.003  1.00 39.40           C  
ATOM   1939  CG2 VAL    88      34.310 105.489 -14.396  1.00 38.65           C  
END
