
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  108 ( 1021),  selected  108 , name 1thx_A
# Molecule2: number of CA atoms   77 (  633),  selected   77 , name T0458.pdb
# PARAMETERS: 1thx_A.T0458.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     1_A      -       -           -
LGA    K     2_A      -       -           -
LGA    G     3_A      -       -           -
LGA    V     4_A      -       -           -
LGA    I     5_A      -       -           -
LGA    T     6_A      -       -           -
LGA    I     7_A      -       -           -
LGA    T     8_A      -       -           -
LGA    D     9_A      -       -           -
LGA    A    10_A      -       -           -
LGA    E    11_A      -       -           -
LGA    F    12_A      -       -           -
LGA    E    13_A      -       -           -
LGA    S    14_A      -       -           -
LGA    E    15_A      -       -           -
LGA    V    16_A      -       -           -
LGA    L    17_A      -       -           -
LGA    K    18_A      -       -           -
LGA    A    19_A      -       -           -
LGA    E    20_A      -       -           -
LGA    Q    21_A      T      12          1.610
LGA    P    22_A      H      13          1.847
LGA    V    23_A      R      14          0.902
LGA    L    24_A      V      15          0.830
LGA    V    25_A      Q      16          0.771
LGA    Y    26_A      I      17          0.680
LGA    F    27_A      E      18          0.761
LGA    W    28_A      Y      19          1.754
LGA    A    29_A      C      20          3.418
LGA    S    30_A      T      21          2.804
LGA    W    31_A      Q      22          1.375
LGA    C    32_A      C      23          1.780
LGA    G    33_A      R      24          3.807
LGA    P    34_A      W      25          4.586
LGA    C    35_A      L      26          4.755
LGA    Q    36_A      P      27          3.096
LGA    L    37_A      R      28          2.609
LGA    M    38_A      A      29          3.371
LGA    S    39_A      A      30          2.151
LGA    P    40_A      W      31          0.666
LGA    L    41_A      L      32          1.846
LGA    I    42_A      A      33          1.625
LGA    N    43_A      Q      34          1.558
LGA    L    44_A      E      35          1.841
LGA    A    45_A      L      36          0.768
LGA    A    46_A      L      37          1.070
LGA    N    47_A      T      38          2.258
LGA    T    48_A      T      39          1.965
LGA    Y    49_A      F      40          0.976
LGA    S    50_A      E      41          1.058
LGA    D    51_A      T      42          1.369
LGA    R    52_A      E      43          0.544
LGA    L    53_A      L      44          1.093
LGA    K    54_A      T      45          3.173
LGA    -       -      E      46           -
LGA    V    55_A      L      47          0.800
LGA    V    56_A      A      48          0.896
LGA    K    57_A      L      49          1.129
LGA    L    58_A      K      50          1.306
LGA    E    59_A      P      51          1.314
LGA    I    60_A      G      52          2.718
LGA    D    61_A      T      53          5.930
LGA    P    62_A      G      54           -
LGA    N    63_A      -       -           -
LGA    P    64_A      -       -           -
LGA    T    65_A      -       -           -
LGA    T    66_A      -       -           -
LGA    V    67_A      -       -           -
LGA    K    68_A      -       -           -
LGA    K    69_A      -       -           -
LGA    Y    70_A      -       -           -
LGA    K    71_A      -       -           -
LGA    V    72_A      -       -           -
LGA    E    73_A      -       -           -
LGA    G    74_A      G      55          4.355
LGA    V    75_A      V      56          1.386
LGA    P    76_A      F      57          1.357
LGA    A    77_A      V      58          1.258
LGA    L    78_A      V      59          1.249
LGA    R    79_A      R      60          1.359
LGA    L    80_A      V      61          1.046
LGA    V    81_A      D      62          1.006
LGA    K    82_A      -       -           -
LGA    G    83_A      -       -           -
LGA    E    84_A      -       -           -
LGA    Q    85_A      -       -           -
LGA    I    86_A      D      63          3.639
LGA    L    87_A      E      64          3.662
LGA    D    88_A      V      65          3.698
LGA    S    89_A      V      66          2.530
LGA    T    90_A      W      67          1.541
LGA    E    91_A      D      68          1.471
LGA    G    92_A      R      69          1.885
LGA    -       -      R      70           -
LGA    -       -      E      71           -
LGA    -       -      Q      72           -
LGA    -       -      G      73           -
LGA    V    93_A      F      74          2.448
LGA    I    94_A      P      75          1.093
LGA    S    95_A      E      76          0.608
LGA    K    96_A      P      77          0.791
LGA    D    97_A      T      78          0.432
LGA    K    98_A      A      79          0.765
LGA    L    99_A      V      80          1.544
LGA    L   100_A      K      81          1.161
LGA    S   101_A      R      82          0.265
LGA    F   102_A      L      83          1.085
LGA    L   103_A      V      84          1.199
LGA    D   104_A      R      85          1.254
LGA    T   105_A      D      86          0.969
LGA    H   106_A      R      87          1.223
LGA    L   107_A      V      88          0.828
LGA    N   108_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  108   77    5.0     71    2.12     9.86     74.707     3.198

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.901184 * X  +  -0.312837 * Y  +  -0.300000 * Z  +  39.676811
  Y_new =  -0.329799 * X  +  -0.944030 * Y  +  -0.006273 * Z  + 140.107117
  Z_new =  -0.281247 * X  +   0.104593 * Y  +  -0.953918 * Z  +  29.880548 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   3.032383   -0.109210  [ DEG:   173.7427     -6.2573 ]
  Theta =   0.285093    2.856499  [ DEG:    16.3346    163.6654 ]
  Phi   =  -0.350824    2.790769  [ DEG:   -20.1007    159.8993 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1thx_A                                        
REMARK     2: T0458.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1thx_A.T0458.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  108   77   5.0   71   2.12    9.86  74.707
REMARK  ---------------------------------------------------------- 
MOLECULE 1thx_A
HEADER    ELECTRON TRANSPORT                      07-JUL-95   1THX              
TITLE     THIOREDOXIN-2                                                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: THIOREDOXIN;                                               
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: THIOREDOXIN 2;                                              
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ANABAENA SP.;                                   
SOURCE   3 STRAIN: PCC 7120;                                                    
SOURCE   4 ATCC: ATCC 27893;                                                    
SOURCE   5 GENE: TRXA;                                                          
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PAN673.2;                                 
SOURCE   8 EXPRESSION_SYSTEM_GENE: TRXA                                         
KEYWDS    OXIDO-REDUCTASE                                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.SAARINEN,F.K.GLEASON,H.EKLUND                                       
REVDAT   1   15-OCT-95 1THX    0                                                
JRNL        AUTH   M.SAARINEN,F.K.GLEASON,H.EKLUND                              
JRNL        TITL   CRYSTAL STRUCTURE OF THIOREDOXIN-2 FROM ANABAENA.            
JRNL        REF    STRUCTURE                     V.   3  1097 1995              
JRNL        REFN   ASTM STRUE6  UK ISSN 0969-2126                               
REMARK   2 RESOLUTION. 1.60 ANGSTROMS.                                          
DBREF  1THX A    1   110  UNP    P20857   THIO2_ANASP      1    110             
SEQRES   1 A  115  MET GLU THR ALA MET SER LYS GLY VAL ILE THR ILE THR          
SEQRES   2 A  115  ASP ALA GLU PHE GLU SER GLU VAL LEU LYS ALA GLU GLN          
SEQRES   3 A  115  PRO VAL LEU VAL TYR PHE TRP ALA SER TRP CYS GLY PRO          
SEQRES   4 A  115  CYS GLN LEU MET SER PRO LEU ILE ASN LEU ALA ALA ASN          
SEQRES   5 A  115  THR TYR SER ASP ARG LEU LYS VAL VAL LYS LEU GLU ILE          
SEQRES   6 A  115  ASP PRO ASN PRO THR THR VAL LYS LYS TYR LYS VAL GLU          
SEQRES   7 A  115  GLY VAL PRO ALA LEU ARG LEU VAL LYS GLY GLU GLN ILE          
SEQRES   8 A  115  LEU ASP SER THR GLU GLY VAL ILE SER LYS ASP LYS LEU          
SEQRES   9 A  115  LEU SER PHE LEU ASP THR HIS LEU ASN ASN ASN                  
FORMUL   2  HOH   *74(H2 O)                                                     
CRYST1   40.480   39.780   60.080  90.00  90.00  90.00 P 21 21 21    4          
ATOM      1  N   SER A   1      32.757 119.460 -14.449  1.00 49.39           N  
ATOM      2  CA  SER A   1      32.039 118.402 -13.674  1.00 47.96           C  
ATOM      3  C   SER A   1      32.295 118.433 -12.174  1.00 44.92           C  
ATOM      4  O   SER A   1      32.553 117.395 -11.562  1.00 46.65           O  
ATOM      5  CB  SER A   1      32.355 116.997 -14.251  1.00 50.54           C  
ATOM      6  OG  SER A   1      33.623 116.934 -14.889  1.00 55.67           O  
ATOM      7  HG  SER A   1      34.032 116.060 -14.738  1.00  0.00           H  
ATOM      8  N   LYS A   2      32.250 119.605 -11.560  1.00 40.26           N  
ATOM      9  CA  LYS A   2      32.466 119.636 -10.133  1.00 35.15           C  
ATOM     10  C   LYS A   2      31.166 119.113  -9.517  1.00 31.75           C  
ATOM     11  O   LYS A   2      31.223 118.341  -8.569  1.00 34.67           O  
ATOM     12  CB  LYS A   2      32.813 121.052  -9.665  0.50 35.25           C  
ATOM     13  CG  LYS A   2      33.480 121.120  -8.315  0.50 37.79           C  
ATOM     14  CD  LYS A   2      34.779 120.338  -8.295  0.50 39.20           C  
ATOM     15  CE  LYS A   2      35.348 120.231  -6.879  0.50 40.87           C  
ATOM     16  NZ  LYS A   2      36.169 121.406  -6.410  0.50 42.96           N  
ATOM     17  H   LYS A   2      32.066 120.474 -11.981  1.00  0.00           H  
ATOM     18  HZ1 LYS A   2      35.703 122.328  -6.498  1.00  0.00           H  
ATOM     19  HZ2 LYS A   2      36.382 121.284  -5.388  1.00  0.00           H  
ATOM     20  HZ3 LYS A   2      37.111 121.445  -6.857  1.00  0.00           H  
ATOM     21  N   GLY A   3      30.023 119.366 -10.163  1.00 25.75           N  
ATOM     22  CA  GLY A   3      28.751 118.926  -9.593  1.00 19.15           C  
ATOM     23  C   GLY A   3      27.804 118.203 -10.536  1.00 17.04           C  
ATOM     24  O   GLY A   3      28.214 117.686 -11.573  1.00 16.49           O  
ATOM     25  H   GLY A   3      29.985 119.746 -11.064  1.00  0.00           H  
ATOM     26  N   VAL A   4      26.527 118.191 -10.179  1.00 13.53           N  
ATOM     27  CA  VAL A   4      25.488 117.488 -10.947  1.00 12.68           C  
ATOM     28  C   VAL A   4      24.703 118.438 -11.842  1.00 11.92           C  
ATOM     29  O   VAL A   4      24.341 119.548 -11.420  1.00 11.77           O  
ATOM     30  CB  VAL A   4      24.446 116.799  -9.990  1.00 12.59           C  
ATOM     31  CG1 VAL A   4      23.388 116.069 -10.784  1.00 11.12           C  
ATOM     32  CG2 VAL A   4      25.138 115.861  -9.033  1.00 11.58           C  
ATOM     33  H   VAL A   4      26.252 118.627  -9.352  1.00  0.00           H  
ATOM     34  N   ILE A   5      24.511 118.049 -13.095  1.00  9.94           N  
ATOM     35  CA  ILE A   5      23.703 118.866 -14.000  1.00 10.73           C  
ATOM     36  C   ILE A   5      22.348 118.159 -14.230  1.00 10.61           C  
ATOM     37  O   ILE A   5      22.280 116.923 -14.418  1.00 10.92           O  
ATOM     38  CB  ILE A   5      24.381 119.183 -15.369  0.50 12.92           C  
ATOM     40  CG1 ILE A   5      24.582 117.908 -16.195  0.50 13.70           C  
ATOM     42  CG2 ILE A   5      25.683 119.962 -15.152  0.50 14.15           C  
ATOM     44  CD1 ILE A   5      24.703 118.153 -17.702  0.50 13.12           C  
ATOM     46  H   ILE A   5      24.905 117.211 -13.413  0.50  0.00           H  
ATOM     48  N   THR A   6      21.275 118.923 -14.132  1.00  9.21           N  
ATOM     49  CA  THR A   6      19.951 118.394 -14.376  1.00  9.69           C  
ATOM     50  C   THR A   6      19.665 118.586 -15.848  1.00 10.43           C  
ATOM     51  O   THR A   6      19.776 119.695 -16.359  1.00 11.22           O  
ATOM     52  CB  THR A   6      18.913 119.124 -13.543  1.00  9.28           C  
ATOM     53  OG1 THR A   6      19.161 118.834 -12.170  1.00 12.07           O  
ATOM     54  CG2 THR A   6      17.519 118.675 -13.903  1.00 10.65           C  
ATOM     55  H   THR A   6      21.340 119.869 -13.905  1.00  0.00           H  
ATOM     56  HG1 THR A   6      18.514 119.303 -11.634  1.00  0.00           H  
ATOM     57  N   ILE A   7      19.342 117.491 -16.538  1.00 11.26           N  
ATOM     58  CA  ILE A   7      19.047 117.535 -17.973  1.00 10.72           C  
ATOM     59  C   ILE A   7      17.630 117.072 -18.296  1.00 10.03           C  
ATOM     60  O   ILE A   7      16.915 116.567 -17.430  1.00 10.71           O  
ATOM     61  CB  ILE A   7      20.058 116.675 -18.803  1.00 11.64           C  
ATOM     62  CG1 ILE A   7      20.024 115.211 -18.361  1.00 13.23           C  
ATOM     63  CG2 ILE A   7      21.460 117.250 -18.660  1.00 14.41           C  
ATOM     64  CD1 ILE A   7      20.574 114.237 -19.386  1.00 16.14           C  
ATOM     65  H   ILE A   7      19.265 116.632 -16.072  1.00  0.00           H  
ATOM     66  N   THR A   8      17.241 117.250 -19.553  1.00  9.96           N  
ATOM     67  CA  THR A   8      15.937 116.848 -20.027  1.00 11.13           C  
ATOM     68  C   THR A   8      16.141 115.992 -21.284  1.00 10.61           C  
ATOM     69  O   THR A   8      17.265 115.873 -21.795  1.00 10.09           O  
ATOM     70  CB  THR A   8      15.066 118.088 -20.427  1.00 12.67           C  
ATOM     71  OG1 THR A   8      15.711 118.772 -21.510  1.00 13.75           O  
ATOM     72  CG2 THR A   8      14.864 119.070 -19.225  1.00 13.15           C  
ATOM     73  H   THR A   8      17.849 117.646 -20.207  1.00  0.00           H  
ATOM     74  HG1 THR A   8      15.241 119.577 -21.743  1.00  0.00           H  
ATOM     75  N   ASP A   9      15.048 115.428 -21.801  1.00 10.41           N  
ATOM     76  CA  ASP A   9      15.084 114.599 -23.016  1.00 10.85           C  
ATOM     77  C   ASP A   9      15.770 115.345 -24.149  1.00 10.55           C  
ATOM     78  O   ASP A   9      16.580 114.780 -24.859  1.00 11.73           O  
ATOM     79  CB  ASP A   9      13.661 114.259 -23.494  1.00 11.07           C  
ATOM     80  CG  ASP A   9      13.075 113.050 -22.805  1.00 12.28           C  
ATOM     81  OD1 ASP A   9      13.850 112.274 -22.213  1.00 11.68           O  
ATOM     82  OD2 ASP A   9      11.840 112.869 -22.858  1.00  9.87           O  
ATOM     83  H   ASP A   9      14.191 115.577 -21.339  1.00  0.00           H  
ATOM     84  N   ALA A  10      15.436 116.625 -24.285  1.00 11.11           N  
ATOM     85  CA  ALA A  10      15.977 117.483 -25.336  1.00 14.60           C  
ATOM     86  C   ALA A  10      17.495 117.652 -25.297  1.00 14.39           C  
ATOM     87  O   ALA A  10      18.114 117.932 -26.319  1.00 14.76           O  
ATOM     88  CB  ALA A  10      15.315 118.877 -25.276  1.00 13.57           C  
ATOM     89  H   ALA A  10      14.789 117.006 -23.655  1.00  0.00           H  
ATOM     90  N   GLU A  11      18.092 117.487 -24.123  1.00 13.46           N  
ATOM     91  CA  GLU A  11      19.524 117.669 -23.989  1.00 13.70           C  
ATOM     92  C   GLU A  11      20.305 116.400 -23.835  1.00 13.03           C  
ATOM     93  O   GLU A  11      21.541 116.425 -23.803  1.00 12.81           O  
ATOM     94  CB  GLU A  11      19.795 118.546 -22.783  1.00 16.00           C  
ATOM     95  CG  GLU A  11      19.247 119.915 -22.944  1.00 20.52           C  
ATOM     96  CD  GLU A  11      18.546 120.364 -21.715  1.00 27.22           C  
ATOM     97  OE1 GLU A  11      18.959 119.950 -20.608  1.00 26.78           O  
ATOM     98  OE2 GLU A  11      17.562 121.120 -21.861  1.00 33.70           O  
ATOM     99  H   GLU A  11      17.568 117.251 -23.339  1.00  0.00           H  
ATOM    100  N   PHE A  12      19.594 115.288 -23.803  1.00 12.16           N  
ATOM    101  CA  PHE A  12      20.228 114.008 -23.564  1.00 13.40           C  
ATOM    102  C   PHE A  12      21.334 113.630 -24.539  1.00 11.97           C  
ATOM    103  O   PHE A  12      22.433 113.216 -24.139  1.00 11.23           O  
ATOM    104  CB  PHE A  12      19.172 112.889 -23.460  1.00 14.94           C  
ATOM    105  CG  PHE A  12      19.750 111.573 -23.018  1.00 17.96           C  
ATOM    106  CD1 PHE A  12      20.075 111.370 -21.677  1.00 18.86           C  
ATOM    107  CD2 PHE A  12      20.062 110.583 -23.954  1.00 19.18           C  
ATOM    108  CE1 PHE A  12      20.717 110.200 -21.272  1.00 20.49           C  
ATOM    109  CE2 PHE A  12      20.702 109.420 -23.562  1.00 18.12           C  
ATOM    110  CZ  PHE A  12      21.032 109.229 -22.241  1.00 17.91           C  
ATOM    111  H   PHE A  12      18.627 115.319 -23.942  1.00  0.00           H  
ATOM    112  N   GLU A  13      21.065 113.808 -25.820  1.00 12.46           N  
ATOM    113  CA  GLU A  13      22.059 113.439 -26.793  1.00 14.73           C  
ATOM    114  C   GLU A  13      23.360 114.213 -26.686  1.00 11.68           C  
ATOM    115  O   GLU A  13      24.424 113.618 -26.655  1.00 14.34           O  
ATOM    116  CB  GLU A  13      21.485 113.546 -28.201  1.00 18.72           C  
ATOM    117  CG  GLU A  13      22.378 112.928 -29.245  1.00 24.81           C  
ATOM    118  CD  GLU A  13      21.855 113.122 -30.644  1.00 28.53           C  
ATOM    119  OE1 GLU A  13      20.984 113.989 -30.843  1.00 28.29           O  
ATOM    120  OE2 GLU A  13      22.344 112.411 -31.549  1.00 34.31           O  
ATOM    121  H   GLU A  13      20.204 114.180 -26.101  1.00  0.00           H  
ATOM    122  N   SER A  14      23.295 115.530 -26.581  1.00 12.54           N  
ATOM    123  CA  SER A  14      24.537 116.318 -26.493  1.00 12.39           C  
ATOM    124  C   SER A  14      25.225 116.235 -25.139  1.00 12.81           C  
ATOM    125  O   SER A  14      26.458 116.166 -25.085  1.00 13.89           O  
ATOM    126  CB  SER A  14      24.313 117.781 -26.880  1.00 17.11           C  
ATOM    127  OG  SER A  14      23.267 118.365 -26.115  1.00 22.91           O  
ATOM    128  H   SER A  14      22.439 116.008 -26.539  1.00  0.00           H  
ATOM    129  HG  SER A  14      23.143 119.283 -26.379  1.00  0.00           H  
ATOM    130  N   GLU A  15      24.454 116.203 -24.049  1.00  9.64           N  
ATOM    131  CA  GLU A  15      25.060 116.122 -22.723  1.00  9.22           C  
ATOM    132  C   GLU A  15      25.544 114.722 -22.313  1.00  9.74           C  
ATOM    133  O   GLU A  15      26.498 114.582 -21.542  1.00 10.17           O  
ATOM    134  CB  GLU A  15      24.082 116.638 -21.664  1.00  9.93           C  
ATOM    135  CG  GLU A  15      23.783 118.129 -21.781  1.00 11.60           C  
ATOM    136  CD  GLU A  15      24.995 119.026 -21.496  1.00 12.03           C  
ATOM    137  OE1 GLU A  15      25.922 118.627 -20.768  1.00 13.19           O  
ATOM    138  OE2 GLU A  15      25.014 120.163 -21.992  1.00 14.92           O  
ATOM    139  H   GLU A  15      23.476 116.261 -24.136  1.00  0.00           H  
ATOM    140  N   VAL A  16      24.884 113.677 -22.808  1.00  9.10           N  
ATOM    141  CA  VAL A  16      25.272 112.324 -22.414  1.00  9.01           C  
ATOM    142  C   VAL A  16      25.892 111.443 -23.519  1.00  9.87           C  
ATOM    143  O   VAL A  16      27.072 111.037 -23.423  1.00 11.07           O  
ATOM    144  CB  VAL A  16      24.063 111.595 -21.764  1.00  9.40           C  
ATOM    145  CG1 VAL A  16      24.476 110.201 -21.269  1.00 10.44           C  
ATOM    146  CG2 VAL A  16      23.496 112.454 -20.599  1.00  9.21           C  
ATOM    147  H   VAL A  16      24.139 113.823 -23.426  1.00  0.00           H  
ATOM    148  N   LEU A  17      25.126 111.179 -24.570  1.00  9.39           N  
ATOM    149  CA  LEU A  17      25.613 110.302 -25.626  1.00 12.47           C  
ATOM    150  C   LEU A  17      26.862 110.802 -26.282  1.00 14.06           C  
ATOM    151  O   LEU A  17      27.704 110.013 -26.652  1.00 15.51           O  
ATOM    152  CB  LEU A  17      24.544 110.073 -26.682  1.00 14.25           C  
ATOM    153  CG  LEU A  17      23.333 109.302 -26.163  1.00 18.03           C  
ATOM    154  CD1 LEU A  17      22.435 108.991 -27.336  1.00 19.58           C  
ATOM    155  CD2 LEU A  17      23.774 108.010 -25.479  1.00 18.32           C  
ATOM    156  H   LEU A  17      24.233 111.578 -24.631  1.00  0.00           H  
ATOM    157  N   LYS A  18      26.986 112.112 -26.448  1.00 14.57           N  
ATOM    158  CA  LYS A  18      28.175 112.657 -27.077  1.00 16.74           C  
ATOM    159  C   LYS A  18      29.231 113.177 -26.105  1.00 17.18           C  
ATOM    160  O   LYS A  18      30.171 113.847 -26.517  1.00 18.74           O  
ATOM    161  CB  LYS A  18      27.762 113.736 -28.060  1.00 16.70           C  
ATOM    162  CG  LYS A  18      27.096 113.133 -29.270  1.00 18.90           C  
ATOM    163  CD  LYS A  18      26.356 114.155 -30.040  1.00 22.95           C  
ATOM    164  CE  LYS A  18      25.913 113.556 -31.351  1.00 25.33           C  
ATOM    165  NZ  LYS A  18      24.963 114.489 -32.009  1.00 30.34           N  
ATOM    166  H   LYS A  18      26.273 112.719 -26.147  1.00  0.00           H  
ATOM    167  HZ1 LYS A  18      25.389 115.437 -32.033  1.00  0.00           H  
ATOM    168  HZ2 LYS A  18      24.798 114.173 -32.985  1.00  0.00           H  
ATOM    169  HZ3 LYS A  18      24.062 114.535 -31.494  1.00  0.00           H  
ATOM    170  N   ALA A  19      29.103 112.869 -24.819  1.00 16.63           N  
ATOM    171  CA  ALA A  19      30.086 113.353 -23.851  1.00 16.56           C  
ATOM    172  C   ALA A  19      31.390 112.624 -24.085  1.00 19.07           C  
ATOM    173  O   ALA A  19      31.407 111.498 -24.580  1.00 19.17           O  
ATOM    174  CB  ALA A  19      29.609 113.108 -22.432  1.00 14.46           C  
ATOM    175  H   ALA A  19      28.396 112.272 -24.512  1.00  0.00           H  
ATOM    176  N   GLU A  20      32.486 113.245 -23.683  1.00 21.49           N  
ATOM    177  CA  GLU A  20      33.781 112.625 -23.843  1.00 24.50           C  
ATOM    178  C   GLU A  20      34.081 111.631 -22.731  1.00 24.03           C  
ATOM    179  O   GLU A  20      34.847 110.717 -22.939  1.00 29.32           O  
ATOM    180  CB  GLU A  20      34.876 113.685 -23.879  1.00 30.45           C  
ATOM    181  CG  GLU A  20      35.945 113.437 -24.942  1.00 37.96           C  
ATOM    182  CD  GLU A  20      35.417 113.620 -26.367  1.00 41.23           C  
ATOM    183  OE1 GLU A  20      35.225 114.782 -26.798  1.00 44.80           O  
ATOM    184  OE2 GLU A  20      35.204 112.598 -27.060  1.00 44.80           O  
ATOM    185  H   GLU A  20      32.415 114.127 -23.284  1.00  0.00           H  
ATOM    186  N   GLN A  21      33.496 111.803 -21.554  1.00 21.95           N  
ATOM    187  CA  GLN A  21      33.751 110.897 -20.432  1.00 18.23           C  
ATOM    188  C   GLN A  21      32.554 110.003 -20.103  1.00 17.63           C  
ATOM    189  O   GLN A  21      31.454 110.213 -20.605  1.00 15.03           O  
ATOM    190  CB  GLN A  21      33.992 111.726 -19.165  1.00 21.34           C  
ATOM    191  CG  GLN A  21      35.245 112.566 -19.114  1.00 24.13           C  
ATOM    192  CD  GLN A  21      35.075 113.716 -18.142  1.00 27.18           C  
ATOM    193  OE1 GLN A  21      34.013 114.352 -18.102  1.00 28.70           O  
ATOM    194  NE2 GLN A  21      36.113 114.005 -17.365  1.00 28.54           N  
ATOM    195  H   GLN A  21      32.891 112.549 -21.405  1.00  0.00           H  
ATOM    196 HE21 GLN A  21      35.993 114.737 -16.724  1.00  0.00           H  
ATOM    197 HE22 GLN A  21      36.931 113.477 -17.444  1.00  0.00           H  
ATOM    198  N   PRO A  22      32.770 108.968 -19.263  1.00 16.11           N  
ATOM    199  CA  PRO A  22      31.656 108.100 -18.872  1.00 14.84           C  
ATOM    200  C   PRO A  22      30.677 109.040 -18.102  1.00 12.47           C  
ATOM    201  O   PRO A  22      31.096 110.029 -17.462  1.00 11.29           O  
ATOM    202  CB  PRO A  22      32.307 107.132 -17.863  1.00 16.28           C  
ATOM    203  CG  PRO A  22      33.749 107.101 -18.257  1.00 18.11           C  
ATOM    204  CD  PRO A  22      34.036 108.527 -18.641  1.00 17.26           C  
ATOM    205  N   VAL A  23      29.392 108.716 -18.137  1.00  9.75           N  
ATOM    206  CA  VAL A  23      28.384 109.522 -17.454  1.00  9.76           C  
ATOM    207  C   VAL A  23      27.548 108.673 -16.496  1.00  8.51           C  
ATOM    208  O   VAL A  23      27.078 107.595 -16.868  1.00  9.37           O  
ATOM    209  CB  VAL A  23      27.393 110.184 -18.479  1.00  7.67           C  
ATOM    210  CG1 VAL A  23      26.334 111.029 -17.767  1.00  8.15           C  
ATOM    211  CG2 VAL A  23      28.136 111.045 -19.500  1.00 10.25           C  
ATOM    212  H   VAL A  23      29.106 107.925 -18.622  1.00  0.00           H  
ATOM    213  N   LEU A  24      27.389 109.161 -15.276  1.00  8.01           N  
ATOM    214  CA  LEU A  24      26.511 108.521 -14.296  1.00  9.21           C  
ATOM    215  C   LEU A  24      25.151 109.248 -14.418  1.00  9.26           C  
ATOM    216  O   LEU A  24      25.064 110.456 -14.237  1.00 10.41           O  
ATOM    217  CB  LEU A  24      27.043 108.660 -12.865  1.00  8.37           C  
ATOM    218  CG  LEU A  24      26.122 108.092 -11.775  1.00  9.51           C  
ATOM    219  CD1 LEU A  24      25.957 106.588 -11.966  1.00 10.54           C  
ATOM    220  CD2 LEU A  24      26.699 108.420 -10.389  1.00 10.27           C  
ATOM    221  H   LEU A  24      27.848 109.987 -15.038  1.00  0.00           H  
ATOM    222  N   VAL A  25      24.118 108.527 -14.811  1.00  8.22           N  
ATOM    223  CA  VAL A  25      22.792 109.112 -14.983  1.00  9.09           C  
ATOM    224  C   VAL A  25      21.924 108.669 -13.784  1.00  9.03           C  
ATOM    225  O   VAL A  25      21.761 107.480 -13.538  1.00 10.27           O  
ATOM    226  CB  VAL A  25      22.165 108.638 -16.318  1.00 10.66           C  
ATOM    227  CG1 VAL A  25      20.823 109.350 -16.585  1.00 10.62           C  
ATOM    228  CG2 VAL A  25      23.149 108.876 -17.478  1.00  9.61           C  
ATOM    229  H   VAL A  25      24.240 107.583 -14.986  1.00  0.00           H  
ATOM    230  N   TYR A  26      21.386 109.630 -13.049  1.00  7.07           N  
ATOM    231  CA  TYR A  26      20.568 109.363 -11.884  1.00  7.52           C  
ATOM    232  C   TYR A  26      19.126 109.727 -12.184  1.00  7.09           C  
ATOM    233  O   TYR A  26      18.853 110.854 -12.591  1.00  8.87           O  
ATOM    234  CB  TYR A  26      21.089 110.224 -10.711  1.00  6.91           C  
ATOM    235  CG  TYR A  26      20.153 110.321  -9.520  1.00  8.35           C  
ATOM    236  CD1 TYR A  26      19.598 109.166  -8.936  1.00  9.75           C  
ATOM    237  CD2 TYR A  26      19.872 111.555  -8.937  1.00  9.31           C  
ATOM    238  CE1 TYR A  26      18.789 109.247  -7.792  1.00  9.91           C  
ATOM    239  CE2 TYR A  26      19.066 111.650  -7.780  1.00 11.17           C  
ATOM    240  CZ  TYR A  26      18.530 110.495  -7.225  1.00 10.48           C  
ATOM    241  OH  TYR A  26      17.759 110.586  -6.087  1.00 13.72           O  
ATOM    242  H   TYR A  26      21.543 110.562 -13.307  1.00  0.00           H  
ATOM    243  HH  TYR A  26      17.489 109.702  -5.835  1.00  0.00           H  
ATOM    244  N   PHE A  27      18.211 108.791 -11.986  1.00  6.87           N  
ATOM    245  CA  PHE A  27      16.774 109.048 -12.214  1.00  8.42           C  
ATOM    246  C   PHE A  27      16.061 109.193 -10.886  1.00  8.99           C  
ATOM    247  O   PHE A  27      16.230 108.369  -9.991  1.00 10.58           O  
ATOM    248  CB  PHE A  27      16.129 107.917 -13.006  1.00  9.12           C  
ATOM    249  CG  PHE A  27      16.702 107.744 -14.393  1.00  9.39           C  
ATOM    250  CD1 PHE A  27      17.833 106.954 -14.590  1.00  9.38           C  
ATOM    251  CD2 PHE A  27      16.101 108.355 -15.491  1.00 10.27           C  
ATOM    252  CE1 PHE A  27      18.359 106.758 -15.866  1.00  9.72           C  
ATOM    253  CE2 PHE A  27      16.629 108.164 -16.802  1.00 12.50           C  
ATOM    254  CZ  PHE A  27      17.759 107.362 -16.979  1.00 10.68           C  
ATOM    255  H   PHE A  27      18.487 107.921 -11.661  1.00  0.00           H  
ATOM    256  N   TRP A  28      15.218 110.203 -10.772  1.00  9.81           N  
ATOM    257  CA  TRP A  28      14.508 110.459  -9.526  1.00 10.50           C  
ATOM    258  C   TRP A  28      13.127 111.052  -9.832  1.00  9.90           C  
ATOM    259  O   TRP A  28      12.807 111.313 -10.993  1.00 11.03           O  
ATOM    260  CB  TRP A  28      15.348 111.437  -8.677  1.00  9.84           C  
ATOM    261  CG  TRP A  28      15.467 112.791  -9.304  1.00 13.15           C  
ATOM    262  CD1 TRP A  28      16.225 113.138 -10.395  1.00 13.43           C  
ATOM    263  CD2 TRP A  28      14.722 113.962  -8.957  1.00 16.45           C  
ATOM    264  NE1 TRP A  28      15.986 114.445 -10.758  1.00 16.11           N  
ATOM    265  CE2 TRP A  28      15.063 114.978  -9.891  1.00 18.12           C  
ATOM    266  CE3 TRP A  28      13.785 114.251  -7.951  1.00 16.94           C  
ATOM    267  CZ2 TRP A  28      14.501 116.257  -9.857  1.00 19.56           C  
ATOM    268  CZ3 TRP A  28      13.229 115.528  -7.912  1.00 21.07           C  
ATOM    269  CH2 TRP A  28      13.590 116.517  -8.864  1.00 19.15           C  
ATOM    270  H   TRP A  28      15.049 110.789 -11.537  1.00  0.00           H  
ATOM    271  HE1 TRP A  28      16.440 114.880 -11.503  1.00  0.00           H  
ATOM    272  N   ALA A  29      12.304 111.252  -8.807  1.00 10.34           N  
ATOM    273  CA  ALA A  29      10.977 111.859  -8.967  1.00 12.64           C  
ATOM    274  C   ALA A  29      10.648 112.602  -7.677  1.00 13.51           C  
ATOM    275  O   ALA A  29      11.171 112.274  -6.617  1.00 12.70           O  
ATOM    276  CB  ALA A  29       9.894 110.819  -9.290  1.00 11.72           C  
ATOM    277  H   ALA A  29      12.595 110.993  -7.903  1.00  0.00           H  
ATOM    278  N   SER A  30       9.801 113.615  -7.776  1.00 15.02           N  
ATOM    279  CA  SER A  30       9.451 114.404  -6.606  1.00 17.22           C  
ATOM    280  C   SER A  30       8.629 113.592  -5.622  1.00 16.41           C  
ATOM    281  O   SER A  30       8.662 113.861  -4.425  1.00 19.03           O  
ATOM    282  CB  SER A  30       8.676 115.651  -7.016  1.00 19.38           C  
ATOM    283  OG  SER A  30       7.514 115.284  -7.747  1.00 25.89           O  
ATOM    284  H   SER A  30       9.386 113.855  -8.633  1.00  0.00           H  
ATOM    285  HG  SER A  30       6.987 116.072  -7.939  1.00  0.00           H  
ATOM    286  N   TRP A  31       7.924 112.583  -6.122  1.00 16.51           N  
ATOM    287  CA  TRP A  31       7.099 111.739  -5.280  1.00 15.40           C  
ATOM    288  C   TRP A  31       7.882 110.550  -4.731  1.00 16.18           C  
ATOM    289  O   TRP A  31       7.310 109.624  -4.143  1.00 18.38           O  
ATOM    290  CB  TRP A  31       5.865 111.254  -6.057  1.00 15.46           C  
ATOM    291  CG  TRP A  31       6.133 110.882  -7.468  1.00 15.54           C  
ATOM    292  CD1 TRP A  31       5.920 111.653  -8.576  1.00 15.31           C  
ATOM    293  CD2 TRP A  31       6.711 109.664  -7.938  1.00 16.69           C  
ATOM    294  NE1 TRP A  31       6.338 111.000  -9.697  1.00 13.90           N  
ATOM    295  CE2 TRP A  31       6.834 109.772  -9.336  1.00 15.61           C  
ATOM    296  CE3 TRP A  31       7.157 108.489  -7.299  1.00 15.20           C  
ATOM    297  CZ2 TRP A  31       7.380 108.756 -10.122  1.00 16.21           C  
ATOM    298  CZ3 TRP A  31       7.699 107.485  -8.072  1.00 16.26           C  
ATOM    299  CH2 TRP A  31       7.815 107.619  -9.473  1.00 17.69           C  
ATOM    300  H   TRP A  31       7.953 112.430  -7.081  1.00  0.00           H  
ATOM    301  HE1 TRP A  31       6.292 111.335 -10.622  1.00  0.00           H  
ATOM    302  N   CYS A  32       9.187 110.573  -4.921  1.00 13.65           N  
ATOM    303  CA  CYS A  32      10.028 109.480  -4.473  1.00 13.66           C  
ATOM    304  C   CYS A  32      10.781 109.781  -3.161  1.00 13.89           C  
ATOM    305  O   CYS A  32      11.800 110.468  -3.145  1.00 13.53           O  
ATOM    306  CB  CYS A  32      10.971 109.095  -5.609  1.00 12.38           C  
ATOM    307  SG  CYS A  32      12.349 108.006  -5.169  1.00 11.18           S  
ATOM    308  H   CYS A  32       9.622 111.334  -5.343  1.00  0.00           H  
ATOM    309  N   GLY A  33      10.276 109.227  -2.058  1.00 13.70           N  
ATOM    310  CA  GLY A  33      10.899 109.451  -0.762  1.00 12.42           C  
ATOM    311  C   GLY A  33      12.352 109.029  -0.645  1.00 12.70           C  
ATOM    312  O   GLY A  33      13.228 109.845  -0.292  1.00 14.13           O  
ATOM    313  H   GLY A  33       9.476 108.673  -2.137  1.00  0.00           H  
ATOM    314  N   PRO A  34      12.663 107.770  -0.977  1.00 12.85           N  
ATOM    315  CA  PRO A  34      14.048 107.301  -0.881  1.00 12.05           C  
ATOM    316  C   PRO A  34      15.020 108.113  -1.767  1.00 14.12           C  
ATOM    317  O   PRO A  34      16.251 108.076  -1.571  1.00 14.48           O  
ATOM    318  CB  PRO A  34      13.943 105.840  -1.336  1.00 12.72           C  
ATOM    319  CG  PRO A  34      12.537 105.440  -0.964  1.00 13.56           C  
ATOM    320  CD  PRO A  34      11.751 106.677  -1.367  1.00 12.61           C  
ATOM    321  N   CYS A  35      14.476 108.785  -2.783  1.00 11.27           N  
ATOM    322  CA  CYS A  35      15.292 109.601  -3.672  1.00 12.21           C  
ATOM    323  C   CYS A  35      15.951 110.717  -2.905  1.00 14.05           C  
ATOM    324  O   CYS A  35      17.051 111.143  -3.251  1.00 13.55           O  
ATOM    325  CB  CYS A  35      14.448 110.188  -4.800  1.00 11.49           C  
ATOM    326  SG  CYS A  35      13.959 108.924  -6.014  1.00 11.71           S  
ATOM    327  H   CYS A  35      13.513 108.753  -2.962  1.00  0.00           H  
ATOM    328  N   GLN A  36      15.301 111.145  -1.822  1.00 15.49           N  
ATOM    329  CA  GLN A  36      15.839 112.214  -0.977  1.00 18.52           C  
ATOM    330  C   GLN A  36      17.157 111.813  -0.306  1.00 18.26           C  
ATOM    331  O   GLN A  36      18.024 112.661  -0.058  1.00 19.14           O  
ATOM    332  CB  GLN A  36      14.818 112.621   0.067  1.00 21.72           C  
ATOM    333  CG  GLN A  36      13.617 113.293  -0.512  1.00 30.66           C  
ATOM    334  CD  GLN A  36      12.842 114.024   0.569  1.00 39.29           C  
ATOM    335  OE1 GLN A  36      13.418 114.790   1.369  1.00 45.28           O  
ATOM    336  NE2 GLN A  36      11.541 113.777   0.632  1.00 41.56           N  
ATOM    337  H   GLN A  36      14.436 110.748  -1.588  1.00  0.00           H  
ATOM    338 HE21 GLN A  36      11.127 114.292   1.363  1.00  0.00           H  
ATOM    339 HE22 GLN A  36      11.101 113.156   0.030  1.00  0.00           H  
ATOM    340  N   LEU A  37      17.307 110.521  -0.019  1.00 17.57           N  
ATOM    341  CA  LEU A  37      18.527 110.004   0.578  1.00 17.78           C  
ATOM    342  C   LEU A  37      19.648 109.932  -0.466  1.00 17.21           C  
ATOM    343  O   LEU A  37      20.809 110.156  -0.156  1.00 17.04           O  
ATOM    344  CB  LEU A  37      18.268 108.608   1.145  1.00 19.21           C  
ATOM    345  CG  LEU A  37      17.104 108.538   2.130  1.00 23.43           C  
ATOM    346  CD1 LEU A  37      16.879 107.101   2.602  1.00 22.85           C  
ATOM    347  CD2 LEU A  37      17.413 109.432   3.314  1.00 24.08           C  
ATOM    348  H   LEU A  37      16.573 109.906  -0.206  1.00  0.00           H  
ATOM    349  N   MET A  38      19.293 109.630  -1.708  1.00 15.23           N  
ATOM    350  CA  MET A  38      20.289 109.523  -2.769  1.00 16.52           C  
ATOM    351  C   MET A  38      20.805 110.829  -3.332  1.00 16.45           C  
ATOM    352  O   MET A  38      21.975 110.922  -3.657  1.00 18.31           O  
ATOM    353  CB  MET A  38      19.759 108.692  -3.935  1.00 18.33           C  
ATOM    354  CG  MET A  38      19.728 107.219  -3.681  1.00 23.34           C  
ATOM    355  SD  MET A  38      21.380 106.544  -3.482  1.00 28.89           S  
ATOM    356  CE  MET A  38      21.856 106.322  -5.200  1.00 28.63           C  
ATOM    357  H   MET A  38      18.350 109.462  -1.901  1.00  0.00           H  
ATOM    358  N   SER A  39      19.952 111.825  -3.501  1.00 15.64           N  
ATOM    359  CA  SER A  39      20.406 113.083  -4.076  1.00 16.14           C  
ATOM    360  C   SER A  39      21.735 113.626  -3.494  1.00 17.43           C  
ATOM    361  O   SER A  39      22.642 114.001  -4.245  1.00 16.87           O  
ATOM    362  CB  SER A  39      19.307 114.117  -4.001  1.00 16.18           C  
ATOM    363  OG  SER A  39      19.684 115.269  -4.720  1.00 22.82           O  
ATOM    364  H   SER A  39      19.010 111.710  -3.262  1.00  0.00           H  
ATOM    365  HG  SER A  39      19.030 115.955  -4.600  1.00  0.00           H  
ATOM    366  N   PRO A  40      21.873 113.686  -2.157  1.00 17.63           N  
ATOM    367  CA  PRO A  40      23.112 114.179  -1.529  1.00 18.31           C  
ATOM    368  C   PRO A  40      24.323 113.331  -1.916  1.00 18.39           C  
ATOM    369  O   PRO A  40      25.415 113.834  -2.154  1.00 18.33           O  
ATOM    370  CB  PRO A  40      22.823 113.995  -0.045  1.00 17.82           C  
ATOM    371  CG  PRO A  40      21.373 114.204   0.032  1.00 18.59           C  
ATOM    372  CD  PRO A  40      20.841 113.457  -1.135  1.00 18.02           C  
ATOM    373  N   LEU A  41      24.123 112.025  -1.942  1.00 18.10           N  
ATOM    374  CA  LEU A  41      25.175 111.074  -2.279  1.00 17.63           C  
ATOM    375  C   LEU A  41      25.642 111.201  -3.724  1.00 16.06           C  
ATOM    376  O   LEU A  41      26.804 110.997  -4.017  1.00 14.76           O  
ATOM    377  CB  LEU A  41      24.624 109.677  -2.052  1.00 21.54           C  
ATOM    378  CG  LEU A  41      25.575 108.563  -1.740  1.00 26.96           C  
ATOM    379  CD1 LEU A  41      26.586 109.070  -0.686  1.00 28.54           C  
ATOM    380  CD2 LEU A  41      24.718 107.363  -1.210  1.00 27.50           C  
ATOM    381  H   LEU A  41      23.233 111.668  -1.734  1.00  0.00           H  
ATOM    382  N   ILE A  42      24.707 111.433  -4.638  1.00 12.73           N  
ATOM    383  CA  ILE A  42      25.052 111.584  -6.038  1.00 14.32           C  
ATOM    384  C   ILE A  42      25.916 112.837  -6.188  1.00 15.10           C  
ATOM    385  O   ILE A  42      26.894 112.866  -6.948  1.00 15.07           O  
ATOM    386  CB  ILE A  42      23.797 111.739  -6.890  1.00 12.33           C  
ATOM    387  CG1 ILE A  42      23.002 110.441  -6.834  1.00 14.79           C  
ATOM    388  CG2 ILE A  42      24.153 112.095  -8.307  1.00 13.08           C  
ATOM    389  CD1 ILE A  42      23.807 109.201  -7.093  1.00 15.62           C  
ATOM    390  H   ILE A  42      23.765 111.497  -4.361  1.00  0.00           H  
ATOM    391  N   ASN A  43      25.570 113.869  -5.432  1.00 16.27           N  
ATOM    392  CA  ASN A  43      26.312 115.128  -5.476  1.00 16.86           C  
ATOM    393  C   ASN A  43      27.758 114.856  -4.997  1.00 15.91           C  
ATOM    394  O   ASN A  43      28.719 115.311  -5.614  1.00 14.94           O  
ATOM    395  CB  ASN A  43      25.581 116.143  -4.599  1.00 18.44           C  
ATOM    396  CG  ASN A  43      25.893 117.560  -4.966  1.00 23.83           C  
ATOM    397  OD1 ASN A  43      26.261 117.885  -6.107  1.00 25.90           O  
ATOM    398  ND2 ASN A  43      25.727 118.440  -3.998  1.00 27.26           N  
ATOM    399  H   ASN A  43      24.769 113.795  -4.857  1.00  0.00           H  
ATOM    400 HD21 ASN A  43      25.924 119.373  -4.236  1.00  0.00           H  
ATOM    401 HD22 ASN A  43      25.428 118.127  -3.130  1.00  0.00           H  
ATOM    402  N   LEU A  44      27.897 114.049  -3.943  1.00 14.85           N  
ATOM    403  CA  LEU A  44      29.219 113.659  -3.404  1.00 17.84           C  
ATOM    404  C   LEU A  44      30.079 112.935  -4.443  1.00 17.09           C  
ATOM    405  O   LEU A  44      31.291 113.165  -4.534  1.00 18.13           O  
ATOM    406  CB  LEU A  44      29.070 112.737  -2.181  1.00 21.07           C  
ATOM    407  CG  LEU A  44      30.297 111.973  -1.641  1.00 23.52           C  
ATOM    408  CD1 LEU A  44      30.173 111.920  -0.158  1.00 26.93           C  
ATOM    409  CD2 LEU A  44      30.395 110.542  -2.178  1.00 24.58           C  
ATOM    410  H   LEU A  44      27.084 113.730  -3.506  1.00  0.00           H  
ATOM    411  N   ALA A  45      29.481 111.964  -5.122  1.00 14.95           N  
ATOM    412  CA  ALA A  45      30.182 111.221  -6.158  1.00 16.41           C  
ATOM    413  C   ALA A  45      30.697 112.194  -7.249  1.00 17.92           C  
ATOM    414  O   ALA A  45      31.834 112.057  -7.750  1.00 17.47           O  
ATOM    415  CB  ALA A  45      29.240 110.205  -6.792  1.00 16.28           C  
ATOM    416  H   ALA A  45      28.542 111.754  -4.921  1.00  0.00           H  
ATOM    417  N   ALA A  46      29.851 113.157  -7.637  1.00 17.20           N  
ATOM    418  CA  ALA A  46      30.224 114.118  -8.673  1.00 16.96           C  
ATOM    419  C   ALA A  46      31.471 114.893  -8.262  1.00 18.05           C  
ATOM    420  O   ALA A  46      32.421 115.020  -9.039  1.00 17.28           O  
ATOM    421  CB  ALA A  46      29.074 115.080  -8.933  1.00 18.14           C  
ATOM    422  H   ALA A  46      28.959 113.229  -7.223  1.00  0.00           H  
ATOM    423  N   ASN A  47      31.478 115.384  -7.029  1.00 18.62           N  
ATOM    424  CA  ASN A  47      32.632 116.147  -6.548  1.00 20.74           C  
ATOM    425  C   ASN A  47      33.860 115.234  -6.468  1.00 20.03           C  
ATOM    426  O   ASN A  47      34.925 115.579  -6.933  1.00 22.50           O  
ATOM    427  CB  ASN A  47      32.362 116.782  -5.175  1.00 23.02           C  
ATOM    428  CG  ASN A  47      31.231 117.810  -5.204  1.00 26.35           C  
ATOM    429  OD1 ASN A  47      30.328 117.761  -4.368  1.00 32.86           O  
ATOM    430  ND2 ASN A  47      31.273 118.733  -6.142  1.00 28.05           N  
ATOM    431  H   ASN A  47      30.694 115.265  -6.445  1.00  0.00           H  
ATOM    432 HD21 ASN A  47      30.520 119.338  -6.157  1.00  0.00           H  
ATOM    433 HD22 ASN A  47      32.020 118.748  -6.771  1.00  0.00           H  
ATOM    434  N   THR A  48      33.679 114.041  -5.938  1.00 19.07           N  
ATOM    435  CA  THR A  48      34.768 113.094  -5.795  1.00 19.24           C  
ATOM    436  C   THR A  48      35.436 112.639  -7.098  1.00 20.15           C  
ATOM    437  O   THR A  48      36.661 112.449  -7.148  1.00 20.69           O  
ATOM    438  CB  THR A  48      34.274 111.890  -5.005  1.00 21.11           C  
ATOM    439  OG1 THR A  48      33.948 112.318  -3.675  1.00 25.18           O  
ATOM    440  CG2 THR A  48      35.293 110.772  -4.965  1.00 22.35           C  
ATOM    441  H   THR A  48      32.785 113.778  -5.611  1.00  0.00           H  
ATOM    442  HG1 THR A  48      33.666 111.532  -3.208  1.00  0.00           H  
ATOM    443  N   TYR A  49      34.653 112.401  -8.140  1.00 17.52           N  
ATOM    444  CA  TYR A  49      35.239 111.965  -9.400  1.00 18.42           C  
ATOM    445  C   TYR A  49      35.177 113.075 -10.426  1.00 18.97           C  
ATOM    446  O   TYR A  49      35.150 112.796 -11.622  1.00 16.80           O  
ATOM    447  CB  TYR A  49      34.484 110.743  -9.930  1.00 19.06           C  
ATOM    448  CG  TYR A  49      34.596 109.546  -9.033  1.00 21.27           C  
ATOM    449  CD1 TYR A  49      35.658 108.653  -9.161  1.00 25.40           C  
ATOM    450  CD2 TYR A  49      33.652 109.310  -8.040  1.00 23.54           C  
ATOM    451  CE1 TYR A  49      35.777 107.542  -8.319  1.00 25.72           C  
ATOM    452  CE2 TYR A  49      33.752 108.214  -7.205  1.00 25.09           C  
ATOM    453  CZ  TYR A  49      34.817 107.328  -7.350  1.00 26.47           C  
ATOM    454  OH  TYR A  49      34.872 106.193  -6.567  1.00 28.22           O  
ATOM    455  H   TYR A  49      33.680 112.527  -8.072  1.00  0.00           H  
ATOM    456  HH  TYR A  49      35.687 105.750  -6.703  1.00  0.00           H  
ATOM    457  N   SER A  50      35.215 114.328  -9.968  1.00 19.76           N  
ATOM    458  CA  SER A  50      35.082 115.465 -10.880  1.00 21.74           C  
ATOM    459  C   SER A  50      35.932 115.435 -12.138  1.00 21.17           C  
ATOM    460  O   SER A  50      35.476 115.858 -13.190  1.00 22.84           O  
ATOM    461  CB  SER A  50      35.233 116.808 -10.151  1.00 22.00           C  
ATOM    462  OG  SER A  50      36.526 116.938  -9.579  1.00 28.84           O  
ATOM    463  H   SER A  50      35.324 114.520  -9.008  1.00  0.00           H  
ATOM    464  HG  SER A  50      36.529 117.759  -9.080  1.00  0.00           H  
ATOM    465  N   ASP A  51      37.144 114.910 -12.063  1.00 20.74           N  
ATOM    466  CA  ASP A  51      37.973 114.887 -13.256  1.00 24.07           C  
ATOM    467  C   ASP A  51      37.829 113.661 -14.172  1.00 24.07           C  
ATOM    468  O   ASP A  51      38.418 113.645 -15.261  1.00 24.73           O  
ATOM    469  CB  ASP A  51      39.449 115.047 -12.885  1.00 26.61           C  
ATOM    470  CG  ASP A  51      39.752 116.380 -12.218  1.00 32.51           C  
ATOM    471  OD1 ASP A  51      39.013 117.367 -12.430  1.00 33.26           O  
ATOM    472  OD2 ASP A  51      40.753 116.436 -11.464  1.00 37.84           O  
ATOM    473  H   ASP A  51      37.469 114.553 -11.215  1.00  0.00           H  
ATOM    474  N   ARG A  52      37.055 112.656 -13.772  1.00 21.31           N  
ATOM    475  CA  ARG A  52      36.951 111.444 -14.585  1.00 21.92           C  
ATOM    476  C   ARG A  52      35.546 111.010 -14.928  1.00 19.88           C  
ATOM    477  O   ARG A  52      35.367 110.044 -15.660  1.00 19.30           O  
ATOM    478  CB  ARG A  52      37.583 110.245 -13.859  1.00 26.68           C  
ATOM    479  CG  ARG A  52      38.661 110.596 -12.841  1.00 35.01           C  
ATOM    480  CD  ARG A  52      39.685 109.461 -12.671  1.00 40.81           C  
ATOM    481  NE  ARG A  52      39.284 108.361 -11.788  1.00 45.70           N  
ATOM    482  CZ  ARG A  52      39.007 108.499 -10.492  1.00 48.89           C  
ATOM    483  NH1 ARG A  52      39.059 109.705  -9.909  1.00 49.89           N  
ATOM    484  NH2 ARG A  52      38.805 107.414  -9.744  1.00 50.35           N  
ATOM    485  H   ARG A  52      36.562 112.723 -12.939  1.00  0.00           H  
ATOM    486  HE  ARG A  52      39.271 107.445 -12.134  1.00  0.00           H  
ATOM    487 HH11 ARG A  52      39.322 110.511 -10.439  1.00  0.00           H  
ATOM    488 HH12 ARG A  52      38.878 109.815  -8.932  1.00  0.00           H  
ATOM    489 HH21 ARG A  52      38.881 106.494 -10.120  1.00  0.00           H  
ATOM    490 HH22 ARG A  52      38.635 107.544  -8.763  1.00  0.00           H  
ATOM    491  N   LEU A  53      34.558 111.754 -14.459  1.00 17.22           N  
ATOM    492  CA  LEU A  53      33.172 111.358 -14.632  1.00 13.72           C  
ATOM    493  C   LEU A  53      32.268 112.558 -14.737  1.00 11.99           C  
ATOM    494  O   LEU A  53      32.509 113.575 -14.087  1.00 13.53           O  
ATOM    495  CB  LEU A  53      32.765 110.584 -13.350  1.00 13.71           C  
ATOM    496  CG  LEU A  53      31.343 110.030 -13.197  1.00 13.74           C  
ATOM    497  CD1 LEU A  53      31.167 108.848 -14.162  1.00 12.59           C  
ATOM    498  CD2 LEU A  53      31.094 109.612 -11.756  1.00 12.54           C  
ATOM    499  H   LEU A  53      34.719 112.595 -13.981  1.00  0.00           H  
ATOM    500  N   LYS A  54      31.206 112.431 -15.522  1.00  9.18           N  
ATOM    501  CA  LYS A  54      30.205 113.492 -15.628  1.00  8.61           C  
ATOM    502  C   LYS A  54      28.953 112.917 -14.961  1.00  8.68           C  
ATOM    503  O   LYS A  54      28.599 111.750 -15.192  1.00 10.38           O  
ATOM    504  CB  LYS A  54      29.925 113.851 -17.089  1.00  9.82           C  
ATOM    505  CG  LYS A  54      28.855 114.905 -17.304  1.00  8.60           C  
ATOM    506  CD  LYS A  54      28.719 115.219 -18.780  1.00 10.66           C  
ATOM    507  CE  LYS A  54      27.754 116.355 -19.039  1.00 11.80           C  
ATOM    508  NZ  LYS A  54      27.810 116.795 -20.473  1.00 11.54           N  
ATOM    509  H   LYS A  54      31.065 111.597 -16.033  1.00  0.00           H  
ATOM    510  HZ1 LYS A  54      27.795 115.952 -21.066  1.00  0.00           H  
ATOM    511  HZ2 LYS A  54      27.022 117.366 -20.738  1.00  0.00           H  
ATOM    512  HZ3 LYS A  54      28.695 117.298 -20.646  1.00  0.00           H  
ATOM    513  N   VAL A  55      28.308 113.706 -14.109  1.00  8.61           N  
ATOM    514  CA  VAL A  55      27.109 113.249 -13.426  1.00  9.31           C  
ATOM    515  C   VAL A  55      25.880 114.107 -13.799  1.00 10.76           C  
ATOM    516  O   VAL A  55      25.890 115.339 -13.683  1.00 10.06           O  
ATOM    517  CB  VAL A  55      27.288 113.207 -11.862  1.00 10.29           C  
ATOM    518  CG1 VAL A  55      26.048 112.614 -11.242  1.00  9.14           C  
ATOM    519  CG2 VAL A  55      28.496 112.344 -11.455  1.00  7.74           C  
ATOM    520  H   VAL A  55      28.636 114.618 -13.945  1.00  0.00           H  
ATOM    521  N   VAL A  56      24.820 113.446 -14.255  1.00  9.98           N  
ATOM    522  CA  VAL A  56      23.614 114.166 -14.638  1.00 10.04           C  
ATOM    523  C   VAL A  56      22.414 113.507 -13.974  1.00  9.58           C  
ATOM    524  O   VAL A  56      22.488 112.360 -13.536  1.00  8.43           O  
ATOM    525  CB  VAL A  56      23.363 114.137 -16.175  1.00 10.83           C  
ATOM    526  CG1 VAL A  56      24.604 114.590 -16.932  1.00 10.45           C  
ATOM    527  CG2 VAL A  56      22.928 112.726 -16.632  1.00 10.01           C  
ATOM    528  H   VAL A  56      24.822 112.454 -14.302  1.00  0.00           H  
ATOM    529  N   LYS A  57      21.328 114.262 -13.870  1.00  8.92           N  
ATOM    530  CA  LYS A  57      20.120 113.724 -13.289  1.00  8.63           C  
ATOM    531  C   LYS A  57      18.885 114.157 -14.063  1.00  9.64           C  
ATOM    532  O   LYS A  57      18.880 115.208 -14.705  1.00  9.59           O  
ATOM    533  CB  LYS A  57      20.010 114.038 -11.794  1.00 10.43           C  
ATOM    534  CG  LYS A  57      19.776 115.458 -11.398  1.00 13.03           C  
ATOM    535  CD  LYS A  57      19.741 115.445  -9.882  1.00 16.63           C  
ATOM    536  CE  LYS A  57      19.380 116.735  -9.246  1.00 19.83           C  
ATOM    537  NZ  LYS A  57      19.244 116.424  -7.775  1.00 19.93           N  
ATOM    538  H   LYS A  57      21.314 115.185 -14.208  1.00  0.00           H  
ATOM    539  HZ1 LYS A  57      20.084 115.908  -7.452  1.00  0.00           H  
ATOM    540  HZ2 LYS A  57      19.174 117.336  -7.287  1.00  0.00           H  
ATOM    541  HZ3 LYS A  57      18.382 115.872  -7.593  1.00  0.00           H  
ATOM    542  N   LEU A  58      17.908 113.253 -14.123  1.00 12.25           N  
ATOM    543  CA  LEU A  58      16.650 113.478 -14.824  1.00 11.64           C  
ATOM    544  C   LEU A  58      15.488 113.065 -13.950  1.00 12.06           C  
ATOM    545  O   LEU A  58      15.496 111.979 -13.355  1.00 11.51           O  
ATOM    546  CB  LEU A  58      16.543 112.601 -16.065  1.00 16.74           C  
ATOM    547  CG  LEU A  58      17.272 112.994 -17.328  1.00 21.50           C  
ATOM    548  CD1 LEU A  58      18.540 112.120 -17.433  1.00 23.50           C  
ATOM    549  CD2 LEU A  58      16.368 112.764 -18.499  1.00 18.45           C  
ATOM    550  H   LEU A  58      18.031 112.385 -13.686  1.00  0.00           H  
ATOM    551  N   GLU A  59      14.465 113.909 -13.955  1.00 11.33           N  
ATOM    552  CA  GLU A  59      13.221 113.663 -13.256  1.00 12.07           C  
ATOM    553  C   GLU A  59      12.461 112.764 -14.234  1.00 12.22           C  
ATOM    554  O   GLU A  59      12.448 113.018 -15.448  1.00 11.70           O  
ATOM    555  CB  GLU A  59      12.500 114.984 -13.117  1.00 13.97           C  
ATOM    556  CG  GLU A  59      11.351 114.970 -12.187  1.00 20.41           C  
ATOM    557  CD  GLU A  59      10.828 116.373 -11.940  1.00 25.67           C  
ATOM    558  OE1 GLU A  59      11.355 117.359 -12.542  1.00 26.73           O  
ATOM    559  OE2 GLU A  59       9.885 116.490 -11.134  1.00 29.86           O  
ATOM    560  H   GLU A  59      14.555 114.722 -14.481  1.00  0.00           H  
ATOM    561  N   ILE A  60      11.805 111.725 -13.746  1.00 12.36           N  
ATOM    562  CA  ILE A  60      11.130 110.847 -14.700  1.00 13.41           C  
ATOM    563  C   ILE A  60       9.871 111.386 -15.355  1.00 12.38           C  
ATOM    564  O   ILE A  60       9.672 111.211 -16.548  1.00 12.59           O  
ATOM    565  CB  ILE A  60      10.848 109.368 -14.175  1.00 16.83           C  
ATOM    566  CG1 ILE A  60       9.855 109.362 -13.022  1.00 17.63           C  
ATOM    567  CG2 ILE A  60      12.154 108.634 -13.823  1.00 14.56           C  
ATOM    568  CD1 ILE A  60       9.358 107.973 -12.701  1.00 22.38           C  
ATOM    569  H   ILE A  60      11.826 111.531 -12.780  1.00  0.00           H  
ATOM    570  N   ASP A  61       9.071 112.126 -14.610  1.00 12.72           N  
ATOM    571  CA  ASP A  61       7.814 112.597 -15.166  1.00 13.55           C  
ATOM    572  C   ASP A  61       7.849 113.373 -16.495  1.00 12.33           C  
ATOM    573  O   ASP A  61       7.162 113.003 -17.439  1.00 13.18           O  
ATOM    574  CB  ASP A  61       6.995 113.338 -14.099  0.50 13.03           C  
ATOM    575  CG  ASP A  61       6.552 112.424 -12.946  0.50 14.49           C  
ATOM    576  OD1 ASP A  61       6.784 111.200 -12.982  0.50 17.24           O  
ATOM    577  OD2 ASP A  61       5.949 112.941 -11.995  0.50 16.44           O  
ATOM    578  H   ASP A  61       9.333 112.334 -13.688  1.00  0.00           H  
ATOM    579  N   PRO A  62       8.707 114.397 -16.607  1.00 12.14           N  
ATOM    580  CA  PRO A  62       8.791 115.201 -17.834  1.00 12.28           C  
ATOM    581  C   PRO A  62       9.694 114.647 -18.926  1.00 12.31           C  
ATOM    582  O   PRO A  62       9.830 115.263 -19.996  1.00 13.29           O  
ATOM    583  CB  PRO A  62       9.398 116.518 -17.329  1.00 13.85           C  
ATOM    584  CG  PRO A  62       9.649 116.333 -15.862  1.00 13.19           C  
ATOM    585  CD  PRO A  62       9.668 114.887 -15.612  1.00 12.42           C  
ATOM    586  N   ASN A  63      10.285 113.485 -18.684  1.00  9.46           N  
ATOM    587  CA  ASN A  63      11.237 112.943 -19.638  1.00  9.76           C  
ATOM    588  C   ASN A  63      10.937 111.516 -20.046  1.00 11.09           C  
ATOM    589  O   ASN A  63      11.801 110.630 -19.901  1.00 10.48           O  
ATOM    590  CB  ASN A  63      12.624 113.049 -19.016  1.00  9.44           C  
ATOM    591  CG  ASN A  63      13.002 114.487 -18.734  1.00 11.38           C  
ATOM    592  OD1 ASN A  63      13.101 115.315 -19.656  1.00 11.86           O  
ATOM    593  ND2 ASN A  63      13.137 114.819 -17.460  1.00 10.24           N  
ATOM    594  H   ASN A  63      10.079 112.956 -17.876  1.00  0.00           H  
ATOM    595 HD21 ASN A  63      13.379 115.744 -17.261  1.00  0.00           H  
ATOM    596 HD22 ASN A  63      12.992 114.107 -16.815  1.00  0.00           H  
ATOM    597  N   PRO A  64       9.793 111.306 -20.737  1.00 11.63           N  
ATOM    598  CA  PRO A  64       9.390 109.955 -21.170  1.00 11.93           C  
ATOM    599  C   PRO A  64      10.336 109.198 -22.095  1.00 10.34           C  
ATOM    600  O   PRO A  64      10.480 107.979 -21.957  1.00 10.50           O  
ATOM    601  CB  PRO A  64       8.006 110.192 -21.792  1.00 12.57           C  
ATOM    602  CG  PRO A  64       8.150 111.574 -22.385  1.00 13.73           C  
ATOM    603  CD  PRO A  64       8.862 112.326 -21.277  1.00 12.63           C  
ATOM    604  N   THR A  65      11.036 109.919 -22.972  1.00  9.37           N  
ATOM    605  CA  THR A  65      11.926 109.279 -23.920  1.00 10.74           C  
ATOM    606  C   THR A  65      13.166 108.625 -23.317  1.00 10.49           C  
ATOM    607  O   THR A  65      13.469 107.457 -23.605  1.00 11.32           O  
ATOM    608  CB  THR A  65      12.309 110.253 -25.049  1.00 12.69           C  
ATOM    609  OG1 THR A  65      11.104 110.689 -25.696  1.00 13.78           O  
ATOM    610  CG2 THR A  65      13.189 109.569 -26.070  1.00 11.26           C  
ATOM    611  H   THR A  65      10.932 110.884 -23.001  1.00  0.00           H  
ATOM    612  HG1 THR A  65      11.319 111.296 -26.408  1.00  0.00           H  
ATOM    613  N   THR A  66      13.859 109.339 -22.442  1.00  9.16           N  
ATOM    614  CA  THR A  66      15.053 108.789 -21.834  1.00  9.55           C  
ATOM    615  C   THR A  66      14.706 107.664 -20.864  1.00 10.03           C  
ATOM    616  O   THR A  66      15.406 106.648 -20.793  1.00 10.41           O  
ATOM    617  CB  THR A  66      15.831 109.888 -21.116  1.00 10.56           C  
ATOM    618  OG1 THR A  66      16.075 110.961 -22.040  1.00 12.21           O  
ATOM    619  CG2 THR A  66      17.166 109.354 -20.638  1.00 12.60           C  
ATOM    620  H   THR A  66      13.594 110.239 -22.194  1.00  0.00           H  
ATOM    621  HG1 THR A  66      16.571 111.642 -21.581  1.00  0.00           H  
ATOM    622  N   VAL A  67      13.574 107.825 -20.179  1.00  9.94           N  
ATOM    623  CA  VAL A  67      13.074 106.855 -19.200  1.00  9.80           C  
ATOM    624  C   VAL A  67      12.811 105.528 -19.922  1.00 11.37           C  
ATOM    625  O   VAL A  67      13.202 104.464 -19.438  1.00 11.52           O  
ATOM    626  CB  VAL A  67      11.806 107.429 -18.505  1.00  9.83           C  
ATOM    627  CG1 VAL A  67      11.031 106.364 -17.793  1.00 12.00           C  
ATOM    628  CG2 VAL A  67      12.223 108.524 -17.509  1.00  9.91           C  
ATOM    629  H   VAL A  67      13.050 108.644 -20.311  1.00  0.00           H  
ATOM    630  N   LYS A  68      12.165 105.604 -21.087  1.00 12.33           N  
ATOM    631  CA  LYS A  68      11.878 104.417 -21.889  1.00 14.63           C  
ATOM    632  C   LYS A  68      13.167 103.800 -22.406  1.00 14.30           C  
ATOM    633  O   LYS A  68      13.352 102.591 -22.298  1.00 15.70           O  
ATOM    634  CB  LYS A  68      10.968 104.752 -23.079  1.00 16.84           C  
ATOM    635  CG  LYS A  68       9.553 105.166 -22.695  1.00 24.98           C  
ATOM    636  CD  LYS A  68       8.588 105.228 -23.909  1.00 29.24           C  
ATOM    637  CE  LYS A  68       8.393 103.826 -24.482  1.00 30.12           C  
ATOM    638  NZ  LYS A  68       7.123 103.617 -25.214  1.00 32.38           N  
ATOM    639  H   LYS A  68      11.858 106.477 -21.417  1.00  0.00           H  
ATOM    640  HZ1 LYS A  68       7.071 104.378 -25.924  1.00  0.00           H  
ATOM    641  HZ2 LYS A  68       7.150 102.700 -25.705  1.00  0.00           H  
ATOM    642  HZ3 LYS A  68       6.294 103.686 -24.591  1.00  0.00           H  
ATOM    643  N   LYS A  69      14.074 104.636 -22.911  1.00 14.61           N  
ATOM    644  CA  LYS A  69      15.354 104.185 -23.467  1.00 14.20           C  
ATOM    645  C   LYS A  69      16.156 103.324 -22.492  1.00 14.84           C  
ATOM    646  O   LYS A  69      16.801 102.352 -22.893  1.00 14.95           O  
ATOM    647  CB  LYS A  69      16.212 105.390 -23.885  1.00 15.59           C  
ATOM    648  CG  LYS A  69      17.528 105.011 -24.543  1.00 18.94           C  
ATOM    649  CD  LYS A  69      18.445 106.209 -24.632  1.00 24.81           C  
ATOM    650  CE  LYS A  69      19.851 105.846 -25.161  1.00 29.13           C  
ATOM    651  NZ  LYS A  69      19.789 105.258 -26.528  1.00 31.76           N  
ATOM    652  H   LYS A  69      13.852 105.585 -22.940  1.00  0.00           H  
ATOM    653  HZ1 LYS A  69      19.133 105.841 -27.086  1.00  0.00           H  
ATOM    654  HZ2 LYS A  69      20.707 105.241 -26.996  1.00  0.00           H  
ATOM    655  HZ3 LYS A  69      19.363 104.315 -26.469  1.00  0.00           H  
ATOM    656  N   TYR A  70      16.139 103.699 -21.213  1.00 13.14           N  
ATOM    657  CA  TYR A  70      16.894 102.959 -20.213  1.00 13.44           C  
ATOM    658  C   TYR A  70      16.080 101.998 -19.370  1.00 13.55           C  
ATOM    659  O   TYR A  70      16.578 101.464 -18.377  1.00 13.62           O  
ATOM    660  CB  TYR A  70      17.698 103.923 -19.335  1.00 13.82           C  
ATOM    661  CG  TYR A  70      18.789 104.553 -20.131  1.00 15.89           C  
ATOM    662  CD1 TYR A  70      19.931 103.812 -20.496  1.00 16.28           C  
ATOM    663  CD2 TYR A  70      18.679 105.867 -20.567  1.00 17.61           C  
ATOM    664  CE1 TYR A  70      20.935 104.369 -21.272  1.00 15.62           C  
ATOM    665  CE2 TYR A  70      19.679 106.432 -21.352  1.00 21.54           C  
ATOM    666  CZ  TYR A  70      20.812 105.678 -21.693  1.00 20.43           C  
ATOM    667  OH  TYR A  70      21.837 106.276 -22.402  1.00 21.96           O  
ATOM    668  H   TYR A  70      15.615 104.479 -20.946  1.00  0.00           H  
ATOM    669  HH  TYR A  70      21.605 107.160 -22.663  1.00  0.00           H  
ATOM    670  N   LYS A  71      14.844 101.761 -19.782  1.00 14.81           N  
ATOM    671  CA  LYS A  71      13.968 100.855 -19.055  1.00 17.34           C  
ATOM    672  C   LYS A  71      13.944 101.168 -17.567  1.00 14.97           C  
ATOM    673  O   LYS A  71      14.110 100.287 -16.705  1.00 14.36           O  
ATOM    674  CB  LYS A  71      14.376  99.395 -19.310  1.00 20.95           C  
ATOM    675  CG  LYS A  71      13.777  98.825 -20.588  1.00 27.48           C  
ATOM    676  CD  LYS A  71      14.123  97.353 -20.746  1.00 34.83           C  
ATOM    677  CE  LYS A  71      13.801  96.556 -19.463  1.00 40.03           C  
ATOM    678  NZ  LYS A  71      13.681  95.043 -19.634  1.00 45.30           N  
ATOM    679  H   LYS A  71      14.503 102.185 -20.599  1.00  0.00           H  
ATOM    680  HZ1 LYS A  71      14.500  94.699 -20.175  1.00  0.00           H  
ATOM    681  HZ2 LYS A  71      13.652  94.558 -18.714  1.00  0.00           H  
ATOM    682  HZ3 LYS A  71      12.816  94.813 -20.166  1.00  0.00           H  
ATOM    683  N   VAL A  72      13.735 102.442 -17.268  1.00 13.44           N  
ATOM    684  CA  VAL A  72      13.658 102.864 -15.882  1.00 14.33           C  
ATOM    685  C   VAL A  72      12.230 102.579 -15.418  1.00 15.67           C  
ATOM    686  O   VAL A  72      11.278 103.300 -15.782  1.00 15.81           O  
ATOM    687  CB  VAL A  72      14.025 104.350 -15.743  1.00 14.51           C  
ATOM    688  CG1 VAL A  72      13.758 104.845 -14.308  1.00 13.02           C  
ATOM    689  CG2 VAL A  72      15.487 104.525 -16.100  1.00 13.41           C  
ATOM    690  H   VAL A  72      13.620 103.095 -17.993  1.00  0.00           H  
ATOM    691  N   GLU A  73      12.072 101.496 -14.662  1.00 13.99           N  
ATOM    692  CA  GLU A  73      10.748 101.127 -14.191  1.00 15.03           C  
ATOM    693  C   GLU A  73      10.636 101.208 -12.682  1.00 15.13           C  
ATOM    694  O   GLU A  73       9.887 100.480 -12.060  1.00 16.78           O  
ATOM    695  CB  GLU A  73      10.361  99.752 -14.734  1.00 15.93           C  
ATOM    696  CG  GLU A  73      10.092  99.820 -16.235  1.00 18.42           C  
ATOM    697  CD  GLU A  73      10.300  98.507 -16.957  1.00 22.93           C  
ATOM    698  OE1 GLU A  73      10.819  97.538 -16.337  1.00 23.61           O  
ATOM    699  OE2 GLU A  73       9.967  98.468 -18.165  1.00 22.37           O  
ATOM    700  H   GLU A  73      12.850 100.938 -14.452  1.00  0.00           H  
ATOM    701  N   GLY A  74      11.359 102.151 -12.105  1.00 14.68           N  
ATOM    702  CA  GLY A  74      11.317 102.346 -10.672  1.00 15.08           C  
ATOM    703  C   GLY A  74      12.409 103.350 -10.337  1.00 14.75           C  
ATOM    704  O   GLY A  74      13.354 103.474 -11.108  1.00 13.79           O  
ATOM    705  H   GLY A  74      11.927 102.755 -12.616  1.00  0.00           H  
ATOM    706  N   VAL A  75      12.215 104.133  -9.279  1.00 11.98           N  
ATOM    707  CA  VAL A  75      13.217 105.097  -8.814  1.00 11.37           C  
ATOM    708  C   VAL A  75      13.447 104.914  -7.287  1.00 10.96           C  
ATOM    709  O   VAL A  75      12.551 104.421  -6.572  1.00  9.86           O  
ATOM    710  CB  VAL A  75      12.795 106.563  -9.129  1.00 10.94           C  
ATOM    711  CG1 VAL A  75      12.941 106.841 -10.631  1.00 12.54           C  
ATOM    712  CG2 VAL A  75      11.348 106.831  -8.690  1.00 10.59           C  
ATOM    713  H   VAL A  75      11.376 104.061  -8.774  1.00  0.00           H  
ATOM    714  N   PRO A  76      14.638 105.291  -6.782  1.00 10.30           N  
ATOM    715  CA  PRO A  76      15.756 105.864  -7.551  1.00  9.95           C  
ATOM    716  C   PRO A  76      16.447 104.823  -8.403  1.00 10.21           C  
ATOM    717  O   PRO A  76      16.401 103.634  -8.095  1.00 11.00           O  
ATOM    718  CB  PRO A  76      16.698 106.400  -6.478  1.00  8.92           C  
ATOM    719  CG  PRO A  76      16.458 105.476  -5.326  1.00 10.18           C  
ATOM    720  CD  PRO A  76      14.962 105.219  -5.342  1.00  9.70           C  
ATOM    721  N   ALA A  77      17.076 105.271  -9.482  1.00  8.39           N  
ATOM    722  CA  ALA A  77      17.795 104.356 -10.377  1.00  9.59           C  
ATOM    723  C   ALA A  77      19.048 105.015 -10.942  1.00  8.44           C  
ATOM    724  O   ALA A  77      19.092 106.245 -11.109  1.00  8.72           O  
ATOM    725  CB  ALA A  77      16.878 103.893 -11.525  1.00  9.05           C  
ATOM    726  H   ALA A  77      17.089 106.229  -9.705  1.00  0.00           H  
ATOM    727  N   LEU A  78      20.077 104.200 -11.162  1.00  8.00           N  
ATOM    728  CA  LEU A  78      21.341 104.658 -11.751  1.00  8.86           C  
ATOM    729  C   LEU A  78      21.714 103.863 -13.011  1.00  9.32           C  
ATOM    730  O   LEU A  78      21.510 102.652 -13.075  1.00  9.27           O  
ATOM    731  CB  LEU A  78      22.500 104.508 -10.766  1.00  8.66           C  
ATOM    732  CG  LEU A  78      22.408 105.314  -9.473  1.00 11.86           C  
ATOM    733  CD1 LEU A  78      23.536 104.917  -8.553  1.00 14.17           C  
ATOM    734  CD2 LEU A  78      22.489 106.817  -9.803  1.00 14.94           C  
ATOM    735  H   LEU A  78      19.982 103.250 -10.962  1.00  0.00           H  
ATOM    736  N   ARG A  79      22.245 104.562 -14.005  1.00  8.50           N  
ATOM    737  CA  ARG A  79      22.754 103.924 -15.223  1.00 10.16           C  
ATOM    738  C   ARG A  79      24.130 104.577 -15.441  1.00 10.86           C  
ATOM    739  O   ARG A  79      24.219 105.812 -15.455  1.00 11.98           O  
ATOM    740  CB  ARG A  79      21.865 104.203 -16.461  1.00  9.57           C  
ATOM    741  CG  ARG A  79      20.417 103.773 -16.321  1.00 10.05           C  
ATOM    742  CD  ARG A  79      20.328 102.268 -16.333  1.00 10.50           C  
ATOM    743  NE  ARG A  79      18.949 101.800 -16.342  1.00 13.77           N  
ATOM    744  CZ  ARG A  79      18.277 101.379 -15.263  1.00 14.73           C  
ATOM    745  NH1 ARG A  79      18.849 101.387 -14.053  1.00 13.25           N  
ATOM    746  NH2 ARG A  79      17.059 100.860 -15.409  1.00 13.32           N  
ATOM    747  H   ARG A  79      22.325 105.540 -13.927  1.00  0.00           H  
ATOM    748  HE  ARG A  79      18.481 101.786 -17.208  1.00  0.00           H  
ATOM    749 HH11 ARG A  79      19.794 101.699 -13.919  1.00  0.00           H  
ATOM    750 HH12 ARG A  79      18.326 101.069 -13.268  1.00  0.00           H  
ATOM    751 HH21 ARG A  79      16.676 100.784 -16.327  1.00  0.00           H  
ATOM    752 HH22 ARG A  79      16.550 100.538 -14.612  1.00  0.00           H  
ATOM    753  N   LEU A  80      25.186 103.765 -15.557  1.00 10.13           N  
ATOM    754  CA  LEU A  80      26.553 104.262 -15.815  1.00  9.93           C  
ATOM    755  C   LEU A  80      26.782 103.946 -17.288  1.00 11.87           C  
ATOM    756  O   LEU A  80      26.759 102.779 -17.685  1.00 11.74           O  
ATOM    757  CB  LEU A  80      27.573 103.535 -14.946  1.00  8.72           C  
ATOM    758  CG  LEU A  80      29.021 103.971 -15.133  1.00  9.85           C  
ATOM    759  CD1 LEU A  80      29.204 105.436 -14.842  1.00  9.27           C  
ATOM    760  CD2 LEU A  80      29.917 103.118 -14.242  1.00 11.32           C  
ATOM    761  H   LEU A  80      25.052 102.799 -15.491  1.00  0.00           H  
ATOM    762  N   VAL A  81      26.985 104.973 -18.106  1.00 13.52           N  
ATOM    763  CA  VAL A  81      27.110 104.754 -19.547  1.00 13.51           C  
ATOM    764  C   VAL A  81      28.298 105.445 -20.174  1.00 11.68           C  
ATOM    765  O   VAL A  81      28.943 106.274 -19.552  1.00 12.79           O  
ATOM    766  CB  VAL A  81      25.819 105.210 -20.295  1.00 13.38           C  
ATOM    767  CG1 VAL A  81      24.542 104.675 -19.588  1.00 13.83           C  
ATOM    768  CG2 VAL A  81      25.784 106.747 -20.414  1.00 17.25           C  
ATOM    769  H   VAL A  81      27.081 105.889 -17.749  1.00  0.00           H  
ATOM    770  N   LYS A  82      28.620 105.018 -21.384  1.00 12.43           N  
ATOM    771  CA  LYS A  82      29.695 105.597 -22.166  1.00 15.12           C  
ATOM    772  C   LYS A  82      29.149 105.556 -23.590  1.00 14.91           C  
ATOM    773  O   LYS A  82      29.097 104.499 -24.228  1.00 13.33           O  
ATOM    774  CB  LYS A  82      30.959 104.770 -22.029  1.00 18.48           C  
ATOM    775  CG  LYS A  82      32.188 105.499 -22.533  1.00 29.51           C  
ATOM    776  CD  LYS A  82      33.481 104.772 -22.107  1.00 37.89           C  
ATOM    777  CE  LYS A  82      34.734 105.498 -22.610  1.00 42.92           C  
ATOM    778  NZ  LYS A  82      36.012 104.814 -22.241  1.00 45.71           N  
ATOM    779  H   LYS A  82      28.110 104.285 -21.791  1.00  0.00           H  
ATOM    780  HZ1 LYS A  82      35.937 103.847 -22.610  1.00  0.00           H  
ATOM    781  HZ2 LYS A  82      36.765 105.319 -22.772  1.00  0.00           H  
ATOM    782  HZ3 LYS A  82      36.199 104.862 -21.224  1.00  0.00           H  
ATOM    783  N   GLY A  83      28.658 106.695 -24.061  1.00 12.83           N  
ATOM    784  CA  GLY A  83      28.058 106.742 -25.373  1.00 14.58           C  
ATOM    785  C   GLY A  83      26.832 105.854 -25.297  1.00 16.43           C  
ATOM    786  O   GLY A  83      26.061 105.975 -24.361  1.00 17.56           O  
ATOM    787  H   GLY A  83      28.688 107.518 -23.539  1.00  0.00           H  
ATOM    788  N   GLU A  84      26.646 104.962 -26.259  1.00 15.76           N  
ATOM    789  CA  GLU A  84      25.505 104.053 -26.249  1.00 17.71           C  
ATOM    790  C   GLU A  84      25.734 102.790 -25.400  1.00 17.97           C  
ATOM    791  O   GLU A  84      24.848 101.938 -25.291  1.00 21.95           O  
ATOM    792  CB  GLU A  84      25.142 103.646 -27.680  1.00 17.82           C  
ATOM    793  CG  GLU A  84      24.436 104.730 -28.482  1.00 21.22           C  
ATOM    794  CD  GLU A  84      22.971 104.922 -28.087  1.00 23.94           C  
ATOM    795  OE1 GLU A  84      22.465 104.228 -27.179  1.00 26.06           O  
ATOM    796  OE2 GLU A  84      22.302 105.784 -28.697  1.00 28.37           O  
ATOM    797  H   GLU A  84      27.292 104.903 -26.993  1.00  0.00           H  
ATOM    798  N   GLN A  85      26.922 102.647 -24.823  1.00 15.77           N  
ATOM    799  CA  GLN A  85      27.232 101.475 -24.011  1.00 15.34           C  
ATOM    800  C   GLN A  85      26.806 101.666 -22.552  1.00 14.94           C  
ATOM    801  O   GLN A  85      27.195 102.640 -21.914  1.00 15.14           O  
ATOM    802  CB  GLN A  85      28.744 101.193 -24.062  0.50 13.58           C  
ATOM    803  CG  GLN A  85      29.227 100.135 -23.082  0.50 19.07           C  
ATOM    804  CD  GLN A  85      30.735  99.888 -23.156  0.50 22.49           C  
ATOM    805  OE1 GLN A  85      31.537 100.824 -23.222  0.50 25.64           O  
ATOM    806  NE2 GLN A  85      31.123  98.623 -23.134  0.50 24.98           N  
ATOM    807  H   GLN A  85      27.600 103.343 -24.903  1.00  0.00           H  
ATOM    808 HE21 GLN A  85      32.084  98.449 -23.152  1.00  0.00           H  
ATOM    809 HE22 GLN A  85      30.442  97.916 -23.103  1.00  0.00           H  
ATOM    810  N   ILE A  86      26.025 100.735 -22.024  1.00 13.89           N  
ATOM    811  CA  ILE A  86      25.637 100.819 -20.624  1.00 15.06           C  
ATOM    812  C   ILE A  86      26.639  99.962 -19.872  1.00 15.15           C  
ATOM    813  O   ILE A  86      26.717  98.756 -20.105  1.00 17.79           O  
ATOM    814  CB  ILE A  86      24.207 100.317 -20.380  1.00 15.31           C  
ATOM    815  CG1 ILE A  86      23.248 101.192 -21.178  1.00 18.85           C  
ATOM    816  CG2 ILE A  86      23.868 100.378 -18.877  1.00 13.36           C  
ATOM    817  CD1 ILE A  86      21.826 100.727 -21.146  1.00 21.04           C  
ATOM    818  H   ILE A  86      25.716  99.983 -22.570  1.00  0.00           H  
ATOM    819  N   LEU A  87      27.450 100.582 -19.032  1.00 11.97           N  
ATOM    820  CA  LEU A  87      28.460  99.854 -18.284  1.00 13.54           C  
ATOM    821  C   LEU A  87      27.906  99.096 -17.088  1.00 15.74           C  
ATOM    822  O   LEU A  87      28.404  98.026 -16.759  1.00 18.60           O  
ATOM    823  CB  LEU A  87      29.544 100.793 -17.795  1.00 14.73           C  
ATOM    824  CG  LEU A  87      30.144 101.678 -18.868  1.00 16.02           C  
ATOM    825  CD1 LEU A  87      31.184 102.557 -18.277  1.00 17.01           C  
ATOM    826  CD2 LEU A  87      30.730 100.802 -19.920  1.00 18.61           C  
ATOM    827  H   LEU A  87      27.363 101.541 -18.930  1.00  0.00           H  
ATOM    828  N   ASP A  88      26.972  99.705 -16.367  1.00 14.32           N  
ATOM    829  CA  ASP A  88      26.378  99.078 -15.196  1.00 13.82           C  
ATOM    830  C   ASP A  88      25.120  99.811 -14.815  1.00 13.28           C  
ATOM    831  O   ASP A  88      24.866 100.899 -15.303  1.00 11.56           O  
ATOM    832  CB  ASP A  88      27.357  99.102 -14.040  1.00 15.44           C  
ATOM    833  CG  ASP A  88      27.216  97.900 -13.151  1.00 17.83           C  
ATOM    834  OD1 ASP A  88      26.117  97.297 -13.143  1.00 18.23           O  
ATOM    835  OD2 ASP A  88      28.207  97.543 -12.474  1.00 20.26           O  
ATOM    836  H   ASP A  88      26.651 100.602 -16.644  1.00  0.00           H  
ATOM    837  N   SER A  89      24.342  99.229 -13.918  1.00 14.01           N  
ATOM    838  CA  SER A  89      23.107  99.841 -13.488  1.00 15.98           C  
ATOM    839  C   SER A  89      22.696  99.352 -12.107  1.00 17.66           C  
ATOM    840  O   SER A  89      23.132  98.274 -11.669  1.00 17.62           O  
ATOM    841  CB  SER A  89      21.994  99.569 -14.501  0.50 16.87           C  
ATOM    843  OG  SER A  89      21.794  98.188 -14.648  0.50 17.92           O  
ATOM    845  H   SER A  89      24.507  98.369 -13.490  0.50  0.00           H  
ATOM    847  HG  SER A  89      21.062  98.043 -15.252  0.50  0.00           H  
ATOM    849  N   THR A  90      21.940 100.176 -11.393  1.00 15.66           N  
ATOM    850  CA  THR A  90      21.438  99.793 -10.090  1.00 16.18           C  
ATOM    851  C   THR A  90      20.089 100.446  -9.749  1.00 14.50           C  
ATOM    852  O   THR A  90      19.723 101.459 -10.305  1.00 14.47           O  
ATOM    853  CB  THR A  90      22.525  99.951  -8.987  1.00 19.33           C  
ATOM    854  OG1 THR A  90      22.123  99.200  -7.828  1.00 27.94           O  
ATOM    855  CG2 THR A  90      22.738 101.377  -8.628  1.00 15.95           C  
ATOM    856  H   THR A  90      21.651 101.039 -11.767  1.00  0.00           H  
ATOM    857  HG1 THR A  90      22.730  99.251  -7.086  1.00  0.00           H  
ATOM    858  N   GLU A  91      19.320  99.792  -8.891  1.00 13.95           N  
ATOM    859  CA  GLU A  91      17.997 100.260  -8.487  1.00 15.54           C  
ATOM    860  C   GLU A  91      17.982 100.407  -6.961  1.00 14.21           C  
ATOM    861  O   GLU A  91      18.534  99.562  -6.247  1.00 14.12           O  
ATOM    862  CB  GLU A  91      16.941  99.197  -8.823  1.00 17.17           C  
ATOM    863  CG  GLU A  91      17.009  98.590 -10.200  1.00 21.91           C  
ATOM    864  CD  GLU A  91      16.446  99.513 -11.249  1.00 24.31           C  
ATOM    865  OE1 GLU A  91      15.297  99.976 -11.048  1.00 26.72           O  
ATOM    866  OE2 GLU A  91      17.141  99.745 -12.273  1.00 23.23           O  
ATOM    867  H   GLU A  91      19.662  98.987  -8.463  1.00  0.00           H  
ATOM    868  N   GLY A  92      17.304 101.425  -6.456  1.00 12.83           N  
ATOM    869  CA  GLY A  92      17.211 101.584  -5.021  1.00 12.52           C  
ATOM    870  C   GLY A  92      18.356 102.338  -4.380  1.00 13.46           C  
ATOM    871  O   GLY A  92      19.356 102.678  -5.029  1.00 13.93           O  
ATOM    872  H   GLY A  92      16.902 102.091  -7.050  1.00  0.00           H  
ATOM    873  N   VAL A  93      18.146 102.697  -3.120  1.00 13.12           N  
ATOM    874  CA  VAL A  93      19.156 103.411  -2.355  1.00 15.05           C  
ATOM    875  C   VAL A  93      20.327 102.465  -2.077  1.00 16.55           C  
ATOM    876  O   VAL A  93      20.121 101.279  -1.780  1.00 17.03           O  
ATOM    877  CB  VAL A  93      18.558 103.917  -0.986  1.00 16.58           C  
ATOM    878  CG1 VAL A  93      19.668 104.356  -0.040  1.00 17.30           C  
ATOM    879  CG2 VAL A  93      17.570 105.066  -1.226  1.00 14.73           C  
ATOM    880  H   VAL A  93      17.285 102.479  -2.702  1.00  0.00           H  
ATOM    881  N   ILE A  94      21.544 102.954  -2.270  1.00 16.86           N  
ATOM    882  CA  ILE A  94      22.721 102.152  -1.951  1.00 19.22           C  
ATOM    883  C   ILE A  94      23.613 103.010  -1.062  1.00 19.89           C  
ATOM    884  O   ILE A  94      23.490 104.224  -1.053  1.00 20.27           O  
ATOM    885  CB  ILE A  94      23.515 101.643  -3.195  1.00 19.09           C  
ATOM    886  CG1 ILE A  94      24.055 102.799  -4.037  1.00 19.89           C  
ATOM    887  CG2 ILE A  94      22.646 100.691  -4.024  1.00 21.13           C  
ATOM    888  CD1 ILE A  94      25.066 102.330  -5.097  1.00 20.38           C  
ATOM    889  H   ILE A  94      21.690 103.865  -2.593  1.00  0.00           H  
ATOM    890  N   SER A  95      24.479 102.377  -0.279  1.00 21.50           N  
ATOM    891  CA  SER A  95      25.382 103.101   0.613  1.00 19.89           C  
ATOM    892  C   SER A  95      26.520 103.821  -0.137  1.00 20.02           C  
ATOM    893  O   SER A  95      26.865 103.465  -1.265  1.00 19.20           O  
ATOM    894  CB  SER A  95      25.991 102.098   1.571  1.00 20.26           C  
ATOM    895  OG  SER A  95      26.783 101.157   0.863  1.00 20.33           O  
ATOM    896  H   SER A  95      24.531 101.400  -0.289  1.00  0.00           H  
ATOM    897  HG  SER A  95      27.080 100.526   1.537  1.00  0.00           H  
ATOM    898  N   LYS A  96      27.147 104.787   0.529  1.00 20.42           N  
ATOM    899  CA  LYS A  96      28.263 105.525  -0.047  1.00 22.24           C  
ATOM    900  C   LYS A  96      29.344 104.571  -0.485  1.00 20.82           C  
ATOM    901  O   LYS A  96      29.904 104.706  -1.562  1.00 20.50           O  
ATOM    902  CB  LYS A  96      28.840 106.506   0.965  1.00 26.49           C  
ATOM    903  CG  LYS A  96      30.056 107.273   0.481  1.00 32.37           C  
ATOM    904  CD  LYS A  96      30.554 108.238   1.574  1.00 39.39           C  
ATOM    905  CE  LYS A  96      31.951 108.850   1.244  1.00 44.51           C  
ATOM    906  NZ  LYS A  96      32.434 109.942   2.194  1.00 45.19           N  
ATOM    907  H   LYS A  96      26.834 105.030   1.417  1.00  0.00           H  
ATOM    908  HZ1 LYS A  96      32.319 109.574   3.161  1.00  0.00           H  
ATOM    909  HZ2 LYS A  96      33.437 110.131   1.998  1.00  0.00           H  
ATOM    910  HZ3 LYS A  96      31.874 110.818   2.079  1.00  0.00           H  
ATOM    911  N   ASP A  97      29.565 103.548   0.320  1.00 21.73           N  
ATOM    912  CA  ASP A  97      30.582 102.557   0.027  1.00 23.94           C  
ATOM    913  C   ASP A  97      30.288 101.754  -1.221  1.00 24.16           C  
ATOM    914  O   ASP A  97      31.190 101.515  -2.050  1.00 23.74           O  
ATOM    915  CB  ASP A  97      30.774 101.609   1.220  1.00 29.63           C  
ATOM    916  CG  ASP A  97      31.440 102.289   2.417  1.00 34.20           C  
ATOM    917  OD1 ASP A  97      32.222 103.252   2.208  1.00 36.45           O  
ATOM    918  OD2 ASP A  97      31.180 101.844   3.561  1.00 38.48           O  
ATOM    919  H   ASP A  97      29.044 103.473   1.139  1.00  0.00           H  
ATOM    920  N   LYS A  98      29.038 101.316  -1.339  1.00 22.41           N  
ATOM    921  CA  LYS A  98      28.595 100.527  -2.484  1.00 23.05           C  
ATOM    922  C   LYS A  98      28.704 101.389  -3.768  1.00 21.57           C  
ATOM    923  O   LYS A  98      29.153 100.924  -4.824  1.00 21.27           O  
ATOM    924  CB  LYS A  98      27.154 100.072  -2.225  1.00 26.41           C  
ATOM    925  CG  LYS A  98      26.567  99.092  -3.217  1.00 33.05           C  
ATOM    926  CD  LYS A  98      25.664  98.007  -2.531  1.00 39.19           C  
ATOM    927  CE  LYS A  98      24.308  98.521  -1.968  1.00 42.16           C  
ATOM    928  NZ  LYS A  98      24.297  99.123  -0.570  1.00 42.70           N  
ATOM    929  H   LYS A  98      28.376 101.526  -0.646  1.00  0.00           H  
ATOM    930  HZ1 LYS A  98      25.028  99.851  -0.450  1.00  0.00           H  
ATOM    931  HZ2 LYS A  98      23.355  99.539  -0.406  1.00  0.00           H  
ATOM    932  HZ3 LYS A  98      24.421  98.355   0.123  1.00  0.00           H  
ATOM    933  N   LEU A  99      28.345 102.661  -3.649  1.00 19.97           N  
ATOM    934  CA  LEU A  99      28.414 103.592  -4.772  1.00 18.96           C  
ATOM    935  C   LEU A  99      29.844 103.802  -5.249  1.00 19.48           C  
ATOM    936  O   LEU A  99      30.130 103.779  -6.451  1.00 19.10           O  
ATOM    937  CB  LEU A  99      27.809 104.948  -4.374  1.00 17.00           C  
ATOM    938  CG  LEU A  99      27.864 106.062  -5.419  1.00 15.87           C  
ATOM    939  CD1 LEU A  99      27.283 105.619  -6.751  1.00 17.94           C  
ATOM    940  CD2 LEU A  99      27.120 107.256  -4.896  1.00 17.28           C  
ATOM    941  H   LEU A  99      28.023 102.980  -2.774  1.00  0.00           H  
ATOM    942  N   LEU A 100      30.745 104.006  -4.297  1.00 20.68           N  
ATOM    943  CA  LEU A 100      32.138 104.257  -4.621  1.00 22.58           C  
ATOM    944  C   LEU A 100      32.746 103.053  -5.305  1.00 23.16           C  
ATOM    945  O   LEU A 100      33.468 103.211  -6.291  1.00 23.90           O  
ATOM    946  CB  LEU A 100      32.906 104.680  -3.364  1.00 24.57           C  
ATOM    947  CG  LEU A 100      33.251 106.176  -3.159  1.00 27.24           C  
ATOM    948  CD1 LEU A 100      32.134 107.130  -3.504  1.00 27.84           C  
ATOM    949  CD2 LEU A 100      33.634 106.388  -1.719  1.00 26.93           C  
ATOM    950  H   LEU A 100      30.479 103.995  -3.353  1.00  0.00           H  
ATOM    951  N   SER A 101      32.387 101.852  -4.854  1.00 23.88           N  
ATOM    952  CA  SER A 101      32.900 100.623  -5.480  1.00 26.69           C  
ATOM    953  C   SER A 101      32.259 100.379  -6.842  1.00 26.22           C  
ATOM    954  O   SER A 101      32.868  99.795  -7.743  1.00 27.04           O  
ATOM    955  CB  SER A 101      32.639  99.399  -4.599  1.00 30.52           C  
ATOM    956  OG  SER A 101      33.210  99.587  -3.312  1.00 39.67           O  
ATOM    957  H   SER A 101      31.787 101.770  -4.074  1.00  0.00           H  
ATOM    958  HG  SER A 101      33.118  98.807  -2.762  1.00  0.00           H  
ATOM    959  N   PHE A 102      31.000 100.772  -6.966  1.00 24.22           N  
ATOM    960  CA  PHE A 102      30.278 100.629  -8.221  1.00 24.25           C  
ATOM    961  C   PHE A 102      31.084 101.433  -9.259  1.00 23.13           C  
ATOM    962  O   PHE A 102      31.431 100.928 -10.322  1.00 24.63           O  
ATOM    963  CB  PHE A 102      28.847 101.176  -8.019  1.00 22.69           C  
ATOM    964  CG  PHE A 102      28.001 101.243  -9.266  1.00 24.30           C  
ATOM    965  CD1 PHE A 102      27.256 100.133  -9.689  1.00 23.37           C  
ATOM    966  CD2 PHE A 102      27.835 102.462  -9.943  1.00 23.46           C  
ATOM    967  CE1 PHE A 102      26.352 100.235 -10.747  1.00 21.80           C  
ATOM    968  CE2 PHE A 102      26.930 102.576 -11.005  1.00 23.52           C  
ATOM    969  CZ  PHE A 102      26.182 101.456 -11.409  1.00 23.89           C  
ATOM    970  H   PHE A 102      30.542 101.176  -6.199  1.00  0.00           H  
ATOM    971  N   LEU A 103      31.493 102.638  -8.873  1.00 21.68           N  
ATOM    972  CA  LEU A 103      32.241 103.513  -9.763  1.00 19.64           C  
ATOM    973  C   LEU A 103      33.676 103.098  -9.992  1.00 20.64           C  
ATOM    974  O   LEU A 103      34.123 103.044 -11.131  1.00 20.20           O  
ATOM    975  CB  LEU A 103      32.157 104.958  -9.267  1.00 17.43           C  
ATOM    976  CG  LEU A 103      30.735 105.527  -9.295  1.00 16.82           C  
ATOM    977  CD1 LEU A 103      30.657 106.849  -8.509  1.00 16.20           C  
ATOM    978  CD2 LEU A 103      30.253 105.692 -10.763  1.00 14.96           C  
ATOM    979  H   LEU A 103      31.247 102.954  -7.978  1.00  0.00           H  
ATOM    980  N   ASP A 104      34.388 102.780  -8.920  1.00 22.79           N  
ATOM    981  CA  ASP A 104      35.788 102.376  -9.020  1.00 25.28           C  
ATOM    982  C   ASP A 104      36.004 101.206  -9.944  1.00 25.80           C  
ATOM    983  O   ASP A 104      36.962 101.177 -10.719  1.00 25.76           O  
ATOM    984  CB  ASP A 104      36.357 102.018  -7.645  1.00 29.27           C  
ATOM    985  CG  ASP A 104      36.672 103.242  -6.802  1.00 33.36           C  
ATOM    986  OD1 ASP A 104      36.689 104.362  -7.379  1.00 33.89           O  
ATOM    987  OD2 ASP A 104      36.906 103.073  -5.572  1.00 35.22           O  
ATOM    988  H   ASP A 104      33.948 102.835  -8.050  1.00  0.00           H  
ATOM    989  N   THR A 105      35.082 100.257  -9.893  1.00 25.82           N  
ATOM    990  CA  THR A 105      35.198  99.075 -10.703  1.00 26.54           C  
ATOM    991  C   THR A 105      35.228  99.397 -12.168  1.00 26.06           C  
ATOM    992  O   THR A 105      35.982  98.790 -12.891  1.00 28.14           O  
ATOM    993  CB  THR A 105      34.047  98.114 -10.411  1.00 28.48           C  
ATOM    994  OG1 THR A 105      34.096  97.759  -9.021  1.00 32.05           O  
ATOM    995  CG2 THR A 105      34.142  96.859 -11.275  1.00 27.28           C  
ATOM    996  H   THR A 105      34.296 100.298  -9.302  1.00  0.00           H  
ATOM    997  HG1 THR A 105      33.426  97.089  -8.853  1.00  0.00           H  
ATOM    998  N   HIS A 106      34.478 100.411 -12.582  1.00 26.02           N  
ATOM    999  CA  HIS A 106      34.390 100.776 -13.988  1.00 26.25           C  
ATOM   1000  C   HIS A 106      35.299 101.898 -14.442  1.00 29.51           C  
ATOM   1001  O   HIS A 106      35.695 101.956 -15.606  1.00 31.27           O  
ATOM   1002  CB  HIS A 106      32.933 101.096 -14.335  1.00 22.67           C  
ATOM   1003  CG  HIS A 106      32.016  99.941 -14.149  1.00 20.57           C  
ATOM   1004  ND1 HIS A 106      32.001  98.849 -14.996  1.00 21.20           N  
ATOM   1005  CD2 HIS A 106      31.127  99.657 -13.165  1.00 20.84           C  
ATOM   1006  CE1 HIS A 106      31.156  97.944 -14.537  1.00 20.39           C  
ATOM   1007  NE2 HIS A 106      30.616  98.413 -13.426  1.00 18.51           N  
ATOM   1008  H   HIS A 106      34.025 100.962 -11.904  1.00  0.00           H  
ATOM   1009  HD1 HIS A 106      32.519  98.745 -15.833  1.00  0.00           H  
ATOM   1010  HE2 HIS A 106      30.031  97.944 -12.817  1.00  0.00           H  
ATOM   1011  N   LEU A 107      35.628 102.802 -13.540  1.00 33.40           N  
ATOM   1012  CA  LEU A 107      36.468 103.914 -13.921  1.00 39.69           C  
ATOM   1013  C   LEU A 107      37.935 103.528 -14.085  1.00 45.67           C  
ATOM   1014  O   LEU A 107      38.673 104.199 -14.810  1.00 48.17           O  
ATOM   1015  CB  LEU A 107      36.306 105.063 -12.927  1.00 37.77           C  
ATOM   1016  CG  LEU A 107      34.909 105.698 -12.948  1.00 37.24           C  
ATOM   1017  CD1 LEU A 107      34.897 107.008 -12.157  1.00 37.03           C  
ATOM   1018  CD2 LEU A 107      34.499 105.943 -14.383  1.00 33.23           C  
ATOM   1019  H   LEU A 107      35.345 102.731 -12.608  1.00  0.00           H  
ATOM   1020  N   ASN A 108      38.321 102.402 -13.482  1.00 51.25           N  
ATOM   1021  CA  ASN A 108      39.702 101.912 -13.512  1.00 55.04           C  
ATOM   1022  C   ASN A 108      39.995 100.769 -14.518  1.00 56.57           C  
ATOM   1023  O   ASN A 108      40.765 101.015 -15.492  1.00 56.78           O  
ATOM   1024  CB  ASN A 108      40.107 101.533 -12.082  1.00 56.87           C  
ATOM   1025  CG  ASN A 108      39.951 102.710 -11.111  1.00 59.99           C  
ATOM   1026  OD1 ASN A 108      40.506 103.789 -11.337  1.00 64.29           O  
ATOM   1027  ND2 ASN A 108      39.155 102.528 -10.065  1.00 60.47           N  
ATOM   1028  H   ASN A 108      37.688 101.819 -13.040  1.00  0.00           H  
ATOM   1029 HD21 ASN A 108      39.069 103.294  -9.461  1.00  0.00           H  
ATOM   1030 HD22 ASN A 108      38.722 101.656 -10.008  1.00  0.00           H  
TER    1031      ASN A 108                                                      
END
MOLECULE T0458.pdb
ATOM   1307  N   THR    12      35.233 112.701 -19.135  1.00 39.16           N  
ATOM   1308  CA  THR    12      35.143 111.676 -20.213  1.00 38.90           C  
ATOM   1309  C   THR    12      34.112 110.567 -19.899  1.00 40.96           C  
ATOM   1310  O   THR    12      33.648 109.876 -20.805  1.00 39.76           O  
ATOM   1311  CB  THR    12      36.539 111.055 -20.467  1.00 36.99           C  
ATOM   1312  OG1 THR    12      36.541 110.386 -21.728  1.00 33.73           O  
ATOM   1313  CG2 THR    12      36.902 110.062 -19.365  1.00 36.11           C  
ATOM   1314  N   HIS    13      33.754 110.409 -18.620  1.00 42.95           N  
ATOM   1315  CA  HIS    13      32.768 109.405 -18.186  1.00 42.37           C  
ATOM   1316  C   HIS    13      31.481 110.051 -17.638  1.00 39.31           C  
ATOM   1317  O   HIS    13      31.550 110.916 -16.776  1.00 39.49           O  
ATOM   1318  CB  HIS    13      33.360 108.504 -17.091  1.00 45.88           C  
ATOM   1319  CG  HIS    13      34.163 107.348 -17.608  1.00 45.03           C  
ATOM   1320  ND1 HIS    13      35.476 107.468 -18.010  1.00 45.10           N  
ATOM   1321  CD2 HIS    13      33.840 106.042 -17.763  1.00 38.68           C  
ATOM   1322  CE1 HIS    13      35.928 106.286 -18.388  1.00 40.14           C  
ATOM   1323  NE2 HIS    13      34.955 105.405 -18.249  1.00 41.81           N  
ATOM   1324  N   ARG    14      30.321 109.602 -18.117  1.00 35.30           N  
ATOM   1325  CA  ARG    14      29.012 110.124 -17.694  1.00 33.07           C  
ATOM   1326  C   ARG    14      28.270 109.275 -16.638  1.00 32.17           C  
ATOM   1327  O   ARG    14      28.250 108.043 -16.729  1.00 34.66           O  
ATOM   1328  CB  ARG    14      28.077 110.231 -18.901  1.00 30.55           C  
ATOM   1329  CG  ARG    14      28.092 111.531 -19.645  1.00 41.12           C  
ATOM   1330  CD  ARG    14      26.788 111.725 -20.417  1.00 52.11           C  
ATOM   1331  NE  ARG    14      25.605 111.441 -19.583  1.00 63.25           N  
ATOM   1332  CZ  ARG    14      24.380 111.936 -19.790  1.00 63.42           C  
ATOM   1333  NH1 ARG    14      23.379 111.608 -18.979  1.00 59.81           N  
ATOM   1334  NH2 ARG    14      24.157 112.777 -20.794  1.00 64.54           N  
ATOM   1335  N   VAL    15      27.635 109.920 -15.659  1.00 26.43           N  
ATOM   1336  CA  VAL    15      26.857 109.184 -14.657  1.00 20.22           C  
ATOM   1337  C   VAL    15      25.458 109.762 -14.622  1.00 18.68           C  
ATOM   1338  O   VAL    15      25.276 110.951 -14.811  1.00 24.00           O  
ATOM   1339  CB  VAL    15      27.464 109.273 -13.230  1.00 22.11           C  
ATOM   1340  CG1 VAL    15      26.500 108.673 -12.212  1.00 18.60           C  
ATOM   1341  CG2 VAL    15      28.785 108.521 -13.180  1.00 21.25           C  
ATOM   1342  N   GLN    16      24.465 108.925 -14.388  1.00 18.92           N  
ATOM   1343  CA  GLN    16      23.099 109.404 -14.339  1.00 20.61           C  
ATOM   1344  C   GLN    16      22.377 108.740 -13.172  1.00 20.40           C  
ATOM   1345  O   GLN    16      22.593 107.562 -12.890  1.00 22.85           O  
ATOM   1346  CB  GLN    16      22.400 109.073 -15.655  1.00 23.81           C  
ATOM   1347  CG  GLN    16      20.923 109.356 -15.665  1.00 30.32           C  
ATOM   1348  CD  GLN    16      20.263 108.887 -16.947  1.00 37.44           C  
ATOM   1349  OE1 GLN    16      20.323 107.701 -17.302  1.00 39.95           O  
ATOM   1350  NE2 GLN    16      19.625 109.820 -17.654  1.00 42.41           N  
ATOM   1351  N   ILE    17      21.523 109.495 -12.492  1.00 20.42           N  
ATOM   1352  CA  ILE    17      20.762 108.969 -11.364  1.00 14.91           C  
ATOM   1353  C   ILE    17      19.307 109.239 -11.617  1.00 15.05           C  
ATOM   1354  O   ILE    17      18.911 110.388 -11.727  1.00 24.10           O  
ATOM   1355  CB  ILE    17      21.159 109.676 -10.065  1.00 14.15           C  
ATOM   1356  CG1 ILE    17      22.619 109.367  -9.757  1.00 17.41           C  
ATOM   1357  CG2 ILE    17      20.241 109.271  -8.928  1.00  6.52           C  
ATOM   1358  CD1 ILE    17      23.132 110.054  -8.534  1.00 18.66           C  
ATOM   1359  N   GLU    18      18.506 108.200 -11.739  1.00 12.00           N  
ATOM   1360  CA  GLU    18      17.079 108.398 -11.959  1.00 17.13           C  
ATOM   1361  C   GLU    18      16.341 108.070 -10.650  1.00 19.59           C  
ATOM   1362  O   GLU    18      16.342 106.921 -10.189  1.00 16.11           O  
ATOM   1363  CB  GLU    18      16.612 107.486 -13.089  1.00 22.94           C  
ATOM   1364  CG  GLU    18      15.173 107.698 -13.530  1.00 34.31           C  
ATOM   1365  CD  GLU    18      14.711 106.651 -14.538  1.00 42.81           C  
ATOM   1366  OE1 GLU    18      13.515 106.693 -14.946  1.00 55.33           O  
ATOM   1367  OE2 GLU    18      15.543 105.786 -14.918  1.00 42.86           O  
ATOM   1368  N   TYR    19      15.715 109.083 -10.060  1.00 20.98           N  
ATOM   1369  CA  TYR    19      14.996 108.948  -8.781  1.00 24.62           C  
ATOM   1370  C   TYR    19      13.485 109.146  -8.906  1.00 24.60           C  
ATOM   1371  O   TYR    19      13.041 109.996  -9.668  1.00 23.03           O  
ATOM   1372  CB  TYR    19      15.511 109.999  -7.799  1.00 23.04           C  
ATOM   1373  CG  TYR    19      15.279 111.412  -8.298  1.00 20.84           C  
ATOM   1374  CD1 TYR    19      16.006 111.919  -9.383  1.00 13.93           C  
ATOM   1375  CD2 TYR    19      14.280 112.206  -7.746  1.00 16.88           C  
ATOM   1376  CE1 TYR    19      15.732 113.175  -9.909  1.00 13.50           C  
ATOM   1377  CE2 TYR    19      13.997 113.466  -8.264  1.00 21.62           C  
ATOM   1378  CZ  TYR    19      14.722 113.946  -9.346  1.00 18.13           C  
ATOM   1379  OH  TYR    19      14.429 115.187  -9.864  1.00 14.85           O  
ATOM   1380  N   CYS    20      12.700 108.395  -8.137  1.00 27.92           N  
ATOM   1381  CA  CYS    20      11.250 108.540  -8.199  1.00 32.48           C  
ATOM   1382  C   CYS    20      10.873 109.894  -7.620  1.00 33.70           C  
ATOM   1383  O   CYS    20      11.123 110.189  -6.453  1.00 33.30           O  
ATOM   1384  CB  CYS    20      10.545 107.395  -7.441  1.00 39.40           C  
ATOM   1385  SG  CYS    20       8.812 107.705  -6.905  1.00 47.94           S  
ATOM   1386  N   THR    21      10.281 110.721  -8.466  1.00 36.58           N  
ATOM   1387  CA  THR    21       9.877 112.061  -8.087  1.00 39.46           C  
ATOM   1388  C   THR    21       8.732 112.041  -7.063  1.00 40.19           C  
ATOM   1389  O   THR    21       8.768 112.759  -6.064  1.00 39.98           O  
ATOM   1390  CB  THR    21       9.483 112.862  -9.360  1.00 39.20           C  
ATOM   1391  OG1 THR    21       9.033 114.168  -8.998  1.00 45.36           O  
ATOM   1392  CG2 THR    21       8.379 112.139 -10.119  1.00 44.44           C  
ATOM   1393  N   GLN    22       7.732 111.200  -7.296  1.00 41.06           N  
ATOM   1394  CA  GLN    22       6.587 111.110  -6.391  1.00 44.27           C  
ATOM   1395  C   GLN    22       6.982 110.661  -4.978  1.00 44.35           C  
ATOM   1396  O   GLN    22       6.388 111.081  -3.978  1.00 40.32           O  
ATOM   1397  CB  GLN    22       5.547 110.146  -6.968  1.00 49.73           C  
ATOM   1398  CG  GLN    22       5.202 110.406  -8.431  1.00 57.57           C  
ATOM   1399  CD  GLN    22       4.559 111.763  -8.654  1.00 63.63           C  
ATOM   1400  OE1 GLN    22       3.488 112.051  -8.111  1.00 68.32           O  
ATOM   1401  NE2 GLN    22       5.209 112.607  -9.460  1.00 65.91           N  
ATOM   1402  N   CYS    23       7.996 109.812  -4.901  1.00 43.84           N  
ATOM   1403  CA  CYS    23       8.474 109.301  -3.622  1.00 41.93           C  
ATOM   1404  C   CYS    23       9.292 110.351  -2.850  1.00 39.32           C  
ATOM   1405  O   CYS    23       9.830 110.054  -1.788  1.00 36.69           O  
ATOM   1406  CB  CYS    23       9.341 108.061  -3.859  1.00 41.55           C  
ATOM   1407  SG  CYS    23       8.704 106.833  -5.047  1.00 53.71           S  
ATOM   1408  N   ARG    24       9.384 111.568  -3.382  1.00 36.78           N  
ATOM   1409  CA  ARG    24      10.159 112.625  -2.730  1.00 37.41           C  
ATOM   1410  C   ARG    24      11.608 112.157  -2.517  1.00 36.10           C  
ATOM   1411  O   ARG    24      12.173 112.325  -1.433  1.00 35.46           O  
ATOM   1412  CB  ARG    24       9.543 112.996  -1.366  1.00 39.04           C  
ATOM   1413  CG  ARG    24       8.055 113.365  -1.394  1.00 48.84           C  
ATOM   1414  CD  ARG    24       7.771 114.873  -1.434  1.00 54.67           C  
ATOM   1415  NE  ARG    24       7.980 115.487  -2.751  1.00 62.77           N  
ATOM   1416  CZ  ARG    24       7.809 116.785  -3.010  1.00 66.70           C  
ATOM   1417  NH1 ARG    24       7.423 117.614  -2.042  1.00 68.58           N  
ATOM   1418  NH2 ARG    24       8.024 117.260  -4.235  1.00 63.77           N  
ATOM   1419  N   TRP    25      12.210 111.575  -3.550  1.00 30.49           N  
ATOM   1420  CA  TRP    25      13.576 111.081  -3.434  1.00 27.73           C  
ATOM   1421  C   TRP    25      14.638 111.992  -4.059  1.00 26.32           C  
ATOM   1422  O   TRP    25      15.796 111.592  -4.273  1.00 21.86           O  
ATOM   1423  CB  TRP    25      13.697 109.677  -4.032  1.00 24.28           C  
ATOM   1424  CG  TRP    25      13.115 108.585  -3.175  1.00 26.51           C  
ATOM   1425  CD1 TRP    25      12.754 108.672  -1.866  1.00 22.11           C  
ATOM   1426  CD2 TRP    25      12.862 107.226  -3.572  1.00 27.33           C  
ATOM   1427  NE1 TRP    25      12.293 107.453  -1.421  1.00 25.73           N  
ATOM   1428  CE2 TRP    25      12.346 106.551  -2.449  1.00 23.98           C  
ATOM   1429  CE3 TRP    25      13.026 106.518  -4.770  1.00 25.78           C  
ATOM   1430  CZ2 TRP    25      11.987 105.210  -2.485  1.00 25.25           C  
ATOM   1431  CZ3 TRP    25      12.672 105.179  -4.807  1.00 27.16           C  
ATOM   1432  CH2 TRP    25      12.156 104.539  -3.669  1.00 28.13           C  
ATOM   1433  N   LEU    26      14.242 113.223  -4.340  1.00 23.87           N  
ATOM   1434  CA  LEU    26      15.151 114.188  -4.917  1.00 24.08           C  
ATOM   1435  C   LEU    26      16.310 114.425  -3.957  1.00 24.23           C  
ATOM   1436  O   LEU    26      17.486 114.364  -4.336  1.00 24.06           O  
ATOM   1437  CB  LEU    26      14.431 115.512  -5.188  1.00 18.76           C  
ATOM   1438  CG  LEU    26      15.326 116.672  -5.637  1.00 15.92           C  
ATOM   1439  CD1 LEU    26      16.110 116.290  -6.882  1.00 15.11           C  
ATOM   1440  CD2 LEU    26      14.477 117.874  -5.902  1.00 18.44           C  
ATOM   1441  N   PRO    27      16.000 114.705  -2.691  1.00 25.42           N  
ATOM   1442  CA  PRO    27      17.095 114.936  -1.749  1.00 25.47           C  
ATOM   1443  C   PRO    27      18.144 113.820  -1.668  1.00 20.34           C  
ATOM   1444  O   PRO    27      19.333 114.107  -1.643  1.00 20.35           O  
ATOM   1445  CB  PRO    27      16.369 115.172  -0.420  1.00 22.29           C  
ATOM   1446  CG  PRO    27      15.083 114.437  -0.586  1.00 28.33           C  
ATOM   1447  CD  PRO    27      14.701 114.788  -2.008  1.00 27.68           C  
ATOM   1448  N   ARG    28      17.734 112.557  -1.640  1.00 20.83           N  
ATOM   1449  CA  ARG    28      18.731 111.490  -1.556  1.00 22.05           C  
ATOM   1450  C   ARG    28      19.484 111.317  -2.873  1.00 23.44           C  
ATOM   1451  O   ARG    28      20.633 110.855  -2.898  1.00 19.09           O  
ATOM   1452  CB  ARG    28      18.090 110.162  -1.140  1.00 22.56           C  
ATOM   1453  CG  ARG    28      17.134 109.566  -2.148  1.00 26.08           C  
ATOM   1454  CD  ARG    28      16.553 108.280  -1.589  1.00 27.46           C  
ATOM   1455  NE  ARG    28      15.820 108.536  -0.353  1.00 32.39           N  
ATOM   1456  CZ  ARG    28      15.228 107.600   0.383  1.00 31.09           C  
ATOM   1457  NH1 ARG    28      15.285 106.329   0.009  1.00 33.28           N  
ATOM   1458  NH2 ARG    28      14.570 107.936   1.488  1.00 26.89           N  
ATOM   1459  N   ALA    29      18.822 111.664  -3.974  1.00 23.48           N  
ATOM   1460  CA  ALA    29      19.446 111.595  -5.290  1.00 16.24           C  
ATOM   1461  C   ALA    29      20.522 112.673  -5.320  1.00 16.53           C  
ATOM   1462  O   ALA    29      21.648 112.430  -5.749  1.00 17.05           O  
ATOM   1463  CB  ALA    29      18.424 111.863  -6.352  1.00 11.90           C  
ATOM   1464  N   ALA    30      20.164 113.866  -4.840  1.00 15.58           N  
ATOM   1465  CA  ALA    30      21.089 114.990  -4.798  1.00 12.15           C  
ATOM   1466  C   ALA    30      22.292 114.672  -3.919  1.00 13.81           C  
ATOM   1467  O   ALA    30      23.417 115.024  -4.245  1.00 17.93           O  
ATOM   1468  CB  ALA    30      20.387 116.217  -4.291  1.00  7.14           C  
ATOM   1469  N   TRP    31      22.050 113.988  -2.810  1.00 14.83           N  
ATOM   1470  CA  TRP    31      23.113 113.629  -1.904  1.00 13.24           C  
ATOM   1471  C   TRP    31      24.094 112.688  -2.569  1.00 16.56           C  
ATOM   1472  O   TRP    31      25.307 112.883  -2.482  1.00 18.69           O  
ATOM   1473  CB  TRP    31      22.532 112.968  -0.671  1.00 14.12           C  
ATOM   1474  CG  TRP    31      23.522 112.170   0.067  1.00 15.03           C  
ATOM   1475  CD1 TRP    31      24.635 112.625   0.710  1.00 13.81           C  
ATOM   1476  CD2 TRP    31      23.549 110.754   0.169  1.00 15.91           C  
ATOM   1477  NE1 TRP    31      25.360 111.573   1.201  1.00 17.25           N  
ATOM   1478  CE2 TRP    31      24.716 110.411   0.883  1.00 17.90           C  
ATOM   1479  CE3 TRP    31      22.703 109.739  -0.279  1.00 18.37           C  
ATOM   1480  CZ2 TRP    31      25.064 109.090   1.157  1.00 24.19           C  
ATOM   1481  CZ3 TRP    31      23.043 108.431  -0.012  1.00 25.80           C  
ATOM   1482  CH2 TRP    31      24.219 108.112   0.701  1.00 26.58           C  
ATOM   1483  N   LEU    32      23.570 111.652  -3.218  1.00 21.85           N  
ATOM   1484  CA  LEU    32      24.410 110.665  -3.908  1.00 22.79           C  
ATOM   1485  C   LEU    32      25.228 111.350  -5.001  1.00 25.24           C  
ATOM   1486  O   LEU    32      26.412 111.029  -5.216  1.00 27.20           O  
ATOM   1487  CB  LEU    32      23.551 109.584  -4.553  1.00 22.61           C  
ATOM   1488  CG  LEU    32      24.006 108.123  -4.413  1.00 24.51           C  
ATOM   1489  CD1 LEU    32      23.323 107.306  -5.521  1.00 25.19           C  
ATOM   1490  CD2 LEU    32      25.502 108.009  -4.517  1.00 18.89           C  
ATOM   1491  N   ALA    33      24.593 112.295  -5.691  1.00 20.92           N  
ATOM   1492  CA  ALA    33      25.267 113.028  -6.752  1.00 18.99           C  
ATOM   1493  C   ALA    33      26.503 113.726  -6.198  1.00 19.03           C  
ATOM   1494  O   ALA    33      27.575 113.721  -6.808  1.00 19.88           O  
ATOM   1495  CB  ALA    33      24.319 114.046  -7.354  1.00 20.93           C  
ATOM   1496  N   GLN    34      26.339 114.333  -5.034  1.00 15.61           N  
ATOM   1497  CA  GLN    34      27.427 115.030  -4.391  1.00 20.42           C  
ATOM   1498  C   GLN    34      28.514 114.044  -3.967  1.00 25.20           C  
ATOM   1499  O   GLN    34      29.701 114.323  -4.130  1.00 28.30           O  
ATOM   1500  CB  GLN    34      26.902 115.770  -3.183  1.00 20.00           C  
ATOM   1501  CG  GLN    34      27.732 116.943  -2.810  1.00 23.76           C  
ATOM   1502  CD  GLN    34      27.113 117.695  -1.689  1.00 25.03           C  
ATOM   1503  OE1 GLN    34      25.914 117.965  -1.712  1.00 27.84           O  
ATOM   1504  NE2 GLN    34      27.915 118.043  -0.686  1.00 25.01           N  
ATOM   1505  N   GLU    35      28.110 112.897  -3.418  1.00 26.05           N  
ATOM   1506  CA  GLU    35      29.062 111.870  -3.000  1.00 26.79           C  
ATOM   1507  C   GLU    35      29.880 111.409  -4.199  1.00 25.76           C  
ATOM   1508  O   GLU    35      31.100 111.373  -4.133  1.00 29.58           O  
ATOM   1509  CB  GLU    35      28.334 110.656  -2.403  1.00 29.07           C  
ATOM   1510  CG  GLU    35      27.663 110.859  -1.026  1.00 36.40           C  
ATOM   1511  CD  GLU    35      28.639 110.840   0.162  1.00 37.35           C  
ATOM   1512  OE1 GLU    35      29.592 110.019   0.147  1.00 43.71           O  
ATOM   1513  OE2 GLU    35      28.432 111.628   1.113  1.00 32.55           O  
ATOM   1514  N   LEU    36      29.208 111.060  -5.295  1.00 26.54           N  
ATOM   1515  CA  LEU    36      29.903 110.588  -6.490  1.00 26.53           C  
ATOM   1516  C   LEU    36      30.739 111.666  -7.179  1.00 28.82           C  
ATOM   1517  O   LEU    36      31.847 111.390  -7.651  1.00 31.06           O  
ATOM   1518  CB  LEU    36      28.903 110.000  -7.492  1.00 23.33           C  
ATOM   1519  CG  LEU    36      28.105 108.784  -7.009  1.00 21.17           C  
ATOM   1520  CD1 LEU    36      27.061 108.392  -8.037  1.00 17.04           C  
ATOM   1521  CD2 LEU    36      29.055 107.639  -6.741  1.00 15.12           C  
ATOM   1522  N   LEU    37      30.226 112.892  -7.233  1.00 28.20           N  
ATOM   1523  CA  LEU    37      30.951 113.965  -7.903  1.00 26.01           C  
ATOM   1524  C   LEU    37      32.174 114.388  -7.145  1.00 27.22           C  
ATOM   1525  O   LEU    37      33.140 114.872  -7.723  1.00 35.05           O  
ATOM   1526  CB  LEU    37      30.037 115.164  -8.129  1.00 22.95           C  
ATOM   1527  CG  LEU    37      29.266 115.054  -9.444  1.00 25.96           C  
ATOM   1528  CD1 LEU    37      28.166 116.104  -9.505  1.00 26.27           C  
ATOM   1529  CD2 LEU    37      30.239 115.215 -10.598  1.00 23.53           C  
ATOM   1530  N   THR    38      32.145 114.208  -5.839  1.00 30.01           N  
ATOM   1531  CA  THR    38      33.278 114.604  -5.031  1.00 29.62           C  
ATOM   1532  C   THR    38      34.364 113.523  -5.108  1.00 31.54           C  
ATOM   1533  O   THR    38      35.555 113.819  -5.059  1.00 32.59           O  
ATOM   1534  CB  THR    38      32.815 114.860  -3.582  1.00 28.57           C  
ATOM   1535  OG1 THR    38      33.935 115.191  -2.766  1.00 35.34           O  
ATOM   1536  CG2 THR    38      32.128 113.640  -3.015  1.00 33.85           C  
ATOM   1537  N   THR    39      33.956 112.269  -5.273  1.00 32.57           N  
ATOM   1538  CA  THR    39      34.921 111.183  -5.366  1.00 34.34           C  
ATOM   1539  C   THR    39      35.467 110.987  -6.789  1.00 36.96           C  
ATOM   1540  O   THR    39      36.640 110.662  -6.964  1.00 37.38           O  
ATOM   1541  CB  THR    39      34.297 109.864  -4.860  1.00 32.96           C  
ATOM   1542  OG1 THR    39      34.062 109.962  -3.448  1.00 33.25           O  
ATOM   1543  CG2 THR    39      35.223 108.689  -5.130  1.00 31.22           C  
ATOM   1544  N   PHE    40      34.629 111.219  -7.798  1.00 38.57           N  
ATOM   1545  CA  PHE    40      35.027 111.035  -9.193  1.00 37.31           C  
ATOM   1546  C   PHE    40      34.988 112.301 -10.047  1.00 41.01           C  
ATOM   1547  O   PHE    40      34.757 112.234 -11.260  1.00 41.00           O  
ATOM   1548  CB  PHE    40      34.125 109.981  -9.832  1.00 31.99           C  
ATOM   1549  CG  PHE    40      34.123 108.678  -9.107  1.00 28.82           C  
ATOM   1550  CD1 PHE    40      33.048 108.312  -8.313  1.00 30.11           C  
ATOM   1551  CD2 PHE    40      35.207 107.812  -9.218  1.00 29.42           C  
ATOM   1552  CE1 PHE    40      33.043 107.088  -7.632  1.00 31.64           C  
ATOM   1553  CE2 PHE    40      35.224 106.590  -8.552  1.00 28.90           C  
ATOM   1554  CZ  PHE    40      34.136 106.225  -7.755  1.00 31.86           C  
ATOM   1555  N   GLU    41      35.225 113.450  -9.421  1.00 45.20           N  
ATOM   1556  CA  GLU    41      35.182 114.735 -10.121  1.00 48.64           C  
ATOM   1557  C   GLU    41      36.149 114.795 -11.292  1.00 49.01           C  
ATOM   1558  O   GLU    41      35.863 115.413 -12.316  1.00 50.22           O  
ATOM   1559  CB  GLU    41      35.511 115.869  -9.150  1.00 52.34           C  
ATOM   1560  CG  GLU    41      36.906 115.767  -8.535  1.00 59.42           C  
ATOM   1561  CD  GLU    41      37.721 117.041  -8.730  1.00 62.86           C  
ATOM   1562  OE1 GLU    41      37.987 117.406  -9.897  1.00 67.41           O  
ATOM   1563  OE2 GLU    41      38.091 117.680  -7.720  1.00 62.22           O  
ATOM   1564  N   THR    42      37.296 114.147 -11.132  1.00 49.32           N  
ATOM   1565  CA  THR    42      38.323 114.141 -12.162  1.00 47.61           C  
ATOM   1566  C   THR    42      38.082 113.124 -13.296  1.00 45.33           C  
ATOM   1567  O   THR    42      38.704 113.205 -14.353  1.00 42.19           O  
ATOM   1568  CB  THR    42      39.717 113.917 -11.511  1.00 48.23           C  
ATOM   1569  OG1 THR    42      40.556 113.159 -12.394  1.00 51.39           O  
ATOM   1570  CG2 THR    42      39.571 113.193 -10.172  1.00 45.58           C  
ATOM   1571  N   GLU    43      37.163 112.187 -13.092  1.00 44.51           N  
ATOM   1572  CA  GLU    43      36.878 111.187 -14.111  1.00 41.57           C  
ATOM   1573  C   GLU    43      35.505 111.365 -14.752  1.00 41.52           C  
ATOM   1574  O   GLU    43      35.196 110.736 -15.766  1.00 44.39           O  
ATOM   1575  CB  GLU    43      36.978 109.774 -13.522  1.00 43.81           C  
ATOM   1576  CG  GLU    43      38.375 109.344 -13.093  1.00 53.78           C  
ATOM   1577  CD  GLU    43      38.797 109.903 -11.741  1.00 59.81           C  
ATOM   1578  OE1 GLU    43      39.949 109.648 -11.322  1.00 66.31           O  
ATOM   1579  OE2 GLU    43      37.982 110.588 -11.090  1.00 67.02           O  
ATOM   1580  N   LEU    44      34.673 112.220 -14.170  1.00 40.18           N  
ATOM   1581  CA  LEU    44      33.338 112.435 -14.719  1.00 37.50           C  
ATOM   1582  C   LEU    44      33.211 113.728 -15.512  1.00 37.96           C  
ATOM   1583  O   LEU    44      33.648 114.791 -15.063  1.00 40.45           O  
ATOM   1584  CB  LEU    44      32.297 112.438 -13.597  1.00 32.21           C  
ATOM   1585  CG  LEU    44      32.195 111.167 -12.766  1.00 27.84           C  
ATOM   1586  CD1 LEU    44      31.086 111.322 -11.751  1.00 26.62           C  
ATOM   1587  CD2 LEU    44      31.923 109.984 -13.679  1.00 30.90           C  
ATOM   1588  N   THR    45      32.611 113.621 -16.693  1.00 34.19           N  
ATOM   1589  CA  THR    45      32.384 114.771 -17.547  1.00 35.13           C  
ATOM   1590  C   THR    45      31.163 115.510 -16.998  1.00 34.08           C  
ATOM   1591  O   THR    45      31.064 116.733 -17.089  1.00 34.71           O  
ATOM   1592  CB  THR    45      32.115 114.349 -19.022  1.00 39.29           C  
ATOM   1593  OG1 THR    45      31.728 115.504 -19.780  1.00 42.07           O  
ATOM   1594  CG2 THR    45      31.009 113.302 -19.103  1.00 38.35           C  
ATOM   1595  N   GLU    46      30.231 114.745 -16.441  1.00 31.19           N  
ATOM   1596  CA  GLU    46      29.034 115.294 -15.824  1.00 36.59           C  
ATOM   1597  C   GLU    46      28.180 114.201 -15.196  1.00 35.80           C  
ATOM   1598  O   GLU    46      28.302 113.023 -15.539  1.00 34.74           O  
ATOM   1599  CB  GLU    46      28.188 116.098 -16.812  1.00 38.03           C  
ATOM   1600  CG  GLU    46      27.534 115.289 -17.895  1.00 48.23           C  
ATOM   1601  CD  GLU    46      26.618 116.141 -18.781  1.00 55.98           C  
ATOM   1602  OE1 GLU    46      27.057 117.229 -19.251  1.00 56.19           O  
ATOM   1603  OE2 GLU    46      25.460 115.710 -19.017  1.00 58.15           O  
ATOM   1604  N   LEU    47      27.333 114.605 -14.255  1.00 32.79           N  
ATOM   1605  CA  LEU    47      26.453 113.685 -13.564  1.00 25.19           C  
ATOM   1606  C   LEU    47      25.065 114.278 -13.677  1.00 24.20           C  
ATOM   1607  O   LEU    47      24.845 115.431 -13.315  1.00 27.81           O  
ATOM   1608  CB  LEU    47      26.876 113.559 -12.108  1.00 23.89           C  
ATOM   1609  CG  LEU    47      26.095 112.525 -11.313  1.00 18.31           C  
ATOM   1610  CD1 LEU    47      26.939 112.062 -10.138  1.00 19.78           C  
ATOM   1611  CD2 LEU    47      24.775 113.124 -10.866  1.00 16.98           C  
ATOM   1612  N   ALA    48      24.126 113.504 -14.198  1.00 22.62           N  
ATOM   1613  CA  ALA    48      22.771 114.015 -14.376  1.00 21.56           C  
ATOM   1614  C   ALA    48      21.717 113.392 -13.464  1.00 20.92           C  
ATOM   1615  O   ALA    48      21.806 112.222 -13.091  1.00 20.60           O  
ATOM   1616  CB  ALA    48      22.353 113.848 -15.836  1.00 14.97           C  
ATOM   1617  N   LEU    49      20.717 114.189 -13.104  1.00 20.06           N  
ATOM   1618  CA  LEU    49      19.621 113.702 -12.277  1.00 21.13           C  
ATOM   1619  C   LEU    49      18.387 113.657 -13.176  1.00 21.86           C  
ATOM   1620  O   LEU    49      17.997 114.671 -13.733  1.00 22.90           O  
ATOM   1621  CB  LEU    49      19.382 114.643 -11.084  1.00 17.94           C  
ATOM   1622  CG  LEU    49      20.515 114.711 -10.047  1.00 17.37           C  
ATOM   1623  CD1 LEU    49      20.426 115.992  -9.265  1.00 17.78           C  
ATOM   1624  CD2 LEU    49      20.453 113.519  -9.121  1.00 14.96           C  
ATOM   1625  N   LYS    50      17.803 112.477 -13.357  1.00 23.96           N  
ATOM   1626  CA  LYS    50      16.609 112.342 -14.183  1.00 24.56           C  
ATOM   1627  C   LYS    50      15.385 111.979 -13.356  1.00 24.08           C  
ATOM   1628  O   LYS    50      15.334 110.907 -12.746  1.00 29.13           O  
ATOM   1629  CB  LYS    50      16.805 111.260 -15.258  1.00 29.60           C  
ATOM   1630  CG  LYS    50      15.518 110.961 -16.062  1.00 38.16           C  
ATOM   1631  CD  LYS    50      15.671 109.851 -17.108  1.00 40.68           C  
ATOM   1632  CE  LYS    50      16.610 110.257 -18.251  1.00 51.82           C  
ATOM   1633  NZ  LYS    50      16.093 111.355 -19.139  1.00 48.44           N  
ATOM   1634  N   PRO    51      14.382 112.859 -13.325  1.00 22.59           N  
ATOM   1635  CA  PRO    51      13.176 112.554 -12.552  1.00 25.38           C  
ATOM   1636  C   PRO    51      12.553 111.288 -13.105  1.00 27.86           C  
ATOM   1637  O   PRO    51      12.436 111.141 -14.319  1.00 27.06           O  
ATOM   1638  CB  PRO    51      12.292 113.773 -12.794  1.00 27.38           C  
ATOM   1639  CG  PRO    51      13.281 114.886 -12.956  1.00 26.85           C  
ATOM   1640  CD  PRO    51      14.356 114.244 -13.825  1.00 23.65           C  
ATOM   1641  N   GLY    52      12.153 110.383 -12.216  1.00 32.91           N  
ATOM   1642  CA  GLY    52      11.559 109.127 -12.640  1.00 36.98           C  
ATOM   1643  C   GLY    52      10.123 108.903 -12.202  1.00 40.80           C  
ATOM   1644  O   GLY    52       9.546 109.714 -11.481  1.00 37.38           O  
ATOM   1645  N   THR    53       9.563 107.772 -12.632  1.00 48.76           N  
ATOM   1646  CA  THR    53       8.180 107.396 -12.341  1.00 52.36           C  
ATOM   1647  C   THR    53       7.897 107.011 -10.892  1.00 54.71           C  
ATOM   1648  O   THR    53       7.858 107.868 -10.003  1.00 60.21           O  
ATOM   1649  CB  THR    53       7.735 106.216 -13.217  1.00 56.86           C  
ATOM   1650  OG1 THR    53       8.252 106.378 -14.543  1.00 60.67           O  
ATOM   1651  CG2 THR    53       6.212 106.147 -13.273  1.00 58.18           C  
ATOM   1652  N   GLY    54       7.693 105.715 -10.664  1.00 47.98           N  
ATOM   1653  CA  GLY    54       7.372 105.247  -9.331  1.00 46.90           C  
ATOM   1654  C   GLY    54       8.318 104.226  -8.740  1.00 45.07           C  
ATOM   1655  O   GLY    54       8.611 103.199  -9.351  1.00 43.29           O  
ATOM   1656  N   GLY    55       8.793 104.522  -7.533  1.00 41.52           N  
ATOM   1657  CA  GLY    55       9.700 103.632  -6.839  1.00 36.31           C  
ATOM   1658  C   GLY    55      11.041 103.449  -7.516  1.00 32.35           C  
ATOM   1659  O   GLY    55      11.884 102.685  -7.053  1.00 34.97           O  
ATOM   1660  N   VAL    56      11.249 104.154  -8.611  1.00 28.59           N  
ATOM   1661  CA  VAL    56      12.494 104.043  -9.350  1.00 29.28           C  
ATOM   1662  C   VAL    56      13.697 104.764  -8.741  1.00 30.33           C  
ATOM   1663  O   VAL    56      13.624 105.938  -8.368  1.00 32.26           O  
ATOM   1664  CB  VAL    56      12.321 104.578 -10.786  1.00 30.24           C  
ATOM   1665  CG1 VAL    56      13.637 104.494 -11.543  1.00 15.34           C  
ATOM   1666  CG2 VAL    56      11.242 103.762 -11.508  1.00 40.19           C  
ATOM   1667  N   PHE    57      14.812 104.057  -8.638  1.00 26.67           N  
ATOM   1668  CA  PHE    57      16.029 104.677  -8.151  1.00 23.98           C  
ATOM   1669  C   PHE    57      17.193 103.910  -8.712  1.00 19.33           C  
ATOM   1670  O   PHE    57      17.634 102.940  -8.120  1.00 22.04           O  
ATOM   1671  CB  PHE    57      16.124 104.686  -6.624  1.00 26.86           C  
ATOM   1672  CG  PHE    57      17.181 105.632  -6.109  1.00 25.63           C  
ATOM   1673  CD1 PHE    57      16.853 106.919  -5.727  1.00 21.45           C  
ATOM   1674  CD2 PHE    57      18.522 105.278  -6.132  1.00 26.35           C  
ATOM   1675  CE1 PHE    57      17.838 107.832  -5.389  1.00 22.63           C  
ATOM   1676  CE2 PHE    57      19.513 106.203  -5.790  1.00 25.01           C  
ATOM   1677  CZ  PHE    57      19.162 107.472  -5.424  1.00 21.00           C  
ATOM   1678  N   VAL    58      17.701 104.340  -9.854  1.00 16.87           N  
ATOM   1679  CA  VAL    58      18.811 103.619 -10.449  1.00 16.50           C  
ATOM   1680  C   VAL    58      19.990 104.509 -10.803  1.00 14.74           C  
ATOM   1681  O   VAL    58      19.833 105.682 -11.099  1.00 19.25           O  
ATOM   1682  CB  VAL    58      18.336 102.803 -11.703  1.00 17.29           C  
ATOM   1683  CG1 VAL    58      17.143 103.480 -12.358  1.00 13.35           C  
ATOM   1684  CG2 VAL    58      19.480 102.662 -12.707  1.00 10.59           C  
ATOM   1685  N   VAL    59      21.181 103.944 -10.737  1.00 17.11           N  
ATOM   1686  CA  VAL    59      22.387 104.675 -11.069  1.00 14.59           C  
ATOM   1687  C   VAL    59      22.962 104.053 -12.337  1.00 18.14           C  
ATOM   1688  O   VAL    59      23.117 102.827 -12.434  1.00 18.37           O  
ATOM   1689  CB  VAL    59      23.442 104.565  -9.941  1.00 14.04           C  
ATOM   1690  CG1 VAL    59      24.705 105.319 -10.332  1.00 14.47           C  
ATOM   1691  CG2 VAL    59      22.881 105.116  -8.644  1.00 10.10           C  
ATOM   1692  N   ARG    60      23.275 104.900 -13.310  1.00 19.90           N  
ATOM   1693  CA  ARG    60      23.835 104.443 -14.582  1.00 22.68           C  
ATOM   1694  C   ARG    60      25.212 105.039 -14.826  1.00 26.21           C  
ATOM   1695  O   ARG    60      25.455 106.193 -14.495  1.00 30.19           O  
ATOM   1696  CB  ARG    60      22.913 104.835 -15.737  1.00 17.23           C  
ATOM   1697  CG  ARG    60      22.086 103.684 -16.262  1.00 28.18           C  
ATOM   1698  CD  ARG    60      21.105 104.151 -17.308  1.00 28.75           C  
ATOM   1699  NE  ARG    60      19.884 104.634 -16.674  1.00 32.77           N  
ATOM   1700  CZ  ARG    60      18.712 104.017 -16.761  1.00 32.20           C  
ATOM   1701  NH1 ARG    60      18.598 102.897 -17.463  1.00 36.11           N  
ATOM   1702  NH2 ARG    60      17.660 104.509 -16.130  1.00 32.88           N  
ATOM   1703  N   VAL    61      26.131 104.249 -15.369  1.00 26.06           N  
ATOM   1704  CA  VAL    61      27.463 104.762 -15.688  1.00 27.01           C  
ATOM   1705  C   VAL    61      27.661 104.437 -17.173  1.00 29.36           C  
ATOM   1706  O   VAL    61      27.682 103.262 -17.563  1.00 24.96           O  
ATOM   1707  CB  VAL    61      28.585 104.089 -14.844  1.00 28.99           C  
ATOM   1708  CG1 VAL    61      29.954 104.665 -15.242  1.00 25.18           C  
ATOM   1709  CG2 VAL    61      28.341 104.307 -13.370  1.00 24.83           C  
ATOM   1710  N   ASP    62      27.775 105.482 -17.993  1.00 29.70           N  
ATOM   1711  CA  ASP    62      27.935 105.318 -19.434  1.00 37.02           C  
ATOM   1712  C   ASP    62      26.786 104.488 -20.032  1.00 41.12           C  
ATOM   1713  O   ASP    62      27.016 103.520 -20.764  1.00 43.88           O  
ATOM   1714  CB  ASP    62      29.282 104.654 -19.732  1.00 38.18           C  
ATOM   1715  CG  ASP    62      30.466 105.553 -19.381  1.00 43.43           C  
ATOM   1716  OD1 ASP    62      31.534 105.021 -19.002  1.00 47.13           O  
ATOM   1717  OD2 ASP    62      30.341 106.795 -19.495  1.00 40.93           O  
ATOM   1718  N   ASP    63      25.553 104.870 -19.698  1.00 43.52           N  
ATOM   1719  CA  ASP    63      24.352 104.194 -20.181  1.00 43.34           C  
ATOM   1720  C   ASP    63      24.123 102.807 -19.583  1.00 42.44           C  
ATOM   1721  O   ASP    63      23.064 102.212 -19.780  1.00 40.82           O  
ATOM   1722  CB  ASP    63      24.383 104.108 -21.708  1.00 49.03           C  
ATOM   1723  CG  ASP    63      24.078 105.449 -22.377  1.00 56.96           C  
ATOM   1724  OD1 ASP    63      22.893 105.855 -22.397  1.00 62.08           O  
ATOM   1725  OD2 ASP    63      25.022 106.101 -22.880  1.00 60.23           O  
ATOM   1726  N   GLU    64      25.103 102.294 -18.847  1.00 43.04           N  
ATOM   1727  CA  GLU    64      24.972 100.970 -18.237  1.00 43.09           C  
ATOM   1728  C   GLU    64      24.517 101.046 -16.793  1.00 35.79           C  
ATOM   1729  O   GLU    64      25.144 101.718 -15.986  1.00 42.15           O  
ATOM   1730  CB  GLU    64      26.305 100.217 -18.330  1.00 48.93           C  
ATOM   1731  CG  GLU    64      26.543  99.569 -19.696  1.00 61.84           C  
ATOM   1732  CD  GLU    64      27.974  99.069 -19.869  1.00 73.08           C  
ATOM   1733  OE1 GLU    64      28.485  98.402 -18.928  1.00 78.01           O  
ATOM   1734  OE2 GLU    64      28.582  99.339 -20.946  1.00 71.08           O  
ATOM   1735  N   VAL    65      23.421 100.369 -16.469  1.00 27.63           N  
ATOM   1736  CA  VAL    65      22.921 100.387 -15.100  1.00 25.77           C  
ATOM   1737  C   VAL    65      23.882  99.655 -14.142  1.00 28.28           C  
ATOM   1738  O   VAL    65      24.226  98.485 -14.338  1.00 20.36           O  
ATOM   1739  CB  VAL    65      21.505  99.762 -14.994  1.00 25.81           C  
ATOM   1740  CG1 VAL    65      21.468  98.433 -15.735  1.00 35.04           C  
ATOM   1741  CG2 VAL    65      21.140  99.546 -13.525  1.00 14.82           C  
ATOM   1742  N   VAL    66      24.313 100.375 -13.108  1.00 27.20           N  
ATOM   1743  CA  VAL    66      25.237  99.852 -12.122  1.00 23.67           C  
ATOM   1744  C   VAL    66      24.561  99.598 -10.779  1.00 24.73           C  
ATOM   1745  O   VAL    66      25.038  98.789  -9.979  1.00 25.71           O  
ATOM   1746  CB  VAL    66      26.408 100.821 -11.961  1.00 24.07           C  
ATOM   1747  CG1 VAL    66      27.305 100.416 -10.806  1.00 25.95           C  
ATOM   1748  CG2 VAL    66      27.204 100.836 -13.246  1.00 19.62           C  
ATOM   1749  N   TRP    67      23.444 100.270 -10.531  1.00 26.59           N  
ATOM   1750  CA  TRP    67      22.721 100.071  -9.283  1.00 24.40           C  
ATOM   1751  C   TRP    67      21.243 100.265  -9.473  1.00 20.86           C  
ATOM   1752  O   TRP    67      20.817 101.260 -10.040  1.00 23.33           O  
ATOM   1753  CB  TRP    67      23.213 101.041  -8.211  1.00 26.08           C  
ATOM   1754  CG  TRP    67      22.669 100.721  -6.859  1.00 24.39           C  
ATOM   1755  CD1 TRP    67      21.405 100.967  -6.396  1.00 24.24           C  
ATOM   1756  CD2 TRP    67      23.368 100.083  -5.793  1.00 22.69           C  
ATOM   1757  NE1 TRP    67      21.277 100.526  -5.103  1.00 19.54           N  
ATOM   1758  CE2 TRP    67      22.468  99.981  -4.706  1.00 21.17           C  
ATOM   1759  CE3 TRP    67      24.669  99.590  -5.646  1.00 19.66           C  
ATOM   1760  CZ2 TRP    67      22.830  99.411  -3.493  1.00 19.53           C  
ATOM   1761  CZ3 TRP    67      25.029  99.026  -4.447  1.00 17.34           C  
ATOM   1762  CH2 TRP    67      24.113  98.941  -3.380  1.00 22.91           C  
ATOM   1763  N   ASP    68      20.463  99.303  -9.005  1.00 20.11           N  
ATOM   1764  CA  ASP    68      19.012  99.388  -9.099  1.00 25.74           C  
ATOM   1765  C   ASP    68      18.429  99.124  -7.711  1.00 27.04           C  
ATOM   1766  O   ASP    68      18.701  98.089  -7.106  1.00 34.40           O  
ATOM   1767  CB  ASP    68      18.484  98.352 -10.089  1.00 29.43           C  
ATOM   1768  CG  ASP    68      16.993  98.503 -10.359  1.00 37.13           C  
ATOM   1769  OD1 ASP    68      16.222  98.766  -9.405  1.00 40.64           O  
ATOM   1770  OD2 ASP    68      16.588  98.348 -11.531  1.00 40.24           O  
ATOM   1771  N   ARG    69      17.623 100.053  -7.215  1.00 27.74           N  
ATOM   1772  CA  ARG    69      17.017  99.922  -5.890  1.00 30.14           C  
ATOM   1773  C   ARG    69      16.300  98.595  -5.624  1.00 31.56           C  
ATOM   1774  O   ARG    69      16.653  97.873  -4.692  1.00 26.37           O  
ATOM   1775  CB  ARG    69      16.025 101.054  -5.647  1.00 26.47           C  
ATOM   1776  CG  ARG    69      15.642 101.191  -4.201  1.00 31.13           C  
ATOM   1777  CD  ARG    69      14.402 102.044  -4.005  1.00 36.14           C  
ATOM   1778  NE  ARG    69      13.230 101.218  -3.775  1.00 38.88           N  
ATOM   1779  CZ  ARG    69      12.604 100.525  -4.719  1.00 43.61           C  
ATOM   1780  NH1 ARG    69      11.542  99.782  -4.414  1.00 47.81           N  
ATOM   1781  NH2 ARG    69      13.021 100.587  -5.974  1.00 44.92           N  
ATOM   1782  N   ARG    70      15.288  98.280  -6.430  1.00 33.52           N  
ATOM   1783  CA  ARG    70      14.543  97.048  -6.223  1.00 41.98           C  
ATOM   1784  C   ARG    70      15.303  95.813  -6.667  1.00 42.00           C  
ATOM   1785  O   ARG    70      14.736  94.867  -7.195  1.00 44.92           O  
ATOM   1786  CB  ARG    70      13.157  97.116  -6.893  1.00 44.21           C  
ATOM   1787  CG  ARG    70      13.138  97.606  -8.309  1.00 51.43           C  
ATOM   1788  CD  ARG    70      13.527  96.536  -9.295  1.00 57.29           C  
ATOM   1789  NE  ARG    70      13.537  97.075 -10.653  1.00 67.22           N  
ATOM   1790  CZ  ARG    70      13.974  96.418 -11.720  1.00 67.47           C  
ATOM   1791  NH1 ARG    70      14.442  95.180 -11.591  1.00 62.93           N  
ATOM   1792  NH2 ARG    70      13.949  97.009 -12.914  1.00 71.38           N  
ATOM   1793  N   GLU    71      16.600  95.821  -6.407  1.00 42.39           N  
ATOM   1794  CA  GLU    71      17.453  94.714  -6.768  1.00 40.69           C  
ATOM   1795  C   GLU    71      18.616  94.666  -5.787  1.00 38.69           C  
ATOM   1796  O   GLU    71      19.081  93.593  -5.414  1.00 35.90           O  
ATOM   1797  CB  GLU    71      17.964  94.923  -8.186  1.00 45.75           C  
ATOM   1798  CG  GLU    71      19.151  94.072  -8.557  1.00 58.77           C  
ATOM   1799  CD  GLU    71      18.834  93.060  -9.651  1.00 65.31           C  
ATOM   1800  OE1 GLU    71      19.789  92.437 -10.187  1.00 67.06           O  
ATOM   1801  OE2 GLU    71      17.632  92.893  -9.969  1.00 67.56           O  
ATOM   1802  N   GLN    72      19.063  95.834  -5.342  1.00 34.65           N  
ATOM   1803  CA  GLN    72      20.190  95.896  -4.425  1.00 32.47           C  
ATOM   1804  C   GLN    72      19.918  96.791  -3.242  1.00 32.08           C  
ATOM   1805  O   GLN    72      20.809  97.042  -2.437  1.00 34.82           O  
ATOM   1806  CB  GLN    72      21.424  96.388  -5.173  1.00 33.17           C  
ATOM   1807  CG  GLN    72      21.362  96.051  -6.643  1.00 34.18           C  
ATOM   1808  CD  GLN    72      22.530  96.578  -7.405  1.00 36.48           C  
ATOM   1809  OE1 GLN    72      22.390  96.999  -8.548  1.00 37.61           O  
ATOM   1810  NE2 GLN    72      23.704  96.553  -6.786  1.00 41.14           N  
ATOM   1811  N   GLY    73      18.685  97.272  -3.136  1.00 31.96           N  
ATOM   1812  CA  GLY    73      18.331  98.142  -2.026  1.00 26.30           C  
ATOM   1813  C   GLY    73      18.884  99.562  -2.071  1.00 24.64           C  
ATOM   1814  O   GLY    73      19.304 100.066  -3.116  1.00 26.56           O  
ATOM   1815  N   PHE    74      18.877 100.203  -0.908  1.00 22.82           N  
ATOM   1816  CA  PHE    74      19.343 101.569  -0.754  1.00 23.62           C  
ATOM   1817  C   PHE    74      20.782 101.741  -1.240  1.00 25.52           C  
ATOM   1818  O   PHE    74      21.653 100.929  -0.939  1.00 21.83           O  
ATOM   1819  CB  PHE    74      19.235 102.005   0.713  1.00 17.63           C  
ATOM   1820  CG  PHE    74      19.596 103.436   0.930  1.00 22.39           C  
ATOM   1821  CD1 PHE    74      18.677 104.447   0.655  1.00 24.11           C  
ATOM   1822  CD2 PHE    74      20.897 103.786   1.276  1.00 24.27           C  
ATOM   1823  CE1 PHE    74      19.056 105.790   0.710  1.00 27.45           C  
ATOM   1824  CE2 PHE    74      21.290 105.123   1.336  1.00 25.44           C  
ATOM   1825  CZ  PHE    74      20.372 106.129   1.050  1.00 26.59           C  
ATOM   1826  N   PRO    75      21.047 102.814  -2.001  1.00 26.42           N  
ATOM   1827  CA  PRO    75      22.402 103.037  -2.506  1.00 30.62           C  
ATOM   1828  C   PRO    75      23.438 103.468  -1.465  1.00 32.60           C  
ATOM   1829  O   PRO    75      23.824 104.634  -1.416  1.00 33.82           O  
ATOM   1830  CB  PRO    75      22.190 104.085  -3.601  1.00 26.01           C  
ATOM   1831  CG  PRO    75      21.066 104.898  -3.041  1.00 31.94           C  
ATOM   1832  CD  PRO    75      20.118 103.838  -2.512  1.00 25.71           C  
ATOM   1833  N   GLU    76      23.886 102.523  -0.640  1.00 32.70           N  
ATOM   1834  CA  GLU    76      24.907 102.809   0.372  1.00 34.65           C  
ATOM   1835  C   GLU    76      26.147 103.377  -0.351  1.00 36.38           C  
ATOM   1836  O   GLU    76      26.734 102.719  -1.222  1.00 32.20           O  
ATOM   1837  CB  GLU    76      25.261 101.525   1.134  1.00 37.11           C  
ATOM   1838  CG  GLU    76      26.053 101.738   2.419  1.00 46.96           C  
ATOM   1839  CD  GLU    76      27.573 101.674   2.227  1.00 54.03           C  
ATOM   1840  OE1 GLU    76      28.284 102.503   2.854  1.00 53.38           O  
ATOM   1841  OE2 GLU    76      28.053 100.790   1.469  1.00 54.08           O  
ATOM   1842  N   PRO    77      26.573 104.599   0.028  1.00 37.27           N  
ATOM   1843  CA  PRO    77      27.723 105.284  -0.573  1.00 36.67           C  
ATOM   1844  C   PRO    77      28.926 104.417  -0.966  1.00 38.30           C  
ATOM   1845  O   PRO    77      29.356 104.407  -2.125  1.00 39.25           O  
ATOM   1846  CB  PRO    77      28.064 106.354   0.465  1.00 30.87           C  
ATOM   1847  CG  PRO    77      27.585 105.757   1.733  1.00 35.87           C  
ATOM   1848  CD  PRO    77      26.259 105.198   1.335  1.00 36.78           C  
ATOM   1849  N   THR    78      29.472 103.688  -0.009  1.00 36.96           N  
ATOM   1850  CA  THR    78      30.627 102.849  -0.288  1.00 40.65           C  
ATOM   1851  C   THR    78      30.379 101.830  -1.396  1.00 40.53           C  
ATOM   1852  O   THR    78      31.098 101.800  -2.398  1.00 40.71           O  
ATOM   1853  CB  THR    78      31.053 102.111   0.984  1.00 43.25           C  
ATOM   1854  OG1 THR    78      31.328 103.076   2.011  1.00 49.41           O  
ATOM   1855  CG2 THR    78      32.296 101.276   0.729  1.00 40.87           C  
ATOM   1856  N   ALA    79      29.363 100.991  -1.197  1.00 39.05           N  
ATOM   1857  CA  ALA    79      28.989  99.958  -2.157  1.00 30.95           C  
ATOM   1858  C   ALA    79      28.860 100.524  -3.559  1.00 30.87           C  
ATOM   1859  O   ALA    79      29.476 100.021  -4.495  1.00 32.07           O  
ATOM   1860  CB  ALA    79      27.674  99.326  -1.744  1.00 30.22           C  
ATOM   1861  N   VAL    80      28.056 101.573  -3.701  1.00 29.83           N  
ATOM   1862  CA  VAL    80      27.845 102.176  -5.008  1.00 32.09           C  
ATOM   1863  C   VAL    80      29.089 102.872  -5.550  1.00 31.24           C  
ATOM   1864  O   VAL    80      29.303 102.901  -6.760  1.00 33.15           O  
ATOM   1865  CB  VAL    80      26.639 103.166  -5.004  1.00 30.11           C  
ATOM   1866  CG1 VAL    80      26.846 104.240  -3.969  1.00 33.03           C  
ATOM   1867  CG2 VAL    80      26.468 103.776  -6.381  1.00 27.36           C  
ATOM   1868  N   LYS    81      29.922 103.424  -4.675  1.00 31.39           N  
ATOM   1869  CA  LYS    81      31.128 104.082  -5.165  1.00 31.48           C  
ATOM   1870  C   LYS    81      32.096 103.060  -5.727  1.00 31.99           C  
ATOM   1871  O   LYS    81      32.828 103.339  -6.673  1.00 34.67           O  
ATOM   1872  CB  LYS    81      31.805 104.914  -4.064  1.00 26.53           C  
ATOM   1873  CG  LYS    81      31.266 106.332  -4.022  1.00 31.15           C  
ATOM   1874  CD  LYS    81      32.104 107.272  -3.195  1.00 34.88           C  
ATOM   1875  CE  LYS    81      31.706 107.256  -1.727  1.00 36.99           C  
ATOM   1876  NZ  LYS    81      32.451 108.286  -0.938  1.00 35.32           N  
ATOM   1877  N   ARG    82      32.084 101.862  -5.162  1.00 34.10           N  
ATOM   1878  CA  ARG    82      32.978 100.825  -5.632  1.00 36.80           C  
ATOM   1879  C   ARG    82      32.578 100.319  -6.998  1.00 34.53           C  
ATOM   1880  O   ARG    82      33.438 100.082  -7.844  1.00 35.29           O  
ATOM   1881  CB  ARG    82      33.023  99.677  -4.638  1.00 44.18           C  
ATOM   1882  CG  ARG    82      34.369  99.584  -3.988  1.00 51.62           C  
ATOM   1883  CD  ARG    82      34.177  99.776  -2.469  1.00 55.04           C  
ATOM   1884  NE  ARG    82      34.057  98.421  -2.176  1.00 59.29           N  
ATOM   1885  CZ  ARG    82      33.233  97.547  -1.649  1.00 61.20           C  
ATOM   1886  NH1 ARG    82      32.044  97.651  -1.063  1.00 59.66           N  
ATOM   1887  NH2 ARG    82      33.675  96.365  -2.009  1.00 60.79           N  
ATOM   1888  N   LEU    83      31.274 100.160  -7.208  1.00 30.67           N  
ATOM   1889  CA  LEU    83      30.756  99.692  -8.490  1.00 30.34           C  
ATOM   1890  C   LEU    83      30.966 100.737  -9.566  1.00 29.94           C  
ATOM   1891  O   LEU    83      31.124 100.399 -10.738  1.00 31.06           O  
ATOM   1892  CB  LEU    83      29.268  99.369  -8.390  1.00 29.27           C  
ATOM   1893  CG  LEU    83      28.906  97.975  -7.870  1.00 29.71           C  
ATOM   1894  CD1 LEU    83      29.519  97.735  -6.500  1.00 37.64           C  
ATOM   1895  CD2 LEU    83      27.400  97.861  -7.795  1.00 32.00           C  
ATOM   1896  N   VAL    84      30.954 102.007  -9.170  1.00 29.27           N  
ATOM   1897  CA  VAL    84      31.168 103.107 -10.114  1.00 28.41           C  
ATOM   1898  C   VAL    84      32.658 103.201 -10.473  1.00 30.57           C  
ATOM   1899  O   VAL    84      33.006 103.503 -11.611  1.00 26.17           O  
ATOM   1900  CB  VAL    84      30.692 104.474  -9.525  1.00 28.14           C  
ATOM   1901  CG1 VAL    84      31.179 105.626 -10.402  1.00 23.12           C  
ATOM   1902  CG2 VAL    84      29.166 104.505  -9.432  1.00 23.83           C  
ATOM   1903  N   ARG    85      33.531 102.939  -9.500  1.00 35.11           N  
ATOM   1904  CA  ARG    85      34.964 102.990  -9.738  1.00 37.04           C  
ATOM   1905  C   ARG    85      35.376 101.886 -10.717  1.00 36.72           C  
ATOM   1906  O   ARG    85      36.238 102.089 -11.569  1.00 31.75           O  
ATOM   1907  CB  ARG    85      35.739 102.839  -8.427  1.00 37.33           C  
ATOM   1908  CG  ARG    85      37.244 102.921  -8.635  1.00 45.43           C  
ATOM   1909  CD  ARG    85      38.040 102.134  -7.605  1.00 50.86           C  
ATOM   1910  NE  ARG    85      37.550 100.814  -7.382  1.00 53.15           N  
ATOM   1911  CZ  ARG    85      37.365 100.069  -6.298  1.00 51.12           C  
ATOM   1912  NH1 ARG    85      36.886  98.880  -6.578  1.00 52.18           N  
ATOM   1913  NH2 ARG    85      37.595 100.408  -5.032  1.00 45.28           N  
ATOM   1914  N   ASP    86      34.747 100.722 -10.610  1.00 40.19           N  
ATOM   1915  CA  ASP    86      35.064  99.612 -11.499  1.00 41.80           C  
ATOM   1916  C   ASP    86      34.682  99.903 -12.946  1.00 44.13           C  
ATOM   1917  O   ASP    86      35.159  99.222 -13.843  1.00 48.91           O  
ATOM   1918  CB  ASP    86      34.357  98.328 -11.045  1.00 44.39           C  
ATOM   1919  CG  ASP    86      34.920  97.758  -9.741  1.00 50.17           C  
ATOM   1920  OD1 ASP    86      34.380  96.720  -9.274  1.00 49.93           O  
ATOM   1921  OD2 ASP    86      35.893  98.333  -9.188  1.00 49.54           O  
ATOM   1922  N   ARG    87      33.824 100.897 -13.179  1.00 46.76           N  
ATOM   1923  CA  ARG    87      33.407 101.250 -14.540  1.00 45.11           C  
ATOM   1924  C   ARG    87      34.408 102.233 -15.120  1.00 45.90           C  
ATOM   1925  O   ARG    87      34.480 102.426 -16.326  1.00 46.61           O  
ATOM   1926  CB  ARG    87      32.032 101.918 -14.546  1.00 48.07           C  
ATOM   1927  CG  ARG    87      31.023 101.391 -13.534  1.00 56.36           C  
ATOM   1928  CD  ARG    87      30.757  99.933 -13.732  1.00 52.84           C  
ATOM   1929  NE  ARG    87      30.517  99.635 -15.134  1.00 58.50           N  
ATOM   1930  CZ  ARG    87      30.047  98.471 -15.562  1.00 63.85           C  
ATOM   1931  NH1 ARG    87      29.853  98.261 -16.861  1.00 61.62           N  
ATOM   1932  NH2 ARG    87      29.763  97.520 -14.675  1.00 63.63           N  
ATOM   1933  N   VAL    88      35.172 102.872 -14.247  1.00 48.48           N  
ATOM   1934  CA  VAL    88      36.171 103.831 -14.690  1.00 49.97           C  
ATOM   1935  C   VAL    88      37.566 103.462 -14.145  1.00 57.00           C  
ATOM   1936  O   VAL    88      38.133 104.262 -13.352  1.00 57.96           O  
ATOM   1937  CB  VAL    88      35.804 105.249 -14.225  1.00 46.27           C  
ATOM   1938  CG1 VAL    88      36.625 106.273 -15.003  1.00 39.40           C  
ATOM   1939  CG2 VAL    88      34.310 105.489 -14.396  1.00 38.65           C  
END
