
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  180 ( 1377),  selected  180 , name 3col_A
# Molecule2: number of CA atoms  192 ( 1477),  selected  192 , name T0454.pdb
# PARAMETERS: 3col_A.T0454.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    N     7_A      D       5          3.332
LGA    K     8_A      C       6          3.013
LGA    Q     9_A      R       7          3.204
LGA    V    10_A      S       8          3.132
LGA    K    11_A      R       9          2.054
LGA    I    12_A      L      10          1.988
LGA    Q    13_A      M      11          2.529
LGA    D    14_A      E      12          1.951
LGA    A    15_A      V      13          1.564
LGA    V    16_A      A      14          2.153
LGA    A    17_A      T      15          2.176
LGA    A    18_A      E      16          1.648
LGA    I    19_A      L      17          1.674
LGA    I    20_A      F      18          2.761
LGA    L    21_A      A      19          3.459
LGA    A    22_A      Q      20          2.881
LGA    E    23_A      K      21          2.255
LGA    G    24_A      G      22          2.798
LGA    P    25_A      F      23          2.634
LGA    A    26_A      Y      24          1.477
LGA    G    27_A      G      25          1.266
LGA    V    28_A      V      26          1.701
LGA    S    29_A      S      27          1.935
LGA    T    30_A      I      28          1.661
LGA    T    31_A      R      29          1.536
LGA    K    32_A      E      30          1.120
LGA    V    33_A      L      31          0.823
LGA    A    34_A      A      32          0.927
LGA    K    35_A      Q      33          0.855
LGA    R    36_A      A      34          0.731
LGA    V    37_A      A      35          0.507
LGA    G    38_A      G      36          0.613
LGA    I    39_A      A      37          0.561
LGA    A    40_A      S      38          0.214
LGA    Q    41_A      I      39          0.986
LGA    S    42_A      S      40          1.141
LGA    N    43_A      M      41          0.993
LGA    V    44_A      I      42          1.126
LGA    Y    45_A      S      43          1.728
LGA    -       -      Y      44           -
LGA    L    46_A      H      45          1.015
LGA    Y    47_A      F      46          1.534
LGA    F    48_A      G      47          1.536
LGA    K    49_A      G      48          3.708
LGA    N    50_A      K      49          3.897
LGA    K    51_A      -       -           -
LGA    Q    52_A      E      50          3.269
LGA    A    53_A      G      51          2.984
LGA    L    54_A      L      52          2.736
LGA    I    55_A      Y      53          2.430
LGA    D    56_A      A      54          2.488
LGA    S    57_A      A      55          2.111
LGA    V    58_A      V      56          1.652
LGA    Y    59_A      L      57          1.593
LGA    A    60_A      Q      58          1.485
LGA    R    61_A      E      59          0.859
LGA    E    62_A      Q      60          0.937
LGA    T    63_A      F      61          1.312
LGA    N    64_A      A      62          1.136
LGA    R    65_A      C      63          4.024
LGA    I    66_A      F      64           #
LGA    L    67_A      G      65           #
LGA    S    68_A      Q      66          4.253
LGA    T    69_A      -       -           -
LGA    T    70_A      -       -           -
LGA    D    71_A      -       -           -
LGA    L    72_A      L      67          2.190
LGA    D    73_A      D      68          2.499
LGA    R    74_A      D      69          3.559
LGA    L    75_A      I      70          2.425
LGA    S    76_A      R      71          2.464
LGA    D    77_A      G      72          3.294
LGA    S    78_A      -       -           -
LGA    T    79_A      Q      73           #
LGA    I    80_A      A      74          3.678
LGA    D    81_A      G      75          3.069
LGA    -       -      D      76           -
LGA    V    82_A      P      77          2.277
LGA    T    83_A      L      78          1.522
LGA    T    84_A      A      79          0.844
LGA    R    85_A      V      80          2.166
LGA    I    86_A      M      81          2.101
LGA    R    87_A      T      82          1.070
LGA    L    88_A      A      83          1.455
LGA    Y    89_A      Y      84          2.042
LGA    V    90_A      L      85          1.395
LGA    Q    91_A      R      86          0.509
LGA    Q    92_A      W      87          1.748
LGA    V    93_A      T      88          1.547
LGA    Y    94_A      I      89          0.644
LGA    D    95_A      Q      90          1.995
LGA    Y    96_A      R      91          2.405
LGA    S    97_A      H      92          1.065
LGA    L    98_A      R      93          1.792
LGA    A    99_A      N      94          2.853
LGA    N   100_A      N      95          2.190
LGA    P   101_A      P      96          1.963
LGA    D   102_A      Q      97          2.357
LGA    S   103_A      L      98          2.116
LGA    L   104_A      L      99          2.057
LGA    T   105_A      R     100          2.258
LGA    I   106_A      F     101          2.736
LGA    I   107_A      Y     102          2.295
LGA    Q   108_A      T     103          1.774
LGA    Q   109_A      S     104          1.860
LGA    I   110_A      E     105          2.952
LGA    K   111_A      L     106          2.859
LGA    A   112_A      T     107          1.971
LGA    L   113_A      N     108          1.326
LGA    N   114_A      P     109          0.366
LGA    G   115_A      T     110           -
LGA    -       -      P     111           -
LGA    -       -      C     112           -
LGA    Q   116_A      F     113           #
LGA    -       -      A     114           -
LGA    -       -      A     115           -
LGA    -       -      I     116           -
LGA    -       -      V     117           -
LGA    -       -      S     118           -
LGA    -       -      P     119           -
LGA    -       -      A     120           -
LGA    -       -      I     121           -
LGA    D   124_A      A     122          3.520
LGA    A   125_A      S     123          3.716
LGA    D   126_A      V     124           #
LGA    P   127_A      -       -           -
LGA    N   128_A      -       -           -
LGA    N   129_A      -       -           -
LGA    I   130_A      -       -           -
LGA    V   131_A      -       -           -
LGA    A   132_A      I     125          3.250
LGA    N   133_A      R     126          3.636
LGA    L   134_A      L     127          2.366
LGA    L   135_A      L     128          1.135
LGA    T   136_A      A     129          1.875
LGA    A   137_A      E     130          1.656
LGA    A   138_A      S     131          2.188
LGA    I   139_A      I     132          2.412
LGA    D   140_A      E     133          1.018
LGA    A   141_A      A     134          2.581
LGA    -       -      G     135           -
LGA    K   142_A      M     136          2.457
LGA    -       -      T     137           -
LGA    -       -      R     138           -
LGA    -       -      G     139           -
LGA    -       -      L     140           -
LGA    -       -      F     141           -
LGA    V   143_A      R     142           #
LGA    I   144_A      R     143           -
LGA    -       -      D     144           -
LGA    K   145_A      L     145          5.008
LGA    Q   146_A      H     146          2.174
LGA    L   147_A      A     147          4.876
LGA    P   148_A      V     148          2.945
LGA    -       -      N     149           -
LGA    -       -      S     150           -
LGA    V   149_A      A     151          3.971
LGA    S   150_A      L     152          3.539
LGA    L   151_A      A     153          3.651
LGA    H   152_A      L     154          3.327
LGA    X   153_A      A     155          2.539
LGA    G   154_A      G     156          2.560
LGA    V   155_A      M     157          2.516
LGA    V   156_A      V     158          2.712
LGA    F   157_A      N     159          1.821
LGA    S   158_A      Y     160          2.001
LGA    T   159_A      F     161          2.008
LGA    I   160_A      F     162          3.352
LGA    H   161_A      L     163          3.471
LGA    T   162_A      S     164          3.150
LGA    H   163_A      -       -           -
LGA    T   164_A      -       -           -
LGA    T   165_A      T     165          3.930
LGA    N   166_A      L     166          4.333
LGA    I   167_A      -       -           -
LGA    S   168_A      -       -           -
LGA    K   169_A      -       -           -
LGA    G   170_A      A     167           #
LGA    -       -      T     168           -
LGA    R   171_A      E     169          3.166
LGA    -       -      G     170           -
LGA    -       -      L     171           -
LGA    -       -      T     172           -
LGA    Y   172_A      S     173          4.977
LGA    A   173_A      H     174           #
LGA    Q   174_A      S     175          2.192
LGA    D   175_A      P     176          4.571
LGA    Q   176_A      D     177           #
LGA    Y   177_A      -       -           -
LGA    T   178_A      Q     178          1.694
LGA    F   179_A      D     179          2.060
LGA    G   180_A      E     180          3.055
LGA    D   181_A      E     181          2.595
LGA    I   182_A      L     182          1.667
LGA    F   183_A      I     183          1.844
LGA    Q   184_A      R     184          3.733
LGA    X   185_A      Q     185          4.293
LGA    I   186_A      Y     186          3.022
LGA    W   187_A      V     187          2.495
LGA    D   188_A      A     188          4.098
LGA    A   189_A      I     189          4.786
LGA    X   190_A      F     190          3.479
LGA    K   191_A      T     191          2.950
LGA    Q   192_A      -       -           -
LGA    D   193_A      R     192           #
LGA    -       -      G     193           -
LGA    -       -      I     194           -
LGA    -       -      M     195           -
LGA    -       -      A     196           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  180  192    5.0    151    2.54    14.57     49.101     5.712

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.027871 * X  +  -0.884208 * Y  +  -0.466262 * Z  +  27.714590
  Y_new =   0.936056 * X  +   0.140580 * Y  +  -0.322547 * Z  +  -3.345378
  Z_new =   0.350745 * X  +  -0.445437 * Y  +   0.823750 * Z  + -17.473169 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.495708    2.645885  [ DEG:   -28.4020    151.5980 ]
  Theta =  -0.358367   -2.783226  [ DEG:   -20.5329   -159.4671 ]
  Phi   =   1.600563   -1.541030  [ DEG:    91.7055    -88.2945 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3col_A                                        
REMARK     2: T0454.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3col_A.T0454.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  180  192   5.0  151   2.54   14.57  49.101
REMARK  ---------------------------------------------------------- 
MOLECULE 3col_A
HEADER    TRANSCRIPTION REGULATOR                 28-MAR-08   3COL              
TITLE     CRYSTAL STRUCTURE OF PUTATIVE TRANSCRIPTION REGULATOR FROM            
TITLE    2 LACTOBACILLUS PLANTARUM                                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PUTATIVE TRANSCRIPTION REGULATOR;                          
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: LACTOBACILLUS PLANTARUM WCFS1;                  
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: WCFS1 / NCIMB 8826;                                          
SOURCE   5 ATCC: BAA-793;                                                       
SOURCE   6 GENE: LP_3090;                                                       
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)MAGIC;                            
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    TRANSCRIPTION REGULATOR, LACTOBACILLUS PLANTARUM,                     
KEYWDS   2 STRUCTURAL GENOMICS, PSI-2, PROTEIN STRUCTURE INITIATIVE,            
KEYWDS   3 MIDWEST CENTER FOR STRUCTURAL GENOMICS, MCSG, DNA-BINDING,           
KEYWDS   4 TRANSCRIPTION REGULATION                                             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    C.CHANG,L.BIGELOW,L.FREEMAN,A.JOACHIMIAK,MIDWEST CENTER FOR           
AUTHOR   2 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   1   08-APR-08 3COL    0                                                
JRNL        AUTH   C.CHANG,L.BIGELOW,L.FREEMAN,A.JOACHIMIAK                     
JRNL        TITL   CRYSTAL STRUCTURE OF PUTATIVE TRANSCRIPTION                  
JRNL        TITL 2 REGULATOR FROM LACTOBACILLUS PLANTARUM.                      
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.10 ANGSTROMS.                                          
DBREF  3COL A    1   193  UNP    Q88T92   Q88T92_LACPL     1    193             
DBREF  3COL B    1   193  UNP    Q88T92   Q88T92_LACPL     1    193             
SEQRES   1 A  196  SER ASN ALA MSE LYS LYS LYS ASP MSE ASN LYS GLN VAL          
SEQRES   2 A  196  LYS ILE GLN ASP ALA VAL ALA ALA ILE ILE LEU ALA GLU          
SEQRES   3 A  196  GLY PRO ALA GLY VAL SER THR THR LYS VAL ALA LYS ARG          
SEQRES   4 A  196  VAL GLY ILE ALA GLN SER ASN VAL TYR LEU TYR PHE LYS          
SEQRES   5 A  196  ASN LYS GLN ALA LEU ILE ASP SER VAL TYR ALA ARG GLU          
SEQRES   6 A  196  THR ASN ARG ILE LEU SER THR THR ASP LEU ASP ARG LEU          
SEQRES   7 A  196  SER ASP SER THR ILE ASP VAL THR THR ARG ILE ARG LEU          
SEQRES   8 A  196  TYR VAL GLN GLN VAL TYR ASP TYR SER LEU ALA ASN PRO          
SEQRES   9 A  196  ASP SER LEU THR ILE ILE GLN GLN ILE LYS ALA LEU ASN          
SEQRES  10 A  196  GLY GLN GLY MSE THR ILE SER ALA ALA ASP ALA ASP PRO          
SEQRES  11 A  196  ASN ASN ILE VAL ALA ASN LEU LEU THR ALA ALA ILE ASP          
SEQRES  12 A  196  ALA LYS VAL ILE LYS GLN LEU PRO VAL SER LEU HIS MSE          
SEQRES  13 A  196  GLY VAL VAL PHE SER THR ILE HIS THR HIS THR THR ASN          
SEQRES  14 A  196  ILE SER LYS GLY ARG TYR ALA GLN ASP GLN TYR THR PHE          
SEQRES  15 A  196  GLY ASP ILE PHE GLN MSE ILE TRP ASP ALA MSE LYS GLN          
SEQRES  16 A  196  ASP                                                          
SEQRES   1 B  196  SER ASN ALA MSE LYS LYS LYS ASP MSE ASN LYS GLN VAL          
SEQRES   2 B  196  LYS ILE GLN ASP ALA VAL ALA ALA ILE ILE LEU ALA GLU          
SEQRES   3 B  196  GLY PRO ALA GLY VAL SER THR THR LYS VAL ALA LYS ARG          
SEQRES   4 B  196  VAL GLY ILE ALA GLN SER ASN VAL TYR LEU TYR PHE LYS          
SEQRES   5 B  196  ASN LYS GLN ALA LEU ILE ASP SER VAL TYR ALA ARG GLU          
SEQRES   6 B  196  THR ASN ARG ILE LEU SER THR THR ASP LEU ASP ARG LEU          
SEQRES   7 B  196  SER ASP SER THR ILE ASP VAL THR THR ARG ILE ARG LEU          
SEQRES   8 B  196  TYR VAL GLN GLN VAL TYR ASP TYR SER LEU ALA ASN PRO          
SEQRES   9 B  196  ASP SER LEU THR ILE ILE GLN GLN ILE LYS ALA LEU ASN          
SEQRES  10 B  196  GLY GLN GLY MSE THR ILE SER ALA ALA ASP ALA ASP PRO          
SEQRES  11 B  196  ASN ASN ILE VAL ALA ASN LEU LEU THR ALA ALA ILE ASP          
SEQRES  12 B  196  ALA LYS VAL ILE LYS GLN LEU PRO VAL SER LEU HIS MSE          
SEQRES  13 B  196  GLY VAL VAL PHE SER THR ILE HIS THR HIS THR THR ASN          
SEQRES  14 B  196  ILE SER LYS GLY ARG TYR ALA GLN ASP GLN TYR THR PHE          
SEQRES  15 B  196  GLY ASP ILE PHE GLN MSE ILE TRP ASP ALA MSE LYS GLN          
SEQRES  16 B  196  ASP                                                          
HET    MSE  A 153      16                                                       
HET    MSE  A 185       8                                                       
HET    MSE  A 190       8                                                       
HET    MSE  B 153      16                                                       
HET    MSE  B 185       8                                                       
HET    MSE  B 190       8                                                       
HET    GOL  B 201       6                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     GOL GLYCEROL                                                         
FORMUL   1  MSE    6(C5 H11 N O2 SE)                                            
FORMUL   3  GOL    C3 H8 O3                                                     
FORMUL   4  HOH   *302(H2 O)                                                    
CRYST1   64.213   66.936   93.404  90.00  90.00  90.00 P 21 21 21    8          
ATOM      1  N   ASN A   7     -15.737  30.411   1.615  1.00 25.08           N  
ATOM      2  CA  ASN A   7     -15.842  30.711   0.147  1.00 24.73           C  
ATOM      3  C   ASN A   7     -16.751  31.917  -0.118  1.00 24.68           C  
ATOM      4  O   ASN A   7     -17.848  32.024   0.464  1.00 24.44           O  
ATOM      5  CB  ASN A   7     -16.336  29.479  -0.611  1.00 25.30           C  
ATOM      6  N   LYS A   8     -16.309  32.812  -0.996  0.50 24.23           N  
ATOM      8  CA  LYS A   8     -17.023  34.066  -1.222  0.50 23.78           C  
ATOM     10  C   LYS A   8     -18.433  33.847  -1.758  0.50 23.91           C  
ATOM     12  O   LYS A   8     -19.385  34.475  -1.288  0.50 23.81           O  
ATOM     14  CB  LYS A   8     -16.250  34.967  -2.178  0.50 23.58           C  
ATOM     16  CG  LYS A   8     -16.368  36.427  -1.836  0.50 22.52           C  
ATOM     18  CD  LYS A   8     -15.449  36.789  -0.675  0.50 20.72           C  
ATOM     20  CE  LYS A   8     -14.101  37.253  -1.179  0.50 19.67           C  
ATOM     22  NZ  LYS A   8     -13.522  38.303  -0.302  0.50 18.89           N  
ATOM     24  N   GLN A   9     -18.549  32.956  -2.742  1.00 23.81           N  
ATOM     25  CA  GLN A   9     -19.834  32.641  -3.372  1.00 23.87           C  
ATOM     26  C   GLN A   9     -20.824  32.209  -2.313  1.00 23.05           C  
ATOM     27  O   GLN A   9     -21.930  32.721  -2.258  1.00 22.11           O  
ATOM     28  CB  GLN A   9     -19.656  31.519  -4.395  1.00 24.17           C  
ATOM     29  CG  GLN A   9     -20.924  31.150  -5.150  1.00 25.75           C  
ATOM     30  CD  GLN A   9     -20.712  30.016  -6.159  1.00 25.37           C  
ATOM     31  OE1 GLN A   9     -19.934  29.087  -5.923  1.00 26.02           O  
ATOM     32  NE2 GLN A   9     -21.390  30.113  -7.306  1.00 26.54           N  
ATOM     33  N   VAL A  10     -20.403  31.278  -1.462  1.00 22.32           N  
ATOM     34  CA  VAL A  10     -21.242  30.773  -0.384  1.00 22.57           C  
ATOM     35  C   VAL A  10     -21.655  31.889   0.585  1.00 21.65           C  
ATOM     36  O   VAL A  10     -22.827  31.990   0.936  1.00 21.18           O  
ATOM     37  CB  VAL A  10     -20.546  29.639   0.341  1.00 22.78           C  
ATOM     38  CG1 VAL A  10     -21.290  29.246   1.624  1.00 24.31           C  
ATOM     39  CG2 VAL A  10     -20.404  28.444  -0.620  1.00 24.79           C  
ATOM     40  N   LYS A  11     -20.694  32.714   1.011  1.00 20.86           N  
ATOM     41  CA  LYS A  11     -20.988  33.901   1.831  1.00 20.46           C  
ATOM     42  C   LYS A  11     -22.019  34.801   1.171  1.00 19.29           C  
ATOM     43  O   LYS A  11     -22.928  35.320   1.838  1.00 18.80           O  
ATOM     44  CB  LYS A  11     -19.718  34.716   2.111  1.00 20.76           C  
ATOM     45  CG  LYS A  11     -18.769  34.053   3.119  1.00 23.74           C  
ATOM     46  CD  LYS A  11     -19.408  34.046   4.514  1.00 29.44           C  
ATOM     47  CE  LYS A  11     -18.827  32.977   5.447  1.00 32.20           C  
ATOM     48  NZ  LYS A  11     -19.302  33.199   6.848  1.00 34.21           N  
ATOM     49  N   ILE A  12     -21.878  34.987  -0.135  1.00 18.10           N  
ATOM     50  CA  ILE A  12     -22.866  35.773  -0.887  1.00 18.38           C  
ATOM     51  C   ILE A  12     -24.254  35.142  -0.957  1.00 17.72           C  
ATOM     52  O   ILE A  12     -25.259  35.817  -0.711  1.00 17.68           O  
ATOM     53  CB  ILE A  12     -22.344  36.138  -2.283  1.00 18.87           C  
ATOM     54  CG1 ILE A  12     -21.193  37.167  -2.160  1.00 19.65           C  
ATOM     55  CG2 ILE A  12     -23.464  36.731  -3.089  1.00 18.23           C  
ATOM     56  CD1 ILE A  12     -20.292  37.237  -3.367  1.00 21.68           C  
ATOM     57  N   GLN A  13     -24.319  33.847  -1.279  1.00 16.61           N  
ATOM     58  CA  GLN A  13     -25.580  33.137  -1.274  1.00 15.89           C  
ATOM     59  C   GLN A  13     -26.257  33.132   0.112  1.00 15.96           C  
ATOM     60  O   GLN A  13     -27.466  33.317   0.220  1.00 15.30           O  
ATOM     61  CB  GLN A  13     -25.345  31.707  -1.732  1.00 17.06           C  
ATOM     62  CG  GLN A  13     -24.918  31.576  -3.185  1.00 15.22           C  
ATOM     63  CD  GLN A  13     -24.569  30.132  -3.526  1.00 17.80           C  
ATOM     64  OE1 GLN A  13     -23.801  29.491  -2.828  1.00 19.91           O  
ATOM     65  NE2 GLN A  13     -25.152  29.620  -4.583  1.00 18.23           N  
ATOM     66  N   ASP A  14     -25.473  32.932   1.168  1.00 15.85           N  
ATOM     67  CA  ASP A  14     -26.015  32.995   2.533  1.00 15.89           C  
ATOM     68  C   ASP A  14     -26.616  34.363   2.818  1.00 15.50           C  
ATOM     69  O   ASP A  14     -27.694  34.455   3.403  1.00 15.53           O  
ATOM     70  CB  ASP A  14     -24.946  32.673   3.563  1.00 15.21           C  
ATOM     71  CG  ASP A  14     -24.608  31.207   3.607  1.00 17.33           C  
ATOM     72  OD1 ASP A  14     -25.311  30.391   2.944  1.00 21.24           O  
ATOM     73  OD2 ASP A  14     -23.655  30.864   4.330  1.00 20.37           O  
ATOM     74  N   ALA A  15     -25.919  35.417   2.403  1.00 15.66           N  
ATOM     75  CA  ALA A  15     -26.439  36.797   2.545  1.00 16.41           C  
ATOM     76  C   ALA A  15     -27.780  37.042   1.793  1.00 16.59           C  
ATOM     77  O   ALA A  15     -28.714  37.599   2.353  1.00 17.54           O  
ATOM     78  CB  ALA A  15     -25.403  37.774   2.079  1.00 15.59           C  
ATOM     79  N   VAL A  16     -27.861  36.616   0.528  1.00 16.24           N  
ATOM     80  CA  VAL A  16     -29.113  36.678  -0.259  1.00 16.09           C  
ATOM     81  C   VAL A  16     -30.230  35.937   0.468  1.00 16.55           C  
ATOM     82  O   VAL A  16     -31.345  36.435   0.546  1.00 16.81           O  
ATOM     83  CB  VAL A  16     -28.926  36.084  -1.703  1.00 16.51           C  
ATOM     84  CG1 VAL A  16     -30.260  36.022  -2.499  1.00 14.86           C  
ATOM     85  CG2 VAL A  16     -27.875  36.895  -2.493  1.00 15.46           C  
ATOM     86  N   ALA A  17     -29.936  34.740   0.988  1.00 16.07           N  
ATOM     87  CA  ALA A  17     -30.948  33.912   1.602  1.00 15.37           C  
ATOM     88  C   ALA A  17     -31.515  34.581   2.869  1.00 15.42           C  
ATOM     89  O   ALA A  17     -32.734  34.540   3.109  1.00 15.34           O  
ATOM     90  CB  ALA A  17     -30.395  32.513   1.882  1.00 15.49           C  
ATOM     91  N   ALA A  18     -30.636  35.211   3.657  1.00 15.33           N  
ATOM     92  CA  ALA A  18     -31.046  35.986   4.840  1.00 15.13           C  
ATOM     93  C   ALA A  18     -31.955  37.157   4.507  1.00 15.44           C  
ATOM     94  O   ALA A  18     -32.940  37.393   5.181  1.00 15.31           O  
ATOM     95  CB  ALA A  18     -29.806  36.478   5.638  1.00 15.09           C  
ATOM     96  N   ILE A  19     -31.591  37.917   3.485  1.00 16.30           N  
ATOM     97  CA  ILE A  19     -32.418  39.040   3.010  1.00 16.52           C  
ATOM     98  C   ILE A  19     -33.805  38.558   2.548  1.00 17.66           C  
ATOM     99  O   ILE A  19     -34.846  39.130   2.922  1.00 17.59           O  
ATOM    100  CB  ILE A  19     -31.703  39.819   1.853  1.00 16.35           C  
ATOM    101  CG1 ILE A  19     -30.433  40.510   2.371  1.00 15.46           C  
ATOM    102  CG2 ILE A  19     -32.665  40.840   1.210  1.00 15.28           C  
ATOM    103  CD1 ILE A  19     -29.480  40.979   1.237  1.00 15.64           C  
ATOM    104  N   ILE A  20     -33.820  37.501   1.745  1.00 17.72           N  
ATOM    105  CA  ILE A  20     -35.085  36.883   1.341  1.00 18.34           C  
ATOM    106  C   ILE A  20     -35.966  36.559   2.560  1.00 18.76           C  
ATOM    107  O   ILE A  20     -37.157  36.860   2.561  1.00 18.12           O  
ATOM    108  CB  ILE A  20     -34.855  35.630   0.426  1.00 18.27           C  
ATOM    109  CG1 ILE A  20     -34.211  36.076  -0.912  1.00 19.37           C  
ATOM    110  CG2 ILE A  20     -36.176  34.841   0.188  1.00 17.03           C  
ATOM    111  CD1 ILE A  20     -33.866  34.935  -1.880  1.00 18.60           C  
ATOM    112  N   LEU A  21     -35.381  35.965   3.605  1.00 19.71           N  
ATOM    113  CA  LEU A  21     -36.164  35.604   4.785  1.00 20.55           C  
ATOM    114  C   LEU A  21     -36.696  36.843   5.508  1.00 21.66           C  
ATOM    115  O   LEU A  21     -37.829  36.837   5.978  1.00 21.61           O  
ATOM    116  CB  LEU A  21     -35.360  34.718   5.731  1.00 20.72           C  
ATOM    117  CG  LEU A  21     -35.025  33.308   5.233  1.00 20.88           C  
ATOM    118  CD1 LEU A  21     -34.106  32.624   6.231  1.00 19.67           C  
ATOM    119  CD2 LEU A  21     -36.291  32.480   5.038  1.00 22.03           C  
ATOM    120  N   ALA A  22     -35.882  37.897   5.576  1.00 22.13           N  
ATOM    121  CA  ALA A  22     -36.248  39.153   6.257  1.00 23.69           C  
ATOM    122  C   ALA A  22     -37.136  40.093   5.414  1.00 24.52           C  
ATOM    123  O   ALA A  22     -38.070  40.693   5.939  1.00 23.64           O  
ATOM    124  CB  ALA A  22     -34.989  39.904   6.728  1.00 22.88           C  
ATOM    125  N   GLU A  23     -36.824  40.245   4.123  1.00 25.59           N  
ATOM    126  CA  GLU A  23     -37.554  41.224   3.299  1.00 26.95           C  
ATOM    127  C   GLU A  23     -38.205  40.669   2.033  1.00 26.61           C  
ATOM    128  O   GLU A  23     -38.784  41.436   1.255  1.00 27.09           O  
ATOM    129  CB  GLU A  23     -36.677  42.413   2.927  1.00 27.53           C  
ATOM    130  CG  GLU A  23     -35.841  42.991   4.047  1.00 31.73           C  
ATOM    131  CD  GLU A  23     -34.844  44.003   3.515  1.00 37.74           C  
ATOM    132  OE1 GLU A  23     -33.641  43.921   3.866  1.00 40.50           O  
ATOM    133  OE2 GLU A  23     -35.266  44.873   2.722  1.00 39.14           O  
ATOM    134  N   GLY A  24     -38.139  39.352   1.837  1.00 25.84           N  
ATOM    135  CA  GLY A  24     -38.568  38.761   0.579  1.00 24.87           C  
ATOM    136  C   GLY A  24     -37.591  39.032  -0.561  1.00 24.33           C  
ATOM    137  O   GLY A  24     -36.631  39.804  -0.412  1.00 24.77           O  
ATOM    138  N   PRO A  25     -37.822  38.398  -1.718  1.00 23.44           N  
ATOM    139  CA  PRO A  25     -36.912  38.526  -2.847  1.00 23.06           C  
ATOM    140  C   PRO A  25     -36.762  39.966  -3.344  1.00 22.30           C  
ATOM    141  O   PRO A  25     -35.692  40.359  -3.755  1.00 21.82           O  
ATOM    142  CB  PRO A  25     -37.562  37.638  -3.918  1.00 23.44           C  
ATOM    143  CG  PRO A  25     -38.425  36.735  -3.188  1.00 22.87           C  
ATOM    144  CD  PRO A  25     -38.948  37.506  -2.035  1.00 23.36           C  
ATOM    145  N   ALA A  26     -37.825  40.754  -3.250  1.00 22.37           N  
ATOM    146  CA  ALA A  26     -37.782  42.172  -3.619  1.00 22.38           C  
ATOM    147  C   ALA A  26     -36.752  42.975  -2.803  1.00 22.44           C  
ATOM    148  O   ALA A  26     -36.243  43.987  -3.276  1.00 22.91           O  
ATOM    149  CB  ALA A  26     -39.175  42.787  -3.525  1.00 22.15           C  
ATOM    150  N   GLY A  27     -36.424  42.508  -1.601  1.00 21.76           N  
ATOM    151  CA  GLY A  27     -35.446  43.192  -0.765  1.00 21.24           C  
ATOM    152  C   GLY A  27     -33.996  42.975  -1.189  1.00 20.80           C  
ATOM    153  O   GLY A  27     -33.114  43.683  -0.729  1.00 21.44           O  
ATOM    154  N   VAL A  28     -33.733  41.996  -2.050  1.00 20.04           N  
ATOM    155  CA  VAL A  28     -32.358  41.711  -2.483  1.00 20.06           C  
ATOM    156  C   VAL A  28     -31.783  42.829  -3.398  1.00 20.28           C  
ATOM    157  O   VAL A  28     -32.454  43.272  -4.333  1.00 19.71           O  
ATOM    158  CB  VAL A  28     -32.269  40.322  -3.180  1.00 20.05           C  
ATOM    159  CG1 VAL A  28     -30.875  40.058  -3.765  1.00 19.88           C  
ATOM    160  CG2 VAL A  28     -32.663  39.181  -2.202  1.00 20.19           C  
ATOM    161  N   SER A  29     -30.564  43.292  -3.099  1.00 19.62           N  
ATOM    162  CA  SER A  29     -29.815  44.171  -3.992  1.00 19.38           C  
ATOM    163  C   SER A  29     -28.340  43.831  -3.850  1.00 19.34           C  
ATOM    164  O   SER A  29     -27.919  43.309  -2.823  1.00 20.09           O  
ATOM    165  CB  SER A  29     -30.082  45.640  -3.667  1.00 19.84           C  
ATOM    166  OG  SER A  29     -29.336  46.071  -2.533  1.00 20.19           O  
ATOM    167  N   THR A  30     -27.561  44.077  -4.882  1.00 19.41           N  
ATOM    168  CA  THR A  30     -26.105  43.869  -4.806  1.00 19.81           C  
ATOM    169  C   THR A  30     -25.493  44.694  -3.652  1.00 20.17           C  
ATOM    170  O   THR A  30     -24.630  44.198  -2.907  1.00 20.02           O  
ATOM    171  CB  THR A  30     -25.442  44.210  -6.154  1.00 20.50           C  
ATOM    172  OG1 THR A  30     -26.021  43.366  -7.173  1.00 22.17           O  
ATOM    173  CG2 THR A  30     -23.906  43.989  -6.110  1.00 19.05           C  
ATOM    174  N   THR A  31     -25.959  45.928  -3.484  1.00 18.94           N  
ATOM    175  CA  THR A  31     -25.447  46.803  -2.418  1.00 20.21           C  
ATOM    176  C   THR A  31     -25.680  46.192  -1.032  1.00 20.21           C  
ATOM    177  O   THR A  31     -24.747  46.092  -0.221  1.00 20.33           O  
ATOM    178  CB  THR A  31     -26.092  48.201  -2.472  1.00 19.07           C  
ATOM    179  OG1 THR A  31     -25.642  48.867  -3.664  1.00 22.49           O  
ATOM    180  CG2 THR A  31     -25.677  49.012  -1.291  1.00 19.85           C  
ATOM    181  N   LYS A  32     -26.928  45.801  -0.775  1.00 20.36           N  
ATOM    182  CA  LYS A  32     -27.313  45.192   0.498  1.00 21.19           C  
ATOM    183  C   LYS A  32     -26.522  43.887   0.728  1.00 20.16           C  
ATOM    184  O   LYS A  32     -26.051  43.608   1.848  1.00 20.85           O  
ATOM    185  CB  LYS A  32     -28.821  44.930   0.481  1.00 21.11           C  
ATOM    186  CG  LYS A  32     -29.518  45.116   1.814  1.00 24.87           C  
ATOM    187  CD  LYS A  32     -31.002  44.713   1.719  1.00 23.67           C  
ATOM    188  CE  LYS A  32     -31.870  45.905   1.314  1.00 27.79           C  
ATOM    189  NZ  LYS A  32     -33.324  45.529   1.373  1.00 29.54           N  
ATOM    190  N   VAL A  33     -26.360  43.092  -0.319  1.00 18.49           N  
ATOM    191  CA  VAL A  33     -25.639  41.812  -0.201  1.00 18.56           C  
ATOM    192  C   VAL A  33     -24.185  42.081   0.177  1.00 18.73           C  
ATOM    193  O   VAL A  33     -23.647  41.462   1.095  1.00 20.44           O  
ATOM    194  CB  VAL A  33     -25.778  40.939  -1.520  1.00 18.87           C  
ATOM    195  CG1 VAL A  33     -24.677  39.846  -1.637  1.00 18.37           C  
ATOM    196  CG2 VAL A  33     -27.145  40.331  -1.589  1.00 16.86           C  
ATOM    197  N   ALA A  34     -23.563  43.034  -0.510  1.00 18.16           N  
ATOM    198  CA  ALA A  34     -22.183  43.396  -0.271  1.00 18.07           C  
ATOM    199  C   ALA A  34     -21.965  43.893   1.158  1.00 18.41           C  
ATOM    200  O   ALA A  34     -20.970  43.538   1.772  1.00 17.76           O  
ATOM    201  CB  ALA A  34     -21.720  44.441  -1.291  1.00 17.34           C  
ATOM    202  N   LYS A  35     -22.889  44.717   1.671  1.00 18.62           N  
ATOM    203  CA  LYS A  35     -22.814  45.229   3.039  1.00 19.39           C  
ATOM    204  C   LYS A  35     -22.894  44.095   4.077  1.00 19.94           C  
ATOM    205  O   LYS A  35     -22.125  44.060   5.031  1.00 19.39           O  
ATOM    206  CB  LYS A  35     -23.908  46.289   3.283  1.00 20.09           C  
ATOM    207  N   ARG A  36     -23.792  43.142   3.852  1.00 19.90           N  
ATOM    208  CA  ARG A  36     -23.893  41.969   4.708  1.00 20.94           C  
ATOM    209  C   ARG A  36     -22.628  41.090   4.750  1.00 20.05           C  
ATOM    210  O   ARG A  36     -22.215  40.640   5.824  1.00 19.57           O  
ATOM    211  CB  ARG A  36     -25.091  41.116   4.299  1.00 20.73           C  
ATOM    212  CG  ARG A  36     -26.381  41.544   4.959  1.00 25.99           C  
ATOM    213  CD  ARG A  36     -27.523  40.661   4.483  1.00 32.10           C  
ATOM    214  NE  ARG A  36     -28.760  40.956   5.204  1.00 37.72           N  
ATOM    215  CZ  ARG A  36     -29.136  40.379   6.340  1.00 39.04           C  
ATOM    216  NH1 ARG A  36     -28.369  39.465   6.937  1.00 39.09           N  
ATOM    217  NH2 ARG A  36     -30.292  40.730   6.876  1.00 42.35           N  
ATOM    218  N   VAL A  37     -22.034  40.852   3.584  1.00 19.20           N  
ATOM    219  CA  VAL A  37     -20.852  40.007   3.474  1.00 18.57           C  
ATOM    220  C   VAL A  37     -19.614  40.759   3.963  1.00 19.46           C  
ATOM    221  O   VAL A  37     -18.687  40.139   4.469  1.00 20.21           O  
ATOM    222  CB  VAL A  37     -20.664  39.430   2.035  1.00 18.77           C  
ATOM    223  CG1 VAL A  37     -19.412  38.563   1.943  1.00 17.67           C  
ATOM    224  CG2 VAL A  37     -21.871  38.578   1.650  1.00 15.56           C  
ATOM    225  N   GLY A  38     -19.619  42.087   3.836  1.00 18.87           N  
ATOM    226  CA  GLY A  38     -18.483  42.891   4.204  1.00 19.26           C  
ATOM    227  C   GLY A  38     -17.458  43.063   3.097  1.00 19.78           C  
ATOM    228  O   GLY A  38     -16.264  43.260   3.374  1.00 18.50           O  
ATOM    229  N   ILE A  39     -17.918  43.017   1.847  1.00 19.62           N  
ATOM    230  CA  ILE A  39     -17.040  43.222   0.702  1.00 20.16           C  
ATOM    231  C   ILE A  39     -17.559  44.350  -0.193  1.00 20.66           C  
ATOM    232  O   ILE A  39     -18.698  44.786  -0.041  1.00 21.33           O  
ATOM    233  CB  ILE A  39     -16.878  41.913  -0.143  1.00 20.52           C  
ATOM    234  CG1 ILE A  39     -18.252  41.376  -0.617  1.00 21.15           C  
ATOM    235  CG2 ILE A  39     -16.104  40.848   0.640  1.00 21.49           C  
ATOM    236  CD1 ILE A  39     -18.176  40.019  -1.380  1.00 19.54           C  
ATOM    237  N   ALA A  40     -16.729  44.795  -1.134  1.00 20.42           N  
ATOM    238  CA  ALA A  40     -17.119  45.758  -2.176  1.00 20.73           C  
ATOM    239  C   ALA A  40     -18.171  45.186  -3.132  1.00 20.96           C  
ATOM    240  O   ALA A  40     -18.226  43.967  -3.344  1.00 20.48           O  
ATOM    241  CB  ALA A  40     -15.891  46.192  -2.970  1.00 20.07           C  
ATOM    242  N   GLN A  41     -18.996  46.063  -3.713  1.00 21.52           N  
ATOM    243  CA  GLN A  41     -19.999  45.617  -4.705  1.00 23.13           C  
ATOM    244  C   GLN A  41     -19.343  44.994  -5.938  1.00 22.72           C  
ATOM    245  O   GLN A  41     -19.863  44.011  -6.512  1.00 23.21           O  
ATOM    246  CB  GLN A  41     -20.880  46.776  -5.131  1.00 23.83           C  
ATOM    247  CG  GLN A  41     -21.765  47.282  -4.011  1.00 27.45           C  
ATOM    248  CD  GLN A  41     -22.482  48.548  -4.390  1.00 32.67           C  
ATOM    249  OE1 GLN A  41     -22.651  49.450  -3.571  1.00 32.96           O  
ATOM    250  NE2 GLN A  41     -22.907  48.630  -5.646  1.00 35.81           N  
ATOM    251  N   SER A  42     -18.199  45.569  -6.312  1.00 21.92           N  
ATOM    252  CA  SER A  42     -17.356  45.063  -7.386  1.00 21.39           C  
ATOM    253  C   SER A  42     -16.984  43.603  -7.149  1.00 21.06           C  
ATOM    254  O   SER A  42     -16.908  42.836  -8.104  1.00 20.72           O  
ATOM    255  CB  SER A  42     -16.082  45.907  -7.517  1.00 21.96           C  
ATOM    256  OG  SER A  42     -15.167  45.686  -6.449  1.00 20.90           O  
ATOM    257  N   ASN A  43     -16.749  43.242  -5.879  1.00 19.90           N  
ATOM    258  CA  ASN A  43     -16.454  41.866  -5.514  1.00 19.68           C  
ATOM    259  C   ASN A  43     -17.664  40.961  -5.788  1.00 19.06           C  
ATOM    260  O   ASN A  43     -17.512  39.802  -6.196  1.00 19.10           O  
ATOM    261  CB  ASN A  43     -16.057  41.767  -4.032  1.00 19.76           C  
ATOM    262  CG  ASN A  43     -15.059  40.610  -3.745  1.00 20.93           C  
ATOM    263  OD1 ASN A  43     -14.379  40.605  -2.713  1.00 19.99           O  
ATOM    264  ND2 ASN A  43     -14.982  39.638  -4.651  1.00 22.61           N  
ATOM    265  N   VAL A  44     -18.857  41.501  -5.558  1.00 18.38           N  
ATOM    266  CA  VAL A  44     -20.092  40.740  -5.739  1.00 17.89           C  
ATOM    267  C   VAL A  44     -20.311  40.578  -7.238  1.00 17.94           C  
ATOM    268  O   VAL A  44     -20.721  39.512  -7.713  1.00 17.95           O  
ATOM    269  CB  VAL A  44     -21.328  41.401  -5.007  1.00 17.78           C  
ATOM    270  CG1 VAL A  44     -22.647  40.694  -5.368  1.00 17.73           C  
ATOM    271  CG2 VAL A  44     -21.144  41.401  -3.477  1.00 16.82           C  
ATOM    272  N   TYR A  45     -19.991  41.617  -8.001  1.00 18.59           N  
ATOM    273  CA  TYR A  45     -20.226  41.556  -9.435  1.00 18.99           C  
ATOM    274  C   TYR A  45     -19.296  40.587 -10.184  1.00 19.65           C  
ATOM    275  O   TYR A  45     -19.533  40.267 -11.365  1.00 20.22           O  
ATOM    276  CB  TYR A  45     -20.160  42.944 -10.036  1.00 19.52           C  
ATOM    277  CG  TYR A  45     -21.388  43.801  -9.778  1.00 19.18           C  
ATOM    278  CD1 TYR A  45     -22.668  43.394 -10.187  1.00 17.03           C  
ATOM    279  CD2 TYR A  45     -21.260  45.027  -9.146  1.00 21.34           C  
ATOM    280  CE1 TYR A  45     -23.780  44.195  -9.962  1.00 18.14           C  
ATOM    281  CE2 TYR A  45     -22.370  45.852  -8.932  1.00 21.39           C  
ATOM    282  CZ  TYR A  45     -23.613  45.436  -9.348  1.00 19.78           C  
ATOM    283  OH  TYR A  45     -24.678  46.268  -9.097  1.00 19.32           O  
ATOM    284  N   LEU A  46     -18.253  40.095  -9.521  1.00 19.57           N  
ATOM    285  CA  LEU A  46     -17.380  39.099 -10.185  1.00 19.96           C  
ATOM    286  C   LEU A  46     -18.078  37.760 -10.321  1.00 20.32           C  
ATOM    287  O   LEU A  46     -17.721  36.946 -11.173  1.00 20.93           O  
ATOM    288  CB  LEU A  46     -16.084  38.872  -9.397  1.00 19.02           C  
ATOM    289  CG  LEU A  46     -15.048  39.977  -9.316  1.00 17.40           C  
ATOM    290  CD1 LEU A  46     -13.962  39.541  -8.319  1.00 16.36           C  
ATOM    291  CD2 LEU A  46     -14.450  40.304 -10.684  1.00 15.36           C  
ATOM    292  N   TYR A  47     -19.058  37.541  -9.450  1.00 20.96           N  
ATOM    293  CA  TYR A  47     -19.708  36.246  -9.296  1.00 21.34           C  
ATOM    294  C   TYR A  47     -21.145  36.255  -9.805  1.00 20.90           C  
ATOM    295  O   TYR A  47     -21.635  35.215 -10.271  1.00 20.77           O  
ATOM    296  CB  TYR A  47     -19.671  35.822  -7.851  1.00 21.30           C  
ATOM    297  N   PHE A  48     -21.806  37.412  -9.691  1.00 20.10           N  
ATOM    298  CA  PHE A  48     -23.225  37.573 -10.054  1.00 20.13           C  
ATOM    299  C   PHE A  48     -23.436  38.910 -10.766  1.00 19.42           C  
ATOM    300  O   PHE A  48     -23.051  39.952 -10.248  1.00 20.76           O  
ATOM    301  CB  PHE A  48     -24.128  37.501  -8.789  1.00 20.20           C  
ATOM    302  CG  PHE A  48     -23.930  36.236  -7.967  1.00 20.45           C  
ATOM    303  CD1 PHE A  48     -24.609  35.071  -8.276  1.00 21.26           C  
ATOM    304  CD2 PHE A  48     -23.029  36.214  -6.896  1.00 21.14           C  
ATOM    305  CE1 PHE A  48     -24.395  33.901  -7.524  1.00 21.52           C  
ATOM    306  CE2 PHE A  48     -22.830  35.065  -6.143  1.00 22.11           C  
ATOM    307  CZ  PHE A  48     -23.521  33.913  -6.456  1.00 21.17           C  
ATOM    308  N   LYS A  49     -24.091  38.909 -11.911  1.00 18.81           N  
ATOM    309  CA  LYS A  49     -24.166  40.137 -12.713  1.00 19.50           C  
ATOM    310  C   LYS A  49     -25.212  41.147 -12.252  1.00 18.42           C  
ATOM    311  O   LYS A  49     -25.118  42.336 -12.567  1.00 17.41           O  
ATOM    312  CB  LYS A  49     -24.294  39.835 -14.215  1.00 19.95           C  
ATOM    313  CG  LYS A  49     -25.562  39.124 -14.662  1.00 21.60           C  
ATOM    314  CD  LYS A  49     -25.702  39.236 -16.237  1.00 21.66           C  
ATOM    315  CE  LYS A  49     -24.726  38.295 -16.972  1.00 22.91           C  
ATOM    316  NZ  LYS A  49     -24.280  38.776 -18.323  1.00 21.81           N  
ATOM    317  N   ASN A  50     -26.195  40.678 -11.491  1.00 18.51           N  
ATOM    318  CA  ASN A  50     -27.296  41.559 -11.020  1.00 18.12           C  
ATOM    319  C   ASN A  50     -28.154  40.892  -9.965  1.00 18.16           C  
ATOM    320  O   ASN A  50     -27.905  39.742  -9.629  1.00 18.59           O  
ATOM    321  CB  ASN A  50     -28.142  42.067 -12.212  1.00 17.44           C  
ATOM    322  CG  ASN A  50     -28.768  40.937 -13.058  1.00 16.95           C  
ATOM    323  OD1 ASN A  50     -28.959  39.813 -12.589  1.00 16.30           O  
ATOM    324  ND2 ASN A  50     -29.094  41.251 -14.317  1.00 12.94           N  
ATOM    325  N   LYS A  51     -29.156  41.610  -9.460  1.00 17.81           N  
ATOM    326  CA  LYS A  51     -30.057  41.139  -8.413  1.00 18.82           C  
ATOM    327  C   LYS A  51     -30.720  39.815  -8.820  1.00 17.97           C  
ATOM    328  O   LYS A  51     -30.726  38.883  -8.039  1.00 18.48           O  
ATOM    329  CB  LYS A  51     -31.102  42.227  -8.090  1.00 19.07           C  
ATOM    330  CG  LYS A  51     -32.392  41.740  -7.465  1.00 22.40           C  
ATOM    331  CD  LYS A  51     -33.452  42.862  -7.397  1.00 21.54           C  
ATOM    332  CE  LYS A  51     -34.705  42.431  -6.568  1.00 24.30           C  
ATOM    333  NZ  LYS A  51     -35.726  43.602  -6.488  1.00 25.51           N  
ATOM    334  N   GLN A  52     -31.243  39.718 -10.041  1.00 17.06           N  
ATOM    335  CA  GLN A  52     -31.850  38.456 -10.521  1.00 17.41           C  
ATOM    336  C   GLN A  52     -30.895  37.254 -10.463  1.00 16.83           C  
ATOM    337  O   GLN A  52     -31.290  36.193 -10.049  1.00 16.13           O  
ATOM    338  CB  GLN A  52     -32.416  38.580 -11.955  1.00 17.28           C  
ATOM    339  CG  GLN A  52     -33.381  37.438 -12.321  1.00 18.40           C  
ATOM    340  CD  GLN A  52     -34.600  37.379 -11.372  1.00 23.61           C  
ATOM    341  OE1 GLN A  52     -35.275  38.397 -11.153  1.00 26.24           O  
ATOM    342  NE2 GLN A  52     -34.870  36.205 -10.800  1.00 20.58           N  
ATOM    343  N   ALA A  53     -29.655  37.431 -10.914  1.00 16.49           N  
ATOM    344  CA  ALA A  53     -28.635  36.384 -10.804  1.00 16.64           C  
ATOM    345  C   ALA A  53     -28.411  35.947  -9.334  1.00 16.21           C  
ATOM    346  O   ALA A  53     -28.218  34.759  -9.061  1.00 16.06           O  
ATOM    347  CB  ALA A  53     -27.313  36.835 -11.468  1.00 15.42           C  
ATOM    348  N   LEU A  54     -28.433  36.896  -8.400  1.00 15.95           N  
ATOM    349  CA  LEU A  54     -28.279  36.573  -6.958  1.00 15.60           C  
ATOM    350  C   LEU A  54     -29.427  35.649  -6.467  1.00 15.28           C  
ATOM    351  O   LEU A  54     -29.186  34.638  -5.819  1.00 14.80           O  
ATOM    352  CB  LEU A  54     -28.252  37.837  -6.092  1.00 15.24           C  
ATOM    353  CG  LEU A  54     -27.048  38.769  -6.237  1.00 15.91           C  
ATOM    354  CD1 LEU A  54     -27.316  40.146  -5.616  1.00 14.65           C  
ATOM    355  CD2 LEU A  54     -25.783  38.121  -5.624  1.00 14.90           C  
ATOM    356  N   ILE A  55     -30.652  36.014  -6.815  1.00 14.81           N  
ATOM    357  CA  ILE A  55     -31.868  35.264  -6.452  1.00 14.18           C  
ATOM    358  C   ILE A  55     -31.868  33.861  -7.120  1.00 13.85           C  
ATOM    359  O   ILE A  55     -32.156  32.841  -6.459  1.00 13.89           O  
ATOM    360  CB  ILE A  55     -33.136  36.080  -6.872  1.00 14.34           C  
ATOM    361  CG1 ILE A  55     -33.304  37.340  -5.975  1.00 14.66           C  
ATOM    362  CG2 ILE A  55     -34.399  35.211  -6.842  1.00 12.51           C  
ATOM    363  CD1 ILE A  55     -34.203  38.468  -6.628  1.00 14.43           C  
ATOM    364  N   ASP A  56     -31.582  33.822  -8.419  1.00 10.89           N  
ATOM    365  CA  ASP A  56     -31.622  32.584  -9.165  1.00  9.88           C  
ATOM    366  C   ASP A  56     -30.628  31.592  -8.576  1.00  9.84           C  
ATOM    367  O   ASP A  56     -30.896  30.405  -8.550  1.00  8.73           O  
ATOM    368  CB  ASP A  56     -31.298  32.795 -10.651  1.00  9.51           C  
ATOM    369  CG  ASP A  56     -32.414  33.515 -11.412  1.00 12.46           C  
ATOM    370  OD1 ASP A  56     -33.495  33.751 -10.820  1.00 14.20           O  
ATOM    371  OD2 ASP A  56     -32.190  33.863 -12.599  1.00 15.83           O  
ATOM    372  N   SER A  57     -29.468  32.103  -8.130  1.00  9.76           N  
ATOM    373  CA  SER A  57     -28.407  31.268  -7.541  1.00 10.24           C  
ATOM    374  C   SER A  57     -28.873  30.599  -6.246  1.00  9.48           C  
ATOM    375  O   SER A  57     -28.685  29.391  -6.045  1.00  9.78           O  
ATOM    376  CB  SER A  57     -27.136  32.083  -7.315  1.00  9.66           C  
ATOM    377  OG  SER A  57     -26.129  31.290  -6.692  1.00 13.56           O  
ATOM    378  N   VAL A  58     -29.506  31.375  -5.380  1.00  9.43           N  
ATOM    379  CA  VAL A  58     -30.084  30.828  -4.161  1.00  9.33           C  
ATOM    380  C   VAL A  58     -31.256  29.871  -4.452  1.00  9.55           C  
ATOM    381  O   VAL A  58     -31.393  28.825  -3.796  1.00  9.13           O  
ATOM    382  CB  VAL A  58     -30.495  31.943  -3.161  1.00  9.12           C  
ATOM    383  CG1 VAL A  58     -31.250  31.345  -1.970  1.00  7.99           C  
ATOM    384  CG2 VAL A  58     -29.229  32.735  -2.714  1.00  8.91           C  
ATOM    385  N   TYR A  59     -32.102  30.225  -5.410  1.00  9.64           N  
ATOM    386  CA  TYR A  59     -33.160  29.281  -5.848  1.00 10.23           C  
ATOM    387  C   TYR A  59     -32.574  27.902  -6.221  1.00 10.73           C  
ATOM    388  O   TYR A  59     -33.020  26.875  -5.684  1.00 10.92           O  
ATOM    389  CB  TYR A  59     -34.012  29.843  -6.985  1.00 11.76           C  
ATOM    390  CG  TYR A  59     -35.253  28.973  -7.277  1.00 14.54           C  
ATOM    391  CD1 TYR A  59     -36.322  28.948  -6.401  1.00 14.26           C  
ATOM    392  CD2 TYR A  59     -35.311  28.164  -8.418  1.00 16.94           C  
ATOM    393  CE1 TYR A  59     -37.428  28.159  -6.643  1.00 19.32           C  
ATOM    394  CE2 TYR A  59     -36.409  27.361  -8.671  1.00 20.06           C  
ATOM    395  CZ  TYR A  59     -37.462  27.366  -7.778  1.00 19.36           C  
ATOM    396  OH  TYR A  59     -38.563  26.571  -8.025  1.00 22.24           O  
ATOM    397  N   ALA A  60     -31.563  27.884  -7.105  1.00 10.35           N  
ATOM    398  CA  ALA A  60     -30.989  26.636  -7.582  1.00 10.98           C  
ATOM    399  C   ALA A  60     -30.258  25.876  -6.460  1.00 11.48           C  
ATOM    400  O   ALA A  60     -30.326  24.659  -6.413  1.00 11.38           O  
ATOM    401  CB  ALA A  60     -30.058  26.875  -8.784  1.00 10.62           C  
ATOM    402  N   ARG A  61     -29.566  26.597  -5.569  1.00 11.50           N  
ATOM    403  CA  ARG A  61     -28.954  25.997  -4.389  1.00 11.67           C  
ATOM    404  C   ARG A  61     -29.957  25.259  -3.504  1.00 12.09           C  
ATOM    405  O   ARG A  61     -29.742  24.078  -3.169  1.00 10.35           O  
ATOM    406  CB  ARG A  61     -28.244  27.047  -3.531  1.00 12.30           C  
ATOM    407  CG  ARG A  61     -27.357  26.446  -2.423  1.00 13.84           C  
ATOM    408  CD  ARG A  61     -26.747  27.507  -1.537  1.00 12.37           C  
ATOM    409  NE  ARG A  61     -27.726  28.150  -0.665  1.00 15.24           N  
ATOM    410  CZ  ARG A  61     -27.386  28.980   0.326  1.00 16.64           C  
ATOM    411  NH1 ARG A  61     -26.096  29.252   0.553  1.00 14.98           N  
ATOM    412  NH2 ARG A  61     -28.332  29.535   1.088  1.00 17.47           N  
ATOM    413  N   GLU A  62     -31.023  25.951  -3.105  1.00 11.55           N  
ATOM    414  CA  GLU A  62     -32.054  25.318  -2.278  1.00 13.92           C  
ATOM    415  C   GLU A  62     -32.706  24.106  -2.965  1.00 14.65           C  
ATOM    416  O   GLU A  62     -32.744  23.029  -2.381  1.00 15.58           O  
ATOM    417  CB  GLU A  62     -33.135  26.322  -1.810  1.00 13.05           C  
ATOM    418  CG  GLU A  62     -32.576  27.456  -0.903  1.00 12.84           C  
ATOM    419  CD  GLU A  62     -31.659  26.935   0.190  1.00 14.93           C  
ATOM    420  OE1 GLU A  62     -32.111  26.083   1.005  1.00 13.72           O  
ATOM    421  OE2 GLU A  62     -30.485  27.357   0.231  1.00 13.81           O  
ATOM    422  N   THR A  63     -33.197  24.280  -4.195  1.00 15.55           N  
ATOM    423  CA  THR A  63     -33.868  23.181  -4.902  1.00 16.21           C  
ATOM    424  C   THR A  63     -32.963  21.999  -5.157  1.00 17.13           C  
ATOM    425  O   THR A  63     -33.377  20.856  -5.015  1.00 16.66           O  
ATOM    426  CB  THR A  63     -34.547  23.632  -6.206  1.00 16.20           C  
ATOM    427  OG1 THR A  63     -33.589  24.230  -7.077  1.00 15.73           O  
ATOM    428  CG2 THR A  63     -35.629  24.604  -5.895  1.00 15.18           C  
ATOM    429  N   ASN A  64     -31.714  22.273  -5.512  1.00 19.17           N  
ATOM    430  CA  ASN A  64     -30.747  21.197  -5.740  1.00 21.56           C  
ATOM    431  C   ASN A  64     -30.331  20.425  -4.488  1.00 22.32           C  
ATOM    432  O   ASN A  64     -29.845  19.309  -4.568  1.00 21.68           O  
ATOM    433  CB  ASN A  64     -29.545  21.734  -6.509  1.00 22.12           C  
ATOM    434  CG  ASN A  64     -29.800  21.758  -8.003  1.00 24.73           C  
ATOM    435  OD1 ASN A  64     -30.279  22.753  -8.560  1.00 28.32           O  
ATOM    436  ND2 ASN A  64     -29.535  20.632  -8.653  1.00 27.97           N  
ATOM    437  N   ARG A  65     -30.572  20.999  -3.319  1.00 24.13           N  
ATOM    438  CA  ARG A  65     -30.253  20.279  -2.094  1.00 26.32           C  
ATOM    439  C   ARG A  65     -31.304  19.212  -1.723  1.00 25.65           C  
ATOM    440  O   ARG A  65     -31.058  18.352  -0.877  1.00 26.42           O  
ATOM    441  CB  ARG A  65     -30.000  21.258  -0.919  1.00 26.61           C  
ATOM    442  CG  ARG A  65     -28.546  21.273  -0.442  1.00 28.89           C  
ATOM    443  CD  ARG A  65     -28.403  21.845   0.986  1.00 28.90           C  
ATOM    444  NE  ARG A  65     -27.950  23.253   1.040  1.00 30.46           N  
ATOM    445  CZ  ARG A  65     -28.756  24.301   1.171  1.00 29.72           C  
ATOM    446  NH1 ARG A  65     -30.075  24.125   1.232  1.00 28.89           N  
ATOM    447  NH2 ARG A  65     -28.245  25.525   1.242  1.00 28.83           N  
ATOM    448  N   ILE A  66     -32.468  19.252  -2.350  1.00 25.16           N  
ATOM    449  CA  ILE A  66     -33.527  18.328  -1.945  1.00 25.35           C  
ATOM    450  C   ILE A  66     -33.200  16.840  -2.247  1.00 25.71           C  
ATOM    451  O   ILE A  66     -33.221  15.995  -1.328  1.00 26.32           O  
ATOM    452  CB  ILE A  66     -34.884  18.742  -2.501  1.00 25.26           C  
ATOM    453  CG1 ILE A  66     -35.171  20.209  -2.137  1.00 24.29           C  
ATOM    454  CG2 ILE A  66     -36.003  17.776  -1.983  1.00 26.40           C  
ATOM    455  CD1 ILE A  66     -36.436  20.757  -2.734  1.00 20.88           C  
ATOM    456  N   LEU A  67     -32.849  16.543  -3.497  1.00 25.01           N  
ATOM    457  CA  LEU A  67     -32.540  15.181  -3.936  1.00 25.06           C  
ATOM    458  C   LEU A  67     -31.135  15.054  -4.504  1.00 25.53           C  
ATOM    459  O   LEU A  67     -30.715  15.881  -5.307  1.00 24.97           O  
ATOM    460  CB  LEU A  67     -33.523  14.756  -5.032  1.00 24.62           C  
ATOM    461  CG  LEU A  67     -35.011  14.877  -4.724  1.00 23.42           C  
ATOM    462  CD1 LEU A  67     -35.806  14.837  -5.996  1.00 23.09           C  
ATOM    463  CD2 LEU A  67     -35.463  13.805  -3.753  1.00 23.17           C  
ATOM    464  N   SER A  68     -30.441  13.975  -4.123  1.00 26.54           N  
ATOM    465  CA  SER A  68     -29.134  13.644  -4.674  1.00 26.40           C  
ATOM    466  C   SER A  68     -29.300  12.922  -6.000  1.00 26.46           C  
ATOM    467  O   SER A  68     -30.429  12.567  -6.387  1.00 26.37           O  
ATOM    468  CB  SER A  68     -28.361  12.761  -3.707  1.00 26.81           C  
ATOM    469  OG  SER A  68     -28.880  11.435  -3.698  1.00 28.37           O  
ATOM    470  N   THR A  69     -28.176  12.723  -6.687  1.00 26.08           N  
ATOM    471  CA  THR A  69     -28.089  11.934  -7.925  1.00 26.77           C  
ATOM    472  C   THR A  69     -28.519  10.490  -7.671  1.00 26.45           C  
ATOM    473  O   THR A  69     -29.282   9.922  -8.452  1.00 26.43           O  
ATOM    474  CB  THR A  69     -26.648  11.941  -8.488  1.00 26.82           C  
ATOM    475  OG1 THR A  69     -26.081  13.254  -8.344  1.00 27.84           O  
ATOM    476  CG2 THR A  69     -26.629  11.545  -9.970  1.00 28.06           C  
ATOM    477  N   THR A  70     -28.004   9.926  -6.575  1.00 26.29           N  
ATOM    478  CA  THR A  70     -28.454   8.663  -5.975  1.00 26.57           C  
ATOM    479  C   THR A  70     -29.987   8.570  -5.789  1.00 25.56           C  
ATOM    480  O   THR A  70     -30.605   7.569  -6.185  1.00 24.94           O  
ATOM    481  CB  THR A  70     -27.760   8.461  -4.610  1.00 26.52           C  
ATOM    482  OG1 THR A  70     -26.353   8.317  -4.827  1.00 31.37           O  
ATOM    483  CG2 THR A  70     -28.260   7.226  -3.901  1.00 28.10           C  
ATOM    484  N   ASP A  71     -30.580   9.602  -5.180  1.00 24.25           N  
ATOM    485  CA  ASP A  71     -32.031   9.679  -5.046  1.00 23.91           C  
ATOM    486  C   ASP A  71     -32.686   9.589  -6.410  1.00 22.92           C  
ATOM    487  O   ASP A  71     -33.557   8.763  -6.625  1.00 22.47           O  
ATOM    488  CB  ASP A  71     -32.469  10.986  -4.357  1.00 24.02           C  
ATOM    489  CG  ASP A  71     -32.003  11.076  -2.924  1.00 25.36           C  
ATOM    490  OD1 ASP A  71     -31.682  10.027  -2.327  1.00 27.90           O  
ATOM    491  OD2 ASP A  71     -31.944  12.201  -2.386  1.00 27.27           O  
ATOM    492  N   LEU A  72     -32.250  10.452  -7.322  1.00 22.87           N  
ATOM    493  CA  LEU A  72     -32.855  10.594  -8.637  1.00 23.07           C  
ATOM    494  C   LEU A  72     -32.788   9.308  -9.443  1.00 22.52           C  
ATOM    495  O   LEU A  72     -33.676   9.016 -10.244  1.00 22.56           O  
ATOM    496  CB  LEU A  72     -32.162  11.722  -9.408  1.00 23.53           C  
ATOM    497  CG  LEU A  72     -32.857  13.078  -9.571  1.00 24.96           C  
ATOM    498  CD1 LEU A  72     -33.894  13.330  -8.531  1.00 25.23           C  
ATOM    499  CD2 LEU A  72     -31.842  14.216  -9.626  1.00 27.51           C  
ATOM    500  N   ASP A  73     -31.726   8.549  -9.243  1.00 22.15           N  
ATOM    501  CA  ASP A  73     -31.531   7.339 -10.013  1.00 21.92           C  
ATOM    502  C   ASP A  73     -32.579   6.302  -9.582  1.00 20.78           C  
ATOM    503  O   ASP A  73     -33.199   5.644 -10.426  1.00 20.25           O  
ATOM    504  CB  ASP A  73     -30.094   6.831  -9.850  1.00 23.12           C  
ATOM    505  CG  ASP A  73     -29.087   7.600 -10.722  1.00 27.20           C  
ATOM    506  OD1 ASP A  73     -29.504   8.518 -11.482  1.00 32.36           O  
ATOM    507  OD2 ASP A  73     -27.866   7.273 -10.664  1.00 30.30           O  
ATOM    508  N   ARG A  74     -32.780   6.194  -8.271  0.50 19.69           N  
ATOM    510  CA  ARG A  74     -33.802   5.329  -7.704  0.50 18.62           C  
ATOM    512  C   ARG A  74     -35.213   5.744  -8.159  0.50 18.48           C  
ATOM    514  O   ARG A  74     -36.025   4.888  -8.517  0.50 18.41           O  
ATOM    516  CB  ARG A  74     -33.689   5.310  -6.168  0.50 18.21           C  
ATOM    518  CG  ARG A  74     -33.928   3.946  -5.531  0.50 16.34           C  
ATOM    520  CD  ARG A  74     -32.693   2.999  -5.548  0.50 11.97           C  
ATOM    522  NE  ARG A  74     -32.054   2.855  -6.857  0.50  7.49           N  
ATOM    524  CZ  ARG A  74     -32.462   2.052  -7.844  0.50  6.29           C  
ATOM    526  NH1 ARG A  74     -33.540   1.275  -7.717  0.50  2.00           N  
ATOM    528  NH2 ARG A  74     -31.780   2.047  -8.985  0.50  3.80           N  
ATOM    530  N   LEU A  75     -35.487   7.052  -8.174  1.00 17.89           N  
ATOM    531  CA  LEU A  75     -36.826   7.583  -8.550  1.00 17.36           C  
ATOM    532  C   LEU A  75     -37.151   7.416 -10.050  1.00 16.39           C  
ATOM    533  O   LEU A  75     -38.317   7.303 -10.453  1.00 15.60           O  
ATOM    534  CB  LEU A  75     -37.020   9.052  -8.091  1.00 15.81           C  
ATOM    535  CG  LEU A  75     -36.882   9.276  -6.581  1.00 16.38           C  
ATOM    536  CD1 LEU A  75     -36.923  10.749  -6.210  1.00 13.75           C  
ATOM    537  CD2 LEU A  75     -37.959   8.495  -5.818  1.00 13.10           C  
ATOM    538  N   SER A  76     -36.111   7.368 -10.861  1.00 15.00           N  
ATOM    539  CA  SER A  76     -36.302   7.195 -12.285  1.00 15.57           C  
ATOM    540  C   SER A  76     -36.230   5.726 -12.716  1.00 15.27           C  
ATOM    541  O   SER A  76     -36.314   5.428 -13.902  1.00 15.11           O  
ATOM    542  CB  SER A  76     -35.290   8.045 -13.061  1.00 15.37           C  
ATOM    543  OG  SER A  76     -33.993   7.493 -12.949  1.00 18.68           O  
ATOM    544  N   ASP A  77     -36.105   4.810 -11.750  1.00 14.87           N  
ATOM    545  CA  ASP A  77     -35.926   3.392 -12.066  1.00 13.54           C  
ATOM    546  C   ASP A  77     -37.327   2.829 -12.278  1.00 13.45           C  
ATOM    547  O   ASP A  77     -38.065   2.575 -11.319  1.00 11.68           O  
ATOM    548  CB  ASP A  77     -35.178   2.664 -10.918  1.00 13.68           C  
ATOM    549  CG  ASP A  77     -34.904   1.161 -11.208  1.00 13.33           C  
ATOM    550  OD1 ASP A  77     -35.433   0.574 -12.180  1.00 11.01           O  
ATOM    551  OD2 ASP A  77     -34.142   0.553 -10.436  1.00 13.84           O  
ATOM    552  N   SER A  78     -37.653   2.576 -13.545  1.00 13.04           N  
ATOM    553  CA  SER A  78     -38.985   2.126 -13.921  1.00 13.44           C  
ATOM    554  C   SER A  78     -39.317   0.691 -13.508  1.00 12.80           C  
ATOM    555  O   SER A  78     -40.494   0.305 -13.511  1.00 14.13           O  
ATOM    556  CB  SER A  78     -39.192   2.316 -15.427  1.00 13.38           C  
ATOM    557  OG  SER A  78     -38.346   1.432 -16.127  1.00 16.03           O  
ATOM    558  N   THR A  79     -38.302  -0.081 -13.132  1.00 11.70           N  
ATOM    559  CA  THR A  79     -38.516  -1.421 -12.566  1.00 10.99           C  
ATOM    560  C   THR A  79     -39.010  -1.445 -11.119  1.00  9.97           C  
ATOM    561  O   THR A  79     -39.479  -2.492 -10.646  1.00  9.87           O  
ATOM    562  CB  THR A  79     -37.266  -2.343 -12.674  1.00 10.86           C  
ATOM    563  OG1 THR A  79     -36.255  -1.908 -11.755  1.00  9.08           O  
ATOM    564  CG2 THR A  79     -36.729  -2.403 -14.140  1.00 11.79           C  
ATOM    565  N   ILE A  80     -38.880  -0.319 -10.412  1.00 10.13           N  
ATOM    566  CA  ILE A  80     -39.334  -0.213  -9.023  1.00  9.23           C  
ATOM    567  C   ILE A  80     -40.797   0.260  -9.022  1.00 11.02           C  
ATOM    568  O   ILE A  80     -41.169   1.171  -9.765  1.00  9.14           O  
ATOM    569  CB  ILE A  80     -38.476   0.788  -8.200  1.00  9.43           C  
ATOM    570  CG1 ILE A  80     -36.990   0.445  -8.288  1.00  7.97           C  
ATOM    571  CG2 ILE A  80     -38.959   0.891  -6.706  1.00  5.59           C  
ATOM    572  CD1 ILE A  80     -36.635  -1.004  -7.944  1.00  6.97           C  
ATOM    573  N   ASP A  81     -41.648  -0.364  -8.216  1.00 11.96           N  
ATOM    574  CA  ASP A  81     -43.040   0.034  -8.319  1.00 14.09           C  
ATOM    575  C   ASP A  81     -43.230   1.488  -7.857  1.00 13.65           C  
ATOM    576  O   ASP A  81     -42.474   2.009  -7.021  1.00 12.37           O  
ATOM    577  CB  ASP A  81     -43.956  -0.925  -7.576  1.00 15.69           C  
ATOM    578  CG  ASP A  81     -43.933  -0.702  -6.114  1.00 18.97           C  
ATOM    579  OD1 ASP A  81     -42.943  -1.137  -5.469  1.00 21.29           O  
ATOM    580  OD2 ASP A  81     -44.907  -0.096  -5.619  1.00 21.39           O  
ATOM    581  N   VAL A  82     -44.217   2.161  -8.443  1.00 12.83           N  
ATOM    582  CA  VAL A  82     -44.353   3.592  -8.206  1.00 12.22           C  
ATOM    583  C   VAL A  82     -44.676   3.946  -6.775  1.00 11.63           C  
ATOM    584  O   VAL A  82     -44.344   5.037  -6.332  1.00 11.39           O  
ATOM    585  CB  VAL A  82     -45.379   4.263  -9.148  1.00 12.68           C  
ATOM    586  CG1 VAL A  82     -44.853   4.230 -10.567  1.00 12.31           C  
ATOM    587  CG2 VAL A  82     -46.783   3.589  -9.041  1.00 13.57           C  
ATOM    588  N   THR A  83     -45.340   3.036  -6.058  1.00 12.07           N  
ATOM    589  CA  THR A  83     -45.792   3.279  -4.686  1.00 11.82           C  
ATOM    590  C   THR A  83     -44.604   3.407  -3.775  1.00 11.85           C  
ATOM    591  O   THR A  83     -44.559   4.293  -2.887  1.00 11.70           O  
ATOM    592  CB  THR A  83     -46.793   2.145  -4.195  1.00 12.48           C  
ATOM    593  OG1 THR A  83     -48.023   2.287  -4.901  1.00 14.08           O  
ATOM    594  CG2 THR A  83     -47.089   2.229  -2.687  1.00 11.44           C  
ATOM    595  N   THR A  84     -43.656   2.487  -3.974  1.00 11.50           N  
ATOM    596  CA  THR A  84     -42.370   2.494  -3.276  1.00 10.72           C  
ATOM    597  C   THR A  84     -41.574   3.800  -3.600  1.00 10.40           C  
ATOM    598  O   THR A  84     -41.059   4.448  -2.697  1.00 10.08           O  
ATOM    599  CB  THR A  84     -41.545   1.231  -3.668  1.00  9.94           C  
ATOM    600  OG1 THR A  84     -42.272   0.062  -3.259  1.00 10.02           O  
ATOM    601  CG2 THR A  84     -40.156   1.216  -2.997  1.00 10.44           C  
ATOM    602  N   ARG A  85     -41.448   4.142  -4.883  1.00  9.52           N  
ATOM    603  CA  ARG A  85     -40.681   5.323  -5.271  1.00  9.94           C  
ATOM    604  C   ARG A  85     -41.297   6.623  -4.755  1.00  9.94           C  
ATOM    605  O   ARG A  85     -40.566   7.515  -4.386  1.00 10.65           O  
ATOM    606  CB  ARG A  85     -40.511   5.411  -6.804  1.00 10.08           C  
ATOM    607  CG  ARG A  85     -39.601   4.335  -7.369  1.00  8.40           C  
ATOM    608  CD  ARG A  85     -39.348   4.617  -8.846  1.00  9.10           C  
ATOM    609  NE  ARG A  85     -40.344   3.973  -9.693  1.00  9.37           N  
ATOM    610  CZ  ARG A  85     -40.613   4.322 -10.945  1.00 11.90           C  
ATOM    611  NH1 ARG A  85     -41.529   3.638 -11.626  1.00 12.98           N  
ATOM    612  NH2 ARG A  85     -39.977   5.341 -11.510  1.00  8.61           N  
ATOM    613  N   ILE A  86     -42.627   6.741  -4.761  1.00 10.25           N  
ATOM    614  CA  ILE A  86     -43.307   7.885  -4.127  1.00 10.84           C  
ATOM    615  C   ILE A  86     -42.968   7.996  -2.621  1.00 11.21           C  
ATOM    616  O   ILE A  86     -42.653   9.069  -2.128  1.00 12.37           O  
ATOM    617  CB  ILE A  86     -44.855   7.885  -4.395  1.00 10.60           C  
ATOM    618  CG1 ILE A  86     -45.118   8.160  -5.866  1.00 11.30           C  
ATOM    619  CG2 ILE A  86     -45.596   9.011  -3.546  1.00 10.03           C  
ATOM    620  CD1 ILE A  86     -46.567   7.971  -6.277  1.00 10.84           C  
ATOM    621  N   ARG A  87     -43.014   6.884  -1.905  0.50 11.67           N  
ATOM    623  CA  ARG A  87     -42.683   6.903  -0.492  0.50 12.12           C  
ATOM    625  C   ARG A  87     -41.237   7.356  -0.252  0.50 11.81           C  
ATOM    627  O   ARG A  87     -40.980   8.188   0.626  0.50 11.72           O  
ATOM    629  CB  ARG A  87     -42.961   5.542   0.164  0.50 11.80           C  
ATOM    631  CG  ARG A  87     -42.921   5.590   1.702  0.50 12.86           C  
ATOM    633  CD  ARG A  87     -43.131   4.214   2.337  0.50 12.32           C  
ATOM    635  NE  ARG A  87     -41.962   3.353   2.120  0.50 15.76           N  
ATOM    637  CZ  ARG A  87     -41.901   2.376   1.211  0.50 14.03           C  
ATOM    639  NH1 ARG A  87     -42.937   2.128   0.439  0.50 13.10           N  
ATOM    641  NH2 ARG A  87     -40.804   1.642   1.087  0.50 14.64           N  
ATOM    643  N   LEU A  88     -40.308   6.806  -1.039  1.00 12.28           N  
ATOM    644  CA  LEU A  88     -38.891   7.200  -1.007  1.00 11.40           C  
ATOM    645  C   LEU A  88     -38.746   8.686  -1.273  1.00 11.35           C  
ATOM    646  O   LEU A  88     -37.964   9.371  -0.607  1.00  9.84           O  
ATOM    647  CB  LEU A  88     -38.087   6.435  -2.067  1.00 11.32           C  
ATOM    648  CG  LEU A  88     -37.951   4.906  -1.908  1.00 14.14           C  
ATOM    649  CD1 LEU A  88     -37.155   4.336  -3.121  1.00 16.63           C  
ATOM    650  CD2 LEU A  88     -37.328   4.503  -0.556  1.00 14.69           C  
ATOM    651  N   TYR A  89     -39.489   9.177  -2.267  1.00 11.46           N  
ATOM    652  CA  TYR A  89     -39.435  10.608  -2.580  1.00 12.99           C  
ATOM    653  C   TYR A  89     -39.900  11.490  -1.425  1.00 11.55           C  
ATOM    654  O   TYR A  89     -39.218  12.426  -1.036  1.00 11.94           O  
ATOM    655  CB  TYR A  89     -40.232  10.914  -3.861  1.00 14.24           C  
ATOM    656  CG  TYR A  89     -40.355  12.391  -4.137  1.00 16.50           C  
ATOM    657  CD1 TYR A  89     -39.228  13.175  -4.353  1.00 14.62           C  
ATOM    658  CD2 TYR A  89     -41.593  13.001  -4.137  1.00 16.55           C  
ATOM    659  CE1 TYR A  89     -39.354  14.543  -4.586  1.00 19.29           C  
ATOM    660  CE2 TYR A  89     -41.724  14.345  -4.349  1.00 19.87           C  
ATOM    661  CZ  TYR A  89     -40.602  15.105  -4.567  1.00 18.16           C  
ATOM    662  OH  TYR A  89     -40.756  16.454  -4.807  1.00 22.99           O  
ATOM    663  N   VAL A  90     -41.088  11.212  -0.904  1.00 12.08           N  
ATOM    664  CA  VAL A  90     -41.656  12.032   0.123  1.00 10.84           C  
ATOM    665  C   VAL A  90     -40.818  11.921   1.400  1.00 10.50           C  
ATOM    666  O   VAL A  90     -40.671  12.889   2.129  1.00 10.29           O  
ATOM    667  CB  VAL A  90     -43.142  11.665   0.388  1.00 11.89           C  
ATOM    668  CG1 VAL A  90     -43.727  12.566   1.482  1.00  9.92           C  
ATOM    669  CG2 VAL A  90     -43.961  11.817  -0.910  1.00 11.90           C  
ATOM    670  N   GLN A  91     -40.274  10.743   1.676  1.00 10.36           N  
ATOM    671  CA  GLN A  91     -39.440  10.599   2.866  1.00 11.51           C  
ATOM    672  C   GLN A  91     -38.152  11.446   2.781  1.00 11.69           C  
ATOM    673  O   GLN A  91     -37.734  12.056   3.774  1.00 11.78           O  
ATOM    674  CB  GLN A  91     -39.144   9.134   3.150  1.00 12.25           C  
ATOM    675  CG  GLN A  91     -38.083   8.907   4.198  1.00 15.44           C  
ATOM    676  CD  GLN A  91     -38.399   7.700   4.986  1.00 23.69           C  
ATOM    677  OE1 GLN A  91     -38.638   6.618   4.427  1.00 27.24           O  
ATOM    678  NE2 GLN A  91     -38.453   7.861   6.300  1.00 27.47           N  
ATOM    679  N   GLN A  92     -37.536  11.487   1.605  1.00 12.15           N  
ATOM    680  CA  GLN A  92     -36.405  12.403   1.359  1.00 13.46           C  
ATOM    681  C   GLN A  92     -36.770  13.904   1.523  1.00 12.50           C  
ATOM    682  O   GLN A  92     -36.066  14.647   2.209  1.00 13.37           O  
ATOM    683  CB  GLN A  92     -35.796  12.131  -0.029  1.00 13.91           C  
ATOM    684  CG  GLN A  92     -34.552  12.973  -0.379  1.00 17.06           C  
ATOM    685  CD  GLN A  92     -33.488  13.014   0.735  1.00 21.66           C  
ATOM    686  OE1 GLN A  92     -33.234  12.019   1.430  1.00 20.76           O  
ATOM    687  NE2 GLN A  92     -32.852  14.178   0.892  1.00 23.22           N  
ATOM    688  N   VAL A  93     -37.863  14.352   0.916  1.00 12.08           N  
ATOM    689  CA  VAL A  93     -38.306  15.779   1.080  1.00 10.39           C  
ATOM    690  C   VAL A  93     -38.480  16.092   2.570  1.00 10.46           C  
ATOM    691  O   VAL A  93     -38.035  17.120   3.060  1.00 10.56           O  
ATOM    692  CB  VAL A  93     -39.612  16.084   0.280  1.00 10.62           C  
ATOM    693  CG1 VAL A  93     -40.098  17.571   0.503  1.00  9.08           C  
ATOM    694  CG2 VAL A  93     -39.452  15.803  -1.195  1.00  9.38           C  
ATOM    695  N   TYR A  94     -39.116  15.175   3.286  1.00 10.50           N  
ATOM    696  CA  TYR A  94     -39.329  15.265   4.731  1.00 11.50           C  
ATOM    697  C   TYR A  94     -38.030  15.396   5.513  1.00 12.07           C  
ATOM    698  O   TYR A  94     -37.868  16.355   6.282  1.00 10.64           O  
ATOM    699  CB  TYR A  94     -40.143  14.048   5.198  1.00 12.20           C  
ATOM    700  CG  TYR A  94     -40.436  13.954   6.668  1.00 12.22           C  
ATOM    701  CD1 TYR A  94     -41.601  14.506   7.207  1.00 11.71           C  
ATOM    702  CD2 TYR A  94     -39.552  13.267   7.530  1.00 12.86           C  
ATOM    703  CE1 TYR A  94     -41.874  14.399   8.607  1.00 14.39           C  
ATOM    704  CE2 TYR A  94     -39.814  13.140   8.914  1.00 13.68           C  
ATOM    705  CZ  TYR A  94     -40.977  13.713   9.441  1.00 15.39           C  
ATOM    706  OH  TYR A  94     -41.224  13.611  10.808  1.00 17.10           O  
ATOM    707  N   ASP A  95     -37.098  14.462   5.304  1.00 12.97           N  
ATOM    708  CA  ASP A  95     -35.790  14.528   5.994  1.00 14.38           C  
ATOM    709  C   ASP A  95     -35.063  15.808   5.621  1.00 15.26           C  
ATOM    710  O   ASP A  95     -34.514  16.495   6.508  1.00 15.75           O  
ATOM    711  CB  ASP A  95     -34.889  13.349   5.616  1.00 14.02           C  
ATOM    712  CG  ASP A  95     -35.396  12.005   6.150  1.00 16.69           C  
ATOM    713  OD1 ASP A  95     -36.191  11.970   7.116  1.00 14.78           O  
ATOM    714  OD2 ASP A  95     -34.943  10.974   5.604  1.00 18.29           O  
ATOM    715  N   TYR A  96     -35.028  16.094   4.315  1.00 16.02           N  
ATOM    716  CA  TYR A  96     -34.387  17.310   3.794  1.00 17.27           C  
ATOM    717  C   TYR A  96     -34.902  18.572   4.474  1.00 16.45           C  
ATOM    718  O   TYR A  96     -34.124  19.402   4.927  1.00 15.97           O  
ATOM    719  CB  TYR A  96     -34.530  17.475   2.272  1.00 18.39           C  
ATOM    720  CG  TYR A  96     -33.994  18.828   1.873  1.00 22.68           C  
ATOM    721  CD1 TYR A  96     -32.610  19.074   1.877  1.00 25.21           C  
ATOM    722  CD2 TYR A  96     -34.850  19.890   1.591  1.00 23.15           C  
ATOM    723  CE1 TYR A  96     -32.117  20.309   1.565  1.00 25.26           C  
ATOM    724  CE2 TYR A  96     -34.354  21.141   1.283  1.00 21.23           C  
ATOM    725  CZ  TYR A  96     -32.993  21.339   1.271  1.00 24.98           C  
ATOM    726  OH  TYR A  96     -32.475  22.582   0.969  1.00 24.09           O  
ATOM    727  N   SER A  97     -36.225  18.712   4.525  1.00 16.28           N  
ATOM    728  CA  SER A  97     -36.828  19.884   5.106  1.00 15.38           C  
ATOM    729  C   SER A  97     -36.515  20.056   6.601  1.00 14.94           C  
ATOM    730  O   SER A  97     -36.215  21.157   7.042  1.00 15.54           O  
ATOM    731  CB  SER A  97     -38.344  19.900   4.839  1.00 15.05           C  
ATOM    732  OG  SER A  97     -38.937  21.113   5.326  1.00 14.15           O  
ATOM    733  N   LEU A  98     -36.620  18.999   7.399  1.00 14.61           N  
ATOM    734  CA  LEU A  98     -36.350  19.130   8.829  1.00 14.25           C  
ATOM    735  C   LEU A  98     -34.906  19.474   9.122  1.00 13.86           C  
ATOM    736  O   LEU A  98     -34.610  20.104  10.148  1.00 13.76           O  
ATOM    737  CB  LEU A  98     -36.721  17.843   9.579  1.00 14.76           C  
ATOM    738  CG  LEU A  98     -38.188  17.440   9.556  1.00 14.34           C  
ATOM    739  CD1 LEU A  98     -38.405  16.089  10.210  1.00 14.35           C  
ATOM    740  CD2 LEU A  98     -38.967  18.482  10.319  1.00 16.36           C  
ATOM    741  N   ALA A  99     -34.020  19.048   8.227  1.00 14.23           N  
ATOM    742  CA  ALA A  99     -32.562  19.245   8.383  1.00 15.08           C  
ATOM    743  C   ALA A  99     -32.144  20.625   7.884  1.00 15.01           C  
ATOM    744  O   ALA A  99     -31.091  21.115   8.276  1.00 15.38           O  
ATOM    745  CB  ALA A  99     -31.798  18.158   7.641  1.00 14.49           C  
ATOM    746  N   ASN A 100     -32.988  21.208   7.008  1.00 15.09           N  
ATOM    747  CA  ASN A 100     -32.878  22.560   6.415  1.00 15.00           C  
ATOM    748  C   ASN A 100     -34.180  23.363   6.580  1.00 14.33           C  
ATOM    749  O   ASN A 100     -34.884  23.628   5.622  1.00 13.24           O  
ATOM    750  CB  ASN A 100     -32.542  22.463   4.923  1.00 14.06           C  
ATOM    751  CG  ASN A 100     -31.318  21.599   4.670  1.00 16.89           C  
ATOM    752  OD1 ASN A 100     -30.181  22.098   4.597  1.00 14.79           O  
ATOM    753  ND2 ASN A 100     -31.531  20.291   4.583  1.00 15.21           N  
ATOM    754  N   PRO A 101     -34.469  23.788   7.811  1.00 14.96           N  
ATOM    755  CA  PRO A 101     -35.772  24.348   8.217  1.00 14.26           C  
ATOM    756  C   PRO A 101     -36.221  25.633   7.526  1.00 14.52           C  
ATOM    757  O   PRO A 101     -37.394  25.980   7.659  1.00 14.84           O  
ATOM    758  CB  PRO A 101     -35.626  24.584   9.719  1.00 14.21           C  
ATOM    759  CG  PRO A 101     -34.369  23.819  10.140  1.00 15.86           C  
ATOM    760  CD  PRO A 101     -33.493  23.737   8.920  1.00 15.05           C  
ATOM    761  N   ASP A 102     -35.320  26.330   6.822  1.00 14.08           N  
ATOM    762  CA  ASP A 102     -35.674  27.533   6.069  1.00 14.86           C  
ATOM    763  C   ASP A 102     -35.708  27.317   4.573  1.00 14.03           C  
ATOM    764  O   ASP A 102     -36.029  28.234   3.851  1.00 13.54           O  
ATOM    765  CB  ASP A 102     -34.673  28.682   6.332  1.00 15.13           C  
ATOM    766  CG  ASP A 102     -34.778  29.209   7.743  1.00 16.99           C  
ATOM    767  OD1 ASP A 102     -35.915  29.319   8.255  1.00 19.12           O  
ATOM    768  OD2 ASP A 102     -33.724  29.466   8.328  1.00 17.47           O  
ATOM    769  N   SER A 103     -35.336  26.128   4.113  1.00 13.80           N  
ATOM    770  CA  SER A 103     -35.142  25.934   2.678  1.00 12.86           C  
ATOM    771  C   SER A 103     -36.437  26.065   1.897  1.00 13.18           C  
ATOM    772  O   SER A 103     -36.530  26.835   0.937  1.00 13.11           O  
ATOM    773  CB  SER A 103     -34.434  24.596   2.407  1.00 12.53           C  
ATOM    774  OG  SER A 103     -33.981  24.567   1.075  1.00 11.03           O  
ATOM    775  N   LEU A 104     -37.472  25.366   2.348  1.00 13.78           N  
ATOM    776  CA  LEU A 104     -38.743  25.396   1.666  1.00 14.31           C  
ATOM    777  C   LEU A 104     -39.346  26.783   1.726  1.00 14.47           C  
ATOM    778  O   LEU A 104     -39.961  27.237   0.771  1.00 14.53           O  
ATOM    779  CB  LEU A 104     -39.683  24.331   2.261  1.00 14.70           C  
ATOM    780  CG  LEU A 104     -39.677  22.948   1.597  1.00 15.48           C  
ATOM    781  CD1 LEU A 104     -38.352  22.343   1.656  1.00 20.04           C  
ATOM    782  CD2 LEU A 104     -40.700  21.990   2.265  1.00 15.02           C  
ATOM    783  N   THR A 105     -39.145  27.478   2.842  1.00 14.38           N  
ATOM    784  CA  THR A 105     -39.622  28.854   2.979  1.00 14.48           C  
ATOM    785  C   THR A 105     -38.969  29.742   1.918  1.00 14.98           C  
ATOM    786  O   THR A 105     -39.662  30.544   1.259  1.00 15.16           O  
ATOM    787  CB  THR A 105     -39.320  29.420   4.395  1.00 15.11           C  
ATOM    788  OG1 THR A 105     -40.036  28.652   5.372  1.00 14.78           O  
ATOM    789  CG2 THR A 105     -39.735  30.919   4.510  1.00 15.13           C  
ATOM    790  N   ILE A 106     -37.652  29.586   1.737  1.00 15.22           N  
ATOM    791  CA  ILE A 106     -36.903  30.411   0.784  1.00 14.78           C  
ATOM    792  C   ILE A 106     -37.410  30.165  -0.642  1.00 14.97           C  
ATOM    793  O   ILE A 106     -37.683  31.126  -1.368  1.00 14.49           O  
ATOM    794  CB  ILE A 106     -35.385  30.125   0.871  1.00 15.52           C  
ATOM    795  CG1 ILE A 106     -34.783  30.720   2.166  1.00 16.84           C  
ATOM    796  CG2 ILE A 106     -34.621  30.650  -0.389  1.00 14.28           C  
ATOM    797  CD1 ILE A 106     -33.494  30.029   2.583  1.00 15.43           C  
ATOM    798  N   ILE A 107     -37.497  28.880  -1.021  1.00 15.47           N  
ATOM    799  CA  ILE A 107     -38.002  28.428  -2.331  1.00 15.92           C  
ATOM    800  C   ILE A 107     -39.393  29.010  -2.586  1.00 17.37           C  
ATOM    801  O   ILE A 107     -39.648  29.593  -3.632  1.00 17.36           O  
ATOM    802  CB  ILE A 107     -38.059  26.880  -2.423  1.00 15.92           C  
ATOM    803  CG1 ILE A 107     -36.638  26.269  -2.447  1.00 15.96           C  
ATOM    804  CG2 ILE A 107     -38.890  26.376  -3.682  1.00 14.78           C  
ATOM    805  CD1 ILE A 107     -36.603  24.781  -2.166  1.00 16.48           C  
ATOM    806  N   GLN A 108     -40.286  28.836  -1.610  1.00 18.42           N  
ATOM    807  CA  GLN A 108     -41.658  29.272  -1.739  1.00 18.97           C  
ATOM    808  C   GLN A 108     -41.719  30.769  -1.991  1.00 18.61           C  
ATOM    809  O   GLN A 108     -42.479  31.245  -2.864  1.00 18.63           O  
ATOM    810  CB  GLN A 108     -42.434  28.886  -0.477  1.00 19.99           C  
ATOM    811  CG  GLN A 108     -43.787  29.585  -0.362  1.00 23.78           C  
ATOM    812  CD  GLN A 108     -44.745  28.785   0.482  1.00 29.97           C  
ATOM    813  OE1 GLN A 108     -44.690  28.825   1.722  1.00 32.44           O  
ATOM    814  NE2 GLN A 108     -45.633  28.039  -0.179  1.00 30.30           N  
ATOM    815  N   GLN A 109     -40.923  31.526  -1.240  0.50 18.41           N  
ATOM    817  CA  GLN A 109     -40.872  32.981  -1.409  0.50 18.40           C  
ATOM    819  C   GLN A 109     -40.396  33.400  -2.793  0.50 18.09           C  
ATOM    821  O   GLN A 109     -40.973  34.303  -3.400  0.50 17.85           O  
ATOM    823  CB  GLN A 109     -39.962  33.627  -0.358  0.50 19.19           C  
ATOM    825  CG  GLN A 109     -40.679  34.115   0.885  0.50 19.82           C  
ATOM    827  CD  GLN A 109     -39.718  34.536   1.974  0.50 20.24           C  
ATOM    829  OE1 GLN A 109     -38.860  33.754   2.396  0.50 23.34           O  
ATOM    831  NE2 GLN A 109     -39.867  35.762   2.455  0.50 18.69           N  
ATOM    833  N   ILE A 110     -39.325  32.768  -3.271  1.00 17.82           N  
ATOM    834  CA  ILE A 110     -38.792  33.067  -4.610  1.00 17.99           C  
ATOM    835  C   ILE A 110     -39.844  32.707  -5.672  1.00 19.44           C  
ATOM    836  O   ILE A 110     -40.127  33.506  -6.554  1.00 18.79           O  
ATOM    837  CB  ILE A 110     -37.454  32.350  -4.891  1.00 15.94           C  
ATOM    838  CG1 ILE A 110     -36.393  32.831  -3.892  1.00 16.18           C  
ATOM    839  CG2 ILE A 110     -37.005  32.637  -6.332  1.00 15.61           C  
ATOM    840  CD1 ILE A 110     -35.056  32.134  -4.004  1.00 14.79           C  
ATOM    841  N   LYS A 111     -40.431  31.515  -5.554  1.00 21.65           N  
ATOM    842  CA  LYS A 111     -41.506  31.093  -6.450  1.00 24.43           C  
ATOM    843  C   LYS A 111     -42.700  32.059  -6.492  1.00 25.94           C  
ATOM    844  O   LYS A 111     -43.202  32.399  -7.574  1.00 26.73           O  
ATOM    845  CB  LYS A 111     -41.949  29.676  -6.102  1.00 24.81           C  
ATOM    846  CG  LYS A 111     -41.195  28.623  -6.862  1.00 26.72           C  
ATOM    847  CD  LYS A 111     -41.649  27.233  -6.466  1.00 29.66           C  
ATOM    848  CE  LYS A 111     -41.715  26.324  -7.716  1.00 35.01           C  
ATOM    849  NZ  LYS A 111     -41.730  24.819  -7.454  1.00 37.75           N  
ATOM    850  N   ALA A 112     -43.140  32.527  -5.329  1.00 28.32           N  
ATOM    851  CA  ALA A 112     -44.232  33.519  -5.243  1.00 30.90           C  
ATOM    852  C   ALA A 112     -43.970  34.792  -6.050  1.00 33.00           C  
ATOM    853  O   ALA A 112     -44.890  35.348  -6.645  1.00 33.12           O  
ATOM    854  CB  ALA A 112     -44.533  33.867  -3.783  1.00 29.83           C  
ATOM    855  N   LEU A 113     -42.716  35.242  -6.081  1.00 36.01           N  
ATOM    856  CA  LEU A 113     -42.341  36.485  -6.773  1.00 39.28           C  
ATOM    857  C   LEU A 113     -42.175  36.334  -8.298  1.00 41.67           C  
ATOM    858  O   LEU A 113     -42.418  37.291  -9.062  1.00 41.71           O  
ATOM    859  CB  LEU A 113     -41.071  37.085  -6.164  1.00 39.00           C  
ATOM    860  CG  LEU A 113     -40.768  38.527  -6.562  1.00 39.92           C  
ATOM    861  CD1 LEU A 113     -41.160  39.477  -5.432  1.00 40.55           C  
ATOM    862  CD2 LEU A 113     -39.291  38.698  -6.946  1.00 40.10           C  
ATOM    863  N   ASN A 114     -41.736  35.150  -8.724  1.00 44.24           N  
ATOM    864  CA  ASN A 114     -41.616  34.824 -10.140  1.00 47.15           C  
ATOM    865  C   ASN A 114     -43.002  34.620 -10.749  1.00 48.54           C  
ATOM    866  O   ASN A 114     -43.441  35.416 -11.586  1.00 48.75           O  
ATOM    867  CB  ASN A 114     -40.740  33.576 -10.349  1.00 47.54           C  
ATOM    868  CG  ASN A 114     -39.242  33.876 -10.273  1.00 49.39           C  
ATOM    869  OD1 ASN A 114     -38.816  35.033 -10.367  1.00 51.05           O  
ATOM    870  ND2 ASN A 114     -38.431  32.821 -10.112  1.00 51.23           N  
ATOM    871  N   GLY A 115     -43.682  33.555 -10.307  1.00 50.15           N  
ATOM    872  CA  GLY A 115     -45.063  33.249 -10.705  1.00 51.62           C  
ATOM    873  C   GLY A 115     -45.233  33.036 -12.199  1.00 52.67           C  
ATOM    874  O   GLY A 115     -45.740  33.924 -12.899  1.00 52.88           O  
ATOM    875  N   GLN A 116     -44.816  31.857 -12.677  1.00 53.41           N  
ATOM    876  CA  GLN A 116     -44.731  31.546 -14.117  1.00 53.70           C  
ATOM    877  C   GLN A 116     -46.094  31.477 -14.804  1.00 53.99           C  
ATOM    878  O   GLN A 116     -46.328  32.151 -15.818  1.00 54.15           O  
ATOM    879  CB  GLN A 116     -43.955  30.246 -14.340  1.00 53.85           C  
ATOM    880  N   ASP A 124     -40.280  18.785  -9.956  1.00 44.04           N  
ATOM    881  CA  ASP A 124     -39.993  18.592 -11.363  1.00 44.41           C  
ATOM    882  C   ASP A 124     -39.411  17.194 -11.651  1.00 44.20           C  
ATOM    883  O   ASP A 124     -39.929  16.476 -12.500  1.00 43.85           O  
ATOM    884  CB  ASP A 124     -39.069  19.735 -11.905  1.00 44.74           C  
ATOM    885  N   ALA A 125     -38.395  16.804 -10.871  1.00 44.47           N  
ATOM    886  CA  ALA A 125     -37.522  15.660 -11.138  1.00 43.16           C  
ATOM    887  C   ALA A 125     -36.223  16.224 -11.649  1.00 43.02           C  
ATOM    888  O   ALA A 125     -35.498  15.589 -12.426  1.00 42.31           O  
ATOM    889  N   ASP A 126     -35.967  17.455 -11.203  1.00 43.29           N  
ATOM    890  CA  ASP A 126     -34.866  18.312 -11.654  1.00 43.26           C  
ATOM    891  C   ASP A 126     -34.806  18.458 -13.178  1.00 42.49           C  
ATOM    892  O   ASP A 126     -35.846  18.621 -13.819  1.00 42.81           O  
ATOM    893  CB  ASP A 126     -33.535  17.861 -11.056  1.00 43.99           C  
ATOM    894  CG  ASP A 126     -32.662  19.026 -10.660  1.00 45.89           C  
ATOM    895  OD1 ASP A 126     -32.973  20.167 -11.076  1.00 48.57           O  
ATOM    896  OD2 ASP A 126     -31.665  18.803  -9.930  1.00 48.48           O  
ATOM    897  N   PRO A 127     -33.603  18.394 -13.748  1.00 41.20           N  
ATOM    898  CA  PRO A 127     -33.414  18.667 -15.165  1.00 39.91           C  
ATOM    899  C   PRO A 127     -34.282  17.779 -16.072  1.00 38.81           C  
ATOM    900  O   PRO A 127     -34.874  18.281 -17.036  1.00 38.80           O  
ATOM    901  CB  PRO A 127     -31.919  18.563 -15.551  1.00 39.92           C  
ATOM    902  N   ASN A 128     -34.373  16.482 -15.741  1.00 36.97           N  
ATOM    903  CA  ASN A 128     -35.010  15.470 -16.610  1.00 34.50           C  
ATOM    904  C   ASN A 128     -36.476  15.125 -16.283  1.00 32.71           C  
ATOM    905  O   ASN A 128     -36.986  14.109 -16.763  1.00 33.12           O  
ATOM    906  CB  ASN A 128     -34.148  14.174 -16.651  1.00 34.88           C  
ATOM    907  N   ASN A 129     -37.145  15.956 -15.477  1.00 29.84           N  
ATOM    908  CA  ASN A 129     -38.558  15.741 -15.106  1.00 27.22           C  
ATOM    909  C   ASN A 129     -38.858  14.379 -14.414  1.00 25.42           C  
ATOM    910  O   ASN A 129     -39.976  13.863 -14.501  1.00 25.01           O  
ATOM    911  CB  ASN A 129     -39.491  15.972 -16.325  1.00 26.89           C  
ATOM    912  N   ILE A 130     -37.850  13.822 -13.737  1.00 23.09           N  
ATOM    913  CA  ILE A 130     -37.958  12.546 -12.989  1.00 21.48           C  
ATOM    914  C   ILE A 130     -39.148  12.446 -12.004  1.00 19.69           C  
ATOM    915  O   ILE A 130     -39.935  11.511 -12.096  1.00 18.58           O  
ATOM    916  CB  ILE A 130     -36.613  12.198 -12.289  1.00 22.09           C  
ATOM    917  CG1 ILE A 130     -35.563  11.869 -13.362  1.00 22.18           C  
ATOM    918  CG2 ILE A 130     -36.785  11.047 -11.225  1.00 20.58           C  
ATOM    919  CD1 ILE A 130     -34.123  11.989 -12.891  1.00 25.01           C  
ATOM    920  N   VAL A 131     -39.307  13.421 -11.118  1.00 17.98           N  
ATOM    921  CA  VAL A 131     -40.434  13.412 -10.180  1.00 17.85           C  
ATOM    922  C   VAL A 131     -41.767  13.549 -10.917  1.00 18.12           C  
ATOM    923  O   VAL A 131     -42.697  12.756 -10.673  1.00 17.74           O  
ATOM    924  CB  VAL A 131     -40.272  14.498  -9.046  1.00 18.44           C  
ATOM    925  CG1 VAL A 131     -41.536  14.581  -8.156  1.00 17.33           C  
ATOM    926  CG2 VAL A 131     -38.984  14.198  -8.227  1.00 17.04           C  
ATOM    927  N   ALA A 132     -41.836  14.489 -11.871  1.00 17.70           N  
ATOM    928  CA  ALA A 132     -43.066  14.700 -12.650  1.00 17.09           C  
ATOM    929  C   ALA A 132     -43.433  13.445 -13.410  1.00 16.95           C  
ATOM    930  O   ALA A 132     -44.601  13.030 -13.418  1.00 18.27           O  
ATOM    931  CB  ALA A 132     -42.930  15.919 -13.602  1.00 17.64           C  
ATOM    932  N   ASN A 133     -42.434  12.807 -14.011  1.00 16.18           N  
ATOM    933  CA  ASN A 133     -42.627  11.533 -14.701  1.00 16.00           C  
ATOM    934  C   ASN A 133     -43.118  10.429 -13.793  1.00 14.54           C  
ATOM    935  O   ASN A 133     -43.978   9.617 -14.183  1.00 14.22           O  
ATOM    936  CB  ASN A 133     -41.334  11.096 -15.425  1.00 17.05           C  
ATOM    937  CG  ASN A 133     -41.043  11.940 -16.667  1.00 20.37           C  
ATOM    938  OD1 ASN A 133     -41.700  12.955 -16.907  1.00 24.12           O  
ATOM    939  ND2 ASN A 133     -40.071  11.511 -17.468  1.00 24.08           N  
ATOM    940  N   LEU A 134     -42.592  10.405 -12.576  1.00 13.72           N  
ATOM    941  CA  LEU A 134     -43.013   9.406 -11.587  1.00 13.41           C  
ATOM    942  C   LEU A 134     -44.498   9.608 -11.257  1.00 13.20           C  
ATOM    943  O   LEU A 134     -45.248   8.653 -11.179  1.00 12.77           O  
ATOM    944  CB  LEU A 134     -42.176   9.526 -10.309  1.00 13.22           C  
ATOM    945  CG  LEU A 134     -42.538   8.738  -9.036  1.00 13.77           C  
ATOM    946  CD1 LEU A 134     -42.705   7.239  -9.353  1.00  9.76           C  
ATOM    947  CD2 LEU A 134     -41.447   8.987  -7.942  1.00 12.78           C  
ATOM    948  N   LEU A 135     -44.890  10.866 -11.043  1.00 13.55           N  
ATOM    949  CA  LEU A 135     -46.259  11.168 -10.641  1.00 13.85           C  
ATOM    950  C   LEU A 135     -47.235  10.881 -11.780  1.00 13.39           C  
ATOM    951  O   LEU A 135     -48.254  10.233 -11.575  1.00 13.86           O  
ATOM    952  CB  LEU A 135     -46.383  12.598 -10.070  1.00 12.09           C  
ATOM    953  CG  LEU A 135     -45.573  12.798  -8.779  1.00 13.42           C  
ATOM    954  CD1 LEU A 135     -45.753  14.178  -8.231  1.00 14.30           C  
ATOM    955  CD2 LEU A 135     -46.008  11.819  -7.720  1.00 11.55           C  
ATOM    956  N   THR A 136     -46.903  11.293 -12.997  1.00 14.73           N  
ATOM    957  CA  THR A 136     -47.776  10.981 -14.149  1.00 14.71           C  
ATOM    958  C   THR A 136     -47.938   9.477 -14.386  1.00 14.41           C  
ATOM    959  O   THR A 136     -49.055   8.982 -14.673  1.00 13.36           O  
ATOM    960  CB  THR A 136     -47.361  11.739 -15.464  1.00 16.37           C  
ATOM    961  OG1 THR A 136     -46.075  11.290 -15.904  1.00 19.30           O  
ATOM    962  CG2 THR A 136     -47.257  13.203 -15.201  1.00 16.39           C  
ATOM    963  N   ALA A 137     -46.839   8.739 -14.237  1.00 13.85           N  
ATOM    964  CA  ALA A 137     -46.889   7.280 -14.342  1.00 13.92           C  
ATOM    965  C   ALA A 137     -47.806   6.678 -13.273  1.00 13.22           C  
ATOM    966  O   ALA A 137     -48.613   5.809 -13.564  1.00 12.36           O  
ATOM    967  CB  ALA A 137     -45.484   6.682 -14.262  1.00 14.45           C  
ATOM    968  N   ALA A 138     -47.728   7.217 -12.052  1.00 13.50           N  
ATOM    969  CA  ALA A 138     -48.599   6.789 -10.961  1.00 12.96           C  
ATOM    970  C   ALA A 138     -50.070   7.152 -11.246  1.00 13.09           C  
ATOM    971  O   ALA A 138     -50.989   6.396 -10.901  1.00 13.36           O  
ATOM    972  CB  ALA A 138     -48.108   7.408  -9.612  1.00 11.70           C  
ATOM    973  N   ILE A 139     -50.286   8.315 -11.849  1.00 13.27           N  
ATOM    974  CA  ILE A 139     -51.624   8.716 -12.256  1.00 13.67           C  
ATOM    975  C   ILE A 139     -52.142   7.752 -13.334  1.00 14.20           C  
ATOM    976  O   ILE A 139     -53.228   7.219 -13.204  1.00 13.79           O  
ATOM    977  CB  ILE A 139     -51.675  10.193 -12.716  1.00 12.93           C  
ATOM    978  CG1 ILE A 139     -51.515  11.122 -11.521  1.00 12.97           C  
ATOM    979  CG2 ILE A 139     -52.989  10.519 -13.416  1.00 13.51           C  
ATOM    980  CD1 ILE A 139     -51.061  12.522 -11.899  1.00 11.68           C  
ATOM    981  N   ASP A 140     -51.350   7.506 -14.371  1.00 15.08           N  
ATOM    982  CA  ASP A 140     -51.757   6.561 -15.422  1.00 16.67           C  
ATOM    983  C   ASP A 140     -52.088   5.158 -14.909  1.00 17.23           C  
ATOM    984  O   ASP A 140     -52.982   4.501 -15.445  1.00 16.28           O  
ATOM    985  CB  ASP A 140     -50.709   6.488 -16.531  1.00 16.79           C  
ATOM    986  CG  ASP A 140     -51.185   5.672 -17.746  1.00 21.12           C  
ATOM    987  OD1 ASP A 140     -52.236   6.004 -18.363  1.00 20.93           O  
ATOM    988  OD2 ASP A 140     -50.490   4.686 -18.075  1.00 23.24           O  
ATOM    989  N   ALA A 141     -51.382   4.715 -13.863  1.00 18.63           N  
ATOM    990  CA  ALA A 141     -51.554   3.365 -13.341  1.00 18.64           C  
ATOM    991  C   ALA A 141     -52.767   3.288 -12.413  1.00 19.02           C  
ATOM    992  O   ALA A 141     -53.117   2.212 -11.927  1.00 19.81           O  
ATOM    993  CB  ALA A 141     -50.327   2.933 -12.628  1.00 19.27           C  
ATOM    994  N   LYS A 142     -53.400   4.430 -12.205  1.00 17.49           N  
ATOM    995  CA  LYS A 142     -54.458   4.616 -11.231  1.00 17.75           C  
ATOM    996  C   LYS A 142     -54.023   4.308  -9.784  1.00 15.83           C  
ATOM    997  O   LYS A 142     -54.828   3.885  -8.956  1.00 16.17           O  
ATOM    998  CB  LYS A 142     -55.746   3.890 -11.656  1.00 19.51           C  
ATOM    999  CG  LYS A 142     -56.364   4.480 -12.949  1.00 22.04           C  
ATOM   1000  CD  LYS A 142     -57.901   4.301 -12.997  1.00 27.65           C  
ATOM   1001  CE  LYS A 142     -58.539   4.940 -14.245  1.00 27.03           C  
ATOM   1002  NZ  LYS A 142     -59.767   4.155 -14.718  1.00 30.45           N  
ATOM   1003  N   VAL A 143     -52.747   4.560  -9.509  1.00 12.06           N  
ATOM   1004  CA  VAL A 143     -52.186   4.423  -8.173  1.00 10.95           C  
ATOM   1005  C   VAL A 143     -52.461   5.676  -7.343  1.00  9.15           C  
ATOM   1006  O   VAL A 143     -52.791   5.588  -6.150  1.00 10.00           O  
ATOM   1007  CB  VAL A 143     -50.687   4.124  -8.268  1.00 10.93           C  
ATOM   1008  CG1 VAL A 143     -50.002   4.290  -6.945  1.00 11.03           C  
ATOM   1009  CG2 VAL A 143     -50.490   2.663  -8.792  1.00 11.13           C  
ATOM   1010  N   ILE A 144     -52.310   6.850  -7.946  1.00  6.38           N  
ATOM   1011  CA  ILE A 144     -52.694   8.084  -7.252  1.00  4.05           C  
ATOM   1012  C   ILE A 144     -53.821   8.773  -8.039  1.00  4.75           C  
ATOM   1013  O   ILE A 144     -54.088   8.408  -9.208  1.00  4.34           O  
ATOM   1014  CB  ILE A 144     -51.477   9.013  -7.009  1.00  3.42           C  
ATOM   1015  CG1 ILE A 144     -50.973   9.578  -8.348  1.00  3.66           C  
ATOM   1016  CG2 ILE A 144     -50.414   8.284  -6.151  1.00  2.00           C  
ATOM   1017  CD1 ILE A 144     -49.707  10.486  -8.275  1.00  2.64           C  
ATOM   1018  N   LYS A 145     -54.498   9.717  -7.394  1.00  3.71           N  
ATOM   1019  CA  LYS A 145     -55.676  10.384  -7.944  1.00  4.76           C  
ATOM   1020  C   LYS A 145     -55.485  11.050  -9.311  1.00  3.71           C  
ATOM   1021  O   LYS A 145     -54.417  11.600  -9.607  1.00  2.74           O  
ATOM   1022  CB  LYS A 145     -56.185  11.427  -6.945  1.00  4.07           C  
ATOM   1023  CG  LYS A 145     -56.728  10.799  -5.633  1.00  5.55           C  
ATOM   1024  CD  LYS A 145     -57.355  11.861  -4.715  1.00  5.07           C  
ATOM   1025  CE  LYS A 145     -58.096  11.253  -3.524  1.00  2.00           C  
ATOM   1026  NZ  LYS A 145     -57.071  10.674  -2.559  1.00  2.11           N  
ATOM   1027  N   GLN A 146     -56.528  11.017 -10.144  1.00  3.52           N  
ATOM   1028  CA  GLN A 146     -56.482  11.714 -11.444  1.00  4.58           C  
ATOM   1029  C   GLN A 146     -56.600  13.207 -11.208  1.00  3.83           C  
ATOM   1030  O   GLN A 146     -57.623  13.812 -11.508  1.00  4.69           O  
ATOM   1031  CB  GLN A 146     -57.626  11.248 -12.387  1.00  4.77           C  
ATOM   1032  CG  GLN A 146     -57.661   9.755 -12.619  1.00 11.37           C  
ATOM   1033  CD  GLN A 146     -56.404   9.253 -13.299  1.00 17.99           C  
ATOM   1034  OE1 GLN A 146     -55.779   8.298 -12.828  1.00 19.39           O  
ATOM   1035  NE2 GLN A 146     -56.001   9.924 -14.396  1.00 17.25           N  
ATOM   1036  N   LEU A 147     -55.577  13.800 -10.598  1.00  4.06           N  
ATOM   1037  CA  LEU A 147     -55.559  15.209 -10.332  1.00  2.99           C  
ATOM   1038  C   LEU A 147     -54.231  15.738 -10.841  1.00  3.08           C  
ATOM   1039  O   LEU A 147     -53.289  14.961 -11.047  1.00  2.00           O  
ATOM   1040  CB  LEU A 147     -55.670  15.472  -8.816  1.00  4.00           C  
ATOM   1041  CG  LEU A 147     -57.048  15.225  -8.160  1.00  4.57           C  
ATOM   1042  CD1 LEU A 147     -56.945  15.319  -6.649  1.00  3.60           C  
ATOM   1043  CD2 LEU A 147     -58.101  16.206  -8.706  1.00  3.05           C  
ATOM   1044  N   PRO A 148     -54.140  17.067 -11.006  1.00  2.95           N  
ATOM   1045  CA  PRO A 148     -52.923  17.638 -11.551  1.00  3.03           C  
ATOM   1046  C   PRO A 148     -51.706  17.320 -10.710  1.00  2.66           C  
ATOM   1047  O   PRO A 148     -51.761  17.226  -9.463  1.00  2.00           O  
ATOM   1048  CB  PRO A 148     -53.183  19.152 -11.562  1.00  2.25           C  
ATOM   1049  CG  PRO A 148     -54.663  19.302 -11.450  1.00  5.11           C  
ATOM   1050  CD  PRO A 148     -55.157  18.105 -10.700  1.00  3.59           C  
ATOM   1051  N   VAL A 149     -50.595  17.157 -11.418  1.00  3.12           N  
ATOM   1052  CA  VAL A 149     -49.327  16.917 -10.762  1.00  3.43           C  
ATOM   1053  C   VAL A 149     -49.053  18.000  -9.722  1.00  2.09           C  
ATOM   1054  O   VAL A 149     -48.487  17.715  -8.695  1.00  2.00           O  
ATOM   1055  CB  VAL A 149     -48.207  16.842 -11.790  1.00  3.53           C  
ATOM   1056  CG1 VAL A 149     -46.855  16.833 -11.080  1.00  5.48           C  
ATOM   1057  CG2 VAL A 149     -48.403  15.604 -12.636  1.00  4.56           C  
ATOM   1058  N   SER A 150     -49.472  19.234  -9.987  1.00  2.11           N  
ATOM   1059  CA  SER A 150     -49.176  20.358  -9.077  1.00  2.00           C  
ATOM   1060  C   SER A 150     -49.925  20.196  -7.753  1.00  2.05           C  
ATOM   1061  O   SER A 150     -49.458  20.687  -6.714  1.00  2.00           O  
ATOM   1062  CB  SER A 150     -49.546  21.717  -9.728  1.00  2.00           C  
ATOM   1063  OG  SER A 150     -50.918  21.727 -10.105  1.00  2.00           O  
ATOM   1064  N   LEU A 151     -51.084  19.519  -7.787  1.00  2.00           N  
ATOM   1065  CA  LEU A 151     -51.842  19.263  -6.554  1.00  2.00           C  
ATOM   1066  C   LEU A 151     -51.205  18.200  -5.655  1.00  2.00           C  
ATOM   1067  O   LEU A 151     -51.180  18.340  -4.432  1.00  2.00           O  
ATOM   1068  CB  LEU A 151     -53.299  18.877  -6.829  1.00  2.02           C  
ATOM   1069  CG  LEU A 151     -54.327  19.883  -7.366  1.00  6.28           C  
ATOM   1070  CD1 LEU A 151     -55.748  19.651  -6.779  1.00  7.79           C  
ATOM   1071  CD2 LEU A 151     -53.933  21.237  -7.139  1.00  6.10           C  
ATOM   1072  N   HIS A 152     -50.712  17.136  -6.277  1.00  2.00           N  
ATOM   1073  CA  HIS A 152     -49.897  16.119  -5.621  1.00  2.59           C  
ATOM   1074  C   HIS A 152     -48.593  16.674  -5.031  1.00  3.78           C  
ATOM   1075  O   HIS A 152     -48.294  16.435  -3.848  1.00  3.00           O  
ATOM   1076  CB  HIS A 152     -49.600  14.994  -6.605  1.00  2.02           C  
ATOM   1077  CG  HIS A 152     -50.781  14.106  -6.862  1.00  2.12           C  
ATOM   1078  ND1 HIS A 152     -51.444  14.059  -8.078  1.00  6.06           N  
ATOM   1079  CD2 HIS A 152     -51.423  13.240  -6.051  1.00  2.00           C  
ATOM   1080  CE1 HIS A 152     -52.448  13.194  -7.999  1.00  2.00           C  
ATOM   1081  NE2 HIS A 152     -52.444  12.682  -6.778  1.00  3.12           N  
HETATM 1082  N   MSE A 153     -47.830  17.394  -5.863  0.50  3.47           N  
HETATM 1084  CA  MSE A 153     -46.643  18.151  -5.417  0.50  4.45           C  
HETATM 1086  C   MSE A 153     -46.974  19.074  -4.248  0.50  4.11           C  
HETATM 1088  O   MSE A 153     -46.265  19.119  -3.248  0.50  4.37           O  
HETATM 1090  CB  MSE A 153     -46.094  18.997  -6.572  0.50  4.80           C  
HETATM 1092  CG  MSE A 153     -45.366  18.187  -7.638  0.50  6.10           C  
HETATM 1094 SE   MSE A 153     -43.871  17.227  -6.835  0.50 11.45          SE  
HETATM 1096  CE  MSE A 153     -42.632  18.726  -6.562  0.50  8.16           C  
ATOM   1098  N   GLY A 154     -48.069  19.804  -4.399  1.00  4.78           N  
ATOM   1099  CA  GLY A 154     -48.540  20.803  -3.416  1.00  4.38           C  
ATOM   1100  C   GLY A 154     -48.813  20.215  -2.042  1.00  4.74           C  
ATOM   1101  O   GLY A 154     -48.378  20.781  -1.027  1.00  5.66           O  
ATOM   1102  N   VAL A 155     -49.516  19.085  -1.987  1.00  4.95           N  
ATOM   1103  CA  VAL A 155     -49.801  18.436  -0.714  1.00  5.42           C  
ATOM   1104  C   VAL A 155     -48.526  17.925  -0.000  1.00  6.21           C  
ATOM   1105  O   VAL A 155     -48.400  18.072   1.230  1.00  6.65           O  
ATOM   1106  CB  VAL A 155     -50.913  17.325  -0.824  1.00  6.80           C  
ATOM   1107  CG1 VAL A 155     -50.451  16.107  -1.652  1.00  6.66           C  
ATOM   1108  CG2 VAL A 155     -51.279  16.844   0.564  1.00  7.01           C  
ATOM   1109  N   VAL A 156     -47.597  17.345  -0.772  1.00  5.42           N  
ATOM   1110  CA  VAL A 156     -46.300  16.931  -0.284  1.00  5.04           C  
ATOM   1111  C   VAL A 156     -45.549  18.113   0.316  1.00  4.99           C  
ATOM   1112  O   VAL A 156     -45.104  18.078   1.468  1.00  5.17           O  
ATOM   1113  CB  VAL A 156     -45.455  16.308  -1.427  1.00  5.13           C  
ATOM   1114  CG1 VAL A 156     -43.949  16.021  -0.959  1.00  5.74           C  
ATOM   1115  CG2 VAL A 156     -46.093  15.038  -1.890  1.00  4.94           C  
ATOM   1116  N   PHE A 157     -45.362  19.153  -0.467  1.00  3.59           N  
ATOM   1117  CA  PHE A 157     -44.538  20.249  -0.012  1.00  4.06           C  
ATOM   1118  C   PHE A 157     -45.172  21.094   1.060  1.00  4.12           C  
ATOM   1119  O   PHE A 157     -44.490  21.500   2.025  1.00  3.13           O  
ATOM   1120  CB  PHE A 157     -44.031  21.081  -1.209  1.00  4.70           C  
ATOM   1121  CG  PHE A 157     -42.848  20.443  -1.865  1.00  8.26           C  
ATOM   1122  CD1 PHE A 157     -41.569  20.888  -1.593  1.00  7.48           C  
ATOM   1123  CD2 PHE A 157     -43.014  19.320  -2.696  1.00 10.13           C  
ATOM   1124  CE1 PHE A 157     -40.476  20.263  -2.176  1.00  9.89           C  
ATOM   1125  CE2 PHE A 157     -41.945  18.697  -3.261  1.00  8.05           C  
ATOM   1126  CZ  PHE A 157     -40.666  19.153  -3.000  1.00  8.06           C  
ATOM   1127  N   SER A 158     -46.471  21.370   0.912  0.50  4.20           N  
ATOM   1129  CA  SER A 158     -47.170  22.235   1.887  0.50  4.23           C  
ATOM   1131  C   SER A 158     -47.265  21.615   3.276  0.50  4.00           C  
ATOM   1133  O   SER A 158     -47.020  22.290   4.271  0.50  4.10           O  
ATOM   1135  CB  SER A 158     -48.546  22.642   1.382  0.50  4.56           C  
ATOM   1137  OG  SER A 158     -49.285  23.269   2.407  0.50  6.82           O  
ATOM   1139  N   THR A 159     -47.581  20.325   3.326  1.00  4.09           N  
ATOM   1140  CA  THR A 159     -47.675  19.557   4.592  1.00  4.04           C  
ATOM   1141  C   THR A 159     -46.307  19.476   5.298  1.00  3.35           C  
ATOM   1142  O   THR A 159     -46.231  19.715   6.488  1.00  2.00           O  
ATOM   1143  CB  THR A 159     -48.213  18.121   4.361  1.00  3.81           C  
ATOM   1144  OG1 THR A 159     -49.508  18.212   3.742  1.00  4.71           O  
ATOM   1145  CG2 THR A 159     -48.340  17.307   5.673  1.00  2.80           C  
ATOM   1146  N   ILE A 160     -45.255  19.138   4.543  1.00  2.29           N  
ATOM   1147  CA  ILE A 160     -43.917  19.109   5.098  1.00  2.34           C  
ATOM   1148  C   ILE A 160     -43.457  20.499   5.515  1.00  2.37           C  
ATOM   1149  O   ILE A 160     -42.824  20.665   6.553  1.00  2.39           O  
ATOM   1150  CB  ILE A 160     -42.929  18.417   4.124  1.00  2.19           C  
ATOM   1151  CG1 ILE A 160     -43.262  16.910   4.060  1.00  3.28           C  
ATOM   1152  CG2 ILE A 160     -41.483  18.700   4.523  1.00  2.00           C  
ATOM   1153  CD1 ILE A 160     -42.563  16.142   2.886  1.00  3.12           C  
ATOM   1154  N   HIS A 161     -43.774  21.512   4.713  1.00  2.76           N  
ATOM   1155  CA  HIS A 161     -43.352  22.842   5.073  1.00  3.38           C  
ATOM   1156  C   HIS A 161     -43.995  23.308   6.391  1.00  3.29           C  
ATOM   1157  O   HIS A 161     -43.296  23.793   7.253  1.00  3.42           O  
ATOM   1158  CB  HIS A 161     -43.622  23.830   3.936  1.00  2.85           C  
ATOM   1159  CG  HIS A 161     -43.027  25.172   4.174  1.00  5.14           C  
ATOM   1160  ND1 HIS A 161     -43.557  26.323   3.646  1.00 10.38           N  
ATOM   1161  CD2 HIS A 161     -41.948  25.553   4.894  1.00  5.27           C  
ATOM   1162  CE1 HIS A 161     -42.835  27.359   4.040  1.00  7.80           C  
ATOM   1163  NE2 HIS A 161     -41.857  26.917   4.798  1.00  4.17           N  
ATOM   1164  N   THR A 162     -45.315  23.149   6.527  1.00  3.58           N  
ATOM   1165  CA  THR A 162     -46.055  23.516   7.741  1.00  4.93           C  
ATOM   1166  C   THR A 162     -45.499  22.790   8.972  1.00  4.45           C  
ATOM   1167  O   THR A 162     -45.275  23.393  10.019  1.00  5.41           O  
ATOM   1168  CB  THR A 162     -47.567  23.243   7.594  1.00  4.48           C  
ATOM   1169  OG1 THR A 162     -48.086  23.941   6.446  1.00  6.37           O  
ATOM   1170  CG2 THR A 162     -48.342  23.727   8.817  1.00  6.40           C  
ATOM   1171  N   HIS A 163     -45.267  21.499   8.826  1.00  4.08           N  
ATOM   1172  CA  HIS A 163     -44.726  20.670   9.900  1.00  4.19           C  
ATOM   1173  C   HIS A 163     -43.343  21.212  10.316  1.00  4.08           C  
ATOM   1174  O   HIS A 163     -43.047  21.329  11.492  1.00  4.05           O  
ATOM   1175  CB  HIS A 163     -44.674  19.207   9.398  1.00  2.87           C  
ATOM   1176  CG  HIS A 163     -44.143  18.220  10.401  1.00  5.30           C  
ATOM   1177  ND1 HIS A 163     -44.643  18.106  11.684  1.00  5.00           N  
ATOM   1178  CD2 HIS A 163     -43.186  17.267  10.288  1.00  2.00           C  
ATOM   1179  CE1 HIS A 163     -44.003  17.138  12.323  1.00  4.22           C  
ATOM   1180  NE2 HIS A 163     -43.113  16.617  11.500  1.00  4.65           N  
ATOM   1181  N   THR A 164     -42.519  21.578   9.329  1.00  4.15           N  
ATOM   1182  CA  THR A 164     -41.177  22.121   9.592  1.00  4.43           C  
ATOM   1183  C   THR A 164     -41.206  23.452  10.349  1.00  4.91           C  
ATOM   1184  O   THR A 164     -40.501  23.612  11.325  1.00  4.58           O  
ATOM   1185  CB  THR A 164     -40.410  22.313   8.285  1.00  4.70           C  
ATOM   1186  OG1 THR A 164     -40.347  21.033   7.617  1.00  4.73           O  
ATOM   1187  CG2 THR A 164     -38.977  22.853   8.568  1.00  3.27           C  
ATOM   1188  N   THR A 165     -42.041  24.389   9.902  1.00  4.45           N  
ATOM   1189  CA  THR A 165     -42.135  25.679  10.564  1.00  4.54           C  
ATOM   1190  C   THR A 165     -42.819  25.532  11.931  1.00  4.92           C  
ATOM   1191  O   THR A 165     -42.477  26.249  12.861  1.00  5.80           O  
ATOM   1192  CB  THR A 165     -42.848  26.743   9.662  1.00  4.63           C  
ATOM   1193  OG1 THR A 165     -44.168  26.313   9.397  1.00  6.79           O  
ATOM   1194  CG2 THR A 165     -42.163  26.899   8.317  1.00  4.57           C  
ATOM   1195  N   ASN A 166     -43.751  24.587  12.069  1.00  4.39           N  
ATOM   1196  CA  ASN A 166     -44.330  24.306  13.399  1.00  4.22           C  
ATOM   1197  C   ASN A 166     -43.228  23.942  14.394  1.00  4.08           C  
ATOM   1198  O   ASN A 166     -43.234  24.387  15.563  1.00  3.98           O  
ATOM   1199  CB  ASN A 166     -45.344  23.145  13.358  1.00  2.96           C  
ATOM   1200  CG  ASN A 166     -46.726  23.540  12.840  1.00  3.17           C  
ATOM   1201  OD1 ASN A 166     -47.083  24.706  12.775  1.00  3.54           O  
ATOM   1202  ND2 ASN A 166     -47.523  22.517  12.456  1.00  2.30           N  
ATOM   1203  N   ILE A 167     -42.270  23.134  13.935  1.00  4.19           N  
ATOM   1204  CA  ILE A 167     -41.148  22.738  14.799  1.00  3.79           C  
ATOM   1205  C   ILE A 167     -40.234  23.940  15.114  1.00  3.71           C  
ATOM   1206  O   ILE A 167     -39.799  24.097  16.254  1.00  3.24           O  
ATOM   1207  CB  ILE A 167     -40.392  21.487  14.231  1.00  3.65           C  
ATOM   1208  CG1 ILE A 167     -41.288  20.229  14.348  1.00  4.31           C  
ATOM   1209  CG2 ILE A 167     -39.010  21.237  14.951  1.00  4.38           C  
ATOM   1210  CD1 ILE A 167     -40.920  19.122  13.368  1.00  3.43           C  
ATOM   1211  N   SER A 168     -39.967  24.799  14.127  1.00  3.71           N  
ATOM   1212  CA  SER A 168     -39.150  26.008  14.367  1.00  5.60           C  
ATOM   1213  C   SER A 168     -39.808  27.002  15.309  1.00  5.06           C  
ATOM   1214  O   SER A 168     -39.118  27.767  15.987  1.00  4.49           O  
ATOM   1215  CB  SER A 168     -38.821  26.737  13.034  1.00  6.53           C  
ATOM   1216  OG  SER A 168     -38.175  25.839  12.163  1.00 10.24           O  
ATOM   1217  N   LYS A 169     -41.141  27.016  15.308  1.00  5.79           N  
ATOM   1218  CA  LYS A 169     -41.939  27.925  16.143  1.00  6.67           C  
ATOM   1219  C   LYS A 169     -42.161  27.411  17.572  1.00  5.99           C  
ATOM   1220  O   LYS A 169     -42.837  28.054  18.380  1.00  6.58           O  
ATOM   1221  CB  LYS A 169     -43.284  28.180  15.471  1.00  7.87           C  
ATOM   1222  CG  LYS A 169     -43.200  29.387  14.510  1.00 11.89           C  
ATOM   1223  CD  LYS A 169     -43.837  29.124  13.166  1.00 17.22           C  
ATOM   1224  CE  LYS A 169     -45.352  29.209  13.187  1.00 19.79           C  
ATOM   1225  NZ  LYS A 169     -45.819  29.652  11.794  1.00 21.35           N  
ATOM   1226  N   GLY A 170     -41.600  26.250  17.862  1.00  4.71           N  
ATOM   1227  CA  GLY A 170     -41.736  25.634  19.162  1.00  3.74           C  
ATOM   1228  C   GLY A 170     -43.117  25.088  19.423  1.00  3.70           C  
ATOM   1229  O   GLY A 170     -43.490  24.945  20.566  1.00  3.45           O  
ATOM   1230  N   ARG A 171     -43.881  24.761  18.385  1.00  4.07           N  
ATOM   1231  CA  ARG A 171     -45.245  24.266  18.624  1.00  5.14           C  
ATOM   1232  C   ARG A 171     -45.263  22.847  19.181  1.00  4.94           C  
ATOM   1233  O   ARG A 171     -46.172  22.488  19.927  1.00  4.78           O  
ATOM   1234  CB  ARG A 171     -46.107  24.347  17.362  1.00  6.16           C  
ATOM   1235  CG  ARG A 171     -46.314  25.768  16.894  1.00  8.45           C  
ATOM   1236  CD  ARG A 171     -47.306  25.797  15.775  1.00 14.64           C  
ATOM   1237  NE  ARG A 171     -47.777  27.160  15.537  1.00 18.31           N  
ATOM   1238  CZ  ARG A 171     -48.522  27.546  14.500  1.00 19.27           C  
ATOM   1239  NH1 ARG A 171     -48.889  26.676  13.544  1.00 15.78           N  
ATOM   1240  NH2 ARG A 171     -48.878  28.825  14.417  1.00 20.61           N  
ATOM   1241  N   TYR A 172     -44.266  22.042  18.808  1.00  4.47           N  
ATOM   1242  CA  TYR A 172     -44.101  20.695  19.348  1.00  4.26           C  
ATOM   1243  C   TYR A 172     -42.677  20.289  18.996  1.00  5.42           C  
ATOM   1244  O   TYR A 172     -42.013  20.994  18.191  1.00  5.22           O  
ATOM   1245  CB  TYR A 172     -45.175  19.715  18.813  1.00  3.50           C  
ATOM   1246  CG  TYR A 172     -45.411  19.748  17.307  1.00  4.05           C  
ATOM   1247  CD1 TYR A 172     -46.492  20.455  16.772  1.00  3.23           C  
ATOM   1248  CD2 TYR A 172     -44.559  19.061  16.412  1.00  3.62           C  
ATOM   1249  CE1 TYR A 172     -46.725  20.502  15.387  1.00  4.88           C  
ATOM   1250  CE2 TYR A 172     -44.794  19.100  14.999  1.00  2.00           C  
ATOM   1251  CZ  TYR A 172     -45.872  19.824  14.516  1.00  3.56           C  
ATOM   1252  OH  TYR A 172     -46.155  19.868  13.162  1.00  4.45           O  
ATOM   1253  N   ALA A 173     -42.197  19.195  19.591  1.00  5.76           N  
ATOM   1254  CA  ALA A 173     -40.822  18.721  19.350  1.00  7.40           C  
ATOM   1255  C   ALA A 173     -40.653  18.088  17.970  1.00  8.48           C  
ATOM   1256  O   ALA A 173     -41.630  17.639  17.355  1.00  8.13           O  
ATOM   1257  CB  ALA A 173     -40.403  17.726  20.462  1.00  7.25           C  
ATOM   1258  N   GLN A 174     -39.409  18.000  17.494  1.00  9.83           N  
ATOM   1259  CA  GLN A 174     -39.130  17.310  16.217  1.00 11.47           C  
ATOM   1260  C   GLN A 174     -39.591  15.837  16.176  1.00 10.99           C  
ATOM   1261  O   GLN A 174     -39.958  15.330  15.110  1.00 12.50           O  
ATOM   1262  CB  GLN A 174     -37.641  17.439  15.829  1.00 12.54           C  
ATOM   1263  CG  GLN A 174     -37.409  17.436  14.288  1.00 15.52           C  
ATOM   1264  CD  GLN A 174     -35.949  17.356  13.878  1.00 15.56           C  
ATOM   1265  OE1 GLN A 174     -35.094  18.043  14.447  1.00 21.93           O  
ATOM   1266  NE2 GLN A 174     -35.652  16.512  12.880  1.00 16.97           N  
ATOM   1267  N   ASP A 175     -39.625  15.192  17.344  0.50 10.61           N  
ATOM   1269  CA  ASP A 175     -39.954  13.770  17.467  0.50  9.69           C  
ATOM   1271  C   ASP A 175     -41.388  13.523  17.937  0.50  8.76           C  
ATOM   1273  O   ASP A 175     -41.786  12.384  18.186  0.50  8.94           O  
ATOM   1275  CB  ASP A 175     -38.988  13.106  18.452  0.50 10.00           C  
ATOM   1277  CG  ASP A 175     -39.234  13.542  19.888  0.50 10.89           C  
ATOM   1279  OD1 ASP A 175     -39.393  14.753  20.131  0.50 11.05           O  
ATOM   1281  OD2 ASP A 175     -39.285  12.670  20.778  0.50 12.77           O  
ATOM   1283  N   GLN A 176     -42.172  14.582  18.077  1.00  8.01           N  
ATOM   1284  CA  GLN A 176     -43.555  14.416  18.510  1.00  7.54           C  
ATOM   1285  C   GLN A 176     -44.304  13.488  17.508  1.00  6.75           C  
ATOM   1286  O   GLN A 176     -45.045  12.590  17.911  1.00  6.84           O  
ATOM   1287  CB  GLN A 176     -44.254  15.769  18.634  1.00  7.83           C  
ATOM   1288  CG  GLN A 176     -45.687  15.630  19.201  1.00 11.45           C  
ATOM   1289  CD  GLN A 176     -45.671  15.315  20.670  1.00 19.37           C  
ATOM   1290  OE1 GLN A 176     -44.904  15.925  21.458  1.00 21.05           O  
ATOM   1291  NE2 GLN A 176     -46.504  14.356  21.073  1.00 21.34           N  
ATOM   1292  N   TYR A 177     -44.085  13.717  16.210  1.00  5.79           N  
ATOM   1293  CA  TYR A 177     -44.670  12.906  15.114  1.00  5.82           C  
ATOM   1294  C   TYR A 177     -43.593  12.222  14.338  1.00  5.80           C  
ATOM   1295  O   TYR A 177     -42.482  12.728  14.244  1.00  6.95           O  
ATOM   1296  CB  TYR A 177     -45.487  13.795  14.145  1.00  5.03           C  
ATOM   1297  CG  TYR A 177     -46.604  14.491  14.886  1.00  5.52           C  
ATOM   1298  CD1 TYR A 177     -47.826  13.822  15.156  1.00  4.65           C  
ATOM   1299  CD2 TYR A 177     -46.424  15.806  15.365  1.00  2.62           C  
ATOM   1300  CE1 TYR A 177     -48.837  14.452  15.879  1.00  3.40           C  
ATOM   1301  CE2 TYR A 177     -47.433  16.449  16.081  1.00  2.37           C  
ATOM   1302  CZ  TYR A 177     -48.619  15.789  16.330  1.00  3.98           C  
ATOM   1303  OH  TYR A 177     -49.583  16.479  17.039  1.00  5.69           O  
ATOM   1304  N   THR A 178     -43.909  11.066  13.775  1.00  5.83           N  
ATOM   1305  CA  THR A 178     -42.955  10.323  12.987  1.00  5.78           C  
ATOM   1306  C   THR A 178     -43.229  10.622  11.522  1.00  5.41           C  
ATOM   1307  O   THR A 178     -44.250  11.258  11.179  1.00  5.30           O  
ATOM   1308  CB  THR A 178     -43.127   8.821  13.219  1.00  6.12           C  
ATOM   1309  OG1 THR A 178     -44.468   8.460  12.875  1.00  6.96           O  
ATOM   1310  CG2 THR A 178     -42.860   8.466  14.689  1.00  8.40           C  
ATOM   1311  N   PHE A 179     -42.304  10.217  10.660  1.00  4.70           N  
ATOM   1312  CA  PHE A 179     -42.549  10.332   9.244  1.00  4.14           C  
ATOM   1313  C   PHE A 179     -43.841   9.563   8.927  1.00  3.91           C  
ATOM   1314  O   PHE A 179     -44.620  10.005   8.132  1.00  4.04           O  
ATOM   1315  CB  PHE A 179     -41.381   9.762   8.429  1.00  4.20           C  
ATOM   1316  CG  PHE A 179     -41.728   9.567   6.956  1.00  3.94           C  
ATOM   1317  CD1 PHE A 179     -41.889  10.675   6.130  1.00  3.20           C  
ATOM   1318  CD2 PHE A 179     -41.904   8.295   6.424  1.00  2.00           C  
ATOM   1319  CE1 PHE A 179     -42.243  10.523   4.769  1.00  6.30           C  
ATOM   1320  CE2 PHE A 179     -42.248   8.133   5.045  1.00  2.00           C  
ATOM   1321  CZ  PHE A 179     -42.418   9.259   4.232  1.00  2.00           C  
ATOM   1322  N   GLY A 180     -44.030   8.390   9.537  1.00  3.35           N  
ATOM   1323  CA  GLY A 180     -45.212   7.595   9.306  1.00  3.67           C  
ATOM   1324  C   GLY A 180     -46.485   8.399   9.608  1.00  3.64           C  
ATOM   1325  O   GLY A 180     -47.470   8.297   8.888  1.00  2.68           O  
ATOM   1326  N   ASP A 181     -46.495   9.148  10.706  1.00  3.64           N  
ATOM   1327  CA  ASP A 181     -47.697   9.947  11.049  1.00  4.47           C  
ATOM   1328  C   ASP A 181     -48.025  11.005   9.962  1.00  4.65           C  
ATOM   1329  O   ASP A 181     -49.187  11.167   9.566  1.00  5.47           O  
ATOM   1330  CB  ASP A 181     -47.532  10.682  12.382  1.00  3.67           C  
ATOM   1331  CG  ASP A 181     -47.361   9.741  13.560  1.00  6.93           C  
ATOM   1332  OD1 ASP A 181     -47.956   8.636  13.550  1.00  4.89           O  
ATOM   1333  OD2 ASP A 181     -46.624  10.125  14.492  1.00  6.59           O  
ATOM   1334  N   ILE A 182     -47.003  11.744   9.532  1.00  4.87           N  
ATOM   1335  CA  ILE A 182     -47.182  12.815   8.558  1.00  4.95           C  
ATOM   1336  C   ILE A 182     -47.462  12.242   7.165  1.00  4.98           C  
ATOM   1337  O   ILE A 182     -48.329  12.747   6.427  1.00  5.45           O  
ATOM   1338  CB  ILE A 182     -45.924  13.716   8.525  1.00  6.52           C  
ATOM   1339  CG1 ILE A 182     -45.563  14.249   9.927  1.00  5.38           C  
ATOM   1340  CG2 ILE A 182     -46.070  14.837   7.462  1.00  5.76           C  
ATOM   1341  CD1 ILE A 182     -46.732  15.000  10.655  1.00  8.01           C  
ATOM   1342  N   PHE A 183     -46.731  11.182   6.796  1.00  4.51           N  
ATOM   1343  CA  PHE A 183     -46.918  10.517   5.497  1.00  4.33           C  
ATOM   1344  C   PHE A 183     -48.309   9.907   5.400  1.00  3.92           C  
ATOM   1345  O   PHE A 183     -48.838   9.790   4.312  1.00  5.10           O  
ATOM   1346  CB  PHE A 183     -45.872   9.409   5.262  1.00  3.53           C  
ATOM   1347  CG  PHE A 183     -45.925   8.814   3.852  1.00  3.83           C  
ATOM   1348  CD1 PHE A 183     -45.749   9.630   2.725  1.00  6.45           C  
ATOM   1349  CD2 PHE A 183     -46.145   7.468   3.657  1.00  2.95           C  
ATOM   1350  CE1 PHE A 183     -45.812   9.100   1.440  1.00  7.05           C  
ATOM   1351  CE2 PHE A 183     -46.188   6.924   2.377  1.00  2.00           C  
ATOM   1352  CZ  PHE A 183     -46.030   7.732   1.272  1.00  3.20           C  
ATOM   1353  N   GLN A 184     -48.921   9.517   6.520  1.00  3.88           N  
ATOM   1354  CA  GLN A 184     -50.297   8.997   6.421  1.00  4.84           C  
ATOM   1355  C   GLN A 184     -51.263  10.068   5.810  1.00  4.74           C  
ATOM   1356  O   GLN A 184     -52.074   9.773   4.909  1.00  4.63           O  
ATOM   1357  CB  GLN A 184     -50.793   8.488   7.766  1.00  4.25           C  
ATOM   1358  CG  GLN A 184     -52.085   7.657   7.667  1.00  8.46           C  
ATOM   1359  CD  GLN A 184     -52.707   7.432   9.038  1.00 13.98           C  
ATOM   1360  OE1 GLN A 184     -52.865   8.378   9.841  1.00 17.54           O  
ATOM   1361  NE2 GLN A 184     -53.017   6.186   9.336  1.00 12.76           N  
HETATM 1362  N   MSE A 185     -51.155  11.307   6.268  1.00  4.99           N  
HETATM 1363  CA  MSE A 185     -51.969  12.395   5.680  1.00  5.80           C  
HETATM 1364  C   MSE A 185     -51.636  12.625   4.174  1.00  4.76           C  
HETATM 1365  O   MSE A 185     -52.528  12.686   3.331  1.00  4.82           O  
HETATM 1366  CB  MSE A 185     -51.816  13.692   6.470  1.00  4.44           C  
HETATM 1367  CG  MSE A 185     -52.219  14.928   5.613  1.00  7.54           C  
HETATM 1368 SE   MSE A 185     -52.218  16.557   6.672  0.80  8.94          SE  
HETATM 1369  CE  MSE A 185     -53.937  16.453   7.567  1.00  6.13           C  
ATOM   1370  N   ILE A 186     -50.347  12.728   3.848  1.00  4.69           N  
ATOM   1371  CA  ILE A 186     -49.899  13.008   2.472  1.00  3.87           C  
ATOM   1372  C   ILE A 186     -50.268  11.891   1.505  1.00  4.00           C  
ATOM   1373  O   ILE A 186     -50.759  12.154   0.417  1.00  3.18           O  
ATOM   1374  CB  ILE A 186     -48.379  13.260   2.434  1.00  4.29           C  
ATOM   1375  CG1 ILE A 186     -48.023  14.553   3.206  1.00  3.68           C  
ATOM   1376  CG2 ILE A 186     -47.840  13.239   0.986  1.00  6.20           C  
ATOM   1377  CD1 ILE A 186     -46.530  14.684   3.476  1.00  3.62           C  
ATOM   1378  N   TRP A 187     -50.030  10.643   1.919  1.00  3.89           N  
ATOM   1379  CA  TRP A 187     -50.328   9.478   1.076  1.00  4.07           C  
ATOM   1380  C   TRP A 187     -51.828   9.264   0.883  1.00  3.58           C  
ATOM   1381  O   TRP A 187     -52.266   8.965  -0.227  1.00  3.71           O  
ATOM   1382  CB  TRP A 187     -49.642   8.176   1.615  1.00  3.71           C  
ATOM   1383  CG  TRP A 187     -49.874   6.926   0.732  1.00  2.27           C  
ATOM   1384  CD1 TRP A 187     -50.440   5.732   1.123  1.00  4.12           C  
ATOM   1385  CD2 TRP A 187     -49.561   6.767  -0.677  1.00  4.06           C  
ATOM   1386  NE1 TRP A 187     -50.487   4.864   0.066  1.00  3.98           N  
ATOM   1387  CE2 TRP A 187     -49.976   5.469  -1.052  1.00  2.32           C  
ATOM   1388  CE3 TRP A 187     -49.002   7.616  -1.662  1.00  3.39           C  
ATOM   1389  CZ2 TRP A 187     -49.816   4.977  -2.361  1.00  6.32           C  
ATOM   1390  CZ3 TRP A 187     -48.856   7.141  -2.955  1.00  4.82           C  
ATOM   1391  CH2 TRP A 187     -49.263   5.832  -3.304  1.00  3.11           C  
ATOM   1392  N   ASP A 188     -52.613   9.365   1.956  1.00  3.65           N  
ATOM   1393  CA  ASP A 188     -54.100   9.394   1.815  1.00  3.37           C  
ATOM   1394  C   ASP A 188     -54.582  10.468   0.814  1.00  3.73           C  
ATOM   1395  O   ASP A 188     -55.473  10.210  -0.022  1.00  2.56           O  
ATOM   1396  CB  ASP A 188     -54.804   9.617   3.167  1.00  2.79           C  
ATOM   1397  CG  ASP A 188     -54.692   8.413   4.087  1.00  3.42           C  
ATOM   1398  OD1 ASP A 188     -54.193   7.378   3.618  1.00  3.28           O  
ATOM   1399  OD2 ASP A 188     -55.096   8.497   5.272  1.00  2.91           O  
ATOM   1400  N   ALA A 189     -54.026  11.675   0.945  1.00  3.20           N  
ATOM   1401  CA  ALA A 189     -54.373  12.808   0.034  1.00  3.15           C  
ATOM   1402  C   ALA A 189     -54.130  12.384  -1.411  1.00  3.82           C  
ATOM   1403  O   ALA A 189     -54.993  12.541  -2.237  1.00  4.62           O  
ATOM   1404  CB  ALA A 189     -53.531  13.996   0.337  1.00  2.39           C  
HETATM 1405  N   MSE A 190     -52.958  11.817  -1.687  1.00  4.45           N  
HETATM 1406  CA  MSE A 190     -52.559  11.430  -3.053  1.00  6.49           C  
HETATM 1407  C   MSE A 190     -53.231  10.168  -3.630  1.00  6.64           C  
HETATM 1408  O   MSE A 190     -53.524  10.113  -4.816  1.00  7.26           O  
HETATM 1409  CB  MSE A 190     -51.032  11.194  -3.117  1.00  5.90           C  
HETATM 1410  CG  MSE A 190     -50.150  12.405  -2.721  1.00  3.04           C  
HETATM 1411 SE   MSE A 190     -48.287  11.921  -2.677  0.70  8.34          SE  
HETATM 1412  CE  MSE A 190     -47.857  11.894  -4.588  1.00  3.49           C  
ATOM   1413  N   LYS A 191     -53.388   9.133  -2.823  1.00  7.67           N  
ATOM   1414  CA  LYS A 191     -53.662   7.806  -3.366  1.00  7.79           C  
ATOM   1415  C   LYS A 191     -55.059   7.658  -3.938  1.00  7.32           C  
ATOM   1416  O   LYS A 191     -55.996   8.316  -3.503  1.00  6.14           O  
ATOM   1417  CB  LYS A 191     -53.328   6.687  -2.370  1.00  7.52           C  
ATOM   1418  CG  LYS A 191     -54.365   6.438  -1.302  1.00 10.94           C  
ATOM   1419  CD  LYS A 191     -53.998   5.197  -0.488  1.00 13.76           C  
ATOM   1420  CE  LYS A 191     -54.568   5.285   0.918  1.00 15.51           C  
ATOM   1421  NZ  LYS A 191     -56.032   5.144   0.803  1.00 18.76           N  
ATOM   1422  N   GLN A 192     -55.174   6.795  -4.946  1.00  9.33           N  
ATOM   1423  CA  GLN A 192     -56.404   6.643  -5.699  1.00 12.08           C  
ATOM   1424  C   GLN A 192     -57.482   5.950  -4.829  1.00 13.91           C  
ATOM   1425  O   GLN A 192     -57.232   4.899  -4.258  1.00 14.06           O  
ATOM   1426  CB  GLN A 192     -56.101   5.898  -6.988  1.00 12.89           C  
ATOM   1427  CG  GLN A 192     -57.307   5.272  -7.689  1.00 15.10           C  
ATOM   1428  CD  GLN A 192     -58.217   6.321  -8.305  1.00 18.66           C  
ATOM   1429  OE1 GLN A 192     -57.773   7.179  -9.081  1.00 19.03           O  
ATOM   1430  NE2 GLN A 192     -59.507   6.241  -7.979  1.00 20.70           N  
ATOM   1431  N   ASP A 193     -58.665   6.579  -4.766  1.00 16.98           N  
ATOM   1432  CA  ASP A 193     -59.748   6.392  -3.757  1.00 17.93           C  
ATOM   1433  C   ASP A 193     -59.624   7.316  -2.512  1.00 18.64           C  
ATOM   1434  O   ASP A 193     -58.808   7.029  -1.629  1.00 17.85           O  
ATOM   1435  CB  ASP A 193     -59.856   4.956  -3.327  1.00 19.18           C  
ATOM   1436  CG  ASP A 193     -60.435   4.064  -4.410  1.00 21.94           C  
ATOM   1437  OD1 ASP A 193     -60.974   3.007  -4.035  1.00 24.99           O  
ATOM   1438  OD2 ASP A 193     -60.348   4.413  -5.610  1.00 23.03           O  
ATOM   1439  OXT ASP A 193     -60.326   8.339  -2.336  1.00 17.71           O  
TER    1440      ASP A 193                                                      
END
MOLECULE T0454.pdb
ATOM      1  N   ASP     5     -12.420  32.658   0.024  1.00 27.13           N
ATOM      2  CA  ASP     5     -13.312  32.598   1.217  1.00 27.34           C
ATOM      3  CB  ASP     5     -12.512  32.690   2.520  1.00 28.50           C
ATOM      4  CG  ASP     5     -13.404  32.599   3.759  1.00 30.42           C
ATOM      5  OD1 ASP     5     -14.289  31.706   3.803  1.00 33.47           O
ATOM      6  OD2 ASP     5     -13.226  33.430   4.680  1.00 32.05           O
ATOM      7  C   ASP     5     -14.424  33.644   1.238  1.00 26.73           C
ATOM      8  O   ASP     5     -15.477  33.398   1.835  1.00 26.63           O
ATOM      9  N   CYS     6     -14.211  34.799   0.611  0.50 26.41           N
ATOM     11  CA  CYS     6     -15.286  35.794   0.531  0.50 26.28           C
ATOM     13  CB  CYS     6     -14.751  37.198   0.241  0.50 26.57           C
ATOM     15  SG  CYS     6     -14.050  37.968   1.731  0.50 29.41           S
ATOM     17  C   CYS     6     -16.388  35.363  -0.439  0.50 25.38           C
ATOM     19  O   CYS     6     -17.496  35.901  -0.414  0.50 25.34           O
ATOM     21  N   ARG     7     -16.080  34.368  -1.271  1.00 24.45           N
ATOM     22  CA  ARG     7     -17.093  33.680  -2.080  1.00 22.28           C
ATOM     23  CB  ARG     7     -16.421  32.728  -3.079  1.00 22.90           C
ATOM     30  C   ARG     7     -18.066  32.903  -1.186  1.00 20.46           C
ATOM     31  O   ARG     7     -19.262  32.867  -1.449  1.00 20.43           O
ATOM     32  N   SER     8     -17.547  32.253  -0.148  0.50 19.10           N
ATOM     34  CA  SER     8     -18.391  31.436   0.731  0.50 17.33           C
ATOM     36  CB  SER     8     -17.550  30.493   1.586  0.50 17.45           C
ATOM     38  OG  SER     8     -18.312  29.968   2.658  0.50 15.65           O
ATOM     40  C   SER     8     -19.258  32.322   1.613  0.50 16.60           C
ATOM     42  O   SER     8     -20.455  32.084   1.776  0.50 15.91           O
ATOM     44  N   ARG     9     -18.645  33.365   2.159  0.50 15.61           N
ATOM     46  CA  ARG     9     -19.363  34.297   3.022  0.50 14.83           C
ATOM     48  CB  ARG     9     -18.372  35.205   3.766  0.50 15.25           C
ATOM     50  CG  ARG     9     -17.394  34.394   4.628  0.50 14.59           C
ATOM     52  CD  ARG     9     -16.768  35.163   5.795  0.50 16.76           C
ATOM     54  NE  ARG     9     -15.709  36.081   5.358  0.50 18.23           N
ATOM     56  CZ  ARG     9     -15.907  37.364   5.046  0.50 17.11           C
ATOM     58  NH1 ARG     9     -14.883  38.115   4.657  0.50 16.37           N
ATOM     60  NH2 ARG     9     -17.129  37.896   5.121  0.50 17.10           N
ATOM     62  C   ARG     9     -20.452  35.089   2.282  0.50 14.49           C
ATOM     64  O   ARG     9     -21.506  35.370   2.850  0.50 13.18           O
ATOM     66  N   LEU    10     -20.187  35.432   1.021  1.00 14.14           N
ATOM     67  CA  LEU    10     -21.183  36.018   0.143  1.00 15.70           C
ATOM     68  CB  LEU    10     -20.580  36.459  -1.201  1.00 16.55           C
ATOM     69  CG  LEU    10     -20.226  37.923  -1.321  1.00 18.07           C
ATOM     70  CD1 LEU    10     -19.435  38.165  -2.626  1.00 18.10           C
ATOM     71  CD2 LEU    10     -21.495  38.769  -1.285  1.00 16.77           C
ATOM     72  C   LEU    10     -22.364  35.072  -0.083  1.00 15.96           C
ATOM     73  O   LEU    10     -23.511  35.520  -0.035  1.00 16.63           O
ATOM     74  N   MET    11     -22.097  33.792  -0.326  0.70 16.06           N
ATOM     76  CA  MET    11     -23.179  32.843  -0.534  0.70 17.38           C
ATOM     78  CB  MET    11     -22.637  31.461  -0.863  0.70 20.17           C
ATOM     80  CG  MET    11     -22.166  31.316  -2.273  0.70 25.34           C
ATOM     82  SD  MET    11     -23.611  30.818  -3.503  0.70 46.93          SE
ATOM     84  CE  MET    11     -22.374  30.088  -4.856  0.70 32.85           C
ATOM     86  C   MET    11     -24.065  32.759   0.707  0.70 15.90           C
ATOM     88  O   MET    11     -25.298  32.724   0.592  0.70 14.79           O
ATOM     90  N   GLU    12     -23.436  32.726   1.888  1.00 13.16           N
ATOM     91  CA  GLU    12     -24.186  32.691   3.141  1.00 12.28           C
ATOM     92  CB  GLU    12     -23.255  32.550   4.367  1.00 11.62           C
ATOM     93  CG  GLU    12     -24.006  32.676   5.679  1.00 12.98           C
ATOM     94  CD  GLU    12     -24.899  31.451   5.972  1.00 17.78           C
ATOM     95  OE1 GLU    12     -24.548  30.339   5.520  1.00 20.61           O
ATOM     96  OE2 GLU    12     -25.952  31.593   6.636  1.00 18.33           O
ATOM     97  C   GLU    12     -25.062  33.946   3.278  1.00 11.77           C
ATOM     98  O   GLU    12     -26.263  33.868   3.569  1.00 10.95           O
ATOM     99  N   VAL    13     -24.441  35.104   3.102  1.00 11.38           N
ATOM    100  CA  VAL    13     -25.143  36.347   3.297  1.00 11.79           C
ATOM    101  CB  VAL    13     -24.168  37.555   3.216  1.00 11.85           C
ATOM    102  CG1 VAL    13     -24.903  38.816   2.771  1.00 13.25           C
ATOM    103  CG2 VAL    13     -23.437  37.739   4.528  1.00 12.09           C
ATOM    104  C   VAL    13     -26.264  36.469   2.270  1.00 12.08           C
ATOM    105  O   VAL    13     -27.360  36.860   2.613  1.00 12.20           O
ATOM    106  N   ALA    14     -25.987  36.132   1.016  1.00 11.94           N
ATOM    107  CA  ALA    14     -27.028  36.192  -0.026  1.00 12.57           C
ATOM    108  CB  ALA    14     -26.434  35.847  -1.397  1.00 12.81           C
ATOM    109  C   ALA    14     -28.224  35.272   0.324  1.00 12.70           C
ATOM    110  O   ALA    14     -29.404  35.681   0.225  1.00 12.49           O
ATOM    111  N   THR    15     -27.933  34.045   0.752  1.00 12.08           N
ATOM    112  CA  THR    15     -29.000  33.092   1.088  1.00 13.57           C
ATOM    113  CB  THR    15     -28.420  31.727   1.526  1.00 13.02           C
ATOM    114  OG1 THR    15     -27.592  31.204   0.477  1.00 13.54           O
ATOM    115  CG2 THR    15     -29.544  30.705   1.864  1.00 14.11           C
ATOM    116  C   THR    15     -29.885  33.685   2.197  1.00 13.81           C
ATOM    117  O   THR    15     -31.100  33.676   2.080  1.00 14.69           O
ATOM    118  N   GLU    16     -29.283  34.229   3.251  0.50 12.86           N
ATOM    120  CA  GLU    16     -30.060  34.743   4.392  0.50 12.65           C
ATOM    122  CB  GLU    16     -29.168  34.850   5.619  0.50 11.98           C
ATOM    124  CG  GLU    16     -28.366  33.560   5.847  0.50 10.56           C
ATOM    126  CD  GLU    16     -29.193  32.437   6.436  0.50 10.50           C
ATOM    128  OE1 GLU    16     -29.690  32.653   7.554  0.50 13.56           O
ATOM    130  OE2 GLU    16     -29.343  31.334   5.814  0.50  9.37           O
ATOM    132  C   GLU    16     -30.844  36.053   4.135  0.50 13.06           C
ATOM    134  O   GLU    16     -31.941  36.247   4.680  0.50 12.44           O
ATOM    136  N   LEU    17     -30.289  36.937   3.304  1.00 13.39           N
ATOM    137  CA  LEU    17     -30.999  38.157   2.904  1.00 13.60           C
ATOM    138  CB  LEU    17     -30.022  39.257   2.439  1.00 13.92           C
ATOM    139  CG  LEU    17     -29.168  39.859   3.564  1.00 15.45           C
ATOM    140  CD1 LEU    17     -28.242  40.964   3.019  1.00 18.76           C
ATOM    141  CD2 LEU    17     -30.008  40.355   4.753  1.00 18.21           C
ATOM    142  C   LEU    17     -32.079  37.907   1.841  1.00 13.42           C
ATOM    143  O   LEU    17     -33.201  38.400   2.004  1.00 13.35           O
ATOM    144  N   PHE    18     -31.772  37.132   0.800  1.00 12.52           N
ATOM    145  CA  PHE    18     -32.789  36.767  -0.188  1.00 12.55           C
ATOM    146  CB  PHE    18     -32.168  36.032  -1.355  1.00 12.74           C
ATOM    147  CG  PHE    18     -31.341  36.895  -2.267  1.00 11.67           C
ATOM    148  CD1 PHE    18     -31.865  38.079  -2.813  1.00 12.22           C
ATOM    149  CE1 PHE    18     -31.138  38.864  -3.706  1.00 12.93           C
ATOM    150  CZ  PHE    18     -29.843  38.455  -4.104  1.00 13.62           C
ATOM    151  CE2 PHE    18     -29.308  37.240  -3.582  1.00 11.19           C
ATOM    152  CD2 PHE    18     -30.083  36.472  -2.677  1.00 11.90           C
ATOM    153  C   PHE    18     -33.889  35.866   0.419  1.00 13.51           C
ATOM    154  O   PHE    18     -35.054  35.962   0.015  1.00 15.25           O
ATOM    155  N   ALA    19     -33.532  34.996   1.373  1.00 13.39           N
ATOM    156  CA  ALA    19     -34.553  34.208   2.061  1.00 15.05           C
ATOM    157  CB  ALA    19     -33.942  33.133   2.992  1.00 14.27           C
ATOM    158  C   ALA    19     -35.536  35.094   2.817  1.00 15.36           C
ATOM    159  O   ALA    19     -36.754  34.842   2.737  1.00 16.78           O
ATOM    160  N   GLN    20     -35.009  36.097   3.541  0.70 16.27           N
ATOM    162  CA  GLN    20     -35.806  37.053   4.335  0.70 16.80           C
ATOM    164  CB  GLN    20     -34.946  37.989   5.239  0.70 17.01           C
ATOM    166  CG  GLN    20     -35.745  39.306   5.640  0.70 16.81           C
ATOM    168  CD  GLN    20     -35.206  40.143   6.812  0.70 17.74           C
ATOM    170  OE1 GLN    20     -35.154  41.393   6.736  0.70 13.85           O
ATOM    172  NE2 GLN    20     -34.830  39.472   7.903  0.70 18.70           N
ATOM    174  C   GLN    20     -36.691  37.941   3.482  0.70 17.07           C
ATOM    176  O   GLN    20     -37.900  38.009   3.701  0.70 17.23           O
ATOM    178  N   LYS    21     -36.060  38.636   2.537  1.00 15.44           N
ATOM    179  CA  LYS    21     -36.656  39.778   1.820  1.00 16.20           C
ATOM    180  CB  LYS    21     -35.693  40.954   1.797  1.00 16.65           C
ATOM    181  CG  LYS    21     -35.259  41.391   3.184  1.00 19.64           C
ATOM    182  CD  LYS    21     -34.363  42.583   3.043  1.00 22.59           C
ATOM    183  CE  LYS    21     -33.720  42.901   4.359  1.00 25.71           C
ATOM    184  NZ  LYS    21     -33.292  44.316   4.378  1.00 29.79           N
ATOM    185  C   LYS    21     -37.021  39.482   0.389  1.00 15.03           C
ATOM    186  O   LYS    21     -37.639  40.317  -0.275  1.00 16.30           O
ATOM    187  N   GLY    22     -36.632  38.313  -0.101  1.00 14.81           N
ATOM    188  CA  GLY    22     -36.879  37.954  -1.501  1.00 12.41           C
ATOM    189  C   GLY    22     -35.967  38.743  -2.431  1.00 13.23           C
ATOM    190  O   GLY    22     -35.355  39.762  -2.034  1.00 13.65           O
ATOM    191  N   PHE    23     -35.857  38.255  -3.660  1.00 12.90           N
ATOM    192  CA  PHE    23     -35.064  38.952  -4.675  1.00 13.24           C
ATOM    193  CB  PHE    23     -35.255  38.297  -6.043  1.00 15.31           C
ATOM    194  CG  PHE    23     -34.544  39.016  -7.130  1.00 16.26           C
ATOM    195  CD1 PHE    23     -33.214  38.729  -7.414  1.00 17.28           C
ATOM    196  CE1 PHE    23     -32.528  39.446  -8.406  1.00 17.88           C
ATOM    197  CZ  PHE    23     -33.173  40.390  -9.137  1.00 18.69           C
ATOM    198  CE2 PHE    23     -34.531  40.677  -8.884  1.00 18.23           C
ATOM    199  CD2 PHE    23     -35.193  40.000  -7.883  1.00 18.32           C
ATOM    200  C   PHE    23     -35.468  40.425  -4.758  1.00 14.16           C
ATOM    201  O   PHE    23     -34.604  41.312  -4.880  1.00 14.45           O
ATOM    202  N   TYR    24     -36.778  40.690  -4.743  1.00 14.52           N
ATOM    203  CA  TYR    24     -37.263  42.057  -4.998  1.00 15.59           C
ATOM    204  CB  TYR    24     -38.733  42.085  -5.422  1.00 13.51           C
ATOM    205  CG  TYR    24     -38.963  41.406  -6.781  1.00 13.47           C
ATOM    206  CD1 TYR    24     -38.665  42.064  -7.967  1.00 12.55           C
ATOM    207  CE1 TYR    24     -38.890  41.458  -9.241  1.00 13.28           C
ATOM    208  CZ  TYR    24     -39.399  40.139  -9.303  1.00 10.43           C
ATOM    209  OH  TYR    24     -39.630  39.577 -10.572  1.00 11.31           O
ATOM    210  CE2 TYR    24     -39.713  39.475  -8.126  1.00 11.68           C
ATOM    211  CD2 TYR    24     -39.493  40.106  -6.858  1.00 14.21           C
ATOM    212  C   TYR    24     -37.080  42.970  -3.806  1.00 16.80           C
ATOM    213  O   TYR    24     -37.286  44.167  -3.939  1.00 18.89           O
ATOM    214  N   GLY    25     -36.702  42.429  -2.656  1.00 16.86           N
ATOM    215  CA  GLY    25     -36.488  43.287  -1.478  1.00 17.30           C
ATOM    216  C   GLY    25     -35.036  43.519  -1.070  1.00 18.19           C
ATOM    217  O   GLY    25     -34.787  44.141  -0.042  1.00 18.97           O
ATOM    218  N   VAL    26     -34.080  42.983  -1.822  1.00 17.80           N
ATOM    219  CA  VAL    26     -32.653  43.017  -1.434  1.00 17.86           C
ATOM    220  CB  VAL    26     -32.053  41.567  -1.526  1.00 16.88           C
ATOM    221  CG1 VAL    26     -30.493  41.578  -1.523  1.00 19.19           C
ATOM    222  CG2 VAL    26     -32.546  40.691  -0.382  1.00 17.09           C
ATOM    223  C   VAL    26     -31.896  43.951  -2.405  1.00 18.57           C
ATOM    224  O   VAL    26     -32.112  43.860  -3.619  1.00 19.26           O
ATOM    225  N   SER    27     -31.024  44.837  -1.900  1.00 18.29           N
ATOM    226  CA  SER    27     -30.188  45.651  -2.802  1.00 18.73           C
ATOM    227  CB  SER    27     -30.240  47.135  -2.451  1.00 18.20           C
ATOM    228  OG  SER    27     -29.499  47.385  -1.297  1.00 19.53           O
ATOM    229  C   SER    27     -28.743  45.196  -2.781  1.00 18.39           C
ATOM    230  O   SER    27     -28.296  44.592  -1.823  1.00 18.07           O
ATOM    231  N   ILE    28     -28.001  45.507  -3.836  1.00 18.31           N
ATOM    232  CA  ILE    28     -26.587  45.151  -3.866  1.00 18.54           C
ATOM    233  CB  ILE    28     -25.953  45.425  -5.232  1.00 18.62           C
ATOM    234  CG1 ILE    28     -24.599  44.703  -5.348  1.00 18.14           C
ATOM    235  CD1 ILE    28     -23.953  44.785  -6.743  1.00 19.13           C
ATOM    236  CG2 ILE    28     -25.915  46.963  -5.537  1.00 18.10           C
ATOM    237  C   ILE    28     -25.825  45.846  -2.714  1.00 18.97           C
ATOM    238  O   ILE    28     -24.902  45.274  -2.156  1.00 17.66           O
ATOM    239  N   ARG    29     -26.211  47.076  -2.360  1.00 19.97           N
ATOM    240  CA  ARG    29     -25.589  47.737  -1.207  1.00 22.13           C
ATOM    241  CB  ARG    29     -26.120  49.174  -1.012  1.00 21.53           C
ATOM    242  CG  ARG    29     -25.467  49.925   0.170  1.00 25.16           C
ATOM    243  CD  ARG    29     -26.316  51.109   0.743  1.00 26.22           C
ATOM    244  NE  ARG    29     -27.682  50.707   1.142  1.00 35.15           N
ATOM    245  CZ  ARG    29     -28.010  50.032   2.256  1.00 36.75           C
ATOM    246  NH1 ARG    29     -27.084  49.650   3.137  1.00 38.29           N
ATOM    247  NH2 ARG    29     -29.285  49.730   2.492  1.00 38.04           N
ATOM    248  C   ARG    29     -25.725  46.902   0.085  1.00 21.09           C
ATOM    249  O   ARG    29     -24.730  46.691   0.798  1.00 19.92           O
ATOM    250  N   GLU    30     -26.937  46.412   0.371  1.00 22.16           N
ATOM    251  CA  GLU    30     -27.160  45.541   1.551  1.00 22.56           C
ATOM    252  CB  GLU    30     -28.618  45.119   1.693  1.00 23.46           C
ATOM    253  CG  GLU    30     -29.623  46.242   1.841  1.00 28.08           C
ATOM    254  CD  GLU    30     -31.046  45.786   1.483  1.00 34.28           C
ATOM    255  OE1 GLU    30     -31.275  44.555   1.368  1.00 33.74           O
ATOM    256  OE2 GLU    30     -31.935  46.662   1.307  1.00 37.15           O
ATOM    257  C   GLU    30     -26.301  44.272   1.533  1.00 21.44           C
ATOM    258  O   GLU    30     -25.795  43.856   2.577  1.00 21.23           O
ATOM    259  N   LEU    31     -26.170  43.640   0.359  1.00 19.98           N
ATOM    260  CA  LEU    31     -25.338  42.431   0.251  1.00 18.96           C
ATOM    261  CB  LEU    31     -25.426  41.823  -1.145  1.00 18.00           C
ATOM    262  CG  LEU    31     -26.768  41.239  -1.562  1.00 18.12           C
ATOM    263  CD1 LEU    31     -26.678  40.931  -3.057  1.00 16.01           C
ATOM    264  CD2 LEU    31     -27.078  39.993  -0.744  1.00 18.33           C
ATOM    265  C   LEU    31     -23.871  42.715   0.588  1.00 18.24           C
ATOM    266  O   LEU    31     -23.227  41.984   1.363  1.00 18.55           O
ATOM    267  N   ALA    32     -23.328  43.776  -0.005  1.00 18.07           N
ATOM    268  CA  ALA    32     -21.928  44.131   0.234  1.00 17.87           C
ATOM    269  CB  ALA    32     -21.533  45.282  -0.659  1.00 17.05           C
ATOM    270  C   ALA    32     -21.689  44.449   1.719  1.00 18.48           C
ATOM    271  O   ALA    32     -20.741  43.938   2.338  1.00 18.50           O
ATOM    272  N   GLN    33     -22.577  45.264   2.282  1.00 18.14           N
ATOM    273  CA  GLN    33     -22.467  45.687   3.672  1.00 18.66           C
ATOM    274  CB  GLN    33     -23.613  46.652   4.012  1.00 18.81           C
ATOM    279  C   GLN    33     -22.496  44.452   4.579  1.00 18.25           C
ATOM    280  O   GLN    33     -21.649  44.307   5.470  1.00 19.06           O
ATOM    281  N   ALA    34     -23.456  43.552   4.355  1.00 18.35           N
ATOM    282  CA  ALA    34     -23.588  42.387   5.224  1.00 17.57           C
ATOM    283  CB  ALA    34     -24.915  41.670   4.988  1.00 18.88           C
ATOM    284  C   ALA    34     -22.400  41.424   5.094  1.00 17.93           C
ATOM    285  O   ALA    34     -22.007  40.800   6.073  1.00 18.07           O
ATOM    286  N   ALA    35     -21.812  41.324   3.902  1.00 17.59           N
ATOM    287  CA  ALA    35     -20.653  40.434   3.662  1.00 17.45           C
ATOM    288  CB  ALA    35     -20.742  39.832   2.241  1.00 17.60           C
ATOM    289  C   ALA    35     -19.271  41.084   3.858  1.00 17.39           C
ATOM    290  O   ALA    35     -18.253  40.386   3.869  1.00 17.10           O
ATOM    291  N   GLY    36     -19.216  42.410   3.975  1.00 17.53           N
ATOM    292  CA  GLY    36     -17.934  43.120   4.053  1.00 17.54           C
ATOM    293  C   GLY    36     -17.142  43.046   2.755  1.00 18.20           C
ATOM    294  O   GLY    36     -15.894  43.109   2.760  1.00 18.83           O
ATOM    295  N   ALA    37     -17.868  42.917   1.638  1.00 18.05           N
ATOM    296  CA  ALA    37     -17.298  42.947   0.287  1.00 17.70           C
ATOM    297  CB  ALA    37     -17.905  41.813  -0.553  1.00 17.69           C
ATOM    298  C   ALA    37     -17.594  44.299  -0.377  1.00 17.25           C
ATOM    299  O   ALA    37     -18.512  44.995   0.029  1.00 17.90           O
ATOM    300  N   SER    38     -16.844  44.680  -1.401  1.00 16.01           N
ATOM    301  CA  SER    38     -17.181  45.941  -2.083  1.00 15.66           C
ATOM    302  CB  SER    38     -15.986  46.530  -2.815  1.00 15.99           C
ATOM    303  OG  SER    38     -15.465  45.574  -3.709  1.00 15.63           O
ATOM    304  C   SER    38     -18.275  45.670  -3.090  1.00 15.23           C
ATOM    305  O   SER    38     -18.390  44.545  -3.568  1.00 14.69           O
ATOM    306  N   ILE    39     -19.054  46.696  -3.426  1.00 14.99           N
ATOM    307  CA  ILE    39     -20.019  46.586  -4.524  1.00 16.34           C
ATOM    308  CB  ILE    39     -20.795  47.908  -4.725  1.00 18.03           C
ATOM    309  CG1 ILE    39     -21.771  48.099  -3.551  1.00 18.95           C
ATOM    310  CD1 ILE    39     -22.260  49.551  -3.403  1.00 24.07           C
ATOM    311  CG2 ILE    39     -21.568  47.905  -6.053  1.00 19.22           C
ATOM    312  C   ILE    39     -19.321  46.142  -5.820  1.00 14.71           C
ATOM    313  O   ILE    39     -19.846  45.293  -6.544  1.00 14.07           O
ATOM    314  N   SER    40     -18.089  46.604  -6.010  0.50 14.67           N
ATOM    316  CA  SER    40     -17.279  46.176  -7.148  0.50 14.62           C
ATOM    318  CB  SER    40     -16.053  47.060  -7.335  0.50 14.94           C
ATOM    320  OG  SER    40     -16.458  48.367  -7.690  0.50 15.23           O
ATOM    322  C   SER    40     -16.894  44.691  -7.144  0.50 14.74           C
ATOM    324  O   SER    40     -17.018  44.048  -8.190  0.50 13.11           O
ATOM    326  N   MET    41     -16.429  44.140  -6.011  0.70 14.50           N
ATOM    328  CA  MET    41     -16.178  42.699  -5.979  0.70 17.69           C
ATOM    330  CB  MET    41     -15.783  42.221  -4.589  0.70 17.10           C
ATOM    332  CG  MET    41     -14.312  42.342  -4.347  0.70 22.14           C
ATOM    334  SD  MET    41     -13.942  42.349  -2.431  0.70 31.19          SE
ATOM    336  CE  MET    41     -12.415  43.576  -2.469  0.70 24.49           C
ATOM    338  C   MET    41     -17.447  41.995  -6.467  0.70 13.85           C
ATOM    340  O   MET    41     -17.391  41.116  -7.335  0.70 12.19           O
ATOM    342  N   ILE    42     -18.586  42.445  -5.946  1.00 11.54           N
ATOM    343  CA  ILE    42     -19.860  41.745  -6.191  1.00 10.80           C
ATOM    344  CB  ILE    42     -21.001  42.280  -5.316  1.00 11.27           C
ATOM    345  CG1 ILE    42     -20.695  41.978  -3.842  1.00 13.93           C
ATOM    346  CD1 ILE    42     -21.839  42.300  -2.903  1.00 16.88           C
ATOM    347  CG2 ILE    42     -22.327  41.616  -5.716  1.00 12.87           C
ATOM    348  C   ILE    42     -20.219  41.838  -7.658  1.00  8.83           C
ATOM    349  O   ILE    42     -20.497  40.819  -8.306  1.00  9.33           O
ATOM    350  N   SER    43     -20.157  43.052  -8.211  1.00  8.95           N
ATOM    351  CA  SER    43     -20.581  43.239  -9.602  1.00  9.74           C
ATOM    352  CB  SER    43     -20.655  44.729  -9.931  1.00 10.68           C
ATOM    353  OG  SER    43     -21.770  45.278  -9.279  1.00 13.08           O
ATOM    354  C   SER    43     -19.645  42.587 -10.619  1.00  9.62           C
ATOM    355  O   SER    43     -20.105  42.053 -11.624  1.00  9.13           O
ATOM    356  N   TYR    44     -18.328  42.697 -10.382  1.00  9.20           N
ATOM    357  CA  TYR    44     -17.361  42.244 -11.376  1.00 10.08           C
ATOM    358  CB  TYR    44     -16.121  43.137 -11.344  1.00  9.76           C
ATOM    359  CG  TYR    44     -16.373  44.487 -11.942  1.00  8.65           C
ATOM    360  CD1 TYR    44     -16.965  45.500 -11.184  1.00  8.93           C
ATOM    361  CE1 TYR    44     -17.202  46.730 -11.711  1.00 10.45           C
ATOM    362  CZ  TYR    44     -16.853  46.987 -13.027  1.00 10.79           C
ATOM    363  OH  TYR    44     -17.090  48.220 -13.553  1.00 11.57           O
ATOM    364  CE2 TYR    44     -16.260  46.002 -13.818  1.00 10.86           C
ATOM    365  CD2 TYR    44     -16.019  44.758 -13.255  1.00  9.35           C
ATOM    366  C   TYR    44     -16.923  40.795 -11.222  1.00 12.28           C
ATOM    367  O   TYR    44     -16.468  40.193 -12.203  1.00 12.21           O
ATOM    368  N   HIS    45     -16.993  40.271 -10.000  1.00 14.53           N
ATOM    369  CA  HIS    45     -16.489  38.928  -9.730  1.00 17.90           C
ATOM    370  CB  HIS    45     -15.347  38.951  -8.714  1.00 18.81           C
ATOM    371  CG  HIS    45     -14.062  39.424  -9.294  1.00 21.69           C
ATOM    372  ND1 HIS    45     -13.118  40.111  -8.564  1.00 26.38           N
ATOM    373  CE1 HIS    45     -12.092  40.405  -9.346  1.00 27.60           C
ATOM    374  NE2 HIS    45     -12.350  39.958 -10.563  1.00 26.67           N
ATOM    375  CD2 HIS    45     -13.574  39.339 -10.558  1.00 25.29           C
ATOM    376  C   HIS    45     -17.532  37.898  -9.348  1.00 19.42           C
ATOM    377  O   HIS    45     -17.334  36.722  -9.630  1.00 19.75           O
ATOM    378  N   PHE    46     -18.630  38.324  -8.726  1.00 20.52           N
ATOM    379  CA  PHE    46     -19.661  37.377  -8.261  1.00 22.82           C
ATOM    380  CB  PHE    46     -19.800  37.465  -6.732  1.00 23.98           C
ATOM    381  CG  PHE    46     -18.496  37.308  -6.003  1.00 26.04           C
ATOM    382  CD1 PHE    46     -18.012  36.039  -5.670  1.00 29.01           C
ATOM    383  CE1 PHE    46     -16.817  35.893  -5.005  1.00 27.12           C
ATOM    384  CZ  PHE    46     -16.071  37.013  -4.649  1.00 28.27           C
ATOM    385  CE2 PHE    46     -16.542  38.280  -4.963  1.00 29.34           C
ATOM    386  CD2 PHE    46     -17.743  38.419  -5.640  1.00 27.17           C
ATOM    387  C   PHE    46     -21.004  37.504  -8.954  1.00 22.70           C
ATOM    388  O   PHE    46     -22.017  36.978  -8.483  1.00 25.73           O
ATOM    389  N   GLY    47     -21.020  38.197 -10.083  1.00 20.71           N
ATOM    390  CA  GLY    47     -22.178  38.260 -10.943  1.00 19.73           C
ATOM    391  C   GLY    47     -23.257  39.227 -10.550  1.00 18.52           C
ATOM    392  O   GLY    47     -24.373  39.148 -11.073  1.00 20.99           O
ATOM    393  N   GLY    48     -22.955  40.137  -9.620  1.00 14.66           N
ATOM    394  CA  GLY    48     -23.926  41.115  -9.145  1.00 14.41           C
ATOM    395  C   GLY    48     -25.035  40.479  -8.295  1.00 13.29           C
ATOM    396  O   GLY    48     -24.959  39.296  -7.948  1.00 12.06           O
ATOM    397  N   LYS    49     -26.021  41.290  -7.929  1.00 13.51           N
ATOM    398  CA  LYS    49     -27.206  40.794  -7.200  1.00 13.00           C
ATOM    399  CB  LYS    49     -28.212  41.934  -7.086  1.00 14.01           C
ATOM    400  CG  LYS    49     -29.503  41.518  -6.350  1.00 15.37           C
ATOM    401  CD  LYS    49     -30.528  42.649  -6.447  1.00 16.73           C
ATOM    402  CE  LYS    49     -31.905  42.078  -6.083  1.00 17.71           C
ATOM    403  NZ  LYS    49     -32.895  43.218  -6.101  1.00 18.77           N
ATOM    404  C   LYS    49     -27.809  39.595  -7.932  1.00 13.68           C
ATOM    405  O   LYS    49     -28.212  38.583  -7.331  1.00 13.27           O
ATOM    406  N   GLU    50     -27.876  39.703  -9.258  1.00 12.63           N
ATOM    407  CA  GLU    50     -28.627  38.725 -10.042  1.00 12.69           C
ATOM    408  CB  GLU    50     -28.814  39.232 -11.468  1.00 13.68           C
ATOM    409  CG  GLU    50     -29.657  40.500 -11.528  1.00 14.16           C
ATOM    410  CD  GLU    50     -28.887  41.815 -11.286  1.00 16.98           C
ATOM    411  OE1 GLU    50     -27.638  41.867 -11.018  1.00 15.01           O
ATOM    412  OE2 GLU    50     -29.566  42.854 -11.451  1.00 19.39           O
ATOM    413  C   GLU    50     -27.883  37.393 -10.048  1.00 12.35           C
ATOM    414  O   GLU    50     -28.506  36.350  -9.816  1.00 13.25           O
ATOM    415  N   GLY    51     -26.567  37.455 -10.306  1.00 11.97           N
ATOM    416  CA  GLY    51     -25.695  36.286 -10.303  1.00 11.39           C
ATOM    417  C   GLY    51     -25.724  35.592  -8.952  1.00 13.31           C
ATOM    418  O   GLY    51     -25.865  34.369  -8.874  1.00 12.68           O
ATOM    419  N   LEU    52     -25.637  36.365  -7.877  1.00 12.96           N
ATOM    420  CA  LEU    52     -25.702  35.752  -6.544  1.00 13.84           C
ATOM    421  CB  LEU    52     -25.453  36.774  -5.450  1.00 13.00           C
ATOM    422  CG  LEU    52     -24.017  37.257  -5.300  1.00 15.32           C
ATOM    423  CD1 LEU    52     -24.026  38.415  -4.321  1.00 17.15           C
ATOM    424  CD2 LEU    52     -23.089  36.110  -4.862  1.00 13.25           C
ATOM    425  C   LEU    52     -27.047  35.092  -6.282  1.00 13.75           C
ATOM    426  O   LEU    52     -27.092  34.016  -5.680  1.00 14.21           O
ATOM    427  N   TYR    53     -28.140  35.744  -6.693  1.00 14.29           N
ATOM    428  CA  TYR    53     -29.441  35.176  -6.517  1.00 14.44           C
ATOM    429  CB  TYR    53     -30.541  36.161  -6.936  1.00 12.90           C
ATOM    430  CG  TYR    53     -31.928  35.606  -6.681  1.00 13.47           C
ATOM    431  CD1 TYR    53     -32.405  35.437  -5.365  1.00 13.59           C
ATOM    432  CE1 TYR    53     -33.679  34.910  -5.123  1.00 14.34           C
ATOM    433  CZ  TYR    53     -34.477  34.537  -6.198  1.00 13.72           C
ATOM    434  OH  TYR    53     -35.718  34.039  -5.965  1.00 13.83           O
ATOM    435  CE2 TYR    53     -34.023  34.711  -7.525  1.00 13.18           C
ATOM    436  CD2 TYR    53     -32.751  35.220  -7.740  1.00 11.75           C
ATOM    437  C   TYR    53     -29.578  33.863  -7.306  1.00 14.35           C
ATOM    438  O   TYR    53     -30.064  32.892  -6.754  1.00 14.84           O
ATOM    439  N   ALA    54     -29.125  33.849  -8.569  1.00 14.57           N
ATOM    440  CA  ALA    54     -29.145  32.612  -9.394  1.00 14.76           C
ATOM    441  CB  ALA    54     -28.572  32.882 -10.785  1.00 15.38           C
ATOM    442  C   ALA    54     -28.382  31.465  -8.737  1.00 16.02           C
ATOM    443  O   ALA    54     -28.853  30.302  -8.752  1.00 16.58           O
ATOM    444  N   ALA    55     -27.206  31.790  -8.179  1.00 15.71           N
ATOM    445  CA  ALA    55     -26.349  30.797  -7.512  1.00 16.60           C
ATOM    446  CB  ALA    55     -24.985  31.418  -7.114  1.00 15.94           C
ATOM    447  C   ALA    55     -27.087  30.239  -6.293  1.00 16.62           C
ATOM    448  O   ALA    55     -27.124  29.027  -6.079  1.00 17.79           O
ATOM    449  N   VAL    56     -27.698  31.121  -5.509  1.00 16.55           N
ATOM    450  CA  VAL    56     -28.442  30.724  -4.309  1.00 17.16           C
ATOM    451  CB  VAL    56     -28.958  31.984  -3.551  1.00 17.77           C
ATOM    452  CG1 VAL    56     -30.068  31.623  -2.591  1.00 18.51           C
ATOM    453  CG2 VAL    56     -27.808  32.716  -2.799  1.00 16.47           C
ATOM    454  C   VAL    56     -29.643  29.805  -4.680  1.00 17.90           C
ATOM    455  O   VAL    56     -29.872  28.769  -4.064  1.00 18.42           O
ATOM    456  N   LEU    57     -30.409  30.209  -5.690  1.00 18.83           N
ATOM    457  CA  LEU    57     -31.588  29.428  -6.064  1.00 20.44           C
ATOM    458  CB  LEU    57     -32.429  30.224  -7.058  1.00 19.98           C
ATOM    459  CG  LEU    57     -33.922  29.962  -7.106  1.00 25.44           C
ATOM    460  CD1 LEU    57     -34.592  30.145  -5.755  1.00 24.83           C
ATOM    461  CD2 LEU    57     -34.480  30.939  -8.118  1.00 27.85           C
ATOM    462  C   LEU    57     -31.165  28.050  -6.627  1.00 20.90           C
ATOM    463  O   LEU    57     -31.808  27.031  -6.345  1.00 20.75           O
ATOM    464  N   GLN    58     -30.052  28.016  -7.360  1.00 21.09           N
ATOM    465  CA  GLN    58     -29.551  26.768  -7.929  1.00 22.36           C
ATOM    466  CB  GLN    58     -28.346  26.998  -8.858  1.00 23.54           C
ATOM    467  CG  GLN    58     -27.960  25.733  -9.635  1.00 27.99           C
ATOM    468  CD  GLN    58     -29.191  25.021 -10.220  1.00 35.26           C
ATOM    469  OE1 GLN    58     -29.888  25.570 -11.083  1.00 37.09           O
ATOM    470  NE2 GLN    58     -29.469  23.796  -9.736  1.00 38.37           N
ATOM    471  C   GLN    58     -29.205  25.793  -6.803  1.00 22.27           C
ATOM    472  O   GLN    58     -29.522  24.575  -6.887  1.00 22.87           O
ATOM    473  N   GLU    59     -28.579  26.306  -5.741  0.50 21.38           N
ATOM    475  CA  GLU    59     -28.271  25.503  -4.553  0.50 21.43           C
ATOM    477  CB  GLU    59     -27.388  26.269  -3.553  0.50 21.44           C
ATOM    479  CG  GLU    59     -26.869  25.393  -2.378  0.50 21.69           C
ATOM    481  CD  GLU    59     -26.114  26.171  -1.293  0.50 22.85           C
ATOM    483  OE1 GLU    59     -25.921  27.400  -1.427  0.50 25.49           O
ATOM    485  OE2 GLU    59     -25.705  25.539  -0.292  0.50 22.88           O
ATOM    487  C   GLU    59     -29.535  25.040  -3.848  0.50 20.81           C
ATOM    489  O   GLU    59     -29.586  23.907  -3.359  0.50 20.84           O
ATOM    491  N   GLN    60     -30.526  25.927  -3.763  1.00 20.01           N
ATOM    492  CA  GLN    60     -31.823  25.588  -3.146  1.00 20.01           C
ATOM    493  CB  GLN    60     -32.751  26.812  -3.069  1.00 18.91           C
ATOM    494  CG  GLN    60     -32.254  27.942  -2.169  1.00 22.57           C
ATOM    495  CD  GLN    60     -32.132  27.523  -0.695  1.00 23.52           C
ATOM    496  OE1 GLN    60     -33.063  26.939  -0.124  1.00 25.17           O
ATOM    497  NE2 GLN    60     -30.987  27.798  -0.090  1.00 23.26           N
ATOM    498  C   GLN    60     -32.527  24.444  -3.865  1.00 18.38           C
ATOM    499  O   GLN    60     -33.135  23.578  -3.222  1.00 19.77           O
ATOM    500  N   PHE    61     -32.428  24.422  -5.192  1.00 18.84           N
ATOM    501  CA  PHE    61     -33.171  23.452  -5.980  1.00 18.05           C
ATOM    502  CB  PHE    61     -33.920  24.171  -7.089  1.00 18.50           C
ATOM    503  CG  PHE    61     -35.166  24.855  -6.603  1.00 16.29           C
ATOM    504  CD1 PHE    61     -35.097  26.142  -6.066  1.00 16.96           C
ATOM    505  CE1 PHE    61     -36.246  26.777  -5.586  1.00 17.57           C
ATOM    506  CZ  PHE    61     -37.469  26.128  -5.639  1.00 16.05           C
ATOM    507  CE2 PHE    61     -37.562  24.840  -6.149  1.00 16.94           C
ATOM    508  CD2 PHE    61     -36.415  24.206  -6.655  1.00 16.84           C
ATOM    509  C   PHE    61     -32.316  22.293  -6.529  1.00 18.86           C
ATOM    510  O   PHE    61     -32.799  21.474  -7.288  1.00 17.68           O
ATOM    511  N   ALA    62     -31.039  22.250  -6.153  1.00 19.75           N
ATOM    512  CA  ALA    62     -30.116  21.245  -6.684  1.00 20.70           C
ATOM    513  CB  ALA    62     -28.776  21.377  -5.988  1.00 21.27           C
ATOM    514  C   ALA    62     -30.639  19.784  -6.602  1.00 21.89           C
ATOM    515  O   ALA    62     -30.568  19.023  -7.588  1.00 22.43           O
ATOM    516  N   CYS    63     -31.180  19.433  -5.431  0.50 22.09           N
ATOM    518  CA  CYS    63     -31.713  18.088  -5.137  0.50 22.45           C
ATOM    520  CB  CYS    63     -32.194  18.002  -3.682  0.50 21.93           C
ATOM    522  SG  CYS    63     -30.917  17.628  -2.464  0.50 27.26           S
ATOM    524  C   CYS    63     -32.836  17.625  -6.072  0.50 21.59           C
ATOM    526  O   CYS    63     -33.089  16.419  -6.196  0.50 20.76           O
ATOM    528  N   PHE    64     -33.520  18.570  -6.711  1.00 20.75           N
ATOM    529  CA  PHE    64     -34.567  18.235  -7.659  1.00 20.96           C
ATOM    530  CB  PHE    64     -35.405  19.451  -8.035  1.00 19.37           C
ATOM    531  CG  PHE    64     -36.415  19.870  -6.996  1.00 19.26           C
ATOM    532  CD1 PHE    64     -36.028  20.573  -5.872  1.00 19.73           C
ATOM    533  CE1 PHE    64     -36.994  21.017  -4.934  1.00 18.87           C
ATOM    534  CZ  PHE    64     -38.331  20.739  -5.155  1.00 17.71           C
ATOM    535  CE2 PHE    64     -38.722  20.056  -6.260  1.00 18.01           C
ATOM    536  CD2 PHE    64     -37.778  19.643  -7.202  1.00 18.03           C
ATOM    537  C   PHE    64     -34.008  17.587  -8.957  1.00 21.96           C
ATOM    538  O   PHE    64     -34.743  16.934  -9.688  1.00 23.37           O
ATOM    539  N   GLY    65     -32.716  17.728  -9.209  1.00 22.10           N
ATOM    540  CA  GLY    65     -32.106  17.074 -10.371  1.00 23.22           C
ATOM    541  C   GLY    65     -31.577  15.697 -10.034  1.00 24.11           C
ATOM    542  O   GLY    65     -30.930  15.040 -10.873  1.00 24.63           O
ATOM    543  N   GLN    66     -31.841  15.266  -8.802  1.00 24.05           N
ATOM    544  CA  GLN    66     -31.357  13.993  -8.283  1.00 24.54           C
ATOM    545  CB  GLN    66     -30.285  14.241  -7.234  1.00 25.47           C
ATOM    546  CG  GLN    66     -28.910  14.511  -7.854  1.00 30.42           C
ATOM    547  CD  GLN    66     -28.001  15.342  -6.962  1.00 36.44           C
ATOM    548  OE1 GLN    66     -28.382  16.421  -6.479  1.00 39.74           O
ATOM    549  NE2 GLN    66     -26.784  14.859  -6.761  1.00 37.88           N
ATOM    550  C   GLN    66     -32.519  13.185  -7.688  1.00 23.92           C
ATOM    551  O   GLN    66     -32.671  13.075  -6.467  1.00 23.62           O
ATOM    552  N   LEU    67     -33.319  12.616  -8.579  1.00 22.78           N
ATOM    553  CA  LEU    67     -34.545  11.916  -8.200  1.00 21.55           C
ATOM    554  CB  LEU    67     -35.668  12.370  -9.128  1.00 21.58           C
ATOM    555  CG  LEU    67     -35.860  13.887  -9.236  1.00 21.33           C
ATOM    556  CD1 LEU    67     -36.995  14.155 -10.180  1.00 22.06           C
ATOM    557  CD2 LEU    67     -36.147  14.475  -7.858  1.00 21.71           C
ATOM    558  C   LEU    67     -34.455  10.391  -8.219  1.00 21.26           C
ATOM    559  O   LEU    67     -35.485   9.730  -8.205  1.00 20.77           O
ATOM    560  N   ASP    68     -33.243   9.827  -8.209  1.00 20.58           N
ATOM    561  CA  ASP    68     -33.066   8.375  -8.336  1.00 21.06           C
ATOM    562  CB  ASP    68     -31.588   8.003  -8.545  1.00 22.43           C
ATOM    563  CG  ASP    68     -31.143   8.118 -10.019  1.00 25.47           C
ATOM    564  OD1 ASP    68     -32.015   8.221 -10.922  1.00 30.33           O
ATOM    565  OD2 ASP    68     -29.915   8.103 -10.278  1.00 28.49           O
ATOM    566  C   ASP    68     -33.707   7.551  -7.191  1.00 21.11           C
ATOM    567  O   ASP    68     -34.136   6.420  -7.409  1.00 20.72           O
ATOM    568  N   ASP    69     -33.790   8.106  -5.981  1.00 20.70           N
ATOM    569  CA  ASP    69     -34.499   7.393  -4.890  1.00 21.27           C
ATOM    570  CB  ASP    69     -34.371   8.149  -3.562  1.00 22.13           C
ATOM    571  CG  ASP    69     -32.986   8.014  -2.948  1.00 24.48           C
ATOM    572  OD1 ASP    69     -32.312   6.996  -3.200  1.00 27.84           O
ATOM    573  OD2 ASP    69     -32.581   8.940  -2.220  1.00 28.42           O
ATOM    574  C   ASP    69     -35.988   7.188  -5.201  1.00 20.42           C
ATOM    575  O   ASP    69     -36.621   6.239  -4.725  1.00 20.59           O
ATOM    576  N   ILE    70     -36.539   8.100  -5.989  1.00 19.38           N
ATOM    577  CA  ILE    70     -37.928   7.992  -6.429  1.00 18.85           C
ATOM    578  CB  ILE    70     -38.556   9.366  -6.619  1.00 18.52           C
ATOM    579  CG1 ILE    70     -38.411  10.193  -5.323  1.00 21.19           C
ATOM    580  CD1 ILE    70     -38.809  11.665  -5.486  1.00 21.34           C
ATOM    581  CG2 ILE    70     -40.039   9.235  -6.997  1.00 19.97           C
ATOM    582  C   ILE    70     -38.014   7.194  -7.726  1.00 17.62           C
ATOM    583  O   ILE    70     -38.761   6.225  -7.804  1.00 18.07           O
ATOM    584  N   ARG    71     -37.271   7.614  -8.747  1.00 16.37           N
ATOM    585  CA  ARG    71     -37.312   6.918 -10.054  1.00 16.19           C
ATOM    586  CB  ARG    71     -36.314   7.527 -11.036  1.00 16.11           C
ATOM    587  CG  ARG    71     -36.578   8.965 -11.418  1.00 19.99           C
ATOM    588  CD  ARG    71     -35.754   9.340 -12.654  1.00 23.24           C
ATOM    589  NE  ARG    71     -35.827  10.770 -12.961  1.00 25.78           N
ATOM    590  CZ  ARG    71     -36.850  11.371 -13.583  1.00 28.05           C
ATOM    591  NH1 ARG    71     -37.910  10.665 -13.975  1.00 28.38           N
ATOM    592  NH2 ARG    71     -36.818  12.683 -13.821  1.00 22.66           N
ATOM    593  C   ARG    71     -36.981   5.449  -9.914  1.00 14.93           C
ATOM    594  O   ARG    71     -37.529   4.587 -10.637  1.00 13.88           O
ATOM    595  N   GLY    72     -36.074   5.141  -8.978  1.00 14.49           N
ATOM    596  CA  GLY    72     -35.604   3.763  -8.809  1.00 13.79           C
ATOM    597  C   GLY    72     -36.685   2.791  -8.352  1.00 14.28           C
ATOM    598  O   GLY    72     -36.498   1.596  -8.465  1.00 15.03           O
ATOM    599  N   GLN    73     -37.809   3.316  -7.844  1.00 13.08           N
ATOM    600  CA  GLN    73     -38.965   2.522  -7.381  1.00 13.26           C
ATOM    601  CB  GLN    73     -39.651   3.251  -6.211  1.00 13.37           C
ATOM    602  CG  GLN    73     -38.783   3.419  -4.979  1.00 16.75           C
ATOM    603  CD  GLN    73     -38.147   2.137  -4.546  1.00 21.82           C
ATOM    604  OE1 GLN    73     -38.813   1.105  -4.424  1.00 22.36           O
ATOM    605  NE2 GLN    73     -36.834   2.173  -4.334  1.00 26.08           N
ATOM    606  C   GLN    73     -40.037   2.290  -8.454  1.00 12.89           C
ATOM    607  O   GLN    73     -41.041   1.624  -8.204  1.00 12.88           O
ATOM    608  N   ALA    74     -39.844   2.871  -9.636  1.00 12.26           N
ATOM    609  CA  ALA    74     -40.800   2.693 -10.736  1.00 12.16           C
ATOM    610  CB  ALA    74     -40.216   3.279 -12.015  1.00 12.22           C
ATOM    611  C   ALA    74     -41.152   1.219 -10.951  1.00 12.26           C
ATOM    612  O   ALA    74     -40.261   0.342 -10.903  1.00 11.19           O
ATOM    613  N   GLY    75     -42.429   0.939 -11.235  1.00 11.65           N
ATOM    614  CA  GLY    75     -42.868  -0.466 -11.342  1.00 10.70           C
ATOM    615  C   GLY    75     -43.731  -0.790 -10.118  1.00 11.25           C
ATOM    616  O   GLY    75     -44.484  -1.762 -10.116  1.00 11.59           O
ATOM    617  N   ASP    76     -43.570  -0.008  -9.043  1.00 12.06           N
ATOM    618  CA  ASP    76     -44.360  -0.166  -7.824  1.00 12.36           C
ATOM    619  CB  ASP    76     -43.487  -0.827  -6.733  1.00 12.42           C
ATOM    620  CG  ASP    76     -44.202  -1.022  -5.400  1.00 15.66           C
ATOM    621  OD1 ASP    76     -45.317  -0.484  -5.151  1.00 16.24           O
ATOM    622  OD2 ASP    76     -43.604  -1.751  -4.566  1.00 15.57           O
ATOM    623  C   ASP    76     -44.849   1.223  -7.391  1.00 12.68           C
ATOM    624  O   ASP    76     -44.129   1.931  -6.685  1.00 11.41           O
ATOM    625  N   PRO    77     -46.043   1.647  -7.879  1.00 13.71           N
ATOM    626  CA  PRO    77     -46.488   3.033  -7.645  1.00 13.93           C
ATOM    627  CB  PRO    77     -47.873   3.103  -8.333  1.00 13.23           C
ATOM    628  CG  PRO    77     -47.761   2.072  -9.458  1.00 15.27           C
ATOM    629  CD  PRO    77     -46.977   0.920  -8.766  1.00 14.18           C
ATOM    630  C   PRO    77     -46.533   3.405  -6.182  1.00 13.31           C
ATOM    631  O   PRO    77     -46.184   4.524  -5.838  1.00 13.85           O
ATOM    632  N   LEU    78     -46.946   2.477  -5.319  0.50 13.21           N
ATOM    634  CA  LEU    78     -46.992   2.787  -3.889  0.50 13.74           C
ATOM    636  CB  LEU    78     -47.582   1.617  -3.103  0.50 13.51           C
ATOM    638  CG  LEU    78     -48.457   1.997  -1.907  0.50 14.73           C
ATOM    640  CD1 LEU    78     -49.147   0.741  -1.413  0.50 17.25           C
ATOM    642  CD2 LEU    78     -47.650   2.638  -0.804  0.50 19.04           C
ATOM    644  C   LEU    78     -45.602   3.124  -3.366  0.50 13.01           C
ATOM    646  O   LEU    78     -45.444   4.072  -2.614  0.50 12.86           O
ATOM    648  N   ALA    79     -44.598   2.339  -3.761  1.00 13.15           N
ATOM    649  CA  ALA    79     -43.203   2.602  -3.355  1.00 13.03           C
ATOM    650  CB  ALA    79     -42.284   1.481  -3.789  1.00 13.22           C
ATOM    651  C   ALA    79     -42.705   3.953  -3.901  1.00 12.54           C
ATOM    652  O   ALA    79     -41.949   4.654  -3.228  1.00 12.09           O
ATOM    653  N   VAL    80     -43.099   4.301  -5.131  1.00 11.58           N
ATOM    654  CA  VAL    80     -42.787   5.630  -5.672  1.00 12.21           C
ATOM    655  CB  VAL    80     -43.296   5.773  -7.101  1.00 11.22           C
ATOM    656  CG1 VAL    80     -43.163   7.227  -7.624  1.00 12.32           C
ATOM    657  CG2 VAL    80     -42.538   4.787  -8.035  1.00 10.84           C
ATOM    658  C   VAL    80     -43.376   6.760  -4.777  1.00 13.05           C
ATOM    659  O   VAL    80     -42.668   7.710  -4.420  1.00 13.23           O
ATOM    660  N   MET    81     -44.661   6.646  -4.436  0.70 12.38           N
ATOM    662  CA  MET    81     -45.330   7.668  -3.603  0.70 12.69           C
ATOM    664  CB  MET    81     -46.833   7.394  -3.427  0.70 13.82           C
ATOM    666  CG  MET    81     -47.597   7.155  -4.747  0.70 14.01           C
ATOM    668  SD  MET    81     -47.622   8.670  -5.960  0.70 21.09          SE
ATOM    670  CE  MET    81     -47.084   7.612  -7.496  0.70 15.28           C
ATOM    672  C   MET    81     -44.684   7.771  -2.235  0.70 13.11           C
ATOM    674  O   MET    81     -44.538   8.886  -1.698  0.70 12.95           O
ATOM    676  N   THR    82     -44.336   6.621  -1.655  1.00 11.97           N
ATOM    677  CA  THR    82     -43.690   6.575  -0.342  1.00 13.13           C
ATOM    678  CB  THR    82     -43.605   5.113   0.176  1.00 12.76           C
ATOM    679  OG1 THR    82     -44.931   4.563   0.297  1.00 13.08           O
ATOM    680  CG2 THR    82     -42.926   5.051   1.546  1.00 12.65           C
ATOM    681  C   THR    82     -42.311   7.220  -0.401  1.00 12.27           C
ATOM    682  O   THR    82     -41.988   8.047   0.443  1.00 12.09           O
ATOM    683  N   ALA    83     -41.522   6.874  -1.419  1.00 12.10           N
ATOM    684  CA  ALA    83     -40.189   7.455  -1.613  1.00 12.71           C
ATOM    685  CB  ALA    83     -39.469   6.804  -2.772  1.00 13.64           C
ATOM    686  C   ALA    83     -40.256   8.962  -1.829  1.00 13.31           C
ATOM    687  O   ALA    83     -39.424   9.717  -1.293  1.00 13.65           O
ATOM    688  N   TYR    84     -41.234   9.393  -2.621  1.00 12.01           N
ATOM    689  CA  TYR    84     -41.450  10.829  -2.827  1.00 11.80           C
ATOM    690  CB  TYR    84     -42.626  11.070  -3.785  1.00 11.47           C
ATOM    691  CG  TYR    84     -43.055  12.503  -3.698  1.00 11.01           C
ATOM    692  CD1 TYR    84     -42.230  13.514  -4.207  1.00  9.70           C
ATOM    693  CE1 TYR    84     -42.562  14.853  -4.058  1.00  7.72           C
ATOM    694  CZ  TYR    84     -43.777  15.207  -3.416  1.00  9.90           C
ATOM    695  OH  TYR    84     -44.090  16.520  -3.245  1.00  9.60           O
ATOM    696  CE2 TYR    84     -44.606  14.228  -2.886  1.00 10.03           C
ATOM    697  CD2 TYR    84     -44.241  12.867  -3.033  1.00  8.93           C
ATOM    698  C   TYR    84     -41.702  11.542  -1.464  1.00 11.96           C
ATOM    699  O   TYR    84     -41.113  12.588  -1.195  1.00 11.13           O
ATOM    700  N   LEU    85     -42.594  11.008  -0.646  1.00 10.86           N
ATOM    701  CA  LEU    85     -42.868  11.627   0.683  1.00 10.85           C
ATOM    702  CB  LEU    85     -44.003  10.908   1.396  1.00 10.34           C
ATOM    703  CG  LEU    85     -45.392  11.039   0.735  1.00 11.08           C
ATOM    704  CD1 LEU    85     -46.412  10.164   1.470  1.00 14.10           C
ATOM    705  CD2 LEU    85     -45.840  12.513   0.824  1.00 11.81           C
ATOM    706  C   LEU    85     -41.608  11.688   1.547  1.00 10.59           C
ATOM    707  O   LEU    85     -41.299  12.737   2.160  1.00  9.89           O
ATOM    708  N   ARG    86     -40.890  10.577   1.613  1.00 11.70           N
ATOM    709  CA  ARG    86     -39.686  10.504   2.430  1.00 12.21           C
ATOM    710  CB  ARG    86     -39.118   9.092   2.407  1.00 13.48           C
ATOM    711  CG  ARG    86     -38.070   8.880   3.462  1.00 16.80           C
ATOM    712  CD  ARG    86     -37.752   7.377   3.627  1.00 18.02           C
ATOM    713  NE  ARG    86     -38.810   6.676   4.350  1.00 20.50           N
ATOM    714  CZ  ARG    86     -39.556   5.706   3.833  1.00 23.33           C
ATOM    715  NH1 ARG    86     -39.354   5.300   2.584  1.00 26.93           N
ATOM    716  NH2 ARG    86     -40.472   5.111   4.589  1.00 24.38           N
ATOM    717  C   ARG    86     -38.635  11.526   1.947  1.00 11.94           C
ATOM    718  O   ARG    86     -37.985  12.202   2.764  1.00 11.86           O
ATOM    719  N   TRP    87     -38.462  11.595   0.637  1.00 11.06           N
ATOM    720  CA  TRP    87     -37.511  12.517   0.011  1.00 11.54           C
ATOM    721  CB  TRP    87     -37.513  12.276  -1.518  1.00 11.78           C
ATOM    722  CG  TRP    87     -36.670  13.219  -2.336  1.00 11.45           C
ATOM    723  CD1 TRP    87     -35.298  13.232  -2.473  1.00 12.95           C
ATOM    724  NE1 TRP    87     -34.914  14.228  -3.355  1.00 11.75           N
ATOM    725  CE2 TRP    87     -36.041  14.867  -3.805  1.00 12.69           C
ATOM    726  CD2 TRP    87     -37.162  14.253  -3.195  1.00 12.32           C
ATOM    727  CE3 TRP    87     -38.448  14.715  -3.505  1.00 13.71           C
ATOM    728  CZ3 TRP    87     -38.582  15.767  -4.386  1.00 13.30           C
ATOM    729  CH2 TRP    87     -37.436  16.377  -4.989  1.00 14.32           C
ATOM    730  CZ2 TRP    87     -36.166  15.944  -4.703  1.00 14.12           C
ATOM    731  C   TRP    87     -37.904  13.972   0.307  1.00 11.68           C
ATOM    732  O   TRP    87     -37.046  14.801   0.617  1.00 11.77           O
ATOM    733  N   THR    88     -39.191  14.280   0.183  1.00 11.01           N
ATOM    734  CA  THR    88     -39.685  15.654   0.390  1.00 11.22           C
ATOM    735  CB  THR    88     -41.147  15.790  -0.053  1.00 12.10           C
ATOM    736  OG1 THR    88     -41.220  15.503  -1.460  1.00 12.19           O
ATOM    737  CG2 THR    88     -41.678  17.220   0.199  1.00 12.36           C
ATOM    738  C   THR    88     -39.498  16.086   1.853  1.00 10.14           C
ATOM    739  O   THR    88     -39.045  17.207   2.119  1.00  9.63           O
ATOM    740  N   ILE    89     -39.826  15.192   2.778  1.00 10.71           N
ATOM    741  CA  ILE    89     -39.609  15.477   4.191  1.00 11.44           C
ATOM    742  CB  ILE    89     -40.178  14.352   5.067  1.00 11.62           C
ATOM    743  CG1 ILE    89     -41.718  14.377   4.949  1.00 10.67           C
ATOM    744  CD1 ILE    89     -42.368  13.154   5.612  1.00 14.32           C
ATOM    745  CG2 ILE    89     -39.752  14.574   6.521  1.00  9.76           C
ATOM    746  C   ILE    89     -38.108  15.719   4.470  1.00 11.65           C
ATOM    747  O   ILE    89     -37.748  16.702   5.123  1.00 10.49           O
ATOM    748  N   GLN    90     -37.253  14.832   3.946  0.60 11.78           N
ATOM    750  CA  GLN    90     -35.805  15.009   4.058  0.60 12.90           C
ATOM    752  CB  GLN    90     -35.059  13.906   3.294  0.60 13.23           C
ATOM    754  CG  GLN    90     -33.581  13.882   3.617  0.60 18.71           C
ATOM    756  CD  GLN    90     -33.320  13.696   5.114  0.60 24.36           C
ATOM    758  OE1 GLN    90     -32.857  14.615   5.797  0.60 28.60           O
ATOM    760  NE2 GLN    90     -33.626  12.502   5.631  0.60 27.22           N
ATOM    762  C   GLN    90     -35.349  16.402   3.563  0.60 12.09           C
ATOM    764  O   GLN    90     -34.599  17.104   4.235  0.60 11.76           O
ATOM    766  N   ARG    91     -35.849  16.798   2.401  1.00 12.06           N
ATOM    767  CA  ARG    91     -35.481  18.070   1.792  1.00 11.96           C
ATOM    768  CB  ARG    91     -36.237  18.253   0.485  1.00 13.06           C
ATOM    769  CG  ARG    91     -35.579  17.519  -0.624  1.00 17.79           C
ATOM    770  CD  ARG    91     -36.116  18.032  -1.972  1.00 20.49           C
ATOM    771  NE  ARG    91     -37.524  17.695  -2.235  1.00 21.73           N
ATOM    772  CZ  ARG    91     -38.542  18.563  -2.176  1.00 22.41           C
ATOM    773  NH1 ARG    91     -39.778  18.166  -2.519  1.00 18.87           N
ATOM    774  NH2 ARG    91     -38.328  19.821  -1.792  1.00 17.44           N
ATOM    775  C   ARG    91     -35.787  19.210   2.737  1.00 11.92           C
ATOM    776  O   ARG    91     -34.954  20.120   2.929  1.00 11.63           O
ATOM    777  N   HIS    92     -36.985  19.171   3.324  1.00 11.45           N
ATOM    778  CA  HIS    92     -37.369  20.231   4.257  1.00 12.36           C
ATOM    779  CB  HIS    92     -38.873  20.203   4.534  1.00 13.78           C
ATOM    780  CG  HIS    92     -39.696  20.557   3.336  1.00 14.40           C
ATOM    781  ND1 HIS    92     -39.591  21.777   2.684  1.00 19.47           N
ATOM    782  CE1 HIS    92     -40.452  21.801   1.674  1.00 21.35           C
ATOM    783  NE2 HIS    92     -41.103  20.649   1.649  1.00 16.69           N
ATOM    784  CD2 HIS    92     -40.635  19.846   2.660  1.00 16.03           C
ATOM    785  C   HIS    92     -36.565  20.215   5.544  1.00 12.15           C
ATOM    786  O   HIS    92     -36.192  21.268   6.056  1.00 11.95           O
ATOM    787  N   ARG    93     -36.254  19.030   6.054  1.00 11.79           N
ATOM    788  CA  ARG    93     -35.455  18.958   7.286  1.00 12.70           C
ATOM    789  CB  ARG    93     -35.461  17.537   7.853  1.00 12.66           C
ATOM    790  CG  ARG    93     -36.858  17.020   8.266  1.00 13.84           C
ATOM    791  CD  ARG    93     -37.401  17.762   9.453  1.00 18.09           C
ATOM    792  NE  ARG    93     -38.685  17.215   9.878  1.00 17.47           N
ATOM    793  CZ  ARG    93     -39.526  17.858  10.676  1.00 16.59           C
ATOM    794  NH1 ARG    93     -39.223  19.072  11.110  1.00 17.37           N
ATOM    795  NH2 ARG    93     -40.666  17.281  11.023  1.00 15.53           N
ATOM    796  C   ARG    93     -34.025  19.435   7.057  1.00 13.20           C
ATOM    797  O   ARG    93     -33.450  20.125   7.905  1.00 15.46           O
ATOM    798  N   ASN    94     -33.459  19.087   5.914  1.00 12.51           N
ATOM    799  CA  ASN    94     -32.101  19.512   5.580  1.00 14.01           C
ATOM    800  CB  ASN    94     -31.566  18.704   4.408  1.00 15.34           C
ATOM    801  CG  ASN    94     -31.380  17.226   4.724  1.00 18.74           C
ATOM    802  OD1 ASN    94     -31.130  16.441   3.813  1.00 27.63           O
ATOM    803  ND2 ASN    94     -31.508  16.841   5.986  1.00 22.90           N
ATOM    804  C   ASN    94     -32.010  20.978   5.199  1.00 13.91           C
ATOM    805  O   ASN    94     -30.942  21.582   5.307  1.00 12.63           O
ATOM    806  N   ASN    95     -33.118  21.549   4.732  1.00 13.29           N
ATOM    807  CA  ASN    95     -33.111  22.936   4.270  1.00 15.16           C
ATOM    808  CB  ASN    95     -32.967  23.054   2.763  1.00 16.24           C
ATOM    809  CG  ASN    95     -32.773  24.515   2.339  1.00 19.00           C
ATOM    810  OD1 ASN    95     -32.538  25.397   3.185  1.00 16.84           O
ATOM    811  ND2 ASN    95     -32.897  24.782   1.041  1.00 21.24           N
ATOM    812  C   ASN    95     -34.330  23.717   4.692  1.00 15.67           C
ATOM    813  O   ASN    95     -35.314  23.831   3.936  1.00 15.80           O
ATOM    814  N   PRO    96     -34.271  24.260   5.900  1.00 16.89           N
ATOM    815  CA  PRO    96     -35.322  25.100   6.460  1.00 18.18           C
ATOM    816  CB  PRO    96     -34.732  25.555   7.802  1.00 18.94           C
ATOM    817  CG  PRO    96     -33.729  24.472   8.148  1.00 19.40           C
ATOM    818  CD  PRO    96     -33.147  24.066   6.837  1.00 17.29           C
ATOM    819  C   PRO    96     -35.602  26.309   5.578  1.00 17.64           C
ATOM    820  O   PRO    96     -36.688  26.843   5.668  1.00 20.08           O
ATOM    821  N   GLN    97     -34.664  26.718   4.721  1.00 17.55           N
ATOM    822  CA  GLN    97     -34.882  27.924   3.884  1.00 16.15           C
ATOM    823  CB  GLN    97     -33.556  28.526   3.375  1.00 18.11           C
ATOM    824  CG  GLN    97     -32.586  28.997   4.445  1.00 21.27           C
ATOM    825  CD  GLN    97     -32.986  30.332   5.097  1.00 25.68           C
ATOM    826  OE1 GLN    97     -34.153  30.593   5.335  1.00 27.40           O
ATOM    827  NE2 GLN    97     -32.009  31.165   5.381  1.00 27.04           N
ATOM    828  C   GLN    97     -35.744  27.610   2.655  1.00 14.78           C
ATOM    829  O   GLN    97     -36.230  28.506   1.960  1.00 11.98           O
ATOM    830  N   LEU    98     -35.901  26.333   2.335  1.00 12.64           N
ATOM    831  CA  LEU    98     -36.399  26.054   0.980  1.00 12.07           C
ATOM    832  CB  LEU    98     -36.223  24.576   0.576  1.00 12.25           C
ATOM    833  CG  LEU    98     -36.864  24.142  -0.779  1.00 13.48           C
ATOM    834  CD1 LEU    98     -36.177  24.694  -2.050  1.00 15.69           C
ATOM    835  CD2 LEU    98     -36.865  22.621  -0.848  1.00 15.12           C
ATOM    836  C   LEU    98     -37.808  26.609   0.762  1.00  9.66           C
ATOM    837  O   LEU    98     -38.058  27.231  -0.286  1.00  9.22           O
ATOM    838  N   LEU    99     -38.723  26.475   1.724  1.00  9.90           N
ATOM    839  CA  LEU    99     -40.096  26.921   1.392  1.00 10.68           C
ATOM    840  CB  LEU    99     -41.134  26.482   2.475  1.00 11.84           C
ATOM    841  CG  LEU    99     -41.720  25.109   2.218  1.00 12.27           C
ATOM    842  CD1 LEU    99     -42.546  24.691   3.463  1.00 16.86           C
ATOM    843  CD2 LEU    99     -42.530  24.990   0.943  1.00 14.59           C
ATOM    844  C   LEU    99     -40.166  28.414   1.244  1.00 10.51           C
ATOM    845  O   LEU    99     -41.036  28.919   0.576  1.00 11.22           O
ATOM    846  N   ARG   100     -39.232  29.138   1.869  1.00  8.91           N
ATOM    847  CA  ARG   100     -39.171  30.614   1.637  1.00 10.19           C
ATOM    848  CB  ARG   100     -38.051  31.233   2.443  1.00  9.36           C
ATOM    849  CG  ARG   100     -38.293  31.279   3.923  1.00 12.57           C
ATOM    850  CD  ARG   100     -37.117  31.919   4.691  1.00 14.26           C
ATOM    851  NE  ARG   100     -37.502  32.131   6.084  1.00 21.03           N
ATOM    852  CZ  ARG   100     -36.662  32.254   7.102  1.00 26.22           C
ATOM    853  NH1 ARG   100     -35.340  32.191   6.906  1.00 25.30           N
ATOM    854  NH2 ARG   100     -37.156  32.455   8.326  1.00 30.04           N
ATOM    855  C   ARG   100     -38.944  30.908   0.135  1.00  9.56           C
ATOM    856  O   ARG   100     -39.737  31.609  -0.479  1.00  9.17           O
ATOM    857  N   PHE   101     -37.894  30.333  -0.451  1.00  8.88           N
ATOM    858  CA  PHE   101     -37.584  30.586  -1.861  1.00  7.74           C
ATOM    859  CB  PHE   101     -36.227  29.979  -2.191  1.00  9.07           C
ATOM    860  CG  PHE   101     -35.072  30.718  -1.553  1.00  8.31           C
ATOM    861  CD1 PHE   101     -34.572  31.865  -2.155  1.00  9.65           C
ATOM    862  CE1 PHE   101     -33.460  32.577  -1.586  1.00 12.39           C
ATOM    863  CZ  PHE   101     -32.856  32.079  -0.434  1.00 11.45           C
ATOM    864  CE2 PHE   101     -33.351  30.895   0.160  1.00 13.90           C
ATOM    865  CD2 PHE   101     -34.452  30.220  -0.416  1.00 11.33           C
ATOM    866  C   PHE   101     -38.651  29.978  -2.784  1.00  8.41           C
ATOM    867  O   PHE   101     -39.040  30.587  -3.776  1.00  8.06           O
ATOM    868  N   TYR   102     -39.122  28.777  -2.420  1.00  7.06           N
ATOM    869  CA  TYR   102     -40.068  28.027  -3.247  1.00  7.90           C
ATOM    870  CB  TYR   102     -40.262  26.695  -2.548  1.00  7.79           C
ATOM    871  CG  TYR   102     -41.077  25.629  -3.236  1.00  8.54           C
ATOM    872  CD1 TYR   102     -42.489  25.656  -3.181  1.00 10.03           C
ATOM    873  CE1 TYR   102     -43.257  24.599  -3.766  1.00 11.63           C
ATOM    874  CZ  TYR   102     -42.610  23.511  -4.376  1.00 11.76           C
ATOM    875  OH  TYR   102     -43.341  22.459  -4.924  1.00 11.14           O
ATOM    876  CE2 TYR   102     -41.192  23.459  -4.417  1.00  9.45           C
ATOM    877  CD2 TYR   102     -40.447  24.510  -3.827  1.00 10.19           C
ATOM    878  C   TYR   102     -41.394  28.796  -3.351  1.00  8.00           C
ATOM    879  O   TYR   102     -41.879  29.032  -4.458  1.00  9.22           O
ATOM    880  N   THR   103     -41.935  29.239  -2.212  1.00  8.23           N
ATOM    881  CA  THR   103     -43.186  30.012  -2.256  1.00  8.10           C
ATOM    882  CB  THR   103     -43.885  30.125  -0.875  1.00  7.33           C
ATOM    883  OG1 THR   103     -43.012  30.781   0.056  1.00  8.06           O
ATOM    884  CG2 THR   103     -44.249  28.714  -0.376  1.00  8.46           C
ATOM    885  C   THR   103     -43.009  31.397  -2.842  1.00  8.57           C
ATOM    886  O   THR   103     -43.909  31.869  -3.557  1.00  9.60           O
ATOM    887  N   SER   104     -41.877  32.052  -2.541  1.00  9.12           N
ATOM    888  CA  SER   104     -41.655  33.400  -3.043  1.00  9.88           C
ATOM    889  CB  SER   104     -40.363  34.009  -2.477  1.00  9.85           C
ATOM    890  OG  SER   104     -40.234  35.352  -2.971  1.00 12.21           O
ATOM    891  C   SER   104     -41.601  33.357  -4.584  1.00 10.66           C
ATOM    892  O   SER   104     -42.219  34.183  -5.265  1.00 10.59           O
ATOM    893  N   GLU   105     -40.865  32.392  -5.125  1.00  8.72           N
ATOM    894  CA  GLU   105     -40.817  32.289  -6.613  1.00  9.18           C
ATOM    895  CB  GLU   105     -39.731  31.293  -7.041  1.00  7.45           C
ATOM    896  CG  GLU   105     -38.332  31.924  -6.972  1.00  8.14           C
ATOM    897  CD  GLU   105     -38.036  32.910  -8.131  1.00 10.19           C
ATOM    898  OE1 GLU   105     -38.853  33.093  -9.071  1.00  9.04           O
ATOM    899  OE2 GLU   105     -36.931  33.505  -8.111  1.00 13.04           O
ATOM    900  C   GLU   105     -42.165  31.935  -7.261  1.00  9.12           C
ATOM    901  O   GLU   105     -42.538  32.491  -8.300  1.00  9.81           O
ATOM    902  N   LEU   106     -42.941  31.042  -6.632  1.00  8.79           N
ATOM    903  CA  LEU   106     -44.237  30.680  -7.191  1.00  9.03           C
ATOM    904  CB  LEU   106     -44.849  29.471  -6.457  1.00  8.32           C
ATOM    905  CG  LEU   106     -44.211  28.130  -6.911  1.00  9.60           C
ATOM    906  CD1 LEU   106     -44.576  27.033  -5.828  1.00  9.04           C
ATOM    907  CD2 LEU   106     -44.754  27.786  -8.296  1.00  9.22           C
ATOM    908  C   LEU   106     -45.238  31.834  -7.135  1.00  9.88           C
ATOM    909  O   LEU   106     -46.147  31.887  -7.972  1.00 10.21           O
ATOM    910  N   THR   107     -45.102  32.717  -6.136  1.00  9.52           N
ATOM    911  CA  THR   107     -46.030  33.832  -5.986  1.00  9.75           C
ATOM    912  CB  THR   107     -46.510  33.990  -4.516  1.00  9.09           C
ATOM    913  OG1 THR   107     -45.388  34.319  -3.693  1.00 10.50           O
ATOM    914  CG2 THR   107     -47.185  32.718  -4.076  1.00 10.05           C
ATOM    915  C   THR   107     -45.544  35.182  -6.484  1.00  9.81           C
ATOM    916  O   THR   107     -46.371  36.081  -6.704  1.00 12.25           O
ATOM    917  N   ASN   108     -44.232  35.363  -6.633  0.50  9.70           N
ATOM    919  CA  ASN   108     -43.617  36.625  -7.105  0.50  9.59           C
ATOM    921  CB  ASN   108     -43.154  37.511  -5.932  0.50  9.99           C
ATOM    923  CG  ASN   108     -44.278  38.322  -5.314  0.50  8.07           C
ATOM    925  OD1 ASN   108     -44.577  38.166  -4.138  0.50 11.45           O
ATOM    927  ND2 ASN   108     -44.931  39.160  -6.116  0.50  6.17           N
ATOM    929  C   ASN   108     -42.392  36.215  -7.909  0.50  9.86           C
ATOM    931  O   ASN   108     -41.262  36.429  -7.469  0.50  9.46           O
ATOM    933  N   PRO   109     -42.611  35.593  -9.087  1.00  9.87           N
ATOM    934  CA  PRO   109     -41.482  34.997  -9.847  1.00  9.20           C
ATOM    935  CB  PRO   109     -42.170  34.338 -11.060  1.00  9.29           C
ATOM    936  CG  PRO   109     -43.456  35.217 -11.249  1.00 11.47           C
ATOM    937  CD  PRO   109     -43.900  35.416  -9.770  1.00 10.72           C
ATOM    938  C   PRO   109     -40.455  36.039 -10.322  1.00  9.60           C
ATOM    939  O   PRO   109     -40.811  37.205 -10.612  1.00 11.09           O
ATOM    940  N   THR   110     -39.210  35.615 -10.382  1.00  9.05           N
ATOM    941  CA  THR   110     -38.133  36.378 -11.039  1.00  9.32           C
ATOM    942  CB  THR   110     -36.862  36.356 -10.160  1.00 10.57           C
ATOM    943  OG1 THR   110     -36.330  35.035 -10.130  1.00  9.30           O
ATOM    944  CG2 THR   110     -37.147  36.832  -8.744  1.00 13.98           C
ATOM    945  C   THR   110     -37.799  35.644 -12.327  1.00  8.94           C
ATOM    946  O   THR   110     -38.429  34.643 -12.626  1.00  8.35           O
ATOM    947  N   PRO   111     -36.818  36.119 -13.123  1.00  9.83           N
ATOM    948  CA  PRO   111     -36.366  35.317 -14.286  1.00 11.52           C
ATOM    949  CB  PRO   111     -35.231  36.183 -14.892  1.00 11.75           C
ATOM    950  CG  PRO   111     -35.579  37.539 -14.489  1.00 11.98           C
ATOM    951  CD  PRO   111     -36.150  37.430 -13.076  1.00 10.83           C
ATOM    952  C   PRO   111     -35.863  33.915 -13.908  1.00 12.86           C
ATOM    953  O   PRO   111     -35.889  32.963 -14.744  1.00 13.75           O
ATOM    954  N   CYS   112     -35.461  33.730 -12.660  1.00 11.46           N
ATOM    955  CA  CYS   112     -35.067  32.401 -12.254  1.00 13.19           C
ATOM    956  CB  CYS   112     -34.230  32.442 -10.978  1.00 14.56           C
ATOM    957  SG  CYS   112     -32.686  33.333 -11.290  1.00 18.40           S
ATOM    958  C   CYS   112     -36.251  31.432 -12.108  1.00 12.18           C
ATOM    959  O   CYS   112     -36.048  30.232 -11.974  1.00 13.79           O
ATOM    960  N   PHE   113     -37.501  31.926 -12.121  1.00 11.58           N
ATOM    961  CA  PHE   113     -38.605  30.987 -11.961  1.00 10.29           C
ATOM    962  CB  PHE   113     -39.921  31.711 -11.869  1.00 10.73           C
ATOM    963  CG  PHE   113     -41.068  30.776 -11.807  1.00 10.75           C
ATOM    964  CD1 PHE   113     -41.318  30.025 -10.649  1.00 13.13           C
ATOM    965  CE1 PHE   113     -42.390  29.092 -10.649  1.00 14.20           C
ATOM    966  CZ  PHE   113     -43.135  28.878 -11.780  1.00 12.39           C
ATOM    967  CE2 PHE   113     -42.909  29.606 -12.931  1.00 14.70           C
ATOM    968  CD2 PHE   113     -41.824  30.539 -12.957  1.00 11.87           C
ATOM    969  C   PHE   113     -38.634  30.035 -13.180  1.00  9.81           C
ATOM    970  O   PHE   113     -38.642  28.807 -13.017  1.00  9.92           O
ATOM    971  N   ALA   114     -38.644  30.592 -14.383  1.00  9.60           N
ATOM    972  CA  ALA   114     -38.711  29.716 -15.565  1.00  9.88           C
ATOM    973  CB  ALA   114     -38.980  30.528 -16.837  1.00  9.97           C
ATOM    974  C   ALA   114     -37.461  28.865 -15.730  1.00 10.92           C
ATOM    975  O   ALA   114     -37.548  27.764 -16.247  1.00 11.21           O
ATOM    976  N   ALA   115     -36.301  29.407 -15.342  1.00 10.45           N
ATOM    977  CA  ALA   115     -35.020  28.733 -15.554  1.00 11.81           C
ATOM    978  CB  ALA   115     -33.882  29.767 -15.520  1.00 12.14           C
ATOM    979  C   ALA   115     -34.750  27.588 -14.574  1.00 11.95           C
ATOM    980  O   ALA   115     -34.178  26.555 -14.951  1.00 12.70           O
ATOM    981  N   ILE   116     -35.186  27.750 -13.331  1.00 11.04           N
ATOM    982  CA  ILE   116     -34.783  26.848 -12.255  1.00 11.69           C
ATOM    983  CB  ILE   116     -33.872  27.616 -11.214  1.00 10.98           C
ATOM    984  CG1 ILE   116     -32.584  28.106 -11.900  1.00 13.37           C
ATOM    985  CD1 ILE   116     -31.751  29.071 -11.039  1.00 12.57           C
ATOM    986  CG2 ILE   116     -33.568  26.724  -9.962  1.00 12.49           C
ATOM    987  C   ILE   116     -35.998  26.242 -11.560  1.00 11.29           C
ATOM    988  O   ILE   116     -36.092  25.007 -11.384  1.00 10.24           O
ATOM    989  N   VAL   117     -36.919  27.089 -11.131  1.00 10.95           N
ATOM    990  CA  VAL   117     -37.977  26.588 -10.206  1.00 10.57           C
ATOM    991  CB  VAL   117     -38.617  27.751  -9.409  1.00 11.02           C
ATOM    992  CG1 VAL   117     -39.795  27.207  -8.454  1.00 10.64           C
ATOM    993  CG2 VAL   117     -37.512  28.443  -8.627  1.00 10.50           C
ATOM    994  C   VAL   117     -39.038  25.771 -10.946  1.00 11.77           C
ATOM    995  O   VAL   117     -39.425  24.648 -10.524  1.00 11.14           O
ATOM    996  N   SER   118     -39.530  26.315 -12.046  1.00 10.59           N
ATOM    997  CA  SER   118     -40.620  25.684 -12.764  1.00 12.47           C
ATOM    998  CB  SER   118     -41.105  26.636 -13.868  1.00 13.39           C
ATOM    999  OG  SER   118     -42.255  26.127 -14.471  1.00 14.41           O
ATOM   1000  C   SER   118     -40.234  24.283 -13.285  1.00 11.92           C
ATOM   1001  O   SER   118     -40.958  23.318 -13.010  1.00 12.39           O
ATOM   1002  N   PRO   119     -39.094  24.138 -13.988  1.00 12.64           N
ATOM   1003  CA  PRO   119     -38.727  22.800 -14.461  1.00 11.77           C
ATOM   1004  CB  PRO   119     -37.448  23.016 -15.304  1.00 12.21           C
ATOM   1005  CG  PRO   119     -36.981  24.375 -14.981  1.00 12.76           C
ATOM   1006  CD  PRO   119     -38.161  25.180 -14.467  1.00 11.90           C
ATOM   1007  C   PRO   119     -38.487  21.799 -13.296  1.00 11.38           C
ATOM   1008  O   PRO   119     -38.822  20.622 -13.450  1.00 11.44           O
ATOM   1009  N   ALA   120     -37.965  22.276 -12.162  1.00 10.79           N
ATOM   1010  CA  ALA   120     -37.680  21.404 -10.992  1.00  9.96           C
ATOM   1011  CB  ALA   120     -36.955  22.202  -9.916  1.00 10.33           C
ATOM   1012  C   ALA   120     -38.996  20.843 -10.478  1.00 11.25           C
ATOM   1013  O   ALA   120     -39.179  19.606 -10.381  1.00 11.32           O
ATOM   1014  N   ILE   121     -39.972  21.731 -10.240  1.00  9.92           N
ATOM   1015  CA  ILE   121     -41.278  21.275  -9.739  1.00 10.42           C
ATOM   1016  CB  ILE   121     -42.191  22.482  -9.354  1.00  9.91           C
ATOM   1017  CG1 ILE   121     -41.576  23.223  -8.147  1.00 11.53           C
ATOM   1018  CD1 ILE   121     -42.273  24.600  -7.882  1.00 11.61           C
ATOM   1019  CG2 ILE   121     -43.657  22.039  -9.082  1.00 11.13           C
ATOM   1020  C   ILE   121     -41.980  20.382 -10.790  1.00 10.00           C
ATOM   1021  O   ILE   121     -42.496  19.302 -10.444  1.00 10.24           O
ATOM   1022  N   ALA   122     -41.999  20.822 -12.047  1.00 10.30           N
ATOM   1023  CA  ALA   122     -42.680  20.050 -13.108  1.00 11.54           C
ATOM   1024  CB  ALA   122     -42.598  20.755 -14.509  1.00 12.24           C
ATOM   1025  C   ALA   122     -42.094  18.638 -13.234  1.00 11.86           C
ATOM   1026  O   ALA   122     -42.845  17.702 -13.488  1.00 12.38           O
ATOM   1027  N   SER   123     -40.780  18.499 -13.132  1.00 11.72           N
ATOM   1028  CA  SER   123     -40.140  17.174 -13.297  1.00 11.69           C
ATOM   1029  CB  SER   123     -38.597  17.220 -13.248  1.00 13.37           C
ATOM   1030  OG  SER   123     -38.136  17.620 -11.957  1.00 18.01           O
ATOM   1031  C   SER   123     -40.678  16.217 -12.222  1.00 11.56           C
ATOM   1032  O   SER   123     -40.889  15.041 -12.504  1.00 11.30           O
ATOM   1033  N   VAL   124     -40.862  16.719 -10.996  1.00 10.19           N
ATOM   1034  CA  VAL   124     -41.338  15.876  -9.883  1.00  9.66           C
ATOM   1035  CB  VAL   124     -41.121  16.603  -8.497  1.00 10.39           C
ATOM   1036  CG1 VAL   124     -41.817  15.860  -7.384  1.00 13.37           C
ATOM   1037  CG2 VAL   124     -39.640  16.694  -8.191  1.00 12.44           C
ATOM   1038  C   VAL   124     -42.808  15.523 -10.075  1.00 10.08           C
ATOM   1039  O   VAL   124     -43.218  14.350  -9.905  1.00  9.51           O
ATOM   1040  N   ILE   125     -43.617  16.526 -10.409  1.00  9.88           N
ATOM   1041  CA  ILE   125     -45.046  16.301 -10.630  1.00 10.74           C
ATOM   1042  CB  ILE   125     -45.803  17.624 -10.870  1.00 11.75           C
ATOM   1043  CG1 ILE   125     -45.744  18.498  -9.590  1.00  9.55           C
ATOM   1044  CD1 ILE   125     -46.274  17.830  -8.232  1.00 11.11           C
ATOM   1045  CG2 ILE   125     -47.298  17.363 -11.280  1.00 10.72           C
ATOM   1046  C   ILE   125     -45.254  15.309 -11.757  1.00 10.24           C
ATOM   1047  O   ILE   125     -46.088  14.386 -11.644  1.00 10.73           O
ATOM   1048  N   ARG   126     -44.483  15.459 -12.837  0.50 10.47           N
ATOM   1050  CA  ARG   126     -44.567  14.514 -13.947  0.50  9.91           C
ATOM   1052  CB  ARG   126     -43.607  14.907 -15.078  0.50  9.78           C
ATOM   1054  CG  ARG   126     -44.070  16.073 -15.874  0.50  8.97           C
ATOM   1056  CD  ARG   126     -43.145  16.305 -17.083  0.50 11.78           C
ATOM   1058  NE  ARG   126     -43.524  17.541 -17.757  0.50 13.41           N
ATOM   1060  CZ  ARG   126     -42.784  18.643 -17.773  0.50 18.19           C
ATOM   1062  NH1 ARG   126     -41.594  18.649 -17.187  0.50 18.32           N
ATOM   1064  NH2 ARG   126     -43.223  19.729 -18.401  0.50 20.28           N
ATOM   1066  C   ARG   126     -44.269  13.104 -13.483  0.50 10.39           C
ATOM   1068  O   ARG   126     -45.010  12.161 -13.806  0.50 11.26           O
ATOM   1070  N   LEU   127     -43.191  12.959 -12.717  1.00 10.18           N
ATOM   1071  CA  LEU   127     -42.747  11.653 -12.281  1.00 11.49           C
ATOM   1072  CB  LEU   127     -41.457  11.792 -11.470  1.00 12.45           C
ATOM   1073  CG  LEU   127     -40.836  10.551 -10.872  1.00 15.70           C
ATOM   1074  CD1 LEU   127     -40.489   9.503 -11.921  1.00 20.81           C
ATOM   1075  CD2 LEU   127     -39.573  10.988 -10.121  1.00 18.67           C
ATOM   1076  C   LEU   127     -43.864  10.955 -11.482  1.00  9.91           C
ATOM   1077  O   LEU   127     -44.173   9.757 -11.684  1.00 10.50           O
ATOM   1078  N   LEU   128     -44.458  11.703 -10.559  1.00  8.79           N
ATOM   1079  CA  LEU   128     -45.555  11.167  -9.751  1.00  9.28           C
ATOM   1080  CB  LEU   128     -45.959  12.213  -8.701  1.00  9.38           C
ATOM   1081  CG  LEU   128     -44.895  12.460  -7.628  1.00 11.13           C
ATOM   1082  CD1 LEU   128     -45.399  13.599  -6.743  1.00 11.82           C
ATOM   1083  CD2 LEU   128     -44.635  11.243  -6.755  1.00 13.49           C
ATOM   1084  C   LEU   128     -46.755  10.814 -10.630  1.00 10.57           C
ATOM   1085  O   LEU   128     -47.393   9.762 -10.464  1.00  8.87           O
ATOM   1086  N   ALA   129     -47.111  11.725 -11.531  1.00  9.99           N
ATOM   1087  CA  ALA   129     -48.264  11.513 -12.419  1.00 10.43           C
ATOM   1088  CB  ALA   129     -48.466  12.756 -13.298  1.00 10.04           C
ATOM   1089  C   ALA   129     -48.072  10.270 -13.290  1.00  9.53           C
ATOM   1090  O   ALA   129     -49.010   9.490 -13.509  1.00  9.22           O
ATOM   1091  N   GLU   130     -46.842  10.075 -13.777  1.00 10.54           N
ATOM   1092  CA  GLU   130     -46.555   8.883 -14.586  1.00 10.65           C
ATOM   1093  CB  GLU   130     -45.130   8.957 -15.080  1.00 11.71           C
ATOM   1094  CG  GLU   130     -45.015   9.922 -16.236  1.00 15.98           C
ATOM   1095  CD  GLU   130     -43.548  10.268 -16.577  1.00 25.12           C
ATOM   1096  OE1 GLU   130     -42.602   9.684 -15.991  1.00 26.80           O
ATOM   1097  OE2 GLU   130     -43.362  11.157 -17.432  1.00 30.61           O
ATOM   1098  C   GLU   130     -46.799   7.589 -13.828  1.00 10.74           C
ATOM   1099  O   GLU   130     -47.364   6.626 -14.382  1.00  9.75           O
ATOM   1100  N   SER   131     -46.395   7.580 -12.558  0.50 10.14           N
ATOM   1102  CA  SER   131     -46.583   6.411 -11.722  0.50 10.49           C
ATOM   1104  CB  SER   131     -45.843   6.578 -10.396  0.50 11.10           C
ATOM   1106  OG  SER   131     -45.705   5.328  -9.775  0.50 10.69           O
ATOM   1108  C   SER   131     -48.057   6.142 -11.458  0.50 10.47           C
ATOM   1110  O   SER   131     -48.497   4.991 -11.474  0.50  9.95           O
ATOM   1112  N   ILE   132     -48.806   7.214 -11.186  1.00  9.30           N
ATOM   1113  CA  ILE   132     -50.274   7.155 -11.007  1.00 10.27           C
ATOM   1114  CB  ILE   132     -50.819   8.528 -10.573  1.00 10.43           C
ATOM   1115  CG1 ILE   132     -50.217   8.879  -9.199  1.00 10.19           C
ATOM   1116  CD1 ILE   132     -50.537  10.321  -8.694  1.00 10.55           C
ATOM   1117  CG2 ILE   132     -52.352   8.522 -10.544  1.00 12.86           C
ATOM   1118  C   ILE   132     -50.956   6.643 -12.274  1.00 10.09           C
ATOM   1119  O   ILE   132     -51.855   5.784 -12.188  1.00  9.47           O
ATOM   1120  N   GLU   133     -50.535   7.164 -13.426  0.50 10.08           N
ATOM   1122  CA  GLU   133     -51.024   6.713 -14.732  0.50 10.68           C
ATOM   1124  CB  GLU   133     -50.390   7.549 -15.871  0.50 10.91           C
ATOM   1126  CG  GLU   133     -51.050   8.940 -16.009  0.50 12.45           C
ATOM   1128  CD  GLU   133     -50.193  10.029 -16.674  0.50 14.41           C
ATOM   1130  OE1 GLU   133     -48.998   9.781 -16.983  0.50 17.78           O
ATOM   1132  OE2 GLU   133     -50.748  11.144 -16.892  0.50 18.07           O
ATOM   1134  C   GLU   133     -50.823   5.208 -14.941  0.50  9.88           C
ATOM   1136  O   GLU   133     -51.712   4.518 -15.430  0.50 10.09           O
ATOM   1138  N   ALA   134     -49.659   4.695 -14.546  1.00  9.31           N
ATOM   1139  CA  ALA   134     -49.346   3.267 -14.674  1.00  9.01           C
ATOM   1140  CB  ALA   134     -47.869   3.011 -14.361  1.00  9.38           C
ATOM   1141  C   ALA   134     -50.237   2.445 -13.765  1.00  9.17           C
ATOM   1142  O   ALA   134     -50.720   1.372 -14.144  1.00  9.07           O
ATOM   1143  N   GLY   135     -50.446   2.954 -12.554  1.00  9.74           N
ATOM   1144  CA  GLY   135     -51.304   2.264 -11.598  1.00  9.68           C
ATOM   1145  C   GLY   135     -52.748   2.231 -12.081  1.00 10.54           C
ATOM   1146  O   GLY   135     -53.432   1.261 -11.841  1.00 11.18           O
ATOM   1147  N   MET   136     -53.212   3.294 -12.736  1.00 10.78           N
ATOM   1148  CA  MET   136     -54.550   3.319 -13.316  1.00 14.00           C
ATOM   1149  CB  MET   136     -54.856   4.709 -13.853  1.00 12.19           C
ATOM   1150  CG  MET   136     -55.025   5.738 -12.769  1.00 17.50           C
ATOM   1151  SD  MET   136     -55.390   7.532 -13.517  0.80 27.77          SE
ATOM   1152  CE  MET   136     -56.956   7.128 -14.509  1.00 24.50           C
ATOM   1153  C   MET   136     -54.690   2.274 -14.426  1.00 11.62           C
ATOM   1154  O   MET   136     -55.630   1.461 -14.414  1.00 11.88           O
ATOM   1155  N   THR   137     -53.704   2.228 -15.331  1.00 10.74           N
ATOM   1156  CA  THR   137     -53.673   1.197 -16.405  1.00  9.88           C
ATOM   1157  CB  THR   137     -52.401   1.371 -17.285  1.00  9.89           C
ATOM   1158  OG1 THR   137     -52.434   2.676 -17.872  1.00 11.23           O
ATOM   1159  CG2 THR   137     -52.311   0.289 -18.374  1.00 10.49           C
ATOM   1160  C   THR   137     -53.735  -0.220 -15.824  1.00  9.70           C
ATOM   1161  O   THR   137     -54.451  -1.096 -16.313  1.00  8.79           O
ATOM   1162  N   ARG   138     -53.012  -0.433 -14.737  1.00 10.06           N
ATOM   1163  CA  ARG   138     -52.962  -1.726 -14.092  1.00 10.50           C
ATOM   1164  CB  ARG   138     -51.753  -1.827 -13.178  1.00 10.22           C
ATOM   1165  CG  ARG   138     -50.421  -1.961 -13.926  1.00 11.00           C
ATOM   1166  CD  ARG   138     -49.267  -1.783 -12.921  1.00 11.40           C
ATOM   1167  NE  ARG   138     -49.385  -2.776 -11.860  1.00 13.48           N
ATOM   1168  CZ  ARG   138     -48.694  -2.749 -10.731  1.00 16.65           C
ATOM   1169  NH1 ARG   138     -47.798  -1.778 -10.519  1.00 13.97           N
ATOM   1170  NH2 ARG   138     -48.909  -3.699  -9.812  1.00 18.04           N
ATOM   1171  C   ARG   138     -54.233  -2.088 -13.308  1.00 11.15           C
ATOM   1172  O   ARG   138     -54.391  -3.238 -12.908  1.00 11.80           O
ATOM   1173  N   GLY   139     -55.117  -1.122 -13.103  1.00 12.43           N
ATOM   1174  CA  GLY   139     -56.308  -1.342 -12.309  1.00 12.85           C
ATOM   1175  C   GLY   139     -56.098  -1.206 -10.803  1.00 14.77           C
ATOM   1176  O   GLY   139     -57.031  -1.500 -10.021  1.00 15.21           O
ATOM   1177  N   LEU   140     -54.904  -0.785 -10.370  1.00 14.40           N
ATOM   1178  CA  LEU   140     -54.663  -0.525  -8.930  1.00 15.70           C
ATOM   1179  CB  LEU   140     -53.175  -0.325  -8.608  1.00 17.02           C
ATOM   1180  CG  LEU   140     -52.165  -1.407  -8.937  1.00 20.06           C
ATOM   1181  CD1 LEU   140     -50.855  -0.921  -8.327  1.00 24.89           C
ATOM   1182  CD2 LEU   140     -52.585  -2.711  -8.319  1.00 24.25           C
ATOM   1183  C   LEU   140     -55.356   0.744  -8.489  1.00 14.92           C
ATOM   1184  O   LEU   140     -55.818   0.834  -7.342  1.00 14.43           O
ATOM   1185  N   PHE   141     -55.378   1.734  -9.384  1.00 13.97           N
ATOM   1186  CA  PHE   141     -55.934   3.051  -9.092  1.00 15.04           C
ATOM   1187  CB  PHE   141     -54.894   4.159  -9.339  1.00 13.91           C
ATOM   1188  CG  PHE   141     -53.627   4.016  -8.510  1.00 13.77           C
ATOM   1189  CD1 PHE   141     -53.668   3.442  -7.227  1.00 13.85           C
ATOM   1190  CE1 PHE   141     -52.491   3.310  -6.463  1.00 13.85           C
ATOM   1191  CZ  PHE   141     -51.267   3.776  -7.000  1.00 12.20           C
ATOM   1192  CE2 PHE   141     -51.240   4.341  -8.294  1.00 10.44           C
ATOM   1193  CD2 PHE   141     -52.392   4.479  -9.011  1.00 12.75           C
ATOM   1194  C   PHE   141     -57.151   3.307  -9.951  1.00 15.74           C
ATOM   1195  O   PHE   141     -57.249   2.777 -11.067  1.00 14.26           O
ATOM   1196  N   ARG   142     -58.074   4.120  -9.443  0.50 16.15           N
ATOM   1198  CA  ARG   142     -59.333   4.428 -10.124  0.50 17.47           C
ATOM   1200  CB  ARG   142     -60.256   5.250  -9.227  0.50 17.67           C
ATOM   1202  CG  ARG   142     -60.907   4.514  -8.115  0.50 18.73           C
ATOM   1204  CD  ARG   142     -61.871   5.446  -7.428  0.50 20.28           C
ATOM   1206  NE  ARG   142     -61.191   6.543  -6.744  0.50 20.28           N
ATOM   1208  CZ  ARG   142     -61.802   7.632  -6.287  0.50 20.99           C
ATOM   1210  NH1 ARG   142     -63.104   7.797  -6.474  0.50 17.88           N
ATOM   1212  NH2 ARG   142     -61.099   8.580  -5.668  0.50 20.92           N
ATOM   1214  C   ARG   142     -59.126   5.255 -11.374  0.50 17.70           C
ATOM   1216  O   ARG   142     -58.339   6.198 -11.388  0.50 18.50           O
ATOM   1218  N   ARG   143     -59.912   4.938 -12.395  1.00 18.41           N
ATOM   1219  CA  ARG   143     -59.747   5.554 -13.691  1.00 19.17           C
ATOM   1220  CB  ARG   143     -60.007   4.550 -14.785  1.00 19.39           C
ATOM   1221  CG  ARG   143     -58.965   3.434 -14.827  1.00 22.29           C
ATOM   1222  CD  ARG   143     -59.450   2.272 -15.677  1.00 26.49           C
ATOM   1223  NE  ARG   143     -58.403   1.273 -15.895  1.00 30.12           N
ATOM   1224  CZ  ARG   143     -58.545  -0.047 -15.757  1.00 31.21           C
ATOM   1225  NH1 ARG   143     -59.715  -0.594 -15.415  1.00 32.67           N
ATOM   1226  NH2 ARG   143     -57.502  -0.838 -15.984  1.00 31.42           N
ATOM   1227  C   ARG   143     -60.507   6.857 -13.893  1.00 18.83           C
ATOM   1228  O   ARG   143     -60.315   7.510 -14.913  1.00 20.12           O
ATOM   1229  N   ASP   144     -61.324   7.254 -12.917  1.00 17.76           N
ATOM   1230  CA  ASP   144     -62.025   8.547 -12.977  1.00 16.37           C
ATOM   1231  CB  ASP   144     -63.426   8.450 -12.354  1.00 16.63           C
ATOM   1232  CG  ASP   144     -63.395   8.116 -10.877  1.00 17.52           C
ATOM   1233  OD1 ASP   144     -62.398   7.530 -10.424  1.00 17.03           O
ATOM   1234  OD2 ASP   144     -64.383   8.426 -10.159  1.00 20.81           O
ATOM   1235  C   ASP   144     -61.281   9.716 -12.339  1.00 15.58           C
ATOM   1236  O   ASP   144     -61.871  10.803 -12.135  1.00 16.22           O
ATOM   1237  N   LEU   145     -60.024   9.520 -11.954  0.50 14.65           N
ATOM   1239  CA  LEU   145     -59.257  10.650 -11.435  0.50 13.62           C
ATOM   1241  CB  LEU   145     -58.748  10.426 -10.005  0.50 13.58           C
ATOM   1243  CG  LEU   145     -59.708  10.249  -8.827  0.50 13.00           C
ATOM   1245  CD1 LEU   145     -58.863   9.721  -7.686  0.50 13.60           C
ATOM   1247  CD2 LEU   145     -60.478  11.539  -8.398  0.50 13.09           C
ATOM   1249  C   LEU   145     -58.106  10.962 -12.376  0.50 13.00           C
ATOM   1251  O   LEU   145     -57.581  10.079 -13.050  0.50 12.96           O
ATOM   1253  N   HIS   146     -57.762  12.235 -12.428  1.00 12.38           N
ATOM   1254  CA  HIS   146     -56.767  12.749 -13.335  1.00 11.72           C
ATOM   1255  CB  HIS   146     -57.099  14.174 -13.754  1.00 13.12           C
ATOM   1256  CG  HIS   146     -58.088  14.223 -14.890  1.00 18.87           C
ATOM   1257  ND1 HIS   146     -59.407  14.593 -14.717  1.00 23.34           N
ATOM   1258  CE1 HIS   146     -60.041  14.495 -15.875  1.00 23.61           C
ATOM   1259  NE2 HIS   146     -59.189  14.056 -16.787  1.00 22.78           N
ATOM   1260  CD2 HIS   146     -57.966  13.859 -16.194  1.00 21.18           C
ATOM   1261  C   HIS   146     -55.432  12.632 -12.658  1.00  9.97           C
ATOM   1262  O   HIS   146     -55.283  13.064 -11.523  1.00  8.48           O
ATOM   1263  N   ALA   147     -54.466  12.063 -13.380  1.00  8.06           N
ATOM   1264  CA  ALA   147     -53.171  11.743 -12.792  1.00  7.43           C
ATOM   1265  CB  ALA   147     -52.303  10.976 -13.795  1.00  7.64           C
ATOM   1266  C   ALA   147     -52.415  12.975 -12.255  1.00  7.37           C
ATOM   1267  O   ALA   147     -51.892  12.935 -11.149  1.00  7.42           O
ATOM   1268  N   VAL   148     -52.323  14.040 -13.057  1.00  5.91           N
ATOM   1269  CA  VAL   148     -51.580  15.234 -12.596  1.00  5.28           C
ATOM   1270  CB  VAL   148     -51.376  16.285 -13.741  1.00  5.29           C
ATOM   1271  CG1 VAL   148     -50.894  17.623 -13.160  1.00  5.38           C
ATOM   1272  CG2 VAL   148     -50.385  15.716 -14.827  1.00  7.18           C
ATOM   1273  C   VAL   148     -52.285  15.874 -11.417  1.00  5.21           C
ATOM   1274  O   VAL   148     -51.641  16.225 -10.424  1.00  4.80           O
ATOM   1275  N   ASN   149     -53.605  16.034 -11.475  1.00  5.51           N
ATOM   1276  CA  ASN   149     -54.259  16.664 -10.322  1.00  5.65           C
ATOM   1277  CB  ASN   149     -55.765  16.822 -10.566  1.00  6.66           C
ATOM   1278  CG  ASN   149     -56.088  18.026 -11.409  1.00 10.17           C
ATOM   1279  OD1 ASN   149     -55.200  18.846 -11.725  1.00 12.80           O
ATOM   1280  ND2 ASN   149     -57.358  18.143 -11.798  1.00 12.10           N
ATOM   1281  C   ASN   149     -54.045  15.842  -9.043  1.00  6.11           C
ATOM   1282  O   ASN   149     -53.933  16.413  -7.953  1.00  4.78           O
ATOM   1283  N   SER   150     -53.988  14.513  -9.207  1.00  5.76           N
ATOM   1284  CA  SER   150     -53.748  13.564  -8.084  1.00  6.08           C
ATOM   1285  CB  SER   150     -54.027  12.096  -8.522  1.00  5.78           C
ATOM   1286  OG  SER   150     -55.422  11.927  -8.837  1.00  7.08           O
ATOM   1287  C   SER   150     -52.331  13.717  -7.550  1.00  5.66           C
ATOM   1288  O   SER   150     -52.119  13.810  -6.341  1.00  5.57           O
ATOM   1289  N   ALA   151     -51.349  13.768  -8.451  1.00  5.77           N
ATOM   1290  CA  ALA   151     -49.966  14.064  -8.076  1.00  5.41           C
ATOM   1291  CB  ALA   151     -49.086  14.156  -9.326  1.00  5.18           C
ATOM   1292  C   ALA   151     -49.874  15.386  -7.279  1.00  5.91           C
ATOM   1293  O   ALA   151     -49.179  15.466  -6.262  1.00  6.61           O
ATOM   1294  N   LEU   152     -50.552  16.425  -7.784  1.00  6.31           N
ATOM   1295  CA  LEU   152     -50.534  17.749  -7.110  1.00  5.72           C
ATOM   1296  CB  LEU   152     -51.297  18.807  -7.921  1.00  4.81           C
ATOM   1297  CG  LEU   152     -50.598  19.222  -9.218  1.00  4.27           C
ATOM   1298  CD1 LEU   152     -51.572  20.071 -10.072  1.00  6.58           C
ATOM   1299  CD2 LEU   152     -49.276  20.001  -8.973  1.00  5.18           C
ATOM   1300  C   LEU   152     -51.132  17.647  -5.707  1.00  7.70           C
ATOM   1301  O   LEU   152     -50.626  18.296  -4.766  1.00  7.69           O
ATOM   1302  N   ALA   153     -52.188  16.836  -5.551  1.00  6.37           N
ATOM   1303  CA  ALA   153     -52.794  16.600  -4.245  1.00  7.16           C
ATOM   1304  CB  ALA   153     -54.029  15.679  -4.378  1.00  5.65           C
ATOM   1305  C   ALA   153     -51.787  16.008  -3.247  1.00  7.42           C
ATOM   1306  O   ALA   153     -51.667  16.511  -2.117  1.00  6.88           O
ATOM   1307  N   LEU   154     -51.039  14.972  -3.683  1.00  5.98           N
ATOM   1308  CA  LEU   154     -50.031  14.354  -2.805  1.00  5.94           C
ATOM   1309  CB  LEU   154     -49.453  13.092  -3.458  1.00  6.06           C
ATOM   1310  CG  LEU   154     -48.400  12.364  -2.617  1.00  6.43           C
ATOM   1311  CD1 LEU   154     -48.990  11.876  -1.271  1.00  5.45           C
ATOM   1312  CD2 LEU   154     -47.790  11.240  -3.434  1.00  7.02           C
ATOM   1313  C   LEU   154     -48.921  15.373  -2.447  1.00  5.85           C
ATOM   1314  O   LEU   154     -48.530  15.518  -1.271  1.00  6.15           O
ATOM   1315  N   ALA   155     -48.449  16.084  -3.464  1.00  6.37           N
ATOM   1316  CA  ALA   155     -47.402  17.083  -3.242  1.00  6.90           C
ATOM   1317  CB  ALA   155     -46.984  17.689  -4.593  1.00  7.15           C
ATOM   1318  C   ALA   155     -47.927  18.147  -2.260  1.00  6.59           C
ATOM   1319  O   ALA   155     -47.181  18.625  -1.387  1.00  7.17           O
ATOM   1320  N   GLY   156     -49.204  18.510  -2.409  1.00  6.53           N
ATOM   1321  CA  GLY   156     -49.808  19.558  -1.574  1.00  7.23           C
ATOM   1322  C   GLY   156     -49.903  19.117  -0.129  1.00  8.33           C
ATOM   1323  O   GLY   156     -49.684  19.935   0.770  1.00  9.18           O
ATOM   1324  N   MET   157     -50.275  17.857   0.104  0.50  7.22           N
ATOM   1326  CA  MET   157     -50.394  17.342   1.473  0.50  9.40           C
ATOM   1328  CB  MET   157     -50.608  15.818   1.495  0.50  9.03           C
ATOM   1330  CG  MET   157     -51.950  15.368   1.037  0.50 10.44           C
ATOM   1332  SD  MET   157     -52.121  13.470   1.490  0.50 14.75          SE
ATOM   1334  CE  MET   157     -53.565  13.043   0.240  0.50 11.36           C
ATOM   1336  C   MET   157     -49.104  17.647   2.216  0.50  8.33           C
ATOM   1338  O   MET   157     -49.097  18.375   3.226  0.50  7.60           O
ATOM   1340  N   VAL   158     -48.020  17.067   1.700  1.00  7.62           N
ATOM   1341  CA  VAL   158     -46.738  17.073   2.389  1.00  7.60           C
ATOM   1342  CB  VAL   158     -45.769  16.001   1.870  1.00  7.87           C
ATOM   1343  CG1 VAL   158     -45.363  16.267   0.375  1.00  6.80           C
ATOM   1344  CG2 VAL   158     -44.556  15.904   2.800  1.00  5.50           C
ATOM   1345  C   VAL   158     -46.161  18.504   2.448  1.00  8.05           C
ATOM   1346  O   VAL   158     -45.655  18.951   3.498  1.00  7.94           O
ATOM   1347  N   ASN   159     -46.268  19.258   1.359  1.00  6.99           N
ATOM   1348  CA  ASN   159     -45.679  20.596   1.364  1.00  8.56           C
ATOM   1349  CB  ASN   159     -45.517  21.063  -0.110  1.00  9.44           C
ATOM   1350  CG  ASN   159     -44.267  20.391  -0.770  1.00 13.46           C
ATOM   1351  OD1 ASN   159     -43.115  20.774  -0.449  1.00 13.49           O
ATOM   1352  ND2 ASN   159     -44.491  19.365  -1.676  1.00 11.04           N
ATOM   1353  C   ASN   159     -46.491  21.532   2.299  1.00  8.55           C
ATOM   1354  O   ASN   159     -45.898  22.350   3.007  1.00  8.77           O
ATOM   1355  N   TYR   160     -47.807  21.324   2.393  1.00  8.99           N
ATOM   1356  CA  TYR   160     -48.598  22.206   3.289  1.00  8.46           C
ATOM   1357  CB  TYR   160     -50.076  22.031   3.041  1.00  9.05           C
ATOM   1358  CG  TYR   160     -50.895  23.089   3.758  1.00  6.76           C
ATOM   1359  CD1 TYR   160     -51.004  24.373   3.254  1.00  6.16           C
ATOM   1360  CE1 TYR   160     -51.755  25.374   3.951  1.00  6.68           C
ATOM   1361  CZ  TYR   160     -52.367  25.032   5.159  1.00  6.05           C
ATOM   1362  OH  TYR   160     -53.125  25.927   5.884  1.00  6.88           O
ATOM   1363  CE2 TYR   160     -52.260  23.729   5.663  1.00  7.56           C
ATOM   1364  CD2 TYR   160     -51.513  22.779   4.968  1.00  8.31           C
ATOM   1365  C   TYR   160     -48.297  21.873   4.749  1.00  8.41           C
ATOM   1366  O   TYR   160     -48.341  22.775   5.600  1.00  7.66           O
ATOM   1367  N   PHE   161     -48.025  20.596   5.064  1.00  7.26           N
ATOM   1368  CA  PHE   161     -47.662  20.273   6.467  1.00  7.86           C
ATOM   1369  CB  PHE   161     -47.311  18.790   6.604  1.00  7.74           C
ATOM   1370  CG  PHE   161     -46.983  18.392   7.998  1.00  9.30           C
ATOM   1371  CD1 PHE   161     -48.006  18.107   8.896  1.00 12.83           C
ATOM   1372  CE1 PHE   161     -47.720  17.697  10.215  1.00 11.42           C
ATOM   1373  CZ  PHE   161     -46.391  17.641  10.657  1.00 12.71           C
ATOM   1374  CE2 PHE   161     -45.357  17.968   9.769  1.00 10.83           C
ATOM   1375  CD2 PHE   161     -45.666  18.335   8.433  1.00 11.04           C
ATOM   1376  C   PHE   161     -46.491  21.148   6.954  1.00  7.95           C
ATOM   1377  O   PHE   161     -46.543  21.724   8.066  1.00  9.32           O
ATOM   1378  N   PHE   162     -45.463  21.301   6.114  1.00  6.72           N
ATOM   1379  CA  PHE   162     -44.318  22.124   6.507  1.00  7.65           C
ATOM   1380  CB  PHE   162     -43.078  21.726   5.710  1.00  7.99           C
ATOM   1381  CG  PHE   162     -42.566  20.366   6.105  1.00  9.27           C
ATOM   1382  CD1 PHE   162     -41.714  20.225   7.191  1.00 10.78           C
ATOM   1383  CE1 PHE   162     -41.239  18.956   7.593  1.00 11.91           C
ATOM   1384  CZ  PHE   162     -41.634  17.827   6.904  1.00 11.69           C
ATOM   1385  CE2 PHE   162     -42.511  17.965   5.784  1.00 13.79           C
ATOM   1386  CD2 PHE   162     -42.967  19.220   5.412  1.00 10.23           C
ATOM   1387  C   PHE   162     -44.639  23.608   6.400  1.00  6.36           C
ATOM   1388  O   PHE   162     -44.272  24.414   7.281  1.00  6.77           O
ATOM   1389  N   LEU   163     -45.339  23.986   5.329  1.00  6.53           N
ATOM   1390  CA  LEU   163     -45.685  25.410   5.150  1.00  6.76           C
ATOM   1391  CB  LEU   163     -46.531  25.576   3.876  1.00  6.66           C
ATOM   1392  CG  LEU   163     -46.960  27.017   3.573  1.00  7.04           C
ATOM   1393  CD1 LEU   163     -45.732  27.937   3.372  1.00  9.53           C
ATOM   1394  CD2 LEU   163     -47.878  27.026   2.294  1.00  8.47           C
ATOM   1395  C   LEU   163     -46.462  25.968   6.327  1.00  6.16           C
ATOM   1396  O   LEU   163     -46.251  27.132   6.716  1.00  6.46           O
ATOM   1397  N   SER   164     -47.398  25.156   6.872  1.00  5.30           N
ATOM   1398  CA  SER   164     -48.338  25.682   7.889  1.00  7.61           C
ATOM   1399  CB  SER   164     -49.657  24.912   7.802  1.00  8.19           C
ATOM   1400  OG  SER   164     -49.459  23.552   8.139  1.00  9.73           O
ATOM   1401  C   SER   164     -47.773  25.574   9.326  1.00  7.56           C
ATOM   1402  O   SER   164     -48.479  25.903  10.294  1.00  8.21           O
ATOM   1403  N   THR   165     -46.511  25.154   9.458  1.00  5.79           N
ATOM   1404  CA  THR   165     -45.964  24.822  10.782  1.00  6.26           C
ATOM   1405  CB  THR   165     -44.424  24.572  10.701  1.00  6.23           C
ATOM   1406  OG1 THR   165     -44.184  23.428   9.866  1.00  7.44           O
ATOM   1407  CG2 THR   165     -43.891  24.259  12.117  1.00  8.11           C
ATOM   1408  C   THR   165     -46.186  25.914  11.821  1.00  4.75           C
ATOM   1409  O   THR   165     -46.641  25.626  12.936  1.00  5.25           O
ATOM   1410  N   LEU   166     -45.844  27.165  11.481  1.00  5.75           N
ATOM   1411  CA  LEU   166     -45.911  28.235  12.482  1.00  6.51           C
ATOM   1412  CB  LEU   166     -45.339  29.576  11.965  1.00  6.68           C
ATOM   1413  CG  LEU   166     -43.841  29.678  11.719  1.00 10.81           C
ATOM   1414  CD1 LEU   166     -43.547  31.167  11.394  1.00 11.81           C
ATOM   1415  CD2 LEU   166     -43.055  29.293  13.016  1.00 11.69           C
ATOM   1416  C   LEU   166     -47.337  28.456  12.986  1.00  7.46           C
ATOM   1417  O   LEU   166     -47.491  28.973  14.095  1.00  8.56           O
ATOM   1418  N   ALA   167     -48.369  28.123  12.171  1.00  6.08           N
ATOM   1419  CA  ALA   167     -49.766  28.384  12.541  1.00  8.18           C
ATOM   1420  CB  ALA   167     -50.626  28.722  11.311  1.00  7.47           C
ATOM   1421  C   ALA   167     -50.387  27.203  13.251  1.00  8.91           C
ATOM   1422  O   ALA   167     -51.532  27.304  13.723  1.00  9.05           O
ATOM   1423  N   THR   168     -49.662  26.096  13.285  1.00  8.62           N
ATOM   1424  CA  THR   168     -50.264  24.857  13.794  1.00 10.98           C
ATOM   1425  CB  THR   168     -50.502  23.867  12.644  1.00  9.39           C
ATOM   1426  OG1 THR   168     -49.275  23.508  11.993  1.00 11.50           O
ATOM   1427  CG2 THR   168     -51.464  24.477  11.542  1.00  9.79           C
ATOM   1428  C   THR   168     -49.423  24.220  14.919  1.00 10.56           C
ATOM   1429  O   THR   168     -49.522  22.997  15.158  1.00 11.79           O
ATOM   1430  N   GLU   169     -48.671  25.069  15.639  1.00 13.47           N
ATOM   1431  CA  GLU   169     -47.634  24.567  16.568  1.00 14.51           C
ATOM   1432  CB  GLU   169     -46.793  25.705  17.190  1.00 15.58           C
ATOM   1433  CG  GLU   169     -45.950  26.533  16.217  1.00 16.67           C
ATOM   1434  CD  GLU   169     -44.641  25.858  15.769  1.00 18.06           C
ATOM   1435  OE1 GLU   169     -44.427  24.660  16.046  1.00 20.34           O
ATOM   1436  OE2 GLU   169     -43.824  26.515  15.088  1.00 17.77           O
ATOM   1437  C   GLU   169     -48.280  23.732  17.661  1.00 14.80           C
ATOM   1438  O   GLU   169     -47.758  22.662  18.045  1.00 15.84           O
ATOM   1439  N   GLY   170     -49.391  24.218  18.188  1.00 14.31           N
ATOM   1440  CA  GLY   170     -50.050  23.519  19.293  1.00 15.34           C
ATOM   1441  C   GLY   170     -51.115  22.570  18.807  1.00 14.96           C
ATOM   1442  O   GLY   170     -51.802  21.946  19.628  1.00 15.30           O
ATOM   1443  N   LEU   171     -51.257  22.405  17.486  1.00 11.97           N
ATOM   1444  CA  LEU   171     -52.364  21.571  16.985  1.00 12.07           C
ATOM   1445  CB  LEU   171     -53.048  22.173  15.739  1.00 11.20           C
ATOM   1446  CG  LEU   171     -53.567  23.620  15.751  1.00 13.56           C
ATOM   1447  CD1 LEU   171     -54.356  23.917  14.477  1.00 12.40           C
ATOM   1448  CD2 LEU   171     -54.410  23.968  16.985  1.00 16.09           C
ATOM   1449  C   LEU   171     -51.901  20.179  16.629  1.00 12.32           C
ATOM   1450  O   LEU   171     -52.706  19.251  16.620  1.00 12.27           O
ATOM   1451  N   THR   172     -50.620  20.021  16.304  1.00 11.32           N
ATOM   1452  CA  THR   172     -50.093  18.690  15.929  1.00 12.36           C
ATOM   1453  CB  THR   172     -50.439  18.296  14.451  1.00 11.94           C
ATOM   1454  OG1 THR   172     -50.076  16.907  14.240  1.00 16.35           O
ATOM   1455  CG2 THR   172     -49.710  19.217  13.452  1.00 12.29           C
ATOM   1456  C   THR   172     -48.585  18.711  16.141  1.00 12.72           C
ATOM   1457  O   THR   172     -47.994  19.812  16.226  1.00 13.87           O
ATOM   1458  N   SER   173     -47.958  17.545  16.214  1.00 12.97           N
ATOM   1459  CA  SER   173     -46.524  17.503  16.397  1.00 11.93           C
ATOM   1460  CB  SER   173     -46.103  16.108  16.826  1.00 13.97           C
ATOM   1461  OG  SER   173     -44.681  15.989  16.771  1.00 14.44           O
ATOM   1462  C   SER   173     -45.874  17.806  15.060  1.00 12.33           C
ATOM   1463  O   SER   173     -46.353  17.332  14.028  1.00 12.42           O
ATOM   1464  N   HIS   174     -44.824  18.610  15.068  1.00 12.00           N
ATOM   1465  CA  HIS   174     -43.970  18.721  13.876  1.00 14.23           C
ATOM   1466  CB  HIS   174     -43.909  20.171  13.391  1.00 14.23           C
ATOM   1467  CG  HIS   174     -45.247  20.722  13.030  1.00 15.81           C
ATOM   1468  ND1 HIS   174     -46.071  21.324  13.968  1.00 16.61           N
ATOM   1469  CE1 HIS   174     -47.185  21.718  13.368  1.00 20.91           C
ATOM   1470  NE2 HIS   174     -47.116  21.386  12.085  1.00 19.63           N
ATOM   1471  CD2 HIS   174     -45.900  20.785  11.839  1.00 17.42           C
ATOM   1472  C   HIS   174     -42.578  18.183  14.149  1.00 13.15           C
ATOM   1473  O   HIS   174     -41.625  18.515  13.427  1.00 14.79           O
ATOM   1474  N   SER   175     -42.456  17.352  15.179  1.00 14.28           N
ATOM   1475  CA  SER   175     -41.158  16.794  15.566  1.00 13.71           C
ATOM   1476  CB  SER   175     -41.281  16.104  16.921  1.00 14.35           C
ATOM   1477  OG  SER   175     -40.255  15.138  17.113  1.00 17.37           O
ATOM   1478  C   SER   175     -40.645  15.822  14.475  1.00 13.44           C
ATOM   1479  O   SER   175     -41.412  15.024  13.953  1.00 12.58           O
ATOM   1480  N   PRO   176     -39.341  15.882  14.146  1.00 13.15           N
ATOM   1481  CA  PRO   176     -38.830  14.880  13.178  1.00 13.22           C
ATOM   1482  CB  PRO   176     -37.342  15.224  13.064  1.00 13.70           C
ATOM   1483  CG  PRO   176     -37.228  16.655  13.534  1.00 13.98           C
ATOM   1484  CD  PRO   176     -38.278  16.806  14.593  1.00 13.08           C
ATOM   1485  C   PRO   176     -39.045  13.413  13.624  1.00 14.24           C
ATOM   1486  O   PRO   176     -39.154  12.527  12.770  1.00 13.21           O
ATOM   1487  N   ASP   177     -39.134  13.171  14.936  1.00 14.82           N
ATOM   1488  CA  ASP   177     -39.514  11.855  15.496  1.00 16.58           C
ATOM   1489  CB  ASP   177     -39.811  11.976  17.000  1.00 17.92           C
ATOM   1490  CG  ASP   177     -38.610  12.345  17.796  1.00 24.07           C
ATOM   1491  OD1 ASP   177     -37.500  12.389  17.204  1.00 30.89           O
ATOM   1492  OD2 ASP   177     -38.764  12.562  19.024  1.00 30.05           O
ATOM   1493  C   ASP   177     -40.780  11.270  14.887  1.00 15.97           C
ATOM   1494  O   ASP   177     -40.967  10.047  14.905  1.00 16.38           O
ATOM   1495  N   GLN   178     -41.655  12.147  14.404  1.00 14.77           N
ATOM   1496  CA  GLN   178     -42.965  11.735  13.923  1.00 15.23           C
ATOM   1497  CB  GLN   178     -44.057  12.637  14.515  1.00 16.28           C
ATOM   1498  CG  GLN   178     -44.212  12.558  16.075  1.00 18.38           C
ATOM   1499  CD  GLN   178     -44.416  11.148  16.555  1.00 24.89           C
ATOM   1500  OE1 GLN   178     -45.323  10.454  16.094  1.00 28.81           O
ATOM   1501  NE2 GLN   178     -43.556  10.694  17.466  1.00 23.68           N
ATOM   1502  C   GLN   178     -43.060  11.731  12.390  1.00 14.33           C
ATOM   1503  O   GLN   178     -44.153  11.563  11.837  1.00 14.25           O
ATOM   1504  N   ASP   179     -41.935  11.946  11.715  1.00 13.75           N
ATOM   1505  CA  ASP   179     -41.931  12.025  10.241  1.00 12.28           C
ATOM   1506  CB  ASP   179     -40.565  12.503   9.712  1.00 12.21           C
ATOM   1507  CG  ASP   179     -40.345  14.003   9.887  1.00 12.00           C
ATOM   1508  OD1 ASP   179     -41.340  14.728  10.133  1.00 12.73           O
ATOM   1509  OD2 ASP   179     -39.178  14.458   9.767  1.00 10.97           O
ATOM   1510  C   ASP   179     -42.333  10.695   9.583  1.00 12.43           C
ATOM   1511  O   ASP   179     -43.076  10.688   8.586  1.00 11.55           O
ATOM   1512  N   GLU   180     -41.873   9.564  10.129  1.00 12.85           N
ATOM   1513  CA  GLU   180     -42.244   8.281   9.539  1.00 13.39           C
ATOM   1514  CB  GLU   180     -41.363   7.129  10.047  1.00 14.36           C
ATOM   1515  CG  GLU   180     -39.961   7.112   9.416  1.00 16.71           C
ATOM   1516  CD  GLU   180     -39.971   6.815   7.917  1.00 18.99           C
ATOM   1517  OE1 GLU   180     -40.744   5.922   7.502  1.00 20.42           O
ATOM   1518  OE2 GLU   180     -39.200   7.469   7.161  1.00 18.63           O
ATOM   1519  C   GLU   180     -43.734   8.019   9.746  1.00 13.71           C
ATOM   1520  O   GLU   180     -44.403   7.448   8.873  1.00 13.28           O
ATOM   1521  N   GLU   181     -44.271   8.460  10.883  1.00 13.78           N
ATOM   1522  CA  GLU   181     -45.689   8.305  11.124  1.00 14.42           C
ATOM   1523  CB  GLU   181     -45.998   8.599  12.588  1.00 16.10           C
ATOM   1524  CG  GLU   181     -47.472   8.632  12.901  1.00 21.01           C
ATOM   1525  CD  GLU   181     -48.173   7.282  12.774  1.00 23.11           C
ATOM   1526  OE1 GLU   181     -47.514   6.228  12.665  1.00 24.17           O
ATOM   1527  OE2 GLU   181     -49.422   7.301  12.790  1.00 25.06           O
ATOM   1528  C   GLU   181     -46.494   9.212  10.185  1.00 14.14           C
ATOM   1529  O   GLU   181     -47.564   8.828   9.706  1.00 14.26           O
ATOM   1530  N   LEU   182     -45.956  10.396   9.878  1.00 13.08           N
ATOM   1531  CA  LEU   182     -46.604  11.293   8.915  1.00 13.64           C
ATOM   1532  CB  LEU   182     -45.865  12.643   8.831  1.00 12.83           C
ATOM   1533  CG  LEU   182     -46.579  13.680   7.940  1.00 14.91           C
ATOM   1534  CD1 LEU   182     -47.863  14.196   8.590  1.00 15.08           C
ATOM   1535  CD2 LEU   182     -45.644  14.827   7.575  1.00 15.95           C
ATOM   1536  C   LEU   182     -46.678  10.637   7.522  1.00 13.14           C
ATOM   1537  O   LEU   182     -47.718  10.661   6.855  1.00 14.11           O
ATOM   1538  N   ILE   183     -45.576  10.050   7.084  1.00 12.68           N
ATOM   1539  CA  ILE   183     -45.564   9.306   5.810  1.00 11.35           C
ATOM   1540  CB  ILE   183     -44.189   8.673   5.546  1.00 10.84           C
ATOM   1541  CG1 ILE   183     -43.122   9.766   5.347  1.00 12.02           C
ATOM   1542  CD1 ILE   183     -41.658   9.195   5.429  1.00 11.23           C
ATOM   1543  CG2 ILE   183     -44.228   7.768   4.309  1.00 11.12           C
ATOM   1544  C   ILE   183     -46.664   8.205   5.800  1.00 11.45           C
ATOM   1545  O   ILE   183     -47.422   8.086   4.830  1.00 10.62           O
ATOM   1546  N   ARG   184     -46.735   7.438   6.884  0.50 11.53           N
ATOM   1548  CA  ARG   184     -47.720   6.369   7.046  0.50 11.75           C
ATOM   1550  CB  ARG   184     -47.569   5.750   8.435  0.50 12.01           C
ATOM   1552  CG  ARG   184     -47.839   4.275   8.512  0.50 14.69           C
ATOM   1554  CD  ARG   184     -47.348   3.699   9.852  0.50 17.23           C
ATOM   1556  NE  ARG   184     -45.897   3.490   9.822  0.50 20.38           N
ATOM   1558  CZ  ARG   184     -45.023   3.988  10.695  0.50 19.61           C
ATOM   1560  NH1 ARG   184     -43.738   3.716  10.523  0.50 21.24           N
ATOM   1562  NH2 ARG   184     -45.415   4.720  11.740  0.50 16.19           N
ATOM   1564  C   ARG   184     -49.137   6.937   6.888  0.50 11.09           C
ATOM   1566  O   ARG   184     -49.974   6.363   6.185  0.50 10.52           O
ATOM   1568  N   GLN   185     -49.387   8.070   7.541  1.00 10.20           N
ATOM   1569  CA  GLN   185     -50.693   8.718   7.492  1.00 11.34           C
ATOM   1570  CB  GLN   185     -50.812   9.832   8.557  1.00 11.76           C
ATOM   1571  CG  GLN   185     -50.910   9.329   9.971  1.00 13.90           C
ATOM   1572  CD  GLN   185     -50.827  10.475  10.988  1.00 16.31           C
ATOM   1573  OE1 GLN   185     -51.146  11.627  10.670  1.00 24.88           O
ATOM   1574  NE2 GLN   185     -50.379  10.163  12.192  1.00 22.00           N
ATOM   1575  C   GLN   185     -51.069   9.294   6.120  1.00 10.79           C
ATOM   1576  O   GLN   185     -52.231   9.134   5.675  1.00 10.92           O
ATOM   1577  N   TYR   186     -50.095   9.901   5.436  1.00  9.48           N
ATOM   1578  CA  TYR   186     -50.375  10.550   4.165  1.00 10.97           C
ATOM   1579  CB  TYR   186     -49.386  11.701   3.929  1.00 11.73           C
ATOM   1580  CG  TYR   186     -49.831  12.983   4.689  1.00 11.89           C
ATOM   1581  CD1 TYR   186     -50.901  12.943   5.618  1.00 16.50           C
ATOM   1582  CE1 TYR   186     -51.319  14.116   6.323  1.00 16.69           C
ATOM   1583  CZ  TYR   186     -50.665  15.304   6.104  1.00 15.60           C
ATOM   1584  OH  TYR   186     -51.066  16.479   6.789  1.00 16.29           O
ATOM   1585  CE2 TYR   186     -49.579  15.336   5.236  1.00 15.60           C
ATOM   1586  CD2 TYR   186     -49.176  14.184   4.529  1.00 16.97           C
ATOM   1587  C   TYR   186     -50.456   9.510   3.024  1.00 10.48           C
ATOM   1588  O   TYR   186     -51.313   9.616   2.143  1.00 10.25           O
ATOM   1589  N   VAL   187     -49.660   8.448   3.114  1.00 10.81           N
ATOM   1590  CA  VAL   187     -49.813   7.308   2.195  1.00 11.07           C
ATOM   1591  CB  VAL   187     -48.750   6.195   2.457  1.00 12.17           C
ATOM   1592  CG1 VAL   187     -49.152   4.865   1.801  1.00 12.64           C
ATOM   1593  CG2 VAL   187     -47.381   6.636   1.948  1.00 12.10           C
ATOM   1594  C   VAL   187     -51.238   6.738   2.348  1.00 10.78           C
ATOM   1595  O   VAL   187     -51.902   6.468   1.365  1.00 11.55           O
ATOM   1596  N   ALA   188     -51.697   6.596   3.591  1.00 10.35           N
ATOM   1597  CA  ALA   188     -53.016   6.013   3.862  1.00 10.34           C
ATOM   1598  CB  ALA   188     -53.214   5.835   5.322  1.00 10.03           C
ATOM   1599  C   ALA   188     -54.109   6.923   3.278  1.00 10.52           C
ATOM   1600  O   ALA   188     -54.976   6.440   2.532  1.00 11.14           O
ATOM   1601  N   ILE   189     -54.067   8.223   3.582  1.00  9.18           N
ATOM   1602  CA  ILE   189     -55.064   9.134   3.022  1.00 10.18           C
ATOM   1603  CB  ILE   189     -54.855  10.573   3.534  1.00 10.61           C
ATOM   1604  CG1 ILE   189     -55.136  10.601   5.058  1.00 10.98           C
ATOM   1605  CD1 ILE   189     -54.723  11.960   5.716  1.00 13.83           C
ATOM   1606  CG2 ILE   189     -55.802  11.563   2.805  1.00 11.30           C
ATOM   1607  C   ILE   189     -55.041   9.113   1.474  1.00  9.70           C
ATOM   1608  O   ILE   189     -56.074   9.014   0.819  1.00  9.40           O
ATOM   1609  N   PHE   190     -53.857   9.209   0.889  1.00  9.58           N
ATOM   1610  CA  PHE   190     -53.805   9.360  -0.550  1.00  9.58           C
ATOM   1611  CB  PHE   190     -52.360   9.611  -0.993  1.00 10.23           C
ATOM   1612  CG  PHE   190     -52.226  10.008  -2.454  1.00  9.45           C
ATOM   1613  CD1 PHE   190     -52.917  11.128  -2.945  1.00  9.44           C
ATOM   1614  CE1 PHE   190     -52.804  11.478  -4.324  1.00  8.91           C
ATOM   1615  CZ  PHE   190     -51.991  10.716  -5.159  1.00  8.37           C
ATOM   1616  CE2 PHE   190     -51.307   9.595  -4.666  1.00 10.34           C
ATOM   1617  CD2 PHE   190     -51.432   9.256  -3.313  1.00  9.34           C
ATOM   1618  C   PHE   190     -54.341   8.115  -1.252  1.00 10.23           C
ATOM   1619  O   PHE   190     -55.013   8.227  -2.272  1.00 10.36           O
ATOM   1620  N   THR   191     -54.011   6.933  -0.728  1.00 10.49           N
ATOM   1621  CA  THR   191     -54.331   5.687  -1.425  1.00 11.39           C
ATOM   1622  CB  THR   191     -53.251   4.575  -1.187  1.00 11.16           C
ATOM   1623  OG1 THR   191     -53.129   4.320   0.203  1.00 13.70           O
ATOM   1624  CG2 THR   191     -51.894   5.021  -1.716  1.00 12.85           C
ATOM   1625  C   THR   191     -55.730   5.173  -1.057  1.00 11.49           C
ATOM   1626  O   THR   191     -56.413   4.630  -1.920  1.00 11.57           O
ATOM   1627  N   ARG   192     -56.142   5.361   0.207  1.00 11.47           N
ATOM   1628  CA  ARG   192     -57.377   4.780   0.764  1.00 12.54           C
ATOM   1629  CB  ARG   192     -57.043   3.762   1.863  1.00 13.38           C
ATOM   1630  CG  ARG   192     -56.218   2.608   1.352  1.00 19.78           C
ATOM   1631  CD  ARG   192     -55.838   1.648   2.458  1.00 27.83           C
ATOM   1632  NE  ARG   192     -54.833   2.186   3.390  1.00 31.16           N
ATOM   1633  CZ  ARG   192     -54.979   2.196   4.710  1.00 30.70           C
ATOM   1634  NH1 ARG   192     -56.099   1.741   5.268  1.00 34.65           N
ATOM   1635  NH2 ARG   192     -54.007   2.636   5.480  1.00 31.86           N
ATOM   1636  C   ARG   192     -58.394   5.793   1.313  1.00 11.41           C
ATOM   1637  O   ARG   192     -59.513   5.408   1.694  1.00 11.66           O
ATOM   1638  N   GLY   193     -57.999   7.067   1.407  1.00 10.15           N
ATOM   1639  CA  GLY   193     -58.897   8.124   1.894  1.00  9.23           C
ATOM   1640  C   GLY   193     -59.105   8.042   3.399  1.00 10.71           C
ATOM   1641  O   GLY   193     -58.465   7.238   4.070  1.00 11.66           O
ATOM   1642  N   ILE   194     -60.015   8.848   3.940  1.00 10.09           N
ATOM   1643  CA  ILE   194     -60.233   8.806   5.378  1.00 10.51           C
ATOM   1644  CB  ILE   194     -60.410  10.235   5.966  1.00  9.22           C
ATOM   1645  CG1 ILE   194     -61.635  10.937   5.378  1.00  9.15           C
ATOM   1646  CD1 ILE   194     -62.095  12.150   6.229  1.00 10.65           C
ATOM   1647  CG2 ILE   194     -59.149  11.099   5.736  1.00 10.26           C
ATOM   1648  C   ILE   194     -61.435   7.920   5.776  1.00 13.00           C
ATOM   1649  O   ILE   194     -61.677   7.686   6.986  1.00 11.91           O
ATOM   1650  N   MET   195     -62.162   7.427   4.770  0.80 13.74           N
ATOM   1652  CA  MET   195     -63.370   6.618   5.035  0.80 19.32           C
ATOM   1654  CB  MET   195     -64.062   6.224   3.735  0.80 17.64           C
ATOM   1656  CG  MET   195     -63.224   5.251   2.910  0.80 22.42           C
ATOM   1658  SD  MET   195     -64.053   4.614   1.255  0.80 35.82          SE
ATOM   1660  CE  MET   195     -65.779   4.059   1.995  0.80 28.19           C
ATOM   1662  C   MET   195     -63.024   5.348   5.798  0.80 17.09           C
ATOM   1664  O   MET   195     -61.945   4.789   5.620  0.80 16.40           O
ATOM   1666  N   ALA   196     -63.946   4.892   6.647  1.00 16.54           N
ATOM   1667  CA  ALA   196     -63.751   3.621   7.358  1.00 17.64           C
ATOM   1668  CB  ALA   196     -64.842   3.419   8.388  1.00 17.48           C
ATOM   1669  C   ALA   196     -63.706   2.435   6.397  1.00 18.42           C
ATOM   1670  O   ALA   196     -64.469   2.403   5.437  1.00 19.76           O
END
