
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  192 ( 1553),  selected  192 , name 3ccy_A
# Molecule2: number of CA atoms  192 ( 1477),  selected  192 , name T0454.pdb
# PARAMETERS: 3ccy_A.T0454.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    Y     9_A      D       5           #
LGA    E    10_A      C       6           -
LGA    N    11_A      R       7           #
LGA    I    12_A      S       8          1.745
LGA    R    13_A      -       -           -
LGA    D    14_A      -       -           -
LGA    T    15_A      R       9          3.691
LGA    I    16_A      L      10          2.721
LGA    I    17_A      M      11          3.057
LGA    E    18_A      E      12          3.311
LGA    R    19_A      V      13          2.958
LGA    A    20_A      A      14          2.381
LGA    A    21_A      T      15          2.497
LGA    A    22_A      E      16          2.624
LGA    X    23_A      L      17          2.755
LGA    F    24_A      F      18          2.708
LGA    A    25_A      A      19          2.772
LGA    R    26_A      Q      20          2.932
LGA    Q    27_A      K      21          3.381
LGA    G    28_A      G      22          2.927
LGA    Y    29_A      F      23          2.920
LGA    S    30_A      Y      24          2.321
LGA    E    31_A      G      25          2.490
LGA    T    32_A      V      26          2.599
LGA    S    33_A      S      27          2.445
LGA    I    34_A      I      28          2.427
LGA    G    35_A      R      29          2.692
LGA    D    36_A      E      30          2.628
LGA    I    37_A      L      31          2.522
LGA    A    38_A      A      32          2.432
LGA    R    39_A      Q      33          3.204
LGA    A    40_A      A      34          3.107
LGA    C    41_A      A      35          2.865
LGA    E    42_A      G      36          4.227
LGA    C    43_A      A      37          3.722
LGA    S    44_A      S      38          3.655
LGA    K    45_A      I      39          3.307
LGA    S    46_A      S      40          3.303
LGA    R    47_A      M      41          3.016
LGA    L    48_A      I      42          2.629
LGA    Y    49_A      S      43          2.895
LGA    -       -      Y      44           -
LGA    H    50_A      H      45          1.853
LGA    Y    51_A      F      46          1.477
LGA    F    52_A      G      47          2.092
LGA    D    53_A      G      48          2.721
LGA    S    54_A      K      49          2.771
LGA    K    55_A      -       -           -
LGA    E    56_A      E      50          2.735
LGA    A    57_A      G      51          2.450
LGA    V    58_A      L      52          2.291
LGA    L    59_A      Y      53          2.403
LGA    R    60_A      A      54          2.397
LGA    D    61_A      A      55          2.612
LGA    X    62_A      V      56          2.579
LGA    L    63_A      L      57          2.385
LGA    T    64_A      Q      58          2.964
LGA    T    65_A      E      59          3.838
LGA    H    66_A      Q      60          3.362
LGA    V    67_A      F      61          2.962
LGA    D    68_A      A      62          3.890
LGA    S    69_A      C      63          2.172
LGA    L    70_A      F      64          1.526
LGA    L    71_A      G      65          2.706
LGA    E    72_A      Q      66          1.404
LGA    R    73_A      L      67          2.979
LGA    C    74_A      -       -           -
LGA    R    75_A      -       -           -
LGA    Q    76_A      D      68          0.962
LGA    V    77_A      D      69          1.584
LGA    L    78_A      I      70          3.434
LGA    Y    79_A      R      71          4.046
LGA    G    80_A      G      72          2.550
LGA    S    81_A      Q      73          3.119
LGA    N    82_A      A      74          5.833
LGA    -       -      G      75           -
LGA    E    83_A      D      76          2.759
LGA    P    84_A      P      77          2.383
LGA    K    85_A      L      78          1.333
LGA    T    86_A      A      79          1.530
LGA    R    87_A      V      80          2.137
LGA    F    88_A      M      81          1.573
LGA    L    89_A      T      82          0.370
LGA    Q    90_A      A      83          0.888
LGA    I    91_A      Y      84          1.257
LGA    V    92_A      L      85          1.187
LGA    K    93_A      R      86          0.654
LGA    L    94_A      W      87          0.423
LGA    F    95_A      T      88          1.036
LGA    L    96_A      I      89          1.171
LGA    E    97_A      Q      90          0.408
LGA    I    98_A      R      91          0.647
LGA    Y    99_A      H      92          0.585
LGA    A   100_A      R      93          0.408
LGA    T   101_A      N      94          0.503
LGA    S   102_A      N      95          1.345
LGA    R   103_A      P      96          2.074
LGA    D   104_A      Q      97          0.815
LGA    R   105_A      L      98          3.270
LGA    H   106_A      L      99          3.991
LGA    V   107_A      R     100          2.583
LGA    V   108_A      F     101          0.340
LGA    X   109_A      Y     102          2.237
LGA    L   110_A      T     103          2.852
LGA    T   111_A      S     104          1.947
LGA    C   112_A      E     105          2.367
LGA    L   113_A      L     106          4.961
LGA    D   114_A      T     107          6.059
LGA    A   115_A      N     108          5.224
LGA    L   116_A      P     109          5.200
LGA    P   117_A      T     110          4.842
LGA    E   118_A      P     111          4.779
LGA    D   119_A      -       -           -
LGA    Q   120_A      C     112          4.463
LGA    R   121_A      F     113          3.074
LGA    K   122_A      A     114          2.248
LGA    A   123_A      A     115          2.897
LGA    L   124_A      I     116          2.887
LGA    -       -      V     117           -
LGA    I   125_A      S     118          1.820
LGA    A   126_A      P     119          2.883
LGA    K   127_A      A     120          3.230
LGA    Q   128_A      I     121          2.207
LGA    R   129_A      A     122          1.346
LGA    E   130_A      S     123          1.447
LGA    L   131_A      V     124          1.741
LGA    I   132_A      I     125          1.191
LGA    A   133_A      R     126          0.459
LGA    Y   134_A      L     127          1.041
LGA    V   135_A      L     128          1.689
LGA    R   136_A      A     129          1.519
LGA    D   137_A      E     130          1.630
LGA    A   138_A      S     131          2.402
LGA    L   139_A      I     132          2.735
LGA    L   140_A      E     133          2.898
LGA    Q   141_A      A     134          3.364
LGA    L   142_A      G     135          3.478
LGA    R   143_A      M     136          3.240
LGA    P   144_A      T     137          3.008
LGA    D   145_A      R     138           #
LGA    -       -      G     139           -
LGA    -       -      L     140           -
LGA    -       -      F     141           -
LGA    -       -      R     142           -
LGA    X   146_A      R     143          2.786
LGA    A   147_A      D     144           -
LGA    A   148_A      -       -           -
LGA    N   149_A      L     145          5.827
LGA    R   150_A      -       -           -
LGA    T   151_A      -       -           -
LGA    L   152_A      H     146          2.633
LGA    A   153_A      A     147          2.240
LGA    H   154_A      V     148          2.456
LGA    V   155_A      N     149          2.149
LGA    D   156_A      S     150          1.849
LGA    T   157_A      A     151          1.983
LGA    X   158_A      L     152          1.823
LGA    L   159_A      A     153          2.084
LGA    F   160_A      L     154          2.078
LGA    F   161_A      A     155          2.055
LGA    G   162_A      G     156          1.789
LGA    X   163_A      M     157          1.569
LGA    I   164_A      V     158          2.030
LGA    N   165_A      N     159          2.225
LGA    W   166_A      Y     160          2.126
LGA    T   167_A      F     161          3.289
LGA    Y   168_A      F     162          3.729
LGA    T   169_A      L     163          2.735
LGA    -       -      S     164           -
LGA    W   170_A      T     165          1.158
LGA    -       -      L     166           -
LGA    -       -      A     167           -
LGA    -       -      T     168           -
LGA    -       -      E     169           -
LGA    -       -      G     170           -
LGA    -       -      L     171           -
LGA    -       -      T     172           -
LGA    -       -      S     173           -
LGA    Y   171_A      H     174          5.171
LGA    K   172_A      -       -           -
LGA    A   173_A      -       -           -
LGA    D   174_A      -       -           -
LGA    G   175_A      -       -           -
LGA    S   176_A      S     175          2.729
LGA    V   177_A      P     176          4.388
LGA    S   178_A      D     177          3.710
LGA    -       -      Q     178           -
LGA    P   179_A      D     179          3.631
LGA    D   180_A      E     180          3.531
LGA    A   181_A      E     181          3.391
LGA    L   182_A      L     182          2.744
LGA    A   183_A      I     183          2.820
LGA    E   184_A      R     184          2.984
LGA    R   185_A      Q     185          2.499
LGA    T   186_A      Y     186          2.104
LGA    V   187_A      V     187          1.890
LGA    Q   188_A      A     188          2.127
LGA    L   189_A      I     189          2.121
LGA    F   190_A      F     190          1.809
LGA    L   191_A      T     191          1.758
LGA    D   192_A      R     192          2.130
LGA    G   193_A      G     193          2.067
LGA    Y   194_A      I     194          2.642
LGA    L   195_A      M     195          3.444
LGA    N   196_A      A     196          4.551
LGA    L   197_A      -       -           -
LGA    L   198_A      -       -           -
LGA    S   199_A      -       -           -
LGA    A   200_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  192  192    5.0    170    2.78    15.88     55.012     5.905

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.271581 * X  +   0.862690 * Y  +  -0.426626 * Z  + -36.262043
  Y_new =   0.036937 * X  +  -0.433617 * Y  +  -0.900340 * Z  +  53.639412
  Z_new =  -0.961707 * X  +  -0.260273 * Y  +   0.085897 * Z  +  -2.578774 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.252027    1.889566  [ DEG:   -71.7358    108.2642 ]
  Theta =   1.293162    1.848430  [ DEG:    74.0927    105.9073 ]
  Phi   =   3.006413   -0.135179  [ DEG:   172.2548     -7.7452 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3ccy_A                                        
REMARK     2: T0454.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3ccy_A.T0454.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  192  192   5.0  170   2.78   15.88  55.012
REMARK  ---------------------------------------------------------- 
MOLECULE 3ccy_A
HEADER    TRANSCRIPTION REGULATOR                 26-FEB-08   3CCY              
TITLE     CRYSTAL STRUCTURE OF A TETR-FAMILY TRANSCRIPTIONAL                    
TITLE    2 REGULATOR FROM BORDETELLA PARAPERTUSSIS 12822                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PUTATIVE TETR-FAMILY TRANSCRIPTIONAL REGULATOR;            
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BORDETELLA PARAPERTUSSIS 12822;                 
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: 12822 / NCTC 13253;                                          
SOURCE   5 ATCC: BAA-587;                                                       
SOURCE   6 GENE: BPP2833;                                                       
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    APC88698, TETR, BORDETELLA PARAPERTUSSIS 12822, STRUCTURAL            
KEYWDS   2 GENOMICS, PSI-2, PROTEIN STRUCTURE INITIATIVE, MIDWEST               
KEYWDS   3 CENTER FOR STRUCTURAL GENOMICS, MCSG, DNA-BINDING,                   
KEYWDS   4 TRANSCRIPTION, TRANSCRIPTION REGULATION, TRANSCRIPTION               
KEYWDS   5 REGULATOR                                                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.TAN,H.LI,S.CLANCY,A.JOACHIMIAK,MIDWEST CENTER FOR                   
AUTHOR   2 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   1   18-MAR-08 3CCY    0                                                
JRNL        AUTH   K.TAN,H.LI,S.CLANCY,A.JOACHIMIAK                             
JRNL        TITL   THE CRYSTAL STRUCTURE OF A TETR-FAMILY                       
JRNL        TITL 2 TRANSCRIPTIONAL REGULATOR FROM BORDETELLA                    
JRNL        TITL 3 PARAPERTUSSIS 12822.                                         
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.01 ANGSTROMS.                                          
DBREF  3CCY A    1   200  UNP    Q7W6R8   Q7W6R8_BORPA     1    200             
SEQRES   1 A  203  SER ASN ALA MSE ALA ARG THR ARG SER ALA ASP TYR GLU          
SEQRES   2 A  203  ASN ILE ARG ASP THR ILE ILE GLU ARG ALA ALA ALA MSE          
SEQRES   3 A  203  PHE ALA ARG GLN GLY TYR SER GLU THR SER ILE GLY ASP          
SEQRES   4 A  203  ILE ALA ARG ALA CYS GLU CYS SER LYS SER ARG LEU TYR          
SEQRES   5 A  203  HIS TYR PHE ASP SER LYS GLU ALA VAL LEU ARG ASP MSE          
SEQRES   6 A  203  LEU THR THR HIS VAL ASP SER LEU LEU GLU ARG CYS ARG          
SEQRES   7 A  203  GLN VAL LEU TYR GLY SER ASN GLU PRO LYS THR ARG PHE          
SEQRES   8 A  203  LEU GLN ILE VAL LYS LEU PHE LEU GLU ILE TYR ALA THR          
SEQRES   9 A  203  SER ARG ASP ARG HIS VAL VAL MSE LEU THR CYS LEU ASP          
SEQRES  10 A  203  ALA LEU PRO GLU ASP GLN ARG LYS ALA LEU ILE ALA LYS          
SEQRES  11 A  203  GLN ARG GLU LEU ILE ALA TYR VAL ARG ASP ALA LEU LEU          
SEQRES  12 A  203  GLN LEU ARG PRO ASP MSE ALA ALA ASN ARG THR LEU ALA          
SEQRES  13 A  203  HIS VAL ASP THR MSE LEU PHE PHE GLY MSE ILE ASN TRP          
SEQRES  14 A  203  THR TYR THR TRP TYR LYS ALA ASP GLY SER VAL SER PRO          
SEQRES  15 A  203  ASP ALA LEU ALA GLU ARG THR VAL GLN LEU PHE LEU ASP          
SEQRES  16 A  203  GLY TYR LEU ASN LEU LEU SER ALA                              
HET    MSE  A  23       8                                                       
HET    MSE  A  62       8                                                       
HET    MSE  A 109      13                                                       
HET    MSE  A 146       8                                                       
HET    MSE  A 158       8                                                       
HET    MSE  A 163       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    6(C5 H11 N O2 SE)                                            
FORMUL   2  HOH   *115(H2 O)                                                    
CRYST1   56.920   56.989  168.271  90.00  90.00  90.00 I 2 2 2       8          
ATOM      1  N   TYR A   9     -14.330  30.997  -7.018  1.00 67.50           N  
ATOM      2  CA  TYR A   9     -13.958  30.567  -5.637  1.00 67.48           C  
ATOM      3  C   TYR A   9     -15.154  29.929  -4.923  1.00 67.37           C  
ATOM      4  O   TYR A   9     -16.028  30.627  -4.394  1.00 67.37           O  
ATOM      5  CB  TYR A   9     -13.421  31.754  -4.839  1.00 67.50           C  
ATOM      6  CG  TYR A   9     -12.185  31.429  -4.045  1.00 67.72           C  
ATOM      7  CD1 TYR A   9     -12.276  30.902  -2.758  1.00 67.71           C  
ATOM      8  CD2 TYR A   9     -10.916  31.648  -4.585  1.00 68.02           C  
ATOM      9  CE1 TYR A   9     -11.128  30.604  -2.024  1.00 67.84           C  
ATOM     10  CE2 TYR A   9      -9.766  31.353  -3.862  1.00 67.89           C  
ATOM     11  CZ  TYR A   9      -9.879  30.830  -2.584  1.00 67.71           C  
ATOM     12  OH  TYR A   9      -8.743  30.536  -1.864  1.00 67.67           O  
ATOM     13  N   GLU A  10     -15.162  28.597  -4.897  1.00 67.13           N  
ATOM     14  CA  GLU A  10     -16.332  27.795  -4.510  1.00 66.68           C  
ATOM     15  C   GLU A  10     -16.630  27.726  -3.001  1.00 66.15           C  
ATOM     16  O   GLU A  10     -17.449  26.913  -2.574  1.00 66.21           O  
ATOM     17  CB  GLU A  10     -16.175  26.371  -5.064  1.00 66.88           C  
ATOM     18  CG  GLU A  10     -17.485  25.679  -5.453  1.00 67.53           C  
ATOM     19  CD  GLU A  10     -17.754  25.719  -6.949  1.00 67.97           C  
ATOM     20  OE1 GLU A  10     -17.413  26.732  -7.599  1.00 68.11           O  
ATOM     21  OE2 GLU A  10     -18.302  24.727  -7.474  1.00 67.94           O  
ATOM     22  N   ASN A  11     -15.972  28.565  -2.203  1.00 65.48           N  
ATOM     23  CA  ASN A  11     -16.145  28.553  -0.744  1.00 64.60           C  
ATOM     24  C   ASN A  11     -17.020  29.728  -0.291  1.00 63.83           C  
ATOM     25  O   ASN A  11     -18.106  29.538   0.267  1.00 63.48           O  
ATOM     26  CB  ASN A  11     -14.787  28.605  -0.006  1.00 64.72           C  
ATOM     27  CG  ASN A  11     -13.645  27.915  -0.770  1.00 64.99           C  
ATOM     28  OD1 ASN A  11     -12.503  28.376  -0.729  1.00 65.24           O  
ATOM     29  ND2 ASN A  11     -13.946  26.808  -1.446  1.00 65.15           N  
ATOM     30  N   ILE A  12     -16.513  30.936  -0.547  1.00 62.81           N  
ATOM     31  CA  ILE A  12     -17.201  32.206  -0.285  1.00 61.77           C  
ATOM     32  C   ILE A  12     -18.475  32.371  -1.134  1.00 60.92           C  
ATOM     33  O   ILE A  12     -19.433  33.017  -0.698  1.00 60.65           O  
ATOM     34  CB  ILE A  12     -16.218  33.398  -0.491  1.00 61.87           C  
ATOM     35  CG1 ILE A  12     -16.951  34.737  -0.671  1.00 61.80           C  
ATOM     36  CG2 ILE A  12     -15.272  33.113  -1.650  1.00 62.11           C  
ATOM     37  CD1 ILE A  12     -17.428  35.381   0.630  1.00 62.03           C  
ATOM     38  N   ARG A  13     -18.461  31.790  -2.337  1.00 59.86           N  
ATOM     39  CA  ARG A  13     -19.640  31.671  -3.203  1.00 58.86           C  
ATOM     40  C   ARG A  13     -20.882  31.217  -2.441  1.00 57.89           C  
ATOM     41  O   ARG A  13     -21.911  31.895  -2.458  1.00 57.62           O  
ATOM     42  CB  ARG A  13     -19.368  30.670  -4.334  1.00 59.05           C  
ATOM     43  CG  ARG A  13     -19.119  31.265  -5.710  1.00 59.40           C  
ATOM     44  CD  ARG A  13     -20.403  31.819  -6.310  1.00 60.13           C  
ATOM     45  NE  ARG A  13     -20.613  31.384  -7.688  1.00 60.69           N  
ATOM     46  CZ  ARG A  13     -21.577  30.549  -8.069  1.00 61.34           C  
ATOM     47  NH1 ARG A  13     -22.434  30.057  -7.183  1.00 60.92           N  
ATOM     48  NH2 ARG A  13     -21.693  30.206  -9.345  1.00 62.25           N  
ATOM     49  N   ASP A  14     -20.759  30.076  -1.763  1.00 56.74           N  
ATOM     50  CA  ASP A  14     -21.883  29.424  -1.095  1.00 56.00           C  
ATOM     51  C   ASP A  14     -22.315  30.134   0.181  1.00 54.65           C  
ATOM     52  O   ASP A  14     -23.441  29.949   0.629  1.00 54.72           O  
ATOM     53  CB  ASP A  14     -21.555  27.961  -0.774  1.00 56.54           C  
ATOM     54  CG  ASP A  14     -20.461  27.394  -1.665  1.00 58.27           C  
ATOM     55  OD1 ASP A  14     -20.586  27.470  -2.916  1.00 59.21           O  
ATOM     56  OD2 ASP A  14     -19.466  26.879  -1.098  1.00 59.85           O  
ATOM     57  N   THR A  15     -21.425  30.926   0.770  1.00 52.92           N  
ATOM     58  CA  THR A  15     -21.784  31.732   1.935  1.00 51.28           C  
ATOM     59  C   THR A  15     -22.781  32.814   1.519  1.00 49.91           C  
ATOM     60  O   THR A  15     -23.786  33.031   2.194  1.00 49.59           O  
ATOM     61  CB  THR A  15     -20.547  32.371   2.600  1.00 51.49           C  
ATOM     62  OG1 THR A  15     -19.496  31.402   2.682  1.00 51.66           O  
ATOM     63  CG2 THR A  15     -20.884  32.882   4.003  1.00 51.23           C  
ATOM     64  N   ILE A  16     -22.492  33.479   0.399  1.00 48.22           N  
ATOM     65  CA  ILE A  16     -23.395  34.469  -0.190  1.00 46.48           C  
ATOM     66  C   ILE A  16     -24.754  33.821  -0.450  1.00 45.49           C  
ATOM     67  O   ILE A  16     -25.774  34.301   0.040  1.00 45.14           O  
ATOM     68  CB  ILE A  16     -22.812  35.074  -1.499  1.00 46.18           C  
ATOM     69  CG1 ILE A  16     -21.452  35.727  -1.225  1.00 45.96           C  
ATOM     70  CG2 ILE A  16     -23.781  36.086  -2.113  1.00 45.47           C  
ATOM     71  CD1 ILE A  16     -20.509  35.683  -2.396  1.00 44.49           C  
ATOM     72  N   ILE A  17     -24.741  32.716  -1.192  1.00 44.50           N  
ATOM     73  CA  ILE A  17     -25.937  31.935  -1.490  1.00 43.84           C  
ATOM     74  C   ILE A  17     -26.675  31.522  -0.214  1.00 43.65           C  
ATOM     75  O   ILE A  17     -27.891  31.686  -0.124  1.00 42.85           O  
ATOM     76  CB  ILE A  17     -25.600  30.680  -2.355  1.00 43.72           C  
ATOM     77  CG1 ILE A  17     -25.136  31.090  -3.757  1.00 43.53           C  
ATOM     78  CG2 ILE A  17     -26.798  29.734  -2.451  1.00 43.87           C  
ATOM     79  CD1 ILE A  17     -26.264  31.571  -4.670  1.00 44.80           C  
ATOM     80  N   GLU A  18     -25.925  31.002   0.763  1.00 43.40           N  
ATOM     81  CA  GLU A  18     -26.462  30.548   2.050  1.00 43.33           C  
ATOM     82  C   GLU A  18     -27.125  31.697   2.808  1.00 42.07           C  
ATOM     83  O   GLU A  18     -28.244  31.560   3.311  1.00 41.72           O  
ATOM     84  CB  GLU A  18     -25.333  29.947   2.907  1.00 43.52           C  
ATOM     85  CG  GLU A  18     -25.785  29.074   4.100  1.00 44.98           C  
ATOM     86  CD  GLU A  18     -24.606  28.393   4.835  1.00 45.70           C  
ATOM     87  OE1 GLU A  18     -24.845  27.344   5.490  1.00 49.09           O  
ATOM     88  OE2 GLU A  18     -23.452  28.895   4.759  1.00 46.38           O  
ATOM     89  N   ARG A  19     -26.429  32.831   2.869  1.00 40.87           N  
ATOM     90  CA  ARG A  19     -26.885  33.981   3.645  1.00 39.71           C  
ATOM     91  C   ARG A  19     -28.056  34.708   2.958  1.00 38.48           C  
ATOM     92  O   ARG A  19     -28.997  35.147   3.631  1.00 38.24           O  
ATOM     93  CB  ARG A  19     -25.710  34.927   3.955  1.00 40.28           C  
ATOM     94  CG  ARG A  19     -25.593  35.291   5.432  1.00 41.62           C  
ATOM     95  CD  ARG A  19     -24.651  34.358   6.202  1.00 44.98           C  
ATOM     96  NE  ARG A  19     -23.350  34.991   6.460  1.00 47.56           N  
ATOM     97  CZ  ARG A  19     -22.335  34.427   7.118  1.00 47.76           C  
ATOM     98  NH1 ARG A  19     -22.441  33.193   7.605  1.00 48.33           N  
ATOM     99  NH2 ARG A  19     -21.206  35.100   7.285  1.00 46.20           N  
ATOM    100  N   ALA A  20     -27.999  34.804   1.627  1.00 36.91           N  
ATOM    101  CA  ALA A  20     -29.092  35.351   0.811  1.00 35.67           C  
ATOM    102  C   ALA A  20     -30.372  34.523   0.913  1.00 35.10           C  
ATOM    103  O   ALA A  20     -31.470  35.078   1.052  1.00 34.31           O  
ATOM    104  CB  ALA A  20     -28.672  35.443  -0.638  1.00 35.96           C  
ATOM    105  N   ALA A  21     -30.224  33.205   0.819  1.00 33.98           N  
ATOM    106  CA  ALA A  21     -31.360  32.289   0.955  1.00 33.98           C  
ATOM    107  C   ALA A  21     -32.099  32.559   2.260  1.00 34.05           C  
ATOM    108  O   ALA A  21     -33.321  32.682   2.268  1.00 34.30           O  
ATOM    109  CB  ALA A  21     -30.893  30.849   0.882  1.00 33.27           C  
ATOM    110  N   ALA A  22     -31.356  32.686   3.357  1.00 34.66           N  
ATOM    111  CA  ALA A  22     -31.977  32.969   4.651  1.00 35.94           C  
ATOM    112  C   ALA A  22     -32.790  34.278   4.656  1.00 36.56           C  
ATOM    113  O   ALA A  22     -33.917  34.313   5.144  1.00 37.08           O  
ATOM    114  CB  ALA A  22     -30.941  32.954   5.768  1.00 35.70           C  
HETATM  115  N   MSE A  23     -32.242  35.343   4.084  1.00 37.24           N  
HETATM  116  CA  MSE A  23     -32.970  36.611   4.050  1.00 38.13           C  
HETATM  117  C   MSE A  23     -34.180  36.620   3.116  1.00 38.95           C  
HETATM  118  O   MSE A  23     -35.250  37.106   3.497  1.00 39.13           O  
HETATM  119  CB  MSE A  23     -32.029  37.761   3.742  1.00 38.04           C  
HETATM  120  CG  MSE A  23     -31.291  38.229   4.982  1.00 38.12           C  
HETATM  121 SE   MSE A  23     -30.071  39.678   4.654  0.50 38.46          SE  
HETATM  122  CE  MSE A  23     -28.683  38.668   3.727  1.00 38.20           C  
ATOM    123  N   PHE A  24     -34.014  36.073   1.909  1.00 39.65           N  
ATOM    124  CA  PHE A  24     -35.113  35.962   0.945  1.00 40.72           C  
ATOM    125  C   PHE A  24     -36.296  35.182   1.527  1.00 42.08           C  
ATOM    126  O   PHE A  24     -37.450  35.399   1.127  1.00 42.30           O  
ATOM    127  CB  PHE A  24     -34.660  35.259  -0.344  1.00 40.37           C  
ATOM    128  CG  PHE A  24     -33.643  36.025  -1.171  1.00 39.53           C  
ATOM    129  CD1 PHE A  24     -33.390  37.374  -0.960  1.00 38.93           C  
ATOM    130  CD2 PHE A  24     -32.977  35.377  -2.206  1.00 39.45           C  
ATOM    131  CE1 PHE A  24     -32.460  38.057  -1.742  1.00 39.13           C  
ATOM    132  CE2 PHE A  24     -32.050  36.047  -2.994  1.00 37.47           C  
ATOM    133  CZ  PHE A  24     -31.791  37.395  -2.760  1.00 39.45           C  
ATOM    134  N   ALA A  25     -35.993  34.248   2.434  1.00 43.41           N  
ATOM    135  CA  ALA A  25     -37.002  33.381   3.061  1.00 44.90           C  
ATOM    136  C   ALA A  25     -37.680  33.981   4.307  1.00 46.22           C  
ATOM    137  O   ALA A  25     -38.815  33.610   4.606  1.00 47.19           O  
ATOM    138  CB  ALA A  25     -36.423  31.985   3.368  1.00 44.11           C  
ATOM    139  N   ARG A  26     -37.008  34.889   5.029  1.00 47.51           N  
ATOM    140  CA  ARG A  26     -37.679  35.652   6.103  1.00 48.78           C  
ATOM    141  C   ARG A  26     -38.464  36.833   5.511  1.00 48.88           C  
ATOM    142  O   ARG A  26     -39.686  36.748   5.375  1.00 49.12           O  
ATOM    143  CB  ARG A  26     -36.720  36.173   7.191  1.00 49.45           C  
ATOM    144  CG  ARG A  26     -35.598  35.251   7.642  1.00 51.89           C  
ATOM    145  CD  ARG A  26     -36.098  33.980   8.323  1.00 56.03           C  
ATOM    146  NE  ARG A  26     -34.994  33.043   8.552  1.00 58.89           N  
ATOM    147  CZ  ARG A  26     -34.546  32.168   7.651  1.00 59.90           C  
ATOM    148  NH1 ARG A  26     -35.112  32.091   6.451  1.00 60.20           N  
ATOM    149  NH2 ARG A  26     -33.532  31.360   7.952  1.00 60.69           N  
ATOM    150  N   GLN A  27     -37.759  37.915   5.150  1.00 48.81           N  
ATOM    151  CA  GLN A  27     -38.395  39.150   4.650  1.00 48.72           C  
ATOM    152  C   GLN A  27     -38.772  39.148   3.170  1.00 48.75           C  
ATOM    153  O   GLN A  27     -39.614  39.950   2.747  1.00 48.82           O  
ATOM    154  CB  GLN A  27     -37.559  40.402   4.958  1.00 48.82           C  
ATOM    155  CG  GLN A  27     -36.123  40.374   4.465  1.00 49.23           C  
ATOM    156  CD  GLN A  27     -35.131  40.098   5.587  1.00 51.05           C  
ATOM    157  OE1 GLN A  27     -35.302  39.157   6.374  1.00 52.22           O  
ATOM    158  NE2 GLN A  27     -34.090  40.920   5.667  1.00 50.46           N  
ATOM    159  N   GLY A  28     -38.151  38.264   2.387  1.00 48.56           N  
ATOM    160  CA  GLY A  28     -38.451  38.158   0.959  1.00 48.13           C  
ATOM    161  C   GLY A  28     -37.420  38.806   0.054  1.00 47.97           C  
ATOM    162  O   GLY A  28     -36.465  39.444   0.516  1.00 47.65           O  
ATOM    163  N   TYR A  29     -37.639  38.657  -1.248  1.00 48.01           N  
ATOM    164  CA  TYR A  29     -36.690  39.119  -2.255  1.00 48.20           C  
ATOM    165  C   TYR A  29     -36.610  40.645  -2.389  1.00 48.24           C  
ATOM    166  O   TYR A  29     -35.529  41.218  -2.243  1.00 48.19           O  
ATOM    167  CB  TYR A  29     -36.980  38.455  -3.610  1.00 48.39           C  
ATOM    168  CG  TYR A  29     -36.003  38.830  -4.703  1.00 48.73           C  
ATOM    169  CD1 TYR A  29     -34.819  38.110  -4.889  1.00 48.58           C  
ATOM    170  CD2 TYR A  29     -36.258  39.909  -5.550  1.00 48.98           C  
ATOM    171  CE1 TYR A  29     -33.921  38.452  -5.894  1.00 48.49           C  
ATOM    172  CE2 TYR A  29     -35.366  40.260  -6.553  1.00 48.84           C  
ATOM    173  CZ  TYR A  29     -34.201  39.531  -6.720  1.00 48.55           C  
ATOM    174  OH  TYR A  29     -33.320  39.888  -7.716  1.00 48.60           O  
ATOM    175  N   SER A  30     -37.738  41.300  -2.665  1.00 48.23           N  
ATOM    176  CA  SER A  30     -37.752  42.764  -2.842  1.00 48.37           C  
ATOM    177  C   SER A  30     -37.349  43.496  -1.567  1.00 47.88           C  
ATOM    178  O   SER A  30     -36.798  44.593  -1.628  1.00 47.94           O  
ATOM    179  CB  SER A  30     -39.121  43.255  -3.317  1.00 48.49           C  
ATOM    180  OG  SER A  30     -40.123  42.947  -2.364  1.00 49.43           O  
ATOM    181  N   GLU A  31     -37.623  42.873  -0.421  1.00 47.43           N  
ATOM    182  CA  GLU A  31     -37.264  43.422   0.884  1.00 47.11           C  
ATOM    183  C   GLU A  31     -35.753  43.382   1.152  1.00 46.35           C  
ATOM    184  O   GLU A  31     -35.213  44.269   1.817  1.00 46.28           O  
ATOM    185  CB  GLU A  31     -38.028  42.688   1.992  1.00 47.68           C  
ATOM    186  CG  GLU A  31     -39.499  43.096   2.121  1.00 49.29           C  
ATOM    187  CD  GLU A  31     -39.698  44.354   2.976  1.00 51.27           C  
ATOM    188  OE1 GLU A  31     -39.752  45.477   2.412  1.00 51.40           O  
ATOM    189  OE2 GLU A  31     -39.797  44.215   4.220  1.00 51.97           O  
ATOM    190  N   THR A  32     -35.086  42.361   0.615  1.00 45.47           N  
ATOM    191  CA  THR A  32     -33.646  42.135   0.800  1.00 44.59           C  
ATOM    192  C   THR A  32     -32.837  42.815  -0.310  1.00 44.39           C  
ATOM    193  O   THR A  32     -33.043  42.543  -1.489  1.00 44.30           O  
ATOM    194  CB  THR A  32     -33.322  40.608   0.794  1.00 44.29           C  
ATOM    195  OG1 THR A  32     -34.166  39.928   1.729  1.00 43.62           O  
ATOM    196  CG2 THR A  32     -31.855  40.341   1.129  1.00 43.60           C  
ATOM    197  N   SER A  33     -31.914  43.697   0.066  1.00 44.11           N  
ATOM    198  CA  SER A  33     -31.063  44.364  -0.917  1.00 43.71           C  
ATOM    199  C   SER A  33     -29.686  43.702  -1.013  1.00 43.81           C  
ATOM    200  O   SER A  33     -29.320  42.879  -0.175  1.00 43.87           O  
ATOM    201  CB  SER A  33     -30.924  45.857  -0.589  1.00 43.70           C  
ATOM    202  OG  SER A  33     -30.197  46.054   0.613  1.00 42.23           O  
ATOM    203  N   ILE A  34     -28.935  44.070  -2.047  1.00 43.83           N  
ATOM    204  CA  ILE A  34     -27.550  43.633  -2.236  1.00 43.83           C  
ATOM    205  C   ILE A  34     -26.658  44.117  -1.087  1.00 43.75           C  
ATOM    206  O   ILE A  34     -25.723  43.423  -0.685  1.00 43.65           O  
ATOM    207  CB  ILE A  34     -26.999  44.139  -3.603  1.00 43.93           C  
ATOM    208  CG1 ILE A  34     -28.021  43.759  -4.748  1.00 44.22           C  
ATOM    209  CG2 ILE A  34     -25.550  43.545  -3.898  1.00 43.48           C  
ATOM    210  CD1 ILE A  34     -28.209  45.035  -5.732  1.00 44.31           C  
ATOM    211  N   GLY A  35     -26.956  45.310  -0.569  1.00 43.80           N  
ATOM    212  CA  GLY A  35     -26.262  45.855   0.596  1.00 43.71           C  
ATOM    213  C   GLY A  35     -26.476  44.999   1.833  1.00 43.82           C  
ATOM    214  O   GLY A  35     -25.522  44.715   2.566  1.00 44.08           O  
ATOM    215  N   ASP A  36     -27.727  44.599   2.060  1.00 43.55           N  
ATOM    216  CA  ASP A  36     -28.097  43.671   3.142  1.00 43.50           C  
ATOM    217  C   ASP A  36     -27.264  42.381   3.110  1.00 43.36           C  
ATOM    218  O   ASP A  36     -26.769  41.927   4.146  1.00 43.27           O  
ATOM    219  CB  ASP A  36     -29.586  43.308   3.047  1.00 43.64           C  
ATOM    220  CG  ASP A  36     -30.507  44.470   3.384  1.00 43.83           C  
ATOM    221  OD1 ASP A  36     -30.101  45.360   4.157  1.00 46.07           O  
ATOM    222  OD2 ASP A  36     -31.656  44.480   2.886  1.00 44.51           O  
ATOM    223  N   ILE A  37     -27.117  41.801   1.913  1.00 43.24           N  
ATOM    224  CA  ILE A  37     -26.292  40.604   1.703  1.00 43.21           C  
ATOM    225  C   ILE A  37     -24.804  40.887   1.974  1.00 43.66           C  
ATOM    226  O   ILE A  37     -24.174  40.021   2.687  1.00 43.82           O  
ATOM    227  CB  ILE A  37     -26.513  40.026   0.280  1.00 43.01           C  
ATOM    228  CG1 ILE A  37     -28.010  39.640   0.069  1.00 42.84           C  
ATOM    229  CG2 ILE A  37     -25.576  38.778   0.023  1.00 42.42           C  
ATOM    230  CD1 ILE A  37     -28.401  39.705  -1.458  1.00 42.75           C  
ATOM    231  N   ALA A  38     -24.305  42.019   1.423  1.00 44.34           N  
ATOM    232  CA  ALA A  38     -22.905  42.355   1.578  1.00 44.74           C  
ATOM    233  C   ALA A  38     -22.485  42.294   3.042  1.00 45.14           C  
ATOM    234  O   ALA A  38     -21.468  41.649   3.384  1.00 44.95           O  
ATOM    235  CB  ALA A  38     -22.623  43.738   0.939  1.00 44.70           C  
ATOM    236  N   ARG A  39     -23.331  42.915   3.908  1.00 45.80           N  
ATOM    237  CA  ARG A  39     -23.049  43.012   5.336  1.00 46.74           C  
ATOM    238  C   ARG A  39     -23.510  41.799   6.161  1.00 47.18           C  
ATOM    239  O   ARG A  39     -23.154  41.684   7.335  1.00 47.08           O  
ATOM    240  CB  ARG A  39     -23.620  44.312   5.903  1.00 46.66           C  
ATOM    241  CG  ARG A  39     -22.903  45.592   5.413  1.00 47.54           C  
ATOM    242  CD  ARG A  39     -23.771  46.832   5.623  1.00 47.29           C  
ATOM    243  NE  ARG A  39     -25.146  46.632   5.143  1.00 49.72           N  
ATOM    244  CZ  ARG A  39     -26.177  46.256   5.905  1.00 49.57           C  
ATOM    245  NH1 ARG A  39     -26.016  46.045   7.209  1.00 49.65           N  
ATOM    246  NH2 ARG A  39     -27.380  46.095   5.363  1.00 49.68           N  
ATOM    247  N   ALA A  40     -24.287  40.894   5.560  1.00 47.83           N  
ATOM    248  CA  ALA A  40     -24.620  39.636   6.233  1.00 48.56           C  
ATOM    249  C   ALA A  40     -23.441  38.665   6.168  1.00 49.21           C  
ATOM    250  O   ALA A  40     -23.254  37.842   7.071  1.00 49.42           O  
ATOM    251  CB  ALA A  40     -25.873  39.002   5.644  1.00 48.41           C  
ATOM    252  N   CYS A  41     -22.650  38.769   5.100  1.00 49.85           N  
ATOM    253  CA  CYS A  41     -21.417  38.002   4.969  1.00 50.82           C  
ATOM    254  C   CYS A  41     -20.281  38.797   5.595  1.00 51.55           C  
ATOM    255  O   CYS A  41     -19.100  38.533   5.335  1.00 51.28           O  
ATOM    256  CB  CYS A  41     -21.123  37.717   3.498  1.00 50.68           C  
ATOM    257  SG  CYS A  41     -22.475  36.861   2.653  1.00 52.41           S  
ATOM    258  N   GLU A  42     -20.666  39.767   6.429  1.00 52.47           N  
ATOM    259  CA  GLU A  42     -19.756  40.736   7.031  1.00 53.66           C  
ATOM    260  C   GLU A  42     -18.730  41.148   5.983  1.00 54.07           C  
ATOM    261  O   GLU A  42     -17.535  40.883   6.131  1.00 54.24           O  
ATOM    262  CB  GLU A  42     -19.098  40.156   8.296  1.00 53.72           C  
ATOM    263  CG  GLU A  42     -20.088  39.903   9.444  1.00 54.46           C  
ATOM    264  CD  GLU A  42     -19.667  38.769  10.371  1.00 55.12           C  
ATOM    265  OE1 GLU A  42     -20.422  37.773  10.476  1.00 55.42           O  
ATOM    266  OE2 GLU A  42     -18.585  38.872  10.990  1.00 54.97           O  
ATOM    267  N   CYS A  43     -19.223  41.769   4.907  1.00 54.85           N  
ATOM    268  CA  CYS A  43     -18.388  42.116   3.748  1.00 55.08           C  
ATOM    269  C   CYS A  43     -18.775  43.449   3.056  1.00 55.03           C  
ATOM    270  O   CYS A  43     -19.855  44.067   3.350  1.00 55.19           O  
ATOM    271  CB  CYS A  43     -18.409  40.959   2.730  1.00 55.28           C  
ATOM    272  SG  CYS A  43     -16.937  40.915   1.685  1.00 55.70           S  
ATOM    273  N   SER A  44     -17.882  43.880   2.131  1.00 54.78           N  
ATOM    274  CA  SER A  44     -18.154  45.071   1.331  1.00 54.69           C  
ATOM    275  C   SER A  44     -19.029  44.719   0.129  1.00 54.56           C  
ATOM    276  O   SER A  44     -18.983  43.588  -0.364  1.00 54.74           O  
ATOM    277  CB  SER A  44     -16.847  45.725   0.871  1.00 54.58           C  
ATOM    278  OG  SER A  44     -16.071  44.825   0.100  1.00 54.37           O  
ATOM    279  N   LYS A  45     -19.819  45.690  -0.336  1.00 54.37           N  
ATOM    280  CA  LYS A  45     -20.722  45.498  -1.482  1.00 54.24           C  
ATOM    281  C   LYS A  45     -19.978  45.129  -2.777  1.00 53.99           C  
ATOM    282  O   LYS A  45     -20.552  44.487  -3.662  1.00 54.29           O  
ATOM    283  CB  LYS A  45     -21.602  46.737  -1.702  1.00 54.22           C  
ATOM    284  CG  LYS A  45     -22.965  46.436  -2.384  1.00 54.65           C  
ATOM    285  CD  LYS A  45     -23.549  47.707  -3.046  1.00 54.34           C  
ATOM    286  CE  LYS A  45     -24.602  48.384  -2.127  1.00 54.72           C  
ATOM    287  NZ  LYS A  45     -23.982  49.173  -0.926  1.00 54.79           N  
ATOM    288  N   SER A  46     -18.705  45.525  -2.871  1.00 53.71           N  
ATOM    289  CA  SER A  46     -17.855  45.229  -4.036  1.00 53.26           C  
ATOM    290  C   SER A  46     -17.690  43.709  -4.266  1.00 52.78           C  
ATOM    291  O   SER A  46     -17.905  43.256  -5.423  1.00 52.84           O  
ATOM    292  CB  SER A  46     -16.472  45.887  -3.873  1.00 53.20           C  
ATOM    293  OG  SER A  46     -16.576  47.183  -3.290  1.00 53.52           O  
ATOM    294  N   ARG A  47     -17.266  43.039  -3.144  1.00 52.11           N  
ATOM    295  CA  ARG A  47     -16.833  41.646  -3.229  1.00 51.65           C  
ATOM    296  C   ARG A  47     -17.925  40.648  -3.648  1.00 51.19           C  
ATOM    297  O   ARG A  47     -17.621  39.511  -4.017  1.00 51.24           O  
ATOM    298  CB  ARG A  47     -16.170  41.221  -1.916  1.00 51.71           C  
ATOM    299  CG  ARG A  47     -14.929  42.043  -1.564  1.00 52.61           C  
ATOM    300  CD  ARG A  47     -14.031  41.345  -0.544  1.00 53.99           C  
ATOM    301  NE  ARG A  47     -13.442  40.110  -1.076  1.00 54.43           N  
ATOM    302  CZ  ARG A  47     -13.889  38.881  -0.807  1.00 53.92           C  
ATOM    303  NH1 ARG A  47     -13.288  37.822  -1.343  1.00 53.71           N  
ATOM    304  NH2 ARG A  47     -14.933  38.705  -0.003  1.00 53.65           N  
ATOM    305  N   LEU A  48     -19.188  41.070  -3.597  1.00 50.47           N  
ATOM    306  CA  LEU A  48     -20.297  40.235  -4.083  1.00 49.87           C  
ATOM    307  C   LEU A  48     -20.271  40.056  -5.594  1.00 49.44           C  
ATOM    308  O   LEU A  48     -20.578  38.974  -6.103  1.00 49.01           O  
ATOM    309  CB  LEU A  48     -21.648  40.822  -3.679  1.00 49.90           C  
ATOM    310  CG  LEU A  48     -22.370  40.193  -2.493  1.00 49.90           C  
ATOM    311  CD1 LEU A  48     -21.652  40.521  -1.192  1.00 50.43           C  
ATOM    312  CD2 LEU A  48     -23.793  40.704  -2.470  1.00 50.04           C  
ATOM    313  N   TYR A  49     -19.874  41.111  -6.297  1.00 48.95           N  
ATOM    314  CA  TYR A  49     -19.912  41.119  -7.746  1.00 48.56           C  
ATOM    315  C   TYR A  49     -18.767  40.376  -8.362  1.00 48.81           C  
ATOM    316  O   TYR A  49     -18.741  40.177  -9.552  1.00 48.93           O  
ATOM    317  CB  TYR A  49     -19.992  42.528  -8.292  1.00 48.24           C  
ATOM    318  CG  TYR A  49     -21.227  43.260  -7.884  1.00 47.34           C  
ATOM    319  CD1 TYR A  49     -21.288  43.916  -6.709  1.00 46.68           C  
ATOM    320  CD2 TYR A  49     -22.332  43.290  -8.688  1.00 47.32           C  
ATOM    321  CE1 TYR A  49     -22.408  44.574  -6.342  1.00 45.96           C  
ATOM    322  CE2 TYR A  49     -23.447  43.941  -8.320  1.00 46.97           C  
ATOM    323  CZ  TYR A  49     -23.478  44.581  -7.150  1.00 46.64           C  
ATOM    324  OH  TYR A  49     -24.595  45.234  -6.780  1.00 47.07           O  
ATOM    325  N   HIS A  50     -17.835  39.955  -7.530  1.00 49.01           N  
ATOM    326  CA  HIS A  50     -16.739  39.055  -7.898  1.00 49.20           C  
ATOM    327  C   HIS A  50     -17.290  37.663  -8.228  1.00 49.03           C  
ATOM    328  O   HIS A  50     -16.657  36.894  -8.954  1.00 49.20           O  
ATOM    329  CB  HIS A  50     -15.718  38.977  -6.752  1.00 49.33           C  
ATOM    330  CG  HIS A  50     -14.405  38.360  -7.134  1.00 50.18           C  
ATOM    331  ND1 HIS A  50     -13.315  39.109  -7.535  1.00 50.96           N  
ATOM    332  CD2 HIS A  50     -13.996  37.067  -7.147  1.00 50.51           C  
ATOM    333  CE1 HIS A  50     -12.300  38.303  -7.796  1.00 50.96           C  
ATOM    334  NE2 HIS A  50     -12.686  37.059  -7.565  1.00 50.79           N  
ATOM    335  N   TYR A  51     -18.481  37.362  -7.708  1.00 48.73           N  
ATOM    336  CA  TYR A  51     -19.113  36.053  -7.901  1.00 48.27           C  
ATOM    337  C   TYR A  51     -20.456  36.132  -8.618  1.00 47.65           C  
ATOM    338  O   TYR A  51     -20.858  35.171  -9.282  1.00 47.82           O  
ATOM    339  CB  TYR A  51     -19.276  35.332  -6.559  1.00 48.65           C  
ATOM    340  CG  TYR A  51     -18.035  35.371  -5.697  1.00 49.09           C  
ATOM    341  CD1 TYR A  51     -16.997  34.452  -5.886  1.00 49.43           C  
ATOM    342  CD2 TYR A  51     -17.889  36.332  -4.701  1.00 49.72           C  
ATOM    343  CE1 TYR A  51     -15.850  34.491  -5.097  1.00 49.51           C  
ATOM    344  CE2 TYR A  51     -16.745  36.383  -3.909  1.00 50.07           C  
ATOM    345  CZ  TYR A  51     -15.731  35.462  -4.112  1.00 49.80           C  
ATOM    346  OH  TYR A  51     -14.599  35.520  -3.324  1.00 50.03           O  
ATOM    347  N   PHE A  52     -21.147  37.263  -8.481  1.00 46.86           N  
ATOM    348  CA  PHE A  52     -22.492  37.433  -9.048  1.00 46.25           C  
ATOM    349  C   PHE A  52     -22.692  38.786  -9.721  1.00 45.93           C  
ATOM    350  O   PHE A  52     -22.228  39.815  -9.219  1.00 45.89           O  
ATOM    351  CB  PHE A  52     -23.561  37.262  -7.965  1.00 45.93           C  
ATOM    352  CG  PHE A  52     -23.578  35.901  -7.330  1.00 45.80           C  
ATOM    353  CD1 PHE A  52     -23.042  35.709  -6.060  1.00 45.24           C  
ATOM    354  CD2 PHE A  52     -24.149  34.811  -7.992  1.00 45.23           C  
ATOM    355  CE1 PHE A  52     -23.061  34.450  -5.459  1.00 44.99           C  
ATOM    356  CE2 PHE A  52     -24.169  33.553  -7.405  1.00 44.90           C  
ATOM    357  CZ  PHE A  52     -23.626  33.372  -6.136  1.00 45.09           C  
ATOM    358  N   ASP A  53     -23.415  38.784 -10.841  1.00 45.67           N  
ATOM    359  CA  ASP A  53     -23.640  40.014 -11.617  1.00 45.34           C  
ATOM    360  C   ASP A  53     -24.832  40.830 -11.118  1.00 44.64           C  
ATOM    361  O   ASP A  53     -24.948  42.019 -11.407  1.00 44.73           O  
ATOM    362  CB  ASP A  53     -23.838  39.693 -13.104  1.00 45.63           C  
ATOM    363  CG  ASP A  53     -22.602  39.082 -13.751  1.00 46.55           C  
ATOM    364  OD1 ASP A  53     -22.788  38.267 -14.687  1.00 47.43           O  
ATOM    365  OD2 ASP A  53     -21.461  39.411 -13.337  1.00 47.51           O  
ATOM    366  N   SER A  54     -25.719  40.186 -10.375  1.00 43.86           N  
ATOM    367  CA  SER A  54     -26.956  40.819  -9.959  1.00 43.10           C  
ATOM    368  C   SER A  54     -27.545  40.102  -8.748  1.00 42.64           C  
ATOM    369  O   SER A  54     -27.130  38.995  -8.400  1.00 42.47           O  
ATOM    370  CB  SER A  54     -27.953  40.819 -11.131  1.00 43.09           C  
ATOM    371  OG  SER A  54     -29.258  41.220 -10.730  1.00 43.75           O  
ATOM    372  N   LYS A  55     -28.501  40.765  -8.108  1.00 41.91           N  
ATOM    373  CA  LYS A  55     -29.349  40.178  -7.090  1.00 41.17           C  
ATOM    374  C   LYS A  55     -30.139  39.018  -7.717  1.00 40.89           C  
ATOM    375  O   LYS A  55     -30.336  37.974  -7.083  1.00 40.80           O  
ATOM    376  CB  LYS A  55     -30.277  41.269  -6.553  1.00 41.24           C  
ATOM    377  CG  LYS A  55     -31.069  40.943  -5.306  1.00 40.87           C  
ATOM    378  CD  LYS A  55     -32.005  42.114  -4.994  1.00 40.94           C  
ATOM    379  CE  LYS A  55     -33.235  41.646  -4.229  1.00 41.64           C  
ATOM    380  NZ  LYS A  55     -34.287  42.707  -4.029  1.00 40.54           N  
ATOM    381  N   GLU A  56     -30.565  39.200  -8.971  1.00 40.23           N  
ATOM    382  CA  GLU A  56     -31.283  38.158  -9.724  1.00 39.45           C  
ATOM    383  C   GLU A  56     -30.407  36.945  -9.997  1.00 38.06           C  
ATOM    384  O   GLU A  56     -30.900  35.819  -9.998  1.00 37.83           O  
ATOM    385  CB  GLU A  56     -31.824  38.700 -11.051  1.00 39.75           C  
ATOM    386  CG  GLU A  56     -32.791  39.865 -10.910  1.00 40.53           C  
ATOM    387  CD  GLU A  56     -33.329  40.352 -12.246  1.00 41.22           C  
ATOM    388  OE1 GLU A  56     -32.519  40.735 -13.128  1.00 43.07           O  
ATOM    389  OE2 GLU A  56     -34.571  40.367 -12.408  1.00 44.26           O  
ATOM    390  N   ALA A  57     -29.115  37.185 -10.226  1.00 36.47           N  
ATOM    391  CA  ALA A  57     -28.135  36.121 -10.450  1.00 35.38           C  
ATOM    392  C   ALA A  57     -27.978  35.240  -9.206  1.00 34.94           C  
ATOM    393  O   ALA A  57     -27.919  34.011  -9.312  1.00 34.80           O  
ATOM    394  CB  ALA A  57     -26.785  36.712 -10.870  1.00 35.17           C  
ATOM    395  N   VAL A  58     -27.916  35.875  -8.033  1.00 33.96           N  
ATOM    396  CA  VAL A  58     -27.904  35.154  -6.754  1.00 32.47           C  
ATOM    397  C   VAL A  58     -29.147  34.277  -6.636  1.00 31.96           C  
ATOM    398  O   VAL A  58     -29.035  33.099  -6.340  1.00 31.20           O  
ATOM    399  CB  VAL A  58     -27.791  36.113  -5.543  1.00 32.41           C  
ATOM    400  CG1 VAL A  58     -27.775  35.332  -4.234  1.00 32.07           C  
ATOM    401  CG2 VAL A  58     -26.533  36.973  -5.658  1.00 31.84           C  
ATOM    402  N   LEU A  59     -30.317  34.853  -6.905  1.00 31.57           N  
ATOM    403  CA  LEU A  59     -31.565  34.108  -6.866  1.00 31.57           C  
ATOM    404  C   LEU A  59     -31.625  32.988  -7.909  1.00 32.25           C  
ATOM    405  O   LEU A  59     -32.003  31.862  -7.586  1.00 31.44           O  
ATOM    406  CB  LEU A  59     -32.787  35.039  -7.002  1.00 31.39           C  
ATOM    407  CG  LEU A  59     -34.192  34.410  -7.003  1.00 31.29           C  
ATOM    408  CD1 LEU A  59     -34.512  33.670  -5.707  1.00 31.23           C  
ATOM    409  CD2 LEU A  59     -35.279  35.417  -7.275  1.00 30.97           C  
ATOM    410  N   ARG A  60     -31.265  33.299  -9.150  1.00 32.82           N  
ATOM    411  CA  ARG A  60     -31.372  32.336 -10.238  1.00 34.52           C  
ATOM    412  C   ARG A  60     -30.502  31.119  -9.939  1.00 34.33           C  
ATOM    413  O   ARG A  60     -30.955  29.986 -10.090  1.00 34.40           O  
ATOM    414  CB  ARG A  60     -31.015  32.975 -11.592  1.00 34.28           C  
ATOM    415  CG  ARG A  60     -31.131  32.025 -12.798  1.00 35.68           C  
ATOM    416  CD  ARG A  60     -30.598  32.646 -14.090  1.00 36.46           C  
ATOM    417  NE  ARG A  60     -29.180  33.011 -14.018  1.00 41.85           N  
ATOM    418  CZ  ARG A  60     -28.697  34.257 -14.103  1.00 43.07           C  
ATOM    419  NH1 ARG A  60     -27.387  34.463 -14.033  1.00 43.52           N  
ATOM    420  NH2 ARG A  60     -29.506  35.303 -14.257  1.00 43.95           N  
ATOM    421  N   ASP A  61     -29.277  31.367  -9.479  1.00 34.33           N  
ATOM    422  CA  ASP A  61     -28.349  30.294  -9.116  1.00 34.91           C  
ATOM    423  C   ASP A  61     -28.858  29.386  -7.985  1.00 34.08           C  
ATOM    424  O   ASP A  61     -28.870  28.156  -8.138  1.00 34.60           O  
ATOM    425  CB  ASP A  61     -26.955  30.873  -8.816  1.00 35.57           C  
ATOM    426  CG  ASP A  61     -25.944  29.814  -8.403  1.00 38.52           C  
ATOM    427  OD1 ASP A  61     -25.043  29.515  -9.212  1.00 42.74           O  
ATOM    428  OD2 ASP A  61     -26.037  29.289  -7.267  1.00 42.65           O  
HETATM  429  N   MSE A  62     -29.322  29.953  -6.873  1.00 33.32           N  
HETATM  430  CA  MSE A  62     -29.799  29.090  -5.772  1.00 31.59           C  
HETATM  431  C   MSE A  62     -31.054  28.289  -6.127  1.00 32.37           C  
HETATM  432  O   MSE A  62     -31.258  27.185  -5.616  1.00 32.15           O  
HETATM  433  CB  MSE A  62     -30.036  29.878  -4.477  1.00 32.10           C  
HETATM  434  CG  MSE A  62     -31.384  30.536  -4.399  1.00 30.36           C  
HETATM  435 SE   MSE A  62     -31.735  31.511  -2.769  0.70 29.57          SE  
HETATM  436  CE  MSE A  62     -30.195  32.659  -2.690  1.00 27.16           C  
ATOM    437  N   LEU A  63     -31.901  28.857  -6.973  1.00 31.37           N  
ATOM    438  CA  LEU A  63     -33.082  28.161  -7.423  1.00 31.96           C  
ATOM    439  C   LEU A  63     -32.709  27.040  -8.386  1.00 31.17           C  
ATOM    440  O   LEU A  63     -33.262  25.955  -8.333  1.00 29.52           O  
ATOM    441  CB  LEU A  63     -34.050  29.144  -8.074  1.00 32.03           C  
ATOM    442  CG  LEU A  63     -34.705  30.137  -7.100  1.00 34.58           C  
ATOM    443  CD1 LEU A  63     -35.926  30.791  -7.729  1.00 35.04           C  
ATOM    444  CD2 LEU A  63     -35.097  29.444  -5.789  1.00 36.29           C  
ATOM    445  N   THR A  64     -31.747  27.318  -9.250  1.00 31.61           N  
ATOM    446  CA  THR A  64     -31.331  26.349 -10.261  1.00 33.44           C  
ATOM    447  C   THR A  64     -30.666  25.130  -9.619  1.00 33.07           C  
ATOM    448  O   THR A  64     -31.007  23.982  -9.933  1.00 33.38           O  
ATOM    449  CB  THR A  64     -30.401  27.002 -11.305  1.00 32.88           C  
ATOM    450  OG1 THR A  64     -31.123  28.026 -11.998  1.00 34.02           O  
ATOM    451  CG2 THR A  64     -29.909  25.993 -12.315  1.00 35.32           C  
ATOM    452  N   THR A  65     -29.730  25.372  -8.713  1.00 33.70           N  
ATOM    453  CA  THR A  65     -29.024  24.267  -8.108  1.00 34.48           C  
ATOM    454  C   THR A  65     -29.988  23.470  -7.232  1.00 34.77           C  
ATOM    455  O   THR A  65     -29.895  22.255  -7.160  1.00 35.94           O  
ATOM    456  CB  THR A  65     -27.751  24.697  -7.337  1.00 34.92           C  
ATOM    457  OG1 THR A  65     -28.111  25.277  -6.077  1.00 37.20           O  
ATOM    458  CG2 THR A  65     -26.912  25.682  -8.165  1.00 33.84           C  
ATOM    459  N   HIS A  66     -30.943  24.147  -6.607  1.00 34.09           N  
ATOM    460  CA  HIS A  66     -31.882  23.466  -5.754  1.00 33.96           C  
ATOM    461  C   HIS A  66     -32.866  22.543  -6.500  1.00 33.63           C  
ATOM    462  O   HIS A  66     -33.122  21.410  -6.046  1.00 34.03           O  
ATOM    463  CB  HIS A  66     -32.675  24.475  -4.931  1.00 34.54           C  
ATOM    464  CG  HIS A  66     -33.617  23.835  -3.974  1.00 34.99           C  
ATOM    465  ND1 HIS A  66     -33.197  23.290  -2.783  1.00 36.32           N  
ATOM    466  CD2 HIS A  66     -34.956  23.641  -4.031  1.00 35.14           C  
ATOM    467  CE1 HIS A  66     -34.240  22.792  -2.145  1.00 35.19           C  
ATOM    468  NE2 HIS A  66     -35.312  22.980  -2.887  1.00 34.32           N  
ATOM    469  N   VAL A  67     -33.462  23.030  -7.585  1.00 32.23           N  
ATOM    470  CA  VAL A  67     -34.377  22.191  -8.373  1.00 32.38           C  
ATOM    471  C   VAL A  67     -33.584  21.105  -9.115  1.00 32.70           C  
ATOM    472  O   VAL A  67     -34.055  19.975  -9.214  1.00 31.39           O  
ATOM    473  CB  VAL A  67     -35.340  22.995  -9.317  1.00 32.54           C  
ATOM    474  CG1 VAL A  67     -34.636  23.578 -10.507  1.00 30.51           C  
ATOM    475  CG2 VAL A  67     -36.554  22.111  -9.775  1.00 32.87           C  
ATOM    476  N   ASP A  68     -32.362  21.427  -9.574  1.00 33.47           N  
ATOM    477  CA  ASP A  68     -31.517  20.421 -10.218  1.00 35.08           C  
ATOM    478  C   ASP A  68     -31.222  19.275  -9.246  1.00 36.03           C  
ATOM    479  O   ASP A  68     -31.308  18.115  -9.611  1.00 36.61           O  
ATOM    480  CB  ASP A  68     -30.208  21.027 -10.773  1.00 34.69           C  
ATOM    481  CG  ASP A  68     -30.414  21.761 -12.091  1.00 34.57           C  
ATOM    482  OD1 ASP A  68     -31.510  21.673 -12.678  1.00 34.77           O  
ATOM    483  OD2 ASP A  68     -29.476  22.445 -12.549  1.00 36.65           O  
ATOM    484  N   SER A  69     -30.926  19.608  -8.000  1.00 37.45           N  
ATOM    485  CA  SER A  69     -30.660  18.589  -6.970  1.00 38.34           C  
ATOM    486  C   SER A  69     -31.883  17.706  -6.696  1.00 38.31           C  
ATOM    487  O   SER A  69     -31.776  16.470  -6.615  1.00 37.37           O  
ATOM    488  CB  SER A  69     -30.211  19.262  -5.684  1.00 39.22           C  
ATOM    489  OG  SER A  69     -29.318  18.435  -4.974  1.00 42.52           O  
ATOM    490  N   LEU A  70     -33.043  18.344  -6.555  1.00 37.70           N  
ATOM    491  CA  LEU A  70     -34.268  17.644  -6.284  1.00 37.77           C  
ATOM    492  C   LEU A  70     -34.579  16.654  -7.433  1.00 37.09           C  
ATOM    493  O   LEU A  70     -34.952  15.499  -7.193  1.00 35.50           O  
ATOM    494  CB  LEU A  70     -35.385  18.672  -6.113  1.00 38.03           C  
ATOM    495  CG  LEU A  70     -36.659  18.355  -5.354  1.00 41.12           C  
ATOM    496  CD1 LEU A  70     -36.474  17.363  -4.201  1.00 42.32           C  
ATOM    497  CD2 LEU A  70     -37.279  19.685  -4.856  1.00 40.24           C  
ATOM    498  N   LEU A  71     -34.423  17.122  -8.675  1.00 36.19           N  
ATOM    499  CA  LEU A  71     -34.643  16.286  -9.852  1.00 36.68           C  
ATOM    500  C   LEU A  71     -33.715  15.076  -9.900  1.00 36.62           C  
ATOM    501  O   LEU A  71     -34.167  13.980 -10.178  1.00 36.31           O  
ATOM    502  CB  LEU A  71     -34.523  17.108 -11.157  1.00 37.04           C  
ATOM    503  CG  LEU A  71     -35.735  18.018 -11.474  1.00 37.59           C  
ATOM    504  CD1 LEU A  71     -35.393  18.957 -12.632  1.00 37.30           C  
ATOM    505  CD2 LEU A  71     -37.021  17.230 -11.817  1.00 37.21           C  
ATOM    506  N   GLU A  72     -32.431  15.266  -9.615  1.00 37.54           N  
ATOM    507  CA  GLU A  72     -31.492  14.155  -9.671  1.00 38.04           C  
ATOM    508  C   GLU A  72     -31.830  13.150  -8.586  1.00 36.28           C  
ATOM    509  O   GLU A  72     -31.880  11.961  -8.862  1.00 36.72           O  
ATOM    510  CB  GLU A  72     -30.037  14.596  -9.538  1.00 38.23           C  
ATOM    511  CG  GLU A  72     -29.013  13.790 -10.394  1.00 43.55           C  
ATOM    512  CD  GLU A  72     -29.559  12.532 -11.174  1.00 50.18           C  
ATOM    513  OE1 GLU A  72     -29.608  11.415 -10.576  1.00 50.36           O  
ATOM    514  OE2 GLU A  72     -29.876  12.660 -12.406  1.00 49.37           O  
ATOM    515  N   ARG A  73     -32.122  13.625  -7.377  1.00 35.03           N  
ATOM    516  CA  ARG A  73     -32.398  12.702  -6.291  0.50 33.97           C  
ATOM    518  C   ARG A  73     -33.679  11.916  -6.495  1.00 33.45           C  
ATOM    519  O   ARG A  73     -33.723  10.735  -6.156  1.00 33.09           O  
ATOM    520  CB  ARG A  73     -32.251  13.390  -4.941  0.50 33.87           C  
ATOM    522  CG  ARG A  73     -30.772  13.811  -4.764  0.50 34.41           C  
ATOM    524  CD  ARG A  73     -30.498  14.614  -3.540  0.50 35.49           C  
ATOM    526  NE  ARG A  73     -30.678  13.814  -2.337  0.50 35.03           N  
ATOM    528  CZ  ARG A  73     -30.850  14.325  -1.127  0.50 31.43           C  
ATOM    530  NH1 ARG A  73     -30.833  15.639  -0.963  0.50 31.16           N  
ATOM    532  NH2 ARG A  73     -31.064  13.518  -0.098  0.50 29.22           N  
ATOM    534  N   CYS A  74     -34.689  12.560  -7.086  1.00 32.71           N  
ATOM    535  CA  CYS A  74     -35.914  11.882  -7.485  0.50 32.97           C  
ATOM    537  C   CYS A  74     -35.667  10.764  -8.485  1.00 33.27           C  
ATOM    538  O   CYS A  74     -36.290   9.703  -8.416  1.00 33.37           O  
ATOM    539  CB  CYS A  74     -36.859  12.875  -8.141  0.50 32.67           C  
ATOM    541  SG  CYS A  74     -38.577  12.385  -8.061  0.40 30.81           S  
ATOM    543  N   ARG A  75     -34.809  11.025  -9.453  1.00 34.41           N  
ATOM    544  CA  ARG A  75     -34.462  10.016 -10.433  1.00 36.18           C  
ATOM    545  C   ARG A  75     -33.826   8.800  -9.771  1.00 35.49           C  
ATOM    546  O   ARG A  75     -34.192   7.667 -10.103  1.00 34.99           O  
ATOM    547  CB  ARG A  75     -33.524  10.581 -11.513  1.00 35.81           C  
ATOM    548  CG  ARG A  75     -34.244  11.492 -12.477  1.00 37.14           C  
ATOM    549  CD  ARG A  75     -33.287  12.068 -13.562  1.00 40.01           C  
ATOM    550  NE  ARG A  75     -33.857  13.357 -13.982  1.00 46.58           N  
ATOM    551  CZ  ARG A  75     -33.235  14.531 -13.847  1.00 47.78           C  
ATOM    552  NH1 ARG A  75     -33.847  15.639 -14.267  1.00 48.22           N  
ATOM    553  NH2 ARG A  75     -31.994  14.594 -13.333  1.00 40.82           N  
ATOM    554  N   GLN A  76     -32.889   9.021  -8.850  1.00 36.27           N  
ATOM    555  CA  GLN A  76     -32.255   7.900  -8.133  1.00 37.46           C  
ATOM    556  C   GLN A  76     -33.303   7.070  -7.394  1.00 36.55           C  
ATOM    557  O   GLN A  76     -33.216   5.858  -7.365  1.00 36.03           O  
ATOM    558  CB  GLN A  76     -31.207   8.361  -7.125  1.00 38.22           C  
ATOM    559  CG  GLN A  76     -30.071   9.200  -7.640  1.00 40.05           C  
ATOM    560  CD  GLN A  76     -29.320   9.900  -6.481  1.00 43.16           C  
ATOM    561  OE1 GLN A  76     -28.837   9.247  -5.539  1.00 49.67           O  
ATOM    562  NE2 GLN A  76     -29.223  11.237  -6.554  1.00 49.76           N  
ATOM    563  N   VAL A  77     -34.278   7.729  -6.775  1.00 36.05           N  
ATOM    564  CA  VAL A  77     -35.388   7.034  -6.151  1.00 35.96           C  
ATOM    565  C   VAL A  77     -36.191   6.241  -7.186  1.00 36.47           C  
ATOM    566  O   VAL A  77     -36.469   5.052  -6.978  1.00 36.03           O  
ATOM    567  CB  VAL A  77     -36.295   8.008  -5.359  1.00 36.08           C  
ATOM    568  CG1 VAL A  77     -37.581   7.340  -4.918  1.00 37.88           C  
ATOM    569  CG2 VAL A  77     -35.568   8.526  -4.108  1.00 36.35           C  
ATOM    570  N   LEU A  78     -36.550   6.899  -8.289  1.00 35.78           N  
ATOM    571  CA  LEU A  78     -37.329   6.260  -9.333  1.00 38.94           C  
ATOM    572  C   LEU A  78     -36.607   5.036  -9.831  1.00 38.60           C  
ATOM    573  O   LEU A  78     -37.209   3.973  -9.867  1.00 39.22           O  
ATOM    574  CB  LEU A  78     -37.664   7.206 -10.509  1.00 38.58           C  
ATOM    575  CG  LEU A  78     -38.761   8.232 -10.269  1.00 42.74           C  
ATOM    576  CD1 LEU A  78     -39.029   8.966 -11.572  1.00 43.57           C  
ATOM    577  CD2 LEU A  78     -40.035   7.574  -9.744  1.00 44.59           C  
ATOM    578  N   TYR A  79     -35.319   5.169 -10.147  1.00 39.35           N  
ATOM    579  CA  TYR A  79     -34.532   4.041 -10.660  1.00 42.12           C  
ATOM    580  C   TYR A  79     -34.155   2.984  -9.613  1.00 43.85           C  
ATOM    581  O   TYR A  79     -33.498   2.010  -9.957  1.00 43.44           O  
ATOM    582  CB  TYR A  79     -33.261   4.513 -11.404  1.00 42.15           C  
ATOM    583  CG  TYR A  79     -33.537   5.471 -12.526  1.00 43.85           C  
ATOM    584  CD1 TYR A  79     -34.790   5.520 -13.115  1.00 42.42           C  
ATOM    585  CD2 TYR A  79     -32.534   6.303 -13.036  1.00 45.41           C  
ATOM    586  CE1 TYR A  79     -35.070   6.383 -14.140  1.00 46.05           C  
ATOM    587  CE2 TYR A  79     -32.811   7.187 -14.087  1.00 46.10           C  
ATOM    588  CZ  TYR A  79     -34.087   7.212 -14.632  1.00 45.93           C  
ATOM    589  OH  TYR A  79     -34.434   8.059 -15.665  1.00 46.59           O  
ATOM    590  N   GLY A  80     -34.576   3.170  -8.357  1.00 45.69           N  
ATOM    591  CA  GLY A  80     -34.241   2.243  -7.281  1.00 49.17           C  
ATOM    592  C   GLY A  80     -35.233   1.107  -7.085  1.00 51.36           C  
ATOM    593  O   GLY A  80     -35.010  -0.010  -7.560  1.00 52.00           O  
ATOM    594  N   SER A  81     -36.336   1.381  -6.387  1.00 53.88           N  
ATOM    595  CA  SER A  81     -37.267   0.305  -5.992  1.00 55.29           C  
ATOM    596  C   SER A  81     -38.013  -0.273  -7.182  1.00 55.92           C  
ATOM    597  O   SER A  81     -38.168   0.375  -8.227  1.00 56.07           O  
ATOM    598  CB  SER A  81     -38.262   0.749  -4.915  1.00 55.71           C  
ATOM    599  OG  SER A  81     -39.063  -0.353  -4.490  1.00 56.70           O  
ATOM    600  N   ASN A  82     -38.450  -1.515  -7.004  1.00 56.37           N  
ATOM    601  CA  ASN A  82     -39.241  -2.217  -7.999  1.00 56.33           C  
ATOM    602  C   ASN A  82     -40.714  -1.804  -7.842  1.00 55.31           C  
ATOM    603  O   ASN A  82     -41.422  -1.608  -8.831  1.00 55.64           O  
ATOM    604  CB  ASN A  82     -39.075  -3.730  -7.804  1.00 56.76           C  
ATOM    605  CG  ASN A  82     -38.912  -4.473  -9.107  1.00 59.23           C  
ATOM    606  OD1 ASN A  82     -39.744  -4.353 -10.021  1.00 61.13           O  
ATOM    607  ND2 ASN A  82     -37.838  -5.272  -9.201  1.00 60.63           N  
ATOM    608  N   GLU A  83     -41.141  -1.645  -6.593  1.00 53.60           N  
ATOM    609  CA  GLU A  83     -42.549  -1.532  -6.253  1.00 52.90           C  
ATOM    610  C   GLU A  83     -43.070  -0.093  -6.332  1.00 50.35           C  
ATOM    611  O   GLU A  83     -42.486   0.804  -5.730  1.00 49.47           O  
ATOM    612  CB  GLU A  83     -42.789  -2.071  -4.839  1.00 52.88           C  
ATOM    613  CG  GLU A  83     -42.401  -3.535  -4.623  1.00 55.87           C  
ATOM    614  CD  GLU A  83     -43.083  -4.143  -3.397  1.00 56.84           C  
ATOM    615  OE1 GLU A  83     -42.383  -4.389  -2.376  1.00 61.31           O  
ATOM    616  OE2 GLU A  83     -44.323  -4.366  -3.451  1.00 60.81           O  
ATOM    617  N   PRO A  84     -44.175   0.130  -7.075  1.00 48.45           N  
ATOM    618  CA  PRO A  84     -44.771   1.475  -7.095  1.00 47.07           C  
ATOM    619  C   PRO A  84     -45.116   2.082  -5.722  1.00 45.89           C  
ATOM    620  O   PRO A  84     -44.918   3.280  -5.543  1.00 45.13           O  
ATOM    621  CB  PRO A  84     -46.019   1.301  -7.974  1.00 46.86           C  
ATOM    622  CG  PRO A  84     -45.670   0.166  -8.884  1.00 46.98           C  
ATOM    623  CD  PRO A  84     -44.886  -0.787  -7.987  1.00 48.17           C  
ATOM    624  N   LYS A  85     -45.627   1.304  -4.762  1.00 44.96           N  
ATOM    625  CA  LYS A  85     -46.046   1.935  -3.496  1.00 44.53           C  
ATOM    626  C   LYS A  85     -44.833   2.420  -2.710  1.00 43.06           C  
ATOM    627  O   LYS A  85     -44.869   3.508  -2.111  1.00 42.62           O  
ATOM    628  CB  LYS A  85     -46.979   1.066  -2.628  1.00 45.09           C  
ATOM    629  CG  LYS A  85     -47.797   1.920  -1.592  1.00 47.43           C  
ATOM    630  CD  LYS A  85     -49.065   1.228  -1.006  1.00 46.58           C  
ATOM    631  CE  LYS A  85     -49.539   1.949   0.283  1.00 48.88           C  
ATOM    632  NZ  LYS A  85     -51.022   1.779   0.654  1.00 48.83           N  
ATOM    633  N   THR A  86     -43.758   1.642  -2.771  1.00 40.97           N  
ATOM    634  CA  THR A  86     -42.499   2.020  -2.127  1.00 40.38           C  
ATOM    635  C   THR A  86     -41.889   3.278  -2.747  1.00 39.01           C  
ATOM    636  O   THR A  86     -41.495   4.172  -2.005  1.00 36.91           O  
ATOM    637  CB  THR A  86     -41.502   0.833  -2.147  1.00 41.28           C  
ATOM    638  OG1 THR A  86     -42.036  -0.210  -1.312  1.00 43.07           O  
ATOM    639  CG2 THR A  86     -40.104   1.233  -1.622  1.00 41.02           C  
ATOM    640  N   ARG A  87     -41.791   3.313  -4.093  1.00 38.12           N  
ATOM    641  CA  ARG A  87     -41.217   4.457  -4.822  1.00 36.50           C  
ATOM    642  C   ARG A  87     -41.936   5.723  -4.451  1.00 34.92           C  
ATOM    643  O   ARG A  87     -41.292   6.752  -4.254  1.00 35.03           O  
ATOM    644  CB  ARG A  87     -41.247   4.255  -6.346  1.00 36.79           C  
ATOM    645  CG  ARG A  87     -40.133   3.284  -6.884  1.00 39.37           C  
ATOM    646  CD  ARG A  87     -39.869   3.429  -8.415  1.00 38.57           C  
ATOM    647  NE  ARG A  87     -41.109   3.331  -9.165  1.00 41.68           N  
ATOM    648  CZ  ARG A  87     -41.620   2.208  -9.670  1.00 38.16           C  
ATOM    649  NH1 ARG A  87     -40.987   1.058  -9.554  1.00 36.34           N  
ATOM    650  NH2 ARG A  87     -42.780   2.260 -10.301  1.00 38.30           N  
ATOM    651  N   PHE A  88     -43.273   5.667  -4.365  1.00 33.97           N  
ATOM    652  CA  PHE A  88     -44.067   6.839  -4.043  1.00 33.20           C  
ATOM    653  C   PHE A  88     -43.723   7.344  -2.638  1.00 33.19           C  
ATOM    654  O   PHE A  88     -43.448   8.534  -2.461  1.00 32.33           O  
ATOM    655  CB  PHE A  88     -45.589   6.611  -4.176  1.00 34.02           C  
ATOM    656  CG  PHE A  88     -46.422   7.835  -3.822  1.00 35.66           C  
ATOM    657  CD1 PHE A  88     -46.374   8.994  -4.603  1.00 38.19           C  
ATOM    658  CD2 PHE A  88     -47.254   7.835  -2.704  1.00 33.38           C  
ATOM    659  CE1 PHE A  88     -47.134  10.128  -4.250  1.00 37.19           C  
ATOM    660  CE2 PHE A  88     -48.001   8.944  -2.336  1.00 36.59           C  
ATOM    661  CZ  PHE A  88     -47.945  10.115  -3.113  1.00 36.40           C  
ATOM    662  N   LEU A  89     -43.736   6.441  -1.655  1.00 33.04           N  
ATOM    663  CA  LEU A  89     -43.416   6.810  -0.259  1.00 33.09           C  
ATOM    664  C   LEU A  89     -41.964   7.360  -0.171  1.00 33.70           C  
ATOM    665  O   LEU A  89     -41.725   8.326   0.533  1.00 32.70           O  
ATOM    666  CB  LEU A  89     -43.579   5.590   0.689  1.00 33.44           C  
ATOM    667  CG  LEU A  89     -43.092   5.816   2.127  1.00 33.00           C  
ATOM    668  CD1 LEU A  89     -43.835   6.970   2.787  1.00 28.62           C  
ATOM    669  CD2 LEU A  89     -43.134   4.530   3.005  1.00 33.60           C  
ATOM    670  N   GLN A  90     -41.030   6.750  -0.908  1.00 32.79           N  
ATOM    671  CA  GLN A  90     -39.653   7.247  -0.937  1.00 34.28           C  
ATOM    672  C   GLN A  90     -39.528   8.660  -1.534  1.00 33.77           C  
ATOM    673  O   GLN A  90     -38.736   9.489  -1.068  1.00 33.37           O  
ATOM    674  CB  GLN A  90     -38.705   6.240  -1.610  1.00 33.05           C  
ATOM    675  CG  GLN A  90     -38.363   5.031  -0.736  1.00 34.78           C  
ATOM    676  CD  GLN A  90     -37.527   3.969  -1.460  1.00 37.41           C  
ATOM    677  OE1 GLN A  90     -36.916   3.098  -0.814  1.00 42.50           O  
ATOM    678  NE2 GLN A  90     -37.481   4.036  -2.787  1.00 40.39           N  
ATOM    679  N   ILE A  91     -40.310   8.949  -2.570  1.00 33.58           N  
ATOM    680  CA  ILE A  91     -40.350  10.292  -3.111  1.00 33.48           C  
ATOM    681  C   ILE A  91     -40.855  11.296  -2.073  1.00 33.23           C  
ATOM    682  O   ILE A  91     -40.285  12.369  -1.914  1.00 32.82           O  
ATOM    683  CB  ILE A  91     -41.273  10.383  -4.386  1.00 34.85           C  
ATOM    684  CG1 ILE A  91     -40.629   9.665  -5.559  1.00 33.99           C  
ATOM    685  CG2 ILE A  91     -41.666  11.875  -4.679  1.00 33.86           C  
ATOM    686  CD1 ILE A  91     -41.628   9.432  -6.728  1.00 37.49           C  
ATOM    687  N   VAL A  92     -41.921  10.968  -1.354  1.00 32.09           N  
ATOM    688  CA  VAL A  92     -42.429  11.935  -0.376  1.00 32.95           C  
ATOM    689  C   VAL A  92     -41.386  12.157   0.772  1.00 31.62           C  
ATOM    690  O   VAL A  92     -41.192  13.265   1.234  1.00 29.67           O  
ATOM    691  CB  VAL A  92     -43.792  11.480   0.215  1.00 31.13           C  
ATOM    692  CG1 VAL A  92     -44.325  12.513   1.272  1.00 33.51           C  
ATOM    693  CG2 VAL A  92     -44.804  11.272  -0.933  1.00 36.30           C  
ATOM    694  N   LYS A  93     -40.751  11.079   1.211  1.00 30.32           N  
ATOM    695  CA  LYS A  93     -39.730  11.138   2.277  1.00 30.66           C  
ATOM    696  C   LYS A  93     -38.569  12.000   1.789  1.00 30.89           C  
ATOM    697  O   LYS A  93     -38.020  12.781   2.554  1.00 30.62           O  
ATOM    698  CB  LYS A  93     -39.203   9.748   2.572  1.00 30.04           C  
ATOM    699  CG  LYS A  93     -40.086   8.906   3.457  1.00 29.62           C  
ATOM    700  CD  LYS A  93     -39.391   7.572   3.851  1.00 31.28           C  
ATOM    701  CE  LYS A  93     -40.380   6.859   4.812  1.00 33.89           C  
ATOM    702  NZ  LYS A  93     -39.825   5.662   5.383  1.00 36.92           N  
ATOM    703  N   LEU A  94     -38.220  11.876   0.509  1.00 31.52           N  
ATOM    704  CA  LEU A  94     -37.155  12.730  -0.071  1.00 32.56           C  
ATOM    705  C   LEU A  94     -37.504  14.224   0.011  1.00 33.15           C  
ATOM    706  O   LEU A  94     -36.667  15.044   0.432  1.00 30.92           O  
ATOM    707  CB  LEU A  94     -36.855  12.337  -1.524  1.00 32.04           C  
ATOM    708  CG  LEU A  94     -36.022  13.286  -2.373  1.00 32.75           C  
ATOM    709  CD1 LEU A  94     -34.589  13.240  -1.843  1.00 29.96           C  
ATOM    710  CD2 LEU A  94     -36.078  12.891  -3.865  1.00 32.40           C  
ATOM    711  N   PHE A  95     -38.725  14.573  -0.400  1.00 34.32           N  
ATOM    712  CA  PHE A  95     -39.113  15.994  -0.405  1.00 36.34           C  
ATOM    713  C   PHE A  95     -39.064  16.576   0.995  1.00 35.97           C  
ATOM    714  O   PHE A  95     -38.570  17.700   1.202  1.00 36.46           O  
ATOM    715  CB  PHE A  95     -40.473  16.238  -1.116  1.00 37.85           C  
ATOM    716  CG  PHE A  95     -40.460  15.906  -2.602  1.00 41.01           C  
ATOM    717  CD1 PHE A  95     -39.287  15.558  -3.246  1.00 46.46           C  
ATOM    718  CD2 PHE A  95     -41.607  15.973  -3.359  1.00 46.89           C  
ATOM    719  CE1 PHE A  95     -39.277  15.262  -4.605  1.00 48.36           C  
ATOM    720  CE2 PHE A  95     -41.595  15.678  -4.737  1.00 45.06           C  
ATOM    721  CZ  PHE A  95     -40.441  15.335  -5.349  1.00 44.45           C  
ATOM    722  N   LEU A  96     -39.524  15.809   1.976  1.00 36.16           N  
ATOM    723  CA  LEU A  96     -39.521  16.287   3.350  1.00 36.28           C  
ATOM    724  C   LEU A  96     -38.144  16.278   3.973  1.00 36.31           C  
ATOM    725  O   LEU A  96     -37.849  17.092   4.842  1.00 36.47           O  
ATOM    726  CB  LEU A  96     -40.562  15.539   4.209  1.00 37.47           C  
ATOM    727  CG  LEU A  96     -42.008  15.851   3.799  1.00 37.99           C  
ATOM    728  CD1 LEU A  96     -42.955  15.112   4.703  1.00 38.92           C  
ATOM    729  CD2 LEU A  96     -42.334  17.364   3.839  1.00 41.33           C  
ATOM    730  N   GLU A  97     -37.278  15.376   3.513  1.00 35.08           N  
ATOM    731  CA  GLU A  97     -35.893  15.386   3.929  1.00 35.45           C  
ATOM    732  C   GLU A  97     -35.198  16.698   3.478  1.00 35.85           C  
ATOM    733  O   GLU A  97     -34.463  17.340   4.255  1.00 35.74           O  
ATOM    734  CB  GLU A  97     -35.178  14.140   3.386  1.00 35.85           C  
ATOM    735  CG  GLU A  97     -33.682  14.094   3.650  1.00 38.08           C  
ATOM    736  CD  GLU A  97     -32.902  13.417   2.530  1.00 42.69           C  
ATOM    737  OE1 GLU A  97     -33.288  12.312   2.050  1.00 45.40           O  
ATOM    738  OE2 GLU A  97     -31.874  13.987   2.129  1.00 44.09           O  
ATOM    739  N   ILE A  98     -35.430  17.066   2.220  1.00 36.00           N  
ATOM    740  CA  ILE A  98     -34.891  18.286   1.638  1.00 37.86           C  
ATOM    741  C   ILE A  98     -35.383  19.563   2.373  1.00 39.26           C  
ATOM    742  O   ILE A  98     -34.608  20.507   2.590  1.00 39.48           O  
ATOM    743  CB  ILE A  98     -35.060  18.255   0.105  1.00 37.21           C  
ATOM    744  CG1 ILE A  98     -34.166  17.119  -0.442  1.00 37.25           C  
ATOM    745  CG2 ILE A  98     -34.717  19.605  -0.529  1.00 37.50           C  
ATOM    746  CD1 ILE A  98     -34.256  16.880  -1.939  1.00 40.70           C  
ATOM    747  N   TYR A  99     -36.627  19.543   2.854  1.00 40.53           N  
ATOM    748  CA  TYR A  99     -37.113  20.546   3.837  1.00 41.36           C  
ATOM    749  C   TYR A  99     -36.350  20.577   5.192  1.00 42.54           C  
ATOM    750  O   TYR A  99     -35.900  21.637   5.671  1.00 42.84           O  
ATOM    751  CB  TYR A  99     -38.598  20.311   4.073  1.00 42.16           C  
ATOM    752  CG  TYR A  99     -39.220  21.298   5.029  1.00 41.65           C  
ATOM    753  CD1 TYR A  99     -39.613  22.579   4.589  1.00 41.07           C  
ATOM    754  CD2 TYR A  99     -39.434  20.949   6.368  1.00 40.98           C  
ATOM    755  CE1 TYR A  99     -40.188  23.493   5.459  1.00 40.53           C  
ATOM    756  CE2 TYR A  99     -40.018  21.855   7.241  1.00 41.67           C  
ATOM    757  CZ  TYR A  99     -40.388  23.126   6.784  1.00 41.47           C  
ATOM    758  OH  TYR A  99     -40.943  24.007   7.654  1.00 38.76           O  
ATOM    759  N   ALA A 100     -36.199  19.413   5.812  1.00 43.03           N  
ATOM    760  CA  ALA A 100     -35.414  19.267   7.022  1.00 43.78           C  
ATOM    761  C   ALA A 100     -33.968  19.783   6.867  1.00 44.21           C  
ATOM    762  O   ALA A 100     -33.383  20.333   7.813  1.00 44.74           O  
ATOM    763  CB  ALA A 100     -35.403  17.785   7.458  1.00 44.05           C  
ATOM    764  N   THR A 101     -33.383  19.600   5.685  1.00 43.99           N  
ATOM    765  CA  THR A 101     -31.990  19.996   5.501  1.00 43.83           C  
ATOM    766  C   THR A 101     -31.871  21.385   4.876  1.00 42.92           C  
ATOM    767  O   THR A 101     -31.071  22.176   5.328  1.00 43.57           O  
ATOM    768  CB  THR A 101     -31.169  18.927   4.735  1.00 44.09           C  
ATOM    769  OG1 THR A 101     -31.759  18.692   3.470  1.00 46.14           O  
ATOM    770  CG2 THR A 101     -31.185  17.623   5.484  1.00 43.79           C  
ATOM    771  N   SER A 102     -32.718  21.683   3.895  1.00 42.12           N  
ATOM    772  CA  SER A 102     -32.582  22.862   3.036  1.00 41.55           C  
ATOM    773  C   SER A 102     -33.803  23.776   3.073  1.00 39.89           C  
ATOM    774  O   SER A 102     -34.243  24.255   2.026  1.00 40.52           O  
ATOM    775  CB  SER A 102     -32.346  22.420   1.581  1.00 41.45           C  
ATOM    776  OG  SER A 102     -30.992  22.086   1.369  1.00 43.22           O  
ATOM    777  N   ARG A 103     -34.330  24.031   4.266  1.00 38.88           N  
ATOM    778  CA  ARG A 103     -35.574  24.793   4.424  1.00 37.62           C  
ATOM    779  C   ARG A 103     -35.574  26.141   3.672  1.00 36.83           C  
ATOM    780  O   ARG A 103     -36.497  26.433   2.885  1.00 35.57           O  
ATOM    781  CB  ARG A 103     -35.897  25.025   5.906  1.00 37.73           C  
ATOM    782  CG  ARG A 103     -37.313  25.609   6.070  1.00 37.50           C  
ATOM    783  CD  ARG A 103     -37.728  25.923   7.513  1.00 38.79           C  
ATOM    784  NE  ARG A 103     -39.091  26.470   7.479  1.00 39.24           N  
ATOM    785  CZ  ARG A 103     -39.361  27.754   7.260  1.00 40.34           C  
ATOM    786  NH1 ARG A 103     -38.374  28.631   7.108  1.00 40.43           N  
ATOM    787  NH2 ARG A 103     -40.615  28.173   7.205  1.00 41.46           N  
ATOM    788  N   ASP A 104     -34.549  26.957   3.925  1.00 34.97           N  
ATOM    789  CA  ASP A 104     -34.437  28.265   3.293  1.00 35.13           C  
ATOM    790  C   ASP A 104     -34.535  28.228   1.769  1.00 34.82           C  
ATOM    791  O   ASP A 104     -35.319  28.967   1.187  1.00 33.25           O  
ATOM    792  CB  ASP A 104     -33.121  28.938   3.689  1.00 34.94           C  
ATOM    793  CG  ASP A 104     -33.112  29.399   5.120  1.00 36.32           C  
ATOM    794  OD1 ASP A 104     -34.206  29.538   5.717  1.00 37.20           O  
ATOM    795  OD2 ASP A 104     -32.000  29.618   5.650  1.00 40.15           O  
ATOM    796  N   ARG A 105     -33.686  27.417   1.132  1.00 35.92           N  
ATOM    797  CA  ARG A 105     -33.679  27.304  -0.336  1.00 38.08           C  
ATOM    798  C   ARG A 105     -35.010  26.709  -0.829  1.00 38.68           C  
ATOM    799  O   ARG A 105     -35.515  27.098  -1.870  1.00 38.50           O  
ATOM    800  CB  ARG A 105     -32.470  26.484  -0.835  1.00 37.82           C  
ATOM    801  CG  ARG A 105     -31.093  27.238  -0.865  1.00 38.96           C  
ATOM    802  CD  ARG A 105     -30.003  26.279  -1.344  1.00 39.79           C  
ATOM    803  NE  ARG A 105     -28.608  26.745  -1.230  1.00 44.78           N  
ATOM    804  CZ  ARG A 105     -27.936  26.913  -0.084  1.00 46.03           C  
ATOM    805  NH1 ARG A 105     -26.676  27.322  -0.100  1.00 45.40           N  
ATOM    806  NH2 ARG A 105     -28.518  26.704   1.087  1.00 48.42           N  
ATOM    807  N   HIS A 106     -35.590  25.801  -0.043  1.00 40.44           N  
ATOM    808  CA  HIS A 106     -36.921  25.218  -0.324  1.00 42.23           C  
ATOM    809  C   HIS A 106     -38.012  26.302  -0.327  1.00 42.07           C  
ATOM    810  O   HIS A 106     -38.732  26.496  -1.311  1.00 41.58           O  
ATOM    811  CB  HIS A 106     -37.212  24.160   0.746  1.00 43.51           C  
ATOM    812  CG  HIS A 106     -38.240  23.138   0.366  1.00 49.04           C  
ATOM    813  ND1 HIS A 106     -39.584  23.289   0.655  1.00 55.52           N  
ATOM    814  CD2 HIS A 106     -38.112  21.926  -0.233  1.00 53.49           C  
ATOM    815  CE1 HIS A 106     -40.238  22.214   0.238  1.00 58.32           C  
ATOM    816  NE2 HIS A 106     -39.368  21.367  -0.296  1.00 56.30           N  
ATOM    817  N   VAL A 107     -38.124  27.033   0.778  1.00 42.02           N  
ATOM    818  CA  VAL A 107     -39.064  28.152   0.862  1.00 41.15           C  
ATOM    819  C   VAL A 107     -38.883  29.102  -0.339  1.00 41.89           C  
ATOM    820  O   VAL A 107     -39.869  29.470  -0.993  1.00 41.32           O  
ATOM    821  CB  VAL A 107     -38.940  28.933   2.208  1.00 40.81           C  
ATOM    822  CG1 VAL A 107     -39.835  30.183   2.213  1.00 39.90           C  
ATOM    823  CG2 VAL A 107     -39.264  28.036   3.387  1.00 39.48           C  
ATOM    824  N   VAL A 108     -37.628  29.460  -0.646  1.00 41.64           N  
ATOM    825  CA  VAL A 108     -37.332  30.377  -1.768  1.00 42.01           C  
ATOM    826  C   VAL A 108     -37.835  29.813  -3.133  1.00 42.71           C  
ATOM    827  O   VAL A 108     -38.362  30.580  -3.955  1.00 41.74           O  
ATOM    828  CB  VAL A 108     -35.825  30.839  -1.788  1.00 41.90           C  
ATOM    829  CG1 VAL A 108     -35.508  31.645  -3.030  1.00 42.14           C  
ATOM    830  CG2 VAL A 108     -35.497  31.704  -0.574  1.00 40.95           C  
HETATM  831  N   MSE A 109     -37.679  28.500  -3.355  1.00 43.40           N  
HETATM  832  CA  MSE A 109     -38.250  27.806  -4.533  0.50 44.32           C  
HETATM  834  C   MSE A 109     -39.763  28.076  -4.563  1.00 46.10           C  
HETATM  835  O   MSE A 109     -40.293  28.687  -5.503  1.00 46.48           O  
HETATM  836  CB  MSE A 109     -37.959  26.271  -4.501  0.50 44.20           C  
HETATM  838  CG  MSE A 109     -38.369  25.441  -5.791  0.50 42.85           C  
HETATM  840 SE   MSE A 109     -37.997  23.463  -5.914  0.35 41.90          SE  
HETATM  842  CE  MSE A 109     -38.925  22.922  -4.282  0.50 38.94           C  
ATOM    844  N   LEU A 110     -40.440  27.622  -3.503  1.00 47.63           N  
ATOM    845  CA  LEU A 110     -41.902  27.711  -3.346  1.00 49.30           C  
ATOM    846  C   LEU A 110     -42.467  29.123  -3.312  1.00 50.14           C  
ATOM    847  O   LEU A 110     -43.679  29.286  -3.337  1.00 51.67           O  
ATOM    848  CB  LEU A 110     -42.353  26.947  -2.086  1.00 48.66           C  
ATOM    849  CG  LEU A 110     -41.970  25.457  -2.041  1.00 50.21           C  
ATOM    850  CD1 LEU A 110     -42.411  24.763  -0.763  1.00 50.19           C  
ATOM    851  CD2 LEU A 110     -42.495  24.684  -3.285  1.00 53.05           C  
ATOM    852  N   THR A 111     -41.613  30.143  -3.284  1.00 51.32           N  
ATOM    853  CA  THR A 111     -42.062  31.500  -2.927  1.00 52.06           C  
ATOM    854  C   THR A 111     -41.558  32.645  -3.812  1.00 52.65           C  
ATOM    855  O   THR A 111     -42.220  33.681  -3.914  1.00 52.57           O  
ATOM    856  CB  THR A 111     -41.726  31.796  -1.420  1.00 52.34           C  
ATOM    857  OG1 THR A 111     -42.798  31.334  -0.585  1.00 52.53           O  
ATOM    858  CG2 THR A 111     -41.461  33.288  -1.148  1.00 52.97           C  
ATOM    859  N   CYS A 112     -40.391  32.471  -4.438  1.00 53.42           N  
ATOM    860  CA  CYS A 112     -39.657  33.610  -5.028  1.00 54.09           C  
ATOM    861  C   CYS A 112     -39.458  33.580  -6.545  1.00 54.23           C  
ATOM    862  O   CYS A 112     -38.847  34.489  -7.109  1.00 53.98           O  
ATOM    863  CB  CYS A 112     -38.296  33.764  -4.352  1.00 54.34           C  
ATOM    864  SG  CYS A 112     -38.321  34.629  -2.784  1.00 55.91           S  
ATOM    865  N   LEU A 113     -39.963  32.537  -7.195  1.00 54.82           N  
ATOM    866  CA  LEU A 113     -39.802  32.368  -8.634  1.00 55.82           C  
ATOM    867  C   LEU A 113     -40.184  33.600  -9.485  1.00 56.31           C  
ATOM    868  O   LEU A 113     -39.561  33.853 -10.518  1.00 56.24           O  
ATOM    869  CB  LEU A 113     -40.553  31.114  -9.099  1.00 55.75           C  
ATOM    870  CG  LEU A 113     -40.287  30.607 -10.516  1.00 56.20           C  
ATOM    871  CD1 LEU A 113     -38.800  30.410 -10.768  1.00 56.73           C  
ATOM    872  CD2 LEU A 113     -41.030  29.320 -10.752  1.00 56.38           C  
ATOM    873  N   ASP A 114     -41.183  34.372  -9.047  1.00 56.95           N  
ATOM    874  CA  ASP A 114     -41.665  35.518  -9.836  1.00 57.68           C  
ATOM    875  C   ASP A 114     -40.690  36.692  -9.881  1.00 57.88           C  
ATOM    876  O   ASP A 114     -40.725  37.501 -10.816  1.00 58.11           O  
ATOM    877  CB  ASP A 114     -43.064  35.984  -9.387  1.00 57.94           C  
ATOM    878  CG  ASP A 114     -43.147  36.275  -7.896  1.00 58.76           C  
ATOM    879  OD1 ASP A 114     -42.798  35.379  -7.086  1.00 58.67           O  
ATOM    880  OD2 ASP A 114     -43.591  37.392  -7.535  1.00 58.39           O  
ATOM    881  N   ALA A 115     -39.814  36.776  -8.880  1.00 57.88           N  
ATOM    882  CA  ALA A 115     -38.833  37.858  -8.803  1.00 57.77           C  
ATOM    883  C   ALA A 115     -37.867  37.859  -9.990  1.00 57.68           C  
ATOM    884  O   ALA A 115     -37.171  38.842 -10.232  1.00 57.58           O  
ATOM    885  CB  ALA A 115     -38.075  37.783  -7.491  1.00 57.85           C  
ATOM    886  N   LEU A 116     -37.843  36.752 -10.728  1.00 57.67           N  
ATOM    887  CA  LEU A 116     -36.980  36.598 -11.900  1.00 57.69           C  
ATOM    888  C   LEU A 116     -37.605  37.202 -13.173  1.00 58.09           C  
ATOM    889  O   LEU A 116     -38.807  37.491 -13.179  1.00 58.10           O  
ATOM    890  CB  LEU A 116     -36.647  35.115 -12.104  1.00 57.33           C  
ATOM    891  CG  LEU A 116     -35.695  34.525 -11.060  1.00 56.75           C  
ATOM    892  CD1 LEU A 116     -35.457  33.058 -11.319  1.00 54.52           C  
ATOM    893  CD2 LEU A 116     -34.365  35.297 -11.026  1.00 55.26           C  
ATOM    894  N   PRO A 117     -36.785  37.431 -14.233  1.00 58.43           N  
ATOM    895  CA  PRO A 117     -37.262  37.807 -15.583  1.00 58.77           C  
ATOM    896  C   PRO A 117     -38.258  36.809 -16.215  1.00 58.97           C  
ATOM    897  O   PRO A 117     -39.135  36.291 -15.520  1.00 59.24           O  
ATOM    898  CB  PRO A 117     -35.968  37.874 -16.411  1.00 58.63           C  
ATOM    899  CG  PRO A 117     -34.896  38.119 -15.426  1.00 58.67           C  
ATOM    900  CD  PRO A 117     -35.309  37.404 -14.174  1.00 58.40           C  
ATOM    901  N   GLU A 118     -38.134  36.555 -17.517  1.00 59.09           N  
ATOM    902  CA  GLU A 118     -39.081  35.673 -18.202  1.00 59.13           C  
ATOM    903  C   GLU A 118     -38.478  34.379 -18.715  1.00 58.80           C  
ATOM    904  O   GLU A 118     -39.056  33.309 -18.526  1.00 58.83           O  
ATOM    905  CB  GLU A 118     -39.834  36.403 -19.321  1.00 59.48           C  
ATOM    906  CG  GLU A 118     -40.999  37.256 -18.818  1.00 60.70           C  
ATOM    907  CD  GLU A 118     -41.824  36.559 -17.737  1.00 62.15           C  
ATOM    908  OE1 GLU A 118     -41.751  36.996 -16.565  1.00 62.42           O  
ATOM    909  OE2 GLU A 118     -42.531  35.572 -18.054  1.00 62.28           O  
ATOM    910  N   ASP A 119     -37.321  34.480 -19.363  1.00 58.29           N  
ATOM    911  CA  ASP A 119     -36.643  33.308 -19.920  1.00 57.76           C  
ATOM    912  C   ASP A 119     -36.180  32.310 -18.843  1.00 57.05           C  
ATOM    913  O   ASP A 119     -36.352  31.094 -18.997  1.00 56.93           O  
ATOM    914  CB  ASP A 119     -35.474  33.727 -20.834  1.00 58.10           C  
ATOM    915  CG  ASP A 119     -34.628  34.861 -20.247  1.00 59.09           C  
ATOM    916  OD1 ASP A 119     -35.069  36.035 -20.300  1.00 60.11           O  
ATOM    917  OD2 ASP A 119     -33.510  34.581 -19.752  1.00 59.61           O  
ATOM    918  N   GLN A 120     -35.604  32.828 -17.758  1.00 55.95           N  
ATOM    919  CA  GLN A 120     -35.069  31.971 -16.697  1.00 54.85           C  
ATOM    920  C   GLN A 120     -36.171  31.495 -15.763  1.00 53.60           C  
ATOM    921  O   GLN A 120     -36.084  30.407 -15.193  1.00 53.14           O  
ATOM    922  CB  GLN A 120     -33.910  32.646 -15.938  1.00 55.26           C  
ATOM    923  CG  GLN A 120     -34.197  34.045 -15.396  1.00 55.80           C  
ATOM    924  CD  GLN A 120     -32.963  34.930 -15.370  1.00 56.27           C  
ATOM    925  OE1 GLN A 120     -32.360  35.144 -14.319  1.00 56.03           O  
ATOM    926  NE2 GLN A 120     -32.582  35.452 -16.532  1.00 57.35           N  
ATOM    927  N   ARG A 121     -37.214  32.311 -15.625  1.00 52.20           N  
ATOM    928  CA  ARG A 121     -38.404  31.924 -14.881  1.00 50.91           C  
ATOM    929  C   ARG A 121     -38.970  30.668 -15.524  1.00 50.07           C  
ATOM    930  O   ARG A 121     -39.282  29.703 -14.836  1.00 50.00           O  
ATOM    931  CB  ARG A 121     -39.442  33.031 -14.943  1.00 51.02           C  
ATOM    932  CG  ARG A 121     -40.344  33.147 -13.761  1.00 51.35           C  
ATOM    933  CD  ARG A 121     -41.585  33.895 -14.167  1.00 54.08           C  
ATOM    934  NE  ARG A 121     -41.898  34.991 -13.257  1.00 56.83           N  
ATOM    935  CZ  ARG A 121     -42.772  35.961 -13.521  1.00 59.88           C  
ATOM    936  NH1 ARG A 121     -42.992  36.921 -12.627  1.00 60.97           N  
ATOM    937  NH2 ARG A 121     -43.427  35.987 -14.682  1.00 61.14           N  
ATOM    938  N   LYS A 122     -39.066  30.683 -16.850  1.00 49.00           N  
ATOM    939  CA  LYS A 122     -39.692  29.591 -17.584  1.00 48.01           C  
ATOM    940  C   LYS A 122     -38.810  28.361 -17.744  1.00 46.44           C  
ATOM    941  O   LYS A 122     -39.325  27.248 -17.865  1.00 45.77           O  
ATOM    942  CB  LYS A 122     -40.212  30.074 -18.936  1.00 48.27           C  
ATOM    943  CG  LYS A 122     -41.486  30.912 -18.822  1.00 50.23           C  
ATOM    944  CD  LYS A 122     -41.890  31.487 -20.166  1.00 52.76           C  
ATOM    945  CE  LYS A 122     -43.240  32.204 -20.083  1.00 54.04           C  
ATOM    946  NZ  LYS A 122     -43.490  32.951 -21.346  1.00 53.94           N  
ATOM    947  N   ALA A 123     -37.493  28.559 -17.765  1.00 44.60           N  
ATOM    948  CA  ALA A 123     -36.559  27.442 -17.642  1.00 43.08           C  
ATOM    949  C   ALA A 123     -36.752  26.727 -16.295  1.00 42.12           C  
ATOM    950  O   ALA A 123     -36.735  25.499 -16.236  1.00 41.74           O  
ATOM    951  CB  ALA A 123     -35.129  27.921 -17.791  1.00 43.16           C  
ATOM    952  N   LEU A 124     -36.941  27.504 -15.227  1.00 41.03           N  
ATOM    953  CA  LEU A 124     -37.166  26.949 -13.882  1.00 39.89           C  
ATOM    954  C   LEU A 124     -38.573  26.407 -13.718  1.00 39.15           C  
ATOM    955  O   LEU A 124     -38.761  25.391 -13.070  1.00 37.81           O  
ATOM    956  CB  LEU A 124     -36.847  27.973 -12.786  1.00 39.89           C  
ATOM    957  CG  LEU A 124     -35.350  28.266 -12.619  1.00 40.64           C  
ATOM    958  CD1 LEU A 124     -35.135  29.626 -11.995  1.00 40.65           C  
ATOM    959  CD2 LEU A 124     -34.684  27.176 -11.785  1.00 41.13           C  
ATOM    960  N   ILE A 125     -39.559  27.080 -14.315  1.00 38.61           N  
ATOM    961  CA  ILE A 125     -40.923  26.553 -14.335  1.00 38.85           C  
ATOM    962  C   ILE A 125     -40.935  25.195 -15.061  1.00 37.67           C  
ATOM    963  O   ILE A 125     -41.685  24.293 -14.682  1.00 37.73           O  
ATOM    964  CB  ILE A 125     -41.932  27.527 -15.018  1.00 39.11           C  
ATOM    965  CG1 ILE A 125     -42.216  28.717 -14.090  1.00 41.18           C  
ATOM    966  CG2 ILE A 125     -43.282  26.814 -15.287  1.00 40.05           C  
ATOM    967  CD1 ILE A 125     -42.890  29.920 -14.783  1.00 39.78           C  
ATOM    968  N   ALA A 126     -40.123  25.069 -16.110  1.00 36.12           N  
ATOM    969  CA  ALA A 126     -40.033  23.806 -16.826  1.00 35.92           C  
ATOM    970  C   ALA A 126     -39.498  22.679 -15.927  1.00 34.63           C  
ATOM    971  O   ALA A 126     -39.955  21.543 -16.014  1.00 34.83           O  
ATOM    972  CB  ALA A 126     -39.184  23.946 -18.058  1.00 34.94           C  
ATOM    973  N   LYS A 127     -38.513  22.991 -15.085  1.00 34.30           N  
ATOM    974  CA  LYS A 127     -37.955  22.012 -14.152  1.00 33.74           C  
ATOM    975  C   LYS A 127     -38.940  21.613 -13.065  1.00 33.68           C  
ATOM    976  O   LYS A 127     -38.971  20.464 -12.660  1.00 33.10           O  
ATOM    977  CB  LYS A 127     -36.640  22.502 -13.580  1.00 33.75           C  
ATOM    978  CG  LYS A 127     -35.512  22.437 -14.625  1.00 35.48           C  
ATOM    979  CD  LYS A 127     -34.240  23.094 -14.122  1.00 36.79           C  
ATOM    980  CE  LYS A 127     -33.131  23.075 -15.181  1.00 40.47           C  
ATOM    981  NZ  LYS A 127     -32.356  21.816 -15.093  1.00 41.69           N  
ATOM    982  N   GLN A 128     -39.745  22.573 -12.602  1.00 34.42           N  
ATOM    983  CA  GLN A 128     -40.794  22.296 -11.634  0.40 35.17           C  
ATOM    985  C   GLN A 128     -41.855  21.382 -12.248  1.00 34.85           C  
ATOM    986  O   GLN A 128     -42.414  20.545 -11.574  1.00 35.25           O  
ATOM    987  CB  GLN A 128     -41.437  23.602 -11.144  0.40 35.74           C  
ATOM    989  CG  GLN A 128     -40.495  24.506 -10.344  0.40 37.51           C  
ATOM    991  CD  GLN A 128     -39.952  23.869  -9.066  0.40 38.98           C  
ATOM    993  OE1 GLN A 128     -38.756  23.956  -8.790  0.40 41.35           O  
ATOM    995  NE2 GLN A 128     -40.826  23.243  -8.275  0.40 39.78           N  
ATOM    997  N   ARG A 129     -42.123  21.550 -13.534  1.00 35.16           N  
ATOM    998  CA  ARG A 129     -43.071  20.682 -14.230  1.00 36.07           C  
ATOM    999  C   ARG A 129     -42.558  19.230 -14.338  1.00 35.44           C  
ATOM   1000  O   ARG A 129     -43.333  18.278 -14.205  1.00 35.05           O  
ATOM   1001  CB  ARG A 129     -43.364  21.247 -15.605  1.00 36.48           C  
ATOM   1002  CG  ARG A 129     -44.416  22.342 -15.600  1.00 41.32           C  
ATOM   1003  CD  ARG A 129     -44.505  22.943 -16.981  1.00 47.11           C  
ATOM   1004  NE  ARG A 129     -45.343  24.138 -17.031  1.00 54.18           N  
ATOM   1005  CZ  ARG A 129     -45.115  25.172 -17.841  1.00 56.99           C  
ATOM   1006  NH1 ARG A 129     -44.048  25.172 -18.645  1.00 57.53           N  
ATOM   1007  NH2 ARG A 129     -45.939  26.218 -17.833  1.00 58.05           N  
ATOM   1008  N   GLU A 130     -41.252  19.070 -14.567  1.00 34.44           N  
ATOM   1009  CA  GLU A 130     -40.603  17.756 -14.538  1.00 34.92           C  
ATOM   1010  C   GLU A 130     -40.825  17.021 -13.221  1.00 33.96           C  
ATOM   1011  O   GLU A 130     -41.121  15.837 -13.207  1.00 33.91           O  
ATOM   1012  CB  GLU A 130     -39.090  17.893 -14.786  1.00 34.79           C  
ATOM   1013  CG  GLU A 130     -38.753  18.405 -16.156  1.00 35.96           C  
ATOM   1014  CD  GLU A 130     -37.248  18.422 -16.422  1.00 38.05           C  
ATOM   1015  OE1 GLU A 130     -36.594  17.379 -16.243  1.00 44.26           O  
ATOM   1016  OE2 GLU A 130     -36.718  19.480 -16.796  1.00 43.45           O  
ATOM   1017  N   LEU A 131     -40.639  17.746 -12.120  1.00 33.90           N  
ATOM   1018  CA  LEU A 131     -40.763  17.249 -10.786  1.00 35.02           C  
ATOM   1019  C   LEU A 131     -42.187  16.821 -10.483  1.00 34.52           C  
ATOM   1020  O   LEU A 131     -42.408  15.724  -9.980  1.00 34.24           O  
ATOM   1021  CB  LEU A 131     -40.383  18.351  -9.823  1.00 36.16           C  
ATOM   1022  CG  LEU A 131     -40.329  17.973  -8.352  1.00 41.12           C  
ATOM   1023  CD1 LEU A 131     -39.114  17.109  -8.079  1.00 41.14           C  
ATOM   1024  CD2 LEU A 131     -40.298  19.292  -7.539  1.00 44.54           C  
ATOM   1025  N   ILE A 132     -43.132  17.699 -10.794  1.00 33.43           N  
ATOM   1026  CA  ILE A 132     -44.542  17.375 -10.732  1.00 33.68           C  
ATOM   1027  C   ILE A 132     -44.871  16.098 -11.547  1.00 33.25           C  
ATOM   1028  O   ILE A 132     -45.613  15.222 -11.071  1.00 32.44           O  
ATOM   1029  CB  ILE A 132     -45.361  18.587 -11.209  1.00 33.98           C  
ATOM   1030  CG1 ILE A 132     -45.154  19.746 -10.228  1.00 36.37           C  
ATOM   1031  CG2 ILE A 132     -46.874  18.238 -11.394  1.00 34.41           C  
ATOM   1032  CD1 ILE A 132     -45.836  21.002 -10.589  1.00 36.16           C  
ATOM   1033  N   ALA A 133     -44.312  16.008 -12.757  1.00 32.18           N  
ATOM   1034  CA  ALA A 133     -44.546  14.869 -13.657  1.00 32.73           C  
ATOM   1035  C   ALA A 133     -44.099  13.562 -12.983  1.00 32.67           C  
ATOM   1036  O   ALA A 133     -44.806  12.549 -13.041  1.00 33.47           O  
ATOM   1037  CB  ALA A 133     -43.835  15.060 -15.004  1.00 32.13           C  
ATOM   1038  N   TYR A 134     -42.961  13.593 -12.315  1.00 32.39           N  
ATOM   1039  CA  TYR A 134     -42.486  12.407 -11.613  1.00 33.78           C  
ATOM   1040  C   TYR A 134     -43.535  11.918 -10.600  1.00 34.03           C  
ATOM   1041  O   TYR A 134     -43.782  10.725 -10.482  1.00 34.90           O  
ATOM   1042  CB  TYR A 134     -41.158  12.666 -10.891  1.00 35.12           C  
ATOM   1043  CG  TYR A 134     -39.941  12.731 -11.789  1.00 35.91           C  
ATOM   1044  CD1 TYR A 134     -39.857  11.950 -12.926  1.00 38.44           C  
ATOM   1045  CD2 TYR A 134     -38.837  13.549 -11.465  1.00 40.25           C  
ATOM   1046  CE1 TYR A 134     -38.741  11.979 -13.751  1.00 39.31           C  
ATOM   1047  CE2 TYR A 134     -37.677  13.583 -12.302  1.00 38.28           C  
ATOM   1048  CZ  TYR A 134     -37.661  12.795 -13.439  1.00 38.82           C  
ATOM   1049  OH  TYR A 134     -36.589  12.798 -14.314  1.00 40.55           O  
ATOM   1050  N   VAL A 135     -44.127  12.845  -9.852  1.00 32.87           N  
ATOM   1051  CA  VAL A 135     -45.080  12.485  -8.808  1.00 32.48           C  
ATOM   1052  C   VAL A 135     -46.400  11.995  -9.448  1.00 31.19           C  
ATOM   1053  O   VAL A 135     -46.976  10.997  -9.009  1.00 30.93           O  
ATOM   1054  CB  VAL A 135     -45.368  13.690  -7.887  1.00 32.85           C  
ATOM   1055  CG1 VAL A 135     -46.573  13.369  -6.920  1.00 30.81           C  
ATOM   1056  CG2 VAL A 135     -44.067  14.027  -7.086  1.00 35.39           C  
ATOM   1057  N   ARG A 136     -46.855  12.716 -10.463  1.00 30.91           N  
ATOM   1058  CA  ARG A 136     -48.087  12.356 -11.168  0.50 31.46           C  
ATOM   1060  C   ARG A 136     -47.989  10.945 -11.708  1.00 30.82           C  
ATOM   1061  O   ARG A 136     -48.905  10.133 -11.492  1.00 31.87           O  
ATOM   1062  CB  ARG A 136     -48.379  13.298 -12.323  0.50 30.94           C  
ATOM   1064  CG  ARG A 136     -49.757  13.030 -12.981  0.50 32.94           C  
ATOM   1066  CD  ARG A 136     -49.771  13.424 -14.451  0.50 35.98           C  
ATOM   1068  NE  ARG A 136     -49.259  12.358 -15.316  0.50 39.98           N  
ATOM   1070  CZ  ARG A 136     -49.939  11.793 -16.307  0.50 40.50           C  
ATOM   1072  NH1 ARG A 136     -51.185  12.179 -16.601  0.50 42.43           N  
ATOM   1074  NH2 ARG A 136     -49.371  10.830 -17.006  0.50 41.30           N  
ATOM   1076  N   ASP A 137     -46.894  10.678 -12.412  1.00 31.43           N  
ATOM   1077  CA  ASP A 137     -46.667   9.388 -13.040  1.00 32.78           C  
ATOM   1078  C   ASP A 137     -46.564   8.299 -11.966  1.00 31.82           C  
ATOM   1079  O   ASP A 137     -47.070   7.202 -12.169  1.00 31.70           O  
ATOM   1080  CB  ASP A 137     -45.428   9.401 -13.924  1.00 32.63           C  
ATOM   1081  CG  ASP A 137     -45.594  10.257 -15.191  1.00 37.28           C  
ATOM   1082  OD1 ASP A 137     -46.676  10.811 -15.431  1.00 36.23           O  
ATOM   1083  OD2 ASP A 137     -44.611  10.356 -15.969  1.00 42.79           O  
ATOM   1084  N   ALA A 138     -45.949   8.597 -10.821  1.00 32.59           N  
ATOM   1085  CA  ALA A 138     -45.813   7.572  -9.765  1.00 32.29           C  
ATOM   1086  C   ALA A 138     -47.170   7.229  -9.141  1.00 33.38           C  
ATOM   1087  O   ALA A 138     -47.408   6.070  -8.779  1.00 33.60           O  
ATOM   1088  CB  ALA A 138     -44.832   8.031  -8.674  1.00 32.90           C  
ATOM   1089  N   LEU A 139     -48.039   8.235  -8.997  1.00 32.88           N  
ATOM   1090  CA  LEU A 139     -49.428   8.023  -8.555  1.00 32.09           C  
ATOM   1091  C   LEU A 139     -50.234   7.158  -9.543  1.00 31.31           C  
ATOM   1092  O   LEU A 139     -50.939   6.225  -9.133  1.00 30.81           O  
ATOM   1093  CB  LEU A 139     -50.153   9.372  -8.334  1.00 33.58           C  
ATOM   1094  CG  LEU A 139     -49.810  10.149  -7.051  1.00 33.44           C  
ATOM   1095  CD1 LEU A 139     -50.550  11.459  -7.032  1.00 35.96           C  
ATOM   1096  CD2 LEU A 139     -50.230   9.307  -5.845  1.00 36.97           C  
ATOM   1097  N   LEU A 140     -50.138   7.471 -10.829  1.00 30.10           N  
ATOM   1098  CA  LEU A 140     -50.822   6.689 -11.842  1.00 30.95           C  
ATOM   1099  C   LEU A 140     -50.230   5.268 -12.006  1.00 30.69           C  
ATOM   1100  O   LEU A 140     -50.900   4.400 -12.559  1.00 29.90           O  
ATOM   1101  CB  LEU A 140     -50.827   7.403 -13.198  1.00 30.06           C  
ATOM   1102  CG  LEU A 140     -51.601   8.721 -13.210  1.00 32.65           C  
ATOM   1103  CD1 LEU A 140     -51.292   9.456 -14.479  1.00 31.74           C  
ATOM   1104  CD2 LEU A 140     -53.129   8.524 -13.089  1.00 30.81           C  
ATOM   1105  N   GLN A 141     -49.009   5.026 -11.518  1.00 30.01           N  
ATOM   1106  CA  GLN A 141     -48.517   3.649 -11.436  1.00 30.05           C  
ATOM   1107  C   GLN A 141     -49.200   2.866 -10.298  1.00 29.95           C  
ATOM   1108  O   GLN A 141     -49.233   1.657 -10.331  1.00 28.82           O  
ATOM   1109  CB  GLN A 141     -46.997   3.572 -11.317  1.00 30.11           C  
ATOM   1110  CG  GLN A 141     -46.351   3.865 -12.644  1.00 28.95           C  
ATOM   1111  CD  GLN A 141     -44.847   3.840 -12.600  1.00 31.25           C  
ATOM   1112  OE1 GLN A 141     -44.220   4.535 -11.814  1.00 30.18           O  
ATOM   1113  NE2 GLN A 141     -44.258   3.058 -13.480  1.00 28.07           N  
ATOM   1114  N   LEU A 142     -49.726   3.572  -9.317  1.00 30.15           N  
ATOM   1115  CA  LEU A 142     -50.558   2.957  -8.272  1.00 32.41           C  
ATOM   1116  C   LEU A 142     -51.972   2.735  -8.773  1.00 32.65           C  
ATOM   1117  O   LEU A 142     -52.614   1.778  -8.364  1.00 33.80           O  
ATOM   1118  CB  LEU A 142     -50.645   3.829  -7.014  1.00 31.10           C  
ATOM   1119  CG  LEU A 142     -49.296   4.139  -6.362  1.00 34.61           C  
ATOM   1120  CD1 LEU A 142     -49.483   5.259  -5.346  1.00 33.30           C  
ATOM   1121  CD2 LEU A 142     -48.733   2.910  -5.725  1.00 34.38           C  
ATOM   1122  N   ARG A 143     -52.455   3.632  -9.631  1.00 32.37           N  
ATOM   1123  CA  ARG A 143     -53.816   3.549 -10.168  1.00 32.32           C  
ATOM   1124  C   ARG A 143     -53.796   3.661 -11.697  1.00 32.15           C  
ATOM   1125  O   ARG A 143     -54.168   4.699 -12.223  1.00 31.65           O  
ATOM   1126  CB  ARG A 143     -54.691   4.691  -9.597  1.00 31.75           C  
ATOM   1127  CG  ARG A 143     -55.110   4.576  -8.104  1.00 32.73           C  
ATOM   1128  CD  ARG A 143     -56.030   3.366  -7.821  1.00 31.70           C  
ATOM   1129  NE  ARG A 143     -57.270   3.340  -8.634  1.00 30.55           N  
ATOM   1130  CZ  ARG A 143     -58.443   3.850  -8.251  1.00 31.75           C  
ATOM   1131  NH1 ARG A 143     -58.565   4.475  -7.084  1.00 28.37           N  
ATOM   1132  NH2 ARG A 143     -59.513   3.750  -9.044  1.00 28.17           N  
ATOM   1133  N   PRO A 144     -53.320   2.612 -12.419  1.00 33.78           N  
ATOM   1134  CA  PRO A 144     -53.268   2.781 -13.881  1.00 34.28           C  
ATOM   1135  C   PRO A 144     -54.657   2.962 -14.469  1.00 34.96           C  
ATOM   1136  O   PRO A 144     -54.776   3.594 -15.512  1.00 33.76           O  
ATOM   1137  CB  PRO A 144     -52.618   1.494 -14.403  1.00 34.66           C  
ATOM   1138  CG  PRO A 144     -52.613   0.536 -13.250  1.00 35.29           C  
ATOM   1139  CD  PRO A 144     -52.817   1.296 -11.979  1.00 32.78           C  
ATOM   1140  N   ASP A 145     -55.694   2.506 -13.743  1.00 35.47           N  
ATOM   1141  CA  ASP A 145     -57.066   2.633 -14.224  1.00 36.11           C  
ATOM   1142  C   ASP A 145     -57.513   4.097 -14.293  1.00 36.88           C  
ATOM   1143  O   ASP A 145     -58.505   4.411 -14.920  1.00 36.68           O  
ATOM   1144  CB  ASP A 145     -58.032   1.769 -13.404  1.00 35.85           C  
ATOM   1145  CG  ASP A 145     -58.073   2.154 -11.894  1.00 36.32           C  
ATOM   1146  OD1 ASP A 145     -57.032   2.448 -11.252  1.00 36.22           O  
ATOM   1147  OD2 ASP A 145     -59.183   2.129 -11.345  1.00 38.19           O  
HETATM 1148  N   MSE A 146     -56.761   4.988 -13.655  1.00 38.35           N  
HETATM 1149  CA  MSE A 146     -57.097   6.411 -13.631  1.00 39.40           C  
HETATM 1150  C   MSE A 146     -56.332   7.304 -14.630  1.00 38.32           C  
HETATM 1151  O   MSE A 146     -56.540   8.521 -14.717  1.00 37.50           O  
HETATM 1152  CB  MSE A 146     -56.969   6.901 -12.185  1.00 40.24           C  
HETATM 1153  CG  MSE A 146     -58.142   6.300 -11.343  1.00 40.23           C  
HETATM 1154 SE   MSE A 146     -58.801   7.420 -10.039  0.60 47.94          SE  
HETATM 1155  CE  MSE A 146     -57.052   7.523  -9.184  1.00 31.43           C  
ATOM   1156  N   ALA A 147     -55.463   6.688 -15.415  1.00 37.89           N  
ATOM   1157  CA  ALA A 147     -54.568   7.443 -16.283  1.00 37.84           C  
ATOM   1158  C   ALA A 147     -55.319   8.020 -17.502  1.00 38.13           C  
ATOM   1159  O   ALA A 147     -54.880   9.005 -18.097  1.00 38.35           O  
ATOM   1160  CB  ALA A 147     -53.382   6.576 -16.682  1.00 36.68           C  
ATOM   1161  N   ALA A 148     -56.494   7.447 -17.806  1.00 38.36           N  
ATOM   1162  CA  ALA A 148     -57.347   7.890 -18.917  1.00 37.87           C  
ATOM   1163  C   ALA A 148     -57.853   9.317 -18.730  1.00 38.19           C  
ATOM   1164  O   ALA A 148     -58.076  10.030 -19.707  1.00 37.97           O  
ATOM   1165  CB  ALA A 148     -58.532   6.924 -19.102  1.00 38.16           C  
ATOM   1166  N   ASN A 149     -58.027   9.742 -17.471  1.00 37.88           N  
ATOM   1167  CA  ASN A 149     -58.530  11.087 -17.200  1.00 37.39           C  
ATOM   1168  C   ASN A 149     -57.405  12.021 -16.773  1.00 37.10           C  
ATOM   1169  O   ASN A 149     -57.079  12.119 -15.576  1.00 36.11           O  
ATOM   1170  CB  ASN A 149     -59.638  11.064 -16.149  1.00 38.06           C  
ATOM   1171  CG  ASN A 149     -60.370  12.408 -16.029  1.00 38.16           C  
ATOM   1172  OD1 ASN A 149     -59.828  13.480 -16.336  1.00 36.50           O  
ATOM   1173  ND2 ASN A 149     -61.625  12.341 -15.610  1.00 40.48           N  
ATOM   1174  N   ARG A 150     -56.823  12.714 -17.750  1.00 36.13           N  
ATOM   1175  CA  ARG A 150     -55.681  13.568 -17.469  1.00 36.76           C  
ATOM   1176  C   ARG A 150     -56.025  14.807 -16.654  1.00 35.72           C  
ATOM   1177  O   ARG A 150     -55.223  15.268 -15.875  1.00 35.79           O  
ATOM   1178  CB  ARG A 150     -54.959  13.927 -18.763  1.00 36.61           C  
ATOM   1179  CG  ARG A 150     -54.100  12.748 -19.255  1.00 39.15           C  
ATOM   1180  CD  ARG A 150     -53.509  12.943 -20.657  1.00 38.60           C  
ATOM   1181  NE  ARG A 150     -52.668  11.783 -20.924  1.00 43.01           N  
ATOM   1182  CZ  ARG A 150     -51.380  11.680 -20.595  1.00 41.75           C  
ATOM   1183  NH1 ARG A 150     -50.712  12.695 -20.047  1.00 41.38           N  
ATOM   1184  NH2 ARG A 150     -50.757  10.557 -20.856  1.00 42.67           N  
ATOM   1185  N   THR A 151     -57.239  15.320 -16.815  1.00 35.35           N  
ATOM   1186  CA  THR A 151     -57.690  16.478 -16.053  1.00 33.81           C  
ATOM   1187  C   THR A 151     -57.649  16.213 -14.567  1.00 33.74           C  
ATOM   1188  O   THR A 151     -57.039  16.966 -13.823  1.00 32.82           O  
ATOM   1189  CB  THR A 151     -59.101  16.903 -16.481  1.00 33.54           C  
ATOM   1190  OG1 THR A 151     -59.086  17.189 -17.880  1.00 34.70           O  
ATOM   1191  CG2 THR A 151     -59.530  18.170 -15.746  1.00 32.22           C  
ATOM   1192  N   LEU A 152     -58.294  15.128 -14.148  1.00 33.97           N  
ATOM   1193  CA  LEU A 152     -58.363  14.761 -12.758  1.00 33.69           C  
ATOM   1194  C   LEU A 152     -57.040  14.225 -12.242  1.00 33.28           C  
ATOM   1195  O   LEU A 152     -56.742  14.405 -11.078  1.00 33.04           O  
ATOM   1196  CB  LEU A 152     -59.519  13.773 -12.515  1.00 34.55           C  
ATOM   1197  CG  LEU A 152     -60.964  14.263 -12.784  1.00 36.61           C  
ATOM   1198  CD1 LEU A 152     -62.017  13.282 -12.238  1.00 38.12           C  
ATOM   1199  CD2 LEU A 152     -61.170  15.627 -12.111  1.00 38.09           C  
ATOM   1200  N   ALA A 153     -56.235  13.580 -13.100  1.00 33.24           N  
ATOM   1201  CA  ALA A 153     -54.854  13.218 -12.700  1.00 33.23           C  
ATOM   1202  C   ALA A 153     -54.008  14.439 -12.261  1.00 32.89           C  
ATOM   1203  O   ALA A 153     -53.297  14.380 -11.242  1.00 33.25           O  
ATOM   1204  CB  ALA A 153     -54.147  12.427 -13.800  1.00 32.58           C  
ATOM   1205  N   HIS A 154     -54.089  15.532 -13.024  1.00 32.40           N  
ATOM   1206  CA  HIS A 154     -53.473  16.798 -12.631  1.00 31.66           C  
ATOM   1207  C   HIS A 154     -54.067  17.382 -11.328  1.00 31.26           C  
ATOM   1208  O   HIS A 154     -53.312  17.770 -10.448  1.00 31.29           O  
ATOM   1209  CB  HIS A 154     -53.520  17.791 -13.789  1.00 32.91           C  
ATOM   1210  CG  HIS A 154     -53.028  19.162 -13.445  1.00 34.13           C  
ATOM   1211  ND1 HIS A 154     -51.701  19.438 -13.193  1.00 35.14           N  
ATOM   1212  CD2 HIS A 154     -53.693  20.336 -13.318  1.00 36.37           C  
ATOM   1213  CE1 HIS A 154     -51.574  20.730 -12.934  1.00 36.79           C  
ATOM   1214  NE2 HIS A 154     -52.773  21.292 -12.983  1.00 36.13           N  
ATOM   1215  N   VAL A 155     -55.388  17.454 -11.209  1.00 29.98           N  
ATOM   1216  CA  VAL A 155     -56.036  17.806  -9.923  1.00 30.09           C  
ATOM   1217  C   VAL A 155     -55.507  16.951  -8.765  1.00 30.10           C  
ATOM   1218  O   VAL A 155     -55.104  17.504  -7.755  1.00 28.11           O  
ATOM   1219  CB  VAL A 155     -57.600  17.735  -9.972  1.00 30.69           C  
ATOM   1220  CG1 VAL A 155     -58.177  18.061  -8.615  1.00 31.13           C  
ATOM   1221  CG2 VAL A 155     -58.124  18.750 -10.991  1.00 30.82           C  
ATOM   1222  N   ASP A 156     -55.451  15.623  -8.912  1.00 29.85           N  
ATOM   1223  CA  ASP A 156     -55.080  14.805  -7.755  1.00 31.39           C  
ATOM   1224  C   ASP A 156     -53.617  15.061  -7.362  1.00 31.24           C  
ATOM   1225  O   ASP A 156     -53.277  15.111  -6.168  1.00 29.87           O  
ATOM   1226  CB  ASP A 156     -55.297  13.291  -8.038  1.00 32.01           C  
ATOM   1227  CG  ASP A 156     -56.782  12.939  -8.258  1.00 36.51           C  
ATOM   1228  OD1 ASP A 156     -57.657  13.712  -7.824  1.00 37.96           O  
ATOM   1229  OD2 ASP A 156     -57.094  11.891  -8.858  1.00 39.26           O  
ATOM   1230  N   THR A 157     -52.748  15.156  -8.373  1.00 30.19           N  
ATOM   1231  CA  THR A 157     -51.358  15.474  -8.156  1.00 31.09           C  
ATOM   1232  C   THR A 157     -51.128  16.819  -7.448  1.00 30.56           C  
ATOM   1233  O   THR A 157     -50.328  16.905  -6.526  1.00 31.00           O  
ATOM   1234  CB  THR A 157     -50.575  15.395  -9.500  1.00 32.34           C  
ATOM   1235  OG1 THR A 157     -50.843  14.109 -10.094  1.00 32.06           O  
ATOM   1236  CG2 THR A 157     -49.097  15.550  -9.251  1.00 33.93           C  
HETATM 1237  N   MSE A 158     -51.827  17.861  -7.886  1.00 31.21           N  
HETATM 1238  CA  MSE A 158     -51.642  19.182  -7.311  1.00 31.29           C  
HETATM 1239  C   MSE A 158     -52.260  19.256  -5.891  1.00 31.55           C  
HETATM 1240  O   MSE A 158     -51.791  20.002  -5.059  1.00 30.91           O  
HETATM 1241  CB  MSE A 158     -52.229  20.271  -8.249  1.00 30.83           C  
HETATM 1242  CG  MSE A 158     -51.562  20.354  -9.613  1.00 34.58           C  
HETATM 1243 SE   MSE A 158     -49.618  20.335  -9.486  0.65 35.85          SE  
HETATM 1244  CE  MSE A 158     -49.466  22.152  -8.856  1.00 35.34           C  
ATOM   1245  N   LEU A 159     -53.290  18.448  -5.613  1.00 31.07           N  
ATOM   1246  CA  LEU A 159     -53.836  18.405  -4.252  1.00 30.16           C  
ATOM   1247  C   LEU A 159     -52.822  17.761  -3.317  1.00 31.07           C  
ATOM   1248  O   LEU A 159     -52.569  18.262  -2.224  1.00 28.90           O  
ATOM   1249  CB  LEU A 159     -55.151  17.654  -4.206  1.00 30.99           C  
ATOM   1250  CG  LEU A 159     -56.323  18.436  -4.834  1.00 30.28           C  
ATOM   1251  CD1 LEU A 159     -57.539  17.534  -5.084  1.00 32.55           C  
ATOM   1252  CD2 LEU A 159     -56.723  19.735  -3.994  1.00 28.14           C  
ATOM   1253  N   PHE A 160     -52.206  16.685  -3.799  1.00 30.78           N  
ATOM   1254  CA  PHE A 160     -51.089  16.116  -3.107  1.00 32.95           C  
ATOM   1255  C   PHE A 160     -49.946  17.122  -2.843  1.00 32.33           C  
ATOM   1256  O   PHE A 160     -49.490  17.207  -1.708  1.00 32.27           O  
ATOM   1257  CB  PHE A 160     -50.539  14.895  -3.821  1.00 33.39           C  
ATOM   1258  CG  PHE A 160     -49.239  14.465  -3.234  1.00 38.04           C  
ATOM   1259  CD1 PHE A 160     -49.225  13.761  -2.028  1.00 42.40           C  
ATOM   1260  CD2 PHE A 160     -48.038  14.889  -3.789  1.00 38.90           C  
ATOM   1261  CE1 PHE A 160     -48.019  13.426  -1.419  1.00 42.61           C  
ATOM   1262  CE2 PHE A 160     -46.837  14.566  -3.162  1.00 44.01           C  
ATOM   1263  CZ  PHE A 160     -46.851  13.837  -1.991  1.00 39.49           C  
ATOM   1264  N   PHE A 161     -49.431  17.780  -3.893  1.00 31.56           N  
ATOM   1265  CA  PHE A 161     -48.391  18.823  -3.707  1.00 33.02           C  
ATOM   1266  C   PHE A 161     -48.694  19.882  -2.651  1.00 32.29           C  
ATOM   1267  O   PHE A 161     -47.824  20.287  -1.892  1.00 33.13           O  
ATOM   1268  CB  PHE A 161     -47.978  19.478  -5.024  1.00 33.39           C  
ATOM   1269  CG  PHE A 161     -46.868  18.721  -5.713  1.00 36.99           C  
ATOM   1270  CD1 PHE A 161     -45.601  18.650  -5.135  1.00 37.31           C  
ATOM   1271  CD2 PHE A 161     -47.109  18.017  -6.889  1.00 36.76           C  
ATOM   1272  CE1 PHE A 161     -44.556  17.921  -5.746  1.00 39.97           C  
ATOM   1273  CE2 PHE A 161     -46.070  17.275  -7.498  1.00 36.67           C  
ATOM   1274  CZ  PHE A 161     -44.809  17.237  -6.928  1.00 35.46           C  
ATOM   1275  N   GLY A 162     -49.920  20.349  -2.642  1.00 32.00           N  
ATOM   1276  CA  GLY A 162     -50.425  21.237  -1.582  1.00 30.61           C  
ATOM   1277  C   GLY A 162     -50.165  20.730  -0.180  1.00 31.73           C  
ATOM   1278  O   GLY A 162     -49.703  21.507   0.659  1.00 28.83           O  
HETATM 1279  N   MSE A 163     -50.497  19.464   0.103  1.00 31.84           N  
HETATM 1280  CA  MSE A 163     -50.207  18.899   1.437  1.00 36.57           C  
HETATM 1281  C   MSE A 163     -48.776  19.061   1.844  1.00 33.49           C  
HETATM 1282  O   MSE A 163     -48.499  19.438   2.986  1.00 32.81           O  
HETATM 1283  CB  MSE A 163     -50.435  17.386   1.498  1.00 35.61           C  
HETATM 1284  CG  MSE A 163     -51.813  16.960   1.268  1.00 40.85           C  
HETATM 1285 SE   MSE A 163     -51.863  14.995   1.653  0.80 49.42          SE  
HETATM 1286  CE  MSE A 163     -52.716  14.463   0.162  1.00 44.34           C  
ATOM   1287  N   ILE A 164     -47.861  18.666   0.946  1.00 33.29           N  
ATOM   1288  CA  ILE A 164     -46.431  18.744   1.278  1.00 33.04           C  
ATOM   1289  C   ILE A 164     -45.793  20.116   1.098  1.00 33.06           C  
ATOM   1290  O   ILE A 164     -44.917  20.455   1.859  1.00 34.22           O  
ATOM   1291  CB  ILE A 164     -45.552  17.662   0.539  1.00 33.99           C  
ATOM   1292  CG1 ILE A 164     -45.669  17.713  -0.987  1.00 28.14           C  
ATOM   1293  CG2 ILE A 164     -45.833  16.264   1.067  1.00 34.43           C  
ATOM   1294  CD1 ILE A 164     -44.451  16.959  -1.597  1.00 35.44           C  
ATOM   1295  N   ASN A 165     -46.196  20.891   0.091  1.00 32.26           N  
ATOM   1296  CA  ASN A 165     -45.609  22.229  -0.145  1.00 32.38           C  
ATOM   1297  C   ASN A 165     -46.053  23.250   0.897  1.00 33.64           C  
ATOM   1298  O   ASN A 165     -45.315  24.216   1.166  1.00 36.34           O  
ATOM   1299  CB  ASN A 165     -45.917  22.775  -1.559  1.00 32.33           C  
ATOM   1300  CG  ASN A 165     -45.168  22.027  -2.651  1.00 34.88           C  
ATOM   1301  OD1 ASN A 165     -44.362  21.161  -2.359  1.00 39.14           O  
ATOM   1302  ND2 ASN A 165     -45.436  22.352  -3.916  1.00 36.06           N  
ATOM   1303  N   TRP A 166     -47.246  23.077   1.480  1.00 31.00           N  
ATOM   1304  CA  TRP A 166     -47.740  23.995   2.525  1.00 30.57           C  
ATOM   1305  C   TRP A 166     -47.024  23.859   3.862  1.00 29.41           C  
ATOM   1306  O   TRP A 166     -47.173  24.722   4.728  1.00 28.34           O  
ATOM   1307  CB  TRP A 166     -49.263  23.802   2.756  1.00 30.73           C  
ATOM   1308  CG  TRP A 166     -49.958  24.893   3.513  1.00 31.21           C  
ATOM   1309  CD1 TRP A 166     -50.610  24.791   4.727  1.00 33.28           C  
ATOM   1310  CD2 TRP A 166     -50.044  26.244   3.126  1.00 32.12           C  
ATOM   1311  NE1 TRP A 166     -51.111  26.011   5.087  1.00 36.70           N  
ATOM   1312  CE2 TRP A 166     -50.778  26.920   4.116  1.00 32.72           C  
ATOM   1313  CE3 TRP A 166     -49.576  26.957   2.015  1.00 33.00           C  
ATOM   1314  CZ2 TRP A 166     -51.059  28.282   4.038  1.00 35.88           C  
ATOM   1315  CZ3 TRP A 166     -49.877  28.315   1.935  1.00 34.12           C  
ATOM   1316  CH2 TRP A 166     -50.590  28.958   2.942  1.00 33.60           C  
ATOM   1317  N   THR A 167     -46.243  22.795   4.020  1.00 29.15           N  
ATOM   1318  CA  THR A 167     -45.547  22.496   5.284  1.00 29.50           C  
ATOM   1319  C   THR A 167     -44.649  23.621   5.789  1.00 29.63           C  
ATOM   1320  O   THR A 167     -44.512  23.826   6.982  1.00 29.70           O  
ATOM   1321  CB  THR A 167     -44.744  21.162   5.226  1.00 29.46           C  
ATOM   1322  OG1 THR A 167     -43.884  21.141   4.082  1.00 29.30           O  
ATOM   1323  CG2 THR A 167     -45.753  19.948   5.148  1.00 28.73           C  
ATOM   1324  N   TYR A 168     -44.059  24.361   4.876  1.00 29.57           N  
ATOM   1325  CA  TYR A 168     -43.184  25.460   5.285  1.00 30.99           C  
ATOM   1326  C   TYR A 168     -43.916  26.458   6.182  1.00 30.83           C  
ATOM   1327  O   TYR A 168     -43.289  27.143   6.996  1.00 31.57           O  
ATOM   1328  CB  TYR A 168     -42.524  26.132   4.074  1.00 31.55           C  
ATOM   1329  CG  TYR A 168     -43.364  27.156   3.347  1.00 33.93           C  
ATOM   1330  CD1 TYR A 168     -43.273  28.516   3.663  1.00 35.80           C  
ATOM   1331  CD2 TYR A 168     -44.213  26.784   2.320  1.00 34.15           C  
ATOM   1332  CE1 TYR A 168     -44.044  29.454   3.002  1.00 35.26           C  
ATOM   1333  CE2 TYR A 168     -45.002  27.734   1.657  1.00 33.18           C  
ATOM   1334  CZ  TYR A 168     -44.896  29.037   1.993  1.00 34.15           C  
ATOM   1335  OH  TYR A 168     -45.678  29.937   1.321  1.00 35.21           O  
ATOM   1336  N   THR A 169     -45.237  26.538   6.055  1.00 30.02           N  
ATOM   1337  CA  THR A 169     -45.980  27.540   6.839  1.00 29.93           C  
ATOM   1338  C   THR A 169     -46.227  27.110   8.291  1.00 30.72           C  
ATOM   1339  O   THR A 169     -46.606  27.945   9.117  1.00 31.32           O  
ATOM   1340  CB  THR A 169     -47.368  27.898   6.223  1.00 29.91           C  
ATOM   1341  OG1 THR A 169     -48.251  26.746   6.271  1.00 29.26           O  
ATOM   1342  CG2 THR A 169     -47.206  28.358   4.775  1.00 29.51           C  
ATOM   1343  N   TRP A 170     -46.081  25.824   8.594  1.00 30.48           N  
ATOM   1344  CA  TRP A 170     -46.542  25.325   9.913  1.00 30.46           C  
ATOM   1345  C   TRP A 170     -45.615  24.287  10.551  1.00 31.36           C  
ATOM   1346  O   TRP A 170     -45.549  24.161  11.792  1.00 31.73           O  
ATOM   1347  CB  TRP A 170     -47.955  24.727   9.792  1.00 29.87           C  
ATOM   1348  CG  TRP A 170     -48.088  23.459   8.908  1.00 26.82           C  
ATOM   1349  CD1 TRP A 170     -48.425  23.398   7.561  1.00 27.07           C  
ATOM   1350  CD2 TRP A 170     -47.941  22.102   9.340  1.00 28.29           C  
ATOM   1351  NE1 TRP A 170     -48.466  22.076   7.140  1.00 28.89           N  
ATOM   1352  CE2 TRP A 170     -48.193  21.265   8.216  1.00 27.41           C  
ATOM   1353  CE3 TRP A 170     -47.618  21.500  10.584  1.00 29.84           C  
ATOM   1354  CZ2 TRP A 170     -48.112  19.882   8.291  1.00 28.47           C  
ATOM   1355  CZ3 TRP A 170     -47.541  20.115  10.648  1.00 28.56           C  
ATOM   1356  CH2 TRP A 170     -47.801  19.328   9.503  1.00 29.42           C  
ATOM   1357  N   TYR A 171     -44.930  23.523   9.708  1.00 31.10           N  
ATOM   1358  CA  TYR A 171     -44.192  22.333  10.182  1.00 30.65           C  
ATOM   1359  C   TYR A 171     -42.766  22.632  10.598  1.00 30.91           C  
ATOM   1360  O   TYR A 171     -42.023  23.298   9.874  1.00 31.75           O  
ATOM   1361  CB  TYR A 171     -44.206  21.235   9.120  1.00 30.78           C  
ATOM   1362  CG  TYR A 171     -43.341  20.056   9.468  1.00 29.66           C  
ATOM   1363  CD1 TYR A 171     -43.691  19.206  10.508  1.00 31.06           C  
ATOM   1364  CD2 TYR A 171     -42.145  19.807   8.754  1.00 29.54           C  
ATOM   1365  CE1 TYR A 171     -42.892  18.101  10.859  1.00 27.14           C  
ATOM   1366  CE2 TYR A 171     -41.317  18.739   9.100  1.00 29.54           C  
ATOM   1367  CZ  TYR A 171     -41.709  17.884  10.148  1.00 30.16           C  
ATOM   1368  OH  TYR A 171     -40.908  16.831  10.490  1.00 30.37           O  
ATOM   1369  N   LYS A 172     -42.384  22.151  11.782  1.00 30.21           N  
ATOM   1370  CA  LYS A 172     -41.002  22.294  12.263  1.00 31.17           C  
ATOM   1371  C   LYS A 172     -40.319  20.916  12.285  1.00 30.05           C  
ATOM   1372  O   LYS A 172     -40.744  20.011  13.011  1.00 29.22           O  
ATOM   1373  CB  LYS A 172     -40.977  22.976  13.628  1.00 32.94           C  
ATOM   1374  CG  LYS A 172     -41.280  24.518  13.651  1.00 36.55           C  
ATOM   1375  CD  LYS A 172     -42.310  25.049  12.617  1.00 40.57           C  
ATOM   1376  CE  LYS A 172     -42.952  26.414  13.051  1.00 42.28           C  
ATOM   1377  NZ  LYS A 172     -43.739  27.141  11.965  1.00 41.45           N  
ATOM   1378  N   ALA A 173     -39.288  20.759  11.454  1.00 29.26           N  
ATOM   1379  CA  ALA A 173     -38.636  19.487  11.257  1.00 29.52           C  
ATOM   1380  C   ALA A 173     -37.876  18.924  12.490  1.00 30.42           C  
ATOM   1381  O   ALA A 173     -37.491  17.723  12.492  1.00 30.82           O  
ATOM   1382  CB  ALA A 173     -37.700  19.551  10.044  1.00 30.14           C  
ATOM   1383  N   ASP A 174     -37.629  19.772  13.492  1.00 29.91           N  
ATOM   1384  CA  ASP A 174     -36.945  19.334  14.726  1.00 31.31           C  
ATOM   1385  C   ASP A 174     -37.924  19.071  15.872  1.00 30.91           C  
ATOM   1386  O   ASP A 174     -37.523  18.952  17.040  1.00 30.41           O  
ATOM   1387  CB  ASP A 174     -35.861  20.351  15.147  1.00 31.46           C  
ATOM   1388  CG  ASP A 174     -36.426  21.698  15.551  1.00 34.71           C  
ATOM   1389  OD1 ASP A 174     -37.659  21.938  15.460  1.00 37.28           O  
ATOM   1390  OD2 ASP A 174     -35.623  22.548  15.988  1.00 41.01           O  
ATOM   1391  N   GLY A 175     -39.204  18.963  15.529  1.00 30.56           N  
ATOM   1392  CA  GLY A 175     -40.259  18.799  16.552  1.00 31.59           C  
ATOM   1393  C   GLY A 175     -40.601  17.346  16.818  1.00 31.85           C  
ATOM   1394  O   GLY A 175     -39.891  16.427  16.394  1.00 31.07           O  
ATOM   1395  N   SER A 176     -41.712  17.148  17.502  1.00 32.95           N  
ATOM   1396  CA  SER A 176     -42.208  15.821  17.890  1.00 34.36           C  
ATOM   1397  C   SER A 176     -42.271  14.825  16.730  1.00 33.96           C  
ATOM   1398  O   SER A 176     -41.723  13.679  16.825  1.00 35.36           O  
ATOM   1399  CB  SER A 176     -43.606  15.997  18.466  1.00 34.28           C  
ATOM   1400  OG  SER A 176     -43.462  16.553  19.737  1.00 39.73           O  
ATOM   1401  N   VAL A 177     -42.857  15.296  15.619  1.00 31.08           N  
ATOM   1402  CA  VAL A 177     -43.034  14.540  14.388  1.00 30.70           C  
ATOM   1403  C   VAL A 177     -41.845  14.727  13.405  1.00 30.74           C  
ATOM   1404  O   VAL A 177     -41.613  15.830  12.908  1.00 30.35           O  
ATOM   1405  CB  VAL A 177     -44.358  14.955  13.671  1.00 31.04           C  
ATOM   1406  CG1 VAL A 177     -44.641  14.002  12.454  1.00 30.35           C  
ATOM   1407  CG2 VAL A 177     -45.518  14.933  14.676  1.00 30.32           C  
ATOM   1408  N   SER A 178     -41.121  13.638  13.129  1.00 30.11           N  
ATOM   1409  CA  SER A 178     -39.925  13.685  12.295  1.00 31.09           C  
ATOM   1410  C   SER A 178     -40.304  13.823  10.830  1.00 31.82           C  
ATOM   1411  O   SER A 178     -41.435  13.501  10.459  1.00 32.57           O  
ATOM   1412  CB  SER A 178     -39.094  12.412  12.481  1.00 30.06           C  
ATOM   1413  OG  SER A 178     -39.750  11.322  11.845  1.00 29.05           O  
ATOM   1414  N   PRO A 179     -39.379  14.328   9.985  1.00 32.04           N  
ATOM   1415  CA  PRO A 179     -39.667  14.295   8.537  1.00 31.68           C  
ATOM   1416  C   PRO A 179     -40.152  12.945   7.991  1.00 31.25           C  
ATOM   1417  O   PRO A 179     -41.148  12.933   7.246  1.00 30.56           O  
ATOM   1418  CB  PRO A 179     -38.346  14.767   7.891  1.00 31.64           C  
ATOM   1419  CG  PRO A 179     -37.816  15.740   8.908  1.00 32.27           C  
ATOM   1420  CD  PRO A 179     -38.093  15.002  10.260  1.00 32.00           C  
ATOM   1421  N   ASP A 180     -39.540  11.830   8.414  1.00 29.92           N  
ATOM   1422  CA  ASP A 180     -39.996  10.499   7.961  1.00 31.10           C  
ATOM   1423  C   ASP A 180     -41.403  10.159   8.475  1.00 30.63           C  
ATOM   1424  O   ASP A 180     -42.207   9.652   7.723  1.00 31.85           O  
ATOM   1425  CB  ASP A 180     -39.037   9.366   8.358  1.00 31.14           C  
ATOM   1426  CG  ASP A 180     -38.162   8.905   7.212  1.00 35.60           C  
ATOM   1427  OD1 ASP A 180     -37.871   9.706   6.246  1.00 34.37           O  
ATOM   1428  OD2 ASP A 180     -37.750   7.728   7.306  1.00 39.80           O  
ATOM   1429  N   ALA A 181     -41.674  10.405   9.749  1.00 29.49           N  
ATOM   1430  CA  ALA A 181     -43.026  10.246  10.324  1.00 29.66           C  
ATOM   1431  C   ALA A 181     -44.060  11.099   9.564  1.00 29.22           C  
ATOM   1432  O   ALA A 181     -45.158  10.629   9.236  1.00 29.57           O  
ATOM   1433  CB  ALA A 181     -43.015  10.578  11.853  1.00 29.95           C  
ATOM   1434  N   LEU A 182     -43.711  12.342   9.243  1.00 29.39           N  
ATOM   1435  CA  LEU A 182     -44.672  13.205   8.541  1.00 30.18           C  
ATOM   1436  C   LEU A 182     -44.967  12.623   7.135  1.00 29.82           C  
ATOM   1437  O   LEU A 182     -46.128  12.624   6.667  1.00 29.62           O  
ATOM   1438  CB  LEU A 182     -44.161  14.661   8.475  1.00 29.53           C  
ATOM   1439  CG  LEU A 182     -45.028  15.613   7.652  1.00 32.70           C  
ATOM   1440  CD1 LEU A 182     -46.413  15.731   8.293  1.00 29.31           C  
ATOM   1441  CD2 LEU A 182     -44.373  17.031   7.561  1.00 30.32           C  
ATOM   1442  N   ALA A 183     -43.921  12.124   6.474  1.00 29.38           N  
ATOM   1443  CA  ALA A 183     -44.023  11.568   5.130  1.00 28.25           C  
ATOM   1444  C   ALA A 183     -44.918  10.336   5.142  1.00 29.12           C  
ATOM   1445  O   ALA A 183     -45.820  10.240   4.299  1.00 27.09           O  
ATOM   1446  CB  ALA A 183     -42.596  11.179   4.553  1.00 28.77           C  
ATOM   1447  N   GLU A 184     -44.669   9.415   6.087  1.00 29.28           N  
ATOM   1448  CA  GLU A 184     -45.499   8.195   6.249  1.00 30.64           C  
ATOM   1449  C   GLU A 184     -46.958   8.497   6.483  1.00 31.50           C  
ATOM   1450  O   GLU A 184     -47.841   7.860   5.883  1.00 29.54           O  
ATOM   1451  CB  GLU A 184     -44.945   7.282   7.339  1.00 31.28           C  
ATOM   1452  CG  GLU A 184     -43.568   6.767   6.907  1.00 36.17           C  
ATOM   1453  CD  GLU A 184     -42.842   5.882   7.897  1.00 44.74           C  
ATOM   1454  OE1 GLU A 184     -43.099   6.014   9.118  1.00 49.56           O  
ATOM   1455  OE2 GLU A 184     -41.981   5.071   7.439  1.00 45.97           O  
ATOM   1456  N   ARG A 185     -47.199   9.468   7.369  1.00 31.04           N  
ATOM   1457  CA  ARG A 185     -48.540   9.977   7.647  1.00 32.00           C  
ATOM   1458  C   ARG A 185     -49.211  10.572   6.400  1.00 31.95           C  
ATOM   1459  O   ARG A 185     -50.362  10.260   6.117  1.00 32.61           O  
ATOM   1460  CB  ARG A 185     -48.472  11.096   8.682  1.00 31.15           C  
ATOM   1461  CG  ARG A 185     -49.893  11.547   9.208  1.00 35.05           C  
ATOM   1462  CD  ARG A 185     -50.445  10.461  10.066  1.00 36.90           C  
ATOM   1463  NE  ARG A 185     -51.618  10.858  10.851  1.00 40.91           N  
ATOM   1464  CZ  ARG A 185     -52.139  10.090  11.802  1.00 39.41           C  
ATOM   1465  NH1 ARG A 185     -51.568   8.924  12.076  1.00 39.90           N  
ATOM   1466  NH2 ARG A 185     -53.211  10.468  12.461  1.00 35.77           N  
ATOM   1467  N   THR A 186     -48.522  11.496   5.730  1.00 30.79           N  
ATOM   1468  CA  THR A 186     -48.986  12.103   4.460  1.00 31.96           C  
ATOM   1469  C   THR A 186     -49.408  11.041   3.410  1.00 31.48           C  
ATOM   1470  O   THR A 186     -50.491  11.103   2.814  1.00 30.34           O  
ATOM   1471  CB  THR A 186     -47.886  13.000   3.884  1.00 32.08           C  
ATOM   1472  OG1 THR A 186     -47.591  14.016   4.853  1.00 31.87           O  
ATOM   1473  CG2 THR A 186     -48.317  13.644   2.547  1.00 35.19           C  
ATOM   1474  N   VAL A 187     -48.567  10.052   3.222  1.00 30.80           N  
ATOM   1475  CA  VAL A 187     -48.892   8.954   2.316  1.00 31.31           C  
ATOM   1476  C   VAL A 187     -50.050   8.067   2.769  1.00 31.52           C  
ATOM   1477  O   VAL A 187     -50.920   7.736   1.950  1.00 30.69           O  
ATOM   1478  CB  VAL A 187     -47.633   8.096   2.048  1.00 32.51           C  
ATOM   1479  CG1 VAL A 187     -47.966   6.848   1.219  1.00 30.09           C  
ATOM   1480  CG2 VAL A 187     -46.595   8.939   1.312  1.00 30.14           C  
ATOM   1481  N   GLN A 188     -50.061   7.653   4.045  1.00 30.71           N  
ATOM   1482  CA  GLN A 188     -51.198   6.865   4.567  1.00 32.57           C  
ATOM   1483  C   GLN A 188     -52.532   7.645   4.336  1.00 31.15           C  
ATOM   1484  O   GLN A 188     -53.527   7.081   3.881  1.00 30.42           O  
ATOM   1485  CB  GLN A 188     -51.009   6.542   6.097  1.00 31.39           C  
ATOM   1486  CG  GLN A 188     -49.822   5.551   6.404  1.00 35.85           C  
ATOM   1487  CD  GLN A 188     -49.291   5.638   7.887  1.00 38.94           C  
ATOM   1488  OE1 GLN A 188     -49.907   6.301   8.772  1.00 44.48           O  
ATOM   1489  NE2 GLN A 188     -48.125   4.987   8.142  1.00 44.38           N  
ATOM   1490  N   LEU A 189     -52.546   8.931   4.699  1.00 29.98           N  
ATOM   1491  CA  LEU A 189     -53.742   9.761   4.557  0.50 29.81           C  
ATOM   1493  C   LEU A 189     -54.153   9.870   3.084  1.00 30.09           C  
ATOM   1494  O   LEU A 189     -55.332   9.609   2.734  1.00 30.34           O  
ATOM   1495  CB  LEU A 189     -53.497  11.167   5.133  0.50 29.18           C  
ATOM   1497  CG  LEU A 189     -53.397  11.363   6.656  0.50 28.11           C  
ATOM   1499  CD1 LEU A 189     -52.668  12.692   6.962  0.50 23.96           C  
ATOM   1501  CD2 LEU A 189     -54.792  11.398   7.288  0.50 25.50           C  
ATOM   1503  N   PHE A 190     -53.207  10.281   2.238  1.00 30.03           N  
ATOM   1504  CA  PHE A 190     -53.492  10.519   0.802  1.00 30.98           C  
ATOM   1505  C   PHE A 190     -53.941   9.227   0.096  1.00 31.95           C  
ATOM   1506  O   PHE A 190     -54.926   9.241  -0.603  1.00 32.24           O  
ATOM   1507  CB  PHE A 190     -52.299  11.139   0.036  1.00 31.66           C  
ATOM   1508  CG  PHE A 190     -52.664  11.536  -1.395  1.00 35.15           C  
ATOM   1509  CD1 PHE A 190     -53.455  12.651  -1.633  1.00 38.78           C  
ATOM   1510  CD2 PHE A 190     -52.272  10.756  -2.472  1.00 35.35           C  
ATOM   1511  CE1 PHE A 190     -53.839  13.009  -2.942  1.00 38.89           C  
ATOM   1512  CE2 PHE A 190     -52.654  11.112  -3.773  1.00 37.14           C  
ATOM   1513  CZ  PHE A 190     -53.437  12.234  -3.987  1.00 35.49           C  
ATOM   1514  N   LEU A 191     -53.221   8.120   0.302  1.00 30.48           N  
ATOM   1515  CA  LEU A 191     -53.540   6.854  -0.375  1.00 30.61           C  
ATOM   1516  C   LEU A 191     -54.739   6.102   0.204  1.00 29.03           C  
ATOM   1517  O   LEU A 191     -55.555   5.557  -0.534  1.00 28.61           O  
ATOM   1518  CB  LEU A 191     -52.315   5.910  -0.385  1.00 30.26           C  
ATOM   1519  CG  LEU A 191     -51.118   6.410  -1.212  1.00 32.28           C  
ATOM   1520  CD1 LEU A 191     -50.112   5.278  -1.340  1.00 31.90           C  
ATOM   1521  CD2 LEU A 191     -51.494   6.949  -2.610  1.00 34.52           C  
ATOM   1522  N   ASP A 192     -54.829   6.051   1.524  1.00 29.46           N  
ATOM   1523  CA  ASP A 192     -55.827   5.191   2.166  1.00 31.22           C  
ATOM   1524  C   ASP A 192     -56.931   5.942   2.916  1.00 29.88           C  
ATOM   1525  O   ASP A 192     -57.984   5.356   3.254  1.00 27.98           O  
ATOM   1526  CB  ASP A 192     -55.116   4.141   3.040  1.00 33.18           C  
ATOM   1527  CG  ASP A 192     -54.323   3.128   2.185  1.00 38.75           C  
ATOM   1528  OD1 ASP A 192     -54.962   2.354   1.431  1.00 48.90           O  
ATOM   1529  OD2 ASP A 192     -53.080   3.120   2.224  1.00 47.47           O  
ATOM   1530  N   GLY A 193     -56.730   7.244   3.140  1.00 28.14           N  
ATOM   1531  CA  GLY A 193     -57.830   8.057   3.663  1.00 27.49           C  
ATOM   1532  C   GLY A 193     -57.846   8.234   5.158  1.00 27.69           C  
ATOM   1533  O   GLY A 193     -57.563   7.313   5.908  1.00 26.87           O  
ATOM   1534  N   TYR A 194     -58.198   9.452   5.588  1.00 26.80           N  
ATOM   1535  CA  TYR A 194     -58.390   9.790   6.996  1.00 27.21           C  
ATOM   1536  C   TYR A 194     -59.295   8.799   7.748  1.00 28.66           C  
ATOM   1537  O   TYR A 194     -59.028   8.443   8.921  1.00 27.38           O  
ATOM   1538  CB  TYR A 194     -59.004  11.184   7.091  1.00 25.93           C  
ATOM   1539  CG  TYR A 194     -59.089  11.692   8.485  1.00 28.15           C  
ATOM   1540  CD1 TYR A 194     -60.319  11.835   9.128  1.00 26.18           C  
ATOM   1541  CD2 TYR A 194     -57.941  12.028   9.171  1.00 28.86           C  
ATOM   1542  CE1 TYR A 194     -60.375  12.299  10.447  1.00 27.32           C  
ATOM   1543  CE2 TYR A 194     -57.994  12.480  10.485  1.00 31.49           C  
ATOM   1544  CZ  TYR A 194     -59.204  12.639  11.100  1.00 26.72           C  
ATOM   1545  OH  TYR A 194     -59.224  13.077  12.441  1.00 32.19           O  
ATOM   1546  N   LEU A 195     -60.378   8.393   7.086  1.00 29.22           N  
ATOM   1547  CA  LEU A 195     -61.355   7.480   7.691  1.00 32.13           C  
ATOM   1548  C   LEU A 195     -60.872   6.028   7.958  1.00 33.55           C  
ATOM   1549  O   LEU A 195     -61.499   5.302   8.744  1.00 32.98           O  
ATOM   1550  CB  LEU A 195     -62.658   7.503   6.900  1.00 31.95           C  
ATOM   1551  CG  LEU A 195     -63.417   8.841   6.788  1.00 30.83           C  
ATOM   1552  CD1 LEU A 195     -64.709   8.655   5.945  1.00 32.16           C  
ATOM   1553  CD2 LEU A 195     -63.799   9.470   8.171  1.00 31.39           C  
ATOM   1554  N   ASN A 196     -59.756   5.621   7.354  1.00 34.25           N  
ATOM   1555  CA  ASN A 196     -59.248   4.251   7.548  1.00 35.77           C  
ATOM   1556  C   ASN A 196     -57.912   4.209   8.303  1.00 37.09           C  
ATOM   1557  O   ASN A 196     -57.315   3.142   8.498  1.00 36.98           O  
ATOM   1558  CB  ASN A 196     -59.088   3.546   6.194  1.00 36.33           C  
ATOM   1559  CG  ASN A 196     -60.294   3.707   5.319  1.00 36.59           C  
ATOM   1560  OD1 ASN A 196     -60.262   4.419   4.305  1.00 39.47           O  
ATOM   1561  ND2 ASN A 196     -61.379   3.093   5.713  1.00 34.44           N  
ATOM   1562  N   LEU A 197     -57.441   5.375   8.704  1.00 37.33           N  
ATOM   1563  CA  LEU A 197     -56.169   5.492   9.372  1.00 40.29           C  
ATOM   1564  C   LEU A 197     -56.328   4.809  10.727  1.00 41.37           C  
ATOM   1565  O   LEU A 197     -57.346   4.998  11.410  1.00 40.47           O  
ATOM   1566  CB  LEU A 197     -55.902   6.977   9.566  1.00 40.26           C  
ATOM   1567  CG  LEU A 197     -54.587   7.741   9.453  1.00 44.21           C  
ATOM   1568  CD1 LEU A 197     -53.687   7.323   8.308  1.00 44.67           C  
ATOM   1569  CD2 LEU A 197     -54.971   9.186   9.298  1.00 43.76           C  
ATOM   1570  N   LEU A 198     -55.350   3.995  11.109  1.00 43.48           N  
ATOM   1571  CA  LEU A 198     -55.392   3.367  12.430  1.00 46.07           C  
ATOM   1572  C   LEU A 198     -55.154   4.388  13.523  1.00 47.24           C  
ATOM   1573  O   LEU A 198     -54.281   5.261  13.413  1.00 46.84           O  
ATOM   1574  CB  LEU A 198     -54.409   2.199  12.530  1.00 46.10           C  
ATOM   1575  CG  LEU A 198     -55.010   0.785  12.444  1.00 47.31           C  
ATOM   1576  CD1 LEU A 198     -56.063   0.603  11.329  1.00 48.53           C  
ATOM   1577  CD2 LEU A 198     -53.893  -0.257  12.285  1.00 47.65           C  
ATOM   1578  N   SER A 199     -55.963   4.295  14.568  1.00 49.60           N  
ATOM   1579  CA  SER A 199     -55.816   5.182  15.703  1.00 52.32           C  
ATOM   1580  C   SER A 199     -55.101   4.494  16.855  1.00 53.62           C  
ATOM   1581  O   SER A 199     -55.569   3.465  17.356  1.00 54.12           O  
ATOM   1582  CB  SER A 199     -57.176   5.685  16.166  1.00 52.36           C  
ATOM   1583  OG  SER A 199     -56.996   6.861  16.940  1.00 54.90           O  
ATOM   1584  N   ALA A 200     -53.965   5.065  17.256  1.00 55.49           N  
ATOM   1585  CA  ALA A 200     -53.172   4.586  18.410  1.00 56.60           C  
ATOM   1586  C   ALA A 200     -53.980   4.452  19.698  1.00 57.21           C  
ATOM   1587  O   ALA A 200     -54.711   3.470  19.898  1.00 57.84           O  
ATOM   1588  CB  ALA A 200     -51.977   5.512  18.654  1.00 57.17           C  
TER    1589      ALA A 200                                                      
END
MOLECULE T0454.pdb
ATOM      1  N   ASP     5     -12.420  32.658   0.024  1.00 27.13           N
ATOM      2  CA  ASP     5     -13.312  32.598   1.217  1.00 27.34           C
ATOM      3  CB  ASP     5     -12.512  32.690   2.520  1.00 28.50           C
ATOM      4  CG  ASP     5     -13.404  32.599   3.759  1.00 30.42           C
ATOM      5  OD1 ASP     5     -14.289  31.706   3.803  1.00 33.47           O
ATOM      6  OD2 ASP     5     -13.226  33.430   4.680  1.00 32.05           O
ATOM      7  C   ASP     5     -14.424  33.644   1.238  1.00 26.73           C
ATOM      8  O   ASP     5     -15.477  33.398   1.835  1.00 26.63           O
ATOM      9  N   CYS     6     -14.211  34.799   0.611  0.50 26.41           N
ATOM     11  CA  CYS     6     -15.286  35.794   0.531  0.50 26.28           C
ATOM     13  CB  CYS     6     -14.751  37.198   0.241  0.50 26.57           C
ATOM     15  SG  CYS     6     -14.050  37.968   1.731  0.50 29.41           S
ATOM     17  C   CYS     6     -16.388  35.363  -0.439  0.50 25.38           C
ATOM     19  O   CYS     6     -17.496  35.901  -0.414  0.50 25.34           O
ATOM     21  N   ARG     7     -16.080  34.368  -1.271  1.00 24.45           N
ATOM     22  CA  ARG     7     -17.093  33.680  -2.080  1.00 22.28           C
ATOM     23  CB  ARG     7     -16.421  32.728  -3.079  1.00 22.90           C
ATOM     30  C   ARG     7     -18.066  32.903  -1.186  1.00 20.46           C
ATOM     31  O   ARG     7     -19.262  32.867  -1.449  1.00 20.43           O
ATOM     32  N   SER     8     -17.547  32.253  -0.148  0.50 19.10           N
ATOM     34  CA  SER     8     -18.391  31.436   0.731  0.50 17.33           C
ATOM     36  CB  SER     8     -17.550  30.493   1.586  0.50 17.45           C
ATOM     38  OG  SER     8     -18.312  29.968   2.658  0.50 15.65           O
ATOM     40  C   SER     8     -19.258  32.322   1.613  0.50 16.60           C
ATOM     42  O   SER     8     -20.455  32.084   1.776  0.50 15.91           O
ATOM     44  N   ARG     9     -18.645  33.365   2.159  0.50 15.61           N
ATOM     46  CA  ARG     9     -19.363  34.297   3.022  0.50 14.83           C
ATOM     48  CB  ARG     9     -18.372  35.205   3.766  0.50 15.25           C
ATOM     50  CG  ARG     9     -17.394  34.394   4.628  0.50 14.59           C
ATOM     52  CD  ARG     9     -16.768  35.163   5.795  0.50 16.76           C
ATOM     54  NE  ARG     9     -15.709  36.081   5.358  0.50 18.23           N
ATOM     56  CZ  ARG     9     -15.907  37.364   5.046  0.50 17.11           C
ATOM     58  NH1 ARG     9     -14.883  38.115   4.657  0.50 16.37           N
ATOM     60  NH2 ARG     9     -17.129  37.896   5.121  0.50 17.10           N
ATOM     62  C   ARG     9     -20.452  35.089   2.282  0.50 14.49           C
ATOM     64  O   ARG     9     -21.506  35.370   2.850  0.50 13.18           O
ATOM     66  N   LEU    10     -20.187  35.432   1.021  1.00 14.14           N
ATOM     67  CA  LEU    10     -21.183  36.018   0.143  1.00 15.70           C
ATOM     68  CB  LEU    10     -20.580  36.459  -1.201  1.00 16.55           C
ATOM     69  CG  LEU    10     -20.226  37.923  -1.321  1.00 18.07           C
ATOM     70  CD1 LEU    10     -19.435  38.165  -2.626  1.00 18.10           C
ATOM     71  CD2 LEU    10     -21.495  38.769  -1.285  1.00 16.77           C
ATOM     72  C   LEU    10     -22.364  35.072  -0.083  1.00 15.96           C
ATOM     73  O   LEU    10     -23.511  35.520  -0.035  1.00 16.63           O
ATOM     74  N   MET    11     -22.097  33.792  -0.326  0.70 16.06           N
ATOM     76  CA  MET    11     -23.179  32.843  -0.534  0.70 17.38           C
ATOM     78  CB  MET    11     -22.637  31.461  -0.863  0.70 20.17           C
ATOM     80  CG  MET    11     -22.166  31.316  -2.273  0.70 25.34           C
ATOM     82  SD  MET    11     -23.611  30.818  -3.503  0.70 46.93          SE
ATOM     84  CE  MET    11     -22.374  30.088  -4.856  0.70 32.85           C
ATOM     86  C   MET    11     -24.065  32.759   0.707  0.70 15.90           C
ATOM     88  O   MET    11     -25.298  32.724   0.592  0.70 14.79           O
ATOM     90  N   GLU    12     -23.436  32.726   1.888  1.00 13.16           N
ATOM     91  CA  GLU    12     -24.186  32.691   3.141  1.00 12.28           C
ATOM     92  CB  GLU    12     -23.255  32.550   4.367  1.00 11.62           C
ATOM     93  CG  GLU    12     -24.006  32.676   5.679  1.00 12.98           C
ATOM     94  CD  GLU    12     -24.899  31.451   5.972  1.00 17.78           C
ATOM     95  OE1 GLU    12     -24.548  30.339   5.520  1.00 20.61           O
ATOM     96  OE2 GLU    12     -25.952  31.593   6.636  1.00 18.33           O
ATOM     97  C   GLU    12     -25.062  33.946   3.278  1.00 11.77           C
ATOM     98  O   GLU    12     -26.263  33.868   3.569  1.00 10.95           O
ATOM     99  N   VAL    13     -24.441  35.104   3.102  1.00 11.38           N
ATOM    100  CA  VAL    13     -25.143  36.347   3.297  1.00 11.79           C
ATOM    101  CB  VAL    13     -24.168  37.555   3.216  1.00 11.85           C
ATOM    102  CG1 VAL    13     -24.903  38.816   2.771  1.00 13.25           C
ATOM    103  CG2 VAL    13     -23.437  37.739   4.528  1.00 12.09           C
ATOM    104  C   VAL    13     -26.264  36.469   2.270  1.00 12.08           C
ATOM    105  O   VAL    13     -27.360  36.860   2.613  1.00 12.20           O
ATOM    106  N   ALA    14     -25.987  36.132   1.016  1.00 11.94           N
ATOM    107  CA  ALA    14     -27.028  36.192  -0.026  1.00 12.57           C
ATOM    108  CB  ALA    14     -26.434  35.847  -1.397  1.00 12.81           C
ATOM    109  C   ALA    14     -28.224  35.272   0.324  1.00 12.70           C
ATOM    110  O   ALA    14     -29.404  35.681   0.225  1.00 12.49           O
ATOM    111  N   THR    15     -27.933  34.045   0.752  1.00 12.08           N
ATOM    112  CA  THR    15     -29.000  33.092   1.088  1.00 13.57           C
ATOM    113  CB  THR    15     -28.420  31.727   1.526  1.00 13.02           C
ATOM    114  OG1 THR    15     -27.592  31.204   0.477  1.00 13.54           O
ATOM    115  CG2 THR    15     -29.544  30.705   1.864  1.00 14.11           C
ATOM    116  C   THR    15     -29.885  33.685   2.197  1.00 13.81           C
ATOM    117  O   THR    15     -31.100  33.676   2.080  1.00 14.69           O
ATOM    118  N   GLU    16     -29.283  34.229   3.251  0.50 12.86           N
ATOM    120  CA  GLU    16     -30.060  34.743   4.392  0.50 12.65           C
ATOM    122  CB  GLU    16     -29.168  34.850   5.619  0.50 11.98           C
ATOM    124  CG  GLU    16     -28.366  33.560   5.847  0.50 10.56           C
ATOM    126  CD  GLU    16     -29.193  32.437   6.436  0.50 10.50           C
ATOM    128  OE1 GLU    16     -29.690  32.653   7.554  0.50 13.56           O
ATOM    130  OE2 GLU    16     -29.343  31.334   5.814  0.50  9.37           O
ATOM    132  C   GLU    16     -30.844  36.053   4.135  0.50 13.06           C
ATOM    134  O   GLU    16     -31.941  36.247   4.680  0.50 12.44           O
ATOM    136  N   LEU    17     -30.289  36.937   3.304  1.00 13.39           N
ATOM    137  CA  LEU    17     -30.999  38.157   2.904  1.00 13.60           C
ATOM    138  CB  LEU    17     -30.022  39.257   2.439  1.00 13.92           C
ATOM    139  CG  LEU    17     -29.168  39.859   3.564  1.00 15.45           C
ATOM    140  CD1 LEU    17     -28.242  40.964   3.019  1.00 18.76           C
ATOM    141  CD2 LEU    17     -30.008  40.355   4.753  1.00 18.21           C
ATOM    142  C   LEU    17     -32.079  37.907   1.841  1.00 13.42           C
ATOM    143  O   LEU    17     -33.201  38.400   2.004  1.00 13.35           O
ATOM    144  N   PHE    18     -31.772  37.132   0.800  1.00 12.52           N
ATOM    145  CA  PHE    18     -32.789  36.767  -0.188  1.00 12.55           C
ATOM    146  CB  PHE    18     -32.168  36.032  -1.355  1.00 12.74           C
ATOM    147  CG  PHE    18     -31.341  36.895  -2.267  1.00 11.67           C
ATOM    148  CD1 PHE    18     -31.865  38.079  -2.813  1.00 12.22           C
ATOM    149  CE1 PHE    18     -31.138  38.864  -3.706  1.00 12.93           C
ATOM    150  CZ  PHE    18     -29.843  38.455  -4.104  1.00 13.62           C
ATOM    151  CE2 PHE    18     -29.308  37.240  -3.582  1.00 11.19           C
ATOM    152  CD2 PHE    18     -30.083  36.472  -2.677  1.00 11.90           C
ATOM    153  C   PHE    18     -33.889  35.866   0.419  1.00 13.51           C
ATOM    154  O   PHE    18     -35.054  35.962   0.015  1.00 15.25           O
ATOM    155  N   ALA    19     -33.532  34.996   1.373  1.00 13.39           N
ATOM    156  CA  ALA    19     -34.553  34.208   2.061  1.00 15.05           C
ATOM    157  CB  ALA    19     -33.942  33.133   2.992  1.00 14.27           C
ATOM    158  C   ALA    19     -35.536  35.094   2.817  1.00 15.36           C
ATOM    159  O   ALA    19     -36.754  34.842   2.737  1.00 16.78           O
ATOM    160  N   GLN    20     -35.009  36.097   3.541  0.70 16.27           N
ATOM    162  CA  GLN    20     -35.806  37.053   4.335  0.70 16.80           C
ATOM    164  CB  GLN    20     -34.946  37.989   5.239  0.70 17.01           C
ATOM    166  CG  GLN    20     -35.745  39.306   5.640  0.70 16.81           C
ATOM    168  CD  GLN    20     -35.206  40.143   6.812  0.70 17.74           C
ATOM    170  OE1 GLN    20     -35.154  41.393   6.736  0.70 13.85           O
ATOM    172  NE2 GLN    20     -34.830  39.472   7.903  0.70 18.70           N
ATOM    174  C   GLN    20     -36.691  37.941   3.482  0.70 17.07           C
ATOM    176  O   GLN    20     -37.900  38.009   3.701  0.70 17.23           O
ATOM    178  N   LYS    21     -36.060  38.636   2.537  1.00 15.44           N
ATOM    179  CA  LYS    21     -36.656  39.778   1.820  1.00 16.20           C
ATOM    180  CB  LYS    21     -35.693  40.954   1.797  1.00 16.65           C
ATOM    181  CG  LYS    21     -35.259  41.391   3.184  1.00 19.64           C
ATOM    182  CD  LYS    21     -34.363  42.583   3.043  1.00 22.59           C
ATOM    183  CE  LYS    21     -33.720  42.901   4.359  1.00 25.71           C
ATOM    184  NZ  LYS    21     -33.292  44.316   4.378  1.00 29.79           N
ATOM    185  C   LYS    21     -37.021  39.482   0.389  1.00 15.03           C
ATOM    186  O   LYS    21     -37.639  40.317  -0.275  1.00 16.30           O
ATOM    187  N   GLY    22     -36.632  38.313  -0.101  1.00 14.81           N
ATOM    188  CA  GLY    22     -36.879  37.954  -1.501  1.00 12.41           C
ATOM    189  C   GLY    22     -35.967  38.743  -2.431  1.00 13.23           C
ATOM    190  O   GLY    22     -35.355  39.762  -2.034  1.00 13.65           O
ATOM    191  N   PHE    23     -35.857  38.255  -3.660  1.00 12.90           N
ATOM    192  CA  PHE    23     -35.064  38.952  -4.675  1.00 13.24           C
ATOM    193  CB  PHE    23     -35.255  38.297  -6.043  1.00 15.31           C
ATOM    194  CG  PHE    23     -34.544  39.016  -7.130  1.00 16.26           C
ATOM    195  CD1 PHE    23     -33.214  38.729  -7.414  1.00 17.28           C
ATOM    196  CE1 PHE    23     -32.528  39.446  -8.406  1.00 17.88           C
ATOM    197  CZ  PHE    23     -33.173  40.390  -9.137  1.00 18.69           C
ATOM    198  CE2 PHE    23     -34.531  40.677  -8.884  1.00 18.23           C
ATOM    199  CD2 PHE    23     -35.193  40.000  -7.883  1.00 18.32           C
ATOM    200  C   PHE    23     -35.468  40.425  -4.758  1.00 14.16           C
ATOM    201  O   PHE    23     -34.604  41.312  -4.880  1.00 14.45           O
ATOM    202  N   TYR    24     -36.778  40.690  -4.743  1.00 14.52           N
ATOM    203  CA  TYR    24     -37.263  42.057  -4.998  1.00 15.59           C
ATOM    204  CB  TYR    24     -38.733  42.085  -5.422  1.00 13.51           C
ATOM    205  CG  TYR    24     -38.963  41.406  -6.781  1.00 13.47           C
ATOM    206  CD1 TYR    24     -38.665  42.064  -7.967  1.00 12.55           C
ATOM    207  CE1 TYR    24     -38.890  41.458  -9.241  1.00 13.28           C
ATOM    208  CZ  TYR    24     -39.399  40.139  -9.303  1.00 10.43           C
ATOM    209  OH  TYR    24     -39.630  39.577 -10.572  1.00 11.31           O
ATOM    210  CE2 TYR    24     -39.713  39.475  -8.126  1.00 11.68           C
ATOM    211  CD2 TYR    24     -39.493  40.106  -6.858  1.00 14.21           C
ATOM    212  C   TYR    24     -37.080  42.970  -3.806  1.00 16.80           C
ATOM    213  O   TYR    24     -37.286  44.167  -3.939  1.00 18.89           O
ATOM    214  N   GLY    25     -36.702  42.429  -2.656  1.00 16.86           N
ATOM    215  CA  GLY    25     -36.488  43.287  -1.478  1.00 17.30           C
ATOM    216  C   GLY    25     -35.036  43.519  -1.070  1.00 18.19           C
ATOM    217  O   GLY    25     -34.787  44.141  -0.042  1.00 18.97           O
ATOM    218  N   VAL    26     -34.080  42.983  -1.822  1.00 17.80           N
ATOM    219  CA  VAL    26     -32.653  43.017  -1.434  1.00 17.86           C
ATOM    220  CB  VAL    26     -32.053  41.567  -1.526  1.00 16.88           C
ATOM    221  CG1 VAL    26     -30.493  41.578  -1.523  1.00 19.19           C
ATOM    222  CG2 VAL    26     -32.546  40.691  -0.382  1.00 17.09           C
ATOM    223  C   VAL    26     -31.896  43.951  -2.405  1.00 18.57           C
ATOM    224  O   VAL    26     -32.112  43.860  -3.619  1.00 19.26           O
ATOM    225  N   SER    27     -31.024  44.837  -1.900  1.00 18.29           N
ATOM    226  CA  SER    27     -30.188  45.651  -2.802  1.00 18.73           C
ATOM    227  CB  SER    27     -30.240  47.135  -2.451  1.00 18.20           C
ATOM    228  OG  SER    27     -29.499  47.385  -1.297  1.00 19.53           O
ATOM    229  C   SER    27     -28.743  45.196  -2.781  1.00 18.39           C
ATOM    230  O   SER    27     -28.296  44.592  -1.823  1.00 18.07           O
ATOM    231  N   ILE    28     -28.001  45.507  -3.836  1.00 18.31           N
ATOM    232  CA  ILE    28     -26.587  45.151  -3.866  1.00 18.54           C
ATOM    233  CB  ILE    28     -25.953  45.425  -5.232  1.00 18.62           C
ATOM    234  CG1 ILE    28     -24.599  44.703  -5.348  1.00 18.14           C
ATOM    235  CD1 ILE    28     -23.953  44.785  -6.743  1.00 19.13           C
ATOM    236  CG2 ILE    28     -25.915  46.963  -5.537  1.00 18.10           C
ATOM    237  C   ILE    28     -25.825  45.846  -2.714  1.00 18.97           C
ATOM    238  O   ILE    28     -24.902  45.274  -2.156  1.00 17.66           O
ATOM    239  N   ARG    29     -26.211  47.076  -2.360  1.00 19.97           N
ATOM    240  CA  ARG    29     -25.589  47.737  -1.207  1.00 22.13           C
ATOM    241  CB  ARG    29     -26.120  49.174  -1.012  1.00 21.53           C
ATOM    242  CG  ARG    29     -25.467  49.925   0.170  1.00 25.16           C
ATOM    243  CD  ARG    29     -26.316  51.109   0.743  1.00 26.22           C
ATOM    244  NE  ARG    29     -27.682  50.707   1.142  1.00 35.15           N
ATOM    245  CZ  ARG    29     -28.010  50.032   2.256  1.00 36.75           C
ATOM    246  NH1 ARG    29     -27.084  49.650   3.137  1.00 38.29           N
ATOM    247  NH2 ARG    29     -29.285  49.730   2.492  1.00 38.04           N
ATOM    248  C   ARG    29     -25.725  46.902   0.085  1.00 21.09           C
ATOM    249  O   ARG    29     -24.730  46.691   0.798  1.00 19.92           O
ATOM    250  N   GLU    30     -26.937  46.412   0.371  1.00 22.16           N
ATOM    251  CA  GLU    30     -27.160  45.541   1.551  1.00 22.56           C
ATOM    252  CB  GLU    30     -28.618  45.119   1.693  1.00 23.46           C
ATOM    253  CG  GLU    30     -29.623  46.242   1.841  1.00 28.08           C
ATOM    254  CD  GLU    30     -31.046  45.786   1.483  1.00 34.28           C
ATOM    255  OE1 GLU    30     -31.275  44.555   1.368  1.00 33.74           O
ATOM    256  OE2 GLU    30     -31.935  46.662   1.307  1.00 37.15           O
ATOM    257  C   GLU    30     -26.301  44.272   1.533  1.00 21.44           C
ATOM    258  O   GLU    30     -25.795  43.856   2.577  1.00 21.23           O
ATOM    259  N   LEU    31     -26.170  43.640   0.359  1.00 19.98           N
ATOM    260  CA  LEU    31     -25.338  42.431   0.251  1.00 18.96           C
ATOM    261  CB  LEU    31     -25.426  41.823  -1.145  1.00 18.00           C
ATOM    262  CG  LEU    31     -26.768  41.239  -1.562  1.00 18.12           C
ATOM    263  CD1 LEU    31     -26.678  40.931  -3.057  1.00 16.01           C
ATOM    264  CD2 LEU    31     -27.078  39.993  -0.744  1.00 18.33           C
ATOM    265  C   LEU    31     -23.871  42.715   0.588  1.00 18.24           C
ATOM    266  O   LEU    31     -23.227  41.984   1.363  1.00 18.55           O
ATOM    267  N   ALA    32     -23.328  43.776  -0.005  1.00 18.07           N
ATOM    268  CA  ALA    32     -21.928  44.131   0.234  1.00 17.87           C
ATOM    269  CB  ALA    32     -21.533  45.282  -0.659  1.00 17.05           C
ATOM    270  C   ALA    32     -21.689  44.449   1.719  1.00 18.48           C
ATOM    271  O   ALA    32     -20.741  43.938   2.338  1.00 18.50           O
ATOM    272  N   GLN    33     -22.577  45.264   2.282  1.00 18.14           N
ATOM    273  CA  GLN    33     -22.467  45.687   3.672  1.00 18.66           C
ATOM    274  CB  GLN    33     -23.613  46.652   4.012  1.00 18.81           C
ATOM    279  C   GLN    33     -22.496  44.452   4.579  1.00 18.25           C
ATOM    280  O   GLN    33     -21.649  44.307   5.470  1.00 19.06           O
ATOM    281  N   ALA    34     -23.456  43.552   4.355  1.00 18.35           N
ATOM    282  CA  ALA    34     -23.588  42.387   5.224  1.00 17.57           C
ATOM    283  CB  ALA    34     -24.915  41.670   4.988  1.00 18.88           C
ATOM    284  C   ALA    34     -22.400  41.424   5.094  1.00 17.93           C
ATOM    285  O   ALA    34     -22.007  40.800   6.073  1.00 18.07           O
ATOM    286  N   ALA    35     -21.812  41.324   3.902  1.00 17.59           N
ATOM    287  CA  ALA    35     -20.653  40.434   3.662  1.00 17.45           C
ATOM    288  CB  ALA    35     -20.742  39.832   2.241  1.00 17.60           C
ATOM    289  C   ALA    35     -19.271  41.084   3.858  1.00 17.39           C
ATOM    290  O   ALA    35     -18.253  40.386   3.869  1.00 17.10           O
ATOM    291  N   GLY    36     -19.216  42.410   3.975  1.00 17.53           N
ATOM    292  CA  GLY    36     -17.934  43.120   4.053  1.00 17.54           C
ATOM    293  C   GLY    36     -17.142  43.046   2.755  1.00 18.20           C
ATOM    294  O   GLY    36     -15.894  43.109   2.760  1.00 18.83           O
ATOM    295  N   ALA    37     -17.868  42.917   1.638  1.00 18.05           N
ATOM    296  CA  ALA    37     -17.298  42.947   0.287  1.00 17.70           C
ATOM    297  CB  ALA    37     -17.905  41.813  -0.553  1.00 17.69           C
ATOM    298  C   ALA    37     -17.594  44.299  -0.377  1.00 17.25           C
ATOM    299  O   ALA    37     -18.512  44.995   0.029  1.00 17.90           O
ATOM    300  N   SER    38     -16.844  44.680  -1.401  1.00 16.01           N
ATOM    301  CA  SER    38     -17.181  45.941  -2.083  1.00 15.66           C
ATOM    302  CB  SER    38     -15.986  46.530  -2.815  1.00 15.99           C
ATOM    303  OG  SER    38     -15.465  45.574  -3.709  1.00 15.63           O
ATOM    304  C   SER    38     -18.275  45.670  -3.090  1.00 15.23           C
ATOM    305  O   SER    38     -18.390  44.545  -3.568  1.00 14.69           O
ATOM    306  N   ILE    39     -19.054  46.696  -3.426  1.00 14.99           N
ATOM    307  CA  ILE    39     -20.019  46.586  -4.524  1.00 16.34           C
ATOM    308  CB  ILE    39     -20.795  47.908  -4.725  1.00 18.03           C
ATOM    309  CG1 ILE    39     -21.771  48.099  -3.551  1.00 18.95           C
ATOM    310  CD1 ILE    39     -22.260  49.551  -3.403  1.00 24.07           C
ATOM    311  CG2 ILE    39     -21.568  47.905  -6.053  1.00 19.22           C
ATOM    312  C   ILE    39     -19.321  46.142  -5.820  1.00 14.71           C
ATOM    313  O   ILE    39     -19.846  45.293  -6.544  1.00 14.07           O
ATOM    314  N   SER    40     -18.089  46.604  -6.010  0.50 14.67           N
ATOM    316  CA  SER    40     -17.279  46.176  -7.148  0.50 14.62           C
ATOM    318  CB  SER    40     -16.053  47.060  -7.335  0.50 14.94           C
ATOM    320  OG  SER    40     -16.458  48.367  -7.690  0.50 15.23           O
ATOM    322  C   SER    40     -16.894  44.691  -7.144  0.50 14.74           C
ATOM    324  O   SER    40     -17.018  44.048  -8.190  0.50 13.11           O
ATOM    326  N   MET    41     -16.429  44.140  -6.011  0.70 14.50           N
ATOM    328  CA  MET    41     -16.178  42.699  -5.979  0.70 17.69           C
ATOM    330  CB  MET    41     -15.783  42.221  -4.589  0.70 17.10           C
ATOM    332  CG  MET    41     -14.312  42.342  -4.347  0.70 22.14           C
ATOM    334  SD  MET    41     -13.942  42.349  -2.431  0.70 31.19          SE
ATOM    336  CE  MET    41     -12.415  43.576  -2.469  0.70 24.49           C
ATOM    338  C   MET    41     -17.447  41.995  -6.467  0.70 13.85           C
ATOM    340  O   MET    41     -17.391  41.116  -7.335  0.70 12.19           O
ATOM    342  N   ILE    42     -18.586  42.445  -5.946  1.00 11.54           N
ATOM    343  CA  ILE    42     -19.860  41.745  -6.191  1.00 10.80           C
ATOM    344  CB  ILE    42     -21.001  42.280  -5.316  1.00 11.27           C
ATOM    345  CG1 ILE    42     -20.695  41.978  -3.842  1.00 13.93           C
ATOM    346  CD1 ILE    42     -21.839  42.300  -2.903  1.00 16.88           C
ATOM    347  CG2 ILE    42     -22.327  41.616  -5.716  1.00 12.87           C
ATOM    348  C   ILE    42     -20.219  41.838  -7.658  1.00  8.83           C
ATOM    349  O   ILE    42     -20.497  40.819  -8.306  1.00  9.33           O
ATOM    350  N   SER    43     -20.157  43.052  -8.211  1.00  8.95           N
ATOM    351  CA  SER    43     -20.581  43.239  -9.602  1.00  9.74           C
ATOM    352  CB  SER    43     -20.655  44.729  -9.931  1.00 10.68           C
ATOM    353  OG  SER    43     -21.770  45.278  -9.279  1.00 13.08           O
ATOM    354  C   SER    43     -19.645  42.587 -10.619  1.00  9.62           C
ATOM    355  O   SER    43     -20.105  42.053 -11.624  1.00  9.13           O
ATOM    356  N   TYR    44     -18.328  42.697 -10.382  1.00  9.20           N
ATOM    357  CA  TYR    44     -17.361  42.244 -11.376  1.00 10.08           C
ATOM    358  CB  TYR    44     -16.121  43.137 -11.344  1.00  9.76           C
ATOM    359  CG  TYR    44     -16.373  44.487 -11.942  1.00  8.65           C
ATOM    360  CD1 TYR    44     -16.965  45.500 -11.184  1.00  8.93           C
ATOM    361  CE1 TYR    44     -17.202  46.730 -11.711  1.00 10.45           C
ATOM    362  CZ  TYR    44     -16.853  46.987 -13.027  1.00 10.79           C
ATOM    363  OH  TYR    44     -17.090  48.220 -13.553  1.00 11.57           O
ATOM    364  CE2 TYR    44     -16.260  46.002 -13.818  1.00 10.86           C
ATOM    365  CD2 TYR    44     -16.019  44.758 -13.255  1.00  9.35           C
ATOM    366  C   TYR    44     -16.923  40.795 -11.222  1.00 12.28           C
ATOM    367  O   TYR    44     -16.468  40.193 -12.203  1.00 12.21           O
ATOM    368  N   HIS    45     -16.993  40.271 -10.000  1.00 14.53           N
ATOM    369  CA  HIS    45     -16.489  38.928  -9.730  1.00 17.90           C
ATOM    370  CB  HIS    45     -15.347  38.951  -8.714  1.00 18.81           C
ATOM    371  CG  HIS    45     -14.062  39.424  -9.294  1.00 21.69           C
ATOM    372  ND1 HIS    45     -13.118  40.111  -8.564  1.00 26.38           N
ATOM    373  CE1 HIS    45     -12.092  40.405  -9.346  1.00 27.60           C
ATOM    374  NE2 HIS    45     -12.350  39.958 -10.563  1.00 26.67           N
ATOM    375  CD2 HIS    45     -13.574  39.339 -10.558  1.00 25.29           C
ATOM    376  C   HIS    45     -17.532  37.898  -9.348  1.00 19.42           C
ATOM    377  O   HIS    45     -17.334  36.722  -9.630  1.00 19.75           O
ATOM    378  N   PHE    46     -18.630  38.324  -8.726  1.00 20.52           N
ATOM    379  CA  PHE    46     -19.661  37.377  -8.261  1.00 22.82           C
ATOM    380  CB  PHE    46     -19.800  37.465  -6.732  1.00 23.98           C
ATOM    381  CG  PHE    46     -18.496  37.308  -6.003  1.00 26.04           C
ATOM    382  CD1 PHE    46     -18.012  36.039  -5.670  1.00 29.01           C
ATOM    383  CE1 PHE    46     -16.817  35.893  -5.005  1.00 27.12           C
ATOM    384  CZ  PHE    46     -16.071  37.013  -4.649  1.00 28.27           C
ATOM    385  CE2 PHE    46     -16.542  38.280  -4.963  1.00 29.34           C
ATOM    386  CD2 PHE    46     -17.743  38.419  -5.640  1.00 27.17           C
ATOM    387  C   PHE    46     -21.004  37.504  -8.954  1.00 22.70           C
ATOM    388  O   PHE    46     -22.017  36.978  -8.483  1.00 25.73           O
ATOM    389  N   GLY    47     -21.020  38.197 -10.083  1.00 20.71           N
ATOM    390  CA  GLY    47     -22.178  38.260 -10.943  1.00 19.73           C
ATOM    391  C   GLY    47     -23.257  39.227 -10.550  1.00 18.52           C
ATOM    392  O   GLY    47     -24.373  39.148 -11.073  1.00 20.99           O
ATOM    393  N   GLY    48     -22.955  40.137  -9.620  1.00 14.66           N
ATOM    394  CA  GLY    48     -23.926  41.115  -9.145  1.00 14.41           C
ATOM    395  C   GLY    48     -25.035  40.479  -8.295  1.00 13.29           C
ATOM    396  O   GLY    48     -24.959  39.296  -7.948  1.00 12.06           O
ATOM    397  N   LYS    49     -26.021  41.290  -7.929  1.00 13.51           N
ATOM    398  CA  LYS    49     -27.206  40.794  -7.200  1.00 13.00           C
ATOM    399  CB  LYS    49     -28.212  41.934  -7.086  1.00 14.01           C
ATOM    400  CG  LYS    49     -29.503  41.518  -6.350  1.00 15.37           C
ATOM    401  CD  LYS    49     -30.528  42.649  -6.447  1.00 16.73           C
ATOM    402  CE  LYS    49     -31.905  42.078  -6.083  1.00 17.71           C
ATOM    403  NZ  LYS    49     -32.895  43.218  -6.101  1.00 18.77           N
ATOM    404  C   LYS    49     -27.809  39.595  -7.932  1.00 13.68           C
ATOM    405  O   LYS    49     -28.212  38.583  -7.331  1.00 13.27           O
ATOM    406  N   GLU    50     -27.876  39.703  -9.258  1.00 12.63           N
ATOM    407  CA  GLU    50     -28.627  38.725 -10.042  1.00 12.69           C
ATOM    408  CB  GLU    50     -28.814  39.232 -11.468  1.00 13.68           C
ATOM    409  CG  GLU    50     -29.657  40.500 -11.528  1.00 14.16           C
ATOM    410  CD  GLU    50     -28.887  41.815 -11.286  1.00 16.98           C
ATOM    411  OE1 GLU    50     -27.638  41.867 -11.018  1.00 15.01           O
ATOM    412  OE2 GLU    50     -29.566  42.854 -11.451  1.00 19.39           O
ATOM    413  C   GLU    50     -27.883  37.393 -10.048  1.00 12.35           C
ATOM    414  O   GLU    50     -28.506  36.350  -9.816  1.00 13.25           O
ATOM    415  N   GLY    51     -26.567  37.455 -10.306  1.00 11.97           N
ATOM    416  CA  GLY    51     -25.695  36.286 -10.303  1.00 11.39           C
ATOM    417  C   GLY    51     -25.724  35.592  -8.952  1.00 13.31           C
ATOM    418  O   GLY    51     -25.865  34.369  -8.874  1.00 12.68           O
ATOM    419  N   LEU    52     -25.637  36.365  -7.877  1.00 12.96           N
ATOM    420  CA  LEU    52     -25.702  35.752  -6.544  1.00 13.84           C
ATOM    421  CB  LEU    52     -25.453  36.774  -5.450  1.00 13.00           C
ATOM    422  CG  LEU    52     -24.017  37.257  -5.300  1.00 15.32           C
ATOM    423  CD1 LEU    52     -24.026  38.415  -4.321  1.00 17.15           C
ATOM    424  CD2 LEU    52     -23.089  36.110  -4.862  1.00 13.25           C
ATOM    425  C   LEU    52     -27.047  35.092  -6.282  1.00 13.75           C
ATOM    426  O   LEU    52     -27.092  34.016  -5.680  1.00 14.21           O
ATOM    427  N   TYR    53     -28.140  35.744  -6.693  1.00 14.29           N
ATOM    428  CA  TYR    53     -29.441  35.176  -6.517  1.00 14.44           C
ATOM    429  CB  TYR    53     -30.541  36.161  -6.936  1.00 12.90           C
ATOM    430  CG  TYR    53     -31.928  35.606  -6.681  1.00 13.47           C
ATOM    431  CD1 TYR    53     -32.405  35.437  -5.365  1.00 13.59           C
ATOM    432  CE1 TYR    53     -33.679  34.910  -5.123  1.00 14.34           C
ATOM    433  CZ  TYR    53     -34.477  34.537  -6.198  1.00 13.72           C
ATOM    434  OH  TYR    53     -35.718  34.039  -5.965  1.00 13.83           O
ATOM    435  CE2 TYR    53     -34.023  34.711  -7.525  1.00 13.18           C
ATOM    436  CD2 TYR    53     -32.751  35.220  -7.740  1.00 11.75           C
ATOM    437  C   TYR    53     -29.578  33.863  -7.306  1.00 14.35           C
ATOM    438  O   TYR    53     -30.064  32.892  -6.754  1.00 14.84           O
ATOM    439  N   ALA    54     -29.125  33.849  -8.569  1.00 14.57           N
ATOM    440  CA  ALA    54     -29.145  32.612  -9.394  1.00 14.76           C
ATOM    441  CB  ALA    54     -28.572  32.882 -10.785  1.00 15.38           C
ATOM    442  C   ALA    54     -28.382  31.465  -8.737  1.00 16.02           C
ATOM    443  O   ALA    54     -28.853  30.302  -8.752  1.00 16.58           O
ATOM    444  N   ALA    55     -27.206  31.790  -8.179  1.00 15.71           N
ATOM    445  CA  ALA    55     -26.349  30.797  -7.512  1.00 16.60           C
ATOM    446  CB  ALA    55     -24.985  31.418  -7.114  1.00 15.94           C
ATOM    447  C   ALA    55     -27.087  30.239  -6.293  1.00 16.62           C
ATOM    448  O   ALA    55     -27.124  29.027  -6.079  1.00 17.79           O
ATOM    449  N   VAL    56     -27.698  31.121  -5.509  1.00 16.55           N
ATOM    450  CA  VAL    56     -28.442  30.724  -4.309  1.00 17.16           C
ATOM    451  CB  VAL    56     -28.958  31.984  -3.551  1.00 17.77           C
ATOM    452  CG1 VAL    56     -30.068  31.623  -2.591  1.00 18.51           C
ATOM    453  CG2 VAL    56     -27.808  32.716  -2.799  1.00 16.47           C
ATOM    454  C   VAL    56     -29.643  29.805  -4.680  1.00 17.90           C
ATOM    455  O   VAL    56     -29.872  28.769  -4.064  1.00 18.42           O
ATOM    456  N   LEU    57     -30.409  30.209  -5.690  1.00 18.83           N
ATOM    457  CA  LEU    57     -31.588  29.428  -6.064  1.00 20.44           C
ATOM    458  CB  LEU    57     -32.429  30.224  -7.058  1.00 19.98           C
ATOM    459  CG  LEU    57     -33.922  29.962  -7.106  1.00 25.44           C
ATOM    460  CD1 LEU    57     -34.592  30.145  -5.755  1.00 24.83           C
ATOM    461  CD2 LEU    57     -34.480  30.939  -8.118  1.00 27.85           C
ATOM    462  C   LEU    57     -31.165  28.050  -6.627  1.00 20.90           C
ATOM    463  O   LEU    57     -31.808  27.031  -6.345  1.00 20.75           O
ATOM    464  N   GLN    58     -30.052  28.016  -7.360  1.00 21.09           N
ATOM    465  CA  GLN    58     -29.551  26.768  -7.929  1.00 22.36           C
ATOM    466  CB  GLN    58     -28.346  26.998  -8.858  1.00 23.54           C
ATOM    467  CG  GLN    58     -27.960  25.733  -9.635  1.00 27.99           C
ATOM    468  CD  GLN    58     -29.191  25.021 -10.220  1.00 35.26           C
ATOM    469  OE1 GLN    58     -29.888  25.570 -11.083  1.00 37.09           O
ATOM    470  NE2 GLN    58     -29.469  23.796  -9.736  1.00 38.37           N
ATOM    471  C   GLN    58     -29.205  25.793  -6.803  1.00 22.27           C
ATOM    472  O   GLN    58     -29.522  24.575  -6.887  1.00 22.87           O
ATOM    473  N   GLU    59     -28.579  26.306  -5.741  0.50 21.38           N
ATOM    475  CA  GLU    59     -28.271  25.503  -4.553  0.50 21.43           C
ATOM    477  CB  GLU    59     -27.388  26.269  -3.553  0.50 21.44           C
ATOM    479  CG  GLU    59     -26.869  25.393  -2.378  0.50 21.69           C
ATOM    481  CD  GLU    59     -26.114  26.171  -1.293  0.50 22.85           C
ATOM    483  OE1 GLU    59     -25.921  27.400  -1.427  0.50 25.49           O
ATOM    485  OE2 GLU    59     -25.705  25.539  -0.292  0.50 22.88           O
ATOM    487  C   GLU    59     -29.535  25.040  -3.848  0.50 20.81           C
ATOM    489  O   GLU    59     -29.586  23.907  -3.359  0.50 20.84           O
ATOM    491  N   GLN    60     -30.526  25.927  -3.763  1.00 20.01           N
ATOM    492  CA  GLN    60     -31.823  25.588  -3.146  1.00 20.01           C
ATOM    493  CB  GLN    60     -32.751  26.812  -3.069  1.00 18.91           C
ATOM    494  CG  GLN    60     -32.254  27.942  -2.169  1.00 22.57           C
ATOM    495  CD  GLN    60     -32.132  27.523  -0.695  1.00 23.52           C
ATOM    496  OE1 GLN    60     -33.063  26.939  -0.124  1.00 25.17           O
ATOM    497  NE2 GLN    60     -30.987  27.798  -0.090  1.00 23.26           N
ATOM    498  C   GLN    60     -32.527  24.444  -3.865  1.00 18.38           C
ATOM    499  O   GLN    60     -33.135  23.578  -3.222  1.00 19.77           O
ATOM    500  N   PHE    61     -32.428  24.422  -5.192  1.00 18.84           N
ATOM    501  CA  PHE    61     -33.171  23.452  -5.980  1.00 18.05           C
ATOM    502  CB  PHE    61     -33.920  24.171  -7.089  1.00 18.50           C
ATOM    503  CG  PHE    61     -35.166  24.855  -6.603  1.00 16.29           C
ATOM    504  CD1 PHE    61     -35.097  26.142  -6.066  1.00 16.96           C
ATOM    505  CE1 PHE    61     -36.246  26.777  -5.586  1.00 17.57           C
ATOM    506  CZ  PHE    61     -37.469  26.128  -5.639  1.00 16.05           C
ATOM    507  CE2 PHE    61     -37.562  24.840  -6.149  1.00 16.94           C
ATOM    508  CD2 PHE    61     -36.415  24.206  -6.655  1.00 16.84           C
ATOM    509  C   PHE    61     -32.316  22.293  -6.529  1.00 18.86           C
ATOM    510  O   PHE    61     -32.799  21.474  -7.288  1.00 17.68           O
ATOM    511  N   ALA    62     -31.039  22.250  -6.153  1.00 19.75           N
ATOM    512  CA  ALA    62     -30.116  21.245  -6.684  1.00 20.70           C
ATOM    513  CB  ALA    62     -28.776  21.377  -5.988  1.00 21.27           C
ATOM    514  C   ALA    62     -30.639  19.784  -6.602  1.00 21.89           C
ATOM    515  O   ALA    62     -30.568  19.023  -7.588  1.00 22.43           O
ATOM    516  N   CYS    63     -31.180  19.433  -5.431  0.50 22.09           N
ATOM    518  CA  CYS    63     -31.713  18.088  -5.137  0.50 22.45           C
ATOM    520  CB  CYS    63     -32.194  18.002  -3.682  0.50 21.93           C
ATOM    522  SG  CYS    63     -30.917  17.628  -2.464  0.50 27.26           S
ATOM    524  C   CYS    63     -32.836  17.625  -6.072  0.50 21.59           C
ATOM    526  O   CYS    63     -33.089  16.419  -6.196  0.50 20.76           O
ATOM    528  N   PHE    64     -33.520  18.570  -6.711  1.00 20.75           N
ATOM    529  CA  PHE    64     -34.567  18.235  -7.659  1.00 20.96           C
ATOM    530  CB  PHE    64     -35.405  19.451  -8.035  1.00 19.37           C
ATOM    531  CG  PHE    64     -36.415  19.870  -6.996  1.00 19.26           C
ATOM    532  CD1 PHE    64     -36.028  20.573  -5.872  1.00 19.73           C
ATOM    533  CE1 PHE    64     -36.994  21.017  -4.934  1.00 18.87           C
ATOM    534  CZ  PHE    64     -38.331  20.739  -5.155  1.00 17.71           C
ATOM    535  CE2 PHE    64     -38.722  20.056  -6.260  1.00 18.01           C
ATOM    536  CD2 PHE    64     -37.778  19.643  -7.202  1.00 18.03           C
ATOM    537  C   PHE    64     -34.008  17.587  -8.957  1.00 21.96           C
ATOM    538  O   PHE    64     -34.743  16.934  -9.688  1.00 23.37           O
ATOM    539  N   GLY    65     -32.716  17.728  -9.209  1.00 22.10           N
ATOM    540  CA  GLY    65     -32.106  17.074 -10.371  1.00 23.22           C
ATOM    541  C   GLY    65     -31.577  15.697 -10.034  1.00 24.11           C
ATOM    542  O   GLY    65     -30.930  15.040 -10.873  1.00 24.63           O
ATOM    543  N   GLN    66     -31.841  15.266  -8.802  1.00 24.05           N
ATOM    544  CA  GLN    66     -31.357  13.993  -8.283  1.00 24.54           C
ATOM    545  CB  GLN    66     -30.285  14.241  -7.234  1.00 25.47           C
ATOM    546  CG  GLN    66     -28.910  14.511  -7.854  1.00 30.42           C
ATOM    547  CD  GLN    66     -28.001  15.342  -6.962  1.00 36.44           C
ATOM    548  OE1 GLN    66     -28.382  16.421  -6.479  1.00 39.74           O
ATOM    549  NE2 GLN    66     -26.784  14.859  -6.761  1.00 37.88           N
ATOM    550  C   GLN    66     -32.519  13.185  -7.688  1.00 23.92           C
ATOM    551  O   GLN    66     -32.671  13.075  -6.467  1.00 23.62           O
ATOM    552  N   LEU    67     -33.319  12.616  -8.579  1.00 22.78           N
ATOM    553  CA  LEU    67     -34.545  11.916  -8.200  1.00 21.55           C
ATOM    554  CB  LEU    67     -35.668  12.370  -9.128  1.00 21.58           C
ATOM    555  CG  LEU    67     -35.860  13.887  -9.236  1.00 21.33           C
ATOM    556  CD1 LEU    67     -36.995  14.155 -10.180  1.00 22.06           C
ATOM    557  CD2 LEU    67     -36.147  14.475  -7.858  1.00 21.71           C
ATOM    558  C   LEU    67     -34.455  10.391  -8.219  1.00 21.26           C
ATOM    559  O   LEU    67     -35.485   9.730  -8.205  1.00 20.77           O
ATOM    560  N   ASP    68     -33.243   9.827  -8.209  1.00 20.58           N
ATOM    561  CA  ASP    68     -33.066   8.375  -8.336  1.00 21.06           C
ATOM    562  CB  ASP    68     -31.588   8.003  -8.545  1.00 22.43           C
ATOM    563  CG  ASP    68     -31.143   8.118 -10.019  1.00 25.47           C
ATOM    564  OD1 ASP    68     -32.015   8.221 -10.922  1.00 30.33           O
ATOM    565  OD2 ASP    68     -29.915   8.103 -10.278  1.00 28.49           O
ATOM    566  C   ASP    68     -33.707   7.551  -7.191  1.00 21.11           C
ATOM    567  O   ASP    68     -34.136   6.420  -7.409  1.00 20.72           O
ATOM    568  N   ASP    69     -33.790   8.106  -5.981  1.00 20.70           N
ATOM    569  CA  ASP    69     -34.499   7.393  -4.890  1.00 21.27           C
ATOM    570  CB  ASP    69     -34.371   8.149  -3.562  1.00 22.13           C
ATOM    571  CG  ASP    69     -32.986   8.014  -2.948  1.00 24.48           C
ATOM    572  OD1 ASP    69     -32.312   6.996  -3.200  1.00 27.84           O
ATOM    573  OD2 ASP    69     -32.581   8.940  -2.220  1.00 28.42           O
ATOM    574  C   ASP    69     -35.988   7.188  -5.201  1.00 20.42           C
ATOM    575  O   ASP    69     -36.621   6.239  -4.725  1.00 20.59           O
ATOM    576  N   ILE    70     -36.539   8.100  -5.989  1.00 19.38           N
ATOM    577  CA  ILE    70     -37.928   7.992  -6.429  1.00 18.85           C
ATOM    578  CB  ILE    70     -38.556   9.366  -6.619  1.00 18.52           C
ATOM    579  CG1 ILE    70     -38.411  10.193  -5.323  1.00 21.19           C
ATOM    580  CD1 ILE    70     -38.809  11.665  -5.486  1.00 21.34           C
ATOM    581  CG2 ILE    70     -40.039   9.235  -6.997  1.00 19.97           C
ATOM    582  C   ILE    70     -38.014   7.194  -7.726  1.00 17.62           C
ATOM    583  O   ILE    70     -38.761   6.225  -7.804  1.00 18.07           O
ATOM    584  N   ARG    71     -37.271   7.614  -8.747  1.00 16.37           N
ATOM    585  CA  ARG    71     -37.312   6.918 -10.054  1.00 16.19           C
ATOM    586  CB  ARG    71     -36.314   7.527 -11.036  1.00 16.11           C
ATOM    587  CG  ARG    71     -36.578   8.965 -11.418  1.00 19.99           C
ATOM    588  CD  ARG    71     -35.754   9.340 -12.654  1.00 23.24           C
ATOM    589  NE  ARG    71     -35.827  10.770 -12.961  1.00 25.78           N
ATOM    590  CZ  ARG    71     -36.850  11.371 -13.583  1.00 28.05           C
ATOM    591  NH1 ARG    71     -37.910  10.665 -13.975  1.00 28.38           N
ATOM    592  NH2 ARG    71     -36.818  12.683 -13.821  1.00 22.66           N
ATOM    593  C   ARG    71     -36.981   5.449  -9.914  1.00 14.93           C
ATOM    594  O   ARG    71     -37.529   4.587 -10.637  1.00 13.88           O
ATOM    595  N   GLY    72     -36.074   5.141  -8.978  1.00 14.49           N
ATOM    596  CA  GLY    72     -35.604   3.763  -8.809  1.00 13.79           C
ATOM    597  C   GLY    72     -36.685   2.791  -8.352  1.00 14.28           C
ATOM    598  O   GLY    72     -36.498   1.596  -8.465  1.00 15.03           O
ATOM    599  N   GLN    73     -37.809   3.316  -7.844  1.00 13.08           N
ATOM    600  CA  GLN    73     -38.965   2.522  -7.381  1.00 13.26           C
ATOM    601  CB  GLN    73     -39.651   3.251  -6.211  1.00 13.37           C
ATOM    602  CG  GLN    73     -38.783   3.419  -4.979  1.00 16.75           C
ATOM    603  CD  GLN    73     -38.147   2.137  -4.546  1.00 21.82           C
ATOM    604  OE1 GLN    73     -38.813   1.105  -4.424  1.00 22.36           O
ATOM    605  NE2 GLN    73     -36.834   2.173  -4.334  1.00 26.08           N
ATOM    606  C   GLN    73     -40.037   2.290  -8.454  1.00 12.89           C
ATOM    607  O   GLN    73     -41.041   1.624  -8.204  1.00 12.88           O
ATOM    608  N   ALA    74     -39.844   2.871  -9.636  1.00 12.26           N
ATOM    609  CA  ALA    74     -40.800   2.693 -10.736  1.00 12.16           C
ATOM    610  CB  ALA    74     -40.216   3.279 -12.015  1.00 12.22           C
ATOM    611  C   ALA    74     -41.152   1.219 -10.951  1.00 12.26           C
ATOM    612  O   ALA    74     -40.261   0.342 -10.903  1.00 11.19           O
ATOM    613  N   GLY    75     -42.429   0.939 -11.235  1.00 11.65           N
ATOM    614  CA  GLY    75     -42.868  -0.466 -11.342  1.00 10.70           C
ATOM    615  C   GLY    75     -43.731  -0.790 -10.118  1.00 11.25           C
ATOM    616  O   GLY    75     -44.484  -1.762 -10.116  1.00 11.59           O
ATOM    617  N   ASP    76     -43.570  -0.008  -9.043  1.00 12.06           N
ATOM    618  CA  ASP    76     -44.360  -0.166  -7.824  1.00 12.36           C
ATOM    619  CB  ASP    76     -43.487  -0.827  -6.733  1.00 12.42           C
ATOM    620  CG  ASP    76     -44.202  -1.022  -5.400  1.00 15.66           C
ATOM    621  OD1 ASP    76     -45.317  -0.484  -5.151  1.00 16.24           O
ATOM    622  OD2 ASP    76     -43.604  -1.751  -4.566  1.00 15.57           O
ATOM    623  C   ASP    76     -44.849   1.223  -7.391  1.00 12.68           C
ATOM    624  O   ASP    76     -44.129   1.931  -6.685  1.00 11.41           O
ATOM    625  N   PRO    77     -46.043   1.647  -7.879  1.00 13.71           N
ATOM    626  CA  PRO    77     -46.488   3.033  -7.645  1.00 13.93           C
ATOM    627  CB  PRO    77     -47.873   3.103  -8.333  1.00 13.23           C
ATOM    628  CG  PRO    77     -47.761   2.072  -9.458  1.00 15.27           C
ATOM    629  CD  PRO    77     -46.977   0.920  -8.766  1.00 14.18           C
ATOM    630  C   PRO    77     -46.533   3.405  -6.182  1.00 13.31           C
ATOM    631  O   PRO    77     -46.184   4.524  -5.838  1.00 13.85           O
ATOM    632  N   LEU    78     -46.946   2.477  -5.319  0.50 13.21           N
ATOM    634  CA  LEU    78     -46.992   2.787  -3.889  0.50 13.74           C
ATOM    636  CB  LEU    78     -47.582   1.617  -3.103  0.50 13.51           C
ATOM    638  CG  LEU    78     -48.457   1.997  -1.907  0.50 14.73           C
ATOM    640  CD1 LEU    78     -49.147   0.741  -1.413  0.50 17.25           C
ATOM    642  CD2 LEU    78     -47.650   2.638  -0.804  0.50 19.04           C
ATOM    644  C   LEU    78     -45.602   3.124  -3.366  0.50 13.01           C
ATOM    646  O   LEU    78     -45.444   4.072  -2.614  0.50 12.86           O
ATOM    648  N   ALA    79     -44.598   2.339  -3.761  1.00 13.15           N
ATOM    649  CA  ALA    79     -43.203   2.602  -3.355  1.00 13.03           C
ATOM    650  CB  ALA    79     -42.284   1.481  -3.789  1.00 13.22           C
ATOM    651  C   ALA    79     -42.705   3.953  -3.901  1.00 12.54           C
ATOM    652  O   ALA    79     -41.949   4.654  -3.228  1.00 12.09           O
ATOM    653  N   VAL    80     -43.099   4.301  -5.131  1.00 11.58           N
ATOM    654  CA  VAL    80     -42.787   5.630  -5.672  1.00 12.21           C
ATOM    655  CB  VAL    80     -43.296   5.773  -7.101  1.00 11.22           C
ATOM    656  CG1 VAL    80     -43.163   7.227  -7.624  1.00 12.32           C
ATOM    657  CG2 VAL    80     -42.538   4.787  -8.035  1.00 10.84           C
ATOM    658  C   VAL    80     -43.376   6.760  -4.777  1.00 13.05           C
ATOM    659  O   VAL    80     -42.668   7.710  -4.420  1.00 13.23           O
ATOM    660  N   MET    81     -44.661   6.646  -4.436  0.70 12.38           N
ATOM    662  CA  MET    81     -45.330   7.668  -3.603  0.70 12.69           C
ATOM    664  CB  MET    81     -46.833   7.394  -3.427  0.70 13.82           C
ATOM    666  CG  MET    81     -47.597   7.155  -4.747  0.70 14.01           C
ATOM    668  SD  MET    81     -47.622   8.670  -5.960  0.70 21.09          SE
ATOM    670  CE  MET    81     -47.084   7.612  -7.496  0.70 15.28           C
ATOM    672  C   MET    81     -44.684   7.771  -2.235  0.70 13.11           C
ATOM    674  O   MET    81     -44.538   8.886  -1.698  0.70 12.95           O
ATOM    676  N   THR    82     -44.336   6.621  -1.655  1.00 11.97           N
ATOM    677  CA  THR    82     -43.690   6.575  -0.342  1.00 13.13           C
ATOM    678  CB  THR    82     -43.605   5.113   0.176  1.00 12.76           C
ATOM    679  OG1 THR    82     -44.931   4.563   0.297  1.00 13.08           O
ATOM    680  CG2 THR    82     -42.926   5.051   1.546  1.00 12.65           C
ATOM    681  C   THR    82     -42.311   7.220  -0.401  1.00 12.27           C
ATOM    682  O   THR    82     -41.988   8.047   0.443  1.00 12.09           O
ATOM    683  N   ALA    83     -41.522   6.874  -1.419  1.00 12.10           N
ATOM    684  CA  ALA    83     -40.189   7.455  -1.613  1.00 12.71           C
ATOM    685  CB  ALA    83     -39.469   6.804  -2.772  1.00 13.64           C
ATOM    686  C   ALA    83     -40.256   8.962  -1.829  1.00 13.31           C
ATOM    687  O   ALA    83     -39.424   9.717  -1.293  1.00 13.65           O
ATOM    688  N   TYR    84     -41.234   9.393  -2.621  1.00 12.01           N
ATOM    689  CA  TYR    84     -41.450  10.829  -2.827  1.00 11.80           C
ATOM    690  CB  TYR    84     -42.626  11.070  -3.785  1.00 11.47           C
ATOM    691  CG  TYR    84     -43.055  12.503  -3.698  1.00 11.01           C
ATOM    692  CD1 TYR    84     -42.230  13.514  -4.207  1.00  9.70           C
ATOM    693  CE1 TYR    84     -42.562  14.853  -4.058  1.00  7.72           C
ATOM    694  CZ  TYR    84     -43.777  15.207  -3.416  1.00  9.90           C
ATOM    695  OH  TYR    84     -44.090  16.520  -3.245  1.00  9.60           O
ATOM    696  CE2 TYR    84     -44.606  14.228  -2.886  1.00 10.03           C
ATOM    697  CD2 TYR    84     -44.241  12.867  -3.033  1.00  8.93           C
ATOM    698  C   TYR    84     -41.702  11.542  -1.464  1.00 11.96           C
ATOM    699  O   TYR    84     -41.113  12.588  -1.195  1.00 11.13           O
ATOM    700  N   LEU    85     -42.594  11.008  -0.646  1.00 10.86           N
ATOM    701  CA  LEU    85     -42.868  11.627   0.683  1.00 10.85           C
ATOM    702  CB  LEU    85     -44.003  10.908   1.396  1.00 10.34           C
ATOM    703  CG  LEU    85     -45.392  11.039   0.735  1.00 11.08           C
ATOM    704  CD1 LEU    85     -46.412  10.164   1.470  1.00 14.10           C
ATOM    705  CD2 LEU    85     -45.840  12.513   0.824  1.00 11.81           C
ATOM    706  C   LEU    85     -41.608  11.688   1.547  1.00 10.59           C
ATOM    707  O   LEU    85     -41.299  12.737   2.160  1.00  9.89           O
ATOM    708  N   ARG    86     -40.890  10.577   1.613  1.00 11.70           N
ATOM    709  CA  ARG    86     -39.686  10.504   2.430  1.00 12.21           C
ATOM    710  CB  ARG    86     -39.118   9.092   2.407  1.00 13.48           C
ATOM    711  CG  ARG    86     -38.070   8.880   3.462  1.00 16.80           C
ATOM    712  CD  ARG    86     -37.752   7.377   3.627  1.00 18.02           C
ATOM    713  NE  ARG    86     -38.810   6.676   4.350  1.00 20.50           N
ATOM    714  CZ  ARG    86     -39.556   5.706   3.833  1.00 23.33           C
ATOM    715  NH1 ARG    86     -39.354   5.300   2.584  1.00 26.93           N
ATOM    716  NH2 ARG    86     -40.472   5.111   4.589  1.00 24.38           N
ATOM    717  C   ARG    86     -38.635  11.526   1.947  1.00 11.94           C
ATOM    718  O   ARG    86     -37.985  12.202   2.764  1.00 11.86           O
ATOM    719  N   TRP    87     -38.462  11.595   0.637  1.00 11.06           N
ATOM    720  CA  TRP    87     -37.511  12.517   0.011  1.00 11.54           C
ATOM    721  CB  TRP    87     -37.513  12.276  -1.518  1.00 11.78           C
ATOM    722  CG  TRP    87     -36.670  13.219  -2.336  1.00 11.45           C
ATOM    723  CD1 TRP    87     -35.298  13.232  -2.473  1.00 12.95           C
ATOM    724  NE1 TRP    87     -34.914  14.228  -3.355  1.00 11.75           N
ATOM    725  CE2 TRP    87     -36.041  14.867  -3.805  1.00 12.69           C
ATOM    726  CD2 TRP    87     -37.162  14.253  -3.195  1.00 12.32           C
ATOM    727  CE3 TRP    87     -38.448  14.715  -3.505  1.00 13.71           C
ATOM    728  CZ3 TRP    87     -38.582  15.767  -4.386  1.00 13.30           C
ATOM    729  CH2 TRP    87     -37.436  16.377  -4.989  1.00 14.32           C
ATOM    730  CZ2 TRP    87     -36.166  15.944  -4.703  1.00 14.12           C
ATOM    731  C   TRP    87     -37.904  13.972   0.307  1.00 11.68           C
ATOM    732  O   TRP    87     -37.046  14.801   0.617  1.00 11.77           O
ATOM    733  N   THR    88     -39.191  14.280   0.183  1.00 11.01           N
ATOM    734  CA  THR    88     -39.685  15.654   0.390  1.00 11.22           C
ATOM    735  CB  THR    88     -41.147  15.790  -0.053  1.00 12.10           C
ATOM    736  OG1 THR    88     -41.220  15.503  -1.460  1.00 12.19           O
ATOM    737  CG2 THR    88     -41.678  17.220   0.199  1.00 12.36           C
ATOM    738  C   THR    88     -39.498  16.086   1.853  1.00 10.14           C
ATOM    739  O   THR    88     -39.045  17.207   2.119  1.00  9.63           O
ATOM    740  N   ILE    89     -39.826  15.192   2.778  1.00 10.71           N
ATOM    741  CA  ILE    89     -39.609  15.477   4.191  1.00 11.44           C
ATOM    742  CB  ILE    89     -40.178  14.352   5.067  1.00 11.62           C
ATOM    743  CG1 ILE    89     -41.718  14.377   4.949  1.00 10.67           C
ATOM    744  CD1 ILE    89     -42.368  13.154   5.612  1.00 14.32           C
ATOM    745  CG2 ILE    89     -39.752  14.574   6.521  1.00  9.76           C
ATOM    746  C   ILE    89     -38.108  15.719   4.470  1.00 11.65           C
ATOM    747  O   ILE    89     -37.748  16.702   5.123  1.00 10.49           O
ATOM    748  N   GLN    90     -37.253  14.832   3.946  0.60 11.78           N
ATOM    750  CA  GLN    90     -35.805  15.009   4.058  0.60 12.90           C
ATOM    752  CB  GLN    90     -35.059  13.906   3.294  0.60 13.23           C
ATOM    754  CG  GLN    90     -33.581  13.882   3.617  0.60 18.71           C
ATOM    756  CD  GLN    90     -33.320  13.696   5.114  0.60 24.36           C
ATOM    758  OE1 GLN    90     -32.857  14.615   5.797  0.60 28.60           O
ATOM    760  NE2 GLN    90     -33.626  12.502   5.631  0.60 27.22           N
ATOM    762  C   GLN    90     -35.349  16.402   3.563  0.60 12.09           C
ATOM    764  O   GLN    90     -34.599  17.104   4.235  0.60 11.76           O
ATOM    766  N   ARG    91     -35.849  16.798   2.401  1.00 12.06           N
ATOM    767  CA  ARG    91     -35.481  18.070   1.792  1.00 11.96           C
ATOM    768  CB  ARG    91     -36.237  18.253   0.485  1.00 13.06           C
ATOM    769  CG  ARG    91     -35.579  17.519  -0.624  1.00 17.79           C
ATOM    770  CD  ARG    91     -36.116  18.032  -1.972  1.00 20.49           C
ATOM    771  NE  ARG    91     -37.524  17.695  -2.235  1.00 21.73           N
ATOM    772  CZ  ARG    91     -38.542  18.563  -2.176  1.00 22.41           C
ATOM    773  NH1 ARG    91     -39.778  18.166  -2.519  1.00 18.87           N
ATOM    774  NH2 ARG    91     -38.328  19.821  -1.792  1.00 17.44           N
ATOM    775  C   ARG    91     -35.787  19.210   2.737  1.00 11.92           C
ATOM    776  O   ARG    91     -34.954  20.120   2.929  1.00 11.63           O
ATOM    777  N   HIS    92     -36.985  19.171   3.324  1.00 11.45           N
ATOM    778  CA  HIS    92     -37.369  20.231   4.257  1.00 12.36           C
ATOM    779  CB  HIS    92     -38.873  20.203   4.534  1.00 13.78           C
ATOM    780  CG  HIS    92     -39.696  20.557   3.336  1.00 14.40           C
ATOM    781  ND1 HIS    92     -39.591  21.777   2.684  1.00 19.47           N
ATOM    782  CE1 HIS    92     -40.452  21.801   1.674  1.00 21.35           C
ATOM    783  NE2 HIS    92     -41.103  20.649   1.649  1.00 16.69           N
ATOM    784  CD2 HIS    92     -40.635  19.846   2.660  1.00 16.03           C
ATOM    785  C   HIS    92     -36.565  20.215   5.544  1.00 12.15           C
ATOM    786  O   HIS    92     -36.192  21.268   6.056  1.00 11.95           O
ATOM    787  N   ARG    93     -36.254  19.030   6.054  1.00 11.79           N
ATOM    788  CA  ARG    93     -35.455  18.958   7.286  1.00 12.70           C
ATOM    789  CB  ARG    93     -35.461  17.537   7.853  1.00 12.66           C
ATOM    790  CG  ARG    93     -36.858  17.020   8.266  1.00 13.84           C
ATOM    791  CD  ARG    93     -37.401  17.762   9.453  1.00 18.09           C
ATOM    792  NE  ARG    93     -38.685  17.215   9.878  1.00 17.47           N
ATOM    793  CZ  ARG    93     -39.526  17.858  10.676  1.00 16.59           C
ATOM    794  NH1 ARG    93     -39.223  19.072  11.110  1.00 17.37           N
ATOM    795  NH2 ARG    93     -40.666  17.281  11.023  1.00 15.53           N
ATOM    796  C   ARG    93     -34.025  19.435   7.057  1.00 13.20           C
ATOM    797  O   ARG    93     -33.450  20.125   7.905  1.00 15.46           O
ATOM    798  N   ASN    94     -33.459  19.087   5.914  1.00 12.51           N
ATOM    799  CA  ASN    94     -32.101  19.512   5.580  1.00 14.01           C
ATOM    800  CB  ASN    94     -31.566  18.704   4.408  1.00 15.34           C
ATOM    801  CG  ASN    94     -31.380  17.226   4.724  1.00 18.74           C
ATOM    802  OD1 ASN    94     -31.130  16.441   3.813  1.00 27.63           O
ATOM    803  ND2 ASN    94     -31.508  16.841   5.986  1.00 22.90           N
ATOM    804  C   ASN    94     -32.010  20.978   5.199  1.00 13.91           C
ATOM    805  O   ASN    94     -30.942  21.582   5.307  1.00 12.63           O
ATOM    806  N   ASN    95     -33.118  21.549   4.732  1.00 13.29           N
ATOM    807  CA  ASN    95     -33.111  22.936   4.270  1.00 15.16           C
ATOM    808  CB  ASN    95     -32.967  23.054   2.763  1.00 16.24           C
ATOM    809  CG  ASN    95     -32.773  24.515   2.339  1.00 19.00           C
ATOM    810  OD1 ASN    95     -32.538  25.397   3.185  1.00 16.84           O
ATOM    811  ND2 ASN    95     -32.897  24.782   1.041  1.00 21.24           N
ATOM    812  C   ASN    95     -34.330  23.717   4.692  1.00 15.67           C
ATOM    813  O   ASN    95     -35.314  23.831   3.936  1.00 15.80           O
ATOM    814  N   PRO    96     -34.271  24.260   5.900  1.00 16.89           N
ATOM    815  CA  PRO    96     -35.322  25.100   6.460  1.00 18.18           C
ATOM    816  CB  PRO    96     -34.732  25.555   7.802  1.00 18.94           C
ATOM    817  CG  PRO    96     -33.729  24.472   8.148  1.00 19.40           C
ATOM    818  CD  PRO    96     -33.147  24.066   6.837  1.00 17.29           C
ATOM    819  C   PRO    96     -35.602  26.309   5.578  1.00 17.64           C
ATOM    820  O   PRO    96     -36.688  26.843   5.668  1.00 20.08           O
ATOM    821  N   GLN    97     -34.664  26.718   4.721  1.00 17.55           N
ATOM    822  CA  GLN    97     -34.882  27.924   3.884  1.00 16.15           C
ATOM    823  CB  GLN    97     -33.556  28.526   3.375  1.00 18.11           C
ATOM    824  CG  GLN    97     -32.586  28.997   4.445  1.00 21.27           C
ATOM    825  CD  GLN    97     -32.986  30.332   5.097  1.00 25.68           C
ATOM    826  OE1 GLN    97     -34.153  30.593   5.335  1.00 27.40           O
ATOM    827  NE2 GLN    97     -32.009  31.165   5.381  1.00 27.04           N
ATOM    828  C   GLN    97     -35.744  27.610   2.655  1.00 14.78           C
ATOM    829  O   GLN    97     -36.230  28.506   1.960  1.00 11.98           O
ATOM    830  N   LEU    98     -35.901  26.333   2.335  1.00 12.64           N
ATOM    831  CA  LEU    98     -36.399  26.054   0.980  1.00 12.07           C
ATOM    832  CB  LEU    98     -36.223  24.576   0.576  1.00 12.25           C
ATOM    833  CG  LEU    98     -36.864  24.142  -0.779  1.00 13.48           C
ATOM    834  CD1 LEU    98     -36.177  24.694  -2.050  1.00 15.69           C
ATOM    835  CD2 LEU    98     -36.865  22.621  -0.848  1.00 15.12           C
ATOM    836  C   LEU    98     -37.808  26.609   0.762  1.00  9.66           C
ATOM    837  O   LEU    98     -38.058  27.231  -0.286  1.00  9.22           O
ATOM    838  N   LEU    99     -38.723  26.475   1.724  1.00  9.90           N
ATOM    839  CA  LEU    99     -40.096  26.921   1.392  1.00 10.68           C
ATOM    840  CB  LEU    99     -41.134  26.482   2.475  1.00 11.84           C
ATOM    841  CG  LEU    99     -41.720  25.109   2.218  1.00 12.27           C
ATOM    842  CD1 LEU    99     -42.546  24.691   3.463  1.00 16.86           C
ATOM    843  CD2 LEU    99     -42.530  24.990   0.943  1.00 14.59           C
ATOM    844  C   LEU    99     -40.166  28.414   1.244  1.00 10.51           C
ATOM    845  O   LEU    99     -41.036  28.919   0.576  1.00 11.22           O
ATOM    846  N   ARG   100     -39.232  29.138   1.869  1.00  8.91           N
ATOM    847  CA  ARG   100     -39.171  30.614   1.637  1.00 10.19           C
ATOM    848  CB  ARG   100     -38.051  31.233   2.443  1.00  9.36           C
ATOM    849  CG  ARG   100     -38.293  31.279   3.923  1.00 12.57           C
ATOM    850  CD  ARG   100     -37.117  31.919   4.691  1.00 14.26           C
ATOM    851  NE  ARG   100     -37.502  32.131   6.084  1.00 21.03           N
ATOM    852  CZ  ARG   100     -36.662  32.254   7.102  1.00 26.22           C
ATOM    853  NH1 ARG   100     -35.340  32.191   6.906  1.00 25.30           N
ATOM    854  NH2 ARG   100     -37.156  32.455   8.326  1.00 30.04           N
ATOM    855  C   ARG   100     -38.944  30.908   0.135  1.00  9.56           C
ATOM    856  O   ARG   100     -39.737  31.609  -0.479  1.00  9.17           O
ATOM    857  N   PHE   101     -37.894  30.333  -0.451  1.00  8.88           N
ATOM    858  CA  PHE   101     -37.584  30.586  -1.861  1.00  7.74           C
ATOM    859  CB  PHE   101     -36.227  29.979  -2.191  1.00  9.07           C
ATOM    860  CG  PHE   101     -35.072  30.718  -1.553  1.00  8.31           C
ATOM    861  CD1 PHE   101     -34.572  31.865  -2.155  1.00  9.65           C
ATOM    862  CE1 PHE   101     -33.460  32.577  -1.586  1.00 12.39           C
ATOM    863  CZ  PHE   101     -32.856  32.079  -0.434  1.00 11.45           C
ATOM    864  CE2 PHE   101     -33.351  30.895   0.160  1.00 13.90           C
ATOM    865  CD2 PHE   101     -34.452  30.220  -0.416  1.00 11.33           C
ATOM    866  C   PHE   101     -38.651  29.978  -2.784  1.00  8.41           C
ATOM    867  O   PHE   101     -39.040  30.587  -3.776  1.00  8.06           O
ATOM    868  N   TYR   102     -39.122  28.777  -2.420  1.00  7.06           N
ATOM    869  CA  TYR   102     -40.068  28.027  -3.247  1.00  7.90           C
ATOM    870  CB  TYR   102     -40.262  26.695  -2.548  1.00  7.79           C
ATOM    871  CG  TYR   102     -41.077  25.629  -3.236  1.00  8.54           C
ATOM    872  CD1 TYR   102     -42.489  25.656  -3.181  1.00 10.03           C
ATOM    873  CE1 TYR   102     -43.257  24.599  -3.766  1.00 11.63           C
ATOM    874  CZ  TYR   102     -42.610  23.511  -4.376  1.00 11.76           C
ATOM    875  OH  TYR   102     -43.341  22.459  -4.924  1.00 11.14           O
ATOM    876  CE2 TYR   102     -41.192  23.459  -4.417  1.00  9.45           C
ATOM    877  CD2 TYR   102     -40.447  24.510  -3.827  1.00 10.19           C
ATOM    878  C   TYR   102     -41.394  28.796  -3.351  1.00  8.00           C
ATOM    879  O   TYR   102     -41.879  29.032  -4.458  1.00  9.22           O
ATOM    880  N   THR   103     -41.935  29.239  -2.212  1.00  8.23           N
ATOM    881  CA  THR   103     -43.186  30.012  -2.256  1.00  8.10           C
ATOM    882  CB  THR   103     -43.885  30.125  -0.875  1.00  7.33           C
ATOM    883  OG1 THR   103     -43.012  30.781   0.056  1.00  8.06           O
ATOM    884  CG2 THR   103     -44.249  28.714  -0.376  1.00  8.46           C
ATOM    885  C   THR   103     -43.009  31.397  -2.842  1.00  8.57           C
ATOM    886  O   THR   103     -43.909  31.869  -3.557  1.00  9.60           O
ATOM    887  N   SER   104     -41.877  32.052  -2.541  1.00  9.12           N
ATOM    888  CA  SER   104     -41.655  33.400  -3.043  1.00  9.88           C
ATOM    889  CB  SER   104     -40.363  34.009  -2.477  1.00  9.85           C
ATOM    890  OG  SER   104     -40.234  35.352  -2.971  1.00 12.21           O
ATOM    891  C   SER   104     -41.601  33.357  -4.584  1.00 10.66           C
ATOM    892  O   SER   104     -42.219  34.183  -5.265  1.00 10.59           O
ATOM    893  N   GLU   105     -40.865  32.392  -5.125  1.00  8.72           N
ATOM    894  CA  GLU   105     -40.817  32.289  -6.613  1.00  9.18           C
ATOM    895  CB  GLU   105     -39.731  31.293  -7.041  1.00  7.45           C
ATOM    896  CG  GLU   105     -38.332  31.924  -6.972  1.00  8.14           C
ATOM    897  CD  GLU   105     -38.036  32.910  -8.131  1.00 10.19           C
ATOM    898  OE1 GLU   105     -38.853  33.093  -9.071  1.00  9.04           O
ATOM    899  OE2 GLU   105     -36.931  33.505  -8.111  1.00 13.04           O
ATOM    900  C   GLU   105     -42.165  31.935  -7.261  1.00  9.12           C
ATOM    901  O   GLU   105     -42.538  32.491  -8.300  1.00  9.81           O
ATOM    902  N   LEU   106     -42.941  31.042  -6.632  1.00  8.79           N
ATOM    903  CA  LEU   106     -44.237  30.680  -7.191  1.00  9.03           C
ATOM    904  CB  LEU   106     -44.849  29.471  -6.457  1.00  8.32           C
ATOM    905  CG  LEU   106     -44.211  28.130  -6.911  1.00  9.60           C
ATOM    906  CD1 LEU   106     -44.576  27.033  -5.828  1.00  9.04           C
ATOM    907  CD2 LEU   106     -44.754  27.786  -8.296  1.00  9.22           C
ATOM    908  C   LEU   106     -45.238  31.834  -7.135  1.00  9.88           C
ATOM    909  O   LEU   106     -46.147  31.887  -7.972  1.00 10.21           O
ATOM    910  N   THR   107     -45.102  32.717  -6.136  1.00  9.52           N
ATOM    911  CA  THR   107     -46.030  33.832  -5.986  1.00  9.75           C
ATOM    912  CB  THR   107     -46.510  33.990  -4.516  1.00  9.09           C
ATOM    913  OG1 THR   107     -45.388  34.319  -3.693  1.00 10.50           O
ATOM    914  CG2 THR   107     -47.185  32.718  -4.076  1.00 10.05           C
ATOM    915  C   THR   107     -45.544  35.182  -6.484  1.00  9.81           C
ATOM    916  O   THR   107     -46.371  36.081  -6.704  1.00 12.25           O
ATOM    917  N   ASN   108     -44.232  35.363  -6.633  0.50  9.70           N
ATOM    919  CA  ASN   108     -43.617  36.625  -7.105  0.50  9.59           C
ATOM    921  CB  ASN   108     -43.154  37.511  -5.932  0.50  9.99           C
ATOM    923  CG  ASN   108     -44.278  38.322  -5.314  0.50  8.07           C
ATOM    925  OD1 ASN   108     -44.577  38.166  -4.138  0.50 11.45           O
ATOM    927  ND2 ASN   108     -44.931  39.160  -6.116  0.50  6.17           N
ATOM    929  C   ASN   108     -42.392  36.215  -7.909  0.50  9.86           C
ATOM    931  O   ASN   108     -41.262  36.429  -7.469  0.50  9.46           O
ATOM    933  N   PRO   109     -42.611  35.593  -9.087  1.00  9.87           N
ATOM    934  CA  PRO   109     -41.482  34.997  -9.847  1.00  9.20           C
ATOM    935  CB  PRO   109     -42.170  34.338 -11.060  1.00  9.29           C
ATOM    936  CG  PRO   109     -43.456  35.217 -11.249  1.00 11.47           C
ATOM    937  CD  PRO   109     -43.900  35.416  -9.770  1.00 10.72           C
ATOM    938  C   PRO   109     -40.455  36.039 -10.322  1.00  9.60           C
ATOM    939  O   PRO   109     -40.811  37.205 -10.612  1.00 11.09           O
ATOM    940  N   THR   110     -39.210  35.615 -10.382  1.00  9.05           N
ATOM    941  CA  THR   110     -38.133  36.378 -11.039  1.00  9.32           C
ATOM    942  CB  THR   110     -36.862  36.356 -10.160  1.00 10.57           C
ATOM    943  OG1 THR   110     -36.330  35.035 -10.130  1.00  9.30           O
ATOM    944  CG2 THR   110     -37.147  36.832  -8.744  1.00 13.98           C
ATOM    945  C   THR   110     -37.799  35.644 -12.327  1.00  8.94           C
ATOM    946  O   THR   110     -38.429  34.643 -12.626  1.00  8.35           O
ATOM    947  N   PRO   111     -36.818  36.119 -13.123  1.00  9.83           N
ATOM    948  CA  PRO   111     -36.366  35.317 -14.286  1.00 11.52           C
ATOM    949  CB  PRO   111     -35.231  36.183 -14.892  1.00 11.75           C
ATOM    950  CG  PRO   111     -35.579  37.539 -14.489  1.00 11.98           C
ATOM    951  CD  PRO   111     -36.150  37.430 -13.076  1.00 10.83           C
ATOM    952  C   PRO   111     -35.863  33.915 -13.908  1.00 12.86           C
ATOM    953  O   PRO   111     -35.889  32.963 -14.744  1.00 13.75           O
ATOM    954  N   CYS   112     -35.461  33.730 -12.660  1.00 11.46           N
ATOM    955  CA  CYS   112     -35.067  32.401 -12.254  1.00 13.19           C
ATOM    956  CB  CYS   112     -34.230  32.442 -10.978  1.00 14.56           C
ATOM    957  SG  CYS   112     -32.686  33.333 -11.290  1.00 18.40           S
ATOM    958  C   CYS   112     -36.251  31.432 -12.108  1.00 12.18           C
ATOM    959  O   CYS   112     -36.048  30.232 -11.974  1.00 13.79           O
ATOM    960  N   PHE   113     -37.501  31.926 -12.121  1.00 11.58           N
ATOM    961  CA  PHE   113     -38.605  30.987 -11.961  1.00 10.29           C
ATOM    962  CB  PHE   113     -39.921  31.711 -11.869  1.00 10.73           C
ATOM    963  CG  PHE   113     -41.068  30.776 -11.807  1.00 10.75           C
ATOM    964  CD1 PHE   113     -41.318  30.025 -10.649  1.00 13.13           C
ATOM    965  CE1 PHE   113     -42.390  29.092 -10.649  1.00 14.20           C
ATOM    966  CZ  PHE   113     -43.135  28.878 -11.780  1.00 12.39           C
ATOM    967  CE2 PHE   113     -42.909  29.606 -12.931  1.00 14.70           C
ATOM    968  CD2 PHE   113     -41.824  30.539 -12.957  1.00 11.87           C
ATOM    969  C   PHE   113     -38.634  30.035 -13.180  1.00  9.81           C
ATOM    970  O   PHE   113     -38.642  28.807 -13.017  1.00  9.92           O
ATOM    971  N   ALA   114     -38.644  30.592 -14.383  1.00  9.60           N
ATOM    972  CA  ALA   114     -38.711  29.716 -15.565  1.00  9.88           C
ATOM    973  CB  ALA   114     -38.980  30.528 -16.837  1.00  9.97           C
ATOM    974  C   ALA   114     -37.461  28.865 -15.730  1.00 10.92           C
ATOM    975  O   ALA   114     -37.548  27.764 -16.247  1.00 11.21           O
ATOM    976  N   ALA   115     -36.301  29.407 -15.342  1.00 10.45           N
ATOM    977  CA  ALA   115     -35.020  28.733 -15.554  1.00 11.81           C
ATOM    978  CB  ALA   115     -33.882  29.767 -15.520  1.00 12.14           C
ATOM    979  C   ALA   115     -34.750  27.588 -14.574  1.00 11.95           C
ATOM    980  O   ALA   115     -34.178  26.555 -14.951  1.00 12.70           O
ATOM    981  N   ILE   116     -35.186  27.750 -13.331  1.00 11.04           N
ATOM    982  CA  ILE   116     -34.783  26.848 -12.255  1.00 11.69           C
ATOM    983  CB  ILE   116     -33.872  27.616 -11.214  1.00 10.98           C
ATOM    984  CG1 ILE   116     -32.584  28.106 -11.900  1.00 13.37           C
ATOM    985  CD1 ILE   116     -31.751  29.071 -11.039  1.00 12.57           C
ATOM    986  CG2 ILE   116     -33.568  26.724  -9.962  1.00 12.49           C
ATOM    987  C   ILE   116     -35.998  26.242 -11.560  1.00 11.29           C
ATOM    988  O   ILE   116     -36.092  25.007 -11.384  1.00 10.24           O
ATOM    989  N   VAL   117     -36.919  27.089 -11.131  1.00 10.95           N
ATOM    990  CA  VAL   117     -37.977  26.588 -10.206  1.00 10.57           C
ATOM    991  CB  VAL   117     -38.617  27.751  -9.409  1.00 11.02           C
ATOM    992  CG1 VAL   117     -39.795  27.207  -8.454  1.00 10.64           C
ATOM    993  CG2 VAL   117     -37.512  28.443  -8.627  1.00 10.50           C
ATOM    994  C   VAL   117     -39.038  25.771 -10.946  1.00 11.77           C
ATOM    995  O   VAL   117     -39.425  24.648 -10.524  1.00 11.14           O
ATOM    996  N   SER   118     -39.530  26.315 -12.046  1.00 10.59           N
ATOM    997  CA  SER   118     -40.620  25.684 -12.764  1.00 12.47           C
ATOM    998  CB  SER   118     -41.105  26.636 -13.868  1.00 13.39           C
ATOM    999  OG  SER   118     -42.255  26.127 -14.471  1.00 14.41           O
ATOM   1000  C   SER   118     -40.234  24.283 -13.285  1.00 11.92           C
ATOM   1001  O   SER   118     -40.958  23.318 -13.010  1.00 12.39           O
ATOM   1002  N   PRO   119     -39.094  24.138 -13.988  1.00 12.64           N
ATOM   1003  CA  PRO   119     -38.727  22.800 -14.461  1.00 11.77           C
ATOM   1004  CB  PRO   119     -37.448  23.016 -15.304  1.00 12.21           C
ATOM   1005  CG  PRO   119     -36.981  24.375 -14.981  1.00 12.76           C
ATOM   1006  CD  PRO   119     -38.161  25.180 -14.467  1.00 11.90           C
ATOM   1007  C   PRO   119     -38.487  21.799 -13.296  1.00 11.38           C
ATOM   1008  O   PRO   119     -38.822  20.622 -13.450  1.00 11.44           O
ATOM   1009  N   ALA   120     -37.965  22.276 -12.162  1.00 10.79           N
ATOM   1010  CA  ALA   120     -37.680  21.404 -10.992  1.00  9.96           C
ATOM   1011  CB  ALA   120     -36.955  22.202  -9.916  1.00 10.33           C
ATOM   1012  C   ALA   120     -38.996  20.843 -10.478  1.00 11.25           C
ATOM   1013  O   ALA   120     -39.179  19.606 -10.381  1.00 11.32           O
ATOM   1014  N   ILE   121     -39.972  21.731 -10.240  1.00  9.92           N
ATOM   1015  CA  ILE   121     -41.278  21.275  -9.739  1.00 10.42           C
ATOM   1016  CB  ILE   121     -42.191  22.482  -9.354  1.00  9.91           C
ATOM   1017  CG1 ILE   121     -41.576  23.223  -8.147  1.00 11.53           C
ATOM   1018  CD1 ILE   121     -42.273  24.600  -7.882  1.00 11.61           C
ATOM   1019  CG2 ILE   121     -43.657  22.039  -9.082  1.00 11.13           C
ATOM   1020  C   ILE   121     -41.980  20.382 -10.790  1.00 10.00           C
ATOM   1021  O   ILE   121     -42.496  19.302 -10.444  1.00 10.24           O
ATOM   1022  N   ALA   122     -41.999  20.822 -12.047  1.00 10.30           N
ATOM   1023  CA  ALA   122     -42.680  20.050 -13.108  1.00 11.54           C
ATOM   1024  CB  ALA   122     -42.598  20.755 -14.509  1.00 12.24           C
ATOM   1025  C   ALA   122     -42.094  18.638 -13.234  1.00 11.86           C
ATOM   1026  O   ALA   122     -42.845  17.702 -13.488  1.00 12.38           O
ATOM   1027  N   SER   123     -40.780  18.499 -13.132  1.00 11.72           N
ATOM   1028  CA  SER   123     -40.140  17.174 -13.297  1.00 11.69           C
ATOM   1029  CB  SER   123     -38.597  17.220 -13.248  1.00 13.37           C
ATOM   1030  OG  SER   123     -38.136  17.620 -11.957  1.00 18.01           O
ATOM   1031  C   SER   123     -40.678  16.217 -12.222  1.00 11.56           C
ATOM   1032  O   SER   123     -40.889  15.041 -12.504  1.00 11.30           O
ATOM   1033  N   VAL   124     -40.862  16.719 -10.996  1.00 10.19           N
ATOM   1034  CA  VAL   124     -41.338  15.876  -9.883  1.00  9.66           C
ATOM   1035  CB  VAL   124     -41.121  16.603  -8.497  1.00 10.39           C
ATOM   1036  CG1 VAL   124     -41.817  15.860  -7.384  1.00 13.37           C
ATOM   1037  CG2 VAL   124     -39.640  16.694  -8.191  1.00 12.44           C
ATOM   1038  C   VAL   124     -42.808  15.523 -10.075  1.00 10.08           C
ATOM   1039  O   VAL   124     -43.218  14.350  -9.905  1.00  9.51           O
ATOM   1040  N   ILE   125     -43.617  16.526 -10.409  1.00  9.88           N
ATOM   1041  CA  ILE   125     -45.046  16.301 -10.630  1.00 10.74           C
ATOM   1042  CB  ILE   125     -45.803  17.624 -10.870  1.00 11.75           C
ATOM   1043  CG1 ILE   125     -45.744  18.498  -9.590  1.00  9.55           C
ATOM   1044  CD1 ILE   125     -46.274  17.830  -8.232  1.00 11.11           C
ATOM   1045  CG2 ILE   125     -47.298  17.363 -11.280  1.00 10.72           C
ATOM   1046  C   ILE   125     -45.254  15.309 -11.757  1.00 10.24           C
ATOM   1047  O   ILE   125     -46.088  14.386 -11.644  1.00 10.73           O
ATOM   1048  N   ARG   126     -44.483  15.459 -12.837  0.50 10.47           N
ATOM   1050  CA  ARG   126     -44.567  14.514 -13.947  0.50  9.91           C
ATOM   1052  CB  ARG   126     -43.607  14.907 -15.078  0.50  9.78           C
ATOM   1054  CG  ARG   126     -44.070  16.073 -15.874  0.50  8.97           C
ATOM   1056  CD  ARG   126     -43.145  16.305 -17.083  0.50 11.78           C
ATOM   1058  NE  ARG   126     -43.524  17.541 -17.757  0.50 13.41           N
ATOM   1060  CZ  ARG   126     -42.784  18.643 -17.773  0.50 18.19           C
ATOM   1062  NH1 ARG   126     -41.594  18.649 -17.187  0.50 18.32           N
ATOM   1064  NH2 ARG   126     -43.223  19.729 -18.401  0.50 20.28           N
ATOM   1066  C   ARG   126     -44.269  13.104 -13.483  0.50 10.39           C
ATOM   1068  O   ARG   126     -45.010  12.161 -13.806  0.50 11.26           O
ATOM   1070  N   LEU   127     -43.191  12.959 -12.717  1.00 10.18           N
ATOM   1071  CA  LEU   127     -42.747  11.653 -12.281  1.00 11.49           C
ATOM   1072  CB  LEU   127     -41.457  11.792 -11.470  1.00 12.45           C
ATOM   1073  CG  LEU   127     -40.836  10.551 -10.872  1.00 15.70           C
ATOM   1074  CD1 LEU   127     -40.489   9.503 -11.921  1.00 20.81           C
ATOM   1075  CD2 LEU   127     -39.573  10.988 -10.121  1.00 18.67           C
ATOM   1076  C   LEU   127     -43.864  10.955 -11.482  1.00  9.91           C
ATOM   1077  O   LEU   127     -44.173   9.757 -11.684  1.00 10.50           O
ATOM   1078  N   LEU   128     -44.458  11.703 -10.559  1.00  8.79           N
ATOM   1079  CA  LEU   128     -45.555  11.167  -9.751  1.00  9.28           C
ATOM   1080  CB  LEU   128     -45.959  12.213  -8.701  1.00  9.38           C
ATOM   1081  CG  LEU   128     -44.895  12.460  -7.628  1.00 11.13           C
ATOM   1082  CD1 LEU   128     -45.399  13.599  -6.743  1.00 11.82           C
ATOM   1083  CD2 LEU   128     -44.635  11.243  -6.755  1.00 13.49           C
ATOM   1084  C   LEU   128     -46.755  10.814 -10.630  1.00 10.57           C
ATOM   1085  O   LEU   128     -47.393   9.762 -10.464  1.00  8.87           O
ATOM   1086  N   ALA   129     -47.111  11.725 -11.531  1.00  9.99           N
ATOM   1087  CA  ALA   129     -48.264  11.513 -12.419  1.00 10.43           C
ATOM   1088  CB  ALA   129     -48.466  12.756 -13.298  1.00 10.04           C
ATOM   1089  C   ALA   129     -48.072  10.270 -13.290  1.00  9.53           C
ATOM   1090  O   ALA   129     -49.010   9.490 -13.509  1.00  9.22           O
ATOM   1091  N   GLU   130     -46.842  10.075 -13.777  1.00 10.54           N
ATOM   1092  CA  GLU   130     -46.555   8.883 -14.586  1.00 10.65           C
ATOM   1093  CB  GLU   130     -45.130   8.957 -15.080  1.00 11.71           C
ATOM   1094  CG  GLU   130     -45.015   9.922 -16.236  1.00 15.98           C
ATOM   1095  CD  GLU   130     -43.548  10.268 -16.577  1.00 25.12           C
ATOM   1096  OE1 GLU   130     -42.602   9.684 -15.991  1.00 26.80           O
ATOM   1097  OE2 GLU   130     -43.362  11.157 -17.432  1.00 30.61           O
ATOM   1098  C   GLU   130     -46.799   7.589 -13.828  1.00 10.74           C
ATOM   1099  O   GLU   130     -47.364   6.626 -14.382  1.00  9.75           O
ATOM   1100  N   SER   131     -46.395   7.580 -12.558  0.50 10.14           N
ATOM   1102  CA  SER   131     -46.583   6.411 -11.722  0.50 10.49           C
ATOM   1104  CB  SER   131     -45.843   6.578 -10.396  0.50 11.10           C
ATOM   1106  OG  SER   131     -45.705   5.328  -9.775  0.50 10.69           O
ATOM   1108  C   SER   131     -48.057   6.142 -11.458  0.50 10.47           C
ATOM   1110  O   SER   131     -48.497   4.991 -11.474  0.50  9.95           O
ATOM   1112  N   ILE   132     -48.806   7.214 -11.186  1.00  9.30           N
ATOM   1113  CA  ILE   132     -50.274   7.155 -11.007  1.00 10.27           C
ATOM   1114  CB  ILE   132     -50.819   8.528 -10.573  1.00 10.43           C
ATOM   1115  CG1 ILE   132     -50.217   8.879  -9.199  1.00 10.19           C
ATOM   1116  CD1 ILE   132     -50.537  10.321  -8.694  1.00 10.55           C
ATOM   1117  CG2 ILE   132     -52.352   8.522 -10.544  1.00 12.86           C
ATOM   1118  C   ILE   132     -50.956   6.643 -12.274  1.00 10.09           C
ATOM   1119  O   ILE   132     -51.855   5.784 -12.188  1.00  9.47           O
ATOM   1120  N   GLU   133     -50.535   7.164 -13.426  0.50 10.08           N
ATOM   1122  CA  GLU   133     -51.024   6.713 -14.732  0.50 10.68           C
ATOM   1124  CB  GLU   133     -50.390   7.549 -15.871  0.50 10.91           C
ATOM   1126  CG  GLU   133     -51.050   8.940 -16.009  0.50 12.45           C
ATOM   1128  CD  GLU   133     -50.193  10.029 -16.674  0.50 14.41           C
ATOM   1130  OE1 GLU   133     -48.998   9.781 -16.983  0.50 17.78           O
ATOM   1132  OE2 GLU   133     -50.748  11.144 -16.892  0.50 18.07           O
ATOM   1134  C   GLU   133     -50.823   5.208 -14.941  0.50  9.88           C
ATOM   1136  O   GLU   133     -51.712   4.518 -15.430  0.50 10.09           O
ATOM   1138  N   ALA   134     -49.659   4.695 -14.546  1.00  9.31           N
ATOM   1139  CA  ALA   134     -49.346   3.267 -14.674  1.00  9.01           C
ATOM   1140  CB  ALA   134     -47.869   3.011 -14.361  1.00  9.38           C
ATOM   1141  C   ALA   134     -50.237   2.445 -13.765  1.00  9.17           C
ATOM   1142  O   ALA   134     -50.720   1.372 -14.144  1.00  9.07           O
ATOM   1143  N   GLY   135     -50.446   2.954 -12.554  1.00  9.74           N
ATOM   1144  CA  GLY   135     -51.304   2.264 -11.598  1.00  9.68           C
ATOM   1145  C   GLY   135     -52.748   2.231 -12.081  1.00 10.54           C
ATOM   1146  O   GLY   135     -53.432   1.261 -11.841  1.00 11.18           O
ATOM   1147  N   MET   136     -53.212   3.294 -12.736  1.00 10.78           N
ATOM   1148  CA  MET   136     -54.550   3.319 -13.316  1.00 14.00           C
ATOM   1149  CB  MET   136     -54.856   4.709 -13.853  1.00 12.19           C
ATOM   1150  CG  MET   136     -55.025   5.738 -12.769  1.00 17.50           C
ATOM   1151  SD  MET   136     -55.390   7.532 -13.517  0.80 27.77          SE
ATOM   1152  CE  MET   136     -56.956   7.128 -14.509  1.00 24.50           C
ATOM   1153  C   MET   136     -54.690   2.274 -14.426  1.00 11.62           C
ATOM   1154  O   MET   136     -55.630   1.461 -14.414  1.00 11.88           O
ATOM   1155  N   THR   137     -53.704   2.228 -15.331  1.00 10.74           N
ATOM   1156  CA  THR   137     -53.673   1.197 -16.405  1.00  9.88           C
ATOM   1157  CB  THR   137     -52.401   1.371 -17.285  1.00  9.89           C
ATOM   1158  OG1 THR   137     -52.434   2.676 -17.872  1.00 11.23           O
ATOM   1159  CG2 THR   137     -52.311   0.289 -18.374  1.00 10.49           C
ATOM   1160  C   THR   137     -53.735  -0.220 -15.824  1.00  9.70           C
ATOM   1161  O   THR   137     -54.451  -1.096 -16.313  1.00  8.79           O
ATOM   1162  N   ARG   138     -53.012  -0.433 -14.737  1.00 10.06           N
ATOM   1163  CA  ARG   138     -52.962  -1.726 -14.092  1.00 10.50           C
ATOM   1164  CB  ARG   138     -51.753  -1.827 -13.178  1.00 10.22           C
ATOM   1165  CG  ARG   138     -50.421  -1.961 -13.926  1.00 11.00           C
ATOM   1166  CD  ARG   138     -49.267  -1.783 -12.921  1.00 11.40           C
ATOM   1167  NE  ARG   138     -49.385  -2.776 -11.860  1.00 13.48           N
ATOM   1168  CZ  ARG   138     -48.694  -2.749 -10.731  1.00 16.65           C
ATOM   1169  NH1 ARG   138     -47.798  -1.778 -10.519  1.00 13.97           N
ATOM   1170  NH2 ARG   138     -48.909  -3.699  -9.812  1.00 18.04           N
ATOM   1171  C   ARG   138     -54.233  -2.088 -13.308  1.00 11.15           C
ATOM   1172  O   ARG   138     -54.391  -3.238 -12.908  1.00 11.80           O
ATOM   1173  N   GLY   139     -55.117  -1.122 -13.103  1.00 12.43           N
ATOM   1174  CA  GLY   139     -56.308  -1.342 -12.309  1.00 12.85           C
ATOM   1175  C   GLY   139     -56.098  -1.206 -10.803  1.00 14.77           C
ATOM   1176  O   GLY   139     -57.031  -1.500 -10.021  1.00 15.21           O
ATOM   1177  N   LEU   140     -54.904  -0.785 -10.370  1.00 14.40           N
ATOM   1178  CA  LEU   140     -54.663  -0.525  -8.930  1.00 15.70           C
ATOM   1179  CB  LEU   140     -53.175  -0.325  -8.608  1.00 17.02           C
ATOM   1180  CG  LEU   140     -52.165  -1.407  -8.937  1.00 20.06           C
ATOM   1181  CD1 LEU   140     -50.855  -0.921  -8.327  1.00 24.89           C
ATOM   1182  CD2 LEU   140     -52.585  -2.711  -8.319  1.00 24.25           C
ATOM   1183  C   LEU   140     -55.356   0.744  -8.489  1.00 14.92           C
ATOM   1184  O   LEU   140     -55.818   0.834  -7.342  1.00 14.43           O
ATOM   1185  N   PHE   141     -55.378   1.734  -9.384  1.00 13.97           N
ATOM   1186  CA  PHE   141     -55.934   3.051  -9.092  1.00 15.04           C
ATOM   1187  CB  PHE   141     -54.894   4.159  -9.339  1.00 13.91           C
ATOM   1188  CG  PHE   141     -53.627   4.016  -8.510  1.00 13.77           C
ATOM   1189  CD1 PHE   141     -53.668   3.442  -7.227  1.00 13.85           C
ATOM   1190  CE1 PHE   141     -52.491   3.310  -6.463  1.00 13.85           C
ATOM   1191  CZ  PHE   141     -51.267   3.776  -7.000  1.00 12.20           C
ATOM   1192  CE2 PHE   141     -51.240   4.341  -8.294  1.00 10.44           C
ATOM   1193  CD2 PHE   141     -52.392   4.479  -9.011  1.00 12.75           C
ATOM   1194  C   PHE   141     -57.151   3.307  -9.951  1.00 15.74           C
ATOM   1195  O   PHE   141     -57.249   2.777 -11.067  1.00 14.26           O
ATOM   1196  N   ARG   142     -58.074   4.120  -9.443  0.50 16.15           N
ATOM   1198  CA  ARG   142     -59.333   4.428 -10.124  0.50 17.47           C
ATOM   1200  CB  ARG   142     -60.256   5.250  -9.227  0.50 17.67           C
ATOM   1202  CG  ARG   142     -60.907   4.514  -8.115  0.50 18.73           C
ATOM   1204  CD  ARG   142     -61.871   5.446  -7.428  0.50 20.28           C
ATOM   1206  NE  ARG   142     -61.191   6.543  -6.744  0.50 20.28           N
ATOM   1208  CZ  ARG   142     -61.802   7.632  -6.287  0.50 20.99           C
ATOM   1210  NH1 ARG   142     -63.104   7.797  -6.474  0.50 17.88           N
ATOM   1212  NH2 ARG   142     -61.099   8.580  -5.668  0.50 20.92           N
ATOM   1214  C   ARG   142     -59.126   5.255 -11.374  0.50 17.70           C
ATOM   1216  O   ARG   142     -58.339   6.198 -11.388  0.50 18.50           O
ATOM   1218  N   ARG   143     -59.912   4.938 -12.395  1.00 18.41           N
ATOM   1219  CA  ARG   143     -59.747   5.554 -13.691  1.00 19.17           C
ATOM   1220  CB  ARG   143     -60.007   4.550 -14.785  1.00 19.39           C
ATOM   1221  CG  ARG   143     -58.965   3.434 -14.827  1.00 22.29           C
ATOM   1222  CD  ARG   143     -59.450   2.272 -15.677  1.00 26.49           C
ATOM   1223  NE  ARG   143     -58.403   1.273 -15.895  1.00 30.12           N
ATOM   1224  CZ  ARG   143     -58.545  -0.047 -15.757  1.00 31.21           C
ATOM   1225  NH1 ARG   143     -59.715  -0.594 -15.415  1.00 32.67           N
ATOM   1226  NH2 ARG   143     -57.502  -0.838 -15.984  1.00 31.42           N
ATOM   1227  C   ARG   143     -60.507   6.857 -13.893  1.00 18.83           C
ATOM   1228  O   ARG   143     -60.315   7.510 -14.913  1.00 20.12           O
ATOM   1229  N   ASP   144     -61.324   7.254 -12.917  1.00 17.76           N
ATOM   1230  CA  ASP   144     -62.025   8.547 -12.977  1.00 16.37           C
ATOM   1231  CB  ASP   144     -63.426   8.450 -12.354  1.00 16.63           C
ATOM   1232  CG  ASP   144     -63.395   8.116 -10.877  1.00 17.52           C
ATOM   1233  OD1 ASP   144     -62.398   7.530 -10.424  1.00 17.03           O
ATOM   1234  OD2 ASP   144     -64.383   8.426 -10.159  1.00 20.81           O
ATOM   1235  C   ASP   144     -61.281   9.716 -12.339  1.00 15.58           C
ATOM   1236  O   ASP   144     -61.871  10.803 -12.135  1.00 16.22           O
ATOM   1237  N   LEU   145     -60.024   9.520 -11.954  0.50 14.65           N
ATOM   1239  CA  LEU   145     -59.257  10.650 -11.435  0.50 13.62           C
ATOM   1241  CB  LEU   145     -58.748  10.426 -10.005  0.50 13.58           C
ATOM   1243  CG  LEU   145     -59.708  10.249  -8.827  0.50 13.00           C
ATOM   1245  CD1 LEU   145     -58.863   9.721  -7.686  0.50 13.60           C
ATOM   1247  CD2 LEU   145     -60.478  11.539  -8.398  0.50 13.09           C
ATOM   1249  C   LEU   145     -58.106  10.962 -12.376  0.50 13.00           C
ATOM   1251  O   LEU   145     -57.581  10.079 -13.050  0.50 12.96           O
ATOM   1253  N   HIS   146     -57.762  12.235 -12.428  1.00 12.38           N
ATOM   1254  CA  HIS   146     -56.767  12.749 -13.335  1.00 11.72           C
ATOM   1255  CB  HIS   146     -57.099  14.174 -13.754  1.00 13.12           C
ATOM   1256  CG  HIS   146     -58.088  14.223 -14.890  1.00 18.87           C
ATOM   1257  ND1 HIS   146     -59.407  14.593 -14.717  1.00 23.34           N
ATOM   1258  CE1 HIS   146     -60.041  14.495 -15.875  1.00 23.61           C
ATOM   1259  NE2 HIS   146     -59.189  14.056 -16.787  1.00 22.78           N
ATOM   1260  CD2 HIS   146     -57.966  13.859 -16.194  1.00 21.18           C
ATOM   1261  C   HIS   146     -55.432  12.632 -12.658  1.00  9.97           C
ATOM   1262  O   HIS   146     -55.283  13.064 -11.523  1.00  8.48           O
ATOM   1263  N   ALA   147     -54.466  12.063 -13.380  1.00  8.06           N
ATOM   1264  CA  ALA   147     -53.171  11.743 -12.792  1.00  7.43           C
ATOM   1265  CB  ALA   147     -52.303  10.976 -13.795  1.00  7.64           C
ATOM   1266  C   ALA   147     -52.415  12.975 -12.255  1.00  7.37           C
ATOM   1267  O   ALA   147     -51.892  12.935 -11.149  1.00  7.42           O
ATOM   1268  N   VAL   148     -52.323  14.040 -13.057  1.00  5.91           N
ATOM   1269  CA  VAL   148     -51.580  15.234 -12.596  1.00  5.28           C
ATOM   1270  CB  VAL   148     -51.376  16.285 -13.741  1.00  5.29           C
ATOM   1271  CG1 VAL   148     -50.894  17.623 -13.160  1.00  5.38           C
ATOM   1272  CG2 VAL   148     -50.385  15.716 -14.827  1.00  7.18           C
ATOM   1273  C   VAL   148     -52.285  15.874 -11.417  1.00  5.21           C
ATOM   1274  O   VAL   148     -51.641  16.225 -10.424  1.00  4.80           O
ATOM   1275  N   ASN   149     -53.605  16.034 -11.475  1.00  5.51           N
ATOM   1276  CA  ASN   149     -54.259  16.664 -10.322  1.00  5.65           C
ATOM   1277  CB  ASN   149     -55.765  16.822 -10.566  1.00  6.66           C
ATOM   1278  CG  ASN   149     -56.088  18.026 -11.409  1.00 10.17           C
ATOM   1279  OD1 ASN   149     -55.200  18.846 -11.725  1.00 12.80           O
ATOM   1280  ND2 ASN   149     -57.358  18.143 -11.798  1.00 12.10           N
ATOM   1281  C   ASN   149     -54.045  15.842  -9.043  1.00  6.11           C
ATOM   1282  O   ASN   149     -53.933  16.413  -7.953  1.00  4.78           O
ATOM   1283  N   SER   150     -53.988  14.513  -9.207  1.00  5.76           N
ATOM   1284  CA  SER   150     -53.748  13.564  -8.084  1.00  6.08           C
ATOM   1285  CB  SER   150     -54.027  12.096  -8.522  1.00  5.78           C
ATOM   1286  OG  SER   150     -55.422  11.927  -8.837  1.00  7.08           O
ATOM   1287  C   SER   150     -52.331  13.717  -7.550  1.00  5.66           C
ATOM   1288  O   SER   150     -52.119  13.810  -6.341  1.00  5.57           O
ATOM   1289  N   ALA   151     -51.349  13.768  -8.451  1.00  5.77           N
ATOM   1290  CA  ALA   151     -49.966  14.064  -8.076  1.00  5.41           C
ATOM   1291  CB  ALA   151     -49.086  14.156  -9.326  1.00  5.18           C
ATOM   1292  C   ALA   151     -49.874  15.386  -7.279  1.00  5.91           C
ATOM   1293  O   ALA   151     -49.179  15.466  -6.262  1.00  6.61           O
ATOM   1294  N   LEU   152     -50.552  16.425  -7.784  1.00  6.31           N
ATOM   1295  CA  LEU   152     -50.534  17.749  -7.110  1.00  5.72           C
ATOM   1296  CB  LEU   152     -51.297  18.807  -7.921  1.00  4.81           C
ATOM   1297  CG  LEU   152     -50.598  19.222  -9.218  1.00  4.27           C
ATOM   1298  CD1 LEU   152     -51.572  20.071 -10.072  1.00  6.58           C
ATOM   1299  CD2 LEU   152     -49.276  20.001  -8.973  1.00  5.18           C
ATOM   1300  C   LEU   152     -51.132  17.647  -5.707  1.00  7.70           C
ATOM   1301  O   LEU   152     -50.626  18.296  -4.766  1.00  7.69           O
ATOM   1302  N   ALA   153     -52.188  16.836  -5.551  1.00  6.37           N
ATOM   1303  CA  ALA   153     -52.794  16.600  -4.245  1.00  7.16           C
ATOM   1304  CB  ALA   153     -54.029  15.679  -4.378  1.00  5.65           C
ATOM   1305  C   ALA   153     -51.787  16.008  -3.247  1.00  7.42           C
ATOM   1306  O   ALA   153     -51.667  16.511  -2.117  1.00  6.88           O
ATOM   1307  N   LEU   154     -51.039  14.972  -3.683  1.00  5.98           N
ATOM   1308  CA  LEU   154     -50.031  14.354  -2.805  1.00  5.94           C
ATOM   1309  CB  LEU   154     -49.453  13.092  -3.458  1.00  6.06           C
ATOM   1310  CG  LEU   154     -48.400  12.364  -2.617  1.00  6.43           C
ATOM   1311  CD1 LEU   154     -48.990  11.876  -1.271  1.00  5.45           C
ATOM   1312  CD2 LEU   154     -47.790  11.240  -3.434  1.00  7.02           C
ATOM   1313  C   LEU   154     -48.921  15.373  -2.447  1.00  5.85           C
ATOM   1314  O   LEU   154     -48.530  15.518  -1.271  1.00  6.15           O
ATOM   1315  N   ALA   155     -48.449  16.084  -3.464  1.00  6.37           N
ATOM   1316  CA  ALA   155     -47.402  17.083  -3.242  1.00  6.90           C
ATOM   1317  CB  ALA   155     -46.984  17.689  -4.593  1.00  7.15           C
ATOM   1318  C   ALA   155     -47.927  18.147  -2.260  1.00  6.59           C
ATOM   1319  O   ALA   155     -47.181  18.625  -1.387  1.00  7.17           O
ATOM   1320  N   GLY   156     -49.204  18.510  -2.409  1.00  6.53           N
ATOM   1321  CA  GLY   156     -49.808  19.558  -1.574  1.00  7.23           C
ATOM   1322  C   GLY   156     -49.903  19.117  -0.129  1.00  8.33           C
ATOM   1323  O   GLY   156     -49.684  19.935   0.770  1.00  9.18           O
ATOM   1324  N   MET   157     -50.275  17.857   0.104  0.50  7.22           N
ATOM   1326  CA  MET   157     -50.394  17.342   1.473  0.50  9.40           C
ATOM   1328  CB  MET   157     -50.608  15.818   1.495  0.50  9.03           C
ATOM   1330  CG  MET   157     -51.950  15.368   1.037  0.50 10.44           C
ATOM   1332  SD  MET   157     -52.121  13.470   1.490  0.50 14.75          SE
ATOM   1334  CE  MET   157     -53.565  13.043   0.240  0.50 11.36           C
ATOM   1336  C   MET   157     -49.104  17.647   2.216  0.50  8.33           C
ATOM   1338  O   MET   157     -49.097  18.375   3.226  0.50  7.60           O
ATOM   1340  N   VAL   158     -48.020  17.067   1.700  1.00  7.62           N
ATOM   1341  CA  VAL   158     -46.738  17.073   2.389  1.00  7.60           C
ATOM   1342  CB  VAL   158     -45.769  16.001   1.870  1.00  7.87           C
ATOM   1343  CG1 VAL   158     -45.363  16.267   0.375  1.00  6.80           C
ATOM   1344  CG2 VAL   158     -44.556  15.904   2.800  1.00  5.50           C
ATOM   1345  C   VAL   158     -46.161  18.504   2.448  1.00  8.05           C
ATOM   1346  O   VAL   158     -45.655  18.951   3.498  1.00  7.94           O
ATOM   1347  N   ASN   159     -46.268  19.258   1.359  1.00  6.99           N
ATOM   1348  CA  ASN   159     -45.679  20.596   1.364  1.00  8.56           C
ATOM   1349  CB  ASN   159     -45.517  21.063  -0.110  1.00  9.44           C
ATOM   1350  CG  ASN   159     -44.267  20.391  -0.770  1.00 13.46           C
ATOM   1351  OD1 ASN   159     -43.115  20.774  -0.449  1.00 13.49           O
ATOM   1352  ND2 ASN   159     -44.491  19.365  -1.676  1.00 11.04           N
ATOM   1353  C   ASN   159     -46.491  21.532   2.299  1.00  8.55           C
ATOM   1354  O   ASN   159     -45.898  22.350   3.007  1.00  8.77           O
ATOM   1355  N   TYR   160     -47.807  21.324   2.393  1.00  8.99           N
ATOM   1356  CA  TYR   160     -48.598  22.206   3.289  1.00  8.46           C
ATOM   1357  CB  TYR   160     -50.076  22.031   3.041  1.00  9.05           C
ATOM   1358  CG  TYR   160     -50.895  23.089   3.758  1.00  6.76           C
ATOM   1359  CD1 TYR   160     -51.004  24.373   3.254  1.00  6.16           C
ATOM   1360  CE1 TYR   160     -51.755  25.374   3.951  1.00  6.68           C
ATOM   1361  CZ  TYR   160     -52.367  25.032   5.159  1.00  6.05           C
ATOM   1362  OH  TYR   160     -53.125  25.927   5.884  1.00  6.88           O
ATOM   1363  CE2 TYR   160     -52.260  23.729   5.663  1.00  7.56           C
ATOM   1364  CD2 TYR   160     -51.513  22.779   4.968  1.00  8.31           C
ATOM   1365  C   TYR   160     -48.297  21.873   4.749  1.00  8.41           C
ATOM   1366  O   TYR   160     -48.341  22.775   5.600  1.00  7.66           O
ATOM   1367  N   PHE   161     -48.025  20.596   5.064  1.00  7.26           N
ATOM   1368  CA  PHE   161     -47.662  20.273   6.467  1.00  7.86           C
ATOM   1369  CB  PHE   161     -47.311  18.790   6.604  1.00  7.74           C
ATOM   1370  CG  PHE   161     -46.983  18.392   7.998  1.00  9.30           C
ATOM   1371  CD1 PHE   161     -48.006  18.107   8.896  1.00 12.83           C
ATOM   1372  CE1 PHE   161     -47.720  17.697  10.215  1.00 11.42           C
ATOM   1373  CZ  PHE   161     -46.391  17.641  10.657  1.00 12.71           C
ATOM   1374  CE2 PHE   161     -45.357  17.968   9.769  1.00 10.83           C
ATOM   1375  CD2 PHE   161     -45.666  18.335   8.433  1.00 11.04           C
ATOM   1376  C   PHE   161     -46.491  21.148   6.954  1.00  7.95           C
ATOM   1377  O   PHE   161     -46.543  21.724   8.066  1.00  9.32           O
ATOM   1378  N   PHE   162     -45.463  21.301   6.114  1.00  6.72           N
ATOM   1379  CA  PHE   162     -44.318  22.124   6.507  1.00  7.65           C
ATOM   1380  CB  PHE   162     -43.078  21.726   5.710  1.00  7.99           C
ATOM   1381  CG  PHE   162     -42.566  20.366   6.105  1.00  9.27           C
ATOM   1382  CD1 PHE   162     -41.714  20.225   7.191  1.00 10.78           C
ATOM   1383  CE1 PHE   162     -41.239  18.956   7.593  1.00 11.91           C
ATOM   1384  CZ  PHE   162     -41.634  17.827   6.904  1.00 11.69           C
ATOM   1385  CE2 PHE   162     -42.511  17.965   5.784  1.00 13.79           C
ATOM   1386  CD2 PHE   162     -42.967  19.220   5.412  1.00 10.23           C
ATOM   1387  C   PHE   162     -44.639  23.608   6.400  1.00  6.36           C
ATOM   1388  O   PHE   162     -44.272  24.414   7.281  1.00  6.77           O
ATOM   1389  N   LEU   163     -45.339  23.986   5.329  1.00  6.53           N
ATOM   1390  CA  LEU   163     -45.685  25.410   5.150  1.00  6.76           C
ATOM   1391  CB  LEU   163     -46.531  25.576   3.876  1.00  6.66           C
ATOM   1392  CG  LEU   163     -46.960  27.017   3.573  1.00  7.04           C
ATOM   1393  CD1 LEU   163     -45.732  27.937   3.372  1.00  9.53           C
ATOM   1394  CD2 LEU   163     -47.878  27.026   2.294  1.00  8.47           C
ATOM   1395  C   LEU   163     -46.462  25.968   6.327  1.00  6.16           C
ATOM   1396  O   LEU   163     -46.251  27.132   6.716  1.00  6.46           O
ATOM   1397  N   SER   164     -47.398  25.156   6.872  1.00  5.30           N
ATOM   1398  CA  SER   164     -48.338  25.682   7.889  1.00  7.61           C
ATOM   1399  CB  SER   164     -49.657  24.912   7.802  1.00  8.19           C
ATOM   1400  OG  SER   164     -49.459  23.552   8.139  1.00  9.73           O
ATOM   1401  C   SER   164     -47.773  25.574   9.326  1.00  7.56           C
ATOM   1402  O   SER   164     -48.479  25.903  10.294  1.00  8.21           O
ATOM   1403  N   THR   165     -46.511  25.154   9.458  1.00  5.79           N
ATOM   1404  CA  THR   165     -45.964  24.822  10.782  1.00  6.26           C
ATOM   1405  CB  THR   165     -44.424  24.572  10.701  1.00  6.23           C
ATOM   1406  OG1 THR   165     -44.184  23.428   9.866  1.00  7.44           O
ATOM   1407  CG2 THR   165     -43.891  24.259  12.117  1.00  8.11           C
ATOM   1408  C   THR   165     -46.186  25.914  11.821  1.00  4.75           C
ATOM   1409  O   THR   165     -46.641  25.626  12.936  1.00  5.25           O
ATOM   1410  N   LEU   166     -45.844  27.165  11.481  1.00  5.75           N
ATOM   1411  CA  LEU   166     -45.911  28.235  12.482  1.00  6.51           C
ATOM   1412  CB  LEU   166     -45.339  29.576  11.965  1.00  6.68           C
ATOM   1413  CG  LEU   166     -43.841  29.678  11.719  1.00 10.81           C
ATOM   1414  CD1 LEU   166     -43.547  31.167  11.394  1.00 11.81           C
ATOM   1415  CD2 LEU   166     -43.055  29.293  13.016  1.00 11.69           C
ATOM   1416  C   LEU   166     -47.337  28.456  12.986  1.00  7.46           C
ATOM   1417  O   LEU   166     -47.491  28.973  14.095  1.00  8.56           O
ATOM   1418  N   ALA   167     -48.369  28.123  12.171  1.00  6.08           N
ATOM   1419  CA  ALA   167     -49.766  28.384  12.541  1.00  8.18           C
ATOM   1420  CB  ALA   167     -50.626  28.722  11.311  1.00  7.47           C
ATOM   1421  C   ALA   167     -50.387  27.203  13.251  1.00  8.91           C
ATOM   1422  O   ALA   167     -51.532  27.304  13.723  1.00  9.05           O
ATOM   1423  N   THR   168     -49.662  26.096  13.285  1.00  8.62           N
ATOM   1424  CA  THR   168     -50.264  24.857  13.794  1.00 10.98           C
ATOM   1425  CB  THR   168     -50.502  23.867  12.644  1.00  9.39           C
ATOM   1426  OG1 THR   168     -49.275  23.508  11.993  1.00 11.50           O
ATOM   1427  CG2 THR   168     -51.464  24.477  11.542  1.00  9.79           C
ATOM   1428  C   THR   168     -49.423  24.220  14.919  1.00 10.56           C
ATOM   1429  O   THR   168     -49.522  22.997  15.158  1.00 11.79           O
ATOM   1430  N   GLU   169     -48.671  25.069  15.639  1.00 13.47           N
ATOM   1431  CA  GLU   169     -47.634  24.567  16.568  1.00 14.51           C
ATOM   1432  CB  GLU   169     -46.793  25.705  17.190  1.00 15.58           C
ATOM   1433  CG  GLU   169     -45.950  26.533  16.217  1.00 16.67           C
ATOM   1434  CD  GLU   169     -44.641  25.858  15.769  1.00 18.06           C
ATOM   1435  OE1 GLU   169     -44.427  24.660  16.046  1.00 20.34           O
ATOM   1436  OE2 GLU   169     -43.824  26.515  15.088  1.00 17.77           O
ATOM   1437  C   GLU   169     -48.280  23.732  17.661  1.00 14.80           C
ATOM   1438  O   GLU   169     -47.758  22.662  18.045  1.00 15.84           O
ATOM   1439  N   GLY   170     -49.391  24.218  18.188  1.00 14.31           N
ATOM   1440  CA  GLY   170     -50.050  23.519  19.293  1.00 15.34           C
ATOM   1441  C   GLY   170     -51.115  22.570  18.807  1.00 14.96           C
ATOM   1442  O   GLY   170     -51.802  21.946  19.628  1.00 15.30           O
ATOM   1443  N   LEU   171     -51.257  22.405  17.486  1.00 11.97           N
ATOM   1444  CA  LEU   171     -52.364  21.571  16.985  1.00 12.07           C
ATOM   1445  CB  LEU   171     -53.048  22.173  15.739  1.00 11.20           C
ATOM   1446  CG  LEU   171     -53.567  23.620  15.751  1.00 13.56           C
ATOM   1447  CD1 LEU   171     -54.356  23.917  14.477  1.00 12.40           C
ATOM   1448  CD2 LEU   171     -54.410  23.968  16.985  1.00 16.09           C
ATOM   1449  C   LEU   171     -51.901  20.179  16.629  1.00 12.32           C
ATOM   1450  O   LEU   171     -52.706  19.251  16.620  1.00 12.27           O
ATOM   1451  N   THR   172     -50.620  20.021  16.304  1.00 11.32           N
ATOM   1452  CA  THR   172     -50.093  18.690  15.929  1.00 12.36           C
ATOM   1453  CB  THR   172     -50.439  18.296  14.451  1.00 11.94           C
ATOM   1454  OG1 THR   172     -50.076  16.907  14.240  1.00 16.35           O
ATOM   1455  CG2 THR   172     -49.710  19.217  13.452  1.00 12.29           C
ATOM   1456  C   THR   172     -48.585  18.711  16.141  1.00 12.72           C
ATOM   1457  O   THR   172     -47.994  19.812  16.226  1.00 13.87           O
ATOM   1458  N   SER   173     -47.958  17.545  16.214  1.00 12.97           N
ATOM   1459  CA  SER   173     -46.524  17.503  16.397  1.00 11.93           C
ATOM   1460  CB  SER   173     -46.103  16.108  16.826  1.00 13.97           C
ATOM   1461  OG  SER   173     -44.681  15.989  16.771  1.00 14.44           O
ATOM   1462  C   SER   173     -45.874  17.806  15.060  1.00 12.33           C
ATOM   1463  O   SER   173     -46.353  17.332  14.028  1.00 12.42           O
ATOM   1464  N   HIS   174     -44.824  18.610  15.068  1.00 12.00           N
ATOM   1465  CA  HIS   174     -43.970  18.721  13.876  1.00 14.23           C
ATOM   1466  CB  HIS   174     -43.909  20.171  13.391  1.00 14.23           C
ATOM   1467  CG  HIS   174     -45.247  20.722  13.030  1.00 15.81           C
ATOM   1468  ND1 HIS   174     -46.071  21.324  13.968  1.00 16.61           N
ATOM   1469  CE1 HIS   174     -47.185  21.718  13.368  1.00 20.91           C
ATOM   1470  NE2 HIS   174     -47.116  21.386  12.085  1.00 19.63           N
ATOM   1471  CD2 HIS   174     -45.900  20.785  11.839  1.00 17.42           C
ATOM   1472  C   HIS   174     -42.578  18.183  14.149  1.00 13.15           C
ATOM   1473  O   HIS   174     -41.625  18.515  13.427  1.00 14.79           O
ATOM   1474  N   SER   175     -42.456  17.352  15.179  1.00 14.28           N
ATOM   1475  CA  SER   175     -41.158  16.794  15.566  1.00 13.71           C
ATOM   1476  CB  SER   175     -41.281  16.104  16.921  1.00 14.35           C
ATOM   1477  OG  SER   175     -40.255  15.138  17.113  1.00 17.37           O
ATOM   1478  C   SER   175     -40.645  15.822  14.475  1.00 13.44           C
ATOM   1479  O   SER   175     -41.412  15.024  13.953  1.00 12.58           O
ATOM   1480  N   PRO   176     -39.341  15.882  14.146  1.00 13.15           N
ATOM   1481  CA  PRO   176     -38.830  14.880  13.178  1.00 13.22           C
ATOM   1482  CB  PRO   176     -37.342  15.224  13.064  1.00 13.70           C
ATOM   1483  CG  PRO   176     -37.228  16.655  13.534  1.00 13.98           C
ATOM   1484  CD  PRO   176     -38.278  16.806  14.593  1.00 13.08           C
ATOM   1485  C   PRO   176     -39.045  13.413  13.624  1.00 14.24           C
ATOM   1486  O   PRO   176     -39.154  12.527  12.770  1.00 13.21           O
ATOM   1487  N   ASP   177     -39.134  13.171  14.936  1.00 14.82           N
ATOM   1488  CA  ASP   177     -39.514  11.855  15.496  1.00 16.58           C
ATOM   1489  CB  ASP   177     -39.811  11.976  17.000  1.00 17.92           C
ATOM   1490  CG  ASP   177     -38.610  12.345  17.796  1.00 24.07           C
ATOM   1491  OD1 ASP   177     -37.500  12.389  17.204  1.00 30.89           O
ATOM   1492  OD2 ASP   177     -38.764  12.562  19.024  1.00 30.05           O
ATOM   1493  C   ASP   177     -40.780  11.270  14.887  1.00 15.97           C
ATOM   1494  O   ASP   177     -40.967  10.047  14.905  1.00 16.38           O
ATOM   1495  N   GLN   178     -41.655  12.147  14.404  1.00 14.77           N
ATOM   1496  CA  GLN   178     -42.965  11.735  13.923  1.00 15.23           C
ATOM   1497  CB  GLN   178     -44.057  12.637  14.515  1.00 16.28           C
ATOM   1498  CG  GLN   178     -44.212  12.558  16.075  1.00 18.38           C
ATOM   1499  CD  GLN   178     -44.416  11.148  16.555  1.00 24.89           C
ATOM   1500  OE1 GLN   178     -45.323  10.454  16.094  1.00 28.81           O
ATOM   1501  NE2 GLN   178     -43.556  10.694  17.466  1.00 23.68           N
ATOM   1502  C   GLN   178     -43.060  11.731  12.390  1.00 14.33           C
ATOM   1503  O   GLN   178     -44.153  11.563  11.837  1.00 14.25           O
ATOM   1504  N   ASP   179     -41.935  11.946  11.715  1.00 13.75           N
ATOM   1505  CA  ASP   179     -41.931  12.025  10.241  1.00 12.28           C
ATOM   1506  CB  ASP   179     -40.565  12.503   9.712  1.00 12.21           C
ATOM   1507  CG  ASP   179     -40.345  14.003   9.887  1.00 12.00           C
ATOM   1508  OD1 ASP   179     -41.340  14.728  10.133  1.00 12.73           O
ATOM   1509  OD2 ASP   179     -39.178  14.458   9.767  1.00 10.97           O
ATOM   1510  C   ASP   179     -42.333  10.695   9.583  1.00 12.43           C
ATOM   1511  O   ASP   179     -43.076  10.688   8.586  1.00 11.55           O
ATOM   1512  N   GLU   180     -41.873   9.564  10.129  1.00 12.85           N
ATOM   1513  CA  GLU   180     -42.244   8.281   9.539  1.00 13.39           C
ATOM   1514  CB  GLU   180     -41.363   7.129  10.047  1.00 14.36           C
ATOM   1515  CG  GLU   180     -39.961   7.112   9.416  1.00 16.71           C
ATOM   1516  CD  GLU   180     -39.971   6.815   7.917  1.00 18.99           C
ATOM   1517  OE1 GLU   180     -40.744   5.922   7.502  1.00 20.42           O
ATOM   1518  OE2 GLU   180     -39.200   7.469   7.161  1.00 18.63           O
ATOM   1519  C   GLU   180     -43.734   8.019   9.746  1.00 13.71           C
ATOM   1520  O   GLU   180     -44.403   7.448   8.873  1.00 13.28           O
ATOM   1521  N   GLU   181     -44.271   8.460  10.883  1.00 13.78           N
ATOM   1522  CA  GLU   181     -45.689   8.305  11.124  1.00 14.42           C
ATOM   1523  CB  GLU   181     -45.998   8.599  12.588  1.00 16.10           C
ATOM   1524  CG  GLU   181     -47.472   8.632  12.901  1.00 21.01           C
ATOM   1525  CD  GLU   181     -48.173   7.282  12.774  1.00 23.11           C
ATOM   1526  OE1 GLU   181     -47.514   6.228  12.665  1.00 24.17           O
ATOM   1527  OE2 GLU   181     -49.422   7.301  12.790  1.00 25.06           O
ATOM   1528  C   GLU   181     -46.494   9.212  10.185  1.00 14.14           C
ATOM   1529  O   GLU   181     -47.564   8.828   9.706  1.00 14.26           O
ATOM   1530  N   LEU   182     -45.956  10.396   9.878  1.00 13.08           N
ATOM   1531  CA  LEU   182     -46.604  11.293   8.915  1.00 13.64           C
ATOM   1532  CB  LEU   182     -45.865  12.643   8.831  1.00 12.83           C
ATOM   1533  CG  LEU   182     -46.579  13.680   7.940  1.00 14.91           C
ATOM   1534  CD1 LEU   182     -47.863  14.196   8.590  1.00 15.08           C
ATOM   1535  CD2 LEU   182     -45.644  14.827   7.575  1.00 15.95           C
ATOM   1536  C   LEU   182     -46.678  10.637   7.522  1.00 13.14           C
ATOM   1537  O   LEU   182     -47.718  10.661   6.855  1.00 14.11           O
ATOM   1538  N   ILE   183     -45.576  10.050   7.084  1.00 12.68           N
ATOM   1539  CA  ILE   183     -45.564   9.306   5.810  1.00 11.35           C
ATOM   1540  CB  ILE   183     -44.189   8.673   5.546  1.00 10.84           C
ATOM   1541  CG1 ILE   183     -43.122   9.766   5.347  1.00 12.02           C
ATOM   1542  CD1 ILE   183     -41.658   9.195   5.429  1.00 11.23           C
ATOM   1543  CG2 ILE   183     -44.228   7.768   4.309  1.00 11.12           C
ATOM   1544  C   ILE   183     -46.664   8.205   5.800  1.00 11.45           C
ATOM   1545  O   ILE   183     -47.422   8.086   4.830  1.00 10.62           O
ATOM   1546  N   ARG   184     -46.735   7.438   6.884  0.50 11.53           N
ATOM   1548  CA  ARG   184     -47.720   6.369   7.046  0.50 11.75           C
ATOM   1550  CB  ARG   184     -47.569   5.750   8.435  0.50 12.01           C
ATOM   1552  CG  ARG   184     -47.839   4.275   8.512  0.50 14.69           C
ATOM   1554  CD  ARG   184     -47.348   3.699   9.852  0.50 17.23           C
ATOM   1556  NE  ARG   184     -45.897   3.490   9.822  0.50 20.38           N
ATOM   1558  CZ  ARG   184     -45.023   3.988  10.695  0.50 19.61           C
ATOM   1560  NH1 ARG   184     -43.738   3.716  10.523  0.50 21.24           N
ATOM   1562  NH2 ARG   184     -45.415   4.720  11.740  0.50 16.19           N
ATOM   1564  C   ARG   184     -49.137   6.937   6.888  0.50 11.09           C
ATOM   1566  O   ARG   184     -49.974   6.363   6.185  0.50 10.52           O
ATOM   1568  N   GLN   185     -49.387   8.070   7.541  1.00 10.20           N
ATOM   1569  CA  GLN   185     -50.693   8.718   7.492  1.00 11.34           C
ATOM   1570  CB  GLN   185     -50.812   9.832   8.557  1.00 11.76           C
ATOM   1571  CG  GLN   185     -50.910   9.329   9.971  1.00 13.90           C
ATOM   1572  CD  GLN   185     -50.827  10.475  10.988  1.00 16.31           C
ATOM   1573  OE1 GLN   185     -51.146  11.627  10.670  1.00 24.88           O
ATOM   1574  NE2 GLN   185     -50.379  10.163  12.192  1.00 22.00           N
ATOM   1575  C   GLN   185     -51.069   9.294   6.120  1.00 10.79           C
ATOM   1576  O   GLN   185     -52.231   9.134   5.675  1.00 10.92           O
ATOM   1577  N   TYR   186     -50.095   9.901   5.436  1.00  9.48           N
ATOM   1578  CA  TYR   186     -50.375  10.550   4.165  1.00 10.97           C
ATOM   1579  CB  TYR   186     -49.386  11.701   3.929  1.00 11.73           C
ATOM   1580  CG  TYR   186     -49.831  12.983   4.689  1.00 11.89           C
ATOM   1581  CD1 TYR   186     -50.901  12.943   5.618  1.00 16.50           C
ATOM   1582  CE1 TYR   186     -51.319  14.116   6.323  1.00 16.69           C
ATOM   1583  CZ  TYR   186     -50.665  15.304   6.104  1.00 15.60           C
ATOM   1584  OH  TYR   186     -51.066  16.479   6.789  1.00 16.29           O
ATOM   1585  CE2 TYR   186     -49.579  15.336   5.236  1.00 15.60           C
ATOM   1586  CD2 TYR   186     -49.176  14.184   4.529  1.00 16.97           C
ATOM   1587  C   TYR   186     -50.456   9.510   3.024  1.00 10.48           C
ATOM   1588  O   TYR   186     -51.313   9.616   2.143  1.00 10.25           O
ATOM   1589  N   VAL   187     -49.660   8.448   3.114  1.00 10.81           N
ATOM   1590  CA  VAL   187     -49.813   7.308   2.195  1.00 11.07           C
ATOM   1591  CB  VAL   187     -48.750   6.195   2.457  1.00 12.17           C
ATOM   1592  CG1 VAL   187     -49.152   4.865   1.801  1.00 12.64           C
ATOM   1593  CG2 VAL   187     -47.381   6.636   1.948  1.00 12.10           C
ATOM   1594  C   VAL   187     -51.238   6.738   2.348  1.00 10.78           C
ATOM   1595  O   VAL   187     -51.902   6.468   1.365  1.00 11.55           O
ATOM   1596  N   ALA   188     -51.697   6.596   3.591  1.00 10.35           N
ATOM   1597  CA  ALA   188     -53.016   6.013   3.862  1.00 10.34           C
ATOM   1598  CB  ALA   188     -53.214   5.835   5.322  1.00 10.03           C
ATOM   1599  C   ALA   188     -54.109   6.923   3.278  1.00 10.52           C
ATOM   1600  O   ALA   188     -54.976   6.440   2.532  1.00 11.14           O
ATOM   1601  N   ILE   189     -54.067   8.223   3.582  1.00  9.18           N
ATOM   1602  CA  ILE   189     -55.064   9.134   3.022  1.00 10.18           C
ATOM   1603  CB  ILE   189     -54.855  10.573   3.534  1.00 10.61           C
ATOM   1604  CG1 ILE   189     -55.136  10.601   5.058  1.00 10.98           C
ATOM   1605  CD1 ILE   189     -54.723  11.960   5.716  1.00 13.83           C
ATOM   1606  CG2 ILE   189     -55.802  11.563   2.805  1.00 11.30           C
ATOM   1607  C   ILE   189     -55.041   9.113   1.474  1.00  9.70           C
ATOM   1608  O   ILE   189     -56.074   9.014   0.819  1.00  9.40           O
ATOM   1609  N   PHE   190     -53.857   9.209   0.889  1.00  9.58           N
ATOM   1610  CA  PHE   190     -53.805   9.360  -0.550  1.00  9.58           C
ATOM   1611  CB  PHE   190     -52.360   9.611  -0.993  1.00 10.23           C
ATOM   1612  CG  PHE   190     -52.226  10.008  -2.454  1.00  9.45           C
ATOM   1613  CD1 PHE   190     -52.917  11.128  -2.945  1.00  9.44           C
ATOM   1614  CE1 PHE   190     -52.804  11.478  -4.324  1.00  8.91           C
ATOM   1615  CZ  PHE   190     -51.991  10.716  -5.159  1.00  8.37           C
ATOM   1616  CE2 PHE   190     -51.307   9.595  -4.666  1.00 10.34           C
ATOM   1617  CD2 PHE   190     -51.432   9.256  -3.313  1.00  9.34           C
ATOM   1618  C   PHE   190     -54.341   8.115  -1.252  1.00 10.23           C
ATOM   1619  O   PHE   190     -55.013   8.227  -2.272  1.00 10.36           O
ATOM   1620  N   THR   191     -54.011   6.933  -0.728  1.00 10.49           N
ATOM   1621  CA  THR   191     -54.331   5.687  -1.425  1.00 11.39           C
ATOM   1622  CB  THR   191     -53.251   4.575  -1.187  1.00 11.16           C
ATOM   1623  OG1 THR   191     -53.129   4.320   0.203  1.00 13.70           O
ATOM   1624  CG2 THR   191     -51.894   5.021  -1.716  1.00 12.85           C
ATOM   1625  C   THR   191     -55.730   5.173  -1.057  1.00 11.49           C
ATOM   1626  O   THR   191     -56.413   4.630  -1.920  1.00 11.57           O
ATOM   1627  N   ARG   192     -56.142   5.361   0.207  1.00 11.47           N
ATOM   1628  CA  ARG   192     -57.377   4.780   0.764  1.00 12.54           C
ATOM   1629  CB  ARG   192     -57.043   3.762   1.863  1.00 13.38           C
ATOM   1630  CG  ARG   192     -56.218   2.608   1.352  1.00 19.78           C
ATOM   1631  CD  ARG   192     -55.838   1.648   2.458  1.00 27.83           C
ATOM   1632  NE  ARG   192     -54.833   2.186   3.390  1.00 31.16           N
ATOM   1633  CZ  ARG   192     -54.979   2.196   4.710  1.00 30.70           C
ATOM   1634  NH1 ARG   192     -56.099   1.741   5.268  1.00 34.65           N
ATOM   1635  NH2 ARG   192     -54.007   2.636   5.480  1.00 31.86           N
ATOM   1636  C   ARG   192     -58.394   5.793   1.313  1.00 11.41           C
ATOM   1637  O   ARG   192     -59.513   5.408   1.694  1.00 11.66           O
ATOM   1638  N   GLY   193     -57.999   7.067   1.407  1.00 10.15           N
ATOM   1639  CA  GLY   193     -58.897   8.124   1.894  1.00  9.23           C
ATOM   1640  C   GLY   193     -59.105   8.042   3.399  1.00 10.71           C
ATOM   1641  O   GLY   193     -58.465   7.238   4.070  1.00 11.66           O
ATOM   1642  N   ILE   194     -60.015   8.848   3.940  1.00 10.09           N
ATOM   1643  CA  ILE   194     -60.233   8.806   5.378  1.00 10.51           C
ATOM   1644  CB  ILE   194     -60.410  10.235   5.966  1.00  9.22           C
ATOM   1645  CG1 ILE   194     -61.635  10.937   5.378  1.00  9.15           C
ATOM   1646  CD1 ILE   194     -62.095  12.150   6.229  1.00 10.65           C
ATOM   1647  CG2 ILE   194     -59.149  11.099   5.736  1.00 10.26           C
ATOM   1648  C   ILE   194     -61.435   7.920   5.776  1.00 13.00           C
ATOM   1649  O   ILE   194     -61.677   7.686   6.986  1.00 11.91           O
ATOM   1650  N   MET   195     -62.162   7.427   4.770  0.80 13.74           N
ATOM   1652  CA  MET   195     -63.370   6.618   5.035  0.80 19.32           C
ATOM   1654  CB  MET   195     -64.062   6.224   3.735  0.80 17.64           C
ATOM   1656  CG  MET   195     -63.224   5.251   2.910  0.80 22.42           C
ATOM   1658  SD  MET   195     -64.053   4.614   1.255  0.80 35.82          SE
ATOM   1660  CE  MET   195     -65.779   4.059   1.995  0.80 28.19           C
ATOM   1662  C   MET   195     -63.024   5.348   5.798  0.80 17.09           C
ATOM   1664  O   MET   195     -61.945   4.789   5.620  0.80 16.40           O
ATOM   1666  N   ALA   196     -63.946   4.892   6.647  1.00 16.54           N
ATOM   1667  CA  ALA   196     -63.751   3.621   7.358  1.00 17.64           C
ATOM   1668  CB  ALA   196     -64.842   3.419   8.388  1.00 17.48           C
ATOM   1669  C   ALA   196     -63.706   2.435   6.397  1.00 18.42           C
ATOM   1670  O   ALA   196     -64.469   2.403   5.437  1.00 19.76           O
END
