
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  201 ( 1559),  selected  201 , name 2iai_A
# Molecule2: number of CA atoms  192 ( 1477),  selected  192 , name T0454.pdb
# PARAMETERS: 2iai_A.T0454.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G    -8_A      D       5           -
LGA    R    -7_A      C       6           -
LGA    E    -6_A      R       7           -
LGA    N    -5_A      S       8           -
LGA    L    -4_A      R       9           -
LGA    Y    -3_A      L      10           -
LGA    F    -2_A      M      11           -
LGA    Q    -1_A      -       -           -
LGA    G     0_A      -       -           -
LGA    X     1_A      -       -           -
LGA    T     2_A      -       -           -
LGA    T     3_A      -       -           -
LGA    A     4_A      -       -           -
LGA    K     5_A      -       -           -
LGA    T    10_A      -       -           -
LGA    P    11_A      -       -           -
LGA    E    12_A      -       -           -
LGA    T    13_A      -       -           -
LGA    L    14_A      E      12          2.497
LGA    L    15_A      -       -           -
LGA    S    16_A      -       -           -
LGA    V    17_A      V      13          2.958
LGA    A    18_A      A      14          2.016
LGA    V    19_A      T      15          2.140
LGA    Q    20_A      E      16          2.208
LGA    V    21_A      L      17          1.626
LGA    F    22_A      F      18          1.699
LGA    I    23_A      A      19          2.227
LGA    E    24_A      Q      20          1.377
LGA    R    25_A      K      21          0.761
LGA    G    26_A      G      22          1.573
LGA    Y    27_A      F      23          1.833
LGA    D    28_A      Y      24          1.699
LGA    G    29_A      G      25          1.520
LGA    T    30_A      V      26          1.576
LGA    S    31_A      S      27          1.589
LGA    X    32_A      I      28          1.648
LGA    E    33_A      R      29          2.219
LGA    H    34_A      E      30          2.492
LGA    L    35_A      L      31          2.183
LGA    S    36_A      A      32          2.556
LGA    K    37_A      Q      33          3.243
LGA    A    38_A      A      34          3.175
LGA    A    39_A      A      35          3.034
LGA    G    40_A      G      36          4.018
LGA    I    41_A      A      37          3.485
LGA    S    42_A      S      38          3.284
LGA    K    43_A      I      39          2.712
LGA    S    44_A      S      40          3.410
LGA    S    45_A      M      41          4.080
LGA    I    46_A      I      42          3.802
LGA    -       -      S      43           -
LGA    Y    47_A      Y      44           #
LGA    H    48_A      H      45          4.889
LGA    H    49_A      -       -           -
LGA    V    50_A      F      46          2.180
LGA    T    51_A      G      47          0.801
LGA    G    52_A      G      48          2.422
LGA    K    53_A      K      49          3.129
LGA    E    54_A      E      50          2.922
LGA    E    55_A      G      51          2.889
LGA    L    56_A      L      52          3.119
LGA    L    57_A      Y      53          3.166
LGA    R    58_A      A      54          2.772
LGA    R    59_A      A      55          3.008
LGA    -       -      V      56           -
LGA    -       -      L      57           -
LGA    -       -      Q      58           -
LGA    A    60_A      E      59          3.033
LGA    V    61_A      Q      60          3.691
LGA    S    62_A      F      61          3.661
LGA    R    63_A      A      62          2.271
LGA    A    64_A      C      63          4.477
LGA    L    65_A      F      64          2.596
LGA    D    66_A      G      65          3.159
LGA    E    67_A      -       -           -
LGA    L    68_A      -       -           -
LGA    F    69_A      -       -           -
LGA    G    70_A      Q      66          1.877
LGA    I    71_A      L      67          2.709
LGA    L    72_A      D      68          4.165
LGA    D    73_A      D      69           #
LGA    E    74_A      I      70          4.962
LGA    E    75_A      R      71           #
LGA    H    76_A      G      72          4.302
LGA    A    77_A      Q      73          2.507
LGA    R    78_A      A      74          3.308
LGA    V    79_A      -       -           -
LGA    G    80_A      G      75          4.103
LGA    T    81_A      D      76          2.057
LGA    A    82_A      -       -           -
LGA    A    83_A      P      77          1.731
LGA    E    84_A      L      78          2.925
LGA    R    85_A      A      79          3.595
LGA    L    86_A      V      80          2.567
LGA    E    87_A      M      81          2.159
LGA    Y    88_A      T      82          2.915
LGA    V    89_A      A      83          3.333
LGA    V    90_A      Y      84          2.799
LGA    R    91_A      L      85          2.104
LGA    R    92_A      R      86          2.736
LGA    X    93_A      W      87          3.689
LGA    V    94_A      T      88          2.797
LGA    E    95_A      I      89          2.326
LGA    V    96_A      Q      90          3.336
LGA    L    97_A      R      91          3.410
LGA    X    98_A      H      92          1.898
LGA    A    99_A      R      93          2.731
LGA    E   100_A      N      94          4.015
LGA    L   101_A      N      95          3.502
LGA    P   102_A      P      96          4.007
LGA    Y   103_A      Q      97          5.008
LGA    V   104_A      L      98          3.136
LGA    T   105_A      L      99          1.693
LGA    -       -      R     100           -
LGA    L   106_A      F     101          1.227
LGA    L   107_A      Y     102          3.083
LGA    L   108_A      T     103          3.912
LGA    R   109_A      S     104          2.727
LGA    V   110_A      E     105          1.480
LGA    -       -      L     106           -
LGA    -       -      T     107           -
LGA    R   111_A      N     108          3.936
LGA    G   112_A      P     109          2.416
LGA    N   113_A      T     110          4.355
LGA    T   114_A      P     111          1.508
LGA    G   115_A      C     112          4.971
LGA    T   116_A      -       -           -
LGA    E   117_A      F     113          2.273
LGA    R   118_A      A     114          1.293
LGA    W   119_A      A     115          1.107
LGA    A   120_A      I     116          1.665
LGA    L   121_A      V     117          3.831
LGA    -       -      S     118           -
LGA    E   122_A      P     119          2.795
LGA    R   123_A      A     120          3.287
LGA    R   124_A      I     121          2.247
LGA    R   125_A      A     122          1.960
LGA    E   126_A      S     123          2.886
LGA    F   127_A      V     124          2.678
LGA    D   128_A      I     125          1.872
LGA    H   129_A      R     126          1.838
LGA    R   130_A      L     127          2.191
LGA    V   131_A      L     128          1.854
LGA    A   132_A      A     129          1.144
LGA    A   133_A      E     130          1.059
LGA    L   134_A      S     131          1.335
LGA    L   135_A      I     132          1.204
LGA    K   136_A      E     133          0.796
LGA    D   137_A      A     134          1.006
LGA    A   138_A      G     135          1.474
LGA    A   139_A      M     136          1.452
LGA    A   140_A      T     137          1.353
LGA    E   141_A      R     138          1.622
LGA    G   142_A      G     139          1.802
LGA    D   143_A      L     140          1.786
LGA    V   144_A      F     141          1.976
LGA    R   145_A      R     142          2.262
LGA    A   146_A      R     143          2.201
LGA    D   147_A      D     144          2.668
LGA    V   148_A      L     145          1.896
LGA    E   149_A      H     146          1.557
LGA    V   150_A      A     147          1.385
LGA    R   151_A      V     148          1.714
LGA    L   152_A      N     149          1.472
LGA    A   153_A      S     150          1.203
LGA    T   154_A      A     151          1.493
LGA    R   155_A      L     152          1.750
LGA    L   156_A      A     153          1.790
LGA    V   157_A      L     154          1.733
LGA    F   158_A      A     155          1.655
LGA    G   159_A      G     156          1.576
LGA    X   160_A      M     157          1.517
LGA    I   161_A      V     158          2.025
LGA    N   162_A      N     159          1.861
LGA    S   163_A      Y     160          1.360
LGA    I   164_A      F     161          3.184
LGA    V   165_A      F     162          3.528
LGA    E   166_A      L     163          1.557
LGA    W   167_A      S     164          3.210
LGA    -       -      T     165           -
LGA    -       -      L     166           -
LGA    -       -      A     167           -
LGA    -       -      T     168           -
LGA    -       -      E     169           -
LGA    -       -      G     170           -
LGA    -       -      L     171           -
LGA    -       -      T     172           -
LGA    -       -      S     173           -
LGA    Y   168_A      H     174           #
LGA    R   169_A      -       -           -
LGA    P   170_A      S     175           #
LGA    E   171_A      -       -           -
LGA    S   183_A      -       -           -
LGA    G   184_A      -       -           -
LGA    V   185_A      -       -           -
LGA    S   186_A      -       -           -
LGA    G   187_A      P     176          4.387
LGA    A   188_A      D     177          1.265
LGA    G   189_A      Q     178          3.054
LGA    E   190_A      D     179          2.867
LGA    R   191_A      E     180          2.535
LGA    E   192_A      E     181          3.166
LGA    V   193_A      L     182          2.912
LGA    V   194_A      I     183          2.819
LGA    D   195_A      R     184          2.876
LGA    A   196_A      Q     185          2.728
LGA    V   197_A      Y     186          2.460
LGA    A   198_A      V     187          2.335
LGA    R   199_A      A     188          2.576
LGA    L   200_A      I     189          2.313
LGA    V   201_A      F     190          2.147
LGA    F   202_A      T     191          2.151
LGA    G   203_A      R     192          2.531
LGA    G   204_A      G     193          2.482
LGA    L   205_A      I     194          2.162
LGA    R   206_A      M     195          2.574
LGA    K   207_A      A     196          3.127

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  201  192    5.0    163    2.68    17.79     56.211     5.871

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.508079 * X  +   0.762544 * Y  +   0.400478 * Z  +  -7.587641
  Y_new =   0.742717 * X  +   0.623331 * Y  +  -0.244602 * Z  +   4.357322
  Z_new =  -0.436149 * X  +   0.173165 * Y  +  -0.883056 * Z  +  25.032495 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.947953   -0.193640  [ DEG:   168.9052    -11.0948 ]
  Theta =   0.451315    2.690278  [ DEG:    25.8585    154.1415 ]
  Phi   =   2.170759   -0.970834  [ DEG:   124.3753    -55.6247 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2iai_A                                        
REMARK     2: T0454.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2iai_A.T0454.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  201  192   5.0  163   2.68   17.79  56.211
REMARK  ---------------------------------------------------------- 
MOLECULE 2iai_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   08-SEP-06   2IAI              
TITLE     CRYSTAL STRUCTURE OF SCO3833, A MEMBER OF THE TETR                    
TITLE    2 TRANSCRIPTIONAL REGULATOR FAMILY FROM STREPTOMYCES                   
TITLE    3 COELICOLOR A3                                                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PUTATIVE TRANSCRIPTIONAL REGULATOR SCO3833;                
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOMYCES COELICOLOR;                        
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: A3;                                                          
SOURCE   5 GENE: SCO3833;                                                       
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21(DE3) STAR MAGIC;                      
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: P15TV LIC                                 
KEYWDS    STRUCTURAL GENOMICS, TETR, TRANSCRIPTIONAL REGULATOR,                 
KEYWDS   2 UNKNOWN FUNCTION, PSI-2, PROTEIN STRUCTURE INITIATIVE,               
KEYWDS   3 MIDWEST CENTER FOR STRUCTURAL GENOMICS, MCSG                         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.D.ZIMMERMAN,X.XU,S.WANG,J.GU,M.CHRUSZCZ,M.CYMBOROWSKI,              
AUTHOR   2 A.SAVCHENKO,A.EDWARDS,W.MINOR,MIDWEST CENTER FOR STRUCTURAL          
AUTHOR   3 GENOMICS (MCSG)                                                      
REVDAT   1   26-SEP-06 2IAI    0                                                
JRNL        AUTH   M.D.ZIMMERMAN,X.XU,S.WANG,J.GU,M.CHRUSZCZ,                   
JRNL        AUTH 2 M.CYMBOROWSKI,A.SAVCHENKO,A.EDWARDS,W.MINOR                  
JRNL        TITL   CRYSTAL STRUCTURE OF SCO3833, A MEMBER OF THE TETR           
JRNL        TITL 2 TRANSCRIPTIONAL REGULATOR FAMILY FROM STREPTOMYCES           
JRNL        TITL 3 COELICOLOR A3                                                
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.65 ANGSTROMS.                                          
DBREF  2IAI A    1   209  UNP    Q9XA31   Q9XA31_STRCO     1    209             
SEQRES   1 A  230  MSE GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 A  230  ARG GLU ASN LEU TYR PHE GLN GLY MSE THR THR ALA LYS          
SEQRES   3 A  230  ARG ASP THR TYR THR PRO GLU THR LEU LEU SER VAL ALA          
SEQRES   4 A  230  VAL GLN VAL PHE ILE GLU ARG GLY TYR ASP GLY THR SER          
SEQRES   5 A  230  MSE GLU HIS LEU SER LYS ALA ALA GLY ILE SER LYS SER          
SEQRES   6 A  230  SER ILE TYR HIS HIS VAL THR GLY LYS GLU GLU LEU LEU          
SEQRES   7 A  230  ARG ARG ALA VAL SER ARG ALA LEU ASP GLU LEU PHE GLY          
SEQRES   8 A  230  ILE LEU ASP GLU GLU HIS ALA ARG VAL GLY THR ALA ALA          
SEQRES   9 A  230  GLU ARG LEU GLU TYR VAL VAL ARG ARG MSE VAL GLU VAL          
SEQRES  10 A  230  LEU MSE ALA GLU LEU PRO TYR VAL THR LEU LEU LEU ARG          
SEQRES  11 A  230  VAL ARG GLY ASN THR GLY THR GLU ARG TRP ALA LEU GLU          
SEQRES  12 A  230  ARG ARG ARG GLU PHE ASP HIS ARG VAL ALA ALA LEU LEU          
SEQRES  13 A  230  LYS ASP ALA ALA ALA GLU GLY ASP VAL ARG ALA ASP VAL          
SEQRES  14 A  230  GLU VAL ARG LEU ALA THR ARG LEU VAL PHE GLY MSE ILE          
SEQRES  15 A  230  ASN SER ILE VAL GLU TRP TYR ARG PRO GLU GLY PRO ASP          
SEQRES  16 A  230  GLY ARG SER ASP ALA SER GLY ALA SER GLY VAL SER GLY          
SEQRES  17 A  230  ALA GLY GLU ARG GLU VAL VAL ASP ALA VAL ALA ARG LEU          
SEQRES  18 A  230  VAL PHE GLY GLY LEU ARG LYS ALA SER                          
HET    MSE  A   1       8                                                       
HET    MSE  A  32       8                                                       
HET    MSE  A  93       8                                                       
HET    MSE  A  98       8                                                       
HET    MSE  A 160       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    5(C5 H11 N O2 SE)                                            
FORMUL   2  HOH   *286(H2 O)                                                    
CRYST1   61.308   61.308  113.865  90.00  90.00 120.00 P 32 2 1      6          
ATOM      1  N   GLY A  -8     -22.031  44.863  23.384  1.00 44.57           N  
ATOM      2  CA  GLY A  -8     -21.013  44.812  24.476  1.00 43.52           C  
ATOM      3  C   GLY A  -8     -21.393  43.687  25.424  1.00 42.60           C  
ATOM      4  O   GLY A  -8     -22.360  42.960  25.176  1.00 43.65           O  
ATOM      5  N   ARG A  -7     -20.661  43.534  26.517  1.00 40.46           N  
ATOM      6  CA  ARG A  -7     -21.015  42.510  27.487  1.00 38.30           C  
ATOM      7  C   ARG A  -7     -22.199  43.036  28.297  1.00 37.99           C  
ATOM      8  O   ARG A  -7     -22.154  44.196  28.734  1.00 40.47           O  
ATOM      9  CB  ARG A  -7     -19.844  42.272  28.450  1.00 38.48           C  
ATOM     10  CG  ARG A  -7     -18.577  41.717  27.743  1.00 38.72           C  
ATOM     11  CD  ARG A  -7     -17.445  41.532  28.761  1.00 38.33           C  
ATOM     12  NE  ARG A  -7     -16.287  40.940  28.129  1.00 38.20           N  
ATOM     13  CZ  ARG A  -7     -15.344  41.622  27.494  1.00 37.05           C  
ATOM     14  NH1 ARG A  -7     -15.396  42.971  27.404  1.00 35.91           N  
ATOM     15  NH2 ARG A  -7     -14.335  40.965  26.953  1.00 41.64           N  
ATOM     16  N   GLU A  -6     -23.237  42.221  28.472  1.00 34.25           N  
ATOM     17  CA  GLU A  -6     -24.404  42.623  29.237  1.00 35.36           C  
ATOM     18  C   GLU A  -6     -24.375  41.928  30.589  1.00 32.31           C  
ATOM     19  O   GLU A  -6     -24.171  40.759  30.664  1.00 31.55           O  
ATOM     20  CB  GLU A  -6     -25.683  42.179  28.528  1.00 35.79           C  
ATOM     21  CG  GLU A  -6     -25.859  42.695  27.193  1.00 40.04           C  
ATOM     22  CD  GLU A  -6     -27.258  42.418  26.664  1.00 41.10           C  
ATOM     23  OE1 GLU A  -6     -28.108  41.722  27.347  1.00 46.71           O  
ATOM     24  OE2 GLU A  -6     -27.506  42.924  25.555  1.00 48.55           O  
ATOM     25  N   ASN A  -5     -24.668  42.685  31.667  1.00 31.42           N  
ATOM     26  CA  ASN A  -5     -24.694  42.143  33.009  1.00 30.95           C  
ATOM     27  C   ASN A  -5     -25.844  41.145  33.044  1.00 28.97           C  
ATOM     28  O   ASN A  -5     -26.968  41.452  32.573  1.00 31.05           O  
ATOM     29  CB  ASN A  -5     -24.942  43.296  33.944  1.00 31.15           C  
ATOM     30  CG  ASN A  -5     -24.773  42.991  35.405  1.00 35.45           C  
ATOM     31  OD1 ASN A  -5     -24.805  41.839  35.841  1.00 34.60           O  
ATOM     32  ND2 ASN A  -5     -24.681  44.079  36.205  1.00 35.81           N  
ATOM     33  N   LEU A  -4     -25.551  39.940  33.570  1.00 30.94           N  
ATOM     34  CA  LEU A  -4     -26.575  38.926  33.742  1.00 30.56           C  
ATOM     35  C   LEU A  -4     -27.303  38.974  35.078  1.00 31.57           C  
ATOM     36  O   LEU A  -4     -28.282  38.221  35.300  1.00 32.44           O  
ATOM     37  CB  LEU A  -4     -26.010  37.531  33.504  1.00 31.38           C  
ATOM     38  CG  LEU A  -4     -25.695  37.277  32.029  1.00 33.58           C  
ATOM     39  CD1 LEU A  -4     -24.771  36.055  31.902  1.00 35.34           C  
ATOM     40  CD2 LEU A  -4     -26.900  37.030  31.256  1.00 35.25           C  
ATOM     41  N   TYR A  -3     -26.858  39.886  35.941  1.00 31.39           N  
ATOM     42  CA  TYR A  -3     -27.388  39.977  37.296  1.00 31.71           C  
ATOM     43  C   TYR A  -3     -27.386  38.605  37.974  1.00 30.53           C  
ATOM     44  O   TYR A  -3     -28.370  38.152  38.539  1.00 30.58           O  
ATOM     45  CB  TYR A  -3     -28.756  40.694  37.303  1.00 30.47           C  
ATOM     46  CG  TYR A  -3     -28.618  42.074  36.766  1.00 30.81           C  
ATOM     47  CD1 TYR A  -3     -28.196  43.139  37.583  1.00 32.23           C  
ATOM     48  CD2 TYR A  -3     -28.758  42.307  35.433  1.00 32.02           C  
ATOM     49  CE1 TYR A  -3     -27.982  44.402  37.092  1.00 29.68           C  
ATOM     50  CE2 TYR A  -3     -28.571  43.590  34.880  1.00 30.39           C  
ATOM     51  CZ  TYR A  -3     -28.150  44.649  35.713  1.00 31.75           C  
ATOM     52  OH  TYR A  -3     -27.943  45.885  35.131  1.00 31.34           O  
ATOM     53  N   PHE A  -2     -26.215  37.981  37.953  1.00 29.72           N  
ATOM     54  CA  PHE A  -2     -26.012  36.730  38.660  1.00 30.12           C  
ATOM     55  C   PHE A  -2     -24.549  36.559  38.970  1.00 31.11           C  
ATOM     56  O   PHE A  -2     -23.748  36.230  38.088  1.00 31.22           O  
ATOM     57  CB  PHE A  -2     -26.493  35.465  37.952  1.00 30.25           C  
ATOM     58  CG  PHE A  -2     -26.402  34.279  38.848  1.00 32.72           C  
ATOM     59  CD1 PHE A  -2     -27.320  34.095  39.900  1.00 31.28           C  
ATOM     60  CD2 PHE A  -2     -25.355  33.363  38.731  1.00 33.14           C  
ATOM     61  CE1 PHE A  -2     -27.161  33.042  40.769  1.00 32.27           C  
ATOM     62  CE2 PHE A  -2     -25.241  32.287  39.609  1.00 32.18           C  
ATOM     63  CZ  PHE A  -2     -26.142  32.142  40.615  1.00 32.92           C  
ATOM     64  N   GLN A  -1     -24.199  36.823  40.219  1.00 30.50           N  
ATOM     65  CA  GLN A  -1     -22.846  36.586  40.739  1.00 30.70           C  
ATOM     66  C   GLN A  -1     -21.776  37.225  39.843  1.00 31.05           C  
ATOM     67  O   GLN A  -1     -20.711  36.694  39.651  1.00 31.86           O  
ATOM     68  CB  GLN A  -1     -22.582  35.059  40.903  1.00 31.47           C  
ATOM     69  CG  GLN A  -1     -23.538  34.355  41.857  1.00 31.64           C  
ATOM     70  CD  GLN A  -1     -23.507  34.967  43.271  1.00 33.33           C  
ATOM     71  OE1 GLN A  -1     -22.447  35.454  43.741  1.00 33.99           O  
ATOM     72  NE2 GLN A  -1     -24.663  34.958  43.954  1.00 31.57           N  
ATOM     73  N   GLY A   0     -22.066  38.424  39.362  1.00 31.13           N  
ATOM     74  CA  GLY A   0     -21.117  39.113  38.545  1.00 30.67           C  
ATOM     75  C   GLY A   0     -20.942  38.683  37.106  1.00 31.56           C  
ATOM     76  O   GLY A   0     -20.086  39.239  36.412  1.00 33.20           O  
HETATM   77  N   MSE A   1     -21.666  37.639  36.679  1.00 31.55           N  
HETATM   78  CA  MSE A   1     -21.521  37.117  35.310  1.00 31.66           C  
HETATM   79  C   MSE A   1     -22.070  38.130  34.311  1.00 32.67           C  
HETATM   80  O   MSE A   1     -23.002  38.916  34.624  1.00 32.41           O  
HETATM   81  CB  MSE A   1     -22.280  35.831  35.159  1.00 32.04           C  
HETATM   82  CG  MSE A   1     -21.809  34.701  36.032  1.00 31.57           C  
HETATM   83 SE   MSE A   1     -22.630  33.072  35.569  0.50 29.98          SE  
HETATM   84  CE  MSE A   1     -22.198  32.155  37.280  1.00 35.23           C  
ATOM     85  N   THR A   2     -21.509  38.087  33.106  1.00 30.64           N  
ATOM     86  CA  THR A   2     -21.984  38.870  31.973  1.00 31.12           C  
ATOM     87  C   THR A   2     -22.122  37.968  30.753  1.00 30.65           C  
ATOM     88  O   THR A   2     -21.581  36.881  30.701  1.00 30.45           O  
ATOM     89  CB  THR A   2     -21.027  40.029  31.591  1.00 31.86           C  
ATOM     90  OG1 THR A   2     -19.849  39.524  30.941  1.00 30.14           O  
ATOM     91  CG2 THR A   2     -20.634  40.839  32.780  1.00 32.28           C  
ATOM     92  N   THR A   3     -22.803  38.472  29.710  1.00 30.80           N  
ATOM     93  CA  THR A   3     -22.698  37.859  28.406  1.00 31.78           C  
ATOM     94  C   THR A   3     -21.299  38.180  27.798  1.00 32.42           C  
ATOM     95  O   THR A   3     -20.547  39.037  28.302  1.00 33.11           O  
ATOM     96  CB  THR A   3     -23.756  38.338  27.414  1.00 32.42           C  
ATOM     97  OG1 THR A   3     -23.520  39.716  27.111  1.00 31.95           O  
ATOM     98  CG2 THR A   3     -25.200  38.125  27.919  1.00 33.65           C  
ATOM     99  N   ALA A   4     -20.985  37.497  26.703  1.00 33.54           N  
ATOM    100  CA  ALA A   4     -19.903  37.914  25.825  1.00 34.37           C  
ATOM    101  C   ALA A   4     -20.487  38.801  24.745  1.00 35.80           C  
ATOM    102  O   ALA A   4     -21.673  38.708  24.433  1.00 38.67           O  
ATOM    103  CB  ALA A   4     -19.184  36.699  25.184  1.00 35.59           C  
ATOM    104  N   LYS A   5     -19.657  39.606  24.099  1.00 37.17           N  
ATOM    105  CA  LYS A   5     -20.175  40.426  22.973  1.00 37.91           C  
ATOM    106  C   LYS A   5     -20.312  39.601  21.717  1.00 39.08           C  
ATOM    107  O   LYS A   5     -19.869  38.451  21.687  1.00 39.28           O  
ATOM    108  CB  LYS A   5     -19.275  41.620  22.700  1.00 39.54           C  
ATOM    109  N   THR A  10     -18.949  36.330  10.515  1.00 40.61           N  
ATOM    110  CA  THR A  10     -20.022  35.566   9.853  1.00 40.41           C  
ATOM    111  C   THR A  10     -19.551  34.163   9.386  1.00 39.66           C  
ATOM    112  O   THR A  10     -19.051  33.984   8.237  1.00 38.45           O  
ATOM    113  CB  THR A  10     -20.603  36.372   8.675  1.00 40.56           C  
ATOM    114  OG1 THR A  10     -21.125  37.629   9.152  1.00 40.87           O  
ATOM    115  CG2 THR A  10     -21.714  35.576   7.965  1.00 41.12           C  
ATOM    116  N   PRO A  11     -19.735  33.140  10.256  1.00 37.98           N  
ATOM    117  CA  PRO A  11     -19.292  31.815   9.901  1.00 37.76           C  
ATOM    118  C   PRO A  11     -20.188  31.076   8.882  1.00 37.66           C  
ATOM    119  O   PRO A  11     -19.771  30.024   8.374  1.00 37.51           O  
ATOM    120  CB  PRO A  11     -19.288  31.055  11.251  1.00 38.40           C  
ATOM    121  CG  PRO A  11     -19.780  32.003  12.258  1.00 39.14           C  
ATOM    122  CD  PRO A  11     -20.369  33.166  11.590  1.00 39.06           C  
ATOM    123  N   GLU A  12     -21.409  31.568   8.626  1.00 37.02           N  
ATOM    124  CA  GLU A  12     -22.287  30.933   7.612  1.00 35.16           C  
ATOM    125  C   GLU A  12     -21.729  31.262   6.233  1.00 34.04           C  
ATOM    126  O   GLU A  12     -21.063  32.304   6.078  1.00 34.00           O  
ATOM    127  CB  GLU A  12     -23.735  31.441   7.690  1.00 35.19           C  
ATOM    128  CG  GLU A  12     -24.474  31.171   8.961  1.00 36.44           C  
ATOM    129  N   THR A  13     -22.044  30.431   5.214  1.00 31.31           N  
ATOM    130  CA  THR A  13     -21.545  30.670   3.876  1.00 29.99           C  
ATOM    131  C   THR A  13     -22.316  31.809   3.228  1.00 28.20           C  
ATOM    132  O   THR A  13     -23.425  32.129   3.629  1.00 26.25           O  
ATOM    133  CB  THR A  13     -21.749  29.461   2.900  1.00 30.39           C  
ATOM    134  OG1 THR A  13     -23.146  29.217   2.703  1.00 29.37           O  
ATOM    135  CG2 THR A  13     -21.073  28.192   3.427  1.00 31.41           C  
ATOM    136  N   LEU A  14     -21.753  32.391   2.167  1.00 28.43           N  
ATOM    137  CA  LEU A  14     -22.499  33.434   1.456  1.00 27.51           C  
ATOM    138  C   LEU A  14     -23.849  32.921   0.975  1.00 27.11           C  
ATOM    139  O   LEU A  14     -24.883  33.599   1.095  1.00 27.48           O  
ATOM    140  CB  LEU A  14     -21.663  33.994   0.309  1.00 28.41           C  
ATOM    141  CG  LEU A  14     -22.298  35.121  -0.487  1.00 27.21           C  
ATOM    142  CD1 LEU A  14     -22.565  36.335   0.360  1.00 29.35           C  
ATOM    143  CD2 LEU A  14     -21.403  35.404  -1.740  1.00 29.42           C  
ATOM    144  N   LEU A  15     -23.861  31.741   0.385  1.00 26.06           N  
ATOM    145  CA  LEU A  15     -25.142  31.172  -0.042  1.00 27.28           C  
ATOM    146  C   LEU A  15     -26.145  31.039   1.087  1.00 26.48           C  
ATOM    147  O   LEU A  15     -27.330  31.361   0.905  1.00 25.85           O  
ATOM    148  CB  LEU A  15     -24.958  29.835  -0.767  1.00 27.08           C  
ATOM    149  CG  LEU A  15     -26.243  29.228  -1.323  1.00 27.80           C  
ATOM    150  CD1 LEU A  15     -26.843  30.124  -2.329  1.00 29.52           C  
ATOM    151  CD2 LEU A  15     -25.916  27.854  -1.860  1.00 31.22           C  
ATOM    152  N   SER A  16     -25.742  30.515   2.239  1.00 26.91           N  
ATOM    153  CA  SER A  16     -26.701  30.305   3.295  1.00 27.83           C  
ATOM    154  C   SER A  16     -27.220  31.672   3.814  1.00 27.44           C  
ATOM    155  O   SER A  16     -28.396  31.783   4.144  1.00 28.27           O  
ATOM    156  CB  SER A  16     -26.074  29.411   4.408  1.00 27.91           C  
ATOM    157  OG  SER A  16     -25.166  30.118   5.168  1.00 35.52           O  
ATOM    158  N   VAL A  17     -26.364  32.686   3.875  1.00 26.92           N  
ATOM    159  CA  VAL A  17     -26.772  34.062   4.232  1.00 27.04           C  
ATOM    160  C   VAL A  17     -27.803  34.604   3.239  1.00 26.92           C  
ATOM    161  O   VAL A  17     -28.873  35.126   3.608  1.00 26.07           O  
ATOM    162  CB  VAL A  17     -25.532  35.022   4.341  1.00 27.96           C  
ATOM    163  CG1 VAL A  17     -25.922  36.513   4.468  1.00 30.46           C  
ATOM    164  CG2 VAL A  17     -24.684  34.602   5.536  1.00 28.22           C  
ATOM    165  N   ALA A  18     -27.462  34.465   1.973  1.00 26.33           N  
ATOM    166  CA  ALA A  18     -28.321  34.959   0.907  1.00 27.12           C  
ATOM    167  C   ALA A  18     -29.667  34.292   0.944  1.00 25.81           C  
ATOM    168  O   ALA A  18     -30.710  34.955   0.762  1.00 26.79           O  
ATOM    169  CB  ALA A  18     -27.659  34.774  -0.426  1.00 27.42           C  
ATOM    170  N   VAL A  19     -29.694  32.973   1.133  1.00 26.21           N  
ATOM    171  CA  VAL A  19     -30.971  32.267   1.214  1.00 26.40           C  
ATOM    172  C   VAL A  19     -31.826  32.839   2.357  1.00 26.32           C  
ATOM    173  O   VAL A  19     -33.021  33.039   2.173  1.00 25.65           O  
ATOM    174  CB  VAL A  19     -30.728  30.743   1.354  1.00 28.55           C  
ATOM    175  CG1 VAL A  19     -31.940  29.992   1.848  1.00 31.24           C  
ATOM    176  CG2 VAL A  19     -30.262  30.172  -0.022  1.00 29.16           C  
ATOM    177  N   GLN A  20     -31.215  33.093   3.502  1.00 26.47           N  
ATOM    178  CA  GLN A  20     -31.969  33.660   4.638  1.00 27.01           C  
ATOM    179  C   GLN A  20     -32.590  35.014   4.265  1.00 27.20           C  
ATOM    180  O   GLN A  20     -33.718  35.277   4.626  1.00 27.19           O  
ATOM    181  CB  GLN A  20     -31.033  33.804   5.859  1.00 27.69           C  
ATOM    182  CG  GLN A  20     -31.702  34.181   7.161  1.00 28.62           C  
ATOM    183  N   VAL A  21     -31.818  35.883   3.616  1.00 25.65           N  
ATOM    184  CA  VAL A  21     -32.287  37.214   3.215  1.00 26.20           C  
ATOM    185  C   VAL A  21     -33.412  37.078   2.190  1.00 24.84           C  
ATOM    186  O   VAL A  21     -34.457  37.740   2.315  1.00 24.19           O  
ATOM    187  CB  VAL A  21     -31.129  38.114   2.659  1.00 27.34           C  
ATOM    188  CG1 VAL A  21     -31.703  39.505   2.190  1.00 27.31           C  
ATOM    189  CG2 VAL A  21     -30.006  38.300   3.730  1.00 28.13           C  
ATOM    190  N   PHE A  22     -33.225  36.175   1.215  1.00 24.05           N  
ATOM    191  CA  PHE A  22     -34.238  35.962   0.184  1.00 25.23           C  
ATOM    192  C   PHE A  22     -35.573  35.489   0.817  1.00 25.61           C  
ATOM    193  O   PHE A  22     -36.630  35.910   0.418  1.00 26.09           O  
ATOM    194  CB  PHE A  22     -33.808  34.928  -0.852  1.00 25.45           C  
ATOM    195  CG  PHE A  22     -32.624  35.338  -1.747  1.00 24.62           C  
ATOM    196  CD1 PHE A  22     -32.298  36.659  -2.041  1.00 24.93           C  
ATOM    197  CD2 PHE A  22     -31.930  34.355  -2.386  1.00 25.76           C  
ATOM    198  CE1 PHE A  22     -31.261  36.947  -2.947  1.00 26.16           C  
ATOM    199  CE2 PHE A  22     -30.884  34.646  -3.231  1.00 28.15           C  
ATOM    200  CZ  PHE A  22     -30.571  35.935  -3.530  1.00 25.48           C  
ATOM    201  N   ILE A  23     -35.517  34.577   1.776  0.50 25.44           N  
ATOM    203  CA  ILE A  23     -36.747  34.135   2.434  0.50 25.58           C  
ATOM    205  C   ILE A  23     -37.392  35.298   3.179  0.50 26.17           C  
ATOM    207  O   ILE A  23     -38.583  35.544   3.036  0.50 26.08           O  
ATOM    209  CB  ILE A  23     -36.491  32.922   3.347  0.50 25.70           C  
ATOM    211  CG1 ILE A  23     -36.200  31.699   2.459  0.50 26.42           C  
ATOM    213  CG2 ILE A  23     -37.693  32.637   4.278  0.50 25.91           C  
ATOM    215  CD1 ILE A  23     -35.532  30.581   3.173  0.50 28.32           C  
ATOM    217  N   GLU A  24     -36.588  36.064   3.905  1.00 26.62           N  
ATOM    218  CA  GLU A  24     -37.134  37.178   4.674  1.00 28.32           C  
ATOM    219  C   GLU A  24     -37.799  38.268   3.833  1.00 27.34           C  
ATOM    220  O   GLU A  24     -38.950  38.687   4.136  1.00 27.38           O  
ATOM    221  CB  GLU A  24     -36.017  37.754   5.491  1.00 28.54           C  
ATOM    222  CG  GLU A  24     -35.639  36.804   6.635  1.00 33.43           C  
ATOM    223  CD  GLU A  24     -34.539  37.344   7.558  1.00 36.34           C  
ATOM    224  OE1 GLU A  24     -34.500  38.604   7.819  1.00 40.11           O  
ATOM    225  OE2 GLU A  24     -33.722  36.489   8.020  1.00 44.56           O  
ATOM    226  N   ARG A  25     -37.079  38.691   2.793  1.00 26.11           N  
ATOM    227  CA  ARG A  25     -37.395  39.871   1.976  1.00 27.62           C  
ATOM    228  C   ARG A  25     -38.107  39.535   0.670  1.00 28.04           C  
ATOM    229  O   ARG A  25     -38.715  40.431   0.051  1.00 29.58           O  
ATOM    230  CB  ARG A  25     -36.140  40.615   1.662  1.00 28.04           C  
ATOM    231  CG  ARG A  25     -35.609  41.423   2.816  1.00 30.13           C  
ATOM    232  CD  ARG A  25     -34.433  42.275   2.375  1.00 31.14           C  
ATOM    233  NE  ARG A  25     -33.774  42.836   3.534  1.00 32.13           N  
ATOM    234  CZ  ARG A  25     -34.184  43.940   4.157  1.00 34.71           C  
ATOM    235  NH1 ARG A  25     -35.272  44.606   3.760  1.00 35.00           N  
ATOM    236  NH2 ARG A  25     -33.507  44.375   5.207  1.00 36.96           N  
ATOM    237  N   GLY A  26     -38.070  38.261   0.301  1.00 27.92           N  
ATOM    238  CA  GLY A  26     -38.386  37.835  -1.068  1.00 27.43           C  
ATOM    239  C   GLY A  26     -37.186  38.106  -1.991  1.00 27.40           C  
ATOM    240  O   GLY A  26     -36.442  39.065  -1.807  1.00 27.39           O  
ATOM    241  N   TYR A  27     -37.003  37.276  -3.008  1.00 27.34           N  
ATOM    242  CA  TYR A  27     -35.925  37.511  -3.938  1.00 27.77           C  
ATOM    243  C   TYR A  27     -35.983  38.911  -4.572  1.00 27.93           C  
ATOM    244  O   TYR A  27     -34.979  39.574  -4.640  1.00 28.08           O  
ATOM    245  CB  TYR A  27     -35.885  36.429  -5.016  1.00 27.52           C  
ATOM    246  CG  TYR A  27     -34.894  36.721  -6.077  1.00 26.46           C  
ATOM    247  CD1 TYR A  27     -33.522  36.460  -5.870  1.00 27.67           C  
ATOM    248  CD2 TYR A  27     -35.282  37.215  -7.302  1.00 27.12           C  
ATOM    249  CE1 TYR A  27     -32.561  36.742  -6.860  1.00 25.99           C  
ATOM    250  CE2 TYR A  27     -34.340  37.489  -8.319  1.00 27.44           C  
ATOM    251  CZ  TYR A  27     -32.970  37.267  -8.075  1.00 27.95           C  
ATOM    252  OH  TYR A  27     -32.061  37.562  -9.045  1.00 28.23           O  
ATOM    253  N   ASP A  28     -37.135  39.320  -5.071  1.00 29.87           N  
ATOM    254  CA  ASP A  28     -37.204  40.581  -5.838  1.00 31.43           C  
ATOM    255  C   ASP A  28     -36.820  41.777  -4.974  1.00 32.48           C  
ATOM    256  O   ASP A  28     -36.105  42.711  -5.415  1.00 32.04           O  
ATOM    257  CB  ASP A  28     -38.604  40.826  -6.382  1.00 32.45           C  
ATOM    258  CG  ASP A  28     -38.955  39.894  -7.521  1.00 38.19           C  
ATOM    259  OD1 ASP A  28     -38.035  39.423  -8.204  1.00 40.01           O  
ATOM    260  OD2 ASP A  28     -40.175  39.669  -7.742  1.00 46.71           O  
ATOM    261  N   GLY A  29     -37.291  41.709  -3.734  1.00 32.02           N  
ATOM    262  CA  GLY A  29     -37.108  42.755  -2.760  1.00 32.73           C  
ATOM    263  C   GLY A  29     -35.760  42.773  -2.080  1.00 33.04           C  
ATOM    264  O   GLY A  29     -35.485  43.690  -1.289  1.00 33.32           O  
ATOM    265  N   THR A  30     -34.904  41.796  -2.393  1.00 31.25           N  
ATOM    266  CA  THR A  30     -33.519  41.784  -1.896  1.00 30.26           C  
ATOM    267  C   THR A  30     -32.581  42.543  -2.814  1.00 31.36           C  
ATOM    268  O   THR A  30     -32.543  42.342  -4.042  1.00 31.28           O  
ATOM    269  CB  THR A  30     -33.001  40.320  -1.735  1.00 30.61           C  
ATOM    270  OG1 THR A  30     -33.813  39.641  -0.785  1.00 27.25           O  
ATOM    271  CG2 THR A  30     -31.515  40.283  -1.302  1.00 30.31           C  
ATOM    272  N   SER A  31     -31.810  43.456  -2.207  1.00 31.17           N  
ATOM    273  CA  SER A  31     -30.781  44.181  -2.919  1.00 30.83           C  
ATOM    274  C   SER A  31     -29.378  43.693  -2.570  1.00 29.30           C  
ATOM    275  O   SER A  31     -29.153  42.988  -1.611  1.00 30.09           O  
ATOM    276  CB  SER A  31     -30.898  45.683  -2.615  1.00 31.04           C  
ATOM    277  OG  SER A  31     -30.375  46.002  -1.326  1.00 31.92           O  
HETATM  278  N   MSE A  32     -28.411  44.089  -3.364  1.00 29.99           N  
HETATM  279  CA  MSE A  32     -27.024  43.767  -3.085  1.00 28.97           C  
HETATM  280  C   MSE A  32     -26.601  44.398  -1.777  1.00 29.53           C  
HETATM  281  O   MSE A  32     -25.762  43.822  -1.078  1.00 29.53           O  
HETATM  282  CB  MSE A  32     -26.104  44.229  -4.214  1.00 29.33           C  
HETATM  283  CG  MSE A  32     -26.170  43.397  -5.475  1.00 30.54           C  
HETATM  284 SE   MSE A  32     -26.198  41.466  -5.217  0.70 32.85          SE  
HETATM  285  CE  MSE A  32     -24.666  41.200  -4.431  1.00 37.43           C  
ATOM    286  N   GLU A  33     -27.149  45.574  -1.460  1.00 30.55           N  
ATOM    287  CA  GLU A  33     -26.820  46.195  -0.192  1.00 29.93           C  
ATOM    288  C   GLU A  33     -27.320  45.354   0.957  1.00 29.34           C  
ATOM    289  O   GLU A  33     -26.599  45.218   1.947  1.00 29.12           O  
ATOM    290  CB  GLU A  33     -27.366  47.605  -0.046  1.00 31.12           C  
ATOM    291  CG  GLU A  33     -26.797  48.329   1.189  1.00 35.84           C  
ATOM    292  CD  GLU A  33     -25.239  48.336   1.261  1.00 41.14           C  
ATOM    293  OE1 GLU A  33     -24.554  48.438   0.216  1.00 43.76           O  
ATOM    294  OE2 GLU A  33     -24.697  48.222   2.387  1.00 48.09           O  
ATOM    295  N   HIS A  34     -28.538  44.817   0.850  1.00 28.95           N  
ATOM    296  CA  HIS A  34     -29.003  43.902   1.907  1.00 28.33           C  
ATOM    297  C   HIS A  34     -28.042  42.757   2.096  1.00 28.17           C  
ATOM    298  O   HIS A  34     -27.753  42.370   3.213  1.00 28.16           O  
ATOM    299  CB  HIS A  34     -30.383  43.296   1.627  1.00 28.03           C  
ATOM    300  CG  HIS A  34     -31.474  44.291   1.539  1.00 29.10           C  
ATOM    301  ND1 HIS A  34     -32.421  44.260   0.542  1.00 30.62           N  
ATOM    302  CD2 HIS A  34     -31.744  45.392   2.292  1.00 29.75           C  
ATOM    303  CE1 HIS A  34     -33.259  45.267   0.710  1.00 30.04           C  
ATOM    304  NE2 HIS A  34     -32.865  45.980   1.757  1.00 31.69           N  
ATOM    305  N   LEU A  35     -27.625  42.140   0.977  1.00 28.00           N  
ATOM    306  CA  LEU A  35     -26.760  40.967   1.025  1.00 27.63           C  
ATOM    307  C   LEU A  35     -25.404  41.314   1.619  1.00 28.70           C  
ATOM    308  O   LEU A  35     -24.862  40.540   2.433  1.00 28.07           O  
ATOM    309  CB  LEU A  35     -26.587  40.332  -0.359  1.00 27.58           C  
ATOM    310  CG  LEU A  35     -27.859  39.681  -0.921  1.00 29.53           C  
ATOM    311  CD1 LEU A  35     -27.590  39.188  -2.319  1.00 32.09           C  
ATOM    312  CD2 LEU A  35     -28.328  38.560  -0.050  1.00 29.44           C  
ATOM    313  N   SER A  36     -24.840  42.458   1.207  1.00 29.16           N  
ATOM    314  CA  SER A  36     -23.577  42.918   1.765  1.00 29.71           C  
ATOM    315  C   SER A  36     -23.686  43.161   3.272  1.00 30.75           C  
ATOM    316  O   SER A  36     -22.789  42.764   4.051  1.00 31.35           O  
ATOM    317  CB  SER A  36     -23.128  44.202   1.037  1.00 29.10           C  
ATOM    318  OG  SER A  36     -22.052  44.838   1.707  1.00 32.10           O  
ATOM    319  N   LYS A  37     -24.746  43.850   3.684  1.00 30.72           N  
ATOM    320  CA  LYS A  37     -24.938  44.159   5.113  1.00 30.54           C  
ATOM    321  C   LYS A  37     -25.139  42.867   5.898  1.00 30.98           C  
ATOM    322  O   LYS A  37     -24.599  42.735   6.986  1.00 31.17           O  
ATOM    323  CB  LYS A  37     -26.118  45.106   5.311  1.00 30.87           C  
ATOM    324  N   ALA A  38     -25.898  41.921   5.336  1.00 31.54           N  
ATOM    325  CA  ALA A  38     -26.111  40.609   5.966  1.00 31.59           C  
ATOM    326  C   ALA A  38     -24.854  39.706   6.052  1.00 31.84           C  
ATOM    327  O   ALA A  38     -24.633  39.034   7.088  1.00 32.63           O  
ATOM    328  CB  ALA A  38     -27.272  39.872   5.310  1.00 31.22           C  
ATOM    329  N   ALA A  39     -24.046  39.659   4.975  1.00 32.31           N  
ATOM    330  CA  ALA A  39     -22.855  38.804   4.966  1.00 32.26           C  
ATOM    331  C   ALA A  39     -21.693  39.520   5.674  1.00 32.44           C  
ATOM    332  O   ALA A  39     -20.709  38.886   6.008  1.00 33.41           O  
ATOM    333  CB  ALA A  39     -22.432  38.469   3.530  1.00 33.07           C  
ATOM    334  N   GLY A  40     -21.787  40.836   5.861  1.00 32.25           N  
ATOM    335  CA  GLY A  40     -20.720  41.592   6.512  1.00 32.00           C  
ATOM    336  C   GLY A  40     -19.473  41.836   5.678  1.00 32.42           C  
ATOM    337  O   GLY A  40     -18.400  42.072   6.218  1.00 32.41           O  
ATOM    338  N   ILE A  41     -19.622  41.785   4.358  1.00 32.91           N  
ATOM    339  CA  ILE A  41     -18.533  42.049   3.419  1.00 33.45           C  
ATOM    340  C   ILE A  41     -18.990  43.006   2.355  1.00 32.50           C  
ATOM    341  O   ILE A  41     -20.207  43.177   2.120  1.00 32.56           O  
ATOM    342  CB  ILE A  41     -18.033  40.755   2.775  1.00 33.19           C  
ATOM    343  CG1 ILE A  41     -19.128  40.015   2.002  1.00 33.79           C  
ATOM    344  CG2 ILE A  41     -17.507  39.849   3.862  1.00 35.07           C  
ATOM    345  CD1 ILE A  41     -18.601  38.869   1.164  1.00 34.87           C  
ATOM    346  N   SER A  42     -18.019  43.579   1.652  1.00 30.20           N  
ATOM    347  CA  SER A  42     -18.333  44.634   0.701  1.00 30.80           C  
ATOM    348  C   SER A  42     -18.937  44.113  -0.597  1.00 29.69           C  
ATOM    349  O   SER A  42     -18.763  42.954  -0.954  1.00 29.15           O  
ATOM    350  CB  SER A  42     -17.080  45.415   0.362  1.00 29.61           C  
ATOM    351  OG  SER A  42     -16.090  44.591  -0.276  1.00 31.39           O  
ATOM    352  N   LYS A  43     -19.651  44.987  -1.295  1.00 30.61           N  
ATOM    353  CA  LYS A  43     -20.153  44.655  -2.625  1.00 32.64           C  
ATOM    354  C   LYS A  43     -19.018  44.207  -3.550  1.00 31.48           C  
ATOM    355  O   LYS A  43     -19.171  43.226  -4.287  1.00 31.02           O  
ATOM    356  CB  LYS A  43     -20.933  45.823  -3.231  1.00 33.46           C  
ATOM    357  CG  LYS A  43     -22.295  46.017  -2.581  1.00 32.99           C  
ATOM    358  CD  LYS A  43     -22.854  47.430  -2.688  1.00 37.73           C  
ATOM    359  CE  LYS A  43     -23.752  47.584  -3.920  1.00 43.37           C  
ATOM    360  NZ  LYS A  43     -25.141  48.109  -3.579  1.00 45.79           N  
ATOM    361  N   SER A  44     -17.879  44.893  -3.494  1.00 30.83           N  
ATOM    362  CA  SER A  44     -16.705  44.468  -4.253  1.00 30.97           C  
ATOM    363  C   SER A  44     -16.270  43.059  -3.903  1.00 29.72           C  
ATOM    364  O   SER A  44     -16.051  42.223  -4.812  1.00 29.74           O  
ATOM    365  CB  SER A  44     -15.509  45.433  -4.067  1.00 31.28           C  
ATOM    366  OG  SER A  44     -14.310  44.900  -4.654  1.00 36.38           O  
ATOM    367  N   SER A  45     -16.190  42.783  -2.608  1.00 28.35           N  
ATOM    368  CA  SER A  45     -15.773  41.469  -2.110  1.00 29.57           C  
ATOM    369  C   SER A  45     -16.677  40.309  -2.592  1.00 28.24           C  
ATOM    370  O   SER A  45     -16.220  39.163  -2.789  1.00 25.27           O  
ATOM    371  CB  SER A  45     -15.732  41.491  -0.599  1.00 30.92           C  
ATOM    372  OG  SER A  45     -15.332  40.245  -0.090  1.00 38.07           O  
ATOM    373  N   ILE A  46     -17.971  40.595  -2.779  1.00 27.20           N  
ATOM    374  CA  ILE A  46     -18.912  39.556  -3.230  1.00 27.34           C  
ATOM    375  C   ILE A  46     -18.569  39.047  -4.638  1.00 25.18           C  
ATOM    376  O   ILE A  46     -18.865  37.905  -4.970  1.00 26.42           O  
ATOM    377  CB  ILE A  46     -20.358  40.096  -3.124  1.00 27.38           C  
ATOM    378  CG1 ILE A  46     -20.728  40.186  -1.629  1.00 29.59           C  
ATOM    379  CG2 ILE A  46     -21.367  39.265  -3.910  1.00 29.30           C  
ATOM    380  CD1 ILE A  46     -22.030  40.902  -1.270  1.00 30.89           C  
ATOM    381  N   TYR A  47     -17.906  39.872  -5.443  1.00 24.72           N  
ATOM    382  CA  TYR A  47     -17.460  39.444  -6.809  1.00 24.92           C  
ATOM    383  C   TYR A  47     -16.374  38.362  -6.804  1.00 25.07           C  
ATOM    384  O   TYR A  47     -16.122  37.746  -7.843  1.00 25.22           O  
ATOM    385  CB  TYR A  47     -16.940  40.633  -7.658  1.00 26.11           C  
ATOM    386  CG  TYR A  47     -18.079  41.377  -8.348  1.00 25.48           C  
ATOM    387  CD1 TYR A  47     -18.611  42.535  -7.767  1.00 25.61           C  
ATOM    388  CD2 TYR A  47     -18.623  40.913  -9.521  1.00 24.36           C  
ATOM    389  CE1 TYR A  47     -19.674  43.199  -8.379  1.00 25.64           C  
ATOM    390  CE2 TYR A  47     -19.698  41.565 -10.132  1.00 24.44           C  
ATOM    391  CZ  TYR A  47     -20.222  42.698  -9.542  1.00 26.97           C  
ATOM    392  OH  TYR A  47     -21.298  43.299 -10.153  1.00 28.09           O  
ATOM    393  N   HIS A  48     -15.743  38.107  -5.652  1.00 24.18           N  
ATOM    394  CA  HIS A  48     -14.908  36.933  -5.555  1.00 23.96           C  
ATOM    395  C   HIS A  48     -15.764  35.656  -5.630  1.00 25.99           C  
ATOM    396  O   HIS A  48     -15.202  34.562  -5.764  1.00 26.97           O  
ATOM    397  CB  HIS A  48     -14.123  36.966  -4.257  1.00 24.86           C  
ATOM    398  CG  HIS A  48     -13.097  38.026  -4.226  1.00 23.76           C  
ATOM    399  ND1 HIS A  48     -11.891  37.899  -4.876  1.00 22.97           N  
ATOM    400  CD2 HIS A  48     -13.027  39.203  -3.552  1.00 28.89           C  
ATOM    401  CE1 HIS A  48     -11.152  38.965  -4.656  1.00 21.97           C  
ATOM    402  NE2 HIS A  48     -11.811  39.771  -3.846  1.00 27.10           N  
ATOM    403  N   HIS A  49     -17.085  35.803  -5.454  1.00 24.75           N  
ATOM    404  CA  HIS A  49     -18.004  34.654  -5.309  1.00 25.28           C  
ATOM    405  C   HIS A  49     -19.042  34.519  -6.394  1.00 25.23           C  
ATOM    406  O   HIS A  49     -19.276  33.416  -6.883  1.00 26.18           O  
ATOM    407  CB  HIS A  49     -18.653  34.743  -3.943  1.00 25.90           C  
ATOM    408  CG  HIS A  49     -17.642  34.827  -2.854  1.00 29.82           C  
ATOM    409  ND1 HIS A  49     -16.887  33.742  -2.467  1.00 35.45           N  
ATOM    410  CD2 HIS A  49     -17.161  35.888  -2.168  1.00 28.97           C  
ATOM    411  CE1 HIS A  49     -16.009  34.123  -1.562  1.00 33.32           C  
ATOM    412  NE2 HIS A  49     -16.158  35.422  -1.349  1.00 33.25           N  
ATOM    413  N   VAL A  50     -19.726  35.623  -6.734  1.00 23.22           N  
ATOM    414  CA  VAL A  50     -20.827  35.639  -7.651  1.00 23.69           C  
ATOM    415  C   VAL A  50     -20.890  36.991  -8.377  1.00 23.93           C  
ATOM    416  O   VAL A  50     -20.398  38.013  -7.864  1.00 24.32           O  
ATOM    417  CB  VAL A  50     -22.202  35.445  -6.923  1.00 23.36           C  
ATOM    418  CG1 VAL A  50     -22.278  34.032  -6.291  1.00 25.72           C  
ATOM    419  CG2 VAL A  50     -22.434  36.525  -5.846  1.00 23.81           C  
ATOM    420  N   THR A  51     -21.625  36.986  -9.492  1.00 24.17           N  
ATOM    421  CA  THR A  51     -21.915  38.242 -10.186  1.00 23.73           C  
ATOM    422  C   THR A  51     -23.028  39.091  -9.547  1.00 25.21           C  
ATOM    423  O   THR A  51     -23.140  40.302  -9.823  1.00 27.02           O  
ATOM    424  CB  THR A  51     -22.306  38.056 -11.654  1.00 25.87           C  
ATOM    425  OG1 THR A  51     -23.465  37.229 -11.683  1.00 27.90           O  
ATOM    426  CG2 THR A  51     -21.154  37.527 -12.495  1.00 26.30           C  
ATOM    427  N   GLY A  52     -23.875  38.469  -8.718  1.00 25.57           N  
ATOM    428  CA  GLY A  52     -24.986  39.181  -8.145  1.00 24.96           C  
ATOM    429  C   GLY A  52     -25.997  38.203  -7.572  1.00 25.16           C  
ATOM    430  O   GLY A  52     -25.695  37.003  -7.418  1.00 25.79           O  
ATOM    431  N   LYS A  53     -27.179  38.716  -7.258  1.00 24.24           N  
ATOM    432  CA  LYS A  53     -28.141  37.881  -6.543  1.00 24.86           C  
ATOM    433  C   LYS A  53     -28.740  36.809  -7.408  1.00 24.93           C  
ATOM    434  O   LYS A  53     -29.167  35.811  -6.864  1.00 25.63           O  
ATOM    435  CB  LYS A  53     -29.234  38.719  -5.878  1.00 25.82           C  
ATOM    436  CG  LYS A  53     -30.118  39.454  -6.819  1.00 26.86           C  
ATOM    437  CD  LYS A  53     -31.371  40.086  -6.094  1.00 27.54           C  
ATOM    438  CE  LYS A  53     -32.322  40.716  -7.078  1.00 28.60           C  
ATOM    439  NZ  LYS A  53     -33.470  41.334  -6.360  1.00 26.91           N  
ATOM    440  N   GLU A  54     -28.831  37.004  -8.718  1.00 25.65           N  
ATOM    441  CA  GLU A  54     -29.467  35.969  -9.551  1.00 25.41           C  
ATOM    442  C   GLU A  54     -28.639  34.686  -9.450  1.00 25.70           C  
ATOM    443  O   GLU A  54     -29.173  33.595  -9.392  1.00 24.66           O  
ATOM    444  CB  GLU A  54     -29.626  36.399 -10.993  1.00 25.95           C  
ATOM    445  CG  GLU A  54     -30.538  35.428 -11.748  1.00 25.80           C  
ATOM    446  CD  GLU A  54     -30.645  35.672 -13.241  1.00 29.45           C  
ATOM    447  OE1 GLU A  54     -30.560  36.859 -13.717  1.00 28.77           O  
ATOM    448  OE2 GLU A  54     -30.867  34.665 -13.983  1.00 26.86           O  
ATOM    449  N   GLU A  55     -27.316  34.818  -9.513  1.00 26.43           N  
ATOM    450  CA  GLU A  55     -26.462  33.652  -9.398  1.00 27.18           C  
ATOM    451  C   GLU A  55     -26.622  32.929  -8.053  1.00 25.09           C  
ATOM    452  O   GLU A  55     -26.632  31.698  -7.990  1.00 26.59           O  
ATOM    453  CB  GLU A  55     -25.004  34.077  -9.729  1.00 26.68           C  
ATOM    454  CG  GLU A  55     -24.002  33.009  -9.545  1.00 26.81           C  
ATOM    455  CD  GLU A  55     -24.125  31.735 -10.396  1.00 29.04           C  
ATOM    456  OE1 GLU A  55     -24.819  31.741 -11.398  1.00 30.32           O  
ATOM    457  OE2 GLU A  55     -23.395  30.774 -10.028  1.00 32.41           O  
ATOM    458  N   LEU A  56     -26.749  33.685  -6.962  1.00 26.33           N  
ATOM    459  CA  LEU A  56     -27.045  33.076  -5.671  1.00 26.19           C  
ATOM    460  C   LEU A  56     -28.408  32.365  -5.660  1.00 26.91           C  
ATOM    461  O   LEU A  56     -28.526  31.222  -5.202  1.00 26.58           O  
ATOM    462  CB  LEU A  56     -26.996  34.131  -4.606  1.00 25.92           C  
ATOM    463  CG  LEU A  56     -25.605  34.708  -4.296  1.00 27.18           C  
ATOM    464  CD1 LEU A  56     -25.688  36.026  -3.534  1.00 27.15           C  
ATOM    465  CD2 LEU A  56     -24.823  33.714  -3.541  1.00 27.82           C  
ATOM    466  N   LEU A  57     -29.413  32.967  -6.271  1.00 25.89           N  
ATOM    467  CA  LEU A  57     -30.710  32.279  -6.391  1.00 25.68           C  
ATOM    468  C   LEU A  57     -30.565  30.987  -7.187  1.00 25.09           C  
ATOM    469  O   LEU A  57     -31.125  29.939  -6.840  1.00 25.26           O  
ATOM    470  CB  LEU A  57     -31.733  33.207  -7.059  1.00 25.53           C  
ATOM    471  CG  LEU A  57     -33.128  32.579  -7.241  1.00 26.18           C  
ATOM    472  CD1 LEU A  57     -33.795  32.326  -5.939  1.00 29.55           C  
ATOM    473  CD2 LEU A  57     -33.975  33.454  -8.161  1.00 26.87           C  
ATOM    474  N   ARG A  58     -29.870  31.080  -8.303  1.00 25.57           N  
ATOM    475  CA  ARG A  58     -29.621  29.895  -9.120  1.00 25.04           C  
ATOM    476  C   ARG A  58     -29.020  28.769  -8.329  1.00 25.36           C  
ATOM    477  O   ARG A  58     -29.440  27.621  -8.422  1.00 25.25           O  
ATOM    478  CB  ARG A  58     -28.765  30.209 -10.306  1.00 25.51           C  
ATOM    479  CG  ARG A  58     -28.662  29.052 -11.328  1.00 26.82           C  
ATOM    480  CD  ARG A  58     -27.529  29.217 -12.360  1.00 26.82           C  
ATOM    481  NE  ARG A  58     -26.241  29.217 -11.658  1.00 27.85           N  
ATOM    482  CZ  ARG A  58     -25.705  28.142 -11.104  1.00 28.89           C  
ATOM    483  NH1 ARG A  58     -26.246  26.935 -11.332  1.00 29.19           N  
ATOM    484  NH2 ARG A  58     -24.589  28.223 -10.370  1.00 31.16           N  
ATOM    485  N   ARG A  59     -27.959  29.088  -7.575  1.00 25.31           N  
ATOM    486  CA  ARG A  59     -27.349  28.071  -6.727  1.00 26.78           C  
ATOM    487  C   ARG A  59     -28.331  27.431  -5.739  1.00 26.37           C  
ATOM    488  O   ARG A  59     -28.348  26.205  -5.517  1.00 27.86           O  
ATOM    489  CB  ARG A  59     -26.080  28.629  -6.039  1.00 26.92           C  
ATOM    490  CG  ARG A  59     -24.967  29.021  -6.981  1.00 27.04           C  
ATOM    491  CD  ARG A  59     -23.742  29.740  -6.265  1.00 27.54           C  
ATOM    492  NE  ARG A  59     -22.829  30.295  -7.292  1.00 30.58           N  
ATOM    493  CZ  ARG A  59     -21.570  30.697  -7.088  1.00 31.12           C  
ATOM    494  NH1 ARG A  59     -21.042  30.645  -5.859  1.00 31.99           N  
ATOM    495  NH2 ARG A  59     -20.843  31.185  -8.095  1.00 31.59           N  
ATOM    496  N   ALA A  60     -29.182  28.272  -5.154  1.00 26.09           N  
ATOM    497  CA  ALA A  60     -30.185  27.830  -4.201  1.00 26.22           C  
ATOM    498  C   ALA A  60     -31.228  26.934  -4.818  1.00 26.52           C  
ATOM    499  O   ALA A  60     -31.465  25.810  -4.350  1.00 27.29           O  
ATOM    500  CB  ALA A  60     -30.833  29.018  -3.507  1.00 27.00           C  
ATOM    501  N   VAL A  61     -31.816  27.368  -5.933  1.00 25.32           N  
ATOM    502  CA  VAL A  61     -32.900  26.559  -6.540  1.00 25.55           C  
ATOM    503  C   VAL A  61     -32.332  25.312  -7.209  1.00 24.58           C  
ATOM    504  O   VAL A  61     -32.985  24.288  -7.218  1.00 25.57           O  
ATOM    505  CB  VAL A  61     -33.841  27.383  -7.433  1.00 25.80           C  
ATOM    506  CG1 VAL A  61     -34.466  28.532  -6.630  1.00 26.53           C  
ATOM    507  CG2 VAL A  61     -33.122  27.893  -8.631  1.00 27.18           C  
ATOM    508  N   SER A  62     -31.110  25.374  -7.739  1.00 23.18           N  
ATOM    509  CA  SER A  62     -30.417  24.207  -8.271  1.00 23.53           C  
ATOM    510  C   SER A  62     -30.240  23.149  -7.161  1.00 22.57           C  
ATOM    511  O   SER A  62     -30.469  21.957  -7.424  1.00 23.26           O  
ATOM    512  CB  SER A  62     -29.112  24.599  -8.961  1.00 24.02           C  
ATOM    513  OG  SER A  62     -28.287  23.483  -9.308  1.00 29.65           O  
ATOM    514  N   ARG A  63     -29.899  23.547  -5.942  0.50 22.19           N  
ATOM    516  CA  ARG A  63     -29.737  22.576  -4.884  0.50 22.55           C  
ATOM    518  C   ARG A  63     -31.066  21.867  -4.577  0.50 22.34           C  
ATOM    520  O   ARG A  63     -31.104  20.675  -4.380  0.50 23.38           O  
ATOM    522  CB  ARG A  63     -29.221  23.256  -3.630  0.50 22.77           C  
ATOM    524  CG  ARG A  63     -28.982  22.332  -2.491  0.50 21.41           C  
ATOM    526  CD  ARG A  63     -28.554  23.098  -1.242  0.50 23.65           C  
ATOM    528  NE  ARG A  63     -28.561  22.200  -0.107  0.50 24.28           N  
ATOM    530  CZ  ARG A  63     -27.649  21.241   0.069  0.50 29.77           C  
ATOM    532  NH1 ARG A  63     -26.638  21.086  -0.798  0.50 34.29           N  
ATOM    534  NH2 ARG A  63     -27.723  20.433   1.115  0.50 33.14           N  
ATOM    536  N   ALA A  64     -32.163  22.624  -4.532  1.00 22.12           N  
ATOM    537  CA  ALA A  64     -33.514  22.093  -4.266  1.00 21.05           C  
ATOM    538  C   ALA A  64     -33.908  21.147  -5.414  1.00 22.24           C  
ATOM    539  O   ALA A  64     -34.384  20.045  -5.166  1.00 21.92           O  
ATOM    540  CB  ALA A  64     -34.511  23.239  -4.141  1.00 22.39           C  
ATOM    541  N   LEU A  65     -33.695  21.584  -6.649  1.00 21.26           N  
ATOM    542  CA  LEU A  65     -34.135  20.790  -7.817  1.00 22.01           C  
ATOM    543  C   LEU A  65     -33.307  19.515  -7.876  1.00 21.98           C  
ATOM    544  O   LEU A  65     -33.840  18.443  -8.213  1.00 22.19           O  
ATOM    545  CB  LEU A  65     -34.034  21.611  -9.072  1.00 22.22           C  
ATOM    546  CG  LEU A  65     -35.090  22.680  -9.202  1.00 21.82           C  
ATOM    547  CD1 LEU A  65     -34.664  23.733 -10.237  1.00 23.52           C  
ATOM    548  CD2 LEU A  65     -36.450  22.077  -9.579  1.00 21.79           C  
ATOM    549  N   ASP A  66     -32.014  19.595  -7.600  1.00 22.69           N  
ATOM    550  CA  ASP A  66     -31.176  18.392  -7.655  1.00 23.18           C  
ATOM    551  C   ASP A  66     -31.651  17.350  -6.668  1.00 22.81           C  
ATOM    552  O   ASP A  66     -31.662  16.135  -6.984  1.00 23.05           O  
ATOM    553  CB  ASP A  66     -29.730  18.734  -7.439  1.00 23.58           C  
ATOM    554  CG  ASP A  66     -29.075  19.386  -8.653  1.00 26.72           C  
ATOM    555  OD1 ASP A  66     -29.682  19.457  -9.744  1.00 28.17           O  
ATOM    556  OD2 ASP A  66     -27.887  19.776  -8.431  1.00 30.34           O  
ATOM    557  N   GLU A  67     -32.067  17.791  -5.480  1.00 21.73           N  
ATOM    558  CA  GLU A  67     -32.549  16.852  -4.473  1.00 23.19           C  
ATOM    559  C   GLU A  67     -33.874  16.244  -4.869  1.00 23.11           C  
ATOM    560  O   GLU A  67     -34.078  15.032  -4.689  1.00 23.96           O  
ATOM    561  CB  GLU A  67     -32.611  17.531  -3.114  1.00 24.85           C  
ATOM    562  CG  GLU A  67     -31.266  17.824  -2.524  1.00 26.42           C  
ATOM    563  CD  GLU A  67     -30.402  16.578  -2.316  1.00 35.15           C  
ATOM    564  OE1 GLU A  67     -30.909  15.586  -1.761  1.00 31.51           O  
ATOM    565  OE2 GLU A  67     -29.237  16.650  -2.722  1.00 40.95           O  
ATOM    566  N   LEU A  68     -34.785  17.024  -5.443  1.00 23.08           N  
ATOM    567  CA  LEU A  68     -36.066  16.491  -5.848  1.00 23.01           C  
ATOM    568  C   LEU A  68     -35.933  15.539  -7.043  1.00 23.35           C  
ATOM    569  O   LEU A  68     -36.430  14.399  -7.010  1.00 23.39           O  
ATOM    570  CB  LEU A  68     -37.000  17.669  -6.200  1.00 22.94           C  
ATOM    571  CG  LEU A  68     -37.523  18.440  -5.011  1.00 23.86           C  
ATOM    572  CD1 LEU A  68     -38.147  19.763  -5.436  1.00 27.53           C  
ATOM    573  CD2 LEU A  68     -38.526  17.583  -4.182  1.00 23.61           C  
ATOM    574  N   PHE A  69     -35.275  15.959  -8.121  1.00 21.44           N  
ATOM    575  CA  PHE A  69     -35.010  15.053  -9.252  1.00 22.00           C  
ATOM    576  C   PHE A  69     -34.270  13.847  -8.836  1.00 22.22           C  
ATOM    577  O   PHE A  69     -34.513  12.783  -9.396  1.00 22.20           O  
ATOM    578  CB  PHE A  69     -34.317  15.778 -10.372  1.00 21.96           C  
ATOM    579  CG  PHE A  69     -35.265  16.514 -11.287  1.00 21.21           C  
ATOM    580  CD1 PHE A  69     -35.908  15.864 -12.324  1.00 23.43           C  
ATOM    581  CD2 PHE A  69     -35.566  17.860 -11.087  1.00 23.10           C  
ATOM    582  CE1 PHE A  69     -36.757  16.503 -13.185  1.00 25.08           C  
ATOM    583  CE2 PHE A  69     -36.485  18.503 -11.921  1.00 22.71           C  
ATOM    584  CZ  PHE A  69     -37.062  17.816 -12.997  1.00 23.93           C  
ATOM    585  N   GLY A  70     -33.348  13.996  -7.875  1.00 20.29           N  
ATOM    586  CA  GLY A  70     -32.564  12.844  -7.419  1.00 21.16           C  
ATOM    587  C   GLY A  70     -33.472  11.729  -6.966  1.00 20.86           C  
ATOM    588  O   GLY A  70     -33.170  10.501  -7.150  1.00 21.59           O  
ATOM    589  N   ILE A  71     -34.565  12.084  -6.301  1.00 21.50           N  
ATOM    590  CA  ILE A  71     -35.504  11.052  -5.819  1.00 20.90           C  
ATOM    591  C   ILE A  71     -35.957  10.088  -6.949  1.00 20.54           C  
ATOM    592  O   ILE A  71     -36.002   8.862  -6.757  1.00 20.90           O  
ATOM    593  CB  ILE A  71     -36.780  11.679  -5.259  1.00 20.66           C  
ATOM    594  CG1 ILE A  71     -36.452  12.558  -4.082  1.00 21.02           C  
ATOM    595  CG2 ILE A  71     -37.776  10.591  -4.879  1.00 21.15           C  
ATOM    596  CD1 ILE A  71     -37.639  13.431  -3.670  1.00 22.63           C  
ATOM    597  N   LEU A  72     -36.217  10.621  -8.138  1.00 21.05           N  
ATOM    598  CA  LEU A  72     -36.862   9.876  -9.164  1.00 22.02           C  
ATOM    599  C   LEU A  72     -36.029   8.739  -9.742  1.00 21.24           C  
ATOM    600  O   LEU A  72     -36.610   7.859 -10.403  1.00 22.23           O  
ATOM    601  CB  LEU A  72     -37.306  10.836 -10.253  1.00 22.50           C  
ATOM    602  CG  LEU A  72     -38.276  11.962  -9.831  1.00 22.85           C  
ATOM    603  CD1 LEU A  72     -38.673  12.759 -11.061  1.00 24.39           C  
ATOM    604  CD2 LEU A  72     -39.464  11.421  -9.110  1.00 24.00           C  
ATOM    605  N   ASP A  73     -34.708   8.826  -9.616  1.00 20.74           N  
ATOM    606  CA  ASP A  73     -33.837   7.746 -10.035  1.00 21.65           C  
ATOM    607  C   ASP A  73     -33.212   6.922  -8.934  1.00 19.89           C  
ATOM    608  O   ASP A  73     -32.483   5.975  -9.214  1.00 20.42           O  
ATOM    609  CB  ASP A  73     -32.777   8.278 -10.975  1.00 21.30           C  
ATOM    610  CG  ASP A  73     -33.402   8.667 -12.320  1.00 27.80           C  
ATOM    611  OD1 ASP A  73     -34.149   7.837 -12.933  1.00 27.14           O  
ATOM    612  OD2 ASP A  73     -33.178   9.858 -12.717  1.00 32.73           O  
ATOM    613  N   GLU A  74     -33.678   7.123  -7.731  1.00 20.22           N  
ATOM    614  CA  GLU A  74     -33.296   6.228  -6.651  1.00 19.71           C  
ATOM    615  C   GLU A  74     -33.941   4.846  -6.908  1.00 19.44           C  
ATOM    616  O   GLU A  74     -35.050   4.763  -7.448  1.00 19.63           O  
ATOM    617  CB  GLU A  74     -33.775   6.802  -5.303  1.00 19.56           C  
ATOM    618  CG  GLU A  74     -32.947   8.015  -4.892  1.00 19.89           C  
ATOM    619  CD  GLU A  74     -33.451   8.724  -3.672  1.00 20.56           C  
ATOM    620  OE1 GLU A  74     -34.389   8.252  -3.056  1.00 21.19           O  
ATOM    621  OE2 GLU A  74     -32.900   9.809  -3.397  1.00 22.48           O  
ATOM    622  N   GLU A  75     -33.264   3.779  -6.479  1.00 19.32           N  
ATOM    623  CA  GLU A  75     -33.703   2.422  -6.763  1.00 20.05           C  
ATOM    624  C   GLU A  75     -35.209   2.237  -6.571  1.00 19.63           C  
ATOM    625  O   GLU A  75     -35.898   1.782  -7.454  1.00 19.88           O  
ATOM    626  CB  GLU A  75     -32.925   1.444  -5.900  1.00 20.18           C  
ATOM    627  CG  GLU A  75     -33.252  -0.012  -6.187  1.00 20.89           C  
ATOM    628  CD  GLU A  75     -32.482  -0.995  -5.334  1.00 25.78           C  
ATOM    629  OE1 GLU A  75     -31.355  -0.744  -4.988  1.00 25.75           O  
ATOM    630  OE2 GLU A  75     -33.087  -1.999  -4.947  1.00 31.18           O  
ATOM    631  N   HIS A  76     -35.702   2.575  -5.406  1.00 19.57           N  
ATOM    632  CA  HIS A  76     -37.110   2.250  -5.074  1.00 20.11           C  
ATOM    633  C   HIS A  76     -38.141   3.170  -5.739  1.00 20.25           C  
ATOM    634  O   HIS A  76     -39.359   2.897  -5.646  1.00 21.95           O  
ATOM    635  CB  HIS A  76     -37.240   2.202  -3.564  1.00 21.03           C  
ATOM    636  CG  HIS A  76     -36.496   1.047  -3.015  1.00 24.55           C  
ATOM    637  ND1 HIS A  76     -35.286   1.180  -2.368  1.00 28.34           N  
ATOM    638  CD2 HIS A  76     -36.694  -0.273  -3.199  1.00 27.27           C  
ATOM    639  CE1 HIS A  76     -34.835  -0.027  -2.054  1.00 30.07           C  
ATOM    640  NE2 HIS A  76     -35.642  -0.932  -2.592  1.00 32.44           N  
ATOM    641  N   ALA A  77     -37.680   4.206  -6.436  1.00 20.91           N  
ATOM    642  CA  ALA A  77     -38.507   4.987  -7.342  1.00 20.97           C  
ATOM    643  C   ALA A  77     -38.576   4.378  -8.733  1.00 21.38           C  
ATOM    644  O   ALA A  77     -39.325   4.864  -9.580  1.00 21.65           O  
ATOM    645  CB  ALA A  77     -38.006   6.429  -7.435  1.00 20.44           C  
ATOM    646  N   ARG A  78     -37.767   3.352  -8.996  1.00 20.41           N  
ATOM    647  CA  ARG A  78     -37.520   2.826 -10.327  1.00 20.20           C  
ATOM    648  C   ARG A  78     -37.800   1.308 -10.470  1.00 20.77           C  
ATOM    649  O   ARG A  78     -37.692   0.798 -11.570  1.00 24.94           O  
ATOM    650  CB  ARG A  78     -36.051   3.054 -10.677  1.00 20.39           C  
ATOM    651  CG  ARG A  78     -35.692   4.491 -10.845  1.00 20.22           C  
ATOM    652  CD  ARG A  78     -36.198   5.088 -12.147  1.00 21.55           C  
ATOM    653  NE  ARG A  78     -35.855   4.227 -13.268  1.00 22.22           N  
ATOM    654  CZ  ARG A  78     -34.633   4.168 -13.827  1.00 20.95           C  
ATOM    655  NH1 ARG A  78     -33.693   5.015 -13.456  1.00 23.11           N  
ATOM    656  NH2 ARG A  78     -34.398   3.269 -14.732  1.00 22.53           N  
ATOM    657  N   VAL A  79     -38.071   0.619  -9.361  1.00 21.68           N  
ATOM    658  CA  VAL A  79     -38.373  -0.813  -9.357  1.00 20.85           C  
ATOM    659  C   VAL A  79     -39.651  -1.062  -8.583  1.00 22.98           C  
ATOM    660  O   VAL A  79     -40.086  -0.192  -7.813  1.00 23.66           O  
ATOM    661  CB  VAL A  79     -37.207  -1.622  -8.721  1.00 21.69           C  
ATOM    662  CG1 VAL A  79     -35.886  -1.310  -9.399  1.00 22.88           C  
ATOM    663  CG2 VAL A  79     -37.137  -1.370  -7.234  1.00 21.61           C  
ATOM    664  N   GLY A  80     -40.220  -2.250  -8.765  1.00 22.25           N  
ATOM    665  CA  GLY A  80     -41.490  -2.604  -8.122  1.00 23.46           C  
ATOM    666  C   GLY A  80     -42.651  -2.080  -8.926  1.00 23.30           C  
ATOM    667  O   GLY A  80     -42.502  -1.640 -10.066  1.00 25.33           O  
ATOM    668  N   THR A  81     -43.839  -2.195  -8.362  1.00 23.04           N  
ATOM    669  CA  THR A  81     -45.021  -1.705  -9.017  1.00 22.86           C  
ATOM    670  C   THR A  81     -45.028  -0.179  -9.080  1.00 23.03           C  
ATOM    671  O   THR A  81     -44.315   0.481  -8.307  1.00 22.20           O  
ATOM    672  CB  THR A  81     -46.283  -2.234  -8.257  1.00 25.06           C  
ATOM    673  OG1 THR A  81     -46.382  -1.550  -6.989  1.00 24.85           O  
ATOM    674  CG2 THR A  81     -46.246  -3.754  -8.099  1.00 26.34           C  
ATOM    675  N   ALA A  82     -45.846   0.396  -9.979  1.00 23.78           N  
ATOM    676  CA  ALA A  82     -45.940   1.815 -10.101  1.00 24.98           C  
ATOM    677  C   ALA A  82     -46.411   2.425  -8.774  1.00 23.60           C  
ATOM    678  O   ALA A  82     -45.946   3.463  -8.369  1.00 23.69           O  
ATOM    679  CB  ALA A  82     -46.928   2.182 -11.247  1.00 26.64           C  
ATOM    680  N   ALA A  83     -47.304   1.732  -8.077  1.00 24.97           N  
ATOM    681  CA  ALA A  83     -47.822   2.309  -6.813  1.00 23.89           C  
ATOM    682  C   ALA A  83     -46.766   2.247  -5.714  1.00 23.22           C  
ATOM    683  O   ALA A  83     -46.700   3.121  -4.872  1.00 21.95           O  
ATOM    684  CB  ALA A  83     -49.048   1.531  -6.359  1.00 24.83           C  
ATOM    685  N   GLU A  84     -45.909   1.205  -5.749  1.00 22.37           N  
ATOM    686  CA  GLU A  84     -44.754   1.151  -4.822  1.00 22.58           C  
ATOM    687  C   GLU A  84     -43.797   2.305  -5.102  1.00 21.72           C  
ATOM    688  O   GLU A  84     -43.311   2.982  -4.182  1.00 20.81           O  
ATOM    689  CB  GLU A  84     -43.999  -0.193  -4.930  1.00 23.20           C  
ATOM    690  CG  GLU A  84     -44.756  -1.313  -4.264  1.00 24.24           C  
ATOM    691  CD  GLU A  84     -44.304  -2.699  -4.626  1.00 25.61           C  
ATOM    692  OE1 GLU A  84     -43.519  -2.906  -5.546  1.00 22.79           O  
ATOM    693  OE2 GLU A  84     -44.764  -3.628  -3.919  1.00 29.11           O  
ATOM    694  N   ARG A  85     -43.514   2.549  -6.380  1.00 21.33           N  
ATOM    695  CA  ARG A  85     -42.596   3.636  -6.744  0.50 20.72           C  
ATOM    697  C   ARG A  85     -43.205   4.956  -6.338  1.00 21.51           C  
ATOM    698  O   ARG A  85     -42.506   5.833  -5.824  1.00 21.60           O  
ATOM    699  CB  ARG A  85     -42.329   3.634  -8.240  0.50 20.12           C  
ATOM    701  CG  ARG A  85     -41.611   2.416  -8.731  0.50 21.06           C  
ATOM    703  CD  ARG A  85     -41.511   2.371 -10.251  0.50 19.86           C  
ATOM    705  NE  ARG A  85     -41.376   0.978 -10.694  0.50 17.25           N  
ATOM    707  CZ  ARG A  85     -40.966   0.590 -11.912  0.50 17.33           C  
ATOM    709  NH1 ARG A  85     -40.602   1.512 -12.811  0.50 20.07           N  
ATOM    711  NH2 ARG A  85     -40.864  -0.720 -12.209  0.50 19.42           N  
ATOM    713  N   LEU A  86     -44.510   5.121  -6.584  1.00 21.27           N  
ATOM    714  CA  LEU A  86     -45.170   6.404  -6.230  1.00 21.78           C  
ATOM    715  C   LEU A  86     -45.102   6.684  -4.739  1.00 20.65           C  
ATOM    716  O   LEU A  86     -44.846   7.831  -4.297  1.00 21.67           O  
ATOM    717  CB  LEU A  86     -46.600   6.419  -6.724  1.00 21.10           C  
ATOM    718  CG  LEU A  86     -47.366   7.709  -6.505  1.00 21.51           C  
ATOM    719  CD1 LEU A  86     -46.774   8.962  -7.189  1.00 24.70           C  
ATOM    720  CD2 LEU A  86     -48.805   7.534  -6.860  1.00 23.19           C  
ATOM    721  N   GLU A  87     -45.430   5.660  -3.950  1.00 21.69           N  
ATOM    722  CA  GLU A  87     -45.371   5.813  -2.499  1.00 22.00           C  
ATOM    723  C   GLU A  87     -43.962   6.158  -2.016  1.00 20.96           C  
ATOM    724  O   GLU A  87     -43.777   7.054  -1.177  1.00 21.12           O  
ATOM    725  CB  GLU A  87     -45.958   4.587  -1.785  1.00 22.91           C  
ATOM    726  CG  GLU A  87     -45.984   4.802  -0.267  1.00 23.35           C  
ATOM    727  CD  GLU A  87     -46.650   3.744   0.508  1.00 27.07           C  
ATOM    728  OE1 GLU A  87     -47.198   2.777  -0.067  1.00 28.75           O  
ATOM    729  OE2 GLU A  87     -46.509   3.834   1.753  1.00 31.03           O  
ATOM    730  N   TYR A  88     -42.963   5.510  -2.579  1.00 20.99           N  
ATOM    731  CA  TYR A  88     -41.595   5.844  -2.233  1.00 20.81           C  
ATOM    732  C   TYR A  88     -41.288   7.316  -2.556  1.00 20.53           C  
ATOM    733  O   TYR A  88     -40.670   8.025  -1.744  1.00 19.04           O  
ATOM    734  CB  TYR A  88     -40.649   4.898  -2.991  1.00 21.17           C  
ATOM    735  CG  TYR A  88     -39.194   5.185  -2.720  1.00 19.29           C  
ATOM    736  CD1 TYR A  88     -38.585   4.779  -1.565  1.00 20.59           C  
ATOM    737  CD2 TYR A  88     -38.452   5.945  -3.621  1.00 20.72           C  
ATOM    738  CE1 TYR A  88     -37.247   5.028  -1.317  1.00 20.57           C  
ATOM    739  CE2 TYR A  88     -37.118   6.241  -3.383  1.00 22.35           C  
ATOM    740  CZ  TYR A  88     -36.509   5.756  -2.224  1.00 20.71           C  
ATOM    741  OH  TYR A  88     -35.161   6.025  -1.974  1.00 22.18           O  
ATOM    742  N   VAL A  89     -41.667   7.734  -3.772  1.00 20.32           N  
ATOM    743  CA  VAL A  89     -41.467   9.120  -4.202  1.00 20.42           C  
ATOM    744  C   VAL A  89     -42.133  10.092  -3.242  1.00 19.93           C  
ATOM    745  O   VAL A  89     -41.517  11.081  -2.837  1.00 20.64           O  
ATOM    746  CB  VAL A  89     -41.897   9.332  -5.666  1.00 20.80           C  
ATOM    747  CG1 VAL A  89     -41.949  10.782  -6.027  1.00 20.43           C  
ATOM    748  CG2 VAL A  89     -40.918   8.507  -6.575  1.00 22.29           C  
ATOM    749  N   VAL A  90     -43.376   9.839  -2.889  1.00 19.94           N  
ATOM    750  CA  VAL A  90     -44.107  10.746  -1.951  1.00 20.83           C  
ATOM    751  C   VAL A  90     -43.364  10.855  -0.605  1.00 20.35           C  
ATOM    752  O   VAL A  90     -43.138  11.964  -0.100  1.00 21.36           O  
ATOM    753  CB  VAL A  90     -45.534  10.267  -1.759  1.00 22.10           C  
ATOM    754  CG1 VAL A  90     -46.203  10.888  -0.526  1.00 20.84           C  
ATOM    755  CG2 VAL A  90     -46.328  10.535  -2.997  1.00 21.54           C  
ATOM    756  N   ARG A  91     -42.979   9.706  -0.025  0.50 20.17           N  
ATOM    758  CA  ARG A  91     -42.229   9.702   1.242  0.50 20.50           C  
ATOM    760  C   ARG A  91     -40.952  10.527   1.125  0.50 21.24           C  
ATOM    762  O   ARG A  91     -40.660  11.389   1.968  0.50 20.38           O  
ATOM    764  CB  ARG A  91     -41.923   8.283   1.697  0.50 20.34           C  
ATOM    766  CG  ARG A  91     -43.151   7.517   2.155  0.50 20.45           C  
ATOM    768  CD  ARG A  91     -42.813   6.127   2.463  0.50 20.25           C  
ATOM    770  NE  ARG A  91     -43.958   5.355   2.930  0.50 22.38           N  
ATOM    772  CZ  ARG A  91     -44.363   5.292   4.196  0.50 21.75           C  
ATOM    774  NH1 ARG A  91     -43.753   5.952   5.155  0.50 19.00           N  
ATOM    776  NH2 ARG A  91     -45.423   4.575   4.499  0.50 22.60           N  
ATOM    778  N   ARG A  92     -40.192  10.286   0.065  1.00 19.55           N  
ATOM    779  CA  ARG A  92     -38.940  10.992  -0.157  1.00 20.35           C  
ATOM    780  C   ARG A  92     -39.133  12.478  -0.382  1.00 20.43           C  
ATOM    781  O   ARG A  92     -38.289  13.271   0.046  1.00 20.04           O  
ATOM    782  CB  ARG A  92     -38.202  10.389  -1.335  1.00 19.52           C  
ATOM    783  CG  ARG A  92     -37.653   8.990  -1.067  1.00 20.49           C  
ATOM    784  CD  ARG A  92     -36.521   8.901  -0.103  1.00 20.75           C  
ATOM    785  NE  ARG A  92     -35.387   9.583  -0.725  1.00 21.94           N  
ATOM    786  CZ  ARG A  92     -34.797  10.719  -0.329  1.00 25.67           C  
ATOM    787  NH1 ARG A  92     -35.121  11.329   0.805  1.00 24.21           N  
ATOM    788  NH2 ARG A  92     -33.833  11.276  -1.090  1.00 26.41           N  
HETATM  789  N   MSE A  93     -40.225  12.855  -1.032  1.00 20.24           N  
HETATM  790  CA  MSE A  93     -40.482  14.303  -1.250  1.00 20.48           C  
HETATM  791  C   MSE A  93     -40.646  14.970   0.111  1.00 20.88           C  
HETATM  792  O   MSE A  93     -40.155  16.079   0.334  1.00 20.70           O  
HETATM  793  CB  MSE A  93     -41.705  14.520  -2.104  1.00 19.83           C  
HETATM  794  CG  MSE A  93     -41.502  14.219  -3.609  1.00 21.52           C  
HETATM  795 SE   MSE A  93     -43.109  14.487  -4.614  0.70 25.72          SE  
HETATM  796  CE  MSE A  93     -43.293  16.333  -4.172  1.00 25.00           C  
ATOM    797  N   VAL A  94     -41.348  14.297   1.015  1.00 20.89           N  
ATOM    798  CA  VAL A  94     -41.481  14.851   2.378  1.00 20.33           C  
ATOM    799  C   VAL A  94     -40.104  14.983   3.062  1.00 19.79           C  
ATOM    800  O   VAL A  94     -39.781  16.014   3.660  1.00 20.45           O  
ATOM    801  CB  VAL A  94     -42.444  14.032   3.219  1.00 21.05           C  
ATOM    802  CG1 VAL A  94     -42.491  14.564   4.678  1.00 21.94           C  
ATOM    803  CG2 VAL A  94     -43.858  14.005   2.533  1.00 20.87           C  
ATOM    804  N   GLU A  95     -39.297  13.930   2.980  1.00 20.82           N  
ATOM    805  CA  GLU A  95     -37.966  13.957   3.557  1.00 21.87           C  
ATOM    806  C   GLU A  95     -37.121  15.103   2.998  1.00 21.73           C  
ATOM    807  O   GLU A  95     -36.448  15.815   3.763  1.00 21.48           O  
ATOM    808  CB  GLU A  95     -37.290  12.603   3.300  1.00 20.60           C  
ATOM    809  CG  GLU A  95     -37.995  11.454   4.070  1.00 21.23           C  
ATOM    810  CD  GLU A  95     -37.329  10.098   3.901  1.00 25.45           C  
ATOM    811  OE1 GLU A  95     -36.390   9.995   3.076  1.00 24.18           O  
ATOM    812  OE2 GLU A  95     -37.672   9.164   4.690  1.00 26.80           O  
ATOM    813  N   VAL A  96     -37.145  15.285   1.680  1.00 20.58           N  
ATOM    814  CA  VAL A  96     -36.351  16.348   1.052  1.00 21.62           C  
ATOM    815  C   VAL A  96     -36.839  17.736   1.444  1.00 22.92           C  
ATOM    816  O   VAL A  96     -36.045  18.605   1.731  1.00 22.50           O  
ATOM    817  CB  VAL A  96     -36.321  16.187  -0.489  1.00 22.47           C  
ATOM    818  CG1 VAL A  96     -35.828  17.441  -1.150  1.00 25.28           C  
ATOM    819  CG2 VAL A  96     -35.504  15.011  -0.864  1.00 25.30           C  
ATOM    820  N   LEU A  97     -38.144  17.929   1.482  0.50 21.94           N  
ATOM    822  CA  LEU A  97     -38.691  19.220   1.865  0.50 21.94           C  
ATOM    824  C   LEU A  97     -38.302  19.605   3.292  0.50 22.16           C  
ATOM    826  O   LEU A  97     -38.090  20.790   3.589  0.50 20.89           O  
ATOM    828  CB  LEU A  97     -40.200  19.177   1.713  0.50 21.72           C  
ATOM    830  CG  LEU A  97     -40.940  20.439   2.080  0.50 23.49           C  
ATOM    832  CD1 LEU A  97     -42.296  20.425   1.379  0.50 24.35           C  
ATOM    834  CD2 LEU A  97     -41.077  20.507   3.570  0.50 20.06           C  
HETATM  836  N   MSE A  98     -38.247  18.619   4.198  1.00 20.81           N  
HETATM  837  CA  MSE A  98     -37.808  18.929   5.566  1.00 20.83           C  
HETATM  838  C   MSE A  98     -36.291  19.236   5.605  1.00 21.31           C  
HETATM  839  O   MSE A  98     -35.873  20.176   6.270  1.00 23.95           O  
HETATM  840  CB  MSE A  98     -38.152  17.793   6.515  1.00 19.95           C  
HETATM  841  CG  MSE A  98     -39.639  17.634   6.709  1.00 21.21           C  
HETATM  842 SE   MSE A  98     -40.247  16.286   7.973  0.70 22.07          SE  
HETATM  843  CE  MSE A  98     -39.491  14.790   7.042  1.00 23.80           C  
ATOM    844  N   ALA A  99     -35.512  18.400   4.912  1.00 21.69           N  
ATOM    845  CA  ALA A  99     -34.067  18.475   4.984  1.00 23.53           C  
ATOM    846  C   ALA A  99     -33.545  19.730   4.289  1.00 23.46           C  
ATOM    847  O   ALA A  99     -32.556  20.314   4.759  1.00 26.99           O  
ATOM    848  CB  ALA A  99     -33.470  17.253   4.349  1.00 23.63           C  
ATOM    849  N   GLU A 100     -34.188  20.094   3.182  1.00 23.71           N  
ATOM    850  CA  GLU A 100     -33.761  21.245   2.361  1.00 23.61           C  
ATOM    851  C   GLU A 100     -34.732  22.410   2.449  1.00 23.09           C  
ATOM    852  O   GLU A 100     -34.887  23.153   1.489  1.00 23.79           O  
ATOM    853  CB  GLU A 100     -33.619  20.809   0.915  1.00 24.73           C  
ATOM    854  CG  GLU A 100     -32.663  19.654   0.745  1.00 28.84           C  
ATOM    855  CD  GLU A 100     -31.208  20.005   1.054  1.00 30.88           C  
ATOM    856  OE1 GLU A 100     -30.783  21.158   1.196  1.00 35.80           O  
ATOM    857  OE2 GLU A 100     -30.441  19.038   1.244  1.00 42.98           O  
ATOM    858  N   LEU A 101     -35.429  22.546   3.584  1.00 22.36           N  
ATOM    859  CA  LEU A 101     -36.532  23.448   3.721  1.00 22.32           C  
ATOM    860  C   LEU A 101     -36.343  24.879   3.125  1.00 22.51           C  
ATOM    861  O   LEU A 101     -37.154  25.338   2.342  1.00 21.84           O  
ATOM    862  CB  LEU A 101     -36.883  23.478   5.192  1.00 23.60           C  
ATOM    863  CG  LEU A 101     -37.874  24.492   5.592  1.00 25.79           C  
ATOM    864  CD1 LEU A 101     -39.176  24.008   5.104  1.00 27.06           C  
ATOM    865  CD2 LEU A 101     -37.792  24.637   7.109  1.00 29.95           C  
ATOM    866  N   PRO A 102     -35.244  25.555   3.458  1.00 23.03           N  
ATOM    867  CA  PRO A 102     -35.111  26.927   2.900  1.00 23.46           C  
ATOM    868  C   PRO A 102     -34.970  26.981   1.376  1.00 21.87           C  
ATOM    869  O   PRO A 102     -35.517  27.877   0.746  1.00 22.43           O  
ATOM    870  CB  PRO A 102     -33.851  27.460   3.558  1.00 23.78           C  
ATOM    871  CG  PRO A 102     -33.256  26.387   4.291  1.00 25.68           C  
ATOM    872  CD  PRO A 102     -34.130  25.196   4.335  1.00 24.49           C  
ATOM    873  N   TYR A 103     -34.292  25.981   0.823  1.00 22.69           N  
ATOM    874  CA  TYR A 103     -34.027  25.902  -0.617  1.00 21.86           C  
ATOM    875  C   TYR A 103     -35.313  25.575  -1.333  1.00 22.58           C  
ATOM    876  O   TYR A 103     -35.662  26.181  -2.362  1.00 23.69           O  
ATOM    877  CB  TYR A 103     -32.945  24.848  -0.881  1.00 22.38           C  
ATOM    878  CG  TYR A 103     -31.633  25.241  -0.256  1.00 24.33           C  
ATOM    879  CD1 TYR A 103     -30.826  26.169  -0.841  1.00 26.04           C  
ATOM    880  CD2 TYR A 103     -31.241  24.714   0.973  1.00 28.59           C  
ATOM    881  CE1 TYR A 103     -29.613  26.527  -0.293  1.00 27.06           C  
ATOM    882  CE2 TYR A 103     -30.060  25.147   1.577  1.00 27.63           C  
ATOM    883  CZ  TYR A 103     -29.266  26.035   0.921  1.00 29.03           C  
ATOM    884  OH  TYR A 103     -28.043  26.518   1.445  1.00 33.16           O  
ATOM    885  N   VAL A 104     -36.027  24.598  -0.792  1.00 23.36           N  
ATOM    886  CA  VAL A 104     -37.309  24.215  -1.392  1.00 24.33           C  
ATOM    887  C   VAL A 104     -38.297  25.332  -1.267  1.00 23.51           C  
ATOM    888  O   VAL A 104     -39.071  25.609  -2.180  1.00 23.73           O  
ATOM    889  CB  VAL A 104     -37.838  22.899  -0.811  1.00 23.35           C  
ATOM    890  CG1 VAL A 104     -39.249  22.602  -1.362  1.00 27.67           C  
ATOM    891  CG2 VAL A 104     -36.947  21.773  -1.139  1.00 24.79           C  
ATOM    892  N   THR A 105     -38.287  26.059  -0.133  1.00 22.66           N  
ATOM    893  CA  THR A 105     -39.135  27.213   0.029  1.00 24.30           C  
ATOM    894  C   THR A 105     -38.888  28.264  -1.094  1.00 23.54           C  
ATOM    895  O   THR A 105     -39.813  28.750  -1.729  1.00 24.03           O  
ATOM    896  CB  THR A 105     -38.947  27.890   1.402  1.00 25.62           C  
ATOM    897  OG1 THR A 105     -39.233  26.984   2.494  1.00 25.55           O  
ATOM    898  CG2 THR A 105     -39.868  29.130   1.506  1.00 26.28           C  
ATOM    899  N   LEU A 106     -37.622  28.608  -1.350  1.00 23.14           N  
ATOM    900  CA  LEU A 106     -37.338  29.521  -2.418  1.00 23.17           C  
ATOM    901  C   LEU A 106     -37.792  29.027  -3.811  1.00 22.39           C  
ATOM    902  O   LEU A 106     -38.335  29.818  -4.577  1.00 24.39           O  
ATOM    903  CB  LEU A 106     -35.854  29.909  -2.407  1.00 23.45           C  
ATOM    904  CG  LEU A 106     -35.355  30.731  -1.253  1.00 24.94           C  
ATOM    905  CD1 LEU A 106     -33.823  30.978  -1.416  1.00 27.60           C  
ATOM    906  CD2 LEU A 106     -36.086  32.005  -1.183  1.00 28.63           C  
ATOM    907  N   LEU A 107     -37.611  27.736  -4.075  1.00 22.42           N  
ATOM    908  CA  LEU A 107     -37.969  27.141  -5.324  1.00 22.74           C  
ATOM    909  C   LEU A 107     -39.488  27.347  -5.480  1.00 24.02           C  
ATOM    910  O   LEU A 107     -39.970  27.762  -6.538  1.00 24.12           O  
ATOM    911  CB  LEU A 107     -37.631  25.672  -5.360  1.00 22.94           C  
ATOM    912  CG  LEU A 107     -38.146  24.945  -6.604  1.00 22.41           C  
ATOM    913  CD1 LEU A 107     -37.552  25.432  -7.881  1.00 25.12           C  
ATOM    914  CD2 LEU A 107     -37.859  23.492  -6.441  1.00 24.82           C  
ATOM    915  N   LEU A 108     -40.215  27.035  -4.424  1.00 24.91           N  
ATOM    916  CA  LEU A 108     -41.678  27.170  -4.482  1.00 26.36           C  
ATOM    917  C   LEU A 108     -42.182  28.585  -4.684  1.00 28.10           C  
ATOM    918  O   LEU A 108     -43.301  28.767  -5.216  1.00 31.23           O  
ATOM    919  CB  LEU A 108     -42.293  26.483  -3.259  1.00 27.23           C  
ATOM    920  CG  LEU A 108     -42.086  24.998  -3.142  1.00 29.37           C  
ATOM    921  CD1 LEU A 108     -42.692  24.404  -1.810  1.00 31.55           C  
ATOM    922  CD2 LEU A 108     -42.654  24.219  -4.319  1.00 34.61           C  
ATOM    923  N   ARG A 109     -41.391  29.581  -4.277  1.00 27.60           N  
ATOM    924  CA  ARG A 109     -41.719  31.004  -4.342  1.00 28.34           C  
ATOM    925  C   ARG A 109     -41.391  31.676  -5.656  1.00 29.33           C  
ATOM    926  O   ARG A 109     -41.795  32.834  -5.911  1.00 30.57           O  
ATOM    927  CB  ARG A 109     -41.056  31.739  -3.191  1.00 27.92           C  
ATOM    928  CG  ARG A 109     -41.710  31.430  -1.847  1.00 26.85           C  
ATOM    929  CD  ARG A 109     -41.024  32.173  -0.733  1.00 28.81           C  
ATOM    930  NE  ARG A 109     -41.620  31.819   0.565  1.00 27.31           N  
ATOM    931  CZ  ARG A 109     -41.190  32.328   1.701  1.00 32.58           C  
ATOM    932  NH1 ARG A 109     -40.253  33.280   1.705  1.00 31.06           N  
ATOM    933  NH2 ARG A 109     -41.803  31.993   2.839  1.00 34.41           N  
ATOM    934  N   VAL A 110     -40.598  30.985  -6.493  1.00 28.37           N  
ATOM    935  CA  VAL A 110     -40.192  31.580  -7.751  1.00 29.79           C  
ATOM    936  C   VAL A 110     -41.411  31.976  -8.578  1.00 31.82           C  
ATOM    937  O   VAL A 110     -42.213  31.141  -8.916  1.00 31.44           O  
ATOM    938  CB  VAL A 110     -39.313  30.619  -8.558  1.00 30.06           C  
ATOM    939  CG1 VAL A 110     -39.116  31.200  -9.912  1.00 30.28           C  
ATOM    940  CG2 VAL A 110     -37.956  30.446  -7.858  1.00 29.03           C  
ATOM    941  N   ARG A 111     -41.486  33.244  -8.927  1.00 35.43           N  
ATOM    942  CA  ARG A 111     -42.638  33.807  -9.672  1.00 39.63           C  
ATOM    943  C   ARG A 111     -42.090  34.947 -10.417  1.00 39.68           C  
ATOM    944  O   ARG A 111     -42.634  36.048 -10.359  1.00 44.77           O  
ATOM    945  CB  ARG A 111     -43.795  34.310  -8.762  1.00 40.12           C  
ATOM    946  CG  ARG A 111     -44.936  33.297  -8.491  1.00 44.46           C  
ATOM    947  CD  ARG A 111     -44.906  32.801  -7.047  1.00 47.90           C  
ATOM    948  NE  ARG A 111     -45.639  31.555  -6.813  1.00 48.07           N  
ATOM    949  N   GLY A 112     -40.972  34.728 -11.089  1.00 41.12           N  
ATOM    950  CA  GLY A 112     -40.305  35.817 -11.790  1.00 39.12           C  
ATOM    951  C   GLY A 112     -39.960  35.438 -13.220  1.00 37.36           C  
ATOM    952  O   GLY A 112     -40.275  34.313 -13.697  1.00 37.82           O  
ATOM    953  N   ASN A 113     -39.372  36.420 -13.880  1.00 36.25           N  
ATOM    954  CA  ASN A 113     -39.058  36.356 -15.295  1.00 36.02           C  
ATOM    955  C   ASN A 113     -37.576  36.505 -15.502  0.50 32.70           C  
ATOM    956  O   ASN A 113     -37.188  36.746 -16.636  0.50 34.66           O  
ATOM    957  CB  ASN A 113     -39.840  37.392 -16.184  1.00 36.23           C  
ATOM    958  CG  ASN A 113     -40.746  36.716 -17.275  1.00 42.68           C  
ATOM    959  OD1 ASN A 113     -41.605  35.886 -16.941  1.00 49.78           O  
ATOM    960  ND2 ASN A 113     -40.574  37.104 -18.582  1.00 43.84           N  
ATOM    961  N   THR A 114     -36.723  36.324 -14.491  0.50 25.71           N  
ATOM    962  CA  THR A 114     -35.284  36.218 -14.826  1.00 24.14           C  
ATOM    963  C   THR A 114     -35.083  34.874 -15.536  1.00 21.21           C  
ATOM    964  O   THR A 114     -35.929  33.946 -15.414  1.00 21.58           O  
ATOM    965  CB  THR A 114     -34.356  36.242 -13.644  1.00 25.68           C  
ATOM    966  OG1 THR A 114     -34.678  35.171 -12.753  1.00 24.09           O  
ATOM    967  CG2 THR A 114     -34.444  37.613 -12.875  1.00 26.53           C  
ATOM    968  N   GLY A 115     -33.967  34.766 -16.253  1.00 22.58           N  
ATOM    969  CA  GLY A 115     -33.640  33.479 -16.892  1.00 22.19           C  
ATOM    970  C   GLY A 115     -33.600  32.344 -15.881  1.00 21.68           C  
ATOM    971  O   GLY A 115     -34.070  31.232 -16.141  1.00 22.51           O  
ATOM    972  N   THR A 116     -32.988  32.600 -14.725  1.00 21.70           N  
ATOM    973  CA  THR A 116     -32.913  31.592 -13.668  1.00 22.34           C  
ATOM    974  C   THR A 116     -34.306  31.137 -13.219  1.00 21.76           C  
ATOM    975  O   THR A 116     -34.560  29.930 -13.039  1.00 21.90           O  
ATOM    976  CB  THR A 116     -32.079  32.113 -12.458  1.00 22.07           C  
ATOM    977  OG1 THR A 116     -30.717  32.267 -12.882  1.00 22.05           O  
ATOM    978  CG2 THR A 116     -32.133  31.151 -11.305  1.00 23.14           C  
ATOM    979  N   GLU A 117     -35.181  32.113 -12.969  1.00 21.59           N  
ATOM    980  CA  GLU A 117     -36.559  31.802 -12.524  1.00 21.89           C  
ATOM    981  C   GLU A 117     -37.317  31.022 -13.568  1.00 22.21           C  
ATOM    982  O   GLU A 117     -37.989  30.014 -13.260  1.00 21.82           O  
ATOM    983  CB  GLU A 117     -37.257  33.060 -12.083  1.00 21.76           C  
ATOM    984  CG  GLU A 117     -36.718  33.604 -10.825  1.00 20.84           C  
ATOM    985  CD  GLU A 117     -37.283  34.971 -10.490  1.00 25.18           C  
ATOM    986  OE1 GLU A 117     -36.850  35.947 -11.123  1.00 27.17           O  
ATOM    987  OE2 GLU A 117     -38.071  35.117  -9.479  1.00 28.74           O  
ATOM    988  N   ARG A 118     -37.199  31.420 -14.824  0.50 21.63           N  
ATOM    990  CA  ARG A 118     -37.897  30.675 -15.867  0.50 22.46           C  
ATOM    992  C   ARG A 118     -37.353  29.242 -15.993  0.50 22.63           C  
ATOM    994  O   ARG A 118     -38.116  28.260 -16.156  0.50 22.68           O  
ATOM    996  CB  ARG A 118     -37.862  31.452 -17.161  0.50 22.53           C  
ATOM    998  CG  ARG A 118     -38.823  32.634 -17.125  0.50 22.02           C  
ATOM   1000  CD  ARG A 118     -38.972  33.214 -18.489  0.50 23.49           C  
ATOM   1002  NE  ARG A 118     -37.663  33.639 -18.953  0.50 23.78           N  
ATOM   1004  CZ  ARG A 118     -37.127  34.844 -18.770  0.50 25.69           C  
ATOM   1006  NH1 ARG A 118     -37.823  35.794 -18.186  0.50 25.41           N  
ATOM   1008  NH2 ARG A 118     -35.907  35.119 -19.233  0.50 25.37           N  
ATOM   1010  N   TRP A 119     -36.051  29.104 -15.836  1.00 22.39           N  
ATOM   1011  CA  TRP A 119     -35.449  27.749 -15.825  1.00 21.90           C  
ATOM   1012  C   TRP A 119     -35.968  26.911 -14.706  1.00 23.35           C  
ATOM   1013  O   TRP A 119     -36.346  25.767 -14.905  1.00 23.77           O  
ATOM   1014  CB  TRP A 119     -33.929  27.872 -15.762  1.00 22.47           C  
ATOM   1015  CG  TRP A 119     -33.220  26.586 -15.605  1.00 22.68           C  
ATOM   1016  CD1 TRP A 119     -32.968  25.654 -16.565  1.00 24.39           C  
ATOM   1017  CD2 TRP A 119     -32.584  26.111 -14.410  1.00 23.30           C  
ATOM   1018  NE1 TRP A 119     -32.273  24.620 -16.040  1.00 25.22           N  
ATOM   1019  CE2 TRP A 119     -31.985  24.883 -14.717  1.00 23.93           C  
ATOM   1020  CE3 TRP A 119     -32.440  26.627 -13.125  1.00 25.09           C  
ATOM   1021  CZ2 TRP A 119     -31.250  24.173 -13.787  1.00 24.88           C  
ATOM   1022  CZ3 TRP A 119     -31.729  25.909 -12.198  1.00 26.52           C  
ATOM   1023  CH2 TRP A 119     -31.162  24.688 -12.528  1.00 25.20           C  
ATOM   1024  N   ALA A 120     -35.951  27.471 -13.504  1.00 22.90           N  
ATOM   1025  CA  ALA A 120     -36.446  26.785 -12.307  1.00 23.57           C  
ATOM   1026  C   ALA A 120     -37.908  26.388 -12.479  1.00 22.61           C  
ATOM   1027  O   ALA A 120     -38.270  25.222 -12.160  1.00 24.09           O  
ATOM   1028  CB  ALA A 120     -36.254  27.604 -11.118  1.00 24.00           C  
ATOM   1029  N   LEU A 121     -38.720  27.251 -13.077  1.00 22.36           N  
ATOM   1030  CA  LEU A 121     -40.157  26.898 -13.342  1.00 23.32           C  
ATOM   1031  C   LEU A 121     -40.272  25.763 -14.354  1.00 23.06           C  
ATOM   1032  O   LEU A 121     -41.096  24.874 -14.185  1.00 23.50           O  
ATOM   1033  CB  LEU A 121     -40.927  28.126 -13.729  1.00 23.14           C  
ATOM   1034  CG  LEU A 121     -41.142  29.212 -12.678  1.00 24.77           C  
ATOM   1035  CD1 LEU A 121     -41.516  30.496 -13.322  1.00 25.99           C  
ATOM   1036  CD2 LEU A 121     -42.180  28.760 -11.653  1.00 30.17           C  
ATOM   1037  N   GLU A 122     -39.457  25.793 -15.417  0.50 23.36           N  
ATOM   1039  CA  GLU A 122     -39.382  24.691 -16.412  0.50 24.16           C  
ATOM   1041  C   GLU A 122     -39.076  23.381 -15.718  0.50 24.25           C  
ATOM   1043  O   GLU A 122     -39.800  22.374 -15.876  0.50 24.26           O  
ATOM   1045  CB  GLU A 122     -38.314  24.960 -17.519  0.50 24.92           C  
ATOM   1047  CG  GLU A 122     -38.589  26.107 -18.494  0.50 27.99           C  
ATOM   1049  CD  GLU A 122     -37.360  26.478 -19.396  0.50 26.23           C  
ATOM   1051  OE1 GLU A 122     -36.246  25.928 -19.198  0.50 31.56           O  
ATOM   1053  OE2 GLU A 122     -37.490  27.378 -20.267  0.50 34.17           O  
ATOM   1055  N   ARG A 123     -38.021  23.390 -14.900  1.00 23.82           N  
ATOM   1056  CA  ARG A 123     -37.599  22.189 -14.183  0.50 23.80           C  
ATOM   1058  C   ARG A 123     -38.690  21.661 -13.264  1.00 24.57           C  
ATOM   1059  O   ARG A 123     -38.927  20.461 -13.187  1.00 25.01           O  
ATOM   1060  CB  ARG A 123     -36.294  22.505 -13.421  0.50 24.53           C  
ATOM   1062  CG  ARG A 123     -35.121  22.864 -14.355  0.50 22.73           C  
ATOM   1064  CD  ARG A 123     -34.779  21.745 -15.329  0.50 24.95           C  
ATOM   1066  NE  ARG A 123     -34.275  20.622 -14.572  0.50 26.06           N  
ATOM   1068  CZ  ARG A 123     -34.295  19.340 -14.945  0.50 27.45           C  
ATOM   1070  NH1 ARG A 123     -34.737  18.955 -16.124  0.50 27.83           N  
ATOM   1072  NH2 ARG A 123     -33.798  18.449 -14.139  0.50 26.34           N  
ATOM   1074  N   ARG A 124     -39.358  22.552 -12.552  0.50 23.66           N  
ATOM   1076  CA  ARG A 124     -40.461  22.140 -11.645  0.50 25.82           C  
ATOM   1078  C   ARG A 124     -41.639  21.523 -12.409  0.50 25.00           C  
ATOM   1080  O   ARG A 124     -42.330  20.580 -11.912  0.50 23.99           O  
ATOM   1082  CB  ARG A 124     -40.988  23.319 -10.841  0.50 27.18           C  
ATOM   1084  CG  ARG A 124     -40.400  23.575  -9.542  0.50 30.11           C  
ATOM   1086  CD  ARG A 124     -41.252  24.627  -8.764  0.50 27.94           C  
ATOM   1088  NE  ARG A 124     -42.383  24.001  -8.126  0.50 29.64           N  
ATOM   1090  CZ  ARG A 124     -43.511  24.593  -7.727  0.50 30.22           C  
ATOM   1092  NH1 ARG A 124     -43.730  25.888  -7.930  0.50 33.19           N  
ATOM   1094  NH2 ARG A 124     -44.433  23.854  -7.117  0.50 31.81           N  
ATOM   1096  N   ARG A 125     -41.924  22.045 -13.597  0.50 23.15           N  
ATOM   1098  CA  ARG A 125     -42.999  21.498 -14.390  0.50 23.19           C  
ATOM   1100  C   ARG A 125     -42.609  20.119 -14.924  0.50 23.52           C  
ATOM   1102  O   ARG A 125     -43.458  19.227 -15.044  0.50 22.98           O  
ATOM   1104  CB  ARG A 125     -43.380  22.431 -15.555  0.50 22.37           C  
ATOM   1106  CG  ARG A 125     -43.984  23.771 -15.128  0.50 22.28           C  
ATOM   1108  CD  ARG A 125     -44.532  24.507 -16.386  0.50 22.24           C  
ATOM   1110  NE  ARG A 125     -43.463  24.777 -17.366  0.50 23.59           N  
ATOM   1112  CZ  ARG A 125     -42.687  25.875 -17.395  0.50 19.57           C  
ATOM   1114  NH1 ARG A 125     -42.873  26.823 -16.583  0.50 21.30           N  
ATOM   1116  NH2 ARG A 125     -41.789  26.009 -18.317  0.50 24.79           N  
ATOM   1118  N   GLU A 126     -41.338  19.953 -15.280  1.00 23.80           N  
ATOM   1119  CA  GLU A 126     -40.838  18.631 -15.688  1.00 24.22           C  
ATOM   1120  C   GLU A 126     -40.975  17.603 -14.558  1.00 24.58           C  
ATOM   1121  O   GLU A 126     -41.401  16.449 -14.756  1.00 25.49           O  
ATOM   1122  CB  GLU A 126     -39.375  18.742 -16.126  1.00 24.39           C  
ATOM   1123  CG  GLU A 126     -38.818  17.390 -16.592  1.00 28.18           C  
ATOM   1124  CD  GLU A 126     -39.674  16.752 -17.705  1.00 36.92           C  
ATOM   1125  OE1 GLU A 126     -40.298  17.472 -18.532  1.00 43.45           O  
ATOM   1126  OE2 GLU A 126     -39.777  15.508 -17.734  1.00 45.26           O  
ATOM   1127  N   PHE A 127     -40.612  18.023 -13.359  1.00 25.09           N  
ATOM   1128  CA  PHE A 127     -40.712  17.143 -12.157  1.00 24.04           C  
ATOM   1129  C   PHE A 127     -42.179  16.763 -11.980  1.00 24.53           C  
ATOM   1130  O   PHE A 127     -42.499  15.585 -11.792  1.00 25.23           O  
ATOM   1131  CB  PHE A 127     -40.188  17.864 -10.936  1.00 25.40           C  
ATOM   1132  CG  PHE A 127     -40.252  17.015  -9.680  1.00 22.65           C  
ATOM   1133  CD1 PHE A 127     -39.263  16.077  -9.402  1.00 24.16           C  
ATOM   1134  CD2 PHE A 127     -41.340  17.100  -8.825  1.00 24.57           C  
ATOM   1135  CE1 PHE A 127     -39.337  15.287  -8.290  1.00 24.17           C  
ATOM   1136  CE2 PHE A 127     -41.405  16.341  -7.679  1.00 24.30           C  
ATOM   1137  CZ  PHE A 127     -40.428  15.389  -7.422  1.00 22.89           C  
ATOM   1138  N   ASP A 128     -43.074  17.755 -12.038  0.50 25.62           N  
ATOM   1140  CA  ASP A 128     -44.539  17.528 -11.949  0.50 25.18           C  
ATOM   1142  C   ASP A 128     -44.934  16.446 -12.946  0.50 24.06           C  
ATOM   1144  O   ASP A 128     -45.537  15.472 -12.550  0.50 23.89           O  
ATOM   1146  CB  ASP A 128     -45.357  18.831 -12.135  0.50 26.13           C  
ATOM   1148  CG  ASP A 128     -46.925  18.619 -12.285  0.50 27.78           C  
ATOM   1150  OD1 ASP A 128     -47.659  18.028 -11.403  0.50 34.74           O  
ATOM   1152  OD2 ASP A 128     -47.479  19.078 -13.310  0.50 35.91           O  
ATOM   1154  N   HIS A 129     -44.555  16.618 -14.230  1.00 23.77           N  
ATOM   1155  CA  HIS A 129     -44.924  15.716 -15.292  1.00 22.78           C  
ATOM   1156  C   HIS A 129     -44.482  14.295 -14.976  1.00 23.21           C  
ATOM   1157  O   HIS A 129     -45.246  13.346 -15.237  1.00 23.61           O  
ATOM   1158  CB  HIS A 129     -44.328  16.147 -16.612  1.00 22.90           C  
ATOM   1159  CG  HIS A 129     -45.031  17.307 -17.278  1.00 24.40           C  
ATOM   1160  ND1 HIS A 129     -46.373  17.299 -17.586  1.00 27.67           N  
ATOM   1161  CD2 HIS A 129     -44.530  18.453 -17.809  1.00 27.75           C  
ATOM   1162  CE1 HIS A 129     -46.681  18.431 -18.220  1.00 25.83           C  
ATOM   1163  NE2 HIS A 129     -45.582  19.162 -18.327  1.00 26.70           N  
ATOM   1164  N   ARG A 130     -43.287  14.174 -14.402  0.50 22.68           N  
ATOM   1166  CA  ARG A 130     -42.717  12.882 -14.094  0.50 22.48           C  
ATOM   1168  C   ARG A 130     -43.573  12.164 -13.070  0.50 23.33           C  
ATOM   1170  O   ARG A 130     -43.973  11.006 -13.260  0.50 23.70           O  
ATOM   1172  CB  ARG A 130     -41.274  13.051 -13.626  0.50 23.22           C  
ATOM   1174  CG  ARG A 130     -40.348  13.444 -14.822  0.50 23.17           C  
ATOM   1176  CD  ARG A 130     -38.938  12.991 -14.698  0.50 27.61           C  
ATOM   1178  NE  ARG A 130     -38.741  11.543 -14.536  0.50 23.93           N  
ATOM   1180  CZ  ARG A 130     -37.588  10.996 -14.139  0.50 26.32           C  
ATOM   1182  NH1 ARG A 130     -36.491  11.729 -13.903  0.50 26.30           N  
ATOM   1184  NH2 ARG A 130     -37.543   9.729 -13.932  0.50 23.94           N  
ATOM   1186  N   VAL A 131     -43.875  12.871 -11.993  1.00 24.12           N  
ATOM   1187  CA  VAL A 131     -44.662  12.295 -10.921  1.00 23.31           C  
ATOM   1188  C   VAL A 131     -46.071  11.974 -11.403  1.00 23.53           C  
ATOM   1189  O   VAL A 131     -46.614  10.905 -11.089  1.00 23.57           O  
ATOM   1190  CB  VAL A 131     -44.656  13.123  -9.619  1.00 24.67           C  
ATOM   1191  CG1 VAL A 131     -45.453  12.399  -8.554  1.00 27.13           C  
ATOM   1192  CG2 VAL A 131     -43.244  13.326  -9.111  1.00 24.07           C  
ATOM   1193  N   ALA A 132     -46.669  12.860 -12.203  1.00 23.37           N  
ATOM   1194  CA  ALA A 132     -47.988  12.575 -12.744  1.00 22.86           C  
ATOM   1195  C   ALA A 132     -47.973  11.296 -13.587  1.00 24.32           C  
ATOM   1196  O   ALA A 132     -48.940  10.511 -13.576  1.00 23.59           O  
ATOM   1197  CB  ALA A 132     -48.459  13.752 -13.563  1.00 22.67           C  
ATOM   1198  N   ALA A 133     -46.859  11.034 -14.289  1.00 23.24           N  
ATOM   1199  CA  ALA A 133     -46.764   9.792 -15.087  1.00 22.99           C  
ATOM   1200  C   ALA A 133     -46.702   8.560 -14.197  1.00 23.19           C  
ATOM   1201  O   ALA A 133     -47.265   7.513 -14.564  1.00 23.98           O  
ATOM   1202  CB  ALA A 133     -45.559   9.857 -15.976  1.00 23.18           C  
ATOM   1203  N   LEU A 134     -46.040   8.678 -13.057  1.00 24.18           N  
ATOM   1204  CA  LEU A 134     -46.039   7.576 -12.080  1.00 23.71           C  
ATOM   1205  C   LEU A 134     -47.454   7.275 -11.590  1.00 24.50           C  
ATOM   1206  O   LEU A 134     -47.864   6.136 -11.509  1.00 24.69           O  
ATOM   1207  CB  LEU A 134     -45.119   7.881 -10.902  1.00 25.73           C  
ATOM   1208  CG  LEU A 134     -43.618   7.905 -11.162  1.00 28.95           C  
ATOM   1209  CD1 LEU A 134     -42.897   8.273  -9.860  1.00 30.79           C  
ATOM   1210  CD2 LEU A 134     -43.119   6.582 -11.673  1.00 31.98           C  
ATOM   1211  N   LEU A 135     -48.214   8.314 -11.315  1.00 23.38           N  
ATOM   1212  CA  LEU A 135     -49.582   8.124 -10.827  1.00 22.57           C  
ATOM   1213  C   LEU A 135     -50.436   7.504 -11.947  1.00 24.38           C  
ATOM   1214  O   LEU A 135     -51.262   6.610 -11.668  1.00 22.92           O  
ATOM   1215  CB  LEU A 135     -50.122   9.460 -10.344  1.00 24.67           C  
ATOM   1216  CG  LEU A 135     -51.274   9.413  -9.378  1.00 28.17           C  
ATOM   1217  CD1 LEU A 135     -51.240  10.597  -8.438  1.00 29.48           C  
ATOM   1218  CD2 LEU A 135     -52.546   9.457 -10.107  1.00 29.94           C  
ATOM   1219  N   LYS A 136     -50.272   7.981 -13.175  1.00 23.09           N  
ATOM   1220  CA  LYS A 136     -50.955   7.394 -14.327  1.00 24.12           C  
ATOM   1221  C   LYS A 136     -50.650   5.908 -14.471  1.00 22.99           C  
ATOM   1222  O   LYS A 136     -51.573   5.083 -14.683  1.00 23.13           O  
ATOM   1223  CB  LYS A 136     -50.585   8.146 -15.612  1.00 24.17           C  
ATOM   1224  CG  LYS A 136     -51.409   7.731 -16.797  1.00 27.23           C  
ATOM   1225  CD  LYS A 136     -51.126   8.539 -18.028  1.00 27.98           C  
ATOM   1226  CE  LYS A 136     -51.977   8.065 -19.197  1.00 31.37           C  
ATOM   1227  NZ  LYS A 136     -51.873   8.878 -20.448  1.00 35.51           N  
ATOM   1228  N   ASP A 137     -49.372   5.550 -14.300  1.00 23.20           N  
ATOM   1229  CA  ASP A 137     -48.991   4.152 -14.353  1.00 22.79           C  
ATOM   1230  C   ASP A 137     -49.642   3.336 -13.255  1.00 23.17           C  
ATOM   1231  O   ASP A 137     -50.121   2.229 -13.491  1.00 24.17           O  
ATOM   1232  CB  ASP A 137     -47.478   3.982 -14.271  1.00 23.88           C  
ATOM   1233  CG  ASP A 137     -46.707   4.502 -15.492  1.00 27.96           C  
ATOM   1234  OD1 ASP A 137     -47.273   4.718 -16.581  1.00 34.52           O  
ATOM   1235  OD2 ASP A 137     -45.476   4.679 -15.309  1.00 32.49           O  
ATOM   1236  N   ALA A 138     -49.689   3.889 -12.056  1.00 22.21           N  
ATOM   1237  CA  ALA A 138     -50.340   3.165 -10.941  1.00 22.73           C  
ATOM   1238  C   ALA A 138     -51.844   2.983 -11.170  1.00 24.22           C  
ATOM   1239  O   ALA A 138     -52.393   1.992 -10.770  1.00 24.92           O  
ATOM   1240  CB  ALA A 138     -50.089   3.903  -9.637  1.00 22.40           C  
ATOM   1241  N   ALA A 139     -52.503   3.981 -11.772  1.00 24.04           N  
ATOM   1242  CA  ALA A 139     -53.933   3.878 -12.126  1.00 24.53           C  
ATOM   1243  C   ALA A 139     -54.117   2.717 -13.165  1.00 25.01           C  
ATOM   1244  O   ALA A 139     -55.012   1.880 -13.072  1.00 26.21           O  
ATOM   1245  CB  ALA A 139     -54.417   5.184 -12.660  1.00 25.46           C  
ATOM   1246  N   ALA A 140     -53.228   2.693 -14.148  1.00 25.97           N  
ATOM   1247  CA  ALA A 140     -53.265   1.643 -15.195  1.00 25.68           C  
ATOM   1248  C   ALA A 140     -53.078   0.256 -14.613  1.00 27.25           C  
ATOM   1249  O   ALA A 140     -53.633  -0.703 -15.139  1.00 27.52           O  
ATOM   1250  CB  ALA A 140     -52.242   1.897 -16.244  1.00 25.68           C  
ATOM   1251  N   GLU A 141     -52.241   0.125 -13.596  1.00 26.38           N  
ATOM   1252  CA  GLU A 141     -51.957  -1.153 -12.955  1.00 27.32           C  
ATOM   1253  C   GLU A 141     -53.054  -1.578 -11.976  1.00 27.63           C  
ATOM   1254  O   GLU A 141     -53.000  -2.689 -11.442  1.00 28.19           O  
ATOM   1255  CB  GLU A 141     -50.571  -1.105 -12.282  1.00 26.80           C  
ATOM   1256  CG  GLU A 141     -49.466  -0.996 -13.318  1.00 25.76           C  
ATOM   1257  CD  GLU A 141     -48.066  -0.791 -12.772  1.00 32.59           C  
ATOM   1258  OE1 GLU A 141     -47.828  -1.112 -11.557  1.00 30.43           O  
ATOM   1259  OE2 GLU A 141     -47.219  -0.338 -13.627  1.00 39.24           O  
ATOM   1260  N   GLY A 142     -53.995  -0.673 -11.741  1.00 27.47           N  
ATOM   1261  CA  GLY A 142     -55.191  -0.899 -10.967  1.00 29.06           C  
ATOM   1262  C   GLY A 142     -55.020  -0.641  -9.496  1.00 30.36           C  
ATOM   1263  O   GLY A 142     -55.866  -1.025  -8.696  1.00 33.07           O  
ATOM   1264  N   ASP A 143     -53.905  -0.010  -9.143  1.00 29.70           N  
ATOM   1265  CA  ASP A 143     -53.534   0.203  -7.753  1.00 31.17           C  
ATOM   1266  C   ASP A 143     -53.969   1.557  -7.236  1.00 31.20           C  
ATOM   1267  O   ASP A 143     -54.123   1.704  -6.023  1.00 33.46           O  
ATOM   1268  CB  ASP A 143     -52.022  -0.022  -7.555  1.00 30.59           C  
ATOM   1269  CG  ASP A 143     -51.647  -1.507  -7.558  1.00 32.90           C  
ATOM   1270  OD1 ASP A 143     -52.464  -2.328  -7.050  1.00 33.39           O  
ATOM   1271  OD2 ASP A 143     -50.554  -1.896  -8.064  1.00 31.62           O  
ATOM   1272  N   VAL A 144     -54.175   2.514  -8.135  1.00 30.97           N  
ATOM   1273  CA  VAL A 144     -54.665   3.864  -7.814  1.00 30.73           C  
ATOM   1274  C   VAL A 144     -56.051   4.038  -8.464  1.00 31.57           C  
ATOM   1275  O   VAL A 144     -56.289   3.535  -9.569  1.00 31.38           O  
ATOM   1276  CB  VAL A 144     -53.648   4.962  -8.287  1.00 31.59           C  
ATOM   1277  CG1 VAL A 144     -54.304   6.374  -8.437  1.00 30.25           C  
ATOM   1278  CG2 VAL A 144     -52.474   5.043  -7.304  1.00 30.51           C  
ATOM   1279  N   ARG A 145     -56.948   4.755  -7.773  1.00 29.50           N  
ATOM   1280  CA  ARG A 145     -58.356   4.871  -8.132  1.00 29.86           C  
ATOM   1281  C   ARG A 145     -58.494   5.618  -9.467  1.00 29.01           C  
ATOM   1282  O   ARG A 145     -57.681   6.462  -9.801  1.00 30.81           O  
ATOM   1283  CB  ARG A 145     -59.143   5.631  -7.041  1.00 30.40           C  
ATOM   1284  CG  ARG A 145     -58.757   7.116  -6.922  1.00 29.81           C  
ATOM   1285  CD  ARG A 145     -59.144   7.695  -5.565  1.00 28.71           C  
ATOM   1286  NE  ARG A 145     -60.591   7.757  -5.432  1.00 27.90           N  
ATOM   1287  CZ  ARG A 145     -61.257   7.876  -4.292  1.00 29.85           C  
ATOM   1288  NH1 ARG A 145     -60.643   8.005  -3.117  1.00 28.09           N  
ATOM   1289  NH2 ARG A 145     -62.583   7.865  -4.344  1.00 30.05           N  
ATOM   1290  N   ALA A 146     -59.563   5.319 -10.183  1.00 30.59           N  
ATOM   1291  CA  ALA A 146     -59.816   5.893 -11.518  1.00 30.78           C  
ATOM   1292  C   ALA A 146     -60.796   7.053 -11.551  1.00 31.31           C  
ATOM   1293  O   ALA A 146     -60.986   7.637 -12.624  1.00 32.27           O  
ATOM   1294  CB  ALA A 146     -60.352   4.831 -12.417  1.00 31.61           C  
ATOM   1295  N   ASP A 147     -61.438   7.355 -10.417  1.00 29.05           N  
ATOM   1296  CA  ASP A 147     -62.465   8.375 -10.351  1.00 28.31           C  
ATOM   1297  C   ASP A 147     -61.972   9.773  -9.984  1.00 27.88           C  
ATOM   1298  O   ASP A 147     -62.806  10.656  -9.643  1.00 28.98           O  
ATOM   1299  CB  ASP A 147     -63.604   7.960  -9.395  1.00 27.67           C  
ATOM   1300  CG  ASP A 147     -63.124   7.647  -8.006  1.00 28.66           C  
ATOM   1301  OD1 ASP A 147     -61.900   7.519  -7.813  1.00 29.05           O  
ATOM   1302  OD2 ASP A 147     -63.993   7.488  -7.115  1.00 31.53           O  
ATOM   1303  N   VAL A 148     -60.657   9.962  -9.990  1.00 28.46           N  
ATOM   1304  CA  VAL A 148     -60.058  11.316  -9.850  1.00 27.37           C  
ATOM   1305  C   VAL A 148     -59.085  11.469 -10.989  1.00 25.74           C  
ATOM   1306  O   VAL A 148     -58.260  10.611 -11.193  1.00 26.81           O  
ATOM   1307  CB  VAL A 148     -59.265  11.567  -8.514  1.00 27.38           C  
ATOM   1308  CG1 VAL A 148     -58.844  13.038  -8.448  1.00 25.99           C  
ATOM   1309  CG2 VAL A 148     -60.131  11.138  -7.330  1.00 30.42           C  
ATOM   1310  N   GLU A 149     -59.153  12.579 -11.712  1.00 25.80           N  
ATOM   1311  CA  GLU A 149     -58.231  12.779 -12.807  1.00 24.96           C  
ATOM   1312  C   GLU A 149     -56.783  12.767 -12.261  1.00 24.45           C  
ATOM   1313  O   GLU A 149     -56.471  13.398 -11.228  1.00 23.60           O  
ATOM   1314  CB  GLU A 149     -58.580  14.098 -13.538  1.00 26.42           C  
ATOM   1315  CG  GLU A 149     -59.813  14.091 -14.401  1.00 31.96           C  
ATOM   1316  CD  GLU A 149     -59.513  13.513 -15.774  1.00 35.31           C  
ATOM   1317  OE1 GLU A 149     -58.360  13.085 -15.996  1.00 42.39           O  
ATOM   1318  OE2 GLU A 149     -60.413  13.463 -16.627  1.00 43.75           O  
ATOM   1319  N   VAL A 150     -55.914  12.078 -12.982  1.00 23.25           N  
ATOM   1320  CA  VAL A 150     -54.529  11.912 -12.576  1.00 24.41           C  
ATOM   1321  C   VAL A 150     -53.823  13.234 -12.308  1.00 22.75           C  
ATOM   1322  O   VAL A 150     -53.096  13.395 -11.301  1.00 22.90           O  
ATOM   1323  CB  VAL A 150     -53.733  11.127 -13.652  1.00 25.28           C  
ATOM   1324  CG1 VAL A 150     -52.230  11.248 -13.423  1.00 25.73           C  
ATOM   1325  CG2 VAL A 150     -54.133   9.667 -13.671  1.00 25.76           C  
ATOM   1326  N   ARG A 151     -54.000  14.225 -13.168  0.50 22.69           N  
ATOM   1328  CA  ARG A 151     -53.249  15.452 -12.917  0.50 22.17           C  
ATOM   1330  C   ARG A 151     -53.820  16.306 -11.801  0.50 22.16           C  
ATOM   1332  O   ARG A 151     -53.101  17.104 -11.177  0.50 22.08           O  
ATOM   1334  CB  ARG A 151     -53.102  16.261 -14.180  0.50 21.84           C  
ATOM   1336  CG  ARG A 151     -52.203  15.550 -15.127  0.50 22.79           C  
ATOM   1338  CD  ARG A 151     -51.884  16.403 -16.280  0.50 23.60           C  
ATOM   1340  NE  ARG A 151     -51.285  15.621 -17.336  0.50 22.88           N  
ATOM   1342  CZ  ARG A 151     -49.997  15.482 -17.591  0.50 25.74           C  
ATOM   1344  NH1 ARG A 151     -49.680  14.747 -18.639  0.50 23.31           N  
ATOM   1346  NH2 ARG A 151     -49.048  16.033 -16.846  0.50 29.07           N  
ATOM   1348  N   LEU A 152     -55.115  16.156 -11.577  1.00 21.98           N  
ATOM   1349  CA  LEU A 152     -55.719  16.827 -10.421  1.00 21.68           C  
ATOM   1350  C   LEU A 152     -55.281  16.169  -9.157  1.00 22.48           C  
ATOM   1351  O   LEU A 152     -54.914  16.869  -8.181  1.00 22.10           O  
ATOM   1352  CB  LEU A 152     -57.250  16.826 -10.581  1.00 21.85           C  
ATOM   1353  CG  LEU A 152     -58.041  17.455  -9.422  1.00 22.31           C  
ATOM   1354  CD1 LEU A 152     -57.568  18.866  -9.084  1.00 20.56           C  
ATOM   1355  CD2 LEU A 152     -59.523  17.462  -9.773  1.00 21.86           C  
ATOM   1356  N   ALA A 153     -55.316  14.833  -9.112  1.00 22.49           N  
ATOM   1357  CA  ALA A 153     -54.794  14.140  -7.936  1.00 23.95           C  
ATOM   1358  C   ALA A 153     -53.345  14.526  -7.654  1.00 23.80           C  
ATOM   1359  O   ALA A 153     -52.947  14.767  -6.518  1.00 22.88           O  
ATOM   1360  CB  ALA A 153     -54.916  12.666  -8.116  1.00 24.26           C  
ATOM   1361  N   THR A 154     -52.537  14.602  -8.690  1.00 23.54           N  
ATOM   1362  CA  THR A 154     -51.123  14.909  -8.494  1.00 23.39           C  
ATOM   1363  C   THR A 154     -50.980  16.336  -7.925  1.00 22.67           C  
ATOM   1364  O   THR A 154     -50.223  16.621  -6.970  1.00 22.43           O  
ATOM   1365  CB  THR A 154     -50.356  14.789  -9.854  1.00 24.77           C  
ATOM   1366  OG1 THR A 154     -50.503  13.437 -10.370  1.00 24.49           O  
ATOM   1367  CG2 THR A 154     -48.890  15.100  -9.641  1.00 26.36           C  
ATOM   1368  N   ARG A 155     -51.735  17.279  -8.489  1.00 22.05           N  
ATOM   1369  CA  ARG A 155     -51.712  18.678  -8.011  1.00 22.25           C  
ATOM   1370  C   ARG A 155     -52.091  18.800  -6.554  1.00 22.29           C  
ATOM   1371  O   ARG A 155     -51.478  19.496  -5.760  1.00 21.44           O  
ATOM   1372  CB  ARG A 155     -52.696  19.536  -8.846  1.00 22.02           C  
ATOM   1373  CG  ARG A 155     -52.564  20.980  -8.597  1.00 23.12           C  
ATOM   1374  CD  ARG A 155     -51.205  21.576  -8.930  1.00 24.89           C  
ATOM   1375  NE  ARG A 155     -51.022  21.555 -10.349  1.00 24.77           N  
ATOM   1376  CZ  ARG A 155     -49.839  21.448 -10.976  1.00 31.03           C  
ATOM   1377  NH1 ARG A 155     -48.704  21.349 -10.283  1.00 33.17           N  
ATOM   1378  NH2 ARG A 155     -49.792  21.399 -12.302  1.00 28.50           N  
ATOM   1379  N   LEU A 156     -53.141  18.073  -6.174  1.00 20.94           N  
ATOM   1380  CA  LEU A 156     -53.604  18.108  -4.769  1.00 20.30           C  
ATOM   1381  C   LEU A 156     -52.600  17.453  -3.787  1.00 20.52           C  
ATOM   1382  O   LEU A 156     -52.392  17.964  -2.716  1.00 21.70           O  
ATOM   1383  CB  LEU A 156     -54.992  17.389  -4.705  1.00 20.89           C  
ATOM   1384  CG  LEU A 156     -56.134  18.194  -5.339  1.00 22.60           C  
ATOM   1385  CD1 LEU A 156     -57.352  17.295  -5.370  1.00 23.49           C  
ATOM   1386  CD2 LEU A 156     -56.433  19.471  -4.555  1.00 23.30           C  
ATOM   1387  N   VAL A 157     -52.041  16.302  -4.187  1.00 22.27           N  
ATOM   1388  CA  VAL A 157     -51.048  15.626  -3.396  1.00 22.71           C  
ATOM   1389  C   VAL A 157     -49.824  16.542  -3.229  1.00 22.74           C  
ATOM   1390  O   VAL A 157     -49.310  16.683  -2.124  1.00 22.61           O  
ATOM   1391  CB  VAL A 157     -50.683  14.238  -4.019  1.00 23.06           C  
ATOM   1392  CG1 VAL A 157     -49.386  13.679  -3.336  1.00 24.69           C  
ATOM   1393  CG2 VAL A 157     -51.896  13.281  -3.846  1.00 24.69           C  
ATOM   1394  N   PHE A 158     -49.379  17.187  -4.298  1.00 23.25           N  
ATOM   1395  CA  PHE A 158     -48.248  18.154  -4.179  1.00 24.04           C  
ATOM   1396  C   PHE A 158     -48.628  19.292  -3.255  1.00 23.62           C  
ATOM   1397  O   PHE A 158     -47.777  19.784  -2.511  1.00 23.67           O  
ATOM   1398  CB  PHE A 158     -47.859  18.713  -5.561  1.00 24.99           C  
ATOM   1399  CG  PHE A 158     -46.908  17.791  -6.369  1.00 25.78           C  
ATOM   1400  CD1 PHE A 158     -46.837  16.433  -6.122  1.00 29.00           C  
ATOM   1401  CD2 PHE A 158     -46.026  18.325  -7.232  1.00 35.84           C  
ATOM   1402  CE1 PHE A 158     -45.991  15.625  -6.854  1.00 31.93           C  
ATOM   1403  CE2 PHE A 158     -45.156  17.450  -7.975  1.00 33.65           C  
ATOM   1404  CZ  PHE A 158     -45.203  16.147  -7.764  1.00 29.52           C  
ATOM   1405  N   GLY A 159     -49.890  19.749  -3.309  1.00 23.43           N  
ATOM   1406  CA  GLY A 159     -50.336  20.802  -2.384  1.00 23.56           C  
ATOM   1407  C   GLY A 159     -50.175  20.382  -0.948  1.00 23.38           C  
ATOM   1408  O   GLY A 159     -49.696  21.156  -0.091  1.00 24.14           O  
HETATM 1409  N   MSE A 160     -50.576  19.157  -0.630  1.00 22.46           N  
HETATM 1410  CA  MSE A 160     -50.411  18.644   0.695  1.00 23.09           C  
HETATM 1411  C   MSE A 160     -48.948  18.617   1.093  1.00 23.25           C  
HETATM 1412  O   MSE A 160     -48.578  19.108   2.183  1.00 23.36           O  
HETATM 1413  CB  MSE A 160     -51.069  17.281   0.857  1.00 23.32           C  
HETATM 1414  CG  MSE A 160     -50.933  16.683   2.256  1.00 26.27           C  
HETATM 1415 SE   MSE A 160     -51.737  14.912   2.450  0.70 27.89          SE  
HETATM 1416  CE  MSE A 160     -53.543  15.432   2.651  1.00 28.10           C  
ATOM   1417  N   ILE A 161     -48.113  18.002   0.237  1.00 21.83           N  
ATOM   1418  CA  ILE A 161     -46.705  17.907   0.544  1.00 22.35           C  
ATOM   1419  C   ILE A 161     -46.046  19.295   0.715  1.00 22.67           C  
ATOM   1420  O   ILE A 161     -45.317  19.606   1.671  1.00 23.51           O  
ATOM   1421  CB  ILE A 161     -45.971  17.028  -0.490  1.00 22.98           C  
ATOM   1422  CG1 ILE A 161     -46.503  15.600  -0.435  1.00 24.13           C  
ATOM   1423  CG2 ILE A 161     -44.445  17.102  -0.250  1.00 23.82           C  
ATOM   1424  CD1 ILE A 161     -46.144  14.797  -1.674  1.00 23.96           C  
ATOM   1425  N   ASN A 162     -46.250  20.168  -0.274  1.00 22.58           N  
ATOM   1426  CA  ASN A 162     -45.579  21.445  -0.289  1.00 22.65           C  
ATOM   1427  C   ASN A 162     -45.983  22.341   0.871  1.00 24.34           C  
ATOM   1428  O   ASN A 162     -45.266  23.243   1.234  1.00 24.54           O  
ATOM   1429  CB  ASN A 162     -45.857  22.148  -1.605  1.00 25.41           C  
ATOM   1430  CG  ASN A 162     -45.141  21.541  -2.744  1.00 26.19           C  
ATOM   1431  OD1 ASN A 162     -44.186  20.793  -2.599  1.00 28.77           O  
ATOM   1432  ND2 ASN A 162     -45.637  21.859  -3.958  1.00 37.04           N  
ATOM   1433  N   SER A 163     -47.172  22.112   1.431  1.00 25.17           N  
ATOM   1434  CA  SER A 163     -47.659  22.886   2.578  1.00 25.90           C  
ATOM   1435  C   SER A 163     -46.755  22.782   3.786  1.00 25.31           C  
ATOM   1436  O   SER A 163     -46.760  23.650   4.657  1.00 26.28           O  
ATOM   1437  CB  SER A 163     -49.101  22.423   2.939  1.00 26.56           C  
ATOM   1438  OG  SER A 163     -49.105  21.253   3.655  1.00 29.14           O  
ATOM   1439  N   ILE A 164     -45.966  21.717   3.835  1.00 23.86           N  
ATOM   1440  CA  ILE A 164     -45.107  21.425   4.956  1.00 26.05           C  
ATOM   1441  C   ILE A 164     -44.101  22.559   5.166  1.00 24.44           C  
ATOM   1442  O   ILE A 164     -43.778  22.893   6.324  1.00 23.51           O  
ATOM   1443  CB  ILE A 164     -44.524  20.094   4.816  1.00 27.26           C  
ATOM   1444  CG1 ILE A 164     -45.698  19.059   4.725  1.00 30.16           C  
ATOM   1445  CG2 ILE A 164     -43.670  19.797   6.025  1.00 31.16           C  
ATOM   1446  CD1 ILE A 164     -45.250  17.682   4.406  1.00 32.94           C  
ATOM   1447  N   VAL A 165     -43.702  23.270   4.101  1.00 23.27           N  
ATOM   1448  CA  VAL A 165     -42.751  24.369   4.282  1.00 23.86           C  
ATOM   1449  C   VAL A 165     -43.329  25.477   5.170  1.00 23.28           C  
ATOM   1450  O   VAL A 165     -42.537  26.256   5.769  1.00 23.30           O  
ATOM   1451  CB  VAL A 165     -42.247  25.013   2.951  1.00 26.07           C  
ATOM   1452  CG1 VAL A 165     -41.611  24.017   2.130  1.00 26.60           C  
ATOM   1453  CG2 VAL A 165     -43.346  25.755   2.253  1.00 26.75           C  
ATOM   1454  N   GLU A 166     -44.674  25.585   5.280  1.00 22.29           N  
ATOM   1455  CA  GLU A 166     -45.302  26.639   6.025  1.00 24.32           C  
ATOM   1456  C   GLU A 166     -45.255  26.389   7.521  1.00 24.48           C  
ATOM   1457  O   GLU A 166     -45.198  27.347   8.309  1.00 24.57           O  
ATOM   1458  CB  GLU A 166     -46.769  26.850   5.606  1.00 26.37           C  
ATOM   1459  CG  GLU A 166     -46.920  27.311   4.182  1.00 32.11           C  
ATOM   1460  CD  GLU A 166     -46.395  28.727   3.930  1.00 37.70           C  
ATOM   1461  N   TRP A 167     -45.361  25.087   7.895  1.00 24.32           N  
ATOM   1462  CA  TRP A 167     -45.621  24.728   9.308  1.00 24.05           C  
ATOM   1463  C   TRP A 167     -44.523  23.937  10.008  1.00 23.89           C  
ATOM   1464  O   TRP A 167     -44.462  23.906  11.235  1.00 23.74           O  
ATOM   1465  CB  TRP A 167     -46.967  23.993   9.393  1.00 23.31           C  
ATOM   1466  CG  TRP A 167     -47.137  22.707   8.697  1.00 23.51           C  
ATOM   1467  CD1 TRP A 167     -47.813  22.495   7.582  1.00 23.01           C  
ATOM   1468  CD2 TRP A 167     -46.681  21.445   9.146  1.00 22.39           C  
ATOM   1469  NE1 TRP A 167     -47.792  21.156   7.232  1.00 26.51           N  
ATOM   1470  CE2 TRP A 167     -47.130  20.493   8.216  1.00 23.62           C  
ATOM   1471  CE3 TRP A 167     -45.954  21.016  10.272  1.00 25.09           C  
ATOM   1472  CZ2 TRP A 167     -46.848  19.140   8.336  1.00 26.32           C  
ATOM   1473  CZ3 TRP A 167     -45.711  19.637  10.397  1.00 23.50           C  
ATOM   1474  CH2 TRP A 167     -46.180  18.751   9.442  1.00 25.20           C  
ATOM   1475  N   TYR A 168     -43.671  23.254   9.241  1.00 22.04           N  
ATOM   1476  CA  TYR A 168     -42.682  22.350   9.809  1.00 21.74           C  
ATOM   1477  C   TYR A 168     -41.490  23.103  10.303  1.00 22.12           C  
ATOM   1478  O   TYR A 168     -40.972  23.964   9.622  1.00 22.92           O  
ATOM   1479  CB  TYR A 168     -42.238  21.350   8.744  1.00 21.75           C  
ATOM   1480  CG  TYR A 168     -41.021  20.583   9.215  1.00 20.37           C  
ATOM   1481  CD1 TYR A 168     -41.158  19.466  10.059  1.00 22.51           C  
ATOM   1482  CD2 TYR A 168     -39.767  20.923   8.761  1.00 22.56           C  
ATOM   1483  CE1 TYR A 168     -39.985  18.796  10.449  1.00 23.51           C  
ATOM   1484  CE2 TYR A 168     -38.611  20.281   9.169  1.00 24.25           C  
ATOM   1485  CZ  TYR A 168     -38.733  19.210  10.007  1.00 24.36           C  
ATOM   1486  OH  TYR A 168     -37.520  18.573  10.399  1.00 26.20           O  
ATOM   1487  N   ARG A 169     -41.099  22.809  11.565  1.00 24.86           N  
ATOM   1488  CA  ARG A 169     -39.874  23.282  12.145  1.00 26.50           C  
ATOM   1489  C   ARG A 169     -39.168  22.057  12.721  1.00 28.21           C  
ATOM   1490  O   ARG A 169     -39.787  21.294  13.489  1.00 28.10           O  
ATOM   1491  CB  ARG A 169     -40.207  24.231  13.303  1.00 27.94           C  
ATOM   1492  CG  ARG A 169     -39.098  24.733  13.995  1.00 28.76           C  
ATOM   1493  CD  ARG A 169     -39.572  25.869  14.904  1.00 29.88           C  
ATOM   1494  NE  ARG A 169     -39.862  25.386  16.226  1.00 27.70           N  
ATOM   1495  CZ  ARG A 169     -39.982  26.194  17.292  1.00 30.16           C  
ATOM   1496  NH1 ARG A 169     -39.900  27.506  17.128  1.00 29.88           N  
ATOM   1497  NH2 ARG A 169     -40.194  25.693  18.512  1.00 30.53           N  
ATOM   1498  N   PRO A 170     -37.880  21.904  12.414  1.00 29.55           N  
ATOM   1499  CA  PRO A 170     -37.223  20.804  13.048  1.00 31.83           C  
ATOM   1500  C   PRO A 170     -37.031  21.059  14.541  1.00 33.13           C  
ATOM   1501  O   PRO A 170     -36.919  22.213  14.947  1.00 33.09           O  
ATOM   1502  CB  PRO A 170     -35.849  20.753  12.343  1.00 31.12           C  
ATOM   1503  CG  PRO A 170     -35.563  22.080  11.913  1.00 31.80           C  
ATOM   1504  CD  PRO A 170     -36.961  22.672  11.557  1.00 28.99           C  
ATOM   1505  N   GLU A 171     -37.074  19.989  15.326  1.00 36.59           N  
ATOM   1506  CA  GLU A 171     -36.460  19.988  16.675  1.00 37.71           C  
ATOM   1507  C   GLU A 171     -34.956  19.853  16.523  1.00 38.68           C  
ATOM   1508  O   GLU A 171     -34.216  20.848  16.465  1.00 39.38           O  
ATOM   1509  CB  GLU A 171     -36.972  18.804  17.502  1.00 38.96           C  
ATOM   1510  CG  GLU A 171     -38.485  18.870  17.822  1.00 38.94           C  
ATOM   1511  N   SER A 183     -39.616   6.693  20.393  1.00 39.41           N  
ATOM   1512  CA  SER A 183     -38.501   6.259  21.216  1.00 38.34           C  
ATOM   1513  C   SER A 183     -37.136   6.246  20.481  1.00 37.69           C  
ATOM   1514  O   SER A 183     -36.104   5.989  21.132  1.00 38.45           O  
ATOM   1515  CB  SER A 183     -38.794   4.878  21.821  1.00 38.79           C  
ATOM   1516  OG  SER A 183     -39.090   3.919  20.804  1.00 39.45           O  
ATOM   1517  N   GLY A 184     -37.121   6.509  19.166  1.00 36.43           N  
ATOM   1518  CA  GLY A 184     -35.856   6.609  18.420  1.00 35.32           C  
ATOM   1519  C   GLY A 184     -35.066   7.783  18.983  1.00 34.51           C  
ATOM   1520  O   GLY A 184     -35.696   8.754  19.470  1.00 33.71           O  
ATOM   1521  N   VAL A 185     -33.724   7.730  18.934  1.00 32.51           N  
ATOM   1522  CA  VAL A 185     -32.934   8.824  19.569  1.00 31.74           C  
ATOM   1523  C   VAL A 185     -33.070  10.125  18.791  1.00 30.65           C  
ATOM   1524  O   VAL A 185     -33.035  11.201  19.375  1.00 30.30           O  
ATOM   1525  CB  VAL A 185     -31.417   8.551  19.749  1.00 33.01           C  
ATOM   1526  CG1 VAL A 185     -31.145   7.216  20.406  1.00 31.98           C  
ATOM   1527  CG2 VAL A 185     -30.701   8.661  18.447  1.00 33.41           C  
ATOM   1528  N   SER A 186     -33.177  10.039  17.477  1.00 27.42           N  
ATOM   1529  CA  SER A 186     -33.413  11.238  16.686  1.00 27.23           C  
ATOM   1530  C   SER A 186     -34.320  10.903  15.525  1.00 25.80           C  
ATOM   1531  O   SER A 186     -34.444   9.733  15.125  1.00 25.57           O  
ATOM   1532  CB  SER A 186     -32.109  11.858  16.163  1.00 27.66           C  
ATOM   1533  OG  SER A 186     -31.488  11.020  15.193  1.00 29.08           O  
ATOM   1534  N   GLY A 187     -34.958  11.937  15.003  1.00 24.63           N  
ATOM   1535  CA  GLY A 187     -35.732  11.829  13.764  1.00 23.37           C  
ATOM   1536  C   GLY A 187     -37.170  11.362  13.890  1.00 23.43           C  
ATOM   1537  O   GLY A 187     -37.837  11.203  12.893  1.00 22.38           O  
ATOM   1538  N   ALA A 188     -37.661  11.171  15.121  1.00 23.22           N  
ATOM   1539  CA  ALA A 188     -39.042  10.691  15.346  1.00 23.05           C  
ATOM   1540  C   ALA A 188     -40.067  11.649  14.769  1.00 21.86           C  
ATOM   1541  O   ALA A 188     -41.045  11.216  14.136  1.00 22.00           O  
ATOM   1542  CB  ALA A 188     -39.303  10.502  16.865  1.00 23.85           C  
ATOM   1543  N   GLY A 189     -39.858  12.943  14.959  1.00 20.87           N  
ATOM   1544  CA  GLY A 189     -40.849  13.882  14.415  1.00 21.92           C  
ATOM   1545  C   GLY A 189     -40.905  13.874  12.895  1.00 22.00           C  
ATOM   1546  O   GLY A 189     -41.961  14.015  12.269  1.00 23.04           O  
ATOM   1547  N   GLU A 190     -39.739  13.714  12.280  1.00 21.35           N  
ATOM   1548  CA  GLU A 190     -39.623  13.620  10.829  1.00 21.22           C  
ATOM   1549  C   GLU A 190     -40.320  12.360  10.300  1.00 20.47           C  
ATOM   1550  O   GLU A 190     -41.095  12.397   9.344  1.00 20.92           O  
ATOM   1551  CB  GLU A 190     -38.153  13.689  10.382  1.00 22.82           C  
ATOM   1552  CG  GLU A 190     -37.520  15.076  10.527  1.00 22.72           C  
ATOM   1553  CD  GLU A 190     -37.302  15.588  11.932  1.00 27.55           C  
ATOM   1554  OE1 GLU A 190     -37.069  14.777  12.863  1.00 25.99           O  
ATOM   1555  OE2 GLU A 190     -37.341  16.852  12.151  1.00 26.91           O  
ATOM   1556  N   ARG A 191     -40.041  11.229  10.926  1.00 19.83           N  
ATOM   1557  CA  ARG A 191     -40.676  10.002  10.541  1.00 20.14           C  
ATOM   1558  C   ARG A 191     -42.168  10.101  10.656  1.00 20.51           C  
ATOM   1559  O   ARG A 191     -42.867   9.526   9.860  1.00 21.02           O  
ATOM   1560  CB  ARG A 191     -40.125   8.828  11.371  1.00 21.02           C  
ATOM   1561  CG  ARG A 191     -38.702   8.458  11.001  1.00 22.20           C  
ATOM   1562  CD  ARG A 191     -38.228   7.197  11.676  1.00 22.20           C  
ATOM   1563  NE  ARG A 191     -38.021   7.405  13.113  1.00 23.25           N  
ATOM   1564  CZ  ARG A 191     -36.933   7.934  13.663  1.00 22.47           C  
ATOM   1565  NH1 ARG A 191     -35.885   8.262  12.933  1.00 22.80           N  
ATOM   1566  NH2 ARG A 191     -36.876   8.065  14.982  1.00 26.23           N  
ATOM   1567  N   GLU A 192     -42.638  10.799  11.683  1.00 21.83           N  
ATOM   1568  CA  GLU A 192     -44.068  10.901  11.938  1.00 22.08           C  
ATOM   1569  C   GLU A 192     -44.711  11.602  10.773  1.00 22.14           C  
ATOM   1570  O   GLU A 192     -45.794  11.194  10.304  1.00 22.15           O  
ATOM   1571  CB  GLU A 192     -44.345  11.656  13.245  1.00 22.37           C  
ATOM   1572  CG  GLU A 192     -45.873  11.879  13.487  1.00 23.52           C  
ATOM   1573  CD  GLU A 192     -46.228  12.798  14.652  1.00 25.96           C  
ATOM   1574  OE1 GLU A 192     -45.426  13.629  15.128  1.00 28.47           O  
ATOM   1575  OE2 GLU A 192     -47.346  12.578  15.173  1.00 36.81           O  
ATOM   1576  N   VAL A 193     -44.091  12.685  10.308  1.00 20.95           N  
ATOM   1577  CA  VAL A 193     -44.675  13.459   9.170  1.00 21.06           C  
ATOM   1578  C   VAL A 193     -44.675  12.637   7.908  1.00 21.66           C  
ATOM   1579  O   VAL A 193     -45.695  12.555   7.218  1.00 22.15           O  
ATOM   1580  CB  VAL A 193     -43.958  14.799   8.933  1.00 21.86           C  
ATOM   1581  CG1 VAL A 193     -44.566  15.583   7.798  1.00 22.35           C  
ATOM   1582  CG2 VAL A 193     -43.999  15.647  10.225  1.00 22.74           C  
ATOM   1583  N   VAL A 194     -43.580  11.963   7.622  1.00 21.67           N  
ATOM   1584  CA  VAL A 194     -43.510  11.136   6.426  1.00 22.05           C  
ATOM   1585  C   VAL A 194     -44.561  10.040   6.436  1.00 21.50           C  
ATOM   1586  O   VAL A 194     -45.271   9.828   5.439  1.00 22.15           O  
ATOM   1587  CB  VAL A 194     -42.152  10.515   6.286  1.00 20.74           C  
ATOM   1588  CG1 VAL A 194     -42.096   9.537   5.124  1.00 22.82           C  
ATOM   1589  CG2 VAL A 194     -41.032  11.581   6.178  1.00 21.78           C  
ATOM   1590  N   ASP A 195     -44.685   9.343   7.558  1.00 22.34           N  
ATOM   1591  CA  ASP A 195     -45.677   8.285   7.698  1.00 22.00           C  
ATOM   1592  C   ASP A 195     -47.095   8.773   7.547  1.00 22.17           C  
ATOM   1593  O   ASP A 195     -47.924   8.167   6.893  1.00 23.45           O  
ATOM   1594  CB  ASP A 195     -45.450   7.600   9.048  1.00 23.27           C  
ATOM   1595  CG  ASP A 195     -44.226   6.728   9.064  1.00 25.22           C  
ATOM   1596  OD1 ASP A 195     -43.605   6.375   8.008  1.00 28.92           O  
ATOM   1597  OD2 ASP A 195     -43.877   6.264  10.182  1.00 27.85           O  
ATOM   1598  N   ALA A 196     -47.389   9.910   8.136  1.00 22.54           N  
ATOM   1599  CA  ALA A 196     -48.729  10.519   8.075  1.00 22.24           C  
ATOM   1600  C   ALA A 196     -49.068  10.896   6.667  1.00 23.09           C  
ATOM   1601  O   ALA A 196     -50.160  10.677   6.225  1.00 23.81           O  
ATOM   1602  CB  ALA A 196     -48.742  11.740   8.939  1.00 23.46           C  
ATOM   1603  N   VAL A 197     -48.125  11.535   5.965  1.00 23.00           N  
ATOM   1604  CA  VAL A 197     -48.397  11.950   4.591  1.00 22.55           C  
ATOM   1605  C   VAL A 197     -48.648  10.718   3.769  1.00 23.85           C  
ATOM   1606  O   VAL A 197     -49.579  10.700   2.965  1.00 23.04           O  
ATOM   1607  CB  VAL A 197     -47.233  12.776   4.004  1.00 23.03           C  
ATOM   1608  CG1 VAL A 197     -47.444  13.013   2.526  1.00 24.63           C  
ATOM   1609  CG2 VAL A 197     -47.155  14.125   4.691  1.00 24.76           C  
ATOM   1610  N   ALA A 198     -47.789   9.701   3.915  1.00 23.28           N  
ATOM   1611  CA  ALA A 198     -48.010   8.470   3.117  1.00 24.80           C  
ATOM   1612  C   ALA A 198     -49.375   7.878   3.388  1.00 24.58           C  
ATOM   1613  O   ALA A 198     -50.088   7.492   2.438  1.00 26.05           O  
ATOM   1614  CB  ALA A 198     -46.892   7.464   3.311  1.00 25.60           C  
ATOM   1615  N   ARG A 199     -49.755   7.809   4.650  1.00 23.98           N  
ATOM   1616  CA  ARG A 199     -51.064   7.217   5.035  1.00 24.63           C  
ATOM   1617  C   ARG A 199     -52.234   7.991   4.467  1.00 24.35           C  
ATOM   1618  O   ARG A 199     -53.164   7.431   3.882  1.00 23.92           O  
ATOM   1619  CB  ARG A 199     -51.174   7.086   6.544  1.00 25.57           C  
ATOM   1620  CG  ARG A 199     -50.287   6.012   7.049  1.00 28.23           C  
ATOM   1621  CD  ARG A 199     -50.360   5.831   8.557  1.00 33.33           C  
ATOM   1622  NE  ARG A 199     -49.468   4.726   8.947  1.00 40.41           N  
ATOM   1623  CZ  ARG A 199     -48.474   4.777   9.848  1.00 41.30           C  
ATOM   1624  NH1 ARG A 199     -48.231   5.850  10.587  1.00 40.99           N  
ATOM   1625  NH2 ARG A 199     -47.750   3.679  10.047  1.00 43.80           N  
ATOM   1626  N   LEU A 200     -52.176   9.303   4.603  1.00 23.36           N  
ATOM   1627  CA  LEU A 200     -53.276  10.134   4.097  1.00 23.05           C  
ATOM   1628  C   LEU A 200     -53.325  10.192   2.601  1.00 22.60           C  
ATOM   1629  O   LEU A 200     -54.410  10.102   2.018  1.00 23.87           O  
ATOM   1630  CB  LEU A 200     -53.173  11.554   4.653  1.00 23.36           C  
ATOM   1631  CG  LEU A 200     -53.398  11.712   6.125  1.00 28.00           C  
ATOM   1632  CD1 LEU A 200     -53.498  13.234   6.374  1.00 27.65           C  
ATOM   1633  CD2 LEU A 200     -54.588  10.965   6.705  1.00 27.58           C  
ATOM   1634  N   VAL A 201     -52.162  10.283   1.920  1.00 22.18           N  
ATOM   1635  CA  VAL A 201     -52.163  10.286   0.477  1.00 22.59           C  
ATOM   1636  C   VAL A 201     -52.789   9.000  -0.100  1.00 22.88           C  
ATOM   1637  O   VAL A 201     -53.594   9.059  -1.046  1.00 23.96           O  
ATOM   1638  CB  VAL A 201     -50.732  10.555  -0.135  1.00 22.47           C  
ATOM   1639  CG1 VAL A 201     -50.707  10.275  -1.556  1.00 22.75           C  
ATOM   1640  CG2 VAL A 201     -50.327  12.012   0.185  1.00 23.19           C  
ATOM   1641  N   PHE A 202     -52.416   7.835   0.443  1.00 22.38           N  
ATOM   1642  CA  PHE A 202     -52.842   6.553  -0.136  1.00 22.07           C  
ATOM   1643  C   PHE A 202     -54.175   6.057   0.390  1.00 23.05           C  
ATOM   1644  O   PHE A 202     -54.942   5.419  -0.364  1.00 24.56           O  
ATOM   1645  CB  PHE A 202     -51.718   5.545  -0.039  1.00 22.38           C  
ATOM   1646  CG  PHE A 202     -50.634   5.853  -1.025  1.00 22.62           C  
ATOM   1647  CD1 PHE A 202     -50.724   5.378  -2.328  1.00 27.72           C  
ATOM   1648  CD2 PHE A 202     -49.611   6.726  -0.694  1.00 24.58           C  
ATOM   1649  CE1 PHE A 202     -49.743   5.712  -3.263  1.00 26.48           C  
ATOM   1650  CE2 PHE A 202     -48.664   7.090  -1.654  1.00 22.71           C  
ATOM   1651  CZ  PHE A 202     -48.758   6.589  -2.920  1.00 25.91           C  
ATOM   1652  N   GLY A 203     -54.435   6.320   1.669  1.00 23.87           N  
ATOM   1653  CA  GLY A 203     -55.687   5.841   2.321  1.00 23.46           C  
ATOM   1654  C   GLY A 203     -56.636   6.902   2.819  1.00 23.29           C  
ATOM   1655  O   GLY A 203     -57.771   6.538   3.221  1.00 25.51           O  
ATOM   1656  N   GLY A 204     -56.259   8.165   2.840  1.00 23.56           N  
ATOM   1657  CA  GLY A 204     -57.175   9.218   3.307  1.00 23.36           C  
ATOM   1658  C   GLY A 204     -57.475   9.106   4.787  1.00 23.70           C  
ATOM   1659  O   GLY A 204     -56.833   8.321   5.507  1.00 24.30           O  
ATOM   1660  N   LEU A 205     -58.501   9.790   5.247  1.00 24.54           N  
ATOM   1661  CA  LEU A 205     -58.820   9.820   6.661  1.00 23.93           C  
ATOM   1662  C   LEU A 205     -59.679   8.639   7.129  1.00 25.47           C  
ATOM   1663  O   LEU A 205     -59.730   8.341   8.325  1.00 24.59           O  
ATOM   1664  CB  LEU A 205     -59.640  11.074   6.986  1.00 24.42           C  
ATOM   1665  CG  LEU A 205     -58.966  12.430   6.948  1.00 26.22           C  
ATOM   1666  CD1 LEU A 205     -60.046  13.469   7.184  1.00 24.69           C  
ATOM   1667  CD2 LEU A 205     -57.891  12.478   8.014  1.00 27.28           C  
ATOM   1668  N   ARG A 206     -60.424   8.010   6.226  1.00 25.84           N  
ATOM   1669  CA  ARG A 206     -61.426   7.047   6.667  1.00 29.29           C  
ATOM   1670  C   ARG A 206     -60.810   5.804   7.265  1.00 30.92           C  
ATOM   1671  O   ARG A 206     -59.817   5.269   6.734  1.00 31.02           O  
ATOM   1672  CB  ARG A 206     -62.334   6.647   5.511  1.00 29.26           C  
ATOM   1673  CG  ARG A 206     -63.464   7.632   5.298  1.00 32.66           C  
ATOM   1674  CD  ARG A 206     -64.718   7.024   4.616  1.00 32.42           C  
ATOM   1675  NE  ARG A 206     -65.243   7.995   3.638  1.00 34.99           N  
ATOM   1676  CZ  ARG A 206     -66.009   9.050   3.924  1.00 35.01           C  
ATOM   1677  NH1 ARG A 206     -66.396   9.299   5.159  1.00 36.48           N  
ATOM   1678  NH2 ARG A 206     -66.404   9.857   2.942  1.00 35.08           N  
ATOM   1679  N   LYS A 207     -61.431   5.307   8.346  1.00 33.48           N  
ATOM   1680  CA  LYS A 207     -61.046   4.002   8.880  1.00 35.10           C  
ATOM   1681  C   LYS A 207     -61.297   2.872   7.831  1.00 36.34           C  
ATOM   1682  O   LYS A 207     -60.411   2.003   7.567  1.00 36.88           O  
ATOM   1683  CB  LYS A 207     -61.772   3.721  10.213  1.00 35.56           C  
ATOM   1684  CG  LYS A 207     -60.936   2.847  11.214  1.00 35.69           C  
ATOM   1685  CD  LYS A 207     -61.478   2.912  12.647  1.00 36.15           C  
TER    1686      LYS A 207                                                      
END
MOLECULE T0454.pdb
ATOM      1  N   ASP     5     -12.420  32.658   0.024  1.00 27.13           N
ATOM      2  CA  ASP     5     -13.312  32.598   1.217  1.00 27.34           C
ATOM      3  CB  ASP     5     -12.512  32.690   2.520  1.00 28.50           C
ATOM      4  CG  ASP     5     -13.404  32.599   3.759  1.00 30.42           C
ATOM      5  OD1 ASP     5     -14.289  31.706   3.803  1.00 33.47           O
ATOM      6  OD2 ASP     5     -13.226  33.430   4.680  1.00 32.05           O
ATOM      7  C   ASP     5     -14.424  33.644   1.238  1.00 26.73           C
ATOM      8  O   ASP     5     -15.477  33.398   1.835  1.00 26.63           O
ATOM      9  N   CYS     6     -14.211  34.799   0.611  0.50 26.41           N
ATOM     11  CA  CYS     6     -15.286  35.794   0.531  0.50 26.28           C
ATOM     13  CB  CYS     6     -14.751  37.198   0.241  0.50 26.57           C
ATOM     15  SG  CYS     6     -14.050  37.968   1.731  0.50 29.41           S
ATOM     17  C   CYS     6     -16.388  35.363  -0.439  0.50 25.38           C
ATOM     19  O   CYS     6     -17.496  35.901  -0.414  0.50 25.34           O
ATOM     21  N   ARG     7     -16.080  34.368  -1.271  1.00 24.45           N
ATOM     22  CA  ARG     7     -17.093  33.680  -2.080  1.00 22.28           C
ATOM     23  CB  ARG     7     -16.421  32.728  -3.079  1.00 22.90           C
ATOM     30  C   ARG     7     -18.066  32.903  -1.186  1.00 20.46           C
ATOM     31  O   ARG     7     -19.262  32.867  -1.449  1.00 20.43           O
ATOM     32  N   SER     8     -17.547  32.253  -0.148  0.50 19.10           N
ATOM     34  CA  SER     8     -18.391  31.436   0.731  0.50 17.33           C
ATOM     36  CB  SER     8     -17.550  30.493   1.586  0.50 17.45           C
ATOM     38  OG  SER     8     -18.312  29.968   2.658  0.50 15.65           O
ATOM     40  C   SER     8     -19.258  32.322   1.613  0.50 16.60           C
ATOM     42  O   SER     8     -20.455  32.084   1.776  0.50 15.91           O
ATOM     44  N   ARG     9     -18.645  33.365   2.159  0.50 15.61           N
ATOM     46  CA  ARG     9     -19.363  34.297   3.022  0.50 14.83           C
ATOM     48  CB  ARG     9     -18.372  35.205   3.766  0.50 15.25           C
ATOM     50  CG  ARG     9     -17.394  34.394   4.628  0.50 14.59           C
ATOM     52  CD  ARG     9     -16.768  35.163   5.795  0.50 16.76           C
ATOM     54  NE  ARG     9     -15.709  36.081   5.358  0.50 18.23           N
ATOM     56  CZ  ARG     9     -15.907  37.364   5.046  0.50 17.11           C
ATOM     58  NH1 ARG     9     -14.883  38.115   4.657  0.50 16.37           N
ATOM     60  NH2 ARG     9     -17.129  37.896   5.121  0.50 17.10           N
ATOM     62  C   ARG     9     -20.452  35.089   2.282  0.50 14.49           C
ATOM     64  O   ARG     9     -21.506  35.370   2.850  0.50 13.18           O
ATOM     66  N   LEU    10     -20.187  35.432   1.021  1.00 14.14           N
ATOM     67  CA  LEU    10     -21.183  36.018   0.143  1.00 15.70           C
ATOM     68  CB  LEU    10     -20.580  36.459  -1.201  1.00 16.55           C
ATOM     69  CG  LEU    10     -20.226  37.923  -1.321  1.00 18.07           C
ATOM     70  CD1 LEU    10     -19.435  38.165  -2.626  1.00 18.10           C
ATOM     71  CD2 LEU    10     -21.495  38.769  -1.285  1.00 16.77           C
ATOM     72  C   LEU    10     -22.364  35.072  -0.083  1.00 15.96           C
ATOM     73  O   LEU    10     -23.511  35.520  -0.035  1.00 16.63           O
ATOM     74  N   MET    11     -22.097  33.792  -0.326  0.70 16.06           N
ATOM     76  CA  MET    11     -23.179  32.843  -0.534  0.70 17.38           C
ATOM     78  CB  MET    11     -22.637  31.461  -0.863  0.70 20.17           C
ATOM     80  CG  MET    11     -22.166  31.316  -2.273  0.70 25.34           C
ATOM     82  SD  MET    11     -23.611  30.818  -3.503  0.70 46.93          SE
ATOM     84  CE  MET    11     -22.374  30.088  -4.856  0.70 32.85           C
ATOM     86  C   MET    11     -24.065  32.759   0.707  0.70 15.90           C
ATOM     88  O   MET    11     -25.298  32.724   0.592  0.70 14.79           O
ATOM     90  N   GLU    12     -23.436  32.726   1.888  1.00 13.16           N
ATOM     91  CA  GLU    12     -24.186  32.691   3.141  1.00 12.28           C
ATOM     92  CB  GLU    12     -23.255  32.550   4.367  1.00 11.62           C
ATOM     93  CG  GLU    12     -24.006  32.676   5.679  1.00 12.98           C
ATOM     94  CD  GLU    12     -24.899  31.451   5.972  1.00 17.78           C
ATOM     95  OE1 GLU    12     -24.548  30.339   5.520  1.00 20.61           O
ATOM     96  OE2 GLU    12     -25.952  31.593   6.636  1.00 18.33           O
ATOM     97  C   GLU    12     -25.062  33.946   3.278  1.00 11.77           C
ATOM     98  O   GLU    12     -26.263  33.868   3.569  1.00 10.95           O
ATOM     99  N   VAL    13     -24.441  35.104   3.102  1.00 11.38           N
ATOM    100  CA  VAL    13     -25.143  36.347   3.297  1.00 11.79           C
ATOM    101  CB  VAL    13     -24.168  37.555   3.216  1.00 11.85           C
ATOM    102  CG1 VAL    13     -24.903  38.816   2.771  1.00 13.25           C
ATOM    103  CG2 VAL    13     -23.437  37.739   4.528  1.00 12.09           C
ATOM    104  C   VAL    13     -26.264  36.469   2.270  1.00 12.08           C
ATOM    105  O   VAL    13     -27.360  36.860   2.613  1.00 12.20           O
ATOM    106  N   ALA    14     -25.987  36.132   1.016  1.00 11.94           N
ATOM    107  CA  ALA    14     -27.028  36.192  -0.026  1.00 12.57           C
ATOM    108  CB  ALA    14     -26.434  35.847  -1.397  1.00 12.81           C
ATOM    109  C   ALA    14     -28.224  35.272   0.324  1.00 12.70           C
ATOM    110  O   ALA    14     -29.404  35.681   0.225  1.00 12.49           O
ATOM    111  N   THR    15     -27.933  34.045   0.752  1.00 12.08           N
ATOM    112  CA  THR    15     -29.000  33.092   1.088  1.00 13.57           C
ATOM    113  CB  THR    15     -28.420  31.727   1.526  1.00 13.02           C
ATOM    114  OG1 THR    15     -27.592  31.204   0.477  1.00 13.54           O
ATOM    115  CG2 THR    15     -29.544  30.705   1.864  1.00 14.11           C
ATOM    116  C   THR    15     -29.885  33.685   2.197  1.00 13.81           C
ATOM    117  O   THR    15     -31.100  33.676   2.080  1.00 14.69           O
ATOM    118  N   GLU    16     -29.283  34.229   3.251  0.50 12.86           N
ATOM    120  CA  GLU    16     -30.060  34.743   4.392  0.50 12.65           C
ATOM    122  CB  GLU    16     -29.168  34.850   5.619  0.50 11.98           C
ATOM    124  CG  GLU    16     -28.366  33.560   5.847  0.50 10.56           C
ATOM    126  CD  GLU    16     -29.193  32.437   6.436  0.50 10.50           C
ATOM    128  OE1 GLU    16     -29.690  32.653   7.554  0.50 13.56           O
ATOM    130  OE2 GLU    16     -29.343  31.334   5.814  0.50  9.37           O
ATOM    132  C   GLU    16     -30.844  36.053   4.135  0.50 13.06           C
ATOM    134  O   GLU    16     -31.941  36.247   4.680  0.50 12.44           O
ATOM    136  N   LEU    17     -30.289  36.937   3.304  1.00 13.39           N
ATOM    137  CA  LEU    17     -30.999  38.157   2.904  1.00 13.60           C
ATOM    138  CB  LEU    17     -30.022  39.257   2.439  1.00 13.92           C
ATOM    139  CG  LEU    17     -29.168  39.859   3.564  1.00 15.45           C
ATOM    140  CD1 LEU    17     -28.242  40.964   3.019  1.00 18.76           C
ATOM    141  CD2 LEU    17     -30.008  40.355   4.753  1.00 18.21           C
ATOM    142  C   LEU    17     -32.079  37.907   1.841  1.00 13.42           C
ATOM    143  O   LEU    17     -33.201  38.400   2.004  1.00 13.35           O
ATOM    144  N   PHE    18     -31.772  37.132   0.800  1.00 12.52           N
ATOM    145  CA  PHE    18     -32.789  36.767  -0.188  1.00 12.55           C
ATOM    146  CB  PHE    18     -32.168  36.032  -1.355  1.00 12.74           C
ATOM    147  CG  PHE    18     -31.341  36.895  -2.267  1.00 11.67           C
ATOM    148  CD1 PHE    18     -31.865  38.079  -2.813  1.00 12.22           C
ATOM    149  CE1 PHE    18     -31.138  38.864  -3.706  1.00 12.93           C
ATOM    150  CZ  PHE    18     -29.843  38.455  -4.104  1.00 13.62           C
ATOM    151  CE2 PHE    18     -29.308  37.240  -3.582  1.00 11.19           C
ATOM    152  CD2 PHE    18     -30.083  36.472  -2.677  1.00 11.90           C
ATOM    153  C   PHE    18     -33.889  35.866   0.419  1.00 13.51           C
ATOM    154  O   PHE    18     -35.054  35.962   0.015  1.00 15.25           O
ATOM    155  N   ALA    19     -33.532  34.996   1.373  1.00 13.39           N
ATOM    156  CA  ALA    19     -34.553  34.208   2.061  1.00 15.05           C
ATOM    157  CB  ALA    19     -33.942  33.133   2.992  1.00 14.27           C
ATOM    158  C   ALA    19     -35.536  35.094   2.817  1.00 15.36           C
ATOM    159  O   ALA    19     -36.754  34.842   2.737  1.00 16.78           O
ATOM    160  N   GLN    20     -35.009  36.097   3.541  0.70 16.27           N
ATOM    162  CA  GLN    20     -35.806  37.053   4.335  0.70 16.80           C
ATOM    164  CB  GLN    20     -34.946  37.989   5.239  0.70 17.01           C
ATOM    166  CG  GLN    20     -35.745  39.306   5.640  0.70 16.81           C
ATOM    168  CD  GLN    20     -35.206  40.143   6.812  0.70 17.74           C
ATOM    170  OE1 GLN    20     -35.154  41.393   6.736  0.70 13.85           O
ATOM    172  NE2 GLN    20     -34.830  39.472   7.903  0.70 18.70           N
ATOM    174  C   GLN    20     -36.691  37.941   3.482  0.70 17.07           C
ATOM    176  O   GLN    20     -37.900  38.009   3.701  0.70 17.23           O
ATOM    178  N   LYS    21     -36.060  38.636   2.537  1.00 15.44           N
ATOM    179  CA  LYS    21     -36.656  39.778   1.820  1.00 16.20           C
ATOM    180  CB  LYS    21     -35.693  40.954   1.797  1.00 16.65           C
ATOM    181  CG  LYS    21     -35.259  41.391   3.184  1.00 19.64           C
ATOM    182  CD  LYS    21     -34.363  42.583   3.043  1.00 22.59           C
ATOM    183  CE  LYS    21     -33.720  42.901   4.359  1.00 25.71           C
ATOM    184  NZ  LYS    21     -33.292  44.316   4.378  1.00 29.79           N
ATOM    185  C   LYS    21     -37.021  39.482   0.389  1.00 15.03           C
ATOM    186  O   LYS    21     -37.639  40.317  -0.275  1.00 16.30           O
ATOM    187  N   GLY    22     -36.632  38.313  -0.101  1.00 14.81           N
ATOM    188  CA  GLY    22     -36.879  37.954  -1.501  1.00 12.41           C
ATOM    189  C   GLY    22     -35.967  38.743  -2.431  1.00 13.23           C
ATOM    190  O   GLY    22     -35.355  39.762  -2.034  1.00 13.65           O
ATOM    191  N   PHE    23     -35.857  38.255  -3.660  1.00 12.90           N
ATOM    192  CA  PHE    23     -35.064  38.952  -4.675  1.00 13.24           C
ATOM    193  CB  PHE    23     -35.255  38.297  -6.043  1.00 15.31           C
ATOM    194  CG  PHE    23     -34.544  39.016  -7.130  1.00 16.26           C
ATOM    195  CD1 PHE    23     -33.214  38.729  -7.414  1.00 17.28           C
ATOM    196  CE1 PHE    23     -32.528  39.446  -8.406  1.00 17.88           C
ATOM    197  CZ  PHE    23     -33.173  40.390  -9.137  1.00 18.69           C
ATOM    198  CE2 PHE    23     -34.531  40.677  -8.884  1.00 18.23           C
ATOM    199  CD2 PHE    23     -35.193  40.000  -7.883  1.00 18.32           C
ATOM    200  C   PHE    23     -35.468  40.425  -4.758  1.00 14.16           C
ATOM    201  O   PHE    23     -34.604  41.312  -4.880  1.00 14.45           O
ATOM    202  N   TYR    24     -36.778  40.690  -4.743  1.00 14.52           N
ATOM    203  CA  TYR    24     -37.263  42.057  -4.998  1.00 15.59           C
ATOM    204  CB  TYR    24     -38.733  42.085  -5.422  1.00 13.51           C
ATOM    205  CG  TYR    24     -38.963  41.406  -6.781  1.00 13.47           C
ATOM    206  CD1 TYR    24     -38.665  42.064  -7.967  1.00 12.55           C
ATOM    207  CE1 TYR    24     -38.890  41.458  -9.241  1.00 13.28           C
ATOM    208  CZ  TYR    24     -39.399  40.139  -9.303  1.00 10.43           C
ATOM    209  OH  TYR    24     -39.630  39.577 -10.572  1.00 11.31           O
ATOM    210  CE2 TYR    24     -39.713  39.475  -8.126  1.00 11.68           C
ATOM    211  CD2 TYR    24     -39.493  40.106  -6.858  1.00 14.21           C
ATOM    212  C   TYR    24     -37.080  42.970  -3.806  1.00 16.80           C
ATOM    213  O   TYR    24     -37.286  44.167  -3.939  1.00 18.89           O
ATOM    214  N   GLY    25     -36.702  42.429  -2.656  1.00 16.86           N
ATOM    215  CA  GLY    25     -36.488  43.287  -1.478  1.00 17.30           C
ATOM    216  C   GLY    25     -35.036  43.519  -1.070  1.00 18.19           C
ATOM    217  O   GLY    25     -34.787  44.141  -0.042  1.00 18.97           O
ATOM    218  N   VAL    26     -34.080  42.983  -1.822  1.00 17.80           N
ATOM    219  CA  VAL    26     -32.653  43.017  -1.434  1.00 17.86           C
ATOM    220  CB  VAL    26     -32.053  41.567  -1.526  1.00 16.88           C
ATOM    221  CG1 VAL    26     -30.493  41.578  -1.523  1.00 19.19           C
ATOM    222  CG2 VAL    26     -32.546  40.691  -0.382  1.00 17.09           C
ATOM    223  C   VAL    26     -31.896  43.951  -2.405  1.00 18.57           C
ATOM    224  O   VAL    26     -32.112  43.860  -3.619  1.00 19.26           O
ATOM    225  N   SER    27     -31.024  44.837  -1.900  1.00 18.29           N
ATOM    226  CA  SER    27     -30.188  45.651  -2.802  1.00 18.73           C
ATOM    227  CB  SER    27     -30.240  47.135  -2.451  1.00 18.20           C
ATOM    228  OG  SER    27     -29.499  47.385  -1.297  1.00 19.53           O
ATOM    229  C   SER    27     -28.743  45.196  -2.781  1.00 18.39           C
ATOM    230  O   SER    27     -28.296  44.592  -1.823  1.00 18.07           O
ATOM    231  N   ILE    28     -28.001  45.507  -3.836  1.00 18.31           N
ATOM    232  CA  ILE    28     -26.587  45.151  -3.866  1.00 18.54           C
ATOM    233  CB  ILE    28     -25.953  45.425  -5.232  1.00 18.62           C
ATOM    234  CG1 ILE    28     -24.599  44.703  -5.348  1.00 18.14           C
ATOM    235  CD1 ILE    28     -23.953  44.785  -6.743  1.00 19.13           C
ATOM    236  CG2 ILE    28     -25.915  46.963  -5.537  1.00 18.10           C
ATOM    237  C   ILE    28     -25.825  45.846  -2.714  1.00 18.97           C
ATOM    238  O   ILE    28     -24.902  45.274  -2.156  1.00 17.66           O
ATOM    239  N   ARG    29     -26.211  47.076  -2.360  1.00 19.97           N
ATOM    240  CA  ARG    29     -25.589  47.737  -1.207  1.00 22.13           C
ATOM    241  CB  ARG    29     -26.120  49.174  -1.012  1.00 21.53           C
ATOM    242  CG  ARG    29     -25.467  49.925   0.170  1.00 25.16           C
ATOM    243  CD  ARG    29     -26.316  51.109   0.743  1.00 26.22           C
ATOM    244  NE  ARG    29     -27.682  50.707   1.142  1.00 35.15           N
ATOM    245  CZ  ARG    29     -28.010  50.032   2.256  1.00 36.75           C
ATOM    246  NH1 ARG    29     -27.084  49.650   3.137  1.00 38.29           N
ATOM    247  NH2 ARG    29     -29.285  49.730   2.492  1.00 38.04           N
ATOM    248  C   ARG    29     -25.725  46.902   0.085  1.00 21.09           C
ATOM    249  O   ARG    29     -24.730  46.691   0.798  1.00 19.92           O
ATOM    250  N   GLU    30     -26.937  46.412   0.371  1.00 22.16           N
ATOM    251  CA  GLU    30     -27.160  45.541   1.551  1.00 22.56           C
ATOM    252  CB  GLU    30     -28.618  45.119   1.693  1.00 23.46           C
ATOM    253  CG  GLU    30     -29.623  46.242   1.841  1.00 28.08           C
ATOM    254  CD  GLU    30     -31.046  45.786   1.483  1.00 34.28           C
ATOM    255  OE1 GLU    30     -31.275  44.555   1.368  1.00 33.74           O
ATOM    256  OE2 GLU    30     -31.935  46.662   1.307  1.00 37.15           O
ATOM    257  C   GLU    30     -26.301  44.272   1.533  1.00 21.44           C
ATOM    258  O   GLU    30     -25.795  43.856   2.577  1.00 21.23           O
ATOM    259  N   LEU    31     -26.170  43.640   0.359  1.00 19.98           N
ATOM    260  CA  LEU    31     -25.338  42.431   0.251  1.00 18.96           C
ATOM    261  CB  LEU    31     -25.426  41.823  -1.145  1.00 18.00           C
ATOM    262  CG  LEU    31     -26.768  41.239  -1.562  1.00 18.12           C
ATOM    263  CD1 LEU    31     -26.678  40.931  -3.057  1.00 16.01           C
ATOM    264  CD2 LEU    31     -27.078  39.993  -0.744  1.00 18.33           C
ATOM    265  C   LEU    31     -23.871  42.715   0.588  1.00 18.24           C
ATOM    266  O   LEU    31     -23.227  41.984   1.363  1.00 18.55           O
ATOM    267  N   ALA    32     -23.328  43.776  -0.005  1.00 18.07           N
ATOM    268  CA  ALA    32     -21.928  44.131   0.234  1.00 17.87           C
ATOM    269  CB  ALA    32     -21.533  45.282  -0.659  1.00 17.05           C
ATOM    270  C   ALA    32     -21.689  44.449   1.719  1.00 18.48           C
ATOM    271  O   ALA    32     -20.741  43.938   2.338  1.00 18.50           O
ATOM    272  N   GLN    33     -22.577  45.264   2.282  1.00 18.14           N
ATOM    273  CA  GLN    33     -22.467  45.687   3.672  1.00 18.66           C
ATOM    274  CB  GLN    33     -23.613  46.652   4.012  1.00 18.81           C
ATOM    279  C   GLN    33     -22.496  44.452   4.579  1.00 18.25           C
ATOM    280  O   GLN    33     -21.649  44.307   5.470  1.00 19.06           O
ATOM    281  N   ALA    34     -23.456  43.552   4.355  1.00 18.35           N
ATOM    282  CA  ALA    34     -23.588  42.387   5.224  1.00 17.57           C
ATOM    283  CB  ALA    34     -24.915  41.670   4.988  1.00 18.88           C
ATOM    284  C   ALA    34     -22.400  41.424   5.094  1.00 17.93           C
ATOM    285  O   ALA    34     -22.007  40.800   6.073  1.00 18.07           O
ATOM    286  N   ALA    35     -21.812  41.324   3.902  1.00 17.59           N
ATOM    287  CA  ALA    35     -20.653  40.434   3.662  1.00 17.45           C
ATOM    288  CB  ALA    35     -20.742  39.832   2.241  1.00 17.60           C
ATOM    289  C   ALA    35     -19.271  41.084   3.858  1.00 17.39           C
ATOM    290  O   ALA    35     -18.253  40.386   3.869  1.00 17.10           O
ATOM    291  N   GLY    36     -19.216  42.410   3.975  1.00 17.53           N
ATOM    292  CA  GLY    36     -17.934  43.120   4.053  1.00 17.54           C
ATOM    293  C   GLY    36     -17.142  43.046   2.755  1.00 18.20           C
ATOM    294  O   GLY    36     -15.894  43.109   2.760  1.00 18.83           O
ATOM    295  N   ALA    37     -17.868  42.917   1.638  1.00 18.05           N
ATOM    296  CA  ALA    37     -17.298  42.947   0.287  1.00 17.70           C
ATOM    297  CB  ALA    37     -17.905  41.813  -0.553  1.00 17.69           C
ATOM    298  C   ALA    37     -17.594  44.299  -0.377  1.00 17.25           C
ATOM    299  O   ALA    37     -18.512  44.995   0.029  1.00 17.90           O
ATOM    300  N   SER    38     -16.844  44.680  -1.401  1.00 16.01           N
ATOM    301  CA  SER    38     -17.181  45.941  -2.083  1.00 15.66           C
ATOM    302  CB  SER    38     -15.986  46.530  -2.815  1.00 15.99           C
ATOM    303  OG  SER    38     -15.465  45.574  -3.709  1.00 15.63           O
ATOM    304  C   SER    38     -18.275  45.670  -3.090  1.00 15.23           C
ATOM    305  O   SER    38     -18.390  44.545  -3.568  1.00 14.69           O
ATOM    306  N   ILE    39     -19.054  46.696  -3.426  1.00 14.99           N
ATOM    307  CA  ILE    39     -20.019  46.586  -4.524  1.00 16.34           C
ATOM    308  CB  ILE    39     -20.795  47.908  -4.725  1.00 18.03           C
ATOM    309  CG1 ILE    39     -21.771  48.099  -3.551  1.00 18.95           C
ATOM    310  CD1 ILE    39     -22.260  49.551  -3.403  1.00 24.07           C
ATOM    311  CG2 ILE    39     -21.568  47.905  -6.053  1.00 19.22           C
ATOM    312  C   ILE    39     -19.321  46.142  -5.820  1.00 14.71           C
ATOM    313  O   ILE    39     -19.846  45.293  -6.544  1.00 14.07           O
ATOM    314  N   SER    40     -18.089  46.604  -6.010  0.50 14.67           N
ATOM    316  CA  SER    40     -17.279  46.176  -7.148  0.50 14.62           C
ATOM    318  CB  SER    40     -16.053  47.060  -7.335  0.50 14.94           C
ATOM    320  OG  SER    40     -16.458  48.367  -7.690  0.50 15.23           O
ATOM    322  C   SER    40     -16.894  44.691  -7.144  0.50 14.74           C
ATOM    324  O   SER    40     -17.018  44.048  -8.190  0.50 13.11           O
ATOM    326  N   MET    41     -16.429  44.140  -6.011  0.70 14.50           N
ATOM    328  CA  MET    41     -16.178  42.699  -5.979  0.70 17.69           C
ATOM    330  CB  MET    41     -15.783  42.221  -4.589  0.70 17.10           C
ATOM    332  CG  MET    41     -14.312  42.342  -4.347  0.70 22.14           C
ATOM    334  SD  MET    41     -13.942  42.349  -2.431  0.70 31.19          SE
ATOM    336  CE  MET    41     -12.415  43.576  -2.469  0.70 24.49           C
ATOM    338  C   MET    41     -17.447  41.995  -6.467  0.70 13.85           C
ATOM    340  O   MET    41     -17.391  41.116  -7.335  0.70 12.19           O
ATOM    342  N   ILE    42     -18.586  42.445  -5.946  1.00 11.54           N
ATOM    343  CA  ILE    42     -19.860  41.745  -6.191  1.00 10.80           C
ATOM    344  CB  ILE    42     -21.001  42.280  -5.316  1.00 11.27           C
ATOM    345  CG1 ILE    42     -20.695  41.978  -3.842  1.00 13.93           C
ATOM    346  CD1 ILE    42     -21.839  42.300  -2.903  1.00 16.88           C
ATOM    347  CG2 ILE    42     -22.327  41.616  -5.716  1.00 12.87           C
ATOM    348  C   ILE    42     -20.219  41.838  -7.658  1.00  8.83           C
ATOM    349  O   ILE    42     -20.497  40.819  -8.306  1.00  9.33           O
ATOM    350  N   SER    43     -20.157  43.052  -8.211  1.00  8.95           N
ATOM    351  CA  SER    43     -20.581  43.239  -9.602  1.00  9.74           C
ATOM    352  CB  SER    43     -20.655  44.729  -9.931  1.00 10.68           C
ATOM    353  OG  SER    43     -21.770  45.278  -9.279  1.00 13.08           O
ATOM    354  C   SER    43     -19.645  42.587 -10.619  1.00  9.62           C
ATOM    355  O   SER    43     -20.105  42.053 -11.624  1.00  9.13           O
ATOM    356  N   TYR    44     -18.328  42.697 -10.382  1.00  9.20           N
ATOM    357  CA  TYR    44     -17.361  42.244 -11.376  1.00 10.08           C
ATOM    358  CB  TYR    44     -16.121  43.137 -11.344  1.00  9.76           C
ATOM    359  CG  TYR    44     -16.373  44.487 -11.942  1.00  8.65           C
ATOM    360  CD1 TYR    44     -16.965  45.500 -11.184  1.00  8.93           C
ATOM    361  CE1 TYR    44     -17.202  46.730 -11.711  1.00 10.45           C
ATOM    362  CZ  TYR    44     -16.853  46.987 -13.027  1.00 10.79           C
ATOM    363  OH  TYR    44     -17.090  48.220 -13.553  1.00 11.57           O
ATOM    364  CE2 TYR    44     -16.260  46.002 -13.818  1.00 10.86           C
ATOM    365  CD2 TYR    44     -16.019  44.758 -13.255  1.00  9.35           C
ATOM    366  C   TYR    44     -16.923  40.795 -11.222  1.00 12.28           C
ATOM    367  O   TYR    44     -16.468  40.193 -12.203  1.00 12.21           O
ATOM    368  N   HIS    45     -16.993  40.271 -10.000  1.00 14.53           N
ATOM    369  CA  HIS    45     -16.489  38.928  -9.730  1.00 17.90           C
ATOM    370  CB  HIS    45     -15.347  38.951  -8.714  1.00 18.81           C
ATOM    371  CG  HIS    45     -14.062  39.424  -9.294  1.00 21.69           C
ATOM    372  ND1 HIS    45     -13.118  40.111  -8.564  1.00 26.38           N
ATOM    373  CE1 HIS    45     -12.092  40.405  -9.346  1.00 27.60           C
ATOM    374  NE2 HIS    45     -12.350  39.958 -10.563  1.00 26.67           N
ATOM    375  CD2 HIS    45     -13.574  39.339 -10.558  1.00 25.29           C
ATOM    376  C   HIS    45     -17.532  37.898  -9.348  1.00 19.42           C
ATOM    377  O   HIS    45     -17.334  36.722  -9.630  1.00 19.75           O
ATOM    378  N   PHE    46     -18.630  38.324  -8.726  1.00 20.52           N
ATOM    379  CA  PHE    46     -19.661  37.377  -8.261  1.00 22.82           C
ATOM    380  CB  PHE    46     -19.800  37.465  -6.732  1.00 23.98           C
ATOM    381  CG  PHE    46     -18.496  37.308  -6.003  1.00 26.04           C
ATOM    382  CD1 PHE    46     -18.012  36.039  -5.670  1.00 29.01           C
ATOM    383  CE1 PHE    46     -16.817  35.893  -5.005  1.00 27.12           C
ATOM    384  CZ  PHE    46     -16.071  37.013  -4.649  1.00 28.27           C
ATOM    385  CE2 PHE    46     -16.542  38.280  -4.963  1.00 29.34           C
ATOM    386  CD2 PHE    46     -17.743  38.419  -5.640  1.00 27.17           C
ATOM    387  C   PHE    46     -21.004  37.504  -8.954  1.00 22.70           C
ATOM    388  O   PHE    46     -22.017  36.978  -8.483  1.00 25.73           O
ATOM    389  N   GLY    47     -21.020  38.197 -10.083  1.00 20.71           N
ATOM    390  CA  GLY    47     -22.178  38.260 -10.943  1.00 19.73           C
ATOM    391  C   GLY    47     -23.257  39.227 -10.550  1.00 18.52           C
ATOM    392  O   GLY    47     -24.373  39.148 -11.073  1.00 20.99           O
ATOM    393  N   GLY    48     -22.955  40.137  -9.620  1.00 14.66           N
ATOM    394  CA  GLY    48     -23.926  41.115  -9.145  1.00 14.41           C
ATOM    395  C   GLY    48     -25.035  40.479  -8.295  1.00 13.29           C
ATOM    396  O   GLY    48     -24.959  39.296  -7.948  1.00 12.06           O
ATOM    397  N   LYS    49     -26.021  41.290  -7.929  1.00 13.51           N
ATOM    398  CA  LYS    49     -27.206  40.794  -7.200  1.00 13.00           C
ATOM    399  CB  LYS    49     -28.212  41.934  -7.086  1.00 14.01           C
ATOM    400  CG  LYS    49     -29.503  41.518  -6.350  1.00 15.37           C
ATOM    401  CD  LYS    49     -30.528  42.649  -6.447  1.00 16.73           C
ATOM    402  CE  LYS    49     -31.905  42.078  -6.083  1.00 17.71           C
ATOM    403  NZ  LYS    49     -32.895  43.218  -6.101  1.00 18.77           N
ATOM    404  C   LYS    49     -27.809  39.595  -7.932  1.00 13.68           C
ATOM    405  O   LYS    49     -28.212  38.583  -7.331  1.00 13.27           O
ATOM    406  N   GLU    50     -27.876  39.703  -9.258  1.00 12.63           N
ATOM    407  CA  GLU    50     -28.627  38.725 -10.042  1.00 12.69           C
ATOM    408  CB  GLU    50     -28.814  39.232 -11.468  1.00 13.68           C
ATOM    409  CG  GLU    50     -29.657  40.500 -11.528  1.00 14.16           C
ATOM    410  CD  GLU    50     -28.887  41.815 -11.286  1.00 16.98           C
ATOM    411  OE1 GLU    50     -27.638  41.867 -11.018  1.00 15.01           O
ATOM    412  OE2 GLU    50     -29.566  42.854 -11.451  1.00 19.39           O
ATOM    413  C   GLU    50     -27.883  37.393 -10.048  1.00 12.35           C
ATOM    414  O   GLU    50     -28.506  36.350  -9.816  1.00 13.25           O
ATOM    415  N   GLY    51     -26.567  37.455 -10.306  1.00 11.97           N
ATOM    416  CA  GLY    51     -25.695  36.286 -10.303  1.00 11.39           C
ATOM    417  C   GLY    51     -25.724  35.592  -8.952  1.00 13.31           C
ATOM    418  O   GLY    51     -25.865  34.369  -8.874  1.00 12.68           O
ATOM    419  N   LEU    52     -25.637  36.365  -7.877  1.00 12.96           N
ATOM    420  CA  LEU    52     -25.702  35.752  -6.544  1.00 13.84           C
ATOM    421  CB  LEU    52     -25.453  36.774  -5.450  1.00 13.00           C
ATOM    422  CG  LEU    52     -24.017  37.257  -5.300  1.00 15.32           C
ATOM    423  CD1 LEU    52     -24.026  38.415  -4.321  1.00 17.15           C
ATOM    424  CD2 LEU    52     -23.089  36.110  -4.862  1.00 13.25           C
ATOM    425  C   LEU    52     -27.047  35.092  -6.282  1.00 13.75           C
ATOM    426  O   LEU    52     -27.092  34.016  -5.680  1.00 14.21           O
ATOM    427  N   TYR    53     -28.140  35.744  -6.693  1.00 14.29           N
ATOM    428  CA  TYR    53     -29.441  35.176  -6.517  1.00 14.44           C
ATOM    429  CB  TYR    53     -30.541  36.161  -6.936  1.00 12.90           C
ATOM    430  CG  TYR    53     -31.928  35.606  -6.681  1.00 13.47           C
ATOM    431  CD1 TYR    53     -32.405  35.437  -5.365  1.00 13.59           C
ATOM    432  CE1 TYR    53     -33.679  34.910  -5.123  1.00 14.34           C
ATOM    433  CZ  TYR    53     -34.477  34.537  -6.198  1.00 13.72           C
ATOM    434  OH  TYR    53     -35.718  34.039  -5.965  1.00 13.83           O
ATOM    435  CE2 TYR    53     -34.023  34.711  -7.525  1.00 13.18           C
ATOM    436  CD2 TYR    53     -32.751  35.220  -7.740  1.00 11.75           C
ATOM    437  C   TYR    53     -29.578  33.863  -7.306  1.00 14.35           C
ATOM    438  O   TYR    53     -30.064  32.892  -6.754  1.00 14.84           O
ATOM    439  N   ALA    54     -29.125  33.849  -8.569  1.00 14.57           N
ATOM    440  CA  ALA    54     -29.145  32.612  -9.394  1.00 14.76           C
ATOM    441  CB  ALA    54     -28.572  32.882 -10.785  1.00 15.38           C
ATOM    442  C   ALA    54     -28.382  31.465  -8.737  1.00 16.02           C
ATOM    443  O   ALA    54     -28.853  30.302  -8.752  1.00 16.58           O
ATOM    444  N   ALA    55     -27.206  31.790  -8.179  1.00 15.71           N
ATOM    445  CA  ALA    55     -26.349  30.797  -7.512  1.00 16.60           C
ATOM    446  CB  ALA    55     -24.985  31.418  -7.114  1.00 15.94           C
ATOM    447  C   ALA    55     -27.087  30.239  -6.293  1.00 16.62           C
ATOM    448  O   ALA    55     -27.124  29.027  -6.079  1.00 17.79           O
ATOM    449  N   VAL    56     -27.698  31.121  -5.509  1.00 16.55           N
ATOM    450  CA  VAL    56     -28.442  30.724  -4.309  1.00 17.16           C
ATOM    451  CB  VAL    56     -28.958  31.984  -3.551  1.00 17.77           C
ATOM    452  CG1 VAL    56     -30.068  31.623  -2.591  1.00 18.51           C
ATOM    453  CG2 VAL    56     -27.808  32.716  -2.799  1.00 16.47           C
ATOM    454  C   VAL    56     -29.643  29.805  -4.680  1.00 17.90           C
ATOM    455  O   VAL    56     -29.872  28.769  -4.064  1.00 18.42           O
ATOM    456  N   LEU    57     -30.409  30.209  -5.690  1.00 18.83           N
ATOM    457  CA  LEU    57     -31.588  29.428  -6.064  1.00 20.44           C
ATOM    458  CB  LEU    57     -32.429  30.224  -7.058  1.00 19.98           C
ATOM    459  CG  LEU    57     -33.922  29.962  -7.106  1.00 25.44           C
ATOM    460  CD1 LEU    57     -34.592  30.145  -5.755  1.00 24.83           C
ATOM    461  CD2 LEU    57     -34.480  30.939  -8.118  1.00 27.85           C
ATOM    462  C   LEU    57     -31.165  28.050  -6.627  1.00 20.90           C
ATOM    463  O   LEU    57     -31.808  27.031  -6.345  1.00 20.75           O
ATOM    464  N   GLN    58     -30.052  28.016  -7.360  1.00 21.09           N
ATOM    465  CA  GLN    58     -29.551  26.768  -7.929  1.00 22.36           C
ATOM    466  CB  GLN    58     -28.346  26.998  -8.858  1.00 23.54           C
ATOM    467  CG  GLN    58     -27.960  25.733  -9.635  1.00 27.99           C
ATOM    468  CD  GLN    58     -29.191  25.021 -10.220  1.00 35.26           C
ATOM    469  OE1 GLN    58     -29.888  25.570 -11.083  1.00 37.09           O
ATOM    470  NE2 GLN    58     -29.469  23.796  -9.736  1.00 38.37           N
ATOM    471  C   GLN    58     -29.205  25.793  -6.803  1.00 22.27           C
ATOM    472  O   GLN    58     -29.522  24.575  -6.887  1.00 22.87           O
ATOM    473  N   GLU    59     -28.579  26.306  -5.741  0.50 21.38           N
ATOM    475  CA  GLU    59     -28.271  25.503  -4.553  0.50 21.43           C
ATOM    477  CB  GLU    59     -27.388  26.269  -3.553  0.50 21.44           C
ATOM    479  CG  GLU    59     -26.869  25.393  -2.378  0.50 21.69           C
ATOM    481  CD  GLU    59     -26.114  26.171  -1.293  0.50 22.85           C
ATOM    483  OE1 GLU    59     -25.921  27.400  -1.427  0.50 25.49           O
ATOM    485  OE2 GLU    59     -25.705  25.539  -0.292  0.50 22.88           O
ATOM    487  C   GLU    59     -29.535  25.040  -3.848  0.50 20.81           C
ATOM    489  O   GLU    59     -29.586  23.907  -3.359  0.50 20.84           O
ATOM    491  N   GLN    60     -30.526  25.927  -3.763  1.00 20.01           N
ATOM    492  CA  GLN    60     -31.823  25.588  -3.146  1.00 20.01           C
ATOM    493  CB  GLN    60     -32.751  26.812  -3.069  1.00 18.91           C
ATOM    494  CG  GLN    60     -32.254  27.942  -2.169  1.00 22.57           C
ATOM    495  CD  GLN    60     -32.132  27.523  -0.695  1.00 23.52           C
ATOM    496  OE1 GLN    60     -33.063  26.939  -0.124  1.00 25.17           O
ATOM    497  NE2 GLN    60     -30.987  27.798  -0.090  1.00 23.26           N
ATOM    498  C   GLN    60     -32.527  24.444  -3.865  1.00 18.38           C
ATOM    499  O   GLN    60     -33.135  23.578  -3.222  1.00 19.77           O
ATOM    500  N   PHE    61     -32.428  24.422  -5.192  1.00 18.84           N
ATOM    501  CA  PHE    61     -33.171  23.452  -5.980  1.00 18.05           C
ATOM    502  CB  PHE    61     -33.920  24.171  -7.089  1.00 18.50           C
ATOM    503  CG  PHE    61     -35.166  24.855  -6.603  1.00 16.29           C
ATOM    504  CD1 PHE    61     -35.097  26.142  -6.066  1.00 16.96           C
ATOM    505  CE1 PHE    61     -36.246  26.777  -5.586  1.00 17.57           C
ATOM    506  CZ  PHE    61     -37.469  26.128  -5.639  1.00 16.05           C
ATOM    507  CE2 PHE    61     -37.562  24.840  -6.149  1.00 16.94           C
ATOM    508  CD2 PHE    61     -36.415  24.206  -6.655  1.00 16.84           C
ATOM    509  C   PHE    61     -32.316  22.293  -6.529  1.00 18.86           C
ATOM    510  O   PHE    61     -32.799  21.474  -7.288  1.00 17.68           O
ATOM    511  N   ALA    62     -31.039  22.250  -6.153  1.00 19.75           N
ATOM    512  CA  ALA    62     -30.116  21.245  -6.684  1.00 20.70           C
ATOM    513  CB  ALA    62     -28.776  21.377  -5.988  1.00 21.27           C
ATOM    514  C   ALA    62     -30.639  19.784  -6.602  1.00 21.89           C
ATOM    515  O   ALA    62     -30.568  19.023  -7.588  1.00 22.43           O
ATOM    516  N   CYS    63     -31.180  19.433  -5.431  0.50 22.09           N
ATOM    518  CA  CYS    63     -31.713  18.088  -5.137  0.50 22.45           C
ATOM    520  CB  CYS    63     -32.194  18.002  -3.682  0.50 21.93           C
ATOM    522  SG  CYS    63     -30.917  17.628  -2.464  0.50 27.26           S
ATOM    524  C   CYS    63     -32.836  17.625  -6.072  0.50 21.59           C
ATOM    526  O   CYS    63     -33.089  16.419  -6.196  0.50 20.76           O
ATOM    528  N   PHE    64     -33.520  18.570  -6.711  1.00 20.75           N
ATOM    529  CA  PHE    64     -34.567  18.235  -7.659  1.00 20.96           C
ATOM    530  CB  PHE    64     -35.405  19.451  -8.035  1.00 19.37           C
ATOM    531  CG  PHE    64     -36.415  19.870  -6.996  1.00 19.26           C
ATOM    532  CD1 PHE    64     -36.028  20.573  -5.872  1.00 19.73           C
ATOM    533  CE1 PHE    64     -36.994  21.017  -4.934  1.00 18.87           C
ATOM    534  CZ  PHE    64     -38.331  20.739  -5.155  1.00 17.71           C
ATOM    535  CE2 PHE    64     -38.722  20.056  -6.260  1.00 18.01           C
ATOM    536  CD2 PHE    64     -37.778  19.643  -7.202  1.00 18.03           C
ATOM    537  C   PHE    64     -34.008  17.587  -8.957  1.00 21.96           C
ATOM    538  O   PHE    64     -34.743  16.934  -9.688  1.00 23.37           O
ATOM    539  N   GLY    65     -32.716  17.728  -9.209  1.00 22.10           N
ATOM    540  CA  GLY    65     -32.106  17.074 -10.371  1.00 23.22           C
ATOM    541  C   GLY    65     -31.577  15.697 -10.034  1.00 24.11           C
ATOM    542  O   GLY    65     -30.930  15.040 -10.873  1.00 24.63           O
ATOM    543  N   GLN    66     -31.841  15.266  -8.802  1.00 24.05           N
ATOM    544  CA  GLN    66     -31.357  13.993  -8.283  1.00 24.54           C
ATOM    545  CB  GLN    66     -30.285  14.241  -7.234  1.00 25.47           C
ATOM    546  CG  GLN    66     -28.910  14.511  -7.854  1.00 30.42           C
ATOM    547  CD  GLN    66     -28.001  15.342  -6.962  1.00 36.44           C
ATOM    548  OE1 GLN    66     -28.382  16.421  -6.479  1.00 39.74           O
ATOM    549  NE2 GLN    66     -26.784  14.859  -6.761  1.00 37.88           N
ATOM    550  C   GLN    66     -32.519  13.185  -7.688  1.00 23.92           C
ATOM    551  O   GLN    66     -32.671  13.075  -6.467  1.00 23.62           O
ATOM    552  N   LEU    67     -33.319  12.616  -8.579  1.00 22.78           N
ATOM    553  CA  LEU    67     -34.545  11.916  -8.200  1.00 21.55           C
ATOM    554  CB  LEU    67     -35.668  12.370  -9.128  1.00 21.58           C
ATOM    555  CG  LEU    67     -35.860  13.887  -9.236  1.00 21.33           C
ATOM    556  CD1 LEU    67     -36.995  14.155 -10.180  1.00 22.06           C
ATOM    557  CD2 LEU    67     -36.147  14.475  -7.858  1.00 21.71           C
ATOM    558  C   LEU    67     -34.455  10.391  -8.219  1.00 21.26           C
ATOM    559  O   LEU    67     -35.485   9.730  -8.205  1.00 20.77           O
ATOM    560  N   ASP    68     -33.243   9.827  -8.209  1.00 20.58           N
ATOM    561  CA  ASP    68     -33.066   8.375  -8.336  1.00 21.06           C
ATOM    562  CB  ASP    68     -31.588   8.003  -8.545  1.00 22.43           C
ATOM    563  CG  ASP    68     -31.143   8.118 -10.019  1.00 25.47           C
ATOM    564  OD1 ASP    68     -32.015   8.221 -10.922  1.00 30.33           O
ATOM    565  OD2 ASP    68     -29.915   8.103 -10.278  1.00 28.49           O
ATOM    566  C   ASP    68     -33.707   7.551  -7.191  1.00 21.11           C
ATOM    567  O   ASP    68     -34.136   6.420  -7.409  1.00 20.72           O
ATOM    568  N   ASP    69     -33.790   8.106  -5.981  1.00 20.70           N
ATOM    569  CA  ASP    69     -34.499   7.393  -4.890  1.00 21.27           C
ATOM    570  CB  ASP    69     -34.371   8.149  -3.562  1.00 22.13           C
ATOM    571  CG  ASP    69     -32.986   8.014  -2.948  1.00 24.48           C
ATOM    572  OD1 ASP    69     -32.312   6.996  -3.200  1.00 27.84           O
ATOM    573  OD2 ASP    69     -32.581   8.940  -2.220  1.00 28.42           O
ATOM    574  C   ASP    69     -35.988   7.188  -5.201  1.00 20.42           C
ATOM    575  O   ASP    69     -36.621   6.239  -4.725  1.00 20.59           O
ATOM    576  N   ILE    70     -36.539   8.100  -5.989  1.00 19.38           N
ATOM    577  CA  ILE    70     -37.928   7.992  -6.429  1.00 18.85           C
ATOM    578  CB  ILE    70     -38.556   9.366  -6.619  1.00 18.52           C
ATOM    579  CG1 ILE    70     -38.411  10.193  -5.323  1.00 21.19           C
ATOM    580  CD1 ILE    70     -38.809  11.665  -5.486  1.00 21.34           C
ATOM    581  CG2 ILE    70     -40.039   9.235  -6.997  1.00 19.97           C
ATOM    582  C   ILE    70     -38.014   7.194  -7.726  1.00 17.62           C
ATOM    583  O   ILE    70     -38.761   6.225  -7.804  1.00 18.07           O
ATOM    584  N   ARG    71     -37.271   7.614  -8.747  1.00 16.37           N
ATOM    585  CA  ARG    71     -37.312   6.918 -10.054  1.00 16.19           C
ATOM    586  CB  ARG    71     -36.314   7.527 -11.036  1.00 16.11           C
ATOM    587  CG  ARG    71     -36.578   8.965 -11.418  1.00 19.99           C
ATOM    588  CD  ARG    71     -35.754   9.340 -12.654  1.00 23.24           C
ATOM    589  NE  ARG    71     -35.827  10.770 -12.961  1.00 25.78           N
ATOM    590  CZ  ARG    71     -36.850  11.371 -13.583  1.00 28.05           C
ATOM    591  NH1 ARG    71     -37.910  10.665 -13.975  1.00 28.38           N
ATOM    592  NH2 ARG    71     -36.818  12.683 -13.821  1.00 22.66           N
ATOM    593  C   ARG    71     -36.981   5.449  -9.914  1.00 14.93           C
ATOM    594  O   ARG    71     -37.529   4.587 -10.637  1.00 13.88           O
ATOM    595  N   GLY    72     -36.074   5.141  -8.978  1.00 14.49           N
ATOM    596  CA  GLY    72     -35.604   3.763  -8.809  1.00 13.79           C
ATOM    597  C   GLY    72     -36.685   2.791  -8.352  1.00 14.28           C
ATOM    598  O   GLY    72     -36.498   1.596  -8.465  1.00 15.03           O
ATOM    599  N   GLN    73     -37.809   3.316  -7.844  1.00 13.08           N
ATOM    600  CA  GLN    73     -38.965   2.522  -7.381  1.00 13.26           C
ATOM    601  CB  GLN    73     -39.651   3.251  -6.211  1.00 13.37           C
ATOM    602  CG  GLN    73     -38.783   3.419  -4.979  1.00 16.75           C
ATOM    603  CD  GLN    73     -38.147   2.137  -4.546  1.00 21.82           C
ATOM    604  OE1 GLN    73     -38.813   1.105  -4.424  1.00 22.36           O
ATOM    605  NE2 GLN    73     -36.834   2.173  -4.334  1.00 26.08           N
ATOM    606  C   GLN    73     -40.037   2.290  -8.454  1.00 12.89           C
ATOM    607  O   GLN    73     -41.041   1.624  -8.204  1.00 12.88           O
ATOM    608  N   ALA    74     -39.844   2.871  -9.636  1.00 12.26           N
ATOM    609  CA  ALA    74     -40.800   2.693 -10.736  1.00 12.16           C
ATOM    610  CB  ALA    74     -40.216   3.279 -12.015  1.00 12.22           C
ATOM    611  C   ALA    74     -41.152   1.219 -10.951  1.00 12.26           C
ATOM    612  O   ALA    74     -40.261   0.342 -10.903  1.00 11.19           O
ATOM    613  N   GLY    75     -42.429   0.939 -11.235  1.00 11.65           N
ATOM    614  CA  GLY    75     -42.868  -0.466 -11.342  1.00 10.70           C
ATOM    615  C   GLY    75     -43.731  -0.790 -10.118  1.00 11.25           C
ATOM    616  O   GLY    75     -44.484  -1.762 -10.116  1.00 11.59           O
ATOM    617  N   ASP    76     -43.570  -0.008  -9.043  1.00 12.06           N
ATOM    618  CA  ASP    76     -44.360  -0.166  -7.824  1.00 12.36           C
ATOM    619  CB  ASP    76     -43.487  -0.827  -6.733  1.00 12.42           C
ATOM    620  CG  ASP    76     -44.202  -1.022  -5.400  1.00 15.66           C
ATOM    621  OD1 ASP    76     -45.317  -0.484  -5.151  1.00 16.24           O
ATOM    622  OD2 ASP    76     -43.604  -1.751  -4.566  1.00 15.57           O
ATOM    623  C   ASP    76     -44.849   1.223  -7.391  1.00 12.68           C
ATOM    624  O   ASP    76     -44.129   1.931  -6.685  1.00 11.41           O
ATOM    625  N   PRO    77     -46.043   1.647  -7.879  1.00 13.71           N
ATOM    626  CA  PRO    77     -46.488   3.033  -7.645  1.00 13.93           C
ATOM    627  CB  PRO    77     -47.873   3.103  -8.333  1.00 13.23           C
ATOM    628  CG  PRO    77     -47.761   2.072  -9.458  1.00 15.27           C
ATOM    629  CD  PRO    77     -46.977   0.920  -8.766  1.00 14.18           C
ATOM    630  C   PRO    77     -46.533   3.405  -6.182  1.00 13.31           C
ATOM    631  O   PRO    77     -46.184   4.524  -5.838  1.00 13.85           O
ATOM    632  N   LEU    78     -46.946   2.477  -5.319  0.50 13.21           N
ATOM    634  CA  LEU    78     -46.992   2.787  -3.889  0.50 13.74           C
ATOM    636  CB  LEU    78     -47.582   1.617  -3.103  0.50 13.51           C
ATOM    638  CG  LEU    78     -48.457   1.997  -1.907  0.50 14.73           C
ATOM    640  CD1 LEU    78     -49.147   0.741  -1.413  0.50 17.25           C
ATOM    642  CD2 LEU    78     -47.650   2.638  -0.804  0.50 19.04           C
ATOM    644  C   LEU    78     -45.602   3.124  -3.366  0.50 13.01           C
ATOM    646  O   LEU    78     -45.444   4.072  -2.614  0.50 12.86           O
ATOM    648  N   ALA    79     -44.598   2.339  -3.761  1.00 13.15           N
ATOM    649  CA  ALA    79     -43.203   2.602  -3.355  1.00 13.03           C
ATOM    650  CB  ALA    79     -42.284   1.481  -3.789  1.00 13.22           C
ATOM    651  C   ALA    79     -42.705   3.953  -3.901  1.00 12.54           C
ATOM    652  O   ALA    79     -41.949   4.654  -3.228  1.00 12.09           O
ATOM    653  N   VAL    80     -43.099   4.301  -5.131  1.00 11.58           N
ATOM    654  CA  VAL    80     -42.787   5.630  -5.672  1.00 12.21           C
ATOM    655  CB  VAL    80     -43.296   5.773  -7.101  1.00 11.22           C
ATOM    656  CG1 VAL    80     -43.163   7.227  -7.624  1.00 12.32           C
ATOM    657  CG2 VAL    80     -42.538   4.787  -8.035  1.00 10.84           C
ATOM    658  C   VAL    80     -43.376   6.760  -4.777  1.00 13.05           C
ATOM    659  O   VAL    80     -42.668   7.710  -4.420  1.00 13.23           O
ATOM    660  N   MET    81     -44.661   6.646  -4.436  0.70 12.38           N
ATOM    662  CA  MET    81     -45.330   7.668  -3.603  0.70 12.69           C
ATOM    664  CB  MET    81     -46.833   7.394  -3.427  0.70 13.82           C
ATOM    666  CG  MET    81     -47.597   7.155  -4.747  0.70 14.01           C
ATOM    668  SD  MET    81     -47.622   8.670  -5.960  0.70 21.09          SE
ATOM    670  CE  MET    81     -47.084   7.612  -7.496  0.70 15.28           C
ATOM    672  C   MET    81     -44.684   7.771  -2.235  0.70 13.11           C
ATOM    674  O   MET    81     -44.538   8.886  -1.698  0.70 12.95           O
ATOM    676  N   THR    82     -44.336   6.621  -1.655  1.00 11.97           N
ATOM    677  CA  THR    82     -43.690   6.575  -0.342  1.00 13.13           C
ATOM    678  CB  THR    82     -43.605   5.113   0.176  1.00 12.76           C
ATOM    679  OG1 THR    82     -44.931   4.563   0.297  1.00 13.08           O
ATOM    680  CG2 THR    82     -42.926   5.051   1.546  1.00 12.65           C
ATOM    681  C   THR    82     -42.311   7.220  -0.401  1.00 12.27           C
ATOM    682  O   THR    82     -41.988   8.047   0.443  1.00 12.09           O
ATOM    683  N   ALA    83     -41.522   6.874  -1.419  1.00 12.10           N
ATOM    684  CA  ALA    83     -40.189   7.455  -1.613  1.00 12.71           C
ATOM    685  CB  ALA    83     -39.469   6.804  -2.772  1.00 13.64           C
ATOM    686  C   ALA    83     -40.256   8.962  -1.829  1.00 13.31           C
ATOM    687  O   ALA    83     -39.424   9.717  -1.293  1.00 13.65           O
ATOM    688  N   TYR    84     -41.234   9.393  -2.621  1.00 12.01           N
ATOM    689  CA  TYR    84     -41.450  10.829  -2.827  1.00 11.80           C
ATOM    690  CB  TYR    84     -42.626  11.070  -3.785  1.00 11.47           C
ATOM    691  CG  TYR    84     -43.055  12.503  -3.698  1.00 11.01           C
ATOM    692  CD1 TYR    84     -42.230  13.514  -4.207  1.00  9.70           C
ATOM    693  CE1 TYR    84     -42.562  14.853  -4.058  1.00  7.72           C
ATOM    694  CZ  TYR    84     -43.777  15.207  -3.416  1.00  9.90           C
ATOM    695  OH  TYR    84     -44.090  16.520  -3.245  1.00  9.60           O
ATOM    696  CE2 TYR    84     -44.606  14.228  -2.886  1.00 10.03           C
ATOM    697  CD2 TYR    84     -44.241  12.867  -3.033  1.00  8.93           C
ATOM    698  C   TYR    84     -41.702  11.542  -1.464  1.00 11.96           C
ATOM    699  O   TYR    84     -41.113  12.588  -1.195  1.00 11.13           O
ATOM    700  N   LEU    85     -42.594  11.008  -0.646  1.00 10.86           N
ATOM    701  CA  LEU    85     -42.868  11.627   0.683  1.00 10.85           C
ATOM    702  CB  LEU    85     -44.003  10.908   1.396  1.00 10.34           C
ATOM    703  CG  LEU    85     -45.392  11.039   0.735  1.00 11.08           C
ATOM    704  CD1 LEU    85     -46.412  10.164   1.470  1.00 14.10           C
ATOM    705  CD2 LEU    85     -45.840  12.513   0.824  1.00 11.81           C
ATOM    706  C   LEU    85     -41.608  11.688   1.547  1.00 10.59           C
ATOM    707  O   LEU    85     -41.299  12.737   2.160  1.00  9.89           O
ATOM    708  N   ARG    86     -40.890  10.577   1.613  1.00 11.70           N
ATOM    709  CA  ARG    86     -39.686  10.504   2.430  1.00 12.21           C
ATOM    710  CB  ARG    86     -39.118   9.092   2.407  1.00 13.48           C
ATOM    711  CG  ARG    86     -38.070   8.880   3.462  1.00 16.80           C
ATOM    712  CD  ARG    86     -37.752   7.377   3.627  1.00 18.02           C
ATOM    713  NE  ARG    86     -38.810   6.676   4.350  1.00 20.50           N
ATOM    714  CZ  ARG    86     -39.556   5.706   3.833  1.00 23.33           C
ATOM    715  NH1 ARG    86     -39.354   5.300   2.584  1.00 26.93           N
ATOM    716  NH2 ARG    86     -40.472   5.111   4.589  1.00 24.38           N
ATOM    717  C   ARG    86     -38.635  11.526   1.947  1.00 11.94           C
ATOM    718  O   ARG    86     -37.985  12.202   2.764  1.00 11.86           O
ATOM    719  N   TRP    87     -38.462  11.595   0.637  1.00 11.06           N
ATOM    720  CA  TRP    87     -37.511  12.517   0.011  1.00 11.54           C
ATOM    721  CB  TRP    87     -37.513  12.276  -1.518  1.00 11.78           C
ATOM    722  CG  TRP    87     -36.670  13.219  -2.336  1.00 11.45           C
ATOM    723  CD1 TRP    87     -35.298  13.232  -2.473  1.00 12.95           C
ATOM    724  NE1 TRP    87     -34.914  14.228  -3.355  1.00 11.75           N
ATOM    725  CE2 TRP    87     -36.041  14.867  -3.805  1.00 12.69           C
ATOM    726  CD2 TRP    87     -37.162  14.253  -3.195  1.00 12.32           C
ATOM    727  CE3 TRP    87     -38.448  14.715  -3.505  1.00 13.71           C
ATOM    728  CZ3 TRP    87     -38.582  15.767  -4.386  1.00 13.30           C
ATOM    729  CH2 TRP    87     -37.436  16.377  -4.989  1.00 14.32           C
ATOM    730  CZ2 TRP    87     -36.166  15.944  -4.703  1.00 14.12           C
ATOM    731  C   TRP    87     -37.904  13.972   0.307  1.00 11.68           C
ATOM    732  O   TRP    87     -37.046  14.801   0.617  1.00 11.77           O
ATOM    733  N   THR    88     -39.191  14.280   0.183  1.00 11.01           N
ATOM    734  CA  THR    88     -39.685  15.654   0.390  1.00 11.22           C
ATOM    735  CB  THR    88     -41.147  15.790  -0.053  1.00 12.10           C
ATOM    736  OG1 THR    88     -41.220  15.503  -1.460  1.00 12.19           O
ATOM    737  CG2 THR    88     -41.678  17.220   0.199  1.00 12.36           C
ATOM    738  C   THR    88     -39.498  16.086   1.853  1.00 10.14           C
ATOM    739  O   THR    88     -39.045  17.207   2.119  1.00  9.63           O
ATOM    740  N   ILE    89     -39.826  15.192   2.778  1.00 10.71           N
ATOM    741  CA  ILE    89     -39.609  15.477   4.191  1.00 11.44           C
ATOM    742  CB  ILE    89     -40.178  14.352   5.067  1.00 11.62           C
ATOM    743  CG1 ILE    89     -41.718  14.377   4.949  1.00 10.67           C
ATOM    744  CD1 ILE    89     -42.368  13.154   5.612  1.00 14.32           C
ATOM    745  CG2 ILE    89     -39.752  14.574   6.521  1.00  9.76           C
ATOM    746  C   ILE    89     -38.108  15.719   4.470  1.00 11.65           C
ATOM    747  O   ILE    89     -37.748  16.702   5.123  1.00 10.49           O
ATOM    748  N   GLN    90     -37.253  14.832   3.946  0.60 11.78           N
ATOM    750  CA  GLN    90     -35.805  15.009   4.058  0.60 12.90           C
ATOM    752  CB  GLN    90     -35.059  13.906   3.294  0.60 13.23           C
ATOM    754  CG  GLN    90     -33.581  13.882   3.617  0.60 18.71           C
ATOM    756  CD  GLN    90     -33.320  13.696   5.114  0.60 24.36           C
ATOM    758  OE1 GLN    90     -32.857  14.615   5.797  0.60 28.60           O
ATOM    760  NE2 GLN    90     -33.626  12.502   5.631  0.60 27.22           N
ATOM    762  C   GLN    90     -35.349  16.402   3.563  0.60 12.09           C
ATOM    764  O   GLN    90     -34.599  17.104   4.235  0.60 11.76           O
ATOM    766  N   ARG    91     -35.849  16.798   2.401  1.00 12.06           N
ATOM    767  CA  ARG    91     -35.481  18.070   1.792  1.00 11.96           C
ATOM    768  CB  ARG    91     -36.237  18.253   0.485  1.00 13.06           C
ATOM    769  CG  ARG    91     -35.579  17.519  -0.624  1.00 17.79           C
ATOM    770  CD  ARG    91     -36.116  18.032  -1.972  1.00 20.49           C
ATOM    771  NE  ARG    91     -37.524  17.695  -2.235  1.00 21.73           N
ATOM    772  CZ  ARG    91     -38.542  18.563  -2.176  1.00 22.41           C
ATOM    773  NH1 ARG    91     -39.778  18.166  -2.519  1.00 18.87           N
ATOM    774  NH2 ARG    91     -38.328  19.821  -1.792  1.00 17.44           N
ATOM    775  C   ARG    91     -35.787  19.210   2.737  1.00 11.92           C
ATOM    776  O   ARG    91     -34.954  20.120   2.929  1.00 11.63           O
ATOM    777  N   HIS    92     -36.985  19.171   3.324  1.00 11.45           N
ATOM    778  CA  HIS    92     -37.369  20.231   4.257  1.00 12.36           C
ATOM    779  CB  HIS    92     -38.873  20.203   4.534  1.00 13.78           C
ATOM    780  CG  HIS    92     -39.696  20.557   3.336  1.00 14.40           C
ATOM    781  ND1 HIS    92     -39.591  21.777   2.684  1.00 19.47           N
ATOM    782  CE1 HIS    92     -40.452  21.801   1.674  1.00 21.35           C
ATOM    783  NE2 HIS    92     -41.103  20.649   1.649  1.00 16.69           N
ATOM    784  CD2 HIS    92     -40.635  19.846   2.660  1.00 16.03           C
ATOM    785  C   HIS    92     -36.565  20.215   5.544  1.00 12.15           C
ATOM    786  O   HIS    92     -36.192  21.268   6.056  1.00 11.95           O
ATOM    787  N   ARG    93     -36.254  19.030   6.054  1.00 11.79           N
ATOM    788  CA  ARG    93     -35.455  18.958   7.286  1.00 12.70           C
ATOM    789  CB  ARG    93     -35.461  17.537   7.853  1.00 12.66           C
ATOM    790  CG  ARG    93     -36.858  17.020   8.266  1.00 13.84           C
ATOM    791  CD  ARG    93     -37.401  17.762   9.453  1.00 18.09           C
ATOM    792  NE  ARG    93     -38.685  17.215   9.878  1.00 17.47           N
ATOM    793  CZ  ARG    93     -39.526  17.858  10.676  1.00 16.59           C
ATOM    794  NH1 ARG    93     -39.223  19.072  11.110  1.00 17.37           N
ATOM    795  NH2 ARG    93     -40.666  17.281  11.023  1.00 15.53           N
ATOM    796  C   ARG    93     -34.025  19.435   7.057  1.00 13.20           C
ATOM    797  O   ARG    93     -33.450  20.125   7.905  1.00 15.46           O
ATOM    798  N   ASN    94     -33.459  19.087   5.914  1.00 12.51           N
ATOM    799  CA  ASN    94     -32.101  19.512   5.580  1.00 14.01           C
ATOM    800  CB  ASN    94     -31.566  18.704   4.408  1.00 15.34           C
ATOM    801  CG  ASN    94     -31.380  17.226   4.724  1.00 18.74           C
ATOM    802  OD1 ASN    94     -31.130  16.441   3.813  1.00 27.63           O
ATOM    803  ND2 ASN    94     -31.508  16.841   5.986  1.00 22.90           N
ATOM    804  C   ASN    94     -32.010  20.978   5.199  1.00 13.91           C
ATOM    805  O   ASN    94     -30.942  21.582   5.307  1.00 12.63           O
ATOM    806  N   ASN    95     -33.118  21.549   4.732  1.00 13.29           N
ATOM    807  CA  ASN    95     -33.111  22.936   4.270  1.00 15.16           C
ATOM    808  CB  ASN    95     -32.967  23.054   2.763  1.00 16.24           C
ATOM    809  CG  ASN    95     -32.773  24.515   2.339  1.00 19.00           C
ATOM    810  OD1 ASN    95     -32.538  25.397   3.185  1.00 16.84           O
ATOM    811  ND2 ASN    95     -32.897  24.782   1.041  1.00 21.24           N
ATOM    812  C   ASN    95     -34.330  23.717   4.692  1.00 15.67           C
ATOM    813  O   ASN    95     -35.314  23.831   3.936  1.00 15.80           O
ATOM    814  N   PRO    96     -34.271  24.260   5.900  1.00 16.89           N
ATOM    815  CA  PRO    96     -35.322  25.100   6.460  1.00 18.18           C
ATOM    816  CB  PRO    96     -34.732  25.555   7.802  1.00 18.94           C
ATOM    817  CG  PRO    96     -33.729  24.472   8.148  1.00 19.40           C
ATOM    818  CD  PRO    96     -33.147  24.066   6.837  1.00 17.29           C
ATOM    819  C   PRO    96     -35.602  26.309   5.578  1.00 17.64           C
ATOM    820  O   PRO    96     -36.688  26.843   5.668  1.00 20.08           O
ATOM    821  N   GLN    97     -34.664  26.718   4.721  1.00 17.55           N
ATOM    822  CA  GLN    97     -34.882  27.924   3.884  1.00 16.15           C
ATOM    823  CB  GLN    97     -33.556  28.526   3.375  1.00 18.11           C
ATOM    824  CG  GLN    97     -32.586  28.997   4.445  1.00 21.27           C
ATOM    825  CD  GLN    97     -32.986  30.332   5.097  1.00 25.68           C
ATOM    826  OE1 GLN    97     -34.153  30.593   5.335  1.00 27.40           O
ATOM    827  NE2 GLN    97     -32.009  31.165   5.381  1.00 27.04           N
ATOM    828  C   GLN    97     -35.744  27.610   2.655  1.00 14.78           C
ATOM    829  O   GLN    97     -36.230  28.506   1.960  1.00 11.98           O
ATOM    830  N   LEU    98     -35.901  26.333   2.335  1.00 12.64           N
ATOM    831  CA  LEU    98     -36.399  26.054   0.980  1.00 12.07           C
ATOM    832  CB  LEU    98     -36.223  24.576   0.576  1.00 12.25           C
ATOM    833  CG  LEU    98     -36.864  24.142  -0.779  1.00 13.48           C
ATOM    834  CD1 LEU    98     -36.177  24.694  -2.050  1.00 15.69           C
ATOM    835  CD2 LEU    98     -36.865  22.621  -0.848  1.00 15.12           C
ATOM    836  C   LEU    98     -37.808  26.609   0.762  1.00  9.66           C
ATOM    837  O   LEU    98     -38.058  27.231  -0.286  1.00  9.22           O
ATOM    838  N   LEU    99     -38.723  26.475   1.724  1.00  9.90           N
ATOM    839  CA  LEU    99     -40.096  26.921   1.392  1.00 10.68           C
ATOM    840  CB  LEU    99     -41.134  26.482   2.475  1.00 11.84           C
ATOM    841  CG  LEU    99     -41.720  25.109   2.218  1.00 12.27           C
ATOM    842  CD1 LEU    99     -42.546  24.691   3.463  1.00 16.86           C
ATOM    843  CD2 LEU    99     -42.530  24.990   0.943  1.00 14.59           C
ATOM    844  C   LEU    99     -40.166  28.414   1.244  1.00 10.51           C
ATOM    845  O   LEU    99     -41.036  28.919   0.576  1.00 11.22           O
ATOM    846  N   ARG   100     -39.232  29.138   1.869  1.00  8.91           N
ATOM    847  CA  ARG   100     -39.171  30.614   1.637  1.00 10.19           C
ATOM    848  CB  ARG   100     -38.051  31.233   2.443  1.00  9.36           C
ATOM    849  CG  ARG   100     -38.293  31.279   3.923  1.00 12.57           C
ATOM    850  CD  ARG   100     -37.117  31.919   4.691  1.00 14.26           C
ATOM    851  NE  ARG   100     -37.502  32.131   6.084  1.00 21.03           N
ATOM    852  CZ  ARG   100     -36.662  32.254   7.102  1.00 26.22           C
ATOM    853  NH1 ARG   100     -35.340  32.191   6.906  1.00 25.30           N
ATOM    854  NH2 ARG   100     -37.156  32.455   8.326  1.00 30.04           N
ATOM    855  C   ARG   100     -38.944  30.908   0.135  1.00  9.56           C
ATOM    856  O   ARG   100     -39.737  31.609  -0.479  1.00  9.17           O
ATOM    857  N   PHE   101     -37.894  30.333  -0.451  1.00  8.88           N
ATOM    858  CA  PHE   101     -37.584  30.586  -1.861  1.00  7.74           C
ATOM    859  CB  PHE   101     -36.227  29.979  -2.191  1.00  9.07           C
ATOM    860  CG  PHE   101     -35.072  30.718  -1.553  1.00  8.31           C
ATOM    861  CD1 PHE   101     -34.572  31.865  -2.155  1.00  9.65           C
ATOM    862  CE1 PHE   101     -33.460  32.577  -1.586  1.00 12.39           C
ATOM    863  CZ  PHE   101     -32.856  32.079  -0.434  1.00 11.45           C
ATOM    864  CE2 PHE   101     -33.351  30.895   0.160  1.00 13.90           C
ATOM    865  CD2 PHE   101     -34.452  30.220  -0.416  1.00 11.33           C
ATOM    866  C   PHE   101     -38.651  29.978  -2.784  1.00  8.41           C
ATOM    867  O   PHE   101     -39.040  30.587  -3.776  1.00  8.06           O
ATOM    868  N   TYR   102     -39.122  28.777  -2.420  1.00  7.06           N
ATOM    869  CA  TYR   102     -40.068  28.027  -3.247  1.00  7.90           C
ATOM    870  CB  TYR   102     -40.262  26.695  -2.548  1.00  7.79           C
ATOM    871  CG  TYR   102     -41.077  25.629  -3.236  1.00  8.54           C
ATOM    872  CD1 TYR   102     -42.489  25.656  -3.181  1.00 10.03           C
ATOM    873  CE1 TYR   102     -43.257  24.599  -3.766  1.00 11.63           C
ATOM    874  CZ  TYR   102     -42.610  23.511  -4.376  1.00 11.76           C
ATOM    875  OH  TYR   102     -43.341  22.459  -4.924  1.00 11.14           O
ATOM    876  CE2 TYR   102     -41.192  23.459  -4.417  1.00  9.45           C
ATOM    877  CD2 TYR   102     -40.447  24.510  -3.827  1.00 10.19           C
ATOM    878  C   TYR   102     -41.394  28.796  -3.351  1.00  8.00           C
ATOM    879  O   TYR   102     -41.879  29.032  -4.458  1.00  9.22           O
ATOM    880  N   THR   103     -41.935  29.239  -2.212  1.00  8.23           N
ATOM    881  CA  THR   103     -43.186  30.012  -2.256  1.00  8.10           C
ATOM    882  CB  THR   103     -43.885  30.125  -0.875  1.00  7.33           C
ATOM    883  OG1 THR   103     -43.012  30.781   0.056  1.00  8.06           O
ATOM    884  CG2 THR   103     -44.249  28.714  -0.376  1.00  8.46           C
ATOM    885  C   THR   103     -43.009  31.397  -2.842  1.00  8.57           C
ATOM    886  O   THR   103     -43.909  31.869  -3.557  1.00  9.60           O
ATOM    887  N   SER   104     -41.877  32.052  -2.541  1.00  9.12           N
ATOM    888  CA  SER   104     -41.655  33.400  -3.043  1.00  9.88           C
ATOM    889  CB  SER   104     -40.363  34.009  -2.477  1.00  9.85           C
ATOM    890  OG  SER   104     -40.234  35.352  -2.971  1.00 12.21           O
ATOM    891  C   SER   104     -41.601  33.357  -4.584  1.00 10.66           C
ATOM    892  O   SER   104     -42.219  34.183  -5.265  1.00 10.59           O
ATOM    893  N   GLU   105     -40.865  32.392  -5.125  1.00  8.72           N
ATOM    894  CA  GLU   105     -40.817  32.289  -6.613  1.00  9.18           C
ATOM    895  CB  GLU   105     -39.731  31.293  -7.041  1.00  7.45           C
ATOM    896  CG  GLU   105     -38.332  31.924  -6.972  1.00  8.14           C
ATOM    897  CD  GLU   105     -38.036  32.910  -8.131  1.00 10.19           C
ATOM    898  OE1 GLU   105     -38.853  33.093  -9.071  1.00  9.04           O
ATOM    899  OE2 GLU   105     -36.931  33.505  -8.111  1.00 13.04           O
ATOM    900  C   GLU   105     -42.165  31.935  -7.261  1.00  9.12           C
ATOM    901  O   GLU   105     -42.538  32.491  -8.300  1.00  9.81           O
ATOM    902  N   LEU   106     -42.941  31.042  -6.632  1.00  8.79           N
ATOM    903  CA  LEU   106     -44.237  30.680  -7.191  1.00  9.03           C
ATOM    904  CB  LEU   106     -44.849  29.471  -6.457  1.00  8.32           C
ATOM    905  CG  LEU   106     -44.211  28.130  -6.911  1.00  9.60           C
ATOM    906  CD1 LEU   106     -44.576  27.033  -5.828  1.00  9.04           C
ATOM    907  CD2 LEU   106     -44.754  27.786  -8.296  1.00  9.22           C
ATOM    908  C   LEU   106     -45.238  31.834  -7.135  1.00  9.88           C
ATOM    909  O   LEU   106     -46.147  31.887  -7.972  1.00 10.21           O
ATOM    910  N   THR   107     -45.102  32.717  -6.136  1.00  9.52           N
ATOM    911  CA  THR   107     -46.030  33.832  -5.986  1.00  9.75           C
ATOM    912  CB  THR   107     -46.510  33.990  -4.516  1.00  9.09           C
ATOM    913  OG1 THR   107     -45.388  34.319  -3.693  1.00 10.50           O
ATOM    914  CG2 THR   107     -47.185  32.718  -4.076  1.00 10.05           C
ATOM    915  C   THR   107     -45.544  35.182  -6.484  1.00  9.81           C
ATOM    916  O   THR   107     -46.371  36.081  -6.704  1.00 12.25           O
ATOM    917  N   ASN   108     -44.232  35.363  -6.633  0.50  9.70           N
ATOM    919  CA  ASN   108     -43.617  36.625  -7.105  0.50  9.59           C
ATOM    921  CB  ASN   108     -43.154  37.511  -5.932  0.50  9.99           C
ATOM    923  CG  ASN   108     -44.278  38.322  -5.314  0.50  8.07           C
ATOM    925  OD1 ASN   108     -44.577  38.166  -4.138  0.50 11.45           O
ATOM    927  ND2 ASN   108     -44.931  39.160  -6.116  0.50  6.17           N
ATOM    929  C   ASN   108     -42.392  36.215  -7.909  0.50  9.86           C
ATOM    931  O   ASN   108     -41.262  36.429  -7.469  0.50  9.46           O
ATOM    933  N   PRO   109     -42.611  35.593  -9.087  1.00  9.87           N
ATOM    934  CA  PRO   109     -41.482  34.997  -9.847  1.00  9.20           C
ATOM    935  CB  PRO   109     -42.170  34.338 -11.060  1.00  9.29           C
ATOM    936  CG  PRO   109     -43.456  35.217 -11.249  1.00 11.47           C
ATOM    937  CD  PRO   109     -43.900  35.416  -9.770  1.00 10.72           C
ATOM    938  C   PRO   109     -40.455  36.039 -10.322  1.00  9.60           C
ATOM    939  O   PRO   109     -40.811  37.205 -10.612  1.00 11.09           O
ATOM    940  N   THR   110     -39.210  35.615 -10.382  1.00  9.05           N
ATOM    941  CA  THR   110     -38.133  36.378 -11.039  1.00  9.32           C
ATOM    942  CB  THR   110     -36.862  36.356 -10.160  1.00 10.57           C
ATOM    943  OG1 THR   110     -36.330  35.035 -10.130  1.00  9.30           O
ATOM    944  CG2 THR   110     -37.147  36.832  -8.744  1.00 13.98           C
ATOM    945  C   THR   110     -37.799  35.644 -12.327  1.00  8.94           C
ATOM    946  O   THR   110     -38.429  34.643 -12.626  1.00  8.35           O
ATOM    947  N   PRO   111     -36.818  36.119 -13.123  1.00  9.83           N
ATOM    948  CA  PRO   111     -36.366  35.317 -14.286  1.00 11.52           C
ATOM    949  CB  PRO   111     -35.231  36.183 -14.892  1.00 11.75           C
ATOM    950  CG  PRO   111     -35.579  37.539 -14.489  1.00 11.98           C
ATOM    951  CD  PRO   111     -36.150  37.430 -13.076  1.00 10.83           C
ATOM    952  C   PRO   111     -35.863  33.915 -13.908  1.00 12.86           C
ATOM    953  O   PRO   111     -35.889  32.963 -14.744  1.00 13.75           O
ATOM    954  N   CYS   112     -35.461  33.730 -12.660  1.00 11.46           N
ATOM    955  CA  CYS   112     -35.067  32.401 -12.254  1.00 13.19           C
ATOM    956  CB  CYS   112     -34.230  32.442 -10.978  1.00 14.56           C
ATOM    957  SG  CYS   112     -32.686  33.333 -11.290  1.00 18.40           S
ATOM    958  C   CYS   112     -36.251  31.432 -12.108  1.00 12.18           C
ATOM    959  O   CYS   112     -36.048  30.232 -11.974  1.00 13.79           O
ATOM    960  N   PHE   113     -37.501  31.926 -12.121  1.00 11.58           N
ATOM    961  CA  PHE   113     -38.605  30.987 -11.961  1.00 10.29           C
ATOM    962  CB  PHE   113     -39.921  31.711 -11.869  1.00 10.73           C
ATOM    963  CG  PHE   113     -41.068  30.776 -11.807  1.00 10.75           C
ATOM    964  CD1 PHE   113     -41.318  30.025 -10.649  1.00 13.13           C
ATOM    965  CE1 PHE   113     -42.390  29.092 -10.649  1.00 14.20           C
ATOM    966  CZ  PHE   113     -43.135  28.878 -11.780  1.00 12.39           C
ATOM    967  CE2 PHE   113     -42.909  29.606 -12.931  1.00 14.70           C
ATOM    968  CD2 PHE   113     -41.824  30.539 -12.957  1.00 11.87           C
ATOM    969  C   PHE   113     -38.634  30.035 -13.180  1.00  9.81           C
ATOM    970  O   PHE   113     -38.642  28.807 -13.017  1.00  9.92           O
ATOM    971  N   ALA   114     -38.644  30.592 -14.383  1.00  9.60           N
ATOM    972  CA  ALA   114     -38.711  29.716 -15.565  1.00  9.88           C
ATOM    973  CB  ALA   114     -38.980  30.528 -16.837  1.00  9.97           C
ATOM    974  C   ALA   114     -37.461  28.865 -15.730  1.00 10.92           C
ATOM    975  O   ALA   114     -37.548  27.764 -16.247  1.00 11.21           O
ATOM    976  N   ALA   115     -36.301  29.407 -15.342  1.00 10.45           N
ATOM    977  CA  ALA   115     -35.020  28.733 -15.554  1.00 11.81           C
ATOM    978  CB  ALA   115     -33.882  29.767 -15.520  1.00 12.14           C
ATOM    979  C   ALA   115     -34.750  27.588 -14.574  1.00 11.95           C
ATOM    980  O   ALA   115     -34.178  26.555 -14.951  1.00 12.70           O
ATOM    981  N   ILE   116     -35.186  27.750 -13.331  1.00 11.04           N
ATOM    982  CA  ILE   116     -34.783  26.848 -12.255  1.00 11.69           C
ATOM    983  CB  ILE   116     -33.872  27.616 -11.214  1.00 10.98           C
ATOM    984  CG1 ILE   116     -32.584  28.106 -11.900  1.00 13.37           C
ATOM    985  CD1 ILE   116     -31.751  29.071 -11.039  1.00 12.57           C
ATOM    986  CG2 ILE   116     -33.568  26.724  -9.962  1.00 12.49           C
ATOM    987  C   ILE   116     -35.998  26.242 -11.560  1.00 11.29           C
ATOM    988  O   ILE   116     -36.092  25.007 -11.384  1.00 10.24           O
ATOM    989  N   VAL   117     -36.919  27.089 -11.131  1.00 10.95           N
ATOM    990  CA  VAL   117     -37.977  26.588 -10.206  1.00 10.57           C
ATOM    991  CB  VAL   117     -38.617  27.751  -9.409  1.00 11.02           C
ATOM    992  CG1 VAL   117     -39.795  27.207  -8.454  1.00 10.64           C
ATOM    993  CG2 VAL   117     -37.512  28.443  -8.627  1.00 10.50           C
ATOM    994  C   VAL   117     -39.038  25.771 -10.946  1.00 11.77           C
ATOM    995  O   VAL   117     -39.425  24.648 -10.524  1.00 11.14           O
ATOM    996  N   SER   118     -39.530  26.315 -12.046  1.00 10.59           N
ATOM    997  CA  SER   118     -40.620  25.684 -12.764  1.00 12.47           C
ATOM    998  CB  SER   118     -41.105  26.636 -13.868  1.00 13.39           C
ATOM    999  OG  SER   118     -42.255  26.127 -14.471  1.00 14.41           O
ATOM   1000  C   SER   118     -40.234  24.283 -13.285  1.00 11.92           C
ATOM   1001  O   SER   118     -40.958  23.318 -13.010  1.00 12.39           O
ATOM   1002  N   PRO   119     -39.094  24.138 -13.988  1.00 12.64           N
ATOM   1003  CA  PRO   119     -38.727  22.800 -14.461  1.00 11.77           C
ATOM   1004  CB  PRO   119     -37.448  23.016 -15.304  1.00 12.21           C
ATOM   1005  CG  PRO   119     -36.981  24.375 -14.981  1.00 12.76           C
ATOM   1006  CD  PRO   119     -38.161  25.180 -14.467  1.00 11.90           C
ATOM   1007  C   PRO   119     -38.487  21.799 -13.296  1.00 11.38           C
ATOM   1008  O   PRO   119     -38.822  20.622 -13.450  1.00 11.44           O
ATOM   1009  N   ALA   120     -37.965  22.276 -12.162  1.00 10.79           N
ATOM   1010  CA  ALA   120     -37.680  21.404 -10.992  1.00  9.96           C
ATOM   1011  CB  ALA   120     -36.955  22.202  -9.916  1.00 10.33           C
ATOM   1012  C   ALA   120     -38.996  20.843 -10.478  1.00 11.25           C
ATOM   1013  O   ALA   120     -39.179  19.606 -10.381  1.00 11.32           O
ATOM   1014  N   ILE   121     -39.972  21.731 -10.240  1.00  9.92           N
ATOM   1015  CA  ILE   121     -41.278  21.275  -9.739  1.00 10.42           C
ATOM   1016  CB  ILE   121     -42.191  22.482  -9.354  1.00  9.91           C
ATOM   1017  CG1 ILE   121     -41.576  23.223  -8.147  1.00 11.53           C
ATOM   1018  CD1 ILE   121     -42.273  24.600  -7.882  1.00 11.61           C
ATOM   1019  CG2 ILE   121     -43.657  22.039  -9.082  1.00 11.13           C
ATOM   1020  C   ILE   121     -41.980  20.382 -10.790  1.00 10.00           C
ATOM   1021  O   ILE   121     -42.496  19.302 -10.444  1.00 10.24           O
ATOM   1022  N   ALA   122     -41.999  20.822 -12.047  1.00 10.30           N
ATOM   1023  CA  ALA   122     -42.680  20.050 -13.108  1.00 11.54           C
ATOM   1024  CB  ALA   122     -42.598  20.755 -14.509  1.00 12.24           C
ATOM   1025  C   ALA   122     -42.094  18.638 -13.234  1.00 11.86           C
ATOM   1026  O   ALA   122     -42.845  17.702 -13.488  1.00 12.38           O
ATOM   1027  N   SER   123     -40.780  18.499 -13.132  1.00 11.72           N
ATOM   1028  CA  SER   123     -40.140  17.174 -13.297  1.00 11.69           C
ATOM   1029  CB  SER   123     -38.597  17.220 -13.248  1.00 13.37           C
ATOM   1030  OG  SER   123     -38.136  17.620 -11.957  1.00 18.01           O
ATOM   1031  C   SER   123     -40.678  16.217 -12.222  1.00 11.56           C
ATOM   1032  O   SER   123     -40.889  15.041 -12.504  1.00 11.30           O
ATOM   1033  N   VAL   124     -40.862  16.719 -10.996  1.00 10.19           N
ATOM   1034  CA  VAL   124     -41.338  15.876  -9.883  1.00  9.66           C
ATOM   1035  CB  VAL   124     -41.121  16.603  -8.497  1.00 10.39           C
ATOM   1036  CG1 VAL   124     -41.817  15.860  -7.384  1.00 13.37           C
ATOM   1037  CG2 VAL   124     -39.640  16.694  -8.191  1.00 12.44           C
ATOM   1038  C   VAL   124     -42.808  15.523 -10.075  1.00 10.08           C
ATOM   1039  O   VAL   124     -43.218  14.350  -9.905  1.00  9.51           O
ATOM   1040  N   ILE   125     -43.617  16.526 -10.409  1.00  9.88           N
ATOM   1041  CA  ILE   125     -45.046  16.301 -10.630  1.00 10.74           C
ATOM   1042  CB  ILE   125     -45.803  17.624 -10.870  1.00 11.75           C
ATOM   1043  CG1 ILE   125     -45.744  18.498  -9.590  1.00  9.55           C
ATOM   1044  CD1 ILE   125     -46.274  17.830  -8.232  1.00 11.11           C
ATOM   1045  CG2 ILE   125     -47.298  17.363 -11.280  1.00 10.72           C
ATOM   1046  C   ILE   125     -45.254  15.309 -11.757  1.00 10.24           C
ATOM   1047  O   ILE   125     -46.088  14.386 -11.644  1.00 10.73           O
ATOM   1048  N   ARG   126     -44.483  15.459 -12.837  0.50 10.47           N
ATOM   1050  CA  ARG   126     -44.567  14.514 -13.947  0.50  9.91           C
ATOM   1052  CB  ARG   126     -43.607  14.907 -15.078  0.50  9.78           C
ATOM   1054  CG  ARG   126     -44.070  16.073 -15.874  0.50  8.97           C
ATOM   1056  CD  ARG   126     -43.145  16.305 -17.083  0.50 11.78           C
ATOM   1058  NE  ARG   126     -43.524  17.541 -17.757  0.50 13.41           N
ATOM   1060  CZ  ARG   126     -42.784  18.643 -17.773  0.50 18.19           C
ATOM   1062  NH1 ARG   126     -41.594  18.649 -17.187  0.50 18.32           N
ATOM   1064  NH2 ARG   126     -43.223  19.729 -18.401  0.50 20.28           N
ATOM   1066  C   ARG   126     -44.269  13.104 -13.483  0.50 10.39           C
ATOM   1068  O   ARG   126     -45.010  12.161 -13.806  0.50 11.26           O
ATOM   1070  N   LEU   127     -43.191  12.959 -12.717  1.00 10.18           N
ATOM   1071  CA  LEU   127     -42.747  11.653 -12.281  1.00 11.49           C
ATOM   1072  CB  LEU   127     -41.457  11.792 -11.470  1.00 12.45           C
ATOM   1073  CG  LEU   127     -40.836  10.551 -10.872  1.00 15.70           C
ATOM   1074  CD1 LEU   127     -40.489   9.503 -11.921  1.00 20.81           C
ATOM   1075  CD2 LEU   127     -39.573  10.988 -10.121  1.00 18.67           C
ATOM   1076  C   LEU   127     -43.864  10.955 -11.482  1.00  9.91           C
ATOM   1077  O   LEU   127     -44.173   9.757 -11.684  1.00 10.50           O
ATOM   1078  N   LEU   128     -44.458  11.703 -10.559  1.00  8.79           N
ATOM   1079  CA  LEU   128     -45.555  11.167  -9.751  1.00  9.28           C
ATOM   1080  CB  LEU   128     -45.959  12.213  -8.701  1.00  9.38           C
ATOM   1081  CG  LEU   128     -44.895  12.460  -7.628  1.00 11.13           C
ATOM   1082  CD1 LEU   128     -45.399  13.599  -6.743  1.00 11.82           C
ATOM   1083  CD2 LEU   128     -44.635  11.243  -6.755  1.00 13.49           C
ATOM   1084  C   LEU   128     -46.755  10.814 -10.630  1.00 10.57           C
ATOM   1085  O   LEU   128     -47.393   9.762 -10.464  1.00  8.87           O
ATOM   1086  N   ALA   129     -47.111  11.725 -11.531  1.00  9.99           N
ATOM   1087  CA  ALA   129     -48.264  11.513 -12.419  1.00 10.43           C
ATOM   1088  CB  ALA   129     -48.466  12.756 -13.298  1.00 10.04           C
ATOM   1089  C   ALA   129     -48.072  10.270 -13.290  1.00  9.53           C
ATOM   1090  O   ALA   129     -49.010   9.490 -13.509  1.00  9.22           O
ATOM   1091  N   GLU   130     -46.842  10.075 -13.777  1.00 10.54           N
ATOM   1092  CA  GLU   130     -46.555   8.883 -14.586  1.00 10.65           C
ATOM   1093  CB  GLU   130     -45.130   8.957 -15.080  1.00 11.71           C
ATOM   1094  CG  GLU   130     -45.015   9.922 -16.236  1.00 15.98           C
ATOM   1095  CD  GLU   130     -43.548  10.268 -16.577  1.00 25.12           C
ATOM   1096  OE1 GLU   130     -42.602   9.684 -15.991  1.00 26.80           O
ATOM   1097  OE2 GLU   130     -43.362  11.157 -17.432  1.00 30.61           O
ATOM   1098  C   GLU   130     -46.799   7.589 -13.828  1.00 10.74           C
ATOM   1099  O   GLU   130     -47.364   6.626 -14.382  1.00  9.75           O
ATOM   1100  N   SER   131     -46.395   7.580 -12.558  0.50 10.14           N
ATOM   1102  CA  SER   131     -46.583   6.411 -11.722  0.50 10.49           C
ATOM   1104  CB  SER   131     -45.843   6.578 -10.396  0.50 11.10           C
ATOM   1106  OG  SER   131     -45.705   5.328  -9.775  0.50 10.69           O
ATOM   1108  C   SER   131     -48.057   6.142 -11.458  0.50 10.47           C
ATOM   1110  O   SER   131     -48.497   4.991 -11.474  0.50  9.95           O
ATOM   1112  N   ILE   132     -48.806   7.214 -11.186  1.00  9.30           N
ATOM   1113  CA  ILE   132     -50.274   7.155 -11.007  1.00 10.27           C
ATOM   1114  CB  ILE   132     -50.819   8.528 -10.573  1.00 10.43           C
ATOM   1115  CG1 ILE   132     -50.217   8.879  -9.199  1.00 10.19           C
ATOM   1116  CD1 ILE   132     -50.537  10.321  -8.694  1.00 10.55           C
ATOM   1117  CG2 ILE   132     -52.352   8.522 -10.544  1.00 12.86           C
ATOM   1118  C   ILE   132     -50.956   6.643 -12.274  1.00 10.09           C
ATOM   1119  O   ILE   132     -51.855   5.784 -12.188  1.00  9.47           O
ATOM   1120  N   GLU   133     -50.535   7.164 -13.426  0.50 10.08           N
ATOM   1122  CA  GLU   133     -51.024   6.713 -14.732  0.50 10.68           C
ATOM   1124  CB  GLU   133     -50.390   7.549 -15.871  0.50 10.91           C
ATOM   1126  CG  GLU   133     -51.050   8.940 -16.009  0.50 12.45           C
ATOM   1128  CD  GLU   133     -50.193  10.029 -16.674  0.50 14.41           C
ATOM   1130  OE1 GLU   133     -48.998   9.781 -16.983  0.50 17.78           O
ATOM   1132  OE2 GLU   133     -50.748  11.144 -16.892  0.50 18.07           O
ATOM   1134  C   GLU   133     -50.823   5.208 -14.941  0.50  9.88           C
ATOM   1136  O   GLU   133     -51.712   4.518 -15.430  0.50 10.09           O
ATOM   1138  N   ALA   134     -49.659   4.695 -14.546  1.00  9.31           N
ATOM   1139  CA  ALA   134     -49.346   3.267 -14.674  1.00  9.01           C
ATOM   1140  CB  ALA   134     -47.869   3.011 -14.361  1.00  9.38           C
ATOM   1141  C   ALA   134     -50.237   2.445 -13.765  1.00  9.17           C
ATOM   1142  O   ALA   134     -50.720   1.372 -14.144  1.00  9.07           O
ATOM   1143  N   GLY   135     -50.446   2.954 -12.554  1.00  9.74           N
ATOM   1144  CA  GLY   135     -51.304   2.264 -11.598  1.00  9.68           C
ATOM   1145  C   GLY   135     -52.748   2.231 -12.081  1.00 10.54           C
ATOM   1146  O   GLY   135     -53.432   1.261 -11.841  1.00 11.18           O
ATOM   1147  N   MET   136     -53.212   3.294 -12.736  1.00 10.78           N
ATOM   1148  CA  MET   136     -54.550   3.319 -13.316  1.00 14.00           C
ATOM   1149  CB  MET   136     -54.856   4.709 -13.853  1.00 12.19           C
ATOM   1150  CG  MET   136     -55.025   5.738 -12.769  1.00 17.50           C
ATOM   1151  SD  MET   136     -55.390   7.532 -13.517  0.80 27.77          SE
ATOM   1152  CE  MET   136     -56.956   7.128 -14.509  1.00 24.50           C
ATOM   1153  C   MET   136     -54.690   2.274 -14.426  1.00 11.62           C
ATOM   1154  O   MET   136     -55.630   1.461 -14.414  1.00 11.88           O
ATOM   1155  N   THR   137     -53.704   2.228 -15.331  1.00 10.74           N
ATOM   1156  CA  THR   137     -53.673   1.197 -16.405  1.00  9.88           C
ATOM   1157  CB  THR   137     -52.401   1.371 -17.285  1.00  9.89           C
ATOM   1158  OG1 THR   137     -52.434   2.676 -17.872  1.00 11.23           O
ATOM   1159  CG2 THR   137     -52.311   0.289 -18.374  1.00 10.49           C
ATOM   1160  C   THR   137     -53.735  -0.220 -15.824  1.00  9.70           C
ATOM   1161  O   THR   137     -54.451  -1.096 -16.313  1.00  8.79           O
ATOM   1162  N   ARG   138     -53.012  -0.433 -14.737  1.00 10.06           N
ATOM   1163  CA  ARG   138     -52.962  -1.726 -14.092  1.00 10.50           C
ATOM   1164  CB  ARG   138     -51.753  -1.827 -13.178  1.00 10.22           C
ATOM   1165  CG  ARG   138     -50.421  -1.961 -13.926  1.00 11.00           C
ATOM   1166  CD  ARG   138     -49.267  -1.783 -12.921  1.00 11.40           C
ATOM   1167  NE  ARG   138     -49.385  -2.776 -11.860  1.00 13.48           N
ATOM   1168  CZ  ARG   138     -48.694  -2.749 -10.731  1.00 16.65           C
ATOM   1169  NH1 ARG   138     -47.798  -1.778 -10.519  1.00 13.97           N
ATOM   1170  NH2 ARG   138     -48.909  -3.699  -9.812  1.00 18.04           N
ATOM   1171  C   ARG   138     -54.233  -2.088 -13.308  1.00 11.15           C
ATOM   1172  O   ARG   138     -54.391  -3.238 -12.908  1.00 11.80           O
ATOM   1173  N   GLY   139     -55.117  -1.122 -13.103  1.00 12.43           N
ATOM   1174  CA  GLY   139     -56.308  -1.342 -12.309  1.00 12.85           C
ATOM   1175  C   GLY   139     -56.098  -1.206 -10.803  1.00 14.77           C
ATOM   1176  O   GLY   139     -57.031  -1.500 -10.021  1.00 15.21           O
ATOM   1177  N   LEU   140     -54.904  -0.785 -10.370  1.00 14.40           N
ATOM   1178  CA  LEU   140     -54.663  -0.525  -8.930  1.00 15.70           C
ATOM   1179  CB  LEU   140     -53.175  -0.325  -8.608  1.00 17.02           C
ATOM   1180  CG  LEU   140     -52.165  -1.407  -8.937  1.00 20.06           C
ATOM   1181  CD1 LEU   140     -50.855  -0.921  -8.327  1.00 24.89           C
ATOM   1182  CD2 LEU   140     -52.585  -2.711  -8.319  1.00 24.25           C
ATOM   1183  C   LEU   140     -55.356   0.744  -8.489  1.00 14.92           C
ATOM   1184  O   LEU   140     -55.818   0.834  -7.342  1.00 14.43           O
ATOM   1185  N   PHE   141     -55.378   1.734  -9.384  1.00 13.97           N
ATOM   1186  CA  PHE   141     -55.934   3.051  -9.092  1.00 15.04           C
ATOM   1187  CB  PHE   141     -54.894   4.159  -9.339  1.00 13.91           C
ATOM   1188  CG  PHE   141     -53.627   4.016  -8.510  1.00 13.77           C
ATOM   1189  CD1 PHE   141     -53.668   3.442  -7.227  1.00 13.85           C
ATOM   1190  CE1 PHE   141     -52.491   3.310  -6.463  1.00 13.85           C
ATOM   1191  CZ  PHE   141     -51.267   3.776  -7.000  1.00 12.20           C
ATOM   1192  CE2 PHE   141     -51.240   4.341  -8.294  1.00 10.44           C
ATOM   1193  CD2 PHE   141     -52.392   4.479  -9.011  1.00 12.75           C
ATOM   1194  C   PHE   141     -57.151   3.307  -9.951  1.00 15.74           C
ATOM   1195  O   PHE   141     -57.249   2.777 -11.067  1.00 14.26           O
ATOM   1196  N   ARG   142     -58.074   4.120  -9.443  0.50 16.15           N
ATOM   1198  CA  ARG   142     -59.333   4.428 -10.124  0.50 17.47           C
ATOM   1200  CB  ARG   142     -60.256   5.250  -9.227  0.50 17.67           C
ATOM   1202  CG  ARG   142     -60.907   4.514  -8.115  0.50 18.73           C
ATOM   1204  CD  ARG   142     -61.871   5.446  -7.428  0.50 20.28           C
ATOM   1206  NE  ARG   142     -61.191   6.543  -6.744  0.50 20.28           N
ATOM   1208  CZ  ARG   142     -61.802   7.632  -6.287  0.50 20.99           C
ATOM   1210  NH1 ARG   142     -63.104   7.797  -6.474  0.50 17.88           N
ATOM   1212  NH2 ARG   142     -61.099   8.580  -5.668  0.50 20.92           N
ATOM   1214  C   ARG   142     -59.126   5.255 -11.374  0.50 17.70           C
ATOM   1216  O   ARG   142     -58.339   6.198 -11.388  0.50 18.50           O
ATOM   1218  N   ARG   143     -59.912   4.938 -12.395  1.00 18.41           N
ATOM   1219  CA  ARG   143     -59.747   5.554 -13.691  1.00 19.17           C
ATOM   1220  CB  ARG   143     -60.007   4.550 -14.785  1.00 19.39           C
ATOM   1221  CG  ARG   143     -58.965   3.434 -14.827  1.00 22.29           C
ATOM   1222  CD  ARG   143     -59.450   2.272 -15.677  1.00 26.49           C
ATOM   1223  NE  ARG   143     -58.403   1.273 -15.895  1.00 30.12           N
ATOM   1224  CZ  ARG   143     -58.545  -0.047 -15.757  1.00 31.21           C
ATOM   1225  NH1 ARG   143     -59.715  -0.594 -15.415  1.00 32.67           N
ATOM   1226  NH2 ARG   143     -57.502  -0.838 -15.984  1.00 31.42           N
ATOM   1227  C   ARG   143     -60.507   6.857 -13.893  1.00 18.83           C
ATOM   1228  O   ARG   143     -60.315   7.510 -14.913  1.00 20.12           O
ATOM   1229  N   ASP   144     -61.324   7.254 -12.917  1.00 17.76           N
ATOM   1230  CA  ASP   144     -62.025   8.547 -12.977  1.00 16.37           C
ATOM   1231  CB  ASP   144     -63.426   8.450 -12.354  1.00 16.63           C
ATOM   1232  CG  ASP   144     -63.395   8.116 -10.877  1.00 17.52           C
ATOM   1233  OD1 ASP   144     -62.398   7.530 -10.424  1.00 17.03           O
ATOM   1234  OD2 ASP   144     -64.383   8.426 -10.159  1.00 20.81           O
ATOM   1235  C   ASP   144     -61.281   9.716 -12.339  1.00 15.58           C
ATOM   1236  O   ASP   144     -61.871  10.803 -12.135  1.00 16.22           O
ATOM   1237  N   LEU   145     -60.024   9.520 -11.954  0.50 14.65           N
ATOM   1239  CA  LEU   145     -59.257  10.650 -11.435  0.50 13.62           C
ATOM   1241  CB  LEU   145     -58.748  10.426 -10.005  0.50 13.58           C
ATOM   1243  CG  LEU   145     -59.708  10.249  -8.827  0.50 13.00           C
ATOM   1245  CD1 LEU   145     -58.863   9.721  -7.686  0.50 13.60           C
ATOM   1247  CD2 LEU   145     -60.478  11.539  -8.398  0.50 13.09           C
ATOM   1249  C   LEU   145     -58.106  10.962 -12.376  0.50 13.00           C
ATOM   1251  O   LEU   145     -57.581  10.079 -13.050  0.50 12.96           O
ATOM   1253  N   HIS   146     -57.762  12.235 -12.428  1.00 12.38           N
ATOM   1254  CA  HIS   146     -56.767  12.749 -13.335  1.00 11.72           C
ATOM   1255  CB  HIS   146     -57.099  14.174 -13.754  1.00 13.12           C
ATOM   1256  CG  HIS   146     -58.088  14.223 -14.890  1.00 18.87           C
ATOM   1257  ND1 HIS   146     -59.407  14.593 -14.717  1.00 23.34           N
ATOM   1258  CE1 HIS   146     -60.041  14.495 -15.875  1.00 23.61           C
ATOM   1259  NE2 HIS   146     -59.189  14.056 -16.787  1.00 22.78           N
ATOM   1260  CD2 HIS   146     -57.966  13.859 -16.194  1.00 21.18           C
ATOM   1261  C   HIS   146     -55.432  12.632 -12.658  1.00  9.97           C
ATOM   1262  O   HIS   146     -55.283  13.064 -11.523  1.00  8.48           O
ATOM   1263  N   ALA   147     -54.466  12.063 -13.380  1.00  8.06           N
ATOM   1264  CA  ALA   147     -53.171  11.743 -12.792  1.00  7.43           C
ATOM   1265  CB  ALA   147     -52.303  10.976 -13.795  1.00  7.64           C
ATOM   1266  C   ALA   147     -52.415  12.975 -12.255  1.00  7.37           C
ATOM   1267  O   ALA   147     -51.892  12.935 -11.149  1.00  7.42           O
ATOM   1268  N   VAL   148     -52.323  14.040 -13.057  1.00  5.91           N
ATOM   1269  CA  VAL   148     -51.580  15.234 -12.596  1.00  5.28           C
ATOM   1270  CB  VAL   148     -51.376  16.285 -13.741  1.00  5.29           C
ATOM   1271  CG1 VAL   148     -50.894  17.623 -13.160  1.00  5.38           C
ATOM   1272  CG2 VAL   148     -50.385  15.716 -14.827  1.00  7.18           C
ATOM   1273  C   VAL   148     -52.285  15.874 -11.417  1.00  5.21           C
ATOM   1274  O   VAL   148     -51.641  16.225 -10.424  1.00  4.80           O
ATOM   1275  N   ASN   149     -53.605  16.034 -11.475  1.00  5.51           N
ATOM   1276  CA  ASN   149     -54.259  16.664 -10.322  1.00  5.65           C
ATOM   1277  CB  ASN   149     -55.765  16.822 -10.566  1.00  6.66           C
ATOM   1278  CG  ASN   149     -56.088  18.026 -11.409  1.00 10.17           C
ATOM   1279  OD1 ASN   149     -55.200  18.846 -11.725  1.00 12.80           O
ATOM   1280  ND2 ASN   149     -57.358  18.143 -11.798  1.00 12.10           N
ATOM   1281  C   ASN   149     -54.045  15.842  -9.043  1.00  6.11           C
ATOM   1282  O   ASN   149     -53.933  16.413  -7.953  1.00  4.78           O
ATOM   1283  N   SER   150     -53.988  14.513  -9.207  1.00  5.76           N
ATOM   1284  CA  SER   150     -53.748  13.564  -8.084  1.00  6.08           C
ATOM   1285  CB  SER   150     -54.027  12.096  -8.522  1.00  5.78           C
ATOM   1286  OG  SER   150     -55.422  11.927  -8.837  1.00  7.08           O
ATOM   1287  C   SER   150     -52.331  13.717  -7.550  1.00  5.66           C
ATOM   1288  O   SER   150     -52.119  13.810  -6.341  1.00  5.57           O
ATOM   1289  N   ALA   151     -51.349  13.768  -8.451  1.00  5.77           N
ATOM   1290  CA  ALA   151     -49.966  14.064  -8.076  1.00  5.41           C
ATOM   1291  CB  ALA   151     -49.086  14.156  -9.326  1.00  5.18           C
ATOM   1292  C   ALA   151     -49.874  15.386  -7.279  1.00  5.91           C
ATOM   1293  O   ALA   151     -49.179  15.466  -6.262  1.00  6.61           O
ATOM   1294  N   LEU   152     -50.552  16.425  -7.784  1.00  6.31           N
ATOM   1295  CA  LEU   152     -50.534  17.749  -7.110  1.00  5.72           C
ATOM   1296  CB  LEU   152     -51.297  18.807  -7.921  1.00  4.81           C
ATOM   1297  CG  LEU   152     -50.598  19.222  -9.218  1.00  4.27           C
ATOM   1298  CD1 LEU   152     -51.572  20.071 -10.072  1.00  6.58           C
ATOM   1299  CD2 LEU   152     -49.276  20.001  -8.973  1.00  5.18           C
ATOM   1300  C   LEU   152     -51.132  17.647  -5.707  1.00  7.70           C
ATOM   1301  O   LEU   152     -50.626  18.296  -4.766  1.00  7.69           O
ATOM   1302  N   ALA   153     -52.188  16.836  -5.551  1.00  6.37           N
ATOM   1303  CA  ALA   153     -52.794  16.600  -4.245  1.00  7.16           C
ATOM   1304  CB  ALA   153     -54.029  15.679  -4.378  1.00  5.65           C
ATOM   1305  C   ALA   153     -51.787  16.008  -3.247  1.00  7.42           C
ATOM   1306  O   ALA   153     -51.667  16.511  -2.117  1.00  6.88           O
ATOM   1307  N   LEU   154     -51.039  14.972  -3.683  1.00  5.98           N
ATOM   1308  CA  LEU   154     -50.031  14.354  -2.805  1.00  5.94           C
ATOM   1309  CB  LEU   154     -49.453  13.092  -3.458  1.00  6.06           C
ATOM   1310  CG  LEU   154     -48.400  12.364  -2.617  1.00  6.43           C
ATOM   1311  CD1 LEU   154     -48.990  11.876  -1.271  1.00  5.45           C
ATOM   1312  CD2 LEU   154     -47.790  11.240  -3.434  1.00  7.02           C
ATOM   1313  C   LEU   154     -48.921  15.373  -2.447  1.00  5.85           C
ATOM   1314  O   LEU   154     -48.530  15.518  -1.271  1.00  6.15           O
ATOM   1315  N   ALA   155     -48.449  16.084  -3.464  1.00  6.37           N
ATOM   1316  CA  ALA   155     -47.402  17.083  -3.242  1.00  6.90           C
ATOM   1317  CB  ALA   155     -46.984  17.689  -4.593  1.00  7.15           C
ATOM   1318  C   ALA   155     -47.927  18.147  -2.260  1.00  6.59           C
ATOM   1319  O   ALA   155     -47.181  18.625  -1.387  1.00  7.17           O
ATOM   1320  N   GLY   156     -49.204  18.510  -2.409  1.00  6.53           N
ATOM   1321  CA  GLY   156     -49.808  19.558  -1.574  1.00  7.23           C
ATOM   1322  C   GLY   156     -49.903  19.117  -0.129  1.00  8.33           C
ATOM   1323  O   GLY   156     -49.684  19.935   0.770  1.00  9.18           O
ATOM   1324  N   MET   157     -50.275  17.857   0.104  0.50  7.22           N
ATOM   1326  CA  MET   157     -50.394  17.342   1.473  0.50  9.40           C
ATOM   1328  CB  MET   157     -50.608  15.818   1.495  0.50  9.03           C
ATOM   1330  CG  MET   157     -51.950  15.368   1.037  0.50 10.44           C
ATOM   1332  SD  MET   157     -52.121  13.470   1.490  0.50 14.75          SE
ATOM   1334  CE  MET   157     -53.565  13.043   0.240  0.50 11.36           C
ATOM   1336  C   MET   157     -49.104  17.647   2.216  0.50  8.33           C
ATOM   1338  O   MET   157     -49.097  18.375   3.226  0.50  7.60           O
ATOM   1340  N   VAL   158     -48.020  17.067   1.700  1.00  7.62           N
ATOM   1341  CA  VAL   158     -46.738  17.073   2.389  1.00  7.60           C
ATOM   1342  CB  VAL   158     -45.769  16.001   1.870  1.00  7.87           C
ATOM   1343  CG1 VAL   158     -45.363  16.267   0.375  1.00  6.80           C
ATOM   1344  CG2 VAL   158     -44.556  15.904   2.800  1.00  5.50           C
ATOM   1345  C   VAL   158     -46.161  18.504   2.448  1.00  8.05           C
ATOM   1346  O   VAL   158     -45.655  18.951   3.498  1.00  7.94           O
ATOM   1347  N   ASN   159     -46.268  19.258   1.359  1.00  6.99           N
ATOM   1348  CA  ASN   159     -45.679  20.596   1.364  1.00  8.56           C
ATOM   1349  CB  ASN   159     -45.517  21.063  -0.110  1.00  9.44           C
ATOM   1350  CG  ASN   159     -44.267  20.391  -0.770  1.00 13.46           C
ATOM   1351  OD1 ASN   159     -43.115  20.774  -0.449  1.00 13.49           O
ATOM   1352  ND2 ASN   159     -44.491  19.365  -1.676  1.00 11.04           N
ATOM   1353  C   ASN   159     -46.491  21.532   2.299  1.00  8.55           C
ATOM   1354  O   ASN   159     -45.898  22.350   3.007  1.00  8.77           O
ATOM   1355  N   TYR   160     -47.807  21.324   2.393  1.00  8.99           N
ATOM   1356  CA  TYR   160     -48.598  22.206   3.289  1.00  8.46           C
ATOM   1357  CB  TYR   160     -50.076  22.031   3.041  1.00  9.05           C
ATOM   1358  CG  TYR   160     -50.895  23.089   3.758  1.00  6.76           C
ATOM   1359  CD1 TYR   160     -51.004  24.373   3.254  1.00  6.16           C
ATOM   1360  CE1 TYR   160     -51.755  25.374   3.951  1.00  6.68           C
ATOM   1361  CZ  TYR   160     -52.367  25.032   5.159  1.00  6.05           C
ATOM   1362  OH  TYR   160     -53.125  25.927   5.884  1.00  6.88           O
ATOM   1363  CE2 TYR   160     -52.260  23.729   5.663  1.00  7.56           C
ATOM   1364  CD2 TYR   160     -51.513  22.779   4.968  1.00  8.31           C
ATOM   1365  C   TYR   160     -48.297  21.873   4.749  1.00  8.41           C
ATOM   1366  O   TYR   160     -48.341  22.775   5.600  1.00  7.66           O
ATOM   1367  N   PHE   161     -48.025  20.596   5.064  1.00  7.26           N
ATOM   1368  CA  PHE   161     -47.662  20.273   6.467  1.00  7.86           C
ATOM   1369  CB  PHE   161     -47.311  18.790   6.604  1.00  7.74           C
ATOM   1370  CG  PHE   161     -46.983  18.392   7.998  1.00  9.30           C
ATOM   1371  CD1 PHE   161     -48.006  18.107   8.896  1.00 12.83           C
ATOM   1372  CE1 PHE   161     -47.720  17.697  10.215  1.00 11.42           C
ATOM   1373  CZ  PHE   161     -46.391  17.641  10.657  1.00 12.71           C
ATOM   1374  CE2 PHE   161     -45.357  17.968   9.769  1.00 10.83           C
ATOM   1375  CD2 PHE   161     -45.666  18.335   8.433  1.00 11.04           C
ATOM   1376  C   PHE   161     -46.491  21.148   6.954  1.00  7.95           C
ATOM   1377  O   PHE   161     -46.543  21.724   8.066  1.00  9.32           O
ATOM   1378  N   PHE   162     -45.463  21.301   6.114  1.00  6.72           N
ATOM   1379  CA  PHE   162     -44.318  22.124   6.507  1.00  7.65           C
ATOM   1380  CB  PHE   162     -43.078  21.726   5.710  1.00  7.99           C
ATOM   1381  CG  PHE   162     -42.566  20.366   6.105  1.00  9.27           C
ATOM   1382  CD1 PHE   162     -41.714  20.225   7.191  1.00 10.78           C
ATOM   1383  CE1 PHE   162     -41.239  18.956   7.593  1.00 11.91           C
ATOM   1384  CZ  PHE   162     -41.634  17.827   6.904  1.00 11.69           C
ATOM   1385  CE2 PHE   162     -42.511  17.965   5.784  1.00 13.79           C
ATOM   1386  CD2 PHE   162     -42.967  19.220   5.412  1.00 10.23           C
ATOM   1387  C   PHE   162     -44.639  23.608   6.400  1.00  6.36           C
ATOM   1388  O   PHE   162     -44.272  24.414   7.281  1.00  6.77           O
ATOM   1389  N   LEU   163     -45.339  23.986   5.329  1.00  6.53           N
ATOM   1390  CA  LEU   163     -45.685  25.410   5.150  1.00  6.76           C
ATOM   1391  CB  LEU   163     -46.531  25.576   3.876  1.00  6.66           C
ATOM   1392  CG  LEU   163     -46.960  27.017   3.573  1.00  7.04           C
ATOM   1393  CD1 LEU   163     -45.732  27.937   3.372  1.00  9.53           C
ATOM   1394  CD2 LEU   163     -47.878  27.026   2.294  1.00  8.47           C
ATOM   1395  C   LEU   163     -46.462  25.968   6.327  1.00  6.16           C
ATOM   1396  O   LEU   163     -46.251  27.132   6.716  1.00  6.46           O
ATOM   1397  N   SER   164     -47.398  25.156   6.872  1.00  5.30           N
ATOM   1398  CA  SER   164     -48.338  25.682   7.889  1.00  7.61           C
ATOM   1399  CB  SER   164     -49.657  24.912   7.802  1.00  8.19           C
ATOM   1400  OG  SER   164     -49.459  23.552   8.139  1.00  9.73           O
ATOM   1401  C   SER   164     -47.773  25.574   9.326  1.00  7.56           C
ATOM   1402  O   SER   164     -48.479  25.903  10.294  1.00  8.21           O
ATOM   1403  N   THR   165     -46.511  25.154   9.458  1.00  5.79           N
ATOM   1404  CA  THR   165     -45.964  24.822  10.782  1.00  6.26           C
ATOM   1405  CB  THR   165     -44.424  24.572  10.701  1.00  6.23           C
ATOM   1406  OG1 THR   165     -44.184  23.428   9.866  1.00  7.44           O
ATOM   1407  CG2 THR   165     -43.891  24.259  12.117  1.00  8.11           C
ATOM   1408  C   THR   165     -46.186  25.914  11.821  1.00  4.75           C
ATOM   1409  O   THR   165     -46.641  25.626  12.936  1.00  5.25           O
ATOM   1410  N   LEU   166     -45.844  27.165  11.481  1.00  5.75           N
ATOM   1411  CA  LEU   166     -45.911  28.235  12.482  1.00  6.51           C
ATOM   1412  CB  LEU   166     -45.339  29.576  11.965  1.00  6.68           C
ATOM   1413  CG  LEU   166     -43.841  29.678  11.719  1.00 10.81           C
ATOM   1414  CD1 LEU   166     -43.547  31.167  11.394  1.00 11.81           C
ATOM   1415  CD2 LEU   166     -43.055  29.293  13.016  1.00 11.69           C
ATOM   1416  C   LEU   166     -47.337  28.456  12.986  1.00  7.46           C
ATOM   1417  O   LEU   166     -47.491  28.973  14.095  1.00  8.56           O
ATOM   1418  N   ALA   167     -48.369  28.123  12.171  1.00  6.08           N
ATOM   1419  CA  ALA   167     -49.766  28.384  12.541  1.00  8.18           C
ATOM   1420  CB  ALA   167     -50.626  28.722  11.311  1.00  7.47           C
ATOM   1421  C   ALA   167     -50.387  27.203  13.251  1.00  8.91           C
ATOM   1422  O   ALA   167     -51.532  27.304  13.723  1.00  9.05           O
ATOM   1423  N   THR   168     -49.662  26.096  13.285  1.00  8.62           N
ATOM   1424  CA  THR   168     -50.264  24.857  13.794  1.00 10.98           C
ATOM   1425  CB  THR   168     -50.502  23.867  12.644  1.00  9.39           C
ATOM   1426  OG1 THR   168     -49.275  23.508  11.993  1.00 11.50           O
ATOM   1427  CG2 THR   168     -51.464  24.477  11.542  1.00  9.79           C
ATOM   1428  C   THR   168     -49.423  24.220  14.919  1.00 10.56           C
ATOM   1429  O   THR   168     -49.522  22.997  15.158  1.00 11.79           O
ATOM   1430  N   GLU   169     -48.671  25.069  15.639  1.00 13.47           N
ATOM   1431  CA  GLU   169     -47.634  24.567  16.568  1.00 14.51           C
ATOM   1432  CB  GLU   169     -46.793  25.705  17.190  1.00 15.58           C
ATOM   1433  CG  GLU   169     -45.950  26.533  16.217  1.00 16.67           C
ATOM   1434  CD  GLU   169     -44.641  25.858  15.769  1.00 18.06           C
ATOM   1435  OE1 GLU   169     -44.427  24.660  16.046  1.00 20.34           O
ATOM   1436  OE2 GLU   169     -43.824  26.515  15.088  1.00 17.77           O
ATOM   1437  C   GLU   169     -48.280  23.732  17.661  1.00 14.80           C
ATOM   1438  O   GLU   169     -47.758  22.662  18.045  1.00 15.84           O
ATOM   1439  N   GLY   170     -49.391  24.218  18.188  1.00 14.31           N
ATOM   1440  CA  GLY   170     -50.050  23.519  19.293  1.00 15.34           C
ATOM   1441  C   GLY   170     -51.115  22.570  18.807  1.00 14.96           C
ATOM   1442  O   GLY   170     -51.802  21.946  19.628  1.00 15.30           O
ATOM   1443  N   LEU   171     -51.257  22.405  17.486  1.00 11.97           N
ATOM   1444  CA  LEU   171     -52.364  21.571  16.985  1.00 12.07           C
ATOM   1445  CB  LEU   171     -53.048  22.173  15.739  1.00 11.20           C
ATOM   1446  CG  LEU   171     -53.567  23.620  15.751  1.00 13.56           C
ATOM   1447  CD1 LEU   171     -54.356  23.917  14.477  1.00 12.40           C
ATOM   1448  CD2 LEU   171     -54.410  23.968  16.985  1.00 16.09           C
ATOM   1449  C   LEU   171     -51.901  20.179  16.629  1.00 12.32           C
ATOM   1450  O   LEU   171     -52.706  19.251  16.620  1.00 12.27           O
ATOM   1451  N   THR   172     -50.620  20.021  16.304  1.00 11.32           N
ATOM   1452  CA  THR   172     -50.093  18.690  15.929  1.00 12.36           C
ATOM   1453  CB  THR   172     -50.439  18.296  14.451  1.00 11.94           C
ATOM   1454  OG1 THR   172     -50.076  16.907  14.240  1.00 16.35           O
ATOM   1455  CG2 THR   172     -49.710  19.217  13.452  1.00 12.29           C
ATOM   1456  C   THR   172     -48.585  18.711  16.141  1.00 12.72           C
ATOM   1457  O   THR   172     -47.994  19.812  16.226  1.00 13.87           O
ATOM   1458  N   SER   173     -47.958  17.545  16.214  1.00 12.97           N
ATOM   1459  CA  SER   173     -46.524  17.503  16.397  1.00 11.93           C
ATOM   1460  CB  SER   173     -46.103  16.108  16.826  1.00 13.97           C
ATOM   1461  OG  SER   173     -44.681  15.989  16.771  1.00 14.44           O
ATOM   1462  C   SER   173     -45.874  17.806  15.060  1.00 12.33           C
ATOM   1463  O   SER   173     -46.353  17.332  14.028  1.00 12.42           O
ATOM   1464  N   HIS   174     -44.824  18.610  15.068  1.00 12.00           N
ATOM   1465  CA  HIS   174     -43.970  18.721  13.876  1.00 14.23           C
ATOM   1466  CB  HIS   174     -43.909  20.171  13.391  1.00 14.23           C
ATOM   1467  CG  HIS   174     -45.247  20.722  13.030  1.00 15.81           C
ATOM   1468  ND1 HIS   174     -46.071  21.324  13.968  1.00 16.61           N
ATOM   1469  CE1 HIS   174     -47.185  21.718  13.368  1.00 20.91           C
ATOM   1470  NE2 HIS   174     -47.116  21.386  12.085  1.00 19.63           N
ATOM   1471  CD2 HIS   174     -45.900  20.785  11.839  1.00 17.42           C
ATOM   1472  C   HIS   174     -42.578  18.183  14.149  1.00 13.15           C
ATOM   1473  O   HIS   174     -41.625  18.515  13.427  1.00 14.79           O
ATOM   1474  N   SER   175     -42.456  17.352  15.179  1.00 14.28           N
ATOM   1475  CA  SER   175     -41.158  16.794  15.566  1.00 13.71           C
ATOM   1476  CB  SER   175     -41.281  16.104  16.921  1.00 14.35           C
ATOM   1477  OG  SER   175     -40.255  15.138  17.113  1.00 17.37           O
ATOM   1478  C   SER   175     -40.645  15.822  14.475  1.00 13.44           C
ATOM   1479  O   SER   175     -41.412  15.024  13.953  1.00 12.58           O
ATOM   1480  N   PRO   176     -39.341  15.882  14.146  1.00 13.15           N
ATOM   1481  CA  PRO   176     -38.830  14.880  13.178  1.00 13.22           C
ATOM   1482  CB  PRO   176     -37.342  15.224  13.064  1.00 13.70           C
ATOM   1483  CG  PRO   176     -37.228  16.655  13.534  1.00 13.98           C
ATOM   1484  CD  PRO   176     -38.278  16.806  14.593  1.00 13.08           C
ATOM   1485  C   PRO   176     -39.045  13.413  13.624  1.00 14.24           C
ATOM   1486  O   PRO   176     -39.154  12.527  12.770  1.00 13.21           O
ATOM   1487  N   ASP   177     -39.134  13.171  14.936  1.00 14.82           N
ATOM   1488  CA  ASP   177     -39.514  11.855  15.496  1.00 16.58           C
ATOM   1489  CB  ASP   177     -39.811  11.976  17.000  1.00 17.92           C
ATOM   1490  CG  ASP   177     -38.610  12.345  17.796  1.00 24.07           C
ATOM   1491  OD1 ASP   177     -37.500  12.389  17.204  1.00 30.89           O
ATOM   1492  OD2 ASP   177     -38.764  12.562  19.024  1.00 30.05           O
ATOM   1493  C   ASP   177     -40.780  11.270  14.887  1.00 15.97           C
ATOM   1494  O   ASP   177     -40.967  10.047  14.905  1.00 16.38           O
ATOM   1495  N   GLN   178     -41.655  12.147  14.404  1.00 14.77           N
ATOM   1496  CA  GLN   178     -42.965  11.735  13.923  1.00 15.23           C
ATOM   1497  CB  GLN   178     -44.057  12.637  14.515  1.00 16.28           C
ATOM   1498  CG  GLN   178     -44.212  12.558  16.075  1.00 18.38           C
ATOM   1499  CD  GLN   178     -44.416  11.148  16.555  1.00 24.89           C
ATOM   1500  OE1 GLN   178     -45.323  10.454  16.094  1.00 28.81           O
ATOM   1501  NE2 GLN   178     -43.556  10.694  17.466  1.00 23.68           N
ATOM   1502  C   GLN   178     -43.060  11.731  12.390  1.00 14.33           C
ATOM   1503  O   GLN   178     -44.153  11.563  11.837  1.00 14.25           O
ATOM   1504  N   ASP   179     -41.935  11.946  11.715  1.00 13.75           N
ATOM   1505  CA  ASP   179     -41.931  12.025  10.241  1.00 12.28           C
ATOM   1506  CB  ASP   179     -40.565  12.503   9.712  1.00 12.21           C
ATOM   1507  CG  ASP   179     -40.345  14.003   9.887  1.00 12.00           C
ATOM   1508  OD1 ASP   179     -41.340  14.728  10.133  1.00 12.73           O
ATOM   1509  OD2 ASP   179     -39.178  14.458   9.767  1.00 10.97           O
ATOM   1510  C   ASP   179     -42.333  10.695   9.583  1.00 12.43           C
ATOM   1511  O   ASP   179     -43.076  10.688   8.586  1.00 11.55           O
ATOM   1512  N   GLU   180     -41.873   9.564  10.129  1.00 12.85           N
ATOM   1513  CA  GLU   180     -42.244   8.281   9.539  1.00 13.39           C
ATOM   1514  CB  GLU   180     -41.363   7.129  10.047  1.00 14.36           C
ATOM   1515  CG  GLU   180     -39.961   7.112   9.416  1.00 16.71           C
ATOM   1516  CD  GLU   180     -39.971   6.815   7.917  1.00 18.99           C
ATOM   1517  OE1 GLU   180     -40.744   5.922   7.502  1.00 20.42           O
ATOM   1518  OE2 GLU   180     -39.200   7.469   7.161  1.00 18.63           O
ATOM   1519  C   GLU   180     -43.734   8.019   9.746  1.00 13.71           C
ATOM   1520  O   GLU   180     -44.403   7.448   8.873  1.00 13.28           O
ATOM   1521  N   GLU   181     -44.271   8.460  10.883  1.00 13.78           N
ATOM   1522  CA  GLU   181     -45.689   8.305  11.124  1.00 14.42           C
ATOM   1523  CB  GLU   181     -45.998   8.599  12.588  1.00 16.10           C
ATOM   1524  CG  GLU   181     -47.472   8.632  12.901  1.00 21.01           C
ATOM   1525  CD  GLU   181     -48.173   7.282  12.774  1.00 23.11           C
ATOM   1526  OE1 GLU   181     -47.514   6.228  12.665  1.00 24.17           O
ATOM   1527  OE2 GLU   181     -49.422   7.301  12.790  1.00 25.06           O
ATOM   1528  C   GLU   181     -46.494   9.212  10.185  1.00 14.14           C
ATOM   1529  O   GLU   181     -47.564   8.828   9.706  1.00 14.26           O
ATOM   1530  N   LEU   182     -45.956  10.396   9.878  1.00 13.08           N
ATOM   1531  CA  LEU   182     -46.604  11.293   8.915  1.00 13.64           C
ATOM   1532  CB  LEU   182     -45.865  12.643   8.831  1.00 12.83           C
ATOM   1533  CG  LEU   182     -46.579  13.680   7.940  1.00 14.91           C
ATOM   1534  CD1 LEU   182     -47.863  14.196   8.590  1.00 15.08           C
ATOM   1535  CD2 LEU   182     -45.644  14.827   7.575  1.00 15.95           C
ATOM   1536  C   LEU   182     -46.678  10.637   7.522  1.00 13.14           C
ATOM   1537  O   LEU   182     -47.718  10.661   6.855  1.00 14.11           O
ATOM   1538  N   ILE   183     -45.576  10.050   7.084  1.00 12.68           N
ATOM   1539  CA  ILE   183     -45.564   9.306   5.810  1.00 11.35           C
ATOM   1540  CB  ILE   183     -44.189   8.673   5.546  1.00 10.84           C
ATOM   1541  CG1 ILE   183     -43.122   9.766   5.347  1.00 12.02           C
ATOM   1542  CD1 ILE   183     -41.658   9.195   5.429  1.00 11.23           C
ATOM   1543  CG2 ILE   183     -44.228   7.768   4.309  1.00 11.12           C
ATOM   1544  C   ILE   183     -46.664   8.205   5.800  1.00 11.45           C
ATOM   1545  O   ILE   183     -47.422   8.086   4.830  1.00 10.62           O
ATOM   1546  N   ARG   184     -46.735   7.438   6.884  0.50 11.53           N
ATOM   1548  CA  ARG   184     -47.720   6.369   7.046  0.50 11.75           C
ATOM   1550  CB  ARG   184     -47.569   5.750   8.435  0.50 12.01           C
ATOM   1552  CG  ARG   184     -47.839   4.275   8.512  0.50 14.69           C
ATOM   1554  CD  ARG   184     -47.348   3.699   9.852  0.50 17.23           C
ATOM   1556  NE  ARG   184     -45.897   3.490   9.822  0.50 20.38           N
ATOM   1558  CZ  ARG   184     -45.023   3.988  10.695  0.50 19.61           C
ATOM   1560  NH1 ARG   184     -43.738   3.716  10.523  0.50 21.24           N
ATOM   1562  NH2 ARG   184     -45.415   4.720  11.740  0.50 16.19           N
ATOM   1564  C   ARG   184     -49.137   6.937   6.888  0.50 11.09           C
ATOM   1566  O   ARG   184     -49.974   6.363   6.185  0.50 10.52           O
ATOM   1568  N   GLN   185     -49.387   8.070   7.541  1.00 10.20           N
ATOM   1569  CA  GLN   185     -50.693   8.718   7.492  1.00 11.34           C
ATOM   1570  CB  GLN   185     -50.812   9.832   8.557  1.00 11.76           C
ATOM   1571  CG  GLN   185     -50.910   9.329   9.971  1.00 13.90           C
ATOM   1572  CD  GLN   185     -50.827  10.475  10.988  1.00 16.31           C
ATOM   1573  OE1 GLN   185     -51.146  11.627  10.670  1.00 24.88           O
ATOM   1574  NE2 GLN   185     -50.379  10.163  12.192  1.00 22.00           N
ATOM   1575  C   GLN   185     -51.069   9.294   6.120  1.00 10.79           C
ATOM   1576  O   GLN   185     -52.231   9.134   5.675  1.00 10.92           O
ATOM   1577  N   TYR   186     -50.095   9.901   5.436  1.00  9.48           N
ATOM   1578  CA  TYR   186     -50.375  10.550   4.165  1.00 10.97           C
ATOM   1579  CB  TYR   186     -49.386  11.701   3.929  1.00 11.73           C
ATOM   1580  CG  TYR   186     -49.831  12.983   4.689  1.00 11.89           C
ATOM   1581  CD1 TYR   186     -50.901  12.943   5.618  1.00 16.50           C
ATOM   1582  CE1 TYR   186     -51.319  14.116   6.323  1.00 16.69           C
ATOM   1583  CZ  TYR   186     -50.665  15.304   6.104  1.00 15.60           C
ATOM   1584  OH  TYR   186     -51.066  16.479   6.789  1.00 16.29           O
ATOM   1585  CE2 TYR   186     -49.579  15.336   5.236  1.00 15.60           C
ATOM   1586  CD2 TYR   186     -49.176  14.184   4.529  1.00 16.97           C
ATOM   1587  C   TYR   186     -50.456   9.510   3.024  1.00 10.48           C
ATOM   1588  O   TYR   186     -51.313   9.616   2.143  1.00 10.25           O
ATOM   1589  N   VAL   187     -49.660   8.448   3.114  1.00 10.81           N
ATOM   1590  CA  VAL   187     -49.813   7.308   2.195  1.00 11.07           C
ATOM   1591  CB  VAL   187     -48.750   6.195   2.457  1.00 12.17           C
ATOM   1592  CG1 VAL   187     -49.152   4.865   1.801  1.00 12.64           C
ATOM   1593  CG2 VAL   187     -47.381   6.636   1.948  1.00 12.10           C
ATOM   1594  C   VAL   187     -51.238   6.738   2.348  1.00 10.78           C
ATOM   1595  O   VAL   187     -51.902   6.468   1.365  1.00 11.55           O
ATOM   1596  N   ALA   188     -51.697   6.596   3.591  1.00 10.35           N
ATOM   1597  CA  ALA   188     -53.016   6.013   3.862  1.00 10.34           C
ATOM   1598  CB  ALA   188     -53.214   5.835   5.322  1.00 10.03           C
ATOM   1599  C   ALA   188     -54.109   6.923   3.278  1.00 10.52           C
ATOM   1600  O   ALA   188     -54.976   6.440   2.532  1.00 11.14           O
ATOM   1601  N   ILE   189     -54.067   8.223   3.582  1.00  9.18           N
ATOM   1602  CA  ILE   189     -55.064   9.134   3.022  1.00 10.18           C
ATOM   1603  CB  ILE   189     -54.855  10.573   3.534  1.00 10.61           C
ATOM   1604  CG1 ILE   189     -55.136  10.601   5.058  1.00 10.98           C
ATOM   1605  CD1 ILE   189     -54.723  11.960   5.716  1.00 13.83           C
ATOM   1606  CG2 ILE   189     -55.802  11.563   2.805  1.00 11.30           C
ATOM   1607  C   ILE   189     -55.041   9.113   1.474  1.00  9.70           C
ATOM   1608  O   ILE   189     -56.074   9.014   0.819  1.00  9.40           O
ATOM   1609  N   PHE   190     -53.857   9.209   0.889  1.00  9.58           N
ATOM   1610  CA  PHE   190     -53.805   9.360  -0.550  1.00  9.58           C
ATOM   1611  CB  PHE   190     -52.360   9.611  -0.993  1.00 10.23           C
ATOM   1612  CG  PHE   190     -52.226  10.008  -2.454  1.00  9.45           C
ATOM   1613  CD1 PHE   190     -52.917  11.128  -2.945  1.00  9.44           C
ATOM   1614  CE1 PHE   190     -52.804  11.478  -4.324  1.00  8.91           C
ATOM   1615  CZ  PHE   190     -51.991  10.716  -5.159  1.00  8.37           C
ATOM   1616  CE2 PHE   190     -51.307   9.595  -4.666  1.00 10.34           C
ATOM   1617  CD2 PHE   190     -51.432   9.256  -3.313  1.00  9.34           C
ATOM   1618  C   PHE   190     -54.341   8.115  -1.252  1.00 10.23           C
ATOM   1619  O   PHE   190     -55.013   8.227  -2.272  1.00 10.36           O
ATOM   1620  N   THR   191     -54.011   6.933  -0.728  1.00 10.49           N
ATOM   1621  CA  THR   191     -54.331   5.687  -1.425  1.00 11.39           C
ATOM   1622  CB  THR   191     -53.251   4.575  -1.187  1.00 11.16           C
ATOM   1623  OG1 THR   191     -53.129   4.320   0.203  1.00 13.70           O
ATOM   1624  CG2 THR   191     -51.894   5.021  -1.716  1.00 12.85           C
ATOM   1625  C   THR   191     -55.730   5.173  -1.057  1.00 11.49           C
ATOM   1626  O   THR   191     -56.413   4.630  -1.920  1.00 11.57           O
ATOM   1627  N   ARG   192     -56.142   5.361   0.207  1.00 11.47           N
ATOM   1628  CA  ARG   192     -57.377   4.780   0.764  1.00 12.54           C
ATOM   1629  CB  ARG   192     -57.043   3.762   1.863  1.00 13.38           C
ATOM   1630  CG  ARG   192     -56.218   2.608   1.352  1.00 19.78           C
ATOM   1631  CD  ARG   192     -55.838   1.648   2.458  1.00 27.83           C
ATOM   1632  NE  ARG   192     -54.833   2.186   3.390  1.00 31.16           N
ATOM   1633  CZ  ARG   192     -54.979   2.196   4.710  1.00 30.70           C
ATOM   1634  NH1 ARG   192     -56.099   1.741   5.268  1.00 34.65           N
ATOM   1635  NH2 ARG   192     -54.007   2.636   5.480  1.00 31.86           N
ATOM   1636  C   ARG   192     -58.394   5.793   1.313  1.00 11.41           C
ATOM   1637  O   ARG   192     -59.513   5.408   1.694  1.00 11.66           O
ATOM   1638  N   GLY   193     -57.999   7.067   1.407  1.00 10.15           N
ATOM   1639  CA  GLY   193     -58.897   8.124   1.894  1.00  9.23           C
ATOM   1640  C   GLY   193     -59.105   8.042   3.399  1.00 10.71           C
ATOM   1641  O   GLY   193     -58.465   7.238   4.070  1.00 11.66           O
ATOM   1642  N   ILE   194     -60.015   8.848   3.940  1.00 10.09           N
ATOM   1643  CA  ILE   194     -60.233   8.806   5.378  1.00 10.51           C
ATOM   1644  CB  ILE   194     -60.410  10.235   5.966  1.00  9.22           C
ATOM   1645  CG1 ILE   194     -61.635  10.937   5.378  1.00  9.15           C
ATOM   1646  CD1 ILE   194     -62.095  12.150   6.229  1.00 10.65           C
ATOM   1647  CG2 ILE   194     -59.149  11.099   5.736  1.00 10.26           C
ATOM   1648  C   ILE   194     -61.435   7.920   5.776  1.00 13.00           C
ATOM   1649  O   ILE   194     -61.677   7.686   6.986  1.00 11.91           O
ATOM   1650  N   MET   195     -62.162   7.427   4.770  0.80 13.74           N
ATOM   1652  CA  MET   195     -63.370   6.618   5.035  0.80 19.32           C
ATOM   1654  CB  MET   195     -64.062   6.224   3.735  0.80 17.64           C
ATOM   1656  CG  MET   195     -63.224   5.251   2.910  0.80 22.42           C
ATOM   1658  SD  MET   195     -64.053   4.614   1.255  0.80 35.82          SE
ATOM   1660  CE  MET   195     -65.779   4.059   1.995  0.80 28.19           C
ATOM   1662  C   MET   195     -63.024   5.348   5.798  0.80 17.09           C
ATOM   1664  O   MET   195     -61.945   4.789   5.620  0.80 16.40           O
ATOM   1666  N   ALA   196     -63.946   4.892   6.647  1.00 16.54           N
ATOM   1667  CA  ALA   196     -63.751   3.621   7.358  1.00 17.64           C
ATOM   1668  CB  ALA   196     -64.842   3.419   8.388  1.00 17.48           C
ATOM   1669  C   ALA   196     -63.706   2.435   6.397  1.00 18.42           C
ATOM   1670  O   ALA   196     -64.469   2.403   5.437  1.00 19.76           O
END
