
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  220 ( 1732),  selected  220 , name 1t33_A
# Molecule2: number of CA atoms  192 ( 1477),  selected  192 , name T0454.pdb
# PARAMETERS: 1t33_A.T0454.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      -       -           -
LGA    N     2_A      -       -           -
LGA    I     3_A      -       -           -
LGA    P     4_A      -       -           -
LGA    T     5_A      -       -           -
LGA    T     6_A      -       -           -
LGA    T     7_A      -       -           -
LGA    T     8_A      -       -           -
LGA    K     9_A      D       5          3.867
LGA    G    10_A      -       -           -
LGA    E    11_A      -       -           -
LGA    Q    12_A      -       -           -
LGA    A    13_A      C       6          3.645
LGA    K    14_A      R       7          2.788
LGA    S    15_A      S       8          3.893
LGA    Q    16_A      R       9          3.565
LGA    L    17_A      L      10          2.214
LGA    I    18_A      M      11          2.695
LGA    A    19_A      E      12          3.174
LGA    A    20_A      V      13          2.404
LGA    A    21_A      A      14          1.750
LGA    L    22_A      T      15          2.422
LGA    A    23_A      E      16          2.110
LGA    Q    24_A      L      17          1.373
LGA    F    25_A      F      18          1.486
LGA    G    26_A      A      19          2.158
LGA    E    27_A      Q      20          1.904
LGA    Y    28_A      K      21          1.084
LGA    G    29_A      G      22          1.869
LGA    L    30_A      F      23          3.111
LGA    -       -      Y      24           -
LGA    H    31_A      G      25          1.814
LGA    A    32_A      V      26          1.468
LGA    T    33_A      S      27          2.696
LGA    T    34_A      I      28          2.874
LGA    R    35_A      R      29          3.771
LGA    D    36_A      E      30          3.277
LGA    I    37_A      L      31          2.999
LGA    A    38_A      A      32          3.832
LGA    A    39_A      Q      33          4.393
LGA    L    40_A      A      34          4.047
LGA    A    41_A      -       -           -
LGA    G    42_A      A      35          3.871
LGA    Q    43_A      G      36          4.389
LGA    N    44_A      A      37          0.993
LGA    I    45_A      S      38          3.271
LGA    A    46_A      I      39          4.014
LGA    -       -      S      40           -
LGA    A    47_A      M      41          3.524
LGA    I    48_A      I      42          2.219
LGA    T    49_A      S      43          2.058
LGA    Y    50_A      Y      44          3.569
LGA    Y    51_A      H      45          3.494
LGA    F    52_A      F      46          2.776
LGA    G    53_A      G      47          2.555
LGA    S    54_A      G      48          1.770
LGA    K    55_A      K      49          1.037
LGA    E    56_A      E      50          2.185
LGA    D    57_A      G      51          2.494
LGA    L    58_A      L      52          1.885
LGA    Y    59_A      Y      53          1.871
LGA    L    60_A      A      54          2.233
LGA    A    61_A      A      55          2.313
LGA    C    62_A      V      56          2.089
LGA    A    63_A      L      57          2.240
LGA    Q    64_A      Q      58          2.043
LGA    W    65_A      E      59          2.101
LGA    I    66_A      Q      60          2.164
LGA    A    67_A      F      61          2.742
LGA    D    68_A      A      62          1.882
LGA    F    69_A      C      63          3.562
LGA    L    70_A      F      64          3.140
LGA    G    71_A      G      65          2.160
LGA    E    72_A      Q      66          3.181
LGA    K    73_A      -       -           -
LGA    F    74_A      L      67          2.665
LGA    R    75_A      D      68          4.007
LGA    P    76_A      D      69          3.615
LGA    H    77_A      I      70          2.340
LGA    A    78_A      R      71          3.445
LGA    E    79_A      -       -           -
LGA    K    80_A      G      72          1.575
LGA    A    81_A      Q      73          5.529
LGA    E    82_A      -       -           -
LGA    R    83_A      -       -           -
LGA    L    84_A      A      74          3.448
LGA    F    85_A      -       -           -
LGA    S    86_A      -       -           -
LGA    Q    87_A      -       -           -
LGA    P    88_A      -       -           -
LGA    A    89_A      -       -           -
LGA    P    90_A      -       -           -
LGA    D    91_A      G      75          3.748
LGA    R    92_A      -       -           -
LGA    D    93_A      -       -           -
LGA    A    94_A      D      76          2.281
LGA    I    95_A      P      77          2.235
LGA    R    96_A      L      78          1.070
LGA    E    97_A      A      79          0.600
LGA    L    98_A      V      80          1.632
LGA    I    99_A      M      81          1.460
LGA    L   100_A      T      82          0.636
LGA    L   101_A      A      83          0.494
LGA    A   102_A      Y      84          0.889
LGA    C   103_A      L      85          0.754
LGA    K   104_A      R      86          0.968
LGA    N   105_A      W      87          1.185
LGA    M   106_A      T      88          0.384
LGA    I   107_A      I      89          1.355
LGA    M   108_A      Q      90          2.494
LGA    L   109_A      R      91          2.175
LGA    L   110_A      H      92          2.068
LGA    T   111_A      R      93          3.549
LGA    Q   112_A      -       -           -
LGA    E   113_A      N      94           #
LGA    D   114_A      N      95          3.379
LGA    T   115_A      -       -           -
LGA    V   116_A      P      96          2.514
LGA    N   117_A      Q      97          1.959
LGA    L   118_A      L      98          2.143
LGA    S   119_A      L      99          1.355
LGA    K   120_A      R     100          0.576
LGA    F   121_A      F     101          1.194
LGA    I   122_A      Y     102          1.442
LGA    S   123_A      T     103          0.568
LGA    R   124_A      S     104          1.019
LGA    E   125_A      E     105          1.091
LGA    Q   126_A      L     106          0.677
LGA    L   127_A      T     107          1.119
LGA    S   128_A      N     108          1.695
LGA    P   129_A      P     109          1.834
LGA    T   130_A      T     110          2.294
LGA    S   131_A      P     111          1.637
LGA    A   132_A      C     112          1.294
LGA    Y   133_A      F     113          1.416
LGA    Q   134_A      A     114          1.207
LGA    L   135_A      A     115          1.780
LGA    V   136_A      I     116          2.191
LGA    H   137_A      V     117          3.525
LGA    E   138_A      S     118          4.947
LGA    Q   139_A      P     119          4.298
LGA    V   140_A      A     120          1.874
LGA    I   141_A      I     121          1.436
LGA    D   142_A      A     122          1.356
LGA    P   143_A      S     123          1.108
LGA    L   144_A      V     124          1.269
LGA    H   145_A      I     125          1.027
LGA    T   146_A      R     126          0.248
LGA    H   147_A      L     127          0.402
LGA    L   148_A      L     128          0.479
LGA    T   149_A      A     129          0.706
LGA    R   150_A      E     130          0.601
LGA    L   151_A      S     131          0.843
LGA    V   152_A      I     132          1.460
LGA    A   153_A      E     133          1.608
LGA    A   154_A      A     134          1.251
LGA    Y   155_A      G     135          1.581
LGA    T   156_A      M     136          2.774
LGA    G   157_A      T     137          2.706
LGA    -       -      R     138           -
LGA    -       -      G     139           -
LGA    -       -      L     140           -
LGA    -       -      F     141           -
LGA    -       -      R     142           -
LGA    C   158_A      R     143          4.964
LGA    D   159_A      D     144           -
LGA    A   160_A      -       -           -
LGA    N   161_A      -       -           -
LGA    D   162_A      -       -           -
LGA    T   163_A      -       -           -
LGA    R   164_A      L     145          5.537
LGA    M   165_A      H     146          2.214
LGA    -       -      A     147           -
LGA    I   166_A      V     148          1.163
LGA    L   167_A      N     149          1.158
LGA    H   168_A      S     150          1.650
LGA    T   169_A      A     151          1.353
LGA    H   170_A      L     152          0.399
LGA    A   171_A      A     153          1.386
LGA    L   172_A      L     154          1.981
LGA    L   173_A      A     155          1.327
LGA    G   174_A      G     156          0.781
LGA    E   175_A      M     157          0.732
LGA    V   176_A      V     158          0.373
LGA    L   177_A      N     159          0.565
LGA    A   178_A      Y     160          1.191
LGA    F   179_A      F     161          1.538
LGA    R   180_A      F     162          1.567
LGA    L   181_A      L     163          1.253
LGA    G   182_A      S     164          0.858
LGA    K   183_A      T     165          1.470
LGA    E   184_A      L     166          0.685
LGA    T   185_A      A     167          1.552
LGA    I   186_A      T     168          2.261
LGA    L   187_A      E     169          1.862
LGA    L   188_A      G     170          3.243
LGA    R   189_A      L     171          1.929
LGA    T   190_A      T     172          2.570
LGA    G   191_A      S     173           #
LGA    W   192_A      -       -           -
LGA    P   193_A      -       -           -
LGA    Q   194_A      -       -           -
LGA    F   195_A      H     174          4.040
LGA    D   196_A      S     175          3.692
LGA    E   197_A      P     176          2.553
LGA    E   198_A      D     177          0.394
LGA    K   199_A      Q     178          2.544
LGA    A   200_A      D     179          1.695
LGA    E   201_A      E     180          2.486
LGA    L   202_A      E     181          2.910
LGA    I   203_A      L     182          2.035
LGA    Y   204_A      I     183          1.794
LGA    Q   205_A      R     184          2.395
LGA    T   206_A      Q     185          1.943
LGA    V   207_A      Y     186          1.210
LGA    T   208_A      V     187          2.026
LGA    C   209_A      A     188          1.781
LGA    H   210_A      I     189          1.112
LGA    I   211_A      F     190          2.087
LGA    D   212_A      T     191          2.441
LGA    L   213_A      R     192          1.058
LGA    I   214_A      G     193          4.797
LGA    L   215_A      I     194           -
LGA    H   216_A      M     195           -
LGA    G   217_A      A     196           -
LGA    L   218_A      -       -           -
LGA    T   219_A      -       -           -
LGA    Q   220_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  220  192    5.0    178    2.40    19.66     64.078     7.122

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.260715 * X  +  -0.780367 * Y  +   0.568380 * Z  + -59.929428
  Y_new =  -0.963109 * X  +  -0.169566 * Y  +   0.208968 * Z  +  49.362892
  Z_new =  -0.066694 * X  +  -0.601893 * Y  +  -0.795787 * Z  +  72.904327 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.494040    0.647552  [ DEG:  -142.8980     37.1020 ]
  Theta =   0.066744    3.074849  [ DEG:     3.8241    176.1759 ]
  Phi   =  -1.306431    1.835162  [ DEG:   -74.8530    105.1470 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1t33_A                                        
REMARK     2: T0454.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1t33_A.T0454.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  220  192   5.0  178   2.40   19.66  64.078
REMARK  ---------------------------------------------------------- 
MOLECULE 1t33_A
HEADER    TRANSCRIPTION                           23-APR-04   1T33              
TITLE     STRUCTURAL GENOMICS, THE CRYSTAL STRUCTURE OF A PUTATIVE              
TITLE    2 TRANSCRIPTIONAL REPRESSOR (TETR/ACRR FAMILY) FROM                    
TITLE    3 SALMONELLA TYPHIMURIM LT2                                            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PUTATIVE TRANSCRIPTIONAL REPRESSOR (TETR/ACRR              
COMPND   3 FAMILY);                                                             
COMPND   4 CHAIN: A, B;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SALMONELLA TYPHIMURIUM;                         
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: LT2;                                                         
SOURCE   5 GENE: YBIH;                                                          
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PDM68                                     
KEYWDS    STRUCTURAL GENOMICS, TRANSCRIPTIONAL REPRESSOR, TETR/CCRR             
KEYWDS   2 FAMILY, HELIX TURN HELIX DNA BINDING DOMAIN, PSI, PROTEIN            
KEYWDS   3 STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL                  
KEYWDS   4 GENOMICS, MCSG                                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    R.ZHANG,M.ZHOU,F.COLLART,A.JOACHIMIAK,MIDWEST CENTER FOR              
AUTHOR   2 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   2   18-JAN-05 1T33    1       AUTHOR KEYWDS REMARK                     
REVDAT   1   03-AUG-04 1T33    0                                                
JRNL        AUTH   R.ZHANG,M.ZHOU,F.COLLART,A.JOACHIMIAK                        
JRNL        TITL   THE CRYSTAL STRUCTURE OF A PUTATIVE                          
JRNL        TITL 2 TRANSCRIPTIONAL REPRESSOR (TETR/ACRR FAMILY) FROM            
JRNL        TITL 3 SALMONELLA TYPHIMURIUM                                       
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.20 ANGSTROMS.                                          
DBREF  1T33 A    1   224  UNP    Q8ZQN9   Q8ZQN9_SALTY     1    224             
DBREF  1T33 B    1   224  UNP    Q8ZQN9   Q8ZQN9_SALTY     1    224             
SEQRES   1 A  224  MET ASN ILE PRO THR THR THR THR LYS GLY GLU GLN ALA          
SEQRES   2 A  224  LYS SER GLN LEU ILE ALA ALA ALA LEU ALA GLN PHE GLY          
SEQRES   3 A  224  GLU TYR GLY LEU HIS ALA THR THR ARG ASP ILE ALA ALA          
SEQRES   4 A  224  LEU ALA GLY GLN ASN ILE ALA ALA ILE THR TYR TYR PHE          
SEQRES   5 A  224  GLY SER LYS GLU ASP LEU TYR LEU ALA CYS ALA GLN TRP          
SEQRES   6 A  224  ILE ALA ASP PHE LEU GLY GLU LYS PHE ARG PRO HIS ALA          
SEQRES   7 A  224  GLU LYS ALA GLU ARG LEU PHE SER GLN PRO ALA PRO ASP          
SEQRES   8 A  224  ARG ASP ALA ILE ARG GLU LEU ILE LEU LEU ALA CYS LYS          
SEQRES   9 A  224  ASN MET ILE MET LEU LEU THR GLN GLU ASP THR VAL ASN          
SEQRES  10 A  224  LEU SER LYS PHE ILE SER ARG GLU GLN LEU SER PRO THR          
SEQRES  11 A  224  SER ALA TYR GLN LEU VAL HIS GLU GLN VAL ILE ASP PRO          
SEQRES  12 A  224  LEU HIS THR HIS LEU THR ARG LEU VAL ALA ALA TYR THR          
SEQRES  13 A  224  GLY CYS ASP ALA ASN ASP THR ARG MET ILE LEU HIS THR          
SEQRES  14 A  224  HIS ALA LEU LEU GLY GLU VAL LEU ALA PHE ARG LEU GLY          
SEQRES  15 A  224  LYS GLU THR ILE LEU LEU ARG THR GLY TRP PRO GLN PHE          
SEQRES  16 A  224  ASP GLU GLU LYS ALA GLU LEU ILE TYR GLN THR VAL THR          
SEQRES  17 A  224  CYS HIS ILE ASP LEU ILE LEU HIS GLY LEU THR GLN ARG          
SEQRES  18 A  224  SER LEU ASP                                                  
SEQRES   1 B  224  MET ASN ILE PRO THR THR THR THR LYS GLY GLU GLN ALA          
SEQRES   2 B  224  LYS SER GLN LEU ILE ALA ALA ALA LEU ALA GLN PHE GLY          
SEQRES   3 B  224  GLU TYR GLY LEU HIS ALA THR THR ARG ASP ILE ALA ALA          
SEQRES   4 B  224  LEU ALA GLY GLN ASN ILE ALA ALA ILE THR TYR TYR PHE          
SEQRES   5 B  224  GLY SER LYS GLU ASP LEU TYR LEU ALA CYS ALA GLN TRP          
SEQRES   6 B  224  ILE ALA ASP PHE LEU GLY GLU LYS PHE ARG PRO HIS ALA          
SEQRES   7 B  224  GLU LYS ALA GLU ARG LEU PHE SER GLN PRO ALA PRO ASP          
SEQRES   8 B  224  ARG ASP ALA ILE ARG GLU LEU ILE LEU LEU ALA CYS LYS          
SEQRES   9 B  224  ASN MET ILE MET LEU LEU THR GLN GLU ASP THR VAL ASN          
SEQRES  10 B  224  LEU SER LYS PHE ILE SER ARG GLU GLN LEU SER PRO THR          
SEQRES  11 B  224  SER ALA TYR GLN LEU VAL HIS GLU GLN VAL ILE ASP PRO          
SEQRES  12 B  224  LEU HIS THR HIS LEU THR ARG LEU VAL ALA ALA TYR THR          
SEQRES  13 B  224  GLY CYS ASP ALA ASN ASP THR ARG MET ILE LEU HIS THR          
SEQRES  14 B  224  HIS ALA LEU LEU GLY GLU VAL LEU ALA PHE ARG LEU GLY          
SEQRES  15 B  224  LYS GLU THR ILE LEU LEU ARG THR GLY TRP PRO GLN PHE          
SEQRES  16 B  224  ASP GLU GLU LYS ALA GLU LEU ILE TYR GLN THR VAL THR          
SEQRES  17 B  224  CYS HIS ILE ASP LEU ILE LEU HIS GLY LEU THR GLN ARG          
SEQRES  18 B  224  SER LEU ASP                                                  
FORMUL   3  HOH   *194(H2 O)                                                    
CRYST1  110.630  122.192  108.991  90.00  90.00  90.00 C 2 2 21     16          
ATOM      1  N   MET A   1     -25.689  30.365 -12.077  1.00 50.19           N  
ATOM      2  CA  MET A   1     -24.569  30.040 -11.118  1.00 52.44           C  
ATOM      3  C   MET A   1     -23.301  30.839 -11.482  1.00 53.25           C  
ATOM      4  O   MET A   1     -22.395  31.012 -10.646  1.00 53.05           O  
ATOM      5  CB  MET A   1     -24.273  28.523 -11.144  1.00 51.93           C  
ATOM      6  CG  MET A   1     -23.811  27.919  -9.787  1.00 52.76           C  
ATOM      7  SD  MET A   1     -25.012  28.160  -8.387  1.00 49.26           S  
ATOM      8  CE  MET A   1     -24.311  29.735  -7.755  1.00 51.16           C  
ATOM      9  N   ASN A   2     -23.248  31.316 -12.729  1.00 54.68           N  
ATOM     10  CA  ASN A   2     -22.132  32.117 -13.234  1.00 55.23           C  
ATOM     11  C   ASN A   2     -20.829  31.371 -13.523  1.00 54.73           C  
ATOM     12  O   ASN A   2     -20.800  30.143 -13.663  1.00 54.42           O  
ATOM     13  CB  ASN A   2     -21.832  33.280 -12.272  1.00 56.21           C  
ATOM     14  CG  ASN A   2     -22.246  34.630 -12.835  1.00 56.35           C  
ATOM     15  OD1 ASN A   2     -23.344  35.126 -12.561  1.00 55.93           O  
ATOM     16  ND2 ASN A   2     -21.370  35.227 -13.636  1.00 54.71           N  
ATOM     17  N   ILE A   3     -19.755  32.160 -13.601  1.00 53.71           N  
ATOM     18  CA  ILE A   3     -18.399  31.690 -13.882  1.00 52.04           C  
ATOM     19  C   ILE A   3     -17.816  30.824 -12.759  1.00 50.26           C  
ATOM     20  O   ILE A   3     -17.791  31.230 -11.594  1.00 50.20           O  
ATOM     21  CB  ILE A   3     -17.456  32.895 -14.130  1.00 51.86           C  
ATOM     22  CG1 ILE A   3     -18.061  33.813 -15.195  1.00 51.48           C  
ATOM     23  CG2 ILE A   3     -16.085  32.412 -14.585  1.00 50.96           C  
ATOM     24  CD1 ILE A   3     -17.297  35.100 -15.385  1.00 51.40           C  
ATOM     25  N   PRO A   4     -17.333  29.618 -13.109  1.00 49.17           N  
ATOM     26  CA  PRO A   4     -16.735  28.634 -12.197  1.00 48.29           C  
ATOM     27  C   PRO A   4     -15.530  29.108 -11.387  1.00 48.53           C  
ATOM     28  O   PRO A   4     -14.641  29.810 -11.885  1.00 47.26           O  
ATOM     29  CB  PRO A   4     -16.369  27.479 -13.124  1.00 48.15           C  
ATOM     30  CG  PRO A   4     -17.401  27.566 -14.187  1.00 48.06           C  
ATOM     31  CD  PRO A   4     -17.465  29.048 -14.461  1.00 48.29           C  
ATOM     32  N   THR A   5     -15.519  28.690 -10.127  1.00 48.71           N  
ATOM     33  CA  THR A   5     -14.465  29.013  -9.184  1.00 48.59           C  
ATOM     34  C   THR A   5     -13.285  28.059  -9.389  1.00 48.28           C  
ATOM     35  O   THR A   5     -13.472  26.896  -9.741  1.00 48.72           O  
ATOM     36  CB  THR A   5     -15.006  28.895  -7.743  1.00 49.19           C  
ATOM     37  OG1 THR A   5     -15.972  29.931  -7.515  1.00 49.83           O  
ATOM     38  CG2 THR A   5     -13.888  29.019  -6.729  1.00 51.81           C  
ATOM     39  N   THR A   6     -12.071  28.559  -9.171  1.00 48.61           N  
ATOM     40  CA  THR A   6     -10.863  27.751  -9.342  1.00 48.80           C  
ATOM     41  C   THR A   6     -10.181  27.382  -8.018  1.00 48.70           C  
ATOM     42  O   THR A   6      -9.344  26.484  -7.983  1.00 49.73           O  
ATOM     43  CB  THR A   6      -9.829  28.479 -10.235  1.00 47.80           C  
ATOM     44  OG1 THR A   6      -9.375  29.665  -9.577  1.00 49.34           O  
ATOM     45  CG2 THR A   6     -10.455  28.872 -11.559  1.00 48.70           C  
ATOM     46  N   THR A   7     -10.537  28.068  -6.934  1.00 48.21           N  
ATOM     47  CA  THR A   7      -9.938  27.783  -5.635  1.00 47.16           C  
ATOM     48  C   THR A   7     -10.975  27.427  -4.570  1.00 47.64           C  
ATOM     49  O   THR A   7     -12.178  27.624  -4.766  1.00 46.74           O  
ATOM     50  CB  THR A   7      -9.100  28.981  -5.130  1.00 47.33           C  
ATOM     51  OG1 THR A   7      -9.943  30.125  -4.959  1.00 45.43           O  
ATOM     52  CG2 THR A   7      -7.999  29.313  -6.123  1.00 46.74           C  
ATOM     53  N   THR A   8     -10.494  26.891  -3.450  1.00 47.87           N  
ATOM     54  CA  THR A   8     -11.353  26.502  -2.336  1.00 48.21           C  
ATOM     55  C   THR A   8     -11.853  27.749  -1.634  1.00 47.34           C  
ATOM     56  O   THR A   8     -12.987  27.796  -1.176  1.00 47.98           O  
ATOM     57  CB  THR A   8     -10.595  25.622  -1.304  1.00 49.81           C  
ATOM     58  OG1 THR A   8     -10.294  24.344  -1.881  1.00 52.47           O  
ATOM     59  CG2 THR A   8     -11.437  25.404  -0.061  1.00 51.27           C  
ATOM     60  N   LYS A   9     -10.997  28.759  -1.545  1.00 46.97           N  
ATOM     61  CA  LYS A   9     -11.380  30.005  -0.903  1.00 47.72           C  
ATOM     62  C   LYS A   9     -12.500  30.686  -1.669  1.00 47.40           C  
ATOM     63  O   LYS A   9     -13.449  31.203  -1.071  1.00 47.43           O  
ATOM     64  CB  LYS A   9     -10.185  30.949  -0.808  1.00 50.53           C  
ATOM     65  CG  LYS A   9      -9.307  30.696   0.397  1.00 53.44           C  
ATOM     66  CD  LYS A   9      -8.351  31.855   0.620  1.00 56.19           C  
ATOM     67  CE  LYS A   9      -7.941  31.940   2.090  1.00 58.40           C  
ATOM     68  NZ  LYS A   9      -9.131  32.099   2.993  1.00 58.87           N  
ATOM     69  N   GLY A  10     -12.378  30.690  -2.994  1.00 46.42           N  
ATOM     70  CA  GLY A  10     -13.386  31.306  -3.836  1.00 45.34           C  
ATOM     71  C   GLY A  10     -14.695  30.545  -3.776  1.00 44.46           C  
ATOM     72  O   GLY A  10     -15.771  31.138  -3.690  1.00 42.73           O  
ATOM     73  N   GLU A  11     -14.603  29.221  -3.814  1.00 44.44           N  
ATOM     74  CA  GLU A  11     -15.785  28.371  -3.763  1.00 44.72           C  
ATOM     75  C   GLU A  11     -16.478  28.508  -2.404  1.00 42.80           C  
ATOM     76  O   GLU A  11     -17.697  28.441  -2.309  1.00 42.04           O  
ATOM     77  CB  GLU A  11     -15.372  26.922  -4.032  1.00 47.54           C  
ATOM     78  CG  GLU A  11     -16.510  25.919  -4.090  1.00 54.44           C  
ATOM     79  CD  GLU A  11     -17.062  25.555  -2.712  1.00 60.13           C  
ATOM     80  OE1 GLU A  11     -16.251  25.294  -1.786  1.00 62.58           O  
ATOM     81  OE2 GLU A  11     -18.310  25.515  -2.558  1.00 62.45           O  
ATOM     82  N   GLN A  12     -15.694  28.721  -1.356  1.00 42.68           N  
ATOM     83  CA  GLN A  12     -16.227  28.877  -0.008  1.00 43.11           C  
ATOM     84  C   GLN A  12     -17.009  30.180   0.132  1.00 41.66           C  
ATOM     85  O   GLN A  12     -18.180  30.181   0.518  1.00 41.62           O  
ATOM     86  CB  GLN A  12     -15.081  28.868   1.001  1.00 47.06           C  
ATOM     87  CG  GLN A  12     -15.486  29.242   2.418  1.00 54.10           C  
ATOM     88  CD  GLN A  12     -16.237  28.124   3.130  1.00 58.89           C  
ATOM     89  OE1 GLN A  12     -17.301  27.680   2.679  1.00 61.86           O  
ATOM     90  NE2 GLN A  12     -15.684  27.663   4.251  1.00 60.60           N  
ATOM     91  N   ALA A  13     -16.344  31.287  -0.179  1.00 39.64           N  
ATOM     92  CA  ALA A  13     -16.950  32.612  -0.095  1.00 38.97           C  
ATOM     93  C   ALA A  13     -18.205  32.737  -0.973  1.00 38.45           C  
ATOM     94  O   ALA A  13     -19.218  33.320  -0.563  1.00 37.51           O  
ATOM     95  CB  ALA A  13     -15.924  33.667  -0.494  1.00 37.76           C  
ATOM     96  N   LYS A  14     -18.124  32.188  -2.182  1.00 37.70           N  
ATOM     97  CA  LYS A  14     -19.231  32.228  -3.126  1.00 37.71           C  
ATOM     98  C   LYS A  14     -20.425  31.494  -2.535  1.00 37.46           C  
ATOM     99  O   LYS A  14     -21.567  31.927  -2.688  1.00 37.83           O  
ATOM    100  CB  LYS A  14     -18.800  31.584  -4.451  1.00 38.78           C  
ATOM    101  CG  LYS A  14     -19.786  31.733  -5.603  1.00 39.91           C  
ATOM    102  CD  LYS A  14     -19.161  31.271  -6.920  1.00 40.43           C  
ATOM    103  CE  LYS A  14     -20.140  31.389  -8.081  1.00 42.78           C  
ATOM    104  NZ  LYS A  14     -19.555  30.919  -9.372  1.00 44.06           N  
ATOM    105  N   SER A  15     -20.153  30.386  -1.849  1.00 37.13           N  
ATOM    106  CA  SER A  15     -21.209  29.595  -1.226  1.00 37.05           C  
ATOM    107  C   SER A  15     -21.846  30.313  -0.051  1.00 35.88           C  
ATOM    108  O   SER A  15     -23.049  30.194   0.173  1.00 36.63           O  
ATOM    109  CB  SER A  15     -20.668  28.252  -0.751  1.00 37.85           C  
ATOM    110  OG  SER A  15     -20.417  27.408  -1.855  1.00 42.08           O  
ATOM    111  N   GLN A  16     -21.046  31.048   0.708  1.00 34.16           N  
ATOM    112  CA  GLN A  16     -21.588  31.775   1.842  1.00 33.89           C  
ATOM    113  C   GLN A  16     -22.434  32.948   1.379  1.00 32.37           C  
ATOM    114  O   GLN A  16     -23.363  33.356   2.066  1.00 32.53           O  
ATOM    115  CB  GLN A  16     -20.469  32.295   2.720  1.00 35.80           C  
ATOM    116  CG  GLN A  16     -19.495  31.244   3.137  1.00 38.86           C  
ATOM    117  CD  GLN A  16     -18.423  31.828   4.007  1.00 41.45           C  
ATOM    118  OE1 GLN A  16     -17.921  32.925   3.740  1.00 43.73           O  
ATOM    119  NE2 GLN A  16     -18.056  31.108   5.055  1.00 42.90           N  
ATOM    120  N   LEU A  17     -22.096  33.503   0.220  1.00 30.73           N  
ATOM    121  CA  LEU A  17     -22.844  34.629  -0.318  1.00 29.26           C  
ATOM    122  C   LEU A  17     -24.204  34.154  -0.805  1.00 28.06           C  
ATOM    123  O   LEU A  17     -25.185  34.885  -0.730  1.00 28.72           O  
ATOM    124  CB  LEU A  17     -22.066  35.299  -1.455  1.00 29.36           C  
ATOM    125  CG  LEU A  17     -20.963  36.271  -1.020  1.00 28.95           C  
ATOM    126  CD1 LEU A  17     -20.081  36.603  -2.210  1.00 29.35           C  
ATOM    127  CD2 LEU A  17     -21.584  37.535  -0.427  1.00 25.37           C  
ATOM    128  N   ILE A  18     -24.264  32.925  -1.301  1.00 27.43           N  
ATOM    129  CA  ILE A  18     -25.528  32.362  -1.763  1.00 27.91           C  
ATOM    130  C   ILE A  18     -26.422  31.997  -0.570  1.00 27.98           C  
ATOM    131  O   ILE A  18     -27.637  32.200  -0.607  1.00 28.27           O  
ATOM    132  CB  ILE A  18     -25.266  31.137  -2.649  1.00 28.20           C  
ATOM    133  CG1 ILE A  18     -24.798  31.626  -4.016  1.00 28.23           C  
ATOM    134  CG2 ILE A  18     -26.511  30.271  -2.769  1.00 28.05           C  
ATOM    135  CD1 ILE A  18     -24.264  30.550  -4.877  1.00 29.75           C  
ATOM    136  N   ALA A  19     -25.811  31.480   0.493  1.00 27.79           N  
ATOM    137  CA  ALA A  19     -26.544  31.126   1.705  1.00 27.00           C  
ATOM    138  C   ALA A  19     -27.196  32.387   2.257  1.00 26.75           C  
ATOM    139  O   ALA A  19     -28.389  32.389   2.576  1.00 27.86           O  
ATOM    140  CB  ALA A  19     -25.594  30.537   2.741  1.00 27.02           C  
ATOM    141  N   ALA A  20     -26.406  33.457   2.362  1.00 25.00           N  
ATOM    142  CA  ALA A  20     -26.883  34.747   2.860  1.00 23.65           C  
ATOM    143  C   ALA A  20     -27.956  35.319   1.940  1.00 23.99           C  
ATOM    144  O   ALA A  20     -28.966  35.848   2.405  1.00 24.33           O  
ATOM    145  CB  ALA A  20     -25.724  35.725   2.966  1.00 24.33           C  
ATOM    146  N   ALA A  21     -27.730  35.212   0.632  1.00 23.41           N  
ATOM    147  CA  ALA A  21     -28.679  35.713  -0.355  1.00 23.59           C  
ATOM    148  C   ALA A  21     -30.000  34.952  -0.261  1.00 24.20           C  
ATOM    149  O   ALA A  21     -31.064  35.551  -0.360  1.00 24.65           O  
ATOM    150  CB  ALA A  21     -28.100  35.591  -1.757  1.00 21.84           C  
ATOM    151  N   LEU A  22     -29.943  33.636  -0.076  1.00 25.26           N  
ATOM    152  CA  LEU A  22     -31.175  32.860   0.048  1.00 26.08           C  
ATOM    153  C   LEU A  22     -31.987  33.367   1.241  1.00 25.84           C  
ATOM    154  O   LEU A  22     -33.213  33.477   1.176  1.00 25.69           O  
ATOM    155  CB  LEU A  22     -30.854  31.370   0.215  1.00 26.99           C  
ATOM    156  CG  LEU A  22     -30.580  30.612  -1.086  1.00 27.64           C  
ATOM    157  CD1 LEU A  22     -30.010  29.244  -0.794  1.00 29.81           C  
ATOM    158  CD2 LEU A  22     -31.872  30.477  -1.867  1.00 28.55           C  
ATOM    159  N   ALA A  23     -31.287  33.690   2.325  1.00 25.46           N  
ATOM    160  CA  ALA A  23     -31.912  34.197   3.541  1.00 26.36           C  
ATOM    161  C   ALA A  23     -32.570  35.558   3.308  1.00 28.25           C  
ATOM    162  O   ALA A  23     -33.752  35.753   3.611  1.00 31.39           O  
ATOM    163  CB  ALA A  23     -30.866  34.312   4.649  1.00 23.55           C  
ATOM    164  N   GLN A  24     -31.796  36.498   2.771  1.00 28.30           N  
ATOM    165  CA  GLN A  24     -32.273  37.850   2.495  1.00 26.95           C  
ATOM    166  C   GLN A  24     -33.329  37.916   1.393  1.00 26.59           C  
ATOM    167  O   GLN A  24     -34.363  38.555   1.566  1.00 26.59           O  
ATOM    168  CB  GLN A  24     -31.087  38.739   2.134  1.00 27.54           C  
ATOM    169  CG  GLN A  24     -30.184  39.065   3.311  1.00 28.72           C  
ATOM    170  CD  GLN A  24     -30.762  40.161   4.195  1.00 31.93           C  
ATOM    171  OE1 GLN A  24     -31.015  41.281   3.733  1.00 33.24           O  
ATOM    172  NE2 GLN A  24     -30.977  39.847   5.470  1.00 32.93           N  
ATOM    173  N   PHE A  25     -33.066  37.274   0.258  1.00 26.04           N  
ATOM    174  CA  PHE A  25     -34.024  37.265  -0.847  1.00 27.12           C  
ATOM    175  C   PHE A  25     -35.278  36.513  -0.423  1.00 27.58           C  
ATOM    176  O   PHE A  25     -36.393  36.905  -0.763  1.00 27.71           O  
ATOM    177  CB  PHE A  25     -33.441  36.577  -2.096  1.00 26.90           C  
ATOM    178  CG  PHE A  25     -32.390  37.386  -2.827  1.00 26.62           C  
ATOM    179  CD1 PHE A  25     -32.509  38.770  -2.961  1.00 26.42           C  
ATOM    180  CD2 PHE A  25     -31.307  36.750  -3.432  1.00 26.35           C  
ATOM    181  CE1 PHE A  25     -31.565  39.509  -3.689  1.00 26.28           C  
ATOM    182  CE2 PHE A  25     -30.359  37.481  -4.164  1.00 25.56           C  
ATOM    183  CZ  PHE A  25     -30.491  38.859  -4.292  1.00 24.39           C  
ATOM    184  N   GLY A  26     -35.090  35.422   0.313  1.00 27.89           N  
ATOM    185  CA  GLY A  26     -36.224  34.640   0.766  1.00 29.91           C  
ATOM    186  C   GLY A  26     -37.175  35.475   1.598  1.00 30.90           C  
ATOM    187  O   GLY A  26     -38.391  35.361   1.480  1.00 31.07           O  
ATOM    188  N   GLU A  27     -36.612  36.345   2.424  1.00 32.79           N  
ATOM    189  CA  GLU A  27     -37.402  37.192   3.306  1.00 34.30           C  
ATOM    190  C   GLU A  27     -37.850  38.533   2.721  1.00 33.84           C  
ATOM    191  O   GLU A  27     -38.967  38.972   2.990  1.00 35.21           O  
ATOM    192  CB  GLU A  27     -36.610  37.430   4.596  1.00 36.10           C  
ATOM    193  CG  GLU A  27     -37.389  38.062   5.737  1.00 41.49           C  
ATOM    194  CD  GLU A  27     -38.546  37.202   6.229  1.00 42.91           C  
ATOM    195  OE1 GLU A  27     -38.361  35.974   6.393  1.00 42.42           O  
ATOM    196  OE2 GLU A  27     -39.638  37.766   6.467  1.00 45.93           O  
ATOM    197  N   TYR A  28     -37.001  39.175   1.917  1.00 31.79           N  
ATOM    198  CA  TYR A  28     -37.332  40.491   1.364  1.00 29.84           C  
ATOM    199  C   TYR A  28     -37.401  40.612  -0.146  1.00 28.63           C  
ATOM    200  O   TYR A  28     -37.720  41.679  -0.661  1.00 27.56           O  
ATOM    201  CB  TYR A  28     -36.339  41.541   1.877  1.00 29.91           C  
ATOM    202  CG  TYR A  28     -36.165  41.525   3.374  1.00 31.65           C  
ATOM    203  CD1 TYR A  28     -37.227  41.845   4.224  1.00 31.84           C  
ATOM    204  CD2 TYR A  28     -34.958  41.131   3.949  1.00 31.36           C  
ATOM    205  CE1 TYR A  28     -37.092  41.764   5.609  1.00 33.84           C  
ATOM    206  CE2 TYR A  28     -34.811  41.048   5.330  1.00 33.55           C  
ATOM    207  CZ  TYR A  28     -35.882  41.362   6.154  1.00 33.97           C  
ATOM    208  OH  TYR A  28     -35.745  41.256   7.519  1.00 36.90           O  
ATOM    209  N   GLY A  29     -37.103  39.536  -0.864  1.00 28.15           N  
ATOM    210  CA  GLY A  29     -37.141  39.616  -2.314  1.00 25.77           C  
ATOM    211  C   GLY A  29     -35.997  40.478  -2.798  1.00 25.83           C  
ATOM    212  O   GLY A  29     -34.931  40.497  -2.174  1.00 25.26           O  
ATOM    213  N   LEU A  30     -36.208  41.205  -3.892  1.00 25.97           N  
ATOM    214  CA  LEU A  30     -35.154  42.053  -4.442  1.00 27.02           C  
ATOM    215  C   LEU A  30     -34.935  43.379  -3.707  1.00 27.64           C  
ATOM    216  O   LEU A  30     -34.135  44.202  -4.143  1.00 27.73           O  
ATOM    217  CB  LEU A  30     -35.384  42.295  -5.943  1.00 25.23           C  
ATOM    218  CG  LEU A  30     -35.021  41.094  -6.841  1.00 25.95           C  
ATOM    219  CD1 LEU A  30     -35.465  41.371  -8.249  1.00 26.28           C  
ATOM    220  CD2 LEU A  30     -33.524  40.820  -6.817  1.00 24.09           C  
ATOM    221  N   HIS A  31     -35.640  43.574  -2.591  1.00 28.49           N  
ATOM    222  CA  HIS A  31     -35.493  44.775  -1.768  1.00 27.31           C  
ATOM    223  C   HIS A  31     -34.320  44.537  -0.836  1.00 27.37           C  
ATOM    224  O   HIS A  31     -33.858  45.447  -0.157  1.00 28.61           O  
ATOM    225  CB  HIS A  31     -36.749  45.030  -0.941  1.00 27.13           C  
ATOM    226  CG  HIS A  31     -37.691  46.006  -1.564  1.00 28.23           C  
ATOM    227  ND1 HIS A  31     -37.897  46.077  -2.926  1.00 29.23           N  
ATOM    228  CD2 HIS A  31     -38.501  46.942  -1.008  1.00 29.49           C  
ATOM    229  CE1 HIS A  31     -38.791  47.016  -3.184  1.00 30.19           C  
ATOM    230  NE2 HIS A  31     -39.173  47.555  -2.037  1.00 30.72           N  
ATOM    231  N   ALA A  32     -33.857  43.294  -0.790  1.00 27.83           N  
ATOM    232  CA  ALA A  32     -32.707  42.946   0.032  1.00 27.90           C  
ATOM    233  C   ALA A  32     -31.534  43.701  -0.590  1.00 28.11           C  
ATOM    234  O   ALA A  32     -31.451  43.817  -1.817  1.00 27.94           O  
ATOM    235  CB  ALA A  32     -32.455  41.443  -0.021  1.00 27.84           C  
ATOM    236  N   THR A  33     -30.641  44.228   0.240  1.00 27.65           N  
ATOM    237  CA  THR A  33     -29.502  44.975  -0.284  1.00 27.71           C  
ATOM    238  C   THR A  33     -28.255  44.112  -0.345  1.00 29.01           C  
ATOM    239  O   THR A  33     -28.093  43.179   0.452  1.00 28.33           O  
ATOM    240  CB  THR A  33     -29.179  46.219   0.581  1.00 26.46           C  
ATOM    241  OG1 THR A  33     -28.826  45.803   1.905  1.00 26.54           O  
ATOM    242  CG2 THR A  33     -30.371  47.149   0.644  1.00 25.21           C  
ATOM    243  N   THR A  34     -27.376  44.421  -1.296  1.00 29.45           N  
ATOM    244  CA  THR A  34     -26.127  43.686  -1.436  1.00 30.00           C  
ATOM    245  C   THR A  34     -25.242  43.935  -0.209  1.00 31.50           C  
ATOM    246  O   THR A  34     -24.447  43.077   0.181  1.00 30.42           O  
ATOM    247  CB  THR A  34     -25.384  44.112  -2.695  1.00 29.11           C  
ATOM    248  OG1 THR A  34     -25.392  45.539  -2.785  1.00 31.20           O  
ATOM    249  CG2 THR A  34     -26.051  43.531  -3.910  1.00 28.88           C  
ATOM    250  N   ARG A  35     -25.387  45.106   0.407  1.00 33.83           N  
ATOM    251  CA  ARG A  35     -24.601  45.414   1.595  1.00 36.42           C  
ATOM    252  C   ARG A  35     -24.971  44.451   2.719  1.00 35.37           C  
ATOM    253  O   ARG A  35     -24.099  43.907   3.394  1.00 35.93           O  
ATOM    254  CB  ARG A  35     -24.841  46.856   2.055  1.00 40.27           C  
ATOM    255  CG  ARG A  35     -23.849  47.308   3.128  1.00 46.03           C  
ATOM    256  CD  ARG A  35     -24.100  48.734   3.616  1.00 50.89           C  
ATOM    257  NE  ARG A  35     -25.355  48.860   4.358  1.00 56.34           N  
ATOM    258  CZ  ARG A  35     -25.654  48.185   5.469  1.00 58.66           C  
ATOM    259  NH1 ARG A  35     -24.786  47.319   5.987  1.00 59.55           N  
ATOM    260  NH2 ARG A  35     -26.826  48.379   6.071  1.00 58.83           N  
ATOM    261  N   ASP A  36     -26.271  44.242   2.908  1.00 34.24           N  
ATOM    262  CA  ASP A  36     -26.763  43.339   3.946  1.00 33.02           C  
ATOM    263  C   ASP A  36     -26.371  41.898   3.661  1.00 30.84           C  
ATOM    264  O   ASP A  36     -25.968  41.169   4.567  1.00 29.68           O  
ATOM    265  CB  ASP A  36     -28.286  43.431   4.053  1.00 36.12           C  
ATOM    266  CG  ASP A  36     -28.756  44.785   4.558  1.00 39.15           C  
ATOM    267  OD1 ASP A  36     -27.901  45.680   4.778  1.00 41.09           O  
ATOM    268  OD2 ASP A  36     -29.986  44.952   4.733  1.00 40.82           O  
ATOM    269  N   ILE A  37     -26.501  41.488   2.402  1.00 28.19           N  
ATOM    270  CA  ILE A  37     -26.146  40.134   2.002  1.00 26.03           C  
ATOM    271  C   ILE A  37     -24.656  39.894   2.213  1.00 27.82           C  
ATOM    272  O   ILE A  37     -24.263  38.849   2.724  1.00 29.26           O  
ATOM    273  CB  ILE A  37     -26.486  39.871   0.527  1.00 23.36           C  
ATOM    274  CG1 ILE A  37     -27.999  39.945   0.317  1.00 20.88           C  
ATOM    275  CG2 ILE A  37     -25.955  38.512   0.115  1.00 22.16           C  
ATOM    276  CD1 ILE A  37     -28.414  39.828  -1.123  1.00 18.17           C  
ATOM    277  N   ALA A  38     -23.829  40.860   1.816  1.00 28.90           N  
ATOM    278  CA  ALA A  38     -22.376  40.749   1.980  1.00 29.20           C  
ATOM    279  C   ALA A  38     -22.031  40.712   3.466  1.00 29.45           C  
ATOM    280  O   ALA A  38     -21.311  39.825   3.927  1.00 29.56           O  
ATOM    281  CB  ALA A  38     -21.679  41.931   1.320  1.00 28.03           C  
ATOM    282  N   ALA A  39     -22.548  41.685   4.208  1.00 29.80           N  
ATOM    283  CA  ALA A  39     -22.313  41.765   5.645  1.00 30.20           C  
ATOM    284  C   ALA A  39     -22.639  40.426   6.298  1.00 31.44           C  
ATOM    285  O   ALA A  39     -21.852  39.892   7.072  1.00 32.06           O  
ATOM    286  CB  ALA A  39     -23.177  42.865   6.249  1.00 28.95           C  
ATOM    287  N   LEU A  40     -23.807  39.884   5.966  1.00 33.73           N  
ATOM    288  CA  LEU A  40     -24.271  38.612   6.513  1.00 33.96           C  
ATOM    289  C   LEU A  40     -23.391  37.423   6.134  1.00 34.44           C  
ATOM    290  O   LEU A  40     -23.208  36.503   6.929  1.00 35.30           O  
ATOM    291  CB  LEU A  40     -25.706  38.356   6.051  1.00 33.51           C  
ATOM    292  CG  LEU A  40     -26.388  37.086   6.546  1.00 32.87           C  
ATOM    293  CD1 LEU A  40     -26.440  37.072   8.071  1.00 33.24           C  
ATOM    294  CD2 LEU A  40     -27.784  37.040   5.964  1.00 32.40           C  
ATOM    295  N   ALA A  41     -22.853  37.443   4.918  1.00 35.21           N  
ATOM    296  CA  ALA A  41     -21.998  36.362   4.431  1.00 35.39           C  
ATOM    297  C   ALA A  41     -20.554  36.531   4.890  1.00 35.94           C  
ATOM    298  O   ALA A  41     -19.711  35.667   4.639  1.00 36.47           O  
ATOM    299  CB  ALA A  41     -22.059  36.301   2.904  1.00 34.36           C  
ATOM    300  N   GLY A  42     -20.271  37.647   5.557  1.00 36.76           N  
ATOM    301  CA  GLY A  42     -18.923  37.905   6.028  1.00 38.52           C  
ATOM    302  C   GLY A  42     -17.960  38.160   4.886  1.00 40.05           C  
ATOM    303  O   GLY A  42     -16.765  37.881   4.992  1.00 41.62           O  
ATOM    304  N   GLN A  43     -18.494  38.682   3.786  1.00 40.19           N  
ATOM    305  CA  GLN A  43     -17.704  38.986   2.598  1.00 39.89           C  
ATOM    306  C   GLN A  43     -17.791  40.476   2.328  1.00 39.56           C  
ATOM    307  O   GLN A  43     -18.578  41.187   2.957  1.00 38.96           O  
ATOM    308  CB  GLN A  43     -18.252  38.245   1.376  1.00 40.29           C  
ATOM    309  CG  GLN A  43     -18.293  36.742   1.505  1.00 41.52           C  
ATOM    310  CD  GLN A  43     -16.936  36.183   1.800  1.00 42.56           C  
ATOM    311  OE1 GLN A  43     -15.936  36.691   1.301  1.00 44.16           O  
ATOM    312  NE2 GLN A  43     -16.884  35.129   2.607  1.00 44.00           N  
ATOM    313  N   ASN A  44     -16.980  40.950   1.391  1.00 40.08           N  
ATOM    314  CA  ASN A  44     -17.014  42.357   1.033  1.00 39.56           C  
ATOM    315  C   ASN A  44     -18.087  42.514  -0.041  1.00 38.36           C  
ATOM    316  O   ASN A  44     -18.454  41.548  -0.704  1.00 38.60           O  
ATOM    317  CB  ASN A  44     -15.667  42.813   0.481  1.00 42.44           C  
ATOM    318  CG  ASN A  44     -15.656  44.294   0.171  1.00 46.76           C  
ATOM    319  OD1 ASN A  44     -15.728  45.129   1.078  1.00 50.43           O  
ATOM    320  ND2 ASN A  44     -15.592  44.634  -1.112  1.00 47.82           N  
ATOM    321  N   ILE A  45     -18.589  43.726  -0.224  1.00 36.50           N  
ATOM    322  CA  ILE A  45     -19.619  43.937  -1.223  1.00 33.73           C  
ATOM    323  C   ILE A  45     -19.058  43.817  -2.645  1.00 33.44           C  
ATOM    324  O   ILE A  45     -19.806  43.588  -3.601  1.00 33.33           O  
ATOM    325  CB  ILE A  45     -20.297  45.308  -1.018  1.00 33.60           C  
ATOM    326  CG1 ILE A  45     -21.671  45.303  -1.669  1.00 33.18           C  
ATOM    327  CG2 ILE A  45     -19.451  46.418  -1.618  1.00 33.79           C  
ATOM    328  CD1 ILE A  45     -22.577  46.378  -1.136  1.00 35.78           C  
ATOM    329  N   ALA A  46     -17.740  43.961  -2.786  1.00 31.39           N  
ATOM    330  CA  ALA A  46     -17.111  43.852  -4.099  1.00 28.86           C  
ATOM    331  C   ALA A  46     -17.049  42.388  -4.530  1.00 28.34           C  
ATOM    332  O   ALA A  46     -16.920  42.082  -5.719  1.00 28.48           O  
ATOM    333  CB  ALA A  46     -15.723  44.443  -4.068  1.00 26.56           C  
ATOM    334  N   ALA A  47     -17.148  41.484  -3.559  1.00 27.04           N  
ATOM    335  CA  ALA A  47     -17.115  40.053  -3.848  1.00 26.38           C  
ATOM    336  C   ALA A  47     -18.357  39.662  -4.644  1.00 25.88           C  
ATOM    337  O   ALA A  47     -18.305  38.781  -5.505  1.00 25.23           O  
ATOM    338  CB  ALA A  47     -17.050  39.249  -2.550  1.00 26.80           C  
ATOM    339  N   ILE A  48     -19.477  40.316  -4.350  1.00 25.19           N  
ATOM    340  CA  ILE A  48     -20.710  40.032  -5.065  1.00 24.57           C  
ATOM    341  C   ILE A  48     -20.552  40.451  -6.534  1.00 24.38           C  
ATOM    342  O   ILE A  48     -20.939  39.714  -7.450  1.00 22.73           O  
ATOM    343  CB  ILE A  48     -21.912  40.755  -4.413  1.00 23.69           C  
ATOM    344  CG1 ILE A  48     -22.183  40.154  -3.026  1.00 22.81           C  
ATOM    345  CG2 ILE A  48     -23.139  40.615  -5.289  1.00 21.93           C  
ATOM    346  CD1 ILE A  48     -23.388  40.734  -2.314  1.00 20.52           C  
ATOM    347  N   THR A  49     -19.962  41.622  -6.757  1.00 24.06           N  
ATOM    348  CA  THR A  49     -19.738  42.095  -8.114  1.00 23.67           C  
ATOM    349  C   THR A  49     -18.840  41.120  -8.868  1.00 23.25           C  
ATOM    350  O   THR A  49     -19.135  40.756 -10.003  1.00 21.90           O  
ATOM    351  CB  THR A  49     -19.068  43.467  -8.123  1.00 24.11           C  
ATOM    352  OG1 THR A  49     -19.904  44.404  -7.441  1.00 25.58           O  
ATOM    353  CG2 THR A  49     -18.858  43.949  -9.558  1.00 24.29           C  
ATOM    354  N   TYR A  50     -17.755  40.687  -8.226  1.00 23.76           N  
ATOM    355  CA  TYR A  50     -16.808  39.771  -8.863  1.00 25.53           C  
ATOM    356  C   TYR A  50     -17.364  38.396  -9.253  1.00 26.42           C  
ATOM    357  O   TYR A  50     -17.223  37.973 -10.407  1.00 25.94           O  
ATOM    358  CB  TYR A  50     -15.576  39.548  -7.980  1.00 24.97           C  
ATOM    359  CG  TYR A  50     -14.517  38.740  -8.701  1.00 26.99           C  
ATOM    360  CD1 TYR A  50     -13.761  39.315  -9.724  1.00 28.14           C  
ATOM    361  CD2 TYR A  50     -14.332  37.380  -8.429  1.00 27.93           C  
ATOM    362  CE1 TYR A  50     -12.851  38.560 -10.466  1.00 28.85           C  
ATOM    363  CE2 TYR A  50     -13.427  36.612  -9.170  1.00 27.73           C  
ATOM    364  CZ  TYR A  50     -12.691  37.213 -10.190  1.00 29.38           C  
ATOM    365  OH  TYR A  50     -11.807  36.480 -10.954  1.00 31.38           O  
ATOM    366  N   TYR A  51     -17.974  37.700  -8.291  1.00 26.86           N  
ATOM    367  CA  TYR A  51     -18.525  36.360  -8.518  1.00 26.94           C  
ATOM    368  C   TYR A  51     -19.850  36.304  -9.260  1.00 26.33           C  
ATOM    369  O   TYR A  51     -20.112  35.339  -9.966  1.00 26.78           O  
ATOM    370  CB  TYR A  51     -18.716  35.622  -7.189  1.00 28.32           C  
ATOM    371  CG  TYR A  51     -17.453  35.369  -6.391  1.00 30.13           C  
ATOM    372  CD1 TYR A  51     -16.436  34.550  -6.889  1.00 31.04           C  
ATOM    373  CD2 TYR A  51     -17.285  35.925  -5.123  1.00 30.70           C  
ATOM    374  CE1 TYR A  51     -15.285  34.291  -6.142  1.00 31.91           C  
ATOM    375  CE2 TYR A  51     -16.143  35.673  -4.369  1.00 31.48           C  
ATOM    376  CZ  TYR A  51     -15.145  34.855  -4.882  1.00 32.90           C  
ATOM    377  OH  TYR A  51     -14.012  34.601  -4.130  1.00 35.37           O  
ATOM    378  N   PHE A  52     -20.689  37.326  -9.104  1.00 25.16           N  
ATOM    379  CA  PHE A  52     -22.006  37.318  -9.747  1.00 24.91           C  
ATOM    380  C   PHE A  52     -22.299  38.483 -10.680  1.00 26.39           C  
ATOM    381  O   PHE A  52     -23.127  38.357 -11.577  1.00 27.21           O  
ATOM    382  CB  PHE A  52     -23.089  37.244  -8.673  1.00 23.42           C  
ATOM    383  CG  PHE A  52     -22.893  36.114  -7.709  1.00 23.58           C  
ATOM    384  CD1 PHE A  52     -23.274  34.820  -8.046  1.00 23.44           C  
ATOM    385  CD2 PHE A  52     -22.263  36.330  -6.490  1.00 22.27           C  
ATOM    386  CE1 PHE A  52     -23.024  33.754  -7.182  1.00 22.88           C  
ATOM    387  CE2 PHE A  52     -22.009  35.274  -5.618  1.00 22.47           C  
ATOM    388  CZ  PHE A  52     -22.389  33.983  -5.966  1.00 22.11           C  
ATOM    389  N   GLY A  53     -21.645  39.619 -10.457  1.00 26.85           N  
ATOM    390  CA  GLY A  53     -21.857  40.768 -11.313  1.00 26.52           C  
ATOM    391  C   GLY A  53     -22.906  41.755 -10.842  1.00 28.08           C  
ATOM    392  O   GLY A  53     -22.675  42.962 -10.884  1.00 31.14           O  
ATOM    393  N   SER A  54     -24.058  41.261 -10.405  1.00 26.88           N  
ATOM    394  CA  SER A  54     -25.131  42.137  -9.943  1.00 26.75           C  
ATOM    395  C   SER A  54     -26.052  41.428  -8.956  1.00 27.19           C  
ATOM    396  O   SER A  54     -26.019  40.206  -8.821  1.00 27.16           O  
ATOM    397  CB  SER A  54     -25.968  42.628 -11.129  1.00 26.02           C  
ATOM    398  OG  SER A  54     -26.841  41.612 -11.597  1.00 26.03           O  
ATOM    399  N   LYS A  55     -26.884  42.200  -8.269  1.00 27.06           N  
ATOM    400  CA  LYS A  55     -27.814  41.627  -7.313  1.00 28.20           C  
ATOM    401  C   LYS A  55     -28.776  40.702  -8.057  1.00 28.86           C  
ATOM    402  O   LYS A  55     -29.101  39.622  -7.575  1.00 29.49           O  
ATOM    403  CB  LYS A  55     -28.588  42.736  -6.590  1.00 27.20           C  
ATOM    404  CG  LYS A  55     -29.577  42.229  -5.557  1.00 29.30           C  
ATOM    405  CD  LYS A  55     -30.103  43.351  -4.668  1.00 29.48           C  
ATOM    406  CE  LYS A  55     -30.997  44.322  -5.412  1.00 29.07           C  
ATOM    407  NZ  LYS A  55     -31.578  45.312  -4.466  1.00 29.01           N  
ATOM    408  N   GLU A  56     -29.221  41.120  -9.237  1.00 29.87           N  
ATOM    409  CA  GLU A  56     -30.139  40.303 -10.016  1.00 31.09           C  
ATOM    410  C   GLU A  56     -29.511  38.979 -10.453  1.00 30.91           C  
ATOM    411  O   GLU A  56     -30.206  37.976 -10.545  1.00 32.30           O  
ATOM    412  CB  GLU A  56     -30.642  41.060 -11.246  1.00 33.18           C  
ATOM    413  CG  GLU A  56     -31.602  42.221 -10.967  1.00 35.30           C  
ATOM    414  CD  GLU A  56     -30.959  43.352 -10.184  1.00 37.68           C  
ATOM    415  OE1 GLU A  56     -29.767  43.650 -10.430  1.00 38.41           O  
ATOM    416  OE2 GLU A  56     -31.654  43.953  -9.331  1.00 40.49           O  
ATOM    417  N   ASP A  57     -28.209  38.957 -10.729  1.00 30.35           N  
ATOM    418  CA  ASP A  57     -27.579  37.697 -11.127  1.00 29.55           C  
ATOM    419  C   ASP A  57     -27.406  36.799  -9.919  1.00 28.36           C  
ATOM    420  O   ASP A  57     -27.449  35.576 -10.027  1.00 28.32           O  
ATOM    421  CB  ASP A  57     -26.216  37.933 -11.767  1.00 32.14           C  
ATOM    422  CG  ASP A  57     -26.319  38.608 -13.105  1.00 35.23           C  
ATOM    423  OD1 ASP A  57     -27.075  38.106 -13.970  1.00 37.32           O  
ATOM    424  OD2 ASP A  57     -25.643  39.641 -13.291  1.00 38.61           O  
ATOM    425  N   LEU A  58     -27.198  37.411  -8.761  1.00 27.11           N  
ATOM    426  CA  LEU A  58     -27.034  36.641  -7.539  1.00 25.99           C  
ATOM    427  C   LEU A  58     -28.373  35.961  -7.220  1.00 25.55           C  
ATOM    428  O   LEU A  58     -28.401  34.830  -6.743  1.00 25.26           O  
ATOM    429  CB  LEU A  58     -26.593  37.561  -6.396  1.00 23.09           C  
ATOM    430  CG  LEU A  58     -26.485  36.929  -5.010  1.00 22.65           C  
ATOM    431  CD1 LEU A  58     -25.694  35.644  -5.081  1.00 20.67           C  
ATOM    432  CD2 LEU A  58     -25.837  37.919  -4.057  1.00 22.57           C  
ATOM    433  N   TYR A  59     -29.470  36.663  -7.513  1.00 24.93           N  
ATOM    434  CA  TYR A  59     -30.829  36.168  -7.285  1.00 24.05           C  
ATOM    435  C   TYR A  59     -31.024  34.899  -8.109  1.00 24.34           C  
ATOM    436  O   TYR A  59     -31.493  33.878  -7.607  1.00 23.33           O  
ATOM    437  CB  TYR A  59     -31.855  37.233  -7.722  1.00 22.67           C  
ATOM    438  CG  TYR A  59     -33.294  36.923  -7.355  1.00 23.37           C  
ATOM    439  CD1 TYR A  59     -33.791  37.210  -6.080  1.00 21.78           C  
ATOM    440  CD2 TYR A  59     -34.144  36.290  -8.263  1.00 22.80           C  
ATOM    441  CE1 TYR A  59     -35.096  36.870  -5.712  1.00 21.63           C  
ATOM    442  CE2 TYR A  59     -35.454  35.940  -7.905  1.00 24.30           C  
ATOM    443  CZ  TYR A  59     -35.923  36.235  -6.625  1.00 23.43           C  
ATOM    444  OH  TYR A  59     -37.205  35.884  -6.263  1.00 21.15           O  
ATOM    445  N   LEU A  60     -30.646  34.977  -9.380  1.00 25.16           N  
ATOM    446  CA  LEU A  60     -30.771  33.851 -10.291  1.00 25.21           C  
ATOM    447  C   LEU A  60     -29.863  32.704  -9.868  1.00 25.62           C  
ATOM    448  O   LEU A  60     -30.220  31.531 -10.011  1.00 27.08           O  
ATOM    449  CB  LEU A  60     -30.420  34.293 -11.699  1.00 28.14           C  
ATOM    450  CG  LEU A  60     -31.075  33.423 -12.768  1.00 31.47           C  
ATOM    451  CD1 LEU A  60     -32.591  33.623 -12.699  1.00 30.87           C  
ATOM    452  CD2 LEU A  60     -30.526  33.789 -14.141  1.00 30.62           C  
ATOM    453  N   ALA A  61     -28.687  33.045  -9.349  1.00 23.79           N  
ATOM    454  CA  ALA A  61     -27.735  32.048  -8.876  1.00 22.37           C  
ATOM    455  C   ALA A  61     -28.370  31.238  -7.740  1.00 22.93           C  
ATOM    456  O   ALA A  61     -28.157  30.032  -7.631  1.00 24.32           O  
ATOM    457  CB  ALA A  61     -26.461  32.735  -8.391  1.00 20.14           C  
ATOM    458  N   CYS A  62     -29.147  31.911  -6.892  1.00 23.22           N  
ATOM    459  CA  CYS A  62     -29.829  31.254  -5.779  1.00 21.66           C  
ATOM    460  C   CYS A  62     -30.841  30.262  -6.339  1.00 21.96           C  
ATOM    461  O   CYS A  62     -31.007  29.153  -5.811  1.00 22.22           O  
ATOM    462  CB  CYS A  62     -30.550  32.285  -4.912  1.00 20.33           C  
ATOM    463  SG  CYS A  62     -29.452  33.350  -3.964  1.00 24.00           S  
ATOM    464  N   ALA A  63     -31.523  30.675  -7.404  1.00 21.79           N  
ATOM    465  CA  ALA A  63     -32.504  29.825  -8.069  1.00 22.95           C  
ATOM    466  C   ALA A  63     -31.768  28.592  -8.604  1.00 24.33           C  
ATOM    467  O   ALA A  63     -32.267  27.468  -8.519  1.00 23.29           O  
ATOM    468  CB  ALA A  63     -33.157  30.583  -9.219  1.00 21.81           C  
ATOM    469  N   GLN A  64     -30.575  28.826  -9.149  1.00 24.87           N  
ATOM    470  CA  GLN A  64     -29.743  27.767  -9.701  1.00 25.75           C  
ATOM    471  C   GLN A  64     -29.268  26.817  -8.609  1.00 25.70           C  
ATOM    472  O   GLN A  64     -29.295  25.599  -8.782  1.00 25.98           O  
ATOM    473  CB  GLN A  64     -28.542  28.371 -10.420  1.00 25.82           C  
ATOM    474  CG  GLN A  64     -27.732  27.361 -11.205  1.00 27.68           C  
ATOM    475  CD  GLN A  64     -28.568  26.605 -12.220  1.00 28.73           C  
ATOM    476  OE1 GLN A  64     -28.930  25.440 -12.013  1.00 30.33           O  
ATOM    477  NE2 GLN A  64     -28.889  27.266 -13.319  1.00 30.18           N  
ATOM    478  N   TRP A  65     -28.830  27.376  -7.485  1.00 25.90           N  
ATOM    479  CA  TRP A  65     -28.373  26.567  -6.362  1.00 25.69           C  
ATOM    480  C   TRP A  65     -29.524  25.704  -5.857  1.00 26.40           C  
ATOM    481  O   TRP A  65     -29.336  24.535  -5.530  1.00 26.91           O  
ATOM    482  CB  TRP A  65     -27.882  27.446  -5.213  1.00 27.49           C  
ATOM    483  CG  TRP A  65     -27.294  26.650  -4.086  1.00 29.72           C  
ATOM    484  CD1 TRP A  65     -25.987  26.283  -3.939  1.00 30.89           C  
ATOM    485  CD2 TRP A  65     -28.001  26.064  -2.982  1.00 30.74           C  
ATOM    486  NE1 TRP A  65     -25.834  25.504  -2.815  1.00 31.64           N  
ATOM    487  CE2 TRP A  65     -27.053  25.353  -2.209  1.00 30.81           C  
ATOM    488  CE3 TRP A  65     -29.345  26.068  -2.571  1.00 31.83           C  
ATOM    489  CZ2 TRP A  65     -27.403  24.652  -1.051  1.00 30.15           C  
ATOM    490  CZ3 TRP A  65     -29.694  25.372  -1.419  1.00 30.30           C  
ATOM    491  CH2 TRP A  65     -28.724  24.673  -0.672  1.00 30.55           C  
ATOM    492  N   ILE A  66     -30.718  26.283  -5.778  1.00 25.93           N  
ATOM    493  CA  ILE A  66     -31.869  25.521  -5.308  1.00 25.76           C  
ATOM    494  C   ILE A  66     -32.169  24.382  -6.275  1.00 26.06           C  
ATOM    495  O   ILE A  66     -32.465  23.262  -5.849  1.00 26.15           O  
ATOM    496  CB  ILE A  66     -33.128  26.409  -5.179  1.00 25.33           C  
ATOM    497  CG1 ILE A  66     -32.977  27.358  -3.984  1.00 24.67           C  
ATOM    498  CG2 ILE A  66     -34.375  25.538  -5.043  1.00 22.57           C  
ATOM    499  CD1 ILE A  66     -34.101  28.378  -3.877  1.00 23.72           C  
ATOM    500  N   ALA A  67     -32.087  24.667  -7.573  1.00 25.85           N  
ATOM    501  CA  ALA A  67     -32.363  23.660  -8.592  1.00 25.84           C  
ATOM    502  C   ALA A  67     -31.403  22.498  -8.447  1.00 26.49           C  
ATOM    503  O   ALA A  67     -31.820  21.344  -8.425  1.00 26.77           O  
ATOM    504  CB  ALA A  67     -32.245  24.261  -9.980  1.00 25.22           C  
ATOM    505  N   ASP A  68     -30.115  22.800  -8.337  1.00 27.12           N  
ATOM    506  CA  ASP A  68     -29.114  21.756  -8.193  1.00 27.22           C  
ATOM    507  C   ASP A  68     -29.333  20.960  -6.908  1.00 28.56           C  
ATOM    508  O   ASP A  68     -29.301  19.730  -6.922  1.00 30.23           O  
ATOM    509  CB  ASP A  68     -27.709  22.354  -8.202  1.00 26.78           C  
ATOM    510  CG  ASP A  68     -27.394  23.094  -9.492  1.00 29.03           C  
ATOM    511  OD1 ASP A  68     -28.027  22.795 -10.529  1.00 30.51           O  
ATOM    512  OD2 ASP A  68     -26.499  23.968  -9.473  1.00 32.18           O  
ATOM    513  N   PHE A  69     -29.562  21.660  -5.803  1.00 28.63           N  
ATOM    514  CA  PHE A  69     -29.790  21.019  -4.505  1.00 28.20           C  
ATOM    515  C   PHE A  69     -30.935  19.994  -4.565  1.00 29.61           C  
ATOM    516  O   PHE A  69     -30.769  18.821  -4.199  1.00 30.54           O  
ATOM    517  CB  PHE A  69     -30.110  22.091  -3.461  1.00 27.28           C  
ATOM    518  CG  PHE A  69     -30.479  21.542  -2.115  1.00 25.54           C  
ATOM    519  CD1 PHE A  69     -29.515  20.997  -1.282  1.00 24.74           C  
ATOM    520  CD2 PHE A  69     -31.797  21.558  -1.685  1.00 25.39           C  
ATOM    521  CE1 PHE A  69     -29.868  20.471  -0.034  1.00 25.12           C  
ATOM    522  CE2 PHE A  69     -32.154  21.038  -0.442  1.00 24.19           C  
ATOM    523  CZ  PHE A  69     -31.190  20.495   0.381  1.00 23.55           C  
ATOM    524  N   LEU A  70     -32.095  20.449  -5.027  1.00 28.93           N  
ATOM    525  CA  LEU A  70     -33.277  19.601  -5.143  1.00 28.89           C  
ATOM    526  C   LEU A  70     -33.130  18.511  -6.198  1.00 29.31           C  
ATOM    527  O   LEU A  70     -33.589  17.389  -6.010  1.00 27.76           O  
ATOM    528  CB  LEU A  70     -34.486  20.470  -5.476  1.00 26.88           C  
ATOM    529  CG  LEU A  70     -35.410  20.910  -4.342  1.00 27.25           C  
ATOM    530  CD1 LEU A  70     -34.652  21.075  -3.051  1.00 25.85           C  
ATOM    531  CD2 LEU A  70     -36.093  22.196  -4.756  1.00 23.29           C  
ATOM    532  N   GLY A  71     -32.499  18.854  -7.316  1.00 30.24           N  
ATOM    533  CA  GLY A  71     -32.317  17.888  -8.382  1.00 31.73           C  
ATOM    534  C   GLY A  71     -31.507  16.709  -7.900  1.00 33.40           C  
ATOM    535  O   GLY A  71     -31.775  15.567  -8.266  1.00 34.36           O  
ATOM    536  N   GLU A  72     -30.517  16.999  -7.066  1.00 34.35           N  
ATOM    537  CA  GLU A  72     -29.639  15.987  -6.497  1.00 35.96           C  
ATOM    538  C   GLU A  72     -30.393  15.109  -5.499  1.00 34.91           C  
ATOM    539  O   GLU A  72     -30.312  13.883  -5.552  1.00 34.26           O  
ATOM    540  CB  GLU A  72     -28.476  16.675  -5.790  1.00 39.90           C  
ATOM    541  CG  GLU A  72     -27.119  16.115  -6.143  1.00 47.21           C  
ATOM    542  CD  GLU A  72     -26.981  14.664  -5.760  1.00 50.86           C  
ATOM    543  OE1 GLU A  72     -27.122  14.364  -4.551  1.00 54.92           O  
ATOM    544  OE2 GLU A  72     -26.733  13.833  -6.664  1.00 51.74           O  
ATOM    545  N   LYS A  73     -31.119  15.751  -4.587  1.00 33.73           N  
ATOM    546  CA  LYS A  73     -31.893  15.044  -3.577  1.00 33.95           C  
ATOM    547  C   LYS A  73     -32.865  14.037  -4.189  1.00 34.96           C  
ATOM    548  O   LYS A  73     -33.149  12.996  -3.591  1.00 35.43           O  
ATOM    549  CB  LYS A  73     -32.674  16.048  -2.721  1.00 33.88           C  
ATOM    550  CG  LYS A  73     -31.847  16.754  -1.656  1.00 34.08           C  
ATOM    551  CD  LYS A  73     -31.549  15.808  -0.511  1.00 35.25           C  
ATOM    552  CE  LYS A  73     -30.731  16.465   0.579  1.00 35.67           C  
ATOM    553  NZ  LYS A  73     -29.401  16.858   0.073  1.00 38.50           N  
ATOM    554  N   PHE A  74     -33.368  14.342  -5.382  1.00 35.26           N  
ATOM    555  CA  PHE A  74     -34.328  13.467  -6.044  1.00 36.00           C  
ATOM    556  C   PHE A  74     -33.819  12.781  -7.299  1.00 36.98           C  
ATOM    557  O   PHE A  74     -34.603  12.214  -8.061  1.00 35.04           O  
ATOM    558  CB  PHE A  74     -35.593  14.255  -6.367  1.00 35.37           C  
ATOM    559  CG  PHE A  74     -36.389  14.620  -5.159  1.00 35.70           C  
ATOM    560  CD1 PHE A  74     -37.293  13.716  -4.610  1.00 36.05           C  
ATOM    561  CD2 PHE A  74     -36.196  15.847  -4.529  1.00 34.97           C  
ATOM    562  CE1 PHE A  74     -37.992  14.023  -3.449  1.00 35.06           C  
ATOM    563  CE2 PHE A  74     -36.887  16.168  -3.367  1.00 34.57           C  
ATOM    564  CZ  PHE A  74     -37.788  15.252  -2.825  1.00 35.67           C  
ATOM    565  N   ARG A  75     -32.507  12.830  -7.509  1.00 39.29           N  
ATOM    566  CA  ARG A  75     -31.903  12.195  -8.674  1.00 41.17           C  
ATOM    567  C   ARG A  75     -32.123  10.685  -8.606  1.00 41.07           C  
ATOM    568  O   ARG A  75     -32.492  10.064  -9.602  1.00 40.60           O  
ATOM    569  CB  ARG A  75     -30.405  12.482  -8.729  1.00 43.10           C  
ATOM    570  CG  ARG A  75     -29.754  12.070 -10.038  1.00 46.54           C  
ATOM    571  CD  ARG A  75     -28.228  12.131  -9.975  1.00 49.18           C  
ATOM    572  NE  ARG A  75     -27.639  10.876  -9.511  1.00 52.17           N  
ATOM    573  CZ  ARG A  75     -27.674  10.444  -8.255  1.00 54.26           C  
ATOM    574  NH1 ARG A  75     -28.269  11.164  -7.315  1.00 55.74           N  
ATOM    575  NH2 ARG A  75     -27.116   9.281  -7.937  1.00 56.67           N  
ATOM    576  N   PRO A  76     -31.887  10.071  -7.430  1.00 41.17           N  
ATOM    577  CA  PRO A  76     -32.076   8.625  -7.274  1.00 41.10           C  
ATOM    578  C   PRO A  76     -33.515   8.197  -7.569  1.00 42.14           C  
ATOM    579  O   PRO A  76     -33.742   7.168  -8.202  1.00 42.55           O  
ATOM    580  CB  PRO A  76     -31.690   8.385  -5.820  1.00 40.11           C  
ATOM    581  CG  PRO A  76     -30.637   9.416  -5.592  1.00 39.95           C  
ATOM    582  CD  PRO A  76     -31.256  10.637  -6.224  1.00 40.46           C  
ATOM    583  N   HIS A  77     -34.480   8.987  -7.107  1.00 42.56           N  
ATOM    584  CA  HIS A  77     -35.887   8.683  -7.341  1.00 43.01           C  
ATOM    585  C   HIS A  77     -36.202   8.757  -8.829  1.00 41.93           C  
ATOM    586  O   HIS A  77     -36.969   7.951  -9.348  1.00 40.63           O  
ATOM    587  CB  HIS A  77     -36.782   9.656  -6.564  1.00 46.51           C  
ATOM    588  CG  HIS A  77     -38.219   9.635  -6.994  1.00 50.09           C  
ATOM    589  ND1 HIS A  77     -38.661  10.243  -8.153  1.00 52.65           N  
ATOM    590  CD2 HIS A  77     -39.315   9.079  -6.422  1.00 51.28           C  
ATOM    591  CE1 HIS A  77     -39.966  10.063  -8.275  1.00 51.55           C  
ATOM    592  NE2 HIS A  77     -40.387   9.360  -7.238  1.00 51.70           N  
ATOM    593  N   ALA A  78     -35.608   9.730  -9.510  1.00 41.92           N  
ATOM    594  CA  ALA A  78     -35.824   9.895 -10.944  1.00 43.50           C  
ATOM    595  C   ALA A  78     -35.247   8.696 -11.698  1.00 43.72           C  
ATOM    596  O   ALA A  78     -35.874   8.178 -12.620  1.00 43.04           O  
ATOM    597  CB  ALA A  78     -35.176  11.193 -11.435  1.00 43.14           C  
ATOM    598  N   GLU A  79     -34.053   8.263 -11.297  1.00 44.16           N  
ATOM    599  CA  GLU A  79     -33.400   7.116 -11.920  1.00 45.74           C  
ATOM    600  C   GLU A  79     -34.240   5.859 -11.713  1.00 46.37           C  
ATOM    601  O   GLU A  79     -34.410   5.066 -12.638  1.00 47.66           O  
ATOM    602  CB  GLU A  79     -32.011   6.895 -11.321  1.00 46.35           C  
ATOM    603  CG  GLU A  79     -31.093   8.100 -11.412  1.00 48.19           C  
ATOM    604  CD  GLU A  79     -29.742   7.857 -10.757  1.00 49.84           C  
ATOM    605  OE1 GLU A  79     -29.700   7.167  -9.708  1.00 50.24           O  
ATOM    606  OE2 GLU A  79     -28.728   8.369 -11.283  1.00 50.91           O  
ATOM    607  N   LYS A  80     -34.756   5.676 -10.499  1.00 46.05           N  
ATOM    608  CA  LYS A  80     -35.587   4.516 -10.192  1.00 46.16           C  
ATOM    609  C   LYS A  80     -36.886   4.541 -10.989  1.00 46.36           C  
ATOM    610  O   LYS A  80     -37.308   3.518 -11.518  1.00 45.60           O  
ATOM    611  CB  LYS A  80     -35.940   4.467  -8.705  1.00 46.63           C  
ATOM    612  CG  LYS A  80     -34.765   4.275  -7.771  1.00 49.49           C  
ATOM    613  CD  LYS A  80     -35.239   4.136  -6.322  1.00 50.13           C  
ATOM    614  CE  LYS A  80     -34.064   3.945  -5.369  1.00 50.68           C  
ATOM    615  NZ  LYS A  80     -34.513   3.607  -3.989  1.00 52.98           N  
ATOM    616  N   ALA A  81     -37.519   5.710 -11.057  1.00 47.03           N  
ATOM    617  CA  ALA A  81     -38.778   5.870 -11.777  1.00 48.50           C  
ATOM    618  C   ALA A  81     -38.619   5.525 -13.248  1.00 50.92           C  
ATOM    619  O   ALA A  81     -39.488   4.888 -13.841  1.00 50.20           O  
ATOM    620  CB  ALA A  81     -39.282   7.290 -11.634  1.00 47.31           C  
ATOM    621  N   GLU A  82     -37.507   5.952 -13.835  1.00 54.18           N  
ATOM    622  CA  GLU A  82     -37.230   5.684 -15.242  1.00 57.31           C  
ATOM    623  C   GLU A  82     -37.000   4.195 -15.423  1.00 58.01           C  
ATOM    624  O   GLU A  82     -37.610   3.549 -16.274  1.00 59.34           O  
ATOM    625  CB  GLU A  82     -35.982   6.442 -15.691  1.00 59.49           C  
ATOM    626  CG  GLU A  82     -36.187   7.273 -16.947  1.00 64.98           C  
ATOM    627  CD  GLU A  82     -37.159   8.429 -16.738  1.00 68.11           C  
ATOM    628  OE1 GLU A  82     -38.343   8.172 -16.412  1.00 69.72           O  
ATOM    629  OE2 GLU A  82     -36.738   9.599 -16.900  1.00 70.43           O  
ATOM    630  N   ARG A  83     -36.099   3.667 -14.606  1.00 58.05           N  
ATOM    631  CA  ARG A  83     -35.743   2.258 -14.604  1.00 58.04           C  
ATOM    632  C   ARG A  83     -36.994   1.390 -14.411  1.00 58.09           C  
ATOM    633  O   ARG A  83     -37.063   0.253 -14.876  1.00 58.78           O  
ATOM    634  CB  ARG A  83     -34.751   2.035 -13.470  1.00 58.03           C  
ATOM    635  CG  ARG A  83     -34.247   0.637 -13.276  1.00 60.15           C  
ATOM    636  CD  ARG A  83     -33.563   0.577 -11.925  1.00 62.74           C  
ATOM    637  NE  ARG A  83     -32.592   1.662 -11.769  1.00 64.59           N  
ATOM    638  CZ  ARG A  83     -32.214   2.168 -10.597  1.00 64.67           C  
ATOM    639  NH1 ARG A  83     -32.728   1.691  -9.470  1.00 64.33           N  
ATOM    640  NH2 ARG A  83     -31.320   3.150 -10.549  1.00 65.47           N  
ATOM    641  N   LEU A  84     -37.986   1.949 -13.732  1.00 58.19           N  
ATOM    642  CA  LEU A  84     -39.235   1.251 -13.449  1.00 58.35           C  
ATOM    643  C   LEU A  84     -40.177   1.288 -14.662  1.00 58.66           C  
ATOM    644  O   LEU A  84     -40.853   0.306 -14.964  1.00 58.35           O  
ATOM    645  CB  LEU A  84     -39.888   1.898 -12.211  1.00 58.70           C  
ATOM    646  CG  LEU A  84     -41.007   1.250 -11.385  1.00 58.61           C  
ATOM    647  CD1 LEU A  84     -42.315   1.317 -12.147  1.00 59.25           C  
ATOM    648  CD2 LEU A  84     -40.634  -0.183 -11.032  1.00 57.92           C  
ATOM    649  N   PHE A  85     -40.210   2.421 -15.360  1.00 59.76           N  
ATOM    650  CA  PHE A  85     -41.068   2.574 -16.537  1.00 61.30           C  
ATOM    651  C   PHE A  85     -40.533   1.851 -17.768  1.00 62.21           C  
ATOM    652  O   PHE A  85     -41.172   1.856 -18.819  1.00 62.15           O  
ATOM    653  CB  PHE A  85     -41.259   4.057 -16.888  1.00 60.55           C  
ATOM    654  CG  PHE A  85     -42.120   4.808 -15.916  1.00 60.81           C  
ATOM    655  CD1 PHE A  85     -43.359   4.303 -15.530  1.00 61.11           C  
ATOM    656  CD2 PHE A  85     -41.698   6.027 -15.391  1.00 61.30           C  
ATOM    657  CE1 PHE A  85     -44.162   5.001 -14.631  1.00 61.15           C  
ATOM    658  CE2 PHE A  85     -42.494   6.734 -14.495  1.00 60.85           C  
ATOM    659  CZ  PHE A  85     -43.728   6.221 -14.112  1.00 60.94           C  
ATOM    660  N   SER A  86     -39.363   1.235 -17.639  1.00 63.26           N  
ATOM    661  CA  SER A  86     -38.763   0.518 -18.758  1.00 65.38           C  
ATOM    662  C   SER A  86     -39.079  -0.977 -18.671  1.00 66.87           C  
ATOM    663  O   SER A  86     -38.233  -1.830 -18.939  1.00 67.30           O  
ATOM    664  CB  SER A  86     -37.248   0.736 -18.774  1.00 64.83           C  
ATOM    665  OG  SER A  86     -36.633   0.157 -17.635  1.00 65.99           O  
ATOM    666  N   GLN A  87     -40.309  -1.281 -18.286  1.00 68.48           N  
ATOM    667  CA  GLN A  87     -40.756  -2.656 -18.163  1.00 70.02           C  
ATOM    668  C   GLN A  87     -42.124  -2.689 -18.800  1.00 70.90           C  
ATOM    669  O   GLN A  87     -42.910  -1.756 -18.631  1.00 71.05           O  
ATOM    670  CB  GLN A  87     -40.866  -3.044 -16.691  1.00 71.53           C  
ATOM    671  CG  GLN A  87     -39.575  -2.866 -15.908  1.00 73.28           C  
ATOM    672  CD  GLN A  87     -39.777  -3.007 -14.409  1.00 74.19           C  
ATOM    673  OE1 GLN A  87     -38.813  -3.009 -13.640  1.00 74.93           O  
ATOM    674  NE2 GLN A  87     -41.036  -3.119 -13.985  1.00 74.21           N  
ATOM    675  N   PRO A  88     -42.432  -3.760 -19.547  1.00 71.67           N  
ATOM    676  CA  PRO A  88     -43.740  -3.871 -20.200  1.00 71.67           C  
ATOM    677  C   PRO A  88     -44.869  -3.516 -19.227  1.00 71.33           C  
ATOM    678  O   PRO A  88     -45.682  -2.625 -19.495  1.00 71.31           O  
ATOM    679  CB  PRO A  88     -43.773  -5.333 -20.642  1.00 72.21           C  
ATOM    680  CG  PRO A  88     -42.327  -5.608 -20.954  1.00 71.83           C  
ATOM    681  CD  PRO A  88     -41.626  -4.974 -19.771  1.00 71.91           C  
ATOM    682  N   ALA A  89     -44.899  -4.214 -18.095  1.00 70.48           N  
ATOM    683  CA  ALA A  89     -45.902  -3.977 -17.064  1.00 69.96           C  
ATOM    684  C   ALA A  89     -45.190  -3.835 -15.722  1.00 69.61           C  
ATOM    685  O   ALA A  89     -44.953  -4.825 -15.024  1.00 70.39           O  
ATOM    686  CB  ALA A  89     -46.884  -5.133 -17.016  1.00 70.02           C  
ATOM    687  N   PRO A  90     -44.824  -2.595 -15.350  1.00 68.41           N  
ATOM    688  CA  PRO A  90     -44.132  -2.329 -14.085  1.00 66.07           C  
ATOM    689  C   PRO A  90     -44.821  -2.952 -12.871  1.00 63.94           C  
ATOM    690  O   PRO A  90     -46.011  -3.265 -12.902  1.00 63.35           O  
ATOM    691  CB  PRO A  90     -44.109  -0.805 -14.029  1.00 66.41           C  
ATOM    692  CG  PRO A  90     -43.969  -0.430 -15.477  1.00 67.41           C  
ATOM    693  CD  PRO A  90     -44.973  -1.353 -16.135  1.00 68.09           C  
ATOM    694  N   ASP A  91     -44.056  -3.130 -11.801  1.00 61.87           N  
ATOM    695  CA  ASP A  91     -44.579  -3.712 -10.576  1.00 59.87           C  
ATOM    696  C   ASP A  91     -45.389  -2.684  -9.786  1.00 57.79           C  
ATOM    697  O   ASP A  91     -44.858  -1.690  -9.295  1.00 57.99           O  
ATOM    698  CB  ASP A  91     -43.429  -4.237  -9.723  1.00 60.56           C  
ATOM    699  CG  ASP A  91     -43.907  -5.050  -8.544  1.00 62.27           C  
ATOM    700  OD1 ASP A  91     -43.074  -5.341  -7.659  1.00 64.16           O  
ATOM    701  OD2 ASP A  91     -45.108  -5.404  -8.503  1.00 62.81           O  
ATOM    702  N   ARG A  92     -46.682  -2.946  -9.666  1.00 55.33           N  
ATOM    703  CA  ARG A  92     -47.613  -2.075  -8.961  1.00 52.47           C  
ATOM    704  C   ARG A  92     -47.206  -1.726  -7.531  1.00 51.35           C  
ATOM    705  O   ARG A  92     -47.495  -0.637  -7.037  1.00 50.26           O  
ATOM    706  CB  ARG A  92     -48.983  -2.741  -8.952  1.00 51.47           C  
ATOM    707  CG  ARG A  92     -50.098  -1.857  -8.495  1.00 49.97           C  
ATOM    708  CD  ARG A  92     -51.255  -1.946  -9.466  1.00 48.90           C  
ATOM    709  NE  ARG A  92     -52.408  -1.210  -8.976  1.00 47.77           N  
ATOM    710  CZ  ARG A  92     -53.048  -1.509  -7.851  1.00 48.39           C  
ATOM    711  NH1 ARG A  92     -52.645  -2.534  -7.108  1.00 48.85           N  
ATOM    712  NH2 ARG A  92     -54.081  -0.773  -7.463  1.00 49.40           N  
ATOM    713  N   ASP A  93     -46.542  -2.661  -6.866  1.00 50.20           N  
ATOM    714  CA  ASP A  93     -46.109  -2.460  -5.493  1.00 48.63           C  
ATOM    715  C   ASP A  93     -44.853  -1.621  -5.420  1.00 46.38           C  
ATOM    716  O   ASP A  93     -44.670  -0.854  -4.483  1.00 46.00           O  
ATOM    717  CB  ASP A  93     -45.870  -3.809  -4.829  1.00 51.23           C  
ATOM    718  CG  ASP A  93     -47.133  -4.638  -4.753  1.00 54.95           C  
ATOM    719  OD1 ASP A  93     -48.067  -4.215  -4.038  1.00 56.43           O  
ATOM    720  OD2 ASP A  93     -47.200  -5.700  -5.413  1.00 57.29           O  
ATOM    721  N   ALA A  94     -43.982  -1.779  -6.410  1.00 43.90           N  
ATOM    722  CA  ALA A  94     -42.743  -1.014  -6.456  1.00 41.80           C  
ATOM    723  C   ALA A  94     -43.076   0.429  -6.838  1.00 40.70           C  
ATOM    724  O   ALA A  94     -42.380   1.370  -6.442  1.00 39.19           O  
ATOM    725  CB  ALA A  94     -41.792  -1.623  -7.468  1.00 41.75           C  
ATOM    726  N   ILE A  95     -44.141   0.590  -7.619  1.00 38.50           N  
ATOM    727  CA  ILE A  95     -44.594   1.911  -8.032  1.00 36.98           C  
ATOM    728  C   ILE A  95     -45.032   2.660  -6.769  1.00 35.52           C  
ATOM    729  O   ILE A  95     -44.571   3.765  -6.496  1.00 33.40           O  
ATOM    730  CB  ILE A  95     -45.772   1.798  -9.027  1.00 36.81           C  
ATOM    731  CG1 ILE A  95     -45.234   1.388 -10.400  1.00 37.00           C  
ATOM    732  CG2 ILE A  95     -46.541   3.112  -9.111  1.00 37.07           C  
ATOM    733  CD1 ILE A  95     -46.311   1.209 -11.446  1.00 35.01           C  
ATOM    734  N   ARG A  96     -45.913   2.035  -5.995  1.00 34.89           N  
ATOM    735  CA  ARG A  96     -46.389   2.631  -4.759  1.00 34.35           C  
ATOM    736  C   ARG A  96     -45.220   2.945  -3.834  1.00 33.45           C  
ATOM    737  O   ARG A  96     -45.193   3.992  -3.202  1.00 33.47           O  
ATOM    738  CB  ARG A  96     -47.363   1.684  -4.061  1.00 34.37           C  
ATOM    739  CG  ARG A  96     -47.695   2.098  -2.635  1.00 36.38           C  
ATOM    740  CD  ARG A  96     -48.696   1.150  -1.996  1.00 35.98           C  
ATOM    741  NE  ARG A  96     -48.825   1.381  -0.560  1.00 35.12           N  
ATOM    742  CZ  ARG A  96     -47.900   1.061   0.343  1.00 35.70           C  
ATOM    743  NH1 ARG A  96     -46.761   0.486  -0.030  1.00 35.06           N  
ATOM    744  NH2 ARG A  96     -48.114   1.319   1.629  1.00 34.54           N  
ATOM    745  N   GLU A  97     -44.256   2.034  -3.758  1.00 34.07           N  
ATOM    746  CA  GLU A  97     -43.080   2.221  -2.909  1.00 35.98           C  
ATOM    747  C   GLU A  97     -42.350   3.507  -3.277  1.00 34.78           C  
ATOM    748  O   GLU A  97     -41.957   4.295  -2.418  1.00 34.22           O  
ATOM    749  CB  GLU A  97     -42.103   1.059  -3.090  1.00 38.33           C  
ATOM    750  CG  GLU A  97     -41.676   0.383  -1.810  1.00 45.11           C  
ATOM    751  CD  GLU A  97     -42.575  -0.780  -1.459  1.00 49.08           C  
ATOM    752  OE1 GLU A  97     -42.561  -1.784  -2.205  1.00 52.70           O  
ATOM    753  OE2 GLU A  97     -43.301  -0.689  -0.446  1.00 52.09           O  
ATOM    754  N   LEU A  98     -42.166   3.695  -4.576  1.00 33.79           N  
ATOM    755  CA  LEU A  98     -41.466   4.853  -5.111  1.00 34.03           C  
ATOM    756  C   LEU A  98     -42.203   6.162  -4.809  1.00 31.88           C  
ATOM    757  O   LEU A  98     -41.580   7.174  -4.503  1.00 31.49           O  
ATOM    758  CB  LEU A  98     -41.276   4.654  -6.617  1.00 34.87           C  
ATOM    759  CG  LEU A  98     -40.066   5.308  -7.273  1.00 37.71           C  
ATOM    760  CD1 LEU A  98     -38.822   5.121  -6.408  1.00 38.38           C  
ATOM    761  CD2 LEU A  98     -39.877   4.685  -8.650  1.00 38.83           C  
ATOM    762  N   ILE A  99     -43.529   6.140  -4.899  1.00 31.01           N  
ATOM    763  CA  ILE A  99     -44.318   7.327  -4.599  1.00 29.73           C  
ATOM    764  C   ILE A  99     -44.093   7.670  -3.129  1.00 29.45           C  
ATOM    765  O   ILE A  99     -43.860   8.827  -2.778  1.00 28.75           O  
ATOM    766  CB  ILE A  99     -45.834   7.087  -4.814  1.00 28.80           C  
ATOM    767  CG1 ILE A  99     -46.131   6.880  -6.306  1.00 28.80           C  
ATOM    768  CG2 ILE A  99     -46.631   8.267  -4.252  1.00 27.02           C  
ATOM    769  CD1 ILE A  99     -47.601   6.553  -6.621  1.00 25.52           C  
ATOM    770  N   LEU A 100     -44.158   6.655  -2.275  1.00 27.55           N  
ATOM    771  CA  LEU A 100     -43.957   6.857  -0.846  1.00 29.17           C  
ATOM    772  C   LEU A 100     -42.536   7.333  -0.538  1.00 30.29           C  
ATOM    773  O   LEU A 100     -42.320   8.101   0.404  1.00 31.50           O  
ATOM    774  CB  LEU A 100     -44.252   5.565  -0.082  1.00 27.54           C  
ATOM    775  CG  LEU A 100     -45.713   5.107  -0.111  1.00 28.65           C  
ATOM    776  CD1 LEU A 100     -45.861   3.848   0.721  1.00 28.14           C  
ATOM    777  CD2 LEU A 100     -46.623   6.208   0.418  1.00 26.36           C  
ATOM    778  N   LEU A 101     -41.575   6.876  -1.337  1.00 30.12           N  
ATOM    779  CA  LEU A 101     -40.175   7.253  -1.163  1.00 28.90           C  
ATOM    780  C   LEU A 101     -39.977   8.744  -1.442  1.00 27.98           C  
ATOM    781  O   LEU A 101     -39.209   9.414  -0.765  1.00 27.03           O  
ATOM    782  CB  LEU A 101     -39.296   6.434  -2.108  1.00 30.62           C  
ATOM    783  CG  LEU A 101     -37.802   6.753  -2.063  1.00 31.60           C  
ATOM    784  CD1 LEU A 101     -37.256   6.451  -0.668  1.00 30.34           C  
ATOM    785  CD2 LEU A 101     -37.069   5.940  -3.127  1.00 32.96           C  
ATOM    786  N   ALA A 102     -40.669   9.253  -2.456  1.00 27.48           N  
ATOM    787  CA  ALA A 102     -40.577  10.660  -2.805  1.00 27.03           C  
ATOM    788  C   ALA A 102     -41.150  11.455  -1.643  1.00 27.27           C  
ATOM    789  O   ALA A 102     -40.537  12.408  -1.163  1.00 26.84           O  
ATOM    790  CB  ALA A 102     -41.368  10.936  -4.081  1.00 26.51           C  
ATOM    791  N   CYS A 103     -42.328  11.049  -1.185  1.00 28.05           N  
ATOM    792  CA  CYS A 103     -42.971  11.708  -0.059  1.00 29.03           C  
ATOM    793  C   CYS A 103     -42.086  11.717   1.184  1.00 28.66           C  
ATOM    794  O   CYS A 103     -41.940  12.756   1.824  1.00 29.61           O  
ATOM    795  CB  CYS A 103     -44.296  11.030   0.249  1.00 30.73           C  
ATOM    796  SG  CYS A 103     -45.477  11.251  -1.082  1.00 37.19           S  
ATOM    797  N   LYS A 104     -41.490  10.575   1.524  1.00 28.45           N  
ATOM    798  CA  LYS A 104     -40.618  10.506   2.692  1.00 28.87           C  
ATOM    799  C   LYS A 104     -39.451  11.481   2.568  1.00 29.70           C  
ATOM    800  O   LYS A 104     -39.091  12.152   3.534  1.00 29.67           O  
ATOM    801  CB  LYS A 104     -40.048   9.102   2.897  1.00 30.41           C  
ATOM    802  CG  LYS A 104     -39.151   9.062   4.123  1.00 32.71           C  
ATOM    803  CD  LYS A 104     -38.244   7.855   4.205  1.00 36.17           C  
ATOM    804  CE  LYS A 104     -37.339   8.010   5.429  1.00 37.30           C  
ATOM    805  NZ  LYS A 104     -36.365   6.904   5.613  1.00 38.80           N  
ATOM    806  N   ASN A 105     -38.846  11.552   1.386  1.00 29.27           N  
ATOM    807  CA  ASN A 105     -37.734  12.472   1.174  1.00 29.76           C  
ATOM    808  C   ASN A 105     -38.176  13.942   1.191  1.00 28.42           C  
ATOM    809  O   ASN A 105     -37.431  14.809   1.647  1.00 26.64           O  
ATOM    810  CB  ASN A 105     -37.017  12.142  -0.132  1.00 33.34           C  
ATOM    811  CG  ASN A 105     -36.162  10.905  -0.016  1.00 37.56           C  
ATOM    812  OD1 ASN A 105     -36.666   9.795   0.136  1.00 39.88           O  
ATOM    813  ND2 ASN A 105     -34.852  11.092  -0.064  1.00 41.74           N  
ATOM    814  N   MET A 106     -39.376  14.227   0.686  1.00 26.60           N  
ATOM    815  CA  MET A 106     -39.881  15.592   0.714  1.00 26.77           C  
ATOM    816  C   MET A 106     -40.068  15.964   2.180  1.00 26.61           C  
ATOM    817  O   MET A 106     -39.638  17.027   2.620  1.00 25.82           O  
ATOM    818  CB  MET A 106     -41.225  15.696  -0.003  1.00 27.23           C  
ATOM    819  CG  MET A 106     -41.137  15.953  -1.493  1.00 30.02           C  
ATOM    820  SD  MET A 106     -42.768  15.871  -2.259  1.00 29.16           S  
ATOM    821  CE  MET A 106     -42.673  14.343  -3.045  1.00 30.41           C  
ATOM    822  N   ILE A 107     -40.700  15.068   2.935  1.00 25.47           N  
ATOM    823  CA  ILE A 107     -40.944  15.308   4.349  1.00 25.26           C  
ATOM    824  C   ILE A 107     -39.679  15.486   5.185  1.00 27.28           C  
ATOM    825  O   ILE A 107     -39.601  16.428   5.970  1.00 27.94           O  
ATOM    826  CB  ILE A 107     -41.814  14.182   4.979  1.00 25.12           C  
ATOM    827  CG1 ILE A 107     -43.230  14.230   4.388  1.00 23.81           C  
ATOM    828  CG2 ILE A 107     -41.866  14.337   6.501  1.00 23.84           C  
ATOM    829  CD1 ILE A 107     -44.138  13.142   4.892  1.00 21.49           C  
ATOM    830  N   MET A 108     -38.679  14.620   5.042  1.00 28.74           N  
ATOM    831  CA  MET A 108     -37.505  14.827   5.874  1.00 29.81           C  
ATOM    832  C   MET A 108     -36.762  16.098   5.483  1.00 31.12           C  
ATOM    833  O   MET A 108     -36.063  16.700   6.299  1.00 32.11           O  
ATOM    834  CB  MET A 108     -36.590  13.579   5.908  1.00 30.40           C  
ATOM    835  CG  MET A 108     -35.792  13.182   4.681  1.00 33.22           C  
ATOM    836  SD  MET A 108     -35.024  11.498   4.933  1.00 27.56           S  
ATOM    837  CE  MET A 108     -35.900  10.579   3.744  1.00 26.23           C  
ATOM    838  N   LEU A 109     -36.964  16.542   4.247  1.00 31.21           N  
ATOM    839  CA  LEU A 109     -36.338  17.766   3.768  1.00 31.31           C  
ATOM    840  C   LEU A 109     -37.137  18.964   4.297  1.00 31.09           C  
ATOM    841  O   LEU A 109     -36.564  19.959   4.739  1.00 29.74           O  
ATOM    842  CB  LEU A 109     -36.329  17.781   2.240  1.00 32.87           C  
ATOM    843  CG  LEU A 109     -35.014  18.155   1.554  1.00 35.14           C  
ATOM    844  CD1 LEU A 109     -33.908  17.191   1.971  1.00 35.68           C  
ATOM    845  CD2 LEU A 109     -35.221  18.121   0.047  1.00 36.69           C  
ATOM    846  N   LEU A 110     -38.464  18.849   4.261  1.00 31.54           N  
ATOM    847  CA  LEU A 110     -39.357  19.909   4.729  1.00 31.87           C  
ATOM    848  C   LEU A 110     -39.497  20.003   6.254  1.00 32.19           C  
ATOM    849  O   LEU A 110     -40.321  20.767   6.749  1.00 32.61           O  
ATOM    850  CB  LEU A 110     -40.764  19.765   4.108  1.00 32.87           C  
ATOM    851  CG  LEU A 110     -41.110  20.305   2.699  1.00 35.03           C  
ATOM    852  CD1 LEU A 110     -40.404  21.636   2.464  1.00 34.25           C  
ATOM    853  CD2 LEU A 110     -40.698  19.326   1.618  1.00 36.13           C  
ATOM    854  N   THR A 111     -38.719  19.224   7.001  1.00 32.75           N  
ATOM    855  CA  THR A 111     -38.787  19.297   8.460  1.00 33.18           C  
ATOM    856  C   THR A 111     -37.447  19.699   9.049  1.00 34.83           C  
ATOM    857  O   THR A 111     -37.210  19.509  10.240  1.00 35.67           O  
ATOM    858  CB  THR A 111     -39.232  17.961   9.131  1.00 31.86           C  
ATOM    859  OG1 THR A 111     -38.409  16.881   8.672  1.00 32.12           O  
ATOM    860  CG2 THR A 111     -40.695  17.674   8.842  1.00 28.08           C  
ATOM    861  N   GLN A 112     -36.560  20.230   8.212  1.00 36.38           N  
ATOM    862  CA  GLN A 112     -35.264  20.690   8.695  1.00 38.85           C  
ATOM    863  C   GLN A 112     -35.080  22.185   8.428  1.00 39.59           C  
ATOM    864  O   GLN A 112     -35.397  22.686   7.349  1.00 38.91           O  
ATOM    865  CB  GLN A 112     -34.119  19.869   8.089  1.00 40.08           C  
ATOM    866  CG  GLN A 112     -34.165  19.678   6.597  1.00 44.00           C  
ATOM    867  CD  GLN A 112     -33.087  18.721   6.117  1.00 46.67           C  
ATOM    868  OE1 GLN A 112     -32.947  17.618   6.648  1.00 48.33           O  
ATOM    869  NE2 GLN A 112     -32.323  19.135   5.105  1.00 48.94           N  
ATOM    870  N   GLU A 113     -34.584  22.889   9.443  1.00 41.66           N  
ATOM    871  CA  GLU A 113     -34.359  24.334   9.398  1.00 43.00           C  
ATOM    872  C   GLU A 113     -33.495  24.827   8.248  1.00 41.55           C  
ATOM    873  O   GLU A 113     -33.763  25.884   7.688  1.00 41.84           O  
ATOM    874  CB  GLU A 113     -33.725  24.805  10.712  1.00 46.59           C  
ATOM    875  CG  GLU A 113     -34.579  24.595  11.958  1.00 52.29           C  
ATOM    876  CD  GLU A 113     -35.658  25.655  12.138  1.00 56.72           C  
ATOM    877  OE1 GLU A 113     -36.377  25.588  13.160  1.00 59.29           O  
ATOM    878  OE2 GLU A 113     -35.788  26.553  11.271  1.00 59.37           O  
ATOM    879  N   ASP A 114     -32.459  24.067   7.907  1.00 40.90           N  
ATOM    880  CA  ASP A 114     -31.538  24.455   6.845  1.00 39.99           C  
ATOM    881  C   ASP A 114     -32.145  24.601   5.456  1.00 37.51           C  
ATOM    882  O   ASP A 114     -31.468  25.063   4.540  1.00 38.43           O  
ATOM    883  CB  ASP A 114     -30.362  23.480   6.782  1.00 44.77           C  
ATOM    884  CG  ASP A 114     -30.807  22.046   6.613  1.00 50.15           C  
ATOM    885  OD1 ASP A 114     -31.365  21.486   7.586  1.00 54.61           O  
ATOM    886  OD2 ASP A 114     -30.604  21.487   5.508  1.00 53.28           O  
ATOM    887  N   THR A 115     -33.406  24.211   5.285  1.00 33.45           N  
ATOM    888  CA  THR A 115     -34.056  24.352   3.983  1.00 29.71           C  
ATOM    889  C   THR A 115     -35.202  25.374   4.006  1.00 27.87           C  
ATOM    890  O   THR A 115     -35.861  25.605   2.993  1.00 26.54           O  
ATOM    891  CB  THR A 115     -34.621  23.024   3.499  1.00 28.80           C  
ATOM    892  OG1 THR A 115     -35.646  22.594   4.401  1.00 29.08           O  
ATOM    893  CG2 THR A 115     -33.525  21.975   3.429  1.00 28.92           C  
ATOM    894  N   VAL A 116     -35.439  25.988   5.158  1.00 25.80           N  
ATOM    895  CA  VAL A 116     -36.508  26.973   5.275  1.00 25.48           C  
ATOM    896  C   VAL A 116     -36.355  28.119   4.279  1.00 25.08           C  
ATOM    897  O   VAL A 116     -37.321  28.498   3.632  1.00 26.69           O  
ATOM    898  CB  VAL A 116     -36.592  27.552   6.711  1.00 24.36           C  
ATOM    899  CG1 VAL A 116     -37.562  28.733   6.745  1.00 23.11           C  
ATOM    900  CG2 VAL A 116     -37.052  26.463   7.679  1.00 23.40           C  
ATOM    901  N   ASN A 117     -35.148  28.667   4.153  1.00 24.75           N  
ATOM    902  CA  ASN A 117     -34.909  29.768   3.225  1.00 24.39           C  
ATOM    903  C   ASN A 117     -35.192  29.380   1.789  1.00 24.50           C  
ATOM    904  O   ASN A 117     -35.616  30.201   0.982  1.00 24.00           O  
ATOM    905  CB  ASN A 117     -33.479  30.265   3.341  1.00 24.40           C  
ATOM    906  CG  ASN A 117     -33.225  30.935   4.649  1.00 24.90           C  
ATOM    907  OD1 ASN A 117     -34.136  31.514   5.243  1.00 26.04           O  
ATOM    908  ND2 ASN A 117     -31.986  30.884   5.111  1.00 27.00           N  
ATOM    909  N   LEU A 118     -34.941  28.125   1.469  1.00 24.36           N  
ATOM    910  CA  LEU A 118     -35.205  27.622   0.140  1.00 23.95           C  
ATOM    911  C   LEU A 118     -36.722  27.699  -0.053  1.00 23.19           C  
ATOM    912  O   LEU A 118     -37.205  28.099  -1.116  1.00 22.60           O  
ATOM    913  CB  LEU A 118     -34.707  26.183   0.048  1.00 25.27           C  
ATOM    914  CG  LEU A 118     -34.874  25.371  -1.229  1.00 26.96           C  
ATOM    915  CD1 LEU A 118     -33.929  24.186  -1.135  1.00 26.75           C  
ATOM    916  CD2 LEU A 118     -36.315  24.902  -1.408  1.00 26.34           C  
ATOM    917  N   SER A 119     -37.474  27.328   0.980  1.00 20.70           N  
ATOM    918  CA  SER A 119     -38.926  27.388   0.894  1.00 21.52           C  
ATOM    919  C   SER A 119     -39.414  28.828   0.762  1.00 20.76           C  
ATOM    920  O   SER A 119     -40.339  29.104   0.001  1.00 21.15           O  
ATOM    921  CB  SER A 119     -39.565  26.735   2.113  1.00 21.88           C  
ATOM    922  OG  SER A 119     -39.422  25.333   2.045  1.00 24.24           O  
ATOM    923  N   LYS A 120     -38.800  29.741   1.511  1.00 19.22           N  
ATOM    924  CA  LYS A 120     -39.164  31.156   1.441  1.00 20.74           C  
ATOM    925  C   LYS A 120     -38.998  31.673   0.011  1.00 19.79           C  
ATOM    926  O   LYS A 120     -39.880  32.332  -0.534  1.00 20.08           O  
ATOM    927  CB  LYS A 120     -38.268  31.996   2.356  1.00 21.80           C  
ATOM    928  CG  LYS A 120     -38.488  31.807   3.845  1.00 24.25           C  
ATOM    929  CD  LYS A 120     -37.628  32.795   4.618  1.00 24.77           C  
ATOM    930  CE  LYS A 120     -37.786  32.612   6.103  1.00 26.46           C  
ATOM    931  NZ  LYS A 120     -36.928  33.552   6.863  1.00 28.43           N  
ATOM    932  N   PHE A 121     -37.847  31.361  -0.580  1.00 20.31           N  
ATOM    933  CA  PHE A 121     -37.504  31.775  -1.935  1.00 20.52           C  
ATOM    934  C   PHE A 121     -38.506  31.251  -2.962  1.00 20.46           C  
ATOM    935  O   PHE A 121     -38.993  32.013  -3.792  1.00 20.90           O  
ATOM    936  CB  PHE A 121     -36.086  31.289  -2.260  1.00 20.65           C  
ATOM    937  CG  PHE A 121     -35.501  31.884  -3.518  1.00 22.68           C  
ATOM    938  CD1 PHE A 121     -35.870  31.405  -4.779  1.00 21.61           C  
ATOM    939  CD2 PHE A 121     -34.593  32.937  -3.445  1.00 21.74           C  
ATOM    940  CE1 PHE A 121     -35.346  31.967  -5.943  1.00 21.72           C  
ATOM    941  CE2 PHE A 121     -34.063  33.505  -4.610  1.00 22.48           C  
ATOM    942  CZ  PHE A 121     -34.441  33.020  -5.856  1.00 21.23           C  
ATOM    943  N   ILE A 122     -38.812  29.955  -2.894  1.00 20.12           N  
ATOM    944  CA  ILE A 122     -39.762  29.319  -3.809  1.00 20.06           C  
ATOM    945  C   ILE A 122     -41.194  29.825  -3.636  1.00 19.81           C  
ATOM    946  O   ILE A 122     -41.916  30.004  -4.614  1.00 19.40           O  
ATOM    947  CB  ILE A 122     -39.814  27.789  -3.608  1.00 21.47           C  
ATOM    948  CG1 ILE A 122     -38.431  27.167  -3.817  1.00 21.45           C  
ATOM    949  CG2 ILE A 122     -40.862  27.186  -4.558  1.00 21.97           C  
ATOM    950  CD1 ILE A 122     -37.835  27.440  -5.185  1.00 22.62           C  
ATOM    951  N   SER A 123     -41.608  30.017  -2.387  1.00 19.90           N  
ATOM    952  CA  SER A 123     -42.950  30.499  -2.081  1.00 20.50           C  
ATOM    953  C   SER A 123     -43.214  31.852  -2.691  1.00 20.12           C  
ATOM    954  O   SER A 123     -44.291  32.095  -3.234  1.00 21.54           O  
ATOM    955  CB  SER A 123     -43.154  30.593  -0.578  1.00 21.18           C  
ATOM    956  OG  SER A 123     -43.081  29.304  -0.019  1.00 30.77           O  
ATOM    957  N   ARG A 124     -42.244  32.749  -2.586  1.00 19.15           N  
ATOM    958  CA  ARG A 124     -42.416  34.066  -3.167  1.00 20.51           C  
ATOM    959  C   ARG A 124     -42.600  33.897  -4.674  1.00 20.97           C  
ATOM    960  O   ARG A 124     -43.541  34.430  -5.262  1.00 21.81           O  
ATOM    961  CB  ARG A 124     -41.193  34.940  -2.894  1.00 21.42           C  
ATOM    962  CG  ARG A 124     -40.834  35.070  -1.420  1.00 25.93           C  
ATOM    963  CD  ARG A 124     -39.764  36.144  -1.173  1.00 25.46           C  
ATOM    964  NE  ARG A 124     -40.210  37.431  -1.687  1.00 23.97           N  
ATOM    965  CZ  ARG A 124     -40.036  37.824  -2.943  1.00 26.73           C  
ATOM    966  NH1 ARG A 124     -39.411  37.034  -3.805  1.00 26.84           N  
ATOM    967  NH2 ARG A 124     -40.509  38.995  -3.349  1.00 28.25           N  
ATOM    968  N   GLU A 125     -41.702  33.129  -5.286  1.00 22.02           N  
ATOM    969  CA  GLU A 125     -41.720  32.889  -6.732  1.00 22.84           C  
ATOM    970  C   GLU A 125     -42.982  32.204  -7.247  1.00 22.95           C  
ATOM    971  O   GLU A 125     -43.431  32.460  -8.361  1.00 22.86           O  
ATOM    972  CB  GLU A 125     -40.492  32.068  -7.124  1.00 21.53           C  
ATOM    973  CG  GLU A 125     -39.206  32.886  -7.209  1.00 22.91           C  
ATOM    974  CD  GLU A 125     -39.177  33.800  -8.429  1.00 23.19           C  
ATOM    975  OE1 GLU A 125     -39.660  33.370  -9.499  1.00 23.62           O  
ATOM    976  OE2 GLU A 125     -38.658  34.936  -8.328  1.00 24.99           O  
ATOM    977  N   GLN A 126     -43.544  31.337  -6.421  1.00 21.90           N  
ATOM    978  CA  GLN A 126     -44.750  30.605  -6.755  1.00 23.52           C  
ATOM    979  C   GLN A 126     -45.952  31.547  -6.992  1.00 24.68           C  
ATOM    980  O   GLN A 126     -46.835  31.272  -7.811  1.00 23.28           O  
ATOM    981  CB  GLN A 126     -45.036  29.635  -5.613  1.00 24.17           C  
ATOM    982  CG  GLN A 126     -45.951  28.521  -5.966  1.00 27.90           C  
ATOM    983  CD  GLN A 126     -45.338  27.551  -6.946  1.00 26.70           C  
ATOM    984  OE1 GLN A 126     -44.478  26.741  -6.601  1.00 27.84           O  
ATOM    985  NE2 GLN A 126     -45.782  27.629  -8.177  1.00 27.30           N  
ATOM    986  N   LEU A 127     -45.972  32.669  -6.278  1.00 25.10           N  
ATOM    987  CA  LEU A 127     -47.053  33.642  -6.398  1.00 24.50           C  
ATOM    988  C   LEU A 127     -46.650  34.862  -7.199  1.00 25.56           C  
ATOM    989  O   LEU A 127     -47.498  35.650  -7.600  1.00 26.80           O  
ATOM    990  CB  LEU A 127     -47.514  34.103  -5.016  1.00 24.05           C  
ATOM    991  CG  LEU A 127     -48.124  33.028  -4.121  1.00 26.11           C  
ATOM    992  CD1 LEU A 127     -48.554  33.664  -2.820  1.00 27.83           C  
ATOM    993  CD2 LEU A 127     -49.309  32.367  -4.814  1.00 25.08           C  
ATOM    994  N   SER A 128     -45.354  35.026  -7.421  1.00 26.48           N  
ATOM    995  CA  SER A 128     -44.850  36.168  -8.175  1.00 28.30           C  
ATOM    996  C   SER A 128     -43.620  35.676  -8.940  1.00 27.94           C  
ATOM    997  O   SER A 128     -42.488  36.101  -8.682  1.00 28.73           O  
ATOM    998  CB  SER A 128     -44.480  37.300  -7.207  1.00 29.87           C  
ATOM    999  OG  SER A 128     -44.481  38.548  -7.868  1.00 34.00           O  
ATOM   1000  N   PRO A 129     -43.845  34.778  -9.915  1.00 27.26           N  
ATOM   1001  CA  PRO A 129     -42.825  34.157 -10.771  1.00 27.09           C  
ATOM   1002  C   PRO A 129     -41.940  35.118 -11.545  1.00 27.11           C  
ATOM   1003  O   PRO A 129     -42.390  36.164 -12.008  1.00 26.97           O  
ATOM   1004  CB  PRO A 129     -43.636  33.287 -11.736  1.00 27.08           C  
ATOM   1005  CG  PRO A 129     -45.009  33.208 -11.137  1.00 28.33           C  
ATOM   1006  CD  PRO A 129     -45.196  34.514 -10.442  1.00 25.94           C  
ATOM   1007  N   THR A 130     -40.673  34.748 -11.676  1.00 27.00           N  
ATOM   1008  CA  THR A 130     -39.719  35.517 -12.456  1.00 27.07           C  
ATOM   1009  C   THR A 130     -38.937  34.443 -13.193  1.00 27.77           C  
ATOM   1010  O   THR A 130     -39.332  33.273 -13.192  1.00 26.88           O  
ATOM   1011  CB  THR A 130     -38.754  36.348 -11.586  1.00 25.65           C  
ATOM   1012  OG1 THR A 130     -37.849  35.476 -10.903  1.00 26.65           O  
ATOM   1013  CG2 THR A 130     -39.532  37.164 -10.570  1.00 27.25           C  
ATOM   1014  N   SER A 131     -37.838  34.824 -13.827  1.00 28.31           N  
ATOM   1015  CA  SER A 131     -37.036  33.847 -14.545  1.00 27.44           C  
ATOM   1016  C   SER A 131     -36.553  32.787 -13.555  1.00 27.67           C  
ATOM   1017  O   SER A 131     -36.382  31.619 -13.909  1.00 27.73           O  
ATOM   1018  CB  SER A 131     -35.851  34.541 -15.212  1.00 26.51           C  
ATOM   1019  OG  SER A 131     -35.160  35.349 -14.279  1.00 29.21           O  
ATOM   1020  N   ALA A 132     -36.359  33.200 -12.304  1.00 27.44           N  
ATOM   1021  CA  ALA A 132     -35.887  32.296 -11.258  1.00 26.72           C  
ATOM   1022  C   ALA A 132     -36.770  31.060 -11.115  1.00 25.64           C  
ATOM   1023  O   ALA A 132     -36.264  29.942 -11.066  1.00 25.40           O  
ATOM   1024  CB  ALA A 132     -35.793  33.036  -9.922  1.00 26.17           C  
ATOM   1025  N   TYR A 133     -38.085  31.250 -11.051  1.00 25.84           N  
ATOM   1026  CA  TYR A 133     -38.970  30.101 -10.918  1.00 27.21           C  
ATOM   1027  C   TYR A 133     -38.890  29.184 -12.138  1.00 28.60           C  
ATOM   1028  O   TYR A 133     -38.799  27.966 -12.000  1.00 27.56           O  
ATOM   1029  CB  TYR A 133     -40.429  30.528 -10.700  1.00 26.88           C  
ATOM   1030  CG  TYR A 133     -41.330  29.312 -10.601  1.00 28.39           C  
ATOM   1031  CD1 TYR A 133     -41.912  28.753 -11.743  1.00 28.07           C  
ATOM   1032  CD2 TYR A 133     -41.448  28.614  -9.399  1.00 27.12           C  
ATOM   1033  CE1 TYR A 133     -42.566  27.531 -11.690  1.00 27.09           C  
ATOM   1034  CE2 TYR A 133     -42.096  27.396  -9.336  1.00 26.43           C  
ATOM   1035  CZ  TYR A 133     -42.646  26.855 -10.484  1.00 28.17           C  
ATOM   1036  OH  TYR A 133     -43.227  25.609 -10.429  1.00 28.45           O  
ATOM   1037  N   GLN A 134     -38.933  29.776 -13.328  1.00 31.07           N  
ATOM   1038  CA  GLN A 134     -38.870  29.032 -14.584  1.00 32.48           C  
ATOM   1039  C   GLN A 134     -37.669  28.102 -14.588  1.00 31.45           C  
ATOM   1040  O   GLN A 134     -37.757  26.957 -15.024  1.00 31.75           O  
ATOM   1041  CB  GLN A 134     -38.758  30.012 -15.747  1.00 36.25           C  
ATOM   1042  CG  GLN A 134     -38.949  29.404 -17.118  1.00 43.88           C  
ATOM   1043  CD  GLN A 134     -38.636  30.398 -18.243  1.00 50.01           C  
ATOM   1044  OE1 GLN A 134     -39.174  31.516 -18.279  1.00 53.64           O  
ATOM   1045  NE2 GLN A 134     -37.761  29.994 -19.166  1.00 51.85           N  
ATOM   1046  N   LEU A 135     -36.544  28.612 -14.098  1.00 30.74           N  
ATOM   1047  CA  LEU A 135     -35.295  27.857 -14.029  1.00 29.95           C  
ATOM   1048  C   LEU A 135     -35.426  26.604 -13.157  1.00 29.95           C  
ATOM   1049  O   LEU A 135     -35.024  25.508 -13.559  1.00 29.55           O  
ATOM   1050  CB  LEU A 135     -34.186  28.769 -13.486  1.00 29.42           C  
ATOM   1051  CG  LEU A 135     -32.761  28.237 -13.340  1.00 29.67           C  
ATOM   1052  CD1 LEU A 135     -31.832  29.401 -13.021  1.00 30.33           C  
ATOM   1053  CD2 LEU A 135     -32.692  27.192 -12.241  1.00 30.50           C  
ATOM   1054  N   VAL A 136     -35.974  26.777 -11.956  1.00 29.84           N  
ATOM   1055  CA  VAL A 136     -36.163  25.671 -11.026  1.00 27.73           C  
ATOM   1056  C   VAL A 136     -37.253  24.737 -11.542  1.00 29.15           C  
ATOM   1057  O   VAL A 136     -37.194  23.516 -11.359  1.00 28.74           O  
ATOM   1058  CB  VAL A 136     -36.581  26.179  -9.640  1.00 25.49           C  
ATOM   1059  CG1 VAL A 136     -36.685  25.013  -8.677  1.00 23.53           C  
ATOM   1060  CG2 VAL A 136     -35.581  27.209  -9.138  1.00 23.11           C  
ATOM   1061  N   HIS A 137     -38.251  25.314 -12.192  1.00 29.19           N  
ATOM   1062  CA  HIS A 137     -39.340  24.515 -12.711  1.00 31.14           C  
ATOM   1063  C   HIS A 137     -38.848  23.568 -13.793  1.00 32.75           C  
ATOM   1064  O   HIS A 137     -39.169  22.378 -13.794  1.00 33.17           O  
ATOM   1065  CB  HIS A 137     -40.438  25.416 -13.265  1.00 30.59           C  
ATOM   1066  CG  HIS A 137     -41.687  24.678 -13.628  1.00 31.15           C  
ATOM   1067  ND1 HIS A 137     -41.900  24.146 -14.883  1.00 31.45           N  
ATOM   1068  CD2 HIS A 137     -42.767  24.336 -12.886  1.00 30.28           C  
ATOM   1069  CE1 HIS A 137     -43.059  23.509 -14.897  1.00 31.34           C  
ATOM   1070  NE2 HIS A 137     -43.605  23.610 -13.697  1.00 31.17           N  
ATOM   1071  N   GLU A 138     -38.050  24.099 -14.708  1.00 34.53           N  
ATOM   1072  CA  GLU A 138     -37.523  23.307 -15.802  1.00 36.16           C  
ATOM   1073  C   GLU A 138     -36.547  22.228 -15.376  1.00 35.62           C  
ATOM   1074  O   GLU A 138     -36.662  21.083 -15.805  1.00 36.37           O  
ATOM   1075  CB  GLU A 138     -36.888  24.234 -16.829  1.00 38.48           C  
ATOM   1076  CG  GLU A 138     -37.939  24.920 -17.680  1.00 43.92           C  
ATOM   1077  CD  GLU A 138     -37.437  26.179 -18.361  1.00 47.76           C  
ATOM   1078  OE1 GLU A 138     -36.216  26.278 -18.635  1.00 47.96           O  
ATOM   1079  OE2 GLU A 138     -38.283  27.064 -18.631  1.00 49.00           O  
ATOM   1080  N   GLN A 139     -35.601  22.573 -14.513  1.00 35.40           N  
ATOM   1081  CA  GLN A 139     -34.621  21.593 -14.066  1.00 35.59           C  
ATOM   1082  C   GLN A 139     -35.117  20.555 -13.080  1.00 35.54           C  
ATOM   1083  O   GLN A 139     -34.634  19.421 -13.089  1.00 36.04           O  
ATOM   1084  CB  GLN A 139     -33.422  22.271 -13.415  1.00 36.59           C  
ATOM   1085  CG  GLN A 139     -32.618  23.178 -14.308  1.00 39.56           C  
ATOM   1086  CD  GLN A 139     -31.303  23.552 -13.660  1.00 40.30           C  
ATOM   1087  OE1 GLN A 139     -30.679  24.549 -14.034  1.00 41.33           O  
ATOM   1088  NE2 GLN A 139     -30.867  22.744 -12.682  1.00 39.34           N  
ATOM   1089  N   VAL A 140     -36.066  20.920 -12.224  1.00 34.60           N  
ATOM   1090  CA  VAL A 140     -36.505  19.963 -11.222  1.00 34.33           C  
ATOM   1091  C   VAL A 140     -37.990  19.751 -10.964  1.00 34.03           C  
ATOM   1092  O   VAL A 140     -38.484  18.623 -11.067  1.00 34.06           O  
ATOM   1093  CB  VAL A 140     -35.847  20.279  -9.856  1.00 34.30           C  
ATOM   1094  CG1 VAL A 140     -36.049  19.119  -8.895  1.00 34.54           C  
ATOM   1095  CG2 VAL A 140     -34.373  20.550 -10.039  1.00 36.30           C  
ATOM   1096  N   ILE A 141     -38.707  20.813 -10.611  1.00 32.72           N  
ATOM   1097  CA  ILE A 141     -40.110  20.637 -10.280  1.00 32.34           C  
ATOM   1098  C   ILE A 141     -40.949  20.045 -11.412  1.00 31.06           C  
ATOM   1099  O   ILE A 141     -41.779  19.171 -11.165  1.00 29.28           O  
ATOM   1100  CB  ILE A 141     -40.719  21.961  -9.663  1.00 32.60           C  
ATOM   1101  CG1 ILE A 141     -42.104  22.246 -10.216  1.00 33.51           C  
ATOM   1102  CG2 ILE A 141     -39.788  23.118  -9.857  1.00 36.67           C  
ATOM   1103  CD1 ILE A 141     -43.191  21.485  -9.519  1.00 36.56           C  
ATOM   1104  N   ASP A 142     -40.722  20.465 -12.652  1.00 30.59           N  
ATOM   1105  CA  ASP A 142     -41.497  19.895 -13.753  1.00 31.48           C  
ATOM   1106  C   ASP A 142     -41.170  18.399 -13.893  1.00 31.77           C  
ATOM   1107  O   ASP A 142     -42.070  17.561 -13.977  1.00 32.39           O  
ATOM   1108  CB  ASP A 142     -41.216  20.644 -15.059  1.00 33.16           C  
ATOM   1109  CG  ASP A 142     -42.106  20.182 -16.206  1.00 36.60           C  
ATOM   1110  OD1 ASP A 142     -43.298  19.885 -15.972  1.00 37.59           O  
ATOM   1111  OD2 ASP A 142     -41.618  20.132 -17.354  1.00 42.01           O  
ATOM   1112  N   PRO A 143     -39.875  18.042 -13.908  1.00 30.95           N  
ATOM   1113  CA  PRO A 143     -39.515  16.627 -14.031  1.00 30.53           C  
ATOM   1114  C   PRO A 143     -40.091  15.744 -12.912  1.00 30.83           C  
ATOM   1115  O   PRO A 143     -40.729  14.725 -13.186  1.00 30.71           O  
ATOM   1116  CB  PRO A 143     -37.991  16.668 -14.018  1.00 30.20           C  
ATOM   1117  CG  PRO A 143     -37.702  17.959 -14.725  1.00 29.31           C  
ATOM   1118  CD  PRO A 143     -38.685  18.896 -14.076  1.00 30.43           C  
ATOM   1119  N   LEU A 144     -39.872  16.135 -11.658  1.00 31.27           N  
ATOM   1120  CA  LEU A 144     -40.377  15.354 -10.525  1.00 30.80           C  
ATOM   1121  C   LEU A 144     -41.903  15.297 -10.457  1.00 29.34           C  
ATOM   1122  O   LEU A 144     -42.470  14.252 -10.142  1.00 29.75           O  
ATOM   1123  CB  LEU A 144     -39.824  15.904  -9.201  1.00 33.87           C  
ATOM   1124  CG  LEU A 144     -40.350  15.266  -7.893  1.00 38.38           C  
ATOM   1125  CD1 LEU A 144     -39.978  13.769  -7.821  1.00 39.81           C  
ATOM   1126  CD2 LEU A 144     -39.770  16.014  -6.687  1.00 37.61           C  
ATOM   1127  N   HIS A 145     -42.573  16.409 -10.753  1.00 27.58           N  
ATOM   1128  CA  HIS A 145     -44.031  16.443 -10.702  1.00 25.69           C  
ATOM   1129  C   HIS A 145     -44.596  15.513 -11.765  1.00 26.66           C  
ATOM   1130  O   HIS A 145     -45.576  14.802 -11.524  1.00 26.87           O  
ATOM   1131  CB  HIS A 145     -44.545  17.868 -10.940  1.00 24.91           C  
ATOM   1132  CG  HIS A 145     -46.007  18.041 -10.660  1.00 24.84           C  
ATOM   1133  ND1 HIS A 145     -46.482  18.866  -9.661  1.00 23.42           N  
ATOM   1134  CD2 HIS A 145     -47.099  17.492 -11.242  1.00 25.11           C  
ATOM   1135  CE1 HIS A 145     -47.801  18.818  -9.642  1.00 24.65           C  
ATOM   1136  NE2 HIS A 145     -48.202  17.992 -10.591  1.00 26.80           N  
ATOM   1137  N   THR A 146     -43.974  15.524 -12.941  1.00 27.44           N  
ATOM   1138  CA  THR A 146     -44.407  14.678 -14.041  1.00 28.40           C  
ATOM   1139  C   THR A 146     -44.187  13.210 -13.700  1.00 29.23           C  
ATOM   1140  O   THR A 146     -45.023  12.362 -14.010  1.00 29.77           O  
ATOM   1141  CB  THR A 146     -43.651  15.014 -15.320  1.00 29.41           C  
ATOM   1142  OG1 THR A 146     -43.754  16.417 -15.574  1.00 31.24           O  
ATOM   1143  CG2 THR A 146     -44.254  14.273 -16.494  1.00 28.25           C  
ATOM   1144  N   HIS A 147     -43.064  12.905 -13.060  1.00 30.36           N  
ATOM   1145  CA  HIS A 147     -42.788  11.531 -12.662  1.00 32.60           C  
ATOM   1146  C   HIS A 147     -43.853  11.025 -11.702  1.00 32.01           C  
ATOM   1147  O   HIS A 147     -44.414   9.949 -11.903  1.00 31.82           O  
ATOM   1148  CB  HIS A 147     -41.408  11.433 -12.013  1.00 37.46           C  
ATOM   1149  CG  HIS A 147     -40.289  11.420 -13.004  1.00 44.50           C  
ATOM   1150  ND1 HIS A 147     -40.320  12.162 -14.167  1.00 47.96           N  
ATOM   1151  CD2 HIS A 147     -39.118  10.742 -13.021  1.00 47.77           C  
ATOM   1152  CE1 HIS A 147     -39.216  11.939 -14.859  1.00 48.74           C  
ATOM   1153  NE2 HIS A 147     -38.470  11.081 -14.185  1.00 49.27           N  
ATOM   1154  N   LEU A 148     -44.142  11.807 -10.667  1.00 30.40           N  
ATOM   1155  CA  LEU A 148     -45.146  11.409  -9.691  1.00 30.53           C  
ATOM   1156  C   LEU A 148     -46.491  11.212 -10.349  1.00 29.64           C  
ATOM   1157  O   LEU A 148     -47.188  10.248 -10.063  1.00 29.60           O  
ATOM   1158  CB  LEU A 148     -45.242  12.445  -8.576  1.00 31.22           C  
ATOM   1159  CG  LEU A 148     -44.009  12.343  -7.674  1.00 33.77           C  
ATOM   1160  CD1 LEU A 148     -43.871  13.587  -6.803  1.00 34.10           C  
ATOM   1161  CD2 LEU A 148     -44.115  11.060  -6.838  1.00 34.01           C  
ATOM   1162  N   THR A 149     -46.851  12.128 -11.238  1.00 30.24           N  
ATOM   1163  CA  THR A 149     -48.112  12.024 -11.957  1.00 30.51           C  
ATOM   1164  C   THR A 149     -48.105  10.713 -12.738  1.00 31.05           C  
ATOM   1165  O   THR A 149     -49.106  10.005 -12.774  1.00 30.11           O  
ATOM   1166  CB  THR A 149     -48.291  13.195 -12.934  1.00 30.01           C  
ATOM   1167  OG1 THR A 149     -48.154  14.435 -12.221  1.00 28.40           O  
ATOM   1168  CG2 THR A 149     -49.660  13.130 -13.587  1.00 27.65           C  
ATOM   1169  N   ARG A 150     -46.967  10.398 -13.355  1.00 32.41           N  
ATOM   1170  CA  ARG A 150     -46.807   9.154 -14.113  1.00 35.29           C  
ATOM   1171  C   ARG A 150     -46.980   7.955 -13.187  1.00 34.07           C  
ATOM   1172  O   ARG A 150     -47.720   7.019 -13.502  1.00 33.93           O  
ATOM   1173  CB  ARG A 150     -45.418   9.079 -14.753  1.00 39.51           C  
ATOM   1174  CG  ARG A 150     -45.391   9.244 -16.267  1.00 47.71           C  
ATOM   1175  CD  ARG A 150     -45.937  10.610 -16.686  1.00 55.83           C  
ATOM   1176  NE  ARG A 150     -45.911  10.816 -18.141  1.00 62.10           N  
ATOM   1177  CZ  ARG A 150     -46.467  11.859 -18.764  1.00 65.07           C  
ATOM   1178  NH1 ARG A 150     -47.098  12.802 -18.063  1.00 66.09           N  
ATOM   1179  NH2 ARG A 150     -46.402  11.959 -20.089  1.00 65.95           N  
ATOM   1180  N   LEU A 151     -46.295   7.990 -12.045  1.00 32.31           N  
ATOM   1181  CA  LEU A 151     -46.375   6.906 -11.072  1.00 30.60           C  
ATOM   1182  C   LEU A 151     -47.801   6.716 -10.588  1.00 30.82           C  
ATOM   1183  O   LEU A 151     -48.304   5.591 -10.551  1.00 30.68           O  
ATOM   1184  CB  LEU A 151     -45.469   7.182  -9.875  1.00 30.17           C  
ATOM   1185  CG  LEU A 151     -43.960   7.154 -10.127  1.00 31.37           C  
ATOM   1186  CD1 LEU A 151     -43.236   7.607  -8.869  1.00 30.10           C  
ATOM   1187  CD2 LEU A 151     -43.517   5.750 -10.524  1.00 30.77           C  
ATOM   1188  N   VAL A 152     -48.460   7.813 -10.222  1.00 30.52           N  
ATOM   1189  CA  VAL A 152     -49.837   7.719  -9.734  1.00 30.60           C  
ATOM   1190  C   VAL A 152     -50.758   7.177 -10.833  1.00 30.52           C  
ATOM   1191  O   VAL A 152     -51.667   6.388 -10.562  1.00 29.64           O  
ATOM   1192  CB  VAL A 152     -50.356   9.099  -9.207  1.00 28.60           C  
ATOM   1193  CG1 VAL A 152     -51.796   8.995  -8.769  1.00 27.09           C  
ATOM   1194  CG2 VAL A 152     -49.537   9.534  -8.014  1.00 28.34           C  
ATOM   1195  N   ALA A 153     -50.505   7.591 -12.071  1.00 31.18           N  
ATOM   1196  CA  ALA A 153     -51.301   7.141 -13.207  1.00 32.54           C  
ATOM   1197  C   ALA A 153     -51.097   5.638 -13.423  1.00 32.86           C  
ATOM   1198  O   ALA A 153     -52.058   4.894 -13.627  1.00 33.12           O  
ATOM   1199  CB  ALA A 153     -50.912   7.924 -14.465  1.00 30.92           C  
ATOM   1200  N   ALA A 154     -49.846   5.197 -13.373  1.00 32.49           N  
ATOM   1201  CA  ALA A 154     -49.536   3.781 -13.549  1.00 33.24           C  
ATOM   1202  C   ALA A 154     -50.213   2.920 -12.481  1.00 35.01           C  
ATOM   1203  O   ALA A 154     -50.772   1.864 -12.779  1.00 36.44           O  
ATOM   1204  CB  ALA A 154     -48.024   3.565 -13.503  1.00 31.68           C  
ATOM   1205  N   TYR A 155     -50.177   3.375 -11.235  1.00 35.76           N  
ATOM   1206  CA  TYR A 155     -50.771   2.613 -10.152  1.00 34.97           C  
ATOM   1207  C   TYR A 155     -52.285   2.469 -10.252  1.00 36.25           C  
ATOM   1208  O   TYR A 155     -52.816   1.368 -10.112  1.00 38.37           O  
ATOM   1209  CB  TYR A 155     -50.425   3.255  -8.812  1.00 33.77           C  
ATOM   1210  CG  TYR A 155     -50.777   2.389  -7.631  1.00 32.49           C  
ATOM   1211  CD1 TYR A 155     -49.874   1.436  -7.153  1.00 32.74           C  
ATOM   1212  CD2 TYR A 155     -52.020   2.500  -7.002  1.00 31.54           C  
ATOM   1213  CE1 TYR A 155     -50.196   0.614  -6.077  1.00 32.02           C  
ATOM   1214  CE2 TYR A 155     -52.356   1.683  -5.927  1.00 32.15           C  
ATOM   1215  CZ  TYR A 155     -51.436   0.742  -5.469  1.00 33.23           C  
ATOM   1216  OH  TYR A 155     -51.745  -0.066  -4.398  1.00 34.71           O  
ATOM   1217  N   THR A 156     -52.981   3.580 -10.478  1.00 37.04           N  
ATOM   1218  CA  THR A 156     -54.442   3.563 -10.555  1.00 36.56           C  
ATOM   1219  C   THR A 156     -54.949   3.077 -11.898  1.00 37.40           C  
ATOM   1220  O   THR A 156     -56.129   2.750 -12.042  1.00 38.33           O  
ATOM   1221  CB  THR A 156     -55.043   4.971 -10.296  1.00 36.10           C  
ATOM   1222  OG1 THR A 156     -54.611   5.878 -11.319  1.00 33.85           O  
ATOM   1223  CG2 THR A 156     -54.604   5.497  -8.932  1.00 35.72           C  
ATOM   1224  N   GLY A 157     -54.047   3.038 -12.875  1.00 38.12           N  
ATOM   1225  CA  GLY A 157     -54.405   2.600 -14.210  1.00 37.84           C  
ATOM   1226  C   GLY A 157     -55.079   3.706 -14.994  1.00 38.66           C  
ATOM   1227  O   GLY A 157     -56.022   3.447 -15.738  1.00 39.27           O  
ATOM   1228  N   CYS A 158     -54.594   4.938 -14.831  1.00 38.67           N  
ATOM   1229  CA  CYS A 158     -55.164   6.096 -15.521  1.00 37.80           C  
ATOM   1230  C   CYS A 158     -54.175   6.731 -16.493  1.00 37.65           C  
ATOM   1231  O   CYS A 158     -53.014   6.326 -16.563  1.00 38.01           O  
ATOM   1232  CB  CYS A 158     -55.626   7.139 -14.501  1.00 37.14           C  
ATOM   1233  SG  CYS A 158     -56.975   6.577 -13.435  1.00 40.82           S  
ATOM   1234  N   ASP A 159     -54.644   7.729 -17.238  1.00 37.59           N  
ATOM   1235  CA  ASP A 159     -53.805   8.420 -18.213  1.00 38.38           C  
ATOM   1236  C   ASP A 159     -53.030   9.555 -17.541  1.00 37.72           C  
ATOM   1237  O   ASP A 159     -53.622  10.509 -17.023  1.00 36.06           O  
ATOM   1238  CB  ASP A 159     -54.669   8.981 -19.354  1.00 40.54           C  
ATOM   1239  CG  ASP A 159     -53.843   9.425 -20.561  1.00 43.20           C  
ATOM   1240  OD1 ASP A 159     -52.611   9.599 -20.429  1.00 45.24           O  
ATOM   1241  OD2 ASP A 159     -54.430   9.614 -21.648  1.00 46.98           O  
ATOM   1242  N   ALA A 160     -51.705   9.443 -17.566  1.00 37.89           N  
ATOM   1243  CA  ALA A 160     -50.826  10.435 -16.963  1.00 38.59           C  
ATOM   1244  C   ALA A 160     -50.961  11.813 -17.601  1.00 39.82           C  
ATOM   1245  O   ALA A 160     -50.658  12.825 -16.968  1.00 40.66           O  
ATOM   1246  CB  ALA A 160     -49.379   9.968 -17.052  1.00 37.33           C  
ATOM   1247  N   ASN A 161     -51.422  11.854 -18.850  1.00 40.30           N  
ATOM   1248  CA  ASN A 161     -51.575  13.117 -19.568  1.00 40.15           C  
ATOM   1249  C   ASN A 161     -52.937  13.781 -19.382  1.00 39.91           C  
ATOM   1250  O   ASN A 161     -53.149  14.910 -19.814  1.00 40.48           O  
ATOM   1251  CB  ASN A 161     -51.290  12.893 -21.055  1.00 41.66           C  
ATOM   1252  CG  ASN A 161     -49.847  12.470 -21.313  1.00 44.09           C  
ATOM   1253  OD1 ASN A 161     -49.588  11.532 -22.070  1.00 46.98           O  
ATOM   1254  ND2 ASN A 161     -48.900  13.166 -20.681  1.00 43.80           N  
ATOM   1255  N   ASP A 162     -53.861  13.083 -18.732  1.00 39.88           N  
ATOM   1256  CA  ASP A 162     -55.185  13.633 -18.487  1.00 39.44           C  
ATOM   1257  C   ASP A 162     -55.065  14.723 -17.423  1.00 38.60           C  
ATOM   1258  O   ASP A 162     -54.439  14.518 -16.386  1.00 39.51           O  
ATOM   1259  CB  ASP A 162     -56.119  12.534 -17.986  1.00 42.03           C  
ATOM   1260  CG  ASP A 162     -57.565  12.997 -17.874  1.00 46.00           C  
ATOM   1261  OD1 ASP A 162     -57.806  14.152 -17.459  1.00 47.70           O  
ATOM   1262  OD2 ASP A 162     -58.471  12.194 -18.189  1.00 49.83           O  
ATOM   1263  N   THR A 163     -55.663  15.881 -17.678  1.00 36.70           N  
ATOM   1264  CA  THR A 163     -55.627  16.989 -16.729  1.00 34.61           C  
ATOM   1265  C   THR A 163     -56.031  16.563 -15.315  1.00 34.96           C  
ATOM   1266  O   THR A 163     -55.405  16.966 -14.337  1.00 35.11           O  
ATOM   1267  CB  THR A 163     -56.567  18.133 -17.175  1.00 32.41           C  
ATOM   1268  OG1 THR A 163     -56.097  18.675 -18.412  1.00 30.79           O  
ATOM   1269  CG2 THR A 163     -56.610  19.239 -16.129  1.00 30.39           C  
ATOM   1270  N   ARG A 164     -57.079  15.754 -15.214  1.00 34.50           N  
ATOM   1271  CA  ARG A 164     -57.563  15.298 -13.921  1.00 34.91           C  
ATOM   1272  C   ARG A 164     -56.524  14.503 -13.140  1.00 32.97           C  
ATOM   1273  O   ARG A 164     -56.545  14.497 -11.911  1.00 32.88           O  
ATOM   1274  CB  ARG A 164     -58.835  14.463 -14.101  1.00 38.38           C  
ATOM   1275  CG  ARG A 164     -60.075  15.295 -14.401  1.00 44.28           C  
ATOM   1276  CD  ARG A 164     -61.255  14.445 -14.893  1.00 49.47           C  
ATOM   1277  NE  ARG A 164     -60.953  13.748 -16.150  1.00 54.29           N  
ATOM   1278  CZ  ARG A 164     -61.841  13.054 -16.866  1.00 55.64           C  
ATOM   1279  NH1 ARG A 164     -63.104  12.961 -16.459  1.00 57.00           N  
ATOM   1280  NH2 ARG A 164     -61.463  12.434 -17.981  1.00 54.87           N  
ATOM   1281  N   MET A 165     -55.616  13.838 -13.846  1.00 30.66           N  
ATOM   1282  CA  MET A 165     -54.578  13.042 -13.188  1.00 29.51           C  
ATOM   1283  C   MET A 165     -53.481  13.985 -12.646  1.00 29.33           C  
ATOM   1284  O   MET A 165     -52.843  13.712 -11.624  1.00 28.46           O  
ATOM   1285  CB  MET A 165     -54.000  12.027 -14.185  1.00 29.14           C  
ATOM   1286  CG  MET A 165     -53.391  10.776 -13.563  1.00 29.41           C  
ATOM   1287  SD  MET A 165     -54.490   9.875 -12.460  1.00 28.04           S  
ATOM   1288  CE  MET A 165     -53.437   9.553 -11.304  1.00 25.86           C  
ATOM   1289  N   ILE A 166     -53.277  15.103 -13.332  1.00 26.98           N  
ATOM   1290  CA  ILE A 166     -52.302  16.092 -12.904  1.00 25.75           C  
ATOM   1291  C   ILE A 166     -52.862  16.785 -11.646  1.00 25.27           C  
ATOM   1292  O   ILE A 166     -52.129  17.074 -10.699  1.00 24.40           O  
ATOM   1293  CB  ILE A 166     -52.048  17.108 -14.051  1.00 26.24           C  
ATOM   1294  CG1 ILE A 166     -51.438  16.360 -15.243  1.00 24.78           C  
ATOM   1295  CG2 ILE A 166     -51.133  18.251 -13.584  1.00 22.84           C  
ATOM   1296  CD1 ILE A 166     -51.296  17.193 -16.489  1.00 25.52           C  
ATOM   1297  N   LEU A 167     -54.173  17.017 -11.631  1.00 24.78           N  
ATOM   1298  CA  LEU A 167     -54.827  17.657 -10.500  1.00 23.88           C  
ATOM   1299  C   LEU A 167     -54.823  16.752  -9.275  1.00 24.81           C  
ATOM   1300  O   LEU A 167     -54.610  17.210  -8.155  1.00 25.18           O  
ATOM   1301  CB  LEU A 167     -56.270  18.029 -10.856  1.00 22.61           C  
ATOM   1302  CG  LEU A 167     -56.484  19.071 -11.962  1.00 22.73           C  
ATOM   1303  CD1 LEU A 167     -57.969  19.392 -12.050  1.00 22.01           C  
ATOM   1304  CD2 LEU A 167     -55.696  20.343 -11.675  1.00 18.65           C  
ATOM   1305  N   HIS A 168     -55.071  15.465  -9.486  1.00 25.61           N  
ATOM   1306  CA  HIS A 168     -55.074  14.498  -8.390  1.00 24.59           C  
ATOM   1307  C   HIS A 168     -53.722  14.453  -7.707  1.00 23.03           C  
ATOM   1308  O   HIS A 168     -53.631  14.520  -6.484  1.00 22.24           O  
ATOM   1309  CB  HIS A 168     -55.415  13.102  -8.912  1.00 25.88           C  
ATOM   1310  CG  HIS A 168     -56.878  12.820  -8.933  1.00 29.01           C  
ATOM   1311  ND1 HIS A 168     -57.619  12.680  -7.780  1.00 30.40           N  
ATOM   1312  CD2 HIS A 168     -57.755  12.726  -9.958  1.00 31.06           C  
ATOM   1313  CE1 HIS A 168     -58.892  12.519  -8.095  1.00 31.80           C  
ATOM   1314  NE2 HIS A 168     -59.002  12.544  -9.412  1.00 31.15           N  
ATOM   1315  N   THR A 169     -52.676  14.334  -8.518  1.00 22.01           N  
ATOM   1316  CA  THR A 169     -51.303  14.265  -8.030  1.00 23.52           C  
ATOM   1317  C   THR A 169     -50.883  15.535  -7.277  1.00 23.64           C  
ATOM   1318  O   THR A 169     -50.260  15.459  -6.217  1.00 24.80           O  
ATOM   1319  CB  THR A 169     -50.335  14.008  -9.212  1.00 22.78           C  
ATOM   1320  OG1 THR A 169     -50.655  12.743  -9.803  1.00 23.42           O  
ATOM   1321  CG2 THR A 169     -48.882  14.004  -8.749  1.00 21.26           C  
ATOM   1322  N   HIS A 170     -51.223  16.699  -7.821  1.00 22.52           N  
ATOM   1323  CA  HIS A 170     -50.873  17.949  -7.177  1.00 21.01           C  
ATOM   1324  C   HIS A 170     -51.576  18.050  -5.830  1.00 22.24           C  
ATOM   1325  O   HIS A 170     -50.987  18.489  -4.849  1.00 22.59           O  
ATOM   1326  CB  HIS A 170     -51.269  19.121  -8.063  1.00 18.79           C  
ATOM   1327  CG  HIS A 170     -50.608  20.407  -7.681  1.00 18.39           C  
ATOM   1328  ND1 HIS A 170     -51.213  21.346  -6.874  1.00 20.14           N  
ATOM   1329  CD2 HIS A 170     -49.379  20.894  -7.968  1.00 15.70           C  
ATOM   1330  CE1 HIS A 170     -50.386  22.358  -6.682  1.00 17.86           C  
ATOM   1331  NE2 HIS A 170     -49.265  22.107  -7.336  1.00 19.98           N  
ATOM   1332  N   ALA A 171     -52.835  17.620  -5.784  1.00 23.25           N  
ATOM   1333  CA  ALA A 171     -53.617  17.672  -4.555  1.00 24.02           C  
ATOM   1334  C   ALA A 171     -52.984  16.804  -3.488  1.00 26.02           C  
ATOM   1335  O   ALA A 171     -52.860  17.220  -2.334  1.00 27.87           O  
ATOM   1336  CB  ALA A 171     -55.050  17.219  -4.811  1.00 21.22           C  
ATOM   1337  N   LEU A 172     -52.556  15.604  -3.847  1.00 27.42           N  
ATOM   1338  CA  LEU A 172     -51.964  14.786  -2.813  1.00 29.67           C  
ATOM   1339  C   LEU A 172     -50.553  15.207  -2.428  1.00 30.00           C  
ATOM   1340  O   LEU A 172     -50.076  14.827  -1.366  1.00 30.78           O  
ATOM   1341  CB  LEU A 172     -52.044  13.306  -3.177  1.00 31.98           C  
ATOM   1342  CG  LEU A 172     -51.316  12.724  -4.366  1.00 33.55           C  
ATOM   1343  CD1 LEU A 172     -49.817  12.691  -4.089  1.00 35.72           C  
ATOM   1344  CD2 LEU A 172     -51.851  11.319  -4.583  1.00 33.57           C  
ATOM   1345  N   LEU A 173     -49.889  16.000  -3.267  1.00 30.65           N  
ATOM   1346  CA  LEU A 173     -48.549  16.493  -2.930  1.00 31.16           C  
ATOM   1347  C   LEU A 173     -48.706  17.599  -1.892  1.00 30.42           C  
ATOM   1348  O   LEU A 173     -47.785  17.891  -1.131  1.00 28.71           O  
ATOM   1349  CB  LEU A 173     -47.843  17.088  -4.149  1.00 33.49           C  
ATOM   1350  CG  LEU A 173     -47.349  16.115  -5.212  1.00 37.11           C  
ATOM   1351  CD1 LEU A 173     -46.609  16.888  -6.306  1.00 36.59           C  
ATOM   1352  CD2 LEU A 173     -46.438  15.083  -4.557  1.00 37.61           C  
ATOM   1353  N   GLY A 174     -49.881  18.220  -1.887  1.00 29.41           N  
ATOM   1354  CA  GLY A 174     -50.154  19.274  -0.934  1.00 29.87           C  
ATOM   1355  C   GLY A 174     -50.167  18.719   0.477  1.00 29.67           C  
ATOM   1356  O   GLY A 174     -49.868  19.440   1.422  1.00 29.25           O  
ATOM   1357  N   GLU A 175     -50.514  17.441   0.618  1.00 29.11           N  
ATOM   1358  CA  GLU A 175     -50.547  16.787   1.925  1.00 30.15           C  
ATOM   1359  C   GLU A 175     -49.175  16.876   2.561  1.00 31.36           C  
ATOM   1360  O   GLU A 175     -49.048  17.112   3.757  1.00 32.20           O  
ATOM   1361  CB  GLU A 175     -50.910  15.313   1.787  1.00 30.40           C  
ATOM   1362  CG  GLU A 175     -52.302  15.054   1.277  1.00 33.68           C  
ATOM   1363  CD  GLU A 175     -53.194  14.418   2.326  1.00 36.06           C  
ATOM   1364  OE1 GLU A 175     -52.710  14.154   3.452  1.00 36.80           O  
ATOM   1365  OE2 GLU A 175     -54.383  14.181   2.022  1.00 36.40           O  
ATOM   1366  N   VAL A 176     -48.145  16.664   1.753  1.00 31.69           N  
ATOM   1367  CA  VAL A 176     -46.783  16.730   2.251  1.00 32.71           C  
ATOM   1368  C   VAL A 176     -46.375  18.183   2.529  1.00 33.78           C  
ATOM   1369  O   VAL A 176     -45.948  18.520   3.634  1.00 36.18           O  
ATOM   1370  CB  VAL A 176     -45.782  16.136   1.235  1.00 33.34           C  
ATOM   1371  CG1 VAL A 176     -44.379  16.229   1.799  1.00 33.96           C  
ATOM   1372  CG2 VAL A 176     -46.142  14.693   0.904  1.00 30.16           C  
ATOM   1373  N   LEU A 177     -46.518  19.041   1.525  1.00 31.16           N  
ATOM   1374  CA  LEU A 177     -46.138  20.438   1.653  1.00 29.21           C  
ATOM   1375  C   LEU A 177     -46.875  21.229   2.726  1.00 28.66           C  
ATOM   1376  O   LEU A 177     -46.398  22.278   3.163  1.00 28.83           O  
ATOM   1377  CB  LEU A 177     -46.293  21.129   0.298  1.00 30.27           C  
ATOM   1378  CG  LEU A 177     -45.154  20.866  -0.699  1.00 30.28           C  
ATOM   1379  CD1 LEU A 177     -44.798  19.387  -0.755  1.00 31.13           C  
ATOM   1380  CD2 LEU A 177     -45.581  21.358  -2.066  1.00 31.99           C  
ATOM   1381  N   ALA A 178     -48.026  20.733   3.161  1.00 26.57           N  
ATOM   1382  CA  ALA A 178     -48.797  21.438   4.177  1.00 24.74           C  
ATOM   1383  C   ALA A 178     -47.974  21.700   5.419  1.00 24.70           C  
ATOM   1384  O   ALA A 178     -48.080  22.765   6.031  1.00 24.79           O  
ATOM   1385  CB  ALA A 178     -50.037  20.639   4.560  1.00 23.99           C  
ATOM   1386  N   PHE A 179     -47.137  20.740   5.785  1.00 23.07           N  
ATOM   1387  CA  PHE A 179     -46.350  20.873   6.998  1.00 22.72           C  
ATOM   1388  C   PHE A 179     -45.255  21.930   7.015  1.00 23.74           C  
ATOM   1389  O   PHE A 179     -44.857  22.379   8.087  1.00 24.61           O  
ATOM   1390  CB  PHE A 179     -45.825  19.495   7.379  1.00 20.00           C  
ATOM   1391  CG  PHE A 179     -46.922  18.550   7.750  1.00 19.56           C  
ATOM   1392  CD1 PHE A 179     -47.379  18.476   9.063  1.00 18.19           C  
ATOM   1393  CD2 PHE A 179     -47.589  17.830   6.769  1.00 18.23           C  
ATOM   1394  CE1 PHE A 179     -48.488  17.707   9.394  1.00 18.44           C  
ATOM   1395  CE2 PHE A 179     -48.707  17.054   7.089  1.00 19.85           C  
ATOM   1396  CZ  PHE A 179     -49.155  16.995   8.404  1.00 18.84           C  
ATOM   1397  N   ARG A 180     -44.780  22.341   5.844  1.00 24.32           N  
ATOM   1398  CA  ARG A 180     -43.746  23.373   5.753  1.00 24.95           C  
ATOM   1399  C   ARG A 180     -44.420  24.690   5.390  1.00 26.46           C  
ATOM   1400  O   ARG A 180     -44.131  25.743   5.968  1.00 26.21           O  
ATOM   1401  CB  ARG A 180     -42.702  22.998   4.691  1.00 25.72           C  
ATOM   1402  CG  ARG A 180     -41.815  24.147   4.187  1.00 24.65           C  
ATOM   1403  CD  ARG A 180     -41.101  24.933   5.304  1.00 25.72           C  
ATOM   1404  NE  ARG A 180     -40.103  24.188   6.074  1.00 23.59           N  
ATOM   1405  CZ  ARG A 180     -38.940  23.750   5.597  1.00 26.67           C  
ATOM   1406  NH1 ARG A 180     -38.603  23.972   4.331  1.00 24.20           N  
ATOM   1407  NH2 ARG A 180     -38.100  23.095   6.398  1.00 25.91           N  
ATOM   1408  N   LEU A 181     -45.344  24.627   4.440  1.00 27.03           N  
ATOM   1409  CA  LEU A 181     -46.041  25.827   4.023  1.00 27.81           C  
ATOM   1410  C   LEU A 181     -47.003  26.324   5.108  1.00 26.43           C  
ATOM   1411  O   LEU A 181     -47.291  27.515   5.181  1.00 26.81           O  
ATOM   1412  CB  LEU A 181     -46.753  25.569   2.692  1.00 31.13           C  
ATOM   1413  CG  LEU A 181     -45.752  25.204   1.582  1.00 33.99           C  
ATOM   1414  CD1 LEU A 181     -46.504  24.955   0.271  1.00 34.82           C  
ATOM   1415  CD2 LEU A 181     -44.708  26.322   1.420  1.00 30.85           C  
ATOM   1416  N   GLY A 182     -47.481  25.422   5.960  1.00 24.01           N  
ATOM   1417  CA  GLY A 182     -48.366  25.828   7.044  1.00 21.30           C  
ATOM   1418  C   GLY A 182     -47.677  25.526   8.364  1.00 20.64           C  
ATOM   1419  O   GLY A 182     -48.312  25.142   9.347  1.00 18.43           O  
ATOM   1420  N   LYS A 183     -46.361  25.713   8.371  1.00 19.89           N  
ATOM   1421  CA  LYS A 183     -45.508  25.435   9.526  1.00 21.29           C  
ATOM   1422  C   LYS A 183     -45.950  25.998  10.883  1.00 20.79           C  
ATOM   1423  O   LYS A 183     -46.159  25.246  11.851  1.00 19.94           O  
ATOM   1424  CB  LYS A 183     -44.078  25.906   9.234  1.00 21.72           C  
ATOM   1425  CG  LYS A 183     -43.098  25.505  10.303  1.00 21.33           C  
ATOM   1426  CD  LYS A 183     -41.716  25.995   9.989  1.00 24.75           C  
ATOM   1427  CE  LYS A 183     -40.791  25.714  11.168  1.00 26.81           C  
ATOM   1428  NZ  LYS A 183     -39.387  26.124  10.893  1.00 28.31           N  
ATOM   1429  N   GLU A 184     -46.079  27.318  10.964  1.00 19.82           N  
ATOM   1430  CA  GLU A 184     -46.469  27.937  12.217  1.00 17.83           C  
ATOM   1431  C   GLU A 184     -47.826  27.458  12.700  1.00 17.52           C  
ATOM   1432  O   GLU A 184     -47.986  27.165  13.885  1.00 17.58           O  
ATOM   1433  CB  GLU A 184     -46.457  29.457  12.090  1.00 18.20           C  
ATOM   1434  CG  GLU A 184     -46.426  30.170  13.422  1.00 22.82           C  
ATOM   1435  CD  GLU A 184     -45.271  29.713  14.317  1.00 25.97           C  
ATOM   1436  OE1 GLU A 184     -44.264  29.168  13.805  1.00 26.18           O  
ATOM   1437  OE2 GLU A 184     -45.364  29.919  15.545  1.00 27.44           O  
ATOM   1438  N   THR A 185     -48.809  27.342  11.812  1.00 16.24           N  
ATOM   1439  CA  THR A 185     -50.100  26.888  12.298  1.00 18.63           C  
ATOM   1440  C   THR A 185     -50.101  25.443  12.793  1.00 17.82           C  
ATOM   1441  O   THR A 185     -50.787  25.144  13.771  1.00 19.16           O  
ATOM   1442  CB  THR A 185     -51.276  27.093  11.277  1.00 19.61           C  
ATOM   1443  OG1 THR A 185     -51.925  25.840  11.045  1.00 23.62           O  
ATOM   1444  CG2 THR A 185     -50.814  27.702   9.994  1.00 16.53           C  
ATOM   1445  N   ILE A 186     -49.343  24.543  12.159  1.00 17.70           N  
ATOM   1446  CA  ILE A 186     -49.326  23.153  12.643  1.00 18.02           C  
ATOM   1447  C   ILE A 186     -48.498  23.005  13.934  1.00 18.51           C  
ATOM   1448  O   ILE A 186     -48.844  22.204  14.814  1.00 19.56           O  
ATOM   1449  CB  ILE A 186     -48.810  22.130  11.568  1.00 17.36           C  
ATOM   1450  CG1 ILE A 186     -49.073  20.703  12.057  1.00 15.57           C  
ATOM   1451  CG2 ILE A 186     -47.322  22.299  11.315  1.00 14.55           C  
ATOM   1452  CD1 ILE A 186     -50.527  20.453  12.410  1.00 15.27           C  
ATOM   1453  N   LEU A 187     -47.409  23.766  14.058  1.00 17.88           N  
ATOM   1454  CA  LEU A 187     -46.614  23.695  15.277  1.00 18.71           C  
ATOM   1455  C   LEU A 187     -47.488  24.189  16.438  1.00 19.44           C  
ATOM   1456  O   LEU A 187     -47.554  23.558  17.492  1.00 20.73           O  
ATOM   1457  CB  LEU A 187     -45.351  24.550  15.156  1.00 17.64           C  
ATOM   1458  CG  LEU A 187     -44.264  24.024  14.206  1.00 19.25           C  
ATOM   1459  CD1 LEU A 187     -43.046  24.950  14.259  1.00 15.94           C  
ATOM   1460  CD2 LEU A 187     -43.875  22.599  14.594  1.00 16.14           C  
ATOM   1461  N   LEU A 188     -48.172  25.311  16.238  1.00 18.98           N  
ATOM   1462  CA  LEU A 188     -49.035  25.851  17.280  1.00 19.11           C  
ATOM   1463  C   LEU A 188     -50.190  24.905  17.614  1.00 19.87           C  
ATOM   1464  O   LEU A 188     -50.487  24.665  18.779  1.00 22.32           O  
ATOM   1465  CB  LEU A 188     -49.578  27.227  16.864  1.00 17.55           C  
ATOM   1466  CG  LEU A 188     -48.547  28.364  16.835  1.00 18.85           C  
ATOM   1467  CD1 LEU A 188     -49.209  29.682  16.468  1.00 16.22           C  
ATOM   1468  CD2 LEU A 188     -47.882  28.478  18.208  1.00 17.04           C  
ATOM   1469  N   ARG A 189     -50.838  24.355  16.598  1.00 19.70           N  
ATOM   1470  CA  ARG A 189     -51.954  23.449  16.830  1.00 20.18           C  
ATOM   1471  C   ARG A 189     -51.570  22.151  17.558  1.00 22.07           C  
ATOM   1472  O   ARG A 189     -52.327  21.658  18.400  1.00 22.99           O  
ATOM   1473  CB  ARG A 189     -52.642  23.137  15.495  1.00 18.65           C  
ATOM   1474  CG  ARG A 189     -53.513  24.290  14.974  1.00 19.39           C  
ATOM   1475  CD  ARG A 189     -54.870  24.340  15.683  1.00 21.25           C  
ATOM   1476  NE  ARG A 189     -55.676  23.157  15.380  1.00 22.33           N  
ATOM   1477  CZ  ARG A 189     -56.174  22.317  16.289  1.00 25.04           C  
ATOM   1478  NH1 ARG A 189     -55.962  22.520  17.584  1.00 26.63           N  
ATOM   1479  NH2 ARG A 189     -56.870  21.257  15.903  1.00 23.24           N  
ATOM   1480  N   THR A 190     -50.401  21.597  17.239  1.00 22.15           N  
ATOM   1481  CA  THR A 190     -49.927  20.363  17.872  1.00 22.76           C  
ATOM   1482  C   THR A 190     -49.215  20.614  19.203  1.00 23.64           C  
ATOM   1483  O   THR A 190     -49.123  19.718  20.039  1.00 23.43           O  
ATOM   1484  CB  THR A 190     -48.920  19.637  16.989  1.00 22.37           C  
ATOM   1485  OG1 THR A 190     -47.818  20.515  16.734  1.00 21.71           O  
ATOM   1486  CG2 THR A 190     -49.557  19.206  15.675  1.00 22.53           C  
ATOM   1487  N   GLY A 191     -48.698  21.826  19.384  1.00 23.84           N  
ATOM   1488  CA  GLY A 191     -47.986  22.151  20.604  1.00 23.15           C  
ATOM   1489  C   GLY A 191     -46.508  21.846  20.460  1.00 25.79           C  
ATOM   1490  O   GLY A 191     -45.734  22.032  21.398  1.00 27.31           O  
ATOM   1491  N   TRP A 192     -46.107  21.366  19.286  1.00 25.39           N  
ATOM   1492  CA  TRP A 192     -44.705  21.048  19.036  1.00 25.30           C  
ATOM   1493  C   TRP A 192     -43.882  22.324  18.903  1.00 26.50           C  
ATOM   1494  O   TRP A 192     -44.255  23.234  18.171  1.00 28.24           O  
ATOM   1495  CB  TRP A 192     -44.546  20.248  17.745  1.00 24.29           C  
ATOM   1496  CG  TRP A 192     -45.187  18.902  17.750  1.00 25.49           C  
ATOM   1497  CD1 TRP A 192     -45.641  18.206  18.838  1.00 25.44           C  
ATOM   1498  CD2 TRP A 192     -45.396  18.058  16.614  1.00 25.87           C  
ATOM   1499  NE1 TRP A 192     -46.119  16.979  18.444  1.00 25.77           N  
ATOM   1500  CE2 TRP A 192     -45.980  16.861  17.085  1.00 26.08           C  
ATOM   1501  CE3 TRP A 192     -45.145  18.195  15.238  1.00 26.40           C  
ATOM   1502  CZ2 TRP A 192     -46.319  15.798  16.223  1.00 27.38           C  
ATOM   1503  CZ3 TRP A 192     -45.483  17.136  14.379  1.00 26.54           C  
ATOM   1504  CH2 TRP A 192     -46.063  15.957  14.880  1.00 26.49           C  
ATOM   1505  N   PRO A 193     -42.741  22.404  19.604  1.00 27.17           N  
ATOM   1506  CA  PRO A 193     -41.878  23.591  19.537  1.00 28.14           C  
ATOM   1507  C   PRO A 193     -41.206  23.733  18.166  1.00 28.77           C  
ATOM   1508  O   PRO A 193     -40.944  24.844  17.692  1.00 29.87           O  
ATOM   1509  CB  PRO A 193     -40.873  23.346  20.667  1.00 27.42           C  
ATOM   1510  CG  PRO A 193     -40.747  21.838  20.676  1.00 29.74           C  
ATOM   1511  CD  PRO A 193     -42.202  21.411  20.554  1.00 28.19           C  
ATOM   1512  N   GLN A 194     -40.929  22.591  17.545  1.00 28.74           N  
ATOM   1513  CA  GLN A 194     -40.308  22.536  16.234  1.00 28.60           C  
ATOM   1514  C   GLN A 194     -40.381  21.093  15.778  1.00 27.91           C  
ATOM   1515  O   GLN A 194     -40.785  20.214  16.536  1.00 27.36           O  
ATOM   1516  CB  GLN A 194     -38.853  22.980  16.320  1.00 30.31           C  
ATOM   1517  CG  GLN A 194     -37.977  22.028  17.107  1.00 37.38           C  
ATOM   1518  CD  GLN A 194     -36.719  22.700  17.646  1.00 43.15           C  
ATOM   1519  OE1 GLN A 194     -36.794  23.614  18.478  1.00 46.91           O  
ATOM   1520  NE2 GLN A 194     -35.555  22.253  17.175  1.00 44.91           N  
ATOM   1521  N   PHE A 195     -40.002  20.849  14.533  1.00 28.53           N  
ATOM   1522  CA  PHE A 195     -40.007  19.494  13.993  1.00 28.89           C  
ATOM   1523  C   PHE A 195     -38.703  18.762  14.358  1.00 29.28           C  
ATOM   1524  O   PHE A 195     -37.682  19.385  14.636  1.00 29.55           O  
ATOM   1525  CB  PHE A 195     -40.127  19.531  12.462  1.00 27.20           C  
ATOM   1526  CG  PHE A 195     -41.409  20.134  11.956  1.00 26.69           C  
ATOM   1527  CD1 PHE A 195     -42.642  19.614  12.340  1.00 24.06           C  
ATOM   1528  CD2 PHE A 195     -41.381  21.209  11.062  1.00 26.62           C  
ATOM   1529  CE1 PHE A 195     -43.829  20.154  11.841  1.00 24.40           C  
ATOM   1530  CE2 PHE A 195     -42.563  21.752  10.560  1.00 24.40           C  
ATOM   1531  CZ  PHE A 195     -43.785  21.224  10.950  1.00 23.45           C  
ATOM   1532  N   ASP A 196     -38.758  17.436  14.367  1.00 29.98           N  
ATOM   1533  CA  ASP A 196     -37.593  16.601  14.625  1.00 30.13           C  
ATOM   1534  C   ASP A 196     -37.870  15.254  13.959  1.00 31.21           C  
ATOM   1535  O   ASP A 196     -38.944  15.052  13.395  1.00 32.02           O  
ATOM   1536  CB  ASP A 196     -37.320  16.437  16.127  1.00 29.94           C  
ATOM   1537  CG  ASP A 196     -38.467  15.803  16.876  1.00 31.98           C  
ATOM   1538  OD1 ASP A 196     -39.038  14.820  16.372  1.00 34.42           O  
ATOM   1539  OD2 ASP A 196     -38.787  16.278  17.986  1.00 34.05           O  
ATOM   1540  N   GLU A 197     -36.910  14.341  14.011  1.00 32.16           N  
ATOM   1541  CA  GLU A 197     -37.067  13.043  13.367  1.00 32.99           C  
ATOM   1542  C   GLU A 197     -38.335  12.310  13.788  1.00 32.12           C  
ATOM   1543  O   GLU A 197     -39.050  11.767  12.944  1.00 31.17           O  
ATOM   1544  CB  GLU A 197     -35.837  12.180  13.646  1.00 35.75           C  
ATOM   1545  CG  GLU A 197     -35.783  10.869  12.875  1.00 40.62           C  
ATOM   1546  CD  GLU A 197     -34.648  10.822  11.852  1.00 43.60           C  
ATOM   1547  OE1 GLU A 197     -34.765  11.501  10.811  1.00 46.71           O  
ATOM   1548  OE2 GLU A 197     -33.637  10.115  12.085  1.00 43.86           O  
ATOM   1549  N   GLU A 198     -38.621  12.301  15.087  1.00 31.82           N  
ATOM   1550  CA  GLU A 198     -39.806  11.607  15.590  1.00 33.70           C  
ATOM   1551  C   GLU A 198     -41.113  12.181  15.064  1.00 32.50           C  
ATOM   1552  O   GLU A 198     -42.060  11.444  14.794  1.00 33.20           O  
ATOM   1553  CB  GLU A 198     -39.843  11.641  17.105  1.00 36.64           C  
ATOM   1554  CG  GLU A 198     -38.572  11.197  17.758  1.00 45.01           C  
ATOM   1555  CD  GLU A 198     -38.742  11.077  19.252  1.00 50.77           C  
ATOM   1556  OE1 GLU A 198     -39.314  12.016  19.860  1.00 53.78           O  
ATOM   1557  OE2 GLU A 198     -38.304  10.044  19.814  1.00 54.45           O  
ATOM   1558  N   LYS A 199     -41.173  13.501  14.942  1.00 30.48           N  
ATOM   1559  CA  LYS A 199     -42.367  14.154  14.434  1.00 28.22           C  
ATOM   1560  C   LYS A 199     -42.491  13.899  12.936  1.00 26.71           C  
ATOM   1561  O   LYS A 199     -43.595  13.794  12.405  1.00 27.24           O  
ATOM   1562  CB  LYS A 199     -42.304  15.647  14.749  1.00 27.72           C  
ATOM   1563  CG  LYS A 199     -42.450  15.903  16.228  1.00 26.37           C  
ATOM   1564  CD  LYS A 199     -42.014  17.288  16.604  1.00 28.37           C  
ATOM   1565  CE  LYS A 199     -42.142  17.484  18.101  1.00 28.53           C  
ATOM   1566  NZ  LYS A 199     -41.367  16.451  18.831  1.00 29.94           N  
ATOM   1567  N   ALA A 200     -41.349  13.780  12.262  1.00 25.16           N  
ATOM   1568  CA  ALA A 200     -41.327  13.495  10.831  1.00 23.82           C  
ATOM   1569  C   ALA A 200     -41.918  12.100  10.604  1.00 23.49           C  
ATOM   1570  O   ALA A 200     -42.574  11.844   9.593  1.00 22.36           O  
ATOM   1571  CB  ALA A 200     -39.890  13.562  10.303  1.00 23.52           C  
ATOM   1572  N   GLU A 201     -41.679  11.200  11.557  1.00 24.61           N  
ATOM   1573  CA  GLU A 201     -42.201   9.833  11.480  1.00 24.30           C  
ATOM   1574  C   GLU A 201     -43.726   9.878  11.493  1.00 23.76           C  
ATOM   1575  O   GLU A 201     -44.389   9.168  10.733  1.00 24.30           O  
ATOM   1576  CB  GLU A 201     -41.710   9.007  12.673  1.00 24.69           C  
ATOM   1577  CG  GLU A 201     -40.194   8.927  12.797  1.00 27.58           C  
ATOM   1578  CD  GLU A 201     -39.743   8.177  14.049  1.00 29.75           C  
ATOM   1579  OE1 GLU A 201     -38.519   8.009  14.238  1.00 30.65           O  
ATOM   1580  OE2 GLU A 201     -40.608   7.756  14.845  1.00 30.40           O  
ATOM   1581  N   LEU A 202     -44.275  10.726  12.361  1.00 23.31           N  
ATOM   1582  CA  LEU A 202     -45.720  10.874  12.491  1.00 21.32           C  
ATOM   1583  C   LEU A 202     -46.331  11.512  11.258  1.00 20.42           C  
ATOM   1584  O   LEU A 202     -47.385  11.093  10.787  1.00 20.27           O  
ATOM   1585  CB  LEU A 202     -46.043  11.695  13.733  1.00 21.65           C  
ATOM   1586  CG  LEU A 202     -45.573  10.981  15.001  1.00 22.59           C  
ATOM   1587  CD1 LEU A 202     -45.768  11.885  16.208  1.00 25.31           C  
ATOM   1588  CD2 LEU A 202     -46.338   9.664  15.160  1.00 20.97           C  
ATOM   1589  N   ILE A 203     -45.664  12.524  10.726  1.00 20.45           N  
ATOM   1590  CA  ILE A 203     -46.159  13.181   9.532  1.00 20.48           C  
ATOM   1591  C   ILE A 203     -46.201  12.187   8.366  1.00 21.46           C  
ATOM   1592  O   ILE A 203     -47.164  12.158   7.603  1.00 22.26           O  
ATOM   1593  CB  ILE A 203     -45.267  14.385   9.170  1.00 20.10           C  
ATOM   1594  CG1 ILE A 203     -45.360  15.433  10.289  1.00 18.57           C  
ATOM   1595  CG2 ILE A 203     -45.672  14.946   7.798  1.00 18.32           C  
ATOM   1596  CD1 ILE A 203     -44.458  16.620  10.108  1.00 17.26           C  
ATOM   1597  N   TYR A 204     -45.159  11.367   8.241  1.00 21.98           N  
ATOM   1598  CA  TYR A 204     -45.082  10.378   7.166  1.00 22.12           C  
ATOM   1599  C   TYR A 204     -46.175   9.333   7.320  1.00 22.33           C  
ATOM   1600  O   TYR A 204     -46.801   8.912   6.350  1.00 21.47           O  
ATOM   1601  CB  TYR A 204     -43.722   9.691   7.175  1.00 22.57           C  
ATOM   1602  CG  TYR A 204     -43.537   8.678   6.063  1.00 24.04           C  
ATOM   1603  CD1 TYR A 204     -43.541   9.073   4.722  1.00 23.34           C  
ATOM   1604  CD2 TYR A 204     -43.336   7.325   6.352  1.00 24.29           C  
ATOM   1605  CE1 TYR A 204     -43.342   8.146   3.694  1.00 25.51           C  
ATOM   1606  CE2 TYR A 204     -43.137   6.390   5.334  1.00 26.46           C  
ATOM   1607  CZ  TYR A 204     -43.138   6.806   4.010  1.00 26.66           C  
ATOM   1608  OH  TYR A 204     -42.902   5.888   3.010  1.00 27.46           O  
ATOM   1609  N   GLN A 205     -46.395   8.910   8.553  1.00 23.24           N  
ATOM   1610  CA  GLN A 205     -47.424   7.932   8.837  1.00 23.70           C  
ATOM   1611  C   GLN A 205     -48.785   8.485   8.401  1.00 23.83           C  
ATOM   1612  O   GLN A 205     -49.594   7.768   7.796  1.00 23.78           O  
ATOM   1613  CB  GLN A 205     -47.413   7.621  10.331  1.00 25.80           C  
ATOM   1614  CG  GLN A 205     -48.534   6.733  10.804  1.00 28.50           C  
ATOM   1615  CD  GLN A 205     -48.334   6.288  12.240  1.00 31.78           C  
ATOM   1616  OE1 GLN A 205     -47.725   5.246  12.503  1.00 31.67           O  
ATOM   1617  NE2 GLN A 205     -48.828   7.089  13.181  1.00 32.75           N  
ATOM   1618  N   THR A 206     -49.026   9.763   8.697  1.00 22.40           N  
ATOM   1619  CA  THR A 206     -50.282  10.420   8.335  1.00 23.35           C  
ATOM   1620  C   THR A 206     -50.452  10.466   6.822  1.00 23.09           C  
ATOM   1621  O   THR A 206     -51.476  10.056   6.282  1.00 22.06           O  
ATOM   1622  CB  THR A 206     -50.325  11.868   8.873  1.00 24.22           C  
ATOM   1623  OG1 THR A 206     -50.143  11.856  10.293  1.00 23.01           O  
ATOM   1624  CG2 THR A 206     -51.658  12.523   8.548  1.00 21.59           C  
ATOM   1625  N   VAL A 207     -49.426  10.969   6.148  1.00 24.45           N  
ATOM   1626  CA  VAL A 207     -49.430  11.087   4.696  1.00 26.08           C  
ATOM   1627  C   VAL A 207     -49.495   9.729   3.986  1.00 26.57           C  
ATOM   1628  O   VAL A 207     -50.215   9.564   3.002  1.00 27.26           O  
ATOM   1629  CB  VAL A 207     -48.187  11.870   4.221  1.00 25.66           C  
ATOM   1630  CG1 VAL A 207     -48.067  11.796   2.719  1.00 26.46           C  
ATOM   1631  CG2 VAL A 207     -48.300  13.326   4.658  1.00 24.95           C  
ATOM   1632  N   THR A 208     -48.732   8.764   4.481  1.00 27.76           N  
ATOM   1633  CA  THR A 208     -48.736   7.426   3.907  1.00 28.89           C  
ATOM   1634  C   THR A 208     -50.142   6.861   3.972  1.00 29.73           C  
ATOM   1635  O   THR A 208     -50.606   6.197   3.050  1.00 31.63           O  
ATOM   1636  CB  THR A 208     -47.815   6.487   4.687  1.00 29.45           C  
ATOM   1637  OG1 THR A 208     -46.452   6.810   4.390  1.00 31.66           O  
ATOM   1638  CG2 THR A 208     -48.089   5.041   4.318  1.00 30.26           C  
ATOM   1639  N   CYS A 209     -50.813   7.130   5.081  1.00 29.41           N  
ATOM   1640  CA  CYS A 209     -52.162   6.650   5.290  1.00 28.56           C  
ATOM   1641  C   CYS A 209     -53.117   7.223   4.259  1.00 28.54           C  
ATOM   1642  O   CYS A 209     -53.864   6.485   3.620  1.00 29.41           O  
ATOM   1643  CB  CYS A 209     -52.619   7.023   6.700  1.00 29.05           C  
ATOM   1644  SG  CYS A 209     -54.365   6.749   7.003  1.00 32.80           S  
ATOM   1645  N   HIS A 210     -53.090   8.541   4.097  1.00 28.57           N  
ATOM   1646  CA  HIS A 210     -53.962   9.216   3.145  1.00 27.83           C  
ATOM   1647  C   HIS A 210     -53.680   8.834   1.697  1.00 28.14           C  
ATOM   1648  O   HIS A 210     -54.607   8.646   0.913  1.00 27.40           O  
ATOM   1649  CB  HIS A 210     -53.823  10.730   3.278  1.00 26.32           C  
ATOM   1650  CG  HIS A 210     -54.344  11.272   4.567  1.00 26.27           C  
ATOM   1651  ND1 HIS A 210     -54.366  12.620   4.849  1.00 25.31           N  
ATOM   1652  CD2 HIS A 210     -54.864  10.650   5.651  1.00 25.91           C  
ATOM   1653  CE1 HIS A 210     -54.877  12.807   6.051  1.00 25.98           C  
ATOM   1654  NE2 HIS A 210     -55.187  11.628   6.559  1.00 26.43           N  
ATOM   1655  N   ILE A 211     -52.403   8.750   1.337  1.00 28.40           N  
ATOM   1656  CA  ILE A 211     -52.028   8.399  -0.027  1.00 29.54           C  
ATOM   1657  C   ILE A 211     -52.541   7.005  -0.388  1.00 29.85           C  
ATOM   1658  O   ILE A 211     -53.048   6.802  -1.484  1.00 30.02           O  
ATOM   1659  CB  ILE A 211     -50.484   8.490  -0.227  1.00 30.47           C  
ATOM   1660  CG1 ILE A 211     -50.057   9.963  -0.231  1.00 31.15           C  
ATOM   1661  CG2 ILE A 211     -50.078   7.836  -1.537  1.00 29.80           C  
ATOM   1662  CD1 ILE A 211     -48.573  10.185  -0.335  1.00 31.56           C  
ATOM   1663  N   ASP A 212     -52.423   6.053   0.535  1.00 30.17           N  
ATOM   1664  CA  ASP A 212     -52.906   4.701   0.293  1.00 29.86           C  
ATOM   1665  C   ASP A 212     -54.406   4.708   0.078  1.00 29.68           C  
ATOM   1666  O   ASP A 212     -54.898   4.108  -0.867  1.00 29.62           O  
ATOM   1667  CB  ASP A 212     -52.562   3.795   1.466  1.00 32.34           C  
ATOM   1668  CG  ASP A 212     -51.123   3.351   1.441  1.00 34.65           C  
ATOM   1669  OD1 ASP A 212     -50.673   2.715   2.414  1.00 37.56           O  
ATOM   1670  OD2 ASP A 212     -50.439   3.634   0.437  1.00 37.28           O  
ATOM   1671  N   LEU A 213     -55.132   5.391   0.955  1.00 29.35           N  
ATOM   1672  CA  LEU A 213     -56.576   5.467   0.830  1.00 28.46           C  
ATOM   1673  C   LEU A 213     -56.954   6.015  -0.531  1.00 30.49           C  
ATOM   1674  O   LEU A 213     -57.858   5.500  -1.184  1.00 33.13           O  
ATOM   1675  CB  LEU A 213     -57.167   6.357   1.922  1.00 26.16           C  
ATOM   1676  CG  LEU A 213     -57.221   5.730   3.312  1.00 26.04           C  
ATOM   1677  CD1 LEU A 213     -57.780   6.727   4.317  1.00 26.49           C  
ATOM   1678  CD2 LEU A 213     -58.096   4.491   3.262  1.00 25.11           C  
ATOM   1679  N   ILE A 214     -56.251   7.053  -0.964  1.00 30.47           N  
ATOM   1680  CA  ILE A 214     -56.520   7.687  -2.249  1.00 31.08           C  
ATOM   1681  C   ILE A 214     -56.143   6.822  -3.451  1.00 30.80           C  
ATOM   1682  O   ILE A 214     -56.916   6.703  -4.398  1.00 30.34           O  
ATOM   1683  CB  ILE A 214     -55.796   9.043  -2.321  1.00 30.80           C  
ATOM   1684  CG1 ILE A 214     -56.446  10.000  -1.318  1.00 31.47           C  
ATOM   1685  CG2 ILE A 214     -55.831   9.593  -3.732  1.00 30.55           C  
ATOM   1686  CD1 ILE A 214     -55.596  11.198  -0.958  1.00 33.56           C  
ATOM   1687  N   LEU A 215     -54.959   6.221  -3.417  1.00 32.29           N  
ATOM   1688  CA  LEU A 215     -54.514   5.362  -4.508  1.00 33.65           C  
ATOM   1689  C   LEU A 215     -55.474   4.196  -4.712  1.00 35.47           C  
ATOM   1690  O   LEU A 215     -55.784   3.833  -5.845  1.00 36.34           O  
ATOM   1691  CB  LEU A 215     -53.105   4.826  -4.235  1.00 30.49           C  
ATOM   1692  CG  LEU A 215     -51.975   5.839  -4.429  1.00 28.77           C  
ATOM   1693  CD1 LEU A 215     -50.626   5.151  -4.261  1.00 25.82           C  
ATOM   1694  CD2 LEU A 215     -52.091   6.464  -5.818  1.00 27.36           C  
ATOM   1695  N   HIS A 216     -55.949   3.610  -3.618  1.00 36.76           N  
ATOM   1696  CA  HIS A 216     -56.877   2.496  -3.713  1.00 39.61           C  
ATOM   1697  C   HIS A 216     -58.246   2.946  -4.196  1.00 40.02           C  
ATOM   1698  O   HIS A 216     -58.923   2.222  -4.928  1.00 41.06           O  
ATOM   1699  CB  HIS A 216     -57.002   1.790  -2.363  1.00 41.83           C  
ATOM   1700  CG  HIS A 216     -55.732   1.139  -1.919  1.00 45.63           C  
ATOM   1701  ND1 HIS A 216     -54.901   0.465  -2.791  1.00 48.65           N  
ATOM   1702  CD2 HIS A 216     -55.142   1.060  -0.702  1.00 47.94           C  
ATOM   1703  CE1 HIS A 216     -53.853   0.004  -2.131  1.00 49.04           C  
ATOM   1704  NE2 HIS A 216     -53.974   0.350  -0.862  1.00 49.38           N  
ATOM   1705  N   GLY A 217     -58.649   4.146  -3.795  1.00 39.30           N  
ATOM   1706  CA  GLY A 217     -59.939   4.660  -4.214  1.00 38.88           C  
ATOM   1707  C   GLY A 217     -59.966   5.070  -5.675  1.00 38.64           C  
ATOM   1708  O   GLY A 217     -61.005   4.989  -6.327  1.00 37.51           O  
ATOM   1709  N   LEU A 218     -58.821   5.507  -6.193  1.00 38.13           N  
ATOM   1710  CA  LEU A 218     -58.719   5.935  -7.583  1.00 38.83           C  
ATOM   1711  C   LEU A 218     -58.533   4.773  -8.555  1.00 40.56           C  
ATOM   1712  O   LEU A 218     -58.780   4.905  -9.756  1.00 39.86           O  
ATOM   1713  CB  LEU A 218     -57.558   6.915  -7.751  1.00 36.53           C  
ATOM   1714  CG  LEU A 218     -57.703   8.262  -7.051  1.00 35.55           C  
ATOM   1715  CD1 LEU A 218     -56.445   9.089  -7.290  1.00 34.23           C  
ATOM   1716  CD2 LEU A 218     -58.938   8.974  -7.566  1.00 32.26           C  
ATOM   1717  N   THR A 219     -58.086   3.635  -8.040  1.00 43.05           N  
ATOM   1718  CA  THR A 219     -57.883   2.462  -8.882  1.00 46.18           C  
ATOM   1719  C   THR A 219     -59.237   1.898  -9.324  1.00 48.47           C  
ATOM   1720  O   THR A 219     -59.360   1.336 -10.415  1.00 49.77           O  
ATOM   1721  CB  THR A 219     -57.101   1.360  -8.123  1.00 44.78           C  
ATOM   1722  OG1 THR A 219     -55.823   1.868  -7.714  1.00 43.41           O  
ATOM   1723  CG2 THR A 219     -56.889   0.147  -9.009  1.00 43.99           C  
ATOM   1724  N   GLN A 220     -60.251   2.085  -8.477  1.00 51.31           N  
ATOM   1725  CA  GLN A 220     -61.605   1.575  -8.736  1.00 55.32           C  
ATOM   1726  C   GLN A 220     -62.750   2.617  -8.833  1.00 55.97           C  
ATOM   1727  O   GLN A 220     -62.500   3.819  -8.537  1.00 56.43           O  
ATOM   1728  CB  GLN A 220     -61.932   0.531  -7.658  1.00 57.72           C  
ATOM   1729  CG  GLN A 220     -63.370   0.536  -7.128  1.00 61.17           C  
ATOM   1730  CD  GLN A 220     -63.386   0.645  -5.603  1.00 63.14           C  
ATOM   1731  OE1 GLN A 220     -62.418   0.213  -4.927  1.00 63.37           O  
ATOM   1732  NE2 GLN A 220     -64.480   1.207  -5.042  1.00 63.78           N  
TER    1733      GLN A 220                                                      
END
MOLECULE T0454.pdb
ATOM      1  N   ASP     5     -12.420  32.658   0.024  1.00 27.13           N
ATOM      2  CA  ASP     5     -13.312  32.598   1.217  1.00 27.34           C
ATOM      3  CB  ASP     5     -12.512  32.690   2.520  1.00 28.50           C
ATOM      4  CG  ASP     5     -13.404  32.599   3.759  1.00 30.42           C
ATOM      5  OD1 ASP     5     -14.289  31.706   3.803  1.00 33.47           O
ATOM      6  OD2 ASP     5     -13.226  33.430   4.680  1.00 32.05           O
ATOM      7  C   ASP     5     -14.424  33.644   1.238  1.00 26.73           C
ATOM      8  O   ASP     5     -15.477  33.398   1.835  1.00 26.63           O
ATOM      9  N   CYS     6     -14.211  34.799   0.611  0.50 26.41           N
ATOM     11  CA  CYS     6     -15.286  35.794   0.531  0.50 26.28           C
ATOM     13  CB  CYS     6     -14.751  37.198   0.241  0.50 26.57           C
ATOM     15  SG  CYS     6     -14.050  37.968   1.731  0.50 29.41           S
ATOM     17  C   CYS     6     -16.388  35.363  -0.439  0.50 25.38           C
ATOM     19  O   CYS     6     -17.496  35.901  -0.414  0.50 25.34           O
ATOM     21  N   ARG     7     -16.080  34.368  -1.271  1.00 24.45           N
ATOM     22  CA  ARG     7     -17.093  33.680  -2.080  1.00 22.28           C
ATOM     23  CB  ARG     7     -16.421  32.728  -3.079  1.00 22.90           C
ATOM     30  C   ARG     7     -18.066  32.903  -1.186  1.00 20.46           C
ATOM     31  O   ARG     7     -19.262  32.867  -1.449  1.00 20.43           O
ATOM     32  N   SER     8     -17.547  32.253  -0.148  0.50 19.10           N
ATOM     34  CA  SER     8     -18.391  31.436   0.731  0.50 17.33           C
ATOM     36  CB  SER     8     -17.550  30.493   1.586  0.50 17.45           C
ATOM     38  OG  SER     8     -18.312  29.968   2.658  0.50 15.65           O
ATOM     40  C   SER     8     -19.258  32.322   1.613  0.50 16.60           C
ATOM     42  O   SER     8     -20.455  32.084   1.776  0.50 15.91           O
ATOM     44  N   ARG     9     -18.645  33.365   2.159  0.50 15.61           N
ATOM     46  CA  ARG     9     -19.363  34.297   3.022  0.50 14.83           C
ATOM     48  CB  ARG     9     -18.372  35.205   3.766  0.50 15.25           C
ATOM     50  CG  ARG     9     -17.394  34.394   4.628  0.50 14.59           C
ATOM     52  CD  ARG     9     -16.768  35.163   5.795  0.50 16.76           C
ATOM     54  NE  ARG     9     -15.709  36.081   5.358  0.50 18.23           N
ATOM     56  CZ  ARG     9     -15.907  37.364   5.046  0.50 17.11           C
ATOM     58  NH1 ARG     9     -14.883  38.115   4.657  0.50 16.37           N
ATOM     60  NH2 ARG     9     -17.129  37.896   5.121  0.50 17.10           N
ATOM     62  C   ARG     9     -20.452  35.089   2.282  0.50 14.49           C
ATOM     64  O   ARG     9     -21.506  35.370   2.850  0.50 13.18           O
ATOM     66  N   LEU    10     -20.187  35.432   1.021  1.00 14.14           N
ATOM     67  CA  LEU    10     -21.183  36.018   0.143  1.00 15.70           C
ATOM     68  CB  LEU    10     -20.580  36.459  -1.201  1.00 16.55           C
ATOM     69  CG  LEU    10     -20.226  37.923  -1.321  1.00 18.07           C
ATOM     70  CD1 LEU    10     -19.435  38.165  -2.626  1.00 18.10           C
ATOM     71  CD2 LEU    10     -21.495  38.769  -1.285  1.00 16.77           C
ATOM     72  C   LEU    10     -22.364  35.072  -0.083  1.00 15.96           C
ATOM     73  O   LEU    10     -23.511  35.520  -0.035  1.00 16.63           O
ATOM     74  N   MET    11     -22.097  33.792  -0.326  0.70 16.06           N
ATOM     76  CA  MET    11     -23.179  32.843  -0.534  0.70 17.38           C
ATOM     78  CB  MET    11     -22.637  31.461  -0.863  0.70 20.17           C
ATOM     80  CG  MET    11     -22.166  31.316  -2.273  0.70 25.34           C
ATOM     82  SD  MET    11     -23.611  30.818  -3.503  0.70 46.93          SE
ATOM     84  CE  MET    11     -22.374  30.088  -4.856  0.70 32.85           C
ATOM     86  C   MET    11     -24.065  32.759   0.707  0.70 15.90           C
ATOM     88  O   MET    11     -25.298  32.724   0.592  0.70 14.79           O
ATOM     90  N   GLU    12     -23.436  32.726   1.888  1.00 13.16           N
ATOM     91  CA  GLU    12     -24.186  32.691   3.141  1.00 12.28           C
ATOM     92  CB  GLU    12     -23.255  32.550   4.367  1.00 11.62           C
ATOM     93  CG  GLU    12     -24.006  32.676   5.679  1.00 12.98           C
ATOM     94  CD  GLU    12     -24.899  31.451   5.972  1.00 17.78           C
ATOM     95  OE1 GLU    12     -24.548  30.339   5.520  1.00 20.61           O
ATOM     96  OE2 GLU    12     -25.952  31.593   6.636  1.00 18.33           O
ATOM     97  C   GLU    12     -25.062  33.946   3.278  1.00 11.77           C
ATOM     98  O   GLU    12     -26.263  33.868   3.569  1.00 10.95           O
ATOM     99  N   VAL    13     -24.441  35.104   3.102  1.00 11.38           N
ATOM    100  CA  VAL    13     -25.143  36.347   3.297  1.00 11.79           C
ATOM    101  CB  VAL    13     -24.168  37.555   3.216  1.00 11.85           C
ATOM    102  CG1 VAL    13     -24.903  38.816   2.771  1.00 13.25           C
ATOM    103  CG2 VAL    13     -23.437  37.739   4.528  1.00 12.09           C
ATOM    104  C   VAL    13     -26.264  36.469   2.270  1.00 12.08           C
ATOM    105  O   VAL    13     -27.360  36.860   2.613  1.00 12.20           O
ATOM    106  N   ALA    14     -25.987  36.132   1.016  1.00 11.94           N
ATOM    107  CA  ALA    14     -27.028  36.192  -0.026  1.00 12.57           C
ATOM    108  CB  ALA    14     -26.434  35.847  -1.397  1.00 12.81           C
ATOM    109  C   ALA    14     -28.224  35.272   0.324  1.00 12.70           C
ATOM    110  O   ALA    14     -29.404  35.681   0.225  1.00 12.49           O
ATOM    111  N   THR    15     -27.933  34.045   0.752  1.00 12.08           N
ATOM    112  CA  THR    15     -29.000  33.092   1.088  1.00 13.57           C
ATOM    113  CB  THR    15     -28.420  31.727   1.526  1.00 13.02           C
ATOM    114  OG1 THR    15     -27.592  31.204   0.477  1.00 13.54           O
ATOM    115  CG2 THR    15     -29.544  30.705   1.864  1.00 14.11           C
ATOM    116  C   THR    15     -29.885  33.685   2.197  1.00 13.81           C
ATOM    117  O   THR    15     -31.100  33.676   2.080  1.00 14.69           O
ATOM    118  N   GLU    16     -29.283  34.229   3.251  0.50 12.86           N
ATOM    120  CA  GLU    16     -30.060  34.743   4.392  0.50 12.65           C
ATOM    122  CB  GLU    16     -29.168  34.850   5.619  0.50 11.98           C
ATOM    124  CG  GLU    16     -28.366  33.560   5.847  0.50 10.56           C
ATOM    126  CD  GLU    16     -29.193  32.437   6.436  0.50 10.50           C
ATOM    128  OE1 GLU    16     -29.690  32.653   7.554  0.50 13.56           O
ATOM    130  OE2 GLU    16     -29.343  31.334   5.814  0.50  9.37           O
ATOM    132  C   GLU    16     -30.844  36.053   4.135  0.50 13.06           C
ATOM    134  O   GLU    16     -31.941  36.247   4.680  0.50 12.44           O
ATOM    136  N   LEU    17     -30.289  36.937   3.304  1.00 13.39           N
ATOM    137  CA  LEU    17     -30.999  38.157   2.904  1.00 13.60           C
ATOM    138  CB  LEU    17     -30.022  39.257   2.439  1.00 13.92           C
ATOM    139  CG  LEU    17     -29.168  39.859   3.564  1.00 15.45           C
ATOM    140  CD1 LEU    17     -28.242  40.964   3.019  1.00 18.76           C
ATOM    141  CD2 LEU    17     -30.008  40.355   4.753  1.00 18.21           C
ATOM    142  C   LEU    17     -32.079  37.907   1.841  1.00 13.42           C
ATOM    143  O   LEU    17     -33.201  38.400   2.004  1.00 13.35           O
ATOM    144  N   PHE    18     -31.772  37.132   0.800  1.00 12.52           N
ATOM    145  CA  PHE    18     -32.789  36.767  -0.188  1.00 12.55           C
ATOM    146  CB  PHE    18     -32.168  36.032  -1.355  1.00 12.74           C
ATOM    147  CG  PHE    18     -31.341  36.895  -2.267  1.00 11.67           C
ATOM    148  CD1 PHE    18     -31.865  38.079  -2.813  1.00 12.22           C
ATOM    149  CE1 PHE    18     -31.138  38.864  -3.706  1.00 12.93           C
ATOM    150  CZ  PHE    18     -29.843  38.455  -4.104  1.00 13.62           C
ATOM    151  CE2 PHE    18     -29.308  37.240  -3.582  1.00 11.19           C
ATOM    152  CD2 PHE    18     -30.083  36.472  -2.677  1.00 11.90           C
ATOM    153  C   PHE    18     -33.889  35.866   0.419  1.00 13.51           C
ATOM    154  O   PHE    18     -35.054  35.962   0.015  1.00 15.25           O
ATOM    155  N   ALA    19     -33.532  34.996   1.373  1.00 13.39           N
ATOM    156  CA  ALA    19     -34.553  34.208   2.061  1.00 15.05           C
ATOM    157  CB  ALA    19     -33.942  33.133   2.992  1.00 14.27           C
ATOM    158  C   ALA    19     -35.536  35.094   2.817  1.00 15.36           C
ATOM    159  O   ALA    19     -36.754  34.842   2.737  1.00 16.78           O
ATOM    160  N   GLN    20     -35.009  36.097   3.541  0.70 16.27           N
ATOM    162  CA  GLN    20     -35.806  37.053   4.335  0.70 16.80           C
ATOM    164  CB  GLN    20     -34.946  37.989   5.239  0.70 17.01           C
ATOM    166  CG  GLN    20     -35.745  39.306   5.640  0.70 16.81           C
ATOM    168  CD  GLN    20     -35.206  40.143   6.812  0.70 17.74           C
ATOM    170  OE1 GLN    20     -35.154  41.393   6.736  0.70 13.85           O
ATOM    172  NE2 GLN    20     -34.830  39.472   7.903  0.70 18.70           N
ATOM    174  C   GLN    20     -36.691  37.941   3.482  0.70 17.07           C
ATOM    176  O   GLN    20     -37.900  38.009   3.701  0.70 17.23           O
ATOM    178  N   LYS    21     -36.060  38.636   2.537  1.00 15.44           N
ATOM    179  CA  LYS    21     -36.656  39.778   1.820  1.00 16.20           C
ATOM    180  CB  LYS    21     -35.693  40.954   1.797  1.00 16.65           C
ATOM    181  CG  LYS    21     -35.259  41.391   3.184  1.00 19.64           C
ATOM    182  CD  LYS    21     -34.363  42.583   3.043  1.00 22.59           C
ATOM    183  CE  LYS    21     -33.720  42.901   4.359  1.00 25.71           C
ATOM    184  NZ  LYS    21     -33.292  44.316   4.378  1.00 29.79           N
ATOM    185  C   LYS    21     -37.021  39.482   0.389  1.00 15.03           C
ATOM    186  O   LYS    21     -37.639  40.317  -0.275  1.00 16.30           O
ATOM    187  N   GLY    22     -36.632  38.313  -0.101  1.00 14.81           N
ATOM    188  CA  GLY    22     -36.879  37.954  -1.501  1.00 12.41           C
ATOM    189  C   GLY    22     -35.967  38.743  -2.431  1.00 13.23           C
ATOM    190  O   GLY    22     -35.355  39.762  -2.034  1.00 13.65           O
ATOM    191  N   PHE    23     -35.857  38.255  -3.660  1.00 12.90           N
ATOM    192  CA  PHE    23     -35.064  38.952  -4.675  1.00 13.24           C
ATOM    193  CB  PHE    23     -35.255  38.297  -6.043  1.00 15.31           C
ATOM    194  CG  PHE    23     -34.544  39.016  -7.130  1.00 16.26           C
ATOM    195  CD1 PHE    23     -33.214  38.729  -7.414  1.00 17.28           C
ATOM    196  CE1 PHE    23     -32.528  39.446  -8.406  1.00 17.88           C
ATOM    197  CZ  PHE    23     -33.173  40.390  -9.137  1.00 18.69           C
ATOM    198  CE2 PHE    23     -34.531  40.677  -8.884  1.00 18.23           C
ATOM    199  CD2 PHE    23     -35.193  40.000  -7.883  1.00 18.32           C
ATOM    200  C   PHE    23     -35.468  40.425  -4.758  1.00 14.16           C
ATOM    201  O   PHE    23     -34.604  41.312  -4.880  1.00 14.45           O
ATOM    202  N   TYR    24     -36.778  40.690  -4.743  1.00 14.52           N
ATOM    203  CA  TYR    24     -37.263  42.057  -4.998  1.00 15.59           C
ATOM    204  CB  TYR    24     -38.733  42.085  -5.422  1.00 13.51           C
ATOM    205  CG  TYR    24     -38.963  41.406  -6.781  1.00 13.47           C
ATOM    206  CD1 TYR    24     -38.665  42.064  -7.967  1.00 12.55           C
ATOM    207  CE1 TYR    24     -38.890  41.458  -9.241  1.00 13.28           C
ATOM    208  CZ  TYR    24     -39.399  40.139  -9.303  1.00 10.43           C
ATOM    209  OH  TYR    24     -39.630  39.577 -10.572  1.00 11.31           O
ATOM    210  CE2 TYR    24     -39.713  39.475  -8.126  1.00 11.68           C
ATOM    211  CD2 TYR    24     -39.493  40.106  -6.858  1.00 14.21           C
ATOM    212  C   TYR    24     -37.080  42.970  -3.806  1.00 16.80           C
ATOM    213  O   TYR    24     -37.286  44.167  -3.939  1.00 18.89           O
ATOM    214  N   GLY    25     -36.702  42.429  -2.656  1.00 16.86           N
ATOM    215  CA  GLY    25     -36.488  43.287  -1.478  1.00 17.30           C
ATOM    216  C   GLY    25     -35.036  43.519  -1.070  1.00 18.19           C
ATOM    217  O   GLY    25     -34.787  44.141  -0.042  1.00 18.97           O
ATOM    218  N   VAL    26     -34.080  42.983  -1.822  1.00 17.80           N
ATOM    219  CA  VAL    26     -32.653  43.017  -1.434  1.00 17.86           C
ATOM    220  CB  VAL    26     -32.053  41.567  -1.526  1.00 16.88           C
ATOM    221  CG1 VAL    26     -30.493  41.578  -1.523  1.00 19.19           C
ATOM    222  CG2 VAL    26     -32.546  40.691  -0.382  1.00 17.09           C
ATOM    223  C   VAL    26     -31.896  43.951  -2.405  1.00 18.57           C
ATOM    224  O   VAL    26     -32.112  43.860  -3.619  1.00 19.26           O
ATOM    225  N   SER    27     -31.024  44.837  -1.900  1.00 18.29           N
ATOM    226  CA  SER    27     -30.188  45.651  -2.802  1.00 18.73           C
ATOM    227  CB  SER    27     -30.240  47.135  -2.451  1.00 18.20           C
ATOM    228  OG  SER    27     -29.499  47.385  -1.297  1.00 19.53           O
ATOM    229  C   SER    27     -28.743  45.196  -2.781  1.00 18.39           C
ATOM    230  O   SER    27     -28.296  44.592  -1.823  1.00 18.07           O
ATOM    231  N   ILE    28     -28.001  45.507  -3.836  1.00 18.31           N
ATOM    232  CA  ILE    28     -26.587  45.151  -3.866  1.00 18.54           C
ATOM    233  CB  ILE    28     -25.953  45.425  -5.232  1.00 18.62           C
ATOM    234  CG1 ILE    28     -24.599  44.703  -5.348  1.00 18.14           C
ATOM    235  CD1 ILE    28     -23.953  44.785  -6.743  1.00 19.13           C
ATOM    236  CG2 ILE    28     -25.915  46.963  -5.537  1.00 18.10           C
ATOM    237  C   ILE    28     -25.825  45.846  -2.714  1.00 18.97           C
ATOM    238  O   ILE    28     -24.902  45.274  -2.156  1.00 17.66           O
ATOM    239  N   ARG    29     -26.211  47.076  -2.360  1.00 19.97           N
ATOM    240  CA  ARG    29     -25.589  47.737  -1.207  1.00 22.13           C
ATOM    241  CB  ARG    29     -26.120  49.174  -1.012  1.00 21.53           C
ATOM    242  CG  ARG    29     -25.467  49.925   0.170  1.00 25.16           C
ATOM    243  CD  ARG    29     -26.316  51.109   0.743  1.00 26.22           C
ATOM    244  NE  ARG    29     -27.682  50.707   1.142  1.00 35.15           N
ATOM    245  CZ  ARG    29     -28.010  50.032   2.256  1.00 36.75           C
ATOM    246  NH1 ARG    29     -27.084  49.650   3.137  1.00 38.29           N
ATOM    247  NH2 ARG    29     -29.285  49.730   2.492  1.00 38.04           N
ATOM    248  C   ARG    29     -25.725  46.902   0.085  1.00 21.09           C
ATOM    249  O   ARG    29     -24.730  46.691   0.798  1.00 19.92           O
ATOM    250  N   GLU    30     -26.937  46.412   0.371  1.00 22.16           N
ATOM    251  CA  GLU    30     -27.160  45.541   1.551  1.00 22.56           C
ATOM    252  CB  GLU    30     -28.618  45.119   1.693  1.00 23.46           C
ATOM    253  CG  GLU    30     -29.623  46.242   1.841  1.00 28.08           C
ATOM    254  CD  GLU    30     -31.046  45.786   1.483  1.00 34.28           C
ATOM    255  OE1 GLU    30     -31.275  44.555   1.368  1.00 33.74           O
ATOM    256  OE2 GLU    30     -31.935  46.662   1.307  1.00 37.15           O
ATOM    257  C   GLU    30     -26.301  44.272   1.533  1.00 21.44           C
ATOM    258  O   GLU    30     -25.795  43.856   2.577  1.00 21.23           O
ATOM    259  N   LEU    31     -26.170  43.640   0.359  1.00 19.98           N
ATOM    260  CA  LEU    31     -25.338  42.431   0.251  1.00 18.96           C
ATOM    261  CB  LEU    31     -25.426  41.823  -1.145  1.00 18.00           C
ATOM    262  CG  LEU    31     -26.768  41.239  -1.562  1.00 18.12           C
ATOM    263  CD1 LEU    31     -26.678  40.931  -3.057  1.00 16.01           C
ATOM    264  CD2 LEU    31     -27.078  39.993  -0.744  1.00 18.33           C
ATOM    265  C   LEU    31     -23.871  42.715   0.588  1.00 18.24           C
ATOM    266  O   LEU    31     -23.227  41.984   1.363  1.00 18.55           O
ATOM    267  N   ALA    32     -23.328  43.776  -0.005  1.00 18.07           N
ATOM    268  CA  ALA    32     -21.928  44.131   0.234  1.00 17.87           C
ATOM    269  CB  ALA    32     -21.533  45.282  -0.659  1.00 17.05           C
ATOM    270  C   ALA    32     -21.689  44.449   1.719  1.00 18.48           C
ATOM    271  O   ALA    32     -20.741  43.938   2.338  1.00 18.50           O
ATOM    272  N   GLN    33     -22.577  45.264   2.282  1.00 18.14           N
ATOM    273  CA  GLN    33     -22.467  45.687   3.672  1.00 18.66           C
ATOM    274  CB  GLN    33     -23.613  46.652   4.012  1.00 18.81           C
ATOM    279  C   GLN    33     -22.496  44.452   4.579  1.00 18.25           C
ATOM    280  O   GLN    33     -21.649  44.307   5.470  1.00 19.06           O
ATOM    281  N   ALA    34     -23.456  43.552   4.355  1.00 18.35           N
ATOM    282  CA  ALA    34     -23.588  42.387   5.224  1.00 17.57           C
ATOM    283  CB  ALA    34     -24.915  41.670   4.988  1.00 18.88           C
ATOM    284  C   ALA    34     -22.400  41.424   5.094  1.00 17.93           C
ATOM    285  O   ALA    34     -22.007  40.800   6.073  1.00 18.07           O
ATOM    286  N   ALA    35     -21.812  41.324   3.902  1.00 17.59           N
ATOM    287  CA  ALA    35     -20.653  40.434   3.662  1.00 17.45           C
ATOM    288  CB  ALA    35     -20.742  39.832   2.241  1.00 17.60           C
ATOM    289  C   ALA    35     -19.271  41.084   3.858  1.00 17.39           C
ATOM    290  O   ALA    35     -18.253  40.386   3.869  1.00 17.10           O
ATOM    291  N   GLY    36     -19.216  42.410   3.975  1.00 17.53           N
ATOM    292  CA  GLY    36     -17.934  43.120   4.053  1.00 17.54           C
ATOM    293  C   GLY    36     -17.142  43.046   2.755  1.00 18.20           C
ATOM    294  O   GLY    36     -15.894  43.109   2.760  1.00 18.83           O
ATOM    295  N   ALA    37     -17.868  42.917   1.638  1.00 18.05           N
ATOM    296  CA  ALA    37     -17.298  42.947   0.287  1.00 17.70           C
ATOM    297  CB  ALA    37     -17.905  41.813  -0.553  1.00 17.69           C
ATOM    298  C   ALA    37     -17.594  44.299  -0.377  1.00 17.25           C
ATOM    299  O   ALA    37     -18.512  44.995   0.029  1.00 17.90           O
ATOM    300  N   SER    38     -16.844  44.680  -1.401  1.00 16.01           N
ATOM    301  CA  SER    38     -17.181  45.941  -2.083  1.00 15.66           C
ATOM    302  CB  SER    38     -15.986  46.530  -2.815  1.00 15.99           C
ATOM    303  OG  SER    38     -15.465  45.574  -3.709  1.00 15.63           O
ATOM    304  C   SER    38     -18.275  45.670  -3.090  1.00 15.23           C
ATOM    305  O   SER    38     -18.390  44.545  -3.568  1.00 14.69           O
ATOM    306  N   ILE    39     -19.054  46.696  -3.426  1.00 14.99           N
ATOM    307  CA  ILE    39     -20.019  46.586  -4.524  1.00 16.34           C
ATOM    308  CB  ILE    39     -20.795  47.908  -4.725  1.00 18.03           C
ATOM    309  CG1 ILE    39     -21.771  48.099  -3.551  1.00 18.95           C
ATOM    310  CD1 ILE    39     -22.260  49.551  -3.403  1.00 24.07           C
ATOM    311  CG2 ILE    39     -21.568  47.905  -6.053  1.00 19.22           C
ATOM    312  C   ILE    39     -19.321  46.142  -5.820  1.00 14.71           C
ATOM    313  O   ILE    39     -19.846  45.293  -6.544  1.00 14.07           O
ATOM    314  N   SER    40     -18.089  46.604  -6.010  0.50 14.67           N
ATOM    316  CA  SER    40     -17.279  46.176  -7.148  0.50 14.62           C
ATOM    318  CB  SER    40     -16.053  47.060  -7.335  0.50 14.94           C
ATOM    320  OG  SER    40     -16.458  48.367  -7.690  0.50 15.23           O
ATOM    322  C   SER    40     -16.894  44.691  -7.144  0.50 14.74           C
ATOM    324  O   SER    40     -17.018  44.048  -8.190  0.50 13.11           O
ATOM    326  N   MET    41     -16.429  44.140  -6.011  0.70 14.50           N
ATOM    328  CA  MET    41     -16.178  42.699  -5.979  0.70 17.69           C
ATOM    330  CB  MET    41     -15.783  42.221  -4.589  0.70 17.10           C
ATOM    332  CG  MET    41     -14.312  42.342  -4.347  0.70 22.14           C
ATOM    334  SD  MET    41     -13.942  42.349  -2.431  0.70 31.19          SE
ATOM    336  CE  MET    41     -12.415  43.576  -2.469  0.70 24.49           C
ATOM    338  C   MET    41     -17.447  41.995  -6.467  0.70 13.85           C
ATOM    340  O   MET    41     -17.391  41.116  -7.335  0.70 12.19           O
ATOM    342  N   ILE    42     -18.586  42.445  -5.946  1.00 11.54           N
ATOM    343  CA  ILE    42     -19.860  41.745  -6.191  1.00 10.80           C
ATOM    344  CB  ILE    42     -21.001  42.280  -5.316  1.00 11.27           C
ATOM    345  CG1 ILE    42     -20.695  41.978  -3.842  1.00 13.93           C
ATOM    346  CD1 ILE    42     -21.839  42.300  -2.903  1.00 16.88           C
ATOM    347  CG2 ILE    42     -22.327  41.616  -5.716  1.00 12.87           C
ATOM    348  C   ILE    42     -20.219  41.838  -7.658  1.00  8.83           C
ATOM    349  O   ILE    42     -20.497  40.819  -8.306  1.00  9.33           O
ATOM    350  N   SER    43     -20.157  43.052  -8.211  1.00  8.95           N
ATOM    351  CA  SER    43     -20.581  43.239  -9.602  1.00  9.74           C
ATOM    352  CB  SER    43     -20.655  44.729  -9.931  1.00 10.68           C
ATOM    353  OG  SER    43     -21.770  45.278  -9.279  1.00 13.08           O
ATOM    354  C   SER    43     -19.645  42.587 -10.619  1.00  9.62           C
ATOM    355  O   SER    43     -20.105  42.053 -11.624  1.00  9.13           O
ATOM    356  N   TYR    44     -18.328  42.697 -10.382  1.00  9.20           N
ATOM    357  CA  TYR    44     -17.361  42.244 -11.376  1.00 10.08           C
ATOM    358  CB  TYR    44     -16.121  43.137 -11.344  1.00  9.76           C
ATOM    359  CG  TYR    44     -16.373  44.487 -11.942  1.00  8.65           C
ATOM    360  CD1 TYR    44     -16.965  45.500 -11.184  1.00  8.93           C
ATOM    361  CE1 TYR    44     -17.202  46.730 -11.711  1.00 10.45           C
ATOM    362  CZ  TYR    44     -16.853  46.987 -13.027  1.00 10.79           C
ATOM    363  OH  TYR    44     -17.090  48.220 -13.553  1.00 11.57           O
ATOM    364  CE2 TYR    44     -16.260  46.002 -13.818  1.00 10.86           C
ATOM    365  CD2 TYR    44     -16.019  44.758 -13.255  1.00  9.35           C
ATOM    366  C   TYR    44     -16.923  40.795 -11.222  1.00 12.28           C
ATOM    367  O   TYR    44     -16.468  40.193 -12.203  1.00 12.21           O
ATOM    368  N   HIS    45     -16.993  40.271 -10.000  1.00 14.53           N
ATOM    369  CA  HIS    45     -16.489  38.928  -9.730  1.00 17.90           C
ATOM    370  CB  HIS    45     -15.347  38.951  -8.714  1.00 18.81           C
ATOM    371  CG  HIS    45     -14.062  39.424  -9.294  1.00 21.69           C
ATOM    372  ND1 HIS    45     -13.118  40.111  -8.564  1.00 26.38           N
ATOM    373  CE1 HIS    45     -12.092  40.405  -9.346  1.00 27.60           C
ATOM    374  NE2 HIS    45     -12.350  39.958 -10.563  1.00 26.67           N
ATOM    375  CD2 HIS    45     -13.574  39.339 -10.558  1.00 25.29           C
ATOM    376  C   HIS    45     -17.532  37.898  -9.348  1.00 19.42           C
ATOM    377  O   HIS    45     -17.334  36.722  -9.630  1.00 19.75           O
ATOM    378  N   PHE    46     -18.630  38.324  -8.726  1.00 20.52           N
ATOM    379  CA  PHE    46     -19.661  37.377  -8.261  1.00 22.82           C
ATOM    380  CB  PHE    46     -19.800  37.465  -6.732  1.00 23.98           C
ATOM    381  CG  PHE    46     -18.496  37.308  -6.003  1.00 26.04           C
ATOM    382  CD1 PHE    46     -18.012  36.039  -5.670  1.00 29.01           C
ATOM    383  CE1 PHE    46     -16.817  35.893  -5.005  1.00 27.12           C
ATOM    384  CZ  PHE    46     -16.071  37.013  -4.649  1.00 28.27           C
ATOM    385  CE2 PHE    46     -16.542  38.280  -4.963  1.00 29.34           C
ATOM    386  CD2 PHE    46     -17.743  38.419  -5.640  1.00 27.17           C
ATOM    387  C   PHE    46     -21.004  37.504  -8.954  1.00 22.70           C
ATOM    388  O   PHE    46     -22.017  36.978  -8.483  1.00 25.73           O
ATOM    389  N   GLY    47     -21.020  38.197 -10.083  1.00 20.71           N
ATOM    390  CA  GLY    47     -22.178  38.260 -10.943  1.00 19.73           C
ATOM    391  C   GLY    47     -23.257  39.227 -10.550  1.00 18.52           C
ATOM    392  O   GLY    47     -24.373  39.148 -11.073  1.00 20.99           O
ATOM    393  N   GLY    48     -22.955  40.137  -9.620  1.00 14.66           N
ATOM    394  CA  GLY    48     -23.926  41.115  -9.145  1.00 14.41           C
ATOM    395  C   GLY    48     -25.035  40.479  -8.295  1.00 13.29           C
ATOM    396  O   GLY    48     -24.959  39.296  -7.948  1.00 12.06           O
ATOM    397  N   LYS    49     -26.021  41.290  -7.929  1.00 13.51           N
ATOM    398  CA  LYS    49     -27.206  40.794  -7.200  1.00 13.00           C
ATOM    399  CB  LYS    49     -28.212  41.934  -7.086  1.00 14.01           C
ATOM    400  CG  LYS    49     -29.503  41.518  -6.350  1.00 15.37           C
ATOM    401  CD  LYS    49     -30.528  42.649  -6.447  1.00 16.73           C
ATOM    402  CE  LYS    49     -31.905  42.078  -6.083  1.00 17.71           C
ATOM    403  NZ  LYS    49     -32.895  43.218  -6.101  1.00 18.77           N
ATOM    404  C   LYS    49     -27.809  39.595  -7.932  1.00 13.68           C
ATOM    405  O   LYS    49     -28.212  38.583  -7.331  1.00 13.27           O
ATOM    406  N   GLU    50     -27.876  39.703  -9.258  1.00 12.63           N
ATOM    407  CA  GLU    50     -28.627  38.725 -10.042  1.00 12.69           C
ATOM    408  CB  GLU    50     -28.814  39.232 -11.468  1.00 13.68           C
ATOM    409  CG  GLU    50     -29.657  40.500 -11.528  1.00 14.16           C
ATOM    410  CD  GLU    50     -28.887  41.815 -11.286  1.00 16.98           C
ATOM    411  OE1 GLU    50     -27.638  41.867 -11.018  1.00 15.01           O
ATOM    412  OE2 GLU    50     -29.566  42.854 -11.451  1.00 19.39           O
ATOM    413  C   GLU    50     -27.883  37.393 -10.048  1.00 12.35           C
ATOM    414  O   GLU    50     -28.506  36.350  -9.816  1.00 13.25           O
ATOM    415  N   GLY    51     -26.567  37.455 -10.306  1.00 11.97           N
ATOM    416  CA  GLY    51     -25.695  36.286 -10.303  1.00 11.39           C
ATOM    417  C   GLY    51     -25.724  35.592  -8.952  1.00 13.31           C
ATOM    418  O   GLY    51     -25.865  34.369  -8.874  1.00 12.68           O
ATOM    419  N   LEU    52     -25.637  36.365  -7.877  1.00 12.96           N
ATOM    420  CA  LEU    52     -25.702  35.752  -6.544  1.00 13.84           C
ATOM    421  CB  LEU    52     -25.453  36.774  -5.450  1.00 13.00           C
ATOM    422  CG  LEU    52     -24.017  37.257  -5.300  1.00 15.32           C
ATOM    423  CD1 LEU    52     -24.026  38.415  -4.321  1.00 17.15           C
ATOM    424  CD2 LEU    52     -23.089  36.110  -4.862  1.00 13.25           C
ATOM    425  C   LEU    52     -27.047  35.092  -6.282  1.00 13.75           C
ATOM    426  O   LEU    52     -27.092  34.016  -5.680  1.00 14.21           O
ATOM    427  N   TYR    53     -28.140  35.744  -6.693  1.00 14.29           N
ATOM    428  CA  TYR    53     -29.441  35.176  -6.517  1.00 14.44           C
ATOM    429  CB  TYR    53     -30.541  36.161  -6.936  1.00 12.90           C
ATOM    430  CG  TYR    53     -31.928  35.606  -6.681  1.00 13.47           C
ATOM    431  CD1 TYR    53     -32.405  35.437  -5.365  1.00 13.59           C
ATOM    432  CE1 TYR    53     -33.679  34.910  -5.123  1.00 14.34           C
ATOM    433  CZ  TYR    53     -34.477  34.537  -6.198  1.00 13.72           C
ATOM    434  OH  TYR    53     -35.718  34.039  -5.965  1.00 13.83           O
ATOM    435  CE2 TYR    53     -34.023  34.711  -7.525  1.00 13.18           C
ATOM    436  CD2 TYR    53     -32.751  35.220  -7.740  1.00 11.75           C
ATOM    437  C   TYR    53     -29.578  33.863  -7.306  1.00 14.35           C
ATOM    438  O   TYR    53     -30.064  32.892  -6.754  1.00 14.84           O
ATOM    439  N   ALA    54     -29.125  33.849  -8.569  1.00 14.57           N
ATOM    440  CA  ALA    54     -29.145  32.612  -9.394  1.00 14.76           C
ATOM    441  CB  ALA    54     -28.572  32.882 -10.785  1.00 15.38           C
ATOM    442  C   ALA    54     -28.382  31.465  -8.737  1.00 16.02           C
ATOM    443  O   ALA    54     -28.853  30.302  -8.752  1.00 16.58           O
ATOM    444  N   ALA    55     -27.206  31.790  -8.179  1.00 15.71           N
ATOM    445  CA  ALA    55     -26.349  30.797  -7.512  1.00 16.60           C
ATOM    446  CB  ALA    55     -24.985  31.418  -7.114  1.00 15.94           C
ATOM    447  C   ALA    55     -27.087  30.239  -6.293  1.00 16.62           C
ATOM    448  O   ALA    55     -27.124  29.027  -6.079  1.00 17.79           O
ATOM    449  N   VAL    56     -27.698  31.121  -5.509  1.00 16.55           N
ATOM    450  CA  VAL    56     -28.442  30.724  -4.309  1.00 17.16           C
ATOM    451  CB  VAL    56     -28.958  31.984  -3.551  1.00 17.77           C
ATOM    452  CG1 VAL    56     -30.068  31.623  -2.591  1.00 18.51           C
ATOM    453  CG2 VAL    56     -27.808  32.716  -2.799  1.00 16.47           C
ATOM    454  C   VAL    56     -29.643  29.805  -4.680  1.00 17.90           C
ATOM    455  O   VAL    56     -29.872  28.769  -4.064  1.00 18.42           O
ATOM    456  N   LEU    57     -30.409  30.209  -5.690  1.00 18.83           N
ATOM    457  CA  LEU    57     -31.588  29.428  -6.064  1.00 20.44           C
ATOM    458  CB  LEU    57     -32.429  30.224  -7.058  1.00 19.98           C
ATOM    459  CG  LEU    57     -33.922  29.962  -7.106  1.00 25.44           C
ATOM    460  CD1 LEU    57     -34.592  30.145  -5.755  1.00 24.83           C
ATOM    461  CD2 LEU    57     -34.480  30.939  -8.118  1.00 27.85           C
ATOM    462  C   LEU    57     -31.165  28.050  -6.627  1.00 20.90           C
ATOM    463  O   LEU    57     -31.808  27.031  -6.345  1.00 20.75           O
ATOM    464  N   GLN    58     -30.052  28.016  -7.360  1.00 21.09           N
ATOM    465  CA  GLN    58     -29.551  26.768  -7.929  1.00 22.36           C
ATOM    466  CB  GLN    58     -28.346  26.998  -8.858  1.00 23.54           C
ATOM    467  CG  GLN    58     -27.960  25.733  -9.635  1.00 27.99           C
ATOM    468  CD  GLN    58     -29.191  25.021 -10.220  1.00 35.26           C
ATOM    469  OE1 GLN    58     -29.888  25.570 -11.083  1.00 37.09           O
ATOM    470  NE2 GLN    58     -29.469  23.796  -9.736  1.00 38.37           N
ATOM    471  C   GLN    58     -29.205  25.793  -6.803  1.00 22.27           C
ATOM    472  O   GLN    58     -29.522  24.575  -6.887  1.00 22.87           O
ATOM    473  N   GLU    59     -28.579  26.306  -5.741  0.50 21.38           N
ATOM    475  CA  GLU    59     -28.271  25.503  -4.553  0.50 21.43           C
ATOM    477  CB  GLU    59     -27.388  26.269  -3.553  0.50 21.44           C
ATOM    479  CG  GLU    59     -26.869  25.393  -2.378  0.50 21.69           C
ATOM    481  CD  GLU    59     -26.114  26.171  -1.293  0.50 22.85           C
ATOM    483  OE1 GLU    59     -25.921  27.400  -1.427  0.50 25.49           O
ATOM    485  OE2 GLU    59     -25.705  25.539  -0.292  0.50 22.88           O
ATOM    487  C   GLU    59     -29.535  25.040  -3.848  0.50 20.81           C
ATOM    489  O   GLU    59     -29.586  23.907  -3.359  0.50 20.84           O
ATOM    491  N   GLN    60     -30.526  25.927  -3.763  1.00 20.01           N
ATOM    492  CA  GLN    60     -31.823  25.588  -3.146  1.00 20.01           C
ATOM    493  CB  GLN    60     -32.751  26.812  -3.069  1.00 18.91           C
ATOM    494  CG  GLN    60     -32.254  27.942  -2.169  1.00 22.57           C
ATOM    495  CD  GLN    60     -32.132  27.523  -0.695  1.00 23.52           C
ATOM    496  OE1 GLN    60     -33.063  26.939  -0.124  1.00 25.17           O
ATOM    497  NE2 GLN    60     -30.987  27.798  -0.090  1.00 23.26           N
ATOM    498  C   GLN    60     -32.527  24.444  -3.865  1.00 18.38           C
ATOM    499  O   GLN    60     -33.135  23.578  -3.222  1.00 19.77           O
ATOM    500  N   PHE    61     -32.428  24.422  -5.192  1.00 18.84           N
ATOM    501  CA  PHE    61     -33.171  23.452  -5.980  1.00 18.05           C
ATOM    502  CB  PHE    61     -33.920  24.171  -7.089  1.00 18.50           C
ATOM    503  CG  PHE    61     -35.166  24.855  -6.603  1.00 16.29           C
ATOM    504  CD1 PHE    61     -35.097  26.142  -6.066  1.00 16.96           C
ATOM    505  CE1 PHE    61     -36.246  26.777  -5.586  1.00 17.57           C
ATOM    506  CZ  PHE    61     -37.469  26.128  -5.639  1.00 16.05           C
ATOM    507  CE2 PHE    61     -37.562  24.840  -6.149  1.00 16.94           C
ATOM    508  CD2 PHE    61     -36.415  24.206  -6.655  1.00 16.84           C
ATOM    509  C   PHE    61     -32.316  22.293  -6.529  1.00 18.86           C
ATOM    510  O   PHE    61     -32.799  21.474  -7.288  1.00 17.68           O
ATOM    511  N   ALA    62     -31.039  22.250  -6.153  1.00 19.75           N
ATOM    512  CA  ALA    62     -30.116  21.245  -6.684  1.00 20.70           C
ATOM    513  CB  ALA    62     -28.776  21.377  -5.988  1.00 21.27           C
ATOM    514  C   ALA    62     -30.639  19.784  -6.602  1.00 21.89           C
ATOM    515  O   ALA    62     -30.568  19.023  -7.588  1.00 22.43           O
ATOM    516  N   CYS    63     -31.180  19.433  -5.431  0.50 22.09           N
ATOM    518  CA  CYS    63     -31.713  18.088  -5.137  0.50 22.45           C
ATOM    520  CB  CYS    63     -32.194  18.002  -3.682  0.50 21.93           C
ATOM    522  SG  CYS    63     -30.917  17.628  -2.464  0.50 27.26           S
ATOM    524  C   CYS    63     -32.836  17.625  -6.072  0.50 21.59           C
ATOM    526  O   CYS    63     -33.089  16.419  -6.196  0.50 20.76           O
ATOM    528  N   PHE    64     -33.520  18.570  -6.711  1.00 20.75           N
ATOM    529  CA  PHE    64     -34.567  18.235  -7.659  1.00 20.96           C
ATOM    530  CB  PHE    64     -35.405  19.451  -8.035  1.00 19.37           C
ATOM    531  CG  PHE    64     -36.415  19.870  -6.996  1.00 19.26           C
ATOM    532  CD1 PHE    64     -36.028  20.573  -5.872  1.00 19.73           C
ATOM    533  CE1 PHE    64     -36.994  21.017  -4.934  1.00 18.87           C
ATOM    534  CZ  PHE    64     -38.331  20.739  -5.155  1.00 17.71           C
ATOM    535  CE2 PHE    64     -38.722  20.056  -6.260  1.00 18.01           C
ATOM    536  CD2 PHE    64     -37.778  19.643  -7.202  1.00 18.03           C
ATOM    537  C   PHE    64     -34.008  17.587  -8.957  1.00 21.96           C
ATOM    538  O   PHE    64     -34.743  16.934  -9.688  1.00 23.37           O
ATOM    539  N   GLY    65     -32.716  17.728  -9.209  1.00 22.10           N
ATOM    540  CA  GLY    65     -32.106  17.074 -10.371  1.00 23.22           C
ATOM    541  C   GLY    65     -31.577  15.697 -10.034  1.00 24.11           C
ATOM    542  O   GLY    65     -30.930  15.040 -10.873  1.00 24.63           O
ATOM    543  N   GLN    66     -31.841  15.266  -8.802  1.00 24.05           N
ATOM    544  CA  GLN    66     -31.357  13.993  -8.283  1.00 24.54           C
ATOM    545  CB  GLN    66     -30.285  14.241  -7.234  1.00 25.47           C
ATOM    546  CG  GLN    66     -28.910  14.511  -7.854  1.00 30.42           C
ATOM    547  CD  GLN    66     -28.001  15.342  -6.962  1.00 36.44           C
ATOM    548  OE1 GLN    66     -28.382  16.421  -6.479  1.00 39.74           O
ATOM    549  NE2 GLN    66     -26.784  14.859  -6.761  1.00 37.88           N
ATOM    550  C   GLN    66     -32.519  13.185  -7.688  1.00 23.92           C
ATOM    551  O   GLN    66     -32.671  13.075  -6.467  1.00 23.62           O
ATOM    552  N   LEU    67     -33.319  12.616  -8.579  1.00 22.78           N
ATOM    553  CA  LEU    67     -34.545  11.916  -8.200  1.00 21.55           C
ATOM    554  CB  LEU    67     -35.668  12.370  -9.128  1.00 21.58           C
ATOM    555  CG  LEU    67     -35.860  13.887  -9.236  1.00 21.33           C
ATOM    556  CD1 LEU    67     -36.995  14.155 -10.180  1.00 22.06           C
ATOM    557  CD2 LEU    67     -36.147  14.475  -7.858  1.00 21.71           C
ATOM    558  C   LEU    67     -34.455  10.391  -8.219  1.00 21.26           C
ATOM    559  O   LEU    67     -35.485   9.730  -8.205  1.00 20.77           O
ATOM    560  N   ASP    68     -33.243   9.827  -8.209  1.00 20.58           N
ATOM    561  CA  ASP    68     -33.066   8.375  -8.336  1.00 21.06           C
ATOM    562  CB  ASP    68     -31.588   8.003  -8.545  1.00 22.43           C
ATOM    563  CG  ASP    68     -31.143   8.118 -10.019  1.00 25.47           C
ATOM    564  OD1 ASP    68     -32.015   8.221 -10.922  1.00 30.33           O
ATOM    565  OD2 ASP    68     -29.915   8.103 -10.278  1.00 28.49           O
ATOM    566  C   ASP    68     -33.707   7.551  -7.191  1.00 21.11           C
ATOM    567  O   ASP    68     -34.136   6.420  -7.409  1.00 20.72           O
ATOM    568  N   ASP    69     -33.790   8.106  -5.981  1.00 20.70           N
ATOM    569  CA  ASP    69     -34.499   7.393  -4.890  1.00 21.27           C
ATOM    570  CB  ASP    69     -34.371   8.149  -3.562  1.00 22.13           C
ATOM    571  CG  ASP    69     -32.986   8.014  -2.948  1.00 24.48           C
ATOM    572  OD1 ASP    69     -32.312   6.996  -3.200  1.00 27.84           O
ATOM    573  OD2 ASP    69     -32.581   8.940  -2.220  1.00 28.42           O
ATOM    574  C   ASP    69     -35.988   7.188  -5.201  1.00 20.42           C
ATOM    575  O   ASP    69     -36.621   6.239  -4.725  1.00 20.59           O
ATOM    576  N   ILE    70     -36.539   8.100  -5.989  1.00 19.38           N
ATOM    577  CA  ILE    70     -37.928   7.992  -6.429  1.00 18.85           C
ATOM    578  CB  ILE    70     -38.556   9.366  -6.619  1.00 18.52           C
ATOM    579  CG1 ILE    70     -38.411  10.193  -5.323  1.00 21.19           C
ATOM    580  CD1 ILE    70     -38.809  11.665  -5.486  1.00 21.34           C
ATOM    581  CG2 ILE    70     -40.039   9.235  -6.997  1.00 19.97           C
ATOM    582  C   ILE    70     -38.014   7.194  -7.726  1.00 17.62           C
ATOM    583  O   ILE    70     -38.761   6.225  -7.804  1.00 18.07           O
ATOM    584  N   ARG    71     -37.271   7.614  -8.747  1.00 16.37           N
ATOM    585  CA  ARG    71     -37.312   6.918 -10.054  1.00 16.19           C
ATOM    586  CB  ARG    71     -36.314   7.527 -11.036  1.00 16.11           C
ATOM    587  CG  ARG    71     -36.578   8.965 -11.418  1.00 19.99           C
ATOM    588  CD  ARG    71     -35.754   9.340 -12.654  1.00 23.24           C
ATOM    589  NE  ARG    71     -35.827  10.770 -12.961  1.00 25.78           N
ATOM    590  CZ  ARG    71     -36.850  11.371 -13.583  1.00 28.05           C
ATOM    591  NH1 ARG    71     -37.910  10.665 -13.975  1.00 28.38           N
ATOM    592  NH2 ARG    71     -36.818  12.683 -13.821  1.00 22.66           N
ATOM    593  C   ARG    71     -36.981   5.449  -9.914  1.00 14.93           C
ATOM    594  O   ARG    71     -37.529   4.587 -10.637  1.00 13.88           O
ATOM    595  N   GLY    72     -36.074   5.141  -8.978  1.00 14.49           N
ATOM    596  CA  GLY    72     -35.604   3.763  -8.809  1.00 13.79           C
ATOM    597  C   GLY    72     -36.685   2.791  -8.352  1.00 14.28           C
ATOM    598  O   GLY    72     -36.498   1.596  -8.465  1.00 15.03           O
ATOM    599  N   GLN    73     -37.809   3.316  -7.844  1.00 13.08           N
ATOM    600  CA  GLN    73     -38.965   2.522  -7.381  1.00 13.26           C
ATOM    601  CB  GLN    73     -39.651   3.251  -6.211  1.00 13.37           C
ATOM    602  CG  GLN    73     -38.783   3.419  -4.979  1.00 16.75           C
ATOM    603  CD  GLN    73     -38.147   2.137  -4.546  1.00 21.82           C
ATOM    604  OE1 GLN    73     -38.813   1.105  -4.424  1.00 22.36           O
ATOM    605  NE2 GLN    73     -36.834   2.173  -4.334  1.00 26.08           N
ATOM    606  C   GLN    73     -40.037   2.290  -8.454  1.00 12.89           C
ATOM    607  O   GLN    73     -41.041   1.624  -8.204  1.00 12.88           O
ATOM    608  N   ALA    74     -39.844   2.871  -9.636  1.00 12.26           N
ATOM    609  CA  ALA    74     -40.800   2.693 -10.736  1.00 12.16           C
ATOM    610  CB  ALA    74     -40.216   3.279 -12.015  1.00 12.22           C
ATOM    611  C   ALA    74     -41.152   1.219 -10.951  1.00 12.26           C
ATOM    612  O   ALA    74     -40.261   0.342 -10.903  1.00 11.19           O
ATOM    613  N   GLY    75     -42.429   0.939 -11.235  1.00 11.65           N
ATOM    614  CA  GLY    75     -42.868  -0.466 -11.342  1.00 10.70           C
ATOM    615  C   GLY    75     -43.731  -0.790 -10.118  1.00 11.25           C
ATOM    616  O   GLY    75     -44.484  -1.762 -10.116  1.00 11.59           O
ATOM    617  N   ASP    76     -43.570  -0.008  -9.043  1.00 12.06           N
ATOM    618  CA  ASP    76     -44.360  -0.166  -7.824  1.00 12.36           C
ATOM    619  CB  ASP    76     -43.487  -0.827  -6.733  1.00 12.42           C
ATOM    620  CG  ASP    76     -44.202  -1.022  -5.400  1.00 15.66           C
ATOM    621  OD1 ASP    76     -45.317  -0.484  -5.151  1.00 16.24           O
ATOM    622  OD2 ASP    76     -43.604  -1.751  -4.566  1.00 15.57           O
ATOM    623  C   ASP    76     -44.849   1.223  -7.391  1.00 12.68           C
ATOM    624  O   ASP    76     -44.129   1.931  -6.685  1.00 11.41           O
ATOM    625  N   PRO    77     -46.043   1.647  -7.879  1.00 13.71           N
ATOM    626  CA  PRO    77     -46.488   3.033  -7.645  1.00 13.93           C
ATOM    627  CB  PRO    77     -47.873   3.103  -8.333  1.00 13.23           C
ATOM    628  CG  PRO    77     -47.761   2.072  -9.458  1.00 15.27           C
ATOM    629  CD  PRO    77     -46.977   0.920  -8.766  1.00 14.18           C
ATOM    630  C   PRO    77     -46.533   3.405  -6.182  1.00 13.31           C
ATOM    631  O   PRO    77     -46.184   4.524  -5.838  1.00 13.85           O
ATOM    632  N   LEU    78     -46.946   2.477  -5.319  0.50 13.21           N
ATOM    634  CA  LEU    78     -46.992   2.787  -3.889  0.50 13.74           C
ATOM    636  CB  LEU    78     -47.582   1.617  -3.103  0.50 13.51           C
ATOM    638  CG  LEU    78     -48.457   1.997  -1.907  0.50 14.73           C
ATOM    640  CD1 LEU    78     -49.147   0.741  -1.413  0.50 17.25           C
ATOM    642  CD2 LEU    78     -47.650   2.638  -0.804  0.50 19.04           C
ATOM    644  C   LEU    78     -45.602   3.124  -3.366  0.50 13.01           C
ATOM    646  O   LEU    78     -45.444   4.072  -2.614  0.50 12.86           O
ATOM    648  N   ALA    79     -44.598   2.339  -3.761  1.00 13.15           N
ATOM    649  CA  ALA    79     -43.203   2.602  -3.355  1.00 13.03           C
ATOM    650  CB  ALA    79     -42.284   1.481  -3.789  1.00 13.22           C
ATOM    651  C   ALA    79     -42.705   3.953  -3.901  1.00 12.54           C
ATOM    652  O   ALA    79     -41.949   4.654  -3.228  1.00 12.09           O
ATOM    653  N   VAL    80     -43.099   4.301  -5.131  1.00 11.58           N
ATOM    654  CA  VAL    80     -42.787   5.630  -5.672  1.00 12.21           C
ATOM    655  CB  VAL    80     -43.296   5.773  -7.101  1.00 11.22           C
ATOM    656  CG1 VAL    80     -43.163   7.227  -7.624  1.00 12.32           C
ATOM    657  CG2 VAL    80     -42.538   4.787  -8.035  1.00 10.84           C
ATOM    658  C   VAL    80     -43.376   6.760  -4.777  1.00 13.05           C
ATOM    659  O   VAL    80     -42.668   7.710  -4.420  1.00 13.23           O
ATOM    660  N   MET    81     -44.661   6.646  -4.436  0.70 12.38           N
ATOM    662  CA  MET    81     -45.330   7.668  -3.603  0.70 12.69           C
ATOM    664  CB  MET    81     -46.833   7.394  -3.427  0.70 13.82           C
ATOM    666  CG  MET    81     -47.597   7.155  -4.747  0.70 14.01           C
ATOM    668  SD  MET    81     -47.622   8.670  -5.960  0.70 21.09          SE
ATOM    670  CE  MET    81     -47.084   7.612  -7.496  0.70 15.28           C
ATOM    672  C   MET    81     -44.684   7.771  -2.235  0.70 13.11           C
ATOM    674  O   MET    81     -44.538   8.886  -1.698  0.70 12.95           O
ATOM    676  N   THR    82     -44.336   6.621  -1.655  1.00 11.97           N
ATOM    677  CA  THR    82     -43.690   6.575  -0.342  1.00 13.13           C
ATOM    678  CB  THR    82     -43.605   5.113   0.176  1.00 12.76           C
ATOM    679  OG1 THR    82     -44.931   4.563   0.297  1.00 13.08           O
ATOM    680  CG2 THR    82     -42.926   5.051   1.546  1.00 12.65           C
ATOM    681  C   THR    82     -42.311   7.220  -0.401  1.00 12.27           C
ATOM    682  O   THR    82     -41.988   8.047   0.443  1.00 12.09           O
ATOM    683  N   ALA    83     -41.522   6.874  -1.419  1.00 12.10           N
ATOM    684  CA  ALA    83     -40.189   7.455  -1.613  1.00 12.71           C
ATOM    685  CB  ALA    83     -39.469   6.804  -2.772  1.00 13.64           C
ATOM    686  C   ALA    83     -40.256   8.962  -1.829  1.00 13.31           C
ATOM    687  O   ALA    83     -39.424   9.717  -1.293  1.00 13.65           O
ATOM    688  N   TYR    84     -41.234   9.393  -2.621  1.00 12.01           N
ATOM    689  CA  TYR    84     -41.450  10.829  -2.827  1.00 11.80           C
ATOM    690  CB  TYR    84     -42.626  11.070  -3.785  1.00 11.47           C
ATOM    691  CG  TYR    84     -43.055  12.503  -3.698  1.00 11.01           C
ATOM    692  CD1 TYR    84     -42.230  13.514  -4.207  1.00  9.70           C
ATOM    693  CE1 TYR    84     -42.562  14.853  -4.058  1.00  7.72           C
ATOM    694  CZ  TYR    84     -43.777  15.207  -3.416  1.00  9.90           C
ATOM    695  OH  TYR    84     -44.090  16.520  -3.245  1.00  9.60           O
ATOM    696  CE2 TYR    84     -44.606  14.228  -2.886  1.00 10.03           C
ATOM    697  CD2 TYR    84     -44.241  12.867  -3.033  1.00  8.93           C
ATOM    698  C   TYR    84     -41.702  11.542  -1.464  1.00 11.96           C
ATOM    699  O   TYR    84     -41.113  12.588  -1.195  1.00 11.13           O
ATOM    700  N   LEU    85     -42.594  11.008  -0.646  1.00 10.86           N
ATOM    701  CA  LEU    85     -42.868  11.627   0.683  1.00 10.85           C
ATOM    702  CB  LEU    85     -44.003  10.908   1.396  1.00 10.34           C
ATOM    703  CG  LEU    85     -45.392  11.039   0.735  1.00 11.08           C
ATOM    704  CD1 LEU    85     -46.412  10.164   1.470  1.00 14.10           C
ATOM    705  CD2 LEU    85     -45.840  12.513   0.824  1.00 11.81           C
ATOM    706  C   LEU    85     -41.608  11.688   1.547  1.00 10.59           C
ATOM    707  O   LEU    85     -41.299  12.737   2.160  1.00  9.89           O
ATOM    708  N   ARG    86     -40.890  10.577   1.613  1.00 11.70           N
ATOM    709  CA  ARG    86     -39.686  10.504   2.430  1.00 12.21           C
ATOM    710  CB  ARG    86     -39.118   9.092   2.407  1.00 13.48           C
ATOM    711  CG  ARG    86     -38.070   8.880   3.462  1.00 16.80           C
ATOM    712  CD  ARG    86     -37.752   7.377   3.627  1.00 18.02           C
ATOM    713  NE  ARG    86     -38.810   6.676   4.350  1.00 20.50           N
ATOM    714  CZ  ARG    86     -39.556   5.706   3.833  1.00 23.33           C
ATOM    715  NH1 ARG    86     -39.354   5.300   2.584  1.00 26.93           N
ATOM    716  NH2 ARG    86     -40.472   5.111   4.589  1.00 24.38           N
ATOM    717  C   ARG    86     -38.635  11.526   1.947  1.00 11.94           C
ATOM    718  O   ARG    86     -37.985  12.202   2.764  1.00 11.86           O
ATOM    719  N   TRP    87     -38.462  11.595   0.637  1.00 11.06           N
ATOM    720  CA  TRP    87     -37.511  12.517   0.011  1.00 11.54           C
ATOM    721  CB  TRP    87     -37.513  12.276  -1.518  1.00 11.78           C
ATOM    722  CG  TRP    87     -36.670  13.219  -2.336  1.00 11.45           C
ATOM    723  CD1 TRP    87     -35.298  13.232  -2.473  1.00 12.95           C
ATOM    724  NE1 TRP    87     -34.914  14.228  -3.355  1.00 11.75           N
ATOM    725  CE2 TRP    87     -36.041  14.867  -3.805  1.00 12.69           C
ATOM    726  CD2 TRP    87     -37.162  14.253  -3.195  1.00 12.32           C
ATOM    727  CE3 TRP    87     -38.448  14.715  -3.505  1.00 13.71           C
ATOM    728  CZ3 TRP    87     -38.582  15.767  -4.386  1.00 13.30           C
ATOM    729  CH2 TRP    87     -37.436  16.377  -4.989  1.00 14.32           C
ATOM    730  CZ2 TRP    87     -36.166  15.944  -4.703  1.00 14.12           C
ATOM    731  C   TRP    87     -37.904  13.972   0.307  1.00 11.68           C
ATOM    732  O   TRP    87     -37.046  14.801   0.617  1.00 11.77           O
ATOM    733  N   THR    88     -39.191  14.280   0.183  1.00 11.01           N
ATOM    734  CA  THR    88     -39.685  15.654   0.390  1.00 11.22           C
ATOM    735  CB  THR    88     -41.147  15.790  -0.053  1.00 12.10           C
ATOM    736  OG1 THR    88     -41.220  15.503  -1.460  1.00 12.19           O
ATOM    737  CG2 THR    88     -41.678  17.220   0.199  1.00 12.36           C
ATOM    738  C   THR    88     -39.498  16.086   1.853  1.00 10.14           C
ATOM    739  O   THR    88     -39.045  17.207   2.119  1.00  9.63           O
ATOM    740  N   ILE    89     -39.826  15.192   2.778  1.00 10.71           N
ATOM    741  CA  ILE    89     -39.609  15.477   4.191  1.00 11.44           C
ATOM    742  CB  ILE    89     -40.178  14.352   5.067  1.00 11.62           C
ATOM    743  CG1 ILE    89     -41.718  14.377   4.949  1.00 10.67           C
ATOM    744  CD1 ILE    89     -42.368  13.154   5.612  1.00 14.32           C
ATOM    745  CG2 ILE    89     -39.752  14.574   6.521  1.00  9.76           C
ATOM    746  C   ILE    89     -38.108  15.719   4.470  1.00 11.65           C
ATOM    747  O   ILE    89     -37.748  16.702   5.123  1.00 10.49           O
ATOM    748  N   GLN    90     -37.253  14.832   3.946  0.60 11.78           N
ATOM    750  CA  GLN    90     -35.805  15.009   4.058  0.60 12.90           C
ATOM    752  CB  GLN    90     -35.059  13.906   3.294  0.60 13.23           C
ATOM    754  CG  GLN    90     -33.581  13.882   3.617  0.60 18.71           C
ATOM    756  CD  GLN    90     -33.320  13.696   5.114  0.60 24.36           C
ATOM    758  OE1 GLN    90     -32.857  14.615   5.797  0.60 28.60           O
ATOM    760  NE2 GLN    90     -33.626  12.502   5.631  0.60 27.22           N
ATOM    762  C   GLN    90     -35.349  16.402   3.563  0.60 12.09           C
ATOM    764  O   GLN    90     -34.599  17.104   4.235  0.60 11.76           O
ATOM    766  N   ARG    91     -35.849  16.798   2.401  1.00 12.06           N
ATOM    767  CA  ARG    91     -35.481  18.070   1.792  1.00 11.96           C
ATOM    768  CB  ARG    91     -36.237  18.253   0.485  1.00 13.06           C
ATOM    769  CG  ARG    91     -35.579  17.519  -0.624  1.00 17.79           C
ATOM    770  CD  ARG    91     -36.116  18.032  -1.972  1.00 20.49           C
ATOM    771  NE  ARG    91     -37.524  17.695  -2.235  1.00 21.73           N
ATOM    772  CZ  ARG    91     -38.542  18.563  -2.176  1.00 22.41           C
ATOM    773  NH1 ARG    91     -39.778  18.166  -2.519  1.00 18.87           N
ATOM    774  NH2 ARG    91     -38.328  19.821  -1.792  1.00 17.44           N
ATOM    775  C   ARG    91     -35.787  19.210   2.737  1.00 11.92           C
ATOM    776  O   ARG    91     -34.954  20.120   2.929  1.00 11.63           O
ATOM    777  N   HIS    92     -36.985  19.171   3.324  1.00 11.45           N
ATOM    778  CA  HIS    92     -37.369  20.231   4.257  1.00 12.36           C
ATOM    779  CB  HIS    92     -38.873  20.203   4.534  1.00 13.78           C
ATOM    780  CG  HIS    92     -39.696  20.557   3.336  1.00 14.40           C
ATOM    781  ND1 HIS    92     -39.591  21.777   2.684  1.00 19.47           N
ATOM    782  CE1 HIS    92     -40.452  21.801   1.674  1.00 21.35           C
ATOM    783  NE2 HIS    92     -41.103  20.649   1.649  1.00 16.69           N
ATOM    784  CD2 HIS    92     -40.635  19.846   2.660  1.00 16.03           C
ATOM    785  C   HIS    92     -36.565  20.215   5.544  1.00 12.15           C
ATOM    786  O   HIS    92     -36.192  21.268   6.056  1.00 11.95           O
ATOM    787  N   ARG    93     -36.254  19.030   6.054  1.00 11.79           N
ATOM    788  CA  ARG    93     -35.455  18.958   7.286  1.00 12.70           C
ATOM    789  CB  ARG    93     -35.461  17.537   7.853  1.00 12.66           C
ATOM    790  CG  ARG    93     -36.858  17.020   8.266  1.00 13.84           C
ATOM    791  CD  ARG    93     -37.401  17.762   9.453  1.00 18.09           C
ATOM    792  NE  ARG    93     -38.685  17.215   9.878  1.00 17.47           N
ATOM    793  CZ  ARG    93     -39.526  17.858  10.676  1.00 16.59           C
ATOM    794  NH1 ARG    93     -39.223  19.072  11.110  1.00 17.37           N
ATOM    795  NH2 ARG    93     -40.666  17.281  11.023  1.00 15.53           N
ATOM    796  C   ARG    93     -34.025  19.435   7.057  1.00 13.20           C
ATOM    797  O   ARG    93     -33.450  20.125   7.905  1.00 15.46           O
ATOM    798  N   ASN    94     -33.459  19.087   5.914  1.00 12.51           N
ATOM    799  CA  ASN    94     -32.101  19.512   5.580  1.00 14.01           C
ATOM    800  CB  ASN    94     -31.566  18.704   4.408  1.00 15.34           C
ATOM    801  CG  ASN    94     -31.380  17.226   4.724  1.00 18.74           C
ATOM    802  OD1 ASN    94     -31.130  16.441   3.813  1.00 27.63           O
ATOM    803  ND2 ASN    94     -31.508  16.841   5.986  1.00 22.90           N
ATOM    804  C   ASN    94     -32.010  20.978   5.199  1.00 13.91           C
ATOM    805  O   ASN    94     -30.942  21.582   5.307  1.00 12.63           O
ATOM    806  N   ASN    95     -33.118  21.549   4.732  1.00 13.29           N
ATOM    807  CA  ASN    95     -33.111  22.936   4.270  1.00 15.16           C
ATOM    808  CB  ASN    95     -32.967  23.054   2.763  1.00 16.24           C
ATOM    809  CG  ASN    95     -32.773  24.515   2.339  1.00 19.00           C
ATOM    810  OD1 ASN    95     -32.538  25.397   3.185  1.00 16.84           O
ATOM    811  ND2 ASN    95     -32.897  24.782   1.041  1.00 21.24           N
ATOM    812  C   ASN    95     -34.330  23.717   4.692  1.00 15.67           C
ATOM    813  O   ASN    95     -35.314  23.831   3.936  1.00 15.80           O
ATOM    814  N   PRO    96     -34.271  24.260   5.900  1.00 16.89           N
ATOM    815  CA  PRO    96     -35.322  25.100   6.460  1.00 18.18           C
ATOM    816  CB  PRO    96     -34.732  25.555   7.802  1.00 18.94           C
ATOM    817  CG  PRO    96     -33.729  24.472   8.148  1.00 19.40           C
ATOM    818  CD  PRO    96     -33.147  24.066   6.837  1.00 17.29           C
ATOM    819  C   PRO    96     -35.602  26.309   5.578  1.00 17.64           C
ATOM    820  O   PRO    96     -36.688  26.843   5.668  1.00 20.08           O
ATOM    821  N   GLN    97     -34.664  26.718   4.721  1.00 17.55           N
ATOM    822  CA  GLN    97     -34.882  27.924   3.884  1.00 16.15           C
ATOM    823  CB  GLN    97     -33.556  28.526   3.375  1.00 18.11           C
ATOM    824  CG  GLN    97     -32.586  28.997   4.445  1.00 21.27           C
ATOM    825  CD  GLN    97     -32.986  30.332   5.097  1.00 25.68           C
ATOM    826  OE1 GLN    97     -34.153  30.593   5.335  1.00 27.40           O
ATOM    827  NE2 GLN    97     -32.009  31.165   5.381  1.00 27.04           N
ATOM    828  C   GLN    97     -35.744  27.610   2.655  1.00 14.78           C
ATOM    829  O   GLN    97     -36.230  28.506   1.960  1.00 11.98           O
ATOM    830  N   LEU    98     -35.901  26.333   2.335  1.00 12.64           N
ATOM    831  CA  LEU    98     -36.399  26.054   0.980  1.00 12.07           C
ATOM    832  CB  LEU    98     -36.223  24.576   0.576  1.00 12.25           C
ATOM    833  CG  LEU    98     -36.864  24.142  -0.779  1.00 13.48           C
ATOM    834  CD1 LEU    98     -36.177  24.694  -2.050  1.00 15.69           C
ATOM    835  CD2 LEU    98     -36.865  22.621  -0.848  1.00 15.12           C
ATOM    836  C   LEU    98     -37.808  26.609   0.762  1.00  9.66           C
ATOM    837  O   LEU    98     -38.058  27.231  -0.286  1.00  9.22           O
ATOM    838  N   LEU    99     -38.723  26.475   1.724  1.00  9.90           N
ATOM    839  CA  LEU    99     -40.096  26.921   1.392  1.00 10.68           C
ATOM    840  CB  LEU    99     -41.134  26.482   2.475  1.00 11.84           C
ATOM    841  CG  LEU    99     -41.720  25.109   2.218  1.00 12.27           C
ATOM    842  CD1 LEU    99     -42.546  24.691   3.463  1.00 16.86           C
ATOM    843  CD2 LEU    99     -42.530  24.990   0.943  1.00 14.59           C
ATOM    844  C   LEU    99     -40.166  28.414   1.244  1.00 10.51           C
ATOM    845  O   LEU    99     -41.036  28.919   0.576  1.00 11.22           O
ATOM    846  N   ARG   100     -39.232  29.138   1.869  1.00  8.91           N
ATOM    847  CA  ARG   100     -39.171  30.614   1.637  1.00 10.19           C
ATOM    848  CB  ARG   100     -38.051  31.233   2.443  1.00  9.36           C
ATOM    849  CG  ARG   100     -38.293  31.279   3.923  1.00 12.57           C
ATOM    850  CD  ARG   100     -37.117  31.919   4.691  1.00 14.26           C
ATOM    851  NE  ARG   100     -37.502  32.131   6.084  1.00 21.03           N
ATOM    852  CZ  ARG   100     -36.662  32.254   7.102  1.00 26.22           C
ATOM    853  NH1 ARG   100     -35.340  32.191   6.906  1.00 25.30           N
ATOM    854  NH2 ARG   100     -37.156  32.455   8.326  1.00 30.04           N
ATOM    855  C   ARG   100     -38.944  30.908   0.135  1.00  9.56           C
ATOM    856  O   ARG   100     -39.737  31.609  -0.479  1.00  9.17           O
ATOM    857  N   PHE   101     -37.894  30.333  -0.451  1.00  8.88           N
ATOM    858  CA  PHE   101     -37.584  30.586  -1.861  1.00  7.74           C
ATOM    859  CB  PHE   101     -36.227  29.979  -2.191  1.00  9.07           C
ATOM    860  CG  PHE   101     -35.072  30.718  -1.553  1.00  8.31           C
ATOM    861  CD1 PHE   101     -34.572  31.865  -2.155  1.00  9.65           C
ATOM    862  CE1 PHE   101     -33.460  32.577  -1.586  1.00 12.39           C
ATOM    863  CZ  PHE   101     -32.856  32.079  -0.434  1.00 11.45           C
ATOM    864  CE2 PHE   101     -33.351  30.895   0.160  1.00 13.90           C
ATOM    865  CD2 PHE   101     -34.452  30.220  -0.416  1.00 11.33           C
ATOM    866  C   PHE   101     -38.651  29.978  -2.784  1.00  8.41           C
ATOM    867  O   PHE   101     -39.040  30.587  -3.776  1.00  8.06           O
ATOM    868  N   TYR   102     -39.122  28.777  -2.420  1.00  7.06           N
ATOM    869  CA  TYR   102     -40.068  28.027  -3.247  1.00  7.90           C
ATOM    870  CB  TYR   102     -40.262  26.695  -2.548  1.00  7.79           C
ATOM    871  CG  TYR   102     -41.077  25.629  -3.236  1.00  8.54           C
ATOM    872  CD1 TYR   102     -42.489  25.656  -3.181  1.00 10.03           C
ATOM    873  CE1 TYR   102     -43.257  24.599  -3.766  1.00 11.63           C
ATOM    874  CZ  TYR   102     -42.610  23.511  -4.376  1.00 11.76           C
ATOM    875  OH  TYR   102     -43.341  22.459  -4.924  1.00 11.14           O
ATOM    876  CE2 TYR   102     -41.192  23.459  -4.417  1.00  9.45           C
ATOM    877  CD2 TYR   102     -40.447  24.510  -3.827  1.00 10.19           C
ATOM    878  C   TYR   102     -41.394  28.796  -3.351  1.00  8.00           C
ATOM    879  O   TYR   102     -41.879  29.032  -4.458  1.00  9.22           O
ATOM    880  N   THR   103     -41.935  29.239  -2.212  1.00  8.23           N
ATOM    881  CA  THR   103     -43.186  30.012  -2.256  1.00  8.10           C
ATOM    882  CB  THR   103     -43.885  30.125  -0.875  1.00  7.33           C
ATOM    883  OG1 THR   103     -43.012  30.781   0.056  1.00  8.06           O
ATOM    884  CG2 THR   103     -44.249  28.714  -0.376  1.00  8.46           C
ATOM    885  C   THR   103     -43.009  31.397  -2.842  1.00  8.57           C
ATOM    886  O   THR   103     -43.909  31.869  -3.557  1.00  9.60           O
ATOM    887  N   SER   104     -41.877  32.052  -2.541  1.00  9.12           N
ATOM    888  CA  SER   104     -41.655  33.400  -3.043  1.00  9.88           C
ATOM    889  CB  SER   104     -40.363  34.009  -2.477  1.00  9.85           C
ATOM    890  OG  SER   104     -40.234  35.352  -2.971  1.00 12.21           O
ATOM    891  C   SER   104     -41.601  33.357  -4.584  1.00 10.66           C
ATOM    892  O   SER   104     -42.219  34.183  -5.265  1.00 10.59           O
ATOM    893  N   GLU   105     -40.865  32.392  -5.125  1.00  8.72           N
ATOM    894  CA  GLU   105     -40.817  32.289  -6.613  1.00  9.18           C
ATOM    895  CB  GLU   105     -39.731  31.293  -7.041  1.00  7.45           C
ATOM    896  CG  GLU   105     -38.332  31.924  -6.972  1.00  8.14           C
ATOM    897  CD  GLU   105     -38.036  32.910  -8.131  1.00 10.19           C
ATOM    898  OE1 GLU   105     -38.853  33.093  -9.071  1.00  9.04           O
ATOM    899  OE2 GLU   105     -36.931  33.505  -8.111  1.00 13.04           O
ATOM    900  C   GLU   105     -42.165  31.935  -7.261  1.00  9.12           C
ATOM    901  O   GLU   105     -42.538  32.491  -8.300  1.00  9.81           O
ATOM    902  N   LEU   106     -42.941  31.042  -6.632  1.00  8.79           N
ATOM    903  CA  LEU   106     -44.237  30.680  -7.191  1.00  9.03           C
ATOM    904  CB  LEU   106     -44.849  29.471  -6.457  1.00  8.32           C
ATOM    905  CG  LEU   106     -44.211  28.130  -6.911  1.00  9.60           C
ATOM    906  CD1 LEU   106     -44.576  27.033  -5.828  1.00  9.04           C
ATOM    907  CD2 LEU   106     -44.754  27.786  -8.296  1.00  9.22           C
ATOM    908  C   LEU   106     -45.238  31.834  -7.135  1.00  9.88           C
ATOM    909  O   LEU   106     -46.147  31.887  -7.972  1.00 10.21           O
ATOM    910  N   THR   107     -45.102  32.717  -6.136  1.00  9.52           N
ATOM    911  CA  THR   107     -46.030  33.832  -5.986  1.00  9.75           C
ATOM    912  CB  THR   107     -46.510  33.990  -4.516  1.00  9.09           C
ATOM    913  OG1 THR   107     -45.388  34.319  -3.693  1.00 10.50           O
ATOM    914  CG2 THR   107     -47.185  32.718  -4.076  1.00 10.05           C
ATOM    915  C   THR   107     -45.544  35.182  -6.484  1.00  9.81           C
ATOM    916  O   THR   107     -46.371  36.081  -6.704  1.00 12.25           O
ATOM    917  N   ASN   108     -44.232  35.363  -6.633  0.50  9.70           N
ATOM    919  CA  ASN   108     -43.617  36.625  -7.105  0.50  9.59           C
ATOM    921  CB  ASN   108     -43.154  37.511  -5.932  0.50  9.99           C
ATOM    923  CG  ASN   108     -44.278  38.322  -5.314  0.50  8.07           C
ATOM    925  OD1 ASN   108     -44.577  38.166  -4.138  0.50 11.45           O
ATOM    927  ND2 ASN   108     -44.931  39.160  -6.116  0.50  6.17           N
ATOM    929  C   ASN   108     -42.392  36.215  -7.909  0.50  9.86           C
ATOM    931  O   ASN   108     -41.262  36.429  -7.469  0.50  9.46           O
ATOM    933  N   PRO   109     -42.611  35.593  -9.087  1.00  9.87           N
ATOM    934  CA  PRO   109     -41.482  34.997  -9.847  1.00  9.20           C
ATOM    935  CB  PRO   109     -42.170  34.338 -11.060  1.00  9.29           C
ATOM    936  CG  PRO   109     -43.456  35.217 -11.249  1.00 11.47           C
ATOM    937  CD  PRO   109     -43.900  35.416  -9.770  1.00 10.72           C
ATOM    938  C   PRO   109     -40.455  36.039 -10.322  1.00  9.60           C
ATOM    939  O   PRO   109     -40.811  37.205 -10.612  1.00 11.09           O
ATOM    940  N   THR   110     -39.210  35.615 -10.382  1.00  9.05           N
ATOM    941  CA  THR   110     -38.133  36.378 -11.039  1.00  9.32           C
ATOM    942  CB  THR   110     -36.862  36.356 -10.160  1.00 10.57           C
ATOM    943  OG1 THR   110     -36.330  35.035 -10.130  1.00  9.30           O
ATOM    944  CG2 THR   110     -37.147  36.832  -8.744  1.00 13.98           C
ATOM    945  C   THR   110     -37.799  35.644 -12.327  1.00  8.94           C
ATOM    946  O   THR   110     -38.429  34.643 -12.626  1.00  8.35           O
ATOM    947  N   PRO   111     -36.818  36.119 -13.123  1.00  9.83           N
ATOM    948  CA  PRO   111     -36.366  35.317 -14.286  1.00 11.52           C
ATOM    949  CB  PRO   111     -35.231  36.183 -14.892  1.00 11.75           C
ATOM    950  CG  PRO   111     -35.579  37.539 -14.489  1.00 11.98           C
ATOM    951  CD  PRO   111     -36.150  37.430 -13.076  1.00 10.83           C
ATOM    952  C   PRO   111     -35.863  33.915 -13.908  1.00 12.86           C
ATOM    953  O   PRO   111     -35.889  32.963 -14.744  1.00 13.75           O
ATOM    954  N   CYS   112     -35.461  33.730 -12.660  1.00 11.46           N
ATOM    955  CA  CYS   112     -35.067  32.401 -12.254  1.00 13.19           C
ATOM    956  CB  CYS   112     -34.230  32.442 -10.978  1.00 14.56           C
ATOM    957  SG  CYS   112     -32.686  33.333 -11.290  1.00 18.40           S
ATOM    958  C   CYS   112     -36.251  31.432 -12.108  1.00 12.18           C
ATOM    959  O   CYS   112     -36.048  30.232 -11.974  1.00 13.79           O
ATOM    960  N   PHE   113     -37.501  31.926 -12.121  1.00 11.58           N
ATOM    961  CA  PHE   113     -38.605  30.987 -11.961  1.00 10.29           C
ATOM    962  CB  PHE   113     -39.921  31.711 -11.869  1.00 10.73           C
ATOM    963  CG  PHE   113     -41.068  30.776 -11.807  1.00 10.75           C
ATOM    964  CD1 PHE   113     -41.318  30.025 -10.649  1.00 13.13           C
ATOM    965  CE1 PHE   113     -42.390  29.092 -10.649  1.00 14.20           C
ATOM    966  CZ  PHE   113     -43.135  28.878 -11.780  1.00 12.39           C
ATOM    967  CE2 PHE   113     -42.909  29.606 -12.931  1.00 14.70           C
ATOM    968  CD2 PHE   113     -41.824  30.539 -12.957  1.00 11.87           C
ATOM    969  C   PHE   113     -38.634  30.035 -13.180  1.00  9.81           C
ATOM    970  O   PHE   113     -38.642  28.807 -13.017  1.00  9.92           O
ATOM    971  N   ALA   114     -38.644  30.592 -14.383  1.00  9.60           N
ATOM    972  CA  ALA   114     -38.711  29.716 -15.565  1.00  9.88           C
ATOM    973  CB  ALA   114     -38.980  30.528 -16.837  1.00  9.97           C
ATOM    974  C   ALA   114     -37.461  28.865 -15.730  1.00 10.92           C
ATOM    975  O   ALA   114     -37.548  27.764 -16.247  1.00 11.21           O
ATOM    976  N   ALA   115     -36.301  29.407 -15.342  1.00 10.45           N
ATOM    977  CA  ALA   115     -35.020  28.733 -15.554  1.00 11.81           C
ATOM    978  CB  ALA   115     -33.882  29.767 -15.520  1.00 12.14           C
ATOM    979  C   ALA   115     -34.750  27.588 -14.574  1.00 11.95           C
ATOM    980  O   ALA   115     -34.178  26.555 -14.951  1.00 12.70           O
ATOM    981  N   ILE   116     -35.186  27.750 -13.331  1.00 11.04           N
ATOM    982  CA  ILE   116     -34.783  26.848 -12.255  1.00 11.69           C
ATOM    983  CB  ILE   116     -33.872  27.616 -11.214  1.00 10.98           C
ATOM    984  CG1 ILE   116     -32.584  28.106 -11.900  1.00 13.37           C
ATOM    985  CD1 ILE   116     -31.751  29.071 -11.039  1.00 12.57           C
ATOM    986  CG2 ILE   116     -33.568  26.724  -9.962  1.00 12.49           C
ATOM    987  C   ILE   116     -35.998  26.242 -11.560  1.00 11.29           C
ATOM    988  O   ILE   116     -36.092  25.007 -11.384  1.00 10.24           O
ATOM    989  N   VAL   117     -36.919  27.089 -11.131  1.00 10.95           N
ATOM    990  CA  VAL   117     -37.977  26.588 -10.206  1.00 10.57           C
ATOM    991  CB  VAL   117     -38.617  27.751  -9.409  1.00 11.02           C
ATOM    992  CG1 VAL   117     -39.795  27.207  -8.454  1.00 10.64           C
ATOM    993  CG2 VAL   117     -37.512  28.443  -8.627  1.00 10.50           C
ATOM    994  C   VAL   117     -39.038  25.771 -10.946  1.00 11.77           C
ATOM    995  O   VAL   117     -39.425  24.648 -10.524  1.00 11.14           O
ATOM    996  N   SER   118     -39.530  26.315 -12.046  1.00 10.59           N
ATOM    997  CA  SER   118     -40.620  25.684 -12.764  1.00 12.47           C
ATOM    998  CB  SER   118     -41.105  26.636 -13.868  1.00 13.39           C
ATOM    999  OG  SER   118     -42.255  26.127 -14.471  1.00 14.41           O
ATOM   1000  C   SER   118     -40.234  24.283 -13.285  1.00 11.92           C
ATOM   1001  O   SER   118     -40.958  23.318 -13.010  1.00 12.39           O
ATOM   1002  N   PRO   119     -39.094  24.138 -13.988  1.00 12.64           N
ATOM   1003  CA  PRO   119     -38.727  22.800 -14.461  1.00 11.77           C
ATOM   1004  CB  PRO   119     -37.448  23.016 -15.304  1.00 12.21           C
ATOM   1005  CG  PRO   119     -36.981  24.375 -14.981  1.00 12.76           C
ATOM   1006  CD  PRO   119     -38.161  25.180 -14.467  1.00 11.90           C
ATOM   1007  C   PRO   119     -38.487  21.799 -13.296  1.00 11.38           C
ATOM   1008  O   PRO   119     -38.822  20.622 -13.450  1.00 11.44           O
ATOM   1009  N   ALA   120     -37.965  22.276 -12.162  1.00 10.79           N
ATOM   1010  CA  ALA   120     -37.680  21.404 -10.992  1.00  9.96           C
ATOM   1011  CB  ALA   120     -36.955  22.202  -9.916  1.00 10.33           C
ATOM   1012  C   ALA   120     -38.996  20.843 -10.478  1.00 11.25           C
ATOM   1013  O   ALA   120     -39.179  19.606 -10.381  1.00 11.32           O
ATOM   1014  N   ILE   121     -39.972  21.731 -10.240  1.00  9.92           N
ATOM   1015  CA  ILE   121     -41.278  21.275  -9.739  1.00 10.42           C
ATOM   1016  CB  ILE   121     -42.191  22.482  -9.354  1.00  9.91           C
ATOM   1017  CG1 ILE   121     -41.576  23.223  -8.147  1.00 11.53           C
ATOM   1018  CD1 ILE   121     -42.273  24.600  -7.882  1.00 11.61           C
ATOM   1019  CG2 ILE   121     -43.657  22.039  -9.082  1.00 11.13           C
ATOM   1020  C   ILE   121     -41.980  20.382 -10.790  1.00 10.00           C
ATOM   1021  O   ILE   121     -42.496  19.302 -10.444  1.00 10.24           O
ATOM   1022  N   ALA   122     -41.999  20.822 -12.047  1.00 10.30           N
ATOM   1023  CA  ALA   122     -42.680  20.050 -13.108  1.00 11.54           C
ATOM   1024  CB  ALA   122     -42.598  20.755 -14.509  1.00 12.24           C
ATOM   1025  C   ALA   122     -42.094  18.638 -13.234  1.00 11.86           C
ATOM   1026  O   ALA   122     -42.845  17.702 -13.488  1.00 12.38           O
ATOM   1027  N   SER   123     -40.780  18.499 -13.132  1.00 11.72           N
ATOM   1028  CA  SER   123     -40.140  17.174 -13.297  1.00 11.69           C
ATOM   1029  CB  SER   123     -38.597  17.220 -13.248  1.00 13.37           C
ATOM   1030  OG  SER   123     -38.136  17.620 -11.957  1.00 18.01           O
ATOM   1031  C   SER   123     -40.678  16.217 -12.222  1.00 11.56           C
ATOM   1032  O   SER   123     -40.889  15.041 -12.504  1.00 11.30           O
ATOM   1033  N   VAL   124     -40.862  16.719 -10.996  1.00 10.19           N
ATOM   1034  CA  VAL   124     -41.338  15.876  -9.883  1.00  9.66           C
ATOM   1035  CB  VAL   124     -41.121  16.603  -8.497  1.00 10.39           C
ATOM   1036  CG1 VAL   124     -41.817  15.860  -7.384  1.00 13.37           C
ATOM   1037  CG2 VAL   124     -39.640  16.694  -8.191  1.00 12.44           C
ATOM   1038  C   VAL   124     -42.808  15.523 -10.075  1.00 10.08           C
ATOM   1039  O   VAL   124     -43.218  14.350  -9.905  1.00  9.51           O
ATOM   1040  N   ILE   125     -43.617  16.526 -10.409  1.00  9.88           N
ATOM   1041  CA  ILE   125     -45.046  16.301 -10.630  1.00 10.74           C
ATOM   1042  CB  ILE   125     -45.803  17.624 -10.870  1.00 11.75           C
ATOM   1043  CG1 ILE   125     -45.744  18.498  -9.590  1.00  9.55           C
ATOM   1044  CD1 ILE   125     -46.274  17.830  -8.232  1.00 11.11           C
ATOM   1045  CG2 ILE   125     -47.298  17.363 -11.280  1.00 10.72           C
ATOM   1046  C   ILE   125     -45.254  15.309 -11.757  1.00 10.24           C
ATOM   1047  O   ILE   125     -46.088  14.386 -11.644  1.00 10.73           O
ATOM   1048  N   ARG   126     -44.483  15.459 -12.837  0.50 10.47           N
ATOM   1050  CA  ARG   126     -44.567  14.514 -13.947  0.50  9.91           C
ATOM   1052  CB  ARG   126     -43.607  14.907 -15.078  0.50  9.78           C
ATOM   1054  CG  ARG   126     -44.070  16.073 -15.874  0.50  8.97           C
ATOM   1056  CD  ARG   126     -43.145  16.305 -17.083  0.50 11.78           C
ATOM   1058  NE  ARG   126     -43.524  17.541 -17.757  0.50 13.41           N
ATOM   1060  CZ  ARG   126     -42.784  18.643 -17.773  0.50 18.19           C
ATOM   1062  NH1 ARG   126     -41.594  18.649 -17.187  0.50 18.32           N
ATOM   1064  NH2 ARG   126     -43.223  19.729 -18.401  0.50 20.28           N
ATOM   1066  C   ARG   126     -44.269  13.104 -13.483  0.50 10.39           C
ATOM   1068  O   ARG   126     -45.010  12.161 -13.806  0.50 11.26           O
ATOM   1070  N   LEU   127     -43.191  12.959 -12.717  1.00 10.18           N
ATOM   1071  CA  LEU   127     -42.747  11.653 -12.281  1.00 11.49           C
ATOM   1072  CB  LEU   127     -41.457  11.792 -11.470  1.00 12.45           C
ATOM   1073  CG  LEU   127     -40.836  10.551 -10.872  1.00 15.70           C
ATOM   1074  CD1 LEU   127     -40.489   9.503 -11.921  1.00 20.81           C
ATOM   1075  CD2 LEU   127     -39.573  10.988 -10.121  1.00 18.67           C
ATOM   1076  C   LEU   127     -43.864  10.955 -11.482  1.00  9.91           C
ATOM   1077  O   LEU   127     -44.173   9.757 -11.684  1.00 10.50           O
ATOM   1078  N   LEU   128     -44.458  11.703 -10.559  1.00  8.79           N
ATOM   1079  CA  LEU   128     -45.555  11.167  -9.751  1.00  9.28           C
ATOM   1080  CB  LEU   128     -45.959  12.213  -8.701  1.00  9.38           C
ATOM   1081  CG  LEU   128     -44.895  12.460  -7.628  1.00 11.13           C
ATOM   1082  CD1 LEU   128     -45.399  13.599  -6.743  1.00 11.82           C
ATOM   1083  CD2 LEU   128     -44.635  11.243  -6.755  1.00 13.49           C
ATOM   1084  C   LEU   128     -46.755  10.814 -10.630  1.00 10.57           C
ATOM   1085  O   LEU   128     -47.393   9.762 -10.464  1.00  8.87           O
ATOM   1086  N   ALA   129     -47.111  11.725 -11.531  1.00  9.99           N
ATOM   1087  CA  ALA   129     -48.264  11.513 -12.419  1.00 10.43           C
ATOM   1088  CB  ALA   129     -48.466  12.756 -13.298  1.00 10.04           C
ATOM   1089  C   ALA   129     -48.072  10.270 -13.290  1.00  9.53           C
ATOM   1090  O   ALA   129     -49.010   9.490 -13.509  1.00  9.22           O
ATOM   1091  N   GLU   130     -46.842  10.075 -13.777  1.00 10.54           N
ATOM   1092  CA  GLU   130     -46.555   8.883 -14.586  1.00 10.65           C
ATOM   1093  CB  GLU   130     -45.130   8.957 -15.080  1.00 11.71           C
ATOM   1094  CG  GLU   130     -45.015   9.922 -16.236  1.00 15.98           C
ATOM   1095  CD  GLU   130     -43.548  10.268 -16.577  1.00 25.12           C
ATOM   1096  OE1 GLU   130     -42.602   9.684 -15.991  1.00 26.80           O
ATOM   1097  OE2 GLU   130     -43.362  11.157 -17.432  1.00 30.61           O
ATOM   1098  C   GLU   130     -46.799   7.589 -13.828  1.00 10.74           C
ATOM   1099  O   GLU   130     -47.364   6.626 -14.382  1.00  9.75           O
ATOM   1100  N   SER   131     -46.395   7.580 -12.558  0.50 10.14           N
ATOM   1102  CA  SER   131     -46.583   6.411 -11.722  0.50 10.49           C
ATOM   1104  CB  SER   131     -45.843   6.578 -10.396  0.50 11.10           C
ATOM   1106  OG  SER   131     -45.705   5.328  -9.775  0.50 10.69           O
ATOM   1108  C   SER   131     -48.057   6.142 -11.458  0.50 10.47           C
ATOM   1110  O   SER   131     -48.497   4.991 -11.474  0.50  9.95           O
ATOM   1112  N   ILE   132     -48.806   7.214 -11.186  1.00  9.30           N
ATOM   1113  CA  ILE   132     -50.274   7.155 -11.007  1.00 10.27           C
ATOM   1114  CB  ILE   132     -50.819   8.528 -10.573  1.00 10.43           C
ATOM   1115  CG1 ILE   132     -50.217   8.879  -9.199  1.00 10.19           C
ATOM   1116  CD1 ILE   132     -50.537  10.321  -8.694  1.00 10.55           C
ATOM   1117  CG2 ILE   132     -52.352   8.522 -10.544  1.00 12.86           C
ATOM   1118  C   ILE   132     -50.956   6.643 -12.274  1.00 10.09           C
ATOM   1119  O   ILE   132     -51.855   5.784 -12.188  1.00  9.47           O
ATOM   1120  N   GLU   133     -50.535   7.164 -13.426  0.50 10.08           N
ATOM   1122  CA  GLU   133     -51.024   6.713 -14.732  0.50 10.68           C
ATOM   1124  CB  GLU   133     -50.390   7.549 -15.871  0.50 10.91           C
ATOM   1126  CG  GLU   133     -51.050   8.940 -16.009  0.50 12.45           C
ATOM   1128  CD  GLU   133     -50.193  10.029 -16.674  0.50 14.41           C
ATOM   1130  OE1 GLU   133     -48.998   9.781 -16.983  0.50 17.78           O
ATOM   1132  OE2 GLU   133     -50.748  11.144 -16.892  0.50 18.07           O
ATOM   1134  C   GLU   133     -50.823   5.208 -14.941  0.50  9.88           C
ATOM   1136  O   GLU   133     -51.712   4.518 -15.430  0.50 10.09           O
ATOM   1138  N   ALA   134     -49.659   4.695 -14.546  1.00  9.31           N
ATOM   1139  CA  ALA   134     -49.346   3.267 -14.674  1.00  9.01           C
ATOM   1140  CB  ALA   134     -47.869   3.011 -14.361  1.00  9.38           C
ATOM   1141  C   ALA   134     -50.237   2.445 -13.765  1.00  9.17           C
ATOM   1142  O   ALA   134     -50.720   1.372 -14.144  1.00  9.07           O
ATOM   1143  N   GLY   135     -50.446   2.954 -12.554  1.00  9.74           N
ATOM   1144  CA  GLY   135     -51.304   2.264 -11.598  1.00  9.68           C
ATOM   1145  C   GLY   135     -52.748   2.231 -12.081  1.00 10.54           C
ATOM   1146  O   GLY   135     -53.432   1.261 -11.841  1.00 11.18           O
ATOM   1147  N   MET   136     -53.212   3.294 -12.736  1.00 10.78           N
ATOM   1148  CA  MET   136     -54.550   3.319 -13.316  1.00 14.00           C
ATOM   1149  CB  MET   136     -54.856   4.709 -13.853  1.00 12.19           C
ATOM   1150  CG  MET   136     -55.025   5.738 -12.769  1.00 17.50           C
ATOM   1151  SD  MET   136     -55.390   7.532 -13.517  0.80 27.77          SE
ATOM   1152  CE  MET   136     -56.956   7.128 -14.509  1.00 24.50           C
ATOM   1153  C   MET   136     -54.690   2.274 -14.426  1.00 11.62           C
ATOM   1154  O   MET   136     -55.630   1.461 -14.414  1.00 11.88           O
ATOM   1155  N   THR   137     -53.704   2.228 -15.331  1.00 10.74           N
ATOM   1156  CA  THR   137     -53.673   1.197 -16.405  1.00  9.88           C
ATOM   1157  CB  THR   137     -52.401   1.371 -17.285  1.00  9.89           C
ATOM   1158  OG1 THR   137     -52.434   2.676 -17.872  1.00 11.23           O
ATOM   1159  CG2 THR   137     -52.311   0.289 -18.374  1.00 10.49           C
ATOM   1160  C   THR   137     -53.735  -0.220 -15.824  1.00  9.70           C
ATOM   1161  O   THR   137     -54.451  -1.096 -16.313  1.00  8.79           O
ATOM   1162  N   ARG   138     -53.012  -0.433 -14.737  1.00 10.06           N
ATOM   1163  CA  ARG   138     -52.962  -1.726 -14.092  1.00 10.50           C
ATOM   1164  CB  ARG   138     -51.753  -1.827 -13.178  1.00 10.22           C
ATOM   1165  CG  ARG   138     -50.421  -1.961 -13.926  1.00 11.00           C
ATOM   1166  CD  ARG   138     -49.267  -1.783 -12.921  1.00 11.40           C
ATOM   1167  NE  ARG   138     -49.385  -2.776 -11.860  1.00 13.48           N
ATOM   1168  CZ  ARG   138     -48.694  -2.749 -10.731  1.00 16.65           C
ATOM   1169  NH1 ARG   138     -47.798  -1.778 -10.519  1.00 13.97           N
ATOM   1170  NH2 ARG   138     -48.909  -3.699  -9.812  1.00 18.04           N
ATOM   1171  C   ARG   138     -54.233  -2.088 -13.308  1.00 11.15           C
ATOM   1172  O   ARG   138     -54.391  -3.238 -12.908  1.00 11.80           O
ATOM   1173  N   GLY   139     -55.117  -1.122 -13.103  1.00 12.43           N
ATOM   1174  CA  GLY   139     -56.308  -1.342 -12.309  1.00 12.85           C
ATOM   1175  C   GLY   139     -56.098  -1.206 -10.803  1.00 14.77           C
ATOM   1176  O   GLY   139     -57.031  -1.500 -10.021  1.00 15.21           O
ATOM   1177  N   LEU   140     -54.904  -0.785 -10.370  1.00 14.40           N
ATOM   1178  CA  LEU   140     -54.663  -0.525  -8.930  1.00 15.70           C
ATOM   1179  CB  LEU   140     -53.175  -0.325  -8.608  1.00 17.02           C
ATOM   1180  CG  LEU   140     -52.165  -1.407  -8.937  1.00 20.06           C
ATOM   1181  CD1 LEU   140     -50.855  -0.921  -8.327  1.00 24.89           C
ATOM   1182  CD2 LEU   140     -52.585  -2.711  -8.319  1.00 24.25           C
ATOM   1183  C   LEU   140     -55.356   0.744  -8.489  1.00 14.92           C
ATOM   1184  O   LEU   140     -55.818   0.834  -7.342  1.00 14.43           O
ATOM   1185  N   PHE   141     -55.378   1.734  -9.384  1.00 13.97           N
ATOM   1186  CA  PHE   141     -55.934   3.051  -9.092  1.00 15.04           C
ATOM   1187  CB  PHE   141     -54.894   4.159  -9.339  1.00 13.91           C
ATOM   1188  CG  PHE   141     -53.627   4.016  -8.510  1.00 13.77           C
ATOM   1189  CD1 PHE   141     -53.668   3.442  -7.227  1.00 13.85           C
ATOM   1190  CE1 PHE   141     -52.491   3.310  -6.463  1.00 13.85           C
ATOM   1191  CZ  PHE   141     -51.267   3.776  -7.000  1.00 12.20           C
ATOM   1192  CE2 PHE   141     -51.240   4.341  -8.294  1.00 10.44           C
ATOM   1193  CD2 PHE   141     -52.392   4.479  -9.011  1.00 12.75           C
ATOM   1194  C   PHE   141     -57.151   3.307  -9.951  1.00 15.74           C
ATOM   1195  O   PHE   141     -57.249   2.777 -11.067  1.00 14.26           O
ATOM   1196  N   ARG   142     -58.074   4.120  -9.443  0.50 16.15           N
ATOM   1198  CA  ARG   142     -59.333   4.428 -10.124  0.50 17.47           C
ATOM   1200  CB  ARG   142     -60.256   5.250  -9.227  0.50 17.67           C
ATOM   1202  CG  ARG   142     -60.907   4.514  -8.115  0.50 18.73           C
ATOM   1204  CD  ARG   142     -61.871   5.446  -7.428  0.50 20.28           C
ATOM   1206  NE  ARG   142     -61.191   6.543  -6.744  0.50 20.28           N
ATOM   1208  CZ  ARG   142     -61.802   7.632  -6.287  0.50 20.99           C
ATOM   1210  NH1 ARG   142     -63.104   7.797  -6.474  0.50 17.88           N
ATOM   1212  NH2 ARG   142     -61.099   8.580  -5.668  0.50 20.92           N
ATOM   1214  C   ARG   142     -59.126   5.255 -11.374  0.50 17.70           C
ATOM   1216  O   ARG   142     -58.339   6.198 -11.388  0.50 18.50           O
ATOM   1218  N   ARG   143     -59.912   4.938 -12.395  1.00 18.41           N
ATOM   1219  CA  ARG   143     -59.747   5.554 -13.691  1.00 19.17           C
ATOM   1220  CB  ARG   143     -60.007   4.550 -14.785  1.00 19.39           C
ATOM   1221  CG  ARG   143     -58.965   3.434 -14.827  1.00 22.29           C
ATOM   1222  CD  ARG   143     -59.450   2.272 -15.677  1.00 26.49           C
ATOM   1223  NE  ARG   143     -58.403   1.273 -15.895  1.00 30.12           N
ATOM   1224  CZ  ARG   143     -58.545  -0.047 -15.757  1.00 31.21           C
ATOM   1225  NH1 ARG   143     -59.715  -0.594 -15.415  1.00 32.67           N
ATOM   1226  NH2 ARG   143     -57.502  -0.838 -15.984  1.00 31.42           N
ATOM   1227  C   ARG   143     -60.507   6.857 -13.893  1.00 18.83           C
ATOM   1228  O   ARG   143     -60.315   7.510 -14.913  1.00 20.12           O
ATOM   1229  N   ASP   144     -61.324   7.254 -12.917  1.00 17.76           N
ATOM   1230  CA  ASP   144     -62.025   8.547 -12.977  1.00 16.37           C
ATOM   1231  CB  ASP   144     -63.426   8.450 -12.354  1.00 16.63           C
ATOM   1232  CG  ASP   144     -63.395   8.116 -10.877  1.00 17.52           C
ATOM   1233  OD1 ASP   144     -62.398   7.530 -10.424  1.00 17.03           O
ATOM   1234  OD2 ASP   144     -64.383   8.426 -10.159  1.00 20.81           O
ATOM   1235  C   ASP   144     -61.281   9.716 -12.339  1.00 15.58           C
ATOM   1236  O   ASP   144     -61.871  10.803 -12.135  1.00 16.22           O
ATOM   1237  N   LEU   145     -60.024   9.520 -11.954  0.50 14.65           N
ATOM   1239  CA  LEU   145     -59.257  10.650 -11.435  0.50 13.62           C
ATOM   1241  CB  LEU   145     -58.748  10.426 -10.005  0.50 13.58           C
ATOM   1243  CG  LEU   145     -59.708  10.249  -8.827  0.50 13.00           C
ATOM   1245  CD1 LEU   145     -58.863   9.721  -7.686  0.50 13.60           C
ATOM   1247  CD2 LEU   145     -60.478  11.539  -8.398  0.50 13.09           C
ATOM   1249  C   LEU   145     -58.106  10.962 -12.376  0.50 13.00           C
ATOM   1251  O   LEU   145     -57.581  10.079 -13.050  0.50 12.96           O
ATOM   1253  N   HIS   146     -57.762  12.235 -12.428  1.00 12.38           N
ATOM   1254  CA  HIS   146     -56.767  12.749 -13.335  1.00 11.72           C
ATOM   1255  CB  HIS   146     -57.099  14.174 -13.754  1.00 13.12           C
ATOM   1256  CG  HIS   146     -58.088  14.223 -14.890  1.00 18.87           C
ATOM   1257  ND1 HIS   146     -59.407  14.593 -14.717  1.00 23.34           N
ATOM   1258  CE1 HIS   146     -60.041  14.495 -15.875  1.00 23.61           C
ATOM   1259  NE2 HIS   146     -59.189  14.056 -16.787  1.00 22.78           N
ATOM   1260  CD2 HIS   146     -57.966  13.859 -16.194  1.00 21.18           C
ATOM   1261  C   HIS   146     -55.432  12.632 -12.658  1.00  9.97           C
ATOM   1262  O   HIS   146     -55.283  13.064 -11.523  1.00  8.48           O
ATOM   1263  N   ALA   147     -54.466  12.063 -13.380  1.00  8.06           N
ATOM   1264  CA  ALA   147     -53.171  11.743 -12.792  1.00  7.43           C
ATOM   1265  CB  ALA   147     -52.303  10.976 -13.795  1.00  7.64           C
ATOM   1266  C   ALA   147     -52.415  12.975 -12.255  1.00  7.37           C
ATOM   1267  O   ALA   147     -51.892  12.935 -11.149  1.00  7.42           O
ATOM   1268  N   VAL   148     -52.323  14.040 -13.057  1.00  5.91           N
ATOM   1269  CA  VAL   148     -51.580  15.234 -12.596  1.00  5.28           C
ATOM   1270  CB  VAL   148     -51.376  16.285 -13.741  1.00  5.29           C
ATOM   1271  CG1 VAL   148     -50.894  17.623 -13.160  1.00  5.38           C
ATOM   1272  CG2 VAL   148     -50.385  15.716 -14.827  1.00  7.18           C
ATOM   1273  C   VAL   148     -52.285  15.874 -11.417  1.00  5.21           C
ATOM   1274  O   VAL   148     -51.641  16.225 -10.424  1.00  4.80           O
ATOM   1275  N   ASN   149     -53.605  16.034 -11.475  1.00  5.51           N
ATOM   1276  CA  ASN   149     -54.259  16.664 -10.322  1.00  5.65           C
ATOM   1277  CB  ASN   149     -55.765  16.822 -10.566  1.00  6.66           C
ATOM   1278  CG  ASN   149     -56.088  18.026 -11.409  1.00 10.17           C
ATOM   1279  OD1 ASN   149     -55.200  18.846 -11.725  1.00 12.80           O
ATOM   1280  ND2 ASN   149     -57.358  18.143 -11.798  1.00 12.10           N
ATOM   1281  C   ASN   149     -54.045  15.842  -9.043  1.00  6.11           C
ATOM   1282  O   ASN   149     -53.933  16.413  -7.953  1.00  4.78           O
ATOM   1283  N   SER   150     -53.988  14.513  -9.207  1.00  5.76           N
ATOM   1284  CA  SER   150     -53.748  13.564  -8.084  1.00  6.08           C
ATOM   1285  CB  SER   150     -54.027  12.096  -8.522  1.00  5.78           C
ATOM   1286  OG  SER   150     -55.422  11.927  -8.837  1.00  7.08           O
ATOM   1287  C   SER   150     -52.331  13.717  -7.550  1.00  5.66           C
ATOM   1288  O   SER   150     -52.119  13.810  -6.341  1.00  5.57           O
ATOM   1289  N   ALA   151     -51.349  13.768  -8.451  1.00  5.77           N
ATOM   1290  CA  ALA   151     -49.966  14.064  -8.076  1.00  5.41           C
ATOM   1291  CB  ALA   151     -49.086  14.156  -9.326  1.00  5.18           C
ATOM   1292  C   ALA   151     -49.874  15.386  -7.279  1.00  5.91           C
ATOM   1293  O   ALA   151     -49.179  15.466  -6.262  1.00  6.61           O
ATOM   1294  N   LEU   152     -50.552  16.425  -7.784  1.00  6.31           N
ATOM   1295  CA  LEU   152     -50.534  17.749  -7.110  1.00  5.72           C
ATOM   1296  CB  LEU   152     -51.297  18.807  -7.921  1.00  4.81           C
ATOM   1297  CG  LEU   152     -50.598  19.222  -9.218  1.00  4.27           C
ATOM   1298  CD1 LEU   152     -51.572  20.071 -10.072  1.00  6.58           C
ATOM   1299  CD2 LEU   152     -49.276  20.001  -8.973  1.00  5.18           C
ATOM   1300  C   LEU   152     -51.132  17.647  -5.707  1.00  7.70           C
ATOM   1301  O   LEU   152     -50.626  18.296  -4.766  1.00  7.69           O
ATOM   1302  N   ALA   153     -52.188  16.836  -5.551  1.00  6.37           N
ATOM   1303  CA  ALA   153     -52.794  16.600  -4.245  1.00  7.16           C
ATOM   1304  CB  ALA   153     -54.029  15.679  -4.378  1.00  5.65           C
ATOM   1305  C   ALA   153     -51.787  16.008  -3.247  1.00  7.42           C
ATOM   1306  O   ALA   153     -51.667  16.511  -2.117  1.00  6.88           O
ATOM   1307  N   LEU   154     -51.039  14.972  -3.683  1.00  5.98           N
ATOM   1308  CA  LEU   154     -50.031  14.354  -2.805  1.00  5.94           C
ATOM   1309  CB  LEU   154     -49.453  13.092  -3.458  1.00  6.06           C
ATOM   1310  CG  LEU   154     -48.400  12.364  -2.617  1.00  6.43           C
ATOM   1311  CD1 LEU   154     -48.990  11.876  -1.271  1.00  5.45           C
ATOM   1312  CD2 LEU   154     -47.790  11.240  -3.434  1.00  7.02           C
ATOM   1313  C   LEU   154     -48.921  15.373  -2.447  1.00  5.85           C
ATOM   1314  O   LEU   154     -48.530  15.518  -1.271  1.00  6.15           O
ATOM   1315  N   ALA   155     -48.449  16.084  -3.464  1.00  6.37           N
ATOM   1316  CA  ALA   155     -47.402  17.083  -3.242  1.00  6.90           C
ATOM   1317  CB  ALA   155     -46.984  17.689  -4.593  1.00  7.15           C
ATOM   1318  C   ALA   155     -47.927  18.147  -2.260  1.00  6.59           C
ATOM   1319  O   ALA   155     -47.181  18.625  -1.387  1.00  7.17           O
ATOM   1320  N   GLY   156     -49.204  18.510  -2.409  1.00  6.53           N
ATOM   1321  CA  GLY   156     -49.808  19.558  -1.574  1.00  7.23           C
ATOM   1322  C   GLY   156     -49.903  19.117  -0.129  1.00  8.33           C
ATOM   1323  O   GLY   156     -49.684  19.935   0.770  1.00  9.18           O
ATOM   1324  N   MET   157     -50.275  17.857   0.104  0.50  7.22           N
ATOM   1326  CA  MET   157     -50.394  17.342   1.473  0.50  9.40           C
ATOM   1328  CB  MET   157     -50.608  15.818   1.495  0.50  9.03           C
ATOM   1330  CG  MET   157     -51.950  15.368   1.037  0.50 10.44           C
ATOM   1332  SD  MET   157     -52.121  13.470   1.490  0.50 14.75          SE
ATOM   1334  CE  MET   157     -53.565  13.043   0.240  0.50 11.36           C
ATOM   1336  C   MET   157     -49.104  17.647   2.216  0.50  8.33           C
ATOM   1338  O   MET   157     -49.097  18.375   3.226  0.50  7.60           O
ATOM   1340  N   VAL   158     -48.020  17.067   1.700  1.00  7.62           N
ATOM   1341  CA  VAL   158     -46.738  17.073   2.389  1.00  7.60           C
ATOM   1342  CB  VAL   158     -45.769  16.001   1.870  1.00  7.87           C
ATOM   1343  CG1 VAL   158     -45.363  16.267   0.375  1.00  6.80           C
ATOM   1344  CG2 VAL   158     -44.556  15.904   2.800  1.00  5.50           C
ATOM   1345  C   VAL   158     -46.161  18.504   2.448  1.00  8.05           C
ATOM   1346  O   VAL   158     -45.655  18.951   3.498  1.00  7.94           O
ATOM   1347  N   ASN   159     -46.268  19.258   1.359  1.00  6.99           N
ATOM   1348  CA  ASN   159     -45.679  20.596   1.364  1.00  8.56           C
ATOM   1349  CB  ASN   159     -45.517  21.063  -0.110  1.00  9.44           C
ATOM   1350  CG  ASN   159     -44.267  20.391  -0.770  1.00 13.46           C
ATOM   1351  OD1 ASN   159     -43.115  20.774  -0.449  1.00 13.49           O
ATOM   1352  ND2 ASN   159     -44.491  19.365  -1.676  1.00 11.04           N
ATOM   1353  C   ASN   159     -46.491  21.532   2.299  1.00  8.55           C
ATOM   1354  O   ASN   159     -45.898  22.350   3.007  1.00  8.77           O
ATOM   1355  N   TYR   160     -47.807  21.324   2.393  1.00  8.99           N
ATOM   1356  CA  TYR   160     -48.598  22.206   3.289  1.00  8.46           C
ATOM   1357  CB  TYR   160     -50.076  22.031   3.041  1.00  9.05           C
ATOM   1358  CG  TYR   160     -50.895  23.089   3.758  1.00  6.76           C
ATOM   1359  CD1 TYR   160     -51.004  24.373   3.254  1.00  6.16           C
ATOM   1360  CE1 TYR   160     -51.755  25.374   3.951  1.00  6.68           C
ATOM   1361  CZ  TYR   160     -52.367  25.032   5.159  1.00  6.05           C
ATOM   1362  OH  TYR   160     -53.125  25.927   5.884  1.00  6.88           O
ATOM   1363  CE2 TYR   160     -52.260  23.729   5.663  1.00  7.56           C
ATOM   1364  CD2 TYR   160     -51.513  22.779   4.968  1.00  8.31           C
ATOM   1365  C   TYR   160     -48.297  21.873   4.749  1.00  8.41           C
ATOM   1366  O   TYR   160     -48.341  22.775   5.600  1.00  7.66           O
ATOM   1367  N   PHE   161     -48.025  20.596   5.064  1.00  7.26           N
ATOM   1368  CA  PHE   161     -47.662  20.273   6.467  1.00  7.86           C
ATOM   1369  CB  PHE   161     -47.311  18.790   6.604  1.00  7.74           C
ATOM   1370  CG  PHE   161     -46.983  18.392   7.998  1.00  9.30           C
ATOM   1371  CD1 PHE   161     -48.006  18.107   8.896  1.00 12.83           C
ATOM   1372  CE1 PHE   161     -47.720  17.697  10.215  1.00 11.42           C
ATOM   1373  CZ  PHE   161     -46.391  17.641  10.657  1.00 12.71           C
ATOM   1374  CE2 PHE   161     -45.357  17.968   9.769  1.00 10.83           C
ATOM   1375  CD2 PHE   161     -45.666  18.335   8.433  1.00 11.04           C
ATOM   1376  C   PHE   161     -46.491  21.148   6.954  1.00  7.95           C
ATOM   1377  O   PHE   161     -46.543  21.724   8.066  1.00  9.32           O
ATOM   1378  N   PHE   162     -45.463  21.301   6.114  1.00  6.72           N
ATOM   1379  CA  PHE   162     -44.318  22.124   6.507  1.00  7.65           C
ATOM   1380  CB  PHE   162     -43.078  21.726   5.710  1.00  7.99           C
ATOM   1381  CG  PHE   162     -42.566  20.366   6.105  1.00  9.27           C
ATOM   1382  CD1 PHE   162     -41.714  20.225   7.191  1.00 10.78           C
ATOM   1383  CE1 PHE   162     -41.239  18.956   7.593  1.00 11.91           C
ATOM   1384  CZ  PHE   162     -41.634  17.827   6.904  1.00 11.69           C
ATOM   1385  CE2 PHE   162     -42.511  17.965   5.784  1.00 13.79           C
ATOM   1386  CD2 PHE   162     -42.967  19.220   5.412  1.00 10.23           C
ATOM   1387  C   PHE   162     -44.639  23.608   6.400  1.00  6.36           C
ATOM   1388  O   PHE   162     -44.272  24.414   7.281  1.00  6.77           O
ATOM   1389  N   LEU   163     -45.339  23.986   5.329  1.00  6.53           N
ATOM   1390  CA  LEU   163     -45.685  25.410   5.150  1.00  6.76           C
ATOM   1391  CB  LEU   163     -46.531  25.576   3.876  1.00  6.66           C
ATOM   1392  CG  LEU   163     -46.960  27.017   3.573  1.00  7.04           C
ATOM   1393  CD1 LEU   163     -45.732  27.937   3.372  1.00  9.53           C
ATOM   1394  CD2 LEU   163     -47.878  27.026   2.294  1.00  8.47           C
ATOM   1395  C   LEU   163     -46.462  25.968   6.327  1.00  6.16           C
ATOM   1396  O   LEU   163     -46.251  27.132   6.716  1.00  6.46           O
ATOM   1397  N   SER   164     -47.398  25.156   6.872  1.00  5.30           N
ATOM   1398  CA  SER   164     -48.338  25.682   7.889  1.00  7.61           C
ATOM   1399  CB  SER   164     -49.657  24.912   7.802  1.00  8.19           C
ATOM   1400  OG  SER   164     -49.459  23.552   8.139  1.00  9.73           O
ATOM   1401  C   SER   164     -47.773  25.574   9.326  1.00  7.56           C
ATOM   1402  O   SER   164     -48.479  25.903  10.294  1.00  8.21           O
ATOM   1403  N   THR   165     -46.511  25.154   9.458  1.00  5.79           N
ATOM   1404  CA  THR   165     -45.964  24.822  10.782  1.00  6.26           C
ATOM   1405  CB  THR   165     -44.424  24.572  10.701  1.00  6.23           C
ATOM   1406  OG1 THR   165     -44.184  23.428   9.866  1.00  7.44           O
ATOM   1407  CG2 THR   165     -43.891  24.259  12.117  1.00  8.11           C
ATOM   1408  C   THR   165     -46.186  25.914  11.821  1.00  4.75           C
ATOM   1409  O   THR   165     -46.641  25.626  12.936  1.00  5.25           O
ATOM   1410  N   LEU   166     -45.844  27.165  11.481  1.00  5.75           N
ATOM   1411  CA  LEU   166     -45.911  28.235  12.482  1.00  6.51           C
ATOM   1412  CB  LEU   166     -45.339  29.576  11.965  1.00  6.68           C
ATOM   1413  CG  LEU   166     -43.841  29.678  11.719  1.00 10.81           C
ATOM   1414  CD1 LEU   166     -43.547  31.167  11.394  1.00 11.81           C
ATOM   1415  CD2 LEU   166     -43.055  29.293  13.016  1.00 11.69           C
ATOM   1416  C   LEU   166     -47.337  28.456  12.986  1.00  7.46           C
ATOM   1417  O   LEU   166     -47.491  28.973  14.095  1.00  8.56           O
ATOM   1418  N   ALA   167     -48.369  28.123  12.171  1.00  6.08           N
ATOM   1419  CA  ALA   167     -49.766  28.384  12.541  1.00  8.18           C
ATOM   1420  CB  ALA   167     -50.626  28.722  11.311  1.00  7.47           C
ATOM   1421  C   ALA   167     -50.387  27.203  13.251  1.00  8.91           C
ATOM   1422  O   ALA   167     -51.532  27.304  13.723  1.00  9.05           O
ATOM   1423  N   THR   168     -49.662  26.096  13.285  1.00  8.62           N
ATOM   1424  CA  THR   168     -50.264  24.857  13.794  1.00 10.98           C
ATOM   1425  CB  THR   168     -50.502  23.867  12.644  1.00  9.39           C
ATOM   1426  OG1 THR   168     -49.275  23.508  11.993  1.00 11.50           O
ATOM   1427  CG2 THR   168     -51.464  24.477  11.542  1.00  9.79           C
ATOM   1428  C   THR   168     -49.423  24.220  14.919  1.00 10.56           C
ATOM   1429  O   THR   168     -49.522  22.997  15.158  1.00 11.79           O
ATOM   1430  N   GLU   169     -48.671  25.069  15.639  1.00 13.47           N
ATOM   1431  CA  GLU   169     -47.634  24.567  16.568  1.00 14.51           C
ATOM   1432  CB  GLU   169     -46.793  25.705  17.190  1.00 15.58           C
ATOM   1433  CG  GLU   169     -45.950  26.533  16.217  1.00 16.67           C
ATOM   1434  CD  GLU   169     -44.641  25.858  15.769  1.00 18.06           C
ATOM   1435  OE1 GLU   169     -44.427  24.660  16.046  1.00 20.34           O
ATOM   1436  OE2 GLU   169     -43.824  26.515  15.088  1.00 17.77           O
ATOM   1437  C   GLU   169     -48.280  23.732  17.661  1.00 14.80           C
ATOM   1438  O   GLU   169     -47.758  22.662  18.045  1.00 15.84           O
ATOM   1439  N   GLY   170     -49.391  24.218  18.188  1.00 14.31           N
ATOM   1440  CA  GLY   170     -50.050  23.519  19.293  1.00 15.34           C
ATOM   1441  C   GLY   170     -51.115  22.570  18.807  1.00 14.96           C
ATOM   1442  O   GLY   170     -51.802  21.946  19.628  1.00 15.30           O
ATOM   1443  N   LEU   171     -51.257  22.405  17.486  1.00 11.97           N
ATOM   1444  CA  LEU   171     -52.364  21.571  16.985  1.00 12.07           C
ATOM   1445  CB  LEU   171     -53.048  22.173  15.739  1.00 11.20           C
ATOM   1446  CG  LEU   171     -53.567  23.620  15.751  1.00 13.56           C
ATOM   1447  CD1 LEU   171     -54.356  23.917  14.477  1.00 12.40           C
ATOM   1448  CD2 LEU   171     -54.410  23.968  16.985  1.00 16.09           C
ATOM   1449  C   LEU   171     -51.901  20.179  16.629  1.00 12.32           C
ATOM   1450  O   LEU   171     -52.706  19.251  16.620  1.00 12.27           O
ATOM   1451  N   THR   172     -50.620  20.021  16.304  1.00 11.32           N
ATOM   1452  CA  THR   172     -50.093  18.690  15.929  1.00 12.36           C
ATOM   1453  CB  THR   172     -50.439  18.296  14.451  1.00 11.94           C
ATOM   1454  OG1 THR   172     -50.076  16.907  14.240  1.00 16.35           O
ATOM   1455  CG2 THR   172     -49.710  19.217  13.452  1.00 12.29           C
ATOM   1456  C   THR   172     -48.585  18.711  16.141  1.00 12.72           C
ATOM   1457  O   THR   172     -47.994  19.812  16.226  1.00 13.87           O
ATOM   1458  N   SER   173     -47.958  17.545  16.214  1.00 12.97           N
ATOM   1459  CA  SER   173     -46.524  17.503  16.397  1.00 11.93           C
ATOM   1460  CB  SER   173     -46.103  16.108  16.826  1.00 13.97           C
ATOM   1461  OG  SER   173     -44.681  15.989  16.771  1.00 14.44           O
ATOM   1462  C   SER   173     -45.874  17.806  15.060  1.00 12.33           C
ATOM   1463  O   SER   173     -46.353  17.332  14.028  1.00 12.42           O
ATOM   1464  N   HIS   174     -44.824  18.610  15.068  1.00 12.00           N
ATOM   1465  CA  HIS   174     -43.970  18.721  13.876  1.00 14.23           C
ATOM   1466  CB  HIS   174     -43.909  20.171  13.391  1.00 14.23           C
ATOM   1467  CG  HIS   174     -45.247  20.722  13.030  1.00 15.81           C
ATOM   1468  ND1 HIS   174     -46.071  21.324  13.968  1.00 16.61           N
ATOM   1469  CE1 HIS   174     -47.185  21.718  13.368  1.00 20.91           C
ATOM   1470  NE2 HIS   174     -47.116  21.386  12.085  1.00 19.63           N
ATOM   1471  CD2 HIS   174     -45.900  20.785  11.839  1.00 17.42           C
ATOM   1472  C   HIS   174     -42.578  18.183  14.149  1.00 13.15           C
ATOM   1473  O   HIS   174     -41.625  18.515  13.427  1.00 14.79           O
ATOM   1474  N   SER   175     -42.456  17.352  15.179  1.00 14.28           N
ATOM   1475  CA  SER   175     -41.158  16.794  15.566  1.00 13.71           C
ATOM   1476  CB  SER   175     -41.281  16.104  16.921  1.00 14.35           C
ATOM   1477  OG  SER   175     -40.255  15.138  17.113  1.00 17.37           O
ATOM   1478  C   SER   175     -40.645  15.822  14.475  1.00 13.44           C
ATOM   1479  O   SER   175     -41.412  15.024  13.953  1.00 12.58           O
ATOM   1480  N   PRO   176     -39.341  15.882  14.146  1.00 13.15           N
ATOM   1481  CA  PRO   176     -38.830  14.880  13.178  1.00 13.22           C
ATOM   1482  CB  PRO   176     -37.342  15.224  13.064  1.00 13.70           C
ATOM   1483  CG  PRO   176     -37.228  16.655  13.534  1.00 13.98           C
ATOM   1484  CD  PRO   176     -38.278  16.806  14.593  1.00 13.08           C
ATOM   1485  C   PRO   176     -39.045  13.413  13.624  1.00 14.24           C
ATOM   1486  O   PRO   176     -39.154  12.527  12.770  1.00 13.21           O
ATOM   1487  N   ASP   177     -39.134  13.171  14.936  1.00 14.82           N
ATOM   1488  CA  ASP   177     -39.514  11.855  15.496  1.00 16.58           C
ATOM   1489  CB  ASP   177     -39.811  11.976  17.000  1.00 17.92           C
ATOM   1490  CG  ASP   177     -38.610  12.345  17.796  1.00 24.07           C
ATOM   1491  OD1 ASP   177     -37.500  12.389  17.204  1.00 30.89           O
ATOM   1492  OD2 ASP   177     -38.764  12.562  19.024  1.00 30.05           O
ATOM   1493  C   ASP   177     -40.780  11.270  14.887  1.00 15.97           C
ATOM   1494  O   ASP   177     -40.967  10.047  14.905  1.00 16.38           O
ATOM   1495  N   GLN   178     -41.655  12.147  14.404  1.00 14.77           N
ATOM   1496  CA  GLN   178     -42.965  11.735  13.923  1.00 15.23           C
ATOM   1497  CB  GLN   178     -44.057  12.637  14.515  1.00 16.28           C
ATOM   1498  CG  GLN   178     -44.212  12.558  16.075  1.00 18.38           C
ATOM   1499  CD  GLN   178     -44.416  11.148  16.555  1.00 24.89           C
ATOM   1500  OE1 GLN   178     -45.323  10.454  16.094  1.00 28.81           O
ATOM   1501  NE2 GLN   178     -43.556  10.694  17.466  1.00 23.68           N
ATOM   1502  C   GLN   178     -43.060  11.731  12.390  1.00 14.33           C
ATOM   1503  O   GLN   178     -44.153  11.563  11.837  1.00 14.25           O
ATOM   1504  N   ASP   179     -41.935  11.946  11.715  1.00 13.75           N
ATOM   1505  CA  ASP   179     -41.931  12.025  10.241  1.00 12.28           C
ATOM   1506  CB  ASP   179     -40.565  12.503   9.712  1.00 12.21           C
ATOM   1507  CG  ASP   179     -40.345  14.003   9.887  1.00 12.00           C
ATOM   1508  OD1 ASP   179     -41.340  14.728  10.133  1.00 12.73           O
ATOM   1509  OD2 ASP   179     -39.178  14.458   9.767  1.00 10.97           O
ATOM   1510  C   ASP   179     -42.333  10.695   9.583  1.00 12.43           C
ATOM   1511  O   ASP   179     -43.076  10.688   8.586  1.00 11.55           O
ATOM   1512  N   GLU   180     -41.873   9.564  10.129  1.00 12.85           N
ATOM   1513  CA  GLU   180     -42.244   8.281   9.539  1.00 13.39           C
ATOM   1514  CB  GLU   180     -41.363   7.129  10.047  1.00 14.36           C
ATOM   1515  CG  GLU   180     -39.961   7.112   9.416  1.00 16.71           C
ATOM   1516  CD  GLU   180     -39.971   6.815   7.917  1.00 18.99           C
ATOM   1517  OE1 GLU   180     -40.744   5.922   7.502  1.00 20.42           O
ATOM   1518  OE2 GLU   180     -39.200   7.469   7.161  1.00 18.63           O
ATOM   1519  C   GLU   180     -43.734   8.019   9.746  1.00 13.71           C
ATOM   1520  O   GLU   180     -44.403   7.448   8.873  1.00 13.28           O
ATOM   1521  N   GLU   181     -44.271   8.460  10.883  1.00 13.78           N
ATOM   1522  CA  GLU   181     -45.689   8.305  11.124  1.00 14.42           C
ATOM   1523  CB  GLU   181     -45.998   8.599  12.588  1.00 16.10           C
ATOM   1524  CG  GLU   181     -47.472   8.632  12.901  1.00 21.01           C
ATOM   1525  CD  GLU   181     -48.173   7.282  12.774  1.00 23.11           C
ATOM   1526  OE1 GLU   181     -47.514   6.228  12.665  1.00 24.17           O
ATOM   1527  OE2 GLU   181     -49.422   7.301  12.790  1.00 25.06           O
ATOM   1528  C   GLU   181     -46.494   9.212  10.185  1.00 14.14           C
ATOM   1529  O   GLU   181     -47.564   8.828   9.706  1.00 14.26           O
ATOM   1530  N   LEU   182     -45.956  10.396   9.878  1.00 13.08           N
ATOM   1531  CA  LEU   182     -46.604  11.293   8.915  1.00 13.64           C
ATOM   1532  CB  LEU   182     -45.865  12.643   8.831  1.00 12.83           C
ATOM   1533  CG  LEU   182     -46.579  13.680   7.940  1.00 14.91           C
ATOM   1534  CD1 LEU   182     -47.863  14.196   8.590  1.00 15.08           C
ATOM   1535  CD2 LEU   182     -45.644  14.827   7.575  1.00 15.95           C
ATOM   1536  C   LEU   182     -46.678  10.637   7.522  1.00 13.14           C
ATOM   1537  O   LEU   182     -47.718  10.661   6.855  1.00 14.11           O
ATOM   1538  N   ILE   183     -45.576  10.050   7.084  1.00 12.68           N
ATOM   1539  CA  ILE   183     -45.564   9.306   5.810  1.00 11.35           C
ATOM   1540  CB  ILE   183     -44.189   8.673   5.546  1.00 10.84           C
ATOM   1541  CG1 ILE   183     -43.122   9.766   5.347  1.00 12.02           C
ATOM   1542  CD1 ILE   183     -41.658   9.195   5.429  1.00 11.23           C
ATOM   1543  CG2 ILE   183     -44.228   7.768   4.309  1.00 11.12           C
ATOM   1544  C   ILE   183     -46.664   8.205   5.800  1.00 11.45           C
ATOM   1545  O   ILE   183     -47.422   8.086   4.830  1.00 10.62           O
ATOM   1546  N   ARG   184     -46.735   7.438   6.884  0.50 11.53           N
ATOM   1548  CA  ARG   184     -47.720   6.369   7.046  0.50 11.75           C
ATOM   1550  CB  ARG   184     -47.569   5.750   8.435  0.50 12.01           C
ATOM   1552  CG  ARG   184     -47.839   4.275   8.512  0.50 14.69           C
ATOM   1554  CD  ARG   184     -47.348   3.699   9.852  0.50 17.23           C
ATOM   1556  NE  ARG   184     -45.897   3.490   9.822  0.50 20.38           N
ATOM   1558  CZ  ARG   184     -45.023   3.988  10.695  0.50 19.61           C
ATOM   1560  NH1 ARG   184     -43.738   3.716  10.523  0.50 21.24           N
ATOM   1562  NH2 ARG   184     -45.415   4.720  11.740  0.50 16.19           N
ATOM   1564  C   ARG   184     -49.137   6.937   6.888  0.50 11.09           C
ATOM   1566  O   ARG   184     -49.974   6.363   6.185  0.50 10.52           O
ATOM   1568  N   GLN   185     -49.387   8.070   7.541  1.00 10.20           N
ATOM   1569  CA  GLN   185     -50.693   8.718   7.492  1.00 11.34           C
ATOM   1570  CB  GLN   185     -50.812   9.832   8.557  1.00 11.76           C
ATOM   1571  CG  GLN   185     -50.910   9.329   9.971  1.00 13.90           C
ATOM   1572  CD  GLN   185     -50.827  10.475  10.988  1.00 16.31           C
ATOM   1573  OE1 GLN   185     -51.146  11.627  10.670  1.00 24.88           O
ATOM   1574  NE2 GLN   185     -50.379  10.163  12.192  1.00 22.00           N
ATOM   1575  C   GLN   185     -51.069   9.294   6.120  1.00 10.79           C
ATOM   1576  O   GLN   185     -52.231   9.134   5.675  1.00 10.92           O
ATOM   1577  N   TYR   186     -50.095   9.901   5.436  1.00  9.48           N
ATOM   1578  CA  TYR   186     -50.375  10.550   4.165  1.00 10.97           C
ATOM   1579  CB  TYR   186     -49.386  11.701   3.929  1.00 11.73           C
ATOM   1580  CG  TYR   186     -49.831  12.983   4.689  1.00 11.89           C
ATOM   1581  CD1 TYR   186     -50.901  12.943   5.618  1.00 16.50           C
ATOM   1582  CE1 TYR   186     -51.319  14.116   6.323  1.00 16.69           C
ATOM   1583  CZ  TYR   186     -50.665  15.304   6.104  1.00 15.60           C
ATOM   1584  OH  TYR   186     -51.066  16.479   6.789  1.00 16.29           O
ATOM   1585  CE2 TYR   186     -49.579  15.336   5.236  1.00 15.60           C
ATOM   1586  CD2 TYR   186     -49.176  14.184   4.529  1.00 16.97           C
ATOM   1587  C   TYR   186     -50.456   9.510   3.024  1.00 10.48           C
ATOM   1588  O   TYR   186     -51.313   9.616   2.143  1.00 10.25           O
ATOM   1589  N   VAL   187     -49.660   8.448   3.114  1.00 10.81           N
ATOM   1590  CA  VAL   187     -49.813   7.308   2.195  1.00 11.07           C
ATOM   1591  CB  VAL   187     -48.750   6.195   2.457  1.00 12.17           C
ATOM   1592  CG1 VAL   187     -49.152   4.865   1.801  1.00 12.64           C
ATOM   1593  CG2 VAL   187     -47.381   6.636   1.948  1.00 12.10           C
ATOM   1594  C   VAL   187     -51.238   6.738   2.348  1.00 10.78           C
ATOM   1595  O   VAL   187     -51.902   6.468   1.365  1.00 11.55           O
ATOM   1596  N   ALA   188     -51.697   6.596   3.591  1.00 10.35           N
ATOM   1597  CA  ALA   188     -53.016   6.013   3.862  1.00 10.34           C
ATOM   1598  CB  ALA   188     -53.214   5.835   5.322  1.00 10.03           C
ATOM   1599  C   ALA   188     -54.109   6.923   3.278  1.00 10.52           C
ATOM   1600  O   ALA   188     -54.976   6.440   2.532  1.00 11.14           O
ATOM   1601  N   ILE   189     -54.067   8.223   3.582  1.00  9.18           N
ATOM   1602  CA  ILE   189     -55.064   9.134   3.022  1.00 10.18           C
ATOM   1603  CB  ILE   189     -54.855  10.573   3.534  1.00 10.61           C
ATOM   1604  CG1 ILE   189     -55.136  10.601   5.058  1.00 10.98           C
ATOM   1605  CD1 ILE   189     -54.723  11.960   5.716  1.00 13.83           C
ATOM   1606  CG2 ILE   189     -55.802  11.563   2.805  1.00 11.30           C
ATOM   1607  C   ILE   189     -55.041   9.113   1.474  1.00  9.70           C
ATOM   1608  O   ILE   189     -56.074   9.014   0.819  1.00  9.40           O
ATOM   1609  N   PHE   190     -53.857   9.209   0.889  1.00  9.58           N
ATOM   1610  CA  PHE   190     -53.805   9.360  -0.550  1.00  9.58           C
ATOM   1611  CB  PHE   190     -52.360   9.611  -0.993  1.00 10.23           C
ATOM   1612  CG  PHE   190     -52.226  10.008  -2.454  1.00  9.45           C
ATOM   1613  CD1 PHE   190     -52.917  11.128  -2.945  1.00  9.44           C
ATOM   1614  CE1 PHE   190     -52.804  11.478  -4.324  1.00  8.91           C
ATOM   1615  CZ  PHE   190     -51.991  10.716  -5.159  1.00  8.37           C
ATOM   1616  CE2 PHE   190     -51.307   9.595  -4.666  1.00 10.34           C
ATOM   1617  CD2 PHE   190     -51.432   9.256  -3.313  1.00  9.34           C
ATOM   1618  C   PHE   190     -54.341   8.115  -1.252  1.00 10.23           C
ATOM   1619  O   PHE   190     -55.013   8.227  -2.272  1.00 10.36           O
ATOM   1620  N   THR   191     -54.011   6.933  -0.728  1.00 10.49           N
ATOM   1621  CA  THR   191     -54.331   5.687  -1.425  1.00 11.39           C
ATOM   1622  CB  THR   191     -53.251   4.575  -1.187  1.00 11.16           C
ATOM   1623  OG1 THR   191     -53.129   4.320   0.203  1.00 13.70           O
ATOM   1624  CG2 THR   191     -51.894   5.021  -1.716  1.00 12.85           C
ATOM   1625  C   THR   191     -55.730   5.173  -1.057  1.00 11.49           C
ATOM   1626  O   THR   191     -56.413   4.630  -1.920  1.00 11.57           O
ATOM   1627  N   ARG   192     -56.142   5.361   0.207  1.00 11.47           N
ATOM   1628  CA  ARG   192     -57.377   4.780   0.764  1.00 12.54           C
ATOM   1629  CB  ARG   192     -57.043   3.762   1.863  1.00 13.38           C
ATOM   1630  CG  ARG   192     -56.218   2.608   1.352  1.00 19.78           C
ATOM   1631  CD  ARG   192     -55.838   1.648   2.458  1.00 27.83           C
ATOM   1632  NE  ARG   192     -54.833   2.186   3.390  1.00 31.16           N
ATOM   1633  CZ  ARG   192     -54.979   2.196   4.710  1.00 30.70           C
ATOM   1634  NH1 ARG   192     -56.099   1.741   5.268  1.00 34.65           N
ATOM   1635  NH2 ARG   192     -54.007   2.636   5.480  1.00 31.86           N
ATOM   1636  C   ARG   192     -58.394   5.793   1.313  1.00 11.41           C
ATOM   1637  O   ARG   192     -59.513   5.408   1.694  1.00 11.66           O
ATOM   1638  N   GLY   193     -57.999   7.067   1.407  1.00 10.15           N
ATOM   1639  CA  GLY   193     -58.897   8.124   1.894  1.00  9.23           C
ATOM   1640  C   GLY   193     -59.105   8.042   3.399  1.00 10.71           C
ATOM   1641  O   GLY   193     -58.465   7.238   4.070  1.00 11.66           O
ATOM   1642  N   ILE   194     -60.015   8.848   3.940  1.00 10.09           N
ATOM   1643  CA  ILE   194     -60.233   8.806   5.378  1.00 10.51           C
ATOM   1644  CB  ILE   194     -60.410  10.235   5.966  1.00  9.22           C
ATOM   1645  CG1 ILE   194     -61.635  10.937   5.378  1.00  9.15           C
ATOM   1646  CD1 ILE   194     -62.095  12.150   6.229  1.00 10.65           C
ATOM   1647  CG2 ILE   194     -59.149  11.099   5.736  1.00 10.26           C
ATOM   1648  C   ILE   194     -61.435   7.920   5.776  1.00 13.00           C
ATOM   1649  O   ILE   194     -61.677   7.686   6.986  1.00 11.91           O
ATOM   1650  N   MET   195     -62.162   7.427   4.770  0.80 13.74           N
ATOM   1652  CA  MET   195     -63.370   6.618   5.035  0.80 19.32           C
ATOM   1654  CB  MET   195     -64.062   6.224   3.735  0.80 17.64           C
ATOM   1656  CG  MET   195     -63.224   5.251   2.910  0.80 22.42           C
ATOM   1658  SD  MET   195     -64.053   4.614   1.255  0.80 35.82          SE
ATOM   1660  CE  MET   195     -65.779   4.059   1.995  0.80 28.19           C
ATOM   1662  C   MET   195     -63.024   5.348   5.798  0.80 17.09           C
ATOM   1664  O   MET   195     -61.945   4.789   5.620  0.80 16.40           O
ATOM   1666  N   ALA   196     -63.946   4.892   6.647  1.00 16.54           N
ATOM   1667  CA  ALA   196     -63.751   3.621   7.358  1.00 17.64           C
ATOM   1668  CB  ALA   196     -64.842   3.419   8.388  1.00 17.48           C
ATOM   1669  C   ALA   196     -63.706   2.435   6.397  1.00 18.42           C
ATOM   1670  O   ALA   196     -64.469   2.403   5.437  1.00 19.76           O
END
