
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  179 ( 1313),  selected  179 , name 3crj_C
# Molecule2: number of CA atoms  192 ( 1477),  selected  192 , name T0454.pdb
# PARAMETERS: 3crj_C.T0454.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    D    11_C      D       5           -
LGA    Q    12_C      C       6           -
LGA    T    13_C      -       -           -
LGA    E    14_C      -       -           -
LGA    E    15_C      -       -           -
LGA    I    16_C      R       7          5.643
LGA    X    17_C      -       -           -
LGA    Q    18_C      S       8           #
LGA    A    19_C      R       9           #
LGA    T    20_C      L      10          5.424
LGA    Y    21_C      M      11          5.319
LGA    R    22_C      E      12          3.768
LGA    A    23_C      -       -           -
LGA    L    24_C      V      13           #
LGA    R    25_C      A      14           -
LGA    -       -      T      15           -
LGA    D    31_C      E      16           #
LGA    L    32_C      L      17          1.795
LGA    T    33_C      F      18           -
LGA    -       -      A      19           -
LGA    -       -      Q      20           -
LGA    -       -      K      21           -
LGA    -       -      G      22           -
LGA    -       -      F      23           -
LGA    -       -      Y      24           -
LGA    -       -      G      25           -
LGA    -       -      V      26           -
LGA    -       -      S      27           -
LGA    -       -      I      28           -
LGA    -       -      R      29           -
LGA    -       -      E      30           -
LGA    I    34_C      L      31          1.986
LGA    Q    35_C      A      32          3.083
LGA    R    36_C      Q      33          5.849
LGA    I    37_C      A      34           #
LGA    A    38_C      A      35          4.684
LGA    D    39_C      G      36          6.058
LGA    E    40_C      -       -           -
LGA    Y    41_C      -       -           -
LGA    S    44_C      -       -           -
LGA    T    45_C      A      37          1.261
LGA    A    46_C      S      38          4.273
LGA    A    47_C      I      39           -
LGA    V    48_C      S      40           -
LGA    H    49_C      M      41          2.628
LGA    -       -      I      42           -
LGA    -       -      S      43           -
LGA    Y    50_C      Y      44          2.955
LGA    Y    51_C      H      45          3.281
LGA    Y    52_C      F      46          2.858
LGA    D    53_C      G      47          2.548
LGA    T    54_C      G      48          2.389
LGA    K    55_C      K      49          0.645
LGA    D    56_C      E      50          2.512
LGA    D    57_C      G      51          2.434
LGA    L    58_C      L      52          0.916
LGA    L    59_C      Y      53          1.020
LGA    A    60_C      A      54          1.740
LGA    A    61_C      A      55          2.589
LGA    F    62_C      V      56          1.901
LGA    L    63_C      L      57          1.298
LGA    D    64_C      Q      58          2.182
LGA    Y    65_C      E      59          2.476
LGA    L    66_C      Q      60          2.090
LGA    L    67_C      F      61          0.970
LGA    E    68_C      A      62          2.161
LGA    R    69_C      C      63          1.975
LGA    F    70_C      F      64          2.947
LGA    V    71_C      G      65          2.771
LGA    D    72_C      Q      66          1.187
LGA    S    73_C      L      67          4.090
LGA    I    74_C      -       -           -
LGA    H    75_C      -       -           -
LGA    D    76_C      D      68          1.630
LGA    V    77_C      D      69          2.207
LGA    -       -      I      70           -
LGA    -       -      R      71           -
LGA    E    78_C      G      72          1.412
LGA    T    79_C      Q      73          2.308
LGA    T    80_C      A      74          2.315
LGA    D    81_C      G      75          2.776
LGA    P    82_C      D      76          1.959
LGA    -       -      P      77           -
LGA    E    83_C      L      78          1.981
LGA    A    84_C      A      79          1.571
LGA    R    85_C      V      80          1.925
LGA    L    86_C      M      81          1.951
LGA    N    87_C      T      82          1.172
LGA    L    88_C      A      83          0.906
LGA    L    89_C      Y      84          1.562
LGA    L    90_C      L      85          1.711
LGA    D    91_C      R      86          1.126
LGA    E    92_C      W      87          0.458
LGA    L    93_C      T      88          1.105
LGA    L    94_C      I      89          2.111
LGA    V    95_C      Q      90          4.065
LGA    K    96_C      R      91          4.761
LGA    P    97_C      H      92          2.906
LGA    Q    98_C      R      93          2.759
LGA    E    99_C      -       -           -
LGA    N   100_C      N      94          2.222
LGA    P   101_C      -       -           -
LGA    D   102_C      -       -           -
LGA    L   103_C      N      95          1.647
LGA    S   104_C      P      96          2.957
LGA    V   105_C      Q      97          2.865
LGA    A   106_C      -       -           -
LGA    L   107_C      L      98          2.161
LGA    L   108_C      L      99          2.929
LGA    E   109_C      R     100          2.587
LGA    X   110_C      F     101          1.690
LGA    R   111_C      Y     102          3.515
LGA    S   112_C      T     103          4.732
LGA    Q   113_C      S     104          3.566
LGA    A   114_C      E     105          2.781
LGA    -       -      L     106           -
LGA    P   115_C      T     107          3.617
LGA    Y   116_C      N     108          3.579
LGA    K   117_C      P     109          4.005
LGA    E   118_C      T     110          2.405
LGA    A   119_C      P     111          1.933
LGA    F   120_C      C     112          4.203
LGA    S   121_C      F     113          3.748
LGA    D   122_C      A     114          3.295
LGA    -       -      A     115           -
LGA    R   123_C      I     116          3.914
LGA    F   124_C      V     117          2.852
LGA    R   125_C      S     118          2.918
LGA    Q   126_C      P     119          2.964
LGA    N   127_C      A     120          2.446
LGA    D   128_C      I     121          2.178
LGA    E   129_C      A     122          1.647
LGA    Y   130_C      S     123          1.622
LGA    V   131_C      V     124          1.546
LGA    R   132_C      I     125          1.027
LGA    Y   133_C      R     126          0.492
LGA    X   134_C      L     127          1.033
LGA    L   135_C      L     128          1.091
LGA    K   136_C      A     129          0.653
LGA    A   137_C      E     130          1.234
LGA    V   138_C      S     131          1.406
LGA    I   139_C      I     132          1.181
LGA    N   140_C      E     133          1.551
LGA    H   141_C      A     134          2.234
LGA    G   142_C      G     135          2.265
LGA    I   143_C      M     136          2.536
LGA    D   144_C      T     137          2.872
LGA    E   145_C      R     138          3.556
LGA    G   146_C      G     139          3.807
LGA    V   147_C      L     140          3.406
LGA    F   148_C      F     141          3.013
LGA    T   149_C      R     142          3.332
LGA    D   150_C      R     143          2.715
LGA    V   151_C      D     144           #
LGA    D   152_C      L     145          2.077
LGA    A   153_C      H     146          3.674
LGA    -       -      A     147           -
LGA    E   154_C      V     148          1.750
LGA    H   155_C      N     149          1.806
LGA    V   156_C      S     150          0.966
LGA    T   157_C      A     151          0.509
LGA    R   158_C      L     152          1.161
LGA    S   159_C      A     153          0.457
LGA    L   160_C      L     154          0.834
LGA    L   161_C      A     155          1.590
LGA    T   162_C      G     156          1.233
LGA    I   163_C      M     157          0.886
LGA    I   164_C      V     158          2.206
LGA    D   165_C      N     159          1.979
LGA    G   166_C      Y     160          0.343
LGA    A   167_C      F     161          1.839
LGA    R   168_C      F     162          2.419
LGA    T   169_C      L     163          0.595
LGA    R   170_C      S     164          2.009
LGA    A   171_C      T     165          3.234
LGA    V   172_C      -       -           -
LGA    X   173_C      -       -           -
LGA    L   174_C      L     166          2.189
LGA    D   175_C      A     167           -
LGA    -       -      T     168           -
LGA    -       -      E     169           -
LGA    -       -      G     170           -
LGA    -       -      L     171           -
LGA    -       -      T     172           -
LGA    -       -      S     173           -
LGA    D   176_C      H     174          4.275
LGA    T   177_C      S     175          4.228
LGA    E   178_C      P     176           #
LGA    E   179_C      D     177           -
LGA    L   180_C      Q     178           #
LGA    E   181_C      D     179          2.669
LGA    T   182_C      E     180           -
LGA    -       -      E     181           -
LGA    A   183_C      L     182          4.646
LGA    R   184_C      I     183          2.854
LGA    Q   185_C      R     184          3.847
LGA    T   186_C      Q     185          4.091
LGA    A   187_C      Y     186          2.318
LGA    S   188_C      V     187          0.841
LGA    E   189_C      A     188          2.166
LGA    Y   190_C      I     189          2.390
LGA    A   191_C      F     190          1.960
LGA    D   192_C      T     191          1.635
LGA    A   193_C      R     192          1.672
LGA    X   194_C      G     193           #
LGA    L   195_C      I     194           -
LGA    Q   196_C      M     195           -
LGA    -       -      A     196           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  179  192    5.0    143    2.70    16.08     47.921     5.106

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.953465 * X  +  -0.018637 * Y  +   0.300926 * Z  + -56.818966
  Y_new =  -0.073501 * X  +   0.982343 * Y  +  -0.172045 * Z  + -83.229942
  Z_new =  -0.292406 * X  +  -0.186157 * Y  +  -0.938000 * Z  +  75.228584 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.945677    0.195916  [ DEG:  -168.7749     11.2251 ]
  Theta =   0.296742    2.844850  [ DEG:    17.0021    162.9979 ]
  Phi   =  -3.064657    0.076936  [ DEG:  -175.5919      4.4081 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3crj_C                                        
REMARK     2: T0454.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3crj_C.T0454.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  179  192   5.0  143   2.70   16.08  47.921
REMARK  ---------------------------------------------------------- 
MOLECULE 3crj_C
HEADER    TRANSCRIPTION REGULATOR                 07-APR-08   3CRJ              
TITLE     CRYSTAL STRUCTURE OF A TETR TRANSCRIPTION REGULATOR FROM              
TITLE    2 HALOARCULA MARISMORTUI ATCC 43049                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TRANSCRIPTION REGULATOR;                                   
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HALOARCULA MARISMORTUI ATCC 43049;              
SOURCE   3 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   4 STRAIN: DSM 3752 / JCM 8966;                                         
SOURCE   5 ATCC: 43049;                                                         
SOURCE   6 GENE: TETR, PNG7308;                                                 
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    APC88200, TETR, HALOARCULA MARISMORTUI ATCC 43049,                    
KEYWDS   2 STRUCTURAL GENOMICS, PSI-2, PROTEIN STRUCTURE INITIATIVE,            
KEYWDS   3 MIDWEST CENTER FOR STRUCTURAL GENOMICS, MCSG, DNA-BINDING,           
KEYWDS   4 PLASMID, TRANSCRIPTION, TRANSCRIPTION REGULATION,                    
KEYWDS   5 TRANSCRIPTION REGULATOR                                              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.TAN,M.ZHOU,L.FREEMAN,A.JOACHIMIAK,MIDWEST CENTER FOR                
AUTHOR   2 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   1   22-APR-08 3CRJ    0                                                
JRNL        AUTH   K.TAN,M.ZHOU,L.FREEMAN,A.JOACHIMIAK                          
JRNL        TITL   THE CRYSTAL STRUCTURE OF A TETR TRANSCRIPTION                
JRNL        TITL 2 REGULATOR FROM HALOARCULA MARISMORTUI ATCC 43049.            
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.60 ANGSTROMS.                                          
DBREF  3CRJ A    1   196  UNP    Q5V649   Q5V649_HALMA     1    196             
DBREF  3CRJ B    1   196  UNP    Q5V649   Q5V649_HALMA     1    196             
DBREF  3CRJ C    1   196  UNP    Q5V649   Q5V649_HALMA     1    196             
DBREF  3CRJ D    1   196  UNP    Q5V649   Q5V649_HALMA     1    196             
SEQRES   1 A  199  SER ASN ALA MSE ALA GLY PRO SER ASP ARG THR PHE SER          
SEQRES   2 A  199  ASP GLN THR GLU GLU ILE MSE GLN ALA THR TYR ARG ALA          
SEQRES   3 A  199  LEU ARG GLU HIS GLY TYR ALA ASP LEU THR ILE GLN ARG          
SEQRES   4 A  199  ILE ALA ASP GLU TYR GLY LYS SER THR ALA ALA VAL HIS          
SEQRES   5 A  199  TYR TYR TYR ASP THR LYS ASP ASP LEU LEU ALA ALA PHE          
SEQRES   6 A  199  LEU ASP TYR LEU LEU GLU ARG PHE VAL ASP SER ILE HIS          
SEQRES   7 A  199  ASP VAL GLU THR THR ASP PRO GLU ALA ARG LEU ASN LEU          
SEQRES   8 A  199  LEU LEU ASP GLU LEU LEU VAL LYS PRO GLN GLU ASN PRO          
SEQRES   9 A  199  ASP LEU SER VAL ALA LEU LEU GLU MSE ARG SER GLN ALA          
SEQRES  10 A  199  PRO TYR LYS GLU ALA PHE SER ASP ARG PHE ARG GLN ASN          
SEQRES  11 A  199  ASP GLU TYR VAL ARG TYR MSE LEU LYS ALA VAL ILE ASN          
SEQRES  12 A  199  HIS GLY ILE ASP GLU GLY VAL PHE THR ASP VAL ASP ALA          
SEQRES  13 A  199  GLU HIS VAL THR ARG SER LEU LEU THR ILE ILE ASP GLY          
SEQRES  14 A  199  ALA ARG THR ARG ALA VAL MSE LEU ASP ASP THR GLU GLU          
SEQRES  15 A  199  LEU GLU THR ALA ARG GLN THR ALA SER GLU TYR ALA ASP          
SEQRES  16 A  199  ALA MSE LEU GLN                                              
SEQRES   1 B  199  SER ASN ALA MSE ALA GLY PRO SER ASP ARG THR PHE SER          
SEQRES   2 B  199  ASP GLN THR GLU GLU ILE MSE GLN ALA THR TYR ARG ALA          
SEQRES   3 B  199  LEU ARG GLU HIS GLY TYR ALA ASP LEU THR ILE GLN ARG          
SEQRES   4 B  199  ILE ALA ASP GLU TYR GLY LYS SER THR ALA ALA VAL HIS          
SEQRES   5 B  199  TYR TYR TYR ASP THR LYS ASP ASP LEU LEU ALA ALA PHE          
SEQRES   6 B  199  LEU ASP TYR LEU LEU GLU ARG PHE VAL ASP SER ILE HIS          
SEQRES   7 B  199  ASP VAL GLU THR THR ASP PRO GLU ALA ARG LEU ASN LEU          
SEQRES   8 B  199  LEU LEU ASP GLU LEU LEU VAL LYS PRO GLN GLU ASN PRO          
SEQRES   9 B  199  ASP LEU SER VAL ALA LEU LEU GLU MSE ARG SER GLN ALA          
SEQRES  10 B  199  PRO TYR LYS GLU ALA PHE SER ASP ARG PHE ARG GLN ASN          
SEQRES  11 B  199  ASP GLU TYR VAL ARG TYR MSE LEU LYS ALA VAL ILE ASN          
SEQRES  12 B  199  HIS GLY ILE ASP GLU GLY VAL PHE THR ASP VAL ASP ALA          
SEQRES  13 B  199  GLU HIS VAL THR ARG SER LEU LEU THR ILE ILE ASP GLY          
SEQRES  14 B  199  ALA ARG THR ARG ALA VAL MSE LEU ASP ASP THR GLU GLU          
SEQRES  15 B  199  LEU GLU THR ALA ARG GLN THR ALA SER GLU TYR ALA ASP          
SEQRES  16 B  199  ALA MSE LEU GLN                                              
SEQRES   1 C  199  SER ASN ALA MSE ALA GLY PRO SER ASP ARG THR PHE SER          
SEQRES   2 C  199  ASP GLN THR GLU GLU ILE MSE GLN ALA THR TYR ARG ALA          
SEQRES   3 C  199  LEU ARG GLU HIS GLY TYR ALA ASP LEU THR ILE GLN ARG          
SEQRES   4 C  199  ILE ALA ASP GLU TYR GLY LYS SER THR ALA ALA VAL HIS          
SEQRES   5 C  199  TYR TYR TYR ASP THR LYS ASP ASP LEU LEU ALA ALA PHE          
SEQRES   6 C  199  LEU ASP TYR LEU LEU GLU ARG PHE VAL ASP SER ILE HIS          
SEQRES   7 C  199  ASP VAL GLU THR THR ASP PRO GLU ALA ARG LEU ASN LEU          
SEQRES   8 C  199  LEU LEU ASP GLU LEU LEU VAL LYS PRO GLN GLU ASN PRO          
SEQRES   9 C  199  ASP LEU SER VAL ALA LEU LEU GLU MSE ARG SER GLN ALA          
SEQRES  10 C  199  PRO TYR LYS GLU ALA PHE SER ASP ARG PHE ARG GLN ASN          
SEQRES  11 C  199  ASP GLU TYR VAL ARG TYR MSE LEU LYS ALA VAL ILE ASN          
SEQRES  12 C  199  HIS GLY ILE ASP GLU GLY VAL PHE THR ASP VAL ASP ALA          
SEQRES  13 C  199  GLU HIS VAL THR ARG SER LEU LEU THR ILE ILE ASP GLY          
SEQRES  14 C  199  ALA ARG THR ARG ALA VAL MSE LEU ASP ASP THR GLU GLU          
SEQRES  15 C  199  LEU GLU THR ALA ARG GLN THR ALA SER GLU TYR ALA ASP          
SEQRES  16 C  199  ALA MSE LEU GLN                                              
SEQRES   1 D  199  SER ASN ALA MSE ALA GLY PRO SER ASP ARG THR PHE SER          
SEQRES   2 D  199  ASP GLN THR GLU GLU ILE MSE GLN ALA THR TYR ARG ALA          
SEQRES   3 D  199  LEU ARG GLU HIS GLY TYR ALA ASP LEU THR ILE GLN ARG          
SEQRES   4 D  199  ILE ALA ASP GLU TYR GLY LYS SER THR ALA ALA VAL HIS          
SEQRES   5 D  199  TYR TYR TYR ASP THR LYS ASP ASP LEU LEU ALA ALA PHE          
SEQRES   6 D  199  LEU ASP TYR LEU LEU GLU ARG PHE VAL ASP SER ILE HIS          
SEQRES   7 D  199  ASP VAL GLU THR THR ASP PRO GLU ALA ARG LEU ASN LEU          
SEQRES   8 D  199  LEU LEU ASP GLU LEU LEU VAL LYS PRO GLN GLU ASN PRO          
SEQRES   9 D  199  ASP LEU SER VAL ALA LEU LEU GLU MSE ARG SER GLN ALA          
SEQRES  10 D  199  PRO TYR LYS GLU ALA PHE SER ASP ARG PHE ARG GLN ASN          
SEQRES  11 D  199  ASP GLU TYR VAL ARG TYR MSE LEU LYS ALA VAL ILE ASN          
SEQRES  12 D  199  HIS GLY ILE ASP GLU GLY VAL PHE THR ASP VAL ASP ALA          
SEQRES  13 D  199  GLU HIS VAL THR ARG SER LEU LEU THR ILE ILE ASP GLY          
SEQRES  14 D  199  ALA ARG THR ARG ALA VAL MSE LEU ASP ASP THR GLU GLU          
SEQRES  15 D  199  LEU GLU THR ALA ARG GLN THR ALA SER GLU TYR ALA ASP          
SEQRES  16 D  199  ALA MSE LEU GLN                                              
HET    MSE  A  17       8                                                       
HET    MSE  A 110       8                                                       
HET    MSE  A 134       8                                                       
HET    MSE  A 173       8                                                       
HET    MSE  A 194       8                                                       
HET    MSE  B  17       8                                                       
HET    MSE  B 110       8                                                       
HET    MSE  B 134      13                                                       
HET    MSE  B 173       8                                                       
HET    MSE  B 194       8                                                       
HET    MSE  C  17       5                                                       
HET    MSE  C 110       8                                                       
HET    MSE  C 134      13                                                       
HET    MSE  C 173       8                                                       
HET    MSE  C 194       8                                                       
HET    MSE  D  17       8                                                       
HET    MSE  D 110       8                                                       
HET    MSE  D 134       8                                                       
HET    MSE  D 173       8                                                       
HET    MSE  D 194       8                                                       
HET     CL  A 301       1                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      CL CHLORIDE ION                                                     
FORMUL   1  MSE    20(C5 H11 N O2 SE)                                           
FORMUL   5   CL    CL 1-                                                        
CRYST1   62.494  103.361  167.898  90.00  90.00  90.00 P 21 21 21   16          
ATOM   3075  N   ASP C  11     -14.515  24.622 -12.650  1.00 82.96           N  
ATOM   3076  CA  ASP C  11     -13.465  23.696 -12.131  1.00 82.96           C  
ATOM   3077  C   ASP C  11     -13.726  23.256 -10.688  1.00 82.99           C  
ATOM   3078  O   ASP C  11     -13.378  22.136 -10.315  1.00 82.99           O  
ATOM   3079  CB  ASP C  11     -12.082  24.327 -12.261  1.00 82.90           C  
ATOM   3080  N   GLN C  12     -14.329  24.138  -9.885  1.00 83.06           N  
ATOM   3081  CA  GLN C  12     -14.662  23.839  -8.482  1.00 83.11           C  
ATOM   3082  C   GLN C  12     -15.662  24.835  -7.879  1.00 83.19           C  
ATOM   3083  O   GLN C  12     -15.545  25.211  -6.709  1.00 83.15           O  
ATOM   3084  CB  GLN C  12     -13.390  23.771  -7.628  1.00 83.07           C  
ATOM   3085  N   THR C  13     -16.650  25.243  -8.677  1.00 83.33           N  
ATOM   3086  CA  THR C  13     -17.630  26.264  -8.272  1.00 83.46           C  
ATOM   3087  C   THR C  13     -18.775  25.741  -7.392  1.00 83.54           C  
ATOM   3088  O   THR C  13     -19.609  26.526  -6.935  1.00 83.49           O  
ATOM   3089  CB  THR C  13     -18.188  26.991  -9.502  1.00 83.41           C  
ATOM   3090  N   GLU C  14     -18.803  24.427  -7.157  1.00 83.69           N  
ATOM   3091  CA  GLU C  14     -19.817  23.786  -6.300  1.00 83.82           C  
ATOM   3092  C   GLU C  14     -19.612  24.081  -4.803  1.00 83.90           C  
ATOM   3093  O   GLU C  14     -20.406  23.651  -3.957  1.00 83.90           O  
ATOM   3094  CB  GLU C  14     -19.866  22.274  -6.559  1.00 83.71           C  
ATOM   3095  N   GLU C  15     -18.538  24.808  -4.495  1.00 83.99           N  
ATOM   3096  CA  GLU C  15     -18.249  25.274  -3.140  1.00 84.01           C  
ATOM   3097  C   GLU C  15     -18.508  26.781  -3.005  1.00 84.01           C  
ATOM   3098  O   GLU C  15     -18.457  27.332  -1.899  1.00 84.00           O  
ATOM   3099  CB  GLU C  15     -16.810  24.930  -2.752  1.00 83.95           C  
ATOM   3100  N   ILE C  16     -18.789  27.433  -4.137  1.00 83.93           N  
ATOM   3101  CA  ILE C  16     -19.138  28.853  -4.168  1.00 83.86           C  
ATOM   3102  C   ILE C  16     -20.432  29.120  -3.402  1.00 83.93           C  
ATOM   3103  O   ILE C  16     -20.581  30.166  -2.769  1.00 83.87           O  
ATOM   3104  CB  ILE C  16     -19.254  29.343  -5.607  1.00 83.71           C  
HETATM 3105  N   MSE C  17     -21.354  28.159  -3.460  1.00 84.06           N  
HETATM 3106  CA  MSE C  17     -22.647  28.260  -2.782  1.00 84.18           C  
HETATM 3107  C   MSE C  17     -22.776  27.301  -1.591  1.00 84.23           C  
HETATM 3108  O   MSE C  17     -23.852  27.197  -0.993  1.00 84.19           O  
HETATM 3109  CB  MSE C  17     -23.790  28.042  -3.784  1.00 84.11           C  
ATOM   3110  N   GLN C  18     -21.683  26.613  -1.248  1.00 84.33           N  
ATOM   3111  CA  GLN C  18     -21.665  25.667  -0.123  1.00 84.41           C  
ATOM   3112  C   GLN C  18     -21.763  26.376   1.232  1.00 84.49           C  
ATOM   3113  O   GLN C  18     -22.683  26.111   2.008  1.00 84.43           O  
ATOM   3114  CB  GLN C  18     -20.429  24.769  -0.182  1.00 84.32           C  
ATOM   3115  N   ALA C  19     -20.817  27.274   1.506  1.00 84.66           N  
ATOM   3116  CA  ALA C  19     -20.857  28.102   2.714  1.00 84.83           C  
ATOM   3117  C   ALA C  19     -21.778  29.314   2.539  1.00 84.97           C  
ATOM   3118  O   ALA C  19     -22.330  29.819   3.521  1.00 85.07           O  
ATOM   3119  CB  ALA C  19     -19.453  28.542   3.116  1.00 84.70           C  
ATOM   3120  N   THR C  20     -21.945  29.760   1.288  1.00 85.10           N  
ATOM   3121  CA  THR C  20     -22.807  30.903   0.931  1.00 85.16           C  
ATOM   3122  C   THR C  20     -24.302  30.586   1.030  1.00 85.22           C  
ATOM   3123  O   THR C  20     -25.151  31.360   0.567  1.00 85.19           O  
ATOM   3124  CB  THR C  20     -22.463  31.415  -0.469  1.00 85.15           C  
ATOM   3125  N   TYR C  21     -24.608  29.431   1.617  1.00 85.25           N  
ATOM   3126  CA  TYR C  21     -25.972  29.054   1.944  1.00 85.22           C  
ATOM   3127  C   TYR C  21     -26.334  29.636   3.302  1.00 85.32           C  
ATOM   3128  O   TYR C  21     -27.474  30.050   3.522  1.00 85.29           O  
ATOM   3129  CB  TYR C  21     -26.106  27.541   1.963  1.00 85.21           C  
ATOM   3130  N   ARG C  22     -25.340  29.683   4.192  1.00 85.38           N  
ATOM   3131  CA  ARG C  22     -25.505  30.137   5.577  1.00 85.50           C  
ATOM   3132  C   ARG C  22     -26.142  31.522   5.736  1.00 85.54           C  
ATOM   3133  O   ARG C  22     -26.610  31.866   6.828  1.00 85.58           O  
ATOM   3134  CB  ARG C  22     -24.160  30.073   6.324  1.00 85.50           C  
ATOM   3135  N   ALA C  23     -26.162  32.305   4.654  1.00 85.59           N  
ATOM   3136  CA  ALA C  23     -26.811  33.625   4.630  1.00 85.58           C  
ATOM   3137  C   ALA C  23     -28.044  33.688   5.549  1.00 85.60           C  
ATOM   3138  O   ALA C  23     -28.163  34.607   6.378  1.00 85.40           O  
ATOM   3139  CB  ALA C  23     -27.184  34.010   3.192  1.00 85.51           C  
ATOM   3140  N   LEU C  24     -28.942  32.700   5.399  1.00 85.58           N  
ATOM   3141  CA  LEU C  24     -30.117  32.557   6.268  1.00 85.64           C  
ATOM   3142  C   LEU C  24     -29.883  31.507   7.389  1.00 85.75           C  
ATOM   3143  O   LEU C  24     -30.550  30.430   7.441  1.00 86.02           O  
ATOM   3144  CB  LEU C  24     -31.371  32.238   5.440  1.00 85.15           C  
ATOM   3145  N   ARG C  25     -28.925  31.827   8.286  1.00 85.63           N  
ATOM   3146  CA  ARG C  25     -28.652  30.923   9.416  1.00 85.58           C  
ATOM   3147  C   ARG C  25     -28.166  31.744  10.739  1.00 85.65           C  
ATOM   3148  O   ARG C  25     -29.020  31.949  11.710  1.00 85.87           O  
ATOM   3149  CB  ARG C  25     -27.564  29.791   8.991  1.00 85.46           C  
ATOM   3150  N   ASP C  31     -33.282  41.785   4.195  1.00 52.60           N  
ATOM   3151  CA  ASP C  31     -32.887  40.371   4.561  1.00 52.70           C  
ATOM   3152  C   ASP C  31     -31.376  40.153   4.364  1.00 52.75           C  
ATOM   3153  O   ASP C  31     -30.600  40.412   5.285  1.00 52.65           O  
ATOM   3154  CB  ASP C  31     -33.733  39.289   3.740  1.00 52.64           C  
ATOM   3155  N   LEU C  32     -30.972  39.693   3.174  1.00 52.91           N  
ATOM   3156  CA  LEU C  32     -29.585  39.264   2.909  1.00 52.97           C  
ATOM   3157  C   LEU C  32     -28.773  40.274   2.097  1.00 53.04           C  
ATOM   3158  O   LEU C  32     -29.251  40.789   1.086  1.00 52.96           O  
ATOM   3159  CB  LEU C  32     -29.570  37.889   2.222  1.00 52.83           C  
ATOM   3160  N   THR C  33     -27.541  40.530   2.540  1.00 53.29           N  
ATOM   3161  CA  THR C  33     -26.680  41.563   1.943  1.00 53.59           C  
ATOM   3162  C   THR C  33     -25.550  40.983   1.090  1.00 53.78           C  
ATOM   3163  O   THR C  33     -25.194  39.810   1.232  1.00 53.81           O  
ATOM   3164  CB  THR C  33     -26.115  42.486   3.028  1.00 53.44           C  
ATOM   3165  N   ILE C  34     -24.999  41.818   0.207  1.00 54.08           N  
ATOM   3166  CA  ILE C  34     -23.939  41.417  -0.728  1.00 54.40           C  
ATOM   3167  C   ILE C  34     -22.668  40.976  -0.004  1.00 54.65           C  
ATOM   3168  O   ILE C  34     -22.113  39.904  -0.287  1.00 54.46           O  
ATOM   3169  CB  ILE C  34     -23.633  42.556  -1.708  1.00 54.25           C  
ATOM   3170  N   GLN C  35     -22.232  41.816   0.935  1.00 55.12           N  
ATOM   3171  CA  GLN C  35     -21.025  41.595   1.737  1.00 55.46           C  
ATOM   3172  C   GLN C  35     -21.257  40.648   2.920  1.00 55.67           C  
ATOM   3173  O   GLN C  35     -20.390  39.824   3.236  1.00 55.74           O  
ATOM   3174  CB  GLN C  35     -20.466  42.933   2.231  1.00 55.38           C  
ATOM   3175  N   ARG C  36     -22.421  40.772   3.564  1.00 55.80           N  
ATOM   3176  CA  ARG C  36     -22.782  39.940   4.714  1.00 55.84           C  
ATOM   3177  C   ARG C  36     -22.853  38.472   4.302  1.00 56.02           C  
ATOM   3178  O   ARG C  36     -23.165  37.597   5.117  1.00 55.93           O  
ATOM   3179  CB  ARG C  36     -24.105  40.405   5.320  1.00 55.67           C  
ATOM   3180  N   ILE C  37     -22.546  38.228   3.026  1.00 56.26           N  
ATOM   3181  CA  ILE C  37     -22.547  36.898   2.421  1.00 56.44           C  
ATOM   3182  C   ILE C  37     -21.127  36.337   2.290  1.00 56.53           C  
ATOM   3183  O   ILE C  37     -20.847  35.222   2.737  1.00 56.48           O  
ATOM   3184  CB  ILE C  37     -23.248  36.938   1.059  1.00 56.26           C  
ATOM   3185  N   ALA C  38     -20.233  37.119   1.687  1.00 56.73           N  
ATOM   3186  CA  ALA C  38     -18.846  36.701   1.484  1.00 57.00           C  
ATOM   3187  C   ALA C  38     -18.041  36.601   2.794  1.00 57.15           C  
ATOM   3188  O   ALA C  38     -16.970  35.982   2.826  1.00 57.08           O  
ATOM   3189  CB  ALA C  38     -18.160  37.634   0.497  1.00 57.05           C  
ATOM   3190  N   ASP C  39     -18.573  37.199   3.862  1.00 57.37           N  
ATOM   3191  CA  ASP C  39     -17.955  37.171   5.194  1.00 57.56           C  
ATOM   3192  C   ASP C  39     -17.929  35.769   5.819  1.00 57.70           C  
ATOM   3193  O   ASP C  39     -17.103  35.492   6.690  1.00 57.76           O  
ATOM   3194  CB  ASP C  39     -18.652  38.161   6.125  1.00 57.50           C  
ATOM   3195  N   GLU C  40     -18.840  34.901   5.379  1.00 57.87           N  
ATOM   3196  CA  GLU C  40     -18.854  33.491   5.787  1.00 58.05           C  
ATOM   3197  C   GLU C  40     -18.240  32.597   4.701  1.00 58.14           C  
ATOM   3198  O   GLU C  40     -17.367  31.770   4.989  1.00 58.19           O  
ATOM   3199  CB  GLU C  40     -20.280  33.036   6.124  1.00 58.06           C  
ATOM   3200  N   TYR C  41     -18.708  32.779   3.462  1.00 58.11           N  
ATOM   3201  CA  TYR C  41     -18.192  32.067   2.290  1.00 57.94           C  
ATOM   3202  C   TYR C  41     -16.768  32.495   1.947  1.00 57.86           C  
ATOM   3203  O   TYR C  41     -15.984  31.707   1.419  1.00 57.69           O  
ATOM   3204  CB  TYR C  41     -19.109  32.287   1.099  1.00 57.87           C  
ATOM   3205  N   SER C  44     -15.042  38.667   1.279  1.00 78.34           N  
ATOM   3206  CA  SER C  44     -15.296  40.102   1.335  1.00 78.40           C  
ATOM   3207  C   SER C  44     -16.041  40.612   0.096  1.00 78.45           C  
ATOM   3208  O   SER C  44     -16.077  39.942  -0.941  1.00 78.39           O  
ATOM   3209  CB  SER C  44     -13.980  40.862   1.522  1.00 78.36           C  
ATOM   3210  N   THR C  45     -16.636  41.801   0.224  1.00 78.56           N  
ATOM   3211  CA  THR C  45     -17.258  42.519  -0.899  1.00 78.64           C  
ATOM   3212  C   THR C  45     -16.211  42.982  -1.917  1.00 78.71           C  
ATOM   3213  O   THR C  45     -16.540  43.265  -3.074  1.00 78.69           O  
ATOM   3214  CB  THR C  45     -18.066  43.709  -0.391  1.00 78.58           C  
ATOM   3215  N   ALA C  46     -14.960  43.076  -1.462  1.00 78.76           N  
ATOM   3216  CA  ALA C  46     -13.810  43.327  -2.327  1.00 78.73           C  
ATOM   3217  C   ALA C  46     -13.060  42.022  -2.643  1.00 78.77           C  
ATOM   3218  O   ALA C  46     -11.938  42.052  -3.152  1.00 78.75           O  
ATOM   3219  CB  ALA C  46     -12.876  44.351  -1.685  1.00 78.69           C  
ATOM   3220  N   ALA C  47     -13.689  40.884  -2.338  1.00 78.83           N  
ATOM   3221  CA  ALA C  47     -13.145  39.565  -2.673  1.00 78.79           C  
ATOM   3222  C   ALA C  47     -13.958  38.899  -3.788  1.00 78.80           C  
ATOM   3223  O   ALA C  47     -13.753  39.208  -4.964  1.00 78.80           O  
ATOM   3224  CB  ALA C  47     -13.065  38.672  -1.435  1.00 78.73           C  
ATOM   3225  N   VAL C  48     -14.882  38.008  -3.422  1.00 78.82           N  
ATOM   3226  CA  VAL C  48     -15.695  37.262  -4.399  1.00 78.90           C  
ATOM   3227  C   VAL C  48     -16.796  38.115  -5.055  1.00 78.94           C  
ATOM   3228  O   VAL C  48     -17.919  37.637  -5.276  1.00 78.89           O  
ATOM   3229  CB  VAL C  48     -16.290  35.996  -3.751  1.00 78.83           C  
ATOM   3230  N   HIS C  49     -16.451  39.366  -5.377  1.00 78.88           N  
ATOM   3231  CA  HIS C  49     -17.389  40.367  -5.908  1.00 78.79           C  
ATOM   3232  C   HIS C  49     -17.842  40.076  -7.341  1.00 78.73           C  
ATOM   3233  O   HIS C  49     -19.035  39.879  -7.592  1.00 78.68           O  
ATOM   3234  CB  HIS C  49     -16.776  41.771  -5.816  1.00 78.71           C  
ATOM   3235  N   TYR C  50     -16.881  40.048  -8.264  1.00 78.72           N  
ATOM   3236  CA  TYR C  50     -17.136  39.827  -9.691  1.00 78.61           C  
ATOM   3237  C   TYR C  50     -17.660  38.421  -9.987  1.00 78.50           C  
ATOM   3238  O   TYR C  50     -18.027  38.116 -11.125  1.00 78.40           O  
ATOM   3239  CB  TYR C  50     -15.868  40.116 -10.511  1.00 78.57           C  
ATOM   3240  N   TYR C  51     -17.697  37.581  -8.953  1.00 78.46           N  
ATOM   3241  CA  TYR C  51     -18.199  36.212  -9.050  1.00 78.54           C  
ATOM   3242  C   TYR C  51     -19.579  36.109  -9.721  1.00 78.54           C  
ATOM   3243  O   TYR C  51     -19.870  35.114 -10.386  1.00 78.50           O  
ATOM   3244  CB  TYR C  51     -18.215  35.555  -7.676  1.00 78.49           C  
ATOM   3245  N   TYR C  52     -20.417  37.131  -9.540  1.00 78.57           N  
ATOM   3246  CA  TYR C  52     -21.688  37.255 -10.271  1.00 78.66           C  
ATOM   3247  C   TYR C  52     -22.012  38.725 -10.567  1.00 78.73           C  
ATOM   3248  O   TYR C  52     -21.853  39.590  -9.698  1.00 78.69           O  
ATOM   3249  CB  TYR C  52     -22.840  36.572  -9.510  1.00 78.64           C  
ATOM   3250  N   ASP C  53     -22.468  38.992 -11.793  1.00 78.85           N  
ATOM   3251  CA  ASP C  53     -22.654  40.361 -12.304  1.00 78.98           C  
ATOM   3252  C   ASP C  53     -23.795  41.157 -11.652  1.00 79.07           C  
ATOM   3253  O   ASP C  53     -23.762  42.390 -11.650  1.00 79.09           O  
ATOM   3254  CB  ASP C  53     -22.805  40.350 -13.831  1.00 78.93           C  
ATOM   3255  N   THR C  54     -24.792  40.458 -11.104  1.00 79.15           N  
ATOM   3256  CA  THR C  54     -25.928  41.109 -10.448  1.00 79.17           C  
ATOM   3257  C   THR C  54     -26.151  40.584  -9.030  1.00 79.29           C  
ATOM   3258  O   THR C  54     -25.991  39.388  -8.769  1.00 79.31           O  
ATOM   3259  CB  THR C  54     -27.194  40.950 -11.287  1.00 79.08           C  
ATOM   3260  N   LYS C  55     -26.517  41.487  -8.119  1.00 79.38           N  
ATOM   3261  CA  LYS C  55     -26.879  41.117  -6.748  1.00 79.54           C  
ATOM   3262  C   LYS C  55     -28.073  40.165  -6.771  1.00 79.70           C  
ATOM   3263  O   LYS C  55     -28.230  39.316  -5.887  1.00 79.55           O  
ATOM   3264  CB  LYS C  55     -27.197  42.360  -5.927  1.00 79.49           C  
ATOM   3265  N   ASP C  56     -28.899  40.321  -7.805  1.00 79.90           N  
ATOM   3266  CA  ASP C  56     -30.022  39.432  -8.077  1.00 80.07           C  
ATOM   3267  C   ASP C  56     -29.542  38.080  -8.617  1.00 80.09           C  
ATOM   3268  O   ASP C  56     -30.054  37.030  -8.205  1.00 80.00           O  
ATOM   3269  CB  ASP C  56     -30.993  40.096  -9.060  1.00 80.02           C  
ATOM   3270  N   ASP C  57     -28.553  38.125  -9.518  1.00 79.93           N  
ATOM   3271  CA  ASP C  57     -28.038  36.941 -10.231  1.00 79.84           C  
ATOM   3272  C   ASP C  57     -27.434  35.883  -9.312  1.00 79.78           C  
ATOM   3273  O   ASP C  57     -27.627  34.682  -9.541  1.00 79.78           O  
ATOM   3274  CB  ASP C  57     -27.032  37.346 -11.323  1.00 79.73           C  
ATOM   3275  N   LEU C  58     -26.709  36.327  -8.282  1.00 79.57           N  
ATOM   3276  CA  LEU C  58     -26.173  35.426  -7.259  1.00 79.47           C  
ATOM   3277  C   LEU C  58     -27.279  34.524  -6.691  1.00 79.48           C  
ATOM   3278  O   LEU C  58     -27.120  33.299  -6.608  1.00 79.24           O  
ATOM   3279  CB  LEU C  58     -25.500  36.220  -6.148  1.00 79.24           C  
ATOM   3280  N   LEU C  59     -28.400  35.148  -6.325  1.00 79.55           N  
ATOM   3281  CA  LEU C  59     -29.577  34.454  -5.809  1.00 79.64           C  
ATOM   3282  C   LEU C  59     -30.178  33.528  -6.864  1.00 79.76           C  
ATOM   3283  O   LEU C  59     -30.582  32.412  -6.549  1.00 79.64           O  
ATOM   3284  CB  LEU C  59     -30.633  35.461  -5.328  1.00 79.55           C  
ATOM   3285  CG  LEU C  59     -30.222  36.579  -4.358  1.00 79.43           C  
ATOM   3286  CD1 LEU C  59     -31.194  37.757  -4.430  1.00 79.31           C  
ATOM   3287  CD2 LEU C  59     -30.092  36.067  -2.930  1.00 78.95           C  
ATOM   3288  N   ALA C  60     -30.215  33.995  -8.112  1.00 80.06           N  
ATOM   3289  CA  ALA C  60     -30.764  33.230  -9.235  1.00 80.35           C  
ATOM   3290  C   ALA C  60     -30.163  31.822  -9.339  1.00 80.60           C  
ATOM   3291  O   ALA C  60     -30.898  30.830  -9.414  1.00 80.63           O  
ATOM   3292  CB  ALA C  60     -30.576  33.998 -10.545  1.00 80.34           C  
ATOM   3293  N   ALA C  61     -28.832  31.749  -9.330  1.00 80.89           N  
ATOM   3294  CA  ALA C  61     -28.114  30.473  -9.378  1.00 81.13           C  
ATOM   3295  C   ALA C  61     -28.445  29.598  -8.172  1.00 81.35           C  
ATOM   3296  O   ALA C  61     -28.604  28.386  -8.307  1.00 81.38           O  
ATOM   3297  CB  ALA C  61     -26.610  30.707  -9.469  1.00 81.03           C  
ATOM   3298  N   PHE C  62     -28.560  30.230  -7.003  1.00 81.67           N  
ATOM   3299  CA  PHE C  62     -28.817  29.532  -5.741  1.00 81.96           C  
ATOM   3300  C   PHE C  62     -30.146  28.768  -5.730  1.00 82.13           C  
ATOM   3301  O   PHE C  62     -30.242  27.692  -5.125  1.00 82.23           O  
ATOM   3302  CB  PHE C  62     -28.746  30.509  -4.565  1.00 82.01           C  
ATOM   3303  CG  PHE C  62     -28.680  29.842  -3.222  1.00 82.24           C  
ATOM   3304  CD1 PHE C  62     -27.453  29.473  -2.679  1.00 82.36           C  
ATOM   3305  CD2 PHE C  62     -29.846  29.584  -2.495  1.00 82.68           C  
ATOM   3306  CE1 PHE C  62     -27.386  28.856  -1.432  1.00 82.70           C  
ATOM   3307  CE2 PHE C  62     -29.793  28.966  -1.249  1.00 82.49           C  
ATOM   3308  CZ  PHE C  62     -28.561  28.603  -0.713  1.00 82.55           C  
ATOM   3309  N   LEU C  63     -31.167  29.329  -6.379  1.00 82.26           N  
ATOM   3310  CA  LEU C  63     -32.394  28.583  -6.633  1.00 82.38           C  
ATOM   3311  C   LEU C  63     -32.062  27.361  -7.467  1.00 82.67           C  
ATOM   3312  O   LEU C  63     -32.370  26.242  -7.073  1.00 82.82           O  
ATOM   3313  CB  LEU C  63     -33.446  29.431  -7.355  1.00 82.19           C  
ATOM   3314  CG  LEU C  63     -34.722  29.841  -6.614  1.00 81.57           C  
ATOM   3315  CD1 LEU C  63     -35.820  30.156  -7.614  1.00 81.00           C  
ATOM   3316  CD2 LEU C  63     -35.193  28.768  -5.655  1.00 80.29           C  
ATOM   3317  N   ASP C  64     -31.403  27.587  -8.602  1.00 82.93           N  
ATOM   3318  CA  ASP C  64     -31.033  26.514  -9.510  1.00 83.28           C  
ATOM   3319  C   ASP C  64     -30.025  25.562  -8.889  1.00 83.63           C  
ATOM   3320  O   ASP C  64     -29.648  24.573  -9.507  1.00 83.65           O  
ATOM   3321  CB  ASP C  64     -30.482  27.089 -10.813  1.00 83.23           C  
ATOM   3322  CG  ASP C  64     -31.552  27.742 -11.658  1.00 83.22           C  
ATOM   3323  OD1 ASP C  64     -31.197  28.608 -12.488  1.00 82.76           O  
ATOM   3324  OD2 ASP C  64     -32.745  27.388 -11.495  1.00 82.64           O  
ATOM   3325  N   TYR C  65     -29.588  25.869  -7.671  1.00 84.15           N  
ATOM   3326  CA  TYR C  65     -28.719  24.969  -6.929  1.00 84.87           C  
ATOM   3327  C   TYR C  65     -29.548  24.079  -6.033  1.00 85.14           C  
ATOM   3328  O   TYR C  65     -29.590  22.867  -6.237  1.00 85.38           O  
ATOM   3329  CB  TYR C  65     -27.698  25.733  -6.087  1.00 85.22           C  
ATOM   3330  CG  TYR C  65     -26.653  24.847  -5.424  1.00 85.77           C  
ATOM   3331  CD1 TYR C  65     -25.362  24.745  -5.957  1.00 85.90           C  
ATOM   3332  CD2 TYR C  65     -26.949  24.117  -4.263  1.00 85.80           C  
ATOM   3333  CE1 TYR C  65     -24.396  23.944  -5.356  1.00 85.92           C  
ATOM   3334  CE2 TYR C  65     -25.990  23.308  -3.655  1.00 86.02           C  
ATOM   3335  CZ  TYR C  65     -24.714  23.229  -4.208  1.00 86.13           C  
ATOM   3336  OH  TYR C  65     -23.751  22.441  -3.619  1.00 86.20           O  
ATOM   3337  N   LEU C  66     -30.200  24.675  -5.034  1.00 85.38           N  
ATOM   3338  CA  LEU C  66     -31.013  23.907  -4.087  1.00 85.57           C  
ATOM   3339  C   LEU C  66     -32.129  23.131  -4.777  1.00 85.70           C  
ATOM   3340  O   LEU C  66     -32.520  22.056  -4.323  1.00 85.76           O  
ATOM   3341  CB  LEU C  66     -31.562  24.794  -2.965  1.00 85.56           C  
ATOM   3342  CG  LEU C  66     -30.777  24.712  -1.646  1.00 85.73           C  
ATOM   3343  CD1 LEU C  66     -29.380  25.330  -1.766  1.00 85.72           C  
ATOM   3344  CD2 LEU C  66     -31.553  25.321  -0.468  1.00 85.52           C  
ATOM   3345  N   LEU C  67     -32.617  23.678  -5.884  1.00 85.93           N  
ATOM   3346  CA  LEU C  67     -33.572  22.983  -6.728  1.00 86.04           C  
ATOM   3347  C   LEU C  67     -32.916  21.873  -7.552  1.00 86.42           C  
ATOM   3348  O   LEU C  67     -33.578  20.891  -7.877  1.00 86.62           O  
ATOM   3349  CB  LEU C  67     -34.319  23.969  -7.629  1.00 85.96           C  
ATOM   3350  CG  LEU C  67     -35.687  24.512  -7.196  1.00 85.56           C  
ATOM   3351  CD1 LEU C  67     -35.822  24.733  -5.695  1.00 85.23           C  
ATOM   3352  CD2 LEU C  67     -35.994  25.788  -7.957  1.00 85.61           C  
ATOM   3353  N   GLU C  68     -31.628  22.014  -7.875  1.00 86.62           N  
ATOM   3354  CA  GLU C  68     -30.913  21.005  -8.678  1.00 86.98           C  
ATOM   3355  C   GLU C  68     -30.666  19.695  -7.913  1.00 87.32           C  
ATOM   3356  O   GLU C  68     -30.952  18.615  -8.426  1.00 87.31           O  
ATOM   3357  CB  GLU C  68     -29.594  21.567  -9.230  1.00 86.99           C  
ATOM   3358  CG  GLU C  68     -29.024  20.827 -10.444  1.00 86.78           C  
ATOM   3359  CD  GLU C  68     -27.894  21.594 -11.136  1.00 86.84           C  
ATOM   3360  OE1 GLU C  68     -26.847  20.978 -11.424  1.00 86.06           O  
ATOM   3361  OE2 GLU C  68     -28.047  22.809 -11.393  1.00 86.48           O  
ATOM   3362  N   ARG C  69     -30.135  19.790  -6.693  1.00 87.75           N  
ATOM   3363  CA  ARG C  69     -29.942  18.604  -5.844  1.00 88.07           C  
ATOM   3364  C   ARG C  69     -31.268  18.157  -5.210  1.00 88.18           C  
ATOM   3365  O   ARG C  69     -31.401  17.019  -4.755  1.00 88.14           O  
ATOM   3366  CB  ARG C  69     -28.852  18.836  -4.783  1.00 88.05           C  
ATOM   3367  CG  ARG C  69     -27.417  18.968  -5.333  1.00 88.45           C  
ATOM   3368  CD  ARG C  69     -26.900  17.670  -5.970  1.00 89.16           C  
ATOM   3369  NE  ARG C  69     -25.439  17.652  -6.106  1.00 89.98           N  
ATOM   3370  CZ  ARG C  69     -24.764  16.970  -7.037  1.00 90.42           C  
ATOM   3371  NH1 ARG C  69     -25.409  16.244  -7.944  1.00 90.86           N  
ATOM   3372  NH2 ARG C  69     -23.436  17.021  -7.073  1.00 89.89           N  
ATOM   3373  N   PHE C  70     -32.245  19.063  -5.200  1.00 88.34           N  
ATOM   3374  CA  PHE C  70     -33.631  18.716  -4.906  1.00 88.66           C  
ATOM   3375  C   PHE C  70     -34.189  17.793  -5.991  1.00 88.53           C  
ATOM   3376  O   PHE C  70     -35.157  17.070  -5.758  1.00 88.67           O  
ATOM   3377  CB  PHE C  70     -34.493  19.976  -4.823  1.00 89.06           C  
ATOM   3378  CG  PHE C  70     -35.747  19.807  -4.010  1.00 89.98           C  
ATOM   3379  CD1 PHE C  70     -36.860  19.141  -4.535  1.00 90.54           C  
ATOM   3380  CD2 PHE C  70     -35.821  20.326  -2.714  1.00 91.03           C  
ATOM   3381  CE1 PHE C  70     -38.018  18.987  -3.781  1.00 90.70           C  
ATOM   3382  CE2 PHE C  70     -36.979  20.178  -1.946  1.00 91.11           C  
ATOM   3383  CZ  PHE C  70     -38.078  19.506  -2.480  1.00 90.87           C  
ATOM   3384  N   VAL C  71     -33.581  17.843  -7.179  1.00 88.25           N  
ATOM   3385  CA  VAL C  71     -33.957  16.987  -8.311  1.00 87.59           C  
ATOM   3386  C   VAL C  71     -33.043  15.756  -8.361  1.00 87.49           C  
ATOM   3387  O   VAL C  71     -33.528  14.620  -8.285  1.00 87.44           O  
ATOM   3388  CB  VAL C  71     -33.919  17.771  -9.652  1.00 87.45           C  
ATOM   3389  CG1 VAL C  71     -34.130  16.851 -10.828  1.00 87.08           C  
ATOM   3390  CG2 VAL C  71     -34.971  18.874  -9.664  1.00 87.30           C  
ATOM   3391  N   ASP C  72     -31.730  15.999  -8.476  1.00 87.20           N  
ATOM   3392  CA  ASP C  72     -30.686  14.959  -8.443  1.00 86.73           C  
ATOM   3393  C   ASP C  72     -31.042  13.807  -7.509  1.00 86.44           C  
ATOM   3394  O   ASP C  72     -30.873  12.637  -7.860  1.00 86.37           O  
ATOM   3395  CB  ASP C  72     -29.356  15.560  -7.977  1.00 86.81           C  
ATOM   3396  CG  ASP C  72     -28.525  16.117  -9.114  1.00 86.79           C  
ATOM   3397  OD1 ASP C  72     -28.488  17.357  -9.276  1.00 87.11           O  
ATOM   3398  OD2 ASP C  72     -27.894  15.319  -9.836  1.00 86.53           O  
ATOM   3399  N   SER C  73     -31.524  14.158  -6.317  1.00 85.89           N  
ATOM   3400  CA  SER C  73     -31.932  13.188  -5.323  1.00 85.48           C  
ATOM   3401  C   SER C  73     -32.979  12.241  -5.900  1.00 85.17           C  
ATOM   3402  O   SER C  73     -32.703  11.060  -6.061  1.00 85.07           O  
ATOM   3403  CB  SER C  73     -32.477  13.892  -4.080  1.00 85.61           C  
ATOM   3404  OG  SER C  73     -33.773  14.423  -4.317  1.00 85.99           O  
ATOM   3405  N   ILE C  74     -34.161  12.772  -6.229  1.00 84.67           N  
ATOM   3406  CA  ILE C  74     -35.298  11.959  -6.686  1.00 83.97           C  
ATOM   3407  C   ILE C  74     -34.964  11.007  -7.837  1.00 83.21           C  
ATOM   3408  O   ILE C  74     -35.482   9.893  -7.889  1.00 83.04           O  
ATOM   3409  CB  ILE C  74     -36.515  12.815  -7.099  1.00 84.26           C  
ATOM   3410  CG1 ILE C  74     -37.157  13.496  -5.895  1.00 84.84           C  
ATOM   3411  CG2 ILE C  74     -37.573  11.946  -7.749  1.00 84.94           C  
ATOM   3412  CD1 ILE C  74     -36.870  14.960  -5.800  1.00 86.26           C  
ATOM   3413  N   HIS C  75     -34.106  11.438  -8.755  1.00 82.28           N  
ATOM   3414  CA  HIS C  75     -33.669  10.558  -9.829  1.00 81.60           C  
ATOM   3415  C   HIS C  75     -32.942   9.354  -9.253  1.00 80.62           C  
ATOM   3416  O   HIS C  75     -32.736   8.359  -9.944  1.00 80.57           O  
ATOM   3417  CB  HIS C  75     -32.734  11.289 -10.796  1.00 82.25           C  
ATOM   3418  CG  HIS C  75     -33.392  12.389 -11.573  1.00 83.14           C  
ATOM   3419  ND1 HIS C  75     -34.406  12.159 -12.481  1.00 83.31           N  
ATOM   3420  CD2 HIS C  75     -33.157  13.725 -11.602  1.00 83.14           C  
ATOM   3421  CE1 HIS C  75     -34.773  13.306 -13.028  1.00 83.12           C  
ATOM   3422  NE2 HIS C  75     -34.036  14.271 -12.506  1.00 82.97           N  
ATOM   3423  N   ASP C  76     -32.553   9.466  -7.984  1.00 79.49           N  
ATOM   3424  CA  ASP C  76     -31.820   8.408  -7.285  1.00 78.46           C  
ATOM   3425  C   ASP C  76     -32.667   7.188  -6.976  1.00 77.12           C  
ATOM   3426  O   ASP C  76     -32.133   6.077  -6.849  1.00 77.24           O  
ATOM   3427  CB  ASP C  76     -31.155   8.929  -6.006  1.00 78.66           C  
ATOM   3428  CG  ASP C  76     -29.655   9.149  -6.181  1.00 79.61           C  
ATOM   3429  OD1 ASP C  76     -29.043   8.473  -7.047  1.00 79.30           O  
ATOM   3430  OD2 ASP C  76     -29.093   9.993  -5.444  1.00 80.40           O  
ATOM   3431  N   VAL C  77     -33.976   7.385  -6.866  1.00 75.25           N  
ATOM   3432  CA  VAL C  77     -34.866   6.249  -6.742  1.00 73.57           C  
ATOM   3433  C   VAL C  77     -35.065   5.660  -8.142  1.00 72.52           C  
ATOM   3434  O   VAL C  77     -35.746   6.227  -8.990  1.00 71.96           O  
ATOM   3435  CB  VAL C  77     -36.185   6.552  -5.917  1.00 73.83           C  
ATOM   3436  CG1 VAL C  77     -36.011   7.770  -4.992  1.00 73.07           C  
ATOM   3437  CG2 VAL C  77     -37.405   6.716  -6.799  1.00 73.66           C  
ATOM   3438  N   GLU C  78     -34.363   4.555  -8.388  1.00 71.50           N  
ATOM   3439  CA  GLU C  78     -34.460   3.811  -9.634  1.00 70.35           C  
ATOM   3440  C   GLU C  78     -35.486   2.699  -9.509  1.00 69.48           C  
ATOM   3441  O   GLU C  78     -35.883   2.091 -10.491  1.00 69.51           O  
ATOM   3442  CB  GLU C  78     -33.095   3.258 -10.037  1.00 70.49           C  
ATOM   3443  CG  GLU C  78     -32.401   4.137 -11.072  1.00 71.04           C  
ATOM   3444  CD  GLU C  78     -30.895   3.960 -11.127  1.00 70.82           C  
ATOM   3445  OE1 GLU C  78     -30.175   4.947 -10.854  1.00 71.54           O  
ATOM   3446  OE2 GLU C  78     -30.432   2.847 -11.445  1.00 70.84           O  
ATOM   3447  N   THR C  79     -35.927   2.458  -8.282  1.00 68.49           N  
ATOM   3448  CA  THR C  79     -36.983   1.509  -7.992  1.00 67.37           C  
ATOM   3449  C   THR C  79     -38.138   1.725  -8.964  1.00 66.84           C  
ATOM   3450  O   THR C  79     -38.541   2.864  -9.238  1.00 66.71           O  
ATOM   3451  CB  THR C  79     -37.455   1.668  -6.524  1.00 67.28           C  
ATOM   3452  OG1 THR C  79     -38.511   0.746  -6.238  1.00 66.97           O  
ATOM   3453  CG2 THR C  79     -37.963   3.065  -6.295  1.00 66.96           C  
ATOM   3454  N   THR C  80     -38.666   0.625  -9.477  1.00 66.18           N  
ATOM   3455  CA  THR C  80     -39.698   0.671 -10.497  1.00 65.97           C  
ATOM   3456  C   THR C  80     -41.082   0.278 -10.010  1.00 66.10           C  
ATOM   3457  O   THR C  80     -42.078   0.728 -10.548  1.00 66.33           O  
ATOM   3458  CB  THR C  80     -39.279  -0.159 -11.733  1.00 66.12           C  
ATOM   3459  OG1 THR C  80     -39.081   0.737 -12.829  1.00 66.01           O  
ATOM   3460  CG2 THR C  80     -40.313  -1.261 -12.114  1.00 65.58           C  
ATOM   3461  N   ASP C  81     -41.172  -0.561  -8.994  1.00 66.39           N  
ATOM   3462  CA  ASP C  81     -42.490  -1.058  -8.657  1.00 66.67           C  
ATOM   3463  C   ASP C  81     -43.314   0.098  -8.047  1.00 66.39           C  
ATOM   3464  O   ASP C  81     -42.804   0.871  -7.230  1.00 66.46           O  
ATOM   3465  CB  ASP C  81     -42.429  -2.390  -7.864  1.00 66.80           C  
ATOM   3466  CG  ASP C  81     -42.631  -2.221  -6.385  1.00 67.53           C  
ATOM   3467  OD1 ASP C  81     -43.675  -1.674  -5.961  1.00 68.32           O  
ATOM   3468  OD2 ASP C  81     -41.754  -2.691  -5.636  1.00 69.72           O  
ATOM   3469  N   PRO C  82     -44.572   0.245  -8.492  1.00 66.15           N  
ATOM   3470  CA  PRO C  82     -45.311   1.489  -8.261  1.00 65.80           C  
ATOM   3471  C   PRO C  82     -45.430   1.922  -6.791  1.00 65.55           C  
ATOM   3472  O   PRO C  82     -45.265   3.098  -6.470  1.00 65.28           O  
ATOM   3473  CB  PRO C  82     -46.688   1.184  -8.866  1.00 65.75           C  
ATOM   3474  CG  PRO C  82     -46.432   0.137  -9.873  1.00 65.42           C  
ATOM   3475  CD  PRO C  82     -45.389  -0.731  -9.237  1.00 65.85           C  
ATOM   3476  N   GLU C  83     -45.688   0.963  -5.918  1.00 65.57           N  
ATOM   3477  CA  GLU C  83     -45.943   1.227  -4.515  1.00 65.54           C  
ATOM   3478  C   GLU C  83     -44.669   1.666  -3.798  1.00 65.05           C  
ATOM   3479  O   GLU C  83     -44.661   2.683  -3.101  1.00 65.21           O  
ATOM   3480  CB  GLU C  83     -46.483  -0.030  -3.874  1.00 65.84           C  
ATOM   3481  CG  GLU C  83     -47.440   0.205  -2.732  1.00 68.01           C  
ATOM   3482  CD  GLU C  83     -48.253  -1.046  -2.440  1.00 71.47           C  
ATOM   3483  OE1 GLU C  83     -48.919  -1.055  -1.381  1.00 72.12           O  
ATOM   3484  OE2 GLU C  83     -48.214  -2.008  -3.275  1.00 71.48           O  
ATOM   3485  N   ALA C  84     -43.586   0.916  -3.976  1.00 64.09           N  
ATOM   3486  CA  ALA C  84     -42.337   1.291  -3.346  1.00 63.27           C  
ATOM   3487  C   ALA C  84     -41.910   2.670  -3.828  1.00 62.50           C  
ATOM   3488  O   ALA C  84     -41.486   3.499  -3.037  1.00 62.48           O  
ATOM   3489  CB  ALA C  84     -41.267   0.276  -3.644  1.00 63.44           C  
ATOM   3490  N   ARG C  85     -42.056   2.909  -5.122  1.00 61.64           N  
ATOM   3491  CA  ARG C  85     -41.579   4.132  -5.728  1.00 61.14           C  
ATOM   3492  C   ARG C  85     -42.313   5.348  -5.206  1.00 61.04           C  
ATOM   3493  O   ARG C  85     -41.686   6.320  -4.774  1.00 61.28           O  
ATOM   3494  CB  ARG C  85     -41.721   4.069  -7.244  1.00 61.14           C  
ATOM   3495  CG  ARG C  85     -41.295   5.350  -7.911  1.00 60.67           C  
ATOM   3496  CD  ARG C  85     -40.954   5.169  -9.383  1.00 61.32           C  
ATOM   3497  NE  ARG C  85     -40.338   6.394  -9.885  1.00 60.17           N  
ATOM   3498  CZ  ARG C  85     -39.037   6.550 -10.069  1.00 59.18           C  
ATOM   3499  NH1 ARG C  85     -38.197   5.548  -9.840  1.00 60.05           N  
ATOM   3500  NH2 ARG C  85     -38.577   7.706 -10.503  1.00 60.38           N  
ATOM   3501  N   LEU C  86     -43.643   5.299  -5.257  1.00 60.68           N  
ATOM   3502  CA  LEU C  86     -44.465   6.406  -4.814  1.00 60.08           C  
ATOM   3503  C   LEU C  86     -44.049   6.740  -3.405  1.00 60.29           C  
ATOM   3504  O   LEU C  86     -43.923   7.907  -3.054  1.00 60.78           O  
ATOM   3505  CB  LEU C  86     -45.949   6.045  -4.876  1.00 59.69           C  
ATOM   3506  CG  LEU C  86     -46.942   7.075  -4.314  1.00 60.63           C  
ATOM   3507  CD1 LEU C  86     -46.832   8.441  -4.966  1.00 59.87           C  
ATOM   3508  CD2 LEU C  86     -48.379   6.568  -4.360  1.00 59.80           C  
ATOM   3509  N   ASN C  87     -43.799   5.703  -2.615  1.00 60.47           N  
ATOM   3510  CA  ASN C  87     -43.398   5.855  -1.219  1.00 60.67           C  
ATOM   3511  C   ASN C  87     -42.035   6.451  -0.998  1.00 60.59           C  
ATOM   3512  O   ASN C  87     -41.819   7.157  -0.008  1.00 60.45           O  
ATOM   3513  CB  ASN C  87     -43.502   4.530  -0.475  1.00 60.84           C  
ATOM   3514  CG  ASN C  87     -44.853   4.351   0.154  1.00 61.83           C  
ATOM   3515  OD1 ASN C  87     -45.268   5.161   0.985  1.00 66.17           O  
ATOM   3516  ND2 ASN C  87     -45.573   3.322  -0.259  1.00 62.63           N  
ATOM   3517  N   LEU C  88     -41.113   6.145  -1.903  1.00 60.54           N  
ATOM   3518  CA  LEU C  88     -39.770   6.674  -1.800  1.00 60.52           C  
ATOM   3519  C   LEU C  88     -39.760   8.105  -2.313  1.00 60.46           C  
ATOM   3520  O   LEU C  88     -39.020   8.946  -1.816  1.00 60.70           O  
ATOM   3521  CB  LEU C  88     -38.765   5.780  -2.513  1.00 60.42           C  
ATOM   3522  CG  LEU C  88     -38.538   4.412  -1.842  1.00 61.58           C  
ATOM   3523  CD1 LEU C  88     -38.127   3.353  -2.854  1.00 60.36           C  
ATOM   3524  CD2 LEU C  88     -37.522   4.464  -0.691  1.00 62.59           C  
ATOM   3525  N   LEU C  89     -40.616   8.402  -3.273  1.00 60.34           N  
ATOM   3526  CA  LEU C  89     -40.728   9.775  -3.724  1.00 60.33           C  
ATOM   3527  C   LEU C  89     -41.309  10.629  -2.604  1.00 60.35           C  
ATOM   3528  O   LEU C  89     -40.760  11.668  -2.274  1.00 61.26           O  
ATOM   3529  CB  LEU C  89     -41.564   9.851  -4.997  1.00 60.60           C  
ATOM   3530  CG  LEU C  89     -40.830   9.871  -6.350  1.00 61.35           C  
ATOM   3531  CD1 LEU C  89     -39.393   9.364  -6.294  1.00 60.19           C  
ATOM   3532  CD2 LEU C  89     -41.625   9.146  -7.447  1.00 61.98           C  
ATOM   3533  N   LEU C  90     -42.397  10.170  -1.992  1.00 59.86           N  
ATOM   3534  CA  LEU C  90     -42.987  10.848  -0.836  1.00 59.11           C  
ATOM   3535  C   LEU C  90     -41.999  11.035   0.295  1.00 58.82           C  
ATOM   3536  O   LEU C  90     -41.995  12.081   0.940  1.00 58.24           O  
ATOM   3537  CB  LEU C  90     -44.189  10.070  -0.329  1.00 58.57           C  
ATOM   3538  CG  LEU C  90     -45.599  10.528  -0.704  1.00 58.72           C  
ATOM   3539  CD1 LEU C  90     -45.710  11.714  -1.699  1.00 54.29           C  
ATOM   3540  CD2 LEU C  90     -46.388   9.306  -1.145  1.00 57.72           C  
ATOM   3541  N   ASP C  91     -41.179  10.005   0.523  1.00 58.87           N  
ATOM   3542  CA  ASP C  91     -40.060  10.041   1.474  1.00 58.81           C  
ATOM   3543  C   ASP C  91     -39.112  11.204   1.224  1.00 59.10           C  
ATOM   3544  O   ASP C  91     -38.718  11.893   2.168  1.00 59.03           O  
ATOM   3545  CB  ASP C  91     -39.248   8.746   1.411  1.00 58.51           C  
ATOM   3546  CG  ASP C  91     -39.737   7.691   2.372  1.00 58.10           C  
ATOM   3547  OD1 ASP C  91     -40.655   7.952   3.174  1.00 60.42           O  
ATOM   3548  OD2 ASP C  91     -39.190   6.579   2.333  1.00 58.03           O  
ATOM   3549  N   GLU C  92     -38.728  11.411  -0.038  1.00 59.22           N  
ATOM   3550  CA  GLU C  92     -37.771  12.469  -0.363  1.00 59.74           C  
ATOM   3551  C   GLU C  92     -38.377  13.854  -0.138  1.00 59.69           C  
ATOM   3552  O   GLU C  92     -37.731  14.755   0.394  1.00 59.89           O  
ATOM   3553  CB  GLU C  92     -37.276  12.349  -1.790  1.00 59.43           C  
ATOM   3554  CG  GLU C  92     -35.791  12.600  -1.901  1.00 61.98           C  
ATOM   3555  CD  GLU C  92     -34.952  11.419  -1.381  1.00 64.28           C  
ATOM   3556  OE1 GLU C  92     -33.846  11.653  -0.844  1.00 64.27           O  
ATOM   3557  OE2 GLU C  92     -35.405  10.255  -1.507  1.00 64.81           O  
ATOM   3558  N   LEU C  93     -39.630  14.003  -0.539  1.00 59.27           N  
ATOM   3559  CA  LEU C  93     -40.346  15.248  -0.397  1.00 58.97           C  
ATOM   3560  C   LEU C  93     -40.713  15.615   1.052  1.00 58.79           C  
ATOM   3561  O   LEU C  93     -40.833  16.790   1.365  1.00 58.59           O  
ATOM   3562  CB  LEU C  93     -41.605  15.167  -1.251  1.00 59.10           C  
ATOM   3563  CG  LEU C  93     -41.531  15.626  -2.708  1.00 58.73           C  
ATOM   3564  CD1 LEU C  93     -40.167  16.169  -3.077  1.00 58.32           C  
ATOM   3565  CD2 LEU C  93     -42.016  14.578  -3.693  1.00 56.43           C  
ATOM   3566  N   LEU C  94     -40.877  14.618   1.923  1.00 58.85           N  
ATOM   3567  CA  LEU C  94     -41.404  14.832   3.288  1.00 58.76           C  
ATOM   3568  C   LEU C  94     -40.540  14.319   4.441  1.00 59.47           C  
ATOM   3569  O   LEU C  94     -40.538  14.923   5.511  1.00 59.82           O  
ATOM   3570  CB  LEU C  94     -42.802  14.215   3.424  1.00 58.19           C  
ATOM   3571  CG  LEU C  94     -44.099  15.032   3.386  1.00 56.76           C  
ATOM   3572  CD1 LEU C  94     -43.933  16.471   2.915  1.00 55.67           C  
ATOM   3573  CD2 LEU C  94     -45.137  14.310   2.548  1.00 53.31           C  
ATOM   3574  N   VAL C  95     -39.790  13.252   4.239  1.00 60.52           N  
ATOM   3575  CA  VAL C  95     -38.943  12.748   5.310  1.00 61.67           C  
ATOM   3576  C   VAL C  95     -37.536  13.303   5.283  1.00 62.70           C  
ATOM   3577  O   VAL C  95     -37.055  13.797   6.266  1.00 62.92           O  
ATOM   3578  CB  VAL C  95     -38.882  11.256   5.314  1.00 61.53           C  
ATOM   3579  CG1 VAL C  95     -37.799  10.823   6.178  1.00 60.80           C  
ATOM   3580  CG2 VAL C  95     -40.163  10.693   5.782  1.00 60.35           C  
ATOM   3581  N   LYS C  96     -36.888  13.220   4.144  1.00 64.42           N  
ATOM   3582  CA  LYS C  96     -35.543  13.823   3.942  1.00 66.30           C  
ATOM   3583  C   LYS C  96     -35.370  15.292   4.388  1.00 67.40           C  
ATOM   3584  O   LYS C  96     -34.315  15.630   4.936  1.00 67.57           O  
ATOM   3585  CB  LYS C  96     -35.089  13.695   2.481  1.00 66.39           C  
ATOM   3586  CG  LYS C  96     -33.578  13.839   2.256  1.00 67.29           C  
ATOM   3587  CD  LYS C  96     -32.897  12.463   2.151  1.00 68.37           C  
ATOM   3588  CE  LYS C  96     -31.641  12.481   1.247  1.00 68.44           C  
ATOM   3589  NZ  LYS C  96     -30.350  12.617   1.987  1.00 67.38           N  
ATOM   3590  N   PRO C  97     -36.375  16.172   4.129  1.00 68.33           N  
ATOM   3591  CA  PRO C  97     -36.304  17.550   4.613  1.00 69.09           C  
ATOM   3592  C   PRO C  97     -36.453  17.735   6.125  1.00 69.99           C  
ATOM   3593  O   PRO C  97     -36.266  18.848   6.612  1.00 70.00           O  
ATOM   3594  CB  PRO C  97     -37.477  18.222   3.904  1.00 69.38           C  
ATOM   3595  CG  PRO C  97     -38.434  17.147   3.677  1.00 69.02           C  
ATOM   3596  CD  PRO C  97     -37.596  15.964   3.329  1.00 68.27           C  
ATOM   3597  N   GLN C  98     -36.794  16.682   6.865  1.00 71.28           N  
ATOM   3598  CA  GLN C  98     -36.776  16.770   8.327  1.00 72.65           C  
ATOM   3599  C   GLN C  98     -35.353  17.068   8.773  1.00 74.11           C  
ATOM   3600  O   GLN C  98     -35.150  17.902   9.655  1.00 74.29           O  
ATOM   3601  CB  GLN C  98     -37.334  15.513   8.984  1.00 72.26           C  
ATOM   3602  CG  GLN C  98     -38.858  15.472   8.955  1.00 72.56           C  
ATOM   3603  CD  GLN C  98     -39.449  14.118   9.299  1.00 72.12           C  
ATOM   3604  OE1 GLN C  98     -39.039  13.473  10.265  1.00 71.34           O  
ATOM   3605  NE2 GLN C  98     -40.439  13.691   8.512  1.00 71.65           N  
ATOM   3606  N   GLU C  99     -34.383  16.393   8.140  1.00 75.87           N  
ATOM   3607  CA  GLU C  99     -32.956  16.770   8.176  1.00 77.38           C  
ATOM   3608  C   GLU C  99     -32.752  18.131   7.502  1.00 78.25           C  
ATOM   3609  O   GLU C  99     -33.344  18.400   6.451  1.00 78.41           O  
ATOM   3610  CB  GLU C  99     -32.100  15.750   7.417  1.00 77.32           C  
ATOM   3611  CG  GLU C  99     -31.914  14.403   8.089  1.00 77.82           C  
ATOM   3612  CD  GLU C  99     -31.241  13.391   7.171  1.00 77.74           C  
ATOM   3613  OE1 GLU C  99     -30.083  12.991   7.461  1.00 77.82           O  
ATOM   3614  OE2 GLU C  99     -31.870  13.012   6.154  1.00 77.84           O  
ATOM   3615  N   ASN C 100     -31.892  18.962   8.090  1.00 79.18           N  
ATOM   3616  CA  ASN C 100     -31.650  20.323   7.599  1.00 80.03           C  
ATOM   3617  C   ASN C 100     -32.953  21.104   7.366  1.00 80.55           C  
ATOM   3618  O   ASN C 100     -33.431  21.194   6.233  1.00 80.59           O  
ATOM   3619  CB  ASN C 100     -30.774  20.303   6.336  1.00 79.97           C  
ATOM   3620  CG  ASN C 100     -30.372  21.696   5.871  1.00 80.34           C  
ATOM   3621  OD1 ASN C 100     -30.350  21.968   4.672  1.00 80.71           O  
ATOM   3622  ND2 ASN C 100     -30.051  22.582   6.816  1.00 79.86           N  
ATOM   3623  N   PRO C 101     -33.534  21.667   8.445  1.00 81.18           N  
ATOM   3624  CA  PRO C 101     -34.805  22.402   8.329  1.00 81.53           C  
ATOM   3625  C   PRO C 101     -34.613  23.830   7.802  1.00 81.88           C  
ATOM   3626  O   PRO C 101     -35.564  24.425   7.283  1.00 82.04           O  
ATOM   3627  CB  PRO C 101     -35.326  22.428   9.770  1.00 81.54           C  
ATOM   3628  CG  PRO C 101     -34.089  22.398  10.620  1.00 81.37           C  
ATOM   3629  CD  PRO C 101     -33.018  21.663   9.831  1.00 81.25           C  
ATOM   3630  N   ASP C 102     -33.394  24.359   7.949  1.00 82.00           N  
ATOM   3631  CA  ASP C 102     -33.004  25.675   7.432  1.00 82.04           C  
ATOM   3632  C   ASP C 102     -33.122  25.762   5.914  1.00 82.03           C  
ATOM   3633  O   ASP C 102     -33.445  26.818   5.365  1.00 82.10           O  
ATOM   3634  CB  ASP C 102     -31.574  26.015   7.858  1.00 82.00           C  
ATOM   3635  CG  ASP C 102     -31.525  26.869   9.114  1.00 82.22           C  
ATOM   3636  OD1 ASP C 102     -30.397  27.237   9.531  1.00 82.66           O  
ATOM   3637  OD2 ASP C 102     -32.603  27.186   9.675  1.00 81.79           O  
ATOM   3638  N   LEU C 103     -32.839  24.649   5.245  1.00 81.92           N  
ATOM   3639  CA  LEU C 103     -33.114  24.523   3.830  1.00 81.86           C  
ATOM   3640  C   LEU C 103     -34.534  25.039   3.576  1.00 81.79           C  
ATOM   3641  O   LEU C 103     -34.719  25.988   2.812  1.00 81.79           O  
ATOM   3642  CB  LEU C 103     -32.938  23.058   3.386  1.00 81.94           C  
ATOM   3643  CG  LEU C 103     -33.442  22.520   2.039  1.00 81.77           C  
ATOM   3644  CD1 LEU C 103     -32.422  21.575   1.419  1.00 81.63           C  
ATOM   3645  CD2 LEU C 103     -34.794  21.830   2.199  1.00 81.71           C  
ATOM   3646  N   SER C 104     -35.516  24.444   4.259  1.00 81.46           N  
ATOM   3647  CA  SER C 104     -36.930  24.730   4.006  1.00 81.30           C  
ATOM   3648  C   SER C 104     -37.421  26.098   4.502  1.00 81.02           C  
ATOM   3649  O   SER C 104     -38.449  26.587   4.020  1.00 81.09           O  
ATOM   3650  CB  SER C 104     -37.838  23.593   4.511  1.00 81.47           C  
ATOM   3651  OG  SER C 104     -37.488  23.182   5.818  1.00 81.89           O  
ATOM   3652  N   VAL C 105     -36.695  26.710   5.443  1.00 80.63           N  
ATOM   3653  CA  VAL C 105     -36.962  28.104   5.846  1.00 80.11           C  
ATOM   3654  C   VAL C 105     -36.583  29.024   4.687  1.00 80.08           C  
ATOM   3655  O   VAL C 105     -37.183  30.087   4.503  1.00 80.09           O  
ATOM   3656  CB  VAL C 105     -36.196  28.530   7.134  1.00 79.96           C  
ATOM   3657  CG1 VAL C 105     -36.551  29.955   7.533  1.00 79.47           C  
ATOM   3658  CG2 VAL C 105     -36.507  27.602   8.285  1.00 79.81           C  
ATOM   3659  N   ALA C 106     -35.596  28.589   3.905  1.00 79.90           N  
ATOM   3660  CA  ALA C 106     -35.146  29.316   2.723  1.00 79.77           C  
ATOM   3661  C   ALA C 106     -36.129  29.179   1.561  1.00 79.54           C  
ATOM   3662  O   ALA C 106     -36.550  30.183   0.991  1.00 79.41           O  
ATOM   3663  CB  ALA C 106     -33.737  28.873   2.313  1.00 79.76           C  
ATOM   3664  N   LEU C 107     -36.494  27.945   1.211  1.00 79.40           N  
ATOM   3665  CA  LEU C 107     -37.536  27.724   0.213  1.00 79.33           C  
ATOM   3666  C   LEU C 107     -38.648  28.744   0.404  1.00 78.96           C  
ATOM   3667  O   LEU C 107     -39.012  29.442  -0.539  1.00 79.19           O  
ATOM   3668  CB  LEU C 107     -38.106  26.306   0.302  1.00 79.72           C  
ATOM   3669  CG  LEU C 107     -37.686  25.219  -0.711  1.00 81.12           C  
ATOM   3670  CD1 LEU C 107     -38.757  24.921  -1.783  1.00 81.27           C  
ATOM   3671  CD2 LEU C 107     -36.312  25.487  -1.359  1.00 81.75           C  
ATOM   3672  N   LEU C 108     -39.155  28.854   1.631  1.00 78.20           N  
ATOM   3673  CA  LEU C 108     -40.225  29.796   1.939  1.00 77.64           C  
ATOM   3674  C   LEU C 108     -39.811  31.267   1.738  1.00 77.32           C  
ATOM   3675  O   LEU C 108     -40.596  32.073   1.227  1.00 77.10           O  
ATOM   3676  CB  LEU C 108     -40.738  29.578   3.363  1.00 77.76           C  
ATOM   3677  CG  LEU C 108     -42.256  29.537   3.619  1.00 77.88           C  
ATOM   3678  CD1 LEU C 108     -42.605  30.404   4.820  1.00 77.38           C  
ATOM   3679  CD2 LEU C 108     -43.093  29.955   2.408  1.00 77.82           C  
ATOM   3680  N   GLU C 109     -38.589  31.616   2.139  1.00 76.76           N  
ATOM   3681  CA  GLU C 109     -38.037  32.931   1.836  1.00 76.20           C  
ATOM   3682  C   GLU C 109     -38.137  33.175   0.336  1.00 75.78           C  
ATOM   3683  O   GLU C 109     -38.697  34.182  -0.095  1.00 75.62           O  
ATOM   3684  CB  GLU C 109     -36.572  33.027   2.265  1.00 76.40           C  
ATOM   3685  CG  GLU C 109     -36.284  32.729   3.729  1.00 76.71           C  
ATOM   3686  CD  GLU C 109     -36.776  33.810   4.673  1.00 77.13           C  
ATOM   3687  OE1 GLU C 109     -36.453  34.999   4.462  1.00 76.50           O  
ATOM   3688  OE2 GLU C 109     -37.483  33.458   5.638  1.00 78.17           O  
HETATM 3689  N   MSE C 110     -37.607  32.228  -0.438  1.00 75.41           N  
HETATM 3690  CA  MSE C 110     -37.581  32.275  -1.905  1.00 75.15           C  
HETATM 3691  C   MSE C 110     -38.977  32.351  -2.509  1.00 74.43           C  
HETATM 3692  O   MSE C 110     -39.283  33.239  -3.308  1.00 74.11           O  
HETATM 3693  CB  MSE C 110     -36.858  31.036  -2.459  1.00 75.85           C  
HETATM 3694  CG  MSE C 110     -35.446  30.857  -1.957  1.00 76.54           C  
HETATM 3695 SE   MSE C 110     -34.464  32.421  -2.492  1.00 82.21          SE  
HETATM 3696  CE  MSE C 110     -33.089  32.518  -1.098  1.00 78.63           C  
ATOM   3697  N   ARG C 111     -39.813  31.398  -2.114  1.00 73.74           N  
ATOM   3698  CA  ARG C 111     -41.188  31.293  -2.586  1.00 73.28           C  
ATOM   3699  C   ARG C 111     -41.996  32.534  -2.275  1.00 72.53           C  
ATOM   3700  O   ARG C 111     -42.939  32.860  -2.995  1.00 72.71           O  
ATOM   3701  CB  ARG C 111     -41.865  30.118  -1.919  1.00 73.29           C  
ATOM   3702  CG  ARG C 111     -41.788  28.815  -2.658  1.00 75.12           C  
ATOM   3703  CD  ARG C 111     -42.837  27.910  -2.038  1.00 78.23           C  
ATOM   3704  NE  ARG C 111     -43.120  26.705  -2.793  1.00 80.40           N  
ATOM   3705  CZ  ARG C 111     -42.654  25.503  -2.471  1.00 83.26           C  
ATOM   3706  NH1 ARG C 111     -41.859  25.358  -1.412  1.00 84.53           N  
ATOM   3707  NH2 ARG C 111     -42.981  24.443  -3.206  1.00 83.54           N  
ATOM   3708  N   SER C 112     -41.641  33.202  -1.181  1.00 71.47           N  
ATOM   3709  CA  SER C 112     -42.313  34.420  -0.772  1.00 70.36           C  
ATOM   3710  C   SER C 112     -42.011  35.564  -1.730  1.00 69.57           C  
ATOM   3711  O   SER C 112     -42.887  36.379  -2.007  1.00 69.68           O  
ATOM   3712  CB  SER C 112     -41.907  34.802   0.647  1.00 70.48           C  
ATOM   3713  OG  SER C 112     -42.370  36.099   0.976  1.00 70.82           O  
ATOM   3714  N   GLN C 113     -40.778  35.620  -2.232  1.00 68.31           N  
ATOM   3715  CA  GLN C 113     -40.348  36.717  -3.096  1.00 67.11           C  
ATOM   3716  C   GLN C 113     -40.706  36.466  -4.566  1.00 66.16           C  
ATOM   3717  O   GLN C 113     -40.461  37.315  -5.428  1.00 66.10           O  
ATOM   3718  CB  GLN C 113     -38.847  37.003  -2.908  1.00 67.01           C  
ATOM   3719  CG  GLN C 113     -38.479  37.509  -1.503  1.00 67.11           C  
ATOM   3720  CD  GLN C 113     -37.022  37.976  -1.360  1.00 67.75           C  
ATOM   3721  OE1 GLN C 113     -36.470  38.650  -2.241  1.00 68.73           O  
ATOM   3722  NE2 GLN C 113     -36.407  37.642  -0.228  1.00 68.11           N  
ATOM   3723  N   ALA C 114     -41.306  35.306  -4.838  1.00 65.16           N  
ATOM   3724  CA  ALA C 114     -41.682  34.900  -6.202  1.00 63.93           C  
ATOM   3725  C   ALA C 114     -42.674  35.836  -6.909  1.00 63.06           C  
ATOM   3726  O   ALA C 114     -42.435  36.208  -8.057  1.00 63.04           O  
ATOM   3727  CB  ALA C 114     -42.202  33.466  -6.217  1.00 63.86           C  
ATOM   3728  N   PRO C 115     -43.783  36.221  -6.240  1.00 62.12           N  
ATOM   3729  CA  PRO C 115     -44.758  37.093  -6.900  1.00 61.38           C  
ATOM   3730  C   PRO C 115     -44.182  38.447  -7.271  1.00 60.58           C  
ATOM   3731  O   PRO C 115     -44.875  39.269  -7.863  1.00 60.25           O  
ATOM   3732  CB  PRO C 115     -45.843  37.274  -5.835  1.00 61.29           C  
ATOM   3733  CG  PRO C 115     -45.687  36.113  -4.938  1.00 61.78           C  
ATOM   3734  CD  PRO C 115     -44.223  35.878  -4.877  1.00 62.06           C  
ATOM   3735  N   TYR C 116     -42.917  38.662  -6.929  1.00 60.01           N  
ATOM   3736  CA  TYR C 116     -42.253  39.933  -7.179  1.00 59.43           C  
ATOM   3737  C   TYR C 116     -40.995  39.794  -8.038  1.00 59.24           C  
ATOM   3738  O   TYR C 116     -40.425  40.794  -8.483  1.00 58.99           O  
ATOM   3739  CB  TYR C 116     -41.956  40.642  -5.854  1.00 59.24           C  
ATOM   3740  CG  TYR C 116     -43.209  40.900  -5.064  1.00 58.97           C  
ATOM   3741  CD1 TYR C 116     -43.527  40.113  -3.959  1.00 59.07           C  
ATOM   3742  CD2 TYR C 116     -44.102  41.907  -5.445  1.00 58.75           C  
ATOM   3743  CE1 TYR C 116     -44.698  40.325  -3.241  1.00 59.29           C  
ATOM   3744  CE2 TYR C 116     -45.269  42.141  -4.732  1.00 59.03           C  
ATOM   3745  CZ  TYR C 116     -45.565  41.342  -3.629  1.00 59.88           C  
ATOM   3746  OH  TYR C 116     -46.722  41.555  -2.912  1.00 59.96           O  
ATOM   3747  N   LYS C 117     -40.565  38.559  -8.275  1.00 58.86           N  
ATOM   3748  CA  LYS C 117     -39.392  38.332  -9.106  1.00 58.77           C  
ATOM   3749  C   LYS C 117     -39.685  37.446 -10.318  1.00 58.87           C  
ATOM   3750  O   LYS C 117     -40.163  36.313 -10.187  1.00 58.81           O  
ATOM   3751  CB  LYS C 117     -38.214  37.796  -8.282  1.00 58.71           C  
ATOM   3752  CG  LYS C 117     -37.669  38.759  -7.214  1.00 58.37           C  
ATOM   3753  CD  LYS C 117     -37.128  40.073  -7.785  1.00 57.94           C  
ATOM   3754  CE  LYS C 117     -35.651  39.986  -8.169  1.00 57.63           C  
ATOM   3755  NZ  LYS C 117     -35.071  41.337  -8.431  1.00 55.91           N  
ATOM   3756  N   GLU C 118     -39.405  38.003 -11.493  1.00 58.93           N  
ATOM   3757  CA  GLU C 118     -39.518  37.314 -12.768  1.00 59.02           C  
ATOM   3758  C   GLU C 118     -38.857  35.939 -12.674  1.00 58.69           C  
ATOM   3759  O   GLU C 118     -39.540  34.913 -12.682  1.00 58.84           O  
ATOM   3760  CB  GLU C 118     -38.838  38.162 -13.855  1.00 59.54           C  
ATOM   3761  CG  GLU C 118     -39.195  37.804 -15.299  1.00 60.91           C  
ATOM   3762  CD  GLU C 118     -40.616  38.207 -15.659  1.00 62.58           C  
ATOM   3763  OE1 GLU C 118     -41.564  37.459 -15.290  1.00 62.25           O  
ATOM   3764  OE2 GLU C 118     -40.772  39.272 -16.309  1.00 62.16           O  
ATOM   3765  N   ALA C 119     -37.528  35.948 -12.553  1.00 58.12           N  
ATOM   3766  CA  ALA C 119     -36.697  34.745 -12.469  1.00 57.54           C  
ATOM   3767  C   ALA C 119     -37.245  33.694 -11.513  1.00 57.23           C  
ATOM   3768  O   ALA C 119     -37.489  32.555 -11.901  1.00 57.11           O  
ATOM   3769  CB  ALA C 119     -35.286  35.127 -12.054  1.00 57.38           C  
ATOM   3770  N   PHE C 120     -37.429  34.098 -10.263  1.00 56.89           N  
ATOM   3771  CA  PHE C 120     -37.830  33.205  -9.190  1.00 56.82           C  
ATOM   3772  C   PHE C 120     -39.110  32.449  -9.519  1.00 56.55           C  
ATOM   3773  O   PHE C 120     -39.138  31.224  -9.486  1.00 56.18           O  
ATOM   3774  CB  PHE C 120     -37.999  34.007  -7.896  1.00 57.01           C  
ATOM   3775  CG  PHE C 120     -36.700  34.392  -7.246  1.00 56.77           C  
ATOM   3776  CD1 PHE C 120     -35.761  35.145  -7.925  1.00 56.41           C  
ATOM   3777  CD2 PHE C 120     -36.424  33.999  -5.944  1.00 57.28           C  
ATOM   3778  CE1 PHE C 120     -34.559  35.500  -7.321  1.00 57.10           C  
ATOM   3779  CE2 PHE C 120     -35.223  34.347  -5.333  1.00 57.12           C  
ATOM   3780  CZ  PHE C 120     -34.291  35.100  -6.023  1.00 57.15           C  
ATOM   3781  N   SER C 121     -40.151  33.199  -9.859  1.00 56.61           N  
ATOM   3782  CA  SER C 121     -41.453  32.646 -10.176  1.00 56.69           C  
ATOM   3783  C   SER C 121     -41.375  31.529 -11.225  1.00 57.20           C  
ATOM   3784  O   SER C 121     -41.648  30.362 -10.915  1.00 57.25           O  
ATOM   3785  CB  SER C 121     -42.395  33.758 -10.637  1.00 56.53           C  
ATOM   3786  OG  SER C 121     -43.730  33.304 -10.691  1.00 55.80           O  
ATOM   3787  N   ASP C 122     -40.995  31.868 -12.456  1.00 57.57           N  
ATOM   3788  CA  ASP C 122     -41.026  30.860 -13.518  1.00 58.08           C  
ATOM   3789  C   ASP C 122     -40.055  29.703 -13.249  1.00 57.81           C  
ATOM   3790  O   ASP C 122     -40.296  28.577 -13.713  1.00 57.86           O  
ATOM   3791  CB  ASP C 122     -40.860  31.476 -14.913  1.00 58.11           C  
ATOM   3792  CG  ASP C 122     -39.552  32.191 -15.077  1.00 59.89           C  
ATOM   3793  OD1 ASP C 122     -39.513  33.270 -15.719  1.00 60.36           O  
ATOM   3794  OD2 ASP C 122     -38.547  31.665 -14.558  1.00 62.50           O  
ATOM   3795  N   ARG C 123     -38.992  29.964 -12.480  1.00 57.35           N  
ATOM   3796  CA  ARG C 123     -38.118  28.882 -12.009  1.00 57.28           C  
ATOM   3797  C   ARG C 123     -38.886  27.885 -11.150  1.00 57.35           C  
ATOM   3798  O   ARG C 123     -38.795  26.677 -11.373  1.00 57.77           O  
ATOM   3799  CB  ARG C 123     -36.885  29.404 -11.267  1.00 57.34           C  
ATOM   3800  CG  ARG C 123     -35.557  29.217 -12.007  1.00 57.43           C  
ATOM   3801  CD  ARG C 123     -35.582  29.883 -13.378  1.00 59.01           C  
ATOM   3802  NE  ARG C 123     -34.245  30.092 -13.941  1.00 59.84           N  
ATOM   3803  CZ  ARG C 123     -33.559  31.233 -13.871  1.00 59.02           C  
ATOM   3804  NH1 ARG C 123     -34.074  32.292 -13.260  1.00 58.24           N  
ATOM   3805  NH2 ARG C 123     -32.353  31.312 -14.415  1.00 58.57           N  
ATOM   3806  N   PHE C 124     -39.665  28.395 -10.197  1.00 57.04           N  
ATOM   3807  CA  PHE C 124     -40.525  27.560  -9.370  1.00 56.41           C  
ATOM   3808  C   PHE C 124     -41.556  26.776 -10.180  1.00 56.92           C  
ATOM   3809  O   PHE C 124     -41.801  25.615  -9.876  1.00 56.81           O  
ATOM   3810  CB  PHE C 124     -41.238  28.393  -8.288  1.00 55.89           C  
ATOM   3811  CG  PHE C 124     -40.408  28.642  -7.059  1.00 54.49           C  
ATOM   3812  CD1 PHE C 124     -39.952  27.586  -6.279  1.00 53.42           C  
ATOM   3813  CD2 PHE C 124     -40.083  29.941  -6.672  1.00 54.33           C  
ATOM   3814  CE1 PHE C 124     -39.179  27.808  -5.136  1.00 52.90           C  
ATOM   3815  CE2 PHE C 124     -39.307  30.179  -5.532  1.00 53.72           C  
ATOM   3816  CZ  PHE C 124     -38.862  29.104  -4.759  1.00 54.20           C  
ATOM   3817  N   ARG C 125     -42.176  27.423 -11.172  1.00 57.89           N  
ATOM   3818  CA  ARG C 125     -43.214  26.801 -12.032  1.00 58.97           C  
ATOM   3819  C   ARG C 125     -42.671  25.605 -12.809  1.00 59.08           C  
ATOM   3820  O   ARG C 125     -43.236  24.496 -12.797  1.00 59.85           O  
ATOM   3821  CB  ARG C 125     -43.822  27.825 -13.011  1.00 59.07           C  
ATOM   3822  CG  ARG C 125     -44.754  28.836 -12.328  1.00 61.59           C  
ATOM   3823  CD  ARG C 125     -45.742  29.491 -13.300  1.00 64.43           C  
ATOM   3824  NE  ARG C 125     -45.327  30.864 -13.633  1.00 68.81           N  
ATOM   3825  CZ  ARG C 125     -45.714  31.971 -12.988  1.00 69.58           C  
ATOM   3826  NH1 ARG C 125     -46.555  31.897 -11.960  1.00 70.94           N  
ATOM   3827  NH2 ARG C 125     -45.257  33.164 -13.375  1.00 69.31           N  
ATOM   3828  N   GLN C 126     -41.556  25.840 -13.475  1.00 59.05           N  
ATOM   3829  CA  GLN C 126     -40.889  24.815 -14.237  1.00 58.98           C  
ATOM   3830  C   GLN C 126     -40.503  23.658 -13.298  1.00 58.81           C  
ATOM   3831  O   GLN C 126     -40.818  22.511 -13.581  1.00 58.87           O  
ATOM   3832  CB  GLN C 126     -39.706  25.461 -14.977  1.00 59.25           C  
ATOM   3833  CG  GLN C 126     -39.007  24.612 -15.999  1.00 59.34           C  
ATOM   3834  CD  GLN C 126     -37.666  24.146 -15.485  1.00 60.11           C  
ATOM   3835  OE1 GLN C 126     -37.583  23.517 -14.427  1.00 59.70           O  
ATOM   3836  NE2 GLN C 126     -36.597  24.472 -16.218  1.00 59.73           N  
ATOM   3837  N   ASN C 127     -39.878  23.959 -12.163  1.00 58.65           N  
ATOM   3838  CA  ASN C 127     -39.579  22.936 -11.159  1.00 58.72           C  
ATOM   3839  C   ASN C 127     -40.824  22.171 -10.683  1.00 58.91           C  
ATOM   3840  O   ASN C 127     -40.778  20.952 -10.488  1.00 58.69           O  
ATOM   3841  CB  ASN C 127     -38.849  23.559  -9.971  1.00 58.68           C  
ATOM   3842  CG  ASN C 127     -38.537  22.549  -8.864  1.00 59.29           C  
ATOM   3843  OD1 ASN C 127     -37.380  22.207  -8.634  1.00 60.80           O  
ATOM   3844  ND2 ASN C 127     -39.567  22.080  -8.171  1.00 58.36           N  
ATOM   3845  N   ASP C 128     -41.927  22.890 -10.493  1.00 59.42           N  
ATOM   3846  CA  ASP C 128     -43.184  22.276 -10.066  1.00 59.98           C  
ATOM   3847  C   ASP C 128     -43.783  21.407 -11.163  1.00 60.87           C  
ATOM   3848  O   ASP C 128     -44.493  20.454 -10.871  1.00 60.45           O  
ATOM   3849  CB  ASP C 128     -44.218  23.323  -9.669  1.00 59.42           C  
ATOM   3850  CG  ASP C 128     -45.515  22.694  -9.198  1.00 59.41           C  
ATOM   3851  OD1 ASP C 128     -45.514  22.098  -8.101  1.00 60.67           O  
ATOM   3852  OD2 ASP C 128     -46.526  22.768  -9.922  1.00 58.51           O  
ATOM   3853  N   GLU C 129     -43.540  21.791 -12.419  1.00 61.90           N  
ATOM   3854  CA  GLU C 129     -43.940  21.002 -13.576  1.00 62.98           C  
ATOM   3855  C   GLU C 129     -43.233  19.644 -13.621  1.00 62.77           C  
ATOM   3856  O   GLU C 129     -43.839  18.626 -13.976  1.00 62.88           O  
ATOM   3857  CB  GLU C 129     -43.594  21.758 -14.843  1.00 63.35           C  
ATOM   3858  CG  GLU C 129     -44.749  22.267 -15.652  1.00 67.20           C  
ATOM   3859  CD  GLU C 129     -44.394  22.341 -17.151  1.00 72.95           C  
ATOM   3860  OE1 GLU C 129     -45.333  22.458 -17.981  1.00 76.41           O  
ATOM   3861  OE2 GLU C 129     -43.184  22.267 -17.515  1.00 73.32           O  
ATOM   3862  N   TYR C 130     -41.947  19.638 -13.285  1.00 62.86           N  
ATOM   3863  CA  TYR C 130     -41.146  18.439 -13.434  1.00 63.12           C  
ATOM   3864  C   TYR C 130     -41.499  17.487 -12.281  1.00 62.08           C  
ATOM   3865  O   TYR C 130     -41.639  16.272 -12.482  1.00 62.19           O  
ATOM   3866  CB  TYR C 130     -39.617  18.731 -13.570  1.00 64.80           C  
ATOM   3867  CG  TYR C 130     -38.789  17.537 -13.169  1.00 67.30           C  
ATOM   3868  CD1 TYR C 130     -38.025  16.794 -14.091  1.00 69.36           C  
ATOM   3869  CD2 TYR C 130     -38.840  17.100 -11.846  1.00 70.37           C  
ATOM   3870  CE1 TYR C 130     -37.314  15.637 -13.656  1.00 70.95           C  
ATOM   3871  CE2 TYR C 130     -38.184  15.981 -11.409  1.00 71.27           C  
ATOM   3872  CZ  TYR C 130     -37.426  15.254 -12.279  1.00 71.45           C  
ATOM   3873  OH  TYR C 130     -36.831  14.165 -11.676  1.00 71.53           O  
ATOM   3874  N   VAL C 131     -41.664  18.035 -11.083  1.00 60.34           N  
ATOM   3875  CA  VAL C 131     -42.082  17.229  -9.952  1.00 58.83           C  
ATOM   3876  C   VAL C 131     -43.465  16.652 -10.220  1.00 58.61           C  
ATOM   3877  O   VAL C 131     -43.708  15.499  -9.943  1.00 59.00           O  
ATOM   3878  CB  VAL C 131     -42.048  18.025  -8.629  1.00 58.78           C  
ATOM   3879  CG1 VAL C 131     -42.644  17.233  -7.492  1.00 57.05           C  
ATOM   3880  CG2 VAL C 131     -40.638  18.374  -8.283  1.00 58.22           C  
ATOM   3881  N   ARG C 132     -44.369  17.431 -10.786  1.00 58.43           N  
ATOM   3882  CA  ARG C 132     -45.675  16.904 -11.174  1.00 59.08           C  
ATOM   3883  C   ARG C 132     -45.499  15.783 -12.213  1.00 58.63           C  
ATOM   3884  O   ARG C 132     -46.213  14.781 -12.196  1.00 58.49           O  
ATOM   3885  CB  ARG C 132     -46.586  18.011 -11.718  1.00 58.26           C  
ATOM   3886  CG  ARG C 132     -47.208  18.876 -10.628  1.00 61.18           C  
ATOM   3887  CD  ARG C 132     -48.060  20.078 -11.142  1.00 61.66           C  
ATOM   3888  NE  ARG C 132     -48.933  19.630 -12.213  1.00 66.09           N  
ATOM   3889  CZ  ARG C 132     -48.832  20.033 -13.472  1.00 69.99           C  
ATOM   3890  NH1 ARG C 132     -47.921  20.956 -13.829  1.00 71.37           N  
ATOM   3891  NH2 ARG C 132     -49.671  19.532 -14.373  1.00 71.60           N  
ATOM   3892  N   TYR C 133     -44.542  15.945 -13.116  1.00 57.85           N  
ATOM   3893  CA  TYR C 133     -44.324  14.913 -14.102  1.00 57.61           C  
ATOM   3894  C   TYR C 133     -43.848  13.619 -13.458  1.00 57.66           C  
ATOM   3895  O   TYR C 133     -44.403  12.553 -13.736  1.00 57.99           O  
ATOM   3896  CB  TYR C 133     -43.317  15.364 -15.177  1.00 57.45           C  
ATOM   3897  CG  TYR C 133     -42.960  14.291 -16.186  1.00 56.05           C  
ATOM   3898  CD1 TYR C 133     -43.600  14.230 -17.419  1.00 56.15           C  
ATOM   3899  CD2 TYR C 133     -41.976  13.347 -15.910  1.00 54.63           C  
ATOM   3900  CE1 TYR C 133     -43.274  13.248 -18.358  1.00 55.64           C  
ATOM   3901  CE2 TYR C 133     -41.638  12.373 -16.841  1.00 55.10           C  
ATOM   3902  CZ  TYR C 133     -42.299  12.320 -18.057  1.00 55.44           C  
ATOM   3903  OH  TYR C 133     -41.971  11.341 -18.977  1.00 57.72           O  
HETATM 3904  N   MSE C 134     -42.811  13.700 -12.625  1.00 57.21           N  
HETATM 3905  CA  MSE C 134     -42.207  12.507 -12.066  0.50 57.61           C  
HETATM 3907  C   MSE C 134     -43.199  11.807 -11.154  1.00 57.51           C  
HETATM 3908  O   MSE C 134     -43.294  10.587 -11.135  1.00 58.18           O  
HETATM 3909  CB  MSE C 134     -40.905  12.834 -11.335  0.50 57.48           C  
HETATM 3911  CG  MSE C 134     -41.073  13.665 -10.090  0.50 58.02           C  
HETATM 3913 SE   MSE C 134     -39.479  13.712  -8.974  0.25 58.81          SE  
HETATM 3915  CE  MSE C 134     -40.262  14.528  -7.392  0.50 58.29           C  
ATOM   3917  N   LEU C 135     -43.963  12.594 -10.422  1.00 57.51           N  
ATOM   3918  CA  LEU C 135     -44.947  12.046  -9.532  1.00 57.57           C  
ATOM   3919  C   LEU C 135     -46.123  11.413 -10.294  1.00 57.14           C  
ATOM   3920  O   LEU C 135     -46.654  10.388  -9.900  1.00 57.26           O  
ATOM   3921  CB  LEU C 135     -45.462  13.147  -8.605  1.00 58.01           C  
ATOM   3922  CG  LEU C 135     -45.374  12.869  -7.117  1.00 58.86           C  
ATOM   3923  CD1 LEU C 135     -46.537  13.503  -6.434  1.00 58.70           C  
ATOM   3924  CD2 LEU C 135     -45.336  11.353  -6.861  1.00 60.00           C  
ATOM   3925  N   LYS C 136     -46.552  12.029 -11.380  1.00 56.73           N  
ATOM   3926  CA  LYS C 136     -47.689  11.486 -12.110  1.00 56.19           C  
ATOM   3927  C   LYS C 136     -47.272  10.276 -12.900  1.00 55.52           C  
ATOM   3928  O   LYS C 136     -48.053   9.360 -13.070  1.00 55.97           O  
ATOM   3929  CB  LYS C 136     -48.305  12.543 -13.001  1.00 56.10           C  
ATOM   3930  CG  LYS C 136     -49.294  12.081 -14.003  1.00 55.65           C  
ATOM   3931  CD  LYS C 136     -49.293  13.133 -15.087  1.00 57.56           C  
ATOM   3932  CE  LYS C 136     -49.895  12.630 -16.344  1.00 58.97           C  
ATOM   3933  NZ  LYS C 136     -49.193  13.166 -17.500  1.00 58.23           N  
ATOM   3934  N   ALA C 137     -46.031  10.249 -13.358  1.00 54.89           N  
ATOM   3935  CA  ALA C 137     -45.504   9.027 -13.955  1.00 54.35           C  
ATOM   3936  C   ALA C 137     -45.667   7.802 -13.040  1.00 54.24           C  
ATOM   3937  O   ALA C 137     -46.083   6.754 -13.515  1.00 54.20           O  
ATOM   3938  CB  ALA C 137     -44.065   9.208 -14.391  1.00 54.13           C  
ATOM   3939  N   VAL C 138     -45.387   7.916 -11.735  1.00 54.13           N  
ATOM   3940  CA  VAL C 138     -45.499   6.722 -10.883  1.00 54.22           C  
ATOM   3941  C   VAL C 138     -46.942   6.262 -10.675  1.00 54.01           C  
ATOM   3942  O   VAL C 138     -47.240   5.061 -10.714  1.00 53.95           O  
ATOM   3943  CB  VAL C 138     -44.731   6.822  -9.541  1.00 54.62           C  
ATOM   3944  CG1 VAL C 138     -45.322   7.853  -8.640  1.00 54.73           C  
ATOM   3945  CG2 VAL C 138     -44.727   5.456  -8.826  1.00 55.32           C  
ATOM   3946  N   ILE C 139     -47.834   7.222 -10.495  1.00 53.55           N  
ATOM   3947  CA  ILE C 139     -49.265   6.940 -10.431  1.00 53.82           C  
ATOM   3948  C   ILE C 139     -49.790   6.263 -11.710  1.00 54.17           C  
ATOM   3949  O   ILE C 139     -50.563   5.313 -11.628  1.00 54.71           O  
ATOM   3950  CB  ILE C 139     -50.071   8.221 -10.114  1.00 54.06           C  
ATOM   3951  CG1 ILE C 139     -49.667   8.738  -8.732  1.00 53.26           C  
ATOM   3952  CG2 ILE C 139     -51.575   7.971 -10.235  1.00 52.54           C  
ATOM   3953  CD1 ILE C 139     -50.383   9.976  -8.347  1.00 55.40           C  
ATOM   3954  N   ASN C 140     -49.362   6.743 -12.879  1.00 54.13           N  
ATOM   3955  CA  ASN C 140     -49.714   6.118 -14.152  1.00 53.88           C  
ATOM   3956  C   ASN C 140     -49.095   4.710 -14.292  1.00 54.29           C  
ATOM   3957  O   ASN C 140     -49.635   3.834 -14.989  1.00 54.92           O  
ATOM   3958  CB  ASN C 140     -49.279   7.012 -15.329  1.00 53.72           C  
ATOM   3959  CG  ASN C 140     -50.313   8.104 -15.692  1.00 54.05           C  
ATOM   3960  OD1 ASN C 140     -51.479   8.076 -15.265  1.00 54.75           O  
ATOM   3961  ND2 ASN C 140     -49.880   9.062 -16.509  1.00 52.34           N  
ATOM   3962  N   HIS C 141     -47.947   4.485 -13.659  1.00 54.00           N  
ATOM   3963  CA  HIS C 141     -47.289   3.201 -13.805  1.00 53.65           C  
ATOM   3964  C   HIS C 141     -48.118   2.199 -13.013  1.00 53.94           C  
ATOM   3965  O   HIS C 141     -48.573   1.173 -13.528  1.00 53.42           O  
ATOM   3966  CB  HIS C 141     -45.870   3.295 -13.274  1.00 53.42           C  
ATOM   3967  CG  HIS C 141     -45.082   2.045 -13.447  1.00 53.13           C  
ATOM   3968  ND1 HIS C 141     -44.901   1.446 -14.675  1.00 54.58           N  
ATOM   3969  CD2 HIS C 141     -44.431   1.271 -12.552  1.00 54.06           C  
ATOM   3970  CE1 HIS C 141     -44.168   0.356 -14.531  1.00 54.34           C  
ATOM   3971  NE2 HIS C 141     -43.874   0.222 -13.249  1.00 55.39           N  
ATOM   3972  N   GLY C 142     -48.348   2.555 -11.753  1.00 54.49           N  
ATOM   3973  CA  GLY C 142     -49.206   1.813 -10.873  1.00 54.56           C  
ATOM   3974  C   GLY C 142     -50.493   1.413 -11.539  1.00 54.93           C  
ATOM   3975  O   GLY C 142     -50.867   0.240 -11.478  1.00 55.09           O  
ATOM   3976  N   ILE C 143     -51.159   2.369 -12.180  1.00 54.58           N  
ATOM   3977  CA  ILE C 143     -52.394   2.060 -12.870  1.00 55.19           C  
ATOM   3978  C   ILE C 143     -52.182   0.917 -13.893  1.00 56.17           C  
ATOM   3979  O   ILE C 143     -52.739  -0.171 -13.722  1.00 56.05           O  
ATOM   3980  CB  ILE C 143     -53.065   3.322 -13.483  1.00 55.10           C  
ATOM   3981  CG1 ILE C 143     -53.467   4.316 -12.381  1.00 55.07           C  
ATOM   3982  CG2 ILE C 143     -54.325   2.948 -14.283  1.00 55.09           C  
ATOM   3983  CD1 ILE C 143     -54.096   5.594 -12.904  1.00 55.04           C  
ATOM   3984  N   ASP C 144     -51.372   1.155 -14.928  1.00 57.23           N  
ATOM   3985  CA  ASP C 144     -51.048   0.137 -15.922  1.00 58.31           C  
ATOM   3986  C   ASP C 144     -50.776  -1.210 -15.263  1.00 58.89           C  
ATOM   3987  O   ASP C 144     -51.417  -2.200 -15.584  1.00 59.05           O  
ATOM   3988  CB  ASP C 144     -49.845   0.563 -16.770  1.00 58.73           C  
ATOM   3989  CG  ASP C 144     -50.126   1.806 -17.599  1.00 60.63           C  
ATOM   3990  OD1 ASP C 144     -51.284   1.967 -18.033  1.00 63.57           O  
ATOM   3991  OD2 ASP C 144     -49.204   2.618 -17.823  1.00 61.28           O  
ATOM   3992  N   GLU C 145     -49.853  -1.233 -14.313  1.00 59.60           N  
ATOM   3993  CA  GLU C 145     -49.516  -2.444 -13.587  1.00 60.21           C  
ATOM   3994  C   GLU C 145     -50.718  -3.100 -12.896  1.00 60.19           C  
ATOM   3995  O   GLU C 145     -50.734  -4.306 -12.721  1.00 61.09           O  
ATOM   3996  CB  GLU C 145     -48.457  -2.108 -12.541  1.00 60.77           C  
ATOM   3997  CG  GLU C 145     -47.441  -3.181 -12.270  1.00 63.08           C  
ATOM   3998  CD  GLU C 145     -46.247  -3.100 -13.202  1.00 67.11           C  
ATOM   3999  OE1 GLU C 145     -46.431  -3.080 -14.442  1.00 66.35           O  
ATOM   4000  OE2 GLU C 145     -45.110  -3.071 -12.679  1.00 70.31           O  
ATOM   4001  N   GLY C 146     -51.716  -2.324 -12.493  1.00 60.14           N  
ATOM   4002  CA  GLY C 146     -52.864  -2.873 -11.775  1.00 60.09           C  
ATOM   4003  C   GLY C 146     -52.857  -2.625 -10.276  1.00 60.76           C  
ATOM   4004  O   GLY C 146     -53.841  -2.895  -9.605  1.00 61.20           O  
ATOM   4005  N   VAL C 147     -51.762  -2.082  -9.743  1.00 60.85           N  
ATOM   4006  CA  VAL C 147     -51.605  -1.883  -8.293  1.00 60.10           C  
ATOM   4007  C   VAL C 147     -52.370  -0.654  -7.812  1.00 59.61           C  
ATOM   4008  O   VAL C 147     -52.651  -0.514  -6.623  1.00 59.92           O  
ATOM   4009  CB  VAL C 147     -50.092  -1.817  -7.887  1.00 60.46           C  
ATOM   4010  CG1 VAL C 147     -49.886  -1.277  -6.469  1.00 60.02           C  
ATOM   4011  CG2 VAL C 147     -49.451  -3.207  -8.008  1.00 60.56           C  
ATOM   4012  N   PHE C 148     -52.721   0.233  -8.730  1.00 58.62           N  
ATOM   4013  CA  PHE C 148     -53.518   1.400  -8.373  1.00 57.59           C  
ATOM   4014  C   PHE C 148     -54.799   1.376  -9.170  1.00 57.28           C  
ATOM   4015  O   PHE C 148     -54.824   0.886 -10.279  1.00 57.61           O  
ATOM   4016  CB  PHE C 148     -52.757   2.694  -8.684  1.00 57.39           C  
ATOM   4017  CG  PHE C 148     -51.477   2.878  -7.883  1.00 56.73           C  
ATOM   4018  CD1 PHE C 148     -51.332   2.332  -6.611  1.00 56.59           C  
ATOM   4019  CD2 PHE C 148     -50.444   3.652  -8.387  1.00 55.75           C  
ATOM   4020  CE1 PHE C 148     -50.164   2.521  -5.889  1.00 54.39           C  
ATOM   4021  CE2 PHE C 148     -49.275   3.841  -7.663  1.00 54.07           C  
ATOM   4022  CZ  PHE C 148     -49.140   3.273  -6.422  1.00 54.60           C  
ATOM   4023  N   THR C 149     -55.866   1.892  -8.598  1.00 57.25           N  
ATOM   4024  CA  THR C 149     -57.130   2.066  -9.303  1.00 57.44           C  
ATOM   4025  C   THR C 149     -56.982   3.179 -10.333  1.00 57.38           C  
ATOM   4026  O   THR C 149     -56.198   4.103 -10.120  1.00 57.94           O  
ATOM   4027  CB  THR C 149     -58.215   2.500  -8.292  1.00 57.60           C  
ATOM   4028  OG1 THR C 149     -58.073   1.722  -7.102  1.00 57.75           O  
ATOM   4029  CG2 THR C 149     -59.628   2.311  -8.858  1.00 57.92           C  
ATOM   4030  N   ASP C 150     -57.737   3.111 -11.429  1.00 56.90           N  
ATOM   4031  CA  ASP C 150     -57.781   4.201 -12.396  1.00 57.00           C  
ATOM   4032  C   ASP C 150     -58.341   5.445 -11.743  1.00 57.20           C  
ATOM   4033  O   ASP C 150     -59.339   5.393 -11.026  1.00 58.15           O  
ATOM   4034  CB  ASP C 150     -58.645   3.850 -13.599  1.00 57.06           C  
ATOM   4035  CG  ASP C 150     -58.216   4.582 -14.867  1.00 58.57           C  
ATOM   4036  OD1 ASP C 150     -57.560   5.670 -14.807  1.00 58.60           O  
ATOM   4037  OD2 ASP C 150     -58.537   4.042 -15.949  1.00 60.93           O  
ATOM   4038  N   VAL C 151     -57.717   6.575 -12.015  1.00 56.91           N  
ATOM   4039  CA  VAL C 151     -57.870   7.727 -11.179  1.00 56.91           C  
ATOM   4040  C   VAL C 151     -57.440   8.911 -12.014  1.00 57.21           C  
ATOM   4041  O   VAL C 151     -56.602   8.758 -12.884  1.00 57.94           O  
ATOM   4042  CB  VAL C 151     -56.988   7.482  -9.918  1.00 57.03           C  
ATOM   4043  CG1 VAL C 151     -55.788   8.408  -9.806  1.00 56.46           C  
ATOM   4044  CG2 VAL C 151     -57.838   7.361  -8.645  1.00 56.66           C  
ATOM   4045  N   ASP C 152     -58.039  10.075 -11.803  1.00 57.66           N  
ATOM   4046  CA  ASP C 152     -57.544  11.301 -12.413  1.00 57.62           C  
ATOM   4047  C   ASP C 152     -56.158  11.462 -11.814  1.00 57.91           C  
ATOM   4048  O   ASP C 152     -55.995  11.970 -10.704  1.00 58.43           O  
ATOM   4049  CB  ASP C 152     -58.449  12.486 -12.042  1.00 58.00           C  
ATOM   4050  CG  ASP C 152     -58.012  13.820 -12.686  1.00 58.78           C  
ATOM   4051  OD1 ASP C 152     -56.849  13.945 -13.150  1.00 57.64           O  
ATOM   4052  OD2 ASP C 152     -58.852  14.761 -12.701  1.00 58.99           O  
ATOM   4053  N   ALA C 153     -55.158  10.987 -12.538  1.00 58.23           N  
ATOM   4054  CA  ALA C 153     -53.797  11.006 -12.056  1.00 58.94           C  
ATOM   4055  C   ALA C 153     -53.294  12.436 -11.822  1.00 59.75           C  
ATOM   4056  O   ALA C 153     -52.579  12.689 -10.847  1.00 60.42           O  
ATOM   4057  CB  ALA C 153     -52.904  10.280 -13.029  1.00 58.88           C  
ATOM   4058  N   GLU C 154     -53.695  13.371 -12.686  1.00 59.92           N  
ATOM   4059  CA  GLU C 154     -53.262  14.754 -12.561  1.00 60.21           C  
ATOM   4060  C   GLU C 154     -53.742  15.318 -11.239  1.00 59.75           C  
ATOM   4061  O   GLU C 154     -52.976  15.941 -10.517  1.00 59.37           O  
ATOM   4062  CB  GLU C 154     -53.781  15.599 -13.716  1.00 60.57           C  
ATOM   4063  CG  GLU C 154     -52.868  16.786 -14.100  1.00 64.38           C  
ATOM   4064  CD  GLU C 154     -51.534  16.383 -14.801  1.00 70.30           C  
ATOM   4065  OE1 GLU C 154     -51.515  15.611 -15.827  1.00 68.74           O  
ATOM   4066  OE2 GLU C 154     -50.488  16.878 -14.306  1.00 73.35           O  
ATOM   4067  N   HIS C 155     -55.008  15.066 -10.915  1.00 59.29           N  
ATOM   4068  CA  HIS C 155     -55.570  15.595  -9.690  1.00 58.76           C  
ATOM   4069  C   HIS C 155     -54.923  14.980  -8.433  1.00 58.46           C  
ATOM   4070  O   HIS C 155     -54.663  15.692  -7.455  1.00 57.74           O  
ATOM   4071  CB  HIS C 155     -57.085  15.457  -9.650  1.00 58.51           C  
ATOM   4072  CG  HIS C 155     -57.641  15.639  -8.280  1.00 58.95           C  
ATOM   4073  ND1 HIS C 155     -57.970  16.872  -7.773  1.00 60.32           N  
ATOM   4074  CD2 HIS C 155     -57.860  14.750  -7.283  1.00 60.36           C  
ATOM   4075  CE1 HIS C 155     -58.385  16.737  -6.527  1.00 60.77           C  
ATOM   4076  NE2 HIS C 155     -58.332  15.458  -6.207  1.00 60.90           N  
ATOM   4077  N   VAL C 156     -54.653  13.675  -8.474  1.00 58.16           N  
ATOM   4078  CA  VAL C 156     -54.025  13.004  -7.347  1.00 57.94           C  
ATOM   4079  C   VAL C 156     -52.624  13.516  -7.113  1.00 58.42           C  
ATOM   4080  O   VAL C 156     -52.245  13.747  -5.954  1.00 58.66           O  
ATOM   4081  CB  VAL C 156     -54.028  11.466  -7.475  1.00 58.27           C  
ATOM   4082  CG1 VAL C 156     -53.223  10.825  -6.340  1.00 56.76           C  
ATOM   4083  CG2 VAL C 156     -55.451  10.952  -7.443  1.00 57.53           C  
ATOM   4084  N   THR C 157     -51.845  13.700  -8.186  1.00 59.13           N  
ATOM   4085  CA  THR C 157     -50.462  14.124  -7.977  1.00 59.66           C  
ATOM   4086  C   THR C 157     -50.476  15.539  -7.428  1.00 59.62           C  
ATOM   4087  O   THR C 157     -49.803  15.831  -6.442  1.00 60.01           O  
ATOM   4088  CB  THR C 157     -49.506  13.995  -9.217  1.00 59.89           C  
ATOM   4089  OG1 THR C 157     -49.151  15.293  -9.716  1.00 60.33           O  
ATOM   4090  CG2 THR C 157     -50.089  13.146 -10.284  1.00 59.28           C  
ATOM   4091  N   ARG C 158     -51.284  16.381  -8.058  1.00 59.52           N  
ATOM   4092  CA  ARG C 158     -51.579  17.736  -7.617  1.00 59.98           C  
ATOM   4093  C   ARG C 158     -51.935  17.752  -6.104  1.00 60.30           C  
ATOM   4094  O   ARG C 158     -51.374  18.527  -5.321  1.00 60.77           O  
ATOM   4095  CB  ARG C 158     -52.742  18.224  -8.467  1.00 60.05           C  
ATOM   4096  CG  ARG C 158     -53.127  19.665  -8.369  1.00 62.66           C  
ATOM   4097  CD  ARG C 158     -52.582  20.486  -9.575  1.00 64.88           C  
ATOM   4098  NE  ARG C 158     -52.751  19.858 -10.885  1.00 63.86           N  
ATOM   4099  CZ  ARG C 158     -52.386  20.426 -12.042  1.00 66.84           C  
ATOM   4100  NH1 ARG C 158     -51.826  21.643 -12.073  1.00 66.95           N  
ATOM   4101  NH2 ARG C 158     -52.566  19.773 -13.184  1.00 67.81           N  
ATOM   4102  N   SER C 159     -52.837  16.870  -5.681  1.00 59.77           N  
ATOM   4103  CA  SER C 159     -53.203  16.800  -4.283  1.00 59.15           C  
ATOM   4104  C   SER C 159     -51.995  16.515  -3.411  1.00 59.86           C  
ATOM   4105  O   SER C 159     -51.839  17.147  -2.370  1.00 60.18           O  
ATOM   4106  CB  SER C 159     -54.248  15.733  -4.060  1.00 58.15           C  
ATOM   4107  OG  SER C 159     -55.407  16.062  -4.772  1.00 57.13           O  
ATOM   4108  N   LEU C 160     -51.153  15.561  -3.820  1.00 59.67           N  
ATOM   4109  CA  LEU C 160     -50.004  15.167  -2.987  1.00 59.57           C  
ATOM   4110  C   LEU C 160     -49.054  16.328  -2.845  1.00 59.84           C  
ATOM   4111  O   LEU C 160     -48.452  16.528  -1.802  1.00 60.53           O  
ATOM   4112  CB  LEU C 160     -49.284  13.953  -3.565  1.00 58.73           C  
ATOM   4113  CG  LEU C 160     -50.154  12.717  -3.438  1.00 57.81           C  
ATOM   4114  CD1 LEU C 160     -49.867  11.740  -4.525  1.00 59.23           C  
ATOM   4115  CD2 LEU C 160     -49.928  12.078  -2.101  1.00 58.66           C  
ATOM   4116  N   LEU C 161     -48.952  17.113  -3.905  1.00 59.97           N  
ATOM   4117  CA  LEU C 161     -48.162  18.320  -3.891  1.00 59.57           C  
ATOM   4118  C   LEU C 161     -48.730  19.363  -2.927  1.00 59.35           C  
ATOM   4119  O   LEU C 161     -47.994  20.099  -2.259  1.00 60.56           O  
ATOM   4120  CB  LEU C 161     -48.069  18.857  -5.311  1.00 59.37           C  
ATOM   4121  CG  LEU C 161     -46.735  18.502  -5.980  1.00 59.89           C  
ATOM   4122  CD1 LEU C 161     -45.965  17.441  -5.233  1.00 58.86           C  
ATOM   4123  CD2 LEU C 161     -46.938  18.108  -7.422  1.00 58.34           C  
ATOM   4124  N   THR C 162     -50.043  19.423  -2.832  1.00 58.46           N  
ATOM   4125  CA  THR C 162     -50.659  20.377  -1.929  1.00 57.58           C  
ATOM   4126  C   THR C 162     -50.373  19.966  -0.493  1.00 57.46           C  
ATOM   4127  O   THR C 162     -49.951  20.802   0.320  1.00 57.05           O  
ATOM   4128  CB  THR C 162     -52.135  20.485  -2.233  1.00 57.57           C  
ATOM   4129  OG1 THR C 162     -52.268  20.883  -3.604  1.00 56.13           O  
ATOM   4130  CG2 THR C 162     -52.810  21.487  -1.340  1.00 57.22           C  
ATOM   4131  N   ILE C 163     -50.541  18.672  -0.205  1.00 56.92           N  
ATOM   4132  CA  ILE C 163     -50.213  18.125   1.100  1.00 56.75           C  
ATOM   4133  C   ILE C 163     -48.741  18.397   1.438  1.00 57.13           C  
ATOM   4134  O   ILE C 163     -48.419  18.721   2.581  1.00 57.16           O  
ATOM   4135  CB  ILE C 163     -50.542  16.626   1.210  1.00 56.48           C  
ATOM   4136  CG1 ILE C 163     -52.053  16.421   1.251  1.00 57.07           C  
ATOM   4137  CG2 ILE C 163     -49.917  16.017   2.460  1.00 56.34           C  
ATOM   4138  CD1 ILE C 163     -52.522  14.984   0.878  1.00 56.17           C  
ATOM   4139  N   ILE C 164     -47.865  18.302   0.448  1.00 57.40           N  
ATOM   4140  CA  ILE C 164     -46.427  18.442   0.687  1.00 58.16           C  
ATOM   4141  C   ILE C 164     -46.040  19.896   0.936  1.00 58.51           C  
ATOM   4142  O   ILE C 164     -45.268  20.214   1.859  1.00 57.69           O  
ATOM   4143  CB  ILE C 164     -45.616  17.818  -0.485  1.00 58.65           C  
ATOM   4144  CG1 ILE C 164     -45.671  16.287  -0.371  1.00 59.06           C  
ATOM   4145  CG2 ILE C 164     -44.174  18.361  -0.565  1.00 57.35           C  
ATOM   4146  CD1 ILE C 164     -45.367  15.559  -1.684  1.00 60.64           C  
ATOM   4147  N   ASP C 165     -46.586  20.796   0.131  1.00 58.93           N  
ATOM   4148  CA  ASP C 165     -46.253  22.192   0.345  1.00 60.15           C  
ATOM   4149  C   ASP C 165     -46.831  22.686   1.664  1.00 59.44           C  
ATOM   4150  O   ASP C 165     -46.183  23.447   2.382  1.00 59.58           O  
ATOM   4151  CB  ASP C 165     -46.662  23.048  -0.858  1.00 61.18           C  
ATOM   4152  CG  ASP C 165     -45.847  22.709  -2.115  1.00 65.81           C  
ATOM   4153  OD1 ASP C 165     -44.606  22.499  -1.991  1.00 69.42           O  
ATOM   4154  OD2 ASP C 165     -46.447  22.636  -3.224  1.00 69.77           O  
ATOM   4155  N   GLY C 166     -48.030  22.215   1.999  1.00 59.09           N  
ATOM   4156  CA  GLY C 166     -48.654  22.544   3.279  1.00 58.98           C  
ATOM   4157  C   GLY C 166     -47.750  22.123   4.417  1.00 59.02           C  
ATOM   4158  O   GLY C 166     -47.544  22.882   5.377  1.00 58.79           O  
ATOM   4159  N   ALA C 167     -47.197  20.918   4.308  1.00 58.82           N  
ATOM   4160  CA  ALA C 167     -46.247  20.462   5.307  1.00 59.54           C  
ATOM   4161  C   ALA C 167     -45.071  21.437   5.462  1.00 59.98           C  
ATOM   4162  O   ALA C 167     -44.810  21.907   6.571  1.00 59.87           O  
ATOM   4163  CB  ALA C 167     -45.769  19.081   5.010  1.00 59.34           C  
ATOM   4164  N   ARG C 168     -44.393  21.758   4.358  1.00 60.66           N  
ATOM   4165  CA  ARG C 168     -43.239  22.651   4.407  1.00 61.81           C  
ATOM   4166  C   ARG C 168     -43.641  23.976   5.063  1.00 61.43           C  
ATOM   4167  O   ARG C 168     -42.935  24.486   5.930  1.00 61.58           O  
ATOM   4168  CB  ARG C 168     -42.675  22.926   3.005  1.00 61.65           C  
ATOM   4169  CG  ARG C 168     -42.383  21.717   2.119  1.00 63.63           C  
ATOM   4170  CD  ARG C 168     -42.061  22.198   0.663  1.00 64.82           C  
ATOM   4171  NE  ARG C 168     -41.788  21.095  -0.268  1.00 72.32           N  
ATOM   4172  CZ  ARG C 168     -41.279  21.237  -1.501  1.00 76.15           C  
ATOM   4173  NH1 ARG C 168     -40.984  22.446  -1.971  1.00 77.88           N  
ATOM   4174  NH2 ARG C 168     -41.069  20.171  -2.283  1.00 76.21           N  
ATOM   4175  N   THR C 169     -44.786  24.526   4.653  1.00 61.18           N  
ATOM   4176  CA  THR C 169     -45.241  25.805   5.171  1.00 60.88           C  
ATOM   4177  C   THR C 169     -45.465  25.729   6.682  1.00 60.83           C  
ATOM   4178  O   THR C 169     -44.788  26.416   7.442  1.00 61.04           O  
ATOM   4179  CB  THR C 169     -46.490  26.293   4.420  1.00 61.02           C  
ATOM   4180  OG1 THR C 169     -46.100  26.751   3.122  1.00 62.23           O  
ATOM   4181  CG2 THR C 169     -47.158  27.444   5.139  1.00 60.78           C  
ATOM   4182  N   ARG C 170     -46.367  24.863   7.127  1.00 60.65           N  
ATOM   4183  CA  ARG C 170     -46.670  24.782   8.555  1.00 60.38           C  
ATOM   4184  C   ARG C 170     -45.427  24.559   9.432  1.00 60.53           C  
ATOM   4185  O   ARG C 170     -45.349  25.087  10.538  1.00 59.98           O  
ATOM   4186  CB  ARG C 170     -47.734  23.722   8.812  1.00 60.50           C  
ATOM   4187  CG  ARG C 170     -49.104  24.041   8.202  1.00 60.03           C  
ATOM   4188  CD  ARG C 170     -50.100  22.915   8.475  1.00 59.60           C  
ATOM   4189  NE  ARG C 170     -50.311  22.700   9.909  1.00 58.88           N  
ATOM   4190  CZ  ARG C 170     -51.219  23.349  10.638  1.00 59.78           C  
ATOM   4191  NH1 ARG C 170     -51.998  24.255  10.063  1.00 60.31           N  
ATOM   4192  NH2 ARG C 170     -51.347  23.107  11.937  1.00 58.25           N  
ATOM   4193  N   ALA C 171     -44.454  23.807   8.916  1.00 61.06           N  
ATOM   4194  CA  ALA C 171     -43.255  23.445   9.676  1.00 61.72           C  
ATOM   4195  C   ALA C 171     -42.357  24.623   9.979  1.00 62.41           C  
ATOM   4196  O   ALA C 171     -41.754  24.671  11.045  1.00 62.31           O  
ATOM   4197  CB  ALA C 171     -42.467  22.392   8.966  1.00 61.64           C  
ATOM   4198  N   VAL C 172     -42.244  25.560   9.045  1.00 63.39           N  
ATOM   4199  CA  VAL C 172     -41.451  26.748   9.324  1.00 64.61           C  
ATOM   4200  C   VAL C 172     -42.291  27.767  10.087  1.00 65.92           C  
ATOM   4201  O   VAL C 172     -41.759  28.529  10.890  1.00 66.57           O  
ATOM   4202  CB  VAL C 172     -40.801  27.383   8.064  1.00 64.34           C  
ATOM   4203  CG1 VAL C 172     -40.971  26.494   6.877  1.00 64.05           C  
ATOM   4204  CG2 VAL C 172     -41.375  28.758   7.764  1.00 64.12           C  
HETATM 4205  N   MSE C 173     -43.598  27.780   9.852  1.00 67.15           N  
HETATM 4206  CA  MSE C 173     -44.458  28.739  10.519  1.00 69.18           C  
HETATM 4207  C   MSE C 173     -44.557  28.435  12.002  1.00 67.71           C  
HETATM 4208  O   MSE C 173     -44.422  29.331  12.811  1.00 67.90           O  
HETATM 4209  CB  MSE C 173     -45.833  28.758   9.889  1.00 68.66           C  
HETATM 4210  CG  MSE C 173     -46.831  29.623  10.614  1.00 71.30           C  
HETATM 4211 SE   MSE C 173     -48.560  29.543   9.706  0.90 76.66          SE  
HETATM 4212  CE  MSE C 173     -49.221  27.792  10.284  1.00 75.68           C  
ATOM   4213  N   LEU C 174     -44.765  27.171  12.351  1.00 67.09           N  
ATOM   4214  CA  LEU C 174     -44.895  26.767  13.749  1.00 66.21           C  
ATOM   4215  C   LEU C 174     -43.575  26.271  14.333  1.00 65.81           C  
ATOM   4216  O   LEU C 174     -43.541  25.718  15.432  1.00 65.61           O  
ATOM   4217  CB  LEU C 174     -45.973  25.689  13.893  1.00 66.18           C  
ATOM   4218  CG  LEU C 174     -47.305  25.972  13.197  1.00 66.39           C  
ATOM   4219  CD1 LEU C 174     -48.203  24.746  13.250  1.00 66.21           C  
ATOM   4220  CD2 LEU C 174     -47.994  27.194  13.798  1.00 66.45           C  
ATOM   4221  N   ASP C 175     -42.491  26.451  13.581  1.00 65.38           N  
ATOM   4222  CA  ASP C 175     -41.146  26.166  14.077  1.00 65.07           C  
ATOM   4223  C   ASP C 175     -41.044  24.722  14.589  1.00 65.01           C  
ATOM   4224  O   ASP C 175     -40.294  24.423  15.518  1.00 64.93           O  
ATOM   4225  CB  ASP C 175     -40.779  27.196  15.166  1.00 65.04           C  
ATOM   4226  CG  ASP C 175     -39.327  27.137  15.573  1.00 64.23           C  
ATOM   4227  OD1 ASP C 175     -38.490  26.698  14.759  1.00 64.04           O  
ATOM   4228  OD2 ASP C 175     -39.032  27.530  16.717  1.00 63.01           O  
ATOM   4229  N   ASP C 176     -41.780  23.826  13.935  1.00 65.01           N  
ATOM   4230  CA  ASP C 176     -42.038  22.490  14.453  1.00 65.16           C  
ATOM   4231  C   ASP C 176     -42.024  21.444  13.357  1.00 65.29           C  
ATOM   4232  O   ASP C 176     -42.887  21.433  12.471  1.00 65.55           O  
ATOM   4233  CB  ASP C 176     -43.402  22.483  15.146  1.00 65.46           C  
ATOM   4234  CG  ASP C 176     -43.809  21.113  15.637  1.00 65.80           C  
ATOM   4235  OD1 ASP C 176     -45.034  20.864  15.690  1.00 66.55           O  
ATOM   4236  OD2 ASP C 176     -42.915  20.302  15.984  1.00 66.54           O  
ATOM   4237  N   THR C 177     -41.063  20.534  13.445  1.00 65.27           N  
ATOM   4238  CA  THR C 177     -40.842  19.557  12.382  1.00 65.04           C  
ATOM   4239  C   THR C 177     -41.694  18.290  12.532  1.00 64.66           C  
ATOM   4240  O   THR C 177     -41.612  17.374  11.721  1.00 64.76           O  
ATOM   4241  CB  THR C 177     -39.336  19.211  12.232  1.00 65.31           C  
ATOM   4242  OG1 THR C 177     -38.872  18.567  13.423  1.00 66.14           O  
ATOM   4243  CG2 THR C 177     -38.495  20.481  11.985  1.00 65.24           C  
ATOM   4244  N   GLU C 178     -42.529  18.233  13.556  1.00 64.34           N  
ATOM   4245  CA  GLU C 178     -43.525  17.173  13.611  1.00 64.16           C  
ATOM   4246  C   GLU C 178     -44.576  17.418  12.527  1.00 63.51           C  
ATOM   4247  O   GLU C 178     -45.341  16.520  12.171  1.00 63.28           O  
ATOM   4248  CB  GLU C 178     -44.177  17.070  14.995  1.00 64.27           C  
ATOM   4249  CG  GLU C 178     -43.167  17.042  16.127  1.00 65.93           C  
ATOM   4250  CD  GLU C 178     -43.583  16.161  17.296  1.00 68.62           C  
ATOM   4251  OE1 GLU C 178     -44.738  16.296  17.778  1.00 68.86           O  
ATOM   4252  OE2 GLU C 178     -42.735  15.344  17.739  1.00 68.49           O  
ATOM   4253  N   GLU C 179     -44.616  18.639  11.999  1.00 62.97           N  
ATOM   4254  CA  GLU C 179     -45.559  18.937  10.920  1.00 62.53           C  
ATOM   4255  C   GLU C 179     -45.255  18.008   9.742  1.00 62.04           C  
ATOM   4256  O   GLU C 179     -46.158  17.431   9.139  1.00 61.64           O  
ATOM   4257  CB  GLU C 179     -45.518  20.419  10.505  1.00 62.41           C  
ATOM   4258  CG  GLU C 179     -46.112  21.375  11.532  1.00 63.21           C  
ATOM   4259  CD  GLU C 179     -47.623  21.216  11.741  1.00 64.91           C  
ATOM   4260  OE1 GLU C 179     -48.077  21.273  12.894  1.00 68.02           O  
ATOM   4261  OE2 GLU C 179     -48.377  21.056  10.771  1.00 66.01           O  
ATOM   4262  N   LEU C 180     -43.966  17.829   9.462  1.00 61.27           N  
ATOM   4263  CA  LEU C 180     -43.543  16.992   8.373  1.00 60.07           C  
ATOM   4264  C   LEU C 180     -43.910  15.531   8.602  1.00 59.90           C  
ATOM   4265  O   LEU C 180     -44.386  14.864   7.681  1.00 60.22           O  
ATOM   4266  CB  LEU C 180     -42.054  17.184   8.127  1.00 60.11           C  
ATOM   4267  CG  LEU C 180     -41.698  18.556   7.547  1.00 58.45           C  
ATOM   4268  CD1 LEU C 180     -40.211  18.742   7.591  1.00 57.14           C  
ATOM   4269  CD2 LEU C 180     -42.217  18.678   6.130  1.00 56.00           C  
ATOM   4270  N   GLU C 181     -43.742  15.034   9.820  1.00 59.20           N  
ATOM   4271  CA  GLU C 181     -44.058  13.628  10.067  1.00 59.35           C  
ATOM   4272  C   GLU C 181     -45.553  13.322  10.004  1.00 58.50           C  
ATOM   4273  O   GLU C 181     -45.964  12.331   9.373  1.00 58.27           O  
ATOM   4274  CB  GLU C 181     -43.374  13.054  11.320  1.00 59.30           C  
ATOM   4275  CG  GLU C 181     -43.325  13.955  12.518  1.00 62.67           C  
ATOM   4276  CD  GLU C 181     -42.202  13.591  13.495  1.00 67.14           C  
ATOM   4277  OE1 GLU C 181     -42.515  13.139  14.626  1.00 68.80           O  
ATOM   4278  OE2 GLU C 181     -41.010  13.752  13.138  1.00 67.59           O  
ATOM   4279  N   THR C 182     -46.366  14.182  10.605  1.00 57.72           N  
ATOM   4280  CA  THR C 182     -47.818  14.023  10.489  1.00 56.96           C  
ATOM   4281  C   THR C 182     -48.233  14.119   9.018  1.00 56.42           C  
ATOM   4282  O   THR C 182     -48.847  13.186   8.502  1.00 56.92           O  
ATOM   4283  CB  THR C 182     -48.618  14.909  11.494  1.00 57.64           C  
ATOM   4284  OG1 THR C 182     -48.535  16.284  11.141  1.00 58.71           O  
ATOM   4285  CG2 THR C 182     -48.053  14.750  12.929  1.00 56.93           C  
ATOM   4286  N   ALA C 183     -47.815  15.166   8.307  1.00 55.60           N  
ATOM   4287  CA  ALA C 183     -47.967  15.214   6.827  1.00 55.34           C  
ATOM   4288  C   ALA C 183     -47.522  13.937   6.071  1.00 55.75           C  
ATOM   4289  O   ALA C 183     -48.203  13.455   5.166  1.00 55.72           O  
ATOM   4290  CB  ALA C 183     -47.268  16.415   6.258  1.00 54.51           C  
ATOM   4291  N   ARG C 184     -46.379  13.379   6.426  1.00 56.06           N  
ATOM   4292  CA  ARG C 184     -45.975  12.130   5.786  1.00 56.89           C  
ATOM   4293  C   ARG C 184     -47.082  11.080   5.912  1.00 57.25           C  
ATOM   4294  O   ARG C 184     -47.374  10.369   4.961  1.00 57.91           O  
ATOM   4295  CB  ARG C 184     -44.650  11.593   6.365  1.00 56.39           C  
ATOM   4296  CG  ARG C 184     -44.139  10.363   5.672  1.00 56.54           C  
ATOM   4297  CD  ARG C 184     -43.973  10.579   4.149  1.00 57.36           C  
ATOM   4298  NE  ARG C 184     -43.552   9.375   3.423  1.00 57.10           N  
ATOM   4299  CZ  ARG C 184     -44.389   8.429   3.005  1.00 58.25           C  
ATOM   4300  NH1 ARG C 184     -45.697   8.533   3.249  1.00 58.85           N  
ATOM   4301  NH2 ARG C 184     -43.927   7.378   2.342  1.00 55.88           N  
ATOM   4302  N   GLN C 185     -47.704  10.993   7.080  1.00 57.83           N  
ATOM   4303  CA  GLN C 185     -48.791  10.057   7.265  1.00 58.50           C  
ATOM   4304  C   GLN C 185     -49.972  10.486   6.414  1.00 58.78           C  
ATOM   4305  O   GLN C 185     -50.558   9.650   5.726  1.00 58.93           O  
ATOM   4306  CB  GLN C 185     -49.208  10.014   8.718  1.00 58.55           C  
ATOM   4307  CG  GLN C 185     -50.303   9.028   8.990  1.00 62.09           C  
ATOM   4308  CD  GLN C 185     -50.721   9.026  10.448  1.00 66.89           C  
ATOM   4309  OE1 GLN C 185     -49.883   9.035  11.360  1.00 69.56           O  
ATOM   4310  NE2 GLN C 185     -52.025   9.034  10.678  1.00 68.37           N  
ATOM   4311  N   THR C 186     -50.303  11.789   6.460  1.00 58.28           N  
ATOM   4312  CA  THR C 186     -51.413  12.330   5.710  1.00 57.51           C  
ATOM   4313  C   THR C 186     -51.276  11.914   4.250  1.00 58.16           C  
ATOM   4314  O   THR C 186     -52.239  11.436   3.651  1.00 58.38           O  
ATOM   4315  CB  THR C 186     -51.503  13.888   5.820  1.00 57.50           C  
ATOM   4316  OG1 THR C 186     -51.531  14.288   7.203  1.00 57.02           O  
ATOM   4317  CG2 THR C 186     -52.755  14.402   5.140  1.00 54.26           C  
ATOM   4318  N   ALA C 187     -50.075  12.069   3.686  1.00 58.49           N  
ATOM   4319  CA  ALA C 187     -49.852  11.771   2.265  1.00 58.38           C  
ATOM   4320  C   ALA C 187     -50.144  10.305   1.968  1.00 58.93           C  
ATOM   4321  O   ALA C 187     -50.763   9.981   0.946  1.00 59.56           O  
ATOM   4322  CB  ALA C 187     -48.442  12.137   1.834  1.00 57.65           C  
ATOM   4323  N   SER C 188     -49.687   9.416   2.848  1.00 58.83           N  
ATOM   4324  CA  SER C 188     -49.925   8.002   2.657  1.00 58.81           C  
ATOM   4325  C   SER C 188     -51.406   7.685   2.758  1.00 58.59           C  
ATOM   4326  O   SER C 188     -51.939   6.993   1.911  1.00 58.41           O  
ATOM   4327  CB  SER C 188     -49.106   7.176   3.643  1.00 59.22           C  
ATOM   4328  OG  SER C 188     -47.973   6.626   2.968  1.00 60.83           O  
ATOM   4329  N   GLU C 189     -52.062   8.204   3.793  1.00 58.87           N  
ATOM   4330  CA  GLU C 189     -53.518   8.118   3.934  1.00 59.33           C  
ATOM   4331  C   GLU C 189     -54.310   8.615   2.709  1.00 59.74           C  
ATOM   4332  O   GLU C 189     -55.315   7.990   2.342  1.00 60.61           O  
ATOM   4333  CB  GLU C 189     -53.996   8.883   5.156  1.00 59.24           C  
ATOM   4334  CG  GLU C 189     -53.769   8.183   6.452  1.00 59.91           C  
ATOM   4335  CD  GLU C 189     -53.968   9.085   7.668  1.00 62.46           C  
ATOM   4336  OE1 GLU C 189     -54.216  10.317   7.532  1.00 60.92           O  
ATOM   4337  OE2 GLU C 189     -53.843   8.544   8.779  1.00 62.97           O  
ATOM   4338  N   TYR C 190     -53.883   9.712   2.078  1.00 59.13           N  
ATOM   4339  CA  TYR C 190     -54.635  10.230   0.942  1.00 59.01           C  
ATOM   4340  C   TYR C 190     -54.407   9.330  -0.249  1.00 59.68           C  
ATOM   4341  O   TYR C 190     -55.339   9.052  -1.005  1.00 60.29           O  
ATOM   4342  CB  TYR C 190     -54.283  11.691   0.608  1.00 58.40           C  
ATOM   4343  CG  TYR C 190     -54.904  12.171  -0.685  1.00 56.87           C  
ATOM   4344  CD1 TYR C 190     -56.231  12.620  -0.733  1.00 55.13           C  
ATOM   4345  CD2 TYR C 190     -54.170  12.146  -1.869  1.00 57.64           C  
ATOM   4346  CE1 TYR C 190     -56.825  13.041  -1.942  1.00 55.06           C  
ATOM   4347  CE2 TYR C 190     -54.745  12.554  -3.093  1.00 58.35           C  
ATOM   4348  CZ  TYR C 190     -56.070  13.000  -3.127  1.00 57.74           C  
ATOM   4349  OH  TYR C 190     -56.593  13.397  -4.350  1.00 55.35           O  
ATOM   4350  N   ALA C 191     -53.170   8.855  -0.393  1.00 60.05           N  
ATOM   4351  CA  ALA C 191     -52.766   8.015  -1.527  1.00 60.20           C  
ATOM   4352  C   ALA C 191     -53.412   6.638  -1.460  1.00 60.54           C  
ATOM   4353  O   ALA C 191     -53.933   6.166  -2.466  1.00 61.35           O  
ATOM   4354  CB  ALA C 191     -51.248   7.897  -1.606  1.00 59.34           C  
ATOM   4355  N   ASP C 192     -53.371   5.996  -0.295  1.00 60.61           N  
ATOM   4356  CA  ASP C 192     -54.045   4.721  -0.137  1.00 61.77           C  
ATOM   4357  C   ASP C 192     -55.506   4.896  -0.472  1.00 61.13           C  
ATOM   4358  O   ASP C 192     -56.076   4.075  -1.165  1.00 60.58           O  
ATOM   4359  CB  ASP C 192     -53.936   4.154   1.290  1.00 62.60           C  
ATOM   4360  CG  ASP C 192     -52.512   3.785   1.689  1.00 65.64           C  
ATOM   4361  OD1 ASP C 192     -51.569   3.867   0.852  1.00 68.04           O  
ATOM   4362  OD2 ASP C 192     -52.344   3.411   2.878  1.00 69.62           O  
ATOM   4363  N   ALA C 193     -56.100   5.982   0.013  1.00 60.92           N  
ATOM   4364  CA  ALA C 193     -57.529   6.175  -0.144  1.00 60.92           C  
ATOM   4365  C   ALA C 193     -57.900   6.327  -1.611  1.00 60.84           C  
ATOM   4366  O   ALA C 193     -58.922   5.820  -2.041  1.00 60.77           O  
ATOM   4367  CB  ALA C 193     -57.992   7.360   0.647  1.00 60.78           C  
HETATM 4368  N   MSE C 194     -57.054   7.003  -2.373  1.00 60.90           N  
HETATM 4369  CA  MSE C 194     -57.323   7.228  -3.777  1.00 61.18           C  
HETATM 4370  C   MSE C 194     -56.944   6.038  -4.639  1.00 60.55           C  
HETATM 4371  O   MSE C 194     -57.744   5.595  -5.465  1.00 60.79           O  
HETATM 4372  CB  MSE C 194     -56.617   8.483  -4.268  1.00 61.33           C  
HETATM 4373  CG  MSE C 194     -57.091   9.746  -3.571  1.00 66.14           C  
HETATM 4374 SE   MSE C 194     -59.030  10.101  -3.689  0.95 76.92          SE  
HETATM 4375  CE  MSE C 194     -59.195  10.035  -5.660  1.00 72.34           C  
ATOM   4376  N   LEU C 195     -55.741   5.507  -4.431  1.00 59.65           N  
ATOM   4377  CA  LEU C 195     -55.181   4.518  -5.334  1.00 58.44           C  
ATOM   4378  C   LEU C 195     -55.445   3.092  -4.916  1.00 58.30           C  
ATOM   4379  O   LEU C 195     -55.336   2.190  -5.736  1.00 58.80           O  
ATOM   4380  CB  LEU C 195     -53.680   4.734  -5.473  1.00 58.09           C  
ATOM   4381  CG  LEU C 195     -53.279   6.174  -5.803  1.00 57.96           C  
ATOM   4382  CD1 LEU C 195     -51.890   6.465  -5.322  1.00 57.02           C  
ATOM   4383  CD2 LEU C 195     -53.426   6.483  -7.285  1.00 55.76           C  
ATOM   4384  N   GLN C 196     -55.827   2.882  -3.662  1.00 57.92           N  
ATOM   4385  CA  GLN C 196     -55.674   1.569  -3.042  1.00 57.57           C  
ATOM   4386  C   GLN C 196     -56.669   1.299  -1.899  1.00 57.41           C  
ATOM   4387  O   GLN C 196     -57.862   1.184  -2.117  1.00 56.84           O  
ATOM   4388  CB  GLN C 196     -54.264   1.498  -2.482  1.00 57.15           C  
ATOM   4389  CG  GLN C 196     -53.576   0.215  -2.662  1.00 57.21           C  
ATOM   4390  CD  GLN C 196     -52.106   0.422  -2.824  1.00 58.18           C  
ATOM   4391  OE1 GLN C 196     -51.612   1.525  -2.620  1.00 60.16           O  
ATOM   4392  NE2 GLN C 196     -51.391  -0.625  -3.221  1.00 57.25           N  
TER    4393      GLN C 196                                                      
END
MOLECULE T0454.pdb
ATOM      1  N   ASP     5     -12.420  32.658   0.024  1.00 27.13           N
ATOM      2  CA  ASP     5     -13.312  32.598   1.217  1.00 27.34           C
ATOM      3  CB  ASP     5     -12.512  32.690   2.520  1.00 28.50           C
ATOM      4  CG  ASP     5     -13.404  32.599   3.759  1.00 30.42           C
ATOM      5  OD1 ASP     5     -14.289  31.706   3.803  1.00 33.47           O
ATOM      6  OD2 ASP     5     -13.226  33.430   4.680  1.00 32.05           O
ATOM      7  C   ASP     5     -14.424  33.644   1.238  1.00 26.73           C
ATOM      8  O   ASP     5     -15.477  33.398   1.835  1.00 26.63           O
ATOM      9  N   CYS     6     -14.211  34.799   0.611  0.50 26.41           N
ATOM     11  CA  CYS     6     -15.286  35.794   0.531  0.50 26.28           C
ATOM     13  CB  CYS     6     -14.751  37.198   0.241  0.50 26.57           C
ATOM     15  SG  CYS     6     -14.050  37.968   1.731  0.50 29.41           S
ATOM     17  C   CYS     6     -16.388  35.363  -0.439  0.50 25.38           C
ATOM     19  O   CYS     6     -17.496  35.901  -0.414  0.50 25.34           O
ATOM     21  N   ARG     7     -16.080  34.368  -1.271  1.00 24.45           N
ATOM     22  CA  ARG     7     -17.093  33.680  -2.080  1.00 22.28           C
ATOM     23  CB  ARG     7     -16.421  32.728  -3.079  1.00 22.90           C
ATOM     30  C   ARG     7     -18.066  32.903  -1.186  1.00 20.46           C
ATOM     31  O   ARG     7     -19.262  32.867  -1.449  1.00 20.43           O
ATOM     32  N   SER     8     -17.547  32.253  -0.148  0.50 19.10           N
ATOM     34  CA  SER     8     -18.391  31.436   0.731  0.50 17.33           C
ATOM     36  CB  SER     8     -17.550  30.493   1.586  0.50 17.45           C
ATOM     38  OG  SER     8     -18.312  29.968   2.658  0.50 15.65           O
ATOM     40  C   SER     8     -19.258  32.322   1.613  0.50 16.60           C
ATOM     42  O   SER     8     -20.455  32.084   1.776  0.50 15.91           O
ATOM     44  N   ARG     9     -18.645  33.365   2.159  0.50 15.61           N
ATOM     46  CA  ARG     9     -19.363  34.297   3.022  0.50 14.83           C
ATOM     48  CB  ARG     9     -18.372  35.205   3.766  0.50 15.25           C
ATOM     50  CG  ARG     9     -17.394  34.394   4.628  0.50 14.59           C
ATOM     52  CD  ARG     9     -16.768  35.163   5.795  0.50 16.76           C
ATOM     54  NE  ARG     9     -15.709  36.081   5.358  0.50 18.23           N
ATOM     56  CZ  ARG     9     -15.907  37.364   5.046  0.50 17.11           C
ATOM     58  NH1 ARG     9     -14.883  38.115   4.657  0.50 16.37           N
ATOM     60  NH2 ARG     9     -17.129  37.896   5.121  0.50 17.10           N
ATOM     62  C   ARG     9     -20.452  35.089   2.282  0.50 14.49           C
ATOM     64  O   ARG     9     -21.506  35.370   2.850  0.50 13.18           O
ATOM     66  N   LEU    10     -20.187  35.432   1.021  1.00 14.14           N
ATOM     67  CA  LEU    10     -21.183  36.018   0.143  1.00 15.70           C
ATOM     68  CB  LEU    10     -20.580  36.459  -1.201  1.00 16.55           C
ATOM     69  CG  LEU    10     -20.226  37.923  -1.321  1.00 18.07           C
ATOM     70  CD1 LEU    10     -19.435  38.165  -2.626  1.00 18.10           C
ATOM     71  CD2 LEU    10     -21.495  38.769  -1.285  1.00 16.77           C
ATOM     72  C   LEU    10     -22.364  35.072  -0.083  1.00 15.96           C
ATOM     73  O   LEU    10     -23.511  35.520  -0.035  1.00 16.63           O
ATOM     74  N   MET    11     -22.097  33.792  -0.326  0.70 16.06           N
ATOM     76  CA  MET    11     -23.179  32.843  -0.534  0.70 17.38           C
ATOM     78  CB  MET    11     -22.637  31.461  -0.863  0.70 20.17           C
ATOM     80  CG  MET    11     -22.166  31.316  -2.273  0.70 25.34           C
ATOM     82  SD  MET    11     -23.611  30.818  -3.503  0.70 46.93          SE
ATOM     84  CE  MET    11     -22.374  30.088  -4.856  0.70 32.85           C
ATOM     86  C   MET    11     -24.065  32.759   0.707  0.70 15.90           C
ATOM     88  O   MET    11     -25.298  32.724   0.592  0.70 14.79           O
ATOM     90  N   GLU    12     -23.436  32.726   1.888  1.00 13.16           N
ATOM     91  CA  GLU    12     -24.186  32.691   3.141  1.00 12.28           C
ATOM     92  CB  GLU    12     -23.255  32.550   4.367  1.00 11.62           C
ATOM     93  CG  GLU    12     -24.006  32.676   5.679  1.00 12.98           C
ATOM     94  CD  GLU    12     -24.899  31.451   5.972  1.00 17.78           C
ATOM     95  OE1 GLU    12     -24.548  30.339   5.520  1.00 20.61           O
ATOM     96  OE2 GLU    12     -25.952  31.593   6.636  1.00 18.33           O
ATOM     97  C   GLU    12     -25.062  33.946   3.278  1.00 11.77           C
ATOM     98  O   GLU    12     -26.263  33.868   3.569  1.00 10.95           O
ATOM     99  N   VAL    13     -24.441  35.104   3.102  1.00 11.38           N
ATOM    100  CA  VAL    13     -25.143  36.347   3.297  1.00 11.79           C
ATOM    101  CB  VAL    13     -24.168  37.555   3.216  1.00 11.85           C
ATOM    102  CG1 VAL    13     -24.903  38.816   2.771  1.00 13.25           C
ATOM    103  CG2 VAL    13     -23.437  37.739   4.528  1.00 12.09           C
ATOM    104  C   VAL    13     -26.264  36.469   2.270  1.00 12.08           C
ATOM    105  O   VAL    13     -27.360  36.860   2.613  1.00 12.20           O
ATOM    106  N   ALA    14     -25.987  36.132   1.016  1.00 11.94           N
ATOM    107  CA  ALA    14     -27.028  36.192  -0.026  1.00 12.57           C
ATOM    108  CB  ALA    14     -26.434  35.847  -1.397  1.00 12.81           C
ATOM    109  C   ALA    14     -28.224  35.272   0.324  1.00 12.70           C
ATOM    110  O   ALA    14     -29.404  35.681   0.225  1.00 12.49           O
ATOM    111  N   THR    15     -27.933  34.045   0.752  1.00 12.08           N
ATOM    112  CA  THR    15     -29.000  33.092   1.088  1.00 13.57           C
ATOM    113  CB  THR    15     -28.420  31.727   1.526  1.00 13.02           C
ATOM    114  OG1 THR    15     -27.592  31.204   0.477  1.00 13.54           O
ATOM    115  CG2 THR    15     -29.544  30.705   1.864  1.00 14.11           C
ATOM    116  C   THR    15     -29.885  33.685   2.197  1.00 13.81           C
ATOM    117  O   THR    15     -31.100  33.676   2.080  1.00 14.69           O
ATOM    118  N   GLU    16     -29.283  34.229   3.251  0.50 12.86           N
ATOM    120  CA  GLU    16     -30.060  34.743   4.392  0.50 12.65           C
ATOM    122  CB  GLU    16     -29.168  34.850   5.619  0.50 11.98           C
ATOM    124  CG  GLU    16     -28.366  33.560   5.847  0.50 10.56           C
ATOM    126  CD  GLU    16     -29.193  32.437   6.436  0.50 10.50           C
ATOM    128  OE1 GLU    16     -29.690  32.653   7.554  0.50 13.56           O
ATOM    130  OE2 GLU    16     -29.343  31.334   5.814  0.50  9.37           O
ATOM    132  C   GLU    16     -30.844  36.053   4.135  0.50 13.06           C
ATOM    134  O   GLU    16     -31.941  36.247   4.680  0.50 12.44           O
ATOM    136  N   LEU    17     -30.289  36.937   3.304  1.00 13.39           N
ATOM    137  CA  LEU    17     -30.999  38.157   2.904  1.00 13.60           C
ATOM    138  CB  LEU    17     -30.022  39.257   2.439  1.00 13.92           C
ATOM    139  CG  LEU    17     -29.168  39.859   3.564  1.00 15.45           C
ATOM    140  CD1 LEU    17     -28.242  40.964   3.019  1.00 18.76           C
ATOM    141  CD2 LEU    17     -30.008  40.355   4.753  1.00 18.21           C
ATOM    142  C   LEU    17     -32.079  37.907   1.841  1.00 13.42           C
ATOM    143  O   LEU    17     -33.201  38.400   2.004  1.00 13.35           O
ATOM    144  N   PHE    18     -31.772  37.132   0.800  1.00 12.52           N
ATOM    145  CA  PHE    18     -32.789  36.767  -0.188  1.00 12.55           C
ATOM    146  CB  PHE    18     -32.168  36.032  -1.355  1.00 12.74           C
ATOM    147  CG  PHE    18     -31.341  36.895  -2.267  1.00 11.67           C
ATOM    148  CD1 PHE    18     -31.865  38.079  -2.813  1.00 12.22           C
ATOM    149  CE1 PHE    18     -31.138  38.864  -3.706  1.00 12.93           C
ATOM    150  CZ  PHE    18     -29.843  38.455  -4.104  1.00 13.62           C
ATOM    151  CE2 PHE    18     -29.308  37.240  -3.582  1.00 11.19           C
ATOM    152  CD2 PHE    18     -30.083  36.472  -2.677  1.00 11.90           C
ATOM    153  C   PHE    18     -33.889  35.866   0.419  1.00 13.51           C
ATOM    154  O   PHE    18     -35.054  35.962   0.015  1.00 15.25           O
ATOM    155  N   ALA    19     -33.532  34.996   1.373  1.00 13.39           N
ATOM    156  CA  ALA    19     -34.553  34.208   2.061  1.00 15.05           C
ATOM    157  CB  ALA    19     -33.942  33.133   2.992  1.00 14.27           C
ATOM    158  C   ALA    19     -35.536  35.094   2.817  1.00 15.36           C
ATOM    159  O   ALA    19     -36.754  34.842   2.737  1.00 16.78           O
ATOM    160  N   GLN    20     -35.009  36.097   3.541  0.70 16.27           N
ATOM    162  CA  GLN    20     -35.806  37.053   4.335  0.70 16.80           C
ATOM    164  CB  GLN    20     -34.946  37.989   5.239  0.70 17.01           C
ATOM    166  CG  GLN    20     -35.745  39.306   5.640  0.70 16.81           C
ATOM    168  CD  GLN    20     -35.206  40.143   6.812  0.70 17.74           C
ATOM    170  OE1 GLN    20     -35.154  41.393   6.736  0.70 13.85           O
ATOM    172  NE2 GLN    20     -34.830  39.472   7.903  0.70 18.70           N
ATOM    174  C   GLN    20     -36.691  37.941   3.482  0.70 17.07           C
ATOM    176  O   GLN    20     -37.900  38.009   3.701  0.70 17.23           O
ATOM    178  N   LYS    21     -36.060  38.636   2.537  1.00 15.44           N
ATOM    179  CA  LYS    21     -36.656  39.778   1.820  1.00 16.20           C
ATOM    180  CB  LYS    21     -35.693  40.954   1.797  1.00 16.65           C
ATOM    181  CG  LYS    21     -35.259  41.391   3.184  1.00 19.64           C
ATOM    182  CD  LYS    21     -34.363  42.583   3.043  1.00 22.59           C
ATOM    183  CE  LYS    21     -33.720  42.901   4.359  1.00 25.71           C
ATOM    184  NZ  LYS    21     -33.292  44.316   4.378  1.00 29.79           N
ATOM    185  C   LYS    21     -37.021  39.482   0.389  1.00 15.03           C
ATOM    186  O   LYS    21     -37.639  40.317  -0.275  1.00 16.30           O
ATOM    187  N   GLY    22     -36.632  38.313  -0.101  1.00 14.81           N
ATOM    188  CA  GLY    22     -36.879  37.954  -1.501  1.00 12.41           C
ATOM    189  C   GLY    22     -35.967  38.743  -2.431  1.00 13.23           C
ATOM    190  O   GLY    22     -35.355  39.762  -2.034  1.00 13.65           O
ATOM    191  N   PHE    23     -35.857  38.255  -3.660  1.00 12.90           N
ATOM    192  CA  PHE    23     -35.064  38.952  -4.675  1.00 13.24           C
ATOM    193  CB  PHE    23     -35.255  38.297  -6.043  1.00 15.31           C
ATOM    194  CG  PHE    23     -34.544  39.016  -7.130  1.00 16.26           C
ATOM    195  CD1 PHE    23     -33.214  38.729  -7.414  1.00 17.28           C
ATOM    196  CE1 PHE    23     -32.528  39.446  -8.406  1.00 17.88           C
ATOM    197  CZ  PHE    23     -33.173  40.390  -9.137  1.00 18.69           C
ATOM    198  CE2 PHE    23     -34.531  40.677  -8.884  1.00 18.23           C
ATOM    199  CD2 PHE    23     -35.193  40.000  -7.883  1.00 18.32           C
ATOM    200  C   PHE    23     -35.468  40.425  -4.758  1.00 14.16           C
ATOM    201  O   PHE    23     -34.604  41.312  -4.880  1.00 14.45           O
ATOM    202  N   TYR    24     -36.778  40.690  -4.743  1.00 14.52           N
ATOM    203  CA  TYR    24     -37.263  42.057  -4.998  1.00 15.59           C
ATOM    204  CB  TYR    24     -38.733  42.085  -5.422  1.00 13.51           C
ATOM    205  CG  TYR    24     -38.963  41.406  -6.781  1.00 13.47           C
ATOM    206  CD1 TYR    24     -38.665  42.064  -7.967  1.00 12.55           C
ATOM    207  CE1 TYR    24     -38.890  41.458  -9.241  1.00 13.28           C
ATOM    208  CZ  TYR    24     -39.399  40.139  -9.303  1.00 10.43           C
ATOM    209  OH  TYR    24     -39.630  39.577 -10.572  1.00 11.31           O
ATOM    210  CE2 TYR    24     -39.713  39.475  -8.126  1.00 11.68           C
ATOM    211  CD2 TYR    24     -39.493  40.106  -6.858  1.00 14.21           C
ATOM    212  C   TYR    24     -37.080  42.970  -3.806  1.00 16.80           C
ATOM    213  O   TYR    24     -37.286  44.167  -3.939  1.00 18.89           O
ATOM    214  N   GLY    25     -36.702  42.429  -2.656  1.00 16.86           N
ATOM    215  CA  GLY    25     -36.488  43.287  -1.478  1.00 17.30           C
ATOM    216  C   GLY    25     -35.036  43.519  -1.070  1.00 18.19           C
ATOM    217  O   GLY    25     -34.787  44.141  -0.042  1.00 18.97           O
ATOM    218  N   VAL    26     -34.080  42.983  -1.822  1.00 17.80           N
ATOM    219  CA  VAL    26     -32.653  43.017  -1.434  1.00 17.86           C
ATOM    220  CB  VAL    26     -32.053  41.567  -1.526  1.00 16.88           C
ATOM    221  CG1 VAL    26     -30.493  41.578  -1.523  1.00 19.19           C
ATOM    222  CG2 VAL    26     -32.546  40.691  -0.382  1.00 17.09           C
ATOM    223  C   VAL    26     -31.896  43.951  -2.405  1.00 18.57           C
ATOM    224  O   VAL    26     -32.112  43.860  -3.619  1.00 19.26           O
ATOM    225  N   SER    27     -31.024  44.837  -1.900  1.00 18.29           N
ATOM    226  CA  SER    27     -30.188  45.651  -2.802  1.00 18.73           C
ATOM    227  CB  SER    27     -30.240  47.135  -2.451  1.00 18.20           C
ATOM    228  OG  SER    27     -29.499  47.385  -1.297  1.00 19.53           O
ATOM    229  C   SER    27     -28.743  45.196  -2.781  1.00 18.39           C
ATOM    230  O   SER    27     -28.296  44.592  -1.823  1.00 18.07           O
ATOM    231  N   ILE    28     -28.001  45.507  -3.836  1.00 18.31           N
ATOM    232  CA  ILE    28     -26.587  45.151  -3.866  1.00 18.54           C
ATOM    233  CB  ILE    28     -25.953  45.425  -5.232  1.00 18.62           C
ATOM    234  CG1 ILE    28     -24.599  44.703  -5.348  1.00 18.14           C
ATOM    235  CD1 ILE    28     -23.953  44.785  -6.743  1.00 19.13           C
ATOM    236  CG2 ILE    28     -25.915  46.963  -5.537  1.00 18.10           C
ATOM    237  C   ILE    28     -25.825  45.846  -2.714  1.00 18.97           C
ATOM    238  O   ILE    28     -24.902  45.274  -2.156  1.00 17.66           O
ATOM    239  N   ARG    29     -26.211  47.076  -2.360  1.00 19.97           N
ATOM    240  CA  ARG    29     -25.589  47.737  -1.207  1.00 22.13           C
ATOM    241  CB  ARG    29     -26.120  49.174  -1.012  1.00 21.53           C
ATOM    242  CG  ARG    29     -25.467  49.925   0.170  1.00 25.16           C
ATOM    243  CD  ARG    29     -26.316  51.109   0.743  1.00 26.22           C
ATOM    244  NE  ARG    29     -27.682  50.707   1.142  1.00 35.15           N
ATOM    245  CZ  ARG    29     -28.010  50.032   2.256  1.00 36.75           C
ATOM    246  NH1 ARG    29     -27.084  49.650   3.137  1.00 38.29           N
ATOM    247  NH2 ARG    29     -29.285  49.730   2.492  1.00 38.04           N
ATOM    248  C   ARG    29     -25.725  46.902   0.085  1.00 21.09           C
ATOM    249  O   ARG    29     -24.730  46.691   0.798  1.00 19.92           O
ATOM    250  N   GLU    30     -26.937  46.412   0.371  1.00 22.16           N
ATOM    251  CA  GLU    30     -27.160  45.541   1.551  1.00 22.56           C
ATOM    252  CB  GLU    30     -28.618  45.119   1.693  1.00 23.46           C
ATOM    253  CG  GLU    30     -29.623  46.242   1.841  1.00 28.08           C
ATOM    254  CD  GLU    30     -31.046  45.786   1.483  1.00 34.28           C
ATOM    255  OE1 GLU    30     -31.275  44.555   1.368  1.00 33.74           O
ATOM    256  OE2 GLU    30     -31.935  46.662   1.307  1.00 37.15           O
ATOM    257  C   GLU    30     -26.301  44.272   1.533  1.00 21.44           C
ATOM    258  O   GLU    30     -25.795  43.856   2.577  1.00 21.23           O
ATOM    259  N   LEU    31     -26.170  43.640   0.359  1.00 19.98           N
ATOM    260  CA  LEU    31     -25.338  42.431   0.251  1.00 18.96           C
ATOM    261  CB  LEU    31     -25.426  41.823  -1.145  1.00 18.00           C
ATOM    262  CG  LEU    31     -26.768  41.239  -1.562  1.00 18.12           C
ATOM    263  CD1 LEU    31     -26.678  40.931  -3.057  1.00 16.01           C
ATOM    264  CD2 LEU    31     -27.078  39.993  -0.744  1.00 18.33           C
ATOM    265  C   LEU    31     -23.871  42.715   0.588  1.00 18.24           C
ATOM    266  O   LEU    31     -23.227  41.984   1.363  1.00 18.55           O
ATOM    267  N   ALA    32     -23.328  43.776  -0.005  1.00 18.07           N
ATOM    268  CA  ALA    32     -21.928  44.131   0.234  1.00 17.87           C
ATOM    269  CB  ALA    32     -21.533  45.282  -0.659  1.00 17.05           C
ATOM    270  C   ALA    32     -21.689  44.449   1.719  1.00 18.48           C
ATOM    271  O   ALA    32     -20.741  43.938   2.338  1.00 18.50           O
ATOM    272  N   GLN    33     -22.577  45.264   2.282  1.00 18.14           N
ATOM    273  CA  GLN    33     -22.467  45.687   3.672  1.00 18.66           C
ATOM    274  CB  GLN    33     -23.613  46.652   4.012  1.00 18.81           C
ATOM    279  C   GLN    33     -22.496  44.452   4.579  1.00 18.25           C
ATOM    280  O   GLN    33     -21.649  44.307   5.470  1.00 19.06           O
ATOM    281  N   ALA    34     -23.456  43.552   4.355  1.00 18.35           N
ATOM    282  CA  ALA    34     -23.588  42.387   5.224  1.00 17.57           C
ATOM    283  CB  ALA    34     -24.915  41.670   4.988  1.00 18.88           C
ATOM    284  C   ALA    34     -22.400  41.424   5.094  1.00 17.93           C
ATOM    285  O   ALA    34     -22.007  40.800   6.073  1.00 18.07           O
ATOM    286  N   ALA    35     -21.812  41.324   3.902  1.00 17.59           N
ATOM    287  CA  ALA    35     -20.653  40.434   3.662  1.00 17.45           C
ATOM    288  CB  ALA    35     -20.742  39.832   2.241  1.00 17.60           C
ATOM    289  C   ALA    35     -19.271  41.084   3.858  1.00 17.39           C
ATOM    290  O   ALA    35     -18.253  40.386   3.869  1.00 17.10           O
ATOM    291  N   GLY    36     -19.216  42.410   3.975  1.00 17.53           N
ATOM    292  CA  GLY    36     -17.934  43.120   4.053  1.00 17.54           C
ATOM    293  C   GLY    36     -17.142  43.046   2.755  1.00 18.20           C
ATOM    294  O   GLY    36     -15.894  43.109   2.760  1.00 18.83           O
ATOM    295  N   ALA    37     -17.868  42.917   1.638  1.00 18.05           N
ATOM    296  CA  ALA    37     -17.298  42.947   0.287  1.00 17.70           C
ATOM    297  CB  ALA    37     -17.905  41.813  -0.553  1.00 17.69           C
ATOM    298  C   ALA    37     -17.594  44.299  -0.377  1.00 17.25           C
ATOM    299  O   ALA    37     -18.512  44.995   0.029  1.00 17.90           O
ATOM    300  N   SER    38     -16.844  44.680  -1.401  1.00 16.01           N
ATOM    301  CA  SER    38     -17.181  45.941  -2.083  1.00 15.66           C
ATOM    302  CB  SER    38     -15.986  46.530  -2.815  1.00 15.99           C
ATOM    303  OG  SER    38     -15.465  45.574  -3.709  1.00 15.63           O
ATOM    304  C   SER    38     -18.275  45.670  -3.090  1.00 15.23           C
ATOM    305  O   SER    38     -18.390  44.545  -3.568  1.00 14.69           O
ATOM    306  N   ILE    39     -19.054  46.696  -3.426  1.00 14.99           N
ATOM    307  CA  ILE    39     -20.019  46.586  -4.524  1.00 16.34           C
ATOM    308  CB  ILE    39     -20.795  47.908  -4.725  1.00 18.03           C
ATOM    309  CG1 ILE    39     -21.771  48.099  -3.551  1.00 18.95           C
ATOM    310  CD1 ILE    39     -22.260  49.551  -3.403  1.00 24.07           C
ATOM    311  CG2 ILE    39     -21.568  47.905  -6.053  1.00 19.22           C
ATOM    312  C   ILE    39     -19.321  46.142  -5.820  1.00 14.71           C
ATOM    313  O   ILE    39     -19.846  45.293  -6.544  1.00 14.07           O
ATOM    314  N   SER    40     -18.089  46.604  -6.010  0.50 14.67           N
ATOM    316  CA  SER    40     -17.279  46.176  -7.148  0.50 14.62           C
ATOM    318  CB  SER    40     -16.053  47.060  -7.335  0.50 14.94           C
ATOM    320  OG  SER    40     -16.458  48.367  -7.690  0.50 15.23           O
ATOM    322  C   SER    40     -16.894  44.691  -7.144  0.50 14.74           C
ATOM    324  O   SER    40     -17.018  44.048  -8.190  0.50 13.11           O
ATOM    326  N   MET    41     -16.429  44.140  -6.011  0.70 14.50           N
ATOM    328  CA  MET    41     -16.178  42.699  -5.979  0.70 17.69           C
ATOM    330  CB  MET    41     -15.783  42.221  -4.589  0.70 17.10           C
ATOM    332  CG  MET    41     -14.312  42.342  -4.347  0.70 22.14           C
ATOM    334  SD  MET    41     -13.942  42.349  -2.431  0.70 31.19          SE
ATOM    336  CE  MET    41     -12.415  43.576  -2.469  0.70 24.49           C
ATOM    338  C   MET    41     -17.447  41.995  -6.467  0.70 13.85           C
ATOM    340  O   MET    41     -17.391  41.116  -7.335  0.70 12.19           O
ATOM    342  N   ILE    42     -18.586  42.445  -5.946  1.00 11.54           N
ATOM    343  CA  ILE    42     -19.860  41.745  -6.191  1.00 10.80           C
ATOM    344  CB  ILE    42     -21.001  42.280  -5.316  1.00 11.27           C
ATOM    345  CG1 ILE    42     -20.695  41.978  -3.842  1.00 13.93           C
ATOM    346  CD1 ILE    42     -21.839  42.300  -2.903  1.00 16.88           C
ATOM    347  CG2 ILE    42     -22.327  41.616  -5.716  1.00 12.87           C
ATOM    348  C   ILE    42     -20.219  41.838  -7.658  1.00  8.83           C
ATOM    349  O   ILE    42     -20.497  40.819  -8.306  1.00  9.33           O
ATOM    350  N   SER    43     -20.157  43.052  -8.211  1.00  8.95           N
ATOM    351  CA  SER    43     -20.581  43.239  -9.602  1.00  9.74           C
ATOM    352  CB  SER    43     -20.655  44.729  -9.931  1.00 10.68           C
ATOM    353  OG  SER    43     -21.770  45.278  -9.279  1.00 13.08           O
ATOM    354  C   SER    43     -19.645  42.587 -10.619  1.00  9.62           C
ATOM    355  O   SER    43     -20.105  42.053 -11.624  1.00  9.13           O
ATOM    356  N   TYR    44     -18.328  42.697 -10.382  1.00  9.20           N
ATOM    357  CA  TYR    44     -17.361  42.244 -11.376  1.00 10.08           C
ATOM    358  CB  TYR    44     -16.121  43.137 -11.344  1.00  9.76           C
ATOM    359  CG  TYR    44     -16.373  44.487 -11.942  1.00  8.65           C
ATOM    360  CD1 TYR    44     -16.965  45.500 -11.184  1.00  8.93           C
ATOM    361  CE1 TYR    44     -17.202  46.730 -11.711  1.00 10.45           C
ATOM    362  CZ  TYR    44     -16.853  46.987 -13.027  1.00 10.79           C
ATOM    363  OH  TYR    44     -17.090  48.220 -13.553  1.00 11.57           O
ATOM    364  CE2 TYR    44     -16.260  46.002 -13.818  1.00 10.86           C
ATOM    365  CD2 TYR    44     -16.019  44.758 -13.255  1.00  9.35           C
ATOM    366  C   TYR    44     -16.923  40.795 -11.222  1.00 12.28           C
ATOM    367  O   TYR    44     -16.468  40.193 -12.203  1.00 12.21           O
ATOM    368  N   HIS    45     -16.993  40.271 -10.000  1.00 14.53           N
ATOM    369  CA  HIS    45     -16.489  38.928  -9.730  1.00 17.90           C
ATOM    370  CB  HIS    45     -15.347  38.951  -8.714  1.00 18.81           C
ATOM    371  CG  HIS    45     -14.062  39.424  -9.294  1.00 21.69           C
ATOM    372  ND1 HIS    45     -13.118  40.111  -8.564  1.00 26.38           N
ATOM    373  CE1 HIS    45     -12.092  40.405  -9.346  1.00 27.60           C
ATOM    374  NE2 HIS    45     -12.350  39.958 -10.563  1.00 26.67           N
ATOM    375  CD2 HIS    45     -13.574  39.339 -10.558  1.00 25.29           C
ATOM    376  C   HIS    45     -17.532  37.898  -9.348  1.00 19.42           C
ATOM    377  O   HIS    45     -17.334  36.722  -9.630  1.00 19.75           O
ATOM    378  N   PHE    46     -18.630  38.324  -8.726  1.00 20.52           N
ATOM    379  CA  PHE    46     -19.661  37.377  -8.261  1.00 22.82           C
ATOM    380  CB  PHE    46     -19.800  37.465  -6.732  1.00 23.98           C
ATOM    381  CG  PHE    46     -18.496  37.308  -6.003  1.00 26.04           C
ATOM    382  CD1 PHE    46     -18.012  36.039  -5.670  1.00 29.01           C
ATOM    383  CE1 PHE    46     -16.817  35.893  -5.005  1.00 27.12           C
ATOM    384  CZ  PHE    46     -16.071  37.013  -4.649  1.00 28.27           C
ATOM    385  CE2 PHE    46     -16.542  38.280  -4.963  1.00 29.34           C
ATOM    386  CD2 PHE    46     -17.743  38.419  -5.640  1.00 27.17           C
ATOM    387  C   PHE    46     -21.004  37.504  -8.954  1.00 22.70           C
ATOM    388  O   PHE    46     -22.017  36.978  -8.483  1.00 25.73           O
ATOM    389  N   GLY    47     -21.020  38.197 -10.083  1.00 20.71           N
ATOM    390  CA  GLY    47     -22.178  38.260 -10.943  1.00 19.73           C
ATOM    391  C   GLY    47     -23.257  39.227 -10.550  1.00 18.52           C
ATOM    392  O   GLY    47     -24.373  39.148 -11.073  1.00 20.99           O
ATOM    393  N   GLY    48     -22.955  40.137  -9.620  1.00 14.66           N
ATOM    394  CA  GLY    48     -23.926  41.115  -9.145  1.00 14.41           C
ATOM    395  C   GLY    48     -25.035  40.479  -8.295  1.00 13.29           C
ATOM    396  O   GLY    48     -24.959  39.296  -7.948  1.00 12.06           O
ATOM    397  N   LYS    49     -26.021  41.290  -7.929  1.00 13.51           N
ATOM    398  CA  LYS    49     -27.206  40.794  -7.200  1.00 13.00           C
ATOM    399  CB  LYS    49     -28.212  41.934  -7.086  1.00 14.01           C
ATOM    400  CG  LYS    49     -29.503  41.518  -6.350  1.00 15.37           C
ATOM    401  CD  LYS    49     -30.528  42.649  -6.447  1.00 16.73           C
ATOM    402  CE  LYS    49     -31.905  42.078  -6.083  1.00 17.71           C
ATOM    403  NZ  LYS    49     -32.895  43.218  -6.101  1.00 18.77           N
ATOM    404  C   LYS    49     -27.809  39.595  -7.932  1.00 13.68           C
ATOM    405  O   LYS    49     -28.212  38.583  -7.331  1.00 13.27           O
ATOM    406  N   GLU    50     -27.876  39.703  -9.258  1.00 12.63           N
ATOM    407  CA  GLU    50     -28.627  38.725 -10.042  1.00 12.69           C
ATOM    408  CB  GLU    50     -28.814  39.232 -11.468  1.00 13.68           C
ATOM    409  CG  GLU    50     -29.657  40.500 -11.528  1.00 14.16           C
ATOM    410  CD  GLU    50     -28.887  41.815 -11.286  1.00 16.98           C
ATOM    411  OE1 GLU    50     -27.638  41.867 -11.018  1.00 15.01           O
ATOM    412  OE2 GLU    50     -29.566  42.854 -11.451  1.00 19.39           O
ATOM    413  C   GLU    50     -27.883  37.393 -10.048  1.00 12.35           C
ATOM    414  O   GLU    50     -28.506  36.350  -9.816  1.00 13.25           O
ATOM    415  N   GLY    51     -26.567  37.455 -10.306  1.00 11.97           N
ATOM    416  CA  GLY    51     -25.695  36.286 -10.303  1.00 11.39           C
ATOM    417  C   GLY    51     -25.724  35.592  -8.952  1.00 13.31           C
ATOM    418  O   GLY    51     -25.865  34.369  -8.874  1.00 12.68           O
ATOM    419  N   LEU    52     -25.637  36.365  -7.877  1.00 12.96           N
ATOM    420  CA  LEU    52     -25.702  35.752  -6.544  1.00 13.84           C
ATOM    421  CB  LEU    52     -25.453  36.774  -5.450  1.00 13.00           C
ATOM    422  CG  LEU    52     -24.017  37.257  -5.300  1.00 15.32           C
ATOM    423  CD1 LEU    52     -24.026  38.415  -4.321  1.00 17.15           C
ATOM    424  CD2 LEU    52     -23.089  36.110  -4.862  1.00 13.25           C
ATOM    425  C   LEU    52     -27.047  35.092  -6.282  1.00 13.75           C
ATOM    426  O   LEU    52     -27.092  34.016  -5.680  1.00 14.21           O
ATOM    427  N   TYR    53     -28.140  35.744  -6.693  1.00 14.29           N
ATOM    428  CA  TYR    53     -29.441  35.176  -6.517  1.00 14.44           C
ATOM    429  CB  TYR    53     -30.541  36.161  -6.936  1.00 12.90           C
ATOM    430  CG  TYR    53     -31.928  35.606  -6.681  1.00 13.47           C
ATOM    431  CD1 TYR    53     -32.405  35.437  -5.365  1.00 13.59           C
ATOM    432  CE1 TYR    53     -33.679  34.910  -5.123  1.00 14.34           C
ATOM    433  CZ  TYR    53     -34.477  34.537  -6.198  1.00 13.72           C
ATOM    434  OH  TYR    53     -35.718  34.039  -5.965  1.00 13.83           O
ATOM    435  CE2 TYR    53     -34.023  34.711  -7.525  1.00 13.18           C
ATOM    436  CD2 TYR    53     -32.751  35.220  -7.740  1.00 11.75           C
ATOM    437  C   TYR    53     -29.578  33.863  -7.306  1.00 14.35           C
ATOM    438  O   TYR    53     -30.064  32.892  -6.754  1.00 14.84           O
ATOM    439  N   ALA    54     -29.125  33.849  -8.569  1.00 14.57           N
ATOM    440  CA  ALA    54     -29.145  32.612  -9.394  1.00 14.76           C
ATOM    441  CB  ALA    54     -28.572  32.882 -10.785  1.00 15.38           C
ATOM    442  C   ALA    54     -28.382  31.465  -8.737  1.00 16.02           C
ATOM    443  O   ALA    54     -28.853  30.302  -8.752  1.00 16.58           O
ATOM    444  N   ALA    55     -27.206  31.790  -8.179  1.00 15.71           N
ATOM    445  CA  ALA    55     -26.349  30.797  -7.512  1.00 16.60           C
ATOM    446  CB  ALA    55     -24.985  31.418  -7.114  1.00 15.94           C
ATOM    447  C   ALA    55     -27.087  30.239  -6.293  1.00 16.62           C
ATOM    448  O   ALA    55     -27.124  29.027  -6.079  1.00 17.79           O
ATOM    449  N   VAL    56     -27.698  31.121  -5.509  1.00 16.55           N
ATOM    450  CA  VAL    56     -28.442  30.724  -4.309  1.00 17.16           C
ATOM    451  CB  VAL    56     -28.958  31.984  -3.551  1.00 17.77           C
ATOM    452  CG1 VAL    56     -30.068  31.623  -2.591  1.00 18.51           C
ATOM    453  CG2 VAL    56     -27.808  32.716  -2.799  1.00 16.47           C
ATOM    454  C   VAL    56     -29.643  29.805  -4.680  1.00 17.90           C
ATOM    455  O   VAL    56     -29.872  28.769  -4.064  1.00 18.42           O
ATOM    456  N   LEU    57     -30.409  30.209  -5.690  1.00 18.83           N
ATOM    457  CA  LEU    57     -31.588  29.428  -6.064  1.00 20.44           C
ATOM    458  CB  LEU    57     -32.429  30.224  -7.058  1.00 19.98           C
ATOM    459  CG  LEU    57     -33.922  29.962  -7.106  1.00 25.44           C
ATOM    460  CD1 LEU    57     -34.592  30.145  -5.755  1.00 24.83           C
ATOM    461  CD2 LEU    57     -34.480  30.939  -8.118  1.00 27.85           C
ATOM    462  C   LEU    57     -31.165  28.050  -6.627  1.00 20.90           C
ATOM    463  O   LEU    57     -31.808  27.031  -6.345  1.00 20.75           O
ATOM    464  N   GLN    58     -30.052  28.016  -7.360  1.00 21.09           N
ATOM    465  CA  GLN    58     -29.551  26.768  -7.929  1.00 22.36           C
ATOM    466  CB  GLN    58     -28.346  26.998  -8.858  1.00 23.54           C
ATOM    467  CG  GLN    58     -27.960  25.733  -9.635  1.00 27.99           C
ATOM    468  CD  GLN    58     -29.191  25.021 -10.220  1.00 35.26           C
ATOM    469  OE1 GLN    58     -29.888  25.570 -11.083  1.00 37.09           O
ATOM    470  NE2 GLN    58     -29.469  23.796  -9.736  1.00 38.37           N
ATOM    471  C   GLN    58     -29.205  25.793  -6.803  1.00 22.27           C
ATOM    472  O   GLN    58     -29.522  24.575  -6.887  1.00 22.87           O
ATOM    473  N   GLU    59     -28.579  26.306  -5.741  0.50 21.38           N
ATOM    475  CA  GLU    59     -28.271  25.503  -4.553  0.50 21.43           C
ATOM    477  CB  GLU    59     -27.388  26.269  -3.553  0.50 21.44           C
ATOM    479  CG  GLU    59     -26.869  25.393  -2.378  0.50 21.69           C
ATOM    481  CD  GLU    59     -26.114  26.171  -1.293  0.50 22.85           C
ATOM    483  OE1 GLU    59     -25.921  27.400  -1.427  0.50 25.49           O
ATOM    485  OE2 GLU    59     -25.705  25.539  -0.292  0.50 22.88           O
ATOM    487  C   GLU    59     -29.535  25.040  -3.848  0.50 20.81           C
ATOM    489  O   GLU    59     -29.586  23.907  -3.359  0.50 20.84           O
ATOM    491  N   GLN    60     -30.526  25.927  -3.763  1.00 20.01           N
ATOM    492  CA  GLN    60     -31.823  25.588  -3.146  1.00 20.01           C
ATOM    493  CB  GLN    60     -32.751  26.812  -3.069  1.00 18.91           C
ATOM    494  CG  GLN    60     -32.254  27.942  -2.169  1.00 22.57           C
ATOM    495  CD  GLN    60     -32.132  27.523  -0.695  1.00 23.52           C
ATOM    496  OE1 GLN    60     -33.063  26.939  -0.124  1.00 25.17           O
ATOM    497  NE2 GLN    60     -30.987  27.798  -0.090  1.00 23.26           N
ATOM    498  C   GLN    60     -32.527  24.444  -3.865  1.00 18.38           C
ATOM    499  O   GLN    60     -33.135  23.578  -3.222  1.00 19.77           O
ATOM    500  N   PHE    61     -32.428  24.422  -5.192  1.00 18.84           N
ATOM    501  CA  PHE    61     -33.171  23.452  -5.980  1.00 18.05           C
ATOM    502  CB  PHE    61     -33.920  24.171  -7.089  1.00 18.50           C
ATOM    503  CG  PHE    61     -35.166  24.855  -6.603  1.00 16.29           C
ATOM    504  CD1 PHE    61     -35.097  26.142  -6.066  1.00 16.96           C
ATOM    505  CE1 PHE    61     -36.246  26.777  -5.586  1.00 17.57           C
ATOM    506  CZ  PHE    61     -37.469  26.128  -5.639  1.00 16.05           C
ATOM    507  CE2 PHE    61     -37.562  24.840  -6.149  1.00 16.94           C
ATOM    508  CD2 PHE    61     -36.415  24.206  -6.655  1.00 16.84           C
ATOM    509  C   PHE    61     -32.316  22.293  -6.529  1.00 18.86           C
ATOM    510  O   PHE    61     -32.799  21.474  -7.288  1.00 17.68           O
ATOM    511  N   ALA    62     -31.039  22.250  -6.153  1.00 19.75           N
ATOM    512  CA  ALA    62     -30.116  21.245  -6.684  1.00 20.70           C
ATOM    513  CB  ALA    62     -28.776  21.377  -5.988  1.00 21.27           C
ATOM    514  C   ALA    62     -30.639  19.784  -6.602  1.00 21.89           C
ATOM    515  O   ALA    62     -30.568  19.023  -7.588  1.00 22.43           O
ATOM    516  N   CYS    63     -31.180  19.433  -5.431  0.50 22.09           N
ATOM    518  CA  CYS    63     -31.713  18.088  -5.137  0.50 22.45           C
ATOM    520  CB  CYS    63     -32.194  18.002  -3.682  0.50 21.93           C
ATOM    522  SG  CYS    63     -30.917  17.628  -2.464  0.50 27.26           S
ATOM    524  C   CYS    63     -32.836  17.625  -6.072  0.50 21.59           C
ATOM    526  O   CYS    63     -33.089  16.419  -6.196  0.50 20.76           O
ATOM    528  N   PHE    64     -33.520  18.570  -6.711  1.00 20.75           N
ATOM    529  CA  PHE    64     -34.567  18.235  -7.659  1.00 20.96           C
ATOM    530  CB  PHE    64     -35.405  19.451  -8.035  1.00 19.37           C
ATOM    531  CG  PHE    64     -36.415  19.870  -6.996  1.00 19.26           C
ATOM    532  CD1 PHE    64     -36.028  20.573  -5.872  1.00 19.73           C
ATOM    533  CE1 PHE    64     -36.994  21.017  -4.934  1.00 18.87           C
ATOM    534  CZ  PHE    64     -38.331  20.739  -5.155  1.00 17.71           C
ATOM    535  CE2 PHE    64     -38.722  20.056  -6.260  1.00 18.01           C
ATOM    536  CD2 PHE    64     -37.778  19.643  -7.202  1.00 18.03           C
ATOM    537  C   PHE    64     -34.008  17.587  -8.957  1.00 21.96           C
ATOM    538  O   PHE    64     -34.743  16.934  -9.688  1.00 23.37           O
ATOM    539  N   GLY    65     -32.716  17.728  -9.209  1.00 22.10           N
ATOM    540  CA  GLY    65     -32.106  17.074 -10.371  1.00 23.22           C
ATOM    541  C   GLY    65     -31.577  15.697 -10.034  1.00 24.11           C
ATOM    542  O   GLY    65     -30.930  15.040 -10.873  1.00 24.63           O
ATOM    543  N   GLN    66     -31.841  15.266  -8.802  1.00 24.05           N
ATOM    544  CA  GLN    66     -31.357  13.993  -8.283  1.00 24.54           C
ATOM    545  CB  GLN    66     -30.285  14.241  -7.234  1.00 25.47           C
ATOM    546  CG  GLN    66     -28.910  14.511  -7.854  1.00 30.42           C
ATOM    547  CD  GLN    66     -28.001  15.342  -6.962  1.00 36.44           C
ATOM    548  OE1 GLN    66     -28.382  16.421  -6.479  1.00 39.74           O
ATOM    549  NE2 GLN    66     -26.784  14.859  -6.761  1.00 37.88           N
ATOM    550  C   GLN    66     -32.519  13.185  -7.688  1.00 23.92           C
ATOM    551  O   GLN    66     -32.671  13.075  -6.467  1.00 23.62           O
ATOM    552  N   LEU    67     -33.319  12.616  -8.579  1.00 22.78           N
ATOM    553  CA  LEU    67     -34.545  11.916  -8.200  1.00 21.55           C
ATOM    554  CB  LEU    67     -35.668  12.370  -9.128  1.00 21.58           C
ATOM    555  CG  LEU    67     -35.860  13.887  -9.236  1.00 21.33           C
ATOM    556  CD1 LEU    67     -36.995  14.155 -10.180  1.00 22.06           C
ATOM    557  CD2 LEU    67     -36.147  14.475  -7.858  1.00 21.71           C
ATOM    558  C   LEU    67     -34.455  10.391  -8.219  1.00 21.26           C
ATOM    559  O   LEU    67     -35.485   9.730  -8.205  1.00 20.77           O
ATOM    560  N   ASP    68     -33.243   9.827  -8.209  1.00 20.58           N
ATOM    561  CA  ASP    68     -33.066   8.375  -8.336  1.00 21.06           C
ATOM    562  CB  ASP    68     -31.588   8.003  -8.545  1.00 22.43           C
ATOM    563  CG  ASP    68     -31.143   8.118 -10.019  1.00 25.47           C
ATOM    564  OD1 ASP    68     -32.015   8.221 -10.922  1.00 30.33           O
ATOM    565  OD2 ASP    68     -29.915   8.103 -10.278  1.00 28.49           O
ATOM    566  C   ASP    68     -33.707   7.551  -7.191  1.00 21.11           C
ATOM    567  O   ASP    68     -34.136   6.420  -7.409  1.00 20.72           O
ATOM    568  N   ASP    69     -33.790   8.106  -5.981  1.00 20.70           N
ATOM    569  CA  ASP    69     -34.499   7.393  -4.890  1.00 21.27           C
ATOM    570  CB  ASP    69     -34.371   8.149  -3.562  1.00 22.13           C
ATOM    571  CG  ASP    69     -32.986   8.014  -2.948  1.00 24.48           C
ATOM    572  OD1 ASP    69     -32.312   6.996  -3.200  1.00 27.84           O
ATOM    573  OD2 ASP    69     -32.581   8.940  -2.220  1.00 28.42           O
ATOM    574  C   ASP    69     -35.988   7.188  -5.201  1.00 20.42           C
ATOM    575  O   ASP    69     -36.621   6.239  -4.725  1.00 20.59           O
ATOM    576  N   ILE    70     -36.539   8.100  -5.989  1.00 19.38           N
ATOM    577  CA  ILE    70     -37.928   7.992  -6.429  1.00 18.85           C
ATOM    578  CB  ILE    70     -38.556   9.366  -6.619  1.00 18.52           C
ATOM    579  CG1 ILE    70     -38.411  10.193  -5.323  1.00 21.19           C
ATOM    580  CD1 ILE    70     -38.809  11.665  -5.486  1.00 21.34           C
ATOM    581  CG2 ILE    70     -40.039   9.235  -6.997  1.00 19.97           C
ATOM    582  C   ILE    70     -38.014   7.194  -7.726  1.00 17.62           C
ATOM    583  O   ILE    70     -38.761   6.225  -7.804  1.00 18.07           O
ATOM    584  N   ARG    71     -37.271   7.614  -8.747  1.00 16.37           N
ATOM    585  CA  ARG    71     -37.312   6.918 -10.054  1.00 16.19           C
ATOM    586  CB  ARG    71     -36.314   7.527 -11.036  1.00 16.11           C
ATOM    587  CG  ARG    71     -36.578   8.965 -11.418  1.00 19.99           C
ATOM    588  CD  ARG    71     -35.754   9.340 -12.654  1.00 23.24           C
ATOM    589  NE  ARG    71     -35.827  10.770 -12.961  1.00 25.78           N
ATOM    590  CZ  ARG    71     -36.850  11.371 -13.583  1.00 28.05           C
ATOM    591  NH1 ARG    71     -37.910  10.665 -13.975  1.00 28.38           N
ATOM    592  NH2 ARG    71     -36.818  12.683 -13.821  1.00 22.66           N
ATOM    593  C   ARG    71     -36.981   5.449  -9.914  1.00 14.93           C
ATOM    594  O   ARG    71     -37.529   4.587 -10.637  1.00 13.88           O
ATOM    595  N   GLY    72     -36.074   5.141  -8.978  1.00 14.49           N
ATOM    596  CA  GLY    72     -35.604   3.763  -8.809  1.00 13.79           C
ATOM    597  C   GLY    72     -36.685   2.791  -8.352  1.00 14.28           C
ATOM    598  O   GLY    72     -36.498   1.596  -8.465  1.00 15.03           O
ATOM    599  N   GLN    73     -37.809   3.316  -7.844  1.00 13.08           N
ATOM    600  CA  GLN    73     -38.965   2.522  -7.381  1.00 13.26           C
ATOM    601  CB  GLN    73     -39.651   3.251  -6.211  1.00 13.37           C
ATOM    602  CG  GLN    73     -38.783   3.419  -4.979  1.00 16.75           C
ATOM    603  CD  GLN    73     -38.147   2.137  -4.546  1.00 21.82           C
ATOM    604  OE1 GLN    73     -38.813   1.105  -4.424  1.00 22.36           O
ATOM    605  NE2 GLN    73     -36.834   2.173  -4.334  1.00 26.08           N
ATOM    606  C   GLN    73     -40.037   2.290  -8.454  1.00 12.89           C
ATOM    607  O   GLN    73     -41.041   1.624  -8.204  1.00 12.88           O
ATOM    608  N   ALA    74     -39.844   2.871  -9.636  1.00 12.26           N
ATOM    609  CA  ALA    74     -40.800   2.693 -10.736  1.00 12.16           C
ATOM    610  CB  ALA    74     -40.216   3.279 -12.015  1.00 12.22           C
ATOM    611  C   ALA    74     -41.152   1.219 -10.951  1.00 12.26           C
ATOM    612  O   ALA    74     -40.261   0.342 -10.903  1.00 11.19           O
ATOM    613  N   GLY    75     -42.429   0.939 -11.235  1.00 11.65           N
ATOM    614  CA  GLY    75     -42.868  -0.466 -11.342  1.00 10.70           C
ATOM    615  C   GLY    75     -43.731  -0.790 -10.118  1.00 11.25           C
ATOM    616  O   GLY    75     -44.484  -1.762 -10.116  1.00 11.59           O
ATOM    617  N   ASP    76     -43.570  -0.008  -9.043  1.00 12.06           N
ATOM    618  CA  ASP    76     -44.360  -0.166  -7.824  1.00 12.36           C
ATOM    619  CB  ASP    76     -43.487  -0.827  -6.733  1.00 12.42           C
ATOM    620  CG  ASP    76     -44.202  -1.022  -5.400  1.00 15.66           C
ATOM    621  OD1 ASP    76     -45.317  -0.484  -5.151  1.00 16.24           O
ATOM    622  OD2 ASP    76     -43.604  -1.751  -4.566  1.00 15.57           O
ATOM    623  C   ASP    76     -44.849   1.223  -7.391  1.00 12.68           C
ATOM    624  O   ASP    76     -44.129   1.931  -6.685  1.00 11.41           O
ATOM    625  N   PRO    77     -46.043   1.647  -7.879  1.00 13.71           N
ATOM    626  CA  PRO    77     -46.488   3.033  -7.645  1.00 13.93           C
ATOM    627  CB  PRO    77     -47.873   3.103  -8.333  1.00 13.23           C
ATOM    628  CG  PRO    77     -47.761   2.072  -9.458  1.00 15.27           C
ATOM    629  CD  PRO    77     -46.977   0.920  -8.766  1.00 14.18           C
ATOM    630  C   PRO    77     -46.533   3.405  -6.182  1.00 13.31           C
ATOM    631  O   PRO    77     -46.184   4.524  -5.838  1.00 13.85           O
ATOM    632  N   LEU    78     -46.946   2.477  -5.319  0.50 13.21           N
ATOM    634  CA  LEU    78     -46.992   2.787  -3.889  0.50 13.74           C
ATOM    636  CB  LEU    78     -47.582   1.617  -3.103  0.50 13.51           C
ATOM    638  CG  LEU    78     -48.457   1.997  -1.907  0.50 14.73           C
ATOM    640  CD1 LEU    78     -49.147   0.741  -1.413  0.50 17.25           C
ATOM    642  CD2 LEU    78     -47.650   2.638  -0.804  0.50 19.04           C
ATOM    644  C   LEU    78     -45.602   3.124  -3.366  0.50 13.01           C
ATOM    646  O   LEU    78     -45.444   4.072  -2.614  0.50 12.86           O
ATOM    648  N   ALA    79     -44.598   2.339  -3.761  1.00 13.15           N
ATOM    649  CA  ALA    79     -43.203   2.602  -3.355  1.00 13.03           C
ATOM    650  CB  ALA    79     -42.284   1.481  -3.789  1.00 13.22           C
ATOM    651  C   ALA    79     -42.705   3.953  -3.901  1.00 12.54           C
ATOM    652  O   ALA    79     -41.949   4.654  -3.228  1.00 12.09           O
ATOM    653  N   VAL    80     -43.099   4.301  -5.131  1.00 11.58           N
ATOM    654  CA  VAL    80     -42.787   5.630  -5.672  1.00 12.21           C
ATOM    655  CB  VAL    80     -43.296   5.773  -7.101  1.00 11.22           C
ATOM    656  CG1 VAL    80     -43.163   7.227  -7.624  1.00 12.32           C
ATOM    657  CG2 VAL    80     -42.538   4.787  -8.035  1.00 10.84           C
ATOM    658  C   VAL    80     -43.376   6.760  -4.777  1.00 13.05           C
ATOM    659  O   VAL    80     -42.668   7.710  -4.420  1.00 13.23           O
ATOM    660  N   MET    81     -44.661   6.646  -4.436  0.70 12.38           N
ATOM    662  CA  MET    81     -45.330   7.668  -3.603  0.70 12.69           C
ATOM    664  CB  MET    81     -46.833   7.394  -3.427  0.70 13.82           C
ATOM    666  CG  MET    81     -47.597   7.155  -4.747  0.70 14.01           C
ATOM    668  SD  MET    81     -47.622   8.670  -5.960  0.70 21.09          SE
ATOM    670  CE  MET    81     -47.084   7.612  -7.496  0.70 15.28           C
ATOM    672  C   MET    81     -44.684   7.771  -2.235  0.70 13.11           C
ATOM    674  O   MET    81     -44.538   8.886  -1.698  0.70 12.95           O
ATOM    676  N   THR    82     -44.336   6.621  -1.655  1.00 11.97           N
ATOM    677  CA  THR    82     -43.690   6.575  -0.342  1.00 13.13           C
ATOM    678  CB  THR    82     -43.605   5.113   0.176  1.00 12.76           C
ATOM    679  OG1 THR    82     -44.931   4.563   0.297  1.00 13.08           O
ATOM    680  CG2 THR    82     -42.926   5.051   1.546  1.00 12.65           C
ATOM    681  C   THR    82     -42.311   7.220  -0.401  1.00 12.27           C
ATOM    682  O   THR    82     -41.988   8.047   0.443  1.00 12.09           O
ATOM    683  N   ALA    83     -41.522   6.874  -1.419  1.00 12.10           N
ATOM    684  CA  ALA    83     -40.189   7.455  -1.613  1.00 12.71           C
ATOM    685  CB  ALA    83     -39.469   6.804  -2.772  1.00 13.64           C
ATOM    686  C   ALA    83     -40.256   8.962  -1.829  1.00 13.31           C
ATOM    687  O   ALA    83     -39.424   9.717  -1.293  1.00 13.65           O
ATOM    688  N   TYR    84     -41.234   9.393  -2.621  1.00 12.01           N
ATOM    689  CA  TYR    84     -41.450  10.829  -2.827  1.00 11.80           C
ATOM    690  CB  TYR    84     -42.626  11.070  -3.785  1.00 11.47           C
ATOM    691  CG  TYR    84     -43.055  12.503  -3.698  1.00 11.01           C
ATOM    692  CD1 TYR    84     -42.230  13.514  -4.207  1.00  9.70           C
ATOM    693  CE1 TYR    84     -42.562  14.853  -4.058  1.00  7.72           C
ATOM    694  CZ  TYR    84     -43.777  15.207  -3.416  1.00  9.90           C
ATOM    695  OH  TYR    84     -44.090  16.520  -3.245  1.00  9.60           O
ATOM    696  CE2 TYR    84     -44.606  14.228  -2.886  1.00 10.03           C
ATOM    697  CD2 TYR    84     -44.241  12.867  -3.033  1.00  8.93           C
ATOM    698  C   TYR    84     -41.702  11.542  -1.464  1.00 11.96           C
ATOM    699  O   TYR    84     -41.113  12.588  -1.195  1.00 11.13           O
ATOM    700  N   LEU    85     -42.594  11.008  -0.646  1.00 10.86           N
ATOM    701  CA  LEU    85     -42.868  11.627   0.683  1.00 10.85           C
ATOM    702  CB  LEU    85     -44.003  10.908   1.396  1.00 10.34           C
ATOM    703  CG  LEU    85     -45.392  11.039   0.735  1.00 11.08           C
ATOM    704  CD1 LEU    85     -46.412  10.164   1.470  1.00 14.10           C
ATOM    705  CD2 LEU    85     -45.840  12.513   0.824  1.00 11.81           C
ATOM    706  C   LEU    85     -41.608  11.688   1.547  1.00 10.59           C
ATOM    707  O   LEU    85     -41.299  12.737   2.160  1.00  9.89           O
ATOM    708  N   ARG    86     -40.890  10.577   1.613  1.00 11.70           N
ATOM    709  CA  ARG    86     -39.686  10.504   2.430  1.00 12.21           C
ATOM    710  CB  ARG    86     -39.118   9.092   2.407  1.00 13.48           C
ATOM    711  CG  ARG    86     -38.070   8.880   3.462  1.00 16.80           C
ATOM    712  CD  ARG    86     -37.752   7.377   3.627  1.00 18.02           C
ATOM    713  NE  ARG    86     -38.810   6.676   4.350  1.00 20.50           N
ATOM    714  CZ  ARG    86     -39.556   5.706   3.833  1.00 23.33           C
ATOM    715  NH1 ARG    86     -39.354   5.300   2.584  1.00 26.93           N
ATOM    716  NH2 ARG    86     -40.472   5.111   4.589  1.00 24.38           N
ATOM    717  C   ARG    86     -38.635  11.526   1.947  1.00 11.94           C
ATOM    718  O   ARG    86     -37.985  12.202   2.764  1.00 11.86           O
ATOM    719  N   TRP    87     -38.462  11.595   0.637  1.00 11.06           N
ATOM    720  CA  TRP    87     -37.511  12.517   0.011  1.00 11.54           C
ATOM    721  CB  TRP    87     -37.513  12.276  -1.518  1.00 11.78           C
ATOM    722  CG  TRP    87     -36.670  13.219  -2.336  1.00 11.45           C
ATOM    723  CD1 TRP    87     -35.298  13.232  -2.473  1.00 12.95           C
ATOM    724  NE1 TRP    87     -34.914  14.228  -3.355  1.00 11.75           N
ATOM    725  CE2 TRP    87     -36.041  14.867  -3.805  1.00 12.69           C
ATOM    726  CD2 TRP    87     -37.162  14.253  -3.195  1.00 12.32           C
ATOM    727  CE3 TRP    87     -38.448  14.715  -3.505  1.00 13.71           C
ATOM    728  CZ3 TRP    87     -38.582  15.767  -4.386  1.00 13.30           C
ATOM    729  CH2 TRP    87     -37.436  16.377  -4.989  1.00 14.32           C
ATOM    730  CZ2 TRP    87     -36.166  15.944  -4.703  1.00 14.12           C
ATOM    731  C   TRP    87     -37.904  13.972   0.307  1.00 11.68           C
ATOM    732  O   TRP    87     -37.046  14.801   0.617  1.00 11.77           O
ATOM    733  N   THR    88     -39.191  14.280   0.183  1.00 11.01           N
ATOM    734  CA  THR    88     -39.685  15.654   0.390  1.00 11.22           C
ATOM    735  CB  THR    88     -41.147  15.790  -0.053  1.00 12.10           C
ATOM    736  OG1 THR    88     -41.220  15.503  -1.460  1.00 12.19           O
ATOM    737  CG2 THR    88     -41.678  17.220   0.199  1.00 12.36           C
ATOM    738  C   THR    88     -39.498  16.086   1.853  1.00 10.14           C
ATOM    739  O   THR    88     -39.045  17.207   2.119  1.00  9.63           O
ATOM    740  N   ILE    89     -39.826  15.192   2.778  1.00 10.71           N
ATOM    741  CA  ILE    89     -39.609  15.477   4.191  1.00 11.44           C
ATOM    742  CB  ILE    89     -40.178  14.352   5.067  1.00 11.62           C
ATOM    743  CG1 ILE    89     -41.718  14.377   4.949  1.00 10.67           C
ATOM    744  CD1 ILE    89     -42.368  13.154   5.612  1.00 14.32           C
ATOM    745  CG2 ILE    89     -39.752  14.574   6.521  1.00  9.76           C
ATOM    746  C   ILE    89     -38.108  15.719   4.470  1.00 11.65           C
ATOM    747  O   ILE    89     -37.748  16.702   5.123  1.00 10.49           O
ATOM    748  N   GLN    90     -37.253  14.832   3.946  0.60 11.78           N
ATOM    750  CA  GLN    90     -35.805  15.009   4.058  0.60 12.90           C
ATOM    752  CB  GLN    90     -35.059  13.906   3.294  0.60 13.23           C
ATOM    754  CG  GLN    90     -33.581  13.882   3.617  0.60 18.71           C
ATOM    756  CD  GLN    90     -33.320  13.696   5.114  0.60 24.36           C
ATOM    758  OE1 GLN    90     -32.857  14.615   5.797  0.60 28.60           O
ATOM    760  NE2 GLN    90     -33.626  12.502   5.631  0.60 27.22           N
ATOM    762  C   GLN    90     -35.349  16.402   3.563  0.60 12.09           C
ATOM    764  O   GLN    90     -34.599  17.104   4.235  0.60 11.76           O
ATOM    766  N   ARG    91     -35.849  16.798   2.401  1.00 12.06           N
ATOM    767  CA  ARG    91     -35.481  18.070   1.792  1.00 11.96           C
ATOM    768  CB  ARG    91     -36.237  18.253   0.485  1.00 13.06           C
ATOM    769  CG  ARG    91     -35.579  17.519  -0.624  1.00 17.79           C
ATOM    770  CD  ARG    91     -36.116  18.032  -1.972  1.00 20.49           C
ATOM    771  NE  ARG    91     -37.524  17.695  -2.235  1.00 21.73           N
ATOM    772  CZ  ARG    91     -38.542  18.563  -2.176  1.00 22.41           C
ATOM    773  NH1 ARG    91     -39.778  18.166  -2.519  1.00 18.87           N
ATOM    774  NH2 ARG    91     -38.328  19.821  -1.792  1.00 17.44           N
ATOM    775  C   ARG    91     -35.787  19.210   2.737  1.00 11.92           C
ATOM    776  O   ARG    91     -34.954  20.120   2.929  1.00 11.63           O
ATOM    777  N   HIS    92     -36.985  19.171   3.324  1.00 11.45           N
ATOM    778  CA  HIS    92     -37.369  20.231   4.257  1.00 12.36           C
ATOM    779  CB  HIS    92     -38.873  20.203   4.534  1.00 13.78           C
ATOM    780  CG  HIS    92     -39.696  20.557   3.336  1.00 14.40           C
ATOM    781  ND1 HIS    92     -39.591  21.777   2.684  1.00 19.47           N
ATOM    782  CE1 HIS    92     -40.452  21.801   1.674  1.00 21.35           C
ATOM    783  NE2 HIS    92     -41.103  20.649   1.649  1.00 16.69           N
ATOM    784  CD2 HIS    92     -40.635  19.846   2.660  1.00 16.03           C
ATOM    785  C   HIS    92     -36.565  20.215   5.544  1.00 12.15           C
ATOM    786  O   HIS    92     -36.192  21.268   6.056  1.00 11.95           O
ATOM    787  N   ARG    93     -36.254  19.030   6.054  1.00 11.79           N
ATOM    788  CA  ARG    93     -35.455  18.958   7.286  1.00 12.70           C
ATOM    789  CB  ARG    93     -35.461  17.537   7.853  1.00 12.66           C
ATOM    790  CG  ARG    93     -36.858  17.020   8.266  1.00 13.84           C
ATOM    791  CD  ARG    93     -37.401  17.762   9.453  1.00 18.09           C
ATOM    792  NE  ARG    93     -38.685  17.215   9.878  1.00 17.47           N
ATOM    793  CZ  ARG    93     -39.526  17.858  10.676  1.00 16.59           C
ATOM    794  NH1 ARG    93     -39.223  19.072  11.110  1.00 17.37           N
ATOM    795  NH2 ARG    93     -40.666  17.281  11.023  1.00 15.53           N
ATOM    796  C   ARG    93     -34.025  19.435   7.057  1.00 13.20           C
ATOM    797  O   ARG    93     -33.450  20.125   7.905  1.00 15.46           O
ATOM    798  N   ASN    94     -33.459  19.087   5.914  1.00 12.51           N
ATOM    799  CA  ASN    94     -32.101  19.512   5.580  1.00 14.01           C
ATOM    800  CB  ASN    94     -31.566  18.704   4.408  1.00 15.34           C
ATOM    801  CG  ASN    94     -31.380  17.226   4.724  1.00 18.74           C
ATOM    802  OD1 ASN    94     -31.130  16.441   3.813  1.00 27.63           O
ATOM    803  ND2 ASN    94     -31.508  16.841   5.986  1.00 22.90           N
ATOM    804  C   ASN    94     -32.010  20.978   5.199  1.00 13.91           C
ATOM    805  O   ASN    94     -30.942  21.582   5.307  1.00 12.63           O
ATOM    806  N   ASN    95     -33.118  21.549   4.732  1.00 13.29           N
ATOM    807  CA  ASN    95     -33.111  22.936   4.270  1.00 15.16           C
ATOM    808  CB  ASN    95     -32.967  23.054   2.763  1.00 16.24           C
ATOM    809  CG  ASN    95     -32.773  24.515   2.339  1.00 19.00           C
ATOM    810  OD1 ASN    95     -32.538  25.397   3.185  1.00 16.84           O
ATOM    811  ND2 ASN    95     -32.897  24.782   1.041  1.00 21.24           N
ATOM    812  C   ASN    95     -34.330  23.717   4.692  1.00 15.67           C
ATOM    813  O   ASN    95     -35.314  23.831   3.936  1.00 15.80           O
ATOM    814  N   PRO    96     -34.271  24.260   5.900  1.00 16.89           N
ATOM    815  CA  PRO    96     -35.322  25.100   6.460  1.00 18.18           C
ATOM    816  CB  PRO    96     -34.732  25.555   7.802  1.00 18.94           C
ATOM    817  CG  PRO    96     -33.729  24.472   8.148  1.00 19.40           C
ATOM    818  CD  PRO    96     -33.147  24.066   6.837  1.00 17.29           C
ATOM    819  C   PRO    96     -35.602  26.309   5.578  1.00 17.64           C
ATOM    820  O   PRO    96     -36.688  26.843   5.668  1.00 20.08           O
ATOM    821  N   GLN    97     -34.664  26.718   4.721  1.00 17.55           N
ATOM    822  CA  GLN    97     -34.882  27.924   3.884  1.00 16.15           C
ATOM    823  CB  GLN    97     -33.556  28.526   3.375  1.00 18.11           C
ATOM    824  CG  GLN    97     -32.586  28.997   4.445  1.00 21.27           C
ATOM    825  CD  GLN    97     -32.986  30.332   5.097  1.00 25.68           C
ATOM    826  OE1 GLN    97     -34.153  30.593   5.335  1.00 27.40           O
ATOM    827  NE2 GLN    97     -32.009  31.165   5.381  1.00 27.04           N
ATOM    828  C   GLN    97     -35.744  27.610   2.655  1.00 14.78           C
ATOM    829  O   GLN    97     -36.230  28.506   1.960  1.00 11.98           O
ATOM    830  N   LEU    98     -35.901  26.333   2.335  1.00 12.64           N
ATOM    831  CA  LEU    98     -36.399  26.054   0.980  1.00 12.07           C
ATOM    832  CB  LEU    98     -36.223  24.576   0.576  1.00 12.25           C
ATOM    833  CG  LEU    98     -36.864  24.142  -0.779  1.00 13.48           C
ATOM    834  CD1 LEU    98     -36.177  24.694  -2.050  1.00 15.69           C
ATOM    835  CD2 LEU    98     -36.865  22.621  -0.848  1.00 15.12           C
ATOM    836  C   LEU    98     -37.808  26.609   0.762  1.00  9.66           C
ATOM    837  O   LEU    98     -38.058  27.231  -0.286  1.00  9.22           O
ATOM    838  N   LEU    99     -38.723  26.475   1.724  1.00  9.90           N
ATOM    839  CA  LEU    99     -40.096  26.921   1.392  1.00 10.68           C
ATOM    840  CB  LEU    99     -41.134  26.482   2.475  1.00 11.84           C
ATOM    841  CG  LEU    99     -41.720  25.109   2.218  1.00 12.27           C
ATOM    842  CD1 LEU    99     -42.546  24.691   3.463  1.00 16.86           C
ATOM    843  CD2 LEU    99     -42.530  24.990   0.943  1.00 14.59           C
ATOM    844  C   LEU    99     -40.166  28.414   1.244  1.00 10.51           C
ATOM    845  O   LEU    99     -41.036  28.919   0.576  1.00 11.22           O
ATOM    846  N   ARG   100     -39.232  29.138   1.869  1.00  8.91           N
ATOM    847  CA  ARG   100     -39.171  30.614   1.637  1.00 10.19           C
ATOM    848  CB  ARG   100     -38.051  31.233   2.443  1.00  9.36           C
ATOM    849  CG  ARG   100     -38.293  31.279   3.923  1.00 12.57           C
ATOM    850  CD  ARG   100     -37.117  31.919   4.691  1.00 14.26           C
ATOM    851  NE  ARG   100     -37.502  32.131   6.084  1.00 21.03           N
ATOM    852  CZ  ARG   100     -36.662  32.254   7.102  1.00 26.22           C
ATOM    853  NH1 ARG   100     -35.340  32.191   6.906  1.00 25.30           N
ATOM    854  NH2 ARG   100     -37.156  32.455   8.326  1.00 30.04           N
ATOM    855  C   ARG   100     -38.944  30.908   0.135  1.00  9.56           C
ATOM    856  O   ARG   100     -39.737  31.609  -0.479  1.00  9.17           O
ATOM    857  N   PHE   101     -37.894  30.333  -0.451  1.00  8.88           N
ATOM    858  CA  PHE   101     -37.584  30.586  -1.861  1.00  7.74           C
ATOM    859  CB  PHE   101     -36.227  29.979  -2.191  1.00  9.07           C
ATOM    860  CG  PHE   101     -35.072  30.718  -1.553  1.00  8.31           C
ATOM    861  CD1 PHE   101     -34.572  31.865  -2.155  1.00  9.65           C
ATOM    862  CE1 PHE   101     -33.460  32.577  -1.586  1.00 12.39           C
ATOM    863  CZ  PHE   101     -32.856  32.079  -0.434  1.00 11.45           C
ATOM    864  CE2 PHE   101     -33.351  30.895   0.160  1.00 13.90           C
ATOM    865  CD2 PHE   101     -34.452  30.220  -0.416  1.00 11.33           C
ATOM    866  C   PHE   101     -38.651  29.978  -2.784  1.00  8.41           C
ATOM    867  O   PHE   101     -39.040  30.587  -3.776  1.00  8.06           O
ATOM    868  N   TYR   102     -39.122  28.777  -2.420  1.00  7.06           N
ATOM    869  CA  TYR   102     -40.068  28.027  -3.247  1.00  7.90           C
ATOM    870  CB  TYR   102     -40.262  26.695  -2.548  1.00  7.79           C
ATOM    871  CG  TYR   102     -41.077  25.629  -3.236  1.00  8.54           C
ATOM    872  CD1 TYR   102     -42.489  25.656  -3.181  1.00 10.03           C
ATOM    873  CE1 TYR   102     -43.257  24.599  -3.766  1.00 11.63           C
ATOM    874  CZ  TYR   102     -42.610  23.511  -4.376  1.00 11.76           C
ATOM    875  OH  TYR   102     -43.341  22.459  -4.924  1.00 11.14           O
ATOM    876  CE2 TYR   102     -41.192  23.459  -4.417  1.00  9.45           C
ATOM    877  CD2 TYR   102     -40.447  24.510  -3.827  1.00 10.19           C
ATOM    878  C   TYR   102     -41.394  28.796  -3.351  1.00  8.00           C
ATOM    879  O   TYR   102     -41.879  29.032  -4.458  1.00  9.22           O
ATOM    880  N   THR   103     -41.935  29.239  -2.212  1.00  8.23           N
ATOM    881  CA  THR   103     -43.186  30.012  -2.256  1.00  8.10           C
ATOM    882  CB  THR   103     -43.885  30.125  -0.875  1.00  7.33           C
ATOM    883  OG1 THR   103     -43.012  30.781   0.056  1.00  8.06           O
ATOM    884  CG2 THR   103     -44.249  28.714  -0.376  1.00  8.46           C
ATOM    885  C   THR   103     -43.009  31.397  -2.842  1.00  8.57           C
ATOM    886  O   THR   103     -43.909  31.869  -3.557  1.00  9.60           O
ATOM    887  N   SER   104     -41.877  32.052  -2.541  1.00  9.12           N
ATOM    888  CA  SER   104     -41.655  33.400  -3.043  1.00  9.88           C
ATOM    889  CB  SER   104     -40.363  34.009  -2.477  1.00  9.85           C
ATOM    890  OG  SER   104     -40.234  35.352  -2.971  1.00 12.21           O
ATOM    891  C   SER   104     -41.601  33.357  -4.584  1.00 10.66           C
ATOM    892  O   SER   104     -42.219  34.183  -5.265  1.00 10.59           O
ATOM    893  N   GLU   105     -40.865  32.392  -5.125  1.00  8.72           N
ATOM    894  CA  GLU   105     -40.817  32.289  -6.613  1.00  9.18           C
ATOM    895  CB  GLU   105     -39.731  31.293  -7.041  1.00  7.45           C
ATOM    896  CG  GLU   105     -38.332  31.924  -6.972  1.00  8.14           C
ATOM    897  CD  GLU   105     -38.036  32.910  -8.131  1.00 10.19           C
ATOM    898  OE1 GLU   105     -38.853  33.093  -9.071  1.00  9.04           O
ATOM    899  OE2 GLU   105     -36.931  33.505  -8.111  1.00 13.04           O
ATOM    900  C   GLU   105     -42.165  31.935  -7.261  1.00  9.12           C
ATOM    901  O   GLU   105     -42.538  32.491  -8.300  1.00  9.81           O
ATOM    902  N   LEU   106     -42.941  31.042  -6.632  1.00  8.79           N
ATOM    903  CA  LEU   106     -44.237  30.680  -7.191  1.00  9.03           C
ATOM    904  CB  LEU   106     -44.849  29.471  -6.457  1.00  8.32           C
ATOM    905  CG  LEU   106     -44.211  28.130  -6.911  1.00  9.60           C
ATOM    906  CD1 LEU   106     -44.576  27.033  -5.828  1.00  9.04           C
ATOM    907  CD2 LEU   106     -44.754  27.786  -8.296  1.00  9.22           C
ATOM    908  C   LEU   106     -45.238  31.834  -7.135  1.00  9.88           C
ATOM    909  O   LEU   106     -46.147  31.887  -7.972  1.00 10.21           O
ATOM    910  N   THR   107     -45.102  32.717  -6.136  1.00  9.52           N
ATOM    911  CA  THR   107     -46.030  33.832  -5.986  1.00  9.75           C
ATOM    912  CB  THR   107     -46.510  33.990  -4.516  1.00  9.09           C
ATOM    913  OG1 THR   107     -45.388  34.319  -3.693  1.00 10.50           O
ATOM    914  CG2 THR   107     -47.185  32.718  -4.076  1.00 10.05           C
ATOM    915  C   THR   107     -45.544  35.182  -6.484  1.00  9.81           C
ATOM    916  O   THR   107     -46.371  36.081  -6.704  1.00 12.25           O
ATOM    917  N   ASN   108     -44.232  35.363  -6.633  0.50  9.70           N
ATOM    919  CA  ASN   108     -43.617  36.625  -7.105  0.50  9.59           C
ATOM    921  CB  ASN   108     -43.154  37.511  -5.932  0.50  9.99           C
ATOM    923  CG  ASN   108     -44.278  38.322  -5.314  0.50  8.07           C
ATOM    925  OD1 ASN   108     -44.577  38.166  -4.138  0.50 11.45           O
ATOM    927  ND2 ASN   108     -44.931  39.160  -6.116  0.50  6.17           N
ATOM    929  C   ASN   108     -42.392  36.215  -7.909  0.50  9.86           C
ATOM    931  O   ASN   108     -41.262  36.429  -7.469  0.50  9.46           O
ATOM    933  N   PRO   109     -42.611  35.593  -9.087  1.00  9.87           N
ATOM    934  CA  PRO   109     -41.482  34.997  -9.847  1.00  9.20           C
ATOM    935  CB  PRO   109     -42.170  34.338 -11.060  1.00  9.29           C
ATOM    936  CG  PRO   109     -43.456  35.217 -11.249  1.00 11.47           C
ATOM    937  CD  PRO   109     -43.900  35.416  -9.770  1.00 10.72           C
ATOM    938  C   PRO   109     -40.455  36.039 -10.322  1.00  9.60           C
ATOM    939  O   PRO   109     -40.811  37.205 -10.612  1.00 11.09           O
ATOM    940  N   THR   110     -39.210  35.615 -10.382  1.00  9.05           N
ATOM    941  CA  THR   110     -38.133  36.378 -11.039  1.00  9.32           C
ATOM    942  CB  THR   110     -36.862  36.356 -10.160  1.00 10.57           C
ATOM    943  OG1 THR   110     -36.330  35.035 -10.130  1.00  9.30           O
ATOM    944  CG2 THR   110     -37.147  36.832  -8.744  1.00 13.98           C
ATOM    945  C   THR   110     -37.799  35.644 -12.327  1.00  8.94           C
ATOM    946  O   THR   110     -38.429  34.643 -12.626  1.00  8.35           O
ATOM    947  N   PRO   111     -36.818  36.119 -13.123  1.00  9.83           N
ATOM    948  CA  PRO   111     -36.366  35.317 -14.286  1.00 11.52           C
ATOM    949  CB  PRO   111     -35.231  36.183 -14.892  1.00 11.75           C
ATOM    950  CG  PRO   111     -35.579  37.539 -14.489  1.00 11.98           C
ATOM    951  CD  PRO   111     -36.150  37.430 -13.076  1.00 10.83           C
ATOM    952  C   PRO   111     -35.863  33.915 -13.908  1.00 12.86           C
ATOM    953  O   PRO   111     -35.889  32.963 -14.744  1.00 13.75           O
ATOM    954  N   CYS   112     -35.461  33.730 -12.660  1.00 11.46           N
ATOM    955  CA  CYS   112     -35.067  32.401 -12.254  1.00 13.19           C
ATOM    956  CB  CYS   112     -34.230  32.442 -10.978  1.00 14.56           C
ATOM    957  SG  CYS   112     -32.686  33.333 -11.290  1.00 18.40           S
ATOM    958  C   CYS   112     -36.251  31.432 -12.108  1.00 12.18           C
ATOM    959  O   CYS   112     -36.048  30.232 -11.974  1.00 13.79           O
ATOM    960  N   PHE   113     -37.501  31.926 -12.121  1.00 11.58           N
ATOM    961  CA  PHE   113     -38.605  30.987 -11.961  1.00 10.29           C
ATOM    962  CB  PHE   113     -39.921  31.711 -11.869  1.00 10.73           C
ATOM    963  CG  PHE   113     -41.068  30.776 -11.807  1.00 10.75           C
ATOM    964  CD1 PHE   113     -41.318  30.025 -10.649  1.00 13.13           C
ATOM    965  CE1 PHE   113     -42.390  29.092 -10.649  1.00 14.20           C
ATOM    966  CZ  PHE   113     -43.135  28.878 -11.780  1.00 12.39           C
ATOM    967  CE2 PHE   113     -42.909  29.606 -12.931  1.00 14.70           C
ATOM    968  CD2 PHE   113     -41.824  30.539 -12.957  1.00 11.87           C
ATOM    969  C   PHE   113     -38.634  30.035 -13.180  1.00  9.81           C
ATOM    970  O   PHE   113     -38.642  28.807 -13.017  1.00  9.92           O
ATOM    971  N   ALA   114     -38.644  30.592 -14.383  1.00  9.60           N
ATOM    972  CA  ALA   114     -38.711  29.716 -15.565  1.00  9.88           C
ATOM    973  CB  ALA   114     -38.980  30.528 -16.837  1.00  9.97           C
ATOM    974  C   ALA   114     -37.461  28.865 -15.730  1.00 10.92           C
ATOM    975  O   ALA   114     -37.548  27.764 -16.247  1.00 11.21           O
ATOM    976  N   ALA   115     -36.301  29.407 -15.342  1.00 10.45           N
ATOM    977  CA  ALA   115     -35.020  28.733 -15.554  1.00 11.81           C
ATOM    978  CB  ALA   115     -33.882  29.767 -15.520  1.00 12.14           C
ATOM    979  C   ALA   115     -34.750  27.588 -14.574  1.00 11.95           C
ATOM    980  O   ALA   115     -34.178  26.555 -14.951  1.00 12.70           O
ATOM    981  N   ILE   116     -35.186  27.750 -13.331  1.00 11.04           N
ATOM    982  CA  ILE   116     -34.783  26.848 -12.255  1.00 11.69           C
ATOM    983  CB  ILE   116     -33.872  27.616 -11.214  1.00 10.98           C
ATOM    984  CG1 ILE   116     -32.584  28.106 -11.900  1.00 13.37           C
ATOM    985  CD1 ILE   116     -31.751  29.071 -11.039  1.00 12.57           C
ATOM    986  CG2 ILE   116     -33.568  26.724  -9.962  1.00 12.49           C
ATOM    987  C   ILE   116     -35.998  26.242 -11.560  1.00 11.29           C
ATOM    988  O   ILE   116     -36.092  25.007 -11.384  1.00 10.24           O
ATOM    989  N   VAL   117     -36.919  27.089 -11.131  1.00 10.95           N
ATOM    990  CA  VAL   117     -37.977  26.588 -10.206  1.00 10.57           C
ATOM    991  CB  VAL   117     -38.617  27.751  -9.409  1.00 11.02           C
ATOM    992  CG1 VAL   117     -39.795  27.207  -8.454  1.00 10.64           C
ATOM    993  CG2 VAL   117     -37.512  28.443  -8.627  1.00 10.50           C
ATOM    994  C   VAL   117     -39.038  25.771 -10.946  1.00 11.77           C
ATOM    995  O   VAL   117     -39.425  24.648 -10.524  1.00 11.14           O
ATOM    996  N   SER   118     -39.530  26.315 -12.046  1.00 10.59           N
ATOM    997  CA  SER   118     -40.620  25.684 -12.764  1.00 12.47           C
ATOM    998  CB  SER   118     -41.105  26.636 -13.868  1.00 13.39           C
ATOM    999  OG  SER   118     -42.255  26.127 -14.471  1.00 14.41           O
ATOM   1000  C   SER   118     -40.234  24.283 -13.285  1.00 11.92           C
ATOM   1001  O   SER   118     -40.958  23.318 -13.010  1.00 12.39           O
ATOM   1002  N   PRO   119     -39.094  24.138 -13.988  1.00 12.64           N
ATOM   1003  CA  PRO   119     -38.727  22.800 -14.461  1.00 11.77           C
ATOM   1004  CB  PRO   119     -37.448  23.016 -15.304  1.00 12.21           C
ATOM   1005  CG  PRO   119     -36.981  24.375 -14.981  1.00 12.76           C
ATOM   1006  CD  PRO   119     -38.161  25.180 -14.467  1.00 11.90           C
ATOM   1007  C   PRO   119     -38.487  21.799 -13.296  1.00 11.38           C
ATOM   1008  O   PRO   119     -38.822  20.622 -13.450  1.00 11.44           O
ATOM   1009  N   ALA   120     -37.965  22.276 -12.162  1.00 10.79           N
ATOM   1010  CA  ALA   120     -37.680  21.404 -10.992  1.00  9.96           C
ATOM   1011  CB  ALA   120     -36.955  22.202  -9.916  1.00 10.33           C
ATOM   1012  C   ALA   120     -38.996  20.843 -10.478  1.00 11.25           C
ATOM   1013  O   ALA   120     -39.179  19.606 -10.381  1.00 11.32           O
ATOM   1014  N   ILE   121     -39.972  21.731 -10.240  1.00  9.92           N
ATOM   1015  CA  ILE   121     -41.278  21.275  -9.739  1.00 10.42           C
ATOM   1016  CB  ILE   121     -42.191  22.482  -9.354  1.00  9.91           C
ATOM   1017  CG1 ILE   121     -41.576  23.223  -8.147  1.00 11.53           C
ATOM   1018  CD1 ILE   121     -42.273  24.600  -7.882  1.00 11.61           C
ATOM   1019  CG2 ILE   121     -43.657  22.039  -9.082  1.00 11.13           C
ATOM   1020  C   ILE   121     -41.980  20.382 -10.790  1.00 10.00           C
ATOM   1021  O   ILE   121     -42.496  19.302 -10.444  1.00 10.24           O
ATOM   1022  N   ALA   122     -41.999  20.822 -12.047  1.00 10.30           N
ATOM   1023  CA  ALA   122     -42.680  20.050 -13.108  1.00 11.54           C
ATOM   1024  CB  ALA   122     -42.598  20.755 -14.509  1.00 12.24           C
ATOM   1025  C   ALA   122     -42.094  18.638 -13.234  1.00 11.86           C
ATOM   1026  O   ALA   122     -42.845  17.702 -13.488  1.00 12.38           O
ATOM   1027  N   SER   123     -40.780  18.499 -13.132  1.00 11.72           N
ATOM   1028  CA  SER   123     -40.140  17.174 -13.297  1.00 11.69           C
ATOM   1029  CB  SER   123     -38.597  17.220 -13.248  1.00 13.37           C
ATOM   1030  OG  SER   123     -38.136  17.620 -11.957  1.00 18.01           O
ATOM   1031  C   SER   123     -40.678  16.217 -12.222  1.00 11.56           C
ATOM   1032  O   SER   123     -40.889  15.041 -12.504  1.00 11.30           O
ATOM   1033  N   VAL   124     -40.862  16.719 -10.996  1.00 10.19           N
ATOM   1034  CA  VAL   124     -41.338  15.876  -9.883  1.00  9.66           C
ATOM   1035  CB  VAL   124     -41.121  16.603  -8.497  1.00 10.39           C
ATOM   1036  CG1 VAL   124     -41.817  15.860  -7.384  1.00 13.37           C
ATOM   1037  CG2 VAL   124     -39.640  16.694  -8.191  1.00 12.44           C
ATOM   1038  C   VAL   124     -42.808  15.523 -10.075  1.00 10.08           C
ATOM   1039  O   VAL   124     -43.218  14.350  -9.905  1.00  9.51           O
ATOM   1040  N   ILE   125     -43.617  16.526 -10.409  1.00  9.88           N
ATOM   1041  CA  ILE   125     -45.046  16.301 -10.630  1.00 10.74           C
ATOM   1042  CB  ILE   125     -45.803  17.624 -10.870  1.00 11.75           C
ATOM   1043  CG1 ILE   125     -45.744  18.498  -9.590  1.00  9.55           C
ATOM   1044  CD1 ILE   125     -46.274  17.830  -8.232  1.00 11.11           C
ATOM   1045  CG2 ILE   125     -47.298  17.363 -11.280  1.00 10.72           C
ATOM   1046  C   ILE   125     -45.254  15.309 -11.757  1.00 10.24           C
ATOM   1047  O   ILE   125     -46.088  14.386 -11.644  1.00 10.73           O
ATOM   1048  N   ARG   126     -44.483  15.459 -12.837  0.50 10.47           N
ATOM   1050  CA  ARG   126     -44.567  14.514 -13.947  0.50  9.91           C
ATOM   1052  CB  ARG   126     -43.607  14.907 -15.078  0.50  9.78           C
ATOM   1054  CG  ARG   126     -44.070  16.073 -15.874  0.50  8.97           C
ATOM   1056  CD  ARG   126     -43.145  16.305 -17.083  0.50 11.78           C
ATOM   1058  NE  ARG   126     -43.524  17.541 -17.757  0.50 13.41           N
ATOM   1060  CZ  ARG   126     -42.784  18.643 -17.773  0.50 18.19           C
ATOM   1062  NH1 ARG   126     -41.594  18.649 -17.187  0.50 18.32           N
ATOM   1064  NH2 ARG   126     -43.223  19.729 -18.401  0.50 20.28           N
ATOM   1066  C   ARG   126     -44.269  13.104 -13.483  0.50 10.39           C
ATOM   1068  O   ARG   126     -45.010  12.161 -13.806  0.50 11.26           O
ATOM   1070  N   LEU   127     -43.191  12.959 -12.717  1.00 10.18           N
ATOM   1071  CA  LEU   127     -42.747  11.653 -12.281  1.00 11.49           C
ATOM   1072  CB  LEU   127     -41.457  11.792 -11.470  1.00 12.45           C
ATOM   1073  CG  LEU   127     -40.836  10.551 -10.872  1.00 15.70           C
ATOM   1074  CD1 LEU   127     -40.489   9.503 -11.921  1.00 20.81           C
ATOM   1075  CD2 LEU   127     -39.573  10.988 -10.121  1.00 18.67           C
ATOM   1076  C   LEU   127     -43.864  10.955 -11.482  1.00  9.91           C
ATOM   1077  O   LEU   127     -44.173   9.757 -11.684  1.00 10.50           O
ATOM   1078  N   LEU   128     -44.458  11.703 -10.559  1.00  8.79           N
ATOM   1079  CA  LEU   128     -45.555  11.167  -9.751  1.00  9.28           C
ATOM   1080  CB  LEU   128     -45.959  12.213  -8.701  1.00  9.38           C
ATOM   1081  CG  LEU   128     -44.895  12.460  -7.628  1.00 11.13           C
ATOM   1082  CD1 LEU   128     -45.399  13.599  -6.743  1.00 11.82           C
ATOM   1083  CD2 LEU   128     -44.635  11.243  -6.755  1.00 13.49           C
ATOM   1084  C   LEU   128     -46.755  10.814 -10.630  1.00 10.57           C
ATOM   1085  O   LEU   128     -47.393   9.762 -10.464  1.00  8.87           O
ATOM   1086  N   ALA   129     -47.111  11.725 -11.531  1.00  9.99           N
ATOM   1087  CA  ALA   129     -48.264  11.513 -12.419  1.00 10.43           C
ATOM   1088  CB  ALA   129     -48.466  12.756 -13.298  1.00 10.04           C
ATOM   1089  C   ALA   129     -48.072  10.270 -13.290  1.00  9.53           C
ATOM   1090  O   ALA   129     -49.010   9.490 -13.509  1.00  9.22           O
ATOM   1091  N   GLU   130     -46.842  10.075 -13.777  1.00 10.54           N
ATOM   1092  CA  GLU   130     -46.555   8.883 -14.586  1.00 10.65           C
ATOM   1093  CB  GLU   130     -45.130   8.957 -15.080  1.00 11.71           C
ATOM   1094  CG  GLU   130     -45.015   9.922 -16.236  1.00 15.98           C
ATOM   1095  CD  GLU   130     -43.548  10.268 -16.577  1.00 25.12           C
ATOM   1096  OE1 GLU   130     -42.602   9.684 -15.991  1.00 26.80           O
ATOM   1097  OE2 GLU   130     -43.362  11.157 -17.432  1.00 30.61           O
ATOM   1098  C   GLU   130     -46.799   7.589 -13.828  1.00 10.74           C
ATOM   1099  O   GLU   130     -47.364   6.626 -14.382  1.00  9.75           O
ATOM   1100  N   SER   131     -46.395   7.580 -12.558  0.50 10.14           N
ATOM   1102  CA  SER   131     -46.583   6.411 -11.722  0.50 10.49           C
ATOM   1104  CB  SER   131     -45.843   6.578 -10.396  0.50 11.10           C
ATOM   1106  OG  SER   131     -45.705   5.328  -9.775  0.50 10.69           O
ATOM   1108  C   SER   131     -48.057   6.142 -11.458  0.50 10.47           C
ATOM   1110  O   SER   131     -48.497   4.991 -11.474  0.50  9.95           O
ATOM   1112  N   ILE   132     -48.806   7.214 -11.186  1.00  9.30           N
ATOM   1113  CA  ILE   132     -50.274   7.155 -11.007  1.00 10.27           C
ATOM   1114  CB  ILE   132     -50.819   8.528 -10.573  1.00 10.43           C
ATOM   1115  CG1 ILE   132     -50.217   8.879  -9.199  1.00 10.19           C
ATOM   1116  CD1 ILE   132     -50.537  10.321  -8.694  1.00 10.55           C
ATOM   1117  CG2 ILE   132     -52.352   8.522 -10.544  1.00 12.86           C
ATOM   1118  C   ILE   132     -50.956   6.643 -12.274  1.00 10.09           C
ATOM   1119  O   ILE   132     -51.855   5.784 -12.188  1.00  9.47           O
ATOM   1120  N   GLU   133     -50.535   7.164 -13.426  0.50 10.08           N
ATOM   1122  CA  GLU   133     -51.024   6.713 -14.732  0.50 10.68           C
ATOM   1124  CB  GLU   133     -50.390   7.549 -15.871  0.50 10.91           C
ATOM   1126  CG  GLU   133     -51.050   8.940 -16.009  0.50 12.45           C
ATOM   1128  CD  GLU   133     -50.193  10.029 -16.674  0.50 14.41           C
ATOM   1130  OE1 GLU   133     -48.998   9.781 -16.983  0.50 17.78           O
ATOM   1132  OE2 GLU   133     -50.748  11.144 -16.892  0.50 18.07           O
ATOM   1134  C   GLU   133     -50.823   5.208 -14.941  0.50  9.88           C
ATOM   1136  O   GLU   133     -51.712   4.518 -15.430  0.50 10.09           O
ATOM   1138  N   ALA   134     -49.659   4.695 -14.546  1.00  9.31           N
ATOM   1139  CA  ALA   134     -49.346   3.267 -14.674  1.00  9.01           C
ATOM   1140  CB  ALA   134     -47.869   3.011 -14.361  1.00  9.38           C
ATOM   1141  C   ALA   134     -50.237   2.445 -13.765  1.00  9.17           C
ATOM   1142  O   ALA   134     -50.720   1.372 -14.144  1.00  9.07           O
ATOM   1143  N   GLY   135     -50.446   2.954 -12.554  1.00  9.74           N
ATOM   1144  CA  GLY   135     -51.304   2.264 -11.598  1.00  9.68           C
ATOM   1145  C   GLY   135     -52.748   2.231 -12.081  1.00 10.54           C
ATOM   1146  O   GLY   135     -53.432   1.261 -11.841  1.00 11.18           O
ATOM   1147  N   MET   136     -53.212   3.294 -12.736  1.00 10.78           N
ATOM   1148  CA  MET   136     -54.550   3.319 -13.316  1.00 14.00           C
ATOM   1149  CB  MET   136     -54.856   4.709 -13.853  1.00 12.19           C
ATOM   1150  CG  MET   136     -55.025   5.738 -12.769  1.00 17.50           C
ATOM   1151  SD  MET   136     -55.390   7.532 -13.517  0.80 27.77          SE
ATOM   1152  CE  MET   136     -56.956   7.128 -14.509  1.00 24.50           C
ATOM   1153  C   MET   136     -54.690   2.274 -14.426  1.00 11.62           C
ATOM   1154  O   MET   136     -55.630   1.461 -14.414  1.00 11.88           O
ATOM   1155  N   THR   137     -53.704   2.228 -15.331  1.00 10.74           N
ATOM   1156  CA  THR   137     -53.673   1.197 -16.405  1.00  9.88           C
ATOM   1157  CB  THR   137     -52.401   1.371 -17.285  1.00  9.89           C
ATOM   1158  OG1 THR   137     -52.434   2.676 -17.872  1.00 11.23           O
ATOM   1159  CG2 THR   137     -52.311   0.289 -18.374  1.00 10.49           C
ATOM   1160  C   THR   137     -53.735  -0.220 -15.824  1.00  9.70           C
ATOM   1161  O   THR   137     -54.451  -1.096 -16.313  1.00  8.79           O
ATOM   1162  N   ARG   138     -53.012  -0.433 -14.737  1.00 10.06           N
ATOM   1163  CA  ARG   138     -52.962  -1.726 -14.092  1.00 10.50           C
ATOM   1164  CB  ARG   138     -51.753  -1.827 -13.178  1.00 10.22           C
ATOM   1165  CG  ARG   138     -50.421  -1.961 -13.926  1.00 11.00           C
ATOM   1166  CD  ARG   138     -49.267  -1.783 -12.921  1.00 11.40           C
ATOM   1167  NE  ARG   138     -49.385  -2.776 -11.860  1.00 13.48           N
ATOM   1168  CZ  ARG   138     -48.694  -2.749 -10.731  1.00 16.65           C
ATOM   1169  NH1 ARG   138     -47.798  -1.778 -10.519  1.00 13.97           N
ATOM   1170  NH2 ARG   138     -48.909  -3.699  -9.812  1.00 18.04           N
ATOM   1171  C   ARG   138     -54.233  -2.088 -13.308  1.00 11.15           C
ATOM   1172  O   ARG   138     -54.391  -3.238 -12.908  1.00 11.80           O
ATOM   1173  N   GLY   139     -55.117  -1.122 -13.103  1.00 12.43           N
ATOM   1174  CA  GLY   139     -56.308  -1.342 -12.309  1.00 12.85           C
ATOM   1175  C   GLY   139     -56.098  -1.206 -10.803  1.00 14.77           C
ATOM   1176  O   GLY   139     -57.031  -1.500 -10.021  1.00 15.21           O
ATOM   1177  N   LEU   140     -54.904  -0.785 -10.370  1.00 14.40           N
ATOM   1178  CA  LEU   140     -54.663  -0.525  -8.930  1.00 15.70           C
ATOM   1179  CB  LEU   140     -53.175  -0.325  -8.608  1.00 17.02           C
ATOM   1180  CG  LEU   140     -52.165  -1.407  -8.937  1.00 20.06           C
ATOM   1181  CD1 LEU   140     -50.855  -0.921  -8.327  1.00 24.89           C
ATOM   1182  CD2 LEU   140     -52.585  -2.711  -8.319  1.00 24.25           C
ATOM   1183  C   LEU   140     -55.356   0.744  -8.489  1.00 14.92           C
ATOM   1184  O   LEU   140     -55.818   0.834  -7.342  1.00 14.43           O
ATOM   1185  N   PHE   141     -55.378   1.734  -9.384  1.00 13.97           N
ATOM   1186  CA  PHE   141     -55.934   3.051  -9.092  1.00 15.04           C
ATOM   1187  CB  PHE   141     -54.894   4.159  -9.339  1.00 13.91           C
ATOM   1188  CG  PHE   141     -53.627   4.016  -8.510  1.00 13.77           C
ATOM   1189  CD1 PHE   141     -53.668   3.442  -7.227  1.00 13.85           C
ATOM   1190  CE1 PHE   141     -52.491   3.310  -6.463  1.00 13.85           C
ATOM   1191  CZ  PHE   141     -51.267   3.776  -7.000  1.00 12.20           C
ATOM   1192  CE2 PHE   141     -51.240   4.341  -8.294  1.00 10.44           C
ATOM   1193  CD2 PHE   141     -52.392   4.479  -9.011  1.00 12.75           C
ATOM   1194  C   PHE   141     -57.151   3.307  -9.951  1.00 15.74           C
ATOM   1195  O   PHE   141     -57.249   2.777 -11.067  1.00 14.26           O
ATOM   1196  N   ARG   142     -58.074   4.120  -9.443  0.50 16.15           N
ATOM   1198  CA  ARG   142     -59.333   4.428 -10.124  0.50 17.47           C
ATOM   1200  CB  ARG   142     -60.256   5.250  -9.227  0.50 17.67           C
ATOM   1202  CG  ARG   142     -60.907   4.514  -8.115  0.50 18.73           C
ATOM   1204  CD  ARG   142     -61.871   5.446  -7.428  0.50 20.28           C
ATOM   1206  NE  ARG   142     -61.191   6.543  -6.744  0.50 20.28           N
ATOM   1208  CZ  ARG   142     -61.802   7.632  -6.287  0.50 20.99           C
ATOM   1210  NH1 ARG   142     -63.104   7.797  -6.474  0.50 17.88           N
ATOM   1212  NH2 ARG   142     -61.099   8.580  -5.668  0.50 20.92           N
ATOM   1214  C   ARG   142     -59.126   5.255 -11.374  0.50 17.70           C
ATOM   1216  O   ARG   142     -58.339   6.198 -11.388  0.50 18.50           O
ATOM   1218  N   ARG   143     -59.912   4.938 -12.395  1.00 18.41           N
ATOM   1219  CA  ARG   143     -59.747   5.554 -13.691  1.00 19.17           C
ATOM   1220  CB  ARG   143     -60.007   4.550 -14.785  1.00 19.39           C
ATOM   1221  CG  ARG   143     -58.965   3.434 -14.827  1.00 22.29           C
ATOM   1222  CD  ARG   143     -59.450   2.272 -15.677  1.00 26.49           C
ATOM   1223  NE  ARG   143     -58.403   1.273 -15.895  1.00 30.12           N
ATOM   1224  CZ  ARG   143     -58.545  -0.047 -15.757  1.00 31.21           C
ATOM   1225  NH1 ARG   143     -59.715  -0.594 -15.415  1.00 32.67           N
ATOM   1226  NH2 ARG   143     -57.502  -0.838 -15.984  1.00 31.42           N
ATOM   1227  C   ARG   143     -60.507   6.857 -13.893  1.00 18.83           C
ATOM   1228  O   ARG   143     -60.315   7.510 -14.913  1.00 20.12           O
ATOM   1229  N   ASP   144     -61.324   7.254 -12.917  1.00 17.76           N
ATOM   1230  CA  ASP   144     -62.025   8.547 -12.977  1.00 16.37           C
ATOM   1231  CB  ASP   144     -63.426   8.450 -12.354  1.00 16.63           C
ATOM   1232  CG  ASP   144     -63.395   8.116 -10.877  1.00 17.52           C
ATOM   1233  OD1 ASP   144     -62.398   7.530 -10.424  1.00 17.03           O
ATOM   1234  OD2 ASP   144     -64.383   8.426 -10.159  1.00 20.81           O
ATOM   1235  C   ASP   144     -61.281   9.716 -12.339  1.00 15.58           C
ATOM   1236  O   ASP   144     -61.871  10.803 -12.135  1.00 16.22           O
ATOM   1237  N   LEU   145     -60.024   9.520 -11.954  0.50 14.65           N
ATOM   1239  CA  LEU   145     -59.257  10.650 -11.435  0.50 13.62           C
ATOM   1241  CB  LEU   145     -58.748  10.426 -10.005  0.50 13.58           C
ATOM   1243  CG  LEU   145     -59.708  10.249  -8.827  0.50 13.00           C
ATOM   1245  CD1 LEU   145     -58.863   9.721  -7.686  0.50 13.60           C
ATOM   1247  CD2 LEU   145     -60.478  11.539  -8.398  0.50 13.09           C
ATOM   1249  C   LEU   145     -58.106  10.962 -12.376  0.50 13.00           C
ATOM   1251  O   LEU   145     -57.581  10.079 -13.050  0.50 12.96           O
ATOM   1253  N   HIS   146     -57.762  12.235 -12.428  1.00 12.38           N
ATOM   1254  CA  HIS   146     -56.767  12.749 -13.335  1.00 11.72           C
ATOM   1255  CB  HIS   146     -57.099  14.174 -13.754  1.00 13.12           C
ATOM   1256  CG  HIS   146     -58.088  14.223 -14.890  1.00 18.87           C
ATOM   1257  ND1 HIS   146     -59.407  14.593 -14.717  1.00 23.34           N
ATOM   1258  CE1 HIS   146     -60.041  14.495 -15.875  1.00 23.61           C
ATOM   1259  NE2 HIS   146     -59.189  14.056 -16.787  1.00 22.78           N
ATOM   1260  CD2 HIS   146     -57.966  13.859 -16.194  1.00 21.18           C
ATOM   1261  C   HIS   146     -55.432  12.632 -12.658  1.00  9.97           C
ATOM   1262  O   HIS   146     -55.283  13.064 -11.523  1.00  8.48           O
ATOM   1263  N   ALA   147     -54.466  12.063 -13.380  1.00  8.06           N
ATOM   1264  CA  ALA   147     -53.171  11.743 -12.792  1.00  7.43           C
ATOM   1265  CB  ALA   147     -52.303  10.976 -13.795  1.00  7.64           C
ATOM   1266  C   ALA   147     -52.415  12.975 -12.255  1.00  7.37           C
ATOM   1267  O   ALA   147     -51.892  12.935 -11.149  1.00  7.42           O
ATOM   1268  N   VAL   148     -52.323  14.040 -13.057  1.00  5.91           N
ATOM   1269  CA  VAL   148     -51.580  15.234 -12.596  1.00  5.28           C
ATOM   1270  CB  VAL   148     -51.376  16.285 -13.741  1.00  5.29           C
ATOM   1271  CG1 VAL   148     -50.894  17.623 -13.160  1.00  5.38           C
ATOM   1272  CG2 VAL   148     -50.385  15.716 -14.827  1.00  7.18           C
ATOM   1273  C   VAL   148     -52.285  15.874 -11.417  1.00  5.21           C
ATOM   1274  O   VAL   148     -51.641  16.225 -10.424  1.00  4.80           O
ATOM   1275  N   ASN   149     -53.605  16.034 -11.475  1.00  5.51           N
ATOM   1276  CA  ASN   149     -54.259  16.664 -10.322  1.00  5.65           C
ATOM   1277  CB  ASN   149     -55.765  16.822 -10.566  1.00  6.66           C
ATOM   1278  CG  ASN   149     -56.088  18.026 -11.409  1.00 10.17           C
ATOM   1279  OD1 ASN   149     -55.200  18.846 -11.725  1.00 12.80           O
ATOM   1280  ND2 ASN   149     -57.358  18.143 -11.798  1.00 12.10           N
ATOM   1281  C   ASN   149     -54.045  15.842  -9.043  1.00  6.11           C
ATOM   1282  O   ASN   149     -53.933  16.413  -7.953  1.00  4.78           O
ATOM   1283  N   SER   150     -53.988  14.513  -9.207  1.00  5.76           N
ATOM   1284  CA  SER   150     -53.748  13.564  -8.084  1.00  6.08           C
ATOM   1285  CB  SER   150     -54.027  12.096  -8.522  1.00  5.78           C
ATOM   1286  OG  SER   150     -55.422  11.927  -8.837  1.00  7.08           O
ATOM   1287  C   SER   150     -52.331  13.717  -7.550  1.00  5.66           C
ATOM   1288  O   SER   150     -52.119  13.810  -6.341  1.00  5.57           O
ATOM   1289  N   ALA   151     -51.349  13.768  -8.451  1.00  5.77           N
ATOM   1290  CA  ALA   151     -49.966  14.064  -8.076  1.00  5.41           C
ATOM   1291  CB  ALA   151     -49.086  14.156  -9.326  1.00  5.18           C
ATOM   1292  C   ALA   151     -49.874  15.386  -7.279  1.00  5.91           C
ATOM   1293  O   ALA   151     -49.179  15.466  -6.262  1.00  6.61           O
ATOM   1294  N   LEU   152     -50.552  16.425  -7.784  1.00  6.31           N
ATOM   1295  CA  LEU   152     -50.534  17.749  -7.110  1.00  5.72           C
ATOM   1296  CB  LEU   152     -51.297  18.807  -7.921  1.00  4.81           C
ATOM   1297  CG  LEU   152     -50.598  19.222  -9.218  1.00  4.27           C
ATOM   1298  CD1 LEU   152     -51.572  20.071 -10.072  1.00  6.58           C
ATOM   1299  CD2 LEU   152     -49.276  20.001  -8.973  1.00  5.18           C
ATOM   1300  C   LEU   152     -51.132  17.647  -5.707  1.00  7.70           C
ATOM   1301  O   LEU   152     -50.626  18.296  -4.766  1.00  7.69           O
ATOM   1302  N   ALA   153     -52.188  16.836  -5.551  1.00  6.37           N
ATOM   1303  CA  ALA   153     -52.794  16.600  -4.245  1.00  7.16           C
ATOM   1304  CB  ALA   153     -54.029  15.679  -4.378  1.00  5.65           C
ATOM   1305  C   ALA   153     -51.787  16.008  -3.247  1.00  7.42           C
ATOM   1306  O   ALA   153     -51.667  16.511  -2.117  1.00  6.88           O
ATOM   1307  N   LEU   154     -51.039  14.972  -3.683  1.00  5.98           N
ATOM   1308  CA  LEU   154     -50.031  14.354  -2.805  1.00  5.94           C
ATOM   1309  CB  LEU   154     -49.453  13.092  -3.458  1.00  6.06           C
ATOM   1310  CG  LEU   154     -48.400  12.364  -2.617  1.00  6.43           C
ATOM   1311  CD1 LEU   154     -48.990  11.876  -1.271  1.00  5.45           C
ATOM   1312  CD2 LEU   154     -47.790  11.240  -3.434  1.00  7.02           C
ATOM   1313  C   LEU   154     -48.921  15.373  -2.447  1.00  5.85           C
ATOM   1314  O   LEU   154     -48.530  15.518  -1.271  1.00  6.15           O
ATOM   1315  N   ALA   155     -48.449  16.084  -3.464  1.00  6.37           N
ATOM   1316  CA  ALA   155     -47.402  17.083  -3.242  1.00  6.90           C
ATOM   1317  CB  ALA   155     -46.984  17.689  -4.593  1.00  7.15           C
ATOM   1318  C   ALA   155     -47.927  18.147  -2.260  1.00  6.59           C
ATOM   1319  O   ALA   155     -47.181  18.625  -1.387  1.00  7.17           O
ATOM   1320  N   GLY   156     -49.204  18.510  -2.409  1.00  6.53           N
ATOM   1321  CA  GLY   156     -49.808  19.558  -1.574  1.00  7.23           C
ATOM   1322  C   GLY   156     -49.903  19.117  -0.129  1.00  8.33           C
ATOM   1323  O   GLY   156     -49.684  19.935   0.770  1.00  9.18           O
ATOM   1324  N   MET   157     -50.275  17.857   0.104  0.50  7.22           N
ATOM   1326  CA  MET   157     -50.394  17.342   1.473  0.50  9.40           C
ATOM   1328  CB  MET   157     -50.608  15.818   1.495  0.50  9.03           C
ATOM   1330  CG  MET   157     -51.950  15.368   1.037  0.50 10.44           C
ATOM   1332  SD  MET   157     -52.121  13.470   1.490  0.50 14.75          SE
ATOM   1334  CE  MET   157     -53.565  13.043   0.240  0.50 11.36           C
ATOM   1336  C   MET   157     -49.104  17.647   2.216  0.50  8.33           C
ATOM   1338  O   MET   157     -49.097  18.375   3.226  0.50  7.60           O
ATOM   1340  N   VAL   158     -48.020  17.067   1.700  1.00  7.62           N
ATOM   1341  CA  VAL   158     -46.738  17.073   2.389  1.00  7.60           C
ATOM   1342  CB  VAL   158     -45.769  16.001   1.870  1.00  7.87           C
ATOM   1343  CG1 VAL   158     -45.363  16.267   0.375  1.00  6.80           C
ATOM   1344  CG2 VAL   158     -44.556  15.904   2.800  1.00  5.50           C
ATOM   1345  C   VAL   158     -46.161  18.504   2.448  1.00  8.05           C
ATOM   1346  O   VAL   158     -45.655  18.951   3.498  1.00  7.94           O
ATOM   1347  N   ASN   159     -46.268  19.258   1.359  1.00  6.99           N
ATOM   1348  CA  ASN   159     -45.679  20.596   1.364  1.00  8.56           C
ATOM   1349  CB  ASN   159     -45.517  21.063  -0.110  1.00  9.44           C
ATOM   1350  CG  ASN   159     -44.267  20.391  -0.770  1.00 13.46           C
ATOM   1351  OD1 ASN   159     -43.115  20.774  -0.449  1.00 13.49           O
ATOM   1352  ND2 ASN   159     -44.491  19.365  -1.676  1.00 11.04           N
ATOM   1353  C   ASN   159     -46.491  21.532   2.299  1.00  8.55           C
ATOM   1354  O   ASN   159     -45.898  22.350   3.007  1.00  8.77           O
ATOM   1355  N   TYR   160     -47.807  21.324   2.393  1.00  8.99           N
ATOM   1356  CA  TYR   160     -48.598  22.206   3.289  1.00  8.46           C
ATOM   1357  CB  TYR   160     -50.076  22.031   3.041  1.00  9.05           C
ATOM   1358  CG  TYR   160     -50.895  23.089   3.758  1.00  6.76           C
ATOM   1359  CD1 TYR   160     -51.004  24.373   3.254  1.00  6.16           C
ATOM   1360  CE1 TYR   160     -51.755  25.374   3.951  1.00  6.68           C
ATOM   1361  CZ  TYR   160     -52.367  25.032   5.159  1.00  6.05           C
ATOM   1362  OH  TYR   160     -53.125  25.927   5.884  1.00  6.88           O
ATOM   1363  CE2 TYR   160     -52.260  23.729   5.663  1.00  7.56           C
ATOM   1364  CD2 TYR   160     -51.513  22.779   4.968  1.00  8.31           C
ATOM   1365  C   TYR   160     -48.297  21.873   4.749  1.00  8.41           C
ATOM   1366  O   TYR   160     -48.341  22.775   5.600  1.00  7.66           O
ATOM   1367  N   PHE   161     -48.025  20.596   5.064  1.00  7.26           N
ATOM   1368  CA  PHE   161     -47.662  20.273   6.467  1.00  7.86           C
ATOM   1369  CB  PHE   161     -47.311  18.790   6.604  1.00  7.74           C
ATOM   1370  CG  PHE   161     -46.983  18.392   7.998  1.00  9.30           C
ATOM   1371  CD1 PHE   161     -48.006  18.107   8.896  1.00 12.83           C
ATOM   1372  CE1 PHE   161     -47.720  17.697  10.215  1.00 11.42           C
ATOM   1373  CZ  PHE   161     -46.391  17.641  10.657  1.00 12.71           C
ATOM   1374  CE2 PHE   161     -45.357  17.968   9.769  1.00 10.83           C
ATOM   1375  CD2 PHE   161     -45.666  18.335   8.433  1.00 11.04           C
ATOM   1376  C   PHE   161     -46.491  21.148   6.954  1.00  7.95           C
ATOM   1377  O   PHE   161     -46.543  21.724   8.066  1.00  9.32           O
ATOM   1378  N   PHE   162     -45.463  21.301   6.114  1.00  6.72           N
ATOM   1379  CA  PHE   162     -44.318  22.124   6.507  1.00  7.65           C
ATOM   1380  CB  PHE   162     -43.078  21.726   5.710  1.00  7.99           C
ATOM   1381  CG  PHE   162     -42.566  20.366   6.105  1.00  9.27           C
ATOM   1382  CD1 PHE   162     -41.714  20.225   7.191  1.00 10.78           C
ATOM   1383  CE1 PHE   162     -41.239  18.956   7.593  1.00 11.91           C
ATOM   1384  CZ  PHE   162     -41.634  17.827   6.904  1.00 11.69           C
ATOM   1385  CE2 PHE   162     -42.511  17.965   5.784  1.00 13.79           C
ATOM   1386  CD2 PHE   162     -42.967  19.220   5.412  1.00 10.23           C
ATOM   1387  C   PHE   162     -44.639  23.608   6.400  1.00  6.36           C
ATOM   1388  O   PHE   162     -44.272  24.414   7.281  1.00  6.77           O
ATOM   1389  N   LEU   163     -45.339  23.986   5.329  1.00  6.53           N
ATOM   1390  CA  LEU   163     -45.685  25.410   5.150  1.00  6.76           C
ATOM   1391  CB  LEU   163     -46.531  25.576   3.876  1.00  6.66           C
ATOM   1392  CG  LEU   163     -46.960  27.017   3.573  1.00  7.04           C
ATOM   1393  CD1 LEU   163     -45.732  27.937   3.372  1.00  9.53           C
ATOM   1394  CD2 LEU   163     -47.878  27.026   2.294  1.00  8.47           C
ATOM   1395  C   LEU   163     -46.462  25.968   6.327  1.00  6.16           C
ATOM   1396  O   LEU   163     -46.251  27.132   6.716  1.00  6.46           O
ATOM   1397  N   SER   164     -47.398  25.156   6.872  1.00  5.30           N
ATOM   1398  CA  SER   164     -48.338  25.682   7.889  1.00  7.61           C
ATOM   1399  CB  SER   164     -49.657  24.912   7.802  1.00  8.19           C
ATOM   1400  OG  SER   164     -49.459  23.552   8.139  1.00  9.73           O
ATOM   1401  C   SER   164     -47.773  25.574   9.326  1.00  7.56           C
ATOM   1402  O   SER   164     -48.479  25.903  10.294  1.00  8.21           O
ATOM   1403  N   THR   165     -46.511  25.154   9.458  1.00  5.79           N
ATOM   1404  CA  THR   165     -45.964  24.822  10.782  1.00  6.26           C
ATOM   1405  CB  THR   165     -44.424  24.572  10.701  1.00  6.23           C
ATOM   1406  OG1 THR   165     -44.184  23.428   9.866  1.00  7.44           O
ATOM   1407  CG2 THR   165     -43.891  24.259  12.117  1.00  8.11           C
ATOM   1408  C   THR   165     -46.186  25.914  11.821  1.00  4.75           C
ATOM   1409  O   THR   165     -46.641  25.626  12.936  1.00  5.25           O
ATOM   1410  N   LEU   166     -45.844  27.165  11.481  1.00  5.75           N
ATOM   1411  CA  LEU   166     -45.911  28.235  12.482  1.00  6.51           C
ATOM   1412  CB  LEU   166     -45.339  29.576  11.965  1.00  6.68           C
ATOM   1413  CG  LEU   166     -43.841  29.678  11.719  1.00 10.81           C
ATOM   1414  CD1 LEU   166     -43.547  31.167  11.394  1.00 11.81           C
ATOM   1415  CD2 LEU   166     -43.055  29.293  13.016  1.00 11.69           C
ATOM   1416  C   LEU   166     -47.337  28.456  12.986  1.00  7.46           C
ATOM   1417  O   LEU   166     -47.491  28.973  14.095  1.00  8.56           O
ATOM   1418  N   ALA   167     -48.369  28.123  12.171  1.00  6.08           N
ATOM   1419  CA  ALA   167     -49.766  28.384  12.541  1.00  8.18           C
ATOM   1420  CB  ALA   167     -50.626  28.722  11.311  1.00  7.47           C
ATOM   1421  C   ALA   167     -50.387  27.203  13.251  1.00  8.91           C
ATOM   1422  O   ALA   167     -51.532  27.304  13.723  1.00  9.05           O
ATOM   1423  N   THR   168     -49.662  26.096  13.285  1.00  8.62           N
ATOM   1424  CA  THR   168     -50.264  24.857  13.794  1.00 10.98           C
ATOM   1425  CB  THR   168     -50.502  23.867  12.644  1.00  9.39           C
ATOM   1426  OG1 THR   168     -49.275  23.508  11.993  1.00 11.50           O
ATOM   1427  CG2 THR   168     -51.464  24.477  11.542  1.00  9.79           C
ATOM   1428  C   THR   168     -49.423  24.220  14.919  1.00 10.56           C
ATOM   1429  O   THR   168     -49.522  22.997  15.158  1.00 11.79           O
ATOM   1430  N   GLU   169     -48.671  25.069  15.639  1.00 13.47           N
ATOM   1431  CA  GLU   169     -47.634  24.567  16.568  1.00 14.51           C
ATOM   1432  CB  GLU   169     -46.793  25.705  17.190  1.00 15.58           C
ATOM   1433  CG  GLU   169     -45.950  26.533  16.217  1.00 16.67           C
ATOM   1434  CD  GLU   169     -44.641  25.858  15.769  1.00 18.06           C
ATOM   1435  OE1 GLU   169     -44.427  24.660  16.046  1.00 20.34           O
ATOM   1436  OE2 GLU   169     -43.824  26.515  15.088  1.00 17.77           O
ATOM   1437  C   GLU   169     -48.280  23.732  17.661  1.00 14.80           C
ATOM   1438  O   GLU   169     -47.758  22.662  18.045  1.00 15.84           O
ATOM   1439  N   GLY   170     -49.391  24.218  18.188  1.00 14.31           N
ATOM   1440  CA  GLY   170     -50.050  23.519  19.293  1.00 15.34           C
ATOM   1441  C   GLY   170     -51.115  22.570  18.807  1.00 14.96           C
ATOM   1442  O   GLY   170     -51.802  21.946  19.628  1.00 15.30           O
ATOM   1443  N   LEU   171     -51.257  22.405  17.486  1.00 11.97           N
ATOM   1444  CA  LEU   171     -52.364  21.571  16.985  1.00 12.07           C
ATOM   1445  CB  LEU   171     -53.048  22.173  15.739  1.00 11.20           C
ATOM   1446  CG  LEU   171     -53.567  23.620  15.751  1.00 13.56           C
ATOM   1447  CD1 LEU   171     -54.356  23.917  14.477  1.00 12.40           C
ATOM   1448  CD2 LEU   171     -54.410  23.968  16.985  1.00 16.09           C
ATOM   1449  C   LEU   171     -51.901  20.179  16.629  1.00 12.32           C
ATOM   1450  O   LEU   171     -52.706  19.251  16.620  1.00 12.27           O
ATOM   1451  N   THR   172     -50.620  20.021  16.304  1.00 11.32           N
ATOM   1452  CA  THR   172     -50.093  18.690  15.929  1.00 12.36           C
ATOM   1453  CB  THR   172     -50.439  18.296  14.451  1.00 11.94           C
ATOM   1454  OG1 THR   172     -50.076  16.907  14.240  1.00 16.35           O
ATOM   1455  CG2 THR   172     -49.710  19.217  13.452  1.00 12.29           C
ATOM   1456  C   THR   172     -48.585  18.711  16.141  1.00 12.72           C
ATOM   1457  O   THR   172     -47.994  19.812  16.226  1.00 13.87           O
ATOM   1458  N   SER   173     -47.958  17.545  16.214  1.00 12.97           N
ATOM   1459  CA  SER   173     -46.524  17.503  16.397  1.00 11.93           C
ATOM   1460  CB  SER   173     -46.103  16.108  16.826  1.00 13.97           C
ATOM   1461  OG  SER   173     -44.681  15.989  16.771  1.00 14.44           O
ATOM   1462  C   SER   173     -45.874  17.806  15.060  1.00 12.33           C
ATOM   1463  O   SER   173     -46.353  17.332  14.028  1.00 12.42           O
ATOM   1464  N   HIS   174     -44.824  18.610  15.068  1.00 12.00           N
ATOM   1465  CA  HIS   174     -43.970  18.721  13.876  1.00 14.23           C
ATOM   1466  CB  HIS   174     -43.909  20.171  13.391  1.00 14.23           C
ATOM   1467  CG  HIS   174     -45.247  20.722  13.030  1.00 15.81           C
ATOM   1468  ND1 HIS   174     -46.071  21.324  13.968  1.00 16.61           N
ATOM   1469  CE1 HIS   174     -47.185  21.718  13.368  1.00 20.91           C
ATOM   1470  NE2 HIS   174     -47.116  21.386  12.085  1.00 19.63           N
ATOM   1471  CD2 HIS   174     -45.900  20.785  11.839  1.00 17.42           C
ATOM   1472  C   HIS   174     -42.578  18.183  14.149  1.00 13.15           C
ATOM   1473  O   HIS   174     -41.625  18.515  13.427  1.00 14.79           O
ATOM   1474  N   SER   175     -42.456  17.352  15.179  1.00 14.28           N
ATOM   1475  CA  SER   175     -41.158  16.794  15.566  1.00 13.71           C
ATOM   1476  CB  SER   175     -41.281  16.104  16.921  1.00 14.35           C
ATOM   1477  OG  SER   175     -40.255  15.138  17.113  1.00 17.37           O
ATOM   1478  C   SER   175     -40.645  15.822  14.475  1.00 13.44           C
ATOM   1479  O   SER   175     -41.412  15.024  13.953  1.00 12.58           O
ATOM   1480  N   PRO   176     -39.341  15.882  14.146  1.00 13.15           N
ATOM   1481  CA  PRO   176     -38.830  14.880  13.178  1.00 13.22           C
ATOM   1482  CB  PRO   176     -37.342  15.224  13.064  1.00 13.70           C
ATOM   1483  CG  PRO   176     -37.228  16.655  13.534  1.00 13.98           C
ATOM   1484  CD  PRO   176     -38.278  16.806  14.593  1.00 13.08           C
ATOM   1485  C   PRO   176     -39.045  13.413  13.624  1.00 14.24           C
ATOM   1486  O   PRO   176     -39.154  12.527  12.770  1.00 13.21           O
ATOM   1487  N   ASP   177     -39.134  13.171  14.936  1.00 14.82           N
ATOM   1488  CA  ASP   177     -39.514  11.855  15.496  1.00 16.58           C
ATOM   1489  CB  ASP   177     -39.811  11.976  17.000  1.00 17.92           C
ATOM   1490  CG  ASP   177     -38.610  12.345  17.796  1.00 24.07           C
ATOM   1491  OD1 ASP   177     -37.500  12.389  17.204  1.00 30.89           O
ATOM   1492  OD2 ASP   177     -38.764  12.562  19.024  1.00 30.05           O
ATOM   1493  C   ASP   177     -40.780  11.270  14.887  1.00 15.97           C
ATOM   1494  O   ASP   177     -40.967  10.047  14.905  1.00 16.38           O
ATOM   1495  N   GLN   178     -41.655  12.147  14.404  1.00 14.77           N
ATOM   1496  CA  GLN   178     -42.965  11.735  13.923  1.00 15.23           C
ATOM   1497  CB  GLN   178     -44.057  12.637  14.515  1.00 16.28           C
ATOM   1498  CG  GLN   178     -44.212  12.558  16.075  1.00 18.38           C
ATOM   1499  CD  GLN   178     -44.416  11.148  16.555  1.00 24.89           C
ATOM   1500  OE1 GLN   178     -45.323  10.454  16.094  1.00 28.81           O
ATOM   1501  NE2 GLN   178     -43.556  10.694  17.466  1.00 23.68           N
ATOM   1502  C   GLN   178     -43.060  11.731  12.390  1.00 14.33           C
ATOM   1503  O   GLN   178     -44.153  11.563  11.837  1.00 14.25           O
ATOM   1504  N   ASP   179     -41.935  11.946  11.715  1.00 13.75           N
ATOM   1505  CA  ASP   179     -41.931  12.025  10.241  1.00 12.28           C
ATOM   1506  CB  ASP   179     -40.565  12.503   9.712  1.00 12.21           C
ATOM   1507  CG  ASP   179     -40.345  14.003   9.887  1.00 12.00           C
ATOM   1508  OD1 ASP   179     -41.340  14.728  10.133  1.00 12.73           O
ATOM   1509  OD2 ASP   179     -39.178  14.458   9.767  1.00 10.97           O
ATOM   1510  C   ASP   179     -42.333  10.695   9.583  1.00 12.43           C
ATOM   1511  O   ASP   179     -43.076  10.688   8.586  1.00 11.55           O
ATOM   1512  N   GLU   180     -41.873   9.564  10.129  1.00 12.85           N
ATOM   1513  CA  GLU   180     -42.244   8.281   9.539  1.00 13.39           C
ATOM   1514  CB  GLU   180     -41.363   7.129  10.047  1.00 14.36           C
ATOM   1515  CG  GLU   180     -39.961   7.112   9.416  1.00 16.71           C
ATOM   1516  CD  GLU   180     -39.971   6.815   7.917  1.00 18.99           C
ATOM   1517  OE1 GLU   180     -40.744   5.922   7.502  1.00 20.42           O
ATOM   1518  OE2 GLU   180     -39.200   7.469   7.161  1.00 18.63           O
ATOM   1519  C   GLU   180     -43.734   8.019   9.746  1.00 13.71           C
ATOM   1520  O   GLU   180     -44.403   7.448   8.873  1.00 13.28           O
ATOM   1521  N   GLU   181     -44.271   8.460  10.883  1.00 13.78           N
ATOM   1522  CA  GLU   181     -45.689   8.305  11.124  1.00 14.42           C
ATOM   1523  CB  GLU   181     -45.998   8.599  12.588  1.00 16.10           C
ATOM   1524  CG  GLU   181     -47.472   8.632  12.901  1.00 21.01           C
ATOM   1525  CD  GLU   181     -48.173   7.282  12.774  1.00 23.11           C
ATOM   1526  OE1 GLU   181     -47.514   6.228  12.665  1.00 24.17           O
ATOM   1527  OE2 GLU   181     -49.422   7.301  12.790  1.00 25.06           O
ATOM   1528  C   GLU   181     -46.494   9.212  10.185  1.00 14.14           C
ATOM   1529  O   GLU   181     -47.564   8.828   9.706  1.00 14.26           O
ATOM   1530  N   LEU   182     -45.956  10.396   9.878  1.00 13.08           N
ATOM   1531  CA  LEU   182     -46.604  11.293   8.915  1.00 13.64           C
ATOM   1532  CB  LEU   182     -45.865  12.643   8.831  1.00 12.83           C
ATOM   1533  CG  LEU   182     -46.579  13.680   7.940  1.00 14.91           C
ATOM   1534  CD1 LEU   182     -47.863  14.196   8.590  1.00 15.08           C
ATOM   1535  CD2 LEU   182     -45.644  14.827   7.575  1.00 15.95           C
ATOM   1536  C   LEU   182     -46.678  10.637   7.522  1.00 13.14           C
ATOM   1537  O   LEU   182     -47.718  10.661   6.855  1.00 14.11           O
ATOM   1538  N   ILE   183     -45.576  10.050   7.084  1.00 12.68           N
ATOM   1539  CA  ILE   183     -45.564   9.306   5.810  1.00 11.35           C
ATOM   1540  CB  ILE   183     -44.189   8.673   5.546  1.00 10.84           C
ATOM   1541  CG1 ILE   183     -43.122   9.766   5.347  1.00 12.02           C
ATOM   1542  CD1 ILE   183     -41.658   9.195   5.429  1.00 11.23           C
ATOM   1543  CG2 ILE   183     -44.228   7.768   4.309  1.00 11.12           C
ATOM   1544  C   ILE   183     -46.664   8.205   5.800  1.00 11.45           C
ATOM   1545  O   ILE   183     -47.422   8.086   4.830  1.00 10.62           O
ATOM   1546  N   ARG   184     -46.735   7.438   6.884  0.50 11.53           N
ATOM   1548  CA  ARG   184     -47.720   6.369   7.046  0.50 11.75           C
ATOM   1550  CB  ARG   184     -47.569   5.750   8.435  0.50 12.01           C
ATOM   1552  CG  ARG   184     -47.839   4.275   8.512  0.50 14.69           C
ATOM   1554  CD  ARG   184     -47.348   3.699   9.852  0.50 17.23           C
ATOM   1556  NE  ARG   184     -45.897   3.490   9.822  0.50 20.38           N
ATOM   1558  CZ  ARG   184     -45.023   3.988  10.695  0.50 19.61           C
ATOM   1560  NH1 ARG   184     -43.738   3.716  10.523  0.50 21.24           N
ATOM   1562  NH2 ARG   184     -45.415   4.720  11.740  0.50 16.19           N
ATOM   1564  C   ARG   184     -49.137   6.937   6.888  0.50 11.09           C
ATOM   1566  O   ARG   184     -49.974   6.363   6.185  0.50 10.52           O
ATOM   1568  N   GLN   185     -49.387   8.070   7.541  1.00 10.20           N
ATOM   1569  CA  GLN   185     -50.693   8.718   7.492  1.00 11.34           C
ATOM   1570  CB  GLN   185     -50.812   9.832   8.557  1.00 11.76           C
ATOM   1571  CG  GLN   185     -50.910   9.329   9.971  1.00 13.90           C
ATOM   1572  CD  GLN   185     -50.827  10.475  10.988  1.00 16.31           C
ATOM   1573  OE1 GLN   185     -51.146  11.627  10.670  1.00 24.88           O
ATOM   1574  NE2 GLN   185     -50.379  10.163  12.192  1.00 22.00           N
ATOM   1575  C   GLN   185     -51.069   9.294   6.120  1.00 10.79           C
ATOM   1576  O   GLN   185     -52.231   9.134   5.675  1.00 10.92           O
ATOM   1577  N   TYR   186     -50.095   9.901   5.436  1.00  9.48           N
ATOM   1578  CA  TYR   186     -50.375  10.550   4.165  1.00 10.97           C
ATOM   1579  CB  TYR   186     -49.386  11.701   3.929  1.00 11.73           C
ATOM   1580  CG  TYR   186     -49.831  12.983   4.689  1.00 11.89           C
ATOM   1581  CD1 TYR   186     -50.901  12.943   5.618  1.00 16.50           C
ATOM   1582  CE1 TYR   186     -51.319  14.116   6.323  1.00 16.69           C
ATOM   1583  CZ  TYR   186     -50.665  15.304   6.104  1.00 15.60           C
ATOM   1584  OH  TYR   186     -51.066  16.479   6.789  1.00 16.29           O
ATOM   1585  CE2 TYR   186     -49.579  15.336   5.236  1.00 15.60           C
ATOM   1586  CD2 TYR   186     -49.176  14.184   4.529  1.00 16.97           C
ATOM   1587  C   TYR   186     -50.456   9.510   3.024  1.00 10.48           C
ATOM   1588  O   TYR   186     -51.313   9.616   2.143  1.00 10.25           O
ATOM   1589  N   VAL   187     -49.660   8.448   3.114  1.00 10.81           N
ATOM   1590  CA  VAL   187     -49.813   7.308   2.195  1.00 11.07           C
ATOM   1591  CB  VAL   187     -48.750   6.195   2.457  1.00 12.17           C
ATOM   1592  CG1 VAL   187     -49.152   4.865   1.801  1.00 12.64           C
ATOM   1593  CG2 VAL   187     -47.381   6.636   1.948  1.00 12.10           C
ATOM   1594  C   VAL   187     -51.238   6.738   2.348  1.00 10.78           C
ATOM   1595  O   VAL   187     -51.902   6.468   1.365  1.00 11.55           O
ATOM   1596  N   ALA   188     -51.697   6.596   3.591  1.00 10.35           N
ATOM   1597  CA  ALA   188     -53.016   6.013   3.862  1.00 10.34           C
ATOM   1598  CB  ALA   188     -53.214   5.835   5.322  1.00 10.03           C
ATOM   1599  C   ALA   188     -54.109   6.923   3.278  1.00 10.52           C
ATOM   1600  O   ALA   188     -54.976   6.440   2.532  1.00 11.14           O
ATOM   1601  N   ILE   189     -54.067   8.223   3.582  1.00  9.18           N
ATOM   1602  CA  ILE   189     -55.064   9.134   3.022  1.00 10.18           C
ATOM   1603  CB  ILE   189     -54.855  10.573   3.534  1.00 10.61           C
ATOM   1604  CG1 ILE   189     -55.136  10.601   5.058  1.00 10.98           C
ATOM   1605  CD1 ILE   189     -54.723  11.960   5.716  1.00 13.83           C
ATOM   1606  CG2 ILE   189     -55.802  11.563   2.805  1.00 11.30           C
ATOM   1607  C   ILE   189     -55.041   9.113   1.474  1.00  9.70           C
ATOM   1608  O   ILE   189     -56.074   9.014   0.819  1.00  9.40           O
ATOM   1609  N   PHE   190     -53.857   9.209   0.889  1.00  9.58           N
ATOM   1610  CA  PHE   190     -53.805   9.360  -0.550  1.00  9.58           C
ATOM   1611  CB  PHE   190     -52.360   9.611  -0.993  1.00 10.23           C
ATOM   1612  CG  PHE   190     -52.226  10.008  -2.454  1.00  9.45           C
ATOM   1613  CD1 PHE   190     -52.917  11.128  -2.945  1.00  9.44           C
ATOM   1614  CE1 PHE   190     -52.804  11.478  -4.324  1.00  8.91           C
ATOM   1615  CZ  PHE   190     -51.991  10.716  -5.159  1.00  8.37           C
ATOM   1616  CE2 PHE   190     -51.307   9.595  -4.666  1.00 10.34           C
ATOM   1617  CD2 PHE   190     -51.432   9.256  -3.313  1.00  9.34           C
ATOM   1618  C   PHE   190     -54.341   8.115  -1.252  1.00 10.23           C
ATOM   1619  O   PHE   190     -55.013   8.227  -2.272  1.00 10.36           O
ATOM   1620  N   THR   191     -54.011   6.933  -0.728  1.00 10.49           N
ATOM   1621  CA  THR   191     -54.331   5.687  -1.425  1.00 11.39           C
ATOM   1622  CB  THR   191     -53.251   4.575  -1.187  1.00 11.16           C
ATOM   1623  OG1 THR   191     -53.129   4.320   0.203  1.00 13.70           O
ATOM   1624  CG2 THR   191     -51.894   5.021  -1.716  1.00 12.85           C
ATOM   1625  C   THR   191     -55.730   5.173  -1.057  1.00 11.49           C
ATOM   1626  O   THR   191     -56.413   4.630  -1.920  1.00 11.57           O
ATOM   1627  N   ARG   192     -56.142   5.361   0.207  1.00 11.47           N
ATOM   1628  CA  ARG   192     -57.377   4.780   0.764  1.00 12.54           C
ATOM   1629  CB  ARG   192     -57.043   3.762   1.863  1.00 13.38           C
ATOM   1630  CG  ARG   192     -56.218   2.608   1.352  1.00 19.78           C
ATOM   1631  CD  ARG   192     -55.838   1.648   2.458  1.00 27.83           C
ATOM   1632  NE  ARG   192     -54.833   2.186   3.390  1.00 31.16           N
ATOM   1633  CZ  ARG   192     -54.979   2.196   4.710  1.00 30.70           C
ATOM   1634  NH1 ARG   192     -56.099   1.741   5.268  1.00 34.65           N
ATOM   1635  NH2 ARG   192     -54.007   2.636   5.480  1.00 31.86           N
ATOM   1636  C   ARG   192     -58.394   5.793   1.313  1.00 11.41           C
ATOM   1637  O   ARG   192     -59.513   5.408   1.694  1.00 11.66           O
ATOM   1638  N   GLY   193     -57.999   7.067   1.407  1.00 10.15           N
ATOM   1639  CA  GLY   193     -58.897   8.124   1.894  1.00  9.23           C
ATOM   1640  C   GLY   193     -59.105   8.042   3.399  1.00 10.71           C
ATOM   1641  O   GLY   193     -58.465   7.238   4.070  1.00 11.66           O
ATOM   1642  N   ILE   194     -60.015   8.848   3.940  1.00 10.09           N
ATOM   1643  CA  ILE   194     -60.233   8.806   5.378  1.00 10.51           C
ATOM   1644  CB  ILE   194     -60.410  10.235   5.966  1.00  9.22           C
ATOM   1645  CG1 ILE   194     -61.635  10.937   5.378  1.00  9.15           C
ATOM   1646  CD1 ILE   194     -62.095  12.150   6.229  1.00 10.65           C
ATOM   1647  CG2 ILE   194     -59.149  11.099   5.736  1.00 10.26           C
ATOM   1648  C   ILE   194     -61.435   7.920   5.776  1.00 13.00           C
ATOM   1649  O   ILE   194     -61.677   7.686   6.986  1.00 11.91           O
ATOM   1650  N   MET   195     -62.162   7.427   4.770  0.80 13.74           N
ATOM   1652  CA  MET   195     -63.370   6.618   5.035  0.80 19.32           C
ATOM   1654  CB  MET   195     -64.062   6.224   3.735  0.80 17.64           C
ATOM   1656  CG  MET   195     -63.224   5.251   2.910  0.80 22.42           C
ATOM   1658  SD  MET   195     -64.053   4.614   1.255  0.80 35.82          SE
ATOM   1660  CE  MET   195     -65.779   4.059   1.995  0.80 28.19           C
ATOM   1662  C   MET   195     -63.024   5.348   5.798  0.80 17.09           C
ATOM   1664  O   MET   195     -61.945   4.789   5.620  0.80 16.40           O
ATOM   1666  N   ALA   196     -63.946   4.892   6.647  1.00 16.54           N
ATOM   1667  CA  ALA   196     -63.751   3.621   7.358  1.00 17.64           C
ATOM   1668  CB  ALA   196     -64.842   3.419   8.388  1.00 17.48           C
ATOM   1669  C   ALA   196     -63.706   2.435   6.397  1.00 18.42           C
ATOM   1670  O   ALA   196     -64.469   2.403   5.437  1.00 19.76           O
END
