
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  183 ( 1504),  selected  183 , name 2jj7_B
# Molecule2: number of CA atoms  192 ( 1477),  selected  192 , name T0454.pdb
# PARAMETERS: 2jj7_B.T0454.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    H     1_B      -       -           -
LGA    M     2_B      -       -           -
LGA    A     3_B      -       -           -
LGA    S     4_B      -       -           -
LGA    R     5_B      -       -           -
LGA    E     6_B      -       -           -
LGA    Q     7_B      D       5          1.507
LGA    T     8_B      C       6          0.788
LGA    M     9_B      R       7          0.829
LGA    E    10_B      S       8          1.072
LGA    N    11_B      R       9          0.669
LGA    I    12_B      L      10          0.449
LGA    L    13_B      M      11          0.693
LGA    K    14_B      E      12          0.875
LGA    A    15_B      V      13          0.818
LGA    A    16_B      A      14          0.790
LGA    K    17_B      T      15          0.783
LGA    K    18_B      E      16          0.780
LGA    K    19_B      L      17          0.891
LGA    F    20_B      F      18          0.887
LGA    G    21_B      A      19          0.841
LGA    E    22_B      Q      20          0.881
LGA    R    23_B      K      21          1.233
LGA    G    24_B      G      22          1.366
LGA    Y    25_B      F      23          1.540
LGA    E    26_B      Y      24          0.811
LGA    G    27_B      G      25          1.216
LGA    T    28_B      V      26          1.517
LGA    S    29_B      S      27          1.746
LGA    I    30_B      I      28          2.053
LGA    Q    31_B      R      29          2.023
LGA    E    32_B      E      30          1.890
LGA    I    33_B      L      31          2.155
LGA    A    34_B      A      32          2.191
LGA    K    35_B      Q      33          2.348
LGA    E    36_B      A      34          2.345
LGA    A    37_B      A      35          2.079
LGA    K    38_B      G      36          2.979
LGA    V    39_B      A      37          2.483
LGA    N    40_B      S      38          2.778
LGA    V    41_B      I      39          2.807
LGA    A    42_B      S      40          2.614
LGA    M    43_B      M      41          1.991
LGA    A    44_B      I      42          2.252
LGA    S    45_B      S      43          2.310
LGA    Y    46_B      Y      44          2.643
LGA    Y    47_B      H      45          2.269
LGA    F    48_B      F      46          2.098
LGA    N    49_B      G      47          2.940
LGA    G    50_B      G      48          2.192
LGA    K    51_B      K      49          1.674
LGA    E    52_B      E      50          1.708
LGA    N    53_B      G      51          1.495
LGA    L    54_B      L      52          0.991
LGA    Y    55_B      Y      53          1.058
LGA    Y    56_B      A      54          0.793
LGA    E    57_B      A      55          0.318
LGA    V    58_B      V      56          0.439
LGA    F    59_B      L      57          1.928
LGA    K    60_B      Q      58          2.309
LGA    K    61_B      E      59          2.867
LGA    Y    62_B      Q      60          3.637
LGA    G    63_B      F      61          2.856
LGA    L    64_B      A      62          1.778
LGA    A    65_B      C      63          5.037
LGA    N    66_B      F      64           #
LGA    E    67_B      G      65          1.229
LGA    L    68_B      Q      66          2.360
LGA    P    69_B      L      67          3.228
LGA    -       -      D      68           -
LGA    -       -      D      69           -
LGA    N    70_B      I      70          5.730
LGA    F    71_B      R      71          2.508
LGA    L    72_B      -       -           -
LGA    E    73_B      -       -           -
LGA    K    74_B      G      72          1.473
LGA    N    75_B      Q      73          0.747
LGA    Q    76_B      A      74          2.605
LGA    F    77_B      G      75          2.850
LGA    N    78_B      D      76          1.803
LGA    P    79_B      P      77          2.076
LGA    I    80_B      L      78          2.214
LGA    N    81_B      A      79          1.472
LGA    A    82_B      V      80          0.958
LGA    L    83_B      M      81          1.756
LGA    R    84_B      T      82          1.933
LGA    E    85_B      A      83          1.519
LGA    Y    86_B      Y      84          1.721
LGA    L    87_B      L      85          2.202
LGA    T    88_B      R      86          1.893
LGA    V    89_B      W      87          1.920
LGA    F    90_B      T      88          2.403
LGA    T    91_B      I      89          2.188
LGA    T    92_B      Q      90          1.516
LGA    H    93_B      R      91          1.926
LGA    I    94_B      H      92          2.299
LGA    K    95_B      R      93          1.933
LGA    E    96_B      N      94          1.931
LGA    N    97_B      N      95          1.835
LGA    P    98_B      P      96          2.053
LGA    E    99_B      Q      97          1.919
LGA    I   100_B      L      98          2.389
LGA    G   101_B      L      99          2.017
LGA    T   102_B      R     100          1.413
LGA    L   103_B      F     101          0.791
LGA    A   104_B      Y     102          1.607
LGA    Y   105_B      T     103          2.242
LGA    E   106_B      S     104          2.494
LGA    E   107_B      E     105          2.092
LGA    I   108_B      L     106          2.968
LGA    I   109_B      T     107          4.235
LGA    K   110_B      N     108          4.802
LGA    E   111_B      P     109          4.516
LGA    S   112_B      T     110          4.009
LGA    A   113_B      P     111          2.833
LGA    R   114_B      C     112          2.052
LGA    L   115_B      F     113          1.971
LGA    E   116_B      A     114          2.796
LGA    K   117_B      A     115          2.229
LGA    I   118_B      I     116          1.835
LGA    K   119_B      V     117          3.646
LGA    P   120_B      S     118           -
LGA    Y   121_B      -       -           -
LGA    F   122_B      -       -           -
LGA    I   123_B      -       -           -
LGA    G   124_B      P     119          3.250
LGA    S   125_B      A     120          4.007
LGA    F   126_B      I     121          3.465
LGA    E   127_B      A     122          2.866
LGA    Q   128_B      S     123          4.276
LGA    -       -      V     124           -
LGA    L   129_B      I     125          2.940
LGA    -       -      R     126           -
LGA    -       -      L     127           -
LGA    K   130_B      L     128          4.745
LGA    E   131_B      A     129          1.162
LGA    I   132_B      E     130           #
LGA    L   133_B      S     131           #
LGA    Q   134_B      I     132          3.380
LGA    E   135_B      E     133          3.628
LGA    G   136_B      A     134           -
LGA    E   137_B      -       -           -
LGA    K   138_B      G     135          4.478
LGA    Q   139_B      M     136          3.978
LGA    -       -      T     137           -
LGA    -       -      R     138           -
LGA    -       -      G     139           -
LGA    -       -      L     140           -
LGA    G   140_B      F     141          2.122
LGA    V   141_B      R     142           -
LGA    F   142_B      R     143           -
LGA    H   143_B      D     144           -
LGA    F   144_B      -       -           -
LGA    F   145_B      -       -           -
LGA    S   146_B      L     145           #
LGA    -       -      H     146           -
LGA    -       -      A     147           -
LGA    -       -      V     148           -
LGA    -       -      N     149           -
LGA    I   147_B      S     150          3.319
LGA    N   148_B      A     151           #
LGA    H   149_B      L     152           #
LGA    T   150_B      A     153          1.579
LGA    I   151_B      L     154           #
LGA    H   152_B      A     155           #
LGA    W   153_B      G     156          2.575
LGA    I   154_B      M     157          3.411
LGA    T   155_B      V     158           #
LGA    S   156_B      N     159          4.220
LGA    I   157_B      Y     160          1.781
LGA    V   158_B      F     161           #
LGA    L   159_B      F     162           #
LGA    F   160_B      L     163          2.874
LGA    P   161_B      S     164           -
LGA    K   162_B      -       -           -
LGA    F   163_B      T     165          4.252
LGA    K   164_B      L     166           -
LGA    K   165_B      A     167           -
LGA    -       -      T     168           -
LGA    F   166_B      E     169          4.859
LGA    -       -      G     170           -
LGA    -       -      L     171           -
LGA    -       -      T     172           -
LGA    -       -      S     173           -
LGA    I   167_B      H     174          1.439
LGA    D   168_B      S     175          3.530
LGA    -       -      P     176           -
LGA    -       -      D     177           -
LGA    -       -      Q     178           -
LGA    S   169_B      D     179          3.691
LGA    A   170_B      E     180          3.299
LGA    D   171_B      E     181          3.817
LGA    L   172_B      L     182          3.695
LGA    V   173_B      I     183          3.102
LGA    S   174_B      R     184          3.175
LGA    R   175_B      Q     185          3.160
LGA    I   176_B      Y     186          2.628
LGA    I   177_B      V     187          2.062
LGA    S   178_B      A     188          2.583
LGA    A   179_B      I     189          2.287
LGA    L   180_B      F     190          0.956
LGA    T   181_B      T     191          2.260
LGA    D   182_B      R     192          2.870
LGA    K   183_B      G     193          3.510
LGA    -       -      I     194           -
LGA    -       -      M     195           -
LGA    -       -      A     196           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  183  192    5.0    149    2.53    19.46     51.080     5.673

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.555621 * X  +  -0.830370 * Y  +  -0.042082 * Z  + -49.734886
  Y_new =   0.427041 * X  +  -0.328438 * Y  +   0.842475 * Z  +  43.946693
  Z_new =  -0.713388 * X  +   0.450126 * Y  +   0.537089 * Z  +  -7.872751 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.697536   -2.444057  [ DEG:    39.9659   -140.0341 ]
  Theta =   0.794321    2.347272  [ DEG:    45.5112    134.4888 ]
  Phi   =   2.486304   -0.655289  [ DEG:   142.4547    -37.5453 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2jj7_B                                        
REMARK     2: T0454.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2jj7_B.T0454.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  183  192   5.0  149   2.53   19.46  51.080
REMARK  ---------------------------------------------------------- 
MOLECULE 2jj7_B
HEADER    TRANSCRIPTION                           18-MAR-08   2JJ7              
TITLE     CRYSTAL STRUCTURE OF THE HLYIIR MUTANT PROTEIN WITH                   
TITLE    2 RESIDUES 170-185 SUBSTITUTED BY ALANINE                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HEMOLYSIN II REGULATORY PROTEIN;                           
COMPND   3 SYNONYM: HLYIIRDA, HEMOLYSIN II REGULATORY PROTEIN MUTANT;           
COMPND   4 CHAIN: A, B;                                                         
COMPND   5 FRAGMENT: RESIDUES 4-169, 186-201;                                   
COMPND   6 MUTATION: YES;                                                       
COMPND   7 ENGINEERED: YES;                                                     
COMPND   8 OTHER_DETAILS: RESIDUES 170-185 SUBSTITUTED BY ALANINE               
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   3 EXPRESSION_SYSTEM_STRAIN: B834;                                      
SOURCE   4 EXPRESSION_SYSTEM_VECTOR: PET28;                                     
SOURCE   5 EXPRESSION_SYSTEM_PLASMID: PET28A;                                   
SOURCE   6 ORGANISM_SCIENTIFIC: BACILLUS CEREUS;                                
SOURCE   7 STRAIN: B771                                                         
KEYWDS    DNA-BINDING PROTEIN, TRANSCRIPTION REGULATION,                        
KEYWDS   2 DNA-BINDING, TETR FAMILY, TRANSCRIPTION,                             
KEYWDS   3 TRANSCRIPTIONAL REGULATOR                                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    O.V.KOVALEVSKIY,A.A.ANTSON,A.S.SOLONIN                                
REVDAT   1   08-APR-08 2JJ7    0                                                
JRNL        AUTH   O.V.KOVALEVSKIY,A.A.ANTSON,A.S.SOLONIN                       
JRNL        TITL   CRYSTAL STRUCTURE OF THE HLYIIR MUTANT WITH REGION           
JRNL        TITL 2 170-185 SUBSTITUTED BY ALANINE RESIDUE                       
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.1  ANGSTROMS.                                          
DBREF  2JJ7 A    1     3  PDB    2JJ7     2JJ7             1      3             
DBREF  2JJ7 A    4   169  UNP    Q7X506   Q7X506_BACCE     4    169             
DBREF  2JJ7 A  170   170  PDB    2JJ7     2JJ7           170    170             
DBREF  2JJ7 A  171   186  UNP    Q7X506   Q7X506_BACCE   186    201             
DBREF  2JJ7 B    1     3  PDB    2JJ7     2JJ7             1      3             
DBREF  2JJ7 B    4   169  UNP    Q7X506   Q7X506_BACCE     4    169             
DBREF  2JJ7 B  170   170  PDB    2JJ7     2JJ7           170    170             
DBREF  2JJ7 B  171   186  UNP    Q7X506   Q7X506_BACCE   186    201             
SEQRES   1 A  186  HIS MET ALA SER ARG GLU GLN THR MET GLU ASN ILE LEU          
SEQRES   2 A  186  LYS ALA ALA LYS LYS LYS PHE GLY GLU ARG GLY TYR GLU          
SEQRES   3 A  186  GLY THR SER ILE GLN GLU ILE ALA LYS GLU ALA LYS VAL          
SEQRES   4 A  186  ASN VAL ALA MET ALA SER TYR TYR PHE ASN GLY LYS GLU          
SEQRES   5 A  186  ASN LEU TYR TYR GLU VAL PHE LYS LYS TYR GLY LEU ALA          
SEQRES   6 A  186  ASN GLU LEU PRO ASN PHE LEU GLU LYS ASN GLN PHE ASN          
SEQRES   7 A  186  PRO ILE ASN ALA LEU ARG GLU TYR LEU THR VAL PHE THR          
SEQRES   8 A  186  THR HIS ILE LYS GLU ASN PRO GLU ILE GLY THR LEU ALA          
SEQRES   9 A  186  TYR GLU GLU ILE ILE LYS GLU SER ALA ARG LEU GLU LYS          
SEQRES  10 A  186  ILE LYS PRO TYR PHE ILE GLY SER PHE GLU GLN LEU LYS          
SEQRES  11 A  186  GLU ILE LEU GLN GLU GLY GLU LYS GLN GLY VAL PHE HIS          
SEQRES  12 A  186  PHE PHE SER ILE ASN HIS THR ILE HIS TRP ILE THR SER          
SEQRES  13 A  186  ILE VAL LEU PHE PRO LYS PHE LYS LYS PHE ILE ASP SER          
SEQRES  14 A  186  ALA ASP LEU VAL SER ARG ILE ILE SER ALA LEU THR ASP          
SEQRES  15 A  186  LYS PRO ASN ILE                                              
SEQRES   1 B  186  HIS MET ALA SER ARG GLU GLN THR MET GLU ASN ILE LEU          
SEQRES   2 B  186  LYS ALA ALA LYS LYS LYS PHE GLY GLU ARG GLY TYR GLU          
SEQRES   3 B  186  GLY THR SER ILE GLN GLU ILE ALA LYS GLU ALA LYS VAL          
SEQRES   4 B  186  ASN VAL ALA MET ALA SER TYR TYR PHE ASN GLY LYS GLU          
SEQRES   5 B  186  ASN LEU TYR TYR GLU VAL PHE LYS LYS TYR GLY LEU ALA          
SEQRES   6 B  186  ASN GLU LEU PRO ASN PHE LEU GLU LYS ASN GLN PHE ASN          
SEQRES   7 B  186  PRO ILE ASN ALA LEU ARG GLU TYR LEU THR VAL PHE THR          
SEQRES   8 B  186  THR HIS ILE LYS GLU ASN PRO GLU ILE GLY THR LEU ALA          
SEQRES   9 B  186  TYR GLU GLU ILE ILE LYS GLU SER ALA ARG LEU GLU LYS          
SEQRES  10 B  186  ILE LYS PRO TYR PHE ILE GLY SER PHE GLU GLN LEU LYS          
SEQRES  11 B  186  GLU ILE LEU GLN GLU GLY GLU LYS GLN GLY VAL PHE HIS          
SEQRES  12 B  186  PHE PHE SER ILE ASN HIS THR ILE HIS TRP ILE THR SER          
SEQRES  13 B  186  ILE VAL LEU PHE PRO LYS PHE LYS LYS PHE ILE ASP SER          
SEQRES  14 B  186  ALA ASP LEU VAL SER ARG ILE ILE SER ALA LEU THR ASP          
SEQRES  15 B  186  LYS PRO ASN ILE                                              
FORMUL   3  HOH   *195(H2 O1)                                                   
CRYST1   66.831  120.414   55.178  90.00  90.00  90.00 P 21 21 2     8          
ATOM   1457  N   HIS B   1      -3.642  34.490   7.270  1.00 55.42           N  
ATOM   1458  CA  HIS B   1      -3.684  35.795   6.553  1.00 55.27           C  
ATOM   1459  C   HIS B   1      -5.038  36.004   5.840  1.00 54.46           C  
ATOM   1460  O   HIS B   1      -6.090  35.814   6.464  1.00 53.74           O  
ATOM   1461  CB  HIS B   1      -2.462  35.956   5.619  1.00 55.76           C  
ATOM   1462  CG  HIS B   1      -2.233  34.800   4.690  1.00 59.29           C  
ATOM   1463  ND1 HIS B   1      -1.714  33.593   5.109  1.00 64.47           N  
ATOM   1464  CD2 HIS B   1      -2.425  34.680   3.353  1.00 64.09           C  
ATOM   1465  CE1 HIS B   1      -1.614  32.774   4.077  1.00 66.33           C  
ATOM   1466  NE2 HIS B   1      -2.036  33.411   2.998  1.00 65.85           N  
ATOM   1467  N   MET B   2      -5.013  36.381   4.557  1.00 53.13           N  
ATOM   1468  CA  MET B   2      -6.228  36.757   3.810  1.00 51.55           C  
ATOM   1469  C   MET B   2      -7.159  35.584   3.520  1.00 49.34           C  
ATOM   1470  O   MET B   2      -6.709  34.473   3.248  1.00 49.80           O  
ATOM   1471  CB  MET B   2      -5.862  37.386   2.465  1.00 52.21           C  
ATOM   1472  CG  MET B   2      -5.329  38.796   2.497  1.00 53.00           C  
ATOM   1473  SD  MET B   2      -5.448  39.423   0.811  1.00 64.58           S  
ATOM   1474  CE  MET B   2      -6.992  40.319   0.832  1.00 58.01           C  
ATOM   1475  N   ALA B   3      -8.461  35.852   3.541  1.00 46.62           N  
ATOM   1476  CA  ALA B   3      -9.453  34.902   3.050  1.00 43.18           C  
ATOM   1477  C   ALA B   3      -9.190  34.554   1.574  1.00 41.41           C  
ATOM   1478  O   ALA B   3      -8.690  35.384   0.796  1.00 39.08           O  
ATOM   1479  CB  ALA B   3     -10.856  35.469   3.229  1.00 42.86           C  
ATOM   1480  N   SER B   4      -9.504  33.319   1.202  1.00 39.66           N  
ATOM   1481  CA  SER B   4      -9.425  32.903  -0.194  1.00 39.27           C  
ATOM   1482  C   SER B   4     -10.636  33.424  -0.945  1.00 39.25           C  
ATOM   1483  O   SER B   4     -11.686  33.678  -0.346  1.00 39.26           O  
ATOM   1484  CB  SER B   4      -9.420  31.386  -0.286  1.00 39.75           C  
ATOM   1485  OG  SER B   4     -10.721  30.900  -0.017  1.00 37.04           O  
ATOM   1486  N   ARG B   5     -10.500  33.562  -2.256  1.00 38.45           N  
ATOM   1487  CA  ARG B   5     -11.624  33.946  -3.118  1.00 40.66           C  
ATOM   1488  C   ARG B   5     -12.843  33.035  -2.892  1.00 40.74           C  
ATOM   1489  O   ARG B   5     -13.981  33.509  -2.832  1.00 41.53           O  
ATOM   1490  CB  ARG B   5     -11.197  33.902  -4.592  1.00 39.45           C  
ATOM   1491  CG  ARG B   5     -12.351  33.958  -5.580  1.00 43.68           C  
ATOM   1492  CD  ARG B   5     -11.911  33.569  -6.972  1.00 44.83           C  
ATOM   1493  NE  ARG B   5     -13.042  33.523  -7.893  1.00 47.22           N  
ATOM   1494  CZ  ARG B   5     -13.658  32.410  -8.294  1.00 50.98           C  
ATOM   1495  NH1 ARG B   5     -14.678  32.495  -9.137  1.00 48.64           N  
ATOM   1496  NH2 ARG B   5     -13.265  31.215  -7.858  1.00 45.87           N  
ATOM   1497  N   GLU B   6     -12.578  31.733  -2.759  1.00 40.88           N  
ATOM   1498  CA  GLU B   6     -13.610  30.705  -2.597  1.00 41.29           C  
ATOM   1499  C   GLU B   6     -14.396  30.913  -1.300  1.00 39.97           C  
ATOM   1500  O   GLU B   6     -15.619  30.876  -1.304  1.00 40.59           O  
ATOM   1501  CB  GLU B   6     -12.987  29.299  -2.646  1.00 41.19           C  
ATOM   1502  CG  GLU B   6     -12.367  28.886  -4.010  1.00 46.60           C  
ATOM   1503  CD  GLU B   6     -11.185  29.772  -4.484  1.00 55.65           C  
ATOM   1504  OE1 GLU B   6     -10.379  30.259  -3.655  1.00 46.78           O  
ATOM   1505  OE2 GLU B   6     -11.059  29.976  -5.713  1.00 62.19           O  
ATOM   1506  N   GLN B   7     -13.685  31.160  -0.203  1.00 39.58           N  
ATOM   1507  CA  GLN B   7     -14.309  31.477   1.084  1.00 38.99           C  
ATOM   1508  C   GLN B   7     -15.192  32.739   1.052  1.00 37.22           C  
ATOM   1509  O   GLN B   7     -16.290  32.758   1.608  1.00 35.88           O  
ATOM   1510  CB  GLN B   7     -13.245  31.587   2.186  1.00 39.54           C  
ATOM   1511  CG  GLN B   7     -13.778  31.940   3.594  1.00 41.85           C  
ATOM   1512  CD  GLN B   7     -14.750  30.899   4.157  1.00 46.94           C  
ATOM   1513  OE1 GLN B   7     -14.403  30.152   5.059  1.00 43.39           O  
ATOM   1514  NE2 GLN B   7     -15.970  30.853   3.621  1.00 49.28           N  
ATOM   1515  N   THR B   8     -14.715  33.789   0.403  1.00 36.72           N  
ATOM   1516  CA  THR B   8     -15.463  35.044   0.365  1.00 35.71           C  
ATOM   1517  C   THR B   8     -16.771  34.860  -0.404  1.00 36.01           C  
ATOM   1518  O   THR B   8     -17.828  35.329   0.040  1.00 34.46           O  
ATOM   1519  CB  THR B   8     -14.616  36.186  -0.228  1.00 36.07           C  
ATOM   1520  OG1 THR B   8     -13.423  36.330   0.547  1.00 30.84           O  
ATOM   1521  CG2 THR B   8     -15.379  37.505  -0.206  1.00 36.35           C  
ATOM   1522  N   MET B   9     -16.686  34.167  -1.544  1.00 34.44           N  
ATOM   1523  CA  MET B   9     -17.844  33.878  -2.368  1.00 36.34           C  
ATOM   1524  C   MET B   9     -18.831  32.981  -1.628  1.00 37.10           C  
ATOM   1525  O   MET B   9     -20.045  33.154  -1.752  1.00 37.03           O  
ATOM   1526  CB  MET B   9     -17.418  33.235  -3.686  1.00 36.52           C  
ATOM   1527  CG  MET B   9     -16.864  34.242  -4.679  1.00 41.14           C  
ATOM   1528  SD  MET B   9     -16.284  33.456  -6.178  1.00 45.55           S  
ATOM   1529  CE  MET B   9     -17.825  33.312  -7.094  1.00 45.58           C  
ATOM   1530  N   GLU B  10     -18.303  32.029  -0.864  1.00 36.63           N  
ATOM   1531  CA  GLU B  10     -19.127  31.190  -0.008  1.00 39.14           C  
ATOM   1532  C   GLU B  10     -19.837  32.003   1.077  1.00 38.98           C  
ATOM   1533  O   GLU B  10     -21.044  31.855   1.271  1.00 39.92           O  
ATOM   1534  CB  GLU B  10     -18.304  30.079   0.626  1.00 37.53           C  
ATOM   1535  CG  GLU B  10     -19.079  29.342   1.698  1.00 45.68           C  
ATOM   1536  CD  GLU B  10     -18.770  27.874   1.717  1.00 56.31           C  
ATOM   1537  OE1 GLU B  10     -17.605  27.519   2.011  1.00 62.55           O  
ATOM   1538  OE2 GLU B  10     -19.694  27.080   1.433  1.00 58.06           O  
ATOM   1539  N   ASN B  11     -19.086  32.854   1.772  1.00 38.11           N  
ATOM   1540  CA  ASN B  11     -19.678  33.799   2.707  1.00 39.27           C  
ATOM   1541  C   ASN B  11     -20.813  34.623   2.082  1.00 38.89           C  
ATOM   1542  O   ASN B  11     -21.862  34.807   2.709  1.00 38.10           O  
ATOM   1543  CB  ASN B  11     -18.608  34.714   3.316  1.00 37.80           C  
ATOM   1544  CG  ASN B  11     -17.735  33.987   4.319  1.00 43.44           C  
ATOM   1545  OD1 ASN B  11     -18.015  32.848   4.693  1.00 50.21           O  
ATOM   1546  ND2 ASN B  11     -16.670  34.640   4.762  1.00 49.38           N  
ATOM   1547  N   ILE B  12     -20.607  35.096   0.852  1.00 36.79           N  
ATOM   1548  CA  ILE B  12     -21.617  35.902   0.159  1.00 35.75           C  
ATOM   1549  C   ILE B  12     -22.865  35.083  -0.183  1.00 37.08           C  
ATOM   1550  O   ILE B  12     -23.983  35.592  -0.106  1.00 34.62           O  
ATOM   1551  CB  ILE B  12     -21.061  36.582  -1.114  1.00 36.49           C  
ATOM   1552  CG1 ILE B  12     -19.957  37.601  -0.763  1.00 32.96           C  
ATOM   1553  CG2 ILE B  12     -22.199  37.278  -1.915  1.00 38.98           C  
ATOM   1554  CD1 ILE B  12     -19.050  37.965  -1.956  1.00 27.73           C  
ATOM   1555  N   LEU B  13     -22.664  33.821  -0.561  1.00 36.70           N  
ATOM   1556  CA  LEU B  13     -23.772  32.931  -0.882  1.00 37.58           C  
ATOM   1557  C   LEU B  13     -24.579  32.524   0.350  1.00 37.12           C  
ATOM   1558  O   LEU B  13     -25.810  32.476   0.286  1.00 39.37           O  
ATOM   1559  CB  LEU B  13     -23.286  31.707  -1.656  1.00 36.77           C  
ATOM   1560  CG  LEU B  13     -22.900  32.006  -3.114  1.00 34.96           C  
ATOM   1561  CD1 LEU B  13     -22.311  30.779  -3.804  1.00 38.16           C  
ATOM   1562  CD2 LEU B  13     -24.083  32.559  -3.902  1.00 36.84           C  
ATOM   1563  N   LYS B  14     -23.891  32.232   1.456  1.00 37.01           N  
ATOM   1564  CA  LYS B  14     -24.548  31.998   2.748  1.00 37.27           C  
ATOM   1565  C   LYS B  14     -25.423  33.199   3.102  1.00 36.78           C  
ATOM   1566  O   LYS B  14     -26.574  33.037   3.510  1.00 34.72           O  
ATOM   1567  CB  LYS B  14     -23.522  31.757   3.868  1.00 37.44           C  
ATOM   1568  CG  LYS B  14     -22.937  30.358   3.902  1.00 40.89           C  
ATOM   1569  CD  LYS B  14     -21.865  30.196   4.971  1.00 50.56           C  
ATOM   1570  CE  LYS B  14     -21.161  28.844   4.810  1.00 54.63           C  
ATOM   1571  NZ  LYS B  14     -20.456  28.373   6.039  1.00 60.29           N  
ATOM   1572  N   ALA B  15     -24.865  34.398   2.931  1.00 34.80           N  
ATOM   1573  CA  ALA B  15     -25.571  35.654   3.219  1.00 36.75           C  
ATOM   1574  C   ALA B  15     -26.804  35.828   2.346  1.00 36.74           C  
ATOM   1575  O   ALA B  15     -27.872  36.190   2.835  1.00 38.83           O  
ATOM   1576  CB  ALA B  15     -24.638  36.854   3.051  1.00 33.59           C  
ATOM   1577  N   ALA B  16     -26.631  35.581   1.053  1.00 37.39           N  
ATOM   1578  CA  ALA B  16     -27.682  35.760   0.071  1.00 36.39           C  
ATOM   1579  C   ALA B  16     -28.827  34.756   0.314  1.00 36.55           C  
ATOM   1580  O   ALA B  16     -29.987  35.132   0.293  1.00 35.96           O  
ATOM   1581  CB  ALA B  16     -27.116  35.621  -1.311  1.00 34.72           C  
ATOM   1582  N   LYS B  17     -28.490  33.488   0.545  1.00 36.78           N  
ATOM   1583  CA  LYS B  17     -29.479  32.483   0.976  1.00 35.96           C  
ATOM   1584  C   LYS B  17     -30.301  33.005   2.157  1.00 37.47           C  
ATOM   1585  O   LYS B  17     -31.533  32.991   2.115  1.00 37.65           O  
ATOM   1586  CB  LYS B  17     -28.774  31.179   1.382  1.00 35.79           C  
ATOM   1587  CG  LYS B  17     -29.703  30.048   1.816  1.00 33.34           C  
ATOM   1588  CD  LYS B  17     -28.945  28.908   2.488  1.00 29.97           C  
ATOM   1589  CE  LYS B  17     -29.726  27.618   2.396  1.00 37.61           C  
ATOM   1590  NZ  LYS B  17     -29.103  26.482   3.165  1.00 38.21           N  
ATOM   1591  N   LYS B  18     -29.609  33.472   3.198  1.00 38.02           N  
ATOM   1592  CA  LYS B  18     -30.250  33.986   4.402  1.00 39.26           C  
ATOM   1593  C   LYS B  18     -31.185  35.161   4.107  1.00 39.32           C  
ATOM   1594  O   LYS B  18     -32.345  35.159   4.522  1.00 39.67           O  
ATOM   1595  CB  LYS B  18     -29.204  34.414   5.437  1.00 39.47           C  
ATOM   1596  CG  LYS B  18     -29.834  34.834   6.772  1.00 42.87           C  
ATOM   1597  CD  LYS B  18     -28.831  35.418   7.746  1.00 47.32           C  
ATOM   1598  CE  LYS B  18     -29.526  35.864   9.022  1.00 47.59           C  
ATOM   1599  NZ  LYS B  18     -28.569  36.026  10.153  1.00 54.73           N  
ATOM   1600  N   LYS B  19     -30.673  36.146   3.377  1.00 37.83           N  
ATOM   1601  CA  LYS B  19     -31.395  37.389   3.119  1.00 37.11           C  
ATOM   1602  C   LYS B  19     -32.550  37.236   2.135  1.00 37.61           C  
ATOM   1603  O   LYS B  19     -33.657  37.702   2.402  1.00 38.13           O  
ATOM   1604  CB  LYS B  19     -30.419  38.491   2.694  1.00 37.59           C  
ATOM   1605  CG  LYS B  19     -29.602  39.063   3.859  1.00 35.93           C  
ATOM   1606  CD  LYS B  19     -30.487  39.989   4.697  1.00 43.51           C  
ATOM   1607  CE  LYS B  19     -29.922  40.225   6.075  1.00 46.48           C  
ATOM   1608  NZ  LYS B  19     -30.924  40.889   6.950  1.00 49.94           N  
ATOM   1609  N   PHE B  20     -32.296  36.578   1.006  1.00 38.53           N  
ATOM   1610  CA  PHE B  20     -33.369  36.159   0.095  1.00 37.08           C  
ATOM   1611  C   PHE B  20     -34.464  35.379   0.815  1.00 36.34           C  
ATOM   1612  O   PHE B  20     -35.644  35.602   0.563  1.00 35.98           O  
ATOM   1613  CB  PHE B  20     -32.826  35.291  -1.038  1.00 37.90           C  
ATOM   1614  CG  PHE B  20     -32.181  36.067  -2.157  1.00 36.96           C  
ATOM   1615  CD1 PHE B  20     -32.840  37.138  -2.759  1.00 38.06           C  
ATOM   1616  CD2 PHE B  20     -30.931  35.692  -2.639  1.00 34.81           C  
ATOM   1617  CE1 PHE B  20     -32.239  37.856  -3.809  1.00 38.55           C  
ATOM   1618  CE2 PHE B  20     -30.325  36.397  -3.696  1.00 38.56           C  
ATOM   1619  CZ  PHE B  20     -30.978  37.477  -4.277  1.00 37.56           C  
ATOM   1620  N   GLY B  21     -34.073  34.458   1.694  1.00 36.45           N  
ATOM   1621  CA  GLY B  21     -35.038  33.642   2.451  1.00 37.54           C  
ATOM   1622  C   GLY B  21     -35.908  34.468   3.391  1.00 39.41           C  
ATOM   1623  O   GLY B  21     -37.081  34.162   3.599  1.00 39.61           O  
ATOM   1624  N   GLU B  22     -35.318  35.517   3.957  1.00 39.52           N  
ATOM   1625  CA  GLU B  22     -36.011  36.394   4.882  1.00 41.34           C  
ATOM   1626  C   GLU B  22     -36.998  37.336   4.201  1.00 41.34           C  
ATOM   1627  O   GLU B  22     -38.091  37.558   4.722  1.00 43.09           O  
ATOM   1628  CB  GLU B  22     -35.009  37.211   5.693  1.00 40.12           C  
ATOM   1629  CG  GLU B  22     -34.389  36.469   6.865  1.00 44.21           C  
ATOM   1630  CD  GLU B  22     -33.227  37.228   7.475  1.00 49.93           C  
ATOM   1631  OE1 GLU B  22     -32.993  38.390   7.069  1.00 46.78           O  
ATOM   1632  OE2 GLU B  22     -32.551  36.665   8.363  1.00 53.25           O  
ATOM   1633  N   ARG B  23     -36.624  37.876   3.046  1.00 41.36           N  
ATOM   1634  CA  ARG B  23     -37.367  38.994   2.453  1.00 42.83           C  
ATOM   1635  C   ARG B  23     -37.820  38.767   1.020  1.00 42.04           C  
ATOM   1636  O   ARG B  23     -38.439  39.646   0.417  1.00 43.13           O  
ATOM   1637  CB  ARG B  23     -36.537  40.280   2.517  1.00 42.64           C  
ATOM   1638  CG  ARG B  23     -36.673  41.041   3.816  1.00 50.31           C  
ATOM   1639  CD  ARG B  23     -35.989  42.386   3.718  1.00 65.00           C  
ATOM   1640  NE  ARG B  23     -35.989  43.100   4.993  1.00 73.82           N  
ATOM   1641  CZ  ARG B  23     -35.131  44.067   5.313  1.00 77.59           C  
ATOM   1642  NH1 ARG B  23     -34.185  44.447   4.458  1.00 76.95           N  
ATOM   1643  NH2 ARG B  23     -35.212  44.654   6.499  1.00 79.36           N  
ATOM   1644  N   GLY B  24     -37.510  37.600   0.469  1.00 40.53           N  
ATOM   1645  CA  GLY B  24     -37.909  37.291  -0.897  1.00 41.20           C  
ATOM   1646  C   GLY B  24     -36.953  37.911  -1.898  1.00 41.67           C  
ATOM   1647  O   GLY B  24     -36.086  38.701  -1.530  1.00 41.24           O  
ATOM   1648  N   TYR B  25     -37.110  37.548  -3.168  1.00 42.08           N  
ATOM   1649  CA  TYR B  25     -36.252  38.077  -4.234  1.00 41.21           C  
ATOM   1650  C   TYR B  25     -36.323  39.598  -4.351  1.00 41.67           C  
ATOM   1651  O   TYR B  25     -35.291  40.268  -4.410  1.00 40.50           O  
ATOM   1652  CB  TYR B  25     -36.588  37.436  -5.594  1.00 41.32           C  
ATOM   1653  CG  TYR B  25     -35.705  37.960  -6.698  1.00 38.75           C  
ATOM   1654  CD1 TYR B  25     -34.392  37.506  -6.838  1.00 38.80           C  
ATOM   1655  CD2 TYR B  25     -36.154  38.949  -7.567  1.00 37.28           C  
ATOM   1656  CE1 TYR B  25     -33.558  38.003  -7.826  1.00 34.37           C  
ATOM   1657  CE2 TYR B  25     -35.322  39.455  -8.564  1.00 38.56           C  
ATOM   1658  CZ  TYR B  25     -34.025  38.972  -8.684  1.00 33.88           C  
ATOM   1659  OH  TYR B  25     -33.196  39.460  -9.664  1.00 38.01           O  
ATOM   1660  N   GLU B  26     -37.547  40.127  -4.399  1.00 42.08           N  
ATOM   1661  CA  GLU B  26     -37.784  41.555  -4.631  1.00 42.98           C  
ATOM   1662  C   GLU B  26     -37.379  42.385  -3.425  1.00 42.16           C  
ATOM   1663  O   GLU B  26     -36.832  43.471  -3.576  1.00 42.83           O  
ATOM   1664  CB  GLU B  26     -39.258  41.830  -4.966  1.00 42.58           C  
ATOM   1665  CG  GLU B  26     -39.896  40.872  -5.987  1.00 48.81           C  
ATOM   1666  CD  GLU B  26     -39.455  41.132  -7.424  1.00 59.02           C  
ATOM   1667  OE1 GLU B  26     -38.891  42.214  -7.714  1.00 60.43           O  
ATOM   1668  OE2 GLU B  26     -39.682  40.242  -8.273  1.00 64.54           O  
ATOM   1669  N   GLY B  27     -37.644  41.866  -2.228  1.00 41.54           N  
ATOM   1670  CA  GLY B  27     -37.372  42.604  -0.996  1.00 42.89           C  
ATOM   1671  C   GLY B  27     -35.926  42.639  -0.535  1.00 42.80           C  
ATOM   1672  O   GLY B  27     -35.634  43.187   0.528  1.00 44.33           O  
ATOM   1673  N   THR B  28     -35.030  42.062  -1.333  1.00 42.50           N  
ATOM   1674  CA  THR B  28     -33.612  41.930  -0.987  1.00 43.09           C  
ATOM   1675  C   THR B  28     -32.747  42.693  -2.002  1.00 43.04           C  
ATOM   1676  O   THR B  28     -33.023  42.657  -3.208  1.00 43.26           O  
ATOM   1677  CB  THR B  28     -33.186  40.440  -1.010  1.00 42.49           C  
ATOM   1678  OG1 THR B  28     -34.122  39.650  -0.263  1.00 48.11           O  
ATOM   1679  CG2 THR B  28     -31.796  40.240  -0.428  1.00 43.25           C  
ATOM   1680  N   SER B  29     -31.701  43.365  -1.519  1.00 41.19           N  
ATOM   1681  CA  SER B  29     -30.759  44.050  -2.402  1.00 40.96           C  
ATOM   1682  C   SER B  29     -29.350  43.495  -2.217  1.00 40.76           C  
ATOM   1683  O   SER B  29     -29.061  42.851  -1.205  1.00 39.35           O  
ATOM   1684  CB  SER B  29     -30.751  45.544  -2.103  1.00 40.53           C  
ATOM   1685  OG  SER B  29     -30.186  45.767  -0.826  1.00 42.27           O  
ATOM   1686  N   ILE B  30     -28.466  43.765  -3.177  1.00 40.28           N  
ATOM   1687  CA  ILE B  30     -27.078  43.334  -3.047  1.00 41.93           C  
ATOM   1688  C   ILE B  30     -26.376  44.025  -1.858  1.00 41.63           C  
ATOM   1689  O   ILE B  30     -25.496  43.437  -1.215  1.00 42.64           O  
ATOM   1690  CB  ILE B  30     -26.288  43.422  -4.391  1.00 41.89           C  
ATOM   1691  CG1 ILE B  30     -24.912  42.754  -4.246  1.00 44.75           C  
ATOM   1692  CG2 ILE B  30     -26.195  44.867  -4.897  1.00 42.54           C  
ATOM   1693  CD1 ILE B  30     -24.482  41.940  -5.452  1.00 53.16           C  
ATOM   1694  N   GLN B  31     -26.817  45.238  -1.537  1.00 42.11           N  
ATOM   1695  CA  GLN B  31     -26.275  46.009  -0.410  1.00 42.69           C  
ATOM   1696  C   GLN B  31     -26.474  45.320   0.943  1.00 41.83           C  
ATOM   1697  O   GLN B  31     -25.542  45.232   1.743  1.00 42.85           O  
ATOM   1698  CB  GLN B  31     -26.865  47.431  -0.387  1.00 42.88           C  
ATOM   1699  CG  GLN B  31     -26.383  48.346  -1.522  1.00 43.87           C  
ATOM   1700  CD  GLN B  31     -26.948  47.971  -2.901  1.00 46.64           C  
ATOM   1701  OE1 GLN B  31     -27.915  47.214  -3.012  1.00 45.89           O  
ATOM   1702  NE2 GLN B  31     -26.333  48.506  -3.955  1.00 41.42           N  
ATOM   1703  N   GLU B  32     -27.684  44.830   1.189  1.00 39.44           N  
ATOM   1704  CA  GLU B  32     -27.989  44.071   2.402  1.00 41.19           C  
ATOM   1705  C   GLU B  32     -27.260  42.724   2.467  1.00 40.79           C  
ATOM   1706  O   GLU B  32     -26.855  42.281   3.549  1.00 41.32           O  
ATOM   1707  CB  GLU B  32     -29.500  43.821   2.508  1.00 39.61           C  
ATOM   1708  CG  GLU B  32     -30.333  45.069   2.453  1.00 47.35           C  
ATOM   1709  CD  GLU B  32     -31.785  44.784   2.101  1.00 60.11           C  
ATOM   1710  OE1 GLU B  32     -32.318  43.732   2.527  1.00 60.62           O  
ATOM   1711  OE2 GLU B  32     -32.396  45.620   1.399  1.00 64.15           O  
ATOM   1712  N   ILE B  33     -27.138  42.061   1.318  1.00 40.56           N  
ATOM   1713  CA  ILE B  33     -26.383  40.812   1.216  1.00 40.30           C  
ATOM   1714  C   ILE B  33     -24.898  41.044   1.525  1.00 40.81           C  
ATOM   1715  O   ILE B  33     -24.295  40.301   2.313  1.00 42.48           O  
ATOM   1716  CB  ILE B  33     -26.593  40.142  -0.166  1.00 40.29           C  
ATOM   1717  CG1 ILE B  33     -28.056  39.681  -0.298  1.00 39.15           C  
ATOM   1718  CG2 ILE B  33     -25.642  38.963  -0.359  1.00 39.26           C  
ATOM   1719  CD1 ILE B  33     -28.430  39.123  -1.680  1.00 41.95           C  
ATOM   1720  N   ALA B  34     -24.319  42.087   0.933  1.00 39.89           N  
ATOM   1721  CA  ALA B  34     -22.924  42.435   1.199  1.00 38.34           C  
ATOM   1722  C   ALA B  34     -22.720  42.705   2.674  1.00 39.89           C  
ATOM   1723  O   ALA B  34     -21.772  42.188   3.290  1.00 39.58           O  
ATOM   1724  CB  ALA B  34     -22.505  43.630   0.385  1.00 36.58           C  
ATOM   1725  N   LYS B  35     -23.629  43.503   3.237  1.00 40.54           N  
ATOM   1726  CA  LYS B  35     -23.588  43.869   4.649  1.00 42.51           C  
ATOM   1727  C   LYS B  35     -23.654  42.635   5.545  1.00 42.91           C  
ATOM   1728  O   LYS B  35     -22.888  42.519   6.508  1.00 43.13           O  
ATOM   1729  CB  LYS B  35     -24.720  44.851   4.980  1.00 41.77           C  
ATOM   1730  CG  LYS B  35     -24.711  45.357   6.408  1.00 45.78           C  
ATOM   1731  CD  LYS B  35     -25.786  46.410   6.634  1.00 48.27           C  
ATOM   1732  CE  LYS B  35     -25.433  47.281   7.829  1.00 57.06           C  
ATOM   1733  NZ  LYS B  35     -26.325  48.472   7.938  1.00 60.16           N  
ATOM   1734  N   GLU B  36     -24.556  41.709   5.214  1.00 43.14           N  
ATOM   1735  CA  GLU B  36     -24.698  40.460   5.970  1.00 42.63           C  
ATOM   1736  C   GLU B  36     -23.436  39.585   5.868  1.00 42.44           C  
ATOM   1737  O   GLU B  36     -22.997  39.004   6.866  1.00 41.84           O  
ATOM   1738  CB  GLU B  36     -25.959  39.701   5.529  1.00 42.87           C  
ATOM   1739  CG  GLU B  36     -26.102  38.275   6.103  1.00 43.93           C  
ATOM   1740  CD  GLU B  36     -26.282  38.215   7.617  1.00 45.53           C  
ATOM   1741  OE1 GLU B  36     -26.875  39.149   8.208  1.00 41.83           O  
ATOM   1742  OE2 GLU B  36     -25.841  37.207   8.214  1.00 41.43           O  
ATOM   1743  N   ALA B  37     -22.852  39.528   4.669  1.00 40.99           N  
ATOM   1744  CA  ALA B  37     -21.629  38.747   4.385  1.00 38.41           C  
ATOM   1745  C   ALA B  37     -20.357  39.378   4.962  1.00 37.76           C  
ATOM   1746  O   ALA B  37     -19.276  38.770   4.919  1.00 36.49           O  
ATOM   1747  CB  ALA B  37     -21.471  38.552   2.862  1.00 34.85           C  
ATOM   1748  N   LYS B  38     -20.497  40.595   5.480  1.00 38.21           N  
ATOM   1749  CA  LYS B  38     -19.386  41.390   5.996  1.00 39.53           C  
ATOM   1750  C   LYS B  38     -18.320  41.612   4.920  1.00 39.51           C  
ATOM   1751  O   LYS B  38     -17.117  41.504   5.180  1.00 40.18           O  
ATOM   1752  CB  LYS B  38     -18.798  40.767   7.275  1.00 40.15           C  
ATOM   1753  CG  LYS B  38     -19.779  40.744   8.452  1.00 43.18           C  
ATOM   1754  CD  LYS B  38     -19.069  40.808   9.813  1.00 52.55           C  
ATOM   1755  CE  LYS B  38     -18.942  39.432  10.468  1.00 57.07           C  
ATOM   1756  NZ  LYS B  38     -20.266  38.897  10.929  1.00 54.57           N  
ATOM   1757  N   VAL B  39     -18.781  41.894   3.700  1.00 38.82           N  
ATOM   1758  CA  VAL B  39     -17.886  42.236   2.592  1.00 38.26           C  
ATOM   1759  C   VAL B  39     -18.309  43.536   1.951  1.00 38.33           C  
ATOM   1760  O   VAL B  39     -19.470  43.948   2.029  1.00 39.15           O  
ATOM   1761  CB  VAL B  39     -17.806  41.162   1.470  1.00 37.96           C  
ATOM   1762  CG1 VAL B  39     -17.512  39.772   2.037  1.00 39.20           C  
ATOM   1763  CG2 VAL B  39     -19.077  41.162   0.629  1.00 38.02           C  
ATOM   1764  N   ASN B  40     -17.329  44.182   1.336  1.00 38.15           N  
ATOM   1765  C   ASN B  40     -18.513  45.151  -0.556  1.00 37.84           C  
ATOM   1766  O   ASN B  40     -18.368  44.162  -1.271  1.00 38.27           O  
ATOM   1767  CA  ASN B  40     -17.576  45.415   0.616  0.50 37.61           C  
ATOM   1768  CB  ASN B  40     -16.250  46.041   0.178  0.50 36.63           C  
ATOM   1769  CG  ASN B  40     -15.463  46.594   1.355  0.50 34.48           C  
ATOM   1770  OD1 ASN B  40     -14.290  46.272   1.554  0.50 23.50           O  
ATOM   1771  ND2 ASN B  40     -16.122  47.418   2.160  0.50 29.34           N  
ATOM   1777  N   VAL B  41     -19.513  46.019  -0.731  1.00 37.40           N  
ATOM   1778  CA  VAL B  41     -20.462  45.850  -1.851  1.00 37.52           C  
ATOM   1779  C   VAL B  41     -19.701  45.671  -3.179  1.00 36.46           C  
ATOM   1780  O   VAL B  41     -20.028  44.780  -3.956  1.00 35.65           O  
ATOM   1781  CB  VAL B  41     -21.552  46.988  -1.935  1.00 38.25           C  
ATOM   1782  CG1 VAL B  41     -22.335  46.918  -3.236  1.00 39.29           C  
ATOM   1783  CG2 VAL B  41     -22.548  46.894  -0.763  1.00 38.35           C  
ATOM   1784  N   ALA B  42     -18.656  46.480  -3.403  1.00 37.18           N  
ATOM   1785  CA  ALA B  42     -17.797  46.365  -4.593  1.00 37.04           C  
ATOM   1786  C   ALA B  42     -17.323  44.933  -4.861  1.00 37.81           C  
ATOM   1787  O   ALA B  42     -17.398  44.452  -5.987  1.00 38.68           O  
ATOM   1788  CB  ALA B  42     -16.601  47.306  -4.497  1.00 36.34           C  
ATOM   1789  N   MET B  43     -16.833  44.257  -3.830  1.00 38.43           N  
ATOM   1790  CA  MET B  43     -16.300  42.911  -4.003  1.00 39.67           C  
ATOM   1791  C   MET B  43     -17.428  41.937  -4.381  1.00 40.26           C  
ATOM   1792  O   MET B  43     -17.259  41.083  -5.255  1.00 41.34           O  
ATOM   1793  CB  MET B  43     -15.569  42.457  -2.734  1.00 39.71           C  
ATOM   1794  CG  MET B  43     -14.683  41.223  -2.923  1.00 43.03           C  
ATOM   1795  SD  MET B  43     -13.264  41.457  -4.039  1.00 54.21           S  
ATOM   1796  CE  MET B  43     -12.178  42.411  -3.037  1.00 43.23           C  
ATOM   1797  N   ALA B  44     -18.581  42.103  -3.738  1.00 39.65           N  
ATOM   1798  CA  ALA B  44     -19.749  41.272  -3.992  1.00 40.03           C  
ATOM   1799  C   ALA B  44     -20.222  41.431  -5.439  1.00 40.16           C  
ATOM   1800  O   ALA B  44     -20.627  40.457  -6.082  1.00 39.14           O  
ATOM   1801  CB  ALA B  44     -20.882  41.608  -2.995  1.00 38.62           C  
ATOM   1802  N   SER B  45     -20.149  42.662  -5.948  1.00 39.07           N  
ATOM   1803  CA  SER B  45     -20.594  42.945  -7.311  1.00 39.39           C  
ATOM   1804  C   SER B  45     -19.517  42.512  -8.316  1.00 36.96           C  
ATOM   1805  O   SER B  45     -19.832  42.077  -9.416  1.00 36.70           O  
ATOM   1806  CB  SER B  45     -20.994  44.419  -7.471  1.00 36.92           C  
ATOM   1807  OG  SER B  45     -19.936  45.274  -7.064  1.00 44.14           O  
ATOM   1808  N   TYR B  46     -18.250  42.595  -7.923  1.00 37.94           N  
ATOM   1809  CA  TYR B  46     -17.183  42.027  -8.748  1.00 38.05           C  
ATOM   1810  C   TYR B  46     -17.405  40.516  -8.977  1.00 38.50           C  
ATOM   1811  O   TYR B  46     -17.378  40.050 -10.109  1.00 39.50           O  
ATOM   1812  CB  TYR B  46     -15.794  42.313  -8.155  1.00 38.38           C  
ATOM   1813  CG  TYR B  46     -14.673  41.666  -8.931  1.00 39.10           C  
ATOM   1814  CD1 TYR B  46     -14.353  42.098 -10.226  1.00 35.91           C  
ATOM   1815  CD2 TYR B  46     -13.947  40.603  -8.390  1.00 41.50           C  
ATOM   1816  CE1 TYR B  46     -13.339  41.493 -10.958  1.00 37.15           C  
ATOM   1817  CE2 TYR B  46     -12.923  39.992  -9.115  1.00 39.25           C  
ATOM   1818  CZ  TYR B  46     -12.630  40.442 -10.392  1.00 41.92           C  
ATOM   1819  OH  TYR B  46     -11.622  39.846 -11.104  1.00 52.78           O  
ATOM   1820  N   TYR B  47     -17.664  39.766  -7.909  1.00 38.80           N  
ATOM   1821  CA  TYR B  47     -17.832  38.309  -8.009  1.00 39.12           C  
ATOM   1822  C   TYR B  47     -19.148  37.828  -8.648  1.00 39.63           C  
ATOM   1823  O   TYR B  47     -19.164  36.812  -9.337  1.00 38.56           O  
ATOM   1824  CB  TYR B  47     -17.657  37.646  -6.632  1.00 39.91           C  
ATOM   1825  CG  TYR B  47     -16.215  37.565  -6.144  1.00 40.86           C  
ATOM   1826  CD1 TYR B  47     -15.175  37.211  -7.015  1.00 44.26           C  
ATOM   1827  CD2 TYR B  47     -15.896  37.813  -4.804  1.00 40.24           C  
ATOM   1828  CE1 TYR B  47     -13.848  37.130  -6.571  1.00 44.90           C  
ATOM   1829  CE2 TYR B  47     -14.573  37.731  -4.344  1.00 40.25           C  
ATOM   1830  CZ  TYR B  47     -13.556  37.387  -5.236  1.00 42.37           C  
ATOM   1831  OH  TYR B  47     -12.256  37.300  -4.802  1.00 44.12           O  
ATOM   1832  N   PHE B  48     -20.245  38.535  -8.397  1.00 39.00           N  
ATOM   1833  CA  PHE B  48     -21.555  38.065  -8.844  1.00 41.89           C  
ATOM   1834  C   PHE B  48     -22.292  38.980  -9.820  1.00 43.69           C  
ATOM   1835  O   PHE B  48     -23.232  38.526 -10.478  1.00 45.51           O  
ATOM   1836  CB  PHE B  48     -22.451  37.693  -7.648  1.00 41.43           C  
ATOM   1837  CG  PHE B  48     -21.947  36.500  -6.881  1.00 41.51           C  
ATOM   1838  CD1 PHE B  48     -21.196  36.669  -5.719  1.00 39.69           C  
ATOM   1839  CD2 PHE B  48     -22.179  35.205  -7.352  1.00 39.29           C  
ATOM   1840  CE1 PHE B  48     -20.689  35.557  -5.020  1.00 39.98           C  
ATOM   1841  CE2 PHE B  48     -21.688  34.091  -6.665  1.00 42.47           C  
ATOM   1842  CZ  PHE B  48     -20.941  34.270  -5.494  1.00 36.96           C  
ATOM   1843  N   ASN B  49     -21.876  40.245  -9.922  1.00 43.82           N  
ATOM   1844  CA  ASN B  49     -22.510  41.180 -10.854  1.00 44.84           C  
ATOM   1845  C   ASN B  49     -24.034  41.145 -10.757  1.00 45.80           C  
ATOM   1846  O   ASN B  49     -24.708  40.762 -11.721  1.00 47.61           O  
ATOM   1847  CB  ASN B  49     -22.082  40.886 -12.305  1.00 45.23           C  
ATOM   1848  CG  ASN B  49     -20.739  41.520 -12.674  0.50 44.35           C  
ATOM   1849  OD1 ASN B  49     -19.750  40.819 -12.888  0.50 39.75           O  
ATOM   1850  ND2 ASN B  49     -20.707  42.850 -12.755  0.50 44.29           N  
ATOM   1851  N   GLY B  50     -24.571  41.491  -9.584  1.00 44.17           N  
ATOM   1852  CA  GLY B  50     -26.007  41.740  -9.439  1.00 40.67           C  
ATOM   1853  C   GLY B  50     -26.782  40.650  -8.734  1.00 40.50           C  
ATOM   1854  O   GLY B  50     -26.342  39.493  -8.664  1.00 39.36           O  
ATOM   1855  N   LYS B  51     -27.949  41.011  -8.210  1.00 37.94           N  
ATOM   1856  CA  LYS B  51     -28.701  40.070  -7.409  1.00 38.61           C  
ATOM   1857  C   LYS B  51     -29.314  38.926  -8.229  1.00 37.86           C  
ATOM   1858  O   LYS B  51     -29.501  37.844  -7.700  1.00 37.23           O  
ATOM   1859  CB  LYS B  51     -29.725  40.770  -6.503  1.00 38.31           C  
ATOM   1860  CG  LYS B  51     -30.985  41.262  -7.165  1.00 39.01           C  
ATOM   1861  CD  LYS B  51     -32.087  41.326  -6.125  1.00 37.48           C  
ATOM   1862  CE  LYS B  51     -33.319  41.947  -6.693  1.00 38.43           C  
ATOM   1863  NZ  LYS B  51     -34.304  42.204  -5.625  1.00 40.71           N  
ATOM   1864  N   GLU B  52     -29.589  39.161  -9.514  1.00 37.83           N  
ATOM   1865  CA  GLU B  52     -30.197  38.136 -10.367  1.00 38.43           C  
ATOM   1866  C   GLU B  52     -29.309  36.898 -10.445  1.00 37.48           C  
ATOM   1867  O   GLU B  52     -29.766  35.774 -10.222  1.00 36.53           O  
ATOM   1868  CB  GLU B  52     -30.507  38.694 -11.760  1.00 38.63           C  
ATOM   1869  CG  GLU B  52     -30.874  37.649 -12.822  1.00 45.56           C  
ATOM   1870  CD  GLU B  52     -32.331  37.212 -12.790  1.00 53.81           C  
ATOM   1871  OE1 GLU B  52     -32.692  36.427 -11.884  1.00 63.57           O  
ATOM   1872  OE2 GLU B  52     -33.109  37.628 -13.684  1.00 50.12           O  
ATOM   1873  N   ASN B  53     -28.032  37.118 -10.736  1.00 36.99           N  
ATOM   1874  CA  ASN B  53     -27.064  36.036 -10.849  1.00 36.70           C  
ATOM   1875  C   ASN B  53     -26.757  35.408  -9.488  1.00 35.99           C  
ATOM   1876  O   ASN B  53     -26.561  34.200  -9.377  1.00 35.58           O  
ATOM   1877  CB  ASN B  53     -25.782  36.545 -11.511  1.00 37.00           C  
ATOM   1878  CG  ASN B  53     -24.751  35.450 -11.680  1.00 41.66           C  
ATOM   1879  OD1 ASN B  53     -25.021  34.427 -12.319  1.00 48.61           O  
ATOM   1880  ND2 ASN B  53     -23.567  35.641 -11.086  1.00 40.02           N  
ATOM   1881  N   LEU B  54     -26.723  36.246  -8.458  1.00 34.57           N  
ATOM   1882  CA  LEU B  54     -26.521  35.807  -7.099  1.00 36.40           C  
ATOM   1883  C   LEU B  54     -27.646  34.852  -6.671  1.00 35.40           C  
ATOM   1884  O   LEU B  54     -27.393  33.821  -6.054  1.00 34.85           O  
ATOM   1885  CB  LEU B  54     -26.487  37.027  -6.187  1.00 37.88           C  
ATOM   1886  CG  LEU B  54     -25.984  36.937  -4.750  1.00 42.51           C  
ATOM   1887  CD1 LEU B  54     -24.695  36.150  -4.663  1.00 47.47           C  
ATOM   1888  CD2 LEU B  54     -25.780  38.344  -4.245  1.00 47.49           C  
ATOM   1889  N   TYR B  55     -28.879  35.213  -7.014  1.00 33.82           N  
ATOM   1890  CA  TYR B  55     -30.055  34.366  -6.810  1.00 31.74           C  
ATOM   1891  C   TYR B  55     -29.918  33.030  -7.522  1.00 30.45           C  
ATOM   1892  O   TYR B  55     -30.145  31.991  -6.917  1.00 30.76           O  
ATOM   1893  CB  TYR B  55     -31.280  35.091  -7.320  1.00 30.07           C  
ATOM   1894  CG  TYR B  55     -32.613  34.443  -7.009  1.00 31.76           C  
ATOM   1895  CD1 TYR B  55     -33.371  33.889  -8.029  1.00 30.58           C  
ATOM   1896  CD2 TYR B  55     -33.144  34.443  -5.717  1.00 28.11           C  
ATOM   1897  CE1 TYR B  55     -34.596  33.333  -7.790  1.00 29.98           C  
ATOM   1898  CE2 TYR B  55     -34.399  33.869  -5.459  1.00 27.47           C  
ATOM   1899  CZ  TYR B  55     -35.109  33.326  -6.517  1.00 23.94           C  
ATOM   1900  OH  TYR B  55     -36.342  32.775  -6.360  1.00 24.29           O  
ATOM   1901  N   TYR B  56     -29.534  33.068  -8.799  1.00 31.58           N  
ATOM   1902  C   TYR B  56     -28.239  30.984  -8.815  1.00 32.03           C  
ATOM   1903  O   TYR B  56     -28.449  29.785  -8.640  1.00 33.25           O  
ATOM   1904  CA  TYR B  56     -29.268  31.845  -9.555  0.50 32.52           C  
ATOM   1905  CB  TYR B  56     -28.766  32.146 -10.975  0.50 32.50           C  
ATOM   1906  CG  TYR B  56     -29.788  32.726 -11.943  0.50 34.11           C  
ATOM   1907  CD1 TYR B  56     -31.157  32.696 -11.677  0.50 31.21           C  
ATOM   1908  CD2 TYR B  56     -29.375  33.271 -13.151  0.50 32.11           C  
ATOM   1909  CE1 TYR B  56     -32.075  33.227 -12.586  0.50 27.17           C  
ATOM   1910  CE2 TYR B  56     -30.277  33.790 -14.054  0.50 29.37           C  
ATOM   1911  CZ  TYR B  56     -31.616  33.774 -13.776  0.50 28.77           C  
ATOM   1912  OH  TYR B  56     -32.486  34.306 -14.710  0.50 32.08           O  
ATOM   1922  N   GLU B  57     -27.149  31.601  -8.367  1.00 31.27           N  
ATOM   1923  CA  GLU B  57     -26.089  30.879  -7.676  1.00 30.97           C  
ATOM   1924  C   GLU B  57     -26.555  30.290  -6.335  1.00 30.90           C  
ATOM   1925  O   GLU B  57     -26.047  29.255  -5.901  1.00 30.01           O  
ATOM   1926  CB  GLU B  57     -24.863  31.774  -7.486  1.00 30.13           C  
ATOM   1927  CG  GLU B  57     -24.107  32.099  -8.767  1.00 34.88           C  
ATOM   1928  CD  GLU B  57     -23.614  30.862  -9.508  1.00 40.70           C  
ATOM   1929  OE1 GLU B  57     -23.133  29.909  -8.862  1.00 40.32           O  
ATOM   1930  OE2 GLU B  57     -23.718  30.845 -10.747  1.00 44.88           O  
ATOM   1931  N   VAL B  58     -27.528  30.946  -5.704  1.00 30.28           N  
ATOM   1932  CA  VAL B  58     -28.136  30.451  -4.465  1.00 30.35           C  
ATOM   1933  C   VAL B  58     -28.895  29.146  -4.716  1.00 29.64           C  
ATOM   1934  O   VAL B  58     -28.704  28.168  -3.990  1.00 30.17           O  
ATOM   1935  CB  VAL B  58     -29.055  31.503  -3.799  1.00 30.30           C  
ATOM   1936  CG1 VAL B  58     -29.993  30.849  -2.768  1.00 24.42           C  
ATOM   1937  CG2 VAL B  58     -28.201  32.559  -3.126  1.00 32.17           C  
ATOM   1938  N   PHE B  59     -29.723  29.128  -5.757  1.00 29.49           N  
ATOM   1939  CA  PHE B  59     -30.418  27.899  -6.174  1.00 30.13           C  
ATOM   1940  C   PHE B  59     -29.444  26.780  -6.567  1.00 30.35           C  
ATOM   1941  O   PHE B  59     -29.650  25.627  -6.211  1.00 30.44           O  
ATOM   1942  CB  PHE B  59     -31.435  28.195  -7.280  1.00 28.99           C  
ATOM   1943  CG  PHE B  59     -32.836  28.410  -6.750  1.00 27.12           C  
ATOM   1944  CD1 PHE B  59     -33.669  27.322  -6.510  1.00 21.67           C  
ATOM   1945  CD2 PHE B  59     -33.307  29.694  -6.474  1.00 25.54           C  
ATOM   1946  CE1 PHE B  59     -34.988  27.505  -5.995  1.00 23.17           C  
ATOM   1947  CE2 PHE B  59     -34.603  29.893  -5.972  1.00 20.70           C  
ATOM   1948  CZ  PHE B  59     -35.442  28.787  -5.730  1.00 24.77           C  
ATOM   1949  N   LYS B  60     -28.371  27.151  -7.264  1.00 28.12           N  
ATOM   1950  CA  LYS B  60     -27.325  26.217  -7.667  1.00 29.27           C  
ATOM   1951  C   LYS B  60     -26.597  25.620  -6.451  1.00 29.67           C  
ATOM   1952  O   LYS B  60     -26.419  24.414  -6.391  1.00 31.09           O  
ATOM   1953  CB  LYS B  60     -26.326  26.924  -8.593  1.00 26.70           C  
ATOM   1954  CG  LYS B  60     -25.314  26.028  -9.266  1.00 29.42           C  
ATOM   1955  CD  LYS B  60     -24.321  26.874 -10.040  1.00 36.90           C  
ATOM   1956  CE  LYS B  60     -23.453  26.032 -10.962  1.00 43.68           C  
ATOM   1957  NZ  LYS B  60     -22.372  26.846 -11.590  1.00 44.57           N  
ATOM   1958  N   LYS B  61     -26.184  26.461  -5.499  1.00 29.49           N  
ATOM   1959  CA  LYS B  61     -25.455  25.989  -4.321  1.00 28.77           C  
ATOM   1960  C   LYS B  61     -26.337  25.212  -3.349  1.00 29.72           C  
ATOM   1961  O   LYS B  61     -25.915  24.178  -2.833  1.00 30.17           O  
ATOM   1962  CB  LYS B  61     -24.764  27.137  -3.567  1.00 27.82           C  
ATOM   1963  CG  LYS B  61     -23.810  26.618  -2.488  1.00 30.18           C  
ATOM   1964  CD  LYS B  61     -22.933  27.677  -1.892  1.00 38.12           C  
ATOM   1965  CE  LYS B  61     -21.982  27.081  -0.855  1.00 42.62           C  
ATOM   1966  NZ  LYS B  61     -20.959  26.148  -1.425  1.00 45.61           N  
ATOM   1967  N   TYR B  62     -27.554  25.701  -3.103  1.00 27.83           N  
ATOM   1968  CA  TYR B  62     -28.389  25.149  -2.032  1.00 28.21           C  
ATOM   1969  C   TYR B  62     -29.590  24.347  -2.511  1.00 29.81           C  
ATOM   1970  O   TYR B  62     -30.336  23.795  -1.697  1.00 29.87           O  
ATOM   1971  CB  TYR B  62     -28.816  26.244  -1.041  1.00 26.95           C  
ATOM   1972  CG  TYR B  62     -27.646  26.977  -0.432  1.00 29.07           C  
ATOM   1973  CD1 TYR B  62     -26.794  26.335   0.476  1.00 29.01           C  
ATOM   1974  CD2 TYR B  62     -27.374  28.315  -0.765  1.00 25.34           C  
ATOM   1975  CE1 TYR B  62     -25.693  27.007   1.042  1.00 27.92           C  
ATOM   1976  CE2 TYR B  62     -26.274  28.993  -0.203  1.00 28.67           C  
ATOM   1977  CZ  TYR B  62     -25.438  28.331   0.698  1.00 29.32           C  
ATOM   1978  OH  TYR B  62     -24.350  28.982   1.258  1.00 24.14           O  
ATOM   1979  N   GLY B  63     -29.766  24.248  -3.829  1.00 31.66           N  
ATOM   1980  CA  GLY B  63     -30.809  23.386  -4.375  1.00 31.78           C  
ATOM   1981  C   GLY B  63     -30.276  21.968  -4.524  1.00 33.54           C  
ATOM   1982  O   GLY B  63     -29.289  21.589  -3.882  1.00 33.58           O  
ATOM   1983  N   LEU B  64     -30.911  21.186  -5.388  1.00 32.13           N  
ATOM   1984  CA  LEU B  64     -30.463  19.829  -5.666  1.00 34.59           C  
ATOM   1985  C   LEU B  64     -29.095  19.784  -6.369  1.00 36.26           C  
ATOM   1986  O   LEU B  64     -28.841  20.545  -7.307  1.00 35.58           O  
ATOM   1987  CB  LEU B  64     -31.536  19.100  -6.486  1.00 35.23           C  
ATOM   1988  CG  LEU B  64     -32.931  19.183  -5.841  1.00 35.89           C  
ATOM   1989  CD1 LEU B  64     -34.021  18.795  -6.827  1.00 33.30           C  
ATOM   1990  CD2 LEU B  64     -33.008  18.346  -4.558  1.00 37.78           C  
ATOM   1991  N   ALA B  65     -28.218  18.895  -5.905  1.00 37.50           N  
ATOM   1992  CA  ALA B  65     -26.910  18.701  -6.524  1.00 39.68           C  
ATOM   1993  C   ALA B  65     -27.030  18.212  -7.971  1.00 41.40           C  
ATOM   1994  O   ALA B  65     -26.190  18.532  -8.824  1.00 40.69           O  
ATOM   1995  CB  ALA B  65     -26.080  17.731  -5.709  1.00 40.73           C  
ATOM   1996  N   ASN B  66     -28.081  17.437  -8.231  1.00 41.67           N  
ATOM   1997  CA  ASN B  66     -28.351  16.841  -9.541  1.00 42.88           C  
ATOM   1998  C   ASN B  66     -29.846  16.675  -9.709  1.00 42.26           C  
ATOM   1999  O   ASN B  66     -30.571  16.514  -8.725  1.00 41.74           O  
ATOM   2000  CB  ASN B  66     -27.738  15.446  -9.642  1.00 43.77           C  
ATOM   2001  CG  ASN B  66     -26.339  15.374  -9.064  1.00 47.97           C  
ATOM   2002  OD1 ASN B  66     -25.381  15.852  -9.676  1.00 44.44           O  
ATOM   2003  ND2 ASN B  66     -26.216  14.777  -7.873  1.00 51.75           N  
ATOM   2004  N   GLU B  67     -30.307  16.694 -10.952  1.00 42.81           N  
ATOM   2005  CA  GLU B  67     -31.687  16.328 -11.253  1.00 44.33           C  
ATOM   2006  C   GLU B  67     -31.976  14.967 -10.621  1.00 43.54           C  
ATOM   2007  O   GLU B  67     -31.133  14.069 -10.651  1.00 43.68           O  
ATOM   2008  CB  GLU B  67     -31.927  16.312 -12.757  1.00 43.76           C  
ATOM   2009  CG  GLU B  67     -31.567  17.644 -13.411  1.00 50.24           C  
ATOM   2010  CD  GLU B  67     -32.208  17.840 -14.770  1.00 62.41           C  
ATOM   2011  OE1 GLU B  67     -32.433  16.830 -15.484  1.00 65.68           O  
ATOM   2012  OE2 GLU B  67     -32.485  19.014 -15.117  1.00 60.06           O  
ATOM   2013  N   LEU B  68     -33.137  14.832  -9.995  1.00 42.35           N  
ATOM   2014  CA  LEU B  68     -33.446  13.588  -9.302  1.00 40.98           C  
ATOM   2015  C   LEU B  68     -33.828  12.513 -10.310  1.00 40.16           C  
ATOM   2016  O   LEU B  68     -34.355  12.835 -11.376  1.00 39.85           O  
ATOM   2017  CB  LEU B  68     -34.546  13.809  -8.256  1.00 41.01           C  
ATOM   2018  CG  LEU B  68     -34.182  14.799  -7.134  1.00 39.75           C  
ATOM   2019  CD1 LEU B  68     -35.394  15.060  -6.292  1.00 38.90           C  
ATOM   2020  CD2 LEU B  68     -33.015  14.284  -6.274  1.00 39.95           C  
ATOM   2021  N   PRO B  69     -33.561  11.233  -9.982  1.00 39.40           N  
ATOM   2022  CA  PRO B  69     -34.042  10.154 -10.858  1.00 38.23           C  
ATOM   2023  C   PRO B  69     -35.567  10.166 -10.885  1.00 35.37           C  
ATOM   2024  O   PRO B  69     -36.174  10.733  -9.987  1.00 34.24           O  
ATOM   2025  CB  PRO B  69     -33.548   8.878 -10.157  1.00 38.99           C  
ATOM   2026  CG  PRO B  69     -33.384   9.274  -8.703  1.00 40.82           C  
ATOM   2027  CD  PRO B  69     -32.921  10.712  -8.755  1.00 39.64           C  
ATOM   2028  N   ASN B  70     -36.170   9.573 -11.915  1.00 32.09           N  
ATOM   2029  CA  ASN B  70     -37.614   9.438 -11.965  1.00 31.91           C  
ATOM   2030  C   ASN B  70     -38.031   8.465 -10.876  1.00 31.22           C  
ATOM   2031  O   ASN B  70     -37.701   7.281 -10.955  1.00 31.45           O  
ATOM   2032  CB  ASN B  70     -38.050   8.913 -13.337  1.00 30.84           C  
ATOM   2033  CG  ASN B  70     -39.551   8.946 -13.516  1.00 32.09           C  
ATOM   2034  OD1 ASN B  70     -40.230   7.930 -13.349  1.00 33.63           O  
ATOM   2035  ND2 ASN B  70     -40.086  10.123 -13.842  1.00 29.22           N  
ATOM   2036  N   PHE B  71     -38.735   8.951  -9.856  1.00 30.97           N  
ATOM   2037  CA  PHE B  71     -39.089   8.087  -8.725  1.00 31.78           C  
ATOM   2038  C   PHE B  71     -40.021   6.920  -9.038  1.00 32.35           C  
ATOM   2039  O   PHE B  71     -39.919   5.875  -8.384  1.00 32.89           O  
ATOM   2040  CB  PHE B  71     -39.605   8.884  -7.530  1.00 32.99           C  
ATOM   2041  CG  PHE B  71     -38.563   9.775  -6.910  1.00 32.50           C  
ATOM   2042  CD1 PHE B  71     -37.448   9.233  -6.282  1.00 29.59           C  
ATOM   2043  CD2 PHE B  71     -38.688  11.155  -6.968  1.00 29.41           C  
ATOM   2044  CE1 PHE B  71     -36.465  10.069  -5.716  1.00 35.14           C  
ATOM   2045  CE2 PHE B  71     -37.707  11.996  -6.400  1.00 30.98           C  
ATOM   2046  CZ  PHE B  71     -36.599  11.440  -5.780  1.00 33.45           C  
ATOM   2047  N   LEU B  72     -40.914   7.085 -10.023  1.00 31.86           N  
ATOM   2048  CA  LEU B  72     -41.809   5.997 -10.451  1.00 29.72           C  
ATOM   2049  C   LEU B  72     -41.035   4.844 -11.072  1.00 29.32           C  
ATOM   2050  O   LEU B  72     -41.274   3.681 -10.746  1.00 30.86           O  
ATOM   2051  CB  LEU B  72     -42.885   6.488 -11.436  1.00 28.65           C  
ATOM   2052  CG  LEU B  72     -44.196   7.099 -10.947  1.00 28.44           C  
ATOM   2053  CD1 LEU B  72     -45.064   7.511 -12.130  1.00 28.93           C  
ATOM   2054  CD2 LEU B  72     -44.960   6.127 -10.058  1.00 26.88           C  
ATOM   2055  N   GLU B  73     -40.125   5.160 -11.981  1.00 28.94           N  
ATOM   2056  CA  GLU B  73     -39.264   4.140 -12.574  1.00 31.79           C  
ATOM   2057  C   GLU B  73     -38.319   3.516 -11.540  1.00 31.85           C  
ATOM   2058  O   GLU B  73     -38.191   2.295 -11.479  1.00 31.69           O  
ATOM   2059  CB  GLU B  73     -38.460   4.703 -13.749  1.00 31.62           C  
ATOM   2060  CG  GLU B  73     -39.332   5.150 -14.912  1.00 39.98           C  
ATOM   2061  CD  GLU B  73     -38.539   5.733 -16.068  1.00 51.46           C  
ATOM   2062  OE1 GLU B  73     -37.580   6.505 -15.835  1.00 48.13           O  
ATOM   2063  OE2 GLU B  73     -38.891   5.418 -17.223  1.00 61.26           O  
ATOM   2064  N   LYS B  74     -37.672   4.345 -10.723  1.00 31.39           N  
ATOM   2065  CA  LYS B  74     -36.796   3.823  -9.672  1.00 32.23           C  
ATOM   2066  C   LYS B  74     -37.546   2.851  -8.725  1.00 33.10           C  
ATOM   2067  O   LYS B  74     -36.975   1.880  -8.220  1.00 31.00           O  
ATOM   2068  CB  LYS B  74     -36.150   4.968  -8.887  1.00 31.45           C  
ATOM   2069  CG  LYS B  74     -35.122   4.479  -7.897  1.00 34.37           C  
ATOM   2070  CD  LYS B  74     -34.483   5.605  -7.104  1.00 33.31           C  
ATOM   2071  CE  LYS B  74     -33.700   5.002  -5.956  1.00 33.45           C  
ATOM   2072  NZ  LYS B  74     -32.971   6.019  -5.180  1.00 41.75           N  
ATOM   2073  N   ASN B  75     -38.834   3.100  -8.512  1.00 33.84           N  
ATOM   2074  CA  ASN B  75     -39.613   2.254  -7.639  1.00 34.82           C  
ATOM   2075  C   ASN B  75     -40.491   1.265  -8.394  1.00 36.23           C  
ATOM   2076  O   ASN B  75     -41.454   0.725  -7.837  1.00 37.22           O  
ATOM   2077  CB  ASN B  75     -40.422   3.127  -6.688  1.00 33.80           C  
ATOM   2078  CG  ASN B  75     -39.537   3.808  -5.686  1.00 38.94           C  
ATOM   2079  OD1 ASN B  75     -39.130   3.192  -4.701  1.00 41.66           O  
ATOM   2080  ND2 ASN B  75     -39.158   5.062  -5.967  1.00 36.31           N  
ATOM   2081  N   GLN B  76     -40.146   1.039  -9.660  1.00 35.67           N  
ATOM   2082  CA  GLN B  76     -40.856   0.097 -10.528  1.00 35.78           C  
ATOM   2083  C   GLN B  76     -42.380   0.270 -10.502  1.00 35.83           C  
ATOM   2084  O   GLN B  76     -43.134  -0.705 -10.428  1.00 35.20           O  
ATOM   2085  CB  GLN B  76     -40.438  -1.332 -10.203  1.00 34.96           C  
ATOM   2086  CG  GLN B  76     -38.990  -1.608 -10.585  1.00 39.54           C  
ATOM   2087  CD  GLN B  76     -38.522  -2.977 -10.156  1.00 48.57           C  
ATOM   2088  OE1 GLN B  76     -38.732  -3.384  -9.012  1.00 54.76           O  
ATOM   2089  NE2 GLN B  76     -37.870  -3.692 -11.068  1.00 46.19           N  
ATOM   2090  N   PHE B  77     -42.797   1.536 -10.540  1.00 36.89           N  
ATOM   2091  CA  PHE B  77     -44.200   1.953 -10.636  1.00 36.40           C  
ATOM   2092  C   PHE B  77     -45.058   1.474  -9.478  1.00 36.39           C  
ATOM   2093  O   PHE B  77     -46.245   1.223  -9.647  1.00 36.88           O  
ATOM   2094  CB  PHE B  77     -44.777   1.593 -12.016  1.00 37.47           C  
ATOM   2095  CG  PHE B  77     -44.047   2.262 -13.146  1.00 36.21           C  
ATOM   2096  CD1 PHE B  77     -44.456   3.505 -13.607  1.00 37.12           C  
ATOM   2097  CD2 PHE B  77     -42.915   1.677 -13.710  1.00 37.49           C  
ATOM   2098  CE1 PHE B  77     -43.768   4.139 -14.630  1.00 34.53           C  
ATOM   2099  CE2 PHE B  77     -42.215   2.305 -14.736  1.00 33.62           C  
ATOM   2100  CZ  PHE B  77     -42.644   3.533 -15.197  1.00 34.59           C  
ATOM   2101  N   ASN B  78     -44.416   1.332  -8.315  1.00 36.53           N  
ATOM   2102  CA  ASN B  78     -45.076   1.276  -7.012  1.00 38.12           C  
ATOM   2103  C   ASN B  78     -45.276   2.732  -6.571  1.00 38.11           C  
ATOM   2104  O   ASN B  78     -44.319   3.388  -6.167  1.00 39.50           O  
ATOM   2105  CB  ASN B  78     -44.181   0.528  -6.011  1.00 38.08           C  
ATOM   2106  CG  ASN B  78     -44.870   0.265  -4.665  1.00 43.97           C  
ATOM   2107  OD1 ASN B  78     -45.638   1.084  -4.167  1.00 39.11           O  
ATOM   2108  ND2 ASN B  78     -44.569  -0.884  -4.064  1.00 43.73           N  
ATOM   2109  N   PRO B  79     -46.517   3.255  -6.683  1.00 38.78           N  
ATOM   2110  CA  PRO B  79     -46.820   4.660  -6.399  1.00 38.36           C  
ATOM   2111  C   PRO B  79     -46.638   5.092  -4.951  1.00 38.98           C  
ATOM   2112  O   PRO B  79     -46.195   6.217  -4.712  1.00 39.23           O  
ATOM   2113  CB  PRO B  79     -48.298   4.778  -6.783  1.00 39.19           C  
ATOM   2114  CG  PRO B  79     -48.513   3.679  -7.748  1.00 36.22           C  
ATOM   2115  CD  PRO B  79     -47.689   2.568  -7.256  1.00 37.33           C  
ATOM   2116  N   ILE B  80     -46.989   4.233  -3.992  1.00 37.84           N  
ATOM   2117  CA  ILE B  80     -46.754   4.558  -2.582  1.00 38.02           C  
ATOM   2118  C   ILE B  80     -45.244   4.698  -2.298  1.00 38.09           C  
ATOM   2119  O   ILE B  80     -44.813   5.681  -1.712  1.00 39.20           O  
ATOM   2120  CB  ILE B  80     -47.423   3.533  -1.626  1.00 38.91           C  
ATOM   2121  CG1 ILE B  80     -48.955   3.657  -1.716  1.00 37.42           C  
ATOM   2122  CG2 ILE B  80     -46.932   3.722  -0.174  1.00 36.17           C  
ATOM   2123  CD1 ILE B  80     -49.738   2.431  -1.145  1.00 31.08           C  
ATOM   2124  N   ASN B  81     -44.441   3.729  -2.737  1.00 38.18           N  
ATOM   2125  CA  ASN B  81     -42.997   3.818  -2.551  1.00 37.36           C  
ATOM   2126  C   ASN B  81     -42.356   4.978  -3.300  1.00 37.04           C  
ATOM   2127  O   ASN B  81     -41.469   5.656  -2.764  1.00 38.45           O  
ATOM   2128  CB  ASN B  81     -42.319   2.501  -2.916  1.00 38.28           C  
ATOM   2129  CG  ASN B  81     -42.517   1.429  -1.852  1.00 38.30           C  
ATOM   2130  OD1 ASN B  81     -43.264   1.609  -0.886  1.00 44.76           O  
ATOM   2131  ND2 ASN B  81     -41.849   0.312  -2.033  1.00 41.37           N  
ATOM   2132  N   ALA B  82     -42.790   5.207  -4.537  1.00 35.58           N  
ATOM   2133  CA  ALA B  82     -42.315   6.369  -5.285  1.00 36.22           C  
ATOM   2134  C   ALA B  82     -42.611   7.640  -4.501  1.00 37.91           C  
ATOM   2135  O   ALA B  82     -41.729   8.475  -4.317  1.00 39.35           O  
ATOM   2136  CB  ALA B  82     -42.955   6.432  -6.655  1.00 36.52           C  
ATOM   2137  N   LEU B  83     -43.841   7.779  -4.016  1.00 37.87           N  
ATOM   2138  CA  LEU B  83     -44.210   8.978  -3.268  1.00 39.79           C  
ATOM   2139  C   LEU B  83     -43.441   9.121  -1.941  1.00 40.40           C  
ATOM   2140  O   LEU B  83     -43.041  10.238  -1.560  1.00 41.22           O  
ATOM   2141  CB  LEU B  83     -45.721   9.033  -3.031  1.00 39.74           C  
ATOM   2142  CG  LEU B  83     -46.256  10.322  -2.399  1.00 42.29           C  
ATOM   2143  CD1 LEU B  83     -46.034  11.517  -3.305  1.00 35.38           C  
ATOM   2144  CD2 LEU B  83     -47.723  10.156  -2.074  1.00 36.60           C  
ATOM   2145  N   ARG B  84     -43.258   8.010  -1.232  1.00 38.90           N  
ATOM   2146  C   ARG B  84     -41.067   8.552  -0.274  1.00 38.21           C  
ATOM   2147  O   ARG B  84     -40.550   9.374   0.476  1.00 38.00           O  
ATOM   2148  CA  ARG B  84     -42.481   8.043   0.005  0.50 39.47           C  
ATOM   2149  CB  ARG B  84     -42.459   6.682   0.722  0.50 38.48           C  
ATOM   2150  CG  ARG B  84     -41.962   6.777   2.164  0.50 39.70           C  
ATOM   2151  CD  ARG B  84     -42.279   5.551   3.010  0.50 41.95           C  
ATOM   2152  NE  ARG B  84     -43.667   5.494   3.477  0.50 41.77           N  
ATOM   2153  CZ  ARG B  84     -44.124   6.077   4.587  0.50 41.39           C  
ATOM   2154  NH1 ARG B  84     -43.310   6.786   5.350  0.50 30.02           N  
ATOM   2155  NH2 ARG B  84     -45.402   5.948   4.936  0.50 45.09           N  
ATOM   2164  N   GLU B  85     -40.462   8.100  -1.369  1.00 38.15           N  
ATOM   2165  CA  GLU B  85     -39.100   8.512  -1.684  1.00 37.56           C  
ATOM   2166  C   GLU B  85     -39.054   9.974  -2.064  1.00 39.27           C  
ATOM   2167  O   GLU B  85     -38.195  10.727  -1.571  1.00 38.12           O  
ATOM   2168  CB  GLU B  85     -38.476   7.664  -2.793  1.00 38.49           C  
ATOM   2169  CG  GLU B  85     -36.979   7.963  -2.957  1.00 35.94           C  
ATOM   2170  CD  GLU B  85     -36.232   6.923  -3.771  1.00 42.40           C  
ATOM   2171  OE1 GLU B  85     -36.869   6.134  -4.493  1.00 42.76           O  
ATOM   2172  OE2 GLU B  85     -34.991   6.893  -3.686  1.00 41.23           O  
ATOM   2173  N   TYR B  86     -39.971  10.366  -2.943  1.00 37.24           N  
ATOM   2174  CA  TYR B  86     -40.095  11.751  -3.354  1.00 39.09           C  
ATOM   2175  C   TYR B  86     -40.223  12.661  -2.119  1.00 40.34           C  
ATOM   2176  O   TYR B  86     -39.470  13.631  -1.964  1.00 40.59           O  
ATOM   2177  CB  TYR B  86     -41.313  11.902  -4.266  1.00 38.09           C  
ATOM   2178  CG  TYR B  86     -41.724  13.325  -4.557  1.00 40.58           C  
ATOM   2179  CD1 TYR B  86     -42.541  14.040  -3.671  1.00 38.91           C  
ATOM   2180  CD2 TYR B  86     -41.312  13.963  -5.724  1.00 36.76           C  
ATOM   2181  CE1 TYR B  86     -42.914  15.343  -3.943  1.00 37.09           C  
ATOM   2182  CE2 TYR B  86     -41.692  15.263  -5.993  1.00 34.93           C  
ATOM   2183  CZ  TYR B  86     -42.486  15.948  -5.103  1.00 36.50           C  
ATOM   2184  OH  TYR B  86     -42.870  17.248  -5.387  1.00 36.03           O  
ATOM   2185  N   LEU B  87     -41.186  12.343  -1.258  1.00 37.75           N  
ATOM   2186  CA  LEU B  87     -41.469  13.149  -0.074  1.00 38.94           C  
ATOM   2187  C   LEU B  87     -40.316  13.162   0.926  1.00 37.75           C  
ATOM   2188  O   LEU B  87     -40.086  14.175   1.591  1.00 38.16           O  
ATOM   2189  CB  LEU B  87     -42.745  12.652   0.631  1.00 36.90           C  
ATOM   2190  CG  LEU B  87     -44.082  12.849  -0.092  1.00 39.97           C  
ATOM   2191  CD1 LEU B  87     -45.223  12.235   0.714  1.00 36.90           C  
ATOM   2192  CD2 LEU B  87     -44.360  14.307  -0.387  1.00 37.36           C  
ATOM   2193  N   THR B  88     -39.629  12.028   1.057  1.00 36.86           N  
ATOM   2194  CA  THR B  88     -38.494  11.904   1.977  1.00 37.79           C  
ATOM   2195  C   THR B  88     -37.340  12.810   1.500  1.00 38.70           C  
ATOM   2196  O   THR B  88     -36.800  13.606   2.281  1.00 37.10           O  
ATOM   2197  CB  THR B  88     -38.056  10.432   2.131  1.00 37.27           C  
ATOM   2198  OG1 THR B  88     -39.171   9.659   2.577  1.00 36.27           O  
ATOM   2199  CG2 THR B  88     -36.894  10.263   3.148  1.00 36.07           C  
ATOM   2200  N   VAL B  89     -36.998  12.717   0.214  1.00 39.69           N  
ATOM   2201  CA  VAL B  89     -35.930  13.539  -0.366  1.00 38.69           C  
ATOM   2202  C   VAL B  89     -36.244  15.037  -0.199  1.00 39.43           C  
ATOM   2203  O   VAL B  89     -35.385  15.813   0.232  1.00 38.56           O  
ATOM   2204  CB  VAL B  89     -35.695  13.217  -1.862  1.00 39.97           C  
ATOM   2205  CG1 VAL B  89     -34.735  14.228  -2.499  1.00 38.40           C  
ATOM   2206  CG2 VAL B  89     -35.176  11.789  -2.049  1.00 40.69           C  
ATOM   2207  N   PHE B  90     -37.470  15.443  -0.531  1.00 37.31           N  
ATOM   2208  CA  PHE B  90     -37.797  16.866  -0.472  1.00 38.30           C  
ATOM   2209  C   PHE B  90     -37.949  17.439   0.932  1.00 37.05           C  
ATOM   2210  O   PHE B  90     -37.411  18.497   1.213  1.00 38.21           O  
ATOM   2211  CB  PHE B  90     -38.965  17.226  -1.397  1.00 37.93           C  
ATOM   2212  CG  PHE B  90     -38.550  17.350  -2.833  1.00 38.52           C  
ATOM   2213  CD1 PHE B  90     -38.939  16.399  -3.779  1.00 36.71           C  
ATOM   2214  CD2 PHE B  90     -37.701  18.385  -3.226  1.00 35.85           C  
ATOM   2215  CE1 PHE B  90     -38.519  16.505  -5.113  1.00 37.84           C  
ATOM   2216  CE2 PHE B  90     -37.268  18.508  -4.564  1.00 42.15           C  
ATOM   2217  CZ  PHE B  90     -37.683  17.571  -5.506  1.00 38.99           C  
ATOM   2218  N   THR B  91     -38.632  16.732   1.832  1.00 37.83           N  
ATOM   2219  CA  THR B  91     -38.734  17.224   3.206  1.00 38.14           C  
ATOM   2220  C   THR B  91     -37.344  17.301   3.865  1.00 38.64           C  
ATOM   2221  O   THR B  91     -37.065  18.232   4.630  1.00 39.01           O  
ATOM   2222  CB  THR B  91     -39.681  16.383   4.089  1.00 38.62           C  
ATOM   2223  OG1 THR B  91     -39.363  14.996   3.954  1.00 39.74           O  
ATOM   2224  CG2 THR B  91     -41.160  16.611   3.704  1.00 35.72           C  
ATOM   2225  N   THR B  92     -36.487  16.333   3.564  1.00 36.24           N  
ATOM   2226  CA  THR B  92     -35.100  16.352   4.064  1.00 37.78           C  
ATOM   2227  C   THR B  92     -34.319  17.531   3.506  1.00 38.12           C  
ATOM   2228  O   THR B  92     -33.608  18.206   4.254  1.00 39.84           O  
ATOM   2229  CB  THR B  92     -34.356  15.029   3.774  1.00 36.68           C  
ATOM   2230  OG1 THR B  92     -34.985  13.974   4.512  1.00 38.15           O  
ATOM   2231  CG2 THR B  92     -32.837  15.119   4.142  1.00 37.90           C  
ATOM   2232  N   HIS B  93     -34.463  17.795   2.205  1.00 39.04           N  
ATOM   2233  CA  HIS B  93     -33.773  18.940   1.607  1.00 38.66           C  
ATOM   2234  C   HIS B  93     -34.197  20.275   2.246  1.00 39.38           C  
ATOM   2235  O   HIS B  93     -33.354  21.153   2.502  1.00 39.15           O  
ATOM   2236  CB  HIS B  93     -33.973  19.023   0.089  1.00 37.16           C  
ATOM   2237  CG  HIS B  93     -32.982  19.930  -0.568  1.00 38.25           C  
ATOM   2238  ND1 HIS B  93     -31.701  19.527  -0.873  1.00 38.74           N  
ATOM   2239  CD2 HIS B  93     -33.052  21.241  -0.896  1.00 40.11           C  
ATOM   2240  CE1 HIS B  93     -31.032  20.543  -1.387  1.00 38.52           C  
ATOM   2241  NE2 HIS B  93     -31.829  21.595  -1.411  1.00 41.80           N  
ATOM   2242  N   ILE B  94     -35.505  20.430   2.447  1.00 38.68           N  
ATOM   2243  CA  ILE B  94     -36.074  21.660   3.006  1.00 39.41           C  
ATOM   2244  C   ILE B  94     -35.687  21.839   4.479  1.00 40.26           C  
ATOM   2245  O   ILE B  94     -35.443  22.959   4.933  1.00 39.85           O  
ATOM   2246  CB  ILE B  94     -37.620  21.725   2.789  1.00 38.76           C  
ATOM   2247  CG1 ILE B  94     -37.957  21.841   1.286  1.00 39.57           C  
ATOM   2248  CG2 ILE B  94     -38.278  22.864   3.596  1.00 40.59           C  
ATOM   2249  CD1 ILE B  94     -36.939  22.632   0.443  1.00 39.37           C  
ATOM   2250  N   LYS B  95     -35.616  20.726   5.210  1.00 39.76           N  
ATOM   2251  CA  LYS B  95     -35.145  20.731   6.581  1.00 40.18           C  
ATOM   2252  C   LYS B  95     -33.748  21.332   6.625  1.00 37.87           C  
ATOM   2253  O   LYS B  95     -33.462  22.157   7.473  1.00 36.21           O  
ATOM   2254  CB  LYS B  95     -35.104  19.312   7.136  1.00 39.79           C  
ATOM   2255  CG  LYS B  95     -35.531  19.200   8.589  1.00 46.96           C  
ATOM   2256  CD  LYS B  95     -35.164  17.847   9.213  1.00 43.97           C  
ATOM   2257  CE  LYS B  95     -35.524  16.673   8.302  1.00 43.63           C  
ATOM   2258  NZ  LYS B  95     -35.467  15.352   9.004  1.00 49.47           N  
ATOM   2259  N   GLU B  96     -32.896  20.912   5.695  1.00 39.65           N  
ATOM   2260  CA  GLU B  96     -31.496  21.344   5.645  1.00 41.38           C  
ATOM   2261  C   GLU B  96     -31.375  22.734   5.017  1.00 40.02           C  
ATOM   2262  O   GLU B  96     -30.447  23.489   5.319  1.00 37.76           O  
ATOM   2263  CB  GLU B  96     -30.656  20.338   4.843  1.00 42.62           C  
ATOM   2264  CG  GLU B  96     -30.569  18.918   5.452  1.00 47.61           C  
ATOM   2265  CD  GLU B  96     -29.970  17.863   4.498  1.00 55.39           C  
ATOM   2266  OE1 GLU B  96     -29.987  18.067   3.262  1.00 63.35           O  
ATOM   2267  OE2 GLU B  96     -29.499  16.809   4.989  1.00 59.30           O  
ATOM   2268  N   ASN B  97     -32.326  23.067   4.143  1.00 39.16           N  
ATOM   2269  CA  ASN B  97     -32.286  24.329   3.406  1.00 37.28           C  
ATOM   2270  C   ASN B  97     -33.614  25.071   3.415  1.00 37.31           C  
ATOM   2271  O   ASN B  97     -34.256  25.182   2.362  1.00 36.20           O  
ATOM   2272  CB  ASN B  97     -31.883  24.050   1.964  1.00 37.11           C  
ATOM   2273  CG  ASN B  97     -30.553  23.365   1.867  1.00 34.86           C  
ATOM   2274  OD1 ASN B  97     -29.518  24.014   1.862  1.00 41.00           O  
ATOM   2275  ND2 ASN B  97     -30.574  22.039   1.774  1.00 36.66           N  
ATOM   2276  N   PRO B  98     -34.035  25.579   4.596  1.00 37.06           N  
ATOM   2277  CA  PRO B  98     -35.388  26.152   4.698  1.00 35.03           C  
ATOM   2278  C   PRO B  98     -35.677  27.276   3.692  1.00 36.79           C  
ATOM   2279  O   PRO B  98     -36.803  27.375   3.187  1.00 35.70           O  
ATOM   2280  CB  PRO B  98     -35.469  26.660   6.149  1.00 36.21           C  
ATOM   2281  CG  PRO B  98     -34.051  26.546   6.726  1.00 37.19           C  
ATOM   2282  CD  PRO B  98     -33.349  25.508   5.907  1.00 35.70           C  
ATOM   2283  N   GLU B  99     -34.664  28.089   3.382  1.00 35.14           N  
ATOM   2284  CA  GLU B  99     -34.826  29.228   2.478  1.00 37.03           C  
ATOM   2285  C   GLU B  99     -35.236  28.804   1.069  1.00 36.59           C  
ATOM   2286  O   GLU B  99     -35.986  29.517   0.396  1.00 37.98           O  
ATOM   2287  CB  GLU B  99     -33.534  30.058   2.416  1.00 34.38           C  
ATOM   2288  CG  GLU B  99     -33.216  30.755   3.706  1.00 33.24           C  
ATOM   2289  CD  GLU B  99     -32.390  29.918   4.669  1.00 40.40           C  
ATOM   2290  OE1 GLU B  99     -32.095  28.727   4.388  1.00 38.29           O  
ATOM   2291  OE2 GLU B  99     -32.014  30.476   5.716  1.00 39.03           O  
ATOM   2292  N   ILE B 100     -34.718  27.657   0.628  1.00 36.71           N  
ATOM   2293  CA  ILE B 100     -35.045  27.107  -0.683  1.00 37.50           C  
ATOM   2294  C   ILE B 100     -36.537  26.736  -0.714  1.00 37.79           C  
ATOM   2295  O   ILE B 100     -37.199  26.865  -1.747  1.00 40.53           O  
ATOM   2296  CB  ILE B 100     -34.117  25.896  -1.037  1.00 38.51           C  
ATOM   2297  CG1 ILE B 100     -32.631  26.328  -1.213  1.00 35.43           C  
ATOM   2298  CG2 ILE B 100     -34.617  25.150  -2.275  1.00 40.34           C  
ATOM   2299  CD1 ILE B 100     -32.345  27.388  -2.355  1.00 31.76           C  
ATOM   2300  N   GLY B 101     -37.070  26.291   0.419  1.00 37.39           N  
ATOM   2301  CA  GLY B 101     -38.501  26.034   0.531  1.00 37.07           C  
ATOM   2302  C   GLY B 101     -39.311  27.280   0.205  1.00 37.98           C  
ATOM   2303  O   GLY B 101     -40.169  27.279  -0.687  1.00 38.93           O  
ATOM   2304  N   THR B 102     -39.016  28.353   0.929  1.00 36.24           N  
ATOM   2305  CA  THR B 102     -39.693  29.635   0.763  1.00 36.90           C  
ATOM   2306  C   THR B 102     -39.540  30.149  -0.668  1.00 36.64           C  
ATOM   2307  O   THR B 102     -40.524  30.530  -1.296  1.00 36.16           O  
ATOM   2308  CB  THR B 102     -39.113  30.683   1.745  1.00 37.67           C  
ATOM   2309  OG1 THR B 102     -39.539  30.361   3.072  1.00 37.38           O  
ATOM   2310  CG2 THR B 102     -39.574  32.102   1.390  1.00 38.69           C  
ATOM   2311  N   LEU B 103     -38.313  30.123  -1.185  1.00 35.91           N  
ATOM   2312  CA  LEU B 103     -38.034  30.691  -2.503  1.00 35.83           C  
ATOM   2313  C   LEU B 103     -38.652  29.871  -3.621  1.00 37.07           C  
ATOM   2314  O   LEU B 103     -39.223  30.444  -4.562  1.00 36.07           O  
ATOM   2315  CB  LEU B 103     -36.526  30.856  -2.728  1.00 35.91           C  
ATOM   2316  CG  LEU B 103     -35.811  31.774  -1.739  1.00 39.04           C  
ATOM   2317  CD1 LEU B 103     -34.304  31.779  -2.019  1.00 33.99           C  
ATOM   2318  CD2 LEU B 103     -36.403  33.190  -1.771  1.00 34.45           C  
ATOM   2319  N   ALA B 104     -38.542  28.540  -3.522  1.00 36.57           N  
ATOM   2320  CA  ALA B 104     -39.158  27.673  -4.523  1.00 36.58           C  
ATOM   2321  C   ALA B 104     -40.661  27.780  -4.457  1.00 35.32           C  
ATOM   2322  O   ALA B 104     -41.303  27.779  -5.492  1.00 36.38           O  
ATOM   2323  CB  ALA B 104     -38.726  26.208  -4.375  1.00 36.55           C  
ATOM   2324  N   TYR B 105     -41.230  27.882  -3.255  1.00 34.63           N  
ATOM   2325  CA  TYR B 105     -42.686  28.025  -3.168  1.00 34.98           C  
ATOM   2326  C   TYR B 105     -43.153  29.258  -3.950  1.00 35.37           C  
ATOM   2327  O   TYR B 105     -44.087  29.158  -4.775  1.00 36.62           O  
ATOM   2328  CB  TYR B 105     -43.198  28.047  -1.719  1.00 33.31           C  
ATOM   2329  CG  TYR B 105     -44.702  28.248  -1.601  1.00 36.94           C  
ATOM   2330  CD1 TYR B 105     -45.573  27.160  -1.622  1.00 29.19           C  
ATOM   2331  CD2 TYR B 105     -45.252  29.533  -1.485  1.00 29.47           C  
ATOM   2332  CE1 TYR B 105     -46.959  27.344  -1.520  1.00 36.27           C  
ATOM   2333  CE2 TYR B 105     -46.619  29.721  -1.399  1.00 35.17           C  
ATOM   2334  CZ  TYR B 105     -47.467  28.625  -1.407  1.00 33.81           C  
ATOM   2335  OH  TYR B 105     -48.821  28.824  -1.319  1.00 43.67           O  
ATOM   2336  N   GLU B 106     -42.507  30.401  -3.698  1.00 34.06           N  
ATOM   2337  CA  GLU B 106     -42.853  31.660  -4.369  1.00 34.74           C  
ATOM   2338  C   GLU B 106     -42.767  31.542  -5.887  1.00 34.74           C  
ATOM   2339  O   GLU B 106     -43.639  32.042  -6.590  1.00 33.91           O  
ATOM   2340  CB  GLU B 106     -41.960  32.822  -3.902  1.00 33.49           C  
ATOM   2341  CG  GLU B 106     -42.299  33.414  -2.526  1.00 42.72           C  
ATOM   2342  CD  GLU B 106     -43.788  33.758  -2.336  1.00 52.04           C  
ATOM   2343  OE1 GLU B 106     -44.450  34.234  -3.303  1.00 44.32           O  
ATOM   2344  OE2 GLU B 106     -44.281  33.554  -1.201  1.00 50.68           O  
ATOM   2345  N   GLU B 107     -41.710  30.897  -6.386  1.00 34.37           N  
ATOM   2346  CA  GLU B 107     -41.515  30.741  -7.834  1.00 35.49           C  
ATOM   2347  C   GLU B 107     -42.534  29.787  -8.425  1.00 37.55           C  
ATOM   2348  O   GLU B 107     -42.909  29.912  -9.601  1.00 38.60           O  
ATOM   2349  CB  GLU B 107     -40.103  30.235  -8.155  1.00 34.73           C  
ATOM   2350  CG  GLU B 107     -38.962  31.161  -7.697  1.00 36.83           C  
ATOM   2351  CD  GLU B 107     -38.705  32.349  -8.638  1.00 38.38           C  
ATOM   2352  OE1 GLU B 107     -39.372  32.454  -9.692  1.00 39.20           O  
ATOM   2353  OE2 GLU B 107     -37.824  33.184  -8.321  1.00 36.34           O  
ATOM   2354  N   ILE B 108     -42.960  28.804  -7.628  1.00 38.09           N  
ATOM   2355  CA  ILE B 108     -43.993  27.859  -8.079  1.00 37.05           C  
ATOM   2356  C   ILE B 108     -45.346  28.549  -8.170  1.00 36.21           C  
ATOM   2357  O   ILE B 108     -46.068  28.344  -9.127  1.00 38.22           O  
ATOM   2358  CB  ILE B 108     -44.108  26.615  -7.159  1.00 37.77           C  
ATOM   2359  CG1 ILE B 108     -42.818  25.784  -7.224  1.00 37.02           C  
ATOM   2360  CG2 ILE B 108     -45.335  25.745  -7.541  1.00 32.77           C  
ATOM   2361  CD1 ILE B 108     -42.764  24.666  -6.179  1.00 37.00           C  
ATOM   2362  N   ILE B 109     -45.701  29.352  -7.176  1.00 35.60           N  
ATOM   2363  CA  ILE B 109     -47.056  29.891  -7.148  1.00 36.98           C  
ATOM   2364  C   ILE B 109     -47.174  31.112  -8.035  1.00 36.67           C  
ATOM   2365  O   ILE B 109     -48.264  31.417  -8.512  1.00 34.23           O  
ATOM   2366  CB  ILE B 109     -47.579  30.229  -5.718  1.00 37.05           C  
ATOM   2367  CG1 ILE B 109     -46.604  31.166  -4.992  1.00 36.41           C  
ATOM   2368  CG2 ILE B 109     -47.859  28.943  -4.947  1.00 37.13           C  
ATOM   2369  CD1 ILE B 109     -47.250  32.076  -3.952  1.00 44.27           C  
ATOM   2370  N   LYS B 110     -46.058  31.813  -8.232  1.00 36.43           N  
ATOM   2371  CA  LYS B 110     -46.054  32.996  -9.092  1.00 39.63           C  
ATOM   2372  C   LYS B 110     -44.882  32.959 -10.070  1.00 39.97           C  
ATOM   2373  O   LYS B 110     -43.764  33.367  -9.747  1.00 40.46           O  
ATOM   2374  CB  LYS B 110     -46.070  34.298  -8.273  1.00 39.23           C  
ATOM   2375  CG  LYS B 110     -46.261  35.555  -9.140  1.00 43.07           C  
ATOM   2376  CD  LYS B 110     -46.433  36.805  -8.296  1.00 50.31           C  
ATOM   2377  CE  LYS B 110     -46.461  38.053  -9.165  1.00 56.45           C  
ATOM   2378  NZ  LYS B 110     -46.942  39.240  -8.394  1.00 58.24           N  
ATOM   2379  N   GLU B 111     -45.162  32.462 -11.268  1.00 40.69           N  
ATOM   2380  CA  GLU B 111     -44.155  32.308 -12.300  1.00 42.91           C  
ATOM   2381  C   GLU B 111     -43.440  33.622 -12.610  1.00 42.37           C  
ATOM   2382  O   GLU B 111     -44.075  34.628 -12.948  1.00 43.58           O  
ATOM   2383  CB  GLU B 111     -44.801  31.746 -13.567  1.00 43.08           C  
ATOM   2384  CG  GLU B 111     -43.803  31.332 -14.637  1.00 50.63           C  
ATOM   2385  CD  GLU B 111     -44.451  30.705 -15.862  1.00 56.21           C  
ATOM   2386  OE1 GLU B 111     -45.681  30.469 -15.861  1.00 61.51           O  
ATOM   2387  OE2 GLU B 111     -43.714  30.447 -16.832  1.00 53.66           O  
ATOM   2388  N   SER B 112     -42.119  33.617 -12.488  1.00 41.00           N  
ATOM   2389  CA  SER B 112     -41.333  34.788 -12.858  1.00 39.25           C  
ATOM   2390  C   SER B 112     -40.453  34.472 -14.062  1.00 39.09           C  
ATOM   2391  O   SER B 112     -40.363  33.326 -14.500  1.00 38.85           O  
ATOM   2392  CB  SER B 112     -40.464  35.250 -11.684  1.00 38.51           C  
ATOM   2393  OG  SER B 112     -39.331  34.404 -11.534  1.00 39.27           O  
ATOM   2394  N   ALA B 113     -39.784  35.497 -14.571  1.00 37.66           N  
ATOM   2395  CA  ALA B 113     -38.838  35.339 -15.668  1.00 38.39           C  
ATOM   2396  C   ALA B 113     -37.620  34.487 -15.279  1.00 36.74           C  
ATOM   2397  O   ALA B 113     -36.896  33.997 -16.145  1.00 36.65           O  
ATOM   2398  CB  ALA B 113     -38.406  36.712 -16.188  1.00 36.86           C  
ATOM   2399  N   ARG B 114     -37.415  34.297 -13.980  1.00 37.35           N  
ATOM   2400  CA  ARG B 114     -36.276  33.526 -13.472  1.00 37.12           C  
ATOM   2401  C   ARG B 114     -36.474  32.009 -13.545  1.00 38.36           C  
ATOM   2402  O   ARG B 114     -35.512  31.245 -13.372  1.00 39.77           O  
ATOM   2403  CB  ARG B 114     -35.973  33.918 -12.022  1.00 36.52           C  
ATOM   2404  CG  ARG B 114     -35.704  35.391 -11.807  1.00 36.69           C  
ATOM   2405  CD  ARG B 114     -35.607  35.755 -10.329  1.00 39.85           C  
ATOM   2406  NE  ARG B 114     -36.872  35.615  -9.603  1.00 41.40           N  
ATOM   2407  CZ  ARG B 114     -37.841  36.529  -9.562  1.00 43.27           C  
ATOM   2408  NH1 ARG B 114     -37.736  37.680 -10.223  1.00 41.24           N  
ATOM   2409  NH2 ARG B 114     -38.936  36.281  -8.858  1.00 42.15           N  
ATOM   2410  N   LEU B 115     -37.706  31.575 -13.806  1.00 37.40           N  
ATOM   2411  CA  LEU B 115     -38.078  30.165 -13.674  1.00 38.92           C  
ATOM   2412  C   LEU B 115     -37.202  29.215 -14.477  1.00 38.47           C  
ATOM   2413  O   LEU B 115     -36.655  28.254 -13.939  1.00 38.81           O  
ATOM   2414  CB  LEU B 115     -39.551  29.930 -14.036  1.00 37.84           C  
ATOM   2415  CG  LEU B 115     -40.073  28.486 -13.885  1.00 40.93           C  
ATOM   2416  CD1 LEU B 115     -39.862  27.920 -12.486  1.00 34.34           C  
ATOM   2417  CD2 LEU B 115     -41.554  28.397 -14.262  1.00 39.15           C  
ATOM   2418  N   GLU B 116     -37.095  29.499 -15.766  1.00 38.60           N  
ATOM   2419  CA  GLU B 116     -36.393  28.653 -16.711  1.00 39.37           C  
ATOM   2420  C   GLU B 116     -34.957  28.349 -16.255  1.00 39.66           C  
ATOM   2421  O   GLU B 116     -34.509  27.205 -16.354  1.00 39.82           O  
ATOM   2422  CB  GLU B 116     -36.420  29.330 -18.084  1.00 38.14           C  
ATOM   2423  CG  GLU B 116     -35.620  28.637 -19.188  1.00 42.74           C  
ATOM   2424  CD  GLU B 116     -35.796  29.307 -20.561  1.00 45.86           C  
ATOM   2425  OE1 GLU B 116     -36.728  30.128 -20.725  1.00 44.18           O  
ATOM   2426  OE2 GLU B 116     -35.004  29.004 -21.475  1.00 50.86           O  
ATOM   2427  N   LYS B 117     -34.244  29.366 -15.760  1.00 39.49           N  
ATOM   2428  CA  LYS B 117     -32.849  29.186 -15.334  1.00 39.54           C  
ATOM   2429  C   LYS B 117     -32.673  28.437 -14.024  1.00 37.33           C  
ATOM   2430  O   LYS B 117     -31.716  27.687 -13.874  1.00 37.25           O  
ATOM   2431  CB  LYS B 117     -32.106  30.524 -15.247  1.00 39.22           C  
ATOM   2432  CG  LYS B 117     -31.739  31.117 -16.592  1.00 44.68           C  
ATOM   2433  CD  LYS B 117     -30.839  30.195 -17.406  1.00 54.23           C  
ATOM   2434  CE  LYS B 117     -30.686  30.717 -18.826  1.00 59.79           C  
ATOM   2435  NZ  LYS B 117     -30.179  29.674 -19.754  1.00 66.12           N  
ATOM   2436  N   ILE B 118     -33.572  28.662 -13.069  1.00 38.00           N  
ATOM   2437  CA  ILE B 118     -33.468  28.024 -11.748  1.00 37.09           C  
ATOM   2438  C   ILE B 118     -34.098  26.631 -11.716  1.00 38.12           C  
ATOM   2439  O   ILE B 118     -33.783  25.836 -10.838  1.00 38.66           O  
ATOM   2440  CB  ILE B 118     -34.082  28.901 -10.612  1.00 39.33           C  
ATOM   2441  CG1 ILE B 118     -35.580  29.119 -10.844  1.00 35.72           C  
ATOM   2442  CG2 ILE B 118     -33.324  30.236 -10.467  1.00 35.77           C  
ATOM   2443  CD1 ILE B 118     -36.313  29.607  -9.629  1.00 36.26           C  
ATOM   2444  N   LYS B 119     -34.965  26.333 -12.682  1.00 36.79           N  
ATOM   2445  CA  LYS B 119     -35.745  25.089 -12.669  1.00 37.03           C  
ATOM   2446  C   LYS B 119     -34.925  23.816 -12.414  1.00 36.25           C  
ATOM   2447  O   LYS B 119     -35.347  22.988 -11.608  1.00 38.91           O  
ATOM   2448  CB  LYS B 119     -36.544  24.928 -13.969  1.00 37.14           C  
ATOM   2449  CG  LYS B 119     -37.741  24.019 -13.833  1.00 39.23           C  
ATOM   2450  CD  LYS B 119     -38.429  23.775 -15.173  1.00 43.85           C  
ATOM   2451  CE  LYS B 119     -39.919  23.535 -14.960  1.00 50.59           C  
ATOM   2452  NZ  LYS B 119     -40.563  22.793 -16.087  1.00 52.62           N  
ATOM   2453  N   PRO B 120     -33.779  23.628 -13.128  1.00 35.61           N  
ATOM   2454  CA  PRO B 120     -32.999  22.402 -12.916  1.00 34.24           C  
ATOM   2455  C   PRO B 120     -32.537  22.198 -11.481  1.00 33.70           C  
ATOM   2456  O   PRO B 120     -32.257  21.067 -11.088  1.00 34.38           O  
ATOM   2457  CB  PRO B 120     -31.789  22.582 -13.837  1.00 34.78           C  
ATOM   2458  CG  PRO B 120     -32.273  23.481 -14.912  1.00 33.34           C  
ATOM   2459  CD  PRO B 120     -33.237  24.421 -14.252  1.00 33.78           C  
ATOM   2460  N   TYR B 121     -32.472  23.268 -10.705  1.00 33.09           N  
ATOM   2461  CA  TYR B 121     -31.929  23.180  -9.352  1.00 33.78           C  
ATOM   2462  C   TYR B 121     -32.922  22.819  -8.236  1.00 34.28           C  
ATOM   2463  O   TYR B 121     -32.528  22.636  -7.088  1.00 34.46           O  
ATOM   2464  CB  TYR B 121     -31.163  24.448  -9.027  1.00 33.04           C  
ATOM   2465  CG  TYR B 121     -30.080  24.747 -10.043  1.00 33.91           C  
ATOM   2466  CD1 TYR B 121     -30.159  25.865 -10.859  1.00 31.53           C  
ATOM   2467  CD2 TYR B 121     -28.993  23.882 -10.208  1.00 27.42           C  
ATOM   2468  CE1 TYR B 121     -29.152  26.143 -11.794  1.00 38.44           C  
ATOM   2469  CE2 TYR B 121     -27.995  24.143 -11.137  1.00 29.39           C  
ATOM   2470  CZ  TYR B 121     -28.080  25.270 -11.926  1.00 35.44           C  
ATOM   2471  OH  TYR B 121     -27.088  25.518 -12.844  1.00 42.88           O  
ATOM   2472  N   PHE B 122     -34.203  22.701  -8.566  1.00 34.51           N  
ATOM   2473  CA  PHE B 122     -35.197  22.293  -7.568  1.00 33.86           C  
ATOM   2474  C   PHE B 122     -36.557  21.971  -8.181  1.00 34.02           C  
ATOM   2475  O   PHE B 122     -37.034  20.840  -8.099  1.00 32.93           O  
ATOM   2476  CB  PHE B 122     -35.366  23.356  -6.459  1.00 35.09           C  
ATOM   2477  CG  PHE B 122     -36.160  22.860  -5.282  1.00 33.85           C  
ATOM   2478  CD1 PHE B 122     -35.519  22.259  -4.206  1.00 33.71           C  
ATOM   2479  CD2 PHE B 122     -37.558  22.943  -5.278  1.00 37.37           C  
ATOM   2480  CE1 PHE B 122     -36.249  21.770  -3.116  1.00 39.04           C  
ATOM   2481  CE2 PHE B 122     -38.305  22.454  -4.205  1.00 40.30           C  
ATOM   2482  CZ  PHE B 122     -37.646  21.860  -3.118  1.00 37.46           C  
ATOM   2483  N   ILE B 123     -37.166  22.974  -8.803  1.00 33.02           N  
ATOM   2484  CA  ILE B 123     -38.558  22.877  -9.238  1.00 35.70           C  
ATOM   2485  C   ILE B 123     -38.795  21.773 -10.276  1.00 37.67           C  
ATOM   2486  O   ILE B 123     -39.844  21.109 -10.246  1.00 38.76           O  
ATOM   2487  CB  ILE B 123     -39.090  24.244  -9.723  1.00 35.59           C  
ATOM   2488  CG1 ILE B 123     -39.257  25.182  -8.534  1.00 34.86           C  
ATOM   2489  CG2 ILE B 123     -40.433  24.093 -10.474  1.00 37.14           C  
ATOM   2490  CD1 ILE B 123     -39.208  26.680  -8.876  1.00 32.92           C  
ATOM   2491  N   GLY B 124     -37.836  21.590 -11.192  1.00 38.42           N  
ATOM   2492  CA  GLY B 124     -37.941  20.568 -12.233  1.00 37.99           C  
ATOM   2493  C   GLY B 124     -38.205  19.194 -11.639  1.00 39.29           C  
ATOM   2494  O   GLY B 124     -39.117  18.486 -12.073  1.00 41.70           O  
ATOM   2495  N   SER B 125     -37.420  18.825 -10.629  1.00 37.75           N  
ATOM   2496  CA  SER B 125     -37.546  17.530  -9.979  1.00 36.87           C  
ATOM   2497  C   SER B 125     -38.774  17.468  -9.064  1.00 38.06           C  
ATOM   2498  O   SER B 125     -39.429  16.417  -8.950  1.00 35.00           O  
ATOM   2499  CB  SER B 125     -36.287  17.205  -9.184  1.00 38.13           C  
ATOM   2500  OG  SER B 125     -35.175  17.026 -10.047  1.00 38.26           O  
ATOM   2501  N   PHE B 126     -39.084  18.600  -8.430  1.00 37.06           N  
ATOM   2502  CA  PHE B 126     -40.282  18.733  -7.606  1.00 37.73           C  
ATOM   2503  C   PHE B 126     -41.558  18.469  -8.423  1.00 37.66           C  
ATOM   2504  O   PHE B 126     -42.539  17.934  -7.905  1.00 39.16           O  
ATOM   2505  CB  PHE B 126     -40.321  20.118  -6.919  1.00 34.48           C  
ATOM   2506  CG  PHE B 126     -41.263  20.179  -5.738  1.00 39.00           C  
ATOM   2507  CD1 PHE B 126     -42.532  20.728  -5.871  1.00 38.99           C  
ATOM   2508  CD2 PHE B 126     -40.889  19.656  -4.492  1.00 35.64           C  
ATOM   2509  CE1 PHE B 126     -43.420  20.767  -4.782  1.00 40.81           C  
ATOM   2510  CE2 PHE B 126     -41.769  19.703  -3.381  1.00 40.18           C  
ATOM   2511  CZ  PHE B 126     -43.033  20.261  -3.524  1.00 37.57           C  
ATOM   2512  N   GLU B 127     -41.532  18.845  -9.698  1.00 37.19           N  
ATOM   2513  CA  GLU B 127     -42.668  18.629 -10.619  1.00 38.31           C  
ATOM   2514  C   GLU B 127     -42.977  17.150 -10.955  1.00 39.40           C  
ATOM   2515  O   GLU B 127     -43.930  16.862 -11.677  1.00 39.27           O  
ATOM   2516  CB  GLU B 127     -42.470  19.428 -11.899  1.00 35.44           C  
ATOM   2517  CG  GLU B 127     -42.946  20.860 -11.748  1.00 37.39           C  
ATOM   2518  CD  GLU B 127     -42.677  21.719 -12.960  1.00 43.18           C  
ATOM   2519  OE1 GLU B 127     -42.102  21.216 -13.948  1.00 45.42           O  
ATOM   2520  OE2 GLU B 127     -43.041  22.915 -12.916  1.00 44.54           O  
ATOM   2521  N   GLN B 128     -42.174  16.226 -10.434  1.00 37.02           N  
ATOM   2522  CA  GLN B 128     -42.461  14.801 -10.602  1.00 37.34           C  
ATOM   2523  C   GLN B 128     -43.735  14.411  -9.856  1.00 37.13           C  
ATOM   2524  O   GLN B 128     -44.330  13.387 -10.155  1.00 38.04           O  
ATOM   2525  CB  GLN B 128     -41.323  13.939 -10.083  1.00 36.52           C  
ATOM   2526  CG  GLN B 128     -40.182  13.723 -11.040  1.00 37.74           C  
ATOM   2527  CD  GLN B 128     -39.244  12.648 -10.531  1.00 44.03           C  
ATOM   2528  OE1 GLN B 128     -39.681  11.547 -10.182  1.00 39.15           O  
ATOM   2529  NE2 GLN B 128     -37.955  12.959 -10.469  1.00 44.92           N  
ATOM   2530  N   LEU B 129     -44.142  15.226  -8.888  1.00 35.21           N  
ATOM   2531  CA  LEU B 129     -45.295  14.912  -8.051  1.00 34.99           C  
ATOM   2532  C   LEU B 129     -46.564  14.529  -8.817  1.00 35.76           C  
ATOM   2533  O   LEU B 129     -47.204  13.527  -8.498  1.00 35.19           O  
ATOM   2534  CB  LEU B 129     -45.582  16.080  -7.115  1.00 34.58           C  
ATOM   2535  CG  LEU B 129     -46.735  15.900  -6.133  1.00 35.38           C  
ATOM   2536  CD1 LEU B 129     -46.534  14.625  -5.256  1.00 37.50           C  
ATOM   2537  CD2 LEU B 129     -46.890  17.190  -5.303  1.00 30.57           C  
ATOM   2538  N   LYS B 130     -46.935  15.341  -9.805  1.00 36.65           N  
ATOM   2539  CA  LYS B 130     -48.108  15.067 -10.641  1.00 38.51           C  
ATOM   2540  C   LYS B 130     -48.169  13.630 -11.145  1.00 38.12           C  
ATOM   2541  O   LYS B 130     -49.176  12.954 -10.934  1.00 40.20           O  
ATOM   2542  CB  LYS B 130     -48.200  16.025 -11.835  1.00 38.68           C  
ATOM   2543  CG  LYS B 130     -49.500  15.832 -12.626  1.00 43.56           C  
ATOM   2544  CD  LYS B 130     -49.728  16.925 -13.650  1.00 47.97           C  
ATOM   2545  CE  LYS B 130     -51.091  16.756 -14.321  1.00 59.67           C  
ATOM   2546  NZ  LYS B 130     -51.252  17.590 -15.553  1.00 59.84           N  
ATOM   2547  N   GLU B 131     -47.109  13.163 -11.810  1.00 38.02           N  
ATOM   2548  CA  GLU B 131     -47.140  11.805 -12.382  1.00 39.66           C  
ATOM   2549  C   GLU B 131     -47.236  10.712 -11.309  1.00 37.79           C  
ATOM   2550  O   GLU B 131     -47.906   9.723 -11.510  1.00 37.07           O  
ATOM   2551  CB  GLU B 131     -45.991  11.546 -13.363  1.00 39.11           C  
ATOM   2552  CG  GLU B 131     -44.601  11.483 -12.755  1.00 44.19           C  
ATOM   2553  CD  GLU B 131     -43.596  10.828 -13.702  1.00 45.31           C  
ATOM   2554  OE1 GLU B 131     -43.874  10.755 -14.911  1.00 52.76           O  
ATOM   2555  OE2 GLU B 131     -42.531  10.378 -13.239  1.00 50.69           O  
ATOM   2556  N   ILE B 132     -46.599  10.923 -10.160  1.00 36.81           N  
ATOM   2557  CA  ILE B 132     -46.691   9.969  -9.049  1.00 36.30           C  
ATOM   2558  C   ILE B 132     -48.146   9.818  -8.575  1.00 36.30           C  
ATOM   2559  O   ILE B 132     -48.637   8.700  -8.345  1.00 35.75           O  
ATOM   2560  CB  ILE B 132     -45.795  10.399  -7.872  1.00 34.45           C  
ATOM   2561  CG1 ILE B 132     -44.317  10.340  -8.280  1.00 35.54           C  
ATOM   2562  CG2 ILE B 132     -46.005   9.473  -6.691  1.00 38.18           C  
ATOM   2563  CD1 ILE B 132     -43.338  10.908  -7.211  1.00 32.78           C  
ATOM   2564  N   LEU B 133     -48.824  10.954  -8.448  1.00 36.99           N  
ATOM   2565  CA  LEU B 133     -50.210  11.020  -7.973  1.00 38.23           C  
ATOM   2566  C   LEU B 133     -51.178  10.419  -8.982  1.00 38.93           C  
ATOM   2567  O   LEU B 133     -52.097   9.685  -8.598  1.00 41.35           O  
ATOM   2568  CB  LEU B 133     -50.609  12.471  -7.667  1.00 38.22           C  
ATOM   2569  CG  LEU B 133     -49.932  13.175  -6.487  1.00 37.01           C  
ATOM   2570  CD1 LEU B 133     -50.402  14.632  -6.413  1.00 31.00           C  
ATOM   2571  CD2 LEU B 133     -50.230  12.449  -5.175  1.00 39.16           C  
ATOM   2572  N   GLN B 134     -50.975  10.727 -10.263  1.00 37.83           N  
ATOM   2573  CA  GLN B 134     -51.799  10.154 -11.332  1.00 38.31           C  
ATOM   2574  C   GLN B 134     -51.644   8.642 -11.404  1.00 37.07           C  
ATOM   2575  O   GLN B 134     -52.630   7.934 -11.533  1.00 37.94           O  
ATOM   2576  CB  GLN B 134     -51.467  10.782 -12.676  1.00 37.62           C  
ATOM   2577  CG  GLN B 134     -51.889  12.235 -12.749  1.00 45.17           C  
ATOM   2578  CD  GLN B 134     -51.453  12.901 -14.034  1.00 51.69           C  
ATOM   2579  OE1 GLN B 134     -50.336  12.674 -14.527  1.00 49.58           O  
ATOM   2580  NE2 GLN B 134     -52.319  13.747 -14.574  1.00 43.53           N  
ATOM   2581  N   GLU B 135     -50.409   8.155 -11.289  1.00 36.55           N  
ATOM   2582  CA  GLU B 135     -50.160   6.714 -11.208  1.00 38.00           C  
ATOM   2583  C   GLU B 135     -50.875   6.030 -10.022  1.00 37.95           C  
ATOM   2584  O   GLU B 135     -51.524   4.996 -10.199  1.00 37.15           O  
ATOM   2585  CB  GLU B 135     -48.651   6.416 -11.184  1.00 37.31           C  
ATOM   2586  CG  GLU B 135     -48.315   4.929 -11.337  1.00 39.77           C  
ATOM   2587  CD  GLU B 135     -48.824   4.304 -12.643  1.00 45.84           C  
ATOM   2588  OE1 GLU B 135     -48.833   4.992 -13.692  1.00 43.41           O  
ATOM   2589  OE2 GLU B 135     -49.208   3.112 -12.617  1.00 40.58           O  
ATOM   2590  N   GLY B 136     -50.760   6.617  -8.830  1.00 39.40           N  
ATOM   2591  CA  GLY B 136     -51.423   6.083  -7.638  1.00 39.57           C  
ATOM   2592  C   GLY B 136     -52.936   6.080  -7.746  1.00 39.27           C  
ATOM   2593  O   GLY B 136     -53.602   5.127  -7.322  1.00 38.95           O  
ATOM   2594  N   GLU B 137     -53.473   7.145  -8.330  1.00 38.64           N  
ATOM   2595  CA  GLU B 137     -54.894   7.234  -8.595  1.00 40.05           C  
ATOM   2596  C   GLU B 137     -55.304   6.178  -9.608  1.00 40.04           C  
ATOM   2597  O   GLU B 137     -56.317   5.499  -9.421  1.00 40.08           O  
ATOM   2598  CB  GLU B 137     -55.256   8.620  -9.119  1.00 39.63           C  
ATOM   2599  CG  GLU B 137     -56.720   8.779  -9.469  1.00 40.94           C  
ATOM   2600  CD  GLU B 137     -57.083  10.222  -9.770  1.00 44.11           C  
ATOM   2601  OE1 GLU B 137     -56.403  10.857 -10.613  1.00 44.21           O  
ATOM   2602  OE2 GLU B 137     -58.050  10.713  -9.154  1.00 38.52           O  
ATOM   2603  N   LYS B 138     -54.522   6.055 -10.681  1.00 39.19           N  
ATOM   2604  CA  LYS B 138     -54.793   5.068 -11.726  1.00 39.11           C  
ATOM   2605  C   LYS B 138     -54.790   3.656 -11.135  1.00 38.90           C  
ATOM   2606  O   LYS B 138     -55.655   2.850 -11.451  1.00 38.27           O  
ATOM   2607  CB  LYS B 138     -53.762   5.192 -12.851  1.00 38.70           C  
ATOM   2608  CG  LYS B 138     -53.835   4.096 -13.917  1.00 40.14           C  
ATOM   2609  CD  LYS B 138     -52.649   4.184 -14.876  1.00 47.10           C  
ATOM   2610  CE  LYS B 138     -52.187   2.799 -15.295  1.00 47.09           C  
ATOM   2611  NZ  LYS B 138     -52.042   2.665 -16.769  1.00 50.59           N  
ATOM   2612  N   GLN B 139     -53.829   3.382 -10.250  1.00 38.48           N  
ATOM   2613  CA  GLN B 139     -53.691   2.061  -9.641  1.00 38.46           C  
ATOM   2614  C   GLN B 139     -54.670   1.783  -8.499  1.00 39.39           C  
ATOM   2615  O   GLN B 139     -54.715   0.668  -7.981  1.00 40.36           O  
ATOM   2616  CB  GLN B 139     -52.266   1.836  -9.163  1.00 37.38           C  
ATOM   2617  CG  GLN B 139     -51.279   1.601 -10.293  1.00 38.49           C  
ATOM   2618  CD  GLN B 139     -49.964   1.058  -9.795  1.00 34.15           C  
ATOM   2619  OE1 GLN B 139     -49.896   0.448  -8.725  1.00 34.63           O  
ATOM   2620  NE2 GLN B 139     -48.899   1.289 -10.563  1.00 32.61           N  
ATOM   2621  N   GLY B 140     -55.442   2.791  -8.103  1.00 40.12           N  
ATOM   2622  CA  GLY B 140     -56.493   2.615  -7.092  1.00 39.60           C  
ATOM   2623  C   GLY B 140     -55.971   2.766  -5.679  1.00 39.17           C  
ATOM   2624  O   GLY B 140     -56.598   2.328  -4.724  1.00 38.75           O  
ATOM   2625  N   VAL B 141     -54.829   3.423  -5.546  1.00 39.68           N  
ATOM   2626  CA  VAL B 141     -54.154   3.517  -4.260  1.00 39.69           C  
ATOM   2627  C   VAL B 141     -54.269   4.930  -3.643  1.00 39.32           C  
ATOM   2628  O   VAL B 141     -54.341   5.064  -2.415  1.00 37.13           O  
ATOM   2629  CB  VAL B 141     -52.697   2.941  -4.381  1.00 41.10           C  
ATOM   2630  CG1 VAL B 141     -51.645   4.018  -4.521  1.00 41.94           C  
ATOM   2631  CG2 VAL B 141     -52.392   1.988  -3.243  1.00 42.46           C  
ATOM   2632  N   PHE B 142     -54.332   5.964  -4.493  1.00 37.43           N  
ATOM   2633  CA  PHE B 142     -54.523   7.344  -4.037  1.00 37.74           C  
ATOM   2634  C   PHE B 142     -55.941   7.827  -4.356  1.00 38.34           C  
ATOM   2635  O   PHE B 142     -56.505   7.496  -5.404  1.00 37.76           O  
ATOM   2636  CB  PHE B 142     -53.496   8.324  -4.645  1.00 37.13           C  
ATOM   2637  CG  PHE B 142     -52.038   8.010  -4.313  1.00 39.79           C  
ATOM   2638  CD1 PHE B 142     -51.684   7.345  -3.129  1.00 40.63           C  
ATOM   2639  CD2 PHE B 142     -51.024   8.397  -5.188  1.00 34.75           C  
ATOM   2640  CE1 PHE B 142     -50.347   7.051  -2.839  1.00 39.60           C  
ATOM   2641  CE2 PHE B 142     -49.665   8.104  -4.912  1.00 33.69           C  
ATOM   2642  CZ  PHE B 142     -49.330   7.444  -3.736  1.00 35.93           C  
ATOM   2643  N   HIS B 143     -56.497   8.624  -3.453  1.00 38.08           N  
ATOM   2644  CA  HIS B 143     -57.860   9.137  -3.600  1.00 39.30           C  
ATOM   2645  C   HIS B 143     -57.906  10.608  -3.216  1.00 39.24           C  
ATOM   2646  O   HIS B 143     -57.551  10.970  -2.093  1.00 40.04           O  
ATOM   2647  CB  HIS B 143     -58.817   8.320  -2.741  1.00 37.60           C  
ATOM   2648  CG  HIS B 143     -58.675   6.845  -2.939  1.00 41.70           C  
ATOM   2649  ND1 HIS B 143     -59.344   6.161  -3.933  1.00 44.70           N  
ATOM   2650  CD2 HIS B 143     -57.914   5.928  -2.295  1.00 41.82           C  
ATOM   2651  CE1 HIS B 143     -59.012   4.883  -3.882  1.00 47.54           C  
ATOM   2652  NE2 HIS B 143     -58.145   4.715  -2.898  1.00 48.00           N  
ATOM   2653  N   PHE B 144     -58.332  11.446  -4.160  1.00 38.42           N  
ATOM   2654  CA  PHE B 144     -58.354  12.897  -3.982  1.00 38.18           C  
ATOM   2655  C   PHE B 144     -59.336  13.538  -4.953  1.00 38.43           C  
ATOM   2656  O   PHE B 144     -59.574  12.998  -6.025  1.00 37.02           O  
ATOM   2657  CB  PHE B 144     -56.934  13.494  -4.152  1.00 36.63           C  
ATOM   2658  CG  PHE B 144     -56.179  12.989  -5.367  1.00 34.97           C  
ATOM   2659  CD1 PHE B 144     -55.127  12.084  -5.224  1.00 37.57           C  
ATOM   2660  CD2 PHE B 144     -56.492  13.452  -6.654  1.00 37.81           C  
ATOM   2661  CE1 PHE B 144     -54.413  11.605  -6.355  1.00 32.95           C  
ATOM   2662  CE2 PHE B 144     -55.794  12.984  -7.797  1.00 34.25           C  
ATOM   2663  CZ  PHE B 144     -54.751  12.067  -7.640  1.00 35.87           C  
ATOM   2664  N   PHE B 145     -59.899  14.690  -4.588  1.00 40.83           N  
ATOM   2665  CA  PHE B 145     -60.934  15.310  -5.420  1.00 42.43           C  
ATOM   2666  C   PHE B 145     -60.394  15.952  -6.706  1.00 42.69           C  
ATOM   2667  O   PHE B 145     -61.097  16.002  -7.723  1.00 44.16           O  
ATOM   2668  CB  PHE B 145     -61.851  16.270  -4.616  1.00 44.68           C  
ATOM   2669  CG  PHE B 145     -61.222  17.604  -4.256  1.00 45.59           C  
ATOM   2670  CD1 PHE B 145     -60.368  17.722  -3.158  1.00 51.76           C  
ATOM   2671  CD2 PHE B 145     -61.533  18.750  -4.981  1.00 43.85           C  
ATOM   2672  CE1 PHE B 145     -59.783  18.971  -2.802  1.00 57.60           C  
ATOM   2673  CE2 PHE B 145     -60.965  19.991  -4.643  1.00 53.79           C  
ATOM   2674  CZ  PHE B 145     -60.087  20.104  -3.541  1.00 52.38           C  
ATOM   2675  N   SER B 146     -59.149  16.422  -6.657  1.00 41.04           N  
ATOM   2676  CA  SER B 146     -58.553  17.147  -7.766  1.00 40.06           C  
ATOM   2677  C   SER B 146     -57.051  17.006  -7.674  1.00 40.38           C  
ATOM   2678  O   SER B 146     -56.469  17.176  -6.598  1.00 38.75           O  
ATOM   2679  CB  SER B 146     -58.955  18.626  -7.711  1.00 41.66           C  
ATOM   2680  OG  SER B 146     -58.070  19.457  -8.446  1.00 39.52           O  
ATOM   2681  N   ILE B 147     -56.435  16.674  -8.804  1.00 39.50           N  
ATOM   2682  CA  ILE B 147     -54.990  16.536  -8.884  1.00 40.51           C  
ATOM   2683  C   ILE B 147     -54.264  17.858  -8.572  1.00 39.39           C  
ATOM   2684  O   ILE B 147     -53.282  17.851  -7.828  1.00 39.97           O  
ATOM   2685  CB  ILE B 147     -54.522  15.923 -10.241  1.00 40.54           C  
ATOM   2686  CG1 ILE B 147     -52.997  15.889 -10.330  1.00 44.18           C  
ATOM   2687  CG2 ILE B 147     -55.069  16.696 -11.431  1.00 43.48           C  
ATOM   2688  CD1 ILE B 147     -52.388  14.737  -9.616  1.00 46.29           C  
ATOM   2689  N   ASN B 148     -54.743  18.973  -9.125  1.00 37.48           N  
ATOM   2690  CA  ASN B 148     -54.087  20.269  -8.916  1.00 37.81           C  
ATOM   2691  C   ASN B 148     -54.225  20.785  -7.483  1.00 36.35           C  
ATOM   2692  O   ASN B 148     -53.323  21.427  -6.968  1.00 38.60           O  
ATOM   2693  CB  ASN B 148     -54.605  21.323  -9.902  1.00 36.93           C  
ATOM   2694  CG  ASN B 148     -54.190  21.036 -11.348  1.00 44.26           C  
ATOM   2695  OD1 ASN B 148     -53.131  20.452 -11.619  1.00 49.81           O  
ATOM   2696  ND2 ASN B 148     -55.022  21.463 -12.285  1.00 45.10           N  
ATOM   2697  N   HIS B 149     -55.350  20.493  -6.841  1.00 35.15           N  
ATOM   2698  CA  HIS B 149     -55.559  20.921  -5.471  1.00 34.07           C  
ATOM   2699  C   HIS B 149     -54.659  20.135  -4.533  1.00 35.49           C  
ATOM   2700  O   HIS B 149     -54.125  20.697  -3.582  1.00 34.70           O  
ATOM   2701  CB  HIS B 149     -57.023  20.781  -5.092  1.00 35.55           C  
ATOM   2702  CG  HIS B 149     -57.916  21.802  -5.745  1.00 39.02           C  
ATOM   2703  ND1 HIS B 149     -58.215  23.015  -5.161  1.00 41.18           N  
ATOM   2704  CD2 HIS B 149     -58.574  21.789  -6.931  1.00 41.15           C  
ATOM   2705  CE1 HIS B 149     -59.034  23.693  -5.948  1.00 36.34           C  
ATOM   2706  NE2 HIS B 149     -59.266  22.972  -7.028  1.00 40.08           N  
ATOM   2707  N   THR B 150     -54.471  18.846  -4.843  1.00 35.77           N  
ATOM   2708  CA  THR B 150     -53.596  17.952  -4.096  1.00 35.38           C  
ATOM   2709  C   THR B 150     -52.118  18.336  -4.270  1.00 35.65           C  
ATOM   2710  O   THR B 150     -51.360  18.357  -3.303  1.00 33.70           O  
ATOM   2711  CB  THR B 150     -53.826  16.488  -4.507  1.00 36.80           C  
ATOM   2712  OG1 THR B 150     -55.222  16.169  -4.360  1.00 36.77           O  
ATOM   2713  CG2 THR B 150     -52.990  15.540  -3.630  1.00 35.46           C  
ATOM   2714  N   ILE B 151     -51.722  18.635  -5.503  1.00 34.17           N  
ATOM   2715  CA  ILE B 151     -50.405  19.214  -5.773  1.00 34.13           C  
ATOM   2716  C   ILE B 151     -50.214  20.484  -4.944  1.00 34.83           C  
ATOM   2717  O   ILE B 151     -49.229  20.603  -4.236  1.00 33.49           O  
ATOM   2718  CB  ILE B 151     -50.196  19.470  -7.295  1.00 34.02           C  
ATOM   2719  CG1 ILE B 151     -50.089  18.116  -8.037  1.00 34.66           C  
ATOM   2720  CG2 ILE B 151     -48.956  20.372  -7.553  1.00 35.39           C  
ATOM   2721  CD1 ILE B 151     -50.130  18.211  -9.530  1.00 37.11           C  
ATOM   2722  N   HIS B 152     -51.148  21.430  -5.004  1.00 35.64           N  
ATOM   2723  CA  HIS B 152     -50.959  22.657  -4.229  1.00 37.19           C  
ATOM   2724  C   HIS B 152     -50.900  22.381  -2.710  1.00 35.83           C  
ATOM   2725  O   HIS B 152     -50.092  22.979  -1.999  1.00 34.97           O  
ATOM   2726  CB  HIS B 152     -51.999  23.751  -4.538  1.00 37.02           C  
ATOM   2727  CG  HIS B 152     -51.782  24.991  -3.723  1.00 46.85           C  
ATOM   2728  ND1 HIS B 152     -50.792  25.905  -4.014  1.00 56.33           N  
ATOM   2729  CD2 HIS B 152     -52.347  25.408  -2.562  1.00 48.76           C  
ATOM   2730  CE1 HIS B 152     -50.793  26.860  -3.101  1.00 55.92           C  
ATOM   2731  NE2 HIS B 152     -51.724  26.581  -2.206  1.00 51.99           N  
ATOM   2732  N   TRP B 153     -51.762  21.490  -2.222  1.00 35.52           N  
ATOM   2733  CA  TRP B 153     -51.731  21.089  -0.808  1.00 35.91           C  
ATOM   2734  C   TRP B 153     -50.334  20.593  -0.370  1.00 35.35           C  
ATOM   2735  O   TRP B 153     -49.761  21.109   0.592  1.00 35.70           O  
ATOM   2736  CB  TRP B 153     -52.833  20.058  -0.516  1.00 34.66           C  
ATOM   2737  CG  TRP B 153     -52.752  19.407   0.853  1.00 38.67           C  
ATOM   2738  CD1 TRP B 153     -52.930  20.014   2.056  1.00 39.29           C  
ATOM   2739  CD2 TRP B 153     -52.493  18.020   1.139  1.00 38.58           C  
ATOM   2740  NE1 TRP B 153     -52.808  19.096   3.082  1.00 38.81           N  
ATOM   2741  CE2 TRP B 153     -52.522  17.869   2.547  1.00 41.53           C  
ATOM   2742  CE3 TRP B 153     -52.251  16.892   0.345  1.00 42.30           C  
ATOM   2743  CZ2 TRP B 153     -52.300  16.636   3.180  1.00 41.08           C  
ATOM   2744  CZ3 TRP B 153     -52.033  15.658   0.978  1.00 43.57           C  
ATOM   2745  CH2 TRP B 153     -52.058  15.548   2.380  1.00 42.70           C  
ATOM   2746  N   ILE B 154     -49.772  19.635  -1.101  1.00 34.62           N  
ATOM   2747  CA  ILE B 154     -48.469  19.061  -0.758  1.00 35.21           C  
ATOM   2748  C   ILE B 154     -47.324  20.090  -0.900  1.00 35.81           C  
ATOM   2749  O   ILE B 154     -46.415  20.190  -0.048  1.00 34.23           O  
ATOM   2750  CB  ILE B 154     -48.182  17.768  -1.612  1.00 35.13           C  
ATOM   2751  CG1 ILE B 154     -49.139  16.638  -1.225  1.00 32.49           C  
ATOM   2752  CG2 ILE B 154     -46.706  17.330  -1.483  1.00 34.65           C  
ATOM   2753  CD1 ILE B 154     -49.012  15.357  -2.090  1.00 27.50           C  
ATOM   2754  N   THR B 155     -47.378  20.877  -1.969  1.00 35.02           N  
ATOM   2755  CA  THR B 155     -46.402  21.933  -2.198  1.00 33.91           C  
ATOM   2756  C   THR B 155     -46.353  22.899  -1.003  1.00 34.94           C  
ATOM   2757  O   THR B 155     -45.273  23.292  -0.535  1.00 33.18           O  
ATOM   2758  CB  THR B 155     -46.745  22.671  -3.531  1.00 36.49           C  
ATOM   2759  OG1 THR B 155     -46.682  21.717  -4.616  1.00 39.10           O  
ATOM   2760  CG2 THR B 155     -45.784  23.835  -3.822  1.00 34.28           C  
ATOM   2761  N   SER B 156     -47.524  23.287  -0.510  1.00 34.21           N  
ATOM   2762  CA  SER B 156     -47.604  24.264   0.558  1.00 34.34           C  
ATOM   2763  C   SER B 156     -47.043  23.717   1.863  1.00 33.01           C  
ATOM   2764  O   SER B 156     -46.353  24.428   2.588  1.00 33.71           O  
ATOM   2765  CB  SER B 156     -49.044  24.762   0.740  1.00 34.77           C  
ATOM   2766  OG  SER B 156     -49.852  23.782   1.376  1.00 35.63           O  
ATOM   2767  N   ILE B 157     -47.330  22.456   2.163  1.00 34.40           N  
ATOM   2768  CA  ILE B 157     -46.853  21.877   3.423  1.00 36.43           C  
ATOM   2769  C   ILE B 157     -45.385  21.406   3.375  1.00 36.33           C  
ATOM   2770  O   ILE B 157     -44.645  21.573   4.347  1.00 37.14           O  
ATOM   2771  CB  ILE B 157     -47.800  20.773   3.954  1.00 37.52           C  
ATOM   2772  CG1 ILE B 157     -47.871  19.597   2.979  1.00 41.78           C  
ATOM   2773  CG2 ILE B 157     -49.205  21.360   4.205  1.00 38.50           C  
ATOM   2774  CD1 ILE B 157     -48.947  18.547   3.341  1.00 51.21           C  
ATOM   2775  N   VAL B 158     -44.967  20.832   2.250  1.00 33.77           N  
ATOM   2776  CA  VAL B 158     -43.629  20.265   2.145  1.00 33.92           C  
ATOM   2777  C   VAL B 158     -42.568  21.364   2.063  1.00 35.45           C  
ATOM   2778  O   VAL B 158     -41.440  21.197   2.564  1.00 34.51           O  
ATOM   2779  CB  VAL B 158     -43.521  19.268   0.943  1.00 35.48           C  
ATOM   2780  CG1 VAL B 158     -42.065  19.025   0.542  1.00 35.26           C  
ATOM   2781  CG2 VAL B 158     -44.183  17.956   1.323  1.00 32.81           C  
ATOM   2782  N   LEU B 159     -42.918  22.485   1.437  1.00 32.05           N  
ATOM   2783  CA  LEU B 159     -41.928  23.569   1.264  1.00 33.89           C  
ATOM   2784  C   LEU B 159     -41.901  24.584   2.393  1.00 32.46           C  
ATOM   2785  O   LEU B 159     -41.080  25.492   2.372  1.00 30.17           O  
ATOM   2786  CB  LEU B 159     -42.131  24.297  -0.066  1.00 32.40           C  
ATOM   2787  CG  LEU B 159     -42.022  23.429  -1.326  1.00 34.28           C  
ATOM   2788  CD1 LEU B 159     -42.203  24.292  -2.566  1.00 30.06           C  
ATOM   2789  CD2 LEU B 159     -40.667  22.727  -1.352  1.00 33.00           C  
ATOM   2790  N   PHE B 160     -42.818  24.461   3.352  1.00 31.69           N  
ATOM   2791  CA  PHE B 160     -42.906  25.446   4.421  1.00 32.33           C  
ATOM   2792  C   PHE B 160     -41.684  25.300   5.316  1.00 34.11           C  
ATOM   2793  O   PHE B 160     -41.486  24.229   5.910  1.00 33.71           O  
ATOM   2794  CB  PHE B 160     -44.203  25.263   5.222  1.00 33.81           C  
ATOM   2795  CG  PHE B 160     -44.428  26.319   6.246  1.00 33.75           C  
ATOM   2796  CD1 PHE B 160     -44.356  26.008   7.601  1.00 33.00           C  
ATOM   2797  CD2 PHE B 160     -44.693  27.639   5.858  1.00 32.32           C  
ATOM   2798  CE1 PHE B 160     -44.563  26.988   8.562  1.00 31.54           C  
ATOM   2799  CE2 PHE B 160     -44.896  28.629   6.804  1.00 33.22           C  
ATOM   2800  CZ  PHE B 160     -44.830  28.311   8.162  1.00 33.71           C  
ATOM   2801  N   PRO B 161     -40.868  26.370   5.428  1.00 34.16           N  
ATOM   2802  CA  PRO B 161     -39.551  26.274   6.051  1.00 36.41           C  
ATOM   2803  C   PRO B 161     -39.583  25.917   7.532  1.00 37.69           C  
ATOM   2804  O   PRO B 161     -38.571  25.469   8.071  1.00 39.60           O  
ATOM   2805  CB  PRO B 161     -38.967  27.680   5.859  1.00 34.00           C  
ATOM   2806  CG  PRO B 161     -40.140  28.564   5.730  1.00 35.36           C  
ATOM   2807  CD  PRO B 161     -41.158  27.748   4.989  1.00 36.40           C  
ATOM   2808  N   LYS B 162     -40.725  26.125   8.182  1.00 38.05           N  
ATOM   2809  CA  LYS B 162     -40.843  25.897   9.615  1.00 39.81           C  
ATOM   2810  C   LYS B 162     -41.654  24.649   9.917  1.00 41.08           C  
ATOM   2811  O   LYS B 162     -42.052  24.455  11.048  1.00 41.83           O  
ATOM   2812  CB  LYS B 162     -41.507  27.105  10.293  1.00 40.01           C  
ATOM   2813  CG  LYS B 162     -40.614  28.312  10.544  1.00 42.01           C  
ATOM   2814  CD  LYS B 162     -41.383  29.374  11.343  1.00 45.34           C  
ATOM   2815  CE  LYS B 162     -40.473  30.137  12.292  1.00 51.71           C  
ATOM   2816  NZ  LYS B 162     -41.240  30.833  13.374  1.00 49.03           N  
ATOM   2817  N   PHE B 163     -41.910  23.809   8.911  1.00 43.27           N  
ATOM   2818  CA  PHE B 163     -42.740  22.612   9.108  1.00 44.64           C  
ATOM   2819  C   PHE B 163     -42.244  21.706  10.239  1.00 45.05           C  
ATOM   2820  O   PHE B 163     -43.057  21.079  10.908  1.00 45.43           O  
ATOM   2821  CB  PHE B 163     -43.008  21.820   7.791  1.00 44.84           C  
ATOM   2822  CG  PHE B 163     -41.882  20.894   7.359  1.00 44.97           C  
ATOM   2823  CD1 PHE B 163     -41.539  19.767   8.122  1.00 43.14           C  
ATOM   2824  CD2 PHE B 163     -41.194  21.124   6.157  1.00 46.71           C  
ATOM   2825  CE1 PHE B 163     -40.504  18.910   7.720  1.00 44.41           C  
ATOM   2826  CE2 PHE B 163     -40.151  20.271   5.737  1.00 40.48           C  
ATOM   2827  CZ  PHE B 163     -39.807  19.165   6.519  1.00 45.38           C  
ATOM   2828  N   LYS B 164     -40.926  21.666  10.453  1.00 45.23           N  
ATOM   2829  CA  LYS B 164     -40.329  20.776  11.447  1.00 46.73           C  
ATOM   2830  C   LYS B 164     -40.685  21.198  12.868  1.00 47.27           C  
ATOM   2831  O   LYS B 164     -40.574  20.402  13.808  1.00 47.96           O  
ATOM   2832  CB  LYS B 164     -38.808  20.679  11.271  1.00 47.42           C  
ATOM   2833  CG  LYS B 164     -38.042  21.969  11.564  1.00 49.62           C  
ATOM   2834  CD  LYS B 164     -36.629  21.895  11.017  1.00 56.18           C  
ATOM   2835  CE  LYS B 164     -36.019  23.283  10.890  1.00 58.53           C  
ATOM   2836  NZ  LYS B 164     -34.824  23.290   9.997  1.00 56.71           N  
ATOM   2837  N   LYS B 165     -41.116  22.452  13.017  1.00 46.67           N  
ATOM   2838  CA  LYS B 165     -41.589  22.956  14.303  1.00 46.57           C  
ATOM   2839  C   LYS B 165     -43.038  22.540  14.554  1.00 45.33           C  
ATOM   2840  O   LYS B 165     -43.497  22.535  15.691  1.00 43.29           O  
ATOM   2841  CB  LYS B 165     -41.412  24.476  14.399  1.00 47.06           C  
ATOM   2842  CG  LYS B 165     -39.950  24.895  14.576  1.00 51.70           C  
ATOM   2843  CD  LYS B 165     -39.784  26.412  14.538  1.00 59.98           C  
ATOM   2844  CE  LYS B 165     -38.371  26.827  14.944  1.00 61.97           C  
ATOM   2845  NZ  LYS B 165     -38.184  28.311  14.980  1.00 61.52           N  
ATOM   2846  N   PHE B 166     -43.749  22.186  13.485  1.00 43.77           N  
ATOM   2847  CA  PHE B 166     -45.101  21.664  13.607  1.00 43.07           C  
ATOM   2848  C   PHE B 166     -45.136  20.125  13.626  1.00 41.91           C  
ATOM   2849  O   PHE B 166     -45.960  19.535  14.307  1.00 42.94           O  
ATOM   2850  CB  PHE B 166     -45.993  22.223  12.485  1.00 42.96           C  
ATOM   2851  CG  PHE B 166     -47.387  21.631  12.455  1.00 45.88           C  
ATOM   2852  CD1 PHE B 166     -48.338  21.995  13.411  1.00 44.54           C  
ATOM   2853  CD2 PHE B 166     -47.749  20.707  11.464  1.00 47.28           C  
ATOM   2854  CE1 PHE B 166     -49.633  21.443  13.393  1.00 40.31           C  
ATOM   2855  CE2 PHE B 166     -49.033  20.147  11.437  1.00 45.97           C  
ATOM   2856  CZ  PHE B 166     -49.976  20.515  12.408  1.00 40.22           C  
ATOM   2857  N   ILE B 167     -44.242  19.484  12.878  1.00 41.85           N  
ATOM   2858  CA  ILE B 167     -44.295  18.032  12.655  1.00 40.47           C  
ATOM   2859  C   ILE B 167     -42.933  17.467  12.210  1.00 40.03           C  
ATOM   2860  O   ILE B 167     -42.234  18.082  11.394  1.00 38.79           O  
ATOM   2861  CB  ILE B 167     -45.394  17.672  11.596  1.00 40.28           C  
ATOM   2862  CG1 ILE B 167     -45.604  16.152  11.503  1.00 39.92           C  
ATOM   2863  CG2 ILE B 167     -45.088  18.319  10.231  1.00 40.40           C  
ATOM   2864  CD1 ILE B 167     -46.810  15.721  10.667  1.00 40.64           C  
ATOM   2865  N   ASP B 168     -42.562  16.302  12.747  1.00 38.09           N  
ATOM   2866  CA  ASP B 168     -41.383  15.575  12.261  1.00 39.32           C  
ATOM   2867  C   ASP B 168     -41.502  15.231  10.769  1.00 40.79           C  
ATOM   2868  O   ASP B 168     -42.598  14.953  10.269  1.00 40.46           O  
ATOM   2869  CB  ASP B 168     -41.150  14.290  13.060  1.00 37.78           C  
ATOM   2870  CG  ASP B 168     -40.653  14.560  14.455  1.00 37.69           C  
ATOM   2871  OD1 ASP B 168     -40.368  15.728  14.775  1.00 36.72           O  
ATOM   2872  OD2 ASP B 168     -40.555  13.605  15.250  1.00 42.50           O  
ATOM   2873  N   SER B 169     -40.364  15.239  10.082  1.00 41.16           N  
ATOM   2874  CA  SER B 169     -40.292  14.927   8.653  1.00 43.20           C  
ATOM   2875  C   SER B 169     -40.840  13.545   8.260  1.00 42.06           C  
ATOM   2876  O   SER B 169     -41.667  13.444   7.352  1.00 42.45           O  
ATOM   2877  CB  SER B 169     -38.852  15.090   8.169  1.00 43.99           C  
ATOM   2878  OG  SER B 169     -38.533  16.473   8.125  1.00 50.70           O  
ATOM   2879  N   ALA B 170     -40.383  12.494   8.941  1.00 40.04           N  
ATOM   2880  CA  ALA B 170     -40.849  11.136   8.653  1.00 39.17           C  
ATOM   2881  C   ALA B 170     -42.355  10.999   8.864  1.00 38.96           C  
ATOM   2882  O   ALA B 170     -43.035  10.274   8.124  1.00 38.71           O  
ATOM   2883  CB  ALA B 170     -40.086  10.103   9.491  1.00 38.03           C  
ATOM   2884  N   ASP B 171     -42.868  11.717   9.860  1.00 38.88           N  
ATOM   2885  CA  ASP B 171     -44.290  11.721  10.153  1.00 39.34           C  
ATOM   2886  C   ASP B 171     -45.058  12.499   9.115  1.00 39.33           C  
ATOM   2887  O   ASP B 171     -46.167  12.107   8.745  1.00 40.20           O  
ATOM   2888  CB  ASP B 171     -44.562  12.301  11.539  1.00 40.66           C  
ATOM   2889  CG  ASP B 171     -44.009  11.430  12.656  1.00 46.41           C  
ATOM   2890  OD1 ASP B 171     -43.845  10.191  12.469  1.00 48.14           O  
ATOM   2891  OD2 ASP B 171     -43.740  11.996  13.738  1.00 58.80           O  
ATOM   2892  N   LEU B 172     -44.475  13.604   8.653  1.00 37.97           N  
ATOM   2893  CA  LEU B 172     -45.095  14.405   7.613  1.00 39.25           C  
ATOM   2894  C   LEU B 172     -45.276  13.562   6.352  1.00 38.09           C  
ATOM   2895  O   LEU B 172     -46.363  13.551   5.776  1.00 39.42           O  
ATOM   2896  CB  LEU B 172     -44.285  15.682   7.326  1.00 38.88           C  
ATOM   2897  CG  LEU B 172     -44.885  16.648   6.296  1.00 42.88           C  
ATOM   2898  CD1 LEU B 172     -46.352  17.027   6.645  1.00 34.53           C  
ATOM   2899  CD2 LEU B 172     -44.005  17.881   6.139  1.00 35.47           C  
ATOM   2900  N   VAL B 173     -44.219  12.844   5.960  1.00 37.35           N  
ATOM   2901  CA  VAL B 173     -44.241  11.928   4.812  1.00 35.55           C  
ATOM   2902  C   VAL B 173     -45.349  10.876   4.984  1.00 36.43           C  
ATOM   2903  O   VAL B 173     -46.192  10.727   4.104  1.00 35.45           O  
ATOM   2904  CB  VAL B 173     -42.851  11.258   4.574  1.00 36.44           C  
ATOM   2905  CG1 VAL B 173     -42.933  10.169   3.479  1.00 32.67           C  
ATOM   2906  CG2 VAL B 173     -41.791  12.315   4.191  1.00 34.01           C  
ATOM   2907  N   SER B 174     -45.350  10.184   6.128  1.00 36.54           N  
ATOM   2908  CA  SER B 174     -46.383   9.190   6.465  1.00 38.71           C  
ATOM   2909  C   SER B 174     -47.796   9.747   6.455  1.00 39.58           C  
ATOM   2910  O   SER B 174     -48.708   9.106   5.933  1.00 40.97           O  
ATOM   2911  CB  SER B 174     -46.117   8.569   7.833  1.00 37.91           C  
ATOM   2912  OG  SER B 174     -45.054   7.656   7.734  1.00 44.71           O  
ATOM   2913  N   ARG B 175     -47.976  10.925   7.050  1.00 39.01           N  
ATOM   2914  CA  ARG B 175     -49.297  11.533   7.160  1.00 39.72           C  
ATOM   2915  C   ARG B 175     -49.818  12.016   5.802  1.00 38.91           C  
ATOM   2916  O   ARG B 175     -51.021  11.954   5.535  1.00 38.31           O  
ATOM   2917  CB  ARG B 175     -49.294  12.677   8.174  1.00 39.49           C  
ATOM   2918  CG  ARG B 175     -49.065  12.239   9.610  1.00 44.87           C  
ATOM   2919  CD  ARG B 175     -49.532  13.316  10.604  1.00 56.96           C  
ATOM   2920  NE  ARG B 175     -50.983  13.271  10.811  1.00 63.12           N  
ATOM   2921  CZ  ARG B 175     -51.579  12.948  11.955  1.00 63.50           C  
ATOM   2922  NH1 ARG B 175     -52.902  12.925  12.021  1.00 64.56           N  
ATOM   2923  NH2 ARG B 175     -50.860  12.656  13.034  1.00 62.06           N  
ATOM   2924  N   ILE B 176     -48.916  12.497   4.947  1.00 37.65           N  
ATOM   2925  CA  ILE B 176     -49.315  12.886   3.595  1.00 36.34           C  
ATOM   2926  C   ILE B 176     -49.840  11.666   2.812  1.00 37.20           C  
ATOM   2927  O   ILE B 176     -50.905  11.720   2.199  1.00 40.43           O  
ATOM   2928  CB  ILE B 176     -48.181  13.610   2.843  1.00 34.95           C  
ATOM   2929  CG1 ILE B 176     -47.989  15.020   3.411  1.00 33.28           C  
ATOM   2930  CG2 ILE B 176     -48.480  13.655   1.338  1.00 32.28           C  
ATOM   2931  CD1 ILE B 176     -46.728  15.760   2.876  1.00 33.68           C  
ATOM   2932  N   ILE B 177     -49.100  10.568   2.869  1.00 37.14           N  
ATOM   2933  CA  ILE B 177     -49.464   9.340   2.188  1.00 37.68           C  
ATOM   2934  C   ILE B 177     -50.780   8.780   2.743  1.00 38.56           C  
ATOM   2935  O   ILE B 177     -51.657   8.387   1.973  1.00 40.97           O  
ATOM   2936  CB  ILE B 177     -48.317   8.302   2.296  1.00 37.66           C  
ATOM   2937  CG1 ILE B 177     -47.054   8.826   1.580  1.00 39.46           C  
ATOM   2938  CG2 ILE B 177     -48.775   6.910   1.765  1.00 39.21           C  
ATOM   2939  CD1 ILE B 177     -45.814   7.956   1.749  1.00 33.05           C  
ATOM   2940  N   SER B 178     -50.921   8.761   4.065  1.00 36.82           N  
ATOM   2941  CA  SER B 178     -52.160   8.297   4.713  1.00 38.16           C  
ATOM   2942  C   SER B 178     -53.390   9.042   4.234  1.00 38.14           C  
ATOM   2943  O   SER B 178     -54.419   8.429   3.967  1.00 37.70           O  
ATOM   2944  CB  SER B 178     -52.074   8.464   6.215  1.00 37.26           C  
ATOM   2945  OG  SER B 178     -51.263   7.459   6.750  1.00 43.74           O  
ATOM   2946  N   ALA B 179     -53.274  10.368   4.137  1.00 37.26           N  
ATOM   2947  CA  ALA B 179     -54.371  11.207   3.693  1.00 36.52           C  
ATOM   2948  C   ALA B 179     -54.790  10.854   2.274  1.00 36.40           C  
ATOM   2949  O   ALA B 179     -55.961  10.992   1.929  1.00 36.87           O  
ATOM   2950  CB  ALA B 179     -54.000  12.684   3.798  1.00 36.30           C  
ATOM   2951  N   LEU B 180     -53.836  10.393   1.464  1.00 35.59           N  
ATOM   2952  CA  LEU B 180     -54.129   9.997   0.085  1.00 36.65           C  
ATOM   2953  C   LEU B 180     -54.670   8.563  -0.056  1.00 37.97           C  
ATOM   2954  O   LEU B 180     -55.461   8.270  -0.964  1.00 37.69           O  
ATOM   2955  CB  LEU B 180     -52.893  10.185  -0.798  1.00 36.36           C  
ATOM   2956  CG  LEU B 180     -52.377  11.620  -0.920  1.00 37.80           C  
ATOM   2957  CD1 LEU B 180     -50.977  11.640  -1.503  1.00 43.17           C  
ATOM   2958  CD2 LEU B 180     -53.326  12.457  -1.776  1.00 32.01           C  
ATOM   2959  N   THR B 181     -54.255   7.682   0.850  1.00 38.51           N  
ATOM   2960  CA  THR B 181     -54.574   6.263   0.747  1.00 39.87           C  
ATOM   2961  C   THR B 181     -55.877   5.908   1.474  1.00 42.57           C  
ATOM   2962  O   THR B 181     -56.384   4.788   1.359  1.00 41.43           O  
ATOM   2963  CB  THR B 181     -53.408   5.396   1.279  1.00 40.17           C  
ATOM   2964  OG1 THR B 181     -53.065   5.827   2.602  1.00 36.97           O  
ATOM   2965  CG2 THR B 181     -52.183   5.535   0.370  1.00 36.53           C  
ATOM   2966  N   ASP B 182     -56.414   6.868   2.217  1.00 44.96           N  
ATOM   2967  CA  ASP B 182     -57.688   6.683   2.889  1.00 48.43           C  
ATOM   2968  C   ASP B 182     -58.824   6.629   1.860  1.00 49.69           C  
ATOM   2969  O   ASP B 182     -59.089   7.617   1.166  1.00 50.65           O  
ATOM   2970  CB  ASP B 182     -57.911   7.799   3.914  1.00 47.76           C  
ATOM   2971  CG  ASP B 182     -59.037   7.487   4.872  1.00 52.53           C  
ATOM   2972  OD1 ASP B 182     -59.340   6.287   5.083  1.00 53.76           O  
ATOM   2973  OD2 ASP B 182     -59.626   8.446   5.416  1.00 55.50           O  
ATOM   2974  N   LYS B 183     -59.473   5.465   1.756  1.00 51.04           N  
ATOM   2975  CA  LYS B 183     -60.503   5.224   0.740  1.00 52.23           C  
ATOM   2976  C   LYS B 183     -61.759   6.051   0.982  1.00 52.64           C  
ATOM   2977  O   LYS B 183     -62.321   6.038   2.080  1.00 53.37           O  
ATOM   2978  CB  LYS B 183     -60.864   3.738   0.662  1.00 52.18           C  
ATOM   2979  CG  LYS B 183     -59.945   2.897  -0.208  1.00 54.59           C  
ATOM   2980  CD  LYS B 183     -60.637   1.598  -0.610  1.00 61.23           C  
ATOM   2981  CE  LYS B 183     -59.716   0.653  -1.387  1.00 64.59           C  
ATOM   2982  NZ  LYS B 183     -59.294   1.179  -2.726  1.00 65.02           N  
TER    2983      LYS B 183                                                      
END
MOLECULE T0454.pdb
ATOM      1  N   ASP     5     -12.420  32.658   0.024  1.00 27.13           N
ATOM      2  CA  ASP     5     -13.312  32.598   1.217  1.00 27.34           C
ATOM      3  CB  ASP     5     -12.512  32.690   2.520  1.00 28.50           C
ATOM      4  CG  ASP     5     -13.404  32.599   3.759  1.00 30.42           C
ATOM      5  OD1 ASP     5     -14.289  31.706   3.803  1.00 33.47           O
ATOM      6  OD2 ASP     5     -13.226  33.430   4.680  1.00 32.05           O
ATOM      7  C   ASP     5     -14.424  33.644   1.238  1.00 26.73           C
ATOM      8  O   ASP     5     -15.477  33.398   1.835  1.00 26.63           O
ATOM      9  N   CYS     6     -14.211  34.799   0.611  0.50 26.41           N
ATOM     11  CA  CYS     6     -15.286  35.794   0.531  0.50 26.28           C
ATOM     13  CB  CYS     6     -14.751  37.198   0.241  0.50 26.57           C
ATOM     15  SG  CYS     6     -14.050  37.968   1.731  0.50 29.41           S
ATOM     17  C   CYS     6     -16.388  35.363  -0.439  0.50 25.38           C
ATOM     19  O   CYS     6     -17.496  35.901  -0.414  0.50 25.34           O
ATOM     21  N   ARG     7     -16.080  34.368  -1.271  1.00 24.45           N
ATOM     22  CA  ARG     7     -17.093  33.680  -2.080  1.00 22.28           C
ATOM     23  CB  ARG     7     -16.421  32.728  -3.079  1.00 22.90           C
ATOM     30  C   ARG     7     -18.066  32.903  -1.186  1.00 20.46           C
ATOM     31  O   ARG     7     -19.262  32.867  -1.449  1.00 20.43           O
ATOM     32  N   SER     8     -17.547  32.253  -0.148  0.50 19.10           N
ATOM     34  CA  SER     8     -18.391  31.436   0.731  0.50 17.33           C
ATOM     36  CB  SER     8     -17.550  30.493   1.586  0.50 17.45           C
ATOM     38  OG  SER     8     -18.312  29.968   2.658  0.50 15.65           O
ATOM     40  C   SER     8     -19.258  32.322   1.613  0.50 16.60           C
ATOM     42  O   SER     8     -20.455  32.084   1.776  0.50 15.91           O
ATOM     44  N   ARG     9     -18.645  33.365   2.159  0.50 15.61           N
ATOM     46  CA  ARG     9     -19.363  34.297   3.022  0.50 14.83           C
ATOM     48  CB  ARG     9     -18.372  35.205   3.766  0.50 15.25           C
ATOM     50  CG  ARG     9     -17.394  34.394   4.628  0.50 14.59           C
ATOM     52  CD  ARG     9     -16.768  35.163   5.795  0.50 16.76           C
ATOM     54  NE  ARG     9     -15.709  36.081   5.358  0.50 18.23           N
ATOM     56  CZ  ARG     9     -15.907  37.364   5.046  0.50 17.11           C
ATOM     58  NH1 ARG     9     -14.883  38.115   4.657  0.50 16.37           N
ATOM     60  NH2 ARG     9     -17.129  37.896   5.121  0.50 17.10           N
ATOM     62  C   ARG     9     -20.452  35.089   2.282  0.50 14.49           C
ATOM     64  O   ARG     9     -21.506  35.370   2.850  0.50 13.18           O
ATOM     66  N   LEU    10     -20.187  35.432   1.021  1.00 14.14           N
ATOM     67  CA  LEU    10     -21.183  36.018   0.143  1.00 15.70           C
ATOM     68  CB  LEU    10     -20.580  36.459  -1.201  1.00 16.55           C
ATOM     69  CG  LEU    10     -20.226  37.923  -1.321  1.00 18.07           C
ATOM     70  CD1 LEU    10     -19.435  38.165  -2.626  1.00 18.10           C
ATOM     71  CD2 LEU    10     -21.495  38.769  -1.285  1.00 16.77           C
ATOM     72  C   LEU    10     -22.364  35.072  -0.083  1.00 15.96           C
ATOM     73  O   LEU    10     -23.511  35.520  -0.035  1.00 16.63           O
ATOM     74  N   MET    11     -22.097  33.792  -0.326  0.70 16.06           N
ATOM     76  CA  MET    11     -23.179  32.843  -0.534  0.70 17.38           C
ATOM     78  CB  MET    11     -22.637  31.461  -0.863  0.70 20.17           C
ATOM     80  CG  MET    11     -22.166  31.316  -2.273  0.70 25.34           C
ATOM     82  SD  MET    11     -23.611  30.818  -3.503  0.70 46.93          SE
ATOM     84  CE  MET    11     -22.374  30.088  -4.856  0.70 32.85           C
ATOM     86  C   MET    11     -24.065  32.759   0.707  0.70 15.90           C
ATOM     88  O   MET    11     -25.298  32.724   0.592  0.70 14.79           O
ATOM     90  N   GLU    12     -23.436  32.726   1.888  1.00 13.16           N
ATOM     91  CA  GLU    12     -24.186  32.691   3.141  1.00 12.28           C
ATOM     92  CB  GLU    12     -23.255  32.550   4.367  1.00 11.62           C
ATOM     93  CG  GLU    12     -24.006  32.676   5.679  1.00 12.98           C
ATOM     94  CD  GLU    12     -24.899  31.451   5.972  1.00 17.78           C
ATOM     95  OE1 GLU    12     -24.548  30.339   5.520  1.00 20.61           O
ATOM     96  OE2 GLU    12     -25.952  31.593   6.636  1.00 18.33           O
ATOM     97  C   GLU    12     -25.062  33.946   3.278  1.00 11.77           C
ATOM     98  O   GLU    12     -26.263  33.868   3.569  1.00 10.95           O
ATOM     99  N   VAL    13     -24.441  35.104   3.102  1.00 11.38           N
ATOM    100  CA  VAL    13     -25.143  36.347   3.297  1.00 11.79           C
ATOM    101  CB  VAL    13     -24.168  37.555   3.216  1.00 11.85           C
ATOM    102  CG1 VAL    13     -24.903  38.816   2.771  1.00 13.25           C
ATOM    103  CG2 VAL    13     -23.437  37.739   4.528  1.00 12.09           C
ATOM    104  C   VAL    13     -26.264  36.469   2.270  1.00 12.08           C
ATOM    105  O   VAL    13     -27.360  36.860   2.613  1.00 12.20           O
ATOM    106  N   ALA    14     -25.987  36.132   1.016  1.00 11.94           N
ATOM    107  CA  ALA    14     -27.028  36.192  -0.026  1.00 12.57           C
ATOM    108  CB  ALA    14     -26.434  35.847  -1.397  1.00 12.81           C
ATOM    109  C   ALA    14     -28.224  35.272   0.324  1.00 12.70           C
ATOM    110  O   ALA    14     -29.404  35.681   0.225  1.00 12.49           O
ATOM    111  N   THR    15     -27.933  34.045   0.752  1.00 12.08           N
ATOM    112  CA  THR    15     -29.000  33.092   1.088  1.00 13.57           C
ATOM    113  CB  THR    15     -28.420  31.727   1.526  1.00 13.02           C
ATOM    114  OG1 THR    15     -27.592  31.204   0.477  1.00 13.54           O
ATOM    115  CG2 THR    15     -29.544  30.705   1.864  1.00 14.11           C
ATOM    116  C   THR    15     -29.885  33.685   2.197  1.00 13.81           C
ATOM    117  O   THR    15     -31.100  33.676   2.080  1.00 14.69           O
ATOM    118  N   GLU    16     -29.283  34.229   3.251  0.50 12.86           N
ATOM    120  CA  GLU    16     -30.060  34.743   4.392  0.50 12.65           C
ATOM    122  CB  GLU    16     -29.168  34.850   5.619  0.50 11.98           C
ATOM    124  CG  GLU    16     -28.366  33.560   5.847  0.50 10.56           C
ATOM    126  CD  GLU    16     -29.193  32.437   6.436  0.50 10.50           C
ATOM    128  OE1 GLU    16     -29.690  32.653   7.554  0.50 13.56           O
ATOM    130  OE2 GLU    16     -29.343  31.334   5.814  0.50  9.37           O
ATOM    132  C   GLU    16     -30.844  36.053   4.135  0.50 13.06           C
ATOM    134  O   GLU    16     -31.941  36.247   4.680  0.50 12.44           O
ATOM    136  N   LEU    17     -30.289  36.937   3.304  1.00 13.39           N
ATOM    137  CA  LEU    17     -30.999  38.157   2.904  1.00 13.60           C
ATOM    138  CB  LEU    17     -30.022  39.257   2.439  1.00 13.92           C
ATOM    139  CG  LEU    17     -29.168  39.859   3.564  1.00 15.45           C
ATOM    140  CD1 LEU    17     -28.242  40.964   3.019  1.00 18.76           C
ATOM    141  CD2 LEU    17     -30.008  40.355   4.753  1.00 18.21           C
ATOM    142  C   LEU    17     -32.079  37.907   1.841  1.00 13.42           C
ATOM    143  O   LEU    17     -33.201  38.400   2.004  1.00 13.35           O
ATOM    144  N   PHE    18     -31.772  37.132   0.800  1.00 12.52           N
ATOM    145  CA  PHE    18     -32.789  36.767  -0.188  1.00 12.55           C
ATOM    146  CB  PHE    18     -32.168  36.032  -1.355  1.00 12.74           C
ATOM    147  CG  PHE    18     -31.341  36.895  -2.267  1.00 11.67           C
ATOM    148  CD1 PHE    18     -31.865  38.079  -2.813  1.00 12.22           C
ATOM    149  CE1 PHE    18     -31.138  38.864  -3.706  1.00 12.93           C
ATOM    150  CZ  PHE    18     -29.843  38.455  -4.104  1.00 13.62           C
ATOM    151  CE2 PHE    18     -29.308  37.240  -3.582  1.00 11.19           C
ATOM    152  CD2 PHE    18     -30.083  36.472  -2.677  1.00 11.90           C
ATOM    153  C   PHE    18     -33.889  35.866   0.419  1.00 13.51           C
ATOM    154  O   PHE    18     -35.054  35.962   0.015  1.00 15.25           O
ATOM    155  N   ALA    19     -33.532  34.996   1.373  1.00 13.39           N
ATOM    156  CA  ALA    19     -34.553  34.208   2.061  1.00 15.05           C
ATOM    157  CB  ALA    19     -33.942  33.133   2.992  1.00 14.27           C
ATOM    158  C   ALA    19     -35.536  35.094   2.817  1.00 15.36           C
ATOM    159  O   ALA    19     -36.754  34.842   2.737  1.00 16.78           O
ATOM    160  N   GLN    20     -35.009  36.097   3.541  0.70 16.27           N
ATOM    162  CA  GLN    20     -35.806  37.053   4.335  0.70 16.80           C
ATOM    164  CB  GLN    20     -34.946  37.989   5.239  0.70 17.01           C
ATOM    166  CG  GLN    20     -35.745  39.306   5.640  0.70 16.81           C
ATOM    168  CD  GLN    20     -35.206  40.143   6.812  0.70 17.74           C
ATOM    170  OE1 GLN    20     -35.154  41.393   6.736  0.70 13.85           O
ATOM    172  NE2 GLN    20     -34.830  39.472   7.903  0.70 18.70           N
ATOM    174  C   GLN    20     -36.691  37.941   3.482  0.70 17.07           C
ATOM    176  O   GLN    20     -37.900  38.009   3.701  0.70 17.23           O
ATOM    178  N   LYS    21     -36.060  38.636   2.537  1.00 15.44           N
ATOM    179  CA  LYS    21     -36.656  39.778   1.820  1.00 16.20           C
ATOM    180  CB  LYS    21     -35.693  40.954   1.797  1.00 16.65           C
ATOM    181  CG  LYS    21     -35.259  41.391   3.184  1.00 19.64           C
ATOM    182  CD  LYS    21     -34.363  42.583   3.043  1.00 22.59           C
ATOM    183  CE  LYS    21     -33.720  42.901   4.359  1.00 25.71           C
ATOM    184  NZ  LYS    21     -33.292  44.316   4.378  1.00 29.79           N
ATOM    185  C   LYS    21     -37.021  39.482   0.389  1.00 15.03           C
ATOM    186  O   LYS    21     -37.639  40.317  -0.275  1.00 16.30           O
ATOM    187  N   GLY    22     -36.632  38.313  -0.101  1.00 14.81           N
ATOM    188  CA  GLY    22     -36.879  37.954  -1.501  1.00 12.41           C
ATOM    189  C   GLY    22     -35.967  38.743  -2.431  1.00 13.23           C
ATOM    190  O   GLY    22     -35.355  39.762  -2.034  1.00 13.65           O
ATOM    191  N   PHE    23     -35.857  38.255  -3.660  1.00 12.90           N
ATOM    192  CA  PHE    23     -35.064  38.952  -4.675  1.00 13.24           C
ATOM    193  CB  PHE    23     -35.255  38.297  -6.043  1.00 15.31           C
ATOM    194  CG  PHE    23     -34.544  39.016  -7.130  1.00 16.26           C
ATOM    195  CD1 PHE    23     -33.214  38.729  -7.414  1.00 17.28           C
ATOM    196  CE1 PHE    23     -32.528  39.446  -8.406  1.00 17.88           C
ATOM    197  CZ  PHE    23     -33.173  40.390  -9.137  1.00 18.69           C
ATOM    198  CE2 PHE    23     -34.531  40.677  -8.884  1.00 18.23           C
ATOM    199  CD2 PHE    23     -35.193  40.000  -7.883  1.00 18.32           C
ATOM    200  C   PHE    23     -35.468  40.425  -4.758  1.00 14.16           C
ATOM    201  O   PHE    23     -34.604  41.312  -4.880  1.00 14.45           O
ATOM    202  N   TYR    24     -36.778  40.690  -4.743  1.00 14.52           N
ATOM    203  CA  TYR    24     -37.263  42.057  -4.998  1.00 15.59           C
ATOM    204  CB  TYR    24     -38.733  42.085  -5.422  1.00 13.51           C
ATOM    205  CG  TYR    24     -38.963  41.406  -6.781  1.00 13.47           C
ATOM    206  CD1 TYR    24     -38.665  42.064  -7.967  1.00 12.55           C
ATOM    207  CE1 TYR    24     -38.890  41.458  -9.241  1.00 13.28           C
ATOM    208  CZ  TYR    24     -39.399  40.139  -9.303  1.00 10.43           C
ATOM    209  OH  TYR    24     -39.630  39.577 -10.572  1.00 11.31           O
ATOM    210  CE2 TYR    24     -39.713  39.475  -8.126  1.00 11.68           C
ATOM    211  CD2 TYR    24     -39.493  40.106  -6.858  1.00 14.21           C
ATOM    212  C   TYR    24     -37.080  42.970  -3.806  1.00 16.80           C
ATOM    213  O   TYR    24     -37.286  44.167  -3.939  1.00 18.89           O
ATOM    214  N   GLY    25     -36.702  42.429  -2.656  1.00 16.86           N
ATOM    215  CA  GLY    25     -36.488  43.287  -1.478  1.00 17.30           C
ATOM    216  C   GLY    25     -35.036  43.519  -1.070  1.00 18.19           C
ATOM    217  O   GLY    25     -34.787  44.141  -0.042  1.00 18.97           O
ATOM    218  N   VAL    26     -34.080  42.983  -1.822  1.00 17.80           N
ATOM    219  CA  VAL    26     -32.653  43.017  -1.434  1.00 17.86           C
ATOM    220  CB  VAL    26     -32.053  41.567  -1.526  1.00 16.88           C
ATOM    221  CG1 VAL    26     -30.493  41.578  -1.523  1.00 19.19           C
ATOM    222  CG2 VAL    26     -32.546  40.691  -0.382  1.00 17.09           C
ATOM    223  C   VAL    26     -31.896  43.951  -2.405  1.00 18.57           C
ATOM    224  O   VAL    26     -32.112  43.860  -3.619  1.00 19.26           O
ATOM    225  N   SER    27     -31.024  44.837  -1.900  1.00 18.29           N
ATOM    226  CA  SER    27     -30.188  45.651  -2.802  1.00 18.73           C
ATOM    227  CB  SER    27     -30.240  47.135  -2.451  1.00 18.20           C
ATOM    228  OG  SER    27     -29.499  47.385  -1.297  1.00 19.53           O
ATOM    229  C   SER    27     -28.743  45.196  -2.781  1.00 18.39           C
ATOM    230  O   SER    27     -28.296  44.592  -1.823  1.00 18.07           O
ATOM    231  N   ILE    28     -28.001  45.507  -3.836  1.00 18.31           N
ATOM    232  CA  ILE    28     -26.587  45.151  -3.866  1.00 18.54           C
ATOM    233  CB  ILE    28     -25.953  45.425  -5.232  1.00 18.62           C
ATOM    234  CG1 ILE    28     -24.599  44.703  -5.348  1.00 18.14           C
ATOM    235  CD1 ILE    28     -23.953  44.785  -6.743  1.00 19.13           C
ATOM    236  CG2 ILE    28     -25.915  46.963  -5.537  1.00 18.10           C
ATOM    237  C   ILE    28     -25.825  45.846  -2.714  1.00 18.97           C
ATOM    238  O   ILE    28     -24.902  45.274  -2.156  1.00 17.66           O
ATOM    239  N   ARG    29     -26.211  47.076  -2.360  1.00 19.97           N
ATOM    240  CA  ARG    29     -25.589  47.737  -1.207  1.00 22.13           C
ATOM    241  CB  ARG    29     -26.120  49.174  -1.012  1.00 21.53           C
ATOM    242  CG  ARG    29     -25.467  49.925   0.170  1.00 25.16           C
ATOM    243  CD  ARG    29     -26.316  51.109   0.743  1.00 26.22           C
ATOM    244  NE  ARG    29     -27.682  50.707   1.142  1.00 35.15           N
ATOM    245  CZ  ARG    29     -28.010  50.032   2.256  1.00 36.75           C
ATOM    246  NH1 ARG    29     -27.084  49.650   3.137  1.00 38.29           N
ATOM    247  NH2 ARG    29     -29.285  49.730   2.492  1.00 38.04           N
ATOM    248  C   ARG    29     -25.725  46.902   0.085  1.00 21.09           C
ATOM    249  O   ARG    29     -24.730  46.691   0.798  1.00 19.92           O
ATOM    250  N   GLU    30     -26.937  46.412   0.371  1.00 22.16           N
ATOM    251  CA  GLU    30     -27.160  45.541   1.551  1.00 22.56           C
ATOM    252  CB  GLU    30     -28.618  45.119   1.693  1.00 23.46           C
ATOM    253  CG  GLU    30     -29.623  46.242   1.841  1.00 28.08           C
ATOM    254  CD  GLU    30     -31.046  45.786   1.483  1.00 34.28           C
ATOM    255  OE1 GLU    30     -31.275  44.555   1.368  1.00 33.74           O
ATOM    256  OE2 GLU    30     -31.935  46.662   1.307  1.00 37.15           O
ATOM    257  C   GLU    30     -26.301  44.272   1.533  1.00 21.44           C
ATOM    258  O   GLU    30     -25.795  43.856   2.577  1.00 21.23           O
ATOM    259  N   LEU    31     -26.170  43.640   0.359  1.00 19.98           N
ATOM    260  CA  LEU    31     -25.338  42.431   0.251  1.00 18.96           C
ATOM    261  CB  LEU    31     -25.426  41.823  -1.145  1.00 18.00           C
ATOM    262  CG  LEU    31     -26.768  41.239  -1.562  1.00 18.12           C
ATOM    263  CD1 LEU    31     -26.678  40.931  -3.057  1.00 16.01           C
ATOM    264  CD2 LEU    31     -27.078  39.993  -0.744  1.00 18.33           C
ATOM    265  C   LEU    31     -23.871  42.715   0.588  1.00 18.24           C
ATOM    266  O   LEU    31     -23.227  41.984   1.363  1.00 18.55           O
ATOM    267  N   ALA    32     -23.328  43.776  -0.005  1.00 18.07           N
ATOM    268  CA  ALA    32     -21.928  44.131   0.234  1.00 17.87           C
ATOM    269  CB  ALA    32     -21.533  45.282  -0.659  1.00 17.05           C
ATOM    270  C   ALA    32     -21.689  44.449   1.719  1.00 18.48           C
ATOM    271  O   ALA    32     -20.741  43.938   2.338  1.00 18.50           O
ATOM    272  N   GLN    33     -22.577  45.264   2.282  1.00 18.14           N
ATOM    273  CA  GLN    33     -22.467  45.687   3.672  1.00 18.66           C
ATOM    274  CB  GLN    33     -23.613  46.652   4.012  1.00 18.81           C
ATOM    279  C   GLN    33     -22.496  44.452   4.579  1.00 18.25           C
ATOM    280  O   GLN    33     -21.649  44.307   5.470  1.00 19.06           O
ATOM    281  N   ALA    34     -23.456  43.552   4.355  1.00 18.35           N
ATOM    282  CA  ALA    34     -23.588  42.387   5.224  1.00 17.57           C
ATOM    283  CB  ALA    34     -24.915  41.670   4.988  1.00 18.88           C
ATOM    284  C   ALA    34     -22.400  41.424   5.094  1.00 17.93           C
ATOM    285  O   ALA    34     -22.007  40.800   6.073  1.00 18.07           O
ATOM    286  N   ALA    35     -21.812  41.324   3.902  1.00 17.59           N
ATOM    287  CA  ALA    35     -20.653  40.434   3.662  1.00 17.45           C
ATOM    288  CB  ALA    35     -20.742  39.832   2.241  1.00 17.60           C
ATOM    289  C   ALA    35     -19.271  41.084   3.858  1.00 17.39           C
ATOM    290  O   ALA    35     -18.253  40.386   3.869  1.00 17.10           O
ATOM    291  N   GLY    36     -19.216  42.410   3.975  1.00 17.53           N
ATOM    292  CA  GLY    36     -17.934  43.120   4.053  1.00 17.54           C
ATOM    293  C   GLY    36     -17.142  43.046   2.755  1.00 18.20           C
ATOM    294  O   GLY    36     -15.894  43.109   2.760  1.00 18.83           O
ATOM    295  N   ALA    37     -17.868  42.917   1.638  1.00 18.05           N
ATOM    296  CA  ALA    37     -17.298  42.947   0.287  1.00 17.70           C
ATOM    297  CB  ALA    37     -17.905  41.813  -0.553  1.00 17.69           C
ATOM    298  C   ALA    37     -17.594  44.299  -0.377  1.00 17.25           C
ATOM    299  O   ALA    37     -18.512  44.995   0.029  1.00 17.90           O
ATOM    300  N   SER    38     -16.844  44.680  -1.401  1.00 16.01           N
ATOM    301  CA  SER    38     -17.181  45.941  -2.083  1.00 15.66           C
ATOM    302  CB  SER    38     -15.986  46.530  -2.815  1.00 15.99           C
ATOM    303  OG  SER    38     -15.465  45.574  -3.709  1.00 15.63           O
ATOM    304  C   SER    38     -18.275  45.670  -3.090  1.00 15.23           C
ATOM    305  O   SER    38     -18.390  44.545  -3.568  1.00 14.69           O
ATOM    306  N   ILE    39     -19.054  46.696  -3.426  1.00 14.99           N
ATOM    307  CA  ILE    39     -20.019  46.586  -4.524  1.00 16.34           C
ATOM    308  CB  ILE    39     -20.795  47.908  -4.725  1.00 18.03           C
ATOM    309  CG1 ILE    39     -21.771  48.099  -3.551  1.00 18.95           C
ATOM    310  CD1 ILE    39     -22.260  49.551  -3.403  1.00 24.07           C
ATOM    311  CG2 ILE    39     -21.568  47.905  -6.053  1.00 19.22           C
ATOM    312  C   ILE    39     -19.321  46.142  -5.820  1.00 14.71           C
ATOM    313  O   ILE    39     -19.846  45.293  -6.544  1.00 14.07           O
ATOM    314  N   SER    40     -18.089  46.604  -6.010  0.50 14.67           N
ATOM    316  CA  SER    40     -17.279  46.176  -7.148  0.50 14.62           C
ATOM    318  CB  SER    40     -16.053  47.060  -7.335  0.50 14.94           C
ATOM    320  OG  SER    40     -16.458  48.367  -7.690  0.50 15.23           O
ATOM    322  C   SER    40     -16.894  44.691  -7.144  0.50 14.74           C
ATOM    324  O   SER    40     -17.018  44.048  -8.190  0.50 13.11           O
ATOM    326  N   MET    41     -16.429  44.140  -6.011  0.70 14.50           N
ATOM    328  CA  MET    41     -16.178  42.699  -5.979  0.70 17.69           C
ATOM    330  CB  MET    41     -15.783  42.221  -4.589  0.70 17.10           C
ATOM    332  CG  MET    41     -14.312  42.342  -4.347  0.70 22.14           C
ATOM    334  SD  MET    41     -13.942  42.349  -2.431  0.70 31.19          SE
ATOM    336  CE  MET    41     -12.415  43.576  -2.469  0.70 24.49           C
ATOM    338  C   MET    41     -17.447  41.995  -6.467  0.70 13.85           C
ATOM    340  O   MET    41     -17.391  41.116  -7.335  0.70 12.19           O
ATOM    342  N   ILE    42     -18.586  42.445  -5.946  1.00 11.54           N
ATOM    343  CA  ILE    42     -19.860  41.745  -6.191  1.00 10.80           C
ATOM    344  CB  ILE    42     -21.001  42.280  -5.316  1.00 11.27           C
ATOM    345  CG1 ILE    42     -20.695  41.978  -3.842  1.00 13.93           C
ATOM    346  CD1 ILE    42     -21.839  42.300  -2.903  1.00 16.88           C
ATOM    347  CG2 ILE    42     -22.327  41.616  -5.716  1.00 12.87           C
ATOM    348  C   ILE    42     -20.219  41.838  -7.658  1.00  8.83           C
ATOM    349  O   ILE    42     -20.497  40.819  -8.306  1.00  9.33           O
ATOM    350  N   SER    43     -20.157  43.052  -8.211  1.00  8.95           N
ATOM    351  CA  SER    43     -20.581  43.239  -9.602  1.00  9.74           C
ATOM    352  CB  SER    43     -20.655  44.729  -9.931  1.00 10.68           C
ATOM    353  OG  SER    43     -21.770  45.278  -9.279  1.00 13.08           O
ATOM    354  C   SER    43     -19.645  42.587 -10.619  1.00  9.62           C
ATOM    355  O   SER    43     -20.105  42.053 -11.624  1.00  9.13           O
ATOM    356  N   TYR    44     -18.328  42.697 -10.382  1.00  9.20           N
ATOM    357  CA  TYR    44     -17.361  42.244 -11.376  1.00 10.08           C
ATOM    358  CB  TYR    44     -16.121  43.137 -11.344  1.00  9.76           C
ATOM    359  CG  TYR    44     -16.373  44.487 -11.942  1.00  8.65           C
ATOM    360  CD1 TYR    44     -16.965  45.500 -11.184  1.00  8.93           C
ATOM    361  CE1 TYR    44     -17.202  46.730 -11.711  1.00 10.45           C
ATOM    362  CZ  TYR    44     -16.853  46.987 -13.027  1.00 10.79           C
ATOM    363  OH  TYR    44     -17.090  48.220 -13.553  1.00 11.57           O
ATOM    364  CE2 TYR    44     -16.260  46.002 -13.818  1.00 10.86           C
ATOM    365  CD2 TYR    44     -16.019  44.758 -13.255  1.00  9.35           C
ATOM    366  C   TYR    44     -16.923  40.795 -11.222  1.00 12.28           C
ATOM    367  O   TYR    44     -16.468  40.193 -12.203  1.00 12.21           O
ATOM    368  N   HIS    45     -16.993  40.271 -10.000  1.00 14.53           N
ATOM    369  CA  HIS    45     -16.489  38.928  -9.730  1.00 17.90           C
ATOM    370  CB  HIS    45     -15.347  38.951  -8.714  1.00 18.81           C
ATOM    371  CG  HIS    45     -14.062  39.424  -9.294  1.00 21.69           C
ATOM    372  ND1 HIS    45     -13.118  40.111  -8.564  1.00 26.38           N
ATOM    373  CE1 HIS    45     -12.092  40.405  -9.346  1.00 27.60           C
ATOM    374  NE2 HIS    45     -12.350  39.958 -10.563  1.00 26.67           N
ATOM    375  CD2 HIS    45     -13.574  39.339 -10.558  1.00 25.29           C
ATOM    376  C   HIS    45     -17.532  37.898  -9.348  1.00 19.42           C
ATOM    377  O   HIS    45     -17.334  36.722  -9.630  1.00 19.75           O
ATOM    378  N   PHE    46     -18.630  38.324  -8.726  1.00 20.52           N
ATOM    379  CA  PHE    46     -19.661  37.377  -8.261  1.00 22.82           C
ATOM    380  CB  PHE    46     -19.800  37.465  -6.732  1.00 23.98           C
ATOM    381  CG  PHE    46     -18.496  37.308  -6.003  1.00 26.04           C
ATOM    382  CD1 PHE    46     -18.012  36.039  -5.670  1.00 29.01           C
ATOM    383  CE1 PHE    46     -16.817  35.893  -5.005  1.00 27.12           C
ATOM    384  CZ  PHE    46     -16.071  37.013  -4.649  1.00 28.27           C
ATOM    385  CE2 PHE    46     -16.542  38.280  -4.963  1.00 29.34           C
ATOM    386  CD2 PHE    46     -17.743  38.419  -5.640  1.00 27.17           C
ATOM    387  C   PHE    46     -21.004  37.504  -8.954  1.00 22.70           C
ATOM    388  O   PHE    46     -22.017  36.978  -8.483  1.00 25.73           O
ATOM    389  N   GLY    47     -21.020  38.197 -10.083  1.00 20.71           N
ATOM    390  CA  GLY    47     -22.178  38.260 -10.943  1.00 19.73           C
ATOM    391  C   GLY    47     -23.257  39.227 -10.550  1.00 18.52           C
ATOM    392  O   GLY    47     -24.373  39.148 -11.073  1.00 20.99           O
ATOM    393  N   GLY    48     -22.955  40.137  -9.620  1.00 14.66           N
ATOM    394  CA  GLY    48     -23.926  41.115  -9.145  1.00 14.41           C
ATOM    395  C   GLY    48     -25.035  40.479  -8.295  1.00 13.29           C
ATOM    396  O   GLY    48     -24.959  39.296  -7.948  1.00 12.06           O
ATOM    397  N   LYS    49     -26.021  41.290  -7.929  1.00 13.51           N
ATOM    398  CA  LYS    49     -27.206  40.794  -7.200  1.00 13.00           C
ATOM    399  CB  LYS    49     -28.212  41.934  -7.086  1.00 14.01           C
ATOM    400  CG  LYS    49     -29.503  41.518  -6.350  1.00 15.37           C
ATOM    401  CD  LYS    49     -30.528  42.649  -6.447  1.00 16.73           C
ATOM    402  CE  LYS    49     -31.905  42.078  -6.083  1.00 17.71           C
ATOM    403  NZ  LYS    49     -32.895  43.218  -6.101  1.00 18.77           N
ATOM    404  C   LYS    49     -27.809  39.595  -7.932  1.00 13.68           C
ATOM    405  O   LYS    49     -28.212  38.583  -7.331  1.00 13.27           O
ATOM    406  N   GLU    50     -27.876  39.703  -9.258  1.00 12.63           N
ATOM    407  CA  GLU    50     -28.627  38.725 -10.042  1.00 12.69           C
ATOM    408  CB  GLU    50     -28.814  39.232 -11.468  1.00 13.68           C
ATOM    409  CG  GLU    50     -29.657  40.500 -11.528  1.00 14.16           C
ATOM    410  CD  GLU    50     -28.887  41.815 -11.286  1.00 16.98           C
ATOM    411  OE1 GLU    50     -27.638  41.867 -11.018  1.00 15.01           O
ATOM    412  OE2 GLU    50     -29.566  42.854 -11.451  1.00 19.39           O
ATOM    413  C   GLU    50     -27.883  37.393 -10.048  1.00 12.35           C
ATOM    414  O   GLU    50     -28.506  36.350  -9.816  1.00 13.25           O
ATOM    415  N   GLY    51     -26.567  37.455 -10.306  1.00 11.97           N
ATOM    416  CA  GLY    51     -25.695  36.286 -10.303  1.00 11.39           C
ATOM    417  C   GLY    51     -25.724  35.592  -8.952  1.00 13.31           C
ATOM    418  O   GLY    51     -25.865  34.369  -8.874  1.00 12.68           O
ATOM    419  N   LEU    52     -25.637  36.365  -7.877  1.00 12.96           N
ATOM    420  CA  LEU    52     -25.702  35.752  -6.544  1.00 13.84           C
ATOM    421  CB  LEU    52     -25.453  36.774  -5.450  1.00 13.00           C
ATOM    422  CG  LEU    52     -24.017  37.257  -5.300  1.00 15.32           C
ATOM    423  CD1 LEU    52     -24.026  38.415  -4.321  1.00 17.15           C
ATOM    424  CD2 LEU    52     -23.089  36.110  -4.862  1.00 13.25           C
ATOM    425  C   LEU    52     -27.047  35.092  -6.282  1.00 13.75           C
ATOM    426  O   LEU    52     -27.092  34.016  -5.680  1.00 14.21           O
ATOM    427  N   TYR    53     -28.140  35.744  -6.693  1.00 14.29           N
ATOM    428  CA  TYR    53     -29.441  35.176  -6.517  1.00 14.44           C
ATOM    429  CB  TYR    53     -30.541  36.161  -6.936  1.00 12.90           C
ATOM    430  CG  TYR    53     -31.928  35.606  -6.681  1.00 13.47           C
ATOM    431  CD1 TYR    53     -32.405  35.437  -5.365  1.00 13.59           C
ATOM    432  CE1 TYR    53     -33.679  34.910  -5.123  1.00 14.34           C
ATOM    433  CZ  TYR    53     -34.477  34.537  -6.198  1.00 13.72           C
ATOM    434  OH  TYR    53     -35.718  34.039  -5.965  1.00 13.83           O
ATOM    435  CE2 TYR    53     -34.023  34.711  -7.525  1.00 13.18           C
ATOM    436  CD2 TYR    53     -32.751  35.220  -7.740  1.00 11.75           C
ATOM    437  C   TYR    53     -29.578  33.863  -7.306  1.00 14.35           C
ATOM    438  O   TYR    53     -30.064  32.892  -6.754  1.00 14.84           O
ATOM    439  N   ALA    54     -29.125  33.849  -8.569  1.00 14.57           N
ATOM    440  CA  ALA    54     -29.145  32.612  -9.394  1.00 14.76           C
ATOM    441  CB  ALA    54     -28.572  32.882 -10.785  1.00 15.38           C
ATOM    442  C   ALA    54     -28.382  31.465  -8.737  1.00 16.02           C
ATOM    443  O   ALA    54     -28.853  30.302  -8.752  1.00 16.58           O
ATOM    444  N   ALA    55     -27.206  31.790  -8.179  1.00 15.71           N
ATOM    445  CA  ALA    55     -26.349  30.797  -7.512  1.00 16.60           C
ATOM    446  CB  ALA    55     -24.985  31.418  -7.114  1.00 15.94           C
ATOM    447  C   ALA    55     -27.087  30.239  -6.293  1.00 16.62           C
ATOM    448  O   ALA    55     -27.124  29.027  -6.079  1.00 17.79           O
ATOM    449  N   VAL    56     -27.698  31.121  -5.509  1.00 16.55           N
ATOM    450  CA  VAL    56     -28.442  30.724  -4.309  1.00 17.16           C
ATOM    451  CB  VAL    56     -28.958  31.984  -3.551  1.00 17.77           C
ATOM    452  CG1 VAL    56     -30.068  31.623  -2.591  1.00 18.51           C
ATOM    453  CG2 VAL    56     -27.808  32.716  -2.799  1.00 16.47           C
ATOM    454  C   VAL    56     -29.643  29.805  -4.680  1.00 17.90           C
ATOM    455  O   VAL    56     -29.872  28.769  -4.064  1.00 18.42           O
ATOM    456  N   LEU    57     -30.409  30.209  -5.690  1.00 18.83           N
ATOM    457  CA  LEU    57     -31.588  29.428  -6.064  1.00 20.44           C
ATOM    458  CB  LEU    57     -32.429  30.224  -7.058  1.00 19.98           C
ATOM    459  CG  LEU    57     -33.922  29.962  -7.106  1.00 25.44           C
ATOM    460  CD1 LEU    57     -34.592  30.145  -5.755  1.00 24.83           C
ATOM    461  CD2 LEU    57     -34.480  30.939  -8.118  1.00 27.85           C
ATOM    462  C   LEU    57     -31.165  28.050  -6.627  1.00 20.90           C
ATOM    463  O   LEU    57     -31.808  27.031  -6.345  1.00 20.75           O
ATOM    464  N   GLN    58     -30.052  28.016  -7.360  1.00 21.09           N
ATOM    465  CA  GLN    58     -29.551  26.768  -7.929  1.00 22.36           C
ATOM    466  CB  GLN    58     -28.346  26.998  -8.858  1.00 23.54           C
ATOM    467  CG  GLN    58     -27.960  25.733  -9.635  1.00 27.99           C
ATOM    468  CD  GLN    58     -29.191  25.021 -10.220  1.00 35.26           C
ATOM    469  OE1 GLN    58     -29.888  25.570 -11.083  1.00 37.09           O
ATOM    470  NE2 GLN    58     -29.469  23.796  -9.736  1.00 38.37           N
ATOM    471  C   GLN    58     -29.205  25.793  -6.803  1.00 22.27           C
ATOM    472  O   GLN    58     -29.522  24.575  -6.887  1.00 22.87           O
ATOM    473  N   GLU    59     -28.579  26.306  -5.741  0.50 21.38           N
ATOM    475  CA  GLU    59     -28.271  25.503  -4.553  0.50 21.43           C
ATOM    477  CB  GLU    59     -27.388  26.269  -3.553  0.50 21.44           C
ATOM    479  CG  GLU    59     -26.869  25.393  -2.378  0.50 21.69           C
ATOM    481  CD  GLU    59     -26.114  26.171  -1.293  0.50 22.85           C
ATOM    483  OE1 GLU    59     -25.921  27.400  -1.427  0.50 25.49           O
ATOM    485  OE2 GLU    59     -25.705  25.539  -0.292  0.50 22.88           O
ATOM    487  C   GLU    59     -29.535  25.040  -3.848  0.50 20.81           C
ATOM    489  O   GLU    59     -29.586  23.907  -3.359  0.50 20.84           O
ATOM    491  N   GLN    60     -30.526  25.927  -3.763  1.00 20.01           N
ATOM    492  CA  GLN    60     -31.823  25.588  -3.146  1.00 20.01           C
ATOM    493  CB  GLN    60     -32.751  26.812  -3.069  1.00 18.91           C
ATOM    494  CG  GLN    60     -32.254  27.942  -2.169  1.00 22.57           C
ATOM    495  CD  GLN    60     -32.132  27.523  -0.695  1.00 23.52           C
ATOM    496  OE1 GLN    60     -33.063  26.939  -0.124  1.00 25.17           O
ATOM    497  NE2 GLN    60     -30.987  27.798  -0.090  1.00 23.26           N
ATOM    498  C   GLN    60     -32.527  24.444  -3.865  1.00 18.38           C
ATOM    499  O   GLN    60     -33.135  23.578  -3.222  1.00 19.77           O
ATOM    500  N   PHE    61     -32.428  24.422  -5.192  1.00 18.84           N
ATOM    501  CA  PHE    61     -33.171  23.452  -5.980  1.00 18.05           C
ATOM    502  CB  PHE    61     -33.920  24.171  -7.089  1.00 18.50           C
ATOM    503  CG  PHE    61     -35.166  24.855  -6.603  1.00 16.29           C
ATOM    504  CD1 PHE    61     -35.097  26.142  -6.066  1.00 16.96           C
ATOM    505  CE1 PHE    61     -36.246  26.777  -5.586  1.00 17.57           C
ATOM    506  CZ  PHE    61     -37.469  26.128  -5.639  1.00 16.05           C
ATOM    507  CE2 PHE    61     -37.562  24.840  -6.149  1.00 16.94           C
ATOM    508  CD2 PHE    61     -36.415  24.206  -6.655  1.00 16.84           C
ATOM    509  C   PHE    61     -32.316  22.293  -6.529  1.00 18.86           C
ATOM    510  O   PHE    61     -32.799  21.474  -7.288  1.00 17.68           O
ATOM    511  N   ALA    62     -31.039  22.250  -6.153  1.00 19.75           N
ATOM    512  CA  ALA    62     -30.116  21.245  -6.684  1.00 20.70           C
ATOM    513  CB  ALA    62     -28.776  21.377  -5.988  1.00 21.27           C
ATOM    514  C   ALA    62     -30.639  19.784  -6.602  1.00 21.89           C
ATOM    515  O   ALA    62     -30.568  19.023  -7.588  1.00 22.43           O
ATOM    516  N   CYS    63     -31.180  19.433  -5.431  0.50 22.09           N
ATOM    518  CA  CYS    63     -31.713  18.088  -5.137  0.50 22.45           C
ATOM    520  CB  CYS    63     -32.194  18.002  -3.682  0.50 21.93           C
ATOM    522  SG  CYS    63     -30.917  17.628  -2.464  0.50 27.26           S
ATOM    524  C   CYS    63     -32.836  17.625  -6.072  0.50 21.59           C
ATOM    526  O   CYS    63     -33.089  16.419  -6.196  0.50 20.76           O
ATOM    528  N   PHE    64     -33.520  18.570  -6.711  1.00 20.75           N
ATOM    529  CA  PHE    64     -34.567  18.235  -7.659  1.00 20.96           C
ATOM    530  CB  PHE    64     -35.405  19.451  -8.035  1.00 19.37           C
ATOM    531  CG  PHE    64     -36.415  19.870  -6.996  1.00 19.26           C
ATOM    532  CD1 PHE    64     -36.028  20.573  -5.872  1.00 19.73           C
ATOM    533  CE1 PHE    64     -36.994  21.017  -4.934  1.00 18.87           C
ATOM    534  CZ  PHE    64     -38.331  20.739  -5.155  1.00 17.71           C
ATOM    535  CE2 PHE    64     -38.722  20.056  -6.260  1.00 18.01           C
ATOM    536  CD2 PHE    64     -37.778  19.643  -7.202  1.00 18.03           C
ATOM    537  C   PHE    64     -34.008  17.587  -8.957  1.00 21.96           C
ATOM    538  O   PHE    64     -34.743  16.934  -9.688  1.00 23.37           O
ATOM    539  N   GLY    65     -32.716  17.728  -9.209  1.00 22.10           N
ATOM    540  CA  GLY    65     -32.106  17.074 -10.371  1.00 23.22           C
ATOM    541  C   GLY    65     -31.577  15.697 -10.034  1.00 24.11           C
ATOM    542  O   GLY    65     -30.930  15.040 -10.873  1.00 24.63           O
ATOM    543  N   GLN    66     -31.841  15.266  -8.802  1.00 24.05           N
ATOM    544  CA  GLN    66     -31.357  13.993  -8.283  1.00 24.54           C
ATOM    545  CB  GLN    66     -30.285  14.241  -7.234  1.00 25.47           C
ATOM    546  CG  GLN    66     -28.910  14.511  -7.854  1.00 30.42           C
ATOM    547  CD  GLN    66     -28.001  15.342  -6.962  1.00 36.44           C
ATOM    548  OE1 GLN    66     -28.382  16.421  -6.479  1.00 39.74           O
ATOM    549  NE2 GLN    66     -26.784  14.859  -6.761  1.00 37.88           N
ATOM    550  C   GLN    66     -32.519  13.185  -7.688  1.00 23.92           C
ATOM    551  O   GLN    66     -32.671  13.075  -6.467  1.00 23.62           O
ATOM    552  N   LEU    67     -33.319  12.616  -8.579  1.00 22.78           N
ATOM    553  CA  LEU    67     -34.545  11.916  -8.200  1.00 21.55           C
ATOM    554  CB  LEU    67     -35.668  12.370  -9.128  1.00 21.58           C
ATOM    555  CG  LEU    67     -35.860  13.887  -9.236  1.00 21.33           C
ATOM    556  CD1 LEU    67     -36.995  14.155 -10.180  1.00 22.06           C
ATOM    557  CD2 LEU    67     -36.147  14.475  -7.858  1.00 21.71           C
ATOM    558  C   LEU    67     -34.455  10.391  -8.219  1.00 21.26           C
ATOM    559  O   LEU    67     -35.485   9.730  -8.205  1.00 20.77           O
ATOM    560  N   ASP    68     -33.243   9.827  -8.209  1.00 20.58           N
ATOM    561  CA  ASP    68     -33.066   8.375  -8.336  1.00 21.06           C
ATOM    562  CB  ASP    68     -31.588   8.003  -8.545  1.00 22.43           C
ATOM    563  CG  ASP    68     -31.143   8.118 -10.019  1.00 25.47           C
ATOM    564  OD1 ASP    68     -32.015   8.221 -10.922  1.00 30.33           O
ATOM    565  OD2 ASP    68     -29.915   8.103 -10.278  1.00 28.49           O
ATOM    566  C   ASP    68     -33.707   7.551  -7.191  1.00 21.11           C
ATOM    567  O   ASP    68     -34.136   6.420  -7.409  1.00 20.72           O
ATOM    568  N   ASP    69     -33.790   8.106  -5.981  1.00 20.70           N
ATOM    569  CA  ASP    69     -34.499   7.393  -4.890  1.00 21.27           C
ATOM    570  CB  ASP    69     -34.371   8.149  -3.562  1.00 22.13           C
ATOM    571  CG  ASP    69     -32.986   8.014  -2.948  1.00 24.48           C
ATOM    572  OD1 ASP    69     -32.312   6.996  -3.200  1.00 27.84           O
ATOM    573  OD2 ASP    69     -32.581   8.940  -2.220  1.00 28.42           O
ATOM    574  C   ASP    69     -35.988   7.188  -5.201  1.00 20.42           C
ATOM    575  O   ASP    69     -36.621   6.239  -4.725  1.00 20.59           O
ATOM    576  N   ILE    70     -36.539   8.100  -5.989  1.00 19.38           N
ATOM    577  CA  ILE    70     -37.928   7.992  -6.429  1.00 18.85           C
ATOM    578  CB  ILE    70     -38.556   9.366  -6.619  1.00 18.52           C
ATOM    579  CG1 ILE    70     -38.411  10.193  -5.323  1.00 21.19           C
ATOM    580  CD1 ILE    70     -38.809  11.665  -5.486  1.00 21.34           C
ATOM    581  CG2 ILE    70     -40.039   9.235  -6.997  1.00 19.97           C
ATOM    582  C   ILE    70     -38.014   7.194  -7.726  1.00 17.62           C
ATOM    583  O   ILE    70     -38.761   6.225  -7.804  1.00 18.07           O
ATOM    584  N   ARG    71     -37.271   7.614  -8.747  1.00 16.37           N
ATOM    585  CA  ARG    71     -37.312   6.918 -10.054  1.00 16.19           C
ATOM    586  CB  ARG    71     -36.314   7.527 -11.036  1.00 16.11           C
ATOM    587  CG  ARG    71     -36.578   8.965 -11.418  1.00 19.99           C
ATOM    588  CD  ARG    71     -35.754   9.340 -12.654  1.00 23.24           C
ATOM    589  NE  ARG    71     -35.827  10.770 -12.961  1.00 25.78           N
ATOM    590  CZ  ARG    71     -36.850  11.371 -13.583  1.00 28.05           C
ATOM    591  NH1 ARG    71     -37.910  10.665 -13.975  1.00 28.38           N
ATOM    592  NH2 ARG    71     -36.818  12.683 -13.821  1.00 22.66           N
ATOM    593  C   ARG    71     -36.981   5.449  -9.914  1.00 14.93           C
ATOM    594  O   ARG    71     -37.529   4.587 -10.637  1.00 13.88           O
ATOM    595  N   GLY    72     -36.074   5.141  -8.978  1.00 14.49           N
ATOM    596  CA  GLY    72     -35.604   3.763  -8.809  1.00 13.79           C
ATOM    597  C   GLY    72     -36.685   2.791  -8.352  1.00 14.28           C
ATOM    598  O   GLY    72     -36.498   1.596  -8.465  1.00 15.03           O
ATOM    599  N   GLN    73     -37.809   3.316  -7.844  1.00 13.08           N
ATOM    600  CA  GLN    73     -38.965   2.522  -7.381  1.00 13.26           C
ATOM    601  CB  GLN    73     -39.651   3.251  -6.211  1.00 13.37           C
ATOM    602  CG  GLN    73     -38.783   3.419  -4.979  1.00 16.75           C
ATOM    603  CD  GLN    73     -38.147   2.137  -4.546  1.00 21.82           C
ATOM    604  OE1 GLN    73     -38.813   1.105  -4.424  1.00 22.36           O
ATOM    605  NE2 GLN    73     -36.834   2.173  -4.334  1.00 26.08           N
ATOM    606  C   GLN    73     -40.037   2.290  -8.454  1.00 12.89           C
ATOM    607  O   GLN    73     -41.041   1.624  -8.204  1.00 12.88           O
ATOM    608  N   ALA    74     -39.844   2.871  -9.636  1.00 12.26           N
ATOM    609  CA  ALA    74     -40.800   2.693 -10.736  1.00 12.16           C
ATOM    610  CB  ALA    74     -40.216   3.279 -12.015  1.00 12.22           C
ATOM    611  C   ALA    74     -41.152   1.219 -10.951  1.00 12.26           C
ATOM    612  O   ALA    74     -40.261   0.342 -10.903  1.00 11.19           O
ATOM    613  N   GLY    75     -42.429   0.939 -11.235  1.00 11.65           N
ATOM    614  CA  GLY    75     -42.868  -0.466 -11.342  1.00 10.70           C
ATOM    615  C   GLY    75     -43.731  -0.790 -10.118  1.00 11.25           C
ATOM    616  O   GLY    75     -44.484  -1.762 -10.116  1.00 11.59           O
ATOM    617  N   ASP    76     -43.570  -0.008  -9.043  1.00 12.06           N
ATOM    618  CA  ASP    76     -44.360  -0.166  -7.824  1.00 12.36           C
ATOM    619  CB  ASP    76     -43.487  -0.827  -6.733  1.00 12.42           C
ATOM    620  CG  ASP    76     -44.202  -1.022  -5.400  1.00 15.66           C
ATOM    621  OD1 ASP    76     -45.317  -0.484  -5.151  1.00 16.24           O
ATOM    622  OD2 ASP    76     -43.604  -1.751  -4.566  1.00 15.57           O
ATOM    623  C   ASP    76     -44.849   1.223  -7.391  1.00 12.68           C
ATOM    624  O   ASP    76     -44.129   1.931  -6.685  1.00 11.41           O
ATOM    625  N   PRO    77     -46.043   1.647  -7.879  1.00 13.71           N
ATOM    626  CA  PRO    77     -46.488   3.033  -7.645  1.00 13.93           C
ATOM    627  CB  PRO    77     -47.873   3.103  -8.333  1.00 13.23           C
ATOM    628  CG  PRO    77     -47.761   2.072  -9.458  1.00 15.27           C
ATOM    629  CD  PRO    77     -46.977   0.920  -8.766  1.00 14.18           C
ATOM    630  C   PRO    77     -46.533   3.405  -6.182  1.00 13.31           C
ATOM    631  O   PRO    77     -46.184   4.524  -5.838  1.00 13.85           O
ATOM    632  N   LEU    78     -46.946   2.477  -5.319  0.50 13.21           N
ATOM    634  CA  LEU    78     -46.992   2.787  -3.889  0.50 13.74           C
ATOM    636  CB  LEU    78     -47.582   1.617  -3.103  0.50 13.51           C
ATOM    638  CG  LEU    78     -48.457   1.997  -1.907  0.50 14.73           C
ATOM    640  CD1 LEU    78     -49.147   0.741  -1.413  0.50 17.25           C
ATOM    642  CD2 LEU    78     -47.650   2.638  -0.804  0.50 19.04           C
ATOM    644  C   LEU    78     -45.602   3.124  -3.366  0.50 13.01           C
ATOM    646  O   LEU    78     -45.444   4.072  -2.614  0.50 12.86           O
ATOM    648  N   ALA    79     -44.598   2.339  -3.761  1.00 13.15           N
ATOM    649  CA  ALA    79     -43.203   2.602  -3.355  1.00 13.03           C
ATOM    650  CB  ALA    79     -42.284   1.481  -3.789  1.00 13.22           C
ATOM    651  C   ALA    79     -42.705   3.953  -3.901  1.00 12.54           C
ATOM    652  O   ALA    79     -41.949   4.654  -3.228  1.00 12.09           O
ATOM    653  N   VAL    80     -43.099   4.301  -5.131  1.00 11.58           N
ATOM    654  CA  VAL    80     -42.787   5.630  -5.672  1.00 12.21           C
ATOM    655  CB  VAL    80     -43.296   5.773  -7.101  1.00 11.22           C
ATOM    656  CG1 VAL    80     -43.163   7.227  -7.624  1.00 12.32           C
ATOM    657  CG2 VAL    80     -42.538   4.787  -8.035  1.00 10.84           C
ATOM    658  C   VAL    80     -43.376   6.760  -4.777  1.00 13.05           C
ATOM    659  O   VAL    80     -42.668   7.710  -4.420  1.00 13.23           O
ATOM    660  N   MET    81     -44.661   6.646  -4.436  0.70 12.38           N
ATOM    662  CA  MET    81     -45.330   7.668  -3.603  0.70 12.69           C
ATOM    664  CB  MET    81     -46.833   7.394  -3.427  0.70 13.82           C
ATOM    666  CG  MET    81     -47.597   7.155  -4.747  0.70 14.01           C
ATOM    668  SD  MET    81     -47.622   8.670  -5.960  0.70 21.09          SE
ATOM    670  CE  MET    81     -47.084   7.612  -7.496  0.70 15.28           C
ATOM    672  C   MET    81     -44.684   7.771  -2.235  0.70 13.11           C
ATOM    674  O   MET    81     -44.538   8.886  -1.698  0.70 12.95           O
ATOM    676  N   THR    82     -44.336   6.621  -1.655  1.00 11.97           N
ATOM    677  CA  THR    82     -43.690   6.575  -0.342  1.00 13.13           C
ATOM    678  CB  THR    82     -43.605   5.113   0.176  1.00 12.76           C
ATOM    679  OG1 THR    82     -44.931   4.563   0.297  1.00 13.08           O
ATOM    680  CG2 THR    82     -42.926   5.051   1.546  1.00 12.65           C
ATOM    681  C   THR    82     -42.311   7.220  -0.401  1.00 12.27           C
ATOM    682  O   THR    82     -41.988   8.047   0.443  1.00 12.09           O
ATOM    683  N   ALA    83     -41.522   6.874  -1.419  1.00 12.10           N
ATOM    684  CA  ALA    83     -40.189   7.455  -1.613  1.00 12.71           C
ATOM    685  CB  ALA    83     -39.469   6.804  -2.772  1.00 13.64           C
ATOM    686  C   ALA    83     -40.256   8.962  -1.829  1.00 13.31           C
ATOM    687  O   ALA    83     -39.424   9.717  -1.293  1.00 13.65           O
ATOM    688  N   TYR    84     -41.234   9.393  -2.621  1.00 12.01           N
ATOM    689  CA  TYR    84     -41.450  10.829  -2.827  1.00 11.80           C
ATOM    690  CB  TYR    84     -42.626  11.070  -3.785  1.00 11.47           C
ATOM    691  CG  TYR    84     -43.055  12.503  -3.698  1.00 11.01           C
ATOM    692  CD1 TYR    84     -42.230  13.514  -4.207  1.00  9.70           C
ATOM    693  CE1 TYR    84     -42.562  14.853  -4.058  1.00  7.72           C
ATOM    694  CZ  TYR    84     -43.777  15.207  -3.416  1.00  9.90           C
ATOM    695  OH  TYR    84     -44.090  16.520  -3.245  1.00  9.60           O
ATOM    696  CE2 TYR    84     -44.606  14.228  -2.886  1.00 10.03           C
ATOM    697  CD2 TYR    84     -44.241  12.867  -3.033  1.00  8.93           C
ATOM    698  C   TYR    84     -41.702  11.542  -1.464  1.00 11.96           C
ATOM    699  O   TYR    84     -41.113  12.588  -1.195  1.00 11.13           O
ATOM    700  N   LEU    85     -42.594  11.008  -0.646  1.00 10.86           N
ATOM    701  CA  LEU    85     -42.868  11.627   0.683  1.00 10.85           C
ATOM    702  CB  LEU    85     -44.003  10.908   1.396  1.00 10.34           C
ATOM    703  CG  LEU    85     -45.392  11.039   0.735  1.00 11.08           C
ATOM    704  CD1 LEU    85     -46.412  10.164   1.470  1.00 14.10           C
ATOM    705  CD2 LEU    85     -45.840  12.513   0.824  1.00 11.81           C
ATOM    706  C   LEU    85     -41.608  11.688   1.547  1.00 10.59           C
ATOM    707  O   LEU    85     -41.299  12.737   2.160  1.00  9.89           O
ATOM    708  N   ARG    86     -40.890  10.577   1.613  1.00 11.70           N
ATOM    709  CA  ARG    86     -39.686  10.504   2.430  1.00 12.21           C
ATOM    710  CB  ARG    86     -39.118   9.092   2.407  1.00 13.48           C
ATOM    711  CG  ARG    86     -38.070   8.880   3.462  1.00 16.80           C
ATOM    712  CD  ARG    86     -37.752   7.377   3.627  1.00 18.02           C
ATOM    713  NE  ARG    86     -38.810   6.676   4.350  1.00 20.50           N
ATOM    714  CZ  ARG    86     -39.556   5.706   3.833  1.00 23.33           C
ATOM    715  NH1 ARG    86     -39.354   5.300   2.584  1.00 26.93           N
ATOM    716  NH2 ARG    86     -40.472   5.111   4.589  1.00 24.38           N
ATOM    717  C   ARG    86     -38.635  11.526   1.947  1.00 11.94           C
ATOM    718  O   ARG    86     -37.985  12.202   2.764  1.00 11.86           O
ATOM    719  N   TRP    87     -38.462  11.595   0.637  1.00 11.06           N
ATOM    720  CA  TRP    87     -37.511  12.517   0.011  1.00 11.54           C
ATOM    721  CB  TRP    87     -37.513  12.276  -1.518  1.00 11.78           C
ATOM    722  CG  TRP    87     -36.670  13.219  -2.336  1.00 11.45           C
ATOM    723  CD1 TRP    87     -35.298  13.232  -2.473  1.00 12.95           C
ATOM    724  NE1 TRP    87     -34.914  14.228  -3.355  1.00 11.75           N
ATOM    725  CE2 TRP    87     -36.041  14.867  -3.805  1.00 12.69           C
ATOM    726  CD2 TRP    87     -37.162  14.253  -3.195  1.00 12.32           C
ATOM    727  CE3 TRP    87     -38.448  14.715  -3.505  1.00 13.71           C
ATOM    728  CZ3 TRP    87     -38.582  15.767  -4.386  1.00 13.30           C
ATOM    729  CH2 TRP    87     -37.436  16.377  -4.989  1.00 14.32           C
ATOM    730  CZ2 TRP    87     -36.166  15.944  -4.703  1.00 14.12           C
ATOM    731  C   TRP    87     -37.904  13.972   0.307  1.00 11.68           C
ATOM    732  O   TRP    87     -37.046  14.801   0.617  1.00 11.77           O
ATOM    733  N   THR    88     -39.191  14.280   0.183  1.00 11.01           N
ATOM    734  CA  THR    88     -39.685  15.654   0.390  1.00 11.22           C
ATOM    735  CB  THR    88     -41.147  15.790  -0.053  1.00 12.10           C
ATOM    736  OG1 THR    88     -41.220  15.503  -1.460  1.00 12.19           O
ATOM    737  CG2 THR    88     -41.678  17.220   0.199  1.00 12.36           C
ATOM    738  C   THR    88     -39.498  16.086   1.853  1.00 10.14           C
ATOM    739  O   THR    88     -39.045  17.207   2.119  1.00  9.63           O
ATOM    740  N   ILE    89     -39.826  15.192   2.778  1.00 10.71           N
ATOM    741  CA  ILE    89     -39.609  15.477   4.191  1.00 11.44           C
ATOM    742  CB  ILE    89     -40.178  14.352   5.067  1.00 11.62           C
ATOM    743  CG1 ILE    89     -41.718  14.377   4.949  1.00 10.67           C
ATOM    744  CD1 ILE    89     -42.368  13.154   5.612  1.00 14.32           C
ATOM    745  CG2 ILE    89     -39.752  14.574   6.521  1.00  9.76           C
ATOM    746  C   ILE    89     -38.108  15.719   4.470  1.00 11.65           C
ATOM    747  O   ILE    89     -37.748  16.702   5.123  1.00 10.49           O
ATOM    748  N   GLN    90     -37.253  14.832   3.946  0.60 11.78           N
ATOM    750  CA  GLN    90     -35.805  15.009   4.058  0.60 12.90           C
ATOM    752  CB  GLN    90     -35.059  13.906   3.294  0.60 13.23           C
ATOM    754  CG  GLN    90     -33.581  13.882   3.617  0.60 18.71           C
ATOM    756  CD  GLN    90     -33.320  13.696   5.114  0.60 24.36           C
ATOM    758  OE1 GLN    90     -32.857  14.615   5.797  0.60 28.60           O
ATOM    760  NE2 GLN    90     -33.626  12.502   5.631  0.60 27.22           N
ATOM    762  C   GLN    90     -35.349  16.402   3.563  0.60 12.09           C
ATOM    764  O   GLN    90     -34.599  17.104   4.235  0.60 11.76           O
ATOM    766  N   ARG    91     -35.849  16.798   2.401  1.00 12.06           N
ATOM    767  CA  ARG    91     -35.481  18.070   1.792  1.00 11.96           C
ATOM    768  CB  ARG    91     -36.237  18.253   0.485  1.00 13.06           C
ATOM    769  CG  ARG    91     -35.579  17.519  -0.624  1.00 17.79           C
ATOM    770  CD  ARG    91     -36.116  18.032  -1.972  1.00 20.49           C
ATOM    771  NE  ARG    91     -37.524  17.695  -2.235  1.00 21.73           N
ATOM    772  CZ  ARG    91     -38.542  18.563  -2.176  1.00 22.41           C
ATOM    773  NH1 ARG    91     -39.778  18.166  -2.519  1.00 18.87           N
ATOM    774  NH2 ARG    91     -38.328  19.821  -1.792  1.00 17.44           N
ATOM    775  C   ARG    91     -35.787  19.210   2.737  1.00 11.92           C
ATOM    776  O   ARG    91     -34.954  20.120   2.929  1.00 11.63           O
ATOM    777  N   HIS    92     -36.985  19.171   3.324  1.00 11.45           N
ATOM    778  CA  HIS    92     -37.369  20.231   4.257  1.00 12.36           C
ATOM    779  CB  HIS    92     -38.873  20.203   4.534  1.00 13.78           C
ATOM    780  CG  HIS    92     -39.696  20.557   3.336  1.00 14.40           C
ATOM    781  ND1 HIS    92     -39.591  21.777   2.684  1.00 19.47           N
ATOM    782  CE1 HIS    92     -40.452  21.801   1.674  1.00 21.35           C
ATOM    783  NE2 HIS    92     -41.103  20.649   1.649  1.00 16.69           N
ATOM    784  CD2 HIS    92     -40.635  19.846   2.660  1.00 16.03           C
ATOM    785  C   HIS    92     -36.565  20.215   5.544  1.00 12.15           C
ATOM    786  O   HIS    92     -36.192  21.268   6.056  1.00 11.95           O
ATOM    787  N   ARG    93     -36.254  19.030   6.054  1.00 11.79           N
ATOM    788  CA  ARG    93     -35.455  18.958   7.286  1.00 12.70           C
ATOM    789  CB  ARG    93     -35.461  17.537   7.853  1.00 12.66           C
ATOM    790  CG  ARG    93     -36.858  17.020   8.266  1.00 13.84           C
ATOM    791  CD  ARG    93     -37.401  17.762   9.453  1.00 18.09           C
ATOM    792  NE  ARG    93     -38.685  17.215   9.878  1.00 17.47           N
ATOM    793  CZ  ARG    93     -39.526  17.858  10.676  1.00 16.59           C
ATOM    794  NH1 ARG    93     -39.223  19.072  11.110  1.00 17.37           N
ATOM    795  NH2 ARG    93     -40.666  17.281  11.023  1.00 15.53           N
ATOM    796  C   ARG    93     -34.025  19.435   7.057  1.00 13.20           C
ATOM    797  O   ARG    93     -33.450  20.125   7.905  1.00 15.46           O
ATOM    798  N   ASN    94     -33.459  19.087   5.914  1.00 12.51           N
ATOM    799  CA  ASN    94     -32.101  19.512   5.580  1.00 14.01           C
ATOM    800  CB  ASN    94     -31.566  18.704   4.408  1.00 15.34           C
ATOM    801  CG  ASN    94     -31.380  17.226   4.724  1.00 18.74           C
ATOM    802  OD1 ASN    94     -31.130  16.441   3.813  1.00 27.63           O
ATOM    803  ND2 ASN    94     -31.508  16.841   5.986  1.00 22.90           N
ATOM    804  C   ASN    94     -32.010  20.978   5.199  1.00 13.91           C
ATOM    805  O   ASN    94     -30.942  21.582   5.307  1.00 12.63           O
ATOM    806  N   ASN    95     -33.118  21.549   4.732  1.00 13.29           N
ATOM    807  CA  ASN    95     -33.111  22.936   4.270  1.00 15.16           C
ATOM    808  CB  ASN    95     -32.967  23.054   2.763  1.00 16.24           C
ATOM    809  CG  ASN    95     -32.773  24.515   2.339  1.00 19.00           C
ATOM    810  OD1 ASN    95     -32.538  25.397   3.185  1.00 16.84           O
ATOM    811  ND2 ASN    95     -32.897  24.782   1.041  1.00 21.24           N
ATOM    812  C   ASN    95     -34.330  23.717   4.692  1.00 15.67           C
ATOM    813  O   ASN    95     -35.314  23.831   3.936  1.00 15.80           O
ATOM    814  N   PRO    96     -34.271  24.260   5.900  1.00 16.89           N
ATOM    815  CA  PRO    96     -35.322  25.100   6.460  1.00 18.18           C
ATOM    816  CB  PRO    96     -34.732  25.555   7.802  1.00 18.94           C
ATOM    817  CG  PRO    96     -33.729  24.472   8.148  1.00 19.40           C
ATOM    818  CD  PRO    96     -33.147  24.066   6.837  1.00 17.29           C
ATOM    819  C   PRO    96     -35.602  26.309   5.578  1.00 17.64           C
ATOM    820  O   PRO    96     -36.688  26.843   5.668  1.00 20.08           O
ATOM    821  N   GLN    97     -34.664  26.718   4.721  1.00 17.55           N
ATOM    822  CA  GLN    97     -34.882  27.924   3.884  1.00 16.15           C
ATOM    823  CB  GLN    97     -33.556  28.526   3.375  1.00 18.11           C
ATOM    824  CG  GLN    97     -32.586  28.997   4.445  1.00 21.27           C
ATOM    825  CD  GLN    97     -32.986  30.332   5.097  1.00 25.68           C
ATOM    826  OE1 GLN    97     -34.153  30.593   5.335  1.00 27.40           O
ATOM    827  NE2 GLN    97     -32.009  31.165   5.381  1.00 27.04           N
ATOM    828  C   GLN    97     -35.744  27.610   2.655  1.00 14.78           C
ATOM    829  O   GLN    97     -36.230  28.506   1.960  1.00 11.98           O
ATOM    830  N   LEU    98     -35.901  26.333   2.335  1.00 12.64           N
ATOM    831  CA  LEU    98     -36.399  26.054   0.980  1.00 12.07           C
ATOM    832  CB  LEU    98     -36.223  24.576   0.576  1.00 12.25           C
ATOM    833  CG  LEU    98     -36.864  24.142  -0.779  1.00 13.48           C
ATOM    834  CD1 LEU    98     -36.177  24.694  -2.050  1.00 15.69           C
ATOM    835  CD2 LEU    98     -36.865  22.621  -0.848  1.00 15.12           C
ATOM    836  C   LEU    98     -37.808  26.609   0.762  1.00  9.66           C
ATOM    837  O   LEU    98     -38.058  27.231  -0.286  1.00  9.22           O
ATOM    838  N   LEU    99     -38.723  26.475   1.724  1.00  9.90           N
ATOM    839  CA  LEU    99     -40.096  26.921   1.392  1.00 10.68           C
ATOM    840  CB  LEU    99     -41.134  26.482   2.475  1.00 11.84           C
ATOM    841  CG  LEU    99     -41.720  25.109   2.218  1.00 12.27           C
ATOM    842  CD1 LEU    99     -42.546  24.691   3.463  1.00 16.86           C
ATOM    843  CD2 LEU    99     -42.530  24.990   0.943  1.00 14.59           C
ATOM    844  C   LEU    99     -40.166  28.414   1.244  1.00 10.51           C
ATOM    845  O   LEU    99     -41.036  28.919   0.576  1.00 11.22           O
ATOM    846  N   ARG   100     -39.232  29.138   1.869  1.00  8.91           N
ATOM    847  CA  ARG   100     -39.171  30.614   1.637  1.00 10.19           C
ATOM    848  CB  ARG   100     -38.051  31.233   2.443  1.00  9.36           C
ATOM    849  CG  ARG   100     -38.293  31.279   3.923  1.00 12.57           C
ATOM    850  CD  ARG   100     -37.117  31.919   4.691  1.00 14.26           C
ATOM    851  NE  ARG   100     -37.502  32.131   6.084  1.00 21.03           N
ATOM    852  CZ  ARG   100     -36.662  32.254   7.102  1.00 26.22           C
ATOM    853  NH1 ARG   100     -35.340  32.191   6.906  1.00 25.30           N
ATOM    854  NH2 ARG   100     -37.156  32.455   8.326  1.00 30.04           N
ATOM    855  C   ARG   100     -38.944  30.908   0.135  1.00  9.56           C
ATOM    856  O   ARG   100     -39.737  31.609  -0.479  1.00  9.17           O
ATOM    857  N   PHE   101     -37.894  30.333  -0.451  1.00  8.88           N
ATOM    858  CA  PHE   101     -37.584  30.586  -1.861  1.00  7.74           C
ATOM    859  CB  PHE   101     -36.227  29.979  -2.191  1.00  9.07           C
ATOM    860  CG  PHE   101     -35.072  30.718  -1.553  1.00  8.31           C
ATOM    861  CD1 PHE   101     -34.572  31.865  -2.155  1.00  9.65           C
ATOM    862  CE1 PHE   101     -33.460  32.577  -1.586  1.00 12.39           C
ATOM    863  CZ  PHE   101     -32.856  32.079  -0.434  1.00 11.45           C
ATOM    864  CE2 PHE   101     -33.351  30.895   0.160  1.00 13.90           C
ATOM    865  CD2 PHE   101     -34.452  30.220  -0.416  1.00 11.33           C
ATOM    866  C   PHE   101     -38.651  29.978  -2.784  1.00  8.41           C
ATOM    867  O   PHE   101     -39.040  30.587  -3.776  1.00  8.06           O
ATOM    868  N   TYR   102     -39.122  28.777  -2.420  1.00  7.06           N
ATOM    869  CA  TYR   102     -40.068  28.027  -3.247  1.00  7.90           C
ATOM    870  CB  TYR   102     -40.262  26.695  -2.548  1.00  7.79           C
ATOM    871  CG  TYR   102     -41.077  25.629  -3.236  1.00  8.54           C
ATOM    872  CD1 TYR   102     -42.489  25.656  -3.181  1.00 10.03           C
ATOM    873  CE1 TYR   102     -43.257  24.599  -3.766  1.00 11.63           C
ATOM    874  CZ  TYR   102     -42.610  23.511  -4.376  1.00 11.76           C
ATOM    875  OH  TYR   102     -43.341  22.459  -4.924  1.00 11.14           O
ATOM    876  CE2 TYR   102     -41.192  23.459  -4.417  1.00  9.45           C
ATOM    877  CD2 TYR   102     -40.447  24.510  -3.827  1.00 10.19           C
ATOM    878  C   TYR   102     -41.394  28.796  -3.351  1.00  8.00           C
ATOM    879  O   TYR   102     -41.879  29.032  -4.458  1.00  9.22           O
ATOM    880  N   THR   103     -41.935  29.239  -2.212  1.00  8.23           N
ATOM    881  CA  THR   103     -43.186  30.012  -2.256  1.00  8.10           C
ATOM    882  CB  THR   103     -43.885  30.125  -0.875  1.00  7.33           C
ATOM    883  OG1 THR   103     -43.012  30.781   0.056  1.00  8.06           O
ATOM    884  CG2 THR   103     -44.249  28.714  -0.376  1.00  8.46           C
ATOM    885  C   THR   103     -43.009  31.397  -2.842  1.00  8.57           C
ATOM    886  O   THR   103     -43.909  31.869  -3.557  1.00  9.60           O
ATOM    887  N   SER   104     -41.877  32.052  -2.541  1.00  9.12           N
ATOM    888  CA  SER   104     -41.655  33.400  -3.043  1.00  9.88           C
ATOM    889  CB  SER   104     -40.363  34.009  -2.477  1.00  9.85           C
ATOM    890  OG  SER   104     -40.234  35.352  -2.971  1.00 12.21           O
ATOM    891  C   SER   104     -41.601  33.357  -4.584  1.00 10.66           C
ATOM    892  O   SER   104     -42.219  34.183  -5.265  1.00 10.59           O
ATOM    893  N   GLU   105     -40.865  32.392  -5.125  1.00  8.72           N
ATOM    894  CA  GLU   105     -40.817  32.289  -6.613  1.00  9.18           C
ATOM    895  CB  GLU   105     -39.731  31.293  -7.041  1.00  7.45           C
ATOM    896  CG  GLU   105     -38.332  31.924  -6.972  1.00  8.14           C
ATOM    897  CD  GLU   105     -38.036  32.910  -8.131  1.00 10.19           C
ATOM    898  OE1 GLU   105     -38.853  33.093  -9.071  1.00  9.04           O
ATOM    899  OE2 GLU   105     -36.931  33.505  -8.111  1.00 13.04           O
ATOM    900  C   GLU   105     -42.165  31.935  -7.261  1.00  9.12           C
ATOM    901  O   GLU   105     -42.538  32.491  -8.300  1.00  9.81           O
ATOM    902  N   LEU   106     -42.941  31.042  -6.632  1.00  8.79           N
ATOM    903  CA  LEU   106     -44.237  30.680  -7.191  1.00  9.03           C
ATOM    904  CB  LEU   106     -44.849  29.471  -6.457  1.00  8.32           C
ATOM    905  CG  LEU   106     -44.211  28.130  -6.911  1.00  9.60           C
ATOM    906  CD1 LEU   106     -44.576  27.033  -5.828  1.00  9.04           C
ATOM    907  CD2 LEU   106     -44.754  27.786  -8.296  1.00  9.22           C
ATOM    908  C   LEU   106     -45.238  31.834  -7.135  1.00  9.88           C
ATOM    909  O   LEU   106     -46.147  31.887  -7.972  1.00 10.21           O
ATOM    910  N   THR   107     -45.102  32.717  -6.136  1.00  9.52           N
ATOM    911  CA  THR   107     -46.030  33.832  -5.986  1.00  9.75           C
ATOM    912  CB  THR   107     -46.510  33.990  -4.516  1.00  9.09           C
ATOM    913  OG1 THR   107     -45.388  34.319  -3.693  1.00 10.50           O
ATOM    914  CG2 THR   107     -47.185  32.718  -4.076  1.00 10.05           C
ATOM    915  C   THR   107     -45.544  35.182  -6.484  1.00  9.81           C
ATOM    916  O   THR   107     -46.371  36.081  -6.704  1.00 12.25           O
ATOM    917  N   ASN   108     -44.232  35.363  -6.633  0.50  9.70           N
ATOM    919  CA  ASN   108     -43.617  36.625  -7.105  0.50  9.59           C
ATOM    921  CB  ASN   108     -43.154  37.511  -5.932  0.50  9.99           C
ATOM    923  CG  ASN   108     -44.278  38.322  -5.314  0.50  8.07           C
ATOM    925  OD1 ASN   108     -44.577  38.166  -4.138  0.50 11.45           O
ATOM    927  ND2 ASN   108     -44.931  39.160  -6.116  0.50  6.17           N
ATOM    929  C   ASN   108     -42.392  36.215  -7.909  0.50  9.86           C
ATOM    931  O   ASN   108     -41.262  36.429  -7.469  0.50  9.46           O
ATOM    933  N   PRO   109     -42.611  35.593  -9.087  1.00  9.87           N
ATOM    934  CA  PRO   109     -41.482  34.997  -9.847  1.00  9.20           C
ATOM    935  CB  PRO   109     -42.170  34.338 -11.060  1.00  9.29           C
ATOM    936  CG  PRO   109     -43.456  35.217 -11.249  1.00 11.47           C
ATOM    937  CD  PRO   109     -43.900  35.416  -9.770  1.00 10.72           C
ATOM    938  C   PRO   109     -40.455  36.039 -10.322  1.00  9.60           C
ATOM    939  O   PRO   109     -40.811  37.205 -10.612  1.00 11.09           O
ATOM    940  N   THR   110     -39.210  35.615 -10.382  1.00  9.05           N
ATOM    941  CA  THR   110     -38.133  36.378 -11.039  1.00  9.32           C
ATOM    942  CB  THR   110     -36.862  36.356 -10.160  1.00 10.57           C
ATOM    943  OG1 THR   110     -36.330  35.035 -10.130  1.00  9.30           O
ATOM    944  CG2 THR   110     -37.147  36.832  -8.744  1.00 13.98           C
ATOM    945  C   THR   110     -37.799  35.644 -12.327  1.00  8.94           C
ATOM    946  O   THR   110     -38.429  34.643 -12.626  1.00  8.35           O
ATOM    947  N   PRO   111     -36.818  36.119 -13.123  1.00  9.83           N
ATOM    948  CA  PRO   111     -36.366  35.317 -14.286  1.00 11.52           C
ATOM    949  CB  PRO   111     -35.231  36.183 -14.892  1.00 11.75           C
ATOM    950  CG  PRO   111     -35.579  37.539 -14.489  1.00 11.98           C
ATOM    951  CD  PRO   111     -36.150  37.430 -13.076  1.00 10.83           C
ATOM    952  C   PRO   111     -35.863  33.915 -13.908  1.00 12.86           C
ATOM    953  O   PRO   111     -35.889  32.963 -14.744  1.00 13.75           O
ATOM    954  N   CYS   112     -35.461  33.730 -12.660  1.00 11.46           N
ATOM    955  CA  CYS   112     -35.067  32.401 -12.254  1.00 13.19           C
ATOM    956  CB  CYS   112     -34.230  32.442 -10.978  1.00 14.56           C
ATOM    957  SG  CYS   112     -32.686  33.333 -11.290  1.00 18.40           S
ATOM    958  C   CYS   112     -36.251  31.432 -12.108  1.00 12.18           C
ATOM    959  O   CYS   112     -36.048  30.232 -11.974  1.00 13.79           O
ATOM    960  N   PHE   113     -37.501  31.926 -12.121  1.00 11.58           N
ATOM    961  CA  PHE   113     -38.605  30.987 -11.961  1.00 10.29           C
ATOM    962  CB  PHE   113     -39.921  31.711 -11.869  1.00 10.73           C
ATOM    963  CG  PHE   113     -41.068  30.776 -11.807  1.00 10.75           C
ATOM    964  CD1 PHE   113     -41.318  30.025 -10.649  1.00 13.13           C
ATOM    965  CE1 PHE   113     -42.390  29.092 -10.649  1.00 14.20           C
ATOM    966  CZ  PHE   113     -43.135  28.878 -11.780  1.00 12.39           C
ATOM    967  CE2 PHE   113     -42.909  29.606 -12.931  1.00 14.70           C
ATOM    968  CD2 PHE   113     -41.824  30.539 -12.957  1.00 11.87           C
ATOM    969  C   PHE   113     -38.634  30.035 -13.180  1.00  9.81           C
ATOM    970  O   PHE   113     -38.642  28.807 -13.017  1.00  9.92           O
ATOM    971  N   ALA   114     -38.644  30.592 -14.383  1.00  9.60           N
ATOM    972  CA  ALA   114     -38.711  29.716 -15.565  1.00  9.88           C
ATOM    973  CB  ALA   114     -38.980  30.528 -16.837  1.00  9.97           C
ATOM    974  C   ALA   114     -37.461  28.865 -15.730  1.00 10.92           C
ATOM    975  O   ALA   114     -37.548  27.764 -16.247  1.00 11.21           O
ATOM    976  N   ALA   115     -36.301  29.407 -15.342  1.00 10.45           N
ATOM    977  CA  ALA   115     -35.020  28.733 -15.554  1.00 11.81           C
ATOM    978  CB  ALA   115     -33.882  29.767 -15.520  1.00 12.14           C
ATOM    979  C   ALA   115     -34.750  27.588 -14.574  1.00 11.95           C
ATOM    980  O   ALA   115     -34.178  26.555 -14.951  1.00 12.70           O
ATOM    981  N   ILE   116     -35.186  27.750 -13.331  1.00 11.04           N
ATOM    982  CA  ILE   116     -34.783  26.848 -12.255  1.00 11.69           C
ATOM    983  CB  ILE   116     -33.872  27.616 -11.214  1.00 10.98           C
ATOM    984  CG1 ILE   116     -32.584  28.106 -11.900  1.00 13.37           C
ATOM    985  CD1 ILE   116     -31.751  29.071 -11.039  1.00 12.57           C
ATOM    986  CG2 ILE   116     -33.568  26.724  -9.962  1.00 12.49           C
ATOM    987  C   ILE   116     -35.998  26.242 -11.560  1.00 11.29           C
ATOM    988  O   ILE   116     -36.092  25.007 -11.384  1.00 10.24           O
ATOM    989  N   VAL   117     -36.919  27.089 -11.131  1.00 10.95           N
ATOM    990  CA  VAL   117     -37.977  26.588 -10.206  1.00 10.57           C
ATOM    991  CB  VAL   117     -38.617  27.751  -9.409  1.00 11.02           C
ATOM    992  CG1 VAL   117     -39.795  27.207  -8.454  1.00 10.64           C
ATOM    993  CG2 VAL   117     -37.512  28.443  -8.627  1.00 10.50           C
ATOM    994  C   VAL   117     -39.038  25.771 -10.946  1.00 11.77           C
ATOM    995  O   VAL   117     -39.425  24.648 -10.524  1.00 11.14           O
ATOM    996  N   SER   118     -39.530  26.315 -12.046  1.00 10.59           N
ATOM    997  CA  SER   118     -40.620  25.684 -12.764  1.00 12.47           C
ATOM    998  CB  SER   118     -41.105  26.636 -13.868  1.00 13.39           C
ATOM    999  OG  SER   118     -42.255  26.127 -14.471  1.00 14.41           O
ATOM   1000  C   SER   118     -40.234  24.283 -13.285  1.00 11.92           C
ATOM   1001  O   SER   118     -40.958  23.318 -13.010  1.00 12.39           O
ATOM   1002  N   PRO   119     -39.094  24.138 -13.988  1.00 12.64           N
ATOM   1003  CA  PRO   119     -38.727  22.800 -14.461  1.00 11.77           C
ATOM   1004  CB  PRO   119     -37.448  23.016 -15.304  1.00 12.21           C
ATOM   1005  CG  PRO   119     -36.981  24.375 -14.981  1.00 12.76           C
ATOM   1006  CD  PRO   119     -38.161  25.180 -14.467  1.00 11.90           C
ATOM   1007  C   PRO   119     -38.487  21.799 -13.296  1.00 11.38           C
ATOM   1008  O   PRO   119     -38.822  20.622 -13.450  1.00 11.44           O
ATOM   1009  N   ALA   120     -37.965  22.276 -12.162  1.00 10.79           N
ATOM   1010  CA  ALA   120     -37.680  21.404 -10.992  1.00  9.96           C
ATOM   1011  CB  ALA   120     -36.955  22.202  -9.916  1.00 10.33           C
ATOM   1012  C   ALA   120     -38.996  20.843 -10.478  1.00 11.25           C
ATOM   1013  O   ALA   120     -39.179  19.606 -10.381  1.00 11.32           O
ATOM   1014  N   ILE   121     -39.972  21.731 -10.240  1.00  9.92           N
ATOM   1015  CA  ILE   121     -41.278  21.275  -9.739  1.00 10.42           C
ATOM   1016  CB  ILE   121     -42.191  22.482  -9.354  1.00  9.91           C
ATOM   1017  CG1 ILE   121     -41.576  23.223  -8.147  1.00 11.53           C
ATOM   1018  CD1 ILE   121     -42.273  24.600  -7.882  1.00 11.61           C
ATOM   1019  CG2 ILE   121     -43.657  22.039  -9.082  1.00 11.13           C
ATOM   1020  C   ILE   121     -41.980  20.382 -10.790  1.00 10.00           C
ATOM   1021  O   ILE   121     -42.496  19.302 -10.444  1.00 10.24           O
ATOM   1022  N   ALA   122     -41.999  20.822 -12.047  1.00 10.30           N
ATOM   1023  CA  ALA   122     -42.680  20.050 -13.108  1.00 11.54           C
ATOM   1024  CB  ALA   122     -42.598  20.755 -14.509  1.00 12.24           C
ATOM   1025  C   ALA   122     -42.094  18.638 -13.234  1.00 11.86           C
ATOM   1026  O   ALA   122     -42.845  17.702 -13.488  1.00 12.38           O
ATOM   1027  N   SER   123     -40.780  18.499 -13.132  1.00 11.72           N
ATOM   1028  CA  SER   123     -40.140  17.174 -13.297  1.00 11.69           C
ATOM   1029  CB  SER   123     -38.597  17.220 -13.248  1.00 13.37           C
ATOM   1030  OG  SER   123     -38.136  17.620 -11.957  1.00 18.01           O
ATOM   1031  C   SER   123     -40.678  16.217 -12.222  1.00 11.56           C
ATOM   1032  O   SER   123     -40.889  15.041 -12.504  1.00 11.30           O
ATOM   1033  N   VAL   124     -40.862  16.719 -10.996  1.00 10.19           N
ATOM   1034  CA  VAL   124     -41.338  15.876  -9.883  1.00  9.66           C
ATOM   1035  CB  VAL   124     -41.121  16.603  -8.497  1.00 10.39           C
ATOM   1036  CG1 VAL   124     -41.817  15.860  -7.384  1.00 13.37           C
ATOM   1037  CG2 VAL   124     -39.640  16.694  -8.191  1.00 12.44           C
ATOM   1038  C   VAL   124     -42.808  15.523 -10.075  1.00 10.08           C
ATOM   1039  O   VAL   124     -43.218  14.350  -9.905  1.00  9.51           O
ATOM   1040  N   ILE   125     -43.617  16.526 -10.409  1.00  9.88           N
ATOM   1041  CA  ILE   125     -45.046  16.301 -10.630  1.00 10.74           C
ATOM   1042  CB  ILE   125     -45.803  17.624 -10.870  1.00 11.75           C
ATOM   1043  CG1 ILE   125     -45.744  18.498  -9.590  1.00  9.55           C
ATOM   1044  CD1 ILE   125     -46.274  17.830  -8.232  1.00 11.11           C
ATOM   1045  CG2 ILE   125     -47.298  17.363 -11.280  1.00 10.72           C
ATOM   1046  C   ILE   125     -45.254  15.309 -11.757  1.00 10.24           C
ATOM   1047  O   ILE   125     -46.088  14.386 -11.644  1.00 10.73           O
ATOM   1048  N   ARG   126     -44.483  15.459 -12.837  0.50 10.47           N
ATOM   1050  CA  ARG   126     -44.567  14.514 -13.947  0.50  9.91           C
ATOM   1052  CB  ARG   126     -43.607  14.907 -15.078  0.50  9.78           C
ATOM   1054  CG  ARG   126     -44.070  16.073 -15.874  0.50  8.97           C
ATOM   1056  CD  ARG   126     -43.145  16.305 -17.083  0.50 11.78           C
ATOM   1058  NE  ARG   126     -43.524  17.541 -17.757  0.50 13.41           N
ATOM   1060  CZ  ARG   126     -42.784  18.643 -17.773  0.50 18.19           C
ATOM   1062  NH1 ARG   126     -41.594  18.649 -17.187  0.50 18.32           N
ATOM   1064  NH2 ARG   126     -43.223  19.729 -18.401  0.50 20.28           N
ATOM   1066  C   ARG   126     -44.269  13.104 -13.483  0.50 10.39           C
ATOM   1068  O   ARG   126     -45.010  12.161 -13.806  0.50 11.26           O
ATOM   1070  N   LEU   127     -43.191  12.959 -12.717  1.00 10.18           N
ATOM   1071  CA  LEU   127     -42.747  11.653 -12.281  1.00 11.49           C
ATOM   1072  CB  LEU   127     -41.457  11.792 -11.470  1.00 12.45           C
ATOM   1073  CG  LEU   127     -40.836  10.551 -10.872  1.00 15.70           C
ATOM   1074  CD1 LEU   127     -40.489   9.503 -11.921  1.00 20.81           C
ATOM   1075  CD2 LEU   127     -39.573  10.988 -10.121  1.00 18.67           C
ATOM   1076  C   LEU   127     -43.864  10.955 -11.482  1.00  9.91           C
ATOM   1077  O   LEU   127     -44.173   9.757 -11.684  1.00 10.50           O
ATOM   1078  N   LEU   128     -44.458  11.703 -10.559  1.00  8.79           N
ATOM   1079  CA  LEU   128     -45.555  11.167  -9.751  1.00  9.28           C
ATOM   1080  CB  LEU   128     -45.959  12.213  -8.701  1.00  9.38           C
ATOM   1081  CG  LEU   128     -44.895  12.460  -7.628  1.00 11.13           C
ATOM   1082  CD1 LEU   128     -45.399  13.599  -6.743  1.00 11.82           C
ATOM   1083  CD2 LEU   128     -44.635  11.243  -6.755  1.00 13.49           C
ATOM   1084  C   LEU   128     -46.755  10.814 -10.630  1.00 10.57           C
ATOM   1085  O   LEU   128     -47.393   9.762 -10.464  1.00  8.87           O
ATOM   1086  N   ALA   129     -47.111  11.725 -11.531  1.00  9.99           N
ATOM   1087  CA  ALA   129     -48.264  11.513 -12.419  1.00 10.43           C
ATOM   1088  CB  ALA   129     -48.466  12.756 -13.298  1.00 10.04           C
ATOM   1089  C   ALA   129     -48.072  10.270 -13.290  1.00  9.53           C
ATOM   1090  O   ALA   129     -49.010   9.490 -13.509  1.00  9.22           O
ATOM   1091  N   GLU   130     -46.842  10.075 -13.777  1.00 10.54           N
ATOM   1092  CA  GLU   130     -46.555   8.883 -14.586  1.00 10.65           C
ATOM   1093  CB  GLU   130     -45.130   8.957 -15.080  1.00 11.71           C
ATOM   1094  CG  GLU   130     -45.015   9.922 -16.236  1.00 15.98           C
ATOM   1095  CD  GLU   130     -43.548  10.268 -16.577  1.00 25.12           C
ATOM   1096  OE1 GLU   130     -42.602   9.684 -15.991  1.00 26.80           O
ATOM   1097  OE2 GLU   130     -43.362  11.157 -17.432  1.00 30.61           O
ATOM   1098  C   GLU   130     -46.799   7.589 -13.828  1.00 10.74           C
ATOM   1099  O   GLU   130     -47.364   6.626 -14.382  1.00  9.75           O
ATOM   1100  N   SER   131     -46.395   7.580 -12.558  0.50 10.14           N
ATOM   1102  CA  SER   131     -46.583   6.411 -11.722  0.50 10.49           C
ATOM   1104  CB  SER   131     -45.843   6.578 -10.396  0.50 11.10           C
ATOM   1106  OG  SER   131     -45.705   5.328  -9.775  0.50 10.69           O
ATOM   1108  C   SER   131     -48.057   6.142 -11.458  0.50 10.47           C
ATOM   1110  O   SER   131     -48.497   4.991 -11.474  0.50  9.95           O
ATOM   1112  N   ILE   132     -48.806   7.214 -11.186  1.00  9.30           N
ATOM   1113  CA  ILE   132     -50.274   7.155 -11.007  1.00 10.27           C
ATOM   1114  CB  ILE   132     -50.819   8.528 -10.573  1.00 10.43           C
ATOM   1115  CG1 ILE   132     -50.217   8.879  -9.199  1.00 10.19           C
ATOM   1116  CD1 ILE   132     -50.537  10.321  -8.694  1.00 10.55           C
ATOM   1117  CG2 ILE   132     -52.352   8.522 -10.544  1.00 12.86           C
ATOM   1118  C   ILE   132     -50.956   6.643 -12.274  1.00 10.09           C
ATOM   1119  O   ILE   132     -51.855   5.784 -12.188  1.00  9.47           O
ATOM   1120  N   GLU   133     -50.535   7.164 -13.426  0.50 10.08           N
ATOM   1122  CA  GLU   133     -51.024   6.713 -14.732  0.50 10.68           C
ATOM   1124  CB  GLU   133     -50.390   7.549 -15.871  0.50 10.91           C
ATOM   1126  CG  GLU   133     -51.050   8.940 -16.009  0.50 12.45           C
ATOM   1128  CD  GLU   133     -50.193  10.029 -16.674  0.50 14.41           C
ATOM   1130  OE1 GLU   133     -48.998   9.781 -16.983  0.50 17.78           O
ATOM   1132  OE2 GLU   133     -50.748  11.144 -16.892  0.50 18.07           O
ATOM   1134  C   GLU   133     -50.823   5.208 -14.941  0.50  9.88           C
ATOM   1136  O   GLU   133     -51.712   4.518 -15.430  0.50 10.09           O
ATOM   1138  N   ALA   134     -49.659   4.695 -14.546  1.00  9.31           N
ATOM   1139  CA  ALA   134     -49.346   3.267 -14.674  1.00  9.01           C
ATOM   1140  CB  ALA   134     -47.869   3.011 -14.361  1.00  9.38           C
ATOM   1141  C   ALA   134     -50.237   2.445 -13.765  1.00  9.17           C
ATOM   1142  O   ALA   134     -50.720   1.372 -14.144  1.00  9.07           O
ATOM   1143  N   GLY   135     -50.446   2.954 -12.554  1.00  9.74           N
ATOM   1144  CA  GLY   135     -51.304   2.264 -11.598  1.00  9.68           C
ATOM   1145  C   GLY   135     -52.748   2.231 -12.081  1.00 10.54           C
ATOM   1146  O   GLY   135     -53.432   1.261 -11.841  1.00 11.18           O
ATOM   1147  N   MET   136     -53.212   3.294 -12.736  1.00 10.78           N
ATOM   1148  CA  MET   136     -54.550   3.319 -13.316  1.00 14.00           C
ATOM   1149  CB  MET   136     -54.856   4.709 -13.853  1.00 12.19           C
ATOM   1150  CG  MET   136     -55.025   5.738 -12.769  1.00 17.50           C
ATOM   1151  SD  MET   136     -55.390   7.532 -13.517  0.80 27.77          SE
ATOM   1152  CE  MET   136     -56.956   7.128 -14.509  1.00 24.50           C
ATOM   1153  C   MET   136     -54.690   2.274 -14.426  1.00 11.62           C
ATOM   1154  O   MET   136     -55.630   1.461 -14.414  1.00 11.88           O
ATOM   1155  N   THR   137     -53.704   2.228 -15.331  1.00 10.74           N
ATOM   1156  CA  THR   137     -53.673   1.197 -16.405  1.00  9.88           C
ATOM   1157  CB  THR   137     -52.401   1.371 -17.285  1.00  9.89           C
ATOM   1158  OG1 THR   137     -52.434   2.676 -17.872  1.00 11.23           O
ATOM   1159  CG2 THR   137     -52.311   0.289 -18.374  1.00 10.49           C
ATOM   1160  C   THR   137     -53.735  -0.220 -15.824  1.00  9.70           C
ATOM   1161  O   THR   137     -54.451  -1.096 -16.313  1.00  8.79           O
ATOM   1162  N   ARG   138     -53.012  -0.433 -14.737  1.00 10.06           N
ATOM   1163  CA  ARG   138     -52.962  -1.726 -14.092  1.00 10.50           C
ATOM   1164  CB  ARG   138     -51.753  -1.827 -13.178  1.00 10.22           C
ATOM   1165  CG  ARG   138     -50.421  -1.961 -13.926  1.00 11.00           C
ATOM   1166  CD  ARG   138     -49.267  -1.783 -12.921  1.00 11.40           C
ATOM   1167  NE  ARG   138     -49.385  -2.776 -11.860  1.00 13.48           N
ATOM   1168  CZ  ARG   138     -48.694  -2.749 -10.731  1.00 16.65           C
ATOM   1169  NH1 ARG   138     -47.798  -1.778 -10.519  1.00 13.97           N
ATOM   1170  NH2 ARG   138     -48.909  -3.699  -9.812  1.00 18.04           N
ATOM   1171  C   ARG   138     -54.233  -2.088 -13.308  1.00 11.15           C
ATOM   1172  O   ARG   138     -54.391  -3.238 -12.908  1.00 11.80           O
ATOM   1173  N   GLY   139     -55.117  -1.122 -13.103  1.00 12.43           N
ATOM   1174  CA  GLY   139     -56.308  -1.342 -12.309  1.00 12.85           C
ATOM   1175  C   GLY   139     -56.098  -1.206 -10.803  1.00 14.77           C
ATOM   1176  O   GLY   139     -57.031  -1.500 -10.021  1.00 15.21           O
ATOM   1177  N   LEU   140     -54.904  -0.785 -10.370  1.00 14.40           N
ATOM   1178  CA  LEU   140     -54.663  -0.525  -8.930  1.00 15.70           C
ATOM   1179  CB  LEU   140     -53.175  -0.325  -8.608  1.00 17.02           C
ATOM   1180  CG  LEU   140     -52.165  -1.407  -8.937  1.00 20.06           C
ATOM   1181  CD1 LEU   140     -50.855  -0.921  -8.327  1.00 24.89           C
ATOM   1182  CD2 LEU   140     -52.585  -2.711  -8.319  1.00 24.25           C
ATOM   1183  C   LEU   140     -55.356   0.744  -8.489  1.00 14.92           C
ATOM   1184  O   LEU   140     -55.818   0.834  -7.342  1.00 14.43           O
ATOM   1185  N   PHE   141     -55.378   1.734  -9.384  1.00 13.97           N
ATOM   1186  CA  PHE   141     -55.934   3.051  -9.092  1.00 15.04           C
ATOM   1187  CB  PHE   141     -54.894   4.159  -9.339  1.00 13.91           C
ATOM   1188  CG  PHE   141     -53.627   4.016  -8.510  1.00 13.77           C
ATOM   1189  CD1 PHE   141     -53.668   3.442  -7.227  1.00 13.85           C
ATOM   1190  CE1 PHE   141     -52.491   3.310  -6.463  1.00 13.85           C
ATOM   1191  CZ  PHE   141     -51.267   3.776  -7.000  1.00 12.20           C
ATOM   1192  CE2 PHE   141     -51.240   4.341  -8.294  1.00 10.44           C
ATOM   1193  CD2 PHE   141     -52.392   4.479  -9.011  1.00 12.75           C
ATOM   1194  C   PHE   141     -57.151   3.307  -9.951  1.00 15.74           C
ATOM   1195  O   PHE   141     -57.249   2.777 -11.067  1.00 14.26           O
ATOM   1196  N   ARG   142     -58.074   4.120  -9.443  0.50 16.15           N
ATOM   1198  CA  ARG   142     -59.333   4.428 -10.124  0.50 17.47           C
ATOM   1200  CB  ARG   142     -60.256   5.250  -9.227  0.50 17.67           C
ATOM   1202  CG  ARG   142     -60.907   4.514  -8.115  0.50 18.73           C
ATOM   1204  CD  ARG   142     -61.871   5.446  -7.428  0.50 20.28           C
ATOM   1206  NE  ARG   142     -61.191   6.543  -6.744  0.50 20.28           N
ATOM   1208  CZ  ARG   142     -61.802   7.632  -6.287  0.50 20.99           C
ATOM   1210  NH1 ARG   142     -63.104   7.797  -6.474  0.50 17.88           N
ATOM   1212  NH2 ARG   142     -61.099   8.580  -5.668  0.50 20.92           N
ATOM   1214  C   ARG   142     -59.126   5.255 -11.374  0.50 17.70           C
ATOM   1216  O   ARG   142     -58.339   6.198 -11.388  0.50 18.50           O
ATOM   1218  N   ARG   143     -59.912   4.938 -12.395  1.00 18.41           N
ATOM   1219  CA  ARG   143     -59.747   5.554 -13.691  1.00 19.17           C
ATOM   1220  CB  ARG   143     -60.007   4.550 -14.785  1.00 19.39           C
ATOM   1221  CG  ARG   143     -58.965   3.434 -14.827  1.00 22.29           C
ATOM   1222  CD  ARG   143     -59.450   2.272 -15.677  1.00 26.49           C
ATOM   1223  NE  ARG   143     -58.403   1.273 -15.895  1.00 30.12           N
ATOM   1224  CZ  ARG   143     -58.545  -0.047 -15.757  1.00 31.21           C
ATOM   1225  NH1 ARG   143     -59.715  -0.594 -15.415  1.00 32.67           N
ATOM   1226  NH2 ARG   143     -57.502  -0.838 -15.984  1.00 31.42           N
ATOM   1227  C   ARG   143     -60.507   6.857 -13.893  1.00 18.83           C
ATOM   1228  O   ARG   143     -60.315   7.510 -14.913  1.00 20.12           O
ATOM   1229  N   ASP   144     -61.324   7.254 -12.917  1.00 17.76           N
ATOM   1230  CA  ASP   144     -62.025   8.547 -12.977  1.00 16.37           C
ATOM   1231  CB  ASP   144     -63.426   8.450 -12.354  1.00 16.63           C
ATOM   1232  CG  ASP   144     -63.395   8.116 -10.877  1.00 17.52           C
ATOM   1233  OD1 ASP   144     -62.398   7.530 -10.424  1.00 17.03           O
ATOM   1234  OD2 ASP   144     -64.383   8.426 -10.159  1.00 20.81           O
ATOM   1235  C   ASP   144     -61.281   9.716 -12.339  1.00 15.58           C
ATOM   1236  O   ASP   144     -61.871  10.803 -12.135  1.00 16.22           O
ATOM   1237  N   LEU   145     -60.024   9.520 -11.954  0.50 14.65           N
ATOM   1239  CA  LEU   145     -59.257  10.650 -11.435  0.50 13.62           C
ATOM   1241  CB  LEU   145     -58.748  10.426 -10.005  0.50 13.58           C
ATOM   1243  CG  LEU   145     -59.708  10.249  -8.827  0.50 13.00           C
ATOM   1245  CD1 LEU   145     -58.863   9.721  -7.686  0.50 13.60           C
ATOM   1247  CD2 LEU   145     -60.478  11.539  -8.398  0.50 13.09           C
ATOM   1249  C   LEU   145     -58.106  10.962 -12.376  0.50 13.00           C
ATOM   1251  O   LEU   145     -57.581  10.079 -13.050  0.50 12.96           O
ATOM   1253  N   HIS   146     -57.762  12.235 -12.428  1.00 12.38           N
ATOM   1254  CA  HIS   146     -56.767  12.749 -13.335  1.00 11.72           C
ATOM   1255  CB  HIS   146     -57.099  14.174 -13.754  1.00 13.12           C
ATOM   1256  CG  HIS   146     -58.088  14.223 -14.890  1.00 18.87           C
ATOM   1257  ND1 HIS   146     -59.407  14.593 -14.717  1.00 23.34           N
ATOM   1258  CE1 HIS   146     -60.041  14.495 -15.875  1.00 23.61           C
ATOM   1259  NE2 HIS   146     -59.189  14.056 -16.787  1.00 22.78           N
ATOM   1260  CD2 HIS   146     -57.966  13.859 -16.194  1.00 21.18           C
ATOM   1261  C   HIS   146     -55.432  12.632 -12.658  1.00  9.97           C
ATOM   1262  O   HIS   146     -55.283  13.064 -11.523  1.00  8.48           O
ATOM   1263  N   ALA   147     -54.466  12.063 -13.380  1.00  8.06           N
ATOM   1264  CA  ALA   147     -53.171  11.743 -12.792  1.00  7.43           C
ATOM   1265  CB  ALA   147     -52.303  10.976 -13.795  1.00  7.64           C
ATOM   1266  C   ALA   147     -52.415  12.975 -12.255  1.00  7.37           C
ATOM   1267  O   ALA   147     -51.892  12.935 -11.149  1.00  7.42           O
ATOM   1268  N   VAL   148     -52.323  14.040 -13.057  1.00  5.91           N
ATOM   1269  CA  VAL   148     -51.580  15.234 -12.596  1.00  5.28           C
ATOM   1270  CB  VAL   148     -51.376  16.285 -13.741  1.00  5.29           C
ATOM   1271  CG1 VAL   148     -50.894  17.623 -13.160  1.00  5.38           C
ATOM   1272  CG2 VAL   148     -50.385  15.716 -14.827  1.00  7.18           C
ATOM   1273  C   VAL   148     -52.285  15.874 -11.417  1.00  5.21           C
ATOM   1274  O   VAL   148     -51.641  16.225 -10.424  1.00  4.80           O
ATOM   1275  N   ASN   149     -53.605  16.034 -11.475  1.00  5.51           N
ATOM   1276  CA  ASN   149     -54.259  16.664 -10.322  1.00  5.65           C
ATOM   1277  CB  ASN   149     -55.765  16.822 -10.566  1.00  6.66           C
ATOM   1278  CG  ASN   149     -56.088  18.026 -11.409  1.00 10.17           C
ATOM   1279  OD1 ASN   149     -55.200  18.846 -11.725  1.00 12.80           O
ATOM   1280  ND2 ASN   149     -57.358  18.143 -11.798  1.00 12.10           N
ATOM   1281  C   ASN   149     -54.045  15.842  -9.043  1.00  6.11           C
ATOM   1282  O   ASN   149     -53.933  16.413  -7.953  1.00  4.78           O
ATOM   1283  N   SER   150     -53.988  14.513  -9.207  1.00  5.76           N
ATOM   1284  CA  SER   150     -53.748  13.564  -8.084  1.00  6.08           C
ATOM   1285  CB  SER   150     -54.027  12.096  -8.522  1.00  5.78           C
ATOM   1286  OG  SER   150     -55.422  11.927  -8.837  1.00  7.08           O
ATOM   1287  C   SER   150     -52.331  13.717  -7.550  1.00  5.66           C
ATOM   1288  O   SER   150     -52.119  13.810  -6.341  1.00  5.57           O
ATOM   1289  N   ALA   151     -51.349  13.768  -8.451  1.00  5.77           N
ATOM   1290  CA  ALA   151     -49.966  14.064  -8.076  1.00  5.41           C
ATOM   1291  CB  ALA   151     -49.086  14.156  -9.326  1.00  5.18           C
ATOM   1292  C   ALA   151     -49.874  15.386  -7.279  1.00  5.91           C
ATOM   1293  O   ALA   151     -49.179  15.466  -6.262  1.00  6.61           O
ATOM   1294  N   LEU   152     -50.552  16.425  -7.784  1.00  6.31           N
ATOM   1295  CA  LEU   152     -50.534  17.749  -7.110  1.00  5.72           C
ATOM   1296  CB  LEU   152     -51.297  18.807  -7.921  1.00  4.81           C
ATOM   1297  CG  LEU   152     -50.598  19.222  -9.218  1.00  4.27           C
ATOM   1298  CD1 LEU   152     -51.572  20.071 -10.072  1.00  6.58           C
ATOM   1299  CD2 LEU   152     -49.276  20.001  -8.973  1.00  5.18           C
ATOM   1300  C   LEU   152     -51.132  17.647  -5.707  1.00  7.70           C
ATOM   1301  O   LEU   152     -50.626  18.296  -4.766  1.00  7.69           O
ATOM   1302  N   ALA   153     -52.188  16.836  -5.551  1.00  6.37           N
ATOM   1303  CA  ALA   153     -52.794  16.600  -4.245  1.00  7.16           C
ATOM   1304  CB  ALA   153     -54.029  15.679  -4.378  1.00  5.65           C
ATOM   1305  C   ALA   153     -51.787  16.008  -3.247  1.00  7.42           C
ATOM   1306  O   ALA   153     -51.667  16.511  -2.117  1.00  6.88           O
ATOM   1307  N   LEU   154     -51.039  14.972  -3.683  1.00  5.98           N
ATOM   1308  CA  LEU   154     -50.031  14.354  -2.805  1.00  5.94           C
ATOM   1309  CB  LEU   154     -49.453  13.092  -3.458  1.00  6.06           C
ATOM   1310  CG  LEU   154     -48.400  12.364  -2.617  1.00  6.43           C
ATOM   1311  CD1 LEU   154     -48.990  11.876  -1.271  1.00  5.45           C
ATOM   1312  CD2 LEU   154     -47.790  11.240  -3.434  1.00  7.02           C
ATOM   1313  C   LEU   154     -48.921  15.373  -2.447  1.00  5.85           C
ATOM   1314  O   LEU   154     -48.530  15.518  -1.271  1.00  6.15           O
ATOM   1315  N   ALA   155     -48.449  16.084  -3.464  1.00  6.37           N
ATOM   1316  CA  ALA   155     -47.402  17.083  -3.242  1.00  6.90           C
ATOM   1317  CB  ALA   155     -46.984  17.689  -4.593  1.00  7.15           C
ATOM   1318  C   ALA   155     -47.927  18.147  -2.260  1.00  6.59           C
ATOM   1319  O   ALA   155     -47.181  18.625  -1.387  1.00  7.17           O
ATOM   1320  N   GLY   156     -49.204  18.510  -2.409  1.00  6.53           N
ATOM   1321  CA  GLY   156     -49.808  19.558  -1.574  1.00  7.23           C
ATOM   1322  C   GLY   156     -49.903  19.117  -0.129  1.00  8.33           C
ATOM   1323  O   GLY   156     -49.684  19.935   0.770  1.00  9.18           O
ATOM   1324  N   MET   157     -50.275  17.857   0.104  0.50  7.22           N
ATOM   1326  CA  MET   157     -50.394  17.342   1.473  0.50  9.40           C
ATOM   1328  CB  MET   157     -50.608  15.818   1.495  0.50  9.03           C
ATOM   1330  CG  MET   157     -51.950  15.368   1.037  0.50 10.44           C
ATOM   1332  SD  MET   157     -52.121  13.470   1.490  0.50 14.75          SE
ATOM   1334  CE  MET   157     -53.565  13.043   0.240  0.50 11.36           C
ATOM   1336  C   MET   157     -49.104  17.647   2.216  0.50  8.33           C
ATOM   1338  O   MET   157     -49.097  18.375   3.226  0.50  7.60           O
ATOM   1340  N   VAL   158     -48.020  17.067   1.700  1.00  7.62           N
ATOM   1341  CA  VAL   158     -46.738  17.073   2.389  1.00  7.60           C
ATOM   1342  CB  VAL   158     -45.769  16.001   1.870  1.00  7.87           C
ATOM   1343  CG1 VAL   158     -45.363  16.267   0.375  1.00  6.80           C
ATOM   1344  CG2 VAL   158     -44.556  15.904   2.800  1.00  5.50           C
ATOM   1345  C   VAL   158     -46.161  18.504   2.448  1.00  8.05           C
ATOM   1346  O   VAL   158     -45.655  18.951   3.498  1.00  7.94           O
ATOM   1347  N   ASN   159     -46.268  19.258   1.359  1.00  6.99           N
ATOM   1348  CA  ASN   159     -45.679  20.596   1.364  1.00  8.56           C
ATOM   1349  CB  ASN   159     -45.517  21.063  -0.110  1.00  9.44           C
ATOM   1350  CG  ASN   159     -44.267  20.391  -0.770  1.00 13.46           C
ATOM   1351  OD1 ASN   159     -43.115  20.774  -0.449  1.00 13.49           O
ATOM   1352  ND2 ASN   159     -44.491  19.365  -1.676  1.00 11.04           N
ATOM   1353  C   ASN   159     -46.491  21.532   2.299  1.00  8.55           C
ATOM   1354  O   ASN   159     -45.898  22.350   3.007  1.00  8.77           O
ATOM   1355  N   TYR   160     -47.807  21.324   2.393  1.00  8.99           N
ATOM   1356  CA  TYR   160     -48.598  22.206   3.289  1.00  8.46           C
ATOM   1357  CB  TYR   160     -50.076  22.031   3.041  1.00  9.05           C
ATOM   1358  CG  TYR   160     -50.895  23.089   3.758  1.00  6.76           C
ATOM   1359  CD1 TYR   160     -51.004  24.373   3.254  1.00  6.16           C
ATOM   1360  CE1 TYR   160     -51.755  25.374   3.951  1.00  6.68           C
ATOM   1361  CZ  TYR   160     -52.367  25.032   5.159  1.00  6.05           C
ATOM   1362  OH  TYR   160     -53.125  25.927   5.884  1.00  6.88           O
ATOM   1363  CE2 TYR   160     -52.260  23.729   5.663  1.00  7.56           C
ATOM   1364  CD2 TYR   160     -51.513  22.779   4.968  1.00  8.31           C
ATOM   1365  C   TYR   160     -48.297  21.873   4.749  1.00  8.41           C
ATOM   1366  O   TYR   160     -48.341  22.775   5.600  1.00  7.66           O
ATOM   1367  N   PHE   161     -48.025  20.596   5.064  1.00  7.26           N
ATOM   1368  CA  PHE   161     -47.662  20.273   6.467  1.00  7.86           C
ATOM   1369  CB  PHE   161     -47.311  18.790   6.604  1.00  7.74           C
ATOM   1370  CG  PHE   161     -46.983  18.392   7.998  1.00  9.30           C
ATOM   1371  CD1 PHE   161     -48.006  18.107   8.896  1.00 12.83           C
ATOM   1372  CE1 PHE   161     -47.720  17.697  10.215  1.00 11.42           C
ATOM   1373  CZ  PHE   161     -46.391  17.641  10.657  1.00 12.71           C
ATOM   1374  CE2 PHE   161     -45.357  17.968   9.769  1.00 10.83           C
ATOM   1375  CD2 PHE   161     -45.666  18.335   8.433  1.00 11.04           C
ATOM   1376  C   PHE   161     -46.491  21.148   6.954  1.00  7.95           C
ATOM   1377  O   PHE   161     -46.543  21.724   8.066  1.00  9.32           O
ATOM   1378  N   PHE   162     -45.463  21.301   6.114  1.00  6.72           N
ATOM   1379  CA  PHE   162     -44.318  22.124   6.507  1.00  7.65           C
ATOM   1380  CB  PHE   162     -43.078  21.726   5.710  1.00  7.99           C
ATOM   1381  CG  PHE   162     -42.566  20.366   6.105  1.00  9.27           C
ATOM   1382  CD1 PHE   162     -41.714  20.225   7.191  1.00 10.78           C
ATOM   1383  CE1 PHE   162     -41.239  18.956   7.593  1.00 11.91           C
ATOM   1384  CZ  PHE   162     -41.634  17.827   6.904  1.00 11.69           C
ATOM   1385  CE2 PHE   162     -42.511  17.965   5.784  1.00 13.79           C
ATOM   1386  CD2 PHE   162     -42.967  19.220   5.412  1.00 10.23           C
ATOM   1387  C   PHE   162     -44.639  23.608   6.400  1.00  6.36           C
ATOM   1388  O   PHE   162     -44.272  24.414   7.281  1.00  6.77           O
ATOM   1389  N   LEU   163     -45.339  23.986   5.329  1.00  6.53           N
ATOM   1390  CA  LEU   163     -45.685  25.410   5.150  1.00  6.76           C
ATOM   1391  CB  LEU   163     -46.531  25.576   3.876  1.00  6.66           C
ATOM   1392  CG  LEU   163     -46.960  27.017   3.573  1.00  7.04           C
ATOM   1393  CD1 LEU   163     -45.732  27.937   3.372  1.00  9.53           C
ATOM   1394  CD2 LEU   163     -47.878  27.026   2.294  1.00  8.47           C
ATOM   1395  C   LEU   163     -46.462  25.968   6.327  1.00  6.16           C
ATOM   1396  O   LEU   163     -46.251  27.132   6.716  1.00  6.46           O
ATOM   1397  N   SER   164     -47.398  25.156   6.872  1.00  5.30           N
ATOM   1398  CA  SER   164     -48.338  25.682   7.889  1.00  7.61           C
ATOM   1399  CB  SER   164     -49.657  24.912   7.802  1.00  8.19           C
ATOM   1400  OG  SER   164     -49.459  23.552   8.139  1.00  9.73           O
ATOM   1401  C   SER   164     -47.773  25.574   9.326  1.00  7.56           C
ATOM   1402  O   SER   164     -48.479  25.903  10.294  1.00  8.21           O
ATOM   1403  N   THR   165     -46.511  25.154   9.458  1.00  5.79           N
ATOM   1404  CA  THR   165     -45.964  24.822  10.782  1.00  6.26           C
ATOM   1405  CB  THR   165     -44.424  24.572  10.701  1.00  6.23           C
ATOM   1406  OG1 THR   165     -44.184  23.428   9.866  1.00  7.44           O
ATOM   1407  CG2 THR   165     -43.891  24.259  12.117  1.00  8.11           C
ATOM   1408  C   THR   165     -46.186  25.914  11.821  1.00  4.75           C
ATOM   1409  O   THR   165     -46.641  25.626  12.936  1.00  5.25           O
ATOM   1410  N   LEU   166     -45.844  27.165  11.481  1.00  5.75           N
ATOM   1411  CA  LEU   166     -45.911  28.235  12.482  1.00  6.51           C
ATOM   1412  CB  LEU   166     -45.339  29.576  11.965  1.00  6.68           C
ATOM   1413  CG  LEU   166     -43.841  29.678  11.719  1.00 10.81           C
ATOM   1414  CD1 LEU   166     -43.547  31.167  11.394  1.00 11.81           C
ATOM   1415  CD2 LEU   166     -43.055  29.293  13.016  1.00 11.69           C
ATOM   1416  C   LEU   166     -47.337  28.456  12.986  1.00  7.46           C
ATOM   1417  O   LEU   166     -47.491  28.973  14.095  1.00  8.56           O
ATOM   1418  N   ALA   167     -48.369  28.123  12.171  1.00  6.08           N
ATOM   1419  CA  ALA   167     -49.766  28.384  12.541  1.00  8.18           C
ATOM   1420  CB  ALA   167     -50.626  28.722  11.311  1.00  7.47           C
ATOM   1421  C   ALA   167     -50.387  27.203  13.251  1.00  8.91           C
ATOM   1422  O   ALA   167     -51.532  27.304  13.723  1.00  9.05           O
ATOM   1423  N   THR   168     -49.662  26.096  13.285  1.00  8.62           N
ATOM   1424  CA  THR   168     -50.264  24.857  13.794  1.00 10.98           C
ATOM   1425  CB  THR   168     -50.502  23.867  12.644  1.00  9.39           C
ATOM   1426  OG1 THR   168     -49.275  23.508  11.993  1.00 11.50           O
ATOM   1427  CG2 THR   168     -51.464  24.477  11.542  1.00  9.79           C
ATOM   1428  C   THR   168     -49.423  24.220  14.919  1.00 10.56           C
ATOM   1429  O   THR   168     -49.522  22.997  15.158  1.00 11.79           O
ATOM   1430  N   GLU   169     -48.671  25.069  15.639  1.00 13.47           N
ATOM   1431  CA  GLU   169     -47.634  24.567  16.568  1.00 14.51           C
ATOM   1432  CB  GLU   169     -46.793  25.705  17.190  1.00 15.58           C
ATOM   1433  CG  GLU   169     -45.950  26.533  16.217  1.00 16.67           C
ATOM   1434  CD  GLU   169     -44.641  25.858  15.769  1.00 18.06           C
ATOM   1435  OE1 GLU   169     -44.427  24.660  16.046  1.00 20.34           O
ATOM   1436  OE2 GLU   169     -43.824  26.515  15.088  1.00 17.77           O
ATOM   1437  C   GLU   169     -48.280  23.732  17.661  1.00 14.80           C
ATOM   1438  O   GLU   169     -47.758  22.662  18.045  1.00 15.84           O
ATOM   1439  N   GLY   170     -49.391  24.218  18.188  1.00 14.31           N
ATOM   1440  CA  GLY   170     -50.050  23.519  19.293  1.00 15.34           C
ATOM   1441  C   GLY   170     -51.115  22.570  18.807  1.00 14.96           C
ATOM   1442  O   GLY   170     -51.802  21.946  19.628  1.00 15.30           O
ATOM   1443  N   LEU   171     -51.257  22.405  17.486  1.00 11.97           N
ATOM   1444  CA  LEU   171     -52.364  21.571  16.985  1.00 12.07           C
ATOM   1445  CB  LEU   171     -53.048  22.173  15.739  1.00 11.20           C
ATOM   1446  CG  LEU   171     -53.567  23.620  15.751  1.00 13.56           C
ATOM   1447  CD1 LEU   171     -54.356  23.917  14.477  1.00 12.40           C
ATOM   1448  CD2 LEU   171     -54.410  23.968  16.985  1.00 16.09           C
ATOM   1449  C   LEU   171     -51.901  20.179  16.629  1.00 12.32           C
ATOM   1450  O   LEU   171     -52.706  19.251  16.620  1.00 12.27           O
ATOM   1451  N   THR   172     -50.620  20.021  16.304  1.00 11.32           N
ATOM   1452  CA  THR   172     -50.093  18.690  15.929  1.00 12.36           C
ATOM   1453  CB  THR   172     -50.439  18.296  14.451  1.00 11.94           C
ATOM   1454  OG1 THR   172     -50.076  16.907  14.240  1.00 16.35           O
ATOM   1455  CG2 THR   172     -49.710  19.217  13.452  1.00 12.29           C
ATOM   1456  C   THR   172     -48.585  18.711  16.141  1.00 12.72           C
ATOM   1457  O   THR   172     -47.994  19.812  16.226  1.00 13.87           O
ATOM   1458  N   SER   173     -47.958  17.545  16.214  1.00 12.97           N
ATOM   1459  CA  SER   173     -46.524  17.503  16.397  1.00 11.93           C
ATOM   1460  CB  SER   173     -46.103  16.108  16.826  1.00 13.97           C
ATOM   1461  OG  SER   173     -44.681  15.989  16.771  1.00 14.44           O
ATOM   1462  C   SER   173     -45.874  17.806  15.060  1.00 12.33           C
ATOM   1463  O   SER   173     -46.353  17.332  14.028  1.00 12.42           O
ATOM   1464  N   HIS   174     -44.824  18.610  15.068  1.00 12.00           N
ATOM   1465  CA  HIS   174     -43.970  18.721  13.876  1.00 14.23           C
ATOM   1466  CB  HIS   174     -43.909  20.171  13.391  1.00 14.23           C
ATOM   1467  CG  HIS   174     -45.247  20.722  13.030  1.00 15.81           C
ATOM   1468  ND1 HIS   174     -46.071  21.324  13.968  1.00 16.61           N
ATOM   1469  CE1 HIS   174     -47.185  21.718  13.368  1.00 20.91           C
ATOM   1470  NE2 HIS   174     -47.116  21.386  12.085  1.00 19.63           N
ATOM   1471  CD2 HIS   174     -45.900  20.785  11.839  1.00 17.42           C
ATOM   1472  C   HIS   174     -42.578  18.183  14.149  1.00 13.15           C
ATOM   1473  O   HIS   174     -41.625  18.515  13.427  1.00 14.79           O
ATOM   1474  N   SER   175     -42.456  17.352  15.179  1.00 14.28           N
ATOM   1475  CA  SER   175     -41.158  16.794  15.566  1.00 13.71           C
ATOM   1476  CB  SER   175     -41.281  16.104  16.921  1.00 14.35           C
ATOM   1477  OG  SER   175     -40.255  15.138  17.113  1.00 17.37           O
ATOM   1478  C   SER   175     -40.645  15.822  14.475  1.00 13.44           C
ATOM   1479  O   SER   175     -41.412  15.024  13.953  1.00 12.58           O
ATOM   1480  N   PRO   176     -39.341  15.882  14.146  1.00 13.15           N
ATOM   1481  CA  PRO   176     -38.830  14.880  13.178  1.00 13.22           C
ATOM   1482  CB  PRO   176     -37.342  15.224  13.064  1.00 13.70           C
ATOM   1483  CG  PRO   176     -37.228  16.655  13.534  1.00 13.98           C
ATOM   1484  CD  PRO   176     -38.278  16.806  14.593  1.00 13.08           C
ATOM   1485  C   PRO   176     -39.045  13.413  13.624  1.00 14.24           C
ATOM   1486  O   PRO   176     -39.154  12.527  12.770  1.00 13.21           O
ATOM   1487  N   ASP   177     -39.134  13.171  14.936  1.00 14.82           N
ATOM   1488  CA  ASP   177     -39.514  11.855  15.496  1.00 16.58           C
ATOM   1489  CB  ASP   177     -39.811  11.976  17.000  1.00 17.92           C
ATOM   1490  CG  ASP   177     -38.610  12.345  17.796  1.00 24.07           C
ATOM   1491  OD1 ASP   177     -37.500  12.389  17.204  1.00 30.89           O
ATOM   1492  OD2 ASP   177     -38.764  12.562  19.024  1.00 30.05           O
ATOM   1493  C   ASP   177     -40.780  11.270  14.887  1.00 15.97           C
ATOM   1494  O   ASP   177     -40.967  10.047  14.905  1.00 16.38           O
ATOM   1495  N   GLN   178     -41.655  12.147  14.404  1.00 14.77           N
ATOM   1496  CA  GLN   178     -42.965  11.735  13.923  1.00 15.23           C
ATOM   1497  CB  GLN   178     -44.057  12.637  14.515  1.00 16.28           C
ATOM   1498  CG  GLN   178     -44.212  12.558  16.075  1.00 18.38           C
ATOM   1499  CD  GLN   178     -44.416  11.148  16.555  1.00 24.89           C
ATOM   1500  OE1 GLN   178     -45.323  10.454  16.094  1.00 28.81           O
ATOM   1501  NE2 GLN   178     -43.556  10.694  17.466  1.00 23.68           N
ATOM   1502  C   GLN   178     -43.060  11.731  12.390  1.00 14.33           C
ATOM   1503  O   GLN   178     -44.153  11.563  11.837  1.00 14.25           O
ATOM   1504  N   ASP   179     -41.935  11.946  11.715  1.00 13.75           N
ATOM   1505  CA  ASP   179     -41.931  12.025  10.241  1.00 12.28           C
ATOM   1506  CB  ASP   179     -40.565  12.503   9.712  1.00 12.21           C
ATOM   1507  CG  ASP   179     -40.345  14.003   9.887  1.00 12.00           C
ATOM   1508  OD1 ASP   179     -41.340  14.728  10.133  1.00 12.73           O
ATOM   1509  OD2 ASP   179     -39.178  14.458   9.767  1.00 10.97           O
ATOM   1510  C   ASP   179     -42.333  10.695   9.583  1.00 12.43           C
ATOM   1511  O   ASP   179     -43.076  10.688   8.586  1.00 11.55           O
ATOM   1512  N   GLU   180     -41.873   9.564  10.129  1.00 12.85           N
ATOM   1513  CA  GLU   180     -42.244   8.281   9.539  1.00 13.39           C
ATOM   1514  CB  GLU   180     -41.363   7.129  10.047  1.00 14.36           C
ATOM   1515  CG  GLU   180     -39.961   7.112   9.416  1.00 16.71           C
ATOM   1516  CD  GLU   180     -39.971   6.815   7.917  1.00 18.99           C
ATOM   1517  OE1 GLU   180     -40.744   5.922   7.502  1.00 20.42           O
ATOM   1518  OE2 GLU   180     -39.200   7.469   7.161  1.00 18.63           O
ATOM   1519  C   GLU   180     -43.734   8.019   9.746  1.00 13.71           C
ATOM   1520  O   GLU   180     -44.403   7.448   8.873  1.00 13.28           O
ATOM   1521  N   GLU   181     -44.271   8.460  10.883  1.00 13.78           N
ATOM   1522  CA  GLU   181     -45.689   8.305  11.124  1.00 14.42           C
ATOM   1523  CB  GLU   181     -45.998   8.599  12.588  1.00 16.10           C
ATOM   1524  CG  GLU   181     -47.472   8.632  12.901  1.00 21.01           C
ATOM   1525  CD  GLU   181     -48.173   7.282  12.774  1.00 23.11           C
ATOM   1526  OE1 GLU   181     -47.514   6.228  12.665  1.00 24.17           O
ATOM   1527  OE2 GLU   181     -49.422   7.301  12.790  1.00 25.06           O
ATOM   1528  C   GLU   181     -46.494   9.212  10.185  1.00 14.14           C
ATOM   1529  O   GLU   181     -47.564   8.828   9.706  1.00 14.26           O
ATOM   1530  N   LEU   182     -45.956  10.396   9.878  1.00 13.08           N
ATOM   1531  CA  LEU   182     -46.604  11.293   8.915  1.00 13.64           C
ATOM   1532  CB  LEU   182     -45.865  12.643   8.831  1.00 12.83           C
ATOM   1533  CG  LEU   182     -46.579  13.680   7.940  1.00 14.91           C
ATOM   1534  CD1 LEU   182     -47.863  14.196   8.590  1.00 15.08           C
ATOM   1535  CD2 LEU   182     -45.644  14.827   7.575  1.00 15.95           C
ATOM   1536  C   LEU   182     -46.678  10.637   7.522  1.00 13.14           C
ATOM   1537  O   LEU   182     -47.718  10.661   6.855  1.00 14.11           O
ATOM   1538  N   ILE   183     -45.576  10.050   7.084  1.00 12.68           N
ATOM   1539  CA  ILE   183     -45.564   9.306   5.810  1.00 11.35           C
ATOM   1540  CB  ILE   183     -44.189   8.673   5.546  1.00 10.84           C
ATOM   1541  CG1 ILE   183     -43.122   9.766   5.347  1.00 12.02           C
ATOM   1542  CD1 ILE   183     -41.658   9.195   5.429  1.00 11.23           C
ATOM   1543  CG2 ILE   183     -44.228   7.768   4.309  1.00 11.12           C
ATOM   1544  C   ILE   183     -46.664   8.205   5.800  1.00 11.45           C
ATOM   1545  O   ILE   183     -47.422   8.086   4.830  1.00 10.62           O
ATOM   1546  N   ARG   184     -46.735   7.438   6.884  0.50 11.53           N
ATOM   1548  CA  ARG   184     -47.720   6.369   7.046  0.50 11.75           C
ATOM   1550  CB  ARG   184     -47.569   5.750   8.435  0.50 12.01           C
ATOM   1552  CG  ARG   184     -47.839   4.275   8.512  0.50 14.69           C
ATOM   1554  CD  ARG   184     -47.348   3.699   9.852  0.50 17.23           C
ATOM   1556  NE  ARG   184     -45.897   3.490   9.822  0.50 20.38           N
ATOM   1558  CZ  ARG   184     -45.023   3.988  10.695  0.50 19.61           C
ATOM   1560  NH1 ARG   184     -43.738   3.716  10.523  0.50 21.24           N
ATOM   1562  NH2 ARG   184     -45.415   4.720  11.740  0.50 16.19           N
ATOM   1564  C   ARG   184     -49.137   6.937   6.888  0.50 11.09           C
ATOM   1566  O   ARG   184     -49.974   6.363   6.185  0.50 10.52           O
ATOM   1568  N   GLN   185     -49.387   8.070   7.541  1.00 10.20           N
ATOM   1569  CA  GLN   185     -50.693   8.718   7.492  1.00 11.34           C
ATOM   1570  CB  GLN   185     -50.812   9.832   8.557  1.00 11.76           C
ATOM   1571  CG  GLN   185     -50.910   9.329   9.971  1.00 13.90           C
ATOM   1572  CD  GLN   185     -50.827  10.475  10.988  1.00 16.31           C
ATOM   1573  OE1 GLN   185     -51.146  11.627  10.670  1.00 24.88           O
ATOM   1574  NE2 GLN   185     -50.379  10.163  12.192  1.00 22.00           N
ATOM   1575  C   GLN   185     -51.069   9.294   6.120  1.00 10.79           C
ATOM   1576  O   GLN   185     -52.231   9.134   5.675  1.00 10.92           O
ATOM   1577  N   TYR   186     -50.095   9.901   5.436  1.00  9.48           N
ATOM   1578  CA  TYR   186     -50.375  10.550   4.165  1.00 10.97           C
ATOM   1579  CB  TYR   186     -49.386  11.701   3.929  1.00 11.73           C
ATOM   1580  CG  TYR   186     -49.831  12.983   4.689  1.00 11.89           C
ATOM   1581  CD1 TYR   186     -50.901  12.943   5.618  1.00 16.50           C
ATOM   1582  CE1 TYR   186     -51.319  14.116   6.323  1.00 16.69           C
ATOM   1583  CZ  TYR   186     -50.665  15.304   6.104  1.00 15.60           C
ATOM   1584  OH  TYR   186     -51.066  16.479   6.789  1.00 16.29           O
ATOM   1585  CE2 TYR   186     -49.579  15.336   5.236  1.00 15.60           C
ATOM   1586  CD2 TYR   186     -49.176  14.184   4.529  1.00 16.97           C
ATOM   1587  C   TYR   186     -50.456   9.510   3.024  1.00 10.48           C
ATOM   1588  O   TYR   186     -51.313   9.616   2.143  1.00 10.25           O
ATOM   1589  N   VAL   187     -49.660   8.448   3.114  1.00 10.81           N
ATOM   1590  CA  VAL   187     -49.813   7.308   2.195  1.00 11.07           C
ATOM   1591  CB  VAL   187     -48.750   6.195   2.457  1.00 12.17           C
ATOM   1592  CG1 VAL   187     -49.152   4.865   1.801  1.00 12.64           C
ATOM   1593  CG2 VAL   187     -47.381   6.636   1.948  1.00 12.10           C
ATOM   1594  C   VAL   187     -51.238   6.738   2.348  1.00 10.78           C
ATOM   1595  O   VAL   187     -51.902   6.468   1.365  1.00 11.55           O
ATOM   1596  N   ALA   188     -51.697   6.596   3.591  1.00 10.35           N
ATOM   1597  CA  ALA   188     -53.016   6.013   3.862  1.00 10.34           C
ATOM   1598  CB  ALA   188     -53.214   5.835   5.322  1.00 10.03           C
ATOM   1599  C   ALA   188     -54.109   6.923   3.278  1.00 10.52           C
ATOM   1600  O   ALA   188     -54.976   6.440   2.532  1.00 11.14           O
ATOM   1601  N   ILE   189     -54.067   8.223   3.582  1.00  9.18           N
ATOM   1602  CA  ILE   189     -55.064   9.134   3.022  1.00 10.18           C
ATOM   1603  CB  ILE   189     -54.855  10.573   3.534  1.00 10.61           C
ATOM   1604  CG1 ILE   189     -55.136  10.601   5.058  1.00 10.98           C
ATOM   1605  CD1 ILE   189     -54.723  11.960   5.716  1.00 13.83           C
ATOM   1606  CG2 ILE   189     -55.802  11.563   2.805  1.00 11.30           C
ATOM   1607  C   ILE   189     -55.041   9.113   1.474  1.00  9.70           C
ATOM   1608  O   ILE   189     -56.074   9.014   0.819  1.00  9.40           O
ATOM   1609  N   PHE   190     -53.857   9.209   0.889  1.00  9.58           N
ATOM   1610  CA  PHE   190     -53.805   9.360  -0.550  1.00  9.58           C
ATOM   1611  CB  PHE   190     -52.360   9.611  -0.993  1.00 10.23           C
ATOM   1612  CG  PHE   190     -52.226  10.008  -2.454  1.00  9.45           C
ATOM   1613  CD1 PHE   190     -52.917  11.128  -2.945  1.00  9.44           C
ATOM   1614  CE1 PHE   190     -52.804  11.478  -4.324  1.00  8.91           C
ATOM   1615  CZ  PHE   190     -51.991  10.716  -5.159  1.00  8.37           C
ATOM   1616  CE2 PHE   190     -51.307   9.595  -4.666  1.00 10.34           C
ATOM   1617  CD2 PHE   190     -51.432   9.256  -3.313  1.00  9.34           C
ATOM   1618  C   PHE   190     -54.341   8.115  -1.252  1.00 10.23           C
ATOM   1619  O   PHE   190     -55.013   8.227  -2.272  1.00 10.36           O
ATOM   1620  N   THR   191     -54.011   6.933  -0.728  1.00 10.49           N
ATOM   1621  CA  THR   191     -54.331   5.687  -1.425  1.00 11.39           C
ATOM   1622  CB  THR   191     -53.251   4.575  -1.187  1.00 11.16           C
ATOM   1623  OG1 THR   191     -53.129   4.320   0.203  1.00 13.70           O
ATOM   1624  CG2 THR   191     -51.894   5.021  -1.716  1.00 12.85           C
ATOM   1625  C   THR   191     -55.730   5.173  -1.057  1.00 11.49           C
ATOM   1626  O   THR   191     -56.413   4.630  -1.920  1.00 11.57           O
ATOM   1627  N   ARG   192     -56.142   5.361   0.207  1.00 11.47           N
ATOM   1628  CA  ARG   192     -57.377   4.780   0.764  1.00 12.54           C
ATOM   1629  CB  ARG   192     -57.043   3.762   1.863  1.00 13.38           C
ATOM   1630  CG  ARG   192     -56.218   2.608   1.352  1.00 19.78           C
ATOM   1631  CD  ARG   192     -55.838   1.648   2.458  1.00 27.83           C
ATOM   1632  NE  ARG   192     -54.833   2.186   3.390  1.00 31.16           N
ATOM   1633  CZ  ARG   192     -54.979   2.196   4.710  1.00 30.70           C
ATOM   1634  NH1 ARG   192     -56.099   1.741   5.268  1.00 34.65           N
ATOM   1635  NH2 ARG   192     -54.007   2.636   5.480  1.00 31.86           N
ATOM   1636  C   ARG   192     -58.394   5.793   1.313  1.00 11.41           C
ATOM   1637  O   ARG   192     -59.513   5.408   1.694  1.00 11.66           O
ATOM   1638  N   GLY   193     -57.999   7.067   1.407  1.00 10.15           N
ATOM   1639  CA  GLY   193     -58.897   8.124   1.894  1.00  9.23           C
ATOM   1640  C   GLY   193     -59.105   8.042   3.399  1.00 10.71           C
ATOM   1641  O   GLY   193     -58.465   7.238   4.070  1.00 11.66           O
ATOM   1642  N   ILE   194     -60.015   8.848   3.940  1.00 10.09           N
ATOM   1643  CA  ILE   194     -60.233   8.806   5.378  1.00 10.51           C
ATOM   1644  CB  ILE   194     -60.410  10.235   5.966  1.00  9.22           C
ATOM   1645  CG1 ILE   194     -61.635  10.937   5.378  1.00  9.15           C
ATOM   1646  CD1 ILE   194     -62.095  12.150   6.229  1.00 10.65           C
ATOM   1647  CG2 ILE   194     -59.149  11.099   5.736  1.00 10.26           C
ATOM   1648  C   ILE   194     -61.435   7.920   5.776  1.00 13.00           C
ATOM   1649  O   ILE   194     -61.677   7.686   6.986  1.00 11.91           O
ATOM   1650  N   MET   195     -62.162   7.427   4.770  0.80 13.74           N
ATOM   1652  CA  MET   195     -63.370   6.618   5.035  0.80 19.32           C
ATOM   1654  CB  MET   195     -64.062   6.224   3.735  0.80 17.64           C
ATOM   1656  CG  MET   195     -63.224   5.251   2.910  0.80 22.42           C
ATOM   1658  SD  MET   195     -64.053   4.614   1.255  0.80 35.82          SE
ATOM   1660  CE  MET   195     -65.779   4.059   1.995  0.80 28.19           C
ATOM   1662  C   MET   195     -63.024   5.348   5.798  0.80 17.09           C
ATOM   1664  O   MET   195     -61.945   4.789   5.620  0.80 16.40           O
ATOM   1666  N   ALA   196     -63.946   4.892   6.647  1.00 16.54           N
ATOM   1667  CA  ALA   196     -63.751   3.621   7.358  1.00 17.64           C
ATOM   1668  CB  ALA   196     -64.842   3.419   8.388  1.00 17.48           C
ATOM   1669  C   ALA   196     -63.706   2.435   6.397  1.00 18.42           C
ATOM   1670  O   ALA   196     -64.469   2.403   5.437  1.00 19.76           O
END
