
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  171 ( 1467),  selected  171 , name 2eh3_A
# Molecule2: number of CA atoms  192 ( 1477),  selected  192 , name T0454.pdb
# PARAMETERS: 2eh3_A.T0454.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     2_A      D       5          4.727
LGA    T     3_A      C       6          3.885
LGA    K     4_A      R       7          3.435
LGA    E     5_A      S       8          3.609
LGA    R     6_A      R       9          2.835
LGA    I     7_A      L      10          1.760
LGA    L     8_A      M      11          2.022
LGA    E     9_A      E      12          1.751
LGA    V    10_A      V      13          1.295
LGA    S    11_A      A      14          1.253
LGA    K    12_A      T      15          1.341
LGA    E    13_A      E      16          1.130
LGA    L    14_A      L      17          1.735
LGA    F    15_A      F      18          2.383
LGA    F    16_A      A      19          2.620
LGA    E    17_A      Q      20          3.084
LGA    K    18_A      -       -           -
LGA    G    19_A      K      21          0.597
LGA    Y    20_A      G      22          2.304
LGA    -       -      F      23           -
LGA    Q    21_A      Y      24          2.928
LGA    G    22_A      G      25          2.904
LGA    T    23_A      V      26          2.385
LGA    S    24_A      S      27          1.965
LGA    V    25_A      I      28          1.851
LGA    E    26_A      R      29          1.991
LGA    E    27_A      E      30          1.948
LGA    I    28_A      L      31          1.815
LGA    V    29_A      A      32          2.204
LGA    K    30_A      Q      33          2.202
LGA    R    31_A      A      34          2.082
LGA    A    32_A      A      35          1.913
LGA    N    33_A      G      36          2.287
LGA    L    34_A      A      37          2.024
LGA    S    35_A      S      38          2.393
LGA    K    36_A      I      39          2.394
LGA    G    37_A      S      40          2.988
LGA    A    38_A      M      41          2.740
LGA    F    39_A      I      42          1.990
LGA    Y    40_A      S      43          2.425
LGA    -       -      Y      44           -
LGA    F    41_A      H      45          0.814
LGA    H    42_A      F      46          1.890
LGA    F    43_A      G      47          1.607
LGA    K    44_A      G      48          3.513
LGA    S    45_A      K      49          3.396
LGA    K    46_A      -       -           -
LGA    E    47_A      E      50          2.838
LGA    E    48_A      G      51          3.102
LGA    L    49_A      L      52          2.514
LGA    I    50_A      Y      53          2.255
LGA    T    51_A      A      54          2.809
LGA    E    52_A      A      55          2.649
LGA    I    53_A      V      56          1.909
LGA    I    54_A      L      57          1.949
LGA    E    55_A      Q      58          2.076
LGA    R    56_A      E      59          2.144
LGA    T    57_A      Q      60          2.213
LGA    H    58_A      F      61          1.838
LGA    K    59_A      A      62          1.826
LGA    K    60_A      C      63          1.254
LGA    I    61_A      F      64          1.886
LGA    I    62_A      G      65          1.661
LGA    S    63_A      Q      66          1.329
LGA    L    64_A      -       -           -
LGA    F    65_A      L      67          0.717
LGA    E    66_A      D      68          2.531
LGA    E    67_A      D      69          4.488
LGA    N    68_A      I      70          4.429
LGA    K    69_A      R      71          2.616
LGA    E    70_A      G      72          2.271
LGA    K    71_A      Q      73          4.202
LGA    -       -      A      74           -
LGA    -       -      G      75           -
LGA    -       -      D      76           -
LGA    -       -      P      77           -
LGA    -       -      L      78           -
LGA    T    72_A      A      79          2.384
LGA    P    73_A      V      80          2.399
LGA    -       -      M      81           -
LGA    E    74_A      T      82          0.928
LGA    E    75_A      A      83          2.968
LGA    L    76_A      Y      84          3.573
LGA    L    77_A      L      85          1.971
LGA    E    78_A      R      86          0.675
LGA    X    79_A      W      87          1.948
LGA    F    80_A      T      88          2.015
LGA    L    81_A      I      89          1.468
LGA    E    82_A      Q      90          0.985
LGA    V    83_A      R      91          1.010
LGA    L    84_A      H      92          2.440
LGA    Y    85_A      R      93          2.816
LGA    R    86_A      N      94          1.819
LGA    E    87_A      N      95          1.686
LGA    K    88_A      P      96          2.244
LGA    K    89_A      Q      97          0.984
LGA    V    90_A      L      98          2.723
LGA    V    91_A      L      99          1.726
LGA    Y    92_A      R     100          0.992
LGA    I    93_A      F     101          2.425
LGA    F    94_A      Y     102          2.368
LGA    L    95_A      T     103          1.258
LGA    F    96_A      S     104          2.933
LGA    D    97_A      -       -           -
LGA    L    98_A      E     105          1.828
LGA    L    99_A      L     106          2.546
LGA    C   100_A      T     107          2.903
LGA    S   101_A      N     108          1.702
LGA    E   102_A      -       -           -
LGA    K   103_A      P     109          4.664
LGA    F   104_A      T     110          2.286
LGA    R   105_A      P     111           -
LGA    -       -      C     112           -
LGA    -       -      F     113           -
LGA    N   106_A      A     114          5.034
LGA    -       -      A     115           -
LGA    I   107_A      I     116           #
LGA    Y   108_A      V     117          4.773
LGA    F   109_A      S     118          4.152
LGA    E   110_A      P     119          4.340
LGA    K   111_A      A     120          3.587
LGA    I   112_A      I     121          2.315
LGA    E   113_A      A     122          1.965
LGA    D   114_A      S     123          2.895
LGA    A   115_A      V     124          2.570
LGA    K   116_A      I     125          1.295
LGA    R   117_A      R     126          2.102
LGA    R   118_A      L     127          3.387
LGA    F   119_A      L     128          3.367
LGA    E   120_A      A     129          3.285
LGA    K   121_A      E     130          4.329
LGA    F   122_A      -       -           -
LGA    L   123_A      S     131          2.074
LGA    E   124_A      -       -           -
LGA    K   125_A      -       -           -
LGA    H   126_A      -       -           -
LGA    F   127_A      I     132          4.362
LGA    P   128_A      E     133          3.134
LGA    -       -      A     134           -
LGA    -       -      G     135           -
LGA    -       -      M     136           -
LGA    -       -      T     137           -
LGA    -       -      R     138           -
LGA    -       -      G     139           -
LGA    -       -      L     140           -
LGA    S   129_A      F     141           #
LGA    K   130_A      R     142           #
LGA    -       -      R     143           -
LGA    -       -      D     144           -
LGA    -       -      L     145           -
LGA    A   131_A      H     146           #
LGA    E   132_A      A     147          2.162
LGA    -       -      V     148           -
LGA    I   133_A      N     149          4.915
LGA    L   134_A      S     150          3.766
LGA    S   135_A      A     151          1.410
LGA    E   136_A      L     152          2.104
LGA    I   137_A      A     153          2.047
LGA    I   138_A      L     154          0.923
LGA    L   139_A      A     155          1.086
LGA    G   140_A      G     156          1.768
LGA    F   141_A      M     157          1.175
LGA    L   142_A      V     158          1.824
LGA    R   143_A      N     159          2.322
LGA    Q   144_A      Y     160          1.834
LGA    L   145_A      F     161          1.292
LGA    I   146_A      F     162          2.205
LGA    L   147_A      L     163          1.722
LGA    H   148_A      S     164          1.056
LGA    Y   149_A      T     165          2.091
LGA    V   150_A      -       -           -
LGA    I   151_A      -       -           -
LGA    K   152_A      -       -           -
LGA    E   153_A      L     166          0.821
LGA    E   154_A      A     167           -
LGA    -       -      T     168           -
LGA    -       -      E     169           -
LGA    -       -      G     170           -
LGA    -       -      L     171           -
LGA    -       -      T     172           -
LGA    -       -      S     173           -
LGA    R   155_A      H     174          3.717
LGA    E   156_A      S     175          3.496
LGA    L   157_A      P     176          3.068
LGA    P   158_A      D     177          3.483
LGA    F   159_A      Q     178          4.161
LGA    L   160_A      D     179          4.935
LGA    K   161_A      E     180          4.696
LGA    E   162_A      E     181          2.957
LGA    K   163_A      L     182          2.577
LGA    L   164_A      I     183          3.343
LGA    R   165_A      R     184          2.777
LGA    E   166_A      Q     185          0.805
LGA    G   167_A      Y     186          1.106
LGA    L   168_A      V     187          1.084
LGA    K   169_A      A     188          2.967
LGA    L   170_A      I     189          3.435
LGA    I   171_A      F     190          2.511
LGA    F   172_A      T     191          3.596
LGA    -       -      R     192           -
LGA    -       -      G     193           -
LGA    -       -      I     194           -
LGA    -       -      M     195           -
LGA    -       -      A     196           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  171  192    5.0    153    2.63    13.73     50.122     5.603

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.777360 * X  +  -0.549869 * Y  +  -0.305542 * Z  +  40.930557
  Y_new =   0.263458 * X  +   0.156478 * Y  +  -0.951895 * Z  +  57.662827
  Z_new =   0.571228 * X  +  -0.820462 * Y  +   0.023228 * Z  + -23.265663 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.542493    1.599099  [ DEG:   -88.3784     91.6216 ]
  Theta =  -0.608002   -2.533591  [ DEG:   -34.8359   -145.1641 ]
  Phi   =   2.814828   -0.326765  [ DEG:   161.2778    -18.7222 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2eh3_A                                        
REMARK     2: T0454.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2eh3_A.T0454.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  171  192   5.0  153   2.63   13.73  50.122
REMARK  ---------------------------------------------------------- 
MOLECULE 2eh3_A
HEADER    TRANSCRIPTION                           03-MAR-07   2EH3              
TITLE     CRYSTAL STRUCTURE OF AQ_1058, A TRANSCRIPTIONAL REGULATOR             
TITLE    2 (TERR/ACRR FAMILY) FROM AQUIFEX AEOLICUS VF5                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: TRANSCRIPTIONAL REGULATOR;                                 
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: TETR/ACRR FAMILY;                                           
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: AQUIFEX AEOLICUS;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: VF5;                                                         
SOURCE   5 GENE: ACRR1;                                                         
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL-21-CODONPLUS(DE3)-RIL-X;                
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PET-21A                                   
KEYWDS    ALL ALPHA PROTEINS, TETRACYCLIN REPRESSOR-LIKE, C-TERMINAL            
KEYWDS   2 DOMAIN, HOMEODOMAIN-LIKE, DNA/RNA-BINDING 3-HELICAL BUNDLE,          
KEYWDS   3 HELIX-TURN-HELIX, STRUCTURAL GENOMICS, NPPSFA, NATIONAL              
KEYWDS   4 PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES,               
KEYWDS   5 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI,               
KEYWDS   6 TRANSCRIPTION                                                        
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.AGARI,A.SHINKAI,S.YOKOYAMA,S.KURAMITSU,RIKEN STRUCTURAL             
AUTHOR   2 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   04-SEP-07 2EH3    0                                                
JRNL        AUTH   Y.AGARI,A.SHINKAI,S.YOKOYAMA,S.KURAMITSU                     
JRNL        TITL   CRYSTAL STRUCTURE OF AQ_1058, A TRANSCRIPTIONAL              
JRNL        TITL 2 REGULATOR (TERR/ACRR FAMILY) FROM AQUIFEX AEOLICUS           
JRNL        TITL 3 VF5                                                          
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.55 ANGSTROMS.                                          
DBREF  2EH3 A    1   179  UNP    O67157   O67157_AQUAE     1    179             
SEQRES   1 A  179  MSE GLY THR LYS GLU ARG ILE LEU GLU VAL SER LYS GLU          
SEQRES   2 A  179  LEU PHE PHE GLU LYS GLY TYR GLN GLY THR SER VAL GLU          
SEQRES   3 A  179  GLU ILE VAL LYS ARG ALA ASN LEU SER LYS GLY ALA PHE          
SEQRES   4 A  179  TYR PHE HIS PHE LYS SER LYS GLU GLU LEU ILE THR GLU          
SEQRES   5 A  179  ILE ILE GLU ARG THR HIS LYS LYS ILE ILE SER LEU PHE          
SEQRES   6 A  179  GLU GLU ASN LYS GLU LYS THR PRO GLU GLU LEU LEU GLU          
SEQRES   7 A  179  MSE PHE LEU GLU VAL LEU TYR ARG GLU LYS LYS VAL VAL          
SEQRES   8 A  179  TYR ILE PHE LEU PHE ASP LEU LEU CYS SER GLU LYS PHE          
SEQRES   9 A  179  ARG ASN ILE TYR PHE GLU LYS ILE GLU ASP ALA LYS ARG          
SEQRES  10 A  179  ARG PHE GLU LYS PHE LEU GLU LYS HIS PHE PRO SER LYS          
SEQRES  11 A  179  ALA GLU ILE LEU SER GLU ILE ILE LEU GLY PHE LEU ARG          
SEQRES  12 A  179  GLN LEU ILE LEU HIS TYR VAL ILE LYS GLU GLU ARG GLU          
SEQRES  13 A  179  LEU PRO PHE LEU LYS GLU LYS LEU ARG GLU GLY LEU LYS          
SEQRES  14 A  179  LEU ILE PHE GLU GLY VAL LYS LYS CYS GLY                      
HET    MSE  A  79       8                                                       
HET     MG  A1001       1                                                       
HET     MG  A1002       1                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      MG MAGNESIUM ION                                                    
FORMUL   1  MSE    C5 H11 N O2 SE                                               
FORMUL   2   MG    2(MG 2+)                                                     
FORMUL   4  HOH   *202(H2 O)                                                    
CRYST1   49.857   54.919   73.144  90.00  90.00  90.00 P 21 21 2     4          
ATOM      1  N   GLY A   2     -16.162  28.139  -1.241  1.00 19.15           N  
ATOM      2  CA  GLY A   2     -15.379  29.358  -1.535  1.00 20.49           C  
ATOM      3  C   GLY A   2     -16.202  30.616  -1.367  1.00 20.32           C  
ATOM      4  O   GLY A   2     -17.242  30.607  -0.706  1.00 22.29           O  
ATOM      5  N   THR A   3     -15.743  31.697  -1.989  1.00 18.73           N  
ATOM      6  CA  THR A   3     -16.417  32.978  -1.895  1.00 17.73           C  
ATOM      7  C   THR A   3     -17.831  32.926  -2.442  1.00 16.08           C  
ATOM      8  O   THR A   3     -18.737  33.518  -1.851  1.00 15.14           O  
ATOM      9  CB  THR A   3     -15.607  34.054  -2.630  1.00 18.38           C  
ATOM     10  OG1 THR A   3     -14.308  34.145  -2.028  1.00 18.32           O  
ATOM     11  CG2 THR A   3     -16.283  35.373  -2.544  1.00 18.97           C  
ATOM     12  N   LYS A   4     -18.036  32.226  -3.559  1.00 15.24           N  
ATOM     13  CA  LYS A   4     -19.385  32.149  -4.130  1.00 14.74           C  
ATOM     14  C   LYS A   4     -20.320  31.473  -3.125  1.00 14.98           C  
ATOM     15  O   LYS A   4     -21.470  31.915  -2.928  1.00 14.46           O  
ATOM     16  CB  LYS A   4     -19.369  31.373  -5.449  1.00 17.18           C  
ATOM     17  CG  LYS A   4     -20.686  31.422  -6.183  1.00 17.62           C  
ATOM     18  CD  LYS A   4     -20.637  30.662  -7.518  1.00 20.58           C  
ATOM     19  CE  LYS A   4     -21.934  30.845  -8.301  1.00 20.56           C  
ATOM     20  NZ  LYS A   4     -21.738  30.396  -9.708  1.00 22.38           N  
ATOM     21  N   GLU A   5     -19.837  30.405  -2.498  1.00 15.34           N  
ATOM     22  CA  GLU A   5     -20.624  29.694  -1.507  1.00 16.15           C  
ATOM     23  C   GLU A   5     -20.941  30.601  -0.330  1.00 14.87           C  
ATOM     24  O   GLU A   5     -22.056  30.593   0.190  1.00 15.43           O  
ATOM     25  CB  GLU A   5     -19.870  28.465  -0.990  1.00 18.71           C  
ATOM     26  CG  GLU A   5     -19.858  27.277  -1.936  1.00 23.06           C  
ATOM     27  CD  GLU A   5     -19.209  27.582  -3.261  1.00 26.20           C  
ATOM     28  OE1 GLU A   5     -18.075  28.131  -3.276  1.00 27.98           O  
ATOM     29  OE2 GLU A   5     -19.842  27.258  -4.293  1.00 27.40           O  
ATOM     30  N   ARG A   6     -19.972  31.398   0.101  1.00 14.43           N  
ATOM     31  CA  ARG A   6     -20.234  32.277   1.234  1.00 14.78           C  
ATOM     32  C   ARG A   6     -21.299  33.323   0.898  1.00 13.19           C  
ATOM     33  O   ARG A   6     -22.186  33.611   1.722  1.00 14.70           O  
ATOM     34  CB  ARG A   6     -18.943  32.966   1.693  1.00 17.22           C  
ATOM     35  CG  ARG A   6     -17.986  32.017   2.376  1.00 21.71           C  
ATOM     36  CD  ARG A   6     -17.251  32.697   3.528  1.00 26.47           C  
ATOM     37  NE  ARG A   6     -16.228  33.631   3.070  1.00 30.59           N  
ATOM     38  CZ  ARG A   6     -16.392  34.940   2.913  1.00 30.34           C  
ATOM     39  NH1 ARG A   6     -17.557  35.524   3.175  1.00 30.63           N  
ATOM     40  NH2 ARG A   6     -15.367  35.671   2.497  1.00 31.57           N  
ATOM     41  N   ILE A   7     -21.217  33.888  -0.296  1.00 12.61           N  
ATOM     42  CA  ILE A   7     -22.205  34.876  -0.721  1.00 10.96           C  
ATOM     43  C   ILE A   7     -23.582  34.200  -0.748  1.00 11.38           C  
ATOM     44  O   ILE A   7     -24.561  34.768  -0.282  1.00 11.62           O  
ATOM     45  CB  ILE A   7     -21.869  35.407  -2.118  1.00 10.96           C  
ATOM     46  CG1 ILE A   7     -20.591  36.234  -2.045  1.00 12.62           C  
ATOM     47  CG2 ILE A   7     -23.016  36.248  -2.677  1.00 11.00           C  
ATOM     48  CD1 ILE A   7     -20.000  36.586  -3.408  1.00 13.35           C  
ATOM     49  N   LEU A   8     -23.662  33.001  -1.308  1.00 11.42           N  
ATOM     50  CA  LEU A   8     -24.948  32.308  -1.354  1.00 10.81           C  
ATOM     51  C   LEU A   8     -25.527  32.088   0.039  1.00 11.69           C  
ATOM     52  O   LEU A   8     -26.740  32.247   0.243  1.00 10.96           O  
ATOM     53  CB  LEU A   8     -24.790  30.969  -2.088  1.00 11.15           C  
ATOM     54  CG  LEU A   8     -24.682  31.155  -3.599  1.00 13.28           C  
ATOM     55  CD1 LEU A   8     -24.133  29.878  -4.248  1.00 15.65           C  
ATOM     56  CD2 LEU A   8     -26.048  31.503  -4.158  1.00 15.23           C  
ATOM     57  N   GLU A   9     -24.681  31.723   1.001  1.00 11.39           N  
ATOM     58  CA  GLU A   9     -25.160  31.465   2.356  1.00 12.80           C  
ATOM     59  C   GLU A   9     -25.672  32.719   3.036  1.00 13.10           C  
ATOM     60  O   GLU A   9     -26.751  32.699   3.650  1.00 12.55           O  
ATOM     61  CB  GLU A   9     -24.064  30.785   3.196  1.00 14.22           C  
ATOM     62  CG  GLU A   9     -23.750  29.356   2.723  1.00 19.82           C  
ATOM     63  CD  GLU A   9     -25.006  28.485   2.663  1.00 22.06           C  
ATOM     64  OE1 GLU A   9     -25.683  28.347   3.711  1.00 24.64           O  
ATOM     65  OE2 GLU A   9     -25.319  27.955   1.574  1.00 22.63           O  
ATOM     66  N   VAL A  10     -24.922  33.813   2.899  1.00 10.86           N  
ATOM     67  CA  VAL A  10     -25.322  35.079   3.492  1.00 12.70           C  
ATOM     68  C   VAL A  10     -26.621  35.576   2.853  1.00 12.78           C  
ATOM     69  O   VAL A  10     -27.499  36.088   3.551  1.00 11.37           O  
ATOM     70  CB  VAL A  10     -24.204  36.141   3.308  1.00 13.79           C  
ATOM     71  CG1 VAL A  10     -24.717  37.531   3.631  1.00 15.47           C  
ATOM     72  CG2 VAL A  10     -23.027  35.806   4.241  1.00 12.58           C  
ATOM     73  N   SER A  11     -26.740  35.420   1.533  1.00 11.62           N  
ATOM     74  CA  SER A  11     -27.926  35.910   0.801  1.00 10.32           C  
ATOM     75  C   SER A  11     -29.161  35.099   1.200  1.00 10.47           C  
ATOM     76  O   SER A  11     -30.254  35.651   1.361  1.00 11.06           O  
ATOM     77  CB  SER A  11     -27.701  35.843  -0.725  1.00 11.65           C  
ATOM     78  OG  SER A  11     -26.569  36.608  -1.128  1.00 12.86           O  
ATOM     79  N   LYS A  12     -28.997  33.799   1.363  1.00  9.90           N  
ATOM     80  CA  LYS A  12     -30.140  32.972   1.783  1.00 10.90           C  
ATOM     81  C   LYS A  12     -30.594  33.430   3.155  1.00 11.72           C  
ATOM     82  O   LYS A  12     -31.798  33.542   3.418  1.00 11.10           O  
ATOM     83  CB  LYS A  12     -29.762  31.480   1.822  1.00 12.65           C  
ATOM     84  CG  LYS A  12     -29.755  30.824   0.464  1.00 16.06           C  
ATOM     85  CD  LYS A  12     -29.558  29.306   0.549  1.00 18.07           C  
ATOM     86  CE  LYS A  12     -28.136  28.966   0.884  1.00 19.82           C  
ATOM     87  NZ  LYS A  12     -27.804  27.567   0.437  1.00 20.42           N  
ATOM     88  N   GLU A  13     -29.635  33.720   4.034  1.00 11.05           N  
ATOM     89  CA  GLU A  13     -29.984  34.179   5.368  1.00 12.57           C  
ATOM     90  C   GLU A  13     -30.722  35.516   5.350  1.00 11.02           C  
ATOM     91  O   GLU A  13     -31.791  35.630   5.973  1.00 11.11           O  
ATOM     92  CB  GLU A  13     -28.723  34.314   6.235  1.00 13.18           C  
ATOM     93  CG  GLU A  13     -28.228  32.977   6.783  1.00 23.22           C  
ATOM     94  CD  GLU A  13     -29.330  32.224   7.520  1.00 25.29           C  
ATOM     95  OE1 GLU A  13     -30.086  32.870   8.294  1.00 30.10           O  
ATOM     96  OE2 GLU A  13     -29.434  30.992   7.330  1.00 31.15           O  
ATOM     97  N   LEU A  14     -30.180  36.502   4.638  1.00 11.52           N  
ATOM     98  CA  LEU A  14     -30.825  37.809   4.595  1.00 11.07           C  
ATOM     99  C   LEU A  14     -32.177  37.769   3.880  1.00 10.99           C  
ATOM    100  O   LEU A  14     -33.119  38.391   4.338  1.00 10.51           O  
ATOM    101  CB  LEU A  14     -29.922  38.863   3.936  1.00 12.16           C  
ATOM    102  CG  LEU A  14     -28.672  39.148   4.761  1.00 12.27           C  
ATOM    103  CD1 LEU A  14     -27.884  40.226   4.060  1.00 15.71           C  
ATOM    104  CD2 LEU A  14     -29.053  39.554   6.201  1.00 15.71           C  
ATOM    105  N   PHE A  15     -32.277  37.055   2.755  1.00  9.62           N  
ATOM    106  CA  PHE A  15     -33.567  36.981   2.054  1.00 10.11           C  
ATOM    107  C   PHE A  15     -34.614  36.301   2.945  1.00  9.45           C  
ATOM    108  O   PHE A  15     -35.787  36.681   2.932  1.00 11.44           O  
ATOM    109  CB  PHE A  15     -33.453  36.198   0.743  1.00 10.85           C  
ATOM    110  CG  PHE A  15     -32.596  36.858  -0.314  1.00 10.47           C  
ATOM    111  CD1 PHE A  15     -32.318  38.228  -0.282  1.00 12.80           C  
ATOM    112  CD2 PHE A  15     -32.098  36.100  -1.373  1.00 10.84           C  
ATOM    113  CE1 PHE A  15     -31.558  38.830  -1.310  1.00 12.30           C  
ATOM    114  CE2 PHE A  15     -31.338  36.697  -2.402  1.00 10.65           C  
ATOM    115  CZ  PHE A  15     -31.076  38.063  -2.367  1.00 11.37           C  
ATOM    116  N   PHE A  16     -34.212  35.264   3.682  1.00  9.71           N  
ATOM    117  CA  PHE A  16     -35.116  34.565   4.595  1.00 10.68           C  
ATOM    118  C   PHE A  16     -35.600  35.527   5.680  1.00 11.12           C  
ATOM    119  O   PHE A  16     -36.798  35.623   5.970  1.00 12.38           O  
ATOM    120  CB  PHE A  16     -34.393  33.372   5.243  1.00 12.00           C  
ATOM    121  CG  PHE A  16     -35.188  32.679   6.317  1.00 12.00           C  
ATOM    122  CD1 PHE A  16     -36.326  31.956   5.999  1.00 12.52           C  
ATOM    123  CD2 PHE A  16     -34.797  32.764   7.650  1.00 12.82           C  
ATOM    124  CE1 PHE A  16     -37.072  31.325   6.992  1.00 14.66           C  
ATOM    125  CE2 PHE A  16     -35.528  32.139   8.644  1.00 13.68           C  
ATOM    126  CZ  PHE A  16     -36.670  31.416   8.316  1.00 14.45           C  
ATOM    127  N   GLU A  17     -34.661  36.265   6.246  1.00 12.09           N  
ATOM    128  CA  GLU A  17     -34.987  37.219   7.303  1.00 13.46           C  
ATOM    129  C   GLU A  17     -35.831  38.412   6.876  1.00 13.66           C  
ATOM    130  O   GLU A  17     -36.762  38.786   7.593  1.00 13.77           O  
ATOM    131  CB  GLU A  17     -33.703  37.743   7.964  1.00 16.73           C  
ATOM    132  CG  GLU A  17     -32.990  36.715   8.846  1.00 21.48           C  
ATOM    133  CD  GLU A  17     -33.854  36.203   9.991  1.00 24.56           C  
ATOM    134  OE1 GLU A  17     -34.457  37.024  10.707  1.00 26.76           O  
ATOM    135  OE2 GLU A  17     -33.920  34.971  10.187  1.00 28.56           O  
ATOM    136  N   LYS A  18     -35.537  38.992   5.723  1.00 12.49           N  
ATOM    137  CA  LYS A  18     -36.279  40.183   5.346  1.00 13.94           C  
ATOM    138  C   LYS A  18     -36.676  40.366   3.898  1.00 11.83           C  
ATOM    139  O   LYS A  18     -37.056  41.464   3.479  1.00 12.39           O  
ATOM    140  CB  LYS A  18     -35.524  41.398   5.863  1.00 14.83           C  
ATOM    141  CG  LYS A  18     -34.212  41.615   5.163  1.00 12.36           C  
ATOM    142  CD  LYS A  18     -33.232  42.178   6.154  1.00 16.21           C  
ATOM    143  CE  LYS A  18     -32.004  42.744   5.462  1.00 15.74           C  
ATOM    144  NZ  LYS A  18     -32.337  43.949   4.691  1.00 18.70           N  
ATOM    145  N   GLY A  19     -36.600  39.279   3.130  1.00 10.53           N  
ATOM    146  CA  GLY A  19     -37.035  39.323   1.745  1.00 10.18           C  
ATOM    147  C   GLY A  19     -36.026  39.768   0.706  1.00 11.34           C  
ATOM    148  O   GLY A  19     -35.059  40.449   1.018  1.00 12.61           O  
ATOM    149  N   TYR A  20     -36.272  39.368  -0.539  1.00 10.57           N  
ATOM    150  CA  TYR A  20     -35.419  39.729  -1.670  1.00 11.19           C  
ATOM    151  C   TYR A  20     -35.457  41.239  -1.959  1.00 11.88           C  
ATOM    152  O   TYR A  20     -34.410  41.877  -2.038  1.00 11.85           O  
ATOM    153  CB  TYR A  20     -35.881  38.967  -2.913  1.00 10.89           C  
ATOM    154  CG  TYR A  20     -35.151  39.358  -4.168  1.00 10.93           C  
ATOM    155  CD1 TYR A  20     -33.903  38.779  -4.491  1.00 11.06           C  
ATOM    156  CD2 TYR A  20     -35.714  40.261  -5.063  1.00 11.11           C  
ATOM    157  CE1 TYR A  20     -33.254  39.085  -5.686  1.00 11.73           C  
ATOM    158  CE2 TYR A  20     -35.068  40.579  -6.247  1.00 13.65           C  
ATOM    159  CZ  TYR A  20     -33.851  39.987  -6.555  1.00 12.54           C  
ATOM    160  OH  TYR A  20     -33.254  40.279  -7.760  1.00 14.79           O  
ATOM    161  N   GLN A  21     -36.653  41.814  -2.086  1.00 14.09           N  
ATOM    162  CA  GLN A  21     -36.765  43.244  -2.368  1.00 15.90           C  
ATOM    163  C   GLN A  21     -36.162  44.114  -1.273  1.00 15.72           C  
ATOM    164  O   GLN A  21     -35.571  45.170  -1.557  1.00 17.99           O  
ATOM    165  CB  GLN A  21     -38.233  43.645  -2.570  1.00 18.21           C  
ATOM    166  CG  GLN A  21     -38.945  42.942  -3.737  1.00 25.03           C  
ATOM    167  CD  GLN A  21     -38.368  43.258  -5.126  1.00 30.22           C  
ATOM    168  OE1 GLN A  21     -38.733  42.618  -6.120  1.00 34.05           O  
ATOM    169  NE2 GLN A  21     -37.480  44.241  -5.200  1.00 32.31           N  
ATOM    170  N   GLY A  22     -36.289  43.661  -0.033  1.00 15.06           N  
ATOM    171  CA  GLY A  22     -35.781  44.405   1.107  1.00 16.73           C  
ATOM    172  C   GLY A  22     -34.334  44.165   1.494  1.00 16.07           C  
ATOM    173  O   GLY A  22     -33.907  44.622   2.556  1.00 17.28           O  
ATOM    174  N   THR A  23     -33.587  43.462   0.641  1.00 14.07           N  
ATOM    175  CA  THR A  23     -32.171  43.192   0.895  1.00 13.18           C  
ATOM    176  C   THR A  23     -31.370  43.693  -0.284  1.00 12.76           C  
ATOM    177  O   THR A  23     -31.691  43.393  -1.419  1.00 14.91           O  
ATOM    178  CB  THR A  23     -31.923  41.690   1.091  1.00 11.04           C  
ATOM    179  OG1 THR A  23     -32.654  41.277   2.248  1.00 13.16           O  
ATOM    180  CG2 THR A  23     -30.449  41.402   1.306  1.00 13.00           C  
ATOM    181  N   SER A  24     -30.315  44.463  -0.005  1.00 13.45           N  
ATOM    182  CA  SER A  24     -29.488  45.022  -1.077  1.00 12.40           C  
ATOM    183  C   SER A  24     -28.154  44.295  -1.214  1.00 12.20           C  
ATOM    184  O   SER A  24     -27.735  43.575  -0.303  1.00 13.22           O  
ATOM    185  CB  SER A  24     -29.223  46.505  -0.791  1.00 13.18           C  
ATOM    186  OG  SER A  24     -28.356  46.631   0.329  1.00 15.01           O  
ATOM    187  N   VAL A  25     -27.500  44.474  -2.363  1.00 12.40           N  
ATOM    188  CA  VAL A  25     -26.198  43.875  -2.583  1.00 13.94           C  
ATOM    189  C   VAL A  25     -25.260  44.469  -1.537  1.00 13.96           C  
ATOM    190  O   VAL A  25     -24.403  43.773  -0.993  1.00 13.75           O  
ATOM    191  CB  VAL A  25     -25.712  44.177  -4.010  1.00 14.82           C  
ATOM    192  CG1 VAL A  25     -24.230  43.814  -4.155  1.00 17.49           C  
ATOM    193  CG2 VAL A  25     -26.569  43.400  -4.996  1.00 16.32           C  
ATOM    194  N   GLU A  26     -25.434  45.749  -1.225  1.00 13.98           N  
ATOM    195  CA  GLU A  26     -24.569  46.341  -0.219  1.00 15.84           C  
ATOM    196  C   GLU A  26     -24.675  45.632   1.142  1.00 13.62           C  
ATOM    197  O   GLU A  26     -23.663  45.391   1.791  1.00 14.45           O  
ATOM    198  CB  GLU A  26     -24.875  47.821  -0.047  1.00 18.63           C  
ATOM    199  CG  GLU A  26     -23.995  48.456   1.021  1.00 23.98           C  
ATOM    200  CD  GLU A  26     -22.521  48.103   0.840  1.00 28.56           C  
ATOM    201  OE1 GLU A  26     -21.942  48.481  -0.209  1.00 28.68           O  
ATOM    202  OE2 GLU A  26     -21.946  47.435   1.745  1.00 27.82           O  
ATOM    203  N   GLU A  27     -25.887  45.304   1.586  1.00 12.45           N  
ATOM    204  CA  GLU A  27     -26.060  44.620   2.868  1.00 11.96           C  
ATOM    205  C   GLU A  27     -25.444  43.214   2.846  1.00 11.97           C  
ATOM    206  O   GLU A  27     -24.884  42.743   3.837  1.00 12.04           O  
ATOM    207  CB  GLU A  27     -27.543  44.535   3.239  1.00 13.81           C  
ATOM    208  CG  GLU A  27     -28.181  45.895   3.449  1.00 14.44           C  
ATOM    209  CD  GLU A  27     -29.686  45.830   3.656  1.00 16.75           C  
ATOM    210  OE1 GLU A  27     -30.359  45.025   2.983  1.00 14.71           O  
ATOM    211  OE2 GLU A  27     -30.202  46.612   4.487  1.00 17.44           O  
ATOM    212  N   ILE A  28     -25.587  42.542   1.712  1.00 11.26           N  
ATOM    213  CA  ILE A  28     -25.037  41.202   1.553  1.00 11.04           C  
ATOM    214  C   ILE A  28     -23.513  41.219   1.662  1.00 11.32           C  
ATOM    215  O   ILE A  28     -22.931  40.435   2.428  1.00 10.24           O  
ATOM    216  CB  ILE A  28     -25.448  40.618   0.191  1.00 11.14           C  
ATOM    217  CG1 ILE A  28     -26.951  40.292   0.214  1.00 12.37           C  
ATOM    218  CG2 ILE A  28     -24.651  39.327  -0.125  1.00 12.59           C  
ATOM    219  CD1 ILE A  28     -27.531  40.030  -1.183  1.00 13.73           C  
ATOM    220  N   VAL A  29     -22.861  42.108   0.895  1.00 11.94           N  
ATOM    221  CA  VAL A  29     -21.398  42.112   0.941  1.00 12.47           C  
ATOM    222  C   VAL A  29     -20.867  42.601   2.283  1.00 13.08           C  
ATOM    223  O   VAL A  29     -19.816  42.129   2.740  1.00 12.73           O  
ATOM    224  CB  VAL A  29     -20.723  42.880  -0.249  1.00 13.45           C  
ATOM    225  CG1 VAL A  29     -21.109  42.216  -1.588  1.00 13.70           C  
ATOM    226  CG2 VAL A  29     -21.069  44.355  -0.231  1.00 14.15           C  
ATOM    227  N   LYS A  30     -21.595  43.513   2.933  1.00 13.07           N  
ATOM    228  CA  LYS A  30     -21.197  43.987   4.258  1.00 14.35           C  
ATOM    229  C   LYS A  30     -21.216  42.805   5.233  1.00 13.94           C  
ATOM    230  O   LYS A  30     -20.264  42.578   5.970  1.00 14.43           O  
ATOM    231  CB  LYS A  30     -22.168  45.052   4.760  1.00 16.40           C  
ATOM    232  CG  LYS A  30     -21.742  45.749   6.062  1.00 21.76           C  
ATOM    233  CD  LYS A  30     -22.816  46.743   6.547  1.00 25.00           C  
ATOM    234  CE  LYS A  30     -24.051  46.014   7.129  1.00 27.39           C  
ATOM    235  NZ  LYS A  30     -25.403  46.540   6.701  1.00 25.41           N  
ATOM    236  N   ARG A  31     -22.315  42.051   5.240  1.00 13.29           N  
ATOM    237  CA  ARG A  31     -22.440  40.915   6.144  1.00 14.36           C  
ATOM    238  C   ARG A  31     -21.390  39.840   5.852  1.00 14.57           C  
ATOM    239  O   ARG A  31     -20.881  39.180   6.767  1.00 16.18           O  
ATOM    240  CB  ARG A  31     -23.858  40.331   6.030  1.00 15.22           C  
ATOM    241  CG  ARG A  31     -24.084  39.044   6.809  1.00 17.45           C  
ATOM    242  CD  ARG A  31     -24.033  39.267   8.309  1.00 21.25           C  
ATOM    243  NE  ARG A  31     -25.151  40.067   8.819  1.00 23.43           N  
ATOM    244  CZ  ARG A  31     -26.371  39.596   9.074  1.00 23.63           C  
ATOM    245  NH1 ARG A  31     -26.651  38.316   8.867  1.00 24.66           N  
ATOM    246  NH2 ARG A  31     -27.317  40.405   9.547  1.00 24.24           N  
ATOM    247  N   ALA A  32     -21.052  39.673   4.579  1.00 14.04           N  
ATOM    248  CA  ALA A  32     -20.053  38.692   4.174  1.00 12.47           C  
ATOM    249  C   ALA A  32     -18.609  39.206   4.280  1.00 13.01           C  
ATOM    250  O   ALA A  32     -17.670  38.445   4.041  1.00 12.99           O  
ATOM    251  CB  ALA A  32     -20.313  38.263   2.737  1.00 12.22           C  
ATOM    252  N   ASN A  33     -18.439  40.485   4.620  1.00 13.72           N  
ATOM    253  CA  ASN A  33     -17.107  41.092   4.714  1.00 14.28           C  
ATOM    254  C   ASN A  33     -16.356  40.934   3.370  1.00 13.34           C  
ATOM    255  O   ASN A  33     -15.181  40.543   3.304  1.00 14.04           O  
ATOM    256  CB  ASN A  33     -16.286  40.481   5.863  1.00 15.07           C  
ATOM    257  CG  ASN A  33     -15.039  41.298   6.187  1.00 16.90           C  
ATOM    258  OD1 ASN A  33     -15.009  42.516   5.986  1.00 15.94           O  
ATOM    259  ND2 ASN A  33     -14.003  40.628   6.695  1.00 17.94           N  
ATOM    260  N   LEU A  34     -17.051  41.281   2.296  1.00 11.15           N  
ATOM    261  CA  LEU A  34     -16.502  41.207   0.947  1.00 12.20           C  
ATOM    262  C   LEU A  34     -16.697  42.517   0.229  1.00 10.80           C  
ATOM    263  O   LEU A  34     -17.527  43.353   0.618  1.00 11.40           O  
ATOM    264  CB  LEU A  34     -17.222  40.109   0.149  1.00 11.79           C  
ATOM    265  CG  LEU A  34     -16.979  38.681   0.591  1.00 13.30           C  
ATOM    266  CD1 LEU A  34     -17.968  37.782  -0.152  1.00 14.99           C  
ATOM    267  CD2 LEU A  34     -15.545  38.258   0.245  1.00 14.06           C  
ATOM    268  N   SER A  35     -15.933  42.694  -0.847  1.00 12.05           N  
ATOM    269  CA  SER A  35     -16.038  43.879  -1.676  1.00 12.03           C  
ATOM    270  C   SER A  35     -17.161  43.668  -2.680  1.00 11.71           C  
ATOM    271  O   SER A  35     -17.567  42.534  -2.934  1.00 13.33           O  
ATOM    272  CB  SER A  35     -14.762  44.082  -2.490  1.00 12.45           C  
ATOM    273  OG  SER A  35     -14.570  42.970  -3.376  1.00 13.70           O  
ATOM    274  N   LYS A  36     -17.632  44.755  -3.280  1.00 14.21           N  
ATOM    275  CA  LYS A  36     -18.649  44.633  -4.322  1.00 13.44           C  
ATOM    276  C   LYS A  36     -18.036  43.884  -5.525  1.00 14.28           C  
ATOM    277  O   LYS A  36     -18.708  43.097  -6.199  1.00 14.35           O  
ATOM    278  CB  LYS A  36     -19.130  46.022  -4.770  1.00 15.35           C  
ATOM    279  CG  LYS A  36     -20.175  46.626  -3.836  1.00 19.26           C  
ATOM    280  CD  LYS A  36     -20.644  47.993  -4.307  1.00 23.86           C  
ATOM    281  CE  LYS A  36     -21.977  48.340  -3.636  1.00 26.72           C  
ATOM    282  NZ  LYS A  36     -22.559  49.632  -4.114  1.00 31.72           N  
ATOM    283  N   GLY A  37     -16.745  44.119  -5.781  1.00 14.25           N  
ATOM    284  CA  GLY A  37     -16.079  43.451  -6.891  1.00 13.34           C  
ATOM    285  C   GLY A  37     -16.093  41.948  -6.716  1.00 12.66           C  
ATOM    286  O   GLY A  37     -16.201  41.188  -7.683  1.00 13.54           O  
ATOM    287  N   ALA A  38     -15.982  41.499  -5.474  1.00 11.81           N  
ATOM    288  CA  ALA A  38     -15.999  40.070  -5.228  1.00 12.40           C  
ATOM    289  C   ALA A  38     -17.381  39.530  -5.576  1.00 12.99           C  
ATOM    290  O   ALA A  38     -17.526  38.445  -6.137  1.00 13.37           O  
ATOM    291  CB  ALA A  38     -15.685  39.802  -3.762  1.00 13.20           C  
ATOM    292  N   PHE A  39     -18.399  40.304  -5.229  1.00 12.67           N  
ATOM    293  CA  PHE A  39     -19.750  39.875  -5.518  1.00 11.81           C  
ATOM    294  C   PHE A  39     -20.002  39.832  -7.018  1.00 11.26           C  
ATOM    295  O   PHE A  39     -20.488  38.828  -7.539  1.00 13.60           O  
ATOM    296  CB  PHE A  39     -20.754  40.820  -4.847  1.00 12.27           C  
ATOM    297  CG  PHE A  39     -22.193  40.496  -5.157  1.00 14.02           C  
ATOM    298  CD1 PHE A  39     -22.927  39.674  -4.301  1.00 15.27           C  
ATOM    299  CD2 PHE A  39     -22.796  40.973  -6.327  1.00 14.25           C  
ATOM    300  CE1 PHE A  39     -24.254  39.339  -4.627  1.00 15.04           C  
ATOM    301  CE2 PHE A  39     -24.111  40.646  -6.655  1.00 14.58           C  
ATOM    302  CZ  PHE A  39     -24.833  39.821  -5.790  1.00 14.31           C  
ATOM    303  N   TYR A  40     -19.659  40.912  -7.711  1.00 12.05           N  
ATOM    304  CA  TYR A  40     -19.891  40.960  -9.141  1.00 13.69           C  
ATOM    305  C   TYR A  40     -19.040  40.026  -9.971  1.00 13.75           C  
ATOM    306  O   TYR A  40     -19.371  39.744 -11.138  1.00 16.88           O  
ATOM    307  CB  TYR A  40     -19.814  42.407  -9.603  1.00 13.96           C  
ATOM    308  CG  TYR A  40     -21.041  43.169  -9.121  1.00 16.66           C  
ATOM    309  CD1 TYR A  40     -22.319  42.821  -9.569  1.00 16.85           C  
ATOM    310  CD2 TYR A  40     -20.934  44.188  -8.183  1.00 17.45           C  
ATOM    311  CE1 TYR A  40     -23.463  43.468  -9.096  1.00 19.43           C  
ATOM    312  CE2 TYR A  40     -22.070  44.845  -7.694  1.00 19.31           C  
ATOM    313  CZ  TYR A  40     -23.331  44.476  -8.157  1.00 20.18           C  
ATOM    314  OH  TYR A  40     -24.469  45.109  -7.677  1.00 21.78           O  
ATOM    315  N   PHE A  41     -17.950  39.532  -9.385  1.00 13.32           N  
ATOM    316  CA  PHE A  41     -17.122  38.569 -10.094  1.00 14.43           C  
ATOM    317  C   PHE A  41     -17.938  37.270 -10.226  1.00 14.93           C  
ATOM    318  O   PHE A  41     -17.886  36.602 -11.263  1.00 16.33           O  
ATOM    319  CB  PHE A  41     -15.823  38.284  -9.326  1.00 13.52           C  
ATOM    320  CG  PHE A  41     -14.991  37.174  -9.925  1.00 15.66           C  
ATOM    321  CD1 PHE A  41     -14.136  37.419 -11.001  1.00 15.93           C  
ATOM    322  CD2 PHE A  41     -15.046  35.894  -9.391  1.00 17.49           C  
ATOM    323  CE1 PHE A  41     -13.341  36.398 -11.529  1.00 17.14           C  
ATOM    324  CE2 PHE A  41     -14.261  34.864  -9.907  1.00 17.97           C  
ATOM    325  CZ  PHE A  41     -13.401  35.119 -10.981  1.00 16.96           C  
ATOM    326  N   HIS A  42     -18.715  36.946  -9.193  1.00 14.60           N  
ATOM    327  CA  HIS A  42     -19.540  35.734  -9.188  1.00 15.76           C  
ATOM    328  C   HIS A  42     -20.979  35.877  -9.656  1.00 16.36           C  
ATOM    329  O   HIS A  42     -21.566  34.899 -10.132  1.00 17.36           O  
ATOM    330  CB  HIS A  42     -19.565  35.114  -7.789  1.00 17.24           C  
ATOM    331  CG  HIS A  42     -18.227  34.652  -7.313  1.00 16.97           C  
ATOM    332  ND1 HIS A  42     -17.591  33.550  -7.840  1.00 20.10           N  
ATOM    333  CD2 HIS A  42     -17.390  35.165  -6.383  1.00 18.68           C  
ATOM    334  CE1 HIS A  42     -16.415  33.407  -7.253  1.00 18.53           C  
ATOM    335  NE2 HIS A  42     -16.270  34.373  -6.366  1.00 19.19           N  
ATOM    336  N   PHE A  43     -21.552  37.073  -9.512  1.00 14.97           N  
ATOM    337  CA  PHE A  43     -22.952  37.323  -9.891  1.00 16.42           C  
ATOM    338  C   PHE A  43     -23.076  38.664 -10.606  1.00 18.03           C  
ATOM    339  O   PHE A  43     -22.655  39.677 -10.085  1.00 20.53           O  
ATOM    340  CB  PHE A  43     -23.829  37.338  -8.624  1.00 14.80           C  
ATOM    341  CG  PHE A  43     -23.792  36.042  -7.847  1.00 12.91           C  
ATOM    342  CD1 PHE A  43     -24.514  34.915  -8.298  1.00 13.34           C  
ATOM    343  CD2 PHE A  43     -23.025  35.917  -6.681  1.00 12.63           C  
ATOM    344  CE1 PHE A  43     -24.459  33.708  -7.592  1.00 14.50           C  
ATOM    345  CE2 PHE A  43     -22.966  34.705  -5.972  1.00 14.33           C  
ATOM    346  CZ  PHE A  43     -23.686  33.592  -6.430  1.00 14.22           C  
ATOM    347  N   LYS A  44     -23.687  38.691 -11.783  1.00 19.38           N  
ATOM    348  CA  LYS A  44     -23.786  39.964 -12.462  1.00 20.71           C  
ATOM    349  C   LYS A  44     -24.887  40.862 -11.901  1.00 20.17           C  
ATOM    350  O   LYS A  44     -24.859  42.088 -12.085  1.00 21.20           O  
ATOM    351  CB  LYS A  44     -23.946  39.734 -13.967  1.00 25.25           C  
ATOM    352  CG  LYS A  44     -22.695  39.084 -14.578  1.00 29.20           C  
ATOM    353  CD  LYS A  44     -21.451  39.944 -14.300  1.00 31.33           C  
ATOM    354  CE  LYS A  44     -20.143  39.202 -14.570  1.00 33.55           C  
ATOM    355  NZ  LYS A  44     -19.703  38.366 -13.410  1.00 32.70           N  
ATOM    356  N   SER A  45     -25.804  40.263 -11.142  1.00 18.34           N  
ATOM    357  CA  SER A  45     -26.916  41.003 -10.577  1.00 17.08           C  
ATOM    358  C   SER A  45     -27.568  40.268  -9.412  1.00 15.89           C  
ATOM    359  O   SER A  45     -27.328  39.086  -9.186  1.00 15.04           O  
ATOM    360  CB  SER A  45     -27.984  41.200 -11.643  1.00 17.50           C  
ATOM    361  OG  SER A  45     -28.470  39.928 -12.040  1.00 17.73           O  
ATOM    362  N   LYS A  46     -28.407  40.999  -8.686  1.00 16.15           N  
ATOM    363  CA  LYS A  46     -29.156  40.442  -7.576  1.00 16.08           C  
ATOM    364  C   LYS A  46     -30.073  39.344  -8.164  1.00 14.53           C  
ATOM    365  O   LYS A  46     -30.324  38.322  -7.530  1.00 13.92           O  
ATOM    366  CB  LYS A  46     -29.991  41.550  -6.938  1.00 17.14           C  
ATOM    367  CG  LYS A  46     -30.200  41.418  -5.475  1.00 18.15           C  
ATOM    368  CD  LYS A  46     -30.880  42.673  -4.931  1.00 20.79           C  
ATOM    369  CE  LYS A  46     -32.280  42.342  -4.475  1.00 16.62           C  
ATOM    370  NZ  LYS A  46     -32.973  43.497  -3.837  1.00 14.77           N  
ATOM    371  N   GLU A  47     -30.587  39.579  -9.374  1.00 14.41           N  
ATOM    372  CA  GLU A  47     -31.463  38.621 -10.057  1.00 14.98           C  
ATOM    373  C   GLU A  47     -30.739  37.293 -10.310  1.00 15.17           C  
ATOM    374  O   GLU A  47     -31.317  36.208 -10.076  1.00 14.43           O  
ATOM    375  CB  GLU A  47     -31.972  39.221 -11.382  1.00 16.98           C  
ATOM    376  CG  GLU A  47     -32.823  38.250 -12.223  1.00 20.84           C  
ATOM    377  CD  GLU A  47     -33.572  38.955 -13.354  1.00 23.21           C  
ATOM    378  OE1 GLU A  47     -33.422  40.182 -13.497  1.00 27.46           O  
ATOM    379  OE2 GLU A  47     -34.322  38.288 -14.096  1.00 25.35           O  
ATOM    380  N   GLU A  48     -29.488  37.366 -10.779  1.00 14.87           N  
ATOM    381  CA  GLU A  48     -28.711  36.145 -11.014  1.00 16.04           C  
ATOM    382  C   GLU A  48     -28.525  35.412  -9.701  1.00 14.10           C  
ATOM    383  O   GLU A  48     -28.567  34.182  -9.651  1.00 14.43           O  
ATOM    384  CB  GLU A  48     -27.313  36.423 -11.595  1.00 17.33           C  
ATOM    385  CG  GLU A  48     -27.247  36.696 -13.075  1.00 24.32           C  
ATOM    386  CD  GLU A  48     -25.830  36.601 -13.664  1.00 27.27           C  
ATOM    387  OE1 GLU A  48     -25.706  36.868 -14.882  1.00 31.70           O  
ATOM    388  OE2 GLU A  48     -24.855  36.269 -12.938  1.00 26.80           O  
ATOM    389  N   LEU A  49     -28.283  36.173  -8.631  1.00 12.64           N  
ATOM    390  CA  LEU A  49     -28.087  35.581  -7.321  1.00 12.41           C  
ATOM    391  C   LEU A  49     -29.273  34.765  -6.804  1.00 12.60           C  
ATOM    392  O   LEU A  49     -29.098  33.635  -6.376  1.00 12.69           O  
ATOM    393  CB  LEU A  49     -27.732  36.683  -6.305  1.00 10.19           C  
ATOM    394  CG  LEU A  49     -27.761  36.312  -4.822  1.00 11.99           C  
ATOM    395  CD1 LEU A  49     -26.596  35.348  -4.456  1.00 13.99           C  
ATOM    396  CD2 LEU A  49     -27.639  37.614  -4.023  1.00 11.91           C  
ATOM    397  N   ILE A  50     -30.477  35.329  -6.809  1.00 13.10           N  
ATOM    398  CA  ILE A  50     -31.594  34.545  -6.289  1.00 13.74           C  
ATOM    399  C   ILE A  50     -31.898  33.375  -7.219  1.00 14.73           C  
ATOM    400  O   ILE A  50     -32.272  32.299  -6.759  1.00 13.90           O  
ATOM    401  CB  ILE A  50     -32.864  35.425  -6.058  1.00 13.39           C  
ATOM    402  CG1 ILE A  50     -33.938  34.603  -5.307  1.00 13.20           C  
ATOM    403  CG2 ILE A  50     -33.339  35.984  -7.347  1.00 15.28           C  
ATOM    404  CD1 ILE A  50     -35.053  35.485  -4.705  1.00 15.21           C  
ATOM    405  N   THR A  51     -31.694  33.568  -8.514  1.00 13.65           N  
ATOM    406  CA  THR A  51     -31.951  32.494  -9.461  1.00 15.12           C  
ATOM    407  C   THR A  51     -31.015  31.323  -9.141  1.00 15.60           C  
ATOM    408  O   THR A  51     -31.454  30.177  -9.137  1.00 15.89           O  
ATOM    409  CB  THR A  51     -31.764  32.993 -10.916  1.00 16.57           C  
ATOM    410  OG1 THR A  51     -32.692  34.060 -11.178  1.00 17.90           O  
ATOM    411  CG2 THR A  51     -32.054  31.875 -11.919  1.00 17.52           C  
ATOM    412  N   GLU A  52     -29.753  31.613  -8.823  1.00 14.02           N  
ATOM    413  CA  GLU A  52     -28.798  30.553  -8.493  1.00 15.02           C  
ATOM    414  C   GLU A  52     -29.158  29.828  -7.204  1.00 15.58           C  
ATOM    415  O   GLU A  52     -28.956  28.619  -7.097  1.00 16.15           O  
ATOM    416  CB  GLU A  52     -27.384  31.129  -8.407  1.00 16.02           C  
ATOM    417  CG  GLU A  52     -26.290  30.100  -8.032  1.00 19.53           C  
ATOM    418  CD  GLU A  52     -26.015  29.069  -9.116  1.00 23.61           C  
ATOM    419  OE1 GLU A  52     -26.498  29.256 -10.247  1.00 24.50           O  
ATOM    420  OE2 GLU A  52     -25.294  28.079  -8.829  1.00 25.23           O  
ATOM    421  N   ILE A  53     -29.667  30.563  -6.220  1.00 13.30           N  
ATOM    422  CA  ILE A  53     -30.081  29.978  -4.943  1.00 12.50           C  
ATOM    423  C   ILE A  53     -31.151  28.926  -5.217  1.00 14.87           C  
ATOM    424  O   ILE A  53     -31.091  27.807  -4.694  1.00 15.15           O  
ATOM    425  CB  ILE A  53     -30.675  31.063  -3.988  1.00 13.13           C  
ATOM    426  CG1 ILE A  53     -29.551  31.958  -3.468  1.00 14.04           C  
ATOM    427  CG2 ILE A  53     -31.415  30.414  -2.826  1.00 15.19           C  
ATOM    428  CD1 ILE A  53     -30.051  33.083  -2.582  1.00 14.10           C  
ATOM    429  N   ILE A  54     -32.130  29.298  -6.035  1.00 14.84           N  
ATOM    430  CA  ILE A  54     -33.201  28.378  -6.371  1.00 14.93           C  
ATOM    431  C   ILE A  54     -32.669  27.215  -7.186  1.00 16.74           C  
ATOM    432  O   ILE A  54     -32.993  26.045  -6.897  1.00 17.66           O  
ATOM    433  CB  ILE A  54     -34.314  29.116  -7.150  1.00 14.13           C  
ATOM    434  CG1 ILE A  54     -34.881  30.246  -6.270  1.00 16.04           C  
ATOM    435  CG2 ILE A  54     -35.418  28.130  -7.591  1.00 13.21           C  
ATOM    436  CD1 ILE A  54     -35.517  29.786  -4.947  1.00 16.83           C  
ATOM    437  N   GLU A  55     -31.838  27.522  -8.179  1.00 17.83           N  
ATOM    438  CA  GLU A  55     -31.277  26.491  -9.049  1.00 20.34           C  
ATOM    439  C   GLU A  55     -30.504  25.431  -8.264  1.00 20.53           C  
ATOM    440  O   GLU A  55     -30.590  24.227  -8.563  1.00 19.05           O  
ATOM    441  CB  GLU A  55     -30.371  27.131 -10.094  1.00 21.28           C  
ATOM    442  CG  GLU A  55     -30.074  26.251 -11.292  1.00 24.75           C  
ATOM    443  CD  GLU A  55     -31.272  26.083 -12.208  1.00 26.17           C  
ATOM    444  OE1 GLU A  55     -32.293  26.780 -12.007  1.00 27.79           O  
ATOM    445  OE2 GLU A  55     -31.184  25.259 -13.140  1.00 29.52           O  
ATOM    446  N   ARG A  56     -29.749  25.860  -7.261  1.00 20.77           N  
ATOM    447  CA  ARG A  56     -28.981  24.901  -6.484  1.00 19.01           C  
ATOM    448  C   ARG A  56     -29.875  24.003  -5.625  1.00 19.79           C  
ATOM    449  O   ARG A  56     -29.579  22.815  -5.472  1.00 18.89           O  
ATOM    450  CB  ARG A  56     -27.930  25.617  -5.648  1.00 19.69           C  
ATOM    451  CG  ARG A  56     -26.802  26.135  -6.502  1.00 20.40           C  
ATOM    452  CD  ARG A  56     -25.712  26.729  -5.641  1.00 20.02           C  
ATOM    453  NE  ARG A  56     -24.593  27.151  -6.472  1.00 19.56           N  
ATOM    454  CZ  ARG A  56     -23.325  27.097  -6.088  1.00 19.96           C  
ATOM    455  NH1 ARG A  56     -23.011  26.644  -4.881  1.00 21.07           N  
ATOM    456  NH2 ARG A  56     -22.378  27.482  -6.923  1.00 21.77           N  
ATOM    457  N   THR A  57     -30.975  24.543  -5.085  1.00 18.81           N  
ATOM    458  CA  THR A  57     -31.865  23.697  -4.293  1.00 17.95           C  
ATOM    459  C   THR A  57     -32.630  22.773  -5.255  1.00 17.07           C  
ATOM    460  O   THR A  57     -32.875  21.605  -4.934  1.00 18.62           O  
ATOM    461  CB  THR A  57     -32.838  24.534  -3.405  1.00 19.03           C  
ATOM    462  OG1 THR A  57     -32.080  25.206  -2.389  1.00 20.70           O  
ATOM    463  CG2 THR A  57     -33.832  23.639  -2.691  1.00 20.01           C  
ATOM    464  N   HIS A  58     -32.966  23.268  -6.437  1.00 16.81           N  
ATOM    465  CA  HIS A  58     -33.660  22.437  -7.432  1.00 17.05           C  
ATOM    466  C   HIS A  58     -32.752  21.270  -7.802  1.00 17.43           C  
ATOM    467  O   HIS A  58     -33.216  20.137  -7.971  1.00 15.88           O  
ATOM    468  CB  HIS A  58     -33.959  23.241  -8.699  1.00 18.73           C  
ATOM    469  CG  HIS A  58     -34.664  22.454  -9.767  1.00 18.74           C  
ATOM    470  ND1 HIS A  58     -34.421  22.644 -11.110  1.00 18.92           N  
ATOM    471  CD2 HIS A  58     -35.620  21.497  -9.693  1.00 20.87           C  
ATOM    472  CE1 HIS A  58     -35.197  21.841 -11.817  1.00 20.16           C  
ATOM    473  NE2 HIS A  58     -35.935  21.135 -10.982  1.00 19.68           N  
ATOM    474  N   LYS A  59     -31.461  21.550  -7.953  1.00 17.38           N  
ATOM    475  CA  LYS A  59     -30.512  20.493  -8.300  1.00 16.78           C  
ATOM    476  C   LYS A  59     -30.471  19.414  -7.241  1.00 15.86           C  
ATOM    477  O   LYS A  59     -30.250  18.252  -7.582  1.00 14.83           O  
ATOM    478  CB  LYS A  59     -29.118  21.067  -8.552  1.00 18.66           C  
ATOM    479  CG  LYS A  59     -28.990  21.616  -9.959  1.00 22.05           C  
ATOM    480  CD  LYS A  59     -27.738  22.443 -10.152  1.00 26.32           C  
ATOM    481  CE  LYS A  59     -27.538  22.734 -11.617  1.00 28.26           C  
ATOM    482  NZ  LYS A  59     -28.814  23.162 -12.258  1.00 29.73           N  
ATOM    483  N   LYS A  60     -30.668  19.777  -5.971  1.00 15.69           N  
ATOM    484  CA  LYS A  60     -30.685  18.769  -4.909  1.00 15.35           C  
ATOM    485  C   LYS A  60     -31.931  17.909  -5.105  1.00 15.52           C  
ATOM    486  O   LYS A  60     -31.920  16.711  -4.791  1.00 17.62           O  
ATOM    487  CB  LYS A  60     -30.722  19.418  -3.508  1.00 16.24           C  
ATOM    488  CG  LYS A  60     -29.410  20.068  -3.134  1.00 19.53           C  
ATOM    489  CD  LYS A  60     -29.498  20.860  -1.833  1.00 21.09           C  
ATOM    490  CE  LYS A  60     -28.191  21.624  -1.619  1.00 22.99           C  
ATOM    491  NZ  LYS A  60     -28.276  22.692  -0.580  1.00 25.63           N  
ATOM    492  N   ILE A  61     -33.002  18.521  -5.616  1.00 16.53           N  
ATOM    493  CA  ILE A  61     -34.242  17.794  -5.854  1.00 15.35           C  
ATOM    494  C   ILE A  61     -34.065  16.845  -7.032  1.00 14.97           C  
ATOM    495  O   ILE A  61     -34.498  15.686  -6.983  1.00 15.29           O  
ATOM    496  CB  ILE A  61     -35.414  18.763  -6.122  1.00 16.03           C  
ATOM    497  CG1 ILE A  61     -35.656  19.615  -4.867  1.00 17.67           C  
ATOM    498  CG2 ILE A  61     -36.684  17.980  -6.466  1.00 16.24           C  
ATOM    499  CD1 ILE A  61     -35.974  18.818  -3.625  1.00 20.05           C  
ATOM    500  N   ILE A  62     -33.431  17.331  -8.090  1.00 15.71           N  
ATOM    501  CA  ILE A  62     -33.167  16.473  -9.243  1.00 15.25           C  
ATOM    502  C   ILE A  62     -32.330  15.280  -8.766  1.00 15.78           C  
ATOM    503  O   ILE A  62     -32.628  14.134  -9.119  1.00 14.49           O  
ATOM    504  CB  ILE A  62     -32.421  17.251 -10.339  1.00 16.20           C  
ATOM    505  CG1 ILE A  62     -33.364  18.319 -10.895  1.00 16.79           C  
ATOM    506  CG2 ILE A  62     -31.919  16.311 -11.458  1.00 17.68           C  
ATOM    507  CD1 ILE A  62     -32.732  19.185 -11.982  1.00 17.56           C  
ATOM    508  N   SER A  63     -31.288  15.546  -7.977  1.00 15.53           N  
ATOM    509  CA  SER A  63     -30.439  14.468  -7.448  1.00 16.83           C  
ATOM    510  C   SER A  63     -31.244  13.470  -6.632  1.00 16.40           C  
ATOM    511  O   SER A  63     -31.039  12.255  -6.740  1.00 15.03           O  
ATOM    512  CB  SER A  63     -29.328  15.041  -6.560  1.00 18.29           C  
ATOM    513  OG  SER A  63     -28.402  15.740  -7.357  1.00 22.52           O  
ATOM    514  N   LEU A  64     -32.147  13.981  -5.799  1.00 16.13           N  
ATOM    515  CA  LEU A  64     -32.985  13.124  -4.978  1.00 18.05           C  
ATOM    516  C   LEU A  64     -33.745  12.119  -5.853  1.00 17.27           C  
ATOM    517  O   LEU A  64     -33.778  10.919  -5.554  1.00 18.20           O  
ATOM    518  CB  LEU A  64     -33.974  13.981  -4.175  1.00 20.79           C  
ATOM    519  CG  LEU A  64     -35.012  13.246  -3.318  1.00 25.04           C  
ATOM    520  CD1 LEU A  64     -35.110  13.914  -1.954  1.00 24.56           C  
ATOM    521  CD2 LEU A  64     -36.354  13.260  -4.000  1.00 25.27           C  
ATOM    522  N   PHE A  65     -34.362  12.605  -6.925  1.00 15.80           N  
ATOM    523  CA  PHE A  65     -35.106  11.718  -7.799  1.00 15.52           C  
ATOM    524  C   PHE A  65     -34.175  10.728  -8.474  1.00 16.68           C  
ATOM    525  O   PHE A  65     -34.489   9.547  -8.541  1.00 18.34           O  
ATOM    526  CB  PHE A  65     -35.851  12.507  -8.883  1.00 17.23           C  
ATOM    527  CG  PHE A  65     -37.146  13.086  -8.421  1.00 16.89           C  
ATOM    528  CD1 PHE A  65     -38.217  12.263  -8.116  1.00 18.99           C  
ATOM    529  CD2 PHE A  65     -37.295  14.467  -8.277  1.00 18.27           C  
ATOM    530  CE1 PHE A  65     -39.420  12.800  -7.673  1.00 20.21           C  
ATOM    531  CE2 PHE A  65     -38.499  15.005  -7.837  1.00 20.90           C  
ATOM    532  CZ  PHE A  65     -39.561  14.160  -7.536  1.00 20.52           C  
ATOM    533  N   GLU A  66     -33.032  11.200  -8.957  1.00 14.55           N  
ATOM    534  CA  GLU A  66     -32.115  10.302  -9.674  1.00 16.54           C  
ATOM    535  C   GLU A  66     -31.540   9.222  -8.754  1.00 16.03           C  
ATOM    536  O   GLU A  66     -31.448   8.045  -9.134  1.00 17.83           O  
ATOM    537  CB  GLU A  66     -30.953  11.098 -10.305  1.00 17.60           C  
ATOM    538  CG  GLU A  66     -31.347  12.072 -11.429  1.00 23.64           C  
ATOM    539  CD  GLU A  66     -30.164  12.915 -11.928  1.00 26.80           C  
ATOM    540  OE1 GLU A  66     -29.187  13.094 -11.164  1.00 29.14           O  
ATOM    541  OE2 GLU A  66     -30.209  13.417 -13.077  1.00 29.64           O  
ATOM    542  N   GLU A  67     -31.184   9.615  -7.538  1.00 15.48           N  
ATOM    543  CA  GLU A  67     -30.557   8.691  -6.596  1.00 14.81           C  
ATOM    544  C   GLU A  67     -31.475   7.748  -5.845  1.00 14.57           C  
ATOM    545  O   GLU A  67     -31.007   6.810  -5.194  1.00 13.81           O  
ATOM    546  CB  GLU A  67     -29.736   9.482  -5.574  1.00 16.97           C  
ATOM    547  CG  GLU A  67     -28.675  10.360  -6.212  1.00 18.30           C  
ATOM    548  CD  GLU A  67     -28.074  11.392  -5.251  1.00 21.34           C  
ATOM    549  OE1 GLU A  67     -28.579  11.566  -4.124  1.00 21.38           O  
ATOM    550  OE2 GLU A  67     -27.094  12.059  -5.646  1.00 24.15           O  
ATOM    551  N   ASN A  68     -32.781   7.984  -5.936  1.00 13.52           N  
ATOM    552  CA  ASN A  68     -33.747   7.184  -5.212  1.00 13.16           C  
ATOM    553  C   ASN A  68     -34.872   6.647  -6.073  1.00 13.26           C  
ATOM    554  O   ASN A  68     -35.943   6.314  -5.563  1.00 15.12           O  
ATOM    555  CB  ASN A  68     -34.321   8.011  -4.063  1.00 13.04           C  
ATOM    556  CG  ASN A  68     -33.241   8.499  -3.124  1.00 15.02           C  
ATOM    557  OD1 ASN A  68     -32.786   9.645  -3.197  1.00 18.44           O  
ATOM    558  ND2 ASN A  68     -32.800   7.611  -2.253  1.00 17.77           N  
ATOM    559  N   LYS A  69     -34.593   6.483  -7.362  1.00 13.46           N  
ATOM    560  CA  LYS A  69     -35.618   5.999  -8.285  1.00 14.05           C  
ATOM    561  C   LYS A  69     -36.066   4.559  -8.045  1.00 12.98           C  
ATOM    562  O   LYS A  69     -37.120   4.141  -8.538  1.00 13.31           O  
ATOM    563  CB  LYS A  69     -35.153   6.171  -9.734  1.00 18.68           C  
ATOM    564  CG  LYS A  69     -33.980   5.327 -10.107  1.00 21.99           C  
ATOM    565  CD  LYS A  69     -33.645   5.498 -11.585  1.00 27.55           C  
ATOM    566  CE  LYS A  69     -33.378   6.937 -11.946  1.00 30.38           C  
ATOM    567  NZ  LYS A  69     -33.211   7.086 -13.425  1.00 32.30           N  
ATOM    568  N   GLU A  70     -35.283   3.797  -7.280  1.00 11.14           N  
ATOM    569  CA  GLU A  70     -35.649   2.402  -6.991  1.00 11.70           C  
ATOM    570  C   GLU A  70     -36.365   2.230  -5.639  1.00 11.42           C  
ATOM    571  O   GLU A  70     -36.764   1.110  -5.241  1.00 13.12           O  
ATOM    572  CB  GLU A  70     -34.408   1.497  -7.018  1.00 12.28           C  
ATOM    573  CG  GLU A  70     -33.704   1.482  -8.362  1.00 15.36           C  
ATOM    574  CD  GLU A  70     -34.588   0.891  -9.459  1.00 16.73           C  
ATOM    575  OE1 GLU A  70     -35.433   0.022  -9.171  1.00 19.33           O  
ATOM    576  OE2 GLU A  70     -34.432   1.280 -10.627  1.00 21.13           O  
ATOM    577  N   LYS A  71     -36.535   3.324  -4.921  1.00 10.32           N  
ATOM    578  CA  LYS A  71     -37.230   3.258  -3.626  1.00 10.27           C  
ATOM    579  C   LYS A  71     -38.755   3.191  -3.797  1.00 10.09           C  
ATOM    580  O   LYS A  71     -39.302   3.465  -4.866  1.00 11.59           O  
ATOM    581  CB  LYS A  71     -36.919   4.503  -2.774  1.00 12.00           C  
ATOM    582  CG  LYS A  71     -35.455   4.755  -2.431  1.00 13.50           C  
ATOM    583  CD  LYS A  71     -34.771   3.521  -1.872  1.00 17.28           C  
ATOM    584  CE  LYS A  71     -33.389   3.868  -1.297  1.00 16.23           C  
ATOM    585  NZ  LYS A  71     -32.498   4.635  -2.239  1.00 15.47           N  
ATOM    586  N   THR A  72     -39.443   2.796  -2.731  1.00 10.65           N  
ATOM    587  CA  THR A  72     -40.900   2.803  -2.775  1.00 11.00           C  
ATOM    588  C   THR A  72     -41.351   4.276  -2.799  1.00 10.53           C  
ATOM    589  O   THR A  72     -40.623   5.180  -2.404  1.00  9.77           O  
ATOM    590  CB  THR A  72     -41.540   2.184  -1.507  1.00 11.39           C  
ATOM    591  OG1 THR A  72     -41.197   2.987  -0.364  1.00 12.11           O  
ATOM    592  CG2 THR A  72     -41.038   0.773  -1.266  1.00 12.33           C  
ATOM    593  N   PRO A  73     -42.559   4.549  -3.284  1.00 10.97           N  
ATOM    594  CA  PRO A  73     -43.029   5.931  -3.304  1.00 10.36           C  
ATOM    595  C   PRO A  73     -42.984   6.573  -1.902  1.00 10.08           C  
ATOM    596  O   PRO A  73     -42.593   7.720  -1.759  1.00 11.14           O  
ATOM    597  CB  PRO A  73     -44.474   5.793  -3.809  1.00 10.15           C  
ATOM    598  CG  PRO A  73     -44.353   4.677  -4.750  1.00 12.78           C  
ATOM    599  CD  PRO A  73     -43.487   3.663  -4.016  1.00 11.90           C  
ATOM    600  N   GLU A  74     -43.368   5.809  -0.879  1.00 10.69           N  
ATOM    601  CA  GLU A  74     -43.372   6.310   0.489  1.00 11.23           C  
ATOM    602  C   GLU A  74     -41.971   6.714   0.937  1.00  9.75           C  
ATOM    603  O   GLU A  74     -41.773   7.759   1.584  1.00 10.46           O  
ATOM    604  CB  GLU A  74     -43.949   5.246   1.432  1.00 12.65           C  
ATOM    605  CG  GLU A  74     -45.396   4.881   1.047  1.00 15.90           C  
ATOM    606  CD  GLU A  74     -45.524   3.565   0.265  1.00 19.05           C  
ATOM    607  OE1 GLU A  74     -44.868   3.367  -0.791  1.00 18.80           O  
ATOM    608  OE2 GLU A  74     -46.305   2.717   0.722  1.00 22.78           O  
ATOM    609  N   GLU A  75     -40.986   5.888   0.629  1.00  9.41           N  
ATOM    610  CA  GLU A  75     -39.619   6.225   1.028  1.00  8.00           C  
ATOM    611  C   GLU A  75     -39.032   7.373   0.189  1.00  9.21           C  
ATOM    612  O   GLU A  75     -38.263   8.204   0.696  1.00  8.52           O  
ATOM    613  CB  GLU A  75     -38.749   4.978   0.962  1.00  9.72           C  
ATOM    614  CG  GLU A  75     -39.064   3.998   2.126  1.00 11.21           C  
ATOM    615  CD  GLU A  75     -38.733   4.534   3.528  1.00 12.29           C  
ATOM    616  OE1 GLU A  75     -37.632   5.066   3.708  1.00 10.21           O  
ATOM    617  OE2 GLU A  75     -39.577   4.388   4.447  1.00 11.47           O  
ATOM    618  N   LEU A  76     -39.356   7.418  -1.096  1.00  9.82           N  
ATOM    619  CA  LEU A  76     -38.865   8.535  -1.918  1.00  8.83           C  
ATOM    620  C   LEU A  76     -39.465   9.832  -1.328  1.00  8.34           C  
ATOM    621  O   LEU A  76     -38.772  10.847  -1.170  1.00  9.24           O  
ATOM    622  CB  LEU A  76     -39.338   8.385  -3.374  1.00 11.14           C  
ATOM    623  CG  LEU A  76     -39.036   9.626  -4.227  1.00 11.14           C  
ATOM    624  CD1 LEU A  76     -37.549   9.707  -4.504  1.00 13.19           C  
ATOM    625  CD2 LEU A  76     -39.857   9.552  -5.540  1.00 15.86           C  
ATOM    626  N   LEU A  77     -40.756   9.807  -1.006  1.00  8.05           N  
ATOM    627  CA  LEU A  77     -41.391  10.998  -0.460  1.00  8.57           C  
ATOM    628  C   LEU A  77     -40.849  11.386   0.923  1.00  8.92           C  
ATOM    629  O   LEU A  77     -40.755  12.564   1.229  1.00  9.06           O  
ATOM    630  CB  LEU A  77     -42.924  10.827  -0.465  1.00 10.52           C  
ATOM    631  CG  LEU A  77     -43.400  10.795  -1.945  1.00 14.63           C  
ATOM    632  CD1 LEU A  77     -44.741  10.052  -2.094  1.00 15.16           C  
ATOM    633  CD2 LEU A  77     -43.479  12.210  -2.479  1.00 17.97           C  
ATOM    634  N   GLU A  78     -40.500  10.397   1.752  1.00  8.51           N  
ATOM    635  CA  GLU A  78     -39.908  10.724   3.029  1.00  8.66           C  
ATOM    636  C   GLU A  78     -38.604  11.500   2.808  1.00  8.21           C  
ATOM    637  O   GLU A  78     -38.325  12.477   3.510  1.00  7.80           O  
ATOM    638  CB  GLU A  78     -39.622   9.449   3.804  1.00  6.18           C  
ATOM    639  CG  GLU A  78     -38.864   9.727   5.141  1.00  8.66           C  
ATOM    640  CD  GLU A  78     -38.484   8.490   5.893  1.00 10.27           C  
ATOM    641  OE1 GLU A  78     -38.937   7.377   5.561  1.00  8.85           O  
ATOM    642  OE2 GLU A  78     -37.674   8.643   6.849  1.00  7.57           O  
HETATM  643  N   MSE A  79     -37.819  11.080   1.826  1.00  8.25           N  
HETATM  644  CA  MSE A  79     -36.557  11.757   1.530  1.00  9.16           C  
HETATM  645  C   MSE A  79     -36.770  13.160   0.999  1.00  9.84           C  
HETATM  646  O   MSE A  79     -36.016  14.084   1.321  1.00 11.49           O  
HETATM  647  CB  MSE A  79     -35.785  10.941   0.501  1.00 14.64           C  
HETATM  648  CG  MSE A  79     -34.440  11.505   0.173  1.00 15.61           C  
HETATM  649 SE   MSE A  79     -33.138  11.199   1.585  1.00 28.65          SE  
HETATM  650  CE  MSE A  79     -33.523   9.411   1.959  1.00 16.64           C  
ATOM    651  N   PHE A  80     -37.808  13.295   0.180  1.00  9.40           N  
ATOM    652  CA  PHE A  80     -38.193  14.574  -0.427  1.00  9.78           C  
ATOM    653  C   PHE A  80     -38.528  15.540   0.712  1.00  8.93           C  
ATOM    654  O   PHE A  80     -38.060  16.670   0.732  1.00 10.25           O  
ATOM    655  CB  PHE A  80     -39.407  14.300  -1.369  1.00 12.27           C  
ATOM    656  CG  PHE A  80     -39.765  15.427  -2.344  1.00 15.04           C  
ATOM    657  CD1 PHE A  80     -39.055  16.625  -2.392  1.00 17.21           C  
ATOM    658  CD2 PHE A  80     -40.855  15.261  -3.196  1.00 18.30           C  
ATOM    659  CE1 PHE A  80     -39.425  17.650  -3.276  1.00 17.80           C  
ATOM    660  CE2 PHE A  80     -41.235  16.286  -4.090  1.00 19.75           C  
ATOM    661  CZ  PHE A  80     -40.508  17.476  -4.115  1.00 18.34           C  
ATOM    662  N   LEU A  81     -39.343  15.096   1.667  1.00  8.57           N  
ATOM    663  CA  LEU A  81     -39.676  15.949   2.802  1.00  9.72           C  
ATOM    664  C   LEU A  81     -38.436  16.288   3.626  1.00 11.17           C  
ATOM    665  O   LEU A  81     -38.277  17.418   4.072  1.00 10.63           O  
ATOM    666  CB  LEU A  81     -40.727  15.261   3.684  1.00  9.90           C  
ATOM    667  CG  LEU A  81     -41.026  15.937   5.035  1.00  9.74           C  
ATOM    668  CD1 LEU A  81     -41.599  17.330   4.863  1.00 12.96           C  
ATOM    669  CD2 LEU A  81     -42.014  15.046   5.810  1.00 12.60           C  
ATOM    670  N   GLU A  82     -37.535  15.327   3.818  1.00  9.84           N  
ATOM    671  CA  GLU A  82     -36.352  15.625   4.598  1.00 11.58           C  
ATOM    672  C   GLU A  82     -35.508  16.731   3.941  1.00 11.00           C  
ATOM    673  O   GLU A  82     -35.036  17.643   4.629  1.00 12.81           O  
ATOM    674  CB  GLU A  82     -35.528  14.353   4.785  1.00 10.73           C  
ATOM    675  CG  GLU A  82     -36.166  13.388   5.772  1.00 10.40           C  
ATOM    676  CD  GLU A  82     -35.593  11.999   5.674  1.00  9.19           C  
ATOM    677  OE1 GLU A  82     -34.842  11.742   4.706  1.00 10.25           O  
ATOM    678  OE2 GLU A  82     -35.903  11.124   6.532  1.00  9.37           O  
ATOM    679  N   VAL A  83     -35.334  16.650   2.619  1.00 12.66           N  
ATOM    680  CA  VAL A  83     -34.561  17.668   1.906  1.00 12.51           C  
ATOM    681  C   VAL A  83     -35.273  19.009   1.980  1.00 12.15           C  
ATOM    682  O   VAL A  83     -34.634  20.014   2.273  1.00 12.55           O  
ATOM    683  CB  VAL A  83     -34.331  17.271   0.433  1.00 14.79           C  
ATOM    684  CG1 VAL A  83     -33.790  18.473  -0.380  1.00 17.46           C  
ATOM    685  CG2 VAL A  83     -33.349  16.089   0.394  1.00 18.37           C  
ATOM    686  N   LEU A  84     -36.582  19.042   1.732  1.00 11.20           N  
ATOM    687  CA  LEU A  84     -37.275  20.326   1.821  1.00 12.81           C  
ATOM    688  C   LEU A  84     -37.122  20.934   3.221  1.00 12.44           C  
ATOM    689  O   LEU A  84     -36.954  22.152   3.360  1.00 13.00           O  
ATOM    690  CB  LEU A  84     -38.748  20.172   1.492  1.00 12.87           C  
ATOM    691  CG  LEU A  84     -39.077  19.738   0.062  1.00 13.98           C  
ATOM    692  CD1 LEU A  84     -40.574  19.472  -0.066  1.00 14.59           C  
ATOM    693  CD2 LEU A  84     -38.635  20.819  -0.913  1.00 15.99           C  
ATOM    694  N   TYR A  85     -37.174  20.088   4.262  1.00 11.52           N  
ATOM    695  CA  TYR A  85     -37.058  20.578   5.631  1.00 12.27           C  
ATOM    696  C   TYR A  85     -35.661  21.146   5.876  1.00 12.66           C  
ATOM    697  O   TYR A  85     -35.530  22.211   6.475  1.00 14.19           O  
ATOM    698  CB  TYR A  85     -37.372  19.454   6.639  1.00 12.12           C  
ATOM    699  CG  TYR A  85     -37.584  19.958   8.047  1.00 10.72           C  
ATOM    700  CD1 TYR A  85     -38.859  20.354   8.484  1.00 13.26           C  
ATOM    701  CD2 TYR A  85     -36.511  20.091   8.913  1.00 13.14           C  
ATOM    702  CE1 TYR A  85     -39.057  20.882   9.787  1.00 15.18           C  
ATOM    703  CE2 TYR A  85     -36.690  20.623  10.218  1.00 14.04           C  
ATOM    704  CZ  TYR A  85     -37.965  21.008  10.630  1.00 15.77           C  
ATOM    705  OH  TYR A  85     -38.143  21.512  11.894  1.00 18.40           O  
ATOM    706  N   ARG A  86     -34.625  20.438   5.435  1.00 14.28           N  
ATOM    707  CA  ARG A  86     -33.242  20.929   5.578  1.00 14.54           C  
ATOM    708  C   ARG A  86     -33.088  22.260   4.826  1.00 14.99           C  
ATOM    709  O   ARG A  86     -32.372  23.160   5.282  1.00 14.93           O  
ATOM    710  CB  ARG A  86     -32.236  19.934   4.985  1.00 19.34           C  
ATOM    711  CG  ARG A  86     -32.105  18.605   5.716  1.00 25.36           C  
ATOM    712  CD  ARG A  86     -30.750  17.945   5.418  1.00 29.14           C  
ATOM    713  NE  ARG A  86     -30.433  17.849   3.990  1.00 33.03           N  
ATOM    714  CZ  ARG A  86     -30.856  16.880   3.182  1.00 35.15           C  
ATOM    715  NH1 ARG A  86     -31.624  15.904   3.650  1.00 36.74           N  
ATOM    716  NH2 ARG A  86     -30.501  16.882   1.904  1.00 37.86           N  
ATOM    717  N   GLU A  87     -33.753  22.360   3.676  1.00 13.00           N  
ATOM    718  CA  GLU A  87     -33.716  23.567   2.829  1.00 14.04           C  
ATOM    719  C   GLU A  87     -34.888  24.501   3.140  1.00 12.88           C  
ATOM    720  O   GLU A  87     -35.255  25.300   2.291  1.00 11.66           O  
ATOM    721  CB  GLU A  87     -33.802  23.179   1.334  1.00 15.23           C  
ATOM    722  CG  GLU A  87     -32.725  22.208   0.855  1.00 17.16           C  
ATOM    723  CD  GLU A  87     -31.372  22.874   0.659  1.00 20.21           C  
ATOM    724  OE1 GLU A  87     -31.332  23.922  -0.024  1.00 22.57           O  
ATOM    725  OE2 GLU A  87     -30.367  22.342   1.176  1.00 21.45           O  
ATOM    726  N   LYS A  88     -35.432  24.474   4.363  1.00 13.49           N  
ATOM    727  CA  LYS A  88     -36.616  25.296   4.638  1.00 12.89           C  
ATOM    728  C   LYS A  88     -36.470  26.801   4.433  1.00 12.40           C  
ATOM    729  O   LYS A  88     -37.445  27.471   4.108  1.00 11.70           O  
ATOM    730  CB  LYS A  88     -37.193  24.976   6.028  1.00 16.86           C  
ATOM    731  CG  LYS A  88     -36.239  25.143   7.174  1.00 19.43           C  
ATOM    732  CD  LYS A  88     -36.861  24.506   8.419  1.00 23.75           C  
ATOM    733  CE  LYS A  88     -35.816  24.319   9.499  1.00 26.42           C  
ATOM    734  NZ  LYS A  88     -34.663  23.501   9.016  1.00 28.97           N  
ATOM    735  N   LYS A  89     -35.261  27.339   4.588  1.00 11.57           N  
ATOM    736  CA  LYS A  89     -35.077  28.773   4.342  1.00 12.31           C  
ATOM    737  C   LYS A  89     -35.278  29.065   2.864  1.00 11.61           C  
ATOM    738  O   LYS A  89     -35.857  30.091   2.487  1.00 10.56           O  
ATOM    739  CB  LYS A  89     -33.684  29.221   4.830  1.00 13.67           C  
ATOM    740  CG  LYS A  89     -33.600  29.234   6.365  1.00 19.81           C  
ATOM    741  CD  LYS A  89     -32.252  29.747   6.848  1.00 22.17           C  
ATOM    742  CE  LYS A  89     -32.105  29.567   8.358  1.00 24.20           C  
ATOM    743  NZ  LYS A  89     -33.062  30.400   9.124  1.00 27.89           N  
ATOM    744  N   VAL A  90     -34.829  28.155   2.001  1.00 10.71           N  
ATOM    745  CA  VAL A  90     -35.004  28.358   0.578  1.00  9.61           C  
ATOM    746  C   VAL A  90     -36.472  28.141   0.205  1.00  9.35           C  
ATOM    747  O   VAL A  90     -36.978  28.814  -0.683  1.00  8.54           O  
ATOM    748  CB  VAL A  90     -34.075  27.426  -0.233  1.00  8.87           C  
ATOM    749  CG1 VAL A  90     -34.309  27.601  -1.734  1.00 11.96           C  
ATOM    750  CG2 VAL A  90     -32.621  27.726   0.125  1.00 11.16           C  
ATOM    751  N   VAL A  91     -37.148  27.212   0.887  1.00  8.82           N  
ATOM    752  CA  VAL A  91     -38.555  26.983   0.616  1.00  9.38           C  
ATOM    753  C   VAL A  91     -39.318  28.265   0.932  1.00 10.48           C  
ATOM    754  O   VAL A  91     -40.210  28.656   0.189  1.00  9.30           O  
ATOM    755  CB  VAL A  91     -39.110  25.813   1.474  1.00 12.69           C  
ATOM    756  CG1 VAL A  91     -40.633  25.747   1.336  1.00 15.82           C  
ATOM    757  CG2 VAL A  91     -38.471  24.500   1.022  1.00 13.30           C  
ATOM    758  N   TYR A  92     -38.947  28.931   2.027  1.00  9.59           N  
ATOM    759  CA  TYR A  92     -39.595  30.178   2.421  1.00 10.51           C  
ATOM    760  C   TYR A  92     -39.351  31.249   1.335  1.00  9.87           C  
ATOM    761  O   TYR A  92     -40.282  31.950   0.902  1.00 10.03           O  
ATOM    762  CB  TYR A  92     -39.031  30.582   3.791  1.00 11.25           C  
ATOM    763  CG  TYR A  92     -39.743  31.708   4.456  1.00 12.70           C  
ATOM    764  CD1 TYR A  92     -39.478  33.023   4.082  1.00 15.56           C  
ATOM    765  CD2 TYR A  92     -40.681  31.472   5.456  1.00 14.53           C  
ATOM    766  CE1 TYR A  92     -40.132  34.077   4.688  1.00 16.34           C  
ATOM    767  CE2 TYR A  92     -41.340  32.511   6.068  1.00 17.67           C  
ATOM    768  CZ  TYR A  92     -41.066  33.808   5.683  1.00 18.72           C  
ATOM    769  OH  TYR A  92     -41.733  34.844   6.286  1.00 21.77           O  
ATOM    770  N   ILE A  93     -38.110  31.366   0.855  1.00  9.66           N  
ATOM    771  CA  ILE A  93     -37.784  32.338  -0.196  1.00 10.64           C  
ATOM    772  C   ILE A  93     -38.570  32.018  -1.485  1.00  9.73           C  
ATOM    773  O   ILE A  93     -39.123  32.904  -2.162  1.00  9.83           O  
ATOM    774  CB  ILE A  93     -36.241  32.298  -0.448  1.00  9.50           C  
ATOM    775  CG1 ILE A  93     -35.518  32.857   0.789  1.00 10.34           C  
ATOM    776  CG2 ILE A  93     -35.871  33.113  -1.707  1.00 11.00           C  
ATOM    777  CD1 ILE A  93     -33.990  32.520   0.840  1.00 10.81           C  
ATOM    778  N   PHE A  94     -38.625  30.733  -1.825  1.00 10.83           N  
ATOM    779  CA  PHE A  94     -39.339  30.266  -2.994  1.00  9.85           C  
ATOM    780  C   PHE A  94     -40.800  30.766  -2.990  1.00  9.60           C  
ATOM    781  O   PHE A  94     -41.316  31.257  -3.999  1.00  9.79           O  
ATOM    782  CB  PHE A  94     -39.286  28.730  -2.960  1.00  9.73           C  
ATOM    783  CG  PHE A  94     -39.755  28.044  -4.209  1.00 12.95           C  
ATOM    784  CD1 PHE A  94     -39.122  28.251  -5.423  1.00 13.54           C  
ATOM    785  CD2 PHE A  94     -40.798  27.130  -4.139  1.00 14.17           C  
ATOM    786  CE1 PHE A  94     -39.519  27.553  -6.563  1.00 13.76           C  
ATOM    787  CE2 PHE A  94     -41.208  26.424  -5.276  1.00 14.12           C  
ATOM    788  CZ  PHE A  94     -40.561  26.642  -6.487  1.00 15.44           C  
ATOM    789  N   LEU A  95     -41.472  30.630  -1.854  1.00  9.54           N  
ATOM    790  CA  LEU A  95     -42.849  31.128  -1.782  1.00 10.14           C  
ATOM    791  C   LEU A  95     -42.973  32.656  -1.728  1.00 10.49           C  
ATOM    792  O   LEU A  95     -43.621  33.288  -2.593  1.00 10.21           O  
ATOM    793  CB  LEU A  95     -43.528  30.517  -0.548  1.00 11.15           C  
ATOM    794  CG  LEU A  95     -44.913  31.031  -0.160  1.00 15.35           C  
ATOM    795  CD1 LEU A  95     -45.894  30.894  -1.303  1.00 17.56           C  
ATOM    796  CD2 LEU A  95     -45.400  30.256   1.069  1.00 15.47           C  
ATOM    797  N   PHE A  96     -42.306  33.269  -0.758  1.00 10.12           N  
ATOM    798  CA  PHE A  96     -42.504  34.695  -0.553  1.00  9.86           C  
ATOM    799  C   PHE A  96     -41.789  35.642  -1.463  1.00 10.95           C  
ATOM    800  O   PHE A  96     -42.249  36.773  -1.649  1.00 12.48           O  
ATOM    801  CB  PHE A  96     -42.238  35.014   0.912  1.00  9.81           C  
ATOM    802  CG  PHE A  96     -43.212  34.345   1.832  1.00 10.48           C  
ATOM    803  CD1 PHE A  96     -44.574  34.672   1.775  1.00 12.05           C  
ATOM    804  CD2 PHE A  96     -42.796  33.367   2.729  1.00 11.10           C  
ATOM    805  CE1 PHE A  96     -45.505  34.036   2.603  1.00 12.67           C  
ATOM    806  CE2 PHE A  96     -43.728  32.728   3.556  1.00 12.90           C  
ATOM    807  CZ  PHE A  96     -45.077  33.062   3.497  1.00 10.93           C  
ATOM    808  N   ASP A  97     -40.675  35.190  -2.036  1.00  9.54           N  
ATOM    809  CA  ASP A  97     -39.937  35.999  -2.987  1.00 10.64           C  
ATOM    810  C   ASP A  97     -40.164  35.630  -4.462  1.00 11.34           C  
ATOM    811  O   ASP A  97     -39.917  36.472  -5.355  1.00 13.17           O  
ATOM    812  CB  ASP A  97     -38.449  35.960  -2.669  1.00 10.31           C  
ATOM    813  CG  ASP A  97     -38.142  36.579  -1.335  1.00 12.39           C  
ATOM    814  OD1 ASP A  97     -38.544  37.733  -1.100  1.00 13.50           O  
ATOM    815  OD2 ASP A  97     -37.509  35.878  -0.526  1.00 13.42           O  
ATOM    816  N   LEU A  98     -40.623  34.407  -4.750  1.00  8.92           N  
ATOM    817  CA  LEU A  98     -40.871  34.053  -6.137  1.00  9.16           C  
ATOM    818  C   LEU A  98     -42.354  33.935  -6.473  1.00  9.23           C  
ATOM    819  O   LEU A  98     -42.812  34.668  -7.342  1.00  8.73           O  
ATOM    820  CB  LEU A  98     -40.083  32.787  -6.544  1.00 11.10           C  
ATOM    821  CG  LEU A  98     -38.560  33.002  -6.715  1.00 13.99           C  
ATOM    822  CD1 LEU A  98     -37.831  32.850  -5.402  1.00 17.95           C  
ATOM    823  CD2 LEU A  98     -38.025  31.973  -7.732  1.00 18.47           C  
ATOM    824  N   LEU A  99     -43.108  33.058  -5.811  1.00  8.83           N  
ATOM    825  CA  LEU A  99     -44.538  32.974  -6.130  1.00  9.62           C  
ATOM    826  C   LEU A  99     -45.211  34.326  -5.925  1.00 10.37           C  
ATOM    827  O   LEU A  99     -45.983  34.781  -6.782  1.00  9.97           O  
ATOM    828  CB  LEU A  99     -45.227  31.913  -5.256  1.00  9.90           C  
ATOM    829  CG  LEU A  99     -46.768  31.946  -5.362  1.00  9.24           C  
ATOM    830  CD1 LEU A  99     -47.173  31.628  -6.805  1.00 11.10           C  
ATOM    831  CD2 LEU A  99     -47.412  30.908  -4.388  1.00 12.68           C  
ATOM    832  N   CYS A 100     -44.903  34.978  -4.812  1.00 10.66           N  
ATOM    833  CA  CYS A 100     -45.527  36.254  -4.468  1.00 11.13           C  
ATOM    834  C   CYS A 100     -45.108  37.418  -5.342  1.00 13.88           C  
ATOM    835  O   CYS A 100     -45.766  38.456  -5.364  1.00 16.80           O  
ATOM    836  CB  CYS A 100     -45.251  36.549  -2.987  1.00 11.17           C  
ATOM    837  SG  CYS A 100     -46.090  35.395  -1.867  1.00 11.70           S  
ATOM    838  N   SER A 101     -44.043  37.236  -6.106  1.00 13.57           N  
ATOM    839  CA  SER A 101     -43.563  38.321  -6.973  1.00 12.72           C  
ATOM    840  C   SER A 101     -44.273  38.300  -8.299  1.00 14.08           C  
ATOM    841  O   SER A 101     -44.923  37.319  -8.633  1.00 16.91           O  
ATOM    842  CB  SER A 101     -42.071  38.123  -7.243  1.00 14.18           C  
ATOM    843  OG  SER A 101     -41.898  37.124  -8.247  1.00 17.42           O  
ATOM    844  N   GLU A 102     -44.217  39.391  -9.063  1.00 12.13           N  
ATOM    845  CA  GLU A 102     -44.778  39.297 -10.398  1.00 12.42           C  
ATOM    846  C   GLU A 102     -43.646  38.832 -11.333  1.00 12.58           C  
ATOM    847  O   GLU A 102     -43.842  37.965 -12.195  1.00 14.13           O  
ATOM    848  CB  GLU A 102     -45.294  40.659 -10.893  1.00 12.08           C  
ATOM    849  CG  GLU A 102     -46.505  41.153 -10.176  1.00 15.43           C  
ATOM    850  CD  GLU A 102     -47.754  40.367 -10.516  1.00 14.61           C  
ATOM    851  OE1 GLU A 102     -47.772  39.612 -11.522  1.00 17.24           O  
ATOM    852  OE2 GLU A 102     -48.748  40.531  -9.779  1.00 21.24           O  
ATOM    853  N   LYS A 103     -42.465  39.420 -11.148  1.00 11.98           N  
ATOM    854  CA  LYS A 103     -41.301  39.138 -11.986  1.00 13.37           C  
ATOM    855  C   LYS A 103     -40.785  37.698 -11.966  1.00 12.91           C  
ATOM    856  O   LYS A 103     -40.376  37.174 -13.012  1.00 12.70           O  
ATOM    857  CB  LYS A 103     -40.157  40.102 -11.618  1.00 16.77           C  
ATOM    858  CG  LYS A 103     -38.891  39.975 -12.461  1.00 18.85           C  
ATOM    859  CD  LYS A 103     -37.779  40.915 -11.982  1.00 20.17           C  
ATOM    860  CE  LYS A 103     -36.684  41.004 -13.054  1.00 23.07           C  
ATOM    861  NZ  LYS A 103     -35.545  41.887 -12.674  1.00 24.54           N  
ATOM    862  N   PHE A 104     -40.830  37.060 -10.804  1.00 11.16           N  
ATOM    863  CA  PHE A 104     -40.288  35.706 -10.681  1.00 12.28           C  
ATOM    864  C   PHE A 104     -41.330  34.597 -10.549  1.00 12.17           C  
ATOM    865  O   PHE A 104     -40.968  33.433 -10.355  1.00 12.54           O  
ATOM    866  CB  PHE A 104     -39.327  35.638  -9.470  1.00 11.60           C  
ATOM    867  CG  PHE A 104     -38.198  36.632  -9.521  1.00 12.32           C  
ATOM    868  CD1 PHE A 104     -37.389  36.736 -10.649  1.00 16.00           C  
ATOM    869  CD2 PHE A 104     -37.910  37.415  -8.416  1.00 15.91           C  
ATOM    870  CE1 PHE A 104     -36.296  37.609 -10.664  1.00 16.34           C  
ATOM    871  CE2 PHE A 104     -36.804  38.298  -8.422  1.00 17.56           C  
ATOM    872  CZ  PHE A 104     -36.005  38.386  -9.546  1.00 16.11           C  
ATOM    873  N   ARG A 105     -42.609  34.931 -10.684  1.00 12.16           N  
ATOM    874  CA  ARG A 105     -43.661  33.912 -10.570  1.00 12.24           C  
ATOM    875  C   ARG A 105     -43.466  32.736 -11.513  1.00 12.52           C  
ATOM    876  O   ARG A 105     -43.717  31.581 -11.134  1.00 11.76           O  
ATOM    877  CB  ARG A 105     -45.039  34.530 -10.825  1.00 14.26           C  
ATOM    878  CG  ARG A 105     -46.186  33.593 -10.397  1.00 15.08           C  
ATOM    879  CD  ARG A 105     -47.512  34.338 -10.330  1.00 15.34           C  
ATOM    880  NE  ARG A 105     -47.403  35.432  -9.374  1.00 14.53           N  
ATOM    881  CZ  ARG A 105     -48.303  36.394  -9.210  1.00 15.44           C  
ATOM    882  NH1 ARG A 105     -49.410  36.398  -9.945  1.00 16.59           N  
ATOM    883  NH2 ARG A 105     -48.088  37.351  -8.317  1.00 16.98           N  
ATOM    884  N   ASN A 106     -43.005  33.024 -12.719  1.00 12.41           N  
ATOM    885  CA  ASN A 106     -42.808  31.970 -13.703  1.00 14.72           C  
ATOM    886  C   ASN A 106     -41.776  30.936 -13.242  1.00 15.15           C  
ATOM    887  O   ASN A 106     -41.894  29.758 -13.589  1.00 15.12           O  
ATOM    888  CB  ASN A 106     -42.368  32.572 -15.034  1.00 16.83           C  
ATOM    889  CG  ASN A 106     -40.988  33.200 -14.948  1.00 21.42           C  
ATOM    890  OD1 ASN A 106     -40.787  34.243 -14.293  1.00 23.92           O  
ATOM    891  ND2 ASN A 106     -40.012  32.553 -15.589  1.00 23.34           N  
ATOM    892  N   ILE A 107     -40.765  31.362 -12.485  1.00 15.35           N  
ATOM    893  CA  ILE A 107     -39.737  30.427 -12.014  1.00 15.29           C  
ATOM    894  C   ILE A 107     -40.332  29.473 -11.000  1.00 15.84           C  
ATOM    895  O   ILE A 107     -40.051  28.262 -11.024  1.00 15.15           O  
ATOM    896  CB  ILE A 107     -38.558  31.191 -11.374  1.00 15.50           C  
ATOM    897  CG1 ILE A 107     -37.944  32.105 -12.426  1.00 17.17           C  
ATOM    898  CG2 ILE A 107     -37.504  30.205 -10.799  1.00 15.99           C  
ATOM    899  CD1 ILE A 107     -36.935  33.113 -11.872  1.00 20.46           C  
ATOM    900  N   TYR A 108     -41.138  30.011 -10.089  1.00 12.38           N  
ATOM    901  CA  TYR A 108     -41.800  29.210  -9.070  1.00 13.82           C  
ATOM    902  C   TYR A 108     -42.550  28.111  -9.786  1.00 13.77           C  
ATOM    903  O   TYR A 108     -42.366  26.927  -9.495  1.00 13.17           O  
ATOM    904  CB  TYR A 108     -42.802  30.058  -8.285  1.00 14.06           C  
ATOM    905  CG  TYR A 108     -43.648  29.288  -7.306  1.00 13.58           C  
ATOM    906  CD1 TYR A 108     -43.191  29.017  -6.011  1.00 14.21           C  
ATOM    907  CD2 TYR A 108     -44.921  28.853  -7.655  1.00 14.53           C  
ATOM    908  CE1 TYR A 108     -43.992  28.342  -5.089  1.00 16.06           C  
ATOM    909  CE2 TYR A 108     -45.732  28.171  -6.753  1.00 16.84           C  
ATOM    910  CZ  TYR A 108     -45.262  27.920  -5.460  1.00 17.08           C  
ATOM    911  OH  TYR A 108     -46.100  27.282  -4.569  1.00 21.39           O  
ATOM    912  N   PHE A 109     -43.386  28.491 -10.742  1.00 13.50           N  
ATOM    913  CA  PHE A 109     -44.139  27.448 -11.445  1.00 12.99           C  
ATOM    914  C   PHE A 109     -43.297  26.513 -12.306  1.00 14.14           C  
ATOM    915  O   PHE A 109     -43.632  25.318 -12.436  1.00 15.21           O  
ATOM    916  CB  PHE A 109     -45.292  28.073 -12.244  1.00 12.19           C  
ATOM    917  CG  PHE A 109     -46.434  28.523 -11.372  1.00 12.09           C  
ATOM    918  CD1 PHE A 109     -47.111  27.595 -10.571  1.00 15.06           C  
ATOM    919  CD2 PHE A 109     -46.803  29.871 -11.301  1.00 13.26           C  
ATOM    920  CE1 PHE A 109     -48.140  27.998  -9.705  1.00 13.92           C  
ATOM    921  CE2 PHE A 109     -47.843  30.289 -10.430  1.00 14.55           C  
ATOM    922  CZ  PHE A 109     -48.506  29.347  -9.629  1.00 14.38           C  
ATOM    923  N   GLU A 110     -42.203  27.016 -12.874  1.00 13.87           N  
ATOM    924  CA  GLU A 110     -41.352  26.172 -13.705  1.00 16.07           C  
ATOM    925  C   GLU A 110     -40.754  25.043 -12.877  1.00 15.69           C  
ATOM    926  O   GLU A 110     -40.767  23.874 -13.291  1.00 14.60           O  
ATOM    927  CB  GLU A 110     -40.238  27.018 -14.350  1.00 19.29           C  
ATOM    928  CG  GLU A 110     -40.704  27.772 -15.595  1.00 24.65           C  
ATOM    929  CD  GLU A 110     -39.812  28.960 -15.958  1.00 28.78           C  
ATOM    930  OE1 GLU A 110     -38.625  28.971 -15.553  1.00 31.07           O  
ATOM    931  OE2 GLU A 110     -40.299  29.885 -16.661  1.00 29.43           O  
ATOM    932  N   LYS A 111     -40.264  25.371 -11.692  1.00 13.71           N  
ATOM    933  CA  LYS A 111     -39.647  24.398 -10.815  1.00 14.32           C  
ATOM    934  C   LYS A 111     -40.630  23.389 -10.281  1.00 14.31           C  
ATOM    935  O   LYS A 111     -40.296  22.209 -10.145  1.00 15.28           O  
ATOM    936  CB  LYS A 111     -38.947  25.110  -9.648  1.00 14.53           C  
ATOM    937  CG  LYS A 111     -37.794  25.968 -10.093  1.00 17.72           C  
ATOM    938  CD  LYS A 111     -36.864  25.230 -11.074  1.00 20.69           C  
ATOM    939  CE  LYS A 111     -35.607  26.056 -11.313  1.00 21.59           C  
ATOM    940  NZ  LYS A 111     -34.668  25.462 -12.306  1.00 23.03           N  
ATOM    941  N   ILE A 112     -41.840  23.841  -9.970  1.00 13.86           N  
ATOM    942  CA  ILE A 112     -42.865  22.939  -9.465  1.00 14.72           C  
ATOM    943  C   ILE A 112     -43.226  21.970 -10.571  1.00 14.67           C  
ATOM    944  O   ILE A 112     -43.326  20.764 -10.340  1.00 15.40           O  
ATOM    945  CB  ILE A 112     -44.156  23.679  -9.050  1.00 16.08           C  
ATOM    946  CG1 ILE A 112     -43.874  24.615  -7.869  1.00 18.01           C  
ATOM    947  CG2 ILE A 112     -45.259  22.636  -8.727  1.00 17.44           C  
ATOM    948  CD1 ILE A 112     -43.669  23.900  -6.537  1.00 19.46           C  
ATOM    949  N   GLU A 113     -43.415  22.504 -11.773  1.00 15.91           N  
ATOM    950  CA  GLU A 113     -43.786  21.661 -12.908  1.00 15.84           C  
ATOM    951  C   GLU A 113     -42.712  20.624 -13.156  1.00 16.08           C  
ATOM    952  O   GLU A 113     -43.029  19.475 -13.464  1.00 15.42           O  
ATOM    953  CB  GLU A 113     -43.986  22.523 -14.162  1.00 18.62           C  
ATOM    954  CG  GLU A 113     -44.307  21.757 -15.447  1.00 23.19           C  
ATOM    955  CD  GLU A 113     -45.516  20.847 -15.304  1.00 26.45           C  
ATOM    956  OE1 GLU A 113     -46.412  21.179 -14.507  1.00 28.05           O  
ATOM    957  OE2 GLU A 113     -45.575  19.803 -16.007  1.00 29.83           O  
ATOM    958  N   ASP A 114     -41.444  21.018 -13.024  1.00 14.22           N  
ATOM    959  CA  ASP A 114     -40.370  20.059 -13.252  1.00 15.66           C  
ATOM    960  C   ASP A 114     -40.396  18.970 -12.208  1.00 15.74           C  
ATOM    961  O   ASP A 114     -40.236  17.786 -12.535  1.00 15.71           O  
ATOM    962  CB  ASP A 114     -38.990  20.710 -13.220  1.00 18.31           C  
ATOM    963  CG  ASP A 114     -37.883  19.716 -13.561  1.00 20.51           C  
ATOM    964  OD1 ASP A 114     -37.827  19.264 -14.724  1.00 23.55           O  
ATOM    965  OD2 ASP A 114     -37.088  19.363 -12.668  1.00 23.18           O  
ATOM    966  N   ALA A 115     -40.592  19.348 -10.947  1.00 15.08           N  
ATOM    967  CA  ALA A 115     -40.648  18.351  -9.886  1.00 14.69           C  
ATOM    968  C   ALA A 115     -41.841  17.424 -10.155  1.00 15.45           C  
ATOM    969  O   ALA A 115     -41.747  16.204  -9.963  1.00 16.12           O  
ATOM    970  CB  ALA A 115     -40.815  19.035  -8.523  1.00 16.72           C  
ATOM    971  N   LYS A 116     -42.964  18.006 -10.587  1.00 15.44           N  
ATOM    972  CA  LYS A 116     -44.157  17.213 -10.867  1.00 15.95           C  
ATOM    973  C   LYS A 116     -43.899  16.225 -12.004  1.00 13.95           C  
ATOM    974  O   LYS A 116     -44.299  15.057 -11.905  1.00 15.01           O  
ATOM    975  CB  LYS A 116     -45.333  18.119 -11.238  1.00 17.07           C  
ATOM    976  CG  LYS A 116     -46.671  17.404 -11.166  1.00 20.20           C  
ATOM    977  CD  LYS A 116     -47.814  18.403 -11.180  1.00 24.79           C  
ATOM    978  CE  LYS A 116     -48.401  18.570 -12.567  1.00 27.96           C  
ATOM    979  NZ  LYS A 116     -49.211  17.389 -12.951  1.00 27.77           N  
ATOM    980  N   ARG A 117     -43.231  16.684 -13.066  1.00 15.18           N  
ATOM    981  CA  ARG A 117     -42.928  15.807 -14.194  1.00 15.03           C  
ATOM    982  C   ARG A 117     -42.057  14.642 -13.742  1.00 13.91           C  
ATOM    983  O   ARG A 117     -42.304  13.492 -14.120  1.00 13.73           O  
ATOM    984  CB  ARG A 117     -42.204  16.558 -15.322  1.00 19.52           C  
ATOM    985  CG  ARG A 117     -43.092  17.479 -16.157  1.00 24.88           C  
ATOM    986  CD  ARG A 117     -42.378  17.917 -17.449  1.00 28.23           C  
ATOM    987  NE  ARG A 117     -41.120  18.631 -17.208  1.00 32.50           N  
ATOM    988  CZ  ARG A 117     -41.035  19.932 -16.932  1.00 33.40           C  
ATOM    989  NH1 ARG A 117     -42.134  20.664 -16.867  1.00 35.65           N  
ATOM    990  NH2 ARG A 117     -39.854  20.498 -16.720  1.00 34.38           N  
ATOM    991  N   ARG A 118     -41.050  14.923 -12.912  1.00 13.87           N  
ATOM    992  CA  ARG A 118     -40.178  13.854 -12.444  1.00 12.80           C  
ATOM    993  C   ARG A 118     -40.894  12.874 -11.533  1.00 12.47           C  
ATOM    994  O   ARG A 118     -40.672  11.656 -11.598  1.00 12.24           O  
ATOM    995  CB  ARG A 118     -38.968  14.443 -11.718  1.00 13.45           C  
ATOM    996  CG  ARG A 118     -38.088  15.200 -12.650  1.00 13.74           C  
ATOM    997  CD  ARG A 118     -36.949  15.847 -11.900  1.00 13.60           C  
ATOM    998  NE  ARG A 118     -36.110  16.640 -12.799  1.00 17.47           N  
ATOM    999  CZ  ARG A 118     -35.096  16.130 -13.493  1.00 20.80           C  
ATOM   1000  NH1 ARG A 118     -34.802  14.840 -13.388  1.00 22.16           N  
ATOM   1001  NH2 ARG A 118     -34.382  16.913 -14.282  1.00 22.72           N  
ATOM   1002  N   PHE A 119     -41.744  13.394 -10.657  1.00 11.57           N  
ATOM   1003  CA  PHE A 119     -42.483  12.546  -9.772  1.00 11.27           C  
ATOM   1004  C   PHE A 119     -43.434  11.668 -10.594  1.00 10.78           C  
ATOM   1005  O   PHE A 119     -43.598  10.466 -10.328  1.00 10.47           O  
ATOM   1006  CB  PHE A 119     -43.245  13.421  -8.775  1.00 12.76           C  
ATOM   1007  CG  PHE A 119     -43.946  12.650  -7.715  1.00 17.20           C  
ATOM   1008  CD1 PHE A 119     -43.387  11.500  -7.157  1.00 16.49           C  
ATOM   1009  CD2 PHE A 119     -45.187  13.102  -7.251  1.00 17.37           C  
ATOM   1010  CE1 PHE A 119     -44.051  10.805  -6.147  1.00 18.80           C  
ATOM   1011  CE2 PHE A 119     -45.853  12.422  -6.250  1.00 20.58           C  
ATOM   1012  CZ  PHE A 119     -45.291  11.274  -5.693  1.00 20.03           C  
ATOM   1013  N   GLU A 120     -44.069  12.268 -11.592  1.00 11.67           N  
ATOM   1014  CA  GLU A 120     -44.980  11.498 -12.441  1.00 13.79           C  
ATOM   1015  C   GLU A 120     -44.268  10.359 -13.114  1.00 12.64           C  
ATOM   1016  O   GLU A 120     -44.788   9.223 -13.132  1.00 11.59           O  
ATOM   1017  CB  GLU A 120     -45.609  12.364 -13.533  1.00 14.44           C  
ATOM   1018  CG  GLU A 120     -46.782  13.091 -13.030  1.00 19.54           C  
ATOM   1019  CD  GLU A 120     -47.677  13.599 -14.113  1.00 17.83           C  
ATOM   1020  OE1 GLU A 120     -48.624  14.287 -13.706  1.00 22.67           O  
ATOM   1021  OE2 GLU A 120     -47.464  13.332 -15.338  1.00 18.83           O  
ATOM   1022  N   LYS A 121     -43.089  10.651 -13.678  1.00 12.06           N  
ATOM   1023  CA  LYS A 121     -42.297   9.633 -14.377  1.00 13.57           C  
ATOM   1024  C   LYS A 121     -41.997   8.479 -13.435  1.00 13.05           C  
ATOM   1025  O   LYS A 121     -42.078   7.318 -13.810  1.00 12.97           O  
ATOM   1026  CB  LYS A 121     -40.987  10.229 -14.902  1.00 16.53           C  
ATOM   1027  CG  LYS A 121     -41.202  11.199 -16.074  1.00 20.73           C  
ATOM   1028  CD  LYS A 121     -39.896  11.648 -16.731  1.00 24.97           C  
ATOM   1029  CE  LYS A 121     -40.094  12.941 -17.552  1.00 27.24           C  
ATOM   1030  NZ  LYS A 121     -41.279  12.898 -18.465  1.00 31.50           N  
ATOM   1031  N   PHE A 122     -41.599   8.808 -12.216  1.00 10.73           N  
ATOM   1032  CA  PHE A 122     -41.326   7.777 -11.208  1.00  9.34           C  
ATOM   1033  C   PHE A 122     -42.581   6.931 -10.924  1.00 10.94           C  
ATOM   1034  O   PHE A 122     -42.534   5.683 -10.833  1.00 11.78           O  
ATOM   1035  CB  PHE A 122     -40.812   8.480  -9.936  1.00 10.10           C  
ATOM   1036  CG  PHE A 122     -40.825   7.620  -8.706  1.00  8.37           C  
ATOM   1037  CD1 PHE A 122     -39.750   6.766  -8.420  1.00 10.27           C  
ATOM   1038  CD2 PHE A 122     -41.911   7.651  -7.831  1.00 10.63           C  
ATOM   1039  CE1 PHE A 122     -39.778   5.971  -7.280  1.00 12.20           C  
ATOM   1040  CE2 PHE A 122     -41.948   6.853  -6.679  1.00 12.69           C  
ATOM   1041  CZ  PHE A 122     -40.871   6.013  -6.410  1.00 12.71           C  
ATOM   1042  N   LEU A 123     -43.732   7.581 -10.800  1.00  9.65           N  
ATOM   1043  CA  LEU A 123     -44.954   6.846 -10.515  1.00 11.37           C  
ATOM   1044  C   LEU A 123     -45.500   6.047 -11.685  1.00 12.13           C  
ATOM   1045  O   LEU A 123     -46.275   5.126 -11.465  1.00 12.81           O  
ATOM   1046  CB  LEU A 123     -46.033   7.798 -10.018  1.00 11.47           C  
ATOM   1047  CG  LEU A 123     -45.770   8.392  -8.631  1.00 12.85           C  
ATOM   1048  CD1 LEU A 123     -46.766   9.499  -8.404  1.00 16.42           C  
ATOM   1049  CD2 LEU A 123     -45.881   7.316  -7.546  1.00 13.61           C  
ATOM   1050  N   GLU A 124     -45.099   6.378 -12.918  1.00 12.68           N  
ATOM   1051  CA  GLU A 124     -45.631   5.647 -14.084  1.00 11.98           C  
ATOM   1052  C   GLU A 124     -45.155   4.211 -14.124  1.00 14.67           C  
ATOM   1053  O   GLU A 124     -45.811   3.368 -14.747  1.00 13.75           O  
ATOM   1054  CB  GLU A 124     -45.242   6.335 -15.406  1.00 10.78           C  
ATOM   1055  CG  GLU A 124     -45.969   7.653 -15.749  1.00 10.08           C  
ATOM   1056  CD  GLU A 124     -47.449   7.499 -16.153  1.00 10.67           C  
ATOM   1057  OE1 GLU A 124     -47.891   6.427 -16.623  1.00  9.13           O  
ATOM   1058  OE2 GLU A 124     -48.149   8.520 -16.013  1.00  8.18           O  
ATOM   1059  N   LYS A 125     -44.042   3.929 -13.446  1.00 17.02           N  
ATOM   1060  CA  LYS A 125     -43.483   2.595 -13.440  1.00 21.01           C  
ATOM   1061  C   LYS A 125     -44.449   1.588 -12.855  1.00 21.36           C  
ATOM   1062  O   LYS A 125     -44.792   0.609 -13.523  1.00 23.18           O  
ATOM   1063  CB  LYS A 125     -42.149   2.567 -12.687  1.00 22.74           C  
ATOM   1064  CG  LYS A 125     -41.115   3.517 -13.284  1.00 27.96           C  
ATOM   1065  CD  LYS A 125     -39.697   2.966 -13.141  1.00 31.99           C  
ATOM   1066  CE  LYS A 125     -38.673   3.889 -13.788  1.00 34.30           C  
ATOM   1067  NZ  LYS A 125     -38.845   3.989 -15.268  1.00 36.04           N  
ATOM   1068  N   HIS A 126     -44.925   1.826 -11.638  1.00 21.41           N  
ATOM   1069  CA  HIS A 126     -45.854   0.864 -11.051  1.00 21.30           C  
ATOM   1070  C   HIS A 126     -47.325   1.280 -10.936  1.00 18.51           C  
ATOM   1071  O   HIS A 126     -48.155   0.459 -10.554  1.00 17.59           O  
ATOM   1072  CB  HIS A 126     -45.342   0.405  -9.684  1.00 23.51           C  
ATOM   1073  CG  HIS A 126     -44.029  -0.311  -9.749  1.00 27.71           C  
ATOM   1074  ND1 HIS A 126     -43.878  -1.536 -10.366  1.00 29.21           N  
ATOM   1075  CD2 HIS A 126     -42.796   0.046  -9.317  1.00 28.94           C  
ATOM   1076  CE1 HIS A 126     -42.608  -1.898 -10.314  1.00 29.90           C  
ATOM   1077  NE2 HIS A 126     -41.930  -0.955  -9.684  1.00 30.48           N  
ATOM   1078  N   PHE A 127     -47.657   2.537 -11.236  1.00 15.85           N  
ATOM   1079  CA  PHE A 127     -49.074   2.965 -11.179  1.00 13.78           C  
ATOM   1080  C   PHE A 127     -49.337   3.818 -12.438  1.00 11.70           C  
ATOM   1081  O   PHE A 127     -49.766   4.963 -12.313  1.00 11.57           O  
ATOM   1082  CB  PHE A 127     -49.306   3.853  -9.945  1.00 16.44           C  
ATOM   1083  CG  PHE A 127     -48.740   3.284  -8.675  1.00 18.44           C  
ATOM   1084  CD1 PHE A 127     -49.512   2.475  -7.860  1.00 20.18           C  
ATOM   1085  CD2 PHE A 127     -47.408   3.528  -8.330  1.00 20.61           C  
ATOM   1086  CE1 PHE A 127     -48.969   1.900  -6.691  1.00 22.81           C  
ATOM   1087  CE2 PHE A 127     -46.856   2.962  -7.174  1.00 22.69           C  
ATOM   1088  CZ  PHE A 127     -47.642   2.151  -6.359  1.00 21.91           C  
ATOM   1089  N   PRO A 128     -49.136   3.263 -13.646  1.00 11.86           N  
ATOM   1090  CA  PRO A 128     -49.353   4.064 -14.858  1.00 11.72           C  
ATOM   1091  C   PRO A 128     -50.652   4.838 -14.983  1.00 11.05           C  
ATOM   1092  O   PRO A 128     -50.641   6.035 -15.316  1.00  7.62           O  
ATOM   1093  CB  PRO A 128     -49.168   3.050 -16.000  1.00 13.81           C  
ATOM   1094  CG  PRO A 128     -49.482   1.714 -15.327  1.00 14.55           C  
ATOM   1095  CD  PRO A 128     -48.861   1.849 -13.973  1.00 14.91           C  
ATOM   1096  N   SER A 129     -51.763   4.147 -14.789  1.00 11.76           N  
ATOM   1097  CA  SER A 129     -53.055   4.779 -14.923  1.00 12.15           C  
ATOM   1098  C   SER A 129     -53.443   5.724 -13.827  1.00 12.60           C  
ATOM   1099  O   SER A 129     -54.438   6.428 -13.977  1.00 12.42           O  
ATOM   1100  CB  SER A 129     -54.148   3.734 -15.092  1.00 14.78           C  
ATOM   1101  OG  SER A 129     -54.019   3.172 -16.385  1.00 19.79           O  
ATOM   1102  N   LYS A 130     -52.689   5.718 -12.727  1.00 11.20           N  
ATOM   1103  CA  LYS A 130     -52.984   6.621 -11.604  1.00 11.18           C  
ATOM   1104  C   LYS A 130     -51.854   7.630 -11.350  1.00 10.98           C  
ATOM   1105  O   LYS A 130     -51.992   8.517 -10.518  1.00 10.12           O  
ATOM   1106  CB  LYS A 130     -53.217   5.814 -10.336  1.00 12.23           C  
ATOM   1107  CG  LYS A 130     -54.484   4.966 -10.348  1.00 15.26           C  
ATOM   1108  CD  LYS A 130     -54.515   4.141  -9.038  1.00 18.43           C  
ATOM   1109  CE  LYS A 130     -55.747   3.235  -8.911  1.00 24.47           C  
ATOM   1110  NZ  LYS A 130     -56.994   4.004  -8.590  1.00 23.34           N  
ATOM   1111  N   ALA A 131     -50.748   7.530 -12.083  1.00  9.42           N  
ATOM   1112  CA  ALA A 131     -49.606   8.442 -11.830  1.00 10.81           C  
ATOM   1113  C   ALA A 131     -49.917   9.936 -11.904  1.00 11.65           C  
ATOM   1114  O   ALA A 131     -49.493  10.733 -11.048  1.00 11.81           O  
ATOM   1115  CB  ALA A 131     -48.443   8.080 -12.794  1.00  9.77           C  
ATOM   1116  N   GLU A 132     -50.658  10.327 -12.927  1.00 11.39           N  
ATOM   1117  CA  GLU A 132     -51.032  11.701 -13.104  1.00 11.47           C  
ATOM   1118  C   GLU A 132     -51.862  12.215 -11.923  1.00 13.17           C  
ATOM   1119  O   GLU A 132     -51.582  13.297 -11.391  1.00 16.70           O  
ATOM   1120  CB  GLU A 132     -51.802  11.830 -14.414  1.00  9.54           C  
ATOM   1121  CG  GLU A 132     -50.869  11.589 -15.632  1.00 10.59           C  
ATOM   1122  CD  GLU A 132     -50.753  10.125 -16.125  1.00  9.88           C  
ATOM   1123  OE1 GLU A 132     -51.084   9.162 -15.429  1.00  9.40           O  
ATOM   1124  OE2 GLU A 132     -50.266   9.963 -17.264  1.00  7.66           O  
ATOM   1125  N   ILE A 133     -52.837  11.426 -11.488  1.00 10.49           N  
ATOM   1126  CA  ILE A 133     -53.715  11.779 -10.369  1.00 10.38           C  
ATOM   1127  C   ILE A 133     -52.930  11.823  -9.059  1.00  9.41           C  
ATOM   1128  O   ILE A 133     -53.038  12.772  -8.271  1.00  9.88           O  
ATOM   1129  CB  ILE A 133     -54.863  10.717 -10.210  1.00 12.62           C  
ATOM   1130  CG1 ILE A 133     -55.654  10.597 -11.515  1.00 14.72           C  
ATOM   1131  CG2 ILE A 133     -55.769  11.093  -9.039  1.00 17.44           C  
ATOM   1132  CD1 ILE A 133     -56.621   9.433 -11.570  1.00 17.07           C  
ATOM   1133  N   LEU A 134     -52.141  10.785  -8.836  1.00  9.84           N  
ATOM   1134  CA  LEU A 134     -51.363  10.690  -7.606  1.00  9.53           C  
ATOM   1135  C   LEU A 134     -50.375  11.826  -7.481  1.00  9.23           C  
ATOM   1136  O   LEU A 134     -50.128  12.322  -6.372  1.00 10.04           O  
ATOM   1137  CB  LEU A 134     -50.593   9.369  -7.583  1.00 10.35           C  
ATOM   1138  CG  LEU A 134     -51.398   8.105  -7.303  1.00 11.57           C  
ATOM   1139  CD1 LEU A 134     -50.566   6.845  -7.677  1.00 13.69           C  
ATOM   1140  CD2 LEU A 134     -51.793   8.108  -5.823  1.00 12.17           C  
ATOM   1141  N   SER A 135     -49.803  12.270  -8.598  1.00 10.42           N  
ATOM   1142  CA  SER A 135     -48.827  13.347  -8.494  1.00  9.67           C  
ATOM   1143  C   SER A 135     -49.483  14.626  -7.980  1.00 11.60           C  
ATOM   1144  O   SER A 135     -48.872  15.326  -7.175  1.00 13.30           O  
ATOM   1145  CB  SER A 135     -48.136  13.615  -9.845  1.00 11.89           C  
ATOM   1146  OG  SER A 135     -49.024  14.223 -10.778  1.00 14.86           O  
ATOM   1147  N   GLU A 136     -50.713  14.916  -8.430  1.00 11.62           N  
ATOM   1148  CA  GLU A 136     -51.463  16.092  -8.015  1.00 11.68           C  
ATOM   1149  C   GLU A 136     -51.807  15.995  -6.534  1.00 11.29           C  
ATOM   1150  O   GLU A 136     -51.607  16.954  -5.753  1.00 10.64           O  
ATOM   1151  CB  GLU A 136     -52.772  16.199  -8.795  1.00 15.27           C  
ATOM   1152  CG  GLU A 136     -52.620  16.280 -10.316  1.00 17.36           C  
ATOM   1153  CD  GLU A 136     -52.379  17.680 -10.830  1.00 19.25           C  
ATOM   1154  OE1 GLU A 136     -52.172  18.612 -10.006  1.00 20.27           O  
ATOM   1155  OE2 GLU A 136     -52.376  17.837 -12.065  1.00 17.52           O  
ATOM   1156  N   ILE A 137     -52.338  14.840  -6.150  1.00 10.35           N  
ATOM   1157  CA  ILE A 137     -52.717  14.619  -4.757  1.00  9.45           C  
ATOM   1158  C   ILE A 137     -51.522  14.741  -3.812  1.00  8.87           C  
ATOM   1159  O   ILE A 137     -51.554  15.471  -2.811  1.00  9.91           O  
ATOM   1160  CB  ILE A 137     -53.292  13.212  -4.549  1.00  9.80           C  
ATOM   1161  CG1 ILE A 137     -54.630  13.055  -5.303  1.00 11.06           C  
ATOM   1162  CG2 ILE A 137     -53.484  12.971  -3.049  1.00 11.04           C  
ATOM   1163  CD1 ILE A 137     -55.110  11.602  -5.406  1.00 10.89           C  
ATOM   1164  N   ILE A 138     -50.468  14.006  -4.126  1.00 10.35           N  
ATOM   1165  CA  ILE A 138     -49.314  13.978  -3.248  1.00 10.74           C  
ATOM   1166  C   ILE A 138     -48.556  15.285  -3.202  1.00 11.36           C  
ATOM   1167  O   ILE A 138     -48.158  15.725  -2.118  1.00 11.86           O  
ATOM   1168  CB  ILE A 138     -48.421  12.793  -3.625  1.00 11.61           C  
ATOM   1169  CG1 ILE A 138     -49.214  11.506  -3.357  1.00 13.39           C  
ATOM   1170  CG2 ILE A 138     -47.136  12.799  -2.787  1.00 12.03           C  
ATOM   1171  CD1 ILE A 138     -48.541  10.238  -3.871  1.00 14.70           C  
ATOM   1172  N   LEU A 139     -48.357  15.944  -4.338  1.00  9.94           N  
ATOM   1173  CA  LEU A 139     -47.680  17.235  -4.281  1.00 10.69           C  
ATOM   1174  C   LEU A 139     -48.541  18.232  -3.512  1.00 10.40           C  
ATOM   1175  O   LEU A 139     -48.020  19.050  -2.759  1.00 10.01           O  
ATOM   1176  CB  LEU A 139     -47.399  17.787  -5.681  1.00 15.04           C  
ATOM   1177  CG  LEU A 139     -46.248  17.125  -6.434  1.00 18.73           C  
ATOM   1178  CD1 LEU A 139     -46.027  17.863  -7.763  1.00 21.20           C  
ATOM   1179  CD2 LEU A 139     -44.982  17.183  -5.609  1.00 22.53           C  
ATOM   1180  N   GLY A 140     -49.856  18.159  -3.701  1.00  9.09           N  
ATOM   1181  CA  GLY A 140     -50.751  19.051  -2.981  1.00  8.99           C  
ATOM   1182  C   GLY A 140     -50.656  18.826  -1.480  1.00 10.31           C  
ATOM   1183  O   GLY A 140     -50.544  19.775  -0.695  1.00 10.98           O  
ATOM   1184  N   PHE A 141     -50.657  17.563  -1.090  1.00 10.44           N  
ATOM   1185  CA  PHE A 141     -50.570  17.190   0.322  1.00  9.66           C  
ATOM   1186  C   PHE A 141     -49.235  17.636   0.921  1.00 10.91           C  
ATOM   1187  O   PHE A 141     -49.204  18.205   2.015  1.00 10.62           O  
ATOM   1188  CB  PHE A 141     -50.776  15.665   0.400  1.00  8.37           C  
ATOM   1189  CG  PHE A 141     -50.561  15.050   1.767  1.00  8.05           C  
ATOM   1190  CD1 PHE A 141     -51.097  15.623   2.924  1.00  9.16           C  
ATOM   1191  CD2 PHE A 141     -49.864  13.839   1.874  1.00  9.37           C  
ATOM   1192  CE1 PHE A 141     -50.943  14.982   4.180  1.00  9.59           C  
ATOM   1193  CE2 PHE A 141     -49.721  13.208   3.105  1.00  9.76           C  
ATOM   1194  CZ  PHE A 141     -50.266  13.782   4.256  1.00  9.02           C  
ATOM   1195  N   LEU A 142     -48.143  17.403   0.204  1.00 10.85           N  
ATOM   1196  CA  LEU A 142     -46.824  17.791   0.714  1.00 12.81           C  
ATOM   1197  C   LEU A 142     -46.785  19.305   0.871  1.00 13.83           C  
ATOM   1198  O   LEU A 142     -46.293  19.817   1.884  1.00 12.43           O  
ATOM   1199  CB  LEU A 142     -45.749  17.303  -0.247  1.00 14.80           C  
ATOM   1200  CG  LEU A 142     -44.287  17.545   0.089  1.00 16.22           C  
ATOM   1201  CD1 LEU A 142     -43.939  16.881   1.416  1.00 16.52           C  
ATOM   1202  CD2 LEU A 142     -43.449  16.978  -1.055  1.00 17.88           C  
ATOM   1203  N   ARG A 143     -47.320  20.039  -0.105  1.00 13.49           N  
ATOM   1204  CA  ARG A 143     -47.321  21.500  -0.007  1.00 14.82           C  
ATOM   1205  C   ARG A 143     -48.180  21.983   1.185  1.00 14.09           C  
ATOM   1206  O   ARG A 143     -47.775  22.894   1.912  1.00 16.58           O  
ATOM   1207  CB  ARG A 143     -47.739  22.078  -1.360  1.00 16.19           C  
ATOM   1208  CG  ARG A 143     -46.655  21.693  -2.402  1.00 18.83           C  
ATOM   1209  CD  ARG A 143     -47.056  21.954  -3.850  1.00 20.58           C  
ATOM   1210  NE  ARG A 143     -47.060  23.376  -4.181  1.00 22.70           N  
ATOM   1211  CZ  ARG A 143     -47.501  23.862  -5.337  1.00 23.04           C  
ATOM   1212  NH1 ARG A 143     -47.973  23.048  -6.256  1.00 21.98           N  
ATOM   1213  NH2 ARG A 143     -47.446  25.159  -5.585  1.00 24.67           N  
ATOM   1214  N   GLN A 144     -49.322  21.331   1.436  1.00 11.23           N  
ATOM   1215  CA  GLN A 144     -50.195  21.665   2.566  1.00 11.54           C  
ATOM   1216  C   GLN A 144     -49.392  21.488   3.871  1.00 11.36           C  
ATOM   1217  O   GLN A 144     -49.414  22.349   4.757  1.00 11.19           O  
ATOM   1218  CB  GLN A 144     -51.422  20.733   2.586  1.00 11.57           C  
ATOM   1219  CG  GLN A 144     -52.324  20.794   3.831  1.00 17.30           C  
ATOM   1220  CD  GLN A 144     -53.396  21.874   3.771  1.00 21.10           C  
ATOM   1221  OE1 GLN A 144     -53.698  22.410   2.706  1.00 24.38           O  
ATOM   1222  NE2 GLN A 144     -53.995  22.174   4.914  1.00 22.21           N  
ATOM   1223  N   LEU A 145     -48.666  20.379   3.979  1.00 11.18           N  
ATOM   1224  CA  LEU A 145     -47.888  20.152   5.201  1.00 10.90           C  
ATOM   1225  C   LEU A 145     -46.777  21.167   5.378  1.00 12.04           C  
ATOM   1226  O   LEU A 145     -46.515  21.619   6.499  1.00 11.01           O  
ATOM   1227  CB  LEU A 145     -47.275  18.753   5.217  1.00 10.50           C  
ATOM   1228  CG  LEU A 145     -48.223  17.557   5.188  1.00  9.95           C  
ATOM   1229  CD1 LEU A 145     -47.341  16.296   5.151  1.00 11.06           C  
ATOM   1230  CD2 LEU A 145     -49.154  17.561   6.390  1.00 10.58           C  
ATOM   1231  N   ILE A 146     -46.105  21.539   4.301  1.00 12.79           N  
ATOM   1232  CA  ILE A 146     -45.019  22.500   4.450  1.00 13.71           C  
ATOM   1233  C   ILE A 146     -45.559  23.873   4.790  1.00 13.69           C  
ATOM   1234  O   ILE A 146     -45.014  24.577   5.637  1.00 12.27           O  
ATOM   1235  CB  ILE A 146     -44.193  22.595   3.153  1.00 15.49           C  
ATOM   1236  CG1 ILE A 146     -43.497  21.260   2.888  1.00 15.95           C  
ATOM   1237  CG2 ILE A 146     -43.164  23.746   3.256  1.00 17.08           C  
ATOM   1238  CD1 ILE A 146     -42.545  20.827   3.965  1.00 19.88           C  
ATOM   1239  N   LEU A 147     -46.623  24.276   4.105  1.00 12.26           N  
ATOM   1240  CA  LEU A 147     -47.199  25.588   4.349  1.00 13.48           C  
ATOM   1241  C   LEU A 147     -47.703  25.729   5.787  1.00 13.30           C  
ATOM   1242  O   LEU A 147     -47.508  26.749   6.451  1.00 14.57           O  
ATOM   1243  CB  LEU A 147     -48.345  25.819   3.362  1.00 16.63           C  
ATOM   1244  CG  LEU A 147     -48.989  27.188   3.424  1.00 19.74           C  
ATOM   1245  CD1 LEU A 147     -48.005  28.242   2.938  1.00 21.55           C  
ATOM   1246  CD2 LEU A 147     -50.208  27.173   2.544  1.00 20.41           C  
ATOM   1247  N   HIS A 148     -48.333  24.693   6.297  1.00 13.29           N  
ATOM   1248  CA  HIS A 148     -48.863  24.801   7.634  1.00 13.28           C  
ATOM   1249  C   HIS A 148     -47.953  24.440   8.759  1.00 13.68           C  
ATOM   1250  O   HIS A 148     -48.071  25.019   9.838  1.00 14.06           O  
ATOM   1251  CB  HIS A 148     -50.148  24.010   7.710  1.00 15.96           C  
ATOM   1252  CG  HIS A 148     -51.219  24.638   6.892  1.00 18.14           C  
ATOM   1253  ND1 HIS A 148     -52.110  25.544   7.425  1.00 19.65           N  
ATOM   1254  CD2 HIS A 148     -51.400  24.674   5.549  1.00 19.41           C  
ATOM   1255  CE1 HIS A 148     -52.785  26.117   6.444  1.00 21.41           C  
ATOM   1256  NE2 HIS A 148     -52.372  25.608   5.296  1.00 21.39           N  
ATOM   1257  N   TYR A 149     -47.008  23.546   8.518  1.00 12.84           N  
ATOM   1258  CA  TYR A 149     -46.162  23.099   9.614  1.00 14.03           C  
ATOM   1259  C   TYR A 149     -44.693  23.451   9.485  1.00 15.64           C  
ATOM   1260  O   TYR A 149     -43.863  22.990  10.272  1.00 16.46           O  
ATOM   1261  CB  TYR A 149     -46.363  21.598   9.815  1.00 13.23           C  
ATOM   1262  CG  TYR A 149     -47.823  21.210  10.014  1.00 12.19           C  
ATOM   1263  CD1 TYR A 149     -48.579  21.714  11.079  1.00 11.08           C  
ATOM   1264  CD2 TYR A 149     -48.453  20.348   9.114  1.00 10.24           C  
ATOM   1265  CE1 TYR A 149     -49.924  21.374  11.247  1.00 10.01           C  
ATOM   1266  CE2 TYR A 149     -49.804  20.001   9.263  1.00 11.49           C  
ATOM   1267  CZ  TYR A 149     -50.537  20.519  10.333  1.00 11.65           C  
ATOM   1268  OH  TYR A 149     -51.853  20.183  10.548  1.00 15.34           O  
ATOM   1269  N   VAL A 150     -44.365  24.231   8.459  1.00 16.15           N  
ATOM   1270  CA  VAL A 150     -43.000  24.739   8.302  1.00 17.73           C  
ATOM   1271  C   VAL A 150     -43.125  26.267   8.156  1.00 18.49           C  
ATOM   1272  O   VAL A 150     -42.396  27.027   8.816  1.00 20.91           O  
ATOM   1273  CB  VAL A 150     -42.282  24.148   7.066  1.00 17.22           C  
ATOM   1274  CG1 VAL A 150     -40.896  24.808   6.891  1.00 19.65           C  
ATOM   1275  CG2 VAL A 150     -42.122  22.646   7.235  1.00 16.95           C  
ATOM   1276  N   ILE A 151     -44.069  26.731   7.336  1.00 19.45           N  
ATOM   1277  CA  ILE A 151     -44.237  28.183   7.127  1.00 20.74           C  
ATOM   1278  C   ILE A 151     -45.073  28.915   8.165  1.00 21.92           C  
ATOM   1279  O   ILE A 151     -44.626  29.922   8.727  1.00 22.77           O  
ATOM   1280  CB  ILE A 151     -44.856  28.496   5.738  1.00 20.80           C  
ATOM   1281  CG1 ILE A 151     -43.962  27.921   4.638  1.00 20.33           C  
ATOM   1282  CG2 ILE A 151     -45.058  30.018   5.580  1.00 21.26           C  
ATOM   1283  CD1 ILE A 151     -42.528  28.431   4.674  1.00 23.33           C  
ATOM   1284  N   LYS A 152     -46.296  28.459   8.394  1.00 21.89           N  
ATOM   1285  CA  LYS A 152     -47.165  29.100   9.368  1.00 23.68           C  
ATOM   1286  C   LYS A 152     -46.503  28.992  10.727  1.00 25.40           C  
ATOM   1287  O   LYS A 152     -46.254  29.995  11.397  1.00 27.38           O  
ATOM   1288  CB  LYS A 152     -48.527  28.419   9.397  1.00 22.56           C  
ATOM   1289  CG  LYS A 152     -49.462  28.976  10.451  1.00 22.70           C  
ATOM   1290  CD  LYS A 152     -50.818  28.300  10.361  1.00 24.35           C  
ATOM   1291  CE  LYS A 152     -51.761  28.818  11.425  1.00 26.50           C  
ATOM   1292  NZ  LYS A 152     -52.973  27.950  11.567  1.00 27.58           N  
ATOM   1293  N   GLU A 153     -46.221  27.763  11.127  1.00 25.70           N  
ATOM   1294  CA  GLU A 153     -45.555  27.501  12.393  1.00 27.40           C  
ATOM   1295  C   GLU A 153     -44.451  26.518  12.081  1.00 25.03           C  
ATOM   1296  O   GLU A 153     -44.652  25.622  11.267  1.00 26.69           O  
ATOM   1297  CB  GLU A 153     -46.530  26.884  13.385  1.00 28.75           C  
ATOM   1298  CG  GLU A 153     -45.841  26.354  14.626  1.00 34.37           C  
ATOM   1299  CD  GLU A 153     -46.787  26.200  15.800  1.00 38.12           C  
ATOM   1300  OE1 GLU A 153     -46.338  25.704  16.858  1.00 39.21           O  
ATOM   1301  OE2 GLU A 153     -47.971  26.580  15.670  1.00 39.81           O  
ATOM   1302  N   GLU A 154     -43.278  26.691  12.680  1.00 22.54           N  
ATOM   1303  CA  GLU A 154     -42.214  25.760  12.405  1.00 21.07           C  
ATOM   1304  C   GLU A 154     -42.228  24.581  13.366  1.00 19.49           C  
ATOM   1305  O   GLU A 154     -41.718  24.661  14.481  1.00 20.42           O  
ATOM   1306  CB  GLU A 154     -40.828  26.434  12.412  1.00 24.18           C  
ATOM   1307  CG  GLU A 154     -39.682  25.420  12.195  1.00 27.53           C  
ATOM   1308  CD  GLU A 154     -38.331  26.048  11.854  1.00 29.42           C  
ATOM   1309  OE1 GLU A 154     -37.320  25.651  12.479  1.00 31.32           O  
ATOM   1310  OE2 GLU A 154     -38.271  26.917  10.955  1.00 30.64           O  
ATOM   1311  N   ARG A 155     -42.840  23.490  12.925  1.00 15.68           N  
ATOM   1312  CA  ARG A 155     -42.873  22.268  13.704  1.00 13.50           C  
ATOM   1313  C   ARG A 155     -41.578  21.526  13.404  1.00 12.62           C  
ATOM   1314  O   ARG A 155     -40.906  21.800  12.393  1.00 14.06           O  
ATOM   1315  CB  ARG A 155     -44.061  21.378  13.296  1.00 12.74           C  
ATOM   1316  CG  ARG A 155     -45.429  22.031  13.477  1.00 13.05           C  
ATOM   1317  CD  ARG A 155     -45.667  22.452  14.927  1.00 11.57           C  
ATOM   1318  NE  ARG A 155     -45.544  21.306  15.835  1.00 16.24           N  
ATOM   1319  CZ  ARG A 155     -46.541  20.475  16.154  1.00 16.87           C  
ATOM   1320  NH1 ARG A 155     -47.768  20.657  15.667  1.00 15.96           N  
ATOM   1321  NH2 ARG A 155     -46.293  19.420  16.928  1.00 17.89           N  
ATOM   1322  N   GLU A 156     -41.242  20.574  14.274  1.00 13.11           N  
ATOM   1323  CA  GLU A 156     -40.042  19.764  14.097  1.00 14.45           C  
ATOM   1324  C   GLU A 156     -40.338  18.695  13.034  1.00 13.70           C  
ATOM   1325  O   GLU A 156     -41.485  18.263  12.840  1.00 13.93           O  
ATOM   1326  CB  GLU A 156     -39.637  19.075  15.406  1.00 17.19           C  
ATOM   1327  CG  GLU A 156     -39.181  20.024  16.511  1.00 22.49           C  
ATOM   1328  CD  GLU A 156     -38.830  19.280  17.794  1.00 27.44           C  
ATOM   1329  OE1 GLU A 156     -37.974  18.369  17.745  1.00 29.39           O  
ATOM   1330  OE2 GLU A 156     -39.406  19.602  18.858  1.00 31.75           O  
ATOM   1331  N   LEU A 157     -39.288  18.246  12.377  1.00 11.82           N  
ATOM   1332  CA  LEU A 157     -39.409  17.244  11.309  1.00 11.26           C  
ATOM   1333  C   LEU A 157     -40.156  15.949  11.665  1.00 11.70           C  
ATOM   1334  O   LEU A 157     -40.913  15.425  10.836  1.00 11.92           O  
ATOM   1335  CB  LEU A 157     -38.005  16.923  10.759  1.00 11.53           C  
ATOM   1336  CG  LEU A 157     -37.897  15.895   9.623  1.00 11.90           C  
ATOM   1337  CD1 LEU A 157     -38.761  16.344   8.394  1.00 12.30           C  
ATOM   1338  CD2 LEU A 157     -36.405  15.752   9.240  1.00 13.01           C  
ATOM   1339  N   PRO A 158     -39.966  15.406  12.883  1.00 10.77           N  
ATOM   1340  CA  PRO A 158     -40.700  14.173  13.183  1.00  9.60           C  
ATOM   1341  C   PRO A 158     -42.216  14.287  13.036  1.00 10.18           C  
ATOM   1342  O   PRO A 158     -42.888  13.335  12.618  1.00 11.16           O  
ATOM   1343  CB  PRO A 158     -40.268  13.852  14.621  1.00  9.74           C  
ATOM   1344  CG  PRO A 158     -38.833  14.367  14.638  1.00 10.66           C  
ATOM   1345  CD  PRO A 158     -38.963  15.699  13.917  1.00 10.53           C  
ATOM   1346  N   PHE A 159     -42.757  15.441  13.415  1.00  9.23           N  
ATOM   1347  CA  PHE A 159     -44.179  15.665  13.297  1.00  8.49           C  
ATOM   1348  C   PHE A 159     -44.600  15.633  11.824  1.00  9.29           C  
ATOM   1349  O   PHE A 159     -45.583  15.002  11.468  1.00  9.13           O  
ATOM   1350  CB  PHE A 159     -44.560  17.026  13.899  1.00  9.85           C  
ATOM   1351  CG  PHE A 159     -46.006  17.373  13.717  1.00 10.17           C  
ATOM   1352  CD1 PHE A 159     -46.976  16.793  14.533  1.00 12.31           C  
ATOM   1353  CD2 PHE A 159     -46.407  18.265  12.730  1.00 11.02           C  
ATOM   1354  CE1 PHE A 159     -48.323  17.094  14.369  1.00 12.54           C  
ATOM   1355  CE2 PHE A 159     -47.766  18.579  12.550  1.00 11.39           C  
ATOM   1356  CZ  PHE A 159     -48.718  17.994  13.372  1.00 12.75           C  
ATOM   1357  N   LEU A 160     -43.853  16.341  10.977  1.00 10.00           N  
ATOM   1358  CA  LEU A 160     -44.203  16.352   9.559  1.00 10.25           C  
ATOM   1359  C   LEU A 160     -44.086  14.960   8.955  1.00  9.30           C  
ATOM   1360  O   LEU A 160     -44.943  14.552   8.163  1.00 10.36           O  
ATOM   1361  CB  LEU A 160     -43.324  17.344   8.764  1.00 13.06           C  
ATOM   1362  CG  LEU A 160     -43.829  18.776   8.929  1.00 13.63           C  
ATOM   1363  CD1 LEU A 160     -43.093  19.414  10.074  1.00 15.12           C  
ATOM   1364  CD2 LEU A 160     -43.653  19.562   7.639  1.00 17.50           C  
ATOM   1365  N   LYS A 161     -43.049  14.215   9.332  1.00  9.46           N  
ATOM   1366  CA  LYS A 161     -42.891  12.874   8.803  1.00 10.56           C  
ATOM   1367  C   LYS A 161     -44.009  11.943   9.213  1.00  9.23           C  
ATOM   1368  O   LYS A 161     -44.451  11.124   8.411  1.00 10.05           O  
ATOM   1369  CB  LYS A 161     -41.528  12.329   9.186  1.00 12.69           C  
ATOM   1370  CG  LYS A 161     -40.491  13.034   8.338  1.00 14.57           C  
ATOM   1371  CD  LYS A 161     -39.110  12.777   8.791  1.00 17.27           C  
ATOM   1372  CE  LYS A 161     -38.786  11.333   8.766  1.00 16.40           C  
ATOM   1373  NZ  LYS A 161     -37.308  11.293   8.984  1.00 11.75           N  
ATOM   1374  N   GLU A 162     -44.487  12.062  10.448  1.00  8.38           N  
ATOM   1375  CA  GLU A 162     -45.603  11.251  10.883  1.00  9.27           C  
ATOM   1376  C   GLU A 162     -46.847  11.571  10.034  1.00  9.20           C  
ATOM   1377  O   GLU A 162     -47.516  10.664   9.557  1.00 10.55           O  
ATOM   1378  CB  GLU A 162     -45.869  11.509  12.375  1.00  8.94           C  
ATOM   1379  CG  GLU A 162     -46.975  10.651  12.952  1.00 10.07           C  
ATOM   1380  CD  GLU A 162     -47.157  10.879  14.445  1.00 13.98           C  
ATOM   1381  OE1 GLU A 162     -46.304  10.401  15.228  1.00 14.88           O  
ATOM   1382  OE2 GLU A 162     -48.131  11.560  14.795  1.00 13.74           O  
ATOM   1383  N   LYS A 163     -47.138  12.856   9.842  1.00  9.71           N  
ATOM   1384  CA  LYS A 163     -48.273  13.254   9.021  1.00 10.37           C  
ATOM   1385  C   LYS A 163     -48.153  12.725   7.597  1.00 10.26           C  
ATOM   1386  O   LYS A 163     -49.107  12.196   7.036  1.00  9.06           O  
ATOM   1387  CB  LYS A 163     -48.379  14.786   8.973  1.00 11.88           C  
ATOM   1388  CG  LYS A 163     -48.548  15.410  10.356  1.00 16.94           C  
ATOM   1389  CD  LYS A 163     -49.947  15.212  10.875  1.00 20.33           C  
ATOM   1390  CE  LYS A 163     -50.820  16.380  10.467  1.00 22.00           C  
ATOM   1391  NZ  LYS A 163     -52.202  16.202  10.985  1.00 20.17           N  
ATOM   1392  N   LEU A 164     -46.977  12.883   7.009  1.00  9.41           N  
ATOM   1393  CA  LEU A 164     -46.768  12.419   5.623  1.00  7.93           C  
ATOM   1394  C   LEU A 164     -46.938  10.905   5.548  1.00  9.80           C  
ATOM   1395  O   LEU A 164     -47.642  10.389   4.686  1.00  9.10           O  
ATOM   1396  CB  LEU A 164     -45.344  12.803   5.150  1.00  9.82           C  
ATOM   1397  CG  LEU A 164     -45.055  12.340   3.729  1.00  9.92           C  
ATOM   1398  CD1 LEU A 164     -45.838  13.184   2.742  1.00 12.09           C  
ATOM   1399  CD2 LEU A 164     -43.579  12.547   3.438  1.00 12.33           C  
ATOM   1400  N   ARG A 165     -46.284  10.187   6.459  1.00  9.69           N  
ATOM   1401  CA  ARG A 165     -46.363   8.727   6.486  1.00 11.63           C  
ATOM   1402  C   ARG A 165     -47.808   8.228   6.536  1.00 11.50           C  
ATOM   1403  O   ARG A 165     -48.201   7.342   5.754  1.00 11.96           O  
ATOM   1404  CB  ARG A 165     -45.586   8.187   7.707  1.00 13.70           C  
ATOM   1405  CG  ARG A 165     -45.635   6.671   7.851  1.00 18.14           C  
ATOM   1406  CD  ARG A 165     -44.888   6.207   9.096  1.00 22.28           C  
ATOM   1407  NE  ARG A 165     -43.840   7.154   9.451  1.00 25.79           N  
ATOM   1408  CZ  ARG A 165     -43.781   7.827  10.599  1.00 23.43           C  
ATOM   1409  NH1 ARG A 165     -44.716   7.659  11.547  1.00 26.56           N  
ATOM   1410  NH2 ARG A 165     -42.798   8.694  10.787  1.00 21.16           N  
ATOM   1411  N   GLU A 166     -48.613   8.787   7.435  1.00 10.07           N  
ATOM   1412  CA  GLU A 166     -49.991   8.325   7.525  1.00 10.18           C  
ATOM   1413  C   GLU A 166     -50.815   8.641   6.301  1.00  9.87           C  
ATOM   1414  O   GLU A 166     -51.622   7.814   5.874  1.00 10.63           O  
ATOM   1415  CB  GLU A 166     -50.642   8.872   8.796  1.00 12.58           C  
ATOM   1416  CG  GLU A 166     -50.135   8.122  10.045  1.00 19.98           C  
ATOM   1417  CD  GLU A 166     -50.232   6.589   9.915  1.00 23.44           C  
ATOM   1418  OE1 GLU A 166     -51.361   6.066   9.725  1.00 26.89           O  
ATOM   1419  OE2 GLU A 166     -49.174   5.905  10.008  1.00 24.71           O  
ATOM   1420  N   GLY A 167     -50.595   9.816   5.722  1.00 10.23           N  
ATOM   1421  CA  GLY A 167     -51.350  10.184   4.537  1.00 10.71           C  
ATOM   1422  C   GLY A 167     -50.966   9.348   3.341  1.00 11.02           C  
ATOM   1423  O   GLY A 167     -51.855   8.963   2.578  1.00 10.58           O  
ATOM   1424  N   LEU A 168     -49.676   9.043   3.172  1.00 11.85           N  
ATOM   1425  CA  LEU A 168     -49.252   8.223   2.040  1.00 11.13           C  
ATOM   1426  C   LEU A 168     -49.738   6.794   2.196  1.00 13.28           C  
ATOM   1427  O   LEU A 168     -50.111   6.161   1.214  1.00 12.70           O  
ATOM   1428  CB  LEU A 168     -47.738   8.263   1.873  1.00 10.29           C  
ATOM   1429  CG  LEU A 168     -47.205   9.647   1.513  1.00 11.27           C  
ATOM   1430  CD1 LEU A 168     -45.726   9.475   1.282  1.00 11.57           C  
ATOM   1431  CD2 LEU A 168     -47.884  10.260   0.273  1.00 12.80           C  
ATOM   1432  N   LYS A 169     -49.755   6.294   3.429  1.00 14.55           N  
ATOM   1433  CA  LYS A 169     -50.251   4.953   3.673  1.00 15.04           C  
ATOM   1434  C   LYS A 169     -51.707   4.889   3.243  1.00 15.01           C  
ATOM   1435  O   LYS A 169     -52.131   3.935   2.585  1.00 15.96           O  
ATOM   1436  CB  LYS A 169     -50.122   4.589   5.162  1.00 17.14           C  
ATOM   1437  CG  LYS A 169     -50.779   3.251   5.523  1.00 22.71           C  
ATOM   1438  CD  LYS A 169     -50.501   2.853   6.976  1.00 26.31           C  
ATOM   1439  CE  LYS A 169     -51.171   1.518   7.315  1.00 29.81           C  
ATOM   1440  NZ  LYS A 169     -50.595   0.891   8.535  1.00 31.77           N  
ATOM   1441  N   LEU A 170     -52.486   5.907   3.600  1.00 14.08           N  
ATOM   1442  CA  LEU A 170     -53.888   5.914   3.228  1.00 16.49           C  
ATOM   1443  C   LEU A 170     -54.037   5.940   1.702  1.00 18.13           C  
ATOM   1444  O   LEU A 170     -54.814   5.168   1.124  1.00 20.53           O  
ATOM   1445  CB  LEU A 170     -54.591   7.110   3.871  1.00 13.83           C  
ATOM   1446  CG  LEU A 170     -56.098   7.270   3.640  1.00 12.43           C  
ATOM   1447  CD1 LEU A 170     -56.646   8.160   4.743  1.00 12.74           C  
ATOM   1448  CD2 LEU A 170     -56.392   7.848   2.267  1.00 14.69           C  
ATOM   1449  N   ILE A 171     -53.259   6.789   1.044  1.00 16.82           N  
ATOM   1450  CA  ILE A 171     -53.320   6.900  -0.413  1.00 18.02           C  
ATOM   1451  C   ILE A 171     -52.900   5.611  -1.126  1.00 19.79           C  
ATOM   1452  O   ILE A 171     -53.631   5.124  -2.016  1.00 23.34           O  
ATOM   1453  CB  ILE A 171     -52.450   8.113  -0.887  1.00 15.24           C  
ATOM   1454  CG1 ILE A 171     -53.067   9.437  -0.402  1.00 15.88           C  
ATOM   1455  CG2 ILE A 171     -52.315   8.100  -2.426  1.00 16.05           C  
ATOM   1456  CD1 ILE A 171     -52.164  10.685  -0.512  1.00 15.67           C  
ATOM   1457  N   PHE A 172     -51.762   5.033  -0.757  1.00 20.26           N  
ATOM   1458  CA  PHE A 172     -51.261   3.815  -1.420  1.00 21.24           C  
ATOM   1459  C   PHE A 172     -51.787   2.463  -0.928  1.00 23.86           C  
ATOM   1460  O   PHE A 172     -52.153   2.329   0.265  1.00 26.02           O  
ATOM   1461  CB  PHE A 172     -49.740   3.793  -1.364  1.00 18.70           C  
ATOM   1462  CG  PHE A 172     -49.093   4.804  -2.244  1.00 15.76           C  
ATOM   1463  CD1 PHE A 172     -49.120   4.646  -3.627  1.00 17.17           C  
ATOM   1464  CD2 PHE A 172     -48.462   5.911  -1.707  1.00 15.81           C  
ATOM   1465  CE1 PHE A 172     -48.522   5.596  -4.470  1.00 16.76           C  
ATOM   1466  CE2 PHE A 172     -47.858   6.871  -2.555  1.00 15.83           C  
ATOM   1467  CZ  PHE A 172     -47.900   6.703  -3.935  1.00 14.31           C  
TER    1468      PHE A 172                                                      
END
MOLECULE T0454.pdb
ATOM      1  N   ASP     5     -12.420  32.658   0.024  1.00 27.13           N
ATOM      2  CA  ASP     5     -13.312  32.598   1.217  1.00 27.34           C
ATOM      3  CB  ASP     5     -12.512  32.690   2.520  1.00 28.50           C
ATOM      4  CG  ASP     5     -13.404  32.599   3.759  1.00 30.42           C
ATOM      5  OD1 ASP     5     -14.289  31.706   3.803  1.00 33.47           O
ATOM      6  OD2 ASP     5     -13.226  33.430   4.680  1.00 32.05           O
ATOM      7  C   ASP     5     -14.424  33.644   1.238  1.00 26.73           C
ATOM      8  O   ASP     5     -15.477  33.398   1.835  1.00 26.63           O
ATOM      9  N   CYS     6     -14.211  34.799   0.611  0.50 26.41           N
ATOM     11  CA  CYS     6     -15.286  35.794   0.531  0.50 26.28           C
ATOM     13  CB  CYS     6     -14.751  37.198   0.241  0.50 26.57           C
ATOM     15  SG  CYS     6     -14.050  37.968   1.731  0.50 29.41           S
ATOM     17  C   CYS     6     -16.388  35.363  -0.439  0.50 25.38           C
ATOM     19  O   CYS     6     -17.496  35.901  -0.414  0.50 25.34           O
ATOM     21  N   ARG     7     -16.080  34.368  -1.271  1.00 24.45           N
ATOM     22  CA  ARG     7     -17.093  33.680  -2.080  1.00 22.28           C
ATOM     23  CB  ARG     7     -16.421  32.728  -3.079  1.00 22.90           C
ATOM     30  C   ARG     7     -18.066  32.903  -1.186  1.00 20.46           C
ATOM     31  O   ARG     7     -19.262  32.867  -1.449  1.00 20.43           O
ATOM     32  N   SER     8     -17.547  32.253  -0.148  0.50 19.10           N
ATOM     34  CA  SER     8     -18.391  31.436   0.731  0.50 17.33           C
ATOM     36  CB  SER     8     -17.550  30.493   1.586  0.50 17.45           C
ATOM     38  OG  SER     8     -18.312  29.968   2.658  0.50 15.65           O
ATOM     40  C   SER     8     -19.258  32.322   1.613  0.50 16.60           C
ATOM     42  O   SER     8     -20.455  32.084   1.776  0.50 15.91           O
ATOM     44  N   ARG     9     -18.645  33.365   2.159  0.50 15.61           N
ATOM     46  CA  ARG     9     -19.363  34.297   3.022  0.50 14.83           C
ATOM     48  CB  ARG     9     -18.372  35.205   3.766  0.50 15.25           C
ATOM     50  CG  ARG     9     -17.394  34.394   4.628  0.50 14.59           C
ATOM     52  CD  ARG     9     -16.768  35.163   5.795  0.50 16.76           C
ATOM     54  NE  ARG     9     -15.709  36.081   5.358  0.50 18.23           N
ATOM     56  CZ  ARG     9     -15.907  37.364   5.046  0.50 17.11           C
ATOM     58  NH1 ARG     9     -14.883  38.115   4.657  0.50 16.37           N
ATOM     60  NH2 ARG     9     -17.129  37.896   5.121  0.50 17.10           N
ATOM     62  C   ARG     9     -20.452  35.089   2.282  0.50 14.49           C
ATOM     64  O   ARG     9     -21.506  35.370   2.850  0.50 13.18           O
ATOM     66  N   LEU    10     -20.187  35.432   1.021  1.00 14.14           N
ATOM     67  CA  LEU    10     -21.183  36.018   0.143  1.00 15.70           C
ATOM     68  CB  LEU    10     -20.580  36.459  -1.201  1.00 16.55           C
ATOM     69  CG  LEU    10     -20.226  37.923  -1.321  1.00 18.07           C
ATOM     70  CD1 LEU    10     -19.435  38.165  -2.626  1.00 18.10           C
ATOM     71  CD2 LEU    10     -21.495  38.769  -1.285  1.00 16.77           C
ATOM     72  C   LEU    10     -22.364  35.072  -0.083  1.00 15.96           C
ATOM     73  O   LEU    10     -23.511  35.520  -0.035  1.00 16.63           O
ATOM     74  N   MET    11     -22.097  33.792  -0.326  0.70 16.06           N
ATOM     76  CA  MET    11     -23.179  32.843  -0.534  0.70 17.38           C
ATOM     78  CB  MET    11     -22.637  31.461  -0.863  0.70 20.17           C
ATOM     80  CG  MET    11     -22.166  31.316  -2.273  0.70 25.34           C
ATOM     82  SD  MET    11     -23.611  30.818  -3.503  0.70 46.93          SE
ATOM     84  CE  MET    11     -22.374  30.088  -4.856  0.70 32.85           C
ATOM     86  C   MET    11     -24.065  32.759   0.707  0.70 15.90           C
ATOM     88  O   MET    11     -25.298  32.724   0.592  0.70 14.79           O
ATOM     90  N   GLU    12     -23.436  32.726   1.888  1.00 13.16           N
ATOM     91  CA  GLU    12     -24.186  32.691   3.141  1.00 12.28           C
ATOM     92  CB  GLU    12     -23.255  32.550   4.367  1.00 11.62           C
ATOM     93  CG  GLU    12     -24.006  32.676   5.679  1.00 12.98           C
ATOM     94  CD  GLU    12     -24.899  31.451   5.972  1.00 17.78           C
ATOM     95  OE1 GLU    12     -24.548  30.339   5.520  1.00 20.61           O
ATOM     96  OE2 GLU    12     -25.952  31.593   6.636  1.00 18.33           O
ATOM     97  C   GLU    12     -25.062  33.946   3.278  1.00 11.77           C
ATOM     98  O   GLU    12     -26.263  33.868   3.569  1.00 10.95           O
ATOM     99  N   VAL    13     -24.441  35.104   3.102  1.00 11.38           N
ATOM    100  CA  VAL    13     -25.143  36.347   3.297  1.00 11.79           C
ATOM    101  CB  VAL    13     -24.168  37.555   3.216  1.00 11.85           C
ATOM    102  CG1 VAL    13     -24.903  38.816   2.771  1.00 13.25           C
ATOM    103  CG2 VAL    13     -23.437  37.739   4.528  1.00 12.09           C
ATOM    104  C   VAL    13     -26.264  36.469   2.270  1.00 12.08           C
ATOM    105  O   VAL    13     -27.360  36.860   2.613  1.00 12.20           O
ATOM    106  N   ALA    14     -25.987  36.132   1.016  1.00 11.94           N
ATOM    107  CA  ALA    14     -27.028  36.192  -0.026  1.00 12.57           C
ATOM    108  CB  ALA    14     -26.434  35.847  -1.397  1.00 12.81           C
ATOM    109  C   ALA    14     -28.224  35.272   0.324  1.00 12.70           C
ATOM    110  O   ALA    14     -29.404  35.681   0.225  1.00 12.49           O
ATOM    111  N   THR    15     -27.933  34.045   0.752  1.00 12.08           N
ATOM    112  CA  THR    15     -29.000  33.092   1.088  1.00 13.57           C
ATOM    113  CB  THR    15     -28.420  31.727   1.526  1.00 13.02           C
ATOM    114  OG1 THR    15     -27.592  31.204   0.477  1.00 13.54           O
ATOM    115  CG2 THR    15     -29.544  30.705   1.864  1.00 14.11           C
ATOM    116  C   THR    15     -29.885  33.685   2.197  1.00 13.81           C
ATOM    117  O   THR    15     -31.100  33.676   2.080  1.00 14.69           O
ATOM    118  N   GLU    16     -29.283  34.229   3.251  0.50 12.86           N
ATOM    120  CA  GLU    16     -30.060  34.743   4.392  0.50 12.65           C
ATOM    122  CB  GLU    16     -29.168  34.850   5.619  0.50 11.98           C
ATOM    124  CG  GLU    16     -28.366  33.560   5.847  0.50 10.56           C
ATOM    126  CD  GLU    16     -29.193  32.437   6.436  0.50 10.50           C
ATOM    128  OE1 GLU    16     -29.690  32.653   7.554  0.50 13.56           O
ATOM    130  OE2 GLU    16     -29.343  31.334   5.814  0.50  9.37           O
ATOM    132  C   GLU    16     -30.844  36.053   4.135  0.50 13.06           C
ATOM    134  O   GLU    16     -31.941  36.247   4.680  0.50 12.44           O
ATOM    136  N   LEU    17     -30.289  36.937   3.304  1.00 13.39           N
ATOM    137  CA  LEU    17     -30.999  38.157   2.904  1.00 13.60           C
ATOM    138  CB  LEU    17     -30.022  39.257   2.439  1.00 13.92           C
ATOM    139  CG  LEU    17     -29.168  39.859   3.564  1.00 15.45           C
ATOM    140  CD1 LEU    17     -28.242  40.964   3.019  1.00 18.76           C
ATOM    141  CD2 LEU    17     -30.008  40.355   4.753  1.00 18.21           C
ATOM    142  C   LEU    17     -32.079  37.907   1.841  1.00 13.42           C
ATOM    143  O   LEU    17     -33.201  38.400   2.004  1.00 13.35           O
ATOM    144  N   PHE    18     -31.772  37.132   0.800  1.00 12.52           N
ATOM    145  CA  PHE    18     -32.789  36.767  -0.188  1.00 12.55           C
ATOM    146  CB  PHE    18     -32.168  36.032  -1.355  1.00 12.74           C
ATOM    147  CG  PHE    18     -31.341  36.895  -2.267  1.00 11.67           C
ATOM    148  CD1 PHE    18     -31.865  38.079  -2.813  1.00 12.22           C
ATOM    149  CE1 PHE    18     -31.138  38.864  -3.706  1.00 12.93           C
ATOM    150  CZ  PHE    18     -29.843  38.455  -4.104  1.00 13.62           C
ATOM    151  CE2 PHE    18     -29.308  37.240  -3.582  1.00 11.19           C
ATOM    152  CD2 PHE    18     -30.083  36.472  -2.677  1.00 11.90           C
ATOM    153  C   PHE    18     -33.889  35.866   0.419  1.00 13.51           C
ATOM    154  O   PHE    18     -35.054  35.962   0.015  1.00 15.25           O
ATOM    155  N   ALA    19     -33.532  34.996   1.373  1.00 13.39           N
ATOM    156  CA  ALA    19     -34.553  34.208   2.061  1.00 15.05           C
ATOM    157  CB  ALA    19     -33.942  33.133   2.992  1.00 14.27           C
ATOM    158  C   ALA    19     -35.536  35.094   2.817  1.00 15.36           C
ATOM    159  O   ALA    19     -36.754  34.842   2.737  1.00 16.78           O
ATOM    160  N   GLN    20     -35.009  36.097   3.541  0.70 16.27           N
ATOM    162  CA  GLN    20     -35.806  37.053   4.335  0.70 16.80           C
ATOM    164  CB  GLN    20     -34.946  37.989   5.239  0.70 17.01           C
ATOM    166  CG  GLN    20     -35.745  39.306   5.640  0.70 16.81           C
ATOM    168  CD  GLN    20     -35.206  40.143   6.812  0.70 17.74           C
ATOM    170  OE1 GLN    20     -35.154  41.393   6.736  0.70 13.85           O
ATOM    172  NE2 GLN    20     -34.830  39.472   7.903  0.70 18.70           N
ATOM    174  C   GLN    20     -36.691  37.941   3.482  0.70 17.07           C
ATOM    176  O   GLN    20     -37.900  38.009   3.701  0.70 17.23           O
ATOM    178  N   LYS    21     -36.060  38.636   2.537  1.00 15.44           N
ATOM    179  CA  LYS    21     -36.656  39.778   1.820  1.00 16.20           C
ATOM    180  CB  LYS    21     -35.693  40.954   1.797  1.00 16.65           C
ATOM    181  CG  LYS    21     -35.259  41.391   3.184  1.00 19.64           C
ATOM    182  CD  LYS    21     -34.363  42.583   3.043  1.00 22.59           C
ATOM    183  CE  LYS    21     -33.720  42.901   4.359  1.00 25.71           C
ATOM    184  NZ  LYS    21     -33.292  44.316   4.378  1.00 29.79           N
ATOM    185  C   LYS    21     -37.021  39.482   0.389  1.00 15.03           C
ATOM    186  O   LYS    21     -37.639  40.317  -0.275  1.00 16.30           O
ATOM    187  N   GLY    22     -36.632  38.313  -0.101  1.00 14.81           N
ATOM    188  CA  GLY    22     -36.879  37.954  -1.501  1.00 12.41           C
ATOM    189  C   GLY    22     -35.967  38.743  -2.431  1.00 13.23           C
ATOM    190  O   GLY    22     -35.355  39.762  -2.034  1.00 13.65           O
ATOM    191  N   PHE    23     -35.857  38.255  -3.660  1.00 12.90           N
ATOM    192  CA  PHE    23     -35.064  38.952  -4.675  1.00 13.24           C
ATOM    193  CB  PHE    23     -35.255  38.297  -6.043  1.00 15.31           C
ATOM    194  CG  PHE    23     -34.544  39.016  -7.130  1.00 16.26           C
ATOM    195  CD1 PHE    23     -33.214  38.729  -7.414  1.00 17.28           C
ATOM    196  CE1 PHE    23     -32.528  39.446  -8.406  1.00 17.88           C
ATOM    197  CZ  PHE    23     -33.173  40.390  -9.137  1.00 18.69           C
ATOM    198  CE2 PHE    23     -34.531  40.677  -8.884  1.00 18.23           C
ATOM    199  CD2 PHE    23     -35.193  40.000  -7.883  1.00 18.32           C
ATOM    200  C   PHE    23     -35.468  40.425  -4.758  1.00 14.16           C
ATOM    201  O   PHE    23     -34.604  41.312  -4.880  1.00 14.45           O
ATOM    202  N   TYR    24     -36.778  40.690  -4.743  1.00 14.52           N
ATOM    203  CA  TYR    24     -37.263  42.057  -4.998  1.00 15.59           C
ATOM    204  CB  TYR    24     -38.733  42.085  -5.422  1.00 13.51           C
ATOM    205  CG  TYR    24     -38.963  41.406  -6.781  1.00 13.47           C
ATOM    206  CD1 TYR    24     -38.665  42.064  -7.967  1.00 12.55           C
ATOM    207  CE1 TYR    24     -38.890  41.458  -9.241  1.00 13.28           C
ATOM    208  CZ  TYR    24     -39.399  40.139  -9.303  1.00 10.43           C
ATOM    209  OH  TYR    24     -39.630  39.577 -10.572  1.00 11.31           O
ATOM    210  CE2 TYR    24     -39.713  39.475  -8.126  1.00 11.68           C
ATOM    211  CD2 TYR    24     -39.493  40.106  -6.858  1.00 14.21           C
ATOM    212  C   TYR    24     -37.080  42.970  -3.806  1.00 16.80           C
ATOM    213  O   TYR    24     -37.286  44.167  -3.939  1.00 18.89           O
ATOM    214  N   GLY    25     -36.702  42.429  -2.656  1.00 16.86           N
ATOM    215  CA  GLY    25     -36.488  43.287  -1.478  1.00 17.30           C
ATOM    216  C   GLY    25     -35.036  43.519  -1.070  1.00 18.19           C
ATOM    217  O   GLY    25     -34.787  44.141  -0.042  1.00 18.97           O
ATOM    218  N   VAL    26     -34.080  42.983  -1.822  1.00 17.80           N
ATOM    219  CA  VAL    26     -32.653  43.017  -1.434  1.00 17.86           C
ATOM    220  CB  VAL    26     -32.053  41.567  -1.526  1.00 16.88           C
ATOM    221  CG1 VAL    26     -30.493  41.578  -1.523  1.00 19.19           C
ATOM    222  CG2 VAL    26     -32.546  40.691  -0.382  1.00 17.09           C
ATOM    223  C   VAL    26     -31.896  43.951  -2.405  1.00 18.57           C
ATOM    224  O   VAL    26     -32.112  43.860  -3.619  1.00 19.26           O
ATOM    225  N   SER    27     -31.024  44.837  -1.900  1.00 18.29           N
ATOM    226  CA  SER    27     -30.188  45.651  -2.802  1.00 18.73           C
ATOM    227  CB  SER    27     -30.240  47.135  -2.451  1.00 18.20           C
ATOM    228  OG  SER    27     -29.499  47.385  -1.297  1.00 19.53           O
ATOM    229  C   SER    27     -28.743  45.196  -2.781  1.00 18.39           C
ATOM    230  O   SER    27     -28.296  44.592  -1.823  1.00 18.07           O
ATOM    231  N   ILE    28     -28.001  45.507  -3.836  1.00 18.31           N
ATOM    232  CA  ILE    28     -26.587  45.151  -3.866  1.00 18.54           C
ATOM    233  CB  ILE    28     -25.953  45.425  -5.232  1.00 18.62           C
ATOM    234  CG1 ILE    28     -24.599  44.703  -5.348  1.00 18.14           C
ATOM    235  CD1 ILE    28     -23.953  44.785  -6.743  1.00 19.13           C
ATOM    236  CG2 ILE    28     -25.915  46.963  -5.537  1.00 18.10           C
ATOM    237  C   ILE    28     -25.825  45.846  -2.714  1.00 18.97           C
ATOM    238  O   ILE    28     -24.902  45.274  -2.156  1.00 17.66           O
ATOM    239  N   ARG    29     -26.211  47.076  -2.360  1.00 19.97           N
ATOM    240  CA  ARG    29     -25.589  47.737  -1.207  1.00 22.13           C
ATOM    241  CB  ARG    29     -26.120  49.174  -1.012  1.00 21.53           C
ATOM    242  CG  ARG    29     -25.467  49.925   0.170  1.00 25.16           C
ATOM    243  CD  ARG    29     -26.316  51.109   0.743  1.00 26.22           C
ATOM    244  NE  ARG    29     -27.682  50.707   1.142  1.00 35.15           N
ATOM    245  CZ  ARG    29     -28.010  50.032   2.256  1.00 36.75           C
ATOM    246  NH1 ARG    29     -27.084  49.650   3.137  1.00 38.29           N
ATOM    247  NH2 ARG    29     -29.285  49.730   2.492  1.00 38.04           N
ATOM    248  C   ARG    29     -25.725  46.902   0.085  1.00 21.09           C
ATOM    249  O   ARG    29     -24.730  46.691   0.798  1.00 19.92           O
ATOM    250  N   GLU    30     -26.937  46.412   0.371  1.00 22.16           N
ATOM    251  CA  GLU    30     -27.160  45.541   1.551  1.00 22.56           C
ATOM    252  CB  GLU    30     -28.618  45.119   1.693  1.00 23.46           C
ATOM    253  CG  GLU    30     -29.623  46.242   1.841  1.00 28.08           C
ATOM    254  CD  GLU    30     -31.046  45.786   1.483  1.00 34.28           C
ATOM    255  OE1 GLU    30     -31.275  44.555   1.368  1.00 33.74           O
ATOM    256  OE2 GLU    30     -31.935  46.662   1.307  1.00 37.15           O
ATOM    257  C   GLU    30     -26.301  44.272   1.533  1.00 21.44           C
ATOM    258  O   GLU    30     -25.795  43.856   2.577  1.00 21.23           O
ATOM    259  N   LEU    31     -26.170  43.640   0.359  1.00 19.98           N
ATOM    260  CA  LEU    31     -25.338  42.431   0.251  1.00 18.96           C
ATOM    261  CB  LEU    31     -25.426  41.823  -1.145  1.00 18.00           C
ATOM    262  CG  LEU    31     -26.768  41.239  -1.562  1.00 18.12           C
ATOM    263  CD1 LEU    31     -26.678  40.931  -3.057  1.00 16.01           C
ATOM    264  CD2 LEU    31     -27.078  39.993  -0.744  1.00 18.33           C
ATOM    265  C   LEU    31     -23.871  42.715   0.588  1.00 18.24           C
ATOM    266  O   LEU    31     -23.227  41.984   1.363  1.00 18.55           O
ATOM    267  N   ALA    32     -23.328  43.776  -0.005  1.00 18.07           N
ATOM    268  CA  ALA    32     -21.928  44.131   0.234  1.00 17.87           C
ATOM    269  CB  ALA    32     -21.533  45.282  -0.659  1.00 17.05           C
ATOM    270  C   ALA    32     -21.689  44.449   1.719  1.00 18.48           C
ATOM    271  O   ALA    32     -20.741  43.938   2.338  1.00 18.50           O
ATOM    272  N   GLN    33     -22.577  45.264   2.282  1.00 18.14           N
ATOM    273  CA  GLN    33     -22.467  45.687   3.672  1.00 18.66           C
ATOM    274  CB  GLN    33     -23.613  46.652   4.012  1.00 18.81           C
ATOM    279  C   GLN    33     -22.496  44.452   4.579  1.00 18.25           C
ATOM    280  O   GLN    33     -21.649  44.307   5.470  1.00 19.06           O
ATOM    281  N   ALA    34     -23.456  43.552   4.355  1.00 18.35           N
ATOM    282  CA  ALA    34     -23.588  42.387   5.224  1.00 17.57           C
ATOM    283  CB  ALA    34     -24.915  41.670   4.988  1.00 18.88           C
ATOM    284  C   ALA    34     -22.400  41.424   5.094  1.00 17.93           C
ATOM    285  O   ALA    34     -22.007  40.800   6.073  1.00 18.07           O
ATOM    286  N   ALA    35     -21.812  41.324   3.902  1.00 17.59           N
ATOM    287  CA  ALA    35     -20.653  40.434   3.662  1.00 17.45           C
ATOM    288  CB  ALA    35     -20.742  39.832   2.241  1.00 17.60           C
ATOM    289  C   ALA    35     -19.271  41.084   3.858  1.00 17.39           C
ATOM    290  O   ALA    35     -18.253  40.386   3.869  1.00 17.10           O
ATOM    291  N   GLY    36     -19.216  42.410   3.975  1.00 17.53           N
ATOM    292  CA  GLY    36     -17.934  43.120   4.053  1.00 17.54           C
ATOM    293  C   GLY    36     -17.142  43.046   2.755  1.00 18.20           C
ATOM    294  O   GLY    36     -15.894  43.109   2.760  1.00 18.83           O
ATOM    295  N   ALA    37     -17.868  42.917   1.638  1.00 18.05           N
ATOM    296  CA  ALA    37     -17.298  42.947   0.287  1.00 17.70           C
ATOM    297  CB  ALA    37     -17.905  41.813  -0.553  1.00 17.69           C
ATOM    298  C   ALA    37     -17.594  44.299  -0.377  1.00 17.25           C
ATOM    299  O   ALA    37     -18.512  44.995   0.029  1.00 17.90           O
ATOM    300  N   SER    38     -16.844  44.680  -1.401  1.00 16.01           N
ATOM    301  CA  SER    38     -17.181  45.941  -2.083  1.00 15.66           C
ATOM    302  CB  SER    38     -15.986  46.530  -2.815  1.00 15.99           C
ATOM    303  OG  SER    38     -15.465  45.574  -3.709  1.00 15.63           O
ATOM    304  C   SER    38     -18.275  45.670  -3.090  1.00 15.23           C
ATOM    305  O   SER    38     -18.390  44.545  -3.568  1.00 14.69           O
ATOM    306  N   ILE    39     -19.054  46.696  -3.426  1.00 14.99           N
ATOM    307  CA  ILE    39     -20.019  46.586  -4.524  1.00 16.34           C
ATOM    308  CB  ILE    39     -20.795  47.908  -4.725  1.00 18.03           C
ATOM    309  CG1 ILE    39     -21.771  48.099  -3.551  1.00 18.95           C
ATOM    310  CD1 ILE    39     -22.260  49.551  -3.403  1.00 24.07           C
ATOM    311  CG2 ILE    39     -21.568  47.905  -6.053  1.00 19.22           C
ATOM    312  C   ILE    39     -19.321  46.142  -5.820  1.00 14.71           C
ATOM    313  O   ILE    39     -19.846  45.293  -6.544  1.00 14.07           O
ATOM    314  N   SER    40     -18.089  46.604  -6.010  0.50 14.67           N
ATOM    316  CA  SER    40     -17.279  46.176  -7.148  0.50 14.62           C
ATOM    318  CB  SER    40     -16.053  47.060  -7.335  0.50 14.94           C
ATOM    320  OG  SER    40     -16.458  48.367  -7.690  0.50 15.23           O
ATOM    322  C   SER    40     -16.894  44.691  -7.144  0.50 14.74           C
ATOM    324  O   SER    40     -17.018  44.048  -8.190  0.50 13.11           O
ATOM    326  N   MET    41     -16.429  44.140  -6.011  0.70 14.50           N
ATOM    328  CA  MET    41     -16.178  42.699  -5.979  0.70 17.69           C
ATOM    330  CB  MET    41     -15.783  42.221  -4.589  0.70 17.10           C
ATOM    332  CG  MET    41     -14.312  42.342  -4.347  0.70 22.14           C
ATOM    334  SD  MET    41     -13.942  42.349  -2.431  0.70 31.19          SE
ATOM    336  CE  MET    41     -12.415  43.576  -2.469  0.70 24.49           C
ATOM    338  C   MET    41     -17.447  41.995  -6.467  0.70 13.85           C
ATOM    340  O   MET    41     -17.391  41.116  -7.335  0.70 12.19           O
ATOM    342  N   ILE    42     -18.586  42.445  -5.946  1.00 11.54           N
ATOM    343  CA  ILE    42     -19.860  41.745  -6.191  1.00 10.80           C
ATOM    344  CB  ILE    42     -21.001  42.280  -5.316  1.00 11.27           C
ATOM    345  CG1 ILE    42     -20.695  41.978  -3.842  1.00 13.93           C
ATOM    346  CD1 ILE    42     -21.839  42.300  -2.903  1.00 16.88           C
ATOM    347  CG2 ILE    42     -22.327  41.616  -5.716  1.00 12.87           C
ATOM    348  C   ILE    42     -20.219  41.838  -7.658  1.00  8.83           C
ATOM    349  O   ILE    42     -20.497  40.819  -8.306  1.00  9.33           O
ATOM    350  N   SER    43     -20.157  43.052  -8.211  1.00  8.95           N
ATOM    351  CA  SER    43     -20.581  43.239  -9.602  1.00  9.74           C
ATOM    352  CB  SER    43     -20.655  44.729  -9.931  1.00 10.68           C
ATOM    353  OG  SER    43     -21.770  45.278  -9.279  1.00 13.08           O
ATOM    354  C   SER    43     -19.645  42.587 -10.619  1.00  9.62           C
ATOM    355  O   SER    43     -20.105  42.053 -11.624  1.00  9.13           O
ATOM    356  N   TYR    44     -18.328  42.697 -10.382  1.00  9.20           N
ATOM    357  CA  TYR    44     -17.361  42.244 -11.376  1.00 10.08           C
ATOM    358  CB  TYR    44     -16.121  43.137 -11.344  1.00  9.76           C
ATOM    359  CG  TYR    44     -16.373  44.487 -11.942  1.00  8.65           C
ATOM    360  CD1 TYR    44     -16.965  45.500 -11.184  1.00  8.93           C
ATOM    361  CE1 TYR    44     -17.202  46.730 -11.711  1.00 10.45           C
ATOM    362  CZ  TYR    44     -16.853  46.987 -13.027  1.00 10.79           C
ATOM    363  OH  TYR    44     -17.090  48.220 -13.553  1.00 11.57           O
ATOM    364  CE2 TYR    44     -16.260  46.002 -13.818  1.00 10.86           C
ATOM    365  CD2 TYR    44     -16.019  44.758 -13.255  1.00  9.35           C
ATOM    366  C   TYR    44     -16.923  40.795 -11.222  1.00 12.28           C
ATOM    367  O   TYR    44     -16.468  40.193 -12.203  1.00 12.21           O
ATOM    368  N   HIS    45     -16.993  40.271 -10.000  1.00 14.53           N
ATOM    369  CA  HIS    45     -16.489  38.928  -9.730  1.00 17.90           C
ATOM    370  CB  HIS    45     -15.347  38.951  -8.714  1.00 18.81           C
ATOM    371  CG  HIS    45     -14.062  39.424  -9.294  1.00 21.69           C
ATOM    372  ND1 HIS    45     -13.118  40.111  -8.564  1.00 26.38           N
ATOM    373  CE1 HIS    45     -12.092  40.405  -9.346  1.00 27.60           C
ATOM    374  NE2 HIS    45     -12.350  39.958 -10.563  1.00 26.67           N
ATOM    375  CD2 HIS    45     -13.574  39.339 -10.558  1.00 25.29           C
ATOM    376  C   HIS    45     -17.532  37.898  -9.348  1.00 19.42           C
ATOM    377  O   HIS    45     -17.334  36.722  -9.630  1.00 19.75           O
ATOM    378  N   PHE    46     -18.630  38.324  -8.726  1.00 20.52           N
ATOM    379  CA  PHE    46     -19.661  37.377  -8.261  1.00 22.82           C
ATOM    380  CB  PHE    46     -19.800  37.465  -6.732  1.00 23.98           C
ATOM    381  CG  PHE    46     -18.496  37.308  -6.003  1.00 26.04           C
ATOM    382  CD1 PHE    46     -18.012  36.039  -5.670  1.00 29.01           C
ATOM    383  CE1 PHE    46     -16.817  35.893  -5.005  1.00 27.12           C
ATOM    384  CZ  PHE    46     -16.071  37.013  -4.649  1.00 28.27           C
ATOM    385  CE2 PHE    46     -16.542  38.280  -4.963  1.00 29.34           C
ATOM    386  CD2 PHE    46     -17.743  38.419  -5.640  1.00 27.17           C
ATOM    387  C   PHE    46     -21.004  37.504  -8.954  1.00 22.70           C
ATOM    388  O   PHE    46     -22.017  36.978  -8.483  1.00 25.73           O
ATOM    389  N   GLY    47     -21.020  38.197 -10.083  1.00 20.71           N
ATOM    390  CA  GLY    47     -22.178  38.260 -10.943  1.00 19.73           C
ATOM    391  C   GLY    47     -23.257  39.227 -10.550  1.00 18.52           C
ATOM    392  O   GLY    47     -24.373  39.148 -11.073  1.00 20.99           O
ATOM    393  N   GLY    48     -22.955  40.137  -9.620  1.00 14.66           N
ATOM    394  CA  GLY    48     -23.926  41.115  -9.145  1.00 14.41           C
ATOM    395  C   GLY    48     -25.035  40.479  -8.295  1.00 13.29           C
ATOM    396  O   GLY    48     -24.959  39.296  -7.948  1.00 12.06           O
ATOM    397  N   LYS    49     -26.021  41.290  -7.929  1.00 13.51           N
ATOM    398  CA  LYS    49     -27.206  40.794  -7.200  1.00 13.00           C
ATOM    399  CB  LYS    49     -28.212  41.934  -7.086  1.00 14.01           C
ATOM    400  CG  LYS    49     -29.503  41.518  -6.350  1.00 15.37           C
ATOM    401  CD  LYS    49     -30.528  42.649  -6.447  1.00 16.73           C
ATOM    402  CE  LYS    49     -31.905  42.078  -6.083  1.00 17.71           C
ATOM    403  NZ  LYS    49     -32.895  43.218  -6.101  1.00 18.77           N
ATOM    404  C   LYS    49     -27.809  39.595  -7.932  1.00 13.68           C
ATOM    405  O   LYS    49     -28.212  38.583  -7.331  1.00 13.27           O
ATOM    406  N   GLU    50     -27.876  39.703  -9.258  1.00 12.63           N
ATOM    407  CA  GLU    50     -28.627  38.725 -10.042  1.00 12.69           C
ATOM    408  CB  GLU    50     -28.814  39.232 -11.468  1.00 13.68           C
ATOM    409  CG  GLU    50     -29.657  40.500 -11.528  1.00 14.16           C
ATOM    410  CD  GLU    50     -28.887  41.815 -11.286  1.00 16.98           C
ATOM    411  OE1 GLU    50     -27.638  41.867 -11.018  1.00 15.01           O
ATOM    412  OE2 GLU    50     -29.566  42.854 -11.451  1.00 19.39           O
ATOM    413  C   GLU    50     -27.883  37.393 -10.048  1.00 12.35           C
ATOM    414  O   GLU    50     -28.506  36.350  -9.816  1.00 13.25           O
ATOM    415  N   GLY    51     -26.567  37.455 -10.306  1.00 11.97           N
ATOM    416  CA  GLY    51     -25.695  36.286 -10.303  1.00 11.39           C
ATOM    417  C   GLY    51     -25.724  35.592  -8.952  1.00 13.31           C
ATOM    418  O   GLY    51     -25.865  34.369  -8.874  1.00 12.68           O
ATOM    419  N   LEU    52     -25.637  36.365  -7.877  1.00 12.96           N
ATOM    420  CA  LEU    52     -25.702  35.752  -6.544  1.00 13.84           C
ATOM    421  CB  LEU    52     -25.453  36.774  -5.450  1.00 13.00           C
ATOM    422  CG  LEU    52     -24.017  37.257  -5.300  1.00 15.32           C
ATOM    423  CD1 LEU    52     -24.026  38.415  -4.321  1.00 17.15           C
ATOM    424  CD2 LEU    52     -23.089  36.110  -4.862  1.00 13.25           C
ATOM    425  C   LEU    52     -27.047  35.092  -6.282  1.00 13.75           C
ATOM    426  O   LEU    52     -27.092  34.016  -5.680  1.00 14.21           O
ATOM    427  N   TYR    53     -28.140  35.744  -6.693  1.00 14.29           N
ATOM    428  CA  TYR    53     -29.441  35.176  -6.517  1.00 14.44           C
ATOM    429  CB  TYR    53     -30.541  36.161  -6.936  1.00 12.90           C
ATOM    430  CG  TYR    53     -31.928  35.606  -6.681  1.00 13.47           C
ATOM    431  CD1 TYR    53     -32.405  35.437  -5.365  1.00 13.59           C
ATOM    432  CE1 TYR    53     -33.679  34.910  -5.123  1.00 14.34           C
ATOM    433  CZ  TYR    53     -34.477  34.537  -6.198  1.00 13.72           C
ATOM    434  OH  TYR    53     -35.718  34.039  -5.965  1.00 13.83           O
ATOM    435  CE2 TYR    53     -34.023  34.711  -7.525  1.00 13.18           C
ATOM    436  CD2 TYR    53     -32.751  35.220  -7.740  1.00 11.75           C
ATOM    437  C   TYR    53     -29.578  33.863  -7.306  1.00 14.35           C
ATOM    438  O   TYR    53     -30.064  32.892  -6.754  1.00 14.84           O
ATOM    439  N   ALA    54     -29.125  33.849  -8.569  1.00 14.57           N
ATOM    440  CA  ALA    54     -29.145  32.612  -9.394  1.00 14.76           C
ATOM    441  CB  ALA    54     -28.572  32.882 -10.785  1.00 15.38           C
ATOM    442  C   ALA    54     -28.382  31.465  -8.737  1.00 16.02           C
ATOM    443  O   ALA    54     -28.853  30.302  -8.752  1.00 16.58           O
ATOM    444  N   ALA    55     -27.206  31.790  -8.179  1.00 15.71           N
ATOM    445  CA  ALA    55     -26.349  30.797  -7.512  1.00 16.60           C
ATOM    446  CB  ALA    55     -24.985  31.418  -7.114  1.00 15.94           C
ATOM    447  C   ALA    55     -27.087  30.239  -6.293  1.00 16.62           C
ATOM    448  O   ALA    55     -27.124  29.027  -6.079  1.00 17.79           O
ATOM    449  N   VAL    56     -27.698  31.121  -5.509  1.00 16.55           N
ATOM    450  CA  VAL    56     -28.442  30.724  -4.309  1.00 17.16           C
ATOM    451  CB  VAL    56     -28.958  31.984  -3.551  1.00 17.77           C
ATOM    452  CG1 VAL    56     -30.068  31.623  -2.591  1.00 18.51           C
ATOM    453  CG2 VAL    56     -27.808  32.716  -2.799  1.00 16.47           C
ATOM    454  C   VAL    56     -29.643  29.805  -4.680  1.00 17.90           C
ATOM    455  O   VAL    56     -29.872  28.769  -4.064  1.00 18.42           O
ATOM    456  N   LEU    57     -30.409  30.209  -5.690  1.00 18.83           N
ATOM    457  CA  LEU    57     -31.588  29.428  -6.064  1.00 20.44           C
ATOM    458  CB  LEU    57     -32.429  30.224  -7.058  1.00 19.98           C
ATOM    459  CG  LEU    57     -33.922  29.962  -7.106  1.00 25.44           C
ATOM    460  CD1 LEU    57     -34.592  30.145  -5.755  1.00 24.83           C
ATOM    461  CD2 LEU    57     -34.480  30.939  -8.118  1.00 27.85           C
ATOM    462  C   LEU    57     -31.165  28.050  -6.627  1.00 20.90           C
ATOM    463  O   LEU    57     -31.808  27.031  -6.345  1.00 20.75           O
ATOM    464  N   GLN    58     -30.052  28.016  -7.360  1.00 21.09           N
ATOM    465  CA  GLN    58     -29.551  26.768  -7.929  1.00 22.36           C
ATOM    466  CB  GLN    58     -28.346  26.998  -8.858  1.00 23.54           C
ATOM    467  CG  GLN    58     -27.960  25.733  -9.635  1.00 27.99           C
ATOM    468  CD  GLN    58     -29.191  25.021 -10.220  1.00 35.26           C
ATOM    469  OE1 GLN    58     -29.888  25.570 -11.083  1.00 37.09           O
ATOM    470  NE2 GLN    58     -29.469  23.796  -9.736  1.00 38.37           N
ATOM    471  C   GLN    58     -29.205  25.793  -6.803  1.00 22.27           C
ATOM    472  O   GLN    58     -29.522  24.575  -6.887  1.00 22.87           O
ATOM    473  N   GLU    59     -28.579  26.306  -5.741  0.50 21.38           N
ATOM    475  CA  GLU    59     -28.271  25.503  -4.553  0.50 21.43           C
ATOM    477  CB  GLU    59     -27.388  26.269  -3.553  0.50 21.44           C
ATOM    479  CG  GLU    59     -26.869  25.393  -2.378  0.50 21.69           C
ATOM    481  CD  GLU    59     -26.114  26.171  -1.293  0.50 22.85           C
ATOM    483  OE1 GLU    59     -25.921  27.400  -1.427  0.50 25.49           O
ATOM    485  OE2 GLU    59     -25.705  25.539  -0.292  0.50 22.88           O
ATOM    487  C   GLU    59     -29.535  25.040  -3.848  0.50 20.81           C
ATOM    489  O   GLU    59     -29.586  23.907  -3.359  0.50 20.84           O
ATOM    491  N   GLN    60     -30.526  25.927  -3.763  1.00 20.01           N
ATOM    492  CA  GLN    60     -31.823  25.588  -3.146  1.00 20.01           C
ATOM    493  CB  GLN    60     -32.751  26.812  -3.069  1.00 18.91           C
ATOM    494  CG  GLN    60     -32.254  27.942  -2.169  1.00 22.57           C
ATOM    495  CD  GLN    60     -32.132  27.523  -0.695  1.00 23.52           C
ATOM    496  OE1 GLN    60     -33.063  26.939  -0.124  1.00 25.17           O
ATOM    497  NE2 GLN    60     -30.987  27.798  -0.090  1.00 23.26           N
ATOM    498  C   GLN    60     -32.527  24.444  -3.865  1.00 18.38           C
ATOM    499  O   GLN    60     -33.135  23.578  -3.222  1.00 19.77           O
ATOM    500  N   PHE    61     -32.428  24.422  -5.192  1.00 18.84           N
ATOM    501  CA  PHE    61     -33.171  23.452  -5.980  1.00 18.05           C
ATOM    502  CB  PHE    61     -33.920  24.171  -7.089  1.00 18.50           C
ATOM    503  CG  PHE    61     -35.166  24.855  -6.603  1.00 16.29           C
ATOM    504  CD1 PHE    61     -35.097  26.142  -6.066  1.00 16.96           C
ATOM    505  CE1 PHE    61     -36.246  26.777  -5.586  1.00 17.57           C
ATOM    506  CZ  PHE    61     -37.469  26.128  -5.639  1.00 16.05           C
ATOM    507  CE2 PHE    61     -37.562  24.840  -6.149  1.00 16.94           C
ATOM    508  CD2 PHE    61     -36.415  24.206  -6.655  1.00 16.84           C
ATOM    509  C   PHE    61     -32.316  22.293  -6.529  1.00 18.86           C
ATOM    510  O   PHE    61     -32.799  21.474  -7.288  1.00 17.68           O
ATOM    511  N   ALA    62     -31.039  22.250  -6.153  1.00 19.75           N
ATOM    512  CA  ALA    62     -30.116  21.245  -6.684  1.00 20.70           C
ATOM    513  CB  ALA    62     -28.776  21.377  -5.988  1.00 21.27           C
ATOM    514  C   ALA    62     -30.639  19.784  -6.602  1.00 21.89           C
ATOM    515  O   ALA    62     -30.568  19.023  -7.588  1.00 22.43           O
ATOM    516  N   CYS    63     -31.180  19.433  -5.431  0.50 22.09           N
ATOM    518  CA  CYS    63     -31.713  18.088  -5.137  0.50 22.45           C
ATOM    520  CB  CYS    63     -32.194  18.002  -3.682  0.50 21.93           C
ATOM    522  SG  CYS    63     -30.917  17.628  -2.464  0.50 27.26           S
ATOM    524  C   CYS    63     -32.836  17.625  -6.072  0.50 21.59           C
ATOM    526  O   CYS    63     -33.089  16.419  -6.196  0.50 20.76           O
ATOM    528  N   PHE    64     -33.520  18.570  -6.711  1.00 20.75           N
ATOM    529  CA  PHE    64     -34.567  18.235  -7.659  1.00 20.96           C
ATOM    530  CB  PHE    64     -35.405  19.451  -8.035  1.00 19.37           C
ATOM    531  CG  PHE    64     -36.415  19.870  -6.996  1.00 19.26           C
ATOM    532  CD1 PHE    64     -36.028  20.573  -5.872  1.00 19.73           C
ATOM    533  CE1 PHE    64     -36.994  21.017  -4.934  1.00 18.87           C
ATOM    534  CZ  PHE    64     -38.331  20.739  -5.155  1.00 17.71           C
ATOM    535  CE2 PHE    64     -38.722  20.056  -6.260  1.00 18.01           C
ATOM    536  CD2 PHE    64     -37.778  19.643  -7.202  1.00 18.03           C
ATOM    537  C   PHE    64     -34.008  17.587  -8.957  1.00 21.96           C
ATOM    538  O   PHE    64     -34.743  16.934  -9.688  1.00 23.37           O
ATOM    539  N   GLY    65     -32.716  17.728  -9.209  1.00 22.10           N
ATOM    540  CA  GLY    65     -32.106  17.074 -10.371  1.00 23.22           C
ATOM    541  C   GLY    65     -31.577  15.697 -10.034  1.00 24.11           C
ATOM    542  O   GLY    65     -30.930  15.040 -10.873  1.00 24.63           O
ATOM    543  N   GLN    66     -31.841  15.266  -8.802  1.00 24.05           N
ATOM    544  CA  GLN    66     -31.357  13.993  -8.283  1.00 24.54           C
ATOM    545  CB  GLN    66     -30.285  14.241  -7.234  1.00 25.47           C
ATOM    546  CG  GLN    66     -28.910  14.511  -7.854  1.00 30.42           C
ATOM    547  CD  GLN    66     -28.001  15.342  -6.962  1.00 36.44           C
ATOM    548  OE1 GLN    66     -28.382  16.421  -6.479  1.00 39.74           O
ATOM    549  NE2 GLN    66     -26.784  14.859  -6.761  1.00 37.88           N
ATOM    550  C   GLN    66     -32.519  13.185  -7.688  1.00 23.92           C
ATOM    551  O   GLN    66     -32.671  13.075  -6.467  1.00 23.62           O
ATOM    552  N   LEU    67     -33.319  12.616  -8.579  1.00 22.78           N
ATOM    553  CA  LEU    67     -34.545  11.916  -8.200  1.00 21.55           C
ATOM    554  CB  LEU    67     -35.668  12.370  -9.128  1.00 21.58           C
ATOM    555  CG  LEU    67     -35.860  13.887  -9.236  1.00 21.33           C
ATOM    556  CD1 LEU    67     -36.995  14.155 -10.180  1.00 22.06           C
ATOM    557  CD2 LEU    67     -36.147  14.475  -7.858  1.00 21.71           C
ATOM    558  C   LEU    67     -34.455  10.391  -8.219  1.00 21.26           C
ATOM    559  O   LEU    67     -35.485   9.730  -8.205  1.00 20.77           O
ATOM    560  N   ASP    68     -33.243   9.827  -8.209  1.00 20.58           N
ATOM    561  CA  ASP    68     -33.066   8.375  -8.336  1.00 21.06           C
ATOM    562  CB  ASP    68     -31.588   8.003  -8.545  1.00 22.43           C
ATOM    563  CG  ASP    68     -31.143   8.118 -10.019  1.00 25.47           C
ATOM    564  OD1 ASP    68     -32.015   8.221 -10.922  1.00 30.33           O
ATOM    565  OD2 ASP    68     -29.915   8.103 -10.278  1.00 28.49           O
ATOM    566  C   ASP    68     -33.707   7.551  -7.191  1.00 21.11           C
ATOM    567  O   ASP    68     -34.136   6.420  -7.409  1.00 20.72           O
ATOM    568  N   ASP    69     -33.790   8.106  -5.981  1.00 20.70           N
ATOM    569  CA  ASP    69     -34.499   7.393  -4.890  1.00 21.27           C
ATOM    570  CB  ASP    69     -34.371   8.149  -3.562  1.00 22.13           C
ATOM    571  CG  ASP    69     -32.986   8.014  -2.948  1.00 24.48           C
ATOM    572  OD1 ASP    69     -32.312   6.996  -3.200  1.00 27.84           O
ATOM    573  OD2 ASP    69     -32.581   8.940  -2.220  1.00 28.42           O
ATOM    574  C   ASP    69     -35.988   7.188  -5.201  1.00 20.42           C
ATOM    575  O   ASP    69     -36.621   6.239  -4.725  1.00 20.59           O
ATOM    576  N   ILE    70     -36.539   8.100  -5.989  1.00 19.38           N
ATOM    577  CA  ILE    70     -37.928   7.992  -6.429  1.00 18.85           C
ATOM    578  CB  ILE    70     -38.556   9.366  -6.619  1.00 18.52           C
ATOM    579  CG1 ILE    70     -38.411  10.193  -5.323  1.00 21.19           C
ATOM    580  CD1 ILE    70     -38.809  11.665  -5.486  1.00 21.34           C
ATOM    581  CG2 ILE    70     -40.039   9.235  -6.997  1.00 19.97           C
ATOM    582  C   ILE    70     -38.014   7.194  -7.726  1.00 17.62           C
ATOM    583  O   ILE    70     -38.761   6.225  -7.804  1.00 18.07           O
ATOM    584  N   ARG    71     -37.271   7.614  -8.747  1.00 16.37           N
ATOM    585  CA  ARG    71     -37.312   6.918 -10.054  1.00 16.19           C
ATOM    586  CB  ARG    71     -36.314   7.527 -11.036  1.00 16.11           C
ATOM    587  CG  ARG    71     -36.578   8.965 -11.418  1.00 19.99           C
ATOM    588  CD  ARG    71     -35.754   9.340 -12.654  1.00 23.24           C
ATOM    589  NE  ARG    71     -35.827  10.770 -12.961  1.00 25.78           N
ATOM    590  CZ  ARG    71     -36.850  11.371 -13.583  1.00 28.05           C
ATOM    591  NH1 ARG    71     -37.910  10.665 -13.975  1.00 28.38           N
ATOM    592  NH2 ARG    71     -36.818  12.683 -13.821  1.00 22.66           N
ATOM    593  C   ARG    71     -36.981   5.449  -9.914  1.00 14.93           C
ATOM    594  O   ARG    71     -37.529   4.587 -10.637  1.00 13.88           O
ATOM    595  N   GLY    72     -36.074   5.141  -8.978  1.00 14.49           N
ATOM    596  CA  GLY    72     -35.604   3.763  -8.809  1.00 13.79           C
ATOM    597  C   GLY    72     -36.685   2.791  -8.352  1.00 14.28           C
ATOM    598  O   GLY    72     -36.498   1.596  -8.465  1.00 15.03           O
ATOM    599  N   GLN    73     -37.809   3.316  -7.844  1.00 13.08           N
ATOM    600  CA  GLN    73     -38.965   2.522  -7.381  1.00 13.26           C
ATOM    601  CB  GLN    73     -39.651   3.251  -6.211  1.00 13.37           C
ATOM    602  CG  GLN    73     -38.783   3.419  -4.979  1.00 16.75           C
ATOM    603  CD  GLN    73     -38.147   2.137  -4.546  1.00 21.82           C
ATOM    604  OE1 GLN    73     -38.813   1.105  -4.424  1.00 22.36           O
ATOM    605  NE2 GLN    73     -36.834   2.173  -4.334  1.00 26.08           N
ATOM    606  C   GLN    73     -40.037   2.290  -8.454  1.00 12.89           C
ATOM    607  O   GLN    73     -41.041   1.624  -8.204  1.00 12.88           O
ATOM    608  N   ALA    74     -39.844   2.871  -9.636  1.00 12.26           N
ATOM    609  CA  ALA    74     -40.800   2.693 -10.736  1.00 12.16           C
ATOM    610  CB  ALA    74     -40.216   3.279 -12.015  1.00 12.22           C
ATOM    611  C   ALA    74     -41.152   1.219 -10.951  1.00 12.26           C
ATOM    612  O   ALA    74     -40.261   0.342 -10.903  1.00 11.19           O
ATOM    613  N   GLY    75     -42.429   0.939 -11.235  1.00 11.65           N
ATOM    614  CA  GLY    75     -42.868  -0.466 -11.342  1.00 10.70           C
ATOM    615  C   GLY    75     -43.731  -0.790 -10.118  1.00 11.25           C
ATOM    616  O   GLY    75     -44.484  -1.762 -10.116  1.00 11.59           O
ATOM    617  N   ASP    76     -43.570  -0.008  -9.043  1.00 12.06           N
ATOM    618  CA  ASP    76     -44.360  -0.166  -7.824  1.00 12.36           C
ATOM    619  CB  ASP    76     -43.487  -0.827  -6.733  1.00 12.42           C
ATOM    620  CG  ASP    76     -44.202  -1.022  -5.400  1.00 15.66           C
ATOM    621  OD1 ASP    76     -45.317  -0.484  -5.151  1.00 16.24           O
ATOM    622  OD2 ASP    76     -43.604  -1.751  -4.566  1.00 15.57           O
ATOM    623  C   ASP    76     -44.849   1.223  -7.391  1.00 12.68           C
ATOM    624  O   ASP    76     -44.129   1.931  -6.685  1.00 11.41           O
ATOM    625  N   PRO    77     -46.043   1.647  -7.879  1.00 13.71           N
ATOM    626  CA  PRO    77     -46.488   3.033  -7.645  1.00 13.93           C
ATOM    627  CB  PRO    77     -47.873   3.103  -8.333  1.00 13.23           C
ATOM    628  CG  PRO    77     -47.761   2.072  -9.458  1.00 15.27           C
ATOM    629  CD  PRO    77     -46.977   0.920  -8.766  1.00 14.18           C
ATOM    630  C   PRO    77     -46.533   3.405  -6.182  1.00 13.31           C
ATOM    631  O   PRO    77     -46.184   4.524  -5.838  1.00 13.85           O
ATOM    632  N   LEU    78     -46.946   2.477  -5.319  0.50 13.21           N
ATOM    634  CA  LEU    78     -46.992   2.787  -3.889  0.50 13.74           C
ATOM    636  CB  LEU    78     -47.582   1.617  -3.103  0.50 13.51           C
ATOM    638  CG  LEU    78     -48.457   1.997  -1.907  0.50 14.73           C
ATOM    640  CD1 LEU    78     -49.147   0.741  -1.413  0.50 17.25           C
ATOM    642  CD2 LEU    78     -47.650   2.638  -0.804  0.50 19.04           C
ATOM    644  C   LEU    78     -45.602   3.124  -3.366  0.50 13.01           C
ATOM    646  O   LEU    78     -45.444   4.072  -2.614  0.50 12.86           O
ATOM    648  N   ALA    79     -44.598   2.339  -3.761  1.00 13.15           N
ATOM    649  CA  ALA    79     -43.203   2.602  -3.355  1.00 13.03           C
ATOM    650  CB  ALA    79     -42.284   1.481  -3.789  1.00 13.22           C
ATOM    651  C   ALA    79     -42.705   3.953  -3.901  1.00 12.54           C
ATOM    652  O   ALA    79     -41.949   4.654  -3.228  1.00 12.09           O
ATOM    653  N   VAL    80     -43.099   4.301  -5.131  1.00 11.58           N
ATOM    654  CA  VAL    80     -42.787   5.630  -5.672  1.00 12.21           C
ATOM    655  CB  VAL    80     -43.296   5.773  -7.101  1.00 11.22           C
ATOM    656  CG1 VAL    80     -43.163   7.227  -7.624  1.00 12.32           C
ATOM    657  CG2 VAL    80     -42.538   4.787  -8.035  1.00 10.84           C
ATOM    658  C   VAL    80     -43.376   6.760  -4.777  1.00 13.05           C
ATOM    659  O   VAL    80     -42.668   7.710  -4.420  1.00 13.23           O
ATOM    660  N   MET    81     -44.661   6.646  -4.436  0.70 12.38           N
ATOM    662  CA  MET    81     -45.330   7.668  -3.603  0.70 12.69           C
ATOM    664  CB  MET    81     -46.833   7.394  -3.427  0.70 13.82           C
ATOM    666  CG  MET    81     -47.597   7.155  -4.747  0.70 14.01           C
ATOM    668  SD  MET    81     -47.622   8.670  -5.960  0.70 21.09          SE
ATOM    670  CE  MET    81     -47.084   7.612  -7.496  0.70 15.28           C
ATOM    672  C   MET    81     -44.684   7.771  -2.235  0.70 13.11           C
ATOM    674  O   MET    81     -44.538   8.886  -1.698  0.70 12.95           O
ATOM    676  N   THR    82     -44.336   6.621  -1.655  1.00 11.97           N
ATOM    677  CA  THR    82     -43.690   6.575  -0.342  1.00 13.13           C
ATOM    678  CB  THR    82     -43.605   5.113   0.176  1.00 12.76           C
ATOM    679  OG1 THR    82     -44.931   4.563   0.297  1.00 13.08           O
ATOM    680  CG2 THR    82     -42.926   5.051   1.546  1.00 12.65           C
ATOM    681  C   THR    82     -42.311   7.220  -0.401  1.00 12.27           C
ATOM    682  O   THR    82     -41.988   8.047   0.443  1.00 12.09           O
ATOM    683  N   ALA    83     -41.522   6.874  -1.419  1.00 12.10           N
ATOM    684  CA  ALA    83     -40.189   7.455  -1.613  1.00 12.71           C
ATOM    685  CB  ALA    83     -39.469   6.804  -2.772  1.00 13.64           C
ATOM    686  C   ALA    83     -40.256   8.962  -1.829  1.00 13.31           C
ATOM    687  O   ALA    83     -39.424   9.717  -1.293  1.00 13.65           O
ATOM    688  N   TYR    84     -41.234   9.393  -2.621  1.00 12.01           N
ATOM    689  CA  TYR    84     -41.450  10.829  -2.827  1.00 11.80           C
ATOM    690  CB  TYR    84     -42.626  11.070  -3.785  1.00 11.47           C
ATOM    691  CG  TYR    84     -43.055  12.503  -3.698  1.00 11.01           C
ATOM    692  CD1 TYR    84     -42.230  13.514  -4.207  1.00  9.70           C
ATOM    693  CE1 TYR    84     -42.562  14.853  -4.058  1.00  7.72           C
ATOM    694  CZ  TYR    84     -43.777  15.207  -3.416  1.00  9.90           C
ATOM    695  OH  TYR    84     -44.090  16.520  -3.245  1.00  9.60           O
ATOM    696  CE2 TYR    84     -44.606  14.228  -2.886  1.00 10.03           C
ATOM    697  CD2 TYR    84     -44.241  12.867  -3.033  1.00  8.93           C
ATOM    698  C   TYR    84     -41.702  11.542  -1.464  1.00 11.96           C
ATOM    699  O   TYR    84     -41.113  12.588  -1.195  1.00 11.13           O
ATOM    700  N   LEU    85     -42.594  11.008  -0.646  1.00 10.86           N
ATOM    701  CA  LEU    85     -42.868  11.627   0.683  1.00 10.85           C
ATOM    702  CB  LEU    85     -44.003  10.908   1.396  1.00 10.34           C
ATOM    703  CG  LEU    85     -45.392  11.039   0.735  1.00 11.08           C
ATOM    704  CD1 LEU    85     -46.412  10.164   1.470  1.00 14.10           C
ATOM    705  CD2 LEU    85     -45.840  12.513   0.824  1.00 11.81           C
ATOM    706  C   LEU    85     -41.608  11.688   1.547  1.00 10.59           C
ATOM    707  O   LEU    85     -41.299  12.737   2.160  1.00  9.89           O
ATOM    708  N   ARG    86     -40.890  10.577   1.613  1.00 11.70           N
ATOM    709  CA  ARG    86     -39.686  10.504   2.430  1.00 12.21           C
ATOM    710  CB  ARG    86     -39.118   9.092   2.407  1.00 13.48           C
ATOM    711  CG  ARG    86     -38.070   8.880   3.462  1.00 16.80           C
ATOM    712  CD  ARG    86     -37.752   7.377   3.627  1.00 18.02           C
ATOM    713  NE  ARG    86     -38.810   6.676   4.350  1.00 20.50           N
ATOM    714  CZ  ARG    86     -39.556   5.706   3.833  1.00 23.33           C
ATOM    715  NH1 ARG    86     -39.354   5.300   2.584  1.00 26.93           N
ATOM    716  NH2 ARG    86     -40.472   5.111   4.589  1.00 24.38           N
ATOM    717  C   ARG    86     -38.635  11.526   1.947  1.00 11.94           C
ATOM    718  O   ARG    86     -37.985  12.202   2.764  1.00 11.86           O
ATOM    719  N   TRP    87     -38.462  11.595   0.637  1.00 11.06           N
ATOM    720  CA  TRP    87     -37.511  12.517   0.011  1.00 11.54           C
ATOM    721  CB  TRP    87     -37.513  12.276  -1.518  1.00 11.78           C
ATOM    722  CG  TRP    87     -36.670  13.219  -2.336  1.00 11.45           C
ATOM    723  CD1 TRP    87     -35.298  13.232  -2.473  1.00 12.95           C
ATOM    724  NE1 TRP    87     -34.914  14.228  -3.355  1.00 11.75           N
ATOM    725  CE2 TRP    87     -36.041  14.867  -3.805  1.00 12.69           C
ATOM    726  CD2 TRP    87     -37.162  14.253  -3.195  1.00 12.32           C
ATOM    727  CE3 TRP    87     -38.448  14.715  -3.505  1.00 13.71           C
ATOM    728  CZ3 TRP    87     -38.582  15.767  -4.386  1.00 13.30           C
ATOM    729  CH2 TRP    87     -37.436  16.377  -4.989  1.00 14.32           C
ATOM    730  CZ2 TRP    87     -36.166  15.944  -4.703  1.00 14.12           C
ATOM    731  C   TRP    87     -37.904  13.972   0.307  1.00 11.68           C
ATOM    732  O   TRP    87     -37.046  14.801   0.617  1.00 11.77           O
ATOM    733  N   THR    88     -39.191  14.280   0.183  1.00 11.01           N
ATOM    734  CA  THR    88     -39.685  15.654   0.390  1.00 11.22           C
ATOM    735  CB  THR    88     -41.147  15.790  -0.053  1.00 12.10           C
ATOM    736  OG1 THR    88     -41.220  15.503  -1.460  1.00 12.19           O
ATOM    737  CG2 THR    88     -41.678  17.220   0.199  1.00 12.36           C
ATOM    738  C   THR    88     -39.498  16.086   1.853  1.00 10.14           C
ATOM    739  O   THR    88     -39.045  17.207   2.119  1.00  9.63           O
ATOM    740  N   ILE    89     -39.826  15.192   2.778  1.00 10.71           N
ATOM    741  CA  ILE    89     -39.609  15.477   4.191  1.00 11.44           C
ATOM    742  CB  ILE    89     -40.178  14.352   5.067  1.00 11.62           C
ATOM    743  CG1 ILE    89     -41.718  14.377   4.949  1.00 10.67           C
ATOM    744  CD1 ILE    89     -42.368  13.154   5.612  1.00 14.32           C
ATOM    745  CG2 ILE    89     -39.752  14.574   6.521  1.00  9.76           C
ATOM    746  C   ILE    89     -38.108  15.719   4.470  1.00 11.65           C
ATOM    747  O   ILE    89     -37.748  16.702   5.123  1.00 10.49           O
ATOM    748  N   GLN    90     -37.253  14.832   3.946  0.60 11.78           N
ATOM    750  CA  GLN    90     -35.805  15.009   4.058  0.60 12.90           C
ATOM    752  CB  GLN    90     -35.059  13.906   3.294  0.60 13.23           C
ATOM    754  CG  GLN    90     -33.581  13.882   3.617  0.60 18.71           C
ATOM    756  CD  GLN    90     -33.320  13.696   5.114  0.60 24.36           C
ATOM    758  OE1 GLN    90     -32.857  14.615   5.797  0.60 28.60           O
ATOM    760  NE2 GLN    90     -33.626  12.502   5.631  0.60 27.22           N
ATOM    762  C   GLN    90     -35.349  16.402   3.563  0.60 12.09           C
ATOM    764  O   GLN    90     -34.599  17.104   4.235  0.60 11.76           O
ATOM    766  N   ARG    91     -35.849  16.798   2.401  1.00 12.06           N
ATOM    767  CA  ARG    91     -35.481  18.070   1.792  1.00 11.96           C
ATOM    768  CB  ARG    91     -36.237  18.253   0.485  1.00 13.06           C
ATOM    769  CG  ARG    91     -35.579  17.519  -0.624  1.00 17.79           C
ATOM    770  CD  ARG    91     -36.116  18.032  -1.972  1.00 20.49           C
ATOM    771  NE  ARG    91     -37.524  17.695  -2.235  1.00 21.73           N
ATOM    772  CZ  ARG    91     -38.542  18.563  -2.176  1.00 22.41           C
ATOM    773  NH1 ARG    91     -39.778  18.166  -2.519  1.00 18.87           N
ATOM    774  NH2 ARG    91     -38.328  19.821  -1.792  1.00 17.44           N
ATOM    775  C   ARG    91     -35.787  19.210   2.737  1.00 11.92           C
ATOM    776  O   ARG    91     -34.954  20.120   2.929  1.00 11.63           O
ATOM    777  N   HIS    92     -36.985  19.171   3.324  1.00 11.45           N
ATOM    778  CA  HIS    92     -37.369  20.231   4.257  1.00 12.36           C
ATOM    779  CB  HIS    92     -38.873  20.203   4.534  1.00 13.78           C
ATOM    780  CG  HIS    92     -39.696  20.557   3.336  1.00 14.40           C
ATOM    781  ND1 HIS    92     -39.591  21.777   2.684  1.00 19.47           N
ATOM    782  CE1 HIS    92     -40.452  21.801   1.674  1.00 21.35           C
ATOM    783  NE2 HIS    92     -41.103  20.649   1.649  1.00 16.69           N
ATOM    784  CD2 HIS    92     -40.635  19.846   2.660  1.00 16.03           C
ATOM    785  C   HIS    92     -36.565  20.215   5.544  1.00 12.15           C
ATOM    786  O   HIS    92     -36.192  21.268   6.056  1.00 11.95           O
ATOM    787  N   ARG    93     -36.254  19.030   6.054  1.00 11.79           N
ATOM    788  CA  ARG    93     -35.455  18.958   7.286  1.00 12.70           C
ATOM    789  CB  ARG    93     -35.461  17.537   7.853  1.00 12.66           C
ATOM    790  CG  ARG    93     -36.858  17.020   8.266  1.00 13.84           C
ATOM    791  CD  ARG    93     -37.401  17.762   9.453  1.00 18.09           C
ATOM    792  NE  ARG    93     -38.685  17.215   9.878  1.00 17.47           N
ATOM    793  CZ  ARG    93     -39.526  17.858  10.676  1.00 16.59           C
ATOM    794  NH1 ARG    93     -39.223  19.072  11.110  1.00 17.37           N
ATOM    795  NH2 ARG    93     -40.666  17.281  11.023  1.00 15.53           N
ATOM    796  C   ARG    93     -34.025  19.435   7.057  1.00 13.20           C
ATOM    797  O   ARG    93     -33.450  20.125   7.905  1.00 15.46           O
ATOM    798  N   ASN    94     -33.459  19.087   5.914  1.00 12.51           N
ATOM    799  CA  ASN    94     -32.101  19.512   5.580  1.00 14.01           C
ATOM    800  CB  ASN    94     -31.566  18.704   4.408  1.00 15.34           C
ATOM    801  CG  ASN    94     -31.380  17.226   4.724  1.00 18.74           C
ATOM    802  OD1 ASN    94     -31.130  16.441   3.813  1.00 27.63           O
ATOM    803  ND2 ASN    94     -31.508  16.841   5.986  1.00 22.90           N
ATOM    804  C   ASN    94     -32.010  20.978   5.199  1.00 13.91           C
ATOM    805  O   ASN    94     -30.942  21.582   5.307  1.00 12.63           O
ATOM    806  N   ASN    95     -33.118  21.549   4.732  1.00 13.29           N
ATOM    807  CA  ASN    95     -33.111  22.936   4.270  1.00 15.16           C
ATOM    808  CB  ASN    95     -32.967  23.054   2.763  1.00 16.24           C
ATOM    809  CG  ASN    95     -32.773  24.515   2.339  1.00 19.00           C
ATOM    810  OD1 ASN    95     -32.538  25.397   3.185  1.00 16.84           O
ATOM    811  ND2 ASN    95     -32.897  24.782   1.041  1.00 21.24           N
ATOM    812  C   ASN    95     -34.330  23.717   4.692  1.00 15.67           C
ATOM    813  O   ASN    95     -35.314  23.831   3.936  1.00 15.80           O
ATOM    814  N   PRO    96     -34.271  24.260   5.900  1.00 16.89           N
ATOM    815  CA  PRO    96     -35.322  25.100   6.460  1.00 18.18           C
ATOM    816  CB  PRO    96     -34.732  25.555   7.802  1.00 18.94           C
ATOM    817  CG  PRO    96     -33.729  24.472   8.148  1.00 19.40           C
ATOM    818  CD  PRO    96     -33.147  24.066   6.837  1.00 17.29           C
ATOM    819  C   PRO    96     -35.602  26.309   5.578  1.00 17.64           C
ATOM    820  O   PRO    96     -36.688  26.843   5.668  1.00 20.08           O
ATOM    821  N   GLN    97     -34.664  26.718   4.721  1.00 17.55           N
ATOM    822  CA  GLN    97     -34.882  27.924   3.884  1.00 16.15           C
ATOM    823  CB  GLN    97     -33.556  28.526   3.375  1.00 18.11           C
ATOM    824  CG  GLN    97     -32.586  28.997   4.445  1.00 21.27           C
ATOM    825  CD  GLN    97     -32.986  30.332   5.097  1.00 25.68           C
ATOM    826  OE1 GLN    97     -34.153  30.593   5.335  1.00 27.40           O
ATOM    827  NE2 GLN    97     -32.009  31.165   5.381  1.00 27.04           N
ATOM    828  C   GLN    97     -35.744  27.610   2.655  1.00 14.78           C
ATOM    829  O   GLN    97     -36.230  28.506   1.960  1.00 11.98           O
ATOM    830  N   LEU    98     -35.901  26.333   2.335  1.00 12.64           N
ATOM    831  CA  LEU    98     -36.399  26.054   0.980  1.00 12.07           C
ATOM    832  CB  LEU    98     -36.223  24.576   0.576  1.00 12.25           C
ATOM    833  CG  LEU    98     -36.864  24.142  -0.779  1.00 13.48           C
ATOM    834  CD1 LEU    98     -36.177  24.694  -2.050  1.00 15.69           C
ATOM    835  CD2 LEU    98     -36.865  22.621  -0.848  1.00 15.12           C
ATOM    836  C   LEU    98     -37.808  26.609   0.762  1.00  9.66           C
ATOM    837  O   LEU    98     -38.058  27.231  -0.286  1.00  9.22           O
ATOM    838  N   LEU    99     -38.723  26.475   1.724  1.00  9.90           N
ATOM    839  CA  LEU    99     -40.096  26.921   1.392  1.00 10.68           C
ATOM    840  CB  LEU    99     -41.134  26.482   2.475  1.00 11.84           C
ATOM    841  CG  LEU    99     -41.720  25.109   2.218  1.00 12.27           C
ATOM    842  CD1 LEU    99     -42.546  24.691   3.463  1.00 16.86           C
ATOM    843  CD2 LEU    99     -42.530  24.990   0.943  1.00 14.59           C
ATOM    844  C   LEU    99     -40.166  28.414   1.244  1.00 10.51           C
ATOM    845  O   LEU    99     -41.036  28.919   0.576  1.00 11.22           O
ATOM    846  N   ARG   100     -39.232  29.138   1.869  1.00  8.91           N
ATOM    847  CA  ARG   100     -39.171  30.614   1.637  1.00 10.19           C
ATOM    848  CB  ARG   100     -38.051  31.233   2.443  1.00  9.36           C
ATOM    849  CG  ARG   100     -38.293  31.279   3.923  1.00 12.57           C
ATOM    850  CD  ARG   100     -37.117  31.919   4.691  1.00 14.26           C
ATOM    851  NE  ARG   100     -37.502  32.131   6.084  1.00 21.03           N
ATOM    852  CZ  ARG   100     -36.662  32.254   7.102  1.00 26.22           C
ATOM    853  NH1 ARG   100     -35.340  32.191   6.906  1.00 25.30           N
ATOM    854  NH2 ARG   100     -37.156  32.455   8.326  1.00 30.04           N
ATOM    855  C   ARG   100     -38.944  30.908   0.135  1.00  9.56           C
ATOM    856  O   ARG   100     -39.737  31.609  -0.479  1.00  9.17           O
ATOM    857  N   PHE   101     -37.894  30.333  -0.451  1.00  8.88           N
ATOM    858  CA  PHE   101     -37.584  30.586  -1.861  1.00  7.74           C
ATOM    859  CB  PHE   101     -36.227  29.979  -2.191  1.00  9.07           C
ATOM    860  CG  PHE   101     -35.072  30.718  -1.553  1.00  8.31           C
ATOM    861  CD1 PHE   101     -34.572  31.865  -2.155  1.00  9.65           C
ATOM    862  CE1 PHE   101     -33.460  32.577  -1.586  1.00 12.39           C
ATOM    863  CZ  PHE   101     -32.856  32.079  -0.434  1.00 11.45           C
ATOM    864  CE2 PHE   101     -33.351  30.895   0.160  1.00 13.90           C
ATOM    865  CD2 PHE   101     -34.452  30.220  -0.416  1.00 11.33           C
ATOM    866  C   PHE   101     -38.651  29.978  -2.784  1.00  8.41           C
ATOM    867  O   PHE   101     -39.040  30.587  -3.776  1.00  8.06           O
ATOM    868  N   TYR   102     -39.122  28.777  -2.420  1.00  7.06           N
ATOM    869  CA  TYR   102     -40.068  28.027  -3.247  1.00  7.90           C
ATOM    870  CB  TYR   102     -40.262  26.695  -2.548  1.00  7.79           C
ATOM    871  CG  TYR   102     -41.077  25.629  -3.236  1.00  8.54           C
ATOM    872  CD1 TYR   102     -42.489  25.656  -3.181  1.00 10.03           C
ATOM    873  CE1 TYR   102     -43.257  24.599  -3.766  1.00 11.63           C
ATOM    874  CZ  TYR   102     -42.610  23.511  -4.376  1.00 11.76           C
ATOM    875  OH  TYR   102     -43.341  22.459  -4.924  1.00 11.14           O
ATOM    876  CE2 TYR   102     -41.192  23.459  -4.417  1.00  9.45           C
ATOM    877  CD2 TYR   102     -40.447  24.510  -3.827  1.00 10.19           C
ATOM    878  C   TYR   102     -41.394  28.796  -3.351  1.00  8.00           C
ATOM    879  O   TYR   102     -41.879  29.032  -4.458  1.00  9.22           O
ATOM    880  N   THR   103     -41.935  29.239  -2.212  1.00  8.23           N
ATOM    881  CA  THR   103     -43.186  30.012  -2.256  1.00  8.10           C
ATOM    882  CB  THR   103     -43.885  30.125  -0.875  1.00  7.33           C
ATOM    883  OG1 THR   103     -43.012  30.781   0.056  1.00  8.06           O
ATOM    884  CG2 THR   103     -44.249  28.714  -0.376  1.00  8.46           C
ATOM    885  C   THR   103     -43.009  31.397  -2.842  1.00  8.57           C
ATOM    886  O   THR   103     -43.909  31.869  -3.557  1.00  9.60           O
ATOM    887  N   SER   104     -41.877  32.052  -2.541  1.00  9.12           N
ATOM    888  CA  SER   104     -41.655  33.400  -3.043  1.00  9.88           C
ATOM    889  CB  SER   104     -40.363  34.009  -2.477  1.00  9.85           C
ATOM    890  OG  SER   104     -40.234  35.352  -2.971  1.00 12.21           O
ATOM    891  C   SER   104     -41.601  33.357  -4.584  1.00 10.66           C
ATOM    892  O   SER   104     -42.219  34.183  -5.265  1.00 10.59           O
ATOM    893  N   GLU   105     -40.865  32.392  -5.125  1.00  8.72           N
ATOM    894  CA  GLU   105     -40.817  32.289  -6.613  1.00  9.18           C
ATOM    895  CB  GLU   105     -39.731  31.293  -7.041  1.00  7.45           C
ATOM    896  CG  GLU   105     -38.332  31.924  -6.972  1.00  8.14           C
ATOM    897  CD  GLU   105     -38.036  32.910  -8.131  1.00 10.19           C
ATOM    898  OE1 GLU   105     -38.853  33.093  -9.071  1.00  9.04           O
ATOM    899  OE2 GLU   105     -36.931  33.505  -8.111  1.00 13.04           O
ATOM    900  C   GLU   105     -42.165  31.935  -7.261  1.00  9.12           C
ATOM    901  O   GLU   105     -42.538  32.491  -8.300  1.00  9.81           O
ATOM    902  N   LEU   106     -42.941  31.042  -6.632  1.00  8.79           N
ATOM    903  CA  LEU   106     -44.237  30.680  -7.191  1.00  9.03           C
ATOM    904  CB  LEU   106     -44.849  29.471  -6.457  1.00  8.32           C
ATOM    905  CG  LEU   106     -44.211  28.130  -6.911  1.00  9.60           C
ATOM    906  CD1 LEU   106     -44.576  27.033  -5.828  1.00  9.04           C
ATOM    907  CD2 LEU   106     -44.754  27.786  -8.296  1.00  9.22           C
ATOM    908  C   LEU   106     -45.238  31.834  -7.135  1.00  9.88           C
ATOM    909  O   LEU   106     -46.147  31.887  -7.972  1.00 10.21           O
ATOM    910  N   THR   107     -45.102  32.717  -6.136  1.00  9.52           N
ATOM    911  CA  THR   107     -46.030  33.832  -5.986  1.00  9.75           C
ATOM    912  CB  THR   107     -46.510  33.990  -4.516  1.00  9.09           C
ATOM    913  OG1 THR   107     -45.388  34.319  -3.693  1.00 10.50           O
ATOM    914  CG2 THR   107     -47.185  32.718  -4.076  1.00 10.05           C
ATOM    915  C   THR   107     -45.544  35.182  -6.484  1.00  9.81           C
ATOM    916  O   THR   107     -46.371  36.081  -6.704  1.00 12.25           O
ATOM    917  N   ASN   108     -44.232  35.363  -6.633  0.50  9.70           N
ATOM    919  CA  ASN   108     -43.617  36.625  -7.105  0.50  9.59           C
ATOM    921  CB  ASN   108     -43.154  37.511  -5.932  0.50  9.99           C
ATOM    923  CG  ASN   108     -44.278  38.322  -5.314  0.50  8.07           C
ATOM    925  OD1 ASN   108     -44.577  38.166  -4.138  0.50 11.45           O
ATOM    927  ND2 ASN   108     -44.931  39.160  -6.116  0.50  6.17           N
ATOM    929  C   ASN   108     -42.392  36.215  -7.909  0.50  9.86           C
ATOM    931  O   ASN   108     -41.262  36.429  -7.469  0.50  9.46           O
ATOM    933  N   PRO   109     -42.611  35.593  -9.087  1.00  9.87           N
ATOM    934  CA  PRO   109     -41.482  34.997  -9.847  1.00  9.20           C
ATOM    935  CB  PRO   109     -42.170  34.338 -11.060  1.00  9.29           C
ATOM    936  CG  PRO   109     -43.456  35.217 -11.249  1.00 11.47           C
ATOM    937  CD  PRO   109     -43.900  35.416  -9.770  1.00 10.72           C
ATOM    938  C   PRO   109     -40.455  36.039 -10.322  1.00  9.60           C
ATOM    939  O   PRO   109     -40.811  37.205 -10.612  1.00 11.09           O
ATOM    940  N   THR   110     -39.210  35.615 -10.382  1.00  9.05           N
ATOM    941  CA  THR   110     -38.133  36.378 -11.039  1.00  9.32           C
ATOM    942  CB  THR   110     -36.862  36.356 -10.160  1.00 10.57           C
ATOM    943  OG1 THR   110     -36.330  35.035 -10.130  1.00  9.30           O
ATOM    944  CG2 THR   110     -37.147  36.832  -8.744  1.00 13.98           C
ATOM    945  C   THR   110     -37.799  35.644 -12.327  1.00  8.94           C
ATOM    946  O   THR   110     -38.429  34.643 -12.626  1.00  8.35           O
ATOM    947  N   PRO   111     -36.818  36.119 -13.123  1.00  9.83           N
ATOM    948  CA  PRO   111     -36.366  35.317 -14.286  1.00 11.52           C
ATOM    949  CB  PRO   111     -35.231  36.183 -14.892  1.00 11.75           C
ATOM    950  CG  PRO   111     -35.579  37.539 -14.489  1.00 11.98           C
ATOM    951  CD  PRO   111     -36.150  37.430 -13.076  1.00 10.83           C
ATOM    952  C   PRO   111     -35.863  33.915 -13.908  1.00 12.86           C
ATOM    953  O   PRO   111     -35.889  32.963 -14.744  1.00 13.75           O
ATOM    954  N   CYS   112     -35.461  33.730 -12.660  1.00 11.46           N
ATOM    955  CA  CYS   112     -35.067  32.401 -12.254  1.00 13.19           C
ATOM    956  CB  CYS   112     -34.230  32.442 -10.978  1.00 14.56           C
ATOM    957  SG  CYS   112     -32.686  33.333 -11.290  1.00 18.40           S
ATOM    958  C   CYS   112     -36.251  31.432 -12.108  1.00 12.18           C
ATOM    959  O   CYS   112     -36.048  30.232 -11.974  1.00 13.79           O
ATOM    960  N   PHE   113     -37.501  31.926 -12.121  1.00 11.58           N
ATOM    961  CA  PHE   113     -38.605  30.987 -11.961  1.00 10.29           C
ATOM    962  CB  PHE   113     -39.921  31.711 -11.869  1.00 10.73           C
ATOM    963  CG  PHE   113     -41.068  30.776 -11.807  1.00 10.75           C
ATOM    964  CD1 PHE   113     -41.318  30.025 -10.649  1.00 13.13           C
ATOM    965  CE1 PHE   113     -42.390  29.092 -10.649  1.00 14.20           C
ATOM    966  CZ  PHE   113     -43.135  28.878 -11.780  1.00 12.39           C
ATOM    967  CE2 PHE   113     -42.909  29.606 -12.931  1.00 14.70           C
ATOM    968  CD2 PHE   113     -41.824  30.539 -12.957  1.00 11.87           C
ATOM    969  C   PHE   113     -38.634  30.035 -13.180  1.00  9.81           C
ATOM    970  O   PHE   113     -38.642  28.807 -13.017  1.00  9.92           O
ATOM    971  N   ALA   114     -38.644  30.592 -14.383  1.00  9.60           N
ATOM    972  CA  ALA   114     -38.711  29.716 -15.565  1.00  9.88           C
ATOM    973  CB  ALA   114     -38.980  30.528 -16.837  1.00  9.97           C
ATOM    974  C   ALA   114     -37.461  28.865 -15.730  1.00 10.92           C
ATOM    975  O   ALA   114     -37.548  27.764 -16.247  1.00 11.21           O
ATOM    976  N   ALA   115     -36.301  29.407 -15.342  1.00 10.45           N
ATOM    977  CA  ALA   115     -35.020  28.733 -15.554  1.00 11.81           C
ATOM    978  CB  ALA   115     -33.882  29.767 -15.520  1.00 12.14           C
ATOM    979  C   ALA   115     -34.750  27.588 -14.574  1.00 11.95           C
ATOM    980  O   ALA   115     -34.178  26.555 -14.951  1.00 12.70           O
ATOM    981  N   ILE   116     -35.186  27.750 -13.331  1.00 11.04           N
ATOM    982  CA  ILE   116     -34.783  26.848 -12.255  1.00 11.69           C
ATOM    983  CB  ILE   116     -33.872  27.616 -11.214  1.00 10.98           C
ATOM    984  CG1 ILE   116     -32.584  28.106 -11.900  1.00 13.37           C
ATOM    985  CD1 ILE   116     -31.751  29.071 -11.039  1.00 12.57           C
ATOM    986  CG2 ILE   116     -33.568  26.724  -9.962  1.00 12.49           C
ATOM    987  C   ILE   116     -35.998  26.242 -11.560  1.00 11.29           C
ATOM    988  O   ILE   116     -36.092  25.007 -11.384  1.00 10.24           O
ATOM    989  N   VAL   117     -36.919  27.089 -11.131  1.00 10.95           N
ATOM    990  CA  VAL   117     -37.977  26.588 -10.206  1.00 10.57           C
ATOM    991  CB  VAL   117     -38.617  27.751  -9.409  1.00 11.02           C
ATOM    992  CG1 VAL   117     -39.795  27.207  -8.454  1.00 10.64           C
ATOM    993  CG2 VAL   117     -37.512  28.443  -8.627  1.00 10.50           C
ATOM    994  C   VAL   117     -39.038  25.771 -10.946  1.00 11.77           C
ATOM    995  O   VAL   117     -39.425  24.648 -10.524  1.00 11.14           O
ATOM    996  N   SER   118     -39.530  26.315 -12.046  1.00 10.59           N
ATOM    997  CA  SER   118     -40.620  25.684 -12.764  1.00 12.47           C
ATOM    998  CB  SER   118     -41.105  26.636 -13.868  1.00 13.39           C
ATOM    999  OG  SER   118     -42.255  26.127 -14.471  1.00 14.41           O
ATOM   1000  C   SER   118     -40.234  24.283 -13.285  1.00 11.92           C
ATOM   1001  O   SER   118     -40.958  23.318 -13.010  1.00 12.39           O
ATOM   1002  N   PRO   119     -39.094  24.138 -13.988  1.00 12.64           N
ATOM   1003  CA  PRO   119     -38.727  22.800 -14.461  1.00 11.77           C
ATOM   1004  CB  PRO   119     -37.448  23.016 -15.304  1.00 12.21           C
ATOM   1005  CG  PRO   119     -36.981  24.375 -14.981  1.00 12.76           C
ATOM   1006  CD  PRO   119     -38.161  25.180 -14.467  1.00 11.90           C
ATOM   1007  C   PRO   119     -38.487  21.799 -13.296  1.00 11.38           C
ATOM   1008  O   PRO   119     -38.822  20.622 -13.450  1.00 11.44           O
ATOM   1009  N   ALA   120     -37.965  22.276 -12.162  1.00 10.79           N
ATOM   1010  CA  ALA   120     -37.680  21.404 -10.992  1.00  9.96           C
ATOM   1011  CB  ALA   120     -36.955  22.202  -9.916  1.00 10.33           C
ATOM   1012  C   ALA   120     -38.996  20.843 -10.478  1.00 11.25           C
ATOM   1013  O   ALA   120     -39.179  19.606 -10.381  1.00 11.32           O
ATOM   1014  N   ILE   121     -39.972  21.731 -10.240  1.00  9.92           N
ATOM   1015  CA  ILE   121     -41.278  21.275  -9.739  1.00 10.42           C
ATOM   1016  CB  ILE   121     -42.191  22.482  -9.354  1.00  9.91           C
ATOM   1017  CG1 ILE   121     -41.576  23.223  -8.147  1.00 11.53           C
ATOM   1018  CD1 ILE   121     -42.273  24.600  -7.882  1.00 11.61           C
ATOM   1019  CG2 ILE   121     -43.657  22.039  -9.082  1.00 11.13           C
ATOM   1020  C   ILE   121     -41.980  20.382 -10.790  1.00 10.00           C
ATOM   1021  O   ILE   121     -42.496  19.302 -10.444  1.00 10.24           O
ATOM   1022  N   ALA   122     -41.999  20.822 -12.047  1.00 10.30           N
ATOM   1023  CA  ALA   122     -42.680  20.050 -13.108  1.00 11.54           C
ATOM   1024  CB  ALA   122     -42.598  20.755 -14.509  1.00 12.24           C
ATOM   1025  C   ALA   122     -42.094  18.638 -13.234  1.00 11.86           C
ATOM   1026  O   ALA   122     -42.845  17.702 -13.488  1.00 12.38           O
ATOM   1027  N   SER   123     -40.780  18.499 -13.132  1.00 11.72           N
ATOM   1028  CA  SER   123     -40.140  17.174 -13.297  1.00 11.69           C
ATOM   1029  CB  SER   123     -38.597  17.220 -13.248  1.00 13.37           C
ATOM   1030  OG  SER   123     -38.136  17.620 -11.957  1.00 18.01           O
ATOM   1031  C   SER   123     -40.678  16.217 -12.222  1.00 11.56           C
ATOM   1032  O   SER   123     -40.889  15.041 -12.504  1.00 11.30           O
ATOM   1033  N   VAL   124     -40.862  16.719 -10.996  1.00 10.19           N
ATOM   1034  CA  VAL   124     -41.338  15.876  -9.883  1.00  9.66           C
ATOM   1035  CB  VAL   124     -41.121  16.603  -8.497  1.00 10.39           C
ATOM   1036  CG1 VAL   124     -41.817  15.860  -7.384  1.00 13.37           C
ATOM   1037  CG2 VAL   124     -39.640  16.694  -8.191  1.00 12.44           C
ATOM   1038  C   VAL   124     -42.808  15.523 -10.075  1.00 10.08           C
ATOM   1039  O   VAL   124     -43.218  14.350  -9.905  1.00  9.51           O
ATOM   1040  N   ILE   125     -43.617  16.526 -10.409  1.00  9.88           N
ATOM   1041  CA  ILE   125     -45.046  16.301 -10.630  1.00 10.74           C
ATOM   1042  CB  ILE   125     -45.803  17.624 -10.870  1.00 11.75           C
ATOM   1043  CG1 ILE   125     -45.744  18.498  -9.590  1.00  9.55           C
ATOM   1044  CD1 ILE   125     -46.274  17.830  -8.232  1.00 11.11           C
ATOM   1045  CG2 ILE   125     -47.298  17.363 -11.280  1.00 10.72           C
ATOM   1046  C   ILE   125     -45.254  15.309 -11.757  1.00 10.24           C
ATOM   1047  O   ILE   125     -46.088  14.386 -11.644  1.00 10.73           O
ATOM   1048  N   ARG   126     -44.483  15.459 -12.837  0.50 10.47           N
ATOM   1050  CA  ARG   126     -44.567  14.514 -13.947  0.50  9.91           C
ATOM   1052  CB  ARG   126     -43.607  14.907 -15.078  0.50  9.78           C
ATOM   1054  CG  ARG   126     -44.070  16.073 -15.874  0.50  8.97           C
ATOM   1056  CD  ARG   126     -43.145  16.305 -17.083  0.50 11.78           C
ATOM   1058  NE  ARG   126     -43.524  17.541 -17.757  0.50 13.41           N
ATOM   1060  CZ  ARG   126     -42.784  18.643 -17.773  0.50 18.19           C
ATOM   1062  NH1 ARG   126     -41.594  18.649 -17.187  0.50 18.32           N
ATOM   1064  NH2 ARG   126     -43.223  19.729 -18.401  0.50 20.28           N
ATOM   1066  C   ARG   126     -44.269  13.104 -13.483  0.50 10.39           C
ATOM   1068  O   ARG   126     -45.010  12.161 -13.806  0.50 11.26           O
ATOM   1070  N   LEU   127     -43.191  12.959 -12.717  1.00 10.18           N
ATOM   1071  CA  LEU   127     -42.747  11.653 -12.281  1.00 11.49           C
ATOM   1072  CB  LEU   127     -41.457  11.792 -11.470  1.00 12.45           C
ATOM   1073  CG  LEU   127     -40.836  10.551 -10.872  1.00 15.70           C
ATOM   1074  CD1 LEU   127     -40.489   9.503 -11.921  1.00 20.81           C
ATOM   1075  CD2 LEU   127     -39.573  10.988 -10.121  1.00 18.67           C
ATOM   1076  C   LEU   127     -43.864  10.955 -11.482  1.00  9.91           C
ATOM   1077  O   LEU   127     -44.173   9.757 -11.684  1.00 10.50           O
ATOM   1078  N   LEU   128     -44.458  11.703 -10.559  1.00  8.79           N
ATOM   1079  CA  LEU   128     -45.555  11.167  -9.751  1.00  9.28           C
ATOM   1080  CB  LEU   128     -45.959  12.213  -8.701  1.00  9.38           C
ATOM   1081  CG  LEU   128     -44.895  12.460  -7.628  1.00 11.13           C
ATOM   1082  CD1 LEU   128     -45.399  13.599  -6.743  1.00 11.82           C
ATOM   1083  CD2 LEU   128     -44.635  11.243  -6.755  1.00 13.49           C
ATOM   1084  C   LEU   128     -46.755  10.814 -10.630  1.00 10.57           C
ATOM   1085  O   LEU   128     -47.393   9.762 -10.464  1.00  8.87           O
ATOM   1086  N   ALA   129     -47.111  11.725 -11.531  1.00  9.99           N
ATOM   1087  CA  ALA   129     -48.264  11.513 -12.419  1.00 10.43           C
ATOM   1088  CB  ALA   129     -48.466  12.756 -13.298  1.00 10.04           C
ATOM   1089  C   ALA   129     -48.072  10.270 -13.290  1.00  9.53           C
ATOM   1090  O   ALA   129     -49.010   9.490 -13.509  1.00  9.22           O
ATOM   1091  N   GLU   130     -46.842  10.075 -13.777  1.00 10.54           N
ATOM   1092  CA  GLU   130     -46.555   8.883 -14.586  1.00 10.65           C
ATOM   1093  CB  GLU   130     -45.130   8.957 -15.080  1.00 11.71           C
ATOM   1094  CG  GLU   130     -45.015   9.922 -16.236  1.00 15.98           C
ATOM   1095  CD  GLU   130     -43.548  10.268 -16.577  1.00 25.12           C
ATOM   1096  OE1 GLU   130     -42.602   9.684 -15.991  1.00 26.80           O
ATOM   1097  OE2 GLU   130     -43.362  11.157 -17.432  1.00 30.61           O
ATOM   1098  C   GLU   130     -46.799   7.589 -13.828  1.00 10.74           C
ATOM   1099  O   GLU   130     -47.364   6.626 -14.382  1.00  9.75           O
ATOM   1100  N   SER   131     -46.395   7.580 -12.558  0.50 10.14           N
ATOM   1102  CA  SER   131     -46.583   6.411 -11.722  0.50 10.49           C
ATOM   1104  CB  SER   131     -45.843   6.578 -10.396  0.50 11.10           C
ATOM   1106  OG  SER   131     -45.705   5.328  -9.775  0.50 10.69           O
ATOM   1108  C   SER   131     -48.057   6.142 -11.458  0.50 10.47           C
ATOM   1110  O   SER   131     -48.497   4.991 -11.474  0.50  9.95           O
ATOM   1112  N   ILE   132     -48.806   7.214 -11.186  1.00  9.30           N
ATOM   1113  CA  ILE   132     -50.274   7.155 -11.007  1.00 10.27           C
ATOM   1114  CB  ILE   132     -50.819   8.528 -10.573  1.00 10.43           C
ATOM   1115  CG1 ILE   132     -50.217   8.879  -9.199  1.00 10.19           C
ATOM   1116  CD1 ILE   132     -50.537  10.321  -8.694  1.00 10.55           C
ATOM   1117  CG2 ILE   132     -52.352   8.522 -10.544  1.00 12.86           C
ATOM   1118  C   ILE   132     -50.956   6.643 -12.274  1.00 10.09           C
ATOM   1119  O   ILE   132     -51.855   5.784 -12.188  1.00  9.47           O
ATOM   1120  N   GLU   133     -50.535   7.164 -13.426  0.50 10.08           N
ATOM   1122  CA  GLU   133     -51.024   6.713 -14.732  0.50 10.68           C
ATOM   1124  CB  GLU   133     -50.390   7.549 -15.871  0.50 10.91           C
ATOM   1126  CG  GLU   133     -51.050   8.940 -16.009  0.50 12.45           C
ATOM   1128  CD  GLU   133     -50.193  10.029 -16.674  0.50 14.41           C
ATOM   1130  OE1 GLU   133     -48.998   9.781 -16.983  0.50 17.78           O
ATOM   1132  OE2 GLU   133     -50.748  11.144 -16.892  0.50 18.07           O
ATOM   1134  C   GLU   133     -50.823   5.208 -14.941  0.50  9.88           C
ATOM   1136  O   GLU   133     -51.712   4.518 -15.430  0.50 10.09           O
ATOM   1138  N   ALA   134     -49.659   4.695 -14.546  1.00  9.31           N
ATOM   1139  CA  ALA   134     -49.346   3.267 -14.674  1.00  9.01           C
ATOM   1140  CB  ALA   134     -47.869   3.011 -14.361  1.00  9.38           C
ATOM   1141  C   ALA   134     -50.237   2.445 -13.765  1.00  9.17           C
ATOM   1142  O   ALA   134     -50.720   1.372 -14.144  1.00  9.07           O
ATOM   1143  N   GLY   135     -50.446   2.954 -12.554  1.00  9.74           N
ATOM   1144  CA  GLY   135     -51.304   2.264 -11.598  1.00  9.68           C
ATOM   1145  C   GLY   135     -52.748   2.231 -12.081  1.00 10.54           C
ATOM   1146  O   GLY   135     -53.432   1.261 -11.841  1.00 11.18           O
ATOM   1147  N   MET   136     -53.212   3.294 -12.736  1.00 10.78           N
ATOM   1148  CA  MET   136     -54.550   3.319 -13.316  1.00 14.00           C
ATOM   1149  CB  MET   136     -54.856   4.709 -13.853  1.00 12.19           C
ATOM   1150  CG  MET   136     -55.025   5.738 -12.769  1.00 17.50           C
ATOM   1151  SD  MET   136     -55.390   7.532 -13.517  0.80 27.77          SE
ATOM   1152  CE  MET   136     -56.956   7.128 -14.509  1.00 24.50           C
ATOM   1153  C   MET   136     -54.690   2.274 -14.426  1.00 11.62           C
ATOM   1154  O   MET   136     -55.630   1.461 -14.414  1.00 11.88           O
ATOM   1155  N   THR   137     -53.704   2.228 -15.331  1.00 10.74           N
ATOM   1156  CA  THR   137     -53.673   1.197 -16.405  1.00  9.88           C
ATOM   1157  CB  THR   137     -52.401   1.371 -17.285  1.00  9.89           C
ATOM   1158  OG1 THR   137     -52.434   2.676 -17.872  1.00 11.23           O
ATOM   1159  CG2 THR   137     -52.311   0.289 -18.374  1.00 10.49           C
ATOM   1160  C   THR   137     -53.735  -0.220 -15.824  1.00  9.70           C
ATOM   1161  O   THR   137     -54.451  -1.096 -16.313  1.00  8.79           O
ATOM   1162  N   ARG   138     -53.012  -0.433 -14.737  1.00 10.06           N
ATOM   1163  CA  ARG   138     -52.962  -1.726 -14.092  1.00 10.50           C
ATOM   1164  CB  ARG   138     -51.753  -1.827 -13.178  1.00 10.22           C
ATOM   1165  CG  ARG   138     -50.421  -1.961 -13.926  1.00 11.00           C
ATOM   1166  CD  ARG   138     -49.267  -1.783 -12.921  1.00 11.40           C
ATOM   1167  NE  ARG   138     -49.385  -2.776 -11.860  1.00 13.48           N
ATOM   1168  CZ  ARG   138     -48.694  -2.749 -10.731  1.00 16.65           C
ATOM   1169  NH1 ARG   138     -47.798  -1.778 -10.519  1.00 13.97           N
ATOM   1170  NH2 ARG   138     -48.909  -3.699  -9.812  1.00 18.04           N
ATOM   1171  C   ARG   138     -54.233  -2.088 -13.308  1.00 11.15           C
ATOM   1172  O   ARG   138     -54.391  -3.238 -12.908  1.00 11.80           O
ATOM   1173  N   GLY   139     -55.117  -1.122 -13.103  1.00 12.43           N
ATOM   1174  CA  GLY   139     -56.308  -1.342 -12.309  1.00 12.85           C
ATOM   1175  C   GLY   139     -56.098  -1.206 -10.803  1.00 14.77           C
ATOM   1176  O   GLY   139     -57.031  -1.500 -10.021  1.00 15.21           O
ATOM   1177  N   LEU   140     -54.904  -0.785 -10.370  1.00 14.40           N
ATOM   1178  CA  LEU   140     -54.663  -0.525  -8.930  1.00 15.70           C
ATOM   1179  CB  LEU   140     -53.175  -0.325  -8.608  1.00 17.02           C
ATOM   1180  CG  LEU   140     -52.165  -1.407  -8.937  1.00 20.06           C
ATOM   1181  CD1 LEU   140     -50.855  -0.921  -8.327  1.00 24.89           C
ATOM   1182  CD2 LEU   140     -52.585  -2.711  -8.319  1.00 24.25           C
ATOM   1183  C   LEU   140     -55.356   0.744  -8.489  1.00 14.92           C
ATOM   1184  O   LEU   140     -55.818   0.834  -7.342  1.00 14.43           O
ATOM   1185  N   PHE   141     -55.378   1.734  -9.384  1.00 13.97           N
ATOM   1186  CA  PHE   141     -55.934   3.051  -9.092  1.00 15.04           C
ATOM   1187  CB  PHE   141     -54.894   4.159  -9.339  1.00 13.91           C
ATOM   1188  CG  PHE   141     -53.627   4.016  -8.510  1.00 13.77           C
ATOM   1189  CD1 PHE   141     -53.668   3.442  -7.227  1.00 13.85           C
ATOM   1190  CE1 PHE   141     -52.491   3.310  -6.463  1.00 13.85           C
ATOM   1191  CZ  PHE   141     -51.267   3.776  -7.000  1.00 12.20           C
ATOM   1192  CE2 PHE   141     -51.240   4.341  -8.294  1.00 10.44           C
ATOM   1193  CD2 PHE   141     -52.392   4.479  -9.011  1.00 12.75           C
ATOM   1194  C   PHE   141     -57.151   3.307  -9.951  1.00 15.74           C
ATOM   1195  O   PHE   141     -57.249   2.777 -11.067  1.00 14.26           O
ATOM   1196  N   ARG   142     -58.074   4.120  -9.443  0.50 16.15           N
ATOM   1198  CA  ARG   142     -59.333   4.428 -10.124  0.50 17.47           C
ATOM   1200  CB  ARG   142     -60.256   5.250  -9.227  0.50 17.67           C
ATOM   1202  CG  ARG   142     -60.907   4.514  -8.115  0.50 18.73           C
ATOM   1204  CD  ARG   142     -61.871   5.446  -7.428  0.50 20.28           C
ATOM   1206  NE  ARG   142     -61.191   6.543  -6.744  0.50 20.28           N
ATOM   1208  CZ  ARG   142     -61.802   7.632  -6.287  0.50 20.99           C
ATOM   1210  NH1 ARG   142     -63.104   7.797  -6.474  0.50 17.88           N
ATOM   1212  NH2 ARG   142     -61.099   8.580  -5.668  0.50 20.92           N
ATOM   1214  C   ARG   142     -59.126   5.255 -11.374  0.50 17.70           C
ATOM   1216  O   ARG   142     -58.339   6.198 -11.388  0.50 18.50           O
ATOM   1218  N   ARG   143     -59.912   4.938 -12.395  1.00 18.41           N
ATOM   1219  CA  ARG   143     -59.747   5.554 -13.691  1.00 19.17           C
ATOM   1220  CB  ARG   143     -60.007   4.550 -14.785  1.00 19.39           C
ATOM   1221  CG  ARG   143     -58.965   3.434 -14.827  1.00 22.29           C
ATOM   1222  CD  ARG   143     -59.450   2.272 -15.677  1.00 26.49           C
ATOM   1223  NE  ARG   143     -58.403   1.273 -15.895  1.00 30.12           N
ATOM   1224  CZ  ARG   143     -58.545  -0.047 -15.757  1.00 31.21           C
ATOM   1225  NH1 ARG   143     -59.715  -0.594 -15.415  1.00 32.67           N
ATOM   1226  NH2 ARG   143     -57.502  -0.838 -15.984  1.00 31.42           N
ATOM   1227  C   ARG   143     -60.507   6.857 -13.893  1.00 18.83           C
ATOM   1228  O   ARG   143     -60.315   7.510 -14.913  1.00 20.12           O
ATOM   1229  N   ASP   144     -61.324   7.254 -12.917  1.00 17.76           N
ATOM   1230  CA  ASP   144     -62.025   8.547 -12.977  1.00 16.37           C
ATOM   1231  CB  ASP   144     -63.426   8.450 -12.354  1.00 16.63           C
ATOM   1232  CG  ASP   144     -63.395   8.116 -10.877  1.00 17.52           C
ATOM   1233  OD1 ASP   144     -62.398   7.530 -10.424  1.00 17.03           O
ATOM   1234  OD2 ASP   144     -64.383   8.426 -10.159  1.00 20.81           O
ATOM   1235  C   ASP   144     -61.281   9.716 -12.339  1.00 15.58           C
ATOM   1236  O   ASP   144     -61.871  10.803 -12.135  1.00 16.22           O
ATOM   1237  N   LEU   145     -60.024   9.520 -11.954  0.50 14.65           N
ATOM   1239  CA  LEU   145     -59.257  10.650 -11.435  0.50 13.62           C
ATOM   1241  CB  LEU   145     -58.748  10.426 -10.005  0.50 13.58           C
ATOM   1243  CG  LEU   145     -59.708  10.249  -8.827  0.50 13.00           C
ATOM   1245  CD1 LEU   145     -58.863   9.721  -7.686  0.50 13.60           C
ATOM   1247  CD2 LEU   145     -60.478  11.539  -8.398  0.50 13.09           C
ATOM   1249  C   LEU   145     -58.106  10.962 -12.376  0.50 13.00           C
ATOM   1251  O   LEU   145     -57.581  10.079 -13.050  0.50 12.96           O
ATOM   1253  N   HIS   146     -57.762  12.235 -12.428  1.00 12.38           N
ATOM   1254  CA  HIS   146     -56.767  12.749 -13.335  1.00 11.72           C
ATOM   1255  CB  HIS   146     -57.099  14.174 -13.754  1.00 13.12           C
ATOM   1256  CG  HIS   146     -58.088  14.223 -14.890  1.00 18.87           C
ATOM   1257  ND1 HIS   146     -59.407  14.593 -14.717  1.00 23.34           N
ATOM   1258  CE1 HIS   146     -60.041  14.495 -15.875  1.00 23.61           C
ATOM   1259  NE2 HIS   146     -59.189  14.056 -16.787  1.00 22.78           N
ATOM   1260  CD2 HIS   146     -57.966  13.859 -16.194  1.00 21.18           C
ATOM   1261  C   HIS   146     -55.432  12.632 -12.658  1.00  9.97           C
ATOM   1262  O   HIS   146     -55.283  13.064 -11.523  1.00  8.48           O
ATOM   1263  N   ALA   147     -54.466  12.063 -13.380  1.00  8.06           N
ATOM   1264  CA  ALA   147     -53.171  11.743 -12.792  1.00  7.43           C
ATOM   1265  CB  ALA   147     -52.303  10.976 -13.795  1.00  7.64           C
ATOM   1266  C   ALA   147     -52.415  12.975 -12.255  1.00  7.37           C
ATOM   1267  O   ALA   147     -51.892  12.935 -11.149  1.00  7.42           O
ATOM   1268  N   VAL   148     -52.323  14.040 -13.057  1.00  5.91           N
ATOM   1269  CA  VAL   148     -51.580  15.234 -12.596  1.00  5.28           C
ATOM   1270  CB  VAL   148     -51.376  16.285 -13.741  1.00  5.29           C
ATOM   1271  CG1 VAL   148     -50.894  17.623 -13.160  1.00  5.38           C
ATOM   1272  CG2 VAL   148     -50.385  15.716 -14.827  1.00  7.18           C
ATOM   1273  C   VAL   148     -52.285  15.874 -11.417  1.00  5.21           C
ATOM   1274  O   VAL   148     -51.641  16.225 -10.424  1.00  4.80           O
ATOM   1275  N   ASN   149     -53.605  16.034 -11.475  1.00  5.51           N
ATOM   1276  CA  ASN   149     -54.259  16.664 -10.322  1.00  5.65           C
ATOM   1277  CB  ASN   149     -55.765  16.822 -10.566  1.00  6.66           C
ATOM   1278  CG  ASN   149     -56.088  18.026 -11.409  1.00 10.17           C
ATOM   1279  OD1 ASN   149     -55.200  18.846 -11.725  1.00 12.80           O
ATOM   1280  ND2 ASN   149     -57.358  18.143 -11.798  1.00 12.10           N
ATOM   1281  C   ASN   149     -54.045  15.842  -9.043  1.00  6.11           C
ATOM   1282  O   ASN   149     -53.933  16.413  -7.953  1.00  4.78           O
ATOM   1283  N   SER   150     -53.988  14.513  -9.207  1.00  5.76           N
ATOM   1284  CA  SER   150     -53.748  13.564  -8.084  1.00  6.08           C
ATOM   1285  CB  SER   150     -54.027  12.096  -8.522  1.00  5.78           C
ATOM   1286  OG  SER   150     -55.422  11.927  -8.837  1.00  7.08           O
ATOM   1287  C   SER   150     -52.331  13.717  -7.550  1.00  5.66           C
ATOM   1288  O   SER   150     -52.119  13.810  -6.341  1.00  5.57           O
ATOM   1289  N   ALA   151     -51.349  13.768  -8.451  1.00  5.77           N
ATOM   1290  CA  ALA   151     -49.966  14.064  -8.076  1.00  5.41           C
ATOM   1291  CB  ALA   151     -49.086  14.156  -9.326  1.00  5.18           C
ATOM   1292  C   ALA   151     -49.874  15.386  -7.279  1.00  5.91           C
ATOM   1293  O   ALA   151     -49.179  15.466  -6.262  1.00  6.61           O
ATOM   1294  N   LEU   152     -50.552  16.425  -7.784  1.00  6.31           N
ATOM   1295  CA  LEU   152     -50.534  17.749  -7.110  1.00  5.72           C
ATOM   1296  CB  LEU   152     -51.297  18.807  -7.921  1.00  4.81           C
ATOM   1297  CG  LEU   152     -50.598  19.222  -9.218  1.00  4.27           C
ATOM   1298  CD1 LEU   152     -51.572  20.071 -10.072  1.00  6.58           C
ATOM   1299  CD2 LEU   152     -49.276  20.001  -8.973  1.00  5.18           C
ATOM   1300  C   LEU   152     -51.132  17.647  -5.707  1.00  7.70           C
ATOM   1301  O   LEU   152     -50.626  18.296  -4.766  1.00  7.69           O
ATOM   1302  N   ALA   153     -52.188  16.836  -5.551  1.00  6.37           N
ATOM   1303  CA  ALA   153     -52.794  16.600  -4.245  1.00  7.16           C
ATOM   1304  CB  ALA   153     -54.029  15.679  -4.378  1.00  5.65           C
ATOM   1305  C   ALA   153     -51.787  16.008  -3.247  1.00  7.42           C
ATOM   1306  O   ALA   153     -51.667  16.511  -2.117  1.00  6.88           O
ATOM   1307  N   LEU   154     -51.039  14.972  -3.683  1.00  5.98           N
ATOM   1308  CA  LEU   154     -50.031  14.354  -2.805  1.00  5.94           C
ATOM   1309  CB  LEU   154     -49.453  13.092  -3.458  1.00  6.06           C
ATOM   1310  CG  LEU   154     -48.400  12.364  -2.617  1.00  6.43           C
ATOM   1311  CD1 LEU   154     -48.990  11.876  -1.271  1.00  5.45           C
ATOM   1312  CD2 LEU   154     -47.790  11.240  -3.434  1.00  7.02           C
ATOM   1313  C   LEU   154     -48.921  15.373  -2.447  1.00  5.85           C
ATOM   1314  O   LEU   154     -48.530  15.518  -1.271  1.00  6.15           O
ATOM   1315  N   ALA   155     -48.449  16.084  -3.464  1.00  6.37           N
ATOM   1316  CA  ALA   155     -47.402  17.083  -3.242  1.00  6.90           C
ATOM   1317  CB  ALA   155     -46.984  17.689  -4.593  1.00  7.15           C
ATOM   1318  C   ALA   155     -47.927  18.147  -2.260  1.00  6.59           C
ATOM   1319  O   ALA   155     -47.181  18.625  -1.387  1.00  7.17           O
ATOM   1320  N   GLY   156     -49.204  18.510  -2.409  1.00  6.53           N
ATOM   1321  CA  GLY   156     -49.808  19.558  -1.574  1.00  7.23           C
ATOM   1322  C   GLY   156     -49.903  19.117  -0.129  1.00  8.33           C
ATOM   1323  O   GLY   156     -49.684  19.935   0.770  1.00  9.18           O
ATOM   1324  N   MET   157     -50.275  17.857   0.104  0.50  7.22           N
ATOM   1326  CA  MET   157     -50.394  17.342   1.473  0.50  9.40           C
ATOM   1328  CB  MET   157     -50.608  15.818   1.495  0.50  9.03           C
ATOM   1330  CG  MET   157     -51.950  15.368   1.037  0.50 10.44           C
ATOM   1332  SD  MET   157     -52.121  13.470   1.490  0.50 14.75          SE
ATOM   1334  CE  MET   157     -53.565  13.043   0.240  0.50 11.36           C
ATOM   1336  C   MET   157     -49.104  17.647   2.216  0.50  8.33           C
ATOM   1338  O   MET   157     -49.097  18.375   3.226  0.50  7.60           O
ATOM   1340  N   VAL   158     -48.020  17.067   1.700  1.00  7.62           N
ATOM   1341  CA  VAL   158     -46.738  17.073   2.389  1.00  7.60           C
ATOM   1342  CB  VAL   158     -45.769  16.001   1.870  1.00  7.87           C
ATOM   1343  CG1 VAL   158     -45.363  16.267   0.375  1.00  6.80           C
ATOM   1344  CG2 VAL   158     -44.556  15.904   2.800  1.00  5.50           C
ATOM   1345  C   VAL   158     -46.161  18.504   2.448  1.00  8.05           C
ATOM   1346  O   VAL   158     -45.655  18.951   3.498  1.00  7.94           O
ATOM   1347  N   ASN   159     -46.268  19.258   1.359  1.00  6.99           N
ATOM   1348  CA  ASN   159     -45.679  20.596   1.364  1.00  8.56           C
ATOM   1349  CB  ASN   159     -45.517  21.063  -0.110  1.00  9.44           C
ATOM   1350  CG  ASN   159     -44.267  20.391  -0.770  1.00 13.46           C
ATOM   1351  OD1 ASN   159     -43.115  20.774  -0.449  1.00 13.49           O
ATOM   1352  ND2 ASN   159     -44.491  19.365  -1.676  1.00 11.04           N
ATOM   1353  C   ASN   159     -46.491  21.532   2.299  1.00  8.55           C
ATOM   1354  O   ASN   159     -45.898  22.350   3.007  1.00  8.77           O
ATOM   1355  N   TYR   160     -47.807  21.324   2.393  1.00  8.99           N
ATOM   1356  CA  TYR   160     -48.598  22.206   3.289  1.00  8.46           C
ATOM   1357  CB  TYR   160     -50.076  22.031   3.041  1.00  9.05           C
ATOM   1358  CG  TYR   160     -50.895  23.089   3.758  1.00  6.76           C
ATOM   1359  CD1 TYR   160     -51.004  24.373   3.254  1.00  6.16           C
ATOM   1360  CE1 TYR   160     -51.755  25.374   3.951  1.00  6.68           C
ATOM   1361  CZ  TYR   160     -52.367  25.032   5.159  1.00  6.05           C
ATOM   1362  OH  TYR   160     -53.125  25.927   5.884  1.00  6.88           O
ATOM   1363  CE2 TYR   160     -52.260  23.729   5.663  1.00  7.56           C
ATOM   1364  CD2 TYR   160     -51.513  22.779   4.968  1.00  8.31           C
ATOM   1365  C   TYR   160     -48.297  21.873   4.749  1.00  8.41           C
ATOM   1366  O   TYR   160     -48.341  22.775   5.600  1.00  7.66           O
ATOM   1367  N   PHE   161     -48.025  20.596   5.064  1.00  7.26           N
ATOM   1368  CA  PHE   161     -47.662  20.273   6.467  1.00  7.86           C
ATOM   1369  CB  PHE   161     -47.311  18.790   6.604  1.00  7.74           C
ATOM   1370  CG  PHE   161     -46.983  18.392   7.998  1.00  9.30           C
ATOM   1371  CD1 PHE   161     -48.006  18.107   8.896  1.00 12.83           C
ATOM   1372  CE1 PHE   161     -47.720  17.697  10.215  1.00 11.42           C
ATOM   1373  CZ  PHE   161     -46.391  17.641  10.657  1.00 12.71           C
ATOM   1374  CE2 PHE   161     -45.357  17.968   9.769  1.00 10.83           C
ATOM   1375  CD2 PHE   161     -45.666  18.335   8.433  1.00 11.04           C
ATOM   1376  C   PHE   161     -46.491  21.148   6.954  1.00  7.95           C
ATOM   1377  O   PHE   161     -46.543  21.724   8.066  1.00  9.32           O
ATOM   1378  N   PHE   162     -45.463  21.301   6.114  1.00  6.72           N
ATOM   1379  CA  PHE   162     -44.318  22.124   6.507  1.00  7.65           C
ATOM   1380  CB  PHE   162     -43.078  21.726   5.710  1.00  7.99           C
ATOM   1381  CG  PHE   162     -42.566  20.366   6.105  1.00  9.27           C
ATOM   1382  CD1 PHE   162     -41.714  20.225   7.191  1.00 10.78           C
ATOM   1383  CE1 PHE   162     -41.239  18.956   7.593  1.00 11.91           C
ATOM   1384  CZ  PHE   162     -41.634  17.827   6.904  1.00 11.69           C
ATOM   1385  CE2 PHE   162     -42.511  17.965   5.784  1.00 13.79           C
ATOM   1386  CD2 PHE   162     -42.967  19.220   5.412  1.00 10.23           C
ATOM   1387  C   PHE   162     -44.639  23.608   6.400  1.00  6.36           C
ATOM   1388  O   PHE   162     -44.272  24.414   7.281  1.00  6.77           O
ATOM   1389  N   LEU   163     -45.339  23.986   5.329  1.00  6.53           N
ATOM   1390  CA  LEU   163     -45.685  25.410   5.150  1.00  6.76           C
ATOM   1391  CB  LEU   163     -46.531  25.576   3.876  1.00  6.66           C
ATOM   1392  CG  LEU   163     -46.960  27.017   3.573  1.00  7.04           C
ATOM   1393  CD1 LEU   163     -45.732  27.937   3.372  1.00  9.53           C
ATOM   1394  CD2 LEU   163     -47.878  27.026   2.294  1.00  8.47           C
ATOM   1395  C   LEU   163     -46.462  25.968   6.327  1.00  6.16           C
ATOM   1396  O   LEU   163     -46.251  27.132   6.716  1.00  6.46           O
ATOM   1397  N   SER   164     -47.398  25.156   6.872  1.00  5.30           N
ATOM   1398  CA  SER   164     -48.338  25.682   7.889  1.00  7.61           C
ATOM   1399  CB  SER   164     -49.657  24.912   7.802  1.00  8.19           C
ATOM   1400  OG  SER   164     -49.459  23.552   8.139  1.00  9.73           O
ATOM   1401  C   SER   164     -47.773  25.574   9.326  1.00  7.56           C
ATOM   1402  O   SER   164     -48.479  25.903  10.294  1.00  8.21           O
ATOM   1403  N   THR   165     -46.511  25.154   9.458  1.00  5.79           N
ATOM   1404  CA  THR   165     -45.964  24.822  10.782  1.00  6.26           C
ATOM   1405  CB  THR   165     -44.424  24.572  10.701  1.00  6.23           C
ATOM   1406  OG1 THR   165     -44.184  23.428   9.866  1.00  7.44           O
ATOM   1407  CG2 THR   165     -43.891  24.259  12.117  1.00  8.11           C
ATOM   1408  C   THR   165     -46.186  25.914  11.821  1.00  4.75           C
ATOM   1409  O   THR   165     -46.641  25.626  12.936  1.00  5.25           O
ATOM   1410  N   LEU   166     -45.844  27.165  11.481  1.00  5.75           N
ATOM   1411  CA  LEU   166     -45.911  28.235  12.482  1.00  6.51           C
ATOM   1412  CB  LEU   166     -45.339  29.576  11.965  1.00  6.68           C
ATOM   1413  CG  LEU   166     -43.841  29.678  11.719  1.00 10.81           C
ATOM   1414  CD1 LEU   166     -43.547  31.167  11.394  1.00 11.81           C
ATOM   1415  CD2 LEU   166     -43.055  29.293  13.016  1.00 11.69           C
ATOM   1416  C   LEU   166     -47.337  28.456  12.986  1.00  7.46           C
ATOM   1417  O   LEU   166     -47.491  28.973  14.095  1.00  8.56           O
ATOM   1418  N   ALA   167     -48.369  28.123  12.171  1.00  6.08           N
ATOM   1419  CA  ALA   167     -49.766  28.384  12.541  1.00  8.18           C
ATOM   1420  CB  ALA   167     -50.626  28.722  11.311  1.00  7.47           C
ATOM   1421  C   ALA   167     -50.387  27.203  13.251  1.00  8.91           C
ATOM   1422  O   ALA   167     -51.532  27.304  13.723  1.00  9.05           O
ATOM   1423  N   THR   168     -49.662  26.096  13.285  1.00  8.62           N
ATOM   1424  CA  THR   168     -50.264  24.857  13.794  1.00 10.98           C
ATOM   1425  CB  THR   168     -50.502  23.867  12.644  1.00  9.39           C
ATOM   1426  OG1 THR   168     -49.275  23.508  11.993  1.00 11.50           O
ATOM   1427  CG2 THR   168     -51.464  24.477  11.542  1.00  9.79           C
ATOM   1428  C   THR   168     -49.423  24.220  14.919  1.00 10.56           C
ATOM   1429  O   THR   168     -49.522  22.997  15.158  1.00 11.79           O
ATOM   1430  N   GLU   169     -48.671  25.069  15.639  1.00 13.47           N
ATOM   1431  CA  GLU   169     -47.634  24.567  16.568  1.00 14.51           C
ATOM   1432  CB  GLU   169     -46.793  25.705  17.190  1.00 15.58           C
ATOM   1433  CG  GLU   169     -45.950  26.533  16.217  1.00 16.67           C
ATOM   1434  CD  GLU   169     -44.641  25.858  15.769  1.00 18.06           C
ATOM   1435  OE1 GLU   169     -44.427  24.660  16.046  1.00 20.34           O
ATOM   1436  OE2 GLU   169     -43.824  26.515  15.088  1.00 17.77           O
ATOM   1437  C   GLU   169     -48.280  23.732  17.661  1.00 14.80           C
ATOM   1438  O   GLU   169     -47.758  22.662  18.045  1.00 15.84           O
ATOM   1439  N   GLY   170     -49.391  24.218  18.188  1.00 14.31           N
ATOM   1440  CA  GLY   170     -50.050  23.519  19.293  1.00 15.34           C
ATOM   1441  C   GLY   170     -51.115  22.570  18.807  1.00 14.96           C
ATOM   1442  O   GLY   170     -51.802  21.946  19.628  1.00 15.30           O
ATOM   1443  N   LEU   171     -51.257  22.405  17.486  1.00 11.97           N
ATOM   1444  CA  LEU   171     -52.364  21.571  16.985  1.00 12.07           C
ATOM   1445  CB  LEU   171     -53.048  22.173  15.739  1.00 11.20           C
ATOM   1446  CG  LEU   171     -53.567  23.620  15.751  1.00 13.56           C
ATOM   1447  CD1 LEU   171     -54.356  23.917  14.477  1.00 12.40           C
ATOM   1448  CD2 LEU   171     -54.410  23.968  16.985  1.00 16.09           C
ATOM   1449  C   LEU   171     -51.901  20.179  16.629  1.00 12.32           C
ATOM   1450  O   LEU   171     -52.706  19.251  16.620  1.00 12.27           O
ATOM   1451  N   THR   172     -50.620  20.021  16.304  1.00 11.32           N
ATOM   1452  CA  THR   172     -50.093  18.690  15.929  1.00 12.36           C
ATOM   1453  CB  THR   172     -50.439  18.296  14.451  1.00 11.94           C
ATOM   1454  OG1 THR   172     -50.076  16.907  14.240  1.00 16.35           O
ATOM   1455  CG2 THR   172     -49.710  19.217  13.452  1.00 12.29           C
ATOM   1456  C   THR   172     -48.585  18.711  16.141  1.00 12.72           C
ATOM   1457  O   THR   172     -47.994  19.812  16.226  1.00 13.87           O
ATOM   1458  N   SER   173     -47.958  17.545  16.214  1.00 12.97           N
ATOM   1459  CA  SER   173     -46.524  17.503  16.397  1.00 11.93           C
ATOM   1460  CB  SER   173     -46.103  16.108  16.826  1.00 13.97           C
ATOM   1461  OG  SER   173     -44.681  15.989  16.771  1.00 14.44           O
ATOM   1462  C   SER   173     -45.874  17.806  15.060  1.00 12.33           C
ATOM   1463  O   SER   173     -46.353  17.332  14.028  1.00 12.42           O
ATOM   1464  N   HIS   174     -44.824  18.610  15.068  1.00 12.00           N
ATOM   1465  CA  HIS   174     -43.970  18.721  13.876  1.00 14.23           C
ATOM   1466  CB  HIS   174     -43.909  20.171  13.391  1.00 14.23           C
ATOM   1467  CG  HIS   174     -45.247  20.722  13.030  1.00 15.81           C
ATOM   1468  ND1 HIS   174     -46.071  21.324  13.968  1.00 16.61           N
ATOM   1469  CE1 HIS   174     -47.185  21.718  13.368  1.00 20.91           C
ATOM   1470  NE2 HIS   174     -47.116  21.386  12.085  1.00 19.63           N
ATOM   1471  CD2 HIS   174     -45.900  20.785  11.839  1.00 17.42           C
ATOM   1472  C   HIS   174     -42.578  18.183  14.149  1.00 13.15           C
ATOM   1473  O   HIS   174     -41.625  18.515  13.427  1.00 14.79           O
ATOM   1474  N   SER   175     -42.456  17.352  15.179  1.00 14.28           N
ATOM   1475  CA  SER   175     -41.158  16.794  15.566  1.00 13.71           C
ATOM   1476  CB  SER   175     -41.281  16.104  16.921  1.00 14.35           C
ATOM   1477  OG  SER   175     -40.255  15.138  17.113  1.00 17.37           O
ATOM   1478  C   SER   175     -40.645  15.822  14.475  1.00 13.44           C
ATOM   1479  O   SER   175     -41.412  15.024  13.953  1.00 12.58           O
ATOM   1480  N   PRO   176     -39.341  15.882  14.146  1.00 13.15           N
ATOM   1481  CA  PRO   176     -38.830  14.880  13.178  1.00 13.22           C
ATOM   1482  CB  PRO   176     -37.342  15.224  13.064  1.00 13.70           C
ATOM   1483  CG  PRO   176     -37.228  16.655  13.534  1.00 13.98           C
ATOM   1484  CD  PRO   176     -38.278  16.806  14.593  1.00 13.08           C
ATOM   1485  C   PRO   176     -39.045  13.413  13.624  1.00 14.24           C
ATOM   1486  O   PRO   176     -39.154  12.527  12.770  1.00 13.21           O
ATOM   1487  N   ASP   177     -39.134  13.171  14.936  1.00 14.82           N
ATOM   1488  CA  ASP   177     -39.514  11.855  15.496  1.00 16.58           C
ATOM   1489  CB  ASP   177     -39.811  11.976  17.000  1.00 17.92           C
ATOM   1490  CG  ASP   177     -38.610  12.345  17.796  1.00 24.07           C
ATOM   1491  OD1 ASP   177     -37.500  12.389  17.204  1.00 30.89           O
ATOM   1492  OD2 ASP   177     -38.764  12.562  19.024  1.00 30.05           O
ATOM   1493  C   ASP   177     -40.780  11.270  14.887  1.00 15.97           C
ATOM   1494  O   ASP   177     -40.967  10.047  14.905  1.00 16.38           O
ATOM   1495  N   GLN   178     -41.655  12.147  14.404  1.00 14.77           N
ATOM   1496  CA  GLN   178     -42.965  11.735  13.923  1.00 15.23           C
ATOM   1497  CB  GLN   178     -44.057  12.637  14.515  1.00 16.28           C
ATOM   1498  CG  GLN   178     -44.212  12.558  16.075  1.00 18.38           C
ATOM   1499  CD  GLN   178     -44.416  11.148  16.555  1.00 24.89           C
ATOM   1500  OE1 GLN   178     -45.323  10.454  16.094  1.00 28.81           O
ATOM   1501  NE2 GLN   178     -43.556  10.694  17.466  1.00 23.68           N
ATOM   1502  C   GLN   178     -43.060  11.731  12.390  1.00 14.33           C
ATOM   1503  O   GLN   178     -44.153  11.563  11.837  1.00 14.25           O
ATOM   1504  N   ASP   179     -41.935  11.946  11.715  1.00 13.75           N
ATOM   1505  CA  ASP   179     -41.931  12.025  10.241  1.00 12.28           C
ATOM   1506  CB  ASP   179     -40.565  12.503   9.712  1.00 12.21           C
ATOM   1507  CG  ASP   179     -40.345  14.003   9.887  1.00 12.00           C
ATOM   1508  OD1 ASP   179     -41.340  14.728  10.133  1.00 12.73           O
ATOM   1509  OD2 ASP   179     -39.178  14.458   9.767  1.00 10.97           O
ATOM   1510  C   ASP   179     -42.333  10.695   9.583  1.00 12.43           C
ATOM   1511  O   ASP   179     -43.076  10.688   8.586  1.00 11.55           O
ATOM   1512  N   GLU   180     -41.873   9.564  10.129  1.00 12.85           N
ATOM   1513  CA  GLU   180     -42.244   8.281   9.539  1.00 13.39           C
ATOM   1514  CB  GLU   180     -41.363   7.129  10.047  1.00 14.36           C
ATOM   1515  CG  GLU   180     -39.961   7.112   9.416  1.00 16.71           C
ATOM   1516  CD  GLU   180     -39.971   6.815   7.917  1.00 18.99           C
ATOM   1517  OE1 GLU   180     -40.744   5.922   7.502  1.00 20.42           O
ATOM   1518  OE2 GLU   180     -39.200   7.469   7.161  1.00 18.63           O
ATOM   1519  C   GLU   180     -43.734   8.019   9.746  1.00 13.71           C
ATOM   1520  O   GLU   180     -44.403   7.448   8.873  1.00 13.28           O
ATOM   1521  N   GLU   181     -44.271   8.460  10.883  1.00 13.78           N
ATOM   1522  CA  GLU   181     -45.689   8.305  11.124  1.00 14.42           C
ATOM   1523  CB  GLU   181     -45.998   8.599  12.588  1.00 16.10           C
ATOM   1524  CG  GLU   181     -47.472   8.632  12.901  1.00 21.01           C
ATOM   1525  CD  GLU   181     -48.173   7.282  12.774  1.00 23.11           C
ATOM   1526  OE1 GLU   181     -47.514   6.228  12.665  1.00 24.17           O
ATOM   1527  OE2 GLU   181     -49.422   7.301  12.790  1.00 25.06           O
ATOM   1528  C   GLU   181     -46.494   9.212  10.185  1.00 14.14           C
ATOM   1529  O   GLU   181     -47.564   8.828   9.706  1.00 14.26           O
ATOM   1530  N   LEU   182     -45.956  10.396   9.878  1.00 13.08           N
ATOM   1531  CA  LEU   182     -46.604  11.293   8.915  1.00 13.64           C
ATOM   1532  CB  LEU   182     -45.865  12.643   8.831  1.00 12.83           C
ATOM   1533  CG  LEU   182     -46.579  13.680   7.940  1.00 14.91           C
ATOM   1534  CD1 LEU   182     -47.863  14.196   8.590  1.00 15.08           C
ATOM   1535  CD2 LEU   182     -45.644  14.827   7.575  1.00 15.95           C
ATOM   1536  C   LEU   182     -46.678  10.637   7.522  1.00 13.14           C
ATOM   1537  O   LEU   182     -47.718  10.661   6.855  1.00 14.11           O
ATOM   1538  N   ILE   183     -45.576  10.050   7.084  1.00 12.68           N
ATOM   1539  CA  ILE   183     -45.564   9.306   5.810  1.00 11.35           C
ATOM   1540  CB  ILE   183     -44.189   8.673   5.546  1.00 10.84           C
ATOM   1541  CG1 ILE   183     -43.122   9.766   5.347  1.00 12.02           C
ATOM   1542  CD1 ILE   183     -41.658   9.195   5.429  1.00 11.23           C
ATOM   1543  CG2 ILE   183     -44.228   7.768   4.309  1.00 11.12           C
ATOM   1544  C   ILE   183     -46.664   8.205   5.800  1.00 11.45           C
ATOM   1545  O   ILE   183     -47.422   8.086   4.830  1.00 10.62           O
ATOM   1546  N   ARG   184     -46.735   7.438   6.884  0.50 11.53           N
ATOM   1548  CA  ARG   184     -47.720   6.369   7.046  0.50 11.75           C
ATOM   1550  CB  ARG   184     -47.569   5.750   8.435  0.50 12.01           C
ATOM   1552  CG  ARG   184     -47.839   4.275   8.512  0.50 14.69           C
ATOM   1554  CD  ARG   184     -47.348   3.699   9.852  0.50 17.23           C
ATOM   1556  NE  ARG   184     -45.897   3.490   9.822  0.50 20.38           N
ATOM   1558  CZ  ARG   184     -45.023   3.988  10.695  0.50 19.61           C
ATOM   1560  NH1 ARG   184     -43.738   3.716  10.523  0.50 21.24           N
ATOM   1562  NH2 ARG   184     -45.415   4.720  11.740  0.50 16.19           N
ATOM   1564  C   ARG   184     -49.137   6.937   6.888  0.50 11.09           C
ATOM   1566  O   ARG   184     -49.974   6.363   6.185  0.50 10.52           O
ATOM   1568  N   GLN   185     -49.387   8.070   7.541  1.00 10.20           N
ATOM   1569  CA  GLN   185     -50.693   8.718   7.492  1.00 11.34           C
ATOM   1570  CB  GLN   185     -50.812   9.832   8.557  1.00 11.76           C
ATOM   1571  CG  GLN   185     -50.910   9.329   9.971  1.00 13.90           C
ATOM   1572  CD  GLN   185     -50.827  10.475  10.988  1.00 16.31           C
ATOM   1573  OE1 GLN   185     -51.146  11.627  10.670  1.00 24.88           O
ATOM   1574  NE2 GLN   185     -50.379  10.163  12.192  1.00 22.00           N
ATOM   1575  C   GLN   185     -51.069   9.294   6.120  1.00 10.79           C
ATOM   1576  O   GLN   185     -52.231   9.134   5.675  1.00 10.92           O
ATOM   1577  N   TYR   186     -50.095   9.901   5.436  1.00  9.48           N
ATOM   1578  CA  TYR   186     -50.375  10.550   4.165  1.00 10.97           C
ATOM   1579  CB  TYR   186     -49.386  11.701   3.929  1.00 11.73           C
ATOM   1580  CG  TYR   186     -49.831  12.983   4.689  1.00 11.89           C
ATOM   1581  CD1 TYR   186     -50.901  12.943   5.618  1.00 16.50           C
ATOM   1582  CE1 TYR   186     -51.319  14.116   6.323  1.00 16.69           C
ATOM   1583  CZ  TYR   186     -50.665  15.304   6.104  1.00 15.60           C
ATOM   1584  OH  TYR   186     -51.066  16.479   6.789  1.00 16.29           O
ATOM   1585  CE2 TYR   186     -49.579  15.336   5.236  1.00 15.60           C
ATOM   1586  CD2 TYR   186     -49.176  14.184   4.529  1.00 16.97           C
ATOM   1587  C   TYR   186     -50.456   9.510   3.024  1.00 10.48           C
ATOM   1588  O   TYR   186     -51.313   9.616   2.143  1.00 10.25           O
ATOM   1589  N   VAL   187     -49.660   8.448   3.114  1.00 10.81           N
ATOM   1590  CA  VAL   187     -49.813   7.308   2.195  1.00 11.07           C
ATOM   1591  CB  VAL   187     -48.750   6.195   2.457  1.00 12.17           C
ATOM   1592  CG1 VAL   187     -49.152   4.865   1.801  1.00 12.64           C
ATOM   1593  CG2 VAL   187     -47.381   6.636   1.948  1.00 12.10           C
ATOM   1594  C   VAL   187     -51.238   6.738   2.348  1.00 10.78           C
ATOM   1595  O   VAL   187     -51.902   6.468   1.365  1.00 11.55           O
ATOM   1596  N   ALA   188     -51.697   6.596   3.591  1.00 10.35           N
ATOM   1597  CA  ALA   188     -53.016   6.013   3.862  1.00 10.34           C
ATOM   1598  CB  ALA   188     -53.214   5.835   5.322  1.00 10.03           C
ATOM   1599  C   ALA   188     -54.109   6.923   3.278  1.00 10.52           C
ATOM   1600  O   ALA   188     -54.976   6.440   2.532  1.00 11.14           O
ATOM   1601  N   ILE   189     -54.067   8.223   3.582  1.00  9.18           N
ATOM   1602  CA  ILE   189     -55.064   9.134   3.022  1.00 10.18           C
ATOM   1603  CB  ILE   189     -54.855  10.573   3.534  1.00 10.61           C
ATOM   1604  CG1 ILE   189     -55.136  10.601   5.058  1.00 10.98           C
ATOM   1605  CD1 ILE   189     -54.723  11.960   5.716  1.00 13.83           C
ATOM   1606  CG2 ILE   189     -55.802  11.563   2.805  1.00 11.30           C
ATOM   1607  C   ILE   189     -55.041   9.113   1.474  1.00  9.70           C
ATOM   1608  O   ILE   189     -56.074   9.014   0.819  1.00  9.40           O
ATOM   1609  N   PHE   190     -53.857   9.209   0.889  1.00  9.58           N
ATOM   1610  CA  PHE   190     -53.805   9.360  -0.550  1.00  9.58           C
ATOM   1611  CB  PHE   190     -52.360   9.611  -0.993  1.00 10.23           C
ATOM   1612  CG  PHE   190     -52.226  10.008  -2.454  1.00  9.45           C
ATOM   1613  CD1 PHE   190     -52.917  11.128  -2.945  1.00  9.44           C
ATOM   1614  CE1 PHE   190     -52.804  11.478  -4.324  1.00  8.91           C
ATOM   1615  CZ  PHE   190     -51.991  10.716  -5.159  1.00  8.37           C
ATOM   1616  CE2 PHE   190     -51.307   9.595  -4.666  1.00 10.34           C
ATOM   1617  CD2 PHE   190     -51.432   9.256  -3.313  1.00  9.34           C
ATOM   1618  C   PHE   190     -54.341   8.115  -1.252  1.00 10.23           C
ATOM   1619  O   PHE   190     -55.013   8.227  -2.272  1.00 10.36           O
ATOM   1620  N   THR   191     -54.011   6.933  -0.728  1.00 10.49           N
ATOM   1621  CA  THR   191     -54.331   5.687  -1.425  1.00 11.39           C
ATOM   1622  CB  THR   191     -53.251   4.575  -1.187  1.00 11.16           C
ATOM   1623  OG1 THR   191     -53.129   4.320   0.203  1.00 13.70           O
ATOM   1624  CG2 THR   191     -51.894   5.021  -1.716  1.00 12.85           C
ATOM   1625  C   THR   191     -55.730   5.173  -1.057  1.00 11.49           C
ATOM   1626  O   THR   191     -56.413   4.630  -1.920  1.00 11.57           O
ATOM   1627  N   ARG   192     -56.142   5.361   0.207  1.00 11.47           N
ATOM   1628  CA  ARG   192     -57.377   4.780   0.764  1.00 12.54           C
ATOM   1629  CB  ARG   192     -57.043   3.762   1.863  1.00 13.38           C
ATOM   1630  CG  ARG   192     -56.218   2.608   1.352  1.00 19.78           C
ATOM   1631  CD  ARG   192     -55.838   1.648   2.458  1.00 27.83           C
ATOM   1632  NE  ARG   192     -54.833   2.186   3.390  1.00 31.16           N
ATOM   1633  CZ  ARG   192     -54.979   2.196   4.710  1.00 30.70           C
ATOM   1634  NH1 ARG   192     -56.099   1.741   5.268  1.00 34.65           N
ATOM   1635  NH2 ARG   192     -54.007   2.636   5.480  1.00 31.86           N
ATOM   1636  C   ARG   192     -58.394   5.793   1.313  1.00 11.41           C
ATOM   1637  O   ARG   192     -59.513   5.408   1.694  1.00 11.66           O
ATOM   1638  N   GLY   193     -57.999   7.067   1.407  1.00 10.15           N
ATOM   1639  CA  GLY   193     -58.897   8.124   1.894  1.00  9.23           C
ATOM   1640  C   GLY   193     -59.105   8.042   3.399  1.00 10.71           C
ATOM   1641  O   GLY   193     -58.465   7.238   4.070  1.00 11.66           O
ATOM   1642  N   ILE   194     -60.015   8.848   3.940  1.00 10.09           N
ATOM   1643  CA  ILE   194     -60.233   8.806   5.378  1.00 10.51           C
ATOM   1644  CB  ILE   194     -60.410  10.235   5.966  1.00  9.22           C
ATOM   1645  CG1 ILE   194     -61.635  10.937   5.378  1.00  9.15           C
ATOM   1646  CD1 ILE   194     -62.095  12.150   6.229  1.00 10.65           C
ATOM   1647  CG2 ILE   194     -59.149  11.099   5.736  1.00 10.26           C
ATOM   1648  C   ILE   194     -61.435   7.920   5.776  1.00 13.00           C
ATOM   1649  O   ILE   194     -61.677   7.686   6.986  1.00 11.91           O
ATOM   1650  N   MET   195     -62.162   7.427   4.770  0.80 13.74           N
ATOM   1652  CA  MET   195     -63.370   6.618   5.035  0.80 19.32           C
ATOM   1654  CB  MET   195     -64.062   6.224   3.735  0.80 17.64           C
ATOM   1656  CG  MET   195     -63.224   5.251   2.910  0.80 22.42           C
ATOM   1658  SD  MET   195     -64.053   4.614   1.255  0.80 35.82          SE
ATOM   1660  CE  MET   195     -65.779   4.059   1.995  0.80 28.19           C
ATOM   1662  C   MET   195     -63.024   5.348   5.798  0.80 17.09           C
ATOM   1664  O   MET   195     -61.945   4.789   5.620  0.80 16.40           O
ATOM   1666  N   ALA   196     -63.946   4.892   6.647  1.00 16.54           N
ATOM   1667  CA  ALA   196     -63.751   3.621   7.358  1.00 17.64           C
ATOM   1668  CB  ALA   196     -64.842   3.419   8.388  1.00 17.48           C
ATOM   1669  C   ALA   196     -63.706   2.435   6.397  1.00 18.42           C
ATOM   1670  O   ALA   196     -64.469   2.403   5.437  1.00 19.76           O
END
