
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  198 ( 1567),  selected  198 , name 1pb6_A
# Molecule2: number of CA atoms  192 ( 1477),  selected  192 , name T0454.pdb
# PARAMETERS: 1pb6_A.T0454.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A    14_A      -       -           -
LGA    V    15_A      D       5           #
LGA    S    16_A      C       6           -
LGA    A    17_A      R       7           #
LGA    K    18_A      S       8          2.008
LGA    K    19_A      -       -           -
LGA    K    20_A      -       -           -
LGA    A    21_A      R       9          2.787
LGA    I    22_A      L      10          2.297
LGA    L    23_A      M      11          2.550
LGA    S    24_A      E      12          2.678
LGA    A    25_A      V      13          1.695
LGA    A    26_A      A      14          1.570
LGA    L    27_A      T      15          1.922
LGA    D    28_A      E      16          0.934
LGA    T    29_A      L      17          0.276
LGA    F    30_A      F      18          1.241
LGA    S    31_A      A      19          2.150
LGA    Q    32_A      Q      20          1.595
LGA    F    33_A      K      21          1.932
LGA    G    34_A      G      22          2.317
LGA    F    35_A      F      23          1.684
LGA    H    36_A      Y      24          2.236
LGA    G    37_A      G      25          1.558
LGA    T    38_A      V      26          0.769
LGA    R    39_A      S      27          1.189
LGA    L    40_A      I      28          2.124
LGA    E    41_A      R      29          3.030
LGA    Q    42_A      E      30          2.292
LGA    I    43_A      L      31          2.429
LGA    A    44_A      A      32          3.256
LGA    E    45_A      Q      33          3.481
LGA    L    46_A      A      34          2.876
LGA    A    47_A      A      35          3.478
LGA    G    48_A      G      36          4.191
LGA    V    49_A      A      37          3.337
LGA    S    50_A      S      38          3.268
LGA    K    51_A      I      39          3.057
LGA    T    52_A      S      40          2.944
LGA    N    53_A      M      41          2.896
LGA    L    54_A      I      42          3.181
LGA    L    55_A      S      43          3.556
LGA    Y    56_A      Y      44          4.956
LGA    Y    57_A      H      45          5.490
LGA    F    58_A      F      46          3.911
LGA    P    59_A      G      47          1.707
LGA    S    60_A      G      48          3.465
LGA    K    61_A      K      49          2.117
LGA    E    62_A      E      50          2.710
LGA    A    63_A      G      51          3.144
LGA    L    64_A      L      52          2.459
LGA    Y    65_A      Y      53          2.138
LGA    I    66_A      A      54          3.269
LGA    A    67_A      A      55          2.975
LGA    V    68_A      V      56          2.245
LGA    L    69_A      L      57          2.463
LGA    R    70_A      Q      58          2.848
LGA    Q    71_A      E      59          2.575
LGA    I    72_A      Q      60          2.746
LGA    L    73_A      F      61          2.359
LGA    D    74_A      A      62          2.667
LGA    I    75_A      C      63          2.052
LGA    W    76_A      F      64          4.440
LGA    L    77_A      G      65           #
LGA    A    78_A      Q      66          3.225
LGA    P    79_A      L      67          3.053
LGA    L    80_A      -       -           -
LGA    K    81_A      D      68           #
LGA    A    82_A      D      69          5.321
LGA    -       -      I      70           -
LGA    F    83_A      R      71          1.370
LGA    R    84_A      G      72          5.226
LGA    E    85_A      -       -           -
LGA    D    86_A      -       -           -
LGA    F    87_A      Q      73          3.146
LGA    A    88_A      A      74           #
LGA    -       -      G      75           -
LGA    -       -      D      76           -
LGA    P    89_A      P      77          1.536
LGA    L    90_A      L      78          0.708
LGA    A    91_A      A      79          0.854
LGA    A    92_A      V      80          1.748
LGA    I    93_A      M      81          1.322
LGA    K    94_A      T      82          0.361
LGA    E    95_A      A      83          1.588
LGA    Y    96_A      Y      84          1.168
LGA    I    97_A      L      85          0.372
LGA    R    98_A      R      86          1.295
LGA    L    99_A      W      87          1.640
LGA    K   100_A      T      88          0.328
LGA    L   101_A      I      89          1.109
LGA    E   102_A      Q      90          1.896
LGA    V   103_A      R      91          1.703
LGA    S   104_A      H      92          1.638
LGA    R   105_A      R      93          2.219
LGA    D   106_A      N      94          2.560
LGA    Y   107_A      N      95          1.188
LGA    P   108_A      P      96          2.126
LGA    Q   109_A      Q      97          1.666
LGA    A   110_A      L      98          2.148
LGA    S   111_A      L      99          1.768
LGA    R   112_A      R     100          1.748
LGA    L   113_A      F     101          2.086
LGA    F   114_A      Y     102          1.459
LGA    C   115_A      T     103          0.657
LGA    M   116_A      S     104          1.688
LGA    E   117_A      E     105          2.065
LGA    M   118_A      L     106          1.545
LGA    L   119_A      T     107          2.018
LGA    A   120_A      N     108          1.689
LGA    G   121_A      -       -           -
LGA    A   122_A      P     109          1.945
LGA    P   123_A      T     110          3.710
LGA    L   124_A      P     111          3.064
LGA    L   125_A      C     112          3.357
LGA    M   126_A      F     113          3.402
LGA    D   127_A      A     114          1.824
LGA    E   128_A      A     115          2.463
LGA    -       -      I     116           -
LGA    L   129_A      V     117          4.966
LGA    T   130_A      S     118          5.397
LGA    G   131_A      -       -           -
LGA    D   132_A      -       -           -
LGA    L   133_A      P     119          1.179
LGA    K   134_A      A     120           #
LGA    A   135_A      I     121           -
LGA    L   136_A      A     122           #
LGA    I   137_A      S     123          3.222
LGA    -       -      V     124           -
LGA    -       -      I     125           -
LGA    D   138_A      R     126          4.691
LGA    E   139_A      L     127           #
LGA    K   140_A      L     128           #
LGA    S   141_A      A     129          3.733
LGA    A   142_A      E     130          3.861
LGA    L   143_A      S     131          5.014
LGA    I   144_A      I     132          4.089
LGA    A   145_A      E     133          2.223
LGA    G   146_A      A     134          2.735
LGA    W   147_A      G     135          3.398
LGA    V   148_A      M     136          2.349
LGA    K   149_A      T     137          1.774
LGA    S   150_A      R     138          2.970
LGA    G   151_A      G     139          3.103
LGA    K   152_A      L     140          4.595
LGA    L   153_A      -       -           -
LGA    A   154_A      F     141          0.851
LGA    P   155_A      R     142          3.112
LGA    -       -      R     143           -
LGA    -       -      D     144           -
LGA    I   156_A      L     145          4.113
LGA    D   157_A      H     146          2.878
LGA    P   158_A      A     147          2.991
LGA    Q   159_A      V     148          1.869
LGA    H   160_A      N     149          2.110
LGA    L   161_A      S     150          3.128
LGA    I   162_A      A     151          2.977
LGA    F   163_A      L     152          2.052
LGA    M   164_A      A     153          2.316
LGA    I   165_A      L     154          3.066
LGA    W   166_A      A     155          2.640
LGA    A   167_A      G     156          1.824
LGA    S   168_A      M     157          2.118
LGA    T   169_A      V     158          1.994
LGA    Q   170_A      N     159          2.017
LGA    H   171_A      Y     160          2.049
LGA    Y   172_A      F     161          3.114
LGA    A   173_A      F     162          2.849
LGA    D   174_A      L     163          2.149
LGA    F   175_A      S     164          1.786
LGA    A   176_A      T     165          1.542
LGA    P   177_A      L     166          0.388
LGA    Q   178_A      A     167          1.164
LGA    V   179_A      T     168          2.386
LGA    E   180_A      E     169          1.020
LGA    A   181_A      G     170          3.868
LGA    V   182_A      L     171          2.281
LGA    T   183_A      T     172          2.814
LGA    G   184_A      S     173           #
LGA    A   185_A      -       -           -
LGA    T   186_A      H     174          3.131
LGA    L   187_A      S     175          3.721
LGA    R   188_A      -       -           -
LGA    D   189_A      -       -           -
LGA    E   190_A      P     176          3.464
LGA    V   191_A      D     177          3.092
LGA    F   192_A      Q     178          3.435
LGA    F   193_A      D     179          3.136
LGA    N   194_A      E     180          3.737
LGA    Q   195_A      E     181          3.492
LGA    T   196_A      L     182          2.540
LGA    V   197_A      I     183          2.801
LGA    E   198_A      R     184          2.594
LGA    N   199_A      Q     185          1.680
LGA    V   200_A      Y     186          2.116
LGA    Q   201_A      V     187          2.663
LGA    R   202_A      A     188          2.312
LGA    I   203_A      I     189          1.596
LGA    I   204_A      F     190          2.279
LGA    I   205_A      T     191          3.856
LGA    E   206_A      R     192          3.555
LGA    G   207_A      G     193          5.058
LGA    I   208_A      I     194           -
LGA    R   209_A      M     195           -
LGA    P   210_A      A     196           -
LGA    R   211_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  198  192    5.0    169    2.74    20.71     55.462     5.951

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.702410 * X  +   0.430288 * Y  +   0.566985 * Z  + -36.749435
  Y_new =  -0.307564 * X  +  -0.534889 * Y  +   0.786955 * Z  +  55.855858
  Z_new =   0.641892 * X  +  -0.727149 * Y  +  -0.243370 * Z  +  27.494211 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.893768    1.247824  [ DEG:  -108.5049     71.4951 ]
  Theta =  -0.696963   -2.444630  [ DEG:   -39.9330   -140.0670 ]
  Phi   =  -0.412720    2.728872  [ DEG:   -23.6471    156.3529 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1pb6_A                                        
REMARK     2: T0454.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1pb6_A.T0454.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  198  192   5.0  169   2.74   20.71  55.462
REMARK  ---------------------------------------------------------- 
MOLECULE 1pb6_A
HEADER    TRANSCRIPTION                           14-MAY-03   1PB6              
TITLE     CRYSTAL STRUCTURE OF HYPOTHETICAL TRANSCRIPTIONAL REGULATOR           
TITLE    2 YCDC                                                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL TRANSCRIPTIONAL REGULATOR YCDC;               
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: PUTATIVE TET OPERON REGULATOR;                              
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: YCDC;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: T7 TOPO-CT                                
KEYWDS    HELIX-LOOP-HELIX, HYPOTHETICAL TRANSCRIPTIONAL REGULATOR,             
KEYWDS   2 DIMER, STRUCTURAL GENOMICS, PSI, PROTEIN STRUCTURE                   
KEYWDS   3 INITIATIVE, NEW YORK STRUCTURAL GENOMIX RESEARCH CONSORTIUM,         
KEYWDS   4 NYSGXRC                                                              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.V.PATSKOVSKY,V.MENNELLA,S.C.ALMO,S.K.BURLEY,NEW YORK                
AUTHOR   2 STRUCTURAL GENOMIX RESEARCH CONSORTIUM (NYSGXRC)                     
REVDAT   3   25-JAN-05 1PB6    1       AUTHOR KEYWDS REMARK                     
REVDAT   2   30-SEP-03 1PB6    1       AUTHOR JRNL   REMARK                     
REVDAT   1   27-MAY-03 1PB6    0                                                
JRNL        AUTH   Y.V.PATSKOVSKY,V.MENNELLA,S.C.ALMO                           
JRNL        TITL   CRYSTAL STRUCTURE OF HYPOTHETICAL TRANSCRIPTIONAL            
JRNL        TITL 2 REGULATOR YCDC FROM ESCHERICHIA COLI                         
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.50 ANGSTROMS.                                          
DBREF  1PB6 A    0   211  UNP    P0ACU2   YCDC_ECOLI       1    212             
DBREF  1PB6 B    0   211  UNP    P0ACU2   YCDC_ECOLI       1    212             
DBREF  1PB6 C    0   211  UNP    P0ACU2   YCDC_ECOLI       1    212             
DBREF  1PB6 D    0   211  UNP    P0ACU2   YCDC_ECOLI       1    212             
SEQRES   1 A  212  MET THR GLN GLY ALA VAL LYS THR THR GLY LYS ARG SER          
SEQRES   2 A  212  ARG ALA VAL SER ALA LYS LYS LYS ALA ILE LEU SER ALA          
SEQRES   3 A  212  ALA LEU ASP THR PHE SER GLN PHE GLY PHE HIS GLY THR          
SEQRES   4 A  212  ARG LEU GLU GLN ILE ALA GLU LEU ALA GLY VAL SER LYS          
SEQRES   5 A  212  THR ASN LEU LEU TYR TYR PHE PRO SER LYS GLU ALA LEU          
SEQRES   6 A  212  TYR ILE ALA VAL LEU ARG GLN ILE LEU ASP ILE TRP LEU          
SEQRES   7 A  212  ALA PRO LEU LYS ALA PHE ARG GLU ASP PHE ALA PRO LEU          
SEQRES   8 A  212  ALA ALA ILE LYS GLU TYR ILE ARG LEU LYS LEU GLU VAL          
SEQRES   9 A  212  SER ARG ASP TYR PRO GLN ALA SER ARG LEU PHE CYS MET          
SEQRES  10 A  212  GLU MET LEU ALA GLY ALA PRO LEU LEU MET ASP GLU LEU          
SEQRES  11 A  212  THR GLY ASP LEU LYS ALA LEU ILE ASP GLU LYS SER ALA          
SEQRES  12 A  212  LEU ILE ALA GLY TRP VAL LYS SER GLY LYS LEU ALA PRO          
SEQRES  13 A  212  ILE ASP PRO GLN HIS LEU ILE PHE MET ILE TRP ALA SER          
SEQRES  14 A  212  THR GLN HIS TYR ALA ASP PHE ALA PRO GLN VAL GLU ALA          
SEQRES  15 A  212  VAL THR GLY ALA THR LEU ARG ASP GLU VAL PHE PHE ASN          
SEQRES  16 A  212  GLN THR VAL GLU ASN VAL GLN ARG ILE ILE ILE GLU GLY          
SEQRES  17 A  212  ILE ARG PRO ARG                                              
SEQRES   1 B  212  MET THR GLN GLY ALA VAL LYS THR THR GLY LYS ARG SER          
SEQRES   2 B  212  ARG ALA VAL SER ALA LYS LYS LYS ALA ILE LEU SER ALA          
SEQRES   3 B  212  ALA LEU ASP THR PHE SER GLN PHE GLY PHE HIS GLY THR          
SEQRES   4 B  212  ARG LEU GLU GLN ILE ALA GLU LEU ALA GLY VAL SER LYS          
SEQRES   5 B  212  THR ASN LEU LEU TYR TYR PHE PRO SER LYS GLU ALA LEU          
SEQRES   6 B  212  TYR ILE ALA VAL LEU ARG GLN ILE LEU ASP ILE TRP LEU          
SEQRES   7 B  212  ALA PRO LEU LYS ALA PHE ARG GLU ASP PHE ALA PRO LEU          
SEQRES   8 B  212  ALA ALA ILE LYS GLU TYR ILE ARG LEU LYS LEU GLU VAL          
SEQRES   9 B  212  SER ARG ASP TYR PRO GLN ALA SER ARG LEU PHE CYS MET          
SEQRES  10 B  212  GLU MET LEU ALA GLY ALA PRO LEU LEU MET ASP GLU LEU          
SEQRES  11 B  212  THR GLY ASP LEU LYS ALA LEU ILE ASP GLU LYS SER ALA          
SEQRES  12 B  212  LEU ILE ALA GLY TRP VAL LYS SER GLY LYS LEU ALA PRO          
SEQRES  13 B  212  ILE ASP PRO GLN HIS LEU ILE PHE MET ILE TRP ALA SER          
SEQRES  14 B  212  THR GLN HIS TYR ALA ASP PHE ALA PRO GLN VAL GLU ALA          
SEQRES  15 B  212  VAL THR GLY ALA THR LEU ARG ASP GLU VAL PHE PHE ASN          
SEQRES  16 B  212  GLN THR VAL GLU ASN VAL GLN ARG ILE ILE ILE GLU GLY          
SEQRES  17 B  212  ILE ARG PRO ARG                                              
SEQRES   1 C  212  MET THR GLN GLY ALA VAL LYS THR THR GLY LYS ARG SER          
SEQRES   2 C  212  ARG ALA VAL SER ALA LYS LYS LYS ALA ILE LEU SER ALA          
SEQRES   3 C  212  ALA LEU ASP THR PHE SER GLN PHE GLY PHE HIS GLY THR          
SEQRES   4 C  212  ARG LEU GLU GLN ILE ALA GLU LEU ALA GLY VAL SER LYS          
SEQRES   5 C  212  THR ASN LEU LEU TYR TYR PHE PRO SER LYS GLU ALA LEU          
SEQRES   6 C  212  TYR ILE ALA VAL LEU ARG GLN ILE LEU ASP ILE TRP LEU          
SEQRES   7 C  212  ALA PRO LEU LYS ALA PHE ARG GLU ASP PHE ALA PRO LEU          
SEQRES   8 C  212  ALA ALA ILE LYS GLU TYR ILE ARG LEU LYS LEU GLU VAL          
SEQRES   9 C  212  SER ARG ASP TYR PRO GLN ALA SER ARG LEU PHE CYS MET          
SEQRES  10 C  212  GLU MET LEU ALA GLY ALA PRO LEU LEU MET ASP GLU LEU          
SEQRES  11 C  212  THR GLY ASP LEU LYS ALA LEU ILE ASP GLU LYS SER ALA          
SEQRES  12 C  212  LEU ILE ALA GLY TRP VAL LYS SER GLY LYS LEU ALA PRO          
SEQRES  13 C  212  ILE ASP PRO GLN HIS LEU ILE PHE MET ILE TRP ALA SER          
SEQRES  14 C  212  THR GLN HIS TYR ALA ASP PHE ALA PRO GLN VAL GLU ALA          
SEQRES  15 C  212  VAL THR GLY ALA THR LEU ARG ASP GLU VAL PHE PHE ASN          
SEQRES  16 C  212  GLN THR VAL GLU ASN VAL GLN ARG ILE ILE ILE GLU GLY          
SEQRES  17 C  212  ILE ARG PRO ARG                                              
SEQRES   1 D  212  MET THR GLN GLY ALA VAL LYS THR THR GLY LYS ARG SER          
SEQRES   2 D  212  ARG ALA VAL SER ALA LYS LYS LYS ALA ILE LEU SER ALA          
SEQRES   3 D  212  ALA LEU ASP THR PHE SER GLN PHE GLY PHE HIS GLY THR          
SEQRES   4 D  212  ARG LEU GLU GLN ILE ALA GLU LEU ALA GLY VAL SER LYS          
SEQRES   5 D  212  THR ASN LEU LEU TYR TYR PHE PRO SER LYS GLU ALA LEU          
SEQRES   6 D  212  TYR ILE ALA VAL LEU ARG GLN ILE LEU ASP ILE TRP LEU          
SEQRES   7 D  212  ALA PRO LEU LYS ALA PHE ARG GLU ASP PHE ALA PRO LEU          
SEQRES   8 D  212  ALA ALA ILE LYS GLU TYR ILE ARG LEU LYS LEU GLU VAL          
SEQRES   9 D  212  SER ARG ASP TYR PRO GLN ALA SER ARG LEU PHE CYS MET          
SEQRES  10 D  212  GLU MET LEU ALA GLY ALA PRO LEU LEU MET ASP GLU LEU          
SEQRES  11 D  212  THR GLY ASP LEU LYS ALA LEU ILE ASP GLU LYS SER ALA          
SEQRES  12 D  212  LEU ILE ALA GLY TRP VAL LYS SER GLY LYS LEU ALA PRO          
SEQRES  13 D  212  ILE ASP PRO GLN HIS LEU ILE PHE MET ILE TRP ALA SER          
SEQRES  14 D  212  THR GLN HIS TYR ALA ASP PHE ALA PRO GLN VAL GLU ALA          
SEQRES  15 D  212  VAL THR GLY ALA THR LEU ARG ASP GLU VAL PHE PHE ASN          
SEQRES  16 D  212  GLN THR VAL GLU ASN VAL GLN ARG ILE ILE ILE GLU GLY          
SEQRES  17 D  212  ILE ARG PRO ARG                                              
FORMUL   5  HOH   *160(H2 O)                                                    
CRYST1   52.020  139.610  156.000  90.00  90.00  90.00 P 21 21 21   16          
ATOM      1  N   ALA A  14     -11.375  27.526  -0.455  1.00 62.93           N  
ATOM      2  CA  ALA A  14     -11.673  28.964  -0.145  1.00 62.80           C  
ATOM      3  C   ALA A  14     -12.610  29.641  -1.152  1.00 62.05           C  
ATOM      4  O   ALA A  14     -13.344  30.572  -0.794  1.00 60.01           O  
ATOM      5  CB  ALA A  14     -10.391  29.764  -0.009  1.00 64.03           C  
ATOM      6  N   VAL A  15     -12.503  29.252  -2.421  1.00 60.41           N  
ATOM      7  CA  VAL A  15     -13.378  29.797  -3.455  1.00 57.00           C  
ATOM      8  C   VAL A  15     -14.737  29.147  -3.195  1.00 54.65           C  
ATOM      9  O   VAL A  15     -15.780  29.797  -3.273  1.00 53.69           O  
ATOM     10  CB  VAL A  15     -12.860  29.457  -4.868  1.00 56.97           C  
ATOM     11  CG1 VAL A  15     -13.833  29.926  -5.925  1.00 57.73           C  
ATOM     12  CG2 VAL A  15     -11.508  30.111  -5.083  1.00 55.62           C  
ATOM     13  N   SER A  16     -14.706  27.865  -2.846  1.00 52.96           N  
ATOM     14  CA  SER A  16     -15.922  27.140  -2.535  1.00 52.83           C  
ATOM     15  C   SER A  16     -16.487  27.748  -1.267  1.00 49.54           C  
ATOM     16  O   SER A  16     -17.700  27.873  -1.123  1.00 51.38           O  
ATOM     17  CB  SER A  16     -15.636  25.646  -2.305  1.00 56.26           C  
ATOM     18  OG  SER A  16     -15.407  25.337  -0.932  1.00 61.15           O  
ATOM     19  N   ALA A  17     -15.605  28.120  -0.348  1.00 45.63           N  
ATOM     20  CA  ALA A  17     -16.035  28.696   0.911  1.00 43.78           C  
ATOM     21  C   ALA A  17     -16.755  30.023   0.727  1.00 43.38           C  
ATOM     22  O   ALA A  17     -17.562  30.412   1.562  1.00 43.49           O  
ATOM     23  CB  ALA A  17     -14.862  28.870   1.834  1.00 41.45           C  
ATOM     24  N   LYS A  18     -16.428  30.734  -0.344  1.00 43.76           N  
ATOM     25  CA  LYS A  18     -17.045  32.026  -0.638  1.00 41.17           C  
ATOM     26  C   LYS A  18     -18.358  31.870  -1.387  1.00 40.04           C  
ATOM     27  O   LYS A  18     -19.344  32.539  -1.076  1.00 40.09           O  
ATOM     28  CB  LYS A  18     -16.114  32.880  -1.494  1.00 41.90           C  
ATOM     29  CG  LYS A  18     -15.093  33.663  -0.743  1.00 40.24           C  
ATOM     30  CD  LYS A  18     -14.255  34.431  -1.714  1.00 40.59           C  
ATOM     31  CE  LYS A  18     -13.484  35.510  -1.004  1.00 41.16           C  
ATOM     32  NZ  LYS A  18     -12.598  36.234  -1.947  1.00 43.70           N  
ATOM     33  N   LYS A  19     -18.347  31.046  -2.429  1.00 39.60           N  
ATOM     34  CA  LYS A  19     -19.545  30.829  -3.214  1.00 39.67           C  
ATOM     35  C   LYS A  19     -20.619  30.367  -2.255  1.00 40.76           C  
ATOM     36  O   LYS A  19     -21.798  30.652  -2.457  1.00 42.72           O  
ATOM     37  CB  LYS A  19     -19.299  29.778  -4.293  1.00 38.22           C  
ATOM     38  CG  LYS A  19     -20.402  29.708  -5.324  1.00 41.31           C  
ATOM     39  CD  LYS A  19     -20.061  28.716  -6.428  1.00 45.36           C  
ATOM     40  CE  LYS A  19     -21.121  28.712  -7.534  1.00 49.44           C  
ATOM     41  NZ  LYS A  19     -21.191  30.006  -8.287  1.00 53.20           N  
ATOM     42  N   LYS A  20     -20.193  29.679  -1.199  1.00 41.27           N  
ATOM     43  CA  LYS A  20     -21.100  29.169  -0.184  1.00 42.66           C  
ATOM     44  C   LYS A  20     -21.549  30.253   0.790  1.00 40.70           C  
ATOM     45  O   LYS A  20     -22.731  30.337   1.117  1.00 42.90           O  
ATOM     46  CB  LYS A  20     -20.464  27.989   0.550  1.00 46.72           C  
ATOM     47  CG  LYS A  20     -20.267  26.773  -0.358  1.00 57.80           C  
ATOM     48  CD  LYS A  20     -19.475  25.664   0.328  1.00 64.83           C  
ATOM     49  CE  LYS A  20     -19.122  24.532  -0.639  1.00 68.29           C  
ATOM     50  NZ  LYS A  20     -18.336  23.452   0.042  1.00 70.36           N  
ATOM     51  N   ALA A  21     -20.612  31.068   1.266  1.00 38.24           N  
ATOM     52  CA  ALA A  21     -20.939  32.153   2.195  1.00 36.76           C  
ATOM     53  C   ALA A  21     -21.966  33.077   1.550  1.00 36.53           C  
ATOM     54  O   ALA A  21     -22.942  33.463   2.173  1.00 36.41           O  
ATOM     55  CB  ALA A  21     -19.692  32.943   2.544  1.00 34.96           C  
ATOM     56  N   ILE A  22     -21.712  33.447   0.299  1.00 36.44           N  
ATOM     57  CA  ILE A  22     -22.604  34.317  -0.459  1.00 34.91           C  
ATOM     58  C   ILE A  22     -24.013  33.709  -0.638  1.00 34.97           C  
ATOM     59  O   ILE A  22     -25.017  34.384  -0.399  1.00 33.38           O  
ATOM     60  CB  ILE A  22     -21.994  34.630  -1.837  1.00 33.96           C  
ATOM     61  CG1 ILE A  22     -20.646  35.349  -1.664  1.00 31.82           C  
ATOM     62  CG2 ILE A  22     -22.972  35.438  -2.668  1.00 32.80           C  
ATOM     63  CD1 ILE A  22     -19.793  35.448  -2.948  1.00 29.15           C  
ATOM     64  N   LEU A  23     -24.088  32.466  -1.112  1.00 33.71           N  
ATOM     65  CA  LEU A  23     -25.379  31.807  -1.302  1.00 33.67           C  
ATOM     66  C   LEU A  23     -26.211  31.749  -0.028  1.00 33.70           C  
ATOM     67  O   LEU A  23     -27.413  31.979  -0.062  1.00 33.77           O  
ATOM     68  CB  LEU A  23     -25.198  30.398  -1.854  1.00 31.61           C  
ATOM     69  CG  LEU A  23     -24.911  30.348  -3.341  1.00 32.07           C  
ATOM     70  CD1 LEU A  23     -24.448  28.967  -3.732  1.00 33.26           C  
ATOM     71  CD2 LEU A  23     -26.172  30.711  -4.074  1.00 32.83           C  
ATOM     72  N   SER A  24     -25.584  31.462   1.101  1.00 34.23           N  
ATOM     73  CA  SER A  24     -26.370  31.386   2.307  1.00 38.62           C  
ATOM     74  C   SER A  24     -26.725  32.774   2.764  1.00 38.47           C  
ATOM     75  O   SER A  24     -27.718  32.956   3.470  1.00 41.81           O  
ATOM     76  CB  SER A  24     -25.674  30.583   3.405  1.00 43.74           C  
ATOM     77  OG  SER A  24     -24.598  31.283   3.989  1.00 53.49           O  
ATOM     78  N   ALA A  25     -25.925  33.754   2.355  1.00 35.78           N  
ATOM     79  CA  ALA A  25     -26.187  35.146   2.713  1.00 33.49           C  
ATOM     80  C   ALA A  25     -27.316  35.632   1.821  1.00 33.05           C  
ATOM     81  O   ALA A  25     -28.122  36.479   2.213  1.00 29.93           O  
ATOM     82  CB  ALA A  25     -24.946  36.002   2.500  1.00 31.82           C  
ATOM     83  N   ALA A  26     -27.341  35.104   0.602  1.00 32.64           N  
ATOM     84  CA  ALA A  26     -28.373  35.451  -0.352  1.00 33.79           C  
ATOM     85  C   ALA A  26     -29.696  34.935   0.181  1.00 34.96           C  
ATOM     86  O   ALA A  26     -30.655  35.700   0.284  1.00 36.32           O  
ATOM     87  CB  ALA A  26     -28.076  34.840  -1.712  1.00 31.44           C  
ATOM     88  N   LEU A  27     -29.724  33.645   0.537  1.00 36.04           N  
ATOM     89  CA  LEU A  27     -30.918  32.984   1.058  1.00 36.71           C  
ATOM     90  C   LEU A  27     -31.472  33.772   2.208  1.00 40.32           C  
ATOM     91  O   LEU A  27     -32.623  34.210   2.168  1.00 43.29           O  
ATOM     92  CB  LEU A  27     -30.611  31.556   1.536  1.00 34.38           C  
ATOM     93  CG  LEU A  27     -31.703  30.820   2.348  1.00 33.88           C  
ATOM     94  CD1 LEU A  27     -33.001  30.663   1.562  1.00 32.36           C  
ATOM     95  CD2 LEU A  27     -31.195  29.472   2.785  1.00 31.45           C  
ATOM     96  N   ASP A  28     -30.637  33.926   3.230  1.00 42.53           N  
ATOM     97  CA  ASP A  28     -30.988  34.649   4.440  1.00 45.42           C  
ATOM     98  C   ASP A  28     -31.486  36.059   4.182  1.00 44.81           C  
ATOM     99  O   ASP A  28     -32.447  36.490   4.804  1.00 46.88           O  
ATOM    100  CB  ASP A  28     -29.788  34.693   5.387  1.00 50.43           C  
ATOM    101  CG  ASP A  28     -29.637  33.427   6.209  1.00 56.63           C  
ATOM    102  OD1 ASP A  28     -30.055  33.442   7.384  1.00 58.59           O  
ATOM    103  OD2 ASP A  28     -29.105  32.418   5.688  1.00 61.09           O  
ATOM    104  N   THR A  29     -30.836  36.785   3.278  1.00 43.40           N  
ATOM    105  CA  THR A  29     -31.257  38.153   3.000  1.00 43.24           C  
ATOM    106  C   THR A  29     -32.505  38.240   2.122  1.00 43.45           C  
ATOM    107  O   THR A  29     -33.394  39.056   2.385  1.00 44.85           O  
ATOM    108  CB  THR A  29     -30.119  39.022   2.414  1.00 40.29           C  
ATOM    109  OG1 THR A  29     -29.007  39.027   3.314  1.00 39.54           O  
ATOM    110  CG2 THR A  29     -30.584  40.453   2.258  1.00 36.96           C  
ATOM    111  N   PHE A  30     -32.581  37.423   1.078  1.00 41.52           N  
ATOM    112  CA  PHE A  30     -33.754  37.442   0.205  1.00 40.60           C  
ATOM    113  C   PHE A  30     -35.036  37.072   0.940  1.00 42.65           C  
ATOM    114  O   PHE A  30     -36.074  37.702   0.748  1.00 44.58           O  
ATOM    115  CB  PHE A  30     -33.553  36.503  -0.968  1.00 36.55           C  
ATOM    116  CG  PHE A  30     -32.744  37.090  -2.064  1.00 32.98           C  
ATOM    117  CD1 PHE A  30     -31.715  36.359  -2.651  1.00 31.86           C  
ATOM    118  CD2 PHE A  30     -33.039  38.360  -2.544  1.00 28.99           C  
ATOM    119  CE1 PHE A  30     -30.985  36.882  -3.714  1.00 31.91           C  
ATOM    120  CE2 PHE A  30     -32.322  38.896  -3.602  1.00 31.87           C  
ATOM    121  CZ  PHE A  30     -31.289  38.159  -4.197  1.00 30.97           C  
ATOM    122  N   SER A  31     -34.978  36.015   1.740  1.00 44.80           N  
ATOM    123  CA  SER A  31     -36.138  35.591   2.503  1.00 46.76           C  
ATOM    124  C   SER A  31     -36.444  36.614   3.578  1.00 49.36           C  
ATOM    125  O   SER A  31     -37.491  36.565   4.209  1.00 52.80           O  
ATOM    126  CB  SER A  31     -35.902  34.221   3.133  1.00 45.88           C  
ATOM    127  OG  SER A  31     -34.746  34.220   3.938  1.00 44.33           O  
ATOM    128  N   GLN A  32     -35.542  37.562   3.762  1.00 51.19           N  
ATOM    129  CA  GLN A  32     -35.746  38.589   4.759  1.00 55.46           C  
ATOM    130  C   GLN A  32     -36.435  39.812   4.174  1.00 55.84           C  
ATOM    131  O   GLN A  32     -37.492  40.228   4.647  1.00 59.23           O  
ATOM    132  CB  GLN A  32     -34.410  38.985   5.394  1.00 59.24           C  
ATOM    133  CG  GLN A  32     -34.065  38.211   6.655  1.00 67.82           C  
ATOM    134  CD  GLN A  32     -34.851  38.691   7.859  1.00 73.62           C  
ATOM    135  OE1 GLN A  32     -35.854  38.090   8.259  1.00 76.69           O  
ATOM    136  NE2 GLN A  32     -34.404  39.801   8.442  1.00 77.22           N  
ATOM    137  N   PHE A  33     -35.872  40.358   3.105  1.00 54.38           N  
ATOM    138  CA  PHE A  33     -36.422  41.566   2.513  1.00 53.38           C  
ATOM    139  C   PHE A  33     -37.010  41.444   1.106  1.00 50.63           C  
ATOM    140  O   PHE A  33     -37.513  42.423   0.565  1.00 51.09           O  
ATOM    141  CB  PHE A  33     -35.358  42.669   2.585  1.00 56.32           C  
ATOM    142  CG  PHE A  33     -34.558  42.635   3.860  1.00 61.63           C  
ATOM    143  CD1 PHE A  33     -35.193  42.723   5.100  1.00 64.78           C  
ATOM    144  CD2 PHE A  33     -33.186  42.434   3.830  1.00 63.56           C  
ATOM    145  CE1 PHE A  33     -34.476  42.603   6.290  1.00 65.41           C  
ATOM    146  CE2 PHE A  33     -32.460  42.314   5.014  1.00 65.66           C  
ATOM    147  CZ  PHE A  33     -33.109  42.397   6.245  1.00 66.30           C  
ATOM    148  N   GLY A  34     -37.009  40.243   0.545  1.00 47.50           N  
ATOM    149  CA  GLY A  34     -37.555  40.053  -0.789  1.00 46.08           C  
ATOM    150  C   GLY A  34     -36.588  40.492  -1.869  1.00 44.13           C  
ATOM    151  O   GLY A  34     -35.694  41.277  -1.586  1.00 46.18           O  
ATOM    152  N   PHE A  35     -36.764  40.005  -3.098  1.00 39.57           N  
ATOM    153  CA  PHE A  35     -35.868  40.351  -4.194  1.00 37.26           C  
ATOM    154  C   PHE A  35     -35.542  41.838  -4.354  1.00 40.04           C  
ATOM    155  O   PHE A  35     -34.380  42.208  -4.480  1.00 40.11           O  
ATOM    156  CB  PHE A  35     -36.399  39.828  -5.524  1.00 33.11           C  
ATOM    157  CG  PHE A  35     -35.480  40.106  -6.681  1.00 33.09           C  
ATOM    158  CD1 PHE A  35     -34.411  39.261  -6.956  1.00 32.81           C  
ATOM    159  CD2 PHE A  35     -35.649  41.237  -7.471  1.00 33.24           C  
ATOM    160  CE1 PHE A  35     -33.516  39.546  -8.011  1.00 32.08           C  
ATOM    161  CE2 PHE A  35     -34.765  41.525  -8.516  1.00 33.36           C  
ATOM    162  CZ  PHE A  35     -33.699  40.679  -8.785  1.00 32.37           C  
ATOM    163  N   HIS A  36     -36.579  42.661  -4.488  1.00 42.40           N  
ATOM    164  CA  HIS A  36     -36.424  44.102  -4.663  1.00 43.66           C  
ATOM    165  C   HIS A  36     -36.077  44.784  -3.360  1.00 45.82           C  
ATOM    166  O   HIS A  36     -35.468  45.854  -3.349  1.00 48.36           O  
ATOM    167  CB  HIS A  36     -37.707  44.706  -5.232  1.00 42.32           C  
ATOM    168  CG  HIS A  36     -38.045  44.211  -6.604  1.00 40.49           C  
ATOM    169  ND1 HIS A  36     -37.343  44.593  -7.724  1.00 41.52           N  
ATOM    170  CD2 HIS A  36     -38.987  43.340  -7.029  1.00 39.69           C  
ATOM    171  CE1 HIS A  36     -37.834  43.973  -8.783  1.00 41.37           C  
ATOM    172  NE2 HIS A  36     -38.834  43.207  -8.387  1.00 38.34           N  
ATOM    173  N   GLY A  37     -36.528  44.188  -2.265  1.00 47.21           N  
ATOM    174  CA  GLY A  37     -36.243  44.736  -0.959  1.00 49.51           C  
ATOM    175  C   GLY A  37     -34.777  44.615  -0.581  1.00 51.05           C  
ATOM    176  O   GLY A  37     -34.300  45.408   0.230  1.00 53.82           O  
ATOM    177  N   THR A  38     -34.056  43.652  -1.156  1.00 49.53           N  
ATOM    178  CA  THR A  38     -32.650  43.474  -0.815  1.00 49.18           C  
ATOM    179  C   THR A  38     -31.673  44.122  -1.773  1.00 48.33           C  
ATOM    180  O   THR A  38     -31.924  44.230  -2.969  1.00 46.37           O  
ATOM    181  CB  THR A  38     -32.247  41.985  -0.653  1.00 47.95           C  
ATOM    182  OG1 THR A  38     -31.920  41.412  -1.921  1.00 47.08           O  
ATOM    183  CG2 THR A  38     -33.360  41.198  -0.050  1.00 48.00           C  
ATOM    184  N   ARG A  39     -30.542  44.540  -1.220  1.00 49.45           N  
ATOM    185  CA  ARG A  39     -29.477  45.164  -1.982  1.00 49.49           C  
ATOM    186  C   ARG A  39     -28.349  44.142  -2.071  1.00 48.06           C  
ATOM    187  O   ARG A  39     -28.046  43.461  -1.102  1.00 50.75           O  
ATOM    188  CB  ARG A  39     -29.020  46.439  -1.272  1.00 52.75           C  
ATOM    189  CG  ARG A  39     -30.163  47.427  -1.048  1.00 59.72           C  
ATOM    190  CD  ARG A  39     -29.774  48.634  -0.193  1.00 65.93           C  
ATOM    191  NE  ARG A  39     -29.835  48.386   1.250  1.00 69.93           N  
ATOM    192  CZ  ARG A  39     -28.772  48.343   2.052  1.00 72.72           C  
ATOM    193  NH1 ARG A  39     -28.928  48.122   3.356  1.00 74.10           N  
ATOM    194  NH2 ARG A  39     -27.544  48.484   1.550  1.00 73.68           N  
ATOM    195  N   LEU A  40     -27.748  44.012  -3.244  1.00 45.28           N  
ATOM    196  CA  LEU A  40     -26.665  43.069  -3.450  1.00 44.46           C  
ATOM    197  C   LEU A  40     -25.450  43.397  -2.565  1.00 48.26           C  
ATOM    198  O   LEU A  40     -24.464  42.668  -2.554  1.00 49.79           O  
ATOM    199  CB  LEU A  40     -26.288  43.073  -4.930  1.00 38.82           C  
ATOM    200  CG  LEU A  40     -25.682  41.830  -5.574  1.00 34.54           C  
ATOM    201  CD1 LEU A  40     -26.596  40.651  -5.352  1.00 31.74           C  
ATOM    202  CD2 LEU A  40     -25.474  42.081  -7.058  1.00 28.88           C  
ATOM    203  N   GLU A  41     -25.503  44.533  -1.879  1.00 52.70           N  
ATOM    204  CA  GLU A  41     -24.435  44.945  -0.971  1.00 56.66           C  
ATOM    205  C   GLU A  41     -24.609  44.262   0.379  1.00 55.21           C  
ATOM    206  O   GLU A  41     -23.631  43.860   1.002  1.00 57.14           O  
ATOM    207  CB  GLU A  41     -24.441  46.462  -0.768  1.00 63.25           C  
ATOM    208  CG  GLU A  41     -23.820  47.247  -1.911  1.00 71.61           C  
ATOM    209  CD  GLU A  41     -22.296  47.144  -1.962  1.00 77.07           C  
ATOM    210  OE1 GLU A  41     -21.732  46.074  -1.624  1.00 78.30           O  
ATOM    211  OE2 GLU A  41     -21.659  48.148  -2.355  1.00 79.96           O  
ATOM    212  N   GLN A  42     -25.858  44.181   0.837  1.00 51.45           N  
ATOM    213  CA  GLN A  42     -26.192  43.540   2.108  1.00 49.00           C  
ATOM    214  C   GLN A  42     -25.804  42.062   2.101  1.00 46.64           C  
ATOM    215  O   GLN A  42     -25.598  41.466   3.154  1.00 48.92           O  
ATOM    216  CB  GLN A  42     -27.692  43.615   2.370  1.00 48.53           C  
ATOM    217  CG  GLN A  42     -28.367  44.842   1.842  1.00 49.19           C  
ATOM    218  CD  GLN A  42     -29.872  44.754   1.950  1.00 50.52           C  
ATOM    219  OE1 GLN A  42     -30.592  45.543   1.350  1.00 53.96           O  
ATOM    220  NE2 GLN A  42     -30.356  43.808   2.739  1.00 52.18           N  
ATOM    221  N   ILE A  43     -25.799  41.462   0.917  1.00 43.08           N  
ATOM    222  CA  ILE A  43     -25.455  40.060   0.766  1.00 42.01           C  
ATOM    223  C   ILE A  43     -23.949  39.942   0.869  1.00 43.02           C  
ATOM    224  O   ILE A  43     -23.421  39.069   1.566  1.00 44.92           O  
ATOM    225  CB  ILE A  43     -25.933  39.516  -0.606  1.00 38.61           C  
ATOM    226  CG1 ILE A  43     -27.465  39.545  -0.682  1.00 36.26           C  
ATOM    227  CG2 ILE A  43     -25.406  38.113  -0.838  1.00 36.74           C  
ATOM    228  CD1 ILE A  43     -28.030  39.120  -2.018  1.00 32.29           C  
ATOM    229  N   ALA A  44     -23.271  40.826   0.147  1.00 43.77           N  
ATOM    230  CA  ALA A  44     -21.818  40.879   0.118  1.00 44.40           C  
ATOM    231  C   ALA A  44     -21.253  41.116   1.517  1.00 46.12           C  
ATOM    232  O   ALA A  44     -20.292  40.463   1.927  1.00 44.91           O  
ATOM    233  CB  ALA A  44     -21.371  41.969  -0.825  1.00 44.28           C  
ATOM    234  N   GLU A  45     -21.860  42.048   2.244  1.00 47.62           N  
ATOM    235  CA  GLU A  45     -21.432  42.365   3.594  1.00 49.69           C  
ATOM    236  C   GLU A  45     -21.615  41.151   4.493  1.00 48.48           C  
ATOM    237  O   GLU A  45     -20.667  40.681   5.120  1.00 51.35           O  
ATOM    238  CB  GLU A  45     -22.247  43.530   4.162  1.00 54.02           C  
ATOM    239  CG  GLU A  45     -21.918  43.815   5.623  1.00 64.11           C  
ATOM    240  CD  GLU A  45     -22.809  44.864   6.263  1.00 69.28           C  
ATOM    241  OE1 GLU A  45     -24.033  44.625   6.370  1.00 72.25           O  
ATOM    242  OE2 GLU A  45     -22.279  45.917   6.688  1.00 72.42           O  
ATOM    243  N   LEU A  46     -22.856  40.683   4.576  1.00 46.00           N  
ATOM    244  CA  LEU A  46     -23.217  39.540   5.396  1.00 44.77           C  
ATOM    245  C   LEU A  46     -22.324  38.340   5.109  1.00 43.59           C  
ATOM    246  O   LEU A  46     -21.926  37.633   6.039  1.00 45.06           O  
ATOM    247  CB  LEU A  46     -24.681  39.187   5.159  1.00 47.05           C  
ATOM    248  CG  LEU A  46     -25.459  38.503   6.274  1.00 49.27           C  
ATOM    249  CD1 LEU A  46     -26.933  38.692   6.012  1.00 51.16           C  
ATOM    250  CD2 LEU A  46     -25.107  37.031   6.362  1.00 54.93           C  
ATOM    251  N   ALA A  47     -22.029  38.113   3.830  1.00 40.26           N  
ATOM    252  CA  ALA A  47     -21.181  37.005   3.415  1.00 37.95           C  
ATOM    253  C   ALA A  47     -19.687  37.304   3.624  1.00 38.62           C  
ATOM    254  O   ALA A  47     -18.829  36.444   3.370  1.00 39.62           O  
ATOM    255  CB  ALA A  47     -21.453  36.674   1.967  1.00 36.10           C  
ATOM    256  N   GLY A  48     -19.379  38.533   4.048  1.00 37.74           N  
ATOM    257  CA  GLY A  48     -18.004  38.936   4.280  1.00 34.92           C  
ATOM    258  C   GLY A  48     -17.143  39.135   3.036  1.00 34.88           C  
ATOM    259  O   GLY A  48     -15.927  39.014   3.118  1.00 33.94           O  
ATOM    260  N   VAL A  49     -17.752  39.399   1.883  1.00 37.18           N  
ATOM    261  CA  VAL A  49     -17.005  39.641   0.637  1.00 38.16           C  
ATOM    262  C   VAL A  49     -17.355  41.015   0.067  1.00 39.20           C  
ATOM    263  O   VAL A  49     -18.227  41.707   0.583  1.00 40.35           O  
ATOM    264  CB  VAL A  49     -17.283  38.587  -0.475  1.00 37.50           C  
ATOM    265  CG1 VAL A  49     -16.828  37.199  -0.032  1.00 36.84           C  
ATOM    266  CG2 VAL A  49     -18.753  38.602  -0.872  1.00 36.47           C  
ATOM    267  N   SER A  50     -16.627  41.437  -0.955  1.00 39.85           N  
ATOM    268  CA  SER A  50     -16.899  42.725  -1.576  1.00 43.47           C  
ATOM    269  C   SER A  50     -17.937  42.541  -2.676  1.00 45.50           C  
ATOM    270  O   SER A  50     -18.100  41.436  -3.216  1.00 44.48           O  
ATOM    271  CB  SER A  50     -15.631  43.314  -2.188  1.00 44.84           C  
ATOM    272  OG  SER A  50     -15.230  42.593  -3.345  1.00 44.73           O  
ATOM    273  N   LYS A  51     -18.635  43.624  -3.007  1.00 46.70           N  
ATOM    274  CA  LYS A  51     -19.654  43.588  -4.051  1.00 47.94           C  
ATOM    275  C   LYS A  51     -19.072  43.191  -5.407  1.00 47.33           C  
ATOM    276  O   LYS A  51     -19.754  42.552  -6.207  1.00 47.94           O  
ATOM    277  CB  LYS A  51     -20.363  44.935  -4.155  1.00 49.24           C  
ATOM    278  CG  LYS A  51     -21.727  44.879  -4.825  1.00 51.91           C  
ATOM    279  CD  LYS A  51     -21.724  45.598  -6.163  1.00 54.19           C  
ATOM    280  CE  LYS A  51     -23.051  46.281  -6.446  1.00 53.66           C  
ATOM    281  NZ  LYS A  51     -23.326  47.385  -5.477  1.00 54.19           N  
ATOM    282  N   THR A  52     -17.828  43.577  -5.667  1.00 46.22           N  
ATOM    283  CA  THR A  52     -17.155  43.244  -6.919  1.00 45.29           C  
ATOM    284  C   THR A  52     -16.753  41.769  -6.929  1.00 45.03           C  
ATOM    285  O   THR A  52     -16.620  41.151  -7.995  1.00 42.95           O  
ATOM    286  CB  THR A  52     -15.892  44.110  -7.118  1.00 46.30           C  
ATOM    287  OG1 THR A  52     -16.268  45.454  -7.450  1.00 49.45           O  
ATOM    288  CG2 THR A  52     -15.028  43.555  -8.232  1.00 44.84           C  
ATOM    289  N   ASN A  53     -16.516  41.223  -5.740  1.00 46.33           N  
ATOM    290  CA  ASN A  53     -16.130  39.828  -5.602  1.00 46.69           C  
ATOM    291  C   ASN A  53     -17.388  38.976  -5.748  1.00 44.97           C  
ATOM    292  O   ASN A  53     -17.379  37.944  -6.425  1.00 44.14           O  
ATOM    293  CB  ASN A  53     -15.447  39.600  -4.247  1.00 48.90           C  
ATOM    294  CG  ASN A  53     -14.955  38.172  -4.063  1.00 51.38           C  
ATOM    295  OD1 ASN A  53     -15.261  37.540  -3.056  1.00 55.78           O  
ATOM    296  ND2 ASN A  53     -14.184  37.659  -5.027  1.00 49.24           N  
ATOM    297  N   LEU A  54     -18.483  39.431  -5.142  1.00 43.39           N  
ATOM    298  CA  LEU A  54     -19.749  38.713  -5.235  1.00 42.47           C  
ATOM    299  C   LEU A  54     -20.112  38.552  -6.706  1.00 44.07           C  
ATOM    300  O   LEU A  54     -20.344  37.426  -7.178  1.00 44.30           O  
ATOM    301  CB  LEU A  54     -20.869  39.471  -4.508  1.00 39.42           C  
ATOM    302  CG  LEU A  54     -22.245  38.793  -4.465  1.00 34.75           C  
ATOM    303  CD1 LEU A  54     -23.040  39.332  -3.324  1.00 37.18           C  
ATOM    304  CD2 LEU A  54     -22.997  39.000  -5.743  1.00 35.12           C  
ATOM    305  N   LEU A  55     -20.170  39.695  -7.402  1.00 44.02           N  
ATOM    306  CA  LEU A  55     -20.516  39.770  -8.824  1.00 40.36           C  
ATOM    307  C   LEU A  55     -19.709  38.864  -9.710  1.00 39.93           C  
ATOM    308  O   LEU A  55     -20.080  38.635 -10.856  1.00 39.75           O  
ATOM    309  CB  LEU A  55     -20.401  41.193  -9.344  1.00 39.20           C  
ATOM    310  CG  LEU A  55     -21.443  42.158  -8.801  1.00 40.20           C  
ATOM    311  CD1 LEU A  55     -21.110  43.553  -9.270  1.00 40.10           C  
ATOM    312  CD2 LEU A  55     -22.832  41.727  -9.252  1.00 39.87           C  
ATOM    313  N   TYR A  56     -18.569  38.409  -9.216  1.00 42.13           N  
ATOM    314  CA  TYR A  56     -17.748  37.504  -9.982  1.00 44.60           C  
ATOM    315  C   TYR A  56     -18.348  36.135  -9.910  1.00 45.70           C  
ATOM    316  O   TYR A  56     -18.242  35.355 -10.857  1.00 49.60           O  
ATOM    317  CB  TYR A  56     -16.334  37.469  -9.444  1.00 48.15           C  
ATOM    318  CG  TYR A  56     -15.428  38.288 -10.292  1.00 53.77           C  
ATOM    319  CD1 TYR A  56     -15.522  39.684 -10.293  1.00 54.33           C  
ATOM    320  CD2 TYR A  56     -14.514  37.681 -11.147  1.00 52.57           C  
ATOM    321  CE1 TYR A  56     -14.735  40.450 -11.126  1.00 51.33           C  
ATOM    322  CE2 TYR A  56     -13.722  38.450 -11.985  1.00 53.48           C  
ATOM    323  CZ  TYR A  56     -13.845  39.827 -11.963  1.00 51.20           C  
ATOM    324  OH  TYR A  56     -13.100  40.592 -12.795  1.00 55.05           O  
ATOM    325  N   TYR A  57     -18.932  35.822  -8.761  1.00 44.50           N  
ATOM    326  CA  TYR A  57     -19.563  34.531  -8.563  1.00 43.79           C  
ATOM    327  C   TYR A  57     -20.949  34.554  -9.197  1.00 43.19           C  
ATOM    328  O   TYR A  57     -21.324  33.629  -9.927  1.00 41.75           O  
ATOM    329  CB  TYR A  57     -19.653  34.221  -7.075  1.00 43.69           C  
ATOM    330  CG  TYR A  57     -18.334  33.820  -6.451  1.00 43.47           C  
ATOM    331  CD1 TYR A  57     -17.600  34.721  -5.676  1.00 44.41           C  
ATOM    332  CD2 TYR A  57     -17.840  32.521  -6.594  1.00 43.47           C  
ATOM    333  CE1 TYR A  57     -16.403  34.340  -5.053  1.00 41.69           C  
ATOM    334  CE2 TYR A  57     -16.653  32.129  -5.977  1.00 42.10           C  
ATOM    335  CZ  TYR A  57     -15.940  33.042  -5.208  1.00 40.34           C  
ATOM    336  OH  TYR A  57     -14.763  32.662  -4.604  1.00 35.82           O  
ATOM    337  N   PHE A  58     -21.698  35.625  -8.918  1.00 42.00           N  
ATOM    338  CA  PHE A  58     -23.048  35.823  -9.447  1.00 40.25           C  
ATOM    339  C   PHE A  58     -23.176  37.232 -10.046  1.00 40.25           C  
ATOM    340  O   PHE A  58     -23.301  38.232  -9.328  1.00 38.67           O  
ATOM    341  CB  PHE A  58     -24.095  35.552  -8.354  1.00 37.40           C  
ATOM    342  CG  PHE A  58     -23.921  34.207  -7.701  1.00 35.83           C  
ATOM    343  CD1 PHE A  58     -23.138  34.070  -6.549  1.00 34.59           C  
ATOM    344  CD2 PHE A  58     -24.460  33.063  -8.276  1.00 32.32           C  
ATOM    345  CE1 PHE A  58     -22.891  32.813  -5.987  1.00 32.33           C  
ATOM    346  CE2 PHE A  58     -24.213  31.802  -7.715  1.00 29.58           C  
ATOM    347  CZ  PHE A  58     -23.427  31.682  -6.572  1.00 28.88           C  
ATOM    348  N   PRO A  59     -23.156  37.310 -11.388  1.00 40.80           N  
ATOM    349  CA  PRO A  59     -23.241  38.483 -12.260  1.00 41.09           C  
ATOM    350  C   PRO A  59     -24.391  39.473 -12.072  1.00 41.27           C  
ATOM    351  O   PRO A  59     -24.334  40.594 -12.597  1.00 42.59           O  
ATOM    352  CB  PRO A  59     -23.251  37.859 -13.652  1.00 41.06           C  
ATOM    353  CG  PRO A  59     -23.887  36.548 -13.422  1.00 40.08           C  
ATOM    354  CD  PRO A  59     -23.200  36.078 -12.195  1.00 39.90           C  
ATOM    355  N   SER A  60     -25.415  39.087 -11.324  1.00 40.82           N  
ATOM    356  CA  SER A  60     -26.557  39.973 -11.090  1.00 40.64           C  
ATOM    357  C   SER A  60     -27.368  39.504  -9.900  1.00 39.59           C  
ATOM    358  O   SER A  60     -27.278  38.336  -9.507  1.00 40.79           O  
ATOM    359  CB  SER A  60     -27.453  40.030 -12.335  1.00 43.49           C  
ATOM    360  OG  SER A  60     -27.449  38.793 -13.050  1.00 46.64           O  
ATOM    361  N   LYS A  61     -28.118  40.420  -9.286  1.00 38.83           N  
ATOM    362  CA  LYS A  61     -28.954  40.061  -8.143  1.00 35.80           C  
ATOM    363  C   LYS A  61     -29.942  39.002  -8.588  1.00 35.54           C  
ATOM    364  O   LYS A  61     -30.365  38.168  -7.788  1.00 36.75           O  
ATOM    365  CB  LYS A  61     -29.703  41.277  -7.592  1.00 32.64           C  
ATOM    366  CG  LYS A  61     -30.609  40.951  -6.428  1.00 32.84           C  
ATOM    367  CD  LYS A  61     -30.678  42.086  -5.430  1.00 34.31           C  
ATOM    368  CE  LYS A  61     -31.340  43.318  -5.979  1.00 36.72           C  
ATOM    369  NZ  LYS A  61     -32.731  43.053  -6.429  1.00 36.68           N  
ATOM    370  N   GLU A  62     -30.308  39.058  -9.866  1.00 36.04           N  
ATOM    371  CA  GLU A  62     -31.233  38.112 -10.468  1.00 36.80           C  
ATOM    372  C   GLU A  62     -30.598  36.731 -10.690  1.00 35.64           C  
ATOM    373  O   GLU A  62     -31.292  35.714 -10.639  1.00 34.55           O  
ATOM    374  CB  GLU A  62     -31.760  38.659 -11.794  1.00 40.87           C  
ATOM    375  CG  GLU A  62     -32.682  37.688 -12.517  1.00 49.97           C  
ATOM    376  CD  GLU A  62     -33.113  38.156 -13.896  1.00 56.67           C  
ATOM    377  OE1 GLU A  62     -33.128  37.312 -14.821  1.00 59.62           O  
ATOM    378  OE2 GLU A  62     -33.460  39.352 -14.050  1.00 63.69           O  
ATOM    379  N   ALA A  63     -29.302  36.698 -10.993  1.00 35.44           N  
ATOM    380  CA  ALA A  63     -28.584  35.434 -11.205  1.00 33.91           C  
ATOM    381  C   ALA A  63     -28.376  34.728  -9.872  1.00 34.55           C  
ATOM    382  O   ALA A  63     -28.450  33.490  -9.784  1.00 34.72           O  
ATOM    383  CB  ALA A  63     -27.236  35.688 -11.850  1.00 33.74           C  
ATOM    384  N   LEU A  64     -28.048  35.515  -8.850  1.00 31.90           N  
ATOM    385  CA  LEU A  64     -27.820  34.972  -7.520  1.00 30.04           C  
ATOM    386  C   LEU A  64     -29.142  34.431  -6.956  1.00 26.92           C  
ATOM    387  O   LEU A  64     -29.181  33.325  -6.402  1.00 22.20           O  
ATOM    388  CB  LEU A  64     -27.192  36.048  -6.609  1.00 27.17           C  
ATOM    389  CG  LEU A  64     -26.934  35.749  -5.129  1.00 27.50           C  
ATOM    390  CD1 LEU A  64     -26.119  34.500  -4.970  1.00 23.10           C  
ATOM    391  CD2 LEU A  64     -26.252  36.920  -4.455  1.00 22.75           C  
ATOM    392  N   TYR A  65     -30.212  35.209  -7.132  1.00 25.06           N  
ATOM    393  CA  TYR A  65     -31.550  34.856  -6.651  1.00 24.64           C  
ATOM    394  C   TYR A  65     -32.002  33.500  -7.173  1.00 26.66           C  
ATOM    395  O   TYR A  65     -32.429  32.625  -6.411  1.00 26.44           O  
ATOM    396  CB  TYR A  65     -32.559  35.901  -7.108  1.00 21.64           C  
ATOM    397  CG  TYR A  65     -33.957  35.678  -6.597  1.00 16.13           C  
ATOM    398  CD1 TYR A  65     -35.005  35.394  -7.475  1.00 14.50           C  
ATOM    399  CD2 TYR A  65     -34.240  35.808  -5.250  1.00 14.32           C  
ATOM    400  CE1 TYR A  65     -36.308  35.251  -7.014  1.00 16.56           C  
ATOM    401  CE2 TYR A  65     -35.523  35.669  -4.776  1.00 18.66           C  
ATOM    402  CZ  TYR A  65     -36.567  35.392  -5.659  1.00 19.44           C  
ATOM    403  OH  TYR A  65     -37.866  35.303  -5.161  1.00 22.58           O  
ATOM    404  N   ILE A  66     -31.986  33.377  -8.492  1.00 24.81           N  
ATOM    405  CA  ILE A  66     -32.374  32.156  -9.159  1.00 24.07           C  
ATOM    406  C   ILE A  66     -31.467  31.019  -8.701  1.00 26.85           C  
ATOM    407  O   ILE A  66     -31.879  29.855  -8.689  1.00 31.74           O  
ATOM    408  CB  ILE A  66     -32.326  32.381 -10.669  1.00 21.73           C  
ATOM    409  CG1 ILE A  66     -33.539  33.217 -11.080  1.00 21.91           C  
ATOM    410  CG2 ILE A  66     -32.263  31.081 -11.408  1.00 23.96           C  
ATOM    411  CD1 ILE A  66     -33.287  34.158 -12.217  1.00 21.65           C  
ATOM    412  N   ALA A  67     -30.251  31.361  -8.275  1.00 29.39           N  
ATOM    413  CA  ALA A  67     -29.281  30.372  -7.786  1.00 28.02           C  
ATOM    414  C   ALA A  67     -29.683  29.776  -6.421  1.00 25.95           C  
ATOM    415  O   ALA A  67     -29.547  28.575  -6.211  1.00 24.79           O  
ATOM    416  CB  ALA A  67     -27.879  30.989  -7.727  1.00 27.41           C  
ATOM    417  N   VAL A  68     -30.158  30.600  -5.492  1.00 25.81           N  
ATOM    418  CA  VAL A  68     -30.584  30.062  -4.203  1.00 30.52           C  
ATOM    419  C   VAL A  68     -31.831  29.179  -4.402  1.00 33.02           C  
ATOM    420  O   VAL A  68     -32.019  28.165  -3.707  1.00 34.61           O  
ATOM    421  CB  VAL A  68     -30.916  31.185  -3.136  1.00 31.55           C  
ATOM    422  CG1 VAL A  68     -29.771  32.148  -2.979  1.00 29.09           C  
ATOM    423  CG2 VAL A  68     -32.169  31.950  -3.506  1.00 34.32           C  
ATOM    424  N   LEU A  69     -32.703  29.593  -5.326  1.00 33.54           N  
ATOM    425  CA  LEU A  69     -33.941  28.858  -5.610  1.00 30.65           C  
ATOM    426  C   LEU A  69     -33.672  27.569  -6.355  1.00 30.62           C  
ATOM    427  O   LEU A  69     -34.330  26.568  -6.114  1.00 30.29           O  
ATOM    428  CB  LEU A  69     -34.898  29.717  -6.429  1.00 28.26           C  
ATOM    429  CG  LEU A  69     -35.601  30.853  -5.696  1.00 25.69           C  
ATOM    430  CD1 LEU A  69     -36.435  31.641  -6.693  1.00 26.26           C  
ATOM    431  CD2 LEU A  69     -36.464  30.308  -4.583  1.00 24.16           C  
ATOM    432  N   ARG A  70     -32.738  27.617  -7.297  1.00 33.15           N  
ATOM    433  CA  ARG A  70     -32.377  26.452  -8.086  1.00 35.19           C  
ATOM    434  C   ARG A  70     -31.792  25.364  -7.177  1.00 36.45           C  
ATOM    435  O   ARG A  70     -31.799  24.186  -7.529  1.00 37.30           O  
ATOM    436  CB  ARG A  70     -31.370  26.858  -9.161  1.00 38.52           C  
ATOM    437  CG  ARG A  70     -31.013  25.765 -10.143  1.00 45.61           C  
ATOM    438  CD  ARG A  70     -32.140  25.492 -11.100  1.00 53.99           C  
ATOM    439  NE  ARG A  70     -32.315  24.063 -11.326  1.00 61.21           N  
ATOM    440  CZ  ARG A  70     -33.499  23.475 -11.488  1.00 65.20           C  
ATOM    441  NH1 ARG A  70     -33.575  22.165 -11.684  1.00 66.06           N  
ATOM    442  NH2 ARG A  70     -34.611  24.196 -11.460  1.00 66.55           N  
ATOM    443  N   GLN A  71     -31.281  25.761  -6.012  1.00 37.24           N  
ATOM    444  CA  GLN A  71     -30.700  24.815  -5.061  1.00 37.04           C  
ATOM    445  C   GLN A  71     -31.752  23.919  -4.416  1.00 35.14           C  
ATOM    446  O   GLN A  71     -31.583  22.706  -4.376  1.00 35.50           O  
ATOM    447  CB  GLN A  71     -29.896  25.534  -3.967  1.00 39.93           C  
ATOM    448  CG  GLN A  71     -28.487  25.972  -4.372  1.00 42.96           C  
ATOM    449  CD  GLN A  71     -27.630  26.387  -3.171  1.00 44.08           C  
ATOM    450  OE1 GLN A  71     -28.089  27.082  -2.275  1.00 41.61           O  
ATOM    451  NE2 GLN A  71     -26.383  25.939  -3.154  1.00 45.51           N  
ATOM    452  N   ILE A  72     -32.783  24.518  -3.830  1.00 34.47           N  
ATOM    453  CA  ILE A  72     -33.847  23.733  -3.218  1.00 36.55           C  
ATOM    454  C   ILE A  72     -34.558  23.008  -4.335  1.00 37.92           C  
ATOM    455  O   ILE A  72     -34.947  21.866  -4.176  1.00 40.04           O  
ATOM    456  CB  ILE A  72     -34.920  24.575  -2.540  1.00 38.02           C  
ATOM    457  CG1 ILE A  72     -34.471  26.027  -2.420  1.00 43.30           C  
ATOM    458  CG2 ILE A  72     -35.260  23.973  -1.196  1.00 36.56           C  
ATOM    459  CD1 ILE A  72     -35.583  27.026  -2.676  1.00 46.77           C  
ATOM    460  N   LEU A  73     -34.740  23.683  -5.464  1.00 38.02           N  
ATOM    461  CA  LEU A  73     -35.417  23.075  -6.594  1.00 37.98           C  
ATOM    462  C   LEU A  73     -34.731  21.775  -6.996  1.00 37.41           C  
ATOM    463  O   LEU A  73     -35.398  20.828  -7.385  1.00 39.32           O  
ATOM    464  CB  LEU A  73     -35.497  24.058  -7.766  1.00 38.46           C  
ATOM    465  CG  LEU A  73     -36.658  23.874  -8.761  1.00 38.87           C  
ATOM    466  CD1 LEU A  73     -37.979  23.691  -8.023  1.00 35.75           C  
ATOM    467  CD2 LEU A  73     -36.733  25.080  -9.696  1.00 39.01           C  
ATOM    468  N   ASP A  74     -33.408  21.724  -6.872  1.00 39.04           N  
ATOM    469  CA  ASP A  74     -32.630  20.521  -7.200  1.00 41.15           C  
ATOM    470  C   ASP A  74     -32.710  19.442  -6.117  1.00 40.86           C  
ATOM    471  O   ASP A  74     -32.556  18.254  -6.409  1.00 39.74           O  
ATOM    472  CB  ASP A  74     -31.158  20.871  -7.433  1.00 44.97           C  
ATOM    473  CG  ASP A  74     -30.854  21.207  -8.875  1.00 48.25           C  
ATOM    474  OD1 ASP A  74     -29.655  21.242  -9.219  1.00 50.89           O  
ATOM    475  OD2 ASP A  74     -31.796  21.428  -9.665  1.00 50.86           O  
ATOM    476  N   ILE A  75     -32.820  19.865  -4.860  1.00 39.51           N  
ATOM    477  CA  ILE A  75     -32.945  18.943  -3.736  1.00 38.66           C  
ATOM    478  C   ILE A  75     -34.370  18.371  -3.732  1.00 39.28           C  
ATOM    479  O   ILE A  75     -34.554  17.169  -3.579  1.00 38.30           O  
ATOM    480  CB  ILE A  75     -32.701  19.663  -2.405  1.00 38.05           C  
ATOM    481  CG1 ILE A  75     -31.249  20.117  -2.309  1.00 40.62           C  
ATOM    482  CG2 ILE A  75     -33.049  18.759  -1.246  1.00 40.08           C  
ATOM    483  CD1 ILE A  75     -30.947  20.911  -1.048  1.00 42.80           C  
ATOM    484  N   TRP A  76     -35.361  19.263  -3.824  1.00 40.51           N  
ATOM    485  CA  TRP A  76     -36.788  18.924  -3.877  1.00 38.66           C  
ATOM    486  C   TRP A  76     -36.959  17.792  -4.891  1.00 39.70           C  
ATOM    487  O   TRP A  76     -37.473  16.724  -4.577  1.00 39.95           O  
ATOM    488  CB  TRP A  76     -37.614  20.095  -4.466  1.00 40.47           C  
ATOM    489  CG  TRP A  76     -38.119  21.250  -3.590  1.00 40.36           C  
ATOM    490  CD1 TRP A  76     -38.439  22.534  -4.018  1.00 40.47           C  
ATOM    491  CD2 TRP A  76     -38.415  21.220  -2.196  1.00 39.22           C  
ATOM    492  NE1 TRP A  76     -38.914  23.287  -2.968  1.00 37.23           N  
ATOM    493  CE2 TRP A  76     -38.906  22.510  -1.841  1.00 39.72           C  
ATOM    494  CE3 TRP A  76     -38.319  20.235  -1.210  1.00 41.06           C  
ATOM    495  CZ2 TRP A  76     -39.292  22.827  -0.543  1.00 44.92           C  
ATOM    496  CZ3 TRP A  76     -38.708  20.550   0.086  1.00 46.55           C  
ATOM    497  CH2 TRP A  76     -39.189  21.840   0.411  1.00 49.09           C  
ATOM    498  N   LEU A  77     -36.514  18.068  -6.115  1.00 38.80           N  
ATOM    499  CA  LEU A  77     -36.656  17.170  -7.250  1.00 38.16           C  
ATOM    500  C   LEU A  77     -35.788  15.940  -7.300  1.00 38.17           C  
ATOM    501  O   LEU A  77     -35.996  15.087  -8.157  1.00 38.25           O  
ATOM    502  CB  LEU A  77     -36.450  17.951  -8.548  1.00 40.00           C  
ATOM    503  CG  LEU A  77     -37.284  19.204  -8.847  1.00 40.79           C  
ATOM    504  CD1 LEU A  77     -36.789  19.799 -10.158  1.00 42.51           C  
ATOM    505  CD2 LEU A  77     -38.781  18.900  -8.915  1.00 39.25           C  
ATOM    506  N   ALA A  78     -34.801  15.854  -6.419  1.00 38.52           N  
ATOM    507  CA  ALA A  78     -33.893  14.714  -6.426  1.00 39.06           C  
ATOM    508  C   ALA A  78     -34.609  13.365  -6.557  1.00 39.43           C  
ATOM    509  O   ALA A  78     -34.420  12.659  -7.554  1.00 42.35           O  
ATOM    510  CB  ALA A  78     -32.977  14.737  -5.182  1.00 42.15           C  
ATOM    511  N   PRO A  79     -35.446  12.994  -5.566  1.00 36.85           N  
ATOM    512  CA  PRO A  79     -36.163  11.721  -5.618  1.00 36.60           C  
ATOM    513  C   PRO A  79     -36.969  11.520  -6.901  1.00 38.45           C  
ATOM    514  O   PRO A  79     -37.023  10.418  -7.436  1.00 39.48           O  
ATOM    515  CB  PRO A  79     -37.097  11.817  -4.417  1.00 34.65           C  
ATOM    516  CG  PRO A  79     -36.351  12.677  -3.470  1.00 34.57           C  
ATOM    517  CD  PRO A  79     -35.839  13.750  -4.363  1.00 37.03           C  
ATOM    518  N   LEU A  80     -37.624  12.580  -7.365  1.00 39.91           N  
ATOM    519  CA  LEU A  80     -38.456  12.518  -8.564  1.00 41.37           C  
ATOM    520  C   LEU A  80     -37.678  12.197  -9.849  1.00 45.05           C  
ATOM    521  O   LEU A  80     -38.158  11.435 -10.694  1.00 46.54           O  
ATOM    522  CB  LEU A  80     -39.256  13.820  -8.703  1.00 38.17           C  
ATOM    523  CG  LEU A  80     -40.638  13.776  -9.372  1.00 38.89           C  
ATOM    524  CD1 LEU A  80     -40.553  14.241 -10.790  1.00 39.72           C  
ATOM    525  CD2 LEU A  80     -41.247  12.387  -9.306  1.00 36.14           C  
ATOM    526  N   LYS A  81     -36.501  12.793 -10.014  1.00 48.43           N  
ATOM    527  CA  LYS A  81     -35.684  12.540 -11.200  1.00 50.26           C  
ATOM    528  C   LYS A  81     -35.270  11.067 -11.264  1.00 51.34           C  
ATOM    529  O   LYS A  81     -35.057  10.516 -12.352  1.00 51.11           O  
ATOM    530  CB  LYS A  81     -34.455  13.454 -11.211  1.00 51.73           C  
ATOM    531  CG  LYS A  81     -34.701  14.775 -11.929  1.00 56.88           C  
ATOM    532  CD  LYS A  81     -33.504  15.724 -11.895  1.00 60.33           C  
ATOM    533  CE  LYS A  81     -33.250  16.258 -10.486  1.00 64.38           C  
ATOM    534  NZ  LYS A  81     -32.282  17.399 -10.468  1.00 69.07           N  
ATOM    535  N   ALA A  82     -35.174  10.447 -10.088  1.00 50.44           N  
ATOM    536  CA  ALA A  82     -34.804   9.044  -9.939  1.00 50.30           C  
ATOM    537  C   ALA A  82     -35.817   8.077 -10.565  1.00 52.25           C  
ATOM    538  O   ALA A  82     -35.431   7.067 -11.165  1.00 52.89           O  
ATOM    539  CB  ALA A  82     -34.632   8.718  -8.463  1.00 48.44           C  
ATOM    540  N   PHE A  83     -37.105   8.366 -10.376  1.00 52.42           N  
ATOM    541  CA  PHE A  83     -38.194   7.540 -10.897  1.00 52.16           C  
ATOM    542  C   PHE A  83     -37.897   6.887 -12.246  1.00 53.30           C  
ATOM    543  O   PHE A  83     -37.611   7.567 -13.236  1.00 52.45           O  
ATOM    544  CB  PHE A  83     -39.497   8.354 -11.010  1.00 49.40           C  
ATOM    545  CG  PHE A  83     -40.271   8.482  -9.715  1.00 47.67           C  
ATOM    546  CD1 PHE A  83     -39.619   8.615  -8.492  1.00 46.36           C  
ATOM    547  CD2 PHE A  83     -41.666   8.502  -9.728  1.00 46.06           C  
ATOM    548  CE1 PHE A  83     -40.348   8.771  -7.293  1.00 44.61           C  
ATOM    549  CE2 PHE A  83     -42.402   8.655  -8.535  1.00 43.20           C  
ATOM    550  CZ  PHE A  83     -41.736   8.791  -7.318  1.00 41.98           C  
ATOM    551  N   ARG A  84     -37.928   5.556 -12.259  1.00 56.54           N  
ATOM    552  CA  ARG A  84     -37.711   4.782 -13.482  1.00 60.30           C  
ATOM    553  C   ARG A  84     -38.881   3.814 -13.653  1.00 60.39           C  
ATOM    554  O   ARG A  84     -39.503   3.397 -12.677  1.00 59.60           O  
ATOM    555  CB  ARG A  84     -36.384   4.012 -13.438  1.00 63.25           C  
ATOM    556  CG  ARG A  84     -35.140   4.887 -13.470  1.00 65.88           C  
ATOM    557  CD  ARG A  84     -34.921   5.510 -14.848  1.00 68.31           C  
ATOM    558  NE  ARG A  84     -34.706   6.959 -14.804  1.00 70.26           N  
ATOM    559  CZ  ARG A  84     -33.801   7.583 -14.047  1.00 71.79           C  
ATOM    560  NH1 ARG A  84     -33.700   8.904 -14.098  1.00 71.80           N  
ATOM    561  NH2 ARG A  84     -33.005   6.900 -13.229  1.00 73.05           N  
ATOM    562  N   GLU A  85     -39.171   3.478 -14.903  1.00 61.81           N  
ATOM    563  CA  GLU A  85     -40.269   2.584 -15.272  1.00 64.54           C  
ATOM    564  C   GLU A  85     -40.427   1.309 -14.439  1.00 63.86           C  
ATOM    565  O   GLU A  85     -41.538   0.925 -14.084  1.00 61.77           O  
ATOM    566  CB  GLU A  85     -40.116   2.224 -16.743  1.00 68.29           C  
ATOM    567  CG  GLU A  85     -41.247   1.425 -17.341  1.00 75.02           C  
ATOM    568  CD  GLU A  85     -41.023   1.175 -18.825  1.00 80.65           C  
ATOM    569  OE1 GLU A  85     -41.063   2.154 -19.610  1.00 83.56           O  
ATOM    570  OE2 GLU A  85     -40.783   0.006 -19.206  1.00 82.46           O  
ATOM    571  N   ASP A  86     -39.311   0.650 -14.151  1.00 65.65           N  
ATOM    572  CA  ASP A  86     -39.303  -0.597 -13.379  1.00 66.78           C  
ATOM    573  C   ASP A  86     -39.522  -0.440 -11.869  1.00 65.96           C  
ATOM    574  O   ASP A  86     -39.487  -1.428 -11.121  1.00 66.54           O  
ATOM    575  CB  ASP A  86     -37.989  -1.347 -13.632  1.00 70.46           C  
ATOM    576  CG  ASP A  86     -36.804  -0.407 -13.771  1.00 74.83           C  
ATOM    577  OD1 ASP A  86     -36.591   0.437 -12.874  1.00 76.19           O  
ATOM    578  OD2 ASP A  86     -36.102  -0.494 -14.799  1.00 78.74           O  
ATOM    579  N   PHE A  87     -39.711   0.797 -11.418  1.00 63.28           N  
ATOM    580  CA  PHE A  87     -39.919   1.062  -9.999  1.00 59.83           C  
ATOM    581  C   PHE A  87     -41.244   0.511  -9.495  1.00 57.97           C  
ATOM    582  O   PHE A  87     -42.156   0.244 -10.285  1.00 55.45           O  
ATOM    583  CB  PHE A  87     -39.864   2.568  -9.721  1.00 59.29           C  
ATOM    584  CG  PHE A  87     -38.476   3.136  -9.686  1.00 58.67           C  
ATOM    585  CD1 PHE A  87     -37.449   2.566 -10.436  1.00 57.67           C  
ATOM    586  CD2 PHE A  87     -38.196   4.242  -8.894  1.00 58.97           C  
ATOM    587  CE1 PHE A  87     -36.162   3.090 -10.396  1.00 58.87           C  
ATOM    588  CE2 PHE A  87     -36.910   4.779  -8.847  1.00 60.61           C  
ATOM    589  CZ  PHE A  87     -35.891   4.199  -9.601  1.00 60.25           C  
ATOM    590  N   ALA A  88     -41.304   0.271  -8.184  1.00 56.83           N  
ATOM    591  CA  ALA A  88     -42.523  -0.204  -7.523  1.00 56.81           C  
ATOM    592  C   ALA A  88     -43.265   1.088  -7.124  1.00 57.16           C  
ATOM    593  O   ALA A  88     -43.039   1.634  -6.033  1.00 55.19           O  
ATOM    594  CB  ALA A  88     -42.166  -1.031  -6.287  1.00 56.68           C  
ATOM    595  N   PRO A  89     -44.183   1.563  -7.998  1.00 56.84           N  
ATOM    596  CA  PRO A  89     -44.983   2.783  -7.822  1.00 54.86           C  
ATOM    597  C   PRO A  89     -45.319   3.181  -6.391  1.00 53.87           C  
ATOM    598  O   PRO A  89     -44.889   4.234  -5.927  1.00 54.87           O  
ATOM    599  CB  PRO A  89     -46.219   2.502  -8.671  1.00 53.69           C  
ATOM    600  CG  PRO A  89     -45.638   1.735  -9.822  1.00 53.32           C  
ATOM    601  CD  PRO A  89     -44.739   0.749  -9.100  1.00 56.12           C  
ATOM    602  N   LEU A  90     -46.083   2.358  -5.688  1.00 52.02           N  
ATOM    603  CA  LEU A  90     -46.440   2.690  -4.322  1.00 50.69           C  
ATOM    604  C   LEU A  90     -45.208   2.925  -3.482  1.00 51.33           C  
ATOM    605  O   LEU A  90     -45.091   3.959  -2.824  1.00 52.90           O  
ATOM    606  CB  LEU A  90     -47.278   1.590  -3.687  1.00 49.74           C  
ATOM    607  CG  LEU A  90     -48.725   1.970  -3.396  1.00 48.75           C  
ATOM    608  CD1 LEU A  90     -49.438   2.401  -4.675  1.00 45.52           C  
ATOM    609  CD2 LEU A  90     -49.410   0.789  -2.772  1.00 50.42           C  
ATOM    610  N   ALA A  91     -44.306   1.951  -3.482  1.00 51.08           N  
ATOM    611  CA  ALA A  91     -43.086   2.060  -2.705  1.00 50.15           C  
ATOM    612  C   ALA A  91     -42.243   3.274  -3.119  1.00 48.32           C  
ATOM    613  O   ALA A  91     -41.588   3.897  -2.278  1.00 49.48           O  
ATOM    614  CB  ALA A  91     -42.280   0.776  -2.823  1.00 52.73           C  
ATOM    615  N   ALA A  92     -42.247   3.592  -4.411  1.00 45.39           N  
ATOM    616  CA  ALA A  92     -41.489   4.722  -4.933  1.00 45.19           C  
ATOM    617  C   ALA A  92     -42.045   6.037  -4.397  1.00 46.84           C  
ATOM    618  O   ALA A  92     -41.289   6.903  -3.930  1.00 47.60           O  
ATOM    619  CB  ALA A  92     -41.530   4.715  -6.447  1.00 44.26           C  
ATOM    620  N   ILE A  93     -43.369   6.164  -4.480  1.00 46.02           N  
ATOM    621  CA  ILE A  93     -44.126   7.336  -4.036  1.00 45.23           C  
ATOM    622  C   ILE A  93     -44.191   7.439  -2.514  1.00 46.36           C  
ATOM    623  O   ILE A  93     -44.451   8.509  -1.963  1.00 48.17           O  
ATOM    624  CB  ILE A  93     -45.564   7.323  -4.659  1.00 43.33           C  
ATOM    625  CG1 ILE A  93     -45.475   7.546  -6.174  1.00 41.28           C  
ATOM    626  CG2 ILE A  93     -46.457   8.384  -4.035  1.00 40.27           C  
ATOM    627  CD1 ILE A  93     -46.775   7.310  -6.904  1.00 40.57           C  
ATOM    628  N   LYS A  94     -43.929   6.337  -1.835  1.00 46.97           N  
ATOM    629  CA  LYS A  94     -43.958   6.338  -0.385  1.00 48.97           C  
ATOM    630  C   LYS A  94     -42.690   6.993   0.142  1.00 49.64           C  
ATOM    631  O   LYS A  94     -42.742   7.785   1.084  1.00 49.72           O  
ATOM    632  CB  LYS A  94     -44.067   4.904   0.138  1.00 51.31           C  
ATOM    633  CG  LYS A  94     -44.341   4.783   1.620  1.00 52.98           C  
ATOM    634  CD  LYS A  94     -44.276   3.326   2.056  1.00 58.54           C  
ATOM    635  CE  LYS A  94     -44.610   3.160   3.537  1.00 61.37           C  
ATOM    636  NZ  LYS A  94     -46.035   3.475   3.839  1.00 64.51           N  
ATOM    637  N   GLU A  95     -41.552   6.677  -0.480  1.00 50.29           N  
ATOM    638  CA  GLU A  95     -40.273   7.241  -0.042  1.00 50.69           C  
ATOM    639  C   GLU A  95     -40.047   8.674  -0.508  1.00 46.23           C  
ATOM    640  O   GLU A  95     -39.322   9.443   0.131  1.00 46.79           O  
ATOM    641  CB  GLU A  95     -39.098   6.326  -0.424  1.00 55.71           C  
ATOM    642  CG  GLU A  95     -38.954   5.103   0.507  1.00 62.57           C  
ATOM    643  CD  GLU A  95     -39.009   5.465   2.007  1.00 65.55           C  
ATOM    644  OE1 GLU A  95     -38.190   6.289   2.473  1.00 67.02           O  
ATOM    645  OE2 GLU A  95     -39.875   4.920   2.724  1.00 63.70           O  
ATOM    646  N   TYR A  96     -40.655   9.008  -1.639  1.00 41.63           N  
ATOM    647  CA  TYR A  96     -40.584  10.341  -2.213  1.00 37.43           C  
ATOM    648  C   TYR A  96     -41.216  11.267  -1.175  1.00 35.31           C  
ATOM    649  O   TYR A  96     -40.680  12.321  -0.847  1.00 34.59           O  
ATOM    650  CB  TYR A  96     -41.399  10.337  -3.506  1.00 37.54           C  
ATOM    651  CG  TYR A  96     -41.495  11.639  -4.276  1.00 36.02           C  
ATOM    652  CD1 TYR A  96     -42.494  11.805  -5.236  1.00 35.57           C  
ATOM    653  CD2 TYR A  96     -40.580  12.675  -4.087  1.00 34.15           C  
ATOM    654  CE1 TYR A  96     -42.581  12.952  -5.989  1.00 36.35           C  
ATOM    655  CE2 TYR A  96     -40.659  13.832  -4.842  1.00 33.91           C  
ATOM    656  CZ  TYR A  96     -41.662  13.961  -5.793  1.00 36.11           C  
ATOM    657  OH  TYR A  96     -41.743  15.076  -6.588  1.00 38.45           O  
ATOM    658  N   ILE A  97     -42.344  10.828  -0.635  1.00 34.00           N  
ATOM    659  CA  ILE A  97     -43.062  11.585   0.369  1.00 35.50           C  
ATOM    660  C   ILE A  97     -42.233  11.776   1.636  1.00 38.25           C  
ATOM    661  O   ILE A  97     -42.286  12.842   2.280  1.00 39.56           O  
ATOM    662  CB  ILE A  97     -44.408  10.890   0.724  1.00 32.99           C  
ATOM    663  CG1 ILE A  97     -45.317  10.856  -0.511  1.00 30.47           C  
ATOM    664  CG2 ILE A  97     -45.103  11.606   1.901  1.00 31.92           C  
ATOM    665  CD1 ILE A  97     -46.672  10.191  -0.277  1.00 25.30           C  
ATOM    666  N   ARG A  98     -41.476  10.747   2.000  1.00 40.47           N  
ATOM    667  CA  ARG A  98     -40.672  10.810   3.211  1.00 41.20           C  
ATOM    668  C   ARG A  98     -39.414  11.669   3.084  1.00 41.57           C  
ATOM    669  O   ARG A  98     -39.006  12.315   4.061  1.00 42.14           O  
ATOM    670  CB  ARG A  98     -40.337   9.414   3.684  1.00 44.80           C  
ATOM    671  CG  ARG A  98     -39.917   9.376   5.122  1.00 49.52           C  
ATOM    672  CD  ARG A  98     -40.048   7.967   5.651  1.00 54.78           C  
ATOM    673  NE  ARG A  98     -38.830   7.537   6.315  1.00 60.74           N  
ATOM    674  CZ  ARG A  98     -37.627   7.562   5.746  1.00 65.78           C  
ATOM    675  NH1 ARG A  98     -36.572   7.140   6.432  1.00 69.10           N  
ATOM    676  NH2 ARG A  98     -37.470   7.998   4.497  1.00 63.28           N  
ATOM    677  N   LEU A  99     -38.780  11.646   1.905  1.00 39.61           N  
ATOM    678  CA  LEU A  99     -37.600  12.473   1.648  1.00 36.93           C  
ATOM    679  C   LEU A  99     -38.036  13.927   1.605  1.00 36.12           C  
ATOM    680  O   LEU A  99     -37.426  14.779   2.241  1.00 35.90           O  
ATOM    681  CB  LEU A  99     -36.963  12.097   0.324  1.00 36.56           C  
ATOM    682  CG  LEU A  99     -36.279  10.737   0.377  1.00 39.32           C  
ATOM    683  CD1 LEU A  99     -35.612  10.443  -0.955  1.00 36.61           C  
ATOM    684  CD2 LEU A  99     -35.260  10.735   1.515  1.00 38.10           C  
ATOM    685  N   LYS A 100     -39.089  14.192   0.830  1.00 36.12           N  
ATOM    686  CA  LYS A 100     -39.666  15.529   0.693  1.00 36.22           C  
ATOM    687  C   LYS A 100     -39.858  16.167   2.063  1.00 34.40           C  
ATOM    688  O   LYS A 100     -39.531  17.344   2.261  1.00 35.24           O  
ATOM    689  CB  LYS A 100     -41.019  15.471  -0.035  1.00 36.26           C  
ATOM    690  CG  LYS A 100     -40.932  15.434  -1.563  1.00 36.82           C  
ATOM    691  CD  LYS A 100     -40.288  16.698  -2.177  1.00 36.74           C  
ATOM    692  CE  LYS A 100     -41.183  17.956  -2.145  1.00 34.98           C  
ATOM    693  NZ  LYS A 100     -40.994  18.827  -0.936  1.00 33.30           N  
ATOM    694  N   LEU A 101     -40.406  15.390   2.993  1.00 32.14           N  
ATOM    695  CA  LEU A 101     -40.634  15.868   4.351  1.00 34.30           C  
ATOM    696  C   LEU A 101     -39.339  16.084   5.138  1.00 33.75           C  
ATOM    697  O   LEU A 101     -39.312  16.822   6.125  1.00 32.37           O  
ATOM    698  CB  LEU A 101     -41.550  14.903   5.100  1.00 35.38           C  
ATOM    699  CG  LEU A 101     -43.045  15.171   4.945  1.00 37.30           C  
ATOM    700  CD1 LEU A 101     -43.830  13.969   5.398  1.00 38.89           C  
ATOM    701  CD2 LEU A 101     -43.441  16.398   5.749  1.00 35.62           C  
ATOM    702  N   GLU A 102     -38.284  15.385   4.744  1.00 35.83           N  
ATOM    703  CA  GLU A 102     -37.010  15.549   5.419  1.00 38.24           C  
ATOM    704  C   GLU A 102     -36.404  16.904   5.081  1.00 38.21           C  
ATOM    705  O   GLU A 102     -35.903  17.597   5.970  1.00 39.03           O  
ATOM    706  CB  GLU A 102     -36.045  14.425   5.055  1.00 40.68           C  
ATOM    707  CG  GLU A 102     -36.364  13.110   5.730  1.00 44.68           C  
ATOM    708  CD  GLU A 102     -35.228  12.111   5.634  1.00 48.69           C  
ATOM    709  OE1 GLU A 102     -34.870  11.546   6.694  1.00 54.50           O  
ATOM    710  OE2 GLU A 102     -34.704  11.886   4.513  1.00 48.05           O  
ATOM    711  N   VAL A 103     -36.402  17.257   3.797  1.00 37.41           N  
ATOM    712  CA  VAL A 103     -35.877  18.548   3.378  1.00 37.03           C  
ATOM    713  C   VAL A 103     -36.734  19.709   3.941  1.00 37.62           C  
ATOM    714  O   VAL A 103     -36.253  20.838   4.069  1.00 39.20           O  
ATOM    715  CB  VAL A 103     -35.673  18.609   1.841  1.00 36.33           C  
ATOM    716  CG1 VAL A 103     -36.744  17.841   1.128  1.00 36.71           C  
ATOM    717  CG2 VAL A 103     -35.614  20.046   1.349  1.00 35.08           C  
ATOM    718  N   SER A 104     -37.984  19.423   4.307  1.00 37.00           N  
ATOM    719  CA  SER A 104     -38.857  20.437   4.909  1.00 35.49           C  
ATOM    720  C   SER A 104     -38.422  20.587   6.354  1.00 34.66           C  
ATOM    721  O   SER A 104     -38.577  21.646   6.954  1.00 35.94           O  
ATOM    722  CB  SER A 104     -40.338  20.026   4.837  1.00 33.15           C  
ATOM    723  OG  SER A 104     -40.854  20.260   3.533  1.00 36.25           O  
ATOM    724  N   ARG A 105     -37.872  19.507   6.903  1.00 36.37           N  
ATOM    725  CA  ARG A 105     -37.366  19.497   8.278  1.00 36.46           C  
ATOM    726  C   ARG A 105     -36.000  20.185   8.319  1.00 35.94           C  
ATOM    727  O   ARG A 105     -35.710  20.997   9.205  1.00 37.71           O  
ATOM    728  CB  ARG A 105     -37.188  18.051   8.763  1.00 33.23           C  
ATOM    729  CG  ARG A 105     -36.564  17.912  10.179  1.00 35.75           C  
ATOM    730  CD  ARG A 105     -36.040  16.499  10.415  1.00 30.29           C  
ATOM    731  NE  ARG A 105     -35.069  16.150   9.378  1.00 31.74           N  
ATOM    732  CZ  ARG A 105     -34.822  14.920   8.938  1.00 29.22           C  
ATOM    733  NH1 ARG A 105     -33.922  14.731   7.984  1.00 23.44           N  
ATOM    734  NH2 ARG A 105     -35.463  13.880   9.451  1.00 32.10           N  
ATOM    735  N   ASP A 106     -35.167  19.843   7.348  1.00 35.08           N  
ATOM    736  CA  ASP A 106     -33.818  20.357   7.280  1.00 36.79           C  
ATOM    737  C   ASP A 106     -33.594  21.686   6.580  1.00 37.91           C  
ATOM    738  O   ASP A 106     -32.765  22.471   7.032  1.00 40.17           O  
ATOM    739  CB  ASP A 106     -32.916  19.268   6.708  1.00 40.09           C  
ATOM    740  CG  ASP A 106     -33.057  17.947   7.466  1.00 42.20           C  
ATOM    741  OD1 ASP A 106     -32.891  16.875   6.838  1.00 43.87           O  
ATOM    742  OD2 ASP A 106     -33.351  17.989   8.686  1.00 38.89           O  
ATOM    743  N   TYR A 107     -34.311  21.944   5.487  1.00 37.62           N  
ATOM    744  CA  TYR A 107     -34.160  23.204   4.759  1.00 35.48           C  
ATOM    745  C   TYR A 107     -35.459  24.013   4.673  1.00 31.62           C  
ATOM    746  O   TYR A 107     -35.881  24.368   3.583  1.00 30.29           O  
ATOM    747  CB  TYR A 107     -33.683  22.945   3.337  1.00 39.32           C  
ATOM    748  CG  TYR A 107     -32.493  22.037   3.180  1.00 44.60           C  
ATOM    749  CD1 TYR A 107     -31.215  22.560   3.030  1.00 48.18           C  
ATOM    750  CD2 TYR A 107     -32.658  20.668   3.031  1.00 47.30           C  
ATOM    751  CE1 TYR A 107     -30.131  21.746   2.712  1.00 51.29           C  
ATOM    752  CE2 TYR A 107     -31.585  19.845   2.714  1.00 50.15           C  
ATOM    753  CZ  TYR A 107     -30.322  20.390   2.546  1.00 51.99           C  
ATOM    754  OH  TYR A 107     -29.273  19.597   2.123  1.00 53.58           O  
ATOM    755  N   PRO A 108     -36.094  24.333   5.812  1.00 30.45           N  
ATOM    756  CA  PRO A 108     -37.339  25.100   5.788  1.00 30.23           C  
ATOM    757  C   PRO A 108     -37.233  26.566   5.380  1.00 32.61           C  
ATOM    758  O   PRO A 108     -38.249  27.179   5.041  1.00 35.31           O  
ATOM    759  CB  PRO A 108     -37.858  24.947   7.211  1.00 31.94           C  
ATOM    760  CG  PRO A 108     -36.603  24.864   8.004  1.00 30.84           C  
ATOM    761  CD  PRO A 108     -35.767  23.932   7.189  1.00 28.89           C  
ATOM    762  N   GLN A 109     -36.044  27.157   5.469  1.00 32.96           N  
ATOM    763  CA  GLN A 109     -35.886  28.552   5.056  1.00 33.52           C  
ATOM    764  C   GLN A 109     -35.911  28.603   3.521  1.00 32.02           C  
ATOM    765  O   GLN A 109     -36.650  29.398   2.936  1.00 33.96           O  
ATOM    766  CB  GLN A 109     -34.584  29.148   5.604  1.00 38.95           C  
ATOM    767  CG  GLN A 109     -34.417  30.670   5.394  1.00 43.94           C  
ATOM    768  CD  GLN A 109     -33.191  31.242   6.119  1.00 48.08           C  
ATOM    769  OE1 GLN A 109     -32.159  30.576   6.259  1.00 49.69           O  
ATOM    770  NE2 GLN A 109     -33.312  32.471   6.600  1.00 47.90           N  
ATOM    771  N   ALA A 110     -35.117  27.746   2.876  1.00 28.91           N  
ATOM    772  CA  ALA A 110     -35.065  27.680   1.415  1.00 28.44           C  
ATOM    773  C   ALA A 110     -36.475  27.429   0.873  1.00 29.23           C  
ATOM    774  O   ALA A 110     -36.905  28.035  -0.111  1.00 31.61           O  
ATOM    775  CB  ALA A 110     -34.137  26.573   0.980  1.00 26.12           C  
ATOM    776  N   SER A 111     -37.167  26.504   1.518  1.00 27.51           N  
ATOM    777  CA  SER A 111     -38.516  26.163   1.159  1.00 27.14           C  
ATOM    778  C   SER A 111     -39.340  27.446   1.259  1.00 26.60           C  
ATOM    779  O   SER A 111     -40.030  27.821   0.314  1.00 30.03           O  
ATOM    780  CB  SER A 111     -39.043  25.094   2.134  1.00 29.63           C  
ATOM    781  OG  SER A 111     -40.361  24.658   1.816  1.00 32.01           O  
ATOM    782  N   ARG A 112     -39.239  28.153   2.377  1.00 24.27           N  
ATOM    783  CA  ARG A 112     -40.023  29.362   2.511  1.00 23.96           C  
ATOM    784  C   ARG A 112     -39.743  30.387   1.444  1.00 24.87           C  
ATOM    785  O   ARG A 112     -40.659  31.090   1.018  1.00 28.20           O  
ATOM    786  CB  ARG A 112     -39.872  29.980   3.882  1.00 22.28           C  
ATOM    787  CG  ARG A 112     -40.689  29.263   4.894  1.00 26.15           C  
ATOM    788  CD  ARG A 112     -40.696  29.992   6.204  1.00 35.44           C  
ATOM    789  NE  ARG A 112     -40.314  29.084   7.274  1.00 43.71           N  
ATOM    790  CZ  ARG A 112     -39.092  29.014   7.778  1.00 47.34           C  
ATOM    791  NH1 ARG A 112     -38.832  28.142   8.739  1.00 48.90           N  
ATOM    792  NH2 ARG A 112     -38.140  29.839   7.346  1.00 47.64           N  
ATOM    793  N   LEU A 113     -38.500  30.470   0.993  1.00 25.77           N  
ATOM    794  CA  LEU A 113     -38.146  31.437  -0.041  1.00 28.05           C  
ATOM    795  C   LEU A 113     -38.804  31.065  -1.381  1.00 29.46           C  
ATOM    796  O   LEU A 113     -39.280  31.947  -2.106  1.00 29.37           O  
ATOM    797  CB  LEU A 113     -36.621  31.531  -0.183  1.00 28.56           C  
ATOM    798  CG  LEU A 113     -35.980  32.849  -0.649  1.00 29.60           C  
ATOM    799  CD1 LEU A 113     -35.452  32.748  -2.051  1.00 30.81           C  
ATOM    800  CD2 LEU A 113     -36.945  33.995  -0.515  1.00 28.55           C  
ATOM    801  N   PHE A 114     -38.828  29.771  -1.703  1.00 27.90           N  
ATOM    802  CA  PHE A 114     -39.438  29.308  -2.946  1.00 27.09           C  
ATOM    803  C   PHE A 114     -40.921  29.684  -2.954  1.00 27.21           C  
ATOM    804  O   PHE A 114     -41.469  30.071  -3.988  1.00 27.86           O  
ATOM    805  CB  PHE A 114     -39.283  27.794  -3.092  1.00 24.63           C  
ATOM    806  CG  PHE A 114     -39.627  27.273  -4.469  1.00 21.53           C  
ATOM    807  CD1 PHE A 114     -40.948  27.002  -4.820  1.00 19.99           C  
ATOM    808  CD2 PHE A 114     -38.627  27.084  -5.426  1.00 19.94           C  
ATOM    809  CE1 PHE A 114     -41.269  26.556  -6.110  1.00 16.00           C  
ATOM    810  CE2 PHE A 114     -38.935  26.638  -6.719  1.00 16.20           C  
ATOM    811  CZ  PHE A 114     -40.255  26.375  -7.059  1.00 15.98           C  
ATOM    812  N   CYS A 115     -41.558  29.570  -1.794  1.00 27.55           N  
ATOM    813  CA  CYS A 115     -42.966  29.893  -1.649  1.00 28.10           C  
ATOM    814  C   CYS A 115     -43.196  31.371  -1.923  1.00 29.77           C  
ATOM    815  O   CYS A 115     -44.143  31.735  -2.627  1.00 30.78           O  
ATOM    816  CB  CYS A 115     -43.423  29.540  -0.248  1.00 27.73           C  
ATOM    817  SG  CYS A 115     -45.189  29.392  -0.082  1.00 29.68           S  
ATOM    818  N   MET A 116     -42.321  32.207  -1.357  1.00 31.08           N  
ATOM    819  CA  MET A 116     -42.340  33.675  -1.525  1.00 30.62           C  
ATOM    820  C   MET A 116     -42.408  34.022  -2.996  1.00 30.48           C  
ATOM    821  O   MET A 116     -43.227  34.845  -3.417  1.00 32.11           O  
ATOM    822  CB  MET A 116     -41.053  34.288  -0.974  1.00 30.81           C  
ATOM    823  CG  MET A 116     -41.223  35.198   0.224  1.00 32.23           C  
ATOM    824  SD  MET A 116     -39.618  35.512   1.023  1.00 31.33           S  
ATOM    825  CE  MET A 116     -39.944  34.867   2.666  1.00 21.93           C  
ATOM    826  N   GLU A 117     -41.497  33.429  -3.761  1.00 30.30           N  
ATOM    827  CA  GLU A 117     -41.438  33.654  -5.194  1.00 30.99           C  
ATOM    828  C   GLU A 117     -42.770  33.290  -5.847  1.00 31.47           C  
ATOM    829  O   GLU A 117     -43.297  34.066  -6.661  1.00 33.12           O  
ATOM    830  CB  GLU A 117     -40.292  32.852  -5.808  1.00 31.01           C  
ATOM    831  CG  GLU A 117     -40.188  32.945  -7.339  1.00 33.34           C  
ATOM    832  CD  GLU A 117     -39.790  34.328  -7.882  1.00 32.91           C  
ATOM    833  OE1 GLU A 117     -39.669  35.306  -7.109  1.00 33.90           O  
ATOM    834  OE2 GLU A 117     -39.596  34.431  -9.112  1.00 29.70           O  
ATOM    835  N   MET A 118     -43.304  32.111  -5.502  1.00 28.60           N  
ATOM    836  CA  MET A 118     -44.589  31.660  -6.049  1.00 24.98           C  
ATOM    837  C   MET A 118     -45.676  32.700  -5.747  1.00 26.02           C  
ATOM    838  O   MET A 118     -46.482  33.047  -6.614  1.00 28.13           O  
ATOM    839  CB  MET A 118     -45.001  30.298  -5.461  1.00 20.73           C  
ATOM    840  CG  MET A 118     -44.136  29.102  -5.880  1.00 12.15           C  
ATOM    841  SD  MET A 118     -43.965  28.904  -7.634  1.00  5.08           S  
ATOM    842  CE  MET A 118     -42.233  29.058  -7.882  1.00  4.65           C  
ATOM    843  N   LEU A 119     -45.707  33.177  -4.506  1.00 25.79           N  
ATOM    844  CA  LEU A 119     -46.687  34.168  -4.108  1.00 23.41           C  
ATOM    845  C   LEU A 119     -46.490  35.468  -4.876  1.00 26.25           C  
ATOM    846  O   LEU A 119     -47.366  36.345  -4.858  1.00 31.33           O  
ATOM    847  CB  LEU A 119     -46.576  34.450  -2.620  1.00 18.42           C  
ATOM    848  CG  LEU A 119     -46.706  33.268  -1.671  1.00 16.52           C  
ATOM    849  CD1 LEU A 119     -46.873  33.800  -0.234  1.00 13.86           C  
ATOM    850  CD2 LEU A 119     -47.907  32.426  -2.076  1.00 16.33           C  
ATOM    851  N   ALA A 120     -45.343  35.608  -5.526  1.00 23.80           N  
ATOM    852  CA  ALA A 120     -45.073  36.820  -6.271  1.00 24.69           C  
ATOM    853  C   ALA A 120     -45.418  36.633  -7.736  1.00 25.32           C  
ATOM    854  O   ALA A 120     -45.181  37.518  -8.561  1.00 27.53           O  
ATOM    855  CB  ALA A 120     -43.620  37.205  -6.114  1.00 24.91           C  
ATOM    856  N   GLY A 121     -46.007  35.490  -8.061  1.00 23.49           N  
ATOM    857  CA  GLY A 121     -46.344  35.209  -9.442  1.00 24.62           C  
ATOM    858  C   GLY A 121     -45.152  34.609 -10.174  1.00 27.21           C  
ATOM    859  O   GLY A 121     -45.180  34.432 -11.387  1.00 31.54           O  
ATOM    860  N   ALA A 122     -44.113  34.240  -9.432  1.00 26.98           N  
ATOM    861  CA  ALA A 122     -42.901  33.676 -10.009  1.00 26.11           C  
ATOM    862  C   ALA A 122     -42.319  34.552 -11.127  1.00 27.86           C  
ATOM    863  O   ALA A 122     -41.859  34.032 -12.143  1.00 26.83           O  
ATOM    864  CB  ALA A 122     -43.161  32.275 -10.522  1.00 22.59           C  
ATOM    865  N   PRO A 123     -42.249  35.883 -10.913  1.00 28.97           N  
ATOM    866  CA  PRO A 123     -41.712  36.782 -11.928  1.00 31.00           C  
ATOM    867  C   PRO A 123     -40.342  36.400 -12.392  1.00 34.30           C  
ATOM    868  O   PRO A 123     -40.101  36.317 -13.593  1.00 37.11           O  
ATOM    869  CB  PRO A 123     -41.682  38.124 -11.213  1.00 31.29           C  
ATOM    870  CG  PRO A 123     -41.553  37.768  -9.795  1.00 31.05           C  
ATOM    871  CD  PRO A 123     -42.515  36.636  -9.677  1.00 30.12           C  
ATOM    872  N   LEU A 124     -39.442  36.172 -11.444  1.00 36.52           N  
ATOM    873  CA  LEU A 124     -38.067  35.810 -11.786  1.00 38.02           C  
ATOM    874  C   LEU A 124     -37.823  34.342 -12.104  1.00 38.81           C  
ATOM    875  O   LEU A 124     -37.030  34.032 -12.981  1.00 40.85           O  
ATOM    876  CB  LEU A 124     -37.095  36.287 -10.704  1.00 36.48           C  
ATOM    877  CG  LEU A 124     -37.052  37.811 -10.560  1.00 36.23           C  
ATOM    878  CD1 LEU A 124     -37.880  38.250  -9.372  1.00 39.41           C  
ATOM    879  CD2 LEU A 124     -35.644  38.273 -10.393  1.00 36.59           C  
ATOM    880  N   LEU A 125     -38.506  33.448 -11.397  1.00 40.67           N  
ATOM    881  CA  LEU A 125     -38.335  32.006 -11.599  1.00 40.66           C  
ATOM    882  C   LEU A 125     -39.142  31.380 -12.740  1.00 40.58           C  
ATOM    883  O   LEU A 125     -38.930  30.217 -13.080  1.00 40.10           O  
ATOM    884  CB  LEU A 125     -38.707  31.266 -10.314  1.00 41.09           C  
ATOM    885  CG  LEU A 125     -37.701  30.340  -9.632  1.00 42.35           C  
ATOM    886  CD1 LEU A 125     -38.494  29.397  -8.739  1.00 43.43           C  
ATOM    887  CD2 LEU A 125     -36.886  29.548 -10.631  1.00 42.29           C  
ATOM    888  N   MET A 126     -40.109  32.119 -13.276  1.00 41.92           N  
ATOM    889  CA  MET A 126     -40.973  31.591 -14.327  1.00 42.86           C  
ATOM    890  C   MET A 126     -40.294  30.749 -15.411  1.00 44.80           C  
ATOM    891  O   MET A 126     -40.669  29.591 -15.602  1.00 45.17           O  
ATOM    892  CB  MET A 126     -41.833  32.706 -14.949  1.00 37.82           C  
ATOM    893  CG  MET A 126     -43.016  32.213 -15.814  1.00 34.22           C  
ATOM    894  SD  MET A 126     -44.188  31.075 -15.011  1.00 23.24           S  
ATOM    895  CE  MET A 126     -45.039  32.233 -13.936  1.00 25.66           C  
ATOM    896  N   ASP A 127     -39.294  31.307 -16.088  1.00 46.97           N  
ATOM    897  CA  ASP A 127     -38.609  30.592 -17.161  1.00 50.39           C  
ATOM    898  C   ASP A 127     -38.026  29.235 -16.797  1.00 51.49           C  
ATOM    899  O   ASP A 127     -37.789  28.393 -17.674  1.00 52.62           O  
ATOM    900  CB  ASP A 127     -37.552  31.480 -17.814  1.00 55.52           C  
ATOM    901  CG  ASP A 127     -38.158  32.491 -18.771  1.00 59.71           C  
ATOM    902  OD1 ASP A 127     -38.124  32.243 -19.995  1.00 62.43           O  
ATOM    903  OD2 ASP A 127     -38.689  33.523 -18.301  1.00 63.66           O  
ATOM    904  N   GLU A 128     -37.761  29.033 -15.512  1.00 52.54           N  
ATOM    905  CA  GLU A 128     -37.224  27.761 -15.039  1.00 52.35           C  
ATOM    906  C   GLU A 128     -38.369  26.746 -14.946  1.00 50.71           C  
ATOM    907  O   GLU A 128     -38.205  25.556 -15.244  1.00 49.97           O  
ATOM    908  CB  GLU A 128     -36.559  27.948 -13.669  1.00 54.06           C  
ATOM    909  CG  GLU A 128     -35.051  27.748 -13.672  1.00 61.75           C  
ATOM    910  CD  GLU A 128     -34.648  26.304 -13.992  1.00 66.85           C  
ATOM    911  OE1 GLU A 128     -35.441  25.378 -13.702  1.00 69.11           O  
ATOM    912  OE2 GLU A 128     -33.539  26.090 -14.537  1.00 68.17           O  
ATOM    913  N   LEU A 129     -39.523  27.236 -14.505  1.00 48.10           N  
ATOM    914  CA  LEU A 129     -40.714  26.425 -14.346  1.00 44.64           C  
ATOM    915  C   LEU A 129     -41.233  25.931 -15.688  1.00 45.07           C  
ATOM    916  O   LEU A 129     -41.415  24.734 -15.890  1.00 44.73           O  
ATOM    917  CB  LEU A 129     -41.796  27.250 -13.645  1.00 40.38           C  
ATOM    918  CG  LEU A 129     -41.935  27.304 -12.121  1.00 34.81           C  
ATOM    919  CD1 LEU A 129     -40.661  27.014 -11.348  1.00 29.93           C  
ATOM    920  CD2 LEU A 129     -42.465  28.666 -11.800  1.00 33.57           C  
ATOM    921  N   THR A 130     -41.513  26.870 -16.585  1.00 46.53           N  
ATOM    922  CA  THR A 130     -42.042  26.541 -17.899  1.00 46.45           C  
ATOM    923  C   THR A 130     -41.011  25.822 -18.747  1.00 49.62           C  
ATOM    924  O   THR A 130     -41.361  25.122 -19.701  1.00 51.71           O  
ATOM    925  CB  THR A 130     -42.549  27.795 -18.624  1.00 43.02           C  
ATOM    926  OG1 THR A 130     -41.492  28.752 -18.743  1.00 43.15           O  
ATOM    927  CG2 THR A 130     -43.684  28.425 -17.845  1.00 41.36           C  
ATOM    928  N   GLY A 131     -39.741  25.988 -18.383  1.00 51.89           N  
ATOM    929  CA  GLY A 131     -38.660  25.345 -19.104  1.00 52.49           C  
ATOM    930  C   GLY A 131     -38.398  23.931 -18.613  1.00 53.99           C  
ATOM    931  O   GLY A 131     -39.167  23.001 -18.896  1.00 55.21           O  
ATOM    932  N   ASP A 132     -37.284  23.770 -17.904  1.00 53.42           N  
ATOM    933  CA  ASP A 132     -36.869  22.480 -17.354  1.00 52.61           C  
ATOM    934  C   ASP A 132     -37.917  21.757 -16.517  1.00 50.32           C  
ATOM    935  O   ASP A 132     -38.264  20.617 -16.817  1.00 51.85           O  
ATOM    936  CB  ASP A 132     -35.621  22.663 -16.503  1.00 56.86           C  
ATOM    937  CG  ASP A 132     -34.501  23.294 -17.264  1.00 60.83           C  
ATOM    938  OD1 ASP A 132     -34.509  24.537 -17.394  1.00 63.53           O  
ATOM    939  OD2 ASP A 132     -33.626  22.546 -17.747  1.00 64.30           O  
ATOM    940  N   LEU A 133     -38.393  22.412 -15.463  1.00 47.73           N  
ATOM    941  CA  LEU A 133     -39.379  21.824 -14.567  1.00 47.19           C  
ATOM    942  C   LEU A 133     -40.565  21.233 -15.323  1.00 49.00           C  
ATOM    943  O   LEU A 133     -40.922  20.069 -15.108  1.00 50.26           O  
ATOM    944  CB  LEU A 133     -39.848  22.867 -13.551  1.00 45.24           C  
ATOM    945  CG  LEU A 133     -40.555  22.395 -12.277  1.00 42.34           C  
ATOM    946  CD1 LEU A 133     -42.050  22.463 -12.412  1.00 44.24           C  
ATOM    947  CD2 LEU A 133     -40.099  21.006 -11.909  1.00 38.10           C  
ATOM    948  N   LYS A 134     -41.178  22.032 -16.196  1.00 48.65           N  
ATOM    949  CA  LYS A 134     -42.318  21.563 -16.971  1.00 47.40           C  
ATOM    950  C   LYS A 134     -41.906  20.339 -17.743  1.00 46.94           C  
ATOM    951  O   LYS A 134     -42.639  19.362 -17.790  1.00 49.25           O  
ATOM    952  CB  LYS A 134     -42.804  22.616 -17.960  1.00 48.61           C  
ATOM    953  CG  LYS A 134     -44.031  22.139 -18.704  1.00 50.15           C  
ATOM    954  CD  LYS A 134     -44.535  23.121 -19.729  1.00 50.09           C  
ATOM    955  CE  LYS A 134     -45.912  22.702 -20.171  1.00 51.28           C  
ATOM    956  NZ  LYS A 134     -45.965  21.242 -20.432  1.00 52.88           N  
ATOM    957  N   ALA A 135     -40.732  20.418 -18.362  1.00 47.60           N  
ATOM    958  CA  ALA A 135     -40.180  19.329 -19.150  1.00 46.84           C  
ATOM    959  C   ALA A 135     -40.033  18.056 -18.332  1.00 46.29           C  
ATOM    960  O   ALA A 135     -40.347  16.972 -18.819  1.00 49.66           O  
ATOM    961  CB  ALA A 135     -38.848  19.737 -19.726  1.00 46.55           C  
ATOM    962  N   LEU A 136     -39.561  18.185 -17.096  1.00 45.03           N  
ATOM    963  CA  LEU A 136     -39.368  17.034 -16.214  1.00 45.25           C  
ATOM    964  C   LEU A 136     -40.676  16.428 -15.723  1.00 45.57           C  
ATOM    965  O   LEU A 136     -40.796  15.215 -15.588  1.00 45.64           O  
ATOM    966  CB  LEU A 136     -38.497  17.424 -15.009  1.00 44.74           C  
ATOM    967  CG  LEU A 136     -38.325  16.453 -13.831  1.00 42.08           C  
ATOM    968  CD1 LEU A 136     -37.715  15.133 -14.279  1.00 42.97           C  
ATOM    969  CD2 LEU A 136     -37.455  17.111 -12.769  1.00 41.67           C  
ATOM    970  N   ILE A 137     -41.631  17.283 -15.393  1.00 46.57           N  
ATOM    971  CA  ILE A 137     -42.908  16.806 -14.905  1.00 47.57           C  
ATOM    972  C   ILE A 137     -43.616  16.052 -16.024  1.00 49.42           C  
ATOM    973  O   ILE A 137     -44.116  14.953 -15.803  1.00 47.60           O  
ATOM    974  CB  ILE A 137     -43.788  17.968 -14.343  1.00 46.24           C  
ATOM    975  CG1 ILE A 137     -43.000  18.771 -13.297  1.00 42.28           C  
ATOM    976  CG2 ILE A 137     -45.084  17.425 -13.734  1.00 42.51           C  
ATOM    977  CD1 ILE A 137     -42.347  17.943 -12.229  1.00 38.83           C  
ATOM    978  N   ASP A 138     -43.597  16.616 -17.231  1.00 52.24           N  
ATOM    979  CA  ASP A 138     -44.236  15.987 -18.389  1.00 56.19           C  
ATOM    980  C   ASP A 138     -43.737  14.559 -18.579  1.00 59.00           C  
ATOM    981  O   ASP A 138     -44.514  13.649 -18.903  1.00 60.26           O  
ATOM    982  CB  ASP A 138     -43.957  16.786 -19.662  1.00 54.45           C  
ATOM    983  CG  ASP A 138     -44.720  18.091 -19.717  1.00 55.57           C  
ATOM    984  OD1 ASP A 138     -44.600  18.787 -20.743  1.00 58.35           O  
ATOM    985  OD2 ASP A 138     -45.436  18.435 -18.750  1.00 55.47           O  
ATOM    986  N   GLU A 139     -42.431  14.387 -18.398  1.00 60.75           N  
ATOM    987  CA  GLU A 139     -41.775  13.098 -18.546  1.00 62.27           C  
ATOM    988  C   GLU A 139     -42.170  12.107 -17.453  1.00 61.19           C  
ATOM    989  O   GLU A 139     -42.605  10.988 -17.749  1.00 62.85           O  
ATOM    990  CB  GLU A 139     -40.257  13.290 -18.540  1.00 66.81           C  
ATOM    991  CG  GLU A 139     -39.464  12.006 -18.731  1.00 74.54           C  
ATOM    992  CD  GLU A 139     -38.151  12.020 -17.968  1.00 78.60           C  
ATOM    993  OE1 GLU A 139     -37.838  10.999 -17.307  1.00 80.42           O  
ATOM    994  OE2 GLU A 139     -37.440  13.052 -18.021  1.00 81.24           O  
ATOM    995  N   LYS A 140     -41.946  12.495 -16.198  1.00 58.40           N  
ATOM    996  CA  LYS A 140     -42.264  11.644 -15.062  1.00 55.24           C  
ATOM    997  C   LYS A 140     -43.756  11.461 -14.869  1.00 54.37           C  
ATOM    998  O   LYS A 140     -44.172  10.530 -14.184  1.00 54.66           O  
ATOM    999  CB  LYS A 140     -41.638  12.192 -13.784  1.00 54.54           C  
ATOM   1000  CG  LYS A 140     -40.119  12.264 -13.810  1.00 54.34           C  
ATOM   1001  CD  LYS A 140     -39.493  10.913 -14.114  1.00 55.23           C  
ATOM   1002  CE  LYS A 140     -37.974  10.979 -14.050  1.00 55.77           C  
ATOM   1003  NZ  LYS A 140     -37.310   9.873 -14.800  1.00 55.23           N  
ATOM   1004  N   SER A 141     -44.556  12.382 -15.399  1.00 53.61           N  
ATOM   1005  CA  SER A 141     -46.010  12.274 -15.295  1.00 53.49           C  
ATOM   1006  C   SER A 141     -46.397  11.068 -16.131  1.00 54.39           C  
ATOM   1007  O   SER A 141     -47.169  10.211 -15.690  1.00 54.08           O  
ATOM   1008  CB  SER A 141     -46.706  13.520 -15.852  1.00 52.37           C  
ATOM   1009  OG  SER A 141     -46.641  14.602 -14.938  1.00 52.20           O  
ATOM   1010  N   ALA A 142     -45.841  11.013 -17.342  1.00 54.36           N  
ATOM   1011  CA  ALA A 142     -46.081   9.920 -18.274  1.00 53.13           C  
ATOM   1012  C   ALA A 142     -45.730   8.581 -17.629  1.00 52.48           C  
ATOM   1013  O   ALA A 142     -46.354   7.561 -17.920  1.00 53.34           O  
ATOM   1014  CB  ALA A 142     -45.270  10.132 -19.538  1.00 52.42           C  
ATOM   1015  N   LEU A 143     -44.712   8.585 -16.777  1.00 52.29           N  
ATOM   1016  CA  LEU A 143     -44.296   7.373 -16.079  1.00 52.66           C  
ATOM   1017  C   LEU A 143     -45.437   6.883 -15.198  1.00 52.38           C  
ATOM   1018  O   LEU A 143     -45.872   5.741 -15.302  1.00 53.75           O  
ATOM   1019  CB  LEU A 143     -43.086   7.658 -15.189  1.00 52.05           C  
ATOM   1020  CG  LEU A 143     -41.821   6.846 -15.430  1.00 51.32           C  
ATOM   1021  CD1 LEU A 143     -41.147   7.354 -16.699  1.00 52.67           C  
ATOM   1022  CD2 LEU A 143     -40.899   6.978 -14.230  1.00 50.63           C  
ATOM   1023  N   ILE A 144     -45.873   7.763 -14.302  1.00 52.30           N  
ATOM   1024  CA  ILE A 144     -46.950   7.485 -13.365  1.00 51.69           C  
ATOM   1025  C   ILE A 144     -48.218   7.176 -14.139  1.00 51.17           C  
ATOM   1026  O   ILE A 144     -49.006   6.323 -13.727  1.00 49.09           O  
ATOM   1027  CB  ILE A 144     -47.160   8.691 -12.392  1.00 52.21           C  
ATOM   1028  CG1 ILE A 144     -45.913   8.877 -11.520  1.00 49.04           C  
ATOM   1029  CG2 ILE A 144     -48.384   8.477 -11.511  1.00 51.82           C  
ATOM   1030  CD1 ILE A 144     -45.855  10.195 -10.793  1.00 45.29           C  
ATOM   1031  N   ALA A 145     -48.410   7.881 -15.254  1.00 53.61           N  
ATOM   1032  CA  ALA A 145     -49.575   7.676 -16.117  1.00 57.25           C  
ATOM   1033  C   ALA A 145     -49.577   6.209 -16.513  1.00 60.20           C  
ATOM   1034  O   ALA A 145     -50.634   5.622 -16.744  1.00 62.21           O  
ATOM   1035  CB  ALA A 145     -49.489   8.555 -17.365  1.00 55.82           C  
ATOM   1036  N   GLY A 146     -48.376   5.645 -16.631  1.00 60.71           N  
ATOM   1037  CA  GLY A 146     -48.231   4.247 -16.970  1.00 58.37           C  
ATOM   1038  C   GLY A 146     -48.593   3.365 -15.792  1.00 58.18           C  
ATOM   1039  O   GLY A 146     -49.253   2.358 -15.992  1.00 57.73           O  
ATOM   1040  N   TRP A 147     -48.178   3.724 -14.575  1.00 59.62           N  
ATOM   1041  CA  TRP A 147     -48.501   2.894 -13.414  1.00 61.61           C  
ATOM   1042  C   TRP A 147     -50.009   2.680 -13.364  1.00 62.68           C  
ATOM   1043  O   TRP A 147     -50.468   1.579 -13.071  1.00 62.47           O  
ATOM   1044  CB  TRP A 147     -48.101   3.522 -12.065  1.00 63.75           C  
ATOM   1045  CG  TRP A 147     -46.749   4.207 -11.907  1.00 63.90           C  
ATOM   1046  CD1 TRP A 147     -46.466   5.222 -11.030  1.00 63.91           C  
ATOM   1047  CD2 TRP A 147     -45.528   3.954 -12.625  1.00 63.68           C  
ATOM   1048  NE1 TRP A 147     -45.162   5.620 -11.161  1.00 63.06           N  
ATOM   1049  CE2 TRP A 147     -44.559   4.861 -12.129  1.00 63.11           C  
ATOM   1050  CE3 TRP A 147     -45.158   3.058 -13.635  1.00 62.86           C  
ATOM   1051  CZ2 TRP A 147     -43.249   4.900 -12.610  1.00 61.58           C  
ATOM   1052  CZ3 TRP A 147     -43.851   3.099 -14.114  1.00 63.23           C  
ATOM   1053  CH2 TRP A 147     -42.915   4.015 -13.598  1.00 64.14           C  
ATOM   1054  N   VAL A 148     -50.774   3.752 -13.583  1.00 64.16           N  
ATOM   1055  CA  VAL A 148     -52.237   3.654 -13.547  1.00 64.84           C  
ATOM   1056  C   VAL A 148     -52.744   2.814 -14.721  1.00 64.46           C  
ATOM   1057  O   VAL A 148     -53.702   2.047 -14.582  1.00 64.19           O  
ATOM   1058  CB  VAL A 148     -52.940   5.062 -13.516  1.00 64.79           C  
ATOM   1059  CG1 VAL A 148     -52.220   5.991 -12.558  1.00 64.42           C  
ATOM   1060  CG2 VAL A 148     -53.032   5.682 -14.894  1.00 64.26           C  
ATOM   1061  N   LYS A 149     -52.084   2.967 -15.868  1.00 64.45           N  
ATOM   1062  CA  LYS A 149     -52.412   2.241 -17.087  1.00 62.51           C  
ATOM   1063  C   LYS A 149     -52.194   0.740 -16.884  1.00 60.67           C  
ATOM   1064  O   LYS A 149     -53.006  -0.069 -17.320  1.00 60.80           O  
ATOM   1065  CB  LYS A 149     -51.558   2.788 -18.237  1.00 63.51           C  
ATOM   1066  CG  LYS A 149     -51.614   2.022 -19.549  1.00 68.56           C  
ATOM   1067  CD  LYS A 149     -50.623   0.829 -19.603  1.00 71.70           C  
ATOM   1068  CE  LYS A 149     -49.164   1.218 -19.268  1.00 72.15           C  
ATOM   1069  NZ  LYS A 149     -48.516   2.172 -20.218  1.00 71.47           N  
ATOM   1070  N   SER A 150     -51.092   0.374 -16.239  1.00 58.92           N  
ATOM   1071  CA  SER A 150     -50.782  -1.025 -15.984  1.00 58.27           C  
ATOM   1072  C   SER A 150     -51.577  -1.555 -14.791  1.00 57.23           C  
ATOM   1073  O   SER A 150     -51.369  -2.687 -14.338  1.00 58.63           O  
ATOM   1074  CB  SER A 150     -49.270  -1.222 -15.763  1.00 61.06           C  
ATOM   1075  OG  SER A 150     -48.831  -0.805 -14.474  1.00 61.95           O  
ATOM   1076  N   GLY A 151     -52.535  -0.759 -14.327  1.00 54.48           N  
ATOM   1077  CA  GLY A 151     -53.341  -1.164 -13.197  1.00 53.71           C  
ATOM   1078  C   GLY A 151     -52.550  -1.213 -11.907  1.00 54.35           C  
ATOM   1079  O   GLY A 151     -53.027  -1.759 -10.898  1.00 54.57           O  
ATOM   1080  N   LYS A 152     -51.334  -0.665 -11.940  1.00 54.03           N  
ATOM   1081  CA  LYS A 152     -50.453  -0.619 -10.769  1.00 53.29           C  
ATOM   1082  C   LYS A 152     -50.828   0.488  -9.777  1.00 50.61           C  
ATOM   1083  O   LYS A 152     -50.380   0.471  -8.626  1.00 49.77           O  
ATOM   1084  CB  LYS A 152     -48.995  -0.444 -11.203  1.00 55.72           C  
ATOM   1085  CG  LYS A 152     -48.237  -1.748 -11.394  1.00 58.62           C  
ATOM   1086  CD  LYS A 152     -46.749  -1.498 -11.597  1.00 62.36           C  
ATOM   1087  CE  LYS A 152     -45.933  -2.782 -11.448  1.00 63.99           C  
ATOM   1088  NZ  LYS A 152     -44.458  -2.524 -11.552  1.00 67.09           N  
ATOM   1089  N   LEU A 153     -51.708   1.391 -10.211  1.00 48.18           N  
ATOM   1090  CA  LEU A 153     -52.157   2.535  -9.417  1.00 45.72           C  
ATOM   1091  C   LEU A 153     -53.623   2.849  -9.755  1.00 43.94           C  
ATOM   1092  O   LEU A 153     -54.102   2.508 -10.841  1.00 41.26           O  
ATOM   1093  CB  LEU A 153     -51.282   3.742  -9.786  1.00 47.07           C  
ATOM   1094  CG  LEU A 153     -50.600   4.622  -8.738  1.00 47.01           C  
ATOM   1095  CD1 LEU A 153     -49.754   3.812  -7.788  1.00 48.19           C  
ATOM   1096  CD2 LEU A 153     -49.736   5.619  -9.463  1.00 46.49           C  
ATOM   1097  N   ALA A 154     -54.329   3.513  -8.836  1.00 43.23           N  
ATOM   1098  CA  ALA A 154     -55.739   3.878  -9.048  1.00 42.12           C  
ATOM   1099  C   ALA A 154     -55.875   4.909 -10.177  1.00 42.72           C  
ATOM   1100  O   ALA A 154     -54.883   5.521 -10.565  1.00 43.17           O  
ATOM   1101  CB  ALA A 154     -56.328   4.423  -7.766  1.00 42.88           C  
ATOM   1102  N   PRO A 155     -57.089   5.089 -10.745  1.00 44.30           N  
ATOM   1103  CA  PRO A 155     -57.306   6.058 -11.833  1.00 45.92           C  
ATOM   1104  C   PRO A 155     -57.156   7.517 -11.378  1.00 48.28           C  
ATOM   1105  O   PRO A 155     -58.117   8.300 -11.363  1.00 47.89           O  
ATOM   1106  CB  PRO A 155     -58.728   5.741 -12.296  1.00 44.28           C  
ATOM   1107  CG  PRO A 155     -59.379   5.238 -11.073  1.00 44.20           C  
ATOM   1108  CD  PRO A 155     -58.327   4.344 -10.470  1.00 45.61           C  
ATOM   1109  N   ILE A 156     -55.919   7.860 -11.030  1.00 49.29           N  
ATOM   1110  CA  ILE A 156     -55.526   9.171 -10.537  1.00 46.60           C  
ATOM   1111  C   ILE A 156     -54.857   9.959 -11.649  1.00 46.23           C  
ATOM   1112  O   ILE A 156     -54.464   9.385 -12.657  1.00 45.07           O  
ATOM   1113  CB  ILE A 156     -54.540   8.982  -9.351  1.00 46.65           C  
ATOM   1114  CG1 ILE A 156     -54.761  10.068  -8.325  1.00 48.78           C  
ATOM   1115  CG2 ILE A 156     -53.086   8.893  -9.817  1.00 43.04           C  
ATOM   1116  CD1 ILE A 156     -56.138  10.012  -7.764  1.00 53.88           C  
ATOM   1117  N   ASP A 157     -54.755  11.275 -11.489  1.00 48.14           N  
ATOM   1118  CA  ASP A 157     -54.090  12.114 -12.491  1.00 48.97           C  
ATOM   1119  C   ASP A 157     -52.679  12.420 -12.006  1.00 48.67           C  
ATOM   1120  O   ASP A 157     -52.513  13.063 -10.969  1.00 48.53           O  
ATOM   1121  CB  ASP A 157     -54.855  13.413 -12.720  1.00 50.54           C  
ATOM   1122  CG  ASP A 157     -55.709  13.364 -13.958  1.00 53.20           C  
ATOM   1123  OD1 ASP A 157     -56.932  13.168 -13.837  1.00 53.42           O  
ATOM   1124  OD2 ASP A 157     -55.149  13.514 -15.059  1.00 57.84           O  
ATOM   1125  N   PRO A 158     -51.645  11.983 -12.763  1.00 47.95           N  
ATOM   1126  CA  PRO A 158     -50.241  12.200 -12.404  1.00 45.29           C  
ATOM   1127  C   PRO A 158     -49.900  13.600 -11.894  1.00 42.73           C  
ATOM   1128  O   PRO A 158     -49.402  13.735 -10.776  1.00 41.44           O  
ATOM   1129  CB  PRO A 158     -49.509  11.852 -13.696  1.00 45.12           C  
ATOM   1130  CG  PRO A 158     -50.346  10.768 -14.246  1.00 45.47           C  
ATOM   1131  CD  PRO A 158     -51.728  11.335 -14.086  1.00 47.38           C  
ATOM   1132  N   GLN A 159     -50.205  14.632 -12.684  1.00 40.61           N  
ATOM   1133  CA  GLN A 159     -49.907  16.008 -12.285  1.00 37.95           C  
ATOM   1134  C   GLN A 159     -50.438  16.350 -10.907  1.00 36.98           C  
ATOM   1135  O   GLN A 159     -49.687  16.821 -10.062  1.00 37.93           O  
ATOM   1136  CB  GLN A 159     -50.475  17.003 -13.283  1.00 39.82           C  
ATOM   1137  CG  GLN A 159     -49.705  17.084 -14.573  1.00 43.86           C  
ATOM   1138  CD  GLN A 159     -50.373  17.998 -15.579  1.00 47.64           C  
ATOM   1139  OE1 GLN A 159     -51.590  18.201 -15.543  1.00 48.07           O  
ATOM   1140  NE2 GLN A 159     -49.583  18.565 -16.476  1.00 49.22           N  
ATOM   1141  N   HIS A 160     -51.733  16.121 -10.695  1.00 33.67           N  
ATOM   1142  CA  HIS A 160     -52.365  16.424  -9.424  1.00 30.23           C  
ATOM   1143  C   HIS A 160     -51.826  15.625  -8.243  1.00 30.48           C  
ATOM   1144  O   HIS A 160     -51.921  16.059  -7.085  1.00 28.48           O  
ATOM   1145  CB  HIS A 160     -53.877  16.289  -9.555  1.00 30.16           C  
ATOM   1146  CG  HIS A 160     -54.482  17.300 -10.480  1.00 30.21           C  
ATOM   1147  ND1 HIS A 160     -54.747  18.597 -10.092  1.00 31.04           N  
ATOM   1148  CD2 HIS A 160     -54.772  17.239 -11.802  1.00 31.63           C  
ATOM   1149  CE1 HIS A 160     -55.159  19.293 -11.138  1.00 32.12           C  
ATOM   1150  NE2 HIS A 160     -55.182  18.492 -12.189  1.00 30.81           N  
ATOM   1151  N   LEU A 161     -51.238  14.470  -8.534  1.00 30.85           N  
ATOM   1152  CA  LEU A 161     -50.677  13.615  -7.488  1.00 29.30           C  
ATOM   1153  C   LEU A 161     -49.406  14.277  -6.988  1.00 28.58           C  
ATOM   1154  O   LEU A 161     -49.149  14.329  -5.788  1.00 28.15           O  
ATOM   1155  CB  LEU A 161     -50.326  12.243  -8.053  1.00 26.39           C  
ATOM   1156  CG  LEU A 161     -50.290  11.029  -7.126  1.00 24.80           C  
ATOM   1157  CD1 LEU A 161     -49.318  10.035  -7.743  1.00 24.02           C  
ATOM   1158  CD2 LEU A 161     -49.861  11.379  -5.699  1.00 21.64           C  
ATOM   1159  N   ILE A 162     -48.597  14.725  -7.943  1.00 27.88           N  
ATOM   1160  CA  ILE A 162     -47.332  15.395  -7.680  1.00 26.26           C  
ATOM   1161  C   ILE A 162     -47.517  16.694  -6.878  1.00 27.17           C  
ATOM   1162  O   ILE A 162     -46.733  16.973  -5.980  1.00 30.95           O  
ATOM   1163  CB  ILE A 162     -46.572  15.625  -9.000  1.00 26.27           C  
ATOM   1164  CG1 ILE A 162     -46.285  14.264  -9.671  1.00 24.42           C  
ATOM   1165  CG2 ILE A 162     -45.281  16.360  -8.746  1.00 27.96           C  
ATOM   1166  CD1 ILE A 162     -45.701  14.339 -11.074  1.00 21.37           C  
ATOM   1167  N   PHE A 163     -48.562  17.465  -7.167  1.00 27.80           N  
ATOM   1168  CA  PHE A 163     -48.851  18.704  -6.425  1.00 23.67           C  
ATOM   1169  C   PHE A 163     -49.334  18.369  -5.013  1.00 23.48           C  
ATOM   1170  O   PHE A 163     -49.138  19.143  -4.091  1.00 24.41           O  
ATOM   1171  CB  PHE A 163     -49.952  19.523  -7.108  1.00 21.56           C  
ATOM   1172  CG  PHE A 163     -49.661  19.888  -8.535  1.00 18.96           C  
ATOM   1173  CD1 PHE A 163     -48.355  20.085  -8.974  1.00 17.52           C  
ATOM   1174  CD2 PHE A 163     -50.709  20.051  -9.437  1.00 16.04           C  
ATOM   1175  CE1 PHE A 163     -48.099  20.439 -10.281  1.00 16.06           C  
ATOM   1176  CE2 PHE A 163     -50.466  20.403 -10.748  1.00 15.27           C  
ATOM   1177  CZ  PHE A 163     -49.155  20.600 -11.172  1.00 18.09           C  
ATOM   1178  N   MET A 164     -50.094  17.290  -4.882  1.00 23.14           N  
ATOM   1179  CA  MET A 164     -50.589  16.855  -3.585  1.00 24.20           C  
ATOM   1180  C   MET A 164     -49.400  16.575  -2.666  1.00 24.35           C  
ATOM   1181  O   MET A 164     -49.399  16.954  -1.501  1.00 25.67           O  
ATOM   1182  CB  MET A 164     -51.385  15.569  -3.768  1.00 29.78           C  
ATOM   1183  CG  MET A 164     -51.753  14.845  -2.476  1.00 31.32           C  
ATOM   1184  SD  MET A 164     -53.221  15.520  -1.722  1.00 34.71           S  
ATOM   1185  CE  MET A 164     -54.478  15.315  -2.983  1.00 23.09           C  
ATOM   1186  N   ILE A 165     -48.425  15.843  -3.195  1.00 24.85           N  
ATOM   1187  CA  ILE A 165     -47.205  15.496  -2.477  1.00 24.51           C  
ATOM   1188  C   ILE A 165     -46.464  16.786  -2.123  1.00 23.85           C  
ATOM   1189  O   ILE A 165     -46.142  17.003  -0.961  1.00 26.23           O  
ATOM   1190  CB  ILE A 165     -46.295  14.583  -3.348  1.00 24.94           C  
ATOM   1191  CG1 ILE A 165     -47.009  13.264  -3.644  1.00 27.04           C  
ATOM   1192  CG2 ILE A 165     -44.998  14.294  -2.633  1.00 29.58           C  
ATOM   1193  CD1 ILE A 165     -46.280  12.367  -4.622  1.00 29.29           C  
ATOM   1194  N   TRP A 166     -46.201  17.626  -3.128  1.00 22.00           N  
ATOM   1195  CA  TRP A 166     -45.518  18.906  -2.934  1.00 17.52           C  
ATOM   1196  C   TRP A 166     -46.255  19.744  -1.920  1.00 17.69           C  
ATOM   1197  O   TRP A 166     -45.665  20.280  -1.002  1.00 21.80           O  
ATOM   1198  CB  TRP A 166     -45.448  19.681  -4.245  1.00 16.97           C  
ATOM   1199  CG  TRP A 166     -44.583  19.022  -5.279  1.00 18.52           C  
ATOM   1200  CD1 TRP A 166     -43.845  17.876  -5.124  1.00 18.91           C  
ATOM   1201  CD2 TRP A 166     -44.348  19.470  -6.624  1.00 17.54           C  
ATOM   1202  NE1 TRP A 166     -43.167  17.590  -6.286  1.00 23.13           N  
ATOM   1203  CE2 TRP A 166     -43.453  18.551  -7.222  1.00 19.66           C  
ATOM   1204  CE3 TRP A 166     -44.809  20.554  -7.383  1.00 19.34           C  
ATOM   1205  CZ2 TRP A 166     -43.005  18.684  -8.542  1.00 17.92           C  
ATOM   1206  CZ3 TRP A 166     -44.362  20.690  -8.699  1.00 18.29           C  
ATOM   1207  CH2 TRP A 166     -43.466  19.755  -9.263  1.00 17.39           C  
ATOM   1208  N   ALA A 167     -47.556  19.871  -2.102  1.00 17.63           N  
ATOM   1209  CA  ALA A 167     -48.398  20.655  -1.206  1.00 17.33           C  
ATOM   1210  C   ALA A 167     -48.272  20.223   0.246  1.00 20.35           C  
ATOM   1211  O   ALA A 167     -47.904  21.005   1.114  1.00 22.16           O  
ATOM   1212  CB  ALA A 167     -49.854  20.541  -1.646  1.00 13.14           C  
ATOM   1213  N   SER A 168     -48.607  18.964   0.496  1.00 24.54           N  
ATOM   1214  CA  SER A 168     -48.590  18.392   1.830  1.00 25.63           C  
ATOM   1215  C   SER A 168     -47.227  18.350   2.506  1.00 26.33           C  
ATOM   1216  O   SER A 168     -47.117  18.704   3.688  1.00 29.76           O  
ATOM   1217  CB  SER A 168     -49.210  16.995   1.799  1.00 26.16           C  
ATOM   1218  OG  SER A 168     -48.504  16.148   0.901  1.00 31.06           O  
ATOM   1219  N   THR A 169     -46.203  17.881   1.803  1.00 25.44           N  
ATOM   1220  CA  THR A 169     -44.884  17.807   2.418  1.00 25.17           C  
ATOM   1221  C   THR A 169     -44.300  19.187   2.704  1.00 25.21           C  
ATOM   1222  O   THR A 169     -43.726  19.396   3.777  1.00 26.32           O  
ATOM   1223  CB  THR A 169     -43.884  16.900   1.619  1.00 26.41           C  
ATOM   1224  OG1 THR A 169     -43.542  17.501   0.368  1.00 27.35           O  
ATOM   1225  CG2 THR A 169     -44.502  15.522   1.336  1.00 24.77           C  
ATOM   1226  N   GLN A 170     -44.523  20.151   1.810  1.00 23.29           N  
ATOM   1227  CA  GLN A 170     -44.000  21.499   2.022  1.00 22.91           C  
ATOM   1228  C   GLN A 170     -44.754  22.296   3.080  1.00 25.16           C  
ATOM   1229  O   GLN A 170     -44.203  23.209   3.720  1.00 27.68           O  
ATOM   1230  CB  GLN A 170     -43.982  22.269   0.722  1.00 19.97           C  
ATOM   1231  CG  GLN A 170     -42.873  21.831  -0.167  1.00 23.69           C  
ATOM   1232  CD  GLN A 170     -43.159  22.078  -1.619  1.00 26.65           C  
ATOM   1233  OE1 GLN A 170     -43.742  23.105  -1.996  1.00 33.95           O  
ATOM   1234  NE2 GLN A 170     -42.763  21.135  -2.453  1.00 24.01           N  
ATOM   1235  N   HIS A 171     -46.007  21.924   3.295  1.00 23.73           N  
ATOM   1236  CA  HIS A 171     -46.836  22.615   4.253  1.00 23.33           C  
ATOM   1237  C   HIS A 171     -46.220  22.680   5.630  1.00 25.65           C  
ATOM   1238  O   HIS A 171     -46.385  23.669   6.343  1.00 28.61           O  
ATOM   1239  CB  HIS A 171     -48.180  21.927   4.356  1.00 23.15           C  
ATOM   1240  CG  HIS A 171     -49.121  22.607   5.290  1.00 22.93           C  
ATOM   1241  ND1 HIS A 171     -49.915  23.666   4.900  1.00 22.75           N  
ATOM   1242  CD2 HIS A 171     -49.413  22.369   6.588  1.00 21.54           C  
ATOM   1243  CE1 HIS A 171     -50.664  24.046   5.920  1.00 23.04           C  
ATOM   1244  NE2 HIS A 171     -50.377  23.275   6.958  1.00 23.33           N  
ATOM   1245  N   TYR A 172     -45.577  21.593   6.040  1.00 26.89           N  
ATOM   1246  CA  TYR A 172     -44.964  21.541   7.366  1.00 27.63           C  
ATOM   1247  C   TYR A 172     -43.836  22.538   7.577  1.00 28.39           C  
ATOM   1248  O   TYR A 172     -43.561  22.921   8.711  1.00 32.05           O  
ATOM   1249  CB  TYR A 172     -44.561  20.103   7.734  1.00 24.87           C  
ATOM   1250  CG  TYR A 172     -45.779  19.224   7.911  1.00 22.58           C  
ATOM   1251  CD1 TYR A 172     -46.232  18.414   6.867  1.00 22.58           C  
ATOM   1252  CD2 TYR A 172     -46.543  19.286   9.082  1.00 21.97           C  
ATOM   1253  CE1 TYR A 172     -47.417  17.699   6.972  1.00 24.48           C  
ATOM   1254  CE2 TYR A 172     -47.741  18.569   9.204  1.00 21.12           C  
ATOM   1255  CZ  TYR A 172     -48.174  17.783   8.140  1.00 25.30           C  
ATOM   1256  OH  TYR A 172     -49.389  17.121   8.210  1.00 29.74           O  
ATOM   1257  N   ALA A 173     -43.227  22.994   6.488  1.00 27.76           N  
ATOM   1258  CA  ALA A 173     -42.162  23.985   6.577  1.00 26.75           C  
ATOM   1259  C   ALA A 173     -42.783  25.370   6.433  1.00 28.12           C  
ATOM   1260  O   ALA A 173     -42.667  26.215   7.319  1.00 29.28           O  
ATOM   1261  CB  ALA A 173     -41.140  23.764   5.476  1.00 25.18           C  
ATOM   1262  N   ASP A 174     -43.451  25.579   5.299  1.00 28.61           N  
ATOM   1263  CA  ASP A 174     -44.091  26.839   4.963  1.00 28.19           C  
ATOM   1264  C   ASP A 174     -45.189  27.298   5.929  1.00 30.14           C  
ATOM   1265  O   ASP A 174     -45.398  28.503   6.114  1.00 33.78           O  
ATOM   1266  CB  ASP A 174     -44.648  26.764   3.544  1.00 29.92           C  
ATOM   1267  CG  ASP A 174     -43.563  26.550   2.489  1.00 29.45           C  
ATOM   1268  OD1 ASP A 174     -42.364  26.644   2.827  1.00 30.42           O  
ATOM   1269  OD2 ASP A 174     -43.911  26.297   1.306  1.00 31.78           O  
ATOM   1270  N   PHE A 175     -45.931  26.364   6.512  1.00 27.48           N  
ATOM   1271  CA  PHE A 175     -46.987  26.761   7.443  1.00 25.70           C  
ATOM   1272  C   PHE A 175     -46.645  26.424   8.895  1.00 27.43           C  
ATOM   1273  O   PHE A 175     -47.476  26.555   9.809  1.00 25.00           O  
ATOM   1274  CB  PHE A 175     -48.329  26.173   7.018  1.00 25.88           C  
ATOM   1275  CG  PHE A 175     -49.012  26.963   5.930  1.00 26.33           C  
ATOM   1276  CD1 PHE A 175     -48.395  27.167   4.711  1.00 21.10           C  
ATOM   1277  CD2 PHE A 175     -50.251  27.557   6.157  1.00 27.24           C  
ATOM   1278  CE1 PHE A 175     -48.989  27.948   3.744  1.00 21.69           C  
ATOM   1279  CE2 PHE A 175     -50.852  28.348   5.180  1.00 26.71           C  
ATOM   1280  CZ  PHE A 175     -50.218  28.541   3.979  1.00 22.74           C  
ATOM   1281  N   ALA A 176     -45.370  26.108   9.095  1.00 27.63           N  
ATOM   1282  CA  ALA A 176     -44.808  25.763  10.386  1.00 27.57           C  
ATOM   1283  C   ALA A 176     -45.394  26.513  11.586  1.00 29.72           C  
ATOM   1284  O   ALA A 176     -45.845  25.892  12.542  1.00 33.16           O  
ATOM   1285  CB  ALA A 176     -43.302  25.937  10.340  1.00 26.43           C  
ATOM   1286  N   PRO A 177     -45.442  27.851  11.543  1.00 29.24           N  
ATOM   1287  CA  PRO A 177     -46.001  28.541  12.703  1.00 31.05           C  
ATOM   1288  C   PRO A 177     -47.362  28.035  13.151  1.00 34.28           C  
ATOM   1289  O   PRO A 177     -47.629  27.967  14.350  1.00 37.84           O  
ATOM   1290  CB  PRO A 177     -46.086  29.990  12.230  1.00 28.25           C  
ATOM   1291  CG  PRO A 177     -44.955  30.108  11.299  1.00 29.49           C  
ATOM   1292  CD  PRO A 177     -45.043  28.823  10.512  1.00 30.14           C  
ATOM   1293  N   GLN A 178     -48.219  27.702  12.194  1.00 34.09           N  
ATOM   1294  CA  GLN A 178     -49.575  27.237  12.492  1.00 34.51           C  
ATOM   1295  C   GLN A 178     -49.626  25.761  12.859  1.00 35.27           C  
ATOM   1296  O   GLN A 178     -50.572  25.298  13.525  1.00 33.69           O  
ATOM   1297  CB  GLN A 178     -50.473  27.508  11.291  1.00 36.47           C  
ATOM   1298  CG  GLN A 178     -51.900  27.040  11.377  1.00 33.13           C  
ATOM   1299  CD  GLN A 178     -52.580  27.280  10.054  1.00 34.56           C  
ATOM   1300  OE1 GLN A 178     -53.511  28.081   9.967  1.00 32.72           O  
ATOM   1301  NE2 GLN A 178     -52.048  26.661   8.991  1.00 32.05           N  
ATOM   1302  N   VAL A 179     -48.668  25.011  12.327  1.00 34.62           N  
ATOM   1303  CA  VAL A 179     -48.600  23.602  12.632  1.00 36.24           C  
ATOM   1304  C   VAL A 179     -48.294  23.536  14.120  1.00 40.03           C  
ATOM   1305  O   VAL A 179     -49.037  22.923  14.878  1.00 42.25           O  
ATOM   1306  CB  VAL A 179     -47.521  22.894  11.803  1.00 34.37           C  
ATOM   1307  CG1 VAL A 179     -47.205  21.546  12.405  1.00 34.51           C  
ATOM   1308  CG2 VAL A 179     -47.999  22.717  10.366  1.00 32.05           C  
ATOM   1309  N   GLU A 180     -47.238  24.225  14.548  1.00 42.95           N  
ATOM   1310  CA  GLU A 180     -46.879  24.247  15.961  1.00 42.72           C  
ATOM   1311  C   GLU A 180     -47.972  24.907  16.780  1.00 41.77           C  
ATOM   1312  O   GLU A 180     -48.183  24.546  17.914  1.00 42.81           O  
ATOM   1313  CB  GLU A 180     -45.563  24.995  16.181  1.00 45.87           C  
ATOM   1314  CG  GLU A 180     -45.085  25.010  17.633  1.00 51.70           C  
ATOM   1315  CD  GLU A 180     -43.933  25.980  17.867  1.00 58.56           C  
ATOM   1316  OE1 GLU A 180     -44.177  27.058  18.457  1.00 63.09           O  
ATOM   1317  OE2 GLU A 180     -42.787  25.669  17.464  1.00 59.75           O  
ATOM   1318  N   ALA A 181     -48.659  25.894  16.217  1.00 43.17           N  
ATOM   1319  CA  ALA A 181     -49.718  26.581  16.953  1.00 43.30           C  
ATOM   1320  C   ALA A 181     -50.858  25.672  17.406  1.00 42.82           C  
ATOM   1321  O   ALA A 181     -51.356  25.822  18.517  1.00 43.81           O  
ATOM   1322  CB  ALA A 181     -50.267  27.761  16.151  1.00 43.87           C  
ATOM   1323  N   VAL A 182     -51.284  24.745  16.555  1.00 42.06           N  
ATOM   1324  CA  VAL A 182     -52.379  23.851  16.922  1.00 44.28           C  
ATOM   1325  C   VAL A 182     -51.858  22.529  17.493  1.00 43.77           C  
ATOM   1326  O   VAL A 182     -52.545  21.848  18.258  1.00 42.72           O  
ATOM   1327  CB  VAL A 182     -53.339  23.566  15.700  1.00 47.20           C  
ATOM   1328  CG1 VAL A 182     -53.390  24.765  14.741  1.00 46.84           C  
ATOM   1329  CG2 VAL A 182     -52.928  22.296  14.950  1.00 49.32           C  
ATOM   1330  N   THR A 183     -50.615  22.218  17.153  1.00 44.93           N  
ATOM   1331  CA  THR A 183     -49.962  20.983  17.556  1.00 45.97           C  
ATOM   1332  C   THR A 183     -48.933  21.141  18.692  1.00 47.61           C  
ATOM   1333  O   THR A 183     -48.677  20.194  19.449  1.00 49.98           O  
ATOM   1334  CB  THR A 183     -49.286  20.333  16.315  1.00 43.80           C  
ATOM   1335  OG1 THR A 183     -50.291  19.846  15.409  1.00 46.36           O  
ATOM   1336  CG2 THR A 183     -48.381  19.211  16.718  1.00 45.88           C  
ATOM   1337  N   GLY A 184     -48.363  22.334  18.826  1.00 47.18           N  
ATOM   1338  CA  GLY A 184     -47.364  22.576  19.856  1.00 45.66           C  
ATOM   1339  C   GLY A 184     -46.084  21.813  19.557  1.00 45.58           C  
ATOM   1340  O   GLY A 184     -45.342  21.469  20.483  1.00 48.38           O  
ATOM   1341  N   ALA A 185     -45.832  21.535  18.273  1.00 42.13           N  
ATOM   1342  CA  ALA A 185     -44.648  20.791  17.830  1.00 37.57           C  
ATOM   1343  C   ALA A 185     -44.114  21.249  16.471  1.00 36.55           C  
ATOM   1344  O   ALA A 185     -44.799  21.959  15.722  1.00 35.61           O  
ATOM   1345  CB  ALA A 185     -44.971  19.302  17.767  1.00 37.55           C  
ATOM   1346  N   THR A 186     -42.894  20.813  16.153  1.00 35.21           N  
ATOM   1347  CA  THR A 186     -42.238  21.131  14.875  1.00 33.71           C  
ATOM   1348  C   THR A 186     -41.714  19.842  14.276  1.00 32.03           C  
ATOM   1349  O   THR A 186     -41.772  18.798  14.919  1.00 31.02           O  
ATOM   1350  CB  THR A 186     -41.050  22.111  15.042  1.00 32.68           C  
ATOM   1351  OG1 THR A 186     -40.086  21.568  15.957  1.00 33.42           O  
ATOM   1352  CG2 THR A 186     -41.538  23.443  15.575  1.00 33.38           C  
ATOM   1353  N   LEU A 187     -41.267  19.888  13.029  1.00 33.96           N  
ATOM   1354  CA  LEU A 187     -40.729  18.697  12.398  1.00 38.34           C  
ATOM   1355  C   LEU A 187     -39.417  18.343  13.095  1.00 43.06           C  
ATOM   1356  O   LEU A 187     -38.804  17.314  12.783  1.00 43.11           O  
ATOM   1357  CB  LEU A 187     -40.474  18.933  10.905  1.00 37.79           C  
ATOM   1358  CG  LEU A 187     -41.609  18.833   9.876  1.00 35.35           C  
ATOM   1359  CD1 LEU A 187     -41.049  19.207   8.502  1.00 29.23           C  
ATOM   1360  CD2 LEU A 187     -42.216  17.425   9.860  1.00 30.78           C  
ATOM   1361  N   ARG A 188     -38.980  19.226  13.998  1.00 47.07           N  
ATOM   1362  CA  ARG A 188     -37.752  19.052  14.772  1.00 53.27           C  
ATOM   1363  C   ARG A 188     -37.969  18.145  15.984  1.00 56.08           C  
ATOM   1364  O   ARG A 188     -37.013  17.694  16.620  1.00 58.42           O  
ATOM   1365  CB  ARG A 188     -37.214  20.406  15.239  1.00 56.22           C  
ATOM   1366  CG  ARG A 188     -36.419  21.184  14.186  1.00 60.17           C  
ATOM   1367  CD  ARG A 188     -37.013  22.572  13.949  1.00 64.99           C  
ATOM   1368  NE  ARG A 188     -37.430  23.199  15.201  1.00 67.99           N  
ATOM   1369  CZ  ARG A 188     -38.230  24.256  15.280  1.00 69.54           C  
ATOM   1370  NH1 ARG A 188     -38.557  24.749  16.468  1.00 71.78           N  
ATOM   1371  NH2 ARG A 188     -38.701  24.822  14.177  1.00 69.55           N  
ATOM   1372  N   ASP A 189     -39.227  17.979  16.374  1.00 56.41           N  
ATOM   1373  CA  ASP A 189     -39.561  17.111  17.489  1.00 55.30           C  
ATOM   1374  C   ASP A 189     -39.668  15.733  16.857  1.00 54.54           C  
ATOM   1375  O   ASP A 189     -40.691  15.396  16.276  1.00 54.15           O  
ATOM   1376  CB  ASP A 189     -40.890  17.542  18.118  1.00 58.03           C  
ATOM   1377  CG  ASP A 189     -40.871  18.996  18.613  1.00 61.24           C  
ATOM   1378  OD1 ASP A 189     -39.944  19.753  18.252  1.00 64.23           O  
ATOM   1379  OD2 ASP A 189     -41.788  19.385  19.372  1.00 61.99           O  
ATOM   1380  N   GLU A 190     -38.586  14.967  16.950  1.00 56.42           N  
ATOM   1381  CA  GLU A 190     -38.458  13.615  16.381  1.00 58.34           C  
ATOM   1382  C   GLU A 190     -39.722  12.744  16.410  1.00 56.72           C  
ATOM   1383  O   GLU A 190     -39.942  11.914  15.519  1.00 54.56           O  
ATOM   1384  CB  GLU A 190     -37.309  12.856  17.072  1.00 64.23           C  
ATOM   1385  CG  GLU A 190     -35.968  13.624  17.196  1.00 70.78           C  
ATOM   1386  CD  GLU A 190     -35.964  14.688  18.302  1.00 73.49           C  
ATOM   1387  OE1 GLU A 190     -35.452  15.805  18.056  1.00 74.96           O  
ATOM   1388  OE2 GLU A 190     -36.464  14.409  19.418  1.00 73.25           O  
ATOM   1389  N   VAL A 191     -40.503  12.875  17.479  1.00 55.37           N  
ATOM   1390  CA  VAL A 191     -41.741  12.109  17.625  1.00 52.72           C  
ATOM   1391  C   VAL A 191     -42.795  12.590  16.621  1.00 51.34           C  
ATOM   1392  O   VAL A 191     -43.442  11.771  15.954  1.00 50.06           O  
ATOM   1393  CB  VAL A 191     -42.319  12.243  19.053  1.00 52.33           C  
ATOM   1394  CG1 VAL A 191     -43.501  11.311  19.224  1.00 51.05           C  
ATOM   1395  CG2 VAL A 191     -41.251  11.952  20.088  1.00 51.70           C  
ATOM   1396  N   PHE A 192     -42.973  13.914  16.553  1.00 48.57           N  
ATOM   1397  CA  PHE A 192     -43.934  14.544  15.647  1.00 43.85           C  
ATOM   1398  C   PHE A 192     -43.587  14.338  14.171  1.00 41.78           C  
ATOM   1399  O   PHE A 192     -44.482  14.139  13.350  1.00 39.23           O  
ATOM   1400  CB  PHE A 192     -44.078  16.040  15.940  1.00 42.29           C  
ATOM   1401  CG  PHE A 192     -45.051  16.731  15.032  1.00 40.68           C  
ATOM   1402  CD1 PHE A 192     -46.405  16.733  15.323  1.00 40.23           C  
ATOM   1403  CD2 PHE A 192     -44.624  17.316  13.848  1.00 40.89           C  
ATOM   1404  CE1 PHE A 192     -47.322  17.298  14.447  1.00 38.60           C  
ATOM   1405  CE2 PHE A 192     -45.536  17.885  12.968  1.00 38.11           C  
ATOM   1406  CZ  PHE A 192     -46.890  17.872  13.274  1.00 37.12           C  
ATOM   1407  N   PHE A 193     -42.302  14.437  13.836  1.00 40.72           N  
ATOM   1408  CA  PHE A 193     -41.850  14.239  12.461  1.00 40.08           C  
ATOM   1409  C   PHE A 193     -42.310  12.881  11.954  1.00 41.17           C  
ATOM   1410  O   PHE A 193     -42.689  12.732  10.793  1.00 41.41           O  
ATOM   1411  CB  PHE A 193     -40.329  14.300  12.373  1.00 37.59           C  
ATOM   1412  CG  PHE A 193     -39.795  14.013  10.995  1.00 35.95           C  
ATOM   1413  CD1 PHE A 193     -39.659  15.041  10.058  1.00 33.67           C  
ATOM   1414  CD2 PHE A 193     -39.448  12.717  10.623  1.00 31.80           C  
ATOM   1415  CE1 PHE A 193     -39.187  14.774   8.772  1.00 30.26           C  
ATOM   1416  CE2 PHE A 193     -38.975  12.447   9.340  1.00 29.72           C  
ATOM   1417  CZ  PHE A 193     -38.846  13.473   8.413  1.00 28.60           C  
ATOM   1418  N   ASN A 194     -42.232  11.886  12.831  1.00 44.43           N  
ATOM   1419  CA  ASN A 194     -42.641  10.525  12.501  1.00 44.42           C  
ATOM   1420  C   ASN A 194     -44.154  10.426  12.332  1.00 42.20           C  
ATOM   1421  O   ASN A 194     -44.645   9.778  11.401  1.00 40.75           O  
ATOM   1422  CB  ASN A 194     -42.157   9.564  13.583  1.00 48.86           C  
ATOM   1423  CG  ASN A 194     -41.161   8.547  13.051  1.00 51.55           C  
ATOM   1424  OD1 ASN A 194     -41.208   7.363  13.422  1.00 54.92           O  
ATOM   1425  ND2 ASN A 194     -40.246   8.998  12.191  1.00 48.05           N  
ATOM   1426  N   GLN A 195     -44.889  11.045  13.248  1.00 40.25           N  
ATOM   1427  CA  GLN A 195     -46.345  11.054  13.175  1.00 40.72           C  
ATOM   1428  C   GLN A 195     -46.739  11.596  11.804  1.00 39.45           C  
ATOM   1429  O   GLN A 195     -47.537  10.997  11.079  1.00 38.69           O  
ATOM   1430  CB  GLN A 195     -46.914  11.990  14.235  1.00 44.28           C  
ATOM   1431  CG  GLN A 195     -46.285  11.841  15.604  1.00 50.39           C  
ATOM   1432  CD  GLN A 195     -46.762  12.904  16.585  1.00 55.89           C  
ATOM   1433  OE1 GLN A 195     -47.481  13.840  16.208  1.00 61.23           O  
ATOM   1434  NE2 GLN A 195     -46.380  12.758  17.856  1.00 55.41           N  
ATOM   1435  N   THR A 196     -46.151  12.746  11.476  1.00 37.82           N  
ATOM   1436  CA  THR A 196     -46.373  13.458  10.223  1.00 35.48           C  
ATOM   1437  C   THR A 196     -46.133  12.594   8.993  1.00 36.64           C  
ATOM   1438  O   THR A 196     -46.962  12.579   8.075  1.00 37.16           O  
ATOM   1439  CB  THR A 196     -45.476  14.724  10.156  1.00 32.88           C  
ATOM   1440  OG1 THR A 196     -46.043  15.761  10.973  1.00 31.40           O  
ATOM   1441  CG2 THR A 196     -45.312  15.217   8.725  1.00 29.90           C  
ATOM   1442  N   VAL A 197     -44.997  11.901   8.958  1.00 36.51           N  
ATOM   1443  CA  VAL A 197     -44.688  11.066   7.805  1.00 36.46           C  
ATOM   1444  C   VAL A 197     -45.691   9.929   7.640  1.00 37.96           C  
ATOM   1445  O   VAL A 197     -46.140   9.662   6.523  1.00 38.50           O  
ATOM   1446  CB  VAL A 197     -43.253  10.513   7.848  1.00 35.66           C  
ATOM   1447  CG1 VAL A 197     -42.863   9.988   6.463  1.00 34.17           C  
ATOM   1448  CG2 VAL A 197     -42.281  11.593   8.290  1.00 33.67           C  
ATOM   1449  N   GLU A 198     -46.041   9.278   8.751  1.00 39.17           N  
ATOM   1450  CA  GLU A 198     -47.018   8.184   8.760  1.00 38.19           C  
ATOM   1451  C   GLU A 198     -48.311   8.607   8.080  1.00 37.05           C  
ATOM   1452  O   GLU A 198     -48.747   8.001   7.099  1.00 36.28           O  
ATOM   1453  CB  GLU A 198     -47.359   7.788  10.201  1.00 43.46           C  
ATOM   1454  CG  GLU A 198     -46.621   6.579  10.707  1.00 50.51           C  
ATOM   1455  CD  GLU A 198     -47.043   5.314   9.980  1.00 56.23           C  
ATOM   1456  OE1 GLU A 198     -48.005   4.655  10.442  1.00 57.83           O  
ATOM   1457  OE2 GLU A 198     -46.418   4.980   8.946  1.00 60.33           O  
ATOM   1458  N   ASN A 199     -48.933   9.643   8.643  1.00 36.36           N  
ATOM   1459  CA  ASN A 199     -50.193  10.185   8.140  1.00 33.33           C  
ATOM   1460  C   ASN A 199     -50.165  10.716   6.721  1.00 31.73           C  
ATOM   1461  O   ASN A 199     -51.116  10.507   5.974  1.00 32.75           O  
ATOM   1462  CB  ASN A 199     -50.709  11.275   9.069  1.00 34.33           C  
ATOM   1463  CG  ASN A 199     -51.141  10.730  10.407  1.00 35.69           C  
ATOM   1464  OD1 ASN A 199     -52.337  10.541  10.653  1.00 37.32           O  
ATOM   1465  ND2 ASN A 199     -50.170  10.464  11.284  1.00 34.87           N  
ATOM   1466  N   VAL A 200     -49.127  11.460   6.360  1.00 29.88           N  
ATOM   1467  CA  VAL A 200     -49.072  11.988   5.010  1.00 30.07           C  
ATOM   1468  C   VAL A 200     -48.988  10.821   4.033  1.00 32.17           C  
ATOM   1469  O   VAL A 200     -49.711  10.797   3.024  1.00 34.19           O  
ATOM   1470  CB  VAL A 200     -47.894  12.983   4.801  1.00 28.83           C  
ATOM   1471  CG1 VAL A 200     -47.824  13.424   3.352  1.00 24.90           C  
ATOM   1472  CG2 VAL A 200     -48.079  14.208   5.662  1.00 26.08           C  
ATOM   1473  N   GLN A 201     -48.104   9.865   4.329  1.00 33.91           N  
ATOM   1474  CA  GLN A 201     -47.925   8.677   3.481  1.00 35.33           C  
ATOM   1475  C   GLN A 201     -49.200   7.850   3.427  1.00 35.42           C  
ATOM   1476  O   GLN A 201     -49.618   7.394   2.356  1.00 32.60           O  
ATOM   1477  CB  GLN A 201     -46.818   7.781   4.013  1.00 36.81           C  
ATOM   1478  CG  GLN A 201     -45.435   8.282   3.787  1.00 38.68           C  
ATOM   1479  CD  GLN A 201     -44.402   7.300   4.293  1.00 41.70           C  
ATOM   1480  OE1 GLN A 201     -43.424   6.999   3.598  1.00 43.06           O  
ATOM   1481  NE2 GLN A 201     -44.617   6.780   5.507  1.00 38.36           N  
ATOM   1482  N   ARG A 202     -49.809   7.656   4.593  1.00 36.60           N  
ATOM   1483  CA  ARG A 202     -51.028   6.883   4.661  1.00 39.04           C  
ATOM   1484  C   ARG A 202     -52.050   7.461   3.691  1.00 38.38           C  
ATOM   1485  O   ARG A 202     -52.389   6.811   2.703  1.00 41.25           O  
ATOM   1486  CB  ARG A 202     -51.597   6.857   6.076  1.00 42.44           C  
ATOM   1487  CG  ARG A 202     -52.464   5.638   6.305  1.00 49.54           C  
ATOM   1488  CD  ARG A 202     -53.459   5.855   7.427  1.00 56.29           C  
ATOM   1489  NE  ARG A 202     -54.421   4.757   7.544  1.00 62.81           N  
ATOM   1490  CZ  ARG A 202     -55.165   4.279   6.544  1.00 66.78           C  
ATOM   1491  NH1 ARG A 202     -56.011   3.279   6.777  1.00 69.05           N  
ATOM   1492  NH2 ARG A 202     -55.063   4.785   5.312  1.00 65.53           N  
ATOM   1493  N   ILE A 203     -52.493   8.695   3.926  1.00 35.24           N  
ATOM   1494  CA  ILE A 203     -53.478   9.313   3.040  1.00 33.87           C  
ATOM   1495  C   ILE A 203     -53.121   9.301   1.547  1.00 35.68           C  
ATOM   1496  O   ILE A 203     -53.964   8.991   0.710  1.00 38.77           O  
ATOM   1497  CB  ILE A 203     -53.818  10.762   3.454  1.00 31.24           C  
ATOM   1498  CG1 ILE A 203     -54.215  10.810   4.927  1.00 33.58           C  
ATOM   1499  CG2 ILE A 203     -55.000  11.279   2.646  1.00 29.36           C  
ATOM   1500  CD1 ILE A 203     -54.686  12.163   5.388  1.00 33.26           C  
ATOM   1501  N   ILE A 204     -51.893   9.643   1.187  1.00 36.25           N  
ATOM   1502  CA  ILE A 204     -51.568   9.659  -0.233  1.00 36.66           C  
ATOM   1503  C   ILE A 204     -51.447   8.264  -0.848  1.00 39.01           C  
ATOM   1504  O   ILE A 204     -51.950   8.033  -1.954  1.00 39.16           O  
ATOM   1505  CB  ILE A 204     -50.310  10.517  -0.535  1.00 35.76           C  
ATOM   1506  CG1 ILE A 204     -50.529  11.951  -0.047  1.00 32.83           C  
ATOM   1507  CG2 ILE A 204     -50.044  10.548  -2.033  1.00 34.18           C  
ATOM   1508  CD1 ILE A 204     -49.396  12.903  -0.368  1.00 27.78           C  
ATOM   1509  N   ILE A 205     -50.757   7.355  -0.157  1.00 42.19           N  
ATOM   1510  CA  ILE A 205     -50.566   5.982  -0.646  1.00 44.29           C  
ATOM   1511  C   ILE A 205     -51.863   5.187  -0.615  1.00 44.55           C  
ATOM   1512  O   ILE A 205     -52.196   4.488  -1.581  1.00 43.79           O  
ATOM   1513  CB  ILE A 205     -49.474   5.226   0.162  1.00 44.58           C  
ATOM   1514  CG1 ILE A 205     -48.097   5.783  -0.195  1.00 45.00           C  
ATOM   1515  CG2 ILE A 205     -49.513   3.736  -0.129  1.00 42.85           C  
ATOM   1516  CD1 ILE A 205     -47.813   5.820  -1.700  1.00 42.94           C  
ATOM   1517  N   GLU A 206     -52.566   5.269   0.509  1.00 44.23           N  
ATOM   1518  CA  GLU A 206     -53.829   4.574   0.660  1.00 44.96           C  
ATOM   1519  C   GLU A 206     -54.927   5.249  -0.144  1.00 44.78           C  
ATOM   1520  O   GLU A 206     -56.082   4.835  -0.104  1.00 46.53           O  
ATOM   1521  CB  GLU A 206     -54.211   4.473   2.139  1.00 44.87           C  
ATOM   1522  CG  GLU A 206     -54.420   3.044   2.612  1.00 48.33           C  
ATOM   1523  CD  GLU A 206     -53.745   2.009   1.699  1.00 50.21           C  
ATOM   1524  OE1 GLU A 206     -52.674   1.471   2.064  1.00 50.91           O  
ATOM   1525  OE2 GLU A 206     -54.292   1.732   0.611  1.00 49.07           O  
ATOM   1526  N   GLY A 207     -54.554   6.297  -0.871  1.00 44.60           N  
ATOM   1527  CA  GLY A 207     -55.505   7.020  -1.692  1.00 41.80           C  
ATOM   1528  C   GLY A 207     -55.271   6.779  -3.172  1.00 42.33           C  
ATOM   1529  O   GLY A 207     -56.124   7.138  -3.988  1.00 41.65           O  
ATOM   1530  N   ILE A 208     -54.123   6.195  -3.528  1.00 43.77           N  
ATOM   1531  CA  ILE A 208     -53.787   5.916  -4.931  1.00 44.63           C  
ATOM   1532  C   ILE A 208     -53.428   4.452  -5.258  1.00 48.22           C  
ATOM   1533  O   ILE A 208     -53.026   4.136  -6.395  1.00 48.30           O  
ATOM   1534  CB  ILE A 208     -52.616   6.780  -5.407  1.00 41.37           C  
ATOM   1535  CG1 ILE A 208     -51.408   6.565  -4.495  1.00 42.05           C  
ATOM   1536  CG2 ILE A 208     -53.030   8.220  -5.476  1.00 38.94           C  
ATOM   1537  CD1 ILE A 208     -50.082   6.822  -5.180  1.00 40.85           C  
ATOM   1538  N   ARG A 209     -53.524   3.562  -4.277  1.00 52.12           N  
ATOM   1539  CA  ARG A 209     -53.189   2.169  -4.548  1.00 56.29           C  
ATOM   1540  C   ARG A 209     -54.343   1.512  -5.299  1.00 58.26           C  
ATOM   1541  O   ARG A 209     -55.508   1.764  -4.996  1.00 57.58           O  
ATOM   1542  CB  ARG A 209     -52.798   1.414  -3.266  1.00 56.25           C  
ATOM   1543  CG  ARG A 209     -53.889   0.655  -2.560  1.00 55.83           C  
ATOM   1544  CD  ARG A 209     -53.268  -0.482  -1.769  1.00 53.94           C  
ATOM   1545  NE  ARG A 209     -52.522  -0.024  -0.601  1.00 53.44           N  
ATOM   1546  CZ  ARG A 209     -51.329  -0.479  -0.231  1.00 54.33           C  
ATOM   1547  NH1 ARG A 209     -50.755  -0.003   0.864  1.00 54.63           N  
ATOM   1548  NH2 ARG A 209     -50.689  -1.372  -0.973  1.00 56.18           N  
ATOM   1549  N   PRO A 210     -54.027   0.717  -6.337  1.00 60.59           N  
ATOM   1550  CA  PRO A 210     -55.050   0.038  -7.137  1.00 61.67           C  
ATOM   1551  C   PRO A 210     -55.932  -0.809  -6.247  1.00 63.75           C  
ATOM   1552  O   PRO A 210     -55.432  -1.542  -5.388  1.00 65.08           O  
ATOM   1553  CB  PRO A 210     -54.223  -0.802  -8.115  1.00 61.11           C  
ATOM   1554  CG  PRO A 210     -52.979  -1.104  -7.335  1.00 63.46           C  
ATOM   1555  CD  PRO A 210     -52.680   0.231  -6.694  1.00 62.80           C  
ATOM   1556  N   ARG A 211     -57.239  -0.692  -6.438  1.00 65.78           N  
ATOM   1557  CA  ARG A 211     -58.189  -1.439  -5.624  1.00 69.68           C  
ATOM   1558  C   ARG A 211     -59.619  -1.463  -6.180  1.00 70.77           C  
ATOM   1559  O   ARG A 211     -60.213  -0.378  -6.353  1.00 73.07           O  
ATOM   1560  CB  ARG A 211     -58.170  -0.898  -4.189  1.00 70.28           C  
ATOM   1561  CG  ARG A 211     -58.288   0.611  -4.092  1.00 72.81           C  
ATOM   1562  CD  ARG A 211     -59.678   1.029  -3.687  1.00 74.46           C  
ATOM   1563  NE  ARG A 211     -59.728   1.422  -2.283  1.00 79.22           N  
ATOM   1564  CZ  ARG A 211     -59.464   0.616  -1.260  1.00 81.81           C  
ATOM   1565  NH1 ARG A 211     -59.540   1.083  -0.022  1.00 80.96           N  
ATOM   1566  NH2 ARG A 211     -59.136  -0.655  -1.468  1.00 83.49           N  
ATOM   1567  OXT ARG A 211     -60.134  -2.585  -6.419  1.00 72.47           O  
TER    1568      ARG A 211                                                      
END
MOLECULE T0454.pdb
ATOM      1  N   ASP     5     -12.420  32.658   0.024  1.00 27.13           N
ATOM      2  CA  ASP     5     -13.312  32.598   1.217  1.00 27.34           C
ATOM      3  CB  ASP     5     -12.512  32.690   2.520  1.00 28.50           C
ATOM      4  CG  ASP     5     -13.404  32.599   3.759  1.00 30.42           C
ATOM      5  OD1 ASP     5     -14.289  31.706   3.803  1.00 33.47           O
ATOM      6  OD2 ASP     5     -13.226  33.430   4.680  1.00 32.05           O
ATOM      7  C   ASP     5     -14.424  33.644   1.238  1.00 26.73           C
ATOM      8  O   ASP     5     -15.477  33.398   1.835  1.00 26.63           O
ATOM      9  N   CYS     6     -14.211  34.799   0.611  0.50 26.41           N
ATOM     11  CA  CYS     6     -15.286  35.794   0.531  0.50 26.28           C
ATOM     13  CB  CYS     6     -14.751  37.198   0.241  0.50 26.57           C
ATOM     15  SG  CYS     6     -14.050  37.968   1.731  0.50 29.41           S
ATOM     17  C   CYS     6     -16.388  35.363  -0.439  0.50 25.38           C
ATOM     19  O   CYS     6     -17.496  35.901  -0.414  0.50 25.34           O
ATOM     21  N   ARG     7     -16.080  34.368  -1.271  1.00 24.45           N
ATOM     22  CA  ARG     7     -17.093  33.680  -2.080  1.00 22.28           C
ATOM     23  CB  ARG     7     -16.421  32.728  -3.079  1.00 22.90           C
ATOM     30  C   ARG     7     -18.066  32.903  -1.186  1.00 20.46           C
ATOM     31  O   ARG     7     -19.262  32.867  -1.449  1.00 20.43           O
ATOM     32  N   SER     8     -17.547  32.253  -0.148  0.50 19.10           N
ATOM     34  CA  SER     8     -18.391  31.436   0.731  0.50 17.33           C
ATOM     36  CB  SER     8     -17.550  30.493   1.586  0.50 17.45           C
ATOM     38  OG  SER     8     -18.312  29.968   2.658  0.50 15.65           O
ATOM     40  C   SER     8     -19.258  32.322   1.613  0.50 16.60           C
ATOM     42  O   SER     8     -20.455  32.084   1.776  0.50 15.91           O
ATOM     44  N   ARG     9     -18.645  33.365   2.159  0.50 15.61           N
ATOM     46  CA  ARG     9     -19.363  34.297   3.022  0.50 14.83           C
ATOM     48  CB  ARG     9     -18.372  35.205   3.766  0.50 15.25           C
ATOM     50  CG  ARG     9     -17.394  34.394   4.628  0.50 14.59           C
ATOM     52  CD  ARG     9     -16.768  35.163   5.795  0.50 16.76           C
ATOM     54  NE  ARG     9     -15.709  36.081   5.358  0.50 18.23           N
ATOM     56  CZ  ARG     9     -15.907  37.364   5.046  0.50 17.11           C
ATOM     58  NH1 ARG     9     -14.883  38.115   4.657  0.50 16.37           N
ATOM     60  NH2 ARG     9     -17.129  37.896   5.121  0.50 17.10           N
ATOM     62  C   ARG     9     -20.452  35.089   2.282  0.50 14.49           C
ATOM     64  O   ARG     9     -21.506  35.370   2.850  0.50 13.18           O
ATOM     66  N   LEU    10     -20.187  35.432   1.021  1.00 14.14           N
ATOM     67  CA  LEU    10     -21.183  36.018   0.143  1.00 15.70           C
ATOM     68  CB  LEU    10     -20.580  36.459  -1.201  1.00 16.55           C
ATOM     69  CG  LEU    10     -20.226  37.923  -1.321  1.00 18.07           C
ATOM     70  CD1 LEU    10     -19.435  38.165  -2.626  1.00 18.10           C
ATOM     71  CD2 LEU    10     -21.495  38.769  -1.285  1.00 16.77           C
ATOM     72  C   LEU    10     -22.364  35.072  -0.083  1.00 15.96           C
ATOM     73  O   LEU    10     -23.511  35.520  -0.035  1.00 16.63           O
ATOM     74  N   MET    11     -22.097  33.792  -0.326  0.70 16.06           N
ATOM     76  CA  MET    11     -23.179  32.843  -0.534  0.70 17.38           C
ATOM     78  CB  MET    11     -22.637  31.461  -0.863  0.70 20.17           C
ATOM     80  CG  MET    11     -22.166  31.316  -2.273  0.70 25.34           C
ATOM     82  SD  MET    11     -23.611  30.818  -3.503  0.70 46.93          SE
ATOM     84  CE  MET    11     -22.374  30.088  -4.856  0.70 32.85           C
ATOM     86  C   MET    11     -24.065  32.759   0.707  0.70 15.90           C
ATOM     88  O   MET    11     -25.298  32.724   0.592  0.70 14.79           O
ATOM     90  N   GLU    12     -23.436  32.726   1.888  1.00 13.16           N
ATOM     91  CA  GLU    12     -24.186  32.691   3.141  1.00 12.28           C
ATOM     92  CB  GLU    12     -23.255  32.550   4.367  1.00 11.62           C
ATOM     93  CG  GLU    12     -24.006  32.676   5.679  1.00 12.98           C
ATOM     94  CD  GLU    12     -24.899  31.451   5.972  1.00 17.78           C
ATOM     95  OE1 GLU    12     -24.548  30.339   5.520  1.00 20.61           O
ATOM     96  OE2 GLU    12     -25.952  31.593   6.636  1.00 18.33           O
ATOM     97  C   GLU    12     -25.062  33.946   3.278  1.00 11.77           C
ATOM     98  O   GLU    12     -26.263  33.868   3.569  1.00 10.95           O
ATOM     99  N   VAL    13     -24.441  35.104   3.102  1.00 11.38           N
ATOM    100  CA  VAL    13     -25.143  36.347   3.297  1.00 11.79           C
ATOM    101  CB  VAL    13     -24.168  37.555   3.216  1.00 11.85           C
ATOM    102  CG1 VAL    13     -24.903  38.816   2.771  1.00 13.25           C
ATOM    103  CG2 VAL    13     -23.437  37.739   4.528  1.00 12.09           C
ATOM    104  C   VAL    13     -26.264  36.469   2.270  1.00 12.08           C
ATOM    105  O   VAL    13     -27.360  36.860   2.613  1.00 12.20           O
ATOM    106  N   ALA    14     -25.987  36.132   1.016  1.00 11.94           N
ATOM    107  CA  ALA    14     -27.028  36.192  -0.026  1.00 12.57           C
ATOM    108  CB  ALA    14     -26.434  35.847  -1.397  1.00 12.81           C
ATOM    109  C   ALA    14     -28.224  35.272   0.324  1.00 12.70           C
ATOM    110  O   ALA    14     -29.404  35.681   0.225  1.00 12.49           O
ATOM    111  N   THR    15     -27.933  34.045   0.752  1.00 12.08           N
ATOM    112  CA  THR    15     -29.000  33.092   1.088  1.00 13.57           C
ATOM    113  CB  THR    15     -28.420  31.727   1.526  1.00 13.02           C
ATOM    114  OG1 THR    15     -27.592  31.204   0.477  1.00 13.54           O
ATOM    115  CG2 THR    15     -29.544  30.705   1.864  1.00 14.11           C
ATOM    116  C   THR    15     -29.885  33.685   2.197  1.00 13.81           C
ATOM    117  O   THR    15     -31.100  33.676   2.080  1.00 14.69           O
ATOM    118  N   GLU    16     -29.283  34.229   3.251  0.50 12.86           N
ATOM    120  CA  GLU    16     -30.060  34.743   4.392  0.50 12.65           C
ATOM    122  CB  GLU    16     -29.168  34.850   5.619  0.50 11.98           C
ATOM    124  CG  GLU    16     -28.366  33.560   5.847  0.50 10.56           C
ATOM    126  CD  GLU    16     -29.193  32.437   6.436  0.50 10.50           C
ATOM    128  OE1 GLU    16     -29.690  32.653   7.554  0.50 13.56           O
ATOM    130  OE2 GLU    16     -29.343  31.334   5.814  0.50  9.37           O
ATOM    132  C   GLU    16     -30.844  36.053   4.135  0.50 13.06           C
ATOM    134  O   GLU    16     -31.941  36.247   4.680  0.50 12.44           O
ATOM    136  N   LEU    17     -30.289  36.937   3.304  1.00 13.39           N
ATOM    137  CA  LEU    17     -30.999  38.157   2.904  1.00 13.60           C
ATOM    138  CB  LEU    17     -30.022  39.257   2.439  1.00 13.92           C
ATOM    139  CG  LEU    17     -29.168  39.859   3.564  1.00 15.45           C
ATOM    140  CD1 LEU    17     -28.242  40.964   3.019  1.00 18.76           C
ATOM    141  CD2 LEU    17     -30.008  40.355   4.753  1.00 18.21           C
ATOM    142  C   LEU    17     -32.079  37.907   1.841  1.00 13.42           C
ATOM    143  O   LEU    17     -33.201  38.400   2.004  1.00 13.35           O
ATOM    144  N   PHE    18     -31.772  37.132   0.800  1.00 12.52           N
ATOM    145  CA  PHE    18     -32.789  36.767  -0.188  1.00 12.55           C
ATOM    146  CB  PHE    18     -32.168  36.032  -1.355  1.00 12.74           C
ATOM    147  CG  PHE    18     -31.341  36.895  -2.267  1.00 11.67           C
ATOM    148  CD1 PHE    18     -31.865  38.079  -2.813  1.00 12.22           C
ATOM    149  CE1 PHE    18     -31.138  38.864  -3.706  1.00 12.93           C
ATOM    150  CZ  PHE    18     -29.843  38.455  -4.104  1.00 13.62           C
ATOM    151  CE2 PHE    18     -29.308  37.240  -3.582  1.00 11.19           C
ATOM    152  CD2 PHE    18     -30.083  36.472  -2.677  1.00 11.90           C
ATOM    153  C   PHE    18     -33.889  35.866   0.419  1.00 13.51           C
ATOM    154  O   PHE    18     -35.054  35.962   0.015  1.00 15.25           O
ATOM    155  N   ALA    19     -33.532  34.996   1.373  1.00 13.39           N
ATOM    156  CA  ALA    19     -34.553  34.208   2.061  1.00 15.05           C
ATOM    157  CB  ALA    19     -33.942  33.133   2.992  1.00 14.27           C
ATOM    158  C   ALA    19     -35.536  35.094   2.817  1.00 15.36           C
ATOM    159  O   ALA    19     -36.754  34.842   2.737  1.00 16.78           O
ATOM    160  N   GLN    20     -35.009  36.097   3.541  0.70 16.27           N
ATOM    162  CA  GLN    20     -35.806  37.053   4.335  0.70 16.80           C
ATOM    164  CB  GLN    20     -34.946  37.989   5.239  0.70 17.01           C
ATOM    166  CG  GLN    20     -35.745  39.306   5.640  0.70 16.81           C
ATOM    168  CD  GLN    20     -35.206  40.143   6.812  0.70 17.74           C
ATOM    170  OE1 GLN    20     -35.154  41.393   6.736  0.70 13.85           O
ATOM    172  NE2 GLN    20     -34.830  39.472   7.903  0.70 18.70           N
ATOM    174  C   GLN    20     -36.691  37.941   3.482  0.70 17.07           C
ATOM    176  O   GLN    20     -37.900  38.009   3.701  0.70 17.23           O
ATOM    178  N   LYS    21     -36.060  38.636   2.537  1.00 15.44           N
ATOM    179  CA  LYS    21     -36.656  39.778   1.820  1.00 16.20           C
ATOM    180  CB  LYS    21     -35.693  40.954   1.797  1.00 16.65           C
ATOM    181  CG  LYS    21     -35.259  41.391   3.184  1.00 19.64           C
ATOM    182  CD  LYS    21     -34.363  42.583   3.043  1.00 22.59           C
ATOM    183  CE  LYS    21     -33.720  42.901   4.359  1.00 25.71           C
ATOM    184  NZ  LYS    21     -33.292  44.316   4.378  1.00 29.79           N
ATOM    185  C   LYS    21     -37.021  39.482   0.389  1.00 15.03           C
ATOM    186  O   LYS    21     -37.639  40.317  -0.275  1.00 16.30           O
ATOM    187  N   GLY    22     -36.632  38.313  -0.101  1.00 14.81           N
ATOM    188  CA  GLY    22     -36.879  37.954  -1.501  1.00 12.41           C
ATOM    189  C   GLY    22     -35.967  38.743  -2.431  1.00 13.23           C
ATOM    190  O   GLY    22     -35.355  39.762  -2.034  1.00 13.65           O
ATOM    191  N   PHE    23     -35.857  38.255  -3.660  1.00 12.90           N
ATOM    192  CA  PHE    23     -35.064  38.952  -4.675  1.00 13.24           C
ATOM    193  CB  PHE    23     -35.255  38.297  -6.043  1.00 15.31           C
ATOM    194  CG  PHE    23     -34.544  39.016  -7.130  1.00 16.26           C
ATOM    195  CD1 PHE    23     -33.214  38.729  -7.414  1.00 17.28           C
ATOM    196  CE1 PHE    23     -32.528  39.446  -8.406  1.00 17.88           C
ATOM    197  CZ  PHE    23     -33.173  40.390  -9.137  1.00 18.69           C
ATOM    198  CE2 PHE    23     -34.531  40.677  -8.884  1.00 18.23           C
ATOM    199  CD2 PHE    23     -35.193  40.000  -7.883  1.00 18.32           C
ATOM    200  C   PHE    23     -35.468  40.425  -4.758  1.00 14.16           C
ATOM    201  O   PHE    23     -34.604  41.312  -4.880  1.00 14.45           O
ATOM    202  N   TYR    24     -36.778  40.690  -4.743  1.00 14.52           N
ATOM    203  CA  TYR    24     -37.263  42.057  -4.998  1.00 15.59           C
ATOM    204  CB  TYR    24     -38.733  42.085  -5.422  1.00 13.51           C
ATOM    205  CG  TYR    24     -38.963  41.406  -6.781  1.00 13.47           C
ATOM    206  CD1 TYR    24     -38.665  42.064  -7.967  1.00 12.55           C
ATOM    207  CE1 TYR    24     -38.890  41.458  -9.241  1.00 13.28           C
ATOM    208  CZ  TYR    24     -39.399  40.139  -9.303  1.00 10.43           C
ATOM    209  OH  TYR    24     -39.630  39.577 -10.572  1.00 11.31           O
ATOM    210  CE2 TYR    24     -39.713  39.475  -8.126  1.00 11.68           C
ATOM    211  CD2 TYR    24     -39.493  40.106  -6.858  1.00 14.21           C
ATOM    212  C   TYR    24     -37.080  42.970  -3.806  1.00 16.80           C
ATOM    213  O   TYR    24     -37.286  44.167  -3.939  1.00 18.89           O
ATOM    214  N   GLY    25     -36.702  42.429  -2.656  1.00 16.86           N
ATOM    215  CA  GLY    25     -36.488  43.287  -1.478  1.00 17.30           C
ATOM    216  C   GLY    25     -35.036  43.519  -1.070  1.00 18.19           C
ATOM    217  O   GLY    25     -34.787  44.141  -0.042  1.00 18.97           O
ATOM    218  N   VAL    26     -34.080  42.983  -1.822  1.00 17.80           N
ATOM    219  CA  VAL    26     -32.653  43.017  -1.434  1.00 17.86           C
ATOM    220  CB  VAL    26     -32.053  41.567  -1.526  1.00 16.88           C
ATOM    221  CG1 VAL    26     -30.493  41.578  -1.523  1.00 19.19           C
ATOM    222  CG2 VAL    26     -32.546  40.691  -0.382  1.00 17.09           C
ATOM    223  C   VAL    26     -31.896  43.951  -2.405  1.00 18.57           C
ATOM    224  O   VAL    26     -32.112  43.860  -3.619  1.00 19.26           O
ATOM    225  N   SER    27     -31.024  44.837  -1.900  1.00 18.29           N
ATOM    226  CA  SER    27     -30.188  45.651  -2.802  1.00 18.73           C
ATOM    227  CB  SER    27     -30.240  47.135  -2.451  1.00 18.20           C
ATOM    228  OG  SER    27     -29.499  47.385  -1.297  1.00 19.53           O
ATOM    229  C   SER    27     -28.743  45.196  -2.781  1.00 18.39           C
ATOM    230  O   SER    27     -28.296  44.592  -1.823  1.00 18.07           O
ATOM    231  N   ILE    28     -28.001  45.507  -3.836  1.00 18.31           N
ATOM    232  CA  ILE    28     -26.587  45.151  -3.866  1.00 18.54           C
ATOM    233  CB  ILE    28     -25.953  45.425  -5.232  1.00 18.62           C
ATOM    234  CG1 ILE    28     -24.599  44.703  -5.348  1.00 18.14           C
ATOM    235  CD1 ILE    28     -23.953  44.785  -6.743  1.00 19.13           C
ATOM    236  CG2 ILE    28     -25.915  46.963  -5.537  1.00 18.10           C
ATOM    237  C   ILE    28     -25.825  45.846  -2.714  1.00 18.97           C
ATOM    238  O   ILE    28     -24.902  45.274  -2.156  1.00 17.66           O
ATOM    239  N   ARG    29     -26.211  47.076  -2.360  1.00 19.97           N
ATOM    240  CA  ARG    29     -25.589  47.737  -1.207  1.00 22.13           C
ATOM    241  CB  ARG    29     -26.120  49.174  -1.012  1.00 21.53           C
ATOM    242  CG  ARG    29     -25.467  49.925   0.170  1.00 25.16           C
ATOM    243  CD  ARG    29     -26.316  51.109   0.743  1.00 26.22           C
ATOM    244  NE  ARG    29     -27.682  50.707   1.142  1.00 35.15           N
ATOM    245  CZ  ARG    29     -28.010  50.032   2.256  1.00 36.75           C
ATOM    246  NH1 ARG    29     -27.084  49.650   3.137  1.00 38.29           N
ATOM    247  NH2 ARG    29     -29.285  49.730   2.492  1.00 38.04           N
ATOM    248  C   ARG    29     -25.725  46.902   0.085  1.00 21.09           C
ATOM    249  O   ARG    29     -24.730  46.691   0.798  1.00 19.92           O
ATOM    250  N   GLU    30     -26.937  46.412   0.371  1.00 22.16           N
ATOM    251  CA  GLU    30     -27.160  45.541   1.551  1.00 22.56           C
ATOM    252  CB  GLU    30     -28.618  45.119   1.693  1.00 23.46           C
ATOM    253  CG  GLU    30     -29.623  46.242   1.841  1.00 28.08           C
ATOM    254  CD  GLU    30     -31.046  45.786   1.483  1.00 34.28           C
ATOM    255  OE1 GLU    30     -31.275  44.555   1.368  1.00 33.74           O
ATOM    256  OE2 GLU    30     -31.935  46.662   1.307  1.00 37.15           O
ATOM    257  C   GLU    30     -26.301  44.272   1.533  1.00 21.44           C
ATOM    258  O   GLU    30     -25.795  43.856   2.577  1.00 21.23           O
ATOM    259  N   LEU    31     -26.170  43.640   0.359  1.00 19.98           N
ATOM    260  CA  LEU    31     -25.338  42.431   0.251  1.00 18.96           C
ATOM    261  CB  LEU    31     -25.426  41.823  -1.145  1.00 18.00           C
ATOM    262  CG  LEU    31     -26.768  41.239  -1.562  1.00 18.12           C
ATOM    263  CD1 LEU    31     -26.678  40.931  -3.057  1.00 16.01           C
ATOM    264  CD2 LEU    31     -27.078  39.993  -0.744  1.00 18.33           C
ATOM    265  C   LEU    31     -23.871  42.715   0.588  1.00 18.24           C
ATOM    266  O   LEU    31     -23.227  41.984   1.363  1.00 18.55           O
ATOM    267  N   ALA    32     -23.328  43.776  -0.005  1.00 18.07           N
ATOM    268  CA  ALA    32     -21.928  44.131   0.234  1.00 17.87           C
ATOM    269  CB  ALA    32     -21.533  45.282  -0.659  1.00 17.05           C
ATOM    270  C   ALA    32     -21.689  44.449   1.719  1.00 18.48           C
ATOM    271  O   ALA    32     -20.741  43.938   2.338  1.00 18.50           O
ATOM    272  N   GLN    33     -22.577  45.264   2.282  1.00 18.14           N
ATOM    273  CA  GLN    33     -22.467  45.687   3.672  1.00 18.66           C
ATOM    274  CB  GLN    33     -23.613  46.652   4.012  1.00 18.81           C
ATOM    279  C   GLN    33     -22.496  44.452   4.579  1.00 18.25           C
ATOM    280  O   GLN    33     -21.649  44.307   5.470  1.00 19.06           O
ATOM    281  N   ALA    34     -23.456  43.552   4.355  1.00 18.35           N
ATOM    282  CA  ALA    34     -23.588  42.387   5.224  1.00 17.57           C
ATOM    283  CB  ALA    34     -24.915  41.670   4.988  1.00 18.88           C
ATOM    284  C   ALA    34     -22.400  41.424   5.094  1.00 17.93           C
ATOM    285  O   ALA    34     -22.007  40.800   6.073  1.00 18.07           O
ATOM    286  N   ALA    35     -21.812  41.324   3.902  1.00 17.59           N
ATOM    287  CA  ALA    35     -20.653  40.434   3.662  1.00 17.45           C
ATOM    288  CB  ALA    35     -20.742  39.832   2.241  1.00 17.60           C
ATOM    289  C   ALA    35     -19.271  41.084   3.858  1.00 17.39           C
ATOM    290  O   ALA    35     -18.253  40.386   3.869  1.00 17.10           O
ATOM    291  N   GLY    36     -19.216  42.410   3.975  1.00 17.53           N
ATOM    292  CA  GLY    36     -17.934  43.120   4.053  1.00 17.54           C
ATOM    293  C   GLY    36     -17.142  43.046   2.755  1.00 18.20           C
ATOM    294  O   GLY    36     -15.894  43.109   2.760  1.00 18.83           O
ATOM    295  N   ALA    37     -17.868  42.917   1.638  1.00 18.05           N
ATOM    296  CA  ALA    37     -17.298  42.947   0.287  1.00 17.70           C
ATOM    297  CB  ALA    37     -17.905  41.813  -0.553  1.00 17.69           C
ATOM    298  C   ALA    37     -17.594  44.299  -0.377  1.00 17.25           C
ATOM    299  O   ALA    37     -18.512  44.995   0.029  1.00 17.90           O
ATOM    300  N   SER    38     -16.844  44.680  -1.401  1.00 16.01           N
ATOM    301  CA  SER    38     -17.181  45.941  -2.083  1.00 15.66           C
ATOM    302  CB  SER    38     -15.986  46.530  -2.815  1.00 15.99           C
ATOM    303  OG  SER    38     -15.465  45.574  -3.709  1.00 15.63           O
ATOM    304  C   SER    38     -18.275  45.670  -3.090  1.00 15.23           C
ATOM    305  O   SER    38     -18.390  44.545  -3.568  1.00 14.69           O
ATOM    306  N   ILE    39     -19.054  46.696  -3.426  1.00 14.99           N
ATOM    307  CA  ILE    39     -20.019  46.586  -4.524  1.00 16.34           C
ATOM    308  CB  ILE    39     -20.795  47.908  -4.725  1.00 18.03           C
ATOM    309  CG1 ILE    39     -21.771  48.099  -3.551  1.00 18.95           C
ATOM    310  CD1 ILE    39     -22.260  49.551  -3.403  1.00 24.07           C
ATOM    311  CG2 ILE    39     -21.568  47.905  -6.053  1.00 19.22           C
ATOM    312  C   ILE    39     -19.321  46.142  -5.820  1.00 14.71           C
ATOM    313  O   ILE    39     -19.846  45.293  -6.544  1.00 14.07           O
ATOM    314  N   SER    40     -18.089  46.604  -6.010  0.50 14.67           N
ATOM    316  CA  SER    40     -17.279  46.176  -7.148  0.50 14.62           C
ATOM    318  CB  SER    40     -16.053  47.060  -7.335  0.50 14.94           C
ATOM    320  OG  SER    40     -16.458  48.367  -7.690  0.50 15.23           O
ATOM    322  C   SER    40     -16.894  44.691  -7.144  0.50 14.74           C
ATOM    324  O   SER    40     -17.018  44.048  -8.190  0.50 13.11           O
ATOM    326  N   MET    41     -16.429  44.140  -6.011  0.70 14.50           N
ATOM    328  CA  MET    41     -16.178  42.699  -5.979  0.70 17.69           C
ATOM    330  CB  MET    41     -15.783  42.221  -4.589  0.70 17.10           C
ATOM    332  CG  MET    41     -14.312  42.342  -4.347  0.70 22.14           C
ATOM    334  SD  MET    41     -13.942  42.349  -2.431  0.70 31.19          SE
ATOM    336  CE  MET    41     -12.415  43.576  -2.469  0.70 24.49           C
ATOM    338  C   MET    41     -17.447  41.995  -6.467  0.70 13.85           C
ATOM    340  O   MET    41     -17.391  41.116  -7.335  0.70 12.19           O
ATOM    342  N   ILE    42     -18.586  42.445  -5.946  1.00 11.54           N
ATOM    343  CA  ILE    42     -19.860  41.745  -6.191  1.00 10.80           C
ATOM    344  CB  ILE    42     -21.001  42.280  -5.316  1.00 11.27           C
ATOM    345  CG1 ILE    42     -20.695  41.978  -3.842  1.00 13.93           C
ATOM    346  CD1 ILE    42     -21.839  42.300  -2.903  1.00 16.88           C
ATOM    347  CG2 ILE    42     -22.327  41.616  -5.716  1.00 12.87           C
ATOM    348  C   ILE    42     -20.219  41.838  -7.658  1.00  8.83           C
ATOM    349  O   ILE    42     -20.497  40.819  -8.306  1.00  9.33           O
ATOM    350  N   SER    43     -20.157  43.052  -8.211  1.00  8.95           N
ATOM    351  CA  SER    43     -20.581  43.239  -9.602  1.00  9.74           C
ATOM    352  CB  SER    43     -20.655  44.729  -9.931  1.00 10.68           C
ATOM    353  OG  SER    43     -21.770  45.278  -9.279  1.00 13.08           O
ATOM    354  C   SER    43     -19.645  42.587 -10.619  1.00  9.62           C
ATOM    355  O   SER    43     -20.105  42.053 -11.624  1.00  9.13           O
ATOM    356  N   TYR    44     -18.328  42.697 -10.382  1.00  9.20           N
ATOM    357  CA  TYR    44     -17.361  42.244 -11.376  1.00 10.08           C
ATOM    358  CB  TYR    44     -16.121  43.137 -11.344  1.00  9.76           C
ATOM    359  CG  TYR    44     -16.373  44.487 -11.942  1.00  8.65           C
ATOM    360  CD1 TYR    44     -16.965  45.500 -11.184  1.00  8.93           C
ATOM    361  CE1 TYR    44     -17.202  46.730 -11.711  1.00 10.45           C
ATOM    362  CZ  TYR    44     -16.853  46.987 -13.027  1.00 10.79           C
ATOM    363  OH  TYR    44     -17.090  48.220 -13.553  1.00 11.57           O
ATOM    364  CE2 TYR    44     -16.260  46.002 -13.818  1.00 10.86           C
ATOM    365  CD2 TYR    44     -16.019  44.758 -13.255  1.00  9.35           C
ATOM    366  C   TYR    44     -16.923  40.795 -11.222  1.00 12.28           C
ATOM    367  O   TYR    44     -16.468  40.193 -12.203  1.00 12.21           O
ATOM    368  N   HIS    45     -16.993  40.271 -10.000  1.00 14.53           N
ATOM    369  CA  HIS    45     -16.489  38.928  -9.730  1.00 17.90           C
ATOM    370  CB  HIS    45     -15.347  38.951  -8.714  1.00 18.81           C
ATOM    371  CG  HIS    45     -14.062  39.424  -9.294  1.00 21.69           C
ATOM    372  ND1 HIS    45     -13.118  40.111  -8.564  1.00 26.38           N
ATOM    373  CE1 HIS    45     -12.092  40.405  -9.346  1.00 27.60           C
ATOM    374  NE2 HIS    45     -12.350  39.958 -10.563  1.00 26.67           N
ATOM    375  CD2 HIS    45     -13.574  39.339 -10.558  1.00 25.29           C
ATOM    376  C   HIS    45     -17.532  37.898  -9.348  1.00 19.42           C
ATOM    377  O   HIS    45     -17.334  36.722  -9.630  1.00 19.75           O
ATOM    378  N   PHE    46     -18.630  38.324  -8.726  1.00 20.52           N
ATOM    379  CA  PHE    46     -19.661  37.377  -8.261  1.00 22.82           C
ATOM    380  CB  PHE    46     -19.800  37.465  -6.732  1.00 23.98           C
ATOM    381  CG  PHE    46     -18.496  37.308  -6.003  1.00 26.04           C
ATOM    382  CD1 PHE    46     -18.012  36.039  -5.670  1.00 29.01           C
ATOM    383  CE1 PHE    46     -16.817  35.893  -5.005  1.00 27.12           C
ATOM    384  CZ  PHE    46     -16.071  37.013  -4.649  1.00 28.27           C
ATOM    385  CE2 PHE    46     -16.542  38.280  -4.963  1.00 29.34           C
ATOM    386  CD2 PHE    46     -17.743  38.419  -5.640  1.00 27.17           C
ATOM    387  C   PHE    46     -21.004  37.504  -8.954  1.00 22.70           C
ATOM    388  O   PHE    46     -22.017  36.978  -8.483  1.00 25.73           O
ATOM    389  N   GLY    47     -21.020  38.197 -10.083  1.00 20.71           N
ATOM    390  CA  GLY    47     -22.178  38.260 -10.943  1.00 19.73           C
ATOM    391  C   GLY    47     -23.257  39.227 -10.550  1.00 18.52           C
ATOM    392  O   GLY    47     -24.373  39.148 -11.073  1.00 20.99           O
ATOM    393  N   GLY    48     -22.955  40.137  -9.620  1.00 14.66           N
ATOM    394  CA  GLY    48     -23.926  41.115  -9.145  1.00 14.41           C
ATOM    395  C   GLY    48     -25.035  40.479  -8.295  1.00 13.29           C
ATOM    396  O   GLY    48     -24.959  39.296  -7.948  1.00 12.06           O
ATOM    397  N   LYS    49     -26.021  41.290  -7.929  1.00 13.51           N
ATOM    398  CA  LYS    49     -27.206  40.794  -7.200  1.00 13.00           C
ATOM    399  CB  LYS    49     -28.212  41.934  -7.086  1.00 14.01           C
ATOM    400  CG  LYS    49     -29.503  41.518  -6.350  1.00 15.37           C
ATOM    401  CD  LYS    49     -30.528  42.649  -6.447  1.00 16.73           C
ATOM    402  CE  LYS    49     -31.905  42.078  -6.083  1.00 17.71           C
ATOM    403  NZ  LYS    49     -32.895  43.218  -6.101  1.00 18.77           N
ATOM    404  C   LYS    49     -27.809  39.595  -7.932  1.00 13.68           C
ATOM    405  O   LYS    49     -28.212  38.583  -7.331  1.00 13.27           O
ATOM    406  N   GLU    50     -27.876  39.703  -9.258  1.00 12.63           N
ATOM    407  CA  GLU    50     -28.627  38.725 -10.042  1.00 12.69           C
ATOM    408  CB  GLU    50     -28.814  39.232 -11.468  1.00 13.68           C
ATOM    409  CG  GLU    50     -29.657  40.500 -11.528  1.00 14.16           C
ATOM    410  CD  GLU    50     -28.887  41.815 -11.286  1.00 16.98           C
ATOM    411  OE1 GLU    50     -27.638  41.867 -11.018  1.00 15.01           O
ATOM    412  OE2 GLU    50     -29.566  42.854 -11.451  1.00 19.39           O
ATOM    413  C   GLU    50     -27.883  37.393 -10.048  1.00 12.35           C
ATOM    414  O   GLU    50     -28.506  36.350  -9.816  1.00 13.25           O
ATOM    415  N   GLY    51     -26.567  37.455 -10.306  1.00 11.97           N
ATOM    416  CA  GLY    51     -25.695  36.286 -10.303  1.00 11.39           C
ATOM    417  C   GLY    51     -25.724  35.592  -8.952  1.00 13.31           C
ATOM    418  O   GLY    51     -25.865  34.369  -8.874  1.00 12.68           O
ATOM    419  N   LEU    52     -25.637  36.365  -7.877  1.00 12.96           N
ATOM    420  CA  LEU    52     -25.702  35.752  -6.544  1.00 13.84           C
ATOM    421  CB  LEU    52     -25.453  36.774  -5.450  1.00 13.00           C
ATOM    422  CG  LEU    52     -24.017  37.257  -5.300  1.00 15.32           C
ATOM    423  CD1 LEU    52     -24.026  38.415  -4.321  1.00 17.15           C
ATOM    424  CD2 LEU    52     -23.089  36.110  -4.862  1.00 13.25           C
ATOM    425  C   LEU    52     -27.047  35.092  -6.282  1.00 13.75           C
ATOM    426  O   LEU    52     -27.092  34.016  -5.680  1.00 14.21           O
ATOM    427  N   TYR    53     -28.140  35.744  -6.693  1.00 14.29           N
ATOM    428  CA  TYR    53     -29.441  35.176  -6.517  1.00 14.44           C
ATOM    429  CB  TYR    53     -30.541  36.161  -6.936  1.00 12.90           C
ATOM    430  CG  TYR    53     -31.928  35.606  -6.681  1.00 13.47           C
ATOM    431  CD1 TYR    53     -32.405  35.437  -5.365  1.00 13.59           C
ATOM    432  CE1 TYR    53     -33.679  34.910  -5.123  1.00 14.34           C
ATOM    433  CZ  TYR    53     -34.477  34.537  -6.198  1.00 13.72           C
ATOM    434  OH  TYR    53     -35.718  34.039  -5.965  1.00 13.83           O
ATOM    435  CE2 TYR    53     -34.023  34.711  -7.525  1.00 13.18           C
ATOM    436  CD2 TYR    53     -32.751  35.220  -7.740  1.00 11.75           C
ATOM    437  C   TYR    53     -29.578  33.863  -7.306  1.00 14.35           C
ATOM    438  O   TYR    53     -30.064  32.892  -6.754  1.00 14.84           O
ATOM    439  N   ALA    54     -29.125  33.849  -8.569  1.00 14.57           N
ATOM    440  CA  ALA    54     -29.145  32.612  -9.394  1.00 14.76           C
ATOM    441  CB  ALA    54     -28.572  32.882 -10.785  1.00 15.38           C
ATOM    442  C   ALA    54     -28.382  31.465  -8.737  1.00 16.02           C
ATOM    443  O   ALA    54     -28.853  30.302  -8.752  1.00 16.58           O
ATOM    444  N   ALA    55     -27.206  31.790  -8.179  1.00 15.71           N
ATOM    445  CA  ALA    55     -26.349  30.797  -7.512  1.00 16.60           C
ATOM    446  CB  ALA    55     -24.985  31.418  -7.114  1.00 15.94           C
ATOM    447  C   ALA    55     -27.087  30.239  -6.293  1.00 16.62           C
ATOM    448  O   ALA    55     -27.124  29.027  -6.079  1.00 17.79           O
ATOM    449  N   VAL    56     -27.698  31.121  -5.509  1.00 16.55           N
ATOM    450  CA  VAL    56     -28.442  30.724  -4.309  1.00 17.16           C
ATOM    451  CB  VAL    56     -28.958  31.984  -3.551  1.00 17.77           C
ATOM    452  CG1 VAL    56     -30.068  31.623  -2.591  1.00 18.51           C
ATOM    453  CG2 VAL    56     -27.808  32.716  -2.799  1.00 16.47           C
ATOM    454  C   VAL    56     -29.643  29.805  -4.680  1.00 17.90           C
ATOM    455  O   VAL    56     -29.872  28.769  -4.064  1.00 18.42           O
ATOM    456  N   LEU    57     -30.409  30.209  -5.690  1.00 18.83           N
ATOM    457  CA  LEU    57     -31.588  29.428  -6.064  1.00 20.44           C
ATOM    458  CB  LEU    57     -32.429  30.224  -7.058  1.00 19.98           C
ATOM    459  CG  LEU    57     -33.922  29.962  -7.106  1.00 25.44           C
ATOM    460  CD1 LEU    57     -34.592  30.145  -5.755  1.00 24.83           C
ATOM    461  CD2 LEU    57     -34.480  30.939  -8.118  1.00 27.85           C
ATOM    462  C   LEU    57     -31.165  28.050  -6.627  1.00 20.90           C
ATOM    463  O   LEU    57     -31.808  27.031  -6.345  1.00 20.75           O
ATOM    464  N   GLN    58     -30.052  28.016  -7.360  1.00 21.09           N
ATOM    465  CA  GLN    58     -29.551  26.768  -7.929  1.00 22.36           C
ATOM    466  CB  GLN    58     -28.346  26.998  -8.858  1.00 23.54           C
ATOM    467  CG  GLN    58     -27.960  25.733  -9.635  1.00 27.99           C
ATOM    468  CD  GLN    58     -29.191  25.021 -10.220  1.00 35.26           C
ATOM    469  OE1 GLN    58     -29.888  25.570 -11.083  1.00 37.09           O
ATOM    470  NE2 GLN    58     -29.469  23.796  -9.736  1.00 38.37           N
ATOM    471  C   GLN    58     -29.205  25.793  -6.803  1.00 22.27           C
ATOM    472  O   GLN    58     -29.522  24.575  -6.887  1.00 22.87           O
ATOM    473  N   GLU    59     -28.579  26.306  -5.741  0.50 21.38           N
ATOM    475  CA  GLU    59     -28.271  25.503  -4.553  0.50 21.43           C
ATOM    477  CB  GLU    59     -27.388  26.269  -3.553  0.50 21.44           C
ATOM    479  CG  GLU    59     -26.869  25.393  -2.378  0.50 21.69           C
ATOM    481  CD  GLU    59     -26.114  26.171  -1.293  0.50 22.85           C
ATOM    483  OE1 GLU    59     -25.921  27.400  -1.427  0.50 25.49           O
ATOM    485  OE2 GLU    59     -25.705  25.539  -0.292  0.50 22.88           O
ATOM    487  C   GLU    59     -29.535  25.040  -3.848  0.50 20.81           C
ATOM    489  O   GLU    59     -29.586  23.907  -3.359  0.50 20.84           O
ATOM    491  N   GLN    60     -30.526  25.927  -3.763  1.00 20.01           N
ATOM    492  CA  GLN    60     -31.823  25.588  -3.146  1.00 20.01           C
ATOM    493  CB  GLN    60     -32.751  26.812  -3.069  1.00 18.91           C
ATOM    494  CG  GLN    60     -32.254  27.942  -2.169  1.00 22.57           C
ATOM    495  CD  GLN    60     -32.132  27.523  -0.695  1.00 23.52           C
ATOM    496  OE1 GLN    60     -33.063  26.939  -0.124  1.00 25.17           O
ATOM    497  NE2 GLN    60     -30.987  27.798  -0.090  1.00 23.26           N
ATOM    498  C   GLN    60     -32.527  24.444  -3.865  1.00 18.38           C
ATOM    499  O   GLN    60     -33.135  23.578  -3.222  1.00 19.77           O
ATOM    500  N   PHE    61     -32.428  24.422  -5.192  1.00 18.84           N
ATOM    501  CA  PHE    61     -33.171  23.452  -5.980  1.00 18.05           C
ATOM    502  CB  PHE    61     -33.920  24.171  -7.089  1.00 18.50           C
ATOM    503  CG  PHE    61     -35.166  24.855  -6.603  1.00 16.29           C
ATOM    504  CD1 PHE    61     -35.097  26.142  -6.066  1.00 16.96           C
ATOM    505  CE1 PHE    61     -36.246  26.777  -5.586  1.00 17.57           C
ATOM    506  CZ  PHE    61     -37.469  26.128  -5.639  1.00 16.05           C
ATOM    507  CE2 PHE    61     -37.562  24.840  -6.149  1.00 16.94           C
ATOM    508  CD2 PHE    61     -36.415  24.206  -6.655  1.00 16.84           C
ATOM    509  C   PHE    61     -32.316  22.293  -6.529  1.00 18.86           C
ATOM    510  O   PHE    61     -32.799  21.474  -7.288  1.00 17.68           O
ATOM    511  N   ALA    62     -31.039  22.250  -6.153  1.00 19.75           N
ATOM    512  CA  ALA    62     -30.116  21.245  -6.684  1.00 20.70           C
ATOM    513  CB  ALA    62     -28.776  21.377  -5.988  1.00 21.27           C
ATOM    514  C   ALA    62     -30.639  19.784  -6.602  1.00 21.89           C
ATOM    515  O   ALA    62     -30.568  19.023  -7.588  1.00 22.43           O
ATOM    516  N   CYS    63     -31.180  19.433  -5.431  0.50 22.09           N
ATOM    518  CA  CYS    63     -31.713  18.088  -5.137  0.50 22.45           C
ATOM    520  CB  CYS    63     -32.194  18.002  -3.682  0.50 21.93           C
ATOM    522  SG  CYS    63     -30.917  17.628  -2.464  0.50 27.26           S
ATOM    524  C   CYS    63     -32.836  17.625  -6.072  0.50 21.59           C
ATOM    526  O   CYS    63     -33.089  16.419  -6.196  0.50 20.76           O
ATOM    528  N   PHE    64     -33.520  18.570  -6.711  1.00 20.75           N
ATOM    529  CA  PHE    64     -34.567  18.235  -7.659  1.00 20.96           C
ATOM    530  CB  PHE    64     -35.405  19.451  -8.035  1.00 19.37           C
ATOM    531  CG  PHE    64     -36.415  19.870  -6.996  1.00 19.26           C
ATOM    532  CD1 PHE    64     -36.028  20.573  -5.872  1.00 19.73           C
ATOM    533  CE1 PHE    64     -36.994  21.017  -4.934  1.00 18.87           C
ATOM    534  CZ  PHE    64     -38.331  20.739  -5.155  1.00 17.71           C
ATOM    535  CE2 PHE    64     -38.722  20.056  -6.260  1.00 18.01           C
ATOM    536  CD2 PHE    64     -37.778  19.643  -7.202  1.00 18.03           C
ATOM    537  C   PHE    64     -34.008  17.587  -8.957  1.00 21.96           C
ATOM    538  O   PHE    64     -34.743  16.934  -9.688  1.00 23.37           O
ATOM    539  N   GLY    65     -32.716  17.728  -9.209  1.00 22.10           N
ATOM    540  CA  GLY    65     -32.106  17.074 -10.371  1.00 23.22           C
ATOM    541  C   GLY    65     -31.577  15.697 -10.034  1.00 24.11           C
ATOM    542  O   GLY    65     -30.930  15.040 -10.873  1.00 24.63           O
ATOM    543  N   GLN    66     -31.841  15.266  -8.802  1.00 24.05           N
ATOM    544  CA  GLN    66     -31.357  13.993  -8.283  1.00 24.54           C
ATOM    545  CB  GLN    66     -30.285  14.241  -7.234  1.00 25.47           C
ATOM    546  CG  GLN    66     -28.910  14.511  -7.854  1.00 30.42           C
ATOM    547  CD  GLN    66     -28.001  15.342  -6.962  1.00 36.44           C
ATOM    548  OE1 GLN    66     -28.382  16.421  -6.479  1.00 39.74           O
ATOM    549  NE2 GLN    66     -26.784  14.859  -6.761  1.00 37.88           N
ATOM    550  C   GLN    66     -32.519  13.185  -7.688  1.00 23.92           C
ATOM    551  O   GLN    66     -32.671  13.075  -6.467  1.00 23.62           O
ATOM    552  N   LEU    67     -33.319  12.616  -8.579  1.00 22.78           N
ATOM    553  CA  LEU    67     -34.545  11.916  -8.200  1.00 21.55           C
ATOM    554  CB  LEU    67     -35.668  12.370  -9.128  1.00 21.58           C
ATOM    555  CG  LEU    67     -35.860  13.887  -9.236  1.00 21.33           C
ATOM    556  CD1 LEU    67     -36.995  14.155 -10.180  1.00 22.06           C
ATOM    557  CD2 LEU    67     -36.147  14.475  -7.858  1.00 21.71           C
ATOM    558  C   LEU    67     -34.455  10.391  -8.219  1.00 21.26           C
ATOM    559  O   LEU    67     -35.485   9.730  -8.205  1.00 20.77           O
ATOM    560  N   ASP    68     -33.243   9.827  -8.209  1.00 20.58           N
ATOM    561  CA  ASP    68     -33.066   8.375  -8.336  1.00 21.06           C
ATOM    562  CB  ASP    68     -31.588   8.003  -8.545  1.00 22.43           C
ATOM    563  CG  ASP    68     -31.143   8.118 -10.019  1.00 25.47           C
ATOM    564  OD1 ASP    68     -32.015   8.221 -10.922  1.00 30.33           O
ATOM    565  OD2 ASP    68     -29.915   8.103 -10.278  1.00 28.49           O
ATOM    566  C   ASP    68     -33.707   7.551  -7.191  1.00 21.11           C
ATOM    567  O   ASP    68     -34.136   6.420  -7.409  1.00 20.72           O
ATOM    568  N   ASP    69     -33.790   8.106  -5.981  1.00 20.70           N
ATOM    569  CA  ASP    69     -34.499   7.393  -4.890  1.00 21.27           C
ATOM    570  CB  ASP    69     -34.371   8.149  -3.562  1.00 22.13           C
ATOM    571  CG  ASP    69     -32.986   8.014  -2.948  1.00 24.48           C
ATOM    572  OD1 ASP    69     -32.312   6.996  -3.200  1.00 27.84           O
ATOM    573  OD2 ASP    69     -32.581   8.940  -2.220  1.00 28.42           O
ATOM    574  C   ASP    69     -35.988   7.188  -5.201  1.00 20.42           C
ATOM    575  O   ASP    69     -36.621   6.239  -4.725  1.00 20.59           O
ATOM    576  N   ILE    70     -36.539   8.100  -5.989  1.00 19.38           N
ATOM    577  CA  ILE    70     -37.928   7.992  -6.429  1.00 18.85           C
ATOM    578  CB  ILE    70     -38.556   9.366  -6.619  1.00 18.52           C
ATOM    579  CG1 ILE    70     -38.411  10.193  -5.323  1.00 21.19           C
ATOM    580  CD1 ILE    70     -38.809  11.665  -5.486  1.00 21.34           C
ATOM    581  CG2 ILE    70     -40.039   9.235  -6.997  1.00 19.97           C
ATOM    582  C   ILE    70     -38.014   7.194  -7.726  1.00 17.62           C
ATOM    583  O   ILE    70     -38.761   6.225  -7.804  1.00 18.07           O
ATOM    584  N   ARG    71     -37.271   7.614  -8.747  1.00 16.37           N
ATOM    585  CA  ARG    71     -37.312   6.918 -10.054  1.00 16.19           C
ATOM    586  CB  ARG    71     -36.314   7.527 -11.036  1.00 16.11           C
ATOM    587  CG  ARG    71     -36.578   8.965 -11.418  1.00 19.99           C
ATOM    588  CD  ARG    71     -35.754   9.340 -12.654  1.00 23.24           C
ATOM    589  NE  ARG    71     -35.827  10.770 -12.961  1.00 25.78           N
ATOM    590  CZ  ARG    71     -36.850  11.371 -13.583  1.00 28.05           C
ATOM    591  NH1 ARG    71     -37.910  10.665 -13.975  1.00 28.38           N
ATOM    592  NH2 ARG    71     -36.818  12.683 -13.821  1.00 22.66           N
ATOM    593  C   ARG    71     -36.981   5.449  -9.914  1.00 14.93           C
ATOM    594  O   ARG    71     -37.529   4.587 -10.637  1.00 13.88           O
ATOM    595  N   GLY    72     -36.074   5.141  -8.978  1.00 14.49           N
ATOM    596  CA  GLY    72     -35.604   3.763  -8.809  1.00 13.79           C
ATOM    597  C   GLY    72     -36.685   2.791  -8.352  1.00 14.28           C
ATOM    598  O   GLY    72     -36.498   1.596  -8.465  1.00 15.03           O
ATOM    599  N   GLN    73     -37.809   3.316  -7.844  1.00 13.08           N
ATOM    600  CA  GLN    73     -38.965   2.522  -7.381  1.00 13.26           C
ATOM    601  CB  GLN    73     -39.651   3.251  -6.211  1.00 13.37           C
ATOM    602  CG  GLN    73     -38.783   3.419  -4.979  1.00 16.75           C
ATOM    603  CD  GLN    73     -38.147   2.137  -4.546  1.00 21.82           C
ATOM    604  OE1 GLN    73     -38.813   1.105  -4.424  1.00 22.36           O
ATOM    605  NE2 GLN    73     -36.834   2.173  -4.334  1.00 26.08           N
ATOM    606  C   GLN    73     -40.037   2.290  -8.454  1.00 12.89           C
ATOM    607  O   GLN    73     -41.041   1.624  -8.204  1.00 12.88           O
ATOM    608  N   ALA    74     -39.844   2.871  -9.636  1.00 12.26           N
ATOM    609  CA  ALA    74     -40.800   2.693 -10.736  1.00 12.16           C
ATOM    610  CB  ALA    74     -40.216   3.279 -12.015  1.00 12.22           C
ATOM    611  C   ALA    74     -41.152   1.219 -10.951  1.00 12.26           C
ATOM    612  O   ALA    74     -40.261   0.342 -10.903  1.00 11.19           O
ATOM    613  N   GLY    75     -42.429   0.939 -11.235  1.00 11.65           N
ATOM    614  CA  GLY    75     -42.868  -0.466 -11.342  1.00 10.70           C
ATOM    615  C   GLY    75     -43.731  -0.790 -10.118  1.00 11.25           C
ATOM    616  O   GLY    75     -44.484  -1.762 -10.116  1.00 11.59           O
ATOM    617  N   ASP    76     -43.570  -0.008  -9.043  1.00 12.06           N
ATOM    618  CA  ASP    76     -44.360  -0.166  -7.824  1.00 12.36           C
ATOM    619  CB  ASP    76     -43.487  -0.827  -6.733  1.00 12.42           C
ATOM    620  CG  ASP    76     -44.202  -1.022  -5.400  1.00 15.66           C
ATOM    621  OD1 ASP    76     -45.317  -0.484  -5.151  1.00 16.24           O
ATOM    622  OD2 ASP    76     -43.604  -1.751  -4.566  1.00 15.57           O
ATOM    623  C   ASP    76     -44.849   1.223  -7.391  1.00 12.68           C
ATOM    624  O   ASP    76     -44.129   1.931  -6.685  1.00 11.41           O
ATOM    625  N   PRO    77     -46.043   1.647  -7.879  1.00 13.71           N
ATOM    626  CA  PRO    77     -46.488   3.033  -7.645  1.00 13.93           C
ATOM    627  CB  PRO    77     -47.873   3.103  -8.333  1.00 13.23           C
ATOM    628  CG  PRO    77     -47.761   2.072  -9.458  1.00 15.27           C
ATOM    629  CD  PRO    77     -46.977   0.920  -8.766  1.00 14.18           C
ATOM    630  C   PRO    77     -46.533   3.405  -6.182  1.00 13.31           C
ATOM    631  O   PRO    77     -46.184   4.524  -5.838  1.00 13.85           O
ATOM    632  N   LEU    78     -46.946   2.477  -5.319  0.50 13.21           N
ATOM    634  CA  LEU    78     -46.992   2.787  -3.889  0.50 13.74           C
ATOM    636  CB  LEU    78     -47.582   1.617  -3.103  0.50 13.51           C
ATOM    638  CG  LEU    78     -48.457   1.997  -1.907  0.50 14.73           C
ATOM    640  CD1 LEU    78     -49.147   0.741  -1.413  0.50 17.25           C
ATOM    642  CD2 LEU    78     -47.650   2.638  -0.804  0.50 19.04           C
ATOM    644  C   LEU    78     -45.602   3.124  -3.366  0.50 13.01           C
ATOM    646  O   LEU    78     -45.444   4.072  -2.614  0.50 12.86           O
ATOM    648  N   ALA    79     -44.598   2.339  -3.761  1.00 13.15           N
ATOM    649  CA  ALA    79     -43.203   2.602  -3.355  1.00 13.03           C
ATOM    650  CB  ALA    79     -42.284   1.481  -3.789  1.00 13.22           C
ATOM    651  C   ALA    79     -42.705   3.953  -3.901  1.00 12.54           C
ATOM    652  O   ALA    79     -41.949   4.654  -3.228  1.00 12.09           O
ATOM    653  N   VAL    80     -43.099   4.301  -5.131  1.00 11.58           N
ATOM    654  CA  VAL    80     -42.787   5.630  -5.672  1.00 12.21           C
ATOM    655  CB  VAL    80     -43.296   5.773  -7.101  1.00 11.22           C
ATOM    656  CG1 VAL    80     -43.163   7.227  -7.624  1.00 12.32           C
ATOM    657  CG2 VAL    80     -42.538   4.787  -8.035  1.00 10.84           C
ATOM    658  C   VAL    80     -43.376   6.760  -4.777  1.00 13.05           C
ATOM    659  O   VAL    80     -42.668   7.710  -4.420  1.00 13.23           O
ATOM    660  N   MET    81     -44.661   6.646  -4.436  0.70 12.38           N
ATOM    662  CA  MET    81     -45.330   7.668  -3.603  0.70 12.69           C
ATOM    664  CB  MET    81     -46.833   7.394  -3.427  0.70 13.82           C
ATOM    666  CG  MET    81     -47.597   7.155  -4.747  0.70 14.01           C
ATOM    668  SD  MET    81     -47.622   8.670  -5.960  0.70 21.09          SE
ATOM    670  CE  MET    81     -47.084   7.612  -7.496  0.70 15.28           C
ATOM    672  C   MET    81     -44.684   7.771  -2.235  0.70 13.11           C
ATOM    674  O   MET    81     -44.538   8.886  -1.698  0.70 12.95           O
ATOM    676  N   THR    82     -44.336   6.621  -1.655  1.00 11.97           N
ATOM    677  CA  THR    82     -43.690   6.575  -0.342  1.00 13.13           C
ATOM    678  CB  THR    82     -43.605   5.113   0.176  1.00 12.76           C
ATOM    679  OG1 THR    82     -44.931   4.563   0.297  1.00 13.08           O
ATOM    680  CG2 THR    82     -42.926   5.051   1.546  1.00 12.65           C
ATOM    681  C   THR    82     -42.311   7.220  -0.401  1.00 12.27           C
ATOM    682  O   THR    82     -41.988   8.047   0.443  1.00 12.09           O
ATOM    683  N   ALA    83     -41.522   6.874  -1.419  1.00 12.10           N
ATOM    684  CA  ALA    83     -40.189   7.455  -1.613  1.00 12.71           C
ATOM    685  CB  ALA    83     -39.469   6.804  -2.772  1.00 13.64           C
ATOM    686  C   ALA    83     -40.256   8.962  -1.829  1.00 13.31           C
ATOM    687  O   ALA    83     -39.424   9.717  -1.293  1.00 13.65           O
ATOM    688  N   TYR    84     -41.234   9.393  -2.621  1.00 12.01           N
ATOM    689  CA  TYR    84     -41.450  10.829  -2.827  1.00 11.80           C
ATOM    690  CB  TYR    84     -42.626  11.070  -3.785  1.00 11.47           C
ATOM    691  CG  TYR    84     -43.055  12.503  -3.698  1.00 11.01           C
ATOM    692  CD1 TYR    84     -42.230  13.514  -4.207  1.00  9.70           C
ATOM    693  CE1 TYR    84     -42.562  14.853  -4.058  1.00  7.72           C
ATOM    694  CZ  TYR    84     -43.777  15.207  -3.416  1.00  9.90           C
ATOM    695  OH  TYR    84     -44.090  16.520  -3.245  1.00  9.60           O
ATOM    696  CE2 TYR    84     -44.606  14.228  -2.886  1.00 10.03           C
ATOM    697  CD2 TYR    84     -44.241  12.867  -3.033  1.00  8.93           C
ATOM    698  C   TYR    84     -41.702  11.542  -1.464  1.00 11.96           C
ATOM    699  O   TYR    84     -41.113  12.588  -1.195  1.00 11.13           O
ATOM    700  N   LEU    85     -42.594  11.008  -0.646  1.00 10.86           N
ATOM    701  CA  LEU    85     -42.868  11.627   0.683  1.00 10.85           C
ATOM    702  CB  LEU    85     -44.003  10.908   1.396  1.00 10.34           C
ATOM    703  CG  LEU    85     -45.392  11.039   0.735  1.00 11.08           C
ATOM    704  CD1 LEU    85     -46.412  10.164   1.470  1.00 14.10           C
ATOM    705  CD2 LEU    85     -45.840  12.513   0.824  1.00 11.81           C
ATOM    706  C   LEU    85     -41.608  11.688   1.547  1.00 10.59           C
ATOM    707  O   LEU    85     -41.299  12.737   2.160  1.00  9.89           O
ATOM    708  N   ARG    86     -40.890  10.577   1.613  1.00 11.70           N
ATOM    709  CA  ARG    86     -39.686  10.504   2.430  1.00 12.21           C
ATOM    710  CB  ARG    86     -39.118   9.092   2.407  1.00 13.48           C
ATOM    711  CG  ARG    86     -38.070   8.880   3.462  1.00 16.80           C
ATOM    712  CD  ARG    86     -37.752   7.377   3.627  1.00 18.02           C
ATOM    713  NE  ARG    86     -38.810   6.676   4.350  1.00 20.50           N
ATOM    714  CZ  ARG    86     -39.556   5.706   3.833  1.00 23.33           C
ATOM    715  NH1 ARG    86     -39.354   5.300   2.584  1.00 26.93           N
ATOM    716  NH2 ARG    86     -40.472   5.111   4.589  1.00 24.38           N
ATOM    717  C   ARG    86     -38.635  11.526   1.947  1.00 11.94           C
ATOM    718  O   ARG    86     -37.985  12.202   2.764  1.00 11.86           O
ATOM    719  N   TRP    87     -38.462  11.595   0.637  1.00 11.06           N
ATOM    720  CA  TRP    87     -37.511  12.517   0.011  1.00 11.54           C
ATOM    721  CB  TRP    87     -37.513  12.276  -1.518  1.00 11.78           C
ATOM    722  CG  TRP    87     -36.670  13.219  -2.336  1.00 11.45           C
ATOM    723  CD1 TRP    87     -35.298  13.232  -2.473  1.00 12.95           C
ATOM    724  NE1 TRP    87     -34.914  14.228  -3.355  1.00 11.75           N
ATOM    725  CE2 TRP    87     -36.041  14.867  -3.805  1.00 12.69           C
ATOM    726  CD2 TRP    87     -37.162  14.253  -3.195  1.00 12.32           C
ATOM    727  CE3 TRP    87     -38.448  14.715  -3.505  1.00 13.71           C
ATOM    728  CZ3 TRP    87     -38.582  15.767  -4.386  1.00 13.30           C
ATOM    729  CH2 TRP    87     -37.436  16.377  -4.989  1.00 14.32           C
ATOM    730  CZ2 TRP    87     -36.166  15.944  -4.703  1.00 14.12           C
ATOM    731  C   TRP    87     -37.904  13.972   0.307  1.00 11.68           C
ATOM    732  O   TRP    87     -37.046  14.801   0.617  1.00 11.77           O
ATOM    733  N   THR    88     -39.191  14.280   0.183  1.00 11.01           N
ATOM    734  CA  THR    88     -39.685  15.654   0.390  1.00 11.22           C
ATOM    735  CB  THR    88     -41.147  15.790  -0.053  1.00 12.10           C
ATOM    736  OG1 THR    88     -41.220  15.503  -1.460  1.00 12.19           O
ATOM    737  CG2 THR    88     -41.678  17.220   0.199  1.00 12.36           C
ATOM    738  C   THR    88     -39.498  16.086   1.853  1.00 10.14           C
ATOM    739  O   THR    88     -39.045  17.207   2.119  1.00  9.63           O
ATOM    740  N   ILE    89     -39.826  15.192   2.778  1.00 10.71           N
ATOM    741  CA  ILE    89     -39.609  15.477   4.191  1.00 11.44           C
ATOM    742  CB  ILE    89     -40.178  14.352   5.067  1.00 11.62           C
ATOM    743  CG1 ILE    89     -41.718  14.377   4.949  1.00 10.67           C
ATOM    744  CD1 ILE    89     -42.368  13.154   5.612  1.00 14.32           C
ATOM    745  CG2 ILE    89     -39.752  14.574   6.521  1.00  9.76           C
ATOM    746  C   ILE    89     -38.108  15.719   4.470  1.00 11.65           C
ATOM    747  O   ILE    89     -37.748  16.702   5.123  1.00 10.49           O
ATOM    748  N   GLN    90     -37.253  14.832   3.946  0.60 11.78           N
ATOM    750  CA  GLN    90     -35.805  15.009   4.058  0.60 12.90           C
ATOM    752  CB  GLN    90     -35.059  13.906   3.294  0.60 13.23           C
ATOM    754  CG  GLN    90     -33.581  13.882   3.617  0.60 18.71           C
ATOM    756  CD  GLN    90     -33.320  13.696   5.114  0.60 24.36           C
ATOM    758  OE1 GLN    90     -32.857  14.615   5.797  0.60 28.60           O
ATOM    760  NE2 GLN    90     -33.626  12.502   5.631  0.60 27.22           N
ATOM    762  C   GLN    90     -35.349  16.402   3.563  0.60 12.09           C
ATOM    764  O   GLN    90     -34.599  17.104   4.235  0.60 11.76           O
ATOM    766  N   ARG    91     -35.849  16.798   2.401  1.00 12.06           N
ATOM    767  CA  ARG    91     -35.481  18.070   1.792  1.00 11.96           C
ATOM    768  CB  ARG    91     -36.237  18.253   0.485  1.00 13.06           C
ATOM    769  CG  ARG    91     -35.579  17.519  -0.624  1.00 17.79           C
ATOM    770  CD  ARG    91     -36.116  18.032  -1.972  1.00 20.49           C
ATOM    771  NE  ARG    91     -37.524  17.695  -2.235  1.00 21.73           N
ATOM    772  CZ  ARG    91     -38.542  18.563  -2.176  1.00 22.41           C
ATOM    773  NH1 ARG    91     -39.778  18.166  -2.519  1.00 18.87           N
ATOM    774  NH2 ARG    91     -38.328  19.821  -1.792  1.00 17.44           N
ATOM    775  C   ARG    91     -35.787  19.210   2.737  1.00 11.92           C
ATOM    776  O   ARG    91     -34.954  20.120   2.929  1.00 11.63           O
ATOM    777  N   HIS    92     -36.985  19.171   3.324  1.00 11.45           N
ATOM    778  CA  HIS    92     -37.369  20.231   4.257  1.00 12.36           C
ATOM    779  CB  HIS    92     -38.873  20.203   4.534  1.00 13.78           C
ATOM    780  CG  HIS    92     -39.696  20.557   3.336  1.00 14.40           C
ATOM    781  ND1 HIS    92     -39.591  21.777   2.684  1.00 19.47           N
ATOM    782  CE1 HIS    92     -40.452  21.801   1.674  1.00 21.35           C
ATOM    783  NE2 HIS    92     -41.103  20.649   1.649  1.00 16.69           N
ATOM    784  CD2 HIS    92     -40.635  19.846   2.660  1.00 16.03           C
ATOM    785  C   HIS    92     -36.565  20.215   5.544  1.00 12.15           C
ATOM    786  O   HIS    92     -36.192  21.268   6.056  1.00 11.95           O
ATOM    787  N   ARG    93     -36.254  19.030   6.054  1.00 11.79           N
ATOM    788  CA  ARG    93     -35.455  18.958   7.286  1.00 12.70           C
ATOM    789  CB  ARG    93     -35.461  17.537   7.853  1.00 12.66           C
ATOM    790  CG  ARG    93     -36.858  17.020   8.266  1.00 13.84           C
ATOM    791  CD  ARG    93     -37.401  17.762   9.453  1.00 18.09           C
ATOM    792  NE  ARG    93     -38.685  17.215   9.878  1.00 17.47           N
ATOM    793  CZ  ARG    93     -39.526  17.858  10.676  1.00 16.59           C
ATOM    794  NH1 ARG    93     -39.223  19.072  11.110  1.00 17.37           N
ATOM    795  NH2 ARG    93     -40.666  17.281  11.023  1.00 15.53           N
ATOM    796  C   ARG    93     -34.025  19.435   7.057  1.00 13.20           C
ATOM    797  O   ARG    93     -33.450  20.125   7.905  1.00 15.46           O
ATOM    798  N   ASN    94     -33.459  19.087   5.914  1.00 12.51           N
ATOM    799  CA  ASN    94     -32.101  19.512   5.580  1.00 14.01           C
ATOM    800  CB  ASN    94     -31.566  18.704   4.408  1.00 15.34           C
ATOM    801  CG  ASN    94     -31.380  17.226   4.724  1.00 18.74           C
ATOM    802  OD1 ASN    94     -31.130  16.441   3.813  1.00 27.63           O
ATOM    803  ND2 ASN    94     -31.508  16.841   5.986  1.00 22.90           N
ATOM    804  C   ASN    94     -32.010  20.978   5.199  1.00 13.91           C
ATOM    805  O   ASN    94     -30.942  21.582   5.307  1.00 12.63           O
ATOM    806  N   ASN    95     -33.118  21.549   4.732  1.00 13.29           N
ATOM    807  CA  ASN    95     -33.111  22.936   4.270  1.00 15.16           C
ATOM    808  CB  ASN    95     -32.967  23.054   2.763  1.00 16.24           C
ATOM    809  CG  ASN    95     -32.773  24.515   2.339  1.00 19.00           C
ATOM    810  OD1 ASN    95     -32.538  25.397   3.185  1.00 16.84           O
ATOM    811  ND2 ASN    95     -32.897  24.782   1.041  1.00 21.24           N
ATOM    812  C   ASN    95     -34.330  23.717   4.692  1.00 15.67           C
ATOM    813  O   ASN    95     -35.314  23.831   3.936  1.00 15.80           O
ATOM    814  N   PRO    96     -34.271  24.260   5.900  1.00 16.89           N
ATOM    815  CA  PRO    96     -35.322  25.100   6.460  1.00 18.18           C
ATOM    816  CB  PRO    96     -34.732  25.555   7.802  1.00 18.94           C
ATOM    817  CG  PRO    96     -33.729  24.472   8.148  1.00 19.40           C
ATOM    818  CD  PRO    96     -33.147  24.066   6.837  1.00 17.29           C
ATOM    819  C   PRO    96     -35.602  26.309   5.578  1.00 17.64           C
ATOM    820  O   PRO    96     -36.688  26.843   5.668  1.00 20.08           O
ATOM    821  N   GLN    97     -34.664  26.718   4.721  1.00 17.55           N
ATOM    822  CA  GLN    97     -34.882  27.924   3.884  1.00 16.15           C
ATOM    823  CB  GLN    97     -33.556  28.526   3.375  1.00 18.11           C
ATOM    824  CG  GLN    97     -32.586  28.997   4.445  1.00 21.27           C
ATOM    825  CD  GLN    97     -32.986  30.332   5.097  1.00 25.68           C
ATOM    826  OE1 GLN    97     -34.153  30.593   5.335  1.00 27.40           O
ATOM    827  NE2 GLN    97     -32.009  31.165   5.381  1.00 27.04           N
ATOM    828  C   GLN    97     -35.744  27.610   2.655  1.00 14.78           C
ATOM    829  O   GLN    97     -36.230  28.506   1.960  1.00 11.98           O
ATOM    830  N   LEU    98     -35.901  26.333   2.335  1.00 12.64           N
ATOM    831  CA  LEU    98     -36.399  26.054   0.980  1.00 12.07           C
ATOM    832  CB  LEU    98     -36.223  24.576   0.576  1.00 12.25           C
ATOM    833  CG  LEU    98     -36.864  24.142  -0.779  1.00 13.48           C
ATOM    834  CD1 LEU    98     -36.177  24.694  -2.050  1.00 15.69           C
ATOM    835  CD2 LEU    98     -36.865  22.621  -0.848  1.00 15.12           C
ATOM    836  C   LEU    98     -37.808  26.609   0.762  1.00  9.66           C
ATOM    837  O   LEU    98     -38.058  27.231  -0.286  1.00  9.22           O
ATOM    838  N   LEU    99     -38.723  26.475   1.724  1.00  9.90           N
ATOM    839  CA  LEU    99     -40.096  26.921   1.392  1.00 10.68           C
ATOM    840  CB  LEU    99     -41.134  26.482   2.475  1.00 11.84           C
ATOM    841  CG  LEU    99     -41.720  25.109   2.218  1.00 12.27           C
ATOM    842  CD1 LEU    99     -42.546  24.691   3.463  1.00 16.86           C
ATOM    843  CD2 LEU    99     -42.530  24.990   0.943  1.00 14.59           C
ATOM    844  C   LEU    99     -40.166  28.414   1.244  1.00 10.51           C
ATOM    845  O   LEU    99     -41.036  28.919   0.576  1.00 11.22           O
ATOM    846  N   ARG   100     -39.232  29.138   1.869  1.00  8.91           N
ATOM    847  CA  ARG   100     -39.171  30.614   1.637  1.00 10.19           C
ATOM    848  CB  ARG   100     -38.051  31.233   2.443  1.00  9.36           C
ATOM    849  CG  ARG   100     -38.293  31.279   3.923  1.00 12.57           C
ATOM    850  CD  ARG   100     -37.117  31.919   4.691  1.00 14.26           C
ATOM    851  NE  ARG   100     -37.502  32.131   6.084  1.00 21.03           N
ATOM    852  CZ  ARG   100     -36.662  32.254   7.102  1.00 26.22           C
ATOM    853  NH1 ARG   100     -35.340  32.191   6.906  1.00 25.30           N
ATOM    854  NH2 ARG   100     -37.156  32.455   8.326  1.00 30.04           N
ATOM    855  C   ARG   100     -38.944  30.908   0.135  1.00  9.56           C
ATOM    856  O   ARG   100     -39.737  31.609  -0.479  1.00  9.17           O
ATOM    857  N   PHE   101     -37.894  30.333  -0.451  1.00  8.88           N
ATOM    858  CA  PHE   101     -37.584  30.586  -1.861  1.00  7.74           C
ATOM    859  CB  PHE   101     -36.227  29.979  -2.191  1.00  9.07           C
ATOM    860  CG  PHE   101     -35.072  30.718  -1.553  1.00  8.31           C
ATOM    861  CD1 PHE   101     -34.572  31.865  -2.155  1.00  9.65           C
ATOM    862  CE1 PHE   101     -33.460  32.577  -1.586  1.00 12.39           C
ATOM    863  CZ  PHE   101     -32.856  32.079  -0.434  1.00 11.45           C
ATOM    864  CE2 PHE   101     -33.351  30.895   0.160  1.00 13.90           C
ATOM    865  CD2 PHE   101     -34.452  30.220  -0.416  1.00 11.33           C
ATOM    866  C   PHE   101     -38.651  29.978  -2.784  1.00  8.41           C
ATOM    867  O   PHE   101     -39.040  30.587  -3.776  1.00  8.06           O
ATOM    868  N   TYR   102     -39.122  28.777  -2.420  1.00  7.06           N
ATOM    869  CA  TYR   102     -40.068  28.027  -3.247  1.00  7.90           C
ATOM    870  CB  TYR   102     -40.262  26.695  -2.548  1.00  7.79           C
ATOM    871  CG  TYR   102     -41.077  25.629  -3.236  1.00  8.54           C
ATOM    872  CD1 TYR   102     -42.489  25.656  -3.181  1.00 10.03           C
ATOM    873  CE1 TYR   102     -43.257  24.599  -3.766  1.00 11.63           C
ATOM    874  CZ  TYR   102     -42.610  23.511  -4.376  1.00 11.76           C
ATOM    875  OH  TYR   102     -43.341  22.459  -4.924  1.00 11.14           O
ATOM    876  CE2 TYR   102     -41.192  23.459  -4.417  1.00  9.45           C
ATOM    877  CD2 TYR   102     -40.447  24.510  -3.827  1.00 10.19           C
ATOM    878  C   TYR   102     -41.394  28.796  -3.351  1.00  8.00           C
ATOM    879  O   TYR   102     -41.879  29.032  -4.458  1.00  9.22           O
ATOM    880  N   THR   103     -41.935  29.239  -2.212  1.00  8.23           N
ATOM    881  CA  THR   103     -43.186  30.012  -2.256  1.00  8.10           C
ATOM    882  CB  THR   103     -43.885  30.125  -0.875  1.00  7.33           C
ATOM    883  OG1 THR   103     -43.012  30.781   0.056  1.00  8.06           O
ATOM    884  CG2 THR   103     -44.249  28.714  -0.376  1.00  8.46           C
ATOM    885  C   THR   103     -43.009  31.397  -2.842  1.00  8.57           C
ATOM    886  O   THR   103     -43.909  31.869  -3.557  1.00  9.60           O
ATOM    887  N   SER   104     -41.877  32.052  -2.541  1.00  9.12           N
ATOM    888  CA  SER   104     -41.655  33.400  -3.043  1.00  9.88           C
ATOM    889  CB  SER   104     -40.363  34.009  -2.477  1.00  9.85           C
ATOM    890  OG  SER   104     -40.234  35.352  -2.971  1.00 12.21           O
ATOM    891  C   SER   104     -41.601  33.357  -4.584  1.00 10.66           C
ATOM    892  O   SER   104     -42.219  34.183  -5.265  1.00 10.59           O
ATOM    893  N   GLU   105     -40.865  32.392  -5.125  1.00  8.72           N
ATOM    894  CA  GLU   105     -40.817  32.289  -6.613  1.00  9.18           C
ATOM    895  CB  GLU   105     -39.731  31.293  -7.041  1.00  7.45           C
ATOM    896  CG  GLU   105     -38.332  31.924  -6.972  1.00  8.14           C
ATOM    897  CD  GLU   105     -38.036  32.910  -8.131  1.00 10.19           C
ATOM    898  OE1 GLU   105     -38.853  33.093  -9.071  1.00  9.04           O
ATOM    899  OE2 GLU   105     -36.931  33.505  -8.111  1.00 13.04           O
ATOM    900  C   GLU   105     -42.165  31.935  -7.261  1.00  9.12           C
ATOM    901  O   GLU   105     -42.538  32.491  -8.300  1.00  9.81           O
ATOM    902  N   LEU   106     -42.941  31.042  -6.632  1.00  8.79           N
ATOM    903  CA  LEU   106     -44.237  30.680  -7.191  1.00  9.03           C
ATOM    904  CB  LEU   106     -44.849  29.471  -6.457  1.00  8.32           C
ATOM    905  CG  LEU   106     -44.211  28.130  -6.911  1.00  9.60           C
ATOM    906  CD1 LEU   106     -44.576  27.033  -5.828  1.00  9.04           C
ATOM    907  CD2 LEU   106     -44.754  27.786  -8.296  1.00  9.22           C
ATOM    908  C   LEU   106     -45.238  31.834  -7.135  1.00  9.88           C
ATOM    909  O   LEU   106     -46.147  31.887  -7.972  1.00 10.21           O
ATOM    910  N   THR   107     -45.102  32.717  -6.136  1.00  9.52           N
ATOM    911  CA  THR   107     -46.030  33.832  -5.986  1.00  9.75           C
ATOM    912  CB  THR   107     -46.510  33.990  -4.516  1.00  9.09           C
ATOM    913  OG1 THR   107     -45.388  34.319  -3.693  1.00 10.50           O
ATOM    914  CG2 THR   107     -47.185  32.718  -4.076  1.00 10.05           C
ATOM    915  C   THR   107     -45.544  35.182  -6.484  1.00  9.81           C
ATOM    916  O   THR   107     -46.371  36.081  -6.704  1.00 12.25           O
ATOM    917  N   ASN   108     -44.232  35.363  -6.633  0.50  9.70           N
ATOM    919  CA  ASN   108     -43.617  36.625  -7.105  0.50  9.59           C
ATOM    921  CB  ASN   108     -43.154  37.511  -5.932  0.50  9.99           C
ATOM    923  CG  ASN   108     -44.278  38.322  -5.314  0.50  8.07           C
ATOM    925  OD1 ASN   108     -44.577  38.166  -4.138  0.50 11.45           O
ATOM    927  ND2 ASN   108     -44.931  39.160  -6.116  0.50  6.17           N
ATOM    929  C   ASN   108     -42.392  36.215  -7.909  0.50  9.86           C
ATOM    931  O   ASN   108     -41.262  36.429  -7.469  0.50  9.46           O
ATOM    933  N   PRO   109     -42.611  35.593  -9.087  1.00  9.87           N
ATOM    934  CA  PRO   109     -41.482  34.997  -9.847  1.00  9.20           C
ATOM    935  CB  PRO   109     -42.170  34.338 -11.060  1.00  9.29           C
ATOM    936  CG  PRO   109     -43.456  35.217 -11.249  1.00 11.47           C
ATOM    937  CD  PRO   109     -43.900  35.416  -9.770  1.00 10.72           C
ATOM    938  C   PRO   109     -40.455  36.039 -10.322  1.00  9.60           C
ATOM    939  O   PRO   109     -40.811  37.205 -10.612  1.00 11.09           O
ATOM    940  N   THR   110     -39.210  35.615 -10.382  1.00  9.05           N
ATOM    941  CA  THR   110     -38.133  36.378 -11.039  1.00  9.32           C
ATOM    942  CB  THR   110     -36.862  36.356 -10.160  1.00 10.57           C
ATOM    943  OG1 THR   110     -36.330  35.035 -10.130  1.00  9.30           O
ATOM    944  CG2 THR   110     -37.147  36.832  -8.744  1.00 13.98           C
ATOM    945  C   THR   110     -37.799  35.644 -12.327  1.00  8.94           C
ATOM    946  O   THR   110     -38.429  34.643 -12.626  1.00  8.35           O
ATOM    947  N   PRO   111     -36.818  36.119 -13.123  1.00  9.83           N
ATOM    948  CA  PRO   111     -36.366  35.317 -14.286  1.00 11.52           C
ATOM    949  CB  PRO   111     -35.231  36.183 -14.892  1.00 11.75           C
ATOM    950  CG  PRO   111     -35.579  37.539 -14.489  1.00 11.98           C
ATOM    951  CD  PRO   111     -36.150  37.430 -13.076  1.00 10.83           C
ATOM    952  C   PRO   111     -35.863  33.915 -13.908  1.00 12.86           C
ATOM    953  O   PRO   111     -35.889  32.963 -14.744  1.00 13.75           O
ATOM    954  N   CYS   112     -35.461  33.730 -12.660  1.00 11.46           N
ATOM    955  CA  CYS   112     -35.067  32.401 -12.254  1.00 13.19           C
ATOM    956  CB  CYS   112     -34.230  32.442 -10.978  1.00 14.56           C
ATOM    957  SG  CYS   112     -32.686  33.333 -11.290  1.00 18.40           S
ATOM    958  C   CYS   112     -36.251  31.432 -12.108  1.00 12.18           C
ATOM    959  O   CYS   112     -36.048  30.232 -11.974  1.00 13.79           O
ATOM    960  N   PHE   113     -37.501  31.926 -12.121  1.00 11.58           N
ATOM    961  CA  PHE   113     -38.605  30.987 -11.961  1.00 10.29           C
ATOM    962  CB  PHE   113     -39.921  31.711 -11.869  1.00 10.73           C
ATOM    963  CG  PHE   113     -41.068  30.776 -11.807  1.00 10.75           C
ATOM    964  CD1 PHE   113     -41.318  30.025 -10.649  1.00 13.13           C
ATOM    965  CE1 PHE   113     -42.390  29.092 -10.649  1.00 14.20           C
ATOM    966  CZ  PHE   113     -43.135  28.878 -11.780  1.00 12.39           C
ATOM    967  CE2 PHE   113     -42.909  29.606 -12.931  1.00 14.70           C
ATOM    968  CD2 PHE   113     -41.824  30.539 -12.957  1.00 11.87           C
ATOM    969  C   PHE   113     -38.634  30.035 -13.180  1.00  9.81           C
ATOM    970  O   PHE   113     -38.642  28.807 -13.017  1.00  9.92           O
ATOM    971  N   ALA   114     -38.644  30.592 -14.383  1.00  9.60           N
ATOM    972  CA  ALA   114     -38.711  29.716 -15.565  1.00  9.88           C
ATOM    973  CB  ALA   114     -38.980  30.528 -16.837  1.00  9.97           C
ATOM    974  C   ALA   114     -37.461  28.865 -15.730  1.00 10.92           C
ATOM    975  O   ALA   114     -37.548  27.764 -16.247  1.00 11.21           O
ATOM    976  N   ALA   115     -36.301  29.407 -15.342  1.00 10.45           N
ATOM    977  CA  ALA   115     -35.020  28.733 -15.554  1.00 11.81           C
ATOM    978  CB  ALA   115     -33.882  29.767 -15.520  1.00 12.14           C
ATOM    979  C   ALA   115     -34.750  27.588 -14.574  1.00 11.95           C
ATOM    980  O   ALA   115     -34.178  26.555 -14.951  1.00 12.70           O
ATOM    981  N   ILE   116     -35.186  27.750 -13.331  1.00 11.04           N
ATOM    982  CA  ILE   116     -34.783  26.848 -12.255  1.00 11.69           C
ATOM    983  CB  ILE   116     -33.872  27.616 -11.214  1.00 10.98           C
ATOM    984  CG1 ILE   116     -32.584  28.106 -11.900  1.00 13.37           C
ATOM    985  CD1 ILE   116     -31.751  29.071 -11.039  1.00 12.57           C
ATOM    986  CG2 ILE   116     -33.568  26.724  -9.962  1.00 12.49           C
ATOM    987  C   ILE   116     -35.998  26.242 -11.560  1.00 11.29           C
ATOM    988  O   ILE   116     -36.092  25.007 -11.384  1.00 10.24           O
ATOM    989  N   VAL   117     -36.919  27.089 -11.131  1.00 10.95           N
ATOM    990  CA  VAL   117     -37.977  26.588 -10.206  1.00 10.57           C
ATOM    991  CB  VAL   117     -38.617  27.751  -9.409  1.00 11.02           C
ATOM    992  CG1 VAL   117     -39.795  27.207  -8.454  1.00 10.64           C
ATOM    993  CG2 VAL   117     -37.512  28.443  -8.627  1.00 10.50           C
ATOM    994  C   VAL   117     -39.038  25.771 -10.946  1.00 11.77           C
ATOM    995  O   VAL   117     -39.425  24.648 -10.524  1.00 11.14           O
ATOM    996  N   SER   118     -39.530  26.315 -12.046  1.00 10.59           N
ATOM    997  CA  SER   118     -40.620  25.684 -12.764  1.00 12.47           C
ATOM    998  CB  SER   118     -41.105  26.636 -13.868  1.00 13.39           C
ATOM    999  OG  SER   118     -42.255  26.127 -14.471  1.00 14.41           O
ATOM   1000  C   SER   118     -40.234  24.283 -13.285  1.00 11.92           C
ATOM   1001  O   SER   118     -40.958  23.318 -13.010  1.00 12.39           O
ATOM   1002  N   PRO   119     -39.094  24.138 -13.988  1.00 12.64           N
ATOM   1003  CA  PRO   119     -38.727  22.800 -14.461  1.00 11.77           C
ATOM   1004  CB  PRO   119     -37.448  23.016 -15.304  1.00 12.21           C
ATOM   1005  CG  PRO   119     -36.981  24.375 -14.981  1.00 12.76           C
ATOM   1006  CD  PRO   119     -38.161  25.180 -14.467  1.00 11.90           C
ATOM   1007  C   PRO   119     -38.487  21.799 -13.296  1.00 11.38           C
ATOM   1008  O   PRO   119     -38.822  20.622 -13.450  1.00 11.44           O
ATOM   1009  N   ALA   120     -37.965  22.276 -12.162  1.00 10.79           N
ATOM   1010  CA  ALA   120     -37.680  21.404 -10.992  1.00  9.96           C
ATOM   1011  CB  ALA   120     -36.955  22.202  -9.916  1.00 10.33           C
ATOM   1012  C   ALA   120     -38.996  20.843 -10.478  1.00 11.25           C
ATOM   1013  O   ALA   120     -39.179  19.606 -10.381  1.00 11.32           O
ATOM   1014  N   ILE   121     -39.972  21.731 -10.240  1.00  9.92           N
ATOM   1015  CA  ILE   121     -41.278  21.275  -9.739  1.00 10.42           C
ATOM   1016  CB  ILE   121     -42.191  22.482  -9.354  1.00  9.91           C
ATOM   1017  CG1 ILE   121     -41.576  23.223  -8.147  1.00 11.53           C
ATOM   1018  CD1 ILE   121     -42.273  24.600  -7.882  1.00 11.61           C
ATOM   1019  CG2 ILE   121     -43.657  22.039  -9.082  1.00 11.13           C
ATOM   1020  C   ILE   121     -41.980  20.382 -10.790  1.00 10.00           C
ATOM   1021  O   ILE   121     -42.496  19.302 -10.444  1.00 10.24           O
ATOM   1022  N   ALA   122     -41.999  20.822 -12.047  1.00 10.30           N
ATOM   1023  CA  ALA   122     -42.680  20.050 -13.108  1.00 11.54           C
ATOM   1024  CB  ALA   122     -42.598  20.755 -14.509  1.00 12.24           C
ATOM   1025  C   ALA   122     -42.094  18.638 -13.234  1.00 11.86           C
ATOM   1026  O   ALA   122     -42.845  17.702 -13.488  1.00 12.38           O
ATOM   1027  N   SER   123     -40.780  18.499 -13.132  1.00 11.72           N
ATOM   1028  CA  SER   123     -40.140  17.174 -13.297  1.00 11.69           C
ATOM   1029  CB  SER   123     -38.597  17.220 -13.248  1.00 13.37           C
ATOM   1030  OG  SER   123     -38.136  17.620 -11.957  1.00 18.01           O
ATOM   1031  C   SER   123     -40.678  16.217 -12.222  1.00 11.56           C
ATOM   1032  O   SER   123     -40.889  15.041 -12.504  1.00 11.30           O
ATOM   1033  N   VAL   124     -40.862  16.719 -10.996  1.00 10.19           N
ATOM   1034  CA  VAL   124     -41.338  15.876  -9.883  1.00  9.66           C
ATOM   1035  CB  VAL   124     -41.121  16.603  -8.497  1.00 10.39           C
ATOM   1036  CG1 VAL   124     -41.817  15.860  -7.384  1.00 13.37           C
ATOM   1037  CG2 VAL   124     -39.640  16.694  -8.191  1.00 12.44           C
ATOM   1038  C   VAL   124     -42.808  15.523 -10.075  1.00 10.08           C
ATOM   1039  O   VAL   124     -43.218  14.350  -9.905  1.00  9.51           O
ATOM   1040  N   ILE   125     -43.617  16.526 -10.409  1.00  9.88           N
ATOM   1041  CA  ILE   125     -45.046  16.301 -10.630  1.00 10.74           C
ATOM   1042  CB  ILE   125     -45.803  17.624 -10.870  1.00 11.75           C
ATOM   1043  CG1 ILE   125     -45.744  18.498  -9.590  1.00  9.55           C
ATOM   1044  CD1 ILE   125     -46.274  17.830  -8.232  1.00 11.11           C
ATOM   1045  CG2 ILE   125     -47.298  17.363 -11.280  1.00 10.72           C
ATOM   1046  C   ILE   125     -45.254  15.309 -11.757  1.00 10.24           C
ATOM   1047  O   ILE   125     -46.088  14.386 -11.644  1.00 10.73           O
ATOM   1048  N   ARG   126     -44.483  15.459 -12.837  0.50 10.47           N
ATOM   1050  CA  ARG   126     -44.567  14.514 -13.947  0.50  9.91           C
ATOM   1052  CB  ARG   126     -43.607  14.907 -15.078  0.50  9.78           C
ATOM   1054  CG  ARG   126     -44.070  16.073 -15.874  0.50  8.97           C
ATOM   1056  CD  ARG   126     -43.145  16.305 -17.083  0.50 11.78           C
ATOM   1058  NE  ARG   126     -43.524  17.541 -17.757  0.50 13.41           N
ATOM   1060  CZ  ARG   126     -42.784  18.643 -17.773  0.50 18.19           C
ATOM   1062  NH1 ARG   126     -41.594  18.649 -17.187  0.50 18.32           N
ATOM   1064  NH2 ARG   126     -43.223  19.729 -18.401  0.50 20.28           N
ATOM   1066  C   ARG   126     -44.269  13.104 -13.483  0.50 10.39           C
ATOM   1068  O   ARG   126     -45.010  12.161 -13.806  0.50 11.26           O
ATOM   1070  N   LEU   127     -43.191  12.959 -12.717  1.00 10.18           N
ATOM   1071  CA  LEU   127     -42.747  11.653 -12.281  1.00 11.49           C
ATOM   1072  CB  LEU   127     -41.457  11.792 -11.470  1.00 12.45           C
ATOM   1073  CG  LEU   127     -40.836  10.551 -10.872  1.00 15.70           C
ATOM   1074  CD1 LEU   127     -40.489   9.503 -11.921  1.00 20.81           C
ATOM   1075  CD2 LEU   127     -39.573  10.988 -10.121  1.00 18.67           C
ATOM   1076  C   LEU   127     -43.864  10.955 -11.482  1.00  9.91           C
ATOM   1077  O   LEU   127     -44.173   9.757 -11.684  1.00 10.50           O
ATOM   1078  N   LEU   128     -44.458  11.703 -10.559  1.00  8.79           N
ATOM   1079  CA  LEU   128     -45.555  11.167  -9.751  1.00  9.28           C
ATOM   1080  CB  LEU   128     -45.959  12.213  -8.701  1.00  9.38           C
ATOM   1081  CG  LEU   128     -44.895  12.460  -7.628  1.00 11.13           C
ATOM   1082  CD1 LEU   128     -45.399  13.599  -6.743  1.00 11.82           C
ATOM   1083  CD2 LEU   128     -44.635  11.243  -6.755  1.00 13.49           C
ATOM   1084  C   LEU   128     -46.755  10.814 -10.630  1.00 10.57           C
ATOM   1085  O   LEU   128     -47.393   9.762 -10.464  1.00  8.87           O
ATOM   1086  N   ALA   129     -47.111  11.725 -11.531  1.00  9.99           N
ATOM   1087  CA  ALA   129     -48.264  11.513 -12.419  1.00 10.43           C
ATOM   1088  CB  ALA   129     -48.466  12.756 -13.298  1.00 10.04           C
ATOM   1089  C   ALA   129     -48.072  10.270 -13.290  1.00  9.53           C
ATOM   1090  O   ALA   129     -49.010   9.490 -13.509  1.00  9.22           O
ATOM   1091  N   GLU   130     -46.842  10.075 -13.777  1.00 10.54           N
ATOM   1092  CA  GLU   130     -46.555   8.883 -14.586  1.00 10.65           C
ATOM   1093  CB  GLU   130     -45.130   8.957 -15.080  1.00 11.71           C
ATOM   1094  CG  GLU   130     -45.015   9.922 -16.236  1.00 15.98           C
ATOM   1095  CD  GLU   130     -43.548  10.268 -16.577  1.00 25.12           C
ATOM   1096  OE1 GLU   130     -42.602   9.684 -15.991  1.00 26.80           O
ATOM   1097  OE2 GLU   130     -43.362  11.157 -17.432  1.00 30.61           O
ATOM   1098  C   GLU   130     -46.799   7.589 -13.828  1.00 10.74           C
ATOM   1099  O   GLU   130     -47.364   6.626 -14.382  1.00  9.75           O
ATOM   1100  N   SER   131     -46.395   7.580 -12.558  0.50 10.14           N
ATOM   1102  CA  SER   131     -46.583   6.411 -11.722  0.50 10.49           C
ATOM   1104  CB  SER   131     -45.843   6.578 -10.396  0.50 11.10           C
ATOM   1106  OG  SER   131     -45.705   5.328  -9.775  0.50 10.69           O
ATOM   1108  C   SER   131     -48.057   6.142 -11.458  0.50 10.47           C
ATOM   1110  O   SER   131     -48.497   4.991 -11.474  0.50  9.95           O
ATOM   1112  N   ILE   132     -48.806   7.214 -11.186  1.00  9.30           N
ATOM   1113  CA  ILE   132     -50.274   7.155 -11.007  1.00 10.27           C
ATOM   1114  CB  ILE   132     -50.819   8.528 -10.573  1.00 10.43           C
ATOM   1115  CG1 ILE   132     -50.217   8.879  -9.199  1.00 10.19           C
ATOM   1116  CD1 ILE   132     -50.537  10.321  -8.694  1.00 10.55           C
ATOM   1117  CG2 ILE   132     -52.352   8.522 -10.544  1.00 12.86           C
ATOM   1118  C   ILE   132     -50.956   6.643 -12.274  1.00 10.09           C
ATOM   1119  O   ILE   132     -51.855   5.784 -12.188  1.00  9.47           O
ATOM   1120  N   GLU   133     -50.535   7.164 -13.426  0.50 10.08           N
ATOM   1122  CA  GLU   133     -51.024   6.713 -14.732  0.50 10.68           C
ATOM   1124  CB  GLU   133     -50.390   7.549 -15.871  0.50 10.91           C
ATOM   1126  CG  GLU   133     -51.050   8.940 -16.009  0.50 12.45           C
ATOM   1128  CD  GLU   133     -50.193  10.029 -16.674  0.50 14.41           C
ATOM   1130  OE1 GLU   133     -48.998   9.781 -16.983  0.50 17.78           O
ATOM   1132  OE2 GLU   133     -50.748  11.144 -16.892  0.50 18.07           O
ATOM   1134  C   GLU   133     -50.823   5.208 -14.941  0.50  9.88           C
ATOM   1136  O   GLU   133     -51.712   4.518 -15.430  0.50 10.09           O
ATOM   1138  N   ALA   134     -49.659   4.695 -14.546  1.00  9.31           N
ATOM   1139  CA  ALA   134     -49.346   3.267 -14.674  1.00  9.01           C
ATOM   1140  CB  ALA   134     -47.869   3.011 -14.361  1.00  9.38           C
ATOM   1141  C   ALA   134     -50.237   2.445 -13.765  1.00  9.17           C
ATOM   1142  O   ALA   134     -50.720   1.372 -14.144  1.00  9.07           O
ATOM   1143  N   GLY   135     -50.446   2.954 -12.554  1.00  9.74           N
ATOM   1144  CA  GLY   135     -51.304   2.264 -11.598  1.00  9.68           C
ATOM   1145  C   GLY   135     -52.748   2.231 -12.081  1.00 10.54           C
ATOM   1146  O   GLY   135     -53.432   1.261 -11.841  1.00 11.18           O
ATOM   1147  N   MET   136     -53.212   3.294 -12.736  1.00 10.78           N
ATOM   1148  CA  MET   136     -54.550   3.319 -13.316  1.00 14.00           C
ATOM   1149  CB  MET   136     -54.856   4.709 -13.853  1.00 12.19           C
ATOM   1150  CG  MET   136     -55.025   5.738 -12.769  1.00 17.50           C
ATOM   1151  SD  MET   136     -55.390   7.532 -13.517  0.80 27.77          SE
ATOM   1152  CE  MET   136     -56.956   7.128 -14.509  1.00 24.50           C
ATOM   1153  C   MET   136     -54.690   2.274 -14.426  1.00 11.62           C
ATOM   1154  O   MET   136     -55.630   1.461 -14.414  1.00 11.88           O
ATOM   1155  N   THR   137     -53.704   2.228 -15.331  1.00 10.74           N
ATOM   1156  CA  THR   137     -53.673   1.197 -16.405  1.00  9.88           C
ATOM   1157  CB  THR   137     -52.401   1.371 -17.285  1.00  9.89           C
ATOM   1158  OG1 THR   137     -52.434   2.676 -17.872  1.00 11.23           O
ATOM   1159  CG2 THR   137     -52.311   0.289 -18.374  1.00 10.49           C
ATOM   1160  C   THR   137     -53.735  -0.220 -15.824  1.00  9.70           C
ATOM   1161  O   THR   137     -54.451  -1.096 -16.313  1.00  8.79           O
ATOM   1162  N   ARG   138     -53.012  -0.433 -14.737  1.00 10.06           N
ATOM   1163  CA  ARG   138     -52.962  -1.726 -14.092  1.00 10.50           C
ATOM   1164  CB  ARG   138     -51.753  -1.827 -13.178  1.00 10.22           C
ATOM   1165  CG  ARG   138     -50.421  -1.961 -13.926  1.00 11.00           C
ATOM   1166  CD  ARG   138     -49.267  -1.783 -12.921  1.00 11.40           C
ATOM   1167  NE  ARG   138     -49.385  -2.776 -11.860  1.00 13.48           N
ATOM   1168  CZ  ARG   138     -48.694  -2.749 -10.731  1.00 16.65           C
ATOM   1169  NH1 ARG   138     -47.798  -1.778 -10.519  1.00 13.97           N
ATOM   1170  NH2 ARG   138     -48.909  -3.699  -9.812  1.00 18.04           N
ATOM   1171  C   ARG   138     -54.233  -2.088 -13.308  1.00 11.15           C
ATOM   1172  O   ARG   138     -54.391  -3.238 -12.908  1.00 11.80           O
ATOM   1173  N   GLY   139     -55.117  -1.122 -13.103  1.00 12.43           N
ATOM   1174  CA  GLY   139     -56.308  -1.342 -12.309  1.00 12.85           C
ATOM   1175  C   GLY   139     -56.098  -1.206 -10.803  1.00 14.77           C
ATOM   1176  O   GLY   139     -57.031  -1.500 -10.021  1.00 15.21           O
ATOM   1177  N   LEU   140     -54.904  -0.785 -10.370  1.00 14.40           N
ATOM   1178  CA  LEU   140     -54.663  -0.525  -8.930  1.00 15.70           C
ATOM   1179  CB  LEU   140     -53.175  -0.325  -8.608  1.00 17.02           C
ATOM   1180  CG  LEU   140     -52.165  -1.407  -8.937  1.00 20.06           C
ATOM   1181  CD1 LEU   140     -50.855  -0.921  -8.327  1.00 24.89           C
ATOM   1182  CD2 LEU   140     -52.585  -2.711  -8.319  1.00 24.25           C
ATOM   1183  C   LEU   140     -55.356   0.744  -8.489  1.00 14.92           C
ATOM   1184  O   LEU   140     -55.818   0.834  -7.342  1.00 14.43           O
ATOM   1185  N   PHE   141     -55.378   1.734  -9.384  1.00 13.97           N
ATOM   1186  CA  PHE   141     -55.934   3.051  -9.092  1.00 15.04           C
ATOM   1187  CB  PHE   141     -54.894   4.159  -9.339  1.00 13.91           C
ATOM   1188  CG  PHE   141     -53.627   4.016  -8.510  1.00 13.77           C
ATOM   1189  CD1 PHE   141     -53.668   3.442  -7.227  1.00 13.85           C
ATOM   1190  CE1 PHE   141     -52.491   3.310  -6.463  1.00 13.85           C
ATOM   1191  CZ  PHE   141     -51.267   3.776  -7.000  1.00 12.20           C
ATOM   1192  CE2 PHE   141     -51.240   4.341  -8.294  1.00 10.44           C
ATOM   1193  CD2 PHE   141     -52.392   4.479  -9.011  1.00 12.75           C
ATOM   1194  C   PHE   141     -57.151   3.307  -9.951  1.00 15.74           C
ATOM   1195  O   PHE   141     -57.249   2.777 -11.067  1.00 14.26           O
ATOM   1196  N   ARG   142     -58.074   4.120  -9.443  0.50 16.15           N
ATOM   1198  CA  ARG   142     -59.333   4.428 -10.124  0.50 17.47           C
ATOM   1200  CB  ARG   142     -60.256   5.250  -9.227  0.50 17.67           C
ATOM   1202  CG  ARG   142     -60.907   4.514  -8.115  0.50 18.73           C
ATOM   1204  CD  ARG   142     -61.871   5.446  -7.428  0.50 20.28           C
ATOM   1206  NE  ARG   142     -61.191   6.543  -6.744  0.50 20.28           N
ATOM   1208  CZ  ARG   142     -61.802   7.632  -6.287  0.50 20.99           C
ATOM   1210  NH1 ARG   142     -63.104   7.797  -6.474  0.50 17.88           N
ATOM   1212  NH2 ARG   142     -61.099   8.580  -5.668  0.50 20.92           N
ATOM   1214  C   ARG   142     -59.126   5.255 -11.374  0.50 17.70           C
ATOM   1216  O   ARG   142     -58.339   6.198 -11.388  0.50 18.50           O
ATOM   1218  N   ARG   143     -59.912   4.938 -12.395  1.00 18.41           N
ATOM   1219  CA  ARG   143     -59.747   5.554 -13.691  1.00 19.17           C
ATOM   1220  CB  ARG   143     -60.007   4.550 -14.785  1.00 19.39           C
ATOM   1221  CG  ARG   143     -58.965   3.434 -14.827  1.00 22.29           C
ATOM   1222  CD  ARG   143     -59.450   2.272 -15.677  1.00 26.49           C
ATOM   1223  NE  ARG   143     -58.403   1.273 -15.895  1.00 30.12           N
ATOM   1224  CZ  ARG   143     -58.545  -0.047 -15.757  1.00 31.21           C
ATOM   1225  NH1 ARG   143     -59.715  -0.594 -15.415  1.00 32.67           N
ATOM   1226  NH2 ARG   143     -57.502  -0.838 -15.984  1.00 31.42           N
ATOM   1227  C   ARG   143     -60.507   6.857 -13.893  1.00 18.83           C
ATOM   1228  O   ARG   143     -60.315   7.510 -14.913  1.00 20.12           O
ATOM   1229  N   ASP   144     -61.324   7.254 -12.917  1.00 17.76           N
ATOM   1230  CA  ASP   144     -62.025   8.547 -12.977  1.00 16.37           C
ATOM   1231  CB  ASP   144     -63.426   8.450 -12.354  1.00 16.63           C
ATOM   1232  CG  ASP   144     -63.395   8.116 -10.877  1.00 17.52           C
ATOM   1233  OD1 ASP   144     -62.398   7.530 -10.424  1.00 17.03           O
ATOM   1234  OD2 ASP   144     -64.383   8.426 -10.159  1.00 20.81           O
ATOM   1235  C   ASP   144     -61.281   9.716 -12.339  1.00 15.58           C
ATOM   1236  O   ASP   144     -61.871  10.803 -12.135  1.00 16.22           O
ATOM   1237  N   LEU   145     -60.024   9.520 -11.954  0.50 14.65           N
ATOM   1239  CA  LEU   145     -59.257  10.650 -11.435  0.50 13.62           C
ATOM   1241  CB  LEU   145     -58.748  10.426 -10.005  0.50 13.58           C
ATOM   1243  CG  LEU   145     -59.708  10.249  -8.827  0.50 13.00           C
ATOM   1245  CD1 LEU   145     -58.863   9.721  -7.686  0.50 13.60           C
ATOM   1247  CD2 LEU   145     -60.478  11.539  -8.398  0.50 13.09           C
ATOM   1249  C   LEU   145     -58.106  10.962 -12.376  0.50 13.00           C
ATOM   1251  O   LEU   145     -57.581  10.079 -13.050  0.50 12.96           O
ATOM   1253  N   HIS   146     -57.762  12.235 -12.428  1.00 12.38           N
ATOM   1254  CA  HIS   146     -56.767  12.749 -13.335  1.00 11.72           C
ATOM   1255  CB  HIS   146     -57.099  14.174 -13.754  1.00 13.12           C
ATOM   1256  CG  HIS   146     -58.088  14.223 -14.890  1.00 18.87           C
ATOM   1257  ND1 HIS   146     -59.407  14.593 -14.717  1.00 23.34           N
ATOM   1258  CE1 HIS   146     -60.041  14.495 -15.875  1.00 23.61           C
ATOM   1259  NE2 HIS   146     -59.189  14.056 -16.787  1.00 22.78           N
ATOM   1260  CD2 HIS   146     -57.966  13.859 -16.194  1.00 21.18           C
ATOM   1261  C   HIS   146     -55.432  12.632 -12.658  1.00  9.97           C
ATOM   1262  O   HIS   146     -55.283  13.064 -11.523  1.00  8.48           O
ATOM   1263  N   ALA   147     -54.466  12.063 -13.380  1.00  8.06           N
ATOM   1264  CA  ALA   147     -53.171  11.743 -12.792  1.00  7.43           C
ATOM   1265  CB  ALA   147     -52.303  10.976 -13.795  1.00  7.64           C
ATOM   1266  C   ALA   147     -52.415  12.975 -12.255  1.00  7.37           C
ATOM   1267  O   ALA   147     -51.892  12.935 -11.149  1.00  7.42           O
ATOM   1268  N   VAL   148     -52.323  14.040 -13.057  1.00  5.91           N
ATOM   1269  CA  VAL   148     -51.580  15.234 -12.596  1.00  5.28           C
ATOM   1270  CB  VAL   148     -51.376  16.285 -13.741  1.00  5.29           C
ATOM   1271  CG1 VAL   148     -50.894  17.623 -13.160  1.00  5.38           C
ATOM   1272  CG2 VAL   148     -50.385  15.716 -14.827  1.00  7.18           C
ATOM   1273  C   VAL   148     -52.285  15.874 -11.417  1.00  5.21           C
ATOM   1274  O   VAL   148     -51.641  16.225 -10.424  1.00  4.80           O
ATOM   1275  N   ASN   149     -53.605  16.034 -11.475  1.00  5.51           N
ATOM   1276  CA  ASN   149     -54.259  16.664 -10.322  1.00  5.65           C
ATOM   1277  CB  ASN   149     -55.765  16.822 -10.566  1.00  6.66           C
ATOM   1278  CG  ASN   149     -56.088  18.026 -11.409  1.00 10.17           C
ATOM   1279  OD1 ASN   149     -55.200  18.846 -11.725  1.00 12.80           O
ATOM   1280  ND2 ASN   149     -57.358  18.143 -11.798  1.00 12.10           N
ATOM   1281  C   ASN   149     -54.045  15.842  -9.043  1.00  6.11           C
ATOM   1282  O   ASN   149     -53.933  16.413  -7.953  1.00  4.78           O
ATOM   1283  N   SER   150     -53.988  14.513  -9.207  1.00  5.76           N
ATOM   1284  CA  SER   150     -53.748  13.564  -8.084  1.00  6.08           C
ATOM   1285  CB  SER   150     -54.027  12.096  -8.522  1.00  5.78           C
ATOM   1286  OG  SER   150     -55.422  11.927  -8.837  1.00  7.08           O
ATOM   1287  C   SER   150     -52.331  13.717  -7.550  1.00  5.66           C
ATOM   1288  O   SER   150     -52.119  13.810  -6.341  1.00  5.57           O
ATOM   1289  N   ALA   151     -51.349  13.768  -8.451  1.00  5.77           N
ATOM   1290  CA  ALA   151     -49.966  14.064  -8.076  1.00  5.41           C
ATOM   1291  CB  ALA   151     -49.086  14.156  -9.326  1.00  5.18           C
ATOM   1292  C   ALA   151     -49.874  15.386  -7.279  1.00  5.91           C
ATOM   1293  O   ALA   151     -49.179  15.466  -6.262  1.00  6.61           O
ATOM   1294  N   LEU   152     -50.552  16.425  -7.784  1.00  6.31           N
ATOM   1295  CA  LEU   152     -50.534  17.749  -7.110  1.00  5.72           C
ATOM   1296  CB  LEU   152     -51.297  18.807  -7.921  1.00  4.81           C
ATOM   1297  CG  LEU   152     -50.598  19.222  -9.218  1.00  4.27           C
ATOM   1298  CD1 LEU   152     -51.572  20.071 -10.072  1.00  6.58           C
ATOM   1299  CD2 LEU   152     -49.276  20.001  -8.973  1.00  5.18           C
ATOM   1300  C   LEU   152     -51.132  17.647  -5.707  1.00  7.70           C
ATOM   1301  O   LEU   152     -50.626  18.296  -4.766  1.00  7.69           O
ATOM   1302  N   ALA   153     -52.188  16.836  -5.551  1.00  6.37           N
ATOM   1303  CA  ALA   153     -52.794  16.600  -4.245  1.00  7.16           C
ATOM   1304  CB  ALA   153     -54.029  15.679  -4.378  1.00  5.65           C
ATOM   1305  C   ALA   153     -51.787  16.008  -3.247  1.00  7.42           C
ATOM   1306  O   ALA   153     -51.667  16.511  -2.117  1.00  6.88           O
ATOM   1307  N   LEU   154     -51.039  14.972  -3.683  1.00  5.98           N
ATOM   1308  CA  LEU   154     -50.031  14.354  -2.805  1.00  5.94           C
ATOM   1309  CB  LEU   154     -49.453  13.092  -3.458  1.00  6.06           C
ATOM   1310  CG  LEU   154     -48.400  12.364  -2.617  1.00  6.43           C
ATOM   1311  CD1 LEU   154     -48.990  11.876  -1.271  1.00  5.45           C
ATOM   1312  CD2 LEU   154     -47.790  11.240  -3.434  1.00  7.02           C
ATOM   1313  C   LEU   154     -48.921  15.373  -2.447  1.00  5.85           C
ATOM   1314  O   LEU   154     -48.530  15.518  -1.271  1.00  6.15           O
ATOM   1315  N   ALA   155     -48.449  16.084  -3.464  1.00  6.37           N
ATOM   1316  CA  ALA   155     -47.402  17.083  -3.242  1.00  6.90           C
ATOM   1317  CB  ALA   155     -46.984  17.689  -4.593  1.00  7.15           C
ATOM   1318  C   ALA   155     -47.927  18.147  -2.260  1.00  6.59           C
ATOM   1319  O   ALA   155     -47.181  18.625  -1.387  1.00  7.17           O
ATOM   1320  N   GLY   156     -49.204  18.510  -2.409  1.00  6.53           N
ATOM   1321  CA  GLY   156     -49.808  19.558  -1.574  1.00  7.23           C
ATOM   1322  C   GLY   156     -49.903  19.117  -0.129  1.00  8.33           C
ATOM   1323  O   GLY   156     -49.684  19.935   0.770  1.00  9.18           O
ATOM   1324  N   MET   157     -50.275  17.857   0.104  0.50  7.22           N
ATOM   1326  CA  MET   157     -50.394  17.342   1.473  0.50  9.40           C
ATOM   1328  CB  MET   157     -50.608  15.818   1.495  0.50  9.03           C
ATOM   1330  CG  MET   157     -51.950  15.368   1.037  0.50 10.44           C
ATOM   1332  SD  MET   157     -52.121  13.470   1.490  0.50 14.75          SE
ATOM   1334  CE  MET   157     -53.565  13.043   0.240  0.50 11.36           C
ATOM   1336  C   MET   157     -49.104  17.647   2.216  0.50  8.33           C
ATOM   1338  O   MET   157     -49.097  18.375   3.226  0.50  7.60           O
ATOM   1340  N   VAL   158     -48.020  17.067   1.700  1.00  7.62           N
ATOM   1341  CA  VAL   158     -46.738  17.073   2.389  1.00  7.60           C
ATOM   1342  CB  VAL   158     -45.769  16.001   1.870  1.00  7.87           C
ATOM   1343  CG1 VAL   158     -45.363  16.267   0.375  1.00  6.80           C
ATOM   1344  CG2 VAL   158     -44.556  15.904   2.800  1.00  5.50           C
ATOM   1345  C   VAL   158     -46.161  18.504   2.448  1.00  8.05           C
ATOM   1346  O   VAL   158     -45.655  18.951   3.498  1.00  7.94           O
ATOM   1347  N   ASN   159     -46.268  19.258   1.359  1.00  6.99           N
ATOM   1348  CA  ASN   159     -45.679  20.596   1.364  1.00  8.56           C
ATOM   1349  CB  ASN   159     -45.517  21.063  -0.110  1.00  9.44           C
ATOM   1350  CG  ASN   159     -44.267  20.391  -0.770  1.00 13.46           C
ATOM   1351  OD1 ASN   159     -43.115  20.774  -0.449  1.00 13.49           O
ATOM   1352  ND2 ASN   159     -44.491  19.365  -1.676  1.00 11.04           N
ATOM   1353  C   ASN   159     -46.491  21.532   2.299  1.00  8.55           C
ATOM   1354  O   ASN   159     -45.898  22.350   3.007  1.00  8.77           O
ATOM   1355  N   TYR   160     -47.807  21.324   2.393  1.00  8.99           N
ATOM   1356  CA  TYR   160     -48.598  22.206   3.289  1.00  8.46           C
ATOM   1357  CB  TYR   160     -50.076  22.031   3.041  1.00  9.05           C
ATOM   1358  CG  TYR   160     -50.895  23.089   3.758  1.00  6.76           C
ATOM   1359  CD1 TYR   160     -51.004  24.373   3.254  1.00  6.16           C
ATOM   1360  CE1 TYR   160     -51.755  25.374   3.951  1.00  6.68           C
ATOM   1361  CZ  TYR   160     -52.367  25.032   5.159  1.00  6.05           C
ATOM   1362  OH  TYR   160     -53.125  25.927   5.884  1.00  6.88           O
ATOM   1363  CE2 TYR   160     -52.260  23.729   5.663  1.00  7.56           C
ATOM   1364  CD2 TYR   160     -51.513  22.779   4.968  1.00  8.31           C
ATOM   1365  C   TYR   160     -48.297  21.873   4.749  1.00  8.41           C
ATOM   1366  O   TYR   160     -48.341  22.775   5.600  1.00  7.66           O
ATOM   1367  N   PHE   161     -48.025  20.596   5.064  1.00  7.26           N
ATOM   1368  CA  PHE   161     -47.662  20.273   6.467  1.00  7.86           C
ATOM   1369  CB  PHE   161     -47.311  18.790   6.604  1.00  7.74           C
ATOM   1370  CG  PHE   161     -46.983  18.392   7.998  1.00  9.30           C
ATOM   1371  CD1 PHE   161     -48.006  18.107   8.896  1.00 12.83           C
ATOM   1372  CE1 PHE   161     -47.720  17.697  10.215  1.00 11.42           C
ATOM   1373  CZ  PHE   161     -46.391  17.641  10.657  1.00 12.71           C
ATOM   1374  CE2 PHE   161     -45.357  17.968   9.769  1.00 10.83           C
ATOM   1375  CD2 PHE   161     -45.666  18.335   8.433  1.00 11.04           C
ATOM   1376  C   PHE   161     -46.491  21.148   6.954  1.00  7.95           C
ATOM   1377  O   PHE   161     -46.543  21.724   8.066  1.00  9.32           O
ATOM   1378  N   PHE   162     -45.463  21.301   6.114  1.00  6.72           N
ATOM   1379  CA  PHE   162     -44.318  22.124   6.507  1.00  7.65           C
ATOM   1380  CB  PHE   162     -43.078  21.726   5.710  1.00  7.99           C
ATOM   1381  CG  PHE   162     -42.566  20.366   6.105  1.00  9.27           C
ATOM   1382  CD1 PHE   162     -41.714  20.225   7.191  1.00 10.78           C
ATOM   1383  CE1 PHE   162     -41.239  18.956   7.593  1.00 11.91           C
ATOM   1384  CZ  PHE   162     -41.634  17.827   6.904  1.00 11.69           C
ATOM   1385  CE2 PHE   162     -42.511  17.965   5.784  1.00 13.79           C
ATOM   1386  CD2 PHE   162     -42.967  19.220   5.412  1.00 10.23           C
ATOM   1387  C   PHE   162     -44.639  23.608   6.400  1.00  6.36           C
ATOM   1388  O   PHE   162     -44.272  24.414   7.281  1.00  6.77           O
ATOM   1389  N   LEU   163     -45.339  23.986   5.329  1.00  6.53           N
ATOM   1390  CA  LEU   163     -45.685  25.410   5.150  1.00  6.76           C
ATOM   1391  CB  LEU   163     -46.531  25.576   3.876  1.00  6.66           C
ATOM   1392  CG  LEU   163     -46.960  27.017   3.573  1.00  7.04           C
ATOM   1393  CD1 LEU   163     -45.732  27.937   3.372  1.00  9.53           C
ATOM   1394  CD2 LEU   163     -47.878  27.026   2.294  1.00  8.47           C
ATOM   1395  C   LEU   163     -46.462  25.968   6.327  1.00  6.16           C
ATOM   1396  O   LEU   163     -46.251  27.132   6.716  1.00  6.46           O
ATOM   1397  N   SER   164     -47.398  25.156   6.872  1.00  5.30           N
ATOM   1398  CA  SER   164     -48.338  25.682   7.889  1.00  7.61           C
ATOM   1399  CB  SER   164     -49.657  24.912   7.802  1.00  8.19           C
ATOM   1400  OG  SER   164     -49.459  23.552   8.139  1.00  9.73           O
ATOM   1401  C   SER   164     -47.773  25.574   9.326  1.00  7.56           C
ATOM   1402  O   SER   164     -48.479  25.903  10.294  1.00  8.21           O
ATOM   1403  N   THR   165     -46.511  25.154   9.458  1.00  5.79           N
ATOM   1404  CA  THR   165     -45.964  24.822  10.782  1.00  6.26           C
ATOM   1405  CB  THR   165     -44.424  24.572  10.701  1.00  6.23           C
ATOM   1406  OG1 THR   165     -44.184  23.428   9.866  1.00  7.44           O
ATOM   1407  CG2 THR   165     -43.891  24.259  12.117  1.00  8.11           C
ATOM   1408  C   THR   165     -46.186  25.914  11.821  1.00  4.75           C
ATOM   1409  O   THR   165     -46.641  25.626  12.936  1.00  5.25           O
ATOM   1410  N   LEU   166     -45.844  27.165  11.481  1.00  5.75           N
ATOM   1411  CA  LEU   166     -45.911  28.235  12.482  1.00  6.51           C
ATOM   1412  CB  LEU   166     -45.339  29.576  11.965  1.00  6.68           C
ATOM   1413  CG  LEU   166     -43.841  29.678  11.719  1.00 10.81           C
ATOM   1414  CD1 LEU   166     -43.547  31.167  11.394  1.00 11.81           C
ATOM   1415  CD2 LEU   166     -43.055  29.293  13.016  1.00 11.69           C
ATOM   1416  C   LEU   166     -47.337  28.456  12.986  1.00  7.46           C
ATOM   1417  O   LEU   166     -47.491  28.973  14.095  1.00  8.56           O
ATOM   1418  N   ALA   167     -48.369  28.123  12.171  1.00  6.08           N
ATOM   1419  CA  ALA   167     -49.766  28.384  12.541  1.00  8.18           C
ATOM   1420  CB  ALA   167     -50.626  28.722  11.311  1.00  7.47           C
ATOM   1421  C   ALA   167     -50.387  27.203  13.251  1.00  8.91           C
ATOM   1422  O   ALA   167     -51.532  27.304  13.723  1.00  9.05           O
ATOM   1423  N   THR   168     -49.662  26.096  13.285  1.00  8.62           N
ATOM   1424  CA  THR   168     -50.264  24.857  13.794  1.00 10.98           C
ATOM   1425  CB  THR   168     -50.502  23.867  12.644  1.00  9.39           C
ATOM   1426  OG1 THR   168     -49.275  23.508  11.993  1.00 11.50           O
ATOM   1427  CG2 THR   168     -51.464  24.477  11.542  1.00  9.79           C
ATOM   1428  C   THR   168     -49.423  24.220  14.919  1.00 10.56           C
ATOM   1429  O   THR   168     -49.522  22.997  15.158  1.00 11.79           O
ATOM   1430  N   GLU   169     -48.671  25.069  15.639  1.00 13.47           N
ATOM   1431  CA  GLU   169     -47.634  24.567  16.568  1.00 14.51           C
ATOM   1432  CB  GLU   169     -46.793  25.705  17.190  1.00 15.58           C
ATOM   1433  CG  GLU   169     -45.950  26.533  16.217  1.00 16.67           C
ATOM   1434  CD  GLU   169     -44.641  25.858  15.769  1.00 18.06           C
ATOM   1435  OE1 GLU   169     -44.427  24.660  16.046  1.00 20.34           O
ATOM   1436  OE2 GLU   169     -43.824  26.515  15.088  1.00 17.77           O
ATOM   1437  C   GLU   169     -48.280  23.732  17.661  1.00 14.80           C
ATOM   1438  O   GLU   169     -47.758  22.662  18.045  1.00 15.84           O
ATOM   1439  N   GLY   170     -49.391  24.218  18.188  1.00 14.31           N
ATOM   1440  CA  GLY   170     -50.050  23.519  19.293  1.00 15.34           C
ATOM   1441  C   GLY   170     -51.115  22.570  18.807  1.00 14.96           C
ATOM   1442  O   GLY   170     -51.802  21.946  19.628  1.00 15.30           O
ATOM   1443  N   LEU   171     -51.257  22.405  17.486  1.00 11.97           N
ATOM   1444  CA  LEU   171     -52.364  21.571  16.985  1.00 12.07           C
ATOM   1445  CB  LEU   171     -53.048  22.173  15.739  1.00 11.20           C
ATOM   1446  CG  LEU   171     -53.567  23.620  15.751  1.00 13.56           C
ATOM   1447  CD1 LEU   171     -54.356  23.917  14.477  1.00 12.40           C
ATOM   1448  CD2 LEU   171     -54.410  23.968  16.985  1.00 16.09           C
ATOM   1449  C   LEU   171     -51.901  20.179  16.629  1.00 12.32           C
ATOM   1450  O   LEU   171     -52.706  19.251  16.620  1.00 12.27           O
ATOM   1451  N   THR   172     -50.620  20.021  16.304  1.00 11.32           N
ATOM   1452  CA  THR   172     -50.093  18.690  15.929  1.00 12.36           C
ATOM   1453  CB  THR   172     -50.439  18.296  14.451  1.00 11.94           C
ATOM   1454  OG1 THR   172     -50.076  16.907  14.240  1.00 16.35           O
ATOM   1455  CG2 THR   172     -49.710  19.217  13.452  1.00 12.29           C
ATOM   1456  C   THR   172     -48.585  18.711  16.141  1.00 12.72           C
ATOM   1457  O   THR   172     -47.994  19.812  16.226  1.00 13.87           O
ATOM   1458  N   SER   173     -47.958  17.545  16.214  1.00 12.97           N
ATOM   1459  CA  SER   173     -46.524  17.503  16.397  1.00 11.93           C
ATOM   1460  CB  SER   173     -46.103  16.108  16.826  1.00 13.97           C
ATOM   1461  OG  SER   173     -44.681  15.989  16.771  1.00 14.44           O
ATOM   1462  C   SER   173     -45.874  17.806  15.060  1.00 12.33           C
ATOM   1463  O   SER   173     -46.353  17.332  14.028  1.00 12.42           O
ATOM   1464  N   HIS   174     -44.824  18.610  15.068  1.00 12.00           N
ATOM   1465  CA  HIS   174     -43.970  18.721  13.876  1.00 14.23           C
ATOM   1466  CB  HIS   174     -43.909  20.171  13.391  1.00 14.23           C
ATOM   1467  CG  HIS   174     -45.247  20.722  13.030  1.00 15.81           C
ATOM   1468  ND1 HIS   174     -46.071  21.324  13.968  1.00 16.61           N
ATOM   1469  CE1 HIS   174     -47.185  21.718  13.368  1.00 20.91           C
ATOM   1470  NE2 HIS   174     -47.116  21.386  12.085  1.00 19.63           N
ATOM   1471  CD2 HIS   174     -45.900  20.785  11.839  1.00 17.42           C
ATOM   1472  C   HIS   174     -42.578  18.183  14.149  1.00 13.15           C
ATOM   1473  O   HIS   174     -41.625  18.515  13.427  1.00 14.79           O
ATOM   1474  N   SER   175     -42.456  17.352  15.179  1.00 14.28           N
ATOM   1475  CA  SER   175     -41.158  16.794  15.566  1.00 13.71           C
ATOM   1476  CB  SER   175     -41.281  16.104  16.921  1.00 14.35           C
ATOM   1477  OG  SER   175     -40.255  15.138  17.113  1.00 17.37           O
ATOM   1478  C   SER   175     -40.645  15.822  14.475  1.00 13.44           C
ATOM   1479  O   SER   175     -41.412  15.024  13.953  1.00 12.58           O
ATOM   1480  N   PRO   176     -39.341  15.882  14.146  1.00 13.15           N
ATOM   1481  CA  PRO   176     -38.830  14.880  13.178  1.00 13.22           C
ATOM   1482  CB  PRO   176     -37.342  15.224  13.064  1.00 13.70           C
ATOM   1483  CG  PRO   176     -37.228  16.655  13.534  1.00 13.98           C
ATOM   1484  CD  PRO   176     -38.278  16.806  14.593  1.00 13.08           C
ATOM   1485  C   PRO   176     -39.045  13.413  13.624  1.00 14.24           C
ATOM   1486  O   PRO   176     -39.154  12.527  12.770  1.00 13.21           O
ATOM   1487  N   ASP   177     -39.134  13.171  14.936  1.00 14.82           N
ATOM   1488  CA  ASP   177     -39.514  11.855  15.496  1.00 16.58           C
ATOM   1489  CB  ASP   177     -39.811  11.976  17.000  1.00 17.92           C
ATOM   1490  CG  ASP   177     -38.610  12.345  17.796  1.00 24.07           C
ATOM   1491  OD1 ASP   177     -37.500  12.389  17.204  1.00 30.89           O
ATOM   1492  OD2 ASP   177     -38.764  12.562  19.024  1.00 30.05           O
ATOM   1493  C   ASP   177     -40.780  11.270  14.887  1.00 15.97           C
ATOM   1494  O   ASP   177     -40.967  10.047  14.905  1.00 16.38           O
ATOM   1495  N   GLN   178     -41.655  12.147  14.404  1.00 14.77           N
ATOM   1496  CA  GLN   178     -42.965  11.735  13.923  1.00 15.23           C
ATOM   1497  CB  GLN   178     -44.057  12.637  14.515  1.00 16.28           C
ATOM   1498  CG  GLN   178     -44.212  12.558  16.075  1.00 18.38           C
ATOM   1499  CD  GLN   178     -44.416  11.148  16.555  1.00 24.89           C
ATOM   1500  OE1 GLN   178     -45.323  10.454  16.094  1.00 28.81           O
ATOM   1501  NE2 GLN   178     -43.556  10.694  17.466  1.00 23.68           N
ATOM   1502  C   GLN   178     -43.060  11.731  12.390  1.00 14.33           C
ATOM   1503  O   GLN   178     -44.153  11.563  11.837  1.00 14.25           O
ATOM   1504  N   ASP   179     -41.935  11.946  11.715  1.00 13.75           N
ATOM   1505  CA  ASP   179     -41.931  12.025  10.241  1.00 12.28           C
ATOM   1506  CB  ASP   179     -40.565  12.503   9.712  1.00 12.21           C
ATOM   1507  CG  ASP   179     -40.345  14.003   9.887  1.00 12.00           C
ATOM   1508  OD1 ASP   179     -41.340  14.728  10.133  1.00 12.73           O
ATOM   1509  OD2 ASP   179     -39.178  14.458   9.767  1.00 10.97           O
ATOM   1510  C   ASP   179     -42.333  10.695   9.583  1.00 12.43           C
ATOM   1511  O   ASP   179     -43.076  10.688   8.586  1.00 11.55           O
ATOM   1512  N   GLU   180     -41.873   9.564  10.129  1.00 12.85           N
ATOM   1513  CA  GLU   180     -42.244   8.281   9.539  1.00 13.39           C
ATOM   1514  CB  GLU   180     -41.363   7.129  10.047  1.00 14.36           C
ATOM   1515  CG  GLU   180     -39.961   7.112   9.416  1.00 16.71           C
ATOM   1516  CD  GLU   180     -39.971   6.815   7.917  1.00 18.99           C
ATOM   1517  OE1 GLU   180     -40.744   5.922   7.502  1.00 20.42           O
ATOM   1518  OE2 GLU   180     -39.200   7.469   7.161  1.00 18.63           O
ATOM   1519  C   GLU   180     -43.734   8.019   9.746  1.00 13.71           C
ATOM   1520  O   GLU   180     -44.403   7.448   8.873  1.00 13.28           O
ATOM   1521  N   GLU   181     -44.271   8.460  10.883  1.00 13.78           N
ATOM   1522  CA  GLU   181     -45.689   8.305  11.124  1.00 14.42           C
ATOM   1523  CB  GLU   181     -45.998   8.599  12.588  1.00 16.10           C
ATOM   1524  CG  GLU   181     -47.472   8.632  12.901  1.00 21.01           C
ATOM   1525  CD  GLU   181     -48.173   7.282  12.774  1.00 23.11           C
ATOM   1526  OE1 GLU   181     -47.514   6.228  12.665  1.00 24.17           O
ATOM   1527  OE2 GLU   181     -49.422   7.301  12.790  1.00 25.06           O
ATOM   1528  C   GLU   181     -46.494   9.212  10.185  1.00 14.14           C
ATOM   1529  O   GLU   181     -47.564   8.828   9.706  1.00 14.26           O
ATOM   1530  N   LEU   182     -45.956  10.396   9.878  1.00 13.08           N
ATOM   1531  CA  LEU   182     -46.604  11.293   8.915  1.00 13.64           C
ATOM   1532  CB  LEU   182     -45.865  12.643   8.831  1.00 12.83           C
ATOM   1533  CG  LEU   182     -46.579  13.680   7.940  1.00 14.91           C
ATOM   1534  CD1 LEU   182     -47.863  14.196   8.590  1.00 15.08           C
ATOM   1535  CD2 LEU   182     -45.644  14.827   7.575  1.00 15.95           C
ATOM   1536  C   LEU   182     -46.678  10.637   7.522  1.00 13.14           C
ATOM   1537  O   LEU   182     -47.718  10.661   6.855  1.00 14.11           O
ATOM   1538  N   ILE   183     -45.576  10.050   7.084  1.00 12.68           N
ATOM   1539  CA  ILE   183     -45.564   9.306   5.810  1.00 11.35           C
ATOM   1540  CB  ILE   183     -44.189   8.673   5.546  1.00 10.84           C
ATOM   1541  CG1 ILE   183     -43.122   9.766   5.347  1.00 12.02           C
ATOM   1542  CD1 ILE   183     -41.658   9.195   5.429  1.00 11.23           C
ATOM   1543  CG2 ILE   183     -44.228   7.768   4.309  1.00 11.12           C
ATOM   1544  C   ILE   183     -46.664   8.205   5.800  1.00 11.45           C
ATOM   1545  O   ILE   183     -47.422   8.086   4.830  1.00 10.62           O
ATOM   1546  N   ARG   184     -46.735   7.438   6.884  0.50 11.53           N
ATOM   1548  CA  ARG   184     -47.720   6.369   7.046  0.50 11.75           C
ATOM   1550  CB  ARG   184     -47.569   5.750   8.435  0.50 12.01           C
ATOM   1552  CG  ARG   184     -47.839   4.275   8.512  0.50 14.69           C
ATOM   1554  CD  ARG   184     -47.348   3.699   9.852  0.50 17.23           C
ATOM   1556  NE  ARG   184     -45.897   3.490   9.822  0.50 20.38           N
ATOM   1558  CZ  ARG   184     -45.023   3.988  10.695  0.50 19.61           C
ATOM   1560  NH1 ARG   184     -43.738   3.716  10.523  0.50 21.24           N
ATOM   1562  NH2 ARG   184     -45.415   4.720  11.740  0.50 16.19           N
ATOM   1564  C   ARG   184     -49.137   6.937   6.888  0.50 11.09           C
ATOM   1566  O   ARG   184     -49.974   6.363   6.185  0.50 10.52           O
ATOM   1568  N   GLN   185     -49.387   8.070   7.541  1.00 10.20           N
ATOM   1569  CA  GLN   185     -50.693   8.718   7.492  1.00 11.34           C
ATOM   1570  CB  GLN   185     -50.812   9.832   8.557  1.00 11.76           C
ATOM   1571  CG  GLN   185     -50.910   9.329   9.971  1.00 13.90           C
ATOM   1572  CD  GLN   185     -50.827  10.475  10.988  1.00 16.31           C
ATOM   1573  OE1 GLN   185     -51.146  11.627  10.670  1.00 24.88           O
ATOM   1574  NE2 GLN   185     -50.379  10.163  12.192  1.00 22.00           N
ATOM   1575  C   GLN   185     -51.069   9.294   6.120  1.00 10.79           C
ATOM   1576  O   GLN   185     -52.231   9.134   5.675  1.00 10.92           O
ATOM   1577  N   TYR   186     -50.095   9.901   5.436  1.00  9.48           N
ATOM   1578  CA  TYR   186     -50.375  10.550   4.165  1.00 10.97           C
ATOM   1579  CB  TYR   186     -49.386  11.701   3.929  1.00 11.73           C
ATOM   1580  CG  TYR   186     -49.831  12.983   4.689  1.00 11.89           C
ATOM   1581  CD1 TYR   186     -50.901  12.943   5.618  1.00 16.50           C
ATOM   1582  CE1 TYR   186     -51.319  14.116   6.323  1.00 16.69           C
ATOM   1583  CZ  TYR   186     -50.665  15.304   6.104  1.00 15.60           C
ATOM   1584  OH  TYR   186     -51.066  16.479   6.789  1.00 16.29           O
ATOM   1585  CE2 TYR   186     -49.579  15.336   5.236  1.00 15.60           C
ATOM   1586  CD2 TYR   186     -49.176  14.184   4.529  1.00 16.97           C
ATOM   1587  C   TYR   186     -50.456   9.510   3.024  1.00 10.48           C
ATOM   1588  O   TYR   186     -51.313   9.616   2.143  1.00 10.25           O
ATOM   1589  N   VAL   187     -49.660   8.448   3.114  1.00 10.81           N
ATOM   1590  CA  VAL   187     -49.813   7.308   2.195  1.00 11.07           C
ATOM   1591  CB  VAL   187     -48.750   6.195   2.457  1.00 12.17           C
ATOM   1592  CG1 VAL   187     -49.152   4.865   1.801  1.00 12.64           C
ATOM   1593  CG2 VAL   187     -47.381   6.636   1.948  1.00 12.10           C
ATOM   1594  C   VAL   187     -51.238   6.738   2.348  1.00 10.78           C
ATOM   1595  O   VAL   187     -51.902   6.468   1.365  1.00 11.55           O
ATOM   1596  N   ALA   188     -51.697   6.596   3.591  1.00 10.35           N
ATOM   1597  CA  ALA   188     -53.016   6.013   3.862  1.00 10.34           C
ATOM   1598  CB  ALA   188     -53.214   5.835   5.322  1.00 10.03           C
ATOM   1599  C   ALA   188     -54.109   6.923   3.278  1.00 10.52           C
ATOM   1600  O   ALA   188     -54.976   6.440   2.532  1.00 11.14           O
ATOM   1601  N   ILE   189     -54.067   8.223   3.582  1.00  9.18           N
ATOM   1602  CA  ILE   189     -55.064   9.134   3.022  1.00 10.18           C
ATOM   1603  CB  ILE   189     -54.855  10.573   3.534  1.00 10.61           C
ATOM   1604  CG1 ILE   189     -55.136  10.601   5.058  1.00 10.98           C
ATOM   1605  CD1 ILE   189     -54.723  11.960   5.716  1.00 13.83           C
ATOM   1606  CG2 ILE   189     -55.802  11.563   2.805  1.00 11.30           C
ATOM   1607  C   ILE   189     -55.041   9.113   1.474  1.00  9.70           C
ATOM   1608  O   ILE   189     -56.074   9.014   0.819  1.00  9.40           O
ATOM   1609  N   PHE   190     -53.857   9.209   0.889  1.00  9.58           N
ATOM   1610  CA  PHE   190     -53.805   9.360  -0.550  1.00  9.58           C
ATOM   1611  CB  PHE   190     -52.360   9.611  -0.993  1.00 10.23           C
ATOM   1612  CG  PHE   190     -52.226  10.008  -2.454  1.00  9.45           C
ATOM   1613  CD1 PHE   190     -52.917  11.128  -2.945  1.00  9.44           C
ATOM   1614  CE1 PHE   190     -52.804  11.478  -4.324  1.00  8.91           C
ATOM   1615  CZ  PHE   190     -51.991  10.716  -5.159  1.00  8.37           C
ATOM   1616  CE2 PHE   190     -51.307   9.595  -4.666  1.00 10.34           C
ATOM   1617  CD2 PHE   190     -51.432   9.256  -3.313  1.00  9.34           C
ATOM   1618  C   PHE   190     -54.341   8.115  -1.252  1.00 10.23           C
ATOM   1619  O   PHE   190     -55.013   8.227  -2.272  1.00 10.36           O
ATOM   1620  N   THR   191     -54.011   6.933  -0.728  1.00 10.49           N
ATOM   1621  CA  THR   191     -54.331   5.687  -1.425  1.00 11.39           C
ATOM   1622  CB  THR   191     -53.251   4.575  -1.187  1.00 11.16           C
ATOM   1623  OG1 THR   191     -53.129   4.320   0.203  1.00 13.70           O
ATOM   1624  CG2 THR   191     -51.894   5.021  -1.716  1.00 12.85           C
ATOM   1625  C   THR   191     -55.730   5.173  -1.057  1.00 11.49           C
ATOM   1626  O   THR   191     -56.413   4.630  -1.920  1.00 11.57           O
ATOM   1627  N   ARG   192     -56.142   5.361   0.207  1.00 11.47           N
ATOM   1628  CA  ARG   192     -57.377   4.780   0.764  1.00 12.54           C
ATOM   1629  CB  ARG   192     -57.043   3.762   1.863  1.00 13.38           C
ATOM   1630  CG  ARG   192     -56.218   2.608   1.352  1.00 19.78           C
ATOM   1631  CD  ARG   192     -55.838   1.648   2.458  1.00 27.83           C
ATOM   1632  NE  ARG   192     -54.833   2.186   3.390  1.00 31.16           N
ATOM   1633  CZ  ARG   192     -54.979   2.196   4.710  1.00 30.70           C
ATOM   1634  NH1 ARG   192     -56.099   1.741   5.268  1.00 34.65           N
ATOM   1635  NH2 ARG   192     -54.007   2.636   5.480  1.00 31.86           N
ATOM   1636  C   ARG   192     -58.394   5.793   1.313  1.00 11.41           C
ATOM   1637  O   ARG   192     -59.513   5.408   1.694  1.00 11.66           O
ATOM   1638  N   GLY   193     -57.999   7.067   1.407  1.00 10.15           N
ATOM   1639  CA  GLY   193     -58.897   8.124   1.894  1.00  9.23           C
ATOM   1640  C   GLY   193     -59.105   8.042   3.399  1.00 10.71           C
ATOM   1641  O   GLY   193     -58.465   7.238   4.070  1.00 11.66           O
ATOM   1642  N   ILE   194     -60.015   8.848   3.940  1.00 10.09           N
ATOM   1643  CA  ILE   194     -60.233   8.806   5.378  1.00 10.51           C
ATOM   1644  CB  ILE   194     -60.410  10.235   5.966  1.00  9.22           C
ATOM   1645  CG1 ILE   194     -61.635  10.937   5.378  1.00  9.15           C
ATOM   1646  CD1 ILE   194     -62.095  12.150   6.229  1.00 10.65           C
ATOM   1647  CG2 ILE   194     -59.149  11.099   5.736  1.00 10.26           C
ATOM   1648  C   ILE   194     -61.435   7.920   5.776  1.00 13.00           C
ATOM   1649  O   ILE   194     -61.677   7.686   6.986  1.00 11.91           O
ATOM   1650  N   MET   195     -62.162   7.427   4.770  0.80 13.74           N
ATOM   1652  CA  MET   195     -63.370   6.618   5.035  0.80 19.32           C
ATOM   1654  CB  MET   195     -64.062   6.224   3.735  0.80 17.64           C
ATOM   1656  CG  MET   195     -63.224   5.251   2.910  0.80 22.42           C
ATOM   1658  SD  MET   195     -64.053   4.614   1.255  0.80 35.82          SE
ATOM   1660  CE  MET   195     -65.779   4.059   1.995  0.80 28.19           C
ATOM   1662  C   MET   195     -63.024   5.348   5.798  0.80 17.09           C
ATOM   1664  O   MET   195     -61.945   4.789   5.620  0.80 16.40           O
ATOM   1666  N   ALA   196     -63.946   4.892   6.647  1.00 16.54           N
ATOM   1667  CA  ALA   196     -63.751   3.621   7.358  1.00 17.64           C
ATOM   1668  CB  ALA   196     -64.842   3.419   8.388  1.00 17.48           C
ATOM   1669  C   ALA   196     -63.706   2.435   6.397  1.00 18.42           C
ATOM   1670  O   ALA   196     -64.469   2.403   5.437  1.00 19.76           O
END
