
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   98 (  776),  selected   98 , name 2p3h_A
# Molecule2: number of CA atoms   87 (  702),  selected   87 , name T0453.pdb
# PARAMETERS: 2p3h_A.T0453.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    E     5_A      D       5          4.392
LGA    D     6_A      E       6          0.685
LGA    I     7_A      I       7          1.107
LGA    T     8_A      V       8          1.181
LGA    E     9_A      Q       9          2.000
LGA    T    10_A      R      10          1.853
LGA    S    11_A      E      11          3.341
LGA    P    12_A      D      12          5.690
LGA    D    13_A      G      13          3.991
LGA    K    14_A      S      14          1.591
LGA    W    15_A      W      15          0.844
LGA    L    16_A      L      16          0.785
LGA    I    17_A      V      17          0.755
LGA    D    18_A      D      18          0.395
LGA    G    19_A      G      19          1.038
LGA    D    20_A      M      20          0.784
LGA    T    21_A      V      21          0.772
LGA    P    22_A      S      22          0.642
LGA    L    23_A      L      23          0.947
LGA    D    24_A      D      24          1.438
LGA    E    25_A      R      25          1.554
LGA    V    26_A      F      26          1.461
LGA    E    27_A      R      27          1.533
LGA    R    28_A      E      28          2.502
LGA    A    29_A      F      29          2.615
LGA    I    30_A      F      30          1.745
LGA    G    31_A      E      31          1.851
LGA    Y    32_A      L      32          1.518
LGA    E    33_A      E      33          3.622
LGA    -       -      A      34           -
LGA    L    34_A      P      35          3.367
LGA    P    35_A      L      36          2.523
LGA    -       -      P      37           -
LGA    -       -      G      38           -
LGA    E    36_A      E      39          2.051
LGA    G    37_A      A      40          3.459
LGA    -       -      G      41           -
LGA    -       -      G      42           -
LGA    D    38_A      N      43          2.252
LGA    Y    39_A      I      44          0.517
LGA    E    40_A      H      45          0.189
LGA    T    41_A      T      46          0.296
LGA    I    42_A      L      47          0.334
LGA    S    43_A      A      48          0.781
LGA    G    44_A      G      49          0.405
LGA    L    45_A      V      50          0.947
LGA    L    46_A      M      51          1.283
LGA    F    47_A      L      52          1.043
LGA    D    48_A      Y      53          1.124
LGA    H    49_A      Q      54          1.758
LGA    A    50_A      L      55          2.164
LGA    N    51_A      G      56          3.423
LGA    A    52_A      R      57          4.257
LGA    L    53_A      V      58          1.946
LGA    L    54_A      P      59          0.895
LGA    K    55_A      S      60          1.009
LGA    T    56_A      V      61          1.024
LGA    G    57_A      T      62          1.320
LGA    D    58_A      D      63          0.923
LGA    V    59_A      R      64          0.988
LGA    I    60_A      F      65          2.051
LGA    E    61_A      E      66          1.839
LGA    I    62_A      W      67          2.016
LGA    P    63_A      N      68          2.311
LGA    L    64_A      -       -           -
LGA    D    65_A      -       -           -
LGA    F    66_A      -       -           -
LGA    E    67_A      -       -           -
LGA    P    68_A      -       -           -
LGA    E    69_A      -       -           -
LGA    D    70_A      -       -           -
LGA    Y    71_A      -       -           -
LGA    L    72_A      -       -           -
LGA    N    73_A      -       -           -
LGA    N    74_A      -       -           -
LGA    T    75_A      -       -           -
LGA    S    76_A      -       -           -
LGA    P    77_A      -       -           -
LGA    T    78_A      -       -           -
LGA    Q    79_A      -       -           -
LGA    R    80_A      -       -           -
LGA    I    81_A      G      69          1.834
LGA    L    82_A      F      70          1.268
LGA    R    83_A      S      71          0.508
LGA    I    84_A      F      72          0.814
LGA    T    85_A      E      73          0.971
LGA    V    86_A      V      74          0.667
LGA    L    87_A      V      75          0.864
LGA    E    88_A      D      76          0.702
LGA    V    89_A      M      77          0.252
LGA    E    90_A      D      78          0.650
LGA    R    91_A      R      79          2.522
LGA    N    92_A      T      80          0.833
LGA    V    93_A      R      81          1.686
LGA    P    94_A      V      82          1.054
LGA    V    95_A      D      83          0.574
LGA    K    96_A      K      84          0.887
LGA    L    97_A      I      85          0.899
LGA    A    98_A      L      86          0.564
LGA    L    99_A      V      87          0.402
LGA    A   100_A      Q      88          0.740
LGA    L   101_A      R      89          0.805
LGA    L   102_A      H      90          1.736
LGA    -       -      H      91           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   98   87    5.0     81    1.85    19.75     84.523     4.148

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.071916 * X  +  -0.501053 * Y  +  -0.862423 * Z  +  22.606682
  Y_new =  -0.984431 * X  +  -0.174699 * Y  +   0.019407 * Z  +   8.771723
  Z_new =  -0.160388 * X  +   0.847600 * Y  +  -0.505816 * Z  +  32.655006 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.108832   -1.032761  [ DEG:   120.8272    -59.1728 ]
  Theta =   0.161084    2.980509  [ DEG:     9.2294    170.7706 ]
  Phi   =  -1.497872    1.643720  [ DEG:   -85.8218     94.1782 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2p3h_A                                        
REMARK     2: T0453.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2p3h_A.T0453.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   98   87   5.0   81   1.85   19.75  84.523
REMARK  ---------------------------------------------------------- 
MOLECULE 2p3h_A
HEADER    TRANSPORT PROTEIN                       08-MAR-07   2P3H              
TITLE     CRYSTAL STRUCTURE OF THE CORC_HLYC DOMAIN OF A PUTATIVE               
TITLE    2 CORYNEBACTERIUM GLUTAMICUM HEMOLYSIN                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UNCHARACTERIZED CBS DOMAIN-CONTAINING PROTEIN;             
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: CORC_HLYC DOMAIN: RESIDUES 356-453;                        
COMPND   5 SYNONYM: MEMBRANE PROTEIN CONTAINING CBS DOMAIN, PUTATIVE            
COMPND   6 HEMOLYSIN;                                                           
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: CORYNEBACTERIUM GLUTAMICUM;                     
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: DSM 20300, JCM 1318, LMG 3730, NCIMB 10025;                  
SOURCE   5 ATCC: 13032;                                                         
SOURCE   6 GENE: TLYC, CGL1194, CG1349;                                         
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   9 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE  10 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    STRUCTURAL GENOMICS, CORC_HLYC, PFAM03471, PUTATIVE                   
KEYWDS   2 TRANSPORT PROTEIN, TRANSPORTER ASSOCIATED DOMAIN,                    
KEYWDS   3 CORYNEBACTERIUM GLUTAMICUM, PSI-2, PROTEIN STRUCTURE                 
KEYWDS   4 INITIATIVE, MIDWEST CENTER FOR STRUCTURAL GENOMICS, MCSG             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.E.CUFF,L.VOLKART,M.GU,A.JOACHIMIAK,MIDWEST CENTER FOR               
AUTHOR   2 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   1   10-APR-07 2P3H    0                                                
JRNL        AUTH   M.E.CUFF,L.VOLKART,M.GU,A.JOACHIMIAK                         
JRNL        TITL   STRUCTURE OF THE CORC_HLYC DOMAIN OF A PUTATIVE              
JRNL        TITL 2 CORYNEBACTERIUM GLUTAMICUM HEMOLYSIN.                        
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  2P3H A    5   102  UNP    Q8NR63   Q8NR63_CORGL   356    453             
SEQRES   1 A  101  SER ASN ALA GLU ASP ILE THR GLU THR SER PRO ASP LYS          
SEQRES   2 A  101  TRP LEU ILE ASP GLY ASP THR PRO LEU ASP GLU VAL GLU          
SEQRES   3 A  101  ARG ALA ILE GLY TYR GLU LEU PRO GLU GLY ASP TYR GLU          
SEQRES   4 A  101  THR ILE SER GLY LEU LEU PHE ASP HIS ALA ASN ALA LEU          
SEQRES   5 A  101  LEU LYS THR GLY ASP VAL ILE GLU ILE PRO LEU ASP PHE          
SEQRES   6 A  101  GLU PRO GLU ASP TYR LEU ASN ASN THR SER PRO THR GLN          
SEQRES   7 A  101  ARG ILE LEU ARG ILE THR VAL LEU GLU VAL GLU ARG ASN          
SEQRES   8 A  101  VAL PRO VAL LYS LEU ALA LEU ALA LEU LEU                      
HET     BR    201       1                                                       
HET     BR    202       1                                                       
HET     BR    203       1                                                       
HET     BR    204       1                                                       
HET     BR    205       1                                                       
HET     BR    206       1                                                       
HET     BR    207       1                                                       
HET     BR    208       1                                                       
HET     BR    209       1                                                       
HET    EDO    301       4                                                       
HET    EDO    302       4                                                       
HET    EDO    303       4                                                       
HETNAM      BR BROMIDE ION                                                      
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   2   BR    9(BR 1-)                                                     
FORMUL  11  EDO    3(C2 H6 O2)                                                  
FORMUL  14  HOH   *172(H2 O)                                                    
CRYST1   51.200   51.214  101.799  90.00  90.00  90.00 C 2 2 21      8          
ATOM      1  N   GLU A   5      13.033   3.098  29.597  1.00 44.27           N  
ATOM      2  CA  GLU A   5      12.286   4.229  28.979  1.00 43.33           C  
ATOM      3  C   GLU A   5      12.768   4.380  27.544  1.00 41.73           C  
ATOM      4  O   GLU A   5      12.879   3.389  26.801  1.00 42.99           O  
ATOM      5  CB  GLU A   5      12.507   5.549  29.742  1.00 43.96           C  
ATOM      6  CG  GLU A   5      13.208   5.440  31.085  1.00 48.50           C  
ATOM      7  CD  GLU A   5      14.713   5.253  30.962  1.00 52.15           C  
ATOM      8  OE1 GLU A   5      15.446   6.252  31.136  1.00 55.06           O  
ATOM      9  OE2 GLU A   5      15.155   4.109  30.690  1.00 54.25           O  
ATOM     10  N   ASP A   6      13.088   5.623  27.187  0.50 40.86           N  
ATOM     12  CA  ASP A   6      13.416   6.032  25.829  0.50 38.81           C  
ATOM     14  C   ASP A   6      14.748   5.504  25.305  0.50 37.27           C  
ATOM     16  O   ASP A   6      14.888   5.282  24.105  0.50 36.28           O  
ATOM     18  CB  ASP A   6      13.459   7.562  25.769  0.50 39.36           C  
ATOM     20  CG  ASP A   6      12.154   8.177  25.348  0.50 40.74           C  
ATOM     22  OD1 ASP A   6      12.183   9.367  24.976  0.50 42.39           O  
ATOM     24  OD2 ASP A   6      11.100   7.504  25.382  0.50 43.80           O  
ATOM     26  N   ILE A   7      15.714   5.325  26.204  1.00 35.47           N  
ATOM     27  CA  ILE A   7      17.133   5.053  25.827  1.00 34.17           C  
ATOM     28  C   ILE A   7      17.674   3.847  26.611  1.00 33.04           C  
ATOM     29  O   ILE A   7      17.472   3.760  27.820  1.00 31.52           O  
ATOM     30  CB  ILE A   7      18.059   6.270  26.117  1.00 34.70           C  
ATOM     31  CG1 ILE A   7      17.669   7.493  25.264  1.00 34.09           C  
ATOM     32  CG2 ILE A   7      19.553   5.923  25.853  1.00 34.00           C  
ATOM     33  CD1 ILE A   7      18.463   8.758  25.596  1.00 33.94           C  
ATOM     34  N   THR A   8      18.319   2.924  25.900  1.00 32.33           N  
ATOM     35  CA  THR A   8      19.022   1.808  26.530  1.00 33.05           C  
ATOM     36  C   THR A   8      20.456   1.813  26.016  1.00 33.29           C  
ATOM     37  O   THR A   8      20.652   1.745  24.792  1.00 31.67           O  
ATOM     38  CB  THR A   8      18.393   0.438  26.126  1.00 33.95           C  
ATOM     39  OG1 THR A   8      16.999   0.413  26.428  1.00 31.54           O  
ATOM     40  CG2 THR A   8      19.097  -0.723  26.811  1.00 33.15           C  
ATOM     41  N   GLU A   9      21.446   1.880  26.918  1.00 33.82           N  
ATOM     42  CA  GLU A   9      22.848   1.674  26.476  1.00 34.59           C  
ATOM     43  C   GLU A   9      23.001   0.174  26.292  1.00 33.20           C  
ATOM     44  O   GLU A   9      22.843  -0.578  27.240  1.00 33.66           O  
ATOM     45  CB  GLU A   9      23.915   2.205  27.460  1.00 34.60           C  
ATOM     46  CG  GLU A   9      25.318   2.376  26.759  1.00 36.10           C  
ATOM     47  CD  GLU A   9      26.442   2.955  27.638  1.00 38.79           C  
ATOM     48  OE1 GLU A   9      26.231   3.075  28.869  1.00 42.77           O  
ATOM     49  OE2 GLU A   9      27.536   3.301  27.078  1.00 42.66           O  
ATOM     50  N   THR A  10      23.279  -0.257  25.064  1.00 32.19           N  
ATOM     51  CA  THR A  10      23.282  -1.688  24.760  1.00 30.95           C  
ATOM     52  C   THR A  10      24.677  -2.316  24.821  1.00 30.93           C  
ATOM     53  O   THR A  10      24.790  -3.510  25.104  1.00 30.51           O  
ATOM     54  CB  THR A  10      22.603  -1.970  23.412  1.00 30.99           C  
ATOM     55  OG1 THR A  10      23.245  -1.201  22.394  1.00 32.42           O  
ATOM     56  CG2 THR A  10      21.106  -1.517  23.464  1.00 32.07           C  
ATOM     57  N   SER A  11      25.716  -1.515  24.552  1.00 30.30           N  
ATOM     58  CA  SER A  11      27.109  -1.889  24.790  1.00 30.70           C  
ATOM     59  C   SER A  11      27.859  -0.546  24.913  1.00 31.29           C  
ATOM     60  O   SER A  11      27.240   0.509  24.685  1.00 31.86           O  
ATOM     61  CB  SER A  11      27.672  -2.716  23.617  1.00 30.86           C  
ATOM     62  OG  SER A  11      27.814  -1.896  22.468  1.00 31.93           O  
ATOM     63  N   PRO A  12      29.148  -0.564  25.297  1.00 30.75           N  
ATOM     64  CA  PRO A  12      29.846   0.716  25.430  1.00 31.26           C  
ATOM     65  C   PRO A  12      29.751   1.562  24.175  1.00 31.73           C  
ATOM     66  O   PRO A  12      30.042   1.078  23.063  1.00 31.16           O  
ATOM     67  CB  PRO A  12      31.303   0.302  25.733  1.00 30.58           C  
ATOM     68  CG  PRO A  12      31.145  -1.056  26.407  1.00 31.35           C  
ATOM     69  CD  PRO A  12      30.018  -1.704  25.680  1.00 30.58           C  
ATOM     70  N   ASP A  13      29.257   2.788  24.350  1.00 32.11           N  
ATOM     71  CA  ASP A  13      29.174   3.761  23.253  1.00 33.23           C  
ATOM     72  C   ASP A  13      28.168   3.323  22.185  1.00 31.88           C  
ATOM     73  O   ASP A  13      28.268   3.736  21.032  1.00 31.95           O  
ATOM     74  CB  ASP A  13      30.562   4.003  22.610  1.00 33.88           C  
ATOM     75  CG  ASP A  13      31.527   4.711  23.539  1.00 39.55           C  
ATOM     76  OD1 ASP A  13      31.079   5.492  24.405  1.00 41.22           O  
ATOM     77  OD2 ASP A  13      32.745   4.468  23.394  1.00 45.51           O  
ATOM     78  N   LYS A  14      27.188   2.495  22.568  1.00 30.42           N  
ATOM     79  CA  LYS A  14      26.086   2.151  21.657  1.00 30.43           C  
ATOM     80  C   LYS A  14      24.754   2.137  22.403  1.00 29.47           C  
ATOM     81  O   LYS A  14      24.704   1.749  23.579  1.00 28.95           O  
ATOM     82  CB  LYS A  14      26.310   0.789  20.983  1.00 30.82           C  
ATOM     83  CG  LYS A  14      27.491   0.767  19.986  1.00 33.12           C  
ATOM     84  CD  LYS A  14      27.544  -0.582  19.256  1.00 32.97           C  
ATOM     85  CE  LYS A  14      28.802  -0.698  18.418  1.00 38.19           C  
ATOM     86  NZ  LYS A  14      28.816  -2.037  17.700  1.00 40.12           N  
ATOM     87  N   TRP A  15      23.693   2.579  21.720  1.00 29.77           N  
ATOM     88  CA  TRP A  15      22.364   2.727  22.319  1.00 30.09           C  
ATOM     89  C   TRP A  15      21.279   2.316  21.326  1.00 30.23           C  
ATOM     90  O   TRP A  15      21.446   2.407  20.102  1.00 29.77           O  
ATOM     91  CB  TRP A  15      22.092   4.191  22.741  1.00 29.97           C  
ATOM     92  CG  TRP A  15      23.113   4.750  23.680  1.00 29.29           C  
ATOM     93  CD1 TRP A  15      23.030   4.829  25.056  1.00 29.07           C  
ATOM     94  CD2 TRP A  15      24.375   5.325  23.313  1.00 30.25           C  
ATOM     95  NE1 TRP A  15      24.193   5.405  25.546  1.00 29.76           N  
ATOM     96  CE2 TRP A  15      25.016   5.720  24.490  1.00 30.76           C  
ATOM     97  CE3 TRP A  15      25.027   5.535  22.081  1.00 31.35           C  
ATOM     98  CZ2 TRP A  15      26.288   6.310  24.482  1.00 29.20           C  
ATOM     99  CZ3 TRP A  15      26.285   6.136  22.086  1.00 29.74           C  
ATOM    100  CH2 TRP A  15      26.890   6.518  23.275  1.00 29.81           C  
ATOM    101  N   LEU A  16      20.167   1.840  21.873  1.00 30.14           N  
ATOM    102  CA  LEU A  16      18.929   1.680  21.130  1.00 30.57           C  
ATOM    103  C   LEU A  16      18.022   2.731  21.726  1.00 31.09           C  
ATOM    104  O   LEU A  16      17.851   2.763  22.957  1.00 31.29           O  
ATOM    105  CB  LEU A  16      18.321   0.281  21.407  1.00 30.25           C  
ATOM    106  CG  LEU A  16      16.941   0.065  20.727  1.00 31.12           C  
ATOM    107  CD1 LEU A  16      17.019   0.122  19.206  1.00 35.10           C  
ATOM    108  CD2 LEU A  16      16.315  -1.272  21.199  1.00 31.50           C  
ATOM    109  N   ILE A  17      17.441   3.594  20.888  1.00 31.21           N  
ATOM    110  CA  ILE A  17      16.568   4.654  21.408  1.00 31.23           C  
ATOM    111  C   ILE A  17      15.285   4.764  20.602  1.00 31.91           C  
ATOM    112  O   ILE A  17      15.221   4.333  19.445  1.00 31.78           O  
ATOM    113  CB  ILE A  17      17.281   6.045  21.489  1.00 31.13           C  
ATOM    114  CG1 ILE A  17      17.423   6.673  20.090  1.00 31.45           C  
ATOM    115  CG2 ILE A  17      18.681   5.917  22.162  1.00 31.15           C  
ATOM    116  CD1 ILE A  17      18.007   8.116  20.111  1.00 32.04           C  
ATOM    117  N   ASP A  18      14.260   5.343  21.219  1.00 31.67           N  
ATOM    118  CA  ASP A  18      13.006   5.647  20.529  1.00 31.84           C  
ATOM    119  C   ASP A  18      13.148   6.786  19.525  1.00 32.41           C  
ATOM    120  O   ASP A  18      13.996   7.674  19.672  1.00 32.66           O  
ATOM    121  CB  ASP A  18      11.926   6.000  21.545  1.00 31.23           C  
ATOM    122  CG  ASP A  18      11.516   4.814  22.380  1.00 34.87           C  
ATOM    123  OD1 ASP A  18      11.899   3.679  22.031  1.00 37.23           O  
ATOM    124  OD2 ASP A  18      10.811   5.012  23.389  1.00 34.51           O  
ATOM    125  N   GLY A  19      12.279   6.772  18.525  1.00 33.83           N  
ATOM    126  CA  GLY A  19      12.341   7.766  17.454  1.00 33.07           C  
ATOM    127  C   GLY A  19      12.006   9.169  17.912  1.00 33.72           C  
ATOM    128  O   GLY A  19      12.416  10.138  17.262  1.00 34.20           O  
ATOM    129  N   ASP A  20      11.275   9.285  19.021  1.00 32.93           N  
ATOM    130  CA  ASP A  20      10.846  10.586  19.541  1.00 33.83           C  
ATOM    131  C   ASP A  20      11.651  11.038  20.756  1.00 33.39           C  
ATOM    132  O   ASP A  20      11.257  11.951  21.488  1.00 32.63           O  
ATOM    133  CB  ASP A  20       9.348  10.569  19.847  1.00 35.02           C  
ATOM    134  CG  ASP A  20       8.999   9.681  21.027  1.00 35.58           C  
ATOM    135  OD1 ASP A  20       9.873   8.945  21.538  1.00 38.27           O  
ATOM    136  OD2 ASP A  20       7.827   9.734  21.453  1.00 37.60           O  
ATOM    137  N   THR A  21      12.815  10.428  20.946  1.00 32.69           N  
ATOM    138  CA  THR A  21      13.668  10.800  22.072  1.00 32.69           C  
ATOM    139  C   THR A  21      14.090  12.274  21.997  1.00 32.33           C  
ATOM    140  O   THR A  21      14.622  12.706  20.980  1.00 33.13           O  
ATOM    141  CB  THR A  21      14.928   9.919  22.107  1.00 31.54           C  
ATOM    142  OG1 THR A  21      14.545   8.532  22.173  1.00 33.78           O  
ATOM    143  CG2 THR A  21      15.777  10.259  23.336  1.00 31.14           C  
ATOM    144  N   PRO A  22      13.854  13.035  23.073  1.00 32.99           N  
ATOM    145  CA  PRO A  22      14.266  14.440  23.087  1.00 32.98           C  
ATOM    146  C   PRO A  22      15.764  14.564  22.897  1.00 32.88           C  
ATOM    147  O   PRO A  22      16.530  13.750  23.441  1.00 32.91           O  
ATOM    148  CB  PRO A  22      13.854  14.895  24.487  1.00 32.62           C  
ATOM    149  CG  PRO A  22      12.636  13.981  24.824  1.00 33.78           C  
ATOM    150  CD  PRO A  22      13.125  12.665  24.315  1.00 33.25           C  
ATOM    151  N   LEU A  23      16.192  15.554  22.120  1.00 33.22           N  
ATOM    152  CA  LEU A  23      17.610  15.725  21.861  1.00 34.48           C  
ATOM    153  C   LEU A  23      18.443  15.970  23.105  1.00 34.36           C  
ATOM    154  O   LEU A  23      19.555  15.455  23.206  1.00 34.70           O  
ATOM    155  CB  LEU A  23      17.847  16.852  20.841  1.00 34.15           C  
ATOM    156  CG  LEU A  23      17.501  16.381  19.432  1.00 36.82           C  
ATOM    157  CD1 LEU A  23      17.450  17.555  18.472  1.00 37.17           C  
ATOM    158  CD2 LEU A  23      18.491  15.310  18.929  1.00 38.33           C  
ATOM    159  N   ASP A  24      17.936  16.743  24.064  1.00 34.72           N  
ATOM    160  CA  ASP A  24      18.759  16.924  25.280  1.00 35.14           C  
ATOM    161  C   ASP A  24      19.104  15.601  25.976  1.00 34.30           C  
ATOM    162  O   ASP A  24      20.185  15.469  26.533  1.00 33.76           O  
ATOM    163  CB  ASP A  24      18.186  17.991  26.244  1.00 35.82           C  
ATOM    164  CG  ASP A  24      16.814  17.646  26.787  1.00 39.14           C  
ATOM    165  OD1 ASP A  24      16.115  16.746  26.266  1.00 41.82           O  
ATOM    166  OD2 ASP A  24      16.421  18.311  27.768  1.00 43.62           O  
ATOM    167  N   GLU A  25      18.152  14.666  25.938  0.50 34.44           N  
ATOM    169  CA  GLU A  25      18.267  13.325  26.503  0.50 34.44           C  
ATOM    171  C   GLU A  25      19.351  12.511  25.789  0.50 34.08           C  
ATOM    173  O   GLU A  25      20.201  11.884  26.431  0.50 34.03           O  
ATOM    175  CB  GLU A  25      16.901  12.633  26.377  0.50 35.28           C  
ATOM    177  CG  GLU A  25      16.611  11.542  27.386  0.50 37.31           C  
ATOM    179  CD  GLU A  25      15.116  11.371  27.637  0.50 39.71           C  
ATOM    181  OE1 GLU A  25      14.477  12.318  28.161  0.50 41.65           O  
ATOM    183  OE2 GLU A  25      14.578  10.284  27.314  0.50 39.80           O  
ATOM    185  N   VAL A  26      19.316  12.537  24.462  1.00 33.10           N  
ATOM    186  CA  VAL A  26      20.348  11.887  23.629  1.00 32.36           C  
ATOM    187  C   VAL A  26      21.729  12.482  23.956  1.00 32.24           C  
ATOM    188  O   VAL A  26      22.713  11.750  24.096  1.00 32.36           O  
ATOM    189  CB  VAL A  26      20.053  12.037  22.110  1.00 32.50           C  
ATOM    190  CG1 VAL A  26      21.182  11.404  21.281  1.00 31.48           C  
ATOM    191  CG2 VAL A  26      18.698  11.377  21.752  1.00 32.13           C  
ATOM    192  N   GLU A  27      21.821  13.812  23.995  1.00 32.07           N  
ATOM    193  CA  GLU A  27      23.092  14.462  24.327  1.00 32.00           C  
ATOM    194  C   GLU A  27      23.655  14.018  25.686  1.00 32.72           C  
ATOM    195  O   GLU A  27      24.849  13.744  25.811  1.00 31.86           O  
ATOM    196  CB  GLU A  27      22.942  15.986  24.262  1.00 32.99           C  
ATOM    197  CG  GLU A  27      22.621  16.492  22.868  1.00 32.92           C  
ATOM    198  CD  GLU A  27      22.381  17.989  22.845  1.00 35.29           C  
ATOM    199  OE1 GLU A  27      22.036  18.571  23.905  1.00 37.29           O  
ATOM    200  OE2 GLU A  27      22.551  18.591  21.767  1.00 35.53           O  
ATOM    201  N   ARG A  28      22.791  13.932  26.703  1.00 33.20           N  
ATOM    202  CA  ARG A  28      23.200  13.482  28.032  1.00 35.02           C  
ATOM    203  C   ARG A  28      23.746  12.045  27.956  1.00 34.28           C  
ATOM    204  O   ARG A  28      24.773  11.715  28.583  1.00 35.21           O  
ATOM    205  CB  ARG A  28      21.992  13.569  28.996  1.00 34.57           C  
ATOM    206  CG  ARG A  28      22.304  13.920  30.435  1.00 39.44           C  
ATOM    207  CD  ARG A  28      21.170  14.803  31.119  1.00 38.66           C  
ATOM    208  NE  ARG A  28      19.770  14.421  30.786  1.00 45.96           N  
ATOM    209  CZ  ARG A  28      18.842  15.214  30.215  1.00 43.66           C  
ATOM    210  NH1 ARG A  28      19.099  16.466  29.872  1.00 46.07           N  
ATOM    211  NH2 ARG A  28      17.637  14.747  29.973  1.00 43.30           N  
ATOM    212  N   ALA A  29      23.081  11.197  27.173  1.00 33.02           N  
ATOM    213  CA  ALA A  29      23.467   9.782  27.047  1.00 32.78           C  
ATOM    214  C   ALA A  29      24.810   9.608  26.364  1.00 32.62           C  
ATOM    215  O   ALA A  29      25.661   8.860  26.835  1.00 33.20           O  
ATOM    216  CB  ALA A  29      22.394   8.986  26.282  1.00 32.97           C  
ATOM    217  N   ILE A  30      25.007  10.316  25.262  1.00 32.08           N  
ATOM    218  CA  ILE A  30      26.201  10.094  24.454  1.00 33.37           C  
ATOM    219  C   ILE A  30      27.394  10.944  24.917  1.00 33.82           C  
ATOM    220  O   ILE A  30      28.540  10.674  24.514  1.00 34.36           O  
ATOM    221  CB  ILE A  30      25.918  10.298  22.963  1.00 32.75           C  
ATOM    222  CG1 ILE A  30      25.728  11.784  22.632  1.00 33.56           C  
ATOM    223  CG2 ILE A  30      24.653   9.476  22.542  1.00 34.69           C  
ATOM    224  CD1 ILE A  30      25.379  12.025  21.161  1.00 33.48           C  
ATOM    225  N   GLY A  31      27.117  11.948  25.751  1.00 34.13           N  
ATOM    226  CA  GLY A  31      28.181  12.807  26.318  1.00 34.90           C  
ATOM    227  C   GLY A  31      28.690  13.921  25.405  1.00 35.23           C  
ATOM    228  O   GLY A  31      29.751  14.509  25.666  1.00 36.18           O  
ATOM    229  N   TYR A  32      27.937  14.231  24.354  1.00 34.60           N  
ATOM    230  CA  TYR A  32      28.296  15.237  23.344  0.50 34.38           C  
ATOM    232  C   TYR A  32      27.035  16.004  22.950  1.00 34.13           C  
ATOM    233  O   TYR A  32      25.971  15.408  22.898  1.00 34.62           O  
ATOM    234  CB  TYR A  32      28.775  14.556  22.059  0.50 34.58           C  
ATOM    236  CG  TYR A  32      30.168  13.969  22.050  0.50 35.16           C  
ATOM    238  CD1 TYR A  32      30.392  12.644  22.414  0.50 34.32           C  
ATOM    240  CD2 TYR A  32      31.253  14.725  21.604  0.50 35.37           C  
ATOM    242  CE1 TYR A  32      31.696  12.095  22.373  0.50 35.49           C  
ATOM    244  CE2 TYR A  32      32.543  14.191  21.555  0.50 36.34           C  
ATOM    246  CZ  TYR A  32      32.753  12.882  21.938  0.50 35.90           C  
ATOM    248  OH  TYR A  32      34.027  12.381  21.887  0.50 36.83           O  
ATOM    250  N   GLU A  33      27.176  17.269  22.571  1.00 33.43           N  
ATOM    251  CA  GLU A  33      26.071  18.008  21.969  1.00 32.93           C  
ATOM    252  C   GLU A  33      25.925  17.731  20.481  1.00 32.85           C  
ATOM    253  O   GLU A  33      26.897  17.529  19.759  1.00 32.25           O  
ATOM    254  CB  GLU A  33      26.213  19.495  22.246  1.00 33.27           C  
ATOM    255  CG  GLU A  33      26.093  19.772  23.741  1.00 35.44           C  
ATOM    256  CD  GLU A  33      25.922  21.229  24.094  1.00 39.26           C  
ATOM    257  OE1 GLU A  33      25.052  21.905  23.494  1.00 43.65           O  
ATOM    258  OE2 GLU A  33      26.631  21.681  25.014  1.00 39.98           O  
ATOM    259  N   LEU A  34      24.669  17.719  20.047  1.00 32.19           N  
ATOM    260  CA  LEU A  34      24.316  17.562  18.653  1.00 32.76           C  
ATOM    261  C   LEU A  34      23.992  18.917  18.027  1.00 33.34           C  
ATOM    262  O   LEU A  34      23.711  19.862  18.756  1.00 33.13           O  
ATOM    263  CB  LEU A  34      23.109  16.618  18.551  1.00 31.88           C  
ATOM    264  CG  LEU A  34      23.476  15.120  18.677  1.00 34.42           C  
ATOM    265  CD1 LEU A  34      22.259  14.336  19.207  1.00 38.21           C  
ATOM    266  CD2 LEU A  34      23.978  14.591  17.355  1.00 35.82           C  
ATOM    267  N   PRO A  35      24.049  19.028  16.685  1.00 34.68           N  
ATOM    268  CA  PRO A  35      23.623  20.285  16.031  1.00 35.73           C  
ATOM    269  C   PRO A  35      22.193  20.699  16.411  1.00 36.70           C  
ATOM    270  O   PRO A  35      21.332  19.849  16.553  1.00 37.35           O  
ATOM    271  CB  PRO A  35      23.703  19.962  14.541  1.00 36.20           C  
ATOM    272  CG  PRO A  35      24.610  18.768  14.431  1.00 36.84           C  
ATOM    273  CD  PRO A  35      24.561  18.029  15.719  1.00 34.67           C  
ATOM    274  N   GLU A  36      21.956  21.992  16.621  1.00 36.99           N  
ATOM    275  CA  GLU A  36      20.628  22.476  16.961  1.00 38.45           C  
ATOM    276  C   GLU A  36      19.995  23.067  15.730  1.00 38.15           C  
ATOM    277  O   GLU A  36      20.688  23.520  14.815  1.00 38.06           O  
ATOM    278  CB  GLU A  36      20.683  23.526  18.081  1.00 38.96           C  
ATOM    279  CG  GLU A  36      21.358  22.985  19.315  1.00 42.77           C  
ATOM    280  CD  GLU A  36      20.903  23.633  20.602  1.00 47.42           C  
ATOM    281  OE1 GLU A  36      20.502  24.820  20.587  1.00 49.24           O  
ATOM    282  OE2 GLU A  36      20.963  22.941  21.642  1.00 49.52           O  
ATOM    283  N   GLY A  37      18.673  23.054  15.700  1.00 38.09           N  
ATOM    284  CA  GLY A  37      17.949  23.536  14.538  1.00 37.70           C  
ATOM    285  C   GLY A  37      16.475  23.580  14.813  1.00 38.05           C  
ATOM    286  O   GLY A  37      16.049  23.648  15.966  1.00 37.90           O  
ATOM    287  N   ASP A  38      15.688  23.542  13.747  1.00 37.86           N  
ATOM    288  CA  ASP A  38      14.243  23.602  13.874  1.00 38.25           C  
ATOM    289  C   ASP A  38      13.707  22.197  14.143  1.00 37.37           C  
ATOM    290  O   ASP A  38      13.030  21.598  13.292  1.00 37.74           O  
ATOM    291  CB  ASP A  38      13.645  24.208  12.600  1.00 38.17           C  
ATOM    292  CG  ASP A  38      12.161  24.512  12.722  1.00 41.06           C  
ATOM    293  OD1 ASP A  38      11.621  24.565  13.854  1.00 41.65           O  
ATOM    294  OD2 ASP A  38      11.529  24.704  11.657  1.00 43.73           O  
ATOM    295  N   TYR A  39      14.016  21.663  15.326  1.00 35.76           N  
ATOM    296  CA  TYR A  39      13.611  20.308  15.716  1.00 35.23           C  
ATOM    297  C   TYR A  39      13.953  20.106  17.181  1.00 34.66           C  
ATOM    298  O   TYR A  39      14.787  20.852  17.727  1.00 34.75           O  
ATOM    299  CB  TYR A  39      14.313  19.240  14.846  1.00 35.96           C  
ATOM    300  CG  TYR A  39      15.787  19.514  14.629  1.00 35.45           C  
ATOM    301  CD1 TYR A  39      16.706  19.266  15.640  1.00 36.36           C  
ATOM    302  CD2 TYR A  39      16.253  20.060  13.422  1.00 36.11           C  
ATOM    303  CE1 TYR A  39      18.070  19.541  15.463  1.00 35.19           C  
ATOM    304  CE2 TYR A  39      17.623  20.333  13.229  1.00 36.70           C  
ATOM    305  CZ  TYR A  39      18.518  20.069  14.266  1.00 38.18           C  
ATOM    306  OH  TYR A  39      19.867  20.315  14.120  1.00 37.00           O  
ATOM    307  N   GLU A  40      13.323  19.116  17.815  1.00 33.84           N  
ATOM    308  CA  GLU A  40      13.568  18.866  19.238  0.50 33.58           C  
ATOM    310  C   GLU A  40      13.750  17.387  19.581  1.00 33.45           C  
ATOM    311  O   GLU A  40      14.164  17.058  20.697  1.00 34.10           O  
ATOM    312  CB  GLU A  40      12.478  19.510  20.114  0.50 33.77           C  
ATOM    314  CG  GLU A  40      11.112  18.872  19.989  0.50 31.80           C  
ATOM    316  CD  GLU A  40      10.056  19.533  20.861  0.50 34.05           C  
ATOM    318  OE1 GLU A  40      10.005  20.780  20.917  0.50 32.49           O  
ATOM    320  OE2 GLU A  40       9.264  18.789  21.478  0.50 33.23           O  
ATOM    322  N   THR A  41      13.492  16.497  18.624  1.00 33.11           N  
ATOM    323  CA  THR A  41      13.702  15.060  18.838  1.00 32.19           C  
ATOM    324  C   THR A  41      14.747  14.510  17.900  1.00 32.25           C  
ATOM    325  O   THR A  41      15.062  15.125  16.869  1.00 31.21           O  
ATOM    326  CB  THR A  41      12.421  14.184  18.651  1.00 32.97           C  
ATOM    327  OG1 THR A  41      12.046  14.125  17.267  1.00 32.95           O  
ATOM    328  CG2 THR A  41      11.252  14.675  19.501  1.00 34.43           C  
ATOM    329  N   ILE A  42      15.248  13.329  18.245  1.00 32.05           N  
ATOM    330  CA  ILE A  42      16.234  12.657  17.386  1.00 32.69           C  
ATOM    331  C   ILE A  42      15.729  12.521  15.931  1.00 33.12           C  
ATOM    332  O   ILE A  42      16.476  12.822  14.987  1.00 33.34           O  
ATOM    333  CB  ILE A  42      16.734  11.316  18.010  1.00 32.98           C  
ATOM    334  CG1 ILE A  42      17.904  10.753  17.199  1.00 32.40           C  
ATOM    335  CG2 ILE A  42      15.622  10.281  18.085  1.00 33.10           C  
ATOM    336  CD1 ILE A  42      19.146  11.750  17.062  1.00 34.52           C  
ATOM    337  N   SER A  43      14.469  12.118  15.737  1.00 32.63           N  
ATOM    338  CA  SER A  43      13.963  11.981  14.353  1.00 32.77           C  
ATOM    339  C   SER A  43      13.890  13.306  13.622  1.00 33.16           C  
ATOM    340  O   SER A  43      14.158  13.382  12.419  1.00 32.70           O  
ATOM    341  CB  SER A  43      12.620  11.249  14.315  1.00 33.21           C  
ATOM    342  OG  SER A  43      12.842   9.890  14.629  1.00 34.27           O  
ATOM    343  N   GLY A  44      13.529  14.361  14.351  1.00 32.51           N  
ATOM    344  CA  GLY A  44      13.468  15.694  13.761  1.00 33.43           C  
ATOM    345  C   GLY A  44      14.837  16.082  13.216  1.00 33.22           C  
ATOM    346  O   GLY A  44      14.943  16.665  12.116  1.00 33.47           O  
ATOM    347  N   LEU A  45      15.879  15.784  13.991  1.00 32.71           N  
ATOM    348  CA  LEU A  45      17.266  16.047  13.557  0.50 32.66           C  
ATOM    350  C   LEU A  45      17.588  15.255  12.286  1.00 33.11           C  
ATOM    351  O   LEU A  45      18.155  15.784  11.328  1.00 33.75           O  
ATOM    352  CB  LEU A  45      18.245  15.679  14.682  0.50 31.83           C  
ATOM    354  CG  LEU A  45      19.744  15.607  14.356  0.50 31.38           C  
ATOM    356  CD1 LEU A  45      20.300  16.982  13.937  0.50 30.44           C  
ATOM    358  CD2 LEU A  45      20.490  15.061  15.547  0.50 30.48           C  
ATOM    360  N   LEU A  46      17.245  13.966  12.302  1.00 34.79           N  
ATOM    361  CA  LEU A  46      17.469  13.077  11.158  1.00 34.59           C  
ATOM    362  C   LEU A  46      16.772  13.569   9.895  1.00 35.35           C  
ATOM    363  O   LEU A  46      17.404  13.645   8.829  1.00 34.12           O  
ATOM    364  CB  LEU A  46      17.015  11.654  11.486  1.00 34.96           C  
ATOM    365  CG  LEU A  46      17.783  10.895  12.556  1.00 36.41           C  
ATOM    366  CD1 LEU A  46      17.207   9.491  12.685  1.00 37.71           C  
ATOM    367  CD2 LEU A  46      19.290  10.865  12.263  1.00 37.22           C  
ATOM    368  N   PHE A  47      15.491  13.937  10.003  1.00 34.09           N  
ATOM    369  CA  PHE A  47      14.794  14.496   8.848  1.00 34.41           C  
ATOM    370  C   PHE A  47      15.456  15.771   8.352  1.00 35.83           C  
ATOM    371  O   PHE A  47      15.598  15.977   7.141  1.00 35.47           O  
ATOM    372  CB  PHE A  47      13.316  14.781   9.160  1.00 34.29           C  
ATOM    373  CG  PHE A  47      12.430  13.564   9.110  1.00 33.08           C  
ATOM    374  CD1 PHE A  47      12.222  12.880   7.913  1.00 34.51           C  
ATOM    375  CD2 PHE A  47      11.753  13.127  10.255  1.00 31.96           C  
ATOM    376  CE1 PHE A  47      11.369  11.758   7.862  1.00 34.47           C  
ATOM    377  CE2 PHE A  47      10.907  12.000  10.218  1.00 33.79           C  
ATOM    378  CZ  PHE A  47      10.710  11.323   9.006  1.00 34.08           C  
ATOM    379  N   ASP A  48      15.848  16.636   9.286  1.00 35.87           N  
ATOM    380  CA  ASP A  48      16.509  17.878   8.908  1.00 37.60           C  
ATOM    381  C   ASP A  48      17.835  17.620   8.158  1.00 38.46           C  
ATOM    382  O   ASP A  48      18.076  18.219   7.101  1.00 38.78           O  
ATOM    383  CB  ASP A  48      16.712  18.741  10.147  1.00 36.78           C  
ATOM    384  CG  ASP A  48      17.216  20.128   9.808  1.00 38.97           C  
ATOM    385  OD1 ASP A  48      16.399  21.048   9.702  1.00 37.56           O  
ATOM    386  OD2 ASP A  48      18.430  20.274   9.623  1.00 38.72           O  
ATOM    387  N   HIS A  49      18.668  16.724   8.692  1.00 39.94           N  
ATOM    388  CA  HIS A  49      19.981  16.355   8.113  1.00 41.80           C  
ATOM    389  C   HIS A  49      19.865  15.662   6.742  1.00 42.42           C  
ATOM    390  O   HIS A  49      20.558  16.031   5.781  1.00 43.09           O  
ATOM    391  CB  HIS A  49      20.743  15.447   9.098  1.00 42.35           C  
ATOM    392  CG  HIS A  49      22.166  15.166   8.705  1.00 43.87           C  
ATOM    393  ND1 HIS A  49      23.229  15.907   9.187  1.00 46.54           N  
ATOM    394  CD2 HIS A  49      22.700  14.242   7.867  1.00 43.75           C  
ATOM    395  CE1 HIS A  49      24.355  15.446   8.666  1.00 44.53           C  
ATOM    396  NE2 HIS A  49      24.061  14.439   7.860  1.00 45.29           N  
ATOM    397  N   ALA A  50      18.998  14.652   6.651  1.00 42.36           N  
ATOM    398  CA  ALA A  50      18.820  13.908   5.404  1.00 42.18           C  
ATOM    399  C   ALA A  50      18.056  14.695   4.367  1.00 42.12           C  
ATOM    400  O   ALA A  50      18.217  14.443   3.170  1.00 42.42           O  
ATOM    401  CB  ALA A  50      18.132  12.571   5.671  1.00 42.34           C  
ATOM    402  N   ASN A  51      17.236  15.658   4.809  1.00 42.04           N  
ATOM    403  CA  ASN A  51      16.284  16.366   3.942  1.00 42.02           C  
ATOM    404  C   ASN A  51      15.592  15.431   2.928  1.00 41.57           C  
ATOM    405  O   ASN A  51      15.452  15.737   1.730  1.00 40.92           O  
ATOM    406  CB  ASN A  51      16.943  17.590   3.256  1.00 43.55           C  
ATOM    407  CG  ASN A  51      15.929  18.495   2.544  1.00 45.26           C  
ATOM    408  OD1 ASN A  51      14.748  18.556   2.910  1.00 49.38           O  
ATOM    409  ND2 ASN A  51      16.395  19.210   1.519  1.00 48.77           N  
ATOM    410  N   ALA A  52      15.163  14.282   3.437  1.00 40.76           N  
ATOM    411  CA  ALA A  52      14.545  13.236   2.649  1.00 40.25           C  
ATOM    412  C   ALA A  52      13.770  12.337   3.612  1.00 39.63           C  
ATOM    413  O   ALA A  52      13.983  12.401   4.833  1.00 39.63           O  
ATOM    414  CB  ALA A  52      15.637  12.416   1.919  1.00 40.11           C  
ATOM    415  N   LEU A  53      12.898  11.486   3.069  1.00 39.02           N  
ATOM    416  CA  LEU A  53      12.302  10.390   3.852  1.00 38.90           C  
ATOM    417  C   LEU A  53      13.363   9.425   4.427  1.00 39.92           C  
ATOM    418  O   LEU A  53      14.458   9.272   3.858  1.00 40.63           O  
ATOM    419  CB  LEU A  53      11.252   9.627   3.023  1.00 38.51           C  
ATOM    420  CG  LEU A  53       9.982  10.388   2.630  1.00 38.45           C  
ATOM    421  CD1 LEU A  53       9.170   9.595   1.622  1.00 37.14           C  
ATOM    422  CD2 LEU A  53       9.147  10.707   3.864  1.00 38.01           C  
ATOM    423  N   LEU A  54      13.048   8.822   5.577  1.00 39.18           N  
ATOM    424  CA  LEU A  54      13.980   7.943   6.290  1.00 39.49           C  
ATOM    425  C   LEU A  54      13.427   6.533   6.270  1.00 39.34           C  
ATOM    426  O   LEU A  54      12.294   6.301   6.681  1.00 40.13           O  
ATOM    427  CB  LEU A  54      14.167   8.429   7.732  1.00 38.88           C  
ATOM    428  CG  LEU A  54      14.706   9.850   7.906  1.00 39.05           C  
ATOM    429  CD1 LEU A  54      14.513  10.308   9.343  1.00 35.86           C  
ATOM    430  CD2 LEU A  54      16.180   9.953   7.513  1.00 39.64           C  
ATOM    431  N   LYS A  55      14.221   5.590   5.775  1.00 38.79           N  
ATOM    432  CA  LYS A  55      13.753   4.211   5.609  1.00 38.62           C  
ATOM    433  C   LYS A  55      14.519   3.249   6.508  1.00 38.12           C  
ATOM    434  O   LYS A  55      15.683   3.505   6.844  1.00 37.19           O  
ATOM    435  CB  LYS A  55      13.925   3.771   4.151  1.00 38.77           C  
ATOM    436  CG  LYS A  55      13.383   4.749   3.116  1.00 40.50           C  
ATOM    437  CD  LYS A  55      11.872   4.740   3.072  1.00 41.70           C  
ATOM    438  CE  LYS A  55      11.343   5.555   1.896  1.00 44.50           C  
ATOM    439  NZ  LYS A  55       9.862   5.650   1.927  1.00 41.53           N  
ATOM    440  N   THR A  56      13.886   2.143   6.896  1.00 38.06           N  
ATOM    441  CA  THR A  56      14.571   1.113   7.691  1.00 38.94           C  
ATOM    442  C   THR A  56      15.853   0.704   6.971  1.00 38.28           C  
ATOM    443  O   THR A  56      15.857   0.487   5.751  1.00 37.57           O  
ATOM    444  CB  THR A  56      13.664  -0.094   7.939  1.00 40.10           C  
ATOM    445  OG1 THR A  56      12.492   0.363   8.608  1.00 42.94           O  
ATOM    446  CG2 THR A  56      14.324  -1.124   8.813  1.00 40.62           C  
ATOM    447  N   GLY A  57      16.939   0.643   7.737  1.00 37.34           N  
ATOM    448  CA  GLY A  57      18.246   0.341   7.205  1.00 36.86           C  
ATOM    449  C   GLY A  57      19.091   1.543   6.826  1.00 36.15           C  
ATOM    450  O   GLY A  57      20.298   1.407   6.655  1.00 35.42           O  
ATOM    451  N   ASP A  58      18.477   2.718   6.674  1.00 35.72           N  
ATOM    452  CA  ASP A  58      19.247   3.944   6.367  1.00 34.93           C  
ATOM    453  C   ASP A  58      20.247   4.244   7.480  1.00 34.75           C  
ATOM    454  O   ASP A  58      19.931   4.085   8.650  1.00 33.58           O  
ATOM    455  CB  ASP A  58      18.317   5.168   6.202  1.00 34.94           C  
ATOM    456  CG  ASP A  58      17.583   5.178   4.868  1.00 38.10           C  
ATOM    457  OD1 ASP A  58      17.807   4.252   4.044  1.00 37.07           O  
ATOM    458  OD2 ASP A  58      16.795   6.121   4.640  1.00 39.23           O  
ATOM    459  N   VAL A  59      21.447   4.669   7.108  1.00 34.35           N  
ATOM    460  CA  VAL A  59      22.476   5.020   8.090  1.00 35.01           C  
ATOM    461  C   VAL A  59      22.823   6.478   7.892  1.00 35.19           C  
ATOM    462  O   VAL A  59      23.111   6.926   6.782  1.00 35.39           O  
ATOM    463  CB  VAL A  59      23.747   4.168   7.930  1.00 35.20           C  
ATOM    464  CG1 VAL A  59      24.839   4.609   8.939  1.00 36.71           C  
ATOM    465  CG2 VAL A  59      23.405   2.680   8.077  1.00 36.21           C  
ATOM    466  N   ILE A  60      22.770   7.235   8.976  1.00 34.72           N  
ATOM    467  CA  ILE A  60      23.013   8.660   8.869  1.00 36.02           C  
ATOM    468  C   ILE A  60      24.114   8.949   9.871  1.00 35.77           C  
ATOM    469  O   ILE A  60      24.017   8.546  11.009  1.00 35.08           O  
ATOM    470  CB  ILE A  60      21.759   9.480   9.239  1.00 36.54           C  
ATOM    471  CG1 ILE A  60      20.648   9.257   8.203  1.00 38.78           C  
ATOM    472  CG2 ILE A  60      22.072  10.970   9.326  1.00 37.36           C  
ATOM    473  CD1 ILE A  60      19.682   8.187   8.620  1.00 43.87           C  
ATOM    474  N   GLU A  61      25.147   9.646   9.434  1.00 33.84           N  
ATOM    475  CA  GLU A  61      26.235   9.995  10.338  1.00 34.71           C  
ATOM    476  C   GLU A  61      26.261  11.507  10.618  1.00 33.16           C  
ATOM    477  O   GLU A  61      26.279  12.309   9.710  1.00 32.36           O  
ATOM    478  CB  GLU A  61      27.572   9.443   9.810  1.00 35.38           C  
ATOM    479  CG  GLU A  61      27.578   7.858   9.866  1.00 37.32           C  
ATOM    480  CD  GLU A  61      28.865   7.181   9.391  1.00 39.80           C  
ATOM    481  OE1 GLU A  61      29.860   7.901   9.035  1.00 39.92           O  
ATOM    482  OE2 GLU A  61      28.878   5.901   9.376  1.00 39.09           O  
ATOM    483  N   ILE A  62      26.227  11.879  11.893  1.00 31.84           N  
ATOM    484  CA  ILE A  62      26.152  13.292  12.302  1.00 33.65           C  
ATOM    485  C   ILE A  62      27.371  13.644  13.184  1.00 32.33           C  
ATOM    486  O   ILE A  62      27.638  12.979  14.204  1.00 31.49           O  
ATOM    487  CB  ILE A  62      24.820  13.581  13.085  1.00 34.38           C  
ATOM    488  CG1 ILE A  62      23.634  13.143  12.192  1.00 36.71           C  
ATOM    489  CG2 ILE A  62      24.735  15.060  13.558  1.00 34.18           C  
ATOM    490  CD1 ILE A  62      22.270  13.583  12.584  1.00 37.62           C  
ATOM    491  N   PRO A  63      28.094  14.696  12.804  1.00 31.48           N  
ATOM    492  CA  PRO A  63      29.211  15.188  13.632  1.00 30.49           C  
ATOM    493  C   PRO A  63      28.706  15.792  14.933  1.00 30.47           C  
ATOM    494  O   PRO A  63      27.678  16.492  14.937  1.00 30.79           O  
ATOM    495  CB  PRO A  63      29.841  16.292  12.769  1.00 32.02           C  
ATOM    496  CG  PRO A  63      29.322  16.055  11.373  1.00 32.54           C  
ATOM    497  CD  PRO A  63      27.940  15.471  11.556  1.00 32.60           C  
ATOM    498  N   LEU A  64      29.443  15.525  15.999  1.00 30.76           N  
ATOM    499  CA  LEU A  64      29.112  15.983  17.356  1.00 30.99           C  
ATOM    500  C   LEU A  64      29.895  17.278  17.619  1.00 30.91           C  
ATOM    501  O   LEU A  64      30.954  17.506  17.020  1.00 31.66           O  
ATOM    502  CB  LEU A  64      29.505  14.909  18.351  1.00 31.93           C  
ATOM    503  CG  LEU A  64      28.636  13.666  18.111  1.00 34.14           C  
ATOM    504  CD1 LEU A  64      29.181  12.494  18.856  1.00 34.63           C  
ATOM    505  CD2 LEU A  64      27.208  13.981  18.511  1.00 36.99           C  
ATOM    506  N   ASP A  65      29.360  18.137  18.479  1.00 30.66           N  
ATOM    507  CA  ASP A  65      30.034  19.396  18.755  1.00 30.10           C  
ATOM    508  C   ASP A  65      31.313  19.130  19.523  1.00 30.24           C  
ATOM    509  O   ASP A  65      31.349  18.277  20.421  1.00 30.25           O  
ATOM    510  CB  ASP A  65      29.150  20.307  19.616  1.00 29.84           C  
ATOM    511  CG  ASP A  65      28.010  20.946  18.830  1.00 31.90           C  
ATOM    512  OD1 ASP A  65      27.842  20.679  17.604  1.00 31.60           O  
ATOM    513  OD2 ASP A  65      27.292  21.738  19.456  1.00 30.90           O  
ATOM    514  N   PHE A  66      32.334  19.898  19.189  1.00 29.41           N  
ATOM    515  CA  PHE A  66      33.552  19.957  19.987  1.00 29.38           C  
ATOM    516  C   PHE A  66      33.232  20.640  21.315  1.00 29.74           C  
ATOM    517  O   PHE A  66      32.262  21.379  21.420  1.00 28.14           O  
ATOM    518  CB  PHE A  66      34.607  20.762  19.247  1.00 30.64           C  
ATOM    519  CG  PHE A  66      35.154  20.082  18.018  1.00 31.33           C  
ATOM    520  CD1 PHE A  66      35.884  18.887  18.127  1.00 32.57           C  
ATOM    521  CD2 PHE A  66      34.980  20.666  16.763  1.00 32.10           C  
ATOM    522  CE1 PHE A  66      36.403  18.263  16.979  1.00 33.52           C  
ATOM    523  CE2 PHE A  66      35.493  20.058  15.611  1.00 34.01           C  
ATOM    524  CZ  PHE A  66      36.212  18.847  15.731  1.00 32.68           C  
ATOM    525  N   GLU A  67      34.054  20.352  22.316  1.00 29.55           N  
ATOM    526  CA  GLU A  67      34.158  21.163  23.514  1.00 29.59           C  
ATOM    527  C   GLU A  67      35.395  22.045  23.370  1.00 28.30           C  
ATOM    528  O   GLU A  67      36.317  21.730  22.580  1.00 27.42           O  
ATOM    529  CB  GLU A  67      34.308  20.273  24.755  1.00 30.60           C  
ATOM    530  CG  GLU A  67      33.236  19.213  24.928  1.00 35.61           C  
ATOM    531  CD  GLU A  67      31.907  19.772  25.366  1.00 42.12           C  
ATOM    532  OE1 GLU A  67      31.866  20.875  25.970  1.00 43.68           O  
ATOM    533  OE2 GLU A  67      30.882  19.107  25.090  1.00 47.64           O  
ATOM    534  N   PRO A  68      35.440  23.155  24.117  1.00 27.03           N  
ATOM    535  CA  PRO A  68      36.583  24.046  24.024  1.00 26.56           C  
ATOM    536  C   PRO A  68      37.942  23.331  24.231  1.00 27.74           C  
ATOM    537  O   PRO A  68      38.898  23.599  23.487  1.00 27.00           O  
ATOM    538  CB  PRO A  68      36.294  25.095  25.120  1.00 26.50           C  
ATOM    539  CG  PRO A  68      34.780  25.147  25.125  1.00 26.34           C  
ATOM    540  CD  PRO A  68      34.398  23.698  25.014  1.00 26.08           C  
ATOM    541  N   GLU A  69      38.000  22.401  25.186  1.00 28.53           N  
ATOM    542  CA  GLU A  69      39.261  21.731  25.512  0.50 29.85           C  
ATOM    544  C   GLU A  69      39.739  20.826  24.366  1.00 29.40           C  
ATOM    545  O   GLU A  69      40.897  20.433  24.326  1.00 29.69           O  
ATOM    546  CB  GLU A  69      39.159  20.977  26.849  0.50 30.59           C  
ATOM    548  CG  GLU A  69      38.142  19.827  26.868  0.50 33.07           C  
ATOM    550  CD  GLU A  69      38.739  18.500  26.439  0.50 37.36           C  
ATOM    552  OE1 GLU A  69      39.958  18.294  26.635  0.50 40.76           O  
ATOM    554  OE2 GLU A  69      37.989  17.659  25.908  0.50 41.00           O  
ATOM    556  N   ASP A  70      38.848  20.528  23.420  1.00 28.88           N  
ATOM    557  CA  ASP A  70      39.247  19.750  22.238  1.00 29.35           C  
ATOM    558  C   ASP A  70      40.237  20.523  21.377  1.00 29.25           C  
ATOM    559  O   ASP A  70      40.984  19.925  20.591  1.00 29.47           O  
ATOM    560  CB  ASP A  70      38.045  19.326  21.400  1.00 28.25           C  
ATOM    561  CG  ASP A  70      37.153  18.319  22.121  1.00 31.41           C  
ATOM    562  OD1 ASP A  70      37.672  17.540  22.948  1.00 34.91           O  
ATOM    563  OD2 ASP A  70      35.936  18.305  21.858  1.00 30.47           O  
ATOM    564  N   TYR A  71      40.244  21.848  21.518  1.00 29.20           N  
ATOM    565  CA  TYR A  71      41.151  22.704  20.761  1.00 29.19           C  
ATOM    566  C   TYR A  71      42.416  23.075  21.543  1.00 29.99           C  
ATOM    567  O   TYR A  71      43.236  23.840  21.057  1.00 29.49           O  
ATOM    568  CB  TYR A  71      40.436  23.989  20.350  1.00 29.90           C  
ATOM    569  CG  TYR A  71      39.496  23.830  19.181  1.00 29.16           C  
ATOM    570  CD1 TYR A  71      38.199  23.348  19.360  1.00 28.99           C  
ATOM    571  CD2 TYR A  71      39.916  24.173  17.887  1.00 30.72           C  
ATOM    572  CE1 TYR A  71      37.319  23.205  18.256  1.00 29.82           C  
ATOM    573  CE2 TYR A  71      39.057  24.040  16.795  1.00 30.69           C  
ATOM    574  CZ  TYR A  71      37.772  23.564  16.981  1.00 31.47           C  
ATOM    575  OH  TYR A  71      36.938  23.435  15.881  1.00 32.84           O  
ATOM    576  N   LEU A  72      42.539  22.560  22.763  1.00 31.28           N  
ATOM    577  CA  LEU A  72      43.669  22.867  23.633  1.00 32.93           C  
ATOM    578  C   LEU A  72      44.867  22.082  23.085  1.00 34.39           C  
ATOM    579  O   LEU A  72      44.837  20.842  23.042  1.00 35.30           O  
ATOM    580  CB  LEU A  72      43.322  22.493  25.089  1.00 31.86           C  
ATOM    581  CG  LEU A  72      44.275  22.826  26.241  1.00 32.73           C  
ATOM    582  CD1 LEU A  72      44.281  24.316  26.497  1.00 32.08           C  
ATOM    583  CD2 LEU A  72      43.863  22.059  27.505  1.00 33.62           C  
ATOM    584  N   ASN A  73      45.872  22.813  22.604  1.00 36.30           N  
ATOM    585  CA  ASN A  73      47.057  22.256  21.891  1.00 37.61           C  
ATOM    586  C   ASN A  73      46.734  21.584  20.540  1.00 37.57           C  
ATOM    587  O   ASN A  73      47.513  20.757  20.050  1.00 38.07           O  
ATOM    588  CB  ASN A  73      47.891  21.280  22.759  1.00 38.05           C  
ATOM    589  CG  ASN A  73      47.935  21.660  24.236  1.00 39.56           C  
ATOM    590  OD1 ASN A  73      48.487  22.695  24.618  1.00 41.00           O  
ATOM    591  ND2 ASN A  73      47.370  20.791  25.080  1.00 42.43           N  
ATOM    592  N   ASN A  74      45.596  21.934  19.943  1.00 36.93           N  
ATOM    593  CA  ASN A  74      45.187  21.361  18.656  1.00 36.16           C  
ATOM    594  C   ASN A  74      44.282  22.304  17.874  1.00 35.54           C  
ATOM    595  O   ASN A  74      43.096  22.451  18.185  1.00 35.64           O  
ATOM    596  CB  ASN A  74      44.507  20.008  18.845  1.00 36.24           C  
ATOM    597  CG  ASN A  74      44.322  19.247  17.525  1.00 36.67           C  
ATOM    598  OD1 ASN A  74      44.460  19.812  16.438  1.00 37.47           O  
ATOM    599  ND2 ASN A  74      44.001  17.971  17.623  1.00 38.43           N  
ATOM    600  N   THR A  75      44.873  22.940  16.868  0.50 35.22           N  
ATOM    602  CA  THR A  75      44.193  23.853  15.954  0.50 34.79           C  
ATOM    604  C   THR A  75      43.179  23.135  15.051  0.50 34.56           C  
ATOM    606  O   THR A  75      42.221  23.747  14.572  0.50 34.51           O  
ATOM    608  CB  THR A  75      45.254  24.668  15.141  0.50 35.03           C  
ATOM    610  OG1 THR A  75      45.311  26.012  15.637  0.50 35.07           O  
ATOM    612  CG2 THR A  75      44.965  24.693  13.635  0.50 35.03           C  
ATOM    614  N   SER A  76      43.381  21.833  14.855  1.00 34.24           N  
ATOM    615  CA  SER A  76      42.546  21.026  13.944  1.00 33.90           C  
ATOM    616  C   SER A  76      42.117  19.715  14.564  1.00 32.80           C  
ATOM    617  O   SER A  76      42.540  18.661  14.083  1.00 32.18           O  
ATOM    618  CB  SER A  76      43.322  20.691  12.673  1.00 34.65           C  
ATOM    619  OG  SER A  76      44.631  20.217  12.999  1.00 37.47           O  
ATOM    620  N   PRO A  77      41.257  19.759  15.614  1.00 30.87           N  
ATOM    621  CA  PRO A  77      40.822  18.519  16.226  1.00 30.78           C  
ATOM    622  C   PRO A  77      39.910  17.708  15.296  1.00 30.18           C  
ATOM    623  O   PRO A  77      39.242  18.261  14.424  1.00 28.91           O  
ATOM    624  CB  PRO A  77      40.041  18.992  17.470  1.00 30.97           C  
ATOM    625  CG  PRO A  77      39.569  20.355  17.133  1.00 29.20           C  
ATOM    626  CD  PRO A  77      40.660  20.941  16.274  1.00 31.63           C  
ATOM    627  N   THR A  78      39.897  16.402  15.503  1.00 30.27           N  
ATOM    628  CA  THR A  78      39.135  15.477  14.710  1.00 30.68           C  
ATOM    629  C   THR A  78      37.727  15.335  15.294  1.00 31.32           C  
ATOM    630  O   THR A  78      37.584  15.060  16.463  1.00 30.55           O  
ATOM    631  CB  THR A  78      39.895  14.127  14.706  1.00 31.91           C  
ATOM    632  OG1 THR A  78      41.211  14.344  14.153  1.00 33.44           O  
ATOM    633  CG2 THR A  78      39.165  13.099  13.930  1.00 33.50           C  
ATOM    634  N   GLN A  79      36.700  15.520  14.465  1.00 31.13           N  
ATOM    635  CA  GLN A  79      35.291  15.414  14.892  1.00 32.41           C  
ATOM    636  C   GLN A  79      34.943  14.030  15.382  1.00 31.67           C  
ATOM    637  O   GLN A  79      35.319  13.054  14.750  1.00 30.91           O  
ATOM    638  CB  GLN A  79      34.376  15.572  13.678  1.00 31.78           C  
ATOM    639  CG  GLN A  79      34.134  16.928  13.152  1.00 35.51           C  
ATOM    640  CD  GLN A  79      33.259  16.923  11.866  1.00 35.45           C  
ATOM    641  OE1 GLN A  79      33.274  15.969  11.036  1.00 33.34           O  
ATOM    642  NE2 GLN A  79      32.570  18.043  11.656  1.00 36.43           N  
ATOM    643  N   ARG A  80      34.199  13.944  16.477  1.00 30.89           N  
ATOM    644  CA  ARG A  80      33.544  12.682  16.807  0.50 31.88           C  
ATOM    646  C   ARG A  80      32.256  12.560  16.005  1.00 31.32           C  
ATOM    647  O   ARG A  80      31.576  13.553  15.735  1.00 30.69           O  
ATOM    648  CB  ARG A  80      33.233  12.581  18.294  0.50 32.14           C  
ATOM    650  CG  ARG A  80      33.180  11.143  18.781  0.50 34.54           C  
ATOM    652  CD  ARG A  80      34.582  10.587  19.100  0.50 37.90           C  
ATOM    654  NE  ARG A  80      34.531   9.146  19.359  0.50 40.98           N  
ATOM    656  CZ  ARG A  80      34.427   8.584  20.563  0.50 41.40           C  
ATOM    658  NH1 ARG A  80      34.374   7.260  20.660  0.50 41.58           N  
ATOM    660  NH2 ARG A  80      34.389   9.324  21.668  0.50 41.43           N  
ATOM    662  N   ILE A  81      31.929  11.336  15.608  1.00 32.75           N  
ATOM    663  CA  ILE A  81      30.749  11.082  14.749  1.00 33.52           C  
ATOM    664  C   ILE A  81      29.777  10.158  15.458  1.00 34.26           C  
ATOM    665  O   ILE A  81      30.202   9.142  16.012  1.00 35.32           O  
ATOM    666  CB  ILE A  81      31.154  10.426  13.406  1.00 33.62           C  
ATOM    667  CG1 ILE A  81      32.153  11.312  12.655  1.00 35.86           C  
ATOM    668  CG2 ILE A  81      29.913  10.159  12.508  1.00 34.18           C  
ATOM    669  CD1 ILE A  81      31.591  12.676  12.288  1.00 38.20           C  
ATOM    670  N   LEU A  82      28.497  10.516  15.418  1.00 33.59           N  
ATOM    671  CA  LEU A  82      27.418   9.645  15.866  1.00 33.57           C  
ATOM    672  C   LEU A  82      26.809   8.968  14.631  1.00 33.48           C  
ATOM    673  O   LEU A  82      26.265   9.637  13.747  1.00 33.39           O  
ATOM    674  CB  LEU A  82      26.369  10.469  16.632  1.00 34.32           C  
ATOM    675  CG  LEU A  82      25.171   9.673  17.195  1.00 34.59           C  
ATOM    676  CD1 LEU A  82      25.662   8.737  18.314  1.00 34.11           C  
ATOM    677  CD2 LEU A  82      24.123  10.627  17.739  1.00 33.59           C  
ATOM    678  N   ARG A  83      26.914   7.641  14.561  1.00 31.92           N  
ATOM    679  CA  ARG A  83      26.226   6.902  13.501  1.00 32.91           C  
ATOM    680  C   ARG A  83      24.853   6.469  13.993  1.00 33.80           C  
ATOM    681  O   ARG A  83      24.742   5.877  15.098  1.00 34.15           O  
ATOM    682  CB  ARG A  83      27.045   5.679  13.104  1.00 32.84           C  
ATOM    683  CG  ARG A  83      26.329   4.789  12.076  1.00 34.73           C  
ATOM    684  CD  ARG A  83      27.156   3.501  11.846  1.00 37.98           C  
ATOM    685  NE  ARG A  83      28.343   3.813  11.064  1.00 43.01           N  
ATOM    686  CZ  ARG A  83      29.447   3.062  11.013  1.00 47.62           C  
ATOM    687  NH1 ARG A  83      29.528   1.930  11.735  1.00 47.29           N  
ATOM    688  NH2 ARG A  83      30.482   3.449  10.254  1.00 43.40           N  
ATOM    689  N   ILE A  84      23.811   6.800  13.219  1.00 33.13           N  
ATOM    690  CA  ILE A  84      22.433   6.441  13.542  1.00 34.26           C  
ATOM    691  C   ILE A  84      21.897   5.561  12.415  1.00 34.57           C  
ATOM    692  O   ILE A  84      21.989   5.920  11.242  1.00 35.03           O  
ATOM    693  CB  ILE A  84      21.532   7.690  13.716  1.00 34.10           C  
ATOM    694  CG1 ILE A  84      22.171   8.625  14.745  1.00 35.11           C  
ATOM    695  CG2 ILE A  84      20.077   7.303  14.088  1.00 35.03           C  
ATOM    696  CD1 ILE A  84      22.207  10.056  14.332  1.00 42.25           C  
ATOM    697  N   THR A  85      21.377   4.401  12.791  1.00 35.03           N  
ATOM    698  CA  THR A  85      20.773   3.468  11.840  1.00 34.26           C  
ATOM    699  C   THR A  85      19.299   3.342  12.179  1.00 34.45           C  
ATOM    700  O   THR A  85      18.933   3.082  13.337  1.00 33.40           O  
ATOM    701  CB  THR A  85      21.432   2.070  11.926  1.00 34.88           C  
ATOM    702  OG1 THR A  85      22.849   2.185  11.799  1.00 35.29           O  
ATOM    703  CG2 THR A  85      20.870   1.149  10.829  1.00 33.84           C  
ATOM    704  N   VAL A  86      18.446   3.539  11.167  1.00 34.39           N  
ATOM    705  CA  VAL A  86      17.006   3.468  11.353  1.00 34.05           C  
ATOM    706  C   VAL A  86      16.641   1.987  11.395  1.00 34.98           C  
ATOM    707  O   VAL A  86      16.847   1.276  10.401  1.00 35.31           O  
ATOM    708  CB  VAL A  86      16.270   4.155  10.197  1.00 34.82           C  
ATOM    709  CG1 VAL A  86      14.769   3.998  10.399  1.00 33.93           C  
ATOM    710  CG2 VAL A  86      16.703   5.647  10.083  1.00 34.69           C  
ATOM    711  N   LEU A  87      16.132   1.519  12.534  1.00 34.49           N  
ATOM    712  CA  LEU A  87      15.820   0.087  12.724  1.00 35.13           C  
ATOM    713  C   LEU A  87      14.349  -0.277  12.518  1.00 35.33           C  
ATOM    714  O   LEU A  87      14.037  -1.407  12.150  1.00 35.81           O  
ATOM    715  CB  LEU A  87      16.250  -0.403  14.126  1.00 35.30           C  
ATOM    716  CG  LEU A  87      17.750  -0.371  14.435  1.00 34.91           C  
ATOM    717  CD1 LEU A  87      17.966  -0.952  15.845  1.00 34.98           C  
ATOM    718  CD2 LEU A  87      18.540  -1.160  13.378  1.00 36.92           C  
ATOM    719  N   GLU A  88      13.453   0.665  12.784  1.00 35.29           N  
ATOM    720  CA  GLU A  88      12.024   0.433  12.617  1.00 36.00           C  
ATOM    721  C   GLU A  88      11.384   1.743  12.211  1.00 35.39           C  
ATOM    722  O   GLU A  88      11.709   2.782  12.781  1.00 34.35           O  
ATOM    723  CB  GLU A  88      11.458  -0.025  13.946  1.00 36.50           C  
ATOM    724  CG  GLU A  88      10.181  -0.835  13.930  1.00 41.90           C  
ATOM    725  CD  GLU A  88       9.983  -1.490  15.289  1.00 47.48           C  
ATOM    726  OE1 GLU A  88       9.468  -0.819  16.209  1.00 50.31           O  
ATOM    727  OE2 GLU A  88      10.384  -2.667  15.451  1.00 53.82           O  
ATOM    728  N   VAL A  89      10.461   1.695  11.242  1.00 35.08           N  
ATOM    729  CA  VAL A  89       9.695   2.875  10.817  1.00 34.94           C  
ATOM    730  C   VAL A  89       8.206   2.544  10.963  1.00 34.96           C  
ATOM    731  O   VAL A  89       7.767   1.421  10.687  1.00 34.34           O  
ATOM    732  CB  VAL A  89      10.037   3.318   9.346  1.00 34.88           C  
ATOM    733  CG1 VAL A  89       9.111   4.448   8.851  1.00 35.35           C  
ATOM    734  CG2 VAL A  89      11.475   3.752   9.240  1.00 34.62           C  
ATOM    735  N   GLU A  90       7.421   3.502  11.429  1.00 35.47           N  
ATOM    736  CA  GLU A  90       5.961   3.327  11.448  1.00 36.55           C  
ATOM    737  C   GLU A  90       5.362   4.646  11.039  1.00 35.20           C  
ATOM    738  O   GLU A  90       5.823   5.681  11.491  1.00 35.01           O  
ATOM    739  CB  GLU A  90       5.449   2.952  12.837  1.00 36.14           C  
ATOM    740  CG  GLU A  90       5.913   1.592  13.350  1.00 40.14           C  
ATOM    741  CD  GLU A  90       5.241   1.206  14.663  1.00 39.96           C  
ATOM    742  OE1 GLU A  90       4.345   1.955  15.137  1.00 45.22           O  
ATOM    743  OE2 GLU A  90       5.610   0.139  15.211  1.00 45.27           O  
ATOM    744  N   ARG A  91       4.373   4.607  10.152  1.00 34.65           N  
ATOM    745  CA  ARG A  91       3.706   5.836   9.705  1.00 34.59           C  
ATOM    746  C   ARG A  91       4.747   6.859   9.214  1.00 34.01           C  
ATOM    747  O   ARG A  91       4.641   8.062   9.473  1.00 34.86           O  
ATOM    748  CB  ARG A  91       2.791   6.412  10.807  1.00 34.67           C  
ATOM    749  CG  ARG A  91       1.709   5.449  11.292  1.00 36.02           C  
ATOM    750  CD  ARG A  91       0.400   6.150  11.727  1.00 38.56           C  
ATOM    751  NE  ARG A  91      -0.100   7.036  10.671  1.00 37.97           N  
ATOM    752  CZ  ARG A  91      -0.115   8.370  10.726  1.00 37.04           C  
ATOM    753  NH1 ARG A  91      -0.531   9.047   9.691  1.00 34.32           N  
ATOM    754  NH2 ARG A  91       0.279   9.034  11.812  1.00 38.37           N  
ATOM    755  N   ASN A  92       5.746   6.354   8.487  1.00 33.66           N  
ATOM    756  CA  ASN A  92       6.753   7.175   7.793  1.00 34.06           C  
ATOM    757  C   ASN A  92       7.713   7.927   8.700  1.00 34.36           C  
ATOM    758  O   ASN A  92       8.423   8.817   8.240  1.00 34.02           O  
ATOM    759  CB  ASN A  92       6.123   8.134   6.775  1.00 34.67           C  
ATOM    760  CG  ASN A  92       5.644   7.417   5.538  1.00 35.75           C  
ATOM    761  OD1 ASN A  92       6.428   7.154   4.619  1.00 37.40           O  
ATOM    762  ND2 ASN A  92       4.360   7.067   5.518  1.00 33.79           N  
ATOM    763  N   VAL A  93       7.745   7.551   9.976  1.00 33.51           N  
ATOM    764  CA  VAL A  93       8.744   8.103  10.905  1.00 33.75           C  
ATOM    765  C   VAL A  93       9.454   6.978  11.659  1.00 33.22           C  
ATOM    766  O   VAL A  93       8.845   5.943  11.959  1.00 34.07           O  
ATOM    767  CB  VAL A  93       8.172   9.146  11.913  1.00 33.38           C  
ATOM    768  CG1 VAL A  93       7.407  10.282  11.194  1.00 32.40           C  
ATOM    769  CG2 VAL A  93       7.279   8.499  12.927  1.00 35.10           C  
ATOM    770  N   PRO A  94      10.758   7.158  11.940  1.00 33.63           N  
ATOM    771  CA  PRO A  94      11.505   6.197  12.749  1.00 33.46           C  
ATOM    772  C   PRO A  94      10.909   6.056  14.150  1.00 32.92           C  
ATOM    773  O   PRO A  94      10.580   7.052  14.786  1.00 32.83           O  
ATOM    774  CB  PRO A  94      12.886   6.830  12.861  1.00 34.30           C  
ATOM    775  CG  PRO A  94      13.027   7.621  11.614  1.00 33.83           C  
ATOM    776  CD  PRO A  94      11.628   8.237  11.447  1.00 33.26           C  
ATOM    777  N   VAL A  95      10.770   4.823  14.606  1.00 32.49           N  
ATOM    778  CA  VAL A  95      10.326   4.557  15.972  1.00 32.93           C  
ATOM    779  C   VAL A  95      11.418   3.866  16.798  1.00 33.45           C  
ATOM    780  O   VAL A  95      11.346   3.889  18.030  1.00 32.79           O  
ATOM    781  CB  VAL A  95       8.991   3.789  16.034  1.00 33.93           C  
ATOM    782  CG1 VAL A  95       7.875   4.635  15.421  1.00 33.40           C  
ATOM    783  CG2 VAL A  95       9.104   2.416  15.365  1.00 34.53           C  
ATOM    784  N   LYS A  96      12.415   3.281  16.125  1.00 32.81           N  
ATOM    785  CA  LYS A  96      13.601   2.738  16.812  1.00 32.85           C  
ATOM    786  C   LYS A  96      14.864   3.048  16.059  1.00 33.15           C  
ATOM    787  O   LYS A  96      14.923   2.853  14.850  1.00 32.58           O  
ATOM    788  CB  LYS A  96      13.486   1.228  17.012  1.00 32.84           C  
ATOM    789  CG  LYS A  96      12.303   0.795  17.859  1.00 33.95           C  
ATOM    790  CD  LYS A  96      12.523   1.045  19.346  1.00 34.63           C  
ATOM    791  CE  LYS A  96      11.189   0.981  20.073  1.00 40.53           C  
ATOM    792  NZ  LYS A  96      11.425   0.959  21.536  1.00 42.80           N  
ATOM    793  N   LEU A  97      15.892   3.493  16.783  1.00 32.92           N  
ATOM    794  CA  LEU A  97      17.157   3.906  16.144  1.00 32.89           C  
ATOM    795  C   LEU A  97      18.315   3.266  16.884  1.00 32.25           C  
ATOM    796  O   LEU A  97      18.307   3.195  18.110  1.00 32.07           O  
ATOM    797  CB  LEU A  97      17.301   5.416  16.230  1.00 33.44           C  
ATOM    798  CG  LEU A  97      16.219   6.201  15.491  1.00 35.34           C  
ATOM    799  CD1 LEU A  97      16.335   7.646  15.850  1.00 37.09           C  
ATOM    800  CD2 LEU A  97      16.382   5.984  13.988  1.00 33.08           C  
ATOM    801  N   ALA A  98      19.309   2.813  16.128  1.00 31.64           N  
ATOM    802  CA  ALA A  98      20.570   2.355  16.734  1.00 33.08           C  
ATOM    803  C   ALA A  98      21.559   3.498  16.668  1.00 33.31           C  
ATOM    804  O   ALA A  98      21.720   4.107  15.624  1.00 34.72           O  
ATOM    805  CB  ALA A  98      21.097   1.174  15.981  1.00 31.95           C  
ATOM    806  N   LEU A  99      22.202   3.796  17.792  1.00 33.87           N  
ATOM    807  CA  LEU A  99      23.198   4.893  17.837  1.00 33.54           C  
ATOM    808  C   LEU A  99      24.540   4.297  18.166  1.00 33.23           C  
ATOM    809  O   LEU A  99      24.653   3.459  19.060  1.00 32.98           O  
ATOM    810  CB  LEU A  99      22.832   5.885  18.949  1.00 33.74           C  
ATOM    811  CG  LEU A  99      21.957   7.070  18.524  1.00 33.79           C  
ATOM    812  CD1 LEU A  99      20.611   6.653  17.884  1.00 33.16           C  
ATOM    813  CD2 LEU A  99      21.748   7.985  19.720  1.00 33.21           C  
ATOM    814  N   ALA A 100      25.579   4.725  17.442  1.00 33.20           N  
ATOM    815  CA  ALA A 100      26.936   4.311  17.824  1.00 33.48           C  
ATOM    816  C   ALA A 100      27.848   5.512  17.774  1.00 34.73           C  
ATOM    817  O   ALA A 100      27.886   6.219  16.756  1.00 34.23           O  
ATOM    818  CB  ALA A 100      27.446   3.206  16.892  1.00 33.73           C  
ATOM    819  N   LEU A 101      28.576   5.742  18.857  1.00 35.84           N  
ATOM    820  CA  LEU A 101      29.632   6.755  18.852  1.00 38.86           C  
ATOM    821  C   LEU A 101      30.851   6.138  18.182  1.00 40.08           C  
ATOM    822  O   LEU A 101      31.343   5.074  18.604  1.00 40.84           O  
ATOM    823  CB  LEU A 101      29.875   7.235  20.289  1.00 39.62           C  
ATOM    824  CG  LEU A 101      30.808   8.377  20.643  1.00 41.27           C  
ATOM    825  CD1 LEU A 101      30.247   9.630  19.989  1.00 41.19           C  
ATOM    826  CD2 LEU A 101      30.835   8.517  22.163  1.00 39.61           C  
ATOM    827  N   LEU A 102      31.325   6.739  17.089  1.00 40.34           N  
ATOM    828  CA  LEU A 102      32.376   6.088  16.294  1.00 40.81           C  
ATOM    829  C   LEU A 102      33.801   6.315  16.818  1.00 41.52           C  
ATOM    830  O   LEU A 102      34.143   7.405  17.299  1.00 42.15           O  
ATOM    831  CB  LEU A 102      32.295   6.451  14.807  1.00 39.89           C  
ATOM    832  CG  LEU A 102      31.011   6.048  14.069  1.00 40.72           C  
ATOM    833  CD1 LEU A 102      31.147   6.374  12.596  1.00 40.66           C  
ATOM    834  CD2 LEU A 102      30.664   4.558  14.277  1.00 39.90           C  
TER     835      LEU A 102                                                      
END
MOLECULE T0453.pdb
ATOM   2776  N   ASP     5      13.939   7.853  29.974  1.00 47.92           N
ATOM   2777  CA  ASP     5      14.700   7.886  28.679  1.00 47.80           C
ATOM   2778  CB  ASP     5      16.179   8.247  28.883  1.00 48.46           C
ATOM   2779  CG  ASP     5      16.915   8.428  27.556  1.00 49.90           C
ATOM   2780  OD1 ASP     5      16.427   9.216  26.713  1.00 53.43           O
ATOM   2781  OD2 ASP     5      17.968   7.797  27.351  1.00 50.78           O
ATOM   2782  C   ASP     5      14.624   6.573  27.901  1.00 46.80           C
ATOM   2783  O   ASP     5      15.270   5.569  28.271  1.00 46.95           O
ATOM   2784  N   GLU     6      13.870   6.599  26.805  1.00 44.89           N
ATOM   2785  CA  GLU     6      13.698   5.424  25.972  1.00 43.39           C
ATOM   2786  CB  GLU     6      12.363   5.468  25.221  1.00 43.64           C
ATOM   2787  CG  GLU     6      11.131   5.428  26.152  1.00 45.88           C
ATOM   2788  CD  GLU     6       9.829   5.301  25.377  1.00 46.19           C
ATOM   2789  OE1 GLU     6       9.872   4.773  24.242  1.00 50.58           O
ATOM   2790  OE2 GLU     6       8.774   5.739  25.891  1.00 48.85           O
ATOM   2791  C   GLU     6      14.901   5.240  25.046  1.00 40.69           C
ATOM   2792  O   GLU     6      14.875   5.576  23.852  1.00 39.47           O
ATOM   2793  N   ILE     7      15.967   4.734  25.661  1.00 38.06           N
ATOM   2794  CA  ILE     7      17.195   4.329  24.992  1.00 35.06           C
ATOM   2795  C   ILE     7      17.767   3.198  25.815  1.00 33.04           C
ATOM   2796  O   ILE     7      17.799   3.277  27.042  1.00 31.68           O
ATOM   2797  N   VAL     8      18.195   2.143  25.133  1.00 30.90           N
ATOM   2798  CA  VAL     8      18.732   0.950  25.772  1.00 30.21           C
ATOM   2799  CB  VAL     8      17.769  -0.270  25.680  1.00 30.55           C
ATOM   2802  C   VAL     8      20.025   0.572  25.113  1.00 28.06           C
ATOM   2803  O   VAL     8      20.102   0.469  23.881  1.00 26.88           O
ATOM   2804  N   GLN     9      21.031   0.321  25.937  1.00 26.84           N
ATOM   2805  CA  GLN     9      22.367   0.059  25.399  1.00 26.48           C
ATOM   2806  CB  GLN     9      23.480   0.514  26.357  1.00 25.83           C
ATOM   2807  CG  GLN     9      24.881   0.340  25.761  1.00 27.00           C
ATOM   2808  CD  GLN     9      25.973   1.010  26.577  1.00 29.45           C
ATOM   2809  OE1 GLN     9      25.950   0.969  27.796  1.00 31.37           O
ATOM   2810  NE2 GLN     9      26.936   1.654  25.888  1.00 33.78           N
ATOM   2811  C   GLN     9      22.529  -1.409  25.071  1.00 25.52           C
ATOM   2812  O   GLN     9      22.124  -2.239  25.843  1.00 23.94           O
ATOM   2813  N   ARG    10      23.132  -1.687  23.910  1.00 25.48           N
ATOM   2814  CA  ARG    10      23.510  -3.026  23.498  1.00 26.37           C
ATOM   2815  CB  ARG    10      23.442  -3.155  21.970  1.00 25.98           C
ATOM   2816  CG  ARG    10      21.994  -2.867  21.456  1.00 27.79           C
ATOM   2817  CD  ARG    10      21.970  -2.770  19.945  1.00 24.56           C
ATOM   2818  NE  ARG    10      22.170  -4.085  19.311  1.00 25.22           N
ATOM   2819  CZ  ARG    10      23.008  -4.338  18.307  1.00 21.72           C
ATOM   2820  NH1 ARG    10      23.765  -3.384  17.827  1.00 24.80           N
ATOM   2821  NH2 ARG    10      23.097  -5.565  17.780  1.00 23.20           N
ATOM   2822  C   ARG    10      24.892  -3.384  24.002  1.00 25.51           C
ATOM   2823  O   ARG    10      25.615  -2.521  24.465  1.00 25.38           O
ATOM   2824  N   GLU    11      25.241  -4.660  23.912  1.00 25.67           N
ATOM   2825  CA  GLU    11      26.458  -5.157  24.546  1.00 26.58           C
ATOM   2826  CB  GLU    11      26.475  -6.695  24.621  1.00 26.73           C
ATOM   2827  CG  GLU    11      26.811  -7.369  23.288  1.00 26.42           C
ATOM   2828  CD  GLU    11      26.801  -8.892  23.365  1.00 26.53           C
ATOM   2829  OE1 GLU    11      25.739  -9.500  23.153  1.00 25.26           O
ATOM   2830  OE2 GLU    11      27.858  -9.481  23.595  1.00 22.61           O
ATOM   2831  C   GLU    11      27.724  -4.653  23.870  1.00 26.09           C
ATOM   2832  O   GLU    11      28.774  -4.670  24.498  1.00 26.17           O
ATOM   2833  N   ASP    12      27.605  -4.208  22.612  1.00 26.54           N
ATOM   2834  CA  ASP    12      28.712  -3.578  21.872  1.00 27.15           C
ATOM   2835  CB  ASP    12      28.593  -3.841  20.362  1.00 27.15           C
ATOM   2836  CG  ASP    12      27.446  -3.056  19.699  1.00 28.87           C
ATOM   2837  OD1 ASP    12      26.730  -2.292  20.385  1.00 28.52           O
ATOM   2838  OD2 ASP    12      27.260  -3.218  18.470  1.00 30.03           O
ATOM   2839  C   ASP    12      28.888  -2.075  22.174  1.00 26.71           C
ATOM   2840  O   ASP    12      29.816  -1.435  21.640  1.00 27.26           O
ATOM   2841  N   GLY    13      28.039  -1.520  23.043  1.00 25.81           N
ATOM   2842  CA  GLY    13      28.068  -0.073  23.310  1.00 25.36           C
ATOM   2843  C   GLY    13      27.134   0.818  22.476  1.00 25.63           C
ATOM   2844  O   GLY    13      26.940   1.992  22.803  1.00 25.79           O
ATOM   2845  N   SER    14      26.562   0.294  21.395  1.00 25.17           N
ATOM   2846  CA  SER    14      25.519   1.035  20.674  1.00 25.01           C
ATOM   2847  CB  SER    14      25.235   0.400  19.311  1.00 25.52           C
ATOM   2848  OG  SER    14      24.693  -0.912  19.479  1.00 26.93           O
ATOM   2849  C   SER    14      24.225   1.087  21.502  1.00 25.39           C
ATOM   2850  O   SER    14      24.061   0.342  22.504  1.00 24.08           O
ATOM   2851  N   TRP    15      23.324   1.994  21.106  1.00 24.85           N
ATOM   2852  CA  TRP    15      22.045   2.170  21.771  1.00 25.06           C
ATOM   2853  CB  TRP    15      21.980   3.558  22.438  1.00 25.81           C
ATOM   2854  CG  TRP    15      22.921   3.778  23.590  1.00 27.13           C
ATOM   2855  CD1 TRP    15      24.284   4.001  23.522  1.00 28.88           C
ATOM   2856  NE1 TRP    15      24.799   4.205  24.779  1.00 28.41           N
ATOM   2857  CE2 TRP    15      23.781   4.116  25.694  1.00 29.03           C
ATOM   2858  CD2 TRP    15      22.578   3.853  24.980  1.00 27.39           C
ATOM   2859  CE3 TRP    15      21.370   3.751  25.693  1.00 28.36           C
ATOM   2860  CZ3 TRP    15      21.409   3.873  27.107  1.00 28.62           C
ATOM   2861  CH2 TRP    15      22.624   4.114  27.781  1.00 27.99           C
ATOM   2862  CZ2 TRP    15      23.817   4.240  27.096  1.00 28.38           C
ATOM   2863  C   TRP    15      20.914   2.093  20.747  1.00 25.64           C
ATOM   2864  O   TRP    15      21.015   2.671  19.627  1.00 26.20           O
ATOM   2865  N   LEU    16      19.820   1.451  21.150  1.00 24.61           N
ATOM   2866  CA  LEU    16      18.548   1.577  20.451  1.00 23.88           C
ATOM   2867  CB  LEU    16      17.755   0.278  20.508  1.00 23.46           C
ATOM   2868  CG  LEU    16      18.471  -0.849  19.740  1.00 24.98           C
ATOM   2869  CD1 LEU    16      17.917  -2.209  20.149  1.00 23.39           C
ATOM   2870  CD2 LEU    16      18.339  -0.584  18.229  1.00 25.56           C
ATOM   2871  C   LEU    16      17.738   2.702  21.081  1.00 23.98           C
ATOM   2872  O   LEU    16      17.340   2.603  22.239  1.00 22.86           O
ATOM   2873  N   VAL    17      17.534   3.771  20.307  1.00 23.50           N
ATOM   2874  CA  VAL    17      16.891   4.985  20.811  1.00 23.44           C
ATOM   2875  CB  VAL    17      17.847   6.182  20.715  1.00 23.51           C
ATOM   2876  CG1 VAL    17      17.262   7.399  21.423  1.00 23.64           C
ATOM   2877  CG2 VAL    17      19.264   5.793  21.302  1.00 22.30           C
ATOM   2878  C   VAL    17      15.570   5.275  20.080  1.00 23.49           C
ATOM   2879  O   VAL    17      15.501   5.252  18.868  1.00 22.25           O
ATOM   2880  N   ASP    18      14.517   5.481  20.852  1.00 24.27           N
ATOM   2881  CA  ASP    18      13.211   5.931  20.346  1.00 25.53           C
ATOM   2882  CB  ASP    18      12.220   6.025  21.518  1.00 25.38           C
ATOM   2883  CG  ASP    18      10.784   6.036  21.049  1.00 30.07           C
ATOM   2884  OD1 ASP    18      10.338   7.042  20.475  1.00 33.75           O
ATOM   2885  OD2 ASP    18      10.100   5.020  21.203  1.00 34.10           O
ATOM   2886  C   ASP    18      13.331   7.291  19.625  1.00 25.29           C
ATOM   2887  O   ASP    18      14.045   8.169  20.089  1.00 25.15           O
ATOM   2888  N   GLY    19      12.644   7.449  18.495  1.00 25.13           N
ATOM   2889  CA  GLY    19      12.716   8.689  17.746  1.00 25.20           C
ATOM   2890  C   GLY    19      12.132   9.872  18.518  1.00 25.29           C
ATOM   2891  O   GLY    19      12.496  11.013  18.279  1.00 23.94           O
ATOM   2892  N   MET    20      11.239   9.572  19.461  1.00 25.99           N
ATOM   2893  CA  MET    20      10.575  10.585  20.276  1.00 27.12           C
ATOM   2894  CB  MET    20       9.292  10.037  20.894  1.00 27.98           C
ATOM   2895  CG  MET    20       8.141   9.876  19.920  1.00 32.02           C
ATOM   2896  SD  MET    20       7.736  11.478  18.923  0.60 36.37          SE
ATOM   2897  CE  MET    20       6.931  12.599  20.315  1.00 39.28           C
ATOM   2898  C   MET    20      11.442  11.238  21.362  1.00 27.21           C
ATOM   2899  O   MET    20      11.012  12.233  21.967  1.00 27.49           O
ATOM   2900  N   VAL    21      12.652  10.723  21.598  1.00 27.09           N
ATOM   2901  CA  VAL    21      13.514  11.286  22.652  1.00 27.06           C
ATOM   2902  CB  VAL    21      14.829  10.499  22.878  1.00 27.48           C
ATOM   2903  CG1 VAL    21      15.780  10.692  21.737  1.00 27.03           C
ATOM   2904  CG2 VAL    21      15.508  10.979  24.154  1.00 28.75           C
ATOM   2905  C   VAL    21      13.846  12.740  22.351  1.00 26.79           C
ATOM   2906  O   VAL    21      14.234  13.073  21.233  1.00 26.08           O
ATOM   2907  N   SER    22      13.688  13.594  23.356  1.00 26.82           N
ATOM   2908  CA  SER    22      13.984  15.007  23.189  1.00 27.80           C
ATOM   2909  CB  SER    22      13.540  15.789  24.407  1.00 27.35           C
ATOM   2910  OG  SER    22      14.390  15.472  25.479  1.00 29.88           O
ATOM   2911  C   SER    22      15.479  15.196  22.992  1.00 27.84           C
ATOM   2912  O   SER    22      16.279  14.377  23.449  1.00 27.14           O
ATOM   2913  N   LEU    23      15.851  16.286  22.332  1.00 28.24           N
ATOM   2914  CA  LEU    23      17.268  16.573  22.107  1.00 29.40           C
ATOM   2915  CB  LEU    23      17.466  17.545  20.951  1.00 29.04           C
ATOM   2916  CG  LEU    23      17.086  16.977  19.591  1.00 28.73           C
ATOM   2917  CD1 LEU    23      17.426  18.002  18.529  1.00 28.66           C
ATOM   2918  CD2 LEU    23      17.789  15.642  19.320  1.00 30.50           C
ATOM   2919  C   LEU    23      18.024  17.021  23.357  1.00 30.69           C
ATOM   2920  O   LEU    23      19.215  16.743  23.485  1.00 30.17           O
ATOM   2921  N   ASP    24      17.330  17.690  24.282  1.00 31.59           N
ATOM   2922  CA  ASP    24      17.944  18.077  25.550  1.00 33.24           C
ATOM   2923  CB  ASP    24      16.990  18.903  26.425  1.00 33.19           C
ATOM   2924  CG  ASP    24      16.834  20.316  25.925  1.00 35.10           C
ATOM   2925  OD1 ASP    24      17.654  20.756  25.073  1.00 36.48           O
ATOM   2926  OD2 ASP    24      15.879  20.992  26.367  1.00 38.09           O
ATOM   2927  C   ASP    24      18.422  16.859  26.307  1.00 33.76           C
ATOM   2928  O   ASP    24      19.576  16.806  26.725  1.00 33.74           O
ATOM   2929  N   ARG    25      17.523  15.892  26.475  1.00 34.41           N
ATOM   2930  CA  ARG    25      17.825  14.663  27.158  1.00 36.04           C
ATOM   2931  CB  ARG    25      16.574  13.799  27.236  1.00 36.64           C
ATOM   2932  CG  ARG    25      16.550  12.889  28.431  1.00 40.74           C
ATOM   2933  CD  ARG    25      15.234  12.136  28.552  1.00 45.96           C
ATOM   2934  NE  ARG    25      14.211  12.850  29.323  1.00 49.06           N
ATOM   2935  CZ  ARG    25      13.208  12.248  29.971  1.00 50.76           C
ATOM   2936  NH1 ARG    25      13.095  10.915  29.944  1.00 51.13           N
ATOM   2937  NH2 ARG    25      12.315  12.972  30.650  1.00 49.48           N
ATOM   2938  C   ARG    25      18.981  13.918  26.453  1.00 36.21           C
ATOM   2939  O   ARG    25      19.966  13.560  27.098  1.00 36.37           O
ATOM   2940  N   PHE    26      18.874  13.754  25.133  1.00 36.07           N
ATOM   2941  CA  PHE    26      19.906  13.101  24.311  1.00 36.11           C
ATOM   2942  CB  PHE    26      19.485  13.109  22.832  1.00 34.64           C
ATOM   2943  CG  PHE    26      20.445  12.388  21.914  1.00 34.27           C
ATOM   2944  CD1 PHE    26      20.142  11.101  21.452  1.00 33.33           C
ATOM   2945  CE1 PHE    26      21.021  10.409  20.610  1.00 30.48           C
ATOM   2946  CZ  PHE    26      22.228  11.010  20.214  1.00 33.22           C
ATOM   2947  CE2 PHE    26      22.548  12.300  20.680  1.00 32.25           C
ATOM   2948  CD2 PHE    26      21.651  12.980  21.514  1.00 31.77           C
ATOM   2949  C   PHE    26      21.294  13.756  24.445  1.00 36.77           C
ATOM   2950  O   PHE    26      22.317  13.087  24.687  1.00 35.79           O
ATOM   2951  N   ARG    27      21.306  15.065  24.221  1.00 37.70           N
ATOM   2952  CA  ARG    27      22.523  15.868  24.105  1.00 38.70           C
ATOM   2953  CB  ARG    27      22.135  17.244  23.571  1.00 39.13           C
ATOM   2954  CG  ARG    27      22.985  18.401  23.964  1.00 41.66           C
ATOM   2955  CD  ARG    27      22.459  19.626  23.236  1.00 47.36           C
ATOM   2956  NE  ARG    27      23.565  20.477  22.814  1.00 49.90           N
ATOM   2957  CZ  ARG    27      24.260  20.287  21.697  1.00 50.12           C
ATOM   2958  NH1 ARG    27      23.952  19.274  20.881  1.00 48.16           N
ATOM   2959  NH2 ARG    27      25.262  21.115  21.408  1.00 49.32           N
ATOM   2960  C   ARG    27      23.205  15.945  25.455  1.00 38.63           C
ATOM   2961  O   ARG    27      24.445  15.916  25.565  1.00 38.85           O
ATOM   2962  N   GLU    28      22.373  16.007  26.487  1.00 38.69           N
ATOM   2963  CA  GLU    28      22.849  15.953  27.856  1.00 38.86           C
ATOM   2964  CB  GLU    28      21.696  16.201  28.828  1.00 39.15           C
ATOM   2965  CG  GLU    28      22.115  16.745  30.185  1.00 41.74           C
ATOM   2966  CD  GLU    28      21.067  16.515  31.262  1.00 44.34           C
ATOM   2967  OE1 GLU    28      20.447  15.418  31.277  1.00 45.33           O
ATOM   2968  OE2 GLU    28      20.875  17.429  32.096  1.00 45.05           O
ATOM   2969  C   GLU    28      23.487  14.590  28.091  1.00 38.06           C
ATOM   2970  O   GLU    28      24.654  14.510  28.488  1.00 38.12           O
ATOM   2971  N   PHE    29      22.739  13.524  27.818  1.00 37.39           N
ATOM   2972  CA  PHE    29      23.245  12.170  28.088  1.00 37.42           C
ATOM   2973  CB  PHE    29      22.195  11.072  27.856  1.00 37.21           C
ATOM   2974  CG  PHE    29      22.728   9.705  28.134  1.00 37.01           C
ATOM   2975  CD1 PHE    29      22.821   9.241  29.452  1.00 37.80           C
ATOM   2976  CE1 PHE    29      23.359   7.982  29.746  1.00 37.16           C
ATOM   2977  CZ  PHE    29      23.827   7.182  28.710  1.00 38.10           C
ATOM   2978  CE2 PHE    29      23.752   7.655  27.373  1.00 36.27           C
ATOM   2979  CD2 PHE    29      23.217   8.914  27.104  1.00 36.23           C
ATOM   2980  C   PHE    29      24.564  11.810  27.358  1.00 37.36           C
ATOM   2981  O   PHE    29      25.544  11.421  28.011  1.00 37.18           O
ATOM   2982  N   PHE    30      24.587  11.956  26.030  1.00 36.69           N
ATOM   2983  CA  PHE    30      25.761  11.599  25.221  1.00 36.82           C
ATOM   2984  CB  PHE    30      25.323  11.298  23.773  1.00 36.26           C
ATOM   2985  CG  PHE    30      24.579   9.990  23.622  1.00 35.16           C
ATOM   2986  CD1 PHE    30      25.263   8.774  23.623  1.00 35.11           C
ATOM   2987  CE1 PHE    30      24.578   7.560  23.485  1.00 33.96           C
ATOM   2988  CZ  PHE    30      23.209   7.555  23.350  1.00 34.74           C
ATOM   2989  CE2 PHE    30      22.513   8.766  23.352  1.00 34.58           C
ATOM   2990  CD2 PHE    30      23.203   9.971  23.487  1.00 33.45           C
ATOM   2991  C   PHE    30      26.941  12.604  25.249  1.00 37.05           C
ATOM   2992  O   PHE    30      27.885  12.489  24.457  1.00 37.33           O
ATOM   2993  N   GLU    31      26.877  13.578  26.160  1.00 37.25           N
ATOM   2994  CA  GLU    31      27.899  14.636  26.324  1.00 37.31           C
ATOM   2995  CB  GLU    31      29.204  14.081  26.933  1.00 37.45           C
ATOM   2996  CG  GLU    31      29.062  13.111  28.091  1.00 36.93           C
ATOM   2997  CD  GLU    31      30.397  12.500  28.461  1.00 37.14           C
ATOM   2998  OE1 GLU    31      30.622  11.304  28.164  1.00 36.13           O
ATOM   2999  OE2 GLU    31      31.238  13.231  29.024  1.00 37.22           O
ATOM   3000  C   GLU    31      28.230  15.426  25.037  1.00 37.54           C
ATOM   3001  O   GLU    31      29.388  15.807  24.814  1.00 37.60           O
ATOM   3002  N   LEU    32      27.219  15.681  24.201  1.00 37.51           N
ATOM   3003  CA  LEU    32      27.418  16.411  22.949  1.00 37.13           C
ATOM   3004  CB  LEU    32      26.226  16.220  22.015  1.00 37.11           C
ATOM   3005  CG  LEU    32      25.674  14.814  21.761  1.00 37.73           C
ATOM   3006  CD1 LEU    32      24.558  14.876  20.741  1.00 40.19           C
ATOM   3007  CD2 LEU    32      26.733  13.886  21.266  1.00 38.68           C
ATOM   3008  C   LEU    32      27.642  17.904  23.214  1.00 37.22           C
ATOM   3009  O   LEU    32      26.792  18.584  23.819  1.00 37.14           O
ATOM   3010  N   GLU    33      28.795  18.411  22.779  1.00 36.63           N
ATOM   3011  CA  GLU    33      29.058  19.850  22.865  1.00 36.09           C
ATOM   3012  CB  GLU    33      30.478  20.124  23.385  1.00 36.71           C
ATOM   3013  CG  GLU    33      30.778  19.467  24.730  1.00 37.38           C
ATOM   3014  CD  GLU    33      31.792  20.231  25.545  1.00 39.66           C
ATOM   3015  OE1 GLU    33      32.286  21.285  25.077  1.00 40.90           O
ATOM   3016  OE2 GLU    33      32.097  19.777  26.668  1.00 40.62           O
ATOM   3017  C   GLU    33      28.798  20.578  21.534  1.00 35.34           C
ATOM   3018  O   GLU    33      29.151  21.764  21.395  1.00 35.36           O
ATOM   3019  N   ALA    34      28.169  19.872  20.581  1.00 33.67           N
ATOM   3020  CA  ALA    34      27.847  20.429  19.264  1.00 32.25           C
ATOM   3021  CB  ALA    34      28.823  19.909  18.217  1.00 32.08           C
ATOM   3022  C   ALA    34      26.405  20.105  18.865  1.00 31.51           C
ATOM   3023  O   ALA    34      25.946  18.986  19.097  1.00 31.56           O
ATOM   3024  N   PRO    35      25.671  21.086  18.286  1.00 30.60           N
ATOM   3025  CA  PRO    35      24.306  20.826  17.826  1.00 30.05           C
ATOM   3026  CB  PRO    35      23.916  22.135  17.119  1.00 29.60           C
ATOM   3027  CG  PRO    35      24.736  23.161  17.781  1.00 30.92           C
ATOM   3028  CD  PRO    35      26.059  22.489  18.047  1.00 31.02           C
ATOM   3029  C   PRO    35      24.204  19.656  16.843  1.00 28.84           C
ATOM   3030  O   PRO    35      25.087  19.436  16.032  1.00 28.26           O
ATOM   3031  N   LEU    36      23.107  18.928  16.909  1.00 28.59           N
ATOM   3032  CA  LEU    36      22.824  17.895  15.912  1.00 28.20           C
ATOM   3033  CB  LEU    36      21.748  16.930  16.441  1.00 28.25           C
ATOM   3034  CG  LEU    36      22.243  15.881  17.467  1.00 29.50           C
ATOM   3035  CD1 LEU    36      23.093  16.562  18.495  1.00 31.71           C
ATOM   3036  CD2 LEU    36      21.100  15.190  18.180  1.00 29.20           C
ATOM   3037  C   LEU    36      22.425  18.560  14.574  1.00 27.08           C
ATOM   3038  O   LEU    36      22.059  19.741  14.551  1.00 26.06           O
ATOM   3039  N   PRO    37      22.525  17.820  13.461  1.00 26.39           N
ATOM   3040  CA  PRO    37      22.073  18.380  12.184  1.00 25.69           C
ATOM   3041  CB  PRO    37      22.022  17.151  11.279  1.00 25.92           C
ATOM   3042  CG  PRO    37      23.172  16.284  11.811  1.00 26.50           C
ATOM   3043  CD  PRO    37      23.024  16.436  13.310  1.00 26.93           C
ATOM   3044  C   PRO    37      20.684  19.027  12.302  1.00 24.76           C
ATOM   3045  O   PRO    37      19.731  18.385  12.770  1.00 22.77           O
ATOM   3046  N   GLY    38      20.601  20.305  11.931  1.00 24.31           N
ATOM   3047  CA  GLY    38      19.335  21.070  11.967  1.00 25.79           C
ATOM   3048  C   GLY    38      18.953  21.689  13.319  1.00 26.35           C
ATOM   3049  O   GLY    38      18.110  22.585  13.377  1.00 27.32           O
ATOM   3050  N   GLU    39      19.561  21.226  14.404  1.00 26.26           N
ATOM   3051  CA  GLU    39      19.180  21.665  15.755  1.00 26.22           C
ATOM   3052  CB  GLU    39      19.832  20.753  16.813  1.00 26.36           C
ATOM   3053  CG  GLU    39      19.573  21.110  18.324  1.00 26.79           C
ATOM   3054  CD  GLU    39      20.402  20.260  19.282  1.00 26.32           C
ATOM   3055  OE1 GLU    39      21.282  19.526  18.792  1.00 26.92           O
ATOM   3056  OE2 GLU    39      20.180  20.314  20.519  1.00 29.41           O
ATOM   3057  C   GLU    39      19.476  23.150  16.020  1.00 26.85           C
ATOM   3058  O   GLU    39      18.789  23.782  16.834  1.00 27.20           O
ATOM   3059  N   ALA    40      20.482  23.712  15.337  1.00 26.46           N
ATOM   3060  CA  ALA    40      20.860  25.118  15.533  1.00 26.45           C
ATOM   3061  CB  ALA    40      22.147  25.450  14.761  1.00 26.81           C
ATOM   3062  C   ALA    40      19.745  26.107  15.167  1.00 25.85           C
ATOM   3063  O   ALA    40      19.634  27.185  15.767  1.00 26.11           O
ATOM   3064  N   GLY    41      18.918  25.738  14.194  1.00 24.86           N
ATOM   3065  CA  GLY    41      17.776  26.563  13.811  1.00 23.81           C
ATOM   3066  C   GLY    41      16.756  26.809  14.922  1.00 22.53           C
ATOM   3067  O   GLY    41      15.982  27.760  14.852  1.00 22.38           O
ATOM   3068  N   GLY    42      16.736  25.935  15.929  1.00 21.89           N
ATOM   3069  CA  GLY    42      15.871  26.108  17.106  1.00 21.66           C
ATOM   3070  C   GLY    42      14.483  25.496  16.960  1.00 21.48           C
ATOM   3071  O   GLY    42      13.628  25.636  17.842  1.00 21.09           O
ATOM   3072  N   ASN    43      14.258  24.802  15.858  1.00 20.65           N
ATOM   3073  CA  ASN    43      12.935  24.263  15.584  1.00 22.12           C
ATOM   3074  CB  ASN    43      12.434  24.802  14.254  1.00 21.56           C
ATOM   3075  CG  ASN    43      13.290  24.360  13.085  1.00 22.65           C
ATOM   3076  OD1 ASN    43      14.533  24.284  13.172  1.00 22.37           O
ATOM   3077  ND2 ASN    43      12.628  24.060  11.974  1.00 23.88           N
ATOM   3078  C   ASN    43      12.826  22.729  15.594  1.00 22.26           C
ATOM   3079  O   ASN    43      11.788  22.186  15.245  1.00 22.09           O
ATOM   3080  N   ILE    44      13.898  22.051  15.993  1.00 23.03           N
ATOM   3081  CA  ILE    44      13.942  20.594  15.992  1.00 24.21           C
ATOM   3082  CB  ILE    44      15.021  20.036  14.990  1.00 23.64           C
ATOM   3083  CG1 ILE    44      14.720  20.477  13.549  1.00 24.60           C
ATOM   3084  CD1 ILE    44      15.698  19.957  12.515  1.00 25.20           C
ATOM   3085  CG2 ILE    44      15.119  18.514  15.117  1.00 25.75           C
ATOM   3086  C   ILE    44      14.274  20.109  17.390  1.00 24.33           C
ATOM   3087  O   ILE    44      15.362  20.400  17.917  1.00 24.81           O
ATOM   3088  N   HIS    45      13.364  19.336  17.976  1.00 24.14           N
ATOM   3089  CA  HIS    45      13.483  18.968  19.372  1.00 24.29           C
ATOM   3090  CB  HIS    45      12.437  19.725  20.187  1.00 24.56           C
ATOM   3091  CG  HIS    45      12.365  21.180  19.854  1.00 23.61           C
ATOM   3092  ND1 HIS    45      13.396  22.052  20.128  1.00 25.03           N
ATOM   3093  CE1 HIS    45      13.069  23.266  19.709  1.00 25.95           C
ATOM   3094  NE2 HIS    45      11.867  23.209  19.165  1.00 25.21           N
ATOM   3095  CD2 HIS    45      11.408  21.911  19.236  1.00 25.32           C
ATOM   3096  C   HIS    45      13.379  17.479  19.673  1.00 24.51           C
ATOM   3097  O   HIS    45      13.313  17.103  20.833  1.00 24.81           O
ATOM   3098  N   THR    46      13.349  16.643  18.641  1.00 24.57           N
ATOM   3099  CA  THR    46      13.438  15.191  18.814  1.00 24.36           C
ATOM   3100  CB  THR    46      12.111  14.448  18.550  1.00 24.78           C
ATOM   3101  OG1 THR    46      11.744  14.598  17.171  1.00 23.28           O
ATOM   3102  CG2 THR    46      10.965  14.975  19.486  1.00 24.18           C
ATOM   3103  C   THR    46      14.471  14.607  17.885  1.00 24.57           C
ATOM   3104  O   THR    46      14.813  15.218  16.875  1.00 23.88           O
ATOM   3105  N   LEU    47      14.946  13.403  18.229  1.00 24.06           N
ATOM   3106  CA  LEU    47      15.903  12.700  17.405  1.00 24.78           C
ATOM   3107  CB  LEU    47      16.468  11.471  18.148  1.00 25.16           C
ATOM   3108  CG  LEU    47      17.510  10.594  17.427  1.00 26.82           C
ATOM   3109  CD1 LEU    47      18.817  11.340  17.143  1.00 25.56           C
ATOM   3110  CD2 LEU    47      17.770   9.324  18.264  1.00 26.00           C
ATOM   3111  C   LEU    47      15.334  12.279  16.057  1.00 24.11           C
ATOM   3112  O   LEU    47      16.083  12.271  15.044  1.00 22.93           O
ATOM   3113  N   ALA    48      14.052  11.878  16.032  1.00 22.87           N
ATOM   3114  CA  ALA    48      13.373  11.632  14.726  1.00 23.61           C
ATOM   3115  CB  ALA    48      11.892  11.205  14.912  1.00 23.25           C
ATOM   3116  C   ALA    48      13.455  12.899  13.854  1.00 23.56           C
ATOM   3117  O   ALA    48      13.766  12.833  12.664  1.00 23.95           O
ATOM   3118  N   GLY    49      13.158  14.060  14.452  1.00 24.06           N
ATOM   3119  CA  GLY    49      13.275  15.340  13.717  1.00 24.08           C
ATOM   3120  C   GLY    49      14.657  15.529  13.098  1.00 24.07           C
ATOM   3121  O   GLY    49      14.792  16.058  11.981  1.00 24.49           O
ATOM   3122  N   VAL    50      15.702  15.128  13.823  1.00 23.41           N
ATOM   3123  CA  VAL    50      17.057  15.171  13.264  1.00 22.23           C
ATOM   3124  CB  VAL    50      18.152  14.934  14.344  1.00 23.46           C
ATOM   3125  CG1 VAL    50      19.564  15.008  13.715  1.00 21.14           C
ATOM   3126  CG2 VAL    50      18.019  15.930  15.482  1.00 22.33           C
ATOM   3127  C   VAL    50      17.216  14.210  12.095  1.00 22.84           C
ATOM   3128  O   VAL    50      17.847  14.551  11.069  1.00 24.39           O
ATOM   3129  N   MET    51      16.651  13.012  12.222  1.00 22.72           N
ATOM   3130  CA  MET    51      16.758  12.009  11.164  1.00 22.53           C
ATOM   3131  CB  MET    51      16.178  10.644  11.594  1.00 22.57           C
ATOM   3132  CG  MET    51      16.756  10.007  12.853  1.00 23.07           C
ATOM   3133  SD  MET    51      18.689   9.799  12.854  0.60 25.91          SE
ATOM   3134  CE  MET    51      19.128  11.427  13.708  1.00 34.37           C
ATOM   3135  C   MET    51      16.065  12.502   9.902  1.00 22.32           C
ATOM   3136  O   MET    51      16.589  12.333   8.809  1.00 22.24           O
ATOM   3137  N   LEU    52      14.886  13.106  10.058  1.00 22.07           N
ATOM   3138  CA  LEU    52      14.157  13.672   8.910  1.00 22.52           C
ATOM   3139  CB  LEU    52      12.703  14.032   9.289  1.00 22.62           C
ATOM   3140  CG  LEU    52      11.761  12.948   9.876  1.00 25.01           C
ATOM   3141  CD1 LEU    52      10.482  13.572  10.478  1.00 25.90           C
ATOM   3142  CD2 LEU    52      11.377  11.875   8.859  1.00 28.33           C
ATOM   3143  C   LEU    52      14.892  14.877   8.232  1.00 22.76           C
ATOM   3144  O   LEU    52      14.910  14.997   6.991  1.00 22.20           O
ATOM   3145  N   TYR    53      15.464  15.774   9.035  1.00 22.64           N
ATOM   3146  CA  TYR    53      16.306  16.855   8.489  1.00 22.84           C
ATOM   3147  CB  TYR    53      16.926  17.691   9.609  1.00 22.65           C
ATOM   3148  CG  TYR    53      17.783  18.854   9.119  1.00 22.30           C
ATOM   3149  CD1 TYR    53      17.208  20.056   8.728  1.00 21.91           C
ATOM   3150  CE1 TYR    53      18.018  21.144   8.304  1.00 23.96           C
ATOM   3151  CZ  TYR    53      19.390  20.990   8.288  1.00 23.27           C
ATOM   3152  OH  TYR    53      20.212  22.016   7.898  1.00 29.26           O
ATOM   3153  CE2 TYR    53      19.972  19.818   8.688  1.00 24.55           C
ATOM   3154  CD2 TYR    53      19.175  18.757   9.102  1.00 21.23           C
ATOM   3155  C   TYR    53      17.439  16.290   7.650  1.00 23.16           C
ATOM   3156  O   TYR    53      17.652  16.720   6.499  1.00 21.90           O
ATOM   3157  N   GLN    54      18.173  15.330   8.239  1.00 23.69           N
ATOM   3158  CA  GLN    54      19.369  14.791   7.595  1.00 24.43           C
ATOM   3159  CB  GLN    54      20.265  14.059   8.606  1.00 23.64           C
ATOM   3160  CG  GLN    54      21.653  13.659   8.049  1.00 25.10           C
ATOM   3161  CD  GLN    54      22.520  14.849   7.615  1.00 27.40           C
ATOM   3162  OE1 GLN    54      22.330  15.970   8.071  1.00 25.62           O
ATOM   3163  NE2 GLN    54      23.479  14.591   6.724  1.00 26.29           N
ATOM   3164  C   GLN    54      19.083  13.911   6.370  1.00 24.02           C
ATOM   3165  O   GLN    54      19.772  14.013   5.348  1.00 23.57           O
ATOM   3166  N   LEU    55      18.048  13.076   6.476  1.00 24.10           N
ATOM   3167  CA  LEU    55      17.819  11.992   5.503  1.00 23.38           C
ATOM   3168  CB  LEU    55      17.709  10.658   6.229  1.00 22.72           C
ATOM   3169  CG  LEU    55      18.934  10.236   7.043  1.00 23.27           C
ATOM   3170  CD1 LEU    55      18.560   9.042   7.930  1.00 26.13           C
ATOM   3171  CD2 LEU    55      20.087   9.865   6.115  1.00 23.13           C
ATOM   3172  C   LEU    55      16.601  12.168   4.622  1.00 23.71           C
ATOM   3173  O   LEU    55      16.391  11.381   3.693  1.00 23.34           O
ATOM   3174  N   GLY    56      15.795  13.195   4.898  1.00 23.46           N
ATOM   3175  CA  GLY    56      14.574  13.405   4.114  1.00 23.77           C
ATOM   3176  C   GLY    56      13.306  12.974   4.836  1.00 24.82           C
ATOM   3177  O   GLY    56      13.346  12.329   5.897  1.00 23.40           O
ATOM   3178  N   ARG    57      12.189  13.338   4.229  1.00 25.62           N
ATOM   3179  CA  ARG    57      10.868  13.139   4.791  1.00 27.20           C
ATOM   3180  CB  ARG    57       9.802  13.778   3.915  1.00 27.30           C
ATOM   3181  CG  ARG    57       9.488  15.184   4.296  1.00 30.11           C
ATOM   3182  CD  ARG    57       9.265  15.293   5.802  1.00 32.60           C
ATOM   3183  NE  ARG    57      10.365  16.054   6.379  1.00 34.52           N
ATOM   3184  CZ  ARG    57      10.352  16.585   7.598  1.00 36.49           C
ATOM   3185  NH1 ARG    57       9.266  16.432   8.378  1.00 35.61           N
ATOM   3186  NH2 ARG    57      11.418  17.279   8.026  1.00 32.29           N
ATOM   3187  C   ARG    57      10.524  11.693   4.997  1.00 27.71           C
ATOM   3188  O   ARG    57       9.907  11.344   6.000  1.00 28.37           O
ATOM   3189  N   VAL    58      10.913  10.831   4.076  1.00 28.82           N
ATOM   3190  CA  VAL    58      10.698   9.421   4.375  1.00 30.30           C
ATOM   3191  CB  VAL    58       9.391   8.875   3.734  1.00 31.00           C
ATOM   3192  CG1 VAL    58       9.301   9.257   2.254  1.00 32.46           C
ATOM   3193  CG2 VAL    58       9.162   7.362   4.058  1.00 32.12           C
ATOM   3194  C   VAL    58      11.963   8.603   4.217  1.00 29.49           C
ATOM   3195  O   VAL    58      12.288   8.106   3.134  1.00 29.21           O
ATOM   3196  N   PRO    59      12.706   8.502   5.332  1.00 29.32           N
ATOM   3197  CA  PRO    59      13.923   7.726   5.423  1.00 28.99           C
ATOM   3198  CB  PRO    59      14.385   7.979   6.864  1.00 28.49           C
ATOM   3199  CG  PRO    59      13.752   9.195   7.266  1.00 28.03           C
ATOM   3200  CD  PRO    59      12.406   9.149   6.618  1.00 28.87           C
ATOM   3201  C   PRO    59      13.571   6.252   5.220  1.00 28.78           C
ATOM   3202  O   PRO    59      12.393   5.887   5.274  1.00 28.94           O
ATOM   3203  N   SER    60      14.573   5.428   4.941  1.00 28.19           N
ATOM   3204  CA  SER    60      14.367   3.985   4.841  1.00 27.71           C
ATOM   3205  CB  SER    60      14.813   3.460   3.475  1.00 28.51           C
ATOM   3206  OG  SER    60      14.236   4.207   2.416  1.00 33.38           O
ATOM   3207  C   SER    60      15.192   3.332   5.919  1.00 26.79           C
ATOM   3208  O   SER    60      16.236   3.851   6.315  1.00 24.76           O
ATOM   3209  N   VAL    61      14.717   2.193   6.412  1.00 26.18           N
ATOM   3210  CA  VAL    61      15.494   1.411   7.363  1.00 26.59           C
ATOM   3211  CB  VAL    61      14.729   0.100   7.748  1.00 26.58           C
ATOM   3212  CG1 VAL    61      15.617  -0.840   8.486  1.00 28.16           C
ATOM   3213  CG2 VAL    61      13.538   0.434   8.611  1.00 27.14           C
ATOM   3214  C   VAL    61      16.868   1.129   6.710  1.00 25.66           C
ATOM   3215  O   VAL    61      16.959   0.943   5.474  1.00 23.81           O
ATOM   3216  N   THR    62      17.898   1.098   7.562  1.00 25.57           N
ATOM   3217  CA  THR    62      19.346   1.071   7.214  1.00 25.96           C
ATOM   3218  CB  THR    62      19.739  -0.046   6.194  1.00 25.44           C
ATOM   3219  OG1 THR    62      19.371   0.364   4.879  1.00 28.27           O
ATOM   3220  CG2 THR    62      19.045  -1.377   6.507  1.00 25.09           C
ATOM   3221  C   THR    62      19.926   2.438   6.780  1.00 26.72           C
ATOM   3222  O   THR    62      21.154   2.613   6.780  1.00 26.33           O
ATOM   3223  N   ASP    63      19.082   3.410   6.430  1.00 26.72           N
ATOM   3224  CA  ASP    63      19.614   4.765   6.158  1.00 28.01           C
ATOM   3225  CB  ASP    63      18.499   5.767   5.936  1.00 28.39           C
ATOM   3226  CG  ASP    63      17.925   5.720   4.522  1.00 29.10           C
ATOM   3227  OD1 ASP    63      18.269   4.818   3.740  1.00 32.34           O
ATOM   3228  OD2 ASP    63      17.110   6.594   4.205  1.00 30.28           O
ATOM   3229  C   ASP    63      20.457   5.212   7.365  1.00 28.78           C
ATOM   3230  O   ASP    63      20.066   4.978   8.525  1.00 28.25           O
ATOM   3231  N   ARG    64      21.607   5.823   7.092  1.00 29.02           N
ATOM   3232  CA  ARG    64      22.656   5.991   8.102  1.00 30.26           C
ATOM   3233  CB  ARG    64      23.507   4.712   8.162  1.00 30.33           C
ATOM   3234  CG  ARG    64      24.604   4.658   9.233  1.00 33.52           C
ATOM   3235  CD  ARG    64      25.429   3.376   9.076  1.00 32.76           C
ATOM   3236  NE  ARG    64      26.257   3.095  10.263  1.00 39.38           N
ATOM   3237  CZ  ARG    64      27.517   3.509  10.425  1.00 40.09           C
ATOM   3238  NH1 ARG    64      28.106   4.247   9.491  1.00 42.36           N
ATOM   3239  NH2 ARG    64      28.187   3.199  11.527  1.00 40.57           N
ATOM   3240  C   ARG    64      23.529   7.200   7.768  1.00 30.13           C
ATOM   3241  O   ARG    64      23.708   7.529   6.603  1.00 29.84           O
ATOM   3242  N   PHE    65      24.036   7.872   8.803  1.00 29.42           N
ATOM   3243  CA  PHE    65      25.037   8.905   8.646  1.00 28.76           C
ATOM   3244  CB  PHE    65      24.396  10.274   8.350  1.00 28.08           C
ATOM   3245  CG  PHE    65      23.530  10.811   9.477  1.00 28.17           C
ATOM   3246  CD1 PHE    65      22.185  10.459   9.578  1.00 26.70           C
ATOM   3247  CE1 PHE    65      21.369  10.998  10.583  1.00 28.95           C
ATOM   3248  CZ  PHE    65      21.890  11.878  11.518  1.00 27.44           C
ATOM   3249  CE2 PHE    65      23.237  12.245  11.434  1.00 28.87           C
ATOM   3250  CD2 PHE    65      24.048  11.716  10.403  1.00 28.74           C
ATOM   3251  C   PHE    65      25.883   8.947   9.905  1.00 28.66           C
ATOM   3252  O   PHE    65      25.483   8.437  10.970  1.00 27.20           O
ATOM   3253  N   GLU    66      27.073   9.510   9.755  1.00 29.20           N
ATOM   3254  CA  GLU    66      27.971   9.722  10.879  1.00 31.24           C
ATOM   3255  CB  GLU    66      29.361   9.019  10.685  1.00 31.12           C
ATOM   3256  CG  GLU    66      29.283   7.428  10.694  1.00 33.90           C
ATOM   3257  CD  GLU    66      30.533   6.666  11.292  1.00 33.48           C
ATOM   3258  OE1 GLU    66      31.522   7.306  11.700  1.00 36.71           O
ATOM   3259  OE2 GLU    66      30.522   5.404  11.362  1.00 37.95           O
ATOM   3260  C   GLU    66      28.031  11.247  11.144  1.00 30.40           C
ATOM   3261  O   GLU    66      27.944  12.082  10.220  1.00 30.52           O
ATOM   3262  N   TRP    67      28.082  11.632  12.411  1.00 29.65           N
ATOM   3263  CA  TRP    67      28.113  13.073  12.715  1.00 29.18           C
ATOM   3264  CB  TRP    67      26.666  13.658  12.870  1.00 30.13           C
ATOM   3265  CG  TRP    67      26.644  15.002  13.511  1.00 31.06           C
ATOM   3266  CD1 TRP    67      26.724  16.215  12.894  1.00 32.45           C
ATOM   3267  NE1 TRP    67      26.716  17.231  13.836  1.00 32.58           N
ATOM   3268  CE2 TRP    67      26.625  16.671  15.085  1.00 33.12           C
ATOM   3269  CD2 TRP    67      26.576  15.266  14.917  1.00 32.54           C
ATOM   3270  CE3 TRP    67      26.475  14.446  16.056  1.00 33.26           C
ATOM   3271  CZ3 TRP    67      26.439  15.048  17.325  1.00 34.12           C
ATOM   3272  CH2 TRP    67      26.510  16.462  17.464  1.00 31.85           C
ATOM   3273  CZ2 TRP    67      26.603  17.280  16.358  1.00 33.81           C
ATOM   3274  C   TRP    67      28.947  13.257  13.968  1.00 28.11           C
ATOM   3275  O   TRP    67      28.627  12.683  14.994  1.00 27.21           O
ATOM   3276  N   ASN    68      30.035  14.014  13.893  1.00 28.17           N
ATOM   3277  CA  ASN    68      30.758  14.338  15.124  1.00 29.31           C
ATOM   3278  CB  ASN    68      29.860  15.266  15.977  1.00 29.79           C
ATOM   3279  CG  ASN    68      30.581  15.862  17.170  1.00 34.24           C
ATOM   3280  OD1 ASN    68      31.787  16.161  17.102  1.00 37.99           O
ATOM   3281  ND2 ASN    68      29.843  16.053  18.283  1.00 37.21           N
ATOM   3282  C   ASN    68      31.151  13.104  15.960  1.00 28.56           C
ATOM   3283  O   ASN    68      31.075  13.150  17.187  1.00 28.28           O
ATOM   3284  N   GLY    69      31.521  11.992  15.311  1.00 28.80           N
ATOM   3285  CA  GLY    69      32.017  10.813  16.047  1.00 28.30           C
ATOM   3286  C   GLY    69      30.951   9.810  16.462  1.00 28.34           C
ATOM   3287  O   GLY    69      31.246   8.843  17.171  1.00 28.43           O
ATOM   3288  N   PHE    70      29.720  10.063  16.027  1.00 28.27           N
ATOM   3289  CA  PHE    70      28.544   9.191  16.231  1.00 28.62           C
ATOM   3290  CB  PHE    70      27.425   9.981  16.931  1.00 27.71           C
ATOM   3291  CG  PHE    70      27.690  10.237  18.350  1.00 27.63           C
ATOM   3292  CD1 PHE    70      27.179   9.376  19.325  1.00 28.94           C
ATOM   3293  CE1 PHE    70      27.449   9.592  20.679  1.00 29.95           C
ATOM   3294  CZ  PHE    70      28.214  10.702  21.069  1.00 28.36           C
ATOM   3295  CE2 PHE    70      28.727  11.575  20.098  1.00 28.03           C
ATOM   3296  CD2 PHE    70      28.456  11.339  18.742  1.00 28.51           C
ATOM   3297  C   PHE    70      27.979   8.652  14.912  1.00 28.79           C
ATOM   3298  O   PHE    70      28.087   9.287  13.868  1.00 29.91           O
ATOM   3299  N   SER    71      27.377   7.472  14.953  1.00 28.72           N
ATOM   3300  CA  SER    71      26.596   7.015  13.830  1.00 27.85           C
ATOM   3301  CB  SER    71      27.129   5.693  13.295  1.00 27.47           C
ATOM   3302  OG  SER    71      27.108   4.708  14.321  1.00 27.61           O
ATOM   3303  C   SER    71      25.131   6.910  14.277  1.00 27.95           C
ATOM   3304  O   SER    71      24.835   6.692  15.459  1.00 28.04           O
ATOM   3305  N   PHE    72      24.239   7.112  13.318  1.00 26.78           N
ATOM   3306  CA  PHE    72      22.811   7.162  13.528  1.00 26.94           C
ATOM   3307  CB  PHE    72      22.302   8.599  13.426  1.00 26.23           C
ATOM   3308  CG  PHE    72      22.848   9.538  14.500  1.00 25.80           C
ATOM   3309  CD1 PHE    72      22.126   9.777  15.662  1.00 27.93           C
ATOM   3310  CE1 PHE    72      22.605  10.661  16.653  1.00 28.12           C
ATOM   3311  CZ  PHE    72      23.826  11.314  16.457  1.00 27.96           C
ATOM   3312  CE2 PHE    72      24.550  11.078  15.291  1.00 27.59           C
ATOM   3313  CD2 PHE    72      24.068  10.185  14.336  1.00 25.35           C
ATOM   3314  C   PHE    72      22.275   6.357  12.361  1.00 27.66           C
ATOM   3315  O   PHE    72      22.540   6.705  11.186  1.00 27.55           O
ATOM   3316  N   GLU    73      21.572   5.277  12.672  1.00 27.38           N
ATOM   3317  CA  GLU    73      21.032   4.383  11.644  1.00 28.12           C
ATOM   3318  CB  GLU    73      21.815   3.055  11.563  1.00 28.15           C
ATOM   3319  CG  GLU    73      21.227   2.007  10.549  1.00 28.54           C
ATOM   3320  CD  GLU    73      22.043   0.696  10.442  1.00 29.78           C
ATOM   3321  OE1 GLU    73      23.166   0.623  11.003  1.00 31.35           O
ATOM   3322  OE2 GLU    73      21.570  -0.272   9.793  1.00 31.62           O
ATOM   3323  C   GLU    73      19.565   4.129  11.950  1.00 27.42           C
ATOM   3324  O   GLU    73      19.217   3.756  13.077  1.00 27.66           O
ATOM   3325  N   VAL    74      18.703   4.373  10.964  1.00 26.44           N
ATOM   3326  CA  VAL    74      17.286   4.003  11.069  1.00 25.62           C
ATOM   3327  CB  VAL    74      16.430   4.563   9.871  1.00 25.05           C
ATOM   3328  CG1 VAL    74      14.954   4.244  10.056  1.00 21.72           C
ATOM   3329  CG2 VAL    74      16.659   6.071   9.680  1.00 24.28           C
ATOM   3330  C   VAL    74      17.121   2.486  11.134  1.00 26.07           C
ATOM   3331  O   VAL    74      17.463   1.786  10.194  1.00 26.27           O
ATOM   3332  N   VAL    75      16.582   1.968  12.235  1.00 24.82           N
ATOM   3333  CA  VAL    75      16.430   0.518  12.289  1.00 24.22           C
ATOM   3334  CB  VAL    75      17.304  -0.135  13.431  1.00 23.75           C
ATOM   3335  CG1 VAL    75      18.875   0.027  13.101  1.00 22.60           C
ATOM   3336  CG2 VAL    75      16.997   0.483  14.733  1.00 22.03           C
ATOM   3337  C   VAL    75      14.953   0.091  12.341  1.00 23.43           C
ATOM   3338  O   VAL    75      14.649  -1.058  12.184  1.00 23.89           O
ATOM   3339  N   ASP    76      14.062   1.038  12.593  1.00 23.04           N
ATOM   3340  CA  ASP    76      12.616   0.792  12.501  1.00 23.06           C
ATOM   3341  CB  ASP    76      12.054   0.166  13.775  1.00 21.32           C
ATOM   3342  CG  ASP    76      10.614  -0.200  13.622  1.00 23.34           C
ATOM   3343  OD1 ASP    76      10.264  -0.862  12.620  1.00 21.79           O
ATOM   3344  OD2 ASP    76       9.805   0.183  14.490  1.00 25.52           O
ATOM   3345  C   ASP    76      11.806   2.034  12.125  1.00 23.33           C
ATOM   3346  O   ASP    76      11.972   3.119  12.728  1.00 22.85           O
ATOM   3347  N   MET    77      10.937   1.850  11.120  1.00 24.35           N
ATOM   3348  CA  MET    77       9.922   2.832  10.717  1.00 23.84           C
ATOM   3349  CB  MET    77       9.918   3.081   9.183  1.00 23.85           C
ATOM   3350  CG  MET    77      11.232   3.638   8.518  1.00 26.25           C
ATOM   3351  SD  MET    77      11.655   5.436   9.114  0.60 30.39          SE
ATOM   3352  CE  MET    77      10.230   6.404   8.177  1.00 25.70           C
ATOM   3353  C   MET    77       8.545   2.282  11.092  1.00 23.56           C
ATOM   3354  O   MET    77       8.280   1.094  10.935  1.00 23.44           O
ATOM   3355  N   ASP    78       7.643   3.149  11.524  1.00 23.14           N
ATOM   3356  CA  ASP    78       6.238   2.764  11.616  1.00 23.52           C
ATOM   3357  CB  ASP    78       5.742   2.835  13.055  1.00 23.99           C
ATOM   3358  CG  ASP    78       6.446   1.841  13.968  1.00 24.34           C
ATOM   3359  OD1 ASP    78       6.774   0.690  13.557  1.00 25.48           O
ATOM   3360  OD2 ASP    78       6.679   2.218  15.123  1.00 22.71           O
ATOM   3361  C   ASP    78       5.441   3.672  10.708  1.00 23.25           C
ATOM   3362  O   ASP    78       5.160   4.830  11.028  1.00 22.38           O
ATOM   3363  N   ARG    79       5.097   3.129   9.551  1.00 24.03           N
ATOM   3364  CA  ARG    79       4.717   3.937   8.389  1.00 25.30           C
ATOM   3365  CB  ARG    79       3.226   4.296   8.407  1.00 25.90           C
ATOM   3366  CG  ARG    79       2.367   3.072   8.690  1.00 28.42           C
ATOM   3367  CD  ARG    79       0.908   3.397   8.810  1.00 33.34           C
ATOM   3368  NE  ARG    79       0.632   4.375   9.859  1.00 36.69           N
ATOM   3369  CZ  ARG    79      -0.354   5.270   9.793  1.00 38.53           C
ATOM   3370  NH1 ARG    79      -1.162   5.301   8.729  1.00 37.32           N
ATOM   3371  NH2 ARG    79      -0.534   6.129  10.791  1.00 39.47           N
ATOM   3372  C   ARG    79       5.673   5.124   8.217  1.00 24.97           C
ATOM   3373  O   ARG    79       6.835   4.898   7.846  1.00 25.53           O
ATOM   3374  N   THR    80       5.241   6.364   8.485  1.00 24.47           N
ATOM   3375  CA  THR    80       6.145   7.525   8.242  1.00 24.62           C
ATOM   3376  CB  THR    80       5.400   8.792   7.781  1.00 24.57           C
ATOM   3377  OG1 THR    80       4.590   9.277   8.855  1.00 26.20           O
ATOM   3378  CG2 THR    80       4.506   8.532   6.555  1.00 24.94           C
ATOM   3379  C   THR    80       6.997   7.897   9.476  1.00 24.20           C
ATOM   3380  O   THR    80       7.792   8.809   9.428  1.00 24.80           O
ATOM   3381  N   ARG    81       6.819   7.190  10.583  1.00 24.32           N
ATOM   3382  CA  ARG    81       7.434   7.586  11.831  1.00 23.49           C
ATOM   3383  CB  ARG    81       6.528   7.227  13.015  1.00 24.51           C
ATOM   3384  CG  ARG    81       7.116   7.598  14.369  1.00 25.10           C
ATOM   3385  CD  ARG    81       6.156   7.226  15.475  1.00 28.67           C
ATOM   3386  NE  ARG    81       6.049   5.781  15.669  1.00 28.69           N
ATOM   3387  CZ  ARG    81       4.891   5.154  15.892  1.00 31.57           C
ATOM   3388  NH1 ARG    81       3.749   5.832  15.903  1.00 31.22           N
ATOM   3389  NH2 ARG    81       4.862   3.847  16.082  1.00 31.69           N
ATOM   3390  C   ARG    81       8.765   6.894  11.939  1.00 22.82           C
ATOM   3391  O   ARG    81       8.869   5.667  11.718  1.00 22.49           O
ATOM   3392  N   VAL    82       9.788   7.688  12.234  1.00 22.27           N
ATOM   3393  CA  VAL    82      11.108   7.151  12.543  1.00 22.97           C
ATOM   3394  CB  VAL    82      12.243   8.207  12.375  1.00 21.97           C
ATOM   3395  CG1 VAL    82      13.593   7.561  12.706  1.00 21.96           C
ATOM   3396  CG2 VAL    82      12.235   8.774  10.950  1.00 21.47           C
ATOM   3397  C   VAL    82      11.051   6.652  13.991  1.00 23.97           C
ATOM   3398  O   VAL    82      11.196   7.436  14.941  1.00 25.11           O
ATOM   3399  N   ASP    83      10.828   5.354  14.153  1.00 24.53           N
ATOM   3400  CA  ASP    83      10.459   4.797  15.468  1.00 23.83           C
ATOM   3401  CB  ASP    83       9.547   3.588  15.274  1.00 23.49           C
ATOM   3402  CG  ASP    83       8.866   3.155  16.565  1.00 25.53           C
ATOM   3403  OD1 ASP    83       8.238   4.016  17.231  1.00 23.09           O
ATOM   3404  OD2 ASP    83       8.957   1.938  16.905  1.00 23.96           O
ATOM   3405  C   ASP    83      11.662   4.402  16.309  1.00 24.17           C
ATOM   3406  O   ASP    83      11.621   4.526  17.532  1.00 24.27           O
ATOM   3407  N   LYS    84      12.726   3.907  15.668  1.00 24.03           N
ATOM   3408  CA  LYS    84      13.904   3.469  16.412  1.00 24.49           C
ATOM   3409  CB  LYS    84      13.823   1.968  16.808  1.00 23.83           C
ATOM   3410  CG  LYS    84      14.905   1.513  17.836  1.00 22.05           C
ATOM   3411  CD  LYS    84      14.488   1.929  19.326  1.00 20.36           C
ATOM   3412  CE  LYS    84      13.532   0.863  19.948  1.00 20.90           C
ATOM   3413  NZ  LYS    84      12.706   1.269  21.133  1.00 23.41           N
ATOM   3414  C   LYS    84      15.177   3.759  15.625  1.00 24.36           C
ATOM   3415  O   LYS    84      15.257   3.475  14.427  1.00 24.95           O
ATOM   3416  N   ILE    85      16.167   4.321  16.316  1.00 24.89           N
ATOM   3417  CA  ILE    85      17.463   4.645  15.733  1.00 24.92           C
ATOM   3418  CB  ILE    85      17.781   6.176  15.796  1.00 25.59           C
ATOM   3419  CG1 ILE    85      16.719   7.031  15.071  1.00 25.62           C
ATOM   3420  CD1 ILE    85      15.512   7.395  15.896  1.00 25.43           C
ATOM   3421  CG2 ILE    85      19.116   6.464  15.127  1.00 24.13           C
ATOM   3422  C   ILE    85      18.543   3.879  16.493  1.00 25.39           C
ATOM   3423  O   ILE    85      18.491   3.798  17.745  1.00 25.81           O
ATOM   3424  N   LEU    86      19.495   3.309  15.751  1.00 24.91           N
ATOM   3425  CA  LEU    86      20.690   2.761  16.362  1.00 25.66           C
ATOM   3426  CB  LEU    86      21.252   1.578  15.589  1.00 25.83           C
ATOM   3427  CG  LEU    86      22.465   0.836  16.211  1.00 25.84           C
ATOM   3428  CD1 LEU    86      22.055   0.090  17.458  1.00 25.27           C
ATOM   3429  CD2 LEU    86      22.970  -0.153  15.159  1.00 27.03           C
ATOM   3430  C   LEU    86      21.731   3.844  16.445  1.00 25.05           C
ATOM   3431  O   LEU    86      22.145   4.389  15.424  1.00 25.06           O
ATOM   3432  N   VAL    87      22.129   4.178  17.663  1.00 24.73           N
ATOM   3433  CA  VAL    87      23.078   5.276  17.869  1.00 24.65           C
ATOM   3434  CB  VAL    87      22.539   6.349  18.791  1.00 25.32           C
ATOM   3435  CG1 VAL    87      23.587   7.505  18.937  1.00 23.95           C
ATOM   3436  CG2 VAL    87      21.218   6.909  18.254  1.00 26.42           C
ATOM   3437  C   VAL    87      24.366   4.691  18.456  1.00 25.49           C
ATOM   3438  O   VAL    87      24.307   3.785  19.318  1.00 24.81           O
ATOM   3439  N   GLN    88      25.518   5.135  17.955  1.00 24.84           N
ATOM   3440  CA  GLN    88      26.776   4.611  18.481  1.00 26.09           C
ATOM   3441  CB  GLN    88      27.199   3.268  17.811  1.00 26.52           C
ATOM   3442  CG  GLN    88      28.390   2.592  18.543  1.00 25.32           C
ATOM   3443  CD  GLN    88      28.739   1.223  18.025  1.00 28.01           C
ATOM   3444  OE1 GLN    88      28.304   0.816  16.935  1.00 28.30           O
ATOM   3445  NE2 GLN    88      29.534   0.481  18.807  1.00 26.49           N
ATOM   3446  C   GLN    88      27.881   5.635  18.455  1.00 26.10           C
ATOM   3447  O   GLN    88      28.113   6.277  17.429  1.00 27.07           O
ATOM   3448  N   ARG    89      28.542   5.826  19.598  1.00 26.77           N
ATOM   3449  CA  ARG    89      29.749   6.670  19.644  1.00 27.37           C
ATOM   3450  CB  ARG    89      29.960   7.310  21.016  1.00 27.17           C
ATOM   3451  CG  ARG    89      31.013   8.475  21.031  1.00 28.39           C
ATOM   3452  CD  ARG    89      31.565   8.745  22.459  1.00 31.11           C
ATOM   3453  NE  ARG    89      30.484   8.679  23.442  1.00 43.41           N
ATOM   3454  CZ  ARG    89      29.849   9.737  23.969  1.00 48.58           C
ATOM   3455  NH1 ARG    89      30.207  10.996  23.643  1.00 49.64           N
ATOM   3456  NH2 ARG    89      28.844   9.536  24.838  1.00 48.75           N
ATOM   3457  C   ARG    89      30.963   5.799  19.300  1.00 27.15           C
ATOM   3458  O   ARG    89      31.129   4.715  19.853  1.00 26.09           O
ATOM   3459  N   HIS    90      31.791   6.281  18.372  1.00 27.72           N
ATOM   3460  CA  HIS    90      32.892   5.494  17.842  1.00 28.10           C
ATOM   3461  CB  HIS    90      32.837   5.519  16.318  1.00 28.17           C
ATOM   3462  CG  HIS    90      31.606   4.838  15.777  1.00 25.94           C
ATOM   3463  ND1 HIS    90      31.433   3.479  15.842  1.00 27.32           N
ATOM   3464  CE1 HIS    90      30.265   3.151  15.307  1.00 28.46           C
ATOM   3465  NE2 HIS    90      29.657   4.264  14.933  1.00 27.25           N
ATOM   3466  CD2 HIS    90      30.477   5.333  15.212  1.00 25.68           C
ATOM   3467  C   HIS    90      34.268   5.801  18.444  1.00 29.75           C
ATOM   3468  O   HIS    90      35.292   5.585  17.820  1.00 29.05           O
ATOM   3469  N   HIS    91      34.251   6.290  19.688  1.00 31.59           N
ATOM   3470  CA  HIS    91      35.426   6.349  20.565  1.00 33.37           C
ATOM   3471  CB  HIS    91      36.173   7.672  20.387  1.00 34.12           C
ATOM   3472  CG  HIS    91      35.302   8.874  20.573  1.00 37.55           C
ATOM   3473  ND1 HIS    91      35.368   9.677  21.693  1.00 41.47           N
ATOM   3474  CE1 HIS    91      34.479  10.652  21.581  1.00 42.12           C
ATOM   3475  NE2 HIS    91      33.836  10.501  20.436  1.00 40.69           N
ATOM   3476  CD2 HIS    91      34.332   9.399  19.787  1.00 40.37           C
ATOM   3477  C   HIS    91      35.007   6.157  22.048  1.00 33.41           C
ATOM   3478  O   HIS    91      35.851   6.025  22.942  1.00 33.69           O
ATOM   3479  OXT HIS    91      33.823   6.105  22.404  1.00 32.91           O
END
