
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   87 (  709),  selected   87 , name 2nqw_A
# Molecule2: number of CA atoms   87 (  702),  selected   87 , name T0453.pdb
# PARAMETERS: 2nqw_A.T0453.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    L     4_A      D       5          2.653
LGA    P     5_A      E       6          1.060
LGA    F     6_A      I       7          0.468
LGA    K     7_A      V       8          0.366
LGA    V     8_A      Q       9          1.191
LGA    L     9_A      R      10          1.246
LGA    G    10_A      E      11          1.120
LGA    D    11_A      D      12          0.346
LGA    G    12_A      G      13          1.140
LGA    S    13_A      S      14          0.738
LGA    Y    14_A      W      15          0.900
LGA    L    15_A      L      16          1.026
LGA    F    16_A      V      17          0.659
LGA    E    17_A      D      18          0.398
LGA    G    18_A      G      19          0.456
LGA    K    19_A      M      20          1.042
LGA    T    20_A      V      21          0.728
LGA    S    21_A      S      22          1.240
LGA    L    22_A      L      23          1.334
LGA    S    23_A      D      24          1.037
LGA    D    24_A      R      25          1.052
LGA    V    25_A      F      26          0.660
LGA    R    26_A      R      27          1.316
LGA    H    27_A      E      28          2.088
LGA    Y    28_A      F      29          2.213
LGA    L    29_A      F      30          1.952
LGA    D    30_A      E      31          2.851
LGA    L    31_A      L      32          2.659
LGA    P    32_A      E      33          2.464
LGA    E    33_A      -       -           -
LGA    N    34_A      A      34          1.822
LGA    A    35_A      -       -           -
LGA    F    36_A      -       -           -
LGA    G    37_A      P      35          2.737
LGA    E    38_A      L      36           #
LGA    L    39_A      P      37          3.056
LGA    G    40_A      G      38          3.720
LGA    D    41_A      E      39          2.072
LGA    -       -      A      40           -
LGA    E    42_A      G      41          3.163
LGA    -       -      G      42           -
LGA    -       -      N      43           -
LGA    V    43_A      I      44          1.599
LGA    D    44_A      H      45          1.210
LGA    T    45_A      T      46          1.068
LGA    L    46_A      L      47          0.747
LGA    S    47_A      A      48          1.073
LGA    G    48_A      G      49          1.000
LGA    L    49_A      V      50          0.944
LGA    F    50_A      M      51          1.208
LGA    L    51_A      L      52          1.301
LGA    E    52_A      Y      53          1.133
LGA    I    53_A      Q      54          1.259
LGA    K    54_A      L      55          1.683
LGA    Q    55_A      G      56          2.591
LGA    E    56_A      R      57          3.993
LGA    L    57_A      V      58          1.232
LGA    P    58_A      P      59          1.104
LGA    H    59_A      S      60          1.502
LGA    V    60_A      V      61          1.415
LGA    G    61_A      T      62          1.500
LGA    D    62_A      D      63          1.121
LGA    T    63_A      R      64          0.945
LGA    A    64_A      F      65          2.059
LGA    V    65_A      E      66          2.353
LGA    Y    66_A      W      67          1.777
LGA    E    67_A      N      68          2.563
LGA    P    68_A      G      69          1.442
LGA    F    69_A      F      70          1.586
LGA    R    70_A      S      71          1.145
LGA    F    71_A      F      72          0.572
LGA    Q    72_A      E      73          0.505
LGA    V    73_A      V      74          0.656
LGA    T    74_A      V      75          0.813
LGA    Q    75_A      D      76          0.997
LGA    X    76_A      M      77          1.368
LGA    D    77_A      D      78          1.112
LGA    K    78_A      R      79          1.798
LGA    R    79_A      T      80          1.902
LGA    R    80_A      R      81          0.380
LGA    I    81_A      V      82          0.713
LGA    I    82_A      D      83          0.657
LGA    E    83_A      K      84          0.510
LGA    I    84_A      I      85          0.385
LGA    K    85_A      L      86          0.599
LGA    I    86_A      V      87          0.629
LGA    F    87_A      Q      88          1.828
LGA    P    88_A      R      89          2.868
LGA    F    89_A      H      90          2.522
LGA    E    90_A      H      91          2.274

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   87   87    5.0     83    1.64    27.71     88.470     4.759

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.527378 * X  +  -0.502797 * Y  +  -0.684885 * Z  +  31.771317
  Y_new =  -0.196114 * X  +  -0.856367 * Y  +   0.477676 * Z  +  24.486475
  Z_new =  -0.826687 * X  +  -0.117600 * Y  +  -0.550235 * Z  +  31.307676 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.931033    0.210560  [ DEG:  -167.9358     12.0642 ]
  Theta =   0.973194    2.168399  [ DEG:    55.7599    124.2401 ]
  Phi   =  -0.356020    2.785573  [ DEG:   -20.3985    159.6015 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2nqw_A                                        
REMARK     2: T0453.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2nqw_A.T0453.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   87   87   5.0   83   1.64   27.71  88.470
REMARK  ---------------------------------------------------------- 
MOLECULE 2nqw_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   31-OCT-06   2NQW              
TITLE     STRUCTURE OF THE TRANSPORTER ASSOCIATED DOMAIN FROM PG_0272,          
TITLE    2 A CBS DOMAIN PROTEIN FROM PORPHYROMONAS GINGIVALIS                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CBS DOMAIN PROTEIN;                                        
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RESIDUES 324-413;                                          
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PORPHYROMONAS GINGIVALIS;                       
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: W83;                                                         
SOURCE   5 GENE: PG_0272;                                                       
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: TIGR4;                                     
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    PFAM03471, HEMOLYSINS, CBS DOMAINS, TRANSPORTER ASSOCIATED            
KEYWDS   2 DOMAIN, CORC_HLYC, STRUCTURAL GENOMICS, PSI-2, PROTEIN               
KEYWDS   3 STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL                  
KEYWDS   4 GENOMICS, MCSG                                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.E.CUFF,L.VOLKART,J.ABDULLAH,A.JOACHIMIAK,MIDWEST CENTER             
AUTHOR   2 FOR STRUCTURAL GENOMICS (MCSG)                                       
REVDAT   1   28-NOV-06 2NQW    0                                                
JRNL        AUTH   M.E.CUFF,L.VOLKART,J.ABDULLAH,A.JOACHIMIAK                   
JRNL        TITL   STRUCTURE OF THE TRANSPORTER ASSOCIATED DOMAIN               
JRNL        TITL 2 FROM PG_0272, A CBS DOMAIN PROTEIN FROM                      
JRNL        TITL 3 PORPHYROMONAS GINGIVALIS.                                    
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.30 ANGSTROMS.                                          
DBREF  2NQW A    1    90  UNP    Q7MXD1   Q7MXD1_PORGI   324    413             
SEQRES   1 A   93  SER ASN ALA GLU GLU GLU LEU PRO PHE LYS VAL LEU GLY          
SEQRES   2 A   93  ASP GLY SER TYR LEU PHE GLU GLY LYS THR SER LEU SER          
SEQRES   3 A   93  ASP VAL ARG HIS TYR LEU ASP LEU PRO GLU ASN ALA PHE          
SEQRES   4 A   93  GLY GLU LEU GLY ASP GLU VAL ASP THR LEU SER GLY LEU          
SEQRES   5 A   93  PHE LEU GLU ILE LYS GLN GLU LEU PRO HIS VAL GLY ASP          
SEQRES   6 A   93  THR ALA VAL TYR GLU PRO PHE ARG PHE GLN VAL THR GLN          
SEQRES   7 A   93  MSE ASP LYS ARG ARG ILE ILE GLU ILE LYS ILE PHE PRO          
SEQRES   8 A   93  PHE GLU                                                      
HET    MSE  A  76       8                                                       
HET    GOL    201       6                                                       
HET    GOL    202       6                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     GOL GLYCEROL                                                         
FORMUL   1  MSE    C5 H11 N O2 SE                                               
FORMUL   2  GOL    2(C3 H8 O3)                                                  
FORMUL   4  HOH   *185(H2 O)                                                    
CRYST1   33.733   45.195   57.214  90.00  90.00  90.00 P 21 21 21    4          
ATOM      1  N   LEU A   4      13.273   4.898  30.721  1.00 23.43           N  
ATOM      2  CA  LEU A   4      14.360   5.574  29.935  1.00 21.04           C  
ATOM      3  C   LEU A   4      14.128   5.382  28.463  1.00 20.08           C  
ATOM      4  O   LEU A   4      13.664   4.307  28.036  1.00 21.87           O  
ATOM      5  CB  LEU A   4      15.727   4.989  30.267  1.00 20.34           C  
ATOM      6  CG  LEU A   4      16.189   5.117  31.724  1.00 22.33           C  
ATOM      7  CD1 LEU A   4      17.490   4.374  31.888  1.00 24.83           C  
ATOM      8  CD2 LEU A   4      16.355   6.582  32.094  1.00 25.03           C  
ATOM      9  N   PRO A   5      14.415   6.429  27.681  1.00 18.74           N  
ATOM     10  CA  PRO A   5      14.138   6.350  26.241  1.00 18.12           C  
ATOM     11  C   PRO A   5      15.220   5.649  25.426  1.00 15.42           C  
ATOM     12  O   PRO A   5      15.172   5.750  24.161  1.00 15.79           O  
ATOM     13  CB  PRO A   5      14.080   7.823  25.835  1.00 18.91           C  
ATOM     14  CG  PRO A   5      15.144   8.484  26.704  1.00 18.63           C  
ATOM     15  CD  PRO A   5      14.973   7.749  28.064  1.00 18.28           C  
ATOM     16  N   PHE A   6      16.177   4.981  26.112  1.00 16.02           N  
ATOM     17  CA  PHE A   6      17.268   4.330  25.455  1.00 14.12           C  
ATOM     18  C   PHE A   6      17.766   3.044  26.098  1.00 13.46           C  
ATOM     19  O   PHE A   6      17.570   2.797  27.300  1.00 14.80           O  
ATOM     20  CB  PHE A   6      18.413   5.326  25.252  1.00 14.67           C  
ATOM     21  CG  PHE A   6      19.290   5.542  26.471  1.00 12.44           C  
ATOM     22  CD1 PHE A   6      20.608   5.084  26.433  1.00 15.22           C  
ATOM     23  CD2 PHE A   6      18.844   6.222  27.587  1.00 13.68           C  
ATOM     24  CE1 PHE A   6      21.475   5.292  27.494  1.00 17.31           C  
ATOM     25  CE2 PHE A   6      19.700   6.404  28.677  1.00 16.01           C  
ATOM     26  CZ  PHE A   6      21.011   5.934  28.624  1.00 16.19           C  
ATOM     27  N   LYS A   7      18.438   2.262  25.265  1.00 12.18           N  
ATOM     28  CA  LYS A   7      19.077   1.035  25.685  1.00 13.67           C  
ATOM     29  C   LYS A   7      20.589   1.154  25.468  1.00 11.98           C  
ATOM     30  O   LYS A   7      21.053   1.734  24.471  1.00 11.63           O  
ATOM     31  CB  LYS A   7      18.554  -0.147  24.886  1.00 13.97           C  
ATOM     32  CG  LYS A   7      17.050  -0.428  25.033  1.00 19.23           C  
ATOM     33  CD  LYS A   7      16.629  -1.597  24.146  1.00 21.14           C  
ATOM     34  CE  LYS A   7      15.119  -1.575  23.815  1.00 29.27           C  
ATOM     35  NZ  LYS A   7      14.251  -1.146  24.944  1.00 33.94           N  
ATOM     36  N   VAL A   8      21.340   0.619  26.430  1.00 12.43           N  
ATOM     37  CA  VAL A   8      22.798   0.559  26.390  1.00 11.82           C  
ATOM     38  C   VAL A   8      23.156  -0.823  25.888  1.00 12.74           C  
ATOM     39  O   VAL A   8      22.826  -1.836  26.539  1.00 14.67           O  
ATOM     40  CB  VAL A   8      23.355   0.752  27.824  1.00 12.46           C  
ATOM     41  CG1 VAL A   8      24.867   0.475  27.883  1.00 13.66           C  
ATOM     42  CG2 VAL A   8      23.033   2.160  28.272  1.00 13.82           C  
ATOM     43  N   LEU A   9      23.803  -0.898  24.723  0.50 12.54           N  
ATOM     45  CA  LEU A   9      24.155  -2.203  24.175  0.50 13.72           C  
ATOM     47  C   LEU A   9      25.572  -2.563  24.499  0.50 13.85           C  
ATOM     49  O   LEU A   9      26.431  -1.700  24.680  0.50 13.50           O  
ATOM     51  CB  LEU A   9      23.951  -2.252  22.657  0.50 14.24           C  
ATOM     53  CG  LEU A   9      22.476  -2.383  22.274  0.50 15.59           C  
ATOM     55  CD1 LEU A   9      21.796  -1.074  22.496  0.50 15.84           C  
ATOM     57  CD2 LEU A   9      22.311  -2.837  20.840  0.50 18.42           C  
ATOM     59  N   GLY A  10      25.820  -3.866  24.565  1.00 14.80           N  
ATOM     60  CA  GLY A  10      27.143  -4.357  24.928  1.00 16.88           C  
ATOM     61  C   GLY A  10      28.237  -3.974  23.947  1.00 18.02           C  
ATOM     62  O   GLY A  10      29.429  -3.878  24.295  1.00 21.44           O  
ATOM     63  N   ASP A  11      27.866  -3.690  22.701  1.00 16.85           N  
ATOM     64  CA  ASP A  11      28.887  -3.301  21.761  1.00 17.26           C  
ATOM     65  C   ASP A  11      29.263  -1.804  21.815  1.00 17.25           C  
ATOM     66  O   ASP A  11      30.010  -1.323  20.942  1.00 18.36           O  
ATOM     67  CB  ASP A  11      28.475  -3.719  20.343  1.00 18.05           C  
ATOM     68  CG  ASP A  11      27.289  -2.915  19.800  1.00 19.13           C  
ATOM     69  OD1 ASP A  11      26.645  -2.147  20.559  1.00 16.44           O  
ATOM     70  OD2 ASP A  11      26.982  -3.084  18.581  1.00 21.45           O  
ATOM     71  N   GLY A  12      28.745  -1.064  22.813  1.00 14.38           N  
ATOM     72  CA  GLY A  12      29.053   0.347  22.917  1.00 13.88           C  
ATOM     73  C   GLY A  12      28.089   1.273  22.166  1.00 12.69           C  
ATOM     74  O   GLY A  12      28.234   2.489  22.217  1.00 12.71           O  
ATOM     75  N   SER A  13      27.099   0.694  21.486  1.00 11.13           N  
ATOM     76  CA  SER A  13      26.089   1.492  20.776  1.00  9.82           C  
ATOM     77  C   SER A  13      24.858   1.695  21.653  1.00  9.49           C  
ATOM     78  O   SER A  13      24.774   1.182  22.796  1.00  9.68           O  
ATOM     79  CB  SER A  13      25.704   0.793  19.464  1.00 11.10           C  
ATOM     80  OG  SER A  13      24.953  -0.377  19.700  1.00 13.16           O  
ATOM     81  N   TYR A  14      23.905   2.463  21.121  1.00  8.94           N  
ATOM     82  CA  TYR A  14      22.690   2.794  21.844  1.00  9.42           C  
ATOM     83  C   TYR A  14      21.504   2.638  20.924  1.00  9.19           C  
ATOM     84  O   TYR A  14      21.606   2.870  19.731  1.00 11.21           O  
ATOM     85  CB  TYR A  14      22.739   4.264  22.350  1.00  9.35           C  
ATOM     86  CG  TYR A  14      23.974   4.523  23.165  1.00  9.24           C  
ATOM     87  CD1 TYR A  14      24.055   4.082  24.489  1.00  8.76           C  
ATOM     88  CD2 TYR A  14      25.081   5.119  22.587  1.00  9.12           C  
ATOM     89  CE1 TYR A  14      25.208   4.269  25.239  1.00  9.78           C  
ATOM     90  CE2 TYR A  14      26.258   5.290  23.306  1.00 10.35           C  
ATOM     91  CZ  TYR A  14      26.308   4.858  24.630  1.00 10.05           C  
ATOM     92  OH  TYR A  14      27.457   5.038  25.388  1.00 12.29           O  
ATOM     93  N   LEU A  15      20.361   2.318  21.499  1.00  9.90           N  
ATOM     94  CA  LEU A  15      19.082   2.398  20.759  1.00 10.20           C  
ATOM     95  C   LEU A  15      18.223   3.446  21.448  1.00  9.96           C  
ATOM     96  O   LEU A  15      18.015   3.360  22.676  1.00 12.00           O  
ATOM     97  CB  LEU A  15      18.351   1.064  20.762  1.00 10.53           C  
ATOM     98  CG  LEU A  15      19.063  -0.060  20.057  1.00 11.65           C  
ATOM     99  CD1 LEU A  15      18.315  -1.388  20.277  1.00 13.46           C  
ATOM    100  CD2 LEU A  15      19.105   0.244  18.545  1.00 13.93           C  
ATOM    101  N   PHE A  16      17.749   4.437  20.678  1.00  9.77           N  
ATOM    102  CA  PHE A  16      16.886   5.498  21.225  1.00  9.66           C  
ATOM    103  C   PHE A  16      15.540   5.485  20.539  1.00  9.52           C  
ATOM    104  O   PHE A  16      15.458   5.269  19.311  1.00 10.19           O  
ATOM    105  CB  PHE A  16      17.517   6.879  20.965  1.00 10.28           C  
ATOM    106  CG  PHE A  16      18.459   7.329  22.046  1.00  9.70           C  
ATOM    107  CD1 PHE A  16      18.007   8.170  23.062  1.00 10.68           C  
ATOM    108  CD2 PHE A  16      19.773   6.883  22.080  1.00 10.63           C  
ATOM    109  CE1 PHE A  16      18.880   8.578  24.108  1.00 11.68           C  
ATOM    110  CE2 PHE A  16      20.639   7.274  23.108  1.00 10.55           C  
ATOM    111  CZ  PHE A  16      20.181   8.135  24.117  1.00 10.65           C  
ATOM    112  N   GLU A  17      14.503   5.840  21.286  1.00 10.09           N  
ATOM    113  CA  GLU A  17      13.225   6.167  20.666  1.00 11.42           C  
ATOM    114  C   GLU A  17      13.428   7.340  19.701  1.00 10.59           C  
ATOM    115  O   GLU A  17      14.121   8.317  20.031  1.00 10.88           O  
ATOM    116  CB  GLU A  17      12.194   6.537  21.745  1.00 12.47           C  
ATOM    117  CG  GLU A  17      11.864   5.381  22.660  1.00 14.70           C  
ATOM    118  CD  GLU A  17      10.925   5.755  23.809  1.00 18.07           C  
ATOM    119  OE1 GLU A  17      10.697   6.951  24.070  1.00 21.87           O  
ATOM    120  OE2 GLU A  17      10.457   4.815  24.491  1.00 25.53           O  
ATOM    121  N   GLY A  18      12.780   7.290  18.532  1.00 10.99           N  
ATOM    122  CA  GLY A  18      12.976   8.369  17.553  1.00 12.17           C  
ATOM    123  C   GLY A  18      12.498   9.726  18.048  1.00 11.58           C  
ATOM    124  O   GLY A  18      13.070  10.764  17.694  1.00 12.62           O  
ATOM    125  N   LYS A  19      11.461   9.730  18.883  1.00 11.29           N  
ATOM    126  CA  LYS A  19      10.911  10.984  19.374  0.50 11.87           C  
ATOM    128  C   LYS A  19      11.746  11.635  20.459  1.00 11.05           C  
ATOM    129  O   LYS A  19      11.405  12.744  20.923  1.00 12.33           O  
ATOM    130  CB  LYS A  19       9.502  10.758  19.935  0.50 12.01           C  
ATOM    132  CG  LYS A  19       9.516  10.078  21.314  0.50 13.60           C  
ATOM    134  CD  LYS A  19       8.114   9.949  21.927  0.50 14.56           C  
ATOM    136  CE  LYS A  19       8.200   9.251  23.264  0.50 17.60           C  
ATOM    138  NZ  LYS A  19       9.049   9.988  24.227  0.50 23.32           N  
ATOM    140  N   THR A  20      12.848  10.986  20.881  1.00 10.57           N  
ATOM    141  CA  THR A  20      13.628  11.574  21.993  1.00 10.02           C  
ATOM    142  C   THR A  20      14.149  12.956  21.596  1.00  9.44           C  
ATOM    143  O   THR A  20      14.722  13.120  20.497  1.00 10.30           O  
ATOM    144  CB  THR A  20      14.821  10.679  22.334  1.00 10.00           C  
ATOM    145  OG1 THR A  20      14.370   9.330  22.558  1.00 11.38           O  
ATOM    146  CG2 THR A  20      15.536  11.194  23.609  1.00 11.21           C  
ATOM    147  N   SER A  21      13.988  13.960  22.463  1.00  9.55           N  
ATOM    148  CA  SER A  21      14.520  15.263  22.101  1.00  9.41           C  
ATOM    149  C   SER A  21      16.057  15.202  22.001  1.00  9.19           C  
ATOM    150  O   SER A  21      16.719  14.426  22.701  1.00  9.17           O  
ATOM    151  CB  SER A  21      14.100  16.299  23.129  1.00 10.24           C  
ATOM    152  OG  SER A  21      14.732  16.051  24.377  1.00 11.61           O  
ATOM    153  N   LEU A  22      16.636  16.056  21.171  1.00  9.43           N  
ATOM    154  CA  LEU A  22      18.093  16.155  21.146  1.00  8.94           C  
ATOM    155  C   LEU A  22      18.646  16.562  22.501  1.00  9.02           C  
ATOM    156  O   LEU A  22      19.707  16.088  22.897  1.00  9.53           O  
ATOM    157  CB  LEU A  22      18.578  17.127  20.053  1.00  9.71           C  
ATOM    158  CG  LEU A  22      18.254  16.668  18.610  1.00  9.33           C  
ATOM    159  CD1 LEU A  22      18.920  17.653  17.655  1.00 10.93           C  
ATOM    160  CD2 LEU A  22      18.809  15.280  18.387  1.00 10.85           C  
ATOM    161  N   SER A  23      17.923  17.434  23.217  0.50  9.26           N  
ATOM    163  CA  SER A  23      18.277  17.772  24.616  0.50  9.61           C  
ATOM    165  C   SER A  23      18.465  16.515  25.440  0.50  8.96           C  
ATOM    167  O   SER A  23      19.467  16.360  26.148  0.50  9.35           O  
ATOM    169  CB  SER A  23      17.168  18.627  25.254  0.50  9.32           C  
ATOM    171  OG  SER A  23      17.372  19.983  24.882  0.50 11.64           O  
ATOM    173  N   ASP A  24      17.478  15.627  25.378  1.00  9.13           N  
ATOM    174  CA  ASP A  24      17.516  14.416  26.183  1.00  9.76           C  
ATOM    175  C   ASP A  24      18.591  13.454  25.699  1.00  8.83           C  
ATOM    176  O   ASP A  24      19.199  12.767  26.514  1.00  9.20           O  
ATOM    177  CB  ASP A  24      16.160  13.735  26.252  1.00 10.22           C  
ATOM    178  CG  ASP A  24      15.188  14.481  27.170  1.00 11.80           C  
ATOM    179  OD1 ASP A  24      15.604  15.456  27.862  1.00 13.03           O  
ATOM    180  OD2 ASP A  24      14.008  14.096  27.169  1.00 13.24           O  
ATOM    181  N   VAL A  25      18.843  13.382  24.389  1.00  8.43           N  
ATOM    182  CA  VAL A  25      19.969  12.568  23.926  1.00  8.05           C  
ATOM    183  C   VAL A  25      21.283  13.100  24.527  1.00  7.96           C  
ATOM    184  O   VAL A  25      22.117  12.313  25.015  1.00  8.91           O  
ATOM    185  CB  VAL A  25      20.068  12.528  22.373  1.00  8.74           C  
ATOM    186  CG1 VAL A  25      21.292  11.743  21.924  1.00  9.86           C  
ATOM    187  CG2 VAL A  25      18.790  11.883  21.754  1.00  9.56           C  
ATOM    188  N   ARG A  26      21.496  14.416  24.483  1.00  8.90           N  
ATOM    189  CA  ARG A  26      22.720  14.968  25.044  1.00  9.21           C  
ATOM    190  C   ARG A  26      22.792  14.717  26.534  1.00  8.75           C  
ATOM    191  O   ARG A  26      23.868  14.438  27.072  1.00  9.24           O  
ATOM    192  CB  ARG A  26      22.821  16.474  24.764  1.00  9.36           C  
ATOM    193  CG  ARG A  26      22.978  16.809  23.270  1.00  9.54           C  
ATOM    194  CD  ARG A  26      23.390  18.266  23.066  1.00 11.41           C  
ATOM    195  NE  ARG A  26      22.354  19.165  23.558  1.00 12.99           N  
ATOM    196  CZ  ARG A  26      21.336  19.662  22.859  1.00 14.11           C  
ATOM    197  NH1 ARG A  26      21.222  19.454  21.545  1.00 12.51           N  
ATOM    198  NH2 ARG A  26      20.417  20.418  23.482  1.00 16.63           N  
ATOM    199  N   HIS A  27      21.642  14.791  27.214  1.00  8.54           N  
ATOM    200  CA  HIS A  27      21.583  14.503  28.665  1.00  8.33           C  
ATOM    201  C   HIS A  27      22.023  13.065  28.948  1.00  9.03           C  
ATOM    202  O   HIS A  27      22.922  12.828  29.772  1.00 10.18           O  
ATOM    203  CB  HIS A  27      20.150  14.713  29.161  1.00  8.97           C  
ATOM    204  CG  HIS A  27      19.906  14.240  30.551  1.00  9.76           C  
ATOM    205  ND1 HIS A  27      20.301  14.967  31.649  1.00 11.92           N  
ATOM    206  CD2 HIS A  27      19.374  13.086  31.018  1.00 10.77           C  
ATOM    207  CE1 HIS A  27      19.989  14.287  32.746  1.00 12.10           C  
ATOM    208  NE2 HIS A  27      19.424  13.141  32.393  1.00 12.20           N  
ATOM    209  N   TYR A  28      21.411  12.095  28.261  1.00  8.73           N  
ATOM    210  CA  TYR A  28      21.674  10.693  28.585  1.00  9.29           C  
ATOM    211  C   TYR A  28      23.042  10.229  28.084  1.00  9.85           C  
ATOM    212  O   TYR A  28      23.602   9.290  28.669  1.00 10.72           O  
ATOM    213  CB  TYR A  28      20.560   9.787  28.016  1.00 10.34           C  
ATOM    214  CG  TYR A  28      19.301   9.897  28.860  1.00 10.62           C  
ATOM    215  CD1 TYR A  28      19.304   9.522  30.213  1.00 13.12           C  
ATOM    216  CD2 TYR A  28      18.114  10.404  28.323  1.00 12.90           C  
ATOM    217  CE1 TYR A  28      18.167   9.626  31.010  1.00 14.00           C  
ATOM    218  CE2 TYR A  28      16.954  10.516  29.136  1.00 13.71           C  
ATOM    219  CZ  TYR A  28      17.014  10.117  30.460  1.00 13.54           C  
ATOM    220  OH  TYR A  28      15.889  10.203  31.242  1.00 16.86           O  
ATOM    221  N   LEU A  29      23.588  10.851  27.030  1.00  8.86           N  
ATOM    222  CA  LEU A  29      24.890  10.425  26.513  1.00  8.52           C  
ATOM    223  C   LEU A  29      26.014  11.334  26.981  1.00  8.15           C  
ATOM    224  O   LEU A  29      27.144  11.188  26.517  1.00  9.38           O  
ATOM    225  CB  LEU A  29      24.876  10.305  24.985  1.00  8.73           C  
ATOM    226  CG  LEU A  29      23.893   9.259  24.457  1.00  9.23           C  
ATOM    227  CD1 LEU A  29      24.063   9.161  22.936  1.00 10.59           C  
ATOM    228  CD2 LEU A  29      24.078   7.904  25.137  1.00 11.51           C  
ATOM    229  N   ASP A  30      25.730  12.254  27.907  1.00  8.65           N  
ATOM    230  CA  ASP A  30      26.766  13.121  28.457  1.00  8.74           C  
ATOM    231  C   ASP A  30      27.487  13.819  27.340  1.00 10.73           C  
ATOM    232  O   ASP A  30      28.746  14.007  27.402  1.00  9.88           O  
ATOM    233  CB  ASP A  30      27.773  12.334  29.308  1.00  9.57           C  
ATOM    234  CG  ASP A  30      27.131  11.617  30.455  1.00 10.12           C  
ATOM    235  OD1 ASP A  30      26.207  12.179  31.078  1.00 12.52           O  
ATOM    236  OD2 ASP A  30      27.550  10.469  30.774  1.00 13.14           O  
ATOM    237  N   LEU A  31      26.728  14.483  26.465  1.00  9.04           N  
ATOM    238  CA  LEU A  31      27.310  15.213  25.320  1.00  9.38           C  
ATOM    239  C   LEU A  31      27.373  16.707  25.567  1.00 10.63           C  
ATOM    240  O   LEU A  31      26.518  17.251  26.269  1.00 11.77           O  
ATOM    241  CB  LEU A  31      26.476  14.981  24.061  1.00  9.13           C  
ATOM    242  CG  LEU A  31      26.385  13.508  23.635  1.00  9.75           C  
ATOM    243  CD1 LEU A  31      25.467  13.379  22.420  1.00 10.20           C  
ATOM    244  CD2 LEU A  31      27.752  12.948  23.330  1.00 12.51           C  
ATOM    245  N   PRO A  32      28.344  17.377  24.945  1.00 11.74           N  
ATOM    246  CA  PRO A  32      28.371  18.849  25.010  1.00 12.56           C  
ATOM    247  C   PRO A  32      27.200  19.468  24.222  1.00 11.64           C  
ATOM    248  O   PRO A  32      26.607  18.836  23.332  1.00 11.23           O  
ATOM    249  CB  PRO A  32      29.701  19.191  24.357  1.00 14.45           C  
ATOM    250  CG  PRO A  32      29.907  18.101  23.363  1.00 15.48           C  
ATOM    251  CD  PRO A  32      29.415  16.836  24.097  1.00 12.98           C  
ATOM    252  N   GLU A  33      26.926  20.734  24.500  1.00 12.58           N  
ATOM    253  CA  GLU A  33      25.765  21.396  23.930  1.00 13.25           C  
ATOM    254  C   GLU A  33      25.789  21.464  22.421  1.00 12.37           C  
ATOM    255  O   GLU A  33      24.731  21.481  21.798  1.00 13.51           O  
ATOM    256  CB  GLU A  33      25.670  22.823  24.483  1.00 16.65           C  
ATOM    257  CG  GLU A  33      25.078  22.891  25.828  1.00 21.86           C  
ATOM    258  CD  GLU A  33      24.896  24.341  26.236  1.00 28.75           C  
ATOM    259  OE1 GLU A  33      25.908  25.089  26.251  1.00 32.09           O  
ATOM    260  OE2 GLU A  33      23.738  24.719  26.532  1.00 34.18           O  
ATOM    261  N   ASN A  34      26.993  21.529  21.848  1.00 11.62           N  
ATOM    262  CA  ASN A  34      27.127  21.657  20.401  1.00 11.33           C  
ATOM    263  C   ASN A  34      27.302  20.337  19.689  1.00  9.67           C  
ATOM    264  O   ASN A  34      27.683  20.324  18.522  1.00 10.51           O  
ATOM    265  CB  ASN A  34      28.291  22.595  20.048  1.00 13.22           C  
ATOM    266  CG  ASN A  34      29.634  22.001  20.341  1.00 15.71           C  
ATOM    267  OD1 ASN A  34      29.768  21.058  21.120  1.00 16.45           O  
ATOM    268  ND2 ASN A  34      30.672  22.532  19.671  1.00 19.79           N  
ATOM    269  N   ALA A  35      26.989  19.213  20.326  1.00  9.75           N  
ATOM    270  CA  ALA A  35      27.252  17.909  19.734  1.00  9.37           C  
ATOM    271  C   ALA A  35      26.619  17.763  18.343  1.00  8.80           C  
ATOM    272  O   ALA A  35      27.198  17.127  17.459  1.00  9.73           O  
ATOM    273  CB  ALA A  35      26.729  16.789  20.653  1.00 10.78           C  
ATOM    274  N   PHE A  36      25.399  18.299  18.168  1.00  8.66           N  
ATOM    275  CA  PHE A  36      24.679  18.132  16.892  1.00  8.97           C  
ATOM    276  C   PHE A  36      24.693  19.409  16.057  1.00  8.92           C  
ATOM    277  O   PHE A  36      24.018  19.478  15.014  1.00  9.63           O  
ATOM    278  CB  PHE A  36      23.254  17.606  17.160  1.00  9.30           C  
ATOM    279  CG  PHE A  36      23.247  16.335  17.974  1.00  8.59           C  
ATOM    280  CD1 PHE A  36      23.955  15.213  17.542  1.00  9.91           C  
ATOM    281  CD2 PHE A  36      22.541  16.277  19.166  1.00  9.87           C  
ATOM    282  CE1 PHE A  36      23.950  14.033  18.303  1.00  9.41           C  
ATOM    283  CE2 PHE A  36      22.531  15.104  19.929  1.00 10.42           C  
ATOM    284  CZ  PHE A  36      23.234  13.986  19.513  1.00  9.27           C  
ATOM    285  N   GLY A  37      25.479  20.377  16.520  1.00  8.55           N  
ATOM    286  CA  GLY A  37      25.844  21.521  15.671  1.00  9.99           C  
ATOM    287  C   GLY A  37      24.702  22.389  15.196  1.00  9.77           C  
ATOM    288  O   GLY A  37      23.586  22.366  15.727  1.00 10.45           O  
ATOM    289  N   GLU A  38      24.962  23.184  14.160  0.50 10.16           N  
ATOM    291  CA  GLU A  38      23.941  24.088  13.650  0.50 11.22           C  
ATOM    293  C   GLU A  38      22.762  23.323  13.082  0.50 12.12           C  
ATOM    295  O   GLU A  38      21.619  23.763  13.206  0.50 13.29           O  
ATOM    297  CB  GLU A  38      24.519  25.015  12.572  0.50 11.70           C  
ATOM    299  CG  GLU A  38      25.477  26.021  13.117  0.50 12.23           C  
ATOM    301  CD  GLU A  38      25.924  27.023  12.061  0.50 12.92           C  
ATOM    303  OE1 GLU A  38      25.096  27.819  11.547  0.50 14.71           O  
ATOM    305  OE2 GLU A  38      27.111  27.029  11.725  0.50 10.66           O  
ATOM    307  N   LEU A  39      23.015  22.191  12.435  1.00 12.60           N  
ATOM    308  CA  LEU A  39      21.929  21.421  11.915  0.50 13.20           C  
ATOM    310  C   LEU A  39      20.970  20.998  13.054  1.00 13.13           C  
ATOM    311  O   LEU A  39      19.723  21.073  12.945  1.00 13.83           O  
ATOM    312  CB  LEU A  39      22.528  20.212  11.205  0.50 15.31           C  
ATOM    314  CG  LEU A  39      21.580  19.589  10.210  0.50 14.53           C  
ATOM    316  CD1 LEU A  39      21.270  20.536   9.019  0.50 15.36           C  
ATOM    318  CD2 LEU A  39      22.148  18.300   9.716  0.50 17.13           C  
ATOM    320  N   GLY A  40      21.552  20.515  14.147  1.00 12.31           N  
ATOM    321  CA  GLY A  40      20.727  20.081  15.272  1.00 13.10           C  
ATOM    322  C   GLY A  40      19.926  21.217  15.858  1.00 12.62           C  
ATOM    323  O   GLY A  40      18.854  21.002  16.422  1.00 14.41           O  
ATOM    324  N   ASP A  41      20.426  22.447  15.746  1.00 12.82           N  
ATOM    325  CA  ASP A  41      19.711  23.594  16.293  1.00 14.14           C  
ATOM    326  C   ASP A  41      18.413  23.856  15.527  1.00 14.35           C  
ATOM    327  O   ASP A  41      17.568  24.598  15.991  1.00 16.53           O  
ATOM    328  CB  ASP A  41      20.587  24.846  16.197  1.00 16.10           C  
ATOM    329  CG  ASP A  41      21.714  24.869  17.199  1.00 20.16           C  
ATOM    330  OD1 ASP A  41      21.715  24.080  18.171  1.00 22.22           O  
ATOM    331  OD2 ASP A  41      22.624  25.734  17.006  1.00 27.97           O  
ATOM    332  N   GLU A  42      18.260  23.273  14.348  1.00 13.40           N  
ATOM    333  CA  GLU A  42      17.078  23.492  13.514  1.00 15.37           C  
ATOM    334  C   GLU A  42      15.933  22.552  13.830  1.00 13.58           C  
ATOM    335  O   GLU A  42      14.834  22.708  13.263  1.00 14.77           O  
ATOM    336  CB  GLU A  42      17.473  23.280  12.036  1.00 16.25           C  
ATOM    337  CG  GLU A  42      18.510  24.331  11.571  1.00 21.46           C  
ATOM    338  CD  GLU A  42      19.251  24.051  10.261  1.00 24.20           C  
ATOM    339  OE1 GLU A  42      18.972  23.031   9.597  1.00 30.24           O  
ATOM    340  OE2 GLU A  42      20.148  24.874   9.932  1.00 34.41           O  
ATOM    341  N   VAL A  43      16.168  21.578  14.715  1.00 12.23           N  
ATOM    342  CA  VAL A  43      15.167  20.540  14.966  1.00 12.18           C  
ATOM    343  C   VAL A  43      15.084  20.234  16.448  1.00 12.03           C  
ATOM    344  O   VAL A  43      15.925  20.685  17.239  1.00 14.21           O  
ATOM    345  CB  VAL A  43      15.523  19.234  14.178  1.00 12.11           C  
ATOM    346  CG1 VAL A  43      15.504  19.475  12.676  1.00 15.35           C  
ATOM    347  CG2 VAL A  43      16.885  18.694  14.669  1.00 14.04           C  
ATOM    348  N   ASP A  44      14.087  19.439  16.822  0.50 12.01           N  
ATOM    350  CA  ASP A  44      13.833  19.140  18.227  0.50 12.19           C  
ATOM    352  C   ASP A  44      14.148  17.716  18.670  0.50 11.11           C  
ATOM    354  O   ASP A  44      14.352  17.479  19.862  0.50 11.85           O  
ATOM    356  CB  ASP A  44      12.358  19.417  18.601  0.50 13.05           C  
ATOM    358  CG  ASP A  44      12.111  19.257  20.078  0.50 16.25           C  
ATOM    360  OD1 ASP A  44      12.880  19.872  20.845  0.50 19.64           O  
ATOM    362  OD2 ASP A  44      11.190  18.504  20.468  0.50 20.59           O  
ATOM    364  N   THR A  45      14.125  16.770  17.739  1.00 10.02           N  
ATOM    365  CA  THR A  45      14.228  15.361  18.116  1.00  9.68           C  
ATOM    366  C   THR A  45      15.287  14.615  17.319  1.00  9.50           C  
ATOM    367  O   THR A  45      15.764  15.115  16.301  1.00  9.32           O  
ATOM    368  CB  THR A  45      12.887  14.615  17.930  1.00 10.32           C  
ATOM    369  OG1 THR A  45      12.630  14.562  16.524  1.00 11.69           O  
ATOM    370  CG2 THR A  45      11.717  15.323  18.681  1.00 11.84           C  
ATOM    371  N   LEU A  46      15.615  13.416  17.783  1.00  9.25           N  
ATOM    372  CA  LEU A  46      16.569  12.579  17.088  1.00  8.79           C  
ATOM    373  C   LEU A  46      16.095  12.197  15.681  1.00  8.69           C  
ATOM    374  O   LEU A  46      16.860  12.262  14.710  1.00  8.88           O  
ATOM    375  CB  LEU A  46      16.868  11.350  17.972  1.00  9.70           C  
ATOM    376  CG  LEU A  46      17.995  10.452  17.470  1.00  9.55           C  
ATOM    377  CD1 LEU A  46      19.338  11.143  17.380  1.00 11.72           C  
ATOM    378  CD2 LEU A  46      18.066   9.246  18.398  1.00 10.82           C  
ATOM    379  N   SER A  47      14.822  11.824  15.552  1.00  8.84           N  
ATOM    380  CA  SER A  47      14.314  11.544  14.217  0.50  9.16           C  
ATOM    382  C   SER A  47      14.321  12.832  13.381  1.00  9.12           C  
ATOM    383  O   SER A  47      14.622  12.766  12.185  1.00  9.54           O  
ATOM    384  CB  SER A  47      12.929  10.903  14.296  0.50  9.94           C  
ATOM    386  OG  SER A  47      12.025  11.800  14.898  0.50 10.03           O  
ATOM    388  N   GLY A  48      14.065  13.991  13.996  1.00  8.70           N  
ATOM    389  CA  GLY A  48      14.154  15.251  13.249  1.00  9.31           C  
ATOM    390  C   GLY A  48      15.556  15.493  12.725  1.00  8.45           C  
ATOM    391  O   GLY A  48      15.720  15.962  11.584  1.00  9.37           O  
ATOM    392  N   LEU A  49      16.583  15.205  13.535  1.00  8.82           N  
ATOM    393  CA  LEU A  49      17.954  15.381  13.062  1.00  8.79           C  
ATOM    394  C   LEU A  49      18.204  14.453  11.863  1.00  8.58           C  
ATOM    395  O   LEU A  49      18.827  14.855  10.878  1.00  9.07           O  
ATOM    396  CB  LEU A  49      18.940  15.070  14.185  1.00  9.31           C  
ATOM    397  CG  LEU A  49      20.420  15.187  13.803  1.00 10.48           C  
ATOM    398  CD1 LEU A  49      20.784  16.605  13.338  1.00 13.10           C  
ATOM    399  CD2 LEU A  49      21.257  14.787  15.014  1.00 11.45           C  
ATOM    400  N   PHE A  50      17.716  13.209  11.933  1.00  8.66           N  
ATOM    401  CA  PHE A  50      17.879  12.290  10.813  1.00  8.20           C  
ATOM    402  C   PHE A  50      17.260  12.874   9.556  1.00  8.30           C  
ATOM    403  O   PHE A  50      17.901  12.877   8.479  1.00  8.51           O  
ATOM    404  CB  PHE A  50      17.236  10.937  11.193  1.00  8.22           C  
ATOM    405  CG  PHE A  50      17.717   9.807  10.310  1.00  7.70           C  
ATOM    406  CD1 PHE A  50      18.757   8.989  10.753  1.00  9.36           C  
ATOM    407  CD2 PHE A  50      17.144   9.551   9.054  1.00  8.86           C  
ATOM    408  CE1 PHE A  50      19.256   7.960   9.959  1.00  8.98           C  
ATOM    409  CE2 PHE A  50      17.646   8.544   8.251  1.00  8.62           C  
ATOM    410  CZ  PHE A  50      18.696   7.758   8.704  1.00  8.96           C  
ATOM    411  N   LEU A  51      16.023  13.392   9.677  1.00  8.41           N  
ATOM    412  CA  LEU A  51      15.355  13.981   8.507  1.00  8.75           C  
ATOM    413  C   LEU A  51      16.092  15.215   7.997  1.00  9.59           C  
ATOM    414  O   LEU A  51      16.114  15.493   6.794  1.00 10.05           O  
ATOM    415  CB  LEU A  51      13.914  14.387   8.859  1.00  8.94           C  
ATOM    416  CG  LEU A  51      12.988  13.247   9.263  1.00  9.93           C  
ATOM    417  CD1 LEU A  51      11.617  13.778   9.626  1.00 10.85           C  
ATOM    418  CD2 LEU A  51      12.873  12.200   8.134  1.00 11.56           C  
ATOM    419  N   GLU A  52      16.663  15.996   8.910  1.00  9.97           N  
ATOM    420  CA  GLU A  52      17.377  17.223   8.516  1.00 10.85           C  
ATOM    421  C   GLU A  52      18.645  16.878   7.742  1.00 10.95           C  
ATOM    422  O   GLU A  52      19.036  17.616   6.813  1.00 12.13           O  
ATOM    423  CB  GLU A  52      17.756  18.013   9.774  1.00 12.11           C  
ATOM    424  CG  GLU A  52      18.216  19.434   9.509  1.00 16.59           C  
ATOM    425  CD  GLU A  52      17.125  20.398   9.133  1.00 21.51           C  
ATOM    426  OE1 GLU A  52      15.938  20.111   9.279  1.00 22.78           O  
ATOM    427  OE2 GLU A  52      17.474  21.538   8.744  1.00 29.45           O  
ATOM    428  N   ILE A  53      19.300  15.772   8.122  1.00  9.52           N  
ATOM    429  CA  ILE A  53      20.483  15.336   7.380  1.00 10.02           C  
ATOM    430  C   ILE A  53      20.119  14.763   6.004  1.00 10.62           C  
ATOM    431  O   ILE A  53      20.763  15.078   4.988  1.00 11.87           O  
ATOM    432  CB  ILE A  53      21.304  14.296   8.187  1.00  9.76           C  
ATOM    433  CG1 ILE A  53      21.854  14.916   9.488  1.00 10.84           C  
ATOM    434  CG2 ILE A  53      22.429  13.694   7.369  1.00 10.76           C  
ATOM    435  CD1 ILE A  53      22.301  13.853  10.505  1.00 11.11           C  
ATOM    436  N   LYS A  54      19.095  13.910   5.968  1.00  9.42           N  
ATOM    437  CA  LYS A  54      18.832  13.114   4.762  1.00  9.54           C  
ATOM    438  C   LYS A  54      17.862  13.771   3.781  1.00 10.83           C  
ATOM    439  O   LYS A  54      17.918  13.482   2.595  1.00 11.78           O  
ATOM    440  CB  LYS A  54      18.356  11.706   5.137  1.00 10.27           C  
ATOM    441  CG  LYS A  54      19.411  10.921   5.913  1.00 10.32           C  
ATOM    442  CD  LYS A  54      20.666  10.577   5.078  1.00 11.22           C  
ATOM    443  CE  LYS A  54      20.420   9.607   3.927  1.00 13.33           C  
ATOM    444  NZ  LYS A  54      19.905   8.297   4.423  1.00 13.05           N  
ATOM    445  N   GLN A  55      16.977  14.614   4.293  1.00 10.36           N  
ATOM    446  CA  GLN A  55      16.080  15.406   3.450  0.50 11.16           C  
ATOM    448  C   GLN A  55      15.261  14.548   2.488  1.00 11.41           C  
ATOM    449  O   GLN A  55      15.080  14.889   1.308  1.00 12.63           O  
ATOM    450  CB  GLN A  55      16.884  16.485   2.740  0.50 11.91           C  
ATOM    452  CG  GLN A  55      17.328  17.551   3.752  0.50 14.49           C  
ATOM    454  CD  GLN A  55      16.169  18.452   4.122  0.50 15.14           C  
ATOM    456  OE1 GLN A  55      15.713  19.200   3.292  0.50 13.41           O  
ATOM    458  NE2 GLN A  55      15.621  18.306   5.367  0.50 17.65           N  
ATOM    460  N   GLU A  56      14.742  13.446   3.015  1.00  9.63           N  
ATOM    461  CA  GLU A  56      13.890  12.541   2.250  1.00  9.73           C  
ATOM    462  C   GLU A  56      13.051  11.734   3.221  1.00  9.28           C  
ATOM    463  O   GLU A  56      13.381  11.663   4.420  1.00  9.53           O  
ATOM    464  CB  GLU A  56      14.747  11.613   1.383  1.00 10.41           C  
ATOM    465  CG  GLU A  56      15.597  10.655   2.205  1.00 10.34           C  
ATOM    466  CD  GLU A  56      16.610   9.871   1.394  1.00 11.35           C  
ATOM    467  OE1 GLU A  56      16.598   9.932   0.138  1.00 16.52           O  
ATOM    468  OE2 GLU A  56      17.410   9.172   2.040  1.00 12.39           O  
ATOM    469  N   LEU A  57      11.985  11.114   2.730  1.00  9.24           N  
ATOM    470  CA  LEU A  57      11.201  10.254   3.619  1.00  9.27           C  
ATOM    471  C   LEU A  57      12.067   9.056   4.018  1.00  8.61           C  
ATOM    472  O   LEU A  57      12.778   8.498   3.171  1.00  8.90           O  
ATOM    473  CB  LEU A  57       9.916   9.784   2.921  1.00 10.21           C  
ATOM    474  CG  LEU A  57       8.766  10.798   3.039  1.00 11.07           C  
ATOM    475  CD1 LEU A  57       8.978  12.019   2.150  1.00 12.61           C  
ATOM    476  CD2 LEU A  57       7.463  10.090   2.675  1.00 13.15           C  
ATOM    477  N   PRO A  58      12.007   8.652   5.283  1.00  8.26           N  
ATOM    478  CA  PRO A  58      12.888   7.589   5.782  1.00  8.36           C  
ATOM    479  C   PRO A  58      12.382   6.170   5.533  1.00  8.41           C  
ATOM    480  O   PRO A  58      11.154   5.928   5.371  1.00  8.47           O  
ATOM    481  CB  PRO A  58      12.934   7.839   7.292  1.00  9.23           C  
ATOM    482  CG  PRO A  58      11.551   8.419   7.560  1.00  9.48           C  
ATOM    483  CD  PRO A  58      11.259   9.327   6.365  1.00  8.43           C  
ATOM    484  N   HIS A  59      13.336   5.233   5.530  1.00  7.97           N  
ATOM    485  CA  HIS A  59      13.042   3.809   5.526  1.00  7.87           C  
ATOM    486  C   HIS A  59      13.871   3.137   6.609  1.00  8.76           C  
ATOM    487  O   HIS A  59      14.976   3.589   6.958  1.00  9.04           O  
ATOM    488  CB  HIS A  59      13.455   3.162   4.187  1.00  8.59           C  
ATOM    489  CG  HIS A  59      12.541   3.481   3.039  1.00  8.12           C  
ATOM    490  ND1 HIS A  59      12.685   4.619   2.267  1.00  8.79           N  
ATOM    491  CD2 HIS A  59      11.487   2.797   2.513  1.00  9.20           C  
ATOM    492  CE1 HIS A  59      11.743   4.631   1.320  1.00  9.16           C  
ATOM    493  NE2 HIS A  59      11.003   3.535   1.451  1.00  9.03           N  
ATOM    494  N   VAL A  60      13.379   1.987   7.068  1.00  8.21           N  
ATOM    495  CA  VAL A  60      14.219   1.121   7.904  1.00  9.25           C  
ATOM    496  C   VAL A  60      15.500   0.774   7.137  1.00  8.22           C  
ATOM    497  O   VAL A  60      15.502   0.480   5.922  1.00  9.67           O  
ATOM    498  CB  VAL A  60      13.441  -0.169   8.272  1.00 10.17           C  
ATOM    499  CG1 VAL A  60      14.368  -1.156   9.028  1.00 12.43           C  
ATOM    500  CG2 VAL A  60      12.236   0.191   9.141  1.00 12.33           C  
ATOM    501  N   GLY A  61      16.633   0.833   7.862  1.00  8.99           N  
ATOM    502  CA  GLY A  61      17.934   0.567   7.255  1.00  9.52           C  
ATOM    503  C   GLY A  61      18.681   1.803   6.805  1.00 10.14           C  
ATOM    504  O   GLY A  61      19.869   1.747   6.523  1.00 11.21           O  
ATOM    505  N   ASP A  62      18.003   2.938   6.719  1.00  8.95           N  
ATOM    506  CA  ASP A  62      18.686   4.153   6.308  1.00  8.73           C  
ATOM    507  C   ASP A  62      19.719   4.540   7.371  1.00  8.68           C  
ATOM    508  O   ASP A  62      19.506   4.338   8.583  1.00  9.11           O  
ATOM    509  CB  ASP A  62      17.694   5.313   6.186  1.00  8.76           C  
ATOM    510  CG  ASP A  62      16.807   5.224   4.946  1.00  9.14           C  
ATOM    511  OD1 ASP A  62      16.927   4.262   4.169  1.00  9.44           O  
ATOM    512  OD2 ASP A  62      15.963   6.152   4.808  1.00  8.98           O  
ATOM    513  N   THR A  63      20.791   5.164   6.910  1.00  8.50           N  
ATOM    514  CA  THR A  63      21.812   5.678   7.815  1.00  9.39           C  
ATOM    515  C   THR A  63      22.087   7.162   7.537  1.00  9.02           C  
ATOM    516  O   THR A  63      21.771   7.695   6.457  1.00 10.13           O  
ATOM    517  CB  THR A  63      23.129   4.894   7.687  1.00 10.73           C  
ATOM    518  OG1 THR A  63      23.690   5.051   6.380  1.00 13.72           O  
ATOM    519  CG2 THR A  63      22.923   3.400   8.004  1.00 12.88           C  
ATOM    520  N   ALA A  64      22.681   7.840   8.519  1.00  9.27           N  
ATOM    521  CA  ALA A  64      23.025   9.245   8.370  1.00  9.46           C  
ATOM    522  C   ALA A  64      24.246   9.483   9.230  1.00  9.23           C  
ATOM    523  O   ALA A  64      24.409   8.819  10.265  1.00  9.78           O  
ATOM    524  CB  ALA A  64      21.887  10.142   8.825  1.00 10.25           C  
ATOM    525  N   VAL A  65      25.076  10.445   8.842  1.00  9.27           N  
ATOM    526  CA  VAL A  65      26.292  10.762   9.600  1.00  9.82           C  
ATOM    527  C   VAL A  65      26.271  12.229   9.991  1.00  8.84           C  
ATOM    528  O   VAL A  65      25.943  13.093   9.168  1.00 10.14           O  
ATOM    529  CB  VAL A  65      27.562  10.430   8.772  1.00 10.52           C  
ATOM    530  CG1 VAL A  65      28.844  10.904   9.501  1.00 11.86           C  
ATOM    531  CG2 VAL A  65      27.640   8.926   8.532  1.00 13.64           C  
ATOM    532  N   TYR A  66      26.634  12.518  11.246  1.00  8.34           N  
ATOM    533  CA  TYR A  66      26.927  13.881  11.666  1.00  8.32           C  
ATOM    534  C   TYR A  66      28.117  13.707  12.615  1.00  8.01           C  
ATOM    535  O   TYR A  66      27.929  13.397  13.802  1.00  8.45           O  
ATOM    536  CB  TYR A  66      25.716  14.535  12.385  1.00  9.13           C  
ATOM    537  CG  TYR A  66      25.921  16.033  12.526  1.00  8.01           C  
ATOM    538  CD1 TYR A  66      25.541  16.891  11.497  1.00  9.52           C  
ATOM    539  CD2 TYR A  66      26.553  16.570  13.640  1.00  9.14           C  
ATOM    540  CE1 TYR A  66      25.778  18.258  11.572  1.00  8.50           C  
ATOM    541  CE2 TYR A  66      26.788  17.913  13.742  1.00  9.06           C  
ATOM    542  CZ  TYR A  66      26.400  18.761  12.710  1.00  8.90           C  
ATOM    543  OH  TYR A  66      26.672  20.112  12.819  1.00 10.07           O  
ATOM    544  N   GLU A  67      29.331  13.840  12.058  1.00  8.26           N  
ATOM    545  CA  GLU A  67      30.512  13.355  12.770  1.00  8.79           C  
ATOM    546  C   GLU A  67      30.564  13.956  14.181  1.00  8.58           C  
ATOM    547  O   GLU A  67      30.346  15.154  14.350  1.00  9.13           O  
ATOM    548  CB  GLU A  67      31.793  13.690  12.009  1.00  9.94           C  
ATOM    549  CG  GLU A  67      32.031  12.844  10.762  1.00 10.46           C  
ATOM    550  CD  GLU A  67      32.480  11.429  11.056  1.00 11.34           C  
ATOM    551  OE1 GLU A  67      32.609  11.061  12.229  1.00 13.00           O  
ATOM    552  OE2 GLU A  67      32.779  10.681  10.098  1.00 15.33           O  
ATOM    553  N   PRO A  68      30.926  13.151  15.199  1.00  8.20           N  
ATOM    554  CA  PRO A  68      31.413  11.770  15.154  1.00  9.50           C  
ATOM    555  C   PRO A  68      30.305  10.723  15.200  1.00  9.22           C  
ATOM    556  O   PRO A  68      30.612   9.551  15.401  1.00 10.83           O  
ATOM    557  CB  PRO A  68      32.256  11.684  16.428  1.00  9.80           C  
ATOM    558  CG  PRO A  68      31.466  12.536  17.401  1.00 10.10           C  
ATOM    559  CD  PRO A  68      31.037  13.737  16.554  1.00  8.91           C  
ATOM    560  N   PHE A  69      29.049  11.131  15.020  1.00  8.30           N  
ATOM    561  CA  PHE A  69      27.920  10.208  15.187  1.00  8.76           C  
ATOM    562  C   PHE A  69      27.513   9.562  13.883  1.00  8.70           C  
ATOM    563  O   PHE A  69      27.539  10.188  12.821  1.00  9.44           O  
ATOM    564  CB  PHE A  69      26.717  10.996  15.757  1.00  9.19           C  
ATOM    565  CG  PHE A  69      27.035  11.697  17.053  1.00  8.47           C  
ATOM    566  CD1 PHE A  69      27.261  13.061  17.066  1.00  9.00           C  
ATOM    567  CD2 PHE A  69      27.200  10.984  18.227  1.00  9.48           C  
ATOM    568  CE1 PHE A  69      27.599  13.704  18.245  1.00 10.09           C  
ATOM    569  CE2 PHE A  69      27.558  11.631  19.427  1.00 10.33           C  
ATOM    570  CZ  PHE A  69      27.762  12.985  19.436  1.00 10.81           C  
ATOM    571  N   ARG A  70      27.068   8.324  13.993  1.00  8.47           N  
ATOM    572  CA  ARG A  70      26.416   7.641  12.889  1.00  9.73           C  
ATOM    573  C   ARG A  70      25.092   7.100  13.415  1.00  9.18           C  
ATOM    574  O   ARG A  70      25.036   6.516  14.518  1.00  9.38           O  
ATOM    575  CB  ARG A  70      27.285   6.485  12.377  1.00 10.48           C  
ATOM    576  CG  ARG A  70      26.693   5.785  11.158  1.00 14.75           C  
ATOM    577  CD  ARG A  70      27.617   4.591  10.717  1.00 17.61           C  
ATOM    578  NE  ARG A  70      27.060   3.896   9.552  1.00 26.83           N  
ATOM    579  CZ  ARG A  70      27.192   4.329   8.303  1.00 30.12           C  
ATOM    580  NH1 ARG A  70      27.887   5.439   8.070  1.00 32.80           N  
ATOM    581  NH2 ARG A  70      26.628   3.652   7.295  1.00 30.40           N  
ATOM    582  N   PHE A  71      24.040   7.304  12.627  1.00  8.35           N  
ATOM    583  CA  PHE A  71      22.679   6.937  13.019  1.00  8.72           C  
ATOM    584  C   PHE A  71      22.116   5.935  12.035  1.00  8.47           C  
ATOM    585  O   PHE A  71      22.425   5.998  10.833  1.00  9.24           O  
ATOM    586  CB  PHE A  71      21.785   8.184  12.907  1.00  8.73           C  
ATOM    587  CG  PHE A  71      22.285   9.372  13.703  1.00  9.15           C  
ATOM    588  CD1 PHE A  71      22.267   9.346  15.090  1.00  9.41           C  
ATOM    589  CD2 PHE A  71      22.787  10.511  13.079  1.00 11.69           C  
ATOM    590  CE1 PHE A  71      22.740  10.418  15.830  1.00  9.68           C  
ATOM    591  CE2 PHE A  71      23.258  11.613  13.836  1.00 10.78           C  
ATOM    592  CZ  PHE A  71      23.199  11.554  15.220  1.00  9.08           C  
ATOM    593  N   GLN A  72      21.291   5.010  12.516  1.00  8.56           N  
ATOM    594  CA  GLN A  72      20.620   4.094  11.611  1.00  8.93           C  
ATOM    595  C   GLN A  72      19.161   3.948  12.075  1.00  8.29           C  
ATOM    596  O   GLN A  72      18.882   3.784  13.273  1.00  8.79           O  
ATOM    597  CB  GLN A  72      21.297   2.720  11.645  1.00  9.62           C  
ATOM    598  CG  GLN A  72      20.634   1.661  10.740  1.00 12.09           C  
ATOM    599  CD  GLN A  72      21.423   0.363  10.786  1.00 14.60           C  
ATOM    600  OE1 GLN A  72      22.647   0.384  10.954  1.00 20.31           O  
ATOM    601  NE2 GLN A  72      20.757  -0.744  10.575  1.00 17.90           N  
ATOM    602  N   VAL A  73      18.228   4.015  11.112  1.00  8.50           N  
ATOM    603  CA  VAL A  73      16.809   3.777  11.458  1.00  8.74           C  
ATOM    604  C   VAL A  73      16.660   2.273  11.619  1.00  9.35           C  
ATOM    605  O   VAL A  73      16.779   1.537  10.640  1.00 10.27           O  
ATOM    606  CB  VAL A  73      15.860   4.294  10.360  1.00  8.83           C  
ATOM    607  CG1 VAL A  73      14.419   3.893  10.656  1.00 10.10           C  
ATOM    608  CG2 VAL A  73      15.975   5.791  10.281  1.00 10.83           C  
ATOM    609  N   THR A  74      16.370   1.823  12.847  1.00  9.32           N  
ATOM    610  CA  THR A  74      16.243   0.381  13.069  1.00  9.81           C  
ATOM    611  C   THR A  74      14.782  -0.074  13.100  1.00 10.34           C  
ATOM    612  O   THR A  74      14.518  -1.244  12.842  1.00 11.62           O  
ATOM    613  CB  THR A  74      16.927  -0.022  14.378  1.00 10.43           C  
ATOM    614  OG1 THR A  74      16.419   0.814  15.429  1.00 11.96           O  
ATOM    615  CG2 THR A  74      18.458   0.124  14.226  1.00 11.78           C  
ATOM    616  N   GLN A  75      13.857   0.831  13.429  1.00  9.82           N  
ATOM    617  CA  GLN A  75      12.423   0.469  13.424  1.00 10.07           C  
ATOM    618  C   GLN A  75      11.592   1.655  12.991  1.00  9.79           C  
ATOM    619  O   GLN A  75      11.901   2.807  13.346  1.00 10.55           O  
ATOM    620  CB  GLN A  75      11.945   0.044  14.813  1.00 11.46           C  
ATOM    621  CG  GLN A  75      12.649  -1.195  15.355  1.00 13.04           C  
ATOM    622  CD  GLN A  75      11.973  -1.676  16.617  1.00 16.17           C  
ATOM    623  OE1 GLN A  75      10.763  -1.988  16.610  1.00 19.06           O  
ATOM    624  NE2 GLN A  75      12.723  -1.738  17.695  1.00 18.60           N  
HETATM  625  N   MSE A  76      10.515   1.354  12.249  1.00 10.55           N  
HETATM  626  CA  MSE A  76       9.490   2.330  11.914  1.00 10.54           C  
HETATM  627  C   MSE A  76       8.148   1.693  12.159  1.00 11.37           C  
HETATM  628  O   MSE A  76       8.034   0.467  12.091  1.00 12.07           O  
HETATM  629  CB  MSE A  76       9.539   2.729  10.428  1.00 10.28           C  
HETATM  630  CG  MSE A  76      10.764   3.576  10.095  1.00 10.06           C  
HETATM  631 SE   MSE A  76      10.780   4.284   8.306  1.00 14.44          SE  
HETATM  632  CE  MSE A  76       9.258   5.471   8.461  1.00 11.05           C  
ATOM    633  N   ASP A  77       7.138   2.517  12.422  1.00 11.30           N  
ATOM    634  CA  ASP A  77       5.748   2.046  12.310  1.00 11.73           C  
ATOM    635  C   ASP A  77       5.314   2.344  10.864  1.00 11.14           C  
ATOM    636  O   ASP A  77       6.191   2.405   9.976  1.00 11.88           O  
ATOM    637  CB  ASP A  77       4.854   2.595  13.439  1.00 12.90           C  
ATOM    638  CG  ASP A  77       4.791   4.104  13.498  1.00 13.09           C  
ATOM    639  OD1 ASP A  77       5.036   4.784  12.469  1.00 14.84           O  
ATOM    640  OD2 ASP A  77       4.462   4.607  14.610  1.00 16.17           O  
ATOM    641  N   LYS A  78       4.036   2.520  10.566  1.00 11.38           N  
ATOM    642  CA  LYS A  78       3.695   2.671   9.153  1.00 10.27           C  
ATOM    643  C   LYS A  78       4.223   3.983   8.577  1.00 10.59           C  
ATOM    644  O   LYS A  78       4.467   4.055   7.364  1.00 12.35           O  
ATOM    645  CB  LYS A  78       2.185   2.613   8.967  1.00 11.98           C  
ATOM    646  CG  LYS A  78       1.672   1.153   9.043  1.00 12.10           C  
ATOM    647  CD  LYS A  78       0.158   1.152   8.963  1.00 14.55           C  
ATOM    648  CE  LYS A  78      -0.422  -0.241   9.196  1.00 16.38           C  
ATOM    649  NZ  LYS A  78      -0.037  -1.171   8.102  1.00 19.20           N  
ATOM    650  N   ARG A  79       4.426   5.000   9.397  1.00 10.99           N  
ATOM    651  CA  ARG A  79       4.827   6.319   8.893  1.00 11.83           C  
ATOM    652  C   ARG A  79       5.970   7.001   9.602  1.00 12.76           C  
ATOM    653  O   ARG A  79       6.473   7.991   9.076  1.00 14.89           O  
ATOM    654  CB  ARG A  79       3.643   7.314   8.901  1.00 12.93           C  
ATOM    655  CG  ARG A  79       2.446   6.882   8.075  1.00 12.95           C  
ATOM    656  CD  ARG A  79       2.767   6.924   6.591  1.00 13.49           C  
ATOM    657  NE  ARG A  79       1.642   6.410   5.808  1.00 14.16           N  
ATOM    658  CZ  ARG A  79       1.752   6.008   4.548  1.00 14.48           C  
ATOM    659  NH1 ARG A  79       2.930   6.137   3.908  1.00 16.94           N  
ATOM    660  NH2 ARG A  79       0.689   5.531   3.903  1.00 15.71           N  
ATOM    661  N   ARG A  80       6.380   6.525  10.774  1.00 11.79           N  
ATOM    662  CA  ARG A  80       7.331   7.293  11.613  0.50 12.33           C  
ATOM    664  C   ARG A  80       8.531   6.464  11.997  1.00 11.29           C  
ATOM    665  O   ARG A  80       8.386   5.253  12.239  1.00 11.38           O  
ATOM    666  CB  ARG A  80       6.645   7.776  12.924  0.50 13.66           C  
ATOM    668  CG  ARG A  80       5.287   8.434  12.738  0.50 16.23           C  
ATOM    670  CD  ARG A  80       5.375   9.692  11.893  0.50 19.65           C  
ATOM    672  NE  ARG A  80       4.158  10.489  12.012  0.50 23.65           N  
ATOM    674  CZ  ARG A  80       3.938  11.425  12.937  0.50 25.06           C  
ATOM    676  NH1 ARG A  80       4.859  11.727  13.844  0.50 26.85           N  
ATOM    678  NH2 ARG A  80       2.784  12.077  12.946  0.50 28.11           N  
ATOM    680  N   ILE A  81       9.683   7.135  12.097  1.00 11.03           N  
ATOM    681  CA  ILE A  81      10.840   6.521  12.740  1.00 10.80           C  
ATOM    682  C   ILE A  81      10.558   6.340  14.220  1.00 11.58           C  
ATOM    683  O   ILE A  81      10.287   7.329  14.917  1.00 13.66           O  
ATOM    684  CB  ILE A  81      12.059   7.449  12.605  1.00 10.98           C  
ATOM    685  CG1 ILE A  81      12.476   7.585  11.128  1.00 11.00           C  
ATOM    686  CG2 ILE A  81      13.223   6.873  13.423  1.00 12.08           C  
ATOM    687  CD1 ILE A  81      13.466   8.757  10.903  1.00 11.34           C  
ATOM    688  N   ILE A  82      10.606   5.100  14.703  1.00 10.80           N  
ATOM    689  CA  ILE A  82      10.368   4.839  16.117  1.00 12.38           C  
ATOM    690  C   ILE A  82      11.630   4.409  16.874  1.00 10.93           C  
ATOM    691  O   ILE A  82      11.639   4.532  18.096  1.00 11.46           O  
ATOM    692  CB  ILE A  82       9.196   3.909  16.355  1.00 12.93           C  
ATOM    693  CG1 ILE A  82       9.490   2.495  15.886  1.00 13.37           C  
ATOM    694  CG2 ILE A  82       7.908   4.488  15.729  1.00 15.23           C  
ATOM    695  CD1 ILE A  82       8.292   1.503  16.138  1.00 15.39           C  
ATOM    696  N   GLU A  83      12.676   3.946  16.178  1.00 10.49           N  
ATOM    697  CA  GLU A  83      13.923   3.652  16.888  1.00  9.83           C  
ATOM    698  C   GLU A  83      15.084   3.989  15.974  1.00  8.95           C  
ATOM    699  O   GLU A  83      15.062   3.666  14.780  1.00  9.58           O  
ATOM    700  CB  GLU A  83      13.998   2.186  17.272  1.00 10.71           C  
ATOM    701  CG  GLU A  83      15.199   1.851  18.194  1.00 11.79           C  
ATOM    702  CD  GLU A  83      15.192   0.373  18.523  1.00 13.79           C  
ATOM    703  OE1 GLU A  83      15.453  -0.434  17.609  1.00 14.75           O  
ATOM    704  OE2 GLU A  83      14.935   0.011  19.697  1.00 15.42           O  
ATOM    705  N   ILE A  84      16.077   4.643  16.581  1.00  9.31           N  
ATOM    706  CA  ILE A  84      17.329   4.951  15.924  1.00  9.58           C  
ATOM    707  C   ILE A  84      18.478   4.381  16.751  1.00  8.58           C  
ATOM    708  O   ILE A  84      18.531   4.570  17.984  1.00  9.61           O  
ATOM    709  CB  ILE A  84      17.496   6.482  15.745  1.00  9.86           C  
ATOM    710  CG1 ILE A  84      16.561   6.954  14.616  1.00 12.53           C  
ATOM    711  CG2 ILE A  84      18.946   6.888  15.419  1.00 10.81           C  
ATOM    712  CD1 ILE A  84      16.399   8.479  14.520  1.00 13.28           C  
ATOM    713  N   LYS A  85      19.391   3.704  16.055  1.00  8.51           N  
ATOM    714  CA  LYS A  85      20.669   3.295  16.632  1.00  8.66           C  
ATOM    715  C   LYS A  85      21.672   4.427  16.514  1.00  9.13           C  
ATOM    716  O   LYS A  85      21.820   5.016  15.430  1.00  9.02           O  
ATOM    717  CB  LYS A  85      21.200   2.085  15.870  1.00  9.37           C  
ATOM    718  CG  LYS A  85      22.607   1.708  16.270  1.00  9.96           C  
ATOM    719  CD  LYS A  85      23.012   0.370  15.604  1.00 13.34           C  
ATOM    720  CE  LYS A  85      24.502   0.124  15.857  1.00 13.94           C  
ATOM    721  NZ  LYS A  85      24.920  -1.198  15.261  1.00 15.07           N  
ATOM    722  N   ILE A  86      22.374   4.705  17.628  1.00  8.81           N  
ATOM    723  CA  ILE A  86      23.553   5.591  17.603  1.00  8.79           C  
ATOM    724  C   ILE A  86      24.755   4.655  17.774  1.00  9.26           C  
ATOM    725  O   ILE A  86      24.826   3.896  18.758  1.00  9.99           O  
ATOM    726  CB  ILE A  86      23.478   6.663  18.719  1.00  9.47           C  
ATOM    727  CG1 ILE A  86      22.229   7.523  18.541  1.00 10.16           C  
ATOM    728  CG2 ILE A  86      24.778   7.476  18.724  1.00 10.53           C  
ATOM    729  CD1 ILE A  86      22.036   8.596  19.620  1.00 11.00           C  
ATOM    730  N   PHE A  87      25.655   4.669  16.792  1.00  9.74           N  
ATOM    731  CA  PHE A  87      26.821   3.794  16.847  1.00  9.94           C  
ATOM    732  C   PHE A  87      27.773   4.244  17.953  1.00 10.21           C  
ATOM    733  O   PHE A  87      27.688   5.376  18.450  1.00 10.07           O  
ATOM    734  CB  PHE A  87      27.521   3.813  15.479  1.00 10.75           C  
ATOM    735  CG  PHE A  87      26.900   2.903  14.453  1.00 11.71           C  
ATOM    736  CD1 PHE A  87      27.518   1.713  14.102  1.00 15.44           C  
ATOM    737  CD2 PHE A  87      25.684   3.242  13.868  1.00 12.71           C  
ATOM    738  CE1 PHE A  87      26.935   0.854  13.152  1.00 17.84           C  
ATOM    739  CE2 PHE A  87      25.090   2.418  12.915  1.00 14.20           C  
ATOM    740  CZ  PHE A  87      25.721   1.213  12.563  1.00 17.15           C  
ATOM    741  N   PRO A  88      28.710   3.361  18.337  1.00 11.05           N  
ATOM    742  CA  PRO A  88      29.691   3.819  19.334  1.00 11.46           C  
ATOM    743  C   PRO A  88      30.452   5.018  18.777  1.00 12.01           C  
ATOM    744  O   PRO A  88      30.752   5.041  17.566  1.00 13.66           O  
ATOM    745  CB  PRO A  88      30.637   2.618  19.483  1.00 13.02           C  
ATOM    746  CG  PRO A  88      29.860   1.420  18.893  1.00 12.35           C  
ATOM    747  CD  PRO A  88      28.978   2.000  17.839  1.00 12.32           C  
ATOM    748  N   PHE A  89      30.815   5.976  19.629  1.00 11.61           N  
ATOM    749  CA  PHE A  89      31.529   7.167  19.147  1.00 11.73           C  
ATOM    750  C   PHE A  89      32.685   7.491  20.082  1.00 12.56           C  
ATOM    751  O   PHE A  89      32.656   7.190  21.295  1.00 13.19           O  
ATOM    752  CB  PHE A  89      30.573   8.372  18.986  1.00 11.47           C  
ATOM    753  CG  PHE A  89      29.791   8.679  20.208  1.00 10.77           C  
ATOM    754  CD1 PHE A  89      30.289   9.602  21.145  1.00 11.24           C  
ATOM    755  CD2 PHE A  89      28.556   8.068  20.448  1.00 10.97           C  
ATOM    756  CE1 PHE A  89      29.586   9.871  22.305  1.00 11.41           C  
ATOM    757  CE2 PHE A  89      27.858   8.340  21.618  1.00 12.01           C  
ATOM    758  CZ  PHE A  89      28.365   9.244  22.529  1.00 10.74           C  
ATOM    759  N   GLU A  90      33.748   8.056  19.540  0.50 13.83           N  
ATOM    761  CA  GLU A  90      34.831   8.538  20.394  0.50 14.97           C  
ATOM    763  C   GLU A  90      34.672  10.060  20.560  0.50 14.49           C  
ATOM    765  O   GLU A  90      33.718  10.671  20.058  0.50 15.10           O  
ATOM    767  CB  GLU A  90      36.216   8.169  19.810  0.50 14.57           C  
ATOM    769  CG  GLU A  90      36.662   6.689  19.975  0.50 17.81           C  
ATOM    771  CD  GLU A  90      38.104   6.439  19.439  0.50 17.56           C  
ATOM    773  OE1 GLU A  90      39.032   6.352  20.267  0.50 22.42           O  
ATOM    775  OE2 GLU A  90      38.290   6.334  18.203  0.50 20.23           O  
ATOM    777  OXT GLU A  90      35.476  10.719  21.222  0.50 15.16           O  
TER     779      GLU A  90                                                      
END
MOLECULE T0453.pdb
ATOM   2776  N   ASP     5      13.939   7.853  29.974  1.00 47.92           N
ATOM   2777  CA  ASP     5      14.700   7.886  28.679  1.00 47.80           C
ATOM   2778  CB  ASP     5      16.179   8.247  28.883  1.00 48.46           C
ATOM   2779  CG  ASP     5      16.915   8.428  27.556  1.00 49.90           C
ATOM   2780  OD1 ASP     5      16.427   9.216  26.713  1.00 53.43           O
ATOM   2781  OD2 ASP     5      17.968   7.797  27.351  1.00 50.78           O
ATOM   2782  C   ASP     5      14.624   6.573  27.901  1.00 46.80           C
ATOM   2783  O   ASP     5      15.270   5.569  28.271  1.00 46.95           O
ATOM   2784  N   GLU     6      13.870   6.599  26.805  1.00 44.89           N
ATOM   2785  CA  GLU     6      13.698   5.424  25.972  1.00 43.39           C
ATOM   2786  CB  GLU     6      12.363   5.468  25.221  1.00 43.64           C
ATOM   2787  CG  GLU     6      11.131   5.428  26.152  1.00 45.88           C
ATOM   2788  CD  GLU     6       9.829   5.301  25.377  1.00 46.19           C
ATOM   2789  OE1 GLU     6       9.872   4.773  24.242  1.00 50.58           O
ATOM   2790  OE2 GLU     6       8.774   5.739  25.891  1.00 48.85           O
ATOM   2791  C   GLU     6      14.901   5.240  25.046  1.00 40.69           C
ATOM   2792  O   GLU     6      14.875   5.576  23.852  1.00 39.47           O
ATOM   2793  N   ILE     7      15.967   4.734  25.661  1.00 38.06           N
ATOM   2794  CA  ILE     7      17.195   4.329  24.992  1.00 35.06           C
ATOM   2795  C   ILE     7      17.767   3.198  25.815  1.00 33.04           C
ATOM   2796  O   ILE     7      17.799   3.277  27.042  1.00 31.68           O
ATOM   2797  N   VAL     8      18.195   2.143  25.133  1.00 30.90           N
ATOM   2798  CA  VAL     8      18.732   0.950  25.772  1.00 30.21           C
ATOM   2799  CB  VAL     8      17.769  -0.270  25.680  1.00 30.55           C
ATOM   2802  C   VAL     8      20.025   0.572  25.113  1.00 28.06           C
ATOM   2803  O   VAL     8      20.102   0.469  23.881  1.00 26.88           O
ATOM   2804  N   GLN     9      21.031   0.321  25.937  1.00 26.84           N
ATOM   2805  CA  GLN     9      22.367   0.059  25.399  1.00 26.48           C
ATOM   2806  CB  GLN     9      23.480   0.514  26.357  1.00 25.83           C
ATOM   2807  CG  GLN     9      24.881   0.340  25.761  1.00 27.00           C
ATOM   2808  CD  GLN     9      25.973   1.010  26.577  1.00 29.45           C
ATOM   2809  OE1 GLN     9      25.950   0.969  27.796  1.00 31.37           O
ATOM   2810  NE2 GLN     9      26.936   1.654  25.888  1.00 33.78           N
ATOM   2811  C   GLN     9      22.529  -1.409  25.071  1.00 25.52           C
ATOM   2812  O   GLN     9      22.124  -2.239  25.843  1.00 23.94           O
ATOM   2813  N   ARG    10      23.132  -1.687  23.910  1.00 25.48           N
ATOM   2814  CA  ARG    10      23.510  -3.026  23.498  1.00 26.37           C
ATOM   2815  CB  ARG    10      23.442  -3.155  21.970  1.00 25.98           C
ATOM   2816  CG  ARG    10      21.994  -2.867  21.456  1.00 27.79           C
ATOM   2817  CD  ARG    10      21.970  -2.770  19.945  1.00 24.56           C
ATOM   2818  NE  ARG    10      22.170  -4.085  19.311  1.00 25.22           N
ATOM   2819  CZ  ARG    10      23.008  -4.338  18.307  1.00 21.72           C
ATOM   2820  NH1 ARG    10      23.765  -3.384  17.827  1.00 24.80           N
ATOM   2821  NH2 ARG    10      23.097  -5.565  17.780  1.00 23.20           N
ATOM   2822  C   ARG    10      24.892  -3.384  24.002  1.00 25.51           C
ATOM   2823  O   ARG    10      25.615  -2.521  24.465  1.00 25.38           O
ATOM   2824  N   GLU    11      25.241  -4.660  23.912  1.00 25.67           N
ATOM   2825  CA  GLU    11      26.458  -5.157  24.546  1.00 26.58           C
ATOM   2826  CB  GLU    11      26.475  -6.695  24.621  1.00 26.73           C
ATOM   2827  CG  GLU    11      26.811  -7.369  23.288  1.00 26.42           C
ATOM   2828  CD  GLU    11      26.801  -8.892  23.365  1.00 26.53           C
ATOM   2829  OE1 GLU    11      25.739  -9.500  23.153  1.00 25.26           O
ATOM   2830  OE2 GLU    11      27.858  -9.481  23.595  1.00 22.61           O
ATOM   2831  C   GLU    11      27.724  -4.653  23.870  1.00 26.09           C
ATOM   2832  O   GLU    11      28.774  -4.670  24.498  1.00 26.17           O
ATOM   2833  N   ASP    12      27.605  -4.208  22.612  1.00 26.54           N
ATOM   2834  CA  ASP    12      28.712  -3.578  21.872  1.00 27.15           C
ATOM   2835  CB  ASP    12      28.593  -3.841  20.362  1.00 27.15           C
ATOM   2836  CG  ASP    12      27.446  -3.056  19.699  1.00 28.87           C
ATOM   2837  OD1 ASP    12      26.730  -2.292  20.385  1.00 28.52           O
ATOM   2838  OD2 ASP    12      27.260  -3.218  18.470  1.00 30.03           O
ATOM   2839  C   ASP    12      28.888  -2.075  22.174  1.00 26.71           C
ATOM   2840  O   ASP    12      29.816  -1.435  21.640  1.00 27.26           O
ATOM   2841  N   GLY    13      28.039  -1.520  23.043  1.00 25.81           N
ATOM   2842  CA  GLY    13      28.068  -0.073  23.310  1.00 25.36           C
ATOM   2843  C   GLY    13      27.134   0.818  22.476  1.00 25.63           C
ATOM   2844  O   GLY    13      26.940   1.992  22.803  1.00 25.79           O
ATOM   2845  N   SER    14      26.562   0.294  21.395  1.00 25.17           N
ATOM   2846  CA  SER    14      25.519   1.035  20.674  1.00 25.01           C
ATOM   2847  CB  SER    14      25.235   0.400  19.311  1.00 25.52           C
ATOM   2848  OG  SER    14      24.693  -0.912  19.479  1.00 26.93           O
ATOM   2849  C   SER    14      24.225   1.087  21.502  1.00 25.39           C
ATOM   2850  O   SER    14      24.061   0.342  22.504  1.00 24.08           O
ATOM   2851  N   TRP    15      23.324   1.994  21.106  1.00 24.85           N
ATOM   2852  CA  TRP    15      22.045   2.170  21.771  1.00 25.06           C
ATOM   2853  CB  TRP    15      21.980   3.558  22.438  1.00 25.81           C
ATOM   2854  CG  TRP    15      22.921   3.778  23.590  1.00 27.13           C
ATOM   2855  CD1 TRP    15      24.284   4.001  23.522  1.00 28.88           C
ATOM   2856  NE1 TRP    15      24.799   4.205  24.779  1.00 28.41           N
ATOM   2857  CE2 TRP    15      23.781   4.116  25.694  1.00 29.03           C
ATOM   2858  CD2 TRP    15      22.578   3.853  24.980  1.00 27.39           C
ATOM   2859  CE3 TRP    15      21.370   3.751  25.693  1.00 28.36           C
ATOM   2860  CZ3 TRP    15      21.409   3.873  27.107  1.00 28.62           C
ATOM   2861  CH2 TRP    15      22.624   4.114  27.781  1.00 27.99           C
ATOM   2862  CZ2 TRP    15      23.817   4.240  27.096  1.00 28.38           C
ATOM   2863  C   TRP    15      20.914   2.093  20.747  1.00 25.64           C
ATOM   2864  O   TRP    15      21.015   2.671  19.627  1.00 26.20           O
ATOM   2865  N   LEU    16      19.820   1.451  21.150  1.00 24.61           N
ATOM   2866  CA  LEU    16      18.548   1.577  20.451  1.00 23.88           C
ATOM   2867  CB  LEU    16      17.755   0.278  20.508  1.00 23.46           C
ATOM   2868  CG  LEU    16      18.471  -0.849  19.740  1.00 24.98           C
ATOM   2869  CD1 LEU    16      17.917  -2.209  20.149  1.00 23.39           C
ATOM   2870  CD2 LEU    16      18.339  -0.584  18.229  1.00 25.56           C
ATOM   2871  C   LEU    16      17.738   2.702  21.081  1.00 23.98           C
ATOM   2872  O   LEU    16      17.340   2.603  22.239  1.00 22.86           O
ATOM   2873  N   VAL    17      17.534   3.771  20.307  1.00 23.50           N
ATOM   2874  CA  VAL    17      16.891   4.985  20.811  1.00 23.44           C
ATOM   2875  CB  VAL    17      17.847   6.182  20.715  1.00 23.51           C
ATOM   2876  CG1 VAL    17      17.262   7.399  21.423  1.00 23.64           C
ATOM   2877  CG2 VAL    17      19.264   5.793  21.302  1.00 22.30           C
ATOM   2878  C   VAL    17      15.570   5.275  20.080  1.00 23.49           C
ATOM   2879  O   VAL    17      15.501   5.252  18.868  1.00 22.25           O
ATOM   2880  N   ASP    18      14.517   5.481  20.852  1.00 24.27           N
ATOM   2881  CA  ASP    18      13.211   5.931  20.346  1.00 25.53           C
ATOM   2882  CB  ASP    18      12.220   6.025  21.518  1.00 25.38           C
ATOM   2883  CG  ASP    18      10.784   6.036  21.049  1.00 30.07           C
ATOM   2884  OD1 ASP    18      10.338   7.042  20.475  1.00 33.75           O
ATOM   2885  OD2 ASP    18      10.100   5.020  21.203  1.00 34.10           O
ATOM   2886  C   ASP    18      13.331   7.291  19.625  1.00 25.29           C
ATOM   2887  O   ASP    18      14.045   8.169  20.089  1.00 25.15           O
ATOM   2888  N   GLY    19      12.644   7.449  18.495  1.00 25.13           N
ATOM   2889  CA  GLY    19      12.716   8.689  17.746  1.00 25.20           C
ATOM   2890  C   GLY    19      12.132   9.872  18.518  1.00 25.29           C
ATOM   2891  O   GLY    19      12.496  11.013  18.279  1.00 23.94           O
ATOM   2892  N   MET    20      11.239   9.572  19.461  1.00 25.99           N
ATOM   2893  CA  MET    20      10.575  10.585  20.276  1.00 27.12           C
ATOM   2894  CB  MET    20       9.292  10.037  20.894  1.00 27.98           C
ATOM   2895  CG  MET    20       8.141   9.876  19.920  1.00 32.02           C
ATOM   2896  SD  MET    20       7.736  11.478  18.923  0.60 36.37          SE
ATOM   2897  CE  MET    20       6.931  12.599  20.315  1.00 39.28           C
ATOM   2898  C   MET    20      11.442  11.238  21.362  1.00 27.21           C
ATOM   2899  O   MET    20      11.012  12.233  21.967  1.00 27.49           O
ATOM   2900  N   VAL    21      12.652  10.723  21.598  1.00 27.09           N
ATOM   2901  CA  VAL    21      13.514  11.286  22.652  1.00 27.06           C
ATOM   2902  CB  VAL    21      14.829  10.499  22.878  1.00 27.48           C
ATOM   2903  CG1 VAL    21      15.780  10.692  21.737  1.00 27.03           C
ATOM   2904  CG2 VAL    21      15.508  10.979  24.154  1.00 28.75           C
ATOM   2905  C   VAL    21      13.846  12.740  22.351  1.00 26.79           C
ATOM   2906  O   VAL    21      14.234  13.073  21.233  1.00 26.08           O
ATOM   2907  N   SER    22      13.688  13.594  23.356  1.00 26.82           N
ATOM   2908  CA  SER    22      13.984  15.007  23.189  1.00 27.80           C
ATOM   2909  CB  SER    22      13.540  15.789  24.407  1.00 27.35           C
ATOM   2910  OG  SER    22      14.390  15.472  25.479  1.00 29.88           O
ATOM   2911  C   SER    22      15.479  15.196  22.992  1.00 27.84           C
ATOM   2912  O   SER    22      16.279  14.377  23.449  1.00 27.14           O
ATOM   2913  N   LEU    23      15.851  16.286  22.332  1.00 28.24           N
ATOM   2914  CA  LEU    23      17.268  16.573  22.107  1.00 29.40           C
ATOM   2915  CB  LEU    23      17.466  17.545  20.951  1.00 29.04           C
ATOM   2916  CG  LEU    23      17.086  16.977  19.591  1.00 28.73           C
ATOM   2917  CD1 LEU    23      17.426  18.002  18.529  1.00 28.66           C
ATOM   2918  CD2 LEU    23      17.789  15.642  19.320  1.00 30.50           C
ATOM   2919  C   LEU    23      18.024  17.021  23.357  1.00 30.69           C
ATOM   2920  O   LEU    23      19.215  16.743  23.485  1.00 30.17           O
ATOM   2921  N   ASP    24      17.330  17.690  24.282  1.00 31.59           N
ATOM   2922  CA  ASP    24      17.944  18.077  25.550  1.00 33.24           C
ATOM   2923  CB  ASP    24      16.990  18.903  26.425  1.00 33.19           C
ATOM   2924  CG  ASP    24      16.834  20.316  25.925  1.00 35.10           C
ATOM   2925  OD1 ASP    24      17.654  20.756  25.073  1.00 36.48           O
ATOM   2926  OD2 ASP    24      15.879  20.992  26.367  1.00 38.09           O
ATOM   2927  C   ASP    24      18.422  16.859  26.307  1.00 33.76           C
ATOM   2928  O   ASP    24      19.576  16.806  26.725  1.00 33.74           O
ATOM   2929  N   ARG    25      17.523  15.892  26.475  1.00 34.41           N
ATOM   2930  CA  ARG    25      17.825  14.663  27.158  1.00 36.04           C
ATOM   2931  CB  ARG    25      16.574  13.799  27.236  1.00 36.64           C
ATOM   2932  CG  ARG    25      16.550  12.889  28.431  1.00 40.74           C
ATOM   2933  CD  ARG    25      15.234  12.136  28.552  1.00 45.96           C
ATOM   2934  NE  ARG    25      14.211  12.850  29.323  1.00 49.06           N
ATOM   2935  CZ  ARG    25      13.208  12.248  29.971  1.00 50.76           C
ATOM   2936  NH1 ARG    25      13.095  10.915  29.944  1.00 51.13           N
ATOM   2937  NH2 ARG    25      12.315  12.972  30.650  1.00 49.48           N
ATOM   2938  C   ARG    25      18.981  13.918  26.453  1.00 36.21           C
ATOM   2939  O   ARG    25      19.966  13.560  27.098  1.00 36.37           O
ATOM   2940  N   PHE    26      18.874  13.754  25.133  1.00 36.07           N
ATOM   2941  CA  PHE    26      19.906  13.101  24.311  1.00 36.11           C
ATOM   2942  CB  PHE    26      19.485  13.109  22.832  1.00 34.64           C
ATOM   2943  CG  PHE    26      20.445  12.388  21.914  1.00 34.27           C
ATOM   2944  CD1 PHE    26      20.142  11.101  21.452  1.00 33.33           C
ATOM   2945  CE1 PHE    26      21.021  10.409  20.610  1.00 30.48           C
ATOM   2946  CZ  PHE    26      22.228  11.010  20.214  1.00 33.22           C
ATOM   2947  CE2 PHE    26      22.548  12.300  20.680  1.00 32.25           C
ATOM   2948  CD2 PHE    26      21.651  12.980  21.514  1.00 31.77           C
ATOM   2949  C   PHE    26      21.294  13.756  24.445  1.00 36.77           C
ATOM   2950  O   PHE    26      22.317  13.087  24.687  1.00 35.79           O
ATOM   2951  N   ARG    27      21.306  15.065  24.221  1.00 37.70           N
ATOM   2952  CA  ARG    27      22.523  15.868  24.105  1.00 38.70           C
ATOM   2953  CB  ARG    27      22.135  17.244  23.571  1.00 39.13           C
ATOM   2954  CG  ARG    27      22.985  18.401  23.964  1.00 41.66           C
ATOM   2955  CD  ARG    27      22.459  19.626  23.236  1.00 47.36           C
ATOM   2956  NE  ARG    27      23.565  20.477  22.814  1.00 49.90           N
ATOM   2957  CZ  ARG    27      24.260  20.287  21.697  1.00 50.12           C
ATOM   2958  NH1 ARG    27      23.952  19.274  20.881  1.00 48.16           N
ATOM   2959  NH2 ARG    27      25.262  21.115  21.408  1.00 49.32           N
ATOM   2960  C   ARG    27      23.205  15.945  25.455  1.00 38.63           C
ATOM   2961  O   ARG    27      24.445  15.916  25.565  1.00 38.85           O
ATOM   2962  N   GLU    28      22.373  16.007  26.487  1.00 38.69           N
ATOM   2963  CA  GLU    28      22.849  15.953  27.856  1.00 38.86           C
ATOM   2964  CB  GLU    28      21.696  16.201  28.828  1.00 39.15           C
ATOM   2965  CG  GLU    28      22.115  16.745  30.185  1.00 41.74           C
ATOM   2966  CD  GLU    28      21.067  16.515  31.262  1.00 44.34           C
ATOM   2967  OE1 GLU    28      20.447  15.418  31.277  1.00 45.33           O
ATOM   2968  OE2 GLU    28      20.875  17.429  32.096  1.00 45.05           O
ATOM   2969  C   GLU    28      23.487  14.590  28.091  1.00 38.06           C
ATOM   2970  O   GLU    28      24.654  14.510  28.488  1.00 38.12           O
ATOM   2971  N   PHE    29      22.739  13.524  27.818  1.00 37.39           N
ATOM   2972  CA  PHE    29      23.245  12.170  28.088  1.00 37.42           C
ATOM   2973  CB  PHE    29      22.195  11.072  27.856  1.00 37.21           C
ATOM   2974  CG  PHE    29      22.728   9.705  28.134  1.00 37.01           C
ATOM   2975  CD1 PHE    29      22.821   9.241  29.452  1.00 37.80           C
ATOM   2976  CE1 PHE    29      23.359   7.982  29.746  1.00 37.16           C
ATOM   2977  CZ  PHE    29      23.827   7.182  28.710  1.00 38.10           C
ATOM   2978  CE2 PHE    29      23.752   7.655  27.373  1.00 36.27           C
ATOM   2979  CD2 PHE    29      23.217   8.914  27.104  1.00 36.23           C
ATOM   2980  C   PHE    29      24.564  11.810  27.358  1.00 37.36           C
ATOM   2981  O   PHE    29      25.544  11.421  28.011  1.00 37.18           O
ATOM   2982  N   PHE    30      24.587  11.956  26.030  1.00 36.69           N
ATOM   2983  CA  PHE    30      25.761  11.599  25.221  1.00 36.82           C
ATOM   2984  CB  PHE    30      25.323  11.298  23.773  1.00 36.26           C
ATOM   2985  CG  PHE    30      24.579   9.990  23.622  1.00 35.16           C
ATOM   2986  CD1 PHE    30      25.263   8.774  23.623  1.00 35.11           C
ATOM   2987  CE1 PHE    30      24.578   7.560  23.485  1.00 33.96           C
ATOM   2988  CZ  PHE    30      23.209   7.555  23.350  1.00 34.74           C
ATOM   2989  CE2 PHE    30      22.513   8.766  23.352  1.00 34.58           C
ATOM   2990  CD2 PHE    30      23.203   9.971  23.487  1.00 33.45           C
ATOM   2991  C   PHE    30      26.941  12.604  25.249  1.00 37.05           C
ATOM   2992  O   PHE    30      27.885  12.489  24.457  1.00 37.33           O
ATOM   2993  N   GLU    31      26.877  13.578  26.160  1.00 37.25           N
ATOM   2994  CA  GLU    31      27.899  14.636  26.324  1.00 37.31           C
ATOM   2995  CB  GLU    31      29.204  14.081  26.933  1.00 37.45           C
ATOM   2996  CG  GLU    31      29.062  13.111  28.091  1.00 36.93           C
ATOM   2997  CD  GLU    31      30.397  12.500  28.461  1.00 37.14           C
ATOM   2998  OE1 GLU    31      30.622  11.304  28.164  1.00 36.13           O
ATOM   2999  OE2 GLU    31      31.238  13.231  29.024  1.00 37.22           O
ATOM   3000  C   GLU    31      28.230  15.426  25.037  1.00 37.54           C
ATOM   3001  O   GLU    31      29.388  15.807  24.814  1.00 37.60           O
ATOM   3002  N   LEU    32      27.219  15.681  24.201  1.00 37.51           N
ATOM   3003  CA  LEU    32      27.418  16.411  22.949  1.00 37.13           C
ATOM   3004  CB  LEU    32      26.226  16.220  22.015  1.00 37.11           C
ATOM   3005  CG  LEU    32      25.674  14.814  21.761  1.00 37.73           C
ATOM   3006  CD1 LEU    32      24.558  14.876  20.741  1.00 40.19           C
ATOM   3007  CD2 LEU    32      26.733  13.886  21.266  1.00 38.68           C
ATOM   3008  C   LEU    32      27.642  17.904  23.214  1.00 37.22           C
ATOM   3009  O   LEU    32      26.792  18.584  23.819  1.00 37.14           O
ATOM   3010  N   GLU    33      28.795  18.411  22.779  1.00 36.63           N
ATOM   3011  CA  GLU    33      29.058  19.850  22.865  1.00 36.09           C
ATOM   3012  CB  GLU    33      30.478  20.124  23.385  1.00 36.71           C
ATOM   3013  CG  GLU    33      30.778  19.467  24.730  1.00 37.38           C
ATOM   3014  CD  GLU    33      31.792  20.231  25.545  1.00 39.66           C
ATOM   3015  OE1 GLU    33      32.286  21.285  25.077  1.00 40.90           O
ATOM   3016  OE2 GLU    33      32.097  19.777  26.668  1.00 40.62           O
ATOM   3017  C   GLU    33      28.798  20.578  21.534  1.00 35.34           C
ATOM   3018  O   GLU    33      29.151  21.764  21.395  1.00 35.36           O
ATOM   3019  N   ALA    34      28.169  19.872  20.581  1.00 33.67           N
ATOM   3020  CA  ALA    34      27.847  20.429  19.264  1.00 32.25           C
ATOM   3021  CB  ALA    34      28.823  19.909  18.217  1.00 32.08           C
ATOM   3022  C   ALA    34      26.405  20.105  18.865  1.00 31.51           C
ATOM   3023  O   ALA    34      25.946  18.986  19.097  1.00 31.56           O
ATOM   3024  N   PRO    35      25.671  21.086  18.286  1.00 30.60           N
ATOM   3025  CA  PRO    35      24.306  20.826  17.826  1.00 30.05           C
ATOM   3026  CB  PRO    35      23.916  22.135  17.119  1.00 29.60           C
ATOM   3027  CG  PRO    35      24.736  23.161  17.781  1.00 30.92           C
ATOM   3028  CD  PRO    35      26.059  22.489  18.047  1.00 31.02           C
ATOM   3029  C   PRO    35      24.204  19.656  16.843  1.00 28.84           C
ATOM   3030  O   PRO    35      25.087  19.436  16.032  1.00 28.26           O
ATOM   3031  N   LEU    36      23.107  18.928  16.909  1.00 28.59           N
ATOM   3032  CA  LEU    36      22.824  17.895  15.912  1.00 28.20           C
ATOM   3033  CB  LEU    36      21.748  16.930  16.441  1.00 28.25           C
ATOM   3034  CG  LEU    36      22.243  15.881  17.467  1.00 29.50           C
ATOM   3035  CD1 LEU    36      23.093  16.562  18.495  1.00 31.71           C
ATOM   3036  CD2 LEU    36      21.100  15.190  18.180  1.00 29.20           C
ATOM   3037  C   LEU    36      22.425  18.560  14.574  1.00 27.08           C
ATOM   3038  O   LEU    36      22.059  19.741  14.551  1.00 26.06           O
ATOM   3039  N   PRO    37      22.525  17.820  13.461  1.00 26.39           N
ATOM   3040  CA  PRO    37      22.073  18.380  12.184  1.00 25.69           C
ATOM   3041  CB  PRO    37      22.022  17.151  11.279  1.00 25.92           C
ATOM   3042  CG  PRO    37      23.172  16.284  11.811  1.00 26.50           C
ATOM   3043  CD  PRO    37      23.024  16.436  13.310  1.00 26.93           C
ATOM   3044  C   PRO    37      20.684  19.027  12.302  1.00 24.76           C
ATOM   3045  O   PRO    37      19.731  18.385  12.770  1.00 22.77           O
ATOM   3046  N   GLY    38      20.601  20.305  11.931  1.00 24.31           N
ATOM   3047  CA  GLY    38      19.335  21.070  11.967  1.00 25.79           C
ATOM   3048  C   GLY    38      18.953  21.689  13.319  1.00 26.35           C
ATOM   3049  O   GLY    38      18.110  22.585  13.377  1.00 27.32           O
ATOM   3050  N   GLU    39      19.561  21.226  14.404  1.00 26.26           N
ATOM   3051  CA  GLU    39      19.180  21.665  15.755  1.00 26.22           C
ATOM   3052  CB  GLU    39      19.832  20.753  16.813  1.00 26.36           C
ATOM   3053  CG  GLU    39      19.573  21.110  18.324  1.00 26.79           C
ATOM   3054  CD  GLU    39      20.402  20.260  19.282  1.00 26.32           C
ATOM   3055  OE1 GLU    39      21.282  19.526  18.792  1.00 26.92           O
ATOM   3056  OE2 GLU    39      20.180  20.314  20.519  1.00 29.41           O
ATOM   3057  C   GLU    39      19.476  23.150  16.020  1.00 26.85           C
ATOM   3058  O   GLU    39      18.789  23.782  16.834  1.00 27.20           O
ATOM   3059  N   ALA    40      20.482  23.712  15.337  1.00 26.46           N
ATOM   3060  CA  ALA    40      20.860  25.118  15.533  1.00 26.45           C
ATOM   3061  CB  ALA    40      22.147  25.450  14.761  1.00 26.81           C
ATOM   3062  C   ALA    40      19.745  26.107  15.167  1.00 25.85           C
ATOM   3063  O   ALA    40      19.634  27.185  15.767  1.00 26.11           O
ATOM   3064  N   GLY    41      18.918  25.738  14.194  1.00 24.86           N
ATOM   3065  CA  GLY    41      17.776  26.563  13.811  1.00 23.81           C
ATOM   3066  C   GLY    41      16.756  26.809  14.922  1.00 22.53           C
ATOM   3067  O   GLY    41      15.982  27.760  14.852  1.00 22.38           O
ATOM   3068  N   GLY    42      16.736  25.935  15.929  1.00 21.89           N
ATOM   3069  CA  GLY    42      15.871  26.108  17.106  1.00 21.66           C
ATOM   3070  C   GLY    42      14.483  25.496  16.960  1.00 21.48           C
ATOM   3071  O   GLY    42      13.628  25.636  17.842  1.00 21.09           O
ATOM   3072  N   ASN    43      14.258  24.802  15.858  1.00 20.65           N
ATOM   3073  CA  ASN    43      12.935  24.263  15.584  1.00 22.12           C
ATOM   3074  CB  ASN    43      12.434  24.802  14.254  1.00 21.56           C
ATOM   3075  CG  ASN    43      13.290  24.360  13.085  1.00 22.65           C
ATOM   3076  OD1 ASN    43      14.533  24.284  13.172  1.00 22.37           O
ATOM   3077  ND2 ASN    43      12.628  24.060  11.974  1.00 23.88           N
ATOM   3078  C   ASN    43      12.826  22.729  15.594  1.00 22.26           C
ATOM   3079  O   ASN    43      11.788  22.186  15.245  1.00 22.09           O
ATOM   3080  N   ILE    44      13.898  22.051  15.993  1.00 23.03           N
ATOM   3081  CA  ILE    44      13.942  20.594  15.992  1.00 24.21           C
ATOM   3082  CB  ILE    44      15.021  20.036  14.990  1.00 23.64           C
ATOM   3083  CG1 ILE    44      14.720  20.477  13.549  1.00 24.60           C
ATOM   3084  CD1 ILE    44      15.698  19.957  12.515  1.00 25.20           C
ATOM   3085  CG2 ILE    44      15.119  18.514  15.117  1.00 25.75           C
ATOM   3086  C   ILE    44      14.274  20.109  17.390  1.00 24.33           C
ATOM   3087  O   ILE    44      15.362  20.400  17.917  1.00 24.81           O
ATOM   3088  N   HIS    45      13.364  19.336  17.976  1.00 24.14           N
ATOM   3089  CA  HIS    45      13.483  18.968  19.372  1.00 24.29           C
ATOM   3090  CB  HIS    45      12.437  19.725  20.187  1.00 24.56           C
ATOM   3091  CG  HIS    45      12.365  21.180  19.854  1.00 23.61           C
ATOM   3092  ND1 HIS    45      13.396  22.052  20.128  1.00 25.03           N
ATOM   3093  CE1 HIS    45      13.069  23.266  19.709  1.00 25.95           C
ATOM   3094  NE2 HIS    45      11.867  23.209  19.165  1.00 25.21           N
ATOM   3095  CD2 HIS    45      11.408  21.911  19.236  1.00 25.32           C
ATOM   3096  C   HIS    45      13.379  17.479  19.673  1.00 24.51           C
ATOM   3097  O   HIS    45      13.313  17.103  20.833  1.00 24.81           O
ATOM   3098  N   THR    46      13.349  16.643  18.641  1.00 24.57           N
ATOM   3099  CA  THR    46      13.438  15.191  18.814  1.00 24.36           C
ATOM   3100  CB  THR    46      12.111  14.448  18.550  1.00 24.78           C
ATOM   3101  OG1 THR    46      11.744  14.598  17.171  1.00 23.28           O
ATOM   3102  CG2 THR    46      10.965  14.975  19.486  1.00 24.18           C
ATOM   3103  C   THR    46      14.471  14.607  17.885  1.00 24.57           C
ATOM   3104  O   THR    46      14.813  15.218  16.875  1.00 23.88           O
ATOM   3105  N   LEU    47      14.946  13.403  18.229  1.00 24.06           N
ATOM   3106  CA  LEU    47      15.903  12.700  17.405  1.00 24.78           C
ATOM   3107  CB  LEU    47      16.468  11.471  18.148  1.00 25.16           C
ATOM   3108  CG  LEU    47      17.510  10.594  17.427  1.00 26.82           C
ATOM   3109  CD1 LEU    47      18.817  11.340  17.143  1.00 25.56           C
ATOM   3110  CD2 LEU    47      17.770   9.324  18.264  1.00 26.00           C
ATOM   3111  C   LEU    47      15.334  12.279  16.057  1.00 24.11           C
ATOM   3112  O   LEU    47      16.083  12.271  15.044  1.00 22.93           O
ATOM   3113  N   ALA    48      14.052  11.878  16.032  1.00 22.87           N
ATOM   3114  CA  ALA    48      13.373  11.632  14.726  1.00 23.61           C
ATOM   3115  CB  ALA    48      11.892  11.205  14.912  1.00 23.25           C
ATOM   3116  C   ALA    48      13.455  12.899  13.854  1.00 23.56           C
ATOM   3117  O   ALA    48      13.766  12.833  12.664  1.00 23.95           O
ATOM   3118  N   GLY    49      13.158  14.060  14.452  1.00 24.06           N
ATOM   3119  CA  GLY    49      13.275  15.340  13.717  1.00 24.08           C
ATOM   3120  C   GLY    49      14.657  15.529  13.098  1.00 24.07           C
ATOM   3121  O   GLY    49      14.792  16.058  11.981  1.00 24.49           O
ATOM   3122  N   VAL    50      15.702  15.128  13.823  1.00 23.41           N
ATOM   3123  CA  VAL    50      17.057  15.171  13.264  1.00 22.23           C
ATOM   3124  CB  VAL    50      18.152  14.934  14.344  1.00 23.46           C
ATOM   3125  CG1 VAL    50      19.564  15.008  13.715  1.00 21.14           C
ATOM   3126  CG2 VAL    50      18.019  15.930  15.482  1.00 22.33           C
ATOM   3127  C   VAL    50      17.216  14.210  12.095  1.00 22.84           C
ATOM   3128  O   VAL    50      17.847  14.551  11.069  1.00 24.39           O
ATOM   3129  N   MET    51      16.651  13.012  12.222  1.00 22.72           N
ATOM   3130  CA  MET    51      16.758  12.009  11.164  1.00 22.53           C
ATOM   3131  CB  MET    51      16.178  10.644  11.594  1.00 22.57           C
ATOM   3132  CG  MET    51      16.756  10.007  12.853  1.00 23.07           C
ATOM   3133  SD  MET    51      18.689   9.799  12.854  0.60 25.91          SE
ATOM   3134  CE  MET    51      19.128  11.427  13.708  1.00 34.37           C
ATOM   3135  C   MET    51      16.065  12.502   9.902  1.00 22.32           C
ATOM   3136  O   MET    51      16.589  12.333   8.809  1.00 22.24           O
ATOM   3137  N   LEU    52      14.886  13.106  10.058  1.00 22.07           N
ATOM   3138  CA  LEU    52      14.157  13.672   8.910  1.00 22.52           C
ATOM   3139  CB  LEU    52      12.703  14.032   9.289  1.00 22.62           C
ATOM   3140  CG  LEU    52      11.761  12.948   9.876  1.00 25.01           C
ATOM   3141  CD1 LEU    52      10.482  13.572  10.478  1.00 25.90           C
ATOM   3142  CD2 LEU    52      11.377  11.875   8.859  1.00 28.33           C
ATOM   3143  C   LEU    52      14.892  14.877   8.232  1.00 22.76           C
ATOM   3144  O   LEU    52      14.910  14.997   6.991  1.00 22.20           O
ATOM   3145  N   TYR    53      15.464  15.774   9.035  1.00 22.64           N
ATOM   3146  CA  TYR    53      16.306  16.855   8.489  1.00 22.84           C
ATOM   3147  CB  TYR    53      16.926  17.691   9.609  1.00 22.65           C
ATOM   3148  CG  TYR    53      17.783  18.854   9.119  1.00 22.30           C
ATOM   3149  CD1 TYR    53      17.208  20.056   8.728  1.00 21.91           C
ATOM   3150  CE1 TYR    53      18.018  21.144   8.304  1.00 23.96           C
ATOM   3151  CZ  TYR    53      19.390  20.990   8.288  1.00 23.27           C
ATOM   3152  OH  TYR    53      20.212  22.016   7.898  1.00 29.26           O
ATOM   3153  CE2 TYR    53      19.972  19.818   8.688  1.00 24.55           C
ATOM   3154  CD2 TYR    53      19.175  18.757   9.102  1.00 21.23           C
ATOM   3155  C   TYR    53      17.439  16.290   7.650  1.00 23.16           C
ATOM   3156  O   TYR    53      17.652  16.720   6.499  1.00 21.90           O
ATOM   3157  N   GLN    54      18.173  15.330   8.239  1.00 23.69           N
ATOM   3158  CA  GLN    54      19.369  14.791   7.595  1.00 24.43           C
ATOM   3159  CB  GLN    54      20.265  14.059   8.606  1.00 23.64           C
ATOM   3160  CG  GLN    54      21.653  13.659   8.049  1.00 25.10           C
ATOM   3161  CD  GLN    54      22.520  14.849   7.615  1.00 27.40           C
ATOM   3162  OE1 GLN    54      22.330  15.970   8.071  1.00 25.62           O
ATOM   3163  NE2 GLN    54      23.479  14.591   6.724  1.00 26.29           N
ATOM   3164  C   GLN    54      19.083  13.911   6.370  1.00 24.02           C
ATOM   3165  O   GLN    54      19.772  14.013   5.348  1.00 23.57           O
ATOM   3166  N   LEU    55      18.048  13.076   6.476  1.00 24.10           N
ATOM   3167  CA  LEU    55      17.819  11.992   5.503  1.00 23.38           C
ATOM   3168  CB  LEU    55      17.709  10.658   6.229  1.00 22.72           C
ATOM   3169  CG  LEU    55      18.934  10.236   7.043  1.00 23.27           C
ATOM   3170  CD1 LEU    55      18.560   9.042   7.930  1.00 26.13           C
ATOM   3171  CD2 LEU    55      20.087   9.865   6.115  1.00 23.13           C
ATOM   3172  C   LEU    55      16.601  12.168   4.622  1.00 23.71           C
ATOM   3173  O   LEU    55      16.391  11.381   3.693  1.00 23.34           O
ATOM   3174  N   GLY    56      15.795  13.195   4.898  1.00 23.46           N
ATOM   3175  CA  GLY    56      14.574  13.405   4.114  1.00 23.77           C
ATOM   3176  C   GLY    56      13.306  12.974   4.836  1.00 24.82           C
ATOM   3177  O   GLY    56      13.346  12.329   5.897  1.00 23.40           O
ATOM   3178  N   ARG    57      12.189  13.338   4.229  1.00 25.62           N
ATOM   3179  CA  ARG    57      10.868  13.139   4.791  1.00 27.20           C
ATOM   3180  CB  ARG    57       9.802  13.778   3.915  1.00 27.30           C
ATOM   3181  CG  ARG    57       9.488  15.184   4.296  1.00 30.11           C
ATOM   3182  CD  ARG    57       9.265  15.293   5.802  1.00 32.60           C
ATOM   3183  NE  ARG    57      10.365  16.054   6.379  1.00 34.52           N
ATOM   3184  CZ  ARG    57      10.352  16.585   7.598  1.00 36.49           C
ATOM   3185  NH1 ARG    57       9.266  16.432   8.378  1.00 35.61           N
ATOM   3186  NH2 ARG    57      11.418  17.279   8.026  1.00 32.29           N
ATOM   3187  C   ARG    57      10.524  11.693   4.997  1.00 27.71           C
ATOM   3188  O   ARG    57       9.907  11.344   6.000  1.00 28.37           O
ATOM   3189  N   VAL    58      10.913  10.831   4.076  1.00 28.82           N
ATOM   3190  CA  VAL    58      10.698   9.421   4.375  1.00 30.30           C
ATOM   3191  CB  VAL    58       9.391   8.875   3.734  1.00 31.00           C
ATOM   3192  CG1 VAL    58       9.301   9.257   2.254  1.00 32.46           C
ATOM   3193  CG2 VAL    58       9.162   7.362   4.058  1.00 32.12           C
ATOM   3194  C   VAL    58      11.963   8.603   4.217  1.00 29.49           C
ATOM   3195  O   VAL    58      12.288   8.106   3.134  1.00 29.21           O
ATOM   3196  N   PRO    59      12.706   8.502   5.332  1.00 29.32           N
ATOM   3197  CA  PRO    59      13.923   7.726   5.423  1.00 28.99           C
ATOM   3198  CB  PRO    59      14.385   7.979   6.864  1.00 28.49           C
ATOM   3199  CG  PRO    59      13.752   9.195   7.266  1.00 28.03           C
ATOM   3200  CD  PRO    59      12.406   9.149   6.618  1.00 28.87           C
ATOM   3201  C   PRO    59      13.571   6.252   5.220  1.00 28.78           C
ATOM   3202  O   PRO    59      12.393   5.887   5.274  1.00 28.94           O
ATOM   3203  N   SER    60      14.573   5.428   4.941  1.00 28.19           N
ATOM   3204  CA  SER    60      14.367   3.985   4.841  1.00 27.71           C
ATOM   3205  CB  SER    60      14.813   3.460   3.475  1.00 28.51           C
ATOM   3206  OG  SER    60      14.236   4.207   2.416  1.00 33.38           O
ATOM   3207  C   SER    60      15.192   3.332   5.919  1.00 26.79           C
ATOM   3208  O   SER    60      16.236   3.851   6.315  1.00 24.76           O
ATOM   3209  N   VAL    61      14.717   2.193   6.412  1.00 26.18           N
ATOM   3210  CA  VAL    61      15.494   1.411   7.363  1.00 26.59           C
ATOM   3211  CB  VAL    61      14.729   0.100   7.748  1.00 26.58           C
ATOM   3212  CG1 VAL    61      15.617  -0.840   8.486  1.00 28.16           C
ATOM   3213  CG2 VAL    61      13.538   0.434   8.611  1.00 27.14           C
ATOM   3214  C   VAL    61      16.868   1.129   6.710  1.00 25.66           C
ATOM   3215  O   VAL    61      16.959   0.943   5.474  1.00 23.81           O
ATOM   3216  N   THR    62      17.898   1.098   7.562  1.00 25.57           N
ATOM   3217  CA  THR    62      19.346   1.071   7.214  1.00 25.96           C
ATOM   3218  CB  THR    62      19.739  -0.046   6.194  1.00 25.44           C
ATOM   3219  OG1 THR    62      19.371   0.364   4.879  1.00 28.27           O
ATOM   3220  CG2 THR    62      19.045  -1.377   6.507  1.00 25.09           C
ATOM   3221  C   THR    62      19.926   2.438   6.780  1.00 26.72           C
ATOM   3222  O   THR    62      21.154   2.613   6.780  1.00 26.33           O
ATOM   3223  N   ASP    63      19.082   3.410   6.430  1.00 26.72           N
ATOM   3224  CA  ASP    63      19.614   4.765   6.158  1.00 28.01           C
ATOM   3225  CB  ASP    63      18.499   5.767   5.936  1.00 28.39           C
ATOM   3226  CG  ASP    63      17.925   5.720   4.522  1.00 29.10           C
ATOM   3227  OD1 ASP    63      18.269   4.818   3.740  1.00 32.34           O
ATOM   3228  OD2 ASP    63      17.110   6.594   4.205  1.00 30.28           O
ATOM   3229  C   ASP    63      20.457   5.212   7.365  1.00 28.78           C
ATOM   3230  O   ASP    63      20.066   4.978   8.525  1.00 28.25           O
ATOM   3231  N   ARG    64      21.607   5.823   7.092  1.00 29.02           N
ATOM   3232  CA  ARG    64      22.656   5.991   8.102  1.00 30.26           C
ATOM   3233  CB  ARG    64      23.507   4.712   8.162  1.00 30.33           C
ATOM   3234  CG  ARG    64      24.604   4.658   9.233  1.00 33.52           C
ATOM   3235  CD  ARG    64      25.429   3.376   9.076  1.00 32.76           C
ATOM   3236  NE  ARG    64      26.257   3.095  10.263  1.00 39.38           N
ATOM   3237  CZ  ARG    64      27.517   3.509  10.425  1.00 40.09           C
ATOM   3238  NH1 ARG    64      28.106   4.247   9.491  1.00 42.36           N
ATOM   3239  NH2 ARG    64      28.187   3.199  11.527  1.00 40.57           N
ATOM   3240  C   ARG    64      23.529   7.200   7.768  1.00 30.13           C
ATOM   3241  O   ARG    64      23.708   7.529   6.603  1.00 29.84           O
ATOM   3242  N   PHE    65      24.036   7.872   8.803  1.00 29.42           N
ATOM   3243  CA  PHE    65      25.037   8.905   8.646  1.00 28.76           C
ATOM   3244  CB  PHE    65      24.396  10.274   8.350  1.00 28.08           C
ATOM   3245  CG  PHE    65      23.530  10.811   9.477  1.00 28.17           C
ATOM   3246  CD1 PHE    65      22.185  10.459   9.578  1.00 26.70           C
ATOM   3247  CE1 PHE    65      21.369  10.998  10.583  1.00 28.95           C
ATOM   3248  CZ  PHE    65      21.890  11.878  11.518  1.00 27.44           C
ATOM   3249  CE2 PHE    65      23.237  12.245  11.434  1.00 28.87           C
ATOM   3250  CD2 PHE    65      24.048  11.716  10.403  1.00 28.74           C
ATOM   3251  C   PHE    65      25.883   8.947   9.905  1.00 28.66           C
ATOM   3252  O   PHE    65      25.483   8.437  10.970  1.00 27.20           O
ATOM   3253  N   GLU    66      27.073   9.510   9.755  1.00 29.20           N
ATOM   3254  CA  GLU    66      27.971   9.722  10.879  1.00 31.24           C
ATOM   3255  CB  GLU    66      29.361   9.019  10.685  1.00 31.12           C
ATOM   3256  CG  GLU    66      29.283   7.428  10.694  1.00 33.90           C
ATOM   3257  CD  GLU    66      30.533   6.666  11.292  1.00 33.48           C
ATOM   3258  OE1 GLU    66      31.522   7.306  11.700  1.00 36.71           O
ATOM   3259  OE2 GLU    66      30.522   5.404  11.362  1.00 37.95           O
ATOM   3260  C   GLU    66      28.031  11.247  11.144  1.00 30.40           C
ATOM   3261  O   GLU    66      27.944  12.082  10.220  1.00 30.52           O
ATOM   3262  N   TRP    67      28.082  11.632  12.411  1.00 29.65           N
ATOM   3263  CA  TRP    67      28.113  13.073  12.715  1.00 29.18           C
ATOM   3264  CB  TRP    67      26.666  13.658  12.870  1.00 30.13           C
ATOM   3265  CG  TRP    67      26.644  15.002  13.511  1.00 31.06           C
ATOM   3266  CD1 TRP    67      26.724  16.215  12.894  1.00 32.45           C
ATOM   3267  NE1 TRP    67      26.716  17.231  13.836  1.00 32.58           N
ATOM   3268  CE2 TRP    67      26.625  16.671  15.085  1.00 33.12           C
ATOM   3269  CD2 TRP    67      26.576  15.266  14.917  1.00 32.54           C
ATOM   3270  CE3 TRP    67      26.475  14.446  16.056  1.00 33.26           C
ATOM   3271  CZ3 TRP    67      26.439  15.048  17.325  1.00 34.12           C
ATOM   3272  CH2 TRP    67      26.510  16.462  17.464  1.00 31.85           C
ATOM   3273  CZ2 TRP    67      26.603  17.280  16.358  1.00 33.81           C
ATOM   3274  C   TRP    67      28.947  13.257  13.968  1.00 28.11           C
ATOM   3275  O   TRP    67      28.627  12.683  14.994  1.00 27.21           O
ATOM   3276  N   ASN    68      30.035  14.014  13.893  1.00 28.17           N
ATOM   3277  CA  ASN    68      30.758  14.338  15.124  1.00 29.31           C
ATOM   3278  CB  ASN    68      29.860  15.266  15.977  1.00 29.79           C
ATOM   3279  CG  ASN    68      30.581  15.862  17.170  1.00 34.24           C
ATOM   3280  OD1 ASN    68      31.787  16.161  17.102  1.00 37.99           O
ATOM   3281  ND2 ASN    68      29.843  16.053  18.283  1.00 37.21           N
ATOM   3282  C   ASN    68      31.151  13.104  15.960  1.00 28.56           C
ATOM   3283  O   ASN    68      31.075  13.150  17.187  1.00 28.28           O
ATOM   3284  N   GLY    69      31.521  11.992  15.311  1.00 28.80           N
ATOM   3285  CA  GLY    69      32.017  10.813  16.047  1.00 28.30           C
ATOM   3286  C   GLY    69      30.951   9.810  16.462  1.00 28.34           C
ATOM   3287  O   GLY    69      31.246   8.843  17.171  1.00 28.43           O
ATOM   3288  N   PHE    70      29.720  10.063  16.027  1.00 28.27           N
ATOM   3289  CA  PHE    70      28.544   9.191  16.231  1.00 28.62           C
ATOM   3290  CB  PHE    70      27.425   9.981  16.931  1.00 27.71           C
ATOM   3291  CG  PHE    70      27.690  10.237  18.350  1.00 27.63           C
ATOM   3292  CD1 PHE    70      27.179   9.376  19.325  1.00 28.94           C
ATOM   3293  CE1 PHE    70      27.449   9.592  20.679  1.00 29.95           C
ATOM   3294  CZ  PHE    70      28.214  10.702  21.069  1.00 28.36           C
ATOM   3295  CE2 PHE    70      28.727  11.575  20.098  1.00 28.03           C
ATOM   3296  CD2 PHE    70      28.456  11.339  18.742  1.00 28.51           C
ATOM   3297  C   PHE    70      27.979   8.652  14.912  1.00 28.79           C
ATOM   3298  O   PHE    70      28.087   9.287  13.868  1.00 29.91           O
ATOM   3299  N   SER    71      27.377   7.472  14.953  1.00 28.72           N
ATOM   3300  CA  SER    71      26.596   7.015  13.830  1.00 27.85           C
ATOM   3301  CB  SER    71      27.129   5.693  13.295  1.00 27.47           C
ATOM   3302  OG  SER    71      27.108   4.708  14.321  1.00 27.61           O
ATOM   3303  C   SER    71      25.131   6.910  14.277  1.00 27.95           C
ATOM   3304  O   SER    71      24.835   6.692  15.459  1.00 28.04           O
ATOM   3305  N   PHE    72      24.239   7.112  13.318  1.00 26.78           N
ATOM   3306  CA  PHE    72      22.811   7.162  13.528  1.00 26.94           C
ATOM   3307  CB  PHE    72      22.302   8.599  13.426  1.00 26.23           C
ATOM   3308  CG  PHE    72      22.848   9.538  14.500  1.00 25.80           C
ATOM   3309  CD1 PHE    72      22.126   9.777  15.662  1.00 27.93           C
ATOM   3310  CE1 PHE    72      22.605  10.661  16.653  1.00 28.12           C
ATOM   3311  CZ  PHE    72      23.826  11.314  16.457  1.00 27.96           C
ATOM   3312  CE2 PHE    72      24.550  11.078  15.291  1.00 27.59           C
ATOM   3313  CD2 PHE    72      24.068  10.185  14.336  1.00 25.35           C
ATOM   3314  C   PHE    72      22.275   6.357  12.361  1.00 27.66           C
ATOM   3315  O   PHE    72      22.540   6.705  11.186  1.00 27.55           O
ATOM   3316  N   GLU    73      21.572   5.277  12.672  1.00 27.38           N
ATOM   3317  CA  GLU    73      21.032   4.383  11.644  1.00 28.12           C
ATOM   3318  CB  GLU    73      21.815   3.055  11.563  1.00 28.15           C
ATOM   3319  CG  GLU    73      21.227   2.007  10.549  1.00 28.54           C
ATOM   3320  CD  GLU    73      22.043   0.696  10.442  1.00 29.78           C
ATOM   3321  OE1 GLU    73      23.166   0.623  11.003  1.00 31.35           O
ATOM   3322  OE2 GLU    73      21.570  -0.272   9.793  1.00 31.62           O
ATOM   3323  C   GLU    73      19.565   4.129  11.950  1.00 27.42           C
ATOM   3324  O   GLU    73      19.217   3.756  13.077  1.00 27.66           O
ATOM   3325  N   VAL    74      18.703   4.373  10.964  1.00 26.44           N
ATOM   3326  CA  VAL    74      17.286   4.003  11.069  1.00 25.62           C
ATOM   3327  CB  VAL    74      16.430   4.563   9.871  1.00 25.05           C
ATOM   3328  CG1 VAL    74      14.954   4.244  10.056  1.00 21.72           C
ATOM   3329  CG2 VAL    74      16.659   6.071   9.680  1.00 24.28           C
ATOM   3330  C   VAL    74      17.121   2.486  11.134  1.00 26.07           C
ATOM   3331  O   VAL    74      17.463   1.786  10.194  1.00 26.27           O
ATOM   3332  N   VAL    75      16.582   1.968  12.235  1.00 24.82           N
ATOM   3333  CA  VAL    75      16.430   0.518  12.289  1.00 24.22           C
ATOM   3334  CB  VAL    75      17.304  -0.135  13.431  1.00 23.75           C
ATOM   3335  CG1 VAL    75      18.875   0.027  13.101  1.00 22.60           C
ATOM   3336  CG2 VAL    75      16.997   0.483  14.733  1.00 22.03           C
ATOM   3337  C   VAL    75      14.953   0.091  12.341  1.00 23.43           C
ATOM   3338  O   VAL    75      14.649  -1.058  12.184  1.00 23.89           O
ATOM   3339  N   ASP    76      14.062   1.038  12.593  1.00 23.04           N
ATOM   3340  CA  ASP    76      12.616   0.792  12.501  1.00 23.06           C
ATOM   3341  CB  ASP    76      12.054   0.166  13.775  1.00 21.32           C
ATOM   3342  CG  ASP    76      10.614  -0.200  13.622  1.00 23.34           C
ATOM   3343  OD1 ASP    76      10.264  -0.862  12.620  1.00 21.79           O
ATOM   3344  OD2 ASP    76       9.805   0.183  14.490  1.00 25.52           O
ATOM   3345  C   ASP    76      11.806   2.034  12.125  1.00 23.33           C
ATOM   3346  O   ASP    76      11.972   3.119  12.728  1.00 22.85           O
ATOM   3347  N   MET    77      10.937   1.850  11.120  1.00 24.35           N
ATOM   3348  CA  MET    77       9.922   2.832  10.717  1.00 23.84           C
ATOM   3349  CB  MET    77       9.918   3.081   9.183  1.00 23.85           C
ATOM   3350  CG  MET    77      11.232   3.638   8.518  1.00 26.25           C
ATOM   3351  SD  MET    77      11.655   5.436   9.114  0.60 30.39          SE
ATOM   3352  CE  MET    77      10.230   6.404   8.177  1.00 25.70           C
ATOM   3353  C   MET    77       8.545   2.282  11.092  1.00 23.56           C
ATOM   3354  O   MET    77       8.280   1.094  10.935  1.00 23.44           O
ATOM   3355  N   ASP    78       7.643   3.149  11.524  1.00 23.14           N
ATOM   3356  CA  ASP    78       6.238   2.764  11.616  1.00 23.52           C
ATOM   3357  CB  ASP    78       5.742   2.835  13.055  1.00 23.99           C
ATOM   3358  CG  ASP    78       6.446   1.841  13.968  1.00 24.34           C
ATOM   3359  OD1 ASP    78       6.774   0.690  13.557  1.00 25.48           O
ATOM   3360  OD2 ASP    78       6.679   2.218  15.123  1.00 22.71           O
ATOM   3361  C   ASP    78       5.441   3.672  10.708  1.00 23.25           C
ATOM   3362  O   ASP    78       5.160   4.830  11.028  1.00 22.38           O
ATOM   3363  N   ARG    79       5.097   3.129   9.551  1.00 24.03           N
ATOM   3364  CA  ARG    79       4.717   3.937   8.389  1.00 25.30           C
ATOM   3365  CB  ARG    79       3.226   4.296   8.407  1.00 25.90           C
ATOM   3366  CG  ARG    79       2.367   3.072   8.690  1.00 28.42           C
ATOM   3367  CD  ARG    79       0.908   3.397   8.810  1.00 33.34           C
ATOM   3368  NE  ARG    79       0.632   4.375   9.859  1.00 36.69           N
ATOM   3369  CZ  ARG    79      -0.354   5.270   9.793  1.00 38.53           C
ATOM   3370  NH1 ARG    79      -1.162   5.301   8.729  1.00 37.32           N
ATOM   3371  NH2 ARG    79      -0.534   6.129  10.791  1.00 39.47           N
ATOM   3372  C   ARG    79       5.673   5.124   8.217  1.00 24.97           C
ATOM   3373  O   ARG    79       6.835   4.898   7.846  1.00 25.53           O
ATOM   3374  N   THR    80       5.241   6.364   8.485  1.00 24.47           N
ATOM   3375  CA  THR    80       6.145   7.525   8.242  1.00 24.62           C
ATOM   3376  CB  THR    80       5.400   8.792   7.781  1.00 24.57           C
ATOM   3377  OG1 THR    80       4.590   9.277   8.855  1.00 26.20           O
ATOM   3378  CG2 THR    80       4.506   8.532   6.555  1.00 24.94           C
ATOM   3379  C   THR    80       6.997   7.897   9.476  1.00 24.20           C
ATOM   3380  O   THR    80       7.792   8.809   9.428  1.00 24.80           O
ATOM   3381  N   ARG    81       6.819   7.190  10.583  1.00 24.32           N
ATOM   3382  CA  ARG    81       7.434   7.586  11.831  1.00 23.49           C
ATOM   3383  CB  ARG    81       6.528   7.227  13.015  1.00 24.51           C
ATOM   3384  CG  ARG    81       7.116   7.598  14.369  1.00 25.10           C
ATOM   3385  CD  ARG    81       6.156   7.226  15.475  1.00 28.67           C
ATOM   3386  NE  ARG    81       6.049   5.781  15.669  1.00 28.69           N
ATOM   3387  CZ  ARG    81       4.891   5.154  15.892  1.00 31.57           C
ATOM   3388  NH1 ARG    81       3.749   5.832  15.903  1.00 31.22           N
ATOM   3389  NH2 ARG    81       4.862   3.847  16.082  1.00 31.69           N
ATOM   3390  C   ARG    81       8.765   6.894  11.939  1.00 22.82           C
ATOM   3391  O   ARG    81       8.869   5.667  11.718  1.00 22.49           O
ATOM   3392  N   VAL    82       9.788   7.688  12.234  1.00 22.27           N
ATOM   3393  CA  VAL    82      11.108   7.151  12.543  1.00 22.97           C
ATOM   3394  CB  VAL    82      12.243   8.207  12.375  1.00 21.97           C
ATOM   3395  CG1 VAL    82      13.593   7.561  12.706  1.00 21.96           C
ATOM   3396  CG2 VAL    82      12.235   8.774  10.950  1.00 21.47           C
ATOM   3397  C   VAL    82      11.051   6.652  13.991  1.00 23.97           C
ATOM   3398  O   VAL    82      11.196   7.436  14.941  1.00 25.11           O
ATOM   3399  N   ASP    83      10.828   5.354  14.153  1.00 24.53           N
ATOM   3400  CA  ASP    83      10.459   4.797  15.468  1.00 23.83           C
ATOM   3401  CB  ASP    83       9.547   3.588  15.274  1.00 23.49           C
ATOM   3402  CG  ASP    83       8.866   3.155  16.565  1.00 25.53           C
ATOM   3403  OD1 ASP    83       8.238   4.016  17.231  1.00 23.09           O
ATOM   3404  OD2 ASP    83       8.957   1.938  16.905  1.00 23.96           O
ATOM   3405  C   ASP    83      11.662   4.402  16.309  1.00 24.17           C
ATOM   3406  O   ASP    83      11.621   4.526  17.532  1.00 24.27           O
ATOM   3407  N   LYS    84      12.726   3.907  15.668  1.00 24.03           N
ATOM   3408  CA  LYS    84      13.904   3.469  16.412  1.00 24.49           C
ATOM   3409  CB  LYS    84      13.823   1.968  16.808  1.00 23.83           C
ATOM   3410  CG  LYS    84      14.905   1.513  17.836  1.00 22.05           C
ATOM   3411  CD  LYS    84      14.488   1.929  19.326  1.00 20.36           C
ATOM   3412  CE  LYS    84      13.532   0.863  19.948  1.00 20.90           C
ATOM   3413  NZ  LYS    84      12.706   1.269  21.133  1.00 23.41           N
ATOM   3414  C   LYS    84      15.177   3.759  15.625  1.00 24.36           C
ATOM   3415  O   LYS    84      15.257   3.475  14.427  1.00 24.95           O
ATOM   3416  N   ILE    85      16.167   4.321  16.316  1.00 24.89           N
ATOM   3417  CA  ILE    85      17.463   4.645  15.733  1.00 24.92           C
ATOM   3418  CB  ILE    85      17.781   6.176  15.796  1.00 25.59           C
ATOM   3419  CG1 ILE    85      16.719   7.031  15.071  1.00 25.62           C
ATOM   3420  CD1 ILE    85      15.512   7.395  15.896  1.00 25.43           C
ATOM   3421  CG2 ILE    85      19.116   6.464  15.127  1.00 24.13           C
ATOM   3422  C   ILE    85      18.543   3.879  16.493  1.00 25.39           C
ATOM   3423  O   ILE    85      18.491   3.798  17.745  1.00 25.81           O
ATOM   3424  N   LEU    86      19.495   3.309  15.751  1.00 24.91           N
ATOM   3425  CA  LEU    86      20.690   2.761  16.362  1.00 25.66           C
ATOM   3426  CB  LEU    86      21.252   1.578  15.589  1.00 25.83           C
ATOM   3427  CG  LEU    86      22.465   0.836  16.211  1.00 25.84           C
ATOM   3428  CD1 LEU    86      22.055   0.090  17.458  1.00 25.27           C
ATOM   3429  CD2 LEU    86      22.970  -0.153  15.159  1.00 27.03           C
ATOM   3430  C   LEU    86      21.731   3.844  16.445  1.00 25.05           C
ATOM   3431  O   LEU    86      22.145   4.389  15.424  1.00 25.06           O
ATOM   3432  N   VAL    87      22.129   4.178  17.663  1.00 24.73           N
ATOM   3433  CA  VAL    87      23.078   5.276  17.869  1.00 24.65           C
ATOM   3434  CB  VAL    87      22.539   6.349  18.791  1.00 25.32           C
ATOM   3435  CG1 VAL    87      23.587   7.505  18.937  1.00 23.95           C
ATOM   3436  CG2 VAL    87      21.218   6.909  18.254  1.00 26.42           C
ATOM   3437  C   VAL    87      24.366   4.691  18.456  1.00 25.49           C
ATOM   3438  O   VAL    87      24.307   3.785  19.318  1.00 24.81           O
ATOM   3439  N   GLN    88      25.518   5.135  17.955  1.00 24.84           N
ATOM   3440  CA  GLN    88      26.776   4.611  18.481  1.00 26.09           C
ATOM   3441  CB  GLN    88      27.199   3.268  17.811  1.00 26.52           C
ATOM   3442  CG  GLN    88      28.390   2.592  18.543  1.00 25.32           C
ATOM   3443  CD  GLN    88      28.739   1.223  18.025  1.00 28.01           C
ATOM   3444  OE1 GLN    88      28.304   0.816  16.935  1.00 28.30           O
ATOM   3445  NE2 GLN    88      29.534   0.481  18.807  1.00 26.49           N
ATOM   3446  C   GLN    88      27.881   5.635  18.455  1.00 26.10           C
ATOM   3447  O   GLN    88      28.113   6.277  17.429  1.00 27.07           O
ATOM   3448  N   ARG    89      28.542   5.826  19.598  1.00 26.77           N
ATOM   3449  CA  ARG    89      29.749   6.670  19.644  1.00 27.37           C
ATOM   3450  CB  ARG    89      29.960   7.310  21.016  1.00 27.17           C
ATOM   3451  CG  ARG    89      31.013   8.475  21.031  1.00 28.39           C
ATOM   3452  CD  ARG    89      31.565   8.745  22.459  1.00 31.11           C
ATOM   3453  NE  ARG    89      30.484   8.679  23.442  1.00 43.41           N
ATOM   3454  CZ  ARG    89      29.849   9.737  23.969  1.00 48.58           C
ATOM   3455  NH1 ARG    89      30.207  10.996  23.643  1.00 49.64           N
ATOM   3456  NH2 ARG    89      28.844   9.536  24.838  1.00 48.75           N
ATOM   3457  C   ARG    89      30.963   5.799  19.300  1.00 27.15           C
ATOM   3458  O   ARG    89      31.129   4.715  19.853  1.00 26.09           O
ATOM   3459  N   HIS    90      31.791   6.281  18.372  1.00 27.72           N
ATOM   3460  CA  HIS    90      32.892   5.494  17.842  1.00 28.10           C
ATOM   3461  CB  HIS    90      32.837   5.519  16.318  1.00 28.17           C
ATOM   3462  CG  HIS    90      31.606   4.838  15.777  1.00 25.94           C
ATOM   3463  ND1 HIS    90      31.433   3.479  15.842  1.00 27.32           N
ATOM   3464  CE1 HIS    90      30.265   3.151  15.307  1.00 28.46           C
ATOM   3465  NE2 HIS    90      29.657   4.264  14.933  1.00 27.25           N
ATOM   3466  CD2 HIS    90      30.477   5.333  15.212  1.00 25.68           C
ATOM   3467  C   HIS    90      34.268   5.801  18.444  1.00 29.75           C
ATOM   3468  O   HIS    90      35.292   5.585  17.820  1.00 29.05           O
ATOM   3469  N   HIS    91      34.251   6.290  19.688  1.00 31.59           N
ATOM   3470  CA  HIS    91      35.426   6.349  20.565  1.00 33.37           C
ATOM   3471  CB  HIS    91      36.173   7.672  20.387  1.00 34.12           C
ATOM   3472  CG  HIS    91      35.302   8.874  20.573  1.00 37.55           C
ATOM   3473  ND1 HIS    91      35.368   9.677  21.693  1.00 41.47           N
ATOM   3474  CE1 HIS    91      34.479  10.652  21.581  1.00 42.12           C
ATOM   3475  NE2 HIS    91      33.836  10.501  20.436  1.00 40.69           N
ATOM   3476  CD2 HIS    91      34.332   9.399  19.787  1.00 40.37           C
ATOM   3477  C   HIS    91      35.007   6.157  22.048  1.00 33.41           C
ATOM   3478  O   HIS    91      35.851   6.025  22.942  1.00 33.69           O
ATOM   3479  OXT HIS    91      33.823   6.105  22.404  1.00 32.91           O
END
