
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  132 ( 1077),  selected  132 , name 2cay_A
# Molecule2: number of CA atoms  116 (  905),  selected  116 , name T0446.pdb
# PARAMETERS: 2cay_A.T0446.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    H    -1_A      G       9           -
LGA    H     0_A      N      10           -
LGA    M     1_A      A      11           -
LGA    E     2_A      A      12           -
LGA    Y     3_A      E      13           -
LGA    W     4_A      V      14           -
LGA    H     5_A      N      15           -
LGA    Y     6_A      L      16           -
LGA    V     7_A      D      17           -
LGA    E     8_A      -       -           -
LGA    T     9_A      -       -           -
LGA    T    10_A      -       -           -
LGA    S    11_A      -       -           -
LGA    S    12_A      -       -           -
LGA    G    13_A      E      18           #
LGA    Q    14_A      L      19          3.538
LGA    -       -      A      20           -
LGA    -       -      Q      21           -
LGA    -       -      E      22           -
LGA    P    15_A      L      23          2.718
LGA    L    16_A      G      24          3.770
LGA    -       -      P      25           -
LGA    L    17_A      I      26          3.851
LGA    R    18_A      M      27          2.363
LGA    -       -      G      28           -
LGA    E    19_A      D      29          1.792
LGA    G    20_A      N      30          1.174
LGA    E    21_A      E      31          1.232
LGA    K    22_A      Q      32          0.889
LGA    D    23_A      L      33          0.641
LGA    I    24_A      A      34          1.114
LGA    F    25_A      L      35          1.386
LGA    I    26_A      A      36          1.696
LGA    D    27_A      Y      37          2.448
LGA    Q    28_A      R      38          3.107
LGA    S    29_A      V      39          2.209
LGA    V    30_A      -       -           -
LGA    G    31_A      -       -           -
LGA    L    32_A      -       -           -
LGA    Y    33_A      -       -           -
LGA    H    34_A      -       -           -
LGA    G    35_A      -       -           -
LGA    K    36_A      -       -           -
LGA    S    37_A      -       -           -
LGA    K    38_A      -       -           -
LGA    I    39_A      -       -           -
LGA    L    40_A      -       -           -
LGA    Q    41_A      -       -           -
LGA    R    42_A      -       -           -
LGA    Q    43_A      -       -           -
LGA    R    44_A      I      40          3.790
LGA    -       -      R      41           -
LGA    G    45_A      D      42          2.186
LGA    R    46_A      M      43          2.584
LGA    I    47_A      F      44          1.428
LGA    F    48_A      V      45          1.053
LGA    L    49_A      F      46          0.482
LGA    T    50_A      T      47          0.682
LGA    S    51_A      N      48          1.410
LGA    Q    52_A      K      49          1.442
LGA    R    53_A      R      50          1.141
LGA    I    54_A      L      51          0.744
LGA    I    55_A      I      52          1.338
LGA    Y    56_A      L      53          2.199
LGA    I    57_A      I      54          3.064
LGA    D    58_A      D      55          4.063
LGA    D    59_A      K      56           #
LGA    -       -      Q      57           -
LGA    -       -      G      58           -
LGA    -       -      V      59           -
LGA    A    60_A      T      60           #
LGA    K    61_A      G      61          3.133
LGA    P    62_A      -       -           -
LGA    T    63_A      K      62           #
LGA    Q    64_A      K      63          3.807
LGA    N    65_A      V      64          2.148
LGA    S    66_A      S      65          3.697
LGA    L    67_A      Y      66          2.521
LGA    G    68_A      H      67          2.240
LGA    -       -      S      68           -
LGA    L    69_A      V      69          1.853
LGA    E    70_A      P      70          2.195
LGA    L    71_A      Y      71          1.735
LGA    D    72_A      K      72          2.196
LGA    D    73_A      A      73          1.408
LGA    L    74_A      I      74          1.223
LGA    A    75_A      T      75          0.953
LGA    Y    76_A      H      76          1.603
LGA    V    77_A      F      77          2.135
LGA    N    78_A      E      78          1.585
LGA    Y    79_A      V      79          1.513
LGA    S    80_A      E      80          1.766
LGA    S    81_A      T      81          1.822
LGA    G    82_A      A      82          2.314
LGA    F    83_A      G      83          2.384
LGA    L    84_A      T      84           -
LGA    T    85_A      F      85           -
LGA    R    86_A      D      86           #
LGA    S    87_A      M      87          4.708
LGA    P    88_A      D      88          3.164
LGA    -       -      A      89           -
LGA    R    89_A      E      90          1.811
LGA    L    90_A      L      91          1.374
LGA    I    91_A      K      92          0.838
LGA    L    92_A      L      93          0.391
LGA    F    93_A      W      94          1.205
LGA    F    94_A      I      95          2.118
LGA    K    95_A      S      96          2.888
LGA    D    96_A      G      97          2.751
LGA    P    97_A      Q      98          3.038
LGA    S    98_A      -       -           -
LGA    S    99_A      -       -           -
LGA    S   252_A      K      99          3.765
LGA    T   253_A      D     100          3.166
LGA    E   254_A      -       -           -
LGA    F   255_A      P     101          1.351
LGA    V   256_A      L     102          0.512
LGA    Q   257_A      V     103          1.538
LGA    L   258_A      K     104          1.969
LGA    S   259_A      E     105          1.803
LGA    F   260_A      L     106          2.807
LGA    R   261_A      K     107          2.821
LGA    K   262_A      K     108          3.159
LGA    S   263_A      G     109          2.395
LGA    D   264_A      T     110          4.703
LGA    G   265_A      D     111          4.454
LGA    V   266_A      V     112          1.018
LGA    L   267_A      V     113          3.697
LGA    -       -      G     114           -
LGA    F   268_A      I     115          1.620
LGA    S   269_A      Q     116          2.360
LGA    Q   270_A      K     117          1.966
LGA    A   271_A      T     118          1.019
LGA    T   272_A      I     119          1.544
LGA    E   273_A      A     120          2.037
LGA    R   274_A      N     121          1.556
LGA    A   275_A      F     122          0.993
LGA    L   276_A      S     123          0.669
LGA    E   277_A      L     124          1.118
LGA    N   278_A      -       -           -
LGA    I   279_A      -       -           -
LGA    L   280_A      -       -           -
LGA    T   281_A      -       -           -
LGA    E   282_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  132  116    5.0     88    2.33    12.50     51.780     3.619

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.311583 * X  +  -0.519867 * Y  +  -0.795395 * Z  + 101.238625
  Y_new =   0.908623 * X  +   0.081947 * Y  +  -0.409499 * Z  + -16.041641
  Z_new =   0.278065 * X  +  -0.850308 * Y  +   0.446830 * Z  +  24.964102 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.086964    2.054629  [ DEG:   -62.2784    117.7216 ]
  Theta =  -0.281779   -2.859813  [ DEG:   -16.1448   -163.8552 ]
  Phi   =   1.901148   -1.240444  [ DEG:   108.9278    -71.0722 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2cay_A                                        
REMARK     2: T0446.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2cay_A.T0446.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  132  116   5.0   88   2.33   12.50  51.780
REMARK  ---------------------------------------------------------- 
MOLECULE 2cay_A
HEADER    TRANSPORT                               23-DEC-05   2CAY              
TITLE     VPS36 N-TERMINAL PH DOMAIN                                            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: VACUOLAR PROTEIN SORTING PROTEIN 36;                       
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: PH DOMAIN, RESIDUES 1-99 AND 252-289;                      
COMPND   5 SYNONYM: VPS36 PH DOMAIN;                                            
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE   3 ORGANISM_COMMON: BAKER'S YEAST;                                      
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: C41(DE3);                                  
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: POPTH                                     
KEYWDS    VPS36, PH DOMAIN, ESCRT-II, LIPID-BINDING, MULTIVESICULAR             
KEYWDS   2 BODIES, MEMBRANE, METAL-BINDING, PROTEIN TRANSPORT,                  
KEYWDS   3 TRANSPORT, ZINC, ZINC-FINGER                                         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    H.TEO,R.L.WILLIAMS,O.PERISIC,D.J.GILL                                 
REVDAT   1   07-APR-06 2CAY    0                                                
JRNL        AUTH   H.TEO,D.J.GILL,J.SUN,O.PERISIC,D.B.VEPRINTSEV,               
JRNL        AUTH 2 Y.VALLIS,S.D.EMR,R.L.WILLIAMS                                
JRNL        TITL   ESCRT-I CORE AND ESCRT-II GLUE DOMAIN STRUCTURES             
JRNL        TITL 2 REVEAL ROLE FOR GLUE IN LINKING TO ESCRT-I AND               
JRNL        TITL 3 MEMBRANES.                                                   
JRNL        REF    CELL                          V. 125    99 2006              
JRNL        REFN   ASTM CELLB5  US ISSN 0092-8674                               
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  2CAY A   -7     0  PDB    2CAY     2CAY            -7      0             
DBREF  2CAY A    1    99  UNP    Q06696   VPS36_YEAST      1     99             
DBREF  2CAY A  252   289  UNP    Q06696   VPS36_YEAST    252    289             
DBREF  2CAY B   -7     0  PDB    2CAY     2CAY            -7      0             
DBREF  2CAY B    1    99  UNP    Q06696   VPS36_YEAST      1     99             
DBREF  2CAY B  252   289  UNP    Q06696   VPS36_YEAST    252    289             
SEQRES   1 A  145  MET ALA HIS HIS HIS HIS HIS HIS MET GLU TYR TRP HIS          
SEQRES   2 A  145  TYR VAL GLU THR THR SER SER GLY GLN PRO LEU LEU ARG          
SEQRES   3 A  145  GLU GLY GLU LYS ASP ILE PHE ILE ASP GLN SER VAL GLY          
SEQRES   4 A  145  LEU TYR HIS GLY LYS SER LYS ILE LEU GLN ARG GLN ARG          
SEQRES   5 A  145  GLY ARG ILE PHE LEU THR SER GLN ARG ILE ILE TYR ILE          
SEQRES   6 A  145  ASP ASP ALA LYS PRO THR GLN ASN SER LEU GLY LEU GLU          
SEQRES   7 A  145  LEU ASP ASP LEU ALA TYR VAL ASN TYR SER SER GLY PHE          
SEQRES   8 A  145  LEU THR ARG SER PRO ARG LEU ILE LEU PHE PHE LYS ASP          
SEQRES   9 A  145  PRO SER SER SER THR GLU PHE VAL GLN LEU SER PHE ARG          
SEQRES  10 A  145  LYS SER ASP GLY VAL LEU PHE SER GLN ALA THR GLU ARG          
SEQRES  11 A  145  ALA LEU GLU ASN ILE LEU THR GLU LYS ASN LYS HIS ILE          
SEQRES  12 A  145  PHE ASN                                                      
SEQRES   1 B  145  MET ALA HIS HIS HIS HIS HIS HIS MET GLU TYR TRP HIS          
SEQRES   2 B  145  TYR VAL GLU THR THR SER SER GLY GLN PRO LEU LEU ARG          
SEQRES   3 B  145  GLU GLY GLU LYS ASP ILE PHE ILE ASP GLN SER VAL GLY          
SEQRES   4 B  145  LEU TYR HIS GLY LYS SER LYS ILE LEU GLN ARG GLN ARG          
SEQRES   5 B  145  GLY ARG ILE PHE LEU THR SER GLN ARG ILE ILE TYR ILE          
SEQRES   6 B  145  ASP ASP ALA LYS PRO THR GLN ASN SER LEU GLY LEU GLU          
SEQRES   7 B  145  LEU ASP ASP LEU ALA TYR VAL ASN TYR SER SER GLY PHE          
SEQRES   8 B  145  LEU THR ARG SER PRO ARG LEU ILE LEU PHE PHE LYS ASP          
SEQRES   9 B  145  PRO SER SER SER THR GLU PHE VAL GLN LEU SER PHE ARG          
SEQRES  10 B  145  LYS SER ASP GLY VAL LEU PHE SER GLN ALA THR GLU ARG          
SEQRES  11 B  145  ALA LEU GLU ASN ILE LEU THR GLU LYS ASN LYS HIS ILE          
SEQRES  12 B  145  PHE ASN                                                      
HET    SO4  A1283       5                                                       
HET    SO4  B1282       5                                                       
HETNAM     SO4 SULFATE ION                                                      
FORMUL   3  SO4    2(O4 S 2-)                                                   
FORMUL   5  HOH   *176(H2 O)                                                    
CRYST1   94.451   88.375   45.888  90.00  90.00  90.00 P 21 21 2     8          
ATOM      1  N   HIS A  -1      72.359  -4.664  15.229  1.00 53.18           N  
ATOM      2  CA  HIS A  -1      71.679  -5.427  16.319  1.00 53.05           C  
ATOM      3  C   HIS A  -1      70.181  -5.599  16.042  1.00 52.39           C  
ATOM      4  O   HIS A  -1      69.514  -4.679  15.558  1.00 52.15           O  
ATOM      5  CB  HIS A  -1      71.896  -4.745  17.672  1.00 53.82           C  
ATOM      6  CG  HIS A  -1      71.764  -5.673  18.840  1.00 55.27           C  
ATOM      7  ND1 HIS A  -1      72.854  -6.214  19.489  1.00 56.79           N  
ATOM      8  CD2 HIS A  -1      70.670  -6.166  19.468  1.00 56.44           C  
ATOM      9  CE1 HIS A  -1      72.439  -6.995  20.471  1.00 57.34           C  
ATOM     10  NE2 HIS A  -1      71.117  -6.983  20.481  1.00 57.76           N  
ATOM     11  N   HIS A   0      69.664  -6.784  16.366  1.00 51.50           N  
ATOM     12  CA  HIS A   0      68.270  -7.146  16.076  1.00 50.72           C  
ATOM     13  C   HIS A   0      67.237  -6.382  16.936  1.00 50.07           C  
ATOM     14  O   HIS A   0      66.024  -6.440  16.676  1.00 49.73           O  
ATOM     15  CB  HIS A   0      68.080  -8.670  16.200  1.00 50.58           C  
ATOM     16  CG  HIS A   0      68.256  -9.192  17.592  1.00 51.00           C  
ATOM     17  ND1 HIS A   0      69.488  -9.528  18.113  1.00 51.88           N  
ATOM     18  CD2 HIS A   0      67.354  -9.437  18.573  1.00 51.49           C  
ATOM     19  CE1 HIS A   0      69.336  -9.954  19.355  1.00 52.38           C  
ATOM     20  NE2 HIS A   0      68.051  -9.911  19.658  1.00 52.05           N  
ATOM     21  N   MET A   1      67.721  -5.658  17.948  1.00 49.04           N  
ATOM     22  CA  MET A   1      66.824  -4.994  18.895  1.00 48.13           C  
ATOM     23  C   MET A   1      66.308  -3.631  18.426  1.00 46.83           C  
ATOM     24  O   MET A   1      65.471  -3.019  19.101  1.00 46.92           O  
ATOM     25  CB  MET A   1      67.453  -4.898  20.296  1.00 48.47           C  
ATOM     26  CG  MET A   1      67.521  -6.234  21.065  1.00 50.31           C  
ATOM     27  SD  MET A   1      65.947  -7.139  21.236  1.00 54.10           S  
ATOM     28  CE  MET A   1      64.942  -5.997  22.209  1.00 52.43           C  
ATOM     29  N   GLU A   2      66.779  -3.162  17.269  1.00 44.84           N  
ATOM     30  CA  GLU A   2      66.226  -1.943  16.677  1.00 43.17           C  
ATOM     31  C   GLU A   2      64.804  -2.227  16.204  1.00 41.09           C  
ATOM     32  O   GLU A   2      63.926  -1.364  16.270  1.00 41.06           O  
ATOM     33  CB  GLU A   2      67.085  -1.476  15.504  1.00 43.45           C  
ATOM     34  CG  GLU A   2      66.553  -0.222  14.793  1.00 45.01           C  
ATOM     35  CD  GLU A   2      67.245   0.063  13.460  1.00 45.43           C  
ATOM     36  OE1 GLU A   2      68.464  -0.231  13.314  1.00 47.82           O  
ATOM     37  OE2 GLU A   2      66.561   0.593  12.551  1.00 49.03           O  
ATOM     38  N   TYR A   3      64.586  -3.461  15.755  1.00 38.10           N  
ATOM     39  CA  TYR A   3      63.333  -3.864  15.138  1.00 36.04           C  
ATOM     40  C   TYR A   3      62.454  -4.706  16.087  1.00 33.73           C  
ATOM     41  O   TYR A   3      61.235  -4.631  16.032  1.00 33.86           O  
ATOM     42  CB  TYR A   3      63.641  -4.643  13.852  1.00 36.85           C  
ATOM     43  CG  TYR A   3      64.666  -3.966  12.945  1.00 37.87           C  
ATOM     44  CD1 TYR A   3      64.278  -2.964  12.036  1.00 37.99           C  
ATOM     45  CD2 TYR A   3      66.030  -4.323  12.999  1.00 39.34           C  
ATOM     46  CE1 TYR A   3      65.227  -2.332  11.184  1.00 38.39           C  
ATOM     47  CE2 TYR A   3      66.990  -3.693  12.157  1.00 39.02           C  
ATOM     48  CZ  TYR A   3      66.581  -2.701  11.251  1.00 39.04           C  
ATOM     49  OH  TYR A   3      67.523  -2.086  10.416  1.00 37.67           O  
ATOM     50  N   TRP A   4      63.080  -5.509  16.938  1.00 30.87           N  
ATOM     51  CA  TRP A   4      62.357  -6.369  17.855  1.00 29.03           C  
ATOM     52  C   TRP A   4      62.089  -5.626  19.180  1.00 27.88           C  
ATOM     53  O   TRP A   4      62.870  -4.752  19.579  1.00 27.69           O  
ATOM     54  CB  TRP A   4      63.148  -7.646  18.124  1.00 29.15           C  
ATOM     55  CG  TRP A   4      63.216  -8.723  16.991  1.00 29.50           C  
ATOM     56  CD1 TRP A   4      64.272  -8.943  16.131  1.00 29.82           C  
ATOM     57  CD2 TRP A   4      62.238  -9.747  16.683  1.00 27.93           C  
ATOM     58  NE1 TRP A   4      64.000 -10.005  15.304  1.00 30.36           N  
ATOM     59  CE2 TRP A   4      62.763 -10.517  15.610  1.00 29.69           C  
ATOM     60  CE3 TRP A   4      60.977 -10.070  17.189  1.00 27.56           C  
ATOM     61  CZ2 TRP A   4      62.065 -11.593  15.037  1.00 28.40           C  
ATOM     62  CZ3 TRP A   4      60.268 -11.148  16.615  1.00 30.10           C  
ATOM     63  CH2 TRP A   4      60.825 -11.900  15.552  1.00 29.95           C  
ATOM     64  N   HIS A   5      60.982  -5.945  19.842  1.00 25.02           N  
ATOM     65  CA  HIS A   5      60.709  -5.387  21.179  1.00 23.74           C  
ATOM     66  C   HIS A   5      60.436  -6.513  22.185  1.00 22.99           C  
ATOM     67  O   HIS A   5      60.064  -7.642  21.814  1.00 20.83           O  
ATOM     68  CB  HIS A   5      59.582  -4.326  21.156  1.00 23.48           C  
ATOM     69  CG  HIS A   5      58.285  -4.822  20.587  1.00 24.18           C  
ATOM     70  ND1 HIS A   5      57.461  -5.709  21.255  1.00 26.76           N  
ATOM     71  CD2 HIS A   5      57.685  -4.584  19.397  1.00 21.63           C  
ATOM     72  CE1 HIS A   5      56.412  -5.998  20.500  1.00 20.67           C  
ATOM     73  NE2 HIS A   5      56.516  -5.320  19.375  1.00 24.06           N  
ATOM     74  N   TYR A   6      60.628  -6.217  23.469  1.00 22.09           N  
ATOM     75  CA  TYR A   6      60.399  -7.216  24.506  1.00 21.53           C  
ATOM     76  C   TYR A   6      58.884  -7.495  24.598  1.00 20.51           C  
ATOM     77  O   TYR A   6      58.061  -6.577  24.430  1.00 19.63           O  
ATOM     78  CB  TYR A   6      60.980  -6.698  25.836  1.00 22.55           C  
ATOM     79  CG  TYR A   6      60.649  -7.544  27.031  1.00 23.65           C  
ATOM     80  CD1 TYR A   6      61.316  -8.742  27.282  1.00 25.24           C  
ATOM     81  CD2 TYR A   6      59.633  -7.149  27.909  1.00 25.09           C  
ATOM     82  CE1 TYR A   6      60.983  -9.522  28.406  1.00 25.77           C  
ATOM     83  CE2 TYR A   6      59.297  -7.918  29.008  1.00 25.12           C  
ATOM     84  CZ  TYR A   6      59.962  -9.088  29.250  1.00 24.69           C  
ATOM     85  OH  TYR A   6      59.598  -9.810  30.362  1.00 27.22           O  
ATOM     86  N   VAL A   7      58.534  -8.759  24.813  1.00 19.51           N  
ATOM     87  CA  VAL A   7      57.128  -9.191  24.976  1.00 19.77           C  
ATOM     88  C   VAL A   7      56.988  -9.924  26.329  1.00 19.43           C  
ATOM     89  O   VAL A   7      57.765 -10.821  26.632  1.00 18.81           O  
ATOM     90  CB  VAL A   7      56.650 -10.138  23.802  1.00 19.59           C  
ATOM     91  CG1 VAL A   7      55.314 -10.815  24.146  1.00 20.68           C  
ATOM     92  CG2 VAL A   7      56.484  -9.347  22.519  1.00 18.34           C  
ATOM     93  N   GLU A   8      55.994  -9.530  27.128  1.00 19.44           N  
ATOM     94  CA  GLU A   8      55.716 -10.198  28.404  1.00 20.22           C  
ATOM     95  C   GLU A   8      54.846 -11.406  28.143  1.00 20.11           C  
ATOM     96  O   GLU A   8      53.976 -11.367  27.258  1.00 19.82           O  
ATOM     97  CB  GLU A   8      54.955  -9.254  29.348  1.00 20.24           C  
ATOM     98  CG  GLU A   8      55.694  -7.984  29.778  1.00 21.13           C  
ATOM     99  CD  GLU A   8      54.885  -7.184  30.820  1.00 22.72           C  
ATOM    100  OE1 GLU A   8      54.111  -7.810  31.570  1.00 26.10           O  
ATOM    101  OE2 GLU A   8      54.991  -5.949  30.871  1.00 26.60           O  
ATOM    102  N   THR A   9      55.074 -12.466  28.909  1.00 20.09           N  
ATOM    103  CA  THR A   9      54.246 -13.666  28.862  1.00 20.89           C  
ATOM    104  C   THR A   9      53.825 -14.139  30.268  1.00 22.08           C  
ATOM    105  O   THR A   9      54.409 -13.727  31.279  1.00 21.36           O  
ATOM    106  CB  THR A   9      54.993 -14.842  28.222  1.00 21.16           C  
ATOM    107  OG1 THR A   9      55.956 -15.358  29.151  1.00 22.77           O  
ATOM    108  CG2 THR A   9      55.681 -14.426  26.925  1.00 17.89           C  
ATOM    109  N   THR A  10      52.819 -15.008  30.324  1.00 22.65           N  
ATOM    110  CA  THR A  10      52.525 -15.726  31.554  1.00 24.70           C  
ATOM    111  C   THR A  10      53.645 -16.729  31.852  1.00 26.12           C  
ATOM    112  O   THR A  10      54.520 -17.011  31.019  1.00 25.68           O  
ATOM    113  CB  THR A  10      51.155 -16.438  31.482  1.00 24.87           C  
ATOM    114  OG1 THR A  10      51.245 -17.540  30.558  1.00 25.92           O  
ATOM    115  CG2 THR A  10      50.058 -15.471  31.023  1.00 24.19           C  
ATOM    116  N   SER A  11      53.652 -17.257  33.069  1.00 28.39           N  
ATOM    117  CA  SER A  11      54.619 -18.282  33.440  1.00 30.40           C  
ATOM    118  C   SER A  11      54.607 -19.456  32.444  1.00 31.54           C  
ATOM    119  O   SER A  11      55.665 -20.007  32.084  1.00 32.37           O  
ATOM    120  CB  SER A  11      54.308 -18.761  34.870  1.00 31.12           C  
ATOM    121  OG  SER A  11      52.892 -18.757  35.099  1.00 33.81           O  
ATOM    122  N   SER A  12      53.416 -19.807  31.969  1.00 32.11           N  
ATOM    123  CA  SER A  12      53.243 -20.930  31.036  1.00 32.74           C  
ATOM    124  C   SER A  12      53.618 -20.618  29.565  1.00 32.32           C  
ATOM    125  O   SER A  12      53.591 -21.506  28.710  1.00 32.84           O  
ATOM    126  CB  SER A  12      51.817 -21.480  31.143  1.00 32.49           C  
ATOM    127  OG  SER A  12      50.862 -20.508  30.761  1.00 34.02           O  
ATOM    128  N   GLY A  13      53.960 -19.361  29.278  1.00 31.46           N  
ATOM    129  CA  GLY A  13      54.438 -18.962  27.958  1.00 30.03           C  
ATOM    130  C   GLY A  13      53.353 -18.450  27.041  1.00 29.44           C  
ATOM    131  O   GLY A  13      53.490 -18.507  25.815  1.00 29.95           O  
ATOM    132  N   GLN A  14      52.267 -17.951  27.621  1.00 27.80           N  
ATOM    133  CA  GLN A  14      51.230 -17.320  26.848  1.00 26.95           C  
ATOM    134  C   GLN A  14      51.492 -15.799  26.777  1.00 25.63           C  
ATOM    135  O   GLN A  14      51.645 -15.143  27.814  1.00 24.27           O  
ATOM    136  CB  GLN A  14      49.862 -17.667  27.441  1.00 27.58           C  
ATOM    137  CG  GLN A  14      48.659 -17.305  26.563  1.00 32.50           C  
ATOM    138  CD  GLN A  14      48.615 -18.032  25.183  1.00 37.64           C  
ATOM    139  OE1 GLN A  14      48.820 -19.256  25.076  1.00 38.77           O  
ATOM    140  NE2 GLN A  14      48.324 -17.263  24.132  1.00 38.16           N  
ATOM    141  N   PRO A  15      51.556 -15.231  25.550  1.00 24.20           N  
ATOM    142  CA  PRO A  15      51.846 -13.790  25.431  1.00 23.47           C  
ATOM    143  C   PRO A  15      50.706 -12.925  25.953  1.00 22.94           C  
ATOM    144  O   PRO A  15      49.532 -13.288  25.812  1.00 21.78           O  
ATOM    145  CB  PRO A  15      52.042 -13.572  23.919  1.00 23.49           C  
ATOM    146  CG  PRO A  15      51.338 -14.728  23.266  1.00 23.61           C  
ATOM    147  CD  PRO A  15      51.363 -15.880  24.235  1.00 24.61           C  
ATOM    148  N   LEU A  16      51.059 -11.795  26.555  1.00 22.72           N  
ATOM    149  CA  LEU A  16      50.075 -10.843  27.042  1.00 23.39           C  
ATOM    150  C   LEU A  16      49.857  -9.832  25.935  1.00 23.08           C  
ATOM    151  O   LEU A  16      50.761  -9.082  25.579  1.00 23.50           O  
ATOM    152  CB  LEU A  16      50.569 -10.161  28.340  1.00 23.64           C  
ATOM    153  CG  LEU A  16      50.900 -11.126  29.494  1.00 25.09           C  
ATOM    154  CD1 LEU A  16      51.332 -10.383  30.755  1.00 28.74           C  
ATOM    155  CD2 LEU A  16      49.735 -12.040  29.799  1.00 27.26           C  
ATOM    156  N   LEU A  17      48.659  -9.840  25.369  1.00 23.27           N  
ATOM    157  CA  LEU A  17      48.376  -9.122  24.132  1.00 24.07           C  
ATOM    158  C   LEU A  17      47.758  -7.765  24.403  1.00 24.81           C  
ATOM    159  O   LEU A  17      47.178  -7.526  25.477  1.00 23.63           O  
ATOM    160  CB  LEU A  17      47.482  -9.985  23.241  1.00 23.73           C  
ATOM    161  CG  LEU A  17      48.066 -10.956  22.182  1.00 24.69           C  
ATOM    162  CD1 LEU A  17      49.562 -11.239  22.210  1.00 21.56           C  
ATOM    163  CD2 LEU A  17      47.261 -12.236  22.044  1.00 24.68           C  
ATOM    164  N   ARG A  18      47.893  -6.877  23.426  1.00 25.13           N  
ATOM    165  CA  ARG A  18      47.373  -5.530  23.541  1.00 26.74           C  
ATOM    166  C   ARG A  18      45.853  -5.492  23.405  1.00 27.55           C  
ATOM    167  O   ARG A  18      45.240  -6.456  22.923  1.00 26.69           O  
ATOM    168  CB  ARG A  18      48.094  -4.615  22.550  1.00 26.88           C  
ATOM    169  CG  ARG A  18      49.601  -4.702  22.775  1.00 28.01           C  
ATOM    170  CD  ARG A  18      50.412  -3.593  22.150  1.00 32.32           C  
ATOM    171  NE  ARG A  18      50.504  -3.709  20.708  1.00 30.04           N  
ATOM    172  CZ  ARG A  18      51.620  -3.608  19.976  1.00 28.47           C  
ATOM    173  NH1 ARG A  18      52.818  -3.400  20.507  1.00 27.82           N  
ATOM    174  NH2 ARG A  18      51.519  -3.728  18.670  1.00 28.51           N  
ATOM    175  N   GLU A  19      45.239  -4.402  23.866  1.00 28.92           N  
ATOM    176  CA  GLU A  19      43.797  -4.266  23.755  1.00 30.49           C  
ATOM    177  C   GLU A  19      43.353  -4.469  22.303  1.00 29.90           C  
ATOM    178  O   GLU A  19      43.862  -3.820  21.383  1.00 30.88           O  
ATOM    179  CB  GLU A  19      43.320  -2.910  24.299  1.00 31.18           C  
ATOM    180  CG  GLU A  19      41.799  -2.702  24.202  1.00 36.31           C  
ATOM    181  CD  GLU A  19      41.219  -1.875  25.363  1.00 43.22           C  
ATOM    182  OE1 GLU A  19      41.718  -1.981  26.526  1.00 46.12           O  
ATOM    183  OE2 GLU A  19      40.241  -1.131  25.111  1.00 45.66           O  
ATOM    184  N   GLY A  20      42.422  -5.395  22.097  1.00 29.03           N  
ATOM    185  CA  GLY A  20      41.870  -5.626  20.761  1.00 28.22           C  
ATOM    186  C   GLY A  20      42.814  -6.379  19.820  1.00 26.91           C  
ATOM    187  O   GLY A  20      42.485  -6.616  18.659  1.00 26.77           O  
ATOM    188  N   GLU A  21      43.998  -6.735  20.307  1.00 24.60           N  
ATOM    189  CA  GLU A  21      44.915  -7.566  19.521  1.00 22.69           C  
ATOM    190  C   GLU A  21      44.529  -9.057  19.645  1.00 22.98           C  
ATOM    191  O   GLU A  21      44.388  -9.568  20.761  1.00 21.92           O  
ATOM    192  CB  GLU A  21      46.348  -7.316  19.988  1.00 22.77           C  
ATOM    193  CG  GLU A  21      47.395  -8.009  19.134  1.00 19.88           C  
ATOM    194  CD  GLU A  21      48.811  -7.932  19.730  1.00 22.08           C  
ATOM    195  OE1 GLU A  21      48.990  -7.546  20.917  1.00 18.39           O  
ATOM    196  OE2 GLU A  21      49.759  -8.286  19.003  1.00 16.18           O  
ATOM    197  N   LYS A  22      44.367  -9.746  18.506  1.00 22.40           N  
ATOM    198  CA  LYS A  22      43.848 -11.118  18.491  1.00 23.07           C  
ATOM    199  C   LYS A  22      44.818 -12.103  17.836  1.00 21.10           C  
ATOM    200  O   LYS A  22      45.416 -11.763  16.805  1.00 19.25           O  
ATOM    201  CB  LYS A  22      42.505 -11.170  17.746  1.00 23.45           C  
ATOM    202  CG  LYS A  22      41.323 -10.524  18.496  1.00 25.89           C  
ATOM    203  CD  LYS A  22      40.071 -10.452  17.567  1.00 25.79           C  
ATOM    204  CE  LYS A  22      38.899  -9.770  18.259  1.00 28.16           C  
ATOM    205  NZ  LYS A  22      39.380  -8.549  18.987  1.00 31.56           N  
ATOM    206  N   ASP A  23      44.981 -13.307  18.410  1.00 20.14           N  
ATOM    207  CA  ASP A  23      45.812 -14.307  17.724  1.00 20.25           C  
ATOM    208  C   ASP A  23      45.160 -14.909  16.470  1.00 18.77           C  
ATOM    209  O   ASP A  23      43.941 -15.126  16.415  1.00 17.71           O  
ATOM    210  CB  ASP A  23      46.488 -15.344  18.623  1.00 23.16           C  
ATOM    211  CG  ASP A  23      45.520 -16.174  19.438  1.00 29.21           C  
ATOM    212  OD1 ASP A  23      44.272 -16.048  19.275  1.00 34.75           O  
ATOM    213  OD2 ASP A  23      46.041 -16.953  20.283  1.00 35.83           O  
ATOM    214  N   ILE A  24      45.990 -15.116  15.451  1.00 15.66           N  
ATOM    215  CA  ILE A  24      45.520 -15.627  14.164  1.00 15.57           C  
ATOM    216  C   ILE A  24      46.119 -16.997  13.922  1.00 14.73           C  
ATOM    217  O   ILE A  24      45.423 -17.914  13.509  1.00 15.36           O  
ATOM    218  CB  ILE A  24      45.879 -14.660  13.018  1.00 15.10           C  
ATOM    219  CG1 ILE A  24      45.166 -13.324  13.217  1.00 17.53           C  
ATOM    220  CG2 ILE A  24      45.556 -15.280  11.626  1.00 14.93           C  
ATOM    221  CD1 ILE A  24      45.661 -12.253  12.254  1.00 18.86           C  
ATOM    222  N   PHE A  25      47.416 -17.164  14.186  1.00 13.45           N  
ATOM    223  CA  PHE A  25      48.017 -18.449  13.900  1.00 13.82           C  
ATOM    224  C   PHE A  25      49.220 -18.693  14.782  1.00 14.42           C  
ATOM    225  O   PHE A  25      49.851 -17.745  15.229  1.00 14.13           O  
ATOM    226  CB  PHE A  25      48.412 -18.550  12.409  1.00 14.79           C  
ATOM    227  CG  PHE A  25      48.381 -19.951  11.882  1.00 16.19           C  
ATOM    228  CD1 PHE A  25      47.166 -20.527  11.490  1.00 21.30           C  
ATOM    229  CD2 PHE A  25      49.541 -20.719  11.811  1.00 17.53           C  
ATOM    230  CE1 PHE A  25      47.118 -21.869  11.023  1.00 22.47           C  
ATOM    231  CE2 PHE A  25      49.495 -22.047  11.336  1.00 19.71           C  
ATOM    232  CZ  PHE A  25      48.279 -22.608  10.949  1.00 19.29           C  
ATOM    233  N   ILE A  26      49.530 -19.952  15.037  1.00 13.88           N  
ATOM    234  CA  ILE A  26      50.704 -20.297  15.848  1.00 15.83           C  
ATOM    235  C   ILE A  26      51.473 -21.470  15.200  1.00 16.08           C  
ATOM    236  O   ILE A  26      50.856 -22.375  14.613  1.00 16.44           O  
ATOM    237  CB  ILE A  26      50.277 -20.685  17.284  1.00 16.45           C  
ATOM    238  CG1 ILE A  26      49.362 -19.607  17.905  1.00 17.52           C  
ATOM    239  CG2 ILE A  26      51.519 -20.985  18.186  1.00 17.93           C  
ATOM    240  CD1 ILE A  26      48.560 -20.089  19.138  1.00 19.54           C  
ATOM    241  N   ASP A  27      52.802 -21.469  15.298  1.00 15.72           N  
ATOM    242  CA  ASP A  27      53.588 -22.656  14.921  1.00 16.24           C  
ATOM    243  C   ASP A  27      54.660 -22.855  15.990  1.00 16.23           C  
ATOM    244  O   ASP A  27      54.928 -21.953  16.773  1.00 16.49           O  
ATOM    245  CB  ASP A  27      54.216 -22.465  13.538  1.00 16.47           C  
ATOM    246  CG  ASP A  27      54.359 -23.786  12.719  1.00 19.66           C  
ATOM    247  OD1 ASP A  27      54.509 -23.654  11.488  1.00 17.89           O  
ATOM    248  OD2 ASP A  27      54.377 -24.933  13.264  1.00 21.40           O  
ATOM    249  N   GLN A  28      55.255 -24.030  16.004  1.00 16.77           N  
ATOM    250  CA  GLN A  28      56.152 -24.510  17.059  1.00 19.31           C  
ATOM    251  C   GLN A  28      57.544 -24.750  16.481  1.00 18.55           C  
ATOM    252  O   GLN A  28      57.697 -24.961  15.252  1.00 18.10           O  
ATOM    253  CB  GLN A  28      55.635 -25.844  17.626  1.00 20.12           C  
ATOM    254  CG  GLN A  28      54.394 -25.748  18.517  1.00 27.23           C  
ATOM    255  CD  GLN A  28      53.122 -25.628  17.720  1.00 34.78           C  
ATOM    256  OE1 GLN A  28      53.041 -26.100  16.571  1.00 37.63           O  
ATOM    257  NE2 GLN A  28      52.111 -24.992  18.316  1.00 35.06           N  
ATOM    258  N   SER A  29      58.540 -24.742  17.374  1.00 18.03           N  
ATOM    259  CA  SER A  29      59.939 -25.079  17.061  1.00 18.60           C  
ATOM    260  C   SER A  29      60.529 -24.180  15.961  1.00 17.67           C  
ATOM    261  O   SER A  29      61.123 -24.668  14.989  1.00 17.82           O  
ATOM    262  CB  SER A  29      60.070 -26.542  16.640  1.00 19.36           C  
ATOM    263  OG  SER A  29      59.589 -27.436  17.628  1.00 23.70           O  
ATOM    264  N   VAL A  30      60.376 -22.879  16.136  1.00 15.30           N  
ATOM    265  CA  VAL A  30      60.889 -21.888  15.187  1.00 14.55           C  
ATOM    266  C   VAL A  30      62.130 -21.254  15.809  1.00 15.51           C  
ATOM    267  O   VAL A  30      62.193 -21.073  17.053  1.00 16.32           O  
ATOM    268  CB  VAL A  30      59.792 -20.843  14.868  1.00 14.70           C  
ATOM    269  CG1 VAL A  30      60.350 -19.657  14.079  1.00 13.93           C  
ATOM    270  CG2 VAL A  30      58.633 -21.517  14.113  1.00 13.88           C  
ATOM    271  N   GLY A  31      63.133 -20.988  14.963  1.00 14.77           N  
ATOM    272  CA  GLY A  31      64.333 -20.251  15.352  1.00 14.20           C  
ATOM    273  C   GLY A  31      64.382 -18.941  14.588  1.00 13.94           C  
ATOM    274  O   GLY A  31      63.781 -18.811  13.490  1.00 13.61           O  
ATOM    275  N   LEU A  32      65.099 -17.965  15.146  1.00 12.69           N  
ATOM    276  CA  LEU A  32      65.170 -16.622  14.556  1.00 12.39           C  
ATOM    277  C   LEU A  32      66.511 -16.370  13.914  1.00 13.18           C  
ATOM    278  O   LEU A  32      67.532 -16.895  14.393  1.00 14.11           O  
ATOM    279  CB  LEU A  32      64.899 -15.548  15.618  1.00 12.49           C  
ATOM    280  CG  LEU A  32      63.577 -15.599  16.389  1.00  9.87           C  
ATOM    281  CD1 LEU A  32      63.470 -14.365  17.353  1.00 12.46           C  
ATOM    282  CD2 LEU A  32      62.335 -15.672  15.435  1.00 11.36           C  
ATOM    283  N   TYR A  33      66.494 -15.598  12.830  1.00 13.16           N  
ATOM    284  CA  TYR A  33      67.694 -15.079  12.165  1.00 14.00           C  
ATOM    285  C   TYR A  33      67.617 -13.570  12.099  1.00 14.53           C  
ATOM    286  O   TYR A  33      66.534 -12.975  11.930  1.00 13.57           O  
ATOM    287  CB  TYR A  33      67.797 -15.601  10.724  1.00 13.79           C  
ATOM    288  CG  TYR A  33      68.303 -17.005  10.643  1.00 14.09           C  
ATOM    289  CD1 TYR A  33      69.604 -17.262  10.155  1.00 15.38           C  
ATOM    290  CD2 TYR A  33      67.495 -18.096  11.034  1.00 12.68           C  
ATOM    291  CE1 TYR A  33      70.091 -18.568  10.076  1.00 16.03           C  
ATOM    292  CE2 TYR A  33      67.983 -19.410  10.950  1.00 16.11           C  
ATOM    293  CZ  TYR A  33      69.276 -19.626  10.470  1.00 15.96           C  
ATOM    294  OH  TYR A  33      69.758 -20.909  10.375  1.00 16.16           O  
ATOM    295  N   HIS A  34      68.768 -12.940  12.253  1.00 14.98           N  
ATOM    296  CA  HIS A  34      68.857 -11.529  11.950  1.00 17.16           C  
ATOM    297  C   HIS A  34      69.828 -11.426  10.780  1.00 16.97           C  
ATOM    298  O   HIS A  34      71.014 -11.746  10.928  1.00 17.47           O  
ATOM    299  CB  HIS A  34      69.348 -10.697  13.130  1.00 18.96           C  
ATOM    300  CG  HIS A  34      69.234  -9.222  12.872  1.00 24.85           C  
ATOM    301  ND1 HIS A  34      68.014  -8.600  12.650  1.00 27.92           N  
ATOM    302  CD2 HIS A  34      70.180  -8.265  12.717  1.00 27.68           C  
ATOM    303  CE1 HIS A  34      68.219  -7.320  12.391  1.00 30.21           C  
ATOM    304  NE2 HIS A  34      69.523  -7.092  12.422  1.00 30.32           N  
ATOM    305  N   GLY A  35      69.321 -10.986   9.631  1.00 16.56           N  
ATOM    306  CA  GLY A  35      70.020 -11.150   8.359  1.00 16.90           C  
ATOM    307  C   GLY A  35      70.312 -12.618   8.127  1.00 17.15           C  
ATOM    308  O   GLY A  35      69.450 -13.476   8.362  1.00 15.52           O  
ATOM    309  N   LYS A  36      71.542 -12.924   7.694  1.00 17.94           N  
ATOM    310  CA  LYS A  36      71.938 -14.309   7.445  1.00 20.04           C  
ATOM    311  C   LYS A  36      72.326 -15.095   8.711  1.00 20.68           C  
ATOM    312  O   LYS A  36      72.529 -16.287   8.624  1.00 22.58           O  
ATOM    313  CB  LYS A  36      73.089 -14.385   6.426  1.00 18.83           C  
ATOM    314  CG  LYS A  36      72.849 -13.572   5.170  1.00 19.71           C  
ATOM    315  CD  LYS A  36      74.028 -13.649   4.246  1.00 20.74           C  
ATOM    316  CE  LYS A  36      73.745 -12.906   2.959  1.00 21.88           C  
ATOM    317  NZ  LYS A  36      74.897 -13.019   2.047  1.00 25.16           N  
ATOM    318  N   SER A  37      72.445 -14.444   9.864  1.00 21.40           N  
ATOM    319  CA  SER A  37      72.982 -15.089  11.086  1.00 21.79           C  
ATOM    320  C   SER A  37      71.922 -15.550  12.089  1.00 20.85           C  
ATOM    321  O   SER A  37      70.986 -14.826  12.351  1.00 19.53           O  
ATOM    322  CB  SER A  37      73.862 -14.091  11.830  1.00 22.46           C  
ATOM    323  OG  SER A  37      74.913 -13.665  10.995  1.00 27.58           O  
ATOM    324  N   LYS A  38      72.095 -16.728  12.693  1.00 20.67           N  
ATOM    325  CA  LYS A  38      71.200 -17.141  13.781  1.00 20.92           C  
ATOM    326  C   LYS A  38      71.241 -16.149  14.933  1.00 21.78           C  
ATOM    327  O   LYS A  38      72.328 -15.644  15.283  1.00 21.32           O  
ATOM    328  CB  LYS A  38      71.590 -18.507  14.326  1.00 20.61           C  
ATOM    329  CG  LYS A  38      71.351 -19.614  13.366  1.00 20.81           C  
ATOM    330  CD  LYS A  38      71.724 -20.924  13.989  1.00 23.64           C  
ATOM    331  CE  LYS A  38      71.641 -22.007  12.971  1.00 24.23           C  
ATOM    332  NZ  LYS A  38      71.897 -23.295  13.648  1.00 28.19           N  
ATOM    333  N   ILE A  39      70.069 -15.837  15.487  1.00 21.22           N  
ATOM    334  CA  ILE A  39      70.003 -15.137  16.766  1.00 22.64           C  
ATOM    335  C   ILE A  39      70.262 -16.183  17.854  1.00 23.76           C  
ATOM    336  O   ILE A  39      69.420 -17.040  18.135  1.00 22.31           O  
ATOM    337  CB  ILE A  39      68.665 -14.403  17.034  1.00 22.44           C  
ATOM    338  CG1 ILE A  39      68.412 -13.316  15.979  1.00 21.68           C  
ATOM    339  CG2 ILE A  39      68.674 -13.808  18.475  1.00 23.03           C  
ATOM    340  CD1 ILE A  39      67.097 -12.510  16.122  1.00 23.47           C  
ATOM    341  N   LEU A  40      71.441 -16.084  18.474  1.00 25.75           N  
ATOM    342  CA  LEU A  40      71.875 -17.047  19.489  1.00 27.33           C  
ATOM    343  C   LEU A  40      70.912 -17.016  20.661  1.00 27.06           C  
ATOM    344  O   LEU A  40      70.453 -15.940  21.071  1.00 27.92           O  
ATOM    345  CB  LEU A  40      73.313 -16.731  19.938  1.00 28.31           C  
ATOM    346  CG  LEU A  40      74.371 -16.660  18.830  1.00 31.04           C  
ATOM    347  CD1 LEU A  40      75.740 -16.489  19.453  1.00 33.81           C  
ATOM    348  CD2 LEU A  40      74.337 -17.905  17.891  1.00 31.19           C  
ATOM    349  N   GLN A  41      70.555 -18.193  21.168  1.00 27.03           N  
ATOM    350  CA  GLN A  41      69.621 -18.263  22.303  1.00 27.13           C  
ATOM    351  C   GLN A  41      68.161 -17.915  21.957  1.00 25.29           C  
ATOM    352  O   GLN A  41      67.306 -17.776  22.845  1.00 25.24           O  
ATOM    353  CB  GLN A  41      70.131 -17.401  23.478  1.00 28.02           C  
ATOM    354  CG  GLN A  41      71.537 -17.789  23.951  1.00 32.52           C  
ATOM    355  CD  GLN A  41      71.689 -19.284  24.152  1.00 37.45           C  
ATOM    356  OE1 GLN A  41      70.882 -19.917  24.844  1.00 41.91           O  
ATOM    357  NE2 GLN A  41      72.721 -19.863  23.543  1.00 39.52           N  
ATOM    358  N   ARG A  42      67.864 -17.763  20.664  1.00 23.46           N  
ATOM    359  CA  ARG A  42      66.469 -17.618  20.247  1.00 21.42           C  
ATOM    360  C   ARG A  42      66.217 -18.614  19.122  1.00 20.01           C  
ATOM    361  O   ARG A  42      65.679 -18.262  18.084  1.00 17.29           O  
ATOM    362  CB  ARG A  42      66.161 -16.203  19.756  1.00 21.96           C  
ATOM    363  CG  ARG A  42      66.501 -15.020  20.736  1.00 25.87           C  
ATOM    364  CD  ARG A  42      65.573 -14.963  21.888  1.00 30.71           C  
ATOM    365  NE  ARG A  42      65.979 -13.938  22.857  1.00 35.74           N  
ATOM    366  CZ  ARG A  42      66.956 -14.088  23.763  1.00 38.99           C  
ATOM    367  NH1 ARG A  42      67.650 -15.226  23.855  1.00 39.10           N  
ATOM    368  NH2 ARG A  42      67.235 -13.091  24.606  1.00 40.42           N  
ATOM    369  N   GLN A  43      66.620 -19.851  19.360  1.00 19.31           N  
ATOM    370  CA  GLN A  43      66.599 -20.904  18.364  1.00 19.29           C  
ATOM    371  C   GLN A  43      65.472 -21.944  18.486  1.00 20.00           C  
ATOM    372  O   GLN A  43      65.323 -22.796  17.601  1.00 19.29           O  
ATOM    373  CB  GLN A  43      67.976 -21.575  18.305  1.00 19.07           C  
ATOM    374  CG  GLN A  43      69.029 -20.674  17.635  1.00 17.94           C  
ATOM    375  CD  GLN A  43      68.569 -20.166  16.238  1.00 18.13           C  
ATOM    376  OE1 GLN A  43      68.445 -18.977  16.018  1.00 17.35           O  
ATOM    377  NE2 GLN A  43      68.327 -21.082  15.324  1.00 17.88           N  
ATOM    378  N   ARG A  44      64.671 -21.867  19.552  1.00 19.56           N  
ATOM    379  CA  ARG A  44      63.541 -22.788  19.721  1.00 20.87           C  
ATOM    380  C   ARG A  44      62.442 -22.122  20.538  1.00 19.76           C  
ATOM    381  O   ARG A  44      62.548 -21.947  21.773  1.00 18.31           O  
ATOM    382  CB  ARG A  44      63.980 -24.113  20.342  1.00 21.10           C  
ATOM    383  CG  ARG A  44      62.902 -25.200  20.356  1.00 25.32           C  
ATOM    384  CD  ARG A  44      63.443 -26.496  20.982  1.00 26.31           C  
ATOM    385  NE  ARG A  44      64.620 -26.984  20.239  1.00 38.61           N  
ATOM    386  CZ  ARG A  44      65.890 -26.833  20.624  1.00 42.31           C  
ATOM    387  NH1 ARG A  44      66.184 -26.223  21.778  1.00 43.28           N  
ATOM    388  NH2 ARG A  44      66.873 -27.307  19.852  1.00 42.70           N  
ATOM    389  N   GLY A  45      61.396 -21.739  19.822  1.00 17.50           N  
ATOM    390  CA  GLY A  45      60.256 -21.049  20.380  1.00 18.08           C  
ATOM    391  C   GLY A  45      59.000 -21.295  19.567  1.00 17.78           C  
ATOM    392  O   GLY A  45      59.045 -21.873  18.454  1.00 17.31           O  
ATOM    393  N   ARG A  46      57.874 -20.903  20.133  1.00 17.40           N  
ATOM    394  CA  ARG A  46      56.631 -20.870  19.384  1.00 17.80           C  
ATOM    395  C   ARG A  46      56.539 -19.507  18.716  1.00 17.25           C  
ATOM    396  O   ARG A  46      57.016 -18.486  19.256  1.00 16.24           O  
ATOM    397  CB  ARG A  46      55.425 -21.078  20.308  1.00 18.50           C  
ATOM    398  CG  ARG A  46      55.262 -22.511  20.752  1.00 24.65           C  
ATOM    399  CD  ARG A  46      53.893 -22.694  21.379  1.00 32.31           C  
ATOM    400  NE  ARG A  46      53.835 -21.913  22.604  1.00 40.12           N  
ATOM    401  CZ  ARG A  46      52.732 -21.693  23.315  1.00 44.64           C  
ATOM    402  NH1 ARG A  46      51.555 -22.194  22.919  1.00 45.20           N  
ATOM    403  NH2 ARG A  46      52.820 -20.961  24.422  1.00 45.30           N  
ATOM    404  N   ILE A  47      55.945 -19.485  17.528  1.00 15.54           N  
ATOM    405  CA  ILE A  47      55.769 -18.246  16.816  1.00 15.70           C  
ATOM    406  C   ILE A  47      54.267 -17.974  16.732  1.00 15.76           C  
ATOM    407  O   ILE A  47      53.489 -18.887  16.426  1.00 15.97           O  
ATOM    408  CB  ILE A  47      56.519 -18.264  15.413  1.00 16.27           C  
ATOM    409  CG1 ILE A  47      56.757 -16.848  14.879  1.00 16.37           C  
ATOM    410  CG2 ILE A  47      55.786 -19.124  14.382  1.00 15.64           C  
ATOM    411  CD1 ILE A  47      57.925 -16.110  15.581  1.00 21.21           C  
ATOM    412  N   PHE A  48      53.863 -16.749  17.073  1.00 15.69           N  
ATOM    413  CA  PHE A  48      52.448 -16.338  17.051  1.00 15.96           C  
ATOM    414  C   PHE A  48      52.289 -15.223  16.042  1.00 14.63           C  
ATOM    415  O   PHE A  48      53.064 -14.246  16.059  1.00 15.39           O  
ATOM    416  CB  PHE A  48      51.993 -15.735  18.401  1.00 17.40           C  
ATOM    417  CG  PHE A  48      51.856 -16.711  19.524  1.00 18.74           C  
ATOM    418  CD1 PHE A  48      52.969 -17.378  20.038  1.00 22.26           C  
ATOM    419  CD2 PHE A  48      50.618 -16.936  20.107  1.00 23.19           C  
ATOM    420  CE1 PHE A  48      52.839 -18.285  21.120  1.00 24.24           C  
ATOM    421  CE2 PHE A  48      50.477 -17.840  21.184  1.00 24.35           C  
ATOM    422  CZ  PHE A  48      51.587 -18.504  21.687  1.00 22.41           C  
ATOM    423  N   LEU A  49      51.275 -15.323  15.202  1.00 13.20           N  
ATOM    424  CA  LEU A  49      50.866 -14.219  14.379  1.00 12.32           C  
ATOM    425  C   LEU A  49      49.609 -13.622  15.004  1.00 13.48           C  
ATOM    426  O   LEU A  49      48.626 -14.354  15.284  1.00 12.34           O  
ATOM    427  CB  LEU A  49      50.556 -14.681  12.939  1.00 11.76           C  
ATOM    428  CG  LEU A  49      49.953 -13.589  12.024  1.00 10.33           C  
ATOM    429  CD1 LEU A  49      51.084 -12.627  11.589  1.00  9.74           C  
ATOM    430  CD2 LEU A  49      49.369 -14.291  10.780  1.00  9.24           C  
ATOM    431  N   THR A  50      49.624 -12.305  15.196  1.00 12.69           N  
ATOM    432  CA  THR A  50      48.430 -11.597  15.618  1.00 15.12           C  
ATOM    433  C   THR A  50      48.057 -10.619  14.533  1.00 15.19           C  
ATOM    434  O   THR A  50      48.799 -10.410  13.548  1.00 14.97           O  
ATOM    435  CB  THR A  50      48.597 -10.832  16.986  1.00 15.30           C  
ATOM    436  OG1 THR A  50      49.337  -9.631  16.768  1.00 16.73           O  
ATOM    437  CG2 THR A  50      49.265 -11.673  18.083  1.00 16.83           C  
ATOM    438  N   SER A  51      46.895 -10.002  14.716  1.00 15.80           N  
ATOM    439  CA  SER A  51      46.441  -8.905  13.913  1.00 17.29           C  
ATOM    440  C   SER A  51      47.453  -7.723  13.816  1.00 17.77           C  
ATOM    441  O   SER A  51      47.382  -6.952  12.885  1.00 19.79           O  
ATOM    442  CB  SER A  51      45.077  -8.375  14.468  1.00 17.53           C  
ATOM    443  OG  SER A  51      45.074  -8.242  15.894  1.00 20.61           O  
ATOM    444  N   GLN A  52      48.377  -7.603  14.764  1.00 16.90           N  
ATOM    445  CA  GLN A  52      49.293  -6.468  14.812  1.00 17.50           C  
ATOM    446  C   GLN A  52      50.755  -6.847  14.739  1.00 15.18           C  
ATOM    447  O   GLN A  52      51.573  -6.009  14.386  1.00 15.08           O  
ATOM    448  CB  GLN A  52      49.111  -5.711  16.139  1.00 16.99           C  
ATOM    449  CG  GLN A  52      47.701  -5.139  16.333  1.00 20.52           C  
ATOM    450  CD  GLN A  52      47.580  -4.380  17.638  1.00 21.29           C  
ATOM    451  OE1 GLN A  52      48.575  -3.949  18.202  1.00 25.93           O  
ATOM    452  NE2 GLN A  52      46.349  -4.218  18.123  1.00 25.05           N  
ATOM    453  N   ARG A  53      51.092  -8.061  15.161  1.00 13.81           N  
ATOM    454  CA  ARG A  53      52.504  -8.422  15.443  1.00 13.84           C  
ATOM    455  C   ARG A  53      52.850  -9.848  15.031  1.00 13.09           C  
ATOM    456  O   ARG A  53      51.969 -10.700  14.922  1.00 13.17           O  
ATOM    457  CB  ARG A  53      52.821  -8.274  16.943  1.00 13.33           C  
ATOM    458  CG  ARG A  53      52.798  -6.799  17.432  1.00 15.50           C  
ATOM    459  CD  ARG A  53      53.343  -6.664  18.850  1.00 15.53           C  
ATOM    460  NE  ARG A  53      52.407  -7.188  19.843  1.00 17.78           N  
ATOM    461  CZ  ARG A  53      52.688  -7.280  21.144  1.00 21.56           C  
ATOM    462  NH1 ARG A  53      53.879  -6.909  21.610  1.00 18.99           N  
ATOM    463  NH2 ARG A  53      51.777  -7.758  21.989  1.00 21.73           N  
ATOM    464  N   ILE A  54      54.149 -10.106  14.879  1.00 12.38           N  
ATOM    465  CA  ILE A  54      54.690 -11.454  14.947  1.00 12.79           C  
ATOM    466  C   ILE A  54      55.427 -11.552  16.270  1.00 13.32           C  
ATOM    467  O   ILE A  54      56.250 -10.679  16.606  1.00 13.45           O  
ATOM    468  CB  ILE A  54      55.665 -11.754  13.754  1.00 12.48           C  
ATOM    469  CG1 ILE A  54      54.885 -11.836  12.435  1.00 13.16           C  
ATOM    470  CG2 ILE A  54      56.452 -13.046  14.032  1.00 14.10           C  
ATOM    471  CD1 ILE A  54      55.747 -11.493  11.125  1.00 13.93           C  
ATOM    472  N   ILE A  55      55.148 -12.604  17.023  1.00 13.08           N  
ATOM    473  CA  ILE A  55      55.683 -12.749  18.359  1.00 13.37           C  
ATOM    474  C   ILE A  55      56.412 -14.052  18.524  1.00 13.09           C  
ATOM    475  O   ILE A  55      55.886 -15.110  18.224  1.00 13.32           O  
ATOM    476  CB  ILE A  55      54.557 -12.649  19.414  1.00 13.34           C  
ATOM    477  CG1 ILE A  55      53.904 -11.242  19.393  1.00 14.65           C  
ATOM    478  CG2 ILE A  55      55.092 -13.054  20.834  1.00 12.94           C  
ATOM    479  CD1 ILE A  55      52.570 -11.195  20.171  1.00 15.05           C  
ATOM    480  N   TYR A  56      57.645 -13.982  19.000  1.00 12.04           N  
ATOM    481  CA  TYR A  56      58.421 -15.181  19.311  1.00 12.81           C  
ATOM    482  C   TYR A  56      58.396 -15.444  20.811  1.00 14.37           C  
ATOM    483  O   TYR A  56      58.834 -14.579  21.588  1.00 13.51           O  
ATOM    484  CB  TYR A  56      59.862 -15.015  18.796  1.00 12.95           C  
ATOM    485  CG  TYR A  56      60.830 -16.065  19.291  1.00 13.66           C  
ATOM    486  CD1 TYR A  56      61.045 -17.263  18.570  1.00 14.38           C  
ATOM    487  CD2 TYR A  56      61.524 -15.877  20.491  1.00 16.00           C  
ATOM    488  CE1 TYR A  56      61.916 -18.230  19.048  1.00 15.94           C  
ATOM    489  CE2 TYR A  56      62.398 -16.843  20.973  1.00 15.21           C  
ATOM    490  CZ  TYR A  56      62.583 -18.007  20.242  1.00 15.75           C  
ATOM    491  OH  TYR A  56      63.444 -18.951  20.722  1.00 15.10           O  
ATOM    492  N   ILE A  57      57.909 -16.631  21.204  1.00 15.41           N  
ATOM    493  CA  ILE A  57      57.880 -17.051  22.628  1.00 16.86           C  
ATOM    494  C   ILE A  57      58.944 -18.122  22.871  1.00 16.88           C  
ATOM    495  O   ILE A  57      58.803 -19.280  22.417  1.00 16.39           O  
ATOM    496  CB  ILE A  57      56.475 -17.588  23.080  1.00 16.96           C  
ATOM    497  CG1 ILE A  57      55.357 -16.568  22.808  1.00 18.60           C  
ATOM    498  CG2 ILE A  57      56.511 -18.030  24.555  1.00 17.64           C  
ATOM    499  CD1 ILE A  57      55.565 -15.171  23.450  1.00 22.92           C  
ATOM    500  N   ASP A  58      60.011 -17.739  23.569  1.00 16.57           N  
ATOM    501  CA  ASP A  58      61.115 -18.648  23.842  1.00 18.91           C  
ATOM    502  C   ASP A  58      60.690 -19.895  24.623  1.00 20.37           C  
ATOM    503  O   ASP A  58      59.983 -19.785  25.624  1.00 21.21           O  
ATOM    504  CB  ASP A  58      62.249 -17.899  24.564  1.00 18.92           C  
ATOM    505  CG  ASP A  58      63.542 -18.674  24.542  1.00 21.39           C  
ATOM    506  OD1 ASP A  58      64.052 -18.980  23.425  1.00 20.83           O  
ATOM    507  OD2 ASP A  58      64.027 -19.016  25.649  1.00 22.20           O  
ATOM    508  N   ASP A  59      61.097 -21.083  24.175  1.00 21.93           N  
ATOM    509  CA  ASP A  59      60.702 -22.306  24.868  1.00 24.48           C  
ATOM    510  C   ASP A  59      61.337 -22.368  26.265  1.00 25.40           C  
ATOM    511  O   ASP A  59      60.648 -22.685  27.229  1.00 26.06           O  
ATOM    512  CB  ASP A  59      61.074 -23.562  24.082  1.00 25.41           C  
ATOM    513  CG  ASP A  59      60.067 -23.894  22.960  1.00 29.18           C  
ATOM    514  OD1 ASP A  59      58.979 -23.259  22.846  1.00 32.07           O  
ATOM    515  OD2 ASP A  59      60.371 -24.830  22.191  1.00 33.54           O  
ATOM    516  N   ALA A  60      62.628 -22.042  26.354  1.00 25.37           N  
ATOM    517  CA  ALA A  60      63.410 -22.213  27.577  1.00 26.56           C  
ATOM    518  C   ALA A  60      63.085 -21.135  28.626  1.00 26.73           C  
ATOM    519  O   ALA A  60      62.818 -21.457  29.796  1.00 27.50           O  
ATOM    520  CB  ALA A  60      64.924 -22.245  27.259  1.00 25.83           C  
ATOM    521  N   LYS A  61      63.089 -19.869  28.215  1.00 26.29           N  
ATOM    522  CA  LYS A  61      62.852 -18.761  29.146  1.00 26.29           C  
ATOM    523  C   LYS A  61      61.809 -17.783  28.592  1.00 23.84           C  
ATOM    524  O   LYS A  61      62.171 -16.692  28.138  1.00 22.97           O  
ATOM    525  CB  LYS A  61      64.178 -18.046  29.426  1.00 26.32           C  
ATOM    526  CG  LYS A  61      65.301 -18.962  29.931  1.00 29.26           C  
ATOM    527  CD  LYS A  61      66.636 -18.236  29.948  1.00 30.23           C  
ATOM    528  CE  LYS A  61      67.793 -19.226  30.058  1.00 36.37           C  
ATOM    529  NZ  LYS A  61      69.085 -18.634  29.559  1.00 39.77           N  
ATOM    530  N   PRO A  62      60.517 -18.182  28.601  1.00 22.98           N  
ATOM    531  CA  PRO A  62      59.501 -17.339  27.933  1.00 22.95           C  
ATOM    532  C   PRO A  62      59.330 -15.943  28.518  1.00 22.82           C  
ATOM    533  O   PRO A  62      59.058 -14.998  27.783  1.00 21.64           O  
ATOM    534  CB  PRO A  62      58.207 -18.150  28.043  1.00 22.57           C  
ATOM    535  CG  PRO A  62      58.450 -19.165  29.120  1.00 23.20           C  
ATOM    536  CD  PRO A  62      59.937 -19.423  29.149  1.00 22.67           C  
ATOM    537  N   THR A  63      59.483 -15.808  29.839  1.00 23.82           N  
ATOM    538  CA  THR A  63      59.273 -14.498  30.478  1.00 24.47           C  
ATOM    539  C   THR A  63      60.470 -13.570  30.339  1.00 25.38           C  
ATOM    540  O   THR A  63      60.385 -12.411  30.760  1.00 27.20           O  
ATOM    541  CB  THR A  63      58.959 -14.608  31.998  1.00 24.01           C  
ATOM    542  OG1 THR A  63      60.066 -15.241  32.626  1.00 22.80           O  
ATOM    543  CG2 THR A  63      57.720 -15.427  32.240  1.00 24.72           C  
ATOM    544  N   GLN A  64      61.582 -14.070  29.793  1.00 25.48           N  
ATOM    545  CA  GLN A  64      62.794 -13.268  29.608  1.00 26.26           C  
ATOM    546  C   GLN A  64      63.153 -13.032  28.137  1.00 25.55           C  
ATOM    547  O   GLN A  64      63.553 -11.931  27.746  1.00 25.70           O  
ATOM    548  CB  GLN A  64      63.995 -13.978  30.231  1.00 26.77           C  
ATOM    549  CG  GLN A  64      64.036 -13.979  31.738  1.00 32.02           C  
ATOM    550  CD  GLN A  64      65.268 -14.695  32.235  1.00 37.85           C  
ATOM    551  OE1 GLN A  64      66.392 -14.227  32.028  1.00 41.42           O  
ATOM    552  NE2 GLN A  64      65.073 -15.849  32.872  1.00 40.24           N  
ATOM    553  N   ASN A  65      63.047 -14.092  27.341  1.00 24.54           N  
ATOM    554  CA  ASN A  65      63.634 -14.105  25.993  1.00 23.79           C  
ATOM    555  C   ASN A  65      62.627 -14.060  24.827  1.00 22.21           C  
ATOM    556  O   ASN A  65      62.974 -14.291  23.668  1.00 22.86           O  
ATOM    557  CB  ASN A  65      64.612 -15.274  25.876  1.00 24.37           C  
ATOM    558  CG  ASN A  65      65.830 -15.122  26.818  1.00 27.55           C  
ATOM    559  OD1 ASN A  65      65.998 -14.082  27.457  1.00 32.02           O  
ATOM    560  ND2 ASN A  65      66.668 -16.150  26.896  1.00 28.33           N  
ATOM    561  N   SER A  66      61.396 -13.701  25.134  1.00 20.38           N  
ATOM    562  CA  SER A  66      60.366 -13.494  24.108  1.00 19.33           C  
ATOM    563  C   SER A  66      60.435 -12.110  23.443  1.00 18.95           C  
ATOM    564  O   SER A  66      60.821 -11.096  24.080  1.00 18.12           O  
ATOM    565  CB  SER A  66      58.977 -13.777  24.697  1.00 19.67           C  
ATOM    566  OG  SER A  66      58.949 -15.109  25.187  1.00 18.81           O  
ATOM    567  N   LEU A  67      60.081 -12.074  22.160  1.00 16.91           N  
ATOM    568  CA  LEU A  67      60.249 -10.874  21.317  1.00 16.84           C  
ATOM    569  C   LEU A  67      59.067 -10.632  20.400  1.00 16.27           C  
ATOM    570  O   LEU A  67      58.376 -11.583  20.006  1.00 16.67           O  
ATOM    571  CB  LEU A  67      61.522 -10.986  20.460  1.00 17.66           C  
ATOM    572  CG  LEU A  67      62.895 -11.006  21.142  1.00 18.32           C  
ATOM    573  CD1 LEU A  67      63.962 -11.406  20.127  1.00 20.37           C  
ATOM    574  CD2 LEU A  67      63.187  -9.624  21.791  1.00 18.43           C  
ATOM    575  N   GLY A  68      58.850  -9.377  20.040  1.00 14.38           N  
ATOM    576  CA  GLY A  68      57.783  -8.982  19.151  1.00 15.45           C  
ATOM    577  C   GLY A  68      58.286  -8.104  18.022  1.00 16.12           C  
ATOM    578  O   GLY A  68      59.248  -7.342  18.187  1.00 15.43           O  
ATOM    579  N   LEU A  69      57.644  -8.233  16.870  1.00 15.59           N  
ATOM    580  CA  LEU A  69      57.894  -7.390  15.726  1.00 17.00           C  
ATOM    581  C   LEU A  69      56.571  -6.758  15.278  1.00 15.53           C  
ATOM    582  O   LEU A  69      55.570  -7.474  15.141  1.00 15.70           O  
ATOM    583  CB  LEU A  69      58.446  -8.329  14.603  1.00 16.83           C  
ATOM    584  CG  LEU A  69      59.480  -7.949  13.547  1.00 21.83           C  
ATOM    585  CD1 LEU A  69      60.804  -7.505  14.171  1.00 24.22           C  
ATOM    586  CD2 LEU A  69      59.748  -9.130  12.676  1.00 18.80           C  
ATOM    587  N   GLU A  70      56.523  -5.460  14.995  1.00 15.11           N  
ATOM    588  CA  GLU A  70      55.270  -4.870  14.483  1.00 16.45           C  
ATOM    589  C   GLU A  70      55.073  -5.160  12.997  1.00 16.56           C  
ATOM    590  O   GLU A  70      55.948  -4.865  12.199  1.00 16.90           O  
ATOM    591  CB  GLU A  70      55.209  -3.347  14.659  1.00 16.99           C  
ATOM    592  CG  GLU A  70      55.531  -2.806  16.058  1.00 20.63           C  
ATOM    593  CD  GLU A  70      54.422  -3.025  17.070  1.00 25.59           C  
ATOM    594  OE1 GLU A  70      53.249  -3.269  16.700  1.00 25.19           O  
ATOM    595  OE2 GLU A  70      54.746  -2.951  18.264  1.00 29.61           O  
ATOM    596  N   LEU A  71      53.915  -5.709  12.622  1.00 15.98           N  
ATOM    597  CA  LEU A  71      53.575  -5.848  11.197  1.00 16.46           C  
ATOM    598  C   LEU A  71      53.631  -4.510  10.447  1.00 17.24           C  
ATOM    599  O   LEU A  71      53.977  -4.462   9.269  1.00 16.44           O  
ATOM    600  CB  LEU A  71      52.201  -6.496  11.016  1.00 16.07           C  
ATOM    601  CG  LEU A  71      52.033  -7.943  11.479  1.00 16.84           C  
ATOM    602  CD1 LEU A  71      50.521  -8.334  11.383  1.00 16.43           C  
ATOM    603  CD2 LEU A  71      52.939  -8.912  10.668  1.00 16.32           C  
ATOM    604  N   ASP A  72      53.277  -3.430  11.132  1.00 17.87           N  
ATOM    605  CA  ASP A  72      53.367  -2.083  10.560  1.00 20.43           C  
ATOM    606  C   ASP A  72      54.801  -1.654  10.163  1.00 19.30           C  
ATOM    607  O   ASP A  72      54.959  -0.705   9.430  1.00 20.97           O  
ATOM    608  CB  ASP A  72      52.783  -1.046  11.521  1.00 21.72           C  
ATOM    609  CG  ASP A  72      52.568   0.310  10.837  1.00 29.44           C  
ATOM    610  OD1 ASP A  72      51.690   0.409   9.926  1.00 33.56           O  
ATOM    611  OD2 ASP A  72      53.300   1.269  11.200  1.00 36.36           O  
ATOM    612  N   ASP A  73      55.826  -2.346  10.640  1.00 17.86           N  
ATOM    613  CA  ASP A  73      57.224  -2.035  10.260  1.00 17.01           C  
ATOM    614  C   ASP A  73      57.722  -2.839   9.021  1.00 16.21           C  
ATOM    615  O   ASP A  73      58.878  -2.667   8.561  1.00 15.01           O  
ATOM    616  CB  ASP A  73      58.138  -2.254  11.456  1.00 17.82           C  
ATOM    617  CG  ASP A  73      57.916  -1.203  12.576  1.00 22.32           C  
ATOM    618  OD1 ASP A  73      57.275  -0.154  12.298  1.00 26.84           O  
ATOM    619  OD2 ASP A  73      58.375  -1.445  13.717  1.00 24.59           O  
ATOM    620  N   LEU A  74      56.850  -3.691   8.481  1.00 14.49           N  
ATOM    621  CA  LEU A  74      57.205  -4.580   7.376  1.00 13.90           C  
ATOM    622  C   LEU A  74      56.664  -4.112   6.035  1.00 14.48           C  
ATOM    623  O   LEU A  74      55.579  -3.533   5.944  1.00 14.47           O  
ATOM    624  CB  LEU A  74      56.691  -6.014   7.639  1.00 14.25           C  
ATOM    625  CG  LEU A  74      57.160  -6.766   8.885  1.00 13.11           C  
ATOM    626  CD1 LEU A  74      56.639  -8.232   8.832  1.00 13.92           C  
ATOM    627  CD2 LEU A  74      58.705  -6.746   9.078  1.00 14.13           C  
ATOM    628  N   ALA A  75      57.433  -4.387   4.981  1.00 14.37           N  
ATOM    629  CA  ALA A  75      57.025  -4.126   3.616  1.00 14.17           C  
ATOM    630  C   ALA A  75      56.687  -5.381   2.818  1.00 13.87           C  
ATOM    631  O   ALA A  75      55.736  -5.364   1.994  1.00 12.37           O  
ATOM    632  CB  ALA A  75      58.087  -3.247   2.869  1.00 14.70           C  
ATOM    633  N   TYR A  76      57.440  -6.472   3.036  1.00 13.20           N  
ATOM    634  CA  TYR A  76      57.164  -7.747   2.354  1.00 12.76           C  
ATOM    635  C   TYR A  76      57.512  -8.913   3.252  1.00 13.59           C  
ATOM    636  O   TYR A  76      58.328  -8.797   4.151  1.00 13.20           O  
ATOM    637  CB  TYR A  76      58.021  -7.931   1.069  1.00 11.79           C  
ATOM    638  CG  TYR A  76      58.029  -6.791   0.081  1.00 10.37           C  
ATOM    639  CD1 TYR A  76      57.216  -6.843  -1.058  1.00  9.60           C  
ATOM    640  CD2 TYR A  76      58.857  -5.671   0.262  1.00  9.95           C  
ATOM    641  CE1 TYR A  76      57.196  -5.795  -2.002  1.00 11.32           C  
ATOM    642  CE2 TYR A  76      58.849  -4.604  -0.671  1.00 11.51           C  
ATOM    643  CZ  TYR A  76      58.028  -4.689  -1.808  1.00 10.35           C  
ATOM    644  OH  TYR A  76      58.032  -3.679  -2.735  1.00 10.74           O  
ATOM    645  N   VAL A  77      56.903 -10.063   2.967  1.00 15.43           N  
ATOM    646  CA  VAL A  77      57.364 -11.330   3.498  1.00 16.44           C  
ATOM    647  C   VAL A  77      57.517 -12.272   2.300  1.00 17.49           C  
ATOM    648  O   VAL A  77      56.759 -12.173   1.323  1.00 17.63           O  
ATOM    649  CB  VAL A  77      56.443 -11.908   4.629  1.00 16.96           C  
ATOM    650  CG1 VAL A  77      56.144 -10.868   5.668  1.00 17.14           C  
ATOM    651  CG2 VAL A  77      55.138 -12.422   4.054  1.00 17.60           C  
ATOM    652  N   ASN A  78      58.515 -13.147   2.353  1.00 17.33           N  
ATOM    653  CA  ASN A  78      58.802 -14.094   1.272  1.00 18.64           C  
ATOM    654  C   ASN A  78      59.130 -15.464   1.855  1.00 17.24           C  
ATOM    655  O   ASN A  78      60.012 -15.579   2.676  1.00 15.95           O  
ATOM    656  CB  ASN A  78      59.985 -13.622   0.402  1.00 19.44           C  
ATOM    657  CG  ASN A  78      60.490 -14.711  -0.576  1.00 26.10           C  
ATOM    658  OD1 ASN A  78      59.764 -15.187  -1.485  1.00 33.22           O  
ATOM    659  ND2 ASN A  78      61.749 -15.118  -0.389  1.00 33.52           N  
ATOM    660  N   TYR A  79      58.405 -16.492   1.412  1.00 16.04           N  
ATOM    661  CA  TYR A  79      58.663 -17.881   1.787  1.00 15.94           C  
ATOM    662  C   TYR A  79      59.772 -18.504   0.952  1.00 17.76           C  
ATOM    663  O   TYR A  79      59.740 -18.417  -0.281  1.00 18.99           O  
ATOM    664  CB  TYR A  79      57.383 -18.696   1.587  1.00 14.11           C  
ATOM    665  CG  TYR A  79      57.512 -20.166   1.960  1.00 14.63           C  
ATOM    666  CD1 TYR A  79      57.468 -20.575   3.301  1.00 12.02           C  
ATOM    667  CD2 TYR A  79      57.686 -21.147   0.978  1.00 12.92           C  
ATOM    668  CE1 TYR A  79      57.588 -21.926   3.658  1.00 12.84           C  
ATOM    669  CE2 TYR A  79      57.793 -22.522   1.334  1.00 15.20           C  
ATOM    670  CZ  TYR A  79      57.747 -22.887   2.679  1.00 12.29           C  
ATOM    671  OH  TYR A  79      57.840 -24.206   3.058  1.00 12.86           O  
ATOM    672  N   SER A  80      60.695 -19.203   1.608  1.00 18.51           N  
ATOM    673  CA  SER A  80      61.803 -19.908   0.928  1.00 19.98           C  
ATOM    674  C   SER A  80      61.775 -21.372   1.394  1.00 20.75           C  
ATOM    675  O   SER A  80      61.743 -21.650   2.594  1.00 19.14           O  
ATOM    676  CB  SER A  80      63.124 -19.204   1.253  1.00 21.25           C  
ATOM    677  OG  SER A  80      64.229 -19.854   0.652  1.00 24.37           O  
ATOM    678  N   SER A  81      61.728 -22.323   0.452  1.00 20.81           N  
ATOM    679  CA  SER A  81      61.246 -23.680   0.771  1.00 22.36           C  
ATOM    680  C   SER A  81      62.231 -24.705   1.310  1.00 23.49           C  
ATOM    681  O   SER A  81      61.862 -25.874   1.495  1.00 24.39           O  
ATOM    682  CB  SER A  81      60.586 -24.285  -0.464  1.00 22.85           C  
ATOM    683  OG  SER A  81      61.492 -24.193  -1.552  1.00 27.43           O  
ATOM    684  N   GLY A  82      63.480 -24.307   1.538  1.00 24.78           N  
ATOM    685  CA  GLY A  82      64.426 -25.205   2.202  1.00 25.53           C  
ATOM    686  C   GLY A  82      65.245 -26.048   1.228  1.00 26.42           C  
ATOM    687  O   GLY A  82      65.551 -27.200   1.525  1.00 27.10           O  
ATOM    688  N   PHE A  83      65.585 -25.509   0.057  1.00 26.98           N  
ATOM    689  CA  PHE A  83      66.461 -26.266  -0.839  1.00 27.30           C  
ATOM    690  C   PHE A  83      67.933 -26.263  -0.428  1.00 26.49           C  
ATOM    691  O   PHE A  83      68.550 -27.328  -0.388  1.00 26.36           O  
ATOM    692  CB  PHE A  83      66.354 -25.896  -2.300  1.00 28.88           C  
ATOM    693  CG  PHE A  83      67.014 -26.924  -3.190  1.00 32.79           C  
ATOM    694  CD1 PHE A  83      66.483 -28.219  -3.279  1.00 36.74           C  
ATOM    695  CD2 PHE A  83      68.196 -26.642  -3.859  1.00 34.54           C  
ATOM    696  CE1 PHE A  83      67.109 -29.213  -4.066  1.00 38.70           C  
ATOM    697  CE2 PHE A  83      68.820 -27.617  -4.631  1.00 36.57           C  
ATOM    698  CZ  PHE A  83      68.276 -28.904  -4.732  1.00 35.73           C  
ATOM    699  N   LEU A  84      68.473 -25.072  -0.146  1.00 24.79           N  
ATOM    700  CA  LEU A  84      69.823 -24.919   0.437  1.00 24.60           C  
ATOM    701  C   LEU A  84      69.844 -24.852   1.969  1.00 23.67           C  
ATOM    702  O   LEU A  84      70.880 -25.107   2.604  1.00 23.73           O  
ATOM    703  CB  LEU A  84      70.486 -23.663  -0.101  1.00 24.38           C  
ATOM    704  CG  LEU A  84      70.670 -23.639  -1.615  1.00 26.05           C  
ATOM    705  CD1 LEU A  84      71.511 -22.433  -2.042  1.00 23.23           C  
ATOM    706  CD2 LEU A  84      71.263 -24.985  -2.043  1.00 23.02           C  
ATOM    707  N   THR A  85      68.710 -24.491   2.565  1.00 21.27           N  
ATOM    708  CA  THR A  85      68.647 -24.371   4.008  1.00 19.68           C  
ATOM    709  C   THR A  85      68.072 -25.672   4.582  1.00 19.21           C  
ATOM    710  O   THR A  85      67.218 -26.306   3.947  1.00 18.93           O  
ATOM    711  CB  THR A  85      67.822 -23.140   4.435  1.00 19.45           C  
ATOM    712  OG1 THR A  85      66.491 -23.265   3.952  1.00 17.90           O  
ATOM    713  CG2 THR A  85      68.416 -21.817   3.858  1.00 20.67           C  
ATOM    714  N   ARG A  86      68.554 -26.069   5.757  1.00 18.69           N  
ATOM    715  CA  ARG A  86      68.028 -27.266   6.443  1.00 18.82           C  
ATOM    716  C   ARG A  86      66.515 -27.165   6.648  1.00 17.89           C  
ATOM    717  O   ARG A  86      65.809 -28.137   6.434  1.00 16.53           O  
ATOM    718  CB  ARG A  86      68.700 -27.473   7.797  1.00 19.58           C  
ATOM    719  CG  ARG A  86      70.175 -27.806   7.675  1.00 26.83           C  
ATOM    720  CD  ARG A  86      70.749 -28.342   8.984  1.00 34.58           C  
ATOM    721  NE  ARG A  86      72.207 -28.194   8.980  1.00 39.78           N  
ATOM    722  CZ  ARG A  86      73.040 -28.899   8.215  1.00 41.10           C  
ATOM    723  NH1 ARG A  86      72.577 -29.835   7.380  1.00 42.43           N  
ATOM    724  NH2 ARG A  86      74.347 -28.670   8.291  1.00 41.73           N  
ATOM    725  N   SER A  87      66.038 -25.982   7.059  1.00 16.96           N  
ATOM    726  CA  SER A  87      64.582 -25.746   7.280  1.00 15.18           C  
ATOM    727  C   SER A  87      64.038 -24.709   6.307  1.00 14.18           C  
ATOM    728  O   SER A  87      64.774 -23.814   5.880  1.00 14.30           O  
ATOM    729  CB  SER A  87      64.337 -25.250   8.707  1.00 16.37           C  
ATOM    730  OG  SER A  87      64.919 -26.120   9.650  1.00 16.40           O  
ATOM    731  N   PRO A  88      62.733 -24.800   5.957  1.00 13.09           N  
ATOM    732  CA  PRO A  88      62.144 -23.660   5.212  1.00 13.49           C  
ATOM    733  C   PRO A  88      62.190 -22.364   6.046  1.00 12.61           C  
ATOM    734  O   PRO A  88      62.290 -22.440   7.275  1.00 12.68           O  
ATOM    735  CB  PRO A  88      60.676 -24.081   4.962  1.00 13.59           C  
ATOM    736  CG  PRO A  88      60.549 -25.494   5.406  1.00 13.57           C  
ATOM    737  CD  PRO A  88      61.756 -25.877   6.241  1.00 13.64           C  
ATOM    738  N   ARG A  89      62.141 -21.221   5.381  1.00 12.37           N  
ATOM    739  CA  ARG A  89      62.347 -19.914   6.025  1.00 12.74           C  
ATOM    740  C   ARG A  89      61.260 -18.969   5.577  1.00 13.33           C  
ATOM    741  O   ARG A  89      60.847 -18.953   4.390  1.00 13.09           O  
ATOM    742  CB  ARG A  89      63.684 -19.306   5.589  1.00 13.23           C  
ATOM    743  CG  ARG A  89      64.921 -20.199   5.757  1.00 11.55           C  
ATOM    744  CD  ARG A  89      65.436 -20.176   7.161  1.00 12.80           C  
ATOM    745  NE  ARG A  89      66.685 -20.973   7.281  1.00 13.32           N  
ATOM    746  CZ  ARG A  89      67.928 -20.519   7.120  1.00 14.03           C  
ATOM    747  NH1 ARG A  89      68.163 -19.248   6.809  1.00 13.53           N  
ATOM    748  NH2 ARG A  89      68.964 -21.382   7.233  1.00 14.00           N  
ATOM    749  N   LEU A  90      60.802 -18.147   6.509  1.00 12.26           N  
ATOM    750  CA  LEU A  90      60.011 -16.980   6.129  1.00 12.42           C  
ATOM    751  C   LEU A  90      60.865 -15.707   6.326  1.00 12.31           C  
ATOM    752  O   LEU A  90      61.307 -15.425   7.431  1.00 11.14           O  
ATOM    753  CB  LEU A  90      58.684 -16.917   6.893  1.00 12.35           C  
ATOM    754  CG  LEU A  90      57.763 -15.730   6.517  1.00 11.93           C  
ATOM    755  CD1 LEU A  90      57.232 -15.889   5.076  1.00 11.30           C  
ATOM    756  CD2 LEU A  90      56.594 -15.587   7.499  1.00 13.87           C  
ATOM    757  N   ILE A  91      61.108 -14.986   5.236  1.00 12.40           N  
ATOM    758  CA  ILE A  91      61.992 -13.786   5.224  1.00 12.57           C  
ATOM    759  C   ILE A  91      61.137 -12.528   5.364  1.00 12.65           C  
ATOM    760  O   ILE A  91      60.186 -12.336   4.601  1.00 13.14           O  
ATOM    761  CB  ILE A  91      62.782 -13.685   3.873  1.00 13.81           C  
ATOM    762  CG1 ILE A  91      63.366 -15.029   3.432  1.00 15.16           C  
ATOM    763  CG2 ILE A  91      63.812 -12.516   3.869  1.00 13.04           C  
ATOM    764  CD1 ILE A  91      64.038 -15.772   4.483  1.00 16.22           C  
ATOM    765  N   LEU A  92      61.439 -11.723   6.371  1.00 12.79           N  
ATOM    766  CA  LEU A  92      60.707 -10.461   6.621  1.00 13.69           C  
ATOM    767  C   LEU A  92      61.559  -9.269   6.181  1.00 13.60           C  
ATOM    768  O   LEU A  92      62.671  -9.077   6.702  1.00 14.31           O  
ATOM    769  CB  LEU A  92      60.371 -10.334   8.117  1.00 13.38           C  
ATOM    770  CG  LEU A  92      59.790 -11.605   8.748  1.00 14.97           C  
ATOM    771  CD1 LEU A  92      59.516 -11.386  10.269  1.00 15.01           C  
ATOM    772  CD2 LEU A  92      58.533 -12.023   8.017  1.00 13.90           C  
ATOM    773  N   PHE A  93      60.995  -8.462   5.274  1.00 12.80           N  
ATOM    774  CA  PHE A  93      61.612  -7.217   4.786  1.00 13.25           C  
ATOM    775  C   PHE A  93      61.003  -6.001   5.468  1.00 13.89           C  
ATOM    776  O   PHE A  93      59.761  -5.861   5.485  1.00 12.75           O  
ATOM    777  CB  PHE A  93      61.384  -7.098   3.287  1.00 13.74           C  
ATOM    778  CG  PHE A  93      62.293  -7.945   2.462  1.00 14.73           C  
ATOM    779  CD1 PHE A  93      63.422  -8.535   3.018  1.00 17.12           C  
ATOM    780  CD2 PHE A  93      62.102  -8.028   1.090  1.00 19.44           C  
ATOM    781  CE1 PHE A  93      64.281  -9.267   2.238  1.00 16.84           C  
ATOM    782  CE2 PHE A  93      62.977  -8.764   0.299  1.00 20.13           C  
ATOM    783  CZ  PHE A  93      64.060  -9.382   0.891  1.00 19.54           C  
ATOM    784  N   PHE A  94      61.866  -5.147   6.037  1.00 14.08           N  
ATOM    785  CA  PHE A  94      61.430  -3.919   6.730  1.00 15.64           C  
ATOM    786  C   PHE A  94      61.185  -2.773   5.764  1.00 15.06           C  
ATOM    787  O   PHE A  94      61.788  -2.714   4.701  1.00 14.43           O  
ATOM    788  CB  PHE A  94      62.470  -3.451   7.745  1.00 16.03           C  
ATOM    789  CG  PHE A  94      62.727  -4.424   8.850  1.00 18.67           C  
ATOM    790  CD1 PHE A  94      61.722  -4.731   9.760  1.00 21.55           C  
ATOM    791  CD2 PHE A  94      63.976  -5.010   8.986  1.00 18.98           C  
ATOM    792  CE1 PHE A  94      61.949  -5.644  10.792  1.00 24.33           C  
ATOM    793  CE2 PHE A  94      64.232  -5.924  10.016  1.00 24.42           C  
ATOM    794  CZ  PHE A  94      63.214  -6.248  10.911  1.00 21.86           C  
ATOM    795  N   LYS A  95      60.329  -1.842   6.161  1.00 15.83           N  
ATOM    796  CA  LYS A  95      60.105  -0.626   5.391  1.00 17.65           C  
ATOM    797  C   LYS A  95      61.365   0.261   5.409  1.00 18.96           C  
ATOM    798  O   LYS A  95      61.677   0.920   4.427  1.00 19.66           O  
ATOM    799  CB  LYS A  95      58.933   0.171   5.978  1.00 17.66           C  
ATOM    800  CG  LYS A  95      57.577  -0.446   5.742  1.00 19.21           C  
ATOM    801  CD  LYS A  95      56.522   0.546   6.197  1.00 25.27           C  
ATOM    802  CE  LYS A  95      55.138   0.051   5.907  1.00 27.85           C  
ATOM    803  NZ  LYS A  95      54.188   0.951   6.619  1.00 32.08           N  
ATOM    804  N   ASP A  96      62.083   0.258   6.521  1.00 19.43           N  
ATOM    805  CA  ASP A  96      63.120   1.280   6.749  1.00 21.06           C  
ATOM    806  C   ASP A  96      64.391   0.632   7.337  1.00 20.42           C  
ATOM    807  O   ASP A  96      64.743   0.887   8.497  1.00 21.08           O  
ATOM    808  CB  ASP A  96      62.516   2.368   7.669  1.00 21.92           C  
ATOM    809  CG  ASP A  96      63.402   3.591   7.837  1.00 26.65           C  
ATOM    810  OD1 ASP A  96      64.097   3.988   6.876  1.00 28.04           O  
ATOM    811  OD2 ASP A  96      63.371   4.170   8.958  1.00 31.64           O  
ATOM    812  N   PRO A  97      65.065  -0.257   6.553  1.00 19.22           N  
ATOM    813  CA  PRO A  97      66.265  -0.906   7.066  1.00 18.91           C  
ATOM    814  C   PRO A  97      67.442   0.087   7.122  1.00 20.72           C  
ATOM    815  O   PRO A  97      67.500   0.999   6.304  1.00 19.85           O  
ATOM    816  CB  PRO A  97      66.554  -1.986   6.015  1.00 18.91           C  
ATOM    817  CG  PRO A  97      65.996  -1.460   4.763  1.00 16.70           C  
ATOM    818  CD  PRO A  97      64.746  -0.721   5.187  1.00 18.77           C  
ATOM    819  N   SER A  98      68.350  -0.102   8.074  1.00 21.46           N  
ATOM    820  CA  SER A  98      69.506   0.812   8.239  1.00 23.71           C  
ATOM    821  C   SER A  98      70.572   0.394   7.260  1.00 23.60           C  
ATOM    822  O   SER A  98      71.521   1.134   6.941  1.00 24.05           O  
ATOM    823  CB  SER A  98      70.092   0.676   9.644  1.00 24.25           C  
ATOM    824  OG  SER A  98      69.132   1.023  10.615  1.00 30.41           O  
ATOM    825  N   SER A  99      70.403  -0.827   6.790  1.00 23.39           N  
ATOM    826  CA  SER A  99      71.314  -1.440   5.904  1.00 23.62           C  
ATOM    827  C   SER A  99      70.463  -2.450   5.140  1.00 24.39           C  
ATOM    828  O   SER A  99      69.710  -3.239   5.726  1.00 22.12           O  
ATOM    829  CB  SER A  99      72.386  -2.158   6.729  1.00 24.48           C  
ATOM    830  OG  SER A  99      73.213  -2.908   5.885  1.00 26.62           O  
ATOM    831  N   SER A 252      70.916  -3.135   3.636  1.00 29.67           N  
ATOM    832  CA  SER A 252      70.114  -4.211   3.077  1.00 29.27           C  
ATOM    833  C   SER A 252      70.507  -5.530   3.742  1.00 28.37           C  
ATOM    834  O   SER A 252      69.948  -6.583   3.453  1.00 28.73           O  
ATOM    835  CB  SER A 252      70.286  -4.213   1.571  1.00 30.24           C  
ATOM    836  OG  SER A 252      69.459  -3.201   1.020  1.00 29.65           O  
ATOM    837  N   THR A 253      71.427  -5.454   4.695  1.00 27.04           N  
ATOM    838  CA  THR A 253      71.808  -6.626   5.455  1.00 26.38           C  
ATOM    839  C   THR A 253      70.817  -6.897   6.600  1.00 25.18           C  
ATOM    840  O   THR A 253      70.819  -7.975   7.192  1.00 25.16           O  
ATOM    841  CB  THR A 253      73.267  -6.530   5.985  1.00 27.41           C  
ATOM    842  OG1 THR A 253      73.351  -5.566   7.051  1.00 29.54           O  
ATOM    843  CG2 THR A 253      74.247  -6.155   4.830  1.00 29.06           C  
ATOM    844  N   GLU A 254      69.969  -5.910   6.900  1.00 22.70           N  
ATOM    845  CA  GLU A 254      69.054  -5.977   8.024  1.00 21.63           C  
ATOM    846  C   GLU A 254      67.678  -6.444   7.545  1.00 19.29           C  
ATOM    847  O   GLU A 254      66.911  -5.667   6.958  1.00 19.23           O  
ATOM    848  CB  GLU A 254      68.890  -4.594   8.624  1.00 22.06           C  
ATOM    849  CG  GLU A 254      70.200  -3.942   9.025  1.00 28.59           C  
ATOM    850  CD  GLU A 254      70.302  -3.751  10.501  1.00 35.83           C  
ATOM    851  OE1 GLU A 254      70.168  -2.579  10.925  1.00 39.55           O  
ATOM    852  OE2 GLU A 254      70.498  -4.758  11.231  1.00 38.78           O  
ATOM    853  N   PHE A 255      67.394  -7.706   7.817  1.00 17.81           N  
ATOM    854  CA  PHE A 255      66.075  -8.299   7.606  1.00 15.85           C  
ATOM    855  C   PHE A 255      65.966  -9.430   8.628  1.00 15.25           C  
ATOM    856  O   PHE A 255      66.927  -9.751   9.326  1.00 15.20           O  
ATOM    857  CB  PHE A 255      65.896  -8.825   6.148  1.00 15.63           C  
ATOM    858  CG  PHE A 255      66.964  -9.809   5.718  1.00 14.71           C  
ATOM    859  CD1 PHE A 255      66.785 -11.190   5.874  1.00 15.65           C  
ATOM    860  CD2 PHE A 255      68.132  -9.359   5.110  1.00 16.33           C  
ATOM    861  CE1 PHE A 255      67.773 -12.095   5.473  1.00 15.40           C  
ATOM    862  CE2 PHE A 255      69.117 -10.257   4.720  1.00 15.42           C  
ATOM    863  CZ  PHE A 255      68.931 -11.625   4.879  1.00 14.05           C  
ATOM    864  N   VAL A 256      64.793 -10.035   8.722  1.00 15.40           N  
ATOM    865  CA  VAL A 256      64.607 -11.128   9.671  1.00 15.53           C  
ATOM    866  C   VAL A 256      64.235 -12.409   8.954  1.00 14.13           C  
ATOM    867  O   VAL A 256      63.635 -12.370   7.892  1.00 14.58           O  
ATOM    868  CB  VAL A 256      63.480 -10.789  10.739  1.00 16.92           C  
ATOM    869  CG1 VAL A 256      63.081 -12.076  11.556  1.00 15.67           C  
ATOM    870  CG2 VAL A 256      63.953  -9.659  11.672  1.00 17.68           C  
ATOM    871  N   GLN A 257      64.585 -13.545   9.534  1.00 12.71           N  
ATOM    872  CA  GLN A 257      64.005 -14.824   9.059  1.00 12.76           C  
ATOM    873  C   GLN A 257      63.419 -15.597  10.216  1.00 11.94           C  
ATOM    874  O   GLN A 257      63.979 -15.611  11.319  1.00 12.83           O  
ATOM    875  CB  GLN A 257      65.029 -15.722   8.380  1.00 10.78           C  
ATOM    876  CG  GLN A 257      66.089 -14.996   7.520  1.00 12.46           C  
ATOM    877  CD  GLN A 257      67.057 -15.990   6.907  1.00 15.12           C  
ATOM    878  OE1 GLN A 257      66.624 -16.994   6.320  1.00 15.10           O  
ATOM    879  NE2 GLN A 257      68.374 -15.742   7.069  1.00 13.62           N  
ATOM    880  N   LEU A 258      62.337 -16.310   9.924  1.00 11.10           N  
ATOM    881  CA  LEU A 258      61.785 -17.314  10.815  1.00 11.48           C  
ATOM    882  C   LEU A 258      62.158 -18.675  10.221  1.00 12.32           C  
ATOM    883  O   LEU A 258      61.903 -18.923   9.022  1.00 13.33           O  
ATOM    884  CB  LEU A 258      60.257 -17.176  10.846  1.00 10.30           C  
ATOM    885  CG  LEU A 258      59.746 -15.761  11.130  1.00 12.84           C  
ATOM    886  CD1 LEU A 258      58.179 -15.796  11.180  1.00 14.58           C  
ATOM    887  CD2 LEU A 258      60.309 -15.203  12.431  1.00 13.01           C  
ATOM    888  N   SER A 259      62.743 -19.555  11.019  1.00 10.75           N  
ATOM    889  CA  SER A 259      63.155 -20.831  10.481  1.00 11.57           C  
ATOM    890  C   SER A 259      62.323 -21.958  11.087  1.00 10.73           C  
ATOM    891  O   SER A 259      62.269 -22.109  12.322  1.00 10.38           O  
ATOM    892  CB  SER A 259      64.673 -21.032  10.677  1.00 11.14           C  
ATOM    893  OG  SER A 259      65.081 -22.259  10.076  1.00 13.61           O  
ATOM    894  N   PHE A 260      61.668 -22.747  10.232  1.00 10.00           N  
ATOM    895  CA  PHE A 260      60.683 -23.741  10.716  1.00 11.45           C  
ATOM    896  C   PHE A 260      61.232 -25.160  10.861  1.00 12.54           C  
ATOM    897  O   PHE A 260      61.336 -25.880   9.872  1.00 13.24           O  
ATOM    898  CB  PHE A 260      59.418 -23.762   9.844  1.00  9.88           C  
ATOM    899  CG  PHE A 260      58.707 -22.434   9.760  1.00  9.83           C  
ATOM    900  CD1 PHE A 260      57.666 -22.134  10.654  1.00 11.57           C  
ATOM    901  CD2 PHE A 260      59.077 -21.496   8.818  1.00 11.23           C  
ATOM    902  CE1 PHE A 260      56.998 -20.900  10.605  1.00 10.23           C  
ATOM    903  CE2 PHE A 260      58.395 -20.251   8.736  1.00 13.46           C  
ATOM    904  CZ  PHE A 260      57.365 -19.964   9.647  1.00 13.01           C  
ATOM    905  N   ARG A 261      61.511 -25.597  12.088  1.00 14.27           N  
ATOM    906  CA  ARG A 261      62.216 -26.885  12.277  1.00 16.58           C  
ATOM    907  C   ARG A 261      61.303 -28.109  12.384  1.00 18.30           C  
ATOM    908  O   ARG A 261      61.772 -29.243  12.261  1.00 20.50           O  
ATOM    909  CB  ARG A 261      63.166 -26.848  13.483  1.00 15.96           C  
ATOM    910  CG  ARG A 261      64.529 -26.221  13.198  1.00 15.71           C  
ATOM    911  CD  ARG A 261      64.401 -24.743  12.853  1.00 14.31           C  
ATOM    912  NE  ARG A 261      65.707 -24.103  12.651  1.00 17.37           N  
ATOM    913  CZ  ARG A 261      66.397 -23.430  13.580  1.00 18.23           C  
ATOM    914  NH1 ARG A 261      65.959 -23.350  14.824  1.00 19.04           N  
ATOM    915  NH2 ARG A 261      67.552 -22.857  13.257  1.00 18.71           N  
ATOM    916  N   LYS A 262      60.029 -27.902  12.618  1.00 20.18           N  
ATOM    917  CA  LYS A 262      59.114 -29.029  12.812  1.00 22.34           C  
ATOM    918  C   LYS A 262      57.856 -28.935  11.959  1.00 21.89           C  
ATOM    919  O   LYS A 262      56.909 -29.692  12.169  1.00 23.61           O  
ATOM    920  CB  LYS A 262      58.708 -29.166  14.299  1.00 23.40           C  
ATOM    921  CG  LYS A 262      59.811 -29.710  15.234  1.00 26.57           C  
ATOM    922  CD  LYS A 262      60.481 -30.997  14.773  1.00 30.55           C  
ATOM    923  CE  LYS A 262      61.536 -31.450  15.821  1.00 32.18           C  
ATOM    924  NZ  LYS A 262      62.638 -32.298  15.219  1.00 35.50           N  
ATOM    925  N   SER A 263      57.841 -28.011  11.010  1.00 20.58           N  
ATOM    926  CA  SER A 263      56.719 -27.856  10.055  1.00 18.60           C  
ATOM    927  C   SER A 263      57.290 -27.282   8.772  1.00 16.55           C  
ATOM    928  O   SER A 263      58.432 -26.870   8.755  1.00 15.93           O  
ATOM    929  CB  SER A 263      55.629 -26.936  10.601  1.00 19.13           C  
ATOM    930  OG  SER A 263      56.025 -25.572  10.519  1.00 19.86           O  
ATOM    931  N   ASP A 264      56.516 -27.269   7.685  1.00 15.91           N  
ATOM    932  CA  ASP A 264      57.010 -26.633   6.457  1.00 15.18           C  
ATOM    933  C   ASP A 264      56.800 -25.127   6.503  1.00 13.82           C  
ATOM    934  O   ASP A 264      57.184 -24.419   5.583  1.00 13.84           O  
ATOM    935  CB  ASP A 264      56.328 -27.237   5.213  1.00 15.95           C  
ATOM    936  CG  ASP A 264      54.804 -27.197   5.294  1.00 17.38           C  
ATOM    937  OD1 ASP A 264      54.228 -26.297   5.953  1.00 18.51           O  
ATOM    938  OD2 ASP A 264      54.178 -28.105   4.691  1.00 22.26           O  
ATOM    939  N   GLY A 265      56.169 -24.640   7.575  1.00 12.54           N  
ATOM    940  CA  GLY A 265      55.928 -23.196   7.728  1.00 10.97           C  
ATOM    941  C   GLY A 265      54.943 -22.574   6.736  1.00  9.97           C  
ATOM    942  O   GLY A 265      54.787 -21.372   6.689  1.00  9.58           O  
ATOM    943  N   VAL A 266      54.266 -23.403   5.942  1.00  9.89           N  
ATOM    944  CA  VAL A 266      53.415 -22.882   4.880  1.00  9.81           C  
ATOM    945  C   VAL A 266      52.150 -22.185   5.383  1.00  9.29           C  
ATOM    946  O   VAL A 266      51.826 -21.104   4.928  1.00  9.05           O  
ATOM    947  CB  VAL A 266      53.043 -24.004   3.867  1.00 10.60           C  
ATOM    948  CG1 VAL A 266      51.943 -23.518   2.899  1.00 10.72           C  
ATOM    949  CG2 VAL A 266      54.313 -24.463   3.135  1.00 11.28           C  
ATOM    950  N   LEU A 267      51.405 -22.811   6.270  1.00  9.16           N  
ATOM    951  CA  LEU A 267      50.183 -22.142   6.762  1.00  9.77           C  
ATOM    952  C   LEU A 267      50.502 -20.843   7.529  1.00  9.56           C  
ATOM    953  O   LEU A 267      49.781 -19.853   7.415  1.00  8.24           O  
ATOM    954  CB  LEU A 267      49.391 -23.082   7.659  1.00 10.59           C  
ATOM    955  CG  LEU A 267      48.748 -24.318   6.978  1.00 12.50           C  
ATOM    956  CD1 LEU A 267      48.073 -25.193   8.031  1.00 13.02           C  
ATOM    957  CD2 LEU A 267      47.754 -23.857   5.904  1.00 13.17           C  
ATOM    958  N   PHE A 268      51.581 -20.866   8.310  1.00  9.39           N  
ATOM    959  CA  PHE A 268      52.011 -19.657   9.020  1.00  9.43           C  
ATOM    960  C   PHE A 268      52.365 -18.535   8.057  1.00  9.37           C  
ATOM    961  O   PHE A 268      51.971 -17.376   8.245  1.00  9.81           O  
ATOM    962  CB  PHE A 268      53.169 -19.920   9.975  1.00  8.77           C  
ATOM    963  CG  PHE A 268      53.431 -18.742  10.915  1.00  9.62           C  
ATOM    964  CD1 PHE A 268      52.815 -18.670  12.160  1.00 12.35           C  
ATOM    965  CD2 PHE A 268      54.247 -17.685  10.512  1.00 11.57           C  
ATOM    966  CE1 PHE A 268      53.044 -17.534  13.007  1.00 12.82           C  
ATOM    967  CE2 PHE A 268      54.488 -16.576  11.367  1.00 12.99           C  
ATOM    968  CZ  PHE A 268      53.869 -16.508  12.598  1.00 12.42           C  
ATOM    969  N   SER A 269      53.116 -18.874   7.021  1.00  8.17           N  
ATOM    970  CA  SER A 269      53.553 -17.877   6.050  1.00  8.98           C  
ATOM    971  C   SER A 269      52.368 -17.315   5.281  1.00  9.71           C  
ATOM    972  O   SER A 269      52.291 -16.121   5.054  1.00  9.88           O  
ATOM    973  CB  SER A 269      54.577 -18.467   5.090  1.00  8.06           C  
ATOM    974  OG  SER A 269      55.708 -18.914   5.828  1.00 10.61           O  
ATOM    975  N   GLN A 270      51.450 -18.193   4.868  1.00 10.07           N  
ATOM    976  CA  GLN A 270      50.243 -17.732   4.158  1.00 10.97           C  
ATOM    977  C   GLN A 270      49.397 -16.767   5.018  1.00  9.25           C  
ATOM    978  O   GLN A 270      48.937 -15.718   4.532  1.00 10.00           O  
ATOM    979  CB  GLN A 270      49.405 -18.948   3.721  1.00 11.09           C  
ATOM    980  CG  GLN A 270      50.056 -19.644   2.485  1.00 14.17           C  
ATOM    981  CD  GLN A 270      49.387 -20.972   2.103  1.00 15.37           C  
ATOM    982  OE1 GLN A 270      48.736 -21.620   2.927  1.00 22.59           O  
ATOM    983  NE2 GLN A 270      49.560 -21.381   0.842  1.00 20.24           N  
ATOM    984  N   ALA A 271      49.218 -17.103   6.283  1.00  8.70           N  
ATOM    985  CA  ALA A 271      48.455 -16.260   7.203  1.00  8.91           C  
ATOM    986  C   ALA A 271      49.188 -14.891   7.387  1.00  9.08           C  
ATOM    987  O   ALA A 271      48.573 -13.832   7.424  1.00  8.43           O  
ATOM    988  CB  ALA A 271      48.316 -16.971   8.541  1.00  8.77           C  
ATOM    989  N   THR A 272      50.512 -14.932   7.481  1.00  9.11           N  
ATOM    990  CA  THR A 272      51.312 -13.702   7.659  1.00  9.69           C  
ATOM    991  C   THR A 272      51.216 -12.795   6.425  1.00  9.96           C  
ATOM    992  O   THR A 272      51.049 -11.582   6.562  1.00  9.96           O  
ATOM    993  CB  THR A 272      52.808 -14.034   7.964  1.00  8.86           C  
ATOM    994  OG1 THR A 272      52.890 -14.815   9.173  1.00 10.46           O  
ATOM    995  CG2 THR A 272      53.618 -12.717   8.152  1.00 10.24           C  
ATOM    996  N   GLU A 273      51.308 -13.387   5.232  1.00 11.62           N  
ATOM    997  CA  GLU A 273      51.106 -12.637   3.980  1.00 14.35           C  
ATOM    998  C   GLU A 273      49.765 -11.878   3.982  1.00 13.58           C  
ATOM    999  O   GLU A 273      49.701 -10.698   3.589  1.00 13.47           O  
ATOM   1000  CB  GLU A 273      51.159 -13.570   2.769  1.00 13.65           C  
ATOM   1001  CG  GLU A 273      52.563 -14.066   2.376  1.00 19.03           C  
ATOM   1002  CD  GLU A 273      52.568 -15.107   1.210  1.00 21.81           C  
ATOM   1003  OE1 GLU A 273      51.526 -15.785   0.949  1.00 31.26           O  
ATOM   1004  OE2 GLU A 273      53.659 -15.291   0.592  1.00 31.50           O  
ATOM   1005  N   ARG A 274      48.711 -12.548   4.454  1.00 13.90           N  
ATOM   1006  CA  ARG A 274      47.369 -11.970   4.481  1.00 16.05           C  
ATOM   1007  C   ARG A 274      47.267 -10.848   5.514  1.00 15.01           C  
ATOM   1008  O   ARG A 274      46.694  -9.814   5.202  1.00 14.97           O  
ATOM   1009  CB  ARG A 274      46.307 -13.045   4.748  1.00 15.33           C  
ATOM   1010  CG  ARG A 274      44.857 -12.538   4.682  1.00 18.84           C  
ATOM   1011  CD  ARG A 274      43.834 -13.684   4.678  1.00 21.10           C  
ATOM   1012  NE  ARG A 274      43.863 -14.363   3.383  1.00 32.49           N  
ATOM   1013  CZ  ARG A 274      42.879 -14.363   2.486  1.00 35.47           C  
ATOM   1014  NH1 ARG A 274      41.708 -13.774   2.741  1.00 37.44           N  
ATOM   1015  NH2 ARG A 274      43.065 -14.992   1.333  1.00 37.55           N  
ATOM   1016  N   ALA A 275      47.838 -11.064   6.705  1.00 13.93           N  
ATOM   1017  CA  ALA A 275      47.795 -10.113   7.820  1.00 14.39           C  
ATOM   1018  C   ALA A 275      48.586  -8.851   7.442  1.00 15.06           C  
ATOM   1019  O   ALA A 275      48.093  -7.719   7.625  1.00 14.40           O  
ATOM   1020  CB  ALA A 275      48.330 -10.748   9.100  1.00 14.26           C  
ATOM   1021  N   LEU A 276      49.770  -9.048   6.837  1.00 14.61           N  
ATOM   1022  CA  LEU A 276      50.525  -7.932   6.265  1.00 15.57           C  
ATOM   1023  C   LEU A 276      49.743  -7.167   5.194  1.00 16.55           C  
ATOM   1024  O   LEU A 276      49.633  -5.935   5.250  1.00 16.81           O  
ATOM   1025  CB  LEU A 276      51.890  -8.407   5.695  1.00 14.72           C  
ATOM   1026  CG  LEU A 276      52.742  -7.272   5.106  1.00 16.88           C  
ATOM   1027  CD1 LEU A 276      52.983  -6.151   6.132  1.00 17.04           C  
ATOM   1028  CD2 LEU A 276      54.052  -7.822   4.586  1.00 15.13           C  
ATOM   1029  N   GLU A 277      49.210  -7.869   4.200  1.00 17.62           N  
ATOM   1030  CA  GLU A 277      48.433  -7.198   3.169  1.00 20.12           C  
ATOM   1031  C   GLU A 277      47.251  -6.353   3.732  1.00 20.79           C  
ATOM   1032  O   GLU A 277      47.006  -5.242   3.226  1.00 21.01           O  
ATOM   1033  CB  GLU A 277      47.978  -8.178   2.071  1.00 20.79           C  
ATOM   1034  CG  GLU A 277      47.428  -7.471   0.801  1.00 25.27           C  
ATOM   1035  CD  GLU A 277      48.515  -6.912  -0.146  1.00 28.94           C  
ATOM   1036  OE1 GLU A 277      49.714  -6.787   0.225  1.00 28.40           O  
ATOM   1037  OE2 GLU A 277      48.150  -6.583  -1.292  1.00 29.17           O  
ATOM   1038  N   ASN A 278      46.573  -6.827   4.791  1.00 20.63           N  
ATOM   1039  CA  ASN A 278      45.473  -6.062   5.404  1.00 22.10           C  
ATOM   1040  C   ASN A 278      45.988  -4.714   5.927  1.00 23.19           C  
ATOM   1041  O   ASN A 278      45.293  -3.702   5.849  1.00 23.30           O  
ATOM   1042  CB  ASN A 278      44.806  -6.809   6.582  1.00 21.97           C  
ATOM   1043  CG  ASN A 278      43.999  -8.041   6.143  1.00 24.52           C  
ATOM   1044  OD1 ASN A 278      43.654  -8.196   4.975  1.00 27.42           O  
ATOM   1045  ND2 ASN A 278      43.730  -8.931   7.085  1.00 25.33           N  
ATOM   1046  N   ILE A 279      47.179  -4.723   6.512  1.00 23.23           N  
ATOM   1047  CA  ILE A 279      47.760  -3.486   7.040  1.00 24.89           C  
ATOM   1048  C   ILE A 279      48.201  -2.566   5.898  1.00 25.51           C  
ATOM   1049  O   ILE A 279      47.900  -1.369   5.925  1.00 25.97           O  
ATOM   1050  CB  ILE A 279      48.888  -3.788   7.995  1.00 24.23           C  
ATOM   1051  CG1 ILE A 279      48.283  -4.339   9.284  1.00 26.86           C  
ATOM   1052  CG2 ILE A 279      49.739  -2.535   8.251  1.00 25.45           C  
ATOM   1053  CD1 ILE A 279      49.167  -5.241   9.993  1.00 25.80           C  
ATOM   1054  N   LEU A 280      48.878  -3.123   4.888  1.00 25.27           N  
ATOM   1055  CA  LEU A 280      49.399  -2.322   3.773  1.00 26.61           C  
ATOM   1056  C   LEU A 280      48.323  -1.609   2.990  1.00 28.30           C  
ATOM   1057  O   LEU A 280      48.493  -0.438   2.645  1.00 27.69           O  
ATOM   1058  CB  LEU A 280      50.286  -3.150   2.818  1.00 25.47           C  
ATOM   1059  CG  LEU A 280      51.659  -3.534   3.388  1.00 24.35           C  
ATOM   1060  CD1 LEU A 280      52.440  -4.454   2.409  1.00 22.91           C  
ATOM   1061  CD2 LEU A 280      52.492  -2.294   3.744  1.00 23.25           C  
ATOM   1062  N   THR A 281      47.222  -2.311   2.709  1.00 30.17           N  
ATOM   1063  CA  THR A 281      46.154  -1.777   1.859  1.00 32.39           C  
ATOM   1064  C   THR A 281      45.203  -0.899   2.675  1.00 34.87           C  
ATOM   1065  O   THR A 281      44.421  -0.124   2.112  1.00 35.43           O  
ATOM   1066  CB  THR A 281      45.383  -2.888   1.148  1.00 32.64           C  
ATOM   1067  OG1 THR A 281      44.857  -3.784   2.128  1.00 30.02           O  
ATOM   1068  CG2 THR A 281      46.302  -3.653   0.167  1.00 32.42           C  
ATOM   1069  N   GLU A 282      45.244  -1.122   3.990  1.00 36.68           N  
ATOM   1070  CA  GLU A 282      45.041  -0.150   5.093  1.00 39.21           C  
ATOM   1071  C   GLU A 282      43.894  -0.377   6.059  1.00 39.46           C  
ATOM   1072  O   GLU A 282      44.105  -0.254   7.273  1.00 40.89           O  
ATOM   1073  CB  GLU A 282      45.274   1.356   4.757  1.00 39.76           C  
ATOM   1074  CG  GLU A 282      44.403   2.033   3.712  1.00 43.45           C  
ATOM   1075  CD  GLU A 282      43.009   2.385   4.201  1.00 48.80           C  
ATOM   1076  OE1 GLU A 282      42.385   3.300   3.604  1.00 51.03           O  
ATOM   1077  OE2 GLU A 282      42.523   1.755   5.164  1.00 50.47           O  
TER    1078      GLU A 282                                                      
END
MOLECULE T0446.pdb
ATOM      5  N   GLY     9      65.185 -29.612  12.805  1.00 60.87           N  
ATOM      6  CA  GLY     9      64.461 -29.375  14.061  1.00 59.52           C  
ATOM      7  C   GLY     9      62.984 -29.191  13.759  1.00 57.77           C  
ATOM      8  O   GLY     9      62.643 -28.728  12.672  1.00 57.61           O  
ATOM      9  N   ASN    10      62.114 -29.563  14.705  1.00 55.20           N  
ATOM     10  CA  ASN    10      60.651 -29.470  14.527  1.00 53.29           C  
ATOM     11  C   ASN    10      60.014 -28.305  15.312  1.00 52.05           C  
ATOM     12  O   ASN    10      60.425 -27.996  16.430  1.00 52.82           O  
ATOM     13  CB  ASN    10      59.961 -30.783  14.932  1.00 52.26           C  
ATOM     14  CG  ASN    10      60.368 -31.975  14.048  1.00 53.17           C  
ATOM     15  OD1 ASN    10      60.525 -31.847  12.834  1.00 52.31           O  
ATOM     16  ND2 ASN    10      60.516 -33.139  14.663  1.00 52.23           N  
ATOM     17  N   ALA    11      59.012 -27.666  14.710  1.00 49.77           N  
ATOM     18  CA  ALA    11      58.198 -26.655  15.395  1.00 48.15           C  
ATOM     19  C   ALA    11      56.922 -27.335  15.898  1.00 45.50           C  
ATOM     20  O   ALA    11      56.339 -28.180  15.200  1.00 46.35           O  
ATOM     21  CB  ALA    11      57.864 -25.490  14.458  1.00 45.83           C  
ATOM     22  N   ALA    12      56.518 -26.982  17.115  1.00 42.12           N  
ATOM     23  CA  ALA    12      55.301 -27.490  17.736  1.00 40.00           C  
ATOM     24  C   ALA    12      54.252 -26.375  17.772  1.00 39.55           C  
ATOM     25  O   ALA    12      54.566 -25.236  18.129  1.00 35.98           O  
ATOM     26  CB  ALA    12      55.605 -27.961  19.142  1.00 38.33           C  
ATOM     27  N   GLU    13      53.023 -26.699  17.394  1.00 40.63           N  
ATOM     28  CA  GLU    13      51.913 -25.749  17.482  1.00 42.72           C  
ATOM     29  C   GLU    13      51.523 -25.518  18.950  1.00 42.02           C  
ATOM     30  O   GLU    13      51.506 -26.452  19.742  1.00 42.03           O  
ATOM     31  CB  GLU    13      50.717 -26.254  16.671  1.00 42.21           C  
ATOM     32  CG  GLU    13      49.860 -25.143  16.068  1.00 47.11           C  
ATOM     33  CD  GLU    13      48.729 -25.671  15.169  1.00 49.32           C  
ATOM     34  OE1 GLU    13      48.950 -26.674  14.442  1.00 52.36           O  
ATOM     35  OE2 GLU    13      47.614 -25.083  15.200  1.00 59.57           O  
ATOM     36  N   VAL    14      51.230 -24.268  19.301  1.00 40.63           N  
ATOM     37  CA  VAL    14      50.890 -23.890  20.675  1.00 37.77           C  
ATOM     38  C   VAL    14      49.390 -23.660  20.813  1.00 36.42           C  
ATOM     39  O   VAL    14      48.761 -23.060  19.946  1.00 36.60           O  
ATOM     40  CB  VAL    14      51.644 -22.622  21.110  1.00 38.62           C  
ATOM     41  CG1 VAL    14      51.241 -22.212  22.518  1.00 33.88           C  
ATOM     42  CG2 VAL    14      53.152 -22.846  21.033  1.00 35.50           C  
ATOM     43  N   ASN    15      48.812 -24.153  21.900  1.00 34.06           N  
ATOM     44  CA  ASN    15      47.407 -23.957  22.158  1.00 33.88           C  
ATOM     45  C   ASN    15      47.083 -22.479  22.334  1.00 33.04           C  
ATOM     46  O   ASN    15      47.602 -21.847  23.255  1.00 32.42           O  
ATOM     47  CB  ASN    15      46.994 -24.708  23.418  1.00 35.53           C  
ATOM     48  CG  ASN    15      45.527 -24.540  23.733  1.00 37.44           C  
ATOM     49  OD1 ASN    15      45.120 -23.520  24.243  1.00 37.41           O  
ATOM     50  ND2 ASN    15      44.729 -25.556  23.423  1.00 43.93           N  
ATOM     51  N   LEU    16      46.207 -21.958  21.483  1.00 31.24           N  
ATOM     52  CA  LEU    16      45.931 -20.529  21.429  1.00 33.01           C  
ATOM     53  C   LEU    16      45.005 -20.054  22.541  1.00 32.25           C  
ATOM     54  O   LEU    16      44.996 -18.881  22.845  1.00 32.26           O  
ATOM     55  CB  LEU    16      45.328 -20.148  20.075  1.00 34.27           C  
ATOM     56  CG  LEU    16      46.190 -20.305  18.818  1.00 34.50           C  
ATOM     57  CD1 LEU    16      45.443 -19.732  17.607  1.00 34.58           C  
ATOM     58  CD2 LEU    16      47.568 -19.650  18.992  1.00 33.93           C  
ATOM     59  N   ASP    17      44.236 -20.949  23.151  1.00 32.19           N  
ATOM     60  CA  ASP    17      43.394 -20.576  24.279  1.00 32.48           C  
ATOM     61  C   ASP    17      44.231 -20.282  25.513  1.00 32.65           C  
ATOM     62  O   ASP    17      44.037 -19.269  26.162  1.00 30.88           O  
ATOM     63  CB  ASP    17      42.382 -21.674  24.594  1.00 35.60           C  
ATOM     64  CG  ASP    17      41.437 -21.931  23.455  1.00 35.99           C  
ATOM     65  OD1 ASP    17      40.779 -20.971  23.006  1.00 38.81           O  
ATOM     66  OD2 ASP    17      41.367 -23.092  23.003  1.00 50.00           O  
ATOM     67  N   GLU    18      45.170 -21.165  25.820  1.00 32.04           N  
ATOM     68  CA  GLU    18      46.071 -20.942  26.935  1.00 34.74           C  
ATOM     69  C   GLU    18      46.977 -19.765  26.654  1.00 31.75           C  
ATOM     70  O   GLU    18      47.183 -18.936  27.543  1.00 30.78           O  
ATOM     71  CB  GLU    18      46.900 -22.196  27.222  1.00 34.77           C  
ATOM     72  CG  GLU    18      46.059 -23.376  27.751  1.00 42.03           C  
ATOM     73  CD  GLU    18      46.796 -24.726  27.729  1.00 43.33           C  
ATOM     74  OE1 GLU    18      47.977 -24.782  27.337  1.00 54.77           O  
ATOM     75  OE2 GLU    18      46.183 -25.752  28.110  1.00 57.13           O  
ATOM     76  N   LEU    19      47.485 -19.658  25.420  1.00 30.67           N  
ATOM     77  CA  LEU    19      48.438 -18.570  25.070  1.00 30.07           C  
ATOM     78  C   LEU    19      47.779 -17.220  25.227  1.00 30.04           C  
ATOM     79  O   LEU    19      48.381 -16.277  25.748  1.00 30.43           O  
ATOM     80  CB  LEU    19      48.997 -18.734  23.646  1.00 29.84           C  
ATOM     81  CG  LEU    19      50.144 -17.827  23.208  1.00 29.31           C  
ATOM     82  CD1 LEU    19      51.284 -17.839  24.240  1.00 31.63           C  
ATOM     83  CD2 LEU    19      50.653 -18.189  21.806  1.00 25.27           C  
ATOM     84  N   ALA    20      46.525 -17.150  24.806  1.00 29.97           N  
ATOM     85  CA  ALA    20      45.729 -15.924  24.888  1.00 31.22           C  
ATOM     86  C   ALA    20      45.521 -15.475  26.334  1.00 30.56           C  
ATOM     87  O   ALA    20      45.505 -14.283  26.629  1.00 32.27           O  
ATOM     88  CB  ALA    20      44.375 -16.146  24.203  1.00 30.51           C  
ATOM     89  N   GLN    21      45.343 -16.432  27.233  1.00 31.77           N  
ATOM     90  CA  GLN    21      45.207 -16.143  28.663  1.00 30.90           C  
ATOM     91  C   GLN    21      46.536 -15.649  29.217  1.00 30.39           C  
ATOM     92  O   GLN    21      46.576 -14.712  30.011  1.00 32.04           O  
ATOM     93  CB  GLN    21      44.717 -17.404  29.411  1.00 32.37           C  
ATOM     94  CG  GLN    21      44.695 -17.283  30.920  1.00 42.11           C  
ATOM     95  N   GLU    22      47.636 -16.241  28.772  1.00 29.04           N  
ATOM     96  CA  GLU    22      48.951 -15.875  29.310  1.00 27.71           C  
ATOM     97  C   GLU    22      49.502 -14.569  28.735  1.00 30.62           C  
ATOM     98  O   GLU    22      50.216 -13.818  29.441  1.00 30.38           O  
ATOM     99  CB  GLU    22      49.911 -17.020  29.090  1.00 27.03           C  
ATOM    100  CG  GLU    22      49.492 -18.259  29.869  1.00 33.36           C  
ATOM    101  CD  GLU    22      50.401 -19.423  29.682  1.00 36.56           C  
ATOM    102  OE1 GLU    22      51.620 -19.193  29.452  1.00 42.93           O  
ATOM    103  OE2 GLU    22      49.905 -20.578  29.799  1.00 37.90           O  
ATOM    104  N   LEU    23      49.169 -14.279  27.470  1.00 29.30           N  
ATOM    105  CA  LEU    23      49.631 -13.056  26.825  1.00 29.17           C  
ATOM    106  C   LEU    23      48.642 -11.915  26.932  1.00 30.25           C  
ATOM    107  O   LEU    23      48.992 -10.772  26.663  1.00 32.08           O  
ATOM    108  CB  LEU    23      49.935 -13.315  25.356  1.00 29.09           C  
ATOM    109  CG  LEU    23      51.089 -14.251  25.075  1.00 30.17           C  
ATOM    110  CD1 LEU    23      51.295 -14.407  23.565  1.00 31.18           C  
ATOM    111  CD2 LEU    23      52.365 -13.776  25.805  1.00 27.85           C  
ATOM    112  N   GLY    24      47.408 -12.223  27.309  1.00 30.92           N  
ATOM    113  CA  GLY    24      46.347 -11.247  27.430  1.00 30.54           C  
ATOM    114  C   GLY    24      46.758  -9.901  27.994  1.00 31.61           C  
ATOM    115  O   GLY    24      46.393  -8.876  27.436  1.00 30.61           O  
ATOM    116  N   PRO    25      47.494  -9.889  29.125  1.00 30.78           N  
ATOM    117  CA  PRO    25      47.913  -8.620  29.713  1.00 29.71           C  
ATOM    118  C   PRO    25      48.754  -7.681  28.835  1.00 30.41           C  
ATOM    119  O   PRO    25      48.751  -6.495  29.105  1.00 30.79           O  
ATOM    120  CB  PRO    25      48.729  -9.065  30.930  1.00 29.78           C  
ATOM    121  CG  PRO    25      48.166 -10.377  31.282  1.00 32.86           C  
ATOM    122  CD  PRO    25      47.910 -11.019  29.970  1.00 31.91           C  
ATOM    123  N   ILE    26      49.481  -8.189  27.836  1.00 29.88           N  
ATOM    124  CA  ILE    26      50.311  -7.331  26.939  1.00 27.57           C  
ATOM    125  C   ILE    26      49.696  -7.214  25.528  1.00 29.15           C  
ATOM    126  O   ILE    26      50.237  -6.558  24.634  1.00 29.64           O  
ATOM    127  CB  ILE    26      51.795  -7.772  26.920  1.00 27.40           C  
ATOM    128  CG1 ILE    26      52.030  -9.205  26.461  1.00 28.86           C  
ATOM    129  CG2 ILE    26      52.382  -7.701  28.367  1.00 27.44           C  
ATOM    130  CD1 ILE    26      51.852  -9.499  24.971  1.00 34.86           C  
ATOM    131  N   MET    27      48.551  -7.848  25.344  1.00 31.06           N  
ATOM    132  CA  MET    27      47.818  -7.785  24.090  1.00 31.64           C  
ATOM    133  C   MET    27      46.949  -6.543  24.019  1.00 29.78           C  
ATOM    134  O   MET    27      46.490  -6.026  25.053  1.00 29.97           O  
ATOM    135  CB  MET    27      46.958  -9.038  23.926  1.00 30.84           C  
ATOM    136  CG  MET    27      47.764 -10.254  23.491  1.00 32.59           C  
ATOM    137  SD  MET    27      46.672 -11.860  23.482  0.75 35.14          SE  
ATOM    138  CE  MET    27      45.480 -11.416  21.918  1.00 32.37           C  
ATOM    139  N   GLY    28      46.702  -6.069  22.799  1.00 28.32           N  
ATOM    140  CA  GLY    28      45.767  -4.966  22.580  1.00 29.27           C  
ATOM    141  C   GLY    28      44.343  -5.406  22.889  1.00 31.94           C  
ATOM    142  O   GLY    28      44.034  -6.593  22.801  1.00 32.50           O  
ATOM    143  N   ASP    29      43.478  -4.449  23.232  1.00 32.77           N  
ATOM    144  CA  ASP    29      42.073  -4.713  23.559  1.00 34.58           C  
ATOM    145  C   ASP    29      41.351  -5.497  22.450  1.00 35.87           C  
ATOM    146  O   ASP    29      40.587  -6.400  22.741  1.00 39.58           O  
ATOM    147  CB  ASP    29      41.286  -3.411  23.802  1.00 34.46           C  
ATOM    148  CG  ASP    29      41.745  -2.633  25.038  1.00 37.07           C  
ATOM    149  OD1 ASP    29      42.465  -3.173  25.898  1.00 37.61           O  
ATOM    150  OD2 ASP    29      41.381  -1.434  25.124  1.00 44.68           O  
ATOM    151  N   ASN    30      41.580  -5.136  21.193  1.00 35.57           N  
ATOM    152  CA  ASN    30      40.959  -5.818  20.047  1.00 37.83           C  
ATOM    153  C   ASN    30      41.907  -6.777  19.279  1.00 36.99           C  
ATOM    154  O   ASN    30      41.725  -7.048  18.082  1.00 37.90           O  
ATOM    155  CB  ASN    30      40.408  -4.760  19.085  1.00 40.16           C  
ATOM    156  CG  ASN    30      39.472  -3.749  19.782  1.00 50.83           C  
ATOM    157  OD1 ASN    30      38.693  -4.105  20.683  1.00 53.38           O  
ATOM    158  ND2 ASN    30      39.556  -2.484  19.364  1.00 57.62           N  
ATOM    159  N   GLU    31      42.917  -7.298  19.973  1.00 33.17           N  
ATOM    160  CA  GLU    31      43.866  -8.192  19.356  1.00 30.29           C  
ATOM    161  C   GLU    31      43.462  -9.640  19.573  1.00 29.50           C  
ATOM    162  O   GLU    31      43.000 -10.022  20.652  1.00 27.97           O  
ATOM    163  CB  GLU    31      45.260  -7.965  19.936  1.00 28.92           C  
ATOM    164  CG  GLU    31      46.361  -8.680  19.151  1.00 28.18           C  
ATOM    165  CD  GLU    31      47.734  -8.228  19.562  1.00 28.59           C  
ATOM    166  OE1 GLU    31      47.887  -7.721  20.712  1.00 28.28           O  
ATOM    167  OE2 GLU    31      48.671  -8.396  18.748  1.00 30.08           O  
ATOM    168  N   GLN    32      43.663 -10.442  18.536  1.00 29.95           N  
ATOM    169  CA  GLN    32      43.384 -11.871  18.580  1.00 30.19           C  
ATOM    170  C   GLN    32      44.564 -12.658  18.060  1.00 29.38           C  
ATOM    171  O   GLN    32      45.280 -12.223  17.161  1.00 27.54           O  
ATOM    172  CB  GLN    32      42.156 -12.191  17.749  1.00 29.37           C  
ATOM    173  CG  GLN    32      40.886 -11.656  18.349  1.00 38.86           C  
ATOM    174  CD  GLN    32      39.686 -12.111  17.575  1.00 48.30           C  
ATOM    175  OE1 GLN    32      39.096 -11.329  16.829  1.00 53.49           O  
ATOM    176  NE2 GLN    32      39.339 -13.400  17.703  1.00 44.10           N  
ATOM    177  N   LEU    33      44.745 -13.847  18.626  1.00 30.24           N  
ATOM    178  CA  LEU    33      45.794 -14.753  18.184  1.00 30.31           C  
ATOM    179  C   LEU    33      45.333 -15.563  16.985  1.00 29.00           C  
ATOM    180  O   LEU    33      44.192 -16.012  16.938  1.00 28.70           O  
ATOM    181  CB  LEU    33      46.199 -15.677  19.328  1.00 29.81           C  
ATOM    182  CG  LEU    33      46.748 -14.978  20.574  1.00 32.58           C  
ATOM    183  CD1 LEU    33      47.196 -16.058  21.500  1.00 28.01           C  
ATOM    184  CD2 LEU    33      47.890 -14.036  20.289  1.00 31.90           C  
ATOM    185  N   ALA    34      46.197 -15.717  15.991  1.00 27.96           N  
ATOM    186  CA  ALA    34      45.836 -16.491  14.792  1.00 30.62           C  
ATOM    187  C   ALA    34      46.559 -17.833  14.765  1.00 30.42           C  
ATOM    188  O   ALA    34      46.006 -18.860  14.353  1.00 28.34           O  
ATOM    189  CB  ALA    34      46.123 -15.678  13.473  1.00 28.64           C  
ATOM    190  N   LEU    35      47.805 -17.819  15.205  1.00 29.05           N  
ATOM    191  CA  LEU    35      48.680 -18.949  15.009  1.00 29.50           C  
ATOM    192  C   LEU    35      49.915 -18.789  15.876  1.00 28.92           C  
ATOM    193  O   LEU    35      50.457 -17.688  15.998  1.00 27.72           O  
ATOM    194  CB  LEU    35      49.077 -18.981  13.542  1.00 31.93           C  
ATOM    195  CG  LEU    35      49.742 -20.189  12.917  1.00 35.04           C  
ATOM    196  CD1 LEU    35      48.962 -21.506  13.182  1.00 38.57           C  
ATOM    197  CD2 LEU    35      49.850 -19.879  11.433  1.00 36.70           C  
ATOM    198  N   ALA    36      50.387 -19.888  16.457  1.00 26.00           N  
ATOM    199  CA  ALA    36      51.602 -19.829  17.208  1.00 26.36           C  
ATOM    200  C   ALA    36      52.398 -21.115  17.200  1.00 26.82           C  
ATOM    201  O   ALA    36      51.850 -22.198  17.333  1.00 25.24           O  
ATOM    202  CB  ALA    36      51.327 -19.382  18.648  1.00 25.51           C  
ATOM    203  N   TYR    37      53.718 -20.956  17.077  1.00 26.47           N  
ATOM    204  CA  TYR    37      54.626 -22.089  17.064  1.00 27.81           C  
ATOM    205  C   TYR    37      55.699 -21.936  18.146  1.00 28.83           C  
ATOM    206  O   TYR    37      56.197 -20.845  18.417  1.00 28.58           O  
ATOM    207  CB  TYR    37      55.281 -22.242  15.691  1.00 28.27           C  
ATOM    208  CG  TYR    37      54.308 -22.558  14.585  1.00 28.64           C  
ATOM    209  CD1 TYR    37      53.787 -23.844  14.442  1.00 30.62           C  
ATOM    210  CD2 TYR    37      53.887 -21.578  13.688  1.00 31.83           C  
ATOM    211  CE1 TYR    37      52.866 -24.148  13.426  1.00 30.92           C  
ATOM    212  CE2 TYR    37      52.970 -21.886  12.650  1.00 32.26           C  
ATOM    213  CZ  TYR    37      52.467 -23.160  12.540  1.00 31.17           C  
ATOM    214  OH  TYR    37      51.557 -23.480  11.544  1.00 37.96           O  
ATOM    215  N   ARG    38      56.061 -23.057  18.748  1.00 29.59           N  
ATOM    216  CA  ARG    38      57.211 -23.114  19.624  1.00 31.93           C  
ATOM    217  C   ARG    38      58.388 -23.872  18.988  1.00 32.07           C  
ATOM    218  O   ARG    38      58.234 -24.897  18.322  1.00 32.21           O  
ATOM    219  CB  ARG    38      56.822 -23.759  20.946  1.00 33.38           C  
ATOM    220  CG  ARG    38      57.843 -23.520  22.054  1.00 39.14           C  
ATOM    221  CD  ARG    38      57.762 -24.582  23.122  1.00 48.81           C  
ATOM    222  NE  ARG    38      56.793 -24.280  24.161  1.00 51.66           N  
ATOM    223  CZ  ARG    38      55.529 -24.684  24.163  1.00 55.61           C  
ATOM    224  NH1 ARG    38      55.039 -25.411  23.159  1.00 59.48           N  
ATOM    225  NH2 ARG    38      54.751 -24.347  25.181  1.00 52.27           N  
ATOM    226  N   VAL    39      59.579 -23.348  19.184  1.00 32.67           N  
ATOM    227  CA  VAL    39      60.788 -24.084  18.841  1.00 33.79           C  
ATOM    228  C   VAL    39      61.618 -24.110  20.121  1.00 34.37           C  
ATOM    229  O   VAL    39      62.196 -23.097  20.514  1.00 35.08           O  
ATOM    230  CB  VAL    39      61.557 -23.468  17.631  1.00 32.80           C  
ATOM    231  CG1 VAL    39      62.871 -24.228  17.388  1.00 33.25           C  
ATOM    232  CG2 VAL    39      60.697 -23.525  16.386  1.00 35.00           C  
ATOM    233  N   ILE    40      61.613 -25.265  20.788  1.00 34.65           N  
ATOM    234  CA  ILE    40      62.264 -25.452  22.095  1.00 36.62           C  
ATOM    235  C   ILE    40      61.657 -24.485  23.132  1.00 34.68           C  
ATOM    236  O   ILE    40      60.539 -24.701  23.582  1.00 34.13           O  
ATOM    237  CB  ILE    40      63.824 -25.387  22.019  1.00 38.36           C  
ATOM    238  CG1 ILE    40      64.365 -26.358  20.954  1.00 43.53           C  
ATOM    239  CG2 ILE    40      64.429 -25.782  23.363  1.00 40.40           C  
ATOM    240  CD1 ILE    40      65.763 -25.997  20.421  1.00 40.40           C  
ATOM    241  N   ARG    41      62.357 -23.419  23.507  1.00 33.68           N  
ATOM    242  CA  ARG    41      61.806 -22.442  24.463  1.00 34.26           C  
ATOM    243  C   ARG    41      61.242 -21.171  23.802  1.00 32.54           C  
ATOM    244  O   ARG    41      60.541 -20.393  24.445  1.00 34.61           O  
ATOM    245  CB  ARG    41      62.879 -21.980  25.436  1.00 34.70           C  
ATOM    246  CG  ARG    41      63.597 -23.055  26.161  1.00 37.86           C  
ATOM    247  CD  ARG    41      64.516 -22.440  27.219  1.00 40.35           C  
ATOM    248  NE  ARG    41      65.529 -21.523  26.666  1.00 39.77           N  
ATOM    249  CZ  ARG    41      66.724 -21.315  27.228  1.00 39.80           C  
ATOM    250  NH1 ARG    41      67.050 -21.929  28.361  1.00 35.97           N  
ATOM    251  NH2 ARG    41      67.594 -20.488  26.670  1.00 31.93           N  
ATOM    252  N   ASP    42      61.585 -20.951  22.545  1.00 29.33           N  
ATOM    253  CA  ASP    42      61.232 -19.738  21.831  1.00 30.54           C  
ATOM    254  C   ASP    42      59.881 -19.918  21.142  1.00 30.37           C  
ATOM    255  O   ASP    42      59.463 -21.036  20.858  1.00 30.57           O  
ATOM    256  CB  ASP    42      62.319 -19.405  20.805  1.00 29.08           C  
ATOM    257  CG  ASP    42      63.675 -19.131  21.445  1.00 35.53           C  
ATOM    258  OD1 ASP    42      63.723 -18.839  22.665  1.00 33.19           O  
ATOM    259  OD2 ASP    42      64.705 -19.209  20.729  1.00 40.83           O  
ATOM    260  N   MET    43      59.199 -18.806  20.902  1.00 29.53           N  
ATOM    261  CA  MET    43      57.899 -18.801  20.272  1.00 33.10           C  
ATOM    262  C   MET    43      57.786 -17.741  19.205  1.00 29.59           C  
ATOM    263  O   MET    43      58.364 -16.654  19.304  1.00 31.23           O  
ATOM    264  CB  MET    43      56.815 -18.561  21.301  1.00 31.88           C  
ATOM    265  CG  MET    43      56.082 -19.773  21.698  1.00 41.39           C  
ATOM    266  SD  MET    43      54.583 -19.260  22.789  0.75 44.15          SE  
ATOM    267  CE  MET    43      54.929 -20.493  24.116  1.00 39.34           C  
ATOM    268  N   PHE    44      57.042 -18.095  18.167  1.00 29.00           N  
ATOM    269  CA  PHE    44      56.722 -17.213  17.071  1.00 28.77           C  
ATOM    270  C   PHE    44      55.190 -17.112  17.021  1.00 29.74           C  
ATOM    271  O   PHE    44      54.499 -18.098  16.729  1.00 30.01           O  
ATOM    272  CB  PHE    44      57.282 -17.836  15.807  1.00 30.56           C  
ATOM    273  CG  PHE    44      57.484 -16.877  14.696  1.00 32.68           C  
ATOM    274  CD1 PHE    44      56.436 -16.470  13.921  1.00 40.05           C  
ATOM    275  CD2 PHE    44      58.737 -16.371  14.427  1.00 39.89           C  
ATOM    276  CE1 PHE    44      56.629 -15.576  12.869  1.00 38.52           C  
ATOM    277  CE2 PHE    44      58.931 -15.475  13.376  1.00 38.67           C  
ATOM    278  CZ  PHE    44      57.865 -15.098  12.592  1.00 35.49           C  
ATOM    279  N   VAL    45      54.657 -15.937  17.355  1.00 27.56           N  
ATOM    280  CA  VAL    45      53.215 -15.790  17.522  1.00 28.26           C  
ATOM    281  C   VAL    45      52.675 -14.862  16.445  1.00 27.06           C  
ATOM    282  O   VAL    45      53.233 -13.789  16.221  1.00 27.80           O  
ATOM    283  CB  VAL    45      52.890 -15.282  18.925  1.00 27.14           C  
ATOM    284  CG1 VAL    45      51.361 -15.110  19.124  1.00 23.97           C  
ATOM    285  CG2 VAL    45      53.477 -16.246  19.943  1.00 24.77           C  
ATOM    286  N   PHE    46      51.654 -15.322  15.738  1.00 25.28           N  
ATOM    287  CA  PHE    46      50.933 -14.480  14.779  1.00 26.22           C  
ATOM    288  C   PHE    46      49.657 -14.017  15.411  1.00 25.97           C  
ATOM    289  O   PHE    46      48.792 -14.832  15.732  1.00 24.46           O  
ATOM    290  CB  PHE    46      50.565 -15.239  13.507  1.00 25.83           C  
ATOM    291  CG  PHE    46      51.729 -15.729  12.736  1.00 26.44           C  
ATOM    292  CD1 PHE    46      52.428 -16.870  13.152  1.00 33.54           C  
ATOM    293  CD2 PHE    46      52.122 -15.083  11.572  1.00 31.14           C  
ATOM    294  CE1 PHE    46      53.521 -17.335  12.424  1.00 31.61           C  
ATOM    295  CE2 PHE    46      53.214 -15.538  10.832  1.00 30.46           C  
ATOM    296  CZ  PHE    46      53.908 -16.657  11.251  1.00 32.65           C  
ATOM    297  N   THR    47      49.525 -12.711  15.596  1.00 26.48           N  
ATOM    298  CA  THR    47      48.247 -12.146  15.980  1.00 25.78           C  
ATOM    299  C   THR    47      47.572 -11.540  14.737  1.00 26.06           C  
ATOM    300  O   THR    47      48.073 -11.664  13.619  1.00 25.84           O  
ATOM    301  CB  THR    47      48.401 -11.146  17.110  1.00 24.21           C  
ATOM    302  OG1 THR    47      48.626  -9.819  16.579  1.00 24.94           O  
ATOM    303  CG2 THR    47      49.514 -11.595  18.070  1.00 22.98           C  
ATOM    304  N   ASN    48      46.414 -10.923  14.908  1.00 27.66           N  
ATOM    305  CA  ASN    48      45.837 -10.172  13.790  1.00 28.00           C  
ATOM    306  C   ASN    48      46.465  -8.771  13.558  1.00 28.75           C  
ATOM    307  O   ASN    48      46.083  -8.081  12.625  1.00 27.02           O  
ATOM    308  CB  ASN    48      44.310 -10.085  13.891  1.00 27.80           C  
ATOM    309  CG  ASN    48      43.834  -9.365  15.101  1.00 30.65           C  
ATOM    310  OD1 ASN    48      44.560  -9.170  16.079  1.00 27.46           O  
ATOM    311  ND2 ASN    48      42.582  -8.966  15.058  1.00 32.05           N  
ATOM    312  N   LYS    49      47.414  -8.373  14.401  1.00 29.97           N  
ATOM    313  CA  LYS    49      48.050  -7.044  14.362  1.00 29.05           C  
ATOM    314  C   LYS    49      49.577  -7.072  14.225  1.00 27.69           C  
ATOM    315  O   LYS    49      50.189  -6.095  13.795  1.00 25.55           O  
ATOM    316  CB  LYS    49      47.745  -6.312  15.651  1.00 29.91           C  
ATOM    317  CG  LYS    49      46.293  -6.201  16.012  1.00 32.58           C  
ATOM    318  CD  LYS    49      45.605  -5.135  15.243  1.00 40.52           C  
ATOM    319  CE  LYS    49      44.240  -4.850  15.839  1.00 46.49           C  
ATOM    320  NZ  LYS    49      43.305  -4.508  14.762  1.00 47.89           N  
ATOM    321  N   ARG    50      50.196  -8.159  14.650  1.00 25.39           N  
ATOM    322  CA  ARG    50      51.658  -8.219  14.705  1.00 25.08           C  
ATOM    323  C   ARG    50      52.156  -9.637  14.821  1.00 24.78           C  
ATOM    324  O   ARG    50      51.416 -10.546  15.162  1.00 24.93           O  
ATOM    325  CB  ARG    50      52.176  -7.433  15.933  1.00 24.93           C  
ATOM    326  CG  ARG    50      51.571  -7.928  17.244  1.00 23.01           C  
ATOM    327  CD  ARG    50      52.229  -7.387  18.526  1.00 25.97           C  
ATOM    328  NE  ARG    50      51.227  -7.423  19.606  1.00 25.66           N  
ATOM    329  CZ  ARG    50      51.399  -6.963  20.839  1.00 26.42           C  
ATOM    330  NH1 ARG    50      52.565  -6.453  21.241  1.00 27.11           N  
ATOM    331  NH2 ARG    50      50.387  -7.018  21.699  1.00 26.62           N  
ATOM    332  N   LEU    51      53.451  -9.807  14.600  1.00 26.95           N  
ATOM    333  CA  LEU    51      54.146 -10.970  15.100  1.00 27.04           C  
ATOM    334  C   LEU    51      54.712 -10.597  16.461  1.00 29.78           C  
ATOM    335  O   LEU    51      55.170  -9.460  16.658  1.00 30.41           O  
ATOM    336  CB  LEU    51      55.282 -11.370  14.186  1.00 27.54           C  
ATOM    337  CG  LEU    51      54.998 -11.394  12.686  1.00 29.34           C  
ATOM    338  CD1 LEU    51      56.323 -11.607  11.956  1.00 30.99           C  
ATOM    339  CD2 LEU    51      53.980 -12.453  12.310  1.00 26.66           C  
ATOM    340  N   ILE    52      54.661 -11.547  17.392  1.00 27.68           N  
ATOM    341  CA  ILE    52      55.383 -11.477  18.649  1.00 27.58           C  
ATOM    342  C   ILE    52      56.458 -12.570  18.624  1.00 30.30           C  
ATOM    343  O   ILE    52      56.167 -13.772  18.457  1.00 28.72           O  
ATOM    344  CB  ILE    52      54.457 -11.600  19.874  1.00 27.65           C  
ATOM    345  CG1 ILE    52      53.316 -10.591  19.780  1.00 27.80           C  
ATOM    346  CG2 ILE    52      55.258 -11.341  21.209  1.00 28.50           C  
ATOM    347  CD1 ILE    52      52.186 -10.811  20.826  1.00 30.99           C  
ATOM    348  N   LEU    53      57.715 -12.153  18.732  1.00 29.54           N  
ATOM    349  CA  LEU    53      58.807 -13.091  18.746  1.00 31.22           C  
ATOM    350  C   LEU    53      59.322 -13.140  20.175  1.00 29.24           C  
ATOM    351  O   LEU    53      59.818 -12.145  20.702  1.00 27.89           O  
ATOM    352  CB  LEU    53      59.911 -12.694  17.757  1.00 33.84           C  
ATOM    353  CG  LEU    53      59.534 -12.203  16.352  1.00 38.88           C  
ATOM    354  CD1 LEU    53      60.751 -12.304  15.464  1.00 47.75           C  
ATOM    355  CD2 LEU    53      58.375 -12.968  15.755  1.00 44.16           C  
ATOM    356  N   ILE    54      59.141 -14.292  20.806  1.00 29.19           N  
ATOM    357  CA  ILE    54      59.549 -14.519  22.195  1.00 28.78           C  
ATOM    358  C   ILE    54      60.821 -15.358  22.243  1.00 29.78           C  
ATOM    359  O   ILE    54      60.788 -16.562  21.961  1.00 29.99           O  
ATOM    360  CB  ILE    54      58.442 -15.232  22.980  1.00 29.40           C  
ATOM    361  CG1 ILE    54      57.138 -14.418  22.910  1.00 27.48           C  
ATOM    362  CG2 ILE    54      58.904 -15.475  24.437  1.00 29.29           C  
ATOM    363  CD1 ILE    54      55.941 -15.044  23.609  1.00 28.12           C  
ATOM    364  N   ASP    55      61.939 -14.719  22.571  1.00 27.43           N  
ATOM    365  CA  ASP    55      63.209 -15.395  22.601  0.50 28.25           C  
ATOM    367  C   ASP    55      63.689 -15.445  24.058  1.00 30.38           C  
ATOM    368  O   ASP    55      63.672 -14.436  24.769  1.00 29.76           O  
ATOM    369  CB  ASP    55      64.211 -14.688  21.668  0.50 28.09           C  
ATOM    371  CG  ASP    55      63.711 -14.584  20.193  0.50 31.75           C  
ATOM    373  OD1 ASP    55      62.981 -15.477  19.699  0.50 24.59           O  
ATOM    375  OD2 ASP    55      64.057 -13.580  19.521  0.50 41.59           O  
ATOM    377  N   LYS    56      64.099 -16.626  24.493  1.00 32.08           N  
ATOM    378  CA  LYS    56      64.643 -16.810  25.839  1.00 34.65           C  
ATOM    379  C   LYS    56      66.126 -17.191  25.736  1.00 34.68           C  
ATOM    380  O   LYS    56      66.532 -17.954  24.850  1.00 37.13           O  
ATOM    381  CB  LYS    56      63.849 -17.857  26.614  1.00 33.26           C  
ATOM    382  CG  LYS    56      62.331 -17.594  26.648  1.00 33.10           C  
ATOM    383  CD  LYS    56      61.635 -18.592  27.549  1.00 36.85           C  
ATOM    384  CE  LYS    56      60.313 -18.080  28.068  1.00 40.09           C  
ATOM    385  NZ  LYS    56      59.874 -18.933  29.177  1.00 38.34           N  
ATOM    386  N   GLN    57      66.925 -16.637  26.632  1.00 31.52           N  
ATOM    387  CA  GLN    57      68.346 -16.923  26.674  1.00 35.10           C  
ATOM    388  C   GLN    57      68.785 -17.298  28.081  1.00 30.44           C  
ATOM    389  O   GLN    57      68.106 -16.981  29.053  1.00 29.95           O  
ATOM    390  CB  GLN    57      69.126 -15.699  26.191  1.00 37.37           C  
ATOM    391  CG  GLN    57      69.024 -15.465  24.686  1.00 43.68           C  
ATOM    392  CD  GLN    57      69.663 -14.166  24.279  1.00 45.08           C  
ATOM    393  OE1 GLN    57      69.247 -13.084  24.727  1.00 59.61           O  
ATOM    394  NE2 GLN    57      70.687 -14.252  23.422  1.00 57.02           N  
ATOM    395  N   GLY    58      69.932 -17.956  28.156  1.00 27.79           N  
ATOM    396  CA  GLY    58      70.562 -18.339  29.414  1.00 26.89           C  
ATOM    397  C   GLY    58      70.197 -19.773  29.693  1.00 24.22           C  
ATOM    398  O   GLY    58      69.295 -20.297  29.067  1.00 23.88           O  
ATOM    399  N   VAL    59      70.886 -20.411  30.626  1.00 23.58           N  
ATOM    400  CA  VAL    59      70.582 -21.783  31.014  1.00 23.37           C  
ATOM    401  C   VAL    59      69.143 -21.909  31.530  1.00 25.93           C  
ATOM    402  O   VAL    59      68.434 -22.844  31.153  1.00 26.68           O  
ATOM    403  CB  VAL    59      71.593 -22.308  32.067  1.00 24.01           C  
ATOM    404  CG1 VAL    59      71.238 -23.739  32.550  1.00 25.92           C  
ATOM    405  CG2 VAL    59      72.972 -22.274  31.485  1.00 24.03           C  
ATOM    406  N   THR    60      68.709 -20.948  32.352  1.00 23.65           N  
ATOM    407  CA  THR    60      67.411 -21.024  33.014  1.00 23.37           C  
ATOM    408  C   THR    60      66.334 -20.330  32.196  1.00 26.68           C  
ATOM    409  O   THR    60      65.167 -20.386  32.543  1.00 29.28           O  
ATOM    410  CB  THR    60      67.460 -20.432  34.466  1.00 23.51           C  
ATOM    411  OG1 THR    60      67.723 -19.014  34.411  1.00 24.54           O  
ATOM    412  CG2 THR    60      68.520 -21.178  35.329  1.00 18.42           C  
ATOM    413  N   GLY    61      66.724 -19.685  31.104  1.00 30.73           N  
ATOM    414  CA  GLY    61      65.778 -19.099  30.213  1.00 32.98           C  
ATOM    415  C   GLY    61      65.064 -17.897  30.798  1.00 33.69           C  
ATOM    416  O   GLY    61      63.924 -17.633  30.444  1.00 30.37           O  
ATOM    417  N   LYS    62      65.742 -17.153  31.672  1.00 34.20           N  
ATOM    418  CA  LYS    62      65.126 -16.018  32.367  1.00 34.99           C  
ATOM    419  C   LYS    62      65.403 -14.678  31.674  1.00 33.78           C  
ATOM    420  O   LYS    62      64.777 -13.689  31.991  1.00 32.47           O  
ATOM    421  CB  LYS    62      65.569 -15.970  33.846  1.00 36.51           C  
ATOM    422  CG  LYS    62      64.835 -17.001  34.756  1.00 40.22           C  
ATOM    423  CD  LYS    62      63.469 -16.485  35.349  1.00 35.99           C  
ATOM    424  CE  LYS    62      63.674 -15.574  36.580  1.00 39.51           C  
ATOM    425  NZ  LYS    62      62.419 -15.380  37.434  1.00 49.24           N  
ATOM    426  N   LYS    63      66.347 -14.657  30.743  1.00 34.21           N  
ATOM    427  CA  LYS    63      66.583 -13.491  29.897  0.50 32.42           C  
ATOM    429  C   LYS    63      65.592 -13.606  28.728  1.00 33.46           C  
ATOM    430  O   LYS    63      65.785 -14.402  27.821  1.00 34.76           O  
ATOM    431  CB  LYS    63      68.057 -13.471  29.440  0.50 32.19           C  
ATOM    433  CG  LYS    63      68.509 -12.280  28.569  0.50 31.21           C  
ATOM    435  CD  LYS    63      68.054 -10.927  29.115  0.50 31.56           C  
ATOM    437  CE  LYS    63      69.005  -9.800  28.734  0.50 31.03           C  
ATOM    439  NZ  LYS    63      69.908  -9.444  29.870  0.50 31.91           N  
ATOM    441  N   VAL    64      64.505 -12.844  28.784  1.00 31.40           N  
ATOM    442  CA  VAL    64      63.399 -13.004  27.823  1.00 30.46           C  
ATOM    443  C   VAL    64      63.151 -11.707  27.081  1.00 30.91           C  
ATOM    444  O   VAL    64      63.119 -10.664  27.694  1.00 29.73           O  
ATOM    445  CB  VAL    64      62.088 -13.428  28.519  1.00 29.36           C  
ATOM    446  CG1 VAL    64      60.970 -13.644  27.493  1.00 27.60           C  
ATOM    447  CG2 VAL    64      62.291 -14.703  29.339  1.00 27.76           C  
ATOM    448  N   SER    65      63.017 -11.776  25.760  1.00 29.51           N  
ATOM    449  CA  SER    65      62.544 -10.643  25.002  1.00 26.52           C  
ATOM    450  C   SER    65      61.240 -10.925  24.275  1.00 26.64           C  
ATOM    451  O   SER    65      61.002 -12.012  23.772  1.00 28.62           O  
ATOM    452  CB  SER    65      63.592 -10.138  24.022  1.00 27.05           C  
ATOM    453  OG  SER    65      64.070 -11.185  23.235  1.00 33.03           O  
ATOM    454  N   TYR    66      60.389  -9.920  24.236  1.00 25.59           N  
ATOM    455  CA  TYR    66      59.191  -9.948  23.409  1.00 27.15           C  
ATOM    456  C   TYR    66      59.361  -8.849  22.363  1.00 25.16           C  
ATOM    457  O   TYR    66      59.309  -7.661  22.693  1.00 25.87           O  
ATOM    458  CB  TYR    66      57.933  -9.662  24.243  1.00 28.11           C  
ATOM    459  CG  TYR    66      57.432 -10.753  25.177  1.00 28.34           C  
ATOM    460  CD1 TYR    66      58.267 -11.715  25.738  1.00 37.37           C  
ATOM    461  CD2 TYR    66      56.097 -10.793  25.520  1.00 31.42           C  
ATOM    462  CE1 TYR    66      57.757 -12.693  26.606  1.00 34.85           C  
ATOM    463  CE2 TYR    66      55.586 -11.741  26.356  1.00 33.25           C  
ATOM    464  CZ  TYR    66      56.403 -12.676  26.918  1.00 35.59           C  
ATOM    465  OH  TYR    66      55.813 -13.599  27.764  1.00 35.83           O  
ATOM    466  N   HIS    67      59.605  -9.263  21.126  1.00 24.79           N  
ATOM    467  CA  HIS    67      59.756  -8.360  20.009  1.00 26.12           C  
ATOM    468  C   HIS    67      58.450  -8.365  19.214  1.00 25.09           C  
ATOM    469  O   HIS    67      58.064  -9.386  18.628  1.00 25.46           O  
ATOM    470  CB  HIS    67      60.943  -8.805  19.158  1.00 27.50           C  
ATOM    471  CG  HIS    67      61.301  -7.845  18.073  1.00 28.86           C  
ATOM    472  ND1 HIS    67      62.124  -8.190  17.027  1.00 41.80           N  
ATOM    473  CD2 HIS    67      60.888  -6.582  17.826  1.00 33.68           C  
ATOM    474  CE1 HIS    67      62.236  -7.160  16.203  1.00 47.44           C  
ATOM    475  NE2 HIS    67      61.492  -6.172  16.665  1.00 32.45           N  
ATOM    476  N   SER    68      57.770  -7.224  19.200  1.00 23.64           N  
ATOM    477  CA  SER    68      56.558  -7.036  18.377  1.00 24.79           C  
ATOM    478  C   SER    68      56.883  -6.462  17.006  1.00 25.82           C  
ATOM    479  O   SER    68      57.509  -5.383  16.889  1.00 23.38           O  
ATOM    480  CB  SER    68      55.560  -6.122  19.079  1.00 24.81           C  
ATOM    481  OG  SER    68      55.153  -6.674  20.322  1.00 24.83           O  
ATOM    482  N   VAL    69      56.462  -7.187  15.969  1.00 25.47           N  
ATOM    483  CA  VAL    69      56.582  -6.720  14.602  1.00 26.01           C  
ATOM    484  C   VAL    69      55.193  -6.542  14.009  1.00 24.83           C  
ATOM    485  O   VAL    69      54.589  -7.532  13.574  1.00 24.53           O  
ATOM    486  CB  VAL    69      57.414  -7.649  13.728  1.00 25.83           C  
ATOM    487  CG1 VAL    69      57.718  -6.924  12.392  1.00 24.55           C  
ATOM    488  CG2 VAL    69      58.691  -8.027  14.450  1.00 23.41           C  
ATOM    489  N   PRO    70      54.672  -5.302  14.022  1.00 23.95           N  
ATOM    490  CA  PRO    70      53.391  -5.074  13.368  1.00 25.46           C  
ATOM    491  C   PRO    70      53.522  -5.421  11.899  1.00 25.75           C  
ATOM    492  O   PRO    70      54.592  -5.246  11.303  1.00 23.32           O  
ATOM    493  CB  PRO    70      53.128  -3.576  13.583  1.00 26.99           C  
ATOM    494  CG  PRO    70      54.007  -3.194  14.738  1.00 26.95           C  
ATOM    495  CD  PRO    70      55.206  -4.066  14.618  1.00 25.90           C  
ATOM    496  N   TYR    71      52.450  -5.922  11.315  1.00 25.67           N  
ATOM    497  CA  TYR    71      52.500  -6.345   9.929  1.00 25.24           C  
ATOM    498  C   TYR    71      52.827  -5.174   9.030  1.00 26.11           C  
ATOM    499  O   TYR    71      53.498  -5.336   8.025  1.00 23.81           O  
ATOM    500  CB  TYR    71      51.193  -7.003   9.522  1.00 24.58           C  
ATOM    501  CG  TYR    71      50.978  -8.334  10.184  1.00 24.13           C  
ATOM    502  CD1 TYR    71      51.691  -9.464   9.795  1.00 27.42           C  
ATOM    503  CD2 TYR    71      50.050  -8.469  11.195  1.00 24.56           C  
ATOM    504  CE1 TYR    71      51.470 -10.710  10.408  1.00 28.42           C  
ATOM    505  CE2 TYR    71      49.837  -9.702  11.828  1.00 27.00           C  
ATOM    506  CZ  TYR    71      50.543 -10.816  11.435  1.00 28.87           C  
ATOM    507  OH  TYR    71      50.294 -12.027  12.072  1.00 26.97           O  
ATOM    508  N   LYS    72      52.402  -3.976   9.423  1.00 27.90           N  
ATOM    509  CA  LYS    72      52.643  -2.772   8.604  1.00 30.48           C  
ATOM    510  C   LYS    72      54.128  -2.389   8.517  1.00 29.83           C  
ATOM    511  O   LYS    72      54.514  -1.617   7.651  1.00 28.15           O  
ATOM    512  CB  LYS    72      51.767  -1.606   9.074  1.00 33.73           C  
ATOM    513  CG  LYS    72      51.942  -1.228  10.527  1.00 38.80           C  
ATOM    514  CD  LYS    72      50.645  -0.734  11.194  1.00 46.86           C  
ATOM    515  CE  LYS    72      50.850  -0.492  12.717  1.00 46.76           C  
ATOM    516  NZ  LYS    72      52.020   0.384  13.023  1.00 49.99           N  
ATOM    517  N   ALA    73      54.959  -2.974   9.379  1.00 26.03           N  
ATOM    518  CA  ALA    73      56.422  -2.756   9.354  1.00 26.95           C  
ATOM    519  C   ALA    73      57.135  -3.716   8.404  1.00 26.78           C  
ATOM    520  O   ALA    73      58.331  -3.561   8.124  1.00 27.35           O  
ATOM    521  CB  ALA    73      56.990  -2.931  10.753  1.00 25.26           C  
ATOM    522  N   ILE    74      56.430  -4.750   7.955  1.00 25.79           N  
ATOM    523  CA  ILE    74      57.001  -5.740   7.046  1.00 26.02           C  
ATOM    524  C   ILE    74      56.861  -5.161   5.650  1.00 24.56           C  
ATOM    525  O   ILE    74      55.773  -5.159   5.064  1.00 27.24           O  
ATOM    526  CB  ILE    74      56.297  -7.115   7.133  1.00 26.74           C  
ATOM    527  CG1 ILE    74      56.326  -7.676   8.549  1.00 30.37           C  
ATOM    528  CG2 ILE    74      56.963  -8.088   6.230  1.00 27.04           C  
ATOM    529  CD1 ILE    74      55.440  -8.887   8.738  1.00 29.27           C  
ATOM    530  N   THR    75      57.953  -4.654   5.115  1.00 22.75           N  
ATOM    531  CA  THR    75      57.917  -3.898   3.863  1.00 21.25           C  
ATOM    532  C   THR    75      57.933  -4.815   2.636  1.00 22.95           C  
ATOM    533  O   THR    75      57.459  -4.460   1.547  1.00 24.63           O  
ATOM    534  CB  THR    75      59.104  -2.942   3.808  1.00 22.31           C  
ATOM    535  OG1 THR    75      60.307  -3.702   3.935  1.00 25.77           O  
ATOM    536  CG2 THR    75      59.024  -1.927   4.971  1.00 22.55           C  
ATOM    537  N   HIS    76      58.510  -5.991   2.811  1.00 22.57           N  
ATOM    538  CA  HIS    76      58.493  -7.038   1.804  1.00 21.16           C  
ATOM    539  C   HIS    76      58.956  -8.338   2.451  1.00 21.61           C  
ATOM    540  O   HIS    76      59.448  -8.354   3.593  1.00 21.00           O  
ATOM    541  CB  HIS    76      59.271  -6.658   0.519  1.00 21.76           C  
ATOM    542  CG  HIS    76      60.724  -6.317   0.693  1.00 24.97           C  
ATOM    543  ND1 HIS    76      61.722  -6.956  -0.015  1.00 20.31           N  
ATOM    544  CD2 HIS    76      61.344  -5.355   1.417  1.00 23.18           C  
ATOM    545  CE1 HIS    76      62.888  -6.436   0.308  1.00 26.69           C  
ATOM    546  NE2 HIS    76      62.686  -5.465   1.178  1.00 21.31           N  
ATOM    547  N   PHE    77      58.703  -9.437   1.760  1.00 22.80           N  
ATOM    548  CA  PHE    77      59.033 -10.739   2.305  1.00 23.33           C  
ATOM    549  C   PHE    77      59.224 -11.738   1.201  1.00 22.45           C  
ATOM    550  O   PHE    77      58.783 -11.527   0.084  1.00 24.55           O  
ATOM    551  CB  PHE    77      57.965 -11.202   3.326  1.00 23.75           C  
ATOM    552  CG  PHE    77      56.558 -11.264   2.781  1.00 24.36           C  
ATOM    553  CD1 PHE    77      55.752 -10.146   2.780  1.00 27.09           C  
ATOM    554  CD2 PHE    77      56.055 -12.443   2.267  1.00 24.93           C  
ATOM    555  CE1 PHE    77      54.469 -10.203   2.281  1.00 26.23           C  
ATOM    556  CE2 PHE    77      54.774 -12.514   1.758  1.00 27.60           C  
ATOM    557  CZ  PHE    77      53.962 -11.395   1.785  1.00 27.00           C  
ATOM    558  N   GLU    78      59.890 -12.838   1.532  1.00 25.55           N  
ATOM    559  CA  GLU    78      60.207 -13.869   0.574  1.00 27.24           C  
ATOM    560  C   GLU    78      60.175 -15.278   1.202  1.00 27.50           C  
ATOM    561  O   GLU    78      60.571 -15.464   2.348  1.00 27.56           O  
ATOM    562  CB  GLU    78      61.586 -13.587  -0.008  1.00 26.47           C  
ATOM    563  CG  GLU    78      62.038 -14.553  -1.100  1.00 29.98           C  
ATOM    564  CD  GLU    78      63.528 -14.477  -1.337  1.00 35.83           C  
ATOM    565  OE1 GLU    78      63.990 -13.444  -1.870  1.00 49.62           O  
ATOM    566  OE2 GLU    78      64.234 -15.442  -0.960  1.00 48.38           O  
ATOM    567  N   VAL    79      59.665 -16.253   0.440  1.00 28.02           N  
ATOM    568  CA  VAL    79      59.784 -17.664   0.793  1.00 26.32           C  
ATOM    569  C   VAL    79      60.564 -18.368  -0.296  1.00 27.86           C  
ATOM    570  O   VAL    79      60.301 -18.193  -1.488  1.00 25.50           O  
ATOM    571  CB  VAL    79      58.420 -18.360   0.961  1.00 28.00           C  
ATOM    572  CG1 VAL    79      58.603 -19.874   1.275  1.00 24.25           C  
ATOM    573  CG2 VAL    79      57.610 -17.676   2.052  1.00 24.80           C  
ATOM    574  N   GLU    80      61.528 -19.179   0.142  1.00 32.33           N  
ATOM    575  CA  GLU    80      62.405 -19.946  -0.732  1.00 33.40           C  
ATOM    576  C   GLU    80      62.178 -21.389  -0.320  1.00 34.29           C  
ATOM    577  O   GLU    80      62.310 -21.733   0.859  1.00 28.69           O  
ATOM    578  CB  GLU    80      63.861 -19.555  -0.489  1.00 35.09           C  
ATOM    579  CG  GLU    80      64.883 -19.996  -1.507  1.00 41.39           C  
ATOM    580  CD  GLU    80      66.305 -19.666  -1.031  1.00 43.19           C  
ATOM    581  OE1 GLU    80      66.903 -20.502  -0.307  1.00 56.02           O  
ATOM    582  OE2 GLU    80      66.812 -18.568  -1.363  1.00 56.50           O  
ATOM    583  N   THR    81      61.829 -22.221  -1.301  1.00 35.13           N  
ATOM    584  CA  THR    81      61.480 -23.608  -1.035  1.00 37.16           C  
ATOM    585  C   THR    81      62.756 -24.389  -0.712  1.00 37.03           C  
ATOM    586  O   THR    81      63.840 -23.988  -1.118  1.00 35.66           O  
ATOM    587  CB  THR    81      60.700 -24.184  -2.240  1.00 36.24           C  
ATOM    588  OG1 THR    81      61.493 -24.098  -3.426  1.00 37.33           O  
ATOM    589  CG2 THR    81      59.409 -23.360  -2.461  1.00 39.83           C  
ATOM    590  N   ALA    82      62.630 -25.466   0.061  1.00 39.00           N  
ATOM    591  CA  ALA    82      63.767 -26.374   0.318  1.00 39.90           C  
ATOM    592  C   ALA    82      64.176 -27.112  -0.957  1.00 39.43           C  
ATOM    593  O   ALA    82      63.336 -27.504  -1.766  1.00 37.27           O  
ATOM    594  CB  ALA    82      63.419 -27.388   1.422  1.00 40.09           C  
ATOM    595  N   GLY    83      65.474 -27.305  -1.138  1.00 41.07           N  
ATOM    596  CA  GLY    83      65.962 -28.114  -2.259  1.00 41.94           C  
ATOM    597  C   GLY    83      65.796 -29.618  -2.065  1.00 42.20           C  
ATOM    598  O   GLY    83      65.641 -30.362  -3.044  1.00 44.82           O  
ATOM    599  N   THR    84      65.846 -30.072  -0.811  1.00 39.95           N  
ATOM    600  CA  THR    84      65.758 -31.504  -0.486  1.00 38.44           C  
ATOM    601  C   THR    84      64.798 -31.724   0.685  1.00 36.77           C  
ATOM    602  O   THR    84      64.413 -30.767   1.359  1.00 32.11           O  
ATOM    603  CB  THR    84      67.157 -32.093  -0.109  1.00 38.28           C  
ATOM    604  OG1 THR    84      67.666 -31.454   1.069  1.00 41.12           O  
ATOM    605  CG2 THR    84      68.158 -31.905  -1.247  1.00 39.37           C  
ATOM    606  N   PHE    85      64.417 -32.978   0.934  1.00 35.16           N  
ATOM    607  CA  PHE    85      63.581 -33.299   2.101  1.00 34.59           C  
ATOM    608  C   PHE    85      64.285 -32.974   3.419  1.00 33.54           C  
ATOM    609  O   PHE    85      63.643 -32.631   4.403  1.00 34.69           O  
ATOM    610  CB  PHE    85      63.156 -34.771   2.093  1.00 34.35           C  
ATOM    611  CG  PHE    85      62.411 -35.187   3.330  1.00 36.56           C  
ATOM    612  CD1 PHE    85      61.094 -34.791   3.530  1.00 34.23           C  
ATOM    613  CD2 PHE    85      63.022 -35.964   4.303  1.00 41.90           C  
ATOM    614  CE1 PHE    85      60.399 -35.165   4.668  1.00 37.88           C  
ATOM    615  CE2 PHE    85      62.321 -36.339   5.447  1.00 43.44           C  
ATOM    616  CZ  PHE    85      61.014 -35.933   5.631  1.00 38.10           C  
ATOM    617  N   ASP    86      65.610 -33.065   3.418  1.00 34.57           N  
ATOM    618  CA  ASP    86      66.430 -32.811   4.598  1.00 35.43           C  
ATOM    619  C   ASP    86      66.472 -31.326   4.976  1.00 34.34           C  
ATOM    620  O   ASP    86      66.744 -30.990   6.118  1.00 32.83           O  
ATOM    621  CB  ASP    86      67.850 -33.364   4.358  1.00 37.07           C  
ATOM    622  CG  ASP    86      67.840 -34.850   3.943  1.00 44.24           C  
ATOM    623  OD1 ASP    86      67.415 -35.710   4.757  1.00 50.09           O  
ATOM    624  OD2 ASP    86      68.258 -35.161   2.797  1.00 51.21           O  
ATOM    625  N   MET    87      66.176 -30.441   4.026  1.00 36.41           N  
ATOM    626  CA  MET    87      66.183 -28.994   4.272  1.00 36.73           C  
ATOM    627  C   MET    87      64.767 -28.427   4.408  1.00 37.03           C  
ATOM    628  O   MET    87      63.805 -28.999   3.900  1.00 37.95           O  
ATOM    629  CB  MET    87      66.891 -28.277   3.119  1.00 37.02           C  
ATOM    630  CG  MET    87      68.369 -28.632   2.974  1.00 41.34           C  
ATOM    631  SD  MET    87      69.443 -27.796   4.371  0.75 49.61          SE  
ATOM    632  CE  MET    87      69.209 -25.886   3.795  1.00 51.12           C  
ATOM    633  N   ASP    88      64.667 -27.273   5.063  1.00 35.71           N  
ATOM    634  CA  ASP    88      63.390 -26.568   5.241  1.00 35.48           C  
ATOM    635  C   ASP    88      63.303 -25.338   4.350  1.00 33.04           C  
ATOM    636  O   ASP    88      64.328 -24.763   3.968  1.00 30.35           O  
ATOM    637  CB  ASP    88      63.247 -26.146   6.700  1.00 35.92           C  
ATOM    638  CG  ASP    88      63.194 -27.331   7.637  1.00 40.49           C  
ATOM    639  OD1 ASP    88      62.562 -28.349   7.240  1.00 39.27           O  
ATOM    640  OD2 ASP    88      63.780 -27.251   8.754  1.00 40.62           O  
ATOM    641  N   ALA    89      62.076 -24.940   4.021  1.00 31.56           N  
ATOM    642  CA  ALA    89      61.844 -23.672   3.309  1.00 31.28           C  
ATOM    643  C   ALA    89      62.235 -22.539   4.235  1.00 30.47           C  
ATOM    644  O   ALA    89      62.233 -22.703   5.456  1.00 30.63           O  
ATOM    645  CB  ALA    89      60.369 -23.520   2.867  1.00 30.70           C  
ATOM    646  N   GLU    90      62.583 -21.397   3.646  1.00 31.14           N  
ATOM    647  CA  GLU    90      63.076 -20.246   4.401  1.00 31.27           C  
ATOM    648  C   GLU    90      62.162 -19.053   4.204  1.00 28.02           C  
ATOM    649  O   GLU    90      61.768 -18.765   3.077  1.00 29.40           O  
ATOM    650  CB  GLU    90      64.466 -19.893   3.905  1.00 31.85           C  
ATOM    651  CG  GLU    90      65.348 -19.268   4.936  1.00 40.07           C  
ATOM    652  CD  GLU    90      66.740 -19.039   4.398  1.00 43.03           C  
ATOM    653  OE1 GLU    90      66.913 -18.106   3.579  1.00 52.07           O  
ATOM    654  OE2 GLU    90      67.646 -19.791   4.798  1.00 52.41           O  
ATOM    655  N   LEU    91      61.819 -18.381   5.299  1.00 26.54           N  
ATOM    656  CA  LEU    91      61.059 -17.128   5.252  1.00 27.74           C  
ATOM    657  C   LEU    91      62.008 -15.977   5.589  1.00 27.20           C  
ATOM    658  O   LEU    91      62.698 -16.022   6.605  1.00 25.93           O  
ATOM    659  CB  LEU    91      59.891 -17.155   6.248  1.00 28.11           C  
ATOM    660  CG  LEU    91      59.006 -15.915   6.487  1.00 26.78           C  
ATOM    661  CD1 LEU    91      58.119 -15.653   5.272  1.00 22.45           C  
ATOM    662  CD2 LEU    91      58.147 -16.087   7.736  1.00 30.23           C  
ATOM    663  N   LYS    92      62.068 -14.983   4.703  1.00 26.73           N  
ATOM    664  CA  LYS    92      62.780 -13.743   4.942  1.00 27.30           C  
ATOM    665  C   LYS    92      61.738 -12.625   5.112  1.00 25.61           C  
ATOM    666  O   LYS    92      60.819 -12.474   4.283  1.00 24.28           O  
ATOM    667  CB  LYS    92      63.692 -13.408   3.771  1.00 28.67           C  
ATOM    668  CG  LYS    92      64.701 -14.500   3.403  1.00 34.36           C  
ATOM    669  CD  LYS    92      65.692 -13.966   2.364  1.00 36.89           C  
ATOM    670  CE  LYS    92      66.965 -14.795   2.340  1.00 49.31           C  
ATOM    671  NZ  LYS    92      67.740 -14.530   1.099  1.00 55.51           N  
ATOM    672  N   LEU    93      61.854 -11.875   6.204  1.00 25.04           N  
ATOM    673  CA  LEU    93      60.949 -10.727   6.466  1.00 25.80           C  
ATOM    674  C   LEU    93      61.803  -9.493   6.554  1.00 26.08           C  
ATOM    675  O   LEU    93      62.727  -9.447   7.361  1.00 26.48           O  
ATOM    676  CB  LEU    93      60.180 -10.876   7.767  1.00 27.38           C  
ATOM    677  CG  LEU    93      59.205 -12.049   7.967  1.00 29.96           C  
ATOM    678  CD1 LEU    93      58.691 -12.011   9.405  1.00 31.75           C  
ATOM    679  CD2 LEU    93      58.029 -12.039   7.000  1.00 28.80           C  
ATOM    680  N   TRP    94      61.529  -8.506   5.705  1.00 23.54           N  
ATOM    681  CA  TRP    94      62.245  -7.239   5.811  1.00 24.30           C  
ATOM    682  C   TRP    94      61.435  -6.314   6.661  1.00 23.70           C  
ATOM    683  O   TRP    94      60.261  -6.099   6.412  1.00 26.50           O  
ATOM    684  CB  TRP    94      62.494  -6.634   4.461  1.00 25.47           C  
ATOM    685  CG  TRP    94      63.624  -7.222   3.760  1.00 24.57           C  
ATOM    686  CD1 TRP    94      64.933  -6.757   3.745  1.00 26.09           C  
ATOM    687  CD2 TRP    94      63.605  -8.383   2.940  1.00 26.14           C  
ATOM    688  NE1 TRP    94      65.700  -7.560   2.952  1.00 28.69           N  
ATOM    689  CE2 TRP    94      64.915  -8.558   2.434  1.00 23.04           C  
ATOM    690  CE3 TRP    94      62.607  -9.283   2.560  1.00 24.99           C  
ATOM    691  CZ2 TRP    94      65.254  -9.606   1.605  1.00 28.18           C  
ATOM    692  CZ3 TRP    94      62.937 -10.311   1.721  1.00 30.51           C  
ATOM    693  CH2 TRP    94      64.259 -10.468   1.244  1.00 31.54           C  
ATOM    694  N   ILE    95      62.068  -5.794   7.695  1.00 25.32           N  
ATOM    695  CA  ILE    95      61.432  -4.881   8.617  1.00 24.96           C  
ATOM    696  C   ILE    95      61.942  -3.471   8.338  1.00 25.77           C  
ATOM    697  O   ILE    95      63.157  -3.233   8.235  1.00 23.87           O  
ATOM    698  CB  ILE    95      61.693  -5.286  10.043  1.00 28.14           C  
ATOM    699  CG1 ILE    95      61.146  -6.701  10.309  1.00 29.98           C  
ATOM    700  CG2 ILE    95      61.069  -4.257  11.027  1.00 23.96           C  
ATOM    701  CD1 ILE    95      61.754  -7.334  11.584  1.00 38.56           C  
ATOM    702  N   SER    96      61.002  -2.543   8.212  1.00 25.84           N  
ATOM    703  CA  SER    96      61.314  -1.141   7.962  1.00 25.77           C  
ATOM    704  C   SER    96      62.446  -0.639   8.862  1.00 24.02           C  
ATOM    705  O   SER    96      62.354  -0.719  10.100  1.00 26.63           O  
ATOM    706  CB  SER    96      60.079  -0.289   8.198  1.00 27.15           C  
ATOM    707  OG  SER    96      60.405   1.045   7.950  1.00 29.32           O  
ATOM    708  N   GLY    97      63.492  -0.109   8.234  1.00 22.83           N  
ATOM    709  CA  GLY    97      64.616   0.510   8.926  1.00 23.97           C  
ATOM    710  C   GLY    97      65.730  -0.450   9.287  1.00 28.11           C  
ATOM    711  O   GLY    97      66.808  -0.017   9.715  1.00 25.59           O  
ATOM    712  N   GLN    98      65.473  -1.759   9.130  1.00 27.91           N  
ATOM    713  CA  GLN    98      66.453  -2.791   9.440  1.00 30.31           C  
ATOM    714  C   GLN    98      66.987  -3.389   8.137  1.00 29.14           C  
ATOM    715  O   GLN    98      66.226  -3.952   7.351  1.00 29.59           O  
ATOM    716  CB  GLN    98      65.798  -3.834  10.333  1.00 30.54           C  
ATOM    717  CG  GLN    98      66.700  -4.988  10.747  1.00 32.23           C  
ATOM    718  CD  GLN    98      65.932  -6.097  11.449  1.00 36.31           C  
ATOM    719  OE1 GLN    98      65.290  -5.869  12.476  1.00 39.28           O  
ATOM    720  NE2 GLN    98      65.963  -7.303  10.873  1.00 37.11           N  
ATOM    721  N   LYS    99      68.287  -3.241   7.884  1.00 30.69           N  
ATOM    722  CA  LYS    99      68.832  -3.508   6.546  1.00 33.56           C  
ATOM    723  C   LYS    99      68.786  -4.980   6.185  1.00 30.39           C  
ATOM    724  O   LYS    99      68.444  -5.334   5.063  1.00 32.15           O  
ATOM    725  CB  LYS    99      70.283  -3.019   6.379  1.00 34.88           C  
ATOM    726  CG  LYS    99      70.717  -3.075   4.922  1.00 38.19           C  
ATOM    727  CD  LYS    99      72.159  -2.664   4.716  1.00 41.85           C  
ATOM    728  CE  LYS    99      72.662  -3.157   3.358  1.00 50.60           C  
ATOM    729  NZ  LYS    99      72.493  -4.643   3.205  1.00 54.44           N  
ATOM    730  N   ASP   100      69.136  -5.819   7.140  1.00 30.38           N  
ATOM    731  CA  ASP   100      69.087  -7.268   6.940  1.00 31.78           C  
ATOM    732  C   ASP   100      67.754  -7.871   7.364  1.00 29.41           C  
ATOM    733  O   ASP   100      67.194  -7.472   8.387  1.00 28.20           O  
ATOM    734  CB  ASP   100      70.217  -7.928   7.713  1.00 33.71           C  
ATOM    735  CG  ASP   100      71.586  -7.481   7.223  1.00 37.96           C  
ATOM    736  OD1 ASP   100      71.683  -6.969   6.081  1.00 41.69           O  
ATOM    737  OD2 ASP   100      72.556  -7.648   7.983  1.00 47.04           O  
ATOM    738  N   PRO   101      67.250  -8.852   6.589  1.00 27.18           N  
ATOM    739  CA  PRO   101      65.970  -9.453   6.911  1.00 26.93           C  
ATOM    740  C   PRO   101      66.065 -10.374   8.106  1.00 26.74           C  
ATOM    741  O   PRO   101      67.131 -10.919   8.372  1.00 27.02           O  
ATOM    742  CB  PRO   101      65.659 -10.266   5.660  1.00 27.48           C  
ATOM    743  CG  PRO   101      66.966 -10.650   5.152  1.00 26.69           C  
ATOM    744  CD  PRO   101      67.824  -9.461   5.375  1.00 28.74           C  
ATOM    745  N   LEU   102      64.956 -10.528   8.826  1.00 26.41           N  
ATOM    746  CA  LEU   102      64.796 -11.585   9.805  1.00 28.61           C  
ATOM    747  C   LEU   102      64.560 -12.868   9.003  1.00 29.31           C  
ATOM    748  O   LEU   102      63.639 -12.930   8.199  1.00 29.52           O  
ATOM    749  CB  LEU   102      63.626 -11.237  10.726  1.00 29.45           C  
ATOM    750  CG  LEU   102      63.125 -12.236  11.764  1.00 37.35           C  
ATOM    751  CD1 LEU   102      64.215 -12.644  12.720  1.00 42.33           C  
ATOM    752  CD2 LEU   102      61.960 -11.601  12.523  1.00 34.66           C  
ATOM    753  N   VAL   103      65.439 -13.858   9.165  1.00 30.55           N  
ATOM    754  CA  VAL   103      65.370 -15.096   8.405  1.00 29.93           C  
ATOM    755  C   VAL   103      64.945 -16.258   9.337  1.00 33.10           C  
ATOM    756  O   VAL   103      65.534 -16.489  10.398  1.00 33.96           O  
ATOM    757  CB  VAL   103      66.701 -15.386   7.711  1.00 29.39           C  
ATOM    758  CG1 VAL   103      66.600 -16.636   6.845  1.00 30.18           C  
ATOM    759  CG2 VAL   103      67.113 -14.209   6.871  1.00 29.40           C  
ATOM    760  N   LYS   104      63.876 -16.945   8.962  1.00 33.36           N  
ATOM    761  CA  LYS   104      63.327 -18.008   9.806  1.00 34.68           C  
ATOM    762  C   LYS   104      63.112 -19.281   8.990  1.00 33.67           C  
ATOM    763  O   LYS   104      62.619 -19.232   7.858  1.00 30.77           O  
ATOM    764  CB  LYS   104      62.043 -17.531  10.488  1.00 36.15           C  
ATOM    765  CG  LYS   104      62.260 -16.435  11.548  1.00 42.19           C  
ATOM    766  CD  LYS   104      62.932 -16.943  12.839  1.00 49.61           C  
ATOM    767  CE  LYS   104      61.927 -17.046  13.995  1.00 53.15           C  
ATOM    768  NZ  LYS   104      62.482 -17.459  15.333  1.00 54.45           N  
ATOM    769  N   GLU   105      63.558 -20.413   9.541  1.00 34.65           N  
ATOM    770  CA  GLU   105      63.309 -21.711   8.915  1.00 38.12           C  
ATOM    771  C   GLU   105      61.878 -22.087   9.144  1.00 35.29           C  
ATOM    772  O   GLU   105      61.392 -22.020  10.279  1.00 36.59           O  
ATOM    773  CB  GLU   105      64.188 -22.818   9.508  1.00 40.49           C  
ATOM    774  CG  GLU   105      65.450 -23.105   8.728  1.00 47.84           C  
ATOM    775  CD  GLU   105      66.309 -24.156   9.425  1.00 47.35           C  
ATOM    776  OE1 GLU   105      65.770 -25.242   9.787  1.00 58.53           O  
ATOM    777  OE2 GLU   105      67.517 -23.875   9.625  1.00 60.66           O  
ATOM    778  N   LEU   106      61.198 -22.462   8.063  1.00 33.29           N  
ATOM    779  CA  LEU   106      59.846 -22.953   8.155  1.00 34.41           C  
ATOM    780  C   LEU   106      59.939 -24.444   8.457  1.00 35.26           C  
ATOM    781  O   LEU   106      59.813 -25.280   7.564  1.00 35.75           O  
ATOM    782  CB  LEU   106      59.071 -22.653   6.864  1.00 32.96           C  
ATOM    783  CG  LEU   106      58.863 -21.152   6.572  1.00 32.66           C  
ATOM    784  CD1 LEU   106      58.118 -20.885   5.270  1.00 29.48           C  
ATOM    785  CD2 LEU   106      58.184 -20.422   7.750  1.00 31.35           C  
ATOM    786  N   LYS   107      60.171 -24.745   9.735  1.00 37.24           N  
ATOM    787  CA  LYS   107      60.501 -26.107  10.177  1.00 39.70           C  
ATOM    788  C   LYS   107      59.363 -27.083   9.948  1.00 38.58           C  
ATOM    789  O   LYS   107      58.192 -26.690   9.886  1.00 36.43           O  
ATOM    790  CB  LYS   107      60.899 -26.117  11.648  1.00 39.82           C  
ATOM    791  CG  LYS   107      62.101 -25.259  11.910  1.00 43.15           C  
ATOM    792  CD  LYS   107      62.416 -25.116  13.371  1.00 45.67           C  
ATOM    793  CE  LYS   107      63.699 -24.326  13.528  1.00 50.08           C  
ATOM    794  NZ  LYS   107      64.809 -24.969  12.753  1.00 46.24           N  
ATOM    795  N   LYS   108      59.727 -28.355   9.789  1.00 39.31           N  
ATOM    796  CA  LYS   108      58.743 -29.433   9.701  1.00 38.89           C  
ATOM    797  C   LYS   108      57.824 -29.377  10.930  1.00 37.81           C  
ATOM    798  O   LYS   108      58.274 -29.207  12.075  1.00 34.12           O  
ATOM    799  CB  LYS   108      59.423 -30.795   9.552  1.00 39.54           C  
ATOM    800  CG  LYS   108      60.031 -30.980   8.164  1.00 42.00           C  
ATOM    801  CD  LYS   108      60.906 -32.208   8.081  1.00 47.09           C  
ATOM    802  CE  LYS   108      61.631 -32.273   6.744  1.00 46.97           C  
ATOM    803  NZ  LYS   108      62.540 -31.099   6.547  1.00 39.92           N  
ATOM    804  N   GLY   109      56.529 -29.472  10.660  1.00 36.51           N  
ATOM    805  CA  GLY   109      55.519 -29.177  11.653  1.00 37.24           C  
ATOM    806  C   GLY   109      54.816 -27.834  11.464  1.00 38.00           C  
ATOM    807  O   GLY   109      53.763 -27.601  12.070  1.00 40.47           O  
ATOM    808  N   THR   110      55.381 -26.924  10.668  1.00 36.87           N  
ATOM    809  CA  THR   110      54.712 -25.633  10.437  1.00 34.22           C  
ATOM    810  C   THR   110      53.744 -25.763   9.251  1.00 33.19           C  
ATOM    811  O   THR   110      53.933 -26.597   8.364  1.00 32.71           O  
ATOM    812  CB  THR   110      55.704 -24.436  10.224  1.00 33.34           C  
ATOM    813  OG1 THR   110      56.512 -24.653   9.073  1.00 37.61           O  
ATOM    814  CG2 THR   110      56.613 -24.188  11.463  1.00 35.87           C  
ATOM    815  N   ASP   111      52.676 -24.974   9.265  1.00 33.06           N  
ATOM    816  CA  ASP   111      51.805 -24.840   8.096  1.00 31.65           C  
ATOM    817  C   ASP   111      52.447 -23.803   7.181  1.00 32.04           C  
ATOM    818  O   ASP   111      52.207 -22.594   7.305  1.00 30.82           O  
ATOM    819  CB  ASP   111      50.412 -24.389   8.520  1.00 32.47           C  
ATOM    820  CG  ASP   111      49.386 -24.491   7.397  1.00 35.05           C  
ATOM    821  OD1 ASP   111      49.730 -24.897   6.264  1.00 37.68           O  
ATOM    822  OD2 ASP   111      48.212 -24.160   7.661  1.00 41.03           O  
ATOM    823  N   VAL   112      53.298 -24.277   6.277  1.00 32.15           N  
ATOM    824  CA  VAL   112      54.098 -23.367   5.458  1.00 32.83           C  
ATOM    825  C   VAL   112      53.197 -22.462   4.621  1.00 32.37           C  
ATOM    826  O   VAL   112      53.411 -21.257   4.551  1.00 32.01           O  
ATOM    827  CB  VAL   112      55.104 -24.153   4.598  1.00 33.23           C  
ATOM    828  CG1 VAL   112      55.614 -23.317   3.419  1.00 34.34           C  
ATOM    829  CG2 VAL   112      56.226 -24.601   5.473  1.00 33.20           C  
ATOM    830  N   VAL   113      52.180 -23.048   3.997  1.00 32.36           N  
ATOM    831  CA  VAL   113      51.203 -22.278   3.211  1.00 31.90           C  
ATOM    832  C   VAL   113      50.331 -21.372   4.102  1.00 30.83           C  
ATOM    833  O   VAL   113      50.054 -20.228   3.751  1.00 31.76           O  
ATOM    834  CB  VAL   113      50.323 -23.208   2.333  1.00 33.31           C  
ATOM    835  CG1 VAL   113      49.076 -22.468   1.837  1.00 34.94           C  
ATOM    836  CG2 VAL   113      51.134 -23.766   1.163  1.00 29.56           C  
ATOM    837  N   GLY   114      49.927 -21.865   5.271  1.00 32.10           N  
ATOM    838  CA  GLY   114      49.098 -21.066   6.209  1.00 31.10           C  
ATOM    839  C   GLY   114      49.832 -19.871   6.800  1.00 29.28           C  
ATOM    840  O   GLY   114      49.293 -18.771   6.914  1.00 30.44           O  
ATOM    841  N   ILE   115      51.086 -20.092   7.165  1.00 30.00           N  
ATOM    842  CA  ILE   115      51.978 -19.012   7.534  1.00 30.58           C  
ATOM    843  C   ILE   115      51.972 -17.935   6.448  1.00 28.83           C  
ATOM    844  O   ILE   115      51.772 -16.771   6.713  1.00 31.68           O  
ATOM    845  CB  ILE   115      53.425 -19.559   7.805  1.00 30.17           C  
ATOM    846  CG1 ILE   115      53.472 -20.164   9.218  1.00 27.89           C  
ATOM    847  CG2 ILE   115      54.479 -18.456   7.609  1.00 26.80           C  
ATOM    848  CD1 ILE   115      54.769 -20.920   9.515  1.00 32.81           C  
ATOM    849  N   GLN   116      52.185 -18.334   5.210  1.00 29.60           N  
ATOM    850  CA  GLN   116      52.281 -17.357   4.131  1.00 28.93           C  
ATOM    851  C   GLN   116      50.942 -16.649   3.912  1.00 29.21           C  
ATOM    852  O   GLN   116      50.906 -15.448   3.581  1.00 29.10           O  
ATOM    853  CB  GLN   116      52.710 -18.054   2.851  1.00 29.66           C  
ATOM    854  CG  GLN   116      54.115 -18.626   2.898  1.00 31.21           C  
ATOM    855  CD  GLN   116      54.426 -19.386   1.655  1.00 29.09           C  
ATOM    856  OE1 GLN   116      54.697 -18.795   0.615  1.00 33.03           O  
ATOM    857  NE2 GLN   116      54.349 -20.713   1.734  1.00 27.96           N  
ATOM    858  N   LYS   117      49.850 -17.404   4.058  1.00 29.70           N  
ATOM    859  CA  LYS   117      48.499 -16.875   3.857  1.00 29.82           C  
ATOM    860  C   LYS   117      48.176 -15.857   4.943  1.00 28.61           C  
ATOM    861  O   LYS   117      47.611 -14.811   4.662  1.00 31.01           O  
ATOM    862  CB  LYS   117      47.473 -18.015   3.875  1.00 29.34           C  
ATOM    863  CG  LYS   117      46.067 -17.622   3.425  1.00 33.13           C  
ATOM    864  CD  LYS   117      45.176 -18.855   3.280  1.00 34.04           C  
ATOM    865  CE  LYS   117      43.939 -18.612   2.396  1.00 40.33           C  
ATOM    866  NZ  LYS   117      43.136 -17.428   2.817  1.00 40.20           N  
ATOM    867  N   THR   118      48.560 -16.168   6.181  1.00 29.34           N  
ATOM    868  CA  THR   118      48.391 -15.249   7.312  1.00 29.40           C  
ATOM    869  C   THR   118      49.143 -13.946   7.120  1.00 29.40           C  
ATOM    870  O   THR   118      48.602 -12.856   7.363  1.00 29.72           O  
ATOM    871  CB  THR   118      48.863 -15.891   8.629  1.00 31.36           C  
ATOM    872  OG1 THR   118      48.218 -17.150   8.782  1.00 30.38           O  
ATOM    873  CG2 THR   118      48.528 -14.991   9.823  1.00 31.15           C  
ATOM    874  N   ILE   119      50.387 -14.037   6.658  1.00 27.90           N  
ATOM    875  CA  ILE   119      51.154 -12.817   6.403  1.00 27.27           C  
ATOM    876  C   ILE   119      50.495 -11.998   5.315  1.00 26.94           C  
ATOM    877  O   ILE   119      50.398 -10.768   5.397  1.00 29.06           O  
ATOM    878  CB  ILE   119      52.654 -13.132   6.052  1.00 27.63           C  
ATOM    879  CG1 ILE   119      53.375 -13.653   7.290  1.00 31.58           C  
ATOM    880  CG2 ILE   119      53.360 -11.887   5.547  1.00 24.38           C  
ATOM    881  CD1 ILE   119      54.558 -14.592   7.017  1.00 25.73           C  
ATOM    882  N   ALA   120      50.013 -12.670   4.280  1.00 26.93           N  
ATOM    883  CA  ALA   120      49.331 -11.984   3.223  1.00 26.31           C  
ATOM    884  C   ALA   120      48.018 -11.372   3.728  1.00 27.39           C  
ATOM    885  O   ALA   120      47.703 -10.231   3.392  1.00 27.07           O  
ATOM    886  CB  ALA   120      49.050 -12.954   2.056  1.00 24.55           C  
ATOM    887  N   ASN   121      47.235 -12.140   4.503  1.00 29.54           N  
ATOM    888  CA  ASN   121      45.973 -11.623   5.076  1.00 30.57           C  
ATOM    889  C   ASN   121      46.149 -10.376   5.918  1.00 31.01           C  
ATOM    890  O   ASN   121      45.327  -9.452   5.873  1.00 32.08           O  
ATOM    891  CB  ASN   121      45.231 -12.705   5.909  1.00 31.39           C  
ATOM    892  CG  ASN   121      44.438 -13.653   5.047  1.00 32.51           C  
ATOM    893  OD1 ASN   121      43.982 -13.277   3.966  1.00 32.82           O  
ATOM    894  ND2 ASN   121      44.282 -14.899   5.503  1.00 30.06           N  
ATOM    895  N   PHE   122      47.208 -10.335   6.710  1.00 33.74           N  
ATOM    896  CA  PHE   122      47.370  -9.229   7.667  1.00 32.31           C  
ATOM    897  C   PHE   122      48.345  -8.170   7.200  1.00 33.03           C  
ATOM    898  O   PHE   122      48.298  -7.055   7.699  1.00 37.61           O  
ATOM    899  CB  PHE   122      47.757  -9.761   9.041  1.00 32.59           C  
ATOM    900  CG  PHE   122      46.712 -10.688   9.664  1.00 34.55           C  
ATOM    901  CD1 PHE   122      45.383 -10.294   9.773  1.00 36.39           C  
ATOM    902  CD2 PHE   122      47.070 -11.941  10.137  1.00 36.96           C  
ATOM    903  CE1 PHE   122      44.440 -11.132  10.335  1.00 38.73           C  
ATOM    904  CE2 PHE   122      46.125 -12.785  10.705  1.00 43.22           C  
ATOM    905  CZ  PHE   122      44.805 -12.375  10.806  1.00 39.44           C  
ATOM    906  N   SER   123      49.214  -8.453   6.236  1.00 33.63           N  
ATOM    907  CA  SER   123      50.231  -7.465   5.887  1.00 35.18           C  
ATOM    908  C   SER   123      50.050  -6.740   4.541  1.00 37.97           C  
ATOM    909  O   SER   123      50.790  -5.783   4.258  1.00 41.06           O  
ATOM    910  CB  SER   123      51.648  -8.061   6.023  1.00 38.33           C  
ATOM    911  OG  SER   123      52.060  -8.784   4.873  1.00 49.46           O  
ATOM    912  N   LEU   124      49.082  -7.162   3.726  1.00 36.37           N  
ATOM    913  CA  LEU   124      48.957  -6.651   2.346  1.00 38.25           C  
ATOM    914  C   LEU   124      47.781  -5.705   2.198  1.00 42.55           C  
ATOM    915  O   LEU   124      46.706  -6.000   2.760  1.00 45.02           O  
ATOM    916  CB  LEU   124      48.769  -7.805   1.351  1.00 35.85           C  
ATOM    917  CG  LEU   124      49.930  -8.768   1.148  1.00 31.97           C  
ATOM    918  CD1 LEU   124      49.528  -9.831   0.107  1.00 27.47           C  
ATOM    919  CD2 LEU   124      51.169  -8.015   0.704  1.00 26.82           C  
ATOM    920  OXT LEU   124      47.881  -4.667   1.503  1.00 44.32           O  
END
