
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  112 ( 1811),  selected  112 , name 1csy_A
# Molecule2: number of CA atoms   54 (  425),  selected   54 , name T0446_71_124.pdb
# PARAMETERS: 1csy_A.T0446_71_124.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      Y      71           -
LGA    S     2_A      -       -           -
LGA    R     3_A      -       -           -
LGA    R     4_A      -       -           -
LGA    A     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    V     7_A      -       -           -
LGA    G     8_A      -       -           -
LGA    S     9_A      -       -           -
LGA    H    10_A      -       -           -
LGA    E    11_A      -       -           -
LGA    K    12_A      -       -           -
LGA    M    13_A      -       -           -
LGA    P    14_A      -       -           -
LGA    W    15_A      -       -           -
LGA    F    16_A      -       -           -
LGA    H    17_A      -       -           -
LGA    G    18_A      -       -           -
LGA    K    19_A      -       -           -
LGA    I    20_A      -       -           -
LGA    S    21_A      -       -           -
LGA    R    22_A      -       -           -
LGA    E    23_A      -       -           -
LGA    E    24_A      -       -           -
LGA    S    25_A      -       -           -
LGA    E    26_A      -       -           -
LGA    Q    27_A      -       -           -
LGA    I    28_A      -       -           -
LGA    V    29_A      -       -           -
LGA    L    30_A      -       -           -
LGA    I    31_A      -       -           -
LGA    G    32_A      -       -           -
LGA    S    33_A      -       -           -
LGA    K    34_A      -       -           -
LGA    T    35_A      K      72          5.420
LGA    N    36_A      A      73          2.206
LGA    G    37_A      I      74          2.288
LGA    K    38_A      T      75          2.922
LGA    -       -      H      76           -
LGA    F    39_A      F      77          1.087
LGA    L    40_A      E      78          1.282
LGA    I    41_A      V      79          1.106
LGA    R    42_A      E      80          1.199
LGA    A    43_A      T      81          1.318
LGA    R    44_A      A      82          2.060
LGA    D    45_A      G      83          0.684
LGA    N    46_A      T      84          3.119
LGA    N    47_A      F      85          3.600
LGA    -       -      D      86           -
LGA    G    48_A      M      87          3.336
LGA    S    49_A      D      88          0.677
LGA    Y    50_A      A      89          1.108
LGA    A    51_A      E      90          1.817
LGA    L    52_A      L      91          1.285
LGA    C    53_A      K      92          1.033
LGA    L    54_A      L      93          1.172
LGA    L    55_A      W      94          1.092
LGA    H    56_A      I      95          1.138
LGA    E    57_A      S      96          1.339
LGA    G    58_A      G      97          3.189
LGA    K    59_A      Q      98          1.980
LGA    -       -      K      99           -
LGA    -       -      D     100           -
LGA    V    60_A      P     101          1.769
LGA    L    61_A      L     102          1.308
LGA    H    62_A      V     103          1.281
LGA    Y    63_A      K     104          1.452
LGA    R    64_A      E     105          1.386
LGA    I    65_A      L     106          0.750
LGA    D    66_A      K     107          1.844
LGA    K    67_A      K     108          1.537
LGA    D    68_A      G     109          3.878
LGA    K    69_A      -       -           -
LGA    T    70_A      -       -           -
LGA    G    71_A      -       -           -
LGA    K    72_A      -       -           -
LGA    L    73_A      -       -           -
LGA    S    74_A      T     110          1.182
LGA    I    75_A      -       -           -
LGA    P    76_A      -       -           -
LGA    E    77_A      -       -           -
LGA    G    78_A      -       -           -
LGA    K    79_A      -       -           -
LGA    K    80_A      -       -           -
LGA    F    81_A      -       -           -
LGA    D    82_A      D     111          3.705
LGA    T    83_A      V     112          3.825
LGA    L    84_A      V     113          2.121
LGA    W    85_A      -       -           -
LGA    Q    86_A      G     114          1.823
LGA    L    87_A      I     115          1.509
LGA    V    88_A      Q     116          0.671
LGA    E    89_A      K     117          0.830
LGA    H    90_A      T     118          1.493
LGA    Y    91_A      I     119          2.294
LGA    S    92_A      A     120          1.847
LGA    Y    93_A      N     121          2.706
LGA    K    94_A      F     122          3.658
LGA    A    95_A      -       -           -
LGA    D    96_A      -       -           -
LGA    G    97_A      -       -           -
LGA    L    98_A      -       -           -
LGA    L    99_A      -       -           -
LGA    R   100_A      -       -           -
LGA    V   101_A      -       -           -
LGA    L   102_A      S     123          3.029
LGA    T   103_A      L     124          2.877
LGA    V   104_A      -       -           -
LGA    P   105_A      -       -           -
LGA    C   106_A      -       -           -
LGA    Q   107_A      -       -           -
LGA    K   108_A      -       -           -
LGA    I   109_A      -       -           -
LGA    G   110_A      -       -           -
LGA    T   111_A      -       -           -
LGA    Q   112_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  112   54    5.0     49    2.23    14.29     76.228     2.105

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.541555 * X  +   0.099548 * Y  +   0.834750 * Z  +  59.037914
  Y_new =   0.827040 * X  +   0.114959 * Y  +  -0.550263 * Z  + -16.805286
  Z_new =  -0.150739 * X  +   0.988370 * Y  +  -0.020074 * Z  +   3.452032 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.591103   -1.550489  [ DEG:    91.1635    -88.8365 ]
  Theta =   0.151316    2.990276  [ DEG:     8.6698    171.3302 ]
  Phi   =   0.991046   -2.150547  [ DEG:    56.7828   -123.2172 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1csy_A                                        
REMARK     2: T0446_71_124.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1csy_A.T0446_71_124.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  112   54   5.0   49   2.23   14.29  76.228
REMARK  ---------------------------------------------------------- 
MOLECULE 1csy_A
HEADER    COMPLEX (PHOSPHOTRANSFERASE/PEPTIDE)    03-OCT-95   1CSY              
TITLE     SYK TYROSINE KINASE C-TERMINAL SH2 DOMAIN COMPLEXED WITH A            
TITLE    2 PHOSPHOPEPTIDEFROM THE GAMMA CHAIN OF THE HIGH AFFINITY              
TITLE    3 IMMUNOGLOBIN G RECEPTOR, NMR                                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SYK PROTEIN TYROSINE KINASE;                               
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: C-TERMINAL SH2 DOMAIN;                                     
COMPND   5 EC: 2.7.1.112;                                                       
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 MOL_ID: 2;                                                           
COMPND   8 MOLECULE: ACETYL-THR-PTR-GLU-THR-LEU-NH2;                            
COMPND   9 CHAIN: B;                                                            
COMPND  10 ENGINEERED: YES;                                                     
COMPND  11 OTHER_DETAILS: THE LIGAND IS A PHOSPHOTYROSINE CONTAINING            
COMPND  12 PEPTIDE DERIVED FROM THE HIGH-AFFINITY IGE RECEPTOR                  
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 CELL_LINE: BL21;                                                     
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: BL21;                                     
SOURCE   8 MOL_ID: 2;                                                           
SOURCE   9 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE  10 ORGANISM_COMMON: HUMAN;                                              
SOURCE  11 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  12 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE  13 OTHER_DETAILS: RECOMBINANT CONSTRUCT ADDED TO PROTEIN                
SOURCE  14 DOMAIN                                                               
KEYWDS    PROTEIN-TYROSINE KINASE SH2 DOMAIN, COMPLEX                           
KEYWDS   2 (PHOSPHOTRANSFERASE/PEPTIDE)                                         
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    S.S.NARULA,R.W.YUAN,S.E.ADAMS,O.M.GREEN,J.GREEN,                      
AUTHOR   2 T.B.PHILLIPS,L.D.ZYDOWSKY,M.C.BOTFIELD,M.H.HATADA,E.R.LAIRD,         
AUTHOR   3 M.J.ZOLLER,J.L.KARAS,D.C.DALGARNO                                    
REVDAT   2   01-APR-03 1CSY    1       JRNL                                     
REVDAT   1   08-NOV-96 1CSY    0                                                
JRNL        AUTH   S.S.NARULA,R.W.YUAN,S.E.ADAMS,O.M.GREEN,J.GREEN,             
JRNL        AUTH 2 T.B.PHILIPS,L.D.ZYDOWSKY,M.C.BOTFIELD,M.HATADA,              
JRNL        AUTH 3 E.R.LAIRD,ET AL.                                             
JRNL        TITL   SOLUTION STRUCTURE OF THE C-TERMINAL SH2 DOMAIN OF           
JRNL        TITL 2 THE HUMAN TYROSINE KINASE SYK COMPLEXED WITH A               
JRNL        TITL 3 PHOSPHOTYROSINE PENTAPEPTIDE.                                
JRNL        REF    STRUCTURE                     V.   3  1061 1995              
JRNL        REFN   ASTM STRUE6  UK ISSN 0969-2126                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1CSY A   10   112  UNP    P43405   KSYK_HUMAN     163    265             
SEQRES   1 A  112  GLY SER ARG ARG ALA SER VAL GLY SER HIS GLU LYS MET          
SEQRES   2 A  112  PRO TRP PHE HIS GLY LYS ILE SER ARG GLU GLU SER GLU          
SEQRES   3 A  112  GLN ILE VAL LEU ILE GLY SER LYS THR ASN GLY LYS PHE          
SEQRES   4 A  112  LEU ILE ARG ALA ARG ASP ASN ASN GLY SER TYR ALA LEU          
SEQRES   5 A  112  CYS LEU LEU HIS GLU GLY LYS VAL LEU HIS TYR ARG ILE          
SEQRES   6 A  112  ASP LYS ASP LYS THR GLY LYS LEU SER ILE PRO GLU GLY          
SEQRES   7 A  112  LYS LYS PHE ASP THR LEU TRP GLN LEU VAL GLU HIS TYR          
SEQRES   8 A  112  SER TYR LYS ALA ASP GLY LEU LEU ARG VAL LEU THR VAL          
SEQRES   9 A  112  PRO CYS GLN LYS ILE GLY THR GLN                              
SEQRES   1 B    5  THR PTR GLU THR LEU                                          
HET    PTR  B   2      24                                                       
HET    ACE  B   0       6                                                       
HET    NH2  B   6       3                                                       
HETNAM     PTR O-PHOSPHOTYROSINE                                                
HETNAM     ACE ACETYL GROUP                                                     
HETNAM     NH2 AMINO GROUP                                                      
HETSYN     PTR PHOSPHONOTYROSINE                                                
FORMUL   2  PTR    C9 H12 N O6 P                                                
FORMUL   3  ACE    C2 H4 O                                                      
FORMUL   4  NH2    H2 N                                                         
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      55.468 -41.733 -11.439  1.00  0.00           N  
ATOM      2  CA  GLY A   1      55.714 -41.231 -10.093  1.00  0.00           C  
ATOM      3  C   GLY A   1      57.200 -40.962  -9.836  1.00  0.00           C  
ATOM      4  O   GLY A   1      58.069 -41.758 -10.172  1.00  0.00           O  
ATOM      5  H2  GLY A   1      54.449 -41.902 -11.566  1.00  0.00           H  
ATOM      6  HA2 GLY A   1      55.147 -40.309  -9.960  1.00  0.00           H  
ATOM      7  HA3 GLY A   1      55.348 -41.967  -9.378  1.00  0.00           H  
ATOM      8  H1  GLY A   1      55.987 -42.624 -11.577  1.00  0.00           H  
ATOM      9  H3  GLY A   1      55.792 -41.033 -12.136  1.00  0.00           H  
ATOM     10  N   SER A   2      57.423 -39.786  -9.221  1.00  0.00           N  
ATOM     11  CA  SER A   2      58.796 -39.410  -8.922  1.00  0.00           C  
ATOM     12  C   SER A   2      59.051 -39.564  -7.423  1.00  0.00           C  
ATOM     13  O   SER A   2      58.284 -40.182  -6.695  1.00  0.00           O  
ATOM     14  CB  SER A   2      59.039 -37.968  -9.363  1.00  0.00           C  
ATOM     15  OG  SER A   2      60.377 -37.601  -9.145  1.00  0.00           O  
ATOM     16  H   SER A   2      56.662 -39.186  -8.974  1.00  0.00           H  
ATOM     17  HA  SER A   2      59.447 -40.098  -9.466  1.00  0.00           H  
ATOM     18  HB2 SER A   2      58.822 -37.845 -10.423  1.00  0.00           H  
ATOM     19  HB3 SER A   2      58.404 -37.279  -8.807  1.00  0.00           H  
ATOM     20  HG  SER A   2      60.417 -37.214  -8.281  1.00  0.00           H  
ATOM     21  N   ARG A   3      60.182 -38.958  -7.021  1.00  0.00           N  
ATOM     22  CA  ARG A   3      60.546 -39.029  -5.619  1.00  0.00           C  
ATOM     23  C   ARG A   3      60.292 -37.676  -4.955  1.00  0.00           C  
ATOM     24  O   ARG A   3      61.017 -36.710  -5.155  1.00  0.00           O  
ATOM     25  CB  ARG A   3      62.017 -39.422  -5.501  1.00  0.00           C  
ATOM     26  CG  ARG A   3      62.426 -39.637  -4.045  1.00  0.00           C  
ATOM     27  CD  ARG A   3      63.915 -39.960  -3.921  1.00  0.00           C  
ATOM     28  NE  ARG A   3      64.269 -40.198  -2.533  1.00  0.00           N  
ATOM     29  CZ  ARG A   3      65.431 -40.820  -2.261  1.00  0.00           C  
ATOM     30  NH1 ARG A   3      66.229 -41.206  -3.254  1.00  0.00           N  
ATOM     31  NH2 ARG A   3      65.785 -41.049  -0.999  1.00  0.00           N  
ATOM     32  H   ARG A   3      60.760 -38.469  -7.674  1.00  0.00           H  
ATOM     33  HA  ARG A   3      59.904 -39.783  -5.155  1.00  0.00           H  
ATOM     34  HB2 ARG A   3      62.197 -40.334  -6.070  1.00  0.00           H  
ATOM     35  HB3 ARG A   3      62.638 -38.645  -5.946  1.00  0.00           H  
ATOM     36  HG2 ARG A   3      62.195 -38.743  -3.464  1.00  0.00           H  
ATOM     37  HG3 ARG A   3      61.839 -40.450  -3.617  1.00  0.00           H  
ATOM     38  HD2 ARG A   3      64.180 -40.859  -4.474  1.00  0.00           H  
ATOM     39  HD3 ARG A   3      64.535 -39.136  -4.279  1.00  0.00           H  
ATOM     40  HE  ARG A   3      63.662 -39.905  -1.794  1.00  0.00           H  
ATOM     41 HH11 ARG A   3      65.966 -41.035  -4.203  1.00  0.00           H  
ATOM     42 HH12 ARG A   3      67.092 -41.669  -3.051  1.00  0.00           H  
ATOM     43 HH21 ARG A   3      65.187 -40.760  -0.251  1.00  0.00           H  
ATOM     44 HH22 ARG A   3      66.650 -41.511  -0.799  1.00  0.00           H  
ATOM     45  N   ARG A   4      59.209 -37.683  -4.156  1.00  0.00           N  
ATOM     46  CA  ARG A   4      58.851 -36.460  -3.459  1.00  0.00           C  
ATOM     47  C   ARG A   4      57.704 -36.749  -2.491  1.00  0.00           C  
ATOM     48  O   ARG A   4      56.745 -37.440  -2.810  1.00  0.00           O  
ATOM     49  CB  ARG A   4      58.446 -35.393  -4.472  1.00  0.00           C  
ATOM     50  CG  ARG A   4      57.829 -34.175  -3.786  1.00  0.00           C  
ATOM     51  CD  ARG A   4      57.740 -32.979  -4.734  1.00  0.00           C  
ATOM     52  NE  ARG A   4      57.213 -33.393  -6.022  1.00  0.00           N  
ATOM     53  CZ  ARG A   4      55.882 -33.520  -6.166  1.00  0.00           C  
ATOM     54  NH1 ARG A   4      55.072 -33.266  -5.141  1.00  0.00           N  
ATOM     55  NH2 ARG A   4      55.374 -33.897  -7.336  1.00  0.00           N  
ATOM     56  H   ARG A   4      58.662 -38.513  -4.047  1.00  0.00           H  
ATOM     57  HA  ARG A   4      59.727 -36.142  -2.889  1.00  0.00           H  
ATOM     58  HB2 ARG A   4      59.320 -35.086  -5.047  1.00  0.00           H  
ATOM     59  HB3 ARG A   4      57.734 -35.812  -5.184  1.00  0.00           H  
ATOM     60  HG2 ARG A   4      56.834 -34.427  -3.420  1.00  0.00           H  
ATOM     61  HG3 ARG A   4      58.425 -33.906  -2.914  1.00  0.00           H  
ATOM     62  HD2 ARG A   4      57.074 -32.209  -4.350  1.00  0.00           H  
ATOM     63  HD3 ARG A   4      58.720 -32.534  -4.910  1.00  0.00           H  
ATOM     64  HE  ARG A   4      57.829 -33.583  -6.787  1.00  0.00           H  
ATOM     65 HH11 ARG A   4      55.452 -32.980  -4.262  1.00  0.00           H  
ATOM     66 HH12 ARG A   4      54.082 -33.361  -5.251  1.00  0.00           H  
ATOM     67 HH21 ARG A   4      55.982 -34.086  -8.107  1.00  0.00           H  
ATOM     68 HH22 ARG A   4      54.384 -33.992  -7.445  1.00  0.00           H  
ATOM     69  N   ALA A   5      57.875 -36.170  -1.288  1.00  0.00           N  
ATOM     70  CA  ALA A   5      56.859 -36.371  -0.269  1.00  0.00           C  
ATOM     71  C   ALA A   5      55.659 -35.461  -0.548  1.00  0.00           C  
ATOM     72  O   ALA A   5      54.763 -35.794  -1.315  1.00  0.00           O  
ATOM     73  CB  ALA A   5      57.456 -36.080   1.108  1.00  0.00           C  
ATOM     74  H   ALA A   5      58.684 -35.615  -1.100  1.00  0.00           H  
ATOM     75  HA  ALA A   5      56.536 -37.414  -0.336  1.00  0.00           H  
ATOM     76  HB1 ALA A   5      58.306 -36.732   1.309  1.00  0.00           H  
ATOM     77  HB2 ALA A   5      57.803 -35.048   1.172  1.00  0.00           H  
ATOM     78  HB3 ALA A   5      56.717 -36.236   1.894  1.00  0.00           H  
ATOM     79  N   SER A   6      55.703 -34.295   0.124  1.00  0.00           N  
ATOM     80  CA  SER A   6      54.615 -33.350  -0.052  1.00  0.00           C  
ATOM     81  C   SER A   6      54.959 -32.368  -1.171  1.00  0.00           C  
ATOM     82  O   SER A   6      55.769 -32.641  -2.048  1.00  0.00           O  
ATOM     83  CB  SER A   6      54.373 -32.607   1.260  1.00  0.00           C  
ATOM     84  OG  SER A   6      53.209 -31.824   1.181  1.00  0.00           O  
ATOM     85  H   SER A   6      56.470 -34.086   0.732  1.00  0.00           H  
ATOM     86  HA  SER A   6      53.730 -33.924  -0.341  1.00  0.00           H  
ATOM     87  HB2 SER A   6      54.254 -33.308   2.086  1.00  0.00           H  
ATOM     88  HB3 SER A   6      55.210 -31.950   1.494  1.00  0.00           H  
ATOM     89  HG  SER A   6      53.108 -31.399   2.022  1.00  0.00           H  
ATOM     90  N   VAL A   7      54.286 -31.207  -1.072  1.00  0.00           N  
ATOM     91  CA  VAL A   7      54.514 -30.178  -2.073  1.00  0.00           C  
ATOM     92  C   VAL A   7      56.010 -30.053  -2.348  1.00  0.00           C  
ATOM     93  O   VAL A   7      56.850 -30.494  -1.573  1.00  0.00           O  
ATOM     94  CB  VAL A   7      53.945 -28.852  -1.573  1.00  0.00           C  
ATOM     95  CG1 VAL A   7      54.627 -28.432  -0.272  1.00  0.00           C  
ATOM     96  CG2 VAL A   7      54.113 -27.768  -2.636  1.00  0.00           C  
ATOM     97  H   VAL A   7      53.642 -31.055  -0.324  1.00  0.00           H  
ATOM     98  HA  VAL A   7      54.007 -30.497  -2.988  1.00  0.00           H  
ATOM     99  HB  VAL A   7      52.881 -28.988  -1.377  1.00  0.00           H  
ATOM    100 HG11 VAL A   7      55.701 -28.316  -0.414  1.00  0.00           H  
ATOM    101 HG12 VAL A   7      54.230 -27.480   0.085  1.00  0.00           H  
ATOM    102 HG13 VAL A   7      54.469 -29.176   0.509  1.00  0.00           H  
ATOM    103 HG21 VAL A   7      53.749 -28.115  -3.602  1.00  0.00           H  
ATOM    104 HG22 VAL A   7      53.557 -26.871  -2.367  1.00  0.00           H  
ATOM    105 HG23 VAL A   7      55.161 -27.492  -2.750  1.00  0.00           H  
ATOM    106  N   GLY A   8      56.280 -29.426  -3.508  1.00  0.00           N  
ATOM    107  CA  GLY A   8      57.665 -29.242  -3.890  1.00  0.00           C  
ATOM    108  C   GLY A   8      57.940 -27.792  -4.296  1.00  0.00           C  
ATOM    109  O   GLY A   8      58.554 -27.512  -5.317  1.00  0.00           O  
ATOM    110  H   GLY A   8      55.539 -29.093  -4.091  1.00  0.00           H  
ATOM    111  HA2 GLY A   8      58.284 -29.523  -3.037  1.00  0.00           H  
ATOM    112  HA3 GLY A   8      57.871 -29.916  -4.722  1.00  0.00           H  
ATOM    113  N   SER A   9      57.437 -26.896  -3.427  1.00  0.00           N  
ATOM    114  CA  SER A   9      57.634 -25.482  -3.693  1.00  0.00           C  
ATOM    115  C   SER A   9      56.923 -25.096  -4.989  1.00  0.00           C  
ATOM    116  O   SER A   9      57.002 -25.784  -6.000  1.00  0.00           O  
ATOM    117  CB  SER A   9      59.129 -25.191  -3.797  1.00  0.00           C  
ATOM    118  OG  SER A   9      59.785 -25.530  -2.602  1.00  0.00           O  
ATOM    119  H   SER A   9      56.935 -27.199  -2.615  1.00  0.00           H  
ATOM    120  HA  SER A   9      57.188 -24.928  -2.861  1.00  0.00           H  
ATOM    121  HB2 SER A   9      59.581 -25.764  -4.606  1.00  0.00           H  
ATOM    122  HB3 SER A   9      59.307 -24.136  -3.995  1.00  0.00           H  
ATOM    123  HG  SER A   9      60.699 -25.307  -2.721  1.00  0.00           H  
ATOM    124  N   HIS A  10      56.224 -23.951  -4.884  1.00  0.00           N  
ATOM    125  CA  HIS A  10      55.502 -23.467  -6.050  1.00  0.00           C  
ATOM    126  C   HIS A  10      56.196 -22.218  -6.590  1.00  0.00           C  
ATOM    127  O   HIS A  10      56.229 -21.170  -5.957  1.00  0.00           O  
ATOM    128  CB  HIS A  10      54.058 -23.156  -5.666  1.00  0.00           C  
ATOM    129  CG  HIS A  10      53.309 -24.449  -5.453  1.00  0.00           C  
ATOM    130  ND1 HIS A  10      52.392 -24.941  -6.314  1.00  0.00           N  
ATOM    131  CD2 HIS A  10      53.417 -25.343  -4.372  1.00  0.00           C  
ATOM    132  CE1 HIS A  10      51.951 -26.094  -5.783  1.00  0.00           C  
ATOM    133  NE2 HIS A  10      52.555 -26.358  -4.612  1.00  0.00           N  
ATOM    134  H   HIS A  10      56.202 -23.444  -4.023  1.00  0.00           H  
ATOM    135  HA  HIS A  10      55.543 -24.254  -6.807  1.00  0.00           H  
ATOM    136  HB2 HIS A  10      54.023 -22.562  -4.753  1.00  0.00           H  
ATOM    137  HB3 HIS A  10      53.568 -22.583  -6.454  1.00  0.00           H  
ATOM    138  HD1 HIS A  10      52.104 -24.536  -7.159  1.00  0.00           H  
ATOM    139  HD2 HIS A  10      54.066 -25.240  -3.514  1.00  0.00           H  
ATOM    140  HE1 HIS A  10      51.208 -26.729  -6.241  1.00  0.00           H  
ATOM    141  N   GLU A  11      56.742 -22.407  -7.802  1.00  0.00           N  
ATOM    142  CA  GLU A  11      57.438 -21.315  -8.439  1.00  0.00           C  
ATOM    143  C   GLU A  11      56.480 -20.150  -8.670  1.00  0.00           C  
ATOM    144  O   GLU A  11      56.634 -19.066  -8.122  1.00  0.00           O  
ATOM    145  CB  GLU A  11      57.990 -21.821  -9.761  1.00  0.00           C  
ATOM    146  CG  GLU A  11      59.436 -21.385  -9.969  1.00  0.00           C  
ATOM    147  CD  GLU A  11      59.500 -19.876 -10.209  1.00  0.00           C  
ATOM    148  OE1 GLU A  11      58.453 -19.231 -10.175  1.00  0.00           O  
ATOM    149  OE2 GLU A  11      60.596 -19.362 -10.426  1.00  0.00           O  
ATOM    150  H   GLU A  11      56.672 -23.289  -8.264  1.00  0.00           H  
ATOM    151  HA  GLU A  11      58.240 -21.001  -7.770  1.00  0.00           H  
ATOM    152  HB2 GLU A  11      57.933 -22.909  -9.785  1.00  0.00           H  
ATOM    153  HB3 GLU A  11      57.370 -21.460 -10.576  1.00  0.00           H  
ATOM    154  HG2 GLU A  11      60.037 -21.632  -9.094  1.00  0.00           H  
ATOM    155  HG3 GLU A  11      59.868 -21.899 -10.826  1.00  0.00           H  
ATOM    156  N   LYS A  12      55.492 -20.461  -9.524  1.00  0.00           N  
ATOM    157  CA  LYS A  12      54.493 -19.454  -9.861  1.00  0.00           C  
ATOM    158  C   LYS A  12      54.176 -18.581  -8.645  1.00  0.00           C  
ATOM    159  O   LYS A  12      53.395 -18.945  -7.776  1.00  0.00           O  
ATOM    160  CB  LYS A  12      53.229 -20.150 -10.361  1.00  0.00           C  
ATOM    161  CG  LYS A  12      53.528 -21.067 -11.548  1.00  0.00           C  
ATOM    162  CD  LYS A  12      52.263 -21.752 -12.064  1.00  0.00           C  
ATOM    163  CE  LYS A  12      51.326 -20.759 -12.752  1.00  0.00           C  
ATOM    164  NZ  LYS A  12      51.967 -20.069 -13.865  1.00  0.00           N  
ATOM    165  H   LYS A  12      55.448 -21.375  -9.926  1.00  0.00           H  
ATOM    166  HA  LYS A  12      54.922 -18.825 -10.647  1.00  0.00           H  
ATOM    167  HB2 LYS A  12      52.787 -20.732  -9.553  1.00  0.00           H  
ATOM    168  HB3 LYS A  12      52.490 -19.404 -10.652  1.00  0.00           H  
ATOM    169  HG2 LYS A  12      53.985 -20.490 -12.351  1.00  0.00           H  
ATOM    170  HG3 LYS A  12      54.256 -21.822 -11.250  1.00  0.00           H  
ATOM    171  HD2 LYS A  12      52.535 -22.542 -12.766  1.00  0.00           H  
ATOM    172  HD3 LYS A  12      51.743 -22.234 -11.237  1.00  0.00           H  
ATOM    173  HE2 LYS A  12      50.446 -21.271 -13.143  1.00  0.00           H  
ATOM    174  HE3 LYS A  12      50.983 -20.003 -12.047  1.00  0.00           H  
ATOM    175  HZ1 LYS A  12      52.324 -20.768 -14.547  1.00  0.00           H  
ATOM    176  HZ2 LYS A  12      51.275 -19.450 -14.334  1.00  0.00           H  
ATOM    177  HZ3 LYS A  12      52.758 -19.496 -13.509  1.00  0.00           H  
ATOM    178  N   MET A  13      54.833 -17.403  -8.669  1.00  0.00           N  
ATOM    179  CA  MET A  13      54.642 -16.443  -7.586  1.00  0.00           C  
ATOM    180  C   MET A  13      55.875 -15.541  -7.514  1.00  0.00           C  
ATOM    181  O   MET A  13      56.974 -15.922  -7.897  1.00  0.00           O  
ATOM    182  CB  MET A  13      54.443 -17.161  -6.253  1.00  0.00           C  
ATOM    183  CG  MET A  13      52.989 -17.088  -5.780  1.00  0.00           C  
ATOM    184  SD  MET A  13      52.843 -17.633  -4.071  1.00  0.00           S  
ATOM    185  CE  MET A  13      51.943 -19.163  -4.370  1.00  0.00           C  
ATOM    186  H   MET A  13      55.448 -17.189  -9.426  1.00  0.00           H  
ATOM    187  HA  MET A  13      53.766 -15.842  -7.838  1.00  0.00           H  
ATOM    188  HB2 MET A  13      54.753 -18.201  -6.341  1.00  0.00           H  
ATOM    189  HB3 MET A  13      55.087 -16.705  -5.502  1.00  0.00           H  
ATOM    190  HG2 MET A  13      52.622 -16.063  -5.855  1.00  0.00           H  
ATOM    191  HG3 MET A  13      52.349 -17.707  -6.406  1.00  0.00           H  
ATOM    192  HE1 MET A  13      52.450 -19.757  -5.131  1.00  0.00           H  
ATOM    193  HE2 MET A  13      51.882 -19.752  -3.454  1.00  0.00           H  
ATOM    194  HE3 MET A  13      50.932 -18.947  -4.714  1.00  0.00           H  
ATOM    195  N   PRO A  14      55.633 -14.313  -6.997  1.00  0.00           N  
ATOM    196  CA  PRO A  14      56.668 -13.313  -6.843  1.00  0.00           C  
ATOM    197  C   PRO A  14      57.470 -13.566  -5.579  1.00  0.00           C  
ATOM    198  O   PRO A  14      58.639 -13.926  -5.593  1.00  0.00           O  
ATOM    199  CB  PRO A  14      55.919 -11.996  -6.661  1.00  0.00           C  
ATOM    200  CG  PRO A  14      54.500 -12.378  -6.219  1.00  0.00           C  
ATOM    201  CD  PRO A  14      54.322 -13.860  -6.562  1.00  0.00           C  
ATOM    202  HA  PRO A  14      57.326 -13.300  -7.708  1.00  0.00           H  
ATOM    203  HB2 PRO A  14      56.405 -11.372  -5.911  1.00  0.00           H  
ATOM    204  HB3 PRO A  14      55.892 -11.436  -7.596  1.00  0.00           H  
ATOM    205  HG2 PRO A  14      54.373 -12.213  -5.150  1.00  0.00           H  
ATOM    206  HG3 PRO A  14      53.768 -11.777  -6.727  1.00  0.00           H  
ATOM    207  HD3 PRO A  14      53.994 -14.435  -5.695  1.00  0.00           H  
ATOM    208  HD2 PRO A  14      53.597 -13.989  -7.356  1.00  0.00           H  
ATOM    209  N   TRP A  15      56.715 -13.361  -4.490  1.00  0.00           N  
ATOM    210  CA  TRP A  15      57.302 -13.540  -3.166  1.00  0.00           C  
ATOM    211  C   TRP A  15      57.623 -15.017  -2.889  1.00  0.00           C  
ATOM    212  O   TRP A  15      57.916 -15.401  -1.763  1.00  0.00           O  
ATOM    213  CB  TRP A  15      56.353 -12.989  -2.083  1.00  0.00           C  
ATOM    214  CG  TRP A  15      54.913 -13.411  -2.343  1.00  0.00           C  
ATOM    215  CD1 TRP A  15      54.512 -14.490  -3.124  1.00  0.00           C  
ATOM    216  CD2 TRP A  15      53.726 -12.795  -1.838  1.00  0.00           C  
ATOM    217  NE1 TRP A  15      53.150 -14.576  -3.124  1.00  0.00           N  
ATOM    218  CE2 TRP A  15      52.619 -13.545  -2.342  1.00  0.00           C  
ATOM    219  CE3 TRP A  15      53.513 -11.695  -1.020  1.00  0.00           C  
ATOM    220  CZ2 TRP A  15      51.317 -13.186  -2.019  1.00  0.00           C  
ATOM    221  CZ3 TRP A  15      52.188 -11.317  -0.683  1.00  0.00           C  
ATOM    222  CH2 TRP A  15      51.090 -12.064  -1.184  1.00  0.00           C  
ATOM    223  H   TRP A  15      55.749 -13.087  -4.593  1.00  0.00           H  
ATOM    224  HA  TRP A  15      58.242 -12.978  -3.157  1.00  0.00           H  
ATOM    225  HB2 TRP A  15      56.654 -13.359  -1.109  1.00  0.00           H  
ATOM    226  HB3 TRP A  15      56.413 -11.904  -2.046  1.00  0.00           H  
ATOM    227  HD1 TRP A  15      55.179 -15.131  -3.672  1.00  0.00           H  
ATOM    228  HE1 TRP A  15      52.625 -15.253  -3.600  1.00  0.00           H  
ATOM    229  HE3 TRP A  15      54.351 -11.130  -0.641  1.00  0.00           H  
ATOM    230  HZ2 TRP A  15      50.485 -13.756  -2.402  1.00  0.00           H  
ATOM    231  HZ3 TRP A  15      52.016 -10.462  -0.047  1.00  0.00           H  
ATOM    232  HH2 TRP A  15      50.080 -11.776  -0.928  1.00  0.00           H  
ATOM    233  N   PHE A  16      57.550 -15.821  -3.970  1.00  0.00           N  
ATOM    234  CA  PHE A  16      57.868 -17.223  -3.799  1.00  0.00           C  
ATOM    235  C   PHE A  16      58.787 -17.680  -4.918  1.00  0.00           C  
ATOM    236  O   PHE A  16      58.357 -18.165  -5.957  1.00  0.00           O  
ATOM    237  CB  PHE A  16      56.605 -18.068  -3.792  1.00  0.00           C  
ATOM    238  CG  PHE A  16      56.901 -19.448  -3.262  1.00  0.00           C  
ATOM    239  CD1 PHE A  16      57.800 -20.303  -3.954  1.00  0.00           C  
ATOM    240  CD2 PHE A  16      56.311 -19.905  -2.057  1.00  0.00           C  
ATOM    241  CE1 PHE A  16      58.105 -21.584  -3.451  1.00  0.00           C  
ATOM    242  CE2 PHE A  16      56.618 -21.193  -1.556  1.00  0.00           C  
ATOM    243  CZ  PHE A  16      57.514 -22.031  -2.253  1.00  0.00           C  
ATOM    244  H   PHE A  16      57.280 -15.465  -4.860  1.00  0.00           H  
ATOM    245  HA  PHE A  16      58.398 -17.319  -2.846  1.00  0.00           H  
ATOM    246  HB2 PHE A  16      55.843 -17.592  -3.179  1.00  0.00           H  
ATOM    247  HB3 PHE A  16      56.204 -18.155  -4.801  1.00  0.00           H  
ATOM    248  HD1 PHE A  16      58.251 -19.978  -4.874  1.00  0.00           H  
ATOM    249  HD2 PHE A  16      55.624 -19.270  -1.519  1.00  0.00           H  
ATOM    250  HE1 PHE A  16      58.800 -22.222  -3.984  1.00  0.00           H  
ATOM    251  HE2 PHE A  16      56.167 -21.536  -0.641  1.00  0.00           H  
ATOM    252  HZ  PHE A  16      57.748 -23.012  -1.867  1.00  0.00           H  
ATOM    253  N   HIS A  17      60.078 -17.468  -4.642  1.00  0.00           N  
ATOM    254  CA  HIS A  17      61.062 -17.902  -5.601  1.00  0.00           C  
ATOM    255  C   HIS A  17      61.883 -19.013  -4.960  1.00  0.00           C  
ATOM    256  O   HIS A  17      62.637 -18.805  -4.018  1.00  0.00           O  
ATOM    257  CB  HIS A  17      61.957 -16.745  -6.003  1.00  0.00           C  
ATOM    258  CG  HIS A  17      61.296 -15.959  -7.112  1.00  0.00           C  
ATOM    259  ND1 HIS A  17      61.974 -15.231  -8.028  1.00  0.00           N  
ATOM    260  CD2 HIS A  17      59.922 -15.838  -7.387  1.00  0.00           C  
ATOM    261  CE1 HIS A  17      61.050 -14.683  -8.835  1.00  0.00           C  
ATOM    262  NE2 HIS A  17      59.805 -15.034  -8.470  1.00  0.00           N  
ATOM    263  H   HIS A  17      60.351 -17.004  -3.804  1.00  0.00           H  
ATOM    264  HA  HIS A  17      60.526 -18.302  -6.465  1.00  0.00           H  
ATOM    265  HB2 HIS A  17      62.148 -16.089  -5.154  1.00  0.00           H  
ATOM    266  HB3 HIS A  17      62.911 -17.126  -6.351  1.00  0.00           H  
ATOM    267  HD1 HIS A  17      62.946 -15.125  -8.090  1.00  0.00           H  
ATOM    268  HD2 HIS A  17      59.113 -16.298  -6.840  1.00  0.00           H  
ATOM    269  HE1 HIS A  17      61.280 -14.041  -9.674  1.00  0.00           H  
ATOM    270  N   GLY A  18      61.678 -20.201  -5.538  1.00  0.00           N  
ATOM    271  CA  GLY A  18      62.381 -21.355  -5.015  1.00  0.00           C  
ATOM    272  C   GLY A  18      63.732 -21.546  -5.716  1.00  0.00           C  
ATOM    273  O   GLY A  18      64.201 -22.657  -5.931  1.00  0.00           O  
ATOM    274  H   GLY A  18      61.077 -20.280  -6.328  1.00  0.00           H  
ATOM    275  HA2 GLY A  18      62.529 -21.192  -3.947  1.00  0.00           H  
ATOM    276  HA3 GLY A  18      61.738 -22.226  -5.157  1.00  0.00           H  
ATOM    277  N   LYS A  19      64.314 -20.378  -6.053  1.00  0.00           N  
ATOM    278  CA  LYS A  19      65.604 -20.401  -6.719  1.00  0.00           C  
ATOM    279  C   LYS A  19      66.563 -19.452  -5.995  1.00  0.00           C  
ATOM    280  O   LYS A  19      67.725 -19.762  -5.762  1.00  0.00           O  
ATOM    281  CB  LYS A  19      65.426 -19.978  -8.176  1.00  0.00           C  
ATOM    282  CG  LYS A  19      66.525 -20.551  -9.075  1.00  0.00           C  
ATOM    283  CD  LYS A  19      67.916 -20.097  -8.632  1.00  0.00           C  
ATOM    284  CE  LYS A  19      68.974 -20.422  -9.688  1.00  0.00           C  
ATOM    285  NZ  LYS A  19      69.095 -21.856  -9.929  1.00  0.00           N  
ATOM    286  H   LYS A  19      63.860 -19.511  -5.853  1.00  0.00           H  
ATOM    287  HA  LYS A  19      65.988 -21.423  -6.653  1.00  0.00           H  
ATOM    288  HB2 LYS A  19      64.453 -20.313  -8.535  1.00  0.00           H  
ATOM    289  HB3 LYS A  19      65.426 -18.890  -8.242  1.00  0.00           H  
ATOM    290  HG2 LYS A  19      66.475 -21.640  -9.064  1.00  0.00           H  
ATOM    291  HG3 LYS A  19      66.352 -20.240 -10.105  1.00  0.00           H  
ATOM    292  HD2 LYS A  19      67.908 -19.024  -8.441  1.00  0.00           H  
ATOM    293  HD3 LYS A  19      68.178 -20.583  -7.692  1.00  0.00           H  
ATOM    294  HE2 LYS A  19      68.726 -19.947 -10.637  1.00  0.00           H  
ATOM    295  HE3 LYS A  19      69.951 -20.054  -9.378  1.00  0.00           H  
ATOM    296  HZ1 LYS A  19      69.346 -22.336  -9.042  1.00  0.00           H  
ATOM    297  HZ2 LYS A  19      68.190 -22.226 -10.280  1.00  0.00           H  
ATOM    298  HZ3 LYS A  19      69.837 -22.025 -10.638  1.00  0.00           H  
ATOM    299  N   ILE A  20      65.993 -18.279  -5.651  1.00  0.00           N  
ATOM    300  CA  ILE A  20      66.799 -17.286  -4.953  1.00  0.00           C  
ATOM    301  C   ILE A  20      67.666 -17.977  -3.903  1.00  0.00           C  
ATOM    302  O   ILE A  20      67.441 -19.123  -3.530  1.00  0.00           O  
ATOM    303  CB  ILE A  20      65.895 -16.237  -4.300  1.00  0.00           C  
ATOM    304  CG1 ILE A  20      64.565 -16.860  -3.860  1.00  0.00           C  
ATOM    305  CG2 ILE A  20      65.644 -15.079  -5.264  1.00  0.00           C  
ATOM    306  CD1 ILE A  20      63.664 -15.837  -3.161  1.00  0.00           C  
ATOM    307  H   ILE A  20      65.035 -18.093  -5.872  1.00  0.00           H  
ATOM    308  HA  ILE A  20      67.452 -16.819  -5.696  1.00  0.00           H  
ATOM    309  HB  ILE A  20      66.406 -15.844  -3.420  1.00  0.00           H  
ATOM    310 HG12 ILE A  20      64.049 -17.267  -4.729  1.00  0.00           H  
ATOM    311 HG13 ILE A  20      64.758 -17.696  -3.188  1.00  0.00           H  
ATOM    312 HG21 ILE A  20      66.580 -14.731  -5.705  1.00  0.00           H  
ATOM    313 HG22 ILE A  20      64.984 -15.385  -6.076  1.00  0.00           H  
ATOM    314 HG23 ILE A  20      65.180 -14.237  -4.751  1.00  0.00           H  
ATOM    315 HD11 ILE A  20      63.616 -14.907  -3.728  1.00  0.00           H  
ATOM    316 HD12 ILE A  20      62.649 -16.220  -3.055  1.00  0.00           H  
ATOM    317 HD13 ILE A  20      64.040 -15.604  -2.165  1.00  0.00           H  
ATOM    318  N   SER A  21      68.669 -17.201  -3.453  1.00  0.00           N  
ATOM    319  CA  SER A  21      69.571 -17.746  -2.456  1.00  0.00           C  
ATOM    320  C   SER A  21      68.972 -17.561  -1.067  1.00  0.00           C  
ATOM    321  O   SER A  21      68.518 -18.491  -0.415  1.00  0.00           O  
ATOM    322  CB  SER A  21      70.920 -17.038  -2.555  1.00  0.00           C  
ATOM    323  OG  SER A  21      71.841 -17.593  -1.650  1.00  0.00           O  
ATOM    324  H   SER A  21      68.786 -16.267  -3.796  1.00  0.00           H  
ATOM    325  HA  SER A  21      69.681 -18.803  -2.662  1.00  0.00           H  
ATOM    326  HB2 SER A  21      71.334 -17.128  -3.559  1.00  0.00           H  
ATOM    327  HB3 SER A  21      70.820 -15.977  -2.328  1.00  0.00           H  
ATOM    328  HG  SER A  21      72.632 -17.076  -1.716  1.00  0.00           H  
ATOM    329  N   ARG A  22      69.013 -16.283  -0.688  1.00  0.00           N  
ATOM    330  CA  ARG A  22      68.505 -15.872   0.611  1.00  0.00           C  
ATOM    331  C   ARG A  22      68.814 -14.381   0.752  1.00  0.00           C  
ATOM    332  O   ARG A  22      68.014 -13.579   1.218  1.00  0.00           O  
ATOM    333  CB  ARG A  22      69.174 -16.677   1.725  1.00  0.00           C  
ATOM    334  CG  ARG A  22      68.470 -16.467   3.066  1.00  0.00           C  
ATOM    335  CD  ARG A  22      68.822 -17.570   4.065  1.00  0.00           C  
ATOM    336  NE  ARG A  22      70.252 -17.584   4.318  1.00  0.00           N  
ATOM    337  CZ  ARG A  22      70.800 -18.688   4.860  1.00  0.00           C  
ATOM    338  NH1 ARG A  22      70.036 -19.741   5.147  1.00  0.00           N  
ATOM    339  NH2 ARG A  22      72.105 -18.728   5.107  1.00  0.00           N  
ATOM    340  H   ARG A  22      69.402 -15.599  -1.305  1.00  0.00           H  
ATOM    341  HA  ARG A  22      67.423 -16.023   0.605  1.00  0.00           H  
ATOM    342  HB2 ARG A  22      69.163 -17.735   1.470  1.00  0.00           H  
ATOM    343  HB3 ARG A  22      70.220 -16.385   1.811  1.00  0.00           H  
ATOM    344  HG2 ARG A  22      68.748 -15.497   3.478  1.00  0.00           H  
ATOM    345  HG3 ARG A  22      67.391 -16.446   2.912  1.00  0.00           H  
ATOM    346  HD2 ARG A  22      68.332 -17.416   5.024  1.00  0.00           H  
ATOM    347  HD3 ARG A  22      68.548 -18.556   3.687  1.00  0.00           H  
ATOM    348  HE  ARG A  22      70.817 -16.791   4.097  1.00  0.00           H  
ATOM    349 HH11 ARG A  22      69.055 -19.713   4.960  1.00  0.00           H  
ATOM    350 HH12 ARG A  22      70.445 -20.559   5.549  1.00  0.00           H  
ATOM    351 HH21 ARG A  22      72.680 -17.938   4.892  1.00  0.00           H  
ATOM    352 HH22 ARG A  22      72.513 -19.547   5.511  1.00  0.00           H  
ATOM    353  N   GLU A  23      70.042 -14.088   0.287  1.00  0.00           N  
ATOM    354  CA  GLU A  23      70.503 -12.731   0.284  1.00  0.00           C  
ATOM    355  C   GLU A  23      69.827 -12.022  -0.878  1.00  0.00           C  
ATOM    356  O   GLU A  23      69.322 -10.915  -0.776  1.00  0.00           O  
ATOM    357  CB  GLU A  23      72.015 -12.766   0.096  1.00  0.00           C  
ATOM    358  CG  GLU A  23      72.442 -12.689  -1.368  1.00  0.00           C  
ATOM    359  CD  GLU A  23      73.963 -12.548  -1.458  1.00  0.00           C  
ATOM    360  OE1 GLU A  23      74.660 -13.182  -0.668  1.00  0.00           O  
ATOM    361  OE2 GLU A  23      74.433 -11.803  -2.318  1.00  0.00           O  
ATOM    362  H   GLU A  23      70.628 -14.806  -0.083  1.00  0.00           H  
ATOM    363  HA  GLU A  23      70.214 -12.274   1.232  1.00  0.00           H  
ATOM    364  HB2 GLU A  23      72.464 -11.955   0.645  1.00  0.00           H  
ATOM    365  HB3 GLU A  23      72.392 -13.689   0.514  1.00  0.00           H  
ATOM    366  HG2 GLU A  23      72.137 -13.586  -1.905  1.00  0.00           H  
ATOM    367  HG3 GLU A  23      71.981 -11.839  -1.854  1.00  0.00           H  
ATOM    368  N   GLU A  24      69.870 -12.770  -1.986  1.00  0.00           N  
ATOM    369  CA  GLU A  24      69.264 -12.275  -3.206  1.00  0.00           C  
ATOM    370  C   GLU A  24      67.854 -11.735  -2.912  1.00  0.00           C  
ATOM    371  O   GLU A  24      67.419 -10.723  -3.452  1.00  0.00           O  
ATOM    372  CB  GLU A  24      69.208 -13.417  -4.213  1.00  0.00           C  
ATOM    373  CG  GLU A  24      70.573 -14.088  -4.363  1.00  0.00           C  
ATOM    374  CD  GLU A  24      71.522 -13.170  -5.137  1.00  0.00           C  
ATOM    375  OE1 GLU A  24      71.125 -12.049  -5.454  1.00  0.00           O  
ATOM    376  OE2 GLU A  24      72.646 -13.584  -5.413  1.00  0.00           O  
ATOM    377  H   GLU A  24      70.350 -13.661  -1.965  1.00  0.00           H  
ATOM    378  HA  GLU A  24      69.894 -11.464  -3.576  1.00  0.00           H  
ATOM    379  HB2 GLU A  24      68.469 -14.151  -3.894  1.00  0.00           H  
ATOM    380  HB3 GLU A  24      68.880 -13.038  -5.177  1.00  0.00           H  
ATOM    381  HG2 GLU A  24      71.006 -14.301  -3.385  1.00  0.00           H  
ATOM    382  HG3 GLU A  24      70.481 -15.034  -4.898  1.00  0.00           H  
ATOM    383  N   SER A  25      67.178 -12.477  -2.015  1.00  0.00           N  
ATOM    384  CA  SER A  25      65.822 -12.080  -1.657  1.00  0.00           C  
ATOM    385  C   SER A  25      65.827 -10.944  -0.619  1.00  0.00           C  
ATOM    386  O   SER A  25      64.871 -10.188  -0.495  1.00  0.00           O  
ATOM    387  CB  SER A  25      65.083 -13.295  -1.106  1.00  0.00           C  
ATOM    388  OG  SER A  25      65.437 -13.527   0.234  1.00  0.00           O  
ATOM    389  H   SER A  25      67.598 -13.285  -1.606  1.00  0.00           H  
ATOM    390  HA  SER A  25      65.338 -11.720  -2.569  1.00  0.00           H  
ATOM    391  HB2 SER A  25      64.005 -13.150  -1.153  1.00  0.00           H  
ATOM    392  HB3 SER A  25      65.329 -14.188  -1.680  1.00  0.00           H  
ATOM    393  HG  SER A  25      64.803 -13.065   0.766  1.00  0.00           H  
ATOM    394  N   GLU A  26      66.956 -10.875   0.112  1.00  0.00           N  
ATOM    395  CA  GLU A  26      67.075  -9.860   1.129  1.00  0.00           C  
ATOM    396  C   GLU A  26      67.586  -8.535   0.528  1.00  0.00           C  
ATOM    397  O   GLU A  26      67.447  -7.468   1.117  1.00  0.00           O  
ATOM    398  CB  GLU A  26      68.024 -10.408   2.188  1.00  0.00           C  
ATOM    399  CG  GLU A  26      68.961  -9.338   2.718  1.00  0.00           C  
ATOM    400  CD  GLU A  26      69.939  -9.949   3.724  1.00  0.00           C  
ATOM    401  OE1 GLU A  26      69.814 -11.137   4.017  1.00  0.00           O  
ATOM    402  OE2 GLU A  26      70.814  -9.229   4.204  1.00  0.00           O  
ATOM    403  H   GLU A  26      67.706 -11.505  -0.038  1.00  0.00           H  
ATOM    404  HA  GLU A  26      66.076  -9.699   1.543  1.00  0.00           H  
ATOM    405  HB2 GLU A  26      67.449 -10.840   2.998  1.00  0.00           H  
ATOM    406  HB3 GLU A  26      68.612 -11.219   1.760  1.00  0.00           H  
ATOM    407  HG2 GLU A  26      69.521  -8.909   1.895  1.00  0.00           H  
ATOM    408  HG3 GLU A  26      68.403  -8.537   3.201  1.00  0.00           H  
ATOM    409  N   GLN A  27      68.160  -8.667  -0.683  1.00  0.00           N  
ATOM    410  CA  GLN A  27      68.653  -7.470  -1.345  1.00  0.00           C  
ATOM    411  C   GLN A  27      67.462  -6.851  -2.067  1.00  0.00           C  
ATOM    412  O   GLN A  27      67.388  -5.657  -2.312  1.00  0.00           O  
ATOM    413  CB  GLN A  27      69.786  -7.808  -2.316  1.00  0.00           C  
ATOM    414  CG  GLN A  27      69.294  -8.628  -3.505  1.00  0.00           C  
ATOM    415  CD  GLN A  27      70.255  -8.459  -4.685  1.00  0.00           C  
ATOM    416  OE1 GLN A  27      71.048  -9.336  -5.005  1.00  0.00           O  
ATOM    417  NE2 GLN A  27      70.125  -7.271  -5.303  1.00  0.00           N  
ATOM    418  H   GLN A  27      68.159  -9.547  -1.154  1.00  0.00           H  
ATOM    419  HA  GLN A  27      68.999  -6.784  -0.569  1.00  0.00           H  
ATOM    420  HB2 GLN A  27      70.244  -6.888  -2.677  1.00  0.00           H  
ATOM    421  HB3 GLN A  27      70.565  -8.359  -1.791  1.00  0.00           H  
ATOM    422  HG2 GLN A  27      69.238  -9.679  -3.242  1.00  0.00           H  
ATOM    423  HG3 GLN A  27      68.301  -8.308  -3.810  1.00  0.00           H  
ATOM    424 HE21 GLN A  27      69.453  -6.602  -4.985  1.00  0.00           H  
ATOM    425 HE22 GLN A  27      70.697  -7.039  -6.089  1.00  0.00           H  
ATOM    426  N   ILE A  28      66.529  -7.764  -2.383  1.00  0.00           N  
ATOM    427  CA  ILE A  28      65.333  -7.338  -3.010  1.00  0.00           C  
ATOM    428  C   ILE A  28      64.531  -6.522  -2.004  1.00  0.00           C  
ATOM    429  O   ILE A  28      63.909  -5.517  -2.320  1.00  0.00           O  
ATOM    430  CB  ILE A  28      64.599  -8.595  -3.415  1.00  0.00           C  
ATOM    431  CG1 ILE A  28      65.246  -9.238  -4.632  1.00  0.00           C  
ATOM    432  CG2 ILE A  28      63.143  -8.302  -3.697  1.00  0.00           C  
ATOM    433  CD1 ILE A  28      64.827 -10.700  -4.758  1.00  0.00           C  
ATOM    434  H   ILE A  28      66.662  -8.739  -2.183  1.00  0.00           H  
ATOM    435  HA  ILE A  28      65.611  -6.715  -3.848  1.00  0.00           H  
ATOM    436  HB  ILE A  28      64.670  -9.299  -2.579  1.00  0.00           H  
ATOM    437 HG12 ILE A  28      64.959  -8.693  -5.529  1.00  0.00           H  
ATOM    438 HG13 ILE A  28      66.331  -9.170  -4.551  1.00  0.00           H  
ATOM    439 HG21 ILE A  28      62.709  -7.695  -2.909  1.00  0.00           H  
ATOM    440 HG22 ILE A  28      63.037  -7.765  -4.637  1.00  0.00           H  
ATOM    441 HG23 ILE A  28      62.576  -9.225  -3.766  1.00  0.00           H  
ATOM    442 HD11 ILE A  28      63.989 -10.919  -4.094  1.00  0.00           H  
ATOM    443 HD12 ILE A  28      64.519 -10.932  -5.775  1.00  0.00           H  
ATOM    444 HD13 ILE A  28      65.648 -11.364  -4.492  1.00  0.00           H  
ATOM    445  N   VAL A  29      64.569  -7.048  -0.775  1.00  0.00           N  
ATOM    446  CA  VAL A  29      63.893  -6.343   0.290  1.00  0.00           C  
ATOM    447  C   VAL A  29      64.545  -4.980   0.466  1.00  0.00           C  
ATOM    448  O   VAL A  29      63.926  -4.019   0.898  1.00  0.00           O  
ATOM    449  CB  VAL A  29      64.024  -7.165   1.581  1.00  0.00           C  
ATOM    450  CG1 VAL A  29      64.275  -6.265   2.794  1.00  0.00           C  
ATOM    451  CG2 VAL A  29      62.790  -8.039   1.825  1.00  0.00           C  
ATOM    452  H   VAL A  29      65.057  -7.910  -0.602  1.00  0.00           H  
ATOM    453  HA  VAL A  29      62.861  -6.188  -0.028  1.00  0.00           H  
ATOM    454  HB  VAL A  29      64.893  -7.817   1.466  1.00  0.00           H  
ATOM    455 HG11 VAL A  29      65.156  -5.643   2.643  1.00  0.00           H  
ATOM    456 HG12 VAL A  29      63.425  -5.608   2.975  1.00  0.00           H  
ATOM    457 HG13 VAL A  29      64.441  -6.861   3.688  1.00  0.00           H  
ATOM    458 HG21 VAL A  29      61.918  -7.639   1.312  1.00  0.00           H  
ATOM    459 HG22 VAL A  29      62.957  -9.057   1.470  1.00  0.00           H  
ATOM    460 HG23 VAL A  29      62.559  -8.093   2.889  1.00  0.00           H  
ATOM    461  N   LEU A  30      65.831  -4.971   0.117  1.00  0.00           N  
ATOM    462  CA  LEU A  30      66.560  -3.758   0.223  1.00  0.00           C  
ATOM    463  C   LEU A  30      65.893  -2.719  -0.677  1.00  0.00           C  
ATOM    464  O   LEU A  30      65.826  -1.533  -0.376  1.00  0.00           O  
ATOM    465  CB  LEU A  30      67.975  -4.090  -0.229  1.00  0.00           C  
ATOM    466  CG  LEU A  30      68.335  -3.466  -1.565  1.00  0.00           C  
ATOM    467  CD1 LEU A  30      68.750  -2.016  -1.391  1.00  0.00           C  
ATOM    468  CD2 LEU A  30      69.438  -4.256  -2.234  1.00  0.00           C  
ATOM    469  H   LEU A  30      66.278  -5.783  -0.273  1.00  0.00           H  
ATOM    470  HA  LEU A  30      66.522  -3.437   1.269  1.00  0.00           H  
ATOM    471  HB2 LEU A  30      68.679  -3.793   0.530  1.00  0.00           H  
ATOM    472  HB3 LEU A  30      68.058  -5.164  -0.325  1.00  0.00           H  
ATOM    473  HG  LEU A  30      67.467  -3.515  -2.204  1.00  0.00           H  
ATOM    474 HD11 LEU A  30      67.959  -1.443  -0.908  1.00  0.00           H  
ATOM    475 HD12 LEU A  30      69.646  -1.944  -0.774  1.00  0.00           H  
ATOM    476 HD13 LEU A  30      68.963  -1.556  -2.355  1.00  0.00           H  
ATOM    477 HD21 LEU A  30      69.445  -5.280  -1.872  1.00  0.00           H  
ATOM    478 HD22 LEU A  30      69.287  -4.279  -3.314  1.00  0.00           H  
ATOM    479 HD23 LEU A  30      70.407  -3.813  -2.033  1.00  0.00           H  
ATOM    480  N   ILE A  31      65.405  -3.273  -1.804  1.00  0.00           N  
ATOM    481  CA  ILE A  31      64.752  -2.439  -2.766  1.00  0.00           C  
ATOM    482  C   ILE A  31      63.515  -1.845  -2.151  1.00  0.00           C  
ATOM    483  O   ILE A  31      63.382  -0.647  -1.929  1.00  0.00           O  
ATOM    484  CB  ILE A  31      64.293  -3.259  -3.970  1.00  0.00           C  
ATOM    485  CG1 ILE A  31      65.135  -4.495  -4.217  1.00  0.00           C  
ATOM    486  CG2 ILE A  31      64.261  -2.388  -5.184  1.00  0.00           C  
ATOM    487  CD1 ILE A  31      66.156  -4.286  -5.337  1.00  0.00           C  
ATOM    488  H   ILE A  31      65.528  -4.259  -1.982  1.00  0.00           H  
ATOM    489  HA  ILE A  31      65.451  -1.649  -3.058  1.00  0.00           H  
ATOM    490  HB  ILE A  31      63.275  -3.593  -3.793  1.00  0.00           H  
ATOM    491 HG12 ILE A  31      65.637  -4.800  -3.313  1.00  0.00           H  
ATOM    492 HG13 ILE A  31      64.460  -5.304  -4.474  1.00  0.00           H  
ATOM    493 HG21 ILE A  31      63.610  -1.531  -5.010  1.00  0.00           H  
ATOM    494 HG22 ILE A  31      65.255  -2.023  -5.416  1.00  0.00           H  
ATOM    495 HG23 ILE A  31      63.881  -2.940  -6.036  1.00  0.00           H  
ATOM    496 HD11 ILE A  31      65.661  -4.016  -6.270  1.00  0.00           H  
ATOM    497 HD12 ILE A  31      66.854  -3.488  -5.083  1.00  0.00           H  
ATOM    498 HD13 ILE A  31      66.732  -5.194  -5.513  1.00  0.00           H  
ATOM    499  N   GLY A  32      62.622  -2.802  -1.903  1.00  0.00           N  
ATOM    500  CA  GLY A  32      61.336  -2.426  -1.377  1.00  0.00           C  
ATOM    501  C   GLY A  32      61.297  -2.441   0.149  1.00  0.00           C  
ATOM    502  O   GLY A  32      62.313  -2.405   0.828  1.00  0.00           O  
ATOM    503  H   GLY A  32      62.861  -3.781  -2.096  1.00  0.00           H  
ATOM    504  HA2 GLY A  32      61.119  -1.426  -1.749  1.00  0.00           H  
ATOM    505  HA3 GLY A  32      60.615  -3.121  -1.796  1.00  0.00           H  
ATOM    506  N   SER A  33      60.042  -2.470   0.631  1.00  0.00           N  
ATOM    507  CA  SER A  33      59.840  -2.482   2.067  1.00  0.00           C  
ATOM    508  C   SER A  33      60.160  -1.106   2.633  1.00  0.00           C  
ATOM    509  O   SER A  33      61.253  -0.574   2.487  1.00  0.00           O  
ATOM    510  CB  SER A  33      60.717  -3.549   2.705  1.00  0.00           C  
ATOM    511  OG  SER A  33      60.308  -3.789   4.028  1.00  0.00           O  
ATOM    512  H   SER A  33      59.262  -2.476   0.008  1.00  0.00           H  
ATOM    513  HA  SER A  33      58.780  -2.696   2.241  1.00  0.00           H  
ATOM    514  HB2 SER A  33      60.655  -4.486   2.154  1.00  0.00           H  
ATOM    515  HB3 SER A  33      61.759  -3.237   2.722  1.00  0.00           H  
ATOM    516  HG  SER A  33      60.548  -3.021   4.530  1.00  0.00           H  
ATOM    517  N   LYS A  34      59.120  -0.584   3.294  1.00  0.00           N  
ATOM    518  CA  LYS A  34      59.240   0.735   3.887  1.00  0.00           C  
ATOM    519  C   LYS A  34      58.340   0.827   5.100  1.00  0.00           C  
ATOM    520  O   LYS A  34      58.701   1.319   6.161  1.00  0.00           O  
ATOM    521  CB  LYS A  34      58.762   1.767   2.872  1.00  0.00           C  
ATOM    522  CG  LYS A  34      59.599   1.723   1.605  1.00  0.00           C  
ATOM    523  CD  LYS A  34      59.684   3.093   0.930  1.00  0.00           C  
ATOM    524  CE  LYS A  34      60.506   4.079   1.761  1.00  0.00           C  
ATOM    525  NZ  LYS A  34      60.687   5.359   1.087  1.00  0.00           N  
ATOM    526  H   LYS A  34      58.267  -1.100   3.377  1.00  0.00           H  
ATOM    527  HA  LYS A  34      60.284   0.893   4.174  1.00  0.00           H  
ATOM    528  HB2 LYS A  34      57.720   1.569   2.621  1.00  0.00           H  
ATOM    529  HB3 LYS A  34      58.789   2.761   3.315  1.00  0.00           H  
ATOM    530  HG2 LYS A  34      60.598   1.368   1.846  1.00  0.00           H  
ATOM    531  HG3 LYS A  34      59.164   0.998   0.915  1.00  0.00           H  
ATOM    532  HD2 LYS A  34      60.132   2.987  -0.058  1.00  0.00           H  
ATOM    533  HD3 LYS A  34      58.680   3.490   0.778  1.00  0.00           H  
ATOM    534  HE2 LYS A  34      60.019   4.273   2.718  1.00  0.00           H  
ATOM    535  HE3 LYS A  34      61.496   3.671   1.971  1.00  0.00           H  
ATOM    536  HZ1 LYS A  34      59.758   5.788   0.904  1.00  0.00           H  
ATOM    537  HZ2 LYS A  34      61.249   5.992   1.692  1.00  0.00           H  
ATOM    538  HZ3 LYS A  34      61.184   5.208   0.186  1.00  0.00           H  
ATOM    539  N   THR A  35      57.138   0.309   4.841  1.00  0.00           N  
ATOM    540  CA  THR A  35      56.115   0.348   5.848  1.00  0.00           C  
ATOM    541  C   THR A  35      56.216  -0.820   6.831  1.00  0.00           C  
ATOM    542  O   THR A  35      55.385  -1.000   7.713  1.00  0.00           O  
ATOM    543  CB  THR A  35      54.792   0.311   5.122  1.00  0.00           C  
ATOM    544  OG1 THR A  35      54.982  -0.131   3.798  1.00  0.00           O  
ATOM    545  CG2 THR A  35      54.127   1.681   5.116  1.00  0.00           C  
ATOM    546  H   THR A  35      56.953  -0.125   3.957  1.00  0.00           H  
ATOM    547  HA  THR A  35      56.241   1.275   6.396  1.00  0.00           H  
ATOM    548  HB  THR A  35      54.163  -0.412   5.596  1.00  0.00           H  
ATOM    549  HG1 THR A  35      55.439   0.562   3.342  1.00  0.00           H  
ATOM    550 HG21 THR A  35      54.770   2.417   4.627  1.00  0.00           H  
ATOM    551 HG22 THR A  35      53.182   1.654   4.580  1.00  0.00           H  
ATOM    552 HG23 THR A  35      53.936   2.027   6.130  1.00  0.00           H  
ATOM    553  N   ASN A  36      57.270  -1.587   6.597  1.00  0.00           N  
ATOM    554  CA  ASN A  36      57.528  -2.736   7.445  1.00  0.00           C  
ATOM    555  C   ASN A  36      56.423  -3.772   7.250  1.00  0.00           C  
ATOM    556  O   ASN A  36      55.740  -4.178   8.182  1.00  0.00           O  
ATOM    557  CB  ASN A  36      57.618  -2.287   8.907  1.00  0.00           C  
ATOM    558  CG  ASN A  36      57.544  -3.494   9.846  1.00  0.00           C  
ATOM    559  OD1 ASN A  36      57.060  -3.407  10.967  1.00  0.00           O  
ATOM    560  ND2 ASN A  36      58.058  -4.617   9.313  1.00  0.00           N  
ATOM    561  H   ASN A  36      57.856  -1.369   5.830  1.00  0.00           H  
ATOM    562  HA  ASN A  36      58.478  -3.170   7.119  1.00  0.00           H  
ATOM    563  HB2 ASN A  36      58.553  -1.760   9.086  1.00  0.00           H  
ATOM    564  HB3 ASN A  36      56.805  -1.606   9.150  1.00  0.00           H  
ATOM    565 HD21 ASN A  36      58.440  -4.616   8.389  1.00  0.00           H  
ATOM    566 HD22 ASN A  36      58.067  -5.472   9.832  1.00  0.00           H  
ATOM    567  N   GLY A  37      56.296  -4.161   5.969  1.00  0.00           N  
ATOM    568  CA  GLY A  37      55.290  -5.157   5.642  1.00  0.00           C  
ATOM    569  C   GLY A  37      55.680  -6.004   4.422  1.00  0.00           C  
ATOM    570  O   GLY A  37      54.895  -6.801   3.932  1.00  0.00           O  
ATOM    571  H   GLY A  37      56.876  -3.766   5.257  1.00  0.00           H  
ATOM    572  HA2 GLY A  37      55.167  -5.794   6.518  1.00  0.00           H  
ATOM    573  HA3 GLY A  37      54.353  -4.639   5.449  1.00  0.00           H  
ATOM    574  N   LYS A  38      56.930  -5.795   3.961  1.00  0.00           N  
ATOM    575  CA  LYS A  38      57.351  -6.565   2.812  1.00  0.00           C  
ATOM    576  C   LYS A  38      57.916  -7.885   3.296  1.00  0.00           C  
ATOM    577  O   LYS A  38      58.474  -7.992   4.379  1.00  0.00           O  
ATOM    578  CB  LYS A  38      58.394  -5.813   2.007  1.00  0.00           C  
ATOM    579  CG  LYS A  38      58.430  -6.325   0.569  1.00  0.00           C  
ATOM    580  CD  LYS A  38      59.459  -5.580  -0.270  1.00  0.00           C  
ATOM    581  CE  LYS A  38      58.816  -4.968  -1.512  1.00  0.00           C  
ATOM    582  NZ  LYS A  38      58.358  -3.603  -1.290  1.00  0.00           N  
ATOM    583  H   LYS A  38      57.555  -5.153   4.409  1.00  0.00           H  
ATOM    584  HA  LYS A  38      56.461  -6.755   2.206  1.00  0.00           H  
ATOM    585  HB2 LYS A  38      58.173  -4.746   2.016  1.00  0.00           H  
ATOM    586  HB3 LYS A  38      59.370  -5.944   2.467  1.00  0.00           H  
ATOM    587  HG2 LYS A  38      58.659  -7.391   0.567  1.00  0.00           H  
ATOM    588  HG3 LYS A  38      57.444  -6.216   0.120  1.00  0.00           H  
ATOM    589  HD2 LYS A  38      59.924  -4.798   0.327  1.00  0.00           H  
ATOM    590  HD3 LYS A  38      60.252  -6.264  -0.566  1.00  0.00           H  
ATOM    591  HE2 LYS A  38      59.524  -4.949  -2.339  1.00  0.00           H  
ATOM    592  HE3 LYS A  38      57.955  -5.558  -1.826  1.00  0.00           H  
ATOM    593  HZ1 LYS A  38      59.166  -3.007  -1.017  1.00  0.00           H  
ATOM    594  HZ2 LYS A  38      57.935  -3.232  -2.165  1.00  0.00           H  
ATOM    595  HZ3 LYS A  38      57.649  -3.594  -0.531  1.00  0.00           H  
ATOM    596  N   PHE A  39      57.738  -8.879   2.421  1.00  0.00           N  
ATOM    597  CA  PHE A  39      58.230 -10.192   2.794  1.00  0.00           C  
ATOM    598  C   PHE A  39      58.383 -11.088   1.570  1.00  0.00           C  
ATOM    599  O   PHE A  39      58.013 -10.748   0.457  1.00  0.00           O  
ATOM    600  CB  PHE A  39      57.262 -10.827   3.797  1.00  0.00           C  
ATOM    601  CG  PHE A  39      56.055 -11.420   3.121  1.00  0.00           C  
ATOM    602  CD1 PHE A  39      54.994 -10.597   2.670  1.00  0.00           C  
ATOM    603  CD2 PHE A  39      55.971 -12.819   2.936  1.00  0.00           C  
ATOM    604  CE1 PHE A  39      53.863 -11.172   2.042  1.00  0.00           C  
ATOM    605  CE2 PHE A  39      54.843 -13.394   2.311  1.00  0.00           C  
ATOM    606  CZ  PHE A  39      53.790 -12.571   1.864  1.00  0.00           C  
ATOM    607  H   PHE A  39      57.297  -8.709   1.537  1.00  0.00           H  
ATOM    608  HA  PHE A  39      59.213 -10.045   3.250  1.00  0.00           H  
ATOM    609  HB2 PHE A  39      57.768 -11.620   4.346  1.00  0.00           H  
ATOM    610  HB3 PHE A  39      56.934 -10.087   4.526  1.00  0.00           H  
ATOM    611  HD1 PHE A  39      55.048  -9.526   2.805  1.00  0.00           H  
ATOM    612  HD2 PHE A  39      56.780 -13.449   3.269  1.00  0.00           H  
ATOM    613  HE1 PHE A  39      53.057 -10.541   1.699  1.00  0.00           H  
ATOM    614  HE2 PHE A  39      54.787 -14.464   2.177  1.00  0.00           H  
ATOM    615  HZ  PHE A  39      52.926 -13.010   1.387  1.00  0.00           H  
ATOM    616  N   LEU A  40      58.939 -12.269   1.883  1.00  0.00           N  
ATOM    617  CA  LEU A  40      59.113 -13.255   0.838  1.00  0.00           C  
ATOM    618  C   LEU A  40      59.426 -14.607   1.464  1.00  0.00           C  
ATOM    619  O   LEU A  40      60.122 -14.713   2.466  1.00  0.00           O  
ATOM    620  CB  LEU A  40      60.231 -12.818  -0.090  1.00  0.00           C  
ATOM    621  CG  LEU A  40      61.596 -12.897   0.594  1.00  0.00           C  
ATOM    622  CD1 LEU A  40      62.228 -14.273   0.387  1.00  0.00           C  
ATOM    623  CD2 LEU A  40      62.521 -11.810   0.054  1.00  0.00           C  
ATOM    624  H   LEU A  40      59.258 -12.449   2.816  1.00  0.00           H  
ATOM    625  HA  LEU A  40      58.166 -13.322   0.297  1.00  0.00           H  
ATOM    626  HB2 LEU A  40      60.231 -13.432  -0.989  1.00  0.00           H  
ATOM    627  HB3 LEU A  40      60.040 -11.800  -0.408  1.00  0.00           H  
ATOM    628  HG  LEU A  40      61.455 -12.736   1.663  1.00  0.00           H  
ATOM    629 HD11 LEU A  40      62.214 -14.552  -0.666  1.00  0.00           H  
ATOM    630 HD12 LEU A  40      63.265 -14.277   0.723  1.00  0.00           H  
ATOM    631 HD13 LEU A  40      61.693 -15.038   0.945  1.00  0.00           H  
ATOM    632 HD21 LEU A  40      62.523 -11.809  -1.037  1.00  0.00           H  
ATOM    633 HD22 LEU A  40      62.203 -10.826   0.392  1.00  0.00           H  
ATOM    634 HD23 LEU A  40      63.544 -11.968   0.392  1.00  0.00           H  
ATOM    635  N   ILE A  41      58.859 -15.626   0.805  1.00  0.00           N  
ATOM    636  CA  ILE A  41      59.080 -16.971   1.290  1.00  0.00           C  
ATOM    637  C   ILE A  41      59.961 -17.718   0.294  1.00  0.00           C  
ATOM    638  O   ILE A  41      59.859 -17.545  -0.914  1.00  0.00           O  
ATOM    639  CB  ILE A  41      57.741 -17.671   1.457  1.00  0.00           C  
ATOM    640  CG1 ILE A  41      57.921 -19.003   2.180  1.00  0.00           C  
ATOM    641  CG2 ILE A  41      57.088 -17.891   0.095  1.00  0.00           C  
ATOM    642  CD1 ILE A  41      58.755 -18.847   3.452  1.00  0.00           C  
ATOM    643  H   ILE A  41      58.296 -15.461  -0.005  1.00  0.00           H  
ATOM    644  HA  ILE A  41      59.602 -16.890   2.247  1.00  0.00           H  
ATOM    645  HB  ILE A  41      57.088 -17.033   2.055  1.00  0.00           H  
ATOM    646 HG12 ILE A  41      56.946 -19.411   2.432  1.00  0.00           H  
ATOM    647 HG13 ILE A  41      58.400 -19.721   1.513  1.00  0.00           H  
ATOM    648 HG21 ILE A  41      57.743 -18.466  -0.561  1.00  0.00           H  
ATOM    649 HG22 ILE A  41      56.149 -18.435   0.198  1.00  0.00           H  
ATOM    650 HG23 ILE A  41      56.875 -16.940  -0.393  1.00  0.00           H  
ATOM    651 HD11 ILE A  41      58.360 -18.047   4.078  1.00  0.00           H  
ATOM    652 HD12 ILE A  41      58.748 -19.766   4.037  1.00  0.00           H  
ATOM    653 HD13 ILE A  41      59.790 -18.609   3.212  1.00  0.00           H  
ATOM    654  N   ARG A  42      60.831 -18.556   0.881  1.00  0.00           N  
ATOM    655  CA  ARG A  42      61.731 -19.313   0.031  1.00  0.00           C  
ATOM    656  C   ARG A  42      61.799 -20.766   0.498  1.00  0.00           C  
ATOM    657  O   ARG A  42      61.525 -21.095   1.646  1.00  0.00           O  
ATOM    658  CB  ARG A  42      63.119 -18.680   0.075  1.00  0.00           C  
ATOM    659  CG  ARG A  42      63.511 -18.286   1.500  1.00  0.00           C  
ATOM    660  CD  ARG A  42      65.008 -17.996   1.615  1.00  0.00           C  
ATOM    661  NE  ARG A  42      65.775 -19.214   1.402  1.00  0.00           N  
ATOM    662  CZ  ARG A  42      66.245 -19.492   0.168  1.00  0.00           C  
ATOM    663  NH1 ARG A  42      66.024 -18.657  -0.844  1.00  0.00           N  
ATOM    664  NH2 ARG A  42      66.938 -20.608  -0.037  1.00  0.00           N  
ATOM    665  H   ARG A  42      60.854 -18.656   1.876  1.00  0.00           H  
ATOM    666  HA  ARG A  42      61.324 -19.285  -0.983  1.00  0.00           H  
ATOM    667  HB2 ARG A  42      63.850 -19.380  -0.326  1.00  0.00           H  
ATOM    668  HB3 ARG A  42      63.141 -17.799  -0.567  1.00  0.00           H  
ATOM    669  HG2 ARG A  42      62.944 -17.406   1.804  1.00  0.00           H  
ATOM    670  HG3 ARG A  42      63.240 -19.087   2.187  1.00  0.00           H  
ATOM    671  HD2 ARG A  42      65.339 -17.270   0.877  1.00  0.00           H  
ATOM    672  HD3 ARG A  42      65.266 -17.622   2.607  1.00  0.00           H  
ATOM    673  HE  ARG A  42      65.948 -19.842   2.161  1.00  0.00           H  
ATOM    674 HH11 ARG A  42      65.508 -17.814  -0.693  1.00  0.00           H  
ATOM    675 HH12 ARG A  42      66.376 -18.872  -1.754  1.00  0.00           H  
ATOM    676 HH21 ARG A  42      67.109 -21.237   0.722  1.00  0.00           H  
ATOM    677 HH22 ARG A  42      67.288 -20.819  -0.949  1.00  0.00           H  
ATOM    678  N   ALA A  43      62.181 -21.602  -0.483  1.00  0.00           N  
ATOM    679  CA  ALA A  43      62.305 -23.020  -0.192  1.00  0.00           C  
ATOM    680  C   ALA A  43      63.716 -23.476  -0.560  1.00  0.00           C  
ATOM    681  O   ALA A  43      64.559 -22.689  -0.975  1.00  0.00           O  
ATOM    682  CB  ALA A  43      61.264 -23.795  -0.995  1.00  0.00           C  
ATOM    683  H   ALA A  43      62.374 -21.254  -1.399  1.00  0.00           H  
ATOM    684  HA  ALA A  43      62.151 -23.149   0.881  1.00  0.00           H  
ATOM    685  HB1 ALA A  43      61.405 -23.642  -2.065  1.00  0.00           H  
ATOM    686  HB2 ALA A  43      61.336 -24.864  -0.795  1.00  0.00           H  
ATOM    687  HB3 ALA A  43      60.255 -23.471  -0.739  1.00  0.00           H  
ATOM    688  N   ARG A  44      63.915 -24.794  -0.384  1.00  0.00           N  
ATOM    689  CA  ARG A  44      65.223 -25.337  -0.706  1.00  0.00           C  
ATOM    690  C   ARG A  44      65.120 -26.847  -0.913  1.00  0.00           C  
ATOM    691  O   ARG A  44      64.256 -27.520  -0.364  1.00  0.00           O  
ATOM    692  CB  ARG A  44      66.203 -25.011   0.417  1.00  0.00           C  
ATOM    693  CG  ARG A  44      67.651 -25.094  -0.066  1.00  0.00           C  
ATOM    694  CD  ARG A  44      68.618 -24.484   0.947  1.00  0.00           C  
ATOM    695  NE  ARG A  44      69.937 -24.340   0.357  1.00  0.00           N  
ATOM    696  CZ  ARG A  44      70.792 -23.449   0.894  1.00  0.00           C  
ATOM    697  NH1 ARG A  44      70.428 -22.727   1.950  1.00  0.00           N  
ATOM    698  NH2 ARG A  44      72.003 -23.292   0.367  1.00  0.00           N  
ATOM    699  H   ARG A  44      63.183 -25.382  -0.040  1.00  0.00           H  
ATOM    700  HA  ARG A  44      65.543 -24.872  -1.643  1.00  0.00           H  
ATOM    701  HB2 ARG A  44      66.001 -24.010   0.796  1.00  0.00           H  
ATOM    702  HB3 ARG A  44      66.052 -25.699   1.249  1.00  0.00           H  
ATOM    703  HG2 ARG A  44      67.917 -26.135  -0.249  1.00  0.00           H  
ATOM    704  HG3 ARG A  44      67.746 -24.573  -1.020  1.00  0.00           H  
ATOM    705  HD2 ARG A  44      68.300 -23.492   1.261  1.00  0.00           H  
ATOM    706  HD3 ARG A  44      68.722 -25.113   1.832  1.00  0.00           H  
ATOM    707  HE  ARG A  44      70.205 -24.889  -0.435  1.00  0.00           H  
ATOM    708 HH11 ARG A  44      69.518 -22.845   2.346  1.00  0.00           H  
ATOM    709 HH12 ARG A  44      71.065 -22.067   2.348  1.00  0.00           H  
ATOM    710 HH21 ARG A  44      72.278 -23.834  -0.427  1.00  0.00           H  
ATOM    711 HH22 ARG A  44      72.639 -22.631   0.765  1.00  0.00           H  
ATOM    712  N   ASP A  45      66.062 -27.324  -1.746  1.00  0.00           N  
ATOM    713  CA  ASP A  45      66.081 -28.748  -2.033  1.00  0.00           C  
ATOM    714  C   ASP A  45      67.361 -29.364  -1.470  1.00  0.00           C  
ATOM    715  O   ASP A  45      68.343 -29.571  -2.173  1.00  0.00           O  
ATOM    716  CB  ASP A  45      66.002 -28.962  -3.542  1.00  0.00           C  
ATOM    717  CG  ASP A  45      65.969 -30.460  -3.853  1.00  0.00           C  
ATOM    718  OD1 ASP A  45      65.086 -31.146  -3.342  1.00  0.00           O  
ATOM    719  OD2 ASP A  45      66.829 -30.922  -4.602  1.00  0.00           O  
ATOM    720  H   ASP A  45      66.736 -26.711  -2.159  1.00  0.00           H  
ATOM    721  HA  ASP A  45      65.218 -29.193  -1.531  1.00  0.00           H  
ATOM    722  HB2 ASP A  45      65.105 -28.496  -3.950  1.00  0.00           H  
ATOM    723  HB3 ASP A  45      66.864 -28.516  -4.039  1.00  0.00           H  
ATOM    724  N   ASN A  46      67.276 -29.640  -0.158  1.00  0.00           N  
ATOM    725  CA  ASN A  46      68.427 -30.230   0.504  1.00  0.00           C  
ATOM    726  C   ASN A  46      67.950 -31.195   1.590  1.00  0.00           C  
ATOM    727  O   ASN A  46      68.442 -32.308   1.729  1.00  0.00           O  
ATOM    728  CB  ASN A  46      69.289 -29.126   1.110  1.00  0.00           C  
ATOM    729  CG  ASN A  46      70.516 -29.738   1.790  1.00  0.00           C  
ATOM    730  OD1 ASN A  46      70.754 -30.938   1.736  1.00  0.00           O  
ATOM    731  ND2 ASN A  46      71.272 -28.827   2.429  1.00  0.00           N  
ATOM    732  H   ASN A  46      66.440 -29.442   0.352  1.00  0.00           H  
ATOM    733  HA  ASN A  46      68.985 -30.789  -0.252  1.00  0.00           H  
ATOM    734  HB2 ASN A  46      69.621 -28.431   0.339  1.00  0.00           H  
ATOM    735  HB3 ASN A  46      68.723 -28.557   1.847  1.00  0.00           H  
ATOM    736 HD21 ASN A  46      71.015 -27.861   2.430  1.00  0.00           H  
ATOM    737 HD22 ASN A  46      72.103 -29.102   2.913  1.00  0.00           H  
ATOM    738  N   ASN A  47      66.959 -30.688   2.346  1.00  0.00           N  
ATOM    739  CA  ASN A  47      66.410 -31.502   3.415  1.00  0.00           C  
ATOM    740  C   ASN A  47      65.143 -30.841   3.956  1.00  0.00           C  
ATOM    741  O   ASN A  47      64.940 -30.717   5.157  1.00  0.00           O  
ATOM    742  CB  ASN A  47      67.450 -31.655   4.522  1.00  0.00           C  
ATOM    743  CG  ASN A  47      66.906 -32.568   5.622  1.00  0.00           C  
ATOM    744  OD1 ASN A  47      66.827 -33.782   5.477  1.00  0.00           O  
ATOM    745  ND2 ASN A  47      66.541 -31.897   6.729  1.00  0.00           N  
ATOM    746  H   ASN A  47      66.608 -29.767   2.173  1.00  0.00           H  
ATOM    747  HA  ASN A  47      66.153 -32.474   2.986  1.00  0.00           H  
ATOM    748  HB2 ASN A  47      68.370 -32.086   4.129  1.00  0.00           H  
ATOM    749  HB3 ASN A  47      67.696 -30.685   4.955  1.00  0.00           H  
ATOM    750 HD21 ASN A  47      66.636 -30.903   6.778  1.00  0.00           H  
ATOM    751 HD22 ASN A  47      66.170 -32.382   7.520  1.00  0.00           H  
ATOM    752  N   GLY A  48      64.311 -30.426   2.983  1.00  0.00           N  
ATOM    753  CA  GLY A  48      63.070 -29.777   3.362  1.00  0.00           C  
ATOM    754  C   GLY A  48      63.327 -28.666   4.380  1.00  0.00           C  
ATOM    755  O   GLY A  48      63.428 -28.898   5.579  1.00  0.00           O  
ATOM    756  H   GLY A  48      64.543 -30.563   2.020  1.00  0.00           H  
ATOM    757  HA2 GLY A  48      62.618 -29.371   2.457  1.00  0.00           H  
ATOM    758  HA3 GLY A  48      62.413 -30.539   3.784  1.00  0.00           H  
ATOM    759  N   SER A  49      63.426 -27.447   3.818  1.00  0.00           N  
ATOM    760  CA  SER A  49      63.672 -26.307   4.683  1.00  0.00           C  
ATOM    761  C   SER A  49      63.171 -25.030   4.011  1.00  0.00           C  
ATOM    762  O   SER A  49      63.556 -24.686   2.900  1.00  0.00           O  
ATOM    763  CB  SER A  49      65.167 -26.208   4.977  1.00  0.00           C  
ATOM    764  OG  SER A  49      65.419 -25.224   5.947  1.00  0.00           O  
ATOM    765  H   SER A  49      63.332 -27.330   2.829  1.00  0.00           H  
ATOM    766  HA  SER A  49      63.107 -26.470   5.605  1.00  0.00           H  
ATOM    767  HB2 SER A  49      65.553 -27.157   5.349  1.00  0.00           H  
ATOM    768  HB3 SER A  49      65.724 -25.949   4.076  1.00  0.00           H  
ATOM    769  HG  SER A  49      66.219 -25.476   6.390  1.00  0.00           H  
ATOM    770  N   TYR A  50      62.286 -24.358   4.768  1.00  0.00           N  
ATOM    771  CA  TYR A  50      61.724 -23.117   4.261  1.00  0.00           C  
ATOM    772  C   TYR A  50      61.906 -22.035   5.322  1.00  0.00           C  
ATOM    773  O   TYR A  50      62.065 -22.320   6.501  1.00  0.00           O  
ATOM    774  CB  TYR A  50      60.238 -23.307   3.948  1.00  0.00           C  
ATOM    775  CG  TYR A  50      60.007 -24.455   3.007  1.00  0.00           C  
ATOM    776  CD1 TYR A  50      60.145 -25.790   3.460  1.00  0.00           C  
ATOM    777  CD2 TYR A  50      59.636 -24.216   1.661  1.00  0.00           C  
ATOM    778  CE1 TYR A  50      59.916 -26.872   2.579  1.00  0.00           C  
ATOM    779  CE2 TYR A  50      59.407 -25.298   0.780  1.00  0.00           C  
ATOM    780  CZ  TYR A  50      59.547 -26.625   1.239  1.00  0.00           C  
ATOM    781  OH  TYR A  50      59.324 -27.681   0.379  1.00  0.00           O  
ATOM    782  H   TYR A  50      62.019 -24.708   5.665  1.00  0.00           H  
ATOM    783  HA  TYR A  50      62.285 -22.844   3.362  1.00  0.00           H  
ATOM    784  HB2 TYR A  50      59.683 -23.491   4.868  1.00  0.00           H  
ATOM    785  HB3 TYR A  50      59.829 -22.400   3.503  1.00  0.00           H  
ATOM    786  HD1 TYR A  50      60.427 -25.983   4.484  1.00  0.00           H  
ATOM    787  HD2 TYR A  50      59.527 -23.202   1.306  1.00  0.00           H  
ATOM    788  HE1 TYR A  50      60.024 -27.886   2.932  1.00  0.00           H  
ATOM    789  HE2 TYR A  50      59.124 -25.109  -0.245  1.00  0.00           H  
ATOM    790  HH  TYR A  50      59.466 -28.498   0.839  1.00  0.00           H  
ATOM    791  N   ALA A  51      61.878 -20.781   4.836  1.00  0.00           N  
ATOM    792  CA  ALA A  51      62.033 -19.688   5.780  1.00  0.00           C  
ATOM    793  C   ALA A  51      61.443 -18.403   5.204  1.00  0.00           C  
ATOM    794  O   ALA A  51      61.682 -18.029   4.061  1.00  0.00           O  
ATOM    795  CB  ALA A  51      63.510 -19.496   6.119  1.00  0.00           C  
ATOM    796  H   ALA A  51      61.755 -20.608   3.859  1.00  0.00           H  
ATOM    797  HA  ALA A  51      61.469 -19.961   6.676  1.00  0.00           H  
ATOM    798  HB1 ALA A  51      64.092 -19.276   5.225  1.00  0.00           H  
ATOM    799  HB2 ALA A  51      63.643 -18.668   6.818  1.00  0.00           H  
ATOM    800  HB3 ALA A  51      63.924 -20.392   6.580  1.00  0.00           H  
ATOM    801  N   LEU A  52      60.655 -17.764   6.086  1.00  0.00           N  
ATOM    802  CA  LEU A  52      60.022 -16.515   5.700  1.00  0.00           C  
ATOM    803  C   LEU A  52      60.996 -15.364   5.947  1.00  0.00           C  
ATOM    804  O   LEU A  52      61.705 -15.326   6.939  1.00  0.00           O  
ATOM    805  CB  LEU A  52      58.744 -16.341   6.523  1.00  0.00           C  
ATOM    806  CG  LEU A  52      58.525 -14.895   6.976  1.00  0.00           C  
ATOM    807  CD1 LEU A  52      58.429 -13.964   5.768  1.00  0.00           C  
ATOM    808  CD2 LEU A  52      57.253 -14.808   7.813  1.00  0.00           C  
ATOM    809  H   LEU A  52      60.504 -18.148   6.997  1.00  0.00           H  
ATOM    810  HA  LEU A  52      59.798 -16.577   4.632  1.00  0.00           H  
ATOM    811  HB2 LEU A  52      57.887 -16.669   5.935  1.00  0.00           H  
ATOM    812  HB3 LEU A  52      58.788 -16.989   7.397  1.00  0.00           H  
ATOM    813  HG  LEU A  52      59.376 -14.583   7.598  1.00  0.00           H  
ATOM    814 HD11 LEU A  52      58.609 -14.510   4.841  1.00  0.00           H  
ATOM    815 HD12 LEU A  52      57.440 -13.510   5.703  1.00  0.00           H  
ATOM    816 HD13 LEU A  52      59.165 -13.162   5.833  1.00  0.00           H  
ATOM    817 HD21 LEU A  52      56.439 -15.359   7.342  1.00  0.00           H  
ATOM    818 HD22 LEU A  52      57.415 -15.229   8.804  1.00  0.00           H  
ATOM    819 HD23 LEU A  52      56.934 -13.772   7.930  1.00  0.00           H  
ATOM    820  N   CYS A  53      60.975 -14.427   4.985  1.00  0.00           N  
ATOM    821  CA  CYS A  53      61.869 -13.291   5.123  1.00  0.00           C  
ATOM    822  C   CYS A  53      61.120 -11.988   4.869  1.00  0.00           C  
ATOM    823  O   CYS A  53      60.645 -11.716   3.773  1.00  0.00           O  
ATOM    824  CB  CYS A  53      63.025 -13.426   4.135  1.00  0.00           C  
ATOM    825  SG  CYS A  53      63.903 -15.000   4.290  1.00  0.00           S  
ATOM    826  H   CYS A  53      60.359 -14.507   4.202  1.00  0.00           H  
ATOM    827  HA  CYS A  53      62.240 -13.293   6.152  1.00  0.00           H  
ATOM    828  HB2 CYS A  53      62.652 -13.333   3.115  1.00  0.00           H  
ATOM    829  HB3 CYS A  53      63.736 -12.611   4.287  1.00  0.00           H  
ATOM    830  HG  CYS A  53      64.290 -15.170   5.556  1.00  0.00           H  
ATOM    831  N   LEU A  54      61.052 -11.202   5.959  1.00  0.00           N  
ATOM    832  CA  LEU A  54      60.401  -9.908   5.831  1.00  0.00           C  
ATOM    833  C   LEU A  54      61.313  -8.856   6.450  1.00  0.00           C  
ATOM    834  O   LEU A  54      62.233  -9.164   7.193  1.00  0.00           O  
ATOM    835  CB  LEU A  54      58.984  -9.916   6.428  1.00  0.00           C  
ATOM    836  CG  LEU A  54      58.912 -10.289   7.915  1.00  0.00           C  
ATOM    837  CD1 LEU A  54      59.055 -11.798   8.107  1.00  0.00           C  
ATOM    838  CD2 LEU A  54      59.964  -9.541   8.731  1.00  0.00           C  
ATOM    839  H   LEU A  54      61.454 -11.499   6.829  1.00  0.00           H  
ATOM    840  HA  LEU A  54      60.345  -9.704   4.762  1.00  0.00           H  
ATOM    841  HB2 LEU A  54      58.536  -8.932   6.291  1.00  0.00           H  
ATOM    842  HB3 LEU A  54      58.371 -10.613   5.856  1.00  0.00           H  
ATOM    843  HG  LEU A  54      57.926 -10.000   8.282  1.00  0.00           H  
ATOM    844 HD11 LEU A  54      58.375 -12.336   7.450  1.00  0.00           H  
ATOM    845 HD12 LEU A  54      60.069 -12.126   7.888  1.00  0.00           H  
ATOM    846 HD13 LEU A  54      58.823 -12.081   9.133  1.00  0.00           H  
ATOM    847 HD21 LEU A  54      60.028  -8.497   8.426  1.00  0.00           H  
ATOM    848 HD22 LEU A  54      59.722  -9.567   9.795  1.00  0.00           H  
ATOM    849 HD23 LEU A  54      60.940  -9.992   8.602  1.00  0.00           H  
ATOM    850  N   LEU A  55      61.028  -7.599   6.078  1.00  0.00           N  
ATOM    851  CA  LEU A  55      61.896  -6.546   6.580  1.00  0.00           C  
ATOM    852  C   LEU A  55      61.183  -5.655   7.591  1.00  0.00           C  
ATOM    853  O   LEU A  55      60.028  -5.276   7.434  1.00  0.00           O  
ATOM    854  CB  LEU A  55      62.395  -5.733   5.391  1.00  0.00           C  
ATOM    855  CG  LEU A  55      63.359  -4.619   5.807  1.00  0.00           C  
ATOM    856  CD1 LEU A  55      64.811  -4.996   5.519  1.00  0.00           C  
ATOM    857  CD2 LEU A  55      63.024  -3.337   5.059  1.00  0.00           C  
ATOM    858  H   LEU A  55      60.248  -7.394   5.472  1.00  0.00           H  
ATOM    859  HA  LEU A  55      62.731  -7.037   7.082  1.00  0.00           H  
ATOM    860  HB2 LEU A  55      62.882  -6.397   4.685  1.00  0.00           H  
ATOM    861  HB3 LEU A  55      61.544  -5.299   4.870  1.00  0.00           H  
ATOM    862  HG  LEU A  55      63.250  -4.445   6.877  1.00  0.00           H  
ATOM    863 HD11 LEU A  55      64.937  -6.071   5.482  1.00  0.00           H  
ATOM    864 HD12 LEU A  55      65.133  -4.585   4.560  1.00  0.00           H  
ATOM    865 HD13 LEU A  55      65.474  -4.602   6.286  1.00  0.00           H  
ATOM    866 HD21 LEU A  55      61.975  -3.079   5.181  1.00  0.00           H  
ATOM    867 HD22 LEU A  55      63.624  -2.508   5.422  1.00  0.00           H  
ATOM    868 HD23 LEU A  55      63.224  -3.454   3.994  1.00  0.00           H  
ATOM    869  N   HIS A  56      61.974  -5.353   8.642  1.00  0.00           N  
ATOM    870  CA  HIS A  56      61.463  -4.489   9.685  1.00  0.00           C  
ATOM    871  C   HIS A  56      62.175  -3.146   9.554  1.00  0.00           C  
ATOM    872  O   HIS A  56      62.823  -2.656  10.471  1.00  0.00           O  
ATOM    873  CB  HIS A  56      61.726  -5.118  11.054  1.00  0.00           C  
ATOM    874  CG  HIS A  56      61.266  -4.172  12.137  1.00  0.00           C  
ATOM    875  ND1 HIS A  56      60.154  -3.410  12.051  1.00  0.00           N  
ATOM    876  CD2 HIS A  56      61.880  -3.913  13.375  1.00  0.00           C  
ATOM    877  CE1 HIS A  56      60.085  -2.707  13.193  1.00  0.00           C  
ATOM    878  NE2 HIS A  56      61.116  -2.992  14.010  1.00  0.00           N  
ATOM    879  H   HIS A  56      62.909  -5.713   8.694  1.00  0.00           H  
ATOM    880  HA  HIS A  56      60.394  -4.358   9.509  1.00  0.00           H  
ATOM    881  HB2 HIS A  56      61.192  -6.064  11.150  1.00  0.00           H  
ATOM    882  HB3 HIS A  56      62.789  -5.323  11.183  1.00  0.00           H  
ATOM    883  HD1 HIS A  56      59.522  -3.379  11.303  1.00  0.00           H  
ATOM    884  HD2 HIS A  56      62.787  -4.364  13.750  1.00  0.00           H  
ATOM    885  HE1 HIS A  56      59.302  -2.003  13.427  1.00  0.00           H  
ATOM    886  N   GLU A  57      62.003  -2.598   8.339  1.00  0.00           N  
ATOM    887  CA  GLU A  57      62.635  -1.344   8.034  1.00  0.00           C  
ATOM    888  C   GLU A  57      64.131  -1.472   8.270  1.00  0.00           C  
ATOM    889  O   GLU A  57      64.622  -1.592   9.385  1.00  0.00           O  
ATOM    890  CB  GLU A  57      62.077  -0.248   8.892  1.00  0.00           C  
ATOM    891  CG  GLU A  57      60.624  -0.505   9.295  1.00  0.00           C  
ATOM    892  CD  GLU A  57      60.109   0.654  10.149  1.00  0.00           C  
ATOM    893  OE1 GLU A  57      60.837   1.096  11.037  1.00  0.00           O  
ATOM    894  OE2 GLU A  57      58.988   1.102   9.918  1.00  0.00           O  
ATOM    895  H   GLU A  57      61.435  -3.039   7.666  1.00  0.00           H  
ATOM    896  HA  GLU A  57      62.454  -1.137   6.975  1.00  0.00           H  
ATOM    897  HB2 GLU A  57      62.699  -0.181   9.759  1.00  0.00           H  
ATOM    898  HB3 GLU A  57      62.154   0.707   8.371  1.00  0.00           H  
ATOM    899  HG2 GLU A  57      59.995  -0.602   8.411  1.00  0.00           H  
ATOM    900  HG3 GLU A  57      60.540  -1.429   9.866  1.00  0.00           H  
ATOM    901  N   GLY A  58      64.789  -1.436   7.125  1.00  0.00           N  
ATOM    902  CA  GLY A  58      66.241  -1.543   7.106  1.00  0.00           C  
ATOM    903  C   GLY A  58      66.780  -2.723   7.935  1.00  0.00           C  
ATOM    904  O   GLY A  58      67.978  -2.831   8.175  1.00  0.00           O  
ATOM    905  H   GLY A  58      64.274  -1.319   6.289  1.00  0.00           H  
ATOM    906  HA2 GLY A  58      66.541  -1.652   6.064  1.00  0.00           H  
ATOM    907  HA3 GLY A  58      66.637  -0.609   7.487  1.00  0.00           H  
ATOM    908  N   LYS A  59      65.841  -3.594   8.354  1.00  0.00           N  
ATOM    909  CA  LYS A  59      66.266  -4.738   9.128  1.00  0.00           C  
ATOM    910  C   LYS A  59      65.557  -5.968   8.596  1.00  0.00           C  
ATOM    911  O   LYS A  59      64.498  -6.368   9.068  1.00  0.00           O  
ATOM    912  CB  LYS A  59      65.931  -4.540  10.595  1.00  0.00           C  
ATOM    913  CG  LYS A  59      66.436  -3.198  11.127  1.00  0.00           C  
ATOM    914  CD  LYS A  59      65.421  -2.555  12.070  1.00  0.00           C  
ATOM    915  CE  LYS A  59      65.875  -2.636  13.527  1.00  0.00           C  
ATOM    916  NZ  LYS A  59      66.014  -4.010  13.992  1.00  0.00           N  
ATOM    917  H   LYS A  59      64.877  -3.467   8.127  1.00  0.00           H  
ATOM    918  HA  LYS A  59      67.342  -4.850   8.982  1.00  0.00           H  
ATOM    919  HB2 LYS A  59      64.854  -4.607  10.725  1.00  0.00           H  
ATOM    920  HB3 LYS A  59      66.371  -5.353  11.172  1.00  0.00           H  
ATOM    921  HG2 LYS A  59      67.382  -3.342  11.649  1.00  0.00           H  
ATOM    922  HG3 LYS A  59      66.636  -2.524  10.297  1.00  0.00           H  
ATOM    923  HD2 LYS A  59      65.274  -1.513  11.789  1.00  0.00           H  
ATOM    924  HD3 LYS A  59      64.455  -3.050  11.958  1.00  0.00           H  
ATOM    925  HE2 LYS A  59      66.839  -2.144  13.656  1.00  0.00           H  
ATOM    926  HE3 LYS A  59      65.160  -2.136  14.179  1.00  0.00           H  
ATOM    927  HZ1 LYS A  59      65.100  -4.500  13.907  1.00  0.00           H  
ATOM    928  HZ2 LYS A  59      66.725  -4.503  13.414  1.00  0.00           H  
ATOM    929  HZ3 LYS A  59      66.315  -4.012  14.987  1.00  0.00           H  
ATOM    930  N   VAL A  60      66.216  -6.534   7.588  1.00  0.00           N  
ATOM    931  CA  VAL A  60      65.646  -7.715   6.978  1.00  0.00           C  
ATOM    932  C   VAL A  60      65.729  -8.867   7.962  1.00  0.00           C  
ATOM    933  O   VAL A  60      66.705  -9.044   8.680  1.00  0.00           O  
ATOM    934  CB  VAL A  60      66.385  -8.078   5.699  1.00  0.00           C  
ATOM    935  CG1 VAL A  60      67.612  -8.917   6.028  1.00  0.00           C  
ATOM    936  CG2 VAL A  60      65.463  -8.860   4.767  1.00  0.00           C  
ATOM    937  H   VAL A  60      67.076  -6.148   7.274  1.00  0.00           H  
ATOM    938  HA  VAL A  60      64.594  -7.494   6.767  1.00  0.00           H  
ATOM    939  HB  VAL A  60      66.702  -7.161   5.202  1.00  0.00           H  
ATOM    940 HG11 VAL A  60      68.259  -8.397   6.732  1.00  0.00           H  
ATOM    941 HG12 VAL A  60      67.317  -9.866   6.479  1.00  0.00           H  
ATOM    942 HG13 VAL A  60      68.184  -9.134   5.131  1.00  0.00           H  
ATOM    943 HG21 VAL A  60      64.448  -8.470   4.806  1.00  0.00           H  
ATOM    944 HG22 VAL A  60      65.810  -8.803   3.736  1.00  0.00           H  
ATOM    945 HG23 VAL A  60      65.429  -9.912   5.052  1.00  0.00           H  
ATOM    946  N   LEU A  61      64.654  -9.648   7.908  1.00  0.00           N  
ATOM    947  CA  LEU A  61      64.581 -10.782   8.795  1.00  0.00           C  
ATOM    948  C   LEU A  61      64.275 -12.048   8.044  1.00  0.00           C  
ATOM    949  O   LEU A  61      63.844 -12.063   6.898  1.00  0.00           O  
ATOM    950  CB  LEU A  61      63.503 -10.555   9.840  1.00  0.00           C  
ATOM    951  CG  LEU A  61      63.653  -9.182  10.465  1.00  0.00           C  
ATOM    952  CD1 LEU A  61      62.664  -8.986  11.610  1.00  0.00           C  
ATOM    953  CD2 LEU A  61      65.083  -9.024  10.952  1.00  0.00           C  
ATOM    954  H   LEU A  61      63.931  -9.447   7.272  1.00  0.00           H  
ATOM    955  HA  LEU A  61      65.562 -10.887   9.261  1.00  0.00           H  
ATOM    956  HB2 LEU A  61      62.520 -10.662   9.392  1.00  0.00           H  
ATOM    957  HB3 LEU A  61      63.574 -11.322  10.608  1.00  0.00           H  
ATOM    958  HG  LEU A  61      63.458  -8.428   9.703  1.00  0.00           H  
ATOM    959 HD11 LEU A  61      62.801  -9.745  12.378  1.00  0.00           H  
ATOM    960 HD12 LEU A  61      62.796  -8.008  12.074  1.00  0.00           H  
ATOM    961 HD13 LEU A  61      61.639  -9.052  11.248  1.00  0.00           H  
ATOM    962 HD21 LEU A  61      65.608  -9.980  10.921  1.00  0.00           H  
ATOM    963 HD22 LEU A  61      65.626  -8.321  10.327  1.00  0.00           H  
ATOM    964 HD23 LEU A  61      65.106  -8.664  11.973  1.00  0.00           H  
ATOM    965  N   HIS A  62      64.523 -13.105   8.814  1.00  0.00           N  
ATOM    966  CA  HIS A  62      64.280 -14.434   8.287  1.00  0.00           C  
ATOM    967  C   HIS A  62      63.728 -15.298   9.423  1.00  0.00           C  
ATOM    968  O   HIS A  62      64.084 -15.135  10.581  1.00  0.00           O  
ATOM    969  CB  HIS A  62      65.580 -15.035   7.728  1.00  0.00           C  
ATOM    970  CG  HIS A  62      66.271 -14.047   6.804  1.00  0.00           C  
ATOM    971  ND1 HIS A  62      66.343 -14.186   5.460  1.00  0.00           N  
ATOM    972  CD2 HIS A  62      66.948 -12.865   7.158  1.00  0.00           C  
ATOM    973  CE1 HIS A  62      67.040 -13.126   5.007  1.00  0.00           C  
ATOM    974  NE2 HIS A  62      67.415 -12.316   6.012  1.00  0.00           N  
ATOM    975  H   HIS A  62      64.876 -12.968   9.748  1.00  0.00           H  
ATOM    976  HA  HIS A  62      63.522 -14.337   7.504  1.00  0.00           H  
ATOM    977  HB2 HIS A  62      66.257 -15.292   8.541  1.00  0.00           H  
ATOM    978  HB3 HIS A  62      65.367 -15.952   7.177  1.00  0.00           H  
ATOM    979  HD1 HIS A  62      65.964 -14.912   4.923  1.00  0.00           H  
ATOM    980  HD2 HIS A  62      67.073 -12.471   8.156  1.00  0.00           H  
ATOM    981  HE1 HIS A  62      67.274 -12.948   3.965  1.00  0.00           H  
ATOM    982  N   TYR A  63      62.825 -16.204   9.026  1.00  0.00           N  
ATOM    983  CA  TYR A  63      62.237 -17.071  10.016  1.00  0.00           C  
ATOM    984  C   TYR A  63      62.224 -18.496   9.477  1.00  0.00           C  
ATOM    985  O   TYR A  63      61.692 -18.768   8.412  1.00  0.00           O  
ATOM    986  CB  TYR A  63      60.812 -16.605  10.282  1.00  0.00           C  
ATOM    987  CG  TYR A  63      60.792 -15.318  11.049  1.00  0.00           C  
ATOM    988  CD1 TYR A  63      61.125 -15.281  12.427  1.00  0.00           C  
ATOM    989  CD2 TYR A  63      60.450 -14.112  10.392  1.00  0.00           C  
ATOM    990  CE1 TYR A  63      61.114 -14.057  13.120  1.00  0.00           C  
ATOM    991  CE2 TYR A  63      60.442 -12.891  11.090  1.00  0.00           C  
ATOM    992  CZ  TYR A  63      60.773 -12.861  12.456  1.00  0.00           C  
ATOM    993  OH  TYR A  63      60.767 -11.664  13.143  1.00  0.00           O  
ATOM    994  H   TYR A  63      62.548 -16.272   8.076  1.00  0.00           H  
ATOM    995  HA  TYR A  63      62.853 -17.019  10.917  1.00  0.00           H  
ATOM    996  HB2 TYR A  63      60.286 -16.458   9.338  1.00  0.00           H  
ATOM    997  HB3 TYR A  63      60.271 -17.359  10.832  1.00  0.00           H  
ATOM    998  HD1 TYR A  63      61.379 -16.191  12.957  1.00  0.00           H  
ATOM    999  HD2 TYR A  63      60.188 -14.129   9.354  1.00  0.00           H  
ATOM   1000  HE1 TYR A  63      61.380 -14.033  14.153  1.00  0.00           H  
ATOM   1001  HE2 TYR A  63      60.184 -11.980  10.574  1.00  0.00           H  
ATOM   1002  HH  TYR A  63      60.581 -10.956  12.541  1.00  0.00           H  
ATOM   1003  N   ARG A  64      62.847 -19.385  10.270  1.00  0.00           N  
ATOM   1004  CA  ARG A  64      62.870 -20.769   9.832  1.00  0.00           C  
ATOM   1005  C   ARG A  64      61.453 -21.330   9.925  1.00  0.00           C  
ATOM   1006  O   ARG A  64      60.699 -21.032  10.843  1.00  0.00           O  
ATOM   1007  CB  ARG A  64      63.839 -21.593  10.680  1.00  0.00           C  
ATOM   1008  CG  ARG A  64      64.109 -20.959  12.046  1.00  0.00           C  
ATOM   1009  CD  ARG A  64      62.854 -20.949  12.918  1.00  0.00           C  
ATOM   1010  NE  ARG A  64      63.205 -21.170  14.308  1.00  0.00           N  
ATOM   1011  CZ  ARG A  64      63.593 -20.119  15.052  1.00  0.00           C  
ATOM   1012  NH1 ARG A  64      63.657 -18.905  14.512  1.00  0.00           N  
ATOM   1013  NH2 ARG A  64      63.915 -20.293  16.331  1.00  0.00           N  
ATOM   1014  H   ARG A  64      63.277 -19.103  11.128  1.00  0.00           H  
ATOM   1015  HA  ARG A  64      63.186 -20.765   8.782  1.00  0.00           H  
ATOM   1016  HB2 ARG A  64      63.434 -22.595  10.819  1.00  0.00           H  
ATOM   1017  HB3 ARG A  64      64.775 -21.710  10.138  1.00  0.00           H  
ATOM   1018  HG2 ARG A  64      64.901 -21.511  12.553  1.00  0.00           H  
ATOM   1019  HG3 ARG A  64      64.473 -19.940  11.913  1.00  0.00           H  
ATOM   1020  HD2 ARG A  64      62.336 -19.992  12.868  1.00  0.00           H  
ATOM   1021  HD3 ARG A  64      62.158 -21.737  12.627  1.00  0.00           H  
ATOM   1022  HE  ARG A  64      63.157 -22.086  14.707  1.00  0.00           H  
ATOM   1023 HH11 ARG A  64      63.415 -18.773  13.551  1.00  0.00           H  
ATOM   1024 HH12 ARG A  64      63.946 -18.125  15.066  1.00  0.00           H  
ATOM   1025 HH21 ARG A  64      63.867 -21.206  16.739  1.00  0.00           H  
ATOM   1026 HH22 ARG A  64      64.203 -19.513  16.885  1.00  0.00           H  
ATOM   1027  N   ILE A  65      61.149 -22.160   8.914  1.00  0.00           N  
ATOM   1028  CA  ILE A  65      59.817 -22.747   8.876  1.00  0.00           C  
ATOM   1029  C   ILE A  65      59.875 -24.162   8.309  1.00  0.00           C  
ATOM   1030  O   ILE A  65      60.274 -24.385   7.172  1.00  0.00           O  
ATOM   1031  CB  ILE A  65      58.909 -21.882   7.999  1.00  0.00           C  
ATOM   1032  CG1 ILE A  65      58.412 -20.667   8.773  1.00  0.00           C  
ATOM   1033  CG2 ILE A  65      57.716 -22.696   7.489  1.00  0.00           C  
ATOM   1034  CD1 ILE A  65      58.697 -19.370   8.022  1.00  0.00           C  
ATOM   1035  H   ILE A  65      61.826 -22.372   8.212  1.00  0.00           H  
ATOM   1036  HA  ILE A  65      59.444 -22.787   9.902  1.00  0.00           H  
ATOM   1037  HB  ILE A  65      59.486 -21.537   7.139  1.00  0.00           H  
ATOM   1038 HG12 ILE A  65      57.341 -20.762   8.944  1.00  0.00           H  
ATOM   1039 HG13 ILE A  65      58.889 -20.636   9.753  1.00  0.00           H  
ATOM   1040 HG21 ILE A  65      58.048 -23.550   6.898  1.00  0.00           H  
ATOM   1041 HG22 ILE A  65      57.118 -23.073   8.319  1.00  0.00           H  
ATOM   1042 HG23 ILE A  65      57.070 -22.084   6.860  1.00  0.00           H  
ATOM   1043 HD11 ILE A  65      59.744 -19.316   7.730  1.00  0.00           H  
ATOM   1044 HD12 ILE A  65      58.091 -19.304   7.118  1.00  0.00           H  
ATOM   1045 HD13 ILE A  65      58.473 -18.504   8.643  1.00  0.00           H  
ATOM   1046  N   ASP A  66      59.449 -25.099   9.174  1.00  0.00           N  
ATOM   1047  CA  ASP A  66      59.421 -26.474   8.728  1.00  0.00           C  
ATOM   1048  C   ASP A  66      58.317 -27.229   9.446  1.00  0.00           C  
ATOM   1049  O   ASP A  66      57.633 -26.720  10.324  1.00  0.00           O  
ATOM   1050  CB  ASP A  66      60.760 -27.137   8.990  1.00  0.00           C  
ATOM   1051  CG  ASP A  66      60.863 -28.439   8.191  1.00  0.00           C  
ATOM   1052  OD1 ASP A  66      60.906 -28.371   6.963  1.00  0.00           O  
ATOM   1053  OD2 ASP A  66      60.900 -29.503   8.805  1.00  0.00           O  
ATOM   1054  H   ASP A  66      59.180 -24.857  10.105  1.00  0.00           H  
ATOM   1055  HA  ASP A  66      59.196 -26.459   7.660  1.00  0.00           H  
ATOM   1056  HB2 ASP A  66      61.576 -26.483   8.704  1.00  0.00           H  
ATOM   1057  HB3 ASP A  66      60.863 -27.362  10.047  1.00  0.00           H  
ATOM   1058  N   LYS A  67      58.224 -28.490   9.015  1.00  0.00           N  
ATOM   1059  CA  LYS A  67      57.213 -29.355   9.579  1.00  0.00           C  
ATOM   1060  C   LYS A  67      57.877 -30.422  10.442  1.00  0.00           C  
ATOM   1061  O   LYS A  67      59.060 -30.363  10.751  1.00  0.00           O  
ATOM   1062  CB  LYS A  67      56.441 -30.007   8.436  1.00  0.00           C  
ATOM   1063  CG  LYS A  67      57.341 -30.918   7.606  1.00  0.00           C  
ATOM   1064  CD  LYS A  67      57.106 -30.726   6.107  1.00  0.00           C  
ATOM   1065  CE  LYS A  67      57.615 -31.919   5.298  1.00  0.00           C  
ATOM   1066  NZ  LYS A  67      59.061 -32.081   5.396  1.00  0.00           N  
ATOM   1067  H   LYS A  67      58.852 -28.826   8.319  1.00  0.00           H  
ATOM   1068  HA  LYS A  67      56.556 -28.736  10.198  1.00  0.00           H  
ATOM   1069  HB2 LYS A  67      55.606 -30.582   8.836  1.00  0.00           H  
ATOM   1070  HB3 LYS A  67      56.016 -29.234   7.797  1.00  0.00           H  
ATOM   1071  HG2 LYS A  67      58.383 -30.716   7.839  1.00  0.00           H  
ATOM   1072  HG3 LYS A  67      57.158 -31.955   7.876  1.00  0.00           H  
ATOM   1073  HD2 LYS A  67      56.042 -30.585   5.921  1.00  0.00           H  
ATOM   1074  HD3 LYS A  67      57.604 -29.816   5.773  1.00  0.00           H  
ATOM   1075  HE2 LYS A  67      57.154 -32.843   5.645  1.00  0.00           H  
ATOM   1076  HE3 LYS A  67      57.367 -31.799   4.243  1.00  0.00           H  
ATOM   1077  HZ1 LYS A  67      59.531 -31.226   5.038  1.00  0.00           H  
ATOM   1078  HZ2 LYS A  67      59.327 -32.232   6.390  1.00  0.00           H  
ATOM   1079  HZ3 LYS A  67      59.357 -32.902   4.830  1.00  0.00           H  
ATOM   1080  N   ASP A  68      57.029 -31.399  10.803  1.00  0.00           N  
ATOM   1081  CA  ASP A  68      57.533 -32.491  11.612  1.00  0.00           C  
ATOM   1082  C   ASP A  68      57.626 -33.730  10.728  1.00  0.00           C  
ATOM   1083  O   ASP A  68      57.144 -34.806  11.060  1.00  0.00           O  
ATOM   1084  CB  ASP A  68      56.588 -32.733  12.783  1.00  0.00           C  
ATOM   1085  CG  ASP A  68      56.946 -31.801  13.943  1.00  0.00           C  
ATOM   1086  OD1 ASP A  68      58.069 -31.886  14.439  1.00  0.00           O  
ATOM   1087  OD2 ASP A  68      56.099 -31.001  14.337  1.00  0.00           O  
ATOM   1088  H   ASP A  68      56.069 -31.380  10.513  1.00  0.00           H  
ATOM   1089  HA  ASP A  68      58.532 -32.213  11.958  1.00  0.00           H  
ATOM   1090  HB2 ASP A  68      55.554 -32.550  12.489  1.00  0.00           H  
ATOM   1091  HB3 ASP A  68      56.657 -33.762  13.123  1.00  0.00           H  
ATOM   1092  N   LYS A  69      58.281 -33.493   9.577  1.00  0.00           N  
ATOM   1093  CA  LYS A  69      58.418 -34.574   8.611  1.00  0.00           C  
ATOM   1094  C   LYS A  69      57.060 -35.248   8.399  1.00  0.00           C  
ATOM   1095  O   LYS A  69      56.957 -36.432   8.102  1.00  0.00           O  
ATOM   1096  CB  LYS A  69      59.460 -35.576   9.099  1.00  0.00           C  
ATOM   1097  CG  LYS A  69      60.881 -35.098   8.797  1.00  0.00           C  
ATOM   1098  CD  LYS A  69      61.115 -33.674   9.303  1.00  0.00           C  
ATOM   1099  CE  LYS A  69      62.564 -33.233   9.086  1.00  0.00           C  
ATOM   1100  NZ  LYS A  69      62.899 -33.109   7.672  1.00  0.00           N  
ATOM   1101  H   LYS A  69      58.667 -32.591   9.389  1.00  0.00           H  
ATOM   1102  HA  LYS A  69      58.722 -34.116   7.667  1.00  0.00           H  
ATOM   1103  HB2 LYS A  69      59.345 -35.732  10.170  1.00  0.00           H  
ATOM   1104  HB3 LYS A  69      59.290 -36.542   8.620  1.00  0.00           H  
ATOM   1105  HG2 LYS A  69      61.600 -35.774   9.258  1.00  0.00           H  
ATOM   1106  HG3 LYS A  69      61.059 -35.137   7.722  1.00  0.00           H  
ATOM   1107  HD2 LYS A  69      60.444 -32.987   8.789  1.00  0.00           H  
ATOM   1108  HD3 LYS A  69      60.871 -33.618  10.365  1.00  0.00           H  
ATOM   1109  HE2 LYS A  69      62.744 -32.267   9.555  1.00  0.00           H  
ATOM   1110  HE3 LYS A  69      63.254 -33.951   9.529  1.00  0.00           H  
ATOM   1111  HZ1 LYS A  69      62.766 -34.027   7.202  1.00  0.00           H  
ATOM   1112  HZ2 LYS A  69      62.280 -32.399   7.230  1.00  0.00           H  
ATOM   1113  HZ3 LYS A  69      63.890 -32.811   7.576  1.00  0.00           H  
ATOM   1114  N   THR A  70      56.037 -34.398   8.574  1.00  0.00           N  
ATOM   1115  CA  THR A  70      54.685 -34.844   8.396  1.00  0.00           C  
ATOM   1116  C   THR A  70      54.095 -34.158   7.162  1.00  0.00           C  
ATOM   1117  O   THR A  70      53.236 -34.689   6.470  1.00  0.00           O  
ATOM   1118  CB  THR A  70      53.904 -34.429   9.631  1.00  0.00           C  
ATOM   1119  OG1 THR A  70      53.967 -35.444  10.600  1.00  0.00           O  
ATOM   1120  CG2 THR A  70      52.457 -34.113   9.299  1.00  0.00           C  
ATOM   1121  H   THR A  70      56.206 -33.454   8.845  1.00  0.00           H  
ATOM   1122  HA  THR A  70      54.694 -35.928   8.260  1.00  0.00           H  
ATOM   1123  HB  THR A  70      54.368 -33.540  10.058  1.00  0.00           H  
ATOM   1124  HG1 THR A  70      54.043 -35.014  11.441  1.00  0.00           H  
ATOM   1125 HG21 THR A  70      51.975 -34.967   8.829  1.00  0.00           H  
ATOM   1126 HG22 THR A  70      51.902 -33.855  10.196  1.00  0.00           H  
ATOM   1127 HG23 THR A  70      52.400 -33.269   8.609  1.00  0.00           H  
ATOM   1128  N   GLY A  71      54.622 -32.935   6.948  1.00  0.00           N  
ATOM   1129  CA  GLY A  71      54.134 -32.159   5.836  1.00  0.00           C  
ATOM   1130  C   GLY A  71      53.586 -30.793   6.280  1.00  0.00           C  
ATOM   1131  O   GLY A  71      53.493 -29.853   5.499  1.00  0.00           O  
ATOM   1132  H   GLY A  71      55.364 -32.592   7.529  1.00  0.00           H  
ATOM   1133  HA2 GLY A  71      54.959 -32.036   5.145  1.00  0.00           H  
ATOM   1134  HA3 GLY A  71      53.351 -32.739   5.364  1.00  0.00           H  
ATOM   1135  N   LYS A  72      53.232 -30.752   7.578  1.00  0.00           N  
ATOM   1136  CA  LYS A  72      52.682 -29.516   8.115  1.00  0.00           C  
ATOM   1137  C   LYS A  72      53.807 -28.528   8.403  1.00  0.00           C  
ATOM   1138  O   LYS A  72      54.584 -28.687   9.335  1.00  0.00           O  
ATOM   1139  CB  LYS A  72      51.902 -29.810   9.394  1.00  0.00           C  
ATOM   1140  CG  LYS A  72      52.704 -30.686  10.360  1.00  0.00           C  
ATOM   1141  CD  LYS A  72      52.048 -30.742  11.740  1.00  0.00           C  
ATOM   1142  CE  LYS A  72      51.244 -32.029  11.932  1.00  0.00           C  
ATOM   1143  NZ  LYS A  72      50.253 -32.225  10.881  1.00  0.00           N  
ATOM   1144  H   LYS A  72      53.355 -31.555   8.160  1.00  0.00           H  
ATOM   1145  HA  LYS A  72      52.026 -29.094   7.350  1.00  0.00           H  
ATOM   1146  HB2 LYS A  72      51.641 -28.872   9.885  1.00  0.00           H  
ATOM   1147  HB3 LYS A  72      50.964 -30.304   9.145  1.00  0.00           H  
ATOM   1148  HG2 LYS A  72      52.791 -31.694   9.954  1.00  0.00           H  
ATOM   1149  HG3 LYS A  72      53.715 -30.296  10.452  1.00  0.00           H  
ATOM   1150  HD2 LYS A  72      52.817 -30.675  12.511  1.00  0.00           H  
ATOM   1151  HD3 LYS A  72      51.397 -29.878  11.871  1.00  0.00           H  
ATOM   1152  HE2 LYS A  72      51.904 -32.896  11.933  1.00  0.00           H  
ATOM   1153  HE3 LYS A  72      50.717 -32.012  12.886  1.00  0.00           H  
ATOM   1154  HZ1 LYS A  72      50.730 -32.258   9.957  1.00  0.00           H  
ATOM   1155  HZ2 LYS A  72      49.750 -33.120  11.042  1.00  0.00           H  
ATOM   1156  HZ3 LYS A  72      49.575 -31.438  10.893  1.00  0.00           H  
ATOM   1157  N   LEU A  73      53.813 -27.471   7.572  1.00  0.00           N  
ATOM   1158  CA  LEU A  73      54.836 -26.467   7.751  1.00  0.00           C  
ATOM   1159  C   LEU A  73      54.429 -25.600   8.934  1.00  0.00           C  
ATOM   1160  O   LEU A  73      53.315 -25.100   9.011  1.00  0.00           O  
ATOM   1161  CB  LEU A  73      54.956 -25.633   6.479  1.00  0.00           C  
ATOM   1162  CG  LEU A  73      55.455 -26.470   5.300  1.00  0.00           C  
ATOM   1163  CD1 LEU A  73      55.435 -25.646   4.013  1.00  0.00           C  
ATOM   1164  CD2 LEU A  73      56.868 -26.990   5.575  1.00  0.00           C  
ATOM   1165  H   LEU A  73      53.115 -27.369   6.866  1.00  0.00           H  
ATOM   1166  HA  LEU A  73      55.776 -26.987   7.979  1.00  0.00           H  
ATOM   1167  HB2 LEU A  73      53.986 -25.200   6.235  1.00  0.00           H  
ATOM   1168  HB3 LEU A  73      55.634 -24.804   6.652  1.00  0.00           H  
ATOM   1169  HG  LEU A  73      54.785 -27.323   5.174  1.00  0.00           H  
ATOM   1170 HD11 LEU A  73      56.058 -24.757   4.111  1.00  0.00           H  
ATOM   1171 HD12 LEU A  73      55.810 -26.230   3.171  1.00  0.00           H  
ATOM   1172 HD13 LEU A  73      54.422 -25.322   3.774  1.00  0.00           H  
ATOM   1173 HD21 LEU A  73      57.560 -26.166   5.743  1.00  0.00           H  
ATOM   1174 HD22 LEU A  73      56.883 -27.628   6.457  1.00  0.00           H  
ATOM   1175 HD23 LEU A  73      57.237 -27.573   4.731  1.00  0.00           H  
ATOM   1176  N   SER A  74      55.400 -25.458   9.848  1.00  0.00           N  
ATOM   1177  CA  SER A  74      55.094 -24.692  11.043  1.00  0.00           C  
ATOM   1178  C   SER A  74      56.278 -23.820  11.451  1.00  0.00           C  
ATOM   1179  O   SER A  74      57.259 -23.666  10.733  1.00  0.00           O  
ATOM   1180  CB  SER A  74      54.741 -25.667  12.164  1.00  0.00           C  
ATOM   1181  OG  SER A  74      54.364 -24.979  13.328  1.00  0.00           O  
ATOM   1182  H   SER A  74      56.308 -25.856   9.702  1.00  0.00           H  
ATOM   1183  HA  SER A  74      54.240 -24.048  10.806  1.00  0.00           H  
ATOM   1184  HB2 SER A  74      53.913 -26.313  11.869  1.00  0.00           H  
ATOM   1185  HB3 SER A  74      55.593 -26.302  12.407  1.00  0.00           H  
ATOM   1186  HG  SER A  74      54.472 -25.585  14.048  1.00  0.00           H  
ATOM   1187  N   ILE A  75      56.100 -23.268  12.666  1.00  0.00           N  
ATOM   1188  CA  ILE A  75      57.128 -22.405  13.214  1.00  0.00           C  
ATOM   1189  C   ILE A  75      57.107 -22.532  14.738  1.00  0.00           C  
ATOM   1190  O   ILE A  75      56.054 -22.612  15.358  1.00  0.00           O  
ATOM   1191  CB  ILE A  75      56.834 -20.959  12.820  1.00  0.00           C  
ATOM   1192  CG1 ILE A  75      56.605 -20.839  11.317  1.00  0.00           C  
ATOM   1193  CG2 ILE A  75      57.971 -20.028  13.251  1.00  0.00           C  
ATOM   1194  CD1 ILE A  75      56.603 -19.370  10.885  1.00  0.00           C  
ATOM   1195  H   ILE A  75      55.266 -23.453  13.184  1.00  0.00           H  
ATOM   1196  HA  ILE A  75      58.092 -22.741  12.824  1.00  0.00           H  
ATOM   1197  HB  ILE A  75      55.925 -20.652  13.333  1.00  0.00           H  
ATOM   1198 HG12 ILE A  75      57.385 -21.382  10.787  1.00  0.00           H  
ATOM   1199 HG13 ILE A  75      55.656 -21.304  11.050  1.00  0.00           H  
ATOM   1200 HG21 ILE A  75      58.210 -20.167  14.304  1.00  0.00           H  
ATOM   1201 HG22 ILE A  75      58.871 -20.220  12.670  1.00  0.00           H  
ATOM   1202 HG23 ILE A  75      57.697 -18.983  13.103  1.00  0.00           H  
ATOM   1203 HD11 ILE A  75      55.817 -18.816  11.398  1.00  0.00           H  
ATOM   1204 HD12 ILE A  75      57.556 -18.897  11.118  1.00  0.00           H  
ATOM   1205 HD13 ILE A  75      56.436 -19.271   9.815  1.00  0.00           H  
ATOM   1206  N   PRO A  76      58.328 -22.547  15.315  1.00  0.00           N  
ATOM   1207  CA  PRO A  76      58.495 -22.636  16.750  1.00  0.00           C  
ATOM   1208  C   PRO A  76      57.707 -21.536  17.462  1.00  0.00           C  
ATOM   1209  O   PRO A  76      56.731 -21.780  18.161  1.00  0.00           O  
ATOM   1210  CB  PRO A  76      59.996 -22.469  17.003  1.00  0.00           C  
ATOM   1211  CG  PRO A  76      60.676 -22.362  15.627  1.00  0.00           C  
ATOM   1212  CD  PRO A  76      59.572 -22.465  14.572  1.00  0.00           C  
ATOM   1213  HA  PRO A  76      58.147 -23.606  17.098  1.00  0.00           H  
ATOM   1214  HB2 PRO A  76      60.186 -21.574  17.594  1.00  0.00           H  
ATOM   1215  HB3 PRO A  76      60.386 -23.320  17.559  1.00  0.00           H  
ATOM   1216  HG2 PRO A  76      61.204 -21.414  15.537  1.00  0.00           H  
ATOM   1217  HG3 PRO A  76      61.406 -23.162  15.498  1.00  0.00           H  
ATOM   1218  HD3 PRO A  76      59.565 -21.596  13.918  1.00  0.00           H  
ATOM   1219  HD2 PRO A  76      59.697 -23.356  13.956  1.00  0.00           H  
ATOM   1220  N   GLU A  77      58.208 -20.313  17.229  1.00  0.00           N  
ATOM   1221  CA  GLU A  77      57.553 -19.161  17.828  1.00  0.00           C  
ATOM   1222  C   GLU A  77      56.361 -18.724  16.961  1.00  0.00           C  
ATOM   1223  O   GLU A  77      55.334 -18.280  17.459  1.00  0.00           O  
ATOM   1224  CB  GLU A  77      58.563 -18.025  17.960  1.00  0.00           C  
ATOM   1225  CG  GLU A  77      59.814 -18.476  18.714  1.00  0.00           C  
ATOM   1226  CD  GLU A  77      59.483 -18.686  20.193  1.00  0.00           C  
ATOM   1227  OE1 GLU A  77      58.704 -19.587  20.498  1.00  0.00           O  
ATOM   1228  OE2 GLU A  77      60.009 -17.946  21.023  1.00  0.00           O  
ATOM   1229  H   GLU A  77      59.023 -20.199  16.663  1.00  0.00           H  
ATOM   1230  HA  GLU A  77      57.186 -19.469  18.810  1.00  0.00           H  
ATOM   1231  HB2 GLU A  77      58.844 -17.669  16.970  1.00  0.00           H  
ATOM   1232  HB3 GLU A  77      58.105 -17.183  18.480  1.00  0.00           H  
ATOM   1233  HG2 GLU A  77      60.195 -19.409  18.301  1.00  0.00           H  
ATOM   1234  HG3 GLU A  77      60.603 -17.730  18.630  1.00  0.00           H  
ATOM   1235  N   GLY A  78      56.575 -18.878  15.636  1.00  0.00           N  
ATOM   1236  CA  GLY A  78      55.525 -18.501  14.703  1.00  0.00           C  
ATOM   1237  C   GLY A  78      54.210 -19.218  15.033  1.00  0.00           C  
ATOM   1238  O   GLY A  78      53.637 -19.064  16.104  1.00  0.00           O  
ATOM   1239  H   GLY A  78      57.444 -19.242  15.304  1.00  0.00           H  
ATOM   1240  HA2 GLY A  78      55.407 -17.421  14.754  1.00  0.00           H  
ATOM   1241  HA3 GLY A  78      55.859 -18.768  13.704  1.00  0.00           H  
ATOM   1242  N   LYS A  79      53.775 -20.006  14.030  1.00  0.00           N  
ATOM   1243  CA  LYS A  79      52.544 -20.754  14.208  1.00  0.00           C  
ATOM   1244  C   LYS A  79      52.705 -22.153  13.608  1.00  0.00           C  
ATOM   1245  O   LYS A  79      53.731 -22.805  13.740  1.00  0.00           O  
ATOM   1246  CB  LYS A  79      51.403 -20.006  13.523  1.00  0.00           C  
ATOM   1247  CG  LYS A  79      50.047 -20.351  14.138  1.00  0.00           C  
ATOM   1248  CD  LYS A  79      49.284 -19.089  14.537  1.00  0.00           C  
ATOM   1249  CE  LYS A  79      48.048 -19.421  15.375  1.00  0.00           C  
ATOM   1250  NZ  LYS A  79      48.381 -20.175  16.578  1.00  0.00           N  
ATOM   1251  H   LYS A  79      54.282 -20.065  13.172  1.00  0.00           H  
ATOM   1252  HA  LYS A  79      52.361 -20.843  15.277  1.00  0.00           H  
ATOM   1253  HB2 LYS A  79      51.570 -18.944  13.596  1.00  0.00           H  
ATOM   1254  HB3 LYS A  79      51.400 -20.247  12.464  1.00  0.00           H  
ATOM   1255  HG2 LYS A  79      49.456 -20.927  13.427  1.00  0.00           H  
ATOM   1256  HG3 LYS A  79      50.193 -20.983  15.013  1.00  0.00           H  
ATOM   1257  HD2 LYS A  79      49.943 -18.429  15.102  1.00  0.00           H  
ATOM   1258  HD3 LYS A  79      48.984 -18.544  13.642  1.00  0.00           H  
ATOM   1259  HE2 LYS A  79      47.541 -18.507  15.687  1.00  0.00           H  
ATOM   1260  HE3 LYS A  79      47.340 -20.013  14.796  1.00  0.00           H  
ATOM   1261  HZ1 LYS A  79      49.086 -19.649  17.133  1.00  0.00           H  
ATOM   1262  HZ2 LYS A  79      47.522 -20.315  17.149  1.00  0.00           H  
ATOM   1263  HZ3 LYS A  79      48.772 -21.101  16.308  1.00  0.00           H  
ATOM   1264  N   LYS A  80      51.611 -22.541  12.944  1.00  0.00           N  
ATOM   1265  CA  LYS A  80      51.582 -23.848  12.299  1.00  0.00           C  
ATOM   1266  C   LYS A  80      50.638 -23.780  11.097  1.00  0.00           C  
ATOM   1267  O   LYS A  80      49.631 -23.083  11.115  1.00  0.00           O  
ATOM   1268  CB  LYS A  80      51.112 -24.905  13.296  1.00  0.00           C  
ATOM   1269  CG  LYS A  80      49.750 -24.550  13.891  1.00  0.00           C  
ATOM   1270  CD  LYS A  80      49.272 -25.620  14.873  1.00  0.00           C  
ATOM   1271  CE  LYS A  80      50.363 -25.984  15.879  1.00  0.00           C  
ATOM   1272  NZ  LYS A  80      49.896 -26.922  16.893  1.00  0.00           N  
ATOM   1273  H   LYS A  80      50.825 -21.921  12.891  1.00  0.00           H  
ATOM   1274  HA  LYS A  80      52.595 -24.063  11.949  1.00  0.00           H  
ATOM   1275  HB2 LYS A  80      51.054 -25.874  12.801  1.00  0.00           H  
ATOM   1276  HB3 LYS A  80      51.846 -25.004  14.095  1.00  0.00           H  
ATOM   1277  HG2 LYS A  80      49.814 -23.589  14.401  1.00  0.00           H  
ATOM   1278  HG3 LYS A  80      49.019 -24.434  13.091  1.00  0.00           H  
ATOM   1279  HD2 LYS A  80      48.389 -25.263  15.402  1.00  0.00           H  
ATOM   1280  HD3 LYS A  80      48.970 -26.512  14.324  1.00  0.00           H  
ATOM   1281  HE2 LYS A  80      51.215 -26.439  15.374  1.00  0.00           H  
ATOM   1282  HE3 LYS A  80      50.722 -25.092  16.394  1.00  0.00           H  
ATOM   1283  HZ1 LYS A  80      49.573 -27.798  16.434  1.00  0.00           H  
ATOM   1284  HZ2 LYS A  80      50.675 -27.141  17.549  1.00  0.00           H  
ATOM   1285  HZ3 LYS A  80      49.107 -26.497  17.422  1.00  0.00           H  
ATOM   1286  N   PHE A  81      51.022 -24.543  10.053  1.00  0.00           N  
ATOM   1287  CA  PHE A  81      50.208 -24.525   8.869  1.00  0.00           C  
ATOM   1288  C   PHE A  81      50.379 -25.815   8.068  1.00  0.00           C  
ATOM   1289  O   PHE A  81      51.238 -26.649   8.338  1.00  0.00           O  
ATOM   1290  CB  PHE A  81      50.643 -23.346   8.031  1.00  0.00           C  
ATOM   1291  CG  PHE A  81      50.245 -22.050   8.669  1.00  0.00           C  
ATOM   1292  CD1 PHE A  81      48.929 -21.550   8.512  1.00  0.00           C  
ATOM   1293  CD2 PHE A  81      51.179 -21.312   9.435  1.00  0.00           C  
ATOM   1294  CE1 PHE A  81      48.553 -20.327   9.112  1.00  0.00           C  
ATOM   1295  CE2 PHE A  81      50.804 -20.090  10.035  1.00  0.00           C  
ATOM   1296  CZ  PHE A  81      49.492 -19.597   9.874  1.00  0.00           C  
ATOM   1297  H   PHE A  81      51.853 -25.083  10.081  1.00  0.00           H  
ATOM   1298  HA  PHE A  81      49.165 -24.424   9.181  1.00  0.00           H  
ATOM   1299  HB2 PHE A  81      51.723 -23.362   7.902  1.00  0.00           H  
ATOM   1300  HB3 PHE A  81      50.204 -23.415   7.051  1.00  0.00           H  
ATOM   1301  HD1 PHE A  81      48.210 -22.105   7.928  1.00  0.00           H  
ATOM   1302  HD2 PHE A  81      52.185 -21.687   9.563  1.00  0.00           H  
ATOM   1303  HE1 PHE A  81      47.548 -19.952   8.991  1.00  0.00           H  
ATOM   1304  HE2 PHE A  81      51.523 -19.530  10.616  1.00  0.00           H  
ATOM   1305  HZ  PHE A  81      49.206 -18.664  10.333  1.00  0.00           H  
ATOM   1306  N   ASP A  82      49.508 -25.895   7.044  1.00  0.00           N  
ATOM   1307  CA  ASP A  82      49.539 -27.062   6.183  1.00  0.00           C  
ATOM   1308  C   ASP A  82      50.588 -26.859   5.091  1.00  0.00           C  
ATOM   1309  O   ASP A  82      51.384 -27.742   4.793  1.00  0.00           O  
ATOM   1310  CB  ASP A  82      48.159 -27.277   5.568  1.00  0.00           C  
ATOM   1311  CG  ASP A  82      48.124 -28.620   4.835  1.00  0.00           C  
ATOM   1312  OD1 ASP A  82      49.103 -28.950   4.165  1.00  0.00           O  
ATOM   1313  OD2 ASP A  82      47.118 -29.320   4.941  1.00  0.00           O  
ATOM   1314  H   ASP A  82      48.854 -25.159   6.880  1.00  0.00           H  
ATOM   1315  HA  ASP A  82      49.827 -27.914   6.803  1.00  0.00           H  
ATOM   1316  HB2 ASP A  82      47.390 -27.276   6.340  1.00  0.00           H  
ATOM   1317  HB3 ASP A  82      47.925 -26.481   4.862  1.00  0.00           H  
ATOM   1318  N   THR A  83      50.537 -25.639   4.515  1.00  0.00           N  
ATOM   1319  CA  THR A  83      51.485 -25.333   3.473  1.00  0.00           C  
ATOM   1320  C   THR A  83      51.812 -23.852   3.559  1.00  0.00           C  
ATOM   1321  O   THR A  83      51.164 -23.086   4.260  1.00  0.00           O  
ATOM   1322  CB  THR A  83      50.887 -25.678   2.111  1.00  0.00           C  
ATOM   1323  OG1 THR A  83      49.597 -25.125   2.015  1.00  0.00           O  
ATOM   1324  CG2 THR A  83      50.814 -27.188   1.890  1.00  0.00           C  
ATOM   1325  H   THR A  83      49.867 -24.951   4.801  1.00  0.00           H  
ATOM   1326  HA  THR A  83      52.387 -25.917   3.668  1.00  0.00           H  
ATOM   1327  HB  THR A  83      51.488 -25.227   1.324  1.00  0.00           H  
ATOM   1328  HG1 THR A  83      49.692 -24.285   1.586  1.00  0.00           H  
ATOM   1329 HG21 THR A  83      50.279 -27.675   2.706  1.00  0.00           H  
ATOM   1330 HG22 THR A  83      50.296 -27.421   0.960  1.00  0.00           H  
ATOM   1331 HG23 THR A  83      51.813 -27.621   1.837  1.00  0.00           H  
ATOM   1332  N   LEU A  84      52.854 -23.503   2.801  1.00  0.00           N  
ATOM   1333  CA  LEU A  84      53.276 -22.138   2.783  1.00  0.00           C  
ATOM   1334  C   LEU A  84      52.204 -21.205   2.226  1.00  0.00           C  
ATOM   1335  O   LEU A  84      52.378 -20.000   2.158  1.00  0.00           O  
ATOM   1336  CB  LEU A  84      54.483 -22.103   1.884  1.00  0.00           C  
ATOM   1337  CG  LEU A  84      55.786 -22.002   2.658  1.00  0.00           C  
ATOM   1338  CD1 LEU A  84      56.936 -21.751   1.689  1.00  0.00           C  
ATOM   1339  CD2 LEU A  84      55.705 -20.894   3.707  1.00  0.00           C  
ATOM   1340  H   LEU A  84      53.350 -24.166   2.251  1.00  0.00           H  
ATOM   1341  HA  LEU A  84      53.499 -21.848   3.806  1.00  0.00           H  
ATOM   1342  HB2 LEU A  84      54.502 -23.001   1.266  1.00  0.00           H  
ATOM   1343  HB3 LEU A  84      54.375 -21.280   1.207  1.00  0.00           H  
ATOM   1344  HG  LEU A  84      55.962 -22.952   3.164  1.00  0.00           H  
ATOM   1345 HD11 LEU A  84      56.761 -20.848   1.106  1.00  0.00           H  
ATOM   1346 HD12 LEU A  84      57.877 -21.635   2.223  1.00  0.00           H  
ATOM   1347 HD13 LEU A  84      57.041 -22.585   0.994  1.00  0.00           H  
ATOM   1348 HD21 LEU A  84      55.186 -20.022   3.311  1.00  0.00           H  
ATOM   1349 HD22 LEU A  84      55.168 -21.235   4.592  1.00  0.00           H  
ATOM   1350 HD23 LEU A  84      56.701 -20.583   4.018  1.00  0.00           H  
ATOM   1351  N   TRP A  85      51.106 -21.839   1.834  1.00  0.00           N  
ATOM   1352  CA  TRP A  85      50.008 -21.065   1.280  1.00  0.00           C  
ATOM   1353  C   TRP A  85      49.123 -20.560   2.396  1.00  0.00           C  
ATOM   1354  O   TRP A  85      48.501 -19.508   2.312  1.00  0.00           O  
ATOM   1355  CB  TRP A  85      49.194 -21.967   0.367  1.00  0.00           C  
ATOM   1356  CG  TRP A  85      49.195 -21.412  -1.035  1.00  0.00           C  
ATOM   1357  CD1 TRP A  85      48.802 -20.124  -1.389  1.00  0.00           C  
ATOM   1358  CD2 TRP A  85      49.584 -22.085  -2.231  1.00  0.00           C  
ATOM   1359  NE1 TRP A  85      48.928 -19.969  -2.741  1.00  0.00           N  
ATOM   1360  CE2 TRP A  85      49.410 -21.157  -3.304  1.00  0.00           C  
ATOM   1361  CE3 TRP A  85      50.056 -23.368  -2.479  1.00  0.00           C  
ATOM   1362  CZ2 TRP A  85      49.708 -21.527  -4.609  1.00  0.00           C  
ATOM   1363  CZ3 TRP A  85      50.365 -23.755  -3.807  1.00  0.00           C  
ATOM   1364  CH2 TRP A  85      50.190 -22.833  -4.874  1.00  0.00           C  
ATOM   1365  H   TRP A  85      51.035 -22.830   1.952  1.00  0.00           H  
ATOM   1366  HA  TRP A  85      50.436 -20.208   0.751  1.00  0.00           H  
ATOM   1367  HB2 TRP A  85      49.610 -22.972   0.377  1.00  0.00           H  
ATOM   1368  HB3 TRP A  85      48.166 -22.037   0.722  1.00  0.00           H  
ATOM   1369  HD1 TRP A  85      48.450 -19.368  -0.700  1.00  0.00           H  
ATOM   1370  HE1 TRP A  85      48.715 -19.153  -3.239  1.00  0.00           H  
ATOM   1371  HE3 TRP A  85      50.188 -24.065  -1.665  1.00  0.00           H  
ATOM   1372  HZ2 TRP A  85      49.575 -20.822  -5.417  1.00  0.00           H  
ATOM   1373  HZ3 TRP A  85      50.731 -24.751  -4.008  1.00  0.00           H  
ATOM   1374  HH2 TRP A  85      50.424 -23.128  -5.886  1.00  0.00           H  
ATOM   1375  N   GLN A  86      49.113 -21.382   3.441  1.00  0.00           N  
ATOM   1376  CA  GLN A  86      48.296 -21.017   4.573  1.00  0.00           C  
ATOM   1377  C   GLN A  86      49.113 -20.188   5.529  1.00  0.00           C  
ATOM   1378  O   GLN A  86      48.663 -19.195   6.061  1.00  0.00           O  
ATOM   1379  CB  GLN A  86      47.751 -22.270   5.254  1.00  0.00           C  
ATOM   1380  CG  GLN A  86      46.770 -23.021   4.352  1.00  0.00           C  
ATOM   1381  CD  GLN A  86      45.509 -22.179   4.147  1.00  0.00           C  
ATOM   1382  OE1 GLN A  86      44.540 -22.274   4.890  1.00  0.00           O  
ATOM   1383  NE2 GLN A  86      45.593 -21.357   3.086  1.00  0.00           N  
ATOM   1384  H   GLN A  86      49.699 -22.206   3.445  1.00  0.00           H  
ATOM   1385  HA  GLN A  86      47.496 -20.388   4.190  1.00  0.00           H  
ATOM   1386  HB2 GLN A  86      48.578 -22.928   5.522  1.00  0.00           H  
ATOM   1387  HB3 GLN A  86      47.254 -21.994   6.184  1.00  0.00           H  
ATOM   1388  HG2 GLN A  86      47.221 -23.228   3.382  1.00  0.00           H  
ATOM   1389  HG3 GLN A  86      46.490 -23.975   4.799  1.00  0.00           H  
ATOM   1390 HE21 GLN A  86      46.418 -21.335   2.522  1.00  0.00           H  
ATOM   1391 HE22 GLN A  86      44.833 -20.755   2.846  1.00  0.00           H  
ATOM   1392  N   LEU A  87      50.344 -20.640   5.704  1.00  0.00           N  
ATOM   1393  CA  LEU A  87      51.189 -19.888   6.593  1.00  0.00           C  
ATOM   1394  C   LEU A  87      51.445 -18.493   6.026  1.00  0.00           C  
ATOM   1395  O   LEU A  87      51.645 -17.540   6.762  1.00  0.00           O  
ATOM   1396  CB  LEU A  87      52.495 -20.645   6.794  1.00  0.00           C  
ATOM   1397  CG  LEU A  87      53.447 -19.896   7.714  1.00  0.00           C  
ATOM   1398  CD1 LEU A  87      54.550 -20.831   8.203  1.00  0.00           C  
ATOM   1399  CD2 LEU A  87      54.045 -18.694   6.982  1.00  0.00           C  
ATOM   1400  H   LEU A  87      50.668 -21.471   5.238  1.00  0.00           H  
ATOM   1401  HA  LEU A  87      50.637 -19.770   7.530  1.00  0.00           H  
ATOM   1402  HB2 LEU A  87      52.287 -21.629   7.206  1.00  0.00           H  
ATOM   1403  HB3 LEU A  87      52.975 -20.806   5.828  1.00  0.00           H  
ATOM   1404  HG  LEU A  87      52.886 -19.539   8.580  1.00  0.00           H  
ATOM   1405 HD11 LEU A  87      54.142 -21.804   8.477  1.00  0.00           H  
ATOM   1406 HD12 LEU A  87      55.301 -20.987   7.428  1.00  0.00           H  
ATOM   1407 HD13 LEU A  87      55.049 -20.421   9.078  1.00  0.00           H  
ATOM   1408 HD21 LEU A  87      53.807 -18.731   5.918  1.00  0.00           H  
ATOM   1409 HD22 LEU A  87      53.651 -17.760   7.382  1.00  0.00           H  
ATOM   1410 HD23 LEU A  87      55.127 -18.675   7.084  1.00  0.00           H  
ATOM   1411  N   VAL A  88      51.402 -18.424   4.683  1.00  0.00           N  
ATOM   1412  CA  VAL A  88      51.643 -17.160   4.064  1.00  0.00           C  
ATOM   1413  C   VAL A  88      50.387 -16.325   4.071  1.00  0.00           C  
ATOM   1414  O   VAL A  88      50.407 -15.160   4.410  1.00  0.00           O  
ATOM   1415  CB  VAL A  88      52.067 -17.374   2.633  1.00  0.00           C  
ATOM   1416  CG1 VAL A  88      51.843 -16.091   1.861  1.00  0.00           C  
ATOM   1417  CG2 VAL A  88      53.526 -17.810   2.563  1.00  0.00           C  
ATOM   1418  H   VAL A  88      51.197 -19.215   4.129  1.00  0.00           H  
ATOM   1419  HA  VAL A  88      52.421 -16.650   4.634  1.00  0.00           H  
ATOM   1420  HB  VAL A  88      51.439 -18.150   2.197  1.00  0.00           H  
ATOM   1421 HG11 VAL A  88      52.288 -15.249   2.388  1.00  0.00           H  
ATOM   1422 HG12 VAL A  88      52.277 -16.151   0.872  1.00  0.00           H  
ATOM   1423 HG13 VAL A  88      50.774 -15.896   1.757  1.00  0.00           H  
ATOM   1424 HG21 VAL A  88      53.704 -18.672   3.206  1.00  0.00           H  
ATOM   1425 HG22 VAL A  88      53.800 -18.085   1.544  1.00  0.00           H  
ATOM   1426 HG23 VAL A  88      54.186 -17.006   2.885  1.00  0.00           H  
ATOM   1427  N   GLU A  89      49.303 -16.978   3.629  1.00  0.00           N  
ATOM   1428  CA  GLU A  89      48.070 -16.225   3.570  1.00  0.00           C  
ATOM   1429  C   GLU A  89      47.668 -15.777   4.956  1.00  0.00           C  
ATOM   1430  O   GLU A  89      47.251 -14.648   5.180  1.00  0.00           O  
ATOM   1431  CB  GLU A  89      46.985 -17.059   2.947  1.00  0.00           C  
ATOM   1432  CG  GLU A  89      46.656 -18.285   3.773  1.00  0.00           C  
ATOM   1433  CD  GLU A  89      45.364 -18.057   4.560  1.00  0.00           C  
ATOM   1434  OE1 GLU A  89      44.293 -18.097   3.955  1.00  0.00           O  
ATOM   1435  OE2 GLU A  89      45.443 -17.842   5.768  1.00  0.00           O  
ATOM   1436  H   GLU A  89      49.339 -17.959   3.369  1.00  0.00           H  
ATOM   1437  HA  GLU A  89      48.266 -15.345   2.961  1.00  0.00           H  
ATOM   1438  HB2 GLU A  89      46.093 -16.458   2.819  1.00  0.00           H  
ATOM   1439  HB3 GLU A  89      47.310 -17.365   1.970  1.00  0.00           H  
ATOM   1440  HG2 GLU A  89      46.532 -19.147   3.123  1.00  0.00           H  
ATOM   1441  HG3 GLU A  89      47.459 -18.505   4.464  1.00  0.00           H  
ATOM   1442  N   HIS A  90      47.821 -16.735   5.870  1.00  0.00           N  
ATOM   1443  CA  HIS A  90      47.453 -16.408   7.233  1.00  0.00           C  
ATOM   1444  C   HIS A  90      48.235 -15.203   7.679  1.00  0.00           C  
ATOM   1445  O   HIS A  90      47.700 -14.190   8.094  1.00  0.00           O  
ATOM   1446  CB  HIS A  90      47.739 -17.576   8.157  1.00  0.00           C  
ATOM   1447  CG  HIS A  90      46.785 -17.537   9.326  1.00  0.00           C  
ATOM   1448  ND1 HIS A  90      45.448 -17.691   9.214  1.00  0.00           N  
ATOM   1449  CD2 HIS A  90      47.090 -17.341  10.686  1.00  0.00           C  
ATOM   1450  CE1 HIS A  90      44.948 -17.593  10.456  1.00  0.00           C  
ATOM   1451  NE2 HIS A  90      45.918 -17.382  11.363  1.00  0.00           N  
ATOM   1452  H   HIS A  90      48.178 -17.653   5.606  1.00  0.00           H  
ATOM   1453  HA  HIS A  90      46.404 -16.151   7.222  1.00  0.00           H  
ATOM   1454  HB2 HIS A  90      47.627 -18.505   7.632  1.00  0.00           H  
ATOM   1455  HB3 HIS A  90      48.764 -17.528   8.520  1.00  0.00           H  
ATOM   1456  HD1 HIS A  90      44.943 -17.845   8.388  1.00  0.00           H  
ATOM   1457  HD2 HIS A  90      48.072 -17.188  11.109  1.00  0.00           H  
ATOM   1458  HE1 HIS A  90      43.898 -17.672  10.696  1.00  0.00           H  
ATOM   1459  N   TYR A  91      49.538 -15.401   7.578  1.00  0.00           N  
ATOM   1460  CA  TYR A  91      50.428 -14.330   7.967  1.00  0.00           C  
ATOM   1461  C   TYR A  91      50.169 -13.098   7.101  1.00  0.00           C  
ATOM   1462  O   TYR A  91      50.462 -11.974   7.489  1.00  0.00           O  
ATOM   1463  CB  TYR A  91      51.868 -14.787   7.860  1.00  0.00           C  
ATOM   1464  CG  TYR A  91      52.303 -15.452   9.141  1.00  0.00           C  
ATOM   1465  CD1 TYR A  91      51.373 -16.212   9.897  1.00  0.00           C  
ATOM   1466  CD2 TYR A  91      53.637 -15.342   9.606  1.00  0.00           C  
ATOM   1467  CE1 TYR A  91      51.769 -16.855  11.088  1.00  0.00           C  
ATOM   1468  CE2 TYR A  91      54.030 -15.987  10.804  1.00  0.00           C  
ATOM   1469  CZ  TYR A  91      53.098 -16.743  11.540  1.00  0.00           C  
ATOM   1470  OH  TYR A  91      53.485 -17.374  12.705  1.00  0.00           O  
ATOM   1471  H   TYR A  91      49.881 -16.269   7.244  1.00  0.00           H  
ATOM   1472  HA  TYR A  91      50.187 -14.080   9.004  1.00  0.00           H  
ATOM   1473  HB2 TYR A  91      51.984 -15.485   7.034  1.00  0.00           H  
ATOM   1474  HB3 TYR A  91      52.505 -13.937   7.653  1.00  0.00           H  
ATOM   1475  HD1 TYR A  91      50.350 -16.276   9.573  1.00  0.00           H  
ATOM   1476  HD2 TYR A  91      54.353 -14.752   9.054  1.00  0.00           H  
ATOM   1477  HE1 TYR A  91      51.046 -17.420  11.663  1.00  0.00           H  
ATOM   1478  HE2 TYR A  91      55.039 -15.890  11.165  1.00  0.00           H  
ATOM   1479  HH  TYR A  91      52.747 -17.842  13.071  1.00  0.00           H  
ATOM   1480  N   SER A  92      49.601 -13.365   5.904  1.00  0.00           N  
ATOM   1481  CA  SER A  92      49.272 -12.237   5.052  1.00  0.00           C  
ATOM   1482  C   SER A  92      48.258 -11.342   5.772  1.00  0.00           C  
ATOM   1483  O   SER A  92      47.988 -10.212   5.385  1.00  0.00           O  
ATOM   1484  CB  SER A  92      48.666 -12.774   3.781  1.00  0.00           C  
ATOM   1485  OG  SER A  92      49.187 -12.124   2.650  1.00  0.00           O  
ATOM   1486  H   SER A  92      49.402 -14.322   5.603  1.00  0.00           H  
ATOM   1487  HA  SER A  92      50.191 -11.682   4.858  1.00  0.00           H  
ATOM   1488  HB2 SER A  92      48.871 -13.828   3.701  1.00  0.00           H  
ATOM   1489  HB3 SER A  92      47.587 -12.650   3.789  1.00  0.00           H  
ATOM   1490  HG  SER A  92      48.800 -12.541   1.893  1.00  0.00           H  
ATOM   1491  N   TYR A  93      47.728 -11.947   6.848  1.00  0.00           N  
ATOM   1492  CA  TYR A  93      46.743 -11.263   7.645  1.00  0.00           C  
ATOM   1493  C   TYR A  93      47.452 -10.476   8.723  1.00  0.00           C  
ATOM   1494  O   TYR A  93      47.316  -9.269   8.853  1.00  0.00           O  
ATOM   1495  CB  TYR A  93      45.842 -12.295   8.313  1.00  0.00           C  
ATOM   1496  CG  TYR A  93      45.214 -13.244   7.327  1.00  0.00           C  
ATOM   1497  CD1 TYR A  93      45.188 -12.942   5.941  1.00  0.00           C  
ATOM   1498  CD2 TYR A  93      44.642 -14.455   7.781  1.00  0.00           C  
ATOM   1499  CE1 TYR A  93      44.593 -13.841   5.025  1.00  0.00           C  
ATOM   1500  CE2 TYR A  93      44.046 -15.353   6.866  1.00  0.00           C  
ATOM   1501  CZ  TYR A  93      44.022 -15.046   5.489  1.00  0.00           C  
ATOM   1502  OH  TYR A  93      43.442 -15.923   4.596  1.00  0.00           O  
ATOM   1503  H   TYR A  93      48.037 -12.871   7.100  1.00  0.00           H  
ATOM   1504  HA  TYR A  93      46.181 -10.593   6.992  1.00  0.00           H  
ATOM   1505  HB2 TYR A  93      46.412 -12.870   9.038  1.00  0.00           H  
ATOM   1506  HB3 TYR A  93      45.067 -11.792   8.865  1.00  0.00           H  
ATOM   1507  HD1 TYR A  93      45.641 -12.029   5.582  1.00  0.00           H  
ATOM   1508  HD2 TYR A  93      44.676 -14.702   8.833  1.00  0.00           H  
ATOM   1509  HE1 TYR A  93      44.579 -13.607   3.972  1.00  0.00           H  
ATOM   1510  HE2 TYR A  93      43.615 -16.277   7.222  1.00  0.00           H  
ATOM   1511  HH  TYR A  93      43.151 -16.698   5.058  1.00  0.00           H  
ATOM   1512  N   LYS A  94      48.167 -11.290   9.512  1.00  0.00           N  
ATOM   1513  CA  LYS A  94      48.923 -10.761  10.603  1.00  0.00           C  
ATOM   1514  C   LYS A  94      50.334 -11.302  10.609  1.00  0.00           C  
ATOM   1515  O   LYS A  94      50.762 -12.082   9.768  1.00  0.00           O  
ATOM   1516  CB  LYS A  94      48.270 -11.245  11.867  1.00  0.00           C  
ATOM   1517  CG  LYS A  94      48.035 -12.759  11.799  1.00  0.00           C  
ATOM   1518  CD  LYS A  94      47.352 -13.288  13.060  1.00  0.00           C  
ATOM   1519  CE  LYS A  94      46.065 -14.042  12.721  1.00  0.00           C  
ATOM   1520  NZ  LYS A  94      45.414 -14.594  13.903  1.00  0.00           N  
ATOM   1521  H   LYS A  94      48.120 -12.262   9.385  1.00  0.00           H  
ATOM   1522  HA  LYS A  94      48.929  -9.673  10.534  1.00  0.00           H  
ATOM   1523  HB2 LYS A  94      48.899 -11.008  12.718  1.00  0.00           H  
ATOM   1524  HB3 LYS A  94      47.344 -10.726  12.005  1.00  0.00           H  
ATOM   1525  HG2 LYS A  94      47.424 -12.999  10.926  1.00  0.00           H  
ATOM   1526  HG3 LYS A  94      48.990 -13.272  11.657  1.00  0.00           H  
ATOM   1527  HD2 LYS A  94      48.034 -13.950  13.594  1.00  0.00           H  
ATOM   1528  HD3 LYS A  94      47.128 -12.460  13.731  1.00  0.00           H  
ATOM   1529  HE2 LYS A  94      45.351 -13.380  12.228  1.00  0.00           H  
ATOM   1530  HE3 LYS A  94      46.272 -14.868  12.040  1.00  0.00           H  
ATOM   1531  HZ1 LYS A  94      46.087 -15.193  14.421  1.00  0.00           H  
ATOM   1532  HZ2 LYS A  94      45.096 -13.818  14.518  1.00  0.00           H  
ATOM   1533  HZ3 LYS A  94      44.594 -15.165  13.612  1.00  0.00           H  
ATOM   1534  N   ALA A  95      51.000 -10.820  11.651  1.00  0.00           N  
ATOM   1535  CA  ALA A  95      52.360 -11.251  11.889  1.00  0.00           C  
ATOM   1536  C   ALA A  95      52.316 -12.619  12.581  1.00  0.00           C  
ATOM   1537  O   ALA A  95      53.056 -13.534  12.255  1.00  0.00           O  
ATOM   1538  CB  ALA A  95      53.074 -10.225  12.765  1.00  0.00           C  
ATOM   1539  H   ALA A  95      50.554 -10.159  12.251  1.00  0.00           H  
ATOM   1540  HA  ALA A  95      52.851 -11.351  10.918  1.00  0.00           H  
ATOM   1541  HB1 ALA A  95      52.508 -10.030  13.676  1.00  0.00           H  
ATOM   1542  HB2 ALA A  95      54.063 -10.580  13.055  1.00  0.00           H  
ATOM   1543  HB3 ALA A  95      53.197  -9.279  12.236  1.00  0.00           H  
ATOM   1544  N   ASP A  96      51.376 -12.695  13.547  1.00  0.00           N  
ATOM   1545  CA  ASP A  96      51.222 -13.949  14.281  1.00  0.00           C  
ATOM   1546  C   ASP A  96      52.393 -14.186  15.237  1.00  0.00           C  
ATOM   1547  O   ASP A  96      52.383 -15.080  16.074  1.00  0.00           O  
ATOM   1548  CB  ASP A  96      51.113 -15.091  13.293  1.00  0.00           C  
ATOM   1549  CG  ASP A  96      49.729 -15.734  13.387  1.00  0.00           C  
ATOM   1550  OD1 ASP A  96      49.432 -16.340  14.415  1.00  0.00           O  
ATOM   1551  OD2 ASP A  96      48.965 -15.622  12.430  1.00  0.00           O  
ATOM   1552  H   ASP A  96      50.796 -11.907  13.755  1.00  0.00           H  
ATOM   1553  HA  ASP A  96      50.325 -13.865  14.860  1.00  0.00           H  
ATOM   1554  HB2 ASP A  96      51.271 -14.731  12.278  1.00  0.00           H  
ATOM   1555  HB3 ASP A  96      51.869 -15.840  13.505  1.00  0.00           H  
ATOM   1556  N   GLY A  97      53.380 -13.324  15.044  1.00  0.00           N  
ATOM   1557  CA  GLY A  97      54.573 -13.409  15.866  1.00  0.00           C  
ATOM   1558  C   GLY A  97      55.776 -12.721  15.202  1.00  0.00           C  
ATOM   1559  O   GLY A  97      56.751 -12.364  15.852  1.00  0.00           O  
ATOM   1560  H   GLY A  97      53.284 -12.633  14.336  1.00  0.00           H  
ATOM   1561  HA2 GLY A  97      54.349 -12.938  16.821  1.00  0.00           H  
ATOM   1562  HA3 GLY A  97      54.784 -14.465  16.031  1.00  0.00           H  
ATOM   1563  N   LEU A  98      55.644 -12.573  13.868  1.00  0.00           N  
ATOM   1564  CA  LEU A  98      56.717 -11.949  13.127  1.00  0.00           C  
ATOM   1565  C   LEU A  98      57.060 -10.617  13.779  1.00  0.00           C  
ATOM   1566  O   LEU A  98      56.602 -10.285  14.865  1.00  0.00           O  
ATOM   1567  CB  LEU A  98      56.250 -11.679  11.704  1.00  0.00           C  
ATOM   1568  CG  LEU A  98      55.723 -12.932  11.034  1.00  0.00           C  
ATOM   1569  CD1 LEU A  98      54.922 -12.571   9.790  1.00  0.00           C  
ATOM   1570  CD2 LEU A  98      56.886 -13.855  10.686  1.00  0.00           C  
ATOM   1571  H   LEU A  98      54.817 -12.880  13.397  1.00  0.00           H  
ATOM   1572  HA  LEU A  98      57.581 -12.634  13.143  1.00  0.00           H  
ATOM   1573  HB2 LEU A  98      55.471 -10.918  11.714  1.00  0.00           H  
ATOM   1574  HB3 LEU A  98      57.073 -11.275  11.123  1.00  0.00           H  
ATOM   1575  HG  LEU A  98      55.063 -13.444  11.727  1.00  0.00           H  
ATOM   1576 HD11 LEU A  98      54.967 -11.498   9.596  1.00  0.00           H  
ATOM   1577 HD12 LEU A  98      55.315 -13.087   8.918  1.00  0.00           H  
ATOM   1578 HD13 LEU A  98      53.873 -12.847   9.905  1.00  0.00           H  
ATOM   1579 HD21 LEU A  98      57.606 -13.886  11.501  1.00  0.00           H  
ATOM   1580 HD22 LEU A  98      56.535 -14.869  10.510  1.00  0.00           H  
ATOM   1581 HD23 LEU A  98      57.403 -13.512   9.798  1.00  0.00           H  
ATOM   1582  N   LEU A  99      57.888  -9.878  13.029  1.00  0.00           N  
ATOM   1583  CA  LEU A  99      58.237  -8.553  13.498  1.00  0.00           C  
ATOM   1584  C   LEU A  99      57.037  -7.638  13.224  1.00  0.00           C  
ATOM   1585  O   LEU A  99      56.650  -6.804  14.034  1.00  0.00           O  
ATOM   1586  CB  LEU A  99      59.478  -8.061  12.758  1.00  0.00           C  
ATOM   1587  CG  LEU A  99      60.357  -7.182  13.646  1.00  0.00           C  
ATOM   1588  CD1 LEU A  99      59.603  -5.924  14.073  1.00  0.00           C  
ATOM   1589  CD2 LEU A  99      60.823  -7.966  14.872  1.00  0.00           C  
ATOM   1590  H   LEU A  99      58.258 -10.232  12.171  1.00  0.00           H  
ATOM   1591  HA  LEU A  99      58.411  -8.619  14.573  1.00  0.00           H  
ATOM   1592  HB2 LEU A  99      60.055  -8.916  12.409  1.00  0.00           H  
ATOM   1593  HB3 LEU A  99      59.177  -7.502  11.872  1.00  0.00           H  
ATOM   1594  HG  LEU A  99      61.233  -6.878  13.071  1.00  0.00           H  
ATOM   1595 HD11 LEU A  99      59.297  -5.341  13.205  1.00  0.00           H  
ATOM   1596 HD12 LEU A  99      58.708  -6.182  14.640  1.00  0.00           H  
ATOM   1597 HD13 LEU A  99      60.229  -5.291  14.702  1.00  0.00           H  
ATOM   1598 HD21 LEU A  99      61.174  -8.957  14.588  1.00  0.00           H  
ATOM   1599 HD22 LEU A  99      61.641  -7.451  15.376  1.00  0.00           H  
ATOM   1600 HD23 LEU A  99      60.012  -8.089  15.588  1.00  0.00           H  
ATOM   1601  N   ARG A 100      56.484  -7.873  12.015  1.00  0.00           N  
ATOM   1602  CA  ARG A 100      55.323  -7.124  11.594  1.00  0.00           C  
ATOM   1603  C   ARG A 100      54.574  -7.951  10.546  1.00  0.00           C  
ATOM   1604  O   ARG A 100      55.147  -8.789   9.862  1.00  0.00           O  
ATOM   1605  CB  ARG A 100      55.779  -5.806  10.992  1.00  0.00           C  
ATOM   1606  CG  ARG A 100      54.652  -4.775  10.945  1.00  0.00           C  
ATOM   1607  CD  ARG A 100      54.404  -4.150  12.318  1.00  0.00           C  
ATOM   1608  NE  ARG A 100      54.042  -2.752  12.176  1.00  0.00           N  
ATOM   1609  CZ  ARG A 100      52.756  -2.438  11.930  1.00  0.00           C  
ATOM   1610  NH1 ARG A 100      51.842  -3.399  11.826  1.00  0.00           N  
ATOM   1611  NH2 ARG A 100      52.399  -1.164  11.792  1.00  0.00           N  
ATOM   1612  H   ARG A 100      56.887  -8.550  11.403  1.00  0.00           H  
ATOM   1613  HA  ARG A 100      54.689  -6.967  12.470  1.00  0.00           H  
ATOM   1614  HB2 ARG A 100      56.616  -5.412  11.567  1.00  0.00           H  
ATOM   1615  HB3 ARG A 100      56.147  -5.991   9.987  1.00  0.00           H  
ATOM   1616  HG2 ARG A 100      54.905  -3.992  10.229  1.00  0.00           H  
ATOM   1617  HG3 ARG A 100      53.736  -5.245  10.585  1.00  0.00           H  
ATOM   1618  HD2 ARG A 100      53.586  -4.640  12.843  1.00  0.00           H  
ATOM   1619  HD3 ARG A 100      55.296  -4.193  12.945  1.00  0.00           H  
ATOM   1620  HE  ARG A 100      54.733  -2.034  12.257  1.00  0.00           H  
ATOM   1621 HH11 ARG A 100      52.110  -4.357  11.930  1.00  0.00           H  
ATOM   1622 HH12 ARG A 100      50.887  -3.165  11.642  1.00  0.00           H  
ATOM   1623 HH21 ARG A 100      53.085  -0.441  11.871  1.00  0.00           H  
ATOM   1624 HH22 ARG A 100      51.444  -0.929  11.609  1.00  0.00           H  
ATOM   1625  N   VAL A 101      53.266  -7.665  10.469  1.00  0.00           N  
ATOM   1626  CA  VAL A 101      52.455  -8.371   9.514  1.00  0.00           C  
ATOM   1627  C   VAL A 101      53.093  -8.273   8.130  1.00  0.00           C  
ATOM   1628  O   VAL A 101      54.095  -7.601   7.920  1.00  0.00           O  
ATOM   1629  CB  VAL A 101      51.099  -7.701   9.463  1.00  0.00           C  
ATOM   1630  CG1 VAL A 101      50.102  -8.600   8.776  1.00  0.00           C  
ATOM   1631  CG2 VAL A 101      50.614  -7.335  10.866  1.00  0.00           C  
ATOM   1632  H   VAL A 101      52.854  -6.973  11.049  1.00  0.00           H  
ATOM   1633  HA  VAL A 101      52.365  -9.420   9.838  1.00  0.00           H  
ATOM   1634  HB  VAL A 101      51.194  -6.796   8.871  1.00  0.00           H  
ATOM   1635 HG11 VAL A 101      50.283  -9.639   9.027  1.00  0.00           H  
ATOM   1636 HG12 VAL A 101      49.097  -8.344   9.083  1.00  0.00           H  
ATOM   1637 HG13 VAL A 101      50.168  -8.497   7.696  1.00  0.00           H  
ATOM   1638 HG21 VAL A 101      51.320  -6.669  11.361  1.00  0.00           H  
ATOM   1639 HG22 VAL A 101      49.649  -6.831  10.824  1.00  0.00           H  
ATOM   1640 HG23 VAL A 101      50.502  -8.226  11.484  1.00  0.00           H  
ATOM   1641  N   LEU A 102      52.431  -8.989   7.215  1.00  0.00           N  
ATOM   1642  CA  LEU A 102      52.867  -8.957   5.832  1.00  0.00           C  
ATOM   1643  C   LEU A 102      51.920  -8.053   5.067  1.00  0.00           C  
ATOM   1644  O   LEU A 102      50.767  -7.856   5.433  1.00  0.00           O  
ATOM   1645  CB  LEU A 102      52.820 -10.343   5.227  1.00  0.00           C  
ATOM   1646  CG  LEU A 102      53.927 -11.261   5.746  1.00  0.00           C  
ATOM   1647  CD1 LEU A 102      54.133 -11.104   7.248  1.00  0.00           C  
ATOM   1648  CD2 LEU A 102      53.598 -12.714   5.413  1.00  0.00           C  
ATOM   1649  H   LEU A 102      51.657  -9.551   7.487  1.00  0.00           H  
ATOM   1650  HA  LEU A 102      53.876  -8.531   5.790  1.00  0.00           H  
ATOM   1651  HB2 LEU A 102      51.855 -10.778   5.425  1.00  0.00           H  
ATOM   1652  HB3 LEU A 102      52.899 -10.260   4.152  1.00  0.00           H  
ATOM   1653  HG  LEU A 102      54.856 -10.992   5.249  1.00  0.00           H  
ATOM   1654 HD11 LEU A 102      53.209 -11.296   7.794  1.00  0.00           H  
ATOM   1655 HD12 LEU A 102      54.884 -11.803   7.600  1.00  0.00           H  
ATOM   1656 HD13 LEU A 102      54.474 -10.102   7.494  1.00  0.00           H  
ATOM   1657 HD21 LEU A 102      53.463 -12.845   4.342  1.00  0.00           H  
ATOM   1658 HD22 LEU A 102      54.397 -13.380   5.738  1.00  0.00           H  
ATOM   1659 HD23 LEU A 102      52.677 -13.025   5.907  1.00  0.00           H  
ATOM   1660  N   THR A 103      52.489  -7.524   3.991  1.00  0.00           N  
ATOM   1661  CA  THR A 103      51.710  -6.621   3.183  1.00  0.00           C  
ATOM   1662  C   THR A 103      52.179  -6.644   1.721  1.00  0.00           C  
ATOM   1663  O   THR A 103      51.390  -6.533   0.791  1.00  0.00           O  
ATOM   1664  CB  THR A 103      51.866  -5.232   3.801  1.00  0.00           C  
ATOM   1665  OG1 THR A 103      50.643  -4.823   4.357  1.00  0.00           O  
ATOM   1666  CG2 THR A 103      52.344  -4.200   2.798  1.00  0.00           C  
ATOM   1667  H   THR A 103      53.432  -7.731   3.767  1.00  0.00           H  
ATOM   1668  HA  THR A 103      50.671  -6.955   3.232  1.00  0.00           H  
ATOM   1669  HB  THR A 103      52.588  -5.288   4.614  1.00  0.00           H  
ATOM   1670  HG1 THR A 103      50.375  -5.507   4.957  1.00  0.00           H  
ATOM   1671 HG21 THR A 103      51.670  -4.148   1.946  1.00  0.00           H  
ATOM   1672 HG22 THR A 103      52.398  -3.213   3.253  1.00  0.00           H  
ATOM   1673 HG23 THR A 103      53.337  -4.459   2.435  1.00  0.00           H  
ATOM   1674  N   VAL A 104      53.510  -6.796   1.585  1.00  0.00           N  
ATOM   1675  CA  VAL A 104      54.070  -6.779   0.227  1.00  0.00           C  
ATOM   1676  C   VAL A 104      55.061  -7.920  -0.013  1.00  0.00           C  
ATOM   1677  O   VAL A 104      55.783  -8.339   0.877  1.00  0.00           O  
ATOM   1678  CB  VAL A 104      54.824  -5.463   0.043  1.00  0.00           C  
ATOM   1679  CG1 VAL A 104      55.501  -5.397  -1.326  1.00  0.00           C  
ATOM   1680  CG2 VAL A 104      53.889  -4.269   0.207  1.00  0.00           C  
ATOM   1681  H   VAL A 104      54.093  -6.906   2.397  1.00  0.00           H  
ATOM   1682  HA  VAL A 104      53.240  -6.855  -0.472  1.00  0.00           H  
ATOM   1683  HB  VAL A 104      55.603  -5.420   0.811  1.00  0.00           H  
ATOM   1684 HG11 VAL A 104      56.046  -6.313  -1.538  1.00  0.00           H  
ATOM   1685 HG12 VAL A 104      54.767  -5.246  -2.116  1.00  0.00           H  
ATOM   1686 HG13 VAL A 104      56.209  -4.571  -1.367  1.00  0.00           H  
ATOM   1687 HG21 VAL A 104      52.897  -4.593   0.513  1.00  0.00           H  
ATOM   1688 HG22 VAL A 104      54.269  -3.575   0.957  1.00  0.00           H  
ATOM   1689 HG23 VAL A 104      53.788  -3.725  -0.732  1.00  0.00           H  
ATOM   1690  N   PRO A 105      55.051  -8.407  -1.290  1.00  0.00           N  
ATOM   1691  CA  PRO A 105      55.987  -9.422  -1.747  1.00  0.00           C  
ATOM   1692  C   PRO A 105      57.352  -8.765  -2.006  1.00  0.00           C  
ATOM   1693  O   PRO A 105      57.433  -7.636  -2.471  1.00  0.00           O  
ATOM   1694  CB  PRO A 105      55.410  -9.962  -3.055  1.00  0.00           C  
ATOM   1695  CG  PRO A 105      54.280  -9.004  -3.466  1.00  0.00           C  
ATOM   1696  CD  PRO A 105      54.041  -8.063  -2.278  1.00  0.00           C  
ATOM   1697  HA  PRO A 105      56.091 -10.202  -0.997  1.00  0.00           H  
ATOM   1698  HB2 PRO A 105      56.174 -10.030  -3.827  1.00  0.00           H  
ATOM   1699  HB3 PRO A 105      55.019 -10.958  -2.906  1.00  0.00           H  
ATOM   1700  HG2 PRO A 105      54.563  -8.437  -4.353  1.00  0.00           H  
ATOM   1701  HG3 PRO A 105      53.374  -9.561  -3.704  1.00  0.00           H  
ATOM   1702  HD3 PRO A 105      54.142  -7.022  -2.574  1.00  0.00           H  
ATOM   1703  HD2 PRO A 105      53.045  -8.208  -1.861  1.00  0.00           H  
ATOM   1704  N   CYS A 106      58.406  -9.526  -1.687  1.00  0.00           N  
ATOM   1705  CA  CYS A 106      59.732  -8.935  -1.851  1.00  0.00           C  
ATOM   1706  C   CYS A 106      60.202  -8.981  -3.293  1.00  0.00           C  
ATOM   1707  O   CYS A 106      60.543  -7.967  -3.889  1.00  0.00           O  
ATOM   1708  CB  CYS A 106      60.746  -9.662  -0.990  1.00  0.00           C  
ATOM   1709  SG  CYS A 106      62.278  -8.725  -0.792  1.00  0.00           S  
ATOM   1710  H   CYS A 106      58.286 -10.465  -1.359  1.00  0.00           H  
ATOM   1711  HA  CYS A 106      59.656  -7.891  -1.545  1.00  0.00           H  
ATOM   1712  HB2 CYS A 106      60.326  -9.871  -0.006  1.00  0.00           H  
ATOM   1713  HB3 CYS A 106      60.992 -10.617  -1.449  1.00  0.00           H  
ATOM   1714  HG  CYS A 106      62.004  -7.527  -0.271  1.00  0.00           H  
ATOM   1715  N   GLN A 107      60.221 -10.223  -3.801  1.00  0.00           N  
ATOM   1716  CA  GLN A 107      60.705 -10.420  -5.135  1.00  0.00           C  
ATOM   1717  C   GLN A 107      60.316  -9.288  -6.051  1.00  0.00           C  
ATOM   1718  O   GLN A 107      59.407  -8.501  -5.815  1.00  0.00           O  
ATOM   1719  CB  GLN A 107      60.189 -11.724  -5.667  1.00  0.00           C  
ATOM   1720  CG  GLN A 107      61.301 -12.513  -6.343  1.00  0.00           C  
ATOM   1721  CD  GLN A 107      61.633 -11.922  -7.714  1.00  0.00           C  
ATOM   1722  OE1 GLN A 107      60.758 -11.620  -8.516  1.00  0.00           O  
ATOM   1723  NE2 GLN A 107      62.955 -11.779  -7.918  1.00  0.00           N  
ATOM   1724  H   GLN A 107      59.895 -11.000  -3.278  1.00  0.00           H  
ATOM   1725  HA  GLN A 107      61.796 -10.452  -5.073  1.00  0.00           H  
ATOM   1726  HB2 GLN A 107      59.789 -12.297  -4.855  1.00  0.00           H  
ATOM   1727  HB3 GLN A 107      59.379 -11.540  -6.355  1.00  0.00           H  
ATOM   1728  HG2 GLN A 107      62.195 -12.496  -5.720  1.00  0.00           H  
ATOM   1729  HG3 GLN A 107      61.008 -13.543  -6.474  1.00  0.00           H  
ATOM   1730 HE21 GLN A 107      63.612 -12.047  -7.214  1.00  0.00           H  
ATOM   1731 HE22 GLN A 107      63.301 -11.403  -8.778  1.00  0.00           H  
ATOM   1732  N   LYS A 108      61.089  -9.309  -7.118  1.00  0.00           N  
ATOM   1733  CA  LYS A 108      60.951  -8.316  -8.135  1.00  0.00           C  
ATOM   1734  C   LYS A 108      59.751  -8.552  -9.027  1.00  0.00           C  
ATOM   1735  O   LYS A 108      59.007  -9.516  -8.903  1.00  0.00           O  
ATOM   1736  CB  LYS A 108      62.224  -8.349  -8.934  1.00  0.00           C  
ATOM   1737  CG  LYS A 108      63.262  -7.550  -8.201  1.00  0.00           C  
ATOM   1738  CD  LYS A 108      64.675  -7.864  -8.672  1.00  0.00           C  
ATOM   1739  CE  LYS A 108      64.890  -7.462 -10.131  1.00  0.00           C  
ATOM   1740  NZ  LYS A 108      64.745  -6.025 -10.337  1.00  0.00           N  
ATOM   1741  H   LYS A 108      61.788 -10.017  -7.200  1.00  0.00           H  
ATOM   1742  HA  LYS A 108      60.837  -7.351  -7.633  1.00  0.00           H  
ATOM   1743  HB2 LYS A 108      62.562  -9.380  -9.055  1.00  0.00           H  
ATOM   1744  HB3 LYS A 108      62.060  -7.938  -9.930  1.00  0.00           H  
ATOM   1745  HG2 LYS A 108      63.033  -6.507  -8.340  1.00  0.00           H  
ATOM   1746  HG3 LYS A 108      63.184  -7.746  -7.131  1.00  0.00           H  
ATOM   1747  HD2 LYS A 108      65.392  -7.346  -8.036  1.00  0.00           H  
ATOM   1748  HD3 LYS A 108      64.864  -8.932  -8.552  1.00  0.00           H  
ATOM   1749  HE2 LYS A 108      65.887  -7.744 -10.464  1.00  0.00           H  
ATOM   1750  HE3 LYS A 108      64.169  -7.962 -10.777  1.00  0.00           H  
ATOM   1751  HZ1 LYS A 108      65.440  -5.520  -9.751  1.00  0.00           H  
ATOM   1752  HZ2 LYS A 108      64.906  -5.801 -11.339  1.00  0.00           H  
ATOM   1753  HZ3 LYS A 108      63.785  -5.731 -10.067  1.00  0.00           H  
ATOM   1754  N   ILE A 109      59.638  -7.576  -9.939  1.00  0.00           N  
ATOM   1755  CA  ILE A 109      58.543  -7.617 -10.884  1.00  0.00           C  
ATOM   1756  C   ILE A 109      59.093  -7.700 -12.301  1.00  0.00           C  
ATOM   1757  O   ILE A 109      58.989  -8.713 -12.984  1.00  0.00           O  
ATOM   1758  CB  ILE A 109      57.694  -6.363 -10.717  1.00  0.00           C  
ATOM   1759  CG1 ILE A 109      57.462  -6.073  -9.236  1.00  0.00           C  
ATOM   1760  CG2 ILE A 109      56.366  -6.523 -11.446  1.00  0.00           C  
ATOM   1761  CD1 ILE A 109      56.768  -7.241  -8.534  1.00  0.00           C  
ATOM   1762  H   ILE A 109      60.306  -6.828  -9.960  1.00  0.00           H  
ATOM   1763  HA  ILE A 109      57.963  -8.514 -10.669  1.00  0.00           H  
ATOM   1764  HB  ILE A 109      58.229  -5.522 -11.156  1.00  0.00           H  
ATOM   1765 HG12 ILE A 109      58.420  -5.873  -8.755  1.00  0.00           H  
ATOM   1766 HG13 ILE A 109      56.860  -5.171  -9.129  1.00  0.00           H  
ATOM   1767 HG21 ILE A 109      56.529  -6.690 -12.512  1.00  0.00           H  
ATOM   1768 HG22 ILE A 109      55.808  -7.370 -11.052  1.00  0.00           H  
ATOM   1769 HG23 ILE A 109      55.753  -5.629 -11.334  1.00  0.00           H  
ATOM   1770 HD11 ILE A 109      55.801  -7.450  -8.991  1.00  0.00           H  
ATOM   1771 HD12 ILE A 109      57.371  -8.146  -8.596  1.00  0.00           H  
ATOM   1772 HD13 ILE A 109      56.601  -7.018  -7.481  1.00  0.00           H  
ATOM   1773  N   GLY A 110      59.684  -6.560 -12.690  1.00  0.00           N  
ATOM   1774  CA  GLY A 110      60.249  -6.489 -14.022  1.00  0.00           C  
ATOM   1775  C   GLY A 110      61.749  -6.193 -13.967  1.00  0.00           C  
ATOM   1776  O   GLY A 110      62.419  -6.420 -12.967  1.00  0.00           O  
ATOM   1777  H   GLY A 110      59.734  -5.779 -12.067  1.00  0.00           H  
ATOM   1778  HA2 GLY A 110      60.063  -7.445 -14.509  1.00  0.00           H  
ATOM   1779  HA3 GLY A 110      59.724  -5.701 -14.561  1.00  0.00           H  
ATOM   1780  N   THR A 111      62.222  -5.669 -15.112  1.00  0.00           N  
ATOM   1781  CA  THR A 111      63.615  -5.338 -15.210  1.00  0.00           C  
ATOM   1782  C   THR A 111      63.838  -3.903 -14.717  1.00  0.00           C  
ATOM   1783  O   THR A 111      64.204  -3.662 -13.574  1.00  0.00           O  
ATOM   1784  CB  THR A 111      64.034  -5.506 -16.672  1.00  0.00           C  
ATOM   1785  OG1 THR A 111      63.009  -6.146 -17.398  1.00  0.00           O  
ATOM   1786  CG2 THR A 111      65.297  -6.325 -16.785  1.00  0.00           C  
ATOM   1787  H   THR A 111      61.634  -5.542 -15.903  1.00  0.00           H  
ATOM   1788  HA  THR A 111      64.160  -6.028 -14.564  1.00  0.00           H  
ATOM   1789  HB  THR A 111      64.188  -4.541 -17.135  1.00  0.00           H  
ATOM   1790  HG1 THR A 111      62.920  -5.675 -18.216  1.00  0.00           H  
ATOM   1791 HG21 THR A 111      65.163  -7.298 -16.315  1.00  0.00           H  
ATOM   1792 HG22 THR A 111      65.559  -6.482 -17.828  1.00  0.00           H  
ATOM   1793 HG23 THR A 111      66.125  -5.819 -16.294  1.00  0.00           H  
ATOM   1794  N   GLN A 112      63.592  -2.980 -15.657  1.00  0.00           N  
ATOM   1795  CA  GLN A 112      63.758  -1.586 -15.329  1.00  0.00           C  
ATOM   1796  C   GLN A 112      62.420  -1.005 -14.869  1.00  0.00           C  
ATOM   1797  O   GLN A 112      62.429  -0.101 -14.035  1.00  0.00           O  
ATOM   1798  CB  GLN A 112      64.270  -0.842 -16.559  1.00  0.00           C  
ATOM   1799  CG  GLN A 112      65.615  -1.397 -17.027  1.00  0.00           C  
ATOM   1800  CD  GLN A 112      66.113  -0.604 -18.236  1.00  0.00           C  
ATOM   1801  OE1 GLN A 112      65.503   0.367 -18.669  1.00  0.00           O  
ATOM   1802  NE2 GLN A 112      67.260  -1.088 -18.747  1.00  0.00           N  
ATOM   1803  OXT GLN A 112      61.385  -1.464 -15.348  1.00  0.00           O  
ATOM   1804  H   GLN A 112      63.323  -3.255 -16.576  1.00  0.00           H  
ATOM   1805  HA  GLN A 112      64.479  -1.539 -14.512  1.00  0.00           H  
ATOM   1806  HB2 GLN A 112      63.541  -0.920 -17.364  1.00  0.00           H  
ATOM   1807  HB3 GLN A 112      64.369   0.212 -16.328  1.00  0.00           H  
ATOM   1808  HG2 GLN A 112      66.357  -1.330 -16.230  1.00  0.00           H  
ATOM   1809  HG3 GLN A 112      65.522  -2.446 -17.306  1.00  0.00           H  
ATOM   1810 HE21 GLN A 112      67.702  -1.887 -18.339  1.00  0.00           H  
ATOM   1811 HE22 GLN A 112      67.688  -0.656 -19.540  1.00  0.00           H  
TER    1812      GLN A 112                                                      
END
MOLECULE T0446_71_124.pdb
ATOM    496  N   TYR    71      52.450  -5.922  11.315  1.00 25.67           N  
ATOM    497  CA  TYR    71      52.500  -6.345   9.929  1.00 25.24           C  
ATOM    498  C   TYR    71      52.827  -5.174   9.030  1.00 26.11           C  
ATOM    499  O   TYR    71      53.498  -5.336   8.025  1.00 23.81           O  
ATOM    500  CB  TYR    71      51.193  -7.003   9.522  1.00 24.58           C  
ATOM    501  CG  TYR    71      50.978  -8.334  10.184  1.00 24.13           C  
ATOM    502  CD1 TYR    71      51.691  -9.464   9.795  1.00 27.42           C  
ATOM    503  CD2 TYR    71      50.050  -8.469  11.195  1.00 24.56           C  
ATOM    504  CE1 TYR    71      51.470 -10.710  10.408  1.00 28.42           C  
ATOM    505  CE2 TYR    71      49.837  -9.702  11.828  1.00 27.00           C  
ATOM    506  CZ  TYR    71      50.543 -10.816  11.435  1.00 28.87           C  
ATOM    507  OH  TYR    71      50.294 -12.027  12.072  1.00 26.97           O  
ATOM    508  N   LYS    72      52.402  -3.976   9.423  1.00 27.90           N  
ATOM    509  CA  LYS    72      52.643  -2.772   8.604  1.00 30.48           C  
ATOM    510  C   LYS    72      54.128  -2.389   8.517  1.00 29.83           C  
ATOM    511  O   LYS    72      54.514  -1.617   7.651  1.00 28.15           O  
ATOM    512  CB  LYS    72      51.767  -1.606   9.074  1.00 33.73           C  
ATOM    513  CG  LYS    72      51.942  -1.228  10.527  1.00 38.80           C  
ATOM    514  CD  LYS    72      50.645  -0.734  11.194  1.00 46.86           C  
ATOM    515  CE  LYS    72      50.850  -0.492  12.717  1.00 46.76           C  
ATOM    516  NZ  LYS    72      52.020   0.384  13.023  1.00 49.99           N  
ATOM    517  N   ALA    73      54.959  -2.974   9.379  1.00 26.03           N  
ATOM    518  CA  ALA    73      56.422  -2.756   9.354  1.00 26.95           C  
ATOM    519  C   ALA    73      57.135  -3.716   8.404  1.00 26.78           C  
ATOM    520  O   ALA    73      58.331  -3.561   8.124  1.00 27.35           O  
ATOM    521  CB  ALA    73      56.990  -2.931  10.753  1.00 25.26           C  
ATOM    522  N   ILE    74      56.430  -4.750   7.955  1.00 25.79           N  
ATOM    523  CA  ILE    74      57.001  -5.740   7.046  1.00 26.02           C  
ATOM    524  C   ILE    74      56.861  -5.161   5.650  1.00 24.56           C  
ATOM    525  O   ILE    74      55.773  -5.159   5.064  1.00 27.24           O  
ATOM    526  CB  ILE    74      56.297  -7.115   7.133  1.00 26.74           C  
ATOM    527  CG1 ILE    74      56.326  -7.676   8.549  1.00 30.37           C  
ATOM    528  CG2 ILE    74      56.963  -8.088   6.230  1.00 27.04           C  
ATOM    529  CD1 ILE    74      55.440  -8.887   8.738  1.00 29.27           C  
ATOM    530  N   THR    75      57.953  -4.654   5.115  1.00 22.75           N  
ATOM    531  CA  THR    75      57.917  -3.898   3.863  1.00 21.25           C  
ATOM    532  C   THR    75      57.933  -4.815   2.636  1.00 22.95           C  
ATOM    533  O   THR    75      57.459  -4.460   1.547  1.00 24.63           O  
ATOM    534  CB  THR    75      59.104  -2.942   3.808  1.00 22.31           C  
ATOM    535  OG1 THR    75      60.307  -3.702   3.935  1.00 25.77           O  
ATOM    536  CG2 THR    75      59.024  -1.927   4.971  1.00 22.55           C  
ATOM    537  N   HIS    76      58.510  -5.991   2.811  1.00 22.57           N  
ATOM    538  CA  HIS    76      58.493  -7.038   1.804  1.00 21.16           C  
ATOM    539  C   HIS    76      58.956  -8.338   2.451  1.00 21.61           C  
ATOM    540  O   HIS    76      59.448  -8.354   3.593  1.00 21.00           O  
ATOM    541  CB  HIS    76      59.271  -6.658   0.519  1.00 21.76           C  
ATOM    542  CG  HIS    76      60.724  -6.317   0.693  1.00 24.97           C  
ATOM    543  ND1 HIS    76      61.722  -6.956  -0.015  1.00 20.31           N  
ATOM    544  CD2 HIS    76      61.344  -5.355   1.417  1.00 23.18           C  
ATOM    545  CE1 HIS    76      62.888  -6.436   0.308  1.00 26.69           C  
ATOM    546  NE2 HIS    76      62.686  -5.465   1.178  1.00 21.31           N  
ATOM    547  N   PHE    77      58.703  -9.437   1.760  1.00 22.80           N  
ATOM    548  CA  PHE    77      59.033 -10.739   2.305  1.00 23.33           C  
ATOM    549  C   PHE    77      59.224 -11.738   1.201  1.00 22.45           C  
ATOM    550  O   PHE    77      58.783 -11.527   0.084  1.00 24.55           O  
ATOM    551  CB  PHE    77      57.965 -11.202   3.326  1.00 23.75           C  
ATOM    552  CG  PHE    77      56.558 -11.264   2.781  1.00 24.36           C  
ATOM    553  CD1 PHE    77      55.752 -10.146   2.780  1.00 27.09           C  
ATOM    554  CD2 PHE    77      56.055 -12.443   2.267  1.00 24.93           C  
ATOM    555  CE1 PHE    77      54.469 -10.203   2.281  1.00 26.23           C  
ATOM    556  CE2 PHE    77      54.774 -12.514   1.758  1.00 27.60           C  
ATOM    557  CZ  PHE    77      53.962 -11.395   1.785  1.00 27.00           C  
ATOM    558  N   GLU    78      59.890 -12.838   1.532  1.00 25.55           N  
ATOM    559  CA  GLU    78      60.207 -13.869   0.574  1.00 27.24           C  
ATOM    560  C   GLU    78      60.175 -15.278   1.202  1.00 27.50           C  
ATOM    561  O   GLU    78      60.571 -15.464   2.348  1.00 27.56           O  
ATOM    562  CB  GLU    78      61.586 -13.587  -0.008  1.00 26.47           C  
ATOM    563  CG  GLU    78      62.038 -14.553  -1.100  1.00 29.98           C  
ATOM    564  CD  GLU    78      63.528 -14.477  -1.337  1.00 35.83           C  
ATOM    565  OE1 GLU    78      63.990 -13.444  -1.870  1.00 49.62           O  
ATOM    566  OE2 GLU    78      64.234 -15.442  -0.960  1.00 48.38           O  
ATOM    567  N   VAL    79      59.665 -16.253   0.440  1.00 28.02           N  
ATOM    568  CA  VAL    79      59.784 -17.664   0.793  1.00 26.32           C  
ATOM    569  C   VAL    79      60.564 -18.368  -0.296  1.00 27.86           C  
ATOM    570  O   VAL    79      60.301 -18.193  -1.488  1.00 25.50           O  
ATOM    571  CB  VAL    79      58.420 -18.360   0.961  1.00 28.00           C  
ATOM    572  CG1 VAL    79      58.603 -19.874   1.275  1.00 24.25           C  
ATOM    573  CG2 VAL    79      57.610 -17.676   2.052  1.00 24.80           C  
ATOM    574  N   GLU    80      61.528 -19.179   0.142  1.00 32.33           N  
ATOM    575  CA  GLU    80      62.405 -19.946  -0.732  1.00 33.40           C  
ATOM    576  C   GLU    80      62.178 -21.389  -0.320  1.00 34.29           C  
ATOM    577  O   GLU    80      62.310 -21.733   0.859  1.00 28.69           O  
ATOM    578  CB  GLU    80      63.861 -19.555  -0.489  1.00 35.09           C  
ATOM    579  CG  GLU    80      64.883 -19.996  -1.507  1.00 41.39           C  
ATOM    580  CD  GLU    80      66.305 -19.666  -1.031  1.00 43.19           C  
ATOM    581  OE1 GLU    80      66.903 -20.502  -0.307  1.00 56.02           O  
ATOM    582  OE2 GLU    80      66.812 -18.568  -1.363  1.00 56.50           O  
ATOM    583  N   THR    81      61.829 -22.221  -1.301  1.00 35.13           N  
ATOM    584  CA  THR    81      61.480 -23.608  -1.035  1.00 37.16           C  
ATOM    585  C   THR    81      62.756 -24.389  -0.712  1.00 37.03           C  
ATOM    586  O   THR    81      63.840 -23.988  -1.118  1.00 35.66           O  
ATOM    587  CB  THR    81      60.700 -24.184  -2.240  1.00 36.24           C  
ATOM    588  OG1 THR    81      61.493 -24.098  -3.426  1.00 37.33           O  
ATOM    589  CG2 THR    81      59.409 -23.360  -2.461  1.00 39.83           C  
ATOM    590  N   ALA    82      62.630 -25.466   0.061  1.00 39.00           N  
ATOM    591  CA  ALA    82      63.767 -26.374   0.318  1.00 39.90           C  
ATOM    592  C   ALA    82      64.176 -27.112  -0.957  1.00 39.43           C  
ATOM    593  O   ALA    82      63.336 -27.504  -1.766  1.00 37.27           O  
ATOM    594  CB  ALA    82      63.419 -27.388   1.422  1.00 40.09           C  
ATOM    595  N   GLY    83      65.474 -27.305  -1.138  1.00 41.07           N  
ATOM    596  CA  GLY    83      65.962 -28.114  -2.259  1.00 41.94           C  
ATOM    597  C   GLY    83      65.796 -29.618  -2.065  1.00 42.20           C  
ATOM    598  O   GLY    83      65.641 -30.362  -3.044  1.00 44.82           O  
ATOM    599  N   THR    84      65.846 -30.072  -0.811  1.00 39.95           N  
ATOM    600  CA  THR    84      65.758 -31.504  -0.486  1.00 38.44           C  
ATOM    601  C   THR    84      64.798 -31.724   0.685  1.00 36.77           C  
ATOM    602  O   THR    84      64.413 -30.767   1.359  1.00 32.11           O  
ATOM    603  CB  THR    84      67.157 -32.093  -0.109  1.00 38.28           C  
ATOM    604  OG1 THR    84      67.666 -31.454   1.069  1.00 41.12           O  
ATOM    605  CG2 THR    84      68.158 -31.905  -1.247  1.00 39.37           C  
ATOM    606  N   PHE    85      64.417 -32.978   0.934  1.00 35.16           N  
ATOM    607  CA  PHE    85      63.581 -33.299   2.101  1.00 34.59           C  
ATOM    608  C   PHE    85      64.285 -32.974   3.419  1.00 33.54           C  
ATOM    609  O   PHE    85      63.643 -32.631   4.403  1.00 34.69           O  
ATOM    610  CB  PHE    85      63.156 -34.771   2.093  1.00 34.35           C  
ATOM    611  CG  PHE    85      62.411 -35.187   3.330  1.00 36.56           C  
ATOM    612  CD1 PHE    85      61.094 -34.791   3.530  1.00 34.23           C  
ATOM    613  CD2 PHE    85      63.022 -35.964   4.303  1.00 41.90           C  
ATOM    614  CE1 PHE    85      60.399 -35.165   4.668  1.00 37.88           C  
ATOM    615  CE2 PHE    85      62.321 -36.339   5.447  1.00 43.44           C  
ATOM    616  CZ  PHE    85      61.014 -35.933   5.631  1.00 38.10           C  
ATOM    617  N   ASP    86      65.610 -33.065   3.418  1.00 34.57           N  
ATOM    618  CA  ASP    86      66.430 -32.811   4.598  1.00 35.43           C  
ATOM    619  C   ASP    86      66.472 -31.326   4.976  1.00 34.34           C  
ATOM    620  O   ASP    86      66.744 -30.990   6.118  1.00 32.83           O  
ATOM    621  CB  ASP    86      67.850 -33.364   4.358  1.00 37.07           C  
ATOM    622  CG  ASP    86      67.840 -34.850   3.943  1.00 44.24           C  
ATOM    623  OD1 ASP    86      67.415 -35.710   4.757  1.00 50.09           O  
ATOM    624  OD2 ASP    86      68.258 -35.161   2.797  1.00 51.21           O  
ATOM    625  N   MET    87      66.176 -30.441   4.026  1.00 36.41           N  
ATOM    626  CA  MET    87      66.183 -28.994   4.272  1.00 36.73           C  
ATOM    627  C   MET    87      64.767 -28.427   4.408  1.00 37.03           C  
ATOM    628  O   MET    87      63.805 -28.999   3.900  1.00 37.95           O  
ATOM    629  CB  MET    87      66.891 -28.277   3.119  1.00 37.02           C  
ATOM    630  CG  MET    87      68.369 -28.632   2.974  1.00 41.34           C  
ATOM    631  SD  MET    87      69.443 -27.796   4.371  0.75 49.61          SE  
ATOM    632  CE  MET    87      69.209 -25.886   3.795  1.00 51.12           C  
ATOM    633  N   ASP    88      64.667 -27.273   5.063  1.00 35.71           N  
ATOM    634  CA  ASP    88      63.390 -26.568   5.241  1.00 35.48           C  
ATOM    635  C   ASP    88      63.303 -25.338   4.350  1.00 33.04           C  
ATOM    636  O   ASP    88      64.328 -24.763   3.968  1.00 30.35           O  
ATOM    637  CB  ASP    88      63.247 -26.146   6.700  1.00 35.92           C  
ATOM    638  CG  ASP    88      63.194 -27.331   7.637  1.00 40.49           C  
ATOM    639  OD1 ASP    88      62.562 -28.349   7.240  1.00 39.27           O  
ATOM    640  OD2 ASP    88      63.780 -27.251   8.754  1.00 40.62           O  
ATOM    641  N   ALA    89      62.076 -24.940   4.021  1.00 31.56           N  
ATOM    642  CA  ALA    89      61.844 -23.672   3.309  1.00 31.28           C  
ATOM    643  C   ALA    89      62.235 -22.539   4.235  1.00 30.47           C  
ATOM    644  O   ALA    89      62.233 -22.703   5.456  1.00 30.63           O  
ATOM    645  CB  ALA    89      60.369 -23.520   2.867  1.00 30.70           C  
ATOM    646  N   GLU    90      62.583 -21.397   3.646  1.00 31.14           N  
ATOM    647  CA  GLU    90      63.076 -20.246   4.401  1.00 31.27           C  
ATOM    648  C   GLU    90      62.162 -19.053   4.204  1.00 28.02           C  
ATOM    649  O   GLU    90      61.768 -18.765   3.077  1.00 29.40           O  
ATOM    650  CB  GLU    90      64.466 -19.893   3.905  1.00 31.85           C  
ATOM    651  CG  GLU    90      65.348 -19.268   4.936  1.00 40.07           C  
ATOM    652  CD  GLU    90      66.740 -19.039   4.398  1.00 43.03           C  
ATOM    653  OE1 GLU    90      66.913 -18.106   3.579  1.00 52.07           O  
ATOM    654  OE2 GLU    90      67.646 -19.791   4.798  1.00 52.41           O  
ATOM    655  N   LEU    91      61.819 -18.381   5.299  1.00 26.54           N  
ATOM    656  CA  LEU    91      61.059 -17.128   5.252  1.00 27.74           C  
ATOM    657  C   LEU    91      62.008 -15.977   5.589  1.00 27.20           C  
ATOM    658  O   LEU    91      62.698 -16.022   6.605  1.00 25.93           O  
ATOM    659  CB  LEU    91      59.891 -17.155   6.248  1.00 28.11           C  
ATOM    660  CG  LEU    91      59.006 -15.915   6.487  1.00 26.78           C  
ATOM    661  CD1 LEU    91      58.119 -15.653   5.272  1.00 22.45           C  
ATOM    662  CD2 LEU    91      58.147 -16.087   7.736  1.00 30.23           C  
ATOM    663  N   LYS    92      62.068 -14.983   4.703  1.00 26.73           N  
ATOM    664  CA  LYS    92      62.780 -13.743   4.942  1.00 27.30           C  
ATOM    665  C   LYS    92      61.738 -12.625   5.112  1.00 25.61           C  
ATOM    666  O   LYS    92      60.819 -12.474   4.283  1.00 24.28           O  
ATOM    667  CB  LYS    92      63.692 -13.408   3.771  1.00 28.67           C  
ATOM    668  CG  LYS    92      64.701 -14.500   3.403  1.00 34.36           C  
ATOM    669  CD  LYS    92      65.692 -13.966   2.364  1.00 36.89           C  
ATOM    670  CE  LYS    92      66.965 -14.795   2.340  1.00 49.31           C  
ATOM    671  NZ  LYS    92      67.740 -14.530   1.099  1.00 55.51           N  
ATOM    672  N   LEU    93      61.854 -11.875   6.204  1.00 25.04           N  
ATOM    673  CA  LEU    93      60.949 -10.727   6.466  1.00 25.80           C  
ATOM    674  C   LEU    93      61.803  -9.493   6.554  1.00 26.08           C  
ATOM    675  O   LEU    93      62.727  -9.447   7.361  1.00 26.48           O  
ATOM    676  CB  LEU    93      60.180 -10.876   7.767  1.00 27.38           C  
ATOM    677  CG  LEU    93      59.205 -12.049   7.967  1.00 29.96           C  
ATOM    678  CD1 LEU    93      58.691 -12.011   9.405  1.00 31.75           C  
ATOM    679  CD2 LEU    93      58.029 -12.039   7.000  1.00 28.80           C  
ATOM    680  N   TRP    94      61.529  -8.506   5.705  1.00 23.54           N  
ATOM    681  CA  TRP    94      62.245  -7.239   5.811  1.00 24.30           C  
ATOM    682  C   TRP    94      61.435  -6.314   6.661  1.00 23.70           C  
ATOM    683  O   TRP    94      60.261  -6.099   6.412  1.00 26.50           O  
ATOM    684  CB  TRP    94      62.494  -6.634   4.461  1.00 25.47           C  
ATOM    685  CG  TRP    94      63.624  -7.222   3.760  1.00 24.57           C  
ATOM    686  CD1 TRP    94      64.933  -6.757   3.745  1.00 26.09           C  
ATOM    687  CD2 TRP    94      63.605  -8.383   2.940  1.00 26.14           C  
ATOM    688  NE1 TRP    94      65.700  -7.560   2.952  1.00 28.69           N  
ATOM    689  CE2 TRP    94      64.915  -8.558   2.434  1.00 23.04           C  
ATOM    690  CE3 TRP    94      62.607  -9.283   2.560  1.00 24.99           C  
ATOM    691  CZ2 TRP    94      65.254  -9.606   1.605  1.00 28.18           C  
ATOM    692  CZ3 TRP    94      62.937 -10.311   1.721  1.00 30.51           C  
ATOM    693  CH2 TRP    94      64.259 -10.468   1.244  1.00 31.54           C  
ATOM    694  N   ILE    95      62.068  -5.794   7.695  1.00 25.32           N  
ATOM    695  CA  ILE    95      61.432  -4.881   8.617  1.00 24.96           C  
ATOM    696  C   ILE    95      61.942  -3.471   8.338  1.00 25.77           C  
ATOM    697  O   ILE    95      63.157  -3.233   8.235  1.00 23.87           O  
ATOM    698  CB  ILE    95      61.693  -5.286  10.043  1.00 28.14           C  
ATOM    699  CG1 ILE    95      61.146  -6.701  10.309  1.00 29.98           C  
ATOM    700  CG2 ILE    95      61.069  -4.257  11.027  1.00 23.96           C  
ATOM    701  CD1 ILE    95      61.754  -7.334  11.584  1.00 38.56           C  
ATOM    702  N   SER    96      61.002  -2.543   8.212  1.00 25.84           N  
ATOM    703  CA  SER    96      61.314  -1.141   7.962  1.00 25.77           C  
ATOM    704  C   SER    96      62.446  -0.639   8.862  1.00 24.02           C  
ATOM    705  O   SER    96      62.354  -0.719  10.100  1.00 26.63           O  
ATOM    706  CB  SER    96      60.079  -0.289   8.198  1.00 27.15           C  
ATOM    707  OG  SER    96      60.405   1.045   7.950  1.00 29.32           O  
ATOM    708  N   GLY    97      63.492  -0.109   8.234  1.00 22.83           N  
ATOM    709  CA  GLY    97      64.616   0.510   8.926  1.00 23.97           C  
ATOM    710  C   GLY    97      65.730  -0.450   9.287  1.00 28.11           C  
ATOM    711  O   GLY    97      66.808  -0.017   9.715  1.00 25.59           O  
ATOM    712  N   GLN    98      65.473  -1.759   9.130  1.00 27.91           N  
ATOM    713  CA  GLN    98      66.453  -2.791   9.440  1.00 30.31           C  
ATOM    714  C   GLN    98      66.987  -3.389   8.137  1.00 29.14           C  
ATOM    715  O   GLN    98      66.226  -3.952   7.351  1.00 29.59           O  
ATOM    716  CB  GLN    98      65.798  -3.834  10.333  1.00 30.54           C  
ATOM    717  CG  GLN    98      66.700  -4.988  10.747  1.00 32.23           C  
ATOM    718  CD  GLN    98      65.932  -6.097  11.449  1.00 36.31           C  
ATOM    719  OE1 GLN    98      65.290  -5.869  12.476  1.00 39.28           O  
ATOM    720  NE2 GLN    98      65.963  -7.303  10.873  1.00 37.11           N  
ATOM    721  N   LYS    99      68.287  -3.241   7.884  1.00 30.69           N  
ATOM    722  CA  LYS    99      68.832  -3.508   6.546  1.00 33.56           C  
ATOM    723  C   LYS    99      68.786  -4.980   6.185  1.00 30.39           C  
ATOM    724  O   LYS    99      68.444  -5.334   5.063  1.00 32.15           O  
ATOM    725  CB  LYS    99      70.283  -3.019   6.379  1.00 34.88           C  
ATOM    726  CG  LYS    99      70.717  -3.075   4.922  1.00 38.19           C  
ATOM    727  CD  LYS    99      72.159  -2.664   4.716  1.00 41.85           C  
ATOM    728  CE  LYS    99      72.662  -3.157   3.358  1.00 50.60           C  
ATOM    729  NZ  LYS    99      72.493  -4.643   3.205  1.00 54.44           N  
ATOM    730  N   ASP   100      69.136  -5.819   7.140  1.00 30.38           N  
ATOM    731  CA  ASP   100      69.087  -7.268   6.940  1.00 31.78           C  
ATOM    732  C   ASP   100      67.754  -7.871   7.364  1.00 29.41           C  
ATOM    733  O   ASP   100      67.194  -7.472   8.387  1.00 28.20           O  
ATOM    734  CB  ASP   100      70.217  -7.928   7.713  1.00 33.71           C  
ATOM    735  CG  ASP   100      71.586  -7.481   7.223  1.00 37.96           C  
ATOM    736  OD1 ASP   100      71.683  -6.969   6.081  1.00 41.69           O  
ATOM    737  OD2 ASP   100      72.556  -7.648   7.983  1.00 47.04           O  
ATOM    738  N   PRO   101      67.250  -8.852   6.589  1.00 27.18           N  
ATOM    739  CA  PRO   101      65.970  -9.453   6.911  1.00 26.93           C  
ATOM    740  C   PRO   101      66.065 -10.374   8.106  1.00 26.74           C  
ATOM    741  O   PRO   101      67.131 -10.919   8.372  1.00 27.02           O  
ATOM    742  CB  PRO   101      65.659 -10.266   5.660  1.00 27.48           C  
ATOM    743  CG  PRO   101      66.966 -10.650   5.152  1.00 26.69           C  
ATOM    744  CD  PRO   101      67.824  -9.461   5.375  1.00 28.74           C  
ATOM    745  N   LEU   102      64.956 -10.528   8.826  1.00 26.41           N  
ATOM    746  CA  LEU   102      64.796 -11.585   9.805  1.00 28.61           C  
ATOM    747  C   LEU   102      64.560 -12.868   9.003  1.00 29.31           C  
ATOM    748  O   LEU   102      63.639 -12.930   8.199  1.00 29.52           O  
ATOM    749  CB  LEU   102      63.626 -11.237  10.726  1.00 29.45           C  
ATOM    750  CG  LEU   102      63.125 -12.236  11.764  1.00 37.35           C  
ATOM    751  CD1 LEU   102      64.215 -12.644  12.720  1.00 42.33           C  
ATOM    752  CD2 LEU   102      61.960 -11.601  12.523  1.00 34.66           C  
ATOM    753  N   VAL   103      65.439 -13.858   9.165  1.00 30.55           N  
ATOM    754  CA  VAL   103      65.370 -15.096   8.405  1.00 29.93           C  
ATOM    755  C   VAL   103      64.945 -16.258   9.337  1.00 33.10           C  
ATOM    756  O   VAL   103      65.534 -16.489  10.398  1.00 33.96           O  
ATOM    757  CB  VAL   103      66.701 -15.386   7.711  1.00 29.39           C  
ATOM    758  CG1 VAL   103      66.600 -16.636   6.845  1.00 30.18           C  
ATOM    759  CG2 VAL   103      67.113 -14.209   6.871  1.00 29.40           C  
ATOM    760  N   LYS   104      63.876 -16.945   8.962  1.00 33.36           N  
ATOM    761  CA  LYS   104      63.327 -18.008   9.806  1.00 34.68           C  
ATOM    762  C   LYS   104      63.112 -19.281   8.990  1.00 33.67           C  
ATOM    763  O   LYS   104      62.619 -19.232   7.858  1.00 30.77           O  
ATOM    764  CB  LYS   104      62.043 -17.531  10.488  1.00 36.15           C  
ATOM    765  CG  LYS   104      62.260 -16.435  11.548  1.00 42.19           C  
ATOM    766  CD  LYS   104      62.932 -16.943  12.839  1.00 49.61           C  
ATOM    767  CE  LYS   104      61.927 -17.046  13.995  1.00 53.15           C  
ATOM    768  NZ  LYS   104      62.482 -17.459  15.333  1.00 54.45           N  
ATOM    769  N   GLU   105      63.558 -20.413   9.541  1.00 34.65           N  
ATOM    770  CA  GLU   105      63.309 -21.711   8.915  1.00 38.12           C  
ATOM    771  C   GLU   105      61.878 -22.087   9.144  1.00 35.29           C  
ATOM    772  O   GLU   105      61.392 -22.020  10.279  1.00 36.59           O  
ATOM    773  CB  GLU   105      64.188 -22.818   9.508  1.00 40.49           C  
ATOM    774  CG  GLU   105      65.450 -23.105   8.728  1.00 47.84           C  
ATOM    775  CD  GLU   105      66.309 -24.156   9.425  1.00 47.35           C  
ATOM    776  OE1 GLU   105      65.770 -25.242   9.787  1.00 58.53           O  
ATOM    777  OE2 GLU   105      67.517 -23.875   9.625  1.00 60.66           O  
ATOM    778  N   LEU   106      61.198 -22.462   8.063  1.00 33.29           N  
ATOM    779  CA  LEU   106      59.846 -22.953   8.155  1.00 34.41           C  
ATOM    780  C   LEU   106      59.939 -24.444   8.457  1.00 35.26           C  
ATOM    781  O   LEU   106      59.813 -25.280   7.564  1.00 35.75           O  
ATOM    782  CB  LEU   106      59.071 -22.653   6.864  1.00 32.96           C  
ATOM    783  CG  LEU   106      58.863 -21.152   6.572  1.00 32.66           C  
ATOM    784  CD1 LEU   106      58.118 -20.885   5.270  1.00 29.48           C  
ATOM    785  CD2 LEU   106      58.184 -20.422   7.750  1.00 31.35           C  
ATOM    786  N   LYS   107      60.171 -24.745   9.735  1.00 37.24           N  
ATOM    787  CA  LYS   107      60.501 -26.107  10.177  1.00 39.70           C  
ATOM    788  C   LYS   107      59.363 -27.083   9.948  1.00 38.58           C  
ATOM    789  O   LYS   107      58.192 -26.690   9.886  1.00 36.43           O  
ATOM    790  CB  LYS   107      60.899 -26.117  11.648  1.00 39.82           C  
ATOM    791  CG  LYS   107      62.101 -25.259  11.910  1.00 43.15           C  
ATOM    792  CD  LYS   107      62.416 -25.116  13.371  1.00 45.67           C  
ATOM    793  CE  LYS   107      63.699 -24.326  13.528  1.00 50.08           C  
ATOM    794  NZ  LYS   107      64.809 -24.969  12.753  1.00 46.24           N  
ATOM    795  N   LYS   108      59.727 -28.355   9.789  1.00 39.31           N  
ATOM    796  CA  LYS   108      58.743 -29.433   9.701  1.00 38.89           C  
ATOM    797  C   LYS   108      57.824 -29.377  10.930  1.00 37.81           C  
ATOM    798  O   LYS   108      58.274 -29.207  12.075  1.00 34.12           O  
ATOM    799  CB  LYS   108      59.423 -30.795   9.552  1.00 39.54           C  
ATOM    800  CG  LYS   108      60.031 -30.980   8.164  1.00 42.00           C  
ATOM    801  CD  LYS   108      60.906 -32.208   8.081  1.00 47.09           C  
ATOM    802  CE  LYS   108      61.631 -32.273   6.744  1.00 46.97           C  
ATOM    803  NZ  LYS   108      62.540 -31.099   6.547  1.00 39.92           N  
ATOM    804  N   GLY   109      56.529 -29.472  10.660  1.00 36.51           N  
ATOM    805  CA  GLY   109      55.519 -29.177  11.653  1.00 37.24           C  
ATOM    806  C   GLY   109      54.816 -27.834  11.464  1.00 38.00           C  
ATOM    807  O   GLY   109      53.763 -27.601  12.070  1.00 40.47           O  
ATOM    808  N   THR   110      55.381 -26.924  10.668  1.00 36.87           N  
ATOM    809  CA  THR   110      54.712 -25.633  10.437  1.00 34.22           C  
ATOM    810  C   THR   110      53.744 -25.763   9.251  1.00 33.19           C  
ATOM    811  O   THR   110      53.933 -26.597   8.364  1.00 32.71           O  
ATOM    812  CB  THR   110      55.704 -24.436  10.224  1.00 33.34           C  
ATOM    813  OG1 THR   110      56.512 -24.653   9.073  1.00 37.61           O  
ATOM    814  CG2 THR   110      56.613 -24.188  11.463  1.00 35.87           C  
ATOM    815  N   ASP   111      52.676 -24.974   9.265  1.00 33.06           N  
ATOM    816  CA  ASP   111      51.805 -24.840   8.096  1.00 31.65           C  
ATOM    817  C   ASP   111      52.447 -23.803   7.181  1.00 32.04           C  
ATOM    818  O   ASP   111      52.207 -22.594   7.305  1.00 30.82           O  
ATOM    819  CB  ASP   111      50.412 -24.389   8.520  1.00 32.47           C  
ATOM    820  CG  ASP   111      49.386 -24.491   7.397  1.00 35.05           C  
ATOM    821  OD1 ASP   111      49.730 -24.897   6.264  1.00 37.68           O  
ATOM    822  OD2 ASP   111      48.212 -24.160   7.661  1.00 41.03           O  
ATOM    823  N   VAL   112      53.298 -24.277   6.277  1.00 32.15           N  
ATOM    824  CA  VAL   112      54.098 -23.367   5.458  1.00 32.83           C  
ATOM    825  C   VAL   112      53.197 -22.462   4.621  1.00 32.37           C  
ATOM    826  O   VAL   112      53.411 -21.257   4.551  1.00 32.01           O  
ATOM    827  CB  VAL   112      55.104 -24.153   4.598  1.00 33.23           C  
ATOM    828  CG1 VAL   112      55.614 -23.317   3.419  1.00 34.34           C  
ATOM    829  CG2 VAL   112      56.226 -24.601   5.473  1.00 33.20           C  
ATOM    830  N   VAL   113      52.180 -23.048   3.997  1.00 32.36           N  
ATOM    831  CA  VAL   113      51.203 -22.278   3.211  1.00 31.90           C  
ATOM    832  C   VAL   113      50.331 -21.372   4.102  1.00 30.83           C  
ATOM    833  O   VAL   113      50.054 -20.228   3.751  1.00 31.76           O  
ATOM    834  CB  VAL   113      50.323 -23.208   2.333  1.00 33.31           C  
ATOM    835  CG1 VAL   113      49.076 -22.468   1.837  1.00 34.94           C  
ATOM    836  CG2 VAL   113      51.134 -23.766   1.163  1.00 29.56           C  
ATOM    837  N   GLY   114      49.927 -21.865   5.271  1.00 32.10           N  
ATOM    838  CA  GLY   114      49.098 -21.066   6.209  1.00 31.10           C  
ATOM    839  C   GLY   114      49.832 -19.871   6.800  1.00 29.28           C  
ATOM    840  O   GLY   114      49.293 -18.771   6.914  1.00 30.44           O  
ATOM    841  N   ILE   115      51.086 -20.092   7.165  1.00 30.00           N  
ATOM    842  CA  ILE   115      51.978 -19.012   7.534  1.00 30.58           C  
ATOM    843  C   ILE   115      51.972 -17.935   6.448  1.00 28.83           C  
ATOM    844  O   ILE   115      51.772 -16.771   6.713  1.00 31.68           O  
ATOM    845  CB  ILE   115      53.425 -19.559   7.805  1.00 30.17           C  
ATOM    846  CG1 ILE   115      53.472 -20.164   9.218  1.00 27.89           C  
ATOM    847  CG2 ILE   115      54.479 -18.456   7.609  1.00 26.80           C  
ATOM    848  CD1 ILE   115      54.769 -20.920   9.515  1.00 32.81           C  
ATOM    849  N   GLN   116      52.185 -18.334   5.210  1.00 29.60           N  
ATOM    850  CA  GLN   116      52.281 -17.357   4.131  1.00 28.93           C  
ATOM    851  C   GLN   116      50.942 -16.649   3.912  1.00 29.21           C  
ATOM    852  O   GLN   116      50.906 -15.448   3.581  1.00 29.10           O  
ATOM    853  CB  GLN   116      52.710 -18.054   2.851  1.00 29.66           C  
ATOM    854  CG  GLN   116      54.115 -18.626   2.898  1.00 31.21           C  
ATOM    855  CD  GLN   116      54.426 -19.386   1.655  1.00 29.09           C  
ATOM    856  OE1 GLN   116      54.697 -18.795   0.615  1.00 33.03           O  
ATOM    857  NE2 GLN   116      54.349 -20.713   1.734  1.00 27.96           N  
ATOM    858  N   LYS   117      49.850 -17.404   4.058  1.00 29.70           N  
ATOM    859  CA  LYS   117      48.499 -16.875   3.857  1.00 29.82           C  
ATOM    860  C   LYS   117      48.176 -15.857   4.943  1.00 28.61           C  
ATOM    861  O   LYS   117      47.611 -14.811   4.662  1.00 31.01           O  
ATOM    862  CB  LYS   117      47.473 -18.015   3.875  1.00 29.34           C  
ATOM    863  CG  LYS   117      46.067 -17.622   3.425  1.00 33.13           C  
ATOM    864  CD  LYS   117      45.176 -18.855   3.280  1.00 34.04           C  
ATOM    865  CE  LYS   117      43.939 -18.612   2.396  1.00 40.33           C  
ATOM    866  NZ  LYS   117      43.136 -17.428   2.817  1.00 40.20           N  
ATOM    867  N   THR   118      48.560 -16.168   6.181  1.00 29.34           N  
ATOM    868  CA  THR   118      48.391 -15.249   7.312  1.00 29.40           C  
ATOM    869  C   THR   118      49.143 -13.946   7.120  1.00 29.40           C  
ATOM    870  O   THR   118      48.602 -12.856   7.363  1.00 29.72           O  
ATOM    871  CB  THR   118      48.863 -15.891   8.629  1.00 31.36           C  
ATOM    872  OG1 THR   118      48.218 -17.150   8.782  1.00 30.38           O  
ATOM    873  CG2 THR   118      48.528 -14.991   9.823  1.00 31.15           C  
ATOM    874  N   ILE   119      50.387 -14.037   6.658  1.00 27.90           N  
ATOM    875  CA  ILE   119      51.154 -12.817   6.403  1.00 27.27           C  
ATOM    876  C   ILE   119      50.495 -11.998   5.315  1.00 26.94           C  
ATOM    877  O   ILE   119      50.398 -10.768   5.397  1.00 29.06           O  
ATOM    878  CB  ILE   119      52.654 -13.132   6.052  1.00 27.63           C  
ATOM    879  CG1 ILE   119      53.375 -13.653   7.290  1.00 31.58           C  
ATOM    880  CG2 ILE   119      53.360 -11.887   5.547  1.00 24.38           C  
ATOM    881  CD1 ILE   119      54.558 -14.592   7.017  1.00 25.73           C  
ATOM    882  N   ALA   120      50.013 -12.670   4.280  1.00 26.93           N  
ATOM    883  CA  ALA   120      49.331 -11.984   3.223  1.00 26.31           C  
ATOM    884  C   ALA   120      48.018 -11.372   3.728  1.00 27.39           C  
ATOM    885  O   ALA   120      47.703 -10.231   3.392  1.00 27.07           O  
ATOM    886  CB  ALA   120      49.050 -12.954   2.056  1.00 24.55           C  
ATOM    887  N   ASN   121      47.235 -12.140   4.503  1.00 29.54           N  
ATOM    888  CA  ASN   121      45.973 -11.623   5.076  1.00 30.57           C  
ATOM    889  C   ASN   121      46.149 -10.376   5.918  1.00 31.01           C  
ATOM    890  O   ASN   121      45.327  -9.452   5.873  1.00 32.08           O  
ATOM    891  CB  ASN   121      45.231 -12.705   5.909  1.00 31.39           C  
ATOM    892  CG  ASN   121      44.438 -13.653   5.047  1.00 32.51           C  
ATOM    893  OD1 ASN   121      43.982 -13.277   3.966  1.00 32.82           O  
ATOM    894  ND2 ASN   121      44.282 -14.899   5.503  1.00 30.06           N  
ATOM    895  N   PHE   122      47.208 -10.335   6.710  1.00 33.74           N  
ATOM    896  CA  PHE   122      47.370  -9.229   7.667  1.00 32.31           C  
ATOM    897  C   PHE   122      48.345  -8.170   7.200  1.00 33.03           C  
ATOM    898  O   PHE   122      48.298  -7.055   7.699  1.00 37.61           O  
ATOM    899  CB  PHE   122      47.757  -9.761   9.041  1.00 32.59           C  
ATOM    900  CG  PHE   122      46.712 -10.688   9.664  1.00 34.55           C  
ATOM    901  CD1 PHE   122      45.383 -10.294   9.773  1.00 36.39           C  
ATOM    902  CD2 PHE   122      47.070 -11.941  10.137  1.00 36.96           C  
ATOM    903  CE1 PHE   122      44.440 -11.132  10.335  1.00 38.73           C  
ATOM    904  CE2 PHE   122      46.125 -12.785  10.705  1.00 43.22           C  
ATOM    905  CZ  PHE   122      44.805 -12.375  10.806  1.00 39.44           C  
ATOM    906  N   SER   123      49.214  -8.453   6.236  1.00 33.63           N  
ATOM    907  CA  SER   123      50.231  -7.465   5.887  1.00 35.18           C  
ATOM    908  C   SER   123      50.050  -6.740   4.541  1.00 37.97           C  
ATOM    909  O   SER   123      50.790  -5.783   4.258  1.00 41.06           O  
ATOM    910  CB  SER   123      51.648  -8.061   6.023  1.00 38.33           C  
ATOM    911  OG  SER   123      52.060  -8.784   4.873  1.00 49.46           O  
ATOM    912  N   LEU   124      49.082  -7.162   3.726  1.00 36.37           N  
ATOM    913  CA  LEU   124      48.957  -6.651   2.346  1.00 38.25           C  
ATOM    914  C   LEU   124      47.781  -5.705   2.198  1.00 42.55           C  
ATOM    915  O   LEU   124      46.706  -6.000   2.760  1.00 45.02           O  
ATOM    916  CB  LEU   124      48.769  -7.805   1.351  1.00 35.85           C  
ATOM    917  CG  LEU   124      49.930  -8.768   1.148  1.00 31.97           C  
ATOM    918  CD1 LEU   124      49.528  -9.831   0.107  1.00 27.47           C  
ATOM    919  CD2 LEU   124      51.169  -8.015   0.704  1.00 26.82           C  
ATOM    920  OXT LEU   124      47.881  -4.667   1.503  1.00 44.32           O  
END
