
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  124 ( 1989),  selected  124 , name 2eoc_A
# Molecule2: number of CA atoms   62 (  480),  selected   62 , name T0446_9_70.pdb
# PARAMETERS: 2eoc_A.T0446_9_70.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G    34_A      G       9           -
LGA    S    35_A      N      10           -
LGA    S    36_A      A      11           -
LGA    G    37_A      A      12           -
LGA    S    38_A      E      13           -
LGA    S    39_A      -       -           -
LGA    G    40_A      -       -           -
LGA    A    41_A      -       -           -
LGA    E    42_A      -       -           -
LGA    K    43_A      -       -           -
LGA    R    44_A      -       -           -
LGA    I    45_A      V      14           #
LGA    -       -      N      15           -
LGA    I    46_A      L      16          1.445
LGA    R    47_A      D      17          3.700
LGA    -       -      E      18           -
LGA    -       -      L      19           -
LGA    V    48_A      A      20          2.748
LGA    -       -      Q      21           -
LGA    -       -      E      22           -
LGA    D    49_A      L      23          2.684
LGA    P    50_A      G      24          5.058
LGA    T    51_A      P      25           #
LGA    C    52_A      -       -           -
LGA    P    53_A      I      26          1.986
LGA    L    54_A      M      27          1.761
LGA    S    55_A      -       -           -
LGA    S    56_A      -       -           -
LGA    N    57_A      G      28          2.773
LGA    P    58_A      D      29          2.215
LGA    G    59_A      N      30          2.410
LGA    T    60_A      E      31          1.134
LGA    Q    61_A      Q      32          1.080
LGA    V    62_A      L      33          0.367
LGA    Y    63_A      A      34          1.503
LGA    E    64_A      -       -           -
LGA    D    65_A      -       -           -
LGA    Y    66_A      L      35          1.437
LGA    N    67_A      A      36          1.220
LGA    C    68_A      Y      37          1.485
LGA    T    69_A      R      38          1.231
LGA    L    70_A      V      39          1.183
LGA    N    71_A      I      40          1.049
LGA    Q    72_A      -       -           -
LGA    T    73_A      -       -           -
LGA    N    74_A      -       -           -
LGA    I    75_A      -       -           -
LGA    E    76_A      -       -           -
LGA    N    77_A      -       -           -
LGA    N    78_A      -       -           -
LGA    N    79_A      -       -           -
LGA    N    80_A      -       -           -
LGA    K    81_A      -       -           -
LGA    F    82_A      R      41          2.275
LGA    Y    83_A      D      42          1.364
LGA    I    84_A      M      43          0.498
LGA    I    85_A      F      44          0.440
LGA    Q    86_A      V      45          0.838
LGA    L    87_A      F      46          0.485
LGA    L    88_A      T      47          0.465
LGA    Q    89_A      N      48          0.935
LGA    D    90_A      -       -           -
LGA    S    91_A      -       -           -
LGA    N    92_A      -       -           -
LGA    R    93_A      -       -           -
LGA    F    94_A      -       -           -
LGA    F    95_A      K      49          2.712
LGA    T    96_A      R      50          0.411
LGA    C    97_A      L      51          0.527
LGA    W    98_A      I      52          0.559
LGA    N    99_A      L      53          0.422
LGA    R   100_A      I      54          1.014
LGA    W   101_A      D      55          0.465
LGA    G   102_A      K      56          1.682
LGA    R   103_A      Q      57          2.664
LGA    -       -      G      58           -
LGA    -       -      V      59           -
LGA    V   104_A      T      60          4.952
LGA    G   105_A      G      61          3.908
LGA    E   106_A      K      62          2.239
LGA    V   107_A      K      63           #
LGA    G   108_A      V      64          0.737
LGA    Q   109_A      S      65          1.354
LGA    S   110_A      Y      66          1.563
LGA    K   111_A      H      67          0.442
LGA    I   112_A      S      68          0.615
LGA    N   113_A      V      69          0.225
LGA    H   114_A      P      70          0.591
LGA    F   115_A      -       -           -
LGA    T   116_A      -       -           -
LGA    R   117_A      -       -           -
LGA    L   118_A      -       -           -
LGA    E   119_A      -       -           -
LGA    D   120_A      -       -           -
LGA    A   121_A      -       -           -
LGA    K   122_A      -       -           -
LGA    K   123_A      -       -           -
LGA    D   124_A      -       -           -
LGA    F   125_A      -       -           -
LGA    E   126_A      -       -           -
LGA    K   127_A      -       -           -
LGA    K   128_A      -       -           -
LGA    F   129_A      -       -           -
LGA    R   130_A      -       -           -
LGA    E   131_A      -       -           -
LGA    K   132_A      -       -           -
LGA    T   133_A      -       -           -
LGA    K   134_A      -       -           -
LGA    N   135_A      -       -           -
LGA    N   136_A      -       -           -
LGA    W   137_A      -       -           -
LGA    A   138_A      -       -           -
LGA    E   139_A      -       -           -
LGA    R   140_A      -       -           -
LGA    D   141_A      -       -           -
LGA    H   142_A      -       -           -
LGA    F   143_A      -       -           -
LGA    V   144_A      -       -           -
LGA    S   145_A      -       -           -
LGA    H   146_A      -       -           -
LGA    P   147_A      -       -           -
LGA    G   148_A      -       -           -
LGA    K   149_A      -       -           -
LGA    Y   150_A      -       -           -
LGA    T   151_A      -       -           -
LGA    L   152_A      -       -           -
LGA    I   153_A      -       -           -
LGA    E   154_A      -       -           -
LGA    V   155_A      -       -           -
LGA    Q   156_A      -       -           -
LGA    A   157_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  124   62    5.0     47    1.93     4.26     66.353     2.311

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.723618 * X  +   0.135739 * Y  +   0.676722 * Z  +  53.394131
  Y_new =  -0.396280 * X  +  -0.721051 * Y  +   0.568373 * Z  + -15.473919
  Z_new =   0.565101 * X  +  -0.679456 * Y  +  -0.467975 * Z  +  19.271679 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.173932    0.967661  [ DEG:  -124.5571     55.4429 ]
  Theta =  -0.600556   -2.541037  [ DEG:   -34.4093   -145.5907 ]
  Phi   =  -0.501027    2.640565  [ DEG:   -28.7068    151.2932 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2eoc_A                                        
REMARK     2: T0446_9_70.pdb                                
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2eoc_A.T0446_9_70.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  124   62   5.0   47   1.93    4.26  66.353
REMARK  ---------------------------------------------------------- 
MOLECULE 2eoc_A
HEADER    TRANSFERASE                             29-MAR-07   2EOC              
TITLE     SOLUTION STRUCTURE OF THE WGR DOMAIN FROM HUMAN POLY [ADP-            
TITLE    2 RIBOSE] POLYMERASE-3                                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: POLY [ADP-RIBOSE] POLYMERASE 3;                            
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: WGR DOMAIN;                                                
COMPND   5 SYNONYM: PARP-3, NAD+, ADP- RIBOSYLTRANSFERASE 3, POLY[ADP-          
COMPND   6 RIBOSE] SYNTHETASE 3, PADPRT-3, HPARP-3, IRT1;                       
COMPND   7 EC: 2.4.2.30;                                                        
COMPND   8 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   5 EXPRESSION_SYSTEM_PLASMID: P060710-01;                               
SOURCE   6 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    ANTI-PARALLEL BETA-SHEET, CELL CYCLE CONTROL, DNA DAMAGE,             
KEYWDS   2 TRANSCRIPTION, NAD+, STRUCTURAL GENOMICS, NPPSFA, NATIONAL           
KEYWDS   3 PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES,               
KEYWDS   4 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI,               
KEYWDS   5 TRANSFERASE                                                          
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    T.NAGASHIMA,F.HAYASHI,S.YOKOYAMA,RIKEN STRUCTURAL                     
AUTHOR   2 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   01-APR-08 2EOC    0                                                
JRNL        AUTH   T.NAGASHIMA,F.HAYASHI,S.YOKOYAMA                             
JRNL        TITL   SOLUTION STRUCTURE OF THE WGR DOMAIN FROM HUMAN              
JRNL        TITL 2 POLY [ADP-RIBOSE] POLYMERASE-3                               
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2EOC A   41   157  UNP    Q9Y6F1   PARP3_HUMAN     41    157             
SEQRES   1 A  124  GLY SER SER GLY SER SER GLY ALA GLU LYS ARG ILE ILE          
SEQRES   2 A  124  ARG VAL ASP PRO THR CYS PRO LEU SER SER ASN PRO GLY          
SEQRES   3 A  124  THR GLN VAL TYR GLU ASP TYR ASN CYS THR LEU ASN GLN          
SEQRES   4 A  124  THR ASN ILE GLU ASN ASN ASN ASN LYS PHE TYR ILE ILE          
SEQRES   5 A  124  GLN LEU LEU GLN ASP SER ASN ARG PHE PHE THR CYS TRP          
SEQRES   6 A  124  ASN ARG TRP GLY ARG VAL GLY GLU VAL GLY GLN SER LYS          
SEQRES   7 A  124  ILE ASN HIS PHE THR ARG LEU GLU ASP ALA LYS LYS ASP          
SEQRES   8 A  124  PHE GLU LYS LYS PHE ARG GLU LYS THR LYS ASN ASN TRP          
SEQRES   9 A  124  ALA GLU ARG ASP HIS PHE VAL SER HIS PRO GLY LYS TYR          
SEQRES  10 A  124  THR LEU ILE GLU VAL GLN ALA                                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A  34      24.203 -19.696   9.344  1.00  0.00           N  
ATOM      2  CA  GLY A  34      25.141 -20.030  10.399  1.00  0.00           C  
ATOM      3  C   GLY A  34      24.463 -20.663  11.599  1.00  0.00           C  
ATOM      4  O   GLY A  34      24.068 -19.969  12.535  1.00  0.00           O  
ATOM      5  H1  GLY A  34      23.842 -18.788   9.281  1.00  0.00           H  
ATOM      6  HA2 GLY A  34      25.875 -20.719  10.009  1.00  0.00           H  
ATOM      7  HA3 GLY A  34      25.642 -19.128  10.719  1.00  0.00           H  
ATOM      8  N   SER A  35      24.326 -21.985  11.569  1.00  0.00           N  
ATOM      9  CA  SER A  35      23.685 -22.711  12.659  1.00  0.00           C  
ATOM     10  C   SER A  35      23.784 -24.218  12.440  1.00  0.00           C  
ATOM     11  O   SER A  35      24.363 -24.677  11.455  1.00  0.00           O  
ATOM     12  CB  SER A  35      22.217 -22.298  12.783  1.00  0.00           C  
ATOM     13  OG  SER A  35      21.457 -22.781  11.689  1.00  0.00           O  
ATOM     14  H   SER A  35      24.661 -22.483  10.794  1.00  0.00           H  
ATOM     15  HA  SER A  35      24.200 -22.457  13.574  1.00  0.00           H  
ATOM     16  HB2 SER A  35      21.808 -22.701  13.696  1.00  0.00           H  
ATOM     17  HB3 SER A  35      22.151 -21.219  12.804  1.00  0.00           H  
ATOM     18  HG  SER A  35      20.549 -22.920  11.966  1.00  0.00           H  
ATOM     19  N   SER A  36      23.215 -24.983  13.367  1.00  0.00           N  
ATOM     20  CA  SER A  36      23.241 -26.438  13.278  1.00  0.00           C  
ATOM     21  C   SER A  36      24.675 -26.959  13.330  1.00  0.00           C  
ATOM     22  O   SER A  36      25.592 -26.341  12.791  1.00  0.00           O  
ATOM     23  CB  SER A  36      22.564 -26.904  11.989  1.00  0.00           C  
ATOM     24  OG  SER A  36      21.177 -27.115  12.189  1.00  0.00           O  
ATOM     25  H   SER A  36      22.769 -24.558  14.129  1.00  0.00           H  
ATOM     26  HA  SER A  36      22.698 -26.831  14.124  1.00  0.00           H  
ATOM     27  HB2 SER A  36      22.695 -26.153  11.225  1.00  0.00           H  
ATOM     28  HB3 SER A  36      23.013 -27.832  11.664  1.00  0.00           H  
ATOM     29  HG  SER A  36      20.684 -26.704  11.476  1.00  0.00           H  
ATOM     30  N   GLY A  37      24.859 -28.102  13.983  1.00  0.00           N  
ATOM     31  CA  GLY A  37      26.182 -28.689  14.094  1.00  0.00           C  
ATOM     32  C   GLY A  37      26.811 -28.960  12.743  1.00  0.00           C  
ATOM     33  O   GLY A  37      26.116 -29.024  11.728  1.00  0.00           O  
ATOM     34  H   GLY A  37      24.090 -28.552  14.393  1.00  0.00           H  
ATOM     35  HA2 GLY A  37      26.818 -28.012  14.647  1.00  0.00           H  
ATOM     36  HA3 GLY A  37      26.106 -29.619  14.636  1.00  0.00           H  
ATOM     37  N   SER A  38      28.130 -29.119  12.726  1.00  0.00           N  
ATOM     38  CA  SER A  38      28.854 -29.379  11.487  1.00  0.00           C  
ATOM     39  C   SER A  38      30.342 -29.582  11.760  1.00  0.00           C  
ATOM     40  O   SER A  38      30.931 -28.893  12.593  1.00  0.00           O  
ATOM     41  CB  SER A  38      28.657 -28.224  10.504  1.00  0.00           C  
ATOM     42  OG  SER A  38      29.222 -28.528   9.241  1.00  0.00           O  
ATOM     43  H   SER A  38      28.629 -29.057  13.568  1.00  0.00           H  
ATOM     44  HA  SER A  38      28.454 -30.283  11.053  1.00  0.00           H  
ATOM     45  HB2 SER A  38      27.601 -28.039  10.378  1.00  0.00           H  
ATOM     46  HB3 SER A  38      29.134 -27.337  10.895  1.00  0.00           H  
ATOM     47  HG  SER A  38      28.775 -28.020   8.559  1.00  0.00           H  
ATOM     48  N   SER A  39      30.942 -30.532  11.051  1.00  0.00           N  
ATOM     49  CA  SER A  39      32.360 -30.829  11.217  1.00  0.00           C  
ATOM     50  C   SER A  39      32.692 -31.091  12.683  1.00  0.00           C  
ATOM     51  O   SER A  39      32.839 -30.159  13.474  1.00  0.00           O  
ATOM     52  CB  SER A  39      33.211 -29.673  10.689  1.00  0.00           C  
ATOM     53  OG  SER A  39      34.583 -29.874  10.980  1.00  0.00           O  
ATOM     54  H   SER A  39      30.419 -31.047  10.402  1.00  0.00           H  
ATOM     55  HA  SER A  39      32.582 -31.718  10.646  1.00  0.00           H  
ATOM     56  HB2 SER A  39      33.089 -29.599   9.619  1.00  0.00           H  
ATOM     57  HB3 SER A  39      32.889 -28.751  11.152  1.00  0.00           H  
ATOM     58  HG  SER A  39      34.696 -29.992  11.926  1.00  0.00           H  
ATOM     59  N   GLY A  40      32.809 -32.366  13.039  1.00  0.00           N  
ATOM     60  CA  GLY A  40      33.121 -32.730  14.408  1.00  0.00           C  
ATOM     61  C   GLY A  40      34.465 -32.191  14.858  1.00  0.00           C  
ATOM     62  O   GLY A  40      34.611 -30.993  15.102  1.00  0.00           O  
ATOM     63  H   GLY A  40      32.681 -33.068  12.365  1.00  0.00           H  
ATOM     64  HA2 GLY A  40      32.352 -32.339  15.058  1.00  0.00           H  
ATOM     65  HA3 GLY A  40      33.134 -33.807  14.490  1.00  0.00           H  
ATOM     66  N   ALA A  41      35.449 -33.077  14.971  1.00  0.00           N  
ATOM     67  CA  ALA A  41      36.787 -32.684  15.395  1.00  0.00           C  
ATOM     68  C   ALA A  41      36.740 -31.896  16.700  1.00  0.00           C  
ATOM     69  O   ALA A  41      35.665 -31.566  17.197  1.00  0.00           O  
ATOM     70  CB  ALA A  41      37.467 -31.867  14.306  1.00  0.00           C  
ATOM     71  H   ALA A  41      35.270 -34.018  14.763  1.00  0.00           H  
ATOM     72  HA  ALA A  41      37.366 -33.584  15.550  1.00  0.00           H  
ATOM     73  HB1 ALA A  41      36.922 -30.948  14.154  1.00  0.00           H  
ATOM     74  HB2 ALA A  41      38.479 -31.640  14.606  1.00  0.00           H  
ATOM     75  HB3 ALA A  41      37.481 -32.434  13.388  1.00  0.00           H  
ATOM     76  N   GLU A  42      37.914 -31.599  17.248  1.00  0.00           N  
ATOM     77  CA  GLU A  42      38.005 -30.851  18.497  1.00  0.00           C  
ATOM     78  C   GLU A  42      38.553 -29.448  18.251  1.00  0.00           C  
ATOM     79  O   GLU A  42      39.724 -29.276  17.912  1.00  0.00           O  
ATOM     80  CB  GLU A  42      38.897 -31.590  19.496  1.00  0.00           C  
ATOM     81  CG  GLU A  42      38.655 -31.187  20.942  1.00  0.00           C  
ATOM     82  CD  GLU A  42      39.109 -32.248  21.926  1.00  0.00           C  
ATOM     83  OE1 GLU A  42      38.970 -33.448  21.612  1.00  0.00           O  
ATOM     84  OE2 GLU A  42      39.603 -31.876  23.011  1.00  0.00           O  
ATOM     85  H   GLU A  42      38.738 -31.890  16.804  1.00  0.00           H  
ATOM     86  HA  GLU A  42      37.011 -30.769  18.908  1.00  0.00           H  
ATOM     87  HB2 GLU A  42      38.718 -32.651  19.405  1.00  0.00           H  
ATOM     88  HB3 GLU A  42      39.930 -31.387  19.257  1.00  0.00           H  
ATOM     89  HG2 GLU A  42      39.197 -30.275  21.143  1.00  0.00           H  
ATOM     90  HG3 GLU A  42      37.598 -31.015  21.082  1.00  0.00           H  
ATOM     91  N   LYS A  43      37.696 -28.446  18.423  1.00  0.00           N  
ATOM     92  CA  LYS A  43      38.092 -27.057  18.222  1.00  0.00           C  
ATOM     93  C   LYS A  43      39.138 -26.635  19.249  1.00  0.00           C  
ATOM     94  O   LYS A  43      38.875 -26.633  20.452  1.00  0.00           O  
ATOM     95  CB  LYS A  43      36.871 -26.140  18.315  1.00  0.00           C  
ATOM     96  CG  LYS A  43      35.941 -26.242  17.119  1.00  0.00           C  
ATOM     97  CD  LYS A  43      35.022 -25.036  17.021  1.00  0.00           C  
ATOM     98  CE  LYS A  43      35.661 -23.911  16.223  1.00  0.00           C  
ATOM     99  NZ  LYS A  43      35.855 -24.285  14.795  1.00  0.00           N  
ATOM    100  H   LYS A  43      36.776 -28.646  18.695  1.00  0.00           H  
ATOM    101  HA  LYS A  43      38.520 -26.974  17.235  1.00  0.00           H  
ATOM    102  HB2 LYS A  43      36.311 -26.393  19.204  1.00  0.00           H  
ATOM    103  HB3 LYS A  43      37.209 -25.117  18.393  1.00  0.00           H  
ATOM    104  HG2 LYS A  43      36.532 -26.304  16.218  1.00  0.00           H  
ATOM    105  HG3 LYS A  43      35.339 -27.135  17.218  1.00  0.00           H  
ATOM    106  HD2 LYS A  43      34.104 -25.331  16.535  1.00  0.00           H  
ATOM    107  HD3 LYS A  43      34.803 -24.680  18.018  1.00  0.00           H  
ATOM    108  HE2 LYS A  43      35.022 -23.042  16.276  1.00  0.00           H  
ATOM    109  HE3 LYS A  43      36.621 -23.679  16.660  1.00  0.00           H  
ATOM    110  HZ1 LYS A  43      36.613 -24.993  14.710  1.00  0.00           H  
ATOM    111  HZ2 LYS A  43      36.115 -23.445  14.238  1.00  0.00           H  
ATOM    112  HZ3 LYS A  43      34.978 -24.685  14.407  1.00  0.00           H  
ATOM    113  N   ARG A  44      40.322 -26.276  18.766  1.00  0.00           N  
ATOM    114  CA  ARG A  44      41.408 -25.851  19.643  1.00  0.00           C  
ATOM    115  C   ARG A  44      41.280 -24.370  19.987  1.00  0.00           C  
ATOM    116  O   ARG A  44      40.780 -23.578  19.188  1.00  0.00           O  
ATOM    117  CB  ARG A  44      42.761 -26.117  18.981  1.00  0.00           C  
ATOM    118  CG  ARG A  44      43.878 -26.403  19.971  1.00  0.00           C  
ATOM    119  CD  ARG A  44      44.573 -25.125  20.411  1.00  0.00           C  
ATOM    120  NE  ARG A  44      45.136 -25.243  21.753  1.00  0.00           N  
ATOM    121  CZ  ARG A  44      46.347 -25.732  22.002  1.00  0.00           C  
ATOM    122  NH1 ARG A  44      47.115 -26.146  21.003  1.00  0.00           N  
ATOM    123  NH2 ARG A  44      46.790 -25.808  23.249  1.00  0.00           N  
ATOM    124  H   ARG A  44      40.472 -26.298  17.798  1.00  0.00           H  
ATOM    125  HA  ARG A  44      41.344 -26.427  20.554  1.00  0.00           H  
ATOM    126  HB2 ARG A  44      42.666 -26.969  18.323  1.00  0.00           H  
ATOM    127  HB3 ARG A  44      43.039 -25.252  18.398  1.00  0.00           H  
ATOM    128  HG2 ARG A  44      43.460 -26.890  20.840  1.00  0.00           H  
ATOM    129  HG3 ARG A  44      44.602 -27.054  19.503  1.00  0.00           H  
ATOM    130  HD2 ARG A  44      45.368 -24.904  19.715  1.00  0.00           H  
ATOM    131  HD3 ARG A  44      43.854 -24.319  20.403  1.00  0.00           H  
ATOM    132  HE  ARG A  44      44.586 -24.943  22.505  1.00  0.00           H  
ATOM    133 HH11 ARG A  44      46.784 -26.089  20.062  1.00  0.00           H  
ATOM    134 HH12 ARG A  44      48.027 -26.512  21.193  1.00  0.00           H  
ATOM    135 HH21 ARG A  44      46.213 -25.496  24.005  1.00  0.00           H  
ATOM    136 HH22 ARG A  44      47.701 -26.175  23.436  1.00  0.00           H  
ATOM    137  N   ILE A  45      41.735 -24.004  21.181  1.00  0.00           N  
ATOM    138  CA  ILE A  45      41.672 -22.619  21.629  1.00  0.00           C  
ATOM    139  C   ILE A  45      43.068 -22.060  21.888  1.00  0.00           C  
ATOM    140  O   ILE A  45      43.936 -22.754  22.418  1.00  0.00           O  
ATOM    141  CB  ILE A  45      40.830 -22.480  22.912  1.00  0.00           C  
ATOM    142  CG1 ILE A  45      39.440 -23.082  22.702  1.00  0.00           C  
ATOM    143  CG2 ILE A  45      40.725 -21.019  23.321  1.00  0.00           C  
ATOM    144  CD1 ILE A  45      38.627 -22.372  21.643  1.00  0.00           C  
ATOM    145  H   ILE A  45      42.123 -24.681  21.772  1.00  0.00           H  
ATOM    146  HA  ILE A  45      41.202 -22.037  20.850  1.00  0.00           H  
ATOM    147  HB  ILE A  45      41.331 -23.016  23.704  1.00  0.00           H  
ATOM    148 HG12 ILE A  45      39.542 -24.113  22.405  1.00  0.00           H  
ATOM    149 HG13 ILE A  45      38.891 -23.032  23.631  1.00  0.00           H  
ATOM    150 HG21 ILE A  45      41.527 -20.777  24.003  1.00  0.00           H  
ATOM    151 HG22 ILE A  45      40.799 -20.394  22.443  1.00  0.00           H  
ATOM    152 HG23 ILE A  45      39.776 -20.848  23.807  1.00  0.00           H  
ATOM    153 HD11 ILE A  45      38.742 -22.883  20.698  1.00  0.00           H  
ATOM    154 HD12 ILE A  45      37.585 -22.374  21.927  1.00  0.00           H  
ATOM    155 HD13 ILE A  45      38.973 -21.353  21.545  1.00  0.00           H  
ATOM    156  N   ILE A  46      43.275 -20.804  21.511  1.00  0.00           N  
ATOM    157  CA  ILE A  46      44.564 -20.152  21.705  1.00  0.00           C  
ATOM    158  C   ILE A  46      44.433 -18.933  22.612  1.00  0.00           C  
ATOM    159  O   ILE A  46      43.406 -18.253  22.611  1.00  0.00           O  
ATOM    160  CB  ILE A  46      45.182 -19.715  20.363  1.00  0.00           C  
ATOM    161  CG1 ILE A  46      45.218 -20.892  19.387  1.00  0.00           C  
ATOM    162  CG2 ILE A  46      46.581 -19.158  20.580  1.00  0.00           C  
ATOM    163  CD1 ILE A  46      45.971 -22.093  19.915  1.00  0.00           C  
ATOM    164  H   ILE A  46      42.544 -20.303  21.094  1.00  0.00           H  
ATOM    165  HA  ILE A  46      45.231 -20.863  22.171  1.00  0.00           H  
ATOM    166  HB  ILE A  46      44.568 -18.931  19.948  1.00  0.00           H  
ATOM    167 HG12 ILE A  46      44.208 -21.204  19.170  1.00  0.00           H  
ATOM    168 HG13 ILE A  46      45.697 -20.576  18.471  1.00  0.00           H  
ATOM    169 HG21 ILE A  46      46.926 -18.688  19.671  1.00  0.00           H  
ATOM    170 HG22 ILE A  46      46.556 -18.426  21.374  1.00  0.00           H  
ATOM    171 HG23 ILE A  46      47.250 -19.960  20.849  1.00  0.00           H  
ATOM    172 HD11 ILE A  46      46.989 -21.810  20.139  1.00  0.00           H  
ATOM    173 HD12 ILE A  46      45.492 -22.451  20.816  1.00  0.00           H  
ATOM    174 HD13 ILE A  46      45.970 -22.875  19.171  1.00  0.00           H  
ATOM    175  N   ARG A  47      45.481 -18.659  23.382  1.00  0.00           N  
ATOM    176  CA  ARG A  47      45.483 -17.522  24.294  1.00  0.00           C  
ATOM    177  C   ARG A  47      46.694 -16.627  24.043  1.00  0.00           C  
ATOM    178  O   ARG A  47      47.838 -17.065  24.164  1.00  0.00           O  
ATOM    179  CB  ARG A  47      45.484 -18.004  25.746  1.00  0.00           C  
ATOM    180  CG  ARG A  47      44.303 -18.897  26.090  1.00  0.00           C  
ATOM    181  CD  ARG A  47      43.011 -18.100  26.188  1.00  0.00           C  
ATOM    182  NE  ARG A  47      42.779 -17.598  27.540  1.00  0.00           N  
ATOM    183  CZ  ARG A  47      41.952 -16.597  27.820  1.00  0.00           C  
ATOM    184  NH1 ARG A  47      41.281 -15.994  26.847  1.00  0.00           N  
ATOM    185  NH2 ARG A  47      41.794 -16.197  29.075  1.00  0.00           N  
ATOM    186  H   ARG A  47      46.271 -19.237  23.338  1.00  0.00           H  
ATOM    187  HA  ARG A  47      44.585 -16.950  24.114  1.00  0.00           H  
ATOM    188  HB2 ARG A  47      46.392 -18.559  25.928  1.00  0.00           H  
ATOM    189  HB3 ARG A  47      45.459 -17.144  26.398  1.00  0.00           H  
ATOM    190  HG2 ARG A  47      44.193 -19.647  25.321  1.00  0.00           H  
ATOM    191  HG3 ARG A  47      44.492 -19.378  27.039  1.00  0.00           H  
ATOM    192  HD2 ARG A  47      43.067 -17.263  25.508  1.00  0.00           H  
ATOM    193  HD3 ARG A  47      42.188 -18.738  25.905  1.00  0.00           H  
ATOM    194  HE  ARG A  47      43.264 -18.029  28.273  1.00  0.00           H  
ATOM    195 HH11 ARG A  47      41.398 -16.295  25.901  1.00  0.00           H  
ATOM    196 HH12 ARG A  47      40.658 -15.242  27.061  1.00  0.00           H  
ATOM    197 HH21 ARG A  47      42.297 -16.648  29.810  1.00  0.00           H  
ATOM    198 HH22 ARG A  47      41.171 -15.444  29.284  1.00  0.00           H  
ATOM    199  N   VAL A  48      46.433 -15.372  23.693  1.00  0.00           N  
ATOM    200  CA  VAL A  48      47.501 -14.416  23.426  1.00  0.00           C  
ATOM    201  C   VAL A  48      48.542 -14.429  24.540  1.00  0.00           C  
ATOM    202  O   VAL A  48      48.220 -14.211  25.708  1.00  0.00           O  
ATOM    203  CB  VAL A  48      46.949 -12.985  23.273  1.00  0.00           C  
ATOM    204  CG1 VAL A  48      48.080 -11.998  23.031  1.00  0.00           C  
ATOM    205  CG2 VAL A  48      45.929 -12.927  22.145  1.00  0.00           C  
ATOM    206  H   VAL A  48      45.501 -15.081  23.613  1.00  0.00           H  
ATOM    207  HA  VAL A  48      47.977 -14.697  22.498  1.00  0.00           H  
ATOM    208  HB  VAL A  48      46.453 -12.713  24.193  1.00  0.00           H  
ATOM    209 HG11 VAL A  48      48.605 -11.820  23.958  1.00  0.00           H  
ATOM    210 HG12 VAL A  48      48.764 -12.406  22.302  1.00  0.00           H  
ATOM    211 HG13 VAL A  48      47.673 -11.068  22.664  1.00  0.00           H  
ATOM    212 HG21 VAL A  48      46.376 -12.464  21.279  1.00  0.00           H  
ATOM    213 HG22 VAL A  48      45.612 -13.928  21.896  1.00  0.00           H  
ATOM    214 HG23 VAL A  48      45.074 -12.347  22.462  1.00  0.00           H  
ATOM    215  N   ASP A  49      49.792 -14.687  24.171  1.00  0.00           N  
ATOM    216  CA  ASP A  49      50.882 -14.728  25.138  1.00  0.00           C  
ATOM    217  C   ASP A  49      50.740 -13.608  26.164  1.00  0.00           C  
ATOM    218  O   ASP A  49      50.348 -12.485  25.845  1.00  0.00           O  
ATOM    219  CB  ASP A  49      52.230 -14.613  24.424  1.00  0.00           C  
ATOM    220  CG  ASP A  49      53.331 -15.371  25.141  1.00  0.00           C  
ATOM    221  OD1 ASP A  49      53.126 -16.564  25.448  1.00  0.00           O  
ATOM    222  OD2 ASP A  49      54.396 -14.771  25.396  1.00  0.00           O  
ATOM    223  H   ASP A  49      49.987 -14.852  23.224  1.00  0.00           H  
ATOM    224  HA  ASP A  49      50.836 -15.676  25.650  1.00  0.00           H  
ATOM    225  HB2 ASP A  49      52.136 -15.013  23.425  1.00  0.00           H  
ATOM    226  HB3 ASP A  49      52.513 -13.573  24.366  1.00  0.00           H  
ATOM    227  N   PRO A  50      51.065 -13.919  27.429  1.00  0.00           N  
ATOM    228  CA  PRO A  50      50.980 -12.952  28.528  1.00  0.00           C  
ATOM    229  C   PRO A  50      52.038 -11.859  28.421  1.00  0.00           C  
ATOM    230  O   PRO A  50      51.736 -10.673  28.550  1.00  0.00           O  
ATOM    231  CB  PRO A  50      51.222 -13.811  29.773  1.00  0.00           C  
ATOM    232  CG  PRO A  50      52.013 -14.974  29.284  1.00  0.00           C  
ATOM    233  CD  PRO A  50      51.540 -15.237  27.881  1.00  0.00           C  
ATOM    234  HA  PRO A  50      50.001 -12.500  28.584  1.00  0.00           H  
ATOM    235  HB2 PRO A  50      51.771 -13.238  30.506  1.00  0.00           H  
ATOM    236  HB3 PRO A  50      50.275 -14.123  30.187  1.00  0.00           H  
ATOM    237  HG2 PRO A  50      53.064 -14.730  29.285  1.00  0.00           H  
ATOM    238  HG3 PRO A  50      51.826 -15.834  29.909  1.00  0.00           H  
ATOM    239  HD2 PRO A  50      52.356 -15.585  27.267  1.00  0.00           H  
ATOM    240  HD3 PRO A  50      50.734 -15.956  27.884  1.00  0.00           H  
ATOM    241  N   THR A  51      53.282 -12.267  28.184  1.00  0.00           N  
ATOM    242  CA  THR A  51      54.385 -11.322  28.061  1.00  0.00           C  
ATOM    243  C   THR A  51      54.065 -10.233  27.044  1.00  0.00           C  
ATOM    244  O   THR A  51      54.586  -9.120  27.128  1.00  0.00           O  
ATOM    245  CB  THR A  51      55.688 -12.031  27.644  1.00  0.00           C  
ATOM    246  OG1 THR A  51      55.452 -12.853  26.496  1.00  0.00           O  
ATOM    247  CG2 THR A  51      56.228 -12.884  28.783  1.00  0.00           C  
ATOM    248  H   THR A  51      53.460 -13.226  28.091  1.00  0.00           H  
ATOM    249  HA  THR A  51      54.542 -10.865  29.027  1.00  0.00           H  
ATOM    250  HB  THR A  51      56.424 -11.281  27.396  1.00  0.00           H  
ATOM    251  HG1 THR A  51      54.717 -12.496  25.993  1.00  0.00           H  
ATOM    252 HG21 THR A  51      55.721 -13.837  28.789  1.00  0.00           H  
ATOM    253 HG22 THR A  51      56.057 -12.380  29.722  1.00  0.00           H  
ATOM    254 HG23 THR A  51      57.287 -13.040  28.644  1.00  0.00           H  
ATOM    255  N   CYS A  52      53.205 -10.560  26.085  1.00  0.00           N  
ATOM    256  CA  CYS A  52      52.817  -9.607  25.051  1.00  0.00           C  
ATOM    257  C   CYS A  52      51.875  -8.547  25.614  1.00  0.00           C  
ATOM    258  O   CYS A  52      50.977  -8.836  26.405  1.00  0.00           O  
ATOM    259  CB  CYS A  52      52.145 -10.335  23.886  1.00  0.00           C  
ATOM    260  SG  CYS A  52      51.112  -9.273  22.849  1.00  0.00           S  
ATOM    261  H   CYS A  52      52.824 -11.462  26.071  1.00  0.00           H  
ATOM    262  HA  CYS A  52      53.712  -9.123  24.693  1.00  0.00           H  
ATOM    263  HB2 CYS A  52      52.907 -10.768  23.254  1.00  0.00           H  
ATOM    264  HB3 CYS A  52      51.518 -11.124  24.276  1.00  0.00           H  
ATOM    265  HG  CYS A  52      51.864  -8.807  21.864  1.00  0.00           H  
ATOM    266  N   PRO A  53      52.086  -7.289  25.201  1.00  0.00           N  
ATOM    267  CA  PRO A  53      51.268  -6.160  25.652  1.00  0.00           C  
ATOM    268  C   PRO A  53      49.850  -6.210  25.093  1.00  0.00           C  
ATOM    269  O   PRO A  53      48.875  -6.092  25.834  1.00  0.00           O  
ATOM    270  CB  PRO A  53      52.015  -4.940  25.107  1.00  0.00           C  
ATOM    271  CG  PRO A  53      52.768  -5.452  23.928  1.00  0.00           C  
ATOM    272  CD  PRO A  53      53.139  -6.872  24.259  1.00  0.00           C  
ATOM    273  HA  PRO A  53      51.226  -6.106  26.730  1.00  0.00           H  
ATOM    274  HB2 PRO A  53      51.304  -4.177  24.821  1.00  0.00           H  
ATOM    275  HB3 PRO A  53      52.682  -4.553  25.864  1.00  0.00           H  
ATOM    276  HG2 PRO A  53      52.141  -5.424  23.051  1.00  0.00           H  
ATOM    277  HG3 PRO A  53      53.658  -4.859  23.775  1.00  0.00           H  
ATOM    278  HD2 PRO A  53      53.125  -7.483  23.369  1.00  0.00           H  
ATOM    279  HD3 PRO A  53      54.111  -6.908  24.729  1.00  0.00           H  
ATOM    280  N   LEU A  54      49.743  -6.387  23.780  1.00  0.00           N  
ATOM    281  CA  LEU A  54      48.444  -6.454  23.121  1.00  0.00           C  
ATOM    282  C   LEU A  54      47.497  -7.381  23.877  1.00  0.00           C  
ATOM    283  O   LEU A  54      46.292  -7.140  23.933  1.00  0.00           O  
ATOM    284  CB  LEU A  54      48.606  -6.938  21.679  1.00  0.00           C  
ATOM    285  CG  LEU A  54      49.602  -6.160  20.818  1.00  0.00           C  
ATOM    286  CD1 LEU A  54      49.948  -6.944  19.561  1.00  0.00           C  
ATOM    287  CD2 LEU A  54      49.041  -4.793  20.457  1.00  0.00           C  
ATOM    288  H   LEU A  54      50.557  -6.475  23.241  1.00  0.00           H  
ATOM    289  HA  LEU A  54      48.025  -5.459  23.113  1.00  0.00           H  
ATOM    290  HB2 LEU A  54      48.930  -7.967  21.710  1.00  0.00           H  
ATOM    291  HB3 LEU A  54      47.639  -6.881  21.200  1.00  0.00           H  
ATOM    292  HG  LEU A  54      50.514  -6.011  21.379  1.00  0.00           H  
ATOM    293 HD11 LEU A  54      50.743  -6.442  19.031  1.00  0.00           H  
ATOM    294 HD12 LEU A  54      49.077  -7.011  18.927  1.00  0.00           H  
ATOM    295 HD13 LEU A  54      50.270  -7.939  19.835  1.00  0.00           H  
ATOM    296 HD21 LEU A  54      49.566  -4.403  19.598  1.00  0.00           H  
ATOM    297 HD22 LEU A  54      49.169  -4.121  21.293  1.00  0.00           H  
ATOM    298 HD23 LEU A  54      47.990  -4.885  20.227  1.00  0.00           H  
ATOM    299  N   SER A  55      48.052  -8.440  24.457  1.00  0.00           N  
ATOM    300  CA  SER A  55      47.256  -9.404  25.209  1.00  0.00           C  
ATOM    301  C   SER A  55      46.201  -8.696  26.053  1.00  0.00           C  
ATOM    302  O   SER A  55      45.029  -9.071  26.043  1.00  0.00           O  
ATOM    303  CB  SER A  55      48.159 -10.253  26.106  1.00  0.00           C  
ATOM    304  OG  SER A  55      48.569  -9.526  27.250  1.00  0.00           O  
ATOM    305  H   SER A  55      49.018  -8.578  24.375  1.00  0.00           H  
ATOM    306  HA  SER A  55      46.759 -10.049  24.499  1.00  0.00           H  
ATOM    307  HB2 SER A  55      47.620 -11.131  26.427  1.00  0.00           H  
ATOM    308  HB3 SER A  55      49.035 -10.552  25.549  1.00  0.00           H  
ATOM    309  HG  SER A  55      49.528  -9.467  27.267  1.00  0.00           H  
ATOM    310  N   SER A  56      46.626  -7.671  26.783  1.00  0.00           N  
ATOM    311  CA  SER A  56      45.720  -6.912  27.636  1.00  0.00           C  
ATOM    312  C   SER A  56      44.638  -6.228  26.808  1.00  0.00           C  
ATOM    313  O   SER A  56      43.464  -6.227  27.178  1.00  0.00           O  
ATOM    314  CB  SER A  56      46.498  -5.869  28.442  1.00  0.00           C  
ATOM    315  OG  SER A  56      45.695  -5.315  29.470  1.00  0.00           O  
ATOM    316  H   SER A  56      47.574  -7.420  26.749  1.00  0.00           H  
ATOM    317  HA  SER A  56      45.251  -7.604  28.320  1.00  0.00           H  
ATOM    318  HB2 SER A  56      47.363  -6.334  28.889  1.00  0.00           H  
ATOM    319  HB3 SER A  56      46.817  -5.074  27.783  1.00  0.00           H  
ATOM    320  HG  SER A  56      45.087  -4.675  29.093  1.00  0.00           H  
ATOM    321  N   ASN A  57      45.042  -5.645  25.684  1.00  0.00           N  
ATOM    322  CA  ASN A  57      44.108  -4.956  24.802  1.00  0.00           C  
ATOM    323  C   ASN A  57      42.973  -5.884  24.379  1.00  0.00           C  
ATOM    324  O   ASN A  57      43.192  -7.003  23.917  1.00  0.00           O  
ATOM    325  CB  ASN A  57      44.836  -4.429  23.564  1.00  0.00           C  
ATOM    326  CG  ASN A  57      45.472  -3.073  23.801  1.00  0.00           C  
ATOM    327  OD1 ASN A  57      45.565  -2.608  24.937  1.00  0.00           O  
ATOM    328  ND2 ASN A  57      45.914  -2.430  22.726  1.00  0.00           N  
ATOM    329  H   ASN A  57      45.991  -5.678  25.442  1.00  0.00           H  
ATOM    330  HA  ASN A  57      43.692  -4.121  25.346  1.00  0.00           H  
ATOM    331  HB2 ASN A  57      45.615  -5.125  23.288  1.00  0.00           H  
ATOM    332  HB3 ASN A  57      44.134  -4.339  22.749  1.00  0.00           H  
ATOM    333 HD21 ASN A  57      45.806  -2.860  21.852  1.00  0.00           H  
ATOM    334 HD22 ASN A  57      46.330  -1.551  22.851  1.00  0.00           H  
ATOM    335  N   PRO A  58      41.728  -5.409  24.542  1.00  0.00           N  
ATOM    336  CA  PRO A  58      40.535  -6.179  24.184  1.00  0.00           C  
ATOM    337  C   PRO A  58      40.381  -6.343  22.675  1.00  0.00           C  
ATOM    338  O   PRO A  58      40.567  -5.392  21.917  1.00  0.00           O  
ATOM    339  CB  PRO A  58      39.387  -5.340  24.750  1.00  0.00           C  
ATOM    340  CG  PRO A  58      39.923  -3.950  24.799  1.00  0.00           C  
ATOM    341  CD  PRO A  58      41.393  -4.083  25.087  1.00  0.00           C  
ATOM    342  HA  PRO A  58      40.535  -7.153  24.651  1.00  0.00           H  
ATOM    343  HB2 PRO A  58      38.529  -5.410  24.097  1.00  0.00           H  
ATOM    344  HB3 PRO A  58      39.127  -5.697  25.735  1.00  0.00           H  
ATOM    345  HG2 PRO A  58      39.770  -3.463  23.848  1.00  0.00           H  
ATOM    346  HG3 PRO A  58      39.435  -3.396  25.588  1.00  0.00           H  
ATOM    347  HD2 PRO A  58      41.948  -3.306  24.583  1.00  0.00           H  
ATOM    348  HD3 PRO A  58      41.573  -4.048  26.152  1.00  0.00           H  
ATOM    349  N   GLY A  59      40.040  -7.554  22.247  1.00  0.00           N  
ATOM    350  CA  GLY A  59      39.866  -7.819  20.830  1.00  0.00           C  
ATOM    351  C   GLY A  59      41.069  -8.509  20.218  1.00  0.00           C  
ATOM    352  O   GLY A  59      40.932  -9.303  19.288  1.00  0.00           O  
ATOM    353  H   GLY A  59      39.904  -8.274  22.897  1.00  0.00           H  
ATOM    354  HA2 GLY A  59      38.997  -8.445  20.695  1.00  0.00           H  
ATOM    355  HA3 GLY A  59      39.704  -6.881  20.318  1.00  0.00           H  
ATOM    356  N   THR A  60      42.253  -8.203  20.739  1.00  0.00           N  
ATOM    357  CA  THR A  60      43.485  -8.798  20.236  1.00  0.00           C  
ATOM    358  C   THR A  60      43.498 -10.306  20.457  1.00  0.00           C  
ATOM    359  O   THR A  60      43.612 -10.774  21.589  1.00  0.00           O  
ATOM    360  CB  THR A  60      44.724  -8.180  20.912  1.00  0.00           C  
ATOM    361  OG1 THR A  60      44.782  -6.775  20.640  1.00  0.00           O  
ATOM    362  CG2 THR A  60      45.999  -8.850  20.422  1.00  0.00           C  
ATOM    363  H   THR A  60      42.298  -7.562  21.479  1.00  0.00           H  
ATOM    364  HA  THR A  60      43.544  -8.598  19.176  1.00  0.00           H  
ATOM    365  HB  THR A  60      44.644  -8.329  21.980  1.00  0.00           H  
ATOM    366  HG1 THR A  60      45.114  -6.635  19.750  1.00  0.00           H  
ATOM    367 HG21 THR A  60      46.644  -8.109  19.974  1.00  0.00           H  
ATOM    368 HG22 THR A  60      45.751  -9.602  19.689  1.00  0.00           H  
ATOM    369 HG23 THR A  60      46.506  -9.312  21.256  1.00  0.00           H  
ATOM    370  N   GLN A  61      43.382 -11.060  19.369  1.00  0.00           N  
ATOM    371  CA  GLN A  61      43.381 -12.515  19.446  1.00  0.00           C  
ATOM    372  C   GLN A  61      44.490 -13.108  18.582  1.00  0.00           C  
ATOM    373  O   GLN A  61      45.084 -12.414  17.756  1.00  0.00           O  
ATOM    374  CB  GLN A  61      42.025 -13.070  19.006  1.00  0.00           C  
ATOM    375  CG  GLN A  61      41.774 -12.947  17.511  1.00  0.00           C  
ATOM    376  CD  GLN A  61      40.308 -13.083  17.154  1.00  0.00           C  
ATOM    377  OE1 GLN A  61      39.926 -13.953  16.368  1.00  0.00           O  
ATOM    378  NE2 GLN A  61      39.474 -12.224  17.728  1.00  0.00           N  
ATOM    379  H   GLN A  61      43.295 -10.627  18.495  1.00  0.00           H  
ATOM    380  HA  GLN A  61      43.556 -12.794  20.474  1.00  0.00           H  
ATOM    381  HB2 GLN A  61      41.972 -14.115  19.274  1.00  0.00           H  
ATOM    382  HB3 GLN A  61      41.244 -12.533  19.525  1.00  0.00           H  
ATOM    383  HG2 GLN A  61      42.120 -11.980  17.179  1.00  0.00           H  
ATOM    384  HG3 GLN A  61      42.328 -13.722  17.002  1.00  0.00           H  
ATOM    385 HE21 GLN A  61      39.849 -11.557  18.342  1.00  0.00           H  
ATOM    386 HE22 GLN A  61      38.521 -12.289  17.514  1.00  0.00           H  
ATOM    387  N   VAL A  62      44.763 -14.393  18.777  1.00  0.00           N  
ATOM    388  CA  VAL A  62      45.801 -15.079  18.015  1.00  0.00           C  
ATOM    389  C   VAL A  62      45.269 -15.554  16.668  1.00  0.00           C  
ATOM    390  O   VAL A  62      44.509 -16.519  16.594  1.00  0.00           O  
ATOM    391  CB  VAL A  62      46.360 -16.287  18.790  1.00  0.00           C  
ATOM    392  CG1 VAL A  62      47.342 -17.067  17.928  1.00  0.00           C  
ATOM    393  CG2 VAL A  62      47.017 -15.833  20.084  1.00  0.00           C  
ATOM    394  H   VAL A  62      44.256 -14.894  19.450  1.00  0.00           H  
ATOM    395  HA  VAL A  62      46.608 -14.381  17.848  1.00  0.00           H  
ATOM    396  HB  VAL A  62      45.537 -16.941  19.038  1.00  0.00           H  
ATOM    397 HG11 VAL A  62      48.287 -17.146  18.444  1.00  0.00           H  
ATOM    398 HG12 VAL A  62      46.949 -18.054  17.737  1.00  0.00           H  
ATOM    399 HG13 VAL A  62      47.487 -16.549  16.990  1.00  0.00           H  
ATOM    400 HG21 VAL A  62      47.754 -16.561  20.389  1.00  0.00           H  
ATOM    401 HG22 VAL A  62      47.497 -14.879  19.927  1.00  0.00           H  
ATOM    402 HG23 VAL A  62      46.267 -15.735  20.855  1.00  0.00           H  
ATOM    403  N   TYR A  63      45.675 -14.869  15.604  1.00  0.00           N  
ATOM    404  CA  TYR A  63      45.238 -15.220  14.258  1.00  0.00           C  
ATOM    405  C   TYR A  63      45.308 -16.728  14.038  1.00  0.00           C  
ATOM    406  O   TYR A  63      46.378 -17.330  14.125  1.00  0.00           O  
ATOM    407  CB  TYR A  63      46.099 -14.502  13.217  1.00  0.00           C  
ATOM    408  CG  TYR A  63      45.717 -14.825  11.790  1.00  0.00           C  
ATOM    409  CD1 TYR A  63      44.537 -14.341  11.238  1.00  0.00           C  
ATOM    410  CD2 TYR A  63      46.537 -15.615  10.992  1.00  0.00           C  
ATOM    411  CE1 TYR A  63      44.184 -14.634   9.935  1.00  0.00           C  
ATOM    412  CE2 TYR A  63      46.193 -15.912   9.688  1.00  0.00           C  
ATOM    413  CZ  TYR A  63      45.016 -15.419   9.164  1.00  0.00           C  
ATOM    414  OH  TYR A  63      44.669 -15.714   7.865  1.00  0.00           O  
ATOM    415  H   TYR A  63      46.281 -14.110  15.726  1.00  0.00           H  
ATOM    416  HA  TYR A  63      44.213 -14.899  14.147  1.00  0.00           H  
ATOM    417  HB2 TYR A  63      46.000 -13.436  13.352  1.00  0.00           H  
ATOM    418  HB3 TYR A  63      47.131 -14.784  13.357  1.00  0.00           H  
ATOM    419  HD1 TYR A  63      43.888 -13.727  11.845  1.00  0.00           H  
ATOM    420  HD2 TYR A  63      47.458 -15.999  11.407  1.00  0.00           H  
ATOM    421  HE1 TYR A  63      43.263 -14.249   9.524  1.00  0.00           H  
ATOM    422  HE2 TYR A  63      46.844 -16.527   9.085  1.00  0.00           H  
ATOM    423  HH  TYR A  63      44.313 -14.929   7.444  1.00  0.00           H  
ATOM    424  N   GLU A  64      44.158 -17.332  13.752  1.00  0.00           N  
ATOM    425  CA  GLU A  64      44.088 -18.770  13.520  1.00  0.00           C  
ATOM    426  C   GLU A  64      44.772 -19.537  14.648  1.00  0.00           C  
ATOM    427  O   GLU A  64      44.721 -19.132  15.809  1.00  0.00           O  
ATOM    428  CB  GLU A  64      44.737 -19.124  12.181  1.00  0.00           C  
ATOM    429  CG  GLU A  64      44.322 -18.208  11.042  1.00  0.00           C  
ATOM    430  CD  GLU A  64      44.499 -18.852   9.681  1.00  0.00           C  
ATOM    431  OE1 GLU A  64      45.568 -19.452   9.444  1.00  0.00           O  
ATOM    432  OE2 GLU A  64      43.570 -18.755   8.852  1.00  0.00           O  
ATOM    433  H   GLU A  64      43.338 -16.798  13.698  1.00  0.00           H  
ATOM    434  HA  GLU A  64      43.047 -19.050  13.491  1.00  0.00           H  
ATOM    435  HB2 GLU A  64      45.810 -19.069  12.288  1.00  0.00           H  
ATOM    436  HB3 GLU A  64      44.462 -20.136  11.919  1.00  0.00           H  
ATOM    437  HG2 GLU A  64      43.281 -17.948  11.167  1.00  0.00           H  
ATOM    438  HG3 GLU A  64      44.923 -17.311  11.081  1.00  0.00           H  
ATOM    439  N   ASP A  65      45.412 -20.647  14.297  1.00  0.00           N  
ATOM    440  CA  ASP A  65      46.107 -21.472  15.278  1.00  0.00           C  
ATOM    441  C   ASP A  65      47.619 -21.365  15.105  1.00  0.00           C  
ATOM    442  O   ASP A  65      48.355 -22.311  15.386  1.00  0.00           O  
ATOM    443  CB  ASP A  65      45.669 -22.933  15.151  1.00  0.00           C  
ATOM    444  CG  ASP A  65      44.243 -23.067  14.655  1.00  0.00           C  
ATOM    445  OD1 ASP A  65      43.318 -23.049  15.494  1.00  0.00           O  
ATOM    446  OD2 ASP A  65      44.051 -23.192  13.427  1.00  0.00           O  
ATOM    447  H   ASP A  65      45.416 -20.918  13.355  1.00  0.00           H  
ATOM    448  HA  ASP A  65      45.844 -21.112  16.261  1.00  0.00           H  
ATOM    449  HB2 ASP A  65      46.322 -23.437  14.455  1.00  0.00           H  
ATOM    450  HB3 ASP A  65      45.742 -23.409  16.117  1.00  0.00           H  
ATOM    451  N   TYR A  66      48.074 -20.207  14.641  1.00  0.00           N  
ATOM    452  CA  TYR A  66      49.499 -19.977  14.427  1.00  0.00           C  
ATOM    453  C   TYR A  66      50.221 -19.762  15.753  1.00  0.00           C  
ATOM    454  O   TYR A  66      50.590 -18.641  16.097  1.00  0.00           O  
ATOM    455  CB  TYR A  66      49.710 -18.766  13.516  1.00  0.00           C  
ATOM    456  CG  TYR A  66      49.560 -19.081  12.045  1.00  0.00           C  
ATOM    457  CD1 TYR A  66      50.479 -19.891  11.390  1.00  0.00           C  
ATOM    458  CD2 TYR A  66      48.499 -18.567  11.309  1.00  0.00           C  
ATOM    459  CE1 TYR A  66      50.347 -20.180  10.047  1.00  0.00           C  
ATOM    460  CE2 TYR A  66      48.357 -18.853   9.965  1.00  0.00           C  
ATOM    461  CZ  TYR A  66      49.284 -19.659   9.339  1.00  0.00           C  
ATOM    462  OH  TYR A  66      49.148 -19.946   7.999  1.00  0.00           O  
ATOM    463  H   TYR A  66      47.439 -19.489  14.435  1.00  0.00           H  
ATOM    464  HA  TYR A  66      49.907 -20.853  13.944  1.00  0.00           H  
ATOM    465  HB2 TYR A  66      48.987 -18.005  13.768  1.00  0.00           H  
ATOM    466  HB3 TYR A  66      50.705 -18.375  13.673  1.00  0.00           H  
ATOM    467  HD1 TYR A  66      51.311 -20.297  11.948  1.00  0.00           H  
ATOM    468  HD2 TYR A  66      47.775 -17.935  11.803  1.00  0.00           H  
ATOM    469  HE1 TYR A  66      51.071 -20.812   9.555  1.00  0.00           H  
ATOM    470  HE2 TYR A  66      47.525 -18.444   9.411  1.00  0.00           H  
ATOM    471  HH  TYR A  66      50.013 -19.952   7.584  1.00  0.00           H  
ATOM    472  N   ASN A  67      50.420 -20.849  16.493  1.00  0.00           N  
ATOM    473  CA  ASN A  67      51.100 -20.781  17.782  1.00  0.00           C  
ATOM    474  C   ASN A  67      51.922 -22.041  18.030  1.00  0.00           C  
ATOM    475  O   ASN A  67      51.376 -23.096  18.358  1.00  0.00           O  
ATOM    476  CB  ASN A  67      50.081 -20.593  18.909  1.00  0.00           C  
ATOM    477  CG  ASN A  67      48.919 -21.561  18.806  1.00  0.00           C  
ATOM    478  OD1 ASN A  67      48.935 -22.635  19.406  1.00  0.00           O  
ATOM    479  ND2 ASN A  67      47.901 -21.183  18.040  1.00  0.00           N  
ATOM    480  H   ASN A  67      50.103 -21.716  16.165  1.00  0.00           H  
ATOM    481  HA  ASN A  67      51.763 -19.930  17.763  1.00  0.00           H  
ATOM    482  HB2 ASN A  67      50.572 -20.749  19.859  1.00  0.00           H  
ATOM    483  HB3 ASN A  67      49.692 -19.586  18.871  1.00  0.00           H  
ATOM    484 HD21 ASN A  67      47.955 -20.314  17.592  1.00  0.00           H  
ATOM    485 HD22 ASN A  67      47.136 -21.789  17.956  1.00  0.00           H  
ATOM    486  N   CYS A  68      53.236 -21.924  17.873  1.00  0.00           N  
ATOM    487  CA  CYS A  68      54.134 -23.054  18.080  1.00  0.00           C  
ATOM    488  C   CYS A  68      55.329 -22.650  18.936  1.00  0.00           C  
ATOM    489  O   CYS A  68      55.918 -21.585  18.738  1.00  0.00           O  
ATOM    490  CB  CYS A  68      54.616 -23.602  16.735  1.00  0.00           C  
ATOM    491  SG  CYS A  68      55.100 -22.326  15.549  1.00  0.00           S  
ATOM    492  H   CYS A  68      53.611 -21.058  17.611  1.00  0.00           H  
ATOM    493  HA  CYS A  68      53.583 -23.826  18.596  1.00  0.00           H  
ATOM    494  HB2 CYS A  68      55.474 -24.237  16.901  1.00  0.00           H  
ATOM    495  HB3 CYS A  68      53.825 -24.186  16.289  1.00  0.00           H  
ATOM    496  HG  CYS A  68      55.244 -21.188  16.210  1.00  0.00           H  
ATOM    497  N   THR A  69      55.683 -23.504  19.891  1.00  0.00           N  
ATOM    498  CA  THR A  69      56.807 -23.233  20.781  1.00  0.00           C  
ATOM    499  C   THR A  69      58.047 -24.008  20.349  1.00  0.00           C  
ATOM    500  O   THR A  69      57.969 -25.192  20.018  1.00  0.00           O  
ATOM    501  CB  THR A  69      56.468 -23.597  22.238  1.00  0.00           C  
ATOM    502  OG1 THR A  69      55.376 -22.796  22.703  1.00  0.00           O  
ATOM    503  CG2 THR A  69      57.676 -23.391  23.141  1.00  0.00           C  
ATOM    504  H   THR A  69      55.176 -24.334  20.000  1.00  0.00           H  
ATOM    505  HA  THR A  69      57.021 -22.176  20.735  1.00  0.00           H  
ATOM    506  HB  THR A  69      56.183 -24.639  22.277  1.00  0.00           H  
ATOM    507  HG1 THR A  69      55.658 -21.881  22.771  1.00  0.00           H  
ATOM    508 HG21 THR A  69      58.516 -23.063  22.548  1.00  0.00           H  
ATOM    509 HG22 THR A  69      57.923 -24.322  23.630  1.00  0.00           H  
ATOM    510 HG23 THR A  69      57.445 -22.643  23.884  1.00  0.00           H  
ATOM    511  N   LEU A  70      59.191 -23.334  20.357  1.00  0.00           N  
ATOM    512  CA  LEU A  70      60.451 -23.959  19.968  1.00  0.00           C  
ATOM    513  C   LEU A  70      61.454 -23.924  21.116  1.00  0.00           C  
ATOM    514  O   LEU A  70      61.528 -22.948  21.859  1.00  0.00           O  
ATOM    515  CB  LEU A  70      61.036 -23.254  18.743  1.00  0.00           C  
ATOM    516  CG  LEU A  70      60.067 -23.000  17.587  1.00  0.00           C  
ATOM    517  CD1 LEU A  70      60.797 -22.381  16.406  1.00  0.00           C  
ATOM    518  CD2 LEU A  70      59.379 -24.294  17.174  1.00  0.00           C  
ATOM    519  H   LEU A  70      59.191 -22.394  20.631  1.00  0.00           H  
ATOM    520  HA  LEU A  70      60.245 -24.989  19.716  1.00  0.00           H  
ATOM    521  HB2 LEU A  70      61.423 -22.299  19.065  1.00  0.00           H  
ATOM    522  HB3 LEU A  70      61.847 -23.861  18.368  1.00  0.00           H  
ATOM    523  HG  LEU A  70      59.305 -22.304  17.911  1.00  0.00           H  
ATOM    524 HD11 LEU A  70      61.464 -21.609  16.759  1.00  0.00           H  
ATOM    525 HD12 LEU A  70      60.078 -21.950  15.724  1.00  0.00           H  
ATOM    526 HD13 LEU A  70      61.365 -23.143  15.894  1.00  0.00           H  
ATOM    527 HD21 LEU A  70      58.313 -24.193  17.310  1.00  0.00           H  
ATOM    528 HD22 LEU A  70      59.746 -25.106  17.784  1.00  0.00           H  
ATOM    529 HD23 LEU A  70      59.593 -24.497  16.135  1.00  0.00           H  
ATOM    530  N   ASN A  71      62.225 -24.998  21.253  1.00  0.00           N  
ATOM    531  CA  ASN A  71      63.225 -25.091  22.310  1.00  0.00           C  
ATOM    532  C   ASN A  71      64.626 -25.236  21.723  1.00  0.00           C  
ATOM    533  O   ASN A  71      64.786 -25.623  20.566  1.00  0.00           O  
ATOM    534  CB  ASN A  71      62.920 -26.276  23.229  1.00  0.00           C  
ATOM    535  CG  ASN A  71      62.048 -25.884  24.407  1.00  0.00           C  
ATOM    536  OD1 ASN A  71      60.991 -26.473  24.634  1.00  0.00           O  
ATOM    537  ND2 ASN A  71      62.488 -24.885  25.163  1.00  0.00           N  
ATOM    538  H   ASN A  71      62.119 -25.747  20.630  1.00  0.00           H  
ATOM    539  HA  ASN A  71      63.182 -24.179  22.887  1.00  0.00           H  
ATOM    540  HB2 ASN A  71      62.405 -27.039  22.663  1.00  0.00           H  
ATOM    541  HB3 ASN A  71      63.846 -26.678  23.609  1.00  0.00           H  
ATOM    542 HD21 ASN A  71      63.338 -24.462  24.921  1.00  0.00           H  
ATOM    543 HD22 ASN A  71      61.944 -24.612  25.931  1.00  0.00           H  
ATOM    544  N   GLN A  72      65.635 -24.925  22.529  1.00  0.00           N  
ATOM    545  CA  GLN A  72      67.022 -25.022  22.089  1.00  0.00           C  
ATOM    546  C   GLN A  72      67.954 -25.259  23.273  1.00  0.00           C  
ATOM    547  O   GLN A  72      68.192 -24.359  24.079  1.00  0.00           O  
ATOM    548  CB  GLN A  72      67.433 -23.749  21.347  1.00  0.00           C  
ATOM    549  CG  GLN A  72      68.865 -23.778  20.838  1.00  0.00           C  
ATOM    550  CD  GLN A  72      69.308 -22.445  20.266  1.00  0.00           C  
ATOM    551  OE1 GLN A  72      69.355 -21.438  20.973  1.00  0.00           O  
ATOM    552  NE2 GLN A  72      69.636 -22.432  18.980  1.00  0.00           N  
ATOM    553  H   GLN A  72      65.444 -24.623  23.441  1.00  0.00           H  
ATOM    554  HA  GLN A  72      67.098 -25.861  21.414  1.00  0.00           H  
ATOM    555  HB2 GLN A  72      66.776 -23.610  20.503  1.00  0.00           H  
ATOM    556  HB3 GLN A  72      67.330 -22.907  22.017  1.00  0.00           H  
ATOM    557  HG2 GLN A  72      69.521 -24.036  21.656  1.00  0.00           H  
ATOM    558  HG3 GLN A  72      68.943 -24.528  20.065  1.00  0.00           H  
ATOM    559 HE21 GLN A  72      69.572 -23.271  18.477  1.00  0.00           H  
ATOM    560 HE22 GLN A  72      69.925 -21.584  18.584  1.00  0.00           H  
ATOM    561  N   THR A  73      68.479 -26.476  23.372  1.00  0.00           N  
ATOM    562  CA  THR A  73      69.383 -26.833  24.458  1.00  0.00           C  
ATOM    563  C   THR A  73      70.805 -27.035  23.945  1.00  0.00           C  
ATOM    564  O   THR A  73      71.011 -27.434  22.800  1.00  0.00           O  
ATOM    565  CB  THR A  73      68.921 -28.114  25.176  1.00  0.00           C  
ATOM    566  OG1 THR A  73      68.417 -29.056  24.222  1.00  0.00           O  
ATOM    567  CG2 THR A  73      67.845 -27.800  26.204  1.00  0.00           C  
ATOM    568  H   THR A  73      68.251 -27.150  22.698  1.00  0.00           H  
ATOM    569  HA  THR A  73      69.381 -26.023  25.173  1.00  0.00           H  
ATOM    570  HB  THR A  73      69.769 -28.549  25.685  1.00  0.00           H  
ATOM    571  HG1 THR A  73      67.473 -28.920  24.107  1.00  0.00           H  
ATOM    572 HG21 THR A  73      66.945 -27.485  25.698  1.00  0.00           H  
ATOM    573 HG22 THR A  73      68.188 -27.008  26.854  1.00  0.00           H  
ATOM    574 HG23 THR A  73      67.638 -28.683  26.791  1.00  0.00           H  
ATOM    575  N   ASN A  74      71.783 -26.759  24.801  1.00  0.00           N  
ATOM    576  CA  ASN A  74      73.186 -26.912  24.434  1.00  0.00           C  
ATOM    577  C   ASN A  74      74.018 -27.352  25.636  1.00  0.00           C  
ATOM    578  O   ASN A  74      73.781 -26.913  26.761  1.00  0.00           O  
ATOM    579  CB  ASN A  74      73.734 -25.596  23.875  1.00  0.00           C  
ATOM    580  CG  ASN A  74      73.547 -25.485  22.375  1.00  0.00           C  
ATOM    581  OD1 ASN A  74      72.435 -25.613  21.864  1.00  0.00           O  
ATOM    582  ND2 ASN A  74      74.640 -25.245  21.659  1.00  0.00           N  
ATOM    583  H   ASN A  74      71.556 -26.445  25.701  1.00  0.00           H  
ATOM    584  HA  ASN A  74      73.247 -27.671  23.670  1.00  0.00           H  
ATOM    585  HB2 ASN A  74      73.220 -24.771  24.345  1.00  0.00           H  
ATOM    586  HB3 ASN A  74      74.788 -25.531  24.094  1.00  0.00           H  
ATOM    587 HD21 ASN A  74      75.493 -25.154  22.132  1.00  0.00           H  
ATOM    588 HD22 ASN A  74      74.548 -25.167  20.687  1.00  0.00           H  
ATOM    589  N   ILE A  75      74.992 -28.221  25.386  1.00  0.00           N  
ATOM    590  CA  ILE A  75      75.858 -28.719  26.447  1.00  0.00           C  
ATOM    591  C   ILE A  75      76.885 -27.669  26.857  1.00  0.00           C  
ATOM    592  O   ILE A  75      78.084 -27.943  26.902  1.00  0.00           O  
ATOM    593  CB  ILE A  75      76.597 -30.000  26.015  1.00  0.00           C  
ATOM    594  CG1 ILE A  75      77.288 -30.648  27.217  1.00  0.00           C  
ATOM    595  CG2 ILE A  75      77.608 -29.686  24.921  1.00  0.00           C  
ATOM    596  CD1 ILE A  75      77.491 -32.138  27.067  1.00  0.00           C  
ATOM    597  H   ILE A  75      75.130 -28.534  24.469  1.00  0.00           H  
ATOM    598  HA  ILE A  75      75.240 -28.955  27.300  1.00  0.00           H  
ATOM    599  HB  ILE A  75      75.871 -30.689  25.612  1.00  0.00           H  
ATOM    600 HG12 ILE A  75      78.257 -30.193  27.353  1.00  0.00           H  
ATOM    601 HG13 ILE A  75      76.688 -30.479  28.100  1.00  0.00           H  
ATOM    602 HG21 ILE A  75      77.255 -30.084  23.980  1.00  0.00           H  
ATOM    603 HG22 ILE A  75      77.725 -28.617  24.837  1.00  0.00           H  
ATOM    604 HG23 ILE A  75      78.557 -30.135  25.169  1.00  0.00           H  
ATOM    605 HD11 ILE A  75      76.993 -32.481  26.171  1.00  0.00           H  
ATOM    606 HD12 ILE A  75      78.546 -32.353  26.995  1.00  0.00           H  
ATOM    607 HD13 ILE A  75      77.075 -32.647  27.924  1.00  0.00           H  
ATOM    608  N   GLU A  76      76.405 -26.466  27.157  1.00  0.00           N  
ATOM    609  CA  GLU A  76      77.282 -25.375  27.564  1.00  0.00           C  
ATOM    610  C   GLU A  76      76.727 -24.662  28.794  1.00  0.00           C  
ATOM    611  O   GLU A  76      75.736 -23.938  28.711  1.00  0.00           O  
ATOM    612  CB  GLU A  76      77.456 -24.376  26.419  1.00  0.00           C  
ATOM    613  CG  GLU A  76      78.338 -24.888  25.293  1.00  0.00           C  
ATOM    614  CD  GLU A  76      78.678 -23.812  24.281  1.00  0.00           C  
ATOM    615  OE1 GLU A  76      77.760 -23.362  23.564  1.00  0.00           O  
ATOM    616  OE2 GLU A  76      79.861 -23.418  24.207  1.00  0.00           O  
ATOM    617  H   GLU A  76      75.440 -26.309  27.102  1.00  0.00           H  
ATOM    618  HA  GLU A  76      78.244 -25.797  27.811  1.00  0.00           H  
ATOM    619  HB2 GLU A  76      76.484 -24.142  26.008  1.00  0.00           H  
ATOM    620  HB3 GLU A  76      77.898 -23.471  26.810  1.00  0.00           H  
ATOM    621  HG2 GLU A  76      79.257 -25.265  25.716  1.00  0.00           H  
ATOM    622  HG3 GLU A  76      77.822 -25.689  24.784  1.00  0.00           H  
ATOM    623  N   ASN A  77      77.374 -24.874  29.936  1.00  0.00           N  
ATOM    624  CA  ASN A  77      76.945 -24.253  31.184  1.00  0.00           C  
ATOM    625  C   ASN A  77      75.426 -24.291  31.317  1.00  0.00           C  
ATOM    626  O   ASN A  77      74.807 -23.323  31.756  1.00  0.00           O  
ATOM    627  CB  ASN A  77      77.440 -22.808  31.255  1.00  0.00           C  
ATOM    628  CG  ASN A  77      78.870 -22.709  31.747  1.00  0.00           C  
ATOM    629  OD1 ASN A  77      79.119 -22.338  32.895  1.00  0.00           O  
ATOM    630  ND2 ASN A  77      79.819 -23.039  30.879  1.00  0.00           N  
ATOM    631  H   ASN A  77      78.158 -25.463  29.939  1.00  0.00           H  
ATOM    632  HA  ASN A  77      77.381 -24.814  31.998  1.00  0.00           H  
ATOM    633  HB2 ASN A  77      77.388 -22.367  30.270  1.00  0.00           H  
ATOM    634  HB3 ASN A  77      76.807 -22.249  31.928  1.00  0.00           H  
ATOM    635 HD21 ASN A  77      79.547 -23.326  29.983  1.00  0.00           H  
ATOM    636 HD22 ASN A  77      80.753 -22.985  31.172  1.00  0.00           H  
ATOM    637  N   ASN A  78      74.831 -25.417  30.934  1.00  0.00           N  
ATOM    638  CA  ASN A  78      73.384 -25.581  31.010  1.00  0.00           C  
ATOM    639  C   ASN A  78      72.668 -24.361  30.438  1.00  0.00           C  
ATOM    640  O   ASN A  78      71.831 -23.753  31.103  1.00  0.00           O  
ATOM    641  CB  ASN A  78      72.952 -25.808  32.460  1.00  0.00           C  
ATOM    642  CG  ASN A  78      71.653 -26.584  32.561  1.00  0.00           C  
ATOM    643  OD1 ASN A  78      70.798 -26.503  31.679  1.00  0.00           O  
ATOM    644  ND2 ASN A  78      71.500 -27.343  33.641  1.00  0.00           N  
ATOM    645  H   ASN A  78      75.379 -26.154  30.591  1.00  0.00           H  
ATOM    646  HA  ASN A  78      73.118 -26.448  30.425  1.00  0.00           H  
ATOM    647  HB2 ASN A  78      73.722 -26.363  32.976  1.00  0.00           H  
ATOM    648  HB3 ASN A  78      72.817 -24.852  32.943  1.00  0.00           H  
ATOM    649 HD21 ASN A  78      72.223 -27.359  34.301  1.00  0.00           H  
ATOM    650 HD22 ASN A  78      70.670 -27.857  33.730  1.00  0.00           H  
ATOM    651  N   ASN A  79      73.003 -24.011  29.202  1.00  0.00           N  
ATOM    652  CA  ASN A  79      72.392 -22.864  28.540  1.00  0.00           C  
ATOM    653  C   ASN A  79      71.265 -23.307  27.612  1.00  0.00           C  
ATOM    654  O   ASN A  79      71.487 -24.066  26.669  1.00  0.00           O  
ATOM    655  CB  ASN A  79      73.444 -22.085  27.747  1.00  0.00           C  
ATOM    656  CG  ASN A  79      74.100 -20.995  28.572  1.00  0.00           C  
ATOM    657  OD1 ASN A  79      74.133 -21.066  29.801  1.00  0.00           O  
ATOM    658  ND2 ASN A  79      74.627 -19.979  27.899  1.00  0.00           N  
ATOM    659  H   ASN A  79      73.678 -24.535  28.722  1.00  0.00           H  
ATOM    660  HA  ASN A  79      71.981 -22.220  29.304  1.00  0.00           H  
ATOM    661  HB2 ASN A  79      74.212 -22.768  27.412  1.00  0.00           H  
ATOM    662  HB3 ASN A  79      72.975 -21.628  26.889  1.00  0.00           H  
ATOM    663 HD21 ASN A  79      74.564 -19.990  26.920  1.00  0.00           H  
ATOM    664 HD22 ASN A  79      75.058 -19.261  28.407  1.00  0.00           H  
ATOM    665  N   ASN A  80      70.056 -22.828  27.887  1.00  0.00           N  
ATOM    666  CA  ASN A  80      68.895 -23.176  27.076  1.00  0.00           C  
ATOM    667  C   ASN A  80      68.109 -21.927  26.688  1.00  0.00           C  
ATOM    668  O   ASN A  80      68.027 -20.968  27.457  1.00  0.00           O  
ATOM    669  CB  ASN A  80      67.989 -24.147  27.837  1.00  0.00           C  
ATOM    670  CG  ASN A  80      68.068 -23.956  29.338  1.00  0.00           C  
ATOM    671  OD1 ASN A  80      68.036 -22.829  29.834  1.00  0.00           O  
ATOM    672  ND2 ASN A  80      68.172 -25.059  30.070  1.00  0.00           N  
ATOM    673  H   ASN A  80      69.942 -22.227  28.653  1.00  0.00           H  
ATOM    674  HA  ASN A  80      69.249 -23.657  26.177  1.00  0.00           H  
ATOM    675  HB2 ASN A  80      66.965 -23.992  27.527  1.00  0.00           H  
ATOM    676  HB3 ASN A  80      68.282 -25.160  27.604  1.00  0.00           H  
ATOM    677 HD21 ASN A  80      68.191 -25.922  29.607  1.00  0.00           H  
ATOM    678 HD22 ASN A  80      68.224 -24.965  31.045  1.00  0.00           H  
ATOM    679  N   LYS A  81      67.531 -21.946  25.492  1.00  0.00           N  
ATOM    680  CA  LYS A  81      66.749 -20.817  25.002  1.00  0.00           C  
ATOM    681  C   LYS A  81      65.416 -21.286  24.429  1.00  0.00           C  
ATOM    682  O   LYS A  81      65.267 -22.448  24.048  1.00  0.00           O  
ATOM    683  CB  LYS A  81      67.534 -20.052  23.934  1.00  0.00           C  
ATOM    684  CG  LYS A  81      68.851 -19.484  24.438  1.00  0.00           C  
ATOM    685  CD  LYS A  81      69.732 -19.020  23.291  1.00  0.00           C  
ATOM    686  CE  LYS A  81      71.200 -18.998  23.690  1.00  0.00           C  
ATOM    687  NZ  LYS A  81      71.576 -17.717  24.350  1.00  0.00           N  
ATOM    688  H   LYS A  81      67.632 -22.739  24.925  1.00  0.00           H  
ATOM    689  HA  LYS A  81      66.557 -20.159  25.836  1.00  0.00           H  
ATOM    690  HB2 LYS A  81      67.745 -20.720  23.112  1.00  0.00           H  
ATOM    691  HB3 LYS A  81      66.927 -19.233  23.576  1.00  0.00           H  
ATOM    692  HG2 LYS A  81      68.645 -18.642  25.083  1.00  0.00           H  
ATOM    693  HG3 LYS A  81      69.372 -20.248  24.995  1.00  0.00           H  
ATOM    694  HD2 LYS A  81      69.609 -19.695  22.457  1.00  0.00           H  
ATOM    695  HD3 LYS A  81      69.433 -18.024  22.998  1.00  0.00           H  
ATOM    696  HE2 LYS A  81      71.386 -19.813  24.374  1.00  0.00           H  
ATOM    697  HE3 LYS A  81      71.803 -19.128  22.803  1.00  0.00           H  
ATOM    698  HZ1 LYS A  81      71.220 -17.699  25.327  1.00  0.00           H  
ATOM    699  HZ2 LYS A  81      71.169 -16.914  23.829  1.00  0.00           H  
ATOM    700  HZ3 LYS A  81      72.611 -17.614  24.366  1.00  0.00           H  
ATOM    701  N   PHE A  82      64.450 -20.377  24.368  1.00  0.00           N  
ATOM    702  CA  PHE A  82      63.128 -20.698  23.840  1.00  0.00           C  
ATOM    703  C   PHE A  82      62.681 -19.653  22.822  1.00  0.00           C  
ATOM    704  O   PHE A  82      62.822 -18.451  23.046  1.00  0.00           O  
ATOM    705  CB  PHE A  82      62.109 -20.787  24.977  1.00  0.00           C  
ATOM    706  CG  PHE A  82      61.901 -19.485  25.699  1.00  0.00           C  
ATOM    707  CD1 PHE A  82      62.790 -19.072  26.678  1.00  0.00           C  
ATOM    708  CD2 PHE A  82      60.817 -18.678  25.398  1.00  0.00           C  
ATOM    709  CE1 PHE A  82      62.601 -17.875  27.344  1.00  0.00           C  
ATOM    710  CE2 PHE A  82      60.623 -17.480  26.060  1.00  0.00           C  
ATOM    711  CZ  PHE A  82      61.516 -17.079  27.035  1.00  0.00           C  
ATOM    712  H   PHE A  82      64.629 -19.467  24.688  1.00  0.00           H  
ATOM    713  HA  PHE A  82      63.193 -21.657  23.351  1.00  0.00           H  
ATOM    714  HB2 PHE A  82      61.157 -21.098  24.575  1.00  0.00           H  
ATOM    715  HB3 PHE A  82      62.447 -21.517  25.698  1.00  0.00           H  
ATOM    716  HD1 PHE A  82      63.639 -19.695  26.922  1.00  0.00           H  
ATOM    717  HD2 PHE A  82      60.117 -18.991  24.637  1.00  0.00           H  
ATOM    718  HE1 PHE A  82      63.301 -17.564  28.105  1.00  0.00           H  
ATOM    719  HE2 PHE A  82      59.774 -16.859  25.817  1.00  0.00           H  
ATOM    720  HZ  PHE A  82      61.367 -16.143  27.553  1.00  0.00           H  
ATOM    721  N   TYR A  83      62.142 -20.122  21.701  1.00  0.00           N  
ATOM    722  CA  TYR A  83      61.676 -19.229  20.646  1.00  0.00           C  
ATOM    723  C   TYR A  83      60.178 -19.396  20.414  1.00  0.00           C  
ATOM    724  O   TYR A  83      59.697 -20.502  20.162  1.00  0.00           O  
ATOM    725  CB  TYR A  83      62.439 -19.499  19.349  1.00  0.00           C  
ATOM    726  CG  TYR A  83      62.562 -18.286  18.455  1.00  0.00           C  
ATOM    727  CD1 TYR A  83      61.439 -17.702  17.884  1.00  0.00           C  
ATOM    728  CD2 TYR A  83      63.803 -17.722  18.184  1.00  0.00           C  
ATOM    729  CE1 TYR A  83      61.547 -16.594  17.066  1.00  0.00           C  
ATOM    730  CE2 TYR A  83      63.921 -16.613  17.369  1.00  0.00           C  
ATOM    731  CZ  TYR A  83      62.791 -16.053  16.812  1.00  0.00           C  
ATOM    732  OH  TYR A  83      62.903 -14.948  16.001  1.00  0.00           O  
ATOM    733  H   TYR A  83      62.056 -21.090  21.580  1.00  0.00           H  
ATOM    734  HA  TYR A  83      61.870 -18.215  20.961  1.00  0.00           H  
ATOM    735  HB2 TYR A  83      63.435 -19.838  19.588  1.00  0.00           H  
ATOM    736  HB3 TYR A  83      61.926 -20.271  18.792  1.00  0.00           H  
ATOM    737  HD1 TYR A  83      60.467 -18.129  18.084  1.00  0.00           H  
ATOM    738  HD2 TYR A  83      64.688 -18.164  18.622  1.00  0.00           H  
ATOM    739  HE1 TYR A  83      60.663 -16.155  16.631  1.00  0.00           H  
ATOM    740  HE2 TYR A  83      64.895 -16.189  17.170  1.00  0.00           H  
ATOM    741  HH  TYR A  83      63.810 -14.864  15.697  1.00  0.00           H  
ATOM    742  N   ILE A  84      59.446 -18.291  20.499  1.00  0.00           N  
ATOM    743  CA  ILE A  84      58.003 -18.314  20.296  1.00  0.00           C  
ATOM    744  C   ILE A  84      57.599 -17.433  19.118  1.00  0.00           C  
ATOM    745  O   ILE A  84      58.048 -16.292  19.001  1.00  0.00           O  
ATOM    746  CB  ILE A  84      57.249 -17.845  21.554  1.00  0.00           C  
ATOM    747  CG1 ILE A  84      57.594 -18.742  22.745  1.00  0.00           C  
ATOM    748  CG2 ILE A  84      55.749 -17.841  21.303  1.00  0.00           C  
ATOM    749  CD1 ILE A  84      57.109 -18.199  24.071  1.00  0.00           C  
ATOM    750  H   ILE A  84      59.887 -17.440  20.702  1.00  0.00           H  
ATOM    751  HA  ILE A  84      57.712 -19.333  20.085  1.00  0.00           H  
ATOM    752  HB  ILE A  84      57.556 -16.834  21.775  1.00  0.00           H  
ATOM    753 HG12 ILE A  84      57.142 -19.711  22.599  1.00  0.00           H  
ATOM    754 HG13 ILE A  84      58.666 -18.854  22.803  1.00  0.00           H  
ATOM    755 HG21 ILE A  84      55.555 -17.519  20.290  1.00  0.00           H  
ATOM    756 HG22 ILE A  84      55.358 -18.837  21.445  1.00  0.00           H  
ATOM    757 HG23 ILE A  84      55.270 -17.163  21.994  1.00  0.00           H  
ATOM    758 HD11 ILE A  84      57.872 -17.564  24.499  1.00  0.00           H  
ATOM    759 HD12 ILE A  84      56.208 -17.624  23.918  1.00  0.00           H  
ATOM    760 HD13 ILE A  84      56.905 -19.018  24.743  1.00  0.00           H  
ATOM    761  N   ILE A  85      56.748 -17.969  18.249  1.00  0.00           N  
ATOM    762  CA  ILE A  85      56.283 -17.230  17.082  1.00  0.00           C  
ATOM    763  C   ILE A  85      54.769 -17.345  16.927  1.00  0.00           C  
ATOM    764  O   ILE A  85      54.259 -18.370  16.473  1.00  0.00           O  
ATOM    765  CB  ILE A  85      56.959 -17.731  15.793  1.00  0.00           C  
ATOM    766  CG1 ILE A  85      58.478 -17.574  15.893  1.00  0.00           C  
ATOM    767  CG2 ILE A  85      56.422 -16.975  14.585  1.00  0.00           C  
ATOM    768  CD1 ILE A  85      59.240 -18.416  14.895  1.00  0.00           C  
ATOM    769  H   ILE A  85      56.427 -18.883  18.397  1.00  0.00           H  
ATOM    770  HA  ILE A  85      56.542 -16.191  17.222  1.00  0.00           H  
ATOM    771  HB  ILE A  85      56.720 -18.776  15.669  1.00  0.00           H  
ATOM    772 HG12 ILE A  85      58.739 -16.541  15.723  1.00  0.00           H  
ATOM    773 HG13 ILE A  85      58.796 -17.863  16.885  1.00  0.00           H  
ATOM    774 HG21 ILE A  85      56.426 -15.916  14.793  1.00  0.00           H  
ATOM    775 HG22 ILE A  85      57.048 -17.175  13.729  1.00  0.00           H  
ATOM    776 HG23 ILE A  85      55.413 -17.299  14.378  1.00  0.00           H  
ATOM    777 HD11 ILE A  85      60.258 -18.545  15.234  1.00  0.00           H  
ATOM    778 HD12 ILE A  85      58.768 -19.384  14.805  1.00  0.00           H  
ATOM    779 HD13 ILE A  85      59.241 -17.924  13.934  1.00  0.00           H  
ATOM    780  N   GLN A  86      54.060 -16.288  17.306  1.00  0.00           N  
ATOM    781  CA  GLN A  86      52.605 -16.271  17.207  1.00  0.00           C  
ATOM    782  C   GLN A  86      52.134 -15.135  16.304  1.00  0.00           C  
ATOM    783  O   GLN A  86      52.763 -14.078  16.238  1.00  0.00           O  
ATOM    784  CB  GLN A  86      51.980 -16.125  18.596  1.00  0.00           C  
ATOM    785  CG  GLN A  86      52.405 -17.213  19.570  1.00  0.00           C  
ATOM    786  CD  GLN A  86      51.928 -16.948  20.984  1.00  0.00           C  
ATOM    787  OE1 GLN A  86      52.710 -16.563  21.854  1.00  0.00           O  
ATOM    788  NE2 GLN A  86      50.637 -17.153  21.223  1.00  0.00           N  
ATOM    789  H   GLN A  86      54.524 -15.501  17.659  1.00  0.00           H  
ATOM    790  HA  GLN A  86      52.290 -17.209  16.777  1.00  0.00           H  
ATOM    791  HB2 GLN A  86      52.268 -15.171  19.009  1.00  0.00           H  
ATOM    792  HB3 GLN A  86      50.905 -16.159  18.499  1.00  0.00           H  
ATOM    793  HG2 GLN A  86      51.993 -18.155  19.240  1.00  0.00           H  
ATOM    794  HG3 GLN A  86      53.483 -17.273  19.574  1.00  0.00           H  
ATOM    795 HE21 GLN A  86      50.074 -17.461  20.482  1.00  0.00           H  
ATOM    796 HE22 GLN A  86      50.303 -16.990  22.128  1.00  0.00           H  
ATOM    797  N   LEU A  87      51.024 -15.360  15.609  1.00  0.00           N  
ATOM    798  CA  LEU A  87      50.470 -14.356  14.708  1.00  0.00           C  
ATOM    799  C   LEU A  87      49.203 -13.739  15.295  1.00  0.00           C  
ATOM    800  O   LEU A  87      48.194 -14.420  15.477  1.00  0.00           O  
ATOM    801  CB  LEU A  87      50.161 -14.979  13.345  1.00  0.00           C  
ATOM    802  CG  LEU A  87      50.268 -14.044  12.140  1.00  0.00           C  
ATOM    803  CD1 LEU A  87      50.673 -14.819  10.897  1.00  0.00           C  
ATOM    804  CD2 LEU A  87      48.951 -13.316  11.912  1.00  0.00           C  
ATOM    805  H   LEU A  87      50.568 -16.222  15.702  1.00  0.00           H  
ATOM    806  HA  LEU A  87      51.209 -13.579  14.581  1.00  0.00           H  
ATOM    807  HB2 LEU A  87      50.850 -15.795  13.192  1.00  0.00           H  
ATOM    808  HB3 LEU A  87      49.152 -15.363  13.379  1.00  0.00           H  
ATOM    809  HG  LEU A  87      51.031 -13.302  12.334  1.00  0.00           H  
ATOM    810 HD11 LEU A  87      51.744 -14.956  10.891  1.00  0.00           H  
ATOM    811 HD12 LEU A  87      50.377 -14.269  10.017  1.00  0.00           H  
ATOM    812 HD13 LEU A  87      50.187 -15.784  10.900  1.00  0.00           H  
ATOM    813 HD21 LEU A  87      48.743 -12.674  12.754  1.00  0.00           H  
ATOM    814 HD22 LEU A  87      48.155 -14.039  11.804  1.00  0.00           H  
ATOM    815 HD23 LEU A  87      49.020 -12.721  11.013  1.00  0.00           H  
ATOM    816  N   LEU A  88      49.265 -12.444  15.589  1.00  0.00           N  
ATOM    817  CA  LEU A  88      48.123 -11.733  16.153  1.00  0.00           C  
ATOM    818  C   LEU A  88      47.430 -10.886  15.092  1.00  0.00           C  
ATOM    819  O   LEU A  88      47.997 -10.614  14.034  1.00  0.00           O  
ATOM    820  CB  LEU A  88      48.573 -10.847  17.317  1.00  0.00           C  
ATOM    821  CG  LEU A  88      49.466 -11.515  18.363  1.00  0.00           C  
ATOM    822  CD1 LEU A  88      50.023 -10.481  19.328  1.00  0.00           C  
ATOM    823  CD2 LEU A  88      48.694 -12.589  19.116  1.00  0.00           C  
ATOM    824  H   LEU A  88      50.096 -11.955  15.423  1.00  0.00           H  
ATOM    825  HA  LEU A  88      47.424 -12.470  16.522  1.00  0.00           H  
ATOM    826  HB2 LEU A  88      49.116 -10.011  16.904  1.00  0.00           H  
ATOM    827  HB3 LEU A  88      47.686 -10.487  17.818  1.00  0.00           H  
ATOM    828  HG  LEU A  88      50.301 -11.990  17.865  1.00  0.00           H  
ATOM    829 HD11 LEU A  88      50.336 -10.969  20.238  1.00  0.00           H  
ATOM    830 HD12 LEU A  88      49.259  -9.752  19.555  1.00  0.00           H  
ATOM    831 HD13 LEU A  88      50.869  -9.986  18.876  1.00  0.00           H  
ATOM    832 HD21 LEU A  88      48.283 -12.169  20.021  1.00  0.00           H  
ATOM    833 HD22 LEU A  88      49.360 -13.401  19.366  1.00  0.00           H  
ATOM    834 HD23 LEU A  88      47.893 -12.960  18.493  1.00  0.00           H  
ATOM    835  N   GLN A  89      46.203 -10.469  15.383  1.00  0.00           N  
ATOM    836  CA  GLN A  89      45.434  -9.650  14.453  1.00  0.00           C  
ATOM    837  C   GLN A  89      44.528  -8.680  15.204  1.00  0.00           C  
ATOM    838  O   GLN A  89      43.736  -9.085  16.055  1.00  0.00           O  
ATOM    839  CB  GLN A  89      44.596 -10.538  13.531  1.00  0.00           C  
ATOM    840  CG  GLN A  89      43.677  -9.758  12.605  1.00  0.00           C  
ATOM    841  CD  GLN A  89      42.619 -10.631  11.961  1.00  0.00           C  
ATOM    842  OE1 GLN A  89      42.281 -11.698  12.474  1.00  0.00           O  
ATOM    843  NE2 GLN A  89      42.089 -10.183  10.829  1.00  0.00           N  
ATOM    844  H   GLN A  89      45.804 -10.718  16.242  1.00  0.00           H  
ATOM    845  HA  GLN A  89      46.131  -9.083  13.855  1.00  0.00           H  
ATOM    846  HB2 GLN A  89      45.261 -11.135  12.924  1.00  0.00           H  
ATOM    847  HB3 GLN A  89      43.989 -11.194  14.137  1.00  0.00           H  
ATOM    848  HG2 GLN A  89      43.183  -8.985  13.176  1.00  0.00           H  
ATOM    849  HG3 GLN A  89      44.272  -9.304  11.826  1.00  0.00           H  
ATOM    850 HE21 GLN A  89      42.408  -9.325  10.478  1.00  0.00           H  
ATOM    851 HE22 GLN A  89      41.404 -10.728  10.390  1.00  0.00           H  
ATOM    852  N   ASP A  90      44.649  -7.396  14.882  1.00  0.00           N  
ATOM    853  CA  ASP A  90      43.840  -6.367  15.526  1.00  0.00           C  
ATOM    854  C   ASP A  90      42.600  -6.052  14.695  1.00  0.00           C  
ATOM    855  O   ASP A  90      42.485  -6.480  13.547  1.00  0.00           O  
ATOM    856  CB  ASP A  90      44.666  -5.097  15.735  1.00  0.00           C  
ATOM    857  CG  ASP A  90      45.323  -4.617  14.456  1.00  0.00           C  
ATOM    858  OD1 ASP A  90      44.607  -4.445  13.448  1.00  0.00           O  
ATOM    859  OD2 ASP A  90      46.556  -4.412  14.464  1.00  0.00           O  
ATOM    860  H   ASP A  90      45.297  -7.135  14.196  1.00  0.00           H  
ATOM    861  HA  ASP A  90      43.528  -6.744  16.488  1.00  0.00           H  
ATOM    862  HB2 ASP A  90      44.021  -4.311  16.101  1.00  0.00           H  
ATOM    863  HB3 ASP A  90      45.437  -5.292  16.464  1.00  0.00           H  
ATOM    864  N   SER A  91      41.675  -5.302  15.284  1.00  0.00           N  
ATOM    865  CA  SER A  91      40.441  -4.933  14.601  1.00  0.00           C  
ATOM    866  C   SER A  91      40.710  -3.896  13.515  1.00  0.00           C  
ATOM    867  O   SER A  91      39.798  -3.474  12.805  1.00  0.00           O  
ATOM    868  CB  SER A  91      39.421  -4.387  15.603  1.00  0.00           C  
ATOM    869  OG  SER A  91      38.140  -4.262  15.009  1.00  0.00           O  
ATOM    870  H   SER A  91      41.825  -4.990  16.202  1.00  0.00           H  
ATOM    871  HA  SER A  91      40.038  -5.823  14.140  1.00  0.00           H  
ATOM    872  HB2 SER A  91      39.351  -5.060  16.444  1.00  0.00           H  
ATOM    873  HB3 SER A  91      39.743  -3.415  15.945  1.00  0.00           H  
ATOM    874  HG  SER A  91      37.535  -3.861  15.637  1.00  0.00           H  
ATOM    875  N   ASN A  92      41.969  -3.489  13.394  1.00  0.00           N  
ATOM    876  CA  ASN A  92      42.360  -2.500  12.395  1.00  0.00           C  
ATOM    877  C   ASN A  92      42.981  -3.174  11.176  1.00  0.00           C  
ATOM    878  O   ASN A  92      43.926  -2.655  10.580  1.00  0.00           O  
ATOM    879  CB  ASN A  92      43.348  -1.499  12.997  1.00  0.00           C  
ATOM    880  CG  ASN A  92      42.651  -0.345  13.692  1.00  0.00           C  
ATOM    881  OD1 ASN A  92      41.833  -0.548  14.589  1.00  0.00           O  
ATOM    882  ND2 ASN A  92      42.972   0.875  13.277  1.00  0.00           N  
ATOM    883  H   ASN A  92      42.652  -3.861  13.989  1.00  0.00           H  
ATOM    884  HA  ASN A  92      41.470  -1.972  12.085  1.00  0.00           H  
ATOM    885  HB2 ASN A  92      43.968  -2.007  13.722  1.00  0.00           H  
ATOM    886  HB3 ASN A  92      43.971  -1.100  12.212  1.00  0.00           H  
ATOM    887 HD21 ASN A  92      43.631   0.962  12.557  1.00  0.00           H  
ATOM    888 HD22 ASN A  92      42.537   1.640  13.709  1.00  0.00           H  
ATOM    889  N   ARG A  93      42.445  -4.334  10.809  1.00  0.00           N  
ATOM    890  CA  ARG A  93      42.947  -5.079   9.662  1.00  0.00           C  
ATOM    891  C   ARG A  93      44.471  -5.036   9.610  1.00  0.00           C  
ATOM    892  O   ARG A  93      45.064  -4.910   8.538  1.00  0.00           O  
ATOM    893  CB  ARG A  93      42.366  -4.514   8.365  1.00  0.00           C  
ATOM    894  CG  ARG A  93      40.856  -4.349   8.395  1.00  0.00           C  
ATOM    895  CD  ARG A  93      40.401  -3.208   7.500  1.00  0.00           C  
ATOM    896  NE  ARG A  93      39.014  -2.828   7.757  1.00  0.00           N  
ATOM    897  CZ  ARG A  93      38.484  -1.674   7.369  1.00  0.00           C  
ATOM    898  NH1 ARG A  93      39.220  -0.791   6.708  1.00  0.00           N  
ATOM    899  NH2 ARG A  93      37.214  -1.400   7.640  1.00  0.00           N  
ATOM    900  H   ARG A  93      41.694  -4.697  11.324  1.00  0.00           H  
ATOM    901  HA  ARG A  93      42.632  -6.106   9.769  1.00  0.00           H  
ATOM    902  HB2 ARG A  93      42.807  -3.545   8.178  1.00  0.00           H  
ATOM    903  HB3 ARG A  93      42.618  -5.178   7.552  1.00  0.00           H  
ATOM    904  HG2 ARG A  93      40.396  -5.265   8.053  1.00  0.00           H  
ATOM    905  HG3 ARG A  93      40.545  -4.145   9.410  1.00  0.00           H  
ATOM    906  HD2 ARG A  93      41.037  -2.353   7.678  1.00  0.00           H  
ATOM    907  HD3 ARG A  93      40.495  -3.517   6.469  1.00  0.00           H  
ATOM    908  HE  ARG A  93      38.452  -3.466   8.244  1.00  0.00           H  
ATOM    909 HH11 ARG A  93      40.177  -0.994   6.501  1.00  0.00           H  
ATOM    910 HH12 ARG A  93      38.818   0.077   6.416  1.00  0.00           H  
ATOM    911 HH21 ARG A  93      36.656  -2.064   8.138  1.00  0.00           H  
ATOM    912 HH22 ARG A  93      36.816  -0.531   7.348  1.00  0.00           H  
ATOM    913  N   PHE A  94      45.101  -5.140  10.776  1.00  0.00           N  
ATOM    914  CA  PHE A  94      46.557  -5.110  10.864  1.00  0.00           C  
ATOM    915  C   PHE A  94      47.070  -6.236  11.758  1.00  0.00           C  
ATOM    916  O   PHE A  94      46.687  -6.342  12.923  1.00  0.00           O  
ATOM    917  CB  PHE A  94      47.029  -3.759  11.404  1.00  0.00           C  
ATOM    918  CG  PHE A  94      46.589  -2.592  10.567  1.00  0.00           C  
ATOM    919  CD1 PHE A  94      46.554  -2.688   9.186  1.00  0.00           C  
ATOM    920  CD2 PHE A  94      46.212  -1.399  11.163  1.00  0.00           C  
ATOM    921  CE1 PHE A  94      46.149  -1.616   8.412  1.00  0.00           C  
ATOM    922  CE2 PHE A  94      45.806  -0.324  10.394  1.00  0.00           C  
ATOM    923  CZ  PHE A  94      45.776  -0.432   9.018  1.00  0.00           C  
ATOM    924  H   PHE A  94      44.574  -5.238  11.596  1.00  0.00           H  
ATOM    925  HA  PHE A  94      46.950  -5.249   9.869  1.00  0.00           H  
ATOM    926  HB2 PHE A  94      46.635  -3.621  12.400  1.00  0.00           H  
ATOM    927  HB3 PHE A  94      48.108  -3.753  11.444  1.00  0.00           H  
ATOM    928  HD1 PHE A  94      46.846  -3.614   8.711  1.00  0.00           H  
ATOM    929  HD2 PHE A  94      46.236  -1.313  12.239  1.00  0.00           H  
ATOM    930  HE1 PHE A  94      46.127  -1.704   7.337  1.00  0.00           H  
ATOM    931  HE2 PHE A  94      45.515   0.601  10.871  1.00  0.00           H  
ATOM    932  HZ  PHE A  94      45.459   0.406   8.417  1.00  0.00           H  
ATOM    933  N   PHE A  95      47.939  -7.075  11.203  1.00  0.00           N  
ATOM    934  CA  PHE A  95      48.503  -8.193  11.947  1.00  0.00           C  
ATOM    935  C   PHE A  95      49.813  -7.793  12.620  1.00  0.00           C  
ATOM    936  O   PHE A  95      50.449  -6.811  12.235  1.00  0.00           O  
ATOM    937  CB  PHE A  95      48.739  -9.385  11.018  1.00  0.00           C  
ATOM    938  CG  PHE A  95      47.519  -9.792  10.244  1.00  0.00           C  
ATOM    939  CD1 PHE A  95      47.143  -9.103   9.102  1.00  0.00           C  
ATOM    940  CD2 PHE A  95      46.745 -10.865  10.658  1.00  0.00           C  
ATOM    941  CE1 PHE A  95      46.020  -9.474   8.388  1.00  0.00           C  
ATOM    942  CE2 PHE A  95      45.622 -11.243   9.947  1.00  0.00           C  
ATOM    943  CZ  PHE A  95      45.257 -10.545   8.812  1.00  0.00           C  
ATOM    944  H   PHE A  95      48.205  -6.938  10.269  1.00  0.00           H  
ATOM    945  HA  PHE A  95      47.794  -8.476  12.709  1.00  0.00           H  
ATOM    946  HB2 PHE A  95      49.512  -9.132  10.308  1.00  0.00           H  
ATOM    947  HB3 PHE A  95      49.059 -10.233  11.605  1.00  0.00           H  
ATOM    948  HD1 PHE A  95      47.739  -8.264   8.770  1.00  0.00           H  
ATOM    949  HD2 PHE A  95      47.027 -11.411  11.546  1.00  0.00           H  
ATOM    950  HE1 PHE A  95      45.739  -8.928   7.500  1.00  0.00           H  
ATOM    951  HE2 PHE A  95      45.027 -12.080  10.281  1.00  0.00           H  
ATOM    952  HZ  PHE A  95      44.381 -10.839   8.254  1.00  0.00           H  
ATOM    953  N   THR A  96      50.211  -8.559  13.631  1.00  0.00           N  
ATOM    954  CA  THR A  96      51.444  -8.284  14.360  1.00  0.00           C  
ATOM    955  C   THR A  96      52.159  -9.577  14.737  1.00  0.00           C  
ATOM    956  O   THR A  96      51.596 -10.433  15.419  1.00  0.00           O  
ATOM    957  CB  THR A  96      51.169  -7.471  15.639  1.00  0.00           C  
ATOM    958  OG1 THR A  96      50.334  -6.348  15.335  1.00  0.00           O  
ATOM    959  CG2 THR A  96      52.471  -6.988  16.262  1.00  0.00           C  
ATOM    960  H   THR A  96      49.662  -9.328  13.892  1.00  0.00           H  
ATOM    961  HA  THR A  96      52.088  -7.701  13.718  1.00  0.00           H  
ATOM    962  HB  THR A  96      50.662  -8.106  16.350  1.00  0.00           H  
ATOM    963  HG1 THR A  96      50.159  -5.852  16.140  1.00  0.00           H  
ATOM    964 HG21 THR A  96      52.260  -6.495  17.200  1.00  0.00           H  
ATOM    965 HG22 THR A  96      52.955  -6.293  15.591  1.00  0.00           H  
ATOM    966 HG23 THR A  96      53.121  -7.832  16.436  1.00  0.00           H  
ATOM    967  N   CYS A  97      53.403  -9.710  14.290  1.00  0.00           N  
ATOM    968  CA  CYS A  97      54.196 -10.899  14.580  1.00  0.00           C  
ATOM    969  C   CYS A  97      54.899 -10.767  15.927  1.00  0.00           C  
ATOM    970  O   CYS A  97      55.870 -10.021  16.061  1.00  0.00           O  
ATOM    971  CB  CYS A  97      55.225 -11.134  13.474  1.00  0.00           C  
ATOM    972  SG  CYS A  97      54.542 -11.880  11.975  1.00  0.00           S  
ATOM    973  H   CYS A  97      53.797  -8.993  13.750  1.00  0.00           H  
ATOM    974  HA  CYS A  97      53.524 -11.743  14.620  1.00  0.00           H  
ATOM    975  HB2 CYS A  97      55.668 -10.187  13.198  1.00  0.00           H  
ATOM    976  HB3 CYS A  97      55.999 -11.790  13.845  1.00  0.00           H  
ATOM    977  HG  CYS A  97      55.335 -11.562  10.963  1.00  0.00           H  
ATOM    978  N   TRP A  98      54.404 -11.495  16.921  1.00  0.00           N  
ATOM    979  CA  TRP A  98      54.984 -11.457  18.258  1.00  0.00           C  
ATOM    980  C   TRP A  98      56.130 -12.455  18.383  1.00  0.00           C  
ATOM    981  O   TRP A  98      55.920 -13.666  18.329  1.00  0.00           O  
ATOM    982  CB  TRP A  98      53.914 -11.758  19.310  1.00  0.00           C  
ATOM    983  CG  TRP A  98      54.480 -12.069  20.661  1.00  0.00           C  
ATOM    984  CD1 TRP A  98      54.550 -13.296  21.259  1.00  0.00           C  
ATOM    985  CD2 TRP A  98      55.056 -11.138  21.586  1.00  0.00           C  
ATOM    986  NE1 TRP A  98      55.133 -13.183  22.498  1.00  0.00           N  
ATOM    987  CE2 TRP A  98      55.453 -11.870  22.721  1.00  0.00           C  
ATOM    988  CE3 TRP A  98      55.276  -9.758  21.562  1.00  0.00           C  
ATOM    989  CZ2 TRP A  98      56.056 -11.267  23.822  1.00  0.00           C  
ATOM    990  CZ3 TRP A  98      55.874  -9.161  22.655  1.00  0.00           C  
ATOM    991  CH2 TRP A  98      56.259  -9.914  23.772  1.00  0.00           C  
ATOM    992  H   TRP A  98      53.628 -12.070  16.753  1.00  0.00           H  
ATOM    993  HA  TRP A  98      55.369 -10.462  18.425  1.00  0.00           H  
ATOM    994  HB2 TRP A  98      53.265 -10.900  19.409  1.00  0.00           H  
ATOM    995  HB3 TRP A  98      53.332 -12.609  18.987  1.00  0.00           H  
ATOM    996  HD1 TRP A  98      54.192 -14.211  20.812  1.00  0.00           H  
ATOM    997  HE1 TRP A  98      55.294 -13.923  23.120  1.00  0.00           H  
ATOM    998  HE3 TRP A  98      54.986  -9.161  20.710  1.00  0.00           H  
ATOM    999  HZ2 TRP A  98      56.359 -11.834  24.690  1.00  0.00           H  
ATOM   1000  HZ3 TRP A  98      56.052  -8.095  22.655  1.00  0.00           H  
ATOM   1001  HH2 TRP A  98      56.723  -9.406  24.603  1.00  0.00           H  
ATOM   1002  N   ASN A  99      57.344 -11.938  18.550  1.00  0.00           N  
ATOM   1003  CA  ASN A  99      58.523 -12.786  18.681  1.00  0.00           C  
ATOM   1004  C   ASN A  99      59.198 -12.573  20.033  1.00  0.00           C  
ATOM   1005  O   ASN A  99      59.640 -11.468  20.350  1.00  0.00           O  
ATOM   1006  CB  ASN A  99      59.514 -12.495  17.552  1.00  0.00           C  
ATOM   1007  CG  ASN A  99      59.259 -13.348  16.325  1.00  0.00           C  
ATOM   1008  OD1 ASN A  99      60.160 -14.022  15.826  1.00  0.00           O  
ATOM   1009  ND2 ASN A  99      58.026 -13.321  15.832  1.00  0.00           N  
ATOM   1010  H   ASN A  99      57.447 -10.965  18.585  1.00  0.00           H  
ATOM   1011  HA  ASN A  99      58.202 -13.813  18.610  1.00  0.00           H  
ATOM   1012  HB2 ASN A  99      59.431 -11.456  17.267  1.00  0.00           H  
ATOM   1013  HB3 ASN A  99      60.516 -12.688  17.902  1.00  0.00           H  
ATOM   1014 HD21 ASN A  99      57.359 -12.761  16.281  1.00  0.00           H  
ATOM   1015 HD22 ASN A  99      57.834 -13.864  15.039  1.00  0.00           H  
ATOM   1016  N   ARG A 100      59.274 -13.637  20.824  1.00  0.00           N  
ATOM   1017  CA  ARG A 100      59.893 -13.567  22.142  1.00  0.00           C  
ATOM   1018  C   ARG A 100      60.977 -14.631  22.290  1.00  0.00           C  
ATOM   1019  O   ARG A 100      60.766 -15.797  21.954  1.00  0.00           O  
ATOM   1020  CB  ARG A 100      58.838 -13.742  23.235  1.00  0.00           C  
ATOM   1021  CG  ARG A 100      59.424 -13.853  24.634  1.00  0.00           C  
ATOM   1022  CD  ARG A 100      58.370 -14.274  25.647  1.00  0.00           C  
ATOM   1023  NE  ARG A 100      58.965 -14.887  26.832  1.00  0.00           N  
ATOM   1024  CZ  ARG A 100      58.268 -15.569  27.735  1.00  0.00           C  
ATOM   1025  NH1 ARG A 100      56.960 -15.725  27.587  1.00  0.00           N  
ATOM   1026  NH2 ARG A 100      58.881 -16.098  28.786  1.00  0.00           N  
ATOM   1027  H   ARG A 100      58.902 -14.490  20.516  1.00  0.00           H  
ATOM   1028  HA  ARG A 100      60.347 -12.592  22.244  1.00  0.00           H  
ATOM   1029  HB2 ARG A 100      58.171 -12.893  23.215  1.00  0.00           H  
ATOM   1030  HB3 ARG A 100      58.274 -14.639  23.034  1.00  0.00           H  
ATOM   1031  HG2 ARG A 100      60.214 -14.588  24.626  1.00  0.00           H  
ATOM   1032  HG3 ARG A 100      59.825 -12.893  24.923  1.00  0.00           H  
ATOM   1033  HD2 ARG A 100      57.810 -13.402  25.948  1.00  0.00           H  
ATOM   1034  HD3 ARG A 100      57.706 -14.985  25.180  1.00  0.00           H  
ATOM   1035  HE  ARG A 100      59.930 -14.784  26.960  1.00  0.00           H  
ATOM   1036 HH11 ARG A 100      56.496 -15.328  26.795  1.00  0.00           H  
ATOM   1037 HH12 ARG A 100      56.438 -16.239  28.267  1.00  0.00           H  
ATOM   1038 HH21 ARG A 100      59.866 -15.983  28.900  1.00  0.00           H  
ATOM   1039 HH22 ARG A 100      58.356 -16.611  29.464  1.00  0.00           H  
ATOM   1040  N   TRP A 101      62.134 -14.223  22.795  1.00  0.00           N  
ATOM   1041  CA  TRP A 101      63.252 -15.141  22.988  1.00  0.00           C  
ATOM   1042  C   TRP A 101      63.991 -14.835  24.285  1.00  0.00           C  
ATOM   1043  O   TRP A 101      63.710 -13.839  24.950  1.00  0.00           O  
ATOM   1044  CB  TRP A 101      64.217 -15.057  21.804  1.00  0.00           C  
ATOM   1045  CG  TRP A 101      64.923 -13.739  21.706  1.00  0.00           C  
ATOM   1046  CD1 TRP A 101      66.015 -13.338  22.423  1.00  0.00           C  
ATOM   1047  CD2 TRP A 101      64.585 -12.648  20.843  1.00  0.00           C  
ATOM   1048  NE1 TRP A 101      66.376 -12.064  22.056  1.00  0.00           N  
ATOM   1049  CE2 TRP A 101      65.515 -11.619  21.089  1.00  0.00           C  
ATOM   1050  CE3 TRP A 101      63.589 -12.441  19.885  1.00  0.00           C  
ATOM   1051  CZ2 TRP A 101      65.476 -10.403  20.411  1.00  0.00           C  
ATOM   1052  CZ3 TRP A 101      63.552 -11.234  19.213  1.00  0.00           C  
ATOM   1053  CH2 TRP A 101      64.490 -10.227  19.479  1.00  0.00           C  
ATOM   1054  H   TRP A 101      62.243 -13.281  23.045  1.00  0.00           H  
ATOM   1055  HA  TRP A 101      62.851 -16.142  23.043  1.00  0.00           H  
ATOM   1056  HB2 TRP A 101      64.965 -15.829  21.903  1.00  0.00           H  
ATOM   1057  HB3 TRP A 101      63.666 -15.210  20.888  1.00  0.00           H  
ATOM   1058  HD1 TRP A 101      66.510 -13.944  23.166  1.00  0.00           H  
ATOM   1059  HE1 TRP A 101      67.128 -11.558  22.428  1.00  0.00           H  
ATOM   1060  HE3 TRP A 101      62.857 -13.204  19.666  1.00  0.00           H  
ATOM   1061  HZ2 TRP A 101      66.192  -9.617  20.604  1.00  0.00           H  
ATOM   1062  HZ3 TRP A 101      62.789 -11.055  18.470  1.00  0.00           H  
ATOM   1063  HH2 TRP A 101      64.421  -9.300  18.930  1.00  0.00           H  
ATOM   1064  N   GLY A 102      64.937 -15.699  24.641  1.00  0.00           N  
ATOM   1065  CA  GLY A 102      65.702 -15.503  25.859  1.00  0.00           C  
ATOM   1066  C   GLY A 102      66.269 -16.799  26.402  1.00  0.00           C  
ATOM   1067  O   GLY A 102      66.770 -17.631  25.644  1.00  0.00           O  
ATOM   1068  H   GLY A 102      65.117 -16.477  24.072  1.00  0.00           H  
ATOM   1069  HA2 GLY A 102      66.515 -14.823  25.654  1.00  0.00           H  
ATOM   1070  HA3 GLY A 102      65.058 -15.065  26.607  1.00  0.00           H  
ATOM   1071  N   ARG A 103      66.194 -16.972  27.717  1.00  0.00           N  
ATOM   1072  CA  ARG A 103      66.708 -18.174  28.362  1.00  0.00           C  
ATOM   1073  C   ARG A 103      65.566 -19.032  28.900  1.00  0.00           C  
ATOM   1074  O   ARG A 103      64.700 -18.546  29.627  1.00  0.00           O  
ATOM   1075  CB  ARG A 103      67.660 -17.802  29.499  1.00  0.00           C  
ATOM   1076  CG  ARG A 103      69.114 -17.694  29.065  1.00  0.00           C  
ATOM   1077  CD  ARG A 103      70.054 -17.712  30.260  1.00  0.00           C  
ATOM   1078  NE  ARG A 103      71.417 -17.343  29.889  1.00  0.00           N  
ATOM   1079  CZ  ARG A 103      71.778 -16.112  29.542  1.00  0.00           C  
ATOM   1080  NH1 ARG A 103      70.880 -15.136  29.520  1.00  0.00           N  
ATOM   1081  NH2 ARG A 103      73.038 -15.855  29.216  1.00  0.00           N  
ATOM   1082  H   ARG A 103      65.784 -16.272  28.269  1.00  0.00           H  
ATOM   1083  HA  ARG A 103      67.250 -18.741  27.620  1.00  0.00           H  
ATOM   1084  HB2 ARG A 103      67.359 -16.849  29.908  1.00  0.00           H  
ATOM   1085  HB3 ARG A 103      67.593 -18.554  30.269  1.00  0.00           H  
ATOM   1086  HG2 ARG A 103      69.351 -18.530  28.423  1.00  0.00           H  
ATOM   1087  HG3 ARG A 103      69.251 -16.770  28.523  1.00  0.00           H  
ATOM   1088  HD2 ARG A 103      69.691 -17.012  30.997  1.00  0.00           H  
ATOM   1089  HD3 ARG A 103      70.062 -18.706  30.681  1.00  0.00           H  
ATOM   1090  HE  ARG A 103      72.097 -18.048  29.898  1.00  0.00           H  
ATOM   1091 HH11 ARG A 103      69.929 -15.328  29.765  1.00  0.00           H  
ATOM   1092 HH12 ARG A 103      71.153 -14.211  29.259  1.00  0.00           H  
ATOM   1093 HH21 ARG A 103      73.718 -16.587  29.233  1.00  0.00           H  
ATOM   1094 HH22 ARG A 103      73.308 -14.929  28.956  1.00  0.00           H  
ATOM   1095  N   VAL A 104      65.574 -20.311  28.538  1.00  0.00           N  
ATOM   1096  CA  VAL A 104      64.540 -21.237  28.985  1.00  0.00           C  
ATOM   1097  C   VAL A 104      64.335 -21.147  30.494  1.00  0.00           C  
ATOM   1098  O   VAL A 104      65.236 -21.457  31.272  1.00  0.00           O  
ATOM   1099  CB  VAL A 104      64.888 -22.690  28.612  1.00  0.00           C  
ATOM   1100  CG1 VAL A 104      63.969 -23.663  29.334  1.00  0.00           C  
ATOM   1101  CG2 VAL A 104      64.808 -22.887  27.105  1.00  0.00           C  
ATOM   1102  H   VAL A 104      66.291 -20.640  27.958  1.00  0.00           H  
ATOM   1103  HA  VAL A 104      63.617 -20.972  28.490  1.00  0.00           H  
ATOM   1104  HB  VAL A 104      65.903 -22.888  28.926  1.00  0.00           H  
ATOM   1105 HG11 VAL A 104      64.288 -24.676  29.133  1.00  0.00           H  
ATOM   1106 HG12 VAL A 104      64.009 -23.475  30.397  1.00  0.00           H  
ATOM   1107 HG13 VAL A 104      62.956 -23.529  28.983  1.00  0.00           H  
ATOM   1108 HG21 VAL A 104      65.578 -22.302  26.625  1.00  0.00           H  
ATOM   1109 HG22 VAL A 104      64.950 -23.931  26.871  1.00  0.00           H  
ATOM   1110 HG23 VAL A 104      63.839 -22.567  26.752  1.00  0.00           H  
ATOM   1111  N   GLY A 105      63.143 -20.720  30.899  1.00  0.00           N  
ATOM   1112  CA  GLY A 105      62.842 -20.596  32.313  1.00  0.00           C  
ATOM   1113  C   GLY A 105      62.541 -19.167  32.720  1.00  0.00           C  
ATOM   1114  O   GLY A 105      61.707 -18.925  33.590  1.00  0.00           O  
ATOM   1115  H   GLY A 105      62.463 -20.486  30.232  1.00  0.00           H  
ATOM   1116  HA2 GLY A 105      61.985 -21.212  32.542  1.00  0.00           H  
ATOM   1117  HA3 GLY A 105      63.689 -20.950  32.882  1.00  0.00           H  
ATOM   1118  N   GLU A 106      63.226 -18.218  32.088  1.00  0.00           N  
ATOM   1119  CA  GLU A 106      63.029 -16.805  32.392  1.00  0.00           C  
ATOM   1120  C   GLU A 106      62.188 -16.129  31.314  1.00  0.00           C  
ATOM   1121  O   GLU A 106      61.857 -16.738  30.295  1.00  0.00           O  
ATOM   1122  CB  GLU A 106      64.380 -16.096  32.520  1.00  0.00           C  
ATOM   1123  CG  GLU A 106      65.113 -15.940  31.198  1.00  0.00           C  
ATOM   1124  CD  GLU A 106      66.043 -14.743  31.185  1.00  0.00           C  
ATOM   1125  OE1 GLU A 106      65.834 -13.819  31.999  1.00  0.00           O  
ATOM   1126  OE2 GLU A 106      66.979 -14.730  30.359  1.00  0.00           O  
ATOM   1127  H   GLU A 106      63.879 -18.473  31.403  1.00  0.00           H  
ATOM   1128  HA  GLU A 106      62.507 -16.738  33.334  1.00  0.00           H  
ATOM   1129  HB2 GLU A 106      64.218 -15.113  32.937  1.00  0.00           H  
ATOM   1130  HB3 GLU A 106      65.007 -16.663  33.191  1.00  0.00           H  
ATOM   1131  HG2 GLU A 106      65.696 -16.830  31.018  1.00  0.00           H  
ATOM   1132  HG3 GLU A 106      64.385 -15.822  30.409  1.00  0.00           H  
ATOM   1133  N   VAL A 107      61.842 -14.867  31.546  1.00  0.00           N  
ATOM   1134  CA  VAL A 107      61.039 -14.106  30.595  1.00  0.00           C  
ATOM   1135  C   VAL A 107      61.827 -13.808  29.325  1.00  0.00           C  
ATOM   1136  O   VAL A 107      61.323 -13.976  28.215  1.00  0.00           O  
ATOM   1137  CB  VAL A 107      60.551 -12.780  31.207  1.00  0.00           C  
ATOM   1138  CG1 VAL A 107      59.724 -12.000  30.198  1.00  0.00           C  
ATOM   1139  CG2 VAL A 107      59.755 -13.041  32.476  1.00  0.00           C  
ATOM   1140  H   VAL A 107      62.136 -14.436  32.375  1.00  0.00           H  
ATOM   1141  HA  VAL A 107      60.174 -14.701  30.339  1.00  0.00           H  
ATOM   1142  HB  VAL A 107      61.416 -12.187  31.465  1.00  0.00           H  
ATOM   1143 HG11 VAL A 107      59.614 -12.582  29.296  1.00  0.00           H  
ATOM   1144 HG12 VAL A 107      58.750 -11.791  30.615  1.00  0.00           H  
ATOM   1145 HG13 VAL A 107      60.222 -11.069  29.967  1.00  0.00           H  
ATOM   1146 HG21 VAL A 107      59.992 -12.287  33.212  1.00  0.00           H  
ATOM   1147 HG22 VAL A 107      58.699 -13.003  32.251  1.00  0.00           H  
ATOM   1148 HG23 VAL A 107      60.006 -14.017  32.866  1.00  0.00           H  
ATOM   1149  N   GLY A 108      63.070 -13.365  29.495  1.00  0.00           N  
ATOM   1150  CA  GLY A 108      63.908 -13.051  28.354  1.00  0.00           C  
ATOM   1151  C   GLY A 108      63.521 -11.743  27.692  1.00  0.00           C  
ATOM   1152  O   GLY A 108      62.838 -10.915  28.294  1.00  0.00           O  
ATOM   1153  H   GLY A 108      63.419 -13.251  30.404  1.00  0.00           H  
ATOM   1154  HA2 GLY A 108      64.935 -12.986  28.682  1.00  0.00           H  
ATOM   1155  HA3 GLY A 108      63.822 -13.846  27.628  1.00  0.00           H  
ATOM   1156  N   GLN A 109      63.960 -11.555  26.452  1.00  0.00           N  
ATOM   1157  CA  GLN A 109      63.656 -10.338  25.710  1.00  0.00           C  
ATOM   1158  C   GLN A 109      62.246 -10.390  25.131  1.00  0.00           C  
ATOM   1159  O   GLN A 109      61.499 -11.337  25.375  1.00  0.00           O  
ATOM   1160  CB  GLN A 109      64.675 -10.133  24.587  1.00  0.00           C  
ATOM   1161  CG  GLN A 109      66.063  -9.767  25.085  1.00  0.00           C  
ATOM   1162  CD  GLN A 109      66.085  -8.453  25.842  1.00  0.00           C  
ATOM   1163  OE1 GLN A 109      65.769  -8.404  27.031  1.00  0.00           O  
ATOM   1164  NE2 GLN A 109      66.460  -7.380  25.157  1.00  0.00           N  
ATOM   1165  H   GLN A 109      64.499 -12.253  26.026  1.00  0.00           H  
ATOM   1166  HA  GLN A 109      63.720  -9.508  26.397  1.00  0.00           H  
ATOM   1167  HB2 GLN A 109      64.749 -11.044  24.014  1.00  0.00           H  
ATOM   1168  HB3 GLN A 109      64.326  -9.339  23.943  1.00  0.00           H  
ATOM   1169  HG2 GLN A 109      66.415 -10.548  25.741  1.00  0.00           H  
ATOM   1170  HG3 GLN A 109      66.726  -9.687  24.236  1.00  0.00           H  
ATOM   1171 HE21 GLN A 109      66.697  -7.494  24.212  1.00  0.00           H  
ATOM   1172 HE22 GLN A 109      66.482  -6.518  25.621  1.00  0.00           H  
ATOM   1173  N   SER A 110      61.889  -9.365  24.364  1.00  0.00           N  
ATOM   1174  CA  SER A 110      60.567  -9.291  23.753  1.00  0.00           C  
ATOM   1175  C   SER A 110      60.594  -8.418  22.502  1.00  0.00           C  
ATOM   1176  O   SER A 110      60.961  -7.244  22.557  1.00  0.00           O  
ATOM   1177  CB  SER A 110      59.550  -8.738  24.753  1.00  0.00           C  
ATOM   1178  OG  SER A 110      59.900  -7.429  25.165  1.00  0.00           O  
ATOM   1179  H   SER A 110      62.529  -8.640  24.207  1.00  0.00           H  
ATOM   1180  HA  SER A 110      60.276 -10.293  23.472  1.00  0.00           H  
ATOM   1181  HB2 SER A 110      58.575  -8.708  24.292  1.00  0.00           H  
ATOM   1182  HB3 SER A 110      59.518  -9.380  25.622  1.00  0.00           H  
ATOM   1183  HG  SER A 110      59.799  -6.823  24.428  1.00  0.00           H  
ATOM   1184  N   LYS A 111      60.202  -9.000  21.374  1.00  0.00           N  
ATOM   1185  CA  LYS A 111      60.179  -8.277  20.107  1.00  0.00           C  
ATOM   1186  C   LYS A 111      58.816  -8.402  19.435  1.00  0.00           C  
ATOM   1187  O   LYS A 111      58.197  -9.467  19.458  1.00  0.00           O  
ATOM   1188  CB  LYS A 111      61.271  -8.807  19.175  1.00  0.00           C  
ATOM   1189  CG  LYS A 111      61.264  -8.159  17.801  1.00  0.00           C  
ATOM   1190  CD  LYS A 111      61.894  -6.777  17.833  1.00  0.00           C  
ATOM   1191  CE  LYS A 111      63.412  -6.856  17.843  1.00  0.00           C  
ATOM   1192  NZ  LYS A 111      64.038  -5.506  17.893  1.00  0.00           N  
ATOM   1193  H   LYS A 111      59.920  -9.940  21.393  1.00  0.00           H  
ATOM   1194  HA  LYS A 111      60.370  -7.236  20.317  1.00  0.00           H  
ATOM   1195  HB2 LYS A 111      62.234  -8.628  19.629  1.00  0.00           H  
ATOM   1196  HB3 LYS A 111      61.134  -9.871  19.048  1.00  0.00           H  
ATOM   1197  HG2 LYS A 111      61.822  -8.781  17.117  1.00  0.00           H  
ATOM   1198  HG3 LYS A 111      60.242  -8.072  17.460  1.00  0.00           H  
ATOM   1199  HD2 LYS A 111      61.579  -6.226  16.958  1.00  0.00           H  
ATOM   1200  HD3 LYS A 111      61.563  -6.261  18.723  1.00  0.00           H  
ATOM   1201  HE2 LYS A 111      63.725  -7.421  18.709  1.00  0.00           H  
ATOM   1202  HE3 LYS A 111      63.739  -7.362  16.947  1.00  0.00           H  
ATOM   1203  HZ1 LYS A 111      63.651  -4.962  18.689  1.00  0.00           H  
ATOM   1204  HZ2 LYS A 111      63.848  -4.992  17.009  1.00  0.00           H  
ATOM   1205  HZ3 LYS A 111      65.067  -5.594  18.015  1.00  0.00           H  
ATOM   1206  N   ILE A 112      58.355  -7.310  18.835  1.00  0.00           N  
ATOM   1207  CA  ILE A 112      57.067  -7.299  18.153  1.00  0.00           C  
ATOM   1208  C   ILE A 112      57.165  -6.598  16.803  1.00  0.00           C  
ATOM   1209  O   ILE A 112      57.850  -5.585  16.666  1.00  0.00           O  
ATOM   1210  CB  ILE A 112      55.987  -6.604  19.003  1.00  0.00           C  
ATOM   1211  CG1 ILE A 112      54.599  -6.855  18.407  1.00  0.00           C  
ATOM   1212  CG2 ILE A 112      56.267  -5.111  19.098  1.00  0.00           C  
ATOM   1213  CD1 ILE A 112      53.485  -6.798  19.428  1.00  0.00           C  
ATOM   1214  H   ILE A 112      58.894  -6.493  18.850  1.00  0.00           H  
ATOM   1215  HA  ILE A 112      56.766  -8.324  17.993  1.00  0.00           H  
ATOM   1216  HB  ILE A 112      56.023  -7.017  20.000  1.00  0.00           H  
ATOM   1217 HG12 ILE A 112      54.397  -6.109  17.655  1.00  0.00           H  
ATOM   1218 HG13 ILE A 112      54.583  -7.834  17.951  1.00  0.00           H  
ATOM   1219 HG21 ILE A 112      55.602  -4.578  18.434  1.00  0.00           H  
ATOM   1220 HG22 ILE A 112      56.105  -4.779  20.111  1.00  0.00           H  
ATOM   1221 HG23 ILE A 112      57.290  -4.918  18.814  1.00  0.00           H  
ATOM   1222 HD11 ILE A 112      53.907  -6.699  20.418  1.00  0.00           H  
ATOM   1223 HD12 ILE A 112      52.850  -5.948  19.223  1.00  0.00           H  
ATOM   1224 HD13 ILE A 112      52.901  -7.705  19.375  1.00  0.00           H  
ATOM   1225  N   ASN A 113      56.475  -7.144  15.807  1.00  0.00           N  
ATOM   1226  CA  ASN A 113      56.483  -6.570  14.466  1.00  0.00           C  
ATOM   1227  C   ASN A 113      55.061  -6.387  13.944  1.00  0.00           C  
ATOM   1228  O   ASN A 113      54.219  -7.276  14.079  1.00  0.00           O  
ATOM   1229  CB  ASN A 113      57.277  -7.462  13.512  1.00  0.00           C  
ATOM   1230  CG  ASN A 113      58.647  -7.819  14.057  1.00  0.00           C  
ATOM   1231  OD1 ASN A 113      58.934  -8.984  14.331  1.00  0.00           O  
ATOM   1232  ND2 ASN A 113      59.498  -6.813  14.220  1.00  0.00           N  
ATOM   1233  H   ASN A 113      55.947  -7.952  15.978  1.00  0.00           H  
ATOM   1234  HA  ASN A 113      56.960  -5.603  14.523  1.00  0.00           H  
ATOM   1235  HB2 ASN A 113      56.729  -8.378  13.344  1.00  0.00           H  
ATOM   1236  HB3 ASN A 113      57.407  -6.948  12.571  1.00  0.00           H  
ATOM   1237 HD21 ASN A 113      59.201  -5.910  13.981  1.00  0.00           H  
ATOM   1238 HD22 ASN A 113      60.391  -7.014  14.571  1.00  0.00           H  
ATOM   1239  N   HIS A 114      54.800  -5.228  13.346  1.00  0.00           N  
ATOM   1240  CA  HIS A 114      53.481  -4.929  12.802  1.00  0.00           C  
ATOM   1241  C   HIS A 114      53.498  -4.975  11.277  1.00  0.00           C  
ATOM   1242  O   HIS A 114      54.319  -4.320  10.635  1.00  0.00           O  
ATOM   1243  CB  HIS A 114      53.011  -3.554  13.277  1.00  0.00           C  
ATOM   1244  CG  HIS A 114      53.125  -3.359  14.757  1.00  0.00           C  
ATOM   1245  ND1 HIS A 114      52.153  -3.763  15.647  1.00  0.00           N  
ATOM   1246  CD2 HIS A 114      54.108  -2.802  15.503  1.00  0.00           C  
ATOM   1247  CE1 HIS A 114      52.530  -3.461  16.877  1.00  0.00           C  
ATOM   1248  NE2 HIS A 114      53.714  -2.877  16.817  1.00  0.00           N  
ATOM   1249  H   HIS A 114      55.513  -4.560  13.269  1.00  0.00           H  
ATOM   1250  HA  HIS A 114      52.794  -5.679  13.165  1.00  0.00           H  
ATOM   1251  HB2 HIS A 114      53.605  -2.791  12.795  1.00  0.00           H  
ATOM   1252  HB3 HIS A 114      51.973  -3.421  13.004  1.00  0.00           H  
ATOM   1253  HD1 HIS A 114      51.310  -4.204  15.413  1.00  0.00           H  
ATOM   1254  HD2 HIS A 114      55.030  -2.375  15.135  1.00  0.00           H  
ATOM   1255  HE1 HIS A 114      51.969  -3.658  17.777  1.00  0.00           H  
ATOM   1256  N   PHE A 115      52.587  -5.754  10.703  1.00  0.00           N  
ATOM   1257  CA  PHE A 115      52.500  -5.887   9.254  1.00  0.00           C  
ATOM   1258  C   PHE A 115      51.127  -5.452   8.750  1.00  0.00           C  
ATOM   1259  O   PHE A 115      50.097  -5.859   9.288  1.00  0.00           O  
ATOM   1260  CB  PHE A 115      52.774  -7.333   8.836  1.00  0.00           C  
ATOM   1261  CG  PHE A 115      54.182  -7.779   9.107  1.00  0.00           C  
ATOM   1262  CD1 PHE A 115      55.220  -7.384   8.280  1.00  0.00           C  
ATOM   1263  CD2 PHE A 115      54.467  -8.594  10.191  1.00  0.00           C  
ATOM   1264  CE1 PHE A 115      56.517  -7.794   8.528  1.00  0.00           C  
ATOM   1265  CE2 PHE A 115      55.762  -9.007  10.445  1.00  0.00           C  
ATOM   1266  CZ  PHE A 115      56.788  -8.605   9.612  1.00  0.00           C  
ATOM   1267  H   PHE A 115      51.960  -6.252  11.268  1.00  0.00           H  
ATOM   1268  HA  PHE A 115      53.250  -5.247   8.817  1.00  0.00           H  
ATOM   1269  HB2 PHE A 115      52.108  -7.990   9.377  1.00  0.00           H  
ATOM   1270  HB3 PHE A 115      52.591  -7.435   7.776  1.00  0.00           H  
ATOM   1271  HD1 PHE A 115      55.010  -6.748   7.433  1.00  0.00           H  
ATOM   1272  HD2 PHE A 115      53.665  -8.909  10.845  1.00  0.00           H  
ATOM   1273  HE1 PHE A 115      57.317  -7.478   7.875  1.00  0.00           H  
ATOM   1274  HE2 PHE A 115      55.971  -9.642  11.294  1.00  0.00           H  
ATOM   1275  HZ  PHE A 115      57.800  -8.926   9.808  1.00  0.00           H  
ATOM   1276  N   THR A 116      51.120  -4.621   7.712  1.00  0.00           N  
ATOM   1277  CA  THR A 116      49.876  -4.129   7.135  1.00  0.00           C  
ATOM   1278  C   THR A 116      49.172  -5.217   6.334  1.00  0.00           C  
ATOM   1279  O   THR A 116      47.948  -5.343   6.380  1.00  0.00           O  
ATOM   1280  CB  THR A 116      50.122  -2.913   6.222  1.00  0.00           C  
ATOM   1281  OG1 THR A 116      51.017  -3.269   5.162  1.00  0.00           O  
ATOM   1282  CG2 THR A 116      50.703  -1.751   7.013  1.00  0.00           C  
ATOM   1283  H   THR A 116      51.974  -4.333   7.327  1.00  0.00           H  
ATOM   1284  HA  THR A 116      49.232  -3.818   7.946  1.00  0.00           H  
ATOM   1285  HB  THR A 116      49.178  -2.603   5.797  1.00  0.00           H  
ATOM   1286  HG1 THR A 116      50.798  -2.765   4.375  1.00  0.00           H  
ATOM   1287 HG21 THR A 116      51.464  -1.260   6.425  1.00  0.00           H  
ATOM   1288 HG22 THR A 116      51.141  -2.121   7.929  1.00  0.00           H  
ATOM   1289 HG23 THR A 116      49.919  -1.047   7.247  1.00  0.00           H  
ATOM   1290  N   ARG A 117      49.953  -6.004   5.600  1.00  0.00           N  
ATOM   1291  CA  ARG A 117      49.403  -7.083   4.788  1.00  0.00           C  
ATOM   1292  C   ARG A 117      49.413  -8.401   5.555  1.00  0.00           C  
ATOM   1293  O   ARG A 117      50.303  -8.651   6.369  1.00  0.00           O  
ATOM   1294  CB  ARG A 117      50.201  -7.230   3.490  1.00  0.00           C  
ATOM   1295  CG  ARG A 117      49.743  -6.293   2.385  1.00  0.00           C  
ATOM   1296  CD  ARG A 117      50.274  -6.731   1.028  1.00  0.00           C  
ATOM   1297  NE  ARG A 117      50.252  -5.643   0.054  1.00  0.00           N  
ATOM   1298  CZ  ARG A 117      50.713  -5.757  -1.186  1.00  0.00           C  
ATOM   1299  NH1 ARG A 117      51.229  -6.905  -1.602  1.00  0.00           N  
ATOM   1300  NH2 ARG A 117      50.658  -4.721  -2.014  1.00  0.00           N  
ATOM   1301  H   ARG A 117      50.921  -5.855   5.604  1.00  0.00           H  
ATOM   1302  HA  ARG A 117      48.382  -6.828   4.545  1.00  0.00           H  
ATOM   1303  HB2 ARG A 117      51.241  -7.027   3.696  1.00  0.00           H  
ATOM   1304  HB3 ARG A 117      50.104  -8.245   3.136  1.00  0.00           H  
ATOM   1305  HG2 ARG A 117      48.664  -6.289   2.352  1.00  0.00           H  
ATOM   1306  HG3 ARG A 117      50.102  -5.297   2.598  1.00  0.00           H  
ATOM   1307  HD2 ARG A 117      51.291  -7.073   1.148  1.00  0.00           H  
ATOM   1308  HD3 ARG A 117      49.662  -7.541   0.662  1.00  0.00           H  
ATOM   1309  HE  ARG A 117      49.876  -4.784   0.341  1.00  0.00           H  
ATOM   1310 HH11 ARG A 117      51.270  -7.688  -0.980  1.00  0.00           H  
ATOM   1311 HH12 ARG A 117      51.574  -6.990  -2.536  1.00  0.00           H  
ATOM   1312 HH21 ARG A 117      50.271  -3.854  -1.704  1.00  0.00           H  
ATOM   1313 HH22 ARG A 117      51.006  -4.809  -2.946  1.00  0.00           H  
ATOM   1314  N   LEU A 118      48.417  -9.240   5.293  1.00  0.00           N  
ATOM   1315  CA  LEU A 118      48.311 -10.533   5.960  1.00  0.00           C  
ATOM   1316  C   LEU A 118      49.408 -11.481   5.488  1.00  0.00           C  
ATOM   1317  O   LEU A 118      50.244 -11.919   6.278  1.00  0.00           O  
ATOM   1318  CB  LEU A 118      46.937 -11.153   5.696  1.00  0.00           C  
ATOM   1319  CG  LEU A 118      46.773 -12.618   6.101  1.00  0.00           C  
ATOM   1320  CD1 LEU A 118      46.989 -12.785   7.598  1.00  0.00           C  
ATOM   1321  CD2 LEU A 118      45.399 -13.133   5.698  1.00  0.00           C  
ATOM   1322  H   LEU A 118      47.738  -8.985   4.635  1.00  0.00           H  
ATOM   1323  HA  LEU A 118      48.425 -10.368   7.021  1.00  0.00           H  
ATOM   1324  HB2 LEU A 118      46.204 -10.576   6.238  1.00  0.00           H  
ATOM   1325  HB3 LEU A 118      46.739 -11.078   4.636  1.00  0.00           H  
ATOM   1326  HG  LEU A 118      47.517 -13.212   5.589  1.00  0.00           H  
ATOM   1327 HD11 LEU A 118      46.048 -12.669   8.112  1.00  0.00           H  
ATOM   1328 HD12 LEU A 118      47.685 -12.037   7.946  1.00  0.00           H  
ATOM   1329 HD13 LEU A 118      47.389 -13.769   7.796  1.00  0.00           H  
ATOM   1330 HD21 LEU A 118      45.414 -14.212   5.665  1.00  0.00           H  
ATOM   1331 HD22 LEU A 118      45.142 -12.745   4.723  1.00  0.00           H  
ATOM   1332 HD23 LEU A 118      44.665 -12.805   6.421  1.00  0.00           H  
ATOM   1333  N   GLU A 119      49.400 -11.792   4.196  1.00  0.00           N  
ATOM   1334  CA  GLU A 119      50.396 -12.687   3.619  1.00  0.00           C  
ATOM   1335  C   GLU A 119      51.798 -12.326   4.104  1.00  0.00           C  
ATOM   1336  O   GLU A 119      52.551 -13.187   4.557  1.00  0.00           O  
ATOM   1337  CB  GLU A 119      50.343 -12.629   2.091  1.00  0.00           C  
ATOM   1338  CG  GLU A 119      49.118 -13.307   1.499  1.00  0.00           C  
ATOM   1339  CD  GLU A 119      49.312 -13.695   0.047  1.00  0.00           C  
ATOM   1340  OE1 GLU A 119      49.991 -12.945  -0.684  1.00  0.00           O  
ATOM   1341  OE2 GLU A 119      48.783 -14.752  -0.360  1.00  0.00           O  
ATOM   1342  H   GLU A 119      48.708 -11.411   3.617  1.00  0.00           H  
ATOM   1343  HA  GLU A 119      50.166 -13.691   3.941  1.00  0.00           H  
ATOM   1344  HB2 GLU A 119      50.342 -11.595   1.781  1.00  0.00           H  
ATOM   1345  HB3 GLU A 119      51.223 -13.114   1.694  1.00  0.00           H  
ATOM   1346  HG2 GLU A 119      48.906 -14.200   2.069  1.00  0.00           H  
ATOM   1347  HG3 GLU A 119      48.280 -12.629   1.567  1.00  0.00           H  
ATOM   1348  N   ASP A 120      52.140 -11.046   4.004  1.00  0.00           N  
ATOM   1349  CA  ASP A 120      53.450 -10.569   4.432  1.00  0.00           C  
ATOM   1350  C   ASP A 120      53.823 -11.153   5.791  1.00  0.00           C  
ATOM   1351  O   ASP A 120      54.922 -11.677   5.971  1.00  0.00           O  
ATOM   1352  CB  ASP A 120      53.463  -9.041   4.500  1.00  0.00           C  
ATOM   1353  CG  ASP A 120      54.864  -8.479   4.635  1.00  0.00           C  
ATOM   1354  OD1 ASP A 120      55.740  -9.193   5.169  1.00  0.00           O  
ATOM   1355  OD2 ASP A 120      55.087  -7.327   4.209  1.00  0.00           O  
ATOM   1356  H   ASP A 120      51.495 -10.406   3.634  1.00  0.00           H  
ATOM   1357  HA  ASP A 120      54.176 -10.895   3.703  1.00  0.00           H  
ATOM   1358  HB2 ASP A 120      53.022  -8.644   3.596  1.00  0.00           H  
ATOM   1359  HB3 ASP A 120      52.881  -8.719   5.350  1.00  0.00           H  
ATOM   1360  N   ALA A 121      52.901 -11.058   6.744  1.00  0.00           N  
ATOM   1361  CA  ALA A 121      53.133 -11.577   8.086  1.00  0.00           C  
ATOM   1362  C   ALA A 121      53.318 -13.090   8.064  1.00  0.00           C  
ATOM   1363  O   ALA A 121      54.220 -13.627   8.710  1.00  0.00           O  
ATOM   1364  CB  ALA A 121      51.983 -11.197   9.006  1.00  0.00           C  
ATOM   1365  H   ALA A 121      52.045 -10.629   6.540  1.00  0.00           H  
ATOM   1366  HA  ALA A 121      54.035 -11.120   8.470  1.00  0.00           H  
ATOM   1367  HB1 ALA A 121      52.306 -11.268  10.033  1.00  0.00           H  
ATOM   1368  HB2 ALA A 121      51.674 -10.184   8.794  1.00  0.00           H  
ATOM   1369  HB3 ALA A 121      51.153 -11.869   8.840  1.00  0.00           H  
ATOM   1370  N   LYS A 122      52.459 -13.776   7.318  1.00  0.00           N  
ATOM   1371  CA  LYS A 122      52.527 -15.229   7.212  1.00  0.00           C  
ATOM   1372  C   LYS A 122      53.899 -15.675   6.718  1.00  0.00           C  
ATOM   1373  O   LYS A 122      54.512 -16.578   7.287  1.00  0.00           O  
ATOM   1374  CB  LYS A 122      51.441 -15.742   6.262  1.00  0.00           C  
ATOM   1375  CG  LYS A 122      50.036 -15.324   6.662  1.00  0.00           C  
ATOM   1376  CD  LYS A 122      49.004 -15.809   5.659  1.00  0.00           C  
ATOM   1377  CE  LYS A 122      48.446 -17.169   6.046  1.00  0.00           C  
ATOM   1378  NZ  LYS A 122      49.216 -18.282   5.424  1.00  0.00           N  
ATOM   1379  H   LYS A 122      51.761 -13.293   6.826  1.00  0.00           H  
ATOM   1380  HA  LYS A 122      52.358 -15.642   8.195  1.00  0.00           H  
ATOM   1381  HB2 LYS A 122      51.639 -15.363   5.271  1.00  0.00           H  
ATOM   1382  HB3 LYS A 122      51.480 -16.822   6.240  1.00  0.00           H  
ATOM   1383  HG2 LYS A 122      49.807 -15.744   7.630  1.00  0.00           H  
ATOM   1384  HG3 LYS A 122      49.994 -14.245   6.717  1.00  0.00           H  
ATOM   1385  HD2 LYS A 122      48.192 -15.097   5.619  1.00  0.00           H  
ATOM   1386  HD3 LYS A 122      49.468 -15.883   4.685  1.00  0.00           H  
ATOM   1387  HE2 LYS A 122      48.489 -17.270   7.119  1.00  0.00           H  
ATOM   1388  HE3 LYS A 122      47.418 -17.228   5.719  1.00  0.00           H  
ATOM   1389  HZ1 LYS A 122      49.817 -17.916   4.658  1.00  0.00           H  
ATOM   1390  HZ2 LYS A 122      48.566 -18.991   5.032  1.00  0.00           H  
ATOM   1391  HZ3 LYS A 122      49.821 -18.740   6.136  1.00  0.00           H  
ATOM   1392  N   LYS A 123      54.379 -15.035   5.658  1.00  0.00           N  
ATOM   1393  CA  LYS A 123      55.681 -15.362   5.089  1.00  0.00           C  
ATOM   1394  C   LYS A 123      56.763 -15.349   6.164  1.00  0.00           C  
ATOM   1395  O   LYS A 123      57.660 -16.192   6.165  1.00  0.00           O  
ATOM   1396  CB  LYS A 123      56.039 -14.373   3.977  1.00  0.00           C  
ATOM   1397  CG  LYS A 123      55.075 -14.402   2.805  1.00  0.00           C  
ATOM   1398  CD  LYS A 123      55.334 -13.255   1.842  1.00  0.00           C  
ATOM   1399  CE  LYS A 123      56.610 -13.473   1.045  1.00  0.00           C  
ATOM   1400  NZ  LYS A 123      56.374 -14.312  -0.163  1.00  0.00           N  
ATOM   1401  H   LYS A 123      53.844 -14.323   5.247  1.00  0.00           H  
ATOM   1402  HA  LYS A 123      55.619 -16.356   4.670  1.00  0.00           H  
ATOM   1403  HB2 LYS A 123      56.044 -13.374   4.389  1.00  0.00           H  
ATOM   1404  HB3 LYS A 123      57.027 -14.606   3.610  1.00  0.00           H  
ATOM   1405  HG2 LYS A 123      55.194 -15.335   2.274  1.00  0.00           H  
ATOM   1406  HG3 LYS A 123      54.064 -14.324   3.179  1.00  0.00           H  
ATOM   1407  HD2 LYS A 123      54.503 -13.177   1.156  1.00  0.00           H  
ATOM   1408  HD3 LYS A 123      55.424 -12.337   2.406  1.00  0.00           H  
ATOM   1409  HE2 LYS A 123      56.996 -12.514   0.736  1.00  0.00           H  
ATOM   1410  HE3 LYS A 123      57.335 -13.965   1.678  1.00  0.00           H  
ATOM   1411  HZ1 LYS A 123      57.280 -14.553  -0.614  1.00  0.00           H  
ATOM   1412  HZ2 LYS A 123      55.784 -13.795  -0.846  1.00  0.00           H  
ATOM   1413  HZ3 LYS A 123      55.887 -15.191   0.103  1.00  0.00           H  
ATOM   1414  N   ASP A 124      56.671 -14.389   7.077  1.00  0.00           N  
ATOM   1415  CA  ASP A 124      57.641 -14.268   8.160  1.00  0.00           C  
ATOM   1416  C   ASP A 124      57.450 -15.378   9.188  1.00  0.00           C  
ATOM   1417  O   ASP A 124      58.419 -15.944   9.694  1.00  0.00           O  
ATOM   1418  CB  ASP A 124      57.514 -12.902   8.836  1.00  0.00           C  
ATOM   1419  CG  ASP A 124      58.608 -12.657   9.857  1.00  0.00           C  
ATOM   1420  OD1 ASP A 124      59.743 -12.335   9.445  1.00  0.00           O  
ATOM   1421  OD2 ASP A 124      58.331 -12.788  11.067  1.00  0.00           O  
ATOM   1422  H   ASP A 124      55.932 -13.746   7.023  1.00  0.00           H  
ATOM   1423  HA  ASP A 124      58.628 -14.357   7.732  1.00  0.00           H  
ATOM   1424  HB2 ASP A 124      57.570 -12.128   8.084  1.00  0.00           H  
ATOM   1425  HB3 ASP A 124      56.559 -12.843   9.338  1.00  0.00           H  
ATOM   1426  N   PHE A 125      56.193 -15.684   9.494  1.00  0.00           N  
ATOM   1427  CA  PHE A 125      55.874 -16.726  10.463  1.00  0.00           C  
ATOM   1428  C   PHE A 125      56.374 -18.086   9.985  1.00  0.00           C  
ATOM   1429  O   PHE A 125      56.996 -18.831  10.742  1.00  0.00           O  
ATOM   1430  CB  PHE A 125      54.364 -16.781  10.705  1.00  0.00           C  
ATOM   1431  CG  PHE A 125      53.963 -17.771  11.762  1.00  0.00           C  
ATOM   1432  CD1 PHE A 125      54.134 -19.131  11.557  1.00  0.00           C  
ATOM   1433  CD2 PHE A 125      53.414 -17.342  12.960  1.00  0.00           C  
ATOM   1434  CE1 PHE A 125      53.764 -20.043  12.527  1.00  0.00           C  
ATOM   1435  CE2 PHE A 125      53.044 -18.249  13.933  1.00  0.00           C  
ATOM   1436  CZ  PHE A 125      53.220 -19.602  13.717  1.00  0.00           C  
ATOM   1437  H   PHE A 125      55.463 -15.198   9.057  1.00  0.00           H  
ATOM   1438  HA  PHE A 125      56.370 -16.478  11.389  1.00  0.00           H  
ATOM   1439  HB2 PHE A 125      54.021 -15.806  11.018  1.00  0.00           H  
ATOM   1440  HB3 PHE A 125      53.869 -17.056   9.786  1.00  0.00           H  
ATOM   1441  HD1 PHE A 125      54.561 -19.476  10.627  1.00  0.00           H  
ATOM   1442  HD2 PHE A 125      53.277 -16.283  13.130  1.00  0.00           H  
ATOM   1443  HE1 PHE A 125      53.904 -21.100  12.355  1.00  0.00           H  
ATOM   1444  HE2 PHE A 125      52.618 -17.901  14.863  1.00  0.00           H  
ATOM   1445  HZ  PHE A 125      52.930 -20.312  14.477  1.00  0.00           H  
ATOM   1446  N   GLU A 126      56.097 -18.402   8.723  1.00  0.00           N  
ATOM   1447  CA  GLU A 126      56.517 -19.672   8.145  1.00  0.00           C  
ATOM   1448  C   GLU A 126      58.017 -19.674   7.867  1.00  0.00           C  
ATOM   1449  O   GLU A 126      58.731 -20.600   8.252  1.00  0.00           O  
ATOM   1450  CB  GLU A 126      55.747 -19.948   6.851  1.00  0.00           C  
ATOM   1451  CG  GLU A 126      54.432 -20.679   7.069  1.00  0.00           C  
ATOM   1452  CD  GLU A 126      53.964 -21.418   5.831  1.00  0.00           C  
ATOM   1453  OE1 GLU A 126      54.172 -20.897   4.715  1.00  0.00           O  
ATOM   1454  OE2 GLU A 126      53.390 -22.518   5.978  1.00  0.00           O  
ATOM   1455  H   GLU A 126      55.598 -17.766   8.170  1.00  0.00           H  
ATOM   1456  HA  GLU A 126      56.294 -20.451   8.858  1.00  0.00           H  
ATOM   1457  HB2 GLU A 126      55.537 -19.008   6.364  1.00  0.00           H  
ATOM   1458  HB3 GLU A 126      56.365 -20.550   6.201  1.00  0.00           H  
ATOM   1459  HG2 GLU A 126      54.560 -21.392   7.869  1.00  0.00           H  
ATOM   1460  HG3 GLU A 126      53.678 -19.959   7.348  1.00  0.00           H  
ATOM   1461  N   LYS A 127      58.489 -18.629   7.195  1.00  0.00           N  
ATOM   1462  CA  LYS A 127      59.905 -18.508   6.866  1.00  0.00           C  
ATOM   1463  C   LYS A 127      60.772 -18.720   8.102  1.00  0.00           C  
ATOM   1464  O   LYS A 127      61.652 -19.581   8.116  1.00  0.00           O  
ATOM   1465  CB  LYS A 127      60.191 -17.133   6.258  1.00  0.00           C  
ATOM   1466  CG  LYS A 127      61.643 -16.934   5.860  1.00  0.00           C  
ATOM   1467  CD  LYS A 127      62.463 -16.363   7.005  1.00  0.00           C  
ATOM   1468  CE  LYS A 127      62.324 -14.852   7.091  1.00  0.00           C  
ATOM   1469  NZ  LYS A 127      63.395 -14.243   7.927  1.00  0.00           N  
ATOM   1470  H   LYS A 127      57.871 -17.922   6.915  1.00  0.00           H  
ATOM   1471  HA  LYS A 127      60.142 -19.270   6.139  1.00  0.00           H  
ATOM   1472  HB2 LYS A 127      59.578 -17.006   5.378  1.00  0.00           H  
ATOM   1473  HB3 LYS A 127      59.931 -16.373   6.980  1.00  0.00           H  
ATOM   1474  HG2 LYS A 127      62.062 -17.887   5.572  1.00  0.00           H  
ATOM   1475  HG3 LYS A 127      61.688 -16.252   5.023  1.00  0.00           H  
ATOM   1476  HD2 LYS A 127      62.121 -16.799   7.933  1.00  0.00           H  
ATOM   1477  HD3 LYS A 127      63.503 -16.613   6.851  1.00  0.00           H  
ATOM   1478  HE2 LYS A 127      62.381 -14.441   6.095  1.00  0.00           H  
ATOM   1479  HE3 LYS A 127      61.362 -14.616   7.524  1.00  0.00           H  
ATOM   1480  HZ1 LYS A 127      63.899 -13.512   7.386  1.00  0.00           H  
ATOM   1481  HZ2 LYS A 127      64.076 -14.972   8.223  1.00  0.00           H  
ATOM   1482  HZ3 LYS A 127      62.981 -13.807   8.777  1.00  0.00           H  
ATOM   1483  N   LYS A 128      60.517 -17.930   9.140  1.00  0.00           N  
ATOM   1484  CA  LYS A 128      61.273 -18.032  10.384  1.00  0.00           C  
ATOM   1485  C   LYS A 128      61.171 -19.437  10.967  1.00  0.00           C  
ATOM   1486  O   LYS A 128      62.183 -20.104  11.185  1.00  0.00           O  
ATOM   1487  CB  LYS A 128      60.763 -17.007  11.399  1.00  0.00           C  
ATOM   1488  CG  LYS A 128      61.508 -17.041  12.722  1.00  0.00           C  
ATOM   1489  CD  LYS A 128      62.947 -16.578  12.563  1.00  0.00           C  
ATOM   1490  CE  LYS A 128      63.027 -15.077  12.331  1.00  0.00           C  
ATOM   1491  NZ  LYS A 128      64.331 -14.516  12.780  1.00  0.00           N  
ATOM   1492  H   LYS A 128      59.803 -17.262   9.068  1.00  0.00           H  
ATOM   1493  HA  LYS A 128      62.308 -17.822  10.161  1.00  0.00           H  
ATOM   1494  HB2 LYS A 128      60.864 -16.018  10.978  1.00  0.00           H  
ATOM   1495  HB3 LYS A 128      59.717 -17.200  11.594  1.00  0.00           H  
ATOM   1496  HG2 LYS A 128      61.007 -16.390  13.424  1.00  0.00           H  
ATOM   1497  HG3 LYS A 128      61.504 -18.052  13.102  1.00  0.00           H  
ATOM   1498  HD2 LYS A 128      63.495 -16.822  13.462  1.00  0.00           H  
ATOM   1499  HD3 LYS A 128      63.388 -17.089  11.721  1.00  0.00           H  
ATOM   1500  HE2 LYS A 128      62.905 -14.883  11.277  1.00  0.00           H  
ATOM   1501  HE3 LYS A 128      62.231 -14.598  12.880  1.00  0.00           H  
ATOM   1502  HZ1 LYS A 128      64.393 -14.540  13.818  1.00  0.00           H  
ATOM   1503  HZ2 LYS A 128      64.425 -13.530  12.460  1.00  0.00           H  
ATOM   1504  HZ3 LYS A 128      65.115 -15.072  12.384  1.00  0.00           H  
ATOM   1505  N   PHE A 129      59.944 -19.882  11.218  1.00  0.00           N  
ATOM   1506  CA  PHE A 129      59.710 -21.209  11.775  1.00  0.00           C  
ATOM   1507  C   PHE A 129      60.522 -22.263  11.028  1.00  0.00           C  
ATOM   1508  O   PHE A 129      61.329 -22.977  11.623  1.00  0.00           O  
ATOM   1509  CB  PHE A 129      58.221 -21.556  11.715  1.00  0.00           C  
ATOM   1510  CG  PHE A 129      57.936 -23.012  11.948  1.00  0.00           C  
ATOM   1511  CD1 PHE A 129      57.922 -23.907  10.890  1.00  0.00           C  
ATOM   1512  CD2 PHE A 129      57.680 -23.485  13.225  1.00  0.00           C  
ATOM   1513  CE1 PHE A 129      57.660 -25.248  11.101  1.00  0.00           C  
ATOM   1514  CE2 PHE A 129      57.418 -24.825  13.442  1.00  0.00           C  
ATOM   1515  CZ  PHE A 129      57.406 -25.706  12.379  1.00  0.00           C  
ATOM   1516  H   PHE A 129      59.177 -19.304  11.022  1.00  0.00           H  
ATOM   1517  HA  PHE A 129      60.026 -21.192  12.807  1.00  0.00           H  
ATOM   1518  HB2 PHE A 129      57.697 -20.991  12.470  1.00  0.00           H  
ATOM   1519  HB3 PHE A 129      57.838 -21.293  10.741  1.00  0.00           H  
ATOM   1520  HD1 PHE A 129      58.120 -23.549   9.890  1.00  0.00           H  
ATOM   1521  HD2 PHE A 129      57.688 -22.797  14.057  1.00  0.00           H  
ATOM   1522  HE1 PHE A 129      57.652 -25.934  10.268  1.00  0.00           H  
ATOM   1523  HE2 PHE A 129      57.219 -25.182  14.442  1.00  0.00           H  
ATOM   1524  HZ  PHE A 129      57.202 -26.754  12.546  1.00  0.00           H  
ATOM   1525  N   ARG A 130      60.298 -22.357   9.722  1.00  0.00           N  
ATOM   1526  CA  ARG A 130      61.006 -23.325   8.893  1.00  0.00           C  
ATOM   1527  C   ARG A 130      62.512 -23.084   8.941  1.00  0.00           C  
ATOM   1528  O   ARG A 130      63.303 -24.019   8.820  1.00  0.00           O  
ATOM   1529  CB  ARG A 130      60.512 -23.248   7.447  1.00  0.00           C  
ATOM   1530  CG  ARG A 130      61.372 -24.031   6.467  1.00  0.00           C  
ATOM   1531  CD  ARG A 130      60.607 -24.356   5.194  1.00  0.00           C  
ATOM   1532  NE  ARG A 130      61.495 -24.477   4.040  1.00  0.00           N  
ATOM   1533  CZ  ARG A 130      62.200 -25.570   3.767  1.00  0.00           C  
ATOM   1534  NH1 ARG A 130      62.121 -26.629   4.560  1.00  0.00           N  
ATOM   1535  NH2 ARG A 130      62.986 -25.605   2.698  1.00  0.00           N  
ATOM   1536  H   ARG A 130      59.642 -21.761   9.305  1.00  0.00           H  
ATOM   1537  HA  ARG A 130      60.799 -24.310   9.283  1.00  0.00           H  
ATOM   1538  HB2 ARG A 130      59.506 -23.638   7.401  1.00  0.00           H  
ATOM   1539  HB3 ARG A 130      60.503 -22.214   7.137  1.00  0.00           H  
ATOM   1540  HG2 ARG A 130      62.240 -23.441   6.213  1.00  0.00           H  
ATOM   1541  HG3 ARG A 130      61.685 -24.953   6.935  1.00  0.00           H  
ATOM   1542  HD2 ARG A 130      60.083 -25.290   5.332  1.00  0.00           H  
ATOM   1543  HD3 ARG A 130      59.895 -23.567   5.006  1.00  0.00           H  
ATOM   1544  HE  ARG A 130      61.568 -23.707   3.440  1.00  0.00           H  
ATOM   1545 HH11 ARG A 130      61.530 -26.606   5.365  1.00  0.00           H  
ATOM   1546 HH12 ARG A 130      62.652 -27.451   4.351  1.00  0.00           H  
ATOM   1547 HH21 ARG A 130      63.047 -24.807   2.096  1.00  0.00           H  
ATOM   1548 HH22 ARG A 130      63.516 -26.427   2.493  1.00  0.00           H  
ATOM   1549  N   GLU A 131      62.899 -21.825   9.119  1.00  0.00           N  
ATOM   1550  CA  GLU A 131      64.311 -21.462   9.181  1.00  0.00           C  
ATOM   1551  C   GLU A 131      64.941 -21.951  10.482  1.00  0.00           C  
ATOM   1552  O   GLU A 131      66.155 -22.129  10.568  1.00  0.00           O  
ATOM   1553  CB  GLU A 131      64.476 -19.946   9.059  1.00  0.00           C  
ATOM   1554  CG  GLU A 131      64.629 -19.463   7.627  1.00  0.00           C  
ATOM   1555  CD  GLU A 131      65.458 -18.199   7.522  1.00  0.00           C  
ATOM   1556  OE1 GLU A 131      65.456 -17.406   8.488  1.00  0.00           O  
ATOM   1557  OE2 GLU A 131      66.111 -18.000   6.476  1.00  0.00           O  
ATOM   1558  H   GLU A 131      62.220 -21.124   9.208  1.00  0.00           H  
ATOM   1559  HA  GLU A 131      64.812 -21.937   8.351  1.00  0.00           H  
ATOM   1560  HB2 GLU A 131      63.609 -19.466   9.489  1.00  0.00           H  
ATOM   1561  HB3 GLU A 131      65.354 -19.646   9.612  1.00  0.00           H  
ATOM   1562  HG2 GLU A 131      65.109 -20.238   7.048  1.00  0.00           H  
ATOM   1563  HG3 GLU A 131      63.648 -19.267   7.219  1.00  0.00           H  
ATOM   1564  N   LYS A 132      64.105 -22.164  11.493  1.00  0.00           N  
ATOM   1565  CA  LYS A 132      64.578 -22.633  12.790  1.00  0.00           C  
ATOM   1566  C   LYS A 132      64.357 -24.134  12.940  1.00  0.00           C  
ATOM   1567  O   LYS A 132      65.053 -24.802  13.706  1.00  0.00           O  
ATOM   1568  CB  LYS A 132      63.861 -21.886  13.918  1.00  0.00           C  
ATOM   1569  CG  LYS A 132      64.099 -20.386  13.901  1.00  0.00           C  
ATOM   1570  CD  LYS A 132      65.444 -20.029  14.510  1.00  0.00           C  
ATOM   1571  CE  LYS A 132      65.540 -18.543  14.819  1.00  0.00           C  
ATOM   1572  NZ  LYS A 132      66.613 -18.249  15.808  1.00  0.00           N  
ATOM   1573  H   LYS A 132      63.147 -22.004  11.363  1.00  0.00           H  
ATOM   1574  HA  LYS A 132      65.636 -22.428  12.852  1.00  0.00           H  
ATOM   1575  HB2 LYS A 132      62.798 -22.062  13.830  1.00  0.00           H  
ATOM   1576  HB3 LYS A 132      64.204 -22.274  14.866  1.00  0.00           H  
ATOM   1577  HG2 LYS A 132      64.074 -20.037  12.880  1.00  0.00           H  
ATOM   1578  HG3 LYS A 132      63.318 -19.901  14.469  1.00  0.00           H  
ATOM   1579  HD2 LYS A 132      65.574 -20.585  15.427  1.00  0.00           H  
ATOM   1580  HD3 LYS A 132      66.227 -20.293  13.813  1.00  0.00           H  
ATOM   1581  HE2 LYS A 132      65.750 -18.010  13.904  1.00  0.00           H  
ATOM   1582  HE3 LYS A 132      64.593 -18.210  15.219  1.00  0.00           H  
ATOM   1583  HZ1 LYS A 132      66.835 -19.103  16.359  1.00  0.00           H  
ATOM   1584  HZ2 LYS A 132      66.304 -17.499  16.459  1.00  0.00           H  
ATOM   1585  HZ3 LYS A 132      67.475 -17.934  15.317  1.00  0.00           H  
ATOM   1586  N   THR A 133      63.386 -24.662  12.202  1.00  0.00           N  
ATOM   1587  CA  THR A 133      63.074 -26.085  12.253  1.00  0.00           C  
ATOM   1588  C   THR A 133      63.438 -26.774  10.943  1.00  0.00           C  
ATOM   1589  O   THR A 133      63.177 -27.964  10.761  1.00  0.00           O  
ATOM   1590  CB  THR A 133      61.580 -26.322  12.546  1.00  0.00           C  
ATOM   1591  OG1 THR A 133      60.781 -25.793  11.483  1.00  0.00           O  
ATOM   1592  CG2 THR A 133      61.178 -25.673  13.862  1.00  0.00           C  
ATOM   1593  H   THR A 133      62.865 -24.078  11.611  1.00  0.00           H  
ATOM   1594  HA  THR A 133      63.651 -26.524  13.052  1.00  0.00           H  
ATOM   1595  HB  THR A 133      61.409 -27.387  12.620  1.00  0.00           H  
ATOM   1596  HG1 THR A 133      60.889 -24.839  11.446  1.00  0.00           H  
ATOM   1597 HG21 THR A 133      60.828 -24.669  13.674  1.00  0.00           H  
ATOM   1598 HG22 THR A 133      62.031 -25.640  14.523  1.00  0.00           H  
ATOM   1599 HG23 THR A 133      60.388 -26.250  14.321  1.00  0.00           H  
ATOM   1600  N   LYS A 134      64.045 -26.021  10.032  1.00  0.00           N  
ATOM   1601  CA  LYS A 134      64.448 -26.560   8.738  1.00  0.00           C  
ATOM   1602  C   LYS A 134      63.362 -27.461   8.162  1.00  0.00           C  
ATOM   1603  O   LYS A 134      63.653 -28.438   7.474  1.00  0.00           O  
ATOM   1604  CB  LYS A 134      65.756 -27.341   8.873  1.00  0.00           C  
ATOM   1605  CG  LYS A 134      66.998 -26.488   8.680  1.00  0.00           C  
ATOM   1606  CD  LYS A 134      68.266 -27.276   8.959  1.00  0.00           C  
ATOM   1607  CE  LYS A 134      68.778 -27.970   7.706  1.00  0.00           C  
ATOM   1608  NZ  LYS A 134      69.249 -26.993   6.685  1.00  0.00           N  
ATOM   1609  H   LYS A 134      64.226 -25.079  10.235  1.00  0.00           H  
ATOM   1610  HA  LYS A 134      64.602 -25.729   8.066  1.00  0.00           H  
ATOM   1611  HB2 LYS A 134      65.798 -27.782   9.859  1.00  0.00           H  
ATOM   1612  HB3 LYS A 134      65.768 -28.130   8.135  1.00  0.00           H  
ATOM   1613  HG2 LYS A 134      67.024 -26.134   7.660  1.00  0.00           H  
ATOM   1614  HG3 LYS A 134      66.953 -25.644   9.355  1.00  0.00           H  
ATOM   1615  HD2 LYS A 134      69.028 -26.602   9.320  1.00  0.00           H  
ATOM   1616  HD3 LYS A 134      68.056 -28.023   9.712  1.00  0.00           H  
ATOM   1617  HE2 LYS A 134      69.598 -28.617   7.977  1.00  0.00           H  
ATOM   1618  HE3 LYS A 134      67.978 -28.561   7.284  1.00  0.00           H  
ATOM   1619  HZ1 LYS A 134      70.012 -27.411   6.114  1.00  0.00           H  
ATOM   1620  HZ2 LYS A 134      69.610 -26.136   7.151  1.00  0.00           H  
ATOM   1621  HZ3 LYS A 134      68.466 -26.727   6.055  1.00  0.00           H  
ATOM   1622  N   ASN A 135      62.107 -27.126   8.448  1.00  0.00           N  
ATOM   1623  CA  ASN A 135      60.976 -27.906   7.956  1.00  0.00           C  
ATOM   1624  C   ASN A 135      59.830 -26.994   7.529  1.00  0.00           C  
ATOM   1625  O   ASN A 135      59.834 -25.799   7.819  1.00  0.00           O  
ATOM   1626  CB  ASN A 135      60.495 -28.879   9.034  1.00  0.00           C  
ATOM   1627  CG  ASN A 135      61.189 -30.225   8.952  1.00  0.00           C  
ATOM   1628  OD1 ASN A 135      60.642 -31.186   8.410  1.00  0.00           O  
ATOM   1629  ND2 ASN A 135      62.400 -30.300   9.491  1.00  0.00           N  
ATOM   1630  H   ASN A 135      61.938 -26.336   9.002  1.00  0.00           H  
ATOM   1631  HA  ASN A 135      61.311 -28.471   7.099  1.00  0.00           H  
ATOM   1632  HB2 ASN A 135      60.691 -28.454  10.008  1.00  0.00           H  
ATOM   1633  HB3 ASN A 135      59.432 -29.034   8.922  1.00  0.00           H  
ATOM   1634 HD21 ASN A 135      62.772 -29.494   9.907  1.00  0.00           H  
ATOM   1635 HD22 ASN A 135      62.872 -31.158   9.451  1.00  0.00           H  
ATOM   1636  N   ASN A 136      58.851 -27.568   6.837  1.00  0.00           N  
ATOM   1637  CA  ASN A 136      57.698 -26.807   6.370  1.00  0.00           C  
ATOM   1638  C   ASN A 136      56.534 -26.926   7.349  1.00  0.00           C  
ATOM   1639  O   ASN A 136      56.235 -28.013   7.842  1.00  0.00           O  
ATOM   1640  CB  ASN A 136      57.268 -27.294   4.985  1.00  0.00           C  
ATOM   1641  CG  ASN A 136      58.235 -26.871   3.897  1.00  0.00           C  
ATOM   1642  OD1 ASN A 136      59.321 -27.436   3.763  1.00  0.00           O  
ATOM   1643  ND2 ASN A 136      57.845 -25.874   3.112  1.00  0.00           N  
ATOM   1644  H   ASN A 136      58.905 -28.526   6.637  1.00  0.00           H  
ATOM   1645  HA  ASN A 136      57.992 -25.770   6.302  1.00  0.00           H  
ATOM   1646  HB2 ASN A 136      57.212 -28.373   4.991  1.00  0.00           H  
ATOM   1647  HB3 ASN A 136      56.294 -26.888   4.754  1.00  0.00           H  
ATOM   1648 HD21 ASN A 136      56.966 -25.471   3.277  1.00  0.00           H  
ATOM   1649 HD22 ASN A 136      58.451 -25.581   2.400  1.00  0.00           H  
ATOM   1650  N   TRP A 137      55.882 -25.803   7.623  1.00  0.00           N  
ATOM   1651  CA  TRP A 137      54.750 -25.781   8.543  1.00  0.00           C  
ATOM   1652  C   TRP A 137      53.639 -26.707   8.060  1.00  0.00           C  
ATOM   1653  O   TRP A 137      52.965 -27.355   8.861  1.00  0.00           O  
ATOM   1654  CB  TRP A 137      54.215 -24.358   8.693  1.00  0.00           C  
ATOM   1655  CG  TRP A 137      53.070 -24.250   9.654  1.00  0.00           C  
ATOM   1656  CD1 TRP A 137      51.753 -24.068   9.343  1.00  0.00           C  
ATOM   1657  CD2 TRP A 137      53.141 -24.319  11.082  1.00  0.00           C  
ATOM   1658  NE1 TRP A 137      51.000 -24.017  10.492  1.00  0.00           N  
ATOM   1659  CE2 TRP A 137      51.828 -24.170  11.572  1.00  0.00           C  
ATOM   1660  CE3 TRP A 137      54.185 -24.493  11.995  1.00  0.00           C  
ATOM   1661  CZ2 TRP A 137      51.536 -24.190  12.934  1.00  0.00           C  
ATOM   1662  CZ3 TRP A 137      53.893 -24.513  13.346  1.00  0.00           C  
ATOM   1663  CH2 TRP A 137      52.576 -24.363  13.804  1.00  0.00           C  
ATOM   1664  H   TRP A 137      56.169 -24.967   7.198  1.00  0.00           H  
ATOM   1665  HA  TRP A 137      55.099 -26.129   9.505  1.00  0.00           H  
ATOM   1666  HB2 TRP A 137      55.008 -23.716   9.048  1.00  0.00           H  
ATOM   1667  HB3 TRP A 137      53.876 -24.005   7.730  1.00  0.00           H  
ATOM   1668  HD1 TRP A 137      51.373 -23.975   8.337  1.00  0.00           H  
ATOM   1669  HE1 TRP A 137      50.029 -23.895  10.531  1.00  0.00           H  
ATOM   1670  HE3 TRP A 137      55.205 -24.611  11.660  1.00  0.00           H  
ATOM   1671  HZ2 TRP A 137      50.526 -24.077  13.302  1.00  0.00           H  
ATOM   1672  HZ3 TRP A 137      54.686 -24.646  14.066  1.00  0.00           H  
ATOM   1673  HH2 TRP A 137      52.395 -24.383  14.868  1.00  0.00           H  
ATOM   1674  N   ALA A 138      53.453 -26.765   6.745  1.00  0.00           N  
ATOM   1675  CA  ALA A 138      52.424 -27.614   6.155  1.00  0.00           C  
ATOM   1676  C   ALA A 138      52.779 -29.090   6.303  1.00  0.00           C  
ATOM   1677  O   ALA A 138      51.922 -29.914   6.615  1.00  0.00           O  
ATOM   1678  CB  ALA A 138      52.226 -27.261   4.689  1.00  0.00           C  
ATOM   1679  H   ALA A 138      54.022 -26.225   6.158  1.00  0.00           H  
ATOM   1680  HA  ALA A 138      51.497 -27.423   6.675  1.00  0.00           H  
ATOM   1681  HB1 ALA A 138      51.233 -26.863   4.546  1.00  0.00           H  
ATOM   1682  HB2 ALA A 138      52.956 -26.520   4.396  1.00  0.00           H  
ATOM   1683  HB3 ALA A 138      52.350 -28.147   4.085  1.00  0.00           H  
ATOM   1684  N   GLU A 139      54.048 -29.414   6.075  1.00  0.00           N  
ATOM   1685  CA  GLU A 139      54.515 -30.792   6.182  1.00  0.00           C  
ATOM   1686  C   GLU A 139      55.027 -31.085   7.589  1.00  0.00           C  
ATOM   1687  O   GLU A 139      55.985 -31.837   7.767  1.00  0.00           O  
ATOM   1688  CB  GLU A 139      55.621 -31.059   5.159  1.00  0.00           C  
ATOM   1689  CG  GLU A 139      55.251 -30.652   3.742  1.00  0.00           C  
ATOM   1690  CD  GLU A 139      56.022 -31.430   2.692  1.00  0.00           C  
ATOM   1691  OE1 GLU A 139      57.259 -31.285   2.635  1.00  0.00           O  
ATOM   1692  OE2 GLU A 139      55.384 -32.184   1.927  1.00  0.00           O  
ATOM   1693  H   GLU A 139      54.685 -28.711   5.828  1.00  0.00           H  
ATOM   1694  HA  GLU A 139      53.679 -31.441   5.972  1.00  0.00           H  
ATOM   1695  HB2 GLU A 139      56.505 -30.511   5.450  1.00  0.00           H  
ATOM   1696  HB3 GLU A 139      55.847 -32.116   5.160  1.00  0.00           H  
ATOM   1697  HG2 GLU A 139      54.196 -30.827   3.594  1.00  0.00           H  
ATOM   1698  HG3 GLU A 139      55.462 -29.600   3.617  1.00  0.00           H  
ATOM   1699  N   ARG A 140      54.382 -30.487   8.584  1.00  0.00           N  
ATOM   1700  CA  ARG A 140      54.771 -30.681   9.975  1.00  0.00           C  
ATOM   1701  C   ARG A 140      54.661 -32.152  10.370  1.00  0.00           C  
ATOM   1702  O   ARG A 140      55.212 -32.576  11.386  1.00  0.00           O  
ATOM   1703  CB  ARG A 140      53.897 -29.829  10.897  1.00  0.00           C  
ATOM   1704  CG  ARG A 140      52.448 -30.281  10.952  1.00  0.00           C  
ATOM   1705  CD  ARG A 140      51.591 -29.309  11.748  1.00  0.00           C  
ATOM   1706  NE  ARG A 140      51.666 -29.562  13.184  1.00  0.00           N  
ATOM   1707  CZ  ARG A 140      51.090 -30.600  13.779  1.00  0.00           C  
ATOM   1708  NH1 ARG A 140      50.400 -31.478  13.065  1.00  0.00           N  
ATOM   1709  NH2 ARG A 140      51.204 -30.761  15.092  1.00  0.00           N  
ATOM   1710  H   ARG A 140      53.624 -29.899   8.378  1.00  0.00           H  
ATOM   1711  HA  ARG A 140      55.800 -30.370  10.078  1.00  0.00           H  
ATOM   1712  HB2 ARG A 140      54.303 -29.870  11.897  1.00  0.00           H  
ATOM   1713  HB3 ARG A 140      53.920 -28.807  10.549  1.00  0.00           H  
ATOM   1714  HG2 ARG A 140      52.061 -30.344   9.946  1.00  0.00           H  
ATOM   1715  HG3 ARG A 140      52.402 -31.254  11.419  1.00  0.00           H  
ATOM   1716  HD2 ARG A 140      51.932 -28.304  11.550  1.00  0.00           H  
ATOM   1717  HD3 ARG A 140      50.565 -29.409  11.427  1.00  0.00           H  
ATOM   1718  HE  ARG A 140      52.171 -28.925  13.731  1.00  0.00           H  
ATOM   1719 HH11 ARG A 140      50.312 -31.359  12.076  1.00  0.00           H  
ATOM   1720 HH12 ARG A 140      49.968 -32.261  13.515  1.00  0.00           H  
ATOM   1721 HH21 ARG A 140      51.723 -30.102  15.633  1.00  0.00           H  
ATOM   1722 HH22 ARG A 140      50.770 -31.543  15.538  1.00  0.00           H  
ATOM   1723  N   ASP A 141      53.946 -32.924   9.559  1.00  0.00           N  
ATOM   1724  CA  ASP A 141      53.764 -34.346   9.822  1.00  0.00           C  
ATOM   1725  C   ASP A 141      55.109 -35.063   9.892  1.00  0.00           C  
ATOM   1726  O   ASP A 141      55.344 -35.879  10.784  1.00  0.00           O  
ATOM   1727  CB  ASP A 141      52.891 -34.980   8.738  1.00  0.00           C  
ATOM   1728  CG  ASP A 141      52.297 -36.306   9.174  1.00  0.00           C  
ATOM   1729  OD1 ASP A 141      51.431 -36.302  10.074  1.00  0.00           O  
ATOM   1730  OD2 ASP A 141      52.699 -37.347   8.614  1.00  0.00           O  
ATOM   1731  H   ASP A 141      53.532 -32.528   8.763  1.00  0.00           H  
ATOM   1732  HA  ASP A 141      53.268 -34.447  10.775  1.00  0.00           H  
ATOM   1733  HB2 ASP A 141      52.080 -34.306   8.498  1.00  0.00           H  
ATOM   1734  HB3 ASP A 141      53.488 -35.147   7.854  1.00  0.00           H  
ATOM   1735  N   HIS A 142      55.989 -34.754   8.943  1.00  0.00           N  
ATOM   1736  CA  HIS A 142      57.310 -35.369   8.897  1.00  0.00           C  
ATOM   1737  C   HIS A 142      58.359 -34.448   9.512  1.00  0.00           C  
ATOM   1738  O   HIS A 142      59.500 -34.395   9.052  1.00  0.00           O  
ATOM   1739  CB  HIS A 142      57.690 -35.701   7.454  1.00  0.00           C  
ATOM   1740  CG  HIS A 142      57.851 -34.494   6.583  1.00  0.00           C  
ATOM   1741  ND1 HIS A 142      57.878 -34.556   5.206  1.00  0.00           N  
ATOM   1742  CD2 HIS A 142      57.994 -33.186   6.901  1.00  0.00           C  
ATOM   1743  CE1 HIS A 142      58.031 -33.340   4.714  1.00  0.00           C  
ATOM   1744  NE2 HIS A 142      58.103 -32.489   5.723  1.00  0.00           N  
ATOM   1745  H   HIS A 142      55.742 -34.097   8.259  1.00  0.00           H  
ATOM   1746  HA  HIS A 142      57.270 -36.283   9.469  1.00  0.00           H  
ATOM   1747  HB2 HIS A 142      58.627 -36.240   7.450  1.00  0.00           H  
ATOM   1748  HB3 HIS A 142      56.921 -36.324   7.019  1.00  0.00           H  
ATOM   1749  HD1 HIS A 142      57.798 -35.372   4.669  1.00  0.00           H  
ATOM   1750  HD2 HIS A 142      58.017 -32.766   7.897  1.00  0.00           H  
ATOM   1751  HE1 HIS A 142      58.087 -33.084   3.667  1.00  0.00           H  
ATOM   1752  N   PHE A 143      57.966 -33.725  10.555  1.00  0.00           N  
ATOM   1753  CA  PHE A 143      58.872 -32.805  11.233  1.00  0.00           C  
ATOM   1754  C   PHE A 143      60.139 -33.524  11.686  1.00  0.00           C  
ATOM   1755  O   PHE A 143      60.116 -34.310  12.634  1.00  0.00           O  
ATOM   1756  CB  PHE A 143      58.177 -32.165  12.437  1.00  0.00           C  
ATOM   1757  CG  PHE A 143      59.037 -31.177  13.170  1.00  0.00           C  
ATOM   1758  CD1 PHE A 143      59.957 -31.604  14.114  1.00  0.00           C  
ATOM   1759  CD2 PHE A 143      58.926 -29.819  12.917  1.00  0.00           C  
ATOM   1760  CE1 PHE A 143      60.752 -30.697  14.790  1.00  0.00           C  
ATOM   1761  CE2 PHE A 143      59.717 -28.907  13.589  1.00  0.00           C  
ATOM   1762  CZ  PHE A 143      60.630 -29.346  14.528  1.00  0.00           C  
ATOM   1763  H   PHE A 143      57.043 -33.811  10.876  1.00  0.00           H  
ATOM   1764  HA  PHE A 143      59.143 -32.031  10.532  1.00  0.00           H  
ATOM   1765  HB2 PHE A 143      57.292 -31.648  12.100  1.00  0.00           H  
ATOM   1766  HB3 PHE A 143      57.893 -32.940  13.133  1.00  0.00           H  
ATOM   1767  HD1 PHE A 143      60.053 -32.661  14.320  1.00  0.00           H  
ATOM   1768  HD2 PHE A 143      58.211 -29.474  12.183  1.00  0.00           H  
ATOM   1769  HE1 PHE A 143      61.463 -31.044  15.523  1.00  0.00           H  
ATOM   1770  HE2 PHE A 143      59.620 -27.851  13.383  1.00  0.00           H  
ATOM   1771  HZ  PHE A 143      61.249 -28.636  15.055  1.00  0.00           H  
ATOM   1772  N   VAL A 144      61.245 -33.251  11.001  1.00  0.00           N  
ATOM   1773  CA  VAL A 144      62.523 -33.871  11.332  1.00  0.00           C  
ATOM   1774  C   VAL A 144      63.292 -33.034  12.347  1.00  0.00           C  
ATOM   1775  O   VAL A 144      63.606 -31.870  12.098  1.00  0.00           O  
ATOM   1776  CB  VAL A 144      63.393 -34.065  10.077  1.00  0.00           C  
ATOM   1777  CG1 VAL A 144      64.754 -34.632  10.453  1.00  0.00           C  
ATOM   1778  CG2 VAL A 144      62.689 -34.967   9.074  1.00  0.00           C  
ATOM   1779  H   VAL A 144      61.201 -32.616  10.256  1.00  0.00           H  
ATOM   1780  HA  VAL A 144      62.322 -34.842  11.759  1.00  0.00           H  
ATOM   1781  HB  VAL A 144      63.546 -33.100   9.615  1.00  0.00           H  
ATOM   1782 HG11 VAL A 144      64.620 -35.508  11.070  1.00  0.00           H  
ATOM   1783 HG12 VAL A 144      65.293 -34.901   9.557  1.00  0.00           H  
ATOM   1784 HG13 VAL A 144      65.314 -33.890  11.001  1.00  0.00           H  
ATOM   1785 HG21 VAL A 144      62.620 -35.966   9.476  1.00  0.00           H  
ATOM   1786 HG22 VAL A 144      61.699 -34.585   8.881  1.00  0.00           H  
ATOM   1787 HG23 VAL A 144      63.252 -34.989   8.152  1.00  0.00           H  
ATOM   1788  N   SER A 145      63.594 -33.635  13.494  1.00  0.00           N  
ATOM   1789  CA  SER A 145      64.326 -32.944  14.550  1.00  0.00           C  
ATOM   1790  C   SER A 145      65.830 -33.122  14.374  1.00  0.00           C  
ATOM   1791  O   SER A 145      66.364 -34.216  14.561  1.00  0.00           O  
ATOM   1792  CB  SER A 145      63.896 -33.465  15.922  1.00  0.00           C  
ATOM   1793  OG  SER A 145      64.447 -34.746  16.177  1.00  0.00           O  
ATOM   1794  H   SER A 145      63.316 -34.565  13.634  1.00  0.00           H  
ATOM   1795  HA  SER A 145      64.088 -31.893  14.483  1.00  0.00           H  
ATOM   1796  HB2 SER A 145      64.234 -32.783  16.686  1.00  0.00           H  
ATOM   1797  HB3 SER A 145      62.817 -33.537  15.955  1.00  0.00           H  
ATOM   1798  HG  SER A 145      65.019 -34.701  16.946  1.00  0.00           H  
ATOM   1799  N   HIS A 146      66.510 -32.038  14.013  1.00  0.00           N  
ATOM   1800  CA  HIS A 146      67.955 -32.073  13.812  1.00  0.00           C  
ATOM   1801  C   HIS A 146      68.691 -31.756  15.110  1.00  0.00           C  
ATOM   1802  O   HIS A 146      68.216 -30.993  15.952  1.00  0.00           O  
ATOM   1803  CB  HIS A 146      68.363 -31.080  12.724  1.00  0.00           C  
ATOM   1804  CG  HIS A 146      67.452 -31.085  11.535  1.00  0.00           C  
ATOM   1805  ND1 HIS A 146      67.658 -31.889  10.434  1.00  0.00           N  
ATOM   1806  CD2 HIS A 146      66.326 -30.379  11.280  1.00  0.00           C  
ATOM   1807  CE1 HIS A 146      66.698 -31.676   9.551  1.00  0.00           C  
ATOM   1808  NE2 HIS A 146      65.877 -30.765  10.041  1.00  0.00           N  
ATOM   1809  H   HIS A 146      66.028 -31.195  13.879  1.00  0.00           H  
ATOM   1810  HA  HIS A 146      68.221 -33.070  13.495  1.00  0.00           H  
ATOM   1811  HB2 HIS A 146      68.362 -30.082  13.139  1.00  0.00           H  
ATOM   1812  HB3 HIS A 146      69.359 -31.321  12.382  1.00  0.00           H  
ATOM   1813  HD1 HIS A 146      68.398 -32.519  10.316  1.00  0.00           H  
ATOM   1814  HD2 HIS A 146      65.866 -29.649  11.930  1.00  0.00           H  
ATOM   1815  HE1 HIS A 146      66.600 -32.164   8.594  1.00  0.00           H  
ATOM   1816  N   PRO A 147      69.879 -32.355  15.278  1.00  0.00           N  
ATOM   1817  CA  PRO A 147      70.706 -32.152  16.472  1.00  0.00           C  
ATOM   1818  C   PRO A 147      71.295 -30.747  16.536  1.00  0.00           C  
ATOM   1819  O   PRO A 147      72.155 -30.387  15.732  1.00  0.00           O  
ATOM   1820  CB  PRO A 147      71.819 -33.192  16.313  1.00  0.00           C  
ATOM   1821  CG  PRO A 147      71.906 -33.433  14.846  1.00  0.00           C  
ATOM   1822  CD  PRO A 147      70.507 -33.276  14.317  1.00  0.00           C  
ATOM   1823  HA  PRO A 147      70.152 -32.351  17.377  1.00  0.00           H  
ATOM   1824  HB2 PRO A 147      72.745 -32.795  16.705  1.00  0.00           H  
ATOM   1825  HB3 PRO A 147      71.552 -34.093  16.846  1.00  0.00           H  
ATOM   1826  HG2 PRO A 147      72.562 -32.705  14.392  1.00  0.00           H  
ATOM   1827  HG3 PRO A 147      72.267 -34.433  14.660  1.00  0.00           H  
ATOM   1828  HD2 PRO A 147      70.524 -32.847  13.326  1.00  0.00           H  
ATOM   1829  HD3 PRO A 147      69.999 -34.230  14.308  1.00  0.00           H  
ATOM   1830  N   GLY A 148      70.828 -29.958  17.499  1.00  0.00           N  
ATOM   1831  CA  GLY A 148      71.321 -28.602  17.650  1.00  0.00           C  
ATOM   1832  C   GLY A 148      70.288 -27.562  17.259  1.00  0.00           C  
ATOM   1833  O   GLY A 148      70.200 -26.500  17.876  1.00  0.00           O  
ATOM   1834  H   GLY A 148      70.143 -30.299  18.111  1.00  0.00           H  
ATOM   1835  HA2 GLY A 148      71.602 -28.445  18.682  1.00  0.00           H  
ATOM   1836  HA3 GLY A 148      72.194 -28.476  17.027  1.00  0.00           H  
ATOM   1837  N   LYS A 149      69.505 -27.868  16.230  1.00  0.00           N  
ATOM   1838  CA  LYS A 149      68.474 -26.952  15.756  1.00  0.00           C  
ATOM   1839  C   LYS A 149      67.348 -26.826  16.777  1.00  0.00           C  
ATOM   1840  O   LYS A 149      67.408 -27.413  17.858  1.00  0.00           O  
ATOM   1841  CB  LYS A 149      67.911 -27.436  14.418  1.00  0.00           C  
ATOM   1842  CG  LYS A 149      68.915 -27.382  13.280  1.00  0.00           C  
ATOM   1843  CD  LYS A 149      69.204 -25.950  12.859  1.00  0.00           C  
ATOM   1844  CE  LYS A 149      68.052 -25.361  12.059  1.00  0.00           C  
ATOM   1845  NZ  LYS A 149      68.203 -23.891  11.872  1.00  0.00           N  
ATOM   1846  H   LYS A 149      69.623 -28.730  15.778  1.00  0.00           H  
ATOM   1847  HA  LYS A 149      68.928 -25.984  15.617  1.00  0.00           H  
ATOM   1848  HB2 LYS A 149      67.578 -28.458  14.529  1.00  0.00           H  
ATOM   1849  HB3 LYS A 149      67.064 -26.819  14.153  1.00  0.00           H  
ATOM   1850  HG2 LYS A 149      69.836 -27.844  13.601  1.00  0.00           H  
ATOM   1851  HG3 LYS A 149      68.514 -27.923  12.433  1.00  0.00           H  
ATOM   1852  HD2 LYS A 149      69.359 -25.350  13.742  1.00  0.00           H  
ATOM   1853  HD3 LYS A 149      70.097 -25.937  12.251  1.00  0.00           H  
ATOM   1854  HE2 LYS A 149      68.021 -25.838  11.092  1.00  0.00           H  
ATOM   1855  HE3 LYS A 149      67.129 -25.556  12.586  1.00  0.00           H  
ATOM   1856  HZ1 LYS A 149      68.744 -23.484  12.661  1.00  0.00           H  
ATOM   1857  HZ2 LYS A 149      67.267 -23.438  11.836  1.00  0.00           H  
ATOM   1858  HZ3 LYS A 149      68.704 -23.695  10.983  1.00  0.00           H  
ATOM   1859  N   TYR A 150      66.323 -26.057  16.428  1.00  0.00           N  
ATOM   1860  CA  TYR A 150      65.183 -25.852  17.315  1.00  0.00           C  
ATOM   1861  C   TYR A 150      64.190 -27.005  17.202  1.00  0.00           C  
ATOM   1862  O   TYR A 150      63.951 -27.530  16.113  1.00  0.00           O  
ATOM   1863  CB  TYR A 150      64.487 -24.530  16.989  1.00  0.00           C  
ATOM   1864  CG  TYR A 150      65.057 -23.345  17.736  1.00  0.00           C  
ATOM   1865  CD1 TYR A 150      64.571 -22.990  18.989  1.00  0.00           C  
ATOM   1866  CD2 TYR A 150      66.081 -22.581  17.190  1.00  0.00           C  
ATOM   1867  CE1 TYR A 150      65.088 -21.908  19.674  1.00  0.00           C  
ATOM   1868  CE2 TYR A 150      66.604 -21.498  17.869  1.00  0.00           C  
ATOM   1869  CZ  TYR A 150      66.105 -21.166  19.110  1.00  0.00           C  
ATOM   1870  OH  TYR A 150      66.622 -20.088  19.792  1.00  0.00           O  
ATOM   1871  H   TYR A 150      66.332 -25.616  15.554  1.00  0.00           H  
ATOM   1872  HA  TYR A 150      65.556 -25.811  18.329  1.00  0.00           H  
ATOM   1873  HB2 TYR A 150      64.583 -24.332  15.932  1.00  0.00           H  
ATOM   1874  HB3 TYR A 150      63.440 -24.611  17.242  1.00  0.00           H  
ATOM   1875  HD1 TYR A 150      63.775 -23.574  19.428  1.00  0.00           H  
ATOM   1876  HD2 TYR A 150      66.470 -22.845  16.217  1.00  0.00           H  
ATOM   1877  HE1 TYR A 150      64.696 -21.647  20.647  1.00  0.00           H  
ATOM   1878  HE2 TYR A 150      67.400 -20.916  17.428  1.00  0.00           H  
ATOM   1879  HH  TYR A 150      66.963 -19.447  19.163  1.00  0.00           H  
ATOM   1880  N   THR A 151      63.613 -27.394  18.334  1.00  0.00           N  
ATOM   1881  CA  THR A 151      62.646 -28.484  18.363  1.00  0.00           C  
ATOM   1882  C   THR A 151      61.218 -27.952  18.408  1.00  0.00           C  
ATOM   1883  O   THR A 151      60.994 -26.769  18.671  1.00  0.00           O  
ATOM   1884  CB  THR A 151      62.876 -29.406  19.576  1.00  0.00           C  
ATOM   1885  OG1 THR A 151      63.024 -28.623  20.766  1.00  0.00           O  
ATOM   1886  CG2 THR A 151      64.112 -30.269  19.373  1.00  0.00           C  
ATOM   1887  H   THR A 151      63.845 -26.936  19.170  1.00  0.00           H  
ATOM   1888  HA  THR A 151      62.774 -29.068  17.464  1.00  0.00           H  
ATOM   1889  HB  THR A 151      62.018 -30.053  19.685  1.00  0.00           H  
ATOM   1890  HG1 THR A 151      63.893 -28.214  20.774  1.00  0.00           H  
ATOM   1891 HG21 THR A 151      64.034 -30.793  18.433  1.00  0.00           H  
ATOM   1892 HG22 THR A 151      64.189 -30.984  20.179  1.00  0.00           H  
ATOM   1893 HG23 THR A 151      64.991 -29.641  19.363  1.00  0.00           H  
ATOM   1894  N   LEU A 152      60.256 -28.829  18.149  1.00  0.00           N  
ATOM   1895  CA  LEU A 152      58.848 -28.448  18.161  1.00  0.00           C  
ATOM   1896  C   LEU A 152      58.124 -29.074  19.348  1.00  0.00           C  
ATOM   1897  O   LEU A 152      57.990 -30.296  19.432  1.00  0.00           O  
ATOM   1898  CB  LEU A 152      58.174 -28.872  16.856  1.00  0.00           C  
ATOM   1899  CG  LEU A 152      57.020 -27.989  16.379  1.00  0.00           C  
ATOM   1900  CD1 LEU A 152      56.409 -28.552  15.104  1.00  0.00           C  
ATOM   1901  CD2 LEU A 152      55.964 -27.859  17.466  1.00  0.00           C  
ATOM   1902  H   LEU A 152      60.496 -29.757  17.947  1.00  0.00           H  
ATOM   1903  HA  LEU A 152      58.797 -27.373  18.251  1.00  0.00           H  
ATOM   1904  HB2 LEU A 152      58.927 -28.879  16.082  1.00  0.00           H  
ATOM   1905  HB3 LEU A 152      57.791 -29.874  16.992  1.00  0.00           H  
ATOM   1906  HG  LEU A 152      57.399 -27.001  16.157  1.00  0.00           H  
ATOM   1907 HD11 LEU A 152      56.453 -27.806  14.324  1.00  0.00           H  
ATOM   1908 HD12 LEU A 152      55.379 -28.820  15.288  1.00  0.00           H  
ATOM   1909 HD13 LEU A 152      56.960 -29.429  14.798  1.00  0.00           H  
ATOM   1910 HD21 LEU A 152      55.063 -27.437  17.045  1.00  0.00           H  
ATOM   1911 HD22 LEU A 152      56.331 -27.212  18.249  1.00  0.00           H  
ATOM   1912 HD23 LEU A 152      55.748 -28.834  17.878  1.00  0.00           H  
ATOM   1913  N   ILE A 153      57.656 -28.231  20.262  1.00  0.00           N  
ATOM   1914  CA  ILE A 153      56.942 -28.702  21.442  1.00  0.00           C  
ATOM   1915  C   ILE A 153      55.499 -28.207  21.446  1.00  0.00           C  
ATOM   1916  O   ILE A 153      55.122 -27.359  20.638  1.00  0.00           O  
ATOM   1917  CB  ILE A 153      57.634 -28.244  22.740  1.00  0.00           C  
ATOM   1918  CG1 ILE A 153      58.297 -26.880  22.535  1.00  0.00           C  
ATOM   1919  CG2 ILE A 153      58.659 -29.275  23.186  1.00  0.00           C  
ATOM   1920  CD1 ILE A 153      59.656 -26.962  21.877  1.00  0.00           C  
ATOM   1921  H   ILE A 153      57.794 -27.269  20.139  1.00  0.00           H  
ATOM   1922  HA  ILE A 153      56.940 -29.782  21.420  1.00  0.00           H  
ATOM   1923  HB  ILE A 153      56.883 -28.160  23.510  1.00  0.00           H  
ATOM   1924 HG12 ILE A 153      57.663 -26.269  21.912  1.00  0.00           H  
ATOM   1925 HG13 ILE A 153      58.420 -26.401  23.496  1.00  0.00           H  
ATOM   1926 HG21 ILE A 153      58.910 -29.917  22.353  1.00  0.00           H  
ATOM   1927 HG22 ILE A 153      59.549 -28.772  23.532  1.00  0.00           H  
ATOM   1928 HG23 ILE A 153      58.246 -29.871  23.986  1.00  0.00           H  
ATOM   1929 HD11 ILE A 153      59.872 -26.026  21.381  1.00  0.00           H  
ATOM   1930 HD12 ILE A 153      60.409 -27.152  22.628  1.00  0.00           H  
ATOM   1931 HD13 ILE A 153      59.659 -27.762  21.153  1.00  0.00           H  
ATOM   1932  N   GLU A 154      54.699 -28.741  22.362  1.00  0.00           N  
ATOM   1933  CA  GLU A 154      53.298 -28.352  22.472  1.00  0.00           C  
ATOM   1934  C   GLU A 154      53.006 -27.746  23.842  1.00  0.00           C  
ATOM   1935  O   GLU A 154      51.850 -27.603  24.237  1.00  0.00           O  
ATOM   1936  CB  GLU A 154      52.390 -29.560  22.234  1.00  0.00           C  
ATOM   1937  CG  GLU A 154      52.711 -30.748  23.123  1.00  0.00           C  
ATOM   1938  CD  GLU A 154      51.855 -31.960  22.810  1.00  0.00           C  
ATOM   1939  OE1 GLU A 154      51.854 -32.402  21.643  1.00  0.00           O  
ATOM   1940  OE2 GLU A 154      51.185 -32.467  23.735  1.00  0.00           O  
ATOM   1941  H   GLU A 154      55.058 -29.413  22.978  1.00  0.00           H  
ATOM   1942  HA  GLU A 154      53.099 -27.610  21.714  1.00  0.00           H  
ATOM   1943  HB2 GLU A 154      51.366 -29.267  22.414  1.00  0.00           H  
ATOM   1944  HB3 GLU A 154      52.489 -29.872  21.203  1.00  0.00           H  
ATOM   1945  HG2 GLU A 154      53.748 -31.016  22.986  1.00  0.00           H  
ATOM   1946  HG3 GLU A 154      52.547 -30.466  24.152  1.00  0.00           H  
ATOM   1947  N   VAL A 155      54.066 -27.392  24.562  1.00  0.00           N  
ATOM   1948  CA  VAL A 155      53.925 -26.801  25.888  1.00  0.00           C  
ATOM   1949  C   VAL A 155      53.000 -27.635  26.766  1.00  0.00           C  
ATOM   1950  O   VAL A 155      52.370 -28.582  26.297  1.00  0.00           O  
ATOM   1951  CB  VAL A 155      53.380 -25.362  25.806  1.00  0.00           C  
ATOM   1952  CG1 VAL A 155      51.899 -25.373  25.458  1.00  0.00           C  
ATOM   1953  CG2 VAL A 155      53.623 -24.626  27.115  1.00  0.00           C  
ATOM   1954  H   VAL A 155      54.964 -27.530  24.194  1.00  0.00           H  
ATOM   1955  HA  VAL A 155      54.905 -26.767  26.344  1.00  0.00           H  
ATOM   1956  HB  VAL A 155      53.908 -24.843  25.021  1.00  0.00           H  
ATOM   1957 HG11 VAL A 155      51.436 -24.470  25.831  1.00  0.00           H  
ATOM   1958 HG12 VAL A 155      51.782 -25.423  24.386  1.00  0.00           H  
ATOM   1959 HG13 VAL A 155      51.428 -26.232  25.914  1.00  0.00           H  
ATOM   1960 HG21 VAL A 155      54.482 -25.050  27.613  1.00  0.00           H  
ATOM   1961 HG22 VAL A 155      53.804 -23.581  26.910  1.00  0.00           H  
ATOM   1962 HG23 VAL A 155      52.755 -24.723  27.750  1.00  0.00           H  
ATOM   1963  N   GLN A 156      52.923 -27.276  28.044  1.00  0.00           N  
ATOM   1964  CA  GLN A 156      52.073 -27.992  28.988  1.00  0.00           C  
ATOM   1965  C   GLN A 156      51.170 -27.027  29.748  1.00  0.00           C  
ATOM   1966  O   GLN A 156      51.641 -26.057  30.341  1.00  0.00           O  
ATOM   1967  CB  GLN A 156      52.931 -28.790  29.973  1.00  0.00           C  
ATOM   1968  CG  GLN A 156      53.918 -29.729  29.300  1.00  0.00           C  
ATOM   1969  CD  GLN A 156      55.140 -30.000  30.153  1.00  0.00           C  
ATOM   1970  OE1 GLN A 156      55.439 -29.255  31.086  1.00  0.00           O  
ATOM   1971  NE2 GLN A 156      55.857 -31.073  29.837  1.00  0.00           N  
ATOM   1972  H   GLN A 156      53.450 -26.513  28.359  1.00  0.00           H  
ATOM   1973  HA  GLN A 156      51.457 -28.677  28.426  1.00  0.00           H  
ATOM   1974  HB2 GLN A 156      53.487 -28.099  30.590  1.00  0.00           H  
ATOM   1975  HB3 GLN A 156      52.280 -29.378  30.603  1.00  0.00           H  
ATOM   1976  HG2 GLN A 156      53.422 -30.668  29.099  1.00  0.00           H  
ATOM   1977  HG3 GLN A 156      54.237 -29.286  28.368  1.00  0.00           H  
ATOM   1978 HE21 GLN A 156      55.561 -31.621  29.079  1.00  0.00           H  
ATOM   1979 HE22 GLN A 156      56.653 -31.272  30.371  1.00  0.00           H  
ATOM   1980  N   ALA A 157      49.870 -27.299  29.725  1.00  0.00           N  
ATOM   1981  CA  ALA A 157      48.899 -26.456  30.412  1.00  0.00           C  
ATOM   1982  C   ALA A 157      49.079 -26.534  31.925  1.00  0.00           C  
ATOM   1983  O   ALA A 157      49.550 -25.586  32.553  1.00  0.00           O  
ATOM   1984  CB  ALA A 157      47.484 -26.857  30.025  1.00  0.00           C  
ATOM   1985  H   ALA A 157      49.555 -28.087  29.234  1.00  0.00           H  
ATOM   1986  HA  ALA A 157      49.059 -25.436  30.093  1.00  0.00           H  
ATOM   1987  HB1 ALA A 157      47.321 -26.636  28.981  1.00  0.00           H  
ATOM   1988  HB2 ALA A 157      47.351 -27.915  30.196  1.00  0.00           H  
ATOM   1989  HB3 ALA A 157      46.776 -26.304  30.626  1.00  0.00           H  
TER    1990      ALA A 157                                                      
END
MOLECULE T0446_9_70.pdb
ATOM      5  N   GLY     9      65.185 -29.612  12.805  1.00 60.87           N  
ATOM      6  CA  GLY     9      64.461 -29.375  14.061  1.00 59.52           C  
ATOM      7  C   GLY     9      62.984 -29.191  13.759  1.00 57.77           C  
ATOM      8  O   GLY     9      62.643 -28.728  12.672  1.00 57.61           O  
ATOM      9  N   ASN    10      62.114 -29.563  14.705  1.00 55.20           N  
ATOM     10  CA  ASN    10      60.651 -29.470  14.527  1.00 53.29           C  
ATOM     11  C   ASN    10      60.014 -28.305  15.312  1.00 52.05           C  
ATOM     12  O   ASN    10      60.425 -27.996  16.430  1.00 52.82           O  
ATOM     13  CB  ASN    10      59.961 -30.783  14.932  1.00 52.26           C  
ATOM     14  CG  ASN    10      60.368 -31.975  14.048  1.00 53.17           C  
ATOM     15  OD1 ASN    10      60.525 -31.847  12.834  1.00 52.31           O  
ATOM     16  ND2 ASN    10      60.516 -33.139  14.663  1.00 52.23           N  
ATOM     17  N   ALA    11      59.012 -27.666  14.710  1.00 49.77           N  
ATOM     18  CA  ALA    11      58.198 -26.655  15.395  1.00 48.15           C  
ATOM     19  C   ALA    11      56.922 -27.335  15.898  1.00 45.50           C  
ATOM     20  O   ALA    11      56.339 -28.180  15.200  1.00 46.35           O  
ATOM     21  CB  ALA    11      57.864 -25.490  14.458  1.00 45.83           C  
ATOM     22  N   ALA    12      56.518 -26.982  17.115  1.00 42.12           N  
ATOM     23  CA  ALA    12      55.301 -27.490  17.736  1.00 40.00           C  
ATOM     24  C   ALA    12      54.252 -26.375  17.772  1.00 39.55           C  
ATOM     25  O   ALA    12      54.566 -25.236  18.129  1.00 35.98           O  
ATOM     26  CB  ALA    12      55.605 -27.961  19.142  1.00 38.33           C  
ATOM     27  N   GLU    13      53.023 -26.699  17.394  1.00 40.63           N  
ATOM     28  CA  GLU    13      51.913 -25.749  17.482  1.00 42.72           C  
ATOM     29  C   GLU    13      51.523 -25.518  18.950  1.00 42.02           C  
ATOM     30  O   GLU    13      51.506 -26.452  19.742  1.00 42.03           O  
ATOM     31  CB  GLU    13      50.717 -26.254  16.671  1.00 42.21           C  
ATOM     32  CG  GLU    13      49.860 -25.143  16.068  1.00 47.11           C  
ATOM     33  CD  GLU    13      48.729 -25.671  15.169  1.00 49.32           C  
ATOM     34  OE1 GLU    13      48.950 -26.674  14.442  1.00 52.36           O  
ATOM     35  OE2 GLU    13      47.614 -25.083  15.200  1.00 59.57           O  
ATOM     36  N   VAL    14      51.230 -24.268  19.301  1.00 40.63           N  
ATOM     37  CA  VAL    14      50.890 -23.890  20.675  1.00 37.77           C  
ATOM     38  C   VAL    14      49.390 -23.660  20.813  1.00 36.42           C  
ATOM     39  O   VAL    14      48.761 -23.060  19.946  1.00 36.60           O  
ATOM     40  CB  VAL    14      51.644 -22.622  21.110  1.00 38.62           C  
ATOM     41  CG1 VAL    14      51.241 -22.212  22.518  1.00 33.88           C  
ATOM     42  CG2 VAL    14      53.152 -22.846  21.033  1.00 35.50           C  
ATOM     43  N   ASN    15      48.812 -24.153  21.900  1.00 34.06           N  
ATOM     44  CA  ASN    15      47.407 -23.957  22.158  1.00 33.88           C  
ATOM     45  C   ASN    15      47.083 -22.479  22.334  1.00 33.04           C  
ATOM     46  O   ASN    15      47.602 -21.847  23.255  1.00 32.42           O  
ATOM     47  CB  ASN    15      46.994 -24.708  23.418  1.00 35.53           C  
ATOM     48  CG  ASN    15      45.527 -24.540  23.733  1.00 37.44           C  
ATOM     49  OD1 ASN    15      45.120 -23.520  24.243  1.00 37.41           O  
ATOM     50  ND2 ASN    15      44.729 -25.556  23.423  1.00 43.93           N  
ATOM     51  N   LEU    16      46.207 -21.958  21.483  1.00 31.24           N  
ATOM     52  CA  LEU    16      45.931 -20.529  21.429  1.00 33.01           C  
ATOM     53  C   LEU    16      45.005 -20.054  22.541  1.00 32.25           C  
ATOM     54  O   LEU    16      44.996 -18.881  22.845  1.00 32.26           O  
ATOM     55  CB  LEU    16      45.328 -20.148  20.075  1.00 34.27           C  
ATOM     56  CG  LEU    16      46.190 -20.305  18.818  1.00 34.50           C  
ATOM     57  CD1 LEU    16      45.443 -19.732  17.607  1.00 34.58           C  
ATOM     58  CD2 LEU    16      47.568 -19.650  18.992  1.00 33.93           C  
ATOM     59  N   ASP    17      44.236 -20.949  23.151  1.00 32.19           N  
ATOM     60  CA  ASP    17      43.394 -20.576  24.279  1.00 32.48           C  
ATOM     61  C   ASP    17      44.231 -20.282  25.513  1.00 32.65           C  
ATOM     62  O   ASP    17      44.037 -19.269  26.162  1.00 30.88           O  
ATOM     63  CB  ASP    17      42.382 -21.674  24.594  1.00 35.60           C  
ATOM     64  CG  ASP    17      41.437 -21.931  23.455  1.00 35.99           C  
ATOM     65  OD1 ASP    17      40.779 -20.971  23.006  1.00 38.81           O  
ATOM     66  OD2 ASP    17      41.367 -23.092  23.003  1.00 50.00           O  
ATOM     67  N   GLU    18      45.170 -21.165  25.820  1.00 32.04           N  
ATOM     68  CA  GLU    18      46.071 -20.942  26.935  1.00 34.74           C  
ATOM     69  C   GLU    18      46.977 -19.765  26.654  1.00 31.75           C  
ATOM     70  O   GLU    18      47.183 -18.936  27.543  1.00 30.78           O  
ATOM     71  CB  GLU    18      46.900 -22.196  27.222  1.00 34.77           C  
ATOM     72  CG  GLU    18      46.059 -23.376  27.751  1.00 42.03           C  
ATOM     73  CD  GLU    18      46.796 -24.726  27.729  1.00 43.33           C  
ATOM     74  OE1 GLU    18      47.977 -24.782  27.337  1.00 54.77           O  
ATOM     75  OE2 GLU    18      46.183 -25.752  28.110  1.00 57.13           O  
ATOM     76  N   LEU    19      47.485 -19.658  25.420  1.00 30.67           N  
ATOM     77  CA  LEU    19      48.438 -18.570  25.070  1.00 30.07           C  
ATOM     78  C   LEU    19      47.779 -17.220  25.227  1.00 30.04           C  
ATOM     79  O   LEU    19      48.381 -16.277  25.748  1.00 30.43           O  
ATOM     80  CB  LEU    19      48.997 -18.734  23.646  1.00 29.84           C  
ATOM     81  CG  LEU    19      50.144 -17.827  23.208  1.00 29.31           C  
ATOM     82  CD1 LEU    19      51.284 -17.839  24.240  1.00 31.63           C  
ATOM     83  CD2 LEU    19      50.653 -18.189  21.806  1.00 25.27           C  
ATOM     84  N   ALA    20      46.525 -17.150  24.806  1.00 29.97           N  
ATOM     85  CA  ALA    20      45.729 -15.924  24.888  1.00 31.22           C  
ATOM     86  C   ALA    20      45.521 -15.475  26.334  1.00 30.56           C  
ATOM     87  O   ALA    20      45.505 -14.283  26.629  1.00 32.27           O  
ATOM     88  CB  ALA    20      44.375 -16.146  24.203  1.00 30.51           C  
ATOM     89  N   GLN    21      45.343 -16.432  27.233  1.00 31.77           N  
ATOM     90  CA  GLN    21      45.207 -16.143  28.663  1.00 30.90           C  
ATOM     91  C   GLN    21      46.536 -15.649  29.217  1.00 30.39           C  
ATOM     92  O   GLN    21      46.576 -14.712  30.011  1.00 32.04           O  
ATOM     93  CB  GLN    21      44.717 -17.404  29.411  1.00 32.37           C  
ATOM     94  CG  GLN    21      44.695 -17.283  30.920  1.00 42.11           C  
ATOM     95  N   GLU    22      47.636 -16.241  28.772  1.00 29.04           N  
ATOM     96  CA  GLU    22      48.951 -15.875  29.310  1.00 27.71           C  
ATOM     97  C   GLU    22      49.502 -14.569  28.735  1.00 30.62           C  
ATOM     98  O   GLU    22      50.216 -13.818  29.441  1.00 30.38           O  
ATOM     99  CB  GLU    22      49.911 -17.020  29.090  1.00 27.03           C  
ATOM    100  CG  GLU    22      49.492 -18.259  29.869  1.00 33.36           C  
ATOM    101  CD  GLU    22      50.401 -19.423  29.682  1.00 36.56           C  
ATOM    102  OE1 GLU    22      51.620 -19.193  29.452  1.00 42.93           O  
ATOM    103  OE2 GLU    22      49.905 -20.578  29.799  1.00 37.90           O  
ATOM    104  N   LEU    23      49.169 -14.279  27.470  1.00 29.30           N  
ATOM    105  CA  LEU    23      49.631 -13.056  26.825  1.00 29.17           C  
ATOM    106  C   LEU    23      48.642 -11.915  26.932  1.00 30.25           C  
ATOM    107  O   LEU    23      48.992 -10.772  26.663  1.00 32.08           O  
ATOM    108  CB  LEU    23      49.935 -13.315  25.356  1.00 29.09           C  
ATOM    109  CG  LEU    23      51.089 -14.251  25.075  1.00 30.17           C  
ATOM    110  CD1 LEU    23      51.295 -14.407  23.565  1.00 31.18           C  
ATOM    111  CD2 LEU    23      52.365 -13.776  25.805  1.00 27.85           C  
ATOM    112  N   GLY    24      47.408 -12.223  27.309  1.00 30.92           N  
ATOM    113  CA  GLY    24      46.347 -11.247  27.430  1.00 30.54           C  
ATOM    114  C   GLY    24      46.758  -9.901  27.994  1.00 31.61           C  
ATOM    115  O   GLY    24      46.393  -8.876  27.436  1.00 30.61           O  
ATOM    116  N   PRO    25      47.494  -9.889  29.125  1.00 30.78           N  
ATOM    117  CA  PRO    25      47.913  -8.620  29.713  1.00 29.71           C  
ATOM    118  C   PRO    25      48.754  -7.681  28.835  1.00 30.41           C  
ATOM    119  O   PRO    25      48.751  -6.495  29.105  1.00 30.79           O  
ATOM    120  CB  PRO    25      48.729  -9.065  30.930  1.00 29.78           C  
ATOM    121  CG  PRO    25      48.166 -10.377  31.282  1.00 32.86           C  
ATOM    122  CD  PRO    25      47.910 -11.019  29.970  1.00 31.91           C  
ATOM    123  N   ILE    26      49.481  -8.189  27.836  1.00 29.88           N  
ATOM    124  CA  ILE    26      50.311  -7.331  26.939  1.00 27.57           C  
ATOM    125  C   ILE    26      49.696  -7.214  25.528  1.00 29.15           C  
ATOM    126  O   ILE    26      50.237  -6.558  24.634  1.00 29.64           O  
ATOM    127  CB  ILE    26      51.795  -7.772  26.920  1.00 27.40           C  
ATOM    128  CG1 ILE    26      52.030  -9.205  26.461  1.00 28.86           C  
ATOM    129  CG2 ILE    26      52.382  -7.701  28.367  1.00 27.44           C  
ATOM    130  CD1 ILE    26      51.852  -9.499  24.971  1.00 34.86           C  
ATOM    131  N   MET    27      48.551  -7.848  25.344  1.00 31.06           N  
ATOM    132  CA  MET    27      47.818  -7.785  24.090  1.00 31.64           C  
ATOM    133  C   MET    27      46.949  -6.543  24.019  1.00 29.78           C  
ATOM    134  O   MET    27      46.490  -6.026  25.053  1.00 29.97           O  
ATOM    135  CB  MET    27      46.958  -9.038  23.926  1.00 30.84           C  
ATOM    136  CG  MET    27      47.764 -10.254  23.491  1.00 32.59           C  
ATOM    137  SD  MET    27      46.672 -11.860  23.482  0.75 35.14          SE  
ATOM    138  CE  MET    27      45.480 -11.416  21.918  1.00 32.37           C  
ATOM    139  N   GLY    28      46.702  -6.069  22.799  1.00 28.32           N  
ATOM    140  CA  GLY    28      45.767  -4.966  22.580  1.00 29.27           C  
ATOM    141  C   GLY    28      44.343  -5.406  22.889  1.00 31.94           C  
ATOM    142  O   GLY    28      44.034  -6.593  22.801  1.00 32.50           O  
ATOM    143  N   ASP    29      43.478  -4.449  23.232  1.00 32.77           N  
ATOM    144  CA  ASP    29      42.073  -4.713  23.559  1.00 34.58           C  
ATOM    145  C   ASP    29      41.351  -5.497  22.450  1.00 35.87           C  
ATOM    146  O   ASP    29      40.587  -6.400  22.741  1.00 39.58           O  
ATOM    147  CB  ASP    29      41.286  -3.411  23.802  1.00 34.46           C  
ATOM    148  CG  ASP    29      41.745  -2.633  25.038  1.00 37.07           C  
ATOM    149  OD1 ASP    29      42.465  -3.173  25.898  1.00 37.61           O  
ATOM    150  OD2 ASP    29      41.381  -1.434  25.124  1.00 44.68           O  
ATOM    151  N   ASN    30      41.580  -5.136  21.193  1.00 35.57           N  
ATOM    152  CA  ASN    30      40.959  -5.818  20.047  1.00 37.83           C  
ATOM    153  C   ASN    30      41.907  -6.777  19.279  1.00 36.99           C  
ATOM    154  O   ASN    30      41.725  -7.048  18.082  1.00 37.90           O  
ATOM    155  CB  ASN    30      40.408  -4.760  19.085  1.00 40.16           C  
ATOM    156  CG  ASN    30      39.472  -3.749  19.782  1.00 50.83           C  
ATOM    157  OD1 ASN    30      38.693  -4.105  20.683  1.00 53.38           O  
ATOM    158  ND2 ASN    30      39.556  -2.484  19.364  1.00 57.62           N  
ATOM    159  N   GLU    31      42.917  -7.298  19.973  1.00 33.17           N  
ATOM    160  CA  GLU    31      43.866  -8.192  19.356  1.00 30.29           C  
ATOM    161  C   GLU    31      43.462  -9.640  19.573  1.00 29.50           C  
ATOM    162  O   GLU    31      43.000 -10.022  20.652  1.00 27.97           O  
ATOM    163  CB  GLU    31      45.260  -7.965  19.936  1.00 28.92           C  
ATOM    164  CG  GLU    31      46.361  -8.680  19.151  1.00 28.18           C  
ATOM    165  CD  GLU    31      47.734  -8.228  19.562  1.00 28.59           C  
ATOM    166  OE1 GLU    31      47.887  -7.721  20.712  1.00 28.28           O  
ATOM    167  OE2 GLU    31      48.671  -8.396  18.748  1.00 30.08           O  
ATOM    168  N   GLN    32      43.663 -10.442  18.536  1.00 29.95           N  
ATOM    169  CA  GLN    32      43.384 -11.871  18.580  1.00 30.19           C  
ATOM    170  C   GLN    32      44.564 -12.658  18.060  1.00 29.38           C  
ATOM    171  O   GLN    32      45.280 -12.223  17.161  1.00 27.54           O  
ATOM    172  CB  GLN    32      42.156 -12.191  17.749  1.00 29.37           C  
ATOM    173  CG  GLN    32      40.886 -11.656  18.349  1.00 38.86           C  
ATOM    174  CD  GLN    32      39.686 -12.111  17.575  1.00 48.30           C  
ATOM    175  OE1 GLN    32      39.096 -11.329  16.829  1.00 53.49           O  
ATOM    176  NE2 GLN    32      39.339 -13.400  17.703  1.00 44.10           N  
ATOM    177  N   LEU    33      44.745 -13.847  18.626  1.00 30.24           N  
ATOM    178  CA  LEU    33      45.794 -14.753  18.184  1.00 30.31           C  
ATOM    179  C   LEU    33      45.333 -15.563  16.985  1.00 29.00           C  
ATOM    180  O   LEU    33      44.192 -16.012  16.938  1.00 28.70           O  
ATOM    181  CB  LEU    33      46.199 -15.677  19.328  1.00 29.81           C  
ATOM    182  CG  LEU    33      46.748 -14.978  20.574  1.00 32.58           C  
ATOM    183  CD1 LEU    33      47.196 -16.058  21.500  1.00 28.01           C  
ATOM    184  CD2 LEU    33      47.890 -14.036  20.289  1.00 31.90           C  
ATOM    185  N   ALA    34      46.197 -15.717  15.991  1.00 27.96           N  
ATOM    186  CA  ALA    34      45.836 -16.491  14.792  1.00 30.62           C  
ATOM    187  C   ALA    34      46.559 -17.833  14.765  1.00 30.42           C  
ATOM    188  O   ALA    34      46.006 -18.860  14.353  1.00 28.34           O  
ATOM    189  CB  ALA    34      46.123 -15.678  13.473  1.00 28.64           C  
ATOM    190  N   LEU    35      47.805 -17.819  15.205  1.00 29.05           N  
ATOM    191  CA  LEU    35      48.680 -18.949  15.009  1.00 29.50           C  
ATOM    192  C   LEU    35      49.915 -18.789  15.876  1.00 28.92           C  
ATOM    193  O   LEU    35      50.457 -17.688  15.998  1.00 27.72           O  
ATOM    194  CB  LEU    35      49.077 -18.981  13.542  1.00 31.93           C  
ATOM    195  CG  LEU    35      49.742 -20.189  12.917  1.00 35.04           C  
ATOM    196  CD1 LEU    35      48.962 -21.506  13.182  1.00 38.57           C  
ATOM    197  CD2 LEU    35      49.850 -19.879  11.433  1.00 36.70           C  
ATOM    198  N   ALA    36      50.387 -19.888  16.457  1.00 26.00           N  
ATOM    199  CA  ALA    36      51.602 -19.829  17.208  1.00 26.36           C  
ATOM    200  C   ALA    36      52.398 -21.115  17.200  1.00 26.82           C  
ATOM    201  O   ALA    36      51.850 -22.198  17.333  1.00 25.24           O  
ATOM    202  CB  ALA    36      51.327 -19.382  18.648  1.00 25.51           C  
ATOM    203  N   TYR    37      53.718 -20.956  17.077  1.00 26.47           N  
ATOM    204  CA  TYR    37      54.626 -22.089  17.064  1.00 27.81           C  
ATOM    205  C   TYR    37      55.699 -21.936  18.146  1.00 28.83           C  
ATOM    206  O   TYR    37      56.197 -20.845  18.417  1.00 28.58           O  
ATOM    207  CB  TYR    37      55.281 -22.242  15.691  1.00 28.27           C  
ATOM    208  CG  TYR    37      54.308 -22.558  14.585  1.00 28.64           C  
ATOM    209  CD1 TYR    37      53.787 -23.844  14.442  1.00 30.62           C  
ATOM    210  CD2 TYR    37      53.887 -21.578  13.688  1.00 31.83           C  
ATOM    211  CE1 TYR    37      52.866 -24.148  13.426  1.00 30.92           C  
ATOM    212  CE2 TYR    37      52.970 -21.886  12.650  1.00 32.26           C  
ATOM    213  CZ  TYR    37      52.467 -23.160  12.540  1.00 31.17           C  
ATOM    214  OH  TYR    37      51.557 -23.480  11.544  1.00 37.96           O  
ATOM    215  N   ARG    38      56.061 -23.057  18.748  1.00 29.59           N  
ATOM    216  CA  ARG    38      57.211 -23.114  19.624  1.00 31.93           C  
ATOM    217  C   ARG    38      58.388 -23.872  18.988  1.00 32.07           C  
ATOM    218  O   ARG    38      58.234 -24.897  18.322  1.00 32.21           O  
ATOM    219  CB  ARG    38      56.822 -23.759  20.946  1.00 33.38           C  
ATOM    220  CG  ARG    38      57.843 -23.520  22.054  1.00 39.14           C  
ATOM    221  CD  ARG    38      57.762 -24.582  23.122  1.00 48.81           C  
ATOM    222  NE  ARG    38      56.793 -24.280  24.161  1.00 51.66           N  
ATOM    223  CZ  ARG    38      55.529 -24.684  24.163  1.00 55.61           C  
ATOM    224  NH1 ARG    38      55.039 -25.411  23.159  1.00 59.48           N  
ATOM    225  NH2 ARG    38      54.751 -24.347  25.181  1.00 52.27           N  
ATOM    226  N   VAL    39      59.579 -23.348  19.184  1.00 32.67           N  
ATOM    227  CA  VAL    39      60.788 -24.084  18.841  1.00 33.79           C  
ATOM    228  C   VAL    39      61.618 -24.110  20.121  1.00 34.37           C  
ATOM    229  O   VAL    39      62.196 -23.097  20.514  1.00 35.08           O  
ATOM    230  CB  VAL    39      61.557 -23.468  17.631  1.00 32.80           C  
ATOM    231  CG1 VAL    39      62.871 -24.228  17.388  1.00 33.25           C  
ATOM    232  CG2 VAL    39      60.697 -23.525  16.386  1.00 35.00           C  
ATOM    233  N   ILE    40      61.613 -25.265  20.788  1.00 34.65           N  
ATOM    234  CA  ILE    40      62.264 -25.452  22.095  1.00 36.62           C  
ATOM    235  C   ILE    40      61.657 -24.485  23.132  1.00 34.68           C  
ATOM    236  O   ILE    40      60.539 -24.701  23.582  1.00 34.13           O  
ATOM    237  CB  ILE    40      63.824 -25.387  22.019  1.00 38.36           C  
ATOM    238  CG1 ILE    40      64.365 -26.358  20.954  1.00 43.53           C  
ATOM    239  CG2 ILE    40      64.429 -25.782  23.363  1.00 40.40           C  
ATOM    240  CD1 ILE    40      65.763 -25.997  20.421  1.00 40.40           C  
ATOM    241  N   ARG    41      62.357 -23.419  23.507  1.00 33.68           N  
ATOM    242  CA  ARG    41      61.806 -22.442  24.463  1.00 34.26           C  
ATOM    243  C   ARG    41      61.242 -21.171  23.802  1.00 32.54           C  
ATOM    244  O   ARG    41      60.541 -20.393  24.445  1.00 34.61           O  
ATOM    245  CB  ARG    41      62.879 -21.980  25.436  1.00 34.70           C  
ATOM    246  CG  ARG    41      63.597 -23.055  26.161  1.00 37.86           C  
ATOM    247  CD  ARG    41      64.516 -22.440  27.219  1.00 40.35           C  
ATOM    248  NE  ARG    41      65.529 -21.523  26.666  1.00 39.77           N  
ATOM    249  CZ  ARG    41      66.724 -21.315  27.228  1.00 39.80           C  
ATOM    250  NH1 ARG    41      67.050 -21.929  28.361  1.00 35.97           N  
ATOM    251  NH2 ARG    41      67.594 -20.488  26.670  1.00 31.93           N  
ATOM    252  N   ASP    42      61.585 -20.951  22.545  1.00 29.33           N  
ATOM    253  CA  ASP    42      61.232 -19.738  21.831  1.00 30.54           C  
ATOM    254  C   ASP    42      59.881 -19.918  21.142  1.00 30.37           C  
ATOM    255  O   ASP    42      59.463 -21.036  20.858  1.00 30.57           O  
ATOM    256  CB  ASP    42      62.319 -19.405  20.805  1.00 29.08           C  
ATOM    257  CG  ASP    42      63.675 -19.131  21.445  1.00 35.53           C  
ATOM    258  OD1 ASP    42      63.723 -18.839  22.665  1.00 33.19           O  
ATOM    259  OD2 ASP    42      64.705 -19.209  20.729  1.00 40.83           O  
ATOM    260  N   MET    43      59.199 -18.806  20.902  1.00 29.53           N  
ATOM    261  CA  MET    43      57.899 -18.801  20.272  1.00 33.10           C  
ATOM    262  C   MET    43      57.786 -17.741  19.205  1.00 29.59           C  
ATOM    263  O   MET    43      58.364 -16.654  19.304  1.00 31.23           O  
ATOM    264  CB  MET    43      56.815 -18.561  21.301  1.00 31.88           C  
ATOM    265  CG  MET    43      56.082 -19.773  21.698  1.00 41.39           C  
ATOM    266  SD  MET    43      54.583 -19.260  22.789  0.75 44.15          SE  
ATOM    267  CE  MET    43      54.929 -20.493  24.116  1.00 39.34           C  
ATOM    268  N   PHE    44      57.042 -18.095  18.167  1.00 29.00           N  
ATOM    269  CA  PHE    44      56.722 -17.213  17.071  1.00 28.77           C  
ATOM    270  C   PHE    44      55.190 -17.112  17.021  1.00 29.74           C  
ATOM    271  O   PHE    44      54.499 -18.098  16.729  1.00 30.01           O  
ATOM    272  CB  PHE    44      57.282 -17.836  15.807  1.00 30.56           C  
ATOM    273  CG  PHE    44      57.484 -16.877  14.696  1.00 32.68           C  
ATOM    274  CD1 PHE    44      56.436 -16.470  13.921  1.00 40.05           C  
ATOM    275  CD2 PHE    44      58.737 -16.371  14.427  1.00 39.89           C  
ATOM    276  CE1 PHE    44      56.629 -15.576  12.869  1.00 38.52           C  
ATOM    277  CE2 PHE    44      58.931 -15.475  13.376  1.00 38.67           C  
ATOM    278  CZ  PHE    44      57.865 -15.098  12.592  1.00 35.49           C  
ATOM    279  N   VAL    45      54.657 -15.937  17.355  1.00 27.56           N  
ATOM    280  CA  VAL    45      53.215 -15.790  17.522  1.00 28.26           C  
ATOM    281  C   VAL    45      52.675 -14.862  16.445  1.00 27.06           C  
ATOM    282  O   VAL    45      53.233 -13.789  16.221  1.00 27.80           O  
ATOM    283  CB  VAL    45      52.890 -15.282  18.925  1.00 27.14           C  
ATOM    284  CG1 VAL    45      51.361 -15.110  19.124  1.00 23.97           C  
ATOM    285  CG2 VAL    45      53.477 -16.246  19.943  1.00 24.77           C  
ATOM    286  N   PHE    46      51.654 -15.322  15.738  1.00 25.28           N  
ATOM    287  CA  PHE    46      50.933 -14.480  14.779  1.00 26.22           C  
ATOM    288  C   PHE    46      49.657 -14.017  15.411  1.00 25.97           C  
ATOM    289  O   PHE    46      48.792 -14.832  15.732  1.00 24.46           O  
ATOM    290  CB  PHE    46      50.565 -15.239  13.507  1.00 25.83           C  
ATOM    291  CG  PHE    46      51.729 -15.729  12.736  1.00 26.44           C  
ATOM    292  CD1 PHE    46      52.428 -16.870  13.152  1.00 33.54           C  
ATOM    293  CD2 PHE    46      52.122 -15.083  11.572  1.00 31.14           C  
ATOM    294  CE1 PHE    46      53.521 -17.335  12.424  1.00 31.61           C  
ATOM    295  CE2 PHE    46      53.214 -15.538  10.832  1.00 30.46           C  
ATOM    296  CZ  PHE    46      53.908 -16.657  11.251  1.00 32.65           C  
ATOM    297  N   THR    47      49.525 -12.711  15.596  1.00 26.48           N  
ATOM    298  CA  THR    47      48.247 -12.146  15.980  1.00 25.78           C  
ATOM    299  C   THR    47      47.572 -11.540  14.737  1.00 26.06           C  
ATOM    300  O   THR    47      48.073 -11.664  13.619  1.00 25.84           O  
ATOM    301  CB  THR    47      48.401 -11.146  17.110  1.00 24.21           C  
ATOM    302  OG1 THR    47      48.626  -9.819  16.579  1.00 24.94           O  
ATOM    303  CG2 THR    47      49.514 -11.595  18.070  1.00 22.98           C  
ATOM    304  N   ASN    48      46.414 -10.923  14.908  1.00 27.66           N  
ATOM    305  CA  ASN    48      45.837 -10.172  13.790  1.00 28.00           C  
ATOM    306  C   ASN    48      46.465  -8.771  13.558  1.00 28.75           C  
ATOM    307  O   ASN    48      46.083  -8.081  12.625  1.00 27.02           O  
ATOM    308  CB  ASN    48      44.310 -10.085  13.891  1.00 27.80           C  
ATOM    309  CG  ASN    48      43.834  -9.365  15.101  1.00 30.65           C  
ATOM    310  OD1 ASN    48      44.560  -9.170  16.079  1.00 27.46           O  
ATOM    311  ND2 ASN    48      42.582  -8.966  15.058  1.00 32.05           N  
ATOM    312  N   LYS    49      47.414  -8.373  14.401  1.00 29.97           N  
ATOM    313  CA  LYS    49      48.050  -7.044  14.362  1.00 29.05           C  
ATOM    314  C   LYS    49      49.577  -7.072  14.225  1.00 27.69           C  
ATOM    315  O   LYS    49      50.189  -6.095  13.795  1.00 25.55           O  
ATOM    316  CB  LYS    49      47.745  -6.312  15.651  1.00 29.91           C  
ATOM    317  CG  LYS    49      46.293  -6.201  16.012  1.00 32.58           C  
ATOM    318  CD  LYS    49      45.605  -5.135  15.243  1.00 40.52           C  
ATOM    319  CE  LYS    49      44.240  -4.850  15.839  1.00 46.49           C  
ATOM    320  NZ  LYS    49      43.305  -4.508  14.762  1.00 47.89           N  
ATOM    321  N   ARG    50      50.196  -8.159  14.650  1.00 25.39           N  
ATOM    322  CA  ARG    50      51.658  -8.219  14.705  1.00 25.08           C  
ATOM    323  C   ARG    50      52.156  -9.637  14.821  1.00 24.78           C  
ATOM    324  O   ARG    50      51.416 -10.546  15.162  1.00 24.93           O  
ATOM    325  CB  ARG    50      52.176  -7.433  15.933  1.00 24.93           C  
ATOM    326  CG  ARG    50      51.571  -7.928  17.244  1.00 23.01           C  
ATOM    327  CD  ARG    50      52.229  -7.387  18.526  1.00 25.97           C  
ATOM    328  NE  ARG    50      51.227  -7.423  19.606  1.00 25.66           N  
ATOM    329  CZ  ARG    50      51.399  -6.963  20.839  1.00 26.42           C  
ATOM    330  NH1 ARG    50      52.565  -6.453  21.241  1.00 27.11           N  
ATOM    331  NH2 ARG    50      50.387  -7.018  21.699  1.00 26.62           N  
ATOM    332  N   LEU    51      53.451  -9.807  14.600  1.00 26.95           N  
ATOM    333  CA  LEU    51      54.146 -10.970  15.100  1.00 27.04           C  
ATOM    334  C   LEU    51      54.712 -10.597  16.461  1.00 29.78           C  
ATOM    335  O   LEU    51      55.170  -9.460  16.658  1.00 30.41           O  
ATOM    336  CB  LEU    51      55.282 -11.370  14.186  1.00 27.54           C  
ATOM    337  CG  LEU    51      54.998 -11.394  12.686  1.00 29.34           C  
ATOM    338  CD1 LEU    51      56.323 -11.607  11.956  1.00 30.99           C  
ATOM    339  CD2 LEU    51      53.980 -12.453  12.310  1.00 26.66           C  
ATOM    340  N   ILE    52      54.661 -11.547  17.392  1.00 27.68           N  
ATOM    341  CA  ILE    52      55.383 -11.477  18.649  1.00 27.58           C  
ATOM    342  C   ILE    52      56.458 -12.570  18.624  1.00 30.30           C  
ATOM    343  O   ILE    52      56.167 -13.772  18.457  1.00 28.72           O  
ATOM    344  CB  ILE    52      54.457 -11.600  19.874  1.00 27.65           C  
ATOM    345  CG1 ILE    52      53.316 -10.591  19.780  1.00 27.80           C  
ATOM    346  CG2 ILE    52      55.258 -11.341  21.209  1.00 28.50           C  
ATOM    347  CD1 ILE    52      52.186 -10.811  20.826  1.00 30.99           C  
ATOM    348  N   LEU    53      57.715 -12.153  18.732  1.00 29.54           N  
ATOM    349  CA  LEU    53      58.807 -13.091  18.746  1.00 31.22           C  
ATOM    350  C   LEU    53      59.322 -13.140  20.175  1.00 29.24           C  
ATOM    351  O   LEU    53      59.818 -12.145  20.702  1.00 27.89           O  
ATOM    352  CB  LEU    53      59.911 -12.694  17.757  1.00 33.84           C  
ATOM    353  CG  LEU    53      59.534 -12.203  16.352  1.00 38.88           C  
ATOM    354  CD1 LEU    53      60.751 -12.304  15.464  1.00 47.75           C  
ATOM    355  CD2 LEU    53      58.375 -12.968  15.755  1.00 44.16           C  
ATOM    356  N   ILE    54      59.141 -14.292  20.806  1.00 29.19           N  
ATOM    357  CA  ILE    54      59.549 -14.519  22.195  1.00 28.78           C  
ATOM    358  C   ILE    54      60.821 -15.358  22.243  1.00 29.78           C  
ATOM    359  O   ILE    54      60.788 -16.562  21.961  1.00 29.99           O  
ATOM    360  CB  ILE    54      58.442 -15.232  22.980  1.00 29.40           C  
ATOM    361  CG1 ILE    54      57.138 -14.418  22.910  1.00 27.48           C  
ATOM    362  CG2 ILE    54      58.904 -15.475  24.437  1.00 29.29           C  
ATOM    363  CD1 ILE    54      55.941 -15.044  23.609  1.00 28.12           C  
ATOM    364  N   ASP    55      61.939 -14.719  22.571  1.00 27.43           N  
ATOM    365  CA  ASP    55      63.209 -15.395  22.601  0.50 28.25           C  
ATOM    367  C   ASP    55      63.689 -15.445  24.058  1.00 30.38           C  
ATOM    368  O   ASP    55      63.672 -14.436  24.769  1.00 29.76           O  
ATOM    369  CB  ASP    55      64.211 -14.688  21.668  0.50 28.09           C  
ATOM    371  CG  ASP    55      63.711 -14.584  20.193  0.50 31.75           C  
ATOM    373  OD1 ASP    55      62.981 -15.477  19.699  0.50 24.59           O  
ATOM    375  OD2 ASP    55      64.057 -13.580  19.521  0.50 41.59           O  
ATOM    377  N   LYS    56      64.099 -16.626  24.493  1.00 32.08           N  
ATOM    378  CA  LYS    56      64.643 -16.810  25.839  1.00 34.65           C  
ATOM    379  C   LYS    56      66.126 -17.191  25.736  1.00 34.68           C  
ATOM    380  O   LYS    56      66.532 -17.954  24.850  1.00 37.13           O  
ATOM    381  CB  LYS    56      63.849 -17.857  26.614  1.00 33.26           C  
ATOM    382  CG  LYS    56      62.331 -17.594  26.648  1.00 33.10           C  
ATOM    383  CD  LYS    56      61.635 -18.592  27.549  1.00 36.85           C  
ATOM    384  CE  LYS    56      60.313 -18.080  28.068  1.00 40.09           C  
ATOM    385  NZ  LYS    56      59.874 -18.933  29.177  1.00 38.34           N  
ATOM    386  N   GLN    57      66.925 -16.637  26.632  1.00 31.52           N  
ATOM    387  CA  GLN    57      68.346 -16.923  26.674  1.00 35.10           C  
ATOM    388  C   GLN    57      68.785 -17.298  28.081  1.00 30.44           C  
ATOM    389  O   GLN    57      68.106 -16.981  29.053  1.00 29.95           O  
ATOM    390  CB  GLN    57      69.126 -15.699  26.191  1.00 37.37           C  
ATOM    391  CG  GLN    57      69.024 -15.465  24.686  1.00 43.68           C  
ATOM    392  CD  GLN    57      69.663 -14.166  24.279  1.00 45.08           C  
ATOM    393  OE1 GLN    57      69.247 -13.084  24.727  1.00 59.61           O  
ATOM    394  NE2 GLN    57      70.687 -14.252  23.422  1.00 57.02           N  
ATOM    395  N   GLY    58      69.932 -17.956  28.156  1.00 27.79           N  
ATOM    396  CA  GLY    58      70.562 -18.339  29.414  1.00 26.89           C  
ATOM    397  C   GLY    58      70.197 -19.773  29.693  1.00 24.22           C  
ATOM    398  O   GLY    58      69.295 -20.297  29.067  1.00 23.88           O  
ATOM    399  N   VAL    59      70.886 -20.411  30.626  1.00 23.58           N  
ATOM    400  CA  VAL    59      70.582 -21.783  31.014  1.00 23.37           C  
ATOM    401  C   VAL    59      69.143 -21.909  31.530  1.00 25.93           C  
ATOM    402  O   VAL    59      68.434 -22.844  31.153  1.00 26.68           O  
ATOM    403  CB  VAL    59      71.593 -22.308  32.067  1.00 24.01           C  
ATOM    404  CG1 VAL    59      71.238 -23.739  32.550  1.00 25.92           C  
ATOM    405  CG2 VAL    59      72.972 -22.274  31.485  1.00 24.03           C  
ATOM    406  N   THR    60      68.709 -20.948  32.352  1.00 23.65           N  
ATOM    407  CA  THR    60      67.411 -21.024  33.014  1.00 23.37           C  
ATOM    408  C   THR    60      66.334 -20.330  32.196  1.00 26.68           C  
ATOM    409  O   THR    60      65.167 -20.386  32.543  1.00 29.28           O  
ATOM    410  CB  THR    60      67.460 -20.432  34.466  1.00 23.51           C  
ATOM    411  OG1 THR    60      67.723 -19.014  34.411  1.00 24.54           O  
ATOM    412  CG2 THR    60      68.520 -21.178  35.329  1.00 18.42           C  
ATOM    413  N   GLY    61      66.724 -19.685  31.104  1.00 30.73           N  
ATOM    414  CA  GLY    61      65.778 -19.099  30.213  1.00 32.98           C  
ATOM    415  C   GLY    61      65.064 -17.897  30.798  1.00 33.69           C  
ATOM    416  O   GLY    61      63.924 -17.633  30.444  1.00 30.37           O  
ATOM    417  N   LYS    62      65.742 -17.153  31.672  1.00 34.20           N  
ATOM    418  CA  LYS    62      65.126 -16.018  32.367  1.00 34.99           C  
ATOM    419  C   LYS    62      65.403 -14.678  31.674  1.00 33.78           C  
ATOM    420  O   LYS    62      64.777 -13.689  31.991  1.00 32.47           O  
ATOM    421  CB  LYS    62      65.569 -15.970  33.846  1.00 36.51           C  
ATOM    422  CG  LYS    62      64.835 -17.001  34.756  1.00 40.22           C  
ATOM    423  CD  LYS    62      63.469 -16.485  35.349  1.00 35.99           C  
ATOM    424  CE  LYS    62      63.674 -15.574  36.580  1.00 39.51           C  
ATOM    425  NZ  LYS    62      62.419 -15.380  37.434  1.00 49.24           N  
ATOM    426  N   LYS    63      66.347 -14.657  30.743  1.00 34.21           N  
ATOM    427  CA  LYS    63      66.583 -13.491  29.897  0.50 32.42           C  
ATOM    429  C   LYS    63      65.592 -13.606  28.728  1.00 33.46           C  
ATOM    430  O   LYS    63      65.785 -14.402  27.821  1.00 34.76           O  
ATOM    431  CB  LYS    63      68.057 -13.471  29.440  0.50 32.19           C  
ATOM    433  CG  LYS    63      68.509 -12.280  28.569  0.50 31.21           C  
ATOM    435  CD  LYS    63      68.054 -10.927  29.115  0.50 31.56           C  
ATOM    437  CE  LYS    63      69.005  -9.800  28.734  0.50 31.03           C  
ATOM    439  NZ  LYS    63      69.908  -9.444  29.870  0.50 31.91           N  
ATOM    441  N   VAL    64      64.505 -12.844  28.784  1.00 31.40           N  
ATOM    442  CA  VAL    64      63.399 -13.004  27.823  1.00 30.46           C  
ATOM    443  C   VAL    64      63.151 -11.707  27.081  1.00 30.91           C  
ATOM    444  O   VAL    64      63.119 -10.664  27.694  1.00 29.73           O  
ATOM    445  CB  VAL    64      62.088 -13.428  28.519  1.00 29.36           C  
ATOM    446  CG1 VAL    64      60.970 -13.644  27.493  1.00 27.60           C  
ATOM    447  CG2 VAL    64      62.291 -14.703  29.339  1.00 27.76           C  
ATOM    448  N   SER    65      63.017 -11.776  25.760  1.00 29.51           N  
ATOM    449  CA  SER    65      62.544 -10.643  25.002  1.00 26.52           C  
ATOM    450  C   SER    65      61.240 -10.925  24.275  1.00 26.64           C  
ATOM    451  O   SER    65      61.002 -12.012  23.772  1.00 28.62           O  
ATOM    452  CB  SER    65      63.592 -10.138  24.022  1.00 27.05           C  
ATOM    453  OG  SER    65      64.070 -11.185  23.235  1.00 33.03           O  
ATOM    454  N   TYR    66      60.389  -9.920  24.236  1.00 25.59           N  
ATOM    455  CA  TYR    66      59.191  -9.948  23.409  1.00 27.15           C  
ATOM    456  C   TYR    66      59.361  -8.849  22.363  1.00 25.16           C  
ATOM    457  O   TYR    66      59.309  -7.661  22.693  1.00 25.87           O  
ATOM    458  CB  TYR    66      57.933  -9.662  24.243  1.00 28.11           C  
ATOM    459  CG  TYR    66      57.432 -10.753  25.177  1.00 28.34           C  
ATOM    460  CD1 TYR    66      58.267 -11.715  25.738  1.00 37.37           C  
ATOM    461  CD2 TYR    66      56.097 -10.793  25.520  1.00 31.42           C  
ATOM    462  CE1 TYR    66      57.757 -12.693  26.606  1.00 34.85           C  
ATOM    463  CE2 TYR    66      55.586 -11.741  26.356  1.00 33.25           C  
ATOM    464  CZ  TYR    66      56.403 -12.676  26.918  1.00 35.59           C  
ATOM    465  OH  TYR    66      55.813 -13.599  27.764  1.00 35.83           O  
ATOM    466  N   HIS    67      59.605  -9.263  21.126  1.00 24.79           N  
ATOM    467  CA  HIS    67      59.756  -8.360  20.009  1.00 26.12           C  
ATOM    468  C   HIS    67      58.450  -8.365  19.214  1.00 25.09           C  
ATOM    469  O   HIS    67      58.064  -9.386  18.628  1.00 25.46           O  
ATOM    470  CB  HIS    67      60.943  -8.805  19.158  1.00 27.50           C  
ATOM    471  CG  HIS    67      61.301  -7.845  18.073  1.00 28.86           C  
ATOM    472  ND1 HIS    67      62.124  -8.190  17.027  1.00 41.80           N  
ATOM    473  CD2 HIS    67      60.888  -6.582  17.826  1.00 33.68           C  
ATOM    474  CE1 HIS    67      62.236  -7.160  16.203  1.00 47.44           C  
ATOM    475  NE2 HIS    67      61.492  -6.172  16.665  1.00 32.45           N  
ATOM    476  N   SER    68      57.770  -7.224  19.200  1.00 23.64           N  
ATOM    477  CA  SER    68      56.558  -7.036  18.377  1.00 24.79           C  
ATOM    478  C   SER    68      56.883  -6.462  17.006  1.00 25.82           C  
ATOM    479  O   SER    68      57.509  -5.383  16.889  1.00 23.38           O  
ATOM    480  CB  SER    68      55.560  -6.122  19.079  1.00 24.81           C  
ATOM    481  OG  SER    68      55.153  -6.674  20.322  1.00 24.83           O  
ATOM    482  N   VAL    69      56.462  -7.187  15.969  1.00 25.47           N  
ATOM    483  CA  VAL    69      56.582  -6.720  14.602  1.00 26.01           C  
ATOM    484  C   VAL    69      55.193  -6.542  14.009  1.00 24.83           C  
ATOM    485  O   VAL    69      54.589  -7.532  13.574  1.00 24.53           O  
ATOM    486  CB  VAL    69      57.414  -7.649  13.728  1.00 25.83           C  
ATOM    487  CG1 VAL    69      57.718  -6.924  12.392  1.00 24.55           C  
ATOM    488  CG2 VAL    69      58.691  -8.027  14.450  1.00 23.41           C  
ATOM    489  N   PRO    70      54.672  -5.302  14.022  1.00 23.95           N  
ATOM    490  CA  PRO    70      53.391  -5.074  13.368  1.00 25.46           C  
ATOM    491  C   PRO    70      53.522  -5.421  11.899  1.00 25.75           C  
ATOM    492  O   PRO    70      54.592  -5.246  11.303  1.00 23.32           O  
ATOM    493  CB  PRO    70      53.128  -3.576  13.583  1.00 26.99           C  
ATOM    494  CG  PRO    70      54.007  -3.194  14.738  1.00 26.95           C  
ATOM    495  CD  PRO    70      55.206  -4.066  14.618  1.00 25.90           C  
END
