
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   95 ( 1473),  selected   95 , name 2yu3_A
# Molecule2: number of CA atoms  134 ( 1070),  selected  134 , name T0443_97_230.pdb
# PARAMETERS: 2yu3_A.T0443_97_230.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      S      97           -
LGA    S     2_A      D      98           -
LGA    S     3_A      G      99           -
LGA    G     4_A      I     100           -
LGA    S     5_A      L     101           -
LGA    S     6_A      A     102           -
LGA    G     7_A      L     103           -
LGA    G     8_A      M     104           -
LGA    Q     9_A      D     105           -
LGA    L    10_A      F     106           -
LGA    D    11_A      E     107           -
LGA    L    12_A      Y     108           -
LGA    L    13_A      T     109           -
LGA    R    14_A      Q     110           -
LGA    S    15_A      L     111           -
LGA    N    16_A      L     112           -
LGA    T    17_A      A     113           -
LGA    -       -      E     114           -
LGA    -       -      V     115           -
LGA    -       -      A     116           -
LGA    -       -      Q     117           -
LGA    -       -      I     118           -
LGA    -       -      P     119           -
LGA    -       -      D     120           -
LGA    -       -      I     121           -
LGA    -       -      P     122           -
LGA    -       -      D     123           -
LGA    -       -      I     124           -
LGA    -       -      H     125           -
LGA    -       -      Y     126           -
LGA    G    18_A      S     127          5.301
LGA    L    19_A      N     128          1.883
LGA    -       -      D     129           -
LGA    L    20_A      S     130          1.614
LGA    Y    21_A      K     131          3.038
LGA    R    22_A      Y     132          1.646
LGA    I    23_A      T     133          1.905
LGA    K    24_A      P     134          3.595
LGA    D    25_A      S     135          4.159
LGA    S    26_A      P     136          4.303
LGA    Q    27_A      A     137           #
LGA    N    28_A      A     138          3.391
LGA    A    29_A      F     139          2.011
LGA    G    30_A      I     140          1.875
LGA    -       -      R     141           -
LGA    -       -      Q     142           -
LGA    -       -      Y     143           -
LGA    -       -      R     144           -
LGA    -       -      Y     145           -
LGA    -       -      D     146           -
LGA    -       -      V     147           -
LGA    -       -      T     148           -
LGA    -       -      H     149           -
LGA    -       -      D     150           -
LGA    -       -      L     151           -
LGA    -       -      Q     152           -
LGA    -       -      E     153           -
LGA    -       -      A     154           -
LGA    -       -      E     155           -
LGA    -       -      T     156           -
LGA    -       -      A     157           -
LGA    -       -      L     158           -
LGA    K    31_A      L     159          1.318
LGA    -       -      I     160           -
LGA    -       -      W     161           -
LGA    -       -      R     162           -
LGA    -       -      N     163           -
LGA    -       -      A     164           -
LGA    -       -      E     165           -
LGA    -       -      D     166           -
LGA    -       -      D     167           -
LGA    -       -      V     168           -
LGA    -       -      M     169           -
LGA    M    32_A      Y     170           #
LGA    K    33_A      Q     171          2.598
LGA    G    34_A      T     172          6.066
LGA    S    35_A      L     173          5.410
LGA    D    36_A      D     174          1.150
LGA    N    37_A      G     175          1.713
LGA    Q    38_A      F     176          2.477
LGA    E    39_A      D     177          1.564
LGA    K    40_A      M     178          1.723
LGA    L    41_A      M     179          2.560
LGA    V    42_A      L     180          2.114
LGA    Y    43_A      L     181          1.595
LGA    Q    44_A      E     182          2.630
LGA    I    45_A      I     183          3.051
LGA    I    46_A      M     184          2.210
LGA    E    47_A      G     185          1.874
LGA    D    48_A      S     186          1.929
LGA    A    49_A      S     187          1.670
LGA    G    50_A      -       -           -
LGA    N    51_A      -       -           -
LGA    K    52_A      -       -           -
LGA    G    53_A      A     188          2.808
LGA    I    54_A      L     189          1.588
LGA    W    55_A      S     190          1.872
LGA    S    56_A      F     191          1.019
LGA    R    57_A      D     192          1.661
LGA    D    58_A      T     193          1.106
LGA    V    59_A      L     194          1.217
LGA    R    60_A      A     195          1.739
LGA    Y    61_A      Q     196          3.100
LGA    K    62_A      T     197          3.238
LGA    S    63_A      L     198          4.097
LGA    -       -      V     199           -
LGA    -       -      E     200           -
LGA    N    64_A      F     201          4.583
LGA    L    65_A      M     202           #
LGA    -       -      P     203           -
LGA    -       -      K     204           -
LGA    -       -      A     205           -
LGA    -       -      D     206           -
LGA    -       -      N     207           -
LGA    P    66_A      W     208          2.794
LGA    L    67_A      K     209          1.087
LGA    T    68_A      N     210          2.065
LGA    E    69_A      I     211          2.648
LGA    I    70_A      L     212          1.669
LGA    N    71_A      L     213          1.047
LGA    K    72_A      G     214          2.216
LGA    I    73_A      K     215          2.068
LGA    L    74_A      W     216          0.745
LGA    K    75_A      S     217          1.918
LGA    N    76_A      G     218          2.831
LGA    L    77_A      W     219          2.024
LGA    E    78_A      I     220          1.991
LGA    S    79_A      E     221          3.192
LGA    K    80_A      Q     222          3.049
LGA    K    81_A      R     223          1.686
LGA    L    82_A      I     224          1.844
LGA    I    83_A      I     225          1.069
LGA    K    84_A      I     226          0.422
LGA    A    85_A      P     227          3.330
LGA    -       -      S     228           -
LGA    V    86_A      L     229           #
LGA    K    87_A      S     230           -
LGA    S    88_A      -       -           -
LGA    V    89_A      -       -           -
LGA    S    90_A      -       -           -
LGA    G    91_A      -       -           -
LGA    P    92_A      -       -           -
LGA    S    93_A      -       -           -
LGA    S    94_A      -       -           -
LGA    G    95_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   95  134    5.0     62    2.62     4.84     30.946     2.279

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.683157 * X  +  -0.610097 * Y  +   0.401345 * Z  + -26.063566
  Y_new =   0.679392 * X  +   0.732519 * Y  +  -0.042916 * Z  +  -1.801280
  Z_new =  -0.267810 * X  +   0.301989 * Y  +   0.914921 * Z  +  33.107567 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.318812   -2.822781  [ DEG:    18.2666   -161.7334 ]
  Theta =   0.271119    2.870474  [ DEG:    15.5340    164.4660 ]
  Phi   =   0.782635   -2.358958  [ DEG:    44.8417   -135.1583 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2yu3_A                                        
REMARK     2: T0443_97_230.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2yu3_A.T0443_97_230.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   95  134   5.0   62   2.62    4.84  30.946
REMARK  ---------------------------------------------------------- 
MOLECULE 2yu3_A
HEADER    TRANSCRIPTION                           05-APR-07   2YU3              
TITLE     SOLUTION STRUCTURE OF THE DOMAIN SWAPPED WINGEDHELIX IN DNA-          
TITLE    2 DIRECTED RNA POLYMERASE III 39 KDA POLYPEPTIDE                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: DNA-DIRECTED RNA POLYMERASE III 39 KDA                     
COMPND   3 POLYPEPTIDE F VARIANT;                                               
COMPND   4 CHAIN: A;                                                            
COMPND   5 FRAGMENT: WINGED HELIX DOMAIN, UNP RESIDUES 61-142;                  
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: POLR3F, RPC39;                                                 
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 OTHER_DETAILS: CELL FREE PROTEIN SYNTHESIS                           
KEYWDS    NMR, WINGED HELIX DOMAIN, RNA POLYMERASE III C39 SUBUNIT,             
KEYWDS   2 STRUCTURAL GENOMICS, NPPSFA, NATIONAL PROJECT ON PROTEIN             
KEYWDS   3 STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN STRUCTURAL                 
KEYWDS   4 GENOMICS/PROTEOMICS INITIATIVE, RSGI, TRANSCRIPTION                  
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    F.HE,Y.MUTO,M.INOUE,T.KIGAWA,M.SHIROUZU,T.TERADA,S.YOKOYAMA,          
AUTHOR   2 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)               
REVDAT   1   09-OCT-07 2YU3    0                                                
JRNL        AUTH   F.HE,Y.MUTO,M.INOUE,T.KIGAWA,M.SHIROUZU,T.TERADA,            
JRNL        AUTH 2 S.YOKOYAMA                                                   
JRNL        TITL   SOLUTION STRUCTURE OF THE DOMAIN SWAPPED                     
JRNL        TITL 2 WINGEDHELIX IN DNA-DIRECTED RNA POLYMERASE III 39            
JRNL        TITL 3 KDA POLYPEPTIDE                                              
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2YU3 A    8    89  UNP    Q53FI8   Q53FI8_HUMAN    61    142             
SEQRES   1 A   95  GLY SER SER GLY SER SER GLY GLY GLN LEU ASP LEU LEU          
SEQRES   2 A   95  ARG SER ASN THR GLY LEU LEU TYR ARG ILE LYS ASP SER          
SEQRES   3 A   95  GLN ASN ALA GLY LYS MET LYS GLY SER ASP ASN GLN GLU          
SEQRES   4 A   95  LYS LEU VAL TYR GLN ILE ILE GLU ASP ALA GLY ASN LYS          
SEQRES   5 A   95  GLY ILE TRP SER ARG ASP VAL ARG TYR LYS SER ASN LEU          
SEQRES   6 A   95  PRO LEU THR GLU ILE ASN LYS ILE LEU LYS ASN LEU GLU          
SEQRES   7 A   95  SER LYS LYS LEU ILE LYS ALA VAL LYS SER VAL SER GLY          
SEQRES   8 A   95  PRO SER SER GLY                                              
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1     -22.183 -48.871  27.021  1.00  0.00           N  
ATOM      2  CA  GLY A   1     -21.928 -47.659  27.778  1.00  0.00           C  
ATOM      3  C   GLY A   1     -22.523 -46.429  27.120  1.00  0.00           C  
ATOM      4  O   GLY A   1     -21.797 -45.587  26.594  1.00  0.00           O  
ATOM      5  H1  GLY A   1     -21.440 -49.468  26.792  1.00  0.00           H  
ATOM      6  HA2 GLY A   1     -22.354 -47.768  28.765  1.00  0.00           H  
ATOM      7  HA3 GLY A   1     -20.861 -47.523  27.870  1.00  0.00           H  
ATOM      8  N   SER A   2     -23.848 -46.327  27.149  1.00  0.00           N  
ATOM      9  CA  SER A   2     -24.539 -45.194  26.545  1.00  0.00           C  
ATOM     10  C   SER A   2     -24.859 -44.132  27.593  1.00  0.00           C  
ATOM     11  O   SER A   2     -25.250 -44.449  28.716  1.00  0.00           O  
ATOM     12  CB  SER A   2     -25.829 -45.660  25.866  1.00  0.00           C  
ATOM     13  OG  SER A   2     -26.398 -46.761  26.553  1.00  0.00           O  
ATOM     14  H   SER A   2     -24.372 -47.031  27.584  1.00  0.00           H  
ATOM     15  HA  SER A   2     -23.886 -44.764  25.801  1.00  0.00           H  
ATOM     16  HB2 SER A   2     -26.542 -44.849  25.857  1.00  0.00           H  
ATOM     17  HB3 SER A   2     -25.611 -45.958  24.851  1.00  0.00           H  
ATOM     18  HG  SER A   2     -26.934 -47.276  25.945  1.00  0.00           H  
ATOM     19  N   SER A   3     -24.688 -42.868  27.217  1.00  0.00           N  
ATOM     20  CA  SER A   3     -24.952 -41.758  28.124  1.00  0.00           C  
ATOM     21  C   SER A   3     -26.452 -41.574  28.333  1.00  0.00           C  
ATOM     22  O   SER A   3     -26.955 -41.702  29.449  1.00  0.00           O  
ATOM     23  CB  SER A   3     -24.341 -40.467  27.576  1.00  0.00           C  
ATOM     24  OG  SER A   3     -22.936 -40.591  27.427  1.00  0.00           O  
ATOM     25  H   SER A   3     -24.373 -42.679  26.308  1.00  0.00           H  
ATOM     26  HA  SER A   3     -24.494 -41.989  29.074  1.00  0.00           H  
ATOM     27  HB2 SER A   3     -24.774 -40.247  26.613  1.00  0.00           H  
ATOM     28  HB3 SER A   3     -24.548 -39.656  28.259  1.00  0.00           H  
ATOM     29  HG  SER A   3     -22.704 -40.505  26.500  1.00  0.00           H  
ATOM     30  N   GLY A   4     -27.162 -41.272  27.250  1.00  0.00           N  
ATOM     31  CA  GLY A   4     -28.597 -41.075  27.335  1.00  0.00           C  
ATOM     32  C   GLY A   4     -28.980 -40.036  28.371  1.00  0.00           C  
ATOM     33  O   GLY A   4     -28.171 -39.180  28.729  1.00  0.00           O  
ATOM     34  H   GLY A   4     -26.708 -41.182  26.386  1.00  0.00           H  
ATOM     35  HA2 GLY A   4     -28.964 -40.758  26.371  1.00  0.00           H  
ATOM     36  HA3 GLY A   4     -29.064 -42.014  27.596  1.00  0.00           H  
ATOM     37  N   SER A   5     -30.216 -40.111  28.853  1.00  0.00           N  
ATOM     38  CA  SER A   5     -30.706 -39.167  29.850  1.00  0.00           C  
ATOM     39  C   SER A   5     -30.485 -37.728  29.391  1.00  0.00           C  
ATOM     40  O   SER A   5     -29.490 -37.097  29.749  1.00  0.00           O  
ATOM     41  CB  SER A   5     -30.007 -39.399  31.191  1.00  0.00           C  
ATOM     42  OG  SER A   5     -30.701 -38.756  32.246  1.00  0.00           O  
ATOM     43  H   SER A   5     -30.814 -40.816  28.528  1.00  0.00           H  
ATOM     44  HA  SER A   5     -31.765 -39.334  29.974  1.00  0.00           H  
ATOM     45  HB2 SER A   5     -29.967 -40.458  31.395  1.00  0.00           H  
ATOM     46  HB3 SER A   5     -29.002 -39.003  31.143  1.00  0.00           H  
ATOM     47  HG  SER A   5     -30.609 -37.805  32.157  1.00  0.00           H  
ATOM     48  N   SER A   6     -31.419 -37.217  28.596  1.00  0.00           N  
ATOM     49  CA  SER A   6     -31.325 -35.855  28.083  1.00  0.00           C  
ATOM     50  C   SER A   6     -32.662 -35.131  28.217  1.00  0.00           C  
ATOM     51  O   SER A   6     -33.613 -35.421  27.493  1.00  0.00           O  
ATOM     52  CB  SER A   6     -30.883 -35.867  26.619  1.00  0.00           C  
ATOM     53  OG  SER A   6     -29.476 -35.985  26.513  1.00  0.00           O  
ATOM     54  H   SER A   6     -32.188 -37.770  28.346  1.00  0.00           H  
ATOM     55  HA  SER A   6     -30.585 -35.330  28.670  1.00  0.00           H  
ATOM     56  HB2 SER A   6     -31.341 -36.705  26.115  1.00  0.00           H  
ATOM     57  HB3 SER A   6     -31.194 -34.947  26.145  1.00  0.00           H  
ATOM     58  HG  SER A   6     -29.240 -36.904  26.368  1.00  0.00           H  
ATOM     59  N   GLY A   7     -32.726 -34.186  29.151  1.00  0.00           N  
ATOM     60  CA  GLY A   7     -33.949 -33.435  29.363  1.00  0.00           C  
ATOM     61  C   GLY A   7     -34.882 -34.112  30.348  1.00  0.00           C  
ATOM     62  O   GLY A   7     -34.518 -35.107  30.976  1.00  0.00           O  
ATOM     63  H   GLY A   7     -31.936 -33.998  29.700  1.00  0.00           H  
ATOM     64  HA2 GLY A   7     -33.696 -32.455  29.739  1.00  0.00           H  
ATOM     65  HA3 GLY A   7     -34.461 -33.327  28.419  1.00  0.00           H  
ATOM     66  N   GLY A   8     -36.089 -33.573  30.485  1.00  0.00           N  
ATOM     67  CA  GLY A   8     -37.056 -34.144  31.403  1.00  0.00           C  
ATOM     68  C   GLY A   8     -38.374 -33.393  31.399  1.00  0.00           C  
ATOM     69  O   GLY A   8     -39.406 -33.941  31.014  1.00  0.00           O  
ATOM     70  H   GLY A   8     -36.325 -32.781  29.958  1.00  0.00           H  
ATOM     71  HA2 GLY A   8     -37.239 -35.171  31.124  1.00  0.00           H  
ATOM     72  HA3 GLY A   8     -36.646 -34.120  32.402  1.00  0.00           H  
ATOM     73  N   GLN A   9     -38.337 -32.136  31.829  1.00  0.00           N  
ATOM     74  CA  GLN A   9     -39.538 -31.310  31.874  1.00  0.00           C  
ATOM     75  C   GLN A   9     -39.185 -29.830  31.764  1.00  0.00           C  
ATOM     76  O   GLN A   9     -38.171 -29.381  32.300  1.00  0.00           O  
ATOM     77  CB  GLN A   9     -40.310 -31.567  33.170  1.00  0.00           C  
ATOM     78  CG  GLN A   9     -41.750 -31.083  33.126  1.00  0.00           C  
ATOM     79  CD  GLN A   9     -42.379 -30.996  34.503  1.00  0.00           C  
ATOM     80  OE1 GLN A   9     -41.874 -30.300  35.385  1.00  0.00           O  
ATOM     81  NE2 GLN A   9     -43.487 -31.701  34.694  1.00  0.00           N  
ATOM     82  H   GLN A   9     -37.484 -31.756  32.122  1.00  0.00           H  
ATOM     83  HA  GLN A   9     -40.160 -31.583  31.036  1.00  0.00           H  
ATOM     84  HB2 GLN A   9     -40.315 -32.628  33.367  1.00  0.00           H  
ATOM     85  HB3 GLN A   9     -39.808 -31.061  33.980  1.00  0.00           H  
ATOM     86  HG2 GLN A   9     -41.774 -30.102  32.673  1.00  0.00           H  
ATOM     87  HG3 GLN A   9     -42.329 -31.770  32.525  1.00  0.00           H  
ATOM     88 HE21 GLN A   9     -43.831 -32.233  33.946  1.00  0.00           H  
ATOM     89 HE22 GLN A   9     -43.914 -31.663  35.575  1.00  0.00           H  
ATOM     90  N   LEU A  10     -40.028 -29.078  31.065  1.00  0.00           N  
ATOM     91  CA  LEU A  10     -39.806 -27.648  30.882  1.00  0.00           C  
ATOM     92  C   LEU A  10     -41.094 -26.863  31.111  1.00  0.00           C  
ATOM     93  O   LEU A  10     -42.111 -27.120  30.467  1.00  0.00           O  
ATOM     94  CB  LEU A  10     -39.268 -27.370  29.478  1.00  0.00           C  
ATOM     95  CG  LEU A  10     -37.748 -27.420  29.319  1.00  0.00           C  
ATOM     96  CD1 LEU A  10     -37.368 -27.550  27.852  1.00  0.00           C  
ATOM     97  CD2 LEU A  10     -37.107 -26.183  29.930  1.00  0.00           C  
ATOM     98  H   LEU A  10     -40.818 -29.492  30.662  1.00  0.00           H  
ATOM     99  HA  LEU A  10     -39.073 -27.331  31.610  1.00  0.00           H  
ATOM    100  HB2 LEU A  10     -39.694 -28.102  28.810  1.00  0.00           H  
ATOM    101  HB3 LEU A  10     -39.600 -26.383  29.187  1.00  0.00           H  
ATOM    102  HG  LEU A  10     -37.366 -28.287  29.841  1.00  0.00           H  
ATOM    103 HD11 LEU A  10     -38.156 -28.064  27.321  1.00  0.00           H  
ATOM    104 HD12 LEU A  10     -36.450 -28.113  27.766  1.00  0.00           H  
ATOM    105 HD13 LEU A  10     -37.228 -26.567  27.428  1.00  0.00           H  
ATOM    106 HD21 LEU A  10     -36.985 -26.328  30.993  1.00  0.00           H  
ATOM    107 HD22 LEU A  10     -37.739 -25.325  29.754  1.00  0.00           H  
ATOM    108 HD23 LEU A  10     -36.140 -26.016  29.476  1.00  0.00           H  
ATOM    109  N   ASP A  11     -41.042 -25.905  32.029  1.00  0.00           N  
ATOM    110  CA  ASP A  11     -42.203 -25.079  32.340  1.00  0.00           C  
ATOM    111  C   ASP A  11     -41.830 -23.600  32.354  1.00  0.00           C  
ATOM    112  O   ASP A  11     -41.583 -23.020  33.413  1.00  0.00           O  
ATOM    113  CB  ASP A  11     -42.794 -25.481  33.692  1.00  0.00           C  
ATOM    114  CG  ASP A  11     -44.217 -24.990  33.871  1.00  0.00           C  
ATOM    115  OD1 ASP A  11     -44.396 -23.790  34.170  1.00  0.00           O  
ATOM    116  OD2 ASP A  11     -45.152 -25.803  33.714  1.00  0.00           O  
ATOM    117  H   ASP A  11     -40.201 -25.747  32.509  1.00  0.00           H  
ATOM    118  HA  ASP A  11     -42.942 -25.243  31.571  1.00  0.00           H  
ATOM    119  HB2 ASP A  11     -42.794 -26.559  33.771  1.00  0.00           H  
ATOM    120  HB3 ASP A  11     -42.186 -25.066  34.482  1.00  0.00           H  
ATOM    121  N   LEU A  12     -41.791 -22.994  31.173  1.00  0.00           N  
ATOM    122  CA  LEU A  12     -41.447 -21.581  31.049  1.00  0.00           C  
ATOM    123  C   LEU A  12     -42.697 -20.709  31.109  1.00  0.00           C  
ATOM    124  O   LEU A  12     -43.809 -21.181  30.863  1.00  0.00           O  
ATOM    125  CB  LEU A  12     -40.700 -21.331  29.737  1.00  0.00           C  
ATOM    126  CG  LEU A  12     -39.231 -20.931  29.868  1.00  0.00           C  
ATOM    127  CD1 LEU A  12     -38.433 -21.431  28.673  1.00  0.00           C  
ATOM    128  CD2 LEU A  12     -39.099 -19.421  30.005  1.00  0.00           C  
ATOM    129  H   LEU A  12     -41.998 -23.507  30.364  1.00  0.00           H  
ATOM    130  HA  LEU A  12     -40.803 -21.323  31.875  1.00  0.00           H  
ATOM    131  HB2 LEU A  12     -40.746 -22.237  29.153  1.00  0.00           H  
ATOM    132  HB3 LEU A  12     -41.214 -20.539  29.211  1.00  0.00           H  
ATOM    133  HG  LEU A  12     -38.818 -21.387  30.758  1.00  0.00           H  
ATOM    134 HD11 LEU A  12     -37.379 -21.296  28.862  1.00  0.00           H  
ATOM    135 HD12 LEU A  12     -38.716 -20.873  27.793  1.00  0.00           H  
ATOM    136 HD13 LEU A  12     -38.641 -22.480  28.515  1.00  0.00           H  
ATOM    137 HD21 LEU A  12     -40.034 -18.953  29.738  1.00  0.00           H  
ATOM    138 HD22 LEU A  12     -38.317 -19.067  29.349  1.00  0.00           H  
ATOM    139 HD23 LEU A  12     -38.850 -19.173  31.027  1.00  0.00           H  
ATOM    140  N   LEU A  13     -42.509 -19.436  31.436  1.00  0.00           N  
ATOM    141  CA  LEU A  13     -43.621 -18.496  31.526  1.00  0.00           C  
ATOM    142  C   LEU A  13     -43.389 -17.289  30.623  1.00  0.00           C  
ATOM    143  O   LEU A  13     -42.251 -16.869  30.413  1.00  0.00           O  
ATOM    144  CB  LEU A  13     -43.810 -18.037  32.973  1.00  0.00           C  
ATOM    145  CG  LEU A  13     -45.230 -17.632  33.369  1.00  0.00           C  
ATOM    146  CD1 LEU A  13     -46.042 -18.854  33.769  1.00  0.00           C  
ATOM    147  CD2 LEU A  13     -45.199 -16.615  34.500  1.00  0.00           C  
ATOM    148  H   LEU A  13     -41.601 -19.118  31.621  1.00  0.00           H  
ATOM    149  HA  LEU A  13     -44.515 -19.008  31.200  1.00  0.00           H  
ATOM    150  HB2 LEU A  13     -43.505 -18.846  33.619  1.00  0.00           H  
ATOM    151  HB3 LEU A  13     -43.165 -17.185  33.135  1.00  0.00           H  
ATOM    152  HG  LEU A  13     -45.718 -17.173  32.519  1.00  0.00           H  
ATOM    153 HD11 LEU A  13     -46.340 -18.764  34.803  1.00  0.00           H  
ATOM    154 HD12 LEU A  13     -45.441 -19.742  33.644  1.00  0.00           H  
ATOM    155 HD13 LEU A  13     -46.920 -18.924  33.144  1.00  0.00           H  
ATOM    156 HD21 LEU A  13     -44.555 -16.973  35.288  1.00  0.00           H  
ATOM    157 HD22 LEU A  13     -46.199 -16.478  34.887  1.00  0.00           H  
ATOM    158 HD23 LEU A  13     -44.825 -15.673  34.128  1.00  0.00           H  
ATOM    159  N   ARG A  14     -44.475 -16.733  30.096  1.00  0.00           N  
ATOM    160  CA  ARG A  14     -44.390 -15.573  29.217  1.00  0.00           C  
ATOM    161  C   ARG A  14     -43.714 -14.403  29.925  1.00  0.00           C  
ATOM    162  O   ARG A  14     -44.203 -13.914  30.944  1.00  0.00           O  
ATOM    163  CB  ARG A  14     -45.785 -15.160  28.745  1.00  0.00           C  
ATOM    164  CG  ARG A  14     -46.163 -15.730  27.388  1.00  0.00           C  
ATOM    165  CD  ARG A  14     -46.609 -14.638  26.429  1.00  0.00           C  
ATOM    166  NE  ARG A  14     -47.798 -13.940  26.909  1.00  0.00           N  
ATOM    167  CZ  ARG A  14     -48.565 -13.177  26.138  1.00  0.00           C  
ATOM    168  NH1 ARG A  14     -48.268 -13.015  24.856  1.00  0.00           N  
ATOM    169  NH2 ARG A  14     -49.632 -12.576  26.649  1.00  0.00           N  
ATOM    170  H   ARG A  14     -45.355 -17.113  30.301  1.00  0.00           H  
ATOM    171  HA  ARG A  14     -43.796 -15.850  28.358  1.00  0.00           H  
ATOM    172  HB2 ARG A  14     -46.512 -15.500  29.468  1.00  0.00           H  
ATOM    173  HB3 ARG A  14     -45.827 -14.084  28.683  1.00  0.00           H  
ATOM    174  HG2 ARG A  14     -45.304 -16.234  26.968  1.00  0.00           H  
ATOM    175  HG3 ARG A  14     -46.969 -16.437  27.516  1.00  0.00           H  
ATOM    176  HD2 ARG A  14     -45.805 -13.925  26.318  1.00  0.00           H  
ATOM    177  HD3 ARG A  14     -46.827 -15.085  25.471  1.00  0.00           H  
ATOM    178  HE  ARG A  14     -48.036 -14.046  27.854  1.00  0.00           H  
ATOM    179 HH11 ARG A  14     -47.466 -13.468  24.468  1.00  0.00           H  
ATOM    180 HH12 ARG A  14     -48.848 -12.441  24.277  1.00  0.00           H  
ATOM    181 HH21 ARG A  14     -49.858 -12.696  27.615  1.00  0.00           H  
ATOM    182 HH22 ARG A  14     -50.207 -12.002  26.068  1.00  0.00           H  
ATOM    183  N   SER A  15     -42.587 -13.959  29.379  1.00  0.00           N  
ATOM    184  CA  SER A  15     -41.841 -12.849  29.961  1.00  0.00           C  
ATOM    185  C   SER A  15     -41.175 -12.012  28.873  1.00  0.00           C  
ATOM    186  O   SER A  15     -41.119 -12.415  27.711  1.00  0.00           O  
ATOM    187  CB  SER A  15     -40.784 -13.372  30.935  1.00  0.00           C  
ATOM    188  OG  SER A  15     -39.568 -13.656  30.265  1.00  0.00           O  
ATOM    189  H   SER A  15     -42.247 -14.389  28.566  1.00  0.00           H  
ATOM    190  HA  SER A  15     -42.539 -12.227  30.500  1.00  0.00           H  
ATOM    191  HB2 SER A  15     -40.597 -12.627  31.694  1.00  0.00           H  
ATOM    192  HB3 SER A  15     -41.145 -14.278  31.401  1.00  0.00           H  
ATOM    193  HG  SER A  15     -38.875 -13.083  30.602  1.00  0.00           H  
ATOM    194  N   ASN A  16     -40.672 -10.844  29.258  1.00  0.00           N  
ATOM    195  CA  ASN A  16     -40.010  -9.948  28.316  1.00  0.00           C  
ATOM    196  C   ASN A  16     -38.598  -9.612  28.785  1.00  0.00           C  
ATOM    197  O   ASN A  16     -38.360  -9.406  29.976  1.00  0.00           O  
ATOM    198  CB  ASN A  16     -40.824  -8.663  28.145  1.00  0.00           C  
ATOM    199  CG  ASN A  16     -42.155  -8.908  27.464  1.00  0.00           C  
ATOM    200  OD1 ASN A  16     -42.871  -9.853  27.797  1.00  0.00           O  
ATOM    201  ND2 ASN A  16     -42.494  -8.057  26.504  1.00  0.00           N  
ATOM    202  H   ASN A  16     -40.747 -10.577  30.198  1.00  0.00           H  
ATOM    203  HA  ASN A  16     -39.949 -10.454  27.365  1.00  0.00           H  
ATOM    204  HB2 ASN A  16     -41.012  -8.231  29.118  1.00  0.00           H  
ATOM    205  HB3 ASN A  16     -40.258  -7.962  27.549  1.00  0.00           H  
ATOM    206 HD21 ASN A  16     -41.875  -7.327  26.291  1.00  0.00           H  
ATOM    207 HD22 ASN A  16     -43.351  -8.191  26.047  1.00  0.00           H  
ATOM    208  N   THR A  17     -37.664  -9.556  27.842  1.00  0.00           N  
ATOM    209  CA  THR A  17     -36.276  -9.243  28.158  1.00  0.00           C  
ATOM    210  C   THR A  17     -36.040  -7.738  28.175  1.00  0.00           C  
ATOM    211  O   THR A  17     -35.568  -7.185  29.167  1.00  0.00           O  
ATOM    212  CB  THR A  17     -35.310  -9.892  27.147  1.00  0.00           C  
ATOM    213  OG1 THR A  17     -35.709 -11.242  26.886  1.00  0.00           O  
ATOM    214  CG2 THR A  17     -33.883  -9.871  27.673  1.00  0.00           C  
ATOM    215  H   THR A  17     -37.915  -9.729  26.911  1.00  0.00           H  
ATOM    216  HA  THR A  17     -36.059  -9.643  29.138  1.00  0.00           H  
ATOM    217  HB  THR A  17     -35.347  -9.328  26.226  1.00  0.00           H  
ATOM    218  HG1 THR A  17     -36.574 -11.245  26.470  1.00  0.00           H  
ATOM    219 HG21 THR A  17     -33.494  -8.866  27.619  1.00  0.00           H  
ATOM    220 HG22 THR A  17     -33.269 -10.527  27.074  1.00  0.00           H  
ATOM    221 HG23 THR A  17     -33.872 -10.207  28.699  1.00  0.00           H  
ATOM    222  N   GLY A  18     -36.373  -7.079  27.069  1.00  0.00           N  
ATOM    223  CA  GLY A  18     -36.191  -5.643  26.979  1.00  0.00           C  
ATOM    224  C   GLY A  18     -35.568  -5.218  25.663  1.00  0.00           C  
ATOM    225  O   GLY A  18     -36.036  -5.607  24.592  1.00  0.00           O  
ATOM    226  H   GLY A  18     -36.746  -7.572  26.309  1.00  0.00           H  
ATOM    227  HA2 GLY A  18     -37.152  -5.161  27.082  1.00  0.00           H  
ATOM    228  HA3 GLY A  18     -35.550  -5.321  27.786  1.00  0.00           H  
ATOM    229  N   LEU A  19     -34.512  -4.418  25.741  1.00  0.00           N  
ATOM    230  CA  LEU A  19     -33.824  -3.938  24.547  1.00  0.00           C  
ATOM    231  C   LEU A  19     -32.386  -4.445  24.506  1.00  0.00           C  
ATOM    232  O   LEU A  19     -31.798  -4.759  25.541  1.00  0.00           O  
ATOM    233  CB  LEU A  19     -33.840  -2.409  24.504  1.00  0.00           C  
ATOM    234  CG  LEU A  19     -34.938  -1.772  23.653  1.00  0.00           C  
ATOM    235  CD1 LEU A  19     -35.687  -0.716  24.451  1.00  0.00           C  
ATOM    236  CD2 LEU A  19     -34.349  -1.168  22.387  1.00  0.00           C  
ATOM    237  H   LEU A  19     -34.184  -4.141  26.623  1.00  0.00           H  
ATOM    238  HA  LEU A  19     -34.352  -4.319  23.686  1.00  0.00           H  
ATOM    239  HB2 LEU A  19     -33.956  -2.052  25.516  1.00  0.00           H  
ATOM    240  HB3 LEU A  19     -32.886  -2.081  24.116  1.00  0.00           H  
ATOM    241  HG  LEU A  19     -35.648  -2.535  23.363  1.00  0.00           H  
ATOM    242 HD11 LEU A  19     -35.059   0.153  24.577  1.00  0.00           H  
ATOM    243 HD12 LEU A  19     -35.949  -1.115  25.420  1.00  0.00           H  
ATOM    244 HD13 LEU A  19     -36.587  -0.437  23.923  1.00  0.00           H  
ATOM    245 HD21 LEU A  19     -34.080  -1.959  21.703  1.00  0.00           H  
ATOM    246 HD22 LEU A  19     -33.470  -0.593  22.638  1.00  0.00           H  
ATOM    247 HD23 LEU A  19     -35.080  -0.523  21.923  1.00  0.00           H  
ATOM    248  N   LEU A  20     -31.825  -4.522  23.304  1.00  0.00           N  
ATOM    249  CA  LEU A  20     -30.455  -4.988  23.128  1.00  0.00           C  
ATOM    250  C   LEU A  20     -29.503  -3.815  22.920  1.00  0.00           C  
ATOM    251  O   LEU A  20     -29.894  -2.768  22.404  1.00  0.00           O  
ATOM    252  CB  LEU A  20     -30.370  -5.945  21.938  1.00  0.00           C  
ATOM    253  CG  LEU A  20     -29.095  -6.783  21.840  1.00  0.00           C  
ATOM    254  CD1 LEU A  20     -28.884  -7.585  23.115  1.00  0.00           C  
ATOM    255  CD2 LEU A  20     -29.154  -7.705  20.631  1.00  0.00           C  
ATOM    256  H   LEU A  20     -32.344  -4.258  22.517  1.00  0.00           H  
ATOM    257  HA  LEU A  20     -30.166  -5.515  24.025  1.00  0.00           H  
ATOM    258  HB2 LEU A  20     -31.207  -6.624  22.000  1.00  0.00           H  
ATOM    259  HB3 LEU A  20     -30.451  -5.357  21.035  1.00  0.00           H  
ATOM    260  HG  LEU A  20     -28.247  -6.124  21.717  1.00  0.00           H  
ATOM    261 HD11 LEU A  20     -28.023  -8.227  22.998  1.00  0.00           H  
ATOM    262 HD12 LEU A  20     -29.759  -8.188  23.310  1.00  0.00           H  
ATOM    263 HD13 LEU A  20     -28.721  -6.910  23.942  1.00  0.00           H  
ATOM    264 HD21 LEU A  20     -29.692  -8.604  20.891  1.00  0.00           H  
ATOM    265 HD22 LEU A  20     -28.150  -7.962  20.325  1.00  0.00           H  
ATOM    266 HD23 LEU A  20     -29.660  -7.203  19.820  1.00  0.00           H  
ATOM    267  N   TYR A  21     -28.250  -3.997  23.322  1.00  0.00           N  
ATOM    268  CA  TYR A  21     -27.242  -2.954  23.179  1.00  0.00           C  
ATOM    269  C   TYR A  21     -25.931  -3.530  22.651  1.00  0.00           C  
ATOM    270  O   TYR A  21     -25.682  -4.732  22.755  1.00  0.00           O  
ATOM    271  CB  TYR A  21     -27.001  -2.261  24.521  1.00  0.00           C  
ATOM    272  CG  TYR A  21     -27.891  -1.061  24.752  1.00  0.00           C  
ATOM    273  CD1 TYR A  21     -29.169  -1.210  25.277  1.00  0.00           C  
ATOM    274  CD2 TYR A  21     -27.455   0.222  24.446  1.00  0.00           C  
ATOM    275  CE1 TYR A  21     -29.986  -0.117  25.488  1.00  0.00           C  
ATOM    276  CE2 TYR A  21     -28.265   1.321  24.655  1.00  0.00           C  
ATOM    277  CZ  TYR A  21     -29.530   1.147  25.175  1.00  0.00           C  
ATOM    278  OH  TYR A  21     -30.340   2.239  25.386  1.00  0.00           O  
ATOM    279  H   TYR A  21     -27.997  -4.854  23.725  1.00  0.00           H  
ATOM    280  HA  TYR A  21     -27.613  -2.227  22.473  1.00  0.00           H  
ATOM    281  HB2 TYR A  21     -27.181  -2.965  25.319  1.00  0.00           H  
ATOM    282  HB3 TYR A  21     -25.975  -1.927  24.568  1.00  0.00           H  
ATOM    283  HD1 TYR A  21     -29.524  -2.201  25.521  1.00  0.00           H  
ATOM    284  HD2 TYR A  21     -26.463   0.355  24.038  1.00  0.00           H  
ATOM    285  HE1 TYR A  21     -30.977  -0.253  25.896  1.00  0.00           H  
ATOM    286  HE2 TYR A  21     -27.907   2.310  24.410  1.00  0.00           H  
ATOM    287  HH  TYR A  21     -30.046   2.967  24.834  1.00  0.00           H  
ATOM    288  N   ARG A  22     -25.098  -2.665  22.083  1.00  0.00           N  
ATOM    289  CA  ARG A  22     -23.814  -3.087  21.536  1.00  0.00           C  
ATOM    290  C   ARG A  22     -22.853  -1.906  21.433  1.00  0.00           C  
ATOM    291  O   ARG A  22     -23.277  -0.751  21.379  1.00  0.00           O  
ATOM    292  CB  ARG A  22     -24.006  -3.724  20.159  1.00  0.00           C  
ATOM    293  CG  ARG A  22     -24.182  -5.232  20.204  1.00  0.00           C  
ATOM    294  CD  ARG A  22     -24.096  -5.846  18.814  1.00  0.00           C  
ATOM    295  NE  ARG A  22     -25.415  -6.013  18.209  1.00  0.00           N  
ATOM    296  CZ  ARG A  22     -25.603  -6.426  16.961  1.00  0.00           C  
ATOM    297  NH1 ARG A  22     -24.564  -6.713  16.191  1.00  0.00           N  
ATOM    298  NH2 ARG A  22     -26.835  -6.554  16.481  1.00  0.00           N  
ATOM    299  H   ARG A  22     -25.353  -1.721  22.029  1.00  0.00           H  
ATOM    300  HA  ARG A  22     -23.393  -3.821  22.206  1.00  0.00           H  
ATOM    301  HB2 ARG A  22     -24.883  -3.296  19.696  1.00  0.00           H  
ATOM    302  HB3 ARG A  22     -23.144  -3.501  19.549  1.00  0.00           H  
ATOM    303  HG2 ARG A  22     -23.403  -5.657  20.821  1.00  0.00           H  
ATOM    304  HG3 ARG A  22     -25.146  -5.461  20.631  1.00  0.00           H  
ATOM    305  HD2 ARG A  22     -23.502  -5.200  18.186  1.00  0.00           H  
ATOM    306  HD3 ARG A  22     -23.620  -6.811  18.891  1.00  0.00           H  
ATOM    307  HE  ARG A  22     -26.198  -5.806  18.761  1.00  0.00           H  
ATOM    308 HH11 ARG A  22     -23.635  -6.619  16.549  1.00  0.00           H  
ATOM    309 HH12 ARG A  22     -24.708  -7.026  15.251  1.00  0.00           H  
ATOM    310 HH21 ARG A  22     -27.620  -6.338  17.059  1.00  0.00           H  
ATOM    311 HH22 ARG A  22     -26.974  -6.865  15.542  1.00  0.00           H  
ATOM    312  N   ILE A  23     -21.559  -2.204  21.408  1.00  0.00           N  
ATOM    313  CA  ILE A  23     -20.538  -1.168  21.310  1.00  0.00           C  
ATOM    314  C   ILE A  23     -20.265  -0.799  19.856  1.00  0.00           C  
ATOM    315  O   ILE A  23     -20.489  -1.600  18.948  1.00  0.00           O  
ATOM    316  CB  ILE A  23     -19.220  -1.612  21.972  1.00  0.00           C  
ATOM    317  CG1 ILE A  23     -18.715  -2.909  21.333  1.00  0.00           C  
ATOM    318  CG2 ILE A  23     -19.413  -1.793  23.470  1.00  0.00           C  
ATOM    319  CD1 ILE A  23     -17.224  -3.113  21.478  1.00  0.00           C  
ATOM    320  H   ILE A  23     -21.283  -3.143  21.454  1.00  0.00           H  
ATOM    321  HA  ILE A  23     -20.902  -0.293  21.831  1.00  0.00           H  
ATOM    322  HB  ILE A  23     -18.486  -0.836  21.818  1.00  0.00           H  
ATOM    323 HG12 ILE A  23     -19.211  -3.748  21.797  1.00  0.00           H  
ATOM    324 HG13 ILE A  23     -18.948  -2.896  20.278  1.00  0.00           H  
ATOM    325 HG21 ILE A  23     -18.457  -1.720  23.966  1.00  0.00           H  
ATOM    326 HG22 ILE A  23     -20.071  -1.023  23.843  1.00  0.00           H  
ATOM    327 HG23 ILE A  23     -19.846  -2.763  23.662  1.00  0.00           H  
ATOM    328 HD11 ILE A  23     -16.729  -2.812  20.566  1.00  0.00           H  
ATOM    329 HD12 ILE A  23     -16.856  -2.515  22.299  1.00  0.00           H  
ATOM    330 HD13 ILE A  23     -17.020  -4.155  21.671  1.00  0.00           H  
ATOM    331  N   LYS A  24     -19.780   0.419  19.641  1.00  0.00           N  
ATOM    332  CA  LYS A  24     -19.473   0.895  18.298  1.00  0.00           C  
ATOM    333  C   LYS A  24     -17.973   0.841  18.031  1.00  0.00           C  
ATOM    334  O   LYS A  24     -17.185   1.486  18.723  1.00  0.00           O  
ATOM    335  CB  LYS A  24     -19.983   2.327  18.114  1.00  0.00           C  
ATOM    336  CG  LYS A  24     -20.808   2.521  16.854  1.00  0.00           C  
ATOM    337  CD  LYS A  24     -20.107   3.436  15.864  1.00  0.00           C  
ATOM    338  CE  LYS A  24     -20.872   3.529  14.552  1.00  0.00           C  
ATOM    339  NZ  LYS A  24     -20.052   3.073  13.397  1.00  0.00           N  
ATOM    340  H   LYS A  24     -19.623   1.013  20.407  1.00  0.00           H  
ATOM    341  HA  LYS A  24     -19.976   0.250  17.595  1.00  0.00           H  
ATOM    342  HB2 LYS A  24     -20.594   2.591  18.963  1.00  0.00           H  
ATOM    343  HB3 LYS A  24     -19.134   2.995  18.070  1.00  0.00           H  
ATOM    344  HG2 LYS A  24     -20.968   1.560  16.387  1.00  0.00           H  
ATOM    345  HG3 LYS A  24     -21.760   2.957  17.121  1.00  0.00           H  
ATOM    346  HD2 LYS A  24     -20.029   4.424  16.292  1.00  0.00           H  
ATOM    347  HD3 LYS A  24     -19.118   3.048  15.665  1.00  0.00           H  
ATOM    348  HE2 LYS A  24     -21.756   2.912  14.621  1.00  0.00           H  
ATOM    349  HE3 LYS A  24     -21.164   4.557  14.393  1.00  0.00           H  
ATOM    350  HZ1 LYS A  24     -19.218   2.551  13.735  1.00  0.00           H  
ATOM    351  HZ2 LYS A  24     -19.734   3.891  12.839  1.00  0.00           H  
ATOM    352  HZ3 LYS A  24     -20.613   2.446  12.784  1.00  0.00           H  
ATOM    353  N   ASP A  25     -17.584   0.067  17.023  1.00  0.00           N  
ATOM    354  CA  ASP A  25     -16.178  -0.070  16.662  1.00  0.00           C  
ATOM    355  C   ASP A  25     -15.371  -0.638  17.826  1.00  0.00           C  
ATOM    356  O   ASP A  25     -15.904  -0.859  18.914  1.00  0.00           O  
ATOM    357  CB  ASP A  25     -15.603   1.283  16.239  1.00  0.00           C  
ATOM    358  CG  ASP A  25     -15.453   1.403  14.736  1.00  0.00           C  
ATOM    359  OD1 ASP A  25     -14.735   0.572  14.143  1.00  0.00           O  
ATOM    360  OD2 ASP A  25     -16.054   2.330  14.152  1.00  0.00           O  
ATOM    361  H   ASP A  25     -18.260  -0.423  16.509  1.00  0.00           H  
ATOM    362  HA  ASP A  25     -16.114  -0.754  15.829  1.00  0.00           H  
ATOM    363  HB2 ASP A  25     -16.261   2.069  16.581  1.00  0.00           H  
ATOM    364  HB3 ASP A  25     -14.631   1.411  16.692  1.00  0.00           H  
ATOM    365  N   SER A  26     -14.084  -0.872  17.589  1.00  0.00           N  
ATOM    366  CA  SER A  26     -13.206  -1.418  18.617  1.00  0.00           C  
ATOM    367  C   SER A  26     -11.892  -0.644  18.675  1.00  0.00           C  
ATOM    368  O   SER A  26     -10.860  -1.183  19.077  1.00  0.00           O  
ATOM    369  CB  SER A  26     -12.927  -2.898  18.345  1.00  0.00           C  
ATOM    370  OG  SER A  26     -12.383  -3.084  17.050  1.00  0.00           O  
ATOM    371  H   SER A  26     -13.718  -0.674  16.703  1.00  0.00           H  
ATOM    372  HA  SER A  26     -13.708  -1.325  19.567  1.00  0.00           H  
ATOM    373  HB2 SER A  26     -12.223  -3.269  19.075  1.00  0.00           H  
ATOM    374  HB3 SER A  26     -13.849  -3.455  18.418  1.00  0.00           H  
ATOM    375  HG  SER A  26     -11.548  -2.615  16.983  1.00  0.00           H  
ATOM    376  N   GLN A  27     -11.939   0.622  18.274  1.00  0.00           N  
ATOM    377  CA  GLN A  27     -10.754   1.470  18.280  1.00  0.00           C  
ATOM    378  C   GLN A  27     -11.093   2.877  18.762  1.00  0.00           C  
ATOM    379  O   GLN A  27     -10.552   3.349  19.759  1.00  0.00           O  
ATOM    380  CB  GLN A  27     -10.138   1.532  16.881  1.00  0.00           C  
ATOM    381  CG  GLN A  27      -9.569   0.203  16.408  1.00  0.00           C  
ATOM    382  CD  GLN A  27      -8.116   0.018  16.799  1.00  0.00           C  
ATOM    383  OE1 GLN A  27      -7.753  -0.980  17.425  1.00  0.00           O  
ATOM    384  NE2 GLN A  27      -7.277   0.978  16.432  1.00  0.00           N  
ATOM    385  H   GLN A  27     -12.791   0.993  17.965  1.00  0.00           H  
ATOM    386  HA  GLN A  27     -10.038   1.034  18.960  1.00  0.00           H  
ATOM    387  HB2 GLN A  27     -10.896   1.844  16.180  1.00  0.00           H  
ATOM    388  HB3 GLN A  27      -9.339   2.259  16.884  1.00  0.00           H  
ATOM    389  HG2 GLN A  27     -10.149  -0.597  16.844  1.00  0.00           H  
ATOM    390  HG3 GLN A  27      -9.646   0.157  15.332  1.00  0.00           H  
ATOM    391 HE21 GLN A  27      -7.637   1.743  15.936  1.00  0.00           H  
ATOM    392 HE22 GLN A  27      -6.332   0.883  16.672  1.00  0.00           H  
ATOM    393  N   ASN A  28     -11.993   3.541  18.044  1.00  0.00           N  
ATOM    394  CA  ASN A  28     -12.404   4.894  18.397  1.00  0.00           C  
ATOM    395  C   ASN A  28     -13.339   4.882  19.603  1.00  0.00           C  
ATOM    396  O   ASN A  28     -14.545   5.088  19.470  1.00  0.00           O  
ATOM    397  CB  ASN A  28     -13.096   5.567  17.210  1.00  0.00           C  
ATOM    398  CG  ASN A  28     -12.128   6.345  16.341  1.00  0.00           C  
ATOM    399  OD1 ASN A  28     -12.012   6.093  15.141  1.00  0.00           O  
ATOM    400  ND2 ASN A  28     -11.426   7.297  16.944  1.00  0.00           N  
ATOM    401  H   ASN A  28     -12.391   3.111  17.257  1.00  0.00           H  
ATOM    402  HA  ASN A  28     -11.517   5.456  18.650  1.00  0.00           H  
ATOM    403  HB2 ASN A  28     -13.569   4.809  16.600  1.00  0.00           H  
ATOM    404  HB3 ASN A  28     -13.849   6.248  17.577  1.00  0.00           H  
ATOM    405 HD21 ASN A  28     -11.570   7.443  17.903  1.00  0.00           H  
ATOM    406 HD22 ASN A  28     -10.792   7.816  16.405  1.00  0.00           H  
ATOM    407  N   ALA A  29     -12.772   4.639  20.782  1.00  0.00           N  
ATOM    408  CA  ALA A  29     -13.553   4.602  22.011  1.00  0.00           C  
ATOM    409  C   ALA A  29     -12.647   4.491  23.233  1.00  0.00           C  
ATOM    410  O   ALA A  29     -12.120   3.420  23.532  1.00  0.00           O  
ATOM    411  CB  ALA A  29     -14.539   3.444  21.976  1.00  0.00           C  
ATOM    412  H   ALA A  29     -11.806   4.483  20.824  1.00  0.00           H  
ATOM    413  HA  ALA A  29     -14.117   5.522  22.076  1.00  0.00           H  
ATOM    414  HB1 ALA A  29     -14.151   2.623  22.559  1.00  0.00           H  
ATOM    415  HB2 ALA A  29     -15.484   3.765  22.390  1.00  0.00           H  
ATOM    416  HB3 ALA A  29     -14.682   3.125  20.954  1.00  0.00           H  
ATOM    417  N   GLY A  30     -12.470   5.605  23.938  1.00  0.00           N  
ATOM    418  CA  GLY A  30     -11.628   5.610  25.118  1.00  0.00           C  
ATOM    419  C   GLY A  30     -11.396   7.008  25.659  1.00  0.00           C  
ATOM    420  O   GLY A  30     -10.294   7.338  26.096  1.00  0.00           O  
ATOM    421  H   GLY A  30     -12.917   6.431  23.652  1.00  0.00           H  
ATOM    422  HA2 GLY A  30     -12.097   5.012  25.885  1.00  0.00           H  
ATOM    423  HA3 GLY A  30     -10.673   5.172  24.867  1.00  0.00           H  
ATOM    424  N   LYS A  31     -12.438   7.833  25.628  1.00  0.00           N  
ATOM    425  CA  LYS A  31     -12.343   9.203  26.118  1.00  0.00           C  
ATOM    426  C   LYS A  31     -13.425   9.484  27.156  1.00  0.00           C  
ATOM    427  O   LYS A  31     -13.164  10.109  28.184  1.00  0.00           O  
ATOM    428  CB  LYS A  31     -12.467  10.191  24.956  1.00  0.00           C  
ATOM    429  CG  LYS A  31     -13.736  10.014  24.139  1.00  0.00           C  
ATOM    430  CD  LYS A  31     -13.578  10.574  22.735  1.00  0.00           C  
ATOM    431  CE  LYS A  31     -14.863  11.223  22.246  1.00  0.00           C  
ATOM    432  NZ  LYS A  31     -14.743  12.706  22.174  1.00  0.00           N  
ATOM    433  H   LYS A  31     -13.290   7.511  25.267  1.00  0.00           H  
ATOM    434  HA  LYS A  31     -11.376   9.324  26.581  1.00  0.00           H  
ATOM    435  HB2 LYS A  31     -12.457  11.196  25.351  1.00  0.00           H  
ATOM    436  HB3 LYS A  31     -11.620  10.063  24.299  1.00  0.00           H  
ATOM    437  HG2 LYS A  31     -13.964   8.960  24.071  1.00  0.00           H  
ATOM    438  HG3 LYS A  31     -14.547  10.528  24.633  1.00  0.00           H  
ATOM    439  HD2 LYS A  31     -12.792  11.314  22.739  1.00  0.00           H  
ATOM    440  HD3 LYS A  31     -13.313   9.769  22.064  1.00  0.00           H  
ATOM    441  HE2 LYS A  31     -15.093  10.841  21.263  1.00  0.00           H  
ATOM    442  HE3 LYS A  31     -15.661  10.968  22.928  1.00  0.00           H  
ATOM    443  HZ1 LYS A  31     -14.036  12.973  21.459  1.00  0.00           H  
ATOM    444  HZ2 LYS A  31     -14.447  13.085  23.096  1.00  0.00           H  
ATOM    445  HZ3 LYS A  31     -15.658  13.127  21.917  1.00  0.00           H  
ATOM    446  N   MET A  32     -14.638   9.017  26.882  1.00  0.00           N  
ATOM    447  CA  MET A  32     -15.759   9.218  27.795  1.00  0.00           C  
ATOM    448  C   MET A  32     -15.912  10.692  28.152  1.00  0.00           C  
ATOM    449  O   MET A  32     -15.268  11.557  27.556  1.00  0.00           O  
ATOM    450  CB  MET A  32     -15.562   8.390  29.066  1.00  0.00           C  
ATOM    451  CG  MET A  32     -15.226   6.933  28.798  1.00  0.00           C  
ATOM    452  SD  MET A  32     -16.057   5.807  29.933  1.00  0.00           S  
ATOM    453  CE  MET A  32     -17.186   4.975  28.819  1.00  0.00           C  
ATOM    454  H   MET A  32     -14.786   8.526  26.047  1.00  0.00           H  
ATOM    455  HA  MET A  32     -16.656   8.885  27.295  1.00  0.00           H  
ATOM    456  HB2 MET A  32     -14.756   8.823  29.641  1.00  0.00           H  
ATOM    457  HB3 MET A  32     -16.469   8.426  29.650  1.00  0.00           H  
ATOM    458  HG2 MET A  32     -15.523   6.688  27.789  1.00  0.00           H  
ATOM    459  HG3 MET A  32     -14.158   6.799  28.897  1.00  0.00           H  
ATOM    460  HE1 MET A  32     -18.038   5.610  28.629  1.00  0.00           H  
ATOM    461  HE2 MET A  32     -16.680   4.761  27.889  1.00  0.00           H  
ATOM    462  HE3 MET A  32     -17.519   4.050  29.269  1.00  0.00           H  
ATOM    463  N   LYS A  33     -16.770  10.974  29.126  1.00  0.00           N  
ATOM    464  CA  LYS A  33     -17.008  12.344  29.564  1.00  0.00           C  
ATOM    465  C   LYS A  33     -17.662  12.370  30.942  1.00  0.00           C  
ATOM    466  O   LYS A  33     -17.060  12.816  31.917  1.00  0.00           O  
ATOM    467  CB  LYS A  33     -17.893  13.078  28.553  1.00  0.00           C  
ATOM    468  CG  LYS A  33     -17.849  14.589  28.690  1.00  0.00           C  
ATOM    469  CD  LYS A  33     -16.572  15.166  28.101  1.00  0.00           C  
ATOM    470  CE  LYS A  33     -16.828  16.502  27.419  1.00  0.00           C  
ATOM    471  NZ  LYS A  33     -17.234  17.552  28.393  1.00  0.00           N  
ATOM    472  H   LYS A  33     -17.254  10.242  29.563  1.00  0.00           H  
ATOM    473  HA  LYS A  33     -16.053  12.845  29.623  1.00  0.00           H  
ATOM    474  HB2 LYS A  33     -17.572  12.818  27.556  1.00  0.00           H  
ATOM    475  HB3 LYS A  33     -18.915  12.755  28.688  1.00  0.00           H  
ATOM    476  HG2 LYS A  33     -18.697  15.015  28.173  1.00  0.00           H  
ATOM    477  HG3 LYS A  33     -17.900  14.848  29.739  1.00  0.00           H  
ATOM    478  HD2 LYS A  33     -15.853  15.310  28.893  1.00  0.00           H  
ATOM    479  HD3 LYS A  33     -16.177  14.471  27.374  1.00  0.00           H  
ATOM    480  HE2 LYS A  33     -15.923  16.815  26.922  1.00  0.00           H  
ATOM    481  HE3 LYS A  33     -17.614  16.376  26.691  1.00  0.00           H  
ATOM    482  HZ1 LYS A  33     -16.503  17.664  29.125  1.00  0.00           H  
ATOM    483  HZ2 LYS A  33     -18.130  17.288  28.850  1.00  0.00           H  
ATOM    484  HZ3 LYS A  33     -17.362  18.461  27.905  1.00  0.00           H  
ATOM    485  N   GLY A  34     -18.898  11.885  31.014  1.00  0.00           N  
ATOM    486  CA  GLY A  34     -19.613  11.860  32.277  1.00  0.00           C  
ATOM    487  C   GLY A  34     -18.988  10.907  33.278  1.00  0.00           C  
ATOM    488  O   GLY A  34     -17.867  11.125  33.736  1.00  0.00           O  
ATOM    489  H   GLY A  34     -19.329  11.542  30.203  1.00  0.00           H  
ATOM    490  HA2 GLY A  34     -19.615  12.855  32.697  1.00  0.00           H  
ATOM    491  HA3 GLY A  34     -20.632  11.555  32.095  1.00  0.00           H  
ATOM    492  N   SER A  35     -19.717   9.849  33.618  1.00  0.00           N  
ATOM    493  CA  SER A  35     -19.230   8.862  34.574  1.00  0.00           C  
ATOM    494  C   SER A  35     -17.882   8.299  34.136  1.00  0.00           C  
ATOM    495  O   SER A  35     -17.662   8.037  32.954  1.00  0.00           O  
ATOM    496  CB  SER A  35     -20.244   7.727  34.729  1.00  0.00           C  
ATOM    497  OG  SER A  35     -21.070   7.932  35.863  1.00  0.00           O  
ATOM    498  H   SER A  35     -20.604   9.730  33.217  1.00  0.00           H  
ATOM    499  HA  SER A  35     -19.108   9.356  35.528  1.00  0.00           H  
ATOM    500  HB2 SER A  35     -20.867   7.682  33.849  1.00  0.00           H  
ATOM    501  HB3 SER A  35     -19.717   6.791  34.846  1.00  0.00           H  
ATOM    502  HG  SER A  35     -21.726   7.233  35.911  1.00  0.00           H  
ATOM    503  N   ASP A  36     -16.983   8.115  35.097  1.00  0.00           N  
ATOM    504  CA  ASP A  36     -15.657   7.582  34.812  1.00  0.00           C  
ATOM    505  C   ASP A  36     -15.630   6.066  34.986  1.00  0.00           C  
ATOM    506  O   ASP A  36     -15.359   5.328  34.040  1.00  0.00           O  
ATOM    507  CB  ASP A  36     -14.615   8.230  35.725  1.00  0.00           C  
ATOM    508  CG  ASP A  36     -14.086   9.536  35.165  1.00  0.00           C  
ATOM    509  OD1 ASP A  36     -13.399   9.499  34.123  1.00  0.00           O  
ATOM    510  OD2 ASP A  36     -14.359  10.595  35.768  1.00  0.00           O  
ATOM    511  H   ASP A  36     -17.218   8.344  36.021  1.00  0.00           H  
ATOM    512  HA  ASP A  36     -15.418   7.818  33.786  1.00  0.00           H  
ATOM    513  HB2 ASP A  36     -15.065   8.430  36.688  1.00  0.00           H  
ATOM    514  HB3 ASP A  36     -13.785   7.551  35.853  1.00  0.00           H  
ATOM    515  N   ASN A  37     -15.915   5.611  36.201  1.00  0.00           N  
ATOM    516  CA  ASN A  37     -15.923   4.184  36.500  1.00  0.00           C  
ATOM    517  C   ASN A  37     -17.312   3.591  36.286  1.00  0.00           C  
ATOM    518  O   ASN A  37     -17.455   2.518  35.700  1.00  0.00           O  
ATOM    519  CB  ASN A  37     -15.469   3.940  37.941  1.00  0.00           C  
ATOM    520  CG  ASN A  37     -14.013   4.304  38.158  1.00  0.00           C  
ATOM    521  OD1 ASN A  37     -13.413   5.015  37.352  1.00  0.00           O  
ATOM    522  ND2 ASN A  37     -13.437   3.814  39.250  1.00  0.00           N  
ATOM    523  H   ASN A  37     -16.124   6.249  36.915  1.00  0.00           H  
ATOM    524  HA  ASN A  37     -15.230   3.700  35.827  1.00  0.00           H  
ATOM    525  HB2 ASN A  37     -16.073   4.539  38.608  1.00  0.00           H  
ATOM    526  HB3 ASN A  37     -15.601   2.896  38.183  1.00  0.00           H  
ATOM    527 HD21 ASN A  37     -13.977   3.254  39.846  1.00  0.00           H  
ATOM    528 HD22 ASN A  37     -12.496   4.034  39.415  1.00  0.00           H  
ATOM    529  N   GLN A  38     -18.332   4.297  36.764  1.00  0.00           N  
ATOM    530  CA  GLN A  38     -19.709   3.840  36.624  1.00  0.00           C  
ATOM    531  C   GLN A  38     -20.046   3.566  35.163  1.00  0.00           C  
ATOM    532  O   GLN A  38     -20.914   2.747  34.860  1.00  0.00           O  
ATOM    533  CB  GLN A  38     -20.674   4.880  37.197  1.00  0.00           C  
ATOM    534  CG  GLN A  38     -21.574   4.335  38.293  1.00  0.00           C  
ATOM    535  CD  GLN A  38     -20.844   4.144  39.608  1.00  0.00           C  
ATOM    536  OE1 GLN A  38     -20.542   5.111  40.309  1.00  0.00           O  
ATOM    537  NE2 GLN A  38     -20.557   2.894  39.950  1.00  0.00           N  
ATOM    538  H   GLN A  38     -18.152   5.143  37.222  1.00  0.00           H  
ATOM    539  HA  GLN A  38     -19.812   2.921  37.183  1.00  0.00           H  
ATOM    540  HB2 GLN A  38     -20.100   5.699  37.605  1.00  0.00           H  
ATOM    541  HB3 GLN A  38     -21.300   5.250  36.398  1.00  0.00           H  
ATOM    542  HG2 GLN A  38     -22.389   5.026  38.449  1.00  0.00           H  
ATOM    543  HG3 GLN A  38     -21.970   3.381  37.976  1.00  0.00           H  
ATOM    544 HE21 GLN A  38     -20.828   2.175  39.341  1.00  0.00           H  
ATOM    545 HE22 GLN A  38     -20.085   2.741  40.794  1.00  0.00           H  
ATOM    546  N   GLU A  39     -19.355   4.257  34.261  1.00  0.00           N  
ATOM    547  CA  GLU A  39     -19.584   4.088  32.831  1.00  0.00           C  
ATOM    548  C   GLU A  39     -18.637   3.042  32.249  1.00  0.00           C  
ATOM    549  O   GLU A  39     -19.041   2.203  31.443  1.00  0.00           O  
ATOM    550  CB  GLU A  39     -19.400   5.421  32.102  1.00  0.00           C  
ATOM    551  CG  GLU A  39     -20.694   5.998  31.553  1.00  0.00           C  
ATOM    552  CD  GLU A  39     -20.582   7.475  31.230  1.00  0.00           C  
ATOM    553  OE1 GLU A  39     -19.509   7.897  30.751  1.00  0.00           O  
ATOM    554  OE2 GLU A  39     -21.568   8.208  31.455  1.00  0.00           O  
ATOM    555  H   GLU A  39     -18.677   4.895  34.565  1.00  0.00           H  
ATOM    556  HA  GLU A  39     -20.601   3.751  32.695  1.00  0.00           H  
ATOM    557  HB2 GLU A  39     -18.972   6.137  32.788  1.00  0.00           H  
ATOM    558  HB3 GLU A  39     -18.718   5.274  31.278  1.00  0.00           H  
ATOM    559  HG2 GLU A  39     -20.956   5.467  30.651  1.00  0.00           H  
ATOM    560  HG3 GLU A  39     -21.474   5.863  32.289  1.00  0.00           H  
ATOM    561  N   LYS A  40     -17.376   3.100  32.662  1.00  0.00           N  
ATOM    562  CA  LYS A  40     -16.370   2.157  32.184  1.00  0.00           C  
ATOM    563  C   LYS A  40     -16.778   0.722  32.495  1.00  0.00           C  
ATOM    564  O   LYS A  40     -16.416  -0.208  31.772  1.00  0.00           O  
ATOM    565  CB  LYS A  40     -15.013   2.463  32.820  1.00  0.00           C  
ATOM    566  CG  LYS A  40     -14.126   3.351  31.963  1.00  0.00           C  
ATOM    567  CD  LYS A  40     -12.653   3.056  32.194  1.00  0.00           C  
ATOM    568  CE  LYS A  40     -11.769   4.163  31.641  1.00  0.00           C  
ATOM    569  NZ  LYS A  40     -10.516   4.320  32.431  1.00  0.00           N  
ATOM    570  H   LYS A  40     -17.115   3.791  33.306  1.00  0.00           H  
ATOM    571  HA  LYS A  40     -16.291   2.273  31.114  1.00  0.00           H  
ATOM    572  HB2 LYS A  40     -15.175   2.958  33.766  1.00  0.00           H  
ATOM    573  HB3 LYS A  40     -14.493   1.533  32.995  1.00  0.00           H  
ATOM    574  HG2 LYS A  40     -14.356   3.178  30.923  1.00  0.00           H  
ATOM    575  HG3 LYS A  40     -14.319   4.384  32.211  1.00  0.00           H  
ATOM    576  HD2 LYS A  40     -12.474   2.965  33.256  1.00  0.00           H  
ATOM    577  HD3 LYS A  40     -12.400   2.125  31.704  1.00  0.00           H  
ATOM    578  HE2 LYS A  40     -11.513   3.925  30.620  1.00  0.00           H  
ATOM    579  HE3 LYS A  40     -12.320   5.092  31.667  1.00  0.00           H  
ATOM    580  HZ1 LYS A  40     -10.141   3.387  32.697  1.00  0.00           H  
ATOM    581  HZ2 LYS A  40     -10.707   4.865  33.297  1.00  0.00           H  
ATOM    582  HZ3 LYS A  40      -9.800   4.822  31.869  1.00  0.00           H  
ATOM    583  N   LEU A  41     -17.533   0.546  33.573  1.00  0.00           N  
ATOM    584  CA  LEU A  41     -17.991  -0.778  33.980  1.00  0.00           C  
ATOM    585  C   LEU A  41     -19.078  -1.290  33.040  1.00  0.00           C  
ATOM    586  O   LEU A  41     -19.236  -2.497  32.856  1.00  0.00           O  
ATOM    587  CB  LEU A  41     -18.520  -0.738  35.415  1.00  0.00           C  
ATOM    588  CG  LEU A  41     -19.019  -2.067  35.983  1.00  0.00           C  
ATOM    589  CD1 LEU A  41     -17.872  -2.845  36.607  1.00  0.00           C  
ATOM    590  CD2 LEU A  41     -20.122  -1.830  37.004  1.00  0.00           C  
ATOM    591  H   LEU A  41     -17.790   1.325  34.110  1.00  0.00           H  
ATOM    592  HA  LEU A  41     -17.147  -1.449  33.935  1.00  0.00           H  
ATOM    593  HB2 LEU A  41     -17.722  -0.385  36.051  1.00  0.00           H  
ATOM    594  HB3 LEU A  41     -19.340  -0.035  35.445  1.00  0.00           H  
ATOM    595  HG  LEU A  41     -19.428  -2.664  35.180  1.00  0.00           H  
ATOM    596 HD11 LEU A  41     -16.986  -2.227  36.628  1.00  0.00           H  
ATOM    597 HD12 LEU A  41     -17.678  -3.733  36.021  1.00  0.00           H  
ATOM    598 HD13 LEU A  41     -18.135  -3.131  37.615  1.00  0.00           H  
ATOM    599 HD21 LEU A  41     -20.461  -2.777  37.396  1.00  0.00           H  
ATOM    600 HD22 LEU A  41     -20.948  -1.320  36.530  1.00  0.00           H  
ATOM    601 HD23 LEU A  41     -19.740  -1.222  37.812  1.00  0.00           H  
ATOM    602  N   VAL A  42     -19.823  -0.364  32.444  1.00  0.00           N  
ATOM    603  CA  VAL A  42     -20.893  -0.722  31.521  1.00  0.00           C  
ATOM    604  C   VAL A  42     -20.341  -1.027  30.133  1.00  0.00           C  
ATOM    605  O   VAL A  42     -20.595  -2.094  29.572  1.00  0.00           O  
ATOM    606  CB  VAL A  42     -21.938   0.405  31.409  1.00  0.00           C  
ATOM    607  CG1 VAL A  42     -23.116  -0.042  30.556  1.00  0.00           C  
ATOM    608  CG2 VAL A  42     -22.403   0.837  32.791  1.00  0.00           C  
ATOM    609  H   VAL A  42     -19.649   0.582  32.631  1.00  0.00           H  
ATOM    610  HA  VAL A  42     -21.385  -1.603  31.904  1.00  0.00           H  
ATOM    611  HB  VAL A  42     -21.474   1.252  30.926  1.00  0.00           H  
ATOM    612 HG11 VAL A  42     -22.754  -0.402  29.604  1.00  0.00           H  
ATOM    613 HG12 VAL A  42     -23.647  -0.834  31.063  1.00  0.00           H  
ATOM    614 HG13 VAL A  42     -23.781   0.793  30.396  1.00  0.00           H  
ATOM    615 HG21 VAL A  42     -22.116   0.093  33.517  1.00  0.00           H  
ATOM    616 HG22 VAL A  42     -21.947   1.783  33.044  1.00  0.00           H  
ATOM    617 HG23 VAL A  42     -23.479   0.945  32.792  1.00  0.00           H  
ATOM    618  N   TYR A  43     -19.584  -0.084  29.583  1.00  0.00           N  
ATOM    619  CA  TYR A  43     -18.997  -0.251  28.259  1.00  0.00           C  
ATOM    620  C   TYR A  43     -18.230  -1.566  28.165  1.00  0.00           C  
ATOM    621  O   TYR A  43     -18.146  -2.173  27.098  1.00  0.00           O  
ATOM    622  CB  TYR A  43     -18.064   0.919  27.940  1.00  0.00           C  
ATOM    623  CG  TYR A  43     -17.593   0.943  26.504  1.00  0.00           C  
ATOM    624  CD1 TYR A  43     -16.467   0.230  26.110  1.00  0.00           C  
ATOM    625  CD2 TYR A  43     -18.273   1.677  25.540  1.00  0.00           C  
ATOM    626  CE1 TYR A  43     -16.032   0.250  24.799  1.00  0.00           C  
ATOM    627  CE2 TYR A  43     -17.845   1.703  24.227  1.00  0.00           C  
ATOM    628  CZ  TYR A  43     -16.724   0.987  23.861  1.00  0.00           C  
ATOM    629  OH  TYR A  43     -16.295   1.008  22.554  1.00  0.00           O  
ATOM    630  H   TYR A  43     -19.417   0.745  30.078  1.00  0.00           H  
ATOM    631  HA  TYR A  43     -19.801  -0.264  27.538  1.00  0.00           H  
ATOM    632  HB2 TYR A  43     -18.582   1.846  28.133  1.00  0.00           H  
ATOM    633  HB3 TYR A  43     -17.192   0.860  28.575  1.00  0.00           H  
ATOM    634  HD1 TYR A  43     -15.926  -0.347  26.847  1.00  0.00           H  
ATOM    635  HD2 TYR A  43     -19.151   2.237  25.830  1.00  0.00           H  
ATOM    636  HE1 TYR A  43     -15.154  -0.311  24.512  1.00  0.00           H  
ATOM    637  HE2 TYR A  43     -18.388   2.279  23.492  1.00  0.00           H  
ATOM    638  HH  TYR A  43     -15.387   0.697  22.510  1.00  0.00           H  
ATOM    639  N   GLN A  44     -17.673  -2.001  29.291  1.00  0.00           N  
ATOM    640  CA  GLN A  44     -16.913  -3.245  29.336  1.00  0.00           C  
ATOM    641  C   GLN A  44     -17.822  -4.447  29.098  1.00  0.00           C  
ATOM    642  O   GLN A  44     -17.475  -5.358  28.346  1.00  0.00           O  
ATOM    643  CB  GLN A  44     -16.205  -3.386  30.685  1.00  0.00           C  
ATOM    644  CG  GLN A  44     -14.870  -2.661  30.750  1.00  0.00           C  
ATOM    645  CD  GLN A  44     -13.795  -3.344  29.928  1.00  0.00           C  
ATOM    646  OE1 GLN A  44     -13.121  -4.259  30.404  1.00  0.00           O  
ATOM    647  NE2 GLN A  44     -13.628  -2.903  28.687  1.00  0.00           N  
ATOM    648  H   GLN A  44     -17.775  -1.473  30.109  1.00  0.00           H  
ATOM    649  HA  GLN A  44     -16.171  -3.209  28.553  1.00  0.00           H  
ATOM    650  HB2 GLN A  44     -16.846  -2.986  31.458  1.00  0.00           H  
ATOM    651  HB3 GLN A  44     -16.030  -4.433  30.879  1.00  0.00           H  
ATOM    652  HG2 GLN A  44     -15.002  -1.656  30.377  1.00  0.00           H  
ATOM    653  HG3 GLN A  44     -14.547  -2.622  31.779  1.00  0.00           H  
ATOM    654 HE21 GLN A  44     -14.200  -2.169  28.376  1.00  0.00           H  
ATOM    655 HE22 GLN A  44     -12.939  -3.325  28.134  1.00  0.00           H  
ATOM    656  N   ILE A  45     -18.983  -4.442  29.743  1.00  0.00           N  
ATOM    657  CA  ILE A  45     -19.941  -5.531  29.600  1.00  0.00           C  
ATOM    658  C   ILE A  45     -20.546  -5.550  28.201  1.00  0.00           C  
ATOM    659  O   ILE A  45     -20.730  -6.614  27.608  1.00  0.00           O  
ATOM    660  CB  ILE A  45     -21.074  -5.424  30.637  1.00  0.00           C  
ATOM    661  CG1 ILE A  45     -20.499  -5.427  32.055  1.00  0.00           C  
ATOM    662  CG2 ILE A  45     -22.064  -6.566  30.459  1.00  0.00           C  
ATOM    663  CD1 ILE A  45     -21.472  -4.931  33.102  1.00  0.00           C  
ATOM    664  H   ILE A  45     -19.202  -3.687  30.328  1.00  0.00           H  
ATOM    665  HA  ILE A  45     -19.414  -6.461  29.766  1.00  0.00           H  
ATOM    666  HB  ILE A  45     -21.598  -4.496  30.470  1.00  0.00           H  
ATOM    667 HG12 ILE A  45     -20.214  -6.433  32.319  1.00  0.00           H  
ATOM    668 HG13 ILE A  45     -19.627  -4.790  32.083  1.00  0.00           H  
ATOM    669 HG21 ILE A  45     -22.697  -6.633  31.332  1.00  0.00           H  
ATOM    670 HG22 ILE A  45     -22.674  -6.380  29.587  1.00  0.00           H  
ATOM    671 HG23 ILE A  45     -21.526  -7.493  30.331  1.00  0.00           H  
ATOM    672 HD11 ILE A  45     -22.483  -5.064  32.746  1.00  0.00           H  
ATOM    673 HD12 ILE A  45     -21.336  -5.492  34.015  1.00  0.00           H  
ATOM    674 HD13 ILE A  45     -21.293  -3.883  33.292  1.00  0.00           H  
ATOM    675  N   ILE A  46     -20.854  -4.367  27.680  1.00  0.00           N  
ATOM    676  CA  ILE A  46     -21.437  -4.248  26.349  1.00  0.00           C  
ATOM    677  C   ILE A  46     -20.424  -4.617  25.270  1.00  0.00           C  
ATOM    678  O   ILE A  46     -20.776  -5.214  24.254  1.00  0.00           O  
ATOM    679  CB  ILE A  46     -21.954  -2.821  26.086  1.00  0.00           C  
ATOM    680  CG1 ILE A  46     -22.997  -2.432  27.136  1.00  0.00           C  
ATOM    681  CG2 ILE A  46     -22.539  -2.719  24.686  1.00  0.00           C  
ATOM    682  CD1 ILE A  46     -23.444  -0.990  27.037  1.00  0.00           C  
ATOM    683  H   ILE A  46     -20.684  -3.556  28.201  1.00  0.00           H  
ATOM    684  HA  ILE A  46     -22.274  -4.929  26.289  1.00  0.00           H  
ATOM    685  HB  ILE A  46     -21.117  -2.142  26.151  1.00  0.00           H  
ATOM    686 HG12 ILE A  46     -23.867  -3.057  27.018  1.00  0.00           H  
ATOM    687 HG13 ILE A  46     -22.580  -2.584  28.120  1.00  0.00           H  
ATOM    688 HG21 ILE A  46     -23.561  -2.371  24.747  1.00  0.00           H  
ATOM    689 HG22 ILE A  46     -21.957  -2.022  24.103  1.00  0.00           H  
ATOM    690 HG23 ILE A  46     -22.518  -3.690  24.215  1.00  0.00           H  
ATOM    691 HD11 ILE A  46     -22.613  -0.339  27.271  1.00  0.00           H  
ATOM    692 HD12 ILE A  46     -23.787  -0.787  26.034  1.00  0.00           H  
ATOM    693 HD13 ILE A  46     -24.247  -0.813  27.737  1.00  0.00           H  
ATOM    694  N   GLU A  47     -19.165  -4.258  25.500  1.00  0.00           N  
ATOM    695  CA  GLU A  47     -18.101  -4.552  24.547  1.00  0.00           C  
ATOM    696  C   GLU A  47     -17.841  -6.053  24.468  1.00  0.00           C  
ATOM    697  O   GLU A  47     -17.627  -6.601  23.388  1.00  0.00           O  
ATOM    698  CB  GLU A  47     -16.816  -3.821  24.943  1.00  0.00           C  
ATOM    699  CG  GLU A  47     -15.629  -4.155  24.055  1.00  0.00           C  
ATOM    700  CD  GLU A  47     -14.450  -4.700  24.838  1.00  0.00           C  
ATOM    701  OE1 GLU A  47     -14.240  -4.248  25.983  1.00  0.00           O  
ATOM    702  OE2 GLU A  47     -13.739  -5.577  24.306  1.00  0.00           O  
ATOM    703  H   GLU A  47     -18.947  -3.782  26.330  1.00  0.00           H  
ATOM    704  HA  GLU A  47     -18.419  -4.202  23.576  1.00  0.00           H  
ATOM    705  HB2 GLU A  47     -16.991  -2.756  24.890  1.00  0.00           H  
ATOM    706  HB3 GLU A  47     -16.565  -4.085  25.959  1.00  0.00           H  
ATOM    707  HG2 GLU A  47     -15.933  -4.895  23.331  1.00  0.00           H  
ATOM    708  HG3 GLU A  47     -15.317  -3.257  23.541  1.00  0.00           H  
ATOM    709  N   ASP A  48     -17.862  -6.713  25.622  1.00  0.00           N  
ATOM    710  CA  ASP A  48     -17.630  -8.150  25.685  1.00  0.00           C  
ATOM    711  C   ASP A  48     -18.659  -8.905  24.849  1.00  0.00           C  
ATOM    712  O   ASP A  48     -18.384  -9.990  24.339  1.00  0.00           O  
ATOM    713  CB  ASP A  48     -17.679  -8.634  27.135  1.00  0.00           C  
ATOM    714  CG  ASP A  48     -17.833 -10.139  27.239  1.00  0.00           C  
ATOM    715  OD1 ASP A  48     -16.962 -10.862  26.712  1.00  0.00           O  
ATOM    716  OD2 ASP A  48     -18.824 -10.593  27.848  1.00  0.00           O  
ATOM    717  H   ASP A  48     -18.039  -6.220  26.451  1.00  0.00           H  
ATOM    718  HA  ASP A  48     -16.647  -8.346  25.284  1.00  0.00           H  
ATOM    719  HB2 ASP A  48     -16.764  -8.349  27.635  1.00  0.00           H  
ATOM    720  HB3 ASP A  48     -18.516  -8.169  27.634  1.00  0.00           H  
ATOM    721  N   ALA A  49     -19.846  -8.321  24.714  1.00  0.00           N  
ATOM    722  CA  ALA A  49     -20.916  -8.938  23.941  1.00  0.00           C  
ATOM    723  C   ALA A  49     -20.578  -8.957  22.453  1.00  0.00           C  
ATOM    724  O   ALA A  49     -20.979  -9.865  21.727  1.00  0.00           O  
ATOM    725  CB  ALA A  49     -22.228  -8.203  24.175  1.00  0.00           C  
ATOM    726  H   ALA A  49     -20.005  -7.456  25.145  1.00  0.00           H  
ATOM    727  HA  ALA A  49     -21.035  -9.955  24.286  1.00  0.00           H  
ATOM    728  HB1 ALA A  49     -22.326  -7.405  23.455  1.00  0.00           H  
ATOM    729  HB2 ALA A  49     -23.051  -8.893  24.063  1.00  0.00           H  
ATOM    730  HB3 ALA A  49     -22.236  -7.791  25.173  1.00  0.00           H  
ATOM    731  N   GLY A  50     -19.836  -7.949  22.007  1.00  0.00           N  
ATOM    732  CA  GLY A  50     -19.457  -7.869  20.608  1.00  0.00           C  
ATOM    733  C   GLY A  50     -20.654  -7.745  19.689  1.00  0.00           C  
ATOM    734  O   GLY A  50     -21.350  -6.730  19.697  1.00  0.00           O  
ATOM    735  H   GLY A  50     -19.544  -7.252  22.633  1.00  0.00           H  
ATOM    736  HA2 GLY A  50     -18.817  -7.009  20.468  1.00  0.00           H  
ATOM    737  HA3 GLY A  50     -18.906  -8.760  20.346  1.00  0.00           H  
ATOM    738  N   ASN A  51     -20.896  -8.780  18.891  1.00  0.00           N  
ATOM    739  CA  ASN A  51     -22.017  -8.782  17.959  1.00  0.00           C  
ATOM    740  C   ASN A  51     -23.275  -9.337  18.621  1.00  0.00           C  
ATOM    741  O   ASN A  51     -24.394  -8.993  18.242  1.00  0.00           O  
ATOM    742  CB  ASN A  51     -21.675  -9.607  16.718  1.00  0.00           C  
ATOM    743  CG  ASN A  51     -22.609  -9.322  15.557  1.00  0.00           C  
ATOM    744  OD1 ASN A  51     -23.659  -9.950  15.422  1.00  0.00           O  
ATOM    745  ND2 ASN A  51     -22.229  -8.370  14.713  1.00  0.00           N  
ATOM    746  H   ASN A  51     -20.306  -9.562  18.929  1.00  0.00           H  
ATOM    747  HA  ASN A  51     -22.203  -7.761  17.661  1.00  0.00           H  
ATOM    748  HB2 ASN A  51     -20.666  -9.377  16.406  1.00  0.00           H  
ATOM    749  HB3 ASN A  51     -21.742 -10.657  16.960  1.00  0.00           H  
ATOM    750 HD21 ASN A  51     -21.379  -7.912  14.883  1.00  0.00           H  
ATOM    751 HD22 ASN A  51     -22.814  -8.165  13.954  1.00  0.00           H  
ATOM    752  N   LYS A  52     -23.082 -10.199  19.615  1.00  0.00           N  
ATOM    753  CA  LYS A  52     -24.199 -10.801  20.333  1.00  0.00           C  
ATOM    754  C   LYS A  52     -24.988  -9.744  21.097  1.00  0.00           C  
ATOM    755  O   LYS A  52     -26.186  -9.898  21.331  1.00  0.00           O  
ATOM    756  CB  LYS A  52     -23.691 -11.872  21.302  1.00  0.00           C  
ATOM    757  CG  LYS A  52     -22.739 -12.869  20.661  1.00  0.00           C  
ATOM    758  CD  LYS A  52     -23.122 -14.300  20.998  1.00  0.00           C  
ATOM    759  CE  LYS A  52     -23.774 -14.996  19.813  1.00  0.00           C  
ATOM    760  NZ  LYS A  52     -23.926 -16.459  20.044  1.00  0.00           N  
ATOM    761  H   LYS A  52     -22.165 -10.434  19.872  1.00  0.00           H  
ATOM    762  HA  LYS A  52     -24.849 -11.265  19.606  1.00  0.00           H  
ATOM    763  HB2 LYS A  52     -23.175 -11.387  22.117  1.00  0.00           H  
ATOM    764  HB3 LYS A  52     -24.538 -12.416  21.694  1.00  0.00           H  
ATOM    765  HG2 LYS A  52     -22.767 -12.742  19.589  1.00  0.00           H  
ATOM    766  HG3 LYS A  52     -21.738 -12.679  21.021  1.00  0.00           H  
ATOM    767  HD2 LYS A  52     -22.232 -14.845  21.277  1.00  0.00           H  
ATOM    768  HD3 LYS A  52     -23.816 -14.293  21.827  1.00  0.00           H  
ATOM    769  HE2 LYS A  52     -24.748 -14.563  19.649  1.00  0.00           H  
ATOM    770  HE3 LYS A  52     -23.159 -14.841  18.939  1.00  0.00           H  
ATOM    771  HZ1 LYS A  52     -24.367 -16.908  19.216  1.00  0.00           H  
ATOM    772  HZ2 LYS A  52     -24.526 -16.628  20.878  1.00  0.00           H  
ATOM    773  HZ3 LYS A  52     -22.996 -16.894  20.208  1.00  0.00           H  
ATOM    774  N   GLY A  53     -24.309  -8.668  21.483  1.00  0.00           N  
ATOM    775  CA  GLY A  53     -24.965  -7.599  22.215  1.00  0.00           C  
ATOM    776  C   GLY A  53     -25.460  -8.048  23.575  1.00  0.00           C  
ATOM    777  O   GLY A  53     -25.611  -9.245  23.824  1.00  0.00           O  
ATOM    778  H   GLY A  53     -23.355  -8.599  21.268  1.00  0.00           H  
ATOM    779  HA2 GLY A  53     -24.265  -6.788  22.348  1.00  0.00           H  
ATOM    780  HA3 GLY A  53     -25.805  -7.246  21.637  1.00  0.00           H  
ATOM    781  N   ILE A  54     -25.712  -7.088  24.459  1.00  0.00           N  
ATOM    782  CA  ILE A  54     -26.193  -7.392  25.800  1.00  0.00           C  
ATOM    783  C   ILE A  54     -27.474  -6.626  26.112  1.00  0.00           C  
ATOM    784  O   ILE A  54     -27.573  -5.428  25.849  1.00  0.00           O  
ATOM    785  CB  ILE A  54     -25.135  -7.054  26.867  1.00  0.00           C  
ATOM    786  CG1 ILE A  54     -25.590  -7.548  28.242  1.00  0.00           C  
ATOM    787  CG2 ILE A  54     -24.871  -5.556  26.896  1.00  0.00           C  
ATOM    788  CD1 ILE A  54     -24.588  -8.456  28.921  1.00  0.00           C  
ATOM    789  H   ILE A  54     -25.572  -6.154  24.201  1.00  0.00           H  
ATOM    790  HA  ILE A  54     -26.399  -8.451  25.848  1.00  0.00           H  
ATOM    791  HB  ILE A  54     -24.215  -7.553  26.600  1.00  0.00           H  
ATOM    792 HG12 ILE A  54     -25.756  -6.698  28.886  1.00  0.00           H  
ATOM    793 HG13 ILE A  54     -26.514  -8.096  28.132  1.00  0.00           H  
ATOM    794 HG21 ILE A  54     -25.663  -5.063  27.441  1.00  0.00           H  
ATOM    795 HG22 ILE A  54     -23.926  -5.367  27.385  1.00  0.00           H  
ATOM    796 HG23 ILE A  54     -24.838  -5.177  25.886  1.00  0.00           H  
ATOM    797 HD11 ILE A  54     -24.390  -8.092  29.919  1.00  0.00           H  
ATOM    798 HD12 ILE A  54     -24.989  -9.457  28.976  1.00  0.00           H  
ATOM    799 HD13 ILE A  54     -23.670  -8.467  28.353  1.00  0.00           H  
ATOM    800  N   TRP A  55     -28.453  -7.326  26.674  1.00  0.00           N  
ATOM    801  CA  TRP A  55     -29.729  -6.711  27.023  1.00  0.00           C  
ATOM    802  C   TRP A  55     -29.578  -5.789  28.228  1.00  0.00           C  
ATOM    803  O   TRP A  55     -28.750  -6.032  29.107  1.00  0.00           O  
ATOM    804  CB  TRP A  55     -30.773  -7.789  27.319  1.00  0.00           C  
ATOM    805  CG  TRP A  55     -30.983  -8.741  26.181  1.00  0.00           C  
ATOM    806  CD1 TRP A  55     -30.221  -9.833  25.874  1.00  0.00           C  
ATOM    807  CD2 TRP A  55     -32.022  -8.684  25.196  1.00  0.00           C  
ATOM    808  NE1 TRP A  55     -30.724 -10.458  24.759  1.00  0.00           N  
ATOM    809  CE2 TRP A  55     -31.829  -9.775  24.325  1.00  0.00           C  
ATOM    810  CE3 TRP A  55     -33.097  -7.821  24.968  1.00  0.00           C  
ATOM    811  CZ2 TRP A  55     -32.671 -10.020  23.244  1.00  0.00           C  
ATOM    812  CZ3 TRP A  55     -33.931  -8.067  23.894  1.00  0.00           C  
ATOM    813  CH2 TRP A  55     -33.716  -9.159  23.044  1.00  0.00           C  
ATOM    814  H   TRP A  55     -28.315  -8.278  26.859  1.00  0.00           H  
ATOM    815  HA  TRP A  55     -30.057  -6.128  26.176  1.00  0.00           H  
ATOM    816  HB2 TRP A  55     -30.458  -8.362  28.178  1.00  0.00           H  
ATOM    817  HB3 TRP A  55     -31.719  -7.313  27.536  1.00  0.00           H  
ATOM    818  HD1 TRP A  55     -29.354 -10.145  26.434  1.00  0.00           H  
ATOM    819  HE1 TRP A  55     -30.353 -11.265  24.343  1.00  0.00           H  
ATOM    820  HE3 TRP A  55     -33.280  -6.974  25.613  1.00  0.00           H  
ATOM    821  HZ2 TRP A  55     -32.519 -10.857  22.579  1.00  0.00           H  
ATOM    822  HZ3 TRP A  55     -34.767  -7.410  23.702  1.00  0.00           H  
ATOM    823  HH2 TRP A  55     -34.392  -9.312  22.217  1.00  0.00           H  
ATOM    824  N   SER A  56     -30.380  -4.730  28.262  1.00  0.00           N  
ATOM    825  CA  SER A  56     -30.332  -3.770  29.358  1.00  0.00           C  
ATOM    826  C   SER A  56     -30.461  -4.475  30.704  1.00  0.00           C  
ATOM    827  O   SER A  56     -29.938  -4.006  31.716  1.00  0.00           O  
ATOM    828  CB  SER A  56     -31.445  -2.731  29.203  1.00  0.00           C  
ATOM    829  OG  SER A  56     -31.932  -2.315  30.467  1.00  0.00           O  
ATOM    830  H   SER A  56     -31.018  -4.591  27.531  1.00  0.00           H  
ATOM    831  HA  SER A  56     -29.376  -3.268  29.318  1.00  0.00           H  
ATOM    832  HB2 SER A  56     -31.062  -1.872  28.677  1.00  0.00           H  
ATOM    833  HB3 SER A  56     -32.261  -3.164  28.641  1.00  0.00           H  
ATOM    834  HG  SER A  56     -32.806  -1.929  30.363  1.00  0.00           H  
ATOM    835  N   ARG A  57     -31.162  -5.604  30.710  1.00  0.00           N  
ATOM    836  CA  ARG A  57     -31.362  -6.374  31.932  1.00  0.00           C  
ATOM    837  C   ARG A  57     -30.085  -7.113  32.323  1.00  0.00           C  
ATOM    838  O   ARG A  57     -29.730  -7.179  33.500  1.00  0.00           O  
ATOM    839  CB  ARG A  57     -32.506  -7.372  31.749  1.00  0.00           C  
ATOM    840  CG  ARG A  57     -32.889  -8.099  33.027  1.00  0.00           C  
ATOM    841  CD  ARG A  57     -34.398  -8.239  33.159  1.00  0.00           C  
ATOM    842  NE  ARG A  57     -34.805  -8.511  34.534  1.00  0.00           N  
ATOM    843  CZ  ARG A  57     -34.609  -9.677  35.141  1.00  0.00           C  
ATOM    844  NH1 ARG A  57     -34.014 -10.671  34.498  1.00  0.00           N  
ATOM    845  NH2 ARG A  57     -35.007  -9.848  36.395  1.00  0.00           N  
ATOM    846  H   ARG A  57     -31.554  -5.926  29.872  1.00  0.00           H  
ATOM    847  HA  ARG A  57     -31.619  -5.683  32.720  1.00  0.00           H  
ATOM    848  HB2 ARG A  57     -33.376  -6.842  31.389  1.00  0.00           H  
ATOM    849  HB3 ARG A  57     -32.213  -8.107  31.016  1.00  0.00           H  
ATOM    850  HG2 ARG A  57     -32.448  -9.085  33.015  1.00  0.00           H  
ATOM    851  HG3 ARG A  57     -32.512  -7.544  33.873  1.00  0.00           H  
ATOM    852  HD2 ARG A  57     -34.861  -7.319  32.832  1.00  0.00           H  
ATOM    853  HD3 ARG A  57     -34.727  -9.051  32.528  1.00  0.00           H  
ATOM    854  HE  ARG A  57     -35.246  -7.789  35.028  1.00  0.00           H  
ATOM    855 HH11 ARG A  57     -33.712 -10.545  33.553  1.00  0.00           H  
ATOM    856 HH12 ARG A  57     -33.866 -11.547  34.957  1.00  0.00           H  
ATOM    857 HH21 ARG A  57     -35.455  -9.100  36.884  1.00  0.00           H  
ATOM    858 HH22 ARG A  57     -34.859 -10.725  36.851  1.00  0.00           H  
ATOM    859  N   ASP A  58     -29.401  -7.669  31.328  1.00  0.00           N  
ATOM    860  CA  ASP A  58     -28.164  -8.403  31.568  1.00  0.00           C  
ATOM    861  C   ASP A  58     -27.052  -7.462  32.017  1.00  0.00           C  
ATOM    862  O   ASP A  58     -26.451  -7.654  33.075  1.00  0.00           O  
ATOM    863  CB  ASP A  58     -27.737  -9.151  30.304  1.00  0.00           C  
ATOM    864  CG  ASP A  58     -28.384 -10.517  30.193  1.00  0.00           C  
ATOM    865  OD1 ASP A  58     -29.198 -10.861  31.075  1.00  0.00           O  
ATOM    866  OD2 ASP A  58     -28.075 -11.243  29.225  1.00  0.00           O  
ATOM    867  H   ASP A  58     -29.735  -7.581  30.411  1.00  0.00           H  
ATOM    868  HA  ASP A  58     -28.351  -9.120  32.353  1.00  0.00           H  
ATOM    869  HB2 ASP A  58     -28.018  -8.569  29.437  1.00  0.00           H  
ATOM    870  HB3 ASP A  58     -26.665  -9.279  30.314  1.00  0.00           H  
ATOM    871  N   VAL A  59     -26.781  -6.443  31.208  1.00  0.00           N  
ATOM    872  CA  VAL A  59     -25.741  -5.471  31.522  1.00  0.00           C  
ATOM    873  C   VAL A  59     -25.978  -4.835  32.887  1.00  0.00           C  
ATOM    874  O   VAL A  59     -25.042  -4.368  33.536  1.00  0.00           O  
ATOM    875  CB  VAL A  59     -25.669  -4.362  30.455  1.00  0.00           C  
ATOM    876  CG1 VAL A  59     -27.011  -3.657  30.325  1.00  0.00           C  
ATOM    877  CG2 VAL A  59     -24.567  -3.369  30.795  1.00  0.00           C  
ATOM    878  H   VAL A  59     -27.295  -6.342  30.379  1.00  0.00           H  
ATOM    879  HA  VAL A  59     -24.794  -5.989  31.536  1.00  0.00           H  
ATOM    880  HB  VAL A  59     -25.433  -4.819  29.506  1.00  0.00           H  
ATOM    881 HG11 VAL A  59     -27.295  -3.617  29.285  1.00  0.00           H  
ATOM    882 HG12 VAL A  59     -27.759  -4.201  30.885  1.00  0.00           H  
ATOM    883 HG13 VAL A  59     -26.928  -2.653  30.716  1.00  0.00           H  
ATOM    884 HG21 VAL A  59     -24.464  -2.656  29.991  1.00  0.00           H  
ATOM    885 HG22 VAL A  59     -24.819  -2.850  31.707  1.00  0.00           H  
ATOM    886 HG23 VAL A  59     -23.633  -3.898  30.927  1.00  0.00           H  
ATOM    887  N   ARG A  60     -27.235  -4.820  33.316  1.00  0.00           N  
ATOM    888  CA  ARG A  60     -27.596  -4.239  34.604  1.00  0.00           C  
ATOM    889  C   ARG A  60     -27.185  -5.159  35.749  1.00  0.00           C  
ATOM    890  O   ARG A  60     -26.675  -4.703  36.773  1.00  0.00           O  
ATOM    891  CB  ARG A  60     -29.102  -3.973  34.665  1.00  0.00           C  
ATOM    892  CG  ARG A  60     -29.552  -3.312  35.957  1.00  0.00           C  
ATOM    893  CD  ARG A  60     -30.855  -3.911  36.463  1.00  0.00           C  
ATOM    894  NE  ARG A  60     -30.626  -5.003  37.406  1.00  0.00           N  
ATOM    895  CZ  ARG A  60     -31.595  -5.593  38.097  1.00  0.00           C  
ATOM    896  NH1 ARG A  60     -32.852  -5.199  37.951  1.00  0.00           N  
ATOM    897  NH2 ARG A  60     -31.307  -6.581  38.936  1.00  0.00           N  
ATOM    898  H   ARG A  60     -27.938  -5.207  32.753  1.00  0.00           H  
ATOM    899  HA  ARG A  60     -27.069  -3.301  34.705  1.00  0.00           H  
ATOM    900  HB2 ARG A  60     -29.375  -3.328  33.843  1.00  0.00           H  
ATOM    901  HB3 ARG A  60     -29.625  -4.912  34.564  1.00  0.00           H  
ATOM    902  HG2 ARG A  60     -28.788  -3.454  36.707  1.00  0.00           H  
ATOM    903  HG3 ARG A  60     -29.695  -2.257  35.781  1.00  0.00           H  
ATOM    904  HD2 ARG A  60     -31.423  -3.137  36.957  1.00  0.00           H  
ATOM    905  HD3 ARG A  60     -31.414  -4.287  35.620  1.00  0.00           H  
ATOM    906  HE  ARG A  60     -29.703  -5.311  37.529  1.00  0.00           H  
ATOM    907 HH11 ARG A  60     -33.072  -4.455  37.320  1.00  0.00           H  
ATOM    908 HH12 ARG A  60     -33.580  -5.645  38.473  1.00  0.00           H  
ATOM    909 HH21 ARG A  60     -30.360  -6.881  39.047  1.00  0.00           H  
ATOM    910 HH22 ARG A  60     -32.037  -7.024  39.456  1.00  0.00           H  
ATOM    911  N   TYR A  61     -27.410  -6.456  35.569  1.00  0.00           N  
ATOM    912  CA  TYR A  61     -27.066  -7.440  36.588  1.00  0.00           C  
ATOM    913  C   TYR A  61     -25.559  -7.478  36.823  1.00  0.00           C  
ATOM    914  O   TYR A  61     -25.094  -7.412  37.960  1.00  0.00           O  
ATOM    915  CB  TYR A  61     -27.564  -8.827  36.176  1.00  0.00           C  
ATOM    916  CG  TYR A  61     -28.271  -9.571  37.286  1.00  0.00           C  
ATOM    917  CD1 TYR A  61     -29.403  -9.040  37.894  1.00  0.00           C  
ATOM    918  CD2 TYR A  61     -27.809 -10.806  37.726  1.00  0.00           C  
ATOM    919  CE1 TYR A  61     -30.051  -9.716  38.909  1.00  0.00           C  
ATOM    920  CE2 TYR A  61     -28.453 -11.489  38.739  1.00  0.00           C  
ATOM    921  CZ  TYR A  61     -29.573 -10.940  39.328  1.00  0.00           C  
ATOM    922  OH  TYR A  61     -30.217 -11.618  40.338  1.00  0.00           O  
ATOM    923  H   TYR A  61     -27.819  -6.759  34.731  1.00  0.00           H  
ATOM    924  HA  TYR A  61     -27.555  -7.152  37.507  1.00  0.00           H  
ATOM    925  HB2 TYR A  61     -28.255  -8.724  35.354  1.00  0.00           H  
ATOM    926  HB3 TYR A  61     -26.722  -9.425  35.860  1.00  0.00           H  
ATOM    927  HD1 TYR A  61     -29.775  -8.082  37.562  1.00  0.00           H  
ATOM    928  HD2 TYR A  61     -26.932 -11.233  37.263  1.00  0.00           H  
ATOM    929  HE1 TYR A  61     -30.929  -9.287  39.370  1.00  0.00           H  
ATOM    930  HE2 TYR A  61     -28.079 -12.447  39.068  1.00  0.00           H  
ATOM    931  HH  TYR A  61     -29.569 -12.052  40.896  1.00  0.00           H  
ATOM    932  N   LYS A  62     -24.800  -7.583  35.737  1.00  0.00           N  
ATOM    933  CA  LYS A  62     -23.346  -7.627  35.822  1.00  0.00           C  
ATOM    934  C   LYS A  62     -22.790  -6.304  36.339  1.00  0.00           C  
ATOM    935  O   LYS A  62     -21.753  -6.272  37.001  1.00  0.00           O  
ATOM    936  CB  LYS A  62     -22.744  -7.944  34.451  1.00  0.00           C  
ATOM    937  CG  LYS A  62     -23.090  -9.332  33.941  1.00  0.00           C  
ATOM    938  CD  LYS A  62     -22.107  -9.796  32.878  1.00  0.00           C  
ATOM    939  CE  LYS A  62     -21.256 -10.955  33.374  1.00  0.00           C  
ATOM    940  NZ  LYS A  62     -20.452 -11.562  32.277  1.00  0.00           N  
ATOM    941  H   LYS A  62     -25.230  -7.631  34.858  1.00  0.00           H  
ATOM    942  HA  LYS A  62     -23.077  -8.412  36.513  1.00  0.00           H  
ATOM    943  HB2 LYS A  62     -23.107  -7.219  33.736  1.00  0.00           H  
ATOM    944  HB3 LYS A  62     -21.668  -7.865  34.516  1.00  0.00           H  
ATOM    945  HG2 LYS A  62     -23.064 -10.026  34.767  1.00  0.00           H  
ATOM    946  HG3 LYS A  62     -24.083  -9.312  33.515  1.00  0.00           H  
ATOM    947  HD2 LYS A  62     -22.658 -10.116  32.006  1.00  0.00           H  
ATOM    948  HD3 LYS A  62     -21.460  -8.971  32.614  1.00  0.00           H  
ATOM    949  HE2 LYS A  62     -20.588 -10.592  34.140  1.00  0.00           H  
ATOM    950  HE3 LYS A  62     -21.906 -11.709  33.792  1.00  0.00           H  
ATOM    951  HZ1 LYS A  62     -21.074 -12.073  31.619  1.00  0.00           H  
ATOM    952  HZ2 LYS A  62     -19.758 -12.228  32.671  1.00  0.00           H  
ATOM    953  HZ3 LYS A  62     -19.945 -10.820  31.754  1.00  0.00           H  
ATOM    954  N   SER A  63     -23.488  -5.215  36.034  1.00  0.00           N  
ATOM    955  CA  SER A  63     -23.063  -3.889  36.467  1.00  0.00           C  
ATOM    956  C   SER A  63     -23.442  -3.646  37.925  1.00  0.00           C  
ATOM    957  O   SER A  63     -22.812  -2.845  38.615  1.00  0.00           O  
ATOM    958  CB  SER A  63     -23.692  -2.813  35.579  1.00  0.00           C  
ATOM    959  OG  SER A  63     -23.094  -2.800  34.294  1.00  0.00           O  
ATOM    960  H   SER A  63     -24.307  -5.305  35.503  1.00  0.00           H  
ATOM    961  HA  SER A  63     -21.988  -3.838  36.373  1.00  0.00           H  
ATOM    962  HB2 SER A  63     -24.747  -3.012  35.469  1.00  0.00           H  
ATOM    963  HB3 SER A  63     -23.554  -1.846  36.038  1.00  0.00           H  
ATOM    964  HG  SER A  63     -23.355  -2.002  33.827  1.00  0.00           H  
ATOM    965  N   ASN A  64     -24.476  -4.342  38.385  1.00  0.00           N  
ATOM    966  CA  ASN A  64     -24.940  -4.202  39.761  1.00  0.00           C  
ATOM    967  C   ASN A  64     -25.442  -2.786  40.023  1.00  0.00           C  
ATOM    968  O   ASN A  64     -25.303  -2.262  41.129  1.00  0.00           O  
ATOM    969  CB  ASN A  64     -23.814  -4.547  40.738  1.00  0.00           C  
ATOM    970  CG  ASN A  64     -24.336  -5.123  42.040  1.00  0.00           C  
ATOM    971  OD1 ASN A  64     -25.479  -4.877  42.428  1.00  0.00           O  
ATOM    972  ND2 ASN A  64     -23.499  -5.896  42.722  1.00  0.00           N  
ATOM    973  H   ASN A  64     -24.937  -4.965  37.786  1.00  0.00           H  
ATOM    974  HA  ASN A  64     -25.756  -4.894  39.907  1.00  0.00           H  
ATOM    975  HB2 ASN A  64     -23.160  -5.274  40.281  1.00  0.00           H  
ATOM    976  HB3 ASN A  64     -23.253  -3.653  40.961  1.00  0.00           H  
ATOM    977 HD21 ASN A  64     -22.605  -6.050  42.351  1.00  0.00           H  
ATOM    978 HD22 ASN A  64     -23.811  -6.283  43.567  1.00  0.00           H  
ATOM    979  N   LEU A  65     -26.027  -2.172  39.001  1.00  0.00           N  
ATOM    980  CA  LEU A  65     -26.551  -0.816  39.121  1.00  0.00           C  
ATOM    981  C   LEU A  65     -28.058  -0.791  38.884  1.00  0.00           C  
ATOM    982  O   LEU A  65     -28.591  -1.525  38.052  1.00  0.00           O  
ATOM    983  CB  LEU A  65     -25.851   0.112  38.127  1.00  0.00           C  
ATOM    984  CG  LEU A  65     -24.342  -0.075  37.980  1.00  0.00           C  
ATOM    985  CD1 LEU A  65     -23.823   0.685  36.770  1.00  0.00           C  
ATOM    986  CD2 LEU A  65     -23.623   0.375  39.243  1.00  0.00           C  
ATOM    987  H   LEU A  65     -26.109  -2.640  38.144  1.00  0.00           H  
ATOM    988  HA  LEU A  65     -26.351  -0.471  40.125  1.00  0.00           H  
ATOM    989  HB2 LEU A  65     -26.299  -0.045  37.157  1.00  0.00           H  
ATOM    990  HB3 LEU A  65     -26.030   1.130  38.443  1.00  0.00           H  
ATOM    991  HG  LEU A  65     -24.129  -1.125  37.831  1.00  0.00           H  
ATOM    992 HD11 LEU A  65     -23.031   0.120  36.302  1.00  0.00           H  
ATOM    993 HD12 LEU A  65     -23.443   1.646  37.085  1.00  0.00           H  
ATOM    994 HD13 LEU A  65     -24.628   0.831  36.065  1.00  0.00           H  
ATOM    995 HD21 LEU A  65     -24.168   1.191  39.696  1.00  0.00           H  
ATOM    996 HD22 LEU A  65     -22.625   0.703  38.993  1.00  0.00           H  
ATOM    997 HD23 LEU A  65     -23.566  -0.449  39.940  1.00  0.00           H  
ATOM    998  N   PRO A  66     -28.760   0.073  39.631  1.00  0.00           N  
ATOM    999  CA  PRO A  66     -30.215   0.215  39.519  1.00  0.00           C  
ATOM   1000  C   PRO A  66     -30.634   0.862  38.203  1.00  0.00           C  
ATOM   1001  O   PRO A  66     -29.837   1.537  37.549  1.00  0.00           O  
ATOM   1002  CB  PRO A  66     -30.574   1.122  40.698  1.00  0.00           C  
ATOM   1003  CG  PRO A  66     -29.332   1.897  40.973  1.00  0.00           C  
ATOM   1004  CD  PRO A  66     -28.189   0.977  40.644  1.00  0.00           C  
ATOM   1005  HA  PRO A  66     -30.716  -0.735  39.627  1.00  0.00           H  
ATOM   1006  HB2 PRO A  66     -31.392   1.772  40.420  1.00  0.00           H  
ATOM   1007  HB3 PRO A  66     -30.860   0.520  41.547  1.00  0.00           H  
ATOM   1008  HG2 PRO A  66     -29.299   2.775  40.345  1.00  0.00           H  
ATOM   1009  HG3 PRO A  66     -29.298   2.178  42.015  1.00  0.00           H  
ATOM   1010  HD2 PRO A  66     -27.359   1.536  40.237  1.00  0.00           H  
ATOM   1011  HD3 PRO A  66     -27.882   0.428  41.521  1.00  0.00           H  
ATOM   1012  N   LEU A  67     -31.888   0.652  37.818  1.00  0.00           N  
ATOM   1013  CA  LEU A  67     -32.414   1.215  36.580  1.00  0.00           C  
ATOM   1014  C   LEU A  67     -32.154   2.716  36.511  1.00  0.00           C  
ATOM   1015  O   LEU A  67     -31.828   3.254  35.452  1.00  0.00           O  
ATOM   1016  CB  LEU A  67     -33.913   0.938  36.466  1.00  0.00           C  
ATOM   1017  CG  LEU A  67     -34.752   1.272  37.700  1.00  0.00           C  
ATOM   1018  CD1 LEU A  67     -35.705   2.420  37.405  1.00  0.00           C  
ATOM   1019  CD2 LEU A  67     -35.522   0.046  38.169  1.00  0.00           C  
ATOM   1020  H   LEU A  67     -32.475   0.106  38.380  1.00  0.00           H  
ATOM   1021  HA  LEU A  67     -31.905   0.736  35.756  1.00  0.00           H  
ATOM   1022  HB2 LEU A  67     -34.295   1.519  35.641  1.00  0.00           H  
ATOM   1023  HB3 LEU A  67     -34.040  -0.113  36.254  1.00  0.00           H  
ATOM   1024  HG  LEU A  67     -34.095   1.582  38.502  1.00  0.00           H  
ATOM   1025 HD11 LEU A  67     -36.555   2.049  36.854  1.00  0.00           H  
ATOM   1026 HD12 LEU A  67     -35.194   3.169  36.817  1.00  0.00           H  
ATOM   1027 HD13 LEU A  67     -36.039   2.859  38.334  1.00  0.00           H  
ATOM   1028 HD21 LEU A  67     -34.967  -0.450  38.952  1.00  0.00           H  
ATOM   1029 HD22 LEU A  67     -35.658  -0.632  37.340  1.00  0.00           H  
ATOM   1030 HD23 LEU A  67     -36.487   0.349  38.548  1.00  0.00           H  
ATOM   1031  N   THR A  68     -32.300   3.389  37.648  1.00  0.00           N  
ATOM   1032  CA  THR A  68     -32.082   4.828  37.718  1.00  0.00           C  
ATOM   1033  C   THR A  68     -30.684   5.197  37.234  1.00  0.00           C  
ATOM   1034  O   THR A  68     -30.469   6.284  36.699  1.00  0.00           O  
ATOM   1035  CB  THR A  68     -32.271   5.356  39.153  1.00  0.00           C  
ATOM   1036  OG1 THR A  68     -32.174   6.785  39.166  1.00  0.00           O  
ATOM   1037  CG2 THR A  68     -31.229   4.764  40.089  1.00  0.00           C  
ATOM   1038  H   THR A  68     -32.562   2.905  38.459  1.00  0.00           H  
ATOM   1039  HA  THR A  68     -32.811   5.308  37.082  1.00  0.00           H  
ATOM   1040  HB  THR A  68     -33.252   5.066  39.500  1.00  0.00           H  
ATOM   1041  HG1 THR A  68     -32.036   7.088  40.066  1.00  0.00           H  
ATOM   1042 HG21 THR A  68     -31.675   4.581  41.055  1.00  0.00           H  
ATOM   1043 HG22 THR A  68     -30.408   5.456  40.199  1.00  0.00           H  
ATOM   1044 HG23 THR A  68     -30.864   3.834  39.679  1.00  0.00           H  
ATOM   1045  N   GLU A  69     -29.737   4.283  37.424  1.00  0.00           N  
ATOM   1046  CA  GLU A  69     -28.359   4.513  37.006  1.00  0.00           C  
ATOM   1047  C   GLU A  69     -28.153   4.089  35.555  1.00  0.00           C  
ATOM   1048  O   GLU A  69     -27.762   4.896  34.711  1.00  0.00           O  
ATOM   1049  CB  GLU A  69     -27.392   3.751  37.914  1.00  0.00           C  
ATOM   1050  CG  GLU A  69     -27.307   4.316  39.323  1.00  0.00           C  
ATOM   1051  CD  GLU A  69     -26.445   5.562  39.399  1.00  0.00           C  
ATOM   1052  OE1 GLU A  69     -26.670   6.490  38.596  1.00  0.00           O  
ATOM   1053  OE2 GLU A  69     -25.546   5.607  40.265  1.00  0.00           O  
ATOM   1054  H   GLU A  69     -29.970   3.435  37.856  1.00  0.00           H  
ATOM   1055  HA  GLU A  69     -28.159   5.570  37.091  1.00  0.00           H  
ATOM   1056  HB2 GLU A  69     -27.715   2.722  37.980  1.00  0.00           H  
ATOM   1057  HB3 GLU A  69     -26.406   3.782  37.476  1.00  0.00           H  
ATOM   1058  HG2 GLU A  69     -28.302   4.564  39.659  1.00  0.00           H  
ATOM   1059  HG3 GLU A  69     -26.885   3.564  39.974  1.00  0.00           H  
ATOM   1060  N   ILE A  70     -28.418   2.817  35.274  1.00  0.00           N  
ATOM   1061  CA  ILE A  70     -28.262   2.284  33.926  1.00  0.00           C  
ATOM   1062  C   ILE A  70     -29.000   3.145  32.906  1.00  0.00           C  
ATOM   1063  O   ILE A  70     -28.539   3.325  31.780  1.00  0.00           O  
ATOM   1064  CB  ILE A  70     -28.777   0.837  33.829  1.00  0.00           C  
ATOM   1065  CG1 ILE A  70     -28.030  -0.061  34.818  1.00  0.00           C  
ATOM   1066  CG2 ILE A  70     -28.622   0.313  32.409  1.00  0.00           C  
ATOM   1067  CD1 ILE A  70     -26.548  -0.165  34.538  1.00  0.00           C  
ATOM   1068  H   ILE A  70     -28.725   2.223  35.990  1.00  0.00           H  
ATOM   1069  HA  ILE A  70     -27.208   2.287  33.687  1.00  0.00           H  
ATOM   1070  HB  ILE A  70     -29.828   0.836  34.075  1.00  0.00           H  
ATOM   1071 HG12 ILE A  70     -28.152   0.333  35.815  1.00  0.00           H  
ATOM   1072 HG13 ILE A  70     -28.447  -1.057  34.774  1.00  0.00           H  
ATOM   1073 HG21 ILE A  70     -29.343   0.797  31.766  1.00  0.00           H  
ATOM   1074 HG22 ILE A  70     -27.625   0.525  32.054  1.00  0.00           H  
ATOM   1075 HG23 ILE A  70     -28.789  -0.754  32.398  1.00  0.00           H  
ATOM   1076 HD11 ILE A  70     -26.083  -0.796  35.284  1.00  0.00           H  
ATOM   1077 HD12 ILE A  70     -26.395  -0.595  33.560  1.00  0.00           H  
ATOM   1078 HD13 ILE A  70     -26.104   0.818  34.573  1.00  0.00           H  
ATOM   1079  N   ASN A  71     -30.151   3.675  33.310  1.00  0.00           N  
ATOM   1080  CA  ASN A  71     -30.954   4.517  32.432  1.00  0.00           C  
ATOM   1081  C   ASN A  71     -30.157   5.732  31.964  1.00  0.00           C  
ATOM   1082  O   ASN A  71     -30.320   6.200  30.837  1.00  0.00           O  
ATOM   1083  CB  ASN A  71     -32.224   4.974  33.152  1.00  0.00           C  
ATOM   1084  CG  ASN A  71     -33.314   3.920  33.126  1.00  0.00           C  
ATOM   1085  OD1 ASN A  71     -33.161   2.868  32.504  1.00  0.00           O  
ATOM   1086  ND2 ASN A  71     -34.423   4.198  33.801  1.00  0.00           N  
ATOM   1087  H   ASN A  71     -30.467   3.495  34.220  1.00  0.00           H  
ATOM   1088  HA  ASN A  71     -31.231   3.929  31.571  1.00  0.00           H  
ATOM   1089  HB2 ASN A  71     -31.989   5.194  34.182  1.00  0.00           H  
ATOM   1090  HB3 ASN A  71     -32.601   5.867  32.675  1.00  0.00           H  
ATOM   1091 HD21 ASN A  71     -34.475   5.056  34.273  1.00  0.00           H  
ATOM   1092 HD22 ASN A  71     -35.143   3.534  33.802  1.00  0.00           H  
ATOM   1093  N   LYS A  72     -29.292   6.238  32.838  1.00  0.00           N  
ATOM   1094  CA  LYS A  72     -28.468   7.395  32.517  1.00  0.00           C  
ATOM   1095  C   LYS A  72     -27.200   6.973  31.780  1.00  0.00           C  
ATOM   1096  O   LYS A  72     -26.751   7.653  30.858  1.00  0.00           O  
ATOM   1097  CB  LYS A  72     -28.100   8.156  33.793  1.00  0.00           C  
ATOM   1098  CG  LYS A  72     -27.128   9.300  33.560  1.00  0.00           C  
ATOM   1099  CD  LYS A  72     -26.766   9.996  34.861  1.00  0.00           C  
ATOM   1100  CE  LYS A  72     -25.567   9.340  35.529  1.00  0.00           C  
ATOM   1101  NZ  LYS A  72     -24.342  10.180  35.422  1.00  0.00           N  
ATOM   1102  H   LYS A  72     -29.208   5.821  33.722  1.00  0.00           H  
ATOM   1103  HA  LYS A  72     -29.043   8.045  31.874  1.00  0.00           H  
ATOM   1104  HB2 LYS A  72     -29.002   8.560  34.229  1.00  0.00           H  
ATOM   1105  HB3 LYS A  72     -27.650   7.466  34.492  1.00  0.00           H  
ATOM   1106  HG2 LYS A  72     -26.228   8.910  33.110  1.00  0.00           H  
ATOM   1107  HG3 LYS A  72     -27.585  10.018  32.893  1.00  0.00           H  
ATOM   1108  HD2 LYS A  72     -26.526  11.028  34.652  1.00  0.00           H  
ATOM   1109  HD3 LYS A  72     -27.612   9.950  35.532  1.00  0.00           H  
ATOM   1110  HE2 LYS A  72     -25.796   9.182  36.572  1.00  0.00           H  
ATOM   1111  HE3 LYS A  72     -25.383   8.388  35.053  1.00  0.00           H  
ATOM   1112  HZ1 LYS A  72     -24.600  11.159  35.183  1.00  0.00           H  
ATOM   1113  HZ2 LYS A  72     -23.717   9.806  34.681  1.00  0.00           H  
ATOM   1114  HZ3 LYS A  72     -23.828  10.179  36.327  1.00  0.00           H  
ATOM   1115  N   ILE A  73     -26.630   5.847  32.194  1.00  0.00           N  
ATOM   1116  CA  ILE A  73     -25.414   5.334  31.573  1.00  0.00           C  
ATOM   1117  C   ILE A  73     -25.664   4.946  30.119  1.00  0.00           C  
ATOM   1118  O   ILE A  73     -25.008   5.453  29.208  1.00  0.00           O  
ATOM   1119  CB  ILE A  73     -24.867   4.111  32.332  1.00  0.00           C  
ATOM   1120  CG1 ILE A  73     -24.595   4.471  33.794  1.00  0.00           C  
ATOM   1121  CG2 ILE A  73     -23.602   3.595  31.663  1.00  0.00           C  
ATOM   1122  CD1 ILE A  73     -24.255   3.276  34.657  1.00  0.00           C  
ATOM   1123  H   ILE A  73     -27.034   5.349  32.935  1.00  0.00           H  
ATOM   1124  HA  ILE A  73     -24.669   6.115  31.602  1.00  0.00           H  
ATOM   1125  HB  ILE A  73     -25.610   3.328  32.293  1.00  0.00           H  
ATOM   1126 HG12 ILE A  73     -23.767   5.160  33.841  1.00  0.00           H  
ATOM   1127 HG13 ILE A  73     -25.473   4.943  34.210  1.00  0.00           H  
ATOM   1128 HG21 ILE A  73     -23.337   4.247  30.843  1.00  0.00           H  
ATOM   1129 HG22 ILE A  73     -22.796   3.579  32.382  1.00  0.00           H  
ATOM   1130 HG23 ILE A  73     -23.772   2.597  31.290  1.00  0.00           H  
ATOM   1131 HD11 ILE A  73     -25.081   3.066  35.321  1.00  0.00           H  
ATOM   1132 HD12 ILE A  73     -24.072   2.418  34.029  1.00  0.00           H  
ATOM   1133 HD13 ILE A  73     -23.372   3.493  35.240  1.00  0.00           H  
ATOM   1134  N   LEU A  74     -26.617   4.044  29.908  1.00  0.00           N  
ATOM   1135  CA  LEU A  74     -26.955   3.588  28.564  1.00  0.00           C  
ATOM   1136  C   LEU A  74     -27.227   4.771  27.640  1.00  0.00           C  
ATOM   1137  O   LEU A  74     -26.931   4.722  26.446  1.00  0.00           O  
ATOM   1138  CB  LEU A  74     -28.177   2.670  28.608  1.00  0.00           C  
ATOM   1139  CG  LEU A  74     -27.935   1.255  29.134  1.00  0.00           C  
ATOM   1140  CD1 LEU A  74     -29.232   0.459  29.144  1.00  0.00           C  
ATOM   1141  CD2 LEU A  74     -26.880   0.548  28.297  1.00  0.00           C  
ATOM   1142  H   LEU A  74     -27.105   3.675  30.674  1.00  0.00           H  
ATOM   1143  HA  LEU A  74     -26.112   3.033  28.180  1.00  0.00           H  
ATOM   1144  HB2 LEU A  74     -28.918   3.136  29.240  1.00  0.00           H  
ATOM   1145  HB3 LEU A  74     -28.566   2.588  27.603  1.00  0.00           H  
ATOM   1146  HG  LEU A  74     -27.574   1.313  30.152  1.00  0.00           H  
ATOM   1147 HD11 LEU A  74     -30.018   1.059  29.577  1.00  0.00           H  
ATOM   1148 HD12 LEU A  74     -29.099  -0.438  29.729  1.00  0.00           H  
ATOM   1149 HD13 LEU A  74     -29.497   0.193  28.131  1.00  0.00           H  
ATOM   1150 HD21 LEU A  74     -26.870  -0.504  28.543  1.00  0.00           H  
ATOM   1151 HD22 LEU A  74     -25.910   0.976  28.506  1.00  0.00           H  
ATOM   1152 HD23 LEU A  74     -27.110   0.671  27.248  1.00  0.00           H  
ATOM   1153  N   LYS A  75     -27.789   5.836  28.202  1.00  0.00           N  
ATOM   1154  CA  LYS A  75     -28.098   7.035  27.430  1.00  0.00           C  
ATOM   1155  C   LYS A  75     -26.855   7.900  27.250  1.00  0.00           C  
ATOM   1156  O   LYS A  75     -26.713   8.598  26.246  1.00  0.00           O  
ATOM   1157  CB  LYS A  75     -29.199   7.842  28.122  1.00  0.00           C  
ATOM   1158  CG  LYS A  75     -30.473   7.960  27.302  1.00  0.00           C  
ATOM   1159  CD  LYS A  75     -31.696   7.564  28.112  1.00  0.00           C  
ATOM   1160  CE  LYS A  75     -32.950   8.258  27.604  1.00  0.00           C  
ATOM   1161  NZ  LYS A  75     -33.251   7.895  26.191  1.00  0.00           N  
ATOM   1162  H   LYS A  75     -28.002   5.816  29.158  1.00  0.00           H  
ATOM   1163  HA  LYS A  75     -28.448   6.723  26.458  1.00  0.00           H  
ATOM   1164  HB2 LYS A  75     -29.442   7.366  29.060  1.00  0.00           H  
ATOM   1165  HB3 LYS A  75     -28.829   8.837  28.319  1.00  0.00           H  
ATOM   1166  HG2 LYS A  75     -30.586   8.982  26.975  1.00  0.00           H  
ATOM   1167  HG3 LYS A  75     -30.397   7.311  26.440  1.00  0.00           H  
ATOM   1168  HD2 LYS A  75     -31.835   6.495  28.040  1.00  0.00           H  
ATOM   1169  HD3 LYS A  75     -31.536   7.839  29.146  1.00  0.00           H  
ATOM   1170  HE2 LYS A  75     -33.783   7.969  28.226  1.00  0.00           H  
ATOM   1171  HE3 LYS A  75     -32.806   9.327  27.668  1.00  0.00           H  
ATOM   1172  HZ1 LYS A  75     -32.916   8.643  25.550  1.00  0.00           H  
ATOM   1173  HZ2 LYS A  75     -34.275   7.777  26.063  1.00  0.00           H  
ATOM   1174  HZ3 LYS A  75     -32.776   7.003  25.942  1.00  0.00           H  
ATOM   1175  N   ASN A  76     -25.957   7.849  28.228  1.00  0.00           N  
ATOM   1176  CA  ASN A  76     -24.726   8.630  28.177  1.00  0.00           C  
ATOM   1177  C   ASN A  76     -23.857   8.198  26.998  1.00  0.00           C  
ATOM   1178  O   ASN A  76     -23.568   8.993  26.103  1.00  0.00           O  
ATOM   1179  CB  ASN A  76     -23.945   8.476  29.483  1.00  0.00           C  
ATOM   1180  CG  ASN A  76     -23.517   9.810  30.062  1.00  0.00           C  
ATOM   1181  OD1 ASN A  76     -22.679  10.508  29.490  1.00  0.00           O  
ATOM   1182  ND2 ASN A  76     -24.092  10.173  31.203  1.00  0.00           N  
ATOM   1183  H   ASN A  76     -26.126   7.275  29.003  1.00  0.00           H  
ATOM   1184  HA  ASN A  76     -24.996   9.667  28.049  1.00  0.00           H  
ATOM   1185  HB2 ASN A  76     -24.567   7.973  30.210  1.00  0.00           H  
ATOM   1186  HB3 ASN A  76     -23.061   7.883  29.300  1.00  0.00           H  
ATOM   1187 HD21 ASN A  76     -24.750   9.566  31.602  1.00  0.00           H  
ATOM   1188 HD22 ASN A  76     -23.834  11.031  31.599  1.00  0.00           H  
ATOM   1189  N   LEU A  77     -23.446   6.935  27.005  1.00  0.00           N  
ATOM   1190  CA  LEU A  77     -22.612   6.397  25.937  1.00  0.00           C  
ATOM   1191  C   LEU A  77     -23.230   6.675  24.571  1.00  0.00           C  
ATOM   1192  O   LEU A  77     -22.521   6.954  23.604  1.00  0.00           O  
ATOM   1193  CB  LEU A  77     -22.417   4.891  26.125  1.00  0.00           C  
ATOM   1194  CG  LEU A  77     -21.315   4.473  27.099  1.00  0.00           C  
ATOM   1195  CD1 LEU A  77     -21.513   3.033  27.544  1.00  0.00           C  
ATOM   1196  CD2 LEU A  77     -19.944   4.652  26.462  1.00  0.00           C  
ATOM   1197  H   LEU A  77     -23.709   6.350  27.745  1.00  0.00           H  
ATOM   1198  HA  LEU A  77     -21.650   6.885  25.989  1.00  0.00           H  
ATOM   1199  HB2 LEU A  77     -23.347   4.480  26.482  1.00  0.00           H  
ATOM   1200  HB3 LEU A  77     -22.185   4.466  25.159  1.00  0.00           H  
ATOM   1201  HG  LEU A  77     -21.361   5.103  27.977  1.00  0.00           H  
ATOM   1202 HD11 LEU A  77     -22.569   2.832  27.654  1.00  0.00           H  
ATOM   1203 HD12 LEU A  77     -21.018   2.877  28.490  1.00  0.00           H  
ATOM   1204 HD13 LEU A  77     -21.095   2.366  26.804  1.00  0.00           H  
ATOM   1205 HD21 LEU A  77     -19.961   4.263  25.455  1.00  0.00           H  
ATOM   1206 HD22 LEU A  77     -19.206   4.119  27.042  1.00  0.00           H  
ATOM   1207 HD23 LEU A  77     -19.692   5.703  26.439  1.00  0.00           H  
ATOM   1208  N   GLU A  78     -24.555   6.597  24.499  1.00  0.00           N  
ATOM   1209  CA  GLU A  78     -25.268   6.841  23.251  1.00  0.00           C  
ATOM   1210  C   GLU A  78     -24.946   8.229  22.704  1.00  0.00           C  
ATOM   1211  O   GLU A  78     -24.488   8.371  21.570  1.00  0.00           O  
ATOM   1212  CB  GLU A  78     -26.777   6.701  23.463  1.00  0.00           C  
ATOM   1213  CG  GLU A  78     -27.507   6.107  22.271  1.00  0.00           C  
ATOM   1214  CD  GLU A  78     -28.038   7.167  21.326  1.00  0.00           C  
ATOM   1215  OE1 GLU A  78     -28.681   8.123  21.807  1.00  0.00           O  
ATOM   1216  OE2 GLU A  78     -27.813   7.040  20.104  1.00  0.00           O  
ATOM   1217  H   GLU A  78     -25.065   6.370  25.305  1.00  0.00           H  
ATOM   1218  HA  GLU A  78     -24.945   6.102  22.534  1.00  0.00           H  
ATOM   1219  HB2 GLU A  78     -26.950   6.066  24.319  1.00  0.00           H  
ATOM   1220  HB3 GLU A  78     -27.191   7.679  23.662  1.00  0.00           H  
ATOM   1221  HG2 GLU A  78     -26.824   5.472  21.728  1.00  0.00           H  
ATOM   1222  HG3 GLU A  78     -28.337   5.518  22.631  1.00  0.00           H  
ATOM   1223  N   SER A  79     -25.191   9.251  23.518  1.00  0.00           N  
ATOM   1224  CA  SER A  79     -24.933  10.629  23.115  1.00  0.00           C  
ATOM   1225  C   SER A  79     -23.476  10.810  22.703  1.00  0.00           C  
ATOM   1226  O   SER A  79     -23.169  11.556  21.774  1.00  0.00           O  
ATOM   1227  CB  SER A  79     -25.276  11.589  24.256  1.00  0.00           C  
ATOM   1228  OG  SER A  79     -26.024  12.695  23.783  1.00  0.00           O  
ATOM   1229  H   SER A  79     -25.557   9.074  24.410  1.00  0.00           H  
ATOM   1230  HA  SER A  79     -25.565  10.850  22.267  1.00  0.00           H  
ATOM   1231  HB2 SER A  79     -25.859  11.067  25.000  1.00  0.00           H  
ATOM   1232  HB3 SER A  79     -24.362  11.952  24.704  1.00  0.00           H  
ATOM   1233  HG  SER A  79     -25.682  13.503  24.173  1.00  0.00           H  
ATOM   1234  N   LYS A  80     -22.580  10.120  23.401  1.00  0.00           N  
ATOM   1235  CA  LYS A  80     -21.153  10.202  23.110  1.00  0.00           C  
ATOM   1236  C   LYS A  80     -20.837   9.568  21.759  1.00  0.00           C  
ATOM   1237  O   LYS A  80     -19.743   9.741  21.222  1.00  0.00           O  
ATOM   1238  CB  LYS A  80     -20.347   9.511  24.212  1.00  0.00           C  
ATOM   1239  CG  LYS A  80     -20.777   9.898  25.615  1.00  0.00           C  
ATOM   1240  CD  LYS A  80     -19.587  10.306  26.470  1.00  0.00           C  
ATOM   1241  CE  LYS A  80     -19.646   9.664  27.848  1.00  0.00           C  
ATOM   1242  NZ  LYS A  80     -19.155   8.259  27.826  1.00  0.00           N  
ATOM   1243  H   LYS A  80     -22.886   9.541  24.131  1.00  0.00           H  
ATOM   1244  HA  LYS A  80     -20.881  11.246  23.077  1.00  0.00           H  
ATOM   1245  HB2 LYS A  80     -20.458   8.442  24.106  1.00  0.00           H  
ATOM   1246  HB3 LYS A  80     -19.304   9.769  24.092  1.00  0.00           H  
ATOM   1247  HG2 LYS A  80     -21.464  10.729  25.556  1.00  0.00           H  
ATOM   1248  HG3 LYS A  80     -21.268   9.055  26.078  1.00  0.00           H  
ATOM   1249  HD2 LYS A  80     -18.678   9.993  25.979  1.00  0.00           H  
ATOM   1250  HD3 LYS A  80     -19.588  11.381  26.583  1.00  0.00           H  
ATOM   1251  HE2 LYS A  80     -19.034  10.240  28.525  1.00  0.00           H  
ATOM   1252  HE3 LYS A  80     -20.671   9.673  28.191  1.00  0.00           H  
ATOM   1253  HZ1 LYS A  80     -18.957   7.963  26.849  1.00  0.00           H  
ATOM   1254  HZ2 LYS A  80     -19.871   7.623  28.231  1.00  0.00           H  
ATOM   1255  HZ3 LYS A  80     -18.282   8.177  28.385  1.00  0.00           H  
ATOM   1256  N   LYS A  81     -21.803   8.836  21.214  1.00  0.00           N  
ATOM   1257  CA  LYS A  81     -21.629   8.179  19.924  1.00  0.00           C  
ATOM   1258  C   LYS A  81     -20.523   7.131  19.992  1.00  0.00           C  
ATOM   1259  O   LYS A  81     -19.796   6.916  19.020  1.00  0.00           O  
ATOM   1260  CB  LYS A  81     -21.302   9.211  18.843  1.00  0.00           C  
ATOM   1261  CG  LYS A  81     -21.607   8.733  17.433  1.00  0.00           C  
ATOM   1262  CD  LYS A  81     -21.551   9.875  16.433  1.00  0.00           C  
ATOM   1263  CE  LYS A  81     -22.699  10.851  16.635  1.00  0.00           C  
ATOM   1264  NZ  LYS A  81     -23.521  11.005  15.403  1.00  0.00           N  
ATOM   1265  H   LYS A  81     -22.653   8.736  21.691  1.00  0.00           H  
ATOM   1266  HA  LYS A  81     -22.557   7.689  19.674  1.00  0.00           H  
ATOM   1267  HB2 LYS A  81     -21.878  10.106  19.029  1.00  0.00           H  
ATOM   1268  HB3 LYS A  81     -20.250   9.453  18.898  1.00  0.00           H  
ATOM   1269  HG2 LYS A  81     -20.880   7.985  17.152  1.00  0.00           H  
ATOM   1270  HG3 LYS A  81     -22.596   8.299  17.417  1.00  0.00           H  
ATOM   1271  HD2 LYS A  81     -20.617  10.404  16.555  1.00  0.00           H  
ATOM   1272  HD3 LYS A  81     -21.608   9.468  15.432  1.00  0.00           H  
ATOM   1273  HE2 LYS A  81     -23.327  10.486  17.433  1.00  0.00           H  
ATOM   1274  HE3 LYS A  81     -22.292  11.813  16.909  1.00  0.00           H  
ATOM   1275  HZ1 LYS A  81     -24.527  10.864  15.624  1.00  0.00           H  
ATOM   1276  HZ2 LYS A  81     -23.231  10.305  14.690  1.00  0.00           H  
ATOM   1277  HZ3 LYS A  81     -23.394  11.959  15.006  1.00  0.00           H  
ATOM   1278  N   LEU A  82     -20.400   6.481  21.143  1.00  0.00           N  
ATOM   1279  CA  LEU A  82     -19.382   5.453  21.337  1.00  0.00           C  
ATOM   1280  C   LEU A  82     -19.979   4.058  21.170  1.00  0.00           C  
ATOM   1281  O   LEU A  82     -19.275   3.110  20.822  1.00  0.00           O  
ATOM   1282  CB  LEU A  82     -18.751   5.588  22.725  1.00  0.00           C  
ATOM   1283  CG  LEU A  82     -17.748   6.728  22.897  1.00  0.00           C  
ATOM   1284  CD1 LEU A  82     -17.216   6.761  24.322  1.00  0.00           C  
ATOM   1285  CD2 LEU A  82     -16.605   6.588  21.902  1.00  0.00           C  
ATOM   1286  H   LEU A  82     -21.007   6.695  21.882  1.00  0.00           H  
ATOM   1287  HA  LEU A  82     -18.619   5.597  20.588  1.00  0.00           H  
ATOM   1288  HB2 LEU A  82     -19.548   5.738  23.436  1.00  0.00           H  
ATOM   1289  HB3 LEU A  82     -18.242   4.661  22.946  1.00  0.00           H  
ATOM   1290  HG  LEU A  82     -18.246   7.670  22.706  1.00  0.00           H  
ATOM   1291 HD11 LEU A  82     -16.167   6.510  24.320  1.00  0.00           H  
ATOM   1292 HD12 LEU A  82     -17.757   6.045  24.923  1.00  0.00           H  
ATOM   1293 HD13 LEU A  82     -17.349   7.750  24.734  1.00  0.00           H  
ATOM   1294 HD21 LEU A  82     -16.891   7.034  20.961  1.00  0.00           H  
ATOM   1295 HD22 LEU A  82     -16.385   5.542  21.753  1.00  0.00           H  
ATOM   1296 HD23 LEU A  82     -15.729   7.089  22.288  1.00  0.00           H  
ATOM   1297  N   ILE A  83     -21.279   3.943  21.419  1.00  0.00           N  
ATOM   1298  CA  ILE A  83     -21.969   2.665  21.293  1.00  0.00           C  
ATOM   1299  C   ILE A  83     -23.112   2.755  20.288  1.00  0.00           C  
ATOM   1300  O   ILE A  83     -23.409   3.829  19.764  1.00  0.00           O  
ATOM   1301  CB  ILE A  83     -22.527   2.191  22.648  1.00  0.00           C  
ATOM   1302  CG1 ILE A  83     -23.533   3.206  23.193  1.00  0.00           C  
ATOM   1303  CG2 ILE A  83     -21.395   1.973  23.640  1.00  0.00           C  
ATOM   1304  CD1 ILE A  83     -24.180   2.778  24.492  1.00  0.00           C  
ATOM   1305  H   ILE A  83     -21.786   4.735  21.693  1.00  0.00           H  
ATOM   1306  HA  ILE A  83     -21.255   1.934  20.945  1.00  0.00           H  
ATOM   1307  HB  ILE A  83     -23.027   1.246  22.496  1.00  0.00           H  
ATOM   1308 HG12 ILE A  83     -23.030   4.144  23.368  1.00  0.00           H  
ATOM   1309 HG13 ILE A  83     -24.316   3.353  22.464  1.00  0.00           H  
ATOM   1310 HG21 ILE A  83     -20.840   2.892  23.762  1.00  0.00           H  
ATOM   1311 HG22 ILE A  83     -21.805   1.673  24.593  1.00  0.00           H  
ATOM   1312 HG23 ILE A  83     -20.736   1.202  23.271  1.00  0.00           H  
ATOM   1313 HD11 ILE A  83     -23.419   2.656  25.250  1.00  0.00           H  
ATOM   1314 HD12 ILE A  83     -24.885   3.532  24.809  1.00  0.00           H  
ATOM   1315 HD13 ILE A  83     -24.695   1.841  24.346  1.00  0.00           H  
ATOM   1316  N   LYS A  84     -23.752   1.621  20.026  1.00  0.00           N  
ATOM   1317  CA  LYS A  84     -24.866   1.570  19.087  1.00  0.00           C  
ATOM   1318  C   LYS A  84     -26.006   0.720  19.639  1.00  0.00           C  
ATOM   1319  O   LYS A  84     -25.825  -0.462  19.933  1.00  0.00           O  
ATOM   1320  CB  LYS A  84     -24.401   1.008  17.742  1.00  0.00           C  
ATOM   1321  CG  LYS A  84     -23.823  -0.394  17.836  1.00  0.00           C  
ATOM   1322  CD  LYS A  84     -22.807  -0.653  16.735  1.00  0.00           C  
ATOM   1323  CE  LYS A  84     -23.386  -1.538  15.641  1.00  0.00           C  
ATOM   1324  NZ  LYS A  84     -22.481  -1.625  14.462  1.00  0.00           N  
ATOM   1325  H   LYS A  84     -23.470   0.797  20.476  1.00  0.00           H  
ATOM   1326  HA  LYS A  84     -25.224   2.578  18.941  1.00  0.00           H  
ATOM   1327  HB2 LYS A  84     -25.243   0.982  17.065  1.00  0.00           H  
ATOM   1328  HB3 LYS A  84     -23.643   1.661  17.335  1.00  0.00           H  
ATOM   1329  HG2 LYS A  84     -23.336  -0.509  18.793  1.00  0.00           H  
ATOM   1330  HG3 LYS A  84     -24.625  -1.112  17.750  1.00  0.00           H  
ATOM   1331  HD2 LYS A  84     -22.512   0.289  16.301  1.00  0.00           H  
ATOM   1332  HD3 LYS A  84     -21.943  -1.143  17.163  1.00  0.00           H  
ATOM   1333  HE2 LYS A  84     -23.540  -2.528  16.041  1.00  0.00           H  
ATOM   1334  HE3 LYS A  84     -24.335  -1.125  15.328  1.00  0.00           H  
ATOM   1335  HZ1 LYS A  84     -21.915  -0.757  14.380  1.00  0.00           H  
ATOM   1336  HZ2 LYS A  84     -23.038  -1.747  13.592  1.00  0.00           H  
ATOM   1337  HZ3 LYS A  84     -21.838  -2.437  14.564  1.00  0.00           H  
ATOM   1338  N   ALA A  85     -27.180   1.327  19.776  1.00  0.00           N  
ATOM   1339  CA  ALA A  85     -28.349   0.625  20.289  1.00  0.00           C  
ATOM   1340  C   ALA A  85     -29.004  -0.218  19.201  1.00  0.00           C  
ATOM   1341  O   ALA A  85     -29.082   0.194  18.044  1.00  0.00           O  
ATOM   1342  CB  ALA A  85     -29.349   1.615  20.866  1.00  0.00           C  
ATOM   1343  H   ALA A  85     -27.262   2.271  19.524  1.00  0.00           H  
ATOM   1344  HA  ALA A  85     -28.023  -0.027  21.087  1.00  0.00           H  
ATOM   1345  HB1 ALA A  85     -30.163   1.076  21.328  1.00  0.00           H  
ATOM   1346  HB2 ALA A  85     -28.859   2.230  21.607  1.00  0.00           H  
ATOM   1347  HB3 ALA A  85     -29.733   2.241  20.075  1.00  0.00           H  
ATOM   1348  N   VAL A  86     -29.475  -1.403  19.579  1.00  0.00           N  
ATOM   1349  CA  VAL A  86     -30.125  -2.304  18.635  1.00  0.00           C  
ATOM   1350  C   VAL A  86     -31.458  -2.805  19.180  1.00  0.00           C  
ATOM   1351  O   VAL A  86     -31.504  -3.499  20.196  1.00  0.00           O  
ATOM   1352  CB  VAL A  86     -29.230  -3.514  18.307  1.00  0.00           C  
ATOM   1353  CG1 VAL A  86     -28.104  -3.107  17.368  1.00  0.00           C  
ATOM   1354  CG2 VAL A  86     -28.675  -4.127  19.583  1.00  0.00           C  
ATOM   1355  H   VAL A  86     -29.384  -1.677  20.515  1.00  0.00           H  
ATOM   1356  HA  VAL A  86     -30.304  -1.758  17.720  1.00  0.00           H  
ATOM   1357  HB  VAL A  86     -29.834  -4.258  17.807  1.00  0.00           H  
ATOM   1358 HG11 VAL A  86     -28.337  -2.152  16.920  1.00  0.00           H  
ATOM   1359 HG12 VAL A  86     -27.181  -3.030  17.925  1.00  0.00           H  
ATOM   1360 HG13 VAL A  86     -27.996  -3.851  16.592  1.00  0.00           H  
ATOM   1361 HG21 VAL A  86     -29.230  -3.756  20.432  1.00  0.00           H  
ATOM   1362 HG22 VAL A  86     -28.766  -5.202  19.535  1.00  0.00           H  
ATOM   1363 HG23 VAL A  86     -27.634  -3.859  19.690  1.00  0.00           H  
ATOM   1364  N   LYS A  87     -32.541  -2.448  18.499  1.00  0.00           N  
ATOM   1365  CA  LYS A  87     -33.877  -2.861  18.913  1.00  0.00           C  
ATOM   1366  C   LYS A  87     -34.260  -4.189  18.268  1.00  0.00           C  
ATOM   1367  O   LYS A  87     -34.109  -4.368  17.059  1.00  0.00           O  
ATOM   1368  CB  LYS A  87     -34.903  -1.787  18.545  1.00  0.00           C  
ATOM   1369  CG  LYS A  87     -35.008  -1.533  17.051  1.00  0.00           C  
ATOM   1370  CD  LYS A  87     -36.225  -2.218  16.453  1.00  0.00           C  
ATOM   1371  CE  LYS A  87     -36.400  -1.862  14.985  1.00  0.00           C  
ATOM   1372  NZ  LYS A  87     -35.948  -2.963  14.090  1.00  0.00           N  
ATOM   1373  H   LYS A  87     -32.440  -1.892  17.697  1.00  0.00           H  
ATOM   1374  HA  LYS A  87     -33.868  -2.986  19.986  1.00  0.00           H  
ATOM   1375  HB2 LYS A  87     -35.873  -2.095  18.906  1.00  0.00           H  
ATOM   1376  HB3 LYS A  87     -34.626  -0.862  19.027  1.00  0.00           H  
ATOM   1377  HG2 LYS A  87     -35.086  -0.470  16.880  1.00  0.00           H  
ATOM   1378  HG3 LYS A  87     -34.119  -1.914  16.567  1.00  0.00           H  
ATOM   1379  HD2 LYS A  87     -36.106  -3.288  16.541  1.00  0.00           H  
ATOM   1380  HD3 LYS A  87     -37.106  -1.906  16.997  1.00  0.00           H  
ATOM   1381  HE2 LYS A  87     -37.444  -1.663  14.797  1.00  0.00           H  
ATOM   1382  HE3 LYS A  87     -35.821  -0.975  14.772  1.00  0.00           H  
ATOM   1383  HZ1 LYS A  87     -35.196  -2.624  13.457  1.00  0.00           H  
ATOM   1384  HZ2 LYS A  87     -36.744  -3.304  13.513  1.00  0.00           H  
ATOM   1385  HZ3 LYS A  87     -35.581  -3.755  14.654  1.00  0.00           H  
ATOM   1386  N   SER A  88     -34.757  -5.116  19.080  1.00  0.00           N  
ATOM   1387  CA  SER A  88     -35.160  -6.428  18.588  1.00  0.00           C  
ATOM   1388  C   SER A  88     -36.472  -6.338  17.814  1.00  0.00           C  
ATOM   1389  O   SER A  88     -37.340  -5.526  18.132  1.00  0.00           O  
ATOM   1390  CB  SER A  88     -35.307  -7.409  19.751  1.00  0.00           C  
ATOM   1391  OG  SER A  88     -36.477  -7.138  20.504  1.00  0.00           O  
ATOM   1392  H   SER A  88     -34.853  -4.913  20.034  1.00  0.00           H  
ATOM   1393  HA  SER A  88     -34.387  -6.785  17.923  1.00  0.00           H  
ATOM   1394  HB2 SER A  88     -35.367  -8.415  19.365  1.00  0.00           H  
ATOM   1395  HB3 SER A  88     -34.447  -7.324  20.401  1.00  0.00           H  
ATOM   1396  HG  SER A  88     -36.257  -6.568  21.244  1.00  0.00           H  
ATOM   1397  N   VAL A  89     -36.608  -7.181  16.795  1.00  0.00           N  
ATOM   1398  CA  VAL A  89     -37.814  -7.199  15.974  1.00  0.00           C  
ATOM   1399  C   VAL A  89     -38.895  -8.068  16.607  1.00  0.00           C  
ATOM   1400  O   VAL A  89     -40.088  -7.800  16.456  1.00  0.00           O  
ATOM   1401  CB  VAL A  89     -37.519  -7.717  14.555  1.00  0.00           C  
ATOM   1402  CG1 VAL A  89     -37.038  -9.159  14.601  1.00  0.00           C  
ATOM   1403  CG2 VAL A  89     -38.752  -7.585  13.673  1.00  0.00           C  
ATOM   1404  H   VAL A  89     -35.882  -7.805  16.590  1.00  0.00           H  
ATOM   1405  HA  VAL A  89     -38.179  -6.185  15.897  1.00  0.00           H  
ATOM   1406  HB  VAL A  89     -36.732  -7.112  14.128  1.00  0.00           H  
ATOM   1407 HG11 VAL A  89     -36.129  -9.217  15.183  1.00  0.00           H  
ATOM   1408 HG12 VAL A  89     -37.797  -9.778  15.056  1.00  0.00           H  
ATOM   1409 HG13 VAL A  89     -36.844  -9.506  13.597  1.00  0.00           H  
ATOM   1410 HG21 VAL A  89     -38.582  -8.096  12.736  1.00  0.00           H  
ATOM   1411 HG22 VAL A  89     -39.600  -8.025  14.175  1.00  0.00           H  
ATOM   1412 HG23 VAL A  89     -38.949  -6.540  13.482  1.00  0.00           H  
ATOM   1413  N   SER A  90     -38.471  -9.110  17.315  1.00  0.00           N  
ATOM   1414  CA  SER A  90     -39.403 -10.021  17.967  1.00  0.00           C  
ATOM   1415  C   SER A  90     -38.700 -10.834  19.051  1.00  0.00           C  
ATOM   1416  O   SER A  90     -38.086 -11.862  18.769  1.00  0.00           O  
ATOM   1417  CB  SER A  90     -40.035 -10.960  16.938  1.00  0.00           C  
ATOM   1418  OG  SER A  90     -39.067 -11.439  16.021  1.00  0.00           O  
ATOM   1419  H   SER A  90     -37.507  -9.271  17.397  1.00  0.00           H  
ATOM   1420  HA  SER A  90     -40.181  -9.428  18.426  1.00  0.00           H  
ATOM   1421  HB2 SER A  90     -40.478 -11.802  17.448  1.00  0.00           H  
ATOM   1422  HB3 SER A  90     -40.801 -10.428  16.392  1.00  0.00           H  
ATOM   1423  HG  SER A  90     -39.256 -12.354  15.805  1.00  0.00           H  
ATOM   1424  N   GLY A  91     -38.794 -10.363  20.290  1.00  0.00           N  
ATOM   1425  CA  GLY A  91     -38.163 -11.057  21.397  1.00  0.00           C  
ATOM   1426  C   GLY A  91     -38.643 -12.488  21.533  1.00  0.00           C  
ATOM   1427  O   GLY A  91     -37.900 -13.440  21.294  1.00  0.00           O  
ATOM   1428  H   GLY A  91     -39.297  -9.538  20.454  1.00  0.00           H  
ATOM   1429  HA2 GLY A  91     -37.094 -11.060  21.244  1.00  0.00           H  
ATOM   1430  HA3 GLY A  91     -38.384 -10.528  22.312  1.00  0.00           H  
ATOM   1431  N   PRO A  92     -39.914 -12.656  21.929  1.00  0.00           N  
ATOM   1432  CA  PRO A  92     -40.520 -13.978  22.106  1.00  0.00           C  
ATOM   1433  C   PRO A  92     -40.734 -14.701  20.780  1.00  0.00           C  
ATOM   1434  O   PRO A  92     -40.641 -14.097  19.712  1.00  0.00           O  
ATOM   1435  CB  PRO A  92     -41.865 -13.667  22.768  1.00  0.00           C  
ATOM   1436  CG  PRO A  92     -42.179 -12.273  22.347  1.00  0.00           C  
ATOM   1437  CD  PRO A  92     -40.858 -11.566  22.231  1.00  0.00           C  
ATOM   1438  HA  PRO A  92     -39.930 -14.601  22.763  1.00  0.00           H  
ATOM   1439  HB2 PRO A  92     -42.612 -14.364  22.417  1.00  0.00           H  
ATOM   1440  HB3 PRO A  92     -41.769 -13.742  23.841  1.00  0.00           H  
ATOM   1441  HG2 PRO A  92     -42.684 -12.282  21.393  1.00  0.00           H  
ATOM   1442  HG3 PRO A  92     -42.795 -11.794  23.094  1.00  0.00           H  
ATOM   1443  HD2 PRO A  92     -40.884 -10.845  21.428  1.00  0.00           H  
ATOM   1444  HD3 PRO A  92     -40.603 -11.085  23.163  1.00  0.00           H  
ATOM   1445  N   SER A  93     -41.022 -15.997  20.858  1.00  0.00           N  
ATOM   1446  CA  SER A  93     -41.246 -16.802  19.663  1.00  0.00           C  
ATOM   1447  C   SER A  93     -42.683 -16.658  19.171  1.00  0.00           C  
ATOM   1448  O   SER A  93     -42.924 -16.251  18.035  1.00  0.00           O  
ATOM   1449  CB  SER A  93     -40.938 -18.274  19.950  1.00  0.00           C  
ATOM   1450  OG  SER A  93     -39.681 -18.418  20.588  1.00  0.00           O  
ATOM   1451  H   SER A  93     -41.082 -16.421  21.740  1.00  0.00           H  
ATOM   1452  HA  SER A  93     -40.577 -16.447  18.894  1.00  0.00           H  
ATOM   1453  HB2 SER A  93     -41.703 -18.680  20.593  1.00  0.00           H  
ATOM   1454  HB3 SER A  93     -40.922 -18.823  19.019  1.00  0.00           H  
ATOM   1455  HG  SER A  93     -39.736 -18.079  21.485  1.00  0.00           H  
ATOM   1456  N   SER A  94     -43.634 -16.995  20.036  1.00  0.00           N  
ATOM   1457  CA  SER A  94     -45.048 -16.906  19.691  1.00  0.00           C  
ATOM   1458  C   SER A  94     -45.414 -15.490  19.258  1.00  0.00           C  
ATOM   1459  O   SER A  94     -45.586 -14.599  20.089  1.00  0.00           O  
ATOM   1460  CB  SER A  94     -45.913 -17.328  20.880  1.00  0.00           C  
ATOM   1461  OG  SER A  94     -45.695 -18.687  21.214  1.00  0.00           O  
ATOM   1462  H   SER A  94     -43.379 -17.312  20.928  1.00  0.00           H  
ATOM   1463  HA  SER A  94     -45.230 -17.580  18.867  1.00  0.00           H  
ATOM   1464  HB2 SER A  94     -45.668 -16.716  21.735  1.00  0.00           H  
ATOM   1465  HB3 SER A  94     -46.956 -17.193  20.629  1.00  0.00           H  
ATOM   1466  HG  SER A  94     -45.501 -18.761  22.151  1.00  0.00           H  
ATOM   1467  N   GLY A  95     -45.532 -15.290  17.948  1.00  0.00           N  
ATOM   1468  CA  GLY A  95     -45.876 -13.980  17.427  1.00  0.00           C  
ATOM   1469  C   GLY A  95     -47.366 -13.820  17.199  1.00  0.00           C  
ATOM   1470  O   GLY A  95     -47.936 -14.452  16.309  1.00  0.00           O  
ATOM   1471  H   GLY A  95     -45.383 -16.037  17.332  1.00  0.00           H  
ATOM   1472  HA2 GLY A  95     -45.546 -13.227  18.126  1.00  0.00           H  
ATOM   1473  HA3 GLY A  95     -45.363 -13.834  16.487  1.00  0.00           H  
TER    1474      GLY A  95                                                      
END
MOLECULE T0443_97_230.pdb
ATOM    557  N   SER    97       9.444  13.904  25.999  1.00 32.65           N  
ATOM    558  CA  SER    97       9.019  13.771  27.400  1.00 32.55           C  
ATOM    559  C   SER    97       7.759  12.923  27.498  1.00 32.70           C  
ATOM    560  O   SER    97       7.026  12.769  26.517  1.00 33.71           O  
ATOM    561  CB  SER    97       8.716  15.139  27.997  1.00 32.59           C  
ATOM    562  OG  SER    97       7.547  15.663  27.400  1.00 31.84           O  
ATOM    563  N   ASP    98       7.467  12.409  28.690  1.00 33.19           N  
ATOM    564  CA  ASP    98       6.275  11.582  28.879  1.00 33.23           C  
ATOM    565  C   ASP    98       4.966  12.366  28.697  1.00 32.35           C  
ATOM    566  O   ASP    98       3.961  11.797  28.233  1.00 31.66           O  
ATOM    567  CB  ASP    98       6.314  10.868  30.227  1.00 34.81           C  
ATOM    568  CG  ASP    98       7.346   9.752  30.271  1.00 35.79           C  
ATOM    569  OD1 ASP    98       7.927   9.397  29.218  1.00 36.03           O  
ATOM    570  OD2 ASP    98       7.566   9.216  31.376  1.00 38.06           O  
ATOM    571  N   GLY    99       4.990  13.651  29.055  1.00 30.82           N  
ATOM    572  CA  GLY    99       3.842  14.548  28.894  1.00 30.89           C  
ATOM    573  C   GLY    99       3.507  14.851  27.439  1.00 31.23           C  
ATOM    574  O   GLY    99       2.338  14.867  27.051  1.00 32.26           O  
ATOM    575  N   ILE   100       4.532  15.128  26.633  1.00 31.16           N  
ATOM    576  CA  ILE   100       4.345  15.348  25.206  1.00 29.39           C  
ATOM    577  C   ILE   100       3.859  14.036  24.541  1.00 29.36           C  
ATOM    578  O   ILE   100       2.931  14.074  23.743  1.00 30.42           O  
ATOM    579  CB  ILE   100       5.637  15.902  24.562  1.00 30.48           C  
ATOM    580  CG1 ILE   100       5.934  17.321  25.075  1.00 31.37           C  
ATOM    581  CG2 ILE   100       5.542  15.941  23.038  1.00 30.03           C  
ATOM    582  CD1 ILE   100       4.947  18.391  24.593  1.00 31.63           C  
ATOM    583  N   LEU   101       4.433  12.889  24.915  1.00 27.54           N  
ATOM    584  CA  LEU   101       4.056  11.584  24.340  1.00 27.41           C  
ATOM    585  C   LEU   101       2.603  11.212  24.618  1.00 27.36           C  
ATOM    586  O   LEU   101       1.952  10.611  23.761  1.00 26.82           O  
ATOM    587  CB  LEU   101       4.997  10.452  24.813  1.00 27.14           C  
ATOM    588  CG  LEU   101       6.374  10.483  24.155  1.00 27.77           C  
ATOM    589  CD1 LEU   101       7.364   9.480  24.749  1.00 28.09           C  
ATOM    590  CD2 LEU   101       6.204  10.283  22.646  1.00 27.85           C  
ATOM    591  N   ALA   102       2.113  11.536  25.809  1.00 26.46           N  
ATOM    592  CA  ALA   102       0.725  11.313  26.148  1.00 27.20           C  
ATOM    593  C   ALA   102      -0.163  12.246  25.304  1.00 27.49           C  
ATOM    594  O   ALA   102      -1.179  11.829  24.744  1.00 28.34           O  
ATOM    595  CB  ALA   102       0.495  11.534  27.664  1.00 26.33           C  
ATOM    596  N   LEU   103       0.242  13.502  25.194  1.00 28.56           N  
ATOM    597  CA  LEU   103      -0.483  14.476  24.398  1.00 28.57           C  
ATOM    598  C   LEU   103      -0.498  14.094  22.928  1.00 30.29           C  
ATOM    599  O   LEU   103      -1.466  14.368  22.211  1.00 31.20           O  
ATOM    600  CB  LEU   103       0.150  15.852  24.550  1.00 27.97           C  
ATOM    601  CG  LEU   103      -0.540  16.927  23.734  1.00 27.93           C  
ATOM    602  CD1 LEU   103      -2.056  16.931  24.028  1.00 28.16           C  
ATOM    603  CD2 LEU   103       0.114  18.260  24.005  1.00 27.38           C  
ATOM    604  N   MET   104       0.578  13.477  22.459  1.00 30.91           N  
ATOM    605  CA  MET   104       0.587  13.021  21.088  1.00 31.03           C  
ATOM    606  C   MET   104      -0.356  11.843  20.907  1.00 31.30           C  
ATOM    607  O   MET   104      -1.078  11.768  19.908  1.00 31.91           O  
ATOM    608  CB  MET   104       2.011  12.700  20.593  1.00 29.78           C  
ATOM    609  CG  MET   104       2.852  13.953  20.409  1.00 29.50           C  
ATOM    610  SD  MET   104       4.547  13.560  19.600  0.75 28.40          SE  
ATOM    611  CE  MET   104       4.041  13.148  17.802  1.00 27.34           C  
ATOM    612  N   ASP   105      -0.376  10.926  21.857  1.00 31.23           N  
ATOM    613  CA  ASP   105      -1.286   9.791  21.726  1.00 32.67           C  
ATOM    614  C   ASP   105      -2.788  10.253  21.729  1.00 32.95           C  
ATOM    615  O   ASP   105      -3.590   9.801  20.916  1.00 32.42           O  
ATOM    616  CB  ASP   105      -0.974   8.721  22.766  1.00 32.38           C  
ATOM    617  CG  ASP   105      -1.939   7.573  22.686  1.00 33.91           C  
ATOM    618  OD1 ASP   105      -3.040   7.652  23.253  1.00 33.56           O  
ATOM    619  OD2 ASP   105      -1.555   6.530  22.122  1.00 35.97           O  
ATOM    620  N   PHE   106      -3.129  11.160  22.630  1.00 33.56           N  
ATOM    621  CA  PHE   106      -4.457  11.802  22.702  1.00 35.01           C  
ATOM    622  C   PHE   106      -4.878  12.370  21.332  1.00 36.24           C  
ATOM    623  O   PHE   106      -5.978  12.083  20.818  1.00 36.06           O  
ATOM    624  CB  PHE   106      -4.385  12.903  23.770  1.00 35.80           C  
ATOM    625  CG  PHE   106      -5.655  13.703  23.965  1.00 36.05           C  
ATOM    626  CD1 PHE   106      -6.880  13.073  24.216  1.00 35.54           C  
ATOM    627  CD2 PHE   106      -5.600  15.108  23.982  1.00 36.94           C  
ATOM    628  CE1 PHE   106      -8.029  13.817  24.425  1.00 36.07           C  
ATOM    629  CE2 PHE   106      -6.743  15.860  24.198  1.00 36.31           C  
ATOM    630  CZ  PHE   106      -7.966  15.215  24.432  1.00 36.38           C  
ATOM    631  N   GLU   107      -3.976  13.149  20.733  1.00 37.10           N  
ATOM    632  CA  GLU   107      -4.199  13.781  19.423  1.00 35.80           C  
ATOM    633  C   GLU   107      -4.382  12.751  18.330  1.00 35.02           C  
ATOM    634  O   GLU   107      -5.280  12.864  17.512  1.00 33.91           O  
ATOM    635  CB  GLU   107      -3.049  14.734  19.088  1.00 36.77           C  
ATOM    636  CG  GLU   107      -3.160  16.067  19.838  1.00 35.57           C  
ATOM    637  CD  GLU   107      -2.247  17.140  19.300  1.00 36.65           C  
ATOM    638  OE1 GLU   107      -1.006  16.977  19.321  1.00 37.42           O  
ATOM    639  OE2 GLU   107      -2.761  18.199  18.885  1.00 37.20           O  
ATOM    640  N   TYR   108      -3.534  11.735  18.321  1.00 34.20           N  
ATOM    641  CA  TYR   108      -3.688  10.676  17.353  1.00 35.65           C  
ATOM    642  C   TYR   108      -5.048   9.963  17.523  1.00 34.35           C  
ATOM    643  O   TYR   108      -5.718   9.617  16.551  1.00 34.92           O  
ATOM    644  CB  TYR   108      -2.523   9.682  17.454  1.00 35.28           C  
ATOM    645  CG  TYR   108      -2.558   8.616  16.409  1.00 35.58           C  
ATOM    646  CD1 TYR   108      -2.544   8.953  15.053  1.00 35.63           C  
ATOM    647  CD2 TYR   108      -2.590   7.270  16.761  1.00 34.32           C  
ATOM    648  CE1 TYR   108      -2.584   7.978  14.075  1.00 35.54           C  
ATOM    649  CE2 TYR   108      -2.619   6.298  15.802  1.00 35.87           C  
ATOM    650  CZ  TYR   108      -2.616   6.649  14.449  1.00 35.77           C  
ATOM    651  OH  TYR   108      -2.658   5.681  13.471  1.00 35.26           O  
ATOM    652  N   THR   109      -5.448   9.746  18.769  1.00 35.03           N  
ATOM    653  CA  THR   109      -6.698   9.064  19.076  1.00 33.68           C  
ATOM    654  C   THR   109      -7.861   9.886  18.507  1.00 31.85           C  
ATOM    655  O   THR   109      -8.816   9.315  18.010  1.00 32.82           O  
ATOM    656  CB  THR   109      -6.808   8.731  20.607  1.00 35.01           C  
ATOM    657  OG1 THR   109      -5.735   7.858  20.969  1.00 34.59           O  
ATOM    658  CG2 THR   109      -8.135   8.031  20.970  1.00 33.15           C  
ATOM    659  N   GLN   110      -7.801  11.217  18.549  1.00 30.28           N  
ATOM    660  CA  GLN   110      -8.859  12.002  17.968  1.00 30.39           C  
ATOM    661  C   GLN   110      -8.990  11.707  16.478  1.00 31.29           C  
ATOM    662  O   GLN   110     -10.103  11.494  15.963  1.00 30.97           O  
ATOM    663  CB  GLN   110      -8.678  13.509  18.239  1.00 31.63           C  
ATOM    664  CG  GLN   110      -8.869  13.893  19.712  1.00 31.90           C  
ATOM    665  CD  GLN   110      -8.517  15.343  19.995  1.00 33.22           C  
ATOM    666  OE1 GLN   110      -7.835  15.657  20.974  1.00 34.63           O  
ATOM    667  NE2 GLN   110      -8.977  16.233  19.134  1.00 35.22           N  
ATOM    668  N   LEU   111      -7.858  11.648  15.775  1.00 30.57           N  
ATOM    669  CA  LEU   111      -7.878  11.335  14.362  1.00 30.61           C  
ATOM    670  C   LEU   111      -8.434   9.911  14.164  1.00 31.02           C  
ATOM    671  O   LEU   111      -9.228   9.651  13.260  1.00 30.94           O  
ATOM    672  CB  LEU   111      -6.471  11.490  13.758  1.00 30.95           C  
ATOM    673  CG  LEU   111      -6.293  11.231  12.256  1.00 31.08           C  
ATOM    674  CD1 LEU   111      -7.111  12.147  11.455  1.00 30.25           C  
ATOM    675  CD2 LEU   111      -4.806  11.369  11.903  1.00 31.37           C  
ATOM    676  N   LEU   112      -8.077   8.985  15.037  1.00 31.17           N  
ATOM    677  CA  LEU   112      -8.657   7.657  14.911  1.00 31.52           C  
ATOM    678  C   LEU   112     -10.191   7.645  15.018  1.00 34.16           C  
ATOM    679  O   LEU   112     -10.858   6.803  14.374  1.00 33.67           O  
ATOM    680  CB  LEU   112      -8.070   6.724  15.939  1.00 30.68           C  
ATOM    681  CG  LEU   112      -6.630   6.333  15.739  1.00 28.89           C  
ATOM    682  CD1 LEU   112      -6.242   5.410  16.888  1.00 28.54           C  
ATOM    683  CD2 LEU   112      -6.406   5.663  14.382  1.00 28.98           C  
ATOM    684  N   ALA   113     -10.747   8.598  15.784  1.00 34.42           N  
ATOM    685  CA  ALA   113     -12.190   8.674  15.988  1.00 34.82           C  
ATOM    686  C   ALA   113     -12.821   9.386  14.806  1.00 36.77           C  
ATOM    687  O   ALA   113     -13.933   9.038  14.385  1.00 34.40           O  
ATOM    688  CB  ALA   113     -12.513   9.386  17.282  1.00 33.82           C  
ATOM    689  N   GLU   114     -12.105  10.396  14.285  1.00 38.02           N  
ATOM    690  CA  GLU   114     -12.525  11.148  13.083  1.00 38.27           C  
ATOM    691  C   GLU   114     -12.688  10.230  11.866  1.00 37.71           C  
ATOM    692  O   GLU   114     -13.631  10.376  11.072  1.00 35.85           O  
ATOM    693  CB  GLU   114     -11.479  12.231  12.748  1.00 38.46           C  
ATOM    694  CG  GLU   114     -11.625  12.955  11.411  1.00 38.44           C  
ATOM    695  CD  GLU   114     -12.912  13.774  11.263  1.00 39.18           C  
ATOM    696  OE1 GLU   114     -13.863  13.564  12.052  1.00 39.13           O  
ATOM    697  OE2 GLU   114     -12.969  14.629  10.339  1.00 38.38           O  
ATOM    698  N   VAL   115     -11.786   9.260  11.783  1.00 36.86           N  
ATOM    699  CA  VAL   115     -11.649   8.407  10.616  1.00 37.42           C  
ATOM    700  C   VAL   115     -12.283   7.031  10.766  1.00 37.20           C  
ATOM    701  O   VAL   115     -12.437   6.316   9.783  1.00 36.94           O  
ATOM    702  CB  VAL   115     -10.088   8.346  10.255  1.00 37.61           C  
ATOM    703  CG1 VAL   115      -9.631   7.000   9.754  1.00 37.26           C  
ATOM    704  CG2 VAL   115      -9.717   9.491   9.349  1.00 35.81           C  
ATOM    705  N   ALA   116     -12.693   6.662  11.972  1.00 37.42           N  
ATOM    706  CA  ALA   116     -13.258   5.331  12.187  1.00 37.49           C  
ATOM    707  C   ALA   116     -14.540   5.101  11.376  1.00 37.88           C  
ATOM    708  O   ALA   116     -15.338   6.015  11.165  1.00 37.84           O  
ATOM    709  CB  ALA   116     -13.500   5.083  13.680  1.00 38.00           C  
ATOM    710  N   GLN   117     -14.690   3.876  10.881  1.00 39.14           N  
ATOM    711  CA  GLN   117     -15.857   3.473  10.117  1.00 39.51           C  
ATOM    712  C   GLN   117     -16.844   2.904  11.096  1.00 39.20           C  
ATOM    713  O   GLN   117     -16.541   1.915  11.775  1.00 39.62           O  
ATOM    714  CB  GLN   117     -15.520   2.391   9.087  1.00 40.02           C  
ATOM    715  CG  GLN   117     -16.761   1.831   8.351  1.00 40.38           C  
ATOM    716  N   ILE   118     -18.023   3.517  11.148  1.00 38.74           N  
ATOM    717  CA  ILE   118     -19.100   3.113  12.047  1.00 37.74           C  
ATOM    718  C   ILE   118     -20.190   2.493  11.173  1.00 37.96           C  
ATOM    719  O   ILE   118     -20.690   3.184  10.284  1.00 37.83           O  
ATOM    720  CB  ILE   118     -19.650   4.354  12.786  1.00 36.97           C  
ATOM    721  CG1 ILE   118     -18.576   4.967  13.676  1.00 36.79           C  
ATOM    722  CG2 ILE   118     -20.836   3.996  13.663  1.00 37.44           C  
ATOM    723  CD1 ILE   118     -18.946   6.361  14.158  1.00 36.94           C  
ATOM    724  N   PRO   119     -20.504   1.180  11.345  1.00 37.96           N  
ATOM    725  CA  PRO   119     -21.559   0.572  10.535  1.00 37.61           C  
ATOM    726  C   PRO   119     -22.869   1.352  10.481  1.00 37.30           C  
ATOM    727  O   PRO   119     -23.244   2.008  11.459  1.00 37.04           O  
ATOM    728  CB  PRO   119     -21.800  -0.801  11.196  1.00 38.22           C  
ATOM    729  CG  PRO   119     -20.857  -0.881  12.383  1.00 38.45           C  
ATOM    730  CD  PRO   119     -19.820   0.169  12.178  1.00 38.93           C  
ATOM    731  N   ASP   120     -23.525   1.290   9.321  1.00 36.76           N  
ATOM    732  CA  ASP   120     -24.832   1.907   9.121  1.00 36.79           C  
ATOM    733  C   ASP   120     -25.816   1.213  10.070  1.00 36.53           C  
ATOM    734  O   ASP   120     -25.821  -0.020  10.190  1.00 36.76           O  
ATOM    735  CB  ASP   120     -25.290   1.781   7.665  1.00 35.70           C  
ATOM    736  N   ILE   121     -26.612   2.007  10.777  1.00 36.81           N  
ATOM    737  CA  ILE   121     -27.601   1.463  11.728  1.00 36.43           C  
ATOM    738  C   ILE   121     -29.007   1.772  11.216  1.00 36.10           C  
ATOM    739  O   ILE   121     -29.369   2.955  11.079  1.00 36.53           O  
ATOM    740  CB  ILE   121     -27.441   2.053  13.157  1.00 36.35           C  
ATOM    741  CG1 ILE   121     -26.346   1.342  13.987  1.00 36.03           C  
ATOM    742  CG2 ILE   121     -28.747   1.798  13.971  1.00 36.54           C  
ATOM    743  CD1 ILE   121     -25.097   1.027  13.356  1.00 35.96           C  
ATOM    744  N   PRO   122     -29.788   0.728  10.870  1.00 35.15           N  
ATOM    745  CA  PRO   122     -31.171   1.018  10.479  1.00 34.84           C  
ATOM    746  C   PRO   122     -31.915   1.759  11.588  1.00 34.29           C  
ATOM    747  O   PRO   122     -31.737   1.480  12.791  1.00 32.53           O  
ATOM    748  CB  PRO   122     -31.781  -0.367  10.236  1.00 35.03           C  
ATOM    749  CG  PRO   122     -30.621  -1.233   9.907  1.00 35.38           C  
ATOM    750  CD  PRO   122     -29.488  -0.711  10.766  1.00 35.15           C  
ATOM    751  N   ASP   123     -32.722   2.719  11.165  1.00 34.56           N  
ATOM    752  CA  ASP   123     -33.461   3.540  12.081  1.00 34.50           C  
ATOM    753  C   ASP   123     -34.829   2.908  12.365  1.00 33.08           C  
ATOM    754  O   ASP   123     -35.856   3.309  11.826  1.00 32.07           O  
ATOM    755  CB  ASP   123     -33.559   4.950  11.511  1.00 35.67           C  
ATOM    756  CG  ASP   123     -33.888   5.972  12.555  1.00 36.62           C  
ATOM    757  OD1 ASP   123     -33.929   5.622  13.755  1.00 37.75           O  
ATOM    758  OD2 ASP   123     -34.108   7.133  12.166  1.00 38.52           O  
ATOM    759  N   ILE   124     -34.798   1.901  13.241  1.00 32.79           N  
ATOM    760  CA  ILE   124     -35.975   1.159  13.684  1.00 31.54           C  
ATOM    761  C   ILE   124     -36.037   1.214  15.210  1.00 31.99           C  
ATOM    762  O   ILE   124     -35.290   1.969  15.851  1.00 31.86           O  
ATOM    763  CB  ILE   124     -35.939  -0.318  13.192  1.00 30.72           C  
ATOM    764  CG1 ILE   124     -34.792  -1.106  13.840  1.00 30.34           C  
ATOM    765  CG2 ILE   124     -35.842  -0.352  11.657  1.00 30.34           C  
ATOM    766  CD1 ILE   124     -34.778  -2.601  13.479  1.00 30.60           C  
ATOM    767  N   HIS   125     -36.940   0.427  15.795  1.00 31.68           N  
ATOM    768  CA  HIS   125     -37.063   0.371  17.238  1.00 30.63           C  
ATOM    769  C   HIS   125     -36.133  -0.690  17.806  1.00 31.38           C  
ATOM    770  O   HIS   125     -36.158  -1.848  17.378  1.00 31.11           O  
ATOM    771  CB  HIS   125     -38.491   0.061  17.652  1.00 30.09           C  
ATOM    772  CG  HIS   125     -38.703   0.103  19.128  1.00 29.67           C  
ATOM    773  ND1 HIS   125     -39.161   1.227  19.774  1.00 29.17           N  
ATOM    774  CD2 HIS   125     -38.504  -0.835  20.088  1.00 29.71           C  
ATOM    775  CE1 HIS   125     -39.249   0.976  21.071  1.00 30.24           C  
ATOM    776  NE2 HIS   125     -38.846  -0.265  21.288  1.00 29.36           N  
ATOM    777  N   TYR   126     -35.284  -0.281  18.752  1.00 32.16           N  
ATOM    778  CA  TYR   126     -34.413  -1.222  19.455  1.00 32.02           C  
ATOM    779  C   TYR   126     -34.825  -1.190  20.918  1.00 30.88           C  
ATOM    780  O   TYR   126     -34.697  -0.178  21.569  1.00 30.80           O  
ATOM    781  CB  TYR   126     -32.932  -0.859  19.288  1.00 31.79           C  
ATOM    782  CG  TYR   126     -32.460  -0.901  17.833  1.00 31.58           C  
ATOM    783  CD1 TYR   126     -32.175  -2.120  17.209  1.00 31.68           C  
ATOM    784  CD2 TYR   126     -32.302   0.271  17.090  1.00 31.54           C  
ATOM    785  CE1 TYR   126     -31.745  -2.176  15.868  1.00 31.67           C  
ATOM    786  CE2 TYR   126     -31.876   0.230  15.763  1.00 31.47           C  
ATOM    787  CZ  TYR   126     -31.592  -1.006  15.157  1.00 31.98           C  
ATOM    788  OH  TYR   126     -31.172  -1.075  13.832  1.00 32.02           O  
ATOM    789  N   SER   127     -35.346  -2.299  21.429  1.00 30.50           N  
ATOM    790  CA  SER   127     -35.776  -2.363  22.835  1.00 28.63           C  
ATOM    791  C   SER   127     -34.573  -2.540  23.798  1.00 28.44           C  
ATOM    792  O   SER   127     -33.393  -2.582  23.369  1.00 27.83           O  
ATOM    793  CB  SER   127     -36.712  -3.532  23.010  1.00 27.86           C  
ATOM    794  OG  SER   127     -35.992  -4.736  22.923  1.00 26.15           O  
ATOM    795  N   ASN   128     -34.881  -2.633  25.088  1.00 27.65           N  
ATOM    796  CA  ASN   128     -33.875  -2.896  26.115  1.00 27.69           C  
ATOM    797  C   ASN   128     -33.578  -4.373  26.171  1.00 27.51           C  
ATOM    798  O   ASN   128     -32.877  -4.812  27.051  1.00 26.32           O  
ATOM    799  CB  ASN   128     -34.288  -2.387  27.484  1.00 27.86           C  
ATOM    800  CG  ASN   128     -34.374  -0.865  27.550  1.00 29.20           C  
ATOM    801  OD1 ASN   128     -33.713  -0.173  26.812  1.00 30.68           O  
ATOM    802  ND2 ASN   128     -35.174  -0.362  28.454  1.00 30.11           N  
ATOM    803  N   ASP   129     -34.124  -5.130  25.235  1.00 29.56           N  
ATOM    804  CA  ASP   129     -33.754  -6.527  25.072  1.00 32.20           C  
ATOM    805  C   ASP   129     -32.702  -6.608  23.947  1.00 32.50           C  
ATOM    806  O   ASP   129     -32.026  -7.621  23.812  1.00 31.46           O  
ATOM    807  CB  ASP   129     -34.944  -7.367  24.692  1.00 32.76           C  
ATOM    808  CG  ASP   129     -34.645  -8.857  24.803  1.00 33.97           C  
ATOM    809  OD1 ASP   129     -34.244  -9.281  25.911  1.00 35.60           O  
ATOM    810  OD2 ASP   129     -34.794  -9.594  23.799  1.00 33.96           O  
ATOM    811  N   SER   130     -32.564  -5.529  23.158  1.00 33.49           N  
ATOM    812  CA  SER   130     -31.562  -5.471  22.058  1.00 34.51           C  
ATOM    813  C   SER   130     -30.140  -5.183  22.523  1.00 33.88           C  
ATOM    814  O   SER   130     -29.894  -4.208  23.252  1.00 34.32           O  
ATOM    815  CB  SER   130     -31.914  -4.418  20.997  1.00 35.21           C  
ATOM    816  OG  SER   130     -32.926  -4.883  20.134  1.00 37.41           O  
ATOM    817  N   LYS   131     -29.203  -5.992  22.028  1.00 32.98           N  
ATOM    818  CA  LYS   131     -27.788  -5.831  22.372  1.00 33.25           C  
ATOM    819  C   LYS   131     -27.079  -4.623  21.752  1.00 34.21           C  
ATOM    820  O   LYS   131     -27.345  -4.219  20.600  1.00 35.24           O  
ATOM    821  CB  LYS   131     -26.998  -7.079  21.997  1.00 32.43           C  
ATOM    822  CG  LYS   131     -27.365  -8.340  22.731  1.00 30.56           C  
ATOM    823  CD  LYS   131     -26.298  -9.360  22.420  1.00 30.14           C  
ATOM    824  CE  LYS   131     -26.583 -10.694  23.034  1.00 29.35           C  
ATOM    825  NZ  LYS   131     -25.600 -11.650  22.472  1.00 28.55           N  
ATOM    826  N   TYR   132     -26.167  -4.059  22.541  1.00 34.56           N  
ATOM    827  CA  TYR   132     -25.337  -2.923  22.138  1.00 34.57           C  
ATOM    828  C   TYR   132     -23.860  -3.303  22.258  1.00 34.03           C  
ATOM    829  O   TYR   132     -23.496  -4.298  22.895  1.00 34.91           O  
ATOM    830  CB  TYR   132     -25.671  -1.656  22.924  1.00 34.95           C  
ATOM    831  CG  TYR   132     -26.909  -0.970  22.392  1.00 35.34           C  
ATOM    832  CD1 TYR   132     -28.161  -1.550  22.548  1.00 34.93           C  
ATOM    833  CD2 TYR   132     -26.833   0.271  21.743  1.00 34.71           C  
ATOM    834  CE1 TYR   132     -29.296  -0.961  22.038  1.00 34.57           C  
ATOM    835  CE2 TYR   132     -27.960   0.871  21.238  1.00 35.07           C  
ATOM    836  CZ  TYR   132     -29.195   0.240  21.397  1.00 35.45           C  
ATOM    837  OH  TYR   132     -30.333   0.810  20.913  1.00 35.94           O  
ATOM    838  N   THR   133     -23.056  -2.574  21.513  1.00 33.01           N  
ATOM    839  CA  THR   133     -21.608  -2.737  21.451  1.00 33.04           C  
ATOM    840  C   THR   133     -21.076  -1.286  21.444  1.00 32.43           C  
ATOM    841  O   THR   133     -21.792  -0.373  21.008  1.00 31.13           O  
ATOM    842  CB  THR   133     -21.239  -3.499  20.159  1.00 33.45           C  
ATOM    843  OG1 THR   133     -19.837  -3.816  20.132  1.00 34.34           O  
ATOM    844  CG2 THR   133     -21.665  -2.709  18.889  1.00 32.15           C  
ATOM    845  N   PRO   134     -19.856  -1.044  21.947  1.00 33.28           N  
ATOM    846  CA  PRO   134     -19.356   0.372  21.853  1.00 32.73           C  
ATOM    847  C   PRO   134     -19.064   0.749  20.393  1.00 31.84           C  
ATOM    848  O   PRO   134     -18.792  -0.114  19.609  1.00 31.68           O  
ATOM    849  CB  PRO   134     -18.052   0.372  22.660  1.00 33.47           C  
ATOM    850  CG  PRO   134     -17.881  -1.021  23.202  1.00 34.04           C  
ATOM    851  CD  PRO   134     -18.877  -1.956  22.542  1.00 33.56           C  
ATOM    852  N   SER   135     -19.118   2.029  20.027  1.00 33.13           N  
ATOM    853  CA  SER   135     -18.845   2.424  18.654  0.50 31.70           C  
ATOM    855  C   SER   135     -17.407   2.086  18.288  1.00 32.82           C  
ATOM    856  O   SER   135     -16.504   2.197  19.131  1.00 34.51           O  
ATOM    857  CB  SER   135     -19.048   3.926  18.440  0.50 30.68           C  
ATOM    859  OG  SER   135     -18.698   4.292  17.117  0.50 27.27           O  
ATOM    861  N   PRO   136     -17.181   1.647  17.036  1.00 30.78           N  
ATOM    862  CA  PRO   136     -15.796   1.420  16.680  1.00 30.75           C  
ATOM    863  C   PRO   136     -15.003   2.724  16.706  1.00 31.52           C  
ATOM    864  O   PRO   136     -13.776   2.688  16.676  1.00 33.29           O  
ATOM    865  CB  PRO   136     -15.860   0.839  15.259  1.00 31.65           C  
ATOM    866  CG  PRO   136     -17.265   0.651  14.924  1.00 30.94           C  
ATOM    867  CD  PRO   136     -18.124   1.292  15.964  1.00 30.49           C  
ATOM    868  N   ALA   137     -15.693   3.870  16.781  1.00 32.33           N  
ATOM    869  CA  ALA   137     -15.056   5.159  16.842  1.00 33.46           C  
ATOM    870  C   ALA   137     -14.846   5.650  18.274  1.00 34.89           C  
ATOM    871  O   ALA   137     -14.559   6.845  18.467  1.00 34.59           O  
ATOM    872  CB  ALA   137     -15.902   6.193  16.070  1.00 32.66           C  
ATOM    873  N   ALA   138     -15.024   4.752  19.248  1.00 34.13           N  
ATOM    874  CA  ALA   138     -14.902   5.049  20.685  1.00 35.16           C  
ATOM    875  C   ALA   138     -13.668   4.388  21.264  1.00 35.13           C  
ATOM    876  O   ALA   138     -13.452   3.192  21.086  1.00 34.97           O  
ATOM    877  CB  ALA   138     -16.161   4.574  21.462  1.00 35.04           C  
ATOM    878  N   PHE   139     -12.870   5.180  21.959  1.00 35.95           N  
ATOM    879  CA  PHE   139     -11.614   4.734  22.528  1.00 36.87           C  
ATOM    880  C   PHE   139     -11.471   5.138  23.993  1.00 36.57           C  
ATOM    881  O   PHE   139     -11.821   6.270  24.388  1.00 36.96           O  
ATOM    882  CB  PHE   139     -10.447   5.322  21.731  1.00 37.58           C  
ATOM    883  CG  PHE   139     -10.437   4.917  20.257  1.00 38.18           C  
ATOM    884  CD1 PHE   139     -11.110   5.675  19.304  1.00 37.01           C  
ATOM    885  CD2 PHE   139      -9.756   3.790  19.838  1.00 37.84           C  
ATOM    886  CE1 PHE   139     -11.115   5.313  17.985  1.00 36.83           C  
ATOM    887  CE2 PHE   139      -9.764   3.431  18.501  1.00 37.78           C  
ATOM    888  CZ  PHE   139     -10.441   4.210  17.578  1.00 37.29           C  
ATOM    889  N   ILE   140     -10.952   4.201  24.778  1.00 35.26           N  
ATOM    890  CA  ILE   140     -10.656   4.414  26.186  1.00 36.28           C  
ATOM    891  C   ILE   140      -9.157   4.673  26.333  1.00 36.01           C  
ATOM    892  O   ILE   140      -8.360   3.790  25.981  1.00 35.21           O  
ATOM    893  CB  ILE   140     -10.980   3.153  27.042  1.00 36.47           C  
ATOM    894  CG1 ILE   140     -12.471   2.827  26.992  1.00 36.86           C  
ATOM    895  CG2 ILE   140     -10.505   3.359  28.507  1.00 36.54           C  
ATOM    896  CD1 ILE   140     -12.823   1.467  27.609  1.00 37.66           C  
ATOM    897  N   ARG   141      -8.788   5.832  26.895  1.00 35.41           N  
ATOM    898  CA  ARG   141      -7.369   6.211  27.124  1.00 34.78           C  
ATOM    899  C   ARG   141      -7.021   6.495  28.588  1.00 34.90           C  
ATOM    900  O   ARG   141      -7.810   7.115  29.289  1.00 34.61           O  
ATOM    901  CB  ARG   141      -7.002   7.454  26.281  1.00 34.37           C  
ATOM    902  CG  ARG   141      -6.906   7.196  24.783  1.00 34.55           C  
ATOM    903  CD  ARG   141      -5.886   6.100  24.513  1.00 34.71           C  
ATOM    904  NE  ARG   141      -5.766   5.735  23.120  1.00 35.21           N  
ATOM    905  CZ  ARG   141      -6.274   4.642  22.544  1.00 35.59           C  
ATOM    906  NH1 ARG   141      -6.948   3.726  23.222  1.00 36.12           N  
ATOM    907  NH2 ARG   141      -6.061   4.446  21.255  1.00 35.22           N  
ATOM    908  N   GLN   142      -5.829   6.055  29.026  1.00 35.09           N  
ATOM    909  CA  GLN   142      -5.313   6.302  30.408  1.00 34.44           C  
ATOM    910  C   GLN   142      -3.952   6.997  30.332  1.00 33.94           C  
ATOM    911  O   GLN   142      -2.990   6.428  29.822  1.00 33.71           O  
ATOM    912  CB  GLN   142      -5.165   4.993  31.211  1.00 34.70           C  
ATOM    913  CG  GLN   142      -6.405   4.095  31.212  1.00 34.93           C  
ATOM    914  CD  GLN   142      -6.277   2.878  32.097  1.00 35.35           C  
ATOM    915  OE1 GLN   142      -5.995   1.783  31.618  1.00 37.10           O  
ATOM    916  NE2 GLN   142      -6.483   3.062  33.407  1.00 35.35           N  
ATOM    917  N   TYR   143      -3.881   8.225  30.827  1.00 34.02           N  
ATOM    918  CA  TYR   143      -2.631   9.020  30.818  1.00 34.50           C  
ATOM    919  C   TYR   143      -2.240   9.431  32.225  1.00 34.11           C  
ATOM    920  O   TYR   143      -3.114   9.610  33.080  1.00 31.71           O  
ATOM    921  CB  TYR   143      -2.790  10.270  29.944  1.00 34.05           C  
ATOM    922  CG  TYR   143      -3.195   9.923  28.526  1.00 34.61           C  
ATOM    923  CD1 TYR   143      -2.358   9.148  27.710  1.00 34.14           C  
ATOM    924  CD2 TYR   143      -4.393  10.372  27.990  1.00 34.69           C  
ATOM    925  CE1 TYR   143      -2.723   8.821  26.415  1.00 34.01           C  
ATOM    926  CE2 TYR   143      -4.752  10.053  26.693  1.00 34.66           C  
ATOM    927  CZ  TYR   143      -3.917   9.279  25.920  1.00 33.99           C  
ATOM    928  OH  TYR   143      -4.288   8.971  24.642  1.00 34.35           O  
ATOM    929  N   ARG   144      -0.930   9.536  32.463  1.00 33.80           N  
ATOM    930  CA  ARG   144      -0.404   9.988  33.742  1.00 35.60           C  
ATOM    931  C   ARG   144      -0.280  11.510  33.721  1.00 34.05           C  
ATOM    932  O   ARG   144       0.192  12.107  34.681  1.00 33.51           O  
ATOM    933  CB  ARG   144       0.960   9.359  34.046  1.00 36.36           C  
ATOM    934  CG  ARG   144       0.991   7.822  33.954  1.00 38.03           C  
ATOM    935  CD  ARG   144       2.367   7.245  34.238  1.00 39.35           C  
ATOM    936  NE  ARG   144       3.382   8.268  34.007  1.00 41.24           N  
ATOM    937  CZ  ARG   144       4.601   8.071  33.506  1.00 42.86           C  
ATOM    938  NH1 ARG   144       5.012   6.867  33.093  1.00 43.50           N  
ATOM    939  NH2 ARG   144       5.405   9.127  33.377  1.00 42.35           N  
ATOM    940  N   TYR   145      -0.745  12.128  32.635  1.00 34.23           N  
ATOM    941  CA  TYR   145      -0.684  13.578  32.457  1.00 32.95           C  
ATOM    942  C   TYR   145      -2.013  14.174  32.013  1.00 33.09           C  
ATOM    943  O   TYR   145      -2.810  13.522  31.365  1.00 32.37           O  
ATOM    944  CB  TYR   145       0.391  13.878  31.438  1.00 33.59           C  
ATOM    945  CG  TYR   145       1.744  13.420  31.917  1.00 33.35           C  
ATOM    946  CD1 TYR   145       2.172  12.122  31.711  1.00 33.26           C  
ATOM    947  CD2 TYR   145       2.574  14.285  32.608  1.00 33.75           C  
ATOM    948  CE1 TYR   145       3.389  11.697  32.170  1.00 33.34           C  
ATOM    949  CE2 TYR   145       3.791  13.876  33.057  1.00 33.71           C  
ATOM    950  CZ  TYR   145       4.194  12.583  32.837  1.00 33.55           C  
ATOM    951  OH  TYR   145       5.411  12.193  33.306  1.00 34.34           O  
ATOM    952  N   ASP   146      -2.262  15.439  32.332  1.00 34.92           N  
ATOM    953  CA  ASP   146      -3.539  16.038  31.934  1.00 35.59           C  
ATOM    954  C   ASP   146      -3.410  16.548  30.509  1.00 36.12           C  
ATOM    955  O   ASP   146      -3.083  17.710  30.275  1.00 36.73           O  
ATOM    956  CB  ASP   146      -4.019  17.144  32.888  1.00 35.23           C  
ATOM    957  CG  ASP   146      -5.482  17.501  32.657  1.00 35.45           C  
ATOM    958  OD1 ASP   146      -6.054  17.045  31.633  1.00 35.51           O  
ATOM    959  OD2 ASP   146      -6.072  18.196  33.509  1.00 34.99           O  
ATOM    960  N   VAL   147      -3.683  15.652  29.569  1.00 36.09           N  
ATOM    961  CA  VAL   147      -3.580  15.934  28.139  1.00 36.00           C  
ATOM    962  C   VAL   147      -4.681  16.859  27.646  1.00 37.54           C  
ATOM    963  O   VAL   147      -4.578  17.393  26.557  1.00 38.09           O  
ATOM    964  CB  VAL   147      -3.653  14.622  27.297  1.00 35.38           C  
ATOM    965  CG1 VAL   147      -2.531  13.675  27.681  1.00 34.28           C  
ATOM    966  CG2 VAL   147      -5.046  13.949  27.459  1.00 35.03           C  
ATOM    967  N   THR   148      -5.742  17.046  28.430  1.00 40.08           N  
ATOM    968  CA  THR   148      -6.843  17.939  28.035  1.00 40.62           C  
ATOM    969  C   THR   148      -6.586  19.399  28.419  1.00 41.55           C  
ATOM    970  O   THR   148      -7.293  20.309  27.964  1.00 40.82           O  
ATOM    971  CB  THR   148      -8.162  17.553  28.734  1.00 41.38           C  
ATOM    972  OG1 THR   148      -8.043  17.840  30.131  1.00 41.87           O  
ATOM    973  CG2 THR   148      -8.513  16.076  28.536  1.00 40.38           C  
ATOM    974  N   HIS   149      -5.595  19.618  29.276  1.00 42.58           N  
ATOM    975  CA  HIS   149      -5.297  20.956  29.770  1.00 43.38           C  
ATOM    976  C   HIS   149      -3.855  21.343  29.493  1.00 44.04           C  
ATOM    977  O   HIS   149      -3.579  21.904  28.430  1.00 43.03           O  
ATOM    978  CB  HIS   149      -5.634  21.082  31.267  1.00 44.14           C  
ATOM    979  CG  HIS   149      -5.333  22.430  31.836  1.00 44.34           C  
ATOM    980  ND1 HIS   149      -4.211  22.681  32.599  1.00 45.27           N  
ATOM    981  CD2 HIS   149      -5.980  23.614  31.721  1.00 44.87           C  
ATOM    982  CE1 HIS   149      -4.182  23.959  32.938  1.00 44.79           C  
ATOM    983  NE2 HIS   149      -5.249  24.547  32.422  1.00 44.80           N  
ATOM    984  N   ASP   150      -2.930  21.021  30.401  1.00 44.79           N  
ATOM    985  CA  ASP   150      -1.545  21.482  30.234  1.00 45.74           C  
ATOM    986  C   ASP   150      -0.462  20.502  30.737  1.00 45.36           C  
ATOM    987  O   ASP   150       0.588  20.917  31.227  1.00 44.69           O  
ATOM    988  CB  ASP   150      -1.397  22.858  30.890  1.00 46.83           C  
ATOM    989  CG  ASP   150      -0.334  23.714  30.233  1.00 48.68           C  
ATOM    990  OD1 ASP   150       0.428  23.212  29.361  1.00 50.39           O  
ATOM    991  OD2 ASP   150      -0.277  24.916  30.573  1.00 49.33           O  
ATOM    992  N   LEU   151      -0.739  19.209  30.572  1.00 44.73           N  
ATOM    993  CA  LEU   151       0.187  18.114  30.895  1.00 44.03           C  
ATOM    994  C   LEU   151       0.579  18.010  32.352  1.00 43.81           C  
ATOM    995  O   LEU   151       1.716  17.673  32.662  1.00 43.47           O  
ATOM    996  CB  LEU   151       1.441  18.183  30.011  1.00 43.12           C  
ATOM    997  CG  LEU   151       1.178  18.324  28.509  1.00 42.79           C  
ATOM    998  CD1 LEU   151       2.482  18.181  27.706  1.00 41.99           C  
ATOM    999  CD2 LEU   151       0.145  17.316  28.042  1.00 42.24           C  
ATOM   1000  N   GLN   152      -0.378  18.295  33.234  1.00 44.58           N  
ATOM   1001  CA  GLN   152      -0.191  18.162  34.682  1.00 44.48           C  
ATOM   1002  C   GLN   152       0.076  16.686  34.995  1.00 43.53           C  
ATOM   1003  O   GLN   152      -0.577  15.837  34.422  1.00 42.55           O  
ATOM   1004  CB  GLN   152      -1.480  18.582  35.445  1.00 44.70           C  
ATOM   1005  CG  GLN   152      -1.749  20.098  35.662  1.00 45.24           C  
ATOM   1006  CD  GLN   152      -2.106  20.916  34.406  1.00 45.34           C  
ATOM   1007  OE1 GLN   152      -2.549  20.376  33.391  1.00 43.86           O  
ATOM   1008  NE2 GLN   152      -1.931  22.247  34.501  1.00 45.02           N  
ATOM   1009  N   GLU   153       1.051  16.373  35.851  1.00 43.57           N  
ATOM   1010  CA  GLU   153       1.211  14.992  36.314  1.00 43.21           C  
ATOM   1011  C   GLU   153      -0.005  14.717  37.178  1.00 42.36           C  
ATOM   1012  O   GLU   153      -0.084  15.217  38.289  1.00 42.69           O  
ATOM   1013  CB  GLU   153       2.466  14.763  37.150  1.00 43.26           C  
ATOM   1014  CG  GLU   153       3.628  14.244  36.395  1.00 44.27           C  
ATOM   1015  CD  GLU   153       4.799  13.889  37.298  1.00 45.15           C  
ATOM   1016  OE1 GLU   153       5.089  14.665  38.243  1.00 46.26           O  
ATOM   1017  OE2 GLU   153       5.453  12.849  37.043  1.00 46.21           O  
ATOM   1018  N   ALA   154      -0.938  13.936  36.642  1.00 41.00           N  
ATOM   1019  CA  ALA   154      -2.180  13.601  37.311  1.00 40.63           C  
ATOM   1020  C   ALA   154      -2.851  12.510  36.492  1.00 39.98           C  
ATOM   1021  O   ALA   154      -3.087  12.710  35.296  1.00 40.14           O  
ATOM   1022  CB  ALA   154      -3.083  14.827  37.394  1.00 40.73           C  
ATOM   1023  N   GLU   155      -3.118  11.358  37.113  1.00 39.02           N  
ATOM   1024  CA  GLU   155      -3.806  10.248  36.442  1.00 38.44           C  
ATOM   1025  C   GLU   155      -5.091  10.729  35.778  1.00 38.05           C  
ATOM   1026  O   GLU   155      -6.012  11.181  36.454  1.00 36.52           O  
ATOM   1027  CB  GLU   155      -4.125   9.092  37.413  1.00 38.51           C  
ATOM   1028  CG  GLU   155      -2.928   8.203  37.826  1.00 39.18           C  
ATOM   1029  CD  GLU   155      -2.304   7.406  36.667  1.00 39.11           C  
ATOM   1030  OE1 GLU   155      -2.806   7.502  35.528  1.00 39.80           O  
ATOM   1031  OE2 GLU   155      -1.309   6.676  36.900  1.00 39.33           O  
ATOM   1032  N   THR   156      -5.150  10.605  34.450  1.00 38.58           N  
ATOM   1033  CA  THR   156      -6.315  11.049  33.668  1.00 39.32           C  
ATOM   1034  C   THR   156      -6.908   9.901  32.842  1.00 38.56           C  
ATOM   1035  O   THR   156      -6.191   9.175  32.177  1.00 38.94           O  
ATOM   1036  CB  THR   156      -5.961  12.238  32.748  1.00 39.69           C  
ATOM   1037  OG1 THR   156      -5.110  13.151  33.460  1.00 39.65           O  
ATOM   1038  CG2 THR   156      -7.238  12.951  32.288  1.00 38.88           C  
ATOM   1039  N   ALA   157      -8.228   9.758  32.907  1.00 38.33           N  
ATOM   1040  CA  ALA   157      -8.964   8.679  32.254  1.00 38.48           C  
ATOM   1041  C   ALA   157     -10.000   9.322  31.326  1.00 38.25           C  
ATOM   1042  O   ALA   157     -10.901  10.005  31.789  1.00 38.07           O  
ATOM   1043  CB  ALA   157      -9.649   7.780  33.328  1.00 37.18           C  
ATOM   1044  N   LEU   158      -9.871   9.098  30.019  1.00 38.80           N  
ATOM   1045  CA  LEU   158     -10.745   9.736  29.012  1.00 38.15           C  
ATOM   1046  C   LEU   158     -11.397   8.749  28.057  1.00 38.07           C  
ATOM   1047  O   LEU   158     -10.844   7.676  27.783  1.00 37.00           O  
ATOM   1048  CB  LEU   158      -9.907  10.718  28.177  1.00 37.77           C  
ATOM   1049  CG  LEU   158      -9.233  11.893  28.915  1.00 38.21           C  
ATOM   1050  CD1 LEU   158      -8.066  12.510  28.104  1.00 36.98           C  
ATOM   1051  CD2 LEU   158     -10.248  12.946  29.326  1.00 36.74           C  
ATOM   1052  N   LEU   159     -12.573   9.125  27.553  1.00 38.32           N  
ATOM   1053  CA  LEU   159     -13.288   8.364  26.494  1.00 37.73           C  
ATOM   1054  C   LEU   159     -13.305   9.288  25.310  1.00 37.07           C  
ATOM   1055  O   LEU   159     -13.845  10.410  25.428  1.00 37.83           O  
ATOM   1056  CB  LEU   159     -14.742   8.037  26.854  1.00 37.83           C  
ATOM   1057  CG  LEU   159     -15.545   7.301  25.775  1.00 38.57           C  
ATOM   1058  CD1 LEU   159     -14.891   5.919  25.489  1.00 38.98           C  
ATOM   1059  CD2 LEU   159     -17.048   7.119  26.134  1.00 37.71           C  
ATOM   1060  N   ILE   160     -12.697   8.869  24.198  1.00 35.82           N  
ATOM   1061  CA  ILE   160     -12.689   9.678  22.962  1.00 35.81           C  
ATOM   1062  C   ILE   160     -13.626   8.993  21.964  1.00 35.30           C  
ATOM   1063  O   ILE   160     -13.571   7.751  21.790  1.00 32.61           O  
ATOM   1064  CB  ILE   160     -11.259   9.822  22.346  1.00 35.67           C  
ATOM   1065  CG1 ILE   160     -10.329  10.615  23.269  1.00 36.38           C  
ATOM   1066  CG2 ILE   160     -11.341  10.519  21.005  1.00 36.24           C  
ATOM   1067  CD1 ILE   160      -9.693   9.814  24.356  1.00 35.92           C  
ATOM   1068  N   TRP   161     -14.533   9.753  21.358  1.00 34.16           N  
ATOM   1069  CA  TRP   161     -15.456   9.155  20.384  1.00 35.62           C  
ATOM   1070  C   TRP   161     -15.980  10.135  19.343  1.00 36.26           C  
ATOM   1071  O   TRP   161     -15.693  11.326  19.429  1.00 35.77           O  
ATOM   1072  CB  TRP   161     -16.644   8.522  21.109  1.00 37.38           C  
ATOM   1073  CG  TRP   161     -17.718   9.455  21.577  1.00 37.18           C  
ATOM   1074  CD1 TRP   161     -18.903   9.685  20.966  1.00 37.71           C  
ATOM   1075  CD2 TRP   161     -17.728  10.237  22.773  1.00 37.19           C  
ATOM   1076  NE1 TRP   161     -19.642  10.576  21.678  1.00 37.89           N  
ATOM   1077  CE2 TRP   161     -18.945  10.934  22.798  1.00 38.42           C  
ATOM   1078  CE3 TRP   161     -16.816  10.435  23.808  1.00 37.18           C  
ATOM   1079  CZ2 TRP   161     -19.276  11.835  23.813  1.00 38.40           C  
ATOM   1080  CZ3 TRP   161     -17.142  11.285  24.818  1.00 37.74           C  
ATOM   1081  CH2 TRP   161     -18.369  11.986  24.824  1.00 38.15           C  
ATOM   1082  N   ARG   162     -16.759   9.632  18.381  1.00 36.30           N  
ATOM   1083  CA  ARG   162     -17.405  10.495  17.383  1.00 36.65           C  
ATOM   1084  C   ARG   162     -18.910  10.371  17.580  1.00 36.51           C  
ATOM   1085  O   ARG   162     -19.440   9.263  17.606  1.00 35.78           O  
ATOM   1086  CB  ARG   162     -17.036  10.123  15.944  1.00 36.17           C  
ATOM   1087  CG  ARG   162     -17.505  11.169  14.969  1.00 36.54           C  
ATOM   1088  CD  ARG   162     -16.821  11.107  13.626  1.00 36.00           C  
ATOM   1089  NE  ARG   162     -17.436  10.134  12.715  1.00 35.70           N  
ATOM   1090  CZ  ARG   162     -17.007   8.899  12.463  1.00 35.72           C  
ATOM   1091  NH1 ARG   162     -15.925   8.408  13.036  1.00 36.11           N  
ATOM   1092  NH2 ARG   162     -17.668   8.156  11.588  1.00 35.62           N  
ATOM   1093  N   ASN   163     -19.597  11.505  17.694  1.00 37.07           N  
ATOM   1094  CA  ASN   163     -21.015  11.459  18.004  1.00 38.11           C  
ATOM   1095  C   ASN   163     -21.908  11.453  16.780  1.00 39.76           C  
ATOM   1096  O   ASN   163     -21.410  11.428  15.668  1.00 40.47           O  
ATOM   1097  CB  ASN   163     -21.359  12.566  18.979  1.00 37.72           C  
ATOM   1098  CG  ASN   163     -21.269  13.932  18.358  1.00 37.22           C  
ATOM   1099  OD1 ASN   163     -21.160  14.070  17.146  1.00 38.13           O  
ATOM   1100  ND2 ASN   163     -21.356  14.949  19.185  1.00 37.50           N  
ATOM   1101  N   ALA   164     -23.226  11.443  16.989  1.00 41.32           N  
ATOM   1102  CA  ALA   164     -24.203  11.411  15.897  1.00 41.49           C  
ATOM   1103  C   ALA   164     -24.046  12.531  14.871  1.00 42.17           C  
ATOM   1104  O   ALA   164     -24.417  12.345  13.715  1.00 41.92           O  
ATOM   1105  CB  ALA   164     -25.641  11.401  16.471  1.00 42.29           C  
ATOM   1106  N   GLU   165     -23.515  13.682  15.289  1.00 42.49           N  
ATOM   1107  CA  GLU   165     -23.253  14.805  14.375  1.00 43.04           C  
ATOM   1108  C   GLU   165     -21.858  14.735  13.715  1.00 42.42           C  
ATOM   1109  O   GLU   165     -21.395  15.723  13.153  1.00 40.99           O  
ATOM   1110  CB  GLU   165     -23.353  16.131  15.123  1.00 43.93           C  
ATOM   1111  CG  GLU   165     -24.748  16.511  15.540  1.00 45.40           C  
ATOM   1112  CD  GLU   165     -24.763  17.805  16.346  1.00 46.25           C  
ATOM   1113  OE1 GLU   165     -24.250  17.781  17.504  1.00 47.45           O  
ATOM   1114  OE2 GLU   165     -25.300  18.828  15.826  1.00 47.05           O  
ATOM   1115  N   ASP   166     -21.201  13.579  13.808  1.00 40.89           N  
ATOM   1116  CA  ASP   166     -19.862  13.355  13.259  1.00 41.15           C  
ATOM   1117  C   ASP   166     -18.775  14.319  13.804  1.00 40.03           C  
ATOM   1118  O   ASP   166     -17.812  14.628  13.100  1.00 38.42           O  
ATOM   1119  CB  ASP   166     -19.876  13.307  11.704  1.00 41.47           C  
ATOM   1120  CG  ASP   166     -20.427  11.982  11.143  1.00 41.09           C  
ATOM   1121  OD1 ASP   166     -20.142  10.911  11.701  1.00 40.80           O  
ATOM   1122  OD2 ASP   166     -21.117  12.003  10.101  1.00 41.82           O  
ATOM   1123  N   ASP   167     -18.934  14.767  15.057  1.00 40.27           N  
ATOM   1124  CA  ASP   167     -17.931  15.619  15.742  1.00 40.57           C  
ATOM   1125  C   ASP   167     -17.164  14.774  16.756  1.00 39.01           C  
ATOM   1126  O   ASP   167     -17.783  13.962  17.449  1.00 39.31           O  
ATOM   1127  CB  ASP   167     -18.599  16.781  16.492  1.00 41.60           C  
ATOM   1128  CG  ASP   167     -19.185  17.828  15.566  1.00 42.34           C  
ATOM   1129  OD1 ASP   167     -18.468  18.360  14.701  1.00 43.82           O  
ATOM   1130  OD2 ASP   167     -20.363  18.165  15.743  1.00 44.30           O  
ATOM   1131  N   VAL   168     -15.838  14.958  16.829  1.00 36.76           N  
ATOM   1132  CA  VAL   168     -15.006  14.240  17.789  1.00 35.36           C  
ATOM   1133  C   VAL   168     -15.226  14.869  19.171  1.00 35.50           C  
ATOM   1134  O   VAL   168     -15.207  16.106  19.342  1.00 32.60           O  
ATOM   1135  CB  VAL   168     -13.510  14.245  17.431  1.00 35.37           C  
ATOM   1136  CG1 VAL   168     -12.719  13.431  18.436  1.00 35.65           C  
ATOM   1137  CG2 VAL   168     -13.292  13.682  16.052  1.00 35.05           C  
ATOM   1138  N   MET   169     -15.476  14.008  20.146  1.00 33.94           N  
ATOM   1139  CA  MET   169     -15.734  14.428  21.512  1.00 33.79           C  
ATOM   1140  C   MET   169     -14.858  13.600  22.453  1.00 34.81           C  
ATOM   1141  O   MET   169     -14.458  12.471  22.130  1.00 30.90           O  
ATOM   1142  CB  MET   169     -17.201  14.148  21.890  1.00 34.13           C  
ATOM   1143  CG  MET   169     -18.291  14.595  20.964  1.00 33.48           C  
ATOM   1144  SD  MET   169     -18.437  16.527  20.858  0.75 37.47          SE  
ATOM   1145  CE  MET   169     -19.112  16.847  22.681  1.00 31.68           C  
ATOM   1146  N   TYR   170     -14.569  14.167  23.618  1.00 35.79           N  
ATOM   1147  CA  TYR   170     -13.835  13.455  24.636  1.00 36.09           C  
ATOM   1148  C   TYR   170     -14.502  13.833  25.959  1.00 37.22           C  
ATOM   1149  O   TYR   170     -15.080  14.917  26.071  1.00 34.89           O  
ATOM   1150  CB  TYR   170     -12.317  13.783  24.601  1.00 36.65           C  
ATOM   1151  CG  TYR   170     -11.885  15.201  24.997  1.00 37.32           C  
ATOM   1152  CD1 TYR   170     -11.850  15.587  26.339  1.00 38.17           C  
ATOM   1153  CD2 TYR   170     -11.444  16.128  24.041  1.00 36.93           C  
ATOM   1154  CE1 TYR   170     -11.448  16.895  26.731  1.00 36.83           C  
ATOM   1155  CE2 TYR   170     -11.027  17.440  24.427  1.00 37.45           C  
ATOM   1156  CZ  TYR   170     -11.037  17.798  25.777  1.00 37.46           C  
ATOM   1157  OH  TYR   170     -10.647  19.065  26.197  1.00 37.82           O  
ATOM   1158  N   GLN   171     -14.427  12.950  26.952  1.00 36.97           N  
ATOM   1159  CA  GLN   171     -14.931  13.264  28.302  1.00 38.53           C  
ATOM   1160  C   GLN   171     -14.247  12.413  29.334  1.00 36.99           C  
ATOM   1161  O   GLN   171     -13.814  11.296  29.038  1.00 37.34           O  
ATOM   1162  CB  GLN   171     -16.450  13.039  28.429  1.00 39.94           C  
ATOM   1163  CG  GLN   171     -16.874  11.573  28.480  1.00 41.08           C  
ATOM   1164  CD  GLN   171     -18.399  11.383  28.609  1.00 42.57           C  
ATOM   1165  OE1 GLN   171     -19.202  12.314  28.348  1.00 45.34           O  
ATOM   1166  NE2 GLN   171     -18.801  10.179  29.008  1.00 44.67           N  
ATOM   1167  N   THR   172     -14.187  12.906  30.567  1.00 35.94           N  
ATOM   1168  CA  THR   172     -13.585  12.134  31.649  0.50 35.77           C  
ATOM   1170  C   THR   172     -14.403  10.853  31.826  1.00 35.48           C  
ATOM   1171  O   THR   172     -15.610  10.851  31.681  1.00 34.08           O  
ATOM   1172  CB  THR   172     -13.508  12.937  32.961  0.50 35.97           C  
ATOM   1174  OG1 THR   172     -14.832  13.263  33.407  0.50 36.62           O  
ATOM   1176  CG2 THR   172     -12.703  14.212  32.757  0.50 35.21           C  
ATOM   1178  N   LEU   173     -13.723   9.749  32.094  1.00 37.16           N  
ATOM   1179  CA  LEU   173     -14.361   8.480  32.248  1.00 38.77           C  
ATOM   1180  C   LEU   173     -14.133   8.031  33.687  1.00 41.89           C  
ATOM   1181  O   LEU   173     -12.973   7.958  34.150  1.00 42.80           O  
ATOM   1182  CB  LEU   173     -13.715   7.490  31.288  1.00 38.76           C  
ATOM   1183  CG  LEU   173     -14.480   6.251  30.833  1.00 38.66           C  
ATOM   1184  CD1 LEU   173     -15.783   6.646  30.191  1.00 36.48           C  
ATOM   1185  CD2 LEU   173     -13.607   5.482  29.866  1.00 37.79           C  
ATOM   1186  N   ASP   174     -15.226   7.774  34.412  1.00 43.53           N  
ATOM   1187  CA  ASP   174     -15.114   7.254  35.771  1.00 44.88           C  
ATOM   1188  C   ASP   174     -14.975   5.716  35.690  1.00 44.13           C  
ATOM   1189  O   ASP   174     -15.195   5.120  34.639  1.00 42.26           O  
ATOM   1190  CB  ASP   174     -16.253   7.760  36.706  1.00 45.97           C  
ATOM   1191  CG  ASP   174     -17.658   7.312  36.286  1.00 46.82           C  
ATOM   1192  OD1 ASP   174     -17.829   6.394  35.462  1.00 48.80           O  
ATOM   1193  OD2 ASP   174     -18.629   7.886  36.815  1.00 47.87           O  
ATOM   1194  N   GLY   175     -14.578   5.100  36.798  1.00 45.15           N  
ATOM   1195  CA  GLY   175     -14.337   3.644  36.858  1.00 46.19           C  
ATOM   1196  C   GLY   175     -15.469   2.691  36.490  1.00 46.07           C  
ATOM   1197  O   GLY   175     -15.213   1.631  35.921  1.00 44.48           O  
ATOM   1198  N   PHE   176     -16.705   3.029  36.858  1.00 47.77           N  
ATOM   1199  CA  PHE   176     -17.872   2.181  36.511  1.00 48.38           C  
ATOM   1200  C   PHE   176     -18.038   2.124  34.998  1.00 46.08           C  
ATOM   1201  O   PHE   176     -18.206   1.055  34.422  1.00 44.30           O  
ATOM   1202  CB  PHE   176     -19.184   2.741  37.104  1.00 50.64           C  
ATOM   1203  CG  PHE   176     -20.358   1.787  36.991  1.00 50.93           C  
ATOM   1204  CD1 PHE   176     -21.063   1.663  35.793  1.00 51.81           C  
ATOM   1205  CD2 PHE   176     -20.744   1.003  38.074  1.00 51.75           C  
ATOM   1206  CE1 PHE   176     -22.127   0.782  35.684  1.00 52.34           C  
ATOM   1207  CE2 PHE   176     -21.813   0.120  37.978  1.00 51.91           C  
ATOM   1208  CZ  PHE   176     -22.501   0.006  36.786  1.00 52.07           C  
ATOM   1209  N   ASP   177     -18.030   3.316  34.402  1.00 43.78           N  
ATOM   1210  CA  ASP   177     -18.138   3.506  32.961  1.00 42.31           C  
ATOM   1211  C   ASP   177     -17.038   2.803  32.187  1.00 40.47           C  
ATOM   1212  O   ASP   177     -17.315   2.124  31.183  1.00 38.92           O  
ATOM   1213  CB  ASP   177     -18.098   5.006  32.652  1.00 42.66           C  
ATOM   1214  CG  ASP   177     -19.338   5.708  33.107  1.00 43.24           C  
ATOM   1215  OD1 ASP   177     -20.192   5.039  33.727  1.00 43.85           O  
ATOM   1216  OD2 ASP   177     -19.479   6.910  32.810  1.00 42.81           O  
ATOM   1217  N   MET   178     -15.798   2.949  32.656  1.00 39.39           N  
ATOM   1218  CA  MET   178     -14.663   2.298  32.000  1.00 40.64           C  
ATOM   1219  C   MET   178     -14.869   0.766  31.995  1.00 40.74           C  
ATOM   1220  O   MET   178     -14.648   0.085  30.975  1.00 41.40           O  
ATOM   1221  CB  MET   178     -13.345   2.681  32.690  1.00 40.52           C  
ATOM   1222  CG  MET   178     -12.078   2.251  31.974  1.00 41.29           C  
ATOM   1223  SD  MET   178     -10.453   2.665  33.068  0.75 42.72          SE  
ATOM   1224  CE  MET   178     -10.429   4.544  32.789  1.00 41.52           C  
ATOM   1225  N   MET   179     -15.315   0.256  33.124  1.00 41.35           N  
ATOM   1226  CA  MET   179     -15.556  -1.178  33.300  1.00 43.56           C  
ATOM   1227  C   MET   179     -16.640  -1.689  32.352  1.00 41.60           C  
ATOM   1228  O   MET   179     -16.456  -2.675  31.679  1.00 41.85           O  
ATOM   1229  CB  MET   179     -15.942  -1.460  34.764  1.00 44.08           C  
ATOM   1230  CG  MET   179     -16.440  -2.879  35.053  1.00 45.36           C  
ATOM   1231  SD  MET   179     -16.813  -3.096  36.947  0.75 47.94          SE  
ATOM   1232  CE  MET   179     -14.922  -3.086  37.444  1.00 47.55           C  
ATOM   1233  N   LEU   180     -17.770  -1.002  32.329  1.00 41.88           N  
ATOM   1234  CA  LEU   180     -18.876  -1.351  31.456  1.00 41.24           C  
ATOM   1235  C   LEU   180     -18.467  -1.298  29.978  1.00 41.06           C  
ATOM   1236  O   LEU   180     -18.760  -2.229  29.222  1.00 41.65           O  
ATOM   1237  CB  LEU   180     -20.062  -0.411  31.683  1.00 42.02           C  
ATOM   1238  CG  LEU   180     -21.271  -0.875  30.862  1.00 42.92           C  
ATOM   1239  CD1 LEU   180     -21.695  -2.288  31.332  1.00 42.64           C  
ATOM   1240  CD2 LEU   180     -22.429   0.094  30.902  1.00 41.63           C  
ATOM   1241  N   LEU   181     -17.805  -0.223  29.543  1.00 39.70           N  
ATOM   1242  CA  LEU   181     -17.411  -0.135  28.130  1.00 38.32           C  
ATOM   1243  C   LEU   181     -16.451  -1.246  27.773  1.00 38.31           C  
ATOM   1244  O   LEU   181     -16.532  -1.782  26.686  1.00 36.05           O  
ATOM   1245  CB  LEU   181     -16.762   1.183  27.782  1.00 38.28           C  
ATOM   1246  CG  LEU   181     -17.665   2.399  27.911  1.00 36.54           C  
ATOM   1247  CD1 LEU   181     -16.873   3.622  27.735  1.00 37.18           C  
ATOM   1248  CD2 LEU   181     -18.810   2.275  26.897  1.00 36.99           C  
ATOM   1249  N   GLU   182     -15.512  -1.535  28.669  1.00 38.51           N  
ATOM   1250  CA  GLU   182     -14.522  -2.609  28.446  1.00 40.12           C  
ATOM   1251  C   GLU   182     -15.173  -3.999  28.354  1.00 38.77           C  
ATOM   1252  O   GLU   182     -14.787  -4.833  27.514  1.00 41.22           O  
ATOM   1253  CB  GLU   182     -13.507  -2.634  29.591  1.00 41.80           C  
ATOM   1254  CG  GLU   182     -12.290  -3.511  29.311  1.00 42.74           C  
ATOM   1255  CD  GLU   182     -11.361  -2.891  28.303  1.00 43.71           C  
ATOM   1256  OE1 GLU   182     -11.405  -1.639  28.138  1.00 44.55           O  
ATOM   1257  OE2 GLU   182     -10.564  -3.644  27.703  1.00 44.05           O  
ATOM   1258  N   ILE   183     -16.106  -4.252  29.273  1.00 37.91           N  
ATOM   1259  CA  ILE   183     -16.902  -5.493  29.336  1.00 37.16           C  
ATOM   1260  C   ILE   183     -17.745  -5.546  28.049  1.00 36.31           C  
ATOM   1261  O   ILE   183     -17.742  -6.521  27.329  1.00 35.36           O  
ATOM   1262  CB  ILE   183     -17.828  -5.442  30.587  1.00 37.12           C  
ATOM   1263  CG1 ILE   183     -17.063  -5.750  31.869  1.00 36.95           C  
ATOM   1264  CG2 ILE   183     -19.031  -6.343  30.458  1.00 38.23           C  
ATOM   1265  CD1 ILE   183     -17.942  -5.655  33.137  1.00 37.12           C  
ATOM   1266  N   MET   184     -18.440  -4.454  27.744  1.00 35.71           N  
ATOM   1267  CA  MET   184     -19.238  -4.380  26.526  1.00 34.96           C  
ATOM   1268  C   MET   184     -18.418  -4.586  25.249  1.00 35.85           C  
ATOM   1269  O   MET   184     -18.939  -5.122  24.265  1.00 36.27           O  
ATOM   1270  CB  MET   184     -20.033  -3.085  26.446  1.00 33.23           C  
ATOM   1271  CG  MET   184     -21.222  -3.019  27.395  1.00 31.28           C  
ATOM   1272  SD  MET   184     -22.000  -1.323  27.109  0.75 33.38          SE  
ATOM   1273  CE  MET   184     -22.939  -1.763  25.378  1.00 31.32           C  
ATOM   1274  N   GLY   185     -17.148  -4.197  25.274  1.00 34.94           N  
ATOM   1275  CA  GLY   185     -16.274  -4.433  24.146  1.00 35.89           C  
ATOM   1276  C   GLY   185     -15.982  -5.923  24.017  1.00 37.67           C  
ATOM   1277  O   GLY   185     -15.725  -6.435  22.910  1.00 38.56           O  
ATOM   1278  N   SER   186     -16.026  -6.632  25.144  1.00 38.48           N  
ATOM   1279  CA  SER   186     -15.778  -8.080  25.147  1.00 39.76           C  
ATOM   1280  C   SER   186     -16.968  -8.860  24.587  1.00 40.37           C  
ATOM   1281  O   SER   186     -16.806  -9.865  23.877  1.00 40.00           O  
ATOM   1282  CB  SER   186     -15.495  -8.592  26.570  1.00 39.79           C  
ATOM   1283  OG  SER   186     -14.333  -8.012  27.134  1.00 39.83           O  
ATOM   1284  N   SER   187     -18.167  -8.445  24.965  1.00 40.53           N  
ATOM   1285  CA  SER   187     -19.350  -9.129  24.488  1.00 41.39           C  
ATOM   1286  C   SER   187     -20.579  -8.234  24.546  1.00 40.22           C  
ATOM   1287  O   SER   187     -20.978  -7.820  25.624  1.00 40.70           O  
ATOM   1288  CB  SER   187     -19.578 -10.406  25.298  1.00 42.49           C  
ATOM   1289  OG  SER   187     -19.582 -10.126  26.684  1.00 44.00           O  
ATOM   1290  N   ALA   188     -21.157  -7.973  23.372  1.00 38.68           N  
ATOM   1291  CA  ALA   188     -22.369  -7.193  23.207  1.00 38.36           C  
ATOM   1292  C   ALA   188     -23.358  -7.535  24.313  1.00 37.68           C  
ATOM   1293  O   ALA   188     -23.562  -8.701  24.646  1.00 39.44           O  
ATOM   1294  CB  ALA   188     -22.978  -7.454  21.840  1.00 36.97           C  
ATOM   1295  N   LEU   189     -23.989  -6.506  24.834  1.00 37.15           N  
ATOM   1296  CA  LEU   189     -24.850  -6.570  26.003  1.00 38.47           C  
ATOM   1297  C   LEU   189     -26.162  -5.759  25.830  1.00 37.16           C  
ATOM   1298  O   LEU   189     -26.156  -4.703  25.248  1.00 37.13           O  
ATOM   1299  CB  LEU   189     -24.006  -5.922  27.127  1.00 38.77           C  
ATOM   1300  CG  LEU   189     -24.536  -5.584  28.514  1.00 40.39           C  
ATOM   1301  CD1 LEU   189     -24.419  -6.807  29.417  1.00 41.44           C  
ATOM   1302  CD2 LEU   189     -23.760  -4.419  29.132  1.00 40.31           C  
ATOM   1303  N   SER   190     -27.282  -6.254  26.331  1.00 37.95           N  
ATOM   1304  CA  SER   190     -28.518  -5.453  26.348  1.00 37.69           C  
ATOM   1305  C   SER   190     -28.605  -4.730  27.687  1.00 36.73           C  
ATOM   1306  O   SER   190     -27.894  -5.081  28.625  1.00 33.55           O  
ATOM   1307  CB  SER   190     -29.771  -6.342  26.171  1.00 37.26           C  
ATOM   1308  OG  SER   190     -30.007  -7.182  27.293  1.00 35.50           O  
ATOM   1309  N   PHE   191     -29.451  -3.695  27.775  1.00 38.21           N  
ATOM   1310  CA  PHE   191     -29.691  -3.038  29.055  1.00 36.68           C  
ATOM   1311  C   PHE   191     -30.306  -4.054  30.014  1.00 36.63           C  
ATOM   1312  O   PHE   191     -29.943  -4.074  31.177  1.00 36.15           O  
ATOM   1313  CB  PHE   191     -30.633  -1.846  28.929  1.00 37.61           C  
ATOM   1314  CG  PHE   191     -30.909  -1.152  30.230  1.00 37.73           C  
ATOM   1315  CD1 PHE   191     -29.970  -0.294  30.788  1.00 38.70           C  
ATOM   1316  CD2 PHE   191     -32.107  -1.347  30.903  1.00 38.74           C  
ATOM   1317  CE1 PHE   191     -30.217   0.351  31.989  1.00 37.92           C  
ATOM   1318  CE2 PHE   191     -32.360  -0.703  32.102  1.00 37.90           C  
ATOM   1319  CZ  PHE   191     -31.407   0.148  32.643  1.00 38.10           C  
ATOM   1320  N   ASP   192     -31.220  -4.911  29.537  1.00 36.19           N  
ATOM   1321  CA  ASP   192     -31.854  -5.864  30.429  1.00 35.73           C  
ATOM   1322  C   ASP   192     -30.837  -6.798  31.035  1.00 34.04           C  
ATOM   1323  O   ASP   192     -30.936  -7.099  32.218  1.00 31.85           O  
ATOM   1324  CB  ASP   192     -32.991  -6.668  29.769  1.00 36.97           C  
ATOM   1325  CG  ASP   192     -34.241  -5.818  29.511  1.00 37.83           C  
ATOM   1326  OD1 ASP   192     -34.239  -4.589  29.827  1.00 36.14           O  
ATOM   1327  OD2 ASP   192     -35.215  -6.396  28.968  1.00 37.83           O  
ATOM   1328  N   THR   193     -29.882  -7.251  30.228  1.00 33.57           N  
ATOM   1329  CA  THR   193     -28.784  -8.108  30.701  1.00 33.05           C  
ATOM   1330  C   THR   193     -27.885  -7.293  31.674  1.00 33.22           C  
ATOM   1331  O   THR   193     -27.553  -7.752  32.763  1.00 32.46           O  
ATOM   1332  CB  THR   193     -27.951  -8.657  29.516  1.00 33.39           C  
ATOM   1333  OG1 THR   193     -28.748  -9.558  28.714  1.00 32.30           O  
ATOM   1334  CG2 THR   193     -26.703  -9.397  29.999  1.00 32.95           C  
ATOM   1335  N   LEU   194     -27.530  -6.061  31.321  1.00 33.14           N  
ATOM   1336  CA  LEU   194     -26.707  -5.264  32.232  1.00 32.74           C  
ATOM   1337  C   LEU   194     -27.412  -5.148  33.579  1.00 34.32           C  
ATOM   1338  O   LEU   194     -26.905  -5.610  34.606  1.00 34.58           O  
ATOM   1339  CB  LEU   194     -26.451  -3.866  31.655  1.00 33.10           C  
ATOM   1340  CG  LEU   194     -25.699  -2.841  32.508  1.00 32.84           C  
ATOM   1341  CD1 LEU   194     -24.341  -3.367  32.928  1.00 32.94           C  
ATOM   1342  CD2 LEU   194     -25.598  -1.508  31.737  1.00 32.98           C  
ATOM   1343  N   ALA   195     -28.597  -4.546  33.576  1.00 35.92           N  
ATOM   1344  CA  ALA   195     -29.320  -4.299  34.825  1.00 37.64           C  
ATOM   1345  C   ALA   195     -29.554  -5.561  35.667  1.00 37.88           C  
ATOM   1346  O   ALA   195     -29.464  -5.514  36.880  1.00 40.48           O  
ATOM   1347  CB  ALA   195     -30.639  -3.534  34.551  1.00 36.84           C  
ATOM   1348  N   GLN   196     -29.800  -6.697  35.042  1.00 39.20           N  
ATOM   1349  CA  GLN   196     -30.019  -7.934  35.786  1.00 39.69           C  
ATOM   1350  C   GLN   196     -28.737  -8.493  36.437  1.00 40.33           C  
ATOM   1351  O   GLN   196     -28.802  -9.184  37.470  1.00 41.04           O  
ATOM   1352  CB  GLN   196     -30.624  -9.008  34.858  1.00 40.42           C  
ATOM   1353  CG  GLN   196     -30.778 -10.420  35.472  1.00 40.58           C  
ATOM   1354  CD  GLN   196     -31.645 -10.452  36.735  1.00 41.73           C  
ATOM   1355  OE1 GLN   196     -32.548  -9.633  36.907  1.00 43.88           O  
ATOM   1356  NE2 GLN   196     -31.391 -11.423  37.606  1.00 41.67           N  
ATOM   1357  N   THR   197     -27.588  -8.255  35.810  1.00 38.92           N  
ATOM   1358  CA  THR   197     -26.328  -8.785  36.321  1.00 37.94           C  
ATOM   1359  C   THR   197     -25.937  -8.023  37.571  1.00 36.70           C  
ATOM   1360  O   THR   197     -25.409  -8.630  38.485  1.00 35.53           O  
ATOM   1361  CB  THR   197     -25.192  -8.642  35.280  1.00 39.04           C  
ATOM   1362  OG1 THR   197     -25.568  -9.302  34.071  1.00 39.48           O  
ATOM   1363  CG2 THR   197     -23.883  -9.235  35.804  1.00 39.19           C  
ATOM   1364  N   LEU   198     -26.194  -6.700  37.581  1.00 33.17           N  
ATOM   1365  CA  LEU   198     -25.887  -5.832  38.711  1.00 33.38           C  
ATOM   1366  C   LEU   198     -26.846  -5.943  39.894  1.00 34.22           C  
ATOM   1367  O   LEU   198     -26.519  -5.510  41.000  1.00 33.03           O  
ATOM   1368  CB  LEU   198     -25.853  -4.354  38.276  1.00 32.60           C  
ATOM   1369  CG  LEU   198     -24.821  -3.832  37.292  1.00 32.72           C  
ATOM   1370  CD1 LEU   198     -25.148  -2.360  36.810  1.00 29.29           C  
ATOM   1371  CD2 LEU   198     -23.429  -3.896  37.907  1.00 33.12           C  
ATOM   1372  N   VAL   199     -28.022  -6.522  39.683  1.00 36.58           N  
ATOM   1373  CA  VAL   199     -29.008  -6.681  40.750  1.00 37.54           C  
ATOM   1374  C   VAL   199     -28.443  -7.249  42.050  1.00 39.42           C  
ATOM   1375  O   VAL   199     -28.828  -6.816  43.151  1.00 39.34           O  
ATOM   1376  CB  VAL   199     -30.224  -7.544  40.276  1.00 36.98           C  
ATOM   1377  CG1 VAL   199     -30.957  -8.122  41.434  1.00 35.71           C  
ATOM   1378  CG2 VAL   199     -31.155  -6.689  39.401  1.00 36.23           C  
ATOM   1379  N   GLU   200     -27.521  -8.200  41.945  1.00 41.22           N  
ATOM   1380  CA  GLU   200     -26.982  -8.823  43.150  1.00 42.00           C  
ATOM   1381  C   GLU   200     -25.916  -7.994  43.879  1.00 41.83           C  
ATOM   1382  O   GLU   200     -25.615  -8.261  45.037  1.00 42.68           O  
ATOM   1383  CB  GLU   200     -26.468 -10.245  42.873  1.00 42.76           C  
ATOM   1384  CG  GLU   200     -25.208 -10.396  42.009  1.00 42.85           C  
ATOM   1385  CD  GLU   200     -24.499 -11.743  42.272  1.00 43.32           C  
ATOM   1386  OE1 GLU   200     -24.374 -12.129  43.462  1.00 44.06           O  
ATOM   1387  OE2 GLU   200     -24.040 -12.401  41.308  1.00 43.24           O  
ATOM   1388  N   PHE   201     -25.351  -6.989  43.227  1.00 41.69           N  
ATOM   1389  CA  PHE   201     -24.333  -6.163  43.858  1.00 41.84           C  
ATOM   1390  C   PHE   201     -24.857  -4.766  44.149  1.00 41.15           C  
ATOM   1391  O   PHE   201     -24.074  -3.818  44.199  1.00 41.58           O  
ATOM   1392  CB  PHE   201     -23.119  -6.041  42.935  1.00 42.85           C  
ATOM   1393  CG  PHE   201     -22.711  -7.325  42.327  1.00 43.28           C  
ATOM   1394  CD1 PHE   201     -22.106  -8.313  43.106  1.00 43.38           C  
ATOM   1395  CD2 PHE   201     -22.944  -7.568  40.980  1.00 43.18           C  
ATOM   1396  CE1 PHE   201     -21.736  -9.526  42.544  1.00 43.77           C  
ATOM   1397  CE2 PHE   201     -22.571  -8.775  40.405  1.00 43.77           C  
ATOM   1398  CZ  PHE   201     -21.972  -9.757  41.185  1.00 43.34           C  
ATOM   1399  N   MET   202     -26.167  -4.644  44.337  1.00 39.31           N  
ATOM   1400  CA  MET   202     -26.809  -3.367  44.555  1.00 38.45           C  
ATOM   1401  C   MET   202     -27.879  -3.471  45.655  1.00 38.54           C  
ATOM   1402  O   MET   202     -28.298  -4.575  46.011  1.00 39.36           O  
ATOM   1403  CB  MET   202     -27.421  -2.925  43.232  1.00 38.67           C  
ATOM   1404  CG  MET   202     -26.387  -2.622  42.128  1.00 37.28           C  
ATOM   1405  SD  MET   202     -25.423  -0.969  42.396  0.75 37.93          SE  
ATOM   1406  CE  MET   202     -26.624   0.243  41.755  1.00 39.90           C  
ATOM   1407  N   PRO   203     -28.287  -2.338  46.245  1.00 37.65           N  
ATOM   1408  CA  PRO   203     -29.354  -2.368  47.264  1.00 38.20           C  
ATOM   1409  C   PRO   203     -30.669  -2.907  46.713  1.00 38.81           C  
ATOM   1410  O   PRO   203     -30.902  -2.803  45.508  1.00 39.63           O  
ATOM   1411  CB  PRO   203     -29.523  -0.895  47.649  1.00 37.58           C  
ATOM   1412  CG  PRO   203     -28.263  -0.263  47.275  1.00 37.55           C  
ATOM   1413  CD  PRO   203     -27.751  -0.990  46.059  1.00 37.28           C  
ATOM   1414  N   LYS   204     -31.508  -3.468  47.587  1.00 39.31           N  
ATOM   1415  CA  LYS   204     -32.810  -4.047  47.207  1.00 39.35           C  
ATOM   1416  C   LYS   204     -33.734  -3.053  46.477  1.00 39.72           C  
ATOM   1417  O   LYS   204     -34.442  -3.452  45.558  1.00 40.18           O  
ATOM   1418  CB  LYS   204     -33.521  -4.681  48.426  1.00 39.78           C  
ATOM   1419  N   ALA   205     -33.708  -1.778  46.879  1.00 38.98           N  
ATOM   1420  CA  ALA   205     -34.517  -0.728  46.255  1.00 38.75           C  
ATOM   1421  C   ALA   205     -33.930  -0.470  44.874  1.00 38.44           C  
ATOM   1422  O   ALA   205     -32.742  -0.128  44.749  1.00 37.86           O  
ATOM   1423  CB  ALA   205     -34.488   0.555  47.087  1.00 38.54           C  
ATOM   1424  N   ASP   206     -34.768  -0.614  43.846  1.00 37.50           N  
ATOM   1425  CA  ASP   206     -34.311  -0.545  42.470  1.00 35.82           C  
ATOM   1426  C   ASP   206     -34.325   0.809  41.811  1.00 32.28           C  
ATOM   1427  O   ASP   206     -34.361   0.864  40.607  1.00 31.31           O  
ATOM   1428  CB  ASP   206     -35.078  -1.551  41.596  1.00 38.60           C  
ATOM   1429  CG  ASP   206     -36.537  -1.153  41.345  1.00 40.47           C  
ATOM   1430  OD1 ASP   206     -36.912   0.028  41.591  1.00 39.42           O  
ATOM   1431  OD2 ASP   206     -37.295  -2.043  40.861  1.00 42.49           O  
ATOM   1432  N   ASN   207     -34.223   1.891  42.572  1.00 31.67           N  
ATOM   1433  CA  ASN   207     -34.119   3.245  41.978  1.00 30.34           C  
ATOM   1434  C   ASN   207     -32.881   3.443  41.059  1.00 32.22           C  
ATOM   1435  O   ASN   207     -32.851   4.328  40.140  1.00 32.13           O  
ATOM   1436  CB  ASN   207     -34.022   4.313  43.076  1.00 29.95           C  
ATOM   1437  CG  ASN   207     -35.200   4.302  44.057  1.00 28.77           C  
ATOM   1438  OD1 ASN   207     -35.559   3.275  44.609  1.00 29.54           O  
ATOM   1439  ND2 ASN   207     -35.755   5.465  44.307  1.00 27.36           N  
ATOM   1440  N   TRP   208     -31.817   2.694  41.364  1.00 32.69           N  
ATOM   1441  CA  TRP   208     -30.556   2.768  40.603  1.00 31.91           C  
ATOM   1442  C   TRP   208     -30.776   2.359  39.170  1.00 32.17           C  
ATOM   1443  O   TRP   208     -30.167   2.961  38.311  1.00 31.13           O  
ATOM   1444  CB  TRP   208     -29.448   1.923  41.247  1.00 32.15           C  
ATOM   1445  CG  TRP   208     -29.846   0.532  41.554  1.00 32.23           C  
ATOM   1446  CD1 TRP   208     -30.470   0.092  42.688  1.00 32.29           C  
ATOM   1447  CD2 TRP   208     -29.671  -0.626  40.718  1.00 32.46           C  
ATOM   1448  NE1 TRP   208     -30.690  -1.258  42.612  1.00 32.16           N  
ATOM   1449  CE2 TRP   208     -30.200  -1.727  41.418  1.00 32.61           C  
ATOM   1450  CE3 TRP   208     -29.107  -0.836  39.450  1.00 32.63           C  
ATOM   1451  CZ2 TRP   208     -30.182  -3.037  40.884  1.00 32.23           C  
ATOM   1452  CZ3 TRP   208     -29.099  -2.105  38.924  1.00 31.68           C  
ATOM   1453  CH2 TRP   208     -29.614  -3.200  39.643  1.00 31.68           C  
ATOM   1454  N   LYS   209     -31.621   1.339  38.918  1.00 33.06           N  
ATOM   1455  CA  LYS   209     -32.004   0.923  37.544  1.00 33.39           C  
ATOM   1456  C   LYS   209     -32.502   2.114  36.713  1.00 34.33           C  
ATOM   1457  O   LYS   209     -32.221   2.198  35.520  1.00 37.07           O  
ATOM   1458  CB  LYS   209     -33.085  -0.168  37.508  1.00 34.04           C  
ATOM   1459  CG  LYS   209     -32.646  -1.527  38.040  1.00 35.43           C  
ATOM   1460  CD  LYS   209     -33.611  -2.691  37.657  1.00 35.19           C  
ATOM   1461  CE  LYS   209     -33.276  -3.967  38.447  1.00 36.00           C  
ATOM   1462  NZ  LYS   209     -33.853  -5.242  37.838  1.00 36.60           N  
ATOM   1463  N   ASN   210     -33.244   3.027  37.304  1.00 34.51           N  
ATOM   1464  CA  ASN   210     -33.677   4.231  36.551  1.00 36.49           C  
ATOM   1465  C   ASN   210     -32.501   5.192  36.240  1.00 35.37           C  
ATOM   1466  O   ASN   210     -32.445   5.812  35.160  1.00 36.42           O  
ATOM   1467  CB  ASN   210     -34.839   4.942  37.274  1.00 37.19           C  
ATOM   1468  CG  ASN   210     -36.022   3.995  37.529  1.00 38.90           C  
ATOM   1469  OD1 ASN   210     -36.385   3.209  36.654  1.00 40.42           O  
ATOM   1470  ND2 ASN   210     -36.583   4.026  38.745  1.00 38.09           N  
ATOM   1471  N   ILE   211     -31.552   5.321  37.164  1.00 34.75           N  
ATOM   1472  CA  ILE   211     -30.402   6.196  36.933  1.00 34.72           C  
ATOM   1473  C   ILE   211     -29.506   5.618  35.844  1.00 33.48           C  
ATOM   1474  O   ILE   211     -28.947   6.352  35.002  1.00 29.16           O  
ATOM   1475  CB  ILE   211     -29.609   6.469  38.249  1.00 36.00           C  
ATOM   1476  CG1 ILE   211     -30.486   7.263  39.223  1.00 35.99           C  
ATOM   1477  CG2 ILE   211     -28.321   7.298  37.985  1.00 34.49           C  
ATOM   1478  CD1 ILE   211     -29.809   7.654  40.520  1.00 35.96           C  
ATOM   1479  N   LEU   212     -29.411   4.290  35.858  1.00 32.77           N  
ATOM   1480  CA  LEU   212     -28.597   3.560  34.949  1.00 33.23           C  
ATOM   1481  C   LEU   212     -29.152   3.659  33.546  1.00 34.91           C  
ATOM   1482  O   LEU   212     -28.404   3.863  32.587  1.00 34.20           O  
ATOM   1483  CB  LEU   212     -28.563   2.076  35.381  1.00 33.12           C  
ATOM   1484  CG  LEU   212     -27.602   1.182  34.612  1.00 33.09           C  
ATOM   1485  CD1 LEU   212     -26.133   1.627  34.822  1.00 31.85           C  
ATOM   1486  CD2 LEU   212     -27.801  -0.229  35.052  1.00 32.08           C  
ATOM   1487  N   LEU   213     -30.463   3.460  33.419  1.00 36.65           N  
ATOM   1488  CA  LEU   213     -31.106   3.532  32.112  1.00 37.15           C  
ATOM   1489  C   LEU   213     -30.851   4.917  31.550  1.00 36.30           C  
ATOM   1490  O   LEU   213     -30.586   5.053  30.373  1.00 36.77           O  
ATOM   1491  CB  LEU   213     -32.620   3.252  32.192  1.00 37.58           C  
ATOM   1492  CG  LEU   213     -33.371   3.435  30.867  1.00 36.80           C  
ATOM   1493  CD1 LEU   213     -32.675   2.648  29.761  1.00 36.19           C  
ATOM   1494  CD2 LEU   213     -34.842   3.031  31.016  1.00 36.87           C  
ATOM   1495  N   GLY   214     -30.914   5.934  32.394  1.00 36.15           N  
ATOM   1496  CA  GLY   214     -30.612   7.314  31.963  1.00 36.31           C  
ATOM   1497  C   GLY   214     -29.201   7.391  31.377  1.00 36.76           C  
ATOM   1498  O   GLY   214     -29.002   7.906  30.282  1.00 34.16           O  
ATOM   1499  N   LYS   215     -28.225   6.833  32.095  1.00 38.08           N  
ATOM   1500  CA  LYS   215     -26.839   6.832  31.623  1.00 39.02           C  
ATOM   1501  C   LYS   215     -26.714   6.102  30.291  1.00 38.67           C  
ATOM   1502  O   LYS   215     -26.045   6.582  29.393  1.00 40.02           O  
ATOM   1503  CB  LYS   215     -25.895   6.169  32.645  1.00 38.95           C  
ATOM   1504  CG  LYS   215     -24.460   6.012  32.121  1.00 40.11           C  
ATOM   1505  CD  LYS   215     -23.490   5.230  33.046  1.00 41.64           C  
ATOM   1506  CE  LYS   215     -23.872   3.752  33.214  1.00 42.33           C  
ATOM   1507  NZ  LYS   215     -24.217   3.083  31.907  1.00 42.80           N  
ATOM   1508  N   TRP   216     -27.320   4.911  30.213  1.00 38.44           N  
ATOM   1509  CA  TRP   216     -27.328   4.055  29.010  1.00 37.73           C  
ATOM   1510  C   TRP   216     -27.931   4.760  27.802  1.00 36.69           C  
ATOM   1511  O   TRP   216     -27.353   4.712  26.709  1.00 37.44           O  
ATOM   1512  CB  TRP   216     -28.109   2.800  29.321  1.00 37.33           C  
ATOM   1513  CG  TRP   216     -28.319   1.837  28.235  1.00 37.88           C  
ATOM   1514  CD1 TRP   216     -29.384   1.799  27.373  1.00 37.86           C  
ATOM   1515  CD2 TRP   216     -27.541   0.663  27.956  1.00 37.86           C  
ATOM   1516  NE1 TRP   216     -29.269   0.727  26.545  1.00 37.80           N  
ATOM   1517  CE2 TRP   216     -28.155   0.008  26.880  1.00 37.05           C  
ATOM   1518  CE3 TRP   216     -26.355   0.134  28.475  1.00 37.81           C  
ATOM   1519  CZ2 TRP   216     -27.627  -1.142  26.312  1.00 37.75           C  
ATOM   1520  CZ3 TRP   216     -25.836  -1.013  27.910  1.00 37.54           C  
ATOM   1521  CH2 TRP   216     -26.476  -1.650  26.857  1.00 37.69           C  
ATOM   1522  N   SER   217     -29.079   5.405  28.011  1.00 34.69           N  
ATOM   1523  CA  SER   217     -29.758   6.195  26.964  1.00 34.80           C  
ATOM   1524  C   SER   217     -28.914   7.353  26.456  1.00 34.06           C  
ATOM   1525  O   SER   217     -28.999   7.724  25.289  1.00 34.05           O  
ATOM   1526  CB  SER   217     -31.099   6.759  27.465  1.00 34.33           C  
ATOM   1527  OG  SER   217     -32.049   5.728  27.666  1.00 34.19           O  
ATOM   1528  N   GLY   218     -28.151   7.959  27.359  1.00 34.17           N  
ATOM   1529  CA  GLY   218     -27.270   9.076  27.018  1.00 33.98           C  
ATOM   1530  C   GLY   218     -26.109   8.619  26.147  1.00 33.23           C  
ATOM   1531  O   GLY   218     -25.666   9.331  25.281  1.00 32.30           O  
ATOM   1532  N   TRP   219     -25.619   7.404  26.391  1.00 33.89           N  
ATOM   1533  CA  TRP   219     -24.562   6.807  25.584  1.00 32.51           C  
ATOM   1534  C   TRP   219     -25.056   6.479  24.156  1.00 31.46           C  
ATOM   1535  O   TRP   219     -24.291   6.485  23.200  1.00 29.93           O  
ATOM   1536  CB  TRP   219     -24.075   5.544  26.315  1.00 34.90           C  
ATOM   1537  CG  TRP   219     -23.044   5.761  27.391  1.00 35.00           C  
ATOM   1538  CD1 TRP   219     -22.690   6.928  27.981  1.00 36.21           C  
ATOM   1539  CD2 TRP   219     -22.297   4.739  28.054  1.00 36.69           C  
ATOM   1540  NE1 TRP   219     -21.727   6.712  28.932  1.00 36.02           N  
ATOM   1541  CE2 TRP   219     -21.464   5.373  29.002  1.00 36.36           C  
ATOM   1542  CE3 TRP   219     -22.238   3.354  27.922  1.00 35.77           C  
ATOM   1543  CZ2 TRP   219     -20.568   4.665  29.819  1.00 36.18           C  
ATOM   1544  CZ3 TRP   219     -21.332   2.630  28.736  1.00 36.36           C  
ATOM   1545  CH2 TRP   219     -20.526   3.286  29.680  1.00 36.68           C  
ATOM   1546  N   ILE   220     -26.332   6.140  24.019  1.00 31.33           N  
ATOM   1547  CA  ILE   220     -26.941   5.905  22.713  1.00 31.05           C  
ATOM   1548  C   ILE   220     -27.082   7.237  21.940  1.00 33.15           C  
ATOM   1549  O   ILE   220     -26.722   7.330  20.755  1.00 32.49           O  
ATOM   1550  CB  ILE   220     -28.304   5.253  22.875  1.00 29.75           C  
ATOM   1551  CG1 ILE   220     -28.157   3.828  23.465  1.00 29.30           C  
ATOM   1552  CG2 ILE   220     -29.014   5.142  21.512  1.00 30.31           C  
ATOM   1553  CD1 ILE   220     -29.494   3.274  23.922  1.00 28.25           C  
ATOM   1554  N   GLU   221     -27.604   8.262  22.608  1.00 35.10           N  
ATOM   1555  CA  GLU   221     -27.741   9.611  21.989  1.00 35.33           C  
ATOM   1556  C   GLU   221     -26.379  10.186  21.502  1.00 36.09           C  
ATOM   1557  O   GLU   221     -26.283  10.752  20.409  1.00 37.21           O  
ATOM   1558  CB  GLU   221     -28.410  10.577  22.987  1.00 36.75           C  
ATOM   1559  CG  GLU   221     -28.923  11.952  22.398  1.00 38.27           C  
ATOM   1560  CD  GLU   221     -27.892  13.097  22.374  1.00 41.37           C  
ATOM   1561  OE1 GLU   221     -26.798  12.930  22.990  1.00 42.19           O  
ATOM   1562  OE2 GLU   221     -28.193  14.192  21.752  1.00 42.76           O  
ATOM   1563  N   GLN   222     -25.344  10.047  22.328  1.00 36.89           N  
ATOM   1564  CA  GLN   222     -23.983  10.545  22.027  1.00 36.28           C  
ATOM   1565  C   GLN   222     -23.212   9.642  21.077  1.00 34.50           C  
ATOM   1566  O   GLN   222     -22.091   9.950  20.718  1.00 31.88           O  
ATOM   1567  CB  GLN   222     -23.159  10.657  23.322  1.00 37.58           C  
ATOM   1568  CG  GLN   222     -23.716  11.611  24.368  1.00 39.28           C  
ATOM   1569  CD  GLN   222     -23.446  13.088  24.074  1.00 41.32           C  
ATOM   1570  OE1 GLN   222     -22.294  13.500  23.894  1.00 43.78           O  
ATOM   1571  NE2 GLN   222     -24.511  13.897  24.041  1.00 40.72           N  
ATOM   1572  N   ARG   223     -23.787   8.494  20.735  1.00 34.13           N  
ATOM   1573  CA  ARG   223     -23.179   7.523  19.831  1.00 33.61           C  
ATOM   1574  C   ARG   223     -21.917   6.873  20.400  1.00 34.35           C  
ATOM   1575  O   ARG   223     -20.949   6.632  19.654  1.00 35.88           O  
ATOM   1576  CB  ARG   223     -22.898   8.168  18.485  1.00 34.96           C  
ATOM   1577  CG  ARG   223     -22.824   7.244  17.284  1.00 35.66           C  
ATOM   1578  CD  ARG   223     -22.314   8.071  16.136  1.00 36.64           C  
ATOM   1579  NE  ARG   223     -22.460   7.421  14.851  1.00 36.77           N  
ATOM   1580  CZ  ARG   223     -22.173   8.005  13.695  1.00 37.14           C  
ATOM   1581  NH1 ARG   223     -21.712   9.244  13.648  1.00 37.54           N  
ATOM   1582  NH2 ARG   223     -22.356   7.338  12.565  1.00 38.08           N  
ATOM   1583  N   ILE   224     -21.926   6.592  21.712  1.00 32.16           N  
ATOM   1584  CA  ILE   224     -20.824   5.884  22.403  1.00 30.24           C  
ATOM   1585  C   ILE   224     -21.037   4.388  22.261  1.00 29.99           C  
ATOM   1586  O   ILE   224     -20.081   3.600  22.134  1.00 26.56           O  
ATOM   1587  CB  ILE   224     -20.757   6.269  23.908  1.00 29.79           C  
ATOM   1588  CG1 ILE   224     -20.396   7.761  24.076  1.00 29.73           C  
ATOM   1589  CG2 ILE   224     -19.763   5.447  24.614  1.00 30.17           C  
ATOM   1590  CD1 ILE   224     -20.563   8.314  25.494  1.00 29.42           C  
ATOM   1591  N   ILE   225     -22.312   3.986  22.300  1.00 30.18           N  
ATOM   1592  CA  ILE   225     -22.678   2.590  22.089  1.00 28.73           C  
ATOM   1593  C   ILE   225     -23.656   2.595  20.934  1.00 30.68           C  
ATOM   1594  O   ILE   225     -24.386   3.580  20.726  1.00 30.26           O  
ATOM   1595  CB  ILE   225     -23.200   1.918  23.379  1.00 28.42           C  
ATOM   1596  CG1 ILE   225     -24.620   2.348  23.737  1.00 26.99           C  
ATOM   1597  CG2 ILE   225     -22.217   2.217  24.514  1.00 29.60           C  
ATOM   1598  CD1 ILE   225     -25.110   1.976  25.113  1.00 26.01           C  
ATOM   1599  N   ILE   226     -23.642   1.506  20.155  1.00 30.62           N  
ATOM   1600  CA  ILE   226     -24.499   1.394  18.976  1.00 30.56           C  
ATOM   1601  C   ILE   226     -25.110   0.009  18.972  1.00 29.99           C  
ATOM   1602  O   ILE   226     -24.574  -0.883  19.606  1.00 28.78           O  
ATOM   1603  CB  ILE   226     -23.740   1.708  17.596  1.00 30.62           C  
ATOM   1604  CG1 ILE   226     -22.567   0.765  17.340  1.00 30.74           C  
ATOM   1605  CG2 ILE   226     -23.274   3.214  17.504  1.00 30.74           C  
ATOM   1606  CD1 ILE   226     -21.914   0.946  15.918  1.00 30.80           C  
ATOM   1607  N   PRO   227     -26.270  -0.161  18.317  1.00 30.20           N  
ATOM   1608  CA  PRO   227     -26.836  -1.526  18.246  1.00 30.62           C  
ATOM   1609  C   PRO   227     -25.852  -2.518  17.629  1.00 33.79           C  
ATOM   1610  O   PRO   227     -25.105  -2.175  16.706  1.00 32.59           O  
ATOM   1611  CB  PRO   227     -28.079  -1.360  17.373  1.00 29.34           C  
ATOM   1612  CG  PRO   227     -28.421   0.098  17.460  1.00 29.26           C  
ATOM   1613  CD  PRO   227     -27.145   0.845  17.691  1.00 29.25           C  
ATOM   1614  N   SER   228     -25.827  -3.722  18.183  1.00 37.62           N  
ATOM   1615  CA  SER   228     -24.979  -4.781  17.679  1.00 40.86           C  
ATOM   1616  C   SER   228     -25.762  -5.611  16.664  1.00 43.11           C  
ATOM   1617  O   SER   228     -26.490  -6.533  17.032  1.00 44.20           O  
ATOM   1618  CB  SER   228     -24.474  -5.666  18.812  1.00 40.76           C  
ATOM   1619  OG  SER   228     -23.551  -6.594  18.271  1.00 41.97           O  
ATOM   1620  N   LEU   229     -25.572  -5.292  15.386  1.00 45.83           N  
ATOM   1621  CA  LEU   229     -26.333  -5.890  14.290  1.00 47.76           C  
ATOM   1622  C   LEU   229     -25.604  -7.011  13.560  1.00 49.40           C  
ATOM   1623  O   LEU   229     -24.593  -6.779  12.910  1.00 49.60           O  
ATOM   1624  CB  LEU   229     -26.711  -4.786  13.289  1.00 47.66           C  
ATOM   1625  CG  LEU   229     -27.607  -3.690  13.883  1.00 47.20           C  
ATOM   1626  CD1 LEU   229     -27.754  -2.509  12.947  1.00 46.75           C  
ATOM   1627  CD2 LEU   229     -28.965  -4.279  14.249  1.00 47.53           C  
ATOM   1628  N   SER   230     -26.155  -8.220  13.659  1.00 51.73           N  
ATOM   1629  CA  SER   230     -25.586  -9.409  13.031  1.00 52.88           C  
ATOM   1630  C   SER   230     -26.236  -9.706  11.680  1.00 53.74           C  
ATOM   1631  O   SER   230     -25.565  -9.657  10.646  1.00 54.94           O  
ATOM   1632  CB  SER   230     -25.730 -10.610  13.970  1.00 52.98           C  
ATOM   1633  OG  SER   230     -25.042 -10.362  15.191  1.00 53.17           O  
END
