
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   82 ( 1365),  selected   82 , name 1p6r_A
# Molecule2: number of CA atoms  134 ( 1070),  selected  134 , name T0443_97_230.pdb
# PARAMETERS: 1p6r_A.T0443_97_230.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      S      97           -
LGA    -       -      D      98           -
LGA    -       -      G      99           -
LGA    -       -      I     100           -
LGA    -       -      L     101           -
LGA    -       -      A     102           -
LGA    -       -      L     103           -
LGA    -       -      M     104           -
LGA    -       -      D     105           -
LGA    -       -      F     106           -
LGA    -       -      E     107           -
LGA    -       -      Y     108           -
LGA    -       -      T     109           -
LGA    -       -      Q     110           -
LGA    -       -      L     111           -
LGA    -       -      L     112           -
LGA    -       -      A     113           -
LGA    -       -      E     114           -
LGA    -       -      V     115           -
LGA    -       -      A     116           -
LGA    -       -      Q     117           -
LGA    -       -      I     118           -
LGA    -       -      P     119           -
LGA    -       -      D     120           -
LGA    -       -      I     121           -
LGA    -       -      P     122           -
LGA    -       -      D     123           -
LGA    -       -      I     124           -
LGA    -       -      H     125           -
LGA    -       -      Y     126           -
LGA    -       -      S     127           -
LGA    -       -      N     128           -
LGA    -       -      D     129           -
LGA    -       -      S     130           -
LGA    -       -      K     131           -
LGA    -       -      Y     132           -
LGA    -       -      T     133           -
LGA    -       -      P     134           -
LGA    -       -      S     135           -
LGA    -       -      P     136           -
LGA    -       -      A     137           -
LGA    -       -      A     138           -
LGA    -       -      F     139           -
LGA    -       -      I     140           -
LGA    -       -      R     141           -
LGA    -       -      Q     142           -
LGA    -       -      Y     143           -
LGA    -       -      R     144           -
LGA    -       -      Y     145           -
LGA    -       -      D     146           -
LGA    -       -      V     147           -
LGA    -       -      T     148           -
LGA    -       -      H     149           -
LGA    -       -      D     150           -
LGA    -       -      L     151           -
LGA    -       -      Q     152           -
LGA    -       -      E     153           -
LGA    -       -      A     154           -
LGA    -       -      E     155           -
LGA    -       -      T     156           -
LGA    -       -      A     157           -
LGA    -       -      L     158           -
LGA    -       -      L     159           -
LGA    -       -      I     160           -
LGA    K     2_A      W     161          6.303
LGA    K     3_A      R     162          3.752
LGA    -       -      N     163           -
LGA    -       -      A     164           -
LGA    -       -      E     165           -
LGA    -       -      D     166           -
LGA    -       -      D     167           -
LGA    -       -      V     168           -
LGA    I     4_A      M     169          3.403
LGA    P     5_A      Y     170          5.020
LGA    Q     6_A      Q     171          2.129
LGA    I     7_A      T     172          4.614
LGA    S     8_A      L     173          2.874
LGA    D     9_A      D     174          1.632
LGA    -       -      G     175           -
LGA    A    10_A      F     176          2.753
LGA    E    11_A      D     177          1.919
LGA    L    12_A      M     178          1.802
LGA    E    13_A      M     179          2.593
LGA    V    14_A      L     180          1.884
LGA    M    15_A      L     181          1.124
LGA    K    16_A      E     182          2.422
LGA    V    17_A      I     183          2.552
LGA    I    18_A      M     184          1.512
LGA    W    19_A      G     185          1.938
LGA    K    20_A      S     186          2.389
LGA    H    21_A      S     187          1.062
LGA    S    22_A      A     188          3.494
LGA    S    23_A      -       -           -
LGA    I    24_A      L     189          1.283
LGA    N    25_A      S     190          1.622
LGA    T    26_A      F     191          1.903
LGA    N    27_A      D     192          1.112
LGA    E    28_A      T     193          0.593
LGA    V    29_A      L     194          1.212
LGA    I    30_A      A     195          0.910
LGA    K    31_A      Q     196          1.206
LGA    E    32_A      T     197          1.935
LGA    L    33_A      L     198          3.260
LGA    S    34_A      V     199          3.476
LGA    K    35_A      E     200          3.487
LGA    T    36_A      F     201          4.594
LGA    S    37_A      -       -           -
LGA    T    38_A      M     202          2.079
LGA    W    39_A      P     203           #
LGA    -       -      K     204           -
LGA    -       -      A     205           -
LGA    -       -      D     206           -
LGA    -       -      N     207           -
LGA    S    40_A      W     208          0.779
LGA    P    41_A      K     209          0.452
LGA    K    42_A      N     210          1.510
LGA    T    43_A      I     211          2.338
LGA    I    44_A      L     212          1.694
LGA    Q    45_A      L     213          0.810
LGA    T    46_A      G     214          2.062
LGA    M    47_A      K     215          2.054
LGA    L    48_A      W     216          0.907
LGA    L    49_A      S     217          1.756
LGA    R    50_A      G     218          2.384
LGA    L    51_A      W     219          1.555
LGA    I    52_A      I     220          1.219
LGA    K    53_A      E     221          1.921
LGA    K    54_A      Q     222          1.731
LGA    G    55_A      R     223          0.919
LGA    A    56_A      I     224          0.852
LGA    L    57_A      I     225          0.275
LGA    N    58_A      I     226          0.806
LGA    H    59_A      P     227          2.367
LGA    H    60_A      -       -           -
LGA    K    61_A      -       -           -
LGA    E    62_A      -       -           -
LGA    G    63_A      -       -           -
LGA    R    64_A      -       -           -
LGA    V    65_A      -       -           -
LGA    F    66_A      -       -           -
LGA    V    67_A      -       -           -
LGA    Y    68_A      -       -           -
LGA    T    69_A      S     228          3.503
LGA    P    70_A      L     229           -
LGA    N    71_A      S     230           -
LGA    I    72_A      -       -           -
LGA    D    73_A      -       -           -
LGA    E    74_A      -       -           -
LGA    S    75_A      -       -           -
LGA    D    76_A      -       -           -
LGA    Y    77_A      -       -           -
LGA    I    78_A      -       -           -
LGA    E    79_A      -       -           -
LGA    V    80_A      -       -           -
LGA    K    81_A      -       -           -
LGA    S    82_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   82  134    5.0     56    2.42     7.14     31.392     2.219

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.112541 * X  +   0.649846 * Y  +  -0.751688 * Z  + -22.694912
  Y_new =   0.902232 * X  +   0.383779 * Y  +   0.196703 * Z  +   1.415804
  Z_new =   0.416308 * X  +  -0.656060 * Y  +  -0.629502 * Z  +  27.734804 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.335539    0.806054  [ DEG:  -133.8165     46.1835 ]
  Theta =  -0.429381   -2.712211  [ DEG:   -24.6017   -155.3983 ]
  Phi   =   1.694891   -1.446701  [ DEG:    97.1101    -82.8899 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1p6r_A                                        
REMARK     2: T0443_97_230.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1p6r_A.T0443_97_230.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   82  134   5.0   56   2.42    7.14  31.392
REMARK  ---------------------------------------------------------- 
MOLECULE 1p6r_A
HEADER    TRANSCRIPTION                           30-APR-03   1P6R              
TITLE     SOLUTION STRUCTURE OF THE DNA BINDING DOMAIN OF THE                   
TITLE    2 REPRESSOR BLAI.                                                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PENICILLINASE REPRESSOR;                                   
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: N-TERMINAL DOMAIN (RESIDUES 1-82);                         
COMPND   5 SYNONYM: REGULATORY PROTEIN BLAI, BETA-LACTAMASE REPRESSOR           
COMPND   6 PROTEIN;                                                             
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS LICHENIFORMIS;                         
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: BLAI OR PENI;                                                  
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3) PLYS;                            
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET22                                     
KEYWDS    TRANSCRIPTION REGULATION, REPRESSOR, DNA-BINDING, WINGED              
KEYWDS   2 HELIX PROTEIN, BACTERIAL RESISTANCE TO ANTIBIOTICS                   
EXPDTA    NMR, 19 STRUCTURES                                                    
AUTHOR    H.V.MELCKEBEKE,C.VREULS,P.GANS,G.LLABRES,P.FILEE,B.JORIS,             
AUTHOR   2 J.P.SIMORRE                                                          
REVDAT   1   09-DEC-03 1P6R    0                                                
JRNL        AUTH   H.V.MELCKEBEKE,C.VREULS,P.GANS,G.LLABRES,B.JORIS,            
JRNL        AUTH 2 J.P.SIMORRE                                                  
JRNL        TITL   SOLUTION STRUCTURAL STUDY OF BLAI: IMPLICATIONS              
JRNL        TITL 2 FOR THE REPRESSION OF GENES INVOLVED IN                      
JRNL        TITL 3 BETA-LACTAM ANTIBIOTIC RESISTANCE.                           
JRNL        REF    J.MOL.BIOL.                   V. 333   711 2003              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1P6R A    1    82  UNP    P06555   BLAI_BACLI       1     82             
SEQRES   1 A   82  MET LYS LYS ILE PRO GLN ILE SER ASP ALA GLU LEU GLU          
SEQRES   2 A   82  VAL MET LYS VAL ILE TRP LYS HIS SER SER ILE ASN THR          
SEQRES   3 A   82  ASN GLU VAL ILE LYS GLU LEU SER LYS THR SER THR TRP          
SEQRES   4 A   82  SER PRO LYS THR ILE GLN THR MET LEU LEU ARG LEU ILE          
SEQRES   5 A   82  LYS LYS GLY ALA LEU ASN HIS HIS LYS GLU GLY ARG VAL          
SEQRES   6 A   82  PHE VAL TYR THR PRO ASN ILE ASP GLU SER ASP TYR ILE          
SEQRES   7 A   82  GLU VAL LYS SER                                              
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1     -24.846  13.326  19.310  1.00  0.00           N  
ATOM      2  CA  MET A   1     -24.157  12.996  18.052  1.00  0.00           C  
ATOM      3  C   MET A   1     -22.820  12.353  18.407  1.00  0.00           C  
ATOM      4  O   MET A   1     -22.485  12.335  19.590  1.00  0.00           O  
ATOM      5  CB  MET A   1     -23.964  14.227  17.149  1.00  0.00           C  
ATOM      6  CG  MET A   1     -25.283  14.822  16.636  1.00  0.00           C  
ATOM      7  SD  MET A   1     -26.270  15.712  17.866  1.00  0.00           S  
ATOM      8  CE  MET A   1     -27.882  15.697  17.050  1.00  0.00           C  
ATOM      9  HA  MET A   1     -24.749  12.250  17.519  1.00  0.00           H  
ATOM     10  HB2 MET A   1     -23.403  14.995  17.683  1.00  0.00           H  
ATOM     11  HB3 MET A   1     -23.383  13.928  16.274  1.00  0.00           H  
ATOM     12  HG2 MET A   1     -25.052  15.533  15.843  1.00  0.00           H  
ATOM     13  HG3 MET A   1     -25.889  14.024  16.207  1.00  0.00           H  
ATOM     14  HE1 MET A   1     -28.596  16.241  17.666  1.00  0.00           H  
ATOM     15  HE2 MET A   1     -28.221  14.669  16.922  1.00  0.00           H  
ATOM     16  HE3 MET A   1     -27.800  16.182  16.078  1.00  0.00           H  
ATOM     17  H1  MET A   1     -24.760  12.517  19.924  1.00  0.00           H  
ATOM     18  H2  MET A   1     -25.814  13.572  19.172  1.00  0.00           H  
ATOM     19  H3  MET A   1     -24.341  14.073  19.762  1.00  0.00           H  
ATOM     20  N   LYS A   2     -22.077  11.818  17.433  1.00  0.00           N  
ATOM     21  CA  LYS A   2     -20.814  11.172  17.748  1.00  0.00           C  
ATOM     22  C   LYS A   2     -19.841  12.184  18.359  1.00  0.00           C  
ATOM     23  O   LYS A   2     -19.612  13.248  17.787  1.00  0.00           O  
ATOM     24  CB  LYS A   2     -20.233  10.446  16.529  1.00  0.00           C  
ATOM     25  CG  LYS A   2     -19.183   9.429  16.999  1.00  0.00           C  
ATOM     26  CD  LYS A   2     -18.650   8.596  15.829  1.00  0.00           C  
ATOM     27  CE  LYS A   2     -17.659   7.534  16.323  1.00  0.00           C  
ATOM     28  NZ  LYS A   2     -18.317   6.507  17.153  1.00  0.00           N  
ATOM     29  H   LYS A   2     -22.359  11.886  16.467  1.00  0.00           H  
ATOM     30  HA  LYS A   2     -21.045  10.411  18.485  1.00  0.00           H  
ATOM     31  HB2 LYS A   2     -21.033   9.905  16.021  1.00  0.00           H  
ATOM     32  HB3 LYS A   2     -19.790  11.163  15.836  1.00  0.00           H  
ATOM     33  HG2 LYS A   2     -18.351   9.949  17.475  1.00  0.00           H  
ATOM     34  HG3 LYS A   2     -19.644   8.764  17.731  1.00  0.00           H  
ATOM     35  HD2 LYS A   2     -19.478   8.105  15.312  1.00  0.00           H  
ATOM     36  HD3 LYS A   2     -18.143   9.256  15.122  1.00  0.00           H  
ATOM     37  HE2 LYS A   2     -17.214   7.038  15.459  1.00  0.00           H  
ATOM     38  HE3 LYS A   2     -16.862   8.008  16.898  1.00  0.00           H  
ATOM     39  HZ1 LYS A   2     -17.640   5.817  17.440  1.00  0.00           H  
ATOM     40  HZ2 LYS A   2     -19.040   6.055  16.613  1.00  0.00           H  
ATOM     41  HZ3 LYS A   2     -18.740   6.917  17.977  1.00  0.00           H  
ATOM     42  N   LYS A   3     -19.299  11.852  19.528  1.00  0.00           N  
ATOM     43  CA  LYS A   3     -18.365  12.654  20.298  1.00  0.00           C  
ATOM     44  C   LYS A   3     -17.398  11.657  20.937  1.00  0.00           C  
ATOM     45  O   LYS A   3     -17.791  10.508  21.154  1.00  0.00           O  
ATOM     46  CB  LYS A   3     -19.178  13.426  21.350  1.00  0.00           C  
ATOM     47  CG  LYS A   3     -18.344  14.457  22.112  1.00  0.00           C  
ATOM     48  CD  LYS A   3     -19.218  15.233  23.104  1.00  0.00           C  
ATOM     49  CE  LYS A   3     -18.368  16.288  23.819  1.00  0.00           C  
ATOM     50  NZ  LYS A   3     -19.170  17.077  24.769  1.00  0.00           N  
ATOM     51  H   LYS A   3     -19.546  10.960  19.957  1.00  0.00           H  
ATOM     52  HA  LYS A   3     -17.820  13.342  19.650  1.00  0.00           H  
ATOM     53  HB2 LYS A   3     -19.985  13.955  20.841  1.00  0.00           H  
ATOM     54  HB3 LYS A   3     -19.616  12.718  22.056  1.00  0.00           H  
ATOM     55  HG2 LYS A   3     -17.533  13.963  22.653  1.00  0.00           H  
ATOM     56  HG3 LYS A   3     -17.905  15.154  21.398  1.00  0.00           H  
ATOM     57  HD2 LYS A   3     -20.030  15.722  22.564  1.00  0.00           H  
ATOM     58  HD3 LYS A   3     -19.637  14.539  23.836  1.00  0.00           H  
ATOM     59  HE2 LYS A   3     -17.560  15.796  24.359  1.00  0.00           H  
ATOM     60  HE3 LYS A   3     -17.923  16.959  23.083  1.00  0.00           H  
ATOM     61  HZ1 LYS A   3     -19.911  17.554  24.274  1.00  0.00           H  
ATOM     62  HZ2 LYS A   3     -19.570  16.466  25.467  1.00  0.00           H  
ATOM     63  HZ3 LYS A   3     -18.577  17.759  25.221  1.00  0.00           H  
ATOM     64  N   ILE A   4     -16.143  12.029  21.213  1.00  0.00           N  
ATOM     65  CA  ILE A   4     -15.256  11.079  21.876  1.00  0.00           C  
ATOM     66  C   ILE A   4     -15.872  10.802  23.258  1.00  0.00           C  
ATOM     67  O   ILE A   4     -16.365  11.740  23.888  1.00  0.00           O  
ATOM     68  CB  ILE A   4     -13.799  11.577  21.915  1.00  0.00           C  
ATOM     69  CG1 ILE A   4     -12.777  10.436  22.067  1.00  0.00           C  
ATOM     70  CG2 ILE A   4     -13.568  12.565  23.060  1.00  0.00           C  
ATOM     71  CD1 ILE A   4     -12.702   9.500  20.856  1.00  0.00           C  
ATOM     72  H   ILE A   4     -15.853  13.004  21.088  1.00  0.00           H  
ATOM     73  HA  ILE A   4     -15.276  10.195  21.249  1.00  0.00           H  
ATOM     74  HB  ILE A   4     -13.589  12.093  20.976  1.00  0.00           H  
ATOM     75 HG12 ILE A   4     -11.789  10.880  22.178  1.00  0.00           H  
ATOM     76 HG13 ILE A   4     -12.989   9.860  22.968  1.00  0.00           H  
ATOM     77 HG21 ILE A   4     -12.615  13.065  22.915  1.00  0.00           H  
ATOM     78 HG22 ILE A   4     -13.556  12.052  24.023  1.00  0.00           H  
ATOM     79 HG23 ILE A   4     -14.358  13.306  23.063  1.00  0.00           H  
ATOM     80 HD11 ILE A   4     -11.844   8.840  20.973  1.00  0.00           H  
ATOM     81 HD12 ILE A   4     -13.596   8.885  20.772  1.00  0.00           H  
ATOM     82 HD13 ILE A   4     -12.576  10.084  19.944  1.00  0.00           H  
ATOM     83  N   PRO A   5     -15.930   9.552  23.740  1.00  0.00           N  
ATOM     84  CA  PRO A   5     -16.622   9.294  24.990  1.00  0.00           C  
ATOM     85  C   PRO A   5     -16.015  10.064  26.174  1.00  0.00           C  
ATOM     86  O   PRO A   5     -14.934   9.731  26.659  1.00  0.00           O  
ATOM     87  CB  PRO A   5     -16.538   7.773  25.176  1.00  0.00           C  
ATOM     88  CG  PRO A   5     -16.381   7.231  23.761  1.00  0.00           C  
ATOM     89  CD  PRO A   5     -15.582   8.319  23.055  1.00  0.00           C  
ATOM     90  HA  PRO A   5     -17.672   9.558  24.857  1.00  0.00           H  
ATOM     91  HB2 PRO A   5     -15.627   7.495  25.706  1.00  0.00           H  
ATOM     92  HB3 PRO A   5     -17.420   7.361  25.672  1.00  0.00           H  
ATOM     93  HG2 PRO A   5     -15.845   6.283  23.764  1.00  0.00           H  
ATOM     94  HG3 PRO A   5     -17.358   7.132  23.289  1.00  0.00           H  
ATOM     95  HD2 PRO A   5     -14.515   8.123  23.166  1.00  0.00           H  
ATOM     96  HD3 PRO A   5     -15.865   8.314  22.003  1.00  0.00           H  
ATOM     97  N   GLN A   6     -16.779  11.016  26.722  1.00  0.00           N  
ATOM     98  CA  GLN A   6     -16.408  11.784  27.903  1.00  0.00           C  
ATOM     99  C   GLN A   6     -16.918  10.966  29.087  1.00  0.00           C  
ATOM    100  O   GLN A   6     -17.981  11.233  29.647  1.00  0.00           O  
ATOM    101  CB  GLN A   6     -16.986  13.207  27.825  1.00  0.00           C  
ATOM    102  CG  GLN A   6     -16.553  13.994  26.569  1.00  0.00           C  
ATOM    103  CD  GLN A   6     -15.044  14.226  26.444  1.00  0.00           C  
ATOM    104  OE1 GLN A   6     -14.281  13.975  27.373  1.00  0.00           O  
ATOM    105  NE2 GLN A   6     -14.583  14.730  25.304  1.00  0.00           N  
ATOM    106  H   GLN A   6     -17.627  11.276  26.245  1.00  0.00           H  
ATOM    107  HA  GLN A   6     -15.325  11.852  27.976  1.00  0.00           H  
ATOM    108  HB2 GLN A   6     -18.075  13.150  27.828  1.00  0.00           H  
ATOM    109  HB3 GLN A   6     -16.672  13.759  28.714  1.00  0.00           H  
ATOM    110  HG2 GLN A   6     -16.907  13.481  25.677  1.00  0.00           H  
ATOM    111  HG3 GLN A   6     -17.031  14.972  26.609  1.00  0.00           H  
ATOM    112 HE21 GLN A   6     -15.172  14.960  24.489  1.00  0.00           H  
ATOM    113 HE22 GLN A   6     -13.582  14.843  25.189  1.00  0.00           H  
ATOM    114  N   ILE A   7     -16.179   9.896  29.371  1.00  0.00           N  
ATOM    115  CA  ILE A   7     -16.522   8.837  30.309  1.00  0.00           C  
ATOM    116  C   ILE A   7     -16.009   9.077  31.733  1.00  0.00           C  
ATOM    117  O   ILE A   7     -14.854   9.444  31.947  1.00  0.00           O  
ATOM    118  CB  ILE A   7     -15.942   7.538  29.716  1.00  0.00           C  
ATOM    119  CG1 ILE A   7     -16.696   7.112  28.450  1.00  0.00           C  
ATOM    120  CG2 ILE A   7     -15.819   6.369  30.703  1.00  0.00           C  
ATOM    121  CD1 ILE A   7     -18.065   6.482  28.700  1.00  0.00           C  
ATOM    122  H   ILE A   7     -15.357   9.761  28.795  1.00  0.00           H  
ATOM    123  HA  ILE A   7     -17.606   8.748  30.352  1.00  0.00           H  
ATOM    124  HB  ILE A   7     -14.935   7.763  29.384  1.00  0.00           H  
ATOM    125 HG12 ILE A   7     -16.843   7.981  27.817  1.00  0.00           H  
ATOM    126 HG13 ILE A   7     -16.075   6.400  27.907  1.00  0.00           H  
ATOM    127 HG21 ILE A   7     -15.480   5.481  30.172  1.00  0.00           H  
ATOM    128 HG22 ILE A   7     -15.087   6.601  31.477  1.00  0.00           H  
ATOM    129 HG23 ILE A   7     -16.775   6.159  31.168  1.00  0.00           H  
ATOM    130 HD11 ILE A   7     -18.730   7.205  29.165  1.00  0.00           H  
ATOM    131 HD12 ILE A   7     -18.480   6.174  27.740  1.00  0.00           H  
ATOM    132 HD13 ILE A   7     -17.983   5.604  29.336  1.00  0.00           H  
ATOM    133  N   SER A   8     -16.872   8.820  32.719  1.00  0.00           N  
ATOM    134  CA  SER A   8     -16.514   8.782  34.128  1.00  0.00           C  
ATOM    135  C   SER A   8     -16.281   7.309  34.487  1.00  0.00           C  
ATOM    136  O   SER A   8     -16.805   6.425  33.808  1.00  0.00           O  
ATOM    137  CB  SER A   8     -17.644   9.388  34.967  1.00  0.00           C  
ATOM    138  OG  SER A   8     -18.862   8.705  34.733  1.00  0.00           O  
ATOM    139  H   SER A   8     -17.814   8.540  32.475  1.00  0.00           H  
ATOM    140  HA  SER A   8     -15.599   9.349  34.313  1.00  0.00           H  
ATOM    141  HB2 SER A   8     -17.391   9.311  36.026  1.00  0.00           H  
ATOM    142  HB3 SER A   8     -17.762  10.443  34.714  1.00  0.00           H  
ATOM    143  HG  SER A   8     -19.196   8.947  33.861  1.00  0.00           H  
ATOM    144  N   ASP A   9     -15.526   7.018  35.552  1.00  0.00           N  
ATOM    145  CA  ASP A   9     -15.248   5.638  35.958  1.00  0.00           C  
ATOM    146  C   ASP A   9     -16.532   4.803  36.063  1.00  0.00           C  
ATOM    147  O   ASP A   9     -16.583   3.659  35.618  1.00  0.00           O  
ATOM    148  CB  ASP A   9     -14.478   5.615  37.278  1.00  0.00           C  
ATOM    149  CG  ASP A   9     -14.213   4.178  37.719  1.00  0.00           C  
ATOM    150  OD1 ASP A   9     -13.285   3.570  37.142  1.00  0.00           O  
ATOM    151  OD2 ASP A   9     -14.952   3.715  38.613  1.00  0.00           O  
ATOM    152  H   ASP A   9     -15.088   7.767  36.066  1.00  0.00           H  
ATOM    153  HA  ASP A   9     -14.604   5.191  35.202  1.00  0.00           H  
ATOM    154  HB2 ASP A   9     -13.521   6.121  37.140  1.00  0.00           H  
ATOM    155  HB3 ASP A   9     -15.047   6.128  38.054  1.00  0.00           H  
ATOM    156  N   ALA A  10     -17.581   5.392  36.639  1.00  0.00           N  
ATOM    157  CA  ALA A  10     -18.868   4.732  36.789  1.00  0.00           C  
ATOM    158  C   ALA A  10     -19.406   4.259  35.433  1.00  0.00           C  
ATOM    159  O   ALA A  10     -19.944   3.160  35.333  1.00  0.00           O  
ATOM    160  CB  ALA A  10     -19.837   5.677  37.503  1.00  0.00           C  
ATOM    161  H   ALA A  10     -17.483   6.339  36.970  1.00  0.00           H  
ATOM    162  HA  ALA A  10     -18.723   3.850  37.416  1.00  0.00           H  
ATOM    163  HB1 ALA A  10     -19.386   6.039  38.428  1.00  0.00           H  
ATOM    164  HB2 ALA A  10     -20.751   5.142  37.755  1.00  0.00           H  
ATOM    165  HB3 ALA A  10     -20.076   6.528  36.863  1.00  0.00           H  
ATOM    166  N   GLU A  11     -19.261   5.077  34.384  1.00  0.00           N  
ATOM    167  CA  GLU A  11     -19.655   4.679  33.039  1.00  0.00           C  
ATOM    168  C   GLU A  11     -18.666   3.628  32.527  1.00  0.00           C  
ATOM    169  O   GLU A  11     -19.068   2.628  31.935  1.00  0.00           O  
ATOM    170  CB  GLU A  11     -19.659   5.888  32.099  1.00  0.00           C  
ATOM    171  CG  GLU A  11     -20.763   6.903  32.403  1.00  0.00           C  
ATOM    172  CD  GLU A  11     -20.495   8.191  31.633  1.00  0.00           C  
ATOM    173  OE1 GLU A  11     -19.648   8.965  32.133  1.00  0.00           O  
ATOM    174  OE2 GLU A  11     -21.096   8.353  30.549  1.00  0.00           O  
ATOM    175  H   GLU A  11     -18.730   5.933  34.495  1.00  0.00           H  
ATOM    176  HA  GLU A  11     -20.657   4.247  33.055  1.00  0.00           H  
ATOM    177  HB2 GLU A  11     -18.698   6.390  32.169  1.00  0.00           H  
ATOM    178  HB3 GLU A  11     -19.791   5.536  31.075  1.00  0.00           H  
ATOM    179  HG2 GLU A  11     -21.728   6.492  32.107  1.00  0.00           H  
ATOM    180  HG3 GLU A  11     -20.787   7.128  33.469  1.00  0.00           H  
ATOM    181  N   LEU A  12     -17.366   3.858  32.747  1.00  0.00           N  
ATOM    182  CA  LEU A  12     -16.315   2.947  32.313  1.00  0.00           C  
ATOM    183  C   LEU A  12     -16.624   1.520  32.758  1.00  0.00           C  
ATOM    184  O   LEU A  12     -16.404   0.592  31.990  1.00  0.00           O  
ATOM    185  CB  LEU A  12     -14.938   3.397  32.817  1.00  0.00           C  
ATOM    186  CG  LEU A  12     -13.781   2.605  32.184  1.00  0.00           C  
ATOM    187  CD1 LEU A  12     -13.636   2.912  30.689  1.00  0.00           C  
ATOM    188  CD2 LEU A  12     -12.484   2.962  32.917  1.00  0.00           C  
ATOM    189  H   LEU A  12     -17.101   4.703  33.243  1.00  0.00           H  
ATOM    190  HA  LEU A  12     -16.328   2.971  31.223  1.00  0.00           H  
ATOM    191  HB2 LEU A  12     -14.799   4.458  32.613  1.00  0.00           H  
ATOM    192  HB3 LEU A  12     -14.893   3.240  33.892  1.00  0.00           H  
ATOM    193  HG  LEU A  12     -13.941   1.534  32.307  1.00  0.00           H  
ATOM    194 HD11 LEU A  12     -14.495   2.539  30.131  1.00  0.00           H  
ATOM    195 HD12 LEU A  12     -12.741   2.426  30.299  1.00  0.00           H  
ATOM    196 HD13 LEU A  12     -13.554   3.988  30.541  1.00  0.00           H  
ATOM    197 HD21 LEU A  12     -11.641   2.443  32.461  1.00  0.00           H  
ATOM    198 HD22 LEU A  12     -12.314   4.035  32.872  1.00  0.00           H  
ATOM    199 HD23 LEU A  12     -12.555   2.659  33.963  1.00  0.00           H  
ATOM    200  N   GLU A  13     -17.143   1.333  33.977  1.00  0.00           N  
ATOM    201  CA  GLU A  13     -17.560   0.014  34.436  1.00  0.00           C  
ATOM    202  C   GLU A  13     -18.505  -0.652  33.427  1.00  0.00           C  
ATOM    203  O   GLU A  13     -18.318  -1.817  33.078  1.00  0.00           O  
ATOM    204  CB  GLU A  13     -18.239   0.129  35.801  1.00  0.00           C  
ATOM    205  CG  GLU A  13     -17.248   0.481  36.919  1.00  0.00           C  
ATOM    206  CD  GLU A  13     -16.311  -0.682  37.234  1.00  0.00           C  
ATOM    207  OE1 GLU A  13     -16.784  -1.626  37.902  1.00  0.00           O  
ATOM    208  OE2 GLU A  13     -15.146  -0.617  36.787  1.00  0.00           O  
ATOM    209  H   GLU A  13     -17.223   2.126  34.610  1.00  0.00           H  
ATOM    210  HA  GLU A  13     -16.685  -0.621  34.538  1.00  0.00           H  
ATOM    211  HB2 GLU A  13     -19.000   0.899  35.728  1.00  0.00           H  
ATOM    212  HB3 GLU A  13     -18.739  -0.811  36.042  1.00  0.00           H  
ATOM    213  HG2 GLU A  13     -16.655   1.353  36.648  1.00  0.00           H  
ATOM    214  HG3 GLU A  13     -17.809   0.723  37.820  1.00  0.00           H  
ATOM    215  N   VAL A  14     -19.516   0.078  32.944  1.00  0.00           N  
ATOM    216  CA  VAL A  14     -20.463  -0.492  31.997  1.00  0.00           C  
ATOM    217  C   VAL A  14     -19.754  -0.771  30.676  1.00  0.00           C  
ATOM    218  O   VAL A  14     -19.959  -1.835  30.099  1.00  0.00           O  
ATOM    219  CB  VAL A  14     -21.770   0.321  31.874  1.00  0.00           C  
ATOM    220  CG1 VAL A  14     -22.098   1.054  33.179  1.00  0.00           C  
ATOM    221  CG2 VAL A  14     -21.873   1.290  30.687  1.00  0.00           C  
ATOM    222  H   VAL A  14     -19.557   1.073  33.132  1.00  0.00           H  
ATOM    223  HA  VAL A  14     -20.764  -1.460  32.399  1.00  0.00           H  
ATOM    224  HB  VAL A  14     -22.564  -0.412  31.719  1.00  0.00           H  
ATOM    225 HG11 VAL A  14     -21.443   1.915  33.307  1.00  0.00           H  
ATOM    226 HG12 VAL A  14     -23.132   1.391  33.143  1.00  0.00           H  
ATOM    227 HG13 VAL A  14     -21.976   0.387  34.031  1.00  0.00           H  
ATOM    228 HG21 VAL A  14     -21.769   0.753  29.745  1.00  0.00           H  
ATOM    229 HG22 VAL A  14     -22.857   1.761  30.694  1.00  0.00           H  
ATOM    230 HG23 VAL A  14     -21.118   2.068  30.741  1.00  0.00           H  
ATOM    231  N   MET A  15     -18.895   0.146  30.212  1.00  0.00           N  
ATOM    232  CA  MET A  15     -18.143  -0.094  28.983  1.00  0.00           C  
ATOM    233  C   MET A  15     -17.363  -1.404  29.097  1.00  0.00           C  
ATOM    234  O   MET A  15     -17.444  -2.269  28.231  1.00  0.00           O  
ATOM    235  CB  MET A  15     -17.138   1.016  28.676  1.00  0.00           C  
ATOM    236  CG  MET A  15     -17.721   2.416  28.608  1.00  0.00           C  
ATOM    237  SD  MET A  15     -16.570   3.615  27.900  1.00  0.00           S  
ATOM    238  CE  MET A  15     -17.076   3.531  26.171  1.00  0.00           C  
ATOM    239  H   MET A  15     -18.753   0.999  30.745  1.00  0.00           H  
ATOM    240  HA  MET A  15     -18.846  -0.149  28.153  1.00  0.00           H  
ATOM    241  HB2 MET A  15     -16.318   1.016  29.394  1.00  0.00           H  
ATOM    242  HB3 MET A  15     -16.745   0.793  27.688  1.00  0.00           H  
ATOM    243  HG2 MET A  15     -18.609   2.390  27.991  1.00  0.00           H  
ATOM    244  HG3 MET A  15     -17.992   2.736  29.607  1.00  0.00           H  
ATOM    245  HE1 MET A  15     -16.362   4.083  25.563  1.00  0.00           H  
ATOM    246  HE2 MET A  15     -17.103   2.489  25.857  1.00  0.00           H  
ATOM    247  HE3 MET A  15     -18.066   3.971  26.064  1.00  0.00           H  
ATOM    248  N   LYS A  16     -16.601  -1.519  30.184  1.00  0.00           N  
ATOM    249  CA  LYS A  16     -15.766  -2.654  30.523  1.00  0.00           C  
ATOM    250  C   LYS A  16     -16.593  -3.931  30.491  1.00  0.00           C  
ATOM    251  O   LYS A  16     -16.213  -4.878  29.809  1.00  0.00           O  
ATOM    252  CB  LYS A  16     -15.097  -2.377  31.874  1.00  0.00           C  
ATOM    253  CG  LYS A  16     -14.006  -3.392  32.219  1.00  0.00           C  
ATOM    254  CD  LYS A  16     -13.481  -3.214  33.654  1.00  0.00           C  
ATOM    255  CE  LYS A  16     -12.804  -1.856  33.908  1.00  0.00           C  
ATOM    256  NZ  LYS A  16     -13.761  -0.796  34.281  1.00  0.00           N  
ATOM    257  H   LYS A  16     -16.610  -0.745  30.835  1.00  0.00           H  
ATOM    258  HA  LYS A  16     -14.985  -2.759  29.777  1.00  0.00           H  
ATOM    259  HB2 LYS A  16     -14.628  -1.397  31.798  1.00  0.00           H  
ATOM    260  HB3 LYS A  16     -15.846  -2.362  32.664  1.00  0.00           H  
ATOM    261  HG2 LYS A  16     -14.418  -4.398  32.120  1.00  0.00           H  
ATOM    262  HG3 LYS A  16     -13.183  -3.292  31.509  1.00  0.00           H  
ATOM    263  HD2 LYS A  16     -14.289  -3.367  34.373  1.00  0.00           H  
ATOM    264  HD3 LYS A  16     -12.736  -3.994  33.821  1.00  0.00           H  
ATOM    265  HE2 LYS A  16     -12.107  -1.966  34.740  1.00  0.00           H  
ATOM    266  HE3 LYS A  16     -12.240  -1.550  33.026  1.00  0.00           H  
ATOM    267  HZ1 LYS A  16     -14.457  -0.671  33.561  1.00  0.00           H  
ATOM    268  HZ2 LYS A  16     -13.264   0.074  34.411  1.00  0.00           H  
ATOM    269  HZ3 LYS A  16     -14.224  -1.034  35.150  1.00  0.00           H  
ATOM    270  N   VAL A  17     -17.722  -3.956  31.204  1.00  0.00           N  
ATOM    271  CA  VAL A  17     -18.605  -5.115  31.199  1.00  0.00           C  
ATOM    272  C   VAL A  17     -19.033  -5.438  29.762  1.00  0.00           C  
ATOM    273  O   VAL A  17     -18.828  -6.553  29.284  1.00  0.00           O  
ATOM    274  CB  VAL A  17     -19.799  -4.843  32.135  1.00  0.00           C  
ATOM    275  CG1 VAL A  17     -20.958  -5.820  31.916  1.00  0.00           C  
ATOM    276  CG2 VAL A  17     -19.353  -4.959  33.598  1.00  0.00           C  
ATOM    277  H   VAL A  17     -17.991  -3.140  31.752  1.00  0.00           H  
ATOM    278  HA  VAL A  17     -18.056  -5.978  31.580  1.00  0.00           H  
ATOM    279  HB  VAL A  17     -20.177  -3.835  31.958  1.00  0.00           H  
ATOM    280 HG11 VAL A  17     -21.735  -5.621  32.652  1.00  0.00           H  
ATOM    281 HG12 VAL A  17     -20.601  -6.843  32.031  1.00  0.00           H  
ATOM    282 HG13 VAL A  17     -21.392  -5.689  30.925  1.00  0.00           H  
ATOM    283 HG21 VAL A  17     -18.519  -4.290  33.801  1.00  0.00           H  
ATOM    284 HG22 VAL A  17     -19.046  -5.983  33.813  1.00  0.00           H  
ATOM    285 HG23 VAL A  17     -20.181  -4.697  34.258  1.00  0.00           H  
ATOM    286  N   ILE A  18     -19.605  -4.452  29.069  1.00  0.00           N  
ATOM    287  CA  ILE A  18     -20.135  -4.616  27.721  1.00  0.00           C  
ATOM    288  C   ILE A  18     -19.071  -5.169  26.767  1.00  0.00           C  
ATOM    289  O   ILE A  18     -19.348  -6.109  26.027  1.00  0.00           O  
ATOM    290  CB  ILE A  18     -20.766  -3.290  27.248  1.00  0.00           C  
ATOM    291  CG1 ILE A  18     -22.037  -3.009  28.075  1.00  0.00           C  
ATOM    292  CG2 ILE A  18     -21.114  -3.336  25.753  1.00  0.00           C  
ATOM    293  CD1 ILE A  18     -22.586  -1.595  27.882  1.00  0.00           C  
ATOM    294  H   ILE A  18     -19.649  -3.530  29.488  1.00  0.00           H  
ATOM    295  HA  ILE A  18     -20.931  -5.362  27.766  1.00  0.00           H  
ATOM    296  HB  ILE A  18     -20.046  -2.486  27.402  1.00  0.00           H  
ATOM    297 HG12 ILE A  18     -22.819  -3.710  27.798  1.00  0.00           H  
ATOM    298 HG13 ILE A  18     -21.837  -3.143  29.137  1.00  0.00           H  
ATOM    299 HG21 ILE A  18     -21.812  -4.146  25.551  1.00  0.00           H  
ATOM    300 HG22 ILE A  18     -21.559  -2.394  25.435  1.00  0.00           H  
ATOM    301 HG23 ILE A  18     -20.212  -3.495  25.166  1.00  0.00           H  
ATOM    302 HD11 ILE A  18     -23.044  -1.505  26.899  1.00  0.00           H  
ATOM    303 HD12 ILE A  18     -21.781  -0.867  27.989  1.00  0.00           H  
ATOM    304 HD13 ILE A  18     -23.348  -1.398  28.636  1.00  0.00           H  
ATOM    305  N   TRP A  19     -17.852  -4.620  26.785  1.00  0.00           N  
ATOM    306  CA  TRP A  19     -16.769  -5.059  25.911  1.00  0.00           C  
ATOM    307  C   TRP A  19     -16.426  -6.548  26.082  1.00  0.00           C  
ATOM    308  O   TRP A  19     -15.803  -7.119  25.188  1.00  0.00           O  
ATOM    309  CB  TRP A  19     -15.528  -4.161  26.082  1.00  0.00           C  
ATOM    310  CG  TRP A  19     -15.548  -2.806  25.418  1.00  0.00           C  
ATOM    311  CD1 TRP A  19     -15.926  -2.562  24.141  1.00  0.00           C  
ATOM    312  CD2 TRP A  19     -15.083  -1.517  25.934  1.00  0.00           C  
ATOM    313  NE1 TRP A  19     -15.760  -1.225  23.838  1.00  0.00           N  
ATOM    314  CE2 TRP A  19     -15.240  -0.536  24.911  1.00  0.00           C  
ATOM    315  CE3 TRP A  19     -14.520  -1.073  27.151  1.00  0.00           C  
ATOM    316  CZ2 TRP A  19     -14.882   0.809  25.095  1.00  0.00           C  
ATOM    317  CZ3 TRP A  19     -14.211   0.285  27.365  1.00  0.00           C  
ATOM    318  CH2 TRP A  19     -14.398   1.230  26.343  1.00  0.00           C  
ATOM    319  H   TRP A  19     -17.673  -3.847  27.413  1.00  0.00           H  
ATOM    320  HA  TRP A  19     -17.118  -4.963  24.883  1.00  0.00           H  
ATOM    321  HB2 TRP A  19     -15.329  -4.036  27.147  1.00  0.00           H  
ATOM    322  HB3 TRP A  19     -14.674  -4.686  25.650  1.00  0.00           H  
ATOM    323  HD1 TRP A  19     -16.281  -3.308  23.445  1.00  0.00           H  
ATOM    324  HE1 TRP A  19     -15.951  -0.777  22.944  1.00  0.00           H  
ATOM    325  HE3 TRP A  19     -14.337  -1.787  27.935  1.00  0.00           H  
ATOM    326  HZ2 TRP A  19     -15.001   1.516  24.292  1.00  0.00           H  
ATOM    327  HZ3 TRP A  19     -13.895   0.621  28.342  1.00  0.00           H  
ATOM    328  HH2 TRP A  19     -14.228   2.282  26.537  1.00  0.00           H  
ATOM    329  N   LYS A  20     -16.801  -7.200  27.191  1.00  0.00           N  
ATOM    330  CA  LYS A  20     -16.553  -8.634  27.337  1.00  0.00           C  
ATOM    331  C   LYS A  20     -17.541  -9.455  26.498  1.00  0.00           C  
ATOM    332  O   LYS A  20     -17.297 -10.631  26.237  1.00  0.00           O  
ATOM    333  CB  LYS A  20     -16.663  -9.073  28.805  1.00  0.00           C  
ATOM    334  CG  LYS A  20     -15.850  -8.225  29.791  1.00  0.00           C  
ATOM    335  CD  LYS A  20     -14.382  -8.005  29.398  1.00  0.00           C  
ATOM    336  CE  LYS A  20     -13.602  -9.321  29.312  1.00  0.00           C  
ATOM    337  NZ  LYS A  20     -12.183  -9.078  29.000  1.00  0.00           N  
ATOM    338  H   LYS A  20     -17.338  -6.730  27.913  1.00  0.00           H  
ATOM    339  HA  LYS A  20     -15.548  -8.868  26.985  1.00  0.00           H  
ATOM    340  HB2 LYS A  20     -17.710  -9.024  29.109  1.00  0.00           H  
ATOM    341  HB3 LYS A  20     -16.346 -10.114  28.881  1.00  0.00           H  
ATOM    342  HG2 LYS A  20     -16.340  -7.259  29.868  1.00  0.00           H  
ATOM    343  HG3 LYS A  20     -15.896  -8.696  30.775  1.00  0.00           H  
ATOM    344  HD2 LYS A  20     -14.331  -7.476  28.447  1.00  0.00           H  
ATOM    345  HD3 LYS A  20     -13.926  -7.368  30.158  1.00  0.00           H  
ATOM    346  HE2 LYS A  20     -13.667  -9.848  30.266  1.00  0.00           H  
ATOM    347  HE3 LYS A  20     -14.020  -9.956  28.531  1.00  0.00           H  
ATOM    348  HZ1 LYS A  20     -11.692  -9.959  28.949  1.00  0.00           H  
ATOM    349  HZ2 LYS A  20     -12.108  -8.604  28.110  1.00  0.00           H  
ATOM    350  HZ3 LYS A  20     -11.768  -8.506  29.720  1.00  0.00           H  
ATOM    351  N   HIS A  21     -18.672  -8.857  26.119  1.00  0.00           N  
ATOM    352  CA  HIS A  21     -19.756  -9.503  25.395  1.00  0.00           C  
ATOM    353  C   HIS A  21     -19.695  -9.133  23.909  1.00  0.00           C  
ATOM    354  O   HIS A  21     -19.053  -8.150  23.546  1.00  0.00           O  
ATOM    355  CB  HIS A  21     -21.076  -9.044  26.033  1.00  0.00           C  
ATOM    356  CG  HIS A  21     -21.105  -9.129  27.537  1.00  0.00           C  
ATOM    357  ND1 HIS A  21     -21.728  -8.148  28.308  1.00  0.00           N  
ATOM    358  CD2 HIS A  21     -20.591 -10.088  28.371  1.00  0.00           C  
ATOM    359  CE1 HIS A  21     -21.560  -8.550  29.570  1.00  0.00           C  
ATOM    360  NE2 HIS A  21     -20.882  -9.705  29.663  1.00  0.00           N  
ATOM    361  H   HIS A  21     -18.786  -7.864  26.296  1.00  0.00           H  
ATOM    362  HA  HIS A  21     -19.682 -10.586  25.495  1.00  0.00           H  
ATOM    363  HB2 HIS A  21     -21.266  -8.008  25.747  1.00  0.00           H  
ATOM    364  HB3 HIS A  21     -21.893  -9.659  25.668  1.00  0.00           H  
ATOM    365  HD2 HIS A  21     -20.049 -10.973  28.070  1.00  0.00           H  
ATOM    366  HE1 HIS A  21     -21.951  -8.019  30.423  1.00  0.00           H  
ATOM    367  HE2 HIS A  21     -20.641 -10.203  30.508  1.00  0.00           H  
ATOM    368  N   SER A  22     -20.343  -9.909  23.031  1.00  0.00           N  
ATOM    369  CA  SER A  22     -20.392  -9.589  21.607  1.00  0.00           C  
ATOM    370  C   SER A  22     -21.238  -8.325  21.487  1.00  0.00           C  
ATOM    371  O   SER A  22     -20.806  -7.299  20.966  1.00  0.00           O  
ATOM    372  CB  SER A  22     -21.043 -10.774  20.887  1.00  0.00           C  
ATOM    373  OG  SER A  22     -22.111 -11.270  21.682  1.00  0.00           O  
ATOM    374  H   SER A  22     -20.917 -10.686  23.334  1.00  0.00           H  
ATOM    375  HA  SER A  22     -19.393  -9.406  21.209  1.00  0.00           H  
ATOM    376  HB2 SER A  22     -21.400 -10.463  19.904  1.00  0.00           H  
ATOM    377  HB3 SER A  22     -20.298 -11.563  20.760  1.00  0.00           H  
ATOM    378  HG  SER A  22     -22.508 -12.027  21.240  1.00  0.00           H  
ATOM    379  N   SER A  23     -22.491  -8.412  21.929  1.00  0.00           N  
ATOM    380  CA  SER A  23     -23.199  -7.224  22.360  1.00  0.00           C  
ATOM    381  C   SER A  23     -23.828  -7.610  23.702  1.00  0.00           C  
ATOM    382  O   SER A  23     -23.490  -8.668  24.228  1.00  0.00           O  
ATOM    383  CB  SER A  23     -24.208  -6.897  21.257  1.00  0.00           C  
ATOM    384  OG  SER A  23     -23.490  -6.558  20.085  1.00  0.00           O  
ATOM    385  H   SER A  23     -22.759  -9.293  22.357  1.00  0.00           H  
ATOM    386  HA  SER A  23     -22.530  -6.377  22.528  1.00  0.00           H  
ATOM    387  HB2 SER A  23     -24.832  -7.770  21.058  1.00  0.00           H  
ATOM    388  HB3 SER A  23     -24.855  -6.073  21.544  1.00  0.00           H  
ATOM    389  HG  SER A  23     -22.547  -6.702  20.247  1.00  0.00           H  
ATOM    390  N   ILE A  24     -24.841  -6.897  24.193  1.00  0.00           N  
ATOM    391  CA  ILE A  24     -25.647  -7.321  25.334  1.00  0.00           C  
ATOM    392  C   ILE A  24     -27.017  -6.655  25.215  1.00  0.00           C  
ATOM    393  O   ILE A  24     -27.084  -5.569  24.634  1.00  0.00           O  
ATOM    394  CB  ILE A  24     -24.888  -7.154  26.664  1.00  0.00           C  
ATOM    395  CG1 ILE A  24     -25.765  -7.492  27.883  1.00  0.00           C  
ATOM    396  CG2 ILE A  24     -24.243  -5.773  26.781  1.00  0.00           C  
ATOM    397  CD1 ILE A  24     -24.934  -7.806  29.132  1.00  0.00           C  
ATOM    398  H   ILE A  24     -25.118  -6.031  23.750  1.00  0.00           H  
ATOM    399  HA  ILE A  24     -25.832  -8.391  25.220  1.00  0.00           H  
ATOM    400  HB  ILE A  24     -24.073  -7.879  26.651  1.00  0.00           H  
ATOM    401 HG12 ILE A  24     -26.444  -6.670  28.101  1.00  0.00           H  
ATOM    402 HG13 ILE A  24     -26.352  -8.383  27.661  1.00  0.00           H  
ATOM    403 HG21 ILE A  24     -25.010  -5.004  26.827  1.00  0.00           H  
ATOM    404 HG22 ILE A  24     -23.630  -5.749  27.679  1.00  0.00           H  
ATOM    405 HG23 ILE A  24     -23.589  -5.584  25.932  1.00  0.00           H  
ATOM    406 HD11 ILE A  24     -24.356  -8.714  28.961  1.00  0.00           H  
ATOM    407 HD12 ILE A  24     -25.593  -7.972  29.982  1.00  0.00           H  
ATOM    408 HD13 ILE A  24     -24.261  -6.988  29.381  1.00  0.00           H  
ATOM    409  N   ASN A  25     -28.087  -7.262  25.742  1.00  0.00           N  
ATOM    410  CA  ASN A  25     -29.423  -6.663  25.758  1.00  0.00           C  
ATOM    411  C   ASN A  25     -29.675  -5.965  27.093  1.00  0.00           C  
ATOM    412  O   ASN A  25     -29.064  -6.319  28.099  1.00  0.00           O  
ATOM    413  CB  ASN A  25     -30.510  -7.708  25.491  1.00  0.00           C  
ATOM    414  CG  ASN A  25     -30.681  -8.688  26.647  1.00  0.00           C  
ATOM    415  OD1 ASN A  25     -31.204  -8.346  27.708  1.00  0.00           O  
ATOM    416  ND2 ASN A  25     -30.237  -9.923  26.451  1.00  0.00           N  
ATOM    417  H   ASN A  25     -27.951  -8.121  26.254  1.00  0.00           H  
ATOM    418  HA  ASN A  25     -29.505  -5.916  24.974  1.00  0.00           H  
ATOM    419  HB2 ASN A  25     -31.455  -7.185  25.354  1.00  0.00           H  
ATOM    420  HB3 ASN A  25     -30.285  -8.243  24.569  1.00  0.00           H  
ATOM    421 HD21 ASN A  25     -29.835 -10.205  25.570  1.00  0.00           H  
ATOM    422 HD22 ASN A  25     -30.418 -10.606  27.182  1.00  0.00           H  
ATOM    423  N   THR A  26     -30.599  -5.002  27.100  1.00  0.00           N  
ATOM    424  CA  THR A  26     -30.961  -4.217  28.268  1.00  0.00           C  
ATOM    425  C   THR A  26     -31.175  -5.043  29.534  1.00  0.00           C  
ATOM    426  O   THR A  26     -30.567  -4.730  30.551  1.00  0.00           O  
ATOM    427  CB  THR A  26     -32.201  -3.374  27.941  1.00  0.00           C  
ATOM    428  OG1 THR A  26     -32.159  -2.993  26.580  1.00  0.00           O  
ATOM    429  CG2 THR A  26     -32.279  -2.133  28.836  1.00  0.00           C  
ATOM    430  H   THR A  26     -31.008  -4.684  26.229  1.00  0.00           H  
ATOM    431  HA  THR A  26     -30.129  -3.546  28.477  1.00  0.00           H  
ATOM    432  HB  THR A  26     -33.102  -3.972  28.087  1.00  0.00           H  
ATOM    433  HG1 THR A  26     -31.396  -2.409  26.450  1.00  0.00           H  
ATOM    434 HG21 THR A  26     -31.380  -1.524  28.737  1.00  0.00           H  
ATOM    435 HG22 THR A  26     -32.380  -2.433  29.879  1.00  0.00           H  
ATOM    436 HG23 THR A  26     -33.144  -1.532  28.558  1.00  0.00           H  
ATOM    437  N   ASN A  27     -32.021  -6.079  29.509  1.00  0.00           N  
ATOM    438  CA  ASN A  27     -32.294  -6.841  30.726  1.00  0.00           C  
ATOM    439  C   ASN A  27     -30.992  -7.363  31.325  1.00  0.00           C  
ATOM    440  O   ASN A  27     -30.667  -7.059  32.472  1.00  0.00           O  
ATOM    441  CB  ASN A  27     -33.296  -7.972  30.477  1.00  0.00           C  
ATOM    442  CG  ASN A  27     -33.710  -8.602  31.805  1.00  0.00           C  
ATOM    443  OD1 ASN A  27     -34.615  -8.112  32.471  1.00  0.00           O  
ATOM    444  ND2 ASN A  27     -33.059  -9.683  32.220  1.00  0.00           N  
ATOM    445  H   ASN A  27     -32.404  -6.397  28.630  1.00  0.00           H  
ATOM    446  HA  ASN A  27     -32.742  -6.154  31.449  1.00  0.00           H  
ATOM    447  HB2 ASN A  27     -34.187  -7.558  30.004  1.00  0.00           H  
ATOM    448  HB3 ASN A  27     -32.872  -8.728  29.816  1.00  0.00           H  
ATOM    449 HD21 ASN A  27     -32.310 -10.095  31.670  1.00  0.00           H  
ATOM    450 HD22 ASN A  27     -33.347 -10.110  33.086  1.00  0.00           H  
ATOM    451  N   GLU A  28     -30.227  -8.113  30.530  1.00  0.00           N  
ATOM    452  CA  GLU A  28     -28.940  -8.627  30.942  1.00  0.00           C  
ATOM    453  C   GLU A  28     -28.016  -7.500  31.415  1.00  0.00           C  
ATOM    454  O   GLU A  28     -27.344  -7.664  32.430  1.00  0.00           O  
ATOM    455  CB  GLU A  28     -28.365  -9.414  29.764  1.00  0.00           C  
ATOM    456  CG  GLU A  28     -28.907 -10.846  29.720  1.00  0.00           C  
ATOM    457  CD  GLU A  28     -30.425 -11.016  29.763  1.00  0.00           C  
ATOM    458  OE1 GLU A  28     -30.986 -10.912  30.875  1.00  0.00           O  
ATOM    459  OE2 GLU A  28     -30.999 -11.288  28.688  1.00  0.00           O  
ATOM    460  H   GLU A  28     -30.532  -8.370  29.595  1.00  0.00           H  
ATOM    461  HA  GLU A  28     -29.077  -9.302  31.788  1.00  0.00           H  
ATOM    462  HB2 GLU A  28     -28.570  -8.898  28.825  1.00  0.00           H  
ATOM    463  HB3 GLU A  28     -27.283  -9.491  29.874  1.00  0.00           H  
ATOM    464  HG2 GLU A  28     -28.535 -11.295  28.805  1.00  0.00           H  
ATOM    465  HG3 GLU A  28     -28.505 -11.376  30.577  1.00  0.00           H  
ATOM    466  N   VAL A  29     -27.973  -6.367  30.706  1.00  0.00           N  
ATOM    467  CA  VAL A  29     -27.120  -5.247  31.092  1.00  0.00           C  
ATOM    468  C   VAL A  29     -27.500  -4.742  32.491  1.00  0.00           C  
ATOM    469  O   VAL A  29     -26.645  -4.689  33.375  1.00  0.00           O  
ATOM    470  CB  VAL A  29     -27.090  -4.160  29.986  1.00  0.00           C  
ATOM    471  CG1 VAL A  29     -27.757  -2.824  30.328  1.00  0.00           C  
ATOM    472  CG2 VAL A  29     -25.645  -3.842  29.593  1.00  0.00           C  
ATOM    473  H   VAL A  29     -28.542  -6.289  29.869  1.00  0.00           H  
ATOM    474  HA  VAL A  29     -26.109  -5.652  31.178  1.00  0.00           H  
ATOM    475  HB  VAL A  29     -27.572  -4.545  29.090  1.00  0.00           H  
ATOM    476 HG11 VAL A  29     -28.818  -2.947  30.524  1.00  0.00           H  
ATOM    477 HG12 VAL A  29     -27.274  -2.359  31.187  1.00  0.00           H  
ATOM    478 HG13 VAL A  29     -27.653  -2.163  29.471  1.00  0.00           H  
ATOM    479 HG21 VAL A  29     -25.118  -3.399  30.438  1.00  0.00           H  
ATOM    480 HG22 VAL A  29     -25.635  -3.143  28.757  1.00  0.00           H  
ATOM    481 HG23 VAL A  29     -25.137  -4.755  29.290  1.00  0.00           H  
ATOM    482  N   ILE A  30     -28.775  -4.397  32.710  1.00  0.00           N  
ATOM    483  CA  ILE A  30     -29.251  -3.923  33.999  1.00  0.00           C  
ATOM    484  C   ILE A  30     -28.943  -4.960  35.076  1.00  0.00           C  
ATOM    485  O   ILE A  30     -28.387  -4.598  36.109  1.00  0.00           O  
ATOM    486  CB  ILE A  30     -30.744  -3.536  33.939  1.00  0.00           C  
ATOM    487  CG1 ILE A  30     -30.924  -2.405  32.906  1.00  0.00           C  
ATOM    488  CG2 ILE A  30     -31.235  -3.084  35.327  1.00  0.00           C  
ATOM    489  CD1 ILE A  30     -32.279  -1.695  32.959  1.00  0.00           C  
ATOM    490  H   ILE A  30     -29.446  -4.444  31.951  1.00  0.00           H  
ATOM    491  HA  ILE A  30     -28.683  -3.030  34.256  1.00  0.00           H  
ATOM    492  HB  ILE A  30     -31.335  -4.400  33.628  1.00  0.00           H  
ATOM    493 HG12 ILE A  30     -30.133  -1.673  33.036  1.00  0.00           H  
ATOM    494 HG13 ILE A  30     -30.821  -2.806  31.905  1.00  0.00           H  
ATOM    495 HG21 ILE A  30     -32.302  -2.866  35.299  1.00  0.00           H  
ATOM    496 HG22 ILE A  30     -31.089  -3.870  36.067  1.00  0.00           H  
ATOM    497 HG23 ILE A  30     -30.693  -2.192  35.642  1.00  0.00           H  
ATOM    498 HD11 ILE A  30     -33.086  -2.427  32.926  1.00  0.00           H  
ATOM    499 HD12 ILE A  30     -32.359  -1.092  33.862  1.00  0.00           H  
ATOM    500 HD13 ILE A  30     -32.367  -1.031  32.098  1.00  0.00           H  
ATOM    501  N   LYS A  31     -29.278  -6.233  34.850  1.00  0.00           N  
ATOM    502  CA  LYS A  31     -29.006  -7.281  35.826  1.00  0.00           C  
ATOM    503  C   LYS A  31     -27.512  -7.324  36.172  1.00  0.00           C  
ATOM    504  O   LYS A  31     -27.148  -7.210  37.340  1.00  0.00           O  
ATOM    505  CB  LYS A  31     -29.500  -8.639  35.304  1.00  0.00           C  
ATOM    506  CG  LYS A  31     -31.029  -8.729  35.190  1.00  0.00           C  
ATOM    507  CD  LYS A  31     -31.727  -8.768  36.555  1.00  0.00           C  
ATOM    508  CE  LYS A  31     -33.237  -8.950  36.359  1.00  0.00           C  
ATOM    509  NZ  LYS A  31     -33.950  -8.942  37.648  1.00  0.00           N  
ATOM    510  H   LYS A  31     -29.723  -6.485  33.971  1.00  0.00           H  
ATOM    511  HA  LYS A  31     -29.540  -7.044  36.745  1.00  0.00           H  
ATOM    512  HB2 LYS A  31     -29.064  -8.817  34.319  1.00  0.00           H  
ATOM    513  HB3 LYS A  31     -29.153  -9.428  35.973  1.00  0.00           H  
ATOM    514  HG2 LYS A  31     -31.416  -7.884  34.623  1.00  0.00           H  
ATOM    515  HG3 LYS A  31     -31.267  -9.643  34.643  1.00  0.00           H  
ATOM    516  HD2 LYS A  31     -31.331  -9.594  37.147  1.00  0.00           H  
ATOM    517  HD3 LYS A  31     -31.550  -7.832  37.085  1.00  0.00           H  
ATOM    518  HE2 LYS A  31     -33.628  -8.141  35.739  1.00  0.00           H  
ATOM    519  HE3 LYS A  31     -33.431  -9.901  35.859  1.00  0.00           H  
ATOM    520  HZ1 LYS A  31     -33.796  -8.060  38.117  1.00  0.00           H  
ATOM    521  HZ2 LYS A  31     -34.941  -9.063  37.486  1.00  0.00           H  
ATOM    522  HZ3 LYS A  31     -33.614  -9.695  38.231  1.00  0.00           H  
ATOM    523  N   GLU A  32     -26.652  -7.473  35.160  1.00  0.00           N  
ATOM    524  CA  GLU A  32     -25.210  -7.555  35.331  1.00  0.00           C  
ATOM    525  C   GLU A  32     -24.685  -6.359  36.129  1.00  0.00           C  
ATOM    526  O   GLU A  32     -23.984  -6.532  37.131  1.00  0.00           O  
ATOM    527  CB  GLU A  32     -24.550  -7.653  33.948  1.00  0.00           C  
ATOM    528  CG  GLU A  32     -23.031  -7.857  34.016  1.00  0.00           C  
ATOM    529  CD  GLU A  32     -22.651  -9.209  34.611  1.00  0.00           C  
ATOM    530  OE1 GLU A  32     -22.605 -10.179  33.825  1.00  0.00           O  
ATOM    531  OE2 GLU A  32     -22.417  -9.246  35.839  1.00  0.00           O  
ATOM    532  H   GLU A  32     -27.010  -7.519  34.213  1.00  0.00           H  
ATOM    533  HA  GLU A  32     -24.995  -8.464  35.894  1.00  0.00           H  
ATOM    534  HB2 GLU A  32     -24.982  -8.495  33.404  1.00  0.00           H  
ATOM    535  HB3 GLU A  32     -24.755  -6.741  33.386  1.00  0.00           H  
ATOM    536  HG2 GLU A  32     -22.646  -7.819  32.999  1.00  0.00           H  
ATOM    537  HG3 GLU A  32     -22.558  -7.060  34.591  1.00  0.00           H  
ATOM    538  N   LEU A  33     -25.009  -5.138  35.690  1.00  0.00           N  
ATOM    539  CA  LEU A  33     -24.537  -3.965  36.404  1.00  0.00           C  
ATOM    540  C   LEU A  33     -25.097  -3.947  37.822  1.00  0.00           C  
ATOM    541  O   LEU A  33     -24.329  -3.739  38.749  1.00  0.00           O  
ATOM    542  CB  LEU A  33     -24.795  -2.651  35.653  1.00  0.00           C  
ATOM    543  CG  LEU A  33     -23.721  -2.275  34.609  1.00  0.00           C  
ATOM    544  CD1 LEU A  33     -22.291  -2.331  35.167  1.00  0.00           C  
ATOM    545  CD2 LEU A  33     -23.817  -3.122  33.336  1.00  0.00           C  
ATOM    546  H   LEU A  33     -25.599  -5.023  34.871  1.00  0.00           H  
ATOM    547  HA  LEU A  33     -23.467  -4.067  36.533  1.00  0.00           H  
ATOM    548  HB2 LEU A  33     -25.786  -2.664  35.198  1.00  0.00           H  
ATOM    549  HB3 LEU A  33     -24.777  -1.857  36.399  1.00  0.00           H  
ATOM    550  HG  LEU A  33     -23.908  -1.237  34.328  1.00  0.00           H  
ATOM    551 HD11 LEU A  33     -22.253  -1.863  36.151  1.00  0.00           H  
ATOM    552 HD12 LEU A  33     -21.612  -1.801  34.502  1.00  0.00           H  
ATOM    553 HD13 LEU A  33     -21.936  -3.358  35.238  1.00  0.00           H  
ATOM    554 HD21 LEU A  33     -23.672  -4.177  33.566  1.00  0.00           H  
ATOM    555 HD22 LEU A  33     -24.796  -2.979  32.881  1.00  0.00           H  
ATOM    556 HD23 LEU A  33     -23.053  -2.808  32.627  1.00  0.00           H  
ATOM    557  N   SER A  34     -26.390  -4.211  38.023  1.00  0.00           N  
ATOM    558  CA  SER A  34     -26.966  -4.233  39.364  1.00  0.00           C  
ATOM    559  C   SER A  34     -26.217  -5.211  40.275  1.00  0.00           C  
ATOM    560  O   SER A  34     -25.946  -4.899  41.430  1.00  0.00           O  
ATOM    561  CB  SER A  34     -28.457  -4.579  39.314  1.00  0.00           C  
ATOM    562  OG  SER A  34     -29.164  -3.642  38.527  1.00  0.00           O  
ATOM    563  H   SER A  34     -26.983  -4.424  37.232  1.00  0.00           H  
ATOM    564  HA  SER A  34     -26.865  -3.233  39.791  1.00  0.00           H  
ATOM    565  HB2 SER A  34     -28.595  -5.582  38.905  1.00  0.00           H  
ATOM    566  HB3 SER A  34     -28.857  -4.556  40.329  1.00  0.00           H  
ATOM    567  HG  SER A  34     -28.872  -3.730  37.612  1.00  0.00           H  
ATOM    568  N   LYS A  35     -25.888  -6.400  39.763  1.00  0.00           N  
ATOM    569  CA  LYS A  35     -25.168  -7.408  40.530  1.00  0.00           C  
ATOM    570  C   LYS A  35     -23.766  -6.917  40.900  1.00  0.00           C  
ATOM    571  O   LYS A  35     -23.353  -7.029  42.051  1.00  0.00           O  
ATOM    572  CB  LYS A  35     -25.082  -8.707  39.717  1.00  0.00           C  
ATOM    573  CG  LYS A  35     -26.447  -9.399  39.616  1.00  0.00           C  
ATOM    574  CD  LYS A  35     -26.403 -10.489  38.539  1.00  0.00           C  
ATOM    575  CE  LYS A  35     -27.762 -11.184  38.421  1.00  0.00           C  
ATOM    576  NZ  LYS A  35     -27.764 -12.173  37.328  1.00  0.00           N  
ATOM    577  H   LYS A  35     -26.149  -6.618  38.806  1.00  0.00           H  
ATOM    578  HA  LYS A  35     -25.710  -7.611  41.455  1.00  0.00           H  
ATOM    579  HB2 LYS A  35     -24.701  -8.480  38.721  1.00  0.00           H  
ATOM    580  HB3 LYS A  35     -24.381  -9.389  40.201  1.00  0.00           H  
ATOM    581  HG2 LYS A  35     -26.697  -9.838  40.584  1.00  0.00           H  
ATOM    582  HG3 LYS A  35     -27.217  -8.673  39.359  1.00  0.00           H  
ATOM    583  HD2 LYS A  35     -26.149 -10.028  37.582  1.00  0.00           H  
ATOM    584  HD3 LYS A  35     -25.633 -11.221  38.793  1.00  0.00           H  
ATOM    585  HE2 LYS A  35     -27.996 -11.692  39.358  1.00  0.00           H  
ATOM    586  HE3 LYS A  35     -28.536 -10.441  38.221  1.00  0.00           H  
ATOM    587  HZ1 LYS A  35     -27.564 -11.711  36.451  1.00  0.00           H  
ATOM    588  HZ2 LYS A  35     -28.670 -12.616  37.272  1.00  0.00           H  
ATOM    589  HZ3 LYS A  35     -27.060 -12.875  37.504  1.00  0.00           H  
ATOM    590  N   THR A  36     -23.024  -6.392  39.924  1.00  0.00           N  
ATOM    591  CA  THR A  36     -21.645  -5.963  40.138  1.00  0.00           C  
ATOM    592  C   THR A  36     -21.543  -4.658  40.942  1.00  0.00           C  
ATOM    593  O   THR A  36     -20.577  -4.448  41.674  1.00  0.00           O  
ATOM    594  CB  THR A  36     -20.911  -5.899  38.792  1.00  0.00           C  
ATOM    595  OG1 THR A  36     -21.654  -5.163  37.844  1.00  0.00           O  
ATOM    596  CG2 THR A  36     -20.696  -7.309  38.231  1.00  0.00           C  
ATOM    597  H   THR A  36     -23.430  -6.298  38.997  1.00  0.00           H  
ATOM    598  HA  THR A  36     -21.140  -6.723  40.737  1.00  0.00           H  
ATOM    599  HB  THR A  36     -19.940  -5.423  38.935  1.00  0.00           H  
ATOM    600  HG1 THR A  36     -22.406  -5.693  37.553  1.00  0.00           H  
ATOM    601 HG21 THR A  36     -20.084  -7.892  38.919  1.00  0.00           H  
ATOM    602 HG22 THR A  36     -21.651  -7.818  38.093  1.00  0.00           H  
ATOM    603 HG23 THR A  36     -20.188  -7.248  37.270  1.00  0.00           H  
ATOM    604  N   SER A  37     -22.485  -3.735  40.766  1.00  0.00           N  
ATOM    605  CA  SER A  37     -22.582  -2.470  41.479  1.00  0.00           C  
ATOM    606  C   SER A  37     -24.065  -2.128  41.634  1.00  0.00           C  
ATOM    607  O   SER A  37     -24.712  -1.746  40.663  1.00  0.00           O  
ATOM    608  CB  SER A  37     -21.808  -1.395  40.715  1.00  0.00           C  
ATOM    609  OG  SER A  37     -20.428  -1.709  40.734  1.00  0.00           O  
ATOM    610  H   SER A  37     -23.227  -3.937  40.110  1.00  0.00           H  
ATOM    611  HA  SER A  37     -22.143  -2.569  42.473  1.00  0.00           H  
ATOM    612  HB2 SER A  37     -22.169  -1.340  39.685  1.00  0.00           H  
ATOM    613  HB3 SER A  37     -21.961  -0.429  41.195  1.00  0.00           H  
ATOM    614  HG  SER A  37     -20.314  -2.618  41.045  1.00  0.00           H  
ATOM    615  N   THR A  38     -24.601  -2.245  42.850  1.00  0.00           N  
ATOM    616  CA  THR A  38     -26.013  -2.058  43.149  1.00  0.00           C  
ATOM    617  C   THR A  38     -26.479  -0.607  42.984  1.00  0.00           C  
ATOM    618  O   THR A  38     -26.759   0.066  43.976  1.00  0.00           O  
ATOM    619  CB  THR A  38     -26.265  -2.576  44.571  1.00  0.00           C  
ATOM    620  OG1 THR A  38     -25.362  -1.935  45.447  1.00  0.00           O  
ATOM    621  CG2 THR A  38     -26.058  -4.091  44.671  1.00  0.00           C  
ATOM    622  H   THR A  38     -24.026  -2.521  43.633  1.00  0.00           H  
ATOM    623  HA  THR A  38     -26.608  -2.662  42.463  1.00  0.00           H  
ATOM    624  HB  THR A  38     -27.291  -2.348  44.869  1.00  0.00           H  
ATOM    625  HG1 THR A  38     -25.572  -0.992  45.425  1.00  0.00           H  
ATOM    626 HG21 THR A  38     -26.246  -4.414  45.695  1.00  0.00           H  
ATOM    627 HG22 THR A  38     -25.039  -4.365  44.398  1.00  0.00           H  
ATOM    628 HG23 THR A  38     -26.754  -4.604  44.006  1.00  0.00           H  
ATOM    629  N   TRP A  39     -26.560  -0.132  41.741  1.00  0.00           N  
ATOM    630  CA  TRP A  39     -27.089   1.169  41.383  1.00  0.00           C  
ATOM    631  C   TRP A  39     -28.555   0.999  40.976  1.00  0.00           C  
ATOM    632  O   TRP A  39     -28.969  -0.083  40.561  1.00  0.00           O  
ATOM    633  CB  TRP A  39     -26.289   1.731  40.205  1.00  0.00           C  
ATOM    634  CG  TRP A  39     -24.819   1.945  40.407  1.00  0.00           C  
ATOM    635  CD1 TRP A  39     -24.252   2.516  41.493  1.00  0.00           C  
ATOM    636  CD2 TRP A  39     -23.718   1.680  39.483  1.00  0.00           C  
ATOM    637  NE1 TRP A  39     -22.888   2.620  41.315  1.00  0.00           N  
ATOM    638  CE2 TRP A  39     -22.507   2.135  40.082  1.00  0.00           C  
ATOM    639  CE3 TRP A  39     -23.618   1.114  38.192  1.00  0.00           C  
ATOM    640  CZ2 TRP A  39     -21.267   2.042  39.432  1.00  0.00           C  
ATOM    641  CZ3 TRP A  39     -22.381   1.025  37.527  1.00  0.00           C  
ATOM    642  CH2 TRP A  39     -21.208   1.490  38.145  1.00  0.00           C  
ATOM    643  H   TRP A  39     -26.221  -0.713  40.983  1.00  0.00           H  
ATOM    644  HA  TRP A  39     -27.025   1.856  42.228  1.00  0.00           H  
ATOM    645  HB2 TRP A  39     -26.425   1.073  39.345  1.00  0.00           H  
ATOM    646  HB3 TRP A  39     -26.721   2.697  39.964  1.00  0.00           H  
ATOM    647  HD1 TRP A  39     -24.791   2.868  42.360  1.00  0.00           H  
ATOM    648  HE1 TRP A  39     -22.237   3.016  41.979  1.00  0.00           H  
ATOM    649  HE3 TRP A  39     -24.503   0.745  37.703  1.00  0.00           H  
ATOM    650  HZ2 TRP A  39     -20.367   2.392  39.917  1.00  0.00           H  
ATOM    651  HZ3 TRP A  39     -22.337   0.602  36.533  1.00  0.00           H  
ATOM    652  HH2 TRP A  39     -20.262   1.423  37.630  1.00  0.00           H  
ATOM    653  N   SER A  40     -29.355   2.064  41.083  1.00  0.00           N  
ATOM    654  CA  SER A  40     -30.747   2.014  40.650  1.00  0.00           C  
ATOM    655  C   SER A  40     -30.777   1.818  39.126  1.00  0.00           C  
ATOM    656  O   SER A  40     -29.911   2.384  38.458  1.00  0.00           O  
ATOM    657  CB  SER A  40     -31.441   3.332  41.025  1.00  0.00           C  
ATOM    658  OG  SER A  40     -32.785   3.332  40.584  1.00  0.00           O  
ATOM    659  H   SER A  40     -28.963   2.935  41.409  1.00  0.00           H  
ATOM    660  HA  SER A  40     -31.239   1.194  41.172  1.00  0.00           H  
ATOM    661  HB2 SER A  40     -31.414   3.474  42.107  1.00  0.00           H  
ATOM    662  HB3 SER A  40     -30.927   4.168  40.549  1.00  0.00           H  
ATOM    663  HG  SER A  40     -33.327   2.852  41.218  1.00  0.00           H  
ATOM    664  N   PRO A  41     -31.744   1.080  38.552  1.00  0.00           N  
ATOM    665  CA  PRO A  41     -31.885   0.923  37.108  1.00  0.00           C  
ATOM    666  C   PRO A  41     -31.765   2.251  36.351  1.00  0.00           C  
ATOM    667  O   PRO A  41     -31.152   2.306  35.285  1.00  0.00           O  
ATOM    668  CB  PRO A  41     -33.255   0.272  36.907  1.00  0.00           C  
ATOM    669  CG  PRO A  41     -33.386  -0.592  38.160  1.00  0.00           C  
ATOM    670  CD  PRO A  41     -32.743   0.277  39.241  1.00  0.00           C  
ATOM    671  HA  PRO A  41     -31.115   0.235  36.761  1.00  0.00           H  
ATOM    672  HB2 PRO A  41     -34.040   1.031  36.910  1.00  0.00           H  
ATOM    673  HB3 PRO A  41     -33.305  -0.315  35.990  1.00  0.00           H  
ATOM    674  HG2 PRO A  41     -34.423  -0.844  38.386  1.00  0.00           H  
ATOM    675  HG3 PRO A  41     -32.799  -1.503  38.031  1.00  0.00           H  
ATOM    676  HD2 PRO A  41     -33.496   0.928  39.687  1.00  0.00           H  
ATOM    677  HD3 PRO A  41     -32.298  -0.367  40.002  1.00  0.00           H  
ATOM    678  N   LYS A  42     -32.324   3.329  36.917  1.00  0.00           N  
ATOM    679  CA  LYS A  42     -32.246   4.672  36.356  1.00  0.00           C  
ATOM    680  C   LYS A  42     -30.792   5.043  36.045  1.00  0.00           C  
ATOM    681  O   LYS A  42     -30.506   5.643  35.011  1.00  0.00           O  
ATOM    682  CB  LYS A  42     -32.901   5.660  37.335  1.00  0.00           C  
ATOM    683  CG  LYS A  42     -32.994   7.097  36.794  1.00  0.00           C  
ATOM    684  CD  LYS A  42     -31.795   7.967  37.209  1.00  0.00           C  
ATOM    685  CE  LYS A  42     -31.850   9.352  36.553  1.00  0.00           C  
ATOM    686  NZ  LYS A  42     -33.036  10.121  36.973  1.00  0.00           N  
ATOM    687  H   LYS A  42     -32.805   3.216  37.799  1.00  0.00           H  
ATOM    688  HA  LYS A  42     -32.815   4.682  35.424  1.00  0.00           H  
ATOM    689  HB2 LYS A  42     -33.919   5.311  37.513  1.00  0.00           H  
ATOM    690  HB3 LYS A  42     -32.371   5.655  38.290  1.00  0.00           H  
ATOM    691  HG2 LYS A  42     -33.089   7.075  35.707  1.00  0.00           H  
ATOM    692  HG3 LYS A  42     -33.899   7.543  37.208  1.00  0.00           H  
ATOM    693  HD2 LYS A  42     -31.781   8.078  38.295  1.00  0.00           H  
ATOM    694  HD3 LYS A  42     -30.857   7.506  36.905  1.00  0.00           H  
ATOM    695  HE2 LYS A  42     -30.955   9.911  36.834  1.00  0.00           H  
ATOM    696  HE3 LYS A  42     -31.856   9.245  35.467  1.00  0.00           H  
ATOM    697  HZ1 LYS A  42     -33.014  11.035  36.543  1.00  0.00           H  
ATOM    698  HZ2 LYS A  42     -33.875   9.639  36.683  1.00  0.00           H  
ATOM    699  HZ3 LYS A  42     -33.036  10.225  37.978  1.00  0.00           H  
ATOM    700  N   THR A  43     -29.869   4.685  36.940  1.00  0.00           N  
ATOM    701  CA  THR A  43     -28.445   4.927  36.778  1.00  0.00           C  
ATOM    702  C   THR A  43     -27.979   4.280  35.475  1.00  0.00           C  
ATOM    703  O   THR A  43     -27.357   4.930  34.637  1.00  0.00           O  
ATOM    704  CB  THR A  43     -27.679   4.339  37.977  1.00  0.00           C  
ATOM    705  OG1 THR A  43     -28.411   4.522  39.172  1.00  0.00           O  
ATOM    706  CG2 THR A  43     -26.289   4.954  38.136  1.00  0.00           C  
ATOM    707  H   THR A  43     -30.153   4.125  37.733  1.00  0.00           H  
ATOM    708  HA  THR A  43     -28.281   6.005  36.735  1.00  0.00           H  
ATOM    709  HB  THR A  43     -27.548   3.265  37.830  1.00  0.00           H  
ATOM    710  HG1 THR A  43     -29.017   3.775  39.232  1.00  0.00           H  
ATOM    711 HG21 THR A  43     -26.370   6.030  38.286  1.00  0.00           H  
ATOM    712 HG22 THR A  43     -25.782   4.517  38.997  1.00  0.00           H  
ATOM    713 HG23 THR A  43     -25.705   4.744  37.244  1.00  0.00           H  
ATOM    714  N   ILE A  44     -28.321   3.000  35.297  1.00  0.00           N  
ATOM    715  CA  ILE A  44     -27.930   2.242  34.121  1.00  0.00           C  
ATOM    716  C   ILE A  44     -28.509   2.918  32.884  1.00  0.00           C  
ATOM    717  O   ILE A  44     -27.792   3.166  31.919  1.00  0.00           O  
ATOM    718  CB  ILE A  44     -28.365   0.769  34.227  1.00  0.00           C  
ATOM    719  CG1 ILE A  44     -28.081   0.145  35.605  1.00  0.00           C  
ATOM    720  CG2 ILE A  44     -27.675  -0.036  33.115  1.00  0.00           C  
ATOM    721  CD1 ILE A  44     -26.642   0.327  36.089  1.00  0.00           C  
ATOM    722  H   ILE A  44     -28.956   2.571  35.956  1.00  0.00           H  
ATOM    723  HA  ILE A  44     -26.842   2.270  34.053  1.00  0.00           H  
ATOM    724  HB  ILE A  44     -29.441   0.697  34.064  1.00  0.00           H  
ATOM    725 HG12 ILE A  44     -28.748   0.574  36.351  1.00  0.00           H  
ATOM    726 HG13 ILE A  44     -28.292  -0.922  35.552  1.00  0.00           H  
ATOM    727 HG21 ILE A  44     -26.595   0.112  33.140  1.00  0.00           H  
ATOM    728 HG22 ILE A  44     -28.048   0.284  32.142  1.00  0.00           H  
ATOM    729 HG23 ILE A  44     -27.883  -1.098  33.232  1.00  0.00           H  
ATOM    730 HD11 ILE A  44     -26.519  -0.238  37.015  1.00  0.00           H  
ATOM    731 HD12 ILE A  44     -26.431   1.377  36.290  1.00  0.00           H  
ATOM    732 HD13 ILE A  44     -25.938  -0.044  35.347  1.00  0.00           H  
ATOM    733  N   GLN A  45     -29.803   3.247  32.921  1.00  0.00           N  
ATOM    734  CA  GLN A  45     -30.464   3.934  31.825  1.00  0.00           C  
ATOM    735  C   GLN A  45     -29.732   5.237  31.487  1.00  0.00           C  
ATOM    736  O   GLN A  45     -29.523   5.533  30.314  1.00  0.00           O  
ATOM    737  CB  GLN A  45     -31.937   4.159  32.167  1.00  0.00           C  
ATOM    738  CG  GLN A  45     -32.695   2.823  32.189  1.00  0.00           C  
ATOM    739  CD  GLN A  45     -32.862   2.215  30.799  1.00  0.00           C  
ATOM    740  OE1 GLN A  45     -32.278   1.184  30.484  1.00  0.00           O  
ATOM    741  NE2 GLN A  45     -33.670   2.846  29.951  1.00  0.00           N  
ATOM    742  H   GLN A  45     -30.342   3.015  33.752  1.00  0.00           H  
ATOM    743  HA  GLN A  45     -30.436   3.296  30.945  1.00  0.00           H  
ATOM    744  HB2 GLN A  45     -32.019   4.641  33.139  1.00  0.00           H  
ATOM    745  HB3 GLN A  45     -32.382   4.816  31.421  1.00  0.00           H  
ATOM    746  HG2 GLN A  45     -32.187   2.105  32.834  1.00  0.00           H  
ATOM    747  HG3 GLN A  45     -33.682   3.006  32.599  1.00  0.00           H  
ATOM    748 HE21 GLN A  45     -34.139   3.694  30.226  1.00  0.00           H  
ATOM    749 HE22 GLN A  45     -33.811   2.450  29.036  1.00  0.00           H  
ATOM    750  N   THR A  46     -29.317   6.002  32.500  1.00  0.00           N  
ATOM    751  CA  THR A  46     -28.579   7.244  32.297  1.00  0.00           C  
ATOM    752  C   THR A  46     -27.243   6.961  31.596  1.00  0.00           C  
ATOM    753  O   THR A  46     -26.916   7.607  30.602  1.00  0.00           O  
ATOM    754  CB  THR A  46     -28.392   7.980  33.635  1.00  0.00           C  
ATOM    755  OG1 THR A  46     -29.645   8.159  34.267  1.00  0.00           O  
ATOM    756  CG2 THR A  46     -27.773   9.365  33.431  1.00  0.00           C  
ATOM    757  H   THR A  46     -29.516   5.702  33.447  1.00  0.00           H  
ATOM    758  HA  THR A  46     -29.175   7.885  31.647  1.00  0.00           H  
ATOM    759  HB  THR A  46     -27.742   7.404  34.294  1.00  0.00           H  
ATOM    760  HG1 THR A  46     -30.028   7.293  34.456  1.00  0.00           H  
ATOM    761 HG21 THR A  46     -26.774   9.280  33.001  1.00  0.00           H  
ATOM    762 HG22 THR A  46     -27.698   9.873  34.393  1.00  0.00           H  
ATOM    763 HG23 THR A  46     -28.401   9.959  32.766  1.00  0.00           H  
ATOM    764  N   MET A  47     -26.463   6.001  32.106  1.00  0.00           N  
ATOM    765  CA  MET A  47     -25.189   5.613  31.513  1.00  0.00           C  
ATOM    766  C   MET A  47     -25.387   5.213  30.047  1.00  0.00           C  
ATOM    767  O   MET A  47     -24.711   5.730  29.159  1.00  0.00           O  
ATOM    768  CB  MET A  47     -24.581   4.470  32.334  1.00  0.00           C  
ATOM    769  CG  MET A  47     -24.211   4.950  33.741  1.00  0.00           C  
ATOM    770  SD  MET A  47     -23.732   3.634  34.884  1.00  0.00           S  
ATOM    771  CE  MET A  47     -22.940   4.636  36.155  1.00  0.00           C  
ATOM    772  H   MET A  47     -26.758   5.507  32.945  1.00  0.00           H  
ATOM    773  HA  MET A  47     -24.510   6.467  31.544  1.00  0.00           H  
ATOM    774  HB2 MET A  47     -25.289   3.646  32.410  1.00  0.00           H  
ATOM    775  HB3 MET A  47     -23.677   4.109  31.841  1.00  0.00           H  
ATOM    776  HG2 MET A  47     -23.394   5.657  33.648  1.00  0.00           H  
ATOM    777  HG3 MET A  47     -25.037   5.480  34.205  1.00  0.00           H  
ATOM    778  HE1 MET A  47     -23.629   5.396  36.515  1.00  0.00           H  
ATOM    779  HE2 MET A  47     -22.066   5.117  35.723  1.00  0.00           H  
ATOM    780  HE3 MET A  47     -22.644   3.984  36.976  1.00  0.00           H  
ATOM    781  N   LEU A  48     -26.328   4.303  29.790  1.00  0.00           N  
ATOM    782  CA  LEU A  48     -26.649   3.874  28.436  1.00  0.00           C  
ATOM    783  C   LEU A  48     -26.982   5.096  27.583  1.00  0.00           C  
ATOM    784  O   LEU A  48     -26.402   5.283  26.517  1.00  0.00           O  
ATOM    785  CB  LEU A  48     -27.833   2.900  28.451  1.00  0.00           C  
ATOM    786  CG  LEU A  48     -27.513   1.542  29.094  1.00  0.00           C  
ATOM    787  CD1 LEU A  48     -28.835   0.796  29.300  1.00  0.00           C  
ATOM    788  CD2 LEU A  48     -26.562   0.717  28.219  1.00  0.00           C  
ATOM    789  H   LEU A  48     -26.857   3.915  30.563  1.00  0.00           H  
ATOM    790  HA  LEU A  48     -25.776   3.392  27.998  1.00  0.00           H  
ATOM    791  HB2 LEU A  48     -28.656   3.365  28.995  1.00  0.00           H  
ATOM    792  HB3 LEU A  48     -28.163   2.730  27.425  1.00  0.00           H  
ATOM    793  HG  LEU A  48     -27.043   1.680  30.065  1.00  0.00           H  
ATOM    794 HD11 LEU A  48     -28.655  -0.181  29.741  1.00  0.00           H  
ATOM    795 HD12 LEU A  48     -29.349   0.675  28.348  1.00  0.00           H  
ATOM    796 HD13 LEU A  48     -29.476   1.361  29.977  1.00  0.00           H  
ATOM    797 HD21 LEU A  48     -25.574   1.175  28.195  1.00  0.00           H  
ATOM    798 HD22 LEU A  48     -26.460  -0.288  28.627  1.00  0.00           H  
ATOM    799 HD23 LEU A  48     -26.947   0.653  27.204  1.00  0.00           H  
ATOM    800  N   LEU A  49     -27.902   5.938  28.059  1.00  0.00           N  
ATOM    801  CA  LEU A  49     -28.323   7.131  27.347  1.00  0.00           C  
ATOM    802  C   LEU A  49     -27.116   7.999  26.984  1.00  0.00           C  
ATOM    803  O   LEU A  49     -27.019   8.442  25.844  1.00  0.00           O  
ATOM    804  CB  LEU A  49     -29.380   7.886  28.166  1.00  0.00           C  
ATOM    805  CG  LEU A  49     -29.922   9.136  27.450  1.00  0.00           C  
ATOM    806  CD1 LEU A  49     -31.411   9.297  27.769  1.00  0.00           C  
ATOM    807  CD2 LEU A  49     -29.181  10.408  27.890  1.00  0.00           C  
ATOM    808  H   LEU A  49     -28.344   5.736  28.950  1.00  0.00           H  
ATOM    809  HA  LEU A  49     -28.801   6.781  26.429  1.00  0.00           H  
ATOM    810  HB2 LEU A  49     -30.205   7.191  28.329  1.00  0.00           H  
ATOM    811  HB3 LEU A  49     -28.978   8.165  29.139  1.00  0.00           H  
ATOM    812  HG  LEU A  49     -29.825   9.017  26.370  1.00  0.00           H  
ATOM    813 HD11 LEU A  49     -31.800  10.187  27.273  1.00  0.00           H  
ATOM    814 HD12 LEU A  49     -31.552   9.392  28.846  1.00  0.00           H  
ATOM    815 HD13 LEU A  49     -31.961   8.429  27.408  1.00  0.00           H  
ATOM    816 HD21 LEU A  49     -28.134  10.374  27.598  1.00  0.00           H  
ATOM    817 HD22 LEU A  49     -29.245  10.523  28.973  1.00  0.00           H  
ATOM    818 HD23 LEU A  49     -29.640  11.279  27.422  1.00  0.00           H  
ATOM    819  N   ARG A  50     -26.201   8.245  27.930  1.00  0.00           N  
ATOM    820  CA  ARG A  50     -24.982   9.008  27.681  1.00  0.00           C  
ATOM    821  C   ARG A  50     -24.216   8.396  26.505  1.00  0.00           C  
ATOM    822  O   ARG A  50     -24.002   9.052  25.485  1.00  0.00           O  
ATOM    823  CB  ARG A  50     -24.108   9.039  28.948  1.00  0.00           C  
ATOM    824  CG  ARG A  50     -24.487  10.182  29.896  1.00  0.00           C  
ATOM    825  CD  ARG A  50     -23.816  11.505  29.491  1.00  0.00           C  
ATOM    826  NE  ARG A  50     -22.353  11.472  29.674  1.00  0.00           N  
ATOM    827  CZ  ARG A  50     -21.720  11.611  30.851  1.00  0.00           C  
ATOM    828  NH1 ARG A  50     -22.422  11.742  31.980  1.00  0.00           N  
ATOM    829  NH2 ARG A  50     -20.385  11.620  30.915  1.00  0.00           N  
ATOM    830  H   ARG A  50     -26.348   7.863  28.860  1.00  0.00           H  
ATOM    831  HA  ARG A  50     -25.255  10.026  27.401  1.00  0.00           H  
ATOM    832  HB2 ARG A  50     -24.213   8.102  29.489  1.00  0.00           H  
ATOM    833  HB3 ARG A  50     -23.059   9.139  28.683  1.00  0.00           H  
ATOM    834  HG2 ARG A  50     -25.572  10.290  29.896  1.00  0.00           H  
ATOM    835  HG3 ARG A  50     -24.171   9.910  30.903  1.00  0.00           H  
ATOM    836  HD2 ARG A  50     -24.028  11.714  28.442  1.00  0.00           H  
ATOM    837  HD3 ARG A  50     -24.241  12.324  30.073  1.00  0.00           H  
ATOM    838  HE  ARG A  50     -21.796  11.363  28.840  1.00  0.00           H  
ATOM    839 HH11 ARG A  50     -23.428  11.721  31.939  1.00  0.00           H  
ATOM    840 HH12 ARG A  50     -21.961  11.850  32.871  1.00  0.00           H  
ATOM    841 HH21 ARG A  50     -19.794  11.504  30.097  1.00  0.00           H  
ATOM    842 HH22 ARG A  50     -19.919  11.680  31.806  1.00  0.00           H  
ATOM    843  N   LEU A  51     -23.792   7.140  26.649  1.00  0.00           N  
ATOM    844  CA  LEU A  51     -23.059   6.412  25.637  1.00  0.00           C  
ATOM    845  C   LEU A  51     -23.773   6.410  24.279  1.00  0.00           C  
ATOM    846  O   LEU A  51     -23.114   6.493  23.245  1.00  0.00           O  
ATOM    847  CB  LEU A  51     -22.799   5.006  26.185  1.00  0.00           C  
ATOM    848  CG  LEU A  51     -21.581   4.997  27.122  1.00  0.00           C  
ATOM    849  CD1 LEU A  51     -21.506   6.094  28.187  1.00  0.00           C  
ATOM    850  CD2 LEU A  51     -21.426   3.626  27.788  1.00  0.00           C  
ATOM    851  H   LEU A  51     -23.910   6.647  27.529  1.00  0.00           H  
ATOM    852  HA  LEU A  51     -22.105   6.914  25.479  1.00  0.00           H  
ATOM    853  HB2 LEU A  51     -23.685   4.630  26.697  1.00  0.00           H  
ATOM    854  HB3 LEU A  51     -22.578   4.342  25.351  1.00  0.00           H  
ATOM    855  HG  LEU A  51     -20.738   5.198  26.484  1.00  0.00           H  
ATOM    856 HD11 LEU A  51     -22.372   6.073  28.837  1.00  0.00           H  
ATOM    857 HD12 LEU A  51     -20.625   5.924  28.797  1.00  0.00           H  
ATOM    858 HD13 LEU A  51     -21.405   7.074  27.722  1.00  0.00           H  
ATOM    859 HD21 LEU A  51     -20.568   3.632  28.461  1.00  0.00           H  
ATOM    860 HD22 LEU A  51     -21.266   2.860  27.031  1.00  0.00           H  
ATOM    861 HD23 LEU A  51     -22.322   3.389  28.362  1.00  0.00           H  
ATOM    862  N   ILE A  52     -25.101   6.311  24.252  1.00  0.00           N  
ATOM    863  CA  ILE A  52     -25.854   6.372  23.008  1.00  0.00           C  
ATOM    864  C   ILE A  52     -25.763   7.786  22.425  1.00  0.00           C  
ATOM    865  O   ILE A  52     -25.367   7.960  21.275  1.00  0.00           O  
ATOM    866  CB  ILE A  52     -27.299   5.906  23.254  1.00  0.00           C  
ATOM    867  CG1 ILE A  52     -27.278   4.407  23.604  1.00  0.00           C  
ATOM    868  CG2 ILE A  52     -28.176   6.152  22.016  1.00  0.00           C  
ATOM    869  CD1 ILE A  52     -28.592   3.934  24.229  1.00  0.00           C  
ATOM    870  H   ILE A  52     -25.611   6.145  25.113  1.00  0.00           H  
ATOM    871  HA  ILE A  52     -25.401   5.695  22.285  1.00  0.00           H  
ATOM    872  HB  ILE A  52     -27.716   6.468  24.090  1.00  0.00           H  
ATOM    873 HG12 ILE A  52     -27.054   3.831  22.710  1.00  0.00           H  
ATOM    874 HG13 ILE A  52     -26.488   4.190  24.320  1.00  0.00           H  
ATOM    875 HG21 ILE A  52     -27.741   5.657  21.146  1.00  0.00           H  
ATOM    876 HG22 ILE A  52     -29.182   5.772  22.179  1.00  0.00           H  
ATOM    877 HG23 ILE A  52     -28.258   7.220  21.810  1.00  0.00           H  
ATOM    878 HD11 ILE A  52     -29.414   3.999  23.519  1.00  0.00           H  
ATOM    879 HD12 ILE A  52     -28.473   2.897  24.536  1.00  0.00           H  
ATOM    880 HD13 ILE A  52     -28.824   4.536  25.107  1.00  0.00           H  
ATOM    881  N   LYS A  53     -26.110   8.798  23.222  1.00  0.00           N  
ATOM    882  CA  LYS A  53     -26.111  10.198  22.821  1.00  0.00           C  
ATOM    883  C   LYS A  53     -24.760  10.616  22.235  1.00  0.00           C  
ATOM    884  O   LYS A  53     -24.723  11.305  21.213  1.00  0.00           O  
ATOM    885  CB  LYS A  53     -26.522  11.063  24.021  1.00  0.00           C  
ATOM    886  CG  LYS A  53     -26.674  12.546  23.648  1.00  0.00           C  
ATOM    887  CD  LYS A  53     -27.327  13.352  24.782  1.00  0.00           C  
ATOM    888  CE  LYS A  53     -28.846  13.511  24.611  1.00  0.00           C  
ATOM    889  NZ  LYS A  53     -29.547  12.219  24.532  1.00  0.00           N  
ATOM    890  H   LYS A  53     -26.379   8.586  24.175  1.00  0.00           H  
ATOM    891  HA  LYS A  53     -26.868  10.315  22.044  1.00  0.00           H  
ATOM    892  HB2 LYS A  53     -27.468  10.680  24.399  1.00  0.00           H  
ATOM    893  HB3 LYS A  53     -25.777  10.970  24.812  1.00  0.00           H  
ATOM    894  HG2 LYS A  53     -25.678  12.953  23.467  1.00  0.00           H  
ATOM    895  HG3 LYS A  53     -27.260  12.652  22.733  1.00  0.00           H  
ATOM    896  HD2 LYS A  53     -27.102  12.891  25.746  1.00  0.00           H  
ATOM    897  HD3 LYS A  53     -26.895  14.355  24.784  1.00  0.00           H  
ATOM    898  HE2 LYS A  53     -29.239  14.071  25.462  1.00  0.00           H  
ATOM    899  HE3 LYS A  53     -29.052  14.078  23.702  1.00  0.00           H  
ATOM    900  HZ1 LYS A  53     -29.353  11.674  25.360  1.00  0.00           H  
ATOM    901  HZ2 LYS A  53     -29.230  11.712  23.719  1.00  0.00           H  
ATOM    902  HZ3 LYS A  53     -30.543  12.376  24.459  1.00  0.00           H  
ATOM    903  N   LYS A  54     -23.662  10.202  22.874  1.00  0.00           N  
ATOM    904  CA  LYS A  54     -22.305  10.489  22.447  1.00  0.00           C  
ATOM    905  C   LYS A  54     -21.856   9.626  21.259  1.00  0.00           C  
ATOM    906  O   LYS A  54     -20.728   9.775  20.796  1.00  0.00           O  
ATOM    907  CB  LYS A  54     -21.389  10.235  23.650  1.00  0.00           C  
ATOM    908  CG  LYS A  54     -21.580  11.273  24.764  1.00  0.00           C  
ATOM    909  CD  LYS A  54     -20.517  11.126  25.863  1.00  0.00           C  
ATOM    910  CE  LYS A  54     -20.646   9.790  26.607  1.00  0.00           C  
ATOM    911  NZ  LYS A  54     -19.740   9.707  27.766  1.00  0.00           N  
ATOM    912  H   LYS A  54     -23.741   9.678  23.738  1.00  0.00           H  
ATOM    913  HA  LYS A  54     -22.220  11.536  22.152  1.00  0.00           H  
ATOM    914  HB2 LYS A  54     -21.574   9.227  24.025  1.00  0.00           H  
ATOM    915  HB3 LYS A  54     -20.366  10.283  23.307  1.00  0.00           H  
ATOM    916  HG2 LYS A  54     -21.483  12.269  24.329  1.00  0.00           H  
ATOM    917  HG3 LYS A  54     -22.577  11.185  25.196  1.00  0.00           H  
ATOM    918  HD2 LYS A  54     -19.530  11.209  25.407  1.00  0.00           H  
ATOM    919  HD3 LYS A  54     -20.645  11.944  26.573  1.00  0.00           H  
ATOM    920  HE2 LYS A  54     -21.670   9.690  26.963  1.00  0.00           H  
ATOM    921  HE3 LYS A  54     -20.422   8.958  25.940  1.00  0.00           H  
ATOM    922  HZ1 LYS A  54     -19.935   8.865  28.289  1.00  0.00           H  
ATOM    923  HZ2 LYS A  54     -19.870  10.503  28.374  1.00  0.00           H  
ATOM    924  HZ3 LYS A  54     -18.780   9.687  27.454  1.00  0.00           H  
ATOM    925  N   GLY A  55     -22.692   8.705  20.765  1.00  0.00           N  
ATOM    926  CA  GLY A  55     -22.322   7.814  19.674  1.00  0.00           C  
ATOM    927  C   GLY A  55     -21.190   6.870  20.086  1.00  0.00           C  
ATOM    928  O   GLY A  55     -20.384   6.457  19.253  1.00  0.00           O  
ATOM    929  H   GLY A  55     -23.623   8.596  21.151  1.00  0.00           H  
ATOM    930  HA2 GLY A  55     -23.191   7.209  19.414  1.00  0.00           H  
ATOM    931  HA3 GLY A  55     -22.027   8.385  18.797  1.00  0.00           H  
ATOM    932  N   ALA A  56     -21.124   6.542  21.380  1.00  0.00           N  
ATOM    933  CA  ALA A  56     -20.159   5.615  21.942  1.00  0.00           C  
ATOM    934  C   ALA A  56     -20.682   4.198  21.691  1.00  0.00           C  
ATOM    935  O   ALA A  56     -19.971   3.330  21.190  1.00  0.00           O  
ATOM    936  CB  ALA A  56     -19.979   5.891  23.443  1.00  0.00           C  
ATOM    937  H   ALA A  56     -21.854   6.887  21.993  1.00  0.00           H  
ATOM    938  HA  ALA A  56     -19.200   5.770  21.444  1.00  0.00           H  
ATOM    939  HB1 ALA A  56     -20.863   5.583  23.998  1.00  0.00           H  
ATOM    940  HB2 ALA A  56     -19.130   5.330  23.831  1.00  0.00           H  
ATOM    941  HB3 ALA A  56     -19.808   6.954  23.618  1.00  0.00           H  
ATOM    942  N   LEU A  57     -21.945   3.956  22.043  1.00  0.00           N  
ATOM    943  CA  LEU A  57     -22.607   2.675  21.838  1.00  0.00           C  
ATOM    944  C   LEU A  57     -23.742   2.880  20.843  1.00  0.00           C  
ATOM    945  O   LEU A  57     -24.604   3.727  21.067  1.00  0.00           O  
ATOM    946  CB  LEU A  57     -23.174   2.149  23.167  1.00  0.00           C  
ATOM    947  CG  LEU A  57     -22.209   1.276  23.987  1.00  0.00           C  
ATOM    948  CD1 LEU A  57     -20.805   1.869  24.174  1.00  0.00           C  
ATOM    949  CD2 LEU A  57     -22.843   1.012  25.355  1.00  0.00           C  
ATOM    950  H   LEU A  57     -22.502   4.731  22.391  1.00  0.00           H  
ATOM    951  HA  LEU A  57     -21.930   1.922  21.434  1.00  0.00           H  
ATOM    952  HB2 LEU A  57     -23.528   2.993  23.758  1.00  0.00           H  
ATOM    953  HB3 LEU A  57     -24.040   1.522  22.945  1.00  0.00           H  
ATOM    954  HG  LEU A  57     -22.093   0.317  23.480  1.00  0.00           H  
ATOM    955 HD11 LEU A  57     -20.233   1.268  24.883  1.00  0.00           H  
ATOM    956 HD12 LEU A  57     -20.856   2.893  24.540  1.00  0.00           H  
ATOM    957 HD13 LEU A  57     -20.274   1.845  23.226  1.00  0.00           H  
ATOM    958 HD21 LEU A  57     -23.062   1.952  25.861  1.00  0.00           H  
ATOM    959 HD22 LEU A  57     -23.773   0.456  25.235  1.00  0.00           H  
ATOM    960 HD23 LEU A  57     -22.156   0.431  25.967  1.00  0.00           H  
ATOM    961  N   ASN A  58     -23.756   2.107  19.758  1.00  0.00           N  
ATOM    962  CA  ASN A  58     -24.886   2.087  18.837  1.00  0.00           C  
ATOM    963  C   ASN A  58     -25.803   0.994  19.381  1.00  0.00           C  
ATOM    964  O   ASN A  58     -25.306   0.089  20.053  1.00  0.00           O  
ATOM    965  CB  ASN A  58     -24.411   1.756  17.416  1.00  0.00           C  
ATOM    966  CG  ASN A  58     -25.599   1.401  16.523  1.00  0.00           C  
ATOM    967  OD1 ASN A  58     -26.240   2.282  15.964  1.00  0.00           O  
ATOM    968  ND2 ASN A  58     -25.943   0.119  16.426  1.00  0.00           N  
ATOM    969  H   ASN A  58     -23.086   1.346  19.686  1.00  0.00           H  
ATOM    970  HA  ASN A  58     -25.413   3.042  18.823  1.00  0.00           H  
ATOM    971  HB2 ASN A  58     -23.898   2.625  17.003  1.00  0.00           H  
ATOM    972  HB3 ASN A  58     -23.708   0.923  17.432  1.00  0.00           H  
ATOM    973 HD21 ASN A  58     -25.415  -0.602  16.914  1.00  0.00           H  
ATOM    974 HD22 ASN A  58     -26.796  -0.108  15.940  1.00  0.00           H  
ATOM    975  N   HIS A  59     -27.116   1.059  19.150  1.00  0.00           N  
ATOM    976  CA  HIS A  59     -28.014   0.009  19.610  1.00  0.00           C  
ATOM    977  C   HIS A  59     -29.020  -0.389  18.545  1.00  0.00           C  
ATOM    978  O   HIS A  59     -29.261   0.355  17.594  1.00  0.00           O  
ATOM    979  CB  HIS A  59     -28.709   0.378  20.921  1.00  0.00           C  
ATOM    980  CG  HIS A  59     -29.750   1.451  20.766  1.00  0.00           C  
ATOM    981  ND1 HIS A  59     -31.076   1.137  20.470  1.00  0.00           N  
ATOM    982  CD2 HIS A  59     -29.629   2.807  20.891  1.00  0.00           C  
ATOM    983  CE1 HIS A  59     -31.699   2.317  20.416  1.00  0.00           C  
ATOM    984  NE2 HIS A  59     -30.877   3.350  20.664  1.00  0.00           N  
ATOM    985  H   HIS A  59     -27.504   1.767  18.542  1.00  0.00           H  
ATOM    986  HA  HIS A  59     -27.417  -0.881  19.783  1.00  0.00           H  
ATOM    987  HB2 HIS A  59     -29.206  -0.505  21.322  1.00  0.00           H  
ATOM    988  HB3 HIS A  59     -27.957   0.686  21.640  1.00  0.00           H  
ATOM    989  HD2 HIS A  59     -28.721   3.339  21.130  1.00  0.00           H  
ATOM    990  HE1 HIS A  59     -32.753   2.427  20.203  1.00  0.00           H  
ATOM    991  HE2 HIS A  59     -31.119   4.329  20.681  1.00  0.00           H  
ATOM    992  N   HIS A  60     -29.569  -1.589  18.717  1.00  0.00           N  
ATOM    993  CA  HIS A  60     -30.599  -2.170  17.868  1.00  0.00           C  
ATOM    994  C   HIS A  60     -31.770  -2.552  18.772  1.00  0.00           C  
ATOM    995  O   HIS A  60     -31.567  -3.224  19.781  1.00  0.00           O  
ATOM    996  CB  HIS A  60     -30.040  -3.388  17.125  1.00  0.00           C  
ATOM    997  CG  HIS A  60     -28.893  -3.070  16.197  1.00  0.00           C  
ATOM    998  ND1 HIS A  60     -27.799  -3.927  16.076  1.00  0.00           N  
ATOM    999  CD2 HIS A  60     -28.712  -2.006  15.352  1.00  0.00           C  
ATOM   1000  CE1 HIS A  60     -27.009  -3.352  15.167  1.00  0.00           C  
ATOM   1001  NE2 HIS A  60     -27.512  -2.200  14.697  1.00  0.00           N  
ATOM   1002  H   HIS A  60     -29.278  -2.103  19.547  1.00  0.00           H  
ATOM   1003  HA  HIS A  60     -30.945  -1.439  17.137  1.00  0.00           H  
ATOM   1004  HB2 HIS A  60     -29.704  -4.127  17.855  1.00  0.00           H  
ATOM   1005  HB3 HIS A  60     -30.840  -3.834  16.532  1.00  0.00           H  
ATOM   1006  HD2 HIS A  60     -29.389  -1.174  15.214  1.00  0.00           H  
ATOM   1007  HE1 HIS A  60     -26.071  -3.774  14.835  1.00  0.00           H  
ATOM   1008  HE2 HIS A  60     -27.102  -1.600  13.996  1.00  0.00           H  
ATOM   1009  N   LYS A  61     -32.991  -2.138  18.426  1.00  0.00           N  
ATOM   1010  CA  LYS A  61     -34.171  -2.378  19.249  1.00  0.00           C  
ATOM   1011  C   LYS A  61     -34.750  -3.771  18.983  1.00  0.00           C  
ATOM   1012  O   LYS A  61     -35.504  -3.978  18.032  1.00  0.00           O  
ATOM   1013  CB  LYS A  61     -35.201  -1.247  19.064  1.00  0.00           C  
ATOM   1014  CG  LYS A  61     -35.514  -0.866  17.608  1.00  0.00           C  
ATOM   1015  CD  LYS A  61     -36.683   0.129  17.577  1.00  0.00           C  
ATOM   1016  CE  LYS A  61     -37.100   0.480  16.143  1.00  0.00           C  
ATOM   1017  NZ  LYS A  61     -36.024   1.165  15.404  1.00  0.00           N  
ATOM   1018  H   LYS A  61     -33.103  -1.628  17.566  1.00  0.00           H  
ATOM   1019  HA  LYS A  61     -33.889  -2.334  20.300  1.00  0.00           H  
ATOM   1020  HB2 LYS A  61     -36.123  -1.548  19.566  1.00  0.00           H  
ATOM   1021  HB3 LYS A  61     -34.821  -0.356  19.568  1.00  0.00           H  
ATOM   1022  HG2 LYS A  61     -34.640  -0.403  17.154  1.00  0.00           H  
ATOM   1023  HG3 LYS A  61     -35.790  -1.753  17.036  1.00  0.00           H  
ATOM   1024  HD2 LYS A  61     -37.544  -0.319  18.080  1.00  0.00           H  
ATOM   1025  HD3 LYS A  61     -36.408   1.039  18.114  1.00  0.00           H  
ATOM   1026  HE2 LYS A  61     -37.380  -0.429  15.608  1.00  0.00           H  
ATOM   1027  HE3 LYS A  61     -37.968   1.140  16.180  1.00  0.00           H  
ATOM   1028  HZ1 LYS A  61     -35.755   2.006  15.895  1.00  0.00           H  
ATOM   1029  HZ2 LYS A  61     -36.351   1.409  14.480  1.00  0.00           H  
ATOM   1030  HZ3 LYS A  61     -35.224   0.555  15.321  1.00  0.00           H  
ATOM   1031  N   GLU A  62     -34.429  -4.738  19.846  1.00  0.00           N  
ATOM   1032  CA  GLU A  62     -34.927  -6.094  19.720  1.00  0.00           C  
ATOM   1033  C   GLU A  62     -36.286  -6.144  20.421  1.00  0.00           C  
ATOM   1034  O   GLU A  62     -36.434  -6.672  21.526  1.00  0.00           O  
ATOM   1035  CB  GLU A  62     -33.896  -7.059  20.323  1.00  0.00           C  
ATOM   1036  CG  GLU A  62     -34.187  -8.516  19.957  1.00  0.00           C  
ATOM   1037  CD  GLU A  62     -33.895  -8.813  18.489  1.00  0.00           C  
ATOM   1038  OE1 GLU A  62     -32.694  -8.926  18.163  1.00  0.00           O  
ATOM   1039  OE2 GLU A  62     -34.877  -8.913  17.723  1.00  0.00           O  
ATOM   1040  H   GLU A  62     -33.945  -4.501  20.705  1.00  0.00           H  
ATOM   1041  HA  GLU A  62     -35.055  -6.362  18.670  1.00  0.00           H  
ATOM   1042  HB2 GLU A  62     -32.909  -6.824  19.936  1.00  0.00           H  
ATOM   1043  HB3 GLU A  62     -33.883  -6.950  21.408  1.00  0.00           H  
ATOM   1044  HG2 GLU A  62     -33.572  -9.172  20.573  1.00  0.00           H  
ATOM   1045  HG3 GLU A  62     -35.234  -8.714  20.164  1.00  0.00           H  
ATOM   1046  N   GLY A  63     -37.289  -5.611  19.721  1.00  0.00           N  
ATOM   1047  CA  GLY A  63     -38.681  -5.563  20.140  1.00  0.00           C  
ATOM   1048  C   GLY A  63     -38.894  -4.799  21.450  1.00  0.00           C  
ATOM   1049  O   GLY A  63     -39.370  -3.668  21.440  1.00  0.00           O  
ATOM   1050  H   GLY A  63     -37.034  -5.147  18.855  1.00  0.00           H  
ATOM   1051  HA2 GLY A  63     -39.257  -5.073  19.354  1.00  0.00           H  
ATOM   1052  HA3 GLY A  63     -39.057  -6.580  20.252  1.00  0.00           H  
ATOM   1053  N   ARG A  64     -38.568  -5.441  22.574  1.00  0.00           N  
ATOM   1054  CA  ARG A  64     -38.752  -4.915  23.920  1.00  0.00           C  
ATOM   1055  C   ARG A  64     -37.445  -4.370  24.498  1.00  0.00           C  
ATOM   1056  O   ARG A  64     -37.446  -3.315  25.127  1.00  0.00           O  
ATOM   1057  CB  ARG A  64     -39.338  -6.016  24.806  1.00  0.00           C  
ATOM   1058  CG  ARG A  64     -39.633  -5.497  26.220  1.00  0.00           C  
ATOM   1059  CD  ARG A  64     -40.520  -6.498  26.961  1.00  0.00           C  
ATOM   1060  NE  ARG A  64     -40.782  -6.068  28.341  1.00  0.00           N  
ATOM   1061  CZ  ARG A  64     -41.683  -5.146  28.713  1.00  0.00           C  
ATOM   1062  NH1 ARG A  64     -42.422  -4.510  27.797  1.00  0.00           N  
ATOM   1063  NH2 ARG A  64     -41.838  -4.863  30.010  1.00  0.00           N  
ATOM   1064  H   ARG A  64     -38.059  -6.311  22.455  1.00  0.00           H  
ATOM   1065  HA  ARG A  64     -39.492  -4.118  23.911  1.00  0.00           H  
ATOM   1066  HB2 ARG A  64     -40.267  -6.359  24.351  1.00  0.00           H  
ATOM   1067  HB3 ARG A  64     -38.643  -6.851  24.862  1.00  0.00           H  
ATOM   1068  HG2 ARG A  64     -38.700  -5.359  26.770  1.00  0.00           H  
ATOM   1069  HG3 ARG A  64     -40.146  -4.536  26.157  1.00  0.00           H  
ATOM   1070  HD2 ARG A  64     -41.453  -6.627  26.413  1.00  0.00           H  
ATOM   1071  HD3 ARG A  64     -40.011  -7.463  26.998  1.00  0.00           H  
ATOM   1072  HE  ARG A  64     -40.238  -6.523  29.061  1.00  0.00           H  
ATOM   1073 HH11 ARG A  64     -42.287  -4.718  26.821  1.00  0.00           H  
ATOM   1074 HH12 ARG A  64     -43.103  -3.816  28.067  1.00  0.00           H  
ATOM   1075 HH21 ARG A  64     -41.277  -5.343  30.698  1.00  0.00           H  
ATOM   1076 HH22 ARG A  64     -42.507  -4.172  30.314  1.00  0.00           H  
ATOM   1077  N   VAL A  65     -36.342  -5.101  24.319  1.00  0.00           N  
ATOM   1078  CA  VAL A  65     -35.034  -4.725  24.842  1.00  0.00           C  
ATOM   1079  C   VAL A  65     -34.182  -4.199  23.691  1.00  0.00           C  
ATOM   1080  O   VAL A  65     -34.428  -4.544  22.538  1.00  0.00           O  
ATOM   1081  CB  VAL A  65     -34.372  -5.917  25.559  1.00  0.00           C  
ATOM   1082  CG1 VAL A  65     -35.169  -6.299  26.812  1.00  0.00           C  
ATOM   1083  CG2 VAL A  65     -34.220  -7.150  24.656  1.00  0.00           C  
ATOM   1084  H   VAL A  65     -36.372  -5.868  23.658  1.00  0.00           H  
ATOM   1085  HA  VAL A  65     -35.132  -3.920  25.572  1.00  0.00           H  
ATOM   1086  HB  VAL A  65     -33.378  -5.608  25.883  1.00  0.00           H  
ATOM   1087 HG11 VAL A  65     -34.645  -7.088  27.354  1.00  0.00           H  
ATOM   1088 HG12 VAL A  65     -35.273  -5.433  27.466  1.00  0.00           H  
ATOM   1089 HG13 VAL A  65     -36.162  -6.660  26.537  1.00  0.00           H  
ATOM   1090 HG21 VAL A  65     -33.588  -6.914  23.801  1.00  0.00           H  
ATOM   1091 HG22 VAL A  65     -33.752  -7.958  25.220  1.00  0.00           H  
ATOM   1092 HG23 VAL A  65     -35.190  -7.497  24.301  1.00  0.00           H  
ATOM   1093  N   PHE A  66     -33.189  -3.360  23.985  1.00  0.00           N  
ATOM   1094  CA  PHE A  66     -32.298  -2.804  22.981  1.00  0.00           C  
ATOM   1095  C   PHE A  66     -30.891  -3.360  23.212  1.00  0.00           C  
ATOM   1096  O   PHE A  66     -30.371  -3.330  24.326  1.00  0.00           O  
ATOM   1097  CB  PHE A  66     -32.423  -1.272  22.861  1.00  0.00           C  
ATOM   1098  CG  PHE A  66     -32.330  -0.390  24.101  1.00  0.00           C  
ATOM   1099  CD1 PHE A  66     -33.275  -0.505  25.141  1.00  0.00           C  
ATOM   1100  CD2 PHE A  66     -31.523   0.764  24.051  1.00  0.00           C  
ATOM   1101  CE1 PHE A  66     -33.275   0.408  26.210  1.00  0.00           C  
ATOM   1102  CE2 PHE A  66     -31.561   1.711  25.091  1.00  0.00           C  
ATOM   1103  CZ  PHE A  66     -32.405   1.510  26.194  1.00  0.00           C  
ATOM   1104  H   PHE A  66     -32.962  -3.168  24.956  1.00  0.00           H  
ATOM   1105  HA  PHE A  66     -32.605  -3.170  22.007  1.00  0.00           H  
ATOM   1106  HB2 PHE A  66     -31.676  -0.956  22.133  1.00  0.00           H  
ATOM   1107  HB3 PHE A  66     -33.398  -1.062  22.418  1.00  0.00           H  
ATOM   1108  HD1 PHE A  66     -34.036  -1.271  25.122  1.00  0.00           H  
ATOM   1109  HD2 PHE A  66     -30.880   0.943  23.204  1.00  0.00           H  
ATOM   1110  HE1 PHE A  66     -33.971   0.280  27.027  1.00  0.00           H  
ATOM   1111  HE2 PHE A  66     -30.946   2.597  25.042  1.00  0.00           H  
ATOM   1112  HZ  PHE A  66     -32.404   2.218  27.011  1.00  0.00           H  
ATOM   1113  N   VAL A  67     -30.330  -3.958  22.159  1.00  0.00           N  
ATOM   1114  CA  VAL A  67     -29.034  -4.612  22.140  1.00  0.00           C  
ATOM   1115  C   VAL A  67     -27.968  -3.561  21.859  1.00  0.00           C  
ATOM   1116  O   VAL A  67     -28.119  -2.814  20.895  1.00  0.00           O  
ATOM   1117  CB  VAL A  67     -29.048  -5.724  21.076  1.00  0.00           C  
ATOM   1118  CG1 VAL A  67     -27.673  -6.389  20.937  1.00  0.00           C  
ATOM   1119  CG2 VAL A  67     -30.082  -6.799  21.436  1.00  0.00           C  
ATOM   1120  H   VAL A  67     -30.813  -3.899  21.270  1.00  0.00           H  
ATOM   1121  HA  VAL A  67     -28.854  -5.066  23.106  1.00  0.00           H  
ATOM   1122  HB  VAL A  67     -29.318  -5.294  20.109  1.00  0.00           H  
ATOM   1123 HG11 VAL A  67     -26.952  -5.674  20.541  1.00  0.00           H  
ATOM   1124 HG12 VAL A  67     -27.737  -7.227  20.244  1.00  0.00           H  
ATOM   1125 HG13 VAL A  67     -27.335  -6.753  21.908  1.00  0.00           H  
ATOM   1126 HG21 VAL A  67     -30.103  -7.565  20.661  1.00  0.00           H  
ATOM   1127 HG22 VAL A  67     -29.819  -7.262  22.386  1.00  0.00           H  
ATOM   1128 HG23 VAL A  67     -31.078  -6.362  21.516  1.00  0.00           H  
ATOM   1129  N   TYR A  68     -26.906  -3.508  22.672  1.00  0.00           N  
ATOM   1130  CA  TYR A  68     -25.847  -2.508  22.543  1.00  0.00           C  
ATOM   1131  C   TYR A  68     -24.642  -3.051  21.783  1.00  0.00           C  
ATOM   1132  O   TYR A  68     -23.994  -3.989  22.242  1.00  0.00           O  
ATOM   1133  CB  TYR A  68     -25.385  -2.061  23.934  1.00  0.00           C  
ATOM   1134  CG  TYR A  68     -26.520  -1.608  24.819  1.00  0.00           C  
ATOM   1135  CD1 TYR A  68     -27.241  -0.451  24.481  1.00  0.00           C  
ATOM   1136  CD2 TYR A  68     -26.983  -2.450  25.844  1.00  0.00           C  
ATOM   1137  CE1 TYR A  68     -28.477  -0.193  25.093  1.00  0.00           C  
ATOM   1138  CE2 TYR A  68     -28.205  -2.174  26.469  1.00  0.00           C  
ATOM   1139  CZ  TYR A  68     -28.996  -1.105  26.029  1.00  0.00           C  
ATOM   1140  OH  TYR A  68     -30.257  -0.963  26.522  1.00  0.00           O  
ATOM   1141  H   TYR A  68     -26.864  -4.156  23.452  1.00  0.00           H  
ATOM   1142  HA  TYR A  68     -26.237  -1.627  22.030  1.00  0.00           H  
ATOM   1143  HB2 TYR A  68     -24.862  -2.883  24.424  1.00  0.00           H  
ATOM   1144  HB3 TYR A  68     -24.678  -1.239  23.817  1.00  0.00           H  
ATOM   1145  HD1 TYR A  68     -26.853   0.222  23.732  1.00  0.00           H  
ATOM   1146  HD2 TYR A  68     -26.427  -3.331  26.128  1.00  0.00           H  
ATOM   1147  HE1 TYR A  68     -29.005   0.714  24.849  1.00  0.00           H  
ATOM   1148  HE2 TYR A  68     -28.548  -2.809  27.261  1.00  0.00           H  
ATOM   1149  HH  TYR A  68     -30.760  -0.272  26.081  1.00  0.00           H  
ATOM   1150  N   THR A  69     -24.307  -2.405  20.668  1.00  0.00           N  
ATOM   1151  CA  THR A  69     -23.163  -2.686  19.820  1.00  0.00           C  
ATOM   1152  C   THR A  69     -22.140  -1.561  20.050  1.00  0.00           C  
ATOM   1153  O   THR A  69     -22.411  -0.426  19.645  1.00  0.00           O  
ATOM   1154  CB  THR A  69     -23.628  -2.699  18.356  1.00  0.00           C  
ATOM   1155  OG1 THR A  69     -24.391  -1.541  18.079  1.00  0.00           O  
ATOM   1156  CG2 THR A  69     -24.497  -3.920  18.051  1.00  0.00           C  
ATOM   1157  H   THR A  69     -24.892  -1.631  20.374  1.00  0.00           H  
ATOM   1158  HA  THR A  69     -22.738  -3.665  20.039  1.00  0.00           H  
ATOM   1159  HB  THR A  69     -22.748  -2.720  17.709  1.00  0.00           H  
ATOM   1160  HG1 THR A  69     -24.100  -0.849  18.694  1.00  0.00           H  
ATOM   1161 HG21 THR A  69     -24.803  -3.896  17.006  1.00  0.00           H  
ATOM   1162 HG22 THR A  69     -25.389  -3.921  18.679  1.00  0.00           H  
ATOM   1163 HG23 THR A  69     -23.930  -4.833  18.228  1.00  0.00           H  
ATOM   1164  N   PRO A  70     -21.002  -1.820  20.713  1.00  0.00           N  
ATOM   1165  CA  PRO A  70     -19.978  -0.810  20.947  1.00  0.00           C  
ATOM   1166  C   PRO A  70     -19.494  -0.176  19.641  1.00  0.00           C  
ATOM   1167  O   PRO A  70     -19.020  -0.880  18.753  1.00  0.00           O  
ATOM   1168  CB  PRO A  70     -18.835  -1.536  21.667  1.00  0.00           C  
ATOM   1169  CG  PRO A  70     -19.555  -2.681  22.375  1.00  0.00           C  
ATOM   1170  CD  PRO A  70     -20.649  -3.062  21.380  1.00  0.00           C  
ATOM   1171  HA  PRO A  70     -20.390  -0.052  21.613  1.00  0.00           H  
ATOM   1172  HB2 PRO A  70     -18.131  -1.954  20.945  1.00  0.00           H  
ATOM   1173  HB3 PRO A  70     -18.312  -0.883  22.364  1.00  0.00           H  
ATOM   1174  HG2 PRO A  70     -18.897  -3.518  22.613  1.00  0.00           H  
ATOM   1175  HG3 PRO A  70     -20.016  -2.285  23.279  1.00  0.00           H  
ATOM   1176  HD2 PRO A  70     -20.263  -3.770  20.645  1.00  0.00           H  
ATOM   1177  HD3 PRO A  70     -21.487  -3.502  21.921  1.00  0.00           H  
ATOM   1178  N   ASN A  71     -19.610   1.149  19.518  1.00  0.00           N  
ATOM   1179  CA  ASN A  71     -19.121   1.879  18.352  1.00  0.00           C  
ATOM   1180  C   ASN A  71     -17.618   2.120  18.482  1.00  0.00           C  
ATOM   1181  O   ASN A  71     -16.918   2.286  17.484  1.00  0.00           O  
ATOM   1182  CB  ASN A  71     -19.837   3.223  18.241  1.00  0.00           C  
ATOM   1183  CG  ASN A  71     -19.988   3.678  16.793  1.00  0.00           C  
ATOM   1184  OD1 ASN A  71     -21.064   4.093  16.378  1.00  0.00           O  
ATOM   1185  ND2 ASN A  71     -18.918   3.614  16.001  1.00  0.00           N  
ATOM   1186  H   ASN A  71     -19.982   1.701  20.283  1.00  0.00           H  
ATOM   1187  HA  ASN A  71     -19.329   1.309  17.452  1.00  0.00           H  
ATOM   1188  HB2 ASN A  71     -20.810   3.150  18.723  1.00  0.00           H  
ATOM   1189  HB3 ASN A  71     -19.257   3.972  18.770  1.00  0.00           H  
ATOM   1190 HD21 ASN A  71     -18.039   3.230  16.340  1.00  0.00           H  
ATOM   1191 HD22 ASN A  71     -19.019   3.889  15.036  1.00  0.00           H  
ATOM   1192  N   ILE A  72     -17.164   2.197  19.733  1.00  0.00           N  
ATOM   1193  CA  ILE A  72     -15.797   2.411  20.176  1.00  0.00           C  
ATOM   1194  C   ILE A  72     -15.269   1.145  20.856  1.00  0.00           C  
ATOM   1195  O   ILE A  72     -15.997   0.439  21.557  1.00  0.00           O  
ATOM   1196  CB  ILE A  72     -15.716   3.607  21.152  1.00  0.00           C  
ATOM   1197  CG1 ILE A  72     -17.001   3.882  21.947  1.00  0.00           C  
ATOM   1198  CG2 ILE A  72     -15.414   4.910  20.399  1.00  0.00           C  
ATOM   1199  CD1 ILE A  72     -17.540   2.756  22.832  1.00  0.00           C  
ATOM   1200  H   ILE A  72     -17.865   2.099  20.447  1.00  0.00           H  
ATOM   1201  HA  ILE A  72     -15.166   2.616  19.310  1.00  0.00           H  
ATOM   1202  HB  ILE A  72     -14.894   3.442  21.852  1.00  0.00           H  
ATOM   1203 HG12 ILE A  72     -16.816   4.724  22.606  1.00  0.00           H  
ATOM   1204 HG13 ILE A  72     -17.758   4.189  21.236  1.00  0.00           H  
ATOM   1205 HG21 ILE A  72     -15.325   5.733  21.111  1.00  0.00           H  
ATOM   1206 HG22 ILE A  72     -16.222   5.136  19.702  1.00  0.00           H  
ATOM   1207 HG23 ILE A  72     -14.476   4.822  19.853  1.00  0.00           H  
ATOM   1208 HD11 ILE A  72     -16.751   2.398  23.478  1.00  0.00           H  
ATOM   1209 HD12 ILE A  72     -18.342   3.157  23.447  1.00  0.00           H  
ATOM   1210 HD13 ILE A  72     -17.944   1.921  22.265  1.00  0.00           H  
ATOM   1211  N   ASP A  73     -13.983   0.865  20.642  1.00  0.00           N  
ATOM   1212  CA  ASP A  73     -13.264  -0.259  21.220  1.00  0.00           C  
ATOM   1213  C   ASP A  73     -11.775   0.073  21.240  1.00  0.00           C  
ATOM   1214  O   ASP A  73     -11.142   0.067  22.292  1.00  0.00           O  
ATOM   1215  CB  ASP A  73     -13.552  -1.520  20.404  1.00  0.00           C  
ATOM   1216  CG  ASP A  73     -12.904  -2.739  21.047  1.00  0.00           C  
ATOM   1217  OD1 ASP A  73     -13.567  -3.343  21.918  1.00  0.00           O  
ATOM   1218  OD2 ASP A  73     -11.754  -3.037  20.658  1.00  0.00           O  
ATOM   1219  H   ASP A  73     -13.474   1.461  20.014  1.00  0.00           H  
ATOM   1220  HA  ASP A  73     -13.595  -0.412  22.248  1.00  0.00           H  
ATOM   1221  HB2 ASP A  73     -14.631  -1.659  20.360  1.00  0.00           H  
ATOM   1222  HB3 ASP A  73     -13.183  -1.415  19.383  1.00  0.00           H  
ATOM   1223  N   GLU A  74     -11.239   0.411  20.063  1.00  0.00           N  
ATOM   1224  CA  GLU A  74      -9.851   0.803  19.871  1.00  0.00           C  
ATOM   1225  C   GLU A  74      -9.547   2.001  20.770  1.00  0.00           C  
ATOM   1226  O   GLU A  74      -8.572   2.006  21.519  1.00  0.00           O  
ATOM   1227  CB  GLU A  74      -9.598   1.162  18.396  1.00  0.00           C  
ATOM   1228  CG  GLU A  74      -9.782  -0.018  17.425  1.00  0.00           C  
ATOM   1229  CD  GLU A  74     -11.230  -0.405  17.127  1.00  0.00           C  
ATOM   1230  OE1 GLU A  74     -12.132   0.392  17.475  1.00  0.00           O  
ATOM   1231  OE2 GLU A  74     -11.414  -1.503  16.560  1.00  0.00           O  
ATOM   1232  H   GLU A  74     -11.836   0.386  19.249  1.00  0.00           H  
ATOM   1233  HA  GLU A  74      -9.201  -0.025  20.158  1.00  0.00           H  
ATOM   1234  HB2 GLU A  74     -10.227   1.998  18.085  1.00  0.00           H  
ATOM   1235  HB3 GLU A  74      -8.559   1.486  18.321  1.00  0.00           H  
ATOM   1236  HG2 GLU A  74      -9.327   0.263  16.476  1.00  0.00           H  
ATOM   1237  HG3 GLU A  74      -9.255  -0.887  17.818  1.00  0.00           H  
ATOM   1238  N   SER A  75     -10.401   3.024  20.687  1.00  0.00           N  
ATOM   1239  CA  SER A  75     -10.335   4.230  21.496  1.00  0.00           C  
ATOM   1240  C   SER A  75     -10.772   3.915  22.932  1.00  0.00           C  
ATOM   1241  O   SER A  75     -11.774   4.445  23.416  1.00  0.00           O  
ATOM   1242  CB  SER A  75     -11.237   5.288  20.850  1.00  0.00           C  
ATOM   1243  OG  SER A  75     -11.037   5.293  19.448  1.00  0.00           O  
ATOM   1244  H   SER A  75     -11.120   2.984  19.979  1.00  0.00           H  
ATOM   1245  HA  SER A  75      -9.308   4.601  21.506  1.00  0.00           H  
ATOM   1246  HB2 SER A  75     -12.285   5.052  21.042  1.00  0.00           H  
ATOM   1247  HB3 SER A  75     -11.019   6.269  21.277  1.00  0.00           H  
ATOM   1248  HG  SER A  75     -10.114   5.492  19.263  1.00  0.00           H  
ATOM   1249  N   ASP A  76     -10.024   3.042  23.609  1.00  0.00           N  
ATOM   1250  CA  ASP A  76     -10.331   2.573  24.948  1.00  0.00           C  
ATOM   1251  C   ASP A  76     -10.179   3.686  25.984  1.00  0.00           C  
ATOM   1252  O   ASP A  76      -9.157   3.780  26.657  1.00  0.00           O  
ATOM   1253  CB  ASP A  76      -9.461   1.355  25.287  1.00  0.00           C  
ATOM   1254  CG  ASP A  76      -9.756   0.802  26.681  1.00  0.00           C  
ATOM   1255  OD1 ASP A  76     -10.905   0.975  27.144  1.00  0.00           O  
ATOM   1256  OD2 ASP A  76      -8.825   0.199  27.258  1.00  0.00           O  
ATOM   1257  H   ASP A  76      -9.232   2.627  23.130  1.00  0.00           H  
ATOM   1258  HA  ASP A  76     -11.371   2.237  24.952  1.00  0.00           H  
ATOM   1259  HB2 ASP A  76      -9.646   0.564  24.559  1.00  0.00           H  
ATOM   1260  HB3 ASP A  76      -8.408   1.637  25.239  1.00  0.00           H  
ATOM   1261  N   TYR A  77     -11.213   4.522  26.093  1.00  0.00           N  
ATOM   1262  CA  TYR A  77     -11.351   5.580  27.082  1.00  0.00           C  
ATOM   1263  C   TYR A  77     -10.268   6.659  26.965  1.00  0.00           C  
ATOM   1264  O   TYR A  77      -9.351   6.731  27.779  1.00  0.00           O  
ATOM   1265  CB  TYR A  77     -11.422   4.960  28.488  1.00  0.00           C  
ATOM   1266  CG  TYR A  77     -11.603   5.939  29.631  1.00  0.00           C  
ATOM   1267  CD1 TYR A  77     -12.336   7.122  29.443  1.00  0.00           C  
ATOM   1268  CD2 TYR A  77     -11.038   5.666  30.891  1.00  0.00           C  
ATOM   1269  CE1 TYR A  77     -12.564   7.982  30.522  1.00  0.00           C  
ATOM   1270  CE2 TYR A  77     -11.278   6.530  31.974  1.00  0.00           C  
ATOM   1271  CZ  TYR A  77     -12.089   7.663  31.801  1.00  0.00           C  
ATOM   1272  OH  TYR A  77     -12.487   8.406  32.872  1.00  0.00           O  
ATOM   1273  H   TYR A  77     -11.922   4.443  25.372  1.00  0.00           H  
ATOM   1274  HA  TYR A  77     -12.313   6.043  26.866  1.00  0.00           H  
ATOM   1275  HB2 TYR A  77     -12.257   4.258  28.506  1.00  0.00           H  
ATOM   1276  HB3 TYR A  77     -10.508   4.397  28.678  1.00  0.00           H  
ATOM   1277  HD1 TYR A  77     -12.756   7.387  28.487  1.00  0.00           H  
ATOM   1278  HD2 TYR A  77     -10.435   4.781  31.036  1.00  0.00           H  
ATOM   1279  HE1 TYR A  77     -13.139   8.871  30.350  1.00  0.00           H  
ATOM   1280  HE2 TYR A  77     -10.850   6.307  32.938  1.00  0.00           H  
ATOM   1281  HH  TYR A  77     -13.186   9.028  32.622  1.00  0.00           H  
ATOM   1282  N   ILE A  78     -10.399   7.528  25.958  1.00  0.00           N  
ATOM   1283  CA  ILE A  78      -9.465   8.618  25.698  1.00  0.00           C  
ATOM   1284  C   ILE A  78     -10.236   9.941  25.701  1.00  0.00           C  
ATOM   1285  O   ILE A  78     -10.806  10.330  24.684  1.00  0.00           O  
ATOM   1286  CB  ILE A  78      -8.727   8.336  24.374  1.00  0.00           C  
ATOM   1287  CG1 ILE A  78      -7.974   6.996  24.491  1.00  0.00           C  
ATOM   1288  CG2 ILE A  78      -7.736   9.461  24.033  1.00  0.00           C  
ATOM   1289  CD1 ILE A  78      -7.298   6.592  23.179  1.00  0.00           C  
ATOM   1290  H   ILE A  78     -11.182   7.429  25.330  1.00  0.00           H  
ATOM   1291  HA  ILE A  78      -8.708   8.676  26.481  1.00  0.00           H  
ATOM   1292  HB  ILE A  78      -9.461   8.263  23.571  1.00  0.00           H  
ATOM   1293 HG12 ILE A  78      -7.215   7.066  25.273  1.00  0.00           H  
ATOM   1294 HG13 ILE A  78      -8.668   6.202  24.769  1.00  0.00           H  
ATOM   1295 HG21 ILE A  78      -8.239  10.426  24.005  1.00  0.00           H  
ATOM   1296 HG22 ILE A  78      -6.939   9.492  24.777  1.00  0.00           H  
ATOM   1297 HG23 ILE A  78      -7.302   9.291  23.049  1.00  0.00           H  
ATOM   1298 HD11 ILE A  78      -6.444   7.237  22.976  1.00  0.00           H  
ATOM   1299 HD12 ILE A  78      -8.012   6.660  22.358  1.00  0.00           H  
ATOM   1300 HD13 ILE A  78      -6.943   5.565  23.264  1.00  0.00           H  
ATOM   1301  N   GLU A  79     -10.268  10.636  26.843  1.00  0.00           N  
ATOM   1302  CA  GLU A  79     -10.955  11.910  26.959  1.00  0.00           C  
ATOM   1303  C   GLU A  79     -10.075  13.040  26.424  1.00  0.00           C  
ATOM   1304  O   GLU A  79      -9.189  13.529  27.122  1.00  0.00           O  
ATOM   1305  CB  GLU A  79     -11.331  12.173  28.420  1.00  0.00           C  
ATOM   1306  CG  GLU A  79     -12.294  11.115  28.953  1.00  0.00           C  
ATOM   1307  CD  GLU A  79     -12.884  11.528  30.298  1.00  0.00           C  
ATOM   1308  OE1 GLU A  79     -12.188  11.308  31.312  1.00  0.00           O  
ATOM   1309  OE2 GLU A  79     -14.018  12.053  30.286  1.00  0.00           O  
ATOM   1310  H   GLU A  79      -9.801  10.288  27.665  1.00  0.00           H  
ATOM   1311  HA  GLU A  79     -11.886  11.882  26.387  1.00  0.00           H  
ATOM   1312  HB2 GLU A  79     -10.443  12.200  29.049  1.00  0.00           H  
ATOM   1313  HB3 GLU A  79     -11.817  13.146  28.468  1.00  0.00           H  
ATOM   1314  HG2 GLU A  79     -13.102  10.980  28.237  1.00  0.00           H  
ATOM   1315  HG3 GLU A  79     -11.757  10.173  29.058  1.00  0.00           H  
ATOM   1316  N   VAL A  80     -10.336  13.446  25.186  1.00  0.00           N  
ATOM   1317  CA  VAL A  80      -9.742  14.591  24.510  1.00  0.00           C  
ATOM   1318  C   VAL A  80     -10.897  15.570  24.286  1.00  0.00           C  
ATOM   1319  O   VAL A  80     -12.048  15.140  24.263  1.00  0.00           O  
ATOM   1320  CB  VAL A  80      -8.993  14.165  23.234  1.00  0.00           C  
ATOM   1321  CG1 VAL A  80      -9.881  13.430  22.225  1.00  0.00           C  
ATOM   1322  CG2 VAL A  80      -8.330  15.366  22.548  1.00  0.00           C  
ATOM   1323  H   VAL A  80     -11.103  13.000  24.703  1.00  0.00           H  
ATOM   1324  HA  VAL A  80      -9.022  15.069  25.176  1.00  0.00           H  
ATOM   1325  HB  VAL A  80      -8.198  13.481  23.534  1.00  0.00           H  
ATOM   1326 HG11 VAL A  80     -10.699  14.073  21.901  1.00  0.00           H  
ATOM   1327 HG12 VAL A  80     -10.277  12.525  22.677  1.00  0.00           H  
ATOM   1328 HG13 VAL A  80      -9.289  13.149  21.354  1.00  0.00           H  
ATOM   1329 HG21 VAL A  80      -9.083  16.037  22.135  1.00  0.00           H  
ATOM   1330 HG22 VAL A  80      -7.695  15.014  21.733  1.00  0.00           H  
ATOM   1331 HG23 VAL A  80      -7.711  15.909  23.262  1.00  0.00           H  
ATOM   1332  N   LYS A  81     -10.630  16.878  24.249  1.00  0.00           N  
ATOM   1333  CA  LYS A  81     -11.664  17.892  24.053  1.00  0.00           C  
ATOM   1334  C   LYS A  81     -12.307  17.767  22.661  1.00  0.00           C  
ATOM   1335  O   LYS A  81     -12.013  18.546  21.757  1.00  0.00           O  
ATOM   1336  CB  LYS A  81     -11.065  19.288  24.282  1.00  0.00           C  
ATOM   1337  CG  LYS A  81     -10.536  19.448  25.715  1.00  0.00           C  
ATOM   1338  CD  LYS A  81     -10.167  20.904  26.036  1.00  0.00           C  
ATOM   1339  CE  LYS A  81      -9.103  21.498  25.102  1.00  0.00           C  
ATOM   1340  NZ  LYS A  81      -7.863  20.703  25.097  1.00  0.00           N  
ATOM   1341  H   LYS A  81      -9.670  17.181  24.285  1.00  0.00           H  
ATOM   1342  HA  LYS A  81     -12.450  17.743  24.795  1.00  0.00           H  
ATOM   1343  HB2 LYS A  81     -10.258  19.451  23.565  1.00  0.00           H  
ATOM   1344  HB3 LYS A  81     -11.846  20.029  24.108  1.00  0.00           H  
ATOM   1345  HG2 LYS A  81     -11.319  19.140  26.410  1.00  0.00           H  
ATOM   1346  HG3 LYS A  81      -9.674  18.801  25.876  1.00  0.00           H  
ATOM   1347  HD2 LYS A  81     -11.067  21.519  25.971  1.00  0.00           H  
ATOM   1348  HD3 LYS A  81      -9.802  20.952  27.064  1.00  0.00           H  
ATOM   1349  HE2 LYS A  81      -9.492  21.566  24.085  1.00  0.00           H  
ATOM   1350  HE3 LYS A  81      -8.866  22.508  25.439  1.00  0.00           H  
ATOM   1351  HZ1 LYS A  81      -7.180  21.146  24.498  1.00  0.00           H  
ATOM   1352  HZ2 LYS A  81      -8.057  19.775  24.750  1.00  0.00           H  
ATOM   1353  HZ3 LYS A  81      -7.494  20.641  26.036  1.00  0.00           H  
ATOM   1354  N   SER A  82     -13.177  16.771  22.492  1.00  0.00           N  
ATOM   1355  CA  SER A  82     -13.933  16.439  21.298  1.00  0.00           C  
ATOM   1356  C   SER A  82     -15.054  15.496  21.746  1.00  0.00           C  
ATOM   1357  O   SER A  82     -15.447  15.596  22.932  1.00  0.00           O  
ATOM   1358  CB  SER A  82     -13.040  15.746  20.260  1.00  0.00           C  
ATOM   1359  OG  SER A  82     -11.918  16.533  19.897  1.00  0.00           O  
ATOM   1360  OXT SER A  82     -15.464  14.648  20.922  1.00  0.00           O  
ATOM   1361  H   SER A  82     -13.367  16.158  23.281  1.00  0.00           H  
ATOM   1362  HA  SER A  82     -14.374  17.342  20.873  1.00  0.00           H  
ATOM   1363  HB2 SER A  82     -12.703  14.791  20.665  1.00  0.00           H  
ATOM   1364  HB3 SER A  82     -13.639  15.542  19.370  1.00  0.00           H  
ATOM   1365  HG  SER A  82     -11.987  17.391  20.336  1.00  0.00           H  
TER    1366      SER A  82                                                      
END
MOLECULE T0443_97_230.pdb
ATOM    557  N   SER    97       9.444  13.904  25.999  1.00 32.65           N  
ATOM    558  CA  SER    97       9.019  13.771  27.400  1.00 32.55           C  
ATOM    559  C   SER    97       7.759  12.923  27.498  1.00 32.70           C  
ATOM    560  O   SER    97       7.026  12.769  26.517  1.00 33.71           O  
ATOM    561  CB  SER    97       8.716  15.139  27.997  1.00 32.59           C  
ATOM    562  OG  SER    97       7.547  15.663  27.400  1.00 31.84           O  
ATOM    563  N   ASP    98       7.467  12.409  28.690  1.00 33.19           N  
ATOM    564  CA  ASP    98       6.275  11.582  28.879  1.00 33.23           C  
ATOM    565  C   ASP    98       4.966  12.366  28.697  1.00 32.35           C  
ATOM    566  O   ASP    98       3.961  11.797  28.233  1.00 31.66           O  
ATOM    567  CB  ASP    98       6.314  10.868  30.227  1.00 34.81           C  
ATOM    568  CG  ASP    98       7.346   9.752  30.271  1.00 35.79           C  
ATOM    569  OD1 ASP    98       7.927   9.397  29.218  1.00 36.03           O  
ATOM    570  OD2 ASP    98       7.566   9.216  31.376  1.00 38.06           O  
ATOM    571  N   GLY    99       4.990  13.651  29.055  1.00 30.82           N  
ATOM    572  CA  GLY    99       3.842  14.548  28.894  1.00 30.89           C  
ATOM    573  C   GLY    99       3.507  14.851  27.439  1.00 31.23           C  
ATOM    574  O   GLY    99       2.338  14.867  27.051  1.00 32.26           O  
ATOM    575  N   ILE   100       4.532  15.128  26.633  1.00 31.16           N  
ATOM    576  CA  ILE   100       4.345  15.348  25.206  1.00 29.39           C  
ATOM    577  C   ILE   100       3.859  14.036  24.541  1.00 29.36           C  
ATOM    578  O   ILE   100       2.931  14.074  23.743  1.00 30.42           O  
ATOM    579  CB  ILE   100       5.637  15.902  24.562  1.00 30.48           C  
ATOM    580  CG1 ILE   100       5.934  17.321  25.075  1.00 31.37           C  
ATOM    581  CG2 ILE   100       5.542  15.941  23.038  1.00 30.03           C  
ATOM    582  CD1 ILE   100       4.947  18.391  24.593  1.00 31.63           C  
ATOM    583  N   LEU   101       4.433  12.889  24.915  1.00 27.54           N  
ATOM    584  CA  LEU   101       4.056  11.584  24.340  1.00 27.41           C  
ATOM    585  C   LEU   101       2.603  11.212  24.618  1.00 27.36           C  
ATOM    586  O   LEU   101       1.952  10.611  23.761  1.00 26.82           O  
ATOM    587  CB  LEU   101       4.997  10.452  24.813  1.00 27.14           C  
ATOM    588  CG  LEU   101       6.374  10.483  24.155  1.00 27.77           C  
ATOM    589  CD1 LEU   101       7.364   9.480  24.749  1.00 28.09           C  
ATOM    590  CD2 LEU   101       6.204  10.283  22.646  1.00 27.85           C  
ATOM    591  N   ALA   102       2.113  11.536  25.809  1.00 26.46           N  
ATOM    592  CA  ALA   102       0.725  11.313  26.148  1.00 27.20           C  
ATOM    593  C   ALA   102      -0.163  12.246  25.304  1.00 27.49           C  
ATOM    594  O   ALA   102      -1.179  11.829  24.744  1.00 28.34           O  
ATOM    595  CB  ALA   102       0.495  11.534  27.664  1.00 26.33           C  
ATOM    596  N   LEU   103       0.242  13.502  25.194  1.00 28.56           N  
ATOM    597  CA  LEU   103      -0.483  14.476  24.398  1.00 28.57           C  
ATOM    598  C   LEU   103      -0.498  14.094  22.928  1.00 30.29           C  
ATOM    599  O   LEU   103      -1.466  14.368  22.211  1.00 31.20           O  
ATOM    600  CB  LEU   103       0.150  15.852  24.550  1.00 27.97           C  
ATOM    601  CG  LEU   103      -0.540  16.927  23.734  1.00 27.93           C  
ATOM    602  CD1 LEU   103      -2.056  16.931  24.028  1.00 28.16           C  
ATOM    603  CD2 LEU   103       0.114  18.260  24.005  1.00 27.38           C  
ATOM    604  N   MET   104       0.578  13.477  22.459  1.00 30.91           N  
ATOM    605  CA  MET   104       0.587  13.021  21.088  1.00 31.03           C  
ATOM    606  C   MET   104      -0.356  11.843  20.907  1.00 31.30           C  
ATOM    607  O   MET   104      -1.078  11.768  19.908  1.00 31.91           O  
ATOM    608  CB  MET   104       2.011  12.700  20.593  1.00 29.78           C  
ATOM    609  CG  MET   104       2.852  13.953  20.409  1.00 29.50           C  
ATOM    610  SD  MET   104       4.547  13.560  19.600  0.75 28.40          SE  
ATOM    611  CE  MET   104       4.041  13.148  17.802  1.00 27.34           C  
ATOM    612  N   ASP   105      -0.376  10.926  21.857  1.00 31.23           N  
ATOM    613  CA  ASP   105      -1.286   9.791  21.726  1.00 32.67           C  
ATOM    614  C   ASP   105      -2.788  10.253  21.729  1.00 32.95           C  
ATOM    615  O   ASP   105      -3.590   9.801  20.916  1.00 32.42           O  
ATOM    616  CB  ASP   105      -0.974   8.721  22.766  1.00 32.38           C  
ATOM    617  CG  ASP   105      -1.939   7.573  22.686  1.00 33.91           C  
ATOM    618  OD1 ASP   105      -3.040   7.652  23.253  1.00 33.56           O  
ATOM    619  OD2 ASP   105      -1.555   6.530  22.122  1.00 35.97           O  
ATOM    620  N   PHE   106      -3.129  11.160  22.630  1.00 33.56           N  
ATOM    621  CA  PHE   106      -4.457  11.802  22.702  1.00 35.01           C  
ATOM    622  C   PHE   106      -4.878  12.370  21.332  1.00 36.24           C  
ATOM    623  O   PHE   106      -5.978  12.083  20.818  1.00 36.06           O  
ATOM    624  CB  PHE   106      -4.385  12.903  23.770  1.00 35.80           C  
ATOM    625  CG  PHE   106      -5.655  13.703  23.965  1.00 36.05           C  
ATOM    626  CD1 PHE   106      -6.880  13.073  24.216  1.00 35.54           C  
ATOM    627  CD2 PHE   106      -5.600  15.108  23.982  1.00 36.94           C  
ATOM    628  CE1 PHE   106      -8.029  13.817  24.425  1.00 36.07           C  
ATOM    629  CE2 PHE   106      -6.743  15.860  24.198  1.00 36.31           C  
ATOM    630  CZ  PHE   106      -7.966  15.215  24.432  1.00 36.38           C  
ATOM    631  N   GLU   107      -3.976  13.149  20.733  1.00 37.10           N  
ATOM    632  CA  GLU   107      -4.199  13.781  19.423  1.00 35.80           C  
ATOM    633  C   GLU   107      -4.382  12.751  18.330  1.00 35.02           C  
ATOM    634  O   GLU   107      -5.280  12.864  17.512  1.00 33.91           O  
ATOM    635  CB  GLU   107      -3.049  14.734  19.088  1.00 36.77           C  
ATOM    636  CG  GLU   107      -3.160  16.067  19.838  1.00 35.57           C  
ATOM    637  CD  GLU   107      -2.247  17.140  19.300  1.00 36.65           C  
ATOM    638  OE1 GLU   107      -1.006  16.977  19.321  1.00 37.42           O  
ATOM    639  OE2 GLU   107      -2.761  18.199  18.885  1.00 37.20           O  
ATOM    640  N   TYR   108      -3.534  11.735  18.321  1.00 34.20           N  
ATOM    641  CA  TYR   108      -3.688  10.676  17.353  1.00 35.65           C  
ATOM    642  C   TYR   108      -5.048   9.963  17.523  1.00 34.35           C  
ATOM    643  O   TYR   108      -5.718   9.617  16.551  1.00 34.92           O  
ATOM    644  CB  TYR   108      -2.523   9.682  17.454  1.00 35.28           C  
ATOM    645  CG  TYR   108      -2.558   8.616  16.409  1.00 35.58           C  
ATOM    646  CD1 TYR   108      -2.544   8.953  15.053  1.00 35.63           C  
ATOM    647  CD2 TYR   108      -2.590   7.270  16.761  1.00 34.32           C  
ATOM    648  CE1 TYR   108      -2.584   7.978  14.075  1.00 35.54           C  
ATOM    649  CE2 TYR   108      -2.619   6.298  15.802  1.00 35.87           C  
ATOM    650  CZ  TYR   108      -2.616   6.649  14.449  1.00 35.77           C  
ATOM    651  OH  TYR   108      -2.658   5.681  13.471  1.00 35.26           O  
ATOM    652  N   THR   109      -5.448   9.746  18.769  1.00 35.03           N  
ATOM    653  CA  THR   109      -6.698   9.064  19.076  1.00 33.68           C  
ATOM    654  C   THR   109      -7.861   9.886  18.507  1.00 31.85           C  
ATOM    655  O   THR   109      -8.816   9.315  18.010  1.00 32.82           O  
ATOM    656  CB  THR   109      -6.808   8.731  20.607  1.00 35.01           C  
ATOM    657  OG1 THR   109      -5.735   7.858  20.969  1.00 34.59           O  
ATOM    658  CG2 THR   109      -8.135   8.031  20.970  1.00 33.15           C  
ATOM    659  N   GLN   110      -7.801  11.217  18.549  1.00 30.28           N  
ATOM    660  CA  GLN   110      -8.859  12.002  17.968  1.00 30.39           C  
ATOM    661  C   GLN   110      -8.990  11.707  16.478  1.00 31.29           C  
ATOM    662  O   GLN   110     -10.103  11.494  15.963  1.00 30.97           O  
ATOM    663  CB  GLN   110      -8.678  13.509  18.239  1.00 31.63           C  
ATOM    664  CG  GLN   110      -8.869  13.893  19.712  1.00 31.90           C  
ATOM    665  CD  GLN   110      -8.517  15.343  19.995  1.00 33.22           C  
ATOM    666  OE1 GLN   110      -7.835  15.657  20.974  1.00 34.63           O  
ATOM    667  NE2 GLN   110      -8.977  16.233  19.134  1.00 35.22           N  
ATOM    668  N   LEU   111      -7.858  11.648  15.775  1.00 30.57           N  
ATOM    669  CA  LEU   111      -7.878  11.335  14.362  1.00 30.61           C  
ATOM    670  C   LEU   111      -8.434   9.911  14.164  1.00 31.02           C  
ATOM    671  O   LEU   111      -9.228   9.651  13.260  1.00 30.94           O  
ATOM    672  CB  LEU   111      -6.471  11.490  13.758  1.00 30.95           C  
ATOM    673  CG  LEU   111      -6.293  11.231  12.256  1.00 31.08           C  
ATOM    674  CD1 LEU   111      -7.111  12.147  11.455  1.00 30.25           C  
ATOM    675  CD2 LEU   111      -4.806  11.369  11.903  1.00 31.37           C  
ATOM    676  N   LEU   112      -8.077   8.985  15.037  1.00 31.17           N  
ATOM    677  CA  LEU   112      -8.657   7.657  14.911  1.00 31.52           C  
ATOM    678  C   LEU   112     -10.191   7.645  15.018  1.00 34.16           C  
ATOM    679  O   LEU   112     -10.858   6.803  14.374  1.00 33.67           O  
ATOM    680  CB  LEU   112      -8.070   6.724  15.939  1.00 30.68           C  
ATOM    681  CG  LEU   112      -6.630   6.333  15.739  1.00 28.89           C  
ATOM    682  CD1 LEU   112      -6.242   5.410  16.888  1.00 28.54           C  
ATOM    683  CD2 LEU   112      -6.406   5.663  14.382  1.00 28.98           C  
ATOM    684  N   ALA   113     -10.747   8.598  15.784  1.00 34.42           N  
ATOM    685  CA  ALA   113     -12.190   8.674  15.988  1.00 34.82           C  
ATOM    686  C   ALA   113     -12.821   9.386  14.806  1.00 36.77           C  
ATOM    687  O   ALA   113     -13.933   9.038  14.385  1.00 34.40           O  
ATOM    688  CB  ALA   113     -12.513   9.386  17.282  1.00 33.82           C  
ATOM    689  N   GLU   114     -12.105  10.396  14.285  1.00 38.02           N  
ATOM    690  CA  GLU   114     -12.525  11.148  13.083  1.00 38.27           C  
ATOM    691  C   GLU   114     -12.688  10.230  11.866  1.00 37.71           C  
ATOM    692  O   GLU   114     -13.631  10.376  11.072  1.00 35.85           O  
ATOM    693  CB  GLU   114     -11.479  12.231  12.748  1.00 38.46           C  
ATOM    694  CG  GLU   114     -11.625  12.955  11.411  1.00 38.44           C  
ATOM    695  CD  GLU   114     -12.912  13.774  11.263  1.00 39.18           C  
ATOM    696  OE1 GLU   114     -13.863  13.564  12.052  1.00 39.13           O  
ATOM    697  OE2 GLU   114     -12.969  14.629  10.339  1.00 38.38           O  
ATOM    698  N   VAL   115     -11.786   9.260  11.783  1.00 36.86           N  
ATOM    699  CA  VAL   115     -11.649   8.407  10.616  1.00 37.42           C  
ATOM    700  C   VAL   115     -12.283   7.031  10.766  1.00 37.20           C  
ATOM    701  O   VAL   115     -12.437   6.316   9.783  1.00 36.94           O  
ATOM    702  CB  VAL   115     -10.088   8.346  10.255  1.00 37.61           C  
ATOM    703  CG1 VAL   115      -9.631   7.000   9.754  1.00 37.26           C  
ATOM    704  CG2 VAL   115      -9.717   9.491   9.349  1.00 35.81           C  
ATOM    705  N   ALA   116     -12.693   6.662  11.972  1.00 37.42           N  
ATOM    706  CA  ALA   116     -13.258   5.331  12.187  1.00 37.49           C  
ATOM    707  C   ALA   116     -14.540   5.101  11.376  1.00 37.88           C  
ATOM    708  O   ALA   116     -15.338   6.015  11.165  1.00 37.84           O  
ATOM    709  CB  ALA   116     -13.500   5.083  13.680  1.00 38.00           C  
ATOM    710  N   GLN   117     -14.690   3.876  10.881  1.00 39.14           N  
ATOM    711  CA  GLN   117     -15.857   3.473  10.117  1.00 39.51           C  
ATOM    712  C   GLN   117     -16.844   2.904  11.096  1.00 39.20           C  
ATOM    713  O   GLN   117     -16.541   1.915  11.775  1.00 39.62           O  
ATOM    714  CB  GLN   117     -15.520   2.391   9.087  1.00 40.02           C  
ATOM    715  CG  GLN   117     -16.761   1.831   8.351  1.00 40.38           C  
ATOM    716  N   ILE   118     -18.023   3.517  11.148  1.00 38.74           N  
ATOM    717  CA  ILE   118     -19.100   3.113  12.047  1.00 37.74           C  
ATOM    718  C   ILE   118     -20.190   2.493  11.173  1.00 37.96           C  
ATOM    719  O   ILE   118     -20.690   3.184  10.284  1.00 37.83           O  
ATOM    720  CB  ILE   118     -19.650   4.354  12.786  1.00 36.97           C  
ATOM    721  CG1 ILE   118     -18.576   4.967  13.676  1.00 36.79           C  
ATOM    722  CG2 ILE   118     -20.836   3.996  13.663  1.00 37.44           C  
ATOM    723  CD1 ILE   118     -18.946   6.361  14.158  1.00 36.94           C  
ATOM    724  N   PRO   119     -20.504   1.180  11.345  1.00 37.96           N  
ATOM    725  CA  PRO   119     -21.559   0.572  10.535  1.00 37.61           C  
ATOM    726  C   PRO   119     -22.869   1.352  10.481  1.00 37.30           C  
ATOM    727  O   PRO   119     -23.244   2.008  11.459  1.00 37.04           O  
ATOM    728  CB  PRO   119     -21.800  -0.801  11.196  1.00 38.22           C  
ATOM    729  CG  PRO   119     -20.857  -0.881  12.383  1.00 38.45           C  
ATOM    730  CD  PRO   119     -19.820   0.169  12.178  1.00 38.93           C  
ATOM    731  N   ASP   120     -23.525   1.290   9.321  1.00 36.76           N  
ATOM    732  CA  ASP   120     -24.832   1.907   9.121  1.00 36.79           C  
ATOM    733  C   ASP   120     -25.816   1.213  10.070  1.00 36.53           C  
ATOM    734  O   ASP   120     -25.821  -0.020  10.190  1.00 36.76           O  
ATOM    735  CB  ASP   120     -25.290   1.781   7.665  1.00 35.70           C  
ATOM    736  N   ILE   121     -26.612   2.007  10.777  1.00 36.81           N  
ATOM    737  CA  ILE   121     -27.601   1.463  11.728  1.00 36.43           C  
ATOM    738  C   ILE   121     -29.007   1.772  11.216  1.00 36.10           C  
ATOM    739  O   ILE   121     -29.369   2.955  11.079  1.00 36.53           O  
ATOM    740  CB  ILE   121     -27.441   2.053  13.157  1.00 36.35           C  
ATOM    741  CG1 ILE   121     -26.346   1.342  13.987  1.00 36.03           C  
ATOM    742  CG2 ILE   121     -28.747   1.798  13.971  1.00 36.54           C  
ATOM    743  CD1 ILE   121     -25.097   1.027  13.356  1.00 35.96           C  
ATOM    744  N   PRO   122     -29.788   0.728  10.870  1.00 35.15           N  
ATOM    745  CA  PRO   122     -31.171   1.018  10.479  1.00 34.84           C  
ATOM    746  C   PRO   122     -31.915   1.759  11.588  1.00 34.29           C  
ATOM    747  O   PRO   122     -31.737   1.480  12.791  1.00 32.53           O  
ATOM    748  CB  PRO   122     -31.781  -0.367  10.236  1.00 35.03           C  
ATOM    749  CG  PRO   122     -30.621  -1.233   9.907  1.00 35.38           C  
ATOM    750  CD  PRO   122     -29.488  -0.711  10.766  1.00 35.15           C  
ATOM    751  N   ASP   123     -32.722   2.719  11.165  1.00 34.56           N  
ATOM    752  CA  ASP   123     -33.461   3.540  12.081  1.00 34.50           C  
ATOM    753  C   ASP   123     -34.829   2.908  12.365  1.00 33.08           C  
ATOM    754  O   ASP   123     -35.856   3.309  11.826  1.00 32.07           O  
ATOM    755  CB  ASP   123     -33.559   4.950  11.511  1.00 35.67           C  
ATOM    756  CG  ASP   123     -33.888   5.972  12.555  1.00 36.62           C  
ATOM    757  OD1 ASP   123     -33.929   5.622  13.755  1.00 37.75           O  
ATOM    758  OD2 ASP   123     -34.108   7.133  12.166  1.00 38.52           O  
ATOM    759  N   ILE   124     -34.798   1.901  13.241  1.00 32.79           N  
ATOM    760  CA  ILE   124     -35.975   1.159  13.684  1.00 31.54           C  
ATOM    761  C   ILE   124     -36.037   1.214  15.210  1.00 31.99           C  
ATOM    762  O   ILE   124     -35.290   1.969  15.851  1.00 31.86           O  
ATOM    763  CB  ILE   124     -35.939  -0.318  13.192  1.00 30.72           C  
ATOM    764  CG1 ILE   124     -34.792  -1.106  13.840  1.00 30.34           C  
ATOM    765  CG2 ILE   124     -35.842  -0.352  11.657  1.00 30.34           C  
ATOM    766  CD1 ILE   124     -34.778  -2.601  13.479  1.00 30.60           C  
ATOM    767  N   HIS   125     -36.940   0.427  15.795  1.00 31.68           N  
ATOM    768  CA  HIS   125     -37.063   0.371  17.238  1.00 30.63           C  
ATOM    769  C   HIS   125     -36.133  -0.690  17.806  1.00 31.38           C  
ATOM    770  O   HIS   125     -36.158  -1.848  17.378  1.00 31.11           O  
ATOM    771  CB  HIS   125     -38.491   0.061  17.652  1.00 30.09           C  
ATOM    772  CG  HIS   125     -38.703   0.103  19.128  1.00 29.67           C  
ATOM    773  ND1 HIS   125     -39.161   1.227  19.774  1.00 29.17           N  
ATOM    774  CD2 HIS   125     -38.504  -0.835  20.088  1.00 29.71           C  
ATOM    775  CE1 HIS   125     -39.249   0.976  21.071  1.00 30.24           C  
ATOM    776  NE2 HIS   125     -38.846  -0.265  21.288  1.00 29.36           N  
ATOM    777  N   TYR   126     -35.284  -0.281  18.752  1.00 32.16           N  
ATOM    778  CA  TYR   126     -34.413  -1.222  19.455  1.00 32.02           C  
ATOM    779  C   TYR   126     -34.825  -1.190  20.918  1.00 30.88           C  
ATOM    780  O   TYR   126     -34.697  -0.178  21.569  1.00 30.80           O  
ATOM    781  CB  TYR   126     -32.932  -0.859  19.288  1.00 31.79           C  
ATOM    782  CG  TYR   126     -32.460  -0.901  17.833  1.00 31.58           C  
ATOM    783  CD1 TYR   126     -32.175  -2.120  17.209  1.00 31.68           C  
ATOM    784  CD2 TYR   126     -32.302   0.271  17.090  1.00 31.54           C  
ATOM    785  CE1 TYR   126     -31.745  -2.176  15.868  1.00 31.67           C  
ATOM    786  CE2 TYR   126     -31.876   0.230  15.763  1.00 31.47           C  
ATOM    787  CZ  TYR   126     -31.592  -1.006  15.157  1.00 31.98           C  
ATOM    788  OH  TYR   126     -31.172  -1.075  13.832  1.00 32.02           O  
ATOM    789  N   SER   127     -35.346  -2.299  21.429  1.00 30.50           N  
ATOM    790  CA  SER   127     -35.776  -2.363  22.835  1.00 28.63           C  
ATOM    791  C   SER   127     -34.573  -2.540  23.798  1.00 28.44           C  
ATOM    792  O   SER   127     -33.393  -2.582  23.369  1.00 27.83           O  
ATOM    793  CB  SER   127     -36.712  -3.532  23.010  1.00 27.86           C  
ATOM    794  OG  SER   127     -35.992  -4.736  22.923  1.00 26.15           O  
ATOM    795  N   ASN   128     -34.881  -2.633  25.088  1.00 27.65           N  
ATOM    796  CA  ASN   128     -33.875  -2.896  26.115  1.00 27.69           C  
ATOM    797  C   ASN   128     -33.578  -4.373  26.171  1.00 27.51           C  
ATOM    798  O   ASN   128     -32.877  -4.812  27.051  1.00 26.32           O  
ATOM    799  CB  ASN   128     -34.288  -2.387  27.484  1.00 27.86           C  
ATOM    800  CG  ASN   128     -34.374  -0.865  27.550  1.00 29.20           C  
ATOM    801  OD1 ASN   128     -33.713  -0.173  26.812  1.00 30.68           O  
ATOM    802  ND2 ASN   128     -35.174  -0.362  28.454  1.00 30.11           N  
ATOM    803  N   ASP   129     -34.124  -5.130  25.235  1.00 29.56           N  
ATOM    804  CA  ASP   129     -33.754  -6.527  25.072  1.00 32.20           C  
ATOM    805  C   ASP   129     -32.702  -6.608  23.947  1.00 32.50           C  
ATOM    806  O   ASP   129     -32.026  -7.621  23.812  1.00 31.46           O  
ATOM    807  CB  ASP   129     -34.944  -7.367  24.692  1.00 32.76           C  
ATOM    808  CG  ASP   129     -34.645  -8.857  24.803  1.00 33.97           C  
ATOM    809  OD1 ASP   129     -34.244  -9.281  25.911  1.00 35.60           O  
ATOM    810  OD2 ASP   129     -34.794  -9.594  23.799  1.00 33.96           O  
ATOM    811  N   SER   130     -32.564  -5.529  23.158  1.00 33.49           N  
ATOM    812  CA  SER   130     -31.562  -5.471  22.058  1.00 34.51           C  
ATOM    813  C   SER   130     -30.140  -5.183  22.523  1.00 33.88           C  
ATOM    814  O   SER   130     -29.894  -4.208  23.252  1.00 34.32           O  
ATOM    815  CB  SER   130     -31.914  -4.418  20.997  1.00 35.21           C  
ATOM    816  OG  SER   130     -32.926  -4.883  20.134  1.00 37.41           O  
ATOM    817  N   LYS   131     -29.203  -5.992  22.028  1.00 32.98           N  
ATOM    818  CA  LYS   131     -27.788  -5.831  22.372  1.00 33.25           C  
ATOM    819  C   LYS   131     -27.079  -4.623  21.752  1.00 34.21           C  
ATOM    820  O   LYS   131     -27.345  -4.219  20.600  1.00 35.24           O  
ATOM    821  CB  LYS   131     -26.998  -7.079  21.997  1.00 32.43           C  
ATOM    822  CG  LYS   131     -27.365  -8.340  22.731  1.00 30.56           C  
ATOM    823  CD  LYS   131     -26.298  -9.360  22.420  1.00 30.14           C  
ATOM    824  CE  LYS   131     -26.583 -10.694  23.034  1.00 29.35           C  
ATOM    825  NZ  LYS   131     -25.600 -11.650  22.472  1.00 28.55           N  
ATOM    826  N   TYR   132     -26.167  -4.059  22.541  1.00 34.56           N  
ATOM    827  CA  TYR   132     -25.337  -2.923  22.138  1.00 34.57           C  
ATOM    828  C   TYR   132     -23.860  -3.303  22.258  1.00 34.03           C  
ATOM    829  O   TYR   132     -23.496  -4.298  22.895  1.00 34.91           O  
ATOM    830  CB  TYR   132     -25.671  -1.656  22.924  1.00 34.95           C  
ATOM    831  CG  TYR   132     -26.909  -0.970  22.392  1.00 35.34           C  
ATOM    832  CD1 TYR   132     -28.161  -1.550  22.548  1.00 34.93           C  
ATOM    833  CD2 TYR   132     -26.833   0.271  21.743  1.00 34.71           C  
ATOM    834  CE1 TYR   132     -29.296  -0.961  22.038  1.00 34.57           C  
ATOM    835  CE2 TYR   132     -27.960   0.871  21.238  1.00 35.07           C  
ATOM    836  CZ  TYR   132     -29.195   0.240  21.397  1.00 35.45           C  
ATOM    837  OH  TYR   132     -30.333   0.810  20.913  1.00 35.94           O  
ATOM    838  N   THR   133     -23.056  -2.574  21.513  1.00 33.01           N  
ATOM    839  CA  THR   133     -21.608  -2.737  21.451  1.00 33.04           C  
ATOM    840  C   THR   133     -21.076  -1.286  21.444  1.00 32.43           C  
ATOM    841  O   THR   133     -21.792  -0.373  21.008  1.00 31.13           O  
ATOM    842  CB  THR   133     -21.239  -3.499  20.159  1.00 33.45           C  
ATOM    843  OG1 THR   133     -19.837  -3.816  20.132  1.00 34.34           O  
ATOM    844  CG2 THR   133     -21.665  -2.709  18.889  1.00 32.15           C  
ATOM    845  N   PRO   134     -19.856  -1.044  21.947  1.00 33.28           N  
ATOM    846  CA  PRO   134     -19.356   0.372  21.853  1.00 32.73           C  
ATOM    847  C   PRO   134     -19.064   0.749  20.393  1.00 31.84           C  
ATOM    848  O   PRO   134     -18.792  -0.114  19.609  1.00 31.68           O  
ATOM    849  CB  PRO   134     -18.052   0.372  22.660  1.00 33.47           C  
ATOM    850  CG  PRO   134     -17.881  -1.021  23.202  1.00 34.04           C  
ATOM    851  CD  PRO   134     -18.877  -1.956  22.542  1.00 33.56           C  
ATOM    852  N   SER   135     -19.118   2.029  20.027  1.00 33.13           N  
ATOM    853  CA  SER   135     -18.845   2.424  18.654  0.50 31.70           C  
ATOM    855  C   SER   135     -17.407   2.086  18.288  1.00 32.82           C  
ATOM    856  O   SER   135     -16.504   2.197  19.131  1.00 34.51           O  
ATOM    857  CB  SER   135     -19.048   3.926  18.440  0.50 30.68           C  
ATOM    859  OG  SER   135     -18.698   4.292  17.117  0.50 27.27           O  
ATOM    861  N   PRO   136     -17.181   1.647  17.036  1.00 30.78           N  
ATOM    862  CA  PRO   136     -15.796   1.420  16.680  1.00 30.75           C  
ATOM    863  C   PRO   136     -15.003   2.724  16.706  1.00 31.52           C  
ATOM    864  O   PRO   136     -13.776   2.688  16.676  1.00 33.29           O  
ATOM    865  CB  PRO   136     -15.860   0.839  15.259  1.00 31.65           C  
ATOM    866  CG  PRO   136     -17.265   0.651  14.924  1.00 30.94           C  
ATOM    867  CD  PRO   136     -18.124   1.292  15.964  1.00 30.49           C  
ATOM    868  N   ALA   137     -15.693   3.870  16.781  1.00 32.33           N  
ATOM    869  CA  ALA   137     -15.056   5.159  16.842  1.00 33.46           C  
ATOM    870  C   ALA   137     -14.846   5.650  18.274  1.00 34.89           C  
ATOM    871  O   ALA   137     -14.559   6.845  18.467  1.00 34.59           O  
ATOM    872  CB  ALA   137     -15.902   6.193  16.070  1.00 32.66           C  
ATOM    873  N   ALA   138     -15.024   4.752  19.248  1.00 34.13           N  
ATOM    874  CA  ALA   138     -14.902   5.049  20.685  1.00 35.16           C  
ATOM    875  C   ALA   138     -13.668   4.388  21.264  1.00 35.13           C  
ATOM    876  O   ALA   138     -13.452   3.192  21.086  1.00 34.97           O  
ATOM    877  CB  ALA   138     -16.161   4.574  21.462  1.00 35.04           C  
ATOM    878  N   PHE   139     -12.870   5.180  21.959  1.00 35.95           N  
ATOM    879  CA  PHE   139     -11.614   4.734  22.528  1.00 36.87           C  
ATOM    880  C   PHE   139     -11.471   5.138  23.993  1.00 36.57           C  
ATOM    881  O   PHE   139     -11.821   6.270  24.388  1.00 36.96           O  
ATOM    882  CB  PHE   139     -10.447   5.322  21.731  1.00 37.58           C  
ATOM    883  CG  PHE   139     -10.437   4.917  20.257  1.00 38.18           C  
ATOM    884  CD1 PHE   139     -11.110   5.675  19.304  1.00 37.01           C  
ATOM    885  CD2 PHE   139      -9.756   3.790  19.838  1.00 37.84           C  
ATOM    886  CE1 PHE   139     -11.115   5.313  17.985  1.00 36.83           C  
ATOM    887  CE2 PHE   139      -9.764   3.431  18.501  1.00 37.78           C  
ATOM    888  CZ  PHE   139     -10.441   4.210  17.578  1.00 37.29           C  
ATOM    889  N   ILE   140     -10.952   4.201  24.778  1.00 35.26           N  
ATOM    890  CA  ILE   140     -10.656   4.414  26.186  1.00 36.28           C  
ATOM    891  C   ILE   140      -9.157   4.673  26.333  1.00 36.01           C  
ATOM    892  O   ILE   140      -8.360   3.790  25.981  1.00 35.21           O  
ATOM    893  CB  ILE   140     -10.980   3.153  27.042  1.00 36.47           C  
ATOM    894  CG1 ILE   140     -12.471   2.827  26.992  1.00 36.86           C  
ATOM    895  CG2 ILE   140     -10.505   3.359  28.507  1.00 36.54           C  
ATOM    896  CD1 ILE   140     -12.823   1.467  27.609  1.00 37.66           C  
ATOM    897  N   ARG   141      -8.788   5.832  26.895  1.00 35.41           N  
ATOM    898  CA  ARG   141      -7.369   6.211  27.124  1.00 34.78           C  
ATOM    899  C   ARG   141      -7.021   6.495  28.588  1.00 34.90           C  
ATOM    900  O   ARG   141      -7.810   7.115  29.289  1.00 34.61           O  
ATOM    901  CB  ARG   141      -7.002   7.454  26.281  1.00 34.37           C  
ATOM    902  CG  ARG   141      -6.906   7.196  24.783  1.00 34.55           C  
ATOM    903  CD  ARG   141      -5.886   6.100  24.513  1.00 34.71           C  
ATOM    904  NE  ARG   141      -5.766   5.735  23.120  1.00 35.21           N  
ATOM    905  CZ  ARG   141      -6.274   4.642  22.544  1.00 35.59           C  
ATOM    906  NH1 ARG   141      -6.948   3.726  23.222  1.00 36.12           N  
ATOM    907  NH2 ARG   141      -6.061   4.446  21.255  1.00 35.22           N  
ATOM    908  N   GLN   142      -5.829   6.055  29.026  1.00 35.09           N  
ATOM    909  CA  GLN   142      -5.313   6.302  30.408  1.00 34.44           C  
ATOM    910  C   GLN   142      -3.952   6.997  30.332  1.00 33.94           C  
ATOM    911  O   GLN   142      -2.990   6.428  29.822  1.00 33.71           O  
ATOM    912  CB  GLN   142      -5.165   4.993  31.211  1.00 34.70           C  
ATOM    913  CG  GLN   142      -6.405   4.095  31.212  1.00 34.93           C  
ATOM    914  CD  GLN   142      -6.277   2.878  32.097  1.00 35.35           C  
ATOM    915  OE1 GLN   142      -5.995   1.783  31.618  1.00 37.10           O  
ATOM    916  NE2 GLN   142      -6.483   3.062  33.407  1.00 35.35           N  
ATOM    917  N   TYR   143      -3.881   8.225  30.827  1.00 34.02           N  
ATOM    918  CA  TYR   143      -2.631   9.020  30.818  1.00 34.50           C  
ATOM    919  C   TYR   143      -2.240   9.431  32.225  1.00 34.11           C  
ATOM    920  O   TYR   143      -3.114   9.610  33.080  1.00 31.71           O  
ATOM    921  CB  TYR   143      -2.790  10.270  29.944  1.00 34.05           C  
ATOM    922  CG  TYR   143      -3.195   9.923  28.526  1.00 34.61           C  
ATOM    923  CD1 TYR   143      -2.358   9.148  27.710  1.00 34.14           C  
ATOM    924  CD2 TYR   143      -4.393  10.372  27.990  1.00 34.69           C  
ATOM    925  CE1 TYR   143      -2.723   8.821  26.415  1.00 34.01           C  
ATOM    926  CE2 TYR   143      -4.752  10.053  26.693  1.00 34.66           C  
ATOM    927  CZ  TYR   143      -3.917   9.279  25.920  1.00 33.99           C  
ATOM    928  OH  TYR   143      -4.288   8.971  24.642  1.00 34.35           O  
ATOM    929  N   ARG   144      -0.930   9.536  32.463  1.00 33.80           N  
ATOM    930  CA  ARG   144      -0.404   9.988  33.742  1.00 35.60           C  
ATOM    931  C   ARG   144      -0.280  11.510  33.721  1.00 34.05           C  
ATOM    932  O   ARG   144       0.192  12.107  34.681  1.00 33.51           O  
ATOM    933  CB  ARG   144       0.960   9.359  34.046  1.00 36.36           C  
ATOM    934  CG  ARG   144       0.991   7.822  33.954  1.00 38.03           C  
ATOM    935  CD  ARG   144       2.367   7.245  34.238  1.00 39.35           C  
ATOM    936  NE  ARG   144       3.382   8.268  34.007  1.00 41.24           N  
ATOM    937  CZ  ARG   144       4.601   8.071  33.506  1.00 42.86           C  
ATOM    938  NH1 ARG   144       5.012   6.867  33.093  1.00 43.50           N  
ATOM    939  NH2 ARG   144       5.405   9.127  33.377  1.00 42.35           N  
ATOM    940  N   TYR   145      -0.745  12.128  32.635  1.00 34.23           N  
ATOM    941  CA  TYR   145      -0.684  13.578  32.457  1.00 32.95           C  
ATOM    942  C   TYR   145      -2.013  14.174  32.013  1.00 33.09           C  
ATOM    943  O   TYR   145      -2.810  13.522  31.365  1.00 32.37           O  
ATOM    944  CB  TYR   145       0.391  13.878  31.438  1.00 33.59           C  
ATOM    945  CG  TYR   145       1.744  13.420  31.917  1.00 33.35           C  
ATOM    946  CD1 TYR   145       2.172  12.122  31.711  1.00 33.26           C  
ATOM    947  CD2 TYR   145       2.574  14.285  32.608  1.00 33.75           C  
ATOM    948  CE1 TYR   145       3.389  11.697  32.170  1.00 33.34           C  
ATOM    949  CE2 TYR   145       3.791  13.876  33.057  1.00 33.71           C  
ATOM    950  CZ  TYR   145       4.194  12.583  32.837  1.00 33.55           C  
ATOM    951  OH  TYR   145       5.411  12.193  33.306  1.00 34.34           O  
ATOM    952  N   ASP   146      -2.262  15.439  32.332  1.00 34.92           N  
ATOM    953  CA  ASP   146      -3.539  16.038  31.934  1.00 35.59           C  
ATOM    954  C   ASP   146      -3.410  16.548  30.509  1.00 36.12           C  
ATOM    955  O   ASP   146      -3.083  17.710  30.275  1.00 36.73           O  
ATOM    956  CB  ASP   146      -4.019  17.144  32.888  1.00 35.23           C  
ATOM    957  CG  ASP   146      -5.482  17.501  32.657  1.00 35.45           C  
ATOM    958  OD1 ASP   146      -6.054  17.045  31.633  1.00 35.51           O  
ATOM    959  OD2 ASP   146      -6.072  18.196  33.509  1.00 34.99           O  
ATOM    960  N   VAL   147      -3.683  15.652  29.569  1.00 36.09           N  
ATOM    961  CA  VAL   147      -3.580  15.934  28.139  1.00 36.00           C  
ATOM    962  C   VAL   147      -4.681  16.859  27.646  1.00 37.54           C  
ATOM    963  O   VAL   147      -4.578  17.393  26.557  1.00 38.09           O  
ATOM    964  CB  VAL   147      -3.653  14.622  27.297  1.00 35.38           C  
ATOM    965  CG1 VAL   147      -2.531  13.675  27.681  1.00 34.28           C  
ATOM    966  CG2 VAL   147      -5.046  13.949  27.459  1.00 35.03           C  
ATOM    967  N   THR   148      -5.742  17.046  28.430  1.00 40.08           N  
ATOM    968  CA  THR   148      -6.843  17.939  28.035  1.00 40.62           C  
ATOM    969  C   THR   148      -6.586  19.399  28.419  1.00 41.55           C  
ATOM    970  O   THR   148      -7.293  20.309  27.964  1.00 40.82           O  
ATOM    971  CB  THR   148      -8.162  17.553  28.734  1.00 41.38           C  
ATOM    972  OG1 THR   148      -8.043  17.840  30.131  1.00 41.87           O  
ATOM    973  CG2 THR   148      -8.513  16.076  28.536  1.00 40.38           C  
ATOM    974  N   HIS   149      -5.595  19.618  29.276  1.00 42.58           N  
ATOM    975  CA  HIS   149      -5.297  20.956  29.770  1.00 43.38           C  
ATOM    976  C   HIS   149      -3.855  21.343  29.493  1.00 44.04           C  
ATOM    977  O   HIS   149      -3.579  21.904  28.430  1.00 43.03           O  
ATOM    978  CB  HIS   149      -5.634  21.082  31.267  1.00 44.14           C  
ATOM    979  CG  HIS   149      -5.333  22.430  31.836  1.00 44.34           C  
ATOM    980  ND1 HIS   149      -4.211  22.681  32.599  1.00 45.27           N  
ATOM    981  CD2 HIS   149      -5.980  23.614  31.721  1.00 44.87           C  
ATOM    982  CE1 HIS   149      -4.182  23.959  32.938  1.00 44.79           C  
ATOM    983  NE2 HIS   149      -5.249  24.547  32.422  1.00 44.80           N  
ATOM    984  N   ASP   150      -2.930  21.021  30.401  1.00 44.79           N  
ATOM    985  CA  ASP   150      -1.545  21.482  30.234  1.00 45.74           C  
ATOM    986  C   ASP   150      -0.462  20.502  30.737  1.00 45.36           C  
ATOM    987  O   ASP   150       0.588  20.917  31.227  1.00 44.69           O  
ATOM    988  CB  ASP   150      -1.397  22.858  30.890  1.00 46.83           C  
ATOM    989  CG  ASP   150      -0.334  23.714  30.233  1.00 48.68           C  
ATOM    990  OD1 ASP   150       0.428  23.212  29.361  1.00 50.39           O  
ATOM    991  OD2 ASP   150      -0.277  24.916  30.573  1.00 49.33           O  
ATOM    992  N   LEU   151      -0.739  19.209  30.572  1.00 44.73           N  
ATOM    993  CA  LEU   151       0.187  18.114  30.895  1.00 44.03           C  
ATOM    994  C   LEU   151       0.579  18.010  32.352  1.00 43.81           C  
ATOM    995  O   LEU   151       1.716  17.673  32.662  1.00 43.47           O  
ATOM    996  CB  LEU   151       1.441  18.183  30.011  1.00 43.12           C  
ATOM    997  CG  LEU   151       1.178  18.324  28.509  1.00 42.79           C  
ATOM    998  CD1 LEU   151       2.482  18.181  27.706  1.00 41.99           C  
ATOM    999  CD2 LEU   151       0.145  17.316  28.042  1.00 42.24           C  
ATOM   1000  N   GLN   152      -0.378  18.295  33.234  1.00 44.58           N  
ATOM   1001  CA  GLN   152      -0.191  18.162  34.682  1.00 44.48           C  
ATOM   1002  C   GLN   152       0.076  16.686  34.995  1.00 43.53           C  
ATOM   1003  O   GLN   152      -0.577  15.837  34.422  1.00 42.55           O  
ATOM   1004  CB  GLN   152      -1.480  18.582  35.445  1.00 44.70           C  
ATOM   1005  CG  GLN   152      -1.749  20.098  35.662  1.00 45.24           C  
ATOM   1006  CD  GLN   152      -2.106  20.916  34.406  1.00 45.34           C  
ATOM   1007  OE1 GLN   152      -2.549  20.376  33.391  1.00 43.86           O  
ATOM   1008  NE2 GLN   152      -1.931  22.247  34.501  1.00 45.02           N  
ATOM   1009  N   GLU   153       1.051  16.373  35.851  1.00 43.57           N  
ATOM   1010  CA  GLU   153       1.211  14.992  36.314  1.00 43.21           C  
ATOM   1011  C   GLU   153      -0.005  14.717  37.178  1.00 42.36           C  
ATOM   1012  O   GLU   153      -0.084  15.217  38.289  1.00 42.69           O  
ATOM   1013  CB  GLU   153       2.466  14.763  37.150  1.00 43.26           C  
ATOM   1014  CG  GLU   153       3.628  14.244  36.395  1.00 44.27           C  
ATOM   1015  CD  GLU   153       4.799  13.889  37.298  1.00 45.15           C  
ATOM   1016  OE1 GLU   153       5.089  14.665  38.243  1.00 46.26           O  
ATOM   1017  OE2 GLU   153       5.453  12.849  37.043  1.00 46.21           O  
ATOM   1018  N   ALA   154      -0.938  13.936  36.642  1.00 41.00           N  
ATOM   1019  CA  ALA   154      -2.180  13.601  37.311  1.00 40.63           C  
ATOM   1020  C   ALA   154      -2.851  12.510  36.492  1.00 39.98           C  
ATOM   1021  O   ALA   154      -3.087  12.710  35.296  1.00 40.14           O  
ATOM   1022  CB  ALA   154      -3.083  14.827  37.394  1.00 40.73           C  
ATOM   1023  N   GLU   155      -3.118  11.358  37.113  1.00 39.02           N  
ATOM   1024  CA  GLU   155      -3.806  10.248  36.442  1.00 38.44           C  
ATOM   1025  C   GLU   155      -5.091  10.729  35.778  1.00 38.05           C  
ATOM   1026  O   GLU   155      -6.012  11.181  36.454  1.00 36.52           O  
ATOM   1027  CB  GLU   155      -4.125   9.092  37.413  1.00 38.51           C  
ATOM   1028  CG  GLU   155      -2.928   8.203  37.826  1.00 39.18           C  
ATOM   1029  CD  GLU   155      -2.304   7.406  36.667  1.00 39.11           C  
ATOM   1030  OE1 GLU   155      -2.806   7.502  35.528  1.00 39.80           O  
ATOM   1031  OE2 GLU   155      -1.309   6.676  36.900  1.00 39.33           O  
ATOM   1032  N   THR   156      -5.150  10.605  34.450  1.00 38.58           N  
ATOM   1033  CA  THR   156      -6.315  11.049  33.668  1.00 39.32           C  
ATOM   1034  C   THR   156      -6.908   9.901  32.842  1.00 38.56           C  
ATOM   1035  O   THR   156      -6.191   9.175  32.177  1.00 38.94           O  
ATOM   1036  CB  THR   156      -5.961  12.238  32.748  1.00 39.69           C  
ATOM   1037  OG1 THR   156      -5.110  13.151  33.460  1.00 39.65           O  
ATOM   1038  CG2 THR   156      -7.238  12.951  32.288  1.00 38.88           C  
ATOM   1039  N   ALA   157      -8.228   9.758  32.907  1.00 38.33           N  
ATOM   1040  CA  ALA   157      -8.964   8.679  32.254  1.00 38.48           C  
ATOM   1041  C   ALA   157     -10.000   9.322  31.326  1.00 38.25           C  
ATOM   1042  O   ALA   157     -10.901  10.005  31.789  1.00 38.07           O  
ATOM   1043  CB  ALA   157      -9.649   7.780  33.328  1.00 37.18           C  
ATOM   1044  N   LEU   158      -9.871   9.098  30.019  1.00 38.80           N  
ATOM   1045  CA  LEU   158     -10.745   9.736  29.012  1.00 38.15           C  
ATOM   1046  C   LEU   158     -11.397   8.749  28.057  1.00 38.07           C  
ATOM   1047  O   LEU   158     -10.844   7.676  27.783  1.00 37.00           O  
ATOM   1048  CB  LEU   158      -9.907  10.718  28.177  1.00 37.77           C  
ATOM   1049  CG  LEU   158      -9.233  11.893  28.915  1.00 38.21           C  
ATOM   1050  CD1 LEU   158      -8.066  12.510  28.104  1.00 36.98           C  
ATOM   1051  CD2 LEU   158     -10.248  12.946  29.326  1.00 36.74           C  
ATOM   1052  N   LEU   159     -12.573   9.125  27.553  1.00 38.32           N  
ATOM   1053  CA  LEU   159     -13.288   8.364  26.494  1.00 37.73           C  
ATOM   1054  C   LEU   159     -13.305   9.288  25.310  1.00 37.07           C  
ATOM   1055  O   LEU   159     -13.845  10.410  25.428  1.00 37.83           O  
ATOM   1056  CB  LEU   159     -14.742   8.037  26.854  1.00 37.83           C  
ATOM   1057  CG  LEU   159     -15.545   7.301  25.775  1.00 38.57           C  
ATOM   1058  CD1 LEU   159     -14.891   5.919  25.489  1.00 38.98           C  
ATOM   1059  CD2 LEU   159     -17.048   7.119  26.134  1.00 37.71           C  
ATOM   1060  N   ILE   160     -12.697   8.869  24.198  1.00 35.82           N  
ATOM   1061  CA  ILE   160     -12.689   9.678  22.962  1.00 35.81           C  
ATOM   1062  C   ILE   160     -13.626   8.993  21.964  1.00 35.30           C  
ATOM   1063  O   ILE   160     -13.571   7.751  21.790  1.00 32.61           O  
ATOM   1064  CB  ILE   160     -11.259   9.822  22.346  1.00 35.67           C  
ATOM   1065  CG1 ILE   160     -10.329  10.615  23.269  1.00 36.38           C  
ATOM   1066  CG2 ILE   160     -11.341  10.519  21.005  1.00 36.24           C  
ATOM   1067  CD1 ILE   160      -9.693   9.814  24.356  1.00 35.92           C  
ATOM   1068  N   TRP   161     -14.533   9.753  21.358  1.00 34.16           N  
ATOM   1069  CA  TRP   161     -15.456   9.155  20.384  1.00 35.62           C  
ATOM   1070  C   TRP   161     -15.980  10.135  19.343  1.00 36.26           C  
ATOM   1071  O   TRP   161     -15.693  11.326  19.429  1.00 35.77           O  
ATOM   1072  CB  TRP   161     -16.644   8.522  21.109  1.00 37.38           C  
ATOM   1073  CG  TRP   161     -17.718   9.455  21.577  1.00 37.18           C  
ATOM   1074  CD1 TRP   161     -18.903   9.685  20.966  1.00 37.71           C  
ATOM   1075  CD2 TRP   161     -17.728  10.237  22.773  1.00 37.19           C  
ATOM   1076  NE1 TRP   161     -19.642  10.576  21.678  1.00 37.89           N  
ATOM   1077  CE2 TRP   161     -18.945  10.934  22.798  1.00 38.42           C  
ATOM   1078  CE3 TRP   161     -16.816  10.435  23.808  1.00 37.18           C  
ATOM   1079  CZ2 TRP   161     -19.276  11.835  23.813  1.00 38.40           C  
ATOM   1080  CZ3 TRP   161     -17.142  11.285  24.818  1.00 37.74           C  
ATOM   1081  CH2 TRP   161     -18.369  11.986  24.824  1.00 38.15           C  
ATOM   1082  N   ARG   162     -16.759   9.632  18.381  1.00 36.30           N  
ATOM   1083  CA  ARG   162     -17.405  10.495  17.383  1.00 36.65           C  
ATOM   1084  C   ARG   162     -18.910  10.371  17.580  1.00 36.51           C  
ATOM   1085  O   ARG   162     -19.440   9.263  17.606  1.00 35.78           O  
ATOM   1086  CB  ARG   162     -17.036  10.123  15.944  1.00 36.17           C  
ATOM   1087  CG  ARG   162     -17.505  11.169  14.969  1.00 36.54           C  
ATOM   1088  CD  ARG   162     -16.821  11.107  13.626  1.00 36.00           C  
ATOM   1089  NE  ARG   162     -17.436  10.134  12.715  1.00 35.70           N  
ATOM   1090  CZ  ARG   162     -17.007   8.899  12.463  1.00 35.72           C  
ATOM   1091  NH1 ARG   162     -15.925   8.408  13.036  1.00 36.11           N  
ATOM   1092  NH2 ARG   162     -17.668   8.156  11.588  1.00 35.62           N  
ATOM   1093  N   ASN   163     -19.597  11.505  17.694  1.00 37.07           N  
ATOM   1094  CA  ASN   163     -21.015  11.459  18.004  1.00 38.11           C  
ATOM   1095  C   ASN   163     -21.908  11.453  16.780  1.00 39.76           C  
ATOM   1096  O   ASN   163     -21.410  11.428  15.668  1.00 40.47           O  
ATOM   1097  CB  ASN   163     -21.359  12.566  18.979  1.00 37.72           C  
ATOM   1098  CG  ASN   163     -21.269  13.932  18.358  1.00 37.22           C  
ATOM   1099  OD1 ASN   163     -21.160  14.070  17.146  1.00 38.13           O  
ATOM   1100  ND2 ASN   163     -21.356  14.949  19.185  1.00 37.50           N  
ATOM   1101  N   ALA   164     -23.226  11.443  16.989  1.00 41.32           N  
ATOM   1102  CA  ALA   164     -24.203  11.411  15.897  1.00 41.49           C  
ATOM   1103  C   ALA   164     -24.046  12.531  14.871  1.00 42.17           C  
ATOM   1104  O   ALA   164     -24.417  12.345  13.715  1.00 41.92           O  
ATOM   1105  CB  ALA   164     -25.641  11.401  16.471  1.00 42.29           C  
ATOM   1106  N   GLU   165     -23.515  13.682  15.289  1.00 42.49           N  
ATOM   1107  CA  GLU   165     -23.253  14.805  14.375  1.00 43.04           C  
ATOM   1108  C   GLU   165     -21.858  14.735  13.715  1.00 42.42           C  
ATOM   1109  O   GLU   165     -21.395  15.723  13.153  1.00 40.99           O  
ATOM   1110  CB  GLU   165     -23.353  16.131  15.123  1.00 43.93           C  
ATOM   1111  CG  GLU   165     -24.748  16.511  15.540  1.00 45.40           C  
ATOM   1112  CD  GLU   165     -24.763  17.805  16.346  1.00 46.25           C  
ATOM   1113  OE1 GLU   165     -24.250  17.781  17.504  1.00 47.45           O  
ATOM   1114  OE2 GLU   165     -25.300  18.828  15.826  1.00 47.05           O  
ATOM   1115  N   ASP   166     -21.201  13.579  13.808  1.00 40.89           N  
ATOM   1116  CA  ASP   166     -19.862  13.355  13.259  1.00 41.15           C  
ATOM   1117  C   ASP   166     -18.775  14.319  13.804  1.00 40.03           C  
ATOM   1118  O   ASP   166     -17.812  14.628  13.100  1.00 38.42           O  
ATOM   1119  CB  ASP   166     -19.876  13.307  11.704  1.00 41.47           C  
ATOM   1120  CG  ASP   166     -20.427  11.982  11.143  1.00 41.09           C  
ATOM   1121  OD1 ASP   166     -20.142  10.911  11.701  1.00 40.80           O  
ATOM   1122  OD2 ASP   166     -21.117  12.003  10.101  1.00 41.82           O  
ATOM   1123  N   ASP   167     -18.934  14.767  15.057  1.00 40.27           N  
ATOM   1124  CA  ASP   167     -17.931  15.619  15.742  1.00 40.57           C  
ATOM   1125  C   ASP   167     -17.164  14.774  16.756  1.00 39.01           C  
ATOM   1126  O   ASP   167     -17.783  13.962  17.449  1.00 39.31           O  
ATOM   1127  CB  ASP   167     -18.599  16.781  16.492  1.00 41.60           C  
ATOM   1128  CG  ASP   167     -19.185  17.828  15.566  1.00 42.34           C  
ATOM   1129  OD1 ASP   167     -18.468  18.360  14.701  1.00 43.82           O  
ATOM   1130  OD2 ASP   167     -20.363  18.165  15.743  1.00 44.30           O  
ATOM   1131  N   VAL   168     -15.838  14.958  16.829  1.00 36.76           N  
ATOM   1132  CA  VAL   168     -15.006  14.240  17.789  1.00 35.36           C  
ATOM   1133  C   VAL   168     -15.226  14.869  19.171  1.00 35.50           C  
ATOM   1134  O   VAL   168     -15.207  16.106  19.342  1.00 32.60           O  
ATOM   1135  CB  VAL   168     -13.510  14.245  17.431  1.00 35.37           C  
ATOM   1136  CG1 VAL   168     -12.719  13.431  18.436  1.00 35.65           C  
ATOM   1137  CG2 VAL   168     -13.292  13.682  16.052  1.00 35.05           C  
ATOM   1138  N   MET   169     -15.476  14.008  20.146  1.00 33.94           N  
ATOM   1139  CA  MET   169     -15.734  14.428  21.512  1.00 33.79           C  
ATOM   1140  C   MET   169     -14.858  13.600  22.453  1.00 34.81           C  
ATOM   1141  O   MET   169     -14.458  12.471  22.130  1.00 30.90           O  
ATOM   1142  CB  MET   169     -17.201  14.148  21.890  1.00 34.13           C  
ATOM   1143  CG  MET   169     -18.291  14.595  20.964  1.00 33.48           C  
ATOM   1144  SD  MET   169     -18.437  16.527  20.858  0.75 37.47          SE  
ATOM   1145  CE  MET   169     -19.112  16.847  22.681  1.00 31.68           C  
ATOM   1146  N   TYR   170     -14.569  14.167  23.618  1.00 35.79           N  
ATOM   1147  CA  TYR   170     -13.835  13.455  24.636  1.00 36.09           C  
ATOM   1148  C   TYR   170     -14.502  13.833  25.959  1.00 37.22           C  
ATOM   1149  O   TYR   170     -15.080  14.917  26.071  1.00 34.89           O  
ATOM   1150  CB  TYR   170     -12.317  13.783  24.601  1.00 36.65           C  
ATOM   1151  CG  TYR   170     -11.885  15.201  24.997  1.00 37.32           C  
ATOM   1152  CD1 TYR   170     -11.850  15.587  26.339  1.00 38.17           C  
ATOM   1153  CD2 TYR   170     -11.444  16.128  24.041  1.00 36.93           C  
ATOM   1154  CE1 TYR   170     -11.448  16.895  26.731  1.00 36.83           C  
ATOM   1155  CE2 TYR   170     -11.027  17.440  24.427  1.00 37.45           C  
ATOM   1156  CZ  TYR   170     -11.037  17.798  25.777  1.00 37.46           C  
ATOM   1157  OH  TYR   170     -10.647  19.065  26.197  1.00 37.82           O  
ATOM   1158  N   GLN   171     -14.427  12.950  26.952  1.00 36.97           N  
ATOM   1159  CA  GLN   171     -14.931  13.264  28.302  1.00 38.53           C  
ATOM   1160  C   GLN   171     -14.247  12.413  29.334  1.00 36.99           C  
ATOM   1161  O   GLN   171     -13.814  11.296  29.038  1.00 37.34           O  
ATOM   1162  CB  GLN   171     -16.450  13.039  28.429  1.00 39.94           C  
ATOM   1163  CG  GLN   171     -16.874  11.573  28.480  1.00 41.08           C  
ATOM   1164  CD  GLN   171     -18.399  11.383  28.609  1.00 42.57           C  
ATOM   1165  OE1 GLN   171     -19.202  12.314  28.348  1.00 45.34           O  
ATOM   1166  NE2 GLN   171     -18.801  10.179  29.008  1.00 44.67           N  
ATOM   1167  N   THR   172     -14.187  12.906  30.567  1.00 35.94           N  
ATOM   1168  CA  THR   172     -13.585  12.134  31.649  0.50 35.77           C  
ATOM   1170  C   THR   172     -14.403  10.853  31.826  1.00 35.48           C  
ATOM   1171  O   THR   172     -15.610  10.851  31.681  1.00 34.08           O  
ATOM   1172  CB  THR   172     -13.508  12.937  32.961  0.50 35.97           C  
ATOM   1174  OG1 THR   172     -14.832  13.263  33.407  0.50 36.62           O  
ATOM   1176  CG2 THR   172     -12.703  14.212  32.757  0.50 35.21           C  
ATOM   1178  N   LEU   173     -13.723   9.749  32.094  1.00 37.16           N  
ATOM   1179  CA  LEU   173     -14.361   8.480  32.248  1.00 38.77           C  
ATOM   1180  C   LEU   173     -14.133   8.031  33.687  1.00 41.89           C  
ATOM   1181  O   LEU   173     -12.973   7.958  34.150  1.00 42.80           O  
ATOM   1182  CB  LEU   173     -13.715   7.490  31.288  1.00 38.76           C  
ATOM   1183  CG  LEU   173     -14.480   6.251  30.833  1.00 38.66           C  
ATOM   1184  CD1 LEU   173     -15.783   6.646  30.191  1.00 36.48           C  
ATOM   1185  CD2 LEU   173     -13.607   5.482  29.866  1.00 37.79           C  
ATOM   1186  N   ASP   174     -15.226   7.774  34.412  1.00 43.53           N  
ATOM   1187  CA  ASP   174     -15.114   7.254  35.771  1.00 44.88           C  
ATOM   1188  C   ASP   174     -14.975   5.716  35.690  1.00 44.13           C  
ATOM   1189  O   ASP   174     -15.195   5.120  34.639  1.00 42.26           O  
ATOM   1190  CB  ASP   174     -16.253   7.760  36.706  1.00 45.97           C  
ATOM   1191  CG  ASP   174     -17.658   7.312  36.286  1.00 46.82           C  
ATOM   1192  OD1 ASP   174     -17.829   6.394  35.462  1.00 48.80           O  
ATOM   1193  OD2 ASP   174     -18.629   7.886  36.815  1.00 47.87           O  
ATOM   1194  N   GLY   175     -14.578   5.100  36.798  1.00 45.15           N  
ATOM   1195  CA  GLY   175     -14.337   3.644  36.858  1.00 46.19           C  
ATOM   1196  C   GLY   175     -15.469   2.691  36.490  1.00 46.07           C  
ATOM   1197  O   GLY   175     -15.213   1.631  35.921  1.00 44.48           O  
ATOM   1198  N   PHE   176     -16.705   3.029  36.858  1.00 47.77           N  
ATOM   1199  CA  PHE   176     -17.872   2.181  36.511  1.00 48.38           C  
ATOM   1200  C   PHE   176     -18.038   2.124  34.998  1.00 46.08           C  
ATOM   1201  O   PHE   176     -18.206   1.055  34.422  1.00 44.30           O  
ATOM   1202  CB  PHE   176     -19.184   2.741  37.104  1.00 50.64           C  
ATOM   1203  CG  PHE   176     -20.358   1.787  36.991  1.00 50.93           C  
ATOM   1204  CD1 PHE   176     -21.063   1.663  35.793  1.00 51.81           C  
ATOM   1205  CD2 PHE   176     -20.744   1.003  38.074  1.00 51.75           C  
ATOM   1206  CE1 PHE   176     -22.127   0.782  35.684  1.00 52.34           C  
ATOM   1207  CE2 PHE   176     -21.813   0.120  37.978  1.00 51.91           C  
ATOM   1208  CZ  PHE   176     -22.501   0.006  36.786  1.00 52.07           C  
ATOM   1209  N   ASP   177     -18.030   3.316  34.402  1.00 43.78           N  
ATOM   1210  CA  ASP   177     -18.138   3.506  32.961  1.00 42.31           C  
ATOM   1211  C   ASP   177     -17.038   2.803  32.187  1.00 40.47           C  
ATOM   1212  O   ASP   177     -17.315   2.124  31.183  1.00 38.92           O  
ATOM   1213  CB  ASP   177     -18.098   5.006  32.652  1.00 42.66           C  
ATOM   1214  CG  ASP   177     -19.338   5.708  33.107  1.00 43.24           C  
ATOM   1215  OD1 ASP   177     -20.192   5.039  33.727  1.00 43.85           O  
ATOM   1216  OD2 ASP   177     -19.479   6.910  32.810  1.00 42.81           O  
ATOM   1217  N   MET   178     -15.798   2.949  32.656  1.00 39.39           N  
ATOM   1218  CA  MET   178     -14.663   2.298  32.000  1.00 40.64           C  
ATOM   1219  C   MET   178     -14.869   0.766  31.995  1.00 40.74           C  
ATOM   1220  O   MET   178     -14.648   0.085  30.975  1.00 41.40           O  
ATOM   1221  CB  MET   178     -13.345   2.681  32.690  1.00 40.52           C  
ATOM   1222  CG  MET   178     -12.078   2.251  31.974  1.00 41.29           C  
ATOM   1223  SD  MET   178     -10.453   2.665  33.068  0.75 42.72          SE  
ATOM   1224  CE  MET   178     -10.429   4.544  32.789  1.00 41.52           C  
ATOM   1225  N   MET   179     -15.315   0.256  33.124  1.00 41.35           N  
ATOM   1226  CA  MET   179     -15.556  -1.178  33.300  1.00 43.56           C  
ATOM   1227  C   MET   179     -16.640  -1.689  32.352  1.00 41.60           C  
ATOM   1228  O   MET   179     -16.456  -2.675  31.679  1.00 41.85           O  
ATOM   1229  CB  MET   179     -15.942  -1.460  34.764  1.00 44.08           C  
ATOM   1230  CG  MET   179     -16.440  -2.879  35.053  1.00 45.36           C  
ATOM   1231  SD  MET   179     -16.813  -3.096  36.947  0.75 47.94          SE  
ATOM   1232  CE  MET   179     -14.922  -3.086  37.444  1.00 47.55           C  
ATOM   1233  N   LEU   180     -17.770  -1.002  32.329  1.00 41.88           N  
ATOM   1234  CA  LEU   180     -18.876  -1.351  31.456  1.00 41.24           C  
ATOM   1235  C   LEU   180     -18.467  -1.298  29.978  1.00 41.06           C  
ATOM   1236  O   LEU   180     -18.760  -2.229  29.222  1.00 41.65           O  
ATOM   1237  CB  LEU   180     -20.062  -0.411  31.683  1.00 42.02           C  
ATOM   1238  CG  LEU   180     -21.271  -0.875  30.862  1.00 42.92           C  
ATOM   1239  CD1 LEU   180     -21.695  -2.288  31.332  1.00 42.64           C  
ATOM   1240  CD2 LEU   180     -22.429   0.094  30.902  1.00 41.63           C  
ATOM   1241  N   LEU   181     -17.805  -0.223  29.543  1.00 39.70           N  
ATOM   1242  CA  LEU   181     -17.411  -0.135  28.130  1.00 38.32           C  
ATOM   1243  C   LEU   181     -16.451  -1.246  27.773  1.00 38.31           C  
ATOM   1244  O   LEU   181     -16.532  -1.782  26.686  1.00 36.05           O  
ATOM   1245  CB  LEU   181     -16.762   1.183  27.782  1.00 38.28           C  
ATOM   1246  CG  LEU   181     -17.665   2.399  27.911  1.00 36.54           C  
ATOM   1247  CD1 LEU   181     -16.873   3.622  27.735  1.00 37.18           C  
ATOM   1248  CD2 LEU   181     -18.810   2.275  26.897  1.00 36.99           C  
ATOM   1249  N   GLU   182     -15.512  -1.535  28.669  1.00 38.51           N  
ATOM   1250  CA  GLU   182     -14.522  -2.609  28.446  1.00 40.12           C  
ATOM   1251  C   GLU   182     -15.173  -3.999  28.354  1.00 38.77           C  
ATOM   1252  O   GLU   182     -14.787  -4.833  27.514  1.00 41.22           O  
ATOM   1253  CB  GLU   182     -13.507  -2.634  29.591  1.00 41.80           C  
ATOM   1254  CG  GLU   182     -12.290  -3.511  29.311  1.00 42.74           C  
ATOM   1255  CD  GLU   182     -11.361  -2.891  28.303  1.00 43.71           C  
ATOM   1256  OE1 GLU   182     -11.405  -1.639  28.138  1.00 44.55           O  
ATOM   1257  OE2 GLU   182     -10.564  -3.644  27.703  1.00 44.05           O  
ATOM   1258  N   ILE   183     -16.106  -4.252  29.273  1.00 37.91           N  
ATOM   1259  CA  ILE   183     -16.902  -5.493  29.336  1.00 37.16           C  
ATOM   1260  C   ILE   183     -17.745  -5.546  28.049  1.00 36.31           C  
ATOM   1261  O   ILE   183     -17.742  -6.521  27.329  1.00 35.36           O  
ATOM   1262  CB  ILE   183     -17.828  -5.442  30.587  1.00 37.12           C  
ATOM   1263  CG1 ILE   183     -17.063  -5.750  31.869  1.00 36.95           C  
ATOM   1264  CG2 ILE   183     -19.031  -6.343  30.458  1.00 38.23           C  
ATOM   1265  CD1 ILE   183     -17.942  -5.655  33.137  1.00 37.12           C  
ATOM   1266  N   MET   184     -18.440  -4.454  27.744  1.00 35.71           N  
ATOM   1267  CA  MET   184     -19.238  -4.380  26.526  1.00 34.96           C  
ATOM   1268  C   MET   184     -18.418  -4.586  25.249  1.00 35.85           C  
ATOM   1269  O   MET   184     -18.939  -5.122  24.265  1.00 36.27           O  
ATOM   1270  CB  MET   184     -20.033  -3.085  26.446  1.00 33.23           C  
ATOM   1271  CG  MET   184     -21.222  -3.019  27.395  1.00 31.28           C  
ATOM   1272  SD  MET   184     -22.000  -1.323  27.109  0.75 33.38          SE  
ATOM   1273  CE  MET   184     -22.939  -1.763  25.378  1.00 31.32           C  
ATOM   1274  N   GLY   185     -17.148  -4.197  25.274  1.00 34.94           N  
ATOM   1275  CA  GLY   185     -16.274  -4.433  24.146  1.00 35.89           C  
ATOM   1276  C   GLY   185     -15.982  -5.923  24.017  1.00 37.67           C  
ATOM   1277  O   GLY   185     -15.725  -6.435  22.910  1.00 38.56           O  
ATOM   1278  N   SER   186     -16.026  -6.632  25.144  1.00 38.48           N  
ATOM   1279  CA  SER   186     -15.778  -8.080  25.147  1.00 39.76           C  
ATOM   1280  C   SER   186     -16.968  -8.860  24.587  1.00 40.37           C  
ATOM   1281  O   SER   186     -16.806  -9.865  23.877  1.00 40.00           O  
ATOM   1282  CB  SER   186     -15.495  -8.592  26.570  1.00 39.79           C  
ATOM   1283  OG  SER   186     -14.333  -8.012  27.134  1.00 39.83           O  
ATOM   1284  N   SER   187     -18.167  -8.445  24.965  1.00 40.53           N  
ATOM   1285  CA  SER   187     -19.350  -9.129  24.488  1.00 41.39           C  
ATOM   1286  C   SER   187     -20.579  -8.234  24.546  1.00 40.22           C  
ATOM   1287  O   SER   187     -20.978  -7.820  25.624  1.00 40.70           O  
ATOM   1288  CB  SER   187     -19.578 -10.406  25.298  1.00 42.49           C  
ATOM   1289  OG  SER   187     -19.582 -10.126  26.684  1.00 44.00           O  
ATOM   1290  N   ALA   188     -21.157  -7.973  23.372  1.00 38.68           N  
ATOM   1291  CA  ALA   188     -22.369  -7.193  23.207  1.00 38.36           C  
ATOM   1292  C   ALA   188     -23.358  -7.535  24.313  1.00 37.68           C  
ATOM   1293  O   ALA   188     -23.562  -8.701  24.646  1.00 39.44           O  
ATOM   1294  CB  ALA   188     -22.978  -7.454  21.840  1.00 36.97           C  
ATOM   1295  N   LEU   189     -23.989  -6.506  24.834  1.00 37.15           N  
ATOM   1296  CA  LEU   189     -24.850  -6.570  26.003  1.00 38.47           C  
ATOM   1297  C   LEU   189     -26.162  -5.759  25.830  1.00 37.16           C  
ATOM   1298  O   LEU   189     -26.156  -4.703  25.248  1.00 37.13           O  
ATOM   1299  CB  LEU   189     -24.006  -5.922  27.127  1.00 38.77           C  
ATOM   1300  CG  LEU   189     -24.536  -5.584  28.514  1.00 40.39           C  
ATOM   1301  CD1 LEU   189     -24.419  -6.807  29.417  1.00 41.44           C  
ATOM   1302  CD2 LEU   189     -23.760  -4.419  29.132  1.00 40.31           C  
ATOM   1303  N   SER   190     -27.282  -6.254  26.331  1.00 37.95           N  
ATOM   1304  CA  SER   190     -28.518  -5.453  26.348  1.00 37.69           C  
ATOM   1305  C   SER   190     -28.605  -4.730  27.687  1.00 36.73           C  
ATOM   1306  O   SER   190     -27.894  -5.081  28.625  1.00 33.55           O  
ATOM   1307  CB  SER   190     -29.771  -6.342  26.171  1.00 37.26           C  
ATOM   1308  OG  SER   190     -30.007  -7.182  27.293  1.00 35.50           O  
ATOM   1309  N   PHE   191     -29.451  -3.695  27.775  1.00 38.21           N  
ATOM   1310  CA  PHE   191     -29.691  -3.038  29.055  1.00 36.68           C  
ATOM   1311  C   PHE   191     -30.306  -4.054  30.014  1.00 36.63           C  
ATOM   1312  O   PHE   191     -29.943  -4.074  31.177  1.00 36.15           O  
ATOM   1313  CB  PHE   191     -30.633  -1.846  28.929  1.00 37.61           C  
ATOM   1314  CG  PHE   191     -30.909  -1.152  30.230  1.00 37.73           C  
ATOM   1315  CD1 PHE   191     -29.970  -0.294  30.788  1.00 38.70           C  
ATOM   1316  CD2 PHE   191     -32.107  -1.347  30.903  1.00 38.74           C  
ATOM   1317  CE1 PHE   191     -30.217   0.351  31.989  1.00 37.92           C  
ATOM   1318  CE2 PHE   191     -32.360  -0.703  32.102  1.00 37.90           C  
ATOM   1319  CZ  PHE   191     -31.407   0.148  32.643  1.00 38.10           C  
ATOM   1320  N   ASP   192     -31.220  -4.911  29.537  1.00 36.19           N  
ATOM   1321  CA  ASP   192     -31.854  -5.864  30.429  1.00 35.73           C  
ATOM   1322  C   ASP   192     -30.837  -6.798  31.035  1.00 34.04           C  
ATOM   1323  O   ASP   192     -30.936  -7.099  32.218  1.00 31.85           O  
ATOM   1324  CB  ASP   192     -32.991  -6.668  29.769  1.00 36.97           C  
ATOM   1325  CG  ASP   192     -34.241  -5.818  29.511  1.00 37.83           C  
ATOM   1326  OD1 ASP   192     -34.239  -4.589  29.827  1.00 36.14           O  
ATOM   1327  OD2 ASP   192     -35.215  -6.396  28.968  1.00 37.83           O  
ATOM   1328  N   THR   193     -29.882  -7.251  30.228  1.00 33.57           N  
ATOM   1329  CA  THR   193     -28.784  -8.108  30.701  1.00 33.05           C  
ATOM   1330  C   THR   193     -27.885  -7.293  31.674  1.00 33.22           C  
ATOM   1331  O   THR   193     -27.553  -7.752  32.763  1.00 32.46           O  
ATOM   1332  CB  THR   193     -27.951  -8.657  29.516  1.00 33.39           C  
ATOM   1333  OG1 THR   193     -28.748  -9.558  28.714  1.00 32.30           O  
ATOM   1334  CG2 THR   193     -26.703  -9.397  29.999  1.00 32.95           C  
ATOM   1335  N   LEU   194     -27.530  -6.061  31.321  1.00 33.14           N  
ATOM   1336  CA  LEU   194     -26.707  -5.264  32.232  1.00 32.74           C  
ATOM   1337  C   LEU   194     -27.412  -5.148  33.579  1.00 34.32           C  
ATOM   1338  O   LEU   194     -26.905  -5.610  34.606  1.00 34.58           O  
ATOM   1339  CB  LEU   194     -26.451  -3.866  31.655  1.00 33.10           C  
ATOM   1340  CG  LEU   194     -25.699  -2.841  32.508  1.00 32.84           C  
ATOM   1341  CD1 LEU   194     -24.341  -3.367  32.928  1.00 32.94           C  
ATOM   1342  CD2 LEU   194     -25.598  -1.508  31.737  1.00 32.98           C  
ATOM   1343  N   ALA   195     -28.597  -4.546  33.576  1.00 35.92           N  
ATOM   1344  CA  ALA   195     -29.320  -4.299  34.825  1.00 37.64           C  
ATOM   1345  C   ALA   195     -29.554  -5.561  35.667  1.00 37.88           C  
ATOM   1346  O   ALA   195     -29.464  -5.514  36.880  1.00 40.48           O  
ATOM   1347  CB  ALA   195     -30.639  -3.534  34.551  1.00 36.84           C  
ATOM   1348  N   GLN   196     -29.800  -6.697  35.042  1.00 39.20           N  
ATOM   1349  CA  GLN   196     -30.019  -7.934  35.786  1.00 39.69           C  
ATOM   1350  C   GLN   196     -28.737  -8.493  36.437  1.00 40.33           C  
ATOM   1351  O   GLN   196     -28.802  -9.184  37.470  1.00 41.04           O  
ATOM   1352  CB  GLN   196     -30.624  -9.008  34.858  1.00 40.42           C  
ATOM   1353  CG  GLN   196     -30.778 -10.420  35.472  1.00 40.58           C  
ATOM   1354  CD  GLN   196     -31.645 -10.452  36.735  1.00 41.73           C  
ATOM   1355  OE1 GLN   196     -32.548  -9.633  36.907  1.00 43.88           O  
ATOM   1356  NE2 GLN   196     -31.391 -11.423  37.606  1.00 41.67           N  
ATOM   1357  N   THR   197     -27.588  -8.255  35.810  1.00 38.92           N  
ATOM   1358  CA  THR   197     -26.328  -8.785  36.321  1.00 37.94           C  
ATOM   1359  C   THR   197     -25.937  -8.023  37.571  1.00 36.70           C  
ATOM   1360  O   THR   197     -25.409  -8.630  38.485  1.00 35.53           O  
ATOM   1361  CB  THR   197     -25.192  -8.642  35.280  1.00 39.04           C  
ATOM   1362  OG1 THR   197     -25.568  -9.302  34.071  1.00 39.48           O  
ATOM   1363  CG2 THR   197     -23.883  -9.235  35.804  1.00 39.19           C  
ATOM   1364  N   LEU   198     -26.194  -6.700  37.581  1.00 33.17           N  
ATOM   1365  CA  LEU   198     -25.887  -5.832  38.711  1.00 33.38           C  
ATOM   1366  C   LEU   198     -26.846  -5.943  39.894  1.00 34.22           C  
ATOM   1367  O   LEU   198     -26.519  -5.510  41.000  1.00 33.03           O  
ATOM   1368  CB  LEU   198     -25.853  -4.354  38.276  1.00 32.60           C  
ATOM   1369  CG  LEU   198     -24.821  -3.832  37.292  1.00 32.72           C  
ATOM   1370  CD1 LEU   198     -25.148  -2.360  36.810  1.00 29.29           C  
ATOM   1371  CD2 LEU   198     -23.429  -3.896  37.907  1.00 33.12           C  
ATOM   1372  N   VAL   199     -28.022  -6.522  39.683  1.00 36.58           N  
ATOM   1373  CA  VAL   199     -29.008  -6.681  40.750  1.00 37.54           C  
ATOM   1374  C   VAL   199     -28.443  -7.249  42.050  1.00 39.42           C  
ATOM   1375  O   VAL   199     -28.828  -6.816  43.151  1.00 39.34           O  
ATOM   1376  CB  VAL   199     -30.224  -7.544  40.276  1.00 36.98           C  
ATOM   1377  CG1 VAL   199     -30.957  -8.122  41.434  1.00 35.71           C  
ATOM   1378  CG2 VAL   199     -31.155  -6.689  39.401  1.00 36.23           C  
ATOM   1379  N   GLU   200     -27.521  -8.200  41.945  1.00 41.22           N  
ATOM   1380  CA  GLU   200     -26.982  -8.823  43.150  1.00 42.00           C  
ATOM   1381  C   GLU   200     -25.916  -7.994  43.879  1.00 41.83           C  
ATOM   1382  O   GLU   200     -25.615  -8.261  45.037  1.00 42.68           O  
ATOM   1383  CB  GLU   200     -26.468 -10.245  42.873  1.00 42.76           C  
ATOM   1384  CG  GLU   200     -25.208 -10.396  42.009  1.00 42.85           C  
ATOM   1385  CD  GLU   200     -24.499 -11.743  42.272  1.00 43.32           C  
ATOM   1386  OE1 GLU   200     -24.374 -12.129  43.462  1.00 44.06           O  
ATOM   1387  OE2 GLU   200     -24.040 -12.401  41.308  1.00 43.24           O  
ATOM   1388  N   PHE   201     -25.351  -6.989  43.227  1.00 41.69           N  
ATOM   1389  CA  PHE   201     -24.333  -6.163  43.858  1.00 41.84           C  
ATOM   1390  C   PHE   201     -24.857  -4.766  44.149  1.00 41.15           C  
ATOM   1391  O   PHE   201     -24.074  -3.818  44.199  1.00 41.58           O  
ATOM   1392  CB  PHE   201     -23.119  -6.041  42.935  1.00 42.85           C  
ATOM   1393  CG  PHE   201     -22.711  -7.325  42.327  1.00 43.28           C  
ATOM   1394  CD1 PHE   201     -22.106  -8.313  43.106  1.00 43.38           C  
ATOM   1395  CD2 PHE   201     -22.944  -7.568  40.980  1.00 43.18           C  
ATOM   1396  CE1 PHE   201     -21.736  -9.526  42.544  1.00 43.77           C  
ATOM   1397  CE2 PHE   201     -22.571  -8.775  40.405  1.00 43.77           C  
ATOM   1398  CZ  PHE   201     -21.972  -9.757  41.185  1.00 43.34           C  
ATOM   1399  N   MET   202     -26.167  -4.644  44.337  1.00 39.31           N  
ATOM   1400  CA  MET   202     -26.809  -3.367  44.555  1.00 38.45           C  
ATOM   1401  C   MET   202     -27.879  -3.471  45.655  1.00 38.54           C  
ATOM   1402  O   MET   202     -28.298  -4.575  46.011  1.00 39.36           O  
ATOM   1403  CB  MET   202     -27.421  -2.925  43.232  1.00 38.67           C  
ATOM   1404  CG  MET   202     -26.387  -2.622  42.128  1.00 37.28           C  
ATOM   1405  SD  MET   202     -25.423  -0.969  42.396  0.75 37.93          SE  
ATOM   1406  CE  MET   202     -26.624   0.243  41.755  1.00 39.90           C  
ATOM   1407  N   PRO   203     -28.287  -2.338  46.245  1.00 37.65           N  
ATOM   1408  CA  PRO   203     -29.354  -2.368  47.264  1.00 38.20           C  
ATOM   1409  C   PRO   203     -30.669  -2.907  46.713  1.00 38.81           C  
ATOM   1410  O   PRO   203     -30.902  -2.803  45.508  1.00 39.63           O  
ATOM   1411  CB  PRO   203     -29.523  -0.895  47.649  1.00 37.58           C  
ATOM   1412  CG  PRO   203     -28.263  -0.263  47.275  1.00 37.55           C  
ATOM   1413  CD  PRO   203     -27.751  -0.990  46.059  1.00 37.28           C  
ATOM   1414  N   LYS   204     -31.508  -3.468  47.587  1.00 39.31           N  
ATOM   1415  CA  LYS   204     -32.810  -4.047  47.207  1.00 39.35           C  
ATOM   1416  C   LYS   204     -33.734  -3.053  46.477  1.00 39.72           C  
ATOM   1417  O   LYS   204     -34.442  -3.452  45.558  1.00 40.18           O  
ATOM   1418  CB  LYS   204     -33.521  -4.681  48.426  1.00 39.78           C  
ATOM   1419  N   ALA   205     -33.708  -1.778  46.879  1.00 38.98           N  
ATOM   1420  CA  ALA   205     -34.517  -0.728  46.255  1.00 38.75           C  
ATOM   1421  C   ALA   205     -33.930  -0.470  44.874  1.00 38.44           C  
ATOM   1422  O   ALA   205     -32.742  -0.128  44.749  1.00 37.86           O  
ATOM   1423  CB  ALA   205     -34.488   0.555  47.087  1.00 38.54           C  
ATOM   1424  N   ASP   206     -34.768  -0.614  43.846  1.00 37.50           N  
ATOM   1425  CA  ASP   206     -34.311  -0.545  42.470  1.00 35.82           C  
ATOM   1426  C   ASP   206     -34.325   0.809  41.811  1.00 32.28           C  
ATOM   1427  O   ASP   206     -34.361   0.864  40.607  1.00 31.31           O  
ATOM   1428  CB  ASP   206     -35.078  -1.551  41.596  1.00 38.60           C  
ATOM   1429  CG  ASP   206     -36.537  -1.153  41.345  1.00 40.47           C  
ATOM   1430  OD1 ASP   206     -36.912   0.028  41.591  1.00 39.42           O  
ATOM   1431  OD2 ASP   206     -37.295  -2.043  40.861  1.00 42.49           O  
ATOM   1432  N   ASN   207     -34.223   1.891  42.572  1.00 31.67           N  
ATOM   1433  CA  ASN   207     -34.119   3.245  41.978  1.00 30.34           C  
ATOM   1434  C   ASN   207     -32.881   3.443  41.059  1.00 32.22           C  
ATOM   1435  O   ASN   207     -32.851   4.328  40.140  1.00 32.13           O  
ATOM   1436  CB  ASN   207     -34.022   4.313  43.076  1.00 29.95           C  
ATOM   1437  CG  ASN   207     -35.200   4.302  44.057  1.00 28.77           C  
ATOM   1438  OD1 ASN   207     -35.559   3.275  44.609  1.00 29.54           O  
ATOM   1439  ND2 ASN   207     -35.755   5.465  44.307  1.00 27.36           N  
ATOM   1440  N   TRP   208     -31.817   2.694  41.364  1.00 32.69           N  
ATOM   1441  CA  TRP   208     -30.556   2.768  40.603  1.00 31.91           C  
ATOM   1442  C   TRP   208     -30.776   2.359  39.170  1.00 32.17           C  
ATOM   1443  O   TRP   208     -30.167   2.961  38.311  1.00 31.13           O  
ATOM   1444  CB  TRP   208     -29.448   1.923  41.247  1.00 32.15           C  
ATOM   1445  CG  TRP   208     -29.846   0.532  41.554  1.00 32.23           C  
ATOM   1446  CD1 TRP   208     -30.470   0.092  42.688  1.00 32.29           C  
ATOM   1447  CD2 TRP   208     -29.671  -0.626  40.718  1.00 32.46           C  
ATOM   1448  NE1 TRP   208     -30.690  -1.258  42.612  1.00 32.16           N  
ATOM   1449  CE2 TRP   208     -30.200  -1.727  41.418  1.00 32.61           C  
ATOM   1450  CE3 TRP   208     -29.107  -0.836  39.450  1.00 32.63           C  
ATOM   1451  CZ2 TRP   208     -30.182  -3.037  40.884  1.00 32.23           C  
ATOM   1452  CZ3 TRP   208     -29.099  -2.105  38.924  1.00 31.68           C  
ATOM   1453  CH2 TRP   208     -29.614  -3.200  39.643  1.00 31.68           C  
ATOM   1454  N   LYS   209     -31.621   1.339  38.918  1.00 33.06           N  
ATOM   1455  CA  LYS   209     -32.004   0.923  37.544  1.00 33.39           C  
ATOM   1456  C   LYS   209     -32.502   2.114  36.713  1.00 34.33           C  
ATOM   1457  O   LYS   209     -32.221   2.198  35.520  1.00 37.07           O  
ATOM   1458  CB  LYS   209     -33.085  -0.168  37.508  1.00 34.04           C  
ATOM   1459  CG  LYS   209     -32.646  -1.527  38.040  1.00 35.43           C  
ATOM   1460  CD  LYS   209     -33.611  -2.691  37.657  1.00 35.19           C  
ATOM   1461  CE  LYS   209     -33.276  -3.967  38.447  1.00 36.00           C  
ATOM   1462  NZ  LYS   209     -33.853  -5.242  37.838  1.00 36.60           N  
ATOM   1463  N   ASN   210     -33.244   3.027  37.304  1.00 34.51           N  
ATOM   1464  CA  ASN   210     -33.677   4.231  36.551  1.00 36.49           C  
ATOM   1465  C   ASN   210     -32.501   5.192  36.240  1.00 35.37           C  
ATOM   1466  O   ASN   210     -32.445   5.812  35.160  1.00 36.42           O  
ATOM   1467  CB  ASN   210     -34.839   4.942  37.274  1.00 37.19           C  
ATOM   1468  CG  ASN   210     -36.022   3.995  37.529  1.00 38.90           C  
ATOM   1469  OD1 ASN   210     -36.385   3.209  36.654  1.00 40.42           O  
ATOM   1470  ND2 ASN   210     -36.583   4.026  38.745  1.00 38.09           N  
ATOM   1471  N   ILE   211     -31.552   5.321  37.164  1.00 34.75           N  
ATOM   1472  CA  ILE   211     -30.402   6.196  36.933  1.00 34.72           C  
ATOM   1473  C   ILE   211     -29.506   5.618  35.844  1.00 33.48           C  
ATOM   1474  O   ILE   211     -28.947   6.352  35.002  1.00 29.16           O  
ATOM   1475  CB  ILE   211     -29.609   6.469  38.249  1.00 36.00           C  
ATOM   1476  CG1 ILE   211     -30.486   7.263  39.223  1.00 35.99           C  
ATOM   1477  CG2 ILE   211     -28.321   7.298  37.985  1.00 34.49           C  
ATOM   1478  CD1 ILE   211     -29.809   7.654  40.520  1.00 35.96           C  
ATOM   1479  N   LEU   212     -29.411   4.290  35.858  1.00 32.77           N  
ATOM   1480  CA  LEU   212     -28.597   3.560  34.949  1.00 33.23           C  
ATOM   1481  C   LEU   212     -29.152   3.659  33.546  1.00 34.91           C  
ATOM   1482  O   LEU   212     -28.404   3.863  32.587  1.00 34.20           O  
ATOM   1483  CB  LEU   212     -28.563   2.076  35.381  1.00 33.12           C  
ATOM   1484  CG  LEU   212     -27.602   1.182  34.612  1.00 33.09           C  
ATOM   1485  CD1 LEU   212     -26.133   1.627  34.822  1.00 31.85           C  
ATOM   1486  CD2 LEU   212     -27.801  -0.229  35.052  1.00 32.08           C  
ATOM   1487  N   LEU   213     -30.463   3.460  33.419  1.00 36.65           N  
ATOM   1488  CA  LEU   213     -31.106   3.532  32.112  1.00 37.15           C  
ATOM   1489  C   LEU   213     -30.851   4.917  31.550  1.00 36.30           C  
ATOM   1490  O   LEU   213     -30.586   5.053  30.373  1.00 36.77           O  
ATOM   1491  CB  LEU   213     -32.620   3.252  32.192  1.00 37.58           C  
ATOM   1492  CG  LEU   213     -33.371   3.435  30.867  1.00 36.80           C  
ATOM   1493  CD1 LEU   213     -32.675   2.648  29.761  1.00 36.19           C  
ATOM   1494  CD2 LEU   213     -34.842   3.031  31.016  1.00 36.87           C  
ATOM   1495  N   GLY   214     -30.914   5.934  32.394  1.00 36.15           N  
ATOM   1496  CA  GLY   214     -30.612   7.314  31.963  1.00 36.31           C  
ATOM   1497  C   GLY   214     -29.201   7.391  31.377  1.00 36.76           C  
ATOM   1498  O   GLY   214     -29.002   7.906  30.282  1.00 34.16           O  
ATOM   1499  N   LYS   215     -28.225   6.833  32.095  1.00 38.08           N  
ATOM   1500  CA  LYS   215     -26.839   6.832  31.623  1.00 39.02           C  
ATOM   1501  C   LYS   215     -26.714   6.102  30.291  1.00 38.67           C  
ATOM   1502  O   LYS   215     -26.045   6.582  29.393  1.00 40.02           O  
ATOM   1503  CB  LYS   215     -25.895   6.169  32.645  1.00 38.95           C  
ATOM   1504  CG  LYS   215     -24.460   6.012  32.121  1.00 40.11           C  
ATOM   1505  CD  LYS   215     -23.490   5.230  33.046  1.00 41.64           C  
ATOM   1506  CE  LYS   215     -23.872   3.752  33.214  1.00 42.33           C  
ATOM   1507  NZ  LYS   215     -24.217   3.083  31.907  1.00 42.80           N  
ATOM   1508  N   TRP   216     -27.320   4.911  30.213  1.00 38.44           N  
ATOM   1509  CA  TRP   216     -27.328   4.055  29.010  1.00 37.73           C  
ATOM   1510  C   TRP   216     -27.931   4.760  27.802  1.00 36.69           C  
ATOM   1511  O   TRP   216     -27.353   4.712  26.709  1.00 37.44           O  
ATOM   1512  CB  TRP   216     -28.109   2.800  29.321  1.00 37.33           C  
ATOM   1513  CG  TRP   216     -28.319   1.837  28.235  1.00 37.88           C  
ATOM   1514  CD1 TRP   216     -29.384   1.799  27.373  1.00 37.86           C  
ATOM   1515  CD2 TRP   216     -27.541   0.663  27.956  1.00 37.86           C  
ATOM   1516  NE1 TRP   216     -29.269   0.727  26.545  1.00 37.80           N  
ATOM   1517  CE2 TRP   216     -28.155   0.008  26.880  1.00 37.05           C  
ATOM   1518  CE3 TRP   216     -26.355   0.134  28.475  1.00 37.81           C  
ATOM   1519  CZ2 TRP   216     -27.627  -1.142  26.312  1.00 37.75           C  
ATOM   1520  CZ3 TRP   216     -25.836  -1.013  27.910  1.00 37.54           C  
ATOM   1521  CH2 TRP   216     -26.476  -1.650  26.857  1.00 37.69           C  
ATOM   1522  N   SER   217     -29.079   5.405  28.011  1.00 34.69           N  
ATOM   1523  CA  SER   217     -29.758   6.195  26.964  1.00 34.80           C  
ATOM   1524  C   SER   217     -28.914   7.353  26.456  1.00 34.06           C  
ATOM   1525  O   SER   217     -28.999   7.724  25.289  1.00 34.05           O  
ATOM   1526  CB  SER   217     -31.099   6.759  27.465  1.00 34.33           C  
ATOM   1527  OG  SER   217     -32.049   5.728  27.666  1.00 34.19           O  
ATOM   1528  N   GLY   218     -28.151   7.959  27.359  1.00 34.17           N  
ATOM   1529  CA  GLY   218     -27.270   9.076  27.018  1.00 33.98           C  
ATOM   1530  C   GLY   218     -26.109   8.619  26.147  1.00 33.23           C  
ATOM   1531  O   GLY   218     -25.666   9.331  25.281  1.00 32.30           O  
ATOM   1532  N   TRP   219     -25.619   7.404  26.391  1.00 33.89           N  
ATOM   1533  CA  TRP   219     -24.562   6.807  25.584  1.00 32.51           C  
ATOM   1534  C   TRP   219     -25.056   6.479  24.156  1.00 31.46           C  
ATOM   1535  O   TRP   219     -24.291   6.485  23.200  1.00 29.93           O  
ATOM   1536  CB  TRP   219     -24.075   5.544  26.315  1.00 34.90           C  
ATOM   1537  CG  TRP   219     -23.044   5.761  27.391  1.00 35.00           C  
ATOM   1538  CD1 TRP   219     -22.690   6.928  27.981  1.00 36.21           C  
ATOM   1539  CD2 TRP   219     -22.297   4.739  28.054  1.00 36.69           C  
ATOM   1540  NE1 TRP   219     -21.727   6.712  28.932  1.00 36.02           N  
ATOM   1541  CE2 TRP   219     -21.464   5.373  29.002  1.00 36.36           C  
ATOM   1542  CE3 TRP   219     -22.238   3.354  27.922  1.00 35.77           C  
ATOM   1543  CZ2 TRP   219     -20.568   4.665  29.819  1.00 36.18           C  
ATOM   1544  CZ3 TRP   219     -21.332   2.630  28.736  1.00 36.36           C  
ATOM   1545  CH2 TRP   219     -20.526   3.286  29.680  1.00 36.68           C  
ATOM   1546  N   ILE   220     -26.332   6.140  24.019  1.00 31.33           N  
ATOM   1547  CA  ILE   220     -26.941   5.905  22.713  1.00 31.05           C  
ATOM   1548  C   ILE   220     -27.082   7.237  21.940  1.00 33.15           C  
ATOM   1549  O   ILE   220     -26.722   7.330  20.755  1.00 32.49           O  
ATOM   1550  CB  ILE   220     -28.304   5.253  22.875  1.00 29.75           C  
ATOM   1551  CG1 ILE   220     -28.157   3.828  23.465  1.00 29.30           C  
ATOM   1552  CG2 ILE   220     -29.014   5.142  21.512  1.00 30.31           C  
ATOM   1553  CD1 ILE   220     -29.494   3.274  23.922  1.00 28.25           C  
ATOM   1554  N   GLU   221     -27.604   8.262  22.608  1.00 35.10           N  
ATOM   1555  CA  GLU   221     -27.741   9.611  21.989  1.00 35.33           C  
ATOM   1556  C   GLU   221     -26.379  10.186  21.502  1.00 36.09           C  
ATOM   1557  O   GLU   221     -26.283  10.752  20.409  1.00 37.21           O  
ATOM   1558  CB  GLU   221     -28.410  10.577  22.987  1.00 36.75           C  
ATOM   1559  CG  GLU   221     -28.923  11.952  22.398  1.00 38.27           C  
ATOM   1560  CD  GLU   221     -27.892  13.097  22.374  1.00 41.37           C  
ATOM   1561  OE1 GLU   221     -26.798  12.930  22.990  1.00 42.19           O  
ATOM   1562  OE2 GLU   221     -28.193  14.192  21.752  1.00 42.76           O  
ATOM   1563  N   GLN   222     -25.344  10.047  22.328  1.00 36.89           N  
ATOM   1564  CA  GLN   222     -23.983  10.545  22.027  1.00 36.28           C  
ATOM   1565  C   GLN   222     -23.212   9.642  21.077  1.00 34.50           C  
ATOM   1566  O   GLN   222     -22.091   9.950  20.718  1.00 31.88           O  
ATOM   1567  CB  GLN   222     -23.159  10.657  23.322  1.00 37.58           C  
ATOM   1568  CG  GLN   222     -23.716  11.611  24.368  1.00 39.28           C  
ATOM   1569  CD  GLN   222     -23.446  13.088  24.074  1.00 41.32           C  
ATOM   1570  OE1 GLN   222     -22.294  13.500  23.894  1.00 43.78           O  
ATOM   1571  NE2 GLN   222     -24.511  13.897  24.041  1.00 40.72           N  
ATOM   1572  N   ARG   223     -23.787   8.494  20.735  1.00 34.13           N  
ATOM   1573  CA  ARG   223     -23.179   7.523  19.831  1.00 33.61           C  
ATOM   1574  C   ARG   223     -21.917   6.873  20.400  1.00 34.35           C  
ATOM   1575  O   ARG   223     -20.949   6.632  19.654  1.00 35.88           O  
ATOM   1576  CB  ARG   223     -22.898   8.168  18.485  1.00 34.96           C  
ATOM   1577  CG  ARG   223     -22.824   7.244  17.284  1.00 35.66           C  
ATOM   1578  CD  ARG   223     -22.314   8.071  16.136  1.00 36.64           C  
ATOM   1579  NE  ARG   223     -22.460   7.421  14.851  1.00 36.77           N  
ATOM   1580  CZ  ARG   223     -22.173   8.005  13.695  1.00 37.14           C  
ATOM   1581  NH1 ARG   223     -21.712   9.244  13.648  1.00 37.54           N  
ATOM   1582  NH2 ARG   223     -22.356   7.338  12.565  1.00 38.08           N  
ATOM   1583  N   ILE   224     -21.926   6.592  21.712  1.00 32.16           N  
ATOM   1584  CA  ILE   224     -20.824   5.884  22.403  1.00 30.24           C  
ATOM   1585  C   ILE   224     -21.037   4.388  22.261  1.00 29.99           C  
ATOM   1586  O   ILE   224     -20.081   3.600  22.134  1.00 26.56           O  
ATOM   1587  CB  ILE   224     -20.757   6.269  23.908  1.00 29.79           C  
ATOM   1588  CG1 ILE   224     -20.396   7.761  24.076  1.00 29.73           C  
ATOM   1589  CG2 ILE   224     -19.763   5.447  24.614  1.00 30.17           C  
ATOM   1590  CD1 ILE   224     -20.563   8.314  25.494  1.00 29.42           C  
ATOM   1591  N   ILE   225     -22.312   3.986  22.300  1.00 30.18           N  
ATOM   1592  CA  ILE   225     -22.678   2.590  22.089  1.00 28.73           C  
ATOM   1593  C   ILE   225     -23.656   2.595  20.934  1.00 30.68           C  
ATOM   1594  O   ILE   225     -24.386   3.580  20.726  1.00 30.26           O  
ATOM   1595  CB  ILE   225     -23.200   1.918  23.379  1.00 28.42           C  
ATOM   1596  CG1 ILE   225     -24.620   2.348  23.737  1.00 26.99           C  
ATOM   1597  CG2 ILE   225     -22.217   2.217  24.514  1.00 29.60           C  
ATOM   1598  CD1 ILE   225     -25.110   1.976  25.113  1.00 26.01           C  
ATOM   1599  N   ILE   226     -23.642   1.506  20.155  1.00 30.62           N  
ATOM   1600  CA  ILE   226     -24.499   1.394  18.976  1.00 30.56           C  
ATOM   1601  C   ILE   226     -25.110   0.009  18.972  1.00 29.99           C  
ATOM   1602  O   ILE   226     -24.574  -0.883  19.606  1.00 28.78           O  
ATOM   1603  CB  ILE   226     -23.740   1.708  17.596  1.00 30.62           C  
ATOM   1604  CG1 ILE   226     -22.567   0.765  17.340  1.00 30.74           C  
ATOM   1605  CG2 ILE   226     -23.274   3.214  17.504  1.00 30.74           C  
ATOM   1606  CD1 ILE   226     -21.914   0.946  15.918  1.00 30.80           C  
ATOM   1607  N   PRO   227     -26.270  -0.161  18.317  1.00 30.20           N  
ATOM   1608  CA  PRO   227     -26.836  -1.526  18.246  1.00 30.62           C  
ATOM   1609  C   PRO   227     -25.852  -2.518  17.629  1.00 33.79           C  
ATOM   1610  O   PRO   227     -25.105  -2.175  16.706  1.00 32.59           O  
ATOM   1611  CB  PRO   227     -28.079  -1.360  17.373  1.00 29.34           C  
ATOM   1612  CG  PRO   227     -28.421   0.098  17.460  1.00 29.26           C  
ATOM   1613  CD  PRO   227     -27.145   0.845  17.691  1.00 29.25           C  
ATOM   1614  N   SER   228     -25.827  -3.722  18.183  1.00 37.62           N  
ATOM   1615  CA  SER   228     -24.979  -4.781  17.679  1.00 40.86           C  
ATOM   1616  C   SER   228     -25.762  -5.611  16.664  1.00 43.11           C  
ATOM   1617  O   SER   228     -26.490  -6.533  17.032  1.00 44.20           O  
ATOM   1618  CB  SER   228     -24.474  -5.666  18.812  1.00 40.76           C  
ATOM   1619  OG  SER   228     -23.551  -6.594  18.271  1.00 41.97           O  
ATOM   1620  N   LEU   229     -25.572  -5.292  15.386  1.00 45.83           N  
ATOM   1621  CA  LEU   229     -26.333  -5.890  14.290  1.00 47.76           C  
ATOM   1622  C   LEU   229     -25.604  -7.011  13.560  1.00 49.40           C  
ATOM   1623  O   LEU   229     -24.593  -6.779  12.910  1.00 49.60           O  
ATOM   1624  CB  LEU   229     -26.711  -4.786  13.289  1.00 47.66           C  
ATOM   1625  CG  LEU   229     -27.607  -3.690  13.883  1.00 47.20           C  
ATOM   1626  CD1 LEU   229     -27.754  -2.509  12.947  1.00 46.75           C  
ATOM   1627  CD2 LEU   229     -28.965  -4.279  14.249  1.00 47.53           C  
ATOM   1628  N   SER   230     -26.155  -8.220  13.659  1.00 51.73           N  
ATOM   1629  CA  SER   230     -25.586  -9.409  13.031  1.00 52.88           C  
ATOM   1630  C   SER   230     -26.236  -9.706  11.680  1.00 53.74           C  
ATOM   1631  O   SER   230     -25.565  -9.657  10.646  1.00 54.94           O  
ATOM   1632  CB  SER   230     -25.730 -10.610  13.970  1.00 52.98           C  
ATOM   1633  OG  SER   230     -25.042 -10.362  15.191  1.00 53.17           O  
END
